﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbo_vpl;
CREATE TABLE tbo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbo_vpl WRITE;
INSERT INTO tbo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Geka gilumana naka Yesu Keliso googana ubeihi, Yesu gogana Dawita ma Dawitana a goga i nenei naka Abelaham a guguni uyahinei. ");
INSERT INTO tbo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abelaham natuna Isako, ma Isako natuna Yakobo, ma Yakobo natunatuna Yuda walewalehina mitehi. ");
INSERT INTO tbo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda natunatuna Pelesi ma Dela, hinahi Tema. Pelesi natuna Esiloni, ma Esiloni natuna Lama, ");
INSERT INTO tbo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ma Lama natuna Amidana, ma Amidana natuna Nahasoni, ma Nahasoni natuna Salimoni, ");
INSERT INTO tbo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ma Salimoni natuna Bowasa. Bowasana hinana Lehaba, ma Bowasana agona Luti. Luti ma Bowasa natuhi Obedi, ma Obedi natuna Yese. ");
INSERT INTO tbo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese natuna Dawita, tauna tu wasawasa. Dawitana Ulaiya hiwapena i lawagi po natuhi Solomona hi guni. ");
INSERT INTO tbo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona natuna Lebom, ma Lebom natuna Abiya, ma Abiya natuna Esa. ");
INSERT INTO tbo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa natuna Yosepata, ma Yosepata natuna Yolam, ma Yolam natuna Usaya. ");
INSERT INTO tbo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya natuna Yotam, ma Yotam natuna Ahasa, ma Ahasa natuna Hesekaya. ");
INSERT INTO tbo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya natuna Manase, ma Manase natuna Amoni, ma Amoni natuna Yosaya. ");
INSERT INTO tbo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya natunatuna Yekonaya walewalehina mitehi, tauhi hai houga uyahina, ma mi Babiloni hi nei po mi Yudeya hi panipanihi po hi niyehi u Babiloni, po hi wihewahewa. ");
INSERT INTO tbo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hougana u Babiloni hi memae po Yekonaya natuna Satiyeli i guni, ma Satiyeli natuna Selubabe, ");
INSERT INTO tbo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ma Selubabe natuna Abiuda, ma Abiuda natuna Eliyakim, ma Eliyakim natuna Eso. ");
INSERT INTO tbo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso natuna Sadoka ma Sadoka natuna Ekim, ma Ekim natuna Eliuda. ");
INSERT INTO tbo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda natuna Eliyesa ma Eliyesa natuna Matani, ma Matani natuna Yakobo. ");
INSERT INTO tbo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo natuna Yosepa tauna agona gowana Maliya, po Maliyana uyahinei Yesu i guni po Yesuna hi wigowaya po hi pa, Besinana lawana. ");
INSERT INTO tbo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Apo Abelaham a houga uyahina ma ta hiyawi po ina nei Dawita a houga uyahina naka hapa magouhi 14. Ma Dawita a houga uyahina, ma ta hiyawi po ina nei po hi niniyehi u Babiloni hougana uyahina naka hapa magouhi 14. Ma hai mae Babiloni uyahinei ta hiyawi po ina nei Besinana lawana a houga guni uyahina naka hapa magouhi 14. ");
INSERT INTO tbo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Geka pitenana Yesu Keliso a houga wawala tahayana. Yesu hinana Maliya, ma guguhinina hewali gowana Yosepa uyahina hi bigeya, ma yohola ega hita meluwaga ma Maliya i koiba. Ma a koibana ma Alugo Woiyawa a wawala Maliya uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma agona Yosepa lawa dumadumaluna po ega ipa Maliya i koikoiba ina wiyahonena niyeya a lawa uyahihi, ma i nugohiyahiyawa po ipa ina wihinigigiyena gowadeya. ");
INSERT INTO tbo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosepa nugonugona i bagibagi po i eno hilage, ma Guyau a tu winoyanoya gehouna luboni uyahinei i paliweleya i pa, ‘Yosepa, Dawita gogana, ega una matomatouta Maliya i koikoiba binei, naka Alugo Woiyawa uyahinei, yaka kidahi ma agom una lawagi. ");
INSERT INTO tbo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Apo natuna olotona ina guni yaka una wigowaya Yesu, babana tauna apo a lawa hai apapoe uyahihiyei ina wiluyagohanihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ginouli geka hi gelegeleta matababahi ipa Guyau a bahapiko ina lugeleteya tu bahapiko odubona i bahebaheya pite i pa, ");
INSERT INTO tbo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Guguhini totopana apo ina koiba po natuna olotona ina guni yaka gowana hina hiyawi Imanuwela.’ Gowana a bui, Yaubada miteta. ");
INSERT INTO tbo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosepa ani eno uyahinei i eno towolo po Guyau a tu winoyanoya a baha i wotagoya po Maliya i lawagi. ");
INSERT INTO tbo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma Yosepa ega Maliya hinina ita wodadani a sigana i wigunaguna po tewelana i wigowaya po gowana Yesu. ");
INSERT INTO tbo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu a guni u Betelehem Yudeya u tuponana Heloda a houga wiwasawasa uyahina. Naka hougana uyahina tu hanahanapu hi nei tupo kaluwabugei po hi nae u Yelusalem, ");
INSERT INTO tbo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","po hi lubayada hi pa, ‘Meka mi Yudeya omi wasawasa wouna hi guni? Amaka to hanapugeya babana hoi tupo kaluwabu a wekiwekilala ubona i geleta po to galeya yaka to nei uyahina ipa to wotalagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hai baha wasawasa Heloda i noonoli po i nugohelele duma po gasi tanitaniwaga Yelusalem atapuhi hi nugohelele baha geka binei. ");
INSERT INTO tbo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ega yaka Heloda mi Yudeya hai tu witalaguyaba babadahi po lugagayo tanitaniwagahi i baha po hi’mboina gogona ma i lubayadehi i pa, ‘Meka hotana Besinana lawana hi guni?’ ");
INSERT INTO tbo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ega yaka hi paliweleya hi pa, ‘U Betelehem naka Yudeya meyageina gehouna, mei tu bahapiko gehouna a baha i bahebaheya i pa, ");
INSERT INTO tbo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betelehem meyageina apo meyagai baneina po wasawasana Yudeya dobuna atapuna uyahina apo una gelagonihi, babana uyahimgei mi Isalaela omi wasawasa apo ina geleta. Tauna u lawa omi tu galena itete.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ega yaka tu hanahanapu Heloda i otugena gowadehi po i lubayadehi i pa, ‘Meyanai a ubona i geleta po o galeya?’ ");
INSERT INTO tbo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tu hanahanapu hai wibaabani atapuna Heloda i noonoli po i kokoe, ma i paliwelehi i pa, ‘Ona nae u Betelehem po ona bihena imahiyeya po tewelana ona tuhagaya yaka ona gunawilena memi po ona paliweleu po apo tau a nae po a wotalagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wasawasa ponana hi nonoli ma hi’mhoe po hi nenae ma ubonana lolowa hoi tupo kaluwabu hi gagaleya u matahi i geleta po i gegae yaka hi wotagoya po tewelana anani mae i lidumaluya po uyahina hi geleta. ");
INSERT INTO tbo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hougana ubona hi galeya ma hi kaoha labatana. ");
INSERT INTO tbo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ma hi lui numa u hinena po tewelana hinana Maliya mitehi hi galehi, ma hi polou tewelana uyahina po hi wotalagiyeya. Ma hai ani’mbenena humahi hi hoenihi po tewelana uyahina hi hounihi naka gole ma mayau dimudimumuna talaguyaba binei ma wakatu dimudimumuna. ");
INSERT INTO tbo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma Yaubada luboniyei i guduhi po i pa, ‘Ega Heloda uyahina ona gunagunawilemi.’ Yaka tahaya tapunei hi gunawilena mehi po hi nae hai dobu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tu hanahanapu hi nenae ma uguwana Yosepa i eneno ma Guyau a tu winoyanoya yadei i geleta po eno luboniyei i paliweleya i pa, ‘Yosepa, una towolo po tewela hinana mitehi una lowogehi po ona nae u Isipita po noka hotanana ona memae a sigana a paliwelemi yaka apo ona gunawilemi. Omi lowo matababana Heloda tewela e bibiheya ipa ina lihilageni.’ ");
INSERT INTO tbo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ega yaka uguwana uyahina Yosepa i eno towolo po tewela hinana mitehi hi’mhoe po ipa hina nae u Isipita. ");
INSERT INTO tbo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","U Isipita hi memae a sigana Heloda i hilage ma apoma hi gunawilena mehi. Hai mae u Isipita ipa Guyau a baha ina lugeleteya tu bahapiko odubona i bahebaheya pite i pa, ‘Isipitagei natuwe a otugena meya.’ ");
INSERT INTO tbo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma Heloda tu hanahanapu i ototonihi po i otona awehi ma ega hita gunawilehi. Yaka i luyogigai po tu wigawiya i himilihi po hi nae Betelehem anani taniwagana atapuna uyahina po logaloga ololotohi hai bolima luwaga ma i hopuhopu hi laihilagenihi. Babana tu hanahanapu hai baha Heloda i nugonugotuhuya po ipa houga awai uyahina tewelana hi guni. ");
INSERT INTO tbo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Uyahinei tu bahapiko Yelemaya a bahapiko i limoineya i pa, ");
INSERT INTO tbo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Lama u dobuna tou bahabaha a nonoli wiyuwa ma diligwegwe i tou bahebahehi. Lahela a guguni ubeihi i tou ega emoemotana po lawa hina woidedeli babana logaloga hi hilage.’ ");
INSERT INTO tbo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Isipita hi memae ma Heloda i hilage, ma Guyau a tu winoyanoya i himili Yosepa uyahina po i paliweleya eno luboni uyahinei ");
INSERT INTO tbo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","i pa, ‘Yosepa, una towolo po tewela hinana mitehi una weluwinihi po ona gunawilena memi Isalaela, babana tewelana tu wigawiyena amaka i hilage.’ ");
INSERT INTO tbo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ega yaka Yosepa i towolo po tewela hinana mitehi i weluwinihi po hi gunawilena mehi Isalaela u tupona. ");
INSERT INTO tbo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hougana hi gunagunawilena mehi ma lawa tuwega hi paliwelehi hi pa, ‘Heloda amaka i hilage, ma natuna Akeliyo iyawena i peli po e tanitaniwaga mi Yudeya uyahita.’ Yaka Yosepa ega ita luhogaleya ipa ina nae Yudeya babana i matouta, ega yaka luboniyei nugotuhu i weleya po ipa ina nae Galili u tupona. ");
INSERT INTO tbo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ega yaka Nasaleta u dobuna hi mae. Hai mae Nasaleta ipa Guyau a bahapiko ina lugeleteya tu bahapiko odubona i bahebaheya pite i pa, ‘Tauna hi wigowaya po hi pa, lawa Nasaletagei.’ ");
INSERT INTO tbo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naka hougana uyahina Yoni tu wibapatiso i geleta Yudeya u balabalana po i lauguguya ");
INSERT INTO tbo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","i pa, ‘Ona nugobui, babana kikina ma Yaubada a taniwaga uyahita ina geleta po ina taniwageta.’ ");
INSERT INTO tbo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Geka bahana naka tu bahapiko odubona gowana Isaiya Yoni binei i ibaabani i pa, ‘Lawa gehouna hoi balabala yabayababa e iototu i pa, “Guyau a tahaya ona wononogogeya. A tahaya ona lidumaluhi.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoni a mae ega ita dewadewa babana a kaleko kamela apalana, ma a dagilolo gamogamo opina ma a yam madimadi ma tuwoya i ananihi. ");
INSERT INTO tbo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yoni hoi balabala i lauguguya ma Yelusalem tu miyehi po Yudeya meyageihi gehouhi po gasi Yodani u liyaliyana tu mae hi liya nae Yoni uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","po hai apapoe hi bahena geletehi ma Yoni i bapatisohi goila Yodani uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mei gasi Palisi lawahi po gasi Sadusi hai bolu gehouhi hi nae Yoni uyahina po ipa ina bapatisohi. Ma Yoni i galehi yaka i baha nae uyahihi i pa, ‘Taumi ani galenami mei mota, uyahinei Yaubada a luuyogigai iyetana ipa ona lowo haleya. ");
INSERT INTO tbo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tamogi ega emoemotami babana omi nugobui anona ega ota wogeletaya. ");
INSERT INTO tbo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma ega tunawami ona pa, “Gogiyai Abelaham,” naka ginouli yabayababa babana a paliwelemi Yaubada emoemotana po geka gaimahi ina dewahi po Abelaham googana. ");
INSERT INTO tbo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Geka hougana Yaubada ilama i wononogogeya ipa mayau u dedena ina taleya. Uyahinei ma mayau atapuna ega ita ugugo apo ina tala halehi po mayau alalatana uyahina in’ompugehi. ");
INSERT INTO tbo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","‘Apo ona nugobui yaka tau goilei a ibapatisomi. Ma lawa gehouna muliugei e nenei tauna i gelagoniu, ma tau ega u dewadewa awai po ipa apo a aehumahuma an’awali. Tau tu nugobui goilei a bapatisomi. Tauna muliugei e nenei apo Alugo Woiyawei po wipoya mei mayau alalatanei ina bapatisomi. ");
INSERT INTO tbo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anani luhapu hipana u nimana po aniani mei pegapega ina tuweluhi po a hanali u hinena ina tuupumi. Ma nudanudahi apo mayau alalata tuwetuweneina uyahina in’apuhi.’ ");
INSERT INTO tbo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Houga noka uyahina Yesu Galili tuponana i nehaleya po i nae Yoni uyahina, po ipa ina bapatisoya Yodani u goilana. ");
INSERT INTO tbo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yoni a wileta ipa Yesu ina paliguduya ega yaka i pa, ‘Tam emoemota dumam po una bapatisou ma iyowai po u nei uyahiu po ipa tau a bapatisom?’ ");
INSERT INTO tbo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Yesu a baha i wimiheya i pa, ‘Eega, geka hougana tam i linanam una wibapatisou, po Yaubada a dewadumaluna ta wotagoya.’ Ega yaka Yoni i palihalena meya po Yesu i wibapatisoya. ");
INSERT INTO tbo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma Yesu goila uyahinei i togotogo geleta ma yada i gunahoeya ma Yesu Yaubada Alugona i gagaleya mei bunebune ma i hopu mai po uyahina i yato. ");
INSERT INTO tbo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma pona yadei i hopu mai i pa, ‘Natuwe geka a luhogaleya, tauna binei a kaoha.’ ");
INSERT INTO tbo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Alugo Woiyawa Yesu i weluwaya po i niyeni hoi balabala yabayababa, ipa Tomodulele a ludadana ina wialoni. ");
INSERT INTO tbo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iyeta ma uguwa magouhi 40 ega aniani ita waya po u mulina am i hilage. ");
INSERT INTO tbo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma tu ludadana i geleta po i baha i pa, ‘Yesu, inapa tam Yaubada Natuna yaka geka gaimahi una baha po hina liyaniyanihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu a bahana i wimiheya i pa, ‘Yaubada a Buka u hinena giluma e memae i pa, “Lawa apega yaniyani tunawana uyahinei hina luyagohana. Ma baha Yaubada gamonei he nenei tauna lawa hai ani luyagohana.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ega yaka Tomodulele Yesu i niyeya Yelusalem, po numa dalabu baneina u moyana i houni ");
INSERT INTO tbo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ma i baha i pa, ‘Inapa tam Yaubada Natuna yaka una lupa hopu, matababana Yaubada a Buka u hinena i baheya i pa, “Yaubada a tu winoyanoya mi yadena apo ina baha po hina galena itetem, ma apo nimahiyei hina wohepam po apega hoi gaima aem una toneya.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu a bahana i wimiheya i pa, ‘Yaubada a Buka i bahena meya i pa, “Guyau om Yaubada ega una laudadani.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Houga gehouna Tomodulele Yesu iludadana meya po i giyeya oya baneina u tepana ma hipuli tupo wohepali ani taniwagahi po gapolahi Yesu i wiatatiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma i baha nae i pa, ‘Inapa una polou uyahiu po una wotalagiyeu, yaka ani taniwaga atapuna geka apo a welem.’ ");
INSERT INTO tbo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ega yaka Yesu i paliweleya i pa, ‘Tomodulele, una nehaleu. Yaubada a Buka u hinena i baheya i pa, “Guyau om Yaubada tam una wotalagae uyahina po tunawana una pupouleya.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ega yaka Tomodulele Yesu i nehaleya ma tu winoyanoya mi yadena hi nei po hi haguya. ");
INSERT INTO tbo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hougana Yesu tuwega i nonoli ipa Yoni amaka hi numa panipani po hoi numa panipani hi houni, yaka i gunawilena meya po i nae Nasaleta Galili u tuponana. ");
INSERT INTO tbo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma Nasaleta i nehaleya po i nae Kapaneum boga u liyaliyana po noka hotanana i memae, naka dobuna Sebuloni ma Napatali hai hipuli. ");
INSERT INTO tbo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","I nenae ipa Guyau a bahapiko ina lugeleteya tu bahapiko Isaiya i bahebaheya pite i pa, ");
INSERT INTO tbo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Sebuloni ma Napatali hai dobu boga u liyaliyana ma Yodani goilana u tuponei tauhi ega mi Yudeya hai dobu gowana Galili. ");
INSERT INTO tbo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Noka dobuna uyahina lawa hoi uguwa hi memae ma yayata baneina, uyahihi amaka i geleta po hi galeya ma tauhi hilage meyageina hi meliyaliyani po hi memae ma yayata uyahihi i lugeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Naka houganana Yesu a bagibagi i wiwawali po i guguya lawa uyahihi ma i ibaabani i pa, ‘Ona nugobui, babana kikina ma Yaubada a taniwaga uyahimi ina geleta po ina taniwagemi.’ ");
INSERT INTO tbo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iyeta gehouna Yesu Galili bogana liyaliyanei i nenae po tu ebaebaga luwaga i tuhagahi, tauhi hi ebebaga u boga. Gehouna gowana Simona tauna hi wigowaya po hi pa, Pita ma walehina gowana Andulu. ");
INSERT INTO tbo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ega yaka i otugehi i pa, ‘Ona wimulitagou po lawa ebagahi a wiatatiyemi.’ ");
INSERT INTO tbo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Naka hougana hai hagida hi nehalehi ma Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ma i tutunae po Sebedi natunatuna luwaga Yamesa ma a tewela Yoni i galehi tauhi hai hagida hi woononogogehi amahi mitehi hai wam uyahina. Ega yaka Yamesa walehina mitehi Yesu i otugehi. ");
INSERT INTO tbo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma hi wotowolo yagiyagina po amahi hoi wam ma hi nehaleya po Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili meyageina atapuna i wiwileya ma i guguya hai numa tapalolo uyahihi, ma tuwega dewadewana i atatiyeneya Yaubada a witaniwaga lawa uyahihi binei i paliweleneya ma lawa tootogohi i lauyawahihi totogo tapuna po tapuna uyahihiyei. ");
INSERT INTO tbo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesu noyana hi nohaya Siliya meyageina atapuna uyahihi, ega yaka tu tootogo gehouhi hi nei uyahina. Tauhi hai totogo hi lata duma po gasi hi witai duma, ma gehouhi gasi alugo apapoehi hi luinihi ma gehouhi wobadebadehi, ma gehouhi gasi waigwameyameyahi atapuhihi Yesu i widewadewahi. ");
INSERT INTO tbo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yesu a wipoya hi gagaleya po bolu baneina hi wotagoya, mi Galiliyena po mi Dekapoliyena po mi Yelusalem po mi Yudeya po gasi Yodani goilana tuponana tu miyena tauhi gasi hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu bolu baneina i galehi ma i gae hoi oya po i tugula ma a hewahewali hi gae uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma Yesu i wiwawala po uyahihi i wiatatiyana i ibaabani i pa, ");
INSERT INTO tbo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘Taumi iyawoi nawa nugonugomi o idayadayabugena mehi a kawaidewedewemi, babana yada taniwagana galimiyei. ");
INSERT INTO tbo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tu nugodubu lawami ona kaoha babana Yaubada apo ina likaoha dumami. ");
INSERT INTO tbo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Taumi iyawoi o palihalena memi ona kaoha, babana Yaubada hipuli a taniwaga atapuna apo ina welemi. ");
INSERT INTO tbo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Taumi iyawoi dewadumalu binei ma o weluweluomhilage po o weluweluuyopopo haleyana a kawaidewedewemi babana apo on’omhiyougo. ");
INSERT INTO tbo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tu lunugotootogo lawami ona kaoha, babana Yaubada apo ina lunugotootogogemi. ");
INSERT INTO tbo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tu nugoyeuyeu lawami ona kaoha, babana Yaubada apo ona galeya. ");
INSERT INTO tbo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tu wihaahalana lawami ona kaoha, babana Yaubada apo ina kawainatunemi. ");
INSERT INTO tbo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Taumi iyawoi apo dewadumalu binei ma lawa hina igawiyemi yaka ona kaoha, babana Yada taniwagana apo ina wigalimiyei. ");
INSERT INTO tbo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘Taumi iyawoi apo biugei ma lawa hina palipaliwiyalutugemi po hina igawiyemi po hina kawakawaikoyakoyamemi yaka ona kaoha labatana. ");
INSERT INTO tbo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ona kaoha po ona gwaugwauyala, babana hoi yada mihami apo ina lata duma. Geka pite apo lawa hina dewadewami mei lawa odubohi tu bahapiko hi laipilipilihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Taumi mei niha tu mehipuli ubeihi. Niha ginouli dewadewana ma dagihana ina kokoe ega emoemotana po ina dagiha meme yaka apo ta wihinigigiyeya po ta haleya. ");
INSERT INTO tbo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Taumi mei yayata tu mehipuli ubeihi, taumi mei meyagai oya u tepana po uguwei omi yayata lawa atapuhi hina gagalehi. ");
INSERT INTO tbo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ega iyai lampa ita apuya ma gaebagei ita lautataya, tamogi anani tugula uyahina e houni po numa hinena atapuna e yaayahi. ");
INSERT INTO tbo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Taumi tu mehipuli hai yayata yaka ipa omi yayata ona houna geletehi lawa magomagouhi u matahi po omi bagibagi dewadewahi lawa hina gagalehi, po Amami hoi yada lawa hina wotalagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Ega ona inugonugotuhu powa po ona pa, a nenei po apo Mose a lugagayo po tu bahapiko hai wiatatiyana a wihalehi. Ega naka pitenana, tau a nenei ipa lugagayo anohi a wogeletena imahiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A baha duma uyahimi, apo hipuli ma yada hina yababa ma lugagayo baneina ma u tipolina po habulu wahagana apega hina kokoe ma anohi hina geleta. ");
INSERT INTO tbo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Apo tam iyai lugagayo habulu hotana una tulagoni po lawa una wiatatiyena powahi, yaka Yaubada anani taniwaga uyahina apo gowam ina hopu duma, ma inapa taniwaga una wiponawogogeya po una iatatiyaneya yaka apo gowam ina lata duma Yaubada anani taniwaga u hinena. ");
INSERT INTO tbo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Palisi po lugagayo tanitaniwagahi lawa u matahi hi dumalu tamogi a paliwelemi apega Yaubada anani taniwaga uyahina hina lui babana hai dewa ega hita dewadewa. Inapa taumi ona luhogaleya Yaubada anani taniwaga uyahina ona lui yaka taumi omi dewa tauhi hai dewa ona dewadewa lagonihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Amaka ta hanapugeya lugagayo Yaubada googata i welehi ma i baheya ipa, “Ega ona yamunugo; apo iyai ina yamunugo yaka libahibahi apo ina wialoni.” ");
INSERT INTO tbo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Geka tau a palipaliwelemi apo tam iyai tulam uyahina uyom ina wogigai yaka apo tam libahibahi una wialoni. Ma tulam una hapohaponi yaka taniwaga witewiteina apo una tuhagaya tanitaniwaga uyahiyei. Apo tulam una kawakawaibuubuweni yaka mayau ebebalana una wialoni. ");
INSERT INTO tbo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Tam iyai om luhogala ipa om ani’mbenena una niyeya po Yaubada una weleya, ma u nugonugom ina lugeleteya ipa tulam gehouna a nugodubuna e memae om dewa binei, ");
INSERT INTO tbo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yaka dumadumaluna ipa om ani’mbenena una houni ani witalaguyaba u liyaliyana ma una gunawilena mem po tulam uyahina una lidumalu tahaya, ma apoma una gunawilena mem po om ani’mbenena una houni Yaubada u matana. ");
INSERT INTO tbo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Apo lawa gehouna ina wigoum po ona nae luhetala binei, yaka naka ipa dumalu ona waya po apapoe ona lidumaluya. Ma inapa ega yaka tu wigoum lawana apo ina niyem tu luhetala u nimana po ina houna luiyem hoi numa panipani. ");
INSERT INTO tbo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A baha duma uyahimi, noka hosi apo una memae a sigana om yaga atapuna una laidumaluya ina hopu po toea emosi uyahina una wikokowi.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Amaka ta hanapugeya lugagayo Yaubada googata i welehi, i baheya i pa, “Ega ona matamatamaga.” ");
INSERT INTO tbo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma geka tau a palipaliwelemi, apo lawa awai wawine gehouna uyahina ina luhogala gowagowada, yaka naka lawana amaka u nugonugona apapoe i geleta. ");
INSERT INTO tbo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ma apo mata hinebawam ina laipeunim yaka una wahi haleya, po ega hinim atapuna mayau ebebalana ina ialoni ma tamogi wiyuwa baneina gutam emosi hota binei apo una wialoni. ");
INSERT INTO tbo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mei gasi awala hinebawam apo ina laipeunim yaka una boli haleya po ega hinim atapuna mayau ebebalana ina ialoni ma tamogi wiyuwa baneina gutam emosi hota binei apo una wialoni.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Lugagayo gehouna Mose i gilugilumi i pa, “Apo lawa awai a luhogala ipa agona ina haleya yaka, a wihulu wekiwekilalana giluma gehouna ina gilumi po ina weleya ma apoma agona ina haleya.” ");
INSERT INTO tbo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma tau a paliwelemi, apo oloto gehouna agona ega ina wihola ma ina haleya, ma apoma wawinena ina nae po oloto tapuna ina lawagi naka e matamatamaga, uyahinei olotona i ihulu tauna a gou babana agona i lipeuya po i tawine damana. Mei gasi oloto gehouna apo ina nae po wawinena ina lawagi yaka naka e matamatamaga.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Lugagayo odubona amaka o hanapugeya hi baheya hi pa, “Apo una igwala yaka om bahana ega nugom ina guluguluwi ma awai Guyau uyahina u palipaliwitumaganeya una dewaya po ina lugeleteya.” ");
INSERT INTO tbo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma tau a paliwelemi ega ona igwala gae yada binei, matababana Yaubada anani mae. ");
INSERT INTO tbo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma a paliwelena memi ega hipuli binei ona igwala matababana Yaubada aena ani hounana. Ma ega Yelusalem ona igwaleya, matababana Wasawasa baneina tauna Yaubada a dobu. ");
INSERT INTO tbo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ega ununum una igwaleya babana geegeka, ega emoemotam una baha po apalam emosi ina wakeke bo una baha po ina wididibaleya, bo? ");
INSERT INTO tbo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ona ibaabani po ona bahabaha dumalu yaka ona pa, “Ee”, ma apo nugonugomi ona bowi yaka ona pa, “Eega”. Apo omi baha ona lauwitani yaka naka tu apapoe a nugotuhugei e nenei.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Lugagayo odubona uyahina amaka o hanapugeya hi baheya hi pa, “Mata emosi bigona mata emosi, ma niwo emosi bigona niwo emosi.” ");
INSERT INTO tbo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma tau u lugagayo a paliwelemi ega ona laubigo, apo lawa awai nawatata hinebawam ina launi yaka nawatata kehakeham una weleya po ina launi. ");
INSERT INTO tbo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Inapa iyai om gupouma luiluina ina waya yaka om luilui hota una palihaleya uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Apo lawa awai ina wihinihininim po a gapola una awala po una nae meyagai tahatahayana uyahina yaka gasi meyagai wiluwagana uyahina una niyeya po una houni. ");
INSERT INTO tbo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iyawoi uyahim he laupali hai luhogala atapuna una welewelehi po iyai om gapola ina lupaliyeya po ina wibagibagi yaka ega una nugonugoneya.’ ");
INSERT INTO tbo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Googata hai baha amaka o hanapugeya hi bahebaheya hi pa, “Omi lawa ona luhogalehi ma omi gawiya ona wihinigigiyehi.” ");
INSERT INTO tbo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma tau u lugagayo a paliwelemi omi gawiya ipa ona luhogalehi, ma tu lipilipilimi ubeihi ona laupali Yaubada uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Po geka dewana uyahinei Yaubada Amata hoi yada ina kawainatunemi, matababana tauna e lauhogaleta po tauna uyahinei kabudala e laalana hopu mai tu apapoe po tu dewadewa uyahihi, po gasi gadiwewe i palihaleya tu dumalu lawahi po ega hita dumadumalu uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Inapa tu luhogalem lawahi tunawahi una lauhogalehi yaka naka apo a dewadewa awai tam uyahim? Matababana takisi tu tama gasi tu luhogalehi he lauhogalehi. ");
INSERT INTO tbo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Apo gasi omi lawa dumahi tunawahi ona maamalihi ma lawa gehouhi eega, omi dewana mei tu meuputa hai dewa po ega ita dewadewa babana tupo magomagouhi geka dewana he meme tagoya. ");
INSERT INTO tbo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hoi hipuli omi dewa hina dewadewa imahi po mei Amami hoi yada a dewa.’ ");
INSERT INTO tbo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu i baha meme i pa, ‘Hougana omi dewa dewadewahi ona dewahi ega ipa lawa u matahi po hina hunemi. Inapa omi dewa naka pitenana yaka Amami hoi yada apega uyahinei maiha dewadewana ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hougana tu dayadayabu ipa uyahihi on’ombenena ega himogo ona huwehuwena tahaeya, po mei tauhi tu wikoyakoyama hoi numa tapalolo po hoi meyagai hai ombenena u mulina ma himogo he huweni po ipa lawa hina hunehi. A baha dumalu uyahimi hai kawaidewadewa houga geka he tutuhagaya naka hai meiha. ");
INSERT INTO tbo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma taumi omi houga ombenena hougana ipa on’ombenena gowagowada, po awala hinebawami a ombenena awala kehakehami ega ina hanahanapugeya ");
INSERT INTO tbo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","po lawa ega hina gagalemi tamogi Amami omi ani’mbenena gowagowadahi ina galehi po uyahihiyei omi meiha ina welemi.’ ");
INSERT INTO tbo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Omi lupali ona galena imahiyehi apo ona laupali Yaubada uyahina ega mei tu wikoyakoyama hai lupaligei ona laupali, matababana gegeka, tauhi hai winugonugotuhu ipa hoi numa tapalolo po hoi ani libolu lawa boluhi u matahi hina towolo ma hina laupali. A baha duma uyahimi tauhi lawa hai kawaidewadewa houga geka he tutuhagahi naka hai meiha. ");
INSERT INTO tbo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma taumi omi houga lupali uyahina ona lui omi numa u hinehi po omi babanoya ona guduhi ma Amami uyahina ona laupali gowagowada. Omi lupali gowagowadahi Yaubada ina galehi po uyahinei omi meiha ina welemi. ");
INSERT INTO tbo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma omi houga lupali uyahihi ega mei tu wipalilougo hai pali. Tauhi hai winugonugotuhu ipa apo baha yawa uyahinei ginouli hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hai dewa taumi ega ona wootagoya, babana taumi Amami e memae po tauna omi nugohine atapuhi i hanapugehi ma apoma muliyei o laupali. ");
INSERT INTO tbo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‘Geka pitenana ona laupali ona pa, Amiyai, tam hoi yada e memae. Gowam to wiyateyateya. ");
INSERT INTO tbo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Om ani taniwaga una wogeleteya. Om nugotuhu to dewaya hoi hipuli mei yada tu miyena he dewedeweya pite. ");
INSERT INTO tbo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","I yam iyeta geka binei una weliyai. ");
INSERT INTO tbo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","I apapoe una paligigilihi po mei iyawoi tu wiapapoeniyai to paligigilihi. ");
INSERT INTO tbo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma ega una palihaliyai po ludadana baneihi tona ialonihi. Ma apapoe uyahinei tam una haloiyai, babana tam om ani taniwaga po om manini po om wasawasa amalai po houga tuwetuwenai. Moina. ");
INSERT INTO tbo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Apo taumi lawa hai apapoe ona paligigilihi yaka Amami hoi yada apo omi apapoe ina paligigilihi. ");
INSERT INTO tbo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma inapa lawa hai apapoe uyahimi ega ona paligigilihi, yaka Amami hoi yada omi apapoe apega ina paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Hougana tapalolo binei ma ona iyohi, yaka ega tepami hina woapapoe po mei tu nugodubu. Naka tu wikoyakoyama hai dewa dumana babana galenahi hi wiapapoenihi po ipa hai wiyohi lawa hina hanapugehi po hina kawaidewedewehi naka hai meiha amaka he tutuhagahi. ");
INSERT INTO tbo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma taumi inapa tapalolo binei ona iyohi yaka ona itepaoga ma apalami ona ineulihi po galenami hina dewadewa lawa uyahihi ");
INSERT INTO tbo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","po omi wiyohi lawa ega hina hanahanapugehi, ma u nugonugomi awai e memae Amami tauna tunawana ina hanapugeya po apo om maiha ina welemi.’ ");
INSERT INTO tbo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Omi gapola ega hoi hipuli ona upupuma, matababana motamota po buda gapola he iapapoenihi ma tu danene apo hina lui po omi numa u hinehi omi gapola hina danenehi. ");
INSERT INTO tbo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma a dumalu ipa omi gapola hoi yada ona biheya, matababana hoi yada ega motamota po buda hita memae. Uyahinei omi gapola apega hina wiapapoenihi po ega tu danene hita memae. ");
INSERT INTO tbo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma meka hosi omi gapola he memeyana naka hosi apo nugonugomi hina mae.’ ");
INSERT INTO tbo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Matam tauna hinim anani liyayata. Hougana matam a dewadewahi hinim atapuna apo yayata ina hogoya. ");
INSERT INTO tbo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma matam hai apapoe hougana hinim atapuna apo hoi uguwa. Inapa yayata uyahim ina wigahugahu yaka naka uguwa ina mewiiwilena dumam. ");
INSERT INTO tbo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Ega emoemotana tu bagibagi emosi babada luwaga ina poulehi. Matababana emosi apo ina wihinigigiyeya ma gehounana ina luhogaleya. Ma apo emosi ina latuya ma gehounana ina galena iapapoeya. Apega Yaubada ma gapola una poulena luwagehi.’ ");
INSERT INTO tbo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Uyahinei a paliwelemi, ega ona genogeno omi mae hoi hipuli binei. Awai apo on’anani bo awai on’umumaya bo hinimi awai in’ototeni ega ona genogenogeya. Matababana omi luyagohana hi geduma ma apoma aniani, ma hinimi hi geduma ma apoma kaleko. ");
INSERT INTO tbo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Heki, kiu ona galehi, tauhi ega hita laupehi po ega hita yaba po hoi hanali hita huhouna. Ma tamogi Amami hoi yada e ianianihi. Ma taumi o geduma ma apoma kiu. ");
INSERT INTO tbo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","U hayami iyai emoemotana a nugotuhugei apo a luyagohana ita lidaoya? Ega emoemotami. ");
INSERT INTO tbo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘Matababana awai po kaleko binei o inugonugotuhu duma? Heki, hipuli wihiyahi iyowai he lahalahahi ona galehi. Tauhi ega hita wobagibagi bo hita diidina. ");
INSERT INTO tbo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tamogi a paliwelemi, Solomona a gapola atapuhi u hinehi a kaleko ega hai haki mei geka wihiyahi. ");
INSERT INTO tbo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hiyamoni amalai e lauyagohana ma mali’inatom po amaka e nae. Hoi mayau he’mapugeya po e alalahi. Tamogi Yaubada tauna hiyamonihi galenahi e idewadewahi, yaka Yaubada omi kaleko dewadewahi apo ina wiotenimi? Omi witumagana hi habulu hota! ");
INSERT INTO tbo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Uyahinei ega ona inugonugotuhu powa po ona pa, “Meka ata yam, ma meka ata goila, ma meka ata kaleko?” ");
INSERT INTO tbo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Matababana geka hipulina uyahina tu meuputa geka ginoulihi he bibihehi. Ma Amami hoi yada i hanapugeya naka geka ginoulihi o lauhogalehi. ");
INSERT INTO tbo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tamogi tauna anani taniwaga po a dewa dumadumaluhi ona bibihena tahaehi yaka geka ginoulihi apo hina wigalimiyei. ");
INSERT INTO tbo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iyeta emosi po emosi a winugonugotuhu he memae amalai binei ma hoimalatom binei. Yaka amalai ega ona inugonugogotuhu hoi malatom binei.’ ");
INSERT INTO tbo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‘Ega lawa gehouhi ona laibahibahihi meka po apo Yaubada ina libahibahimi. ");
INSERT INTO tbo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lawa hai apapoe ega ona inimayooyogehi babana omi winimayooyogana Yaubada apo ina wotagoya po ina winimayooyogemi. ");
INSERT INTO tbo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Awai binei walehim u matana dubudubu e gagaleya ma tam u matam mayau tipolina ega uta genogeya? ");
INSERT INTO tbo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Apo iyowai walehimna uyahina una baha nae una pa, “Una nei po u matam dubudubu a wihaleya,” inapa tam u matam mayau tipolina ega una galeya? ");
INSERT INTO tbo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tam tu wikoyakoyama. U matam mayau tipolina una wihalena tahaeya po una galena imahi ma apoma walehim u matana dubudubu una wihaleya. ");
INSERT INTO tbo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Yaubada a gapola ega ona hahalena yabayababaya kedewa u matahi, apo ona liyahiyahihi ma hina luhagawilehi po hina kimami. Mei gasi omi kahi matana ega polo ona weleweleya apo ina tuibaabaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Ona lupali yaka apo Yaubada ina welemi. Ona bibeiha yaka apo ona tuhagaya. Ma ona laitutou yaka Yaubada apo taumi bimiyei gudu ina hoeya. ");
INSERT INTO tbo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Matababana tu lupali atapuhi hai luhogala Yaubada e welewelehi. Ma tu beiha hai luhogala he tutuhagahi po tu litutou ubeihi Yaubada gudu e hoehoeya. ");
INSERT INTO tbo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Itapa geka u hayamina tam olotom po natum olotona ita kawayaniyani, apo gaima uta weleya? ");
INSERT INTO tbo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bo ita kawaiyana, apo mota uta weleya? ");
INSERT INTO tbo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Taumi tu apapoe ma o hanapugeya po natunatumi ginouli dewadewana o yambenehi, yaka Amata hoi yada tu lupali ginouli dewadewana e welewelemi. ");
INSERT INTO tbo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ma awai u luhogaleya ipa lawa uyahim hina dewadewaya naka dewana emosina uyahihi una dewadewaya, naka pitenana Mose po tu bahapiko hai wiatatiyana anona.’ ");
INSERT INTO tbo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Ona wileta po mateta dinadinana uyahinei ona luilui ma ega mateta yawayawatana uyahinei ona luilui, naka tahaya teyateyana po lawa magomagouhi nugohi i waya ma uyahinei he nenae anani kokoe uyahina wiyuwa e memae. ");
INSERT INTO tbo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma tahaya dinadinana i witai ma matetana i dinadina, po lawa ega hita maga ma uyahinei he nenae anani kokoe uyahina yautu tuwetuwenai.’ ");
INSERT INTO tbo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Tu wiatatiyana koyakoyama ona galena imahiyehi. Babana apo gehouhi hina nehi uyahimi po gagalenahi mei sipi malamalagamahi ma tamogi u nugonugohi mei kedewa woyahiyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lawa hai ugo uyahihiyei apo ta galena tuhagahi. Apega gologolowa gowana wine ugona donadona u tuyana una lohi po apega sitaniya u toyana kiyaha ugona una lohi. ");
INSERT INTO tbo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mayau dewadewana ugona dewadewana, mayau kakai ugona apapoena. ");
INSERT INTO tbo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mayau dewadewana apega ugona kakai ina houni ma mayau kakai apega ugo dewadewana ina houni. ");
INSERT INTO tbo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Inapa mayau ega hina ugugo imahi yaka apo Yaubada ina tala halehi po ina apuhi. ");
INSERT INTO tbo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yaka apo lawa dewadewahi po apapoehi ona galena tuhagahi hai bagibagi uyahihiyei. ");
INSERT INTO tbo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Lawa hi maga duma uyahihi he kawakawaiguyau, ma tamogi atapuhi apega hina lui Amau anani taniwaga uyahina, ma iyawoi tauhi Amau hoi yada a nugotuhu tu wiponawogogena tauhi tunawahi. ");
INSERT INTO tbo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Iyeta he nenei uyahihi lawa magomaoguhi apo hina baha hina pa, “Guyau, Guyau, i bagibagi gowamgei to dewahi: to baha piko po alugo apapoehi to iyagahi po manini magomagouhi to dewadewahi.” ");
INSERT INTO tbo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma apo a baha nae uyahihi ana pa, “Lolowa ega ata hanapugemi taumi tu bagibagi apapoehi ona nehaleu.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘U wibaabani geka apo taumi iyawoi ona nonola imahiyeya po ona wiponawogogeya yaka apo taumi mei tu lunuma hanahanapuna po hoi gaima a numa amaka i wogoya. ");
INSERT INTO tbo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ma houga apapoena ina nei apo gadiwewe ina atuna po goila ina hopu ma togowa baneina ina togo mai numana uyahina ma apega ina guli, matababana gaima u tepana i witowoli po i kadilili. ");
INSERT INTO tbo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Apo taumi iyawoi u wibaabani geka ega ona nonola imahiyeya po ega ona wiponawogogeya, yaka apo taumi mei tu lunuma buubuwana a numa hoi bubu i wogowogoya pite. ");
INSERT INTO tbo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma hougana gadiwawewe baneina ina atuna po goila hina hopu ma togowa baneina ina togo mai numana uyahina, yaka apo ina dubali po ina lugolugoluhi.’ ");
INSERT INTO tbo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu a wibaabani i wikokowi ma lawa magomagouhi hi nugogohola duma a wiatatiyana binei, ");
INSERT INTO tbo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","babana a baha hi wipoya ipa lawa hina wotagoya, ma ega mei lugagayo tanitaniwagahi hai wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu oyagei i hopu mai po bolu baneina hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma lawa lepelepelona i nei Yesu uyahina po anai wiyateyatena i polou ma i baha i pa, ‘Guyau, inapa nugonugom yaka una luyawahiu.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu nimana i lodomi po lawana i wodadani ma i pa, ‘Apo a luyawahim. Amaka ma una dewadewa.’ Mala emosi ma a lepelo i kokoe. ");
INSERT INTO tbo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu i baha nae lawana uyahina i pa, ‘Ega lawa gehouna una palipaliweleya, ma una nae tu witalaguyaba uyahihi po una bahena mem una pa, “Amaka a dewadewa” ma om ani’mbenena una houni mei Mose a lugagayo bukana uyahina i gilugilumi pite, po hina hanapugem tam amaka u luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu i nei meyagai gehouna gowana Kapaneum ma Loma lawana tauna tu wigawiya tu galena itetehi i nei po i lubayadeya ");
INSERT INTO tbo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","i pa, ‘Guyau, u hewali gehouna a totogo i lata po i wiyuwa duma po hoi numa eneno ma ega emoemotana po ina widagudagu.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu i baha nae uyahina i pa, ‘Apo a nehi po a widewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tu galena itetena i baha nae Yesu uyahina i pa, ‘Guyau, ega u dewadewa awai ipa a winim po una lui mai u numa u hinena tamogi baha yawa una baheya ma apo u hewali ina luyagohana. ");
INSERT INTO tbo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ma tau gasi witaniwaga gehouna a tu bagibagi po tu wigawiya u nimau hi hounihi po a gagalena itetehi. Ma apo tu wigawiya emosi uyahina ana pa, “Una nae,” ma e nae. Ma apo gehouna uyahina ana pa, “Una nei,” ma e nei. Ma gasi apo u tu bagibagi uyahina ana pa, “Geka una dewaya,” ma e dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hougana geka bahahi Yesu i noonolihi po i goholi ma hi imulitagoya uyahihi i baha nae i pa, ‘A baha duma uyahimi, yohola mi Isalaela u hinemi ega lawa awai a witumagana ata galeya po mei geka lawana. ");
INSERT INTO tbo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A paliwelemi, kabudala anani geleta po anani yoli lawa magomagouhi hina nei po hina tugula gogona hoi ani am Yaubada anani taniwaga uyahina, Abelaham ma Isako po Yakobo mitehi. ");
INSERT INTO tbo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma taumi Isalaela googana gehoumi anani taniwaga u hinena o memae apo ina wihulu hopunemi hoi tupo uguwa po tou ma omhanakidiyana ona tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu tu wigawiya hai taniwaga uyahina i baha nae i pa, ‘Una nae om hewali apo ina luyagohana om witumagana binei.’ Houga naka uyahina tu tootogona a kadidili i tuhaga meya. ");
INSERT INTO tbo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu i nae Pita a numa uyahina po pohiyana i hinigugupouma i galeya hoi ani eno i eneno ");
INSERT INTO tbo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","yaka Yesu nimana i lodomi po wawinena i wogoya po a gupouma i kokoe, ma i towolo po i poulehi. ");
INSERT INTO tbo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aipompom ma tu tootogo lawa hi neihinimai Yesu uyahina, tauhi alugo apapoehi i luiluinihi ma Yesu i galehi yaka i paliyehi po hi lowo ma gasi tootogohi i widewadewahi. ");
INSERT INTO tbo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Geka dewahi hi gelegeleta naka tu bahapiko Isaiya a baha i limoineya. Geka pitenana a wibaabani i pa, ‘Tauna ata wigwameyameya ma ata totogo witeihi ina awalihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Naka hougana uyahina Yesu bolu banei dumana hi mewiwileya ma i galehi, yaka a hewahewali i baha nae uyahihi po ipa wam uyahina hina gelu po hina woe damana u tupona. ");
INSERT INTO tbo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lugagayo taniwagana gehouna i nei Yesu uyahina po i baha i pa, ‘Bada, om nae atapuhu uyahihi ipa a wotagom.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu i baha lawana uyahina i pa, ‘Gamogamo mi pitepitena waidomohi po kiu moyanei waipatahi. Ma Lawa Moinau ega meka nawatatau ani wienona gehouha.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesu tu wotagona gehouna i nei uyahina po i lubayada i pa, ‘Guyau, una palihaleu po a nae amau a guluwa tahaeya ma apoma a wotagom.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu a baha i wimiheya i pa, ‘Lawa hai luyagohana mei tu hilahilage una palihalehi po tu hilahilage uyahihi hina galena nae.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu a hewahewali mitehi wam uyahina hi gelu po hi damadamana ");
INSERT INTO tbo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","po mala emosi ma togowa baneina hi wialoni po guletutu i hulugeleteya wam u hinena ma apo hita yoli. Ma Yesu amaka i eno hilage. ");
INSERT INTO tbo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yesu a hewahewali hi nei po hi limaamahi po i towolo ma hi pa, ‘Guyau, una luyawahita, kikina ma apo ta yoli.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu i baha nae a hewahewali uyahihi i pa, ‘Awai binei o matomatouta? Omi witumagana hi habulu hota,’ ma i towolo po togowa ma guletutu i paliyehi po noka hougana dumola baneina. ");
INSERT INTO tbo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A hewahewali hi gohola dumahi ma tunawahi hi ibaabani hi pa, ‘Geka lawana iyai, po togowa ma guletutu he iponawogogeya?’ ");
INSERT INTO tbo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Galili bogana u tuponei dobu gowana Gadala apoma uyahina hi lugeleta. Hougana hi laugeleta lawa luwaga hi tuhagahi naka tauhi alugo apapoehi hi luinihi po kokowaga u domohi hi memae. Hai dewa hi apapoe duma po ega emoemotana lawa gehouna tupo noka uyahina tunawana ina nae. ");
INSERT INTO tbo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hai luwagahi Yesu hi galeya yaka hi otu hopu uyahina hi pa, ‘Yaubada Natuna tam. Awai ipa una dewaya uyahiyai? Yohola ega libahibahi hougana ma ipa hiniwiyuwa una weliyai?’ ");
INSERT INTO tbo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma polo boluhi hi banibani, ega balana ita dao Yesu uyahinei. ");
INSERT INTO tbo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ega yaka alugo apapoehi Yesu uyahina hi lupali gonugonuwa hi pa, ‘Inapa una iyagiyai yaka to luhogaleya ipa una himiliyai po noka polohi uyahihi to lui.’ ");
INSERT INTO tbo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ega yaka Yesu i baha nae uyahihi i pa, ‘Ona hopu.’ Lawahi luwaga uyahihiyei alugo apapoehi hi hopu po hi nae polo uyahihi po hi lui, ma polohi boluhi hi nohanoha mehi po hoi gubala hi holuholugehi hoi boga po hi halele atapuhi. ");
INSERT INTO tbo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma polo tu galena itetehi hi lowo po hi nae dobu baneina uyahina hi wibenabenama awai hi gelegeleta ma lawahi alugo apapoehi hi luiluinihi ubeihi hi wibenabenama. ");
INSERT INTO tbo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ega yaka lawa atapuhi meyageina hi’mboina nae Yesu uyahina po hi galeya ma hi baha gonugonuwa uyahina po ipa tupo noka ina nehaleya. ");
INSERT INTO tbo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu hoi wam i gelu po hi damana meme a dobu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bolu gehouhi lawa waigwameyameyana hoi ani eno hi neiyai Yesu uyahina. Hougana Yesu hai witumagana i galeya po i baha nae totogo lawana uyahina i pa, ‘Natuwe, om apapoe amaka a paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yesu a wibaabani lugagayo tanitaniwagahi hi noonoli po tunawahi ma hi ibaabani hi pa, ‘Geka lawana Yaubada e idibogi.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hai winugonugotuhu Yesu amaka i hanapugeya ega yaka i baha nae uyahihi i pa, ‘Awai binei o inugonugotuhu powa? ");
INSERT INTO tbo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Meka baha dewadewana ega ita ipilipili? Om apapoe a paligigili bo una towolo po una nae? ");
INSERT INTO tbo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Apo uyahimi a limoineya naka tau Lawa Moinau, wipoya Yaubada i weleu po hoi hipuli apo apapoe a paligigili.’ Ega yaka i baha nae lawa waigwameyameyana uyahina i pa, ‘Una towolo po om ani eno una awali po una nae om meyagai uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ega yaka lawana i wotowolo po i nae anu meyagai. ");
INSERT INTO tbo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma bolu hi gagaleya po hi matouta duma ma Yaubada hi wotalagiyeya po hi pa, ‘Nugote Yaubada a wipoya atapuna Yesu i weleya.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu tupo noka i nehaleya po i nenae ma lawa gehouna gowana Matiu takisi tu tama anani bagibagi numana uyahina i tugutugula ma i galeya. Ega yaka Yesu i baha nae uyahina i pa, ‘Una wotagou.’ Matiu i towolo po Yesu i wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Houga naka uyahina Yesu mitehi hi tugula Matiu anu numa po hi’mam, ma takisi tu tama po tu apapoe po Yesu a hewahewali hi nei po mitehi hi’mam. ");
INSERT INTO tbo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma Palisi lawahi Yesu hi gagaleya po ega yaka a hewahewali hi lubayadehi hi pa, ‘Awai binei omi tu wiatatiyana takisi tu tama po tu apapoe mitehi he yam gogona?’ ");
INSERT INTO tbo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu hai baha i noonoli po i baha nae uyahihi i pa, ‘Lawa ega hita tootogo ega tu lumulamula nugonugohi ma tu tootogo tauhi nugonugohi tu lumulamula. ");
INSERT INTO tbo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yaubada a baha hoi Buka hi gilugilumi o hanapugeya, bo eega? Geka pitenana hi baheya hi pa, “A luhogaleya lunugotootogo ma ega ata luhogaleya witalaguyaba.” A nenei ega ipa tu dewadumalu a otugehi ma tu apapoe a otugehi po hina nugobui.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yoni a hewahewali hi nei Yesu uyahina po hi lubayadeya hi pa, ‘Awai binei tauyai ma Palisi lawahi i tapalolo binei to iyohi ma tam om hewahewali mitehi o’mam?’ ");
INSERT INTO tbo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Yesu i’mpaliluwaluwa uyahihi i pa, ‘Itapa tu tawine olotona a tawine tolehana uyahina tauna ita memae, moina apo a toumana hita iyohi? Apega. Tamogi iyeta he nenei apo tu tawine olotona a gawiya hina wihaleya ma noka iyetahi uyahihi apoma apo hina wiyohi. ");
INSERT INTO tbo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Ega iyai luilui wouna ita papaya po luilui odubona uyahina ita hilahilama lawiteya. Inapa ina dewaya yaka naka luiluina wouna amaka i wiapapoeya ma gasi apo gunalolona ina lata. ");
INSERT INTO tbo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma ega iyai wine wouna ita hiwohiwoga hopuneya tala gigoila gamogamo opihiyei hi dewadewaya odubona uyahina. Inapa ina dewaya yaka apo winena wouna ina hahana po tala gigoilana ina gunahaiya po wine ina kolologeya. Apega iyai ina dewaya. Tamogi wine wouna ipa tala gigoila wouna uyahina hina hiwohiwoga hopuneya po atapuna ina dewadewa pahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu i ibaabani ma taniwaga gehouna i nei uyahina po i polou ma i baha nae uyahina i pa, ‘Natuwe wawinena amalai i hilage. Ma a luhogalem ipa una nei po una wogodadani po ina luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu a hewahewali mitehi hi wotowolo po taniwagana hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Po hi nenae ma wawinena gehouna tootogona, tauna a totogo naka tala i kolokololo bolima magouhi 12. Wawinena mulihiyei i nei po Yesu a kaleko mutuna i wodadani. ");
INSERT INTO tbo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Matababana u nugonugona i lugeleteya i pa, ‘Apo Yesu a kaleko yawa a wogodadani yaka a luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hougana Yesu a kaleko i wodadani, ma i luhagawileya po i baha nae uyahina i pa, ‘Natuwe, una kaoha om witumagana i luyawahim.’ Mala emosi wawinena a dewadewa i tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu a hewahewali mitehi hi nae po taniwagana a numa uyahina hi geleta, po hi gagalena naka tu widilehu hi dilehu, hai nugowiyuwa binei ma hi tutou labalabatana. ");
INSERT INTO tbo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ega yaka Yesu i paliyehi i pa, ‘Atapumi tewela geka ona nehaleya po ona hopu hoi uputa; tewela geka ega ita hilage ma e’neno.’ Geka bahana uyahina ma lawa atapuhi hi winameya. ");
INSERT INTO tbo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bolu atapuhi numana hi hopu haleya ma Yesu i lui po tewelana u nimana i wogo ma i witowoli. ");
INSERT INTO tbo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma u mulina Yesu tuwegana hi nohaya tupo atapuna uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu numa noka i nehaleya po tahayagei i nenae ma tu matakeke luwaga hi wotagoya po hi ototu hi pa, ‘Yesu, Dawita gogana, apo uta lunugotootogogeiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu numa u hinena i lui po i memae, ma tu matakekehi hi nei uyahina po i lubayadehi i pa, ‘O witumaganeu ipa apo matami a widewadewahi?’ Tauhi a baha hi wimiheya hi pa, ‘Guyau, to witumaganem.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ega yaka matahi i wodadanihi ma i baha nae uyahihi i pa, ‘Omi witumagana binei apo matami hina lugiigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yaka matahi hi lugiigilihi. Ma Yesu i lugagayogehi i pa, ‘Ega lawa gehouna uyahina ona bahebaheu.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hai luwagahi hi nenae po Yesu a baha ega hita wotagoya ma a bagibagi tuwegana hi deedeniyeya tupo atapuna uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesu a hewahewali mitehi hi nenae ma lawa gehouna menana alugo apapoena i wobuiya po ega ita ibaabani ma hi neiyai uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","po Yesu i wiyagaya ma lawana i dewadewa meme po i ibaabani. Ma lawa boluhi hi kaoha duma po Yesu hi kawaidewedeweya po hi pa, ‘Ega kikina lawa gehouna a bagibagi tata galeya Isalaela u hinena geka pitenana.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma Palisi lawahi hi gagaleya po ega yaka hi baha hi pa, ‘Ega naka tauna a wipoyagei ita wobagibagi ma Tomodulele balau i weleya po uyahinei alugo apapoehi e iyagahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu dobu po meyagai uyahihi i wiwila nae, ma hai numa tapalolo uyahihi i iatatiyana, ma Yaubada anani taniwaga tuwegana i bahebaheya ma gasi tu tootogo magomagouhi i lauyawahihi. ");
INSERT INTO tbo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma lawa boluhi i gagalehi po i lunugotootogogehi, babana witai atapuhi uyahihi ega kikina hai tu hagu gehouna, galenahi mei gamogamo hi neneyabayababa ega hai tu galena itete. ");
INSERT INTO tbo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ega yaka Yesu a hewahewali i paliwelehi i pa, ‘Mahula i lauliligeya ma tu yaba luemoemotahi. ");
INSERT INTO tbo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Uyahinei ona lupali mahula Guyouna uyahina po tu yaba gehouhi ina himilihi po hina nae mahula hina tuwaluhi.’ ");
INSERT INTO tbo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu a hewahewali magouhi 12 i otugehi po wipoya i welehi, po apo alugo apapoehi lawa uyahihi hina iyagahi ma totogo galenahi tapuhi po tapuhi hina luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Geka a hewahewalihi magouhi 12 i wigowahi po tu wituwetuwega, lawa tahatahayana Simona tauna gowana hi buiya po Pita, ma walehina Andulu, ma Yamesa ma walehina Yoni tauhi Sebedi natunatuna. ");
INSERT INTO tbo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo ma Batolomiu, Tomasi ma Matiu tauna takisi tu tama ma gasi Yamesa gehouna tauna Alipi natuna ma Tadiyesi, ");
INSERT INTO tbo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma Simona gehouna tauna tu’mgudugudu mi Loma hai ani taniwaga uyahinei, ma Yudasa Isakaliyota Yesu tu nugohalenana. ");
INSERT INTO tbo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu a hewahewali magouhi 12 i himihimilihi ma hai lugagayo i paliwelehi i pa, ‘Tauhi ega mi Yudeya uyahihi ega ona nenae, po gasi Samaliya meyageihi uyahihi ega ona luilui. ");
INSERT INTO tbo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma ata lawa mi Isalaela uyahihi ona nae, babana tauhi galenahi mei gamogamo weluwelupowahi ");
INSERT INTO tbo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","po uyahihi ona wipaliwelena ona pa, “Kikina ma Yaubada a taniwaga ina geleta uyahita po ina taniwageta!” ");
INSERT INTO tbo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tu tootogo ona widewadewahi po mei gasi hilahilagehi ona witowolo mehi, ma gasi tu lepelo ona liyeuyeuhi. Ma alugo apapoehi lawa u nugonugohi ona wiyagahi. Yaubada a manini i weleyababami yaka taumi gasi lawa uyahihi ona hagu yababa. ");
INSERT INTO tbo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Omi kadau binei ega mone, kina bo toea, ona pohapohahi omi outu u hinena. ");
INSERT INTO tbo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Omi kadau binei geka ginoulihi ega ona tamitamihi, omi outu, omi kaleko wiluwagana, oma ae humahuma po gasi omi digona, matababana tu bagibagi apo a iligona ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Hougana dobu po meyagai uyahihi ona luilui ona lubayada tahaya po lawa awai a dewa wodewadewana ina baha uyahimi, yaka ona lui a numa u hinena po ona memae a sigana omi houga omhoe yaka apoma ona nehaleya. ");
INSERT INTO tbo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hougana ona luilui numa u hinena yaka ona wimaamala tahaya lawana uyahina ona pa, “Yaubada a nugodumola mitehi ona memae,” ma apoma ona lui. ");
INSERT INTO tbo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Apo gugunihi omi baha wimaamala ina linanahi yaka omi wimaamala ina memae, ma inapa ega ina linanahi yaka omi baha wimaamala ina gunawilena meya uyahimi. ");
INSERT INTO tbo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma inapa lawa ega hina kaohemi po omi baha hina nonoli. Yaka naka meyagaina bo numana ona nehaleya. Ma ona nenae hougana aemi dubudubuna ona lihooholi u matahi. ");
INSERT INTO tbo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A baha duma uyahimi, Libahibahi Iyetana uyahina apo hai wiyuwa ina lata duma ma mi Sodom ma mi Gomola hai wiyuwa ina habulu.’ ");
INSERT INTO tbo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Tau a himihimilimi gagalenami mei sipi, ma kedewa woyahiyahihi u hayahi o nenae, yaka ipa ona nugohanahanapu po mei mota, ma ona nugohegoya po mei bunebune. ");
INSERT INTO tbo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ma lawa ona galena imahiyehi, babana tauhi apo hina niyemi po hina libahibahimi hai omboina uyahihi ma hai numa dalabu uyahihi apo hina wilawimi. ");
INSERT INTO tbo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ma gowau binei apo hina niyemi taniwaga po wasawasa baneihi uyahihi. Ma naka omi gaogao apo tuwega dewadewana ona nohaya tu meuputa u matahi. ");
INSERT INTO tbo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hougana apo hina panimi po hina niyemi libahibahi binei ega ona genogeno ipa apo awai ona baheya uyahihi. Yaubada tauna apo omi baha ina woogeleteya u nugonugomi, ");
INSERT INTO tbo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","babana awai o bahebaheya ega tunawami, ma Amami Alugona apo ina wiatatiyemi omi wibaabani uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Houga noka uyahina lawa apo gugunihi yawa apo hina igawigawiya biugei po walehina ina palihaleya po hina lihilageni. Mei gasi lawa natuna apo ina nugohaleya po hina lihilageni ma logaloga amamahi po hinahinahi hina palihalehi po hina lihilagenihi. ");
INSERT INTO tbo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Apo gowau binei ma lawa atapuhi hina wihinigigiyemi. Ma apo taumi iyawoi on’omtaibagibagi ma ona towolo kadidili po a sigana houga anani kokoe uyahina yaka apo luyagohana ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Apo dobu awai uyahina wiyuwa hina welewelemi yaka ona lowo nae dobu gehouna uyahina. A baha duma uyahimi Isalaela dobuna atapuna apega ona wikokowi ma tau Lawa Moinau apo a gunawilena meu. ");
INSERT INTO tbo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Tu lunonola a tu wiatatiyana apega ina gelagoni. Mei gasi tu bagibagi a bada apega ina taniwageya. ");
INSERT INTO tbo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Taumi tu wotagotagou apega ona gelagoniu geka amaka omi dewa ipa mei u dewa. Lawa hi igowau hi pa tau Tomodulele yaka apo gasi hina wigowami po Tomodulele a lawa. ");
INSERT INTO tbo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Lawa ega ona matumatutehi, babana ginouli awai humahumana apo ina lugeleteya, bo gowagowadana apo lawa hina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Awai hoi uguwa a bahebaheya apo hoi yayata lawa ona paliwelehi, ma awai a iyaguhayahayageya dobu atapuna ona iototugeya. ");
INSERT INTO tbo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","‘Iyawoi hinimi hin’ununi ega ona matumatutehi babana alugomi apega hina lihilagenihi. Ma tamogi Yaubada ona matuteya, babana emoemotana apo hinimi po alugomi mayau alalatana uyahina ina houni. ");
INSERT INTO tbo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kiu muhomuhohi luwaga mihahi 10 toea tamogi Yaubada e gagalena itetehi po gehouna ina hilage naka Amami hoi yada a nugotuhugei. ");
INSERT INTO tbo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma gasi ununumi apala atapuhi Yaubada i hiyawa pahi. ");
INSERT INTO tbo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yaka ega ona matomatouta, taumi o geduma ma apoma kiu boluhi. ");
INSERT INTO tbo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Iyai bolu u matahi ma ina bahena geleteu naka tau e itumaganeu yaka tau Amau hoi yada u matana apo tauna a bahena geleteya. ");
INSERT INTO tbo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma iyai ina bowiyeu bolu u matahi yaka tau Amau hoi yada u matana apo tauna a bowiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Omi nugotuhu o pa nugodumola ata neiyai hoi hipuli, bo? A paliwelemi, eega. Ega nugodumola ata neiyai ma tamogi gawiya. ");
INSERT INTO tbo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tau amaka a nei yaka apo wikahakaha ina wawala. Apo lawa natuna olotona ina towolo po amana ina wigawiyeya. Apo natuna wawinena ina towolo po hinana ina wigawiyeya. Pohiyana wawinena apo ina towolo po pohiyana wawinena ina wigawiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Po gasi lawa a guguni dumahi apo hina wigawiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Apo lawa awai amana ma hinana ina luhogalena dumahi ma tau tupo hotana tauna ega emoemotana po ina wotagou. Ma apo lawa awai natuna olotona bo wawinena ina luhogalena dumahi ma tau tupo hotana naka lawana ega emoemotana po ina wimulitagou. ");
INSERT INTO tbo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Apo iyai anani take ega ina awali po ina wotagou tauna ega emoemotana po ina wotagou. ");
INSERT INTO tbo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Apo lawa awai a luyagohana ina nugoneya yaka apo ina haleya ma apo iyawoi tau biugei hina hilage yaka apo yautuhi hina tuhagahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Apo lawa awai ina kaohemi yaka naka tau i likaohau po tu himiliu i likaohaya. ");
INSERT INTO tbo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Apo lawa awai tu bahapiko ina likaohaya babana tauna tu bahapiko yaka a meiha ma tu bahapikona a meiha emoemotahi. Ma apo lawa awai tu dumalu lawana ina likaohaya babana tauna tu dumalu po una yaka a meiha ma tu dumaluna a meiha emoemotahi. ");
INSERT INTO tbo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Apo tu witumaganeu wouna uyopopona ina haleya po ina nei uyahim ma goila wayowayouna una weleya, babana e wotagou a paliwelem tam meiha apo una tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu a hewahewali magouhi 12 uyahihi a wiatatiyana i wikokowi, ma tupo noka i nehaleya po i wiiwila tupo emosi po emosi uyahihi ma i guuguya. ");
INSERT INTO tbo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Houga naka uyahina Yoni tu wibapatiso amaka hi houna luiyeya hoi numa panipani, ma Keliso a bagibagi tuwegana i nonoli ma ega yaka a hewahewali i himilihi po hi nae Yesu uyahina po hi lubayada, ");
INSERT INTO tbo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","hi pa, ‘Tam iyai? Besinana lawana bimgei to iotonana ipa apo una nenei bo ega tam ma lawa gehouna to iotonaneya?’ ");
INSERT INTO tbo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ega yaka Yesu hai lubayadana i wimihena meya i pa, ‘Awai o gagalehi po o noonolihi ona gunawilemi po Yoni ona paliweleya. ");
INSERT INTO tbo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tu matakeke he gagalena imahi po tu aeapapoe he neneimahi po lepelo lawahi he wodewadewa meme po tu tanigapupu he launonola po lawa hilahilagehi hi towolo meme po tu dayadayabu tuwega dewadewana he noonoli. ");
INSERT INTO tbo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iyai ega ita inugomagomagougeu tauna a kawaidewedeweya.’ ");
INSERT INTO tbo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yoni a hewahewali hi gunawilena mehi po hi memae, ma Yesu i wiwawala po bolu uyahihi i ipaliwelena Yoni binei i pa, ‘Hougana o nenae hoi balabala yabayababa Yoni uyahina omi nugotuhu ipa awai ona galeya? Ega togowa didiyala ita kwadikwadiyeya ma ota galeya. ");
INSERT INTO tbo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma omi nugotuhu ipa awai ona galeya? Ega ipa lawa a wihiya gegena, bo? Babana lawa noke pite hai wihiya po hai wigapola naka tauhi wasawasa hai u numa he tugutugula. ");
INSERT INTO tbo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ona paliweleu awai ipa ona galeya? Tu bahapiko, bo? Moina tauna tu bahapiko tamogi tu bahapiko atapuhi i gelagonihi. ");
INSERT INTO tbo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Matababana Yaubada a Buka uyahina tauna binei hi baha i pa, “Apo u tu winoyanoya a himila tahaeyem po om tahaya ina wononogogeya.” ");
INSERT INTO tbo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A baha duma uyahimi, ega meka lawa hita guni po a gae mei Yoni bapatiso. Tamogi Yaubada anani taniwaga uyahina iyawoi hina idayadayabu tauhi hi geduma ma apoma Yoni. ");
INSERT INTO tbo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yoni bapatiso a houga uyahina ma i nei po amalai tu kadidili hai kadidiliyei Yaubada anani taniwaga he luiluiya. ");
INSERT INTO tbo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Odubona tu bahapiko atapuhi hai wibaabani po gasi Mose a lugagayo uyahihiyei Yaubada anani taniwaga hi wogeleteya anani kokoe Yoni i nei. ");
INSERT INTO tbo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma Yoni a nei mei tu bahapiko odubona i bahebaheya Guyau ina nenei apo Elaisiya ina tahaya, ma o luhogaleya ipa ona hanapugeya. A paliwelemi Elaisiyana naka tauna Yoni. ");
INSERT INTO tbo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Apo uyahimiyei lawa awai waitanigana yaka baha geka ina nonola imahiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘Lawa geka hapanana apo awai uyahina a wiluweluwena niyehi? Po galenahi awai? Tauhi mei logaloga ani gimala meyageina uyahina he tugula ma he yampalidamadamana he pa, ");
INSERT INTO tbo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ubeimi to lauinainaga ma ega ota hala. Ma to tutou ma ega ota tou haguiyai.” ");
INSERT INTO tbo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ma Yoni i nei naka a omhilagena po ega wine ita umaya ma lawa hi ibaabani hi pa, “Tauna alugo apapoena u hinena.” ");
INSERT INTO tbo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tau Lawa Moinau a nenei anai omniu po anai umau po lawa hi pa, “Geka lawana ona galeya, tauna tu’mlabatana po tu umabuubuuwa po a lawa takisi tu tama po tu apapoe.” Tamogi Yaubada a hanapu bagibagi dewadewana uyahina naka hanapu moinana.’ ");
INSERT INTO tbo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dobu gehouhi uyahihi Yesu a manini hi galeya ma ega hita nugobui yaka i paliyehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","‘Kihoni Kolasini tu nugodubu lawami. Kihoni Besaida tu nugodubu lawami. Itapa manini u hinemi hi dewadewahi u Taya po u Saidoni hita dewahi amaka lolowa lawahi hita nugobui. Ma hai nugobuina apo hita wogeleteya po kaleko apapoehi hita otena ma hita lugobu. ");
INSERT INTO tbo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tamogi Libahibahi Iyetana uyahina apo Yaubada Taya ma Saidoni ina lunugotootogogena dumahi ma apoma taumi. ");
INSERT INTO tbo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","24","Ma taumi Kapaneum lawami omi nugotuhu o pa ona wohepa memi po ona gae hoi yada, bo? Apo Yaubada ina halena hopunemi mayau alalatana uyahina. Ma mi Sodom hai libahibahi ina habulu babana itapa odubona mi Sodom u manini hita galeya, apo hita nugobui po apega Yaubada ita hamaga halehi.’ ");
INSERT INTO tbo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naka houganana Yesu i baha i pa, ‘Amau yada po hipuli hai Guyau, a wotalagiyem babana lawa hanahanapuhi po wainugonugotuhi uyahihi awai u gowagowadi naka tu winugoneina uyahihi u wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Moina Amau geka pite ipa om lunugotootogogei ina wawala. ");
INSERT INTO tbo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","‘Amau ginouli atapuhi i weleu. Ega iyai tau ita hanapugeu ma Amau tunawana. Gasi ega iyai Amau ita hanapugeya, ma tau Natuna po iyawoi a inaganihi uyahihi Amau a woogeleteya tunawiyai to hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","‘Taumi iyawoi omi awala po omi bagibagi hina witai, yaka ona nei uyahiu po apo alugomi wiyagohina hina tuhagaya, ");
INSERT INTO tbo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","po u bagibagi ona dewaya babana u bagibagi awalana i teyateya gasi u memae ona lubuya po alugomi wiyagohina hina tuhagaya, matababana tau u dewa nugohegoya ma nugohopuhopu.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hoi dalabu Yesu a hewahewali mitehi yaniyani mei pegapega tanona tipolinei hi nenae po am hi hilage yaka pegapega ugohi hi’mgomugomu po hi’mam. ");
INSERT INTO tbo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma Palisi lawahi hi galehi yaka Yesu hi paliweleya hi pa, ‘I lugagayo i baheya ipa ega hoi dalabu to wobagibagi, ma iyowai po om hewahewali geka pite he dewadewaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ega yaka Yesu i paliwelehi i pa, ‘Dawita po iyawoi tauna mitehi am hi hilage ma awai i dewadewaya o hiyawi, bo eega? ");
INSERT INTO tbo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tauna i lui po Yaubada a numa u hinena palawa wailugagayona i waya po i ani ma a hewahewali i welewelehi. Tamogi ata lugagayo i baheya ipa ega iyai ina anani ma tu witalaguyaba tunawahi. ");
INSERT INTO tbo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma Lugagayo bukana u hinena giluma e memae i pa, dalabu iyetana uyahihi tu witalaguyaba he wobagibagi po dalabu lugagayona he lagolagoni naka ega genona po gasi ega apapoena. ");
INSERT INTO tbo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A baha uyahimi lawa gehouna u hayami e memae tauna numa dalabu i gelagoni. ");
INSERT INTO tbo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaubada a baha ega ota hanapugeya i pa, “Talaguyaba ega ginouli baneina ma lunugotootogo naka ginouli baneina.” Yaka ega u hewahewali ona igouhi. ");
INSERT INTO tbo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tau Lawa Moinau dalabu taniwagana.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu i nae po hai numa tapalolo uyahina i lui, ");
INSERT INTO tbo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","po lawa nimana wogiyogiyona i memae ma i galeya ega yaka tanitaniwaga hi lubayadeya hi pa, ‘Emoemotana apo dalabugei lawa tata widewadewahi?’ Hai lubayada babana ipa iyowai ma Yesu hina wigouya. ");
INSERT INTO tbo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ega yaka Yesu hai baha i wimiheya i pa, ‘Iyowai taumi apo lawa gehouna a gamogamo emosi hota iyeta dalabu uyahina ma ina peu hoi domo apo ina wihalena meya, bo eega? Nugote apo ina haguya. ");
INSERT INTO tbo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A paliwelemi gamogamo ginouli habuluna ma lawa geka ginouli baneina yaka iyeta dalabu uyahina emoemotana apo lawa ta widewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu lawana i paliweleya i pa, ‘Nimam una lodomi,’ ega yaka lawana nimana i lodolodomi po i dewadewa po mei nimana gehouna. ");
INSERT INTO tbo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Palisi lawahi hi nehaleya po hi wiwogatala hi pa, ‘Apo iyowai ma Yesu ta lihilageni?’ ");
INSERT INTO tbo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma hai wiwogatala gowagowada Yesu amaka i hanapugeya, ega yaka tupo noka i nehaleya po i nae tupo gehouna uyahina ma lawa boluhi hi wotagoya po hai totogo i widewadewa mehi. ");
INSERT INTO tbo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma i paliwelehi i pa, ‘Ega ona palipaligeleteu lawa uyahihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A bagibagi geka hi gelegeleta matababana Yaubada a baha Isaiya i bahebaheya i pa, ");
INSERT INTO tbo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Ona galeya u tu bagibagi a winagani. Tauna u ani kaoha po u ani luhogala. Alugou a hiwoga haleya uyahina po dewa dumadumaluna ina wituwetuwegeya lawa magomagouhi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tauna ega emoemotana po ina wogalahi po gasi apega in’omlahalaha uheiya lawa ponana apega hina nonoli. ");
INSERT INTO tbo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tu tapitapiya apega ina wihinigigiyehi, tu lunugoluwaluwaga hai yayata apega ina bohoya, a siga a taniwaga dumadumaluna ina kadidili, ");
INSERT INTO tbo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","po tauna gowanei hipuli atapuna hai luhogala hina wialona imahiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lawa gehouna alugo apapoehi matana hi likekeya po menana hi wobuiya po ega ita ibaabani, ma hi neiyai Yesu uyahina po i widewadewaya ma i wibaabani imahi ma gasi i galena meme. ");
INSERT INTO tbo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lawa magomagouhi hi gohola dumahi po ega yaka hi ibaabani hi pa, ‘Nugote geka Besinana lawana tauna Dawita gogana?’ ");
INSERT INTO tbo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Palisi lawahi tuwegana hi nonoli po tunawahi ma hi ibaabani hi pa, ‘Palouma hai bada Tomodulele Yesu balau i weleya po uyahinei alugo apapoehi e iyagahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu hai winugonugotuhu amaka i hanapugeya yaka uyahihi i baha i pa, ‘Apo ani taniwaga gehouna u tipolina ina gunakahaya po hina igawigawiyena mehi apo hai mae ina apapoe. Mei gasi apo guguni emosi ma ina gunakahaya po hina igawiyena mehi apega hina towolo kadidili. ");
INSERT INTO tbo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Uyahinei ma inapa Tomodulele anani taniwaga ina gunakahaya po bolu ina luluwageya po hina igawigawiyena mehi apo iyowai a kadidili galenana. ");
INSERT INTO tbo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taumi o baha o pa, Tomodulele a wipoya uyahinei a wobagibagi po alugo apapoehi a iyagahi, yaka taumi omi lawa iyowai he iyaga. Tauhi uyahihiyei nugotuhu dumaluna apo ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tamogi inapa Yaubada Alugona uyahinei alugo apapoehi ana iyagahi yaka Yaubada anani taniwaga amaka i nei uyahimi. ");
INSERT INTO tbo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Ani galena gehouna ipa a paliwelemi, ega emoemotana lawa kadikadidilina a numa ta luiya po a gapola ta danenehi. Inapa numana taniwagana ta womomohi po aena ma nimana ta panipanihi yaka apo ta lui a numa u hinena po a gapola ta danenehi. ");
INSERT INTO tbo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Iyai ega tau miteu yaka tauna e igawiyeu. Ma iyai ega tau miteu to nugoemota yaka tauna tu’mnoha. ");
INSERT INTO tbo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Uyahinei a paliwelemi lawa hai apapoe po gasi hai baha woapapoehi atapuhi Yaubada apo ina paligigilihi. Ma Alugo Woiyawa uyahina ta baha apapoe ega emoemotana po ita apapoe ina paligigilihi. ");
INSERT INTO tbo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Apo lawa gehouna ina baha apapoe tau Lawa Moinau uyahiu yaka apo Yaubada ina paligigili. Tamogi iyai Alugo Woiyawa ina paliguyoguyougeya yaka geka hougana po houga he nenei uyahihi tauna apega Yaubada ina paligigili.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Mayau dewadewana ugo dewadewana e ugugogeya, ma mayau kakai ugo apapoena e ugugogeya. Yaka ugo emosi po emosi uyahinei apo ta galena tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Taumi tu apapoe mei mota natunatuna, yaka ega emoemotana po baha dewadewahi ona bahehi, babana taumi tu apapoe po omi winugonugotuhu u nugonugomi he memae naka tauhi gamomiyei o bahebahena geletehi. ");
INSERT INTO tbo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lawa dewadewana u nugonugona ginouli dewadewahi he memae apo ina hauhopunehi. Ma lawa apapoena u nugonugona ginouli apapoehi he memae apo ina hauhopunehi. ");
INSERT INTO tbo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A paliwelemi iyeta libahibahi uyahina lawa hai baha apapoehi atapuhi ubeihi Yaubada apo ina lubayadehi po anohi hina bahena geletehi. ");
INSERT INTO tbo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Omi baha uyahihiyei Yaubada apo ina kawaidewedewemi, ma omi baha uyahihiyei Yaubada apo ina kawaiapapoenimi.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Palisi lawahi po lugagayo tanitaniwagahi Yesu hi lubayadeya hi pa, ‘Bada, to luhogaleya ipa om manini wekiwekilalana una dewaya po to galeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu i baha nae uyahihi i pa, ‘Taumi geka hapanana hapa apapoena po matami hi maga. Omi luhogala ipa manini Yaubada uyahimi ina woogeleteya. Tamogi apega manini gehouna ina wogeleteya uyahimi ma wekiwekilala tu bahapiko Yona i woogeleteya tunawana. ");
INSERT INTO tbo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Babana Yona tauna iyana baneina i lumehaya po u koibana i memae iyeta tonuga ma ididibala tonuga, mei tau Lawa Moinau apo iyeta tonuga ma ididibala tonuga hipuli ina lumehau po u hinena a memae. ");
INSERT INTO tbo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Libahibahi Iyetana uyahina apo Ninewa lawahi hina towolo po hina wigoumi. Matababana Yona a guguya hi noonoli po hai apapoe hi palihalehi. Ma a paliwelemi, geka hosi lawa gehouna i geduma ma apoma Yona. ");
INSERT INTO tbo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tupo yawana hai wasawasa wawinena apo Libahibahi Iyetana uyahina ina towolo po ina libahibahimi. Matababana hipuli anani kokoe uyahina ma i nei po Solomona a wiatatiyana hanahanapu i nonoli. Ma a paliwelemi, geka hosi lawa gehouna i geduma apoma Solomona.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Hougana alugo apapoena lawa ina hopu haleya naka dobu ega ita igoila e yayahi po e nenae ani wiyagohina e bibeiha. Ma inapa ega emosi ina tuhagaya ");
INSERT INTO tbo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yaka apo tunawana ina baha ina pa, “Apo a gunawilena meu u numa a nenehaleya uyahina.” Ma hougana i gunagunawileya po numana kokoena po yeuyeuna po ginouli hi houna imahiyehi ma i galeya. ");
INSERT INTO tbo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yaka apoma apo ina nae po alugo apapoe dumahi magouhi 7 ina weluwinihi po hina lui po noka hosi hina mae. Uyahinei mehougana hina meyato po ina kokoe yaka naka lawana a mae apo ina apapoe duma ma apoma lolowa. Galenana mei geka taumi hapanana apo omi apapoe hina lata lagona duma.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu bolu uyahihi i ibaabani ma walewalehina hinahi mitehi hi nei po hoi uputa hi towolo ma hi laubayadeya, hai luhogala ipa mitehi hina wibaabani. ");
INSERT INTO tbo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ega yaka lawa gehouna i nae po Yesu i paliweleya i pa, ‘Walewalehim hinami mitehi hi luhogalem ipa ona wibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu lawana a baha i wimiheya i pa, ‘Hinau iyai? Ma walewalehiu iyawoi nawa?’ ");
INSERT INTO tbo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ega yaka tu wotagona atapuhi i winimayoyogehi i pa, ‘Geka taumi hinahinau ma walewalehiu. ");
INSERT INTO tbo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Matababana apo iyai Amau hoi yada a nugotuhu ina dewadewaya naka tauna walehiu po nouwe po hinau.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Noka iyetana uyahina Yesu numa hinenei i hopu po i nae boga u liyaliyana po i memae. ");
INSERT INTO tbo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma bolu baneina hi’mboina mai uyahina ma ega yaka wam uyahina i gelu po i tugula imahi ma bolu hoi dedeyani hi towotowolo, ");
INSERT INTO tbo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ma ega yaka baha wiluwaluwagei ginouli magomagouhi i wiatatiyehi i pa, ‘Tu lupehi i nae a tano uyahina po a pehi polahi i nohanohahi. ");
INSERT INTO tbo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","I ihulu po pola gehouhi hi peu tahaya u liyaliyana ma kiu hi nei po hi anihi. ");
INSERT INTO tbo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma pola gehouhi hi peu dobu waigaigaimana uyahina po hi laha yagiyaginehi babana hipulina ega ita potopoto. ");
INSERT INTO tbo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma kabudala a houga lalana uyahina mala emosi ma hi kokodila, babana dedehi ega hipuli dewadewana hita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma pola gehouhi hiyamoni waidonadonana u hayahi hi peu po hougana hi lahalahahi naka donadona i numa panipani unihi. ");
INSERT INTO tbo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma pola gehouhi hipuli dewadewana uyahina hi peu po hi lata po hi ugo. Hai houga ugo naka gehouhi hi ugo labatana ma gehouhi ega hit’ugo duma ma gehouhi ega hit’ugo imahi. ");
INSERT INTO tbo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Taumi iyawoi waitanigami yaka ona launonola.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesu a hewahewali hi nei uyahina po hi lubayadeya hi pa, ‘Awai binei bolu uyahihi baha wiluwaluwagei u wiatatiyehi?’ ");
INSERT INTO tbo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu hai baha i wimiheya i pa, ‘Taumi Yaubada anani taniwaga baha gowagowadana i lugeleteya uyahimi. Ma geka boluhihi baha wiluwaluwa geka hi nonoli ma anona ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Matababana iyai uyahina awai dewadewana e memae apo Yaubada ina luwitani tauna uyahina yaka luwitana baneina ina tuhagaya. Ma iyai uyahina ega ginouli gehouna ita memae, awai habuluna e memae apo Yaubada ina wihaleya. ");
INSERT INTO tbo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Geka binei ma baha wiluwaluwagei a iatatiyana babana “Apo hina ihalugeya ma apega hina galena tuhaga po apo hina lutanigana ma apega hina hanapugeya.” ");
INSERT INTO tbo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Uyahinei ma odubona Isaiya baha i bahebaheya i lugeleteya i pa, “Apo ona nonoli ma tamogi apega ona hanapugeya. Apo ona galeya ma tamogi apega u nugonugomi ina lugiigili. ");
INSERT INTO tbo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Matababana lawahi tanigahi hi pota, po palihi hi bagibagi, yaka apega tanigahiyei hina nonoli ma matahi hi keke po apega hina galeya ma u nugonugohi apega ina lugiigili, yaka apega hina nugobui po a wiluyagohanihi.” ");
INSERT INTO tbo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Ma taumi ona kaoha duma babana matamiyei o galeya ma tanigamiyei o nonoli. ");
INSERT INTO tbo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A baha duma uyahimi, naka awai o gagalehi tu bahapiko po tu dewadumalu odubohi hai luhogala ipa hina galehi ma ega hita galehi. Ma awai o noonolihi hai luhogala ipa hina nonolihi ma ega hita nonolihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Pehi tu wihuluna baha wiluwaluwana anona ona nonoli. ");
INSERT INTO tbo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Apo lawa awai Yaubada anani taniwaga bahana ina nonoli ma ega nugonugona ina lugiigili naka galenana mei Tomodulele i nei po bahana u nugonugona i wihaleya, bahana anona naka pola hoi tahaya hi pipeu. ");
INSERT INTO tbo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma pola dobu waigaigaimana uyahina hi pipeu naka anona iyai amaka anai kaohana Yaubada a baha i nonoli, ");
INSERT INTO tbo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","tamogi ega dedena uyahinei ma e itumagana po ega daona ma witai po pilipili i wialonihi naka amaka e peu. ");
INSERT INTO tbo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma pola hiyamoni waidonadonahi u hayahi hi pipeu anona naka iyai amaka Yaubada a baha i nonoli ma tamogi hipuli genona ma gapola wasawasahi nugona i waya po bahana ega ita luhogaleya yaka ega emoemotana po ugona ina houni. ");
INSERT INTO tbo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma pola hipuli dewadewana uyahina hi pipeu anona naka lawa tauhi baha hi nonoli po hi hanapugeya yaka apo hin’ugugo. Gehouhi hi ugo labatana ma gehouhi ega hit’ugo duma ma gehouhi ega hit’ugo imahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu baha wiluwaluwa gehouna i paliwelehi i pa, ‘Yaubada a taniwaga galenana mei lawa gehouna a pehi dewadewana i nae po a tano uyahina i ugohi. ");
INSERT INTO tbo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma uguwei i eneno ma upom bolinai a gawiya lawana i nei po a tanona uyahina pehi apapoena i ugohi ma i nehaleya po i nae. ");
INSERT INTO tbo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma hi laha gogonehi po hi lata apoma ugohi gagalenahi uyahihiyei ma hi galena tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‘Ega yaka badana a tu bagibagi hi nae po hai taniwaga hi paliweleya hi pa, “Bada, lolowa pehi dewadewana u nei po ugohi om tano uyahina, ma iyowai po pehi apapoehi mitehi hi laha gogonehi po hi lata?” ");
INSERT INTO tbo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Ma tano taniwagana i paliwelehi i pa, “Nugote u gawiya gehouna i nei po i ugohi.” ‘Ega yaka a tu bagibagi hi baha nae hi pa, “Iyowai, apo pehi apapoehi to hapuhapuhalehi?” ");
INSERT INTO tbo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ma hai badana i baha i pa, “Amaka ma hina lata gogona babana apo ona’mhapuhapu po pehi dewadewahi mitehi ona hapu gogonehi. ");
INSERT INTO tbo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ma houga omlohi hougana uyahina tu bagibagi apo a paliwelehi po pehi apapoehi hina hapuhapuhalehi ma hina lugogonihi po hina apuhi, ma pehi dewadewahi hina tuwaluhi po hina houna luiyehi hanali u hinena.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Baha wiluwaluwa gehouna i paliwelehi i pa, ‘Yaubada anani taniwaga galenana mei lawa ihagila polana e waya po a tano uyahina e ugohi. ");
INSERT INTO tbo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma ihagilana polana i habulu duma ma a houga lata uyahina i wimayau baneina po i lata lagona ma kiu he liya mai uyahina po hai pata he wogowogohi.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Baha wiluwaluwa gehouna i paliwelehi i pa, ‘Yaubada anani taniwaga galenana mei palawa ani lihaahanana wawine e waya po palawa humahi tonuga uyahihi e houna hopunehi. Ma e mudamudaya po palawana atapuna e hahana pahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu a wibaabani atapuna naka baha wiluwaluwa uyahinei bolu i atatiyehi babana tauna a dewa dumana baha wiluwaluwa wiatatiyanana. ");
INSERT INTO tbo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Geka dewana uyahinei ma ipa tu bahapiko gehouna a baha anona ina lugeletena imahiyeya. ‘Baha wiluwaluwagei uyahihi a ibaabani, po Yaubada hipuli i iwawali ma ginouli i huhouna gowadihi a paligeletehi.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu bolu i nehalehi po i lui hoi numa, ma a hewahewali hi nae uyahina po hi lubayadeya hi pa, ‘Pehi apapoena baha wiluwaluwana anona una liyayahi po to hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ega yaka Yesu i paliwelehi i pa, ‘Pehi dewadewana tu liholina naka tau Lawa Moinau. ");
INSERT INTO tbo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma tano naka hipuli tupo wohepali ma pehi dewadewahi naka Yaubada a taniwaga tu wotagona ma pehi apapoehi naka Tomodulele a taniwaga tu wotagona. ");
INSERT INTO tbo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma pehi apapoehi tu ugohina naka Tomodulele, ma houga om lohina naka houga anani kokoe, ma tu hounaboiboina naka tu winoyanoya hoi yada. ");
INSERT INTO tbo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‘Apo houga anani kokoe uyahina tu apapoe lawahi galenahi mei pehi apapoehi apo hina lugogonihi po hina apu halehi. ");
INSERT INTO tbo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Apo tau Lawa Moinau u tu winoyanoya mi yadena a himilihi po apapoe tu dewana po tu nugogobu atapuhi hina lugogonihi mai u ani taniwaga u upuna, ");
INSERT INTO tbo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","po hina wihulu hopunehi mayau alalatana u hinena, naka tuponana uyahina tou po omhanakidiyana hina tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Houga naka uyahina tauhi tu dumalu lawahi apo hina lui Amau anani taniwaga u hinena po hina namanamalihi, gagalenahi mei kabudala namalana. Apo iyai waitanigana yaka u baha geka ina nonoli po ina nonola imahiyeya po ina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‘Yaubada a taniwaga galenana mei gapola gegena hoi hipuli i memae ma lawa gehouna i tuhugaya po i gowada imahiyeya ma anai kaohana i nae po a gapola atapuhi i gimalena halehi ma a gapolahi mihahi uyahinei tanona i gimaleya po gapola gegena i wialoni. ");
INSERT INTO tbo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Yaubada a taniwaga mei giniuba matana dewadewana e memae ma lawa gehouna a luhogala ipa hilaki ita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yaka apo a gapola ina halehi po iyawe pelina giniuba matana dewadewa dumana ina waya. ");
INSERT INTO tbo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Ma Yaubada anani taniwaga galenana mei tu ebaebaga hagida u boga he teleteleneya ma iyana atapuhi he onona, ");
INSERT INTO tbo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ma hagidana ina hogoya ma hina teina geleteya po hoi hayahaya hina tugula ma iyana hi onona hina wikahahi po dewadewahi hoi gaeba hina hounihi ma apapoehi hina wihulu hopunehi. ");
INSERT INTO tbo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Apo naka pitenana houga anani kokoe uyahina tu winoyanoya mi yadena hina nei po tu apapoe hina kahahi tu dewadewa u hayahi ");
INSERT INTO tbo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","po hina wihulu hopunehi mayau alalatana u hinena po tou ma omhanakidiyana hina tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu i lubayada nae uyahihi i pa, ‘Geka baha luwaluwahi a palipaliwelemi amaka o hanapugehi, bo eega?’ Ma hi baha hi pa, ‘Ee.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ega yaka i paliwelena mehi i pa, ‘Lugagayo tanitaniwagahi atapuhi baha gilugilumana odubona hi hanapugeya ma Yaubada a taniwaga hi wotagoya, yaka tauhi mei tu waigapola lawana a hanali gapolana wouna po odubona i houna geletehi a numa hinena uyahinei.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu a baha wiluwaluwa geka i wikokowi ma tupo noka i nehaleya, ");
INSERT INTO tbo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","po i nae tauna a meyagai dumana uyahina po hai numa tapalolo uyahina i lui po i atatiyana lawa uyahihi. Ma nugonugohi hi gohola dumahi ma hi ibaabani hi pa, ‘Geka lawana meka hotanana a hanapu po a manini i tuhagahi? ");
INSERT INTO tbo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Geka lawana amana kamda ma hinana Maliya ma walewalehina Yamesa ma Yosepa ma Simona ma Yuda, ");
INSERT INTO tbo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ma nounouna mitehi ta memae ma iyowai po a hanapu geka pitenana gagalenahi?’ ");
INSERT INTO tbo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ega yaka Yesu hi wihinigigiyeya. Ma i paliwelehi i pa, ‘Tu bahapiko u tupo geha lawa hi wiyateyateya ma a meyagai po a guguni ega hita wiyateyateya.’ ");
INSERT INTO tbo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yaka Yesu a manini i dewadewahi ega hita maga babana ega hita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Houga noka uyahina Heloda tu wasawasa Yesu a bagibagi tuwegana i nonoli. ");
INSERT INTO tbo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ega yaka a tu bagibagi i paliwelehi i pa, ‘Nugote Yoni tu bapatiso hilage uyahinei i towolo meme po manini geka e dewadewahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tauna Yonina lolowa Heloda i numa panipani po hoi numa panipani i houni, a lui babana wawine gowana Helodiyasi naka Pilipo agona. ");
INSERT INTO tbo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Helodana walehina Pilipo ma agona i haloya. Uyahinei Yoni i gagaleya po ega ita dumalu yaka i baha nae Heloda uyahina i pa, ‘Ega naka ita dumalu babana tulam agona ma u lawagi.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hougana Yoni hoi numa panipani i memae Heloda i luhogaleya ipa Yoni in’uni ma ega emoemotana babana lawa magomagouhi Yoni hi kawatubahapikogeya po Heloda i matouta po ega it’uni. ");
INSERT INTO tbo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma hi memae po Heloda a houga guni iyetana i geleta, po a houga gunina tolehana i dewaya. Ma Helodiyasi natuna wawinena i hopu po Heloda u matana i halahala ipa ina kaoha. ");
INSERT INTO tbo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Guguhinina a hala binei ma Heloda i kaoha duma po i baha gwala natuna guguhinina uyahina i pa, ‘Inapa awai om luhogala yaka apo geka hougana a welem.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ega yaka guguhinina i nae po hinana uyahina i baha i pa, ‘Apo awai u luhogala Heloda uyahina a baheya?’ Ega yaka hinana i pa, ‘Una nae po una baha una pa, “A luhogaleya ipa Yoni tu wibapatiso unununa hoi gaeba una houni ma una weleu.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Geka bahana Wasawasa i noonoli po nugonugona i wiyuwa duma, ma tamogi a bahagwala tu witoumanena amaka hi nonoli ega yaka i palihaleya. ");
INSERT INTO tbo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yaka tu bagibagi i himilihi po hi nae hoi numa panipani po Yoni gadouna hi boli ");
INSERT INTO tbo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","po hoi gaeba hi houni ma hi niyeya po guguhinina hi weleya, ma guguhinina i waya po i niyeya hinana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ma Yoni a hewahewali hi nei po hinina hi waya po hoi kokowaga hi guluwi, ma hi nae Yesu hi paliweleya. ");
INSERT INTO tbo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu tuwega geka i nonoli yaka wam uyahina i gelu po i nae hoi balabala yabayababa. Ma bolu Yesu a naena amaka hi hanapugeya hai meyagai hi nehalehi po tahayagei hi nae po Yesu uyahina hi geleta. ");
INSERT INTO tbo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu wam uyahinei i huhopu po bolu baneina i gagalehi po i galena lunugotootogogehi yaka tu tootogo i widewadewahi. ");
INSERT INTO tbo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma amaka aipompom ma ega yaka a hewahewali hi nae po Yesu hi lubayadeya hi pa, ‘Bada, geka dobuna naka balabala yabayababa, ma kabudala amaka i yoli yaka geka lawahi boluhi una himilihi po hina nae hoi meyagai po hai am hina gimala.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu hai baha i wimiheya i pa, ‘Apega hina nae; taumi aniani ona welehi po hina am.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A hewahewali hi baha hi pa, ‘I am ega ita lata palawa magouna nimitutu ma iyana luwaga.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu i baha i pa, ‘Palawa ma iyana ona weleu.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma i baha po bolu hi tugula hoi hiyamoni ma Yesu palawahi nimitutu ma iyanahi luwaga i winihi po i galena gae hoi yada ma Yaubada uyahina i wimaamala. Ma i’mtomutomu po i kokoe ma a hewahewali i welehi po hi gutaya bolu uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Lawa atapuhi hi’mam po hi’mhiyougo ma yaniyani tupotupona hi tutuwaluta meya naka poha magouhi 12 hi lihogohi, ");
INSERT INTO tbo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lawa hi’mam hi hiyahiyawi ololoto magouhi tausana nimututu ma wiwine po logaloga ega hita hiyawihi. ");
INSERT INTO tbo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A hewahewali i paliwelehi i pa, ‘Wam ona geluya po ona tahatahaya noka u tuponana ma tau lawa a himilihi po hina nae hai u dobu.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A hewahewali hi gelu po hi nenae ma Yesu bolu i himilihi po hi nenae ma tauna tunawana i gae hoi oya ipa ina lupali. Ma amaka aipom ma Yesu tunawana hoi oya i memae. ");
INSERT INTO tbo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A hewahewali tunawahi wamgei hi woe hopu po boga u tipolina, ma togowa po guletutu hi wialonihi, ma gasi togowana hai wam naonei i togo mai po hai wam i laududu meya. ");
INSERT INTO tbo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kikina ipa apo malinatom, ma Yesu i nei po boga tepanei i nenae po a hewahewali u liyaliyahi i geleta. ");
INSERT INTO tbo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yesu hi gagaleya ma boga tepanei i nenei uyahihi ma hi matouta duma po hi taatawa ma hi iototu hai nugotuhu hi pa lawa hilahilagena alugona hita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma Yesu i baha nae uyahihi i pa, ‘Awai matoutana? Ona nugomotu, Tau.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ega yaka Pita i baha nae uyahina i pa, ‘Guyau, inapa tam yaka una baha po boga tepanei a nehi uyahim.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu i pa, ‘Una nei.’ Ega yaka Pita wam uyahinei i hopu po ipa boga tepanei ina nae Yesu uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","i tunae kikeina ma guletutu i gagalehi po i matouta ma i halehalele, yaka i otu i pa, ‘Guyau, una haguwe.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu i wogo nae Pita uyahina po i lunimani, ma i baha i pa, ‘Om witumagana i habulu duma awai binei e lauluwaluwaga.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hai luwagahi hi gelu geleta hoi wam ma togowa i dumoli. ");
INSERT INTO tbo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wam tu gelugeluna atapuhi Yesu hi wotalagiyeya hi pa, ‘Moina dumana tam Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hi damana po Genesaleta u tuponana hi gota. ");
INSERT INTO tbo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma meyageina tu miyena Yesu hi galena tuhagaya yaka hi nae po hai tu tootogo meyagai atapuhi uyahihi hi paliwelehi po hi neihini mai Yesu uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","po hi lubayada hi pa, ‘Bada, emoemotana apo tu tootogo geka om kaleko hita wogodadani?’ Ega yaka i baha po a kaleko hi wodadani ma hi luyagohana meme hai totogo uyahihiyei. ");
INSERT INTO tbo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palisi lawahi po lugagayo tanitaniwagahi Yelusalemgei hi nei po hi lubayada Yesu uyahina hi pa, ");
INSERT INTO tbo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‘Awai binei po om hewahewali am binei ega hita inimaoga ma googata hai lugagayo he tutulagoni?’ ");
INSERT INTO tbo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu hai lubayada i wimiheya i pa, ‘Taumi Yaubada a lugagayo o tutulagoni, babana taumi Yaubada a lugagayo o wihinigigiyeya ma omi lugagayogei o iatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yaubada a lugagayo i baheya i pa, “Amam ma hinam una wiyateyatehi, apo lawa awai hinana ma amana ina kawaiapapoehi yaka hina lihilageni.” ");
INSERT INTO tbo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Naka lugagayona o wihinigigiyeya ma taumi omi lugagayogei o baheya o pa, apo lawa awai hinana ma amana ina palihalehi po ina pa, “U gapola atapuna amaka a palihaleya Yaubada uyahina po ega emoemotau a hagumi.” ");
INSERT INTO tbo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yaka naka lawana a hagu po a wiyateyate amana ma hinana uyahihi i kokoe. Omi babada hai lugagayo uyahinei Yaubada a baha o laiyababaya. ");
INSERT INTO tbo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Taumi tu wikoyakoyama dumami, naka binei Yaubada a baha Isaiya tu bahapiko i gilumi i pa, ");
INSERT INTO tbo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Geka lawahi gamohi yawa e bahabaha wiyateyateu ma nugonugohi hi mebala dao uyahiugei. ");
INSERT INTO tbo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Uyahiu he tapatapalolo yababa, babana hai wiatatiyana ega tau uyahiugei ma tauhi hai winugonugotuhugei.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ega yaka Yesu a lawa i otugehi po hi nei uyahina ma i paliwelehi i pa, ‘Ona lutanigana po ona hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yaniyani emosi po emosi gamomiyei o anani ega emoemotana po ina wiapapoenimi, ma awai gamomiyei e gelegeletai naka tauna e iapapoenimi.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesu a hewahewali hi nei uyahina po hi baha hi pa, ‘Amaka u hanapugeya geka om bahana binei ma Palisi lawahi he nugonugoapapoe uyahim?’ ");
INSERT INTO tbo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu i baha i pa, ‘Amau yadei mayau ega ita ugugohihi apo yohola ina hapuhapuhalehi. ");
INSERT INTO tbo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Palisi lawahi hawehi hina memae a sigana hina peu, babana tauhi taniwaga matahi i likekeya. Inapa tu matakeke tulana ina weluwaya yaka apo hoi domo hina peu gogona.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita i lubayadeya nae i pa, ‘Om baha wiluwaluwa gamo binei anona una paliweliyai po u nugonugoiyai ina lugiigila imahiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu i baha nae uyahihi i pa, ‘Taumi gasi nugote yohola ega nugonugomi hita lugiigilihi? ");
INSERT INTO tbo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Anona gegeka yaniyani awai o ani po e luilui u amamohi houga kukuna ma apo ina hopu meme hoi nudanuda. ");
INSERT INTO tbo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma baha awai gamomiyei e gelegeleta naka nugonugomi hi nenei e gelegeletai naka tauna apo ina wiapapoenimi. ");
INSERT INTO tbo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Geka ginoulihi nugonugomi hinehiyei he gelegeleta nugogobu, omunugo, wihola, matamaga, danene, baha koyakoyama, widibodiboga. ");
INSERT INTO tbo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Geka ginoulihi tauhi lawa he iapapoenihi, ma inapa ega ta winima oga ma tan’omam naka apega alugota ina wiapapoeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mi Isalaela hai tupo Yesu i nehaleya po i nae Taya ma Saidoni tupohihi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma Kanani wawinena gehouna i nei Yesu uyahina po i baha i pa, ‘Guyau, tam Dawita gogana, una lunugotootogogeu, babana natuwe wawinena alugo apapoena i luiya po i totogo.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu wawinena a baha ega ita wimiheya, ma a hewahewali hi nei po uyahina hi baha nae hi pa, ‘Wawinena una himili po ina nae babana i wihinigaligali duma.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu hai baha i wimiheya i pa, ‘Tau u nei Isalaela u hinena sipi hi laugowadehi a bihehi, ma ega tupo gehouhi ubeihi ata nei.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wawinena i nae po Yesu u aena i polou ma i baha i pa, ‘Guyau, una haguwe.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu i baha nae uyahina i pa, ‘Ega a dumalu po logaloga hai yam kedewa ta welehi.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma wawinena Yesu a baha i wimiheya i pa, ‘Guyau, naka baha dumana, ma kedewa logaloga hai am hamomouna he lemolemoya.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu i baha nae wawinena uyahina i pa, ‘Tinani baneina wawine, tam tu witumagana wawinem, yaka om witumagana anona apo ina lugeleteya.’ Houga naka uyahina wawinena natuna i luyagohana meme. ");
INSERT INTO tbo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu tupo noka i nehaleya po Galili bogana liyaliyanei i nenae po i gae hoi oya yaka i tugula. ");
INSERT INTO tbo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma bolu baneina lawa tootogohi hi nehinimai Yesu uyahina, daladalahi, po matahi keekehi po nimahi habehabeluhi po wobadebadehi, po gasi totogo gehouhi. Tauhi hi nehinimai Yesu aena u babana po i widewadewahi. ");
INSERT INTO tbo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma lawa magomagouhi hi gagalena po badebade lawahi hi ibaabani ma nimahi habehabeluhi hi kadidili, ma daladalahi hi towolo po hi nenae, ma matahi keekehi matahi hi lugiigilihi, lawa mi Isalaela hai Yaubada hi wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu a hewahewali i otugehi po hi nae uyahina ma i baha uyahihi i pa, ‘Lawa geka nugonugou i wiyuwena dumahi, babana iyeta tonuga uyahita hi memae ma ega kikina hai yam, yaka ega ata luhogaleya ipa anai omhilagehi ta himila mehi po hina nae babana apo hoi tahaya kamnahi hina apapoe.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma a hewahewali hi baha nae uyahina hi pa, ‘Geka balabala yabayababa ma iyowai apo yaniyani ta tuhagaya po bolu geka ta wianihi?’ ");
INSERT INTO tbo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu i lubayadena mehi i pa, ‘Omi palawa wabihaga he memae.’ Ega yaka hi paliweleya hi pa, ‘Palawa magouhi 7 he memae, ma iyana muhomuhohi ega hita maga.’ ");
INSERT INTO tbo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ega yaka i baha po lawa boluhi hi tugula hoi hiyamoni. ");
INSERT INTO tbo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma palawa magouhi 7 i winihi ma iyana, ma Yaubada uyahina i wimaamala. Ma i’mtomutomu po i kokoe ma a hewahewali i welehi po hi gutaya lawa uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Lawa atapuhi hi’mam po hi’mhiyougo ma yaniyani tupotupona hi tutuwaluhi naka poha magouna 7 hi lihogohi. ");
INSERT INTO tbo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lawa hi’mam a lata hi hiyahiyawi naka ololoto magouhi tausana wohepali, ma wiwine po logaloga ega hita hiyawihi. ");
INSERT INTO tbo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu lawa boluhi i himilihi po hi nenae ma wam uyahina hi gelu po hi nae Magadini u tupona. ");
INSERT INTO tbo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Houga gehouna Palisi lawahi ma Sadusi hai bolu hi nei Yesu uyahina po hina ludadani po hi lubayadeya ipa wekiwekilala yadei gehouna ina dewaya. ");
INSERT INTO tbo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ega yaka Yesu i baha nae uyahihi i pa, ‘Heki, kabudala a yoli ona galeya hoi tupo yalasi e imagomagololo yaka o pa, “Hoimalatom apo houga dewadewa.” ");
INSERT INTO tbo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma inapa malatomtomgei ma kabudala ina geleta po yada ina kaya yaka o pa, “Noka gadiwewe a wekiwekilala.” Taumi houga apo galenana iyowai naka yada o galehi ma o ipikogehi. Tamogi iyowai po geka hougana Yaubada a bagibagi anona ega emoemotami ona baheya. ");
INSERT INTO tbo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Taumi geka hapanana hapa apapoena po matami hi maga. Omi luhogala ipa manini wekiwekilalana Yaubada uyahimi ina woogeleteya. Tamogi apega manini gehouna ina wogeleteya uyahimi ma wekiwekilala Yona i woogeleteya tunawana.’ Ma Yesu i nehalehi po i nae. ");
INSERT INTO tbo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A hewahewali mitehi hi damana u tuponei, ma hai palawa nugohi i guluwi po ega hita waya. ");
INSERT INTO tbo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma Yesu i baha nae uyahihi i pa, ‘Ona gagalena imahi Palisi po Sadusi hai palawa ani lihaahanana naka nugohine gowagowada.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesu a hewahewali tunawihi ma hi ibaabani hi pa, ‘Geka a nugotuhuna binei ma ata palawa nugota i guluwi po ega tata waya.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Yesu hai wibaabani gowada amaka i hanapugeya, ega yaka i lubayadehi i pa, ‘Awai o ibaabaniyeniya, ega omi palawa, bo? Nugote ega ota witumaganeu, po yohola ega ota galena tuhagau. ");
INSERT INTO tbo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ona nugotuhuya lolowa palawa magouhi nimitutu uyahinei lawa magouhi tausana nimitutu iyanihi ma tupotupona o tuwaluta meya po poha magouhi 12 o leihogohi. ");
INSERT INTO tbo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma gasi lawa magouhi tausana wohepali palawa magouhi 7 uyahinei a ianihi, ma tupotupona o tutuwaluhi poha magouhi 7 o leihogohi? ");
INSERT INTO tbo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ma taumi iyowai po ega nugonugomi hita lugiigilihi, palawa binei ega ata ibaabani? Ma tamogi a baha wiluwaluwa Palisi po Sadusi hai ani lihaahana ona matuteya.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Geka a bahana uyahina ma a hewahewali nugonugohi hi lugiigilihi, ega palawa binei ita ibaabani ma Palisi po Sadusi hai wiatatiyana koyakoyama ipa uyahinei hi lowolowo. ");
INSERT INTO tbo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu mitehi hi nae Sisaliya Pilipai u tuponana, ma a hewahewali i lubayadehi i pa, ‘Ona paliweleu, lawa hi pa Lawa Moinau tau iyai?’ ");
INSERT INTO tbo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma a baha hi wimiheya hi pa, ‘Lawa gehouhi hi pa tam Yoni bapatiso, ma lawa gehouhi hi pa tam Elaisiya, ma lawa gehouhi hi pa tam Yelemaya bo tu bahapiko odubona gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Apoma a hewahewali uyahihi i baha nae i pa, ‘Ma taumi omi nugotuhu o pa tau iyai?’ ");
INSERT INTO tbo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma Simona Pita a baha i wimiheya i pa, ‘Tam Yaubada Lauyagohanana Natuna ma a Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu i baha nae Simona uyahina i pa, ‘Simona, tam Yoni natuna, a baha duma uyahim, tam lawa kaokaoham, babana om hanapu geka ega tam uyahimgei, ma Amau hoi yada a hanapu i welem. ");
INSERT INTO tbo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yaka a paliwelem, tam gowam Pita, anona gaima kadikadililina, apo gaima geka u tepana u bolu a witowolihi po hilage apapoena a kadidili ega ina wogowogodadanihi. ");
INSERT INTO tbo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Apo Yaubada anani taniwaga ani’mhoena a welem, po ginouli hoi hipuli una hoeya yaka hoi yada hina hoeya, ma ginouli hoi hipuli una guduya yaka hoi yada hina guduya.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naka hotanana ma Yesu i baha kadidili uyahihi i pa, ‘Ega kikina lawa gehouna ona palipaliweleya ona pa, “Yesu Besinana lawana.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naka hougana uyahina i wiwawala po a hewahewali i wiatatiyehi i pa, ‘Apo ta nae Yelusalem po noka hotanana wiyuwa galenahi magomagouhi a wialonihi, mi Yudeya hai tanitaniwaga po tu witalaguyaba babadahi po lugagayo tanitaniwagahi uyahihiyei. Ma apo hin’uniu po iyeta witonugana uyahina a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ega yaka Pita i weluwaya po hi tunae uheiya ma i baha kadidili uyahina i pa, ‘Guyau, ega a dumalu ipa geka dewana uyahim ina geleta.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu i luhagawileya po i baha nae Pita uyahina i pa, ‘Tomodulele, geka hougana una nehaleu, ega una laipeuniu om winugonugotuhu mei lawa hota hai winugonugotuhu, ma ega mei Yaubada a nugotuhu.’ ");
INSERT INTO tbo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ega yaka Yesu a hewahewali i paliwelehi i pa, ‘Inapa lawa awai nugonugona ina wotagou yaka a luyagohana ina palihaleya. Ma anani take ina awali ma ina wotagou. ");
INSERT INTO tbo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Apo iyai ega biugei ina hilage yaka apo yautuna ina halehi. Ma iyai tau biugei ina hilage apega yautuna ina halehi. ");
INSERT INTO tbo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inapa iyai ina wigapola duma yaka Yaubada a dewa apo ina winugoguluwi, naka apo awai dewadewana ina tuhagaya? Ma lawa a luyagohana naka ginouli baneina. ");
INSERT INTO tbo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Babana yohola apo tau Lawa Moinau u tu winoyanoya mitehi to nenei Amau a wasawasa namanamalinei ma lawa atapuhi hai bagibagi mihana a welehi. ");
INSERT INTO tbo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A baha duma uyahimi, lawa gehoumi geka hosi o towotowolo apega ona hilage a sigana tau Lawa Moinau u taniwaga waiwasawasanei ona galeu.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iyeta magouhi 6 hi kokoe, Pita ma Yamesa walehina Yoni mitehi tunawahi weluwinihi po hi gae oya baneina u tepana. ");
INSERT INTO tbo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Oyana uyahina hi memae, ma Yesu tepana galenana i buiya a hewahewali u matahi po i namanamali mei kabudala namalana, ma a kaleko wakekena i wimatatona. ");
INSERT INTO tbo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma mala emosi ma babada odubohi hi lugeletehi po tauna mitehi hi ibaabani. Babadahi naka Mose ma Elaisiya. ");
INSERT INTO tbo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita i baha Yesu uyahina i pa, ‘Guyau, i haki duma po tauyai geka hosi. U luhogaleya ipa kape tonuga a wogohi, emosi tam bimgei, ma emosi Mose binei, ma emosi Elaisiya binei?’ ");
INSERT INTO tbo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita yohola i ibaabani ma gahu yayatana i lutatahi, ma gahuna u hinena baha hi noonoli i pa, ‘Natuwe geka a luhogaleya, tauna binei a kaoha duma; a baha ona iponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma a hewahewali baha geka hi noonoli po hi matouta duma, yaka hi guli hoi hipuli po hi lautalapupugehi. ");
INSERT INTO tbo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Yesu i nei po i limaamahihi i pa, ‘Ona towolo, ega ona matomatouta.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A hewahewali hi lauwatatehi po ega lawa gehouna hita galeya ma Yesu tunawana i towotowolo. ");
INSERT INTO tbo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oyagei hi hopuhopu mai ma Yesu a hewahewali i paliwelehi i pa, ‘Ega lawa uyahihi ona bahebaheu, awai o gagalehi, a sigana tau Lawa Moinau hilage uyahinei apo a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A hewahewali hi lubayadeya hi pa, ‘Awai binei lugagayo tanitaniwagahi hi baheya hi pa, apo Elaisiya ina tahaya mai ma u mulina apo Besinana lawana ina nei?’ ");
INSERT INTO tbo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu i baha nae uyahihi i pa, ‘Naka moina dumana, Elaisiya ipa ina tahaya mai po ginouli atapuhi ina lidumaluhi. ");
INSERT INTO tbo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A paliwelemi Elaisiyana amaka i nei, ma lawa ega hita hanapugeya, po hi wihinigigiyeya ma tau Lawa Moinau gasi apo hina wihiniwiyuwau.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yaka a hewahewalihi hi hanapugeya Elaisiya anona Yoni tu wibapatiso. ");
INSERT INTO tbo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu a hewahewali mitehi oyagei hi hopu mai bolu uyahihi, ma lawa gehouna i nei po anai wiyateyatena i polou Yesu uyahina ");
INSERT INTO tbo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma i baha i pa, ‘Guyau, natuwe una lunugotootogogeya po una luyawahi. Houga magomagouna alugo apapoena e tapeibadebadeya po u hinina wiyuwa he lalata duma. Houga gehouhi mayau alalatana uyahina e pipeu, ma houga gehouhi goila uyahina e yoliyoli. ");
INSERT INTO tbo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma om hewahewali uyahihi a neneiyai po ega emoemotahi hina widewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu i baha i pa, ‘Taumi geka hapana ega omi witumagana po apapoe lawami. Houga a dao awai apo a meme liyaliyanimi po a genogenogemi? Tewelana ona neiyai uyahiu.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu alugo apapoena i paliyeya po tewelana i hopu haleya, ma naka kabudalana i dewadewa meme. ");
INSERT INTO tbo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma Yesu a hewahewali tunawahi hi nei Yesu uyahina po hi lubayadeya hi pa, ‘Iyowai po ega emoemotiyai alugo apapoena to wiyagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Yesu i baha nae uyahihi i pa, ‘Ega alugo apapoehi ota iyagahi babana omi witumagana ega ita lata. A baha duma uyahimi, itapa omi witumagana a lata mei ihagila polana apo oya uyahina ota baha ota pa, “Una nae noka hosi,” apo ita wiponawogogemi. Tu witumagana uyahimi ginouli magomagouhi hi teyateya. ");
INSERT INTO tbo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ega tahaya gehouna po ipa apo dewa geka pitenana ta dewahi, tahaya emosi hota naka lupali po wiyohi.’ ");
INSERT INTO tbo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","U Galili atapuhi hi’mboina gogona ma Yesu i paliwelehi i pa, ‘Lawa Moinau apo hina houna damaneu lawa u nimahi ");
INSERT INTO tbo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","po hina lihilageniu, ma iyeta tonuga hina kokoe ma apo a towolo meme.’ Yesu a baha geka binei ma nugonugohi hi wiyuwa duma. ");
INSERT INTO tbo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hi nae po Kapaneum u meyageina hi memae ma numa dalabu monena tu tama hi nei po Pita uyahina hi baha hi pa, ‘Iyowai apo omi tu wiatatiyana mone ina houni, bo apeega?’ ");
INSERT INTO tbo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ega yaka Pita i baha i pa, ‘Ee, apo mone ina houni.’ Pita i gunawilena meya hoi numa, ma Yesu Pita i lubayadeya i pa, ‘Simona, om winugonugotuhu hipuli wasawasahi uyahihi iyawoi, hai mone he tamatama natunatuhi uyahihiyei, bo lawa tapuhi uyahihiyei?’ ");
INSERT INTO tbo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita i baha i pa, ‘Lawa tapuhi uyahihiyei ma ega natunatuhi uyahihiyei.’ Yesu i baha i pa, ‘Moina dumana, tauhi natunatuhi ega hai witai gehouhi. ");
INSERT INTO tbo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma tauta uyahita apo hina nugoapapoe, yaka geka hougana sili una waya ma una nae u boga po una wisili, po iyana tahatahayana un’ununi naka u gamona mone una waya, po apo ita hagu una houni tam ma tau ubeita.’ ");
INSERT INTO tbo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naka hougana Yesu a hewahewali hi nei uyahina po hi lubayadeya hi pa, ‘Iyai tauna lawa gegena Yaubada anani taniwaga uyahina?’ ");
INSERT INTO tbo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu tewela gehouna i otugeya po i nei u matahi po i towolo, ");
INSERT INTO tbo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ma Yesu i baha nae uyahihi i pa, ‘A baha duma uyahimi, inapa ega ona nugobui po mei logaloga yaka apega Yaubada anani taniwaga ona luiya. ");
INSERT INTO tbo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Apo iyai ina nugohopuhopu po mei geka tewelana yaka apo tauna ina geduma Yaubada anani taniwaga uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Apo u hayami lawa awai gowaugei logaloga mei geka tewelana ina likaohaya yaka naka tau i likaohau. ");
INSERT INTO tbo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Apo tu witumaganeu lawana a winugonugotuhu mei geka tewelana, ma lawa awai ina lipeuya, yaka a dumalu itapa gaima baneina u gadouna hita duli ma u boga dumdum hita halena hopuneya po ita yoli. Ma ega ita dewadewa geka tu tapitapiyana ina dewaya po apapoe ina dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kihoni tu mehipuli taumi tu nugodubu ani peu ludadanahi binei. Moina ani peu ludadanahi apo hina nei, tamogi iyai i dewahi po he waawala tauna tu nugodubu. ");
INSERT INTO tbo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Apo tam lawa awai aem bo nimam ina laipeunim, yaka una boli haleya. Naka ega apapoe awai, babana apo aem emosi bo nimam emosi yaka luyagohana una tuhagaya. Tamogi woapapoe dumana naka aem po nimam luwaga a dewadewahi ma apo hina halena hopunem mayau alatana ega sigasigana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mei gasi matam naka pite apo ina laipeunim yaka una wahi haleya, babana ega apapoe awai apo matam emosi hota, yaka om luyagohana ina dewadewa, tamogi woapapoe dumana uyahim naka apo matam luwaga a dewadewahi ma hina halena hopunem meyagai waipoyana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Logaloga mei geka tewelana ega ona gagalena hopuhopunehi. Tauhi hai tu winoyanoya hoi yada he memae houga magomagouna Amau u matana. ");
INSERT INTO tbo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma Lawa Moinau a nenei ipa tu welupowa lawahi a wiluyagohanihi. ");
INSERT INTO tbo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘Omi winugonugotuhu awai? Apo lawa gehouna a sipi magouhi handele emosi ma emosi ina welupowa, apo awai ina dewaya? Apo hoi oya atapuhi hina memae ma ina nae po emosina ina bibiheya a sigana ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A baha duma uyahimi, apo ina tuhagaya yaka a kaoha ina lata duma, ma magomagouhihi uyahihi ega ita kaoha duma po mei geka emosina. ");
INSERT INTO tbo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Naka pitenana Amau hoi yada e memae ega ita luhogaleya ipa tewela emosi apapoe ina wialoni po ina welupowa.’ ");
INSERT INTO tbo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu i baha meme i pa, ‘Apo walehim gehouna uyahim apapoe ina dewaya, yaka una wileta po omi luwaga ona lidumalu a apapoe binei. Ma ponam ina nonoli yaka naka i dewadewa duma, babana amaka walehim u tuhagaya po mitehi o witulana meme. ");
INSERT INTO tbo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma inapa ega ponam ina nonoli, yaka lawa emosi bo luwaga una winihi po mitehi walehimna uyahina ona wibaabani po a apapoe ina galena tuhaga imahiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma ega ina luhogaleya ipa omi baha ina nonoli, yaka tu tapalolo hai bolu uyahihi ona paligeleteya, po bolu hai baha ega ina nonoli, yaka ona palihaleya po tauna galenana mei tu meuputa bo takisi tu tama woapapoena. ");
INSERT INTO tbo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘A baha duma uyahimi, hoi hipuli ginouli awai ona numa panipani yaka hoi yada hina numa panipani. Ma ginouli awai hoi hipuli ona hoeya, yaka hoi yada hina hoeya. ");
INSERT INTO tbo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Geka hougana a paliwelemi apo taumi iyawoi omi luwaga hota hoi hipuli ona nugoemota omi luhogala binei po Amau hoi yada uyahina ona laupali, yaka apo ina dewaya bimiyei. ");
INSERT INTO tbo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Babana tupo awai uyahina lawa luwaga bo tonuga tau gowaugei hin’omboina gogona naka tau mitehi to memae.’ ");
INSERT INTO tbo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita i nae Yesu uyahina po i baha nae i pa, ‘Guyau, apo walehiu gehouna houga magomagouna uyahiu apapoe ina dewadewaya, ma mala wabihaga apo a apapoe a paligigilihi mala 7 bo mala wabihaga?’ ");
INSERT INTO tbo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ega yaka Yesu i baha nae uyahina i pa, ‘Ega una pa mala 7 hota, ma tamogi 7 magouhi 70.’ ");
INSERT INTO tbo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ega yaka Yesu baha wiluwaluwagei i paliwelehi i pa, ‘Yaubada a taniwaga mei tu wasawasa banei dumana, ma i luhogaleya ipa a tu bagibagi hai yaga hina lidumaluhi uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ega yaka i wiwawala po lawa gehouna a yagayaga mone magouhi tausana 10 i bahena geleteya. ");
INSERT INTO tbo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Geka lawana a yagayaga ega emoemotana po ipa ina lidumaluya, ega yaka tu wasawasana i baha po ipa lawana ma agona po natunatuhi, po gasi a gapola atapuhi hina gimalena halehi po mihahi tu wasawasana ina waya, ma a hewalina a yaga hina dumalu. ");
INSERT INTO tbo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‘Ma a tu bagibagina a nugodubuna i polou u matana, ma i lupali a bada uyahina i pa, “Bada, una lunugotootogogeu ma apo u yagayaga atapuna houga he nenei uyahihi a lidumaluhi.” ");
INSERT INTO tbo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ega yaka tu wasawasana a hewalina i lunugotootogogeya po a yagayaga atapuhi i paligigilihi ma a hewalina i hopu po i nae. ");
INSERT INTO tbo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‘Ma lawana i hopu po i nenae, ma tulana gehouna mone magouhi 10 i weleya po i bagibagi ega ita wimihena yagiyagineya ma i memae, ma lawana i tuhagaya po i lugadouni ma i pa, “Geka hougana om yaga uyahiu una lidumaluya.” ");
INSERT INTO tbo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Ma tulanana i polou uyahina po i lupali i pa, “Tulau, una lunugotootogogeu, ma houga he nenei apo u yaga uyahim a lidumaluya.” ");
INSERT INTO tbo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","‘Ma tulana a lupali ega ita genogeya po ponana ega ita nonoli, ma i houna luiyeya hoi numa panipani po i memae a sigana a yaga atapuna i lidumaluya. ");
INSERT INTO tbo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma hai lawa hai dewa hi gagalehi po hi nugoapapoe, yaka hi nae po tu wasawasana hi paliweleya hai lawa hi itona binei. ");
INSERT INTO tbo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","‘Ega yaka badana a hewalina i otugeya po i paliweleya i pa, “Tam tu bagibagi apapoem babana om yagayaga uyahiu ubeihi u lupali po a lunugotootogogem po a paligigilim, ");
INSERT INTO tbo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","awai binei tulam ega uta lunugotootogogeya po a yaga uyahim uta paligigili?” ");
INSERT INTO tbo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tu wasawasana uyona i gigai duma yaka i baha po numapani tu galena itetena hi paliweleya, po a tu bagibagi hi niyeya po hi houna luiyeya hoi numa panipani, po i memae a sigana a yagayaga atapuhi i lidumaluhi. ");
INSERT INTO tbo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‘Amau hoi yada apo naka pitenana uyahimi ina dewaya, inapa omi lawa hai apapoe ega ona lunugotootogogehi po ona paligigilihi yaka apega ina paligigilim.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu a wiatatiyana i wikokowi ma tupo Galili i nehaleya po i nenae Yudeya Yodani goilana i damani u tupona. ");
INSERT INTO tbo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma bolu baneina Yesu hi wotagoya po hai totogo i widewadewahi. ");
INSERT INTO tbo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma Palisi lawahi hi nei Yesu uyahina ipa hina ludadani hi pa, ‘Apo lawa agona a dewa binei ega ita kaoha, iyowai a dumalu, ipa ina haleya bo ega?’ ");
INSERT INTO tbo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ega yaka Yesu i paliwelehi i pa, ‘Yaubada a Buka uyahina gilugilumana amaka o hanapugeya, “Houga a wawala uyahina tu wiwawala lawa luwaga i wiwawalihi oloto ma wawine.” ");
INSERT INTO tbo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma baha gehouna i pa, “Oloto amana ma hinana ina nehalehi po agona ina waya po mitehi hina megogona po hai luwaga hinihi emosi hota.” ");
INSERT INTO tbo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","‘Yaka hai luwaga hina wihiniemosi ma ega hini luwaga. Oloto ma wawine hai tawine Yaubada i popo emotehi, uyahinei ega emoemotana po ta lupena halehi.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ega yaka hi lubayadeya hi pa, ‘Matababana awai po Mose lugagayo i houni i pa, “Apo lawa agona ina hahaleya yaka giluma gehouna ina gilumi po wawinena ina weleya ma apoma ina wihulu”?’ ");
INSERT INTO tbo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu hai baha i wimiheya i pa, ‘Naka omi palibagibagi tepanei ma Mose lugagayo geka i baheya uyahimi po ipa wihulu wekiwekilalana ona gilumi, yaka apoma agagomi ona hahalehi. Tamogi houga a wawala uyahinei i nenei ega geka pitenana. ");
INSERT INTO tbo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma a paliwelemi apo oloto awai agona ega ina wihola ma ina haleya, po ina tawine damana wawine gehouna uyahina, yaka naka lawana e matamatamaga.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ega yaka a hewahewali hi baha nae uyahina hi pa, ‘Inapa oloto ma wawine ita lugagayo geka pitenana yaka ega ta tawitawine.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma hai baha i wimiheya i pa, ‘Wiatatiyana geka ega lawa magomagoumi ubeimi, ma iyawoi Yaubada nugotuhu i welewelehi tauhi tunawahi. ");
INSERT INTO tbo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Matababana ololoto gehouhi hi gunigunihi po ega tawine luhogalana uyahihi ita memae. Ma ololoto gehouhi he hapihapihi po ega emoemotahi hina tawine. Ma ololoto gehouhi Yaubada anani taniwaga binei ma luhogalahi tauhi hi gudu mehi, po tawine ega hita luhogaleya. Inapa lawa awai geka dewana emoemotana yaka ina wotagoya.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ega yaka lawa gehouhi logaloga hi neihini mai Yesu uyahina ipa ina wotepanihi, ma ina lupali ubeihi. Ma a hewahewali hi paliyehi. ");
INSERT INTO tbo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Yesu i baha i pa, ‘Logaloga ona palihalehi po hina nenei uyahiu ma ega ona guduguduhi. Matababana lawa mei geka logalogahi apo Yaubada anani taniwaga hina luiya.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu nimana i lodomi po logaloga i wotepanihi, ma i nehalehi. ");
INSERT INTO tbo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tu waigapola gehouna i nei Yesu uyahina po i baha i pa, ‘Bada, bagibagi dewadewana awai a dewaya po luyagohana tuwetuwenai a tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu i baha nae uyahina i pa, ‘Awai binei e laubayadeu bagibagi dewadewana binei? Tu dewadewa emosi hota e memae, inapa luyagohana tuwetuwenai una luhogaleya yaka Yaubada a lugagayo una wotagohi.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hewalina Yesu i lubayadeya i pa, ‘Lugagayo awai?’ Yesu i baha i pa, ‘ “Ega una yamunugo, ega una matamatamaga, ega una danedanene, ega una igou koyakoyama. ");
INSERT INTO tbo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Amam ma hinam una wiyateyatehi” ma “U liyaliyam tu mae una luhogalehi po mei tam e lauhogalena mem.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma hewalina i baha i pa, ‘Geka lugagayohi a wotagohi, ma apo awai a dewaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu i baha nae hewalina uyahina i pa, ‘Apo om luhogala ipa om dewa atapuna ina dewadewa, yaka om gapola magomagouhi una gimalena halehi po mihahi tu dayadayabu una welehi. Apo hoi yada una wigapola ma una nei po una wimulitagou.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hewalina Yesu a baha i noonoli po a nugodubuna i gunawilena meya, babana a gapola hi maga duma. ");
INSERT INTO tbo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ega yaka Yesu a hewahewali tauhi i paliwelehi i pa, ‘A baha duma uyahimi, tu wigapola lawahi hai lui Yaubada anani taniwaga uyahina i witai. ");
INSERT INTO tbo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A paliwelena memi, kamela ega emoemotana heyau domona ina honogi. Ma tu wigapola lawana a lui Yaubada anani taniwaga uyahina i wipilipili lagona ma apoma naka gamogamona a honoga.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu a hewahewali baha geka hi noonoli po nugonugohi hi gohola dumahi po hi pa, ‘Heki, iyai apoma apo luyagohana ina tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu i gagalehi po i kokoe ma i pa, ‘Lawa uyahihi luyagohana tuhagana ega emoemotahi ma Yaubada uyahina ginouli atapuhi emoemotana.’ ");
INSERT INTO tbo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ega yaka Pita i baha nae Yesu uyahina i pa, ‘U galeya i gapola atapuhi to nehalehi po to wootagom, tauyai apo awai to tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu i baha nae uyahihi i pa, ‘A baha duma uyahimi, yohola apo hipuli wouna uyahina tau Lawa Moinau, u ani wiwasawasa namanamalina uyahina a tugula, ma taumi tu wotagou magoumi 12, ani luhetala ona tugulehi, ma Isalaela gugunina magouhi 12 ona luhetalehi. ");
INSERT INTO tbo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Apo iyawoi hai meyagai bo walewalehihi bo nounouhi bo amamahi po hinahinahi bo natunatuhi bo hai tano, tau biugei ma hina nehalehi, tauhi apo mihahi hina tuhaga lagoneya ma luyagohana tuwetuwenai hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma amalai gehouhi he tahatahaya apo hina wimuli. Ma amalai gehouhi he imuli apo hina tahaya. ");
INSERT INTO tbo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Yaubada anani taniwaga mei lawa gehouna a tano. Malatomtom kikina ma i nae po a tu bagibagi i weluwinihi po ipa a tano uyahina hina bagibagi. ");
INSERT INTO tbo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma a lugagayo i baheya i pa, “Iyeta emosi mihana naka kina emosi omi bagibagi mihana,” po hi kaoha ega yaka i himilihi po hi nae hoi tano po hi wobagibagi. ");
INSERT INTO tbo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","‘Kabudala i gegei ma gasi i nae hoi ani gimala po lawa gehouhi i gagalehi ega hai bagibagi ma hi meme yabayababa, ");
INSERT INTO tbo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ega yaka i paliwelehi i pa, “Emoemotana apo ota nae u tano uyahina po ota bagibagi? Po omi bagibagi a lata naka pitenana ata wimihena tagoya,” ega yaka hi nae hoi tano po hi wobagibagi. ");
INSERT INTO tbo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","‘Iyeta bolinai po ibigei i nenememe po lawa gehouhi hi memae ma i galehi, yaka i paliwelehi po hi nae a tano uyahina po hi bagibagi. ");
INSERT INTO tbo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kabudala i yoliyoli ma i nenae po lawa gehouhi i tuhagahi, ega yaka i baha nae uyahihi i pa, “Awai binei bagibagi iyetana o halena yababaya?” ");
INSERT INTO tbo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Ma hi baha hi pa, “Babana ega lawa gehouna ita paliweliyai ipa apo a bagibagi to dewaya.” ‘Ega yaka badana i baha i pa, “Taumi ona nae u tano uyahina po ona bagibagi.” ");
INSERT INTO tbo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘I uguguwi, ma tanona tu galena itetena i paliweleya i pa, “Tu bagibagi atapuhi una liwoloehi po hai meiha hina tama. Tu bagibagi waimulihi uyahihi una wiwawala po tu bagibagi tahatahayahi uyahihi una liwoloe.” ");
INSERT INTO tbo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","‘Tauhi kabudala i yoliyoli ma hi nei po hi wobagibagi noka mihahi kina emosi i welehi naka pitenana lawa atapuhi apo gasi kina emosi po emosi hina waya. ");
INSERT INTO tbo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma lawa tu bagibagi tahatahayahi hai winugonugotuhu hi pa, apo maiha baneina hina waya, tamogi ega atapuhihi mihahi galenana emosi. ");
INSERT INTO tbo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hai meiha hi tama po i kokoe, ma mihahi a lata hi gagaleya po hi nugoapapoe tano taniwagana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ega yaka hi baha nae taniwaga uyahina hi pa, “Lawa wouhi ega hita luhilage, po mei tauyai to lauhilage, tauyai iyeta atapuna to bagibagiyeya, ma i meiha atapuyeina emoemotiyai.” ");
INSERT INTO tbo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Ma taniwagana i paliwelehi i pa, “U lawa, ega u taniwaga ita apapoe, ma kina emosi mihana o lueeneya yaka naka amaka. ");
INSERT INTO tbo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Omi meiha kina emosi po emosi ona waya ma ona nae. Ma u taniwaga lawa waimulihi hai bagibagi mihana a lata mei mihami a lata. ");
INSERT INTO tbo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tau u mone a tanitaniwageya, yaka u ani’mbenena lawa a welewelehi ega binei ona nugonugoapapoe.” ");
INSERT INTO tbo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‘Amalai gehouhi he tahatahaya apo hina wimuli. Ma amalai gehouhi he imuli apo hina tahaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu a hewahewali magouhi 12 mitehi hi gegae Yelusalem po hoi tahaya ma i paliwelehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","‘Tauta ta nenae u Yelusalem apo Lawa Moinau hina palihaleu tu witalaguyaba babadahi, po lugagayo tanitaniwagahi u nimahi, po u hilage binei hina taniwaga. ");
INSERT INTO tbo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma hina palihaleu tu meuputa hai tu wigawiya u nimahi po apo hina paliguyoguyougeu ma gulawa uyahinei hina kodikodiliu po ina kokoe ma hoi ani take hina tutulawiteu. Ma iyeta tonuga hina kokoe apo a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi agona ma natunatuna luwaga hi nei Yesu uyahina, po i polou ma i lupali Yamesa ma Yoni ubeihi. ");
INSERT INTO tbo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ega yaka Yesu i lubayadeya i pa, ‘Awai om luhogala?’ Ma wawinena i baha i pa, ‘A luhogaleya ipa om ani taniwaga una tutuhagaya hougana, natunatuwe mitehi apo ota tugula gogona, gehouna u awala hinebawam ma gehouna u keham.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ega yaka Yesu hai baha i wimiheya i pa, ‘Omi lupali anona ega ota hanapugeya. Emoemotami apo wiyuwa ani umana a umumaya taumi on’umaya?’ Ma hi baha hi pa, ‘Emoemotiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu i baha nae uyahihi i pa, ‘Naka moina apo wiyuwana a umumaya taumi on’umaya. Ma tamogi ega emoemotau po a winaganimi po ipa apo iyai u awala hinebawau ina tugula ma iyai u kehau ina tugula. Amau tauna e woononogo iyawoi apo hina tugula.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ma a hewahewali magouhi 10, Yamesa ma Yoni hai lubayada hi noonoli po hi luuyogigai duma. ");
INSERT INTO tbo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ega yaka Yesu i boinihi po i baha nae uyahihi i pa, ‘O hanapugeya tanitaniwaga hipuligei lawa uyahihi hi taniwaga kadidili duma, po tauhi mei tu wasawasa. ");
INSERT INTO tbo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma taumi ega ipa naka pitenana ona dewadewaya, apo u hayami tam iyai ipa una witaniwaga, yaka una witubagibagi om lawa ubeihi. ");
INSERT INTO tbo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Apo iyai u hayami ipa ina tahaemi, yaka tauna a lawa ubeihi ina witupupoula. ");
INSERT INTO tbo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mei tau Lawa Moinau a nenei hoi hipuli ega ipa lawa biugei hina bagibagi, ma tau ipa a witubagibagi lawa ubeihi, po apo yautuwe a palihaleya lawa magomagouhi ubeihi ipa a lupenihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yeliko hi nehaleya po hi nenae ma bolu banei dumana hi wotagohi. ");
INSERT INTO tbo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma lawa luwaga matahi keekehi hoi tahaya hi tugutugula, ma Yesu i nei po i nenae ma tuwegana hi nonoli, yaka hi otu hi pa, ‘Yesu, Dawita gogana, uta lunugotootogogeiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma bolu hi paliyehi hi pa, ‘Hei, ona genuwana.’ Ma apoma hi ototu labalabatana hi pa, ‘Guyau, Dawita gogana, una lunugotootogogeiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ega yaka Yesu i tutowolo ma i otugehi po hi nei uyahina po i lubayadehi i pa, ‘Omi luhogala ipa awai bimiyei a dewaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma tauhi hi pa, ‘Guyau, nugonugoiyai to galena meme.’ ");
INSERT INTO tbo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu i lunugotootogogehi yaka matahi i wodadanihi po mala emosi ma matahi hi galeneya, ma Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu a hewahewali mitehi hi nae Yelusalem u liyaliyana po hi geleta u Betepage, naka oya Oliweta uyahina po noka hota ma Yesu a hewahewali luwaga i himila tahaehi po ");
INSERT INTO tbo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","i pa, ‘Meyagai u naomi ona nae po ona luiluiya naka hota doniki ma natuna olotona ona tuhagahi. Ona lupenihi po ona neihi mai uyahiu. ");
INSERT INTO tbo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Apo ona lupelupenihi ma hina laubayademi yaka ona pa, “Guyau ipa ina wibagibagi, ma apo ina gunawileya.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Geka dewahi hai geleta odubona tu bahapiko amaka i bahena nonogogeya i pa, ");
INSERT INTO tbo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Saiyoni lawahi ona paliwelehi ona pa, “Omi wasawasa ona galeya e nenehi uyahimi anai nugohopuhopuna doniki i geluya. Naka donikina natuna olotona i geluya.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu a hewahewali a baha hi wotagoya po hi nae. ");
INSERT INTO tbo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Apoma donikina natuna mitehi hi niyehi Yesu uyahina, ma hai kalekogei doniki upuna wihiyeya ma Yesu i gelu. ");
INSERT INTO tbo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma bolu baneina hai kalekogei tahayana hi lutouli, ma lawa gehouhi mayau lagahi anai luguluguhi hi bolihi po a tahaya hi lutouli. ");
INSERT INTO tbo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bolu gehouhi u naonei ma bolu gehouhi mulinei hi nenae, ma lawa atapuhi hi otu labatana ma hi wotalagae hi pa, ‘Tam Dawita gogana, to wotalagiyem!’ ‘Guyau gowanei e nenei Yaubada ina kawaidewedewem!’ ‘Ani’mhuna duma tam Gegewahagam uyahim!’ ");
INSERT INTO tbo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","A luina uyahina Yelusalem tu miyena hi goholihi po hi ibaabani hi pa, ‘Noka tauna iyai?’ ");
INSERT INTO tbo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma lawa boluhi Yelusalem tu miyena hai lubayada hi imiheya hi pa, ‘Tu bahapiko lawa Nasaletagei gowana Yesu, Galili anani taniwaga uyahinei i nei.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu numa dalabu baneina i luiya, po i tugudu po tu gimagimala i wiyagahi, ma mone tu wiyawepeli hai pata i lugoluhi, ma bunebune tu gimalahalenahi hai ani tugula i lubuiya. ");
INSERT INTO tbo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma i baha nae uyahihi i pa, ‘Yaubada a Buka hi gilugilumi uyahina i baheya i pa, “U numa lawa hai ani lupali numana.” Ma taumi o buiya po tu danedanene hai ani megowada.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Matakeke lawahi po lawa daladalahi hi nei numa dalabu u hinena po Yesu i widewadewahi. ");
INSERT INTO tbo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tu witalaguyaba babadahi po lugagayo tanitaniwagahi Yesu a bagibagi maninina hi galeya, ma logaloga hi ototu numa dalabu u hinena hi pa, ‘Dawita gogana ta wotalagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tanitaniwaga hi luuyogigai po hi pa, ‘Awai binei logaloga hai wiototu ega uta liwoloeya?’ Yesu hai baha i wimiheya i pa, ‘Yaubada a Buka o hiyahiyawi babana iyowai? I pa, “Apo logaloga muhomuhohi uyahihiyei om wotalagae una wiatatiyehi.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ega yaka Yesu Yelusalem i nehaleya po i nae u Betani po noka hotanana i eno. ");
INSERT INTO tbo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu malatomtom kikina ma i gunawilena meya po i nenae Yelusalem po hoi tahaya ma am i hilage. ");
INSERT INTO tbo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma hoi tahaya mayau i towotowolo ma i galeya po i nae u liyaliyana ma tamogi ega ugona ita tuhagaya ma lugu yawa, ega yaka Yesu mayouna i paliyeya i pa, ‘Apega una ugo meme.’ Mala emosi ma mayouna i kokodila. ");
INSERT INTO tbo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ma Yesu a hewahewali mayouna hi gagaleya po hi gohola dumahi po tunawahi hi ibaabani hi pa, ‘Iyowai po mayouna a hilage i bulili duma?’ ");
INSERT INTO tbo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma Yesu i paliwelehi i pa, ‘A baha duma uyahimi ona witumagana ma ega ona launugoluwaluwaga mayau geka uyahina awai a dewadewaya binei, taumi ipa ona dewaya po mei awai a dewadewaya pite. Ma inapa geka oyana uyahina ona baha apo ina gunawotowi po u boga ina yoli yaka apo ina wiponawogogemi. ");
INSERT INTO tbo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Inapa omi luhogala awai a witumaganami ona laupali yaka apo ona tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu i lui hoi numa dalabu baneina uyahina po i iatatiyana ma tu witalaguyaba babadahi, po Yudeya tanitaniwagahi hi nei po Yesu hi lubayadeya hi pa, ‘Witaniwaga awai u waya po geka ginoulihi e dewadewahi, bo iyai geka witaniwagana i welem?’ ");
INSERT INTO tbo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu hai baha i wimiheya i pa, ‘Hapali tau lubayada a welemi po ona wimiheya yaka apo omi lubayada a wimiheya, po iyai geka witaniwagana i weleu. ");
INSERT INTO tbo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoni a witaniwaga yadei i nei bo lawa uyahihiyei i nei po i ibapatiso?’ Ma tunawahi u hayahi hi ibaabani hi pa, ‘Apo awai ta baheya! Apo tana pa, “Yadei,” apo ina pa, “Awai binei ega ota witumaganeya?” ");
INSERT INTO tbo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ega emoemotana tana pa, “Lawa uyahineiyei,” babana lawa boluhi ta matutehi, ma hai winugonugotuhu naka tu bahapiko gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ega yaka a baha hi wimiheya hi pa, ‘Ega tota hanapugeya miyei i nei.’ Ma Yesu uyahihi i baha i pa, ‘Tau gasi apega a paliwelemi witaniwaga awai a waya po geka ginoulihi a dewadewahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu i baha meme uyahihi i pa, ‘Apo lawa natunatuna ololotohi luwaga, ma tutuwoga i paliweleya i pa, “Natuwe, amalai apo una nae hoi tano una bagibagiyeya.” ");
INSERT INTO tbo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma i luhinigigai, ma tamogi muliyei i nugobui po i nae i bagibagi. ");
INSERT INTO tbo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","‘Ma natuna habuluna i paliweleya i pa, “Natuwe, una nae hoi tano una bagibagi,” ma natuna habuluna i pa, “Ee, i haki apo a nae,” ma tamogi ega ita nae. ");
INSERT INTO tbo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‘Hai luwagahi iyai amahi a nugotuhu i wiponawogogeya?’ Ma tauhi hi baha hi pa, ‘Tutuwoga.’ Ega yaka Yesu i baha nae uyahihi i pa, ‘A baha duma uyahimi tauhi tu apapoe po tauhi t matamaga wiwinehi apo hina lui Yaubada anani taniwaga uyahina, ma taumi apega ona lui. ");
INSERT INTO tbo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoni lolowa tahaya dumadumaluna i atatiyemi, ma ega ota witumaganeya, ma takisi tu tama po tu matamaga wiwinehi hi witumaganeya po hai witumagana o gagalehi ma taumi ega kikina ota witumagana po ota nugobui. ");
INSERT INTO tbo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‘Paliluwaluwa gehouna tano taniwagana binei ona nonoli. Tano taniwagana gologolowa ugona uyahina wine he dewadewaya i lupehiyeya, ma gali i dewaya po i wiwila, ma wine pihagana i dewaya, ma gasi tanona u hinena ani luwiyau numana i wogoya, ma tu galena itete hai ututu i lawi ma i nehalehi po i nae bala daodaona. ");
INSERT INTO tbo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma wine i ugo po i magula, ma houga omlohina hougana a hewahewali i himilihi po hi nae ipa ugona tupona hina welehi. ");
INSERT INTO tbo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","‘Ma tano tu galena itete baha tu hihiwa hi womomohihi po gehouna hi kodikodili ma wiluwagana hi lihilageni, ma witonugana gaimei hi wilawi. ");
INSERT INTO tbo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ega yaka taniwagana hewahewali gehouhi i himilihi kikina hi maga ma gasi naka pitenana tu galena itetehi hi dewaya. ");
INSERT INTO tbo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anani kokoe naka tauna natuna dumana i himili ma i pa, “Geka tauna natu hotau yaka apo hina wiyateyateya.” ");
INSERT INTO tbo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","‘Tamogi hougana tano tu galena itete natunana hi gagaleya po tunawahi hi ibaabani hi pa, “Tanona muliyei tu witaniwagena geegeka. Ta uni po geka tanona ipa ina nenae uyahina naka apo ina wigalitiyei.” ");
INSERT INTO tbo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ega yaka hi womomohi, po hi halena hopuneya tanona uputana po hi uni.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu i lubayada i pa, ‘Houga awai apo tanona taniwagana ina gunagunawileya tu galena itete iyowai ina dewahi?’ ");
INSERT INTO tbo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma hi baha hi pa, ‘Tu leihilage apo ina wiapapoe dumahi, ma tano tu galena itete gehouhi u nimahi tanona ina houni, tauhi apo tanona ugougona tupona tano taniwagana hina weleya.’ ");
INSERT INTO tbo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ega yaka Yesu i baha nae babadahi uyahihi i pa, ‘Nugote Yaubada a Buka hi gilugilumi, yohola ega ota nugotuhu tuhagaya i pa, “Ogolana tauna tu lunuma hi ihinigigiyeya amalai i gunabuiya po i dewadewa lagona. Naka Guyau a bagibagi u matata ani nugogohola.” ");
INSERT INTO tbo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yaka a paliwelemi Yaubada anani taniwaga uyahimi ina wihaleya po bolu tapuhi ina welehi po tauhi uyahihiyei ugo dewadewana ina geleta. ");
INSERT INTO tbo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Iyai ina peu po noka ogolana uyahina ina yato apo ina lauhedalena meya po tupotupona. Ma inapa noka ogolana ina guli po iyai ina lutataya apo ina lumutumutuya.”’ ");
INSERT INTO tbo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesu a paliluwaluwa geka tu witalaguyaba babadahi po gasi Palisi lawahi hi noonoli po hi nugohanapu po hi pa, tauhi ubeihi ita’mpaliluwaluwa. ");
INSERT INTO tbo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ega yaka Yesu hi iletaya ipa hina numa panipani, ma tamogi bolu hi matutehi, matababana Yesu hi kawatubahapikogeya. ");
INSERT INTO tbo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Baha luwaluwa gehouhi Yesu i paliwelehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‘Yaubada anani taniwaga mei tu wasawasa baneina toleha i dewaya natuna olotona a tawine tolehana binei. ");
INSERT INTO tbo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma a tu bagibagi i himilihi iyawoi tauhi i utanehi ipa hina weluwinihi po hina nei tolehana uyahina, ma tauhi hi luhinigigai. ");
INSERT INTO tbo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‘Ega yaka a tu bagibagi gehouhi i himilihi po ipa hina paliwelehi hina pa, “Bada a toleha amaka hougana i geleta, a bulamakau amaka i unihi po gasi aniani atapuhi amaka hi wononogogehi. Ona nei po ta nae a tolehana uyahina.” ");
INSERT INTO tbo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","‘Ma hai baha ega hita wiponawogogeya po gehouhi hi nae hai tano uyahihi, ma lawa gehouhi hi nae tauhi hai bagibagi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma gehouhi tu wasawasana a tu bagibagi hi womomohihi po hi wilawihi, ma hi wiapapoenihi ma hi lihilagenihi. ");
INSERT INTO tbo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wasawasana uyona i gigai yaka a tu wigawiya i himilihi po hi nae po tu’munugohi hi uni pahihi ma hai dobu hi apuya. ");
INSERT INTO tbo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‘Ega yaka taniwagana a tu bagibagi uyahihi i baha i pa, “Tawine tolehana amaka i nonogo, ma tamogi lawa a iutanehi tauhi ega emoemotahi ipa hina nei toleha uyahina babana tauhi tu apapoe. ");
INSERT INTO tbo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ona hopu po tahayagei ona nenae, ma lawa awai ona tuhagahi yaka ona wiutanehi po hina nei tawine tolehana uyahina po hina am.” ");
INSERT INTO tbo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ega yaka hi hopu po tahayagei hi nenae, ma lawa hi tamitamihi tauhi, tu dewadewa po tu apapoe po tawine numana hi wihogoya. ");
INSERT INTO tbo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Hougana tu wasawasana i nei po a toumana i gagalena niyehi po lawa gehouna i galena tuhagaya tauna ega tawine kalekona ita oteni. ");
INSERT INTO tbo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ega yaka i lubayadeya i pa, “Tulau, awai binei ega tawine tolehana kalekona uta oteni, ma awai binei u lui mai?” Lawana geka lubayada ega emoemotana po ina wimiheya. ");
INSERT INTO tbo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","‘Ega yaka wasawasana a tu bagibagi i baha uyahihi i pa, “Geka lawana ona womomohi, po aena ma nimana ona panihi po ona halena hopuneya hoi dobu uguwa po noka hotanana tou ma omhanakidiyana ina tuhagaya.” ");
INSERT INTO tbo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‘Babana Yaubada lawa magomagouhi i iutanihi ma ega hita maga i winaganihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Palisi lawahi tunawahi hai omboina uyahina hi wogatala hi pa, ‘Iyowai ma apo Yesu a baha powa ta tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hi inugonugotuhu po ega yaka hai hewahewali po Heloda a bolu mitehi hi himilihi po hi nae Yesu uyahina po hi pa, ‘Bada, to hanapugem tam lawa dumadumalum, po Yaubada a tahaya dumana e iatatiyaneya, ma lawa kadikadidilihi ega uta genogenogehi ma baha e bahebahehi lawa magomagouhi uyahihi.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ega yaka hi lubayada hi pa, ‘Om winugonugotuhu iyowai? Mi Loma hai taniwaga ta wotagoya po takisi ta huhouni Sisa binei, bo ega?’ ");
INSERT INTO tbo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu hai wiwogatala gowagowada amaka i hanapugeya, yaka i baha i pa, ‘Taumi tu wikoyakoyama, awai binei o laudadaniu?’ ");
INSERT INTO tbo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ega yaka Yesu i baha i pa, ‘Heki, takisi monena ona weleu po a galeya,’ ");
INSERT INTO tbo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","po i wiatatiyehi ma i lubayadehi i pa, ‘Iyai tepana galenana po gowana geka monena uyahina?’ ");
INSERT INTO tbo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma hi baha hi pa, ‘Sisa galenana.’ Ega yaka Yesu uyahihi i baha i pa, ‘Heki, ginouli awai Sisa galinei Sisa ona weleya. Ma ginouli awai Yaubada galinei Yaubada ona weleya.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu a baha hi noonoli hi gohola dumahi. Ega yaka hi nehaleya po hi nae. ");
INSERT INTO tbo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Noka iyetana uyahina Sadusi hai bolu tauhi hi nei Yesu uyahina, tauhi hilage towolo memena ega hita itumaganeya. ");
INSERT INTO tbo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tauhi hi lubayadeya hi pa, ‘Bada, Mose geka lugagayona ubeiyai i gilumi i pa, “Oloto awai ina tawine po ega ina winatuna ma ina hilage apo walehina hiwapena ina lawagi po hina winatuna naka popoyana galinei.” ");
INSERT INTO tbo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lawa gehouna natunatuna ololotohi magouhi 7. Tutuwoga i tawine po ega natuna ma i hilage. Ma walehina i haulatuya hiwapena i lawagi, ");
INSERT INTO tbo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","po ega natuna ma i hilage. Po gasi witonugahi ma atapuna magouhi 7 emoemotahi. ");
INSERT INTO tbo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Muliyei apoma wawinena i hilage. ");
INSERT INTO tbo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Uyahinei ma hoi towolo meme wawinena apo agona iyai? Matababana atapuhi magouhi 7 i lawaga pahihi?’ ");
INSERT INTO tbo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma Yesu hai lubayada i wimiheya i pa, ‘Taumi naka o koyakoyamena memi babana Yaubada a Buka gilugilumana ega ota hanapugeya, ma gasi a wipoya ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Towolomeme hougana uyahina lawa apega hina tawitawine po apega hina itawinehi, tamogi hai mae yada uyahina tauhi ani galenahi mei tu winoyanoya mi yadena. ");
INSERT INTO tbo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma Yaubada a baha hi gilugilumi towolo meme binei amaka o hiyawa tuhagaya i pa, ");
INSERT INTO tbo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abelaham a Yaubada tau, po Isako a Yaubada tau, po Yakobo a Yaubada tau.” Tauna ega lawa hilahilagehi hai Yaubada, ma lawa lauyagohanahi hai Yaubada.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesu a wiatatiyana bolu hi noonoli po hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Palisi lawahi Yesu noyana hi nonoli ipa Sadusi hai lubayada amaka i wimiheya po ega hai ani baha gehouna, ega yaka Palisi hi’mboina gogona ma hi nei Yesu uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","po Palisi uyahihiyei lawa gehouna lugagayo tu hanapugena Yesu i ludadani i pa, ");
INSERT INTO tbo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‘Bada, lugagayo atapuhi uyahihiyei lugagayo awai i lata duma?’ ");
INSERT INTO tbo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Yesu a lubayadana i wimiheya i pa, ‘Guyau om Yaubada luhogalam atapunei po alugom atapunei po nugonugom atapunei una luhogaleya. ");
INSERT INTO tbo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Geka lugagayo tahatahayana po gasi i lagona duma. ");
INSERT INTO tbo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma lugagayo wiluwagana geka pitenana i baheya i pa, “Lawa u liyaliyama tu mae una luhogalehi po mei e lauhogalena mem.” ");
INSERT INTO tbo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Geka lugagayohi luwaga naka, lugagayo magomagouhi po tu bahapiko hai wibaabani magomagouhi hai baba.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naka hougana Palisi hi’mboina gogona mai ma Yesu i lubayadehi ");
INSERT INTO tbo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","i pa, ‘Iyowai omi winugonugotuhu, Besinana lawana gogana iyai?’ Ma hi baha hi pa, ‘Gogana Dawita.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ega yaka Yesu i baha i pa, ‘Ma iyowai po lolowa Alugo Woiyawa nugotuhu Dawita i weleya po Besinana lawana i kawaiguyougeya i pa, ");
INSERT INTO tbo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Yaubada i baha u Guyau uyahina i pa, ‘U awala hinebawau una memae a sigana om gawiya a houna hopunehi po aem ani luhanatanahi.’” ");
INSERT INTO tbo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Noka hougana Dawita Besinana lawana i kawaiguyougeya. Uyahinei Dawita ega Besinana lawana gogana dumana.’ ");
INSERT INTO tbo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu a lubayada geka ega emoemotana po lawa awai ina wimiheya, geka uyahinei Yesu hi lowogeya po ega hita lubayabayadena gawahi. ");
INSERT INTO tbo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu a hewahewali po gasi bolu mitehi ma uyahihi i baha i pa, ");
INSERT INTO tbo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‘Omi lugagayo tanitaniwagahihi po Palisi lawahi, tauhi Mose a lugagayo odubohi he iatatiyanehi mi Isalaela uyahimi. ");
INSERT INTO tbo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yaka awai he iatatiyemi ona wotagoya, ma tamogi hai bagibagi ega ona itutupoganehi, babana he iatatiyana hota ma ega hita wootagohi. ");
INSERT INTO tbo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hai lugagayo hi witai duma po lawa he laiwitenihi, ma ega kikina hita wileta po lugagayo geka hita wotagohi. ");
INSERT INTO tbo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","‘Hai bagibagi atapuhi ipa lawa hina galehi ma hina hunehi, po Yaubada a Buka uyahinei hi gilumihi po u tepahi hi numa panipani lawitehi po nimahi uyahihi po hai ani lupali kalekohi hi lidaohi ma he ototenihi. ");
INSERT INTO tbo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma tauhi hai luhogala ani tugula gegehi toleha uyahihi po gasi ani tugula dewadewahi hoi numa dalabu. ");
INSERT INTO tbo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hai luhogala ipa ani gimala uyahina lawa wiyateyategei hina mamalihi ma hina kawaiguyougehi. ");
INSERT INTO tbo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Ma taumi tu wotagou yaka apega naka pite hina kawaiguyougemi babana omi Guyau emosi hota po atapumina emoemotami. ");
INSERT INTO tbo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hoi hipuli ega iyai uyahina ona kawakawaiamana, babana Amami emosi hota hoi yada e memae. ");
INSERT INTO tbo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lawa ega hina kawakawaitaniwagemi, babana Besinana lawana tau tunawau omi taniwaga. ");
INSERT INTO tbo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma apo uyahimi lawa awai ina tahaemi, yaka tauna ina witubagibagi uyahimi. ");
INSERT INTO tbo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Matababana iyai e wohepa meya apo ina hopu ma iyai e wohopunena meya apo ina gae. ");
INSERT INTO tbo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘Kihoni lugagayo tanitaniwagami po Palisi lawami taumi tu nugodubu. Omi wikoyakoyama binei lawa o guduhi po apega Yaubada anani taniwaga uyahina hina lui. Taumi ega ota lui yaka lawa ega hita lui, babana o guduguduhi. ");
INSERT INTO tbo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kihoni lugagayo tanitaniwagami po Palisi lawami taumi tu nugodubu. Omi wikoyakoyama gehouna boga ma hipuli uyahihi o kadakadau wiwila dobu magomagouhi uyahihi, ipa omi hewali emosi hota ona waya po omi wiatatiyana powa binei apo a apapoe omi apapoe ina lata lagoni po tauna ma taumi dobu ebebalana ona wialoni. ");
INSERT INTO tbo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘Kihoni tanitaniwaga matami keekehi taumi tu nugodubu. O baha o pa, “Apo iyai numa dalabu gowanei ina igwala naka ega ginouli baneina, ma apo lawa awai gapola numa dalabu u hinena he memae uyahihiyei ina igwala, yaka naka ginouli banei dumana po apo ginoulina ina dewaya.” ");
INSERT INTO tbo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Taumi o buuwa duma po matami hi keke. Ginouli awai i dewadewa duma, numa dalabu bo gapola? Nugote numa dalabu babana numa dalabu u hinena gapola he memae tauhi hi wiwoiyawa babana numa dalabu u hinena. ");
INSERT INTO tbo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma o baha o pa, “Apo iyai ani talaguyaba gowanei ina igwala naka ega ginouli baneina, ma tamogi ina igwala anani’mbenena ani talaguyaba uyahina, po ginouli awai i pikogeya apo ina dewaya.” ");
INSERT INTO tbo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Taumi matami hi keke, ginouli awai i dewadewa, ani’mbenena bo ani witalaguyaba tauna ombenena e iwoiyaweya? ");
INSERT INTO tbo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Uyahinei apo lawa awai ani talaguyaba gowanei ina igwala, yaka tauna gasi ginouli atapuhi ani talaguyaba uyahihi e igwalehi. ");
INSERT INTO tbo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma apo lawa awai gasi numa dalabu gowanei ina igwala, yaka tauna gasi numa dalabu gapolahi gowanei e igwala. ");
INSERT INTO tbo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma apo lawa awai yada gowanei ina igwala tauna Yaubada anani mae gowanei po gasi Yaubada gowanei e igwala. ");
INSERT INTO tbo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘Kihoni lugagayo tanitaniwagami po Palisi lawami taumi tu nugodubu. Yaubada uyahina omi koyamagei o yambenena ma omi ani’mbenenahi omi ginouli atapuhi baneihi po habuluhi uyahihiyei, tamogi lugagayo dumahi o winugoguluwihi, dewa dumadumaluna ma lunugotootogo ma witumagana tauhi o winugoguluwihi, emoemotami ginouli baneihi geka ona dewahi, ma gasi ginouli habuluhi ega ipa ona inugoguluwihi. ");
INSERT INTO tbo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Taumi tanitaniwaga matami keekehi, omi gulai u hinena nabugala o wihaleya po ega ota umaya, ma gamogamo baneihi o laumehahi. ");
INSERT INTO tbo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘Kihoni lugagayo tanitaniwagami po Palisi lawami taumi tu nugodubu. Omi wikoyakoyama binei, omi keyaka po omi gaeba upuhi o laiyeuyeuhi ma tamogi u hinemi omboho po dewa apapoe i wihogomi. ");
INSERT INTO tbo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Taumi Palisi matami hi keke duma omi keyaka po omi gaeba hinehi ona liyeuyeu tahaehi, yaka apo upuhi hina yeuyeu. ");
INSERT INTO tbo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘Kihoni lugagayo tanitaniwagami po Palisi lawami taumi tu nugodubu. Omi wikoyakoyama binei taumi mei kokowaga, tepana o wihiyeya po i yeuyeu po galenana i haki, ma tamogi u hinena lawa geyamihi bowabowahi po gobugobuhi he memae. ");
INSERT INTO tbo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taumi lawa u matahi galenami mei tanitaniwaga dumadumalumi, ma nugonugomi u hinena koyama po apapoe hi maga duma ma he memae. ");
INSERT INTO tbo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘Kihoni lugagayo tanitaniwagami po Palisi lawami taumi tu nugodubu. O ikoyakoyama, babana tu bahapiko odubohi kokowagahi o dewahi ma tu dewadumalu odubohi ani nugomomotahi o wononogogehi, ");
INSERT INTO tbo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ma o baha o pa, “Itapa odubona googata hai houga uyahina tata memae apega tata haguhaguhi, ma tu bahapikohi hita laihilagenihi.” ");
INSERT INTO tbo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Omi wibaabani uyahina ma o bahena memi, o pa, “Tu’munugo googahi tauyai.” ");
INSERT INTO tbo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yaka hai bagibagina taumi apo ona wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘Baha dumana taumi ani galenami mei mota deewa yaka ega emoemotami ipa dobu ebebalana ona lowo haleya. ");
INSERT INTO tbo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tu bahapiko po tu dewadewa po tu wiatatiyana apo gehouhi a himihimilihi po ona unihi po hina hilage, ma gehouhi ani take uyahina ona tutulawitehi, ma gehouhi omi numa tapalolo u hinehi ona wilawihi ma meyagai emosi po emosi uyahihi ona iyaga niyehi. ");
INSERT INTO tbo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Houga a kokoe uyahina tu dumalu atapuhi hai hilage bigona taumi apo ona waya, Abele tu dumalu a hilage uyahina i wawali ma i nei po amalai Belekiya natuna Sekaliya numa dalabu ma ani talaguyaba u tipolinana o lihilageni naka bigohi apo ona waya. ");
INSERT INTO tbo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A baha duma uyahimi taumi geka hapanana apo bigo geka ona wialoni. ");
INSERT INTO tbo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘Aee, Yelusalem, Yelusalem, tam tu bahapiko e ununihi po Yaubada a tu baha e laugaimahi. Houga i dao ipa natunatum a lugoogonihi po mei kamkam apapenei natunatuna e talatalahagauhi. Ma ega uta palihaleu po ata dewaya. ");
INSERT INTO tbo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Uyahinei apo Yaubada om meyagai ina nehaleya po ina apapoe wahaga. ");
INSERT INTO tbo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma a paliwelem, apega una galeu a sigana u houga a gunawileu po una pa, “Tam Guyau gowanei e nenei to kawaidewedewem.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu numa dalabu baneina i nehaleya po ipa ina nae u oya ma a hewahewali hi nae uyahina po numa dalabu ani galenana binei hi laiatatiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Po Yesu i baha nae uyahihi i pa, ‘Geka numahi gaima uyahihiyei hi wogohi po o gagalehi a baha duma uyahimi, houga he nenei apo gaima emosi ega u uyawena ina memae. Atapuna apo hina dubadubalena pahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hi ibaabani ma hi nenae po Oliweta u oyana hi geleta po tunawahi hi tugula, ma a hewahewali hi lubayadeya hi pa, ‘Una paliweliyai meyanai apo numa dalabuna hina goluta haleya, ma houga awai apo om houga gunawilana po iyeta anani kokoe, wekiwekilalana awai una paliweliyai po to hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu i paliwelehi i pa, ‘Ona gagalena imahi po apega iyai ina witahaya powami ");
INSERT INTO tbo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Matababana lawa hi maga apo hina towolo po gowaugei hina koyama hina pa, “Tau Besinana lawana,” po lawa magomagouhi hina koyamehi. ");
INSERT INTO tbo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hougana gawiya po wogalahi tuwegahi ona noonolihi ega ona matomatouta babana geka dewahi apo hina wawala tahaya. Tamogi houga sigasigana yohola. ");
INSERT INTO tbo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tupo geha ma tupo geha apo hina wigawiya po gasi ani taniwaga geha ma ani taniwaga geha apo hina wigawiya ma houga gomala po guhuguhu hina geleta tupo magomagouhi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Geka ginoulihi naka houga witai anani wawala dumana. ");
INSERT INTO tbo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Taumi apo lawa hina womomohimi po hina wihiniwiyuwami, ma hina laihilagenimi. Apo gowau binei ma tupo atapuhi uyahihi lawa apo hina wihinigigiyemi. ");
INSERT INTO tbo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Houga witai uyahina apo lawa gehouhi hina peu po hai lawa hina nugohalehi po hina wigawiyehi. ");
INSERT INTO tbo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Apo tu bahapiko koyakoyama hina nei po lawa gehouhi hina tahaena powahi. ");
INSERT INTO tbo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Apo dewa apapoena a lata binei ma lawa hai luhogala u nugonugohi hina tapiya. ");
INSERT INTO tbo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma inapa iyai in’omtaibagibagi, ma ina nae po houga a sigasiga uyahina tauna apo luyagohana ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma Yaubada anani taniwaga tuwegana hina guguyeni hipuli tupo wohepali uyahina po hina nonola tahaeya, ma apoma houga sigasigana iyetana ina geleta. ");
INSERT INTO tbo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Apo yohola wekiwekilala tu bahapiko Daniyela i bahebaheya ina geleta, i pa, “Ginouli waigola dumana tupo waiwoiyawana uyahina e towotowolo.” ’ (Taumi tu’mhiyawa ona wileta po baha geka anona ona hanapugena imahiyeya.) ");
INSERT INTO tbo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","‘Ma iyawoi Yudeya u tupona ona memae yaka ona lowo po ona nae u oya. ");
INSERT INTO tbo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iyai a numa uputana e memae apega ina lui po a ginouli ina tamatama. ");
INSERT INTO tbo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Emoemotana gasi iyai hoi tano ina wobagibagi, apega ina gunawileya a kaleko binei. ");
INSERT INTO tbo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ma wiwine he igugu po koikoibahi noka hougana, tauhi tu nugodubu. ");
INSERT INTO tbo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ona laupali omi lowo iyetana binei, po ega houga wayau bo dalabu iyetahi uyahihi ona memae. ");
INSERT INTO tbo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Houga witai banei dumana, babana hipuli a wawala uyahinei ma i nei po amalai, ega kikina witai mei geka pitenana, ma houga he nenei uyahihi apega witai hina geleta meme. ");
INSERT INTO tbo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iyeta witai noka itapa Yaubada ega hougana ita likukuya apo lawa atapuhi hita hilage pahihi, ma Yaubada hougana apo ina likukuya, babana a lawa i inaganihi ubeihi. ");
INSERT INTO tbo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Apo lawa gehouna ina paliwelemi ina pa, “Ona galeya, geka bo noka Besinana lawana,” ega ona itumaganeya, ");
INSERT INTO tbo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","matababana Besinana koyakoyama po, tu bahapiko koyakoyama apo hina geleta po wekiwekilala waipoyahi po manini lawa u matahi hina wogeletehi, po Yaubada a bolu i inaganihi kikina apo gasi hita koyamehi. ");
INSERT INTO tbo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yaka taumi geka dewahi ubeihi ma amaka a palipaliwelena tahaemi. ");
INSERT INTO tbo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‘Apo hina paliwelemi hina pa, “Keliso u pitapita e memae,” ega ona nenae u pitapita. Apo hina baha hina pa, “Keliso numa u hine dumana e memae,” ega ona itumaganehi. ");
INSERT INTO tbo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Babana tau Lawa Moinau u gunawilana galenana mei namanamala baneina, namalana hoi tupo kaluwabu po a siga tupo yalasi. ");
INSERT INTO tbo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Meka hotanana waewae hina yamtuboina naka hosi popoya. ");
INSERT INTO tbo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Houga witai u mulina, Kabudala a kadidili apo ina tapiya, ma wamahiya yayatana ina wigahugahu, ma yada ubonahi hina peu hopu mai, ma yada ginoulihi atapuhi hai kadidili apo hina tapiya.’ ");
INSERT INTO tbo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Naka hougana apo tau Lawa Moinau u wekiwekilala hoi yada ina lugeleteya, po lawa tupo wohepali uyahihi nugonugohi hina launihi po hina tou bahabaha apoma apo Lawa Moinau a wipoyau po a diidiga lagonau ona gagaleu ma yaloigei a nei. ");
INSERT INTO tbo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma himogo apo hina huweni po u tu winoyanoya a himilihi hipuli atapuna, togowa mata wohepali uyahihi po u lawa a inaganihi hina welugogonihi po hina nei uyahiu hipuli anani wawala po anani kokoe uyahinei. ");
INSERT INTO tbo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Ani galena a paliwelemi po ona nugonugotuhuya, i galugalu hougana uyahina ta hanapugeya naka ega daona ma apo higolo ina wawala. ");
INSERT INTO tbo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yaka wekiwekilala awai a palipaliwelemi hina wawala ma ona galehi yaka ona hanapugeya u houga gunawilana ega daona ma apo ina geleta babana hoi mateta a towotowolo. ");
INSERT INTO tbo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A baha duma uyahimi, geka ginoulihi atapuhi apo hina wawala tahaya ma apoma geka hapanana lawahi hina hilage pahihi. ");
INSERT INTO tbo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yada ma hipuli apo hina yababa ma tau u baha apega ina yababa.’ ");
INSERT INTO tbo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Ega iyai gehouna ita hanapugeya iyetana po kabudalana apo ina geleta mei gasi tu winoyanoya mi yadena ega hita hanapugeya. Tau gasi ega ata hanapugeya, Amau tunawana i hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mei Nowa a houga emoemotana mei gasi apo Lawa Moinau u houga nei, ");
INSERT INTO tbo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","babana Nowa a houga uyahina lawa hi’mam, po hi umuma po hi tawitawine po hi itawitawine ma Nowa wam uyahina i gelu, ");
INSERT INTO tbo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ma goila i hopu i ligohogoholihi, po lawa atapuhi hi hilage pahihi yaka tau Lawa Moinau, u houga gunawilana naka pitenana. ");
INSERT INTO tbo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naka hougana apo lawa luwaga hoi tano, yaka emosi Yaubada ina wihaleya ma emosi ina memae. ");
INSERT INTO tbo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wiwine luwaga apo pegapega hina yamapu po emosi Yaubada ina wihaleya ma emosi ina memae. ");
INSERT INTO tbo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Uyahinei ona gagalena, babana tau omi Guyau u houga gunawilana iyetana ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma gegeka ona hanapugeya, itapa numa taniwagana uguwei tu danedanene a nei kabudalana ita hanapugeya apo matana ita kayakaya po apega a numa ita lupapaya po ita lui. ");
INSERT INTO tbo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Taumi ipa gasi ona wononogo babana kabudala awai o pa apega a nenei naka u hinena apo Lawa Moinau a nei. ");
INSERT INTO tbo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Iyai waiponawogona po wainugonugotuhuna? Tauna apo a bada ina witowoli po numa u hinena ina witaniwaga, ma tu bagibagi gehouhi aniani kabudala dumalunei ina welewelehi. ");
INSERT INTO tbo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Inapa badana ina gunagunawileya po geka dewana ina dewedeweya ma ina tuhagaya naka tu bagibagina tauna tu kaohadiidiga. ");
INSERT INTO tbo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A baha duma uyahimi noka badana apo tu bagibagina ina witowoli po ginouli atapuhi ina gagalena itetehi. ");
INSERT INTO tbo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tamogi inapa tu bagibagina a dewa ina apapoe ma ina paliwelena meya ina pa, “U bada, a gunawilana i wihinihinibiga, ");
INSERT INTO tbo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma ina wiwawala po tu bagibagi gehouhi ina kodikodilihi, ma in’omam ma in’umuma buuwa. ");
INSERT INTO tbo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Noka tu bagibagina a bada iyeta emosi apo ina nei. Ma a neina naka tu bagibagina ipa apega ina nei po kabudalana apega ina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma apo kwasikwasi daodaonei ina talatala mutuya po tu wikoyakoyama mitehi ina houna emotehi po noka hotanana tou ma omhanakidiyana ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‘Yaubada anani taniwaga galenana mei guguhini magouhi 10, hai lampa hi tama, ma hi nae ipa tu tawine olotona i nenei mitehi hina witutuhaga a tawine tolehana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uyahihiyei magouhi nimitutu buubuwahi, ma nimitutu hanahanapuhi. ");
INSERT INTO tbo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tu buubuuwa hai lampa bunamahi a luwitana ega hita waya, ");
INSERT INTO tbo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ma tauhi hanahanapuhi hai bunamahi luwitanana hi waya hai lampa binei. ");
INSERT INTO tbo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tu tawine olotona i hinihinibiga, ma atapuhi hi otonana po hi eno hilage. ");
INSERT INTO tbo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","‘Ma amaka i wiupom bolina ma lawa gehouna i otu i pa, “Hei, tu tawine olotona amaka e nenei, ma ona towolo po mitehi ta witutuhaga.” ");
INSERT INTO tbo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","‘Ega yaka guguhinihi atapuhi hi towolo po hai lampa hi wononogogehi. ");
INSERT INTO tbo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma guguhini buubuwahi, hai lawa uyahihi hi baha hi pa, “I lawa, omi lampa a bunamahi tuponei ona weliyai babana kikina ma apo i lampa hina boho.” ");
INSERT INTO tbo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Ma hanahanapuhi hi baha nae hi pa, “Nugote ega emoemotana po i lampa bunamahi tupohi to welemi amaka emoemotiyai, yaka taumi ona nae tu gimala uyahihi po omi lampa bunamahi ona gimala.” ");
INSERT INTO tbo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‘Yaka hi nenae ipa hina gimala, ma tu tawine olotona i nei po tauhi amaka hi woononogo mitehi hi lui tawine tolehana uyahina, ma mateta hi guduya. ");
INSERT INTO tbo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","‘Ma hai lawa hi gimala po i kokoe, ma hi gunagunawilehi po hoi uputa hi mae, ega yaka hi baha hi pa, “Bada, bada, gudu una hoeya ma to lui mahi.” ");
INSERT INTO tbo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Ma hai baha i wimiheya i pa, “A baha duma uyahimi taumi bolu tapuna, ega ata hanapugemi.” ");
INSERT INTO tbo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‘Uyahinei ipa ona gagalena babana u houga gunawilana iyetana po kabudalana ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Galenana mei bada gehouna ipa ina nae ina kadau ma a tu bagibagi i otugehi po hai ututu i lawi, ma awai i lainanahi apo anani taniwaga tupona hina galena iteteya. ");
INSERT INTO tbo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ega yaka a tu bagibagi gehouha mone a lata tausana nimitutu i weleya ma a hewali wiluwagana, tausana luwaga i weleya, ma a hewali witonugana tausana emosi i weleya. Emosi po emosi a hanapu a lata uyahinei ma hai guta i welehi, ma i nehalehi po i nae bala daodaona. ");
INSERT INTO tbo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma lawana a bada mone tausana nimitutu i weleweleya i nae po i ibagibagi po a luwitana tausana nimitutu i tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mei lawa wiluwagana a bada mone tausana luwaga i weleweleya i nae po i ibagibagi po tausana luwaga i tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma lawa witonugana a bada mone tausana emosi i weleweleya, i nae po a bada a mone ega ita wibagibagi ma hipuli i halaya ma i guluwi. ");
INSERT INTO tbo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Ma hai badana a kadau hougana i dao, apoma i gunawilena meya po a hewahewali hai bagibagi anohi ina galehi ma ina lubayadehi. ");
INSERT INTO tbo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yaka lawana tausana nimitutu i weleweleya, naka i nei a tausana nimitutu i luwitani po u nimana ma i nei a bada uyahina i baha i pa, “Bada, geka tausana nimitutu u weleu po a ibagibagi geka gasi tausana nimitutu a tuhagaya po a luwitani ma a neiyai.” ");
INSERT INTO tbo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘A bada i baha i pa, “I dewadewa. Tam tu bagibagi dewadewam po dumadumalum, apo ginouli baneihi una galena itetehi matababana ginouli habuluhi emoemotana a witumaganem, po u ani kaoha uyahina apo una memae.” ");
INSERT INTO tbo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘U mulina lawa wiluwagana i nei tauna tausana luwaga i weleweleya, po i baha i pa, “Bada, tausana luwaga u weleu ma a nae po a ibagibagi po geka tausana luwaga a luwitana a tuhagaya po a neiyai.” ");
INSERT INTO tbo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Yaka a bada i baha i pa, “I dewadewa. Tam tu upuhegoya dumam po dumadumalum. Amaka u wileta ginouli habuluhi uyahihi, yaka apo a taniwagem po ginouli baneihi a welem po una taniwagehi, po u ani kaoha uyahina una memae.” ");
INSERT INTO tbo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘Ma lawana witonugana tauna tausana emosi i weleweleya i nei po i baha i pa, “Bada, a hanapugem tam ega lawa uta genogenogehi yaka om gapola e tamatama lawa gehouhi hai bagibagi uyahihiyei. ");
INSERT INTO tbo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Uyahinei a matouta po om mone tausana emosi u weleweleu hipuli u hinena a gowadi, po amaka a tuhaga meya yaka geka om mone una waya.” ");
INSERT INTO tbo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Ega yaka a bada i baha nae uyahina i pa, “Upum i dodola duma po tam tu bagibagi apapoem. U hanapugeu u gapola lawa gehouhi hai bagibagi uyahihiyei a tamatama, ");
INSERT INTO tbo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","awai binei u mone hoi banika ega uta houni? U gunawilana hougana uyahina u mone anai luwitanana ata waya?” ");
INSERT INTO tbo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Ega yaka a hewahewali uyahihi i baha i pa, “Kina tausana emosi ona wihaleya po lawana iyai kina tausana 10 uyahina tauna ona weleya. ");
INSERT INTO tbo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lawa atapuhi uyahihi awai e memae apo Yaubada ina luwitanihi po hina lata duma. Ma iyai uyahina ega awai ita memae, hawena habulu hotana ma Yaubada apo ina wihalena pahi. ");
INSERT INTO tbo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yaka hewalina apapoena ona halena hopuneya hoi uputa, tupo uguguwana uyahina po noka hotanana tou ma omhanakidiyana ina tahagaya.” ");
INSERT INTO tbo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Apo yohola tau Lawa Moinau tu winoyanoya magomagouhi mitehi yada to nehaleya po to nenei u didiga hoi hipuli po u ani mae wasawasana uyahina a tugula. ");
INSERT INTO tbo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Naka hougana apo ani taniwaga magomagouhi hin’omboina gogona mai u matau, ma lawa a wikahahi mei gamogamo gowahi sipi tu galena itetehi e kahakahahi goti u hayahiyei, ");
INSERT INTO tbo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","po sipi a houna liyehi u awala hinebawaugei, ma goti u awala kehakehaugei. ");
INSERT INTO tbo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","‘Tau hai wasawasa yaka apo lawa u awala hinebawau a paliwelehi ana pa, “Taumi Amau i kawakawaidewedewemi, ona nei omi ani taniwaga hipuli i iwawala tahaeya, ma ubeimi i wononogogeya ona waya. ");
INSERT INTO tbo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Matababana taumi odubona am a hilage, ma yaniyani o weleu mei gasi uyopopou i haleeya, ma goila o weleu. A ihewahewa omi dobu uyahina ma o weluwiniu po a nehi omi numa uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ma ega u kaleko, ma taumi kaleko o weleu, a totogo ma o galena iteteu, hoi numa panipani a memae, ma o daadaniu.” ");
INSERT INTO tbo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‘Uyahinei tu dumalu lawahi apo uyahiu hina baha hina pa, “Guyau, ega tota hanapugeya meyanai to gagalem ma am u hilage, ma yaniyani to welem, bo uyopopom i haleeya, ma goila to welem, ");
INSERT INTO tbo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","bo u ihewahewa ma to otugem po u nei i numa uyahina, bo ega om kaleko ma kaleko to welem, ");
INSERT INTO tbo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","bo u totogo ma to galena itetem ma hoi numa panipani u memae ma to weluweludadanim.” ");
INSERT INTO tbo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Yaka tau tu wasawasa apo a paliwelehi ana pa, “A baha duma uyahimi, tam iyai walewalehiu tapitapiyahi emosi hota uyahina u ihaguhagu naka tau amaka u haguwe.” ");
INSERT INTO tbo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Uyahinei apo u awala kehakehau tu mae a paliwelehi ana pa, “Taumi tu apapoe ona nehaleu po ona nae mayau alalata wahagana uyahina, tauna Yaubada i wononogogeya Tomodulele a bolu ubeihi, ");
INSERT INTO tbo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","matababana lolowa am a hilage, ma ega yaniyani ota weleu, uyopopou i haleeya, ma ega goila ota weleu; ");
INSERT INTO tbo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","a ihewahewa omi dobu uyahina ma ega ota otugeu po ata nehi omi numa uyahina, ega u kaleko, ma kaleko ega ota weleu. A totogo ma ega ota galena iteteu, ma hoi numa panipani a memae ma ega ota weluweludadaniu.” ");
INSERT INTO tbo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Apo tauhi u mulina hina baha hina pa, “Guyau, ega tota hanapugeya meyanai to gagalem ma am u hilage, bo uyopopom i haleeya, bo i dobu uyahina u wihewahewa, bo ega om kaleko, bo u totogo bo hoi numa panipani u memae ma ega tota haguhagum?” ");
INSERT INTO tbo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Ma apo a baha uyahihi ana pa, “A baha duma uyahimi, hougana omi luyagohana u hinehi ega tu wotagou tapitapiyahi ota haguhaguhi, naka tau gasi ega ota haguwe.” ");
INSERT INTO tbo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‘Uyahinei tauhi apo hina nae wiyuwa memewahagana uyahina. Ma tu dumalu lawahi apo luyagohana tuwetuwenai hina tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu a wiatatiyana i wikokowi ma a hewahewali i paliwelehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‘O hanapugeya iyeta luwaga ma apo Welulagona tolehana ta dewaya, po tau Lawa Moinau tu nugohaleu in’omweleneu tu wigawiya uyahihi po hoi ani take hina tutulawiteu.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naka hougana tu witalaguyaba babadahi po lugagayo tanitaniwaga po mi Yudeya hai tanitaniwaga hi’mboina gogona Kayapa a numa baneina u hinena, babana Kayapa tauna talaguyaba taniwagana. ");
INSERT INTO tbo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma tunawahi hi wiwogatala ipa iyowai ma Yesu hina numa panipani gowadi po hin’uni. ");
INSERT INTO tbo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hi ibaabani po hi pa, ‘Ega toleha u hinena Yesu ta panipani apo lawa hina wigawiyeta.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu u Betani i memae, Simona lepelo a numa uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ma wawine gehouna wedu gaimei hi dewadewaya u hinena wakatu dimudimumuna i awali po i nei wakatuna mihana i lata duma ma weduna galenana i haki wahaga, ma Yesu uyahina i hiwogi. ");
INSERT INTO tbo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma Yesu a hewahewali wawinena hi gagaleya po uyohi i gigai po hi baha hi pa, ‘Babana awai po wakatu geka u dewa guyougeya? ");
INSERT INTO tbo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wakatu geka emoemotana hita gimalena haleya po mone baneina hita waya po dayadayabu hita welehi.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma Yesu hai wibaabani amaka i hanapugeya yaka i baha nae uyahihi i pa, ‘Geka wawinena ega ona genogenogeya. Awai uyahiu i dewadewaya naka i haki duma. ");
INSERT INTO tbo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tu dayadayabu hai hagu binei apo houga magomagouna u liyaliyami hina memae ma tau apega houga daodaona ta memae. ");
INSERT INTO tbo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wawinena i bunabunamiu naka hiniu i wononogogeya apo hoi kokowaga hina huhouniu binei. ");
INSERT INTO tbo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A baha duma uyahimi yohola apo tuwegau hina guuguyeya lawa atapuhi uyahihi po hina noonoli ma gasi wawine geka a bagibagi uyahiu i dewadewaya apo hina deedeya ani nugomomota tauna binei.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ega yaka Yesu a hewali gehouna gowana Yudasa Isakaliyota i nae witalaguyaba babadahi uyahihi ");
INSERT INTO tbo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","po i paliwelehi i pa, ‘Mone a lata awai apo ona weleu, ma Yesu uyahimi a palihaleya?’ Ega yaka mone bibitutuna magouhi 30 hi weleya. ");
INSERT INTO tbo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naka hougana Yudasa a gaogao i biheiha ipa iyowai ma apo Yesu ina nugohaleya. ");
INSERT INTO tbo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Welulagona tolehana uyahina palawa ega ani lihaahanana houga amna, noka iyeta emosi hota i iotonana, ma Yesu a hewahewali hi nei uyahina po hi pa, ‘Meka tuponana u luhogaleya apo uyahina toleha bimgei to wononogogeya?’ ");
INSERT INTO tbo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu i pa, ‘Meyagai baneina ona luiya po lawana amaka o hanapugeya ona paliweleya ona pa, “Bada geka pita a baha uyahim, i pa u houga dumana i tuliyaliyani, yaka apo u hewahewali mitehi welulagona tolehana om numa uyahina ton’ani.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ega yaka Yesu a baha hi wotagoya po Welulagona tolehana hi wononogogeya. ");
INSERT INTO tbo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aipompom Yesu a hewahewali magouhi 12 mitehi hi lui po hi duhuna po hi’mam. ");
INSERT INTO tbo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma hai amna u hinena Yesu i baha i pa, ‘A baha duma uyahimi uyahimiyei apo lawa gehouna ina nugohaleu.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yesu a baha geka binei ma hi nugodubu, yaka emosi po emosi Yesu i laubayadeya i pa, ‘Guyau iyai? Nugote tau?’ ");
INSERT INTO tbo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ega yaka Yesu i baha i pa, ‘Lawana mitehi gaeba emosi uyahina to wohopu gogona tauna apo ina nugohaleu. ");
INSERT INTO tbo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lawa Moinau apo a hilage, mei Yaubada a Buka uyahina hi gilugilumi pite, tamogi lawa awai Lawa Moinau ina nugonugohaleu naka tauna tu nugodubu. Itapa lolowa ega hita guni po ita lata apo ita haki wahaga, ma apo ina winugototogo duma a apapoe binei.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ega yaka Yudasa Yesu tu nugohalenana i baha i pa, “Guyau, nugote tau?’ Ma Yesu i baha i pa, ‘Amaka u bahena mem.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hai am uyahina Yesu aniani i waya po i wimaamala ma i tomutomuya po a hewahewali i welewelehi ma i baabani i pa, ‘Geka hiniu ona waya po on’ani.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma keyaka i waya po i wimaamala ma i welehi, ma i baha i pa, ‘Magomagoumi on’umaya, ");
INSERT INTO tbo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","geka talau Yaubada a wogatala binei lawa atapuhi hai apapoe paligigilana binei apo ina kololo. ");
INSERT INTO tbo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma a paliwelemi amalai ma i wawala po i nenae apega wine a umaya a sigana taumi ma tau Amau anani taniwaga uyahina, wine wouna apo tan’umaya.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ega yaka hi lulougo ma hi hopu po hi gae Oliweta oyana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu i baha nae uyahihi i pa, ‘Ididibala geka atapumi apo ona lowo haleu, mei Yaubada a Buka i bahebaheya i pa, “Tu galena itete sipi ana ilawi ma sipi magomagouhi hina nohanoha mehi.” ");
INSERT INTO tbo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma u towolo meme u mulina apo a tahatahaya nae u Galili ma taumi muliugei ona nei.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita i baha kadidili i pa, ‘Atapuhi apo hina lowo halem, ma tau apega a lowo halem.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma Yesu Pita uyahina i baha nae i pa, ‘A baha duma uyahim, kamkam olotona apega ina tou, a sigana mala tonuga una bowiyeu.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Pita i baha i pa, ‘Apeega. Apo hina laihilagenim, yaka tau gasi hina lihilageniu. Apega a bowiyem.’ Ma atapuhi hi baha hi pa, ‘Tauyai gasi, apega to lowo halem.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu a hewahewali tauhi mitehi hi nae tano Gesemani uyahina, ma i paliwelehi i pa, ‘Geka hotanana ona memae ma tau kikina a tunae po a lupali.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ega yaka hai tonuga i weluwinihi po mitehi hi nae, Pita ma Sebedi natunatuna luwaga, ma Yesu anai nugowiyuwana po anai nogohelelena. ");
INSERT INTO tbo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ega yaka i paliwelehi i pa, ‘Nugonugou i wiyuwa duma nugote kikina ma apo a hilage, uyahinei geka hotanana ona memae ma ta gagalena imahi.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ma Yesu tupona i tunae ma i polou hoi hipuli ma i lupali i pa, ‘Amau, apo emoemotana yaka geka wiyuwa keyakana uyahiu una wihaleya. Tau u nugotuhu hawena ma tam om nugotuhu una dewa tagoya.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ma i gunawileya a hewahewali uyahihi po hi eneno ma i tuhagahi, ega yaka Pita uyahina i baha nae i pa, ‘Pita, ega emoemotam kabudala gaogaona emosi ma ta gagalena? ");
INSERT INTO tbo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ona gagalena ma ona laupali po ipa ega ludadana ona ialoni. O luhogaleya ipa ona haguwe ma hinimi hi begabega.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu i gunawilena meya po i lupali i pa, ‘Amau, wiyuwa keyakana ega ata luhogaleya an’umaya, tamogi ipa om nugotuhu a wotagoya.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma i gunawilena meya a hewahewali uyahihi po hi eneno ma i tuhagahi, babana matahi hi pota. ");
INSERT INTO tbo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ega yaka i nehalena mehi po i nae a lupali i witonugaya, ma a lupali i lilugo meya. ");
INSERT INTO tbo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma i gunawilena meya po a hewahewali uyahihi i baha nae i pa, ‘Iyowai yohola o eneno, ma o iyagohina? Ona galeya u houga amaka i geleta po tau Lawa Moinau hina nugohaleu tu apapoe u nimahi. ");
INSERT INTO tbo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ona towolo po ta nae babana tu nugohaleu amaka e nenei.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu yohola i ibaabani ma Yudasa i geleta tauna a hewali gehouna. Ma lawa hi nenei naka witalaguyaba babadahi po mi Yudeya hai tanitaniwaga hi himilihi po Yudasa mitehi hi nei ipa Yesu hina numa panipani, a nimagawiya gapolahi anai kwasikwasihi po anai dabalumahi hi nei Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ma Yudasa wekiwekilala gehouna uyahihi i baheya i pa, ‘Apo ona gagaleu ma lawana a nae po niuna a yagoyagoni, naka tauna Yesu apo ona womomohi.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ega yaka i dumalu po i nae Yesu uyahina po niuna i yagoni ma i mamali i pa, ‘Tinani Guyau.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yesu i baha nae Yudasa uyahina i pa, ‘Tulau, awai binei u nei?’ Ma tu wigawiya hi nei po Yesu hi womomohi. ");
INSERT INTO tbo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma Yesu a bolu uyahihiyei lawa gehouna nimana i wohopuneya po a kwasikwasi i holi po tu witalaguyaba hai taniwaga a tu bagibagi i lubuya po tanigana i talutuiya. ");
INSERT INTO tbo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Yesu lawana uyahina i baha nae i pa, ‘Amaka ma om kwasikwasi ani hounana uyahina una houna meya, babana tu wigawiya witona hai ani hilage. ");
INSERT INTO tbo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A paliwelem inapa a lupali Amau uyahina hagu binei, yaka apo tu winoyanoya yadei bolu banei dumana ina himilihi. ");
INSERT INTO tbo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tamogi apeega, babana geka tahayana amaka Yaubada a Buka uyahina hi bahebaheya ipa limoinana ina geleta.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naka hougana Yesu bolu uyahihi i baha nae i pa, ‘Iyowai po nimagawiya gapolami o nei biugei mei tau tu danene? ");
INSERT INTO tbo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma iyowai po iyeta magomagouna numa dalabu baneina uyahina a iyatatiyana ma ega ota paniu, ma geka dewahi ipa hina geleta po tu bahapiko hai wibaabani atapuhi Yaubada a Buka u hinena hi gilugilumihi anohi hina limoinehi.’ Ega yaka Yesu a hewahewali atapuhi hi lowo haleya. ");
INSERT INTO tbo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tu wigawiya boluhi Yesu hi numa panipani po hi niyeya tu witalaguyaba hai taniwaga gowana Kayapa uyahina, ma Kayapana a numa u hinena naka lugagayo tanitaniwagahi po mi Isalaela hai tanitaniwaga hi’mboina gogona po hi memae. ");
INSERT INTO tbo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Pita mulihiyei i wotago po i nae tu witalaguyaba hai taniwaga a numa u gali hinena i lui po tu galena itete mitehi hi tugutugula, ma i lautanigana ipa apo Yesu a taniwaga awai hina weleya. ");
INSERT INTO tbo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma tu witalaguyaba babadahi po tu wiwogatala atapuhi Yesu hi gou koyakoyameya ipa iyowai ma Yesu a baba awai hina tuhagaya po hin’uni. ");
INSERT INTO tbo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma tu wigou koyakoyama hi nei po Yesu hi igouya ma ega kikina lawa luwaga hai wigou nonolahi emosi. Ma muliyei lawa luwaga hi nei po ");
INSERT INTO tbo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hi baha hi pa, ‘Yesu lolowa i baha i pa, “Emoemotau apo numa dalabu geka a hoe haleya ma iyeta tonuga u hinena ma apo a wogo meya.” ’ ");
INSERT INTO tbo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ega yaka tu witalaguyaba hai taniwaga i towolo po i baha i pa, ‘Iyowai? Ega emoemotana po noka lawahi hai wigou una wimiheya? Hai limoinana amaka ta nonoli ma om baha awai?’ ");
INSERT INTO tbo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Yesu i genuwana. Ega yaka tu witalaguyaba hai taniwaga Yesu i paliweleya i pa, ‘A taniwagem Yaubada Memewahagana u matana, una baha dumalu, tam Besinana lawana, Yaubada Natuna?’ ");
INSERT INTO tbo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Yesu i baha i pa, ‘Naka amaka u baheya, ma a paliwelemi apo yohola tau Lawa Moinau, Tu maninidumana u awala hinebawana a tugutugula ma ona gagaleya, ma yaloi uyahinei a hopu mai.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Uyahinei tu witalaguyaba hai taniwaga uyona i gigai ma a kaleko i loloya ma i baha i pa, ‘A baha o nonoli, Yaubada i widibogi. Amaka ma ega tu wigou hina ibaabani a powa binei. ");
INSERT INTO tbo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ma iyowai taumi omi winugonugotuhu Yesu binei?’ Ma tauhi hi baha hi pa, ‘Yesu ina hilage.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma hi howaya ma hi lunawatatani ma gehouhi hi kodikodili ");
INSERT INTO tbo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma hi laubayadeya hi pa, ‘Inapa tam Besinana lawana yaka una wipiko iyai i launim?’ ");
INSERT INTO tbo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma Pita hoi galihine i memae ma tu bagibagi guguhinina gehouna i hopu mai po i baha nae i pa, ‘Tam lawa Galiligei lolowa Yesu mitehi u memae.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma lawa magomagouhi u matahi ma i bowi i pa, ‘Om wibaabani anona ega ata hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ega yaka Pitana i tudeiwa nae gali u matetana, ma guguhini gehouna Pita i galeya yaka lawa hi towotowolo uyahihi i baha i pa, ‘Naka lawana lolowa Yesu lawa Nasaletagei mitehi hi memae.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita i bowi meme ma i wigwala i pa, ‘Naka lawana tau ega ata hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hi memae houga kukuna ma lawa gehouhi hi nei Pita uyahina po hi pa, ‘Baha dumana tam Yesu a bolu gehouna, babana ponam gololona mei mi Galili ponahi gololona.’ ");
INSERT INTO tbo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ega yaka Pita i wigwala labatana i pa, ‘U gwala amau, naka lawana tau ega ata hanapugeya.’ Naka kabudalana uyahina kamkam olotona i tou. ");
INSERT INTO tbo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma Pita, Yesu a baha i nugotuhuya i pa, ‘Apega kamkam olotona ina tou, a sigana mala tonuga una bowiyeu.’ Ma i hopu hoi uputa po i tou duma. ");
INSERT INTO tbo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Malitom ma tu witalaguyaba babadahi atapuhi po gasi mi Yudeya hai tanitaniwaga hi baha gogona ipa Yesu hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ega yaka Yesu hi numa panipani po hi niyeya Pilato uyahina, babana tauna mi Loma hai taniwaga. ");
INSERT INTO tbo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesu tu nugohalenana Yudasa i hanapugeya ipa apo kikina ma Yesu hina lihilageni, yaka nugonugona i buiya, po a mone bibitutuna magouhi 30 i waya ma i gunawilena meya tu witalaguyaba babadahi po gasi mi Yudeya hai tanitaniwaga uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Po i baha i pa, ‘Amaka a powaya, babana lawa dewadewana uyahimi a nugohaleya.’ Ma hi baha hi pa, ‘Tauyai uyahiyai ega genona, ma tam tunawam om geno.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ega yaka mone bibitutuna magouhi 30 numa dalabu u hinena i nohaya ma i nae po gulawa uyahinei i take po i hilage. ");
INSERT INTO tbo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma tu witalaguyaba babadahi monena hi tuwaluhi po hi pa, ‘Ega a dumalu ipa numa dalabu ombenenana binei ta houni, babana geka monena lawa a hilage mihana.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ega yaka tunawahi ma hi nugonugotuhu po geka monena hi waya po walata tu bagibagiyena a hipuli hi gimaleya, po ipa hipulina tauhi tu wihewahewa hai kokowaga. ");
INSERT INTO tbo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ma hipulina hi wigowaya po hi pa, ‘Tala Hipulina’, geka gowanana yohola e memae. ");
INSERT INTO tbo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Noka uyahina ma tu bahapiko Yelemaya Yaubada a baha uyahina i bahebaheya anona i lugeleteya, i pa, ‘Mi Isalaela mihana hi baheya, ma naka monena bibitutuna magouhi 30 hi waya, ");
INSERT INTO tbo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","po walata tu bagibagiyena a hipuli hi gimaleya, mei Guyau a taniwaga uyahiu.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pilato mi Loma hai taniwaga baneina Yesu u matana i towolo. Ma Pilato Yesu i lubayadeya i pa, ‘Tam mi Yudeya hai wasawasa, bo?’ Ma Yesu i baha i pa, ‘Tam, om baha naka pite.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tu witalaguyaba babadahi po mi Yudeya hai tanitaniwaga Yesu hi igouya ma ega kikina awai ita baheya. ");
INSERT INTO tbo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ega yaka Pilato i baha i pa, ‘Iyowai geka bahahi uyahihiyei hi igoum amaka u nonolihi?’ ");
INSERT INTO tbo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Yesu ega kikina baha awai ita baheya, ma i genugenuwana. Uyahinei ma Pilato nugonugona i gohola dumaya. ");
INSERT INTO tbo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bolima emosi po emosi Welulagona tolehana uyahina mi Loma hai taniwaga a dewa apo lawa hoi numa panipani he memae, apo lawa boluhi ma iyai hina nugotuhuya po hina baheya yaka apo ina lupena haleya hoi po ina hopu. ");
INSERT INTO tbo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma naka hougana lawa gehouna hoi i memae ma lawa magomagouhi gowana hi hanapugeya, Balaba tauna lawa apapoe dumana. ");
INSERT INTO tbo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ega yaka lawa boluhi hi’mboina mai Pilato uyahina ma Pilato i lubayadehi i pa, ‘Lawa awai o luhogaleya apo a lupena haleya hoi, Balaba bo Yesu hi igowaya Besinana lawana?’ ");
INSERT INTO tbo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato hai matababana amaka i hanapugeya, Yesu hi’mgenagenaliliyeya yaka hi numa panipani po ipa hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Noka hougana Pilato yohola luhetala i noonoli, ma agona baha i himili uyahina i pa, ‘Naka lawana uyahina ega awai una dewadewaya, tauna lawa dumadumaluna, babana uguwei a luboniyeya po a matouta duma.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hi ibaabani ma tu witalaguyaba babadahi po mi Yudeya hai tanitaniwaga lawa hi lihunahi po Pilato uyahina hi bahabaha gawata, ipa Balaba ina hoe haleya m Yesu hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ega yaka Pilota i lubayadehi i pa, ‘Hai luwaga, ma iyai o luhogaleya apo a lupena haleya bimiyei?’ Ma hi baha hi pa, ‘Balaba.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Pilato i lubayadehi i pa, ‘Yesu hi igowaya Besinana lawana iyowai apo a dewaya?’ Ma lawa atapuhi hi otu labatana hi pa, ‘Una witakeya!’ ");
INSERT INTO tbo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ega yaka Pilato i lubayadena mehi i pa, ‘Ma powa awai i dewaya?’ Ma hi otu labatana hi pa, ‘Ona witakeya!’ ");
INSERT INTO tbo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yaka Pilato amaka i nugotuhuya ega a kadidili gehouna, babana bolu baneina hi wihigihigili duma po galenahi mei hina itona, ega yaka goila i waya po u matahi nimana i ogaya ma i baha i pa, ‘Apega awai gehouna a dewaya geka lawana uyahina po a hilage binei a taniwaga, taumi tunawami apo ona taniwageya.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma lawa boluhi hi baha hi pa, ‘To baha ipa ina hilage, ma a hilage witeina tauyai po natunatuyai uyahiyai ina memae.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Geka bahana u mulina Pilato i baha po Balaba hi lupena haleya ma Yesu gulawa metametanana uyahinei hi wilawi ma ipa hina niyeya po hoi ani take hina tutulawiteya. ");
INSERT INTO tbo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ega yaka mi Loma hai tu wigawiya Yesu hi luiya taniwaga a numa baneina u hinena, ma tu wigawiya hai bolu atapuna hi’mboina gogona mai Yesu uyahina, ");
INSERT INTO tbo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","po a kaleko hi wihaleya ma wasawasa hai kaleko kayakayana hi wiluiya. ");
INSERT INTO tbo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma a unuhau gologolowa waidonadonana hi dewaya po u unununa hi houni ma digona u awala hinebawana hi houni, ma u matana hi polou ma hi lauguyaguyau hi pa, ‘Tinani, tam mi Yudeya hai wasawasa?’ ");
INSERT INTO tbo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma hi howaya ma digona hi waya po uyahinei unununa hi ilawi. ");
INSERT INTO tbo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hi luguyoguyougena woloeya ma wasawasa hai kaleko hi wihaleya ma tauna a kaleko dumana hi wiluiya, ma hi niniyeya ipa hina witakeya. ");
INSERT INTO tbo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yelusalem hi nehaleya po hi nenae, ma Simona lawa Sailinigei hi tuhagaya po ega yaka hi baha po Yesu anani take mayouna i awala haguya. ");
INSERT INTO tbo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hi nae po hi geleta u Gologota, a bui naka Ununu Dobuna. ");
INSERT INTO tbo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ega yaka wine mulamula waigolana mitehi hi wila emoteya ma hi weleya, ma Yesu wine noka i uma dadani ma i wihinigigiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ma Yesu hoi ani take hi tutulawiteya po i kokoe ma a kaleko hi wikibugehi po hi tamihi. ");
INSERT INTO tbo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Gohagohana i kokoe ma hi tugula po hi gagalena iteteya. ");
INSERT INTO tbo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma ani take u tepana ani wigouna hi giluma geleteya hi pa: ");
INSERT INTO tbo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tu danene luwaga mitehi hi witake gogonehi gehouna u awala hinebawana ma gehouna u awala kehana. ");
INSERT INTO tbo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lawa liyaliyanei hi nenae ma hi bahabaha gae ma hi ununu kwadikwadiyana ma hi palipaliyeya hi pa, ");
INSERT INTO tbo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","‘U baha u pa emoemotam apo numa dalabu una hoe haleya, ma iyeta tonuga u hinena una wogo meya, ma heki, tam tunawam una luyawata mem po ani take uyahinei una hopu mai apo inapa tam Yaubada Natuna yaka.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mei gasi tu witalaguyaba babadahi po lugagayo tanitaniwagahi po mi Yudeya hai tanitaniwaga hi palipaliguyaguyau hi pa, ");
INSERT INTO tbo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‘Lawa gehouhi i wiluyagohanihi hapali tauna ina wiluyagohana meya? Ipa tauna Isalaela ata wasawasa, heki, geka hougana ani take uyahinei ita hopu mai po tata galeya ma tata witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tauna Yaubada i witumaganeya po i pa, “Tau Yaubada Natuna.” Heki, geka hougana Yaubada ina haloya po ta galeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mei tu danene Yesu mitehi hi take gogonehi tauhi gasi Yesu hi widibogi. ");
INSERT INTO tbo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Iyeta i lautipolini ma kabudala lalana i wohouni po tupo atapuna i uguguwi a sigana kabudalana i hopu po ibiga i lutipolini. ");
INSERT INTO tbo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Houga noka uyahina Yesu i otu i pa, ‘Eloi, Eloi, lama Sabatani?’ anona ‘U Yaubada, u Yaubada, awai binei u nehaleu?’ ");
INSERT INTO tbo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma lawa gehouhi u liyaliyana hi towotowolo geka bahana hi nonoli po hi pa, ‘Geka lawana nugote Elaisiya e ototugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mala emosi ma lawa gehouna i bulili nae po baloi i waya po wine waitululuwana uyahina i wiyoli ma hige uyahinei i tupahigeya po i wiyoyoga giyeya u gamona ipa ina hanaguguya. ");
INSERT INTO tbo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma lawa gehouhi hi baha hi pa, ‘Heki, una wohouna ma tana iotonana ma apo Elaisiya ina nei po ina wiluyagohani.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma Yesu i otu labatana meme ma yautuna i kokoe. ");
INSERT INTO tbo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma numa dalabu baneina libulibuna kaleko baneina i taketake i gunalolo luwageya u moyana ma i hopu po u babana, ma guhuguhu i geleta po gaima baneihi hi gunahedalihi. ");
INSERT INTO tbo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma kokowaga lobodahi hi gunahoenihi po tu wiwoiyawa magomagouhi odubona hi hilage po hoi kokowaga hi memae hi towolo meme. ");
INSERT INTO tbo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma Yesu a towolo meme u mulina tauhi hi nae Yelusalem po lawa magomagouhi uyahihi hi laugeletehi. ");
INSERT INTO tbo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma tu wigawiyahi hai taniwaga mitehi Yesu hi gagalena iteteya ma guhuguhu po gasi awai po awai hi gelegeleta ma hi gagalehi po hi matouna duma po hi pa, ‘Baha dumana geka Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wiwine gehouhi uheiya hi towolo ma Yesu hi gagaleya, tauhi lolowa u Galili ma hi wotagoya po a hagu hi dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gehouna gowana Maliya Magadalagei, ma a waligeha Yamesa ma Yosepa hinahi, ma gasi Sebedi natunatuna luwaga hinahi. ");
INSERT INTO tbo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ma amaka aibiga yaka lawa Alimatiyagei tu waigapola lawana gowana Yosepa tauna Yesu tu wotagona gehouna i nae ");
INSERT INTO tbo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato uyahina po Yesu hinina i lupaliyeya ipa ina waya po ega yaka i palihaleya po ipa ina waya. ");
INSERT INTO tbo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Apoma Yesu hinina i waya po kokowaga kalekonei i humaya ");
INSERT INTO tbo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma hoi kokowaga i houni. Kokowagana naka tapatapana hi hedali po i lui ma yohola ega hita houneya, ma guduna gaima baneina hi buileya po uyahinei kokowagana hi lutomgeya ma i nae. ");
INSERT INTO tbo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma Maliya Magadalagei a waligeha mitehi kokowaga matetana u liyaliyana hi tugutugula. ");
INSERT INTO tbo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesu hi itakeya naka mi Yudeya hai iyeta wononogo, ma malitom po hai dalabu iyetana uyahina tu witalaguyaba babadahi po gasi Palisi lawahi hi nae Pilato uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Po hi baha hi pa, ‘Bada, tu wikoyakoyamana lolowa a yautuna ma i bahabaha to nugotuhuya i pa, “Iyeta tonuga ma apo hilagei a towolo meme.” ");
INSERT INTO tbo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ma emoemotana apo uta baha po kokowaga tu galena itetehi hita galena itete imahiyeya iyeta tonuga u hinehi, meka po apo a hewahewali hina nei po Yesu hinina hina waya po hina houna gowadi ma lawa hina koyamehi po hina pa, “Yesu amaka hilage uyahinei i towolo meme,” po Yesu a hewahewali hai koyama waimulina a koyama tahatahayana ina lata lagoni.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ega yaka Pilato i paliwelehi i pa, ‘Omi tu galena itete he memae, ona niyehi po kokowaga hina galena itete imahiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yaka hi nae kokowaga u matetana po guduna hi pupu imahiyeya ma tu galena itete hi witowolihi. ");
INSERT INTO tbo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mi Yudeya hai dalabu i kokoe, ma gaogao a iyeta tahatahayana uyahina malatomtom kikina Maliya Magadalagei, a waligeha mitehi hi nae ipa kokowaga hina galeya. ");
INSERT INTO tbo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma guhuguhu baneina i gelete, naka Guyau a tu winoyanoya gehouna yadei i hopu mai po kokowaga matenanei gaima i buileya ma u tepana i tugula. ");
INSERT INTO tbo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tu winoyanoya galenana i namanamali ma a kaleko i wakeke duma. ");
INSERT INTO tbo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma kokowaga tu galena itetena tu winoyanoya hi gagaleya po hi matouta, po hi taatawa ma hi guli mei lawa hilahilagehi. ");
INSERT INTO tbo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma tu winoyanoya wiwinehi i paliwelehi i pa, ‘Ega ona matomatouta. A hanapugemi taumi Yesu hi laihilageni o bibiheya. ");
INSERT INTO tbo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tauna ega geka hotana ita memae amaka i towolo meme, mei lolowa i palipaliwelemi pite. Ona nei po anani eno ona galeya kokoena. ");
INSERT INTO tbo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ma ona nae po a hewahewali ona paliwelena yagiyaginehi ona pa Yesu amaka hilage uyahinei i towolo meme po e tahatahaya nae u Galili, ma taumi noka hota apo ona galeya. Geka omi tuwega amaka a paliwelemi.’ ");
INSERT INTO tbo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ega yaka wiwinehi hi matouta ma gasi hi kaoha, ma kokowaga hi nehaleya po hi neyagiyagina po hi nae Yesu a hewahewali uyahihi po awai hi gelegeleta hi paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mala emosi ma Yesu i tuhagahi po i mamalihi i pa, ‘Tinani,’ ma hi polou po aena hi wogoya ma hi wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Yesu i paliwelehi i pa, ‘Ega ona matomatouta ma ona nae po walewalehiu ona paliwelehi po hina nae u Galili po noka hotana apo hina galeu.’ ");
INSERT INTO tbo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Geka wiwinehi yohola tahayagei hi nenae, ma kokowaga tu galena itete hi nae Yelusalem po awai hi gelegeleta tu witalaguyaba babadahi hi paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ega yaka tu witalaguyaba po mi Yudeya hai tanitaniwaga mitehi hi’mboina ma hi wiwogatala po mone baneina kokowaga tu galena itetena hi welehi ma hi lugagayogehi, ");
INSERT INTO tbo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","po ipa ega lawa hina palipaliwelehi, ma hina baha hina pa, ‘Uguwei to eneno ma Yesu a hewahewali hi nei po hinina hi daneneya.’ ");
INSERT INTO tbo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma gasi hi paliwelehi hi pa, ‘Inapa mi Loma hai taniwaga tuwega geka ina nonoli yaka apo to koyameya po ega ina lauuyogigai uyahimi.’ ");
INSERT INTO tbo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ega yaka hai mone hi tama, ma babadahi hai baha hi wiponawogogeya po hai widededena hi nohaya mi Yudeya atapuhi uyahihi po amalai he ibaabaniyeya. ");
INSERT INTO tbo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ega yaka Yesu a hewahewali magouhi 11 hi nae u Galili po hi gae oya Yesu i bahebaheya uyahina. ");
INSERT INTO tbo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Po Yesu hi galeya ma hi wotalagiyeya, tamogi uyahihi gehouhi yohola hi launugoluwaluwaga. ");
INSERT INTO tbo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ega yaka Yesu i nei uyahihi po i paliwelehi i pa, ‘Amau taniwaga atapuna hoi yada po hoi hipuli amaka i weleu, ");
INSERT INTO tbo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","yaka ona nae tupo atapuna uyahina po ona lauguguya lawa uyahihi po hina wotago uyahiu. Ma Amau gowanei, po tau Natuna gowaugei, po Alugo Woiyawa gowanei ona ibapatisohi. ");
INSERT INTO tbo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma wiatatiyana atapuna amaka a welemi, ma lawa ona wiatatiyehi po hina wiponawogo. A baha duma uyahimi apo tau houga magomagouna mitemi ta memae, amalai po a siga hipuli anani kokoe uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Geka tuwega dewadewana i waawala Yesu Keliso binei, tauna Yaubada Natuna. ");
INSERT INTO tbo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tu bahapiko gehouna gowana Isaiya Yaubada a baha i bahebaheya i pa, ‘U tu winoyanoya apo a himila tahaem po om tahaya ina wononogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Lawa gehouna hoi balabala yabayababa e iototu i pa, “Guyau a tahaya ona wononogeya. A tahaya ona lidumaluhi.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Uyahinei Yoni tu wibapatiso i geleta Yudeya balabalana uyahina apapoe paligigilana binei nugobui bapatisona i lauguguyeya. ");
INSERT INTO tbo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lawa boluhi tupo Yudeyagei po dobu Yelusalemgei hi liya mai Yoni uyahina. Hai apapoe hi bahena geletehi ma Yoni i bapatisohi goila Yodani uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni a mae ega ita dewadewa babana a kaleko kamelo apalana, ma a dagilolo gamogamo opina ma a yam madimadi ma tuwoya i ananihi. ");
INSERT INTO tbo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yoni a guguya Yesu binei i pa, ‘Lawana muliugei e nenei naka i gelagoniu ma ega u dewadewa awai ipa apo a polou po a aehumahuma a lupeni. ");
INSERT INTO tbo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tau goilei a bapatisomi ma tauna apo Alugo Woiyawei ina wibapatisomi.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Noka hougana Yesu Nasaletagei i nei Galili tuponanei. Yesu i nei Yoni uyahina po Yoni Yesu i bapatisoya goila Yodani uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Goila uyahinei Yesu i togo geleta po yada i gagaleya ma i gunahoeya po Alugo Woiyawa mei bunebune i hopu mai tauna uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma pona yadei i hopu mai i pa, ‘Tam Natuwe a luhogalem, ma bimgei a kaoha.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Naka hougana Alugo Woiyawa Yesu i himili po i nae balabala yabayababa uyahina, ");
INSERT INTO tbo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","po noka hota i memae iyeta magouhi 40, ma Tomodulele Yesu i laudadani. Ma balabalana uyahina gamogamo woyahiyahihi hai ani mae ma tu winoyanoya mi yadena Yesu hi galena iteteya. ");
INSERT INTO tbo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Heloda Yoni i numa panipani po hoi numa panipani i houni, ma u mulina Yesu i nae tupo Galili uyahina po tuwega dewadewana i guguyeya Yaubada uyahinei i pa, ");
INSERT INTO tbo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","‘Houga amaka i geleta Yaubada a taniwaga kikina apo ina wawala, uyahinei omi apapoe uyahihiyei ona luhagawilemi po tuwega dewadewana nugonugomiyei ona witumaganeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iyeta gehouna Yesu Galili bogana liyaliyanei i nenae po tu ebaebaga luwaga i tuhagahi, tauhi hi ebebaga. Gehouna gowana Simona ma walehina gowana Andulu ");
INSERT INTO tbo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ega yaka Yesu i otugehi i pa, ‘Ona wimulitagou po lawa ebagahi a wiatatiyemi.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ega yaka hai hagida hi nehalehi ma Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma i tutunae po Sebedi natunatuna luwaga Yamesa ma a tewela Yoni i galehi tauhi hai hagida hi wononogo wam uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Naka hougana Yesu i otugehi i pa, ‘Ona wimulitagou.’ Ma hi towolo yagiyagina po amahi ma a tu bagibagi mitehi hi nehalehi hai wam uyahina ma Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu i nae Kapaneum u meyageina. Iyeta dalabu uyahina hi lui hoi numa dalabu po Yesu i wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma lawa hi nugogohola duma a wiatatiyana binei babana a baha hi wipoya ipa lawa hina wotagoya. Ma ega mei lugagayo tanitaniwagahi hai wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naka hougana lawa gehouna alugo apapoena u hinena i memae ma i otu i pa, ");
INSERT INTO tbo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","‘Yesu tam Nasaletagei. Awai ipa uyahiyai una dewaya? U nenei ipa una wiapapoeniyai? Ma a hanapugem tam iyai. Tam Yaubada galinei waiwoiyawam.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu i paliyeya i pa, ‘Una genuwana ma una nehaleya!’ ");
INSERT INTO tbo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yesu i baha yaka alugo apapoena lawana i tapeitatawa dumaya ma i otu labatana apoma lawana i nehaleya. ");
INSERT INTO tbo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lawa atapuhi hi gohola dumahi po tunawahi hi lulubayadena mehi hi pa, ‘Geka awai? Geka nugote wiatatiyana wouna. Tauna a wipoyagei alugo apapoehi i taniwagehi po hi wiponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Noka hougana Yesu tuwegana hi nohaya meyagai atapuhi uyahihi Galili u tuponana. ");
INSERT INTO tbo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kapaneum numa dalabuna hi hopu haleya po hi nae Simona ma Andulu hai numa uyahina ma gasi Yamesa ma Yoni mitehi. ");
INSERT INTO tbo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hi geleta po Yesu hi paliweleya hi pa, ‘Simona pohiyana i wihinigugupouma po ani eno uyahina e’neno.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yaka Yesu i nae Simona pohiyana uyahina po u nimana i wogo po i witowoli. Ma a gupouma i kokoe. I wotowolo po i poulehi. ");
INSERT INTO tbo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kabudala i yoli po i uguguwi ma lawa tootogohi po tauhi alugo apapoena i luiluinihi hi nehi mai Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tauhi meyageinei hi nei po numa u liyaliyana hi towolo. ");
INSERT INTO tbo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu lawa hai totogo tapuhi po tapuhi i luyawahihi ma alugo apapoehi i wiyagahi ma i paliwelehi ipa hina genuwana po Yesu ega hina palipaligeleteya. ");
INSERT INTO tbo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesu numa i nehaleya po i weludidibala nae hoi balabala po tunawana i laupali. ");
INSERT INTO tbo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simona a lawa mitehi hi’mhoe po hi nae Yesu hi biheya. ");
INSERT INTO tbo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hougana hi tuhagaya po hi paliweleya hi pa, ‘Lawa atapuhi he bibihem.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Yesu i baha i pa, ‘Amaka ma ta nae dobu gehouhi uyahihi po a guguya. Geka bagibagina binei a nei.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma ega yaka Galili atapuna hi wiwileya po i guguya hai numa dalabu uyahihi ma alugo apapoehi i wiyagahi. ");
INSERT INTO tbo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lawa lepelepelona i nei Yesu uyahina po i polou ma i baha gonugonuwa i pa, ‘Inapa nugonugom yaka una wiluyagohaniu.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu i lunugotootogogeya yaka nimana i lodomi po lawana i wodadani ma i pa, ‘Nugonugou a luyawahim. Amaka ma una dewadewa.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mala emosi ma a lepelo i kokoe ma i dewadewa meme. ");
INSERT INTO tbo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Naka hougana Yesu i himihimili ma i baha kadidili uyahina i pa, ");
INSERT INTO tbo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","‘Ega lawa gehouna una palipaliweleya, ma una nae tu witalaguyaba uyahihi po una bahena mem una pa, “Amaka a dewadewa,” ma om ani’mbenena una houni mei Mose a lugagayo bukana uyahina i gilugilumi pite om yeuyeu binei po hina hanapugem tam amaka u luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma lawana Yesu a lugagayo ega ita wiponawogogeya ma i nae po lawa boluhi uyahihi i ibaabaniyeya. Uyahinei Yesu ega emoemotana ina nae meyagai uyahihi babana lawa hi maga duma po hoi balabala i memae, ma lawa tupo atapunei hi nenei Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iyeta wabihaga hi kokoe ma Yesu i gunawileya Kapaneum po hoi numa i memae ma tuwegana lawa hi nonoli. ");
INSERT INTO tbo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma bolu baneina hi’mboina nae po numa hinena matetana hi wihogoya, ma Yesu i guguya uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lawa wohepali lawa waigwameyameyana hi awali po hi nei hoi numa ma ega emoemotahi po hina lui babana numana i hogoya. ");
INSERT INTO tbo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ega yaka tetegei hi’mgeina gae wogo tabataba uyahina ma numa gatowana hi hoeya, ma tu totogo anai ani enona ma hi houna hopuneya Yesu u matana. ");
INSERT INTO tbo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hougana Yesu lawahi hai witumagana i gagaleya po i baha nae totogo lawana uyahina i pa, ‘Natuwe, om apapoe amaka a paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma lugagayo tanitaniwagahi Yesu a baha hi nonoli ma u nugonugohi hi nugowilawila hi pa, ");
INSERT INTO tbo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Awai binei geka lawana Yaubada e palipaliguyoguyougeya? Ega emoemotana lawa awai apapoe ina paligigili ma Yaubada tunawana.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mala emosi ma Yesu u nugonugona hai nugotuhu gowagowada i lugeleteya yaka i baha nae uyahihi i pa, ‘Awai binei o inugowilawila? ");
INSERT INTO tbo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Meka baha dewadewana po apo tu tootogona a paliweleya? Om apapoe a paligigili bo una towolo po om ani eno una waya po una nae? ");
INSERT INTO tbo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Apo uyahimi a limoineya naka tau Lawa Moinau, wipoya Yaubada i weleu po hoi hipuli apapoe a paligigili.’ Ega yaka i baha nae lawa waigwameyameyana uyahina i pa, ");
INSERT INTO tbo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘A bahabaha uyahim, una towolo po om ani eno una awali ma una nae om meyagai uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","U matahi ma i towolo po anani eno i awali po i nae, ma lawa atapuhi nugonugohi hi goholihi ma Yaubada hi wotalagiyeya hi pa, ‘Geka mala emosi hota apoma ta galeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu i gunawilena meya Galili u bogana ma bolu baneina hi’mboina mai uyahina po i wiatatiyana uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma i nenae po lawa gowana Libai amana Alipi, naka lawana tauna takisi tu tama anani bagibagi numana uyahina i tugutugula ma Yesu i baha nae uyahina i pa, ‘Una wotagou.’ Libai i towolo po Yesu i wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Houga naka uyahina Yesu mitehi hi tugula Libai anu numa po hi’mam, ma takisi tu tama po tu apapoe po Yesu a hewahewali mitehi hi tugutugula babana lawa magomagouhi Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma lugagayo tanitaniwagahi naka tauhi Palisi lawahi hi gagaleya tu apapoe po takisi tu tama mitehi hi’mam ma a hewahewali hi lubayadehi hi pa, ‘Awai binei omi bada takisi tu tama po tu apapoe mitehi he’mam?’ ");
INSERT INTO tbo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu hai baha i nonoli yaka i paliwelehi i pa, ‘Lawa ega hita tootogo ega tu lumulamula nugonugohi ma tu tootogo tauhi nugonugohi tu lumulamula. A nenei ega ipa tu dewadumalu a otugehi, ma tu apapoe a otugehi po hina nugobui.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Houga gehouna Yoni tu bapatiso a hewahewali po Palisi lawahi hai tapalolo uyahina aniani atapuhi ega hita ananihi babana hi hudihudi. Ma Yesu a hewahewali ega hita hudihudi. Lawa gehouhi hi nei Yesu uyahina po hi lubayada hi pa, ‘Awai binei Yoni po Palisi hai hewahewali he hudihudi ma tam om hewahewali ega hita hudihudi?’ ");
INSERT INTO tbo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma Yesu i’mpaliluwaluwa i pa, ‘Itapa tu tawine olotona a tawine tolehana uyahina tauna ita memae, moina apo a toumana hita iyohi? Apega. Hougana tu tawine olotona mitehi hina memae apega hina iyohi. ");
INSERT INTO tbo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tamogi iyeta he nenei apo tu tawine olotona a gawiya hina wihaleya ma noka iyetana uyahina apoma apo hina wiyohi.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma i baha meme uyahihi i pa, ‘Ega iyai luilui wouna ita papaya po luilui odubona uyahina ita hilahilama lawiteya. Inapa ina dewaya yaka naka luiluina wouna amaka i wiapapoeya ma apo gunalolona ina lata. ");
INSERT INTO tbo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma ega iyai wine wouna ita hiwohiwoga hopuneya talagigoila gamogamo opihiyei hi dewadewaya odubona uyahina. Inapa ina dewaya yaka apo winena wouna ina hahana po talagigoilana ina gunahaiya po wine ina kolologeya. Apega iyai ina dewaya. Tamogi wine wouna ipa talagigoila wouna uyahina hina hiwohiwoga hopuneya.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Dalabu gehouna Yesu a hewahewali mitehi yaniyani mei pegapega tanona tipolinei hi nenae, ma a hewahewali hi nae po pegapega ugohi hi’mgomugomu po hi’mam. ");
INSERT INTO tbo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Palisi lawahi hi gagalehi po hi pa, ‘Una galeya. Ata lugagayo i baheya ipa ega hoi dalabu ta wobagibagi ma om hewahewali geka pite he dewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ega yaka Yesu i paliwelehi i pa, ‘Dawita po iyawoi tauna mitehi am hi hilage ma awai i dewadewaya o hiyawa bo eega? ");
INSERT INTO tbo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Naka hougana Abiyata tu witalaguyaba taniwagana Dawita i lui po Yaubada a numa u hinena palawa wailugagayona i waya po i ani, ma a hewahewali i welewelehi. Tamogi ata lugagayo i baheya ipa ega iyai ina anani ma tu witalaguyaba tunawahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ega yaka Yesu i baha i pa, ‘Yaubada iyeta dalabu lawa i welewelehi tauhi galihiyei, ma dalabu ega lawa ita tanitaniwagehi. ");
INSERT INTO tbo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tau Lawa Moinau dalabu taniwagana.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu i gunawileya numa tapalolo uyahina po lawa nimana habehabeluna i memae ma i galeya. ");
INSERT INTO tbo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma Palisi lawahi tahaya hi bibeiha ipa Yesu hina wigouya po hi todi ma hi gagaleya hi pa, apo dalabugei lawana ina luyawahi bo eega. ");
INSERT INTO tbo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ega yaka Yesu lawana nimana habehabeluna i otugeya i pa, ‘Una nei geka u tipolinana.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma Yesu i pa, ‘A lubayademi, ata lugagayo uyahina i baheya ipa hoi dalabu awai ta dewadewaya? Lawa tana idewadewahi bo tana iapapoenihi, bo lawa ta lauyawahihi bo ta ununihi?’ Ma hi genugenuwana. ");
INSERT INTO tbo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu anai uyogigeina i gagalena wilawila uyahihi ma nugonugona i wiyuwa duma babana ega hai lunugotootogo, ega yaka lawana uyahina i pa, ‘Nimam una lodomi,’ ma nimana i lodolodomi po i dewadewa. ");
INSERT INTO tbo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Uyahinei Palisi Heloda hai bolu mitehi hi wiwogatala hi pa, apo iyowai ma Yesu hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Houga gehouna Yesu a hewahewali mitehi hi hopu Galili u bogana ma bolu baneina hi wotagohi. ");
INSERT INTO tbo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bolu geka dobuhigei hi nenei naka tupo Galili ma Yudeya ma Yelusalemgei hi nei, Idumeya tuponana uyahinei hi nei, Yodani goilana u tuponanei hi nei, ma gasi meyagai baneihi, Saidoni ma Taya u liyaliyahigei hi nei. ");
INSERT INTO tbo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ma bolu i lata duma yaka i baha nae a hewahewali uyahihi i pa, ‘Wam ona neiyai ma lawa he pitapita mehi ma hoi wam apo a gelu. ");
INSERT INTO tbo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Babana Yesu tu tootogo uyahihi i wobagibagi. Ma lawa hi pitapita mehi po Yesu hi wodadani. ");
INSERT INTO tbo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bolu u hayahi lawa gehouhi alugo apapoehi hi luinihi ma Yesu u matana hi polopolou ma hi ototu hi pa, ‘Tam Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ega yaka Yesu i paliwelehi i pa, ‘Ega ona palipaligeleteu lawa uyahihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu a bagibagi u boga i luwegahi ma i gae u oya, po bolu uyahihiyei lawa i lauhogalehi i otugehi po hina nae uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma magouhi 12 i witowolihi ma i wigowahi tu wituwetuwega ipa apo mitehi hina memae po ina himilihi tupo gehouhi uyahihi po hina luguguya. ");
INSERT INTO tbo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma hai wipoyagei apo alugo apapoehi lawa uyahihi hina wihalehi. ");
INSERT INTO tbo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yesu a hewahewali magouhi 12 i naganihi gowahi gegeka: Simona, Yesu i wigowaya Pita, ");
INSERT INTO tbo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yamesa ma walehina Yoni tauhi Sebedi natunatuna, ma Yesu i igowahi Palele natunatuna, tauhi ponahiyei i baheya Bowanati, ");
INSERT INTO tbo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andulu, Pilipo, Batolomiu, Matiu, Tomasi, Yamesa Alipi natuna, Tadiyesi, Simona tauna tu’mgudugudu mi Loma hai ani taniwaga uyahinei, ");
INSERT INTO tbo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Yudasa Isakaliyota Yesu tu nugohalenana. ");
INSERT INTO tbo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu a hewahewali mitehi numa gehouna uyahina hi lui ma bolu gehouhi hi’mboina mai po ega emoemotahi hin’omagotupo babana lawa hai gaoago ega hita welehi. ");
INSERT INTO tbo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesu a guguni noyana hi nonoli po binei hi nae po ipa hina weluwaya, babana lawa hi baheya hi pa Yesu ita badebade. ");
INSERT INTO tbo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma lugagayo tanitaniwagahi Yelusalemgei hi hopu mai po hi paliguyoguyougeya hi pa, ‘Ega naka tauna a kadidiligei ita wobagibagi ma Tomodulele, palouma hai bada, a manini uyahinei alugo apapoehi e iyagahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu lugagayo tanitaniwagahi hai baha i nonoli, yaka paliluwaluwagei i baha nae uyahihi i pa, ‘Omi bahahi ega baha dumahi. Awai binei apo palouma tulana ina wigawiyeya? Tauna tulana. ");
INSERT INTO tbo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Apo ani taniwaga gehouna u tipolina ina gunakahaya po hina igawigawiyena mehi apo hai mae ina apapoe. ");
INSERT INTO tbo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Apo gasi guguni emosi ma u tipolina ina gunakahaya po hina igawigawiyena mehi, apo hai gugunina ina apapoe. ");
INSERT INTO tbo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Uyahinei ma inapa Tomodulele anani taniwaga ina gunakahaya po hina igawigawiyena mehi apo hai boluna apega ina kadidili ma apo hina kokoe. ");
INSERT INTO tbo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ega emoemotana lawa kadikadidilina a numa ta luiya po a gapola ta danenehi. Inapa numana taniwagana ta womomohi po aena ma nimana ta panipanihi yaka apo ta lui a numa u hinena po a gapola ta danenehi. ");
INSERT INTO tbo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A baha duma uyahimi, lawa hai apapoe po hai baha apapoehi Yaubada emoemotana apo ina paligigilihi. ");
INSERT INTO tbo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma apapoe emosi hota, inapa lawa awai Alugo Woiyawa ina paliguyoguyougeya yaka tauna apega Yaubada ina paligigili ma a apapoe apo ina mewahaga.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu geka i bahabaha nae matababana lawa hi wigouya hi pa, tauna alugo apapoena i luiya. ");
INSERT INTO tbo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hinana ma walewalehina hi geleta Yesu uyahina po numa u uputana hi towotowolo ma Yesu hi giigimeya ipa ina hopu uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bolu Yesu u liyaliyana hi memae hi paliweleya hi pa, ‘Hinam ma walewalehim hoi uputa he bibihem.’ ");
INSERT INTO tbo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu hai baha i wimiheya i pa, ‘Hinau iyai? Ma walewalehiu iyawoi nawa?’ ");
INSERT INTO tbo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma bolu i galehi ma i baha i pa, ‘Geka taumi hinahinau po walewalehiu. ");
INSERT INTO tbo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Apo iyai Yaubada a nugotuhu ina dewadewaya, naka tauna walehiu po nouwe po hinau.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu i gunawileya Galili u bogana ma i wiwawala po i guuguya ma bolu banei dumana hi’mboina mai uyahina, ega yaka Yesu wam uyahina i gelu po i tugula imahi ma bolu hoi dedeyani hi towotowolo. ");
INSERT INTO tbo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma ega yaka baha wiluwaluwagei i wiatatiyehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‘Ona lutanigana, tu lupehi i nae a tano uyahina po a pehi polahi i nohanohahi. ");
INSERT INTO tbo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I ihulu po pola gehouhi hoi tahaya hi peu po kiu hi anihi. ");
INSERT INTO tbo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma pola gehouhi hi peu dobu waigaigaimana uyahina po hi laha yagiyaginehi babana hipulina ega ita potopoto. ");
INSERT INTO tbo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma kabudala a houga lalana uyahina mala emosi ma hi kokodila, babana dedehi ega hipuli dewadewana hita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma pola gehouhi hiyamoni waidonadonana u hayahi hi peu po hougana hi lahalahahi naka donadona i numa panipani unihi. ");
INSERT INTO tbo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma pola gehouhi hipuli dewadewana uyahina hi peu po hi lata po hi ugo. Hai houga ugo naka gehouhi ega hit’ugo imahi ma gehouhi ega hit’ugo duma. Ma gehouhi hi ugo labatana.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uyahinei Yesu i pa, ‘Taumi iyawoi waitanigami yaka ona launonola.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu a guguya i luwegahi po bolu hi’mtuihagola ma a hewahewali po tu wotagona gehouhi mitehi hi memae po hi lubayada hi pa, ‘Nugonugoiyai ipa om baha wiluwaluwa una liyayahihi uyahiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu hai baha i wimiheya i pa, ‘Taumi amaka Yaubada anani taniwaga anona i lugeleteya uyahimi. Ma tauhi tu meuputa baha wiluwaluwa geka hi nonoli ma anona ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Geka binei ma baha wiluwaluwagei i iatatiyana babana, “Apo hina wihalugeya ma apega hina galena tuhagaya po apo hina lutanigana ma apega hina hanapugeya. Ma itapa hita hanapugeya apo hai apapoe hita wihinigigiyehi po Yaubada ita paligigilihi.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu i lubayadehi i pa, ‘Pehi paliluwaluwana ega ota hanapugeya? Yaka baha wiluwaluwa gehouhi apega ona hanapugehi. ");
INSERT INTO tbo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tu wihulu Yaubada a baha e laiholi lawa u nugonugohi. ");
INSERT INTO tbo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pola hoi tahaya hi pipeu naka lawa Yaubada a baha hi nonoli ma Tomodulele bahana u nugonugohi i wihaleya. ");
INSERT INTO tbo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma pola dobu waigaigaimana uyahina hi pipeu, anona naka iyawoi Yaubada a baha anai kaohahi hi nonoli, ");
INSERT INTO tbo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","tamogi ega dedehi uyahinei ma he itumagana po ega daona ma witai po pilipili he wialonihi naka bahana binei ma amaka he peu. ");
INSERT INTO tbo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pola hiyamoni waidonadonana u hayahi he pepeu anona naka lawa Yaubada a baha hi nonoli ");
INSERT INTO tbo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma tamogi hipuli genona ma gapola wasawasahi nugohi i waya po tauhi hai luhogala gowagowadagei bahana hi winugoguluwi po ega ugohi. ");
INSERT INTO tbo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma pola hipuli dewadewana uyahina hi pipeu anona naka lawa tauhi baha hi nonola tuhagaya yaka apo hin’ugugo. Gehouhi ega hit’ugo imahi, gehouhi naka hi ugo duma ma gehouhi hi ugo labatana.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu a baha wiluwaluwa gehouna yayata omgowadana binei, i baha i pa, ‘Ega iyai lampa ita apuya ma gaebagei ita lautataya bo ani eno u gaboulina ita huhouni, tamogi anani tugula uyahina e huhouni. ");
INSERT INTO tbo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Awai gowagowadana apo ina wihabuhabuluna po lawa hina nonoli. Ma awai gowagowadana apo hina tuhagaya po hina neiyai hoi yayata po lawa hina galeya. ");
INSERT INTO tbo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Taumi iyawoi waitanigami yaka ona launonola. ");
INSERT INTO tbo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","‘Iyawoi o lautanigana ipa ona gagalena imahi. Babana awai o dewadewaya apo Yaubada bimiyei ina dewaya po ina luwitani. ");
INSERT INTO tbo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Matababana iyai uyahina awai dewadewana e memae apo Yaubada ina luwitani tauna uyahina. Ma iyai uyahina eega, awai habuluna e memae apo Yaubada ina wihaleya.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu i baha i pa, ‘Yaubada anani taniwaga naka mei pehi lawa a tano uyahina i ugohi, ");
INSERT INTO tbo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ma uguwei lawana i eno po malatomtomgei i towotowolo po pehihi hai laha po hai lata a baba ega ita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hipuli tauna tu wilata lugu ma ugo hai dewadewa tu welehi, ");
INSERT INTO tbo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ma a houga magula uyahina apo ugonana hina lohi.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu i baha meme i pa, ‘Yaubada anani taniwaga galenana awai? Ma apo awai uyahina a paliluweluweya? ");
INSERT INTO tbo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Galenana mei ihagila polana habuluna, ");
INSERT INTO tbo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ma apo lawa e ugohi po e lahaya po e lata ma lagalagana baneihi e hounihi ma kiu hai pata he wogowogohi.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu a guguya uyahina paliluwaluwa hi maga duma ma uyahihiyei Yaubada a baha i bahebaheya lawa uyahihi ma awai lawa emoemotahi po hina hanapugeya naka tauna Yesu i luwaluwageya. ");
INSERT INTO tbo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A luguguya lawa uyahihi houga magomagouna ompaliluwaluwagei i iatatiyana ma a hewahewali uyahihi i palipaligeletehi paliluwaluwahi anohi. ");
INSERT INTO tbo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ibigei a hewahewali i paliwelehi i pa, ‘Ta gelu po ta woe damana u tupona.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hi gelu ma bolu hoi gadowa hi nehalehi po hi yamkuka ma wam gehouhi gasi hi wotagohi. ");
INSERT INTO tbo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hi’mkuka po hi damadamana ma togowa a guletutuna hi wiyaloni po guletutu i hulugeleteya wam u hinena ma apo hita yoli. ");
INSERT INTO tbo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Yesu wam u mulina i eneno ma a hewahewali hi limaamahi po hi pa, ‘Bada, ega uta genogeta, kikina ma apo ta hilage.’ ");
INSERT INTO tbo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu i welutowolo po togowa ma boga anai guligulina i paliyehi i pa, ‘Amaka ma ona todi,’ po ega yaka togowa i todi ma noka hougana dumola baneina. ");
INSERT INTO tbo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma a hewahewali i paliwelehi i pa, ‘Awai binei o matomatouta? Yohola ega Yaubada ota witumaganeya?’ ");
INSERT INTO tbo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A hewahewali hi matouta duma, ma tunawahi hi lulubayadena mehi hi pa, ‘Geka lawana awai? Togowa po guletutu he iponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Galili bogana u tuponei dobu gowana Gelasene apoma uyahina hi lugeleta. ");
INSERT INTO tbo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu wamgei i huhopu po badebade gehouna alugo apapoehi hi luiluiya kokowagagei i nei po mitehi hi witutuhaga. ");
INSERT INTO tbo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Lawana i memae kokowaga domohi uyahihi. Ma lawa hi letaya ipa gulawa pawapawasigei aena po nimana hina panipanihi ma ega emoemotahi matababana i lautuinihi ma i lowo po u pitapita i memae ma ega emoemotana po hina womomohi. ");
INSERT INTO tbo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma iyeta po uguwa hoi kokowaga po hoi oya i ototu nae ma hinina gaima kamkamna uyahinei i hapihapihi. ");
INSERT INTO tbo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ma lawana i galena nae po Yesu i galeya ma i bulili po u matana i tupeu ma i polou. ");
INSERT INTO tbo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ega yaka lawana i otu labatana i pa, ‘Yesu, Yaubada Gegewahagana Natuna tam. Awai uyahiu una dewaya? Ipa Yaubada gowanei una paligubau ega una ihiniwiyuwau.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Geka bahana i bahebaheya babana Yesu amaka i baha nae uyahina i pa, ‘Alugo palopaloumam, lawana una hopu haleya!’ ");
INSERT INTO tbo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma Yesu i lubayadeya, i pa, ‘Gowam iyai?’ Ma i pa, ‘Gowau Bolu, babana boluiyai to memae.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I lupali higihigili i pa, ‘Ega tupo geka uyahinei una iyagiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma polo boluhi oya u hadana hi banibani, Yesu u liyaliyana. ");
INSERT INTO tbo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Alugohi hi lupali gonugonuwa hi pa, ‘Una himiliyai po polo uyahihi to lui.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ega yaka Yesu i palihalehi po alugo apapoehi lawana hi hopu haleya po polohi hi luinihi. Polo magouhi mei tausana luwaga naka pitenana ma atapuhihi oyana yapanei hi haha hopu po bogana uyahina hi halele. ");
INSERT INTO tbo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma polo tu galena itetehi hi lowo po hi nae dobu baneina po pitapita tu miyehi uyahihi hi wibenabenama awai hi gelegeleta. Apoma lawa hi hopu po hi nae ipa awai i waawala hina galeya. ");
INSERT INTO tbo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lawa Yesu uyahina hi geleta. Ma lawana alugo apapoehi boluhi hi nenehaleya hi tuhagaya Yesu aena u labena i tugutugula. Tauna i lukaleko po nugonugona a dumadumaluna ma hi gagaleya po hi matouta. ");
INSERT INTO tbo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lawahi Yesu a bagibagi hi galeya po hi wituwega hi pa, ‘Alugo apapoehi lawa hi hopu haleya po hi lui polo uyahihi, po hi yoliyoligehi.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yaka hi lupali gonugonuwa Yesu uyahina ipa tupo noka ina nehaleya. ");
INSERT INTO tbo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hougana Yesu ipa hoi wam ina gelu ma lawana alugo apapoehi hi hopuhopu haleya i baha gonugonuwa Yesu uyahina ipa mitehi hina nae. ");
INSERT INTO tbo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu a baha i wimiheya i pa, ‘Eega, ma tamogi una nae om meyagai uyahina po om guguni una paliwelehi Guyau i lunugotootogogem po i hagum.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yaka lawana i nae a tupo uyahina dobuna gowana Dekapoli, po i wituwega po lawa hi nonoli ma hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu a hewahewali mitehi hi damana meme hai u tupo po bolu hi’mboina meme gadowa uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Apoma numa dalabu taniwagana gowana Yailo i nei Yesu uyahina po u aena i polou, ");
INSERT INTO tbo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma i lupali gonugonuwa i pa, ‘Natuwe wawinena kikina ma apo ina hilage. Ma a luhogalem ipa una nei po una wodadani po ina luyagohana ma ina memae.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ega yaka hi nenae a numa uyahina ma bolu baneina hi wotagohi po hi tataliyana mehi. ");
INSERT INTO tbo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma noka boluna u hinena wawine gehouna tootogona. Tauna a totogo naka tala i kolokololo bolima magouhi 12. ");
INSERT INTO tbo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wawine geka tu ulaula gehouhi uyahihi a gapola i halehi po ipa luyagohana ina tuhagaya po ega ma tamogi a totogona i lalata. ");
INSERT INTO tbo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tauna Yesu tuwegana i nonoli yaka i wimulitagoya po a kaleko i wodadani. ");
INSERT INTO tbo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Babana wawinena a nugotuhu i pa, ‘Apo Yesu a kaleko a wodadani yaka a luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yaka wawinena Yesu a kaleko i wodadani po mala emosi ma talana a kololo i wohouna ma mayana i wimeya amaka i dewadewa. ");
INSERT INTO tbo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu mayana i wimeya naka manini i hopuhopu yaka i luhagawileya po i lubayada, i pa, ‘Iyai u kaleko i wodadani?’ ");
INSERT INTO tbo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ega yaka a hewahewali hi paliweleya hi pa, ‘Heki, bolu una galeya, he tataliyana mehi. Awai binei e laubayada upa iyai i wodadanim?’ ");
INSERT INTO tbo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma ega yaka Yesu tauna i itotolana lawa u hayahi ipa ina galeya iyai i wodadani. ");
INSERT INTO tbo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma wawinena i hanapugeya tauna i dewaya yaka i matouta po i taatawa ma i nei Yesu u matana po i polou po i wibenabenama i pa, ‘Tau a wodadanim.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu wawinena i paliweleya i pa, ‘Natuwe, om witumagana i wiluyagohanim; a nugodumolam una nae, om wiyuwa i kokoe.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu yohola geka bahana i bahebaheya ma Yailo a numagei lawa gehouna i nei po Yailona uyahina i baha i pa, ‘Natum amaka i hilage ma ata bada ega una laigeno gawahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu noya i nonoli ma Yailo i paliweleya i pa, ‘Ega una matomatouta tamogi una witumagana.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ega yaka Yesu lawa atapuhi i talagagalihi po ega hita wotagohi ma Pita ma Yamesa walehina Yoni tunawahi i weluwinihi po mitehi hi nae Yailo a numa uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hougana hi gelegeleta meyagai uyahina ponapona hi nonoli naka lawa hi tutou po hi lauhiyawa. ");
INSERT INTO tbo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ega yaka Yesu i lui numa u hinena po tu tou i paliwelehi i pa, ‘Awai binei o tutou ma o lauhiyawa? Tewela geka ega ita hilage ma e eneno.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Geka bahana uyahina ma lawa atapuhi hi winameya. Ma Yesu i baha po lawa atapuhi hi huhopu numa hinenei po hi nae hoi uputa. Ma tewelana hinana ma amana ma gasi a hewahewali tonuga mitehi hi lui po hi nae tewelana anu ani eno. ");
INSERT INTO tbo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu tewelana u nimana i wogo ma ponahiyei i baha i pa, ‘Talida kum,’ ponatiyei a bui i pa, ‘Kenuna una towolo.’ ");
INSERT INTO tbo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma tewelana i wotowolo po i nae, babana a bolima magouhi 12. Amana po hinana ma a hewahewali hi galeya ma hi nugogohola duma. ");
INSERT INTO tbo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu i lugagayogehi i pa, ‘Ega lawa gehouhi ona palipaliwelehi u bagibagi geka binei, ma tewela a yam ona weleya po ina am.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu a hewahewali mitehi hi gunawilehi a meyagai duma uyahina, ");
INSERT INTO tbo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","po Yesu hoi dalabu i wiwawala po i wiatatiyana hoi numa tapalolo. Ma lawa magomagouhi hi nonoli po nugonugohi hi goholihi hi pa, ‘Meka hotanana a hanapu i tuhagaya? Iyai i wiatatiyeya, po manini e dewadewaya? ");
INSERT INTO tbo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Geka Maliya natuna, tauna kamda, walewalehina Yamesa, Yosa, Yuda ma Simona po nounouna mitehi ta memae.’ Uyahinei Yesu hi luhinidoodoleya. ");
INSERT INTO tbo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ega yaka i paliwelehi i pa, ‘Tu bahapiko u tupo geha lawa hi wiyateyateya ma a meyagai po a guguni po a manago ega hita wiyateyateya.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Yesu i nugogohola duma babana a lawa ega hita witumagana uyahina po ega emoemotana a wipoya atapuna ina haleya, yaka lawa ega hita maga ma i wodadanihi po hi luyagohana. Ega yaka Yesu i wiwila meyagai gehouhi uyahihi po i wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Apoma Yesu a hewahewali magouhi 12 i otugehi po hi nei uyahina ma i paliwelehi ipa luwaga luwaga hina nenae. Ma wipoya i welehi ipa alugo apapoehi lawa uyahihi hina iyagahi. ");
INSERT INTO tbo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hai ututu i lawihi i pa, ‘Ega awai ona wiwaya omi kadau binei. Ega aniani po ega poha po ega mone, ma omi digona yawa ona waya. ");
INSERT INTO tbo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Omi ae humahumagei ae yapayapami ona humahi ma ega luilui wiluwagana ona wiwaya. ");
INSERT INTO tbo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Apo ona nenae meyagai gehouna uyahina ona gelegeleta ma numa taniwagana ina otugemi a numa uyahina ona lui, yaka naka numana ega ona nenehaleya, ma uyahina ona memae po a sigana meyageina ona nehaleya. ");
INSERT INTO tbo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma inapa meyagai gehouna uyahina lawa ega hina kaohemi po omi guguya hina wihinigigiyeya yaka meyageina ona nehaleya. Ma ona nenae hougana aemi dubudubuna ona lihooholi po ani galena u matahi ona dewaya po hai dewa apapoehi hina hanapugehi.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesu a hewahewali i himilihi po hi nae meyagai uyahihi po hi guguya ma lawa hai apapoe uyahihiyei hina nugobui. ");
INSERT INTO tbo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gasi alugo apapoehi lawa uyahihi hi wiyagahi ma bunama uyahinei tu tootogo hi bunamihi po hi luyagohana. ");
INSERT INTO tbo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu a wipoya tuwegana hi nohaya tupo atapuna uyahina po Heloda wasawasa i nonoli. Ma lawa gehouhi hi pa, ‘Nugote Yoni tu bapatiso hilage uyahinei i towolo meme po manini geka e dewadewahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma lawa gehouhi hi pa, ‘Tu bahapiko odubona Elaisiya i gunawilena meya.’ Ma lawa gehouhi hi pa, ‘Ega Elaisiya ma nugote tu bahapiko odubona gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma Heloda wasawasa Yesu a wipoya noyana i nonoli po i pa, ‘Baha dumana Yoni tu wibapatiso gadouna a boliboli tauna hilagei i towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Babana tauna Yonina lolowa Heloda i baha po hi numa panipani po hoi numa panipani hi houni. A lui babana wawine gowana Helodiyasi naka Pilipo agona ma tamogi Heloda i’mhalohalo po walehina agona i lawagi. ");
INSERT INTO tbo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Uyahinei Yoni i gagaleya po ega ita dumalu yaka i baha nae Heloda uyahina i pa, ‘Ega ita dumalu babana walehim agona u lawagi.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Naka binei ma Helodiyasi i luuyogigai Yoni uyahina po ipa Yoni in’uni. Ma ega emoemotana, ");
INSERT INTO tbo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","babana Heloda Yoni i matuteya po i galena teteya babana i hanapugeya naka Yoni tu dumalu po tu wiwoiyawa. Houga magomagouna Heloda Yoni a guguya i nonoli ma i launugoluwaluwaga tamogi ipa hilaki Yoni ponana ita noonoli. ");
INSERT INTO tbo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heloda a houga guni iyetana ma agona a gaogao i tuhagaya ipa Yoni ina hilage. Tolehana hi dewaya po toumana hi otugehi am binei. Toumanahi gabemani tanitaniwagahi po gawiya tu tahaehi po Galili tupona tanitaniwagahi. ");
INSERT INTO tbo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hougana Heloda a toumana mitehi hi’mam ma mahiyana wawinena i lui po u matahi i halahala ipa i laikaohahi. Tewelana a hala hi gagaleya po hi kaoha duma yaka Heloda mahiyana i otugeya po i baha uyahina i pa, ‘Ani’mbenena apo a welem? Awai om luhogala?’ ");
INSERT INTO tbo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma wasawasa i baha i pa, ‘Moina dumana a baha gwala uyahim om luhogala awai apo a welem. Inapa ani taniwaga una luhogaleya emoemotana apo tupo gehouna bimgei a palihaleya.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma ega yaka guguhinina i nae po hinana uyahina i baha i pa, ‘Apo awai u luhogala Heloda uyahina a baheya?’ Ega yaka hinana i pa, ‘Una nae po una baha una pa, “A luhogaleya ipa Yoni tu wibapatiso unununa una weleu.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ega yaka tewelana i bulili po i gunawileya wasawasa a toumana mitehi uyahihi po i pa, ‘A luhogaleya geka hougana Yoni tu wibapatiso unununa hoi gaeba una houni ma una weleu.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Geka bahana wasawasa i noonoli po nugonugona i wiyuwa duma, ma tamogi a bahagwala tu witoumanena amaka hi nonoli yaka ega emoemotana ina nugoneya. ");
INSERT INTO tbo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mala emosi ma numa panipani tu galena itetena i paliweleya i pa, ‘Una nae po Yoni gadouna una boli.’ Yaka tu galena itete naka pitenana i dewaya po Yoni gadouna i boli, ");
INSERT INTO tbo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","po hoi gaeba i houni ma i niyeya po guguhinina i weleya, ma guguhinina i waya po i niyeya hinana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yoni a hewahewali noyana hi nonoli yaka hi nei po hai popoya hi niyeya po hoi wikokowaga hi houni. ");
INSERT INTO tbo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu a tu wituwetuwega hi gunawilehi po hai bagibagi po hai wiatatiyana atapuna hi wibenabenama. ");
INSERT INTO tbo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma ega hai gaogao ipa hina am babana lawa hai geleta po hai hopu ega hita wohouna. Ega yaka Yesu a hewahewali i paliwelehi i pa, ‘Tupo geka ta nehaleya po ta nae hoi balabala po kikina ta wiyagohina.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ega yaka wam tunawahi hi geluya po hi nae hoi balabala. ");
INSERT INTO tbo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma hi gelugelu bolu hi galehi. Yaka lawa tahayagei hi ibulibulili ma hi nenae. Ma hai wibulibulili binei meyagai emosi po emosi lawahi mitehi hi negogona po dobuna uyahina hi geleta tahaya. ");
INSERT INTO tbo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu wam uyahinei i huhopu po bolu baneina i gagalehi po i galena lunugotootogogehi babana galenahi mei sipi ega hai tu galena itete ega yaka i wiwawala po lawa uyahihi i wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma Yesu a wiatatiyana i lidaoya bolu uyahihi, ma a hewahewali hi galeya naka amaka ibiga i geleta, ega yaka Yesu hi paliweleya hi pa, ‘Geka hoi balabala yabayababa ma kabudala e yoliyoli. ");
INSERT INTO tbo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lawa una himilihi po hina nae hoi tano po hoi meyagai po hai am hina gimala.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu i paliwelehi i pa, ‘Taumi aniani ona welehi po hina am.’ Ma a hewahewali a baha hi wimiheya hi pa, ‘Guyau, ega emoemotiyai. Nugote apo to nae po hai am to gimala, yaka mone baneina to haleya mei kina handele luwaga apo uyahinei ta wianihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu i baha i pa, ‘Palawa wabihaga uyahim? Ona nae lawa uyahihi po palawa ona lupali.’ Yaka a hewahewali hi bibeiha po palawa magouhia numitutu ma iyana luwaga hi tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ega yaka Yesu i baha po hiyamoni waiidaidagana uyahina hi duhuna. ");
INSERT INTO tbo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ega yaka hi duhuna bolu po bolu uyahinei mei 50 po 100. ");
INSERT INTO tbo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu palawa nimitutu ma iyana luwaga i wihini po i galena gae hoi yada ma Yaubada uyahina i wimaamala. Ma palawa i tomutomuya po a hewahewali i welehi po hi gutaya bolu uyahihi. Mei gasi iyana luwaga i tomutomuya po i welehi. ");
INSERT INTO tbo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma lawa hi’mam po atapuhi hi’mhiyougo ");
INSERT INTO tbo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","po ega yaka a hewahewali palawa ma iyana omtelenana hi tuwaluta meya po hi lauemoteya poha magouhi 12 hi lihogohi. ");
INSERT INTO tbo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yesu ololoto i ianihi magouhi tausana nimitutu. ");
INSERT INTO tbo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Naka hougana Yesu a hewahewali i paliwelehi i pa, ‘Wam ona geluya po ona tahatahaya Besaida ma tau lawa a himilihi po hina nae hai u dobu.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma Yesu bolu i himilihi po hi nenae ma tauna i gae u oya ipa ina lupali. ");
INSERT INTO tbo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yesu tunawana oya u tepana ma upom i geleta po a hewahewali boga u tipolina hi woewoe. ");
INSERT INTO tbo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu a hewahewali i gagalehi ma hi ileta babana togowa i tupamatamatanihi po ega emoemotahi hina woe yagiyagina po hina damana hoi dobu. Kikina ipa malinatom, ma Yesu i nei po boga tepanei i nenae po i nei a hewahewali u liyaliyahi ipa ina weluwilehi. ");
INSERT INTO tbo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yesu hi gagaleya ma boga tepanei i nenei uyahihi ma hi iototu hai nugotuhu hi pa lawa hilahilagena alugona hita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Babana a hewahewali atapuhi hi gagaleya po hi matouta duma. Mala emosi ma Yesu i baha nae uyahihi i pa, ‘Awai matoutana, ona nugomotu, tau.’ ");
INSERT INTO tbo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma Yesu hoi wam i gelu geleta ma togowa i wohouna ma a hewahewali hi gohola dumahi, ");
INSERT INTO tbo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","babana bolu Yesu i anihi ega hita nugotuhu tuhagaya matababana nugonugohi matahi hi keke. ");
INSERT INTO tbo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hi damana po Genesaleta u tuponana hi gota po hai wam hi hepaya. ");
INSERT INTO tbo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma hi huhopu wam uyahinei po hi gegae ma lawa Yesu hi galeya. ");
INSERT INTO tbo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yaka lawa hi wibulibulili nae meyagai atapuhi uyahihi po tu tootogo ani enogei hi awalihi po hi nehi mai Yesu uyahina ma apo noyana hina nonoli meka u tuponana e nenae gasi lawa hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu a wiwila tupo atapuna uyahina dobu po meyagai po tano uyahihi, ma lawa hai tu tootogo hi niyehi po hai ani gimala dobuhi uyahihi hi otonaneya po hi laupali gonugonuwa ipa tu tootogo Yesu a kaleko hina wogo dadani. Ma tauhi hi wodadani yaka hi luyagohana meme. ");
INSERT INTO tbo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Houga gehouna Palisi lawahi po lugagayo tanitaniwagahi Yelusalemgei hi nei po Yesu u liyaliyana hi towotowolo ma hi ihalugeya. ");
INSERT INTO tbo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesu a hewahewali hi galena tuhagahi ega nimahi hita oga tahaehi ma apoma hit’omam. Ma hi baha hi pa, ‘Yesu a hewahewali hi gobu.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hai baha babana Palisi lawahi po mi Yudeya atapuhi hai tapalolo dewana naka yeuyeu po nimahi he oga imahi apoma apo he’mam. ");
INSERT INTO tbo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma gasi apo ani gimala uyahinei he nenei naka he togo tahaya apoma he’mam. Ma lugagayo atapuna googahi uyahihiyei i nenei hi wotagohi gaeba po keyaka po nau hi ogogahi. ");
INSERT INTO tbo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ega yaka Palisi lawahi po lugagayo tanitaniwagahi Yesu hi lubayadeya hi pa, ‘Awai binei om hewahewali googata hai lugagayo ega hita wiyateyatehi, ma a nima gobugobuhi he’mam?’ ");
INSERT INTO tbo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu hai baha i wimiheya i pa, ‘Baha dumana taumi tu wikoyakoyama dumami, naka binei ma Yaubada a baha tu bahapiko Isaiya i gilumi i pa, “Geka lawahi gamohi yawa e bahabaha wiyateyateu ma nugonugohi hi mebala dao uyahiugei. ");
INSERT INTO tbo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Uyahiu he tapatapalolo yababa, babana hai wiatatiyana ega tau uyahiugei ma tauhi hai winugonugotuhugei.” ");
INSERT INTO tbo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Omi dewa hi apapoe babana Yaubada a lugagayo o houna gowadihi ma lawa hai lugagayo o wotagohi. ");
INSERT INTO tbo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","‘O hanapu duma po omi dewa uyahinei Yaubada a lugagayo o wihinigigiyehi, ma lawa hai lugagayo o iponawogogehi. ");
INSERT INTO tbo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Geka Yaubada a lugagayo Mose i weleweleya i baha i pa, “Amam ma hinam una wiyateyatehi. Apo lawa awai hinana ma amana ina kawaiapapoehi yaka hina lihilageni.” ");
INSERT INTO tbo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Naka lugagayona o wihinigigiyeya ma taumi omi lugagayogei o baheya o pa, apo lawa awai hinana ma amana ina palihalehi po ina pa, “U gapola atapuna amaka a palihaleya Yaubada uyahina po ega emoemotau a hagumi.” ");
INSERT INTO tbo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yaka lawana o paliguduguduya po uyahinei amana po hinana apega ina haguhi. ");
INSERT INTO tbo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Geka omi wiatatiyana apapoehi googami uyahihiyei o laudamanehi, po Yaubada a baha o laiwayaunihi ma gasi ginouli gehouhi uyahinei Yaubada a lugagayo o tulagonihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu lawa i otugehi po hi liya mai uyahina ma i paliwelehi, i pa, ‘Ona lutanigana imahi u wiatatiyana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yaniyani emosi po emosi gamomiyei o anani ega emoemotana po ina wiapapoenimi, ma awai gamomiyei e gelegeletai naka tauna e iapapoenimi. ");
INSERT INTO tbo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Taumi iyawoi waitanigami yaka ona launonola.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma Yesu bolu i nehalehi po i lui numa u hinena, ma a hewahewali hi lubayadeya hi pa, ‘Emoemotana baha wiluwaluwa geka uta liyayahi uyahiyai?’ ");
INSERT INTO tbo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ega yaka Yesu i paliwelehi i pa, ‘O winugoneina hota? Ona lutanigana, lawa aniani hi ani po koibahi u hinena i luilui ega ita iapapoenihi ");
INSERT INTO tbo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","matababana ega ita hopu u nugonugohi, ma i lui u amamohi houga kukuna ma apo ina hopu meme hoi nudanuda.’ (Geka uyahinei Yesu i paliweleta po i pa aniani atapuhi ta ananihi.) ");
INSERT INTO tbo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","‘Ma awai gamomiyei e gelegeleta naka tauna e iapapoenimi. ");
INSERT INTO tbo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nugotuhu apapoehi lawa nugonugohiyei e gelegeletai naka: matamaga, danene, omunugo, wihola, ");
INSERT INTO tbo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","omboho, nugogobu, koyama, wotutawine, omgenagenalili, wiyalutu, nugogegae, tanigapota, ");
INSERT INTO tbo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","geka dewahi lawa nugonugohi he iapapoenihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Apoma Yesu i nae tupo gehouna Taya meyageina u liyaliyana po i lui numa uyahina, babana ega nugonugona po ipa lawa hina hanapugeya a geleta binei ma tamogi lawa hi tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ma wawine gehouna a geleta noyana i nonoli po i nei. Wawinena ega Yudeyagei ma tauna a dobu Ponisiya tupo Siliya uyahina ma a nei matababana natuna wawinena alugo apapoena i luiya po nugonugona ipa Yesu ina galeya po ina wiyagaya. I nei po Yesu aena u babana i polou po i lupali Yesu uyahina i pa, ‘Alugo apapoena una wiyagaya natuwe uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu wawinena a lupali i wimiheya, i pa, ‘Lawa mi Yudeya a hagu tahaehi apoma tupo gehouhi. Ega emoemotana po logaloga hai yam kedewa a welehi.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wawinena Yesu a paliluwaluwa i wimeheya, i pa, ‘Guyau, naka baha dumana ma kedewa logaloga hai yam hamomouna he lemolemoya.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ega yaka Yesu i baha i pa, ‘Tinani, om baha binei, un’omhoe po una nae om numa uyahina alugo apapoena natum amaka i hopu haleya po i dewadewa.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma wawinena i wotowolo po i nae a numa uyahina, hougana i geleta anu numa po i luilui ma natuna hoi ani eno ma alugo apapoena amaka i hopu haleya. ");
INSERT INTO tbo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu Taya i nehaleya po i nae Saidoni po i nehaleya po i nae Dekapoli tuponana uyahina naka Galili bogana tupona. ");
INSERT INTO tbo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hougana Yesu i geleta u Galili lawa waigumgumna hi neiyai Yesu uyahina po hi lupali hi pa, ‘Yesu, lawa geka una wodadani.’ ");
INSERT INTO tbo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu lawana mitehi bolu hi nehalehi po hi nae uheiya. Ma Yesu nima gigina luwaga lawana u tanigana i houna luiyehi po i kokoe. Ma nimana i luhowaya ma lawana menana i wodadani. ");
INSERT INTO tbo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma Yesu anai nugowiyuwana i galena watata hoi yada ma i yautu halena ma i paliweleya i pa, ‘Epapata,’ ponata, ‘Ona gunahoenimi!’ ");
INSERT INTO tbo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yaka mala emosi ma lawana tanigana hi gunahoenihi ma menana i teyateya po emoemotana ina baha dumalu. ");
INSERT INTO tbo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu bolu i paliwelehi i pa, ‘Ega tuwegana ona bahebaheya lawa uyahihi.’ Ma lawa ega hita geno, Yesu tuwegana hi dedeya lawa atapuhi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma lawa hi nonoli ma hi goholihi, ega yaka hi pa, ‘Yesu a bagibagi hi dewadewa duma. Emoemotana taniga pupu ina baha po hina nonola ma menahi witewiteihi apo ina lidumaluhi po hina baha.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ega houga ita dao ma bolu baneina gehouna hi nei Yesu uyahina ma ega hai am. Ega yaka Yesu a hewahewali i otugehi po i paliwelehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‘Lawa geka a lunugotootogogena dumahi, babana iyeta tonuga mitehi ta memae ma ega hai yam. ");
INSERT INTO tbo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma inapa anai omhilagehi a himilihi apo hoi tahaya kamnahi hina apapoe, babana gehouhi bala daodaohiyei hi nei.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma a hewahewali hi pa, ‘Guyau, u hanapugeya tauta geka hoi balabala ta memae ma apo meka aniani ta tuhagaya po lawa ta wianihi?’ ");
INSERT INTO tbo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ega yaka Yesu i lubayadehi i pa, ‘Omi palawa wabihaga he memae?’ Hi pa, ‘Palawa magouhi 7 he memae.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","I baha po lawa hoi hipuli hi tugula. Ma palawahi i winihi po Yaubada uyahina i wimaamala. Ma i’mtomutomu po a hewahewali i welehi po hi gutaya lawa uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yesu iyana muhomuhohi ega ita maga ma i winihi po i wimamala Yaubada uyahina ma a hewahewali i welehi po hi guta wiwila lawa uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lawa hi’mam po hi’mhiyougo ma yaniyani tupotupona hi tutuwaluhi naka poha magouhi 7 hi lihogohi. ");
INSERT INTO tbo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma ololoto magouhi mei tausana wohepali i himili. ");
INSERT INTO tbo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma Yesu a hewahewali mitehi wam hi geluya po hi damana Damanuta u tuponana. ");
INSERT INTO tbo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Palisi lawahi hi nei Yesu uyahina po hi ludadani hi pa, ‘Nugonugoiyai wekiwekilala gehouna una wiatatiyeiyai po to hanapugem tam Yaubada uyahinei u nei.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu i yautu halena ma i pa, ‘Awai binei geka hapanana manini wekiwekilalana o bibiheya? A baha duma uyahimi, apega wekiwekilala gehouna a wogeleteya uyahimi.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ega yaka, i nehalehi po wamgei i damana u tupona. ");
INSERT INTO tbo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A hewahewali hai palawa ega hita waya babana nugohi i guluwi ma hai palawa emosi hota hoi wam. ");
INSERT INTO tbo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu i baha i pa, ‘Ona galena imahi Palisi po Heloda lawahi hai palawa ani lihaahanana naka nugohine gowagowada.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yesu a hewahewali tunawahi ma hi ibaabani hi pa, ‘Geka a nugotuhuna binei ma ata palawa nugota i guluwi po ega tata waya.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu hai wibaabani i hanapugeya yaka i baha uyahihi i pa, ‘Awai binei o ibaabani palawa, bo? Ega palawa binei ata bahabaha, ma nugote nugonugomi hi kapala yaka u baha anohi ega ota nugotuhu tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","“Waimatami ma ega ota ihalu, waitanigami ma ega ota launonola.” ");
INSERT INTO tbo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nugomi i guluwi? Hougana tausana nimitutu a ianihi palawa nimitutu uyahinei ma o laugogona meya poha wabihaga?’ Hi pa, ‘Poha magouhi 12.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma i baha meme i pa, ‘Hougana tausana wohepali a ianihi palawa magouhi 7 uyahihiyei, naka o tutuwaluhi poha wabihaga o lihogohi?’ A hewahewali hi pa, ‘Poha magouhi 7.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ega yaka i baha i pa, ‘Iyowai nugonugomi yohola ega hita lugiigilihi?’ ");
INSERT INTO tbo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu a hewahewali mitehi hi damana po hi gota Besaida u meyageina, ma lawa matana keekena hi neiyai Yesu uyahina po hi lupali hi pa, ina wodadani. ");
INSERT INTO tbo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ega yaka Yesu matakeke lawana u nimana i wogo ma meyagai hi nehaleya po hi nae uheiya, ma Yesu lawana matana luwaga i howahi ma nimana i hounihi u matana po i wihalehi ma i baha i pa, ‘Ginouli awai e gagalehi?’ ");
INSERT INTO tbo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma tu matakeke i pa, ‘Lawa a gagalehi ma amaka mei mayau hina nenae.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ega yaka Yesu nimana i houna mehi u matana po nimana i wihalehi ma lawana i lumatabohoboho ma matana hi lugigilihi po ginouli atapuhi i galena imahiyehi. ");
INSERT INTO tbo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ega yaka Yesu i paliweleya i pa, ‘Ega una nenae bolu uyahihi, ma una dumalu po una nae om numa uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu a hewahewali mitehi tupo Sisaliya Pilipai tahayanei hi nenae ma i lubayadehi i pa, ‘Lawa hai winugonugotuhu hi pa tau iyai?’ ");
INSERT INTO tbo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A hewahewali hi pa, ‘Lawa hi pa tam Yoni bapatiso, ma gehouhi hi pa tam Elaisiya lawa odubona, ma gehouhi hi pa tam tu bahapiko odubona gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Apoma a hewahewali uyahihi i baha nae i pa, ‘Ma taumi, omi nugotuhu o pa tau iyai?’ Ma Pita a baha i wimiheya i pa, ‘Tam, Yaubada a Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu i paliwelehi i pa, ‘Ega iyai gehouna ona palipaliweleya.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu tauna i bahena meya i pa, ‘Apo Lawa Moinau wiyuwa galenahi magomagouhi a wialonihi. Apo mi Yudeya hai tanitaniwaga po tu witalaguyaba babadahi po lugagayo tanitaniwagahi hina wihinigigiyeu. Ma apo hina uniu po iyeta tonuga u mulina a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu a baha dumalu binei Pita i weluwaya po hi tunae uheiya ma i’mpaligudugudu uyahina ");
INSERT INTO tbo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu i luhagawileya po a hewahewali i galehi ma Pita i paliyeya i pa, ‘Tomodulele, una nehaleu om winugonugotuhu mei lawa hota hai winugonugotuhu, ma ega mei Yaubada a nugotuhu.’ ");
INSERT INTO tbo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu bolu po a hewahewali i paliwelehi i pa, ‘Inapa lawa awai nugonugona ina wotagou yaka a luyagohana ina palihaleya. Ma anani take ina awali ma ina wotagou. ");
INSERT INTO tbo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Apo iyawoi ega biugei hina hilage yaka apo yautuhi hina halehi. Ma iyawoi tau biugei ma tuwega dewadewana binei hina hilage apega yautuhi hina halehi. ");
INSERT INTO tbo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inapa iyai ina wigapola duma yaka Yaubada a dewa apo ina winugoguluwi, naka apo awai dewadewana ina tuhagaya? ");
INSERT INTO tbo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma lawa a luyagohana naka ginouli baneina. ");
INSERT INTO tbo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Apo lawa awai tau ma u baha ubeihi ina ihinimaya geka hapana u matahi babana tu apapoe apo hina paliguyoguyougeya yaka tau Lawa Moinau u houga nei uyahina apo tauna a wihinimaeya. Naka hougana uyahina tau ma Amau po a tu winoyanoya waiwoiyawahi hai wasawasa namanamalinei a nei.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu bolu i paliwelehi i pa, ‘A baha duma uyahimi, gehoumi geka hosi o towotowolo apega ona hilage a sigana Yaubada a taniwaga waipoyana ina geleta po ona galeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iyeta magouhi 6 hi kokoe ma Pita ma Yamesa ma Yoni tunawahi Yesu i weluwinihi po hi gae oya baneina u tepana. Hai mae uyahina ma Yesu galenana i buiya u matahi, ");
INSERT INTO tbo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","po a luilui galenana i wakeke lagona duma po i namanamali ega mei iyai hoi hipuli kaleko ina deoya po wakekena. ");
INSERT INTO tbo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma babada odubohi hi lugeletehi po Yesu mitehi hi ibaabani. Babadahi naka Mose ma Elaisiya. ");
INSERT INTO tbo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma Pita i baha Yesu uyahina i pa, ‘Guyau, i haki duma po tauyai geka hosi. Apo kape tonuga to wogohi, emosi tam bimgei ma emosi Mose binei ma emosi Elaisiya binei.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita a matouta binei ma i baha yababa. ");
INSERT INTO tbo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma gahu i lutatahi ma gahuna u hinena pona hi noonoli i pa, ‘Natuwe geka, a luhogaleya; tauna ona wiponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mala emosi ma a hewahewali hi hagahagawila po ega lawa gehouna hita galeya ma Yesu tunawana i towotowolo. ");
INSERT INTO tbo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Oyagei hi hopuhopu mai ma Yesu a hewahewali i paliwelehi i pa, ‘Ega lawa uyahihi ona bahebaheu, awai o gagalehi, a sigana tau Lawa Moinau hilage uyahinei apo a towolo meme. ");
INSERT INTO tbo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yesu a baha hi wiponawogogeya po ega hita wiyahoneya ma tamogi hi nugonugotuhu hi pa, ‘Hilage uyahinei towolo memena anona awai?’ ");
INSERT INTO tbo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma Yesu uyahina hi lubayada hi pa, ‘Awai binei lugagayo tanitaniwagahi hi baheya hi pa, apo Elaisiya ina tahaya mai ma u mulina apo Besinana lawana ina nei?’ ");
INSERT INTO tbo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu i baha nae uyahihi i pa, ‘Naka moina dumana, Elaisiya ipa ina tahaya mai po ginouli atapuhi ina lidumaluhi. Ma awai binei ma Yaubada a Buka uyahina hi gilugilumi hi pa, Lawa Moinau apo wiyuwa a tuhagahi po paliguyaguyau. ");
INSERT INTO tbo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma tamogi Elaisiyana amaka i nei, ma hi wihinigigiyeya, mei Yaubada a Buka uyahina hi bahebaheya.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu a hewahewali tonuga mitehi oyagei hi hopu mai po a hewahewali gehouhi hi tuhagahi ma lugagaya tanitaniwagahi mitehi he laugamobagibagi ma bolu baneina hi’mboina. ");
INSERT INTO tbo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hougana bolu Yesu hi galeya ma hi goholihi ega yaka hi bulili po hi witutuhaga ma hi mamali. ");
INSERT INTO tbo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma i lubayadehi i pa, ‘Awai binei o laugamobagibagi?’ ");
INSERT INTO tbo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bolu u hayahi lawa gehouna Yesu i paliweleya i pa, ‘Bada, natuwe alugo apapoena i luiya ma a neneiyai uyahim po tam ega geka hota. Natuwe geka ega emoemotana po ina baha ");
INSERT INTO tbo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ma houga gehouhi alugo apapoena e luiya ma e guli hoi hipuli po pulopulo gamonei he gelegeleta ma niwona e yamhanakidiyana ma e yamtatamomota. Ma om hewahewali uyahihi a baha ipa alugo apapoena hina wiyagaya ma ega emoemotahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu i baha i pa, ‘Taumi hapa geka ega omi witumagana. Houga a dao awai apo a meme liyanimi po a genogenogemi? Tewelana ona neiyai uyahiu.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Apoma tewelana hi neiyai Yesu uyahina ma alugona Yesu i galeya ma i wimatauguuguwa po i peu hoi hipuli po i taatawa ma gamonei pulopulo hi gelegeleta. ");
INSERT INTO tbo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu tewelana a totogo i galeya ma i lubayada amana uyahina i pa, ‘Iyowai a totogo a dao?’ Tewela amana Yesu a baha i wimiheya i pa, ");
INSERT INTO tbo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","‘A habuluna ma i nei po geka hougana, ma alugo apapoena e ileta ipa ina lihilageni ma e haleya mayau ebebalana uyahina po gasi goila u hinena. Yaka emoemotam una lunugotootogogeiyai po una haguiyai.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu a baha i wimiheya i pa, ‘Awai binei u baha u pa, “Emoemotam”? Ginouli atapuhi witumaganagei emoemotahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mala emosi tewela amana i baha gonugonuwa i pa, ‘A witumaganem, ma u witumagana ega ita lata yaka una haguwe.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu bolu i gagalehi ma hi bulibulili mai u liyaliyana yaka alugo apapoena i paliyeya i pa, ‘Alugo gumgum geka hougana una hopu haleya ega una luilui meya!’ ");
INSERT INTO tbo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ega yaka alugo i otu labatana ma tewelana i wimatauguuguwa po i guli hoi hipuli, ma alugo apapoena i hopu haleya, ma bolu tewelana hi galeya ma hi pa, ‘Amaka i hilage!’ ");
INSERT INTO tbo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma ega yaka Yesu tewela u nimana i wogo po i woitowoli po mitehi hi towotowolo. ");
INSERT INTO tbo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu a hewahewali mitehi lawa hi nehalehi po hi nae numa u hinena po tunawahi ma hi lubayadeya hi pa, ‘Iyowai po ega emoemotiyai alugo apapoena to wiyagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ega yaka Yesu hai baha i wimiheya i pa, ‘Lupaligei emoemotana alugo apapoehi lawa u hinehi hina lupa hopu, ma ega awai gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dobu naka hi nehaleya po hi damana Galili u tupona. Yesu ega nugonugona ipa lawa hai ani nae hina hanapugeya, ");
INSERT INTO tbo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","babana ipa a hewahewali ina wiatatiyehi. Ma i baha nae uyahihi i pa, ‘Lawa Moinau apo hina houna damaneu lawa u nimahi po hina lihilageniu ma apo iyeta witonugana uyahina hilagei apo a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A baha uyahihi ega hita nugotuhu tuhagaya ma hi nugolowo yaka ega hita lubayada meme uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hi geleta Kapaneum po hi lui hoi numa po Yesu a hewahewali i lubayadehi i pa, ‘Awai hoi tahaya o yampaliwilewileya?’ ");
INSERT INTO tbo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Atapuhi hi genuwana, matababana hoi tahaya tunawahi ma hi wigamogahigahi wibadabada binei po hi wihinimaya. ");
INSERT INTO tbo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu i tugula ma magouhi 12 i otugehi, po i baha uyahihi i pa, ‘Apo iyai nugonugona po ina tahaya, tauna ina nugohopuhopu ma ina witubagibagi a lawa ubeihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ega yaka tewela gehouna i waya po u naohi i witowoli ma i talahagauya ma i baha uyahihi ipa, ");
INSERT INTO tbo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‘Iyai gowaugei geka tewelana ina likaohaya yaka tau i likaohau. Ma iyai ina likaohau yaka ega tau tunawau ma tu himiliu i likaohaya.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoni i baha Yesu uyahina i pa, ‘Bada, lawa gehouna gowamgei ma alugo apapoehi i iyagahi ma to baha po ipa ina wohouna, matababana tauna ega ata bolu u hinena.’ ");
INSERT INTO tbo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu i baha i pa, ‘Ega ona yamgudugudu apo iyai manini ina dewadewahi gowaugei naka tauna ega ita palipalidibogiu, ");
INSERT INTO tbo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","babana iyai ega ita igawiyeta naka tulata. ");
INSERT INTO tbo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A baha duma uyahimi, apo iyai goila ina welemi babana taumi Keliso a bolu, yaka a meiha apo ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Apo tu witumaganeu lawana a winugonugotuhu mei geka tewelana, ma lawa awai ina lipeuya, yaka a dumalu itapa gaima baneina u gadouna hita duli ma u boga dumdum hita halena hopuneya. Ma ega ita dumalu ipa geka tu tapitapiyana ina dewaya po apapoe ina dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Apo nimam ina laipeunim yaka una boli haleya. Naka ega apapoe awai babana nimam emosi yaka luyagohana apo una tuhagaya. Tamogi woapapoe dumana naka nimam luwaga a dewadewahi ma apo hina halena hopunem mayau ebebalana ega sigasigana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma apo aem ina laipeunim yaka una boli haleya. Naka ega apapoe awai, babana apo aem emosi yaka luyagohana una tuhagaya. Tamogi woapapoe dumana naka aem luwaga a dewadewahi ma apo hina halena hopunem mayau ebebalana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Apo gasi matam ina laipeunim yaka una wahi haleya. Naka ega apapoe awai babana matam emosi yaka Yaubada anani taniwaga una luiya. Tamogi woapapoe dumana naka matam luwaga a dewadewahi ma apo hina halena hopunem mayau ebebalana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tupo noka uyahina, “Motamota hai ani mae ma mayau ebalana ega ita bohoboho.” ");
INSERT INTO tbo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Gasi atapumi mayau ebebalana apo ina widewadewami, mei niha aniani e idewadewaya. ");
INSERT INTO tbo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","‘Niha ginouli dewadewana ma dagihana ina kokoe ega emoemotana po ina dagiha meme. Niha naka omi dewa. Dewa dewadewana ona wibagibagi po omi lawa mitehi ona nugoemota.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu a hewahewali mitehi Galili hi nehaleya po hi nae Yudeya u tupona po Yodani goilana hi damani po lawa hi galeya yaka bolu hi’mboina nae ma a dewa tauna bolu uyahihi i iatatiyana. ");
INSERT INTO tbo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma Palisi lawahi hi nei Yesu uyahina ipa hina ludadani hi pa, ‘Iyowai apo lawa agona ina nehaya naka apapoe?’ ");
INSERT INTO tbo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu i lubayadehi i pa, ‘Iyowai Mose a lugagayo uyahimi?’ ");
INSERT INTO tbo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Palisi lawahi hi pa, ‘Mose lugagayo i pa, apo lawa agona ina hahaleya yaka giluma gehouna ina gilumi po wawinena ina weleya ma apoma ina wihulu.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ega yaka Yesu i paliwelehi i pa, ‘Mose lugagayona i welewelemi matababana omi nugokapala tepanei. ");
INSERT INTO tbo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Houga a wawala uyahina Yaubada lawa luwaga i wiwawalihi oloto ma wawine. ");
INSERT INTO tbo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Oloto amana ma hinana ina nehalehi po agona ina waya po mitehi hina megogona. ");
INSERT INTO tbo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yaka hai luwaga hina wihiniemosi ma ega hini luwaga. ");
INSERT INTO tbo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Oloto ma wawine hai tawine Yaubada i popo emotehi, ega lawa hina lupelupena halehi.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu bolu uyahihi a wiatatiyana i luwegahi ma hi gunawilehi hai numa uyahina, ma a hewahewali Yesu hi lubayadeya a baha wihulu binei. ");
INSERT INTO tbo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ega yaka Yesu i paliwelehi i pa, ‘Oloto awai agona ina haleya ma wawine gehouna ina lawagi naka e matamatamaga. ");
INSERT INTO tbo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma wawine awai agona ina haleya ma oloto gehouna ina lawagi naka e matamatamaga.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ma lawa gehouhi logaloga hi nehi mai Yesu uyahina ipa ina wotepanihi ma a hewahewali hi paliyehi. ");
INSERT INTO tbo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma Yesu i gagalehi po nugonugona i apapoe hai baha binei yaka i baha i pa, ‘Logaloga ona palihalehi po hina nenei uyahiu ma ega ona guduguduhi. Matababana lawa mei geka logalogahi apo Yaubada anani taniwaga hina luiya. ");
INSERT INTO tbo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A baha duma uyahimi, apo iyai Yaubada anani taniwaga ina luiya ipa nugonugona ina dewaya po mei logaloga hai winugonugotuhu.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesu logaloga i gunihi po u nimana ma i kawaidewedewehi. ");
INSERT INTO tbo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu i wotowolo po tahayagei i nenae ma tu wigapola lawana i bulili mai po i tutunei i’mtutonetonena u matana ma i lubayada i pa, ‘Bada dewadewam, apo awai a dewaya po luyagohana tuwetuwenai Yaubada ina weleu?’ ");
INSERT INTO tbo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Yesu i paliweleya i pa, ‘Om winugonugotuhu awai binei u kawaidewadewageu? Ega iyai ita dewadewa ma Yaubada tunawana. ");
INSERT INTO tbo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lugagayo u hanapugehi hi pa, “Ega una yamunugo, ega una matamatamaga, ega una danedanene, ega una igou koyakoyama, ega koyamagei una laugapola, amam ma hinam una wiyateyatehi.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma lawana i baha i pa, ‘Bada, geka lugagayohi a habuluwe a wootagohi ma i nei po amalai.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu lawana i galena lunugotootogogeya ma i pa, ‘Ginouli emosi hota ega uyahim. Om gapola magomagouhi una gimalena halehi po monehi tu dayadayabu una welehi, ma una nei po una wotagou. Yaka apo hoi yada una wigapola.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hewalina Yesu a baha i noonoli po anai nugodubuna i gunawilena meya, babana a gapola hi maga duma. ");
INSERT INTO tbo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu i luhagawileya po a hewahewali uyahihi i pa, ‘Tu wigapola lawahi hai lui Yaubada anani taniwaga uyahina i witai.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A baha geka uyahina ma a hewahewali hi goholihi yaka Yesu i pa, ‘U logaloga Yaubada anani taniwaga luina i witai duma. ");
INSERT INTO tbo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela ega emoemotana heyau domona ina honogi. Ma tu wigapola lawana a lui Yaubada anani taniwaga uyahina i wipilipili lagona apoma noka kamela a honoga.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu a baha uyahina ma a hewahewali hi nugogohola duma po hi lubayada hi pa, ‘Heki, iyai apo luyagohana ina tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu i galehi po i kokoe ma i baha uyahihi i pa, ‘Lawa uyahihi luyagohana tuhagana ega emoemotahi ma Yaubada uyahina ginouli atapuhi emoemotana.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ega yaka Pita i baha nae i pa, ‘Una galeya i gapola atapuhi to nehalehi po to wootagom.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma Yesu i baha uyahihi i pa, ‘A baha duma uyahimi, apo iyai a meyagai bo walewalehina bo nounouna bo hinana po amana bo natunatuna bo a tano tau biugei po gasi tuwega dewadewana binei ina nehalehi, ");
INSERT INTO tbo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tauna geka hougana ginouli magomagouhi ina tuhagahi Yaubada uyahinei, a numa ma walewalehina ma nounouna ma hinahinana ma natunatuna ma a tano apo ina tuhagahi ma lawa apo hina widibogi ma tamogi houga he nenei luyagohana ega sigana apo ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma amalai gehouhi he tahatahaya apo hina wimuli. Ma amalai gehouhi he imuli apo hina tahaya.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Noka hougana hi nenae u Yelusalem po Yesu i tahaya ma a hewahewali hi nugohele ma tu wotagona gehouhi hi matouta duma hi gegae Yelusalem binei. Hoi tahaya ma a hewahewali i paliwelehi apo awai hina gelegeleta uyahina binei i pa, ");
INSERT INTO tbo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","‘Tauta ta nenae u Yelusalem apo Lawa Moinau hina palihaleu, tu witalaguyaba babadahi ma lugagayo tanitaniwagahi u nimahi apo u hilage binei hina taniwaga. Ma hina palihaleu tu meuputa hai tu wigawiya u nimahi po ");
INSERT INTO tbo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","apo hina paliguyoguyougeu ma hina howahowau po hina kodikodiliu po ina kokoe ma apo hina lihilageniu. Ma iyeta tonuga hina kokoe apo a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yamesa ma Yoni, Sebedi natunatuna, hi nei Yesu uyahina po hi baha hi pa, ‘Bada, to nei uyahim po to lubayadem.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu i pa, ‘Awai nugonugomi?’ ");
INSERT INTO tbo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hi baha uyahina hi pa, ‘Apo om wasawasa una tutuhagaya hougana, ma emoemotana apo tata tugula gogona gehouna u awala hinebawam ma gehouna u keham.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ega yaka Yesu i baha nae uyahihi i pa, ‘Omi lupali anona ega ota hanapugeya. Emoemotami apo wiyuwa ani umana a umumaya taumi gasi on’umaya? Emoemotami apo hilage bapatisona a wiwaya taumi ona waya?’ ");
INSERT INTO tbo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma hi pa, ‘Emoemotiyai.’ Ega yaka Yesu i paliwelehi i pa, ‘Naka moina, apo wiyuwana a umumaya taumi on’umaya po hilage a tutuhagaya apo taumi ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma tamogi ega emoemotau po a taniwaga po ona tugula u awala hinebawau bo u awala kehau. Yaubada tauna e woononogo iyawoi apo hina tugula.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma a hewahewali magouhi 10, Yamesa ma Yoni hai lubayada hi noonoli po hi luuyogigai. ");
INSERT INTO tbo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu i boinihi po i baha nae uyahihi i pa, ‘O hanapugeya tanitaniwaga hipuligei lawa uyahihi hi taniwaga kadidili duma, po tauhi mei tu wasawasa. ");
INSERT INTO tbo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma taumi ega ipa naka pitenana ona dewadewaya. Apo u hayami tam iyai ipa una witaniwaga, yaka una witubagibagi om lawa ubeihi. ");
INSERT INTO tbo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Apo gasi iyai u hayami ipa ina tahaemi, yaka tauna a lawa ubeihi ina witupupoula. ");
INSERT INTO tbo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mei gasi tau Lawa Moinau a nenei hoi hipuli ega ipa lawa biugei hina bagibagi, ma tau ipa a witubagibagi lawa ubeihi, po yautuwe a palihaleya lawa magomagouhi ubeihi ipa a lupenihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu a hewahewali mitehi hi geleta Yeliko po ipa hina nehaleya ma lawa matana keekena gowana Batimeyo babana Timeyo natuna tahaya u liyaliyana i tugutugula, ma gapola i lulupali. ");
INSERT INTO tbo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma tuwega i nonoli ipa Yesu lawa Nasaletagei, yaka i otu i pa, ‘Yesu, Dawita gogana, hilaki uta lunugotootogogeu!’ ");
INSERT INTO tbo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma lawa magomagouhi hi paliyeya hi pa, ‘Hei, una genuwana!’ Tamogi i otu labatana i pa, ‘Tam Dawita gogana, una lunugotootogogeu!’ ");
INSERT INTO tbo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu i tutowolo ma i baha i pa, ‘On’otugeya.’ Ega yaka tu matakeke hi otugeya hi pa, ‘Una kaoha! Una towolo, Yesu e ototugem.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mala emosi ma a lupulu i halehi ma i wotowolo po i nae Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu i lubayadeya i pa, ‘Om luhogala awai uyahim a dewaya?’ Tu matakeke i pa, ‘Guyau, u luhogala ipa matau hina dewadewa.’ ");
INSERT INTO tbo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma Yesu uyahina i baha i pa, ‘Una nae. Om witumagana i luyawahim.’ Mala emosi ma matana i galeneya ma Yesu hoi tahaya i wotagoya po hi nae. ");
INSERT INTO tbo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hi nae Yelusalema u liyaliyana po hi geleta u Betepage po u Betani naka oya Oliweta uyahina. Yesu a hewahewali luwaga i himila tahaehi i pa, ");
INSERT INTO tbo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","‘Meyagai u naomi ona nae po ona luiluiya naka hota doniki wouna yohola ega hita geluya ma e memae, apo ona tuhagaya. Ona lupeni po ona neiyai geka hosi. ");
INSERT INTO tbo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma inapa iyai ina lubayademi ina pa, “Awai binei o lupelupeni?” yaka ona pa, “Guyau ipa ina wibagibagi ma apo ina gunawileya.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hai luwaga hi nae po hi geleta meyagai uyahina. Ma hi galeya doniki anai lutamina i memae numa u matetana. Ega yaka doniki lutamina hi lupelupeni. ");
INSERT INTO tbo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ma lawa hi pa, ‘Hei, awai binei doniki naka o lupelupeni?’ ");
INSERT INTO tbo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ega yaka hi pa, ‘Guyau i pa houga kuku hotana ina wibagibagi ma apo ina himila meya,’ po ega yaka hi palihaleya. ");
INSERT INTO tbo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Apoma donikina hi niyeya Yesu uyahina, po hai kalekogei donikina upuna hi lutouli ma Yesu i gelu. ");
INSERT INTO tbo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma lawa magomagouhi hai kalekogei tahayana hi lutouli ma lawa gehouhi mayau luguluguhi hi bolihi po a tahaya hi lutouli. ");
INSERT INTO tbo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma lawa u naonei po mulinei hi nenae ma hi ototu po hi wotalagae hi pa, ‘To wotalagiyem!’ ‘Guyau gowanei e nenei Yaubada ina kawaidewedewem!’ ");
INSERT INTO tbo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","‘Gogata Dawita anani taniwagagei e nenei Yaubada ina kawaidewedewem!’ ‘Ani’mhuna duma tam Gegewahagam uyahim!’ ");
INSERT INTO tbo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hougana Yesu i geleta Yelusalem po i lui numa dalabu baneina uyahina po ginouli atapuhi i galehi numa dalabu u hinena. Ma amaka aibiga yaka a hewahewali magouhi 12 mitehi hi gunawilehi u Betani po noka hotanana hi eno. ");
INSERT INTO tbo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Malatomtomgei Yesu a hewahewali mitehi Betanigei hi gunagunawilehi, po hoi tahaya Yesu am i hilage. ");
INSERT INTO tbo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma i gagalena nae po mayau mei mabewa i galeya yaka i nae u liyaliyana ipa apo ugona ina tami. Ma mayouna ega ugona ma lugu yawa babana ega hai houga ugo. ");
INSERT INTO tbo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ega yaka Yesu mayau i paliyeya i pa, ‘Apega ugomgei lawa hina am a sigana.’ Ma a hewahewali hi nonoli mayau uyahina i bahabaha nae. ");
INSERT INTO tbo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hougana hi geleta Yelusalem po Yesu numa dalabu baneina i luiya ma i wiwawala po tu gimagimala i wiyagahi ma gasi mone tu wiyawepeli hai pata i lugoluhi ma bunebune tu gimalahalenahi hai ani tugula i lubuiya. ");
INSERT INTO tbo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma i taniwaga po ipa ega iyai hai gapola numa dalabu u hinena ina awawala. ");
INSERT INTO tbo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ega yaka Yesu lawa i guguyahi i pa, ‘Yaubada a Buka gilugiluma uyahina i baheya i pa, “U numa tupo wohepali hai ani lupali binei.” Ma taumi o buiya po tu danedanene hai ani megowada.’ ");
INSERT INTO tbo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ma tu witalaguyaba babadahi po lugagayo tanitaniwagahi a baha hi nonoli po hi luuyogigai ma hi pa, mata awai uyahinei ma apo hina lihilageni. Ma lawa atapuhi Yesu a guguya nugohi i waya po tanitaniwaga lawa hi matutehi po ega Yesu hita womomohi. ");
INSERT INTO tbo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma amaka aibiga yaka Yesu a hewahewali mitehi Yelusalem hi nehaleya po hi nae Betani u tuponana. ");
INSERT INTO tbo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yesu a hewahewali mitehi malatomtom kikina hi wotowolo po hi nenae Yelusalem po hoi tahaya ma Yesu mayau i palipaligubaya hi gagaleya atapuna amaka i kokodila. ");
INSERT INTO tbo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ega yaka Pita Yesu a wogalahi i nugotuhuya yaka i baha i pa, ‘Guyau, mayau una galeya u palipaliyeya po amaka i kokodila.’ ");
INSERT INTO tbo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu a hewahewali hai wibaabani i nonoli yaka i baha uyahihi i pa, ‘A baha duma uyahimi, ");
INSERT INTO tbo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","apo iyai oya geka uyahina ina baha po ina gunawotowi po u boga ina yoli, apega anai nugoluwaluwagana ma inapa anai witumaganana yaka apo ina wiponawogogeya. ");
INSERT INTO tbo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A baha uyahimi, anai witumaganami ona laupali po omi luhogala awai Yaubada uyahina ona paligeletehi yaka apo ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ma omi lupali hougahi uyahihi lawa hai apapoe uyahimi ona nugotuhuya yaka ona paligigilihi. Uyahinei Amami hoi yada apo omi apapoe ina paligigilihi. ");
INSERT INTO tbo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Inapa lawa hai apapoe uyahimi ega ona paligigilihi yaka Amami hoi yada omi apapoe apega ina paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu a hewahewali mitehi hi geleta Yelusalem po i lui numa dalabu u hinena i lautowolo nae ma mi Yudeya hai tanitaniwaga po tu witalaguyaba babadahi po lugagayo tanitaniwagahi hi nei uyahina, po Yesu hi lubayadeya hi pa, ");
INSERT INTO tbo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","‘Witaniwaga awai u waya po geka ginoulihi e dewadewahi, bo iyai geka witaniwagana i welem?’ ");
INSERT INTO tbo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu hai baha i wimiheya i pa, ‘Hapali tau gasi u lubayada a welemi, po ona wimiheya yaka apo omi lubayada a wimiheya, po iyai geka witaniwagana i weleu. ");
INSERT INTO tbo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoni a witaniwaga yadei i nei bo lawa uyahihiyei i nei po i ibapatiso? Ona paliweleu.’ ");
INSERT INTO tbo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma tunawahi u hayahi hi ibaabani hi pa, ‘Apo awai ta baheya? Apo tana pa, “Yadei,” apo ina pa, “Awai binei ega ota witumaganeya?” ");
INSERT INTO tbo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma apo tana pa, “Lawa uyahihiyei,” yaka apo bolu hina luyogigai uyahita.’ (Babana lawa hai winugonugotuhu naka Yoni tu bahapiko gehouna.) ");
INSERT INTO tbo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ega yaka a baha hi wimiheya hi pa, ‘Ega tota hanapugeya miyei i nei.’ Ma Yesu uyahihi i baha i pa, ‘Tau gasi apega a paliwelemi witaniwaga awai a waya po geka ginoulihi a dewadewahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Apoma Yesu i wiwawala po paliluwaluwahi lawa i paliwelehi i pa, ‘Lawa gehouna gologolowa ugona uyahina wine he dewadewaya i lupehiyeya. Ma gali i dewaya po i wiwila, ma wine pihagana i dewaya, ma tanona u hinena ani luwiyau numana i wogoya, ma tu galena itete hai ututu i lawi ma i nehalehi po i nae bala daodaona. ");
INSERT INTO tbo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Omlohina hougana uyahina badana a hewali i himili po i nae tano tu galena itete uyahihi ipa ugona tupona hina weleya. ");
INSERT INTO tbo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tamogi tano tu galena itete badana a hewali hi wilawi ma a nima kwakwawina hi himili po i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ega yaka badana a hewali wiluwagana i himili po i nae uyahihi po unununa hi hedali po anai wihinimayana i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma gehouna i himili po hi lihilageni ma atapuhi naka dewana uyahinei hi dewahi gehouhi hi wilawihi ma gehouhi hi lihilagenihi. ");
INSERT INTO tbo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘A hewahewali atapuhi i himilihi po hi kokoe. Ma tauna natu hotana i lauhogaleya tunawana i tupo. Ega yaka i himili tano tu galena itete uyahihi i pa, “Geka natuwe yaka apo hina wiyateyateya.” ");
INSERT INTO tbo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‘Tamogi hougana tano tu galena itete natunana hi galeya yaka tunawahi hi ibaabani hi pa, “Tanona muliyei tu witaniwagena geegeka. Tan’uni po geka tanona ipa ina nenae uyahina naka apo ina wigalitiyei.” ");
INSERT INTO tbo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ega yaka hi womomohi, po hi lihilageni po hi halena hopuneya tanona uputana.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu i lubayada i pa, ‘Tanona taniwagana apo tano tu galena itete iyowai ina dewahi? Apo ina nei po ina unihi ma tano tu galena itete gehouhi u nimahi tanona ina houni. ");
INSERT INTO tbo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nugote Yaubada a Buka hi gilugilumi, yohola ega ota nugotuhu tuhagaya i pa, “Ogolana tauna tu lunuma hi ihinigigiyeya amalai i gunabuiya po i dewadewa lagona. ");
INSERT INTO tbo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Naka Guyau a bagibagi uyahita ani nugogohola u matata.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu a paliluwaluwa hi noonoli po uyahinei tanitaniwaga hi pa tauhi ubeihi ita’mpaliluwaluwa ma ipa hina numa panipani ma tamogi bolu hi matutehi. Ega yaka hi nehaleya po hi nae. ");
INSERT INTO tbo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ega yaka Palisi lawahi po Heloda hai bolu hi nei Yesu uyahina po ipa hina lubayadeya po a baha powa hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ma hi liya nae Yesu uyahina po hi pa, ‘Bada, to hanapugem tam lawa dumadumalum ma lawa kadikadidilihi ega uta genogenogehi. Ma Yaubada a tahaya dumadumaluna e bahebaheya lawa atapuhi u matahi. Ma iyowai, mi Loma hai taniwaga ta wotagoya po takisi ta huhouni, bo ega? ");
INSERT INTO tbo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sisa ta weleweleya bo ega?’ Ma Yesu amaka hai lubayada koyakoyama i hanapuya yaka i pa, ‘Awai binei o laudadaniu? Ipa lubayada geka uyahinei ma ona paniu. Ma heki, naka monena ona weleu po a galeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ega yaka mone hi weleya po i lubayadehi i pa, ‘Iyai tepana galenana po gowana geka monena uyahina?’ Hi baha uyahina hi pa, ‘Sisa galenana.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ega yaka Yesu uyahihi i baha i pa, ‘Heki, ginouli awai Sisa galinei Sisa ona weleya. Ma ginouli awai Yaubada galinei Yaubada ona weleya.’ Yesu a baha hi nonoli po hi nugogohola duma. ");
INSERT INTO tbo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi hai bolu lawahi hilage towolo memena ega hita itumaganeya. Tauhi hi nei Yesu uyahina, ");
INSERT INTO tbo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","po hi lubayadeya hi pa, ‘Bada, Mose geka lugagayona ubeiyai i gilumi i pa, “Oloto awai ina tawine po ega ina winatuna ma ina hilage, apo walehina hiwapena ina lawagi po hina winatuna yaka naka popoyana galinei.” ");
INSERT INTO tbo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lawa gehouna natunatuna ololotohi magouhi 7. Tutuwoga i tawine po ega natuna ma i hilage. ");
INSERT INTO tbo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ma ega yaka tu hulatuna hiwapena i lawagi po ega gasi natuna ma i hilage. Ma witonugahi hai hiwapena i lawagi po gasi ega natuna ma i hilage. ");
INSERT INTO tbo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Atapuhina magouhi 7 ega hita winatuna. Ma wawinena tunawana i memae po i hilage. ");
INSERT INTO tbo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Uyahinei ma hoi towolo meme wawinena apo agona iyai? Matababana magouhi 7 i lawaga pahihi.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ega yaka Yesu i baha nae uyahihi i pa, ‘Taumi naka o koyakoyamena memi babana Yaubada a Buka gilugilumana ega ota hanapugeya, ma gasi a wipoya ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ma houga towolo meme uyahina apo tauhi tu hilage hina towolo apega hina tawitawine po apega hina itawinehi, tamogi hai mae yada uyahina tauhi ani galenahi mei tu winoyanoya mi yadena. ");
INSERT INTO tbo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ega Mose a buka ota hiyawa tuhagaya. Mayau towotowolona i alalahi hougana Mose i limoineya naka lawa hoi hilage he towotowolo meme. Noka hougana Yaubada i baha nae uyahina i pa, “Abelaham a Yaubada tau, po Isako a Yaubada tau, po Yakobo a Yaubada tau.” ");
INSERT INTO tbo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tauna ega lawa hilahilagehi hai Yaubada ma lawa lauyagohanahi hai Yaubada. Yaka taumi omi baha ega hita dumalu.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lugagayo taniwagana gehouna lubayadahi anohi i nonolihi po Yesu a baha hi dumalu duma. Ega yaka lawana i nae Yesu uyahina po i lubayada i pa, ‘Yaubada a lugagayo awai i geduma?’ ");
INSERT INTO tbo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ega yaka Yesu i pa, ‘Geka lugagayo baneina: taumi mi Isalaela ona lutanigana imahi, Yaubada tunawana ata Guyau. ");
INSERT INTO tbo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Guyau om Yaubada luhogalam atapunei po alugom atapunei po nugonugom atapunei po omi kadidili atapunei una luhogaleya. ");
INSERT INTO tbo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma geka lugagayo wiluwagana: lawa u liyaliyam tu mae una luhogalehi po mei e lauhogalena mem.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lugagayo taniwagana Yesu a baha i nonoli po i baha i pa, ‘Bada, om baha atapuna nonolana uyahiyai i dewadewa duma po gasi hi dumalu duma matababana Yaubada tunawana ata Guyau ma ega Guyau gehouna ita memae. ");
INSERT INTO tbo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nugote gamogamo po ani’mbenena atapuhi ta italaguyabehi Yaubada uyahina naka ginouli habuluhi, ma ginouli baneihi naka Yaubada nugonugota atapunei ta luhogaleya po ata hanapu atapunei ta luhogaleya. Ata kadidili atapunei ta luhogaleya ma ata lawa ta luhogalehi po mei ta lauhogalena meta.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu lawana a baha hanahanapu i nonoli yaka i pa, ‘Tam Yaubada anani taniwaga uyahinei ega uta mebala dao.’ Ma lawa hi lowogeya po ega hita lubayabayadena gawahi. ");
INSERT INTO tbo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hougana Yesu i iatatiyana numa dalabu u hinena po lubayada gehouna i welehi i pa, ‘Iyowai ma lugagayo tanitaniwagahi hi pa Besinana lawana naka apo Dawita gogana? ");
INSERT INTO tbo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma Alugo Woiyawa nugotuhu Dawita i weleya po Besinana lawana i kawaiguyougeya i pa, “Yaubada i baha u Guyau uyahina i pa, ‘U awala hinebawau una memae a sigana om gawiya a houna hopunehi po aem ani luhanatanahi.’” ");
INSERT INTO tbo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Noka hougana Dawita Besinana lawana i kawaguyougeya. Uyahinei Dawita ega Besinana lawana gogana dumana.’ Bolu Yesu a baha hi nonoli po hi kaoha duma. ");
INSERT INTO tbo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma a wiatatiyana uyahinei i paliwelehi i pa, ‘Lugagayo tanitaniwagahi ona gagalena imahiyehi. Tauhi hai luhogala ipa luilui daodaohi hina otenihi ma hina nenae, ma ani gimala dobuna uyahina lawa wiyateyategei hina maamalihi. ");
INSERT INTO tbo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tauhi hai luhogala hoi numa dalabu ani tugula dewadewahi po hoi toleha hai ani tugula gegehi. ");
INSERT INTO tbo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ma koyamagei hiwahiwape hai numa gapolahi he danedanenehi ma lupali daodaohigei galena koyakoyama he dewadewaya. Tauhi hai wimeiha apo ina lata duma.’ ");
INSERT INTO tbo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu i nei hoi numa dalabu mone ani hounana u liyaliyana i duhuduhuna, ma lawa hi yambenena ma Yesu tu wigapola hai ombenena baneihi hi huhouna ma i gagalehi. ");
INSERT INTO tbo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma gasi i gagalena ma hiwape wodayadayabuna mone luwaga habuluhi mei toea emosi i hounihi. ");
INSERT INTO tbo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Yesu a hewahewali i boinihi ma i paliwelehi i pa, ‘A baha duma uyahimi geka hiwapena wodayadayabuna i houna lagona ma apoma atapuhina. Matababana atapuhina hai omteletelenagei hi houna ma tauna a widayadayabu u hinena ma mone atapuna i tutuhagaya i houna pahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu a hewahewali mitehi numa dalabu baneina uyahinei hi hopu mai po a hewali gehouna Yesu uyahina i pa, ‘Bada, numa geka galenahi hi dewadewa duma, gaima baneihi uyahihiyei hi dewahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ega yaka Yesu a baha i wimiheya i pa, ‘Geka numahi gaima uyahihiyei hi dewahi po o gagalehi, houga e nenei apega gaima gehouna u uyawena ina memae. Atapuna apo hina dubadubalena pahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu i gae oya Oliweta u tepana po i tugula, ma i gagalena damana Yelusalem numa dalabu baneina uyahina. Pita ma Yamesa ma Yoni ma Andulu tunawahi hi nei Yesu u liyaliyana, ");
INSERT INTO tbo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","po hi pa, ‘Una paliweliyai om baha anona meyanai apo ina geletai? Ma wekiwekilala awai una baheya po to galeya yaka apo to hanapugeya ginoulihi u bahebahehi apo kikina ma hina geleta?’ ");
INSERT INTO tbo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ega yaka Yesu uyahihi i pa, ‘Ona gagalena imahi po ega iyai ina inepowami. ");
INSERT INTO tbo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Matababana lawa hi maga apo hina towolo po gowaugei hina koyama hina pa, “Tau Yaubada a Besinana lawana,” ma lawa magomagouhi hina koyamehi po hina wotagohi. ");
INSERT INTO tbo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hougana gawiya po witona tuwegahi ona noonolihi ega ona matomatouta babana geka dewahi apo hina wawala tahaya. Tamogi houga sigasigana yohola. ");
INSERT INTO tbo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tupo geha ma tupo geha apo hina wigawiya po ani taniwaga geha ma ani taniwaga geha apo hina wigawiya. Ma apo guhuguhu tupo gehouhi uyahihi hina geleta ma gomala baneihi. Geka ginoulihi naka houga witai anani wawala dumana. ");
INSERT INTO tbo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Ma lawa ona galena imahiyehi, babana tauhi apo hina niyemi po hina libahibahimi hai omboina uyahihi ma hai numa dalabu uyahihi apo hina wilawimi. Ma gowau binei apo hina niyemi taniwaga baneihi po wasawasa uyahihi. Ma naka omi gaogao ipa tuwega dewadewana ona nohaya. ");
INSERT INTO tbo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma tuwega dewadewana ona noha tahaeya hipuli atapuna uyahihi ma apoma muliyei houga apapoe ina geleta. ");
INSERT INTO tbo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hougana apo hina panimi po hina niyemi libahibahi binei ega ona genogeno ipa apo awai ona baheya uyahihi. Yaubada tauna apo omi baha ina woogeleteya u nugonugomi naka hougana uyahina baha awai o bahebaheya ega tunawami, ma Alugo Woiyawa apo ina wiatatiyemi omi wibaabani uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","‘Houga naka uyahihi apo lawa walehina ina wihinigigiyeya po tanitaniwaga ina weleya po hina lihilageni mei amamahi naka pitenana apo natunatuhi hina wihinigigiyehi, apo gasi natunatuhi amamahi hina wihinigigiyehi. ");
INSERT INTO tbo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Apo gowau binei ma lawa atapuhi hina wihinigigiyemi. Ma apo iyawoi uyahimiyei hin’omtaibagibagi ma hina towolo kadidili po houga a siga uyahina, luyagohana apo hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Apo yohola wekiwekilala naka ginouli waigola dumana ona galeya tupo waiwoiyawana uyahina e towotowolo (taumi tu’mhiyawa ona wileta po baha geka anona ona hanapugena imahiyeya) ma iyawoi Yudeya u tupona ona memae yaka ona lowo gae u oya. ");
INSERT INTO tbo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Apo tam iyai om numa uputana una memae, yaka una lowo yagiyagina, ma ega una luilui hoi numa om gapola ubeihi. ");
INSERT INTO tbo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Apo tam iyai hoi tano una wobagibagi, yaka ega om luilui binei una gunagunawilem. ");
INSERT INTO tbo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma wiwine tu koikoiba po tu wigugu houga noka uyahina tauhi tu nugodubu. ");
INSERT INTO tbo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ma ona laupali omi lowo hougana binei, po ega houga wayau uyahina ona nenae. ");
INSERT INTO tbo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Houga witai banei dumana, babana Yaubada a wiwawala uyahinei ma i nei po amalai ega kikina witai mei geka pitenana, ma houga he nenei uyahihi apega witai hina geleta meme. ");
INSERT INTO tbo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iyeta witai noka itapa Guyau hougana ega ita likukuya apo lawa atapuhi hita hilage pahihi, ma Guyau hougana apo ina likukuya, babana a lawa i inaganihi ubeihi. ");
INSERT INTO tbo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Apo lawa gehouna ina paliwelemi ina pa, “Ona galeya, geka bo noka Besinana lawana,” ega ona itumaganeya, ");
INSERT INTO tbo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Matababana Besinana koyakoyama po tu bahapiko koyakoyama apo hina geleta po wekiwekilala po manini lawa u matahi hina wogeletehi, po Yaubada a bolu i inaganihi kikina apo hita koyamehi. ");
INSERT INTO tbo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Uyahinei ona galena itete memi dewa geka uyahihi babana palihanapu atapuna amaka a bahehi uyahimi. ");
INSERT INTO tbo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Houga witai u mulina, “Kabudala a kadidili apo ina tapiya ma wamahiya yayatana ina wigahugahu. ");
INSERT INTO tbo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma yada ubonahi apo hina peu hopu mai ma yada ginouli atapuhi hai kadidili apo hina tapiya.” ");
INSERT INTO tbo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Apoma apo Lawa Moinau anai wipoyau po anai wasawasau ona gagaleu ma yaloigei a nei. ");
INSERT INTO tbo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma apo u tu winoyanoya a himilihi hipuli atapuna, togowa mata wohepali i nae po yada a siga uyahihi po u lawa a inaganihi hina welugogonihi po hina nei uyahiu. ");
INSERT INTO tbo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Ani galena a paliwelemi po ona nugonugotuhuya, i galugalu hougana uyahina ta hanapugeya naka ega daona ma apo higolo ina wawala. ");
INSERT INTO tbo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yaka wekiwekilala awai a palipaliwelemi hina wawala ma ona galehi yaka ona hanapugeya u houga gunawilana ega daona ma apo ina geleta babana hoi mateta a towotowolo. ");
INSERT INTO tbo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A baha duma uyahimi, geka ginoulihi atapuhi apo hina wawala tahaya ma apoma geka hapanana lawahi hina hilage pahihi. ");
INSERT INTO tbo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yada po hipuli apo hina yababa ma tau u baha apega ina yababa. ");
INSERT INTO tbo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‘Iyeta awai bo kabudala gaogaona awai apo a gunagunawilena meu ega iyai gehouna ita hanapugeya. Tu winoyanoya hoi yada ega hita hanapugeya, tau gasi ega ata hanapugeya; Amau tunawana i hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Uyahinei ona gagalena imahi po ega on’eneno babana houga awai apo a geletai, ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Galenana mei bada gehouna ipa ina nae ina kadau, ma a tu bagibagi i otugehi po hai ututu i lawi. Ma emosi po emosi hai bagibagi i welehi, ma numa matetana tu galena itetena i paliweleya i pa, “Una gagalena imahi.” ");
INSERT INTO tbo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","‘Uyahinei ona gagalena babana ega ota hanapugeya meka hougana apo numa taniwagana ina geletai: iyeta bolinai, bo ibigei, bo uguwa bolinai, bo malinatomtom, bo malatomtomgei, ");
INSERT INTO tbo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","apo ina nei po anai enoenomi ma ina ligoholimi. ");
INSERT INTO tbo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Awai a palipaliwelemi mei naka pitenana lawa atapuhi ona paliwelehi, ipa hina gagalena imahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iyeta luwaga hi otonana, ma apo Welulagona a nugohepa tolehana uyahina hina geleta, po tolehana uyahina apo palawa ega ani lihaahanana hina dewaya. Ma tu witalaguyaba babadahi po lugagayo tanitaniwagahi hi nugowilawila hi pa apo iyowai ma Yesu hina numa panipani gowadi po hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hi ibaabani po hi pa, ‘Ega toleha u hinena Yesu ta panipani apo lawa hina wigawiyeta.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu u Betani i memae, Simona lepelo a numa uyahina hi’mam, ma wawine gehouna wedu gaimei hi dewadewaya u hinena wakatu dimudimumuna i waya po i nei, wakatuna gowana nadi ma mihana i lata duma. I neiyai po weduna i hedali po i hiwogi Yesu unubolina po i wineuli. ");
INSERT INTO tbo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma hai bolu uyahinei gehouhi hi nugoapapoe, po hi pa, ‘Wawine geka matababana awai ma wakatu geka i dewa guyougeya? ");
INSERT INTO tbo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wakatu geka emoemotana hita gimalena haleya po mihana kina handele tonuga hita waya po dayadayabu uyahihi hita welehi,’ po ega yaka wawinena hi paliyeya. ");
INSERT INTO tbo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu i baha uyahihi i pa, ‘Geka wawinena ega ona palipaliwiyalutugeya. Awai uyahiu i dewadewaya naka i haki duma. ");
INSERT INTO tbo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Taumi apo dayadayabu mitehi houga magomagouna ona memae po houga awai nugonugomi yaka apo ona haguhi; ma tau apega houga daodaona ta memae. ");
INSERT INTO tbo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wawinena awai i dewadewaya naka emoemotana babana i bunabunamiu hiniu i wononogogeya apo hoi kokowaga hina huhouniu binei. ");
INSERT INTO tbo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A baha duma uyahimi, yohola apo tuwegau hina guuguyeya lawa atapuhi uyahihi po hina noonoli ma gasi wawine geka a bagibagi uyahiu i dewadewaya apo hina deedeya ani nugomomota tauna binei.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudasa Isakaliyota Yesu a hewahewali magouhi 12 uyahihiyei i nae tu witalaguyaba babadahi uyahihi po Yesu wogana i talaya ipa ina nugohaleya. ");
INSERT INTO tbo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yudasa a baha hi nonoli ma hi kaoha labatana ma hi paliwitumaganeya hi pa, ‘Apo mone to welem,’ yaka Yudasa a gaogao i bibeiha ipa iyowai ma apo Yesu ina nugohaleya. ");
INSERT INTO tbo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Welulagona tolehana uyahina ma palawa ega ani lihaahanana ma sipi hai houga omunugohi i geleta. Yesu a hewahewali hi lubayadeya hi pa, ‘Meka tuponana u luhogaleya apo uyahina Welulagona tolehana bimgei to wononogogeya?’ ");
INSERT INTO tbo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu a hewahewali luwaga i himilihi i pa, ‘Meyagai baneina ona luiluiya hougana oloto gehouna goila talagigoilana i awawali apo ona itutuhaga, tauna ona wotagoya. ");
INSERT INTO tbo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma numa awai o luiluiya, numana taniwagana ona paliweleya ona pa, “Bada geka pite a baha uyahim i pa, Meka toumana hai babanoya naka uyahina apo u hewahewali mitehi Welulagona tolehana ton’ani?” ");
INSERT INTO tbo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma tauna apo babanoya baneina u moyana ina wiatatiyemi po uyahina ginouli atapuna ona wononogogeya ubeita.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ma a hewahewali meyagai baneina hi luiluiya po Yesu awai atapuna i bahebaheya naka pitenana ma hi tuhagaya yaka hai Welulagona tolehana hi wononogogeya. ");
INSERT INTO tbo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma amaka aibiga, yaka Yesu a hewahewali mitehi hi nae hoi numa, hi lui po hi’mam. ");
INSERT INTO tbo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma hai amna uyahina ma Yesu i pa, ‘A baha duma uyahimi, uyahimiyei apo lawa gehouna ina nugohaleu tauna mitehi to’mam.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yesu a baha geka binei ma hi nugodubu duma, ma emosi po emosi Yesu i laubayadeya i pa, ‘Iyai, nugote tau?’ ");
INSERT INTO tbo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu i baha i pa, ‘Apo magoumi 12 uyahimiyei tauna mitehi gaeba emosi uyahina to wohopu gogona tauna apo ina nugohaleu. ");
INSERT INTO tbo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Lawa Moinau apo a hilage mei Yaubada a Buka uyahina hi gilugilumi pite ma iyai tu nugohaleu naka tauna tu nugodubu, itapa lolowa ega hita guni po ita lata apo ita haki wahaga, ma apo ina winugotootogo duma a apapoe binei.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hai am uyahina ma Yesu aniani i waya po i wimaamala ma i tomutomuya po a hewahewali i welewelehi ma i ibaabani i pa, ‘Geka hiniu ona waya.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mei gasi keyaka i waya, po i wimaamala, ma i welehi po atapuhi hi uma. ");
INSERT INTO tbo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu i baha i pa, ‘Geka talau lawa atapuhi ubeihi Yaubada a wogatala binei apo ina kololo. ");
INSERT INTO tbo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A baha duma uyahimi amalai ma i wawala po i nenae apega wine a umaya a sigana Yaubada anani taniwaga uyahina wine wouna apo tan’umaya.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ega yaka hi lulougo ma hi hopu po hi gae Oliweta oyana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu i baha nae uyahihi i pa, ‘Atapumi apo ona lowo haleu, mei Yaubada a Buka i bahebaheya i pa, “Tu galena itete sipi ana ilawi ma sipi magomagouhi hina nohanoha mehi.” ");
INSERT INTO tbo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma u towolo meme u mulina apo a tahatahaya nae u Galili ma taumi muliugei ona nei.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita i baha i pa, ‘Atapuhi apo hina lowo halem ma tau apega a lowo halem.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu i baha i pa, ‘A baha duma uyahim, uguwa geka uyahina kamkam olotona a tou apega ina wiluwagaya a sigana mala tonuga una bowiyeu.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Pita i baha kadidili i pa, ‘Apeega, apo hina laihilagenim, yaka tau gasi hina lihilageniu, apega a bowiyem.’ Ma atapuhi hi baha hi pa, ‘Tauyai gasi, apega to lowo halem.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tauhi hi nei tano gehouna gowana Gesemani, po Yesu a hewahewali i paliwelehi i pa, ‘Geka hotanana ona memae ma tau tupona a tunae po a lupali.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma a hewahewali tonuga i weluwinihi naka Pita ma Yamesa ma Yoni, hai wohepali tupona hi tu nae, ma Yesu i nugohelele duma ma gasi i nugowiyuwa. ");
INSERT INTO tbo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ega yaka i paliwelehi i pa, ‘Nugonugou i wiyuwa duma nugote kikina ma apo a hilage, uyahinei geka hotanana ona memae ma ona gagalena imahi.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma Yesu i tunae tupona ma i polou hoi hipuli ma i lupali i pa, ‘Amau, emoemotam wiyuwa geka una wihaleya. ");
INSERT INTO tbo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aba, Amau, ginouli atapuna emoemotam, yaka geka wiyuwa keyakana uyahiu una wihaleya. Tau u nugotuhu hawena ma tam om nugotuhu una dewa tagoya.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu i gunawileya a hewahewali uyahihi po hi eneno ma i tuhagahi, po ega yaka Pita uyahina i baha nae i pa, ‘Simona, awai binei e eneno? Ega emoemotam kabudala gaogaona emosi una wiyaugeya? ");
INSERT INTO tbo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ona kadidili po ona laupali ipa ega ludadana ona ialoni. Alugomi i luhogala ma hinimi hi begabega.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu i gunawilena meya po a lupali i lilugo meya. ");
INSERT INTO tbo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma i gunawilena meya a hewahewali uyahihi po hi eneno meme ma i tuhagahi, babana matahi hi pota duma. ");
INSERT INTO tbo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma a gunawilana i witonugaya, ma i baha nae i pa, ‘Iyowai yohola o eneno, ma o iyagohina, bo? Ona galeya u houga amaka i geleta po tau Lawa Moinau hina nugohaleu tu apapoe u nimahi. ");
INSERT INTO tbo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ona towolo po ta nae babana tu nugohaleu amaka e nenei.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu yohola i ibaabani ma Yudasa i geleta tauna a hewali gehouna. Ma lawa hi nenei naka tu witalaguyaba babadahi po lugagayo tanitaniwagahi po mi Yudeya hai tanitaniwaga hi himilihi po Yudasa mitehi hi nei ipa Yesu hina numa panipani, a nimagawiya gapolahi kwasikwasi po anai dabalumahi hi nei Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma Yudasa wekiwekilala gehouna uyahihi i baheya i pa, ‘Apo ona gagaleu ma lawana a nae po niuna a yagoyagoni, naka tauna Yesu apo ona womomohi po ona numa panipani.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hougana hi geleta po Yudasa Yesu uyahina i nenae ma i pa, ‘U Guyau,’ ma i tala hagauya. ");
INSERT INTO tbo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma tu wigawiya hi nei po Yesu hi womomohi. ");
INSERT INTO tbo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma Yesu a bolu uyahihiyei lawa gehouna a kwasikwasi i holi po tu witalaguyaba hai taniwaga a tu bagibagi i lubuya po tanigana i talutuiya. ");
INSERT INTO tbo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu bolu i paliwelehi i pa, ‘Iyowai po a nimagawiya gapolami o nei biugei mei tau tu danene? ");
INSERT INTO tbo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma lolowa iyeta emosi hoi numa dalabu baneina uyahina a iatatiyana u hayami ma ega ota paniu, ma Yaubada a Buka odubona i bahebaheya geka amaka u houga i geleta.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ega yaka Yesu a hewahewali atapuhi hi lowo haleya. ");
INSERT INTO tbo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma hewali gehouna i lukaleko hota ma Yesu i witulani, po tu wigawiya nugonugohi ipa hina womomohi, po hi tapeilowoya. ");
INSERT INTO tbo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ma a kaleko hi teinagagi ma hipun’awa i lowo. ");
INSERT INTO tbo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma tu wigawiya Yesu hi niyeya, po hi luiyeya tu witalaguyaba hai taniwaga anu numa. Numana uyahina tu witalaguyaba babadahi po mi Yudeya hai tanitaniwaga po lugagayo tanitaniwagahi hi’mboina po ipa Yesu hina luhetaleya. ");
INSERT INTO tbo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Pita mulinei i wotago po i nae tu witalaguyaba hai taniwaga a numa u gali hinena, po mayau i ebebala i galeya. Ma numana tu galena itetena hi lalana yaka i nae uyahihi po i tugula ma ipa ina wilalana. ");
INSERT INTO tbo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ma tu witalaguyaba babadahi po tu wiwogatala atapuhi Yesu hi igouya ipa iyowai ma a baba awai hina tuhagaya po hin’uni ma ega hita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma tu wigou koyakoyamahi hai wibaabani ega hita dumalu, babana lawa luwaga ega hai baha emosi. ");
INSERT INTO tbo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ega yaka lawa gehouhi hi towolo po Yesu hi wigou koyakoyameya tanitaniwaga u matahi, hi pa, ");
INSERT INTO tbo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Yesu iyeta gehouna to nonoli ma i pa, “Numa dalabu geka lawa hi wogowogoya apo a hoe haleya ma iyeta tonuga u hinena a wogo meya, ega lawa nimahiyei.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Po lawa hai wibaabani ega galenahi emosi, yamoha po yamoha a nugotuhu. ");
INSERT INTO tbo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ega yaka tu witalaguyaba hai taniwaga i towolo u hayahi po i baha i pa, ‘Iyowai? Ega emoemotana po noka lawahi hai wigou una wimiheya?’ ");
INSERT INTO tbo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Yesu ega ponana ma i genuwana. Ega yaka tu witalaguyaba hai taniwaga i lubayada meme i pa, ‘Iyowai, tam Besinana lawana, Yaubada Natuna, bo?’ ");
INSERT INTO tbo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu a baha i wimiheya i pa, ‘Ee, tau Lawa Moinau, ma yohola apo Tu maninidumana u awala hinebawana a tugutugula, ma ona gagaleu ma yaloi uyahinei a hopu mai.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Uyahinei tu witalaguyaba hai taniwaga uyona i gigai ma a kaleko i loloya ma i baha i pa, ‘A baha amaka o nonoli? Amaka ma ega tu wigou hina ibaabani a powa binei, ");
INSERT INTO tbo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","babana a baha widiboga Yaubada uyahina amaka ta nonoli, ma omi nugotuhu awai Yesu binei?’ Ega yaka a boluhi hi pa, ‘A baha powa binei ina hilage.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ega yaka Yesu hi howaya, ma matana hi humaya kalekogei ma hi launawatatani hi pa, ‘Una wipiko iyai e ilawim?’ Ma tu wigawiya hi numa panipani po hi lawi ma hi niyeya. ");
INSERT INTO tbo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ma Pita mayau uyahina i lalana, ma tu witalaguyaba hai taniwaga a tu poula wawinena i nei, ");
INSERT INTO tbo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","po Pita i gagaleya ma i lalana yaka i pa, ‘Tam Yesu lawa Nasaletagei a bolu.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Pita i bowi i pa, ‘Om wibaabani ega ata hanapugeya.’ Ega yaka Pita i lowo hopu gali matetana u liyaliyana. ");
INSERT INTO tbo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma wawinena Pita i gagaleya mateta u liyaliyana i towotowolo, ma lawa hi lalana i paliwelehi i pa, ‘Noka lawana naka Yesu a hewali gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Pita i nonoli yaka i bowi meme i pa, ‘Tau eega.’ Ega yaka lawa hi towotowolo u liyaliyana hi pa, ‘Moina dumana, tam Yesu a bolu babana tam lawa Galiligei.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ega yaka Pita i wigwala labatana i pa, ‘U gwala amau, naka lawana binei o ibaabani, tau ega ata hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hougana naka kamkam olotona a tou i luwagaya, ma Yesu a baha Pita nugonei i gae, Yesu a baha i pa, ‘Kamkam olotona a tou apega ina wiluwagaya a sigana mala tonuga una bowiyeu.’ Pita i nugotuhuya ma i tou duma. ");
INSERT INTO tbo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Malatomtom kikina tu witalaguyaba babadahi po mi Yudeya hai tanitaniwaga po lugagayo tanitaniwagahi po tu wiwogatala atapuhi hi lueeneya yaka Yesu hi numa panipani po hi niyeya Pilato uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato mi Loma hai gawana tauna Yesu i lubayadeya i pa, ‘Tam mi Yudeya hai wasawasa, bo?’ Yesu i pa, ‘Tam om baha naka pite.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma tu witalaguyaba babadahi Yesu ginouli atapuna uyahinei hi wigouya. ");
INSERT INTO tbo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ega yaka Pilato Yesu i lubayadena meya i pa, ‘Ega om baha awai hi goum ginouli atapuhi ubeihi?’ ");
INSERT INTO tbo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yesu i genuwana, yaka Pilato nugonugona i goholi. ");
INSERT INTO tbo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bolima emosi po emosi Welulagona tolehana uyahina lawa hoi numa panipani he memae ma bolu lawa awai hai luhogala uyahina apo hina winagani yaka gawana lawana apo ina lupena haleya hoi numa pani. ");
INSERT INTO tbo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bolima geka Welulagona tolehana iyetana ma hoi numa panipani lawa gehouna i memae gowana Balaba tauna witona i liwawali po omunugo binei hoi numa panipani i memae. ");
INSERT INTO tbo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bolu hi’mboina nae Pilato uyahina, po hi baha hi pa, ‘Nugonugoiyai lawa gehouna una lupena haleya hoi numa panipani.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ega yaka Pilato hai baha i wimiheya i pa, ‘O luhogaleya mi Yudeya omi wasawasa a lupena haleya, bo?’ ");
INSERT INTO tbo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato hai matababana amaka i galena tuhagaya, naka tu witalaguyaba babadahi, Yesu hi’mgenagenaliliyeya yaka hi numa panipani po ipa hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tu witalaguyaba babadahi lawa u nugonugohi hi wohouni ipa Balaba ina lupena haleya. ");
INSERT INTO tbo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato i lubayada meme i pa, ‘Awai nugonugomi ipa mi Yudeya omi wasawasa uyahina a dewaya?’ ");
INSERT INTO tbo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bolu atapuhi hi otu labatana hi pa, ‘Una witakeya!’ ");
INSERT INTO tbo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato i lubayada i pa, ‘Ma powa awai i dewaya?’ Ma bolu hi otu meme hi pa, ‘Una witakeya!’ ");
INSERT INTO tbo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato nugonugona ipa bolu ina winugohegoyahi. Pilato i baha po Balaba hi lupena haleya ma Yesu hi wilawi ma ipa hina niyeya po hoi ani take hina tutu lawiteya. ");
INSERT INTO tbo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ega yaka mi Loma hai tu wigawiya Yesu hi luiyeya taniwaga a numa baneina u hinena, ma tu wigawiya hai bolu atapuna hi’mboina gogona mai Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma tu wigawiya Yesu tu wasawasa hai luilui hi wiluiya, ma a unuhau gologolowa waidonadonana hi dewaya po u unununa hi houni. ");
INSERT INTO tbo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma Yesu hi lauguyoguyougeya hi pa, ‘Tinani tam mi Yudeya hai wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma unubolina hi kodili digona uyahinei, ma hi howaya ma hi tupolou po hi wotalagae koyakoyama. ");
INSERT INTO tbo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hi luguyoguyougena woloeya ma wasawasa hai luilui hi wihaleya ma tauna a kaleko dumana hi wiluiya, ma hi niniyeya ipa hina witakeya. ");
INSERT INTO tbo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tahayagei hi nenae po lawa gehouna hi tuhagaya, gowana Simona tanogei i nenei ipa ina nae meyagai baneina uyahina. Ma tu wigawiya hi utani po Yesu anani take i awali. Simona tauna lawa Sailinagei natunatuna ololotohi luwaga Alesana ma Lupasi. ");
INSERT INTO tbo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu hi niyeya oya gowana Gologota, a bui naka ‘Ununu Dobuna.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ega yaka wine mulamula waigolana mitehi hi wila emoteya ma hi weleya, ma Yesu wine noka i wihinigigiyeya. ");
INSERT INTO tbo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma Yesu hoi ani take hi tutulawiteya ma a kaleko hi wikibugehi po hi tamihi. ");
INSERT INTO tbo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hougana Yesu hi tutulawiteya ani take uyahina mei iyeta bolina ina lauliyaliyani. ");
INSERT INTO tbo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tauna ani wigouna hi giluma geleteya hi pa: ");
INSERT INTO tbo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tu danene luwaga mitehi hi witake gogonehi gehouna u awala hinebawana ma gehouna u awala kehana. ");
INSERT INTO tbo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lawa liyaliyanei hi nenae ma hi bahabaha gae ma hi ununu kwadikwadiyana, ma hi palipaliyeya hi pa, ‘Ee, u baha u pa emoemotam apo numa dalabu una hoe haleya, ma iyeta tonuga u hinena una wogomeya. ");
INSERT INTO tbo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Heki, tam una luyawihi mem po ani takegei una hopu.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma tu witalaguyaba babadahi po lugagayo tanitaniwagahi tunawahi ma Yesu hi inameya hi pa, ‘Lawa gehouhi i wiluyagohanihi ma iyowai po tauna ega ita wiluyagohana meya? ");
INSERT INTO tbo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Itapa tauna Besinana lawana po mi Yudeya ata wasawasa, heki, geka hougana ani take uyahinei ita hopu mai po tata galeya ma tata witumaganeya.’ Tu danene luwaga Yesu mitehi hi take gogonehi tauhi gasi Yesu hi widibogi. ");
INSERT INTO tbo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iyeta i lautipolini ma kabudala lalana i wohouni po tupo atapuna i uguguwi a sigana kabudalana i hopu po ibiga i lutipolini. ");
INSERT INTO tbo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Houga noka uyahina Yesu i otu i pa, ‘Eloi, Eloi, lama Sabatani?’ anona ‘U Yaubada, U Yaubada, awai binei u wihinigigiyeu?’ ");
INSERT INTO tbo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma lawa gehouhi u liyaliyana hi towotowolo, geka bahana hi nonoli po hi pa, ‘Geka lawana Elaisiya e ototugeya.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ega yaka lawa gehouna uyahihiyei i bulili nae po baloi i waya po wine waitululuwana uyahina i wiyoli ma hige uyahinei i tupahigeya po i wiyoyoga giyeya u gamona ipa ina hanaguguya, ma i pa, ‘Heki, ona wohouna ma tana iotonana ma apo Elaisiya ina nei po ina wiluyagohani.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ponana i lata apoma i hilage. ");
INSERT INTO tbo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma numa dalabu baneina u hinena kaleko baneina i taketake i gunalolo luwageya, u moyana ma i hopu po u babana. ");
INSERT INTO tbo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma tu wigawiya hai taniwaga, Yesu u naona i towotowolo ma i gagaleya, ma Yesu a otu i nonoli, u mulina apoma i hawalele, yaka lawana i kawamoina i pa, ‘Baha dumana geka lawana Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wiwine gehouhi uheiya hi towolo ma hi gagalena nae. Gehouna gowana Maliya Magadalagei ma gasi Maliya gehouna tauna Yamesa a waligeha ma walehina Yosa hinahi, ma Salome. ");
INSERT INTO tbo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Geka wiwinehi tauhi Yesu hi wotagoya po hi haguhaguya a wiwila tupo Galili uyahina. Ma gasi wiwine gehouhi Yesu mitehi Galiligei hi nei Yelusalem, tauhi Yesu a hilage matahiyei hi galeya. ");
INSERT INTO tbo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Amaka aibiga po hai wononogo iyetana mi Yudeya hai dalabu binei. ");
INSERT INTO tbo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ega yaka Yosepa Alimatiyagei i nei, tauna mi Yudeya hai tu wiwogatala dewadewana, ma i otonana Yaubada a taniwaga a houga nei. Yosepa tauna lawa nugonugomotuna yaka i nae Pilato uyahina po Yesu hinina i lupaliyeya ipa ina waya. ");
INSERT INTO tbo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A baha uyahina ma Pilato i goholi, po i pa, ‘Moina amaka i hilage?’ Ega yaka Pilato gawiya taniwagana i himili ipa Yesu a hilage ina limoineya. ");
INSERT INTO tbo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ega yaka gawiya taniwagana i baha i pa, ‘Ee, amaka i hilage.’ Apoma hinina i palihaleya Yosepa uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Apoma hoi ani take i telehopuneya po kokowaga kalekonei i humaya. Kokowagana naka tapatapana hi hedali po i lui. Ma guduna gaima baneina, hi buiya po matetana hi lutomgeya. ");
INSERT INTO tbo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma wiwine luwaga hi gagalehi ma Yesu hi houni hoi kokowaga, naka Maliya i nei Magadalagei, ma a waligeha Yosa hinana. ");
INSERT INTO tbo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mi Yudeya hai dalabu iyetana i kokoe ma malatomtomgei Maliya Magadala, ma a waligeha tauna Yamesa hinana, ma Salome, geka wiwinehi bunama dimudimumuna hi gimalaya po ipa Yesu hinina hina wineuli. ");
INSERT INTO tbo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Malatomtom kikina, gaogao a iyeta tahatahayana uyahina kabudala i gelegeleta ma wiwinehi hi nae Yesu kokowagana uyahina. ");
INSERT INTO tbo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tahayagei hi nenae ma tunawahi hi ibaabani hi pa, ‘Iyawoi hita haguta po gaima hita beuli kokowaga matetanei?’ ");
INSERT INTO tbo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hougana hi geleta kokowaga uyahina, ma hi galena nae po gaimana hi gagaleya naka amaka hi beula liyeni kokowaga matetanei. ");
INSERT INTO tbo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yaka wiwinehi hi lui kokowaga u hinena, ma hewali gehouna a luilui wakewakekena u awala hinebawana i tugutugula, ma hi matouta duma. ");
INSERT INTO tbo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma hewalina i paliwelehi i pa, ‘Ega ona matomatouta. Yesu lawa Nasaletagei hi tutulawiteya ani take uyahina, tauna o bibiheya, ega geka hotana ita memae amaka i towolo meme, anani eno o galeya kokoena.’ ");
INSERT INTO tbo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma hewalina i paliwelehi i pa, ‘Ona gunawilemi po ona nae, ma tuwegana a lawa ona paliwelehi, ma Pita ona paliweleya, ona pa, “Yesu e tahatahaya nae u Galili ma taumi noka hota apo ona galeya mei lolowa uyahimi i bahabaha pite.” ’ ");
INSERT INTO tbo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma wiwinehi kokowaga hinenagei hi weluhopu anai nugohelelehi po anai matoutahi hi bulibulili ma ega iyai hita paliweleya, babana matouta u nogonugohi. ");
INSERT INTO tbo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gaogao a iyeta tahatahayana uyahina Yesu malatomtom kikina ma i towolo meme po i lugeletena tahaeya Maliya Magadala uyahina, tauna Maliyana lolowa alugo apapoehi magouhi 7 Yesu i lilupa hopunehi ma i dewadewa. ");
INSERT INTO tbo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tauna tuwega i niyeya po a hewahewali i paliwelehi. Hi nugodubu po hi tutou Yesu binei. ");
INSERT INTO tbo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma Maliya tuwega i palipaliwelehi i pa, ‘Yesu amaka i towolo meme po mitehi to witutuhaga.’ Ma ega hita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Naka u mulina a hewahewali luwaga, tauhi tahayagei hi nenae, ma Yesu i lugeleteya tepa tapunei uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tauhi naka hi gunawilehi po hai lawa hi paliwelehi awai hoi tahaya ma hi gelegeleta. Ma hai baha ega hita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","U mulina Yesu i lugeleteya a hewahewali magouhi 11 uyahihi, tauhi hi’mam ma Yesu i geleta u tipolihi po i towolo ma i paliyehi i pa, ‘Awai binei u towolo meme lawa hi bahebaheya ega ota witumaganehi? Nugonugomi awai he guduguduhi?’ ");
INSERT INTO tbo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ega yaka Yesu i baha nae uyahihi i pa, ‘Hipuli tupo wohepali uyahihi ona nae po tuwega dewadewana ona guguyeya lawa atapuhi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma apo iyawoi hina witumaganeu yaka ona bapatisohi po Yaubada ina wiluyagohanihi ma iyawoi ega hina witumagana yaka apo Yaubada ina kawaiapapoenihi. ");
INSERT INTO tbo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Apo iyawoi hina witumagana yaka wekiwekilala uyahihi ina geleta po gowaugei alugo apapoehi lawa uyahihi hina wiyagahi ma apo pona gehouhi uyahihiyei hina ibaabani. ");
INSERT INTO tbo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Apo mota apapoehi hina wohepahi ma apega hina wiyuwa, apo kakai hin’umahi apega hina hilage. Ma apo tu tootogo hina wotepanihi yaka hina dewadewa.’ ");
INSERT INTO tbo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Guyau Yesu a baha i wikokowi a hewahewali uyahihi, ma i gae hoi yada po Yaubada u awala hinebawana i tugula. ");
INSERT INTO tbo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesu a hewahewali hi hopu po hi nae tupo atapuhi uyahihi hi luguguya, ma Guyau a baha i laimoineya wekiwekilala uyahihiyei. ");
INSERT INTO tbo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiyopilasi tam taniwaga dewadewam. Awai u hayata hi waawala naka lawa hi maga duma hi wileta ipa hina giluma hopunehi. ");
INSERT INTO tbo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yesu a baha tu limoinena po tu bagibagiyena anani wawala ugolina hi bahebaheya hi giluma hopunehi. ");
INSERT INTO tbo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Geka ginoulihi hai ani wawala ugolihi a todi ma a inugohiyahiyawehi po i nenei naka i dewadewa duma yaka a giluma dumaluhi tam Tiyopilasi bimgei. ");
INSERT INTO tbo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma geka a dewadewaya naka apo ginouli atapuhi hi palipaliwelem moinana una hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heloda a houga wiwasawasa u Yudeya ma tu witalaguyaba gehouna gowana Sakaliya tauna Abiya a bagibagi tu woiteyana i mamae. Agona gowana Elisabeta tauna Alona gugunigei i nei. ");
INSERT INTO tbo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hai luwaga Yaubada matana hi dumalu po a lugagayo po a palihanahanapu atapuhi hi iponawogogehi. ");
INSERT INTO tbo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tamogi ega natuhi babana Elisabeta naka alinawa ma i wikeduluma po Sakaliya amaka i wibada. ");
INSERT INTO tbo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iyeta gehouna Sakaliya witalaguyaba bagibagina i laidumaluya Yaubada u matana. ");
INSERT INTO tbo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ma tu witalaguyaba hai dewa naka wikibu po wikibugei i welutahaya po ipa apo tauna dadi ina apuya. Ega yaka i lui gae Guyau a numa dalabu baneina u hinena. ");
INSERT INTO tbo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma lawa atapuhi noka hougana dadi i apapuya naka u uputa hi laupali. ");
INSERT INTO tbo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma Guyau a tu winoyanoya dadi ani’mapuna u awala hinebawanei i lugeleteya. ");
INSERT INTO tbo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hougana Sakaliya i gagaleya po i goholi ma matouta i geini. ");
INSERT INTO tbo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma Yaubada a tu winoyanoya i baha i pa, ‘Sakaliya, ega una matomatouteu. Yaubada amaka am lupali i nonoli po agom Elisabeta apo natum olotona ina guni. Apo gowana Yoni una hiyawi. ");
INSERT INTO tbo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Apo ina tutuipeili hougana una kaoha po una kaoha duma ma gasi lawa magomagouhi apo hina kaoha. ");
INSERT INTO tbo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Matababana Guyau u matana apo tauna lawa baneina. Apega wine po umauma kadikadidilihi ina umuma. Ma hina guniguni hougana apo Alugo Woiyawa ina wihogoya po ina mamae po houga magomagouna. ");
INSERT INTO tbo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma tauna apo Isalaela lawahi ina buinihi po hina luhagawilehi Guyau Yaubada ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tauna apo Guyau u naonei ina tahaya mai a nugotuhu po a wipoya mei tu bahapiko Elaisiya. Ama po natu tauna apo ina winugoemotahi po tu wiponahahalena dewadumaluna ugolina ina hounihi. Ma Guyau ubeina lawa ina wononogogehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaliya i baha nae tu winoyanoya ugolina i pa, ‘Iyowai apo geka a wikawamoineya babana tau amaka a wibada ma agou i wikeduluma.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma tu winoyanoyana a baha i wimiheya i pa, ‘Tau Gabeliyela houga magomagouna Yaubada u matana a towotowolo. Ma tauna i himiliu po a nei ugolim geka tuwega dewadewana ipa a paliwelem. ");
INSERT INTO tbo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tamogi u baha ega uta kawamoineya ma agom a houga wigunaguna ugolina apo una limoineya. Ma ega uta kawamoineu yaka apo una wigumgum po ega ponam a sigana iyeta noka ugolina anona ina lugeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lawa boluhi u uputa hai wiotonana ugolina ma hi pa, ‘Iyowai po Sakaliya a mae i dao numa dalabu baneina u hinena?’ ");
INSERT INTO tbo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hi otonana ma Sakaliya i hopu mai po hi pa, ‘Nugote Sakaliya numa dalabu baneina u hinena awai i galeya, po ega emoemotana ina baha ma nimanei e ibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iyeta wabihaga hi nae ma apoma Sakaliya a bagibagi atapuhi i wikokowihi ma apoma i gunawileya a u meyagai. ");
INSERT INTO tbo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma a bagibagi hi kokoe po gaogao ega ita dao ma agona Elisabeta i koiba po tuawana hau numa i mamae wamahiya nimitutu hi kokoe ma i pa, ");
INSERT INTO tbo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‘Amalai apoma Guyau i haguwe po u wialinawa wihinimayana lawa u matahi i wihaleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeta i koiba po i mamae a wamahiya magouna 6 ma Yaubada a tu winoyanoya gowana Gabeliyela i himila hopu neiyai u Nasaleta, Galili u tupona. ");
INSERT INTO tbo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tu winoyanoyana guguhini gowana Maliya a tuwega i neiyai. Maliya tauna hi bigeya wasawasa Dawita a guguni hewalina gehouna gowana Yosepa ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tu winoyanoyana i nei po Maliya ugolina i pa, ‘Tinani tam. Guyau a winagana po gasi tauna tam mitehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tu winoyanoyana a baha ugolina ma Maliya nugonugona i helele duma po a bahahi anohi i inugonugotuhugehi. ");
INSERT INTO tbo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma tu winoyanoyana i pa, ‘Maliya, ega una matomatouta babana amaka Yaubada i hagu lagonem. ");
INSERT INTO tbo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tam apo natum olotona una koibeya po una guni po gowana Yesu una hiyawi. ");
INSERT INTO tbo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tauna apo lawa baneina gehouna ma lawa apo hina wootalagiyeya hina pa, “Yaubada Gegewahagana Natuna.” Ma Guyau Yaubada apo tauna ina dewaya po wasawasa mei gogana Dawita i wasawasa pite, ");
INSERT INTO tbo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","po apo Yakobo a guguni u hinehi ina iwasawasa houga magomagouna ina nae po ega a siga ma anani taniwaga apega ina kokoe.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Maliya tu winoyanoyana ugolina i baha i pa, ‘Tau ega ata tawine ma apo iyowai a wigunaguna?’ ");
INSERT INTO tbo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma tu winoyanoyana i pa, ‘Alugo Woiyawa apo ina nei po Yaubada a wipoya ina welem po ugolinei tewela waiwoiyawana una guni po gowana hina hiyawi, Yaubada Natuna. ");
INSERT INTO tbo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Am guguni wawinena Elisabeta gasi i koiba a houga wikeduluma ugolina. Tauna ipa ega emoemotana ina wigunaguna ma amalai a wamahiya magouna 6. ");
INSERT INTO tbo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Matababana Yaubada ginouli atapuhi emoemotana.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Maliya i baha nae tu winoyanoyana ugolina i pa, ‘Tau Guyau tu wiponawogogena ma amalai awai u palipaliweleu ugoliu ina wawala.’ Ma tu winoyanoyana Maliya i nehaleya. ");
INSERT INTO tbo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Geka u mulina Maliya i wononogo ma i wotowolo po i nae dobu waioyana i tutani po i nae Yudeya u hinena. ");
INSERT INTO tbo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","I nae po Sakaliya a u numa i geleta po Elisabeta i mamali. ");
INSERT INTO tbo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma Elisabeta pona i noonoli po natuna managona u hinena i’imtuilupa po Elisabeta Alugo Woiyawa i wihogoya. ");
INSERT INTO tbo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma ponana i lata ma i wootu i pa, ‘Wiwine atapuhi u hinehi tam tu kaoha lagona po tewelana apo una guniguni tauna tu kaoha. ");
INSERT INTO tbo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aee, awai binei lunugotootogo geka pite i wawala po u Guyau hinana i witoumana mai ugoliu. ");
INSERT INTO tbo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Matababana am baha wimaamala a noonoli po tewela u managou i kaoha po i’mtuilupa. ");
INSERT INTO tbo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Guyau a baha u itumaganeya binei apo ina laimoineya naka tam tu kaoha.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya i pa, ‘Guyau a hunena dumaya ");
INSERT INTO tbo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma nugonugou hinena i wotalagae babana u Yaubada Tu wiluyagohaniu. ");
INSERT INTO tbo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tau a tu bagibagi yabayababa ma i galena tuhagau tau. Ugolinei lawa atapuhi amalai ma i wawala po i nenae apo hina pa tau tu kaoha. ");
INSERT INTO tbo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Matababana Yaubada manininagei ginouli gegehi biugei i dewahi. Tauna gowana i wiwoiyawa. ");
INSERT INTO tbo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A lunugotootogo i mewahaga hapana po hapana ugolihi iyawoi Yaubada hi matumatuteya. ");
INSERT INTO tbo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tauna nimana kadikadidilina i lodomi po tu nugogegae hai wiwogatala i lunohahi. ");
INSERT INTO tbo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wasawasa gegehi hai ani tugula ugolihi i hauhopunehi ma tu nugohopuhopu i houna geletehi. ");
INSERT INTO tbo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tu omhilage lawahi i wiomhiyougohi, ma tu wigapola lawahi a nima kwakwawihi i himilihi. ");
INSERT INTO tbo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A paliwitumagana googata ugolihi i womomota emoteya, ma i nei Isalaela lawahi ina haguta. ");
INSERT INTO tbo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","A lunugotootogo Abelaham ugolina i woogeleteya po gasi googana, po ataputa ugolita apo ina nae po ega a siga.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma Maliya Elisabeta mitehi hi mamae wamahiya tonuga hi kokoe ma i gunawilena meya a u numa. ");
INSERT INTO tbo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeta upuna i wiyuwa po i igunaguna po natuna olotona. ");
INSERT INTO tbo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ma a lawa po a guguni hi noonoli po tauna mitehi hi kaoha babana Guyau a hagu dewadewa dumana i weleya. ");
INSERT INTO tbo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Natuna i guni po iyeta magouhi 8 hi kokoe ma lawa hi’mboina mai. Ma hai dewa hi deweya po tewelana a wekiwekilala naka hinina hi hapi ma ipa Sakaliya hina wiwaligeheya. ");
INSERT INTO tbo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma tamogi hinana i pa, ‘Apega. Apo gowana Yoni.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma a lawa hi pa, ‘Ega ita dewadewa ipa Yoni una hiyawi babana ega am bada gehouna gowana Yoni.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Apoma amana nimahiyei hi paliweleya gowana apo iyai ina hiyawi, babana tauna naka i wigumgum. ");
INSERT INTO tbo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma Sakaliya ani’mgiluma i lupaliyeya po i’mgiluma i pa ‘Gowana Yoni.’ Ma lawa nugonugohi hi goholihi. ");
INSERT INTO tbo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma noka hougana Sakaliya a wigumgum i kokoe po i wibaabani meme ma Yaubada i wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lawa u liyaliyahi tu mae matouta i wihogohi. Ma geka dewana atapuna tuwegana naka Yudeya oyana i weluyayata pahi. ");
INSERT INTO tbo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lawa iyawoi tuwegana hi noonoli naka hai nugohine ma hi pa, ‘Geka tewelana apo tauna iyai?’ Matababana i lugeletana dumaya naka Yaubada a wipoya tauna ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yoni amana Sakaliya Alugo Woiyawa i wihogoya po Yaubada tuwegana i baheya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","‘Isalaela lawahi ata Guyau Yaubada ta wotalagiyeya. Tauna a lawa haguta binei i nei po hau panipani i lupena haleta. ");
INSERT INTO tbo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yaubada a tu wiponawogo lawana gowana Dawita gogana i himiliyai Tu wiluyagohanita kadikadidilina. ");
INSERT INTO tbo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tu bahapiko waiwoiyawahi hi palipaliwitumaganeta hi pa, ");
INSERT INTO tbo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tu wiluyagohana apo ina himili yaka tauta ata gawiya po tu wihinigigiyeta hai manini ugolihi ina luyawahita. ");
INSERT INTO tbo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ma i baha i pa apo googata ina lunugotootogogehi po a wiwogatala waiwoiyawana nugonei ina gae. ");
INSERT INTO tbo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mei gogata Abelaham ugolina i igwala, naka pite i paliwitumaganeta. ");
INSERT INTO tbo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tauna ata gawiya u nimahi apo ina halota po tauna apo ta pupouleya ma apega ta lowogeya. ");
INSERT INTO tbo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yaka houga magomagouna ata luyagohana iyetahi ugolihi ata dewa apo hina wiwoiyawa po ina dumalu tauna u matana. ");
INSERT INTO tbo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma tam natuwe, Yoni, apo Yaubada Gegewahagana a tu bahapiko. Apo Guyau u naonei una tahaya po a tahaya una diuya. ");
INSERT INTO tbo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma lawa una paliwelehi naka Yaubada apo hai apapoe ina paligigilihi ma luyagohana hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ata Yaubada a lunugotootogo po a woideedeyana, apo luyagohana yayatana namanamalina ina dewaya po ina lalanita. ");
INSERT INTO tbo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Apo yadei ina lalana hopu mai iyawoi hilage loguna u hinena ta mamae ataputa ugolita, po dumola tahayana ugolina aeta hounana ina laidumaluya.’ ");
INSERT INTO tbo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tewelana Yoni i lalata ma a winugonugotuhu hi lalata. Ma hau balabala yabayababa i meme nae a sigana a houga i geleta po Isalaela lawahi u matahi i wogeletena meya. ");
INSERT INTO tbo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Noka hougana Sisa Ogasito a houga witaniwaga Loma u hinena ma i baha ipa apo tupo atapuna lawa gowahi hina giluma hopunehi. ");
INSERT INTO tbo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Geka naka omgiluma tahatahayana Kwiliniya a witaniwaga u Siliya hougana. ");
INSERT INTO tbo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ugolinei ma lawa atapuhi yamoha po yamoha i nenae a meyagai ugolina po gowana hi gilugilumi. ");
INSERT INTO tbo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tupo Galili u hinena u Nasaleta Yosepa i wotowolo po i gae u Yudeya, meyagai gowana Betelehem ugolina. Yosepa i nae noka hosi babana gogana Dawita noka dobunei i nei. ");
INSERT INTO tbo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ma tauna Maliya ugolina hi bigebigeya mitehi hi nae po gowahi hi gilumihi. Maliya a koibana ");
INSERT INTO tbo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ma u Betelehem hi mamae po a houga wigunaguna i geleta. ");
INSERT INTO tbo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma i wigunaguna po a tutuwoga olotona i guni po lupulugei i huma imahiyeya ma gamogamo hai gaeba u hinena i wienoya. Matababana ani wiyagohina numana u hinena ega meka babanoya kwakwawina. ");
INSERT INTO tbo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dobuna u liyaliyana naka sipi tu galena itete u pitepitei hai sipi upomgei hi gagalena itetehi. ");
INSERT INTO tbo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma Guyau a tu winoyanoya i lugeleteya ugolihi po yayata namanamalina i yayata wiiwilehi po lowo i geinihi. ");
INSERT INTO tbo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma ega yaka tu winoyanoyana i pa, ‘Ega ona matomatotouta. Ami tuwega dewadewana waikaohana a neiyai lawa atapuhi ubeihi. ");
INSERT INTO tbo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Geka amalai Dawita a meyagai u hinena Tu wiluyagohanimi hi guni. Tauna Guyau, Yaubada a Besinana lawana. ");
INSERT INTO tbo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma ani limoina naka tewelana apo a humahumana gamogamo hai ani am u hinena e eneno ma apo ona tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mala emosi ma tu winoyanoya boluhi yadei hi lugeletehi tulahina u liyaliyana po Yaubada ugolina hi yamhuna hi pa, ");
INSERT INTO tbo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","‘Yaubada Gegewahagana ta wotalagiyeya po iyawoi hau hipuli i kaokaohehi ugolihi nugodumola ina mae.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hougana tu winoyanoyana i wotowolo po i gae hau yada ma sipi tu galena itete tuawahi hi pa, ‘Guyau geka ginoulina ugolita i woogeleteya ta nae u Betelehem po ta galeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ega yaka yagiyagina hi nae po Maliya po Yosepa po tewelana gamogamo hai gaeba u hinena i eneno ma hi tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma hi gagalehi po hi paliwelehi iyowai tewelana binei ma tu winoyanoya ugolihi i bahabaha. ");
INSERT INTO tbo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyawoi sipi tu galena itete hai bahana hi noonoli po hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Maliya geka ginoulihi atapuhi nugonei hi gae ma i toditodi naka bala tapuna. ");
INSERT INTO tbo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma sipi tu galena itete Yaubada hi wootalagiyeya po hi hunehuneya ma hi gunawilehi. Matababana awai atapuna hi noonoli po hi gagaleya naka i laimoineya mei tu winoyanoyana i palipaliwelehi pite. ");
INSERT INTO tbo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iyeta magouhi 8 hi kokoe ma tewelana a wekiwekilala naka hinina hi hapi ma hi wigowaya po Yesu. Gowana geka yohola ega hita guni ma tu winoyanoya hi palipaligeleteya tauna hi hiyawi. ");
INSERT INTO tbo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mose a lugagayo i baheya i pa, tutuwau hai wigunaguna u mulina hina laiyeuyeu mehi. Ega yaka Yosepa ma Maliya tewelana hi weluwaya po hi nae u Yelusalem ipa Yaubada ugolina hina wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Matababana Mose a lugagayo ugolina i baheya i pa, ‘Tutuwoga ololotohi atapuhi hina palipaligwalehi Guyau ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma Mose a lugagayo i baheya i pa, ‘Bunebune luwaga bo natunatuhi luwaga ugolihiyei hai ani witalaguyaba hina dewadewahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Noka hougana lawa gehouna dewadewana gowana Simona Yaubada tu wiponawogogena u Yelusalem i mamae. Tauna Isalaela Tu witowolo mena i ototoni ma Alugo Woiyawa i luiya. ");
INSERT INTO tbo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma Alugo Woiyawa i paliweleya naka apega ina hilage a sigana Guyau a Besinana lawana ina galeya ma apoma ina hilage. ");
INSERT INTO tbo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tewelana Yesu tu gunina hi geleteya numa dalabu baneina u hinena ipa Mose a lugagayo hina wotagoya ma Alugo Woiyawa Simona i tahaeya po i nae numa dalabuna u hinena. ");
INSERT INTO tbo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ma Simona tewelana i guni po u nimana ma a wimaamala Yaubada ugolina i dewaya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","‘Guyau Wasawasa, am paliwitumagana amalai u limoineya yaka amaka ma tau am tu bagibagi nugodumolagei una palihaleu po a hilage. ");
INSERT INTO tbo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Matababana amaka am Tu wiluyagohana lawa atapuhi ubeihi u wononogogeya matougei a galeya. ");
INSERT INTO tbo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tauna tu meuputa hai yayata am nugotuhu galena tuhagana binei. Ma am lawa mi Isalaela hai wasawasa binei.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simona Yesu binei ma awai i bahebahehi naka amana po hinana hi nugogohola duma. ");
INSERT INTO tbo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ma i kawaidewedewehi ma Maliya ugolina i baha nae i pa, ‘Apo nugonugom ina wiyuwa duma babana geka tewelana tauna wekiwekilala Isalaela lawahi ugolihi, ma apo hina wihinigigiyeya. Lawa hai nugotuhu gowagowadahi apo ina wogeletehi tepanei ma lawa boluhi apo hina peu ma gehouhi hina towolo.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Noka hougana keduluma odubona gowana Ana tauna tu bahapiko gehouna ma amana Penuweli ma a guguni Asa. Tauna a guguhinina ma i tawine po i mamae agona mitehi naka bolima magouhi 7, ");
INSERT INTO tbo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma i hiwape po i mamae naka bolima magouhi 84. Tauna numa dalabu baneina ega ita nenehaleya. Uguwa po iyeta i wootalagae po am i iyohiyeya ma i laupali. ");
INSERT INTO tbo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Noka hougana emosina i lui gae hau numa dalabuna tewelana ubeina po Yaubada ugolina i wimaamala. Ma iyawoi Yelusalem Tu luyawahina hi ototoni atapuhi ugolihi i wibaabani. ");
INSERT INTO tbo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hougana tewelana hinana po amana Mose a lugagayo dewana atapuna hi ikokowi naka hi gunawilehi Galili u tupona, hai meyagai dumana Nasaleta ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma tewelana i lata po i kadidili ma nugonugona i holahola po Yaubada a nugohegoya tauna ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bolima emosi po emosi Yesu tu gunina hi gegae u Yelusalem Welulagona tolehana ubeina. ");
INSERT INTO tbo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hougana Yesu a bolima magouhi 12, hinana po amana mitehi hi gae toleha binei mei bolima emosi po emosi. ");
INSERT INTO tbo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ma hougana tolehana i kokoe po hai houga gunawilana ugolina tewelana Yesu u Yelusalem ma hi nehaleya. Hinana po amana ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hai nugotuhu hi pa, bolu mitehi hi nenae naka tauna mitehi. Ugolinei ma iyeta atapuna hi negeya ma apoma hi tugudu po hai guguni po hai lawa u hayahi hi beiha. ");
INSERT INTO tbo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma ega hita tuhagaya yaka hi beiha po hi gunawilehi u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iyeta tonuga hi kokoe ma apoma numa dalabu baneina u hinena hi tuhagaya. Tu wiatatiyana u hayahi i tugula ma i launonola ma i laubayabayada. ");
INSERT INTO tbo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tu lunonolena atapuhi a hanapu po baha wimihana ugolina hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hougana hinana po amana hi gagaleya po hi gohola dumahi. Ma hinana i baha nae ugolina i pa, ‘Natuwe, iyowai po geka u dewiyai? Amam po tau a nugodubuiyai to bibihem.’ ");
INSERT INTO tbo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma tauna ugolihi i baha i pa, ‘Awai binei uheiya o bibiheu? Moina ega ota hanapugeya naka tau Amau a numa u hinena?’ ");
INSERT INTO tbo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma awai ugolihi i bahebaheya naka ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tauna mitehi hi hopu po hi nae u Nasaleta po iponawogogehi. Ma geka ginoulihi atapuhi naka hinana a nugohine. ");
INSERT INTO tbo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu i lalata ma a winugonugotuhu hi lalata po Yaubada po lawa hi kawaidewedeweya. ");
INSERT INTO tbo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Tibeliya u Loma i iwasawasa bolima magouna 15 u hinena naka Ponitiyo Pilato mi Yudeya hai taniwaga. Ma Heloda Galili tupona i gagalena iteteya ma walehina Pilipo Ituleya tupona i gagalena iteteya, ma gasi Talakoniti tupona i gagalena iteteya. Ma Lisaniya Abilini tupona i gagalena iteteya. ");
INSERT INTO tbo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma Anase po Kayapa tauhi tu witalaguyaba tanitaniwagahi. Geka tauna hougana Yaubada a baha i nei Sakaliya natuna Yoni ugolina hau balabala yabayababa. ");
INSERT INTO tbo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yoni tauna i lui po i nae Yodani tupona atapuna u hinena apapoe paligigilana ubeina nugobui bapatisona i lauguguyeya. ");
INSERT INTO tbo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mei tu bahapiko Isaiya a baha bukana u hinena i gilugilumi i pa, ‘Lawa gehouna hau balabala yabayababa e iototu i pa, “Guyau a tahaya ona wononogeya. A tahaya ona lidumaluhi.” ");
INSERT INTO tbo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Guguba atapuhi apo hina hogohi. Oya baneihi po habuluhi apo hina hopu. Tahaya waiwilowilowahi apo hina dumalu. Ani nae waitupitupihi apo hina wihabuhabuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma lawa atapuhi apo Yaubada anani wiluyagohana hina galeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bolu hi hopu mai po Yoni ipa ina bapatisohi naka ugolihi i baha i pa, ‘Taumi ani galenami mei mota, ugolinei Yaubada a luuyogigai iyetana ipa ona lowo haleya. ");
INSERT INTO tbo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tamogi ega emoemotami babana ami nugobui anohi ega ota wogeletahi. Ma ega tuawami ona pa, “Gogiyai Abelaham,” naka ginouli yabayababa babana a paliwelemi Yaubada emoemotana po geka gaimahi ina dewahi po Abelaham googana. ");
INSERT INTO tbo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Geka hougana Yaubada ilama i wononogogeya ipa mayau u dedena ina taleya. Ugolinei ma mayau atapuna ega ita ugugo apo ina talahalehi po mayau alalatana ugolina in’omapugehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma bolu hi lubayadeya hi pa, ‘Iyowai apo to dewa?’ ");
INSERT INTO tbo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma hai baha i wimiheya i pa, ‘Iyai ugolina luilui luwaga yaka ina gutaya lawa gehouna ega ita iluilui mitehi. Ma iyai ugolina aniani yaka dewana emosina ina dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisi tu tama hi nei po ipa bapatiso hina waya tauhi gasi hi baha ugolina hi pa, ‘Bada, apo awai to dewaya?’ ");
INSERT INTO tbo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma tauna i baha i pa, ‘Gapola mihana a lata awai mi Loma hi bahebaheya naka ega ona huhouna lagoneya.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tu wigawiya hi lubayadeya hi pa, ‘Ma tiyai apo iyowai to dewa?’ Ma ugolihi i baha i pa, ‘Lawa hai gapola ega ona halohalohi bo koyamagei ona tamitamihi. Ma ami bagibagi mihahi ona kaohehi tamogi.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lawa hai witumagana hi lata po hi nugowilawila hi pa, nugote Yoni tauna Yaubada a Besinana lawana. ");
INSERT INTO tbo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yoni atapuhi ugolihi i baha nae i pa, ‘Tau eega; tau goilagei a ibapatisomi ma tauna tu gelagoniu naka e nenei. Tau ega u dewadewa awai ipa apo a aehumahuma a lupeni. Tauna apo Alugo Woiyawei po wipoya mei mayau alalatanei ina bapatisomi. ");
INSERT INTO tbo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Anani luhapu hipana u nimana po aniani mei pegapega ina tuwaluhi po a hanali u hinena ina tuupumi. Ma nudanudahi apo mayau alalata tuwetuweneina ugolina ina apuhi.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Luguguya galenahi tapuhi po tapuhigei Yoni tuwega dewadewana i lauguguyeya lawa ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma Yoni taniwaga Heloda i palihopuhopuneya babana walehina agona gowana Helodiyasi i lawalawagi binei. Ma gasi dewa apapoe atapuhi Heloda i dewadewahi bihiyei. ");
INSERT INTO tbo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Apoma apapoe banei dumana Heloda i dewadewaya naka Yoni hau numa panipani i tuguduya. ");
INSERT INTO tbo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lawa atapuhi hi bapatiso po u mulina Yesu i bapatiso. Ma hougana Yesu i laupali naka yada i gunahoeya ");
INSERT INTO tbo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","po Alugo Woiyawa i libunebuneya ma i hopu mai tauna ugolina. Ma pona yadei i hopu mai i pa, ‘Tam Natuwe a luhogalem, ma bimgei a kaoha.’ ");
INSERT INTO tbo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu hougana a bagibagi i wawali naka a bolima magouna 30. Tauna lawa hi pa amana Yosepa, ma Yosepa Heli natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli Matati natuna ma Matati Libai natuna. Libai Meleki natuna ma Meleki Yanai natuna, ma Yanai Yosepa natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepa Matiyasi natuna ma Matiyasi Eimosi natuna. Eimosi Nahum natuna ma Nahum Esili natuna. Esili Nagai natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Mata natuna. Mata Matatiya natuna ma Matatiya Semeina natuna. Semeina Yoseka natuna ma Yoseka Yoda natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda Yowanani natuna ma Yowanani Lesa natuna. Lesa Selubabe natuna ma Selubabe Satiyeli natuna. Satiyeli Neli natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli Meleki natuna. Meleki Adi natuna ma Adi Kosam natuna. Kosam Elumadam natuna ma Elumadam Elu natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Elu Yosuwa natuna ma Yosuwa Eliyesa natuna. Eliyesa Yolim natuna ma Yolim Matati natuna. Matati Libai natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai Simiyona natuna. Simiyona Yuda natuna ma Yuda Yosepa natuna. Yosepa Yonam natuna ma Yonam Eliyakim natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim Meleya natuna ma Meleya Mena natuna. Mena Matata natuna ma Matata Natani natuna. Natani Dawita natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawita Yese natuna. Yese Obedi natuna ma Obedi Bowasa natuna. Bowasa Sala natuna ma Sala Nahasona natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasona Amidana natuna ma Amidana Adimana natuna ma Adimana Ani natuna. Ani Heselona natuna ma Heselona Pelesa natuna. Pelesa Yuda natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda Yakobo natuna. Yakobo Isako natuna ma Isako Abelaham natuna. Abelaham Tela natuna ma Tela Naho natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho Seluga natuna ma Seluga Leu natuna. Leu Pelega natuna ma Pelega Ebe natuna. Ebe Sila natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila Kainana natuna. Kainana Apakada natuna ma Apakada Sem natuna. Sem Nowa natuna ma Nowa Lameka natuna. ");
INSERT INTO tbo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameka Metusela natuna ma Metusela Enoka natuna. Enoka Yaledi natuna ma Yaledi Mahalali natuna. Mahalali Kainana natuna ma ");
INSERT INTO tbo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainana Enosi natuna. Enosi Seta natuna ma Seta Adam natuna ma Adam Yaubada natuna. ");
INSERT INTO tbo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Yodani u goilana Alugo Woiyawa i wihogoya ma i gunagunawileya naka Alugo Woiyawa tauna i niyeya hau balabala yabayababa. ");
INSERT INTO tbo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iyeta magouhi 40 u hinehi Tomodulele i laudadani. Noka iyetahi ugolihi ega it’omam po u mulina ma am i hilage. ");
INSERT INTO tbo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Tomodulelena i baha nae ugolina i pa, ‘Inapa tam Yaubada Natuna yaka geka gaimahi una baha po hina lianianihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A bahana Yesu i wimiheya i pa, ‘Yaubada a Buka u hinena giluma e mamae i pa, “Lawa apega aniani tuawana ugolinei hina lauyagohana.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Apoma Tomodulele Yesu i weluwaya po hi gae. Kabudala kukuna u hinena hipuli tupo wohepali i wogeleteya ugolina po i galeya. ");
INSERT INTO tbo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma i baha nae ugolina i pa, ‘Geka dobuhi hai witaniwaga po hai wiwasawasa apo atapuhi tam a welem. Matababana i damanai u witaniwaga ugolina po tau apo iyai a lauhogaleya an’ombeneneya ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Inapa una polopolou ugoliu yaka geka atapunana apo ina wigalimgei.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yesu a baha i wimiheya i pa, ‘Yaubada a Buka u hinena i baheya i pa, “Guyau am Yaubada tam una polopolou ugolina po tuawana una pupouleya.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Apoma Tomodulele Yesu i weluwaya po hi nae u Yelusalem numa dalabu baneina u moyana i houni ma i baha i pa, ‘Inapa tam Yaubada Natuna yaka geka hosi ma una lupa hopu. ");
INSERT INTO tbo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Matababana Yaubada a Buka u hinena i baheya i pa, “Yaubada a tu winoyanoya mi yadena apo ina baha po hina galena itetem, ");
INSERT INTO tbo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma apo nimahiyei hina wohepam po apega aem una toneya.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu a bahana i wimiheya i pa, ‘Yaubada a Buka u hinena i pa, “Guyau am Yaubada ega una laudadani.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hougana Tomodulele ludadana atapuhigei Yesu i ludadani po i kokoe ma i nehaleya po i nae gaogao gehouna i wiotonaneya. ");
INSERT INTO tbo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma Alugo Woiyawa a wipoyagei Yesu i gunawileya u Galili. Tuwegana i gunanohaya po noka tuponana atapuna i hogoya. ");
INSERT INTO tbo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma tauna hai numa dalabu u hinehi i iatatiyana po lawa atapuhi hi huneya. ");
INSERT INTO tbo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Apoma Yesu i nae u Nasaleta, naka anani lata meyageina. Iyeta dalabu ugolina tauna hau numa dalabu i lui mei houga daodaona i dewadewa pite. Ma i towolo po ipa in’omhiyawa. ");
INSERT INTO tbo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma tu bahapiko Isaiya a buka hi weleya po i lagahi po i nae po omgiluma geka pite ugolina i geleta i pa, ");
INSERT INTO tbo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Guyau Alugona Waiwoiyawana tau ugoliu. Tauna i wotepaniu ipa tuwega dewadewana tu dayadayabu ugolihi a guguyeya. Tauna i himiliu ipa lawa hau panipani a paliwelehi apo panipani hina nehaleya. Ma tu matakeke hina galena meme, po iyawoi witai u hinena he mamae apo a wikaohahi. ");
INSERT INTO tbo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bolima awai apo Guyau a lawa ina iluyagohanihi ipa a baheya.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu bukana i lukukumi po numa dalabu a tu wihaguhagu i weleya ma i tugula. Ma lawa atapuhi numa dalabu u hinena hi todi ma hi halugeya. ");
INSERT INTO tbo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma i tugudu po lawahi ugolihi i baha nae i pa, ‘Baha kukuna o noonoli Yaubada a Buka u hinena naka amalai i lugeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lawa atapuhi hi kawaidewedeweya po gamonei baha waikamnahi i bahebahehi naka hi hunena dumaya. Ma hi pa, ‘Iyowai ma Yosepa natuna geka pite u ibaabani?’ ");
INSERT INTO tbo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma ugolihi i baha nae i pa, ‘A hanapugeya naka apo ona paliweleu geka baha hanahanapuhi, “Tu lumulamula, una wiluyagohana mem.” Ma gasi apo ugoliu ona baha ona pa, “Awai u Kapenaum i waawala ma to noonoli geka am meyagai ugolina una dewahi.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma i baha meme i pa, ‘A baha duma ugolimi, ega tu bahapiko gehouna a meyagai ugolina hita luhogaleya. ");
INSERT INTO tbo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tamogi moina a paliwelemi naka Elaisiya a u houga hiwape i maga duma u Isalaela. Hougana gadiwewe ega ita atatuna naka bolima tonuga ma tupona po gomala baneina tupo atapuna hi wialoni. ");
INSERT INTO tbo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tamogi Elaisiya ega ita nae hiwahiwape mi Isalaela emosi ugolihi ma i nae hiwape Salepatagei Saidoni u tupona tuawana ugolina po i haguya. ");
INSERT INTO tbo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma Elaisa a u houga lepelo lawahi hi maga duma ma ega gehouna ita luyawihi. Ma Neamana lawa Siliyagei tuawana i widewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hougana lawa geka bahahi hi noonolihi po hau numa dalabu uyogigai i wihogohi. ");
INSERT INTO tbo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma hi welutowolo po Yesu hi teina niyeya hai meyagai u uputana. Oya u tepana hai meyagai hi dewadewaya ugolina hi giyeya po ipa apo hau gubala hina dubali. ");
INSERT INTO tbo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma tamogi tipolihigei i honoga po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu i hopu po i nae Galili meyageina gehouna gowana Kapenaum ugolina po noka hosi hau dalabu lawa i wiatatiyehi. ");
INSERT INTO tbo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma hi nugogohola duma a wiatatiyana binei babana a baha hi wipoya ipa lawa hina wotagoya. ");
INSERT INTO tbo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Noka numa dalabuna u hinena lawa gehouna alugo apapoena u hinena i mamae po ponana i lata ma i otu i pa, ");
INSERT INTO tbo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‘Oo Yesu, tam Nasaletagei, awai ipa ugoliyai una dewaya? U nei ipa una uniyai, bo? A hanapugeya tam iyai. Tam Yaubada galinei Waiwoiyawam.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tamogi Yesu alugona i lahatuutuneya i pa, ‘Ega ponam ma naka lawana una hopu haleya.’ Alugona lawana i dewaya po bolu u matahi ma i guli ma i hopu haleya. Tamogi lawana ega ita wihiniwiyuwaya. ");
INSERT INTO tbo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lawa atapuhi hi gohola dumahi po tuawahi hi ibaabani hi pa, ‘Geka wiatatatiyanana awai? Matababana a taniwagagei po maninigei alugo apapoehi e taniwagehi po he laupa hopu.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Noka tuponana ugolina Yesu tuwegana i gunanohaya po tupo atapuna i waya. ");
INSERT INTO tbo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu numa dalabu i nehaleya po i nae Simona a numa ugolina. Ma Simona pohiyana wawinena i totogo. Tauna hinigugupouma baneina i waya po binei ma Yesu hi paliweleya. ");
INSERT INTO tbo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I nae po wawinena u liyaliyana i towolo ma hinigugupouma i lahaya. Ma a hinigugupouma i kokoe ma mala emosi i welutowolo po i poulehi. ");
INSERT INTO tbo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kabudala i yoliyoli ma iyawoi hai lawa ugolihi totogo galenahi tapuhi po tapuhi hi neihi mai Yesu ugolina. Atapuhi ugolihi nimana i hounihi po i luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Lawa hi maga alugo apapoehi hi luinihi naka gasi hi laupa hopu ma hi ototu hi pa, ‘Tam Yaubada Natuna.’ Ma Yesu i lahahi po ega emoemotahi hina ibaabani babana hi hanapugeya naka tauna Besinana lawana. ");
INSERT INTO tbo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yayata hau hipuli i lauhedaleya hougana Yesu noka dobuna i nehaleya po i nae meyagai ega lawa hita mimiyeya ugolina. Ma lawa hi biheya po hi tutuhagaya naka hi nugoneya po ipa ega ina nenehalehi. ");
INSERT INTO tbo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tamogi ugolihi i baha nae i pa, ‘Tau ipa tuwega dewadewana Yaubada anani taniwaga binei a lauguguya meyagai gehouhi ugolihi gasi. Matababana geka tauna binei Yaubada i himiliu po a nei.’ ");
INSERT INTO tbo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ega yaka Yudeya u tupona numa dalabuhi u hinehi i lauguguya. ");
INSERT INTO tbo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Genesaleta bogana u hadana Yesu i towotowolo ma lawa hi yamliyana gae ugolina ipa Yaubada a baha hina nonoli. ");
INSERT INTO tbo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tauna wam luwaga hi hepahi po hi mamae i galehi ma tamogi tu ebagahi amaka hi lupa hopu halehi po hai hagida hi lauoga. ");
INSERT INTO tbo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu wam gehouna i geluya naka Simona a wam ma i baha po i lududuya po hi hopu u bogei po noka hosi i tugula ma lawa i wiatatiyehi. ");
INSERT INTO tbo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma hougana baha i woohouni po Simona ugolina i baha nae i pa, ‘Wamna una woeya po ta hopu boga daodaona ugolina po ami hagida ona telenehi po ona ebaga.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Simona Yesu a baha i buiya i pa, ‘Bada, to luhilage malatom ma ega awai tota onaya. Ma am baha binei apo hagidahi to telena mehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hougana iyana a maga hi ononaya naka mei hagidahi hina gunagunalolohi. ");
INSERT INTO tbo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ega yaka hai lawa wamna gehouna ugolina hi luhapiyehi ipa hina haguhi. Hi nei po wamhi luwaga hi lihogohi po mei hina yoliyoli. ");
INSERT INTO tbo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hougana Simona Pita i gagalena po i tutunei Yesu u naona i’mtutonetonena ma i pa, ‘Una nehaleu, Guyau, babana tau tu apapoe lawau.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A baha babana tauna po a lawa iyana a maga hi ononaya hi gagaleya po, hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi natunatuna Yamesa ma Yoni Simona tu haguna tauhi gasi hi gohola dumahi. Ma Yesu Simona ugolina i baha nae i pa, ‘Ega una matomatouta. Amalai ma i wawala po i nenae apo lawa una ononahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma wamhi hi hepa geletehi hau hayahaya po ginouli atapuna hi nehaleya ma Yesu hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu meyagai gehouna ugolina ma lawa lepelo hinina i hogoya i nei ugolina. Ma hougana lawa Yesu i gagaleya po u naona i guli hopu hau hipuli ma i lupali gonugonuwa i pa, ‘Guyau, inapa nugonugom yaka una luyawahiu.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu nimana i lodomi po lawana i wodadani ma i pa, ‘Ee, nugonugou. Amaka ma una dewadewa.’ Mala emosi ma a lepelo i kokoe. ");
INSERT INTO tbo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma Yesu i baha kadidili lawana ugolina ipa ega lawa ina palipaliwelehi. Tamogi i pa, ‘Dumalu una nae po tu witalaguyaba hina galem. Ma am luyagohana binei witalaguyaba una dewaya mei Mose i bahebaheya po lawa hai ani kawamoina naka u luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tamogi Yesu tuwegana i gunanohaya po i lalata. Ma bolu hi liya mai po ipa hina lunonola po gasi hai totogo ugolihi ma ina luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tamogi i’mhoe po i nae po dobu ega lawa hita mimiyehi ugolihi i laupali. ");
INSERT INTO tbo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iyeta gehouna Yesu i iatatiyana ma Palisi lawahi gehouhi po lugagayo tanitaniwagahi hi tugutugula. Tauhi Galili po Yudeya meyageihi atapuhi po Yelusalem ugolihiyei hi nei. Ma Guyau a manini Yesu ugolina po tu tootogo ipa ina luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma lawa gehouna waigwameyameyana hau liyapa ma hi awala neiyai po hi leta ipa hina luiyeya numa u hinena po Yesu u naona hina wienoya. ");
INSERT INTO tbo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tamogi ega emoemotahi ipa tahaya hina tuhagaya po hina luiyeya babana lawa hi maga duma. Ega yaka hi awala geleteya hau gatowa po domo hi dewaya ma lawana anani enona mitehi hi houna hopuneya bolu u tipolihi Yesu u naonei. ");
INSERT INTO tbo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hougana Yesu lawahi hai witumagana i gagaleya po i baha nae lawana ugolina i pa, ‘Tulau, am apapoe amaka a paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Palisi po lugagayo tanitaniwagahi tauhi hi ibaabani hi pa, ‘Geka lawana iyai po Yaubada e palipaliguyoguyougeya? Ega emoemotana lawa awai apapoe ina paligigili ma Yaubada tuawana.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu hai winugonugotuhu amaka i hanapugeya yaka ugolihi i baha nae i pa, ‘Awai binei o inugowilawila? ");
INSERT INTO tbo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Memeka baha dewadewana ega ita ipilipili? Am apapoe a paligigili bo una towolo po una nae? ");
INSERT INTO tbo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Apo ugolimi a limoineya naka tau Lawa Moinau, wipoya Yaubada i weleu po hau hipuli apo apapoe a paligigili.’ Ega yaka i baha nae lawa wai gwameyameyana ugolina i pa, ‘A bahabaha ugolim, una towolo po am ani eno una awali ma una nae ma meyagai ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mala emosi ma lawana u matahi i welutowolo po ani eno i enenogeya i awali po Yaubada i hunehuneya ma i nae a u dobu. ");
INSERT INTO tbo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tauhi atapuhi hi gohola dumahi po matouta i wihogohi ma Yaubada hi hunehuneya hi pa, ‘Ginouli ega tota gagalehi amalai to galehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Geka dewana u mulina Yesu i hopu po i nenae po takisi tu tama gowana Libai i galeya. Tauna anani bagibagi numana ugolina i tugutugula ma Yesu i baha nae ugolina ipa, ‘Una wotagou.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Libai ginouli atapuhi i nehalehi ma Yesu i wotagoya. ");
INSERT INTO tbo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma Libai a u numa toleha baneina Yesu binei i dewaya po takisi tu tama po lawa gehouhi mitehi hi tugula am binei. ");
INSERT INTO tbo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma lugagayo tanitaniwagahi po Palisi gehouhi Yesu a hewahewali mitehi hi pilipilihi hi pa, ‘Awai binei takisi tu tama po tu apapoe mitehi o’mam po o umuma gogona?’ ");
INSERT INTO tbo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Yesu hai baha i wimiheya i pa, ‘Lawa ega hita tootogo ega tu lumulamula nugonugohi ma tu tootogo tauhi nugonugohi tu lumulamula. ");
INSERT INTO tbo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A nenei ega ipa tu dewadumalu a otugehi ma tu apapoe a otugehi po hina nugobui.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma hi baha nae ugolina hi pa, ‘Yoni a hewahewali po Palisi hai hewahewali he iyohi po aniani atapuhi ega hita ananihi po he laupali houga daodaona ma am hewahewali he’mam po he umuma.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma Yesu i’mpaliluwaluwa i pa, ‘Itapa tu tawine olotona a tawine tolehana ugolina tauna ita mamae, moina apo a toumana hita iyohi? Apega. ");
INSERT INTO tbo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tamogi iyeta he nenei apo tu tawine olotona a gawiya hina wihaleya ma noka iyetahi ugolihi apoma apo hina wiyohi.’ ");
INSERT INTO tbo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu gasi geka paliluwaluwana i paliwelehi i pa, ‘Ega iyai luilui wouna ita papaya po luilui odubona ugolina ita hilahilama lawiteya. Inapa ina dewaya yaka naka luiluina wouna amaka i wiapapoeya ma gasi kalekona henahenamina apega luiluina odubona ina linanaya. ");
INSERT INTO tbo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma gasi ega iyai wine wouna ita hiwohiwoga hopuneya talagigoila gamogamo opihiyei hi dewadewaya odubona ugolina. Inapa ina dewaya yaka apo winena wouna ina hahana po talagigoilana ina gunahaiya po wine ina kolologeya. ");
INSERT INTO tbo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Apega iyai ina dewaya. Tamogi wine wouna ipa talagigoila wouna ugolina hina hiwohiwoga hopuneya po atapuna ina dewadewa pahi. ");
INSERT INTO tbo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Apega iyai wine odubona ina umumaya po u mulina ma wine wouna ina umaya. Matababana apo ina pa, “Odubona i dewadewa.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hau dalabu Yesu a hewahewali mitehi aniani mei pegapega tanona tipolinei i nenae ma a hewahewali pegapega anohi hi’mgomugomu po u nimahi hi gohohi po hi ananihi. ");
INSERT INTO tbo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma Palisi lawahi hi baha hi pa, ‘Ata lugagayo i baheya ipa ega hau dalabu ta wobagibagi ma iyowai po geka pite o dewadewa?’ ");
INSERT INTO tbo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu hai baha i wimiheya i pa, ‘Dawita po iyawoi tauna mitehi am hi hilage ma awai i dewadewaya o hiyawi, bo eega? ");
INSERT INTO tbo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tauna i lui po Yaubada a numa u hinena palawa wailugagayona i waya po i ani ma a hewahewali i welewelehi. Tamogi ata lugagayo i baheya ipa ega iyai ina anani ma tu witalaguyaba tuawahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma i baha i pa, ‘Tau Lawa Moinau dalabu taniwagana.’ ");
INSERT INTO tbo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dalabu gehouna Yesu i lui hau numa dalabu po i iatatiyana. Ma noka hosi lawa gehouna awala hinebawana i habelu. ");
INSERT INTO tbo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Palisi po lugagayo tanitaniwagahi tahaya hi bibeiha ipa Yesu hina wigouya po hi todi ma hi gagaleya hi pa, apo lugagayo ina tulagoni po dalabugei lawana ina luyawahi, bo eega. ");
INSERT INTO tbo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tamogi Yesu hai nugotuhu amaka i hanapugehi po i baha nae tu nimahabelu ugolina i pa, ‘Una nei po lawa u matahi una towolo.’ Yaka lawana u matahi i towolo. ");
INSERT INTO tbo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma Yesu ugolihi i baha i pa, ‘Ipa a lubayademi, ata lugagayo ugolina awai i baheya ipa hau dalabu lawa tana idewadewahi bo tana iapapoenihi, bo lawa ta lauyawahihi bo ta ununihi?’ ");
INSERT INTO tbo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu i galena wiwila po atapuhi i galehi ma lawana ugolina i pa, ‘Nimam una lodomi,’ ma nimana i lodolodomi po i dewadewa meme. ");
INSERT INTO tbo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tamogi tanitaniwaga uyogigai i wihogohi po awai ipa Yesu ugolina hina dewadewaya tuawahi hi ibaabaniyeya. ");
INSERT INTO tbo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Noka hougana Yesu i gae po u oya i laupali. Ma uguwa daodaona naka Yaubada ugolina i laupali ma malitom. ");
INSERT INTO tbo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","I lauyayahi hougana Yesu tu wotagona i otugehi po u hinehi lawa magouhi 12 i winaganihi ma i wigowahi po tu wituwetuwega. ");
INSERT INTO tbo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tauhi naka Simona ma Yesu i wigowaya Pita ma walehina Andulu po Yamesa po Yoni po Pilipo po Batolomiu. ");
INSERT INTO tbo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ma Matiu po Tomasi po Yamesa Alipi natuna po Simona hi wigowaya po tu palihalena mena. ");
INSERT INTO tbo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ma Yudasa Yamesa natuna po Yudasa Isakaliyota Yesu apo ina nugohaleya. ");
INSERT INTO tbo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Oya tepanei hi hopu mai po a hewahewali boluhi mitehi hi towolo. Ma lawa bolu baneina i liyaliya mai Yudeya tupona atapuna po Yelusalem po Taya ma Saidoni niha labehi meyageihi ugolihiyei hi nei. ");
INSERT INTO tbo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hi nei ipa a baha hina nonolihi po tootogohi ina luyawahihi. Ma iyawoi alugo apapoena i iapapoenihi hi nei po hi luyagohana. ");
INSERT INTO tbo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma atapuhi hi ileta ipa hina wodadani babana ugolinei wipoya i hopu po lawa tu tootogo atapuhi i lauyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu a hewahewali i galehi ma i baha i pa, ‘Taumi tu dayadayabu a kawaidewedewemi, babana Yaubada anani taniwaga galimiyei. ");
INSERT INTO tbo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Taumi iyawoi amalai am o hilahilage a kawaidewedewemi, babana apo on’omhiyougo. Taumi iyawoi amalai o tutou a kawaidewedewemi, babana apo ona winama. ");
INSERT INTO tbo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Taumi iyawoi hougana apo lawa hina lauuyogigiyemi po hina ihinigigiyemi po hina hapohaponimi po gowami hina iapapoenihi babana tau Lawa Moinau biugei taumi tu kaohadiidiga. ");
INSERT INTO tbo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","‘Yaka omi houga witai ugolina ona kaoha po ona ilupalupa gae babana hau yada mihami apo ina lata duma. Geka pite apo lawa hina dewadewami mei googata hi dewedewehi tu bahapiko ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Ma kihoni tu nugodubu taumi waimonemi amalai, babana amaka kamnami o idewadewahi. ");
INSERT INTO tbo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kihoni tu nugodubu taumi iyawoi amalai o yamhiyougo, apo am ona hilage. Kihoni taumi tu nugodubu iyawoi amalai o inama, apo ona tou. ");
INSERT INTO tbo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kihoni taumi tu nugodubu lawa atapuhi he kawakawaidewedewemi, mei googata tu bahapiko koyakoyama hi kawakawaidewedewehi. ");
INSERT INTO tbo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Tamogi tu lunonoleu a paliwelem. Tu wigawiyemi ona luhogalehi po tu luuyogigiyemi ona dewa imahiyehi. ");
INSERT INTO tbo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Iyawoi tu paliapapoenimi ona kawaidewedewehi. Ma iyawoi tu paliguyoguyougemi ubeihi ona laupali. ");
INSERT INTO tbo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Inapa iyai nawatatam ina launi yaka nawatatam tupo gehouna una weleya po ina launi. Inapa iyai am gupouma luiluina ina waya yaka am luilui hota una palihaleya ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iyawoi ugolim he laupali atapuhi hai luhogala una welewelehi po iyai am gapola ina winihi yaka ega una tamitami mehi. ");
INSERT INTO tbo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ma awai u luhogaleya ipa lawa ugolim hina dewadewaya naka dewana emosina ugolihi una dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Inapa tu luhogalem lawahi tuawahi una lauhogalehi yaka naka apo a dewadewa awai tam ugolim? Matababana tu apapoe lawahi gasi tu luhogalehi he lauhogalehi. ");
INSERT INTO tbo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma inapa tu dewa imahiyem tuawahi una dewadewa imahiyehi yaka naka apo a dewadewa awai tam ugolim? Matababana tu apapoe lawahi naka dewana he dewedeweya. ");
INSERT INTO tbo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma inapa iyawoi am ginouli apo hina laidumaluhi tuawahi ugolihi una welewelehi yaka naka apo a dewadewa awai tam ugolim? Matababana tu apapoe lawahi hai lawa ugolihi he lauguta babana apo hai ginouli latana emoemotana hina lidumalu meya. ");
INSERT INTO tbo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tamogi tu wigawiyemi ona luhogalehi po ona dewa imahiyehi. Ma ona luguta po ega wimihana ona nugonugotuhuya. Ugolinei ami meiha apo ina lata duma po taumi apo Yaubada Gegewahagana natunatuna. Matababana lawa yabayababa po tu’mboho ugolihi i lunugodewadewa. ");
INSERT INTO tbo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Taumi ona lunugotootogo po mei Amami e launugotootogo. ");
INSERT INTO tbo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Ega lawa gehouhi ona laibahibahihi meka po apo Yaubada ina libahibahimi. Ma ega lawa gehouhi ona igouhi babana apo Yaubada ina wigoumi. Lawa geha hai apapoe ugolimi ona winugoguluwihi po apo Yaubada ami apapoe ina winugoguluwihi. ");
INSERT INTO tbo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","On’ambenena yaka apo Yaubada in’ombenena ugolimi. Awai hogohogona po i lautepanena meya apo ina woliligeya u alomi. Matababana ginouli a lata awai u yambeneneya apo una tuhaga meya.’ ");
INSERT INTO tbo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma gasi Yesu geka paliluwaluwana i paliwelehi i pa, ‘Lawa matana keekena apega tu matakeke tulana ina weluwaya. Inapa ina weluwaya yaka apo hau domo hina peu gogona. ");
INSERT INTO tbo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tu lunonola a tu wiatatiyana apega ina gelagoni. Tamogi tu wisikuluna houga awai a sikulu ina wikokowi tauna apo mei a tu wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘Awai binei walehim u matana dubudubu e gagaleya ma tam u matam mayau tipolina ega uta genogeya? ");
INSERT INTO tbo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Apo iyowai walehimna ugolina una baha nae una pa, “Walehiu, una nei po u matam dubudubu a wihaleya,” inapa tam u matam mayau tipolina ega una galeya? Tam tu wikoyakoyama. U matam mayouna tipolina una wihalena tahaeya po una galena imahi ma apoma walehim u matana dubudubu una wihaleya. ");
INSERT INTO tbo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Mayau dewadewana apega ugona kakai ina houni. Ma kakai mayouna apega ugona dewadewana ina houni. ");
INSERT INTO tbo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Matababana mayau atapuhi hai ugo ugolihiyei ma ta gagalena tuhagahi. Apega sitaniya u toyana kiyaha ugona una lohi po apega gologolowa gowana wine ugona donadona u toyana una lohi. ");
INSERT INTO tbo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lawa dewadewana u nugonugona ginouli dewadewahi he mamae apo ina hauhopunehi. Ma lawa apapoena u nugonugona ginouli apapoehi he mamae apo ina hauhopunehi. Matababana lawa nugonugona awai i wihogoya po e mamae apo gamonei ina baheya. ");
INSERT INTO tbo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘Awai binei o pa, “Guyau, Guyau,” ma awai a palipaliwelemi ega ota wootagohi. ");
INSERT INTO tbo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iyai ina nei ugoliu po u baha ina nonolihi ma ina dewa tagohi apo a wogeleteya ugolimi tauna galenana mei iyai. ");
INSERT INTO tbo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tauna mei tu lunuma. I ludomo hopu po dobu waigaigaimana ugolina a ogola i pati tatahi po hougana goila i hopuhopu po numana i launi. Tamogi ega ita guhuya babana i wogo imahiyeya. ");
INSERT INTO tbo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma iyai u baha ina nonolihi ma ega ina dewa tagohi, tauna mei lawa numa i wogowogoya po ega ogola ita pati tatahi. Hougana goila i hopu po numana i laulauni naka mala emosi ma i guli po i laugolutena haleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu geka bahahi atapuhi i ibaabaniyehi lawa ugolihi po i kokoe ma i nae u Kapenaum. ");
INSERT INTO tbo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Noka hosi mi Loma hai tu wigawiya tu galena itetehi a tu bagibagi upuna hegohegoyana i totogo po mei ina hilahilage. ");
INSERT INTO tbo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hougana lawana Yesu noyana i noonoli po mi Yudeya hai tanitaniwaga i himilihi, ipa hina nae po Yesu hina baha po ina nei po tu bagibagina ina luyawahi. ");
INSERT INTO tbo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tu tahayahi hi nae po Yesu ugolina hi bahabaha gonugonuwa i pa, ‘Geka lawana to bahebaheya a dumalu ipa una haguya. ");
INSERT INTO tbo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Matababana tauta mi Yudeya i luhogaleta po ata numa dalabu i witowoli.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ega yaka Yesu mitehi hi nae. Hougana hi nae po tu galena itetena a numa hi tutuliyaliyani ma tu galena itetena a lawa i himilihi po hi nei Yesu ugolina ipa a baha hina paliweleya. A bahana geka pite i pa, ‘Guyau, ega una laigeno mem, babana tau ega u dewadewa awai ipa a winim po una lui mai u numa u hinena. ");
INSERT INTO tbo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Geka binei ma tau ega ata nehi ugolim. Tamogi baha awa una baheya po apo u hewali ina luyagohana. ");
INSERT INTO tbo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Babana tau gasi tanitaniwaga hai tu bagibagi taniwagana po tu wigawiya u nimau hi hounihi po a gagalena itetehi. Ma apo tu wigawiya emosi ugolina ana pa, “Una nae,” ma e nae. Ma apo gehouna ugolina ana pa, “Una nei,” ma e nei. Ma apo u tu bagibagi ugolina ana pa, “Geka una dewaya,” ma e dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hougana geka bahahi Yesu i noonolihi po i goholi ma i luhagawileya po bolu hi imulitagoya ugolihi i baha nae i pa, ‘A paliwelemi, yohola mi Isalaela u hinemi ega lawa awai a witumagana ata galeya po mei geka lawana.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lawana a hewahewali hi gunawilehi po hi nenae tu galena itetena a u numa po tu bagibagina a kamna dewadewana hi tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Geka dewana u mulina Yesu i’mhoe po i nenae meyagai gowana Naina ugolina naka a hewahewali po bolu mitehi hi nae. ");
INSERT INTO tbo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Meyageina matetana i tutuliyaliyani ma popoya hi awali po hi hopuhopu mai. Popoyana naka keduluma hiwahiwapena natuna amaka emosi hotana olotona. Ma lawa meyaginei boluhi hi wotago po tauna mitehi. ");
INSERT INTO tbo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Guyau hougana hiwapena i gagaleya po nugonugona i wiyuweya ma i baha nae ugolina i pa, ‘Ega una tutou.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ma apoma i nae po halawina i wodadani po tu wikeyauga hi tutowolo ma i baha i pa, ‘U hewali ugolim a bahabaha, una towolo.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma popoyana i welutowolo po i tugudu po i ibaabani ma apoma Yesu wawinena natuna u nimana i palihaleya. ");
INSERT INTO tbo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Matouta lawa atapuhi nugonugohi i hogoya po Yaubada hi wootalagiyeya hi pa, ‘U hayata tu bahapiko gegena i lugeleteya,’ po gasi hi pa, ‘Yaubada a lawa i tudadanita ipa ina haguta.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma Yesu tuweganana i gunanohaya po Yudeya tuponana atapuna po meyagai Yudeya u liyaliyana hi nonoli. ");
INSERT INTO tbo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoni a hewahewali geka ginoulihi atapuhi tauna hi paliweleya. ");
INSERT INTO tbo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ega yaka a hewahewali luwaga i otugehi po i himilihi po hi nae Guyau ugolina po ipa hina pa, ‘Tam iyai? Tu wiluyagohana bimgei to iotonana ipa apo una nenei, bo ega tam ma lawa gehouna to ototonaneya?’ ");
INSERT INTO tbo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma hi nae po hougana Yesu ugolina hi laugeleta po hi baha hi pa, ‘Yoni bapatiso i himiliyai ipa to lubayadem. Moina tam i bahebahem ipa apo una nenei bo ega tam ma lawa gehouna to ototoni?’ ");
INSERT INTO tbo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Noka kabudalana ugolina lawa hai totogo po hai hilitani i wihalehi. Ma gasi lawa alugo apapoehi u hinehi i wiyagahi po tu matakeke i luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ma hai baha i wimiheya i pa, ‘Awai o gagalehi po o noonolihi ona gunawilemi po Yoni ona paliweleya. Tu matakeke he gagalena imahi po tu aeapapoe he neneimahi po lepelo lawahi he wodewadewa meme po tu tanigapupu he launonola po lawa hau hilage ma he towotowolo meme po tu dayadayabu tuwega dewadewana he noonoli. ");
INSERT INTO tbo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iyai ega ita inugomagomagougeu tauna a kawaidewedeweya.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoni a baha tu hihiwa hougana hi’mhoe po hi nenae ma Yesu i wiwawala po bolu ugolihi i ipaliwelena Yoni binei i pa, ‘Hougana o nenae hau balabala yabayababa Yoni ugolina ami nugotuhu ipa awai ona galeya? Ega togowa didiyala ita kwadikwadiyeya ma ota galeya. ");
INSERT INTO tbo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma ami nugotuhu ipa awai ona galeya? Ega ipa lawa a wihiya gegena, bo? Babana lawa noka pite hai wihiya po hai wigapola naka tauhi wasawasa hai u numa he tugutugula. ");
INSERT INTO tbo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ona paliweleu awai ipa ona galeya? Tu bahapiko, bo? Moina tauna tu bahapiko tamogi tu bahapiko atapuhi i gelagonihi. ");
INSERT INTO tbo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Matababana Yaubada a Buka ugolina tauna ubeina hi baha hi pa, “Una galeya, u tu winoyanoya apo a himila tahaeyem po am tahaya ina wononogogeya.” ");
INSERT INTO tbo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A paliwelemi, ega meka lawa hita guni po a gae mei Yoni. Tamogi Yaubada anani taniwaga ugolina lawa muhomuhohi tauhi hi geduma ma apoma Yoni.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Hougana lawa tapuhi po takisi tu tama geka bahahi hi noonolihi po Yaubada a tahaya hi kawamoineya. Naka tauhi lolowa Yoni i bapatisohi. ");
INSERT INTO tbo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tamogi Palisi lawahi po lugagayo tanitaniwagahi Yaubada a nugotuhu ubeihi hi wihinigigiyeya, po tauhi Yoni ega ita wibapatisohi.) ");
INSERT INTO tbo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu i baha i pa, ‘Lawa geka hapanana apo awai ugolina a wiluweluwena niyehi po galenahi awai? ");
INSERT INTO tbo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tauhi mei logaloga ani gimala meyageina ugolina he tugula ma he yampalidamadamana he pa, “Ubeimi to lauinainaga ma ega ota hala. Ma to tutou ma ega ota tou haguiyai.” ");
INSERT INTO tbo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ma Yoni bapatiso i nenei naka a omhilagena po ega wine ita umaya ma o ibaabani o pa, “Tauna alugo apapoena u hinena.” ");
INSERT INTO tbo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tau Lawa Moinau a nenei a omniu po a umau ma o pa, “Geka lawana ona galeya, tauna tu’mlabatana po tu uma buuwa po a lawa takisi tu tama po tu apapoe.” ");
INSERT INTO tbo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tamogi Yaubada a hanapu iyawoi ugolihi apo hina baheya naka hanapu moinana.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisi gehouna gowana Simona Yesu i igigimeya po ipa mitehi hina am. Yaka i lui Simona a u numa po hau ani am i tugula. ");
INSERT INTO tbo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma noka u meyageina tu apapoe wawinena gehouna i mamae. Tauna Yesu tuwegana i nonoli naka Simona a u numa i’mam. Ega yaka wedu gaimei hi dewadewaya u hinena wakatu dimudimumuna i awali po i nei. ");
INSERT INTO tbo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma i nae po Yesu u mulina i towolo, aena u liyaliyana ma i tutou naka matadiligwegwena Yesu aena i lainigi. Apoma apalanei Yesu aena i hamagi po aenana i yagoni ma ugolina wakatu dimudimumuna i howogi. ");
INSERT INTO tbo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma Simona i gagaleya po tuawana u nugonugona i pa, ‘Itapa geka lawana tu bahapiko apo geka wawinena a luyagohana galenana waiigohina apo ita hanapugeya. Ma tauna Yesu e wodadani po apo ita hanapugeya naka wawinena wawine apapoena.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Yesu Simona a winugonugotuhu i wimiheya i pa, ‘Simona, ginouli gehouna ugolim ipa a baheya.’ Ma Simona i pa, ‘Bada, ginouli awai?’ ");
INSERT INTO tbo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma Yesu i pa, ‘Lawa gehouna ugolina lawa luwaga mone hi tama yageya. Lawa emosi a yaga naka 5 kina ma gehouna a yaga 50 kina. ");
INSERT INTO tbo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hai yagahi ega emoemotahi ipa hina lidumaluhi yaka lawana i kawahawenehi. Ma geka hai luwagahi naka apo iyai tulahina ina luhogalena dumaya?’ ");
INSERT INTO tbo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma Simona a baha i wimiheya i pa, ‘Nugote lawana a yaga baneina apo tulahina ina luhogalena dumaya.’ Ma Yesu i pa, ‘Naka u baha moina.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Apoma i luhagawileya wawinena ugolina ma Simona ugolina i baha nae i pa, ‘Geka wawinena u galeya. A geletai am u numa po ega aeu goilana uta weleu ma tauna matadiligwegwenei aeu i linigi ma apalanei i hamagi. ");
INSERT INTO tbo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tam ega niuwe uta yagoni ma tauna a gelegeletai naka aeu i yagoyagoni ma i nei po geka. ");
INSERT INTO tbo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ega wakatugei apalau uta wololoya ma tauna wakatu dimudimumunei aeu i wololoya. ");
INSERT INTO tbo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ugolinei ma a paliwelem naka a apapoe magomagouhi amaka a paligigilihi. Matababana a luhogala i lata duma. Ma iyai a paligigila ina habulu ugolinei a luhogala i habulu.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Apoma wawinena ugolina Yesu i baha i pa, ‘Am apapoe a paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma iyawoi tauna mitehi hau ani am hi tugutugula tuawahi hi ibaabani hi pa, ‘Geka iyai tauna, po apapoe e palipaligigilihi?’ ");
INSERT INTO tbo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Yesu wawinena ugolina i baha nae i pa, ‘A nugodumolam una nae, am witumagana i wiluyagohanim.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Geka u mulina Yesu i kadau po i nae meyagai baneihi po habuluhi Yaubada anani taniwaga tuwegana dewadewana i guuguyeya. Ma a hewahewali magouhi 12 tauna mitehi hi nae. ");
INSERT INTO tbo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ma gasi wiwine gehouhi hai hilitani po alugo apapoehi ugolihi ma lolowa i lauyawahihi mitehi hi nae. Geka wiwinehi naka Maliya (gowana gehouna Magadala) tauna ugolina alugo apapoehi magouhi 7 i wiyagahi. ");
INSERT INTO tbo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma Heloda a tu poula gowana Kusa ma agona gowana Yowana Yesu i wotagoya. Ma Susana ma gasi wiwine gehouhi. Tauhi hai gapolagei Yesu a hewahewali mitehi hi haguhi. ");
INSERT INTO tbo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lawa meyagai emosi po emosi ugolihiyei hi liyaliya nae po hougana bolu baneina hi yamtuboina naka Yesu geka paliluwaluwana i baheya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","‘Tu lupehi i nae a tano ugolina po a pehi polahi i nohanohahi. I nohahi po i nenae naka gehouhi hau tahaya hi peu po lawa hi tutanihi po kiu hi anihi. ");
INSERT INTO tbo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ma gehouhi dobu waigaigaimana ugolina hi peu po hougana hi lahalahahi naka kabudala i lalana unihi, babana hipulina ega ita niginigi. ");
INSERT INTO tbo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma pola gehouhi hiyamoni waidonadonana u hayahi hi peu po hougana hi lahalahahi naka donadona i numa panipani unihi. ");
INSERT INTO tbo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma pola gehouhi hipuli dewadewana ugolina hi peu po hi lata po hi ugo. Hai houga ugo naka hi ugo duma.’ Apoma Yesu i pa, ‘Taumi iyawoi waitanigami yaka ona launonola.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Geka ompaliluwaluwana anona awai binei Yesu a hewahewali hi lubayadeya. ");
INSERT INTO tbo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma Yesu i pa, ‘Yaubada anani taniwaga hanapuna gowagowadana taumi ugolimi amaka i lugeleteya. Ma gehouhi ompaliluwaluwagei apo a bahabaha nae ugolihi. “Ma apo hina ihalu ma apega hina galena tuhaga po apo hina launonola ma apega hina hanapugeya.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu i baha i pa, ‘Geka ompaliluwaluwana anona. Pola anona naka Yaubada a baha. ");
INSERT INTO tbo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pola hau tahaya hi pipeu naka iyawoi amaka Yaubada a baha hi nonoli ma Tomodulele i nei po bahana u nugonugohi i wihaleya. Ma naka tauhi apega hina witumagana po hina luyagohana. ");
INSERT INTO tbo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pola dobu waigaigaimana ugolina hi pipeu anona naka iyawoi amaka anai kaohahi Yaubada a baha hi nonoli, tamogi ega dedehi ugolinei ma he itumagana po ega daona ma hai ludadana kabudalana ina geleta naka amaka he peu. ");
INSERT INTO tbo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hiyamoni waidonadonahi u hayahi pola hi pipeu anona naka iyawoi amaka Yaubada a baha hi nonoli, ma tamogi winugopilipili po wigapola po ani kaoha gehouhi he lui mai hai luyagohana ugolihi po e panihi po ugohi ega hita gugou. ");
INSERT INTO tbo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pola hipuli dewadewana ugolina hi pipeu naka anona iyawoi amaka Yaubada a baha hi nonoli po nugonugohi moinahi po dumadumaluhi ugolihi hi houna emotehi. Ma hai upuhegoyagei apo hina ugo.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu i baha i pa, ‘Ega iyai lampa ita apuya ma gaebagei ita lautataya bo ani eno u gaboulina ita huhouni, tamogi anani tugula ugolina e houni po lawa he luilui apo yayatana hina galeya. ");
INSERT INTO tbo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","18","Awai gowagowadana apo ina wihabuhabuna po lawa hina nonoli. Ma awai gowagowadana apo hina tuhagaya po hina neiyai hau yayata po lawa hina galeya. Iyowai o lautanigana ipa ona gagalena imahi. Matababana iyai ugolina awai dewadewana e mamae apo Yaubada ina luwitani tauna ugolina. Ma iyai ugolina eega, ma a nugotuhu ipa awai habuluna e mamae apo Yaubada ina wihaleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu hinana po walewalehina hi nae ugolina tamogi ega hita geleta babana bolu i lata duma. ");
INSERT INTO tbo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma lawa gehouna Yesu i paliweleya i pa, ‘Hinam po walewalehim u uputa ma hai luhogala ipa hina galem.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tamogi Yesu lawa atapuhi ugolihi i baha i pa, ‘Hinau po walewalehiu naka tauhi Yaubada a baha hi nonoli po he iponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iyeta gehouna Yesu a hewahewali ugolihi i baha i pa, ‘Ta damana po ta nae geka bogana u tupona.’ Ega yaka hi gelu hopu ");
INSERT INTO tbo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","po hi’mkuka po hi nenae ma Yesu i eno. Ma togowa baneina bogana i launi po hai wam i higuya po mei hina yoliyoli. ");
INSERT INTO tbo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesu a hewahewali hi nei po hi limaamahi po i towolo ma hi pa, ‘Bada, Bada, ega daona ma apo ta hilage.’ Yesu i welutowolo po togowa ma boga anai guligulina i lahahi po hi todi ma noka hougana dumola baneina. ");
INSERT INTO tbo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Apoma a hewahewali ugolihi i baha i pa, ‘Meka ami witumagana o hounihi?’ Ma tauhi hi goholihi po tuawahi hi yamhuna hi pa, ‘Geka lawana iyai po e baha nae togowa po boga ugolihi ma he iponawogogeya?’ ");
INSERT INTO tbo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galili bogana u tuponei dobu gowana Gelasene ugolina hi lugeleta. ");
INSERT INTO tbo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hougana Yesu i hauhopu hau hipuli naka lawa noka meyageinei alugo apapoehi hi luiluiya tauna ma Yesu hi witutuhaga. Houga i dao ega kaleko ita oteni po ega hau numa ita mamae ma hau kokowaga i mamae. ");
INSERT INTO tbo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hougana Yesu i gagaleya po i wootu ma u aena i guli hopu po ponana i lata ma i pa, ‘Yesu, Yaubada Gegewahagana Natuna tam. Awai ipa ugoliu una dewaya? A laupali gonugonuwa ega una ihiniwiyuwau.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Geka bahana i bahebaheya babana Yesu i baha ipa alugo apapoena lawana ina hopu haleya. Houga magomagouna hinina hi luiluiya po hawena hau numa panipani gulawa pawasigei he panipani ma apo ina lautuiya ma alugona e weluwaya po e niyeya hau balabala yabayababa. ");
INSERT INTO tbo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Apoma Yesu lawana i lubayadeya i pa, ‘Gowam iyai?’ Ma tauna i pa, ‘Boluiyai,’ babana alugo apapoehi boluhi tauna u hinena hi lui. ");
INSERT INTO tbo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Alugohi apapoehi Yesu hi lupaliyeya po ipa ega ina himihimilihi domo daodaona u hinena. ");
INSERT INTO tbo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma polo boluhi oya u hadana hi banibani, Yesu u liyaliyana. Alugohi hi lupali gonugonuwa ipa ina palihalehi po polohi ugolihi hina lui. Ega yaka Yesu i palihalehi. ");
INSERT INTO tbo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Apoma alugo apapoehi lawana hi hopu haleya po polohi hi luinihi. Ma polohi oyana yapanei hi haha hopu po bogana ugolina hi halele. ");
INSERT INTO tbo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Polohi tu galena itetehi awai hi gagaleya po hi lowo po hi nae dobu baneina po pitapita tu miyehi ugolihi hi wibenabenama awai hi gelegeleta. ");
INSERT INTO tbo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Apoma lawa hi hopu po hi nae ipa awai i waawala hina galeya po Yesu ugolina hi geleta. Ma lawana alugo apapoehi hi nenehaleya naka hi tuhagaya Yesu aena u labena i tugutugula. Tauna i lukaleko po nugonugona a dumadumaluna ma hi gagaleya po hi matouta. ");
INSERT INTO tbo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma iyawoi geka dewana hi gagaleya naka lawa hi paliwelehi iyowai Yesu lawana i lauyawahi. ");
INSERT INTO tbo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gelasene u tupona meyagai habuluhi lawahi Yesu hi lupaliyeya ipa ina nehalehi. Matababana matouta nugonugohi i wihogoya po ega yaka Yesu hau wam i gelu po i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lawana alugo apapoehi hi hopuhopu haleya i baha gonugonuwa Yesu ugolina i pa, ‘Una baha po tam ma tau ta nae.’ Ma Yesu i wihinigigiyeya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","‘Una gunawilem am meyagai ugolina po awai Yaubada i dewadewaya ugolim lawa una paliwelehi.’ Yaka lawana i’mhoe po i nenae naka Yesu awai i dewadewaya tauna ugolina lawa i palipaliwelehi ma dobu baneina i yayahi po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hougana Yesu i gunagunawileya bogana u tupona naka lawa boluhi hi kaoheya babana tauna hi ototoni. ");
INSERT INTO tbo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Apoma numa dalabu tu galena itete gowana Yailo i lugeleta. I nae po Yesu u aena i polou ma i lupali gonugonuwa ipa mitehi hina nae a u numa. ");
INSERT INTO tbo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Matababana natuna wawinena emosi hotana a bolima magouhi 12 i totogo duma po mei ina hilahilage. Hougana i’mhoe po hi nenae naka lawa hi yamliyana gae po hi meme wiwileya. ");
INSERT INTO tbo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma noka boluna u hayana wawine gehouna tootogona. Tauna a totogo naka tala i kolokololo bolima magouhi 12, ma ega iyai ita luyawahi. ");
INSERT INTO tbo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wawinena bolu hinehiyei i gae po Yesu u upuna ma a kaleko hadana i wodadani po mala emosi ma a talakololo i wohouna. ");
INSERT INTO tbo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma Yesu i pa, ‘Iyai i wodadaniu?’ Lawa atapuhi hi bowi ma Pita i pa, ‘Bada, bolu hi mewiwilem po he tutugehi ugolim.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Yesu i pa, ‘Lawa gehouna i wodadaniu babana u hiniu manini i hopuhopu ma mayana a waya.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wawinena i hanapugeya naka amaka hi tuhagaya yaka i taatawa ma i gae po Yesu u aena i polou hopu. Ma bolu u matahi i bahena geleteya awai binei Yesu i wodadani po iyowai ma mala emosi ma i lauyagohana. ");
INSERT INTO tbo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu wawinena ugolina i baha nae i pa, ‘Natuwe, am witumagana i wiluyagohanim, a nugodumolam una nae.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu yohola geka bahana i bahebaheya ma Yailo a numagei lawa gehouna i nei po Yailona ugolina i baha i pa, ‘Natum amaka i hilage ma ata Tu wiatatiyana ega una laigeno gawahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tamogi Yesu bahana i nonoli po Yailo ugolina i baha i pa, ‘Ega una matomatouta, tamogi una witumagana ma apo ina luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hougana Yesu numana ugolina i laugeleta naka lawa atapuhi i talagagalihi po ega tauna mitehi hita lui. Ma Pita po Yoni po Yamesa po tewelana hinana po amana tuawahi mitehi hi lui. ");
INSERT INTO tbo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lawa atapuhi noka hosi tewelana hi tutougeya po hi lauhiyaweya. Ma Yesu i baha i pa, ‘Ega ona tutou, babana tewelana ega ita hilage ma e eneno hota!’ ");
INSERT INTO tbo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Geka bahana ugolina ma lawa atapuhi hi winameya babana hi hanapugeya tewelana i hilage. ");
INSERT INTO tbo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tamogi Yesu tewelana u nimana i wogo ma i otu i pa, ‘Tewela, una towolo!’ ");
INSERT INTO tbo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tewelana alugona i gunawilena meya po mala emosi ma i welutowolo. Ma Yesu i baha i pa, ‘Aniani ona weleya po ina am.’ ");
INSERT INTO tbo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma hinana po amana hi gohola dumahi. Tamogi Yesu i baha kadidili ipa awai i waawala ega iyai hina palipaliweleya. ");
INSERT INTO tbo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu a hewahewali magouhi 12 i otugehi po hi’mtuboina. Ma kadidili po manini i welehi po apo alugo apapoehi lawa ugolihi hina iyagahi po tu tootogo hina lauyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Apoma i himilihi po hi nae ipa Yaubada anani taniwaga hina guguyeya po tu tootogo hina luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma ugolihi i baha nae i pa, ‘Ega awai ona wiwaya ami kadau ubeina. Ega digona po ega poha po ega aniani po ega mone po gasi ega luilui wiluwagana ona wiwaya. ");
INSERT INTO tbo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Meka hina kaohemi yaka naka numana emosina ugolina ona mamae a sigana naka meyageina ona nehaleya. ");
INSERT INTO tbo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Meka lawa ega hina kaohemi yaka naka meyagaina ona nehaleya. Ma ona nenae hougana aemi dubudubuna ona lihooholi po ani galena u matahi ona dewaya po hai dewa apapoehi hina hanapugehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Apoma a hewahewalihi hi’mhoe po meyagai muhomuhohi hi yayahihi po hi nae. Tuwega dewadewana hi guuguyeya po lawa hi lauyawata niyehi. ");
INSERT INTO tbo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tupo Galili tu galena itetena gowana Heloda ginouli atapuhi hi waawala naka tuwegahi i nonolihi. Ma tauna nugonugona i wipilipili babana lawa gehouhi hi pa Yoni bapatiso hau hilage i towolo. ");
INSERT INTO tbo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lawa gehouhi hi pa, Elaisiya lawa odubona i lugeleteya ma gehouhi hi pa tu bahapiko gehouna odubona i luyagohana meme. ");
INSERT INTO tbo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heloda i pa, ‘A baha po Yoni unununa hi boli haleya ma geka lawana tuwegana a noonoli naka iyai?’ Ma tauna i ileta gawata ipa Yesu ina galeya. ");
INSERT INTO tbo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tu wituwetuwega hai gunawilana ugolina awai atapuhi hi dewadewahi Yesu hi paliweleya. Ma i weluwinihi po tuawahi hi meliya po hi nae meyagai baneina gowana Besaida u liyaliyana. ");
INSERT INTO tbo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hougana lawahi boluhi geka nugotuhuna hi hanapugeya po hi wotagoya. Ma tauna i kaohehi po ugolihi Yaubada anani taniwaga i guguyeya, po tu tootogo kamana dewadewa hi lauhogaleya i luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hougana kabudala i yoliyoli ma a hewahewali magouhi 12 hi nei ugolina po hi pa, ‘Lawahi una himilihi po hina nae meyagai muhomuhohi po tano ugolihi geka tuponana ugolina. Tauhi apo aniani po ani eno hina beiha babana geka dobuna ega lawa hita mimiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma Yesu i baha nae ugolihi i pa, ‘Taumi aniani ona welehi po hina am.’ Tauhi a baha hi wimiheya hi pa, ‘I am ega ita lata palawa magouna nimitutu ma iyana luwaga hota. Nugonugom to nae po bolu geka ubeihi aniani to gimala?’ ");
INSERT INTO tbo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Matababana ololoto nugote tausana nimitutu noka hosi.) Ma tauna a hewahewali ugolihi i pa, ‘Lawa ona baha po bolugei hina tugula po ina nae. Bolu emosi po emosi u hinehi naka lawa magouhi 50.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A hewahewali hi wiponawogo po lawa atapuhi hi witugula pahihi. ");
INSERT INTO tbo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu palawahi nimitutu ma iyanahi luwaga i winihi po i galena gae hau yada ma Yaubada ugolina i wimaamala. Ma i’mtomutomu po i kokoe ma a hewahewali i welehi po hi gutaya bolu ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma atapuhi hi am po hi’mhiyougo. Ma Yesu a hewahewali omtelena hi tutuwaluhi naka poha magouhi 12. ");
INSERT INTO tbo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hougana Yesu tuawana i laupali ma a hewahewali hi nei ugolina po i lubayadehi i pa, ‘Lawa hai nugotuhu hi pa tau iyai?’ ");
INSERT INTO tbo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma tauhi hi pa, ‘Lawa gehouhi hi pa tam Yoni bapatiso, ma gehouhi hi pa tam Elaisiya lawa odubona po gehouhi hi pa tam tu bahapiko odubona u towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Apoma a hewahewali ugolihi i baha nae i pa, ‘Ma taumi ami winugonugotuhu o pa tau iyai?’ Ma Pita a baha i wimiheya i pa, ‘Tam Yaubada a Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ma Yesu a hewahewali i talagagalihi ipa ega iyai hina palipaliweleya. ");
INSERT INTO tbo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Apoma i baha meme i pa, ‘Apo Lawa Moinau wiyuwa galenahi magomagouhi a wialonihi. Apo mi Yudeya hai tanitaniwaga po tu witalaguyaba babadahi po lugagayo tanitaniwagahi hina wihinigigiyeu. Ma apo hina uniu po iyeta witonugana u mulina a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma i baha a hewahewali ugolihi i pa, ‘Inapa lawa awai nugonugona ina wotagou yaka a luyagohana ina palihaleya. Ma anani take iyeta emosi po emosi ina awali ma ina wotagou. ");
INSERT INTO tbo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Apo iyawoi yautuhi hi nugonehi yaka apo yautuhi hina halehi. Ma iyawoi tau biugei hina hilage apega yautuhi hina halehi. ");
INSERT INTO tbo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Inapa iyai ina wigapola duma yaka Yaubada a dewa apo ina winugoguluwi naka apo awai dewadewana ina tuhagaya? ");
INSERT INTO tbo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Apo lawa awai tau ma gasi u baha ubeihi ina ihinimaeya yaka tau Lawa Moinau u houga nei ugolina apo tauna a wihinimaya. Hougana a nenei tau ma Amau po a tu winoyanoya waiwoiyawahi hai wasawasa namanamalinei. ");
INSERT INTO tbo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tamogi a baha duma ugolimi, lawa gehoumi geka hosi o towotowolo apega ona hilage a sigana Yaubada a taniwaga ona galeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bahahi geka Yesu i bahehi po hi kokoe, ma iyeta magouhi 8 u mulihi, Pita ma Yoni ma Yamesa i winihi po tauna mitehi hi gae u oya hi lupali. ");
INSERT INTO tbo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hougana Yesu i laupali ma galenana i gunabuiya po a luilui i wakewakeke po i namanamali. ");
INSERT INTO tbo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma mala emosi ma babada odubohi luwaga hi lugeletehi po tauna mitehi hi ibaabani. Babadahi naka Mose ma Elaisiya. ");
INSERT INTO tbo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tauhi a namanamalihi ma hi lugeletehi po Yesu mitehi hi ibaabani iyowai apo u Yelusalem Yesu ina hilage Yaubada a nugotuhu limoinana binei. ");
INSERT INTO tbo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita a lawa mitehi hi eno hilage ma tamogi hi eno towolo. Ma Yesu a wiwasawasa po babadahi luwaga Yesu mitehi hi towotowolo gasi hi galehi. ");
INSERT INTO tbo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hougana babadahi Yesu hi nenehaleya ma Pita i baha Yesu ugolina i pa, ‘Bada, i haki duma po tiyai geka hosi. Apo kape tonuga to wogohi, emosi tam bimgei ma emosi Mose binei ma emosi Elaisiya binei.’ Awai Pita i bahebaheya naka i bahena yababaya. ");
INSERT INTO tbo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita yohola i ibaabani ma gahu i hopu mai po i lutatahi. Ma gahuna i lautatahi naka Yesu a hewahewali hi matouta duma. ");
INSERT INTO tbo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gahuna ugolinei pona geka pite hi nonoli i pa, ‘Natuwe geka tauna a inagani, tauna ona iponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hougana pona i kookoe po Yesu tuawana i towotowolo. A hewahewalihi ega ponahi po awai hi gagalehi ega iyai hita paliweleya noka iyetahi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Malitom po Yesu a hewahewalihi tonuga mitehi u oyana hi mamae hi hopu po hi nae. Ma lawa boluna baneina i’mboina mai Yesu ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lawa gehouna boluna u hinena i otu i pa, ‘Bada, a lupaliyem ipa natuwe emosi hotana olotona una galeya. ");
INSERT INTO tbo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tauna alugo apapoena e geluya po mala emosi ma e tapeiotuya po e ilougo nae po gamonei pulopulo he hopuhopu. Ma houga daodaona e ihiniwiyuwaya ma ega ita nenehaleya. ");
INSERT INTO tbo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma am hewahewali a lupaliyehi ipa hina widewadewaya po ega emoemotahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu lawana a baha i wimihena niyeya i pa, ‘Taumi geka hapanana ega ami witumagana po apapoe lawami. Houga a dao awai apo a meme liyaliyanimi po a genogenogemi?’ Apoma lawana ugolina i pa, ‘Natumna una neiyai ugoliu.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tewelana i nenei ma alugona tewelana i tapedubali po hau hipuli i taatawa nae. Tamogi Yesu alugona i baha po i nae ma tewelana i luyawahi po i kokoe ma amana u nimana i houni. ");
INSERT INTO tbo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lawa atapuhi Yaubada a wipoya ugolina hi’mhuna duma. Ginouli atapuhi Yesu i dewadewahi naka yohola hi hunehuneya ma a hewahewali ugolihi i baha i pa, ");
INSERT INTO tbo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","‘Geka bahahi apo a bahebahehi ega ona inugoguluwihi. Lawa Moinau apo hina houna damaneu lawa u nimahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tamogi a hewahewali geka bahana ega anona hita hanapugeya. Tauhi ugolihi geka bahana anona i lugowadeya po ega hita hanapugeya. Geka binei ipa Yesu hina lubayadeya ma hi matouta. ");
INSERT INTO tbo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu a hewahewali u hayahi wigamogahigahi i wawala. Hai wigamogahigahina a wawala babana hi pa u hayahi iyai i geduma. ");
INSERT INTO tbo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu hai winugonugotuhu amaka i hanapugeya yaka tewela i waya po u liyaliyana i witowoli. ");
INSERT INTO tbo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma i baha nae ugolihi i pa, ‘Iyai gowaugei geka tewelana ina lunugotootogogeya yaka tau i lunugotootogogeu. Ma iyai ina kaoheu yaka ega tau tuawau tu himiliu gasi i kaoheya. Matababana iyai u hayami i hopu duma naka tauna i geduma.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoni ponana i lata ma i pa, ‘Bada, lawa gehouna gowamgei ma alugo apapoehi i iyagahi ma to baha po ipa ina wohouna. Matababana tauna ega ata bolu u hinena.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu i baha Yoni ugolina i pa, ‘Ega ona yamgudugudu, babana iyai ega ita igawiyeta naka tulata.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Houga i kukuku ipa apo Yaubada Yesu ina wohepaya po ina gae hau yada. Ma Yesu a nugotuhu i houna emoteya ipa ina nae u Yelusalem, ");
INSERT INTO tbo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","po baha tu hihiwa i himilihi po hi tahaya nae. Tauhi hi nae po Samaliya meyageina gehouna ugolina ipa tauna ubeina hina wononogo. ");
INSERT INTO tbo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tamogi meyageina lawahi Yesu hi wihinigigiyeya babana nugonugona i nenae u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hougana a hewahewali Yamesa po Yoni geka bahana hi noonoli po hi pa, ‘Guyau, nugonugom yaka mayau yadei to otugeya po ina hopu mai po geka lawahi ina alahihi?’ ");
INSERT INTO tbo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Yesu i luhagawileya po i paliyehi i pa, ‘Ega naka pite.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ugolinei hi nehalehi po hi nae meyagai gehouna ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hougana tahayagei hi nenae ma lawa gehouna i baha nae Yesu ugolina i pa, ‘Am nae atapuhi ugolihi apo a wotagom.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu i baha lawana ugolina i pa, ‘Gamogamo mi pitepitena waidomohi po kiu moyanei waipatahi. Ma Lawa Moinau ega meka nawatatau ani wienona gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu i baha nae lawa gehouna ugolina i pa, ‘Una wotagou.’ Ma lawana i pa, ‘Guyau, una palihaleu po a nae po amau a ototoni ma ina hilage po a guluwa tahaeya ma apoma a wotagom.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu a baha i wimiheya i pa, ‘Lawa hai luyagohana mei tu hilahilage una palihalehi po tu hilahilage ugolihi hina galena nae. Ma tam una nae po Yaubada anani taniwaga una guuguyeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lawa gehouna Yesu ugolina i baha i pa, ‘Guyau, apo a wotagom. Tamogi una palihaleu po a nae po u guguni a mamala tahaehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Yesu i baha ugolina i pa, ‘Apo iyai Yaubada binei ina wobagibagi ma ina luhagawileya po uyawena ina gagaleya yaka tauna ega a dewadewa awai Yaubada anani taniwaga ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Geka u mulina Guyau lawa magouhi 72 i winaganihi po luwaga luwaga ma i himilihi po hi tahaya nae meyagai baneihi po habuluhi atapuhi ugolihi. Tauna noka meyageihi apo ina luinihi. ");
INSERT INTO tbo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma Yesu i paliwelehi i pa, ‘Mahula i lauliligeya ma tu yaba luemoemotahi. Ugolinei ona lupali po mahula Guyouna ugolina po tu yaba gehouhi ina himilihi po hina nae mahula hina tuwaluhi. ");
INSERT INTO tbo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ona nae. Tau a himihimilimi galenami mei sipi natunatuhi kedewa woyahiyahi u hayahi. ");
INSERT INTO tbo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ega mone po outu po ae humahuma ona wiwinihi. U tahaya ega ona tutowolo po iyai ona maamali. ");
INSERT INTO tbo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","‘Numa awai ona luiya yaka ginouli tahatahayana ona pa, “Yaubada a nugodumola geka u numana ina mae.” ");
INSERT INTO tbo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Inapa tu nugodumola lawana naka hosi yaka am wimaamala ugolina ina mae. Ma inapa eega yaka am wimaamala una wimeya. ");
INSERT INTO tbo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma numa emosi ugolina ona mamae ma awai he welewelemi on’omam po ona umuma babana tu bagibagi waimihana. Ega ona inuma maga. ");
INSERT INTO tbo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","‘Hougana meyagai baneina awai ona luiya po lawa hina kaohemi po u naomi aniani hina huhouna ona ani. ");
INSERT INTO tbo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Naka u meyageina tu tootogo ona luyawahihi ma lawa ugolihi ona baha ona pa, “Yaubada anani taniwaga amaka i tuliyaliyanimi.” ");
INSERT INTO tbo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tamogi meyagai awai ona luiya po ega hina kaohemi yaka ona nae po hau tahaya ona pa, ");
INSERT INTO tbo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ami meyagai dubudubuna u aeyai i yampati gasi mitehi to lihooholaitani taumi ugolimi. Hawena ma tamogi Yaubada anani taniwaga amaka i tuliyaliyanimi.” ");
INSERT INTO tbo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","‘A paliwelemi, Libahibahi Iyetana ugolina apo hai wiyuwa ina lata duma ma mi Sodom hai wiyuwa ina habulu. ");
INSERT INTO tbo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘Aee, kihoni, Kolasini lawami apo wiyuwa ona wialoni. Aee, kihoni, Besaida lawami apo wiyuwa ona wialoni. Itapa manini u hinemi hi dewadewahi u Taya po u Saidoni hita dewahi amaka lolowa lawahi hita nugobui. Ma hai nugobuina apo hita wogeleteya po kaleko apapoehi hita otena ma hita lugobu ma hita tugutugula. ");
INSERT INTO tbo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tamogi Libahibahi Iyetana ugolina apo Yaubada Taya ma Saidoni ina lunugotootogogena dumahi ma apoma taumi. ");
INSERT INTO tbo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma taumi Kapaneum lawami ami nugotuhu o pa ona wohepa memi po ona gae hau yada, bo? Apeega, apo Yaubada ina halena hopunemi hiyoyowa ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu a hewahewali ugolihi i baha i pa, ‘Iyai ugolimi e launonola naka ugoliu e launonola. Iyai i wihinigigiyemi naka i wihinigigiyeu. Ma iyai ina wihinigigiyeu naka tu himiliu i wihinigigiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ega yaka Yesu a hewahewali magouhi 72 hi nae po hi gunagunawilena mehi a kaohahi po hi pa, ‘Guyau, alugo apapoehi gowamgei hi wiponawogogeiyai.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Yesu ugolihi i baha i pa, ‘Tomodulele a gagaleya ma yadei i peu po i hopuhopu mai mei namanamala. ");
INSERT INTO tbo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ona launonola, amaka wipoya a welemi po apo mota waitonahi tepahigei ona nae po tanala ona tutepanihi po Tomodulele a wipoya atapuhi ona lagonihi ma apega wiyuwa ona wialonihi. ");
INSERT INTO tbo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tamogi alugo apapoehi he iponawogogemi binei ega ona kaokaoha. Ma ona kaokaoha babana amaka hau yada Yaubada gowami i gilumihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Noka hougana Yesu Alugo Woiyawa i wihogoya po i kaoha ma i pa, ‘Amau yada po hipuli hai Guyau. A wotalagiyem babana lawa hanahanapuhi po wainugonugotuhuhi ugolihi awai u gowagowadi naka tu winugoneina ugolihi u wogeleteya. Moina Amau geka pite ipa am lunugotootogogei ina wawala. ");
INSERT INTO tbo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","‘Amau ginouli atapuhi u weleu. Ega iyai tau ita hanapugeu ma Amau tuawam. Gasi ega iyai Amau ita hanapugem, ma tau Natum po iyawoi a inaganihi ugolihi Amau a woogeletem tuawiyai to hanapugem.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hougana Yesu a hewahewali mitehi hi lutuwanehi ma apoma i luhagawileya po ugolihi i baha i pa, ‘Taumi tu kaoha babana ginouli dewadewahi amaka o galehi. ");
INSERT INTO tbo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Matababana a paliwelemi naka awai o gagalehi tu bahapiko po wasawasa odubohi hai luhogala ipa hina galehi ma ega hita galehi. Ma gasi awai o noonolihi hai luhogala ipa hina nonolihi ma ega hita nonolihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lugagayo taniwagana i towolo po Yesu a hanapu i ludadani i pa, ‘Bada, awai apo a dewaya po luyagohana tuwetuwenai a tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu i baha nae ugolina i pa, ‘Hau lugagayo Mose awai i gilumihi? Ma anohi awai e hiyahiyawa tuhagahi?’ ");
INSERT INTO tbo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lawana Yesu a baha i wimiheya i pa, ‘Guyau am Yaubada luhogalam atapunei po alugom atapunei po kadidilim atapunei po nugonugom atapunei una luhogaleya. Ma lawa u liyaliyam tu mae una luhogalehi po mei e lauhogalena mem.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu lawana ugolina i baha i pa, ‘Am baha i dumalu duma. Geka una metagohi yaka apo luyagohana tuwetuwenai una tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ugolinei lugagayo taniwagana ipa ina houna idumalu meya po i lubayada i pa, ‘Lawa awai naka u liyaliyau tu mae?’ ");
INSERT INTO tbo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma Yesu a bahana i wimiheya i pa, ‘Lawa gehouna Yelusalemgei i hopuhopu u Yeliko po tu danedanene u nimahi i houna meya. A gala hi gagigagi ma hi ilawi po mei ina hilahilage ma hi nehaleya. ");
INSERT INTO tbo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Noka kabudalana ugolina tu witalaguyaba gehouna noka tahayanei i hopuhopu. Tamogi i galeya ma tahayana hadana gehouna i waya po i nae po i weluwileya. ");
INSERT INTO tbo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mei gasi Libai lawana gehouna. I nei u dobuna po lawana i galeya ma i weluwileya po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma lawa gehouna Samaliyagei noka tahayanei i kadau po i nenei po lawana ugolina i lugeleta. Hougana i gagaleya po nugonugona i wiyuweya. ");
INSERT INTO tbo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ega yaka i nae po kelona ugolihi wakatu po wine i hiwogihi ma i humahi. Apoma a gamogamo u upuna i touli po i niyeya tu kadakadau hai u numa po i galena iteteya. ");
INSERT INTO tbo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma malitom po mone i waya po numana taniwagana i weleya ma i pa, “Geka lawana una gagalena iteteya. Ma ugolina mone a lata awai u hahaleya meka hougana a gunawileu apo a lidumalum.” ");
INSERT INTO tbo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","‘Geka lawahi tonuga ugolihi meka lawana i wogeletena meya tauna lawana tu danedanene hi lawi u liyaliyana tu mae?’ ");
INSERT INTO tbo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lugagayo taniwagana i pa, ‘Lawana Samaliyagei tauna i launugotootogogeya.’ Ma Yesu i pa, ‘Amaka, ma una nae po una metagoya.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hougana Yesu po a hewahewali tahayagei hi nenae. Ma meyagai gehouna hi luiya po wawine gowana Maleta Yesu i weluwaya po hi nae a u numa. ");
INSERT INTO tbo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma tauna walehina gowana Maliya Guyau aena u labena i tugula ma a wiatatiyana i noonolihi. ");
INSERT INTO tbo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maleta a bagibagi a maga ugolina ma nugonugona i apapoe po i nei Yesu ugolina po i pa, ‘Guyau, iyowai po walehiu i palihaleu po tuawau a pupoula ma ega ita geno? Una baha po ina nei po ina haguwe.’ ");
INSERT INTO tbo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Guyau Maleta a baha i wimiheya i pa, ‘Maleta, Maleta, ginouli magomagouhi ugolihi e genogeno po e inugopilipili, ");
INSERT INTO tbo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","tamogi ginouli emosi waianona. Maliya ginouli moinana i winagani po apega iyai ina wihaleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iyeta gehouna Yesu dobu gehouna ugolina i laupali. Hougana i laupali woloe po a hewali gehouna Yesuna ugolina i baha i pa, ‘Guyau, lupali una wiatatiyeiyai po mei Yoni bapatiso a hewahewali.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu i baha ugolihi i pa, ‘Ona laupali ona pa: Amiyai, Gowam to wiyateyateya. Am ani taniwaga una wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iyeta emosi po emosi i am ubeina una weliyai. ");
INSERT INTO tbo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","I apapoe una paligigilihi po mei iyawoi tu wiapapoeniyai to paligigilihi. Ma ega una palihaliyai po ludadana baneihi tona ialonihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma Yesu a hewahewali ugolihi i pa, ‘Itapa iyai gehoum uta nae upom tipolinei po tulam ugolina uta pa, “Tulau palawa ugolim yaka piyana tonuga una weleu. ");
INSERT INTO tbo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Matababana tulau i kadakadau nae po ugoliu i lugeleta po ega a yam ma ega aniani awai ugoliu ipa apo a weleya.” ");
INSERT INTO tbo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Ma tulomna numa u hinena ita pa, “Ega una laigenou. Amaka mateta a guduya po natunatuwe mitehi to eneno. Apega a wotowolo po awai a welem.” ");
INSERT INTO tbo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A paliwelemi, hawena apega ina wotowolo po awai ina welem babana tauna tulam. Ma tamogi am wihigihigili binei apo ina wotowolo po awai atapuhi u lauhogalehi ina welem. ");
INSERT INTO tbo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","‘Ma a paliwelemi, ona lupali yaka apo Yaubada ina welemi. Ona bibeiha yaka apo ona tuhagaya. Ma ona laitutou yaka Yaubada apo taumi bimiyei gudu ina hoeya. ");
INSERT INTO tbo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Matababana tu lupali atapuhi hai luhogala Yaubada e welewelehi. Ma tu beiha hai luhogala he tutuhagahi po tu litutou ubeihi Yaubada gudu e hoehoeya. ");
INSERT INTO tbo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘Itapa geka u hayamina tam tu winatuna ma natum olotona ita kawaiyana, apo mota uta weleya? ");
INSERT INTO tbo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bo ita kawapou, apo tanala uta weleya? ");
INSERT INTO tbo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Taumi tu apapoe ma o hanapugeya po natunatumi ginouli dewadewana, o yambenehi, yaka Amata hau yada tu lupali Alugo Woiyawa e welewelehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Alugo apapoena lawa e laigumgumnihi Yesu i wiyagaya lawa gehouna ugolina. Hougana alugo lawana i nenehaleya naka lawana i tugudu po i wibaabani. Bolu hi gagalena naka hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tamogi lawa gehouhi hi pa, ‘Palouma hai bada Tomodulele Yesu balau i weleya po ugolinei alugo apapoehi e iyagahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma gehouhi hai luhogala ipa Yesu hina ludadani po hi laupaliyeya ipa manini wekiwekilalana yadei ina wogeleteya po hina galeya. ");
INSERT INTO tbo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tamogi hai winugonugotuhu amaka i hanapugeya yaka ugolihi i baha i pa, ‘Apo ani taniwaga gehouna u tipolina ina gunakahaya po hina igawigawiyena mehi apo hai mae ina apapoe. ");
INSERT INTO tbo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ugolinei ma inapa Tomodulele anani taniwaga ina gunakahaya po hina igawigawiyena mehi, apo iyowai a kadidili galenana? Taumi o pa Tomodulele a wipoyagei alugo apapoehi a iyagahi. ");
INSERT INTO tbo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Taumi o baha o pa Tomodulele a wipoya ugolinei a wobagibagi po alugo apapoehi a iyagahi yaka taumi ami lawa iyowai he iyaga. Tauhi ugolihiyei nugotuhu dumaluna apo ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tamogi inapa Yaubada a wipoyagei alugo apapoehi ana iyagahi yaka Yaubada anani taniwaga amaka i nei ugolimi. ");
INSERT INTO tbo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Inapa lawa kadikadidilina anani witona ginoulihi ina wononogogehi ma a numa ina ototoni, apega a ginouli hina danenehi. ");
INSERT INTO tbo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tamogi meka hougana lawa kadikadidili dumana lawana ina huluya apo ina uni. Ma anani witonahi i itumaganehi lawana kadikadidili dumana ina tamihi po ina nohaya. ");
INSERT INTO tbo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Iyai ega tau miteu yaka tauna e igawiyeu. Ma iyai ega tau miteu tona nugoemota yaka tauna tu’mnoha. ");
INSERT INTO tbo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Hougana alugo apapoena lawa ina hopu haleya naka dobu ega ita igoila e yayahi po e nenae ani wiyagohina e bibeiha. Ma inapa ega emosi ina tuhagaya yaka apo tuawana ina baha ina pa, ‘Apo a gunawilena meu u numa a nenehaleya ugolina.” ");
INSERT INTO tbo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma hougana i gunagunawileya po numana i yeuyeu po ginouli hi houna imahiyehi ma i galeya. ");
INSERT INTO tbo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yaka apoma apo ina nae po alugo apapoe dumahi magouhi 7 ina weluwinihi po hina lui po noka hosi hina mae. Ugolinei mehougana hina meyato po ina kokoe naka noka lawa a mae apo ina apapoe duma ma apoma lolowa.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hougana Yesu geka i baheya po i kokoe ma wawine gehouna bolu u hinena ponana i lata ma i baha Yesu ugolina i pa, ‘Wawine iyai tu gunim po tu wigugum tauna tu kaohadiidiga.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma a baha Yesu i wimiyeya i pa, ‘Tamogi iyawoi Yaubada a baha hina nonoli po hina wiponawogogeya tauhi tu kaohadiidiga.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bolu hougana i lalata ma Yesu i tugudu po i pa, ‘Geka hapanana hapa apapoena. Hai luhogala ipa manini wekiwekilalana Yaubada ugolihi ina woogeleteya. Tamogi apega manini gehouna ina wogeleteya ugolihi ma wekiwekilala Yona i woogeleteya tuawana. ");
INSERT INTO tbo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tu bahapiko Yona tauna wekiwekilala Ninewa lawahi ugolihi. Naka pitenana gasi tau Lawa Moinau wekiwekilala geka hapanana lawami ugolimi. ");
INSERT INTO tbo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tupo yawana hai wasawasa wawinena apo Libahibahi Iyetana ugolina ina towolo po ina wigoumi. Matababana hipuli anani kokoe ugolina ma i nei po Solomona a wiatatiyana hanahanapu i nonoli. Ma a paliwelemi, geka hosi lawa gehouna i geduma apoma Solomona. ");
INSERT INTO tbo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Libahibahi Iyetana ugolina apo Ninewa lawahi hina towolo po hina wigoumi. Matababana Yona a guguya hi noonoli po hai apapoe hi palihalehi. Ma a paliwelemi, geka hosi lawa gehouna i geduma ma apoma Yona. ");
INSERT INTO tbo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘Apega iyai ani liyayata ina tunuya ma ina gowadi bo nau u hinena ina talapupuya. Tamogi ani tugulana ugolina e wituguli po numana lawa he luiluiya apo yayatana hina galeya. ");
INSERT INTO tbo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam tauna hinim anani liyayata. Hougana matam a dewadewahi hinim atapuna apo yayata ina hogoya. Ma matam hai apapoe hougana hinim atapuna apo hau uguwa. ");
INSERT INTO tbo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ugolinei ma ipa una galena imahi naka yayatana ugolim ega ina uguguwi. ");
INSERT INTO tbo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Inapa hinim atapuna yayata ina hogoya po ega tupom gehouna hau uguwa naka apo ina yayata pahim. Galenana mei yayata baneina e nenehi ugolim.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu hougana i ibaabani woloe po Palisi lawana gehouna i gigimeya po ipa hina am yaka i lui gae po hau ani am i tugula. ");
INSERT INTO tbo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Palisi lawana i gohola dumaya babana Yesu ega ita oga tahaya ma apoma ita am. ");
INSERT INTO tbo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yaka Yesu i baha nae ugolina i pa, ‘Taumi Palisi lawami ami keyaka po ami gaeba upuhi o laiyeuyeuhi, ma tamogi u hinemi omboho po dewa apapoe i wihogomi. ");
INSERT INTO tbo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Taumi buuwa. Yaubada ginouli atapuhi uputahi i dewahi yaka tauna gasi hinehi i dewahi. ");
INSERT INTO tbo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma am lounugotootogogei tu dayadayabu hagu ona welewelehi yaka apo taumi tu yeuyeu. ");
INSERT INTO tbo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘Kihoni Palisi lawami taumi tu nugodubu. Ami ginouli magouhi 10 ma u hinehi emosi Yaubada o weleweleya, ginouli mei naiya po tupatago po aniani ani widewadewahi atapuhi. Tamogi dewadumalu po Yaubada luhogalana ega ota genogenogeya. Geka dewahi naka ginouli baneihi ipa ona wootagohi ma ami ombenena Yaubada ugolina ega nugomi ina guluguluwi. ");
INSERT INTO tbo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Kihoni Palisi lawami taumi tu nugodubu. Ami luhogala ani tugula dewadewahi hau numa dalabu. Ami luhogala ipa ani gimala ugolina lawa wiyateyategei hina maamalimi. ");
INSERT INTO tbo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Taumi tu nugodubu babana galenami mei kokowaga ega wekiwekilalahi ma tepahiyei lawa he nenae.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lugagayo taniwagana gehouna Yesu ugolina i baha i pa, ‘Bada, geka bahahi u bahebahehi naka gasi tiyai u paliguyoguyougeiyai.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Yesu i pa, ‘Taumi lagagayo tanitaniwagahi gasi tu nugodubu. Matababana lawa witai baneihi ega emoemotahi hina awalihi ma o iawalihi. Ma taumi ega kikeina nima gigimi emosi ota lodomi po noka witeihi ota wodadanihi. ");
INSERT INTO tbo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘Taumi tu nugodubu babana taumi googami tu bahapiko hi ununihi kokowagahi o wogo imahiyehi. ");
INSERT INTO tbo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ugolinei taumi tu baha moina po tu lueena googomi hai dewa ugolihi babana hi ununihi ma taumi kokowagahi o wogo imahiyehi. ");
INSERT INTO tbo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Geka binei ma Yaubada a hanapu i baheya i pa, “Ugolihi apo tu bahapiko po tu wituwetuwega a himila niyehi. Gehouhi apo hina unihi ma gehouhi apo hina wihiniwiyuwahi.” ");
INSERT INTO tbo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yaka hipuli i wawala po i nenei ma tu bahapiko atapuhi hi ununi talahi mihana apo geka hapanana hina waya. ");
INSERT INTO tbo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Keini tulana Abele i ununi ugolina i nei po Sakaliya ani witalaguyaba babanoyana wailugagayona u tipolina hi ununi ugolina. Moina dumana a paliwelemi, atapuhi bihiyei geka hanapana lawahi apo wimeihana hina waya. ");
INSERT INTO tbo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘Kihoni lugagayo tanitaniwagahi taumi tu nugodubu. Matababana hanapu numana an’imhoena o wihaleya. Taumi apega ona lui po gasi iyawoi he ileta ipa hina lui naka o luguduhi.’ ");
INSERT INTO tbo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hougana Yesu noka dobuna i nenehaleya ma Palisi lawahi po lugagayo tanitaniwagahi hi tugudu po hi palipaliguyoguyougeya. Ma ginouli boluhi bihiyei hi laubayadeya, ");
INSERT INTO tbo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","po hi ileta ipa hina witahaya powaya po ina baha powa ma hina nonoli. ");
INSERT INTO tbo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lawa magouhi tausana po tausana hi yamtuboina mai naka hi tututata mehi. Ma Yesu i baha tahaya a hewahewali ugolihi i pa, ‘Ona gagalena imahi Palisi lawahi hai palawa ani lihaahanana binei naka hai nugohine gowagowada. Taumi ega noka pite ona dewedeweya. ");
INSERT INTO tbo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Babana ginouli awai humahumana apo ina lugeleteya, bo gowagowadana apo lawa hina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ugolinei ma ginouli awai hau uguwa o bahebaheya apo hau yayata hina nonoli. Ma awai babanoya guduguduhi u hinehi o iyaguhaehaehi apo dobu atapuna hina iototugeya. ");
INSERT INTO tbo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘U lawa, a paliwelemi, iyawoi hinita he uni po u mulina ma apega awai apapoe dumana hina dewaya ega ona matomatoutehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tamogi iyai ipa ona matomatouteya apo a wiatatiyemi. Yaubada ona matouteya, tauna omunugo u mulina a wipoyagei emoemotana apo tu hilahilage hau mayau alalatana ina wihulu niyehi. Moina tauna emosina ona matomatouteya. ");
INSERT INTO tbo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘Lawa atapuhi hi hanapugeya naka kiu muhomuhohi nimituhu mihahi 20 toea. Ma ega kiuna emosi Yaubada ita inugoguluwi. ");
INSERT INTO tbo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ma gasi ununumi apala atapuhi Yaubada i hiyawa pahi. Ugolinei ega ona matomatouta, taumi o geduma ma apoma kiu boluhi. ");
INSERT INTO tbo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Ma a paliwelemi, iyai bolu u matahi ma ina bahena geleteu naka tau e itumaganeu, yaka Lawa Moinau Yaubada a tu winoyanoya u matahi apo tauna a bahena geleteya. ");
INSERT INTO tbo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma iyai ina bowiyeu lawa u matahi yaka Lawa Moinau Yaubada a tu winoyanoya u matahi apo tauna a bowiyeya. ");
INSERT INTO tbo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma iyai ina baha apapoe Lawa Moinau ugoliu yaka apo Yaubada ina paligigili. Tamogi iyai Alugo Woiyawa ina paliguyoguyougeya yaka tauna apega Yaubada ina paligigili. ");
INSERT INTO tbo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Hougana apo hina niyemi hau numa dalabu po hina lauhetalemi bo babada po tanitaniwaga u matahi ega ona genogeno ipa apo iyowai ona wibaabani po awai ona baheya. ");
INSERT INTO tbo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Matababana noka hougana Alugo Woiyawa apo awai ina wiatatiyemi po ona baheya.’ ");
INSERT INTO tbo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bolu u hinena lawa gehouna i baha i pa, ‘Bada, walehiu una paliweleya po amiyai gapola i hilahilage haleya ina gutaya tau mitehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma a baha Yesu i wimiheya i pa, ‘Tulau, iyai i dewau po ipa a wituluhetala bo a wituguta ugolimi?’ ");
INSERT INTO tbo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma ugolihi i baha nae i pa, ‘Ona gagalena imahi po omgaganu galenana tapuna po tapuna ugolina ona wola imahi. Matababana hawena lawa i wigapola lagona tamogi a luyagohana moinana ega gapola ugolihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Apoma Yesu geka om paliluwaluwana i paliwelehi i pa, ‘Lawa waigapolana gehouna a hipuli ugolina aniani baneina i tutuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma tuawana i nugonugotuhu ipa, “Apo awai a dewaya babana ega meka u yam ani hounahi?” ");
INSERT INTO tbo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Ma i paliwelena meya i pa, “Geka pite apo a dewa. Apo u hanali a goluhihi po baneihi a dewahi po ugolihi apo u pegapega po u ginouli gehouhi atapuhi a hounihi. ");
INSERT INTO tbo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Apoma apo a paliwelena meu ana pa, a woimahi duma. Ginouli atapuhi ugoliu apo ana ibagibagihi ma hina mamae, bolima magamaga. Kamnau apo a laidewadewaya. A am po a uma ma a kaokaoha.” ");
INSERT INTO tbo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Tamogi Yaubada i baha nae ugolina i pa, “Tam buuwa. Geka upomna apo alugom a wihaleya. Ma geka ginoulihi u noonogogehi apo iyai galinei?” ’ ");
INSERT INTO tbo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu ompaliluwaluwana i laiwoloeya i pa, ‘Iyawoi tauhi bihiyei gapola he iupuma gae ma Yaubada u matana ega hita igapola geka pite dewa apo ugolihi ina wawala.’ ");
INSERT INTO tbo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Apoma Yesu i baha nae a hewahewali ugolihi i pa, ‘Ugolinei ma a paliwelemi, ega ona genogeno ami mae hau hipuli binei, awai apo ona anani, Ma ega hinimi binei ona genogenogeya ipa awai apo ona ototeni. ");
INSERT INTO tbo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Matababana ami luyagohana hi geduma ma apoma aniani, ma gasi hinimi hi geduma ma apoma kaleko. ");
INSERT INTO tbo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hapali waewae ona galehi, tauhi ega hita laupehi po ega hita yaba po hau hanali hita huhouna. Ma tamogi Yaubada e ianianihi. Ma taumi o geduma ma apoma kiu. ");
INSERT INTO tbo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iyai u hayami emoemotana a nugotuhugei a luyagohana ita lidaoya? Ega emoemotami. ");
INSERT INTO tbo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Inapa ega emoemotami ginouli habuluna mei nonokahi ona dewaya yaka awai bihiyei o genogeno? ");
INSERT INTO tbo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Hapali wihiya iyowai he lahalahahi ona galehi. Tauhi ega hita wobagibagi bo hai kaleko hita yamdewa. Tamogi a paliwelemi, Solomona a gapola atapuhi u hinehi a kaleko ega hai haki mei geka wihiyahi. ");
INSERT INTO tbo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hiyamoni amalai e lauyagohana ma malinatom po amaka e nae. Hau mayau he’mapugeya po e alalahi. Tamogi Yaubada tauna hiyamonihi galenahi e idewadewahi. Baha dumana Yaubada apo ami kaleko dewadewahi ina wiotenimi? Ami witumagana hi habulu hota! ");
INSERT INTO tbo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Awai apo ona anani po awai apo ona umumaya binei ega ona inugonugotuhu po ega ona nugonugogeno. ");
INSERT INTO tbo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Matababana geka hipulina ugolina tu meuputa geka ginoulihi he bibihehi. Ma Amami i hanapugeya naka geka ginoulihi o luhogalehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yaka tauna anani taniwaga ona bibiheya po geka ginoulihi apo hina wigalimiyei gasi. ");
INSERT INTO tbo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Taumi bolu habulumi ega ona matomatouta babana Amami a nugodewadewa ipa anani taniwaga ina welemi. ");
INSERT INTO tbo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ami ginouli ona gimalena halehi po monehi tu dayadayabu ona welehi. Ami mone ani’mpohapohahi ega hita woapapoe ona winihi po hau yada mone memewagahi ona tuupumihi. Noka hosi apega tu danedanene hina winihi po apega pitala hina tonahi. ");
INSERT INTO tbo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma meka hosi ami gapola he memeyana naka hosi apo nugonugomi hina mae. ");
INSERT INTO tbo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Ami ani bagibagi kalekohi ona lumomohihi ma ami ani liyayata ona tunuhi ma ona wononogo, ");
INSERT INTO tbo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mei tu bagibagi hai bada tawine tolehana ugolina a gunawilana he ototoni. Tauhi apo mala emosi ma a gudu hina hoeya inapa ina gunawileya po ina ilulougo yaka. ");
INSERT INTO tbo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Noka tu bagibagihi tauhi tu kaoha inapa hai bada ina gunawileya po ina tuhagahi naka ega hita meme hota. A baha duma ugolimi apo badana a kaleko ina lumomohi ma ina baha po hau ani am hina tugula ma ina nei po ina poulehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Inapa upom tipolinei bo malatomtomgei ina nenei po tu bagibagihi a nonogohi ma ina tuhagahi naka tauhi tu kaohadiidiga. ");
INSERT INTO tbo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma gegeka ona hanapugeya, itapa numa taniwagana tu danedanene a nei kabudalana ita hanapugeya apo matana ita kayakaya po apega a numa ita lupapaya po ita lui. ");
INSERT INTO tbo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Taumi ipa gasi ona wononogo babana kabudala awai o pa apega a nenei naka u hinena apo Lawa Moinau a nei.’ ");
INSERT INTO tbo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita i baha i pa, ‘Guyau, geka paliluwaluwana e bahebaheya naka tuawiyai ubeiyai bo lawa atapuhi ubeihi?’ ");
INSERT INTO tbo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma Guyau i pa, ‘Iyai waiponawogona po wainugonugotuhuna? Tauna apo a bada ina witowoli po numa u hinena ina witaniwaga, ma tu bagibagi gehouhi hai guta aniani kabudala dumalunei ina welewelehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Inapa badana ina gunagunawileya po geka dewana ina dewedeweya ma ina tuhagaya naka tu bagibagina tauna tu kaohadiidiga. ");
INSERT INTO tbo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A baha duma ugolimi noka badana apo tu bagibagina ina witowoli po ginouli atapuhi ina gagalena itetehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tamogi noka tu bagibagina inapa ina paliwelena meya ina pa, “U bada a gunawilana i wihinihinibiga,” ma ina wiwawala po tu bagibagi ololotohi po wiwinehi ina kodikodilihi. Ma in’omam ma ina umuma buuwa. ");
INSERT INTO tbo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Noka tu bagibagina a bada iyeta emosi apo ina nei. Ma a neina naka tu bagibagina ipa apega ina nei po kabudalana apega ina hanapugeya. Ma apo ina wimiheya po tu bagibagi waiponahahalehi mitehi ina houna emotehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Ma inapa noka tu bagibagina a bada a nugotuhu ina hanapugeya ma ega ina wononogo po ina dewa tagoya. Tauna apo kodikodila baneina ina waya. ");
INSERT INTO tbo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma tu bagibagi iyai a bada a nugotuhu ega ita hanapugeya ma i dewa powaya po apo kodikodila ina ialoni tauna apega kodikodila baneina ina waya. Iyai awai baneina i tutuhagaya ipa gasi baneina ina palihaleya. Ma iyai ugolina banei dumana lawa hi huhouni tauhi apo hai lupali banei dumana hina dewaya. ");
INSERT INTO tbo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘A nei ipa hipuli a tunuya po ina alahi. Hilaki amaka ita luebaleya po ita alalata. ");
INSERT INTO tbo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma tau gasi u bapatiso waiyuwana apo a waya ma hilaki wiyuwana ita kokoe. ");
INSERT INTO tbo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ami nugotuhu o pa nugodumola ata neiyai hau hipuli, bo? A paliwelemi, eega. Tamogi wikahakaha a neiyai. ");
INSERT INTO tbo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Amalai ma i wawala po i nenae apo numa emosi u hinena lawa nimitutu hina mamae. Ma tonuga apo hina towolo po luwaga hina igawiyehi, bo luwaga hina towolo po tonuga hina igawiyehi. ");
INSERT INTO tbo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apo hina wikahakaha po ama natuna olotona ina igawiyeya ma natu olotona amana ina igawiyeya. Apo hina natuna wawinena ina igawiyeya ma natu wawinena hinana ina igawiyeya. Keduluma apo pohiyana wawinena ina igawiyeya ma wawine apo pohiyana waikedulumana ina igawiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu i baha nae bolu ugolihi i pa, ‘Taumi kabudala anani yoli ugolina yaloi wopotopotona e wohepa ma o galeya po mala emosi ma o pa, “Apo ina atuna,” ma e atuna. ");
INSERT INTO tbo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma yawana e togotogo ma o galeya yaka o pa, “Apo dobu ina wipoya,” ma e wipoya. ");
INSERT INTO tbo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Taumi galena koyakoyama o dewadewaya. Houga apo galenana iyowai naka hipuli po yada o galehi ma o ipikogehi. Tamogi iyowai po geka hougana Yaubada a bagibagi anona ega emoemotami ona baheya? ");
INSERT INTO tbo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘Ma dewa awai dumadumaluna iyowai po tuawami ega ota ikahaya? ");
INSERT INTO tbo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ma inapa iyai ina wigoum po ina niniyem hau luhetala yaka una wileta duma hau tahaya po tauna mitehi ona winugoemota. Ma inapa ega ona inugoemota yaka apo ina niyem tu luhetala baneihi ugolihi. Tauhi apo numa panipani tu galena itetehi u nimahi hina hounim po hau numa panipani hina tugudum. ");
INSERT INTO tbo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A paliwelemi, noka hosi apo una mamae a sigana am yaga atapuna una lidumaluya ina hopu po toea emosi ugolina una wikokowi.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Noka hougana lawa gehouhi Yesu hi paliweleya tu witalaguyaba mi Galili ubeihi. Tauhi Yaubada ugolina hai witalaguyaba hi dewadewaya ma Pilato i ununihi ma talahi gamogamo talahi mitehi i wilawila emoteya, Yesu hi paliweleya. ");
INSERT INTO tbo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma Yesu hai baha i wimiheya i pa, ‘O nugotuhuya naka geka pite mi Galilihi hi ununihi naka tauhi hi apapoe lagona ma apoma mi Galili gehouhi, bo? ");
INSERT INTO tbo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eega duma. Ma a paliwelemi, inapa ami apapoe ega ona palihalehi yaka atapumi apo ona hilage po mei tauhi hi hilahilage. ");
INSERT INTO tbo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lawa magouhi 18 u Silowam numa gahina daodaona i guli po i lutatahi. Ma tauhi o nugonugotuhuhi naka iyowai? Ami nugotuhu o pa tauhi hi apapoe lagona ma apoma Yelusalem tu miyena gehouhi, bo? ");
INSERT INTO tbo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eega duma. Ma a paliwelemi, inapa ami apapoe ega ona palihalehi yaka apo atapumi ona hilage po mei tauhi hi hilahilage.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ma geka paliluwaluwana i baheya i pa, ‘Lawa gehouna a wine tanona ugolina mabewa i lahaya po i lata po i mamae. Ma lawana i nae po mabewana ugona i bibiheya po ega ita tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ega yaka a tano tu bagibagiyena ugolina i baha i pa, “U galeya, geka mabewana a nei po ugona a bibiheya naka bolima tonuga ma ega ata tutuhagahi. Una tala dubali babana hipuli a dewadewa e ibagibagi yababaya.” ");
INSERT INTO tbo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Ma tano tu bagibagiyena i pa, “Bada, una palihaleya po ina towotowolo geka bolimana emosi hotana. Apo babana a tawi wiiwileya ma nudanuda budabudahi a hounihi. ");
INSERT INTO tbo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma inapa bolima gehouna ina ugo yaka i dewadewa duma. Ma inapa eega yaka apoma una baha po ta tala dubali.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dalabu gehouna Yesu hau numa dalabu i iatatiyana. ");
INSERT INTO tbo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma noka hosi keduluma gehouna u hinena alugo apapoena i mamae. Alugona tauna kedulumana i witotogoya po i mamae naka bolima magouhi 18. Kedulumana upuna i gunayouni po ega ita towotowolo dumadumalu. ");
INSERT INTO tbo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma hougana Yesu kedulumana i gagaleya po i baha ugolina i pa, ‘Keduluma, am totogo amaka i nehalem.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma nimana Kedulumana ugolina i hounihi po mala emosi ma i towolo dumadumalu po Yaubada i wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tamogi numa dalabu tu galena itete uyona i gigai babana Yesu hau dalabu lawa i luyawahi. Binei ma lawa ugolihi i baha i pa, ‘Iyeta magouhi 6 u hinehi ta woobagibagi. Yaka noka iyetahi ugolihi ona nei po Yesu ina lauyawahimi ma ega hau dalabu.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Apoma a baha Guyau i wimiheya i pa, ‘Taumi galena koyakoyama o dewadewaya. Ega iyai gehouna a bulumakau bo a doniki hau dalabu ita lupeni po ita iumaumaya, bo? ");
INSERT INTO tbo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma gegeka Abelaham gogana Tomodulele i numa panipani po i mamae bolima magouhi 18, ma apega hau dalabu a panipani a lupeni, bo?’ ");
INSERT INTO tbo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Geka i bahebaheya po tu wigawiyena hi wihinimaya. Ma ginouli dewadewahi atapuhi i dewadewahi naka lawa hi kaokaohehi. ");
INSERT INTO tbo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu i lubayada i pa, ‘Yaubada anani taniwaga mei awai? Ma apo awai ugolina a wiluweluweya? ");
INSERT INTO tbo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Amaka mei lawa ihagila polana e waya po a u tano e ugohi po e lata po mayau baneina. Ma lagalagana ugolihi kiu hai pata he wogowogohi.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma Yesu i baha meme i pa, ‘Yaubada anani taniwaga awai ugolina apo a wiluweluweya? ");
INSERT INTO tbo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Amaka mei palawa ani lihaahanana wawine e waya po palawa humahi tonuga ugolihi e houna hopunehi. Ma e mudamudaya po palawana atapuna e hahana pahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu meyagai baneihi po habuluhi i yayahihi po i nenae a tahayagei. Ma i iatatiyana ma Yelusalem binei i haleya po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma lawa gehouna i lubayada i pa, ‘Guyau, apo lawa luemoemota hotahi hina luyagohana?’ Ma lawa ugolihi i baha nae i pa, ");
INSERT INTO tbo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","‘Ona wileta kadidili duma po mateta wodinadinana ugolina ona honoga lui. Matababana lawa boluhi apo hina wileta ipa hina lui ma apega emoemotahi. ");
INSERT INTO tbo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mehougana numa taniwagana ina wotowolo po mateta ina guduya, apo ona tugudu po u uputa ona laitutou ma ona pa, “Bada, ubeiyai gudu una hoeya.” ‘Ma apo ami baha ina wimiheya ina pa, “Miyei o nei? Ega ata hanapugemi.” ");
INSERT INTO tbo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‘Apoma apo taumi ona tugudu po ona pa, “Tam po tiyai tamam po ta umuna gogona. Ma i u meyagai u iatatiyana.” ");
INSERT INTO tbo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","‘Tamogi tauna apo ina pa, “A paliwelemi ega ata hanapugemi; miyei o nei. Amaka ma ona nehaleu, taumi tu dewaapapoe.” ");
INSERT INTO tbo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","‘Hougana Abelaham po Isako po Yakobo po tu bahapiko atapuhi apo noka hosi Yaubada anani taniwaga u hinena ona gagalehi ma taumi apo u uputa po tou ma omhanakidiyana ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kabudala anani geleta po anani yoli po tupo bauli po tupo yawana ugolihi apo lawa hina nei. Ma apo hina tugula gogona hau ani am Yaubada anani taniwaga ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Amalai gehouhi he tahatahaya apo hina wimuli. Ma amalai gehouhi he imuli apo hina tahaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Noka hougana ugolina Palisi lawahi gehouhi hi nei po Yesu ugolina hi baha nae hi pa, ‘Geka dobuna una nehaleya babana Heloda nugonugona ipa ina unim” ");
INSERT INTO tbo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma tauna ugolihi i baha nae i pa, ‘Ona nae po noka gamogamona ona paliweleya ona pa, “Amalai po haumalatom alugo apapoehi a iyagahi po lawa a lauyawahihi. Ma iyeta witonugana ugolina apo u bagibagi a wikokowi.” ");
INSERT INTO tbo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tamogi amalai po haumalatom po haumalatom meme ipa u tahaya a wotagoya po a nenae. Matababana Yaubada a tu bahapiko ipa ega uheiya hina ununi ma u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‘Aee, kihoni Yelusalem, kihoni Yelusalem, tam tu bahapiko e ununihi po Yaubada a tu baha e laugaimahi. Houga i dao ipa natunatum a lugoogonihi po mei kamkam apapenei natunatuna e talatalahagauhi. Ma ega uta palihaleu po ata dewaya. ");
INSERT INTO tbo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ugolinei ma apo Yaubada am numa dalabu baneina ina nehaleya. Ma a paliwelemi, apega ona galeu a sigana u houga a gunawileu po ona pa, “Tam Guyau gowanei e nenei to talahiyougogem.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Dalabu gehouna Yesu i nae Palisi lawahi hai tu tahaya a u numa po ipa hina am. Noka hougana lawa hi todi ma hi gagalena imahiyeya. ");
INSERT INTO tbo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma lawa gehouna nimana po aena haahanahi i nei Yesu ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Yesu Palisi lawahi po lugagayo tanitaniwagahi i lubayadehi i pa, ‘Ata lugagayo i baheya i pa lawa hau dalabu ta lauyawahihi, bo eega?’ ");
INSERT INTO tbo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma tauhi ega awai hita baheya. Apoma Yesu lawana i waya po i luyawahi ma i himili po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma ugolihi i baha nae i pa, ‘Itapa iyai gehoum natum bo am gamogamo ita peu hopu domo u hinena hau dalabu, moina apega mala emosi ma ota teina hepaya?’ ");
INSERT INTO tbo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tamogi geka a bahana ega ipa hina wimiheya. ");
INSERT INTO tbo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu i galena tuhagaya naka iyawoi hi otugehi po hi nenei ani tugula dewadewahi hi iteina. Ega yaka geka paliluwaluwana i paliwelehi i pa, ");
INSERT INTO tbo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‘Mehougana iyai ina otugem po una nenae tawine tolehana ugolina, ega ani tugula gegena ugolina una tugutugula. Meka po lawa katugaena ma apoma tam hi otugena po e nenei, ");
INSERT INTO tbo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ma lawana iyai ami luwaga i ototugemi apo ina nehi po ugolim ina baha ina pa, “Geka ani tugulana geka lawana una weleya.” Ma tam apoma a wihinimayam ani tugula apapoena ugolina una tugula. ");
INSERT INTO tbo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tamogi mehougana iyai ina otugem yaka una nae po ani tugula apapoena ugolina una tugula, yaka tu otugem apo ina nehi po ugolim ina pa, “Tulau, una towolo po una megeleta ani tugula dewadewana ugolina.” Ee, apoma apo iyawoi mitehi o tugutugula hina galena hepam. ");
INSERT INTO tbo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Matababana iyai e wohepa meya apo ina hopu ma iyai e wohopunena meya apo ina gae.’ ");
INSERT INTO tbo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu gasi i baha nae lawana iyai i ototugeya ugolina i pa, ‘Am baneina una dewadewaya iyetei bo ibigei hougana, ega am lawa bo walewalehim bo am guguni lawahi bo tu wigapola lawahi una ototugehi. Meka po apo hina otugem gasi po am yam hina lidumaluya. ");
INSERT INTO tbo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tamogi hougana una toletoleha, tu dayadayabu po tu habehabelu tu ae apapoe po tu matakeke una ototugehi. ");
INSERT INTO tbo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yaka Yaubada apo ina kawaidewedewem babana tauhi ega emoemotahi hina lidumalum. Tu dewadumalu hai towolo meme iyetana ugolina apo Yaubada ina lidumalum.’ ");
INSERT INTO tbo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lawa gehouna Yesu mitehi hi tugutugula hougana geka bahahi i noonolihi po i baha nae ugolina i pa, ‘Iyawoi Yaubada anani taniwaga u hinena tu am tauhi tu kaohadiidiga.’ ");
INSERT INTO tbo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Yesu i baha lawana ugolina i pa, ‘Houga gehouna lawa gehouna toleha baneina i dewaya ma bolu i otugehi. ");
INSERT INTO tbo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hougana apo am ma a tu bagibagi i himili po i nae a tu am ugolihi i wipaliwelena i pa, “Ona nei babana ginouli atapuna amaka i nonogo.” ");
INSERT INTO tbo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","‘Tamogi atapuhina emoemotahi hi yampalibui ma i nae po hi kokoe. Lawa tahatahayana tu bagibagina i paliweleya i pa, “Hipuli a gimaleya po apo a nae po a galeya. Tinani baneina ma ega ona nugonugotuhuwe.” ");
INSERT INTO tbo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‘Ma lawa gehouna i pa, “Bulumakau basiyawa luwaga a gimalehi po apo a nae po a galena imahiyehi. Tinani baneina ma ega ona nugonugotuhuwe.” ");
INSERT INTO tbo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‘Ma gehouna i pa, “Geka amalai hotana a tawine po apega a nehi.” ");
INSERT INTO tbo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","‘Ega yaka tu bagibagina i gunawileya po ginouli atapuhi a bada i paliweleya. Apoma badana i luuyogigai po a tu bagibagina ugolina i baha nae i pa, “Bulibulili una hopu geka meyageina tahayana baneina po habuluna ugolihi. Ma tu dayadayabu po tu habehabelu po tu matakeke po tu aeapapoe una neihi mai.” ");
INSERT INTO tbo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Ma tu bagibagina i nae po i gunawileya po i baha i pa, “Bada, awai u bahebaheya amaka a dewaya ma gaogao baneina e mamae ega lawana.” ");
INSERT INTO tbo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Ega yaka badana a tu bagibagina ugolina i baha i pa, “Una hopu po una nae meyagai balahi daodaohi po hau pitapita po una tahaehi. Noka hosi lawa una weluwinihi po hina nei po apo u numa hina wihogoya. ");
INSERT INTO tbo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma a paliwelem, iyawoi atapuhi a ototugehi apega u yam hin’omdadani.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Houga gehouna bolu baneina Yesu mitehi hi nenae ma i luhagawileya po ugolihi i baha nae i pa, ");
INSERT INTO tbo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘Inapa iyai ina nei ugoliu po ina witubagibagi ma amana po hinana po agona po natunatuna po walewalehina po nounouna ega ina wihinigigiyehi, ma gasi a luyagohana ega ina wihinigigiyeya yaka tauna apega u hewali. ");
INSERT INTO tbo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iyai anani take ega ina awali po ina wotagou tauna apega u hewali. ");
INSERT INTO tbo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","‘Ma iyai e inugonugotuhu ipa numa gahina daodaona ina wogoya? Ginouli tahatahayana apo ina tugula ma miha ina winugonugotuhugeya. Mone emoemotana apo bagibagi ina wikokowi bo eega? ");
INSERT INTO tbo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inapa ega a mone yaka apo ogola awa ina witowolihi ma ega emoemotana ina wikokowi. Lawa atapuhi hina gagaleya po hina winameya. ");
INSERT INTO tbo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ma hina pa, “Geka lawana wogo i tugudugeya ma ega emoemotana ina wikokowi.” ");
INSERT INTO tbo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‘Inapa wasawasa gehouna a tu witona tausana 10 ina winihi po wasawasa gehouna a tu witona tausana 20 ina huluhuluya. Yaka apo ina tugula ma ina winugonugotuhu tahaya a kadidili emoemotana bo eega? ");
INSERT INTO tbo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma inapa eega yaka wasawasa tulana a mawa daodaona ma apo baha tu hihiwa ina himili po nugodumola tahayahi ina lubayadeya. ");
INSERT INTO tbo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ugolinei ma iyai ginouli atapuhi galinei ega ina wihinigigiyehi yaka tauna apega u hewali. ");
INSERT INTO tbo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Niha ginouli dewadewana ma dagihana ina kokoe ega emoemotana po ina dagiha meme. ");
INSERT INTO tbo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","‘Hipuli binei bo mayau tobutobuna binei ega ita dewadewa yaka apo hina haleya. Tam iyai waitanigam una lautanigana.’ ");
INSERT INTO tbo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Houga gehouna takisi tu tama po tu apapoe gehouhi hi nei ipa Yesu a baha hina nonolihi. ");
INSERT INTO tbo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma Palisi lawahi po lugagayo tanitaniwagahi hi yampili hi pa, ‘Geka lawana tu apapoe e kaokaohehi po mitehi he’mam.’ ");
INSERT INTO tbo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ega yaka Yesu geka paliluwaluwana ugolihi i baheya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‘Apo lawa gehouna a sipi magouhi 100 ma emosi ita welupowa, apo awai ina dewaya? Apo hau balabala magouhi 99 hina mamae ma ina nae po emosina ina bibiheya a sigana ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hougana i tutuhagaya apo ina kaoha duma po ina wohepaya po u awalana ina houni ");
INSERT INTO tbo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ina awali po ina gunawileya. Apoma apo a lawa po lawa u liyaliyana tu mae ina otugehi po ina baha ina pa, “Taumi miteu ta kaoha babana u sipi i weluwelupowa amaka a tuhagaya.” ");
INSERT INTO tbo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A paliwelemi, yada galenana geka pitenana. Tu apapoe emosi a nugobui binei kaohana apo ina lata lagona duma ma apoma tu dewadumalu magouhi 99 hai nugobui binei. Matababana tauhi apo awai binei ma hina nugobui? ");
INSERT INTO tbo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‘Apo wawine gehouna a kina bibitutuhi magouhi 10, ma emosi ina lugowadeya, apo awai ina dewaya? Apo lampa ina tunuya ma a numa ina wotamitami. Ma dobu atapuna ina bibiheya a sigana ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hougana i tutuhagaya apo a lawa po lawa u liyaliyana tu mae ina otugehi po ugolihi ina baha ina pa, “Taumi miteu ta kaoha babana u mone i laugowadeya amaka a tuhagaya.” ");
INSERT INTO tbo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A paliwelemi, geka ani galenana mei hau yada. Tu apapoe emosi a nugobui ugolina apo Yaubada a tu winoyanoya hina kaoha.’ ");
INSERT INTO tbo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Yesu i baha i pa, ‘Lawa gehouna natunatuna ololotohi luwaga. ");
INSERT INTO tbo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma habuluna amana ugolina i baha nae i pa, “Amau, ginouli awai apo una woodamaneya ugoliu una weleu.” Ega yaka lawana a ginouli i kahaya natunatuna luwaga ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‘Hi mae po iyeta wabihaga ma natunana habulunana a ginouli i gimalena halehi. Ma monena i waya po i nae dobu mawana daodaona ugolina. Noka hosi a nugowai i meme tagohi ma a mone i lauguyoguyougeya. ");
INSERT INTO tbo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hougana mone atapuna i ihulu pahi ma gomala baneina noka dobuna i launi po tauna ugolina ega awai gehouna. ");
INSERT INTO tbo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ega yaka i nae po noka dobuna lawana gehouna ugolina i kawabagibagi. Ma hi himili po i nae po polo i ianihi. ");
INSERT INTO tbo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A luhogala baneina ipa polo hai amgei in’omam babana am i hilage ma ega iyai aniani ita weleya. ");
INSERT INTO tbo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‘Apoma a winugonugotuhu i dumalu ma i baha i pa, “Aee, Amau a tu bagibagi hai yam i lata duma ma geka hosi omhilage i tapetapeuniu. ");
INSERT INTO tbo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Apo a wotowolo po a nae amau ugolina po ana pa, ‘Amau, Yaubada u matana po tam u matam apapoe a dewaya. ");
INSERT INTO tbo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tau amaka ma ega una kawakawainatuneu babana ega u dewadewa awai. Ma una winiu po mei am tu bagibagi gehouna.’” ");
INSERT INTO tbo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ega yaka i wotowolo po i nae amana ugolina. ‘Tauna yohola uheiya ma amana i gagalena nae po nugonugona i wiyuweya. Ma i wibulibulili nae po natuna i talahagauya ma niuna i yagoni. ");
INSERT INTO tbo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Ma natunana i baha i pa, “Amau, Yaubada u matana po u matam apapoe a dewaya. Amaka ma ega una kawakawainatuneu babana ega u dewadewa awai gehouna.” ");
INSERT INTO tbo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Tamogi amana a tu bagibagi ugolihi i baha i pa, “Bulibulili! Kaleko dewadewa dumana ona neiyai po ona wioteni. Ma nima kope u nima gigina ona houni ma ae humahuma u aena ona giyehi. ");
INSERT INTO tbo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Apoma ona nae po bulumakau yaubona haahanana ona uni po tan’omgogona ma ta kaoha. ");
INSERT INTO tbo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Matababana geka natuwena i hilage ma amalai i luyagohana. Tauna i lugowadeya ma amalai i gunawileya.” Ee, apoma hi tugudu po hina kaoha. ");
INSERT INTO tbo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Geka dewahi hi nenae ma lawana natuna baneina hau tano i wobagibagi. Hougana i gunawileya po i nei po numana i tutuliyaliyani naka lougo po hala gololohi i nonolihi. ");
INSERT INTO tbo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ega yaka tu bagibagi gehouna i otugeya po i lubayadeya i pa, “Noka awai he dewadewaya?” ");
INSERT INTO tbo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma tu bagibagina i baha i pa, “Walehim i gunawilena meya po amami i baha po bulumakau haahanana to uni. Matababana a lauyagohanana po a dewadewana ma i tuhaga meya.” ");
INSERT INTO tbo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‘Ma tugona uyona i gigai duma po lui i wihinigigiyeya. Ega yaka amana i hopu mai po i wihinigali ipa ina lui. ");
INSERT INTO tbo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma tauna amana ugolina i baha nae i pa, “U galeya geka bolimahi magomagouhi a puloulem po ega ata iponahahalenem. Ma ega muhala gehouna uta wele dadaniu po u lawa mitehi tota am ma tota kaoha gogona. ");
INSERT INTO tbo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma geka natumna am ginouli tu matamaga ugolihi i luguyoguyougehi. Ma i gunagunawileya po a bulumakau haahanana u uni.” ");
INSERT INTO tbo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Ma lawana natuna ugolina i baha i pa, “Natuwe, tam houga daodaona tau miteu po ginouli atapuhi galiugei naka gasi tam galimgei. ");
INSERT INTO tbo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma i dewadewa tan’omgogona po ta kaoha. Matababana geka walehimna i hilage ma amalai i luyagohana. Ma gasi i lugowadeya ma amalai i gunawilena meya.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu gasi a hewahewali ugolihi i baha i pa, ‘Lawa waigapolana a tu bagibagi a gapola i gagalena itetehi. Ma lawa tu wigapola hi paliweleya naka a tu galena itetena a mone i lauguyoguyougeya. ");
INSERT INTO tbo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ega yaka a tu galena itetena i otugeya po ugolina i baha i pa, “Geka am dewa awai a noonoli? Am galena itete u hinena ma mone a lata awai i luilui mai po i hopuhopu atapuna una giluma hopuneya po a galeya, matababana apega una itugalena itete meme.” ");
INSERT INTO tbo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ma tu bagibagina i paliwelena meya i pa, “U bada apo u bagibagi ugolina ina telehopuneu ma awai apo a dewaya? Hau omhala ega ata kadidili ma lupali a wihinimaeya. ");
INSERT INTO tbo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oo, a hanapugeya apo awai a dewaya po u bagibagi ugolina ina teletelehopuneu apo lawa hina kaoheu po hai u numa a luilui.” ");
INSERT INTO tbo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","‘Ega yaka tu tama yaga a badana ugolina atapuhi i otugehi po emosi emosi ma i laubayadehi. Lawa tahatahayana ugolina i baha i pa, “U bada ugolina am yaga, a lata awai?” ");
INSERT INTO tbo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Ma tauna i pa, “Bunama mihana kina 1,000.” ‘Ma tu galena itetena i pa, “Geka am yaga pepana. Bulibulili una tugula ma kina 500 una gilumihi.” ");
INSERT INTO tbo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","‘Apoma gehouna i lubayadeya i pa, “Ma tam am yaga a lata awai?” ‘Ma tauna i pa, “Palawa baekihi 1,000.” ‘Tu galena itetena i pa, “Geka am yaga pepana una waya po baeki 800 una gilumihi.” ");
INSERT INTO tbo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","‘Badana a tu galena itetena waikoyakoyamana a winugonugotuhu imahi binei i huneya. Matababana geka hipulina lawahi u hanapu duma gapola bagibagina ubeina ma apoma yayata lawahi. ");
INSERT INTO tbo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ma a paliwelemi, taumi ami witulana ona dewaya hipuli gapolana ugolinei po mehougana ina kokoe po tam apo Yaubada ina winim ani mae memewahagana ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Iyai ginouli habuluna ugolina a galena itete i dewadewa yaka ginouli baneihi lawa hina weleya po ina galena iteteya. Ma iyai ginouli habuluhi ugolihi a galena itete i apapoe yaka apega ginouli baneihi ina galena itetehi. ");
INSERT INTO tbo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Inapa hipuli gapolahi ugolihi ega una galena itete imahi, yaka apega iyai gehouna gapola moinahi u nimam ina hounihi? ");
INSERT INTO tbo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma inapa lawa gehouna a ginouli ugolim ega una galena itete imahiyeya yaka apega iyai gehouna ginouli galimgei u nimam ina houni? ");
INSERT INTO tbo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Ega emoemotana tam tuawam ma babada luwaga hai bagibagi una pouleya. Matababana emosi apo una luhogaleya ma gehounana una wihinigigiyeya. Ma apo emosi una ilataya ma gehounana una galena iapapoeya. Apega Yaubada ma gapola una poulena luwagehi.’ ");
INSERT INTO tbo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Palisi lawana gehouna geka bahahi atapuhi hi noonolihi po Yesu hi lumutubougeya babana tauhi mone tu luhogalenana. ");
INSERT INTO tbo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yaka Yesu i baha nae ugolihi i pa, ‘Taumi lawa u matahi o bahena memi po o pa tu dumalu. Tamogi Yaubada nugonugomi i hanapugeya. Matababana lawa u hayahi awai hi gagalena hepaya naka Yaubada u matana ginouli yabayababa. ");
INSERT INTO tbo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Mose a lugagayo po tu bahapiko hai omgiluma i bagibagi po i nei po Yoni bapatiso a u houga. Noka hosi ma i wawala po i nenei naka Yaubada anani taniwaga tuwegana dewadewana he guuguyeya, ma tu kadidili hai kadidiligei he luiluiya. ");
INSERT INTO tbo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tamogi yada ma hipuli hai yababa ega hita wipilipili lagona ma apoma ginouli awai habulu hotana hau lugagayo wihalenana. ");
INSERT INTO tbo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‘Oloto awai agona ina haleya ma wawine gehouna ina lawagi naka e matamatamaga. Ma oloto awai ihabana ina lawagi naka e matamatamaga.’ ");
INSERT INTO tbo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu i ibaabani i pa, ‘Tu wigapola lawana gehouna kaleko mihahi baneina i otenihi ma i meimahi po iyeta emosi po emosi i toletoleha ma i mamae. ");
INSERT INTO tbo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma a u mateta tu dayadayabu gehouna gowana Lasalo hinina kelo i hogoya ma i mamae. ");
INSERT INTO tbo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I itumagana ipa apo tu wigapola a pata ugolina aniani tupotupohi hina holuholu ina anihi. Tauna kedewa hi nei po kelona hi lemolemoya. ");
INSERT INTO tbo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","‘Tu dayadayabuna i hilage po Yaubada a tu winoyanoya hi awali po Abelaham u hadana hi wituguli. Tu wigapolana gasi i hilage po hi guluwi ");
INSERT INTO tbo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","po u hiyoyawa ma mayau alalatana u hinena matana i tahepaya po Abelaham uheiya duma Lasalo u hadana ma i galehi. ");
INSERT INTO tbo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ega yaka i otu labatana i pa, “Gogau Abelaham, una lunugotootogogeu, ma Lasalo una himili po hau goila nimana ina taiyoli po menau ina linigi, babana wiyuwa a wohilahilage duma geka alatana u hinena.” ");
INSERT INTO tbo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Ma Abelaham i pa, “Gogau, am luyagohana iyetahi una nugotuhuhi. Tam ginouli dewadewahi u winihi ma Lasalo ginouli apapoehi i winihi. Tamogi tauna amalai i mehinihegoya ma tam hau wiyuwa. ");
INSERT INTO tbo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma noka ega tuawana. Tam ma tiyai ma u tipolita naka domo daodaona e mamae. Iyawoi nugonugohi geka hosi ma hina damanahi ugolim apega emoemotahi. Ma gasi apega iyai naka hosi ma ina damanai ugoliyai.” ");
INSERT INTO tbo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‘Ma tu wigapolana i baha i pa, “Heki, gogau Abelaham, a laupaliyem. Lasalo una himili po ina nae amau a u numa. ");
INSERT INTO tbo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Matababana walewalehiu nimitutu noka hosi tauna ina paliwelehi po u mae ega hina meme tagoya. Meka po tauhi gasi apo hina nei geka wiyuwana meyageina ugolina.” ");
INSERT INTO tbo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‘Tamogi Abelaham i baha i pa, “Mose po tu bahapiko hai giluma walewalehim ugolihi tauna tu paliwelehi. Awai hi bahebahehi hilaki hita nonolihi.” ");
INSERT INTO tbo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Ma tu wigapolana i pa, “Gogau Abelaham, naka ega emoemotana. Tamogi inapa lawa gehouna hau hilage ma ina towolo meme po ina nae ugolihi apo hina nugobui.” ");
INSERT INTO tbo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Abelaham ugolina i baha nae i pa, “Inapa Mose po tu bahapiko hai baha ega hina nonolihi yaka apega hina nugotona. Hawena lawa hau hilage ma i towolo meme ma apega hina nugotona.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu a hewahewali ugolihi i pa, ‘Ani peu ludadanahi apo hina nei, tamogi iyai i dewahi po he waawala tauna tu nugodubu. ");
INSERT INTO tbo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Apo ita dewadewa duma itapa gaima baneina u gadouna hita duli ma u boga hita halena hopuneya. Ma ega ita dewadewa geka tu tapitapiya ina dewaya po apapoe ina dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Awai o dewadewahi ipa ona gagalena imahi. ‘Inapa walehim apapoe ina dewaya yaka una paliyeya. Ma inapa paligigila ina laupaliyeya yaka una paligigili. ");
INSERT INTO tbo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma inapa ugolim apapoe mala 7 iyetei ina dewaya ma ina luhagawileya po mala 7 ina pa, “A mamala dumam ma una paligigiliu,” tam ipa una paligigili.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tu wituwetuwega Guyau ugolina hi baha hi pa, ‘I witumagana una wilatahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma Guyau i pa, ‘Itapa ami witumagana mei ihagila polana apo geka mayouna ugolina ota pa, “Una gunahapum po u boga una ugota mem,” apo ita wiponawogogemi.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu i baha nae ugolihi i pa, ‘Iyai gehouna a tu poula hau tano ita laidogo bo sipi ita gagalena itete po ita gunagunawileya ma apo ugolina ita pa, “Una bulili mai po una am,” bo? ");
INSERT INTO tbo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Apeega. Tamogi apo ita pa, “U yam una wononogogeya ma am ani poula kalekona una oteni ma una pupouleu a sigana a am ma a uma woloe. Ma muliyei apoma una am ma una uma.” ");
INSERT INTO tbo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tu poulana apega ina mamali babana a baha tuawana i wiponawogogehi. ");
INSERT INTO tbo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ugolinei emoemotana mei taumi. Hougana ami bagibagi atapuna a bahebaheya ona wikokowi ona pa, “Ega i dewadewa awai binei ipa una maamaliyai babana tiyai tu poula hota. Ma i bagibagi tuawana to dewaya.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu Yelusalem binei i nenae naka Samaliya sigana ma Galili sigana ma tipolihiyei i honoga po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma meyagai gehouna ugolina i luilui po olooloto lepelepelohi magouhi 10 uheiya hi towotowolo ma i galehi. ");
INSERT INTO tbo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tauhi hi otu hi pa, ‘Bada Yesu, una lunugotootogeiyai.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hougana i gagalehi po ugolihi i baha nae i pa, ‘Ona nae po Yaubada tu witalaguyaba ugolihi ona wogeletena memi.’ Ma hougana tauhi hi nenae ma kelohi hi poi. ");
INSERT INTO tbo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Apoma tulahi gehouna i gagalena meya po i luyagohana yaka ponana i lata ma Yaubada i wotalagiyeya ma i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","I nei po Yesu u aena i polou hopu ma i mamali. Tauna lawa Samaliyagei. ");
INSERT INTO tbo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Apoma Yesu i pa, ‘Lawa magouhi 10 hi luyagohana. Ma magouhi 9 meka? ");
INSERT INTO tbo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iyowai po geka tu wihewahewa tuawa hotana i gunawileya po Yaubada i wotalagiyeya?’ ");
INSERT INTO tbo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma i baha nae lawana ugolina i pa, ‘Una towolo po una nae. Amaka am witumagana i wiluyagohanim.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yaubada anani taniwaga a nei binei Palisi lawahi Yesu hi lubayadeya po tauna hai baha i wimiheya i pa, ‘Yaubada anani taniwaga a nei apega wekiwekilalana awai hina galeya. ");
INSERT INTO tbo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Apega iyai ina pa, “Gegeka ona galeya,” bo “Nonoka ona galeya.” Matababana Yaubada anani taniwaga naka taumi u hayami.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Apoma i baha nae a hewahewali ugolihi i pa, ‘Iyeta he nenei apo ami luhogala ipa Lawa Moinau u houga nei hilaki ota galeya, ma apega ona galeya. ");
INSERT INTO tbo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma apo u nei binei ugolimi hina ibaabani hina pa, “Noka hosi ona galena nae,” bo “Geka hosi ona galena mai.” Tamogi ega ona nenae po ega ona wotagohi. ");
INSERT INTO tbo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Matababana mei namanamala e lunamaleya po yada u aliyana e yayahi naka e nei po e nae po u tupona. Naka pitenana apo Lawa Moinau u iyeta ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tamogi wiyuwa magomagouhi apo a wialonihi po geka hapanana lawahi apo hina wihinigigiyeu. ");
INSERT INTO tbo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","‘Mei Nowa a houga emoemotana mei gasi apo Lawa Moinau u houga, ");
INSERT INTO tbo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","babana Nowa a houga ugolina lawa hi’mam po hi umuma po hi kawakawalulu po hi tawitawine ma Nowa wam ugolina i gelu. Ma goila i hopu po atapuhi i unihi. ");
INSERT INTO tbo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‘Emoemotana mei gasi Lota a u houga. Lawa atapuhi hi’mam po hi umuma po hi gimagimala po hilaupehi po hi launuma. ");
INSERT INTO tbo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iyetana Lota Sodom i nenehaleya, Yaubada mayau alalatana yadei i himila hopu neiyai po atapuhi i unihi. ");
INSERT INTO tbo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","‘Noka pitenana apo Lawa Moinau u iyeta lugeletana hougana ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Noka iyetana ugolina iyai a numa uputana e mamae apega ina lui po a ginouli ina tamatama. Emoemotana gasi iyai hau tano ina wobagibagi, apega ina gunawileya a kaleko binei. ");
INSERT INTO tbo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lota agona ona nugotuhuya. ");
INSERT INTO tbo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Iyai a luyagohana ina bibiyeha yaka apo ina haleya. Ma iyai a luyagohana ina haleya yaka apo ina womomohi. ");
INSERT INTO tbo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A paliwelemi, noka upomna apo lawa tulana mitehi hau liyapa hina eneno po emosi Yaubada ina wihaleya ma emosi ina mamae. ");
INSERT INTO tbo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wiwine luwaga apo pegapega hina yamapu po emosi Yaubada ina wihaleya ma emosi ina mamae. ");
INSERT INTO tbo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ololoto luwaga apo hau tano, po emosi Yaubada ina wihaleya ma emosi ina mamae.’ ");
INSERT INTO tbo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu a hewahewali hi lubayadeya hi pa, ‘Guyau meka hosi?’ Ma tauna i pa, ‘Meka hosi waewae hina yamtuboina naka hosi popoya.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Apoma Yesu a hewahewali geka paliluwaluwana i paliwelehi po ipa ina wiatatiyehi naka houga daodaona hina laupali ma ega hina nugonugotapiya. ");
INSERT INTO tbo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ma i pa, ‘Meyagai baneina gehouna ugolina tu luhetala gehouna i mamae. Tauna ega Yaubada ita matouteya po lawa ega ita iyateyatehi. ");
INSERT INTO tbo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma noka meyageina emosina ugolina hiwape gehouna i nenei tu luhetalana ugolina ma i bahabaha gawata i pa, “Hau luhetala ega u gawiya una haguhaguya ma dumalugei una luhetala.” ");
INSERT INTO tbo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","‘Tu luhetalana i lauhinigigai ma i mae po ega daona ma tuawana i baha i pa, “Hawena Yaubada ega ata matomatouteya bo lawa ega ata iyateyatehi, ");
INSERT INTO tbo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma geka hiwapena e ihinigaliu binei apo dumalugei a luhetala. Ma inapa ega yaka apo ina nenegawatai po kamnau ina wiapapoeya.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Guyau i baha i pa, ‘Noka tu luhetalana woapapoena awai i bahebaheya ona nonoli. ");
INSERT INTO tbo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yaubada a lawa i winaganihi yaka apo hai pilipili ugolihiyei ina haguhi? Tauhi iyawoi hagu binei iyeta po uguwa ugolina he tutou nae, yaka apo ina hagu yagiyaginehi. ");
INSERT INTO tbo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A palipaliwelemi hai pilipili ugolihiyei apo ina hagu yagiyaginehi po dumalu ina welehi. Tamogi hougana Lawa Moinau apo a nenei hau hipuli witumagana a tuhagaya, bo eega?’ ");
INSERT INTO tbo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lawa gehouhi hai dewadumalu hi witumaganehi ma lawa atapuhi he gagalena iapapoenihi. Tauhi ugolihi gasi Yesu geka paliluwaluwana i baheya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","‘Lawa luwaga hi lui numa dalabu baneina u hinena ipa hina lupali. Emosi Palisi lawana ma gehounana takisi tu tama. ");
INSERT INTO tbo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisi lawana tuawana i towolo nae u hiyei ma i lupali i pa, “Yaubada a mamalim babana tau ega mei lawa gehouhi. Tauhi hi’mboho po he ikoyakoyama po he matamatamaga. A mamalim babana tau ega mei noka takisi tu tamana. ");
INSERT INTO tbo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tau dalabu emosi po emosi u hinena iyeta luwaga u hinena a iyohi ma ega at’omam. Ma u mone a hiyawi po magouna 10 a tuhagaya yaka emosi a houna liyeya po tam a welewelem.” ");
INSERT INTO tbo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","‘Ma takisi tu tamana uheiya i towotowolo ega emoemotana ipa ina luwatateya hau yada. Ma tamogi nugonugona i ilawi ma i bahabaha i pa, “Yaubada, tu apapoe tau, una lunugotootogogeu.” ");
INSERT INTO tbo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","‘A paliwelemi, geka tauna lawana Yaubada u matana i dumalu ma apoma gehounana, ma apoma i hopu po i nae a u numa. Matababana iyai e wohepa meya apo ina hopu ma iyai e wohopunena meya apo Yaubada ina wohepaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lawa gehouhi logaloga hi neihi mai Yesu ugolina ipa ina wotepanihi ma a hewahewali hi gagalehi po hi paliyehi. ");
INSERT INTO tbo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma tamogi Yesu logalogahi i otugehi po hi nae ugolina ma i baha i pa, ‘Logaloga ona palihalehi po hina nenei ugoliu ma ega ona guduguduhi. Matababana lawa mei geka logalogahi apo Yaubada anani taniwaga hina luiya. ");
INSERT INTO tbo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A baha duma ugolimi, apo iyawoi Yaubada anani taniwaga hina luiluiya ipa nugonugohi mei logaloga hai winugonugotuhu.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Taniwaga gehouna Yesu i lubayadeya i pa, ‘Bada dewadewam, apo awai a dewaya po Yaubada luyagohana tuwetuwenai ina weleu?’ ");
INSERT INTO tbo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Yesu i baha ugolina i pa, ‘Am winugonugotuhu awai binei u kawaidewadewageu? Ega iyai ita dewadewa ma Yaubada tuawana. ");
INSERT INTO tbo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Lugagayo u hanapugehi ma hi baheya hi pa, “Ega una matamatamaga, ega una yamunugo, ega una danedanene, ega una igou koyakoyama, amam po hinam una wiyateyatehi.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma lawana i baha i pa, ‘Geka lugagayohi atapuhi a habuluwe a wootagohi ma i nei po amalai.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu geka bahana i noonoli po i baha nae ugolina i pa, ‘Ginouli emosi hotana ega ugolim. Gapola atapuhi ugolim una gimalena halehi po monehi tu dayadayabu una welehi. Apo hau yada una wigapola. Ma una nei po una wotagou.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tamogi lawana geka babahi i noonolihi po i nugodubu duma babana tauna i wigapola duma. ");
INSERT INTO tbo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu lawana i gagaleya po i pa, ‘Tu wigapola lawahi hai lui Yaubada anani taniwaga ugolina i witai. ");
INSERT INTO tbo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamela ega emoemotana heyau domona ina honogi. Ma tu wigapola lawana a lui Yaubada anani taniwaga ugolina i wipilipili lagona ma apoma noka gamogamona a honoga.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lawa iyawoi geka bahana hi noonoli po hi lubayada hi pa, ‘Ma heki, iyai apoma apo luyagohana ina tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Yesu i pa, ‘Lawa ugolihi luyagohana tuhagana ega emoemotahi ma Yaubada ugolina emoemotana.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Apoma Pita i baha i pa, ‘U galeya, i meyagai to nehalehi ma to wootagom.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma Yesu ugolihi i baha i pa, ‘A baha duma ugolimi, apo iyai a meyagai bo agona bo walewalehina bo amana po hinana bo natunatuna Yaubada anani taniwaga binei ma ina nehalehi, ");
INSERT INTO tbo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tauna geka hougana apo mihana ina tuhaga lagoneya ma houga he nenei luyagohana ega sigana apo ina tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu a hewahewali magouhi 12 i winihi po hi meliya ma ugolihi i baha i pa, ‘Ona lautanigana, tauta ta nenae u Yelusalem, ma tu bahapiko ginouli atapuna Lawa Moinau ubeu ma hi gilugilumi apo ina limoineya. ");
INSERT INTO tbo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tu meuputa lawahi ugolihi apo hina houna damaneu, ma tauhi apo hina paliguyoguyougeu po hina dewa guyougeu po hina howahowau. ");
INSERT INTO tbo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma apo hina kodikodiliu po ina kokoe ma apo hina wihilageniu. Ma iyeta witonugana ugolina apo a towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tamogi a hewahewali geka bahahi ega hita nugotuhu tuhagahi. Bahahi anohi ega hita lugeletehi tauhi ugolihi po awai i ibaabaniyeya ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu Yeliko i tutuliyaliyani ma lawa matana keekena tahaya u hadana i tugula ma i laupali. ");
INSERT INTO tbo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hougana bolu hi nei po hi weluwileya ma i lubayada i pa, ‘Geka awai?’ ");
INSERT INTO tbo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma hi paliweleya hi pa, ‘Yesu Nasaletagei i nei po e nenae.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma tauna i otu i pa, ‘Yesu Dawita gogana, hilaki uta lunugotootogogeu!’ ");
INSERT INTO tbo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma iyawoi bolu u naohi hi lahaya ma hi paliyeya hi pa, ‘Hei, una genuwana.’ Tamogi tauna i otu labatana i pa, ‘Dawita gogana, hilaki uta lunugotootogogeu!’ ");
INSERT INTO tbo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ega yaka Yesu i tutowolo ma i baha po ipa tu matakekena hina neiyai ugolina. Hougana i nei po u liyaliyana ma Yesu i lubayadeya i pa, ");
INSERT INTO tbo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‘Am luhogala ipa bimgei a dewaya?’ Ma tauna i pa, ‘Guyau, u luhogala ipa matau hina dewadewa.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Yesu ugolina i baha i pa, ‘Una galena meme. Am witumagana i luyawahim.’ ");
INSERT INTO tbo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mala emosi ma matana i galeneya po Yaubada i maamali ma Yesu i wotagoya po hi nae. Ma lawa atapuhi geka dewana hi gagaleya po Yaubada hi wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Yeliko i luiya po i nenae. ");
INSERT INTO tbo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma noka hosi takisi tu tama hai bada waigapolana gowana Sakiyasi i mamae. ");
INSERT INTO tbo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tauna i ileta ipa Yesu ina galeya naka iyowai ma ega emoemotana babana gahina i kuku duma ma bolu hi itugaagali. ");
INSERT INTO tbo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ega yaka i bulili tahatahaya po Yesu apo tahayanei ina nenae mayau gehouna i geini. ");
INSERT INTO tbo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ma hougana Yesu i nei po mayouna ugolina ma i luwatateya po Sakiyasi ugolina i baha i pa, ‘Una hopu yagiyagina mai babana amalai apo am u numa a mae.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ega yaka Sakiyasi i hopu yagiyagina po a kaohana Yesu i weluwaya. ");
INSERT INTO tbo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma lawa atapuhi hi gagaleya po hi’mpili ma hi pa, ‘Geka lawana i witoumana nae tu apapoe a u numa.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma Sakiyasi i towolo po Guyau ugolina i baha i pa, ‘Guyau, una galeu. U gapola a kahaya po tupona apo tu dayadayabu a welehi ma tupona galiugei. Ma inapa iyai amaka koyamagei ma a ginouli a tamihi yaka apo ginoulihi hai lata mala wohepali a weleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Yesu i baha nae ugolina i pa, ‘Tam Abelaham gogana gehouna ma amalai luyagohana i nei om numana u hinena. ");
INSERT INTO tbo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma Lawa Moinau a nei ipa lawa tu welupowa a bihehi po a luyawahihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu amaka Yelusalem i tutuliyaliyani yaka tu lutanigana hai lunonola powa ipa apo ega daona ma Yaubada anani taniwaga ina wogeleteya yaka geka paliluwaluwana i paliwelehi ");
INSERT INTO tbo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","i pa, ‘Tu tahaya lawana gehouna dobu mawana daodaona ugolina i nae ipa ina wiwasawasa ma ina gunawileya. ");
INSERT INTO tbo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yohola ega ita nae ma a tu bagibagi magouhi 10 i otugehi po emosi po emosi mone gole i welewelehi. Ma ugolihi i baha i pa, “Geka ugolihiyei ona gimagimala ma mone ona yamdewa a sigana a gunawileu.” ");
INSERT INTO tbo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","‘Tamogi a dobu lawahi ega hita luhogaleya po mulinei baha tu hihiwa po ipa ina pa, “Geka lawana ega nugonugoiyai ipa ina wiwasawasa ubeiyai.” ");
INSERT INTO tbo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‘Tamogi lawana i wiwasawasa ma i gunawileya po a tu bagibagihi, iyawoi mone i welewelehi i otugehi ipa hina nae ugolina. Ma mone awai hi dewadewaya ipa ina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‘Tu bagibagi tahatahayana i nei ugolina po i pa, “Bada, am mone gole emosi u weleweleu naka mone gole yagahi magouhi 10 a dewaya.” ");
INSERT INTO tbo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Ma tauna ugolina badana i baha i pa, “I haki duma. Tam tu bagibagi dewadewam. Apo meyagai baneihi magouhi 10 una galena itetehi, matababana ginouli habuluhi ugolihi emoemotana a witumaganem.” ");
INSERT INTO tbo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‘Ma tu bagibagi wiluwagana i nei po i baha i pa, “Bada, mone gole emosi u weleweleu naka mone gole yagahi nimitutu a dewaya.” ");
INSERT INTO tbo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Geka tu bagibagina ugolina i baha i pa, “Tam apo meyagai baneihi nimitutu una galena itetehi.” ");
INSERT INTO tbo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‘Apoma gehouna i nei po i baha i pa, “Bada, gee am mone gole u weleweleu naka kaleko henahenamina ugolinei a humaya ma a houna gowadi po i mamae. ");
INSERT INTO tbo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ma a lowogem babana tam lawa lauhinidoodolam. Ginouli awai ega galimgei ma apo una waya po gasi awai ega uta ugohi ma apo anona una waya.” ");
INSERT INTO tbo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Geka tu bagibagina ugolina i baha i pa, “Tam tu bagibagi apapoena. Baha awai gamomgei hi hopuhopu ugolihiyei apo a wigoum. U hanapugeya naka tau lawa lauhinidoodolau. Awai ega galiugei a wiwaya po awai ega ata ugugohi a wiwaya. ");
INSERT INTO tbo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ugolinei ma awaka po u mone ega hau banika uta houni? U gunawilana hougana ugolina u mone anai luwitanana ata waya.” ");
INSERT INTO tbo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","‘Apoma iyawoi u liyaliyana hi towotowolo ugolihi i baha i pa, “Monena gole emosi ugolina ona wihaleya po lawana iyai mone gole magouhi 10 ugolina tauna ona weleya.” ");
INSERT INTO tbo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Ma tauhi hi baha hi pa, “Bada, geka tauna ugolina amaka mone gole magouhi 10 memehi.” ");
INSERT INTO tbo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ma wasawasana i pa, “A paliwelemi, lawa atapuhi ugolihi awai e mamae apo Yaubada ina luwitanihi. Ma iyai ugolina ega awai ita mamae, hawena habulu hotana ma Yaubada apo ina wihalena pahi. ");
INSERT INTO tbo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma noka lawahi tu wigawiyeu iyawoi ega nugonugohi ipa ubeihi ana iwasawasa ona neihi mai po u matau ona unihi.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu a wibaabani i kokoe ma i welutahaeya po hi gae Yelusalem ubeina. ");
INSERT INTO tbo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hougana Betepage ma Betani oya Oliweta ugolina i tutuliyaliyanihi ma a hewahewali luwaga i himila tahaehi po i baha ");
INSERT INTO tbo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","i pa, ‘Meyagai u naomi ona nae po ona luiluiya naka hota doniki wouna yohola ega hita geluya ma e mamae, apo ona tuhagaya. Ona lupeni po ona neiyai geka hosi. ");
INSERT INTO tbo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma inapa iyai ina lubayademi ina pa, “Awai binei o lupelupeni?” yaka ona pa, “Guyau ipa ina wibagibagi.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ega yaka iyawoi i himihimilihi hi nae po iyowai i palipaliwelehi naka pitenana ma hi tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma hi lupelupeni hougana donikina taniwagana ugolihi i baha i pa, ‘Awai binei o lupelupeni?’ ");
INSERT INTO tbo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma tauhi hi pa, ‘Guyau ipa ina wibagibagi.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Apoma hi niyeya Yesu ugolina po hai kalekogei gamogamona upuna hi lutouli ma Yesu hi wigeluya. ");
INSERT INTO tbo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma i gelu po i nenae ma lawa hai kalekogei tahayana hi lutouli. ");
INSERT INTO tbo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hougana Yelusalem i tutuliyaliyani tahaya Oliweta u oyana ma i hopu po i nenae ugolina tu wotagona atapuhi hi’mtuboina. Ma manini po wipoya atapuhi hi gagalehi bihiyei ponahi i lata ma hi tugudu po Yaubada hina wotalagiyeya ");
INSERT INTO tbo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","hi pa, ‘Tam Wasawasa, Guyau gowanei e nenei Yaubada ina kawaidewedewem!’ ‘Nugodumola hau yada po ani’mhuna duma tam Gegewahagam ugolim!’ ");
INSERT INTO tbo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Apoma bolu u hinena Palisi lawahi gehouhi Yesu ugolina hi baha hi pa, ‘Bada, am hewahewali una lahahi po hina genuwana.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Yesu i baha i pa, ‘A paliwelemi, inapa hina genuwana yaka gaima apo hina tugudu po hina iototu.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hougana Yesu Yelusalem i tutuliyaliyani ma i gagaleya po i tougeya. ");
INSERT INTO tbo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma i pa, ‘Hilaki tam gasi awai nugodumola e dewadewaya uta hanapugeya. Tamogi amalai u matam i lugowadeya. ");
INSERT INTO tbo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hougana e nenei apo am gawiya anai lagenahi hina mewiiwilem ma hada atapuna ugolina hina huluhulum, ");
INSERT INTO tbo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","po hina lugoluhim po una hopu hau hipuli. Ma lawa u hinem apo hina wiapapoenihi. Numa atapuhi apo hina kokoe, apega gaima emosi u uyawena ina mamae, babana hougana Yaubada u hagumgei i nenehi ega uta galena tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Apoma Yesu numa dalabu baneina i luiya po i tugudu po tu gimagimala ina wiyagahi. ");
INSERT INTO tbo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma ugolihi i baha i pa, ‘Yaubada a Buka gilugilumana ugolina i baheya i pa, “U numa lawa hai ani lupali ubeina.” Ma taumi o buiya po “Tu danedanene hai ani megowada.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iyeta emosi po emosi numa dalabu baneina u hinena Yesu i iatatiyana. Ma tu witalaguyaba babadahi po lugagayo tanitaniwagahi po lawa tu tahaehi nugonugohi ipa hina uni. ");
INSERT INTO tbo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tamogi ega tahaya awai hita tuhagaya babana lawa atapuhi hi launonola gawateya po ega baha emosi ipa hina lauemuli. ");
INSERT INTO tbo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iyeta gehouna numa dalabu baneina u hinena Yesu lawa iatatiyehi po ugolihi tuwega dewadewana i guuguyeya, ma tu witalaguyaba babadahi po lugagayo tanitaniwagahi, mi Yudeya hai tanitaniwaga mitehi hi nei, ");
INSERT INTO tbo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","po ugolina hi pa, ‘Una paliweliyai, witaniwaga awai u waya po geka ginoulihi e dewadewahi, bo iyai geka witaniwagana i welem?’ ");
INSERT INTO tbo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu hai baha i wimiheya i pa, ‘Hapali tau gasi u lubayada a welemi. Ona paliweleu, ");
INSERT INTO tbo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoni a witaniwaga yadei i nei bo lawa ugolihiyei i nei po i ibapatiso?’ ");
INSERT INTO tbo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma tuawahi u hayahi hi ibaabani hi pa, ‘Apo awai ta baheya? Apo tana pa, “Yadei,” apo ina pa, “Awai binei ega ota witumaganeya?” ");
INSERT INTO tbo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma apo tana pa, “Lawa ugolihiyei,” apo lawa atapuhi hina lugaimata. Matababana u nugonugohi i kadidili duma naka Yoni tauna tu bahapiko gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ega yaka a baha hi wimiheya hi pa, ‘Ega tota hanapugeya miyei i nei.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Yesu ugolihi i baha i pa, ‘Tau gasi apega a paliwelemi witaniwaga awai a waya po geka ginoulihi a dewadewahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Apoma Yesu i tugudu po geka paliluwaluwana lawa i paliwelehi i pa, ‘Lawa gehouna gologolowa ugona ugolina wine he dewadewaya i lupehiyeya. Ma tano tu galena itete u nimahi i houni ma i nae dobu mawana daodaona ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Omlohina hougana ugolina badana a hewali i himili po i nae tano tu galena itete ugolihi ipa ugona tupona hina weleya. Tamogi tano tu galena itete baha tu hihiwa hi wilawi ma a nima kwakwawina hi himili po i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ega yaka badana a hewali gehouna i himili po tauna gasi hi wilawi po i wihinimaya ma a nima kwakwawina hi himili po i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ma a tu bagibagi witonugana i himili po gegeka naka kelo hi weleya ma tano u putana hi dubala hopuneya. ");
INSERT INTO tbo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Apoma tanona taniwagana i baha i pa, “Apo awai a dewaya? Heki, natu hotau a lauhogalena dumaya a himili, nugote apo hina wiyateyateya.” ");
INSERT INTO tbo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‘Tamogi hougana tano tu galena itete natunana hi gagaleya po tuawahi hi ibaabani hi pa, “Tanona muliyei tu witaniwagena geegeka. Ta uni po geka tanona ipa ina nenae ugolina naka apo ina wigalitiyei.” ");
INSERT INTO tbo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ega yaka hi halena hopuneya tanona uputana po hi uni.’ Yesu i lubayada i pa, ‘Tanona taniwagana apo tano tu galena itete iyowai ina dewahi? ");
INSERT INTO tbo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Apo ina nei po ina unihi ma tano tu galena itete gehouhi u nimahi tanona ina houni.’ Hougana geka lawa hi noonoli po hi pa, ‘Apega duma.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma tauna i galehi ma i pa, ‘Heki, geka bahana Yaubada a Buka ugolina anona awai? I baheya i pa, “Ogolana tauna tu lunuma hi ihinigigiyeya amalai i gunabuiya po i dewadewa lagona.” ");
INSERT INTO tbo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iyai ina peu po noka ogolana ugolina ina yato apo ina lauhedalena meya po tupotupona. Ma inapa noka ogolana ina guli po iyai ina lutataya apo ina lumutumutuya.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lugagayo tanitaniwagahi po tu witalaguyaba babadahi ipa noka kabudalana hina numa panipani. Matababana geka paliluwaluwana i bahena niyeya ugolihi ma tamogi lawa hi lowogehi. ");
INSERT INTO tbo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ega yaka gaogao hi beiha po lawa tu wibenabenama gowagowada hi himilihi ipa hina witepa naka tauhi tu winugonugotuhu dumalu. Ma tauhi ipa Yesu hina laubayabayadeya po ina baha powa ma mi Loma hai taniwaga baneina a witaniwaga po a wipoya ugolina hina houni. ");
INSERT INTO tbo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tu wibenabenama gowagowadahi Yesu hi lubayadeya hi pa, ‘Bada, to hanapugeya naka awai e bahebahehi po e iatatiyanehi hi dumalu. Ma gasi to hanapugeya naka lawa ega uta ikahahi ma tamogi Yaubada a nugotuhu moinana lawa ubeihi e iatatiyanehi. ");
INSERT INTO tbo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Apo mi Loma hai taniwaga ta wotagoya po takisi ta huhouni Sisa binei, bo eega?’ ");
INSERT INTO tbo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tamogi Yesu amaka hai lubayada koyakoyama i hanapugeya yaka ugolihi i baha i pa, ");
INSERT INTO tbo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","‘Mone emosi ona wogeleteya po a galeya. Iyai tepana galenana po gowana geka monena ugolina?’ Ma tauhi hi pa, ‘Sisa galenana.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ega yaka Yesu ugolihi i baha i pa, ‘Heki, ginouli awai Sisa galinei Sisa ona weleya. Ma ginouli awai Yaubada galinei Yaubada ona weleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lawa u matahi ega emoemotahi ipa Yesu hina dewaya po ina baha powa. Ega yaka hi genuwana ma a baha binei nugonugohi i goholi. ");
INSERT INTO tbo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi hai bolu lawahi hilage towolo memena ega hita itumaganeya. Tauhi hi nei Yesu ugolina, ");
INSERT INTO tbo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","po hi lubayadeya hi pa, ‘Bada, Mose geka lugagayona ubeiyai i gilumi i pa, “Oloto awai ina tawine po ega ina winatuna ma ina hilage apo walehina hiwapena ina lawagi po hina winatuna naka popoyana galinei.” ");
INSERT INTO tbo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lawa gehouna natunatuna ololotohi magouhi 7. Tutuwoga i tawine po ega natuna ma i hilage. ");
INSERT INTO tbo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma tu hulatuna wawinena i lawagi. ");
INSERT INTO tbo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Po gasi tu witonugahi ma atapuhina magouhi 7 emoemotahi. Ega hita winatuna ma hi hilage pahihi. ");
INSERT INTO tbo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Muliyei apoma wawinena i hilage. ");
INSERT INTO tbo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ugolinei ma hau towolo meme wawinena apo agona iyai? Matababana atapuhi magouhi 7 i lawaga pahihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma Yesu ugolihi i baha i pa, ‘Lawa geka u hougana he mamae he tawitawine po natunatuhi he itawinehi. ");
INSERT INTO tbo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma tamogi iyawoi noka u hougana Yaubada u matana hi dewadewa po hau hilage he towotowolo meme lawa apega hina tawitawine po apega hina itawinehi. ");
INSERT INTO tbo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Matababana apega hina hilage meme babana tauhi apo mei tu winoyanoya po tauhi Yaubada natunatuna hai towolo meme binei. ");
INSERT INTO tbo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mayau towotowolona i alalahi hougana Mose i limoineya naka lawa hau hilage he towotowolo meme. Noka hougana Guyau i bahena meya tauna Abelaham a Yaubada po Isako a Yaubada po Yakobo a Yaubada. ");
INSERT INTO tbo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tauna ega lawa hilahilagehi hai Yaubada ma lawa lauyagohanahi hai Yaubada. Matababana tauna ugolina lawa atapuhi he lauyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma lugagayo tanitaniwagahi gehouhi hi baha hi pa, ‘Bada, i lubayada u wimihena imahiyena dumaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma atapuhi hi lowogeya po ega hita lubayadena meya. ");
INSERT INTO tbo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tamogi Yesu i lubayadehi i pa, ‘Iyowai ma lawa hi pa Besinana lawana naka apo Dawita gogana? ");
INSERT INTO tbo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Matababana Dawita tauna buka Sam ugolina i baheya i pa, “Yaubada i baha u Guyau ugolina i pa, U awala hinebawau una mamae ");
INSERT INTO tbo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","a sigana am gawiya a houna hopunehi po aem ani luhanatanahi.” ");
INSERT INTO tbo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Noka hougana Dawita Besinana lawana i kawaguyougeya. Ugolinei Dawita ega Besinana lawana gogana dumana.’ ");
INSERT INTO tbo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lawa atapuhi Yesu hi lautaniganeya ma a hewahewali ugolihi i baha i pa, ");
INSERT INTO tbo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","‘Lugagayo tanitaniwagahi ona gagalena imahiyehi. Tauhi hai luhogala ipa luilui daodaohi hina otenihi ma hina nenae, ma ani gimala dobuna ugolina lawa wiyateyategei hina maamalihi. Tauhi hai luhogala hau numa dalabu ani tugula dewadewahi po hau toleha hai ani tugula gegehi. ");
INSERT INTO tbo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ma gasi koyamagei hiwahiwape hai numa gapolahi he danedanenehi ma lupali daodaohigei galena koyakoyama he dewadewaya. Tauhi hai wimeiha apo ina lata duma.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu numa dalabu baneina u hinena i mamae ma i gagalena ani’mbenena gaebana ugolina tu wigapola lawahi hai ani’mbenena hi huhouna. ");
INSERT INTO tbo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma gasi i gagalena ma hiwape wodayadayabuna mone luwaga habuluhi mei toea emosi i hounihi. ");
INSERT INTO tbo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Yesu i baha i pa, ‘A baha duma ugolimi, geka hiwapena wodayadayabuna i houna lagona ma apoma atapuhina. ");
INSERT INTO tbo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Matababana atapuhina hai omteletelenagei hi houna ma tauna a widayadayabu u hinena ma mone atapuna i tutuhagaya i houna pahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu a hewahewali lawa hai ani’mbenena gaima dewadewahiyei numa dalabu baneina hi wogowogoya ani galenana hakina hi bahebaheya. Ma Yesu i baha nae ugolihi i pa, ");
INSERT INTO tbo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","‘Geka numahi gaima ugolihiyei hiwogohi po o gagalehi, houga e nenei apo gaima emosi ega u uyawena ina mamae. Atapuna apo hina dubadubalena pahi.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma tauhi hi lubayadeya hi pa, ‘Bada, meyanai apo am baha anona ina lugeleteya? Ma wekiwekilala awai apo ina paliweliyai naka hougana ugolina amaka to geleta?’ ");
INSERT INTO tbo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma tauna i baha i pa, ‘Ona gagalena imahi po apega iyai ina witahaya powami. Matababana lawa hi maga apo hina towolo po gowaugei hina koyama hina pa, “Tau Yaubada a Besinana,” po hina pa, “A houga amaka i geleta.” Tamogi ega ona wotagohi. ");
INSERT INTO tbo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hougana gawiya po wogalahi tuwegahi ona noonolihi ega ona matomatouta babana geka dewahi apo hina wawala tahaya. Tamogi houga sigasigana apega ina geleta yagiyaginai.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu gasi i baha meme ugolihi i pa, ‘Tupo geha ma tupo geha apo hina wigawiya po gasi ani taniwaga geha ma ani taniwaga geha apo hina wigawiya. ");
INSERT INTO tbo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Apo guhuguhu po tupo gehouhi gomala po totogo baneihi hina geleta. Ma gasi wekiwelilala wainugolowolowo dumahi apo yadei hina hopu mai. ");
INSERT INTO tbo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Tamogi geka ginoulihi atapuhi yohola apega hina wawala tahaya ma apo lawa gehouhi hina panimi po hina wihiniwiyuwami. Apo numa dalabu ugolihi hina libahibahimi po hau numa panipani hina tugudumi. Ma gowau binei apo hina niyemi wasawasa po taniwaga baneihi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma nonoka ami gaogao apo tuwega dewadewana ona nohaya. ");
INSERT INTO tbo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ega nugonugomi ona laigeno meya ipa apo iyowai bimiyei ona ibaabani. Winugotuhu u nugonugomi ina kokoe duma. ");
INSERT INTO tbo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Matababana baha po nugohanahanapu apo a welewelemi naka ega emoemotana tu wigawiyemi hina houna liyeya bo hina kawaikoyakoyameya. ");
INSERT INTO tbo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma hinahinami po amamami po walewalehimi po nounoumi po ami guguni po ami lawa tauhi apo hau libahibahi hina hounimi po gehouhi apo hina unimi. ");
INSERT INTO tbo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Apo gowau binei ma lawa atapuhi apo hina wihinigigiyemi. ");
INSERT INTO tbo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tamogi apega u ununumi apala emosi ina lugowadeya. ");
INSERT INTO tbo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ami nugokadidili binei apo luyagohana moinana ona tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesu i ibaabani i pa, ‘Mehougana tu wigawiya Yelusalem hina mewiiwileya naka ona hanapugeya a houga apapoe amaka i tuliyaliyani. ");
INSERT INTO tbo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma iyawoi Yudeya u tupona ona mamae yaka ona lowo po ona nae u oya. Ma taumi iyawoi Yelusalem u hinena ona mamae ega ona luilui Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nonoka apo Yaubada a wimeiha hougahi babana awai Yaubada a Buka ugolina i bahebaheya ipa ina limoineya. ");
INSERT INTO tbo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ma wiwine wainatuhahi po koikoibahi noka hougahi ugolihi apo tauhi tu nugodubu duma. Matababana wiyuwa baneina apo geka hipulina ina wialoni po Yaubada a wimeiha geka lawahi hina wialoni. ");
INSERT INTO tbo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ma tu wigawiya lawa gehouhi apo kwasikwasi daodaonei hina talatala unihi ma gehouhi apo hina panipanihi po hina niyehi tupo atapuna ugolihi. Ma tu meuputa lawahi apo Yelusalem hina yomtutuibabeya a sigana hai houga ina kokoe.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu i ibaabani i pa, Wekiwekilala apo hau kabudala po hau wamahiya po hau ubona hina lugeletehi. Hau hipuli tupo gehouhi boga po guliguli gololohi ma apo matouta baneihi ina huluhi po ugolihi nugohanahanapu ina yababa. ");
INSERT INTO tbo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hipuli tupo atapuna ugolina awai apo ina nenei wiotonana ma lawa apo matouta ina geinihi po hina imatauguuguwa. Ma yada ginoulihi atapuhi hai kadidili apo hina tapiya. ");
INSERT INTO tbo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Apoma apo Lawa Moinau a wipoyau po a wasawasau ona gagaleu ma yaloigei a nei. ");
INSERT INTO tbo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hougana geka ginoulihi hina tugudu po hina waawala taumi ona luwatatemi po ona galena gae babana ami lupena halena tahina e kukuku.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Apoma Yesu geka paliluwaluwana ugolihi i baheya i pa, ‘Hapali kiyaha ona galeya ma mayau atapuhi ona galehi. ");
INSERT INTO tbo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","I galugalu hougana ugolina ta hanapugeya naka ega daona ma apo higolo ina wawala. ");
INSERT INTO tbo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yaka wekiwekilala awai a palipaliwelemi hina wawala ma ona galehi yaka ona hanapugeya Yaubada anani taniwaga ega daona ma apo ina geleta. ");
INSERT INTO tbo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‘A baha duma ugolimi, geka ginoulihi atapuhi apo hina wawala tahaya ma apoma geka hapanana lawahi hina hilage pahihi. ");
INSERT INTO tbo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yada po hipuli apo hina yababa ma tau u baha apega ina yababa. ");
INSERT INTO tbo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Ona gagalena imahi. Witoletoleha po uma buuwa po geka hipulina luyagohanana genona ega ina laigenogenomi ma apo noka iyetana ina ligohogoholimi mei walo e lailupa. ");
INSERT INTO tbo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Matababana lawa atapuhi hipuli tupo wohepali he mimiyeya apo ina nei ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tamogi houga magomagouna ona ihalu po ona laupali. Yaka apo ona kadidili po geka ginoulihi atapuhi hinehiyei a dewadewami ona nei po Lawa Moinau u matau ona towolo.’ ");
INSERT INTO tbo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iyeta emosi po emosi Yesu numa dalabu baneina u hinena i iatatiyana. Tamogi uguwei i nae po Oliweta u oyana i eneno. ");
INSERT INTO tbo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma malatomtom habuluna lawa atapuhi hi nei numa dalabu baneina u hinena po ugolina hi lautanigana. ");
INSERT INTO tbo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Palawa ega ita haahana tolehana gowana Welulagona hougana i tutuliyaliyani. ");
INSERT INTO tbo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma tu witalaguyaba babadahi po lugagayo tanitaniwagahi tahaya hi bibeiha iyowai ma apo Yesu hina uni babana lawa hi lowogehi. ");
INSERT INTO tbo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Apoma Tomodulele Yudasa Isakaliyota a winugonugotuhu i taniwageya. Yudasa tauna Yesu a hewali gehouna. ");
INSERT INTO tbo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ma i nae po tu witalaguyaba babadahi po numa dalabu tu galena itete hai babada mitehi hi wiwogatala. Iyowai apo Yesu ina nugonugohaleya ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma tauhi hi kaoha po hi lueena apo mone hina weleya. ");
INSERT INTO tbo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ega yaka i lueena. Ma gaogao i bibeiha ipa bolu ega hina hanapugeya ma Yesu ina nugohaleya po hina numa panipani. ");
INSERT INTO tbo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Palawa ega haahanana tolehana apoma iyetana i geleta. Noka iyetana ugolina ipa apo Welulagona tolehana binei sipi natunatuhi hina unihi. ");
INSERT INTO tbo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yaka Yesu Pita ma Yoni i himilihi ma i pa, ‘Ona nae po Welulagona tolehana ubeita ona wononogogeya po apo ta ani.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma hi lubayada hi pa, ‘Meka nugonugom ipa to wononogogeya?’ ");
INSERT INTO tbo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma ugolihi i baha ipa, ‘Meyagai baneina ona luiluiya hougana oloto gehouna goila talagigoilana e awawali apo ona itutuhaga. Tauna ona wotagoya po numa awai e luiluiya ona luiya. ");
INSERT INTO tbo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Numana taniwagana ona paliweleya ona pa, “Bada geka pite a baha ugolim i pa, meka toumana hai babanoya naka ugolina apo u hewahewali mitehi Welulagona tolehana to ani?” ");
INSERT INTO tbo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma tauna apo babanoya baneina u moyana ina wiatatiyemi po ugolina ginouli atapuna ona wononogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hai luwaga hi nae po Yesu awai atapuna i bahebaheya naka pitenana ma hi tuhagaya yaka hai Welulagona tolehana hi wononogogeya. ");
INSERT INTO tbo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Am kabudalana hougana Yesu a tu wituwetuwega mitehi hau ani am hi tugula. ");
INSERT INTO tbo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma ugolihi i baha i pa, ‘U luhogala baneina ipa taumi miteu geka welulagonana amna tan’omtahaeya ma apoma hiniu ina wiyuwa. ");
INSERT INTO tbo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Matababana a paliwelemi, apega anani a sigana Yaubada anani taniwaga u hinena anani kokoe ugolina ina geleta.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ma keyaka i waya po Yaubada ugolina i wimaamala ma i pa, ‘Geka ona waya po ona gutaya u hayami. ");
INSERT INTO tbo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Matababana a paliwelemi, amalai ma i wawala po i nenae apega wine a umaya a sigana Yaubada a witaniwaga ina geleta.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Apoma aniani i waya po i wimaamala ma i tomutomuya po i welewelehi ma i ibaabani i pa, ‘Geka hiniu taumi a welewelemi. Winugohepau binei geka pite ona dewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Emoemotana gasi mei am u mulina ma keyaka i waya po i pa, ‘Geka talau Yaubada a wogatala wouna lawa atapumi ubeimi apo ina kololo.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amna u hinena Yesu i baha i pa, ‘Ona galeya, tu nugohaleu lawana tauna miteu geka ani amna ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Lawa Moinau apo Yaubada a nugotuhugei a hilage, ma iyai tu nugohaleu naka tauna tu nugodubu.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma a hewahewali hi tugudu po hi laubayabayadena mehi, iyai apo geka dewana ina dewaya. ");
INSERT INTO tbo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesu a hewahewali u hayahi witaniwaga binei hi wigamogahigahi. ");
INSERT INTO tbo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Yesu ugolihi i baha nae i pa, ‘Tu meuputa lawahi hai wasawasa lawa he tanitaniwagehi. Ma lawa hai baha wiyateyate hipa “Bada tam tuhaguiyai.” ");
INSERT INTO tbo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tamogi taumi ipa ega geka pite. Iyai u hayami ami bada ipa ina dewa meya po mei tewela habuluna. Ma iyai ami tu tahaya ipa ina dewa meya po mei tu poula. ");
INSERT INTO tbo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lawa awai tauna i geduma? Lawa hau ani am e tugutugula bo lawa e pupoula? Lawana e pupoula tauna i geduma. Ma tau u hayami mei tu poula lawana. ");
INSERT INTO tbo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Taumi u houga witai u hinehi ma mitemi ta mamae. ");
INSERT INTO tbo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma amaka mei amau witaniwaga ubeina ma i inaganiu, naka pitenana apo a winaganimi witaniwaga ubeina. ");
INSERT INTO tbo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","U ani taniwaga u hinena apo u ani am ugolina ona am po ona uma. Isalaela gugunina magouhi 12 taumi apo taniwaga hai ani tugula ugolina ona tugula ma ona luhetalehi. ");
INSERT INTO tbo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu i baha nae Pita ugolina i pa, ‘Simona, Simona, una lautanigana. Tomodulele lubayada i waya ipa atapumi ina ludadanimi po ina wikahami mei lawa witi e ikahaya. ");
INSERT INTO tbo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tamogi bimgei a lupali ipa am witumagana ega ina kookoe po mehougana una luhagawilem ipa walewalehim una wikadidilihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma Pita i baha i pa, ‘Guyau, a nonogo duma apo tam miteu ta nae hau numa panipani po ta hilage.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Yesu i pa, ‘Pita a baha duma ugolim. Uguwei apega kamkam olotona ina tou a sigana mala tonuga una bowiyeu naka ega uta hanapugeu.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Apoma Yesu a hewahewali i lubayadehi i pa, ‘Hougana a himilimi po o nenae ega ami mone ani’mpohapoha po ega ami baeki po ega aehumahuma ota tama ma awai ugolina o kuku bo eega?’ Ma tauhi hi pa, ‘Ega awai.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma Yesu i pa, ‘Tamogi amalai iyai mone ani’mpohapohana waioutuna ugolina yaka ina waya. Ma iyai ega ugolina kwasikwasi daodaona yaka a luilui wopotopotona ina gimalena haleya po emosi ina waya. ");
INSERT INTO tbo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Matababana a paliwelemi naka geka bahana Yaubada a Buka ugolina ipa ina limoineya tau ugoliu. I baheya i pa, “Tauna tu dewaapapoe mitehi hi hiyawa emotehi,” babana awai biugei hi gilugilumi e laimoineya.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma a hewahewali hi pa, ‘Guyau, u galeya geka kwasikwasi daodaohi luwaga.’ Ma tauna i pa, ‘Amaka.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu mei houga gehouhi i dewadewaya naka pitenana meyagai baneina i hopu haleya po i nenae Oliweta u oyana ma a hewahewali hi wotagoya. ");
INSERT INTO tbo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hougana hau oya hi laugeleta po a hewahewali ugolihi i baha i pa, ‘Ona lupali po apega ludadana ona wialonihi.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ma tauna i nehalehi po i nae uheiya mei gaima ta haleya po e yatoyato naka pitenana mawana a dao ma itutunei i’mtutonetonena ma i lupali i pa, ");
INSERT INTO tbo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","‘Amau, inapa am nugotuhu yaka geka wiyuwana keyakana ugoliu una wihaleya. Tau u nugotuhu hawena ma tam am nugotuhu una dewa tagoya.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma Yaubada a tu winoyanoya yadei i lugeleteya po i wikadidili. ");
INSERT INTO tbo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma nugowiyuwa i dewaya po i laupali gawagawata ma moyagahuna mei tala hau hipuli i tonetoneya. ");
INSERT INTO tbo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A lupali u mulina i gunawileya po a hewahewali nugodubu i tapeienohi po hi eneno ma i tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma i baha nae ugolihi i pa, ‘Awai binei o eneno? Ona towolo po ona laupali ipa ega ludadana ona wialoni.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu yohola i ibaabani ma a hewali gehouna gowana Yudasa bolu i tahaehi ma hi geleta. Tauna i gegae ipa Yesu niuna ina yagoni, ");
INSERT INTO tbo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ma Yesu i baha nae ugolina i pa, ‘Yudasa, winiu yagonagei ipa Lawa Moinau una nugohaleu, bo?’ ");
INSERT INTO tbo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hougana Yesu a hewahewali tauna mitehi awai apo ina waawala hi gagaleya po hi pa, ‘Guyau, i kwasikwasi daodaohi to wibagibagihi bo hawehi?’ ");
INSERT INTO tbo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma tulahi gehouna talaguyaba taniwagana a tu bagibagi i lubuya po tanigana u awala binebawana i talutuiya. ");
INSERT INTO tbo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tamogi Yesu i baha i pa, ‘Geka dewana amaka ma ina kokoe.’ Ma lawana tanigana i wodadani po i dewadewa meme. ");
INSERT INTO tbo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Apoma Yesu i baha nae tu witalaguyaba babadahi po numa dalabu tu galena itete hai babada po mi Yudeya hai tanitaniwaga hi nenei tauna ubeina ugolihi i pa, ‘Iyowai po a nimagawiya gapolami o nei ubeu mei tau tu danene? ");
INSERT INTO tbo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hougana iyeta emosi po emosi tau numa dalabu baneina u hinena taumi u hayami ma iyowai po ega ota paniu? Tamogi geegeka taumi ami kabudala po gasi uguwa wipoyana a houga.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Apoma Yesu hi numa panipani po hi niyeya tu witalaguyaba hai taniwaga a u numa hi luiyeya. Ma Pita mulinei i wotago po i nae. ");
INSERT INTO tbo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma mayau u tano hau ani libolu hi ahili po hi duhuduhuna wiiwileya naka i luwoheyanehi. ");
INSERT INTO tbo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Apoma tu bagibagi wawinena Pita hau yayata i tugutugula i todi ma i gagaleya po i pa, ‘Geka lawana gasi tauna Yesu tu wotagona.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tamogi Pita i bowi i pa, ‘Wawine, Yesu ega ata hanapugena dadani.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma hi mae po ega daona ma lawa gehouna i galeya po i pa, ‘Tam gasi tulahi gehouna.’ Ma Pita i baha i pa, ‘Tulau, tau eega!’ ");
INSERT INTO tbo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma hi mae po kabudala gaogaona emosi u mulina ma lawa gehouna i baha higihigili i pa, ‘Moina dumana geka lawana tauna Yesu a bolu babana tauna lawa Galiligei.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tamogi Pita i pa, ‘Tulau, am baha anona a winugoniniyeya!’ Yohola i ibaabani ma amaka kamkam olotona i tou. ");
INSERT INTO tbo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Guyau i luhagawileya po Pita i gagaleya po Guyau a baha Pita nugonei i gegae naka geka pite i baheya i pa, ‘Uguwei apega kamkam olotona ina tou a sigana mala tonuga una bowiyeu.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Noka apoma i hopu hau uputa po nugonugona pouhi i tutou halenehi. ");
INSERT INTO tbo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tu wigawiya Yesu hi womomohi ma hi palipaliguyoguyougeya po hi ilawi. ");
INSERT INTO tbo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Gasi matana hi humahi ma hi lubayadeya hi pa, ‘Una wipiko, iyai noka i launim?’ ");
INSERT INTO tbo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma baha apapoe galenahi tapuhi po tapuhi ugolihiyei hi palipalitepani. ");
INSERT INTO tbo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Malitomtom hougana tu wiwogatala po tu witalaguyaba babadahi po lugagayo tanitaniwagahi hi’mtuboina. Ma Yesu hi niyeya hau ani wiwogatala numana po hi pa, ");
INSERT INTO tbo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","‘Inapa tam Besinana lawana yaka una paliweliyai.’ Ma tauna i baha ugolihi i pa, ‘Inapa a paliwelemi yaka apega u baha ona kawamoineya. ");
INSERT INTO tbo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma inapa a lubayademi yaka apega u baha ona wimiheya. ");
INSERT INTO tbo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tamogi amalai ma i wawala po i nenae apo Lawa Moinau Yaubada manimaninina u awala hinebawana a tugutugula.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma atapuhi hi pa, ‘Heki, tam Yaubada Natuna, bo?’ Ma tauna i pa, ‘Taumi tuawami o baheya naka tau Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma tuawahi hi pa, ‘Awai binei tu wigouna ta bibiheya? Amaka tauna i wigou meya po a baha gamonei he hopuhopu.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Apoma bolu atapuhi hi welutowolo po Yesu hi niyeya Pilato u naona. ");
INSERT INTO tbo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma hi tugudu po hi igouya hi pa, ‘Geka lawana ata lawa e itahaya powahi ma to tuhagaya. Lawa i palipaliwelehi ipa ega Sisa ugolina takisi hina huhouna po gasi i bahena meya i pa tauna Besinana lawana po wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma Pilato Yesu i lubayadeya i pa, ‘Tam mi Yudeya hai wasawasa, bo?’ Ma Yesu i pa, ‘Tam am baha naka pite.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ma Pilato tu witalaguyaba babadahi po bolu ugolihi i baha i pa, ‘Geka lawana ega a powa awai ata tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tamogi tauhi hi baha higihigili hi pa, ‘A wiatatiyanagei lawa u hayahi wogalahi e talatala iwawali, Yudeya tupona atapuna u hinena. U Galili i wawala i nei po amalai geka hosi.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hougana Pilato geka bahana i noonoli po i lubayada i pa, ‘Geka lawana lawa Galiligei?’ ");
INSERT INTO tbo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma i tuhagaya naka Yesu tauna Heloda tupo i gagalena iteteya ugolinei i nei. Ega yaka i himili po i nae Heloda ugolina, babana noka hougana u Yelusalem i mamae. ");
INSERT INTO tbo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heloda Yesu i gagaleya po nugonugona i kaoha duma babana houga i dao tuwegana i nonoli po gasi ipa ina galeya. Matababana a luhogala ipa Yesu a manini ina wogeleteya po ina galeya. ");
INSERT INTO tbo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ega yaka Heloda Yesu i lubayabayadena dumaya ma a lubayadahi Yesu ega ita wimihehi. ");
INSERT INTO tbo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tu witalaguyaba babadahi po lugagayo tanitaniwagahi hi towolo gae po Yesu hi wigou kadidiliyeya. ");
INSERT INTO tbo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heloda a tu wigawiya mitehi Yesu hi galena hopuhopuneya po hi paliguyoguyougeya, po luilui daodaona po dewadewana hi wioteni ma hi himila meya po i gunawileya Pilato ugolina. ");
INSERT INTO tbo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Noka iyetana ugolina Heloda ma Pilato hi witulana. Ma lolowa geka dewana eega ma hi gawiyena mehi. ");
INSERT INTO tbo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato apoma tu witalaguyaba babadahi po tu tahatahaya po lawa i otugehi po hi’mboina. ");
INSERT INTO tbo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma ugolihi i baha i pa, ‘Geka lawana o neiyai ugoliu po o pa lawa i itahaya powahi. Ma amalai u matami awai bihiyei o igouya a lauwilewileya po ega a powa awai ata tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma gasi Heloda ega Yesu a powa awai ita tuhagaya yaka i himila meya ugoliu. Geka lawana ega awai ita dewa powaya po apo binei ma ina hilage. ");
INSERT INTO tbo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ugolinei ma apo a baha po hina kodikodili ma a wohaleya po ina nae.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bolima emosi po emosi Welulagona tolehana ugolina hau numa panipani iyai lawa hi inagani he baha po Pilato e wohaleya. ");
INSERT INTO tbo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tamogi lawa atapuhi hi otu gogona hi pa, ‘Geka lawana una uni ma nugonugoiyai Balaba una wohaleya.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Balaba tauna meyagai baneina u hinena wogalahi i wiwawali po omunugo binei hau numa panipani i mamae.) ");
INSERT INTO tbo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato nugonugona ipa Yesu ina wohaleya yaka bolu ugolihi i baha meme. ");
INSERT INTO tbo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tamogi tauhi hi otu gunawilana ugolihi hi pa, ‘Una witakeya! Una witakeya!’ ");
INSERT INTO tbo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma ugolihi Pilato a baha i witonugaya i pa, ‘Ma powa awai i dewaya? Ega a powa awai ata tuhagaya po apo binei ma ina hilage.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tamogi tauhi ponahi i lata ma hi ototu gawagawata ipa Yesu ina witakeya po hai wiototu i wiponawogogeya. ");
INSERT INTO tbo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ega yaka Pilato a luhetala i wihimilana naka Yesu apo lawa hai nugotuhu ina wotagoya. ");
INSERT INTO tbo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma lawana wogalahi po omunugo binei hau numa panipani hi tutuguduya hi laupaliyeya ipa ina wohaleya. Ma Yesu i palihaleya lawa hai nugotuhu ina wotagoya. ");
INSERT INTO tbo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tu wigawiya Yesu hi witahaya laweneya po hi niniyeya ma lawa Sailinagei gowana Simona meyagai u uputa ugolina i mamae i nei i luilui meyagai baneina u hinena. Tauna ani take mayouna u awalana hi houni ma hi dewaya po Yesu mulinei i awawalaniyeya. ");
INSERT INTO tbo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lawa boluna baneina Yesu hi wootagoniyeya po u hayahi wiwine gehouhi hi tutou ma hi lauhiyawa. ");
INSERT INTO tbo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma Yesu i luhagawileya po ugolihi i baha i pa, ‘Wawine mi Yelusalemgena, ega biugei ona tutou. Tamogi taumi bimiyei po natunatumi bihiyei ona tutou. ");
INSERT INTO tbo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Matababana iyeta e nenei apo lawa hina pa, “Wiwine alinawa po ega hita inatuna po ega hita igugu tauhi tu kaoha.” ");
INSERT INTO tbo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Apoma, “Apo lawa hina tugudu po oya baneihi ugolihi hina baha hina pa, ‘Ona guli po ona lutataiyai.’ Ma oya habuluhi ugolihi hina pa, ‘Ona guluwiyai.’” ");
INSERT INTO tbo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Matababana inapa ginouli geka pite mayau a wiidaidaga hougana ma hina dewaya, apo mayau a poi hougana awai ina wawala?’ ");
INSERT INTO tbo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ololoto luwaga tauhi tu dewaapapoe gasi hi witahaya lawena niyehi po ipa Yesu mitehi hina wihilagenihi. ");
INSERT INTO tbo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dobu gowana Ununu Dobuna ugolina hi lugeleta po noka hosi Yesu hi witakeya po gasi tu dewaapapoehi luwaga; gehouna u awala hinebawana ma gehouna u awala kehana. ");
INSERT INTO tbo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma Yesu i pa, ‘Amau, una paligigilihi babana awai he dewadewaya ega hita hanapugeya.’ Ma tu wigawiyahi u hayahi a kaleko hi wikibugehi po hi tamihi. ");
INSERT INTO tbo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lawa hi towolo ma hi ihalu ma mi Yudeya hai tu tahaya Yesu hi palipaliguyoguyougeya hi pa, ‘Lawa gehouhi i wiluyagohanihi. Ma inapa tauna Yaubada a Besinana lawana yaka hapali ina wiluyagohana meya.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tu wigawiyahi gasi hi paliguyoguyougeya po hi gae ugolina po wine waitululuwana hi iyoyogi. ");
INSERT INTO tbo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma hi pa, ‘Inapa tam mi Yudeya hai wasawasa yaka una wiluyagohana mem.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma geka bahahi ani take u tepana hi gilumihi hi pa: ");
INSERT INTO tbo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tu dewaapapoena emosi i taketake Yesu i paliapapoeya i pa, ‘Moina tam Besinana lawana? Tam po tiyai una wiluyagohanita.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tamogi tulanana gehounana i lahaya i pa, ‘Yaubada ega uta lowogeya, bo? Wimihana tauta ta wiwaya emosina gasi tauna e wiwaya. ");
INSERT INTO tbo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tauta ata apapoe mihana ta laidumaluya ma tamogi geka lawana ega awai ita dewa powaya.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma i baha Yesu ugolina i pa, ‘Yesu, am wiwasawasa una iwaawali una nugotuhuwe.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Yesu i baha lawana ugolina i pa, ‘A baha duma ugolim, amalai apo tam miteu meyagai gegena ugolina ta mae.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Iyeta i lautipolini ma kabudala lalana i wohouni po tupo atapuna i uguguwi a sigana kabudalana i hopu po ibiga i lutipolini. ");
INSERT INTO tbo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma numa dalabu baneina u hinena kaleko baneina i taketake i gunalolo luwageya. ");
INSERT INTO tbo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Apoma Yesu ponana i lata ma i pa, ‘Amau, u nimam alugou a huhouni.’ Geka bahana i baheya ma yautuna i kokoe po i hilage. ");
INSERT INTO tbo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tu wigawiya tu galena itetehi awai i waawala i gagaleya po Yaubada i huneya i pa, ‘Moina dumana tauna lawa dumadumaluna.’ ");
INSERT INTO tbo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Noka hosi bolu hi’mtuboina po dewa i waawala hi ihalugeya. Ma hougana awai i waawala ma hi gagaleya po a nugowiyuwahi hi gunawilehi hai u numa. ");
INSERT INTO tbo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu tu hanapugena dumana po wiwine u Galili ma hi wotago po hi nenei uheiya hi towolo ma hi ihalu. ");
INSERT INTO tbo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lawa gehouna gowana Yosepa Alimatiyagei Yudeya u tupona. Tauna tu wiwogatala gehouna. Tauna lawa wodewadewana po a dewa hi dumalu. ");
INSERT INTO tbo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hawena tauna tu wogatala gehouna tamogi hai wiwogatala po awai hi dewadewaya ega ita kaoheya. Ma Yaubada anani taniwaga i ototoni. ");
INSERT INTO tbo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Geka tauna lawana i nae Pilato ugolina po Yesu hinina i lupaliyeya ipa ina weleya. ");
INSERT INTO tbo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Apoma hau ani take ma i telehopuneya po kokowaga kalekonei i humaya ma hau kokowaga i houni. Kokowagana naka tapatapana hi hedali po i lui ma yohola ega hita houneya. ");
INSERT INTO tbo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Noka iyetana naka wononogo iyetana po ega daona ma apo dalabu ina wawala. ");
INSERT INTO tbo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wiwinehi u Galili ma Yesu hi wotagoya po hi nenei Yosepa mitehi hi nae kokowagana ugolina po iyowai Yesu i ienoya hi galeya. ");
INSERT INTO tbo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Apoma hi gunawilehi hai u numa po Yesu hinina binei wakatu po dadi dimudimumuhi hi wononogo. Ma hau dalabu hi wiyagohina mei hai lugagayo i bahebaheya pite. ");
INSERT INTO tbo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma gaogao a iyeta tahatahayana ugolina malatomtom kikeina wiwinehi hai dadi hi woononogogehi hi tama po hi nae hau kokowaga. ");
INSERT INTO tbo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gaimagei kokowaga matetana hi lautomgeya naka hi builena niyeya uheiya po i mamae ma hi geleta. ");
INSERT INTO tbo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tamogi hi luilui hougana Guyau Yesu hinina ega hita tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Geka hi winugoniniyeya po hi towotowolo ma mala emosi ma lawa luwaga hai kaleko namanamalihi u liyaliyahi hi lugeletehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ma wiwinehi matouta i wihogohi po hi kulukululu hau hipuli ma lawahi hi baha hi pa, ‘Iyowai po lawa hilahilagehi hai ani mae ugolina lawa lauyagohanana o bibiheya? ");
INSERT INTO tbo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesu ega geka hosi. Yaubada amaka i witowolo meya. Yohola tauna u Galili ma awai ugolimi i bahebaheya ona nugotuhuya. ");
INSERT INTO tbo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tauna i pa, “Lawa Moinau apo tu apapoe lawahi u nimahi hina houniu po hina witakeu po iyeta witonugana ugolina a towolo meme.” ’ ");
INSERT INTO tbo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Apoma wiwinehi geka a bahahi nugohiyei i gae. ");
INSERT INTO tbo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma kokowagei hi gunagunawilehi geka ginoulihi atapuhi Yesu a hewahewali magouhi 11 hi paliwelehi po gasi iyawoi mitehi hi mamae atapuhi hi paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wiwinehi naka Maliya Magadala po Yowana po Maliya Yamesa hinana. Tauhi wiwine gehouhi mitehi geka hi wipaliweleneya tu wituwetuwega ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tamogi wiwinehi awai hi bahebahehi tu wituwetuwegahi ugolihi naka mei dedede yabayababa po ega hita kawamoinehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma Pita i towolo po i wibulibulili po i nae hau kokowaga po i lukululugeya po i gagalena naka kaleko awa i galehi ma ega awai gehouna. Apoma awai i waawala i nugonugotuhugeya ma i nae a u numa. ");
INSERT INTO tbo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Noka iyetana emosina ugolina Yesu tu wotagona luwaga hi nenae u Emeusa. Meyagai gehouna u Yelusalem ma ta nenae mawana a dao kabudala gaogaohi luwaga. ");
INSERT INTO tbo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma hai luwagahi Yesu binei hi dedede, ");
INSERT INTO tbo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","po hi lauwilewilena mehi ginouli awai hi noonolihi ma Yesu i tulatuhi po mitehi hi nenegogona. ");
INSERT INTO tbo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tamogi hi galeya ma ega hita galena tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma Yesu i baha nae ugolihi i pa, ‘Ami luwagahi ami nae ugolina awai o ibaabaniyeya?’ Tauhi hi tutowolo po a nugodubuhi hi kulukululu. ");
INSERT INTO tbo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma gehouna gowana Kilopa i lubayada i pa, ‘Tam tu witoumana u Yelusalem? Moina tuawa hotam awai hi waawala geka iyetahi ta nenehalehi ugolihi ega uta hanapugehi?’ ");
INSERT INTO tbo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Yesu i lubayada i pa, ‘Ginouli awai?’ Ma tauhi hi pa, ‘Awai i waawala Yesu Nasaletagei ugolina. Tauna Yaubada a tu bahapiko. Ginouli atapuhi Yaubada po lawa u matahi i dewadewahi po i bahebahehi naka hi manini duma. ");
INSERT INTO tbo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","I tu witalaguyaba babadahi po i tu tahaya luhetala a wihimilana hilage ubeina ugolina po hau ani take hi tutulawiteya. ");
INSERT INTO tbo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma tiyai a witumaganiyai to iotonana to pa tauna apo Isalaela hau panipani ma ina lupena haleiyai. Ee, ma gasi baha gehouna naka geka dewahi hi wawala po i nenei naka amalai iyeta witonugana. ");
INSERT INTO tbo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","I bolu u hinena wiwine gehouhi hi ligohogoholiyai. Tauhi malatomtom kikeina hi nae hau kokowaga ");
INSERT INTO tbo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tamogi Yesu hinina ega hita tuhagaya. Ma hi gunawilehi po hi pa Yaubada a tu winoyanoya u matahi hi lugeletehi po wiwinehi ugolihi hi baha nae naka Yesu e lauyagohana. ");
INSERT INTO tbo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma i lawa gehouhi hi nae kokowaga ugolina po wiwinehi awai hi bahebaheya naka pitenana hi galeya. Tamogi Yesu ega hita galeya.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Apoma Yesu i baha ugolihi i pa, ‘Nugote taumi tu winugoneina. Ginouli atapuhi tu bahapiko hi bahebahehi o winugoguluwihi po ega ota witumaganehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ma o hanapugena dumaya naka Besinana lawana ipa geka wiyuwahi ina wialonihi ma apoma a wiwasawasa ugolina ina lui.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yaubada a Buka u hinena awai atapuna Yesu binei i bahebaheya naka ugolihi i deede imahiyeya. Mose a giluma ugolina i waawala i nei po tu bahapiko hai giluma atapuhi i wikokowihi. ");
INSERT INTO tbo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Meyageina hi nenae ugolina hi tutuliyaliyani ma Yesu galenana mei ina nenehalehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma hi talagagali hi pa, ‘Tam miteiyai ta nae babana amaka aibiga ma dobu e uguguwi.’ Ega yaka i lui po mitehi hi mae. ");
INSERT INTO tbo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Am hougana lawahi mitehi hau ani am hi tugula ma palawa i waya po i wimaamala ma i tomuya po i welehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Apoma matahi hi gunagadali po hi gagalena tuhagaya ma u matahi i luyababeya. ");
INSERT INTO tbo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma hai luwaga hi ibaabani hi pa, ‘Hei, tauna Yesu, yaka ugolita i ibaabani ma Yaubada a Buka i deede imahiyeya hau tahaya naka mei mayau ina alalata u nugonugota.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mala emosi ma hi wotowolo po hi gunawilehi Yelusalem. Noka hosi Yesu a hewahewali magouhi 11 tu wotago gehouhi mitehi hi’mboina po hi mamae ma hi tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hai megogona u hinena hi ibaabani hi pa, ‘Guyau moina dumana i towolo meme po Simona ugolina i lugeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Apoma lawahi luwaga u tahaya awai i waawala hai lawa hi paliwelehi. Ma iyowai palawa omtomutomuna ugolina ma Guyau hi gagalena tuhagaya gasi hi paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lawahi luwaga geka ginoulihi hai lawa hi palipaliwelehi ma Guyau u hayahi i lugeleteya po i towotowolo, ma i baha ugolihi i pa, ‘Nugodumola ina mamae ugolimi.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma tauhi hi goholihi po hi matouta ma hai nugotuhu hi pa alugo hita gagaleya. ");
INSERT INTO tbo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma tauna i baha nae ugolihi i pa, ‘Awai binei nugonugomi he ipilipili po gasi awai binei o launugoluwaluwaga? ");
INSERT INTO tbo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nimau po aeu ona galehi naka tau moina hotau. Ona wogou po ona galeu babana alugo ega uyogona po ega geyamina po mei tau o gagaleu.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Geka i baheya po i kokoe ma nimana po aena i wogeletehi tauhi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma kaoha po winugonugotuhu i lihogohi po awai i bahebahehi yohola ega hita kawamoinehi ma i lubayadehi i pa, ‘Aniani awai geka hosi he mamae?’ ");
INSERT INTO tbo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ega yaka iyana apapuna tupona hi weleya, ");
INSERT INTO tbo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma i waya po u matahi ma i ani. ");
INSERT INTO tbo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Apoma ugolihi i baha i pa, ‘Yohola taumi miteu ma geka ginoulihi tauhi a palipaliwelemi. Ginouli atapuhi biugei ma hi gilugilumihi Mose a buka ugolihi po tu bahapiko hai buka ugolihi po gasi Sam ugolina ipa ina limoineya.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Apoma Yaubada a Buka u hinena bahahi anohi u nugonugohi i liyayahihi. ");
INSERT INTO tbo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma i baha i pa, ‘Geka pite hi gilumi hi pa, Besinana lawana apo hinina ina wiyuwa po ina hilage ma iyeta witonugana ugolina ina towolo meme. ");
INSERT INTO tbo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma gasi hi bahebaheya gowanei nugobui po paligigilahi hina guguyeya tupo atapuna, u Yelusalem ma i wawala po i nenae. ");
INSERT INTO tbo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Geka ginoulihi anohi taumi tu limoinehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma Amau awai i palipaliwitumaganemi tau apo a himila neiyai ugolimi. Tamogi taumi meyagai baneina u hinena ona iotonana a sigana wipoya moyanei ina hopu mai ugolimi.’ ");
INSERT INTO tbo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Apoma i weluwinihi po hi hopu u uputa po hi nenae naka u Betani hai siga. Ma nimana i wohepahi po i kawaidewedewehi. ");
INSERT INTO tbo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A kawaidewadewa u hinena i wotowolo po i gae hau yada. ");
INSERT INTO tbo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma tauhi hi wotalagiyeya po i kokoe ma hi gunawilehi u Yelusalem a nugokaohahi. ");
INSERT INTO tbo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma houga daodaona numa dalabu baneina u hinena Yaubada hi maamali. ");
INSERT INTO tbo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Houga a wawala uyahina Baha i memae naka tauna Yaubada tu wogeletana. Ma Bahana Yaubada mitehi hi memae, po Bahana naka tauna Yaubada. ");
INSERT INTO tbo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ma wawala tahatahayana uyahina Yaubada mitehi hi memae. ");
INSERT INTO tbo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Bahana uyahinei hipuli ma yada ginoulihi amaka hi geleta, ma ega iyai gehouna ita dewahi. ");
INSERT INTO tbo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tauna luyagohana a baba, yaka yautu i wiwawali po uyahinei yayata i lugeleteya lawa magomagouta uyahita. ");
INSERT INTO tbo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma yayata uguwa u hinena i ludila, po uguwa wopotopotona ega emoemotana yayata ina humaya. ");
INSERT INTO tbo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ega yaka Yaubada lawa gehouna i himiliyai gowana Yoni tauna tu wibapatiso. ");
INSERT INTO tbo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tauna i nei tu limoina lawa uyahihi po i ipaliwelena yayata binei, ipa lawa hina nonoli po hina witumagana. ");
INSERT INTO tbo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma i baha i pa, ‘Tau ega yayatana ma a nei ipa yayata dumana a limoineya.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ma yayatana tauna yayata dumana uyahinei lawa ataputa hoi hipuli nugonugota i liyayahihi. ");
INSERT INTO tbo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tauna hipuli i wiwawali po i nei hoi hipuli po i memae ma tu mehipuli ega hita hanapugeya tauna iyai. ");
INSERT INTO tbo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tauna i nei a lawa uyahihi, ma a lawahi ega hita kaoheya. ");
INSERT INTO tbo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Uyahinei lawa ega tata maga ma ta kaoheya po gowanei ta witumagana, po Yaubada i kawainatuneta yaka tauta natunatuna. ");
INSERT INTO tbo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iyowai ma tauta natunatuna i wiwawalita? Ega lawa hinita a luhogala uyahinei, po ega lawa ata wiwogatala uyahinei, po ega lawa ata nugotuhugei, ma guni memeta Yaubada tauna uyahinei. ");
INSERT INTO tbo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bahana i wilawa hota po mitehi ta memae, po a wasawasa amaka ta galeya. A wiwasawasana Yaubada uyahinei i nei babana Yaubada Natuna dumana. Yaka anai lunugotootogona po anai dewadumaluna i memae. ");
INSERT INTO tbo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Geka tauna Yoni i limoineya po i ototu i pa, ‘Geka tauna binei a ibaabani a pa, tu gelagoniu muliugei e nenei apo ina tahaeu, babana tauna lawa tahatahayana.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tauna lunugotootogo lawana yaka a lunugotootogogei e idewadewata. ");
INSERT INTO tbo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yaubada a lugagayo Mose uyahinei hi nei, ma lunugotootogo po dewadumadumaluna Yesu Keliso uyahinei hi nei. ");
INSERT INTO tbo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ega lawa gehouna Yaubada tepana ita galeya, ma Yaubada Natuna emosi hota tauna Amana u liyaliyana i memae, a dewa i wogeleteya tauta uyahita. ");
INSERT INTO tbo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yoni i tuwetuwega Yodani u goilana ma lawa i bapatisohi. Ma Yudeya Yelusalemgei hi nei Yoni uyahina, tauhi tu witalaguyaba po Libai a guguni gehouhi. Hi nei po Yoni hi lubayadeya hi pa, ‘Tam iyai?’ ");
INSERT INTO tbo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hai lubayada uyahina Yoni ega ita bowi ma i baha dumalu i pa, ‘Tau ega Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ega yaka hi lubayada meme hi pa, ‘Heki, tam iyai? Tam Elaisiya lawa odubona, bo?’ Tauna i pa, ‘Tau ega.’ Yaka tauhi hi pa, ‘Nugote tam tu bahapiko Mose i bahebahem.’ Ma Yoni i paliwelehi i pa, ‘Tau ega.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ega yaka hi pa, ‘Heki, tam iyai? I babada hi himiliyai po to nenei, apo awai to paliwelehi? Om baha awai tam bimgei?’ ");
INSERT INTO tbo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ega yaka hai lubayada i wimiheya i pa, ‘Yaubada a Buka uyahina biugei i ibaabani geka pitenana i pa, “Tu wiototu apo ina geleta hoi balabala po ina iototu ina pa, Guyau a tahaya ona lidumaluya.” ’ ");
INSERT INTO tbo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Palisi lawahi hi lautanigana po Yoni hi lubayadeya hi pa, ");
INSERT INTO tbo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","‘Tam u pa ega Besinana lawana, po tam ega Elaisiya, po tam ega tu bahapiko Mose i bahebahem, ma awai binei e ibapatiso?’ ");
INSERT INTO tbo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hai baha i wimiheya i pa, ‘Tau goilei a ibapatisomi, ma lawa gehouna e towotowolo u hayami ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tauna tu gelagoniu muliugei e nenei. Tau ega u dewadewa awai ipa apo a aehumahuma a lupeni.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Geka dewahi atapuhi naka u Betani hi geleta, Yoni anani wibapatiso tuponana Yodani goilana u tuponei. ");
INSERT INTO tbo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Malitom Yesu i nenei Yoni uyahina ma i galeya, yaka Yoni lawa i paliwelehi i pa, ‘Hei, ona galeya lawana e nenei tauna Yaubada a Sipi Natuna babana apo ina hilage po ata apapoe ina boho halehi. ");
INSERT INTO tbo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Geka tauna binei a ibaabani a pa, Tu gelagoniu muliugei e nenei apo ina tahaeu babana tauna lawa tahatahayana. ");
INSERT INTO tbo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lolowa ega ata hanapugeya a pa tauna iyai, ma tau goilei a ibapatisomi, babana ipa taumi mi Isalaela Yaubada a Besinana ona hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","‘Tau yohola ega ata hanapugeya, ma a pa tauna iyai, ma tau Yaubada i himiliu po goilei a wobagibagi ma uyahiu i bahena geleteya i pa, “Apo yohola Alugou una gagaleya ma yadei ina hopu mai po lawa uyahina ina talu yaka naka tauna apo Alugo Woiyawei ina wibapatisomi.” Geka apoma Yesu a limoineya babana Alugo Woiyawa a gagaleya mei bunebune ma yadei i hopu mai po Yesu uyahina i talu. ");
INSERT INTO tbo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tau lawana mataugei a galeya yaka a laimoineya uyahimi babana tauna Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Malitom ma Yoni a hewahewali luwaga mitehi hi towotowolo ");
INSERT INTO tbo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ma Yesu hi gagaleya ma liyaliyahiyei i nei po i nenae, yaka Yoni i baha uyahihi i pa, ‘Ona galeya, naka tauna Yaubada a Sipi Natuna!’ ");
INSERT INTO tbo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hai luwaga a bahana hi nonoli yaka Yesu hi wimulitagoya po mulinei hi nae, ");
INSERT INTO tbo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ma Yesu i luhagawileya po hi wotagoya i galehi yaka i lubayadehi i pa, ‘Omi luhogala awai?’ Ma hi pa, ‘Labai, meka om ani mae?’ (Labai a bui Bada.) ");
INSERT INTO tbo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu i paliwelehi i pa, ‘Ona nei po ona galeya.’ Yaka mitehi hi nae po anani mae hi galeya, ma amaka aibiga yaka mitehi hi eno. ");
INSERT INTO tbo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoni a hewahewali luwaga a baha hi noonoli po Yesu hi wotagoya, gehouna gowana Andulu, Simona walehina. ");
INSERT INTO tbo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Houga naka uyahina i wotowolo po i nae walehina i biheya po i paliweleya i pa, ‘Yaubada a Besinana lawana amaka to tuhagaya.’ (Besinana lawana naka Keliso.) ");
INSERT INTO tbo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Simona i weluwaya po hi nei Yesu uyahina po Yesu Simona i galeya ma i paliweleya i pa, ‘Tam gowam Simona, Yoni natuna; gowam wouna a yatoni Sipasa.’ (A bui Pita, ma anona tapatapana.) ");
INSERT INTO tbo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Malitom ma Yesu i pa, ‘Ta nae u Galili.’ Hi nenae po Pilipo hi tuhagaya po Yesu i baha uyahina i pa, ‘Una wimulitagou.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo a meyagai Besaida naka Andulu ma Pita hai meyagai. ");
INSERT INTO tbo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo Nataniyela i tuhagaya, po i paliweleya i pa, ‘Yaubada a Besina lawana amaka to tuhagaya. Tauna odubona Mose a lugagayo bukana uyahina i gilumi po gasi tu bahapiko hai giluma uyahina hi bahebaheya. Tauna lawa Nasaletagei Yosepa natuna gowana Yesu.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyela Pilipo uyahina i baha nae i pa, ‘Moina apo lawa dewadewana u Nasaleta hita guni?’ Yaka Pilipo i pa, ‘Una nei po una galeya.’ Ega yaka hi nae Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu i gagaleya ma Nataniyela i nenei ma i baha i pa, ‘Geka lawana tauna mei gogata Isalaela a dewa ega kikina a mepowa gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyela Yesu i lubayadeya i pa, ‘Iyowai ma u hanapugeu?’ Yesu i pa, ‘Pilipo muliyei apoma i otugem ma tau a galena tahaem kiyaha u loguloguna u memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Uyahina ma Nataniyela nugonugona i goholi, ma ega yaka Yesu i paliweleya i pa, ‘Guyau, tam Yaubada Natuna, tam mi Isalaela i wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu a baha i wimiheya i pa, ‘U witumaganeu babana a paliwelem, tam kiyaha u loguloguna u memae ma a galem. Geka hougana ani galena habuluna uyahim ma yohola apo banei dumana una galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu gasi i baha i pa, ‘A baha duma uyahimi, yohola apo ona galeya yada ina hoeya ma Yaubada a tu winoyanoya hina gae ma hina hopu tau Lawa Moinau uyahiugei.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Iyeta luwaga hi kokoe ma tawine tolehana hi dewaya Kana meyageina uyahina, Galili u tuponana. Ma tolehana uyahina Yesu hinana hi toletoleha. ");
INSERT INTO tbo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu a hewahewali mitehi hi paliwelehi, tawine tolehana amna binei. ");
INSERT INTO tbo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hai am uyahina ma hai wine hi wikokowi, ega yaka Yesu hinana i baha uyahina i pa, ‘Wine amaka hi wikokowi.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma Yesu i pa, ‘Hinau, awai binei ipa una wibagibagiu? Yohola ega u houga bagibagi.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesu hinana tu bagibagi i paliwelehi i pa, ‘Inapa awai ina baheya yaka ona wotagoya po ona dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yudeya hai dewa naka yeuyeu, ma ani luoga walatahi hi memae toleha numana uyahina magouhi 6. Naka gaimagei hi dewahi, ma ani galenahi mei walata ma hi lata duma. ");
INSERT INTO tbo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu tu bagibagi i paliwelehi i pa, ‘Walata ona lihogohi,’ yaka walata hi lihogohi po hi liwoliwogehi po i kokoe. ");
INSERT INTO tbo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma Yesu i baha uyahihi po goilana hi higuya po hi niyeya toleha taniwagana uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma Yesu goilana i wobuiya po wine, toleha taniwagana ega ita hanapugeya wine geka ugona meka hi tami, ma tu bagibagi tunawahi hi hanapugeya. Tu bagibagi goilana hi niyeya toleha taniwagana uyahina po i uma dadani ma ega yaka tu tawine wouna i otugeya, ");
INSERT INTO tbo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","po i baha uyahina i pa, ‘Tulau, wine geka i dewadewa duma, tauta ata dewa naka ipa umauma dewadewana lawa ta wele tahaehi po lawa hin’umumaya po hin’uma hiyougo, ma umauma waimulina umauma apapoena ta houni, ma om umauma waimulina naka i haki lagona.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Geka Yesu a wekiwekilala tahatahayana i dewaya Kana u meyageina, Galili u tuponana, yaka a wipoya i wogeleteya lawa uyahihi, ma a hewahewali hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Toleha i kokoe ma Yesu hinana po walewalehina po a hewahewali mitehi hi hopu Kapaneum, po noka hotanana iyeta wabihaga hota hi memae. ");
INSERT INTO tbo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ma amaka houga i tulabeni po mi Yudeya Welulagona tolehana hina dewaya, yaka Yesu i gae u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma i lui numa dalabu baneina u gali hinena po tu gimala i galehi tauhi gamogamo hi gimagimalena halehi, lawa hai talaguyaba ubeihi. Gamogamohi naka bulumakau, sipi ma bunebune. Ma gasi mone tu wiiyawepeli i galehi. ");
INSERT INTO tbo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yaka Yesu gulawa metametanana uyahinei i wikodikodila. Gamogamo ma lawa i wiyagahi numa dalabu baneina u gali hinena, ma mone tu wiiyawepelipeli hai pata i lugolugoluhi ma hai mone i lunohanohaya. ");
INSERT INTO tbo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma lawa bunebune hi gimagimalehi i paliwelehi i pa, ‘Omi kiu ona hopunehi! Ma Amau a numa ega ona ibagibagi ipa omi ani gimala numana!’ ");
INSERT INTO tbo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma a hewahewali Yaubada a Buka bahana hi nugotuhuya i pa, ‘Yaubada om numa a luhogaleya po nugou i waya. Ma nugowiyuwana uyahiu mei mayau ebebalana.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mi Yudeya hai tanitaniwaga hi nei po Yesu hi lubayadeya hi pa, ‘Awai binei dewa geka pitenana u dewahi? Om manini wekiwekilalana una dewaya po to galeya ma to hanapugem tam taniwaga.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu hai baha i wimiheya i pa, ‘Yaubada a numa geka ona hoe haleya, ma iyeta tonuga u hinena apo a witowolo meya.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ega yaka hi pa, ‘Ipa numa geka iyeta tonuga una wogo meya? Ma una nugotuhuya numa geka a bolima magouhi 46 ma hi wikokowi.’ ");
INSERT INTO tbo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesu ega numa dalabu binei ita ibaabani, ma a hilage po a towolo meme binei i ibaabani. ");
INSERT INTO tbo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","A hewahewali bahana anona ega hita hanapugeya ma a towolo meme u mulina a bahana ma Yaubada a Buka bahana hi nugotuhu tuhagahi yaka hi witumaganehi. ");
INSERT INTO tbo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Welulagona tolehana uyahina, Yesu Yelusalem i memae, ma a wipoya wekiwekilalana lawa hi gagaleya po hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma Yesu ega ita kawamoinehi, babana lawa hai dewa i hanapugena dumahi. ");
INSERT INTO tbo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ega emoemotana po lawa awai Yesu ina wibenabenameya ma tamogi Yesu hai nugotuhu atapuhi amaka i hanapugehi. ");
INSERT INTO tbo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lawa gowana Nikodemo tauna Palisi hai bolu, mi Yudeya hai tu wiwogatala gehouna. ");
INSERT INTO tbo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tauna uguwei i nae Yesu uyahina, po i paliweleya i pa, ‘Guyau, tam to hanapugem, tu wiatatiyana Yaubada uyahinei, babana om bagibagi galenana mei Yaubada a bagibagi wipoyana po ega emoemotana lawa gehouna hoi hipuli ina bagibagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yaka Yesu i paliweleya i pa, ‘A baha duma uyahim, apo iyawoi ega hina guni mehi yaka Yaubada anani taniwaga uyahina apega hina lui.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma Nikodemo Yesu i lubayadeya i pa, ‘Iyowai po tau amaka a lata ma ipa a guni meu? Nugote ega emoemotau po hinau u managona a lui meme po u houga guni a wiluwagaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu i baha meme i pa, ‘A baha duma uyahim, inapa lawa ega goilei po gasi Alugo Woiyawei ina guni meya yaka Yaubada anani taniwaga uyahina apega ina lui. ");
INSERT INTO tbo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lawa hi gunigunita tauta lawa ma Yaubada Alugo Woiyawa e weleweleta. ");
INSERT INTO tbo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","U wibaabani guni meme binei, ega nugonugom ina gohogoholi. ");
INSERT INTO tbo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Togowa a togo tupo gehouna po gehouna gololona ta noonoli, ma anani nei po anani nae ega tata hanapugeya naka pitenana lawa hai guni meme Alugo Woiyawa uyahinei ega tata hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma Nikodemo i baha nae Yesu uyahina i pa, ‘Om baha anona u nugonugou ega ita lugeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Yesu i baha i pa, ‘Tam mi Isalaela hai tu wiatatiyana gehouna, ma u baha geka ega uta hanapugeya? ");
INSERT INTO tbo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A baha dumalu uyahimi awai a hanahanapugeya po a gagaleya naka a bahebaheya uyahimi ma u baha ega ota kawaimoineya. ");
INSERT INTO tbo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ginouli hipuligei a palipaliwelemi ma ega ota witumagana, ma apo iyowai yada ginoulihi ona hanapugehi. ");
INSERT INTO tbo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ega iyai gehouna ita gae hoi yada, ma tau Lawa Moinau yadei a hopu mai. ");
INSERT INTO tbo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Odubona Mose mota pawasi i dewaya hoi balabala po mayau uyahina i takeya, apo tau Lawa Moinau naka pite mayau uyahina hina witakeu. ");
INSERT INTO tbo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ma iyawoi hina witumaganeu yaka apo yautu tuwetuwenai hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yaubada hipuli lawahi i luhogalehi yaka Natuna emosi hota i palihaleya, apo iyai ina witumaganeya yaka apega ina hilage ma yautu tuwetuwenai apo ina waya. ");
INSERT INTO tbo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaubada Natuna i himihimiliyai hipuli lawahi ubeita, ega ipa ina wigouta ma ipa ina luyawihita. ");
INSERT INTO tbo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Apo iyai Yaubada Natuna ina witumaganeya yaka apega libahibahi ina wialoni. Ma iyai tauna ega ita itumaganeya libahibahi apo i wialoni, babana Yaubada Natuna ega ita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lawa hai libahibahihi babana geegeka. Yayata amaka i nei hoi hipuli po ata dewa apapoehi i lugeletehi, ma uguwa dewana nugohi i waya ma yayatana dewana ega hita luhogaleya. ");
INSERT INTO tbo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yaka iyawoi hai dewa apapoehi, naka tauhi yayata hi wihinigigiyeya po yayatana uyahina ega hita nei. Matababana apo hai dewa apapoehi yayatana ina lugeletehi. ");
INSERT INTO tbo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma iyai a dewa dumadumaluna yayatana uyahina e nenae po yayata a dewa e laugeleteya, naka a bagibagi Yaubada uyahinei e nenei.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Geka u mulihi apoma Yesu a hewahewali mitehi hi nae Yudeya u tuponana po hi memae ma Yesu gowanei a hewahewali lawa hi bapatisohi. ");
INSERT INTO tbo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoni gasi lawa i ibapatisohi Yudeya u tuponana. Naka Enoni meyageina Salim u liyaliyana babana tupo noka goila hi maga uyahinei lawa hi liya nae po i ibapatisohi. ");
INSERT INTO tbo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Yoni gasi lawa i ibapatisohi naka hougana yohola ega hoi numa panipani hita houni.) ");
INSERT INTO tbo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yoni a hewahewali Yudeya lawana mitehi hi lugamobagibagi bapatiso yeuyeuna binei. ");
INSERT INTO tbo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yaka hi nae Yoni uyahina po hi baha hi pa, ‘Guyau, u nugotuhuya lolowa Yodani u tuponei ta memae ma lawana u laimoineya, tauna i wiwawala po e ibapatiso, ma a bapatisona lawa atapuhi hi luhogaleya po he nenae uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoni hai baha i wimiheya i pa, ‘Bagibagi atapuhi Yaubada i huhounihi naka tauhi lawa hi wobagibagiyehi. ");
INSERT INTO tbo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ma amaka a paliwelemi, tau ega Yaubada a Besinana lawana, ma tau Yaubada i himila tahaeu ma Besinana lawana tauna i wimulitagou.’ ");
INSERT INTO tbo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yoni i’mpaliluwaluwa i pa, ‘Hewahewali luwaga hi memae po tulana a guguhini i tuhagaya po ipa apo ina lawagi, ma tulanana i kaoha duma babana tulana a houga tawine amaka i geleta. Mei tau naka pitenana a kaoha duma babana lawa atapuhi he nenae Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesu tu wotagona boluna ina lata, ma tau tu wotagou boluna ina habulu. ");
INSERT INTO tbo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","‘Lawana yadei i nenei naka lawa ataputa i gelagonita, ma iyai hipuligei i nenei naka tauna hipuli lawana, po hipuli gapolahi ubeihi e ibaabani. Ma lawana yadei i hopuhopu mai tauna lawa baneina. ");
INSERT INTO tbo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yada dewahi i gagalehi ma i noonolihi amaka i paliweleta po a baha ta nonoli ma lawa gehouhi ega hita kawamoineya. ");
INSERT INTO tbo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma apo iyai tuwegana ina witumaganeya yaka apo Yaubada ina kawamoineya. ");
INSERT INTO tbo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Lawana tauna Yaubada i himihimili, Yaubada a baha i bahebaheya, babana Yaubada Alugona i lihogo dumaya. ");
INSERT INTO tbo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Guyau Natuna i luhogaleya yaka anani taniwaga u nimana i hounihi. ");
INSERT INTO tbo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma apo iyai ina witumaganeya yaka yautu tuwetuwenai ina tuhagaya, ma apo iyai ega ina witumaganeya yaka apega yautu tuwetuwenai ina tuhagaya, ma Yaubada a luyogigai apega ina kokoe uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Palisi lawahi Yesu tuwegana hi nonoli naka Yesu a bapatisogei lawa hi maga duma hi wootagoya, ma Yoni ega hita maga. ");
INSERT INTO tbo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma Yesu tauna ega bapatiso ita dewadewaya ma a hewahewali tauhi hi dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ma Yesu i hanapugeya naka amaka Palisi lawahi a bagibagi tuwegana hi nonoli, yaka Yudeya i nehaleya po ipa ina gunawileya u Galili. ");
INSERT INTO tbo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma tahaya naka Samaliya tuponana uyahinei i nae, ");
INSERT INTO tbo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","po i geleta meyagai gowana Saika uyahina. Odubona Yakobo natuna Yosepa hipuli i weleweleya balana ega ita dao. ");
INSERT INTO tbo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tuponana uyahina naka goila huuhulana i memae, ma goilana naka Yakobo odubona i halaya, ma Yesu a naena uyahina i weluhilahilage ma i geleta goilana uyahina iyeta bolinai po i tugula ma i iyagohina. ");
INSERT INTO tbo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Houga naka uyahina tauna tunawana i memae (ma a hewahewali atapuhi hi nae Samaliya u meyageina po ipa hai am hina gimala). Houga kukuna ma Samaliya wawinena gehouna i nei po ipa goila ina higu, ma Yesu wawinena i galeya yaka i lupali i pa, ‘Wawine, goila una weleu po an’uma.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wawinena Yesu uyahina i baha nae i pa, ‘Una galeu, awai binei tam lawa Yudeyagei ma tau wawine Samaliyagei, ma goila e laupaliyeu?’ (Mi Yudeya ma mi Samaliya yohola ega hita winugoemosi.) ");
INSERT INTO tbo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ega yaka Yesu wawinena i paliweleya i pa, ‘Itapa Yaubada anani’mbenena uta hanapugeya uyahim, po itapa uta hanapugeu tau iyai, apo uta lupaliyeu po goila waiyautuna ata welem.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ega yaka wawinena i pa, ‘Bada, ega om ledu, ma goila geka domona i dao duma apo iyowai ma goila waiyautuna una weleu? ");
INSERT INTO tbo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apo tam gogata Yakobo una gelagoni? Yakobo tauna i goila geka huuhulana i dewaya, natunatuna po a gamogamo mitehi hi umumaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu wawinena i paliweleya i pa, ‘Apo iyawoi goila geka hin’umaya yaka apo uyopopohi hina haleyana mehi, ");
INSERT INTO tbo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ma apo iyawoi goila galiugei hin’umaya yaka apega uyopopohi hina haleyana mehi. Goilana apo lawa u nugonugohi ina huuhuleya yautu memewahagana binei.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma wawinena Yesu uyahina i baha i pa, ‘Bada, goilana una weleu po an’uma po ega uyopopou ina halehaleeya po ega goila higuna binei a gunagunawilena meu.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ega yaka Yesu i pa, ‘Una nae po agom una weluwaya po ona nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma wawinena Yesu a baha i wimiheya i pa, ‘Tau ega agou.’ Ega yaka Yesu i baha meme uyahina i pa, ‘Naka baha dumana u pa ega agom, ");
INSERT INTO tbo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","babana agagom magouhi nimitutu, ma naka lawana u lawagi po mitehi o memae, ega agom dumana. Om bahana naka baha dumana.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yaka wawinena Yesu a baha i wimiheya i pa, ‘Bada, amaka a hanapugem tam tu bahapiko gehouna. ");
INSERT INTO tbo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ma una paliweleu tupo awai Yaubada ani polouna i linanaya, babana googiyai uyahihiyei i nenei naka Samaliya u oyana to polopolou, ma taumi mi Yudeya o pa Yelusalem ani polou dumana.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yaka Yesu wawinena a baha i wimiheya i pa, ‘Wawine, a baha dumalu uyahim, houga e nenei apega lawa hina polopolou Samaliya u oyana po Yelusalem uyahina; tauhi ega ani polou dumahi. ");
INSERT INTO tbo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Taumi mi Samaliya iyai uyahina o polopolou, ega ota hanapugeya ma tauyai mi Yudeya to hanapugeya iyai uyahina to polopolou, babana Tu wiluyagohana uyahiyai i geleta. ");
INSERT INTO tbo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tamogi houga amaka i geleta, po tauhi Amata a tu polou dumahi uyahina hina polopolou, ma hai polouna uyahina nugonugohiyei po tahaya dumalunei, Yaubada lawa geka pitenana e bibihehi. ");
INSERT INTO tbo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada tauna Alugo po tupo atapuna uyahina e memae, yaka tauhi uyahina hina polopolou, nugonugohiyei po tahaya dumalunei hina polopolou.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma wawinena Yesu i paliweleya i pa, ‘Amaka a hanapugeya ipa yohola apo Yaubada a Besinana lawana ina nei, tauna hi igowaya hi pa, Keliso, apo ina nei po hanapu atapuna ina paliweleta.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu wawinena i paliweleya i pa, ‘Geka tau a ibaabani uyahim, tau Besibesinanau.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hai wibaabani uyahina ma a hewahewali hi gunawilena mehi po hi gagaleya naka wawine mitehi hi memae ma hi goholihi tamogi ega awai gehouna hita baheya, hita pa, ‘Awai nugonugom?’ bo hita pa, ‘Awai binei wawine mitehi o ibaabani?’ ");
INSERT INTO tbo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma wawinena a goila ani higuna i nehaleya ma inae po lawa hoi meyagai i paliwelehi i pa, ");
INSERT INTO tbo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","‘Ona nei po lawa ona galeya tauna u dewa atapuhi i paligeletehi, nugote tauna Yaubada a Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ega yaka lawa meyagai baninei ipa hina liya mai Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hi liyaliya mai ma a hewahewali uyahina hi pa, ‘Guyau, un’am.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma hai baha i wimiheya i pa, ‘U yam taumi ega ota hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Uyahinei tunawahi ma hi ibaabani hi pa, ‘A yam iyai i weleya?’ ");
INSERT INTO tbo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu i pa, ‘U yam naka Tu himiliu a nugotuhu a dewaya po a bagibagi a luwegahi. ");
INSERT INTO tbo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Houga hi kokoe uyahihi o ibaabani o pa, wamahiya wohepali hina kokoe apo mahula a houga ina geleta. A paliwelemi, ona galena nae hoi tano, mahula a houga i geleta. ");
INSERT INTO tbo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Houga mahula uyahina apo tu bagibagi hina kaoha po hai meiha hina tama, tu ugota ma tu luhepa mitehi hina kaoha gogona, babana houga mahula i geleta. Ma Yaubada a mahula uyahina tu bagibagi apo hina kaoha babana lawa luyagohana tuwetuwenai amaka hi tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Googata hai baha hi pa, ‘Lawa gehouna tu lupehi ma lawa gehouna tu luhepa.’ Naka baha dumana. ");
INSERT INTO tbo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mahula binei a himilimi po lawa ona tamihi. Lawa gehouhi lolowa hi ugota po hi liyeuyeu, ma taumi ona luhepa.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaliya u meyageina lawa tupohi Yesu hi witumaganeya, wawinena a wipaliwelena binei, babana i pa, ‘Tauna u dewa atapuhi i paligeletehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yaka mi Samaliya hi geleta po Yesu uyahina hi pa, ‘Oo Bada, hilaki tata memae?’ Uyahinei iyeta luwaga mitehi hi meupom. ");
INSERT INTO tbo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yaka lawa magomagouhi Yesu hi witumaganeya a baha ubeihi. ");
INSERT INTO tbo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma wawinena hi paliweleya hi pa, ‘Amaka to kawamoineya, babana ega om baha yawa, ma a baha amaka to nonolihi po gasi to galeya, yaka to hanapugena dumaya tauna Tu wiluyagohana tu mehipuli ataputa ubeita.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iyeta luwaga hi kokoe ma Yesu Samaliya i nehaleya po ipa ina nae Galili u tupona. ");
INSERT INTO tbo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ma Yesu baha geka pitenana i baheya i pa, ‘Tu bahapiko ega emoemotana po hina wiyateyateya a meyagai dumana uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hougana i geleta u Galili lawa hi kaoha duma a nei binei, babana lolowa hi nae Yelusalem welulagona tolehana uyahina po Yesu a bagibagi hi galeya tolehana u hinena. ");
INSERT INTO tbo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Ma Yesu i gunawilena meya Kana u meyageina, naka Galili u hinena. Dobuna uyahina lolowa goila i wobuiya po wine. Yesu i geleta po i memae. Ma Kapaneum taniwagana noya i nonoli naka Yesu Yudeya i nehaleya po u Galili i memae yaka i nei Yesu uyahina babana natuna i totogo po i baha gonugonuguwa i pa, ‘Emoemotana tata nae Kapaneum po natuwe i tootogo uta luyawahi? Kikina ma apo ina hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu lawana i paliweleya i pa, ‘Ega kikina iyai gehouna uyahimiyei ita witumaganeu, ma u bagibagi wipoyahi o galehi ma apoma o kawamoineu.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ega yaka taniwagana i paliweleya i pa, ‘Bada, una bulili po ta nae ma natuwe apo ina hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma Yesu i baha i pa, ‘Una gunawilem, natum amaka i luyagohana.’ Lawana Yesu a baha i witumaganeya ma i gunawileya. ");
INSERT INTO tbo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hougana i gunawileya po i nenae ma a tu bagibagi hoi tahaya i tuhagahi po tuwega hi paliweleya hi pa, ‘Natum amaka i luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ega yaka i lubayada i pa, ‘Kabudala awai natuwe a totogo i wohouna?’ Ma hi pa, ‘Pom iyeta bolinai ma wipoya i nehaleya.’ ");
INSERT INTO tbo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma tewelana amana i nugotuhuya hougana Yesu i bahabaha uyahina i pa, ‘Natum amaka i luyagohana,’ yaka lawana a bolu mitehi Yesu hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Geka Yesu a manini wiluwagana wekiwekilalana i dewaya hougana Yudeya i nehaleya po u Galili i wobagibagi. ");
INSERT INTO tbo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Houga geka u mulina mi Yudeya toleha gehouna Yelusalem hi dewaya, po ega yaka Yesu i gae tolehana binei. ");
INSERT INTO tbo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma Yelusalem gamogamo hai mateta u liyaliyana goila talawiwilana i memae mi Yudeya ponahiyei goilana hi wogowaya po hi pa Besaida. Ma tuponana uyahina numa ani wiyagohina nimitutu hi wogohi po hi memae goilana u hadana. ");
INSERT INTO tbo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Naka numahi uyahihi tu tootogo boluhi hi eneno, matahi keekehi po daladalahi po tapitapiyahi po, he iotonana goila ombutuna binei. ");
INSERT INTO tbo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ma Guyau a tu winoyanoya gehouna e hopu po goila talawiwilana e butuya po guhuguhuna, ma lawa awai tootogona ina yoli tahaya goilana uyahina yaka apo a totogo ina yababa. ");
INSERT INTO tbo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma u hayahi lawa gehouna i wobolobolou bolima magouhi 38. ");
INSERT INTO tbo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ma Yesu i nae po lawana i galeya, ma i hanapugeya naka bolima hi maga duma uyahina totogo i memae, ega yaka Yesu lawana i lubayadeya i pa, ‘Nugonugom una luyagonana?’ ");
INSERT INTO tbo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ega yaka tu tootogona i baha i pa, ‘Bada, ega tu haguwe, iyai apo goila a houga wiguhu hougana ma ina houna hopuneu, houga magomagouna a laudadana ipa a hopu, ma ega emoemotau, ma tu tootogo gehouhi he nei po he togo po he lauyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu lawana uyahina i baha i pa, ‘Una wotowolo po om ani eno una awali po una nae.’ ");
INSERT INTO tbo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mala emosi ma lawana tootogona i luyagohana ma anani eno i awali po i nae. Naka houganana iyeta dalabu. ");
INSERT INTO tbo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ma mi Yudeya hai tanitaniwaga lawana hi galeya yaka hi baha nae uyahina hi pa, ‘Awai binei lugagayo u tulagoni po iyeta dalabu ma om ani eno u awala?’ ");
INSERT INTO tbo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma hai baha i wimiheya i pa, ‘Lawa i iluyagohaniu tauna i paliweleu i pa, “Om ani eno una awali po una nae.” ’ ");
INSERT INTO tbo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma hi lubayadena meya hi pa, ‘Lawa awai i baha naka pitenana?’ ");
INSERT INTO tbo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma Yesu lawana i lauyawahi ega ita hanapugeya po i pa, ‘Iyai’galehi, lawa awai,’ babana Yesu i nae bolu u hayahi po ega ita galena tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Apoma Yesu lawana hoi numa dalabu baneina uyahina i tuhagaya po i paliweleya i pa, ‘U galeya, amaka u luyagohana ega houga gehouna dewa apapoehi una dewadewa meya, meka po apo apapoe banei dumana una wialoni.’ ");
INSERT INTO tbo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lawana i nae po tanitaniwaga uyahihi i bahena meya i pa, ‘Lawana i lauyawahiu naka Yesu.’ ");
INSERT INTO tbo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mi Yudeya tanitaniwagahi Yesu hi lipilipili, babana hoi dalabu lawa tootogona i luyawahi. ");
INSERT INTO tbo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ega yaka Yesu mi Yudeya i paliwelehi i pa, ‘Amau houga atapuna e wobagibagi, yaka tau a wobagibagi.’ ");
INSERT INTO tbo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yudeya tanitaniwagahi a baha hi noonoli po ipa iyowai ma hina lihilageni. Babana dalabu lugagayona i tulagoni, ma i pa tauna ama dumana Yaubada po mitehi emoemotahi. ");
INSERT INTO tbo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu lawa i paliwelehi i pa, ‘A baha dumalu uyahimi, ega emoemotana tau tunawau bagibagi awai a dewaya. Ma Amau a bagibagi a galehi, naka pitenana tau gasi a bagibagi a wotagohi. ");
INSERT INTO tbo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Amau i luhogalena dumau, uyahinei a bagibagi atapuhi i dewadewahi, i wiatatiyeu po a bagibagihi a dewahi. Ma apo ona goholimi babana bagibagi gegedumahi e iatatiyeu. ");
INSERT INTO tbo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Amau tu hilahilage hai hilage uyahinei i witowolo mehi po yautu i welehi, naka pitenana tau gasi apo yautu wouna lawa a welehi iyawoi amaka a winaganihi. ");
INSERT INTO tbo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Amau luhetala ega ita taniwageya lawa uyahihi, babana luhetala lugagayona atapuna amaka i weleu po tau a bagibagiyehi, ");
INSERT INTO tbo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ipa atapumi ona wiyateyateu mei Amau o iyateyateya. Ma apo iyawoi ega hina wiyateyateu yaka Amau i himihimiliu ega hita wiyateyateya. ");
INSERT INTO tbo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘A baha dumalu uyahimi, apo taumi iyawoi u baha ona wiponawogogeya po Tu himiliu ona witumaganeya yaka apo yautu tuwetuwenai ona tuhagaya, ma apega a libahibahimi. Taumi amaka o witumagana yaka hilage a tupo o nehaleya po o damana luyagohana wouna uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ma a paliwelena memi, houga e nenei, bo hougana amaka i geletai, apo tu hilahilage Yaubada Natuna ponana hina noonoli, naka tau ponau ma apo ponouna tu nonolina luyagohana hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Amau tauna luyagohana a baba amaka i palihaleya uyahiu po tau gasi luyagohana a baba. ");
INSERT INTO tbo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Luhetala lugagayona amaka i weleu, po ipa tau apo a dewahi, babana tau Lawa Moinau. ");
INSERT INTO tbo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","‘Uyahinei ega ona nugonugogohola ginouli geka ubeihi, houga e nenei tu hilahilage atapuhi ponau apo hina nonoli po kokowaga uyahinei hina towolo meme. ");
INSERT INTO tbo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Po iyawoi tauhi tu dewadumalu luyagohana tuwetuwenai apo hina tuhagaya, ma tauhi tu dewaapapoe nugodubu apo hina wialoni. ");
INSERT INTO tbo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ega emoemotau tunawau bagibagi awai a dewaya. Ega tau u luhogala a wootagoya, ma Yaubada a luhogala a wotagohi. Ma u limoina i dumalu babana ega tau u nugotuhugei, ma Yaubada a luhetala a nonoli po a wobagibagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu i baha meme i pa, ‘Apo tau tunawau a limoinena meu ma ega tu limoineu gehouna, yaka u baha apega ona wotagoya. ");
INSERT INTO tbo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma Yaubada i laimoineu amaka a hanapugeya bahahi naka baha moinahi. ");
INSERT INTO tbo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","‘Lolowa lawa o himilihi po hi nae Yoni tu bapatiso uyahina po biugei i ibaabani naka i limoineu. ");
INSERT INTO tbo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tau ega ata geno lawa hai baha limoinana binei ma ubeimi a ibaabani Yoni a baha binei ipa ona witumagana. ");
INSERT INTO tbo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni galenana mei yayata, houga kukuna o galeya po o kaoha. ");
INSERT INTO tbo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","‘Yoni a wibaabani tau biugei naka ginouli baneina. Ma tamogi Yaubada a bagibagi naka ginouli banei dumana babana i haguwe. A maninigei a bagibagi a lauegahi ipa ona hanapugeu tau Yaubada uyahinei a nei. ");
INSERT INTO tbo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Amau tauna i himiliu ma i paligeletau. Tamogi ega ota galeya po ega ponana ota nonoli. ");
INSERT INTO tbo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yaka a baha ega u nugonugomi hita memae, uyahinei ega ota witumaganeu po ota pa tau Yaubada uyahinei a nei. ");
INSERT INTO tbo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Houga magomagouna Yaubada a Buka odubohi o hiyahiyawihi, ma omi nugotuhu o pa yohola apo yautu memewahagana ona waya, ma ega ota nugotuhu tuhagaya Buka uyahina hi palipaliwelemi tau biugei. ");
INSERT INTO tbo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","O winugoniniyeu yaka yautu memewahagana apega ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘U bagibagi geka a dewadewahi ega lawa omi omhuna binei. ");
INSERT INTO tbo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","A hanapugemi ega kikina omi luhogala Yaubada uyahina ita memae. ");
INSERT INTO tbo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tau Amau gowanei a nei ma ega ota kaoheu. Apo lawa gehouna tunawana gowanei ina nei uyahimi yaka ona kaoheya. ");
INSERT INTO tbo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nugonugomi ipa lawa hina hunemi, yaka Yaubada omhunana o wihinigigiyeya, naka tepanei ega ota witumagana. ");
INSERT INTO tbo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","‘Ega ona inugonugotuhu ipa apo a wigoumi Amau u matana. Mose a lugagayo apo hina wigoumi. Omi nugotuhu ipa Mose a lugagayo apo ina hagumi; apeega. ");
INSERT INTO tbo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma inapa Mose a lugagayo ona wotagoya, yaka tau ona wotagou babana odubona i’mgiluma po biugei i wipaliwelena. ");
INSERT INTO tbo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma a gilumana ega ota witumaganeya, yaka ega emoemotami po u baha ona witumaganehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu a wibaabani i wikokowi ma i gelu po Galili bogana i damani. Bogana gowana gehouna Tibeliya. ");
INSERT INTO tbo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bolu baneina hi wotagoya po hi nei uyahina, babana a bagibagi wipoyana amaka hi galeya tu tootogo lawahi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu a hewahewali mitehi hi gae u oya po hi tugula. ");
INSERT INTO tbo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Naka hougana mi Yudeya hai Welulagona tolehana a iyeta amaka i tu liyaliyani. ");
INSERT INTO tbo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu i itotolana wilawila po bolu i lata duma ma hi liya mai uyahina, ega yaka Pilipo i lubayadeya i pa, ‘Meka yaniyani apo ta gimala po lawa geka ta wianihi?’ ");
INSERT INTO tbo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Lubayada geka uyahinei Pilipo i ludadani, ma Yesu i hanapugeya apo awai ina dewaya po lawa geka ina wianihi. ");
INSERT INTO tbo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipo Yesu uyahina i baha nae i pa, ‘Patala i lata duma po ega emoemotana kina handele luwaga uyahinei palawa ta gimalaya po ta wianihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ega yaka a hewali gowana Andulu, Simona Pita walehina i paliweleya i pa, ");
INSERT INTO tbo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","‘Tewela gehouna a palawa muhomuhona magouna nimitutu ma iyana luwaga uyahina a galeya, nugote ega emoemotana po bolu uyahinei ta wianihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu i paliwelehi i pa, ‘Amaka ma lawa atapuhi ona baha po hoi hiyamoni hina tugula,’ babana tupo naka i wihiyamoni yaka lawa hi tugula, ma ololoto tunawahi hi hiyawihi po magouhi tausana nimitutu. ");
INSERT INTO tbo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu palawa i winihi po Yaubada uyahina i wimamala, ma hi gutaya lawa uyahihi, ma iyana luwaga i winihi po i dewaya mei palawa i dewadewaya pite ma hi gutaya, ma hi am po emoemotahi. ");
INSERT INTO tbo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Am atapuhi hi’mam po hi’mhiyougo apoma Yesu a hewahewali i paliwelehi i pa, ‘Palawa tupotupona ona tuwaluta meya ega gehouna ona laipeuya.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Palawa nimitutu uyahinei lawa i ianihi, tupotupona a hewahewali hi tutuwaluta meya naka poha magouhi 12 hi lihogohi. ");
INSERT INTO tbo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Houga noka uyahina Yesu a manini wekiwekilalana lawa hi gagaleya, po hi pa, ‘Moina dumana geka tauna Tu bahapiko Mose i bahebaheya Yaubada a Buka uyahina, amaka i nei hoi hipuli.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Houga naka uyahina Yesu lawa hai winugonugotuhu i hanapugeya hi pa, apo houga kikina ma hina winagani po ina wiwasawasa uyahihi. Ma Yesu ega nugonugona yaka i nehalehi po tunawana i nae u oya. ");
INSERT INTO tbo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma ibiga amaka i geleta yaka a hewahewali hi hopu Galili u bogana ");
INSERT INTO tbo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","po wam uyahina hi gelu po ipa hina damana meme Kapaneum u meyageina. Ma uguwana uyahina tunawahi hi woewoe damana, ma Yesu yohola ega ita nae uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hougana togowa baneina po guletutu hi wialoni. ");
INSERT INTO tbo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma hi woe po boga hi lautipolini, ma Yesu boga tepanei i nenei wam u liyaliyana ma hi galeya, po hi matouta duma. ");
INSERT INTO tbo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ega yaka Yesu i paliwelehi ipa, ‘Ega ona matomatouta; tau.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma hi baha po hoi wam i gelu po ega daona ma Kapaneum u lekawana hi gota. ");
INSERT INTO tbo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Malitom ma Galili u bogana tu mae, hi hanapugeya tauhi Yesu a hewahewali tunawahi wam hi geluya po hi nae ega Yesu mitehi. ");
INSERT INTO tbo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Naka malatomtomna mi Tibeliya hai wamgei hi nei po hi gota, Guyau palawa i waya po i wimamala ma bolu i ianihi meyageina uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Po noka hotanana Yesu a hewahewali mitehi hi bihehi po ega yaka, lawa boluhi wam hi geluhi po hi damana Kapaneum Yesu tu bihena. ");
INSERT INTO tbo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hi damana po hi tuhagaya, ma hi lubayadeya hi pa, ‘Guyau, iyowai ma u nei?’ ");
INSERT INTO tbo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma Yesu lawa uyahihi i baha i pa, ‘A baha dumalu uyahimi, taumi o bibiheu babana palawa o ani po o’mhiyougo ma u wipoya wekiwekilalana ega kikina anona awai gehouna uyahimi. ");
INSERT INTO tbo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ega yaniyani kookoena binei ona wobagibagi, ma yaniyani yautumi memewahagana binei ona wobagibagi. Tau Lawa Moinau yaniyani a welewelemi, babana Amau a kaoha wekiwekilalana.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tauhi hi lubayadeya hi pa, ‘Awai uyahinei apo Yaubada a bagibagi to dewahi?’ ");
INSERT INTO tbo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu hai lubayada i wimiheya i pa, ‘Geka bagibagina Yaubada i luhogaleya ipa ona dewaya: tau ona witumaganeu babana i himiliu po a nei uyahimi.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma hi lubayadena meya hi pa, ‘Heki, wekiwekilala awai una dewaya po to galeya ma to witumaganem, ");
INSERT INTO tbo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","mei odubona googiyai hoi balabala yabayababa ma yaniyani hi anani gowana mana. Naka Yaubada a Buka uyahina hi baheya hi pa, ‘Yaniyani yadei i welehi po hi’mam.’ Ma tam apo wekiwekilala awai una dewaya u matiyai?’ ");
INSERT INTO tbo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu lawa i paliwelehi i pa, ‘A baha dumalu uyahimi, Mose ega yaniyani yadei googata ita welehi, ma Yaubada yaniyani moinana yadei e welewelemi. ");
INSERT INTO tbo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tau yaniyani Yaubada uyahinei a hopu mai hoi hipuli po lawa hai luyagohana a welehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tauhi hi baha nae Yesu uyahina hi pa, ‘Bada, yaniyani geka una weleweleiyai houga magomagouna.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu i baha nae uyahihi i pa, ‘Tau yaniyani omi luyagohana binei. Apo iyai ina nei uyahiu yaka apega am ina hilage, ma iyai ina witumaganeu yaka apega uyopopona ina haleya. ");
INSERT INTO tbo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","A paliwelemi amaka o galeu, ma tamogi ega ota witumaganeu. ");
INSERT INTO tbo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma iyawoi Amau i palihalehi uyahiu, apo hina nei uyahiu ma apega a wihinigigiyehi. ");
INSERT INTO tbo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Babana tau yadei a hopu mai ma ega ipa, tau u nugotuhu a dewaya ma Tu himiliu a nugotuhu a dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Geka a nugotuhu, lawa magomagouhi i palihalehi uyahiu po a galena itete imahiyehi po iyeta sigasigana uyahina hilage uyahinei a witowolo mehi. ");
INSERT INTO tbo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ma Amau a nugotuhu geka: apo iyai tau Natuna ina galeu po ina witumaganeu yaka apo luyagohana tuwetuwenai ina tuhagaya po iyeta sigasigana uyahina hilagei apo a witowolo meya.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mi Yudeya tanitaniwaga a baha hi noonoli po hi luyogigai, babana i baha uyahihi i pa, ‘Tau yaniyani yadei a hopu mai.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tauhi hi pa, ‘Geka lawana Yosepa natuna gowana Yesu, amana ma hinana ta hanapugehi ma iyowai po i pa tauna yadei ita hopu mai.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu i paliwelehi i pa, ‘Ega tau biugei ma ona bahabaha unuunula. ");
INSERT INTO tbo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Apega iyai nugonei ina nei uyahiu Amau tauna a nugotuhugei. Tauhi iyeta sigasigana uyahina hilagei apo a witowolo mehi. ");
INSERT INTO tbo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Baha geka tu bahapiko odubona i gilumi Yaubada a baha i pa, “Lawa magomagouhi Yaubada uyahinei apo hai witatiyana hina tuhagaya.” Ma apo iyawoi Amau a wiatatiyana hi noonoli po hi wiponawogogeya tauhi apo uyahiu hina nei. ");
INSERT INTO tbo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Taumi uyahimiyei ega iyai gehouna Amau ita galeya, tau tunawau, babana Yaubada uyahinei a nei. ");
INSERT INTO tbo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A baha dumalu uyahimi, lawa awai i itumaganeu tauna apo luyagohana tuwetuwenai hina tuhagaya ");
INSERT INTO tbo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","babana tau yaniyani omi luyagohana binei. ");
INSERT INTO tbo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Odubona googami hoi balabala yaniyani gowana mana hi anani, ma uyahinei ega luyagohana tuwetuwenai hita tuhagaya ma hi hilahilage. ");
INSERT INTO tbo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma yaniyanina yadei i hopuhopu mai lawa awai in’anani yaka apega hina hilage. ");
INSERT INTO tbo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naka yaniyanina tau yadei a hopu mai apo iyai in’aniu, yaka apo luyagohana tuwetuwenai ina tuhagaya. Ma yaniyanina a welewelemi naka tau hiniu ma u luyagohana apo a palihaleya hipuli lawami ubeimi.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Geka bahana binei ma mi Yudeya mitehi hi lugamogahigahi hi pa, ‘Geka lawa awai ipa apo hinina ta’nani?’ ");
INSERT INTO tbo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ega yaka Yesu i baha uyahihi i pa, ‘A baha dumalu uyahimi, tau Lawa Moinau, ma inapa hiniu ega on’anani, ma talau ega on’umaya, yaka apega omi luyagohana. ");
INSERT INTO tbo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Apo iyai hiniu in’anani, ma talau in’umaya, yaka apo luyagohana memewahagana ina tuhagaya, po iyeta sigasigana uyahina hilagei apo a witowolo meya. ");
INSERT INTO tbo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yaka ona hanapugeya hiniu yaniyani dewadewana, ma talau umauma dewadewana. ");
INSERT INTO tbo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Apo iyai hiniu in’anani ma talau in’umaya, yaka apo tau u nugonugona a memae, ma tauna uyahiu ina memae. ");
INSERT INTO tbo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Amau tauna lauyagohanana i himiliu yaka uyahinei u luyagohana a wiwaya, ma apo iyai hina winiu po in’aniu, yaka luyagohana apo uyahiugei ina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Odubona googata mana hi anani, ma ega uyahinei luyagohana hita tuhagaya, ma hi hilahilage. Yaniyani geka yadei i hopuhopu mai inapa iyai in’ani yaka apo luyagohana memewahagana ina tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Geka ginouli atapuhi naka Kapaneum numa dalabu u hinena i paligeletehi po i wiatatiyanehi. ");
INSERT INTO tbo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu tu wotagona magomagouhi yaniyani bahana hi noonoli po tunawahi ma hi ibaabani hi pa, ‘Baha geka nonolahi uyahita hi witai duma; tauta ega emoemotata.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu hai baha unuunula amaka i hanapugeya, yaka i baha nae uyahihi i pa, ‘Baha geka binei ma o lunugoluwaluwaga. ");
INSERT INTO tbo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tau Lawa Moinau lolowa yadei a hopu mai, ma yohola apo a gunawileu. Ma inapa u gunawilana ona galeya yaka ona witumaganeu? ");
INSERT INTO tbo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Alugo Woiyawa luyagohana memewahagana lawa e welewelehi. Ega emoemotana po lawa tunawahi hina waya. U baha anohi, lawa hai luyagohana memewahagana binei, ");
INSERT INTO tbo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ma gehoumi ega ota witumaganeu.’ Yesu baha geka i bahebahehi babana i hanapugena dumaya apo awa hina wawala: gehouhi ega hita witumaganeya, ma i hanapugeya apo iyai ina nugohaleya. ");
INSERT INTO tbo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yaka i paliwelehi i pa, ‘Geka u bahana lolowa a paliwelemi a pa, apega iyai nugonei ina nei uyahiu Amau tauna a nugotuhugei.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Geka bahana binei tu wotagona magomagouhi hi wihinigigiyeya, ma hi nehaleya po ega mitehi hita nae. ");
INSERT INTO tbo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma a hewahewali magouhi 12 i lubayadehi i pa, ‘Taumi iyowai nugonugomi ipa ona nae?’ ");
INSERT INTO tbo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ega yaka Simona Pita Yesu uyahina i baha i pa, ‘Guyau, apo iyai uyahina to nae? Tam tunawam luyagohana memewahagana uyahim e memae, ");
INSERT INTO tbo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","yaka tauyai to witumaganem po gasi to hanapugem tam Yaubada a Besinana Waiwoiyawana.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu i paliwelehi i pa, ‘Baha dumana, magoumi 12 a winaganimi, ma uyahimiyei gehouna tauna Tomodulele tulana.’ ");
INSERT INTO tbo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Yesu i ibaabani naka Yudasa binei, tauna Simona Isakaliyota natuna. Yudasa tauna Yesu a hewali, ma yohola apo ina nugohaleya.) ");
INSERT INTO tbo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Geka u mulihi Yesu Galili tuponana i wiwileya. Ma ega nugonugona ipa Yudeya ina wiwileya, babana Yudeya hai tanitaniwaga nugonugohi ipa Yesu hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma mi Yudeya hai Kape tolehana amaka i tuliyaliyani ipa apo hina dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ega yaka Yesu walewalehina hi baha nae uyahina hi pa, ‘Meyagai geka una nehaleya po una nae Yelusalem tupo Yudeya uyahina, po noka hotanana tu wotagom om bagibagi wipoyana hina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma una nugotuhuya apega iyai gehouna bagibagi gowagowada uyahinei ma tuwegana ina lata inapa tam una wipoya yaka una nae po hipuli lawa uyahihi om manini una wogeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Walewalehina baha geka hi bahebaheya, babana ega hita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ega yaka Yesu i paliwelehi i pa, ‘Ega u houga dumana po ipa a nae. Ma taumi ona nae, babana houga atapuna emoemotami. ");
INSERT INTO tbo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Taumi tu mehipuli po ega omi witumagana yaka lawa apega hina wigawiyemi ma tau apo hina wigawiyeu babana hai apapoe a palipaligeletehi ubeihi. ");
INSERT INTO tbo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Taumi tunawami ona nae hoi toleha, geka hougana apega a nehi toleha uyahina babana u houga dumana ega ita geleta.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Baha geka i baheya yaka a lawa hi nae toleha uyahina ma tauna u Galili i memae. ");
INSERT INTO tbo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu walewalehina hi nehaleya po hi nae hoi toleha ma Yesu mulihiyei i welugowagowada po i nae Yelusalem po i geleta. ");
INSERT INTO tbo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mi Yudeya hai tanitaniwaga tolehana u hinena, Yesu hi bibiheya ma hi laubayadeya hi pa, ‘Yesu meka?’ ");
INSERT INTO tbo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lawa a boluhi ma Yesu binei hi laugamogahigahi po gehouhi hi pa, ‘Yesu tauna lawa dewadewana.’ Ma gehouhi hi pa, ‘Ega, lawa e koyakoyamehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma ega iyai gehouna Yesu ita widewedeweya lawa u matahi, babana mi Yudeya hai tanitaniwaga hi matutehi. ");
INSERT INTO tbo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Toleha gaogaonana u tupolina, ma Yesu i lui numa dalabu baneina uyahina po a wiatatiyana i wiwawali, ");
INSERT INTO tbo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","po mi Yudeya nugonugohi hi gohola dumahi po hi pa, ‘Lawa geka meka a hanapu i tuhagahi? Tauna ega meka hosi ita wisikulu.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu i paliwelehi i pa, ‘U wiatatiyana geka ega tau u nugotuhu, ma Tu himiliu tauna a nugotuhugei a iatatiyana. ");
INSERT INTO tbo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ma ona nugotuhuya iyai luhogalana ipa Yaubada a nugotuhu ina dewaya, yaka u wiatatiyana ona hanapugeya miyei e nenei, Yaubada uyahinei bo tau tunawau u nugotuhugei. ");
INSERT INTO tbo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Inapa tu wituwetuwega tunawana a nugotuhu ina ibaabaniyehi ipa tauna omhunana binei. Ma tu wituwetuwega tu himilana a nugotuhu e ibaabaniyehi ipa tu himilina omhunana binei. Yaka a bahahi hi dumalu ma hi dewadewa. ");
INSERT INTO tbo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose a lugagayo i welewelemi atapumi o wihinigigiyeya yaka nugonugomi ipa ona lihilageniu.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bolu a baha hi wimiheya hi pa, ‘Nugote alugo apapoena i luinim yaka bahahi geka e bahebaheya. Lawa ega nugonugohi ipa hina lihilagenim.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu hai baha i wimiheya i pa, ‘O nugoapapoe babana iyeta dalabu uyahina lawa a lauyawahi binei. ");
INSERT INTO tbo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ma taumi iyowai omi bagibagi iyeta dalabu uyahina? Mose a lugagayo i baheya ipa logaloga ololotohi hai wekiwekilala hini omhapina hina waya gaogao emosi ina kokoe. Lugagayo geka Mose googana uyahihiyei i nei, po hai wekiwekilala o dewadewahi iyeta dalabu uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yaka naka Mose a lugagayo iyeta dalabu binei o tutulagoni, bo? Ma iyowai po hoi dalabu lawa a lauyawahi binei ma o igawiyeu? ");
INSERT INTO tbo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ega nugolelehiyei ona igou koyakoyameu, ma u dewa po u baha ona galena imahiyehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yelusalem lawa gehouhi hi pa, ‘Nugote geka lawana ipa hina laihilageni, bo?’ ");
INSERT INTO tbo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ma gehouhi hi pa, ‘Eega, ona galeya, u hayata i towolo po e ibaabani,’ ma gehouhi hi pa, ‘Ega iyai a baha ita wimiheya, nugote ata tanitaniwaga hi kawamoineya hi pa tauna Yaubada a Besinana lawana, bo?’ ");
INSERT INTO tbo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma gehouhi hi pa, ‘Ataputa ta hanapugeya anani nei tuponana. Ma itapa tauna Besinana lawana apo anani nei apega iyai gehouna ita hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu numa dalabu baneina u hinena i iatatiyana po i baha labatana i pa, ‘Moina dumana o hanapugeu tau iyai ma gasi miyei a nei? Tau Yaubada i himiliu po a nugotuhugei a nei. Ma ega tau u nugotuhugei ata nei tupo geka uyahina. Tu himiliu a dewa hi dumalu, taumi ega ota hanapugeya tauna iyai. ");
INSERT INTO tbo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma tau a hanapugeya babana tauna i himiliu po uyahinei a nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Geka bahana binei ma ipa hina numa panipani, ma ega iyai gehouna ita wodadani, babana ega a houga dumana ipa ina hilage. ");
INSERT INTO tbo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma lawa magomagouhi hi kawamoineya po hi pa, ‘Baha dumana geka Besinana lawana. Ega emoemotana po Besinana gehouna ina nei po a bagibagi ina tahaeya, tauna amaka.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Lawa hai wibaabani gowagowada Palisi lawahi po tu witalaguyaba babadahi hi nonoli yaka tu wigawiya hi himilihi po hi nae ipa Yesu hina numa panipani. ");
INSERT INTO tbo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma Yesu i baha nae i pa, ‘Houga kuku hotana apo tau mitemi ta memae ma apo a nae Tu himiliu uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Apo ona biheu ma apega ona tuhagau tuponana uyahina a memae ega emoemotami po ona nei uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mi Yudeya tunawahi ma hi ibaabani hi pa, ‘Meka u tuponana ipa ina nae po apega ta tutuhagaya? Ipa ina nae mi Yudeya he memae tu meuputa u hayahi ipa ina wiatatiyana uyahihi? ");
INSERT INTO tbo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Geka a bahana anona awai? Babana i pa, “Apo ona biheu ma apega ona tuhagau,” po gasi i pa, “Tuponana uyahina a memae apega ona nei uyahina.” ’ ");
INSERT INTO tbo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Toleha baneina iyetana anani kokoe uyahina ma Yesu i towolo po i otu labatana i pa, ‘Taumi iyawoi uyopopomi hina haleeya, yaka ona nei uyahiu po on’uma. ");
INSERT INTO tbo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mei Yaubada a Buka i bahebaheya tauhi hi tumaganeu ubeihi i pa, u nugonugohi goila waiyautuna ina huhuleya.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu baha geka i bahebaheya naka Alugo Woiyawa binei i ibaabani, babana Alugo Woiyawa apo tu witumaganena nugonugohi ina lihogohi. Ma houga noka uyahina Alugo Woiyawa lawa u nugonugohi ega ita lui po ita lihogohi, babana Yesu ega ita gae anani mewasawasa uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lawa boluhi Yesu a baha hi noonoli po hi pa, ‘Lawana geka lawa dumana tauna tu bahapiko Mose i bahebaheya.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gehouhi hi pa, ‘Tauna Besinana lawana.’ Ma gehouhi hi widibogi hi pa, ‘Besinana ma Galiligei i nei? ");
INSERT INTO tbo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yaubada a Buka u hinena i pa, Besinana lawana apo Dawita gugunina uyahinei ina nei po Dawita a dobu Betelehem uyahina hina guni.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Geka bahana tepanei ma lawa nugokahakaha uyahihi i geleta. ");
INSERT INTO tbo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma ipa lawa gehouhi Yesu hina numa panipani, ma ega iyai gehouna hinina ita wodadani. ");
INSERT INTO tbo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tu wigawiya hi gunawelehi, tu witalaguyaba babadahi po Palisi lawahi uyahihi po hi lubayadehi hi pa, ‘Awai binei ega ota numa panipani po ota neiyai?’ ");
INSERT INTO tbo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tu wigawiya hi baha hi pa, ‘Lawana a baha hi dewadewa duma, ega mei lawa gehouna a wibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Palisi i baha nae tu wigawiya uyahihi hi pa, ‘Nugote nugonugomi i waya. ");
INSERT INTO tbo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ona nogutuhuya tanitaniwaga atapuiyai ega iyai gehouna Yesu ita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lawa boluhi Yesu hi wotagoya, ma Mose a lugagayo ega hita hanapugeya, yaka apo Yaubada ina paligubahi.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo, tauna uguwei i nenae Yesu uyahina tauna taniwaga gehouna po i baha a lawa uyahihi i pa, ");
INSERT INTO tbo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","‘Ata lugagayo geka pitenana, lawa apega ta numa panipani yababaya, ipa a powa ta bihena tahaeya, apoma ta numa panipani po ta wimiheya a apapoe bigona.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tanitaniwaga tulana hi baha nae Nikodemo uyahina hi pa, ‘Nugote tam Galiligei u nei? Yaubada a Buka una hiyawi po una galeya, apega tu bahapiko Galiligei ina nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ega yaka atapuhi hi liya nae hai numa uyahihi, ");
INSERT INTO tbo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","ma Yesu i gae Olibe u oyana. Malatomtomgei Yesu i gunawilena meya hoi numa dalabu po i tugula ma lawa atapuhi hi mewiwileya ma iatatiyehi. ");
INSERT INTO tbo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma lugagayo tanitaniwagahi po Palisi lawahi wawine gehouna hi neiyai, babana apapoe i dewadewaya ma hi tuhagaya, yaka wawinena u tipolina hi witowoli ");
INSERT INTO tbo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ma Yesu hi paliweleya hi pa, ‘Bada, wawine geka oloto mitehi hi eneno gogona ma to tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma ata lugagayo Mose uyahinei i nenei i pa apo geka pitenana to tuhagahi yaka apo to lugaimahi po hina hilage. Ma tam om winugonugotuhu iyowai wawine geka binei?’ ");
INSERT INTO tbo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baha geka hi bahebaheya ipa iyowai ma Yesu a baha powa hina nonoli yaka hina numa panipani po hina libahibahi. Ma Yesu ega kikina hai baha ita wimiheya, ma i medobudobu ma hoi hipuli i yamgiluma. ");
INSERT INTO tbo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma tauhi hi laubayabayadeya, ega yaka Yesu i wotowolo po i baha uyahihi i pa, ‘Oo, i dewadewa duma. Ma taumi uyahimiyei inapa iyai ega a apapoe yaka apo tauna gaima ina halena tahaeya wawine naka uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ma i medobudobu po hoi hipuli i yamgiluma meme. ");
INSERT INTO tbo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma Yesu a baha hi noonoli po, yamoha po yamoha a apapoe i nugonugotuhu tuhagaya yaka hi nehaleya babada hi tahaya ma hewahewali hi wimuli. Yesu hi nehaleya ma wawinena tunawana i towotowolo. ");
INSERT INTO tbo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ega yaka Yesu i wotowolo po i lubayadeya i pa, ‘Wawine, meka tauhi hi nae, po ega iyai gehouna ita memae, ma ita laibahibahim?’ ");
INSERT INTO tbo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wawinena Yesu i paliweleya i pa, ‘Bada, ega iyai gehouna ita memae.’ Ega yaka Yesu i baha meme i pa, ‘Oo, i dewadewa, tau apeega gasi a wigoum ma una nae, ma a paliwelem ega apapoe una dewadewa meya.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu i baha meme i pa, ‘Tau tu mehipuli omi yayata apo iyawoi hina wotagou yaka yayata uyahina hina geleta po hina luyagohana ma apega uguwa uyahinei hina nenae.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Palisi Yesu uyahina hi baha nae hi pa, ‘Tam tunawam bimgei e ibaabani yaka apega to witumaganem.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu i baha meme uyahihi i pa, ‘Baha dumana, tau biugei a ibaabani ma awai a palipaliwelemi naka baha dumahi, babana tuponana uyahinei a nenei apo a gunawileu uyahina, naka a hanapugeya. Ma taumi tuponana uyahinei a nenei po apo a gunagunawileu uyahina ega ota hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Taumi o igouwe lawa hai nugotuhu uyahinei, ma tau ega iyai gehouna ata wigouya. ");
INSERT INTO tbo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Inapa lawa a wigouhi yaka u gagalena kaha i dumalu ma i dewadewa, babana Tu himiliu tauna a nugotuhugei a gagalena kahakaha ma ega tunawau u nogutuhugei ata igou. ");
INSERT INTO tbo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ma Mose a taniwaga gehouna i pa, apo lawa luwaga hai baha nonolahi emosi yaka naka bahahi ta limoinehi. ");
INSERT INTO tbo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tau biugei a ibaabani, ma gasi Amau i himihimiliu tauna e laimoineu.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ega yaka hi lubayadeya hi pa, ‘Amam meka?’ Ma Yesu hai baha i wimiheya i pa, ‘Ega ota hanapugeu yaka gasi Amau ega ota hanapugeya. Ma inapa taumi ona hanapugeu yaka, apo gasi Amau ona hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu a wiatatiyana geka numa dalabu baneina u hinena i wiatatiyaneya, ani’mbenena dedewagana u liyaliyana. Ma Yesu ega iyai gehouna uyahina ita wogo nae, babana a houga dumana ega uyahina ita geleta. ");
INSERT INTO tbo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu mi Yudeya tanitaniwagahi i paliwelehi i pa, ‘Apo a nehalemi ma ona bihena aweu, po omi dewa apapoehi ubeihi ona hilage wahaga. Babana tuponana a nenae uyahina ega emoemotami po ona nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mi Yudeya tunawahi ma hi baabani hi pa, ‘A baha o nonoli, a bahana i pa, “Tuponana uyahina a nenae taumi ega emoemotami po uyahinei ona nei.” A bahana anona nugote ipa ina lihilagena meya?’ ");
INSERT INTO tbo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu i baha meme uyahihi i pa, ‘Taumi babanei o nei ma tau moyanei a hopu mai. Taumi hipuligei o nei ma tau yadei a hopu mai. ");
INSERT INTO tbo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Uyahinei a paliwelemi inapa ega ona witumaganeu yaka omi dewa apapoehi tepahiyei apo ona hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ega yaka hi lubayadeya hi pa, ‘Tam iyai?’ Ma Yesu i baha nae uyahihi i pa, ‘Houga daodaona amaka a palipaliwelemi. ");
INSERT INTO tbo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Emoemotau a wigoumi ginouli magomagouhi ubeihi tamogi apeega babana Tu himiliu tauna a dewa hi dumalu ma awai a noonoli tauna uyahinei a ibaabaniyeya taumi hipuli lawami uyahimi.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma a wibaabanina Amana binei, tauhi ega hita nugotuhu tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yaka Yesu i paliwelena mehi i pa, ‘Yohola tau Lawa Moinau apo ona wohepau apoma ona hanapugeu tau iyai, po ona nugotuhu tuhagaya ega tau u nugotuhugei ata wobagibagi, ma Amau awai i iatatiyeu tauhi a ibaabaniyehi. ");
INSERT INTO tbo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tu himiliu ega ita nehaleu, mitehi to wobagibagi po houga magomagouna a laikaohaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu a baha lawa magomagouhi hi noonoli po hi witumaganena dumaya. ");
INSERT INTO tbo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mi Yudeya, tauhi Yesu a baha tu witumaganena i paliwelehi i pa, ‘Apo u wiatatiyana ona wotagohi yaka taumi tu wimulitagou dewadewahi. ");
INSERT INTO tbo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Po taumi nugogadagadala dumana ona waya, po palihalena ona tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tauhi hi baha nae Yesu uyahina hi pa, ‘Tauyai Abelaham gugunina po ega iyai gehouna a taniwaga ita lauguduguduyai. Ma om baha anona awai po u pa, palihalena ona tuhagaya?’ ");
INSERT INTO tbo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ega yaka Yesu i baha meme uyahihi i pa, ‘A baha duma uyahimi iyawoi tauhi hai dewa apapoehi naka tauhi apapoe i panihi. ");
INSERT INTO tbo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tu bagibagi hota waimihana ega guguni uyahihi ita memewahaga, ma lawa natuna guguni uyahihi apo ina mewahaga. ");
INSERT INTO tbo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tau Yaubada Natuna yaka apo omi apapoe hi panipanimi uyahinei palihalena a welemi po palihalena dumana ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A hanapugemi taumi Abelaham gugunina, ma tamogi o ileta ipa ona lihilageniu babana u wiatatiyana ega u nugonugomi hita lugeletehi. ");
INSERT INTO tbo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tau Amau u matana awai a gagalehi naka a ibaabaniyehi. Ma taumi amami uyahinei awai o noonolihi o wobagibagiyehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tauhi Yesu a baha hi wimiheya hi pa, ‘Tauyai Abelaham guguninei to nei.’ Yesu i baha nae uyahihi i pa, ‘Itapa taumi Abelaham googana dumahi apo a dewa ota wotagoya. ");
INSERT INTO tbo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma taumi omi nugotuhu tapuna yaka o ileta ipa ona lihilageniu, tau baha dumana tu bahena Yaubada uyahinei. Ma omi dewa a gagaleya ega mei Abelaham a dewa. ");
INSERT INTO tbo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Taumi amami a bagibagi o wotagohi.’ Ega yaka hi pa, ‘Aa, ega tauyai dewa apapoena natunatuna; tauyai amiyai emosi hota gowana Yaubada.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu i baha nae uyahihi i pa, ‘Inapa taumi Amami dumana Yaubada yaka ona luhogaleu babana tau Yaubada i himiliu po a hopu mai hoi hipuli. Tau ega u nugotuhugei ata nei, ma Tu himiliu tauna a nugotuhugei a nei. ");
INSERT INTO tbo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Awai binei u baha u nugonugomi ega hita lugiigilihi. Nugote ega emoemotami ipa u baha ona lutaniganena imahiyeya. ");
INSERT INTO tbo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","A hanapugemi taumi Tomodulele natunatuna, yaka nugonugomi luhogalana ipa amamina a bagibagi ona dewaya. Houga wawala uyahina i nei po amalai tauna tu lihilage, ega kikina dewa dumadumaluna uyahina ita memae. Houga magomagouna koyamagei e ibaabani po tauna a dewa dumana, yaka tauna tu wikoyakoyama amahi ");
INSERT INTO tbo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","uyahinei ega ota witumaganeu babana tau baha dumahi uyahimi a ibaabaniyehi. Ma iyowai? ");
INSERT INTO tbo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Emoemotami lawa gehouna uyahimiyei u dewa apapoehi ina bahena geletehi? Ega emoemotami. Baha geka a ibaabaniyehi naka baha dumahi, awai binei ega ota witumaganeu? ");
INSERT INTO tbo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tauhi iyawoi Yaubada a lawa naka a baha tu nonolina. Ma taumi iyawoi ega Yaubada a lawa, yaka a baha ega ota nonolihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mi Yudeya Yesu a baha hi wimiheya hi pa, ‘Lolowa i baha uyahim geka amaka anona i lugeleteya, babana to pa, tam lawa Samaliyagei yaka alugo apapoena uyahim e memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu tanitaniwaga hai baha i wimiheya i pa, ‘Tau ega alugo apapoena uyahiu, ma Amau a wiyateyateya, ma taumi ega kikina ota wiyateyateu. ");
INSERT INTO tbo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tau ega tuwegau ata wohepa meya, ma Taniwaga gehouna tauna e wohepau, tauna apo ina limoineu. ");
INSERT INTO tbo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A baha duma uyahimi, taumi iyawoi u baha geka ona wotagoya yaka apega ona hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ega yaka mi Yudeya Yesu a baha hi wimiheya hi pa, ‘To hanapugena dumam alugo apapoena uyahim e memae, babana Abelaham to hanapugeya ma i hilage, ma tu bahapiko to hanapugehi ma hi hilage. Ma tam om baha iyowai po u pa, “Apo iyawoi u baha hina wotagohi yaka apega hina hilage.” Tam lawa awai? ");
INSERT INTO tbo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gogiyai Abelaham amaka i hilage, ma e ileta ipa una gelagoni? Tu bahapiko amaka hi hilage, ma om nugotuhu ipa una houna hopu nehi, bo?’ ");
INSERT INTO tbo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yaka Yesu uyahihi i baha nae i pa, ‘Apo tau a hunena meu yaka u omhunana naka ginouli yabayababa. Ma Amau e hunehuneu, taumi omi baha o pa, “I Yaubada.” ");
INSERT INTO tbo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Taumi ega Yaubada ota hanapugeya, ma tau a hanapugeya. Inapa a baha ana pa, “Ega ata hanapugeya,” yaka apo ona kawaikoyakoyameu ma tamogi taumi o ikoyakoyama. Ma tau amaka a hanapugeya po a baha a wotagoya. ");
INSERT INTO tbo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma gogamina Abelaham a kaohana ipa u iyeta ina galeya, po i galeya yaka i kaoha duma.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mi Yudeya hi baha nae Yesu uyahina hi pa, ‘Tam yohola ega om bolima magouhi 50 uta tuhagaya. Ma u baha u pa, Abelaham uta galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu i paliwelehi i pa, ‘A baha duma uyahimi, Abelaham muliyei apoma hi guni, ma houga noka uyahina tau a memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A bahana binei mi Yudeya hi luyogigai po gaima hi tama po ipa Yesu hina wilawi, ma u matahi i lugowadeya po numa dalabu baneina i hopu haleya. ");
INSERT INTO tbo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Houga gehouna Yesu tahayagei i nenae, po lawa gehouna i gagaleya a matakekena ma hi guni. ");
INSERT INTO tbo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A hewahewali Yesu hi lubayadeya hi pa, ‘Guyau, iyai a apapoegei lawa geka a matakekena hi guni, tauna bo amana ma hinana?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu hai baha i wimiheya i pa, ‘Ega tauna a apapoe bo amana ma hinana po a matakekena hita guni ma ipa Yaubada a bagibagi wipoyana ina wogeleteya lawa magomagouhi uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tu himiliu tauna ipa a bagibagi ta dewahi iyeta hougana uyahina, ma uguwa ina nei ega emoemotana po iyai gehouna ina bagibagiyehi. ");
INSERT INTO tbo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Geka hougana tau hoi hipuli a memae, lawa atapuhi hai yayata.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Geka bahana i baheya ma hoi hipuli i howa, po bigabiga i waya po uyahinei lawana matana i wololoya. ");
INSERT INTO tbo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma i baha uyahina i pa, ‘Una nae Silowam u goilana apo una witepaoga.’ (Silowam a bui himihimila.) Yaka i nae po i witepaoga, po anai mata lugiigilina i nae a numa uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma hewalina a lawa po odubona lawa hi gagaleya hi pa, ‘Geka nugote tauna tu wilulupali?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma gehouhi hi pa, ‘Ma nugote tauna, houga magomagouna i memae ma i lulupali.’ Ma gehouhi hi pa, ‘Eega. Tamogi galenana mei tauna.’ Ega yaka hewalina i baha i pa, ‘Geka tau.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yaka hewalina hi lubayadeya hi pa, ‘Iyowai ma matam i lugiigili?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma i paliwelehi i pa, ‘Lawa gehouna gowana Yesu bigabiga i howaya, ma bigabigana i waya po uyahinei matau i wololoya, ma i himiliu i pa, ‘Una nae Silowam u goilana po una witepaoga,’ yaka a nae po a witepaoga, po matau hi lugiigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yaka hi lubayadena meya hi pa, ‘Meka tauna?’ Ma hewalina i pa, ‘Ega ata hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yesu iyeta dalabu uyahina ma lawa matana bigabigagei i dewadewaya binei ma lawana hi weluwaya po hi niyeya Palisi lawahi uyahihi, ");
INSERT INTO tbo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","po Palisihi lawana hi lubayadena meya hi pa, ‘Iyowai ma matam i lugiigili?’ Ega yaka i paliwelehi i pa, ‘Lawana bigabiga i godaya po matau i wololoya ma a witepaoga po matau i lugiigili.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma Palisi hai bolu gehouhi hi baha hi pa, ‘Tu bagibagi naka nugote ega Yaubada uyahinei, babana dalabu lugagayona ega ita wotagoya.’ Ma bolu gehouhi hi baha hi pa, ‘Iyowai tu apapoe ma apo manini wekiwekilalana ina dewahi, nugote ega emoemotana?’ Geka bahahi uyahihiyei ma nugokahakaha i geleta uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ega yaka Palisihi tu matakekena hi lubayadena meya hi pa, ‘Tam iyowai om winugonugotuhu lawana matam i dewadewaya binei?’ Ma tu matakekena i baha i pa, ‘Tauna Yaubada a tu bahapiko gehouna.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma mi Yudeya tanitaniwagahi ega hita witumagana ipa lawa geka a matakekena ma hi guni, ma geke hougana matana i lugiigili, yaka hinana ma amana hi otugehi ");
INSERT INTO tbo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","po hi lubayadehi hi pa, ‘Tewela geka taumi natumi? Ona paliweliyai, a matakekena ma o guni? Iyowai ma matana hi lugiigilihi?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hewalina amana ma hinana Palisi lawahi hi paliwelehi hi pa, ‘To hanapugeya tauyai natuyai, po a houga guni uyahina a matakekena i wawala, ");
INSERT INTO tbo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ma matana i laugiigili ega tota hanapugeya, po iyai i widewadewaya ega tota hanapugeya. Ma tauna ona lubayadeya babana amaka i lata.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Amana ma hinana baha geka hi bahebaheya babana mi Yudeya hai tanitaniwaga hi matoutehi. Babana lugagayo hi houni hi pa, apo iyai Yesu ina kawaibesinanageya yaka apo to wihinigigiyeya po i tapalolo ina hopu haleya. ");
INSERT INTO tbo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Geka lugagayona binei, ma lawana amana ma hinana hi pa, ‘Tauna ona lubayadeya babana amaka i lata.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ega yaka tu matakekena hi otugena meya po hi baha nae uyahina hi pa, ‘Ega Yesu una hunehuneya ma Yaubada una huneya babana tauna i luyawahim ma naka lawana to hanapugeya tauna lawa apapoena.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma i baha i pa, ‘Ega ata hanapugeya tauna tu apapoe bo ega. Ma tamogi matau kekena i liyeuyeuya.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yaka hi baha uyahina hi pa, ‘Awai i dewaya po matam i liyeuyeuya?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tu matakekena i baha i pa, ‘Amaka a paliwelemi ma ponau ega ota nonoli, awai binei ma ipa ona nonola meya? Nugote taumi o luhogaleya ipa ona wotagoya, bo?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","A baha binei ma hi paliyeya hi pa, ‘Tawa tam tu wotagona, ma tauyai Mose tu wotagona ");
INSERT INTO tbo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","babana a baha Yaubada uyahinei amaka to hanapugeya. Ma tauyai Yesu ega tota hanapugeya miyei i nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lawana matana keekena i baha uyahihi i pa, ‘Geka dewana naka i nugopilipili duma babana lawana matau i liyeuyeuya, ma ega ota hanapugeya po o pa miyei i nei. ");
INSERT INTO tbo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Amaka ta hanapugeya Yaubada tu apapoe ega ita noonolihi, ma inapa iyai Yaubada ina wotalagiyeya ma a nugotuhu ina wobagibagiyehi yaka apo Yaubada ponana ina nonoli. ");
INSERT INTO tbo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ta hanapugena dumaya odubona po amalai ega iyai gehouna tuwegana tata nonoli ipa matakeke lawana ita widewadewaya. ");
INSERT INTO tbo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Itapa Yesu ega Yaubada uyahinei, apega wipoya geka pitenana ita dewahi.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Palisi lawahi tu matakeke uyahina hi baha nae hi pa, ‘Tam tu apapoe om houga tewela uyahinei i nei po amalai. Ma ipa una wiatatiyeiyai, tam iyai?’ Yaka numa dalabu hinenei hi wiyagaya po i hopu halehi. ");
INSERT INTO tbo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu lawana tuwegana i nonoli ipa numa dalabu hinenei hi wiyagaya po i hopu yaka Yesu lawana i biheya po i tuhagaya. Ma i lubayadeya i pa, ‘Yaubada a Besinana lawana u witumaganeya?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma matakeke lawana i baha i pa, ‘Bada, tauna iyai po apo a witumaganeya?’ ");
INSERT INTO tbo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yaka Yesu i baha nae uyahina i pa, ‘Lawana amaka u galeya ma geka mitehi o ibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Lawana i baha i pa, ‘Guyau, a witumaganem,’ ma i polou po i wiyateyate. ");
INSERT INTO tbo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu i baha nae i pa, ‘Tau a nenei hoi hipuli ipa a galena kahakahami, po tauhi matahi keekehi hina galena meme, ma tauhi matahi laugiigilahi apo hina mata keke.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Palisi Yesu a baha hi noonoli po hi pa, ‘Ega tauyai tu matakeke.’ ");
INSERT INTO tbo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu i baha nae uyahihi i pa, ‘Itapa taumi matami hita keke apega Yaubada ita wigoumi. Ma taumi o pa matiyai he laugiigilihi, yaka omi dewa apapoehi uyahimi he memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu i baha i pa, ‘A baha duma uyahimi apo iyai sipi hai gali matetanei ega ina lui, ma tupo tapunei in’omgeina tagona, yaka tauna tu danene po tu’munugo. ");
INSERT INTO tbo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Apo iyai sipi hai matetagei ina lui, tauna sipi hai tu galena itete dumana. ");
INSERT INTO tbo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yaka mateta tu galena itetena tauna binei gudu i hoeya. Ma i lui, po a sipihi gowahi i yatonihi po ponana hi nonoli ma hi wimulitagoya po hi hopu hoi uputa. ");
INSERT INTO tbo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hougana i hopunehi hoi uputa po i lutahaya lawenihi ma sipi hi wotagoya, babana ponana hi hanapugeya ma hi malagameya. ");
INSERT INTO tbo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Apega iyai gehouna hina wotagoya, apo inapa lawa tapuna yaka apo hina lowo haleya, babana ponana ega hita hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu baha wiluwaluwa geka i paliwelehi, ma nugonugohi ega hita lugiigilihi. ");
INSERT INTO tbo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ega yaka Yesu i baha meme uyahihi i pa, ‘A baha duma uyahimi, tau sipi hai matete! ");
INSERT INTO tbo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lolowa tu galena itete tahatahayahi tauhi tu danene po tu’munugo yaka sipi ponahi ega hita nonolihi. ");
INSERT INTO tbo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Tau mateta! Apo iyawoi uyahiugei hina lui, yaka apo hina luyagohana, babana houga magomagouna he lui ma he hopu po hiyamoni dewadewahi he tutuhagahi. ");
INSERT INTO tbo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tu lugowada hi nei po he danedanene, ma he laihilagenihi ma he launohanoha, ma tau a nenei ipa luyagohana dewadewana po hogohogona uyahiugei hina tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yesu uyahihi i baha i pa, ‘Tau sipi hai tu galena itete dewadewana, uyahinei yautuwe apo a palihaleya sipi ubeihi po a hilage. ");
INSERT INTO tbo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Apo lawa awai ega a sipi dumahi, ma maiha binei e gagalena itete, lawana kedewa woyahiyahina i gagaleya ma i nenei yaka sipihi i lowo halehi. Ma kedewana sipi gehouhi i unihi ma atapuhi i lunohanohahi. ");
INSERT INTO tbo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma lawana a lowo babana maiha binei e wobagibagi, ma sipihi ega tauna galinei ma lawa gehouna a gamogamo yaka ega ita luhogalehi. ");
INSERT INTO tbo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","‘Tau sipi hai tu galena itete dewadewau, uyahinei u sipi a hanapugehi ma tauhi hi hanapugeu. ");
INSERT INTO tbo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mei tau Amau a hanapugeya, ma Amau tauna i hanapugeu. Ma apo yautuwe a palihaleya po sipi ubeihi a hilage. ");
INSERT INTO tbo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipi gehouhi he memae ma ega geka galina u hinena hita memae, naka tauhi ipa apo a weluwinihi po hina nei uyahiu po ponau hina nonoli ma hina wotagou. Yaka hai lawa mitehi hina wibolu emosi ma hai tu galena itete emosi. ");
INSERT INTO tbo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Amau i luhogalena dumau babana apo yautuwe a palihaleya hoi hipuli po a hilage, ma yohola apo a tuhaga meya. ");
INSERT INTO tbo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","U hilage ega iyai gehouna ita taniwageya, tau tunawau a palihalena meu po apo a hilage, ma emoemotau apo yautuwe a wimeya, babana Amau a nugotuhu po a taniwaga uyahiu.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu geka a bahahi ubeihi, ma mi Yudeya tunawahi ma hi wigamogahigahi po hi kahakaha mehi. ");
INSERT INTO tbo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lawa gehouhi hi baha hi pa, ‘Alugo apapoena i luiya po i libadebadeya ma ega ponana ona noonoli.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma gehouhi hi baha hi pa, ‘Moina geka pitenana alugo apapoena a baha? Ega emoemotana po alugo apapoena matakeke lawana ina widewadewaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Houga wayau hougana uyahina ma Yelusalem numa dalabu wouna tolehana hi dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu numa dalabu baneina u hinena i lautowolo nae, babanoya gehouna hi wigowaya hi pa, Solomona Wasawasa a babanoya. ");
INSERT INTO tbo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma mi Yudeya Yesu hi mewiwileya ma hi lubayadeya hi pa, ‘Tam houga magomagouna nugonugoiyai e laipilipili, meyanai apo una baha dumalu uyahiyai, apo tam Besinana lawana yaka?’ ");
INSERT INTO tbo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yaka uyahihi i baha nae i pa, ‘Amaka a paliwelemi ma taumi ega ota witumaganeu, po gasi manini Amau gowanei a dewadewahi naka tauhi he wogeleteu. ");
INSERT INTO tbo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma ega ota witumaganeu, babana taumi ega u sipi. ");
INSERT INTO tbo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tau u sipi ponau hi nonoli ma a hanapugehi, yaka he wotagou ");
INSERT INTO tbo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","po apo yautu tuwetuwenai a welehi, po apega hina hilage, ma apega iyai gehouna u nimau in wihalehi. ");
INSERT INTO tbo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sipihi tau Amau i weleu yaka apega iyai Amau nimanei ina wihalehi, babana tauna lawa magomagouhi i kadidila lagonihi ");
INSERT INTO tbo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Amau ma tau naka emoemotiyai.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yaka mi Yudeya gaima hi tama meme po ipa Yesu hina wilawi. ");
INSERT INTO tbo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu i galehi yaka i baha nae uyahihi i pa, ‘Manini magomagouhi Amau uyahinei u matami a dewadewahi ma waigohina binei o galena iapapoeniu po ipa gaima uyahinei ona wilawiu?’ ");
INSERT INTO tbo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mi Yudeya Yesu a baha hi wimiheya hi pa, ‘Ega ipa om manini ubeihi ma to wilawim, ma u baha kawayagala po Yaubada u widibogi. Awai binei tam lawa hota ma u pa, “Yaubada mitehi emoemotami.” ’ ");
INSERT INTO tbo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ega yaka Yesu i baha uyahihi i pa, ‘Lugagayo gilugilumana buka uyahina i pa, “Amaka a baha uyahimi a pa, taumi mei Yaubada.” ");
INSERT INTO tbo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma Yaubada a baha apega ina buda. Ipa tauhi mei Yaubada babana Yaubada a baha hi nonoli, tau Yaubada ega ata idibogi, ");
INSERT INTO tbo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","babana Amau i winaganiu ma i himiliu po a nei hoi hipuli po a bagibagi a dewahi, yaka a paliwelemi tau Yaubada Natuna. ");
INSERT INTO tbo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Itapa Yaubada a bagibagi ega ata dewadewahi apega ota witumaganeu. ");
INSERT INTO tbo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A hanapugemi taumi ega ota itumaganeu, ma tamogi a bagibagi ona galehi po ona witumaganeu po ona hanapugeu tau Yaubada uyahina a memae ma tauna uyahiu e memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Houganana mi Yudeya hi leta ipa hina womomohi po ega emoemotahi, ma i nae. ");
INSERT INTO tbo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","I nehalehi po i damana meme Yodani goilana u tuponei odubona Yoni anani bapatiso u dobuna po naka hotanana i memae. ");
INSERT INTO tbo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma lawa boluhi hi liya nae uyahina po hi galeya ma tunawahi ma hi ibaabani hi pa, ‘Yoni ega a manini ita dewahi po tata galehi ma i ibaabani hota, ma a bahahi anohi lawana binei amaka i geletai.’ ");
INSERT INTO tbo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tupo noka uyahina lawa magomagouhi Yesu hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lawa gehouna gowana Lasalo i totogo. Lasalo a meyagai Betani tupo Yudeya uyahina ma nounouna luwaga, Maliya ma Maleta. ");
INSERT INTO tbo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Geka Maliyana tauna yohola apo Yesu aena ina wineuli ma apalanei ina hamagi. ");
INSERT INTO tbo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma Lasalo i totogo yaka, nounouna Yesu a tuwega hi himila niyeya uyahina hi pa, ‘Guyau, tulam u lauhogaleya i totogo duma.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu tuwega i waya, ma a hewahewali uyahihi i baha i pa, ‘Totogo anona noka Lasalo ega a houga hilage dumana, ma ipa Yaubada a wipoya lawa atapuhi hina galeya po Yaubada hina wotalagiyeya ma Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Maleta walehina mitehi ma nouhi Lasalo, Yesu i luhogalena dumahi. ");
INSERT INTO tbo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hougana Lasalo a totogo tuwegana i nonoli, ma tuponana uyahina i memae naka iyeta luwaga hi kokoe. ");
INSERT INTO tbo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iyeta luwaga u mulina, a hewahewali uyahihi i baha i pa, ‘Ta gunawileta Yudeya u tupona.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma hi baha nae Yesu uyahina hi pa, ‘Guyau, ega emoemotana ta gunawileta babana ega houga ita dao, ma lolowa mi Yudeya ipa hina lugaimam, ma u baha po ipa ta gunawilena meta.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu i pa, ‘Iyeta a yayata e iwawali malatomtom po a siga ibiga, ma apo lawa yayatagei ina nae yaka apega aebahibahi ina wialoni babana kabudala yayatana e lalani. ");
INSERT INTO tbo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma apo uguwei ina nenae yaka apo aebahibahi ina wialoni, babana ega yayatagei ina nenae.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A nugotuhu geka i paliwelehi po i kokoe, ma i baha meme i pa, ‘Tulata Lasalo amaka i eno, yaka ta nae po a limaamahi.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Hi baha nae uyahina hi pa, ‘Guyau, apo in’eno hilage yaka apo kamnana ina dewadewa.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu a baha ano dumana naka Lasalo amaka i hilage, ma a hewahewali hai nugotuhu hi pa eno hilage binei ita ibaabani. ");
INSERT INTO tbo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ega yaka Yesu uyahihi i bahena geleteya i pa, ‘Lasalo amaka i hilage, ");
INSERT INTO tbo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ma a kaoha duma babana a hilage uyahina ega tau ata memae. Ma a hilagena uyahinei apo u bagibagi ona galeya ma ona witumaganeu, yaka ta nae uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi tauna hi igowaya hi pa, Natulagalaga, i towolo po i baha nae i pa, ‘Amaka ma ata Bada mitehi ta nae po ina hilahilage, yaka tauta gasi ta hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu i nae Betani meyageina u liyaliyana ma tuwega hi paliweleya naka Lasalo amaka i hilage, po hoi kokowaga i eneno iyeta wohepali hi kokoe. ");
INSERT INTO tbo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ma Yelusalem mawana ega ita dao, mei kabudala gaogaona emosi, ");
INSERT INTO tbo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","yaka mi Yudeya hi nei Maleta ma Maliya uyahihi po ipa hina winugohegoyahi po nugonugohi hina dewadewa. ");
INSERT INTO tbo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maleta Yesu a nei tuwegana i nonoli, yaka i nae po hoi tahaya po i tutuotootoni ipa hina witutuhaga, ma walehina Maliya hoi numa i memae. ");
INSERT INTO tbo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maleta Yesu i tuhagaya po i baha nae uyahina i pa, ‘Guyau, itapa tam geka hotanana uta memae nouwe apega ita hilage. ");
INSERT INTO tbo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma a hanapugem apo Yaubada uyahina una lupali yaka om lupalina anona ina welem, po ina lugeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu Maleta uyahina i baha nae i pa, ‘Noum apo hilagei ina towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maleta Yesu a baha i wimiheya ipa, ‘Aee, Bada, moina dumana, a hanapugem. Iyeta sigasigana uyahina hilage uyahinei Lasalo apo ina towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu i baha nae Maleta uyahina i pa, ‘Tau towolo meme a baba po gasi yautu tuwetuwenai, apo iyawoi hina witumaganeu yaka hawena apo hina hilage ma tamogi houga e nenei apo tauhi a witowolo mehi po yautu memewahagana hina tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma apo iyawoi hina witumaganeu, yaka apo yautuhi hina tuhagaya po apega hina hilage. Ma tam iyowai, u baha geka binei ma u witumaganeu bo ega?’ ");
INSERT INTO tbo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maleta i baha i pa, ‘Guyau, a witumaganem, babana tam Besibesinanam po tam Yaubada Natuna, lawa to iototonanem om nei hoi hipuli binei.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yesu i baha woloe, ma Maleta i gunawileya hoi numa po walehina Maliya i paliweleya i pa, ‘Bada amaka i nei po i lubayadem.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Yaka Maliya i bulili po i nenae ipa Yesu ina galeya. ");
INSERT INTO tbo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu yohola ega ita nae hoi meyagai, ma Maleta mitehi hi itutuhaga uyahina i memae ma Maliya i nei po i geleta. ");
INSERT INTO tbo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma mi Yudeya Maliya tu winugohegoyana mitehi hoi numa hi memae, hi gagaleya ma i bulili po i nenae yaka hi wotagoya. Hai nugotuhu hi pa ita nenae hoi kokowaga u tougei. ");
INSERT INTO tbo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliya i nae po Yesu uyahina i geleta, ma u aena i polou ma i tou bahabaha i pa, ‘Aee, Guyau, itapa tam geka hotanana uta memae apega nouwe ita hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu Maliya a tou po gasi mi Yudeya Maliya mitehi hi nenei hai tou i noonoli po nugonugona i wiyuwa duma. ");
INSERT INTO tbo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yaka i lubayada uyahihi i pa, ‘Meka a kokowaga?’ Ma hi baha hi pa, ‘Guyau, ta nae po una galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yaka hi nae po i tou. ");
INSERT INTO tbo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma mi Yudeya a nugowiyuwa hi gagaleya po hi pa, ‘Baha dumana, tulana i luhogalena dumaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma lawa gehouhi hi ibaabani hi pa, ‘Lolowa lawa matana keekena i luyawahi, ma awai binei po tulana i totogo ma ega ita luyawahi, ma i hilage wahaga.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu a nugowiyuwana i geleta hoi kokowaga po mateta uyahina i towolo. Kokowagana naka gaima duyuwana ma matetana gaima baneina uyahinei hi lutomgeya. ");
INSERT INTO tbo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ega yaka Yesu bolu uyahihi i baha i pa, ‘Gaima geka ona wihaleya.’ Ma tu hilahilagena nouna Maleta i baha nae i pa, ‘Guyau, amaka i bowa babana iyeta wohepali amaka hi kokoe.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu i baha nae Maleta uyahina i pa, ‘Amaka a paliwelem a pa, una witumaganeu yaka apo Yaubada a wipoya una galeya ma una wotalagiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yaka gaima hi wihaleya, ma Yesu i galena watata ma i lupali i pa, ‘Amau, tinani baneina houga magomagouna u noonoliu. ");
INSERT INTO tbo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tau tunawau houga magomagouna a hanapugeya u lupali u nonoli, ma geka hougana lawa hi towotowolo wiiwileu ubeihi a laupali ipa hina witumaganem tam u himiliu po a nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A lupali u mulina Yesu ponana i lata, ma i otu i pa, ‘Lasalo, una hopu mai!’ ");
INSERT INTO tbo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mala emosi ma lawana hilahilagena a humahumana i wotowolo po i hopu mai, aena po nimana a panipanihi, ma tepana a humahumana. Yesu i baha i pa, ‘Ona lupena haleya, ma ona wohaleya po ina nae.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mi Yudeya Maliya tu winugohegoyana hi nenei, Yesu a bagibagi hi gagaleya po hi witumagana duma. ");
INSERT INTO tbo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma gehouhi ega hita witumaganeya, yaka hi gunawilehi po Palisi lawahi hi wibenabenamehi Yesu awai i dewadewaya binei. ");
INSERT INTO tbo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yaka tu witalaguyaba babadahi po Palisi lawahi, po tanitaniwaga gehouhi hi’mboina gogona po hi pa, ‘Lawana uyahina apo awai ta dewaya, babana manini atapuhi e dewadewahi? ");
INSERT INTO tbo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma lawa magomagouhi apo hina wotagoya. Ma inapa ega ta liwoloeya, apo binei ma lawa hina wobahabaha po mi Loma hai tu wigawiya hina towolo po ata numa dalabu baneina hina wiapapoeya po ata lawa gasi.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma Kayapa, hai bolu uyahinei naka bolimana hai taniwaga, po omboinana uyahina i baha i pa, ‘O winugoneina duma. ");
INSERT INTO tbo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ega ota hanapugeya apo lawa gehouna boluta ubeita ina hilage. Ma a hilagena binei tauta mi Yudeya boluta apega ta hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayapa baha geka i bahebaheya ega tauna a nugotuhugei, babana bolima noka uyahina tauna tu witalaguyaba hai taniwaga, yaka i baha piko ipa apo Yesu ina hilage mi Yudeya boluta ubeita. ");
INSERT INTO tbo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ega mi Yudeya tunawata ubeita ipa ina hilage ma tupo atapuhi Yaubada a lawa he memae apo ina welugogonihi po tauta bolu emosi. ");
INSERT INTO tbo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Naka iyetana uyahina tanitaniwaga hi wiwogatala wawala ipa Yesu hina lihilageni. ");
INSERT INTO tbo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Uyahinei Yesu ega mi Yudeya matahiyei ita nenae ma i nehalehi po i nae dobu gehouna gowana Epalaim u pitapitana, po noka hotana a hewahewali mitehi hi memae. ");
INSERT INTO tbo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma welulagona tolehana i tutulabelabeni, ma mi Yudeya hi liya nae Yelusalem ipa hina liyeuyeu mehi, ma u mulina apoma toleha hina dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Houga naka uyahina numa dalabu baneina u hinena hi memae, ma Yesu hi gagalena bibiheya, ma tunawahi hi ibaabani hi pa, ‘O nugonugotuhuya apo ina nei geka tolehana uyahina, bo eega?’ ");
INSERT INTO tbo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Palisi lawahi po tu witalaguyaba babadahi lawa hi paliwelehi hi pa, ‘Apo Yesu meka ona tuhagaya, yaka ona nei po ona paliweliyai po to womomohi.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iyeta magouhi 6 hi iotonana, ma apo Welulagona tolehana hina dewaya, yaka Yesu Epalaim i nehaleya po i nae u Betani Lasalo a meyagai uyahina, tauna lolowa hilage uyahinei Yesu i witowolo meya. ");
INSERT INTO tbo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Noka hotanana Yesu binei aniani hi wononogo, Maleta aniani i ululona. Lasalo ma Yesu hai lawa mitehi hi tugula po himam. ");
INSERT INTO tbo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma Maliya wakatu dimudimumuna mihana i lata duma ma i gimaleya po i neiyai Yesu uyahina po aena i hiwogi. Ma Maliya i polou po Yesu aena i wololoya ma apalanei i hamagi. Ma wakatuna dimumuna numa hinena i wihogoya. ");
INSERT INTO tbo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma Yudasa Isakaliyota tauna Yesu a hewali gehouna, tauna apo Yesu ina nugohaleya. Nugonugona i ibagibagi po i pa, ");
INSERT INTO tbo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","‘Awai binei wakatu geka ega hita gimalena haleya po mihana kina handele tonuga hita waya po dayadayabu lawahi hita haguhi?’ ");
INSERT INTO tbo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasa a nugotuhu geka ega nugotuhu dumana, babana ega tu dayadayabu ubeihi ma tauna binei. Matababana tu danene gehouna, tauna hai mone tu galena itetena, ma monehi i danedanenehi. ");
INSERT INTO tbo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ega yaka Yesu i baha nae Yudasa uyahina i pa, ‘Geka wawinena ega ona palipaliwiyalutugeya. Nugotuhu geka i dewadewaya naka apo hoi kokowaga hina huhouniu binei i dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Taumi apo dayadayabu mitehi houga magomagouna ona memae, ma tau apega houga daodaona ta memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mi Yudeya Yesu tuwegana hi nonoli u Betani i memae, yaka hi liya nae uyahina. Hai nae babana nugonugohi ipa Yesu hina galeya ma Lasalo gasi, babana Yesu hilage uyahinei i witowolo meya. ");
INSERT INTO tbo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Bolu Lasalo hi galeya po Yesu hi witumaganeya, yaka tu witalaguyaba babadahi hi baha gogona ma ipa Lasalo hina lihilageni gasi. ");
INSERT INTO tbo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Malinatom apo Yesu ina lui u Yelusalem ma houga noka uyahina bolu baneina hi memae Yelusalem Welulagona tolehana binei. Yesu tuwegana hi nonoli ipa apo ina nei. ");
INSERT INTO tbo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yaka lawa beda luguluguhi hi tamihi ma hi nae po ipa Yesu mitehi hina witutuhaga. Ma hi wotalagae ma hi otu labatana hi pi, ‘To wotalagiyem!’ ‘Yaubada gowanei e nenei tam mi Isalaela i Wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu gamogamo gowana doniki i tuhagaya ma i gelu po i nenae, mei Yaubada a Buka gilumana hi bahebaheya pite, ");
INSERT INTO tbo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Saiyoni dobu diidigana, lawami ega ona matomatouta. Geka hougana omi Wasawasa e luilui mai uyahimi. Tauna doniki wouna uyahina i gelu po i nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iyeta noka uyahina Yesu a hewahewali lawa hai wotalagae hi nonoli, ma anona ega hita nugotuhu tuhagaya. Yesu anani mewasawasa u mulina apoma nugohiyei i gae, ");
INSERT INTO tbo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","babana Buka hi gilugilumi anona i lugeleteya. Bolunana hai wotalagae babana lolowa Yesu Lasalo kokowaga uyahinei i otugeya po i towotowolo meme ma bolu hi galeya, ma hi nae po lawa atapuhi hi paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lawa magomagouhi a manini wekiwekilalana hi noonoli yaka hi liya nae ipa Yesu hina galeya. ");
INSERT INTO tbo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma Palisi lawahi tunawahi hi ibaabani hi pa, ‘Ata kadidili amaka hi kokoe babana lawa atapuhi amaka he liyaliya nae Yesu a bolu uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tolehana uyahina mi Giliki gehouhi u hayahi hi memae, ma tauhi tu tapalolo po hi gae Yelusalem Welulagona tolehana binei. ");
INSERT INTO tbo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ma mi Gilikihi hi nae Pilipo uyahina ipa hina lubayada, Pilipo tauna lawa Besaidagei tupo Galili uyahinei i nei. Hi nae po hi pa, ‘Bada, nugonugoiyai ipa Yesu to galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipo i’mhoe po i nae Andulu uyahina po i paliweleya ma hai luwaga hi nae Yesu uyahina po mi Giliki hai luhogala hi paliweleya. ");
INSERT INTO tbo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu mi Giliki hai lubayada i wimiheya i pa, ‘Houga amaka i geleta, po Lawa Moinau u Wasawasa a tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A baha duma uyahimi, inapa pola ega ina peu hoi hipuli po ina hilage ma tunawana ina memae. Ma inapa ina hilage yaka apo ina lahaya po in’ugo imahi. ");
INSERT INTO tbo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Taumi polana naka pitenana, ipa omi luyagohana ona luhogaleya, yaka apo ona haleya, ma tamogi apo yautumi ona palihaleya hipuli geka uyahina yaka houga e nenei apo luyagohana ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Apo taumi iyawoi nugonugomi po uyahiu ona witubagibagi yaka ona wimulitagou po meka a memae taumi gasi ona memae. Taumi iyawoi ona bagibagi biugei, yaka Amau apo ina kawaidewedewemi.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu i baha meme i pa, ‘Houga geka uyahina nugonugou i wiyuwa duma, ma apo iyowai a lupali? Po witai geka uyahina Amau ina wihaleu? Ega u nugotuhu babana binei a nei hoi hipuli. ");
INSERT INTO tbo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nugote ana pa, “Amau om wasawasa una wogeleteya.” ’ Ma baha yadei hi noonoli i pa, ‘U wasawasa amaka a wogeleteya apo yohola a wogeletena meya.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma bolu hi towotowolo baha geka hi nonoli po hai nugotuhu hi pa, ‘Palele gololona.’ Ma gehouhi hi pa, ‘Ega, Yaubada a tu winoyanoya uyahina e ibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma Yesu i baha nae uyahihi i pa, ‘Baha o nonoli ega tau biugei ma taumi bimiyei. ");
INSERT INTO tbo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Houga amaka i geleta po tu apapoe hipuli geka uyahina he memae Yaubada a libahibahi hina wialoni, ma hipuli geka taniwagana Tomodulele apo ina halena hopuneya. ");
INSERT INTO tbo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma tau apo hina wohepau po lawa atapuhi a teina gogonihi po hina nei uyahiu.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Geka Yesu a wiatatiyana, apo iyowai ma ina hilage. ");
INSERT INTO tbo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lawa boluhi a baha hi noonoli po a bahana hi wimiheya hi pa, ‘Ata buka i paliweleiyai i pa, Yaubada a Besinana memewahagana, ma iyowai po u pa, “Lawa Moinau apo hina wohepau”? Lawa Moinana tauna Yaubada a Besinana, bo ega?’ ");
INSERT INTO tbo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu i paliwelehi i pa, ‘Houga kuku hotana yayata uyahimi i memae po geka hougana yayatana uyahinei o nenae, ma uguwa apo ina nei yaka apega tahaya ona galeya. Apo iyai uguwei ina nenae yaka apega tahaya ina galena tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Geka hougana yayata uyahimi e memae yaka yayatana ona witumaganeya, po taumi yayata tu wotagona.’ Yesu a baha geka i bahehi ma uyahihiyei i lugowadeya po i nehalehi. ");
INSERT INTO tbo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu manini wekiwekilalana magomagouhi u matahi i wogeleteya ma ega kikina hita witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mei tu bahapiko Isaiya Yaubada a baha i bahebaheya i pa, ‘Guyau, om tuwega to paliwelehi, ma ega iyai tu witumaganem? Om wipoya amaka hi galeya ma ega hita witumaganeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ma tauhi ega hita itumaganeya babana Isaiya amaka i paligeleteya i pa, ");
INSERT INTO tbo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Yaubada matahi i likekehi. Ma nugonugohi i lupupuhi, po ega emoemotahi matahiyei hina galeya ma ega emoemotahi po nugogadagadala hina tuhagaya, ma ega emoemotahi hina luhagawilehi po a luyawahihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiya baha geka i bahebaheya babana Yesu a wasawasa amaka i galena tahaeya, yaka binei i baha tahaya. ");
INSERT INTO tbo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mi Yudeya hai tanitaniwaga magomagouhi Yesu hi witumaganeya, ma tamogi ega hita paligeletena mehi, babana Palisi lawahi hi matutehi hi pa apo hai tapalolo uyahinei hina houna hopu nehi. ");
INSERT INTO tbo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tauhi nugonugohi ipa lawa hina hunehi, uyahinei Yaubada ega nugonugohi. ");
INSERT INTO tbo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu ponana i lata ma i baha i pa, ‘Apo iyai ina witumaganeu yaka Tu himiliu tauna gasi i witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Apo iyai galenau ina galena imahiyeya yaka Tu himiliu tauna amaka i galeya. ");
INSERT INTO tbo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tau yayata amaka a nei hoi hipuli, ma iyawoi apo hina witumaganeu yaka apega uguwa uyahina hina memae. ");
INSERT INTO tbo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","‘Iyai ponau i nonoli ma ega ita wiponawogogeu a apapoe apega a taniwageya po a libahibahi, babana tau ega tu libahibahi ata nei, ma u nei matababana ipa lawa a luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Apo iyai ina wihinigigiyeu, po u baha ina wihinigigiyehi yaka houga e nenei Tu luhetala u matana libahibahi apo ina wialonihi, ega tau uyahiugei ma u baha i ihinigigiyeya binei. ");
INSERT INTO tbo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Babana u baha atapuhi ega tau u nugotuhugei, ma Tu himiliu tauna i paliweleu po tau a ibaabaniyeya. ");
INSERT INTO tbo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A hanapugeya Yaubada a baha uyahinei apo yautu memewahagana ina geletai. Amau a nugotuhu i palipaliweleu po geka a palipaliwelemi.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Welulagona tolehana iyetana amaka i tuliyaliyani, ma malinatom apo hina dewaya. Ma Yesu i hanapugena dumaya a houga amaka i geleta po apo hipuli ina nehaleya po ina nae Amana uyahina. Ma Yesu a lawa hoi hipuli i luhogalena dumahi, po a luhogala i wogeleteya uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tomodulele Yudasa nugotuhu i weleya po i winugotuhuya ipa apo Yesu ina nugohaleya. Yudasa tauna Simona Isakaliyota natuna. Yesu a hewahewali mitehi hi’mam. ");
INSERT INTO tbo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nugonugonei i hanapugeya ginouli atapuhi Yaubada i weleya po tauna apo ina taniwaga. Ma i hanapugeya tauna Yaubada uyahinei i nei yaka ipa ina gunawilena meya. ");
INSERT INTO tbo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yaka amna uyahina ma Yesu i towolo po a luilui i wihaleya ma sawelo i waya po i oteni. ");
INSERT INTO tbo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ma goila i hiwogi gaeba baneina uyahina ma a hewahewali aehi i ogahi po i kokoe ma sawelona uyahinei aehi i hamagihi. ");
INSERT INTO tbo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma Yesu i oga po i nae Simona Pita uyahina ma Pita Yesu uyahina i baha i pa, ‘Guyau, ega aeu una ogogaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ega yaka Yesu i baha nae i pa, ‘Ega uta hanapugeya geka hougana awai a dewadewaya uyahim ma yohola apo una hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma Pita Yesu i paliweleya i pa, ‘Ega emoemotana po aeu una ogaya!’ Yaka Yesu Pita a baha i wimiheya i pa, ‘Inapa ega aem a ogahi, yaka apega tam u bolu.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ega yaka Simona Pita Yesu uyahina i palihalena meya po i pa, ‘Guyau, i dewadewa duma, ega aeu tunawana ma nimau po ununuwe una ogahi.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu i baha i pa, ‘Iyai tauna amaka i togo woloe po i yeuyeu apega ina togo meme babana amaka i yeuyeu, ma aena tunawahi in’ogogahi. Naka pitenana gehoumi amaka o togo woloe, ma gehoumi yohola ega ota togo.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu i hanapugena tahaeya, apo uyahihiyei gehouna ina nugohaleya. Naka binei ma i pa, ‘Gehoumi yohola ega ota togo.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","A hewahewali aehi i ogahi po i kokoe, ma a kaleko i otena meya ma i tugula ma i baha uyahihi i pa, ‘Dewa geka uyahimi a dewadewaya anona o hanapugeya bo ega? ");
INSERT INTO tbo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Taumi o baheu o pa Bada po tau Guyau, naka baha dumana. ");
INSERT INTO tbo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tau omi guyau po omi bada ma tamogi a witupoula po aemi a ogahi. Uyahinei omi lawa aehi on’ogahi. ");
INSERT INTO tbo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mei tau a itubagibagi uyahimi ona witutupoganeu po ona witubagibagi omi lawa uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A baha duma uyahimi, tu bagibagi apega a taniwaga ina gelagoni. Mei gasi tu wituwetuwega a tu tahaya apega ina gelagoni. ");
INSERT INTO tbo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","U wiatatiyana amaka o galehi po gasi o hanapugehi, ma ona bagibagiyehi, yaka apo ani kaoha baneina ona tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Baha geka ega atapumi bimiyei ma ata ibaabaniyeya, ma iyawoi a inaganimi taumi ubeimi a ibaabani. Ma Yaubada a Buka uyahina baha hi baheya lawa gehouna binei hi pa, “Lawana a yam a weleya ma i luhagawileya po i wigawiyeu.” ");
INSERT INTO tbo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","‘Ginouli uyahimi a bahebahehi, houga e nenei apo hina geleta uyahimi. Ma a houga geleta, uyahimi ipa omi witumagana uyahiu ina memae. ");
INSERT INTO tbo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A baha duma uyahimi, iyai u tu wituwetuwega ina likaohaya naka tau i likaohau. Ma iyai ina likaohau naka Tu himiliu i likaohaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu nugotuhu geka i bahena geleteya, ma u mulina nugonugona i wiyuwa duma. Yaka a hewahewali uyahihi i baha i pa, ‘A baha duma uyahimi, uyahimiyei apo lawa gehouna ina nugohaleu.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ma a hewahewali hi imatagagalena, babana ega hita hanapugeya iyai binei i ibaabani. ");
INSERT INTO tbo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tu wotagona gehouna Yesu i luhogalena dumaya, yaka i luwahala Yesu uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma Simona Pita i winimayoyoga uyahina i pa, ‘Una lubayadeya iyai binei e ibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ega yaka i luwahala imahi Yesu uyahina, ma u tanigana i wiyaguhayahaya i pa, ‘Guyau, iyai binei e ibaabani?’ ");
INSERT INTO tbo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yaka Yesu i baha nae uyahina i pa, ‘Yohola apo palawa a tomuya po gulai uyahina a wiyoli ma a weleweleya, ma ona galeya yaka naka tauna lawana.’ Yesu palawa i tomuya po i wiyoli ma Yudasa Isakaliyota i weleya, naka tauna Simona natuna. ");
INSERT INTO tbo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hougana Yudasa palawa i waya, ma Tomodulele u nugonugona i lui yaka Yesu i baha nae i pa, ‘Una bulili po om nugotuhu una dewa yagiyagineya.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesu i bahabaha nae Yudasa uyahina ega kikina a hewahewali anona hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasa tauna hai mone tu galena itetena, yaka Yesu i bahabaha nae uyahina ma gehouhi hai nugotuhu hi pa, Yudasa ina nae po hai toleha binei ina gimala, bo ina nae po tu dayadayabu mone ina welehi. ");
INSERT INTO tbo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mala emosi ma Yudasa palawa i waya po i’mam, ma i wotowolo po i hopu hoi uputa, naka amaka i uguwi. ");
INSERT INTO tbo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasa i nehalehi, ma Yesu i paliwelehi i pa, ‘U houga amaka i geleta po Lawa Moinau u wasawasa ina wawala po uyahiugei Yaubada a wasawasa ina wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Inapa Yaubada a wasawasa ina wogeleteya uyahiugei, yaka tau Natuna apo ina wiwasewaseu po u wasawasana ina wogeletena yagiyagineya. ");
INSERT INTO tbo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","‘Natunatuwe, houga kuku hotana apo tau mitemi, ma apo ona biheu ma apega ona tuhagau mei lolowa mi Yudeya uyahihi a ibaabani a pa, tuponana uyahina a nenae taumi ega emoemotami po uyahinei ona nei. ");
INSERT INTO tbo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","‘Yaka geka taumi lugagayo wouna a welewelemi ipa emosi po emosi ona lauhogalena memi. Ma ona luhogala mei a lauhogalemi, ");
INSERT INTO tbo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","po omi luhogalahi uyahihiyei lawa emosi po emosi hina hanapugemi, taumi tu wotagou.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Pita Yesu i lubayadeya i pa, ‘Guyau, meka e nenae?’ Yaka Yesu i paliweleya i pa, ‘Tuponana uyahina a nenae, ega emoemotam po houga geka una wotagou, ma yohola una wotagou.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita Yesu i lubayadena meya i pa, ‘Guyau, awai binei u pa, apega houga geka a wotagom? Amaka a palihalena meu bimgei ipa apo a hilage.’ ");
INSERT INTO tbo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ega yaka Yesu Pita uyahina i baha nae i pa, ‘Om baha ega ata kawamoineya. Ma a baha duma uyahim, apega kamkam olotona ina tou a sigana mala tonuga una bowiyeu.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu i baha nae uyahihi i pa, ‘Ega ona nugonugohelele Yaubada ona witumaganeya ma gasi ona witumaganeu. ");
INSERT INTO tbo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Amau a dobu uyahina ani wiyagohina numahi hi maga duma, yaka apo tau a nae tuponana uyahina, po omi ani mae a wononogogeya. Itapa ega, apega ata paliwelemi. ");
INSERT INTO tbo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Apo a nae po dobuna a wononogogeya po ina kokoe ma a gunawileu po a weluwinimi, po u ani maena uyahina a memae taumi gasi apo ona mae. ");
INSERT INTO tbo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tahaya uyahinei a nenae amaka o hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi i baha i pa, ‘Guyau, om ani mae ega tota hanapugeya yaka tahayana ega tota hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu i baha nae Tomasi uyahina i pa, ‘Tau tahaya, po tau baha moinana, po tau luyagohanana. Apo iyawoi nugonugohi po hina nae Amau uyahina, yaka tau uyahiugei apo hina nae Amau uyahina, babana tau tunawau tahaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yesu uyahihi i baha meme i pa, ‘Odubona ega ota hanapugeu yaka Amau ega ota hanapugeya, ma geka hougana ona wiwawala po ona hanapugeu, yaka Amau ona galeya po ona hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipo i pa, ‘Guyau, to luhogaleya ipa Amam una wiatatiyeiyai po emoemotiyai.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu Pilipo a baha i wimiheya i pa, ‘Pilipo, houga i dao duma tau mitemi ta memae, ma ega ota hanapugeu? Taumi iyawoi amaka o gagaleu naka Amau o galeya, ma awai binei u pa, “Amam una wiatatiyeiyai”? ");
INSERT INTO tbo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilipo, nugote ega uta witumaganeu? Tau Amau uyahina a memae, ma Amau tau uyahiu e memae. Bahahi a bahebahehi ega tau u nugotuhugei, Amau tauna uyahinei. Tauna uyahiu e memae yaka a bagibagi tau uyahiugei e dewadewahi. ");
INSERT INTO tbo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Iyowai apo ona hanapugeya Amau tau uyahina a memae ma Amau tauna uyahiu e memae. Ma ega u baha yawa ma u manini amaka o galehi po o hanapugehi. ");
INSERT INTO tbo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","‘A baha duma uyahimi, taumi iyawoi o itumaganeu, yohola apo manini ona wogeletehi mei tau u manini po omi manini hina lata lagona babana apo a nehalemi Amau uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Apo gowaugei awai ona lupaliyeya yaka a welemi, uyahinei Amau a wasawasa a wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Apo ginouli awai binei gowaugei ona lupali yaka a dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu i baha meme uyahihi i pa, ‘Apo ona luhogaleu yaka, u lugagayo ona wiponawogogehi. ");
INSERT INTO tbo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma apo Amau uyahina a lupali ubeimi po omi Tu hagu gehouna ina himili tauna Alugo Woiyawa dumadumaluna po uyahimi ina mewahaga. ");
INSERT INTO tbo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tu mehipuli ega emoemotana po Alugo Dumadumaluna hina tuhagaya babana ega hita galeya po ega hita hanapugeya. Tu haguna amaka o hanapugeya u liyaliyami e memae po apo u nugonugomi ina memae. ");
INSERT INTO tbo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Apega a nehalemi po mei higohigoe, apo a gunawilena meu. ");
INSERT INTO tbo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Houga kuku hotana ma apo a nehalemi, po tu mehipuli apega hina galena meu. Ma taumi apo ona galena meu, babana apo a luyagohana meme, po gasi taumi luyagohana a welemi. ");
INSERT INTO tbo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Iyeta e nenei apo ona hanapugeu, tau Amau uyahina a memae, ma taumi uyahiu o memae, ma tau uyahimi a memae. ");
INSERT INTO tbo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Apo taumi iyawoi u lugagayo ona hanapugehi, ma ona wiponawogogehi yaka taumi o luhogaleu. Naka binei Amau apo ina luhogalemi, tau apo a luhogalemi po a wogeletena meu uyahimi.’ ");
INSERT INTO tbo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudasa gehouna (ega tauna Simona natuna) i baha i pa, ‘Guyau, iyowai apo una wogeletana mem uyahiyai, ma apega tu mehipuli uyahihi?’ ");
INSERT INTO tbo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu i baha nae uyahina ipa, ‘Apo taumi iyawoi ona luhogaleu, po u baha ona wotagohi yaka, Amau apo ina luhogalemi, po Amouna mitehi to nehi uyahimi po taumi ma tauyai ta megogona. ");
INSERT INTO tbo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iyai ega ina luhogaleu yaka u baha apega ina wiponawogogehi. Baha geka o noonolihi naka ega tau uyahiugei ma Amau uyahinei, naka tauna Tu himiliu. ");
INSERT INTO tbo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Ginouli geka a palipaliwelemi hougana mitemi ta memae. ");
INSERT INTO tbo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma houga e nenei omi Tu hagu ginouli magomagouhi apo ina wiatatiyemi, po gasi ina inugohepami awai a bahebahehi uyahimi. Tu hagu tauna Alugo Woiyawa, Amau apo ina himili tau gowaugei. ");
INSERT INTO tbo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nugodumola a wohouni uyahimi, tau u nugodumola a welemi. Tu mehipuli hai nugodumola ega mei tau u nugodumola. Uyahinei ega ona nugohelele po ona matomatouta. ");
INSERT INTO tbo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘U baha amaka o nonolihi, ma geka a palipaliwelena memi ipa apo a nae po a gunawilena meu uyahimi. U naena binei ega ona nugonugodubu ma ona kaoha, babana a nenae Amau uyahina. Inapa ona luhogalena dumau, yaka ona kaoha u naena Amau uyahina babana tauna i lata lagoniu. ");
INSERT INTO tbo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ginouli geka hougana a ibaabaniyehi apo hina geleta uyahimi ma ipa ona witumaganeu. ");
INSERT INTO tbo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Amaka ma apega a baha duma uyahimi babana hipuli taniwagana Tomodulele e nenei ipa ina liwoloeu, ma ega kikina a kadidili uyahiu. ");
INSERT INTO tbo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma ipa tu mehipuli hina hanapugeya tau Amau a luhogalena dumaya, uyahinei a lugagayo a wotagoya po apo a hilage. Amaka ma ona towolo po ta nae.’ ");
INSERT INTO tbo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu i bahena meya i pa, ‘Tau wine mayouna dewadewana, ma Amau tauna tu lupehi. ");
INSERT INTO tbo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Apo lagalaga gehouhi ega hin’ugugo, yaka Amau apo ina boliboli halehi. Ma lagalaga gehouhi hin’ugugo, yaka apo ina woimahiyehi po hin’ugo labatana. ");
INSERT INTO tbo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Taumi u baha uyahinei amaka i liyeuyeumi, ");
INSERT INTO tbo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","po mei mayau lagalagana uyahiu on’ompasi po ona memae, ma tau uyahimi a memae. Inapa ega uyahiu ona memae yaka apega ugomi hina dewadewa, galenami mei mayau lagalagana ega u babana ina memae po ega ugona. ");
INSERT INTO tbo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Tau mayau babana, ma taumi lagalagau po uyahiugei ona wilagalaga dewadewami po on’ugo imahi. Ma inapa tau ega uyahimi, ega emoemotami po awai gehouna ona dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Apo iyai ega uyahiu ina memae yaka Amau apo ina boli haleya, po ina kokodila, mei lagalaga boliboli halenahi apo hina lugogonihi po mayau ebebalana uyahina hina halehi po hina alahihi. ");
INSERT INTO tbo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Uyahiu ona memae, ma u baha uyahimi ina memae, awai nugonugomi yaka ona lupali uyahiu po apo a welemi, ");
INSERT INTO tbo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","po uyahinei ugougomi hina maga po lawa hina hanapugeya taumi tu wotagou, ma Amau a wasawasa hina galeya. ");
INSERT INTO tbo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","‘Amau i luhogaleu, mei tau gasi a luhogalemi, po u luhogala uyahina ona memae. ");
INSERT INTO tbo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Inapa u lugagayo ona wotago imahiyeya, yaka luhogalau uyahina ona memae. Mei tau Amau a lugagayo a wotagoya, po tau a luhogala uyahina a memae. ");
INSERT INTO tbo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Dewa geka a palipaliwelemi ipa u kaoha nugonugomi ina wihogoya po ona kaoha labatana. ");
INSERT INTO tbo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Geka u lugagayo, ipa emosi po emosi ona lauhogalena memi, mei tau a lauhogalemi. ");
INSERT INTO tbo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Apo iyai a lawa ubeihi ina hilage, yaka naka luhogala banei dumana. ");
INSERT INTO tbo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Taumi gasi naka pitenana, apo u lugagayo ona wiponawogogeya, yaka taumi u lawa. ");
INSERT INTO tbo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ega emoemotana po a kawatupoulemi, babana tu witupupoula hai taniwaga a nugotuhu ega hita hanahanapugeya. Ma tau a witulanemi, yaka Amau awai uyahinei a noonolihi amaka a paliwelemi. ");
INSERT INTO tbo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taumi ega ota winaganiu. Ma tau a winaganimi, yaka a himilimi ipa ugomi dewadewahi hina geleta, po ugomihi, ugo memewahagahi. Ma apo awai gowaugei ona lupaliyeya, yaka apo Amau ina welemi. ");
INSERT INTO tbo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","U lugagayo a paliwelemi ipa ona lauhogalena memi.’ ");
INSERT INTO tbo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu i baha uyahihi i pa, ‘Apo tu mehipuli hina wihinigigiyemi yaka ona nugotuhuya, tau gasi hi wihinigigiyeu. ");
INSERT INTO tbo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Itapa taumi hipuli lawahi, apo lawa hita luhogalemi, babana omi lawa. Ma taumi ega tu mehipuli hai bolu uyahina ota memae babana a inaganimi ipa hai bolu ona nehaleya. Naka binei apo tu mehipuli hina wihinigigiyemi. ");
INSERT INTO tbo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lolowa u baha a bahebaheya uyahimi, ona nugotuhuya, “Tu bagibagi ega emoemotana a taniwaga ina gelagoni.” Tau hi lipilipiliu yaka apo hina lipilipilimi. U baha ega hita wiponawogogeya, yaka omi baha apega hina wiponawogogehi. ");
INSERT INTO tbo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dewaapapoehi apo hina dewahi uyahimi, babana taumi tu wotagou, ma Tu himiliu ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Itapa lolowa ega ata nei po ata paliwelehi, apo Yaubada ega ita wigouhi. Ma amaka a nei po a paliwelehi, yaka ega emoemotana iyai gehouna ina baha walewalegama hai apapoe ubeihi. ");
INSERT INTO tbo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Apo iyai ina wihinigigiyeu, yaka Amau i wihinigigiyeya. ");
INSERT INTO tbo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Lolowa manini u hayahi a dewadewahi naka ega iyai gehouna emoemotana ina dewaya. Maninina amaka hi galeya ma hi wihinigigiyeu po Amau hi wihinigigiyeya yaka apo ina wigouhi po ega hai ani bowi gehouna. ");
INSERT INTO tbo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hai wihinigigiyana anona i lugeletena dumaya, hai Buka Yaubada Mose i weleweleya i pa, “Hai luhinigigai ega anona.” ");
INSERT INTO tbo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Apo omi Tu hagu a himili uyahimi tauna Alugo Dumadumaluna. Amau uyahinei apo ina nei po ina limoina tau biugei, ");
INSERT INTO tbo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ma taumi ona limoineu babana houga a wawala uyahinei i nei po amalai tau mitemi.’ ");
INSERT INTO tbo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu i baha nae uyahihi i pa, ‘U baha geka a palipaliwelemi, ega ipa uyahihi ona pipeu. ");
INSERT INTO tbo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Babana apo numa tapalolo uyahinei hina wiyagami, ma houga e nenei apo hina lihilagenimi. Ma hai nugotuhu apo hina pa geka Yaubada anani kaoha. ");
INSERT INTO tbo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hai dewa apapoehi apo hina dewehi uyahimi, matababana Amau ma tau ega hita hanapugeiyai. ");
INSERT INTO tbo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ginouli geka a palipaliwelemi, hougana hina gelegeleta uyahimi, u baha geka ipa ona nugotuhu momohihi. Ginouli geka lolowa ega uyahimi ata baheya, babana tau mitemi ta memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","I baha meme uyahihi i pa, ‘Geka hougana a bahebahehi, babana kikina ma apo a nehalemi po a nae Tu himiliu uyahina. Uyahinei o nugodubu duma. Ma ega iyai gehouna uyahimiyei ita lubayadeu po ita pa, “Meka e nenae?” ");
INSERT INTO tbo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A baha duma uyahimi, u naena i haki wahaga, babana inapa ega a nehalemi, apega Tu hagu ina nei uyahimi. Ma a nehalemi po a nae yaka, Tu hagu apo a himili uyahimi. ");
INSERT INTO tbo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Apo ina nei hoi hipuli, yaka lawa hai dewa apapoehi ina wogeletehi ma Yaubada a dewa dewadewana, ma Yaubada a libahibahi ina wogeletehi. ");
INSERT INTO tbo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dewaapapoehi ina wogeletehi babana lawa ega hita witumaganeu. ");
INSERT INTO tbo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dewa dewadewana ina wogeletehi, babana tau amaka a nenehalemi Amau uyahina, po apega ona galena meu. ");
INSERT INTO tbo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Libahibahi ina wogeleteya babana Yaubada Tomodulele hipuli taniwagana amaka i libahibahi po a apapoe bigona i wialoni. ");
INSERT INTO tbo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘U wiatatiyana hi maga duma he memae, ma geka hougana apega atapuna a baheya uyahimi, babana ega emoemotami po ona hanapugena pahi. ");
INSERT INTO tbo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yohola apo Alugo Dumadumaluna ina nei uyahimi, po tauna ina tahaemi ginouli dumadumaluhi atapuhi uyahihiyei. Apega tauna a nugotuhugei ina ibaabani. Yaubada uyahinei awai i noonolihi apo u nugonugomi ina wogeletehi, ma ina paliwelemi houga he nenei ubeihi. ");
INSERT INTO tbo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","U wasawasa apo ina wogeleteya uyahimi, po ina wiatatiyemi tau biugei. ");
INSERT INTO tbo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Amau a ginouli atapuhi tau galiugei, naka binei a palipaliwelemi a pa, apo ina wiatatiyemi tau biugei. ");
INSERT INTO tbo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Houga kikina ma apega ona galeu, ma gasi houga kuku hotana ma apo ona galena meu.’ ");
INSERT INTO tbo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesu i baha a hewahewali uyahihi i pa, ‘Ma tunawahi hi laubayadena mehi hi pa, ‘A baha geka anona awai ma i baha i pa, “Houga kikina ma apega ona galeu, ma gasi houga kuku hotana ma apo ona galena meu, babana a nenae Amau uyahina.” ");
INSERT INTO tbo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A baha i bahebahehi anohi ega tata hanapugehi. “Houga kikina” anona awai?’ ");
INSERT INTO tbo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu hai nugotuhu amaka i hanapugeya, ipa apo hina lubayadeya, yaka i baha nae uyahihi i pa, ‘O luhogaleya ipa u baha anona ona hanapugeya? “Houga kikina” anona awai? Ma “houga kuku hotana” anona awai? ");
INSERT INTO tbo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A baha duma uyahimi, yohola apo a nugodubumi ona tou, ma tu mehipuli atapuhi hina kaoha. Ma ona nugodubu, po omi nugodubuna ina buiya po ona kaoha labatana. ");
INSERT INTO tbo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Galenana mei wawine a houga wigunaguna, wiyuwi baneina i wialoni, ma a wigunaguna u mulina wiyuwa atapuna nugona i guluwihi, babana tewela amaka i guni po i kaoha. ");
INSERT INTO tbo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Taumi naka pitenana, houga e nenei apo wiyuwa ona wialoni, ma yohola apo ona galeu, yaka ona kaoha duma ma omi kaohana apega iyai gehouna ina wihaleya uyahimiyei. ");
INSERT INTO tbo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Naka hougana lubayada ega ona weleweleu. A baha duma uyahimi omi luhogala awai yaka, ona lupali Amau uyahina tau gowaugei, po ina welemi. ");
INSERT INTO tbo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Houga odubona po amalai, ega awai gehouna gowaugei ota lupaliyeya Amau uyahina, ma tamogi ona lupaliyeya po ina welemi po omi kaoha ina lata lagona. ");
INSERT INTO tbo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‘Baha wiluwaluwagei a ibaabani uyahimi. Ma houga e nenei apega baha luwaluwagei a paliwelemi, ma apo a baha dumalu Amau binei. ");
INSERT INTO tbo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Iyeta he nenei uyahihi tau gowaugei ona lupali uyahina. Ega omi luhogala ipa tau Amau uyahina a laupaliyehi babana ");
INSERT INTO tbo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Amau i luhogalena dumami po omi luhogala ina welemi. I lauhogalemi babana taumi o luhogalena dumau, po o witumaganeu, tau Yaubada uyahinei a nei. ");
INSERT INTO tbo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Amau uyahinei a nei hoi hipuli, po hipuli uyahina a memae, ma geka hougana a gunagunawilena meu Amau uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A hewahewali hi baha nae uyahina hi pa, ‘Guyau, geka hougana baha dumanei e palipaliweliyai, ma ega bahaluwaluwa uyahinei, ");
INSERT INTO tbo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","po to hanapugem, tam ginouli magomagouhi u hanapugehi yaka i nugopilipili u hanapugehi po to witumaganem tam Yaubada uyahinei u nei.’ ");
INSERT INTO tbo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu i paliwelihi i pa, ‘Amaka o witumaganeu, bo? ");
INSERT INTO tbo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Houga e nenei bo amaka geka hougana, apo ona nohanoha memi, po yamoha po yamoha anu meyagai, ma tunawau apo a memae. Ma ega tau tunawau, ma tamogi Yaubada mitehi. ");
INSERT INTO tbo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","‘Baha geka a palipaliwelemi ipa a nugodumolami ona memae, babana tau mitemi. Hoi hipuli pilipili apo ona wialonihi ma on’omtaibagibagi, babana hipuli a kadidili tau a gelagoni.’ ");
INSERT INTO tbo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ginouli atapuhi i bahehi po hi kokoe, ma i galena gae hoi yada ma i lupali i pa, ‘Amau, u houga amaka i geleta, Tau natum om wasawasa una weleu po om wasawasa a wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Amau hipuli taniwagana u weleu po ipa lawa a taniwagehi. Ma lawa u weleweleu, luyagohana tuwetuwenai apo a wele damaneya uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Geka luyagohana tuwetuwenai, apo lawa hina hanapugem po hina pa tam Yaubada dumam po hina hanapugeu tau Yesu Besibesinanau po tam u himiliu. ");
INSERT INTO tbo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Hoi hipuli om wasawasa a wogeleteya babana om bagibagi u weleweleu amaka a wikokowihi. ");
INSERT INTO tbo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Amau, ee, geka hougana u matam una wiwasewaseu, mei lolowa tam ma tau ata ani mae wasawasa uyahina ta memae pite. Apoma muliyei a nei hoi hipuli. ");
INSERT INTO tbo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Ma lawa hipuligei u weleweleu om dewa atapuhi amaka a wiatatiyehi babana tam om lawa ma u weleu yaka om baha hi wotagohi, ");
INSERT INTO tbo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","po u wipoya hi hanapugeya tam uyahimgei i nei. ");
INSERT INTO tbo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma baha u weleweleu amaka a wiatatiyehi po u nugonugohi he memae, yaka hi hanapugena imahiyeya tam u himiliu po uyahimgei a nei, po tau hi witumaganeu. ");
INSERT INTO tbo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‘Yaka geka hougana ubeihi a laupali uyahim, ega tauhi tu mehipuli ubeihi ata laupali, ma tauhi lawahi u weleweleu ubeihi a laupali babana tauhi om lawa. ");
INSERT INTO tbo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ma om lawahi tau u lawa mei gasi u lawa tam om lawa. Yaka ata lawahi hai witumagana uyahinei a wiwasawasa. ");
INSERT INTO tbo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tau geka hougana ipa hipuli a nehaleya po a nehi uyahim. Ma tauhi hoi hipuli he memae ubeihi a laupali. Amau waiwoiyawam, gowam waipoyanei una galena itetehi. Ma gowam u weleweleu uyahinei hina wiemota, mei tam ma tau po ta iemota pite. ");
INSERT INTO tbo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Houga magomagouna tau mitehi to memae ma gowam u weleweleu uyahinei a galena itetehi, po ega gehouna ita lugowadeya. Ma emosi hota tauna apapoe galinei apo ina lugowadeya po om Buka bahana ina limoineya. ");
INSERT INTO tbo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‘Amau, ee, ega daona ma apo a nehi uyahim, ma u baha hoi hipuli a bahebaheya, ipa u kaoha ina mewahaga uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Om baha amaka lawa a paliwelehi, uyahinei tu mehipuli tu witumaganeu hi wihinigigiyehi babana tu mehipuli hai bolu uyahina ega hita memae, mei tau gasi ega ata memae. ");
INSERT INTO tbo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tu witumagana ubeihi a laupali uyahim ipa hoi hipuli hina memae, ma una galiwiiwilehi po Tomodulele a wipoya ega ina wogowogo dadanihi. ");
INSERT INTO tbo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tauhi ega tu mehipuli hai bolu uyahina hita memae, babana tauhi mei tau. ");
INSERT INTO tbo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Om baha una wiatatiyehi po om baha dumadumalunei una wiwoiyawehi. ");
INSERT INTO tbo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ma tam u himiliu hoi hipuli, ma tau apo a himilihi tu mehipuli uyahihi. ");
INSERT INTO tbo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tauhi ubeihi ma a palihalena meu tam uyahim, yaka houga e nenei tauhi hina palihalena mehi anai dumaluhi tam uyahim. ");
INSERT INTO tbo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Amau, ee, ega tu wotagou tunawahi ubeihi ata laupali, ma tu wotagou hai wibaabani uyahina, ma iyawoi hi itumaganeu tauhi ubeihi gasi a laupali, ");
INSERT INTO tbo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ipa atapuhi hina wiemota, po ta megogona. Mei tam ma tau, ta memae pite. Yaka tu mehipuli ata bolu hina galeya po apo hina witumaganeu tam u himiliu. ");
INSERT INTO tbo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wasawasa u weleweleu amaka tu wotagou a welehi, po ipa hina wiemota, po mei tauta ta iemota pite. ");
INSERT INTO tbo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tau uyahihi a memae, ma tam uyahiu e memae, geka uyahinei apo hina wiemota imahi, po tu mehipuli hina hanapugena dumaya tam u himiliu, ma gasi hina hanapugeya tam tu wotagou u luhogalena dumahi, mei u lauhogaleu pite. ");
INSERT INTO tbo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Amau, ee, u luhogala geegeka, lawa u weleweleu tauhi ma tau to megogona, po u wasawasa hina galeya. Babana om wiwawala hi wimuli ma tau u wasawasa om luhogalagei u wele tahaeu. ");
INSERT INTO tbo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","‘Amau, tam tu dewadewa, ma tu mehipuli ega hita hanapugem, ma tau amaka a hanapugem. Ma tu wotagou amaka hi hanapugeta, babana u himihimiliu binei. ");
INSERT INTO tbo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Om nugotuhu lawa uyahihi amaka a wogeleteya, yohola apo a wogeletena meya uyahihi, po ipa hina hanapugena dumam, om luhogala u nugonugou e memae, po tauhi gasi u nugonugohi una memae, mei tau apo uyahihi a memae.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu a lupali i wikokowi, ma a hewahewali mitehi hi nae po Kidiloni goilana hi damani, po hi lui tano oliweta uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Yudasa Yesu i nugonugohaleya, tupo naka amaka i hanapugeya, babana Yesu a hewahewali mitehi houga magomagouna hi nenae. ");
INSERT INTO tbo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yaka Yudasa tu wigawiya boluhi i weluwinihi po hi nae hoi tano. Ma hi nenae naka tanitaniwaga hi himilihi, tauhi tu witalaguyaba babadahi po Palisi lawahi hai bolu uyahihiyei hi’mhimila po hi nae, a nimagawiya gapolahi po a nima heutahi. ");
INSERT INTO tbo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu apo awai ina gelegeleta uyahina amaka i hanapugeya, yaka i nae tu wigawiya uyahihi po i lubayada i pa, ‘Iyai o bibiheya?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ma hi baha hi pa, ‘Yesu, lawa Nasaletagei to bibiheya.’ Ma Yesu i baha uyahihi i pa, ‘Tau geka.’ Ma Yudasa tu wigawiya mitehi hi towotowolo. ");
INSERT INTO tbo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hougana Yesu i bahabaha i pa, ‘Tau geka,’ ma tu wigawiya hi tudeiwa nae po hi guli hoi hipuli. ");
INSERT INTO tbo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","I baha meme uyahihi i pa, ‘Iyai o bibiheya?’ Ma hi baha hi pa, ‘Yesu, lawa Nasaletagei.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yaka Yesu i baha uyahihi i pa, ‘Amaka a paliwelemi a pa geka tau, inapa ona bibiheu yaka u hewahewali ona palihalehi po hina nae.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A bahana i limoineya, babana a lupali Amana uyahina i pa, ‘Amau, lawa u weleweleu ega gehouna ata haleya.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simona Pita u liyaliyana i towotowolo a kwasikwasi i holi po tu witalaguyaba hai taniwaga a tu bagibagi tanigana i lubuya po taniga hinebawana i talutuiya (gowana Makosi). ");
INSERT INTO tbo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu i baha nae Pita uyahina i pa, ‘Amaka, ma om kwasikwasi ani hounana uyahina una houna meya. Ma wiyuwa uyahina ega una lauguduguduwe, babana wiyuwa umaumana Amau i weleu.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tu wigawiya hai taniwaga mitehi, ma gasi tanitaniwaga hai hewahewali, Yesu hi womomohi ma hi numa panipani. ");
INSERT INTO tbo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hi weluwaya po hi tahaya nae Anase uyahina, babana tauna Kayapa pohiyana. Kayapa tauna tu witalaguyaba hai taniwaga bolima naka uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tauna lolowa mi Yudeya hai omboina uyahina i wibaabani tahaya i pa, ‘Hilaki lawa gehouna ita hilage lawa boluta ubeita.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hougana hi weluwaya Anase a numa uyahina Pita Simona ma Yesu a hewali gehouna, tauhi Yesu hi wotagoya. A hewalina tu witalaguyaba hai taniwaga i hanapugeya, yaka bolu mitehi hi lui gogona a numa u gali hinena. ");
INSERT INTO tbo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita ega ita lui ma gali matetana u liyaliyana i towotowolo, yaka hewalina tu witalaguyaba hai taniwaga a heliyam i nae po guguhini gehouna mateta tu galena itetena i paliweleya ipa Pita ina lui yaka guguhinina i baha po Pita ipa ina lui. ");
INSERT INTO tbo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pitana i luilui nae ma guguhinina i baha nae Pita uyahina i pa, ‘Nugote tam lawana a hewali gehouna?’ Ma Pita i bowi i pa, ‘Tau ega.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Houga waiyau hougana yaka, tu bagibagi po tu wigawiya mayau hi ahili po hi lalana, ma Pita i nae po mitehi hi lalana gogona. ");
INSERT INTO tbo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hi lalana ma tu witalaguyaba hai taniwaga Yesu i laubayabayadeya i pa, ‘Tu wotagom iyawoi? Ma awai u wiatatiyehi?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu a baha i wimiheya i pa, ‘U wiatatiyana hi lugelegeletehi lawa uyahihi, hoi numa tapalolo po gasi Yelusalem a numa dalabu baneina u hinena. Ma mi Yudeya hi luilui yaka u wiatatiyana atapuhi amaka hi hanapugehi ega iyai gehouna gowagowadei ata wiatatiyana. ");
INSERT INTO tbo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ega una laubayadeu ma u baha tu nonolina una lubayadehi apo hina paliwelem, awai a bahebahehi po a iatatiyaneya, atapuhi amaka hi nonolihi po hi hanapugehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu a baha i bahebaheya, ma tu galena itete u liyaliyana i towotowolo, i lunawatatani ma i pa, ‘Awai binei tu witalaguyaba hai taniwaga e palipalimatani?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu tu galena itete a baha i wihiheya i pa, ‘Inapa u baha powa awai yaka, lawa uyahihi una lidumaluya. Tau u baha i dumalu, ma om nogutuhu awai po u launiu?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anase, Yesu anai panipanina ma i himili po i nae Kayapa uyahina. Tauna tu witalaguyaba hai taniwaga. ");
INSERT INTO tbo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma Simona Pita i memae po lawa mitehi hi ilalana ma hi baha nae uyahina hi pa, ‘Geka tam nugote lawana tu wotagona gehouna?’ Ma Pita i bowi meme i pa, ‘Tau ega!’ ");
INSERT INTO tbo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma tu witalaguyaba hai taniwaga a tu bagibagi tanigana i boliboli haleya tulana i baha i pa, ‘U koyama; tam Yesu mitehi hoi tano a galem.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita i bowibowi meme, ma kamkam i tou. ");
INSERT INTO tbo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yesu Kayapa a numagei hi weluwaya po hi niyeya gawana Pilato a numa uyahina. Hougana hi niniyeya ma malatom i yayahi, po ega emoemotana mi Yudeya hina lui gawana a numa u hinena matababana Pilato ega tauna lawa Yudeyagei. Apo hina lui yaka hina wigobugena mehi po Welulagona tolehana uyahina apega hina am. ");
INSERT INTO tbo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yaka Pilato i hopu hoi uputa po lawa uyahihi po i lubayada i pa, ‘Baba awai ma lawa geka o wigouya?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mi Yudeya a baha hi wimiheya hi pa, ‘Itapa ega tu apapoe, apega tota neiyai uyahim.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato i baha meme uyahihi i pa, ‘Tau apega a luhetaleya, ma taumi omi lugagayo uyahinei ona luhetaleya.’ Mi Yudeya hi pa, ‘Tauyai ega palihalena tota waya ipa lawa geka a hilage binei to taniwaga po to witakeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ma tauna a hilage lolowa i baheya i pa, ‘Apo mayau u moyana hina witakeu.’ Yaka geka a houga i geleta.) ");
INSERT INTO tbo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato i lui meme a numa u hinena, ma Yesu i otugeya po i lui. Ma i lubayadeya i pa, ‘Tam mi Yudeya hai Wasawasa?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu Pilato a lubayada i wimiheya i pa, ‘Om lubayada geka tam uyahimgei bo lawa hai baha binei ma e laubayadeu po u pa tau mi Yudeya hai Wasawasa?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato i baha nae Yesu uyahina i pa, ‘Ega tau lawa Yudeyagei. Tam om lawa po om tu witalaguyaba babadahi, tauhi hi himilim po u nei. Ma om apapoe awai?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu Pilato a baha i wimiheya i pa, ‘Ega u wasawasa hoi hipuli, itapa u ani taniwaga hoi hipuli apo u hewahewali biugei hita wigawiya po mi Yudeya apega hita paniu. Ma u ani taniwaga u tupo geha.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato i lubayada meme i pa, ‘Moina, tam Wasawasa?’ Yesu bahana i wimiheya i pa, ‘Ee, naka pitenana, tau Wasawasa. Tau hoi hipuli a nei po hi guniu ipa a wiwasawasa po dewa dumadumaluna a wipaliweleneya, apo iyawoi nugonugohi hina lugadagadalihi yaka u baha hina wiponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato i lubayada i pa, ‘Dewa dumadumaluna anona awai?’ Yaka Pilato i hopu hoi uputa po mi Yudeya uyahihi i baha nae i pa, ‘Geka lawana ega a powa ata tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Taumi omi dewa houga magomagouna Welulagona tolehana uyahina, lawa panipanina a lupelupena haleya hoi numa pani. Ma o luhogaleya ipa mi Yudeya omi Wasawasa a lupena haleya, bo?’ ");
INSERT INTO tbo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Atapuhi hi otu labatana hi pa, ‘Apeega, ega tauna, to luhogaleya Balaba una lupena haleya.’ Balaba tauna tu danene baneina. ");
INSERT INTO tbo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato i lui numa u hinena po Yesu tu wigawiya i welehi, po gulawa metametanana uyahinei hi wilawi. ");
INSERT INTO tbo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tu wigawiya unuhau gologolowa waidonadonana hi metami po Yesu hi winabaya. Ma luilui kayakayana hi wiluiya. ");
INSERT INTO tbo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ma hi nae u liyaliyana po hi lauguyoguyougeya hi pa, ‘Tinani tam, mi Yudeya hai Wasawasa.’ Ma nimahiyei hi launawatatani. ");
INSERT INTO tbo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato i hopu meme hoi uputa, po bolu uyahihi i baha nae i pa, ‘Lawana ona galeya, a neiyena meiyai uyahimi, ipa ona hanapugeya ega kikina a powa ata tu hagaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu i hopu hoi uputa po unuhau gologolowa waidonadonana i nabaya ma luilui kayakayana i luiya. Ma Pilato i baha nae uyahihi i pa, ‘Hei, lawana ona galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tu witalaguyaba babadahi po hai tu bagibagi Yesu hi galeya ma hi otu labatana hi pa, ‘Una witakeya!’ Pilato i baha nae uyahihi i pa, ‘Tunawami ona niyeya po ona witakeya; tau a powa ega ata galena tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mi Yudeya hi baha meme hi pa, ‘I lugagayo i baheya i pa, apo ina hilage, babana lugagayo i tulagoni po tunawana i bahena meya ipa tauna Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Geka bahana Pilato i noonoli po i matouta duma. ");
INSERT INTO tbo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yaka Pilatona Yesu i weluwimeya po hi lui meme hoi numa. Ma i lubayadeya i pa, ‘Miyei u nei?’ Ma Yesu ega awai ita baheya, ma i genugenuwana. ");
INSERT INTO tbo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ega yaka Pilatona i baha nae Yesu uyahina i pa, ‘U baha ega nugonugom wimeihana, ma u taniwaga emoemotau po a lupena halem, bo a wihilagenim.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu Pilato a baha i wimiheya i pa, ‘Om taniwaga Yaubada uyahinei i nei. Tu witalaguyaba hai taniwagana i palihaleu yaka tauna a gou baneina apoma tam.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yesu a baha Pilato i noonoli po ipa ina lupena haleya. Ma mi Yudeya hi otu labatana hi pa, ‘Apo lawa geka una lupena haleya, yaka ega tam Sisa tulana. Babana Yesu tunawana i wiwasewasena meya, yaka ata wasawasa Sisa i widibogi.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato hai baha i nonoli yaka, Yesu i hopunena meya hoi uputa, po i tugula geleta ani luhetala uyahina, gowana Gahana (mi Yudeya hai ponei hi pa ‘Gabata’). ");
INSERT INTO tbo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iyeta amaka hi luliyaliyani po ipa apo hina geleta Welulagona amna iyetana uyahina. Iyeta u bolina ma Pilato mi Yudeya i paliwelehi i pa, ‘Ona galeya geka omi Wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma hi otu labatana hi pa, ‘Ona uni, ona uni, ona tutulawiteya hoi ani take.’ Pilato i baha uyahihi i pa, ‘Tau ipa omi Wasawasa a wibaleya hoi ani take?’ Tu witalaguyaba babadahi hi baha i pa, ‘Ega kikina i Wasawasa gehouna; Sisa tunawana i wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ega yaka Pilato Yesu i palihaleya mi Yudeya uyahihi ma mi Loma hai tu wigawiya apo hina witakeya. ");
INSERT INTO tbo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tu wigawiya Yesu hi numa panipani po anani take tunawana i awali, po i nae meyagai hi igowaya hi pa, Ununu Dobuna uyahina, mi Yudeya ponahiyei hi pa, Gologota ");
INSERT INTO tbo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","po noka hosi hi witakeya, ma lawa luwaga mitehi, gehouna u kehana ma gehouna u awala hinebawana, ma Yesu u tipolina. ");
INSERT INTO tbo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato i’mgiluma po Yesu anani take u tepana i tutulawiteya i pa, ‘Yesu Nawaleta lawana mi Yudeya hai Wasawasa’. ");
INSERT INTO tbo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mi Yudeya magomagouhi giluma geka hi hiyawa tuhagaya, babana dobuna uyahina hi itakeya naka hai dobu baneina u liyaliyana. Yaka gilumana hi hanapugeya babana pona tonuga uyahinei hi gilumi, mi Yudeya, mi Loma, po mi Giliki. ");
INSERT INTO tbo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mi Yudeya hai tu witalaguyaba babadahi hi nei Pilato uyahina, po hi baha nae hi pa, ‘Awai binei u gilumi u pa, mi Yudeya i Wasawasa? Tauna i bahena meya i pa, ‘Tau mi Yudeya omi Wasawasa.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato hai baha i wimiheya i pa, ‘Giluma a gilugilumi naka amaka tauna.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tu wigawiya magouhi wohepali Yesu hi witakeya, ma a kaleko hi gutaya po yamoha i wiwaya. Ma a luilui gasi hi waya, ma luiluina hi diidini ega popona. ");
INSERT INTO tbo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tunawahi ma hi iwogatala hi pa, ‘Ega ta looloya, ma ta wikibu po iyai ina waya yaka tauna galinei.’ Ma Yaubada a baha hoi Buka ina wialona imahiyeya, ‘U kaleko hi gutaya, ma u luilui binei hi wikibu.’ Yaka tu wigawiya dewa geka hi dewaya. ");
INSERT INTO tbo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu anani take u liyaliyana, hinana ma walehina Maliya Kilopa agona, ma gasi Maliya Magadalagei hi towotowolo ani take u labena. ");
INSERT INTO tbo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu hinana, a hewali i lauhogaleya u liyaliyana i towotowolo, yaka Yesu i baha nae uyahina i pa, ‘Hinau, natum una galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Gasi i baha nae a hewali uyahina i pa, ‘Tulau, hinam una galeya.’ Ega yaka a hewalina Yesu hinana tu gunina i weluwaya po mitehi hi memae a numa uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu i hanapugena dumaya bagibagi emosi po emosi uyahina hina kokoe. Yaka i baha i pa, ‘Uyopopou i haleeya,’ baha geka uyahinei Buka a baha i wikokowi. ");
INSERT INTO tbo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma wine waitululuwana keyaka uyahina hogohogona i memae tuponana uyahina. Baloi hi waya po wine waitululuwana uyahina hi ligayoya, ma hiyamoni gowana hisopa uyahina hi numa panipani lawiteya, ma hi wiyoyoga giyeya u gamona po i hanalemoya. ");
INSERT INTO tbo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu wine waitululuwana i waya, ma i baha i pa, ‘Amaka i kokoe,’ ma unununa i yagelo, ma yautuna i kokoe. ");
INSERT INTO tbo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mi Yudeya hai dalabu iyetana i tulabeni. Yaka mi Yudeya hi nae po Pilato hi lubayadeya ipa lawa hi takehi aehi hina lauwotowihi ma ani take uyahinei hina wihalehi, babana ega ita dewadewa ipa hoi ani take hina memae, ma dalabu iyetana ina geleta. Matababana mi Yudeya iyeta dalabu naka tauhi hi wiyateyatena dumaya. ");
INSERT INTO tbo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yaka tu wigawiya hi nae po lawa luwaga Yesu mitehi hi itake gogonehi aehi hi lauwotowihi. ");
INSERT INTO tbo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hi nae po Yesu hi gagaleya, naka amaka i hilage yaka ega aena hita luwotowi. ");
INSERT INTO tbo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma tu wigawiya gehouna iyelagei Yesu tolotolona i tonaya, mala emosi ma goila ma tala hi kololo Yesu tolotolonei. ");
INSERT INTO tbo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tau a gelena tuhagaya a baha, yaka u bahana anona ipa ona witumageneya, babana tau u galena a limoinena dumaya, baha moina po baha dumahi a palipaliwelemi. ");
INSERT INTO tbo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dewa geka hi gelegeleta, naka Yaubada a Buka bahana i wikokowi i pa, ‘Apega geyamina gehouna hina luwotowi.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gasi Buka baha gehouna i baheya i pa, ‘Iyawoi tu tonana apo matahiyei hina galeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Geka dewahi hi kokoe ma u mulina Yosepa lawa Alimatiyagei, tauna tu witumagana gowagowada Yesu uyahina, babana mi Yudeya hai lugagayo i matuteya. Tauna i nae Pilato uyahina po i lubayada Yesu hinina hilahilagena binei i pa, ‘Emoemotana apo ani take uyahinei ata wihaleya po u kokowaga ata houni.’ Pilato Yosepa uyahina i palihaleya. ");
INSERT INTO tbo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, tauna odubona uguwa bolinai i nenae Yesu uyahina, tauna gasi i nei, wakatu wilawila emotana i neiyai dimumuna i lata duma a witai naka 60 kilo. ");
INSERT INTO tbo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hai luwaga Yesu hinina hi wihaleya, po wakatu dimudimumunei hi wineuli, ma kaleko wakewakekenei hi humaya. Naka mi Yudeya hai dewa, wikokowaga binei. ");
INSERT INTO tbo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu anani hilage u liyaliyana, tano i memae ma tanona uyahina kokowaga wouna hi wogoya, ma kokowagana uyahina ega kikina lawa gehouna hita wienoya. ");
INSERT INTO tbo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yesu uyahina hi wienoya, babana mi Yudeya hai iyeta wononogo dalabu binei ma gasi kokowaga u liyaliyahi. ");
INSERT INTO tbo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gaogao a iyeta tahatahayana uyahina, yohola a uguwana, ma Maliya Magadalagei i weludidibala nae hoi kokowaga, po gaimanei kokowagana matetana hi lautomgeya naka hi builena niyeya uheiya po i memae ma hi geleta. ");
INSERT INTO tbo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yaka i bulili po i nae Simona Pita ma Yesu a hewali gehouna uyahihi po i paliwelehi i pa, ‘Ata Guyau amaka kokowaga uyahinei hi wihaleya, ma ega ata hanapugeya meka hi houni.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ega yaka Pita ma hewali gehouna hi bulili luwaga po hi nae hoi kokowaga. ");
INSERT INTO tbo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hai luwagahi hi nenae po hewali gehouna i sagena duma yaka Pita a bulili haleya po i geleta tahaya hoi kokowaga, ma ega ita lui. ");
INSERT INTO tbo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ma i kululu po i lauwiwilana lui, naka kaleko yawa hi memae ma i galehi. ");
INSERT INTO tbo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Apoma Simona Pita mulinei i bulili geleta po i lui kokowaga u hinena, po Yesu humana i galeya. ");
INSERT INTO tbo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma unununa panina ma humana ega kikina ita nohahi. ");
INSERT INTO tbo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Apoma hewalina i lui, po i galehi yaka i witumagana. ");
INSERT INTO tbo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tamogi Buka a baha yohola ega hita nugotuhu tuhagaya i pa, apo hilage uyahinei ina towolo meme. ");
INSERT INTO tbo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma hi gunawilena mehi hai u numa. ");
INSERT INTO tbo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliya i gunawilena meya po kokowaga uputana i towolo ma i tutou, ma i kululu po i lauwiwilana lui kokowaga u hinena ");
INSERT INTO tbo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","po Yaubada a tu winoyanoya luwaga i galehi, hai luilui wakewakekehi hi tugutugula, gehouna u unununa, ma gehouna u aena, Yesu i enenoyana. ");
INSERT INTO tbo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hi baha nae uyahina hi pa, ‘Wawine, awai binei e tutou?’ I baha nae uyahihi i pa, ‘U Guyau hi wihaleya po meka hi houni ma ega ata hanapugeya.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A baha geka i baheya po i kokoe, ma i lauhagawileya po Yesu i towotowolo. Tamogi ega ita galena tuhagaya po ita pa Yesu. ");
INSERT INTO tbo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu i baha nae uyahina i pa, ‘Wawine, awai binei e tutou? Iyai e bibiheya?’ A nugotuhu ipa tano tu bagibagi, po i baha nae uyahina i pa, ‘Bada, inapa una wihaleya, yaka una paliweleu, meka hotanana u houni ma a nae po a waya.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu i baha nae, wawinena uyahina i pa, ‘Maliya,’ po i luhagawileya, ma mi Yudeya ponahiyei i baha nae i pa, ‘Labona’ (a bui naka, Bada). ");
INSERT INTO tbo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu i baha nae wawinena uyahina i pa, ‘Ega una wodadaniu. Yohola ega ata nae Amau uyahina. Ma tuwegau una niyeya po walewalehiu una paliwelehi una pa, Tau a gegae Amau po Amami, u Yaubada po omi Yaubada uyahina.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yaka Maliya Magadalagei i nae po a hewahewali i paliwelehi i pa, ‘Guyau amaka a galeya.’ Ma a baha i bahebaheya i paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma iyeta tahatahayana ibigana uyahina Yesu a hewahewali hai numa hi guduya, ma u hinena hi’mboina gogona po hi memae, babana mi Yudeya hi matutehi. Ma Yesu u tipolihi i lugeleteya, po i towolo ma i baha nae uyahihi i pa, ‘Atapumi ona nugodumola.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I baha ma nimana po tolotolona i wiatatiyehi. Yaka hi kaoha duma, babana Guyau hi galeya. ");
INSERT INTO tbo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu i baha meme uyahihi i pa, ‘Ona nugodumola Amau tauna i himiliu, naka pitenana apo tau a himilimi.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A baha i bahehi po hi kokoe ma i yautu damana uyahihi, ma i baha i pa, ‘Alugo Woiyawa ona waya, ");
INSERT INTO tbo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","po uyahinei lawa hai apapoe ona paligigilihi, yaka Yaubada apo ina paligigilihi ma apo iyawoi hai apapoe ona wihawenehi, yaka Yaubada apega ina paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi, tauna magouhi 12 hoi bolu uyahinei hi wigowaya hi pa, Natulagalaga, hougana Yesu i laugeleteya tauna ega mitehi. ");
INSERT INTO tbo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Gehouhi hi baha nae Tomasi uyahina hi pa, ‘Guyau amaka to galeya.’ Tomasi i baha i pa, ‘Apo Yesu nimana hi tuutuya a galeya, po nima gigiu a houni uyahina, ma tolotolona kelena uyahina nimau a houni, yaka apo a kawamoina.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dalabu gaogaona emosi i kokoe, ma numa u hinena hi memae, Tomasi mitehi, mateta hi guduya ma Yesu i geleta po u hayahi i towolo ma i baha i pa, ‘Ona nugodumola atapumi.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Apoma Tomasi uyahina i baha nae i pa, ‘Nima gigim una wiyoyoga neiyai nimau uyahina po una galeya. Ma gasi nimam una wiyoyoga neiyai tolotolou uyahina po una houni. Po ega una launugoluwaluwaga ma una kawamoineu.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi i baha Yesu uyahina i pa, ‘Oo, u Guyau ma u Yaubada.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu i baha nae Tomasi uyahina i pa, ‘U witumaganeu, babana amaka u galeu? Lawa gehouhi ega hita galeu ma hi itumaganeu, apo hina kaoha duma.’ ");
INSERT INTO tbo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu a manini wekiwekilalana gehouhi i dewadewahi, a hewahewali u matahi ega buka geka uyahina hita gilumihi. ");
INSERT INTO tbo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma wabihaga hota hi gilugilumihi, naka ipa ona hanapugeya, Yesu tauna Yaubada a Besinana lawana ma Yaubada Natuna. Yaka tauna ona witumaganeya po gowanei ona luyagohana. ");
INSERT INTO tbo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesu i wogeletena meya a hewahewali uyahihi, Tibeliya u bogana. ");
INSERT INTO tbo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Pita, ma Tomasi (tauna gowana hi pa, Natulagalaga), Nataniyela lawa Kanagei, Galili tuponana, ma Sebedi natunatuna luwaga, ma a hewahewali luwaga gasi. ");
INSERT INTO tbo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Pita i baha uyahihi i pa, ‘Tau a nenae an’ebaga.’ Hi baha uyahina hi pa, ‘Apo boluta ta negogona.’ Hi nae po wam uyahina hi gelu, ma hai hagida hi teleneya, po didibalana ega kikina iyana gehouna hit’onaya ma a sigana malitom. ");
INSERT INTO tbo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Malatomtom kikina, hi gagalena gae, ma Yesu hoi gadowa i towotowolo. Ma ega hita hanapugeya, hai nugotuhu hi pa, ‘Iyai?’ ");
INSERT INTO tbo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu i otu hopu uyahihi i pa, ‘U lawa, iyana bo ega?’ A baha hi wimiheya hi pa, ‘Eega.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma i otu hopu meme i pa, ‘Ona tuhopu ma u awala hinebawamiyei hagida ona telenena meya, yaka iyana apo ona wialoni.’ Ega yaka hagida hi teleneya po iyana hi ononaya i maga wahaga, po ega emoemotahi hagida hina nouya. ");
INSERT INTO tbo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hewalina Yesu i lauhogaleya i baha nae Pita uyahina i pa, ‘Hei, ata Guyau!’ Simona Pita i noonola ma i pa, ‘Ata Guyau,’ mala emosi ma a kaleko i oteni, babana i ebebaga binei ma i houni po i memae, ega yaka i lupa hopu hoi boga. ");
INSERT INTO tbo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gehouhi wam uyahina hi memae, hagida anai iyanana hi woe teini po hi gae hoi hayahaya, ega bala ita dao, babana guli magouna 60. ");
INSERT INTO tbo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hi gae po hoi gadowa hi gota, ma mayau ononiyana uyahina iyana hi memae, ma palawa mayouna u liyaliyana hi memae. ");
INSERT INTO tbo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu i baha nae uyahihi i pa, ‘Amalai iyana o ununihi gehouhi ona neihinimai.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ega yaka Simona Pita i gelu hoi wam po hagida i pili po i gae hoi hayahaya. Ma iyana balubaluhi hi onahi magouhi 153, ma hagida ega hita loloya. ");
INSERT INTO tbo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu i baha uyahihi i pa, ‘Ona nei po tan’am.’ Ma a hewahewali hi hanapugeya tauna Guyau ma tamogi hi witutubaha hi pa, ‘Guyau bo lawa tapuna?’ ");
INSERT INTO tbo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu palawa i waya po i welehi ma iyana naka pitenana. ");
INSERT INTO tbo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu mala luwaga i lugeleteya uyahihi, ma geka i witonugaya a towolo memena uyahina. ");
INSERT INTO tbo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Malatomtom amna hi’mam, ma Yesu i baha nae Simona Pita uyahina i pa, ‘Simona, Yoni natuna, tam iyowai, u luhogalena dumau ma apoma om bagibagi, bo?’ Pita i pa, ‘Ee Guyau, u hanapugeu tau a luhogalem.’ Yesu i baha i pa, ‘U sipi muhomuhohi una wianihi.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A bahana i wiluwagaya i pa, ‘Simona Yoni natuna, u luhogalena dumau?’ Simona i pa, ‘Ee, Guyau u hanapugeu a luhogalem.’ Yesu i baha i pa, ‘U sipi una galena itetehi.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A bahana i witonugaya i pa, ‘Simona, Yoni natuna, u luhogaleu?’ Pita baha geka i noonoli, po i nugodubu babana Yesu a baha i pa, ‘U luhogaleu?’ Yaka Yesu a baha i wimiheya i pa, ‘Guyau, ginouli magomagouhi u hanapugehi po gasi u hanapugeu. A luhogalem.’ Yesu i baha uyahina i pa, ‘U sipi una wianihi. ");
INSERT INTO tbo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A baha duma uyahim, om houga tewela uyahina om nogutuhu ipa meka una nae naka om dagilolo u lumomohi ma apo una nae. Ma apo om houga wibada uyahina nimam una lodomi po lawa gehouhi hina widagilolom, ma tupo ega uta lauhogaleya apo uyahina hina niyem.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A baha geka naka Pita a hilage binei i ibaabani, ipa hina hanapugeya. Ma a hilagena uyahina Yaubada gowana ina wilataya. Yesu Pita uyahina i baha i pa, ‘Una wootagou.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Hewalina Yesu i lauhogaleya i wotagohi ma Pita i luhagawileya po i galeya (ma nugonei i gae tauna Yesu i luhogaleya yaka toleha uyahina u nugonugona i luwahala ma i lubayadeya i pa, ‘Guyau, iyai apo ina nugohalem?’ ");
INSERT INTO tbo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Uyahinei Pita i baha nae Yesu uyahina i pa, ‘Guyau, Yoni tauna iyowai?’) ");
INSERT INTO tbo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu Pita a baha i wimiheya i pa, ‘Itapa ita memae ma ata gunawilena meu naka ega om nugotuhu. Tam tunawam una wimulitagou.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A baha geka binei ma tu witumagana gehouhi hi winugonugotuhu powa, po hi pa, ‘Yoni apega ina hilage.’ Yesu ega ita baha uyahina ita pa, ‘Apega ina hilage’; tamogi i pa, ‘Itapa u nugotuhu ita memae ma ata gunawilena meu, naka ega om nugotuhu.’ ");
INSERT INTO tbo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A hewali gehouna ginouli magomagouhi i bahebahehi amaka i giluma hopunehi, ma lawa magomagouhi hi limoineya. ");
INSERT INTO tbo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ginouli atapuhi i dewadewahi, itapa emosi po emosi hita gilumi, a nugonugotuhuya apo buka hita maga duma po hipuli tupo wohepali hita wihogoya. ");
INSERT INTO tbo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyopilasi, u buka tahatahayana u hinena Yesu a bagibagi i wawali hougana, ginouli atapuhi i dewadewahi po i iatatiyanehi a gilugilumi ");
INSERT INTO tbo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","i nae po a siga iyetana Yaubada i waya po i gae hau yada. Yohola ega po ita gae ma Alugo Woiyawa a hanapugei litahatahaya a tu wituwetuwega i inaganihi i welehi. ");
INSERT INTO tbo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A hilage u mulina dewa tapuna po tapunei i woogeletena meya a tu wituwetuwega ugolihi ma i mamae naka iyeta magouhi 40. Ma iyowai i woogeletena meya naka ega ani lunugoluwaluwaga ma tamogi moina dumana i lauyagohana. A tu wituwetuwega hi galeya po mitehi hi ibaabani naka Yaubada anani taniwaga i paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hougana tauna po a tu wituwetuwega hi’mtuboina gogona ma i baha kadidili ugolihi i pa, ‘Ega Yelusalem ona nenehaleya. Amau anani’mbenena i palipaliwitumaganana a bahebaheya ona ototoni, ");
INSERT INTO tbo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","babana Yoni goilei lawa i bapatisohi ma taumi apo iyeta wabihaga u hinena Alugo Woiyawa ugolinei bapatiso ona waya.’ ");
INSERT INTO tbo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu a tu wituwetuwega mitehi hougana hi yamtuboina gogona naka hi lubayadeya hi pa, ‘Guyau, apo geka u hougana mi Isalaela i witaniwaga una wele meiyai?’ ");
INSERT INTO tbo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu hai baha i wimihaya i pa, ‘Amau tuawana a taniwagagei apo geka ginoulihi wawala hougahi ina hounihi ma ega ipa taumi ona hanapugehi. ");
INSERT INTO tbo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma tamogi hougana Alugo Woiyawa ugolimi ina geleta, apo ona manini. Taumi apo tuwegau ona nohaya lawa atapuhi u Yelusalem dobuna ugolina po tupo Yudeya po Samaliya ma i nae po hipuli a u ani kokoe ugolihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Geka a bahana u mulina Yaubada i waya po i gae hau yada. Hi ihalu ma yaloi Yesu i guduya po u matahi i lugowadeya. ");
INSERT INTO tbo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesu i nenae ma a tu wituwetuwega hi todi ma hi ihalugeya ma mala emosi lawa luwaga, hai kaleko wakewakekehi awa hi lugeletehi po u liyaliyahi hi towotowolo. ");
INSERT INTO tbo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Lawahi luwaga hi lubayada hi pa, ‘Lawa mi Galili, iyowai po o towolo ma o ihalu gae hau yada? Yesu lolowa mitehi o mamae ma iyowai Yaubada i waya po e gegae hau yada naka apo dewana emotanei ina gunawileya.’ ");
INSERT INTO tbo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oliweta u oyana ma hi gunawilehi po hi nenae u Yelusalem naka balana ega ita dao babana oyana naka Yelusalem u liyaliyana. ");
INSERT INTO tbo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma hougana hi lui u Yelusalem po hi gae numa babanoyana wiluwaganaa ugolina, noka u hougana hi mimiyeya. Tu wituwetuwegahi naka: Pita, Yoni, Yamesa, Andulu, Pilipo, Tomasi, Batolomiu, Matiu, Yamesa Alipi natuna, Simona tauna mi Yudeya hai tu’mpaligudugudu, Yudasa Yamesa natuna. ");
INSERT INTO tbo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Houga magomagouna tauhi ma Yesu tu wotagona wiwinehi, po Maliya, Yesu hinana, po Yesu walewalehina naka hi yamtuboina gogona ma hau tapalolo hi welewele mehi. ");
INSERT INTO tbo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Houga noka ugolina tu witumagana nugote magouhi 120 hi’mtuboina mai ma Pita i towolo po ugolihi i baha i pa, ");
INSERT INTO tbo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","‘Walewalehiu, Yaubada a baha amaka i limoineya. Ugolinei ma Alugo Woiyawa Dawita i tubahabahaya po i bahabaha piko tu’mpalihalena binei. Po amaka Yudasa tauna lawa i litahatahaehi po Yesu hi numa panipani. ");
INSERT INTO tbo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudasana Yesu i winagani po a tupo i dewaya ata bagibagi u hinena, po tauna tulata igehouna.’ ");
INSERT INTO tbo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudasana i benabenama po mihana hi weleweleya ugolinei hipuli i gimaleya. Ma geka hipulina ugolina i peu po amamona a liyalapoila po i hilage. ");
INSERT INTO tbo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lawa atapuhi u Yelusalem hi nonoli yaka hipulina hi wigowaya hai ponei hi pa Akedama bo ta baheya Hipuli Waitalana.) ");
INSERT INTO tbo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita gasi i baha i pa, ‘Buka Sam ugolina Yudasa ubeina i baheya i pa, “A numa ina gouda po ega lawa igehouna u hinena ina mamae.” Ma gasi Buka i pa, “Tamogi lawa gehouna apo iyawena ina peli.” ");
INSERT INTO tbo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yaka apo yohola Yudasa tu luhalenana lawa awai houga magomagouna i mulitagotago Guyau Yesu a gae po a hopu ugolihi, ");
INSERT INTO tbo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ma gasi Yoni Yesu i bapatisoya hougana ma i nei po Yesu a gae hougana. Geka lawana tauna ina nei po Yesu a towolo meme tona ituwetuwegeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ega yaka lawa luwaga gowahi hi bahehi: Yosepa ma gowana gehouna Basabasa ma gasi gowana gehouna Yusito; ma Matiyasi. ");
INSERT INTO tbo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hi bahehi po i kokoe ma hi tapalolo hi pa, ‘Guyau, lawa hai winugonugotuhu u hanapugena dumahi. Yaka geka lawahi luwaga ugolihi emosi u inagani una wogeleteya. ");
INSERT INTO tbo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tauna apo geka bagibagina po wituwetuwegana Yudasa i nenehaleya ina towologeya babana Yudasa amaka i newahaga.’ ");
INSERT INTO tbo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hai luwagahi hi wikibu gowagowadehi po Matiyasi a winagana i lugeleteya yaka tauna i lui tu wituwetuwega hai bolu magouhi 12 ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mi Yudeya hai toleha iyetana gowana Penitikosi. Noka hougana tu witumagana atapuhi hi’mtuboina gogona po hi winugoemota. ");
INSERT INTO tbo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hi duhuduhuna po mala emosi ma gololo mei togowa baneina gololona yadei i hopu mai po numana i wihogoya. ");
INSERT INTO tbo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma hai galena ugolina ginouli mei mayau ina laumenamena u hayahi, po menamenana emosi po emosi lawa emosi po emosi i tatadadani. ");
INSERT INTO tbo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma Alugo Woiyawa i wihogohi po i dewahi po pona tapuhi po tapuhigei hi ibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lawa atapuhi hai witumagana Yaubada ugolina mei mi Yudeya hai witumagana tupo atapunei hi nei u Yelusalem po ipa hina toleha. Tauhi tu witumagana kadidili Yaubada ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hougana gololona hi noonoli po bolu baneina hi’mboina nei numana u liyaliyana, po nugonugohi i goholi babana lawa emosi po emosi a pona i noonola tuhagaya. ");
INSERT INTO tbo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hai nugogohola po nugopilipili ugolina ma hi pa, ‘Geka lawahi noka pite he ibaabani naka tauhi mi Galili? ");
INSERT INTO tbo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma iyowai po tauta emosi po emosi ata meyagai ponana ta noonola tuhagaya? ");
INSERT INTO tbo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tauta mi Pateya po mi Midiya po mi Elama po mi Mesopotamiya po mi Yudeya po mi Kapadosiya po mi Ponita po mi Asiya ");
INSERT INTO tbo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","po mi Piligiya po mi Pampiliya po mi Isipita po Libiya ani taniwagana tupohihi Sailini u liyaliyana. Ma gehouta Loma tu mimiyena, ");
INSERT INTO tbo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","naka tupota ata babada mi Yudeya ma tupota moina mi Loma ma ata witumagana mei mi Yudeya. Ma gehouta mi Kilita po mi Alebiya. Tamogi ginouli baneihi Yaubada i dewadewahi ataputa ata ponei he bahebahehi ma ta noonolihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hai nugogohola po hai nugopilipili ugolinei ma yohola hi lulubayadena mehi hi pa, ‘Geka ginoulina anona awai?’ ");
INSERT INTO tbo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma gehouhi tu witumaganahi hi paliguyoguyougehi hi pa, ‘Geka lawahi hi uma po hi buuwa.’ ");
INSERT INTO tbo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ega yaka Pita ma tu wituwetuwegahi gehouhi magouhi 11 mitehi hi towolo, po Pita ponana i lata ma bolu ugolihi i baha nae i pa, ‘U lawa mi Yudeya po taumi atapumi u Yelusalem o mamae, ona lautanigana imahi ma a paliwelemi. ");
INSERT INTO tbo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ami nugotuhu o pa tiyai tota uma po tota buuwa ma tamogi eega, babana geka apoma e gegae ata malatomtom amna kabudalana ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma tamogi moina dumana geka awai e wawala naka Yaubada a tu bahapiko odubona gowana Yoela i bahehi. ");
INSERT INTO tbo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yaubada i baha i pa: “Houga sigasigana u hinena apo geka dewahi a dewehi Alugo Woiyawa apo lawa atapuhi a welehi. Natunatumi ololotohi po wiwinehi apo u baha hina bahabaha pikogeya, ami hewahewali ma babada apo u kawaimoina hina luboniyehi. ");
INSERT INTO tbo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ee, noka hougana ugolina u tu bagibagi ololotohi po wiwinehi, Alugo Woiyawa apo a welehi po u baha hina bahabaha pikogehi. ");
INSERT INTO tbo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Apo u manini hau yada a wogeletehi, ma u wekiwekilala hau hipuli a wogeletehi. Tala po mayau ebebalana po bogahu wopotopotona. ");
INSERT INTO tbo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kabudala apo ina uguwi ma wamahiya ina kaya po ani galenana mei tala, ma muliyei apoma Guyau a iyeta ina geleta, naka iyetana iyeta baneina po namanamalina. ");
INSERT INTO tbo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma apoma iyawoi nawa Guyau gowanei hina laupali apo hina luyagohana.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita gasi i baha i pa, ‘U lawa mi Yudeya, geka bahahi ona nonolihi: Yesu Nasaletagei, Yaubada a manini po a wipoya po a wekiwekilala amodewedewei i wogeletehi po ugolinei Yaubada a winagana i limoineya. Tauta geka ta hanapugeya babana u hayata i wawala. ");
INSERT INTO tbo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yaubada i nugotuhu lagoneya yaka Yudasa Yesu u nimami i houni, ma taumi o uni babana ombeneneya tu apapoe lawahi ugolihi po hau ani take hi tutuya po i hilage. ");
INSERT INTO tbo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tamogi Yaubada i witowolo meya hilage ugolina po hilage wiyuwahi i wihalehi, babana hilage ega a kadidili emoemotana ipa ina womomohi. ");
INSERT INTO tbo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ubeina po Dawita i baha i pa, “Houga magomagouna Guyau u matana a gagaleya. U awala hinebawau e mamae ugolinei apega lawa hina lipilipiliu. ");
INSERT INTO tbo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Geka binei nugonugou i kaoha ma u baha kaoha awa, yaka hawena apo uyogou ina buda ma a nugotuhu lagoneya a towolo meme ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Matababana tau apega hau hiyoyowa una nugohelau yaka gasi apega am tu bagibagi una palihaleu po hiniu ina buda. ");
INSERT INTO tbo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tam luyagohana tahayana u wiatatiyeu, ma tau tam u matam apo a kaoha duma.” ");
INSERT INTO tbo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Gasi Pita i baha i pa, ‘Walewalehiu, dumalugei apo a paliwelemi naka gogata Dawita i hilage po hi guluwi ma kokowagana amalai e mamae ugolita. ");
INSERT INTO tbo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tauna tu wipiko ma Yaubada a paliwitumagana kadidilina ugolina i hanapugeya. Yaubada a paliwitumagana ipa apo Dawita gogana emosi ina witaniwaga mei Dawita. ");
INSERT INTO tbo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ma Dawita i nugotuhu lagoneya apo Yaubada awai ina dewaya. Yaka Keliso a towolo meme ubeina i baha i pa, “Apeega hau hiyoyowa una nugohaleu ma hiniu apeega ina buda.” ");
INSERT INTO tbo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Naka binei Yaubada geka Yesuna hilage ugolina i witowoli, ubeina ma tauyai tu baha moina babana matiyei to galeya. ");
INSERT INTO tbo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu i wohepaya po u awala hinebawana e mamae. Ma a paliwitumagana ubeina Alugo Woiyawa Yesu i weliyai. Yaka i dewa geka amalai o noonolihi po o gagalehi naka Yesu anani’mbenena i lautepaneya ugoliyai. ");
INSERT INTO tbo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawita ega ita gae hau yada mei Yesu ma tamogi i pa, “Yaubada u Guyau ugolina i baha nae i pa: U awala hinebawau una duhuduhuna ");
INSERT INTO tbo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","a sigana am gawiya una kadidili lagonihi po aem u labena a hounihi.” ");
INSERT INTO tbo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","U lawa, mi Isalaela atapumi, ipa ona hanapugena dumaya geka Yesuna hau ani take o tuutulawiteya naka Yaubada i dewaya po Yesu tauna Guyau po tauna Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hougana lawa geka bahahi hi noonolihi po hi nugotona. Hi baha nae Pita po tu wituwetuwegahi gehouhi ugolihi hi pa, ‘Walewalehiyai, apo awai to dewaya?’ ");
INSERT INTO tbo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ugolihi i baha nae i pa, ‘Atapumi ona nugobui ma bapatiso Yesu Keliso gowanei ona waya, po apo Yaubada ami apapoe ina paligigilihi ma ani’mbenena Alugo Woiyawa ona tuhagaya, ");
INSERT INTO tbo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","babana Yaubada a paliwitumagana Alugo Woiyawa binei ugolita po natunatuta ugolihi po bala daodaohi tu miyehi ugolihi. Guyau ata Yaubada e igiigimana ataputa ugolita.’ ");
INSERT INTO tbo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita guguya daodaona i welehi Yesu tuwegana ubeina ma i palihunahunahi i pa, ‘Ami apapoe ona palihalehi yaka apega tu apapoe mitehi ona hilage.’ ");
INSERT INTO tbo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iyawoi Pita a baha hi itumaganeya naka noka iyetana ugolina bapatiso hi waya. Magouhi mei tausana tonuga hi lui tu witumagana gugunihi ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma tu wituwetuwega hai wiatatiyana po hai wilawalawa ugolihi hi palihalena mehi. Ma gasi palawa omtomutomuna ugolina Yesu hi nugonugohepaya ma hi tapatapalolo. ");
INSERT INTO tbo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yaubada a manini po a wipoya tu wituwetuwega ugolihiyei i wogeletehi po lawa atapuhi hi matouta. ");
INSERT INTO tbo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tu witumagana atapuhi hi meme labelabena mehi ma hi ginouli luluemota. ");
INSERT INTO tbo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hai hipuli po hai gapola hi gimalena halehi ma mihahi hai lawa, tu witumagana ega hita igapola hi welehi. ");
INSERT INTO tbo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iyeta emosi po emosi Yelusalem hai numa dalabu baneina ugolina hi yamboina gogona. Ma Yesu hi nugonugohepaya palawa omtomutomunei naka anai kaohahi po anai nugoemotahi hai numa emosi po emosi ugolina hi yamgogoneya. ");
INSERT INTO tbo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yaubada hi hunehuneya ma tu meuputa lawahi tu witumaganahi hi lunugodewedewehi. Ma Guyau iyeta emosi po emosi tu witumaganahi i laimagouhi lawa tu nugobuigei. ");
INSERT INTO tbo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ibiga u tipolina, lupali kabudalana ugolina Pita ma Yoni hi nae Yelusalem numa dalabu baneina ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Noka hougana lawa aena paapana hinana u managona ma noka pite i wawala. Iyeta emosi po emosi hi awala niyeya po numa dalabuna baneina matetana, gowana Mateta Diidigana ugolina hi huhouni. Ma hagu lawa tu lui ugolihi i laupali. Noka pite houga magomagouna i dewadewa. ");
INSERT INTO tbo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hougana Pita ma Yoni hi luilui ma i galehi yaka i lupali ipa mone hina weleya. ");
INSERT INTO tbo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hi todi po hi gagaleya ma Pita i pa, ‘Una galeiyai!’ ");
INSERT INTO tbo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ega yaka i ihalugehi anai witumaganana ipa apo awai hina weleya. ");
INSERT INTO tbo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma Pita i pa, ‘Ega u mone ma tamogi awai ugoliu e mamae apo a welem. Yesu Keliso Nasaletagei gowanei una towolo po una nae.’ ");
INSERT INTO tbo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Apoma Pita tu aepapana u awala hinebawana i wogo po i witowoli. Mala emosi ma ae yapayapana po ikwalukwaluna hi kadidili. ");
INSERT INTO tbo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ma i lupa gae po i hopu i lautowologeya po i nae. Apoma i nenelupalupa ma Yaubada i hunehuneya ma Pita po Yoni mitehi hi lui numa dalabu baneina ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lawa atapuhi i nenelupalupa ma Yaubada i hunehuneya hi gagaleya ");
INSERT INTO tbo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","po hi galena tuhaga, tauna Mateta Diidigana ugolina i duhuna houga magomagouna ma mone i laupali. Hai galena tuhagaya awai i wawala ugolina ma apoma hi gohola dumahi po hai winugonugotuhu hi kokoe. ");
INSERT INTO tbo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tu aepapana hi lauyawahi Pita ma Yoni ugolihi i womomota po Solomona a kape ugolina hi mamae. Ma lawa atapuhi anai nugogoholahi hi wibulibulili nae po ugolihi hi’mtuboina. ");
INSERT INTO tbo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hougana Pita lawahi i gagalehi po ugolihi i baha nae i pa, ‘U lawa mi Yudeya, iyowai po geka dewana o goholeya ma iyowai po o ihalugeiyai? Omi nugotuhu o pa i kadidili bo i dewadewa Yaubada u matana ugolihiyei geka lawana tota dewaya po ita nenae? ");
INSERT INTO tbo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abelaham po Isako po Yakobo hai Yaubada, googata hai Yaubada tauna a tu bagibagi Yesu kawaidewadewa wotalagaena i weleya. Taumi ombeneneya tu taniwaga ugolihi ma o wihinigigiyeya Pilato u matana. Hougana Pilato ipa ina wohaleya ma taumi yohola o ikawakoyakoyameya. ");
INSERT INTO tbo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tauna Lawa Waiwoiyawana po Dumadumaluna, tamogi o wihinigigiyeya ma o lupali po tu’munugo Pilato i wohaleya. ");
INSERT INTO tbo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yaka taumi Lawa Luyagohana tu weleta o uni ma tamogi Yaubada hilage ugolina i witowola meya. Geka ubeina tauta tu baha moina. ");
INSERT INTO tbo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Geka lawana o gagaleya po o hanahanapugeya naka witumagana Yesu gowanei kadidili po dewadewa i waya atapumi u matami. ");
INSERT INTO tbo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Ma walewalehiu, amalai a hanapugeya taumi po ata tanitaniwaga awai Yesu ugolina hi dewadewaya naka o dewaya babana o winugoneina. ");
INSERT INTO tbo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amaka mei lolowa Yaubada a baha tu bahapiko atapuhi ugolihiyei i wogeleteya naka apo a Besinana hinina ina iyuwa amaka Yaubada i limoineya. ");
INSERT INTO tbo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ugolinei ona nugobui ma ona luhagawilemi yaka apo Yaubada ami apapoe ina hamaga halehi ");
INSERT INTO tbo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma Guyau wiyagohina hougana ina welemi. Ma apo Yesu, Yaubada a Besinana amaka i inagani ubeita ina himila hopunena meyai. ");
INSERT INTO tbo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hau yada apo ina mamae a sigana ina gunawileya po ginouli atapuhi ina liwou mehi, mei lolowa Yaubada a tu bahapiko waiwoiyawahi hi pikogeya. ");
INSERT INTO tbo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ma tu bahapiko Mose i pa, “Yaubada ata Guyau apo tu bahapiko gehouna mei tau ina himili ugolimi. Taumi omi bolu ugolinei ina nei. Ginouli atapuhi ina ibaabaniyehi ona lautaniganehi. ");
INSERT INTO tbo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Iyai noka tu wipikona awai ina bahebahehi ega ina lautaniganehi apo Yaubada bolu ugolina ina wihaleya po ina houni hau hilage.” ");
INSERT INTO tbo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‘Tu bahapiko Samwela a u houga ma i wawala po i gegei naka awai hi bahebahehi amalai he waawala. ");
INSERT INTO tbo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tauta tu bahapiko googahi ugolinei Yaubada wiwogatala i dewadewaya googata mitehi a tu bahapiko ugolihiyei i bahebahehi naka tauta ubeita. Mei a baha nae Abelaham ugolina i pa, “Am guguni ugolihiyei apo lawa atapuhi hau hipuli kawaidewadewa a welehi.” ");
INSERT INTO tbo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yaka Yaubada a Tu bagibagi Yesu i winagani ma i himili po i netahaya mai tauta mi Yudeya ugolita. Ugolinei ami dewa apapoehi ugolihi ina wiiwilimi naka anani kawaidewadewa ugolimi.’ ");
INSERT INTO tbo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ma Yoni yohola lawa ugolihi hi ibaabani ma tu witalaguyaba babadahi po numa dalabu baneina tu galena itete hai bada po Sadusi hai bolu hi nei ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Uyohi i gigai babana Pita ma Yoni Yesu hi iatatiyaneya ma hilage ugolina a towolo meme hi kawaimoineya, apo lawa hilage ugolina hina towolo meme. ");
INSERT INTO tbo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yaka hi panihi po numa panipani ugolina hi hounihi po hi eno babana amaka kabudala i nae. ");
INSERT INTO tbo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma tamogi lawa i maga bahana hi noonoli hi witumagana, po tu witumagana lawahi hai maga i gae mei tausana nimitutu. ");
INSERT INTO tbo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Malatomtomgei mi Yudeya hai tanitaniwaga po babadahi po hai lugagayo tanitaniwagahi hi’mtuboina u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anase, tu witalaguyaba hai taniwaga po Kaiyapa po Yoni po Alesana po tu witalaguyaba hai taniwaga a guguni gehouhi ipa Pita ma Yoni mitehi hina wibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yaka Pita ma Yoni u naohi hi witowolihi ma hi lubayadehi hi pa, ‘Iyai a manini bo iyai gowanei tu aepapa o luyawahi?’ ");
INSERT INTO tbo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Alugo Woiyawa Pita i wihogoya po hai baha i wimiheya i pa, ‘Taumi lawa tu tahaya po tu taniwagehi, ");
INSERT INTO tbo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","inapa amalai ona laubayadiyai dewa dewadewana tu aepapa ugolina to dewedeweya ubeina po iyowai ma i wodewadewa, ");
INSERT INTO tbo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","naka atapumi ona hanapugeya po mi Isalaela lawahi atapuhi hi hanapugeya naka Yesu Keliso Nasaletagei gowanei. Tauna o itakeya po tauna Yaubada hau hilage ma i itowola meya, ugolinei geka tu aepapana anai dewadewana u matami e towotowolo. ");
INSERT INTO tbo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yaubada a Buka i bahebaheya Yesu binei i pa, “Tu lunuma, taumi geka ogolana o ihinigigiyeya naka i gunabuiya po ogola gegedumana.” ");
INSERT INTO tbo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hau hipuli ega iyai gehouna tu wiluyagohana. Yesu tauna tuawana, Yaubada lawa i weleta po gowanei emoemotana ta luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita ma Yoni hai nugomotu ugolina ma tu wiwogatalahi hi goholihi, babana hi hanapugeya Pita ma Yoni tauhi tu mae u meyagai po ega hita wisikulu, ma amaka hi hanapu. Apoma tu wiwogatalahi hi nugotuhu tuhagaya naka Pita ma Yoni Yesu mitehi hi liya nae. ");
INSERT INTO tbo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tamogi ega emoemotana ipa awai hina baheya babana tu aepapana hi lauyawahi u liyaliyahi i towotowolo. ");
INSERT INTO tbo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tamogi hougana hi palihalehi po hi meliya wogatala numana ugolina ma tu wiwogatalahi tuawahi hi ibaabani, ");
INSERT INTO tbo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","hi pa, ‘Apo geka lawahi iyowai ta dewahi? Lawa atapuhi u Yelusalem tu mae manini baneina hi galeya, po ega emoemotana ta wikawakoyakoyameya. ");
INSERT INTO tbo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tamogi geka lawahi ta paligagalihi po ega Yesu gowanei lawa awai ugolina hina bahabaha nae, po geka dewana apega lawa u hayahi ina lata.’ ");
INSERT INTO tbo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ega yaka Pita ma Yoni hi otugena mehi po hi lui ma hi paliguduguduhi hi pa, ‘Ega houga igehouna Yesu gowanei ona ibaabani po ona iatatiyana.’ ");
INSERT INTO tbo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tamogi Pita ma Yoni hai baha hi wimiheya hi pa, ‘Taumi tuawami ona wikahaya meemeka Yaubada u matana i dumalu, to wiponawogogemi bo Yaubada to wiponawogogeya. ");
INSERT INTO tbo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Awai to gagalehi po awai to noonolihi ega emoemotana to bahena woloehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tu wiwogatalahi hi’mpaligudugudu kadidili ugolihi ma hi wohalehi po hi nae. Ega emoemotana po hina panihi babana awai i waawala ubeina lawa atapuhi Yaubada hi wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lawana ugolina geka luyagohana wekiwekilalana i waawala naka a bolima magouhi 40 i lagoni. ");
INSERT INTO tbo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hougana Pita ma Yoni hi woohalehi hi gunawilehi po hi nae hai lawa ugolihi po awai tu witalaguyaba babada po mi Yudeya hai tanitaniwaga hi palipaliwelehi hai lawa ugolihi hi wibenabenama. ");
INSERT INTO tbo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ma hai lawahi hi noonoli po atapuhi hi winugoemota ma hi tapalolo Yaubada ugolina hi pa, ‘Guyau Wasawasa, yada po hipuli po boga po ginouli atapuhi u hinehi he mamae Tu wiwawalihi. ");
INSERT INTO tbo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Alugo Woiyawei gogiyai Dawita, am tu bagibagi u dewaya po i baha i pa, “Iyowai po tauhi ega mi Yudeya uyohi i gigai duma? Ma iyowai po tu mehipuli hai nugotuhu ega anona? ");
INSERT INTO tbo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hipuli wasawasahi hi nonogo mehi ma tu taniwaga hi’mboina gogona po ipa Guyau Yaubada a Besinana mitehi hina igawiyehi.” ");
INSERT INTO tbo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Moina, Heloda ma Ponotiyo Pilato geka meyageina baneina ugolina mi Isalaela po tauhi ega mi Yudeya mitehi hi’mboina gogona. Ma Yesu am Tu bagibagi waiwoiyawana, tauna u dewaya po am Besinana hi wigawiyeya. ");
INSERT INTO tbo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hi’mboina gogona po ginouli atapuhi am wipoya po am nugotuhugei ipa apo hina waawala naka hi dewahi. ");
INSERT INTO tbo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma Guyau, amalai hai ani’mpalilowolowo ugolihi una galena nae. Ma tiyai am tu bagibagi una dewiyai po to nugomotu am tuwega bahenana ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nimam una lodomi po lawa una luyawahihi ma manini po wekiwekilala una dewahi po am Tu bagibagi waiwoiyawana, Yesu gowanei hina wawala.’ ");
INSERT INTO tbo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hougana tapalolo hi laiwoloeya, dobuna ugolina hi yamboina i wiguhu. Ma atapuhi Alugo Woiyawa i wihogohi po Yaubada tuwegana anai nugomotuhi hi wiwawala po hi iyahoneya. ");
INSERT INTO tbo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tu witumagana atapuhi hai winugonugotuhu po hai luhogala emosi. Ega iyai gehouna ita pa ‘Geka tau u ginouli.’ Iyai ginouli awai i tanitaniwageya naka atapuhi ubeihi. ");
INSERT INTO tbo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Guyau Yesu a towolo meme naka wipoyagei tu wituwetuwegahi hi ibaabaniyeya lawa ugolihi. Ma Yaubada i kawaidewadewa dumahi. ");
INSERT INTO tbo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Boluna ugolina ega iyai gehouna awai ugolina ita kuku. Iyawoi waihipulihi po wainumahi naka hi gimalena halehi ");
INSERT INTO tbo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ma monehi tu wituwetuwega hi welehi po tauhi hi nohaya. Iyawoi hagu ugolina hi kukuku hi welehi. ");
INSERT INTO tbo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ega yaka Yosepa, lawa Saipilasigei, ma a guguni Libai, naka tauna tu wituwetuwegahi hi wigowaya po Banabasi (Banabasi anona, tu winugokadidili natuna) ");
INSERT INTO tbo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","a hipuli tupona gehouna i gimalena haleya ma monena i niyeya po tu wituwetuwegahi u nimahi i houni. ");
INSERT INTO tbo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lawa gehouna gowana Ananaya, agona gowana Sapaila, mitehi hai hipuli tupona hi gimalena haleya. ");
INSERT INTO tbo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sapaila i hanapugeya naka hipulina monena tupona Ananaya i womomohi, tauna tuawana ubeina. Ma tupona tu wituwetuwega u nimahi i houni ma i koyama i pa, ‘Geka hipuli mihana atapuna.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma Pita i baha nae ugolina i pa, ‘Ananaya, iyowai po u palihalena mem po Tomodulele nugonugom i taniwageya, ma Alugo Woiyawa u koyameya po hipuli monena tupona u womomohi? ");
INSERT INTO tbo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lolowa ega hipulina uta gimalena haleya naka tam galimgei. Ma muliyei u gimalena haleya po monena tam galimgei. Yaka iyowai po u nugonugom u pa apo geka pite dewa una deweya? Lawa ega uta koyamehi ma Yaubada u koyameya.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hougana Ananaya geka bahahi i noonolihi po i guli po i hilage. Ma tuwegana tu nonolina atapuhi hi matouta. ");
INSERT INTO tbo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Hewahewali hi wotowolo po hi woimahi ma hi awala hopuneya po hi guluwi. ");
INSERT INTO tbo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mei kabudala gaogaona tonuga hi kokoe ma Ananaya agona i geletai. Ma tamogi awai i waawala ega ita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita wawinena ugolina i baha nae i pa, ‘Una paliweleu, tam ma agom ami hipuli mihana atapuna gegeka?’ Wawinena i wimeiha i pa, ‘Ee, atapuna.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yaka Pita i baha nae ugolina i pa, ‘Iyowai po tam ma agom o pa Guyau Alugona ona ludadani? Hewahewalihi agom tu guluwina naka geka kabudalana tauhi hau mateta, ma apo hina awala hopunem gasi.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mala emosi ma wawinena Pita u aena i guli po i hilage. Hewahewalihi hi lui mai po hi gagaleya naka amaka i hilage, yaka hi awala hopuneya po agona u liyaliyana hi guluwi. ");
INSERT INTO tbo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tu witumagana atapuhi po geka tuwegana tu nonolina atapuhi hi matouta duma. ");
INSERT INTO tbo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Manini po wekiwekilala magomagouhi lawa u hayahi tu wituwetuwegahi hi dewadewahi. Houga magomagouna tu witumagana atapuhi hi yamboina gogona Solomona a kape ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Iyawoi ega hita itumagana hi matouta po tu witumagana mitehi ega hita yamboina gogona. Ma tamogi hi wiyateyatehi ma hi hunehi. ");
INSERT INTO tbo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma tamogi tu witumaganahi hai bolu i lalata. Oloto po wiwine iyawoi Guyau hi itumaganeya naka hi luilui. ");
INSERT INTO tbo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tu wituwetuwegahi hai dewa ugolihi ma tu tootogo hi awala hopunehi po u tahaya pata po liyapa ugolihi hi wienohi. Apo Pita a nae ugolina, ipa kabudala ina lalani po alugona ina yato tu tootogohi ugolihi po hina luyagohana. ");
INSERT INTO tbo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lawa boluhi, hai tu tootogo po lawa alugo palopaloumana i luiluinihi hi neihi mai u Yelusalem po atapuhi hi lauyawahihi. ");
INSERT INTO tbo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tu witalaguyaba hai taniwaga ma tu wimulitagona tauhi Sadusi hai bolu gehouna tu wituwetuwegahi hi’mgenagenaliliyehi. ");
INSERT INTO tbo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yaka tu wituwetuwegahi hi panihi po bolu hai numa panipani ugolina hi hounihi. ");
INSERT INTO tbo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tamogi noka upomna, Guyau a tu winoyanoya yadei i hopu mai po panina matetana i hoeya ma tu wituwetuwegahi hi hopu. Ma ugolihi i baha nae i pa, ");
INSERT INTO tbo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","‘Ona nae numa dalabu baneina ugolina po ona towolo, ma lawa geka luyagohanana tuwegana atapuna ona paliwelehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tu wituwetuwegahi hi wiponawogo po malatomtom kikina hi lui numa dalabu baneina ugolina po wiatatiyana hi wiwawali. Tu witalaguyaba hai taniwaga ma a tu wotago, mi Isalaela babadahi hi otugehi po tauhi tu wiwogatala awa omboina baneina hi waya. Ma apoma baha hi himili po i nae hau numa panipani ipa tu wituwetuwegahi hina neihi mai omboinana ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Hougana numa panipani tanitaniwagahi hi gelegeleta po ega tu wituwetuwega gehouna hita tuhagaya numana ugolina. Ega yaka hi gunawilehi po hi wibenabenama hi pa, ");
INSERT INTO tbo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","‘To tuhagaya naka panina anai gudu momotana po tu galena itetena hau mateta hi towotowolo. Ma tamogi hougana to hoehoeya naka ega iyai gehouna u hinena tota tuhagaya.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hougana tu witalaguyaba hai taniwaga po tu witalaguyaba babadahi po numa dalabu baneina tu galena itete hai baha hi noonoli po hi winugonugotuhu bala tapuna hi pa, ‘Apo awai ina geleta?’ ");
INSERT INTO tbo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ma lawa gehouna i lui mai po i baha nae ugolihi i pa, ‘Ona lautanigana, lawahi hau numa panipani o huhounihi naka numa dalabu baneina ugolina he towotowolo, ma lawa he iatatiyehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ega yaka numa panipani taniwagana a hewahewali mitehi hi nae po tu wituwetuwegahi hi weluwinihi po hi gunawilehi. Ma tamogi ega hita lihunahunahi babana hi matouta hi pa apo lawa hina luuyogigai po tu galena itete hina lugeimahi. ");
INSERT INTO tbo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tu wituwetuwegahi hi luiyehi po tu wiwogatala u naohi hi witowolihi. Ma tu witalaguyaba hai taniwaga i lubayadehi i pa, ");
INSERT INTO tbo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","‘Paligudugudu kadidilina to welemi to pa ega Yesu gowanei ona iatatiyana. Ma awai o dewadewaya amaka o galeya? Ami wiatatiyana o nohaya po Yelusalem i wihogoya, ma geka lawana a hilage gouna ipa ona weliyai.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita ma tu wituwetuwegahi gehouhi hai baha hi wimiheya hi pa, ‘Yaubada ipa tona iponawogogeya, ma ega ipa lawa. ");
INSERT INTO tbo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Googata hai Yaubada, Yesu hilage ugolina ma i witowolo meya. Tauna o uni hau ani take o tuutulawiteya ugolina ma ");
INSERT INTO tbo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","tauna Yaubada i wohepaya po u awala hinebawana i houni. Tauna Tu tahaya ma Tu wiluyagohana, ipa lawa mi Isalaela ata gaogao ina weleta po ta nugobui po apo ata apapoe ina paligigilihi. ");
INSERT INTO tbo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tiyai tu baha moina geka ginoulihi ugolihi, mei gasi Alugo Woiyawa, tauna Yaubada anani’mbenena tu wiponawogogena ugolita.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hougana tu wiwogatalahi geka hi noonoli po uyohi i gigai duma po ipa hina unihi. ");
INSERT INTO tbo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ma lawa gowana Gameliyela a bolu Palisi ma lugagayo tu wiatatiyanena po gasi tu wogatala gehouna lawa hai ani wiyateyate, tauna i towolo po i baha po tu wituwetuwega hi himila hopunehi hau uputa. ");
INSERT INTO tbo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Apoma i baha nae a lawa ugolihi, i pa, ‘U lawa mi Yudeya, geka lawahi ugolihi awai ona dewadewaya ipa ona gagalena imahi. ");
INSERT INTO tbo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lolowa Tiudasi i towolo po ipa tauna lawa hai tu tahaya gehouna, po lawa magouhi mei 400 hi imulitagoya. Tamogi lawa gehouhi hi uni ma tu wotagona hi gunanohanohahi po a bagibagina i yababa. ");
INSERT INTO tbo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Geka u mulina Yudasa Galiligei, lawa omhiyawahi hougana i towolo po lawa gehouhi i teinihi po hi wootagoya. Tauna gasi lawa gehouhi hi uni ma tu wotagona hi gunanohanohahi. ");
INSERT INTO tbo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ugolinei ma geka pite dewa amalai ipa a paliwelemi naka ega ugolihi ona wogowogo nae. Ona palihalehi po tuawahi. Inapa geka hai bagibagina lawa ina ununugeya yaka apo ina yababa. ");
INSERT INTO tbo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma inapa hai bagibagina Yaubada ina ununugeya, ega emoemotana ona lagonihi, babana meka po apo ona tuhaga memi naka taumi Yaubada ona igawiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ega yaka tu wiwogatalahi Gameliyela a wiututu lulougo hi wotagoya. Tu wituwetuwegahi hi otugehi po hi lui ma hi kodikodilihi po i kokoe ma hi paliwelehi ega houga gehouna Yesu gowanei hina ibaabani. Ma apoma hi wohalehi po hi nae. ");
INSERT INTO tbo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tu wiwogatalahi hi nenehalehi naka kaoha i wihogohi babana Yaubada apoma i hiyawihi emoemotana hiniwiyuwa Yesu gowana binei hina waya. ");
INSERT INTO tbo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma iyeta emosi po emosi numa dalabu baneina ugolina hi yamboina gogona po gasi lawa hai numa ugolihi Yesu tauna Besinana lawana a tuwegana dewadewana hi iatatiyaneya po hi guuguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Noka u hougana Yesu tu wotagona hi magamaga po mi Giliki mi Yudeya mitehi hi gamogahigahi. Mi Giliki hi pa yaniyani omgutana iyeta emosi po emosi ugolina hai hiwahiwape hi lauwiwilihi. ");
INSERT INTO tbo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ega yaka tu wituwetuwegahi magouhi 12 tu wotago atapuhi hi otugehi po hi’mboina ma hi pa, ‘Ega ita dumalu ipa Yaubada a baha guguyana to wohouni ma yaniyani gutana ugolina to genogeno. ");
INSERT INTO tbo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ugolinei, walewalehiyai, lawa magouhi 7 u hayami, o hanahanapugehi tauhi Alugo Woiyawa e tanitaniwagehi po hanahanapuhi ona winaganihi po tauhi geka bagibagina ugolina hina towolo. ");
INSERT INTO tbo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma tiyai lupali po Yaubada a baha luguguyana ugolina, ega i gaogao to hahaleya.’ ");
INSERT INTO tbo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Atapuhi geka nugotuhuna ugolina hi kaoha yaka Sitibeni hi witowoli. Tauna lawa waitumaganana ma Alugo Woiyawa ugolina. Ma Pilipo po Polokola po Nikano po Timona po Pamenasa po Nikolosi, lawa Anitiyokagei, a witumagana ega mei mi Yudeya ma hi buiya po mei tauhi. ");
INSERT INTO tbo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Geka lawahi hi inaganihi naka atapuhi hi wogeletehi tu wituwetuwegahi ugolihi po hi wotepanihi ma hi lupaliyehi. ");
INSERT INTO tbo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma Yaubada a baha i gunanohaya po i lata. U Yelusalem tu wimulitago hi magamaga po tu witalaguyaba boluhi witumaganana hi wiponawogogeya. ");
INSERT INTO tbo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitibeni naka Yaubada a lunugotootogo po a wipoya i wihogoya. Ugolinei lawa u hayahi manini po wekiwekilala i dewadewahi. ");
INSERT INTO tbo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma tu tapalolo mi Yudeya tamogi tauhi, mi Sailina po mi Alesana po mi Silisiya po mi Asiya atapuhi hai tapalolo boluna gowana hi pa, ‘Palipalihalenahi,’ hi towolo po Sitibeni mitehi hi igegae. ");
INSERT INTO tbo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tamogi Alugo Woiyawa hanapu Sitibeni i weleya po ugolinei i ibaabani naka ega emoemotana a baha hina wimihehi. ");
INSERT INTO tbo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ega yaka lawa gowadei hi wimihehi ma hi witowolihi po tauhi hi pa, ‘To lautanigana ma Mose po Yaubada i iapapoenihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Geka ugolina ma lawa po mi Yudeya tanitaniwaga po lugagayo tanitaniwagahi hi linugoapapoenihi. Yaka hi nae po Sitibeni hi numa panipani po hi neiyai tu wiwogatala ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ma lawa gehouhi hi neihi mai po Sitibeni hi benabenama koyakoyameya tu luhetala ugolihi, hi pa, ‘Geka lawana houga magomagouna ata numa dalabu waiwoiyawana po Mose a lugagayo e iapapoenihi. ");
INSERT INTO tbo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","To lautanigana ma i pa Yesu Nasaletagei apo geka numa dalabuna ina wiapapoeya ma ata dewa Mose ugolina ma i wawala po i nenei ina buinihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tu wiwogatala atapuhi hi tugutugula naka hi todi ma Sitibeni hi gagaleya naka tepana mei tu winoyanoya yadei. ");
INSERT INTO tbo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tu witalaguyaba hai taniwaga Sitibeni i lubayadeya i pa, ‘Geka lawahi awai hi bahebahehi naka moinahi?’ ");
INSERT INTO tbo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitibeni hai baha i wimiheya i pa, ‘Walewalehiu po amamau, ona lautanigana! Gogata Abelaham goila luwaga u tipolina i mamae yohola ega a u dobu u Halana ita mae ma Yaubada Diidigana i wogeletena meya ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Hougana i wogeletena meya naka i baha nae ugolina i pa, “Am hipuli po am dobu lawahi una nehalehi po una nae hipuli gehouna apo ana iatatiyem ugolina.” ");
INSERT INTO tbo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ega yaka goila luwaga hipulina i nehaleya po i nae u Halana i mae. Amana i hilage po u mulina Yaubada Abelaham noka hipulina ugolina i wihaleya po geka hipulina ta mimiyeya ugolina i houni. ");
INSERT INTO tbo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Noka hougana Yaubada Abelaham ega hipuli tupona ita weleya, ma tamogi i paliwitumagana ipa apo ina weleya. Hipulina apo tauna galinei po gasi a hewahewali guguninei hina nenei ubeihi. Noka hougana Yaubada geka paliwitumaganana i dewadewaya, Abelaham ega natuna. ");
INSERT INTO tbo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ugolinei ma Yaubada i baha nae Abelaham ugolina i pa, “Am guguni apo u tupo geha hina mae. Noka hosi apo hina itubagibagi ma ega mihahi, ma gasi hina dewadewa yabayababehi ma hina mamae bolima magouhi handele wohepali (400). ");
INSERT INTO tbo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tamogi dobuna ugolina hi wobagibagi lawahi apo a libahibahihi. Ma muliyei apoma apo noka dobuna hina hopu haleya po geka u dobuna hina wotalagiyeu.” ");
INSERT INTO tbo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma Abelaham i laueeneya naka guguninei logaloga ololotohi hai wekiwekilala hini omhapina hina welehi. Abelaham Isako i guni po gaogao emosi i kokoe ma hapihapi i weleya. Naka pitenana gasi Isako natuna Yakobo hapihapi i weleya. Ma Yakobo gasi natunatuna magouhi 12 hapihapi i welehi. ");
INSERT INTO tbo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Gogata Yakobo natunatuna hai tewela Yosepa hi gimalena haleya mi Isipita ugolihi babana hi’mgenagenaliliyeya po noka hosi i tubagibagi ma ega mihana. Tamogi Yaubada ega ita nugohaleya. ");
INSERT INTO tbo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ugolinei ma a pilipili atapuhi u hinehi tauna i haguhaguya po i kawaidewedeweya po hanapu i weleya. Ma Isipita hai wasawasa gowana Pelo Yosepa i galena tuhagaya po ani taniwaga i weleya Isipita atapuna u hinena po gasi a numa u hinena. ");
INSERT INTO tbo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Apoma gomala Isipita po Kainana po tupo atapuhi i wogohi po lawa hi nugodubu duma. Ma googata ega emoemotahi yaniyani hina tuhagaya. Ma tamogi u Isipita naka amaka yaniyani hi luhanalihi. ");
INSERT INTO tbo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ugolinei ma Yakobo tuwega i inonoli naka u Isipita yaniyani i mamae, ega yaka natunatuna hai houga tahatahayana i himilihi po hi nae Isipita. ");
INSERT INTO tbo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma hai nae u Isipita wiluwagana ugolina Yosepa i wogeletena meya walewalehina ugolihi po i pa, “Tau geka walehimi Yosepa.” Ma Pelo tuwega i nonoli po gasi Yosepa a guguni i hanapugehi. ");
INSERT INTO tbo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ega yaka Yosepa baha i himili po i nae amana Yakobo ugolina i pa tauna po a manago atapuhi hina nei u Isipita. Hi nenae magouhi 75. ");
INSERT INTO tbo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Apoma gogata Yakobo po natunatuna hi hopu Isipita po noka hosi hi mamae po hi hilage. ");
INSERT INTO tbo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ma hai popoya hi hilahilage hi niyehi po odubona Abelaham hipuli monegei i gimagimaleya u Sekem, Hemo natunatuna, ugolihi naka hosi hi kokowaga. ");
INSERT INTO tbo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Bolima hi maga duma hi kokoe ma Yaubada a bahapiko anona Abelaham ugolina ipa ina lugeleteya naka ipa mi Yudeya Isipita hina hopu haleya. Matababana googatahi u Isipita hi maga duma. ");
INSERT INTO tbo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A sigana wasawasa gehouna u Isipita i towolo po a houga witaniwaga naka Yosepa ega ita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Googata i koyakoyamehi ma i ihiniwiyuwahi. Ma i duduhi po natunatuhi muhomuhohi hi palipalihalehi po hau balabala hi hilahilage. ");
INSERT INTO tbo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","‘Noka hougana Mose hi guni po Yaubada u matana i diidiga duma. Ma amana a numa ugolina i mamae naka wamahiya tonuga. ");
INSERT INTO tbo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hougana hi houna hopuneya goila u liyaliyana ma Pelo wasawasa natuna wawinena i waya po i woilataya po i kawainatuneya. ");
INSERT INTO tbo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma mi Isipita hai hanapu atapuna Mose i wiatatiyeya po tauna baha po mamae ugolihi i welulagona. ");
INSERT INTO tbo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Mose hougana a bolima magouhi 40 ma u nugonugona i lugeleteya apo a lawa mi Yudeya ina dadanihi. ");
INSERT INTO tbo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tauna matanei i gagalena nae ma Isipitagei Isalaela lawana gehouna i ilawi yaka tulana i haguya po Isipitagei i lihilageni. ");
INSERT INTO tbo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A nugotuhu ipa a lawa apo hina hanapugeya naka tauna Yaubada apo ina wibagibagi po nimanei mi Isipita ugolihi a guguni ina wihalena halehi. Ma tamogi ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Malitom po mi Yudeya luwaga i gagalehi ma hi itona yaka i wileta po ipa ina winugoemotahi po i pa, “U lawa, taumi guguni emosi ma iyowai po o ilawi memi?” ");
INSERT INTO tbo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","‘Tamogi tu wilougona Mose i luniyeya uheiya ma i pa, “Iyai i witowolim po ipa una witaniwaga po gasi tu lidumaluiyai? ");
INSERT INTO tbo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nugonugom ipa una uniu po mei pom Isipitagei u ununi?” ");
INSERT INTO tbo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Geka bahana Mose i noonoli po Isipita i lowo haleya po i nae u Midiyani po i mamae. Noka hosi natunatuna ololotohi luwaga i gunihi. ");
INSERT INTO tbo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Bolima magouhi 40 hi kokoe ma Yaubada a tu winoyanoya i wogeletena meya Mose ugolina mayau wailuguna ugolina ma mayouna i laumenamena hau balabala Sinai oyana u liyaliyana. Mayouna i wilugu ma tamogi ega ita yaguli. ");
INSERT INTO tbo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ugolinei Mose i gohola dumaya, yaka i tunae dobuna i alalahi u liyaliyana po ipa ina galena imahiyeya, ma Guyau ponana i nonoli i pa, ");
INSERT INTO tbo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Tau googam hai Yaubada, Abelaham a Yaubada, po Isako a Yaubada, po Yakobo a Yaubada.” Mose matouta i tapeitaatawi po ega ita gagalena nae mayouna ebalana ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma Guyau Mose ugolina i baha nae i pa, “Am ae humahuma una gagi haleya babana geka hipulina ugolina e towotowolo naka dobu woiyawa. ");
INSERT INTO tbo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","U Isipita, u lawa he ihiniwiyuwahi naka amaka a galehi po hai gabala amaka a nonolihi. Ugolinei ma a hopu mai ipa a lupena halehi. Una nei apo a himilim po una nae u Isipita.” ");
INSERT INTO tbo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Mi Yudeya Mose hi wihinigigiyeya hi pa, “Iyai i witowolim po ipa una witaniwaga po gasi tu lidumaluiyai?” Mi Isalaela hi wihinigigiyeya ma Yaubada a winagana hougana tu winoyanoya mayau ebebalana ugolina i winagani ipa tauna tu witaniwaga ma tu’mhoe. ");
INSERT INTO tbo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mi Yudeya i tahaehi po Isipita hi hopu haleya. Manini po wekiwekilalahi u Isipita po boga kayakayana i dewadewahi. Ma gasi maninihi po wekiwekilalahi hau balabala yabayababa i dewadewahi naka bolima magouhi 40. ");
INSERT INTO tbo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose tauna mi Yudeya ugolihi i baha nae i pa, “Yaubada apo a tu bahapiko lawana ina himiliyai ugolimi ani galenana mei tau. Tauna apo guguni tulami gehouna.” ");
INSERT INTO tbo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hau balabala yabayababa Mose mi Yudeya hai bolu u hinena tauna googata mitehi hi mamae, ma tu winoyanoya yadei i ibaabani oya Sinai ugolina. Tauna Yaubada a baha lauyagohanana i waya po i wodamaneya ugolita. ");
INSERT INTO tbo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Ma tamogi googata hi wihinigigiyeya po hi teleliyeya ma ipa hina gunawilehi u Isipita. ");
INSERT INTO tbo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ega yaka talaguyaba taniwagana Alona ugolina hi baha nae hi pa, “Ata talaoloto una tahi po apo ata yaubada u naota hina awali ma ta wotagohi. Mose i weluwinita po Isipita ta nenehaleya naka tauna i gae u oya, ega tata hanapugeya awai i meme.” ");
INSERT INTO tbo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Noka hougana talaoloto hi dewaya po mei bulumakau natuna. Ma ugolina hi italaguyaba po nimahiyei awai hi dewadewaya hi kaohena dumaya ugolinei ma hi toleheya. ");
INSERT INTO tbo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tamogi Yaubada i mepuputehi ma i palihalehi po yada ginoulihi mei kipola po wamahiya po kabudala hi polopolou ugolihi mei tu bahapiko Yaubada a baha hi gilugilumi hi pa, “Mi Yudeya, bolima magouhi 40 u hinehi hau balabala gamogamo o unihi po o italaguyaba naka ega tau ugoliu. ");
INSERT INTO tbo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ami talaoloto gowana Moloka a kape o iomawawaleya ma ami talaoloto Lepana a kipola o tahi po ugolina o wootalagae. Ugolinei apo a tupahimilimi po ona nae Babiloni u upunei.” ");
INSERT INTO tbo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‘Googata naka hau balabala Yaubada a kape, numa tapalolo kapena hi iomawawalena niyeya. Mose kapena i dewadewaya naka mei Yaubada i iatatiyeya po tautauna i wogeleteya ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Muliyei googata geka kapena hi wiwaya naka Yosuwa mitehi hi nae po geka hipulina hi waya Yaubada geka hipulina lawahi i wiyagahi ma apoma mi Yudeya hi miyeya. Ma kapena i mamae geka u hipulina a sigana Dawita a houga wasawasa. ");
INSERT INTO tbo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tauna Yaubada a kawaidewadewa i weleya. Ma Yaubada ugolina i lubayada ipa ina palihaleya po Yakobo a Yaubada a numa ina wogoya. ");
INSERT INTO tbo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma tamogi natuna Solomona Yaubada a numana i wogoya. ");
INSERT INTO tbo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","‘Yaubada Gegewahaga dumana a numa lawa nimahiyei hi wogowogoya ega u hinena ita mamae mei tu bahapiko a baha i pa, ");
INSERT INTO tbo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Guyau i pa: Tau u ani tugula hau yada, ma aeu ani luhanatanana hipuli tupo wohepali. Ega emoemotana numa biugei ona dewaya. Ma ega dobu emosi hota u ani wiyagohina. ");
INSERT INTO tbo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tau ginouli hau yada po hau hipuli nimougei a dewahi.” ");
INSERT INTO tbo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","‘Taumi tu nugokapala lawami. Yaubada tuwegana ugolina naka nugonugomi a bidahi po tanigami a pupuhi. Taumi amaka mei googami houga daodaona Alugo Woiyawa o ihinigigiyeya. ");
INSERT INTO tbo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Googami tu bahapiko magomagouhi hi ihiniwiyuwahi. Tu wituwetuwega, Lawa Dumadumaluna a nei lolowa hi noenoeya naka googami hi ununihi. Ma geka hougana Lawa Dumadumaluna tauna i wogeletena meya po o uni. ");
INSERT INTO tbo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yaubada a tu winoyanoya i himila hopunihi mai po a lugagayo o waya ma tamogi ega ota iponawogogeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tu wiwogatala Sitibeni a baha hi noonoli po hai modi i kekehi ma uyogigai i dewahi po niwohi hi kiko. ");
INSERT INTO tbo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma tamogi Sitibeni anai hogohogona Alugo Woiyawei i galena gae hau yada po Yaubada namanamalina i galeya ma u awala hinebawana Yesu i towotowolo ma i galeya. ");
INSERT INTO tbo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma i pa, ‘Ona galeya! Yada i gunahoeya ma Lawa Moinana e towotowolo Yaubada u awala hinebawana!’ ");
INSERT INTO tbo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hi ototu labatana po tanigahi hi wopupuhi ipa ega a baha hina noonoli. Apoma ubeina hi lupa gogona, ");
INSERT INTO tbo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","po meyageina u uputana hi dubala hopuneya ma gaimei hi wilawi. Tu lueenena lawahi Sitibeni a hilage hi lueeneya yaka hi dubala hopuneya meyageina u uputana ma gaimei hi wilawi. Ma tu lueena lawahi hai luilui hewali gowana Saulo aena u babana hi upumi. ");
INSERT INTO tbo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sitibeni yohola gaimei hi ilawi ma Guyau ugolina i tapalolo i pa, ‘Guyau Yesu, alugou una waya!’ ");
INSERT INTO tbo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma itutunei i’mtutonetonena ma i otu labatana i pa, ‘Guyau, geka apapoena ega ugolihi una nugonugotuhu niyeya!’ Geka bahana i baheya po i kokoe ma i hilage. ");
INSERT INTO tbo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sitibeni a hilage hougana u mulina Yelusalem u hinena tu witumagana hiniwiyuwa baneina hi wialonihi. Tu witumagana boluhi hi gunanohanohahi po hi nae Yudeya po Samaliya u tupohi. Ma tu wituwetuwega tuawahi u Yelusalem hi mamae. ");
INSERT INTO tbo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lawa Yaubada tu wotalagiyena Sitibeni hi waya po hi tutougeya po i kokoe ma hi guluwi. ");
INSERT INTO tbo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tamogi Saulo i ileta ipa tu witumagana hai bolu ina liyababaya. Numa po numa i luiluinihi ma tu witumagana i hihiwihi po hau numa panipani i tutuguduhi. ");
INSERT INTO tbo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tu witumaganahi hi launohanohahi naka hi nae tupo igehouhi Yesu tuwegana hi lauguguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ma Pilipo i nae meyagai baneina u Samaliya po noka hosi lawa ugolihi Besinana lawana noyana i guguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pilipo awai i bahebahehi bolu hi lunonola imahi po a manini wekiwekilalana hi galehi. ");
INSERT INTO tbo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Alugo palopaloumahi lawa hi luiluinihi anai otuotuhi ma lawahi hi hopu halehi. Lawa tootogohi po aehi woapapoehi Pilipo i luyawahihi. ");
INSERT INTO tbo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ugolinei ma lawa meyageina u hinena hi kaoha duma. ");
INSERT INTO tbo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Noka u meyageina lawa gehouna i mamae gowana Simona. Tauna houga gehouna mi Samaliya a dewa balabalau ugolinei i koyamehi. Ma i bahena meya naka tauna lawa baneina gehouna. ");
INSERT INTO tbo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Lawa atapuhi, lawa hota po lawa baneihi ugolina hi lautanigana po hi pa, ‘Geka lawana mei Yaubada,’ po hi pa, ‘Tam tu manini dumam.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ma ugolina hi lautanigana imahi babana houga daodaona dewa balabalaugei hai omhuna i waya. ");
INSERT INTO tbo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tamogi hougana Pilipo Yaubada anani taniwaga po Yesu Keliso a tuwega dewadewana i guuguyeya ma ololoto po wiwine hi itumagana naka bapatiso hi waya. ");
INSERT INTO tbo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona gasi i witumagana po bapatiso i waya ma u mulina naka Pilipo i melabena emoteya. Ma Pilipo manini po wekiwekilala i dewadewahi ma i gagalehi po i nugogohola. ");
INSERT INTO tbo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tu wituwetuwegahi u Yelusalem tuwega hi noonoli naka amaka lawa u Samaliya Yaubada a baha hi witumaganeya. Ega yaka Pita ma Yoni hi himilihi po hi nae lawahi u Samaliya ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hougana hi laugeleta naka tu witumaganahi u Samaliya ubeihi hi tapalolo po apo Alugo Woiyawa ina wihogohi. ");
INSERT INTO tbo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Alugo Woiyawa yohola ega iyai gehouna ita wihogoya ma bapatiso tuawana Guyau Yesu gowanei hi waya ugolinei hi lupali ubeihi. ");
INSERT INTO tbo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Apoma tu witumaganahi u ununuhi Pita ma Yoni nimahi hi hounihi po Alugo Woiyawa i luinihi. ");
INSERT INTO tbo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tu wituwetuwegahi nimahi tu witumaganahi ugolihi hi hounihi ma Alugo Woiyawa i luiluinihi naka Simona i galeya. Yaka Pita ma Yoni ugolihi mone i palihaleya ");
INSERT INTO tbo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ma i pa, ‘Geka wipoyana ona weleu po apo iyai ugolina nimau a huhouni naka apo Alugo Woiyawa ina luiya.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma tamogi Pita a baha i wimiheya i pa, ‘Am mone mitehi ona hilage babana am nugotuhu u pa, apo emoemotam Yaubada anani’mbenena una gimaleya hiyahi. ");
INSERT INTO tbo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","I bagibagi ugolina ega am tupo gehouna babana nugonugom ega ita dumalu Yaubada u matana. ");
INSERT INTO tbo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Una nugobui geka am nugotuhu apapoena ugolinei ma una lupali po nugote Guyau geka am winugonugotuhuna ina paligigili. ");
INSERT INTO tbo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","A gagalem naka omgenagenalili nugonugom i wihogoya po apapoe i panim.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simona hai baha i wimiheya i pa, ‘Ami baha a nonoli ma Guyau ugolina biugei una lupali po geka ginoulihi u bahebahehi apega ugoliu hina wawala.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Muliyei Pita ma Yoni awai Guyau i dewadewahi ma hi gagalehi hi deedeya ma hi guuguya po i kokoe naka hi gunawilehi u Yelusalem. Hai houga gunawilana meme ugolina tuwega dewadewana hi guguyeya meyagai atapuna Samaliya u hinena. ");
INSERT INTO tbo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Guyau a tu winoyanoya i baha nae Pilipo ugolina i pa, ‘Una wononogo ma una nae hau tupo yawana, tahaya u Yelusalem ma i nenae u Gasa ugolina.’ Tahayana i nenae balabala yabayababa ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ega yaka Pilipo i wotowolo po i nae. Noka hougana taniwaga baneina, Itiyopiyei i gunagunawileya a u meyagai. Tauna Itiyopiya hai wasawasa wawine gowana Kanase a mone i gagalena iteteya. Tauna i nae u Yelusalem po Yaubada i wotalagiyeya ma i gunagunawileya. ");
INSERT INTO tbo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","I gelu po i nenae ma bahapiko bukana Isaiya ugolina i yamhiyawa. ");
INSERT INTO tbo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma Alugo Woiyawa Pilipo ugolina i baha nae i pa, ‘Una nae po noka lawana una tulatuya.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ega yaka Pilipo i wibulibulili po i nae ugolina po i launonola ma lawana i yamhiyawa. Pilipo lawana i lubayadeya i pa, ‘U hanapugeya awai e hiyahiyawi?’ ");
INSERT INTO tbo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lawana i pa, ‘Eega, babana ega iyai ipa ina dede imahiyeya ugoliu.’ Ma i baha po Pilipo i’mgeina gae po katina ugolina mitehi hi duhuna. ");
INSERT INTO tbo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yaubada a Buka i hiyahiyawi i pa, ‘Tauna mei sipi hi waya po hina uni po mei sipi natuna ega ponana ma apalana he boliboli, tauna ega awai ita baheya. ");
INSERT INTO tbo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hi palihopuhopuneya po ega hita lidumalu imahiyeya. Ega iyai igehouna tauna natunatuna i gunigunihi ipa hina dedeya. Babana amaka hau hipuli a luyagohana i kokoe.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Lawana i baha nae Pilipo ugolina i pa, ‘Una paliweleu, geka tu bahapiko naka iyai e bahebaheya? Tauna e bahebahena meya bo lawa gehouna?’ ");
INSERT INTO tbo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pilipo geka Yaubada a bahana gutana ugolina i wiwawala po i nenae naka Yesu tuwegana dewadewana i dedeya. ");
INSERT INTO tbo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tahayanei hi gelu po hi nenae po goila ugolina hi geleta ma taniwagana i pa, ‘Geka goila ma iyowai po apega bapatiso a waya?’ ");
INSERT INTO tbo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipo taniwagana a baha i wimiheya i pa, ‘Inapa nugonugom atapunei una witumagana, apo bapatiso una waya.’ Taniwagana i pa, ‘Nugonugou atapunei a itumagana. Ma gasi a itumaganeya Yesu Keliso tauna Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Taniwagana i baha po katina hi liwoloeya ma hai luwaga hi lupa hopu ma hi hopu goilana ugolina. Ma Pilipo taniwagana i bapatisoya. ");
INSERT INTO tbo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hougana u goilana ma hi haugeleta po Guyau Alugona Pilipo i wihaleya, po taniwagana ega Pilipo ita galena meya. Ma tamogi anai kaohana tahayana i wotagoya po i nae. ");
INSERT INTO tbo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Pilipo u Asota hi tuhagaya, po meyagai i weluweluwilehi ma tuwega dewadewana i guuguyeya ma i nenae po u Sisaliya i geleta. ");
INSERT INTO tbo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo yohola Yesu tu wimulitagona i palipalilowolowohi ipa ina unihi. Ma i nae po tu witalaguyaba taniwagana ugolina ");
INSERT INTO tbo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","i lubayada i pa ‘Pepa una weleu po apo ugolinei a lui Damaseko numa dalabuna po oloto po wawine noka hosi a tutuhagahi, tauhi Guyau a tahaya tu wotagona apo a panihi po to gunawiliyai u Yelusalem.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","I nenae po hougana Damaseko i tutuliyaliyani, naka mala emosi ma yayata yadei i hopu po i yayata wiwileya. ");
INSERT INTO tbo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma i ludubali hau hipuli po lawa ponana i noonoli ma i pa, ‘Saulo! Saulo! Iyowai po e ihiniwiyuwau?’ ");
INSERT INTO tbo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ma Saulo i pa, ‘Guyau, tam iyai?’ Ma lawana i pa, ‘Tau Yesu e ihiniwiyuwau. ");
INSERT INTO tbo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tamogi una towolo po meyageina una luiya. Noka hosi apo hina paliwelem awai apo una dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lawa Saulo mitehi hi nenae naka hi tutowolo, ma lawa ponana hi nonoli ma tamogi ega hita galeya. ");
INSERT INTO tbo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ma Saulo hau hipuli i eneno po i wotowolo po matana i tatakaeya naka ega emoemotana awai ina galeya. Ega yaka u nimana hi wogo po hi luiyeya u Damaseko. ");
INSERT INTO tbo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ega ita gagalena ma i mamae naka iyeta tonuga. Ma noka iyetahi ugolihi ega awai ita ani po ega awai ita umaya. ");
INSERT INTO tbo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Noka hougana Yesu tu wotagona gehouna u Damaseko i mamae, gowana Ananaya. Tauna a enogagalena u hinena Guyau i baha nae ugolina i pa, ‘Ananaya!’ Ma Ananaya i pa, ‘Guyau, tau gee.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Apoma Guyau i pa, ‘Un’omhoe po una nae tahaya gowana Dumalu ugolina. Noka hosi Yudasa a u numa lawa Tasasigei gowana Saulo ubeina una lubayada. Tauna e laupali ");
INSERT INTO tbo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ma hau enogagalena i gagalena ma lawa gowana Ananaya i lui po nimana u unununa i houni po ipa apo ina galena meme.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaya Guyau a baha i wimiheya i pa, ‘Guyau, lawa i maga duma geka lawana dededena ugoliu hi baheya. Ma gasi tu wiwoiyawem u Yelusalem i dewadewa yabayababehi naka bahana atapuna amaka a nonoli. ");
INSERT INTO tbo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tauna tu witalaguyaba babadahi ugolihi palihalena i waya po i nei ipa gowam tu hiyawina u Damaseko ina panipanihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Guyau i baha nae Ananaya ugolina i pa, ‘Una nae babana a winagani tauna apo ina pupouleu. Tauna apo tu wipaliwelena lawa tupo wohepali u hinena po wasawasa po Yudeya lawahi ina dewahi po gowau hina hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tau biugei ma hiniwiyuwa atapuna ina ialoni apo a wiatatiyeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ega yaka Ananaya Yudasa a numana i luiya po nimana Saulo u unununa i hounihi ma i pa, ‘Walehiu Saulo, Guyau Yesu u nenei tahayagei ma i woogeletena meya i himiliu po a nei. Apo una galena meme ma Alugo Woiyawa ina wihogom.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mala emosi ma ginouli mei iyana wenawihi Saulo u matana hi mamae hi peu ma i galena meme. Apoma i welutowolo po bapatiso i waya ");
INSERT INTO tbo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ma i am po a kadidili i wimeya. Saulo Yesu tu wotagona mitehi hi mae u Damaseko iyeta ega hita maga. ");
INSERT INTO tbo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma i dumalu po i nae numa dalabu ugolihi po Yesu i guguyeya i pa, ‘Yesu Yaubada Natuna.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lawa atapuhi Saulo a baha hi noonoli po hi gohola dumahi po hi pa, ‘Geka tauna lawana u Yelusalem Yesu gowana tu hiyawina i panipanihi. Ma i nenei geka hosi ipa Yesu gowana tu hiyawina ina panipanihi po hina gunawilehi tu witalaguyaba babadahi ugolihi, bo?’ ");
INSERT INTO tbo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ma tamogi Saulo a guguya i ipoya. A limoina Yesu tauna Tu wiluyagohana naka bahana i winugowiwai duma ugolinei ma mi Yudeya u Damaseko hi mamae ega emoemotana a baha hina wimihehi. ");
INSERT INTO tbo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Iyeta i maga i nae ma apoma mi Yudeya hi wiwogatala ipa Saulo hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ma tamogi hai wiwogatalana amaka Saulo i hanapugeya. Uguwei po iyetei meyageina galina matetana hi ihalugeya ipa a hopu ugolina ma hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma tamogi uguwa emosi Saulona tu wotagona galina malamalanei hau poha i tugula ma gulawei hi woipipeili po i hopu u uputa. ");
INSERT INTO tbo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo i gunawileya u Yelusalem po i ileta ipa Yesu tu wotagona u hinehi ina lui, ma tamogi ega hita witumaganeya naka tauna Yesu tu wotagona gehouna. Ma gasi Saulona hi matouteya. ");
INSERT INTO tbo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Apoma Banabasi Saulo i weluwaya po i niyeya tu wituwetuwega ugolihi po i dedeya iyowai Saulo u tahaya Guyau i gagaleya. Ma iyowai Guyau i bahabaha nae Saulo ugolina po iyowai u Damaseko i nugomotu ma Yesu gowanei i lauguguya naka i dedeya. ");
INSERT INTO tbo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ega yaka Saulo tauhi mitehi hi mae ma Yelusalem atapuna i weluyagohi, anai nugokadidilina Guyau gowanei i lauguguya. ");
INSERT INTO tbo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saulo ma mi Yudeya pona Giliki tu bahebahena mitehi hi ibaabani po hi wigamogahigahi po hi ileta ipa hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ugolinei Yesu tu wotagona dewana geka hi gagalena tuhagaya po Saulo hi hopuneya u Sisaliya po hi himili po i nae u Tasasi. ");
INSERT INTO tbo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ee, apoma tu tapalolo Yudeya po Galili po Samaliya meyageihi atapuhi u hinehi hi meimahi. Ma Guyau hi wiyateyateya po Alugo Woiyawa a winugokadidili po a wihaguhagu ugolihi ma hi mamae, ugolinei hai bolu hi ilataya. ");
INSERT INTO tbo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita tupo atapuna i kadaugeya. Ma houga gehouna Yaubada tu wiwoiyawena u Lida tu mae i hopu po i dadanihi. ");
INSERT INTO tbo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Noka hosi lawa gehouna gowana Iniyasi i tuhagaya. Tauna hinina hi hilage po hau ani eno i mamae naka bolima magouhi 8. ");
INSERT INTO tbo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Pita i baha nae i pa, ‘Iniyasi, Yesu Keliso gowanei una luyagohana. Una towolo po am ani eno una woimahiyeya.’ Mala emosi ma Iniyasina i welutowolo. ");
INSERT INTO tbo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida po Selona tu miyena atapuhi hi galeya po Guyau hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wawine Yopagei gehouna Yesu tu wotagona gowana Tabita (mi Giliki ponahigei he pa Dokasi). Noka wawinena naka a dewa hi dewadewa po tu dayadayabu i haguhaguhi. ");
INSERT INTO tbo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Noka hougana i totogo po i hilage ma hai dewei hi deweya, hi witogoya po i kokoe, ma babanoya gehouna u moyana hi houni. ");
INSERT INTO tbo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa naka Lida u liyaliyana ugolinei ma hougana Yesu tu wotagona Pita tuwegana hi noonoli po lawa luwaga hi himilihi po hi nae Pitana ubeina. Lawahi tuwega hi niniyeya naka Pita ugolina hi pa, ‘Una bulili mai po una nei ugoliyai.’ ");
INSERT INTO tbo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ega yaka Pita i wotowolo po lawahi mitehi hi nae, hougana hi laugeleta naka hi weluwaya po hi gae babanoyana u moyana. Hiwahiwape atapuhi Pitana hi towolo wiwileya ma luilui po ani oteotena Dokasi lolowa i dewadewahi hi woogelegeletehi ma hi tutou. ");
INSERT INTO tbo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita atapuhi i hauhopunehi u uputa ma i tutunei i’mtutonetonena ma i lupali Yaubada ugolina. Apoma i mewila po popoyana ugolina i pa, ‘Tabita, una towolo!’ Wawinena matana i kaya po Pita i galeya ma i towolo po i duhuna. ");
INSERT INTO tbo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita i wotayaga po i witowolo haleya apoma tu witumagana po hiwahiwapehi i otugehi, po wawinena anai luyagohanana i wogeleteya ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wawinena a towolo meme tuwegana Yopa atapuna i hogoya po lawa boluhi Guyau hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Pita u Yopa lawa gamogamo opihi tu’mdidina po tu’mkaniyoga gowana Simona mitehi hi meidaodao kikina. ");
INSERT INTO tbo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","U Sisaliya lawa gehouna gowana Koniliyasi i mamae. Tauna mi Itali hai gawiya kapenana gehouna. ");
INSERT INTO tbo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tauna Yaubada tu lowogena gehouna po a manago mitehi Yaubada hi wootalagiyeya. Tu widayadayabu i haguhagu dumahi. Ma houga magomagouna i laupali Yaubada ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kabudala mei ibiga i lautipolini ma enogagalenagei Yaubada a tu winoyanoya i gagaleya ma i nei po ugolina i pa, ‘Koniliyasi!’ ");
INSERT INTO tbo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tauna anai matoutana i todi ma tu winoyanoyana i gagaleya po i pa, ‘Guyau, am luhogala awai?’ Tu winoyanoyana i pa, ‘Yaubada am lupali po am gadili dewadewana i hanapugehi po i lunugotootogogem. ");
INSERT INTO tbo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yaka geka kabudalana lawa una himilihi po hina nae u Yopa lawa gowana Simona Pita hina weluwaya. ");
INSERT INTO tbo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tauna lawa gamogamo opihi tu’mdidina gowana Simona ugolina e itoumana. Simonana a numa naka niha u liyaliyana.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Apoma Yaubada a tu winoyanoya i baha po i kokoe ma i nae. Ma Koniliyasi a tu bagibagi luwaga i otugehi. Ma gasi tu wigawiya gehouna i otugeya, tauna Yaubada tu lowogena gehouna ma Koniliyasi u liyaliyana tu mae. ");
INSERT INTO tbo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hi nei po awai hi waawala i paliwelehi ma i himilihi po hi nae u Yopa. ");
INSERT INTO tbo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Malitom po lawahi tonuga Yopa hi tutuliyaliyani ma Pita iyeta bolinai i gae po numa wogotabataba u upuna ipa ina lupali. ");
INSERT INTO tbo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma am i hilage po yohola yaniyani hi wononogogeya ma i enogagalena. ");
INSERT INTO tbo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I gagalena ma yada i gunahoeya po ginouli mei lupulu baneina u aliyana hina wogo ma ina hopuhopu mai hau hipuli. ");
INSERT INTO tbo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Geka ginoulina u hinena naka gamogamo galenana tapuna tapuna po mota po kiu. ");
INSERT INTO tbo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma lawa ponana i noonoli ma i pa, ‘Pita una towolo po geka gamogamohi una unihi po una am!’ ");
INSERT INTO tbo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma tamogi Pita i pa, ‘Guyau, apega ananihi babana i lugagayo ginouli apapoena po gobugobuna i wilugagayo ma yohola ega ata tulagoni.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lawana i baha meme i pa, ‘Awai Yaubada i laiyeuyeuya ega una pa i gobu.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mala tonuga geka pite i baha ma apoma ginoulina i wohepa po i gae hau yada. ");
INSERT INTO tbo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita yohola a enogalena anona i inugonugotuhugeya ma lawahi tonuga Koniliyasi i himihimilihi Simona a numa hi tuhagaya po hi nei po gali u matetana hi towotowolo, ");
INSERT INTO tbo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ma hi lubayada hi pa, ‘Geka hosi toumana gowana Simona Pita e mamae?’ ");
INSERT INTO tbo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita yohola i ileta ipa a enogalena anona ina tuhagaya ma Alugo Woiyawa i baha nae ugolina i pa, ‘Lawa tonuga he bibihem, ");
INSERT INTO tbo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ugolinei una hopu po ega una inugowilawila ma mitehi ona nae, babana a himilihi po hi nei.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ega yaka i hopu po lawahi ugolihi i pa, ‘Lawana o bibiheya geka tau. Ma awai binei o nei?’ ");
INSERT INTO tbo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Lawahi hi pa, ‘Tu wigawiya hai kapena gowana Koniliyasi i himiliyai po to nei. Tauna lawa dumadumaluna po Yaubada e wootalagiyeya. Yaka mi Yudeya atapuhi he iyateyateya. Yaubada a tu winoyanoya waiwoiyawana Koniliyasi i paliweleya po i himiliyai po to nei ipa to gigimem po ta nae a u numa, po awai apo una bahebahehi ina nonoli.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yaka Pita lawahi i gigimehi po hi lui numana ugolina po noka hosi hi am ma hi eno. Malitom po Pita i wotowolo po lawahi tonuga mitehi hi nae. U Yopa tu witumagana gehouhi hi wotago po mitehi hi nae. ");
INSERT INTO tbo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Malitom meme apoma u Sisaliya hi lugeleta. Ma noka hosi Koniliyasi a guguni gehouhi po a lawa gehouhi i otugehi po hi nei po hi otonana. ");
INSERT INTO tbo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hougana Pita i luilui naka Koniliyasi mitehi hi witutuhaga po Koniliyasi i peu hopu Pita aena u babana po i wiyateyateya. ");
INSERT INTO tbo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma tamogi Pita i baha po ipa Koniliyasi ina towolo po i pa, ‘Una towolo, tau lawa hota.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita Koniliyasi ugolina i ibaabani ma hi luilui po bolu hi’mboina ma hi otonana i tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma i baha nae ugolihi i pa, ‘Taumi o hanapugeya naka tau Yudeyagei ega emoemotau taumi ega mi Yudeya ipa to luwoheyanemi naka i lugagayo po ipa ega a dadanimi. Ma tamogi Yaubada i wiatatiyeu naka lugagayona amaka i kokoe. ");
INSERT INTO tbo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ugolinei ma ubeu lawa hi nenei naka ega ata luhinigigai. Ma a lubayademi, am luhogala awai?’ ");
INSERT INTO tbo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniliyasi i pa, ‘Iyeta wohepali amaka hi kokoe ma kabudala geka pite mei ibiga u tipolina u numa u hinena a laupali. Mala emosi ma lawa a kaleko namanamalina u matau i lugeleteya, ");
INSERT INTO tbo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","po i pa, ‘Koniliyasi! Yaubada am lupali po am gadili dewadewa i hanapugehi po i lunugotootogogem. ");
INSERT INTO tbo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lawa una himilihi po hina nae u Yopa, lawa gowana Simona Pita hina weluwaya. Tauna lawa gehouna gamogamo opihi tu’mdidina gowana Simona ugolina e itoumana Simonana a numa naka niha u liyaliyana. ");
INSERT INTO tbo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ega yaka mala emosi ma ubeim a wihimilana po u lunugotootogogeiyai yaka u nei. Ugolinei ma amalai atapuiyai geka hosi Yaubada u matana. Ginouli awai Guyau i paliwelem po ipa una bahebahehi naka atapuiyai to iotonana ipa to nonoli.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Apoma Pita a baha i wiwawali i pa, ‘Amalai apoma a galena tuhaga naka Yaubada a galena itete lawa ataputa ugolita naka emosi hota. ");
INSERT INTO tbo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma tupo wohepali ugolihi taumi iyawoi ona matouteya po dewa dumadumaluhi ona mimiyehi naka tauna u matana i haki duma. ");
INSERT INTO tbo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ma tuwega amaka o nonoli naka Yaubada amaka Isalaela lawiyai i paliweliyai nugodumola a tuwega dewadewana Yesu Keliso u hinena naka tauna lawa ataputa ata Guyau. ");
INSERT INTO tbo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Geka tuwegana Yoni tu wibapatiso ugolina i waawala naka i gunanohaya po u Galili ma i nae po Yudeya atapuna i wihogoya. ");
INSERT INTO tbo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tuwegana naka geka pite Yaubada Yesu Nasaletagei i wotepani po Alugo Woiyawa i wihogoya po i wipoya ma a wipoyana amaka o nonoli tupo atapuna u hinena lawa i dewadewahi ma iyawoi nawa alugo apapoena ugolihi i lauyawahihi matababana Yaubada i witulaneya. ");
INSERT INTO tbo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","‘Yesu awai atapuna i dewadewahi u Yudeya po u Yelusalem naka tauyai tu baha moina. Tauna hau ani take hi tutulawiteya po i hilage. ");
INSERT INTO tbo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ma tamogi iyeta witonugana ugolina Yaubada i witowolo meya hilage ugolina po i dewaya po i wogeletena meya. ");
INSERT INTO tbo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ega lawa atapuhi ugolihi ma Yaubada amaka i winaganiyai tauyai tu baha moina tuawiyai ugoliyai. Ma a towolo meme u mulina mitehi to am po to uma. ");
INSERT INTO tbo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma i paliweliyai i pa, ‘Lawa ugolihi tuwega dewadewana ona guuguyeya,’ po ugolinei baha moina naka tauna Yaubada i witowoli lawa hilahilagehi po lauyagohanahi tu libahibahihi. ");
INSERT INTO tbo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Binei tu bahapiko atapuhi hi bahabaha hi pa, ataputa iyawoi ugolina ta itumagana apo gowana a wipoyagei ata apapoe ina paligigilihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita yohola i ibaabani ma Alugo Woiyawa i hopu mai po bahana tu nonolina atapuhi i luinihi. ");
INSERT INTO tbo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma mi Yudeya lawahi u Yopa ma Pita hi wotagoya po hi nenei naka hi gohola dumahi, matababana Yaubada ani’mbenena Alugo Woiyawa tauhi ega mi Yudeya i welehi. ");
INSERT INTO tbo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hi lautanigana ma pona geha ega hita hanapugeya ugolinei hi ibaabani po Yaubada hi mamali po hi wotalagiyeya. Apoma Pita i baha nae a lawa ugolihi i pa, ");
INSERT INTO tbo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","‘Geka lawahi ta wibapatisohi goilei babana limoinana Alugo Woiyawa amaka i luinihi mei tauta.’ ");
INSERT INTO tbo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ega yaka i paliwelehi po Yesu Keliso gowanei bapatiso hi waya. Ma apoma hi lupaliyeya po ipa ugolihi ina mae houga kukuna. ");
INSERT INTO tbo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tauhi ega mi Yudeya Yaubada a baha hi itumaganeya naka Yesu tu wituwetuwega po tu witumagana Yudeya atapuna u hinena hi nonoli. ");
INSERT INTO tbo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hougana Pita i gegae u Yelusalem naka Yesu tu wotagona tauhi mi Yudeya lawahi hi galena iapapoeya po ");
INSERT INTO tbo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","hi pa, ‘Iyowai po ilugagayo u tulagoni po u nae po tauhi ega mi Yudeya hai u numa mitehi o am?’ ");
INSERT INTO tbo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ega yaka Pita a enogalena i waawala naka ginouli atapuna i bahena pahi po i wikokowi anona awai. ");
INSERT INTO tbo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Geka pite i paliwelehi i pa, ‘Yopa u meyageina a laupali po ginouli mei lupulu baneina a eno galeya u aliyana hi wogo ma yadei i hopuhopu mai. I hopu mai po u liyaliyau i tutowolo. ");
INSERT INTO tbo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A gagalena imaimahiyeya naka gamogamo malamalagamahi po woyahiyahihi po mota po kiu u hinena. ");
INSERT INTO tbo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Apoma a lautanigana ma lawa i pa, “Pita, una towolo po geka gamogamohi un’omunugo po una am!” ");
INSERT INTO tbo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Ma tamogi a pa, “Guyau, apega naka lugagayo ma yohola ega ginouli apapoena po gobugobuna gamougei ata am dadani.” ");
INSERT INTO tbo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","‘Ma lawana yadei i baha meme i pa, “Yaubada awai i laiyeuyeuya ega una pa i gobu.” ");
INSERT INTO tbo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dewana geka pite mala tonuga i wawala ma apoma ginoulina i wohepa po i gae hau yada. ");
INSERT INTO tbo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","‘Noka kabudalana u hinena lawa tonuga u Sisaliya ma hi himilihi po ubeu hi nenei naka numana a mimiyeya ugolina hi lugeleta. ");
INSERT INTO tbo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma Alugo Woiyawa i paliweleu i pa, ega anai nugowilawila ma lawahi a wotagohi. Geka mi Yopahi magouhi 6 hi wotago po mitehi to nae u Sisaliya, po atapuiyai to lui Koniliyasi a numa u hinena. ");
INSERT INTO tbo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","I paliweliyai iyowai Yaubada a tu winoyanoya i gagaleya ma a u numa i towolo ma i bahabaha i pa, “Lawa gehouhi una himilihi po hina nae Yopa lawa gowana Simona Pita ubeina. ");
INSERT INTO tbo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tauna apo baha ina bahebahehi naka ugolihiyei tam po am manago apo ona luyagohana.” ");
INSERT INTO tbo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","‘Hougana baha a iwawali ma Alugo Woiyawa i luinihi, amaka mei tauta lolowa ta iwawala hougana. ");
INSERT INTO tbo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma apoma Guyau a baha nugougei i gae i pa, “Yoni goilei i bapatiso ma taumi apo Alugo Woiyawei bapatiso ona waya.” ");
INSERT INTO tbo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ma i lugeleteya naka Yaubada geka ani’mbenenana emosina i welewelehi naka i weleta, hougana Guyau Yesu Keliso ta itumaganeya. Ugolinei, tau iyai po ipa Yaubada a bagibagi a lauguduguduya?’ ");
INSERT INTO tbo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hougana geka bahahi hi noonolihi po hai ompalihibahiba hi wohounihi. Ma hi tugudu po Yaubada hi wotalagiyeya hi pa, ‘Apoma Yaubada tauhi ega mi Yudeya gaogao i welehi apo hina nugobui po luyagohana tuwetuwenai hina waya.’ ");
INSERT INTO tbo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sitibeni hi ununi ugolina ma tu witumagana hi lunohanohahi po hi nae u Ponisiya po u Saipilasi po u Anitiyoka. Noka u dobuhi Yesu tuwegana lawa mi Yudeya tuawahi ugolihi hi deedeya. ");
INSERT INTO tbo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tamogi tu witumagana gehouhi mi Saipilasi po mi Sailina hi nenei u Anitiyoka naka mi Giliki ugolihi Guyau Yesu hi guguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Guyau Yaubada a wipoya tauhi ugolihi po bolu baneina hi witumagana naka Guyau hi kawaibadeya. ");
INSERT INTO tbo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Geka tuwegana tu witumagana hai bolu u Yelusalem hi nonoli yaka Banabasi hi himili po i nae u Anitiyoka. ");
INSERT INTO tbo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hougana i laugeleta naka Yaubada a lunugotootogo baneina i gagaleya po i kaoha. Ugolinei ma i winugokadidilihi ma ipa atapuhi houga daodaona Guyau ugolina hina iponawogo ma nugonugohi atapunei hina nugonugomomohi. ");
INSERT INTO tbo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi tauna lawa dewadewana. Alugo Woiyawa i wihogoya po gasi witumagana u nugonugona i lata duma. Geka binei ma bolu baneina Guyau hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Apoma Banabasi i nae u Tasasi Saulo i biheya, ");
INSERT INTO tbo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ma hougana i tutuhagaya naka i weluwaya po i neiyai u Anitiyoka. Hai luwaga noka hosi hi mae bolima emosi ma tu witumagana mitehi hi amboina ma hi iatatiyana lawa boluhi ugolihi. Ma u Anitiyoka Yesu tu wotagona apoma hai houga tahatahayana hi wigowahi po Keliso a bolu. ");
INSERT INTO tbo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Noka hougana tu bahapiko gehouhi u Yelusalem hi wotowolo po hi hopu u Anitiyoka. ");
INSERT INTO tbo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma tulahi emosi i towolo po Alugo Woiyawa a litahatahayagei i baha piko ipa apo gomala baneina tupo atapuna ina wogoya. (Ma geka gomalana naka yohola Kilodiyasi a houga i itaniwaga ugolina ma i lugeleteya.) ");
INSERT INTO tbo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ega yaka tu wimulitago hi wiwogatala ipa apo emosi po emosi a wihaguhagu ina himila niyeya walewalehihi u Yudeya tu mae ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Geka hai wihaguhaguna naka Banabasi ma Saulo u nimahi hi houni po hi niyeya tu witumagana hai tanitaniwaga u Yudeya ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Noka hougana Wasawasa Heloda i wiwawala po tu witumagana i hiniwiyuwahi po hai bolu ugolihiyei gehouhi i panipanihi. ");
INSERT INTO tbo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tauna Yesu a hewali Yamesa, Yoni walehina kwasikwasi daodaonei i uni. ");
INSERT INTO tbo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma i gagalena naka geka dewana lawa mi Yudeya i winugodewadewahi yaka i dewa gawahi po Pita i numa panipani. Geka dewana Welulagona tolehana ugolina i wawala. ");
INSERT INTO tbo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ma hougana Pita i numa panipani po hau numa panipani i houni po i kokoe ma tu galena itetena lawa wohepali wohepali i upumihi po i nae po bolu wohepali i dewahi. A nugotuhu ipa Welulagona tolehana u mulina mi Yudeya ina welehi po hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ega yaka hau numa panipani hi houni po i mamae ma tamogi tu witumagana ubeina hi laupali kadidili Yaubada ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Apo malinatom po upomna Heloda Pita ina uni ma amalai upoma tu galena itete luwaga mateta naka, gulawa pawapawasigei Pita hi numa panipani wiwileya po hi womomota luwagehi ma hi eneno ma gasi tu galena itete luwaga hi gagalena iteteya. ");
INSERT INTO tbo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma mala emosi ma yayata numana u hinena i luebaleya po Yaubada a tu winoyanoya i lugeleteya. Lawana Pita tolotolona i lutonaya po i limaamahi ma i pa, ‘Una towolo yagiyagina!’ Gulawahi pawapawasi Pita u nimana hi gunalupenihi. ");
INSERT INTO tbo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma tu winoyanoyana i baha nae Pita ugolina i pa, ‘Una leli ma am ae humahuma una otenihi.’ Yaka Pita i wiponawogo, ma tu winoyanoyana i baha meme i pa, ‘Am lupulu una luhagogoleya ma una wotagou.’ ");
INSERT INTO tbo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ega yaka tu winoyanoyana i hopuhopu ma Pita i wotago po panina i hopu haleya. Tamogi tu winoyanoyana awai i dewadewahi naka moinahi hi waawala ma Pita ega ita nugotuhu tuhagaya. A nugotuhu ipa ita lauboni. ");
INSERT INTO tbo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hi nei po tu galena itete wiluwagana hi weluwileya ma apoma hau mateta pawapawasi hi lugeleta. Geka matetana nugonei i gunahoeya po hi nae hau meyagai. Ega yaka hi lui po hi tuluwaluwaga po ega daona ma tu winoyanoyana Pita i nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Apoma nugohanahanapu i geleta meme Pita ugolina ma i pa, ‘Geka apoma a hanapugeya naka tau Heloda u nimana Guyau i haguwe ma a tu winoyanoya i himili po i halou. Gasi lawa mi Yudeya hai winugonugotuhu ipa ugoliu awai hina dewadewahi naka a nehalehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita i gagalena tuhaga po i nae Yoni Maki ma hinana Maliya hai u numa. Noka hosi lawa boluhi hi amboina ma Pita binei hi laupali. ");
INSERT INTO tbo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ma hougana i lulougo naka tu bagibagi wawinena gowana Loda i nei po ipa guduna ina hoeya. ");
INSERT INTO tbo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ma Pita ponana i nonola tuhagaya yaka ega guduna ita hoeya ma anai kaohana i bulili lui po a lawa i paliwelehi naka Pita hau mateta e towotowolo. ");
INSERT INTO tbo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","A lawa hi baha nae ugolina hi pa, ‘Nugote u badebade.’ Tamogi i lugamobagibagi yaka hi baha meme hi pa, ‘Naka nugote alugona.’ ");
INSERT INTO tbo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hi ibaabani ma Pita yohola i lulougo. Ma guduna hi hoeya ma hi gagaleya po hi gohola dumahi. ");
INSERT INTO tbo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tamogi nimanei i paliwelehi po ega hita iyahona ma apoma iyowai hau numa panipani ma Guyau i wiwihaleya naka i paliwelehi po i pa, ‘Awai i waawala naka Yamesa po walewalehita ona paliwelehi.’ Geka bahana u mulina i nehalehi po i nae dobu gehouna ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Malatomtomgei numa panipani tu galena itete hi winugoneina po hi talabibeiha, hi pa, ‘Pita miyei i nae?’ ");
INSERT INTO tbo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ma hougana Heloda i bibeiha po i beiha awa yaka tu galena itetehi i luhetalehi ma i baha po hi unihi. ");
INSERT INTO tbo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Apoma Heloda Yudeya i nehaleya po i hopu u Sisaliya i mae. Heloda mi Taya po mi Saidoni i luuyogigiyehi yaka tauhi nugonugohi ipa hina winugoemosi. Ugolinei hi nae po a numa tu galena itetena gowana Balasita mitehi hi witulaneya. Ma hi lupaliyeya ipa apo wasawasa po tauhi hina winugoemosi. Matababana wasawasana a u meyagai hi lauwahala nae, yaniyani a u tupo. ");
INSERT INTO tbo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Heloda iyeta i inagani ugolina wasawasa hai luilui i luiya ma anani tugula ugolina i tugula ma i wibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ma lawa hi ototu hi pa, ‘E ibaabani amaka mei Yaubada ma ega lawa.’ ");
INSERT INTO tbo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ma hai omhuna i waya po ega Yaubada ita wotalagiyeya yaka mala emosi ma Guyau a tu winoyanoya Heloda i dewaya po i totogo po motamota hi tonaya po i hilage. ");
INSERT INTO tbo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma naka hougana lawa Yaubada a baha hi nonoli po hi iponawogogeya. Ma hai boluna i lalata. ");
INSERT INTO tbo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi ma Saulo ma hewali gowana Yoni Maki hi weluwaya po hi gunawilehi hougana u Yelusalem hai bagibagi hi laiwoloeya. ");
INSERT INTO tbo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tu witumagana u Anitiyoka naka gehouhi tu bahapiko po gehouhi tu wiatatiyana. Naka geka gowahi: Banabasi po Simiyona (hi wigowaya po Uguwa) po Lukasi Sailinagei po Wasawasa Heloda a woilata Manaeni po Saulo. ");
INSERT INTO tbo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hougana hi iyohi po Guyau hi wotalagiyeya ma Alugo Woiyawa i paliwelehi i pa, ‘Banabasi ma Saulo ona teleliyehi po hai bagibagi tapuna ubeina a itowolihi hina dewaya.’ ");
INSERT INTO tbo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Apoma tu witumaganahi hai wiyohi po tapalolo u mulina, nimahi Banabasi ma Saulo u ununuhi hi houna po hi kawaidewedewehi ma hi himilihi po hi nae. ");
INSERT INTO tbo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabasi ma Saulo Alugo Woiyawa i himilihi yaka hi hopu niha u liyaliyana meyagai gehouna gowana Selusiya po noka hosi wam hi geluya po hi’mkuka po hi nae Saipilasi u bonabonana. ");
INSERT INTO tbo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hi kadau nae meyagai gowana Salamisi po hi gota po naka hougana Yaubada a baha hi guguyeya mi Yudeya hai numa dalabu ugolina. Ma Yoni Maki hi weluwaya po tauna hai tu hagu. ");
INSERT INTO tbo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Salamisi hi nehaleya po hi hopu po hi nenae po Paposi u meyageina hi lugeleta po hi mamae ma tu balabalau gowana BaYesu mitehi hi witutuhaga. Tauna Yudeyagei ma ipa tauna Yaubada a tu bahapiko, ma tamogi i koyama. ");
INSERT INTO tbo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tauna Saipilasi bonabonana hai taniwaga gowana Segasi Poulasi a hewali. Taniwagana naka lawa hanahanapuna, ma Banabasi ma Saulo i otugehi po hi nae babana ipa Yaubada a baha ina nonoli. ");
INSERT INTO tbo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tamogi tu balabalauna, BaYesu gowana Elimasi (pona Gilikigei i ampaligudugudu) i pa, ‘Tulau, ega una itumaganehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tamogi Saulo ta wigowaya po Paulo naka Alugo Woiyawa i wihogoya po i toditodi ma tu balabalauna i gagaleya ");
INSERT INTO tbo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","po i pa, ‘Tam mei Tomodulele. Tam ginouli dumadumaluna atapuna e igawiyeya. Koyama i wihogom po houga daodaona e ileta ipa Guyau a baha moinahi una buinihi po koyama. ");
INSERT INTO tbo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ma geka amalai apo Guyau ina wimihem po matam ina keke po ega una gagalena a sigana Yaubada am iyeta i bahebaheya ugolina una geleta, apoma apo una galena meme.’ Mala emosi ma Elimasi maya i wiwaya ma matana i uguwi po i woyadaga nae ipa lawa u nimana hina wogo po hina widaadaya. ");
INSERT INTO tbo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Apoma taniwagana Guyau a manini i gagaleya po i witumagana, po nugonugonei i’mhuna duma Guyau a wiatatiyana ubinei. ");
INSERT INTO tbo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ma a lawa hi’mkuka po Paposi hi nehaleya po hi nae po u tanowai meyagai gehouna gowana Pega hi gota tupo Pampiliya u hinena. Yoni Maki noka hosi i nehalehi po i gunawileya po i nae u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ma Paulo ma a lawa Pega hi nehaleya po aehiyei hi lui po hi nae Anitiyoka Pisidiya u tupona hi lugeleta. Ma mi Yudeya hai dalabu iyetana ugolina hi nae po hau numa dalabu hi duhuna. ");
INSERT INTO tbo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Yaubada a lugagayo Mose i gilugilumi po tu bahapiko hai giluma omhiyawana u mulina numa dalabu babadahi Paulo a lawa mitehi hi utanihi, hi pa, ‘Walewalehiyai, inapa lawa winugokadidilihi bahahi ugolimi yaka ona bahehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ega yaka Paulo i wotowolo po nimana i wohepahi po lawa hi genuwana ma i pa, ‘U lawa mi Yudeya po taumi ega mi Yudeya, Yaubada tu wotalagiyena atapumi ona lautanigana. ");
INSERT INTO tbo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yaubada tauta mi Isalaela ta itumaganeya naka googata i winaganihi, ugolinei natunatuhi hi maga duma po gasi hi kadidili duma hougana Isipita u tupona hi wihewahewa. Ma a maninigei googata i weluwinihi po Isipita hi hopu haleya. ");
INSERT INTO tbo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bolima magouna 40 u hinena Yaubada hau balabala i galena itetehi. ");
INSERT INTO tbo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ma Kainana hipulina u hinena dobu magouna 7 anai lawahi i wiapapoenihi. Ma googata i dewahi po Kainana hipulina hi tanitaniwageya naka bolima magouna 450. ");
INSERT INTO tbo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","‘Ma noka u mulina hai tu luhetala i witowolihi po hi tanitaniwagehi a sigana tu bahapiko gowana Samwela a houga witaniwaga. ");
INSERT INTO tbo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hougana Yaubada ugolina tu wiwasawasa hi laupaliyeya yaka Kisi natuna gowana Saulo i welehi. Saulo tauna Beniyamina guguninei i nei po bolima magouna 40 i witaniwaga. ");
INSERT INTO tbo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ma Saulo i wihaleya po u mulina Dawita i witowoli po hai wasawasa. Dawita ubeina geka pita Yaubada i baha i pa, “Yese natuna Dawita a tuhagaya naka tauna a luhogaleya babana u luhogala atapuhi apo ina dewahi.” ");
INSERT INTO tbo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yaubada a paliwitumagana i limoineya mi Isalaela ugolita, naka Yesu Tu wiluyagohanita i weleta, po Dawita guguninei i nei. ");
INSERT INTO tbo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yohola ega Yesu ita nei ma Yoni mi Isalaela lawahi ugolihi i nei ipa hai apapoe hina palihalehi ma bapatiso hina waya. ");
INSERT INTO tbo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ma Yoni a bagibagi mei ina ikokowi ma i baha nae mi Yudeya lawahi ugolihi i pa, “Ami nugotuhu o pa tau iyai? Tu wiluyagohana o ototoni naka ega tau. Tamogi muliugei e nenei.” Ma Yoni i baha wiyateyate Yesu binei i pa, “Tau ega u dewadewa awai ipa a pouleya, po a ae humahuma a wihaleya.” ");
INSERT INTO tbo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Walewalehiu, Abelaham googana po taumi ega mi Yudeya iyawoi Yaubada tu wotalagiyena geka hosi, tauta ugolita geka luyagohanana tuwegana Yaubada i himiliyai. ");
INSERT INTO tbo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tuwegana naka Yesu binei, tamogi iyawoi u Yelusalem tu mae hai tanitaniwaga mitehi ega hita hanapugeya naka tauna Tu wiluyagohana. Ma gasi tu bahapiko hai baha dalabu magamaga he hiyahiyawi naka ega hita nugotuhu tuhagaya. Tamogi Yesu hi igouya naka tu bahapikohi hai baha hi laimoineya. ");
INSERT INTO tbo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Moina hai wigou ega anona tamogi Pilato hi lupaliyeya ipa Yesu hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yesu ubeina Yaubada a Bukau ugolina ginouli atapuna hi gilugilumi naka hi lautagoya po i kokoe ma hau ani take hi wihaleya po hau kokowaga hi houni. ");
INSERT INTO tbo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tamogi Yaubada hau hilage ma i witowolo meya po i woogeletena meya lawa ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naka tauhi mitehi lolowa Galili hi nehaleya po hi kadau gae Yelusalem. Ma i wogeletena meya ma i mamae naka iyeta magomagouna. Tauhi amalai a tu baha moina mi Yudeya lawahi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Tiyai to nei geka hosi ipa tuwegana dewadewana to dedeya ugolimi. Mei Yaubada a paliwitumagana googata ugolihi ");
INSERT INTO tbo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ipa Yesu ina itowolo meya naka tauta ugolita e laimoineya. Mei Sam wiluwagana u hinena hi gilugilumi geka pite, “Tam Natuwe, amalai a wogeletem lawa boluhi u matahi naka tam Natuwe.” ");
INSERT INTO tbo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ma Yaubada Yesu i witowolo meya po ega emoemotana Yesu ina buda, mei a Buka i bahebaheya pite i pa, “Kawaidewadewa waiwoiyawana po moinana tam natuwe apo a welem. Mei Dawita a palipaliwitumaganeya.” ");
INSERT INTO tbo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ugolinei ma i baha meme i pa, “Yaubada a Tu bagibagi waiwoiyawana apega ina palihaleya po ina buda.” ");
INSERT INTO tbo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Geka paliwitumaganana ega Dawita binei babana Dawita a u houga Yaubada a nugotuhu i wootagohi po i hilage. Ma googana kokowagahi u liyaliyana hi guluwi po hinina i buda. ");
INSERT INTO tbo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma tamogi Yaubada lawa emosi hotana hau hilage i towolo meya apega ina buda. ");
INSERT INTO tbo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Walewalehiu, geka binei ipa ona hanapugena dumaya naka geka lawana ugolinei apo apapoe ina paligigilihi po binei ma tuwegana to guuguyeya ugolimi. ");
INSERT INTO tbo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ma ugolinei apo tu witumagana atapuhi ina houna idumaluhi. Mose a lugagayo ega ita huhouna idumaluta ma Yesu ugolinei apo hina houna idumaluta. ");
INSERT INTO tbo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ugolinei ipa ona gagalena imahi po tu bahapiko awai hi bahebaheya, apega ona wialoni. Hi pa, ");
INSERT INTO tbo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Ona lautanigana taumi tu’mpalihibahiba, ona wineneyabayababa ma ona hilage. Matababana ami houga bagibagi awai a dewadewaya naka apega ona witumaganeya. Hawena lawa gehouna ina paliwelemi ma apega ona witumaganeya.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hougana Paulo ma Banabasi numa dalabuna hi nenehaleya ma lawa hi lupaliyehi ipa dalabu gehouna hina gunawilehi po geka ginoulihi hina dede mehi. ");
INSERT INTO tbo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Omboina u mulina mi Yudeya po ega mi Yudeya naka mi Yudeya hai witumagana hi wiwaya tauhi atapuhi Paulo ma Banabasi hi wotagohi. Ma tu wituwetuwegahi lawahi ugolihi hi baha ma hi winugokadidilihi hi pa, ‘Yaubada a lunogotootogo ona meme tagoya houga daodaona.’ ");
INSERT INTO tbo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Dalabu gehouna naka lawa atapuhi meyageina u hinena hi nei po Guyau a baha ipa hina nonoli. ");
INSERT INTO tbo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Hougana mi Yudeya lawa boluna hi gagaleya po omgenagenalili nugonugohi i wihogoya. Ma Paulo a baha hi tugotugowiwili po hi yampaligudugudu. ");
INSERT INTO tbo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tamogi Paulo ma Banabasi hi bahabaha gawata babana ega hita geno, po hi pa, ‘Lawa ipa Yaubada a baha hina dede tahaeya ugolimi ma a bahana o wihinigigiyeya. O pa ega ami dewadewa awai ipa luyagohana tuwetuwenai ona waya yaka apo to nehalemi po to nae tauhi ega mi Yudeya ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Matababana i lugagayo geka pite Guyau i baheya i pa, “Tam a witowolim yayata tauhi ega mi Yudeya ugolihi. Tam ugolimgei apo luyagohana una neiyai tupo wohepali.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hougana tauhi ega mi Yudeya geka bahana hi noonoli po hi kaoha ma Yaubada a baha hi wiyateyateya. Ma iyawoi Yaubada i inaganihi luyagohana tuwetuwenai ubeina naka hi witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma Guyau a baha i gunanohaya po tupo noka i wihogoya. ");
INSERT INTO tbo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tamogi mi Yudeya, meyageina babadahi po wiwine waigapolahi po gasi waitumaganahi, hi liuyogigeinihi. Yaka lawa hi lihunahi po Paulo ma Banabasi hi wigawiyehi po tupo naka hi nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ega yaka tu wituwetuwegahi aehi dubudubuhi noka u meyageina hi lihooholihi ma hi nehalehi po hi nae u Ikoniyam. ");
INSERT INTO tbo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma Yesu tu wotagona Alugo Woiyawa i wihogohi po gasi kaoha i wihogohi. ");
INSERT INTO tbo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","U Ikoniyam Paulo ma Banabasi mi Yudeya hai numa dalabu ugolina hi lui po hi luguguya. Hai luguguya ugolina ma mi Yudeya po ega mi Yudeya bolu baneina hi witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma mi Yudeya Keliso ega hita itumagana tauhi ega mi Yudeya hi liuyogigeinihi po tu witumagana hi wigawiyehi. ");
INSERT INTO tbo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ega yaka Paulo ma Banabasi hi meidaodao u Ikoniyam. Guyau ubeina hi bahabaha kadidili. Ma Guyau a lunugotootogo i laimoinehi hai baha ubeihi naka Paulo ma Banabasi i dewahi po wekiwekilala po manini nimahiyei hi wogeletehi. ");
INSERT INTO tbo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Meyageina u hinena naka lawa hi gunanohahi po bolu luwaga. Gehouhi tu wituwetuwegahi ubeihi hi nenae ma gehouhi mi Yudeya ubeihi hi nenae. ");
INSERT INTO tbo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Apoma mi Yudeya po tauhi ega mi Yudeya, hai babada mitehi hi wiwogatala po ipa Paulo ma Banabasi hina dewa guyougehi po gaimei hina wilawihi. ");
INSERT INTO tbo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hougana wiwogatalana Paulo ma Banabasi hi hanahanapugeya po hi lowo po hi nae u Lisita po u Debi, meyagai baneihi Laikoniya u tupona. Ma gasi meyagai gehouhi Laikoniya u hinena ");
INSERT INTO tbo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ugolihi Yaubada a baha hi guguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lawa gehouna u Lisita i mamae naka hinana u managona ma aena i apapoe po ega ita nenae ma i tugutugula. ");
INSERT INTO tbo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tauna Paulo a baha i noonoli ma Paulo lawana i gagalena imahiyeya po i pa, ‘Geka lawana a witumagana binei emoemotana ina luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Yaka Paulo i todi ma lawana i gagaleya po ponana i lata ma i baha nae ugolina i pa, ‘Aemgei una towolo dumadumalu!’ Lawana i lupa gae ma i hopu po i lautowologeya po aenei i nae ma i nei. ");
INSERT INTO tbo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Awai Paulo i dewadewaya, bolu hi gagaleya po Laikoniya ponahigei hi ototu hi pa, ‘Yaubada hi lilawa hotahi po hi hopu mai ugolita.’ ");
INSERT INTO tbo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabasi hai yaubada hi wiwaligeheya po hi pa, Susi. Ma Paulo hai yaubada gehouna hi wiwaligeheya po hi pa, Hemesi, babana tauna omboinana i tanitaniwageya. ");
INSERT INTO tbo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yaubada Susi a tu witalaguyaba, a numa dalabu meyageina u aliyana naka bulumakau anai wihiyana i neiyai po meyageina mateta ma ugolina ipa lawa mitehi hina witalaguyaba. ");
INSERT INTO tbo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tamogi Paulo ma Banabasi geka dewana hi nonoli, yaka hai luilui hi laugagihi ma bolu u hinehi hi lui po hi ototu hi pa, ");
INSERT INTO tbo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","‘Iyowai po geka dewana o dewedeweya? Tiyai lawa hota mei taumi. Ma to nei ipa tuwega dewadewana to dedeya ugolimi po geka dewahi ona palihalehi, ma ona luhagawilemi Yaubada Lauyagohanana ugolina. Geka Yaubadana tauna yada po hipuli po boga i dewahi. Ma u hinehi awai he mamae i dewahi. ");
INSERT INTO tbo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lolowa hapa odubona i palihalehi po hai nugotuhu hi lautago. ");
INSERT INTO tbo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tamogi dewa dewadewahi houga magomagouna i dewedewehi naka i laimoinena meya ugolihi. Mahula po gadiwewe yadei i weleta. Yaniyani i weleta po nugonugota i wikaoahahi.’ ");
INSERT INTO tbo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Geka ompaliguduguduhi bahahi hi bahehi ma tamogi lawa boluhi yohola hi ileta ipa hina witalaguyaba Paulo ma Banabasi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mi Yudeya Anitiyoka tupo Pisidiyagei hi nei po Ikoniyamgei hi nei u Lisita. Tauhi lawa boluhi nugonugohi hi litomatomahi po Paulo gaimei hi wilawi ma hi teina niyeya meyageina u aliyana. Hai nugotuhu hi pa amaka ita hilage. ");
INSERT INTO tbo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tamogi hougana tu wimulitago hi nei po hi meme wiwileya naka i towolo po meyageina i lui meya. Malitom po tauna ma Banabasi mitehi hi nae u Debi. ");
INSERT INTO tbo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo ma Banabasi tuwega dewadewana u Debi hi guguyeya po lawa boluhi hi winugobuinihi. Ma hi gunawilehi po hi nae u Lisita po u Ikoniyam po hi nae u Anitiyoka Pisidiya u hinena. ");
INSERT INTO tbo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Hai nae ugolihi tu wimulitago hi inugokadidilihi po hi pa, ‘Ona nugomomota omi witumagana ugolihi. Babana pilipili magomagouhi apo ta weluwilehi ma apoma apo Yaubada anani taniwaga ugolina ta geleta.’ ");
INSERT INTO tbo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo ma Banabasi bolu emosi po emosi u hinehi hai tanitaniwaga hi witowolihi. Ma anai lupalihi po anai wiyohihi hi’mbenenehi Guyau u nimana babana tauna ugolina hai witumagana hi hounihi. ");
INSERT INTO tbo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidiya tupona hi weluyayahi ma apoma hi nae Pampiliya anani taniwaga ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tuwega dewadewana u Pega hi guguyeya ma apoma hi hopu u Ateliya ");
INSERT INTO tbo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","po u Ateliya ma hi gelu po hi nae Anitiyoka. Lolowa u Anitiyoka tu witumagana Yaubada a lunugotootogo po a galena itete binei hi lupali po Paulo ma Banabasi hi himihimilihi naka hi lugeleta meme babana hai bagibagi hi wikokowi. ");
INSERT INTO tbo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hougana u Anitiyoka hi laugeleta naka tu witumagana hai bolu hi tuboinihi ma Yaubada ginouli atapuhi ugolihi i dewadewahi naka hi paliwelehi. Ma gasi tauhi ega mi Yudeya Yaubada hai gaogao i welehi po hi witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma u Anitiyoka tu witumagana mitehi hi meidaodao. ");
INSERT INTO tbo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lawa gehouhi Yudeyagei hi nei u Anitiyoka po walewalehihi hi iatatiyehi hi pa, ‘Inapa ega ami wekiwekilala hini omhapina ona waya mei Mose lugagayo i gilugilumi ugolina yaka apega ona luyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo ma Banabasi lawahi mitehi hi wigamogahigahi geka bahana binei. Ega yaka Paulo ma Banabasi lawa gehouhi hi itowolihi mitehi hi nae u Yelusalem, tu wituwetuwega po tanitaniwaga ipa hina galehi geka bahana ubeina. ");
INSERT INTO tbo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Paulo ma Banabasi ma lawahi hi himilihi po hi nenae naka hougana Ponisiya tupona po Samaliya tupona hi luinihi po hi nenae naka hi ipaliwelena hi pa, ‘Tauhi ega mi Yudeya Yaubada hi itumaganeya.’ Naka ugolinei walewalehihi atapuhi hi kaoha duma. ");
INSERT INTO tbo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hougana u Yelusalem hi laugeleta naka tu witumagana hai bolu po tu wituwetuwega po tanitaniwaga hi likaohahi. Ma Paulo ma Banabasi Yaubada ginouli atapuhi ugolihi i dewadewahi naka hi paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tamogi mi Yudeya hai lugagayo tu wiatatiyana gehouhi Yesu hi wootagoya ugolinei hi towolo po hi pa, ‘Tu meuputa lawahi iyawoi nawa Yesu hi itumaganeya ona paliwelehi ona pa, “Wekiwekilala hini omhapina ona waya po Mose a lugagayo i gilugilumi naka i pa ona iponawogogeya.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ega yaka tu wituwetuwega po tanitaniwaga hi’mboina po geka bahana hi wibaabaniyeya. ");
INSERT INTO tbo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ma hai wibaabani a dao u hinena naka Pita i towolo po i baha nae ugolihi i pa, ‘Walewalehiu, o hanapugeya lolowa u hayami ma Yaubada i winaganiu, po ipa tauhi ega mi Yudeya ugolihi tuwega dewadewana a guguyeya, ma apo hina nonoli po hina witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ma lawa hai nugotuhu naka Yaubada i hanapugena dumahi, po tu meuputa iyawoi nawa hi itumagana i galena idewedewehi. A galena idewadewa i wogeleteya naka Alugo Woiyawa i welehi mei i weleweleta pite. ");
INSERT INTO tbo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tauhi po tauta ega ita galena ikahata. Nugonugohi i liyeuyeuhi babana hi witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ugolinei tu wimulitago wouhi ega ta laipeunihi Mose a lugagayo ugolinei. Geka witeina ega emoemotana ipa ta awali babana odubona po amalai naka lugagayona ata ani peu. Geka dewana binei ega Yaubada ta laudadani. ");
INSERT INTO tbo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ta itumagana po Guyau Yesu a lunugotootogogei ta lauyagohana naka amaka mei tauhi gasi.’ ");
INSERT INTO tbo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita a baha u mulina ma lawa atapuhi ega ponahi ma hi lautanigana. Banabasi ma Paulo Yaubada a wekiwekilala po a manini atapuhi tauhi ega mi Yudeya u hayahi i dewadewahi naka hi dede pahihi. ");
INSERT INTO tbo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hai widedede u mulina Yamesa i baha i pa, ‘Walewalehiu, ona lautanigana! ");
INSERT INTO tbo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pita i dedeya iyowai Yaubada tauhi ega mi Yudeya ugolihi i woogeletena meya po u hayahi a guguni i inaganihi. ");
INSERT INTO tbo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Geka pite emoemotana mei tu bahapiko hai baha Yaubada a Buka ugolina i pa, ");
INSERT INTO tbo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Geka u mulina apo a gunawileu, po Dawita a numa i guliguli a witowola meya. Awai hi woapapoe apo a liwou mehi, ma a witowolihi, ");
INSERT INTO tbo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","po apo lawa atapuhi tau Guyau hina biheu. Ma tauhi ega mi Yudeya waigowahi apo hina wigaliugei. ");
INSERT INTO tbo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Geka pite Guyau ponana lolowa i bahebahena geleteya.” ");
INSERT INTO tbo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‘Ugolinei ma u wikaha naka tauhi ega mi Yudeya Yaubada he itumaganeya, ega ipa ta laipilipilihi. ");
INSERT INTO tbo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tamogi ipa hai pepa ta gilumi po ta paliwelehi: Aniani hi yambenenehi talaoloto ugolihi ega hina ananihi. Ega hina matamatamaga. Gasi ega muhala waitalana po gadouna he kikiki hina anani. ");
INSERT INTO tbo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Matababana geka lugagayohi Mose i gilugilumihi mi Yudeya hau numa dalabu hi guuguyeya houga i dao duma. Ma a baha meyagai atapuhi u hinehi dalabu emosi po emosi he guuguyehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tu wituwetuwegahi po tanitaniwaga po tu witumagana boluhi mitehi hi wiwogatala po lawa hi winaganihi boluna u hinena. Tauhi apo Paulo ma Banabasi mitehi hina himilihi po hina nae u Anitiyoka. Lawa hi itowolihi naka Yudasa (gowana gehouna Basabasa) ma gasi Sailasi. Naka hai luwagahi walewalehihi hi wiyateyatena dumahi. ");
INSERT INTO tbo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pepa lawahi mitehi hi himilihi po hi nenae naka geka pite: ‘Tu wituwetuwega po tanitaniwaga tiyai, walewalehimi i wimaamala taumi walewalehiyai atapumi ugolimi. Taumi ega Yudeya lawami u Anitiyoka po u Siliya po u Silisiya tu mae. ");
INSERT INTO tbo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amaka to nonoli naka i bolu ugolina lawa hi nehi po hi lipilipilimi po nugonugomi hi wiapapoenihi hai baha ugolihiyei. Tamogi ega ugoliyai hita lubayada ma geka dewana hi deweya. ");
INSERT INTO tbo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ugolinei ma to’mboina po atapuiyai to lueena ma lawa to winaganihi po hi nehi ugolimi ata lawa Banabasi po Paulo mitehi. ");
INSERT INTO tbo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Hai luwaga hai luyagohana hi palihalehi Guyau Yesu Keliso gowanei. ");
INSERT INTO tbo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ma Yudasa po Sailasi to himilihi tauhi apo ginoulihi to gilugilumihi emoemotahi apo hina limoinehi. ");
INSERT INTO tbo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Matababana Alugo Woiyawa a nugotuhu mei i nugotuhu po ipa ega to laiwiteinimi, ma geka ginoulihi tuawahi ona wootagohi. ");
INSERT INTO tbo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Aniani hi yambenenehi talaoloto ugolihi ega ona ananihi. Ega muhala waitalana po gadouna hi kikiki ona anani. Ega ona matamatamaga. Inapa geka ginoulihi ega ugolihi ona wogowogo nae yaka apo ona meimahi. Kihoni.’ ");
INSERT INTO tbo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tu winoyanoyahi hi himilihi po hi nenae naka hi hopu u Anitiyoka po tu witumagana hai bolu hi boinihi ma pepana hi welehi. ");
INSERT INTO tbo_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ma lawahi pepana hi hiyahiyawi po a baha winugokadidili ugolina ma hi kaoha duma. ");
INSERT INTO tbo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasa ma Sailasi naka tauhi Yaubada a tu bahapiko ugolinei ma walewalehihi mitehi hi wibaabani duma. Hi inugokadidilihi po hi towolo kadidili. ");
INSERT INTO tbo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tauhi mitehi hi meidaodao ma apoma hi himilihi po anai nugodumolahi hi gunawilehi tu himilihi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tamogi Sailasi i nugonugotuhu po noka hosi i mae. ");
INSERT INTO tbo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo ma Banabasi u Anitiyoka hi mamae, ma lawa magomagouhi mitehi Guyau a baha hi guuguyeya po hi atatiyaneya. ");
INSERT INTO tbo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Iyeta wabiha hi kokoe ma Paulo i baha nae Banabasi ugolina i pa, ‘Ta gunawilena meta po walewalehita ta dadanihi lolowa meyageihi ugolihi Guyau a baha ta guuguyeya, po ta galena niyehi iyowai hai mae galenahi.’ ");
INSERT INTO tbo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi a luhogala ipa Yoni Maki hina weluwaya po mitehi hina nae. ");
INSERT INTO tbo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ma Paulo i nugonugotuhu po ega ita dumalu, babana lolowa u Pampiliya hi mamae po Yoni Maki i lowo halehi ma ega ita wotagohi po hai bagibagi hita wikokowi. ");
INSERT INTO tbo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ugolinei Paulo ma Banabasi geka bahahi bihiyei ma hi lugamogahigahi po hi wikahakaha. Banabasi Yoni Maki i weluwaya po hi’mkuka po hi nae u Saipilasi. ");
INSERT INTO tbo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ma Paulo Sailasi i winagani po mitehi ipa hina nae, po ega yaka walewalehihi Paulo ma Sailasi hi lupali ubeihi ipa Guyau a lunugotootogo po a galena itete ina melabenihi. ");
INSERT INTO tbo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ma hi’mhoe po Siliya ma Silisiya hai ani taniwaga meyageihi hi luinihi po tu witumagana hai bolu atapuhi hi itowolo kadidilihi. ");
INSERT INTO tbo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Naka hougana Paulo ma Sailasi hi nae u Debi po gasi hi nehaleya po hi nae u Lisita. Ma noka hosi u Lisita tu wimulitago gehouna i mamae, gowana Timoti. Timoti hinana wawine Yudeyagei ma Yesu i itumaganeya. Ma amana lawa Gilikigei. ");
INSERT INTO tbo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tu witumagana atapuhi u Lisita po u Ikoniyam naka Timoti hi kawaidewedewena dumaya. ");
INSERT INTO tbo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo nugonugona ipa Timoti ina weluwaya. Ega yaka mi Yudeya hai dewagei a wekiwekilala hini omhapina i waya babana lawa noka hosi tu mae tauhi mi Yudeya po hi hanapugeya Timoti amana lawa Gilikigei. ");
INSERT INTO tbo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lisita hi nehaleya po hi nenae meyagai emosi po emosi hi luinihi naka Yelusalem tu wituwetuwegahi po tanitaniwaga dewa awai hi laueenehi naka tu witumagana hi palipaliwelehi ipa hina iponawogogehi. ");
INSERT INTO tbo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ega yaka tu witumagana hai bolu hi witowolo kadidilihi po iyeta emosi po emosi lawa hi nugonugobui ma tu witumagana hai bolu hi magamaga. ");
INSERT INTO tbo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ma hi kadau po hi nae tupo Piligiya ma Galatiya ugolihi ma Alugo Woiyawa ega ita palihalehi ipa Guyau a baha hina guguyeya u Asiya. ");
INSERT INTO tbo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ega yaka Maisiya u tuponana hi nae po sigana ugolina hi lugeleta po hi ileta ipa Bitiniya tupona hina luiya. Tamogi Yesu Alugona Waiwoiyawana ega ita palihalehi ipa hina lui. ");
INSERT INTO tbo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ega yaka Maisiyagei hi’mhoe po hi hopu u Tolowasi. ");
INSERT INTO tbo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ma noka upomna Paulo i eno galena po lawa Masedoniyagei i gagaleya ma i towolo po i laupaliyeya i pa, ‘Una lunugotootogeiyai po una damanai u Masedoniya po una haguiyai.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Hougana Paulo lawana i eneno gagaleya po i welutowolo po to wononogo po tau ipa mitehi to nae u Masedoniya babana to nugotuhuya naka Yaubada i otugeiyai ipa tuwega dewadewana lawa noka hosi ugolihi to guguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ega yaka u Tolowasi ma wamgei to’mkuka po to dumalu, po to damana bonabona gowana Samotalesi ugolina. Ma malitom po to damana u Nipolisi. ");
INSERT INTO tbo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Noka hosi ma to lui po to nae Masedoniya meyageina baneina Pilipai ugolina. Meyageina gasi mi Loma hi mimiyeya. Noka u meyageina to mamae iyeta ega hita maga imahi. ");
INSERT INTO tbo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ma hau dalabu, meyageina to nehaleya po to nae goila u hadana. Tu nugotuhuya apo noka hosi mi Yudeya hai ani lupali to tuhagaya. Wiwine noka hosi hi’mboina mai po to duhuna ma ugolihi to wibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tu lutaniganeiyai emosi naka Lidiya, wawine Tayatailagei. Tauna luilui kayakayahi i gimagimalehi. Wawinena naka Yaubada tu wotalagiyena gehouna po nugonugona Guyau i luhoeya ma Paulo awai i bahebahehi naka ugolihi i kawamoina. ");
INSERT INTO tbo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Po noka hougana tauna po a numahine lawahi hi bapatisohi ma u mulina i igiigimeiyai i pa, ‘Taumi o baha o pa tau Guyau tu witumaganena moinana yaka ona nei po u numa ona mae.’ Ma nugonugoiyai i talatalahi po to nae. ");
INSERT INTO tbo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Iyeta gehouna to’mhoe po to nenae ani lupali dobuna ugolina po tu bagibagi wawinena to tuhagaya. Wawinena naka alugo palopaloumana i luiya po i dewaya po awai apo houga u naota hina waawala i bahebahehi. Geka dewana ugolina ma mone baneina a tanitaniwaga ubeihi i dewadewaya. ");
INSERT INTO tbo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Paulo po tiyai i wotagoiyai po i ototu i pa, ‘Geka lawahi naka Yaubada Gegewahagana a tu bagibagi. Tauhi luyagohana tahayana he bahebaheya ugolimi.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Geka dewana iyeta magomagouna i dewedeweya a sigana Paulo uyona i gigai ma i luhagawileya po alugona palopaloumana ugolina i baha nae. I pa, ‘Yesu Keliso gowanei a paliwelem, naka wawinena una hopuhaleya!’ Mala emosi ma alugo palopaloumana wawinena i hopu haleya. ");
INSERT INTO tbo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wawinena a tanitaniwaga hi gagalena po hai ani lumone tahayaha i kokoe. Ega yaka Paulo ma Sailasi hi womomohihi po hi teina niyehi ani gimala u dobuna, tanitaniwaga ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hi neihi mai po tu luhetala mi Loma u naohi ma hi pa, ‘Geka mi Yudeya lawahi, ma ata meyagai u hinena pilipili he laiwawalihi. ");
INSERT INTO tbo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Lugagayo he iatatiyanehi naka tauta mi Loma ata lugagayo he tutulagonihi po ega emoemotana ta winihi po ta metagohi.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Paulo ma Sailasi hi lawihi naka bolu tu luhetalahi u hayahi hi lui po hi wilougo haguhagu. Ma tu luhetalahi Paulo po Sailasi hai kaleko hi laulolohi ma hi baha po hi kwapukwapuhi. ");
INSERT INTO tbo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hi wilawihi po i kokoe ma hau numa panipani hi hauluiyehi. Ma numa panipani tu galena itete hi paliweleya hi pa, ‘Numa una gudu momohi.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tu galena itetena baha i noonoli po Paulo ma Sailasi numa panipani u hine dumana i hounihi ma aehi mayau talaikukuna ugolina i panipani lawitehi. ");
INSERT INTO tbo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mei upom u tipolina Paulo ma Sailasi hi laupali ma hi lulougo tapalolo Yaubada ugolina ma hai lawa numa panipani u hinena hi lautanigana. ");
INSERT INTO tbo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mala emosi ma guhuguhu baneina i nei po panina ogolana i guhuhi po mala emosi ma gudu atapuna i gunahoe pahi. Ma lawa atapuhi hai ae panipani pawapawasi hi gunagunalupenihi. ");
INSERT INTO tbo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tu galena itete i welutowolo po gudu gamohi hi taatagihi ma a nugotuhu ipa amaka lawahi hita lowo. Ega yaka a kwasikwasi i waya po ipa ina uni meya. ");
INSERT INTO tbo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ma Paulo i otu labatana ugolina i pa, ‘Ega una ununi mem babana atapuiyai geka u hinena.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tu galena itetena yayata ubeina i otu i pa, ‘Lampa ona neiyai,’ ma i bulili lui Paulo ma Sailasi u aehi po i guli hopu ma i taatawa a matouta binei. ");
INSERT INTO tbo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ma apoma i weluwinihi po hi hopu u uputa ma i lubayadehi i pa, ‘Babada, awai apo a dewaya po a luyagohana?’ ");
INSERT INTO tbo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ma hi pa, ‘Guyau Yesu una witumaganeya yaka apo una luyagohana. Tam po am numahine lawahi mitehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ega yaka a numa u hinena Guyau a baha hi guguyeya tauna po a manago lawahi atapuhi ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Noka uguwana ugolina Paulo ma Sailasi i weluwinihi po kelohi i ogahi ma tauna po a manago atapuhi hi wibapatisohi. ");
INSERT INTO tbo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ma apoma i weluwinihi po hi gae a numa ugolina po aniani i welehi po hi am. Ma lawana a manago mitehi hi kaoha duma babana Yaubada hi witumaganeya. ");
INSERT INTO tbo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Malitom po tu luhetalahi tu’mpanipani hi himilihi po hi nenae naka baha geka hi himili hi pa, ‘Naka lawahi ona wohalehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tu galena itete geka bahahi Paulo ugolina i bahehi i pa, ‘Tu luhetala baha hi himiliyai ipa to wohalemi. Ugolinei ma ona hopu mai a nugodumolami ona nae.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tamogi tu’mpanipani ugolihi Paulo i baha nae i pa, ‘Ega i powa awai ma bolu u matahi hi wilawiyai ma hau numa panipani hi houniyai. Tauhi hai powa babana tiyai Loma lawiyai, ma ega emoemotana ipa gowagowadei hina hauhopu neiyai? Apeega! Tauhi hina nei po hina hauhopu neiyai.’ ");
INSERT INTO tbo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tu’mpanipani geka bahahi hi bahebahehi tu luhetala ugolihi po tu luhetalahi hi matouta duma matababana Paulo ma Sailasi naka mi Loma. ");
INSERT INTO tbo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ega yaka hi nae po Paulo ma Sailasi hi mamalihi ma hi weluwinihi po numa panipani hi hopu haleya. Ma hi lupaliyehi ipa meyageina hina nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Numa panipani hi hopu haleya po hi nae Lidiya a numa ugolina. Ma noka hosi tu witumagana hi tuhagahi po hi winugokadidilihi ma hai u meyagai hi nehalehi. ");
INSERT INTO tbo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo ma Sailasi hi nehalehi po hi nae Ampipolisi po Apoloniya hi luinihi po hi weluwilehi. Ma hi nei u Tesalonika mi Yudeya hai numa dalabu i memeyana. ");
INSERT INTO tbo_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ma Paulo a dewa houga daodaona ugolinei ma i dumalu po i nae hau numa dalabu. Noka u numana Yaubada a Buka ugolinei lawa i iatatiyehi naka dalabu gaogaona tonuga. ");
INSERT INTO tbo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tauna Yaubada a baha i deede imahiyehi po i laimoinehi naka ipa Yesu ina hilage po ina towolo meme. Ma Paulona i pa, ‘Geka Yesuna ugolimi a deedeya naka tauna Besinana lawana.’ ");
INSERT INTO tbo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mi Yudeya gehouhi nugonugohi i waya po Paulo ma Sailasi hi wotagohi. Ma gasi tu wotago gehouhi naka mi Giliki boluhi Yaubada tu wotalagiyena po wiwine waigapolahi gehouhi. ");
INSERT INTO tbo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tamogi mi Yudeya hi’mgenagenalili po lawa woapapoehi hi tuboinihi po bolu hi dewaya. Ma meyageina atapuna u hinena hi laigologololo po Yasona a numa hi wigawiyeya ipa iyowaka ma Paulo ma Sailasi hi bibihehi po ipa hina hopu nehi lawa boluhi u matahi. ");
INSERT INTO tbo_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tamogi ega hita tuhagahi, yaka Yasona po tu witumagana gehouhi hi teina niyehi meyagai tanitaniwagahi ugolihi. Ma hi ototu hi pa, ‘Paulo ma Sailasi tauhi naka tupo atapuhi he laipilipilihi. Ma amalai hi lui mai ata meyagai u hinena, ");
INSERT INTO tbo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","po Yasona a numa ugolina i hounihi po he mamae. Tauhi ata wasawasa baneina Sisa a lugagayo he tutulagonihi. Ma hi pa Wasawasa gehouna, gowana Yesu.’ ");
INSERT INTO tbo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tanitaniwaga po lawa geka bahahi hi noonolihi po nugonugohi hi geno duma, ");
INSERT INTO tbo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ma hi baha po Yasona a lawa mitehi hi wimeiha monegei hai numa panipani lupena halenana binei ma apoma hi wohalehi. ");
INSERT INTO tbo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Aipompom ma tu witumaganahi Paulo ma Sailasi hi himilihi po hi nae u Beleya. Hougana u Beleya hi laugeleta naka hi nae mi Yudeya hai numa dalabu ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Noka hosi lawa nugonugohi hi lugadagadalihi ega mei lawa u Tesalonika nugonugohi hi pupu. Matababana lawa u Beleya Paulo a baha hi lautaniganeya ma hi luweluweya Yaubada a Buka ugolina iyeta emosi po emosi. Moina Paulo a baha moinahi bo eega, naka ubeina ma hi luweluwehi. ");
INSERT INTO tbo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ugolinei mi Yudeya boluhi hi witumagana ma gasi wiwine mi Giliki waigapolahi gehouhi po ololoto mi Giliki magomagouhi hi witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tamogi mi Yudeya u Tesalonika naka Paulo u Beleya Yaubada a baha i guuguyeya hi nonoli. Yaka hi nei po lawa hi liuyogigeinihi po Paulo ma Sailasi hi wigawiyehi. ");
INSERT INTO tbo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ega yaka tu witumagana Paulo hi himili po i nae u niha ma Sailasi Timoti mitehi u Beleya hi mae. ");
INSERT INTO tbo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lawahi Paulo mitehi hi gelu po hi nenae naka u Ateni hai siga. Noka hosi ma hi gunawilehi po hi nenae u Beleya naka Paulo a baha hi waya, po ipa Sailasi ma Timoti hai bagibagi ina kokoe naka Paulo hina latu yagiyagineya. ");
INSERT INTO tbo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo u Ateni Sailasi po Timoti i ototonihi naka nugonugona i witai duma babana u meyageina talaoloto i maga duma. ");
INSERT INTO tbo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ega yaka mi Yudeya po tauhi ega mi Yudeya Yaubada tu wotalagiyena, mitehi hi wigamogahigahi hau numa dalabu ma ani gimala dobuna ugolina, iyeta emosi po emosi lawa hi ialoni naka mitehi hi igamogahigahi. ");
INSERT INTO tbo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ma tu hanahanapu hai bolu gowahi Epikuli ma Sitoweki lawahi gehouhi Paulo mitehi hi wigamogahigahi. Ma gehouhi hi pa, ‘Geka buuwana ipa awai ina baheya?’ Gehouhi hi pa, ‘Galenana mei tupo geha yaubadahi hai tu luguguya.’ Geka bahana hi baheya babana Yesu tuwegana po a towolo meme i guuguyeya. ");
INSERT INTO tbo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ega yaka Paulo hi weluwaya po hi niyeya tanitaniwaga hai omboina gowana Aliyopago ugolina po hi pa, ‘Wiatatiyana wouna geka tam e ibaabaniyeya ipa to hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ginouli gehouhi to noonolihi naka to winugoniniyehi, binei ipa to hanapugehi anohi awai.’ ");
INSERT INTO tbo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Hai lubayada babana gegeka, mi Ateni po gasi tupo geha lawahi u Ateni hi mamae naka ega awai hita dewadewaya ma ginouli wouhi hi deedehi ma hi ibaabaniyehi.) ");
INSERT INTO tbo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo Aliyopago tu’mboinahi u tipolihi i towolo ma i pa, ‘Mi Ateni, ami dewa atapuhi ugolihi ma a gagalemi, naka ami ani witumagana tapuna po tapuna hi maga duma. ");
INSERT INTO tbo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Matababana ami meyagai a yayahi po a nae ma ani tapalolo dobuhi a gagalehi po ani’mbenena patahi ugolihi geka bahana a tuhagaya, i pa, “Yaubada ega tata hanapugeya a pata.” Ugolinei Yaubadana tauna o wotalagiyeya ma ega ota hanapugeya tauna a deedeya ugolimi. ");
INSERT INTO tbo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","‘Yaubadana hipuli tu dewana po ginouli atapuhi ugolina he mamae tu dewahi, yaka naka tauna yada ma hipuli Guyouna, naka numa tapalolo lawa hi dewadewahi ega u hinehi ita mamae. ");
INSERT INTO tbo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma gasi lawa nimatiyei ginouli ta iwawalihi ega emoemotana tan’ombeneneya ugolina babana tauna ega dayadayabu. Tauna yautu po luyagohana po ginouli atapuhi lawa e weleweleta. ");
INSERT INTO tbo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hipuli tupo wohepali u hinena Yaubada lawa i wiwawalita po ta mamae naka lawa emosi ugolinei ta nei. Tauna tuawana ata houga amaka i bahehi po ata ani mae sigasiga dumahi i bahehi. ");
INSERT INTO tbo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Geka i dewadewaya babana ipa ta bibiheya ma ta iletaya ipa ta tuhagaya. Matababana Yaubada a mawa ega ita dao. ");
INSERT INTO tbo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mei lawa gehouna i baheya i pa, “Yaubada tauna a manini u hinena ta mamae po ta idagudagu po ta lauyagohana.” Mei ami tu wipakulo hi bahebaheya hi pa, “Tauta gasi tauna natunatuna.” ");
INSERT INTO tbo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","‘Yaubada natunatuna tauta ugolinei ega ipa Yaubada galenana ta nugonugotuhuya mei talaoloto lawa hai winugonugotuhugei he laukidihi. Gole bo siluba bo gaima ugolinei hi gilugilumihi tauhi ega mei Yaubada. ");
INSERT INTO tbo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Winugoneina hougahi ugolihi Yaubada ega lawa wimeihana ita genogeya. Ma amalai lawa ataputa e palipaliweleta i pa, “Ami dewa apapoehi ona palihalehi.” ");
INSERT INTO tbo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Matababana iyeta i bahebaheya ugolina lawa i inagani apo dewa dumadumalunei lawa ataputa ina libahibahita. A baha limoinana lawa ataputa ugolita naka lawana i inagani amaka hilage ugolinei i witowolo meya.’ ");
INSERT INTO tbo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hougana Paulo a baha towolo meme ubeina hi noonoli po lawa gehouhi hi’mpalihibahiba ma gehouhi hi pa, ‘Nugonugoiyai apo una wibaabani meme geka bahahi ubeihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ega yaka Paulo omboinana i nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tamogi lawa gehouhi hi latuya po hi witumagana ma u hayahi naka lawa gowana Diyonisi, tauna Aliyopago taniwagana gehouna. Ma gasi u hayahi naka wawine gowana Damalisi po gasi lawa gehouhi hi witumagana. ");
INSERT INTO tbo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paulo a baha u mulina Ateni i nehaleya po i nae u Kolinito. ");
INSERT INTO tbo_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Noka hosi lawa Yudeyagei gowana Akwila, Ponita u meyageina hi guniguni i tuhagaya. Tauna amalai hotana agona gowana Pilisila mitehi Italigei hi nei. Hai nei matababana Itali hai taniwaga gowana Kilodiyasi i baha i pa, Yudeya lawahi Loma hina nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo i nae po i galehi po mitehi hi mae, babana tauna po tauhi hai mone tahayana naka palai hi yamdewa. ");
INSERT INTO tbo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Dalabu magamaga hau numa dalabu mi Yudeya po mi Giliki mitehi hi igamogahigahi. Ma i ileta ipa nugonugohi ina waya. ");
INSERT INTO tbo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Hougana Sailasi ma Timoti Masedoniyagei hi laugeletai naka Paulo a bagibagi palai didinana i nehaleya ma a houga luguguya ugolina i hahaleya. Ma mi Yudeya i palipaliwelena imahiyehi naka Yesu tauna Besinana lawana. ");
INSERT INTO tbo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ma hi bahabaha guduguduya po hi iapapoeya naka a luilui dubudubuna i lihooholi ipa hai apapoe ina wiatatiyehi. Ma i baha nae ugolihi i pa, ‘Inapa ona lugowademi, yaka taumi tuawami apo gouna ona waya. Tau ega u gou. Yaka amalai i wawala po i nenae naka apo a nenae tauhi ega mi Yudeya ugolihi.’ ");
INSERT INTO tbo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ugolinei mi Yudeya hai numa dalabu i nehaleya po i nae lawa gowana Sisiyasi Yusito, Yaubada tu wotalagiyena a numa ugolina. Lawana a numa naka mi Yudeya hai numa dalabu u liyaliyana. ");
INSERT INTO tbo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mi Yudeya hai taniwaga gehouna gowana Kilisipa Guyau i witumaganeya, tauna po a numahine lawahi atapuhi. Ma mi Kolinito magomagouhi Paulo a baha hi noonoli naka hi witumagana po bapatiso hi waya. ");
INSERT INTO tbo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Upom emosi Paulo i enogagalena po Guyau i bahabaha nae Paulona ugolina i pa, ‘Ega lawa una matomatoutehi. Tamogi una ibaabani ma ega una wohouna, ");
INSERT INTO tbo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","matababana tau tam mitem. Ma ega emoemotana po iyai ina wihiniwiyuwam babana geka meyageina u hinena u lawa hi maga.’ ");
INSERT INTO tbo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ega yaka Paulo noka hosi i mae bolima emosi ma tupona, Yaubada a baha lawa i iatatiyehi. ");
INSERT INTO tbo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tamogi hougana Galiyo i taniwaga u Giliki naka mi Yudeya lawahi hi’mtuboina ma Paulo hi numa panipani po hi niyeya hau luhetala. ");
INSERT INTO tbo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ma Galiyo ugolina hi pa, ‘Geka lawana lawa nugonugohi e talatalahi ipa Yaubada hina wotalagiyeya. Ma nanakahi naka lugagayo e tutulagoni.’ ");
INSERT INTO tbo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo gamona i tatagi po ipa ina baha ma Galiyo i baha nae mi Yudeya ugolihi i pa, ‘Itapa geka lawana powa bo apapoe baneina ita dewaya apo nanaka u matababana ma upuwe ita hegoemi. ");
INSERT INTO tbo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ma geka wigamobahabahana naka baha po gowa po ami lugagayo ubeihi. Ugolinei ma taumi tuawami ona lidumaluya. Apega geka ginoulihi ugolihi a wituluhetala.’ ");
INSERT INTO tbo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ma ega yaka i wiyagahi po ani luhetala meyageina hi nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Atapuhi numa dalabu badana gowana Sositene hi womomohi ani luhetala u matetana ma hi wilawi. Tamogi Galiyo geka dewana ugolina ega ita geno. ");
INSERT INTO tbo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo u Kolinito i mamae naka iyeta i maga duma, ma apoma tu witumagana i nehalehi po Pilisila ma Akwila mitehi hi’mkuka po Siliya ubeina hi nae. Yohola ega hita gelu ma Yaubada u matana i wigwala u Kenekeleya ma unununa hi gali. ");
INSERT INTO tbo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ma u Kenekeleya hi gelu po hi nae u Epeso po noka hosi Pilisila ma Akwila i tuhounihi. Ma tuawana i lui hau numa dalabu po mi Yudeya lawahi mitehi hi wibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Hi lupaliyeya ipa mitehi hina meidaodao ma i luhinigigai. ");
INSERT INTO tbo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tamogi i nenae ma i paliwelehi i pa, ‘Inapa Yaubada a nugotuhu yaka apo a gunawileu ugolimi.’ Ega yaka u Epeso ma i’mkuka po i nae. ");
INSERT INTO tbo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Hougana u Sisaliya i laugeleta naka i nae u Yelusalem po tu witumagana lawahi i mamalihi ma apoma i hopu u Anitiyoka. ");
INSERT INTO tbo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Noka hosi houga kukuna i haleya ma apoma Galatiya po Piligiya tupohi i yayahihi. Tu wimulitago atapuhi i towolo kadidilihi. ");
INSERT INTO tbo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lawa Yudeyagei ma a meyagai Alesanila gowana Apolo i nae u Epeso. Tauna lawa bahabahana po Yaubada a Buka i hanapugena dumaya. ");
INSERT INTO tbo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Wiatatiyana Guyau a Tahaya ugolina i waya po i palihalena dumaya po Yesu ubeina i iatatiyanehi po i bahebahehi naka i laidumaluhi. Tamogi Yoni a wibapatiso tuawana i hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mi Yudeya hai u numa dalabu i wiwawala po i ibaabani kadidili ma hougana Pilisila ma Akwila hi noonoli po hi weluwaya. Hi weluwaya po hi niyeya hai numa ugolina apoma Yaubada a Tahaya hi dede idumaluya ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo i inugonugotuhu ipa ina damana u Giliki, yaka tu witumagana u Epeso hi haguya po hi’mgiluma nae tu wimulitago u Giliki ugolihi. Hi paliwelehi ipa Apolo hina kaoheya ma hina weluwaya. Hougana i laugeleta naka Yaubada a lunugotootogo galena itetenagei ma lawa hi itumagana naka ugolihi i wihaguhagu duma. ");
INSERT INTO tbo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Matababana mi Yudeya lawahi mitehi hi laugamobagibagi ma hai baha i ununihi, bolu omboinahi u hinehi, po Yesu tauna Besinana lawana naka Yaubada a Buka ugolinei i laimoineya. ");
INSERT INTO tbo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo u Kolinito i mamae naka Giliki tupona ma Paulo Piligiya tupona i nehaleya po meyagai atapuhi i weluyayahihi po i hopu u niha po u Epeso i geleta. Noka hosi tu wimulitago i tuhagahi. ");
INSERT INTO tbo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ma i lubayadehi i pa, ‘O itumagana naka Alugo Woiyawa o tuhagaya bo eega?’ Ma hi wimeiha hi pa, ‘Yohola ega tota nonoli naka Alugo Woiyawa e mamae.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ega yaka Paulo i lubayadehi i pa, ‘Bapatiso waigohina o waya?’ Ma hi pa, ‘Yoni a bapatiso to waya.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo i pa, ‘Yoni a bapatiso naka iyawoi hai apapoe ugolihi ma hi nugonugobui naka ubeina ma i ibapatiso. Ma lawa i paliwelehi i pa mulinei lawa i nenei naka ugolina hina itumagana. Lawana naka tauna Yesu.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Geka bahana hi noonoli po Guyau Yesu gowanei bapatiso hi waya. ");
INSERT INTO tbo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ma hougana Paulo nimana i huhounihi ugolihi naka Alugo Woiyawa i nei ugolihi po pona tapuhigei hi ibaabani ma gasi baha piko bahana hi ibaabaniyeya. ");
INSERT INTO tbo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tauhi magouhi mei 12. ");
INSERT INTO tbo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Geka pite Paulo i wobagibagi wamahiya tonuga u hinehi. Houga daodaona i nae po mi Yudeya hai u numa dalabu i bahabaha kadidili po i igamogahigahi po Yaubada anani taniwaga ubeina lawa nugonugohi i talatalahi. ");
INSERT INTO tbo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tamogi gehouhi hi nugokapala po ega hita witumagana ma Guyau a Tahaya hi iapapoeya. Ega yaka Paulo tu wimulitago i tamihi po mitehi ma lawahi hi nehalehi. Ma iyeta emosi po emosi tu wiatatiyana gowana Tilana anani wiatatiyana numana ugolina i ibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Geka dewana i nenae naka bolima luwaga. Ugolinei ma lawa atapuhi u Asiya tu mae Guyau a baha hi nonoli, mi Yudeya po gasi ega mi Yudeya. ");
INSERT INTO tbo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yaubada Paulo i dewaya po nimanei manini galenahi tapuhi po tapuhi i dewadewahi. ");
INSERT INTO tbo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ugolinei lawa hai tepa hamahamaga po hai luilui Paulo i wodadanihi ma hi winihi po hi niniyehi tu tootogo ugolihi, naka hai totogo hi kokoe po alugo apapoehi hi nehalehi. ");
INSERT INTO tbo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Lawa gehouhi tauhi mi Yudeya houga magomagouna hi kadakadau ma alugo apapoena hi iyagahi ma hi nei po ipa Guyau Yesu gowanei alugo apapoena hina wiyagaya. Yaka alugona ugolina hi pa, ‘Paulo Yesu e guuguyeya gowanei a paliwelem una hopu po una nae.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Geka dewana mi Yudeya hai tu witalaguyaba badana natunatuna ololotohi magouhi 7 hi dewedeweya. ");
INSERT INTO tbo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma tamogi houga gehouna alugo apapoena ugolina hi bahabaha nae po i pa, ‘Yesu a hanapugeya po Paulo a hanapugeya ma taumi iyawoi?’ ");
INSERT INTO tbo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Lawana ugolina geka alugo apapoena i mamae naka i wotowolo po i wilawihi po kelo i welehi ma hai kaleko i loolohi po ani kowakowahi awa hi lupa hopu po hi lowo po hi nae. ");
INSERT INTO tbo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mi Yudeya po tauhi ega mi Yudeya atapuhi u Epeso tu mae awai i waawala tuwegana hi noonoli po hi matouta. Ma Guyau Yesu gowana hi wiyateyate dumaya. ");
INSERT INTO tbo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tu witumagana boluhi hi nei po bolu u matahi hai apapoe hi hoena geletehi. ");
INSERT INTO tbo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tu balabalau boluhi hai buka hi hihiwa mai po bolu u matahi ma hi’mapugehi. Ma bukahi mihahi hi lauemotehi a lata mei K50,000. ");
INSERT INTO tbo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Wipoya geka pite ugolinei ma Guyau a baha i gunanohaya po i nenae ma i kadikadidili. ");
INSERT INTO tbo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Geka dewahi u mulihi Paulo a wiwogatala ipa Masedoniya po Giliki tupohi ina yayahihi po ina nae Yelusalem. Ma i pa, ‘A nae Yelusalem u mulina u luhogala ipa Loma a galeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ega yaka a tu hagu luwaga, Timoti ma Elasita, i himilihi po hi nae u Masedoniya ma tauna Asiya u tupona i womaamae. ");
INSERT INTO tbo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Noka u hougana lawa hi wogalahi babana ega nugonugohi ipa Guyau a tahaya Paulo ina deedeya. ");
INSERT INTO tbo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ma lawa gehouna gowana Demitiliya a bagibagi numinumi namanamalihi i yamdewa. Geka ginoulihi i dewadewahi talaoloto wawinena gowana Atemisi ubeina naka mone baneina i tutuhagaya a tu bagibagi ubeihi. ");
INSERT INTO tbo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tauna a tu bagibagi atapuhi po lawa gehouhi hai bagibagi mei tauhi i otugehi ma i pa, ‘Babada, o hanapugena dumaya naka geka bagibagina ugolina ta igapola. ");
INSERT INTO tbo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Amaka o galeya po o hanapugeya naka geka lawana Paulo awai e dewadewahi. Tauna i pa talaoloto lawa nimahigei he dewadewahi naka ega hai wipoya. Ma lawa boluhi i winugowinihi po he iponawogogeya. Ega Epeso lawahi tuawahi ma Asiya tupona atapuna. ");
INSERT INTO tbo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ugolinei ipa ta lowo duma babana apo geka ata bagibagina gowana ina apapoe. Ma gasi ega ata bagibagi gowana tuawana, ma ipa ta lowo duma babana apo ata talaoloto wawinena gegena gowana Atemisi a numa dalabu lawa ega hina iyateyateya. Geka ata talaoloto wawinena Asiya tupona atapuna po hipuli atapuna he wotalagiyeya apo a lugae ina kokoe.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bolu geka bahahi hi noonolihi po uyohi i gigai ma hi wootuotu hi pa, ‘Atemisi Epesogei i gewahaga.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Geka wootuotuna i lata po i nae po meyagai atapuna i wihogoya. Ma tu wootuotuhi hi bulibulili ani’mboina numana ugolina naka Gayasi ma Alisitaka hi titeinihi ma hi lui ani’mboina u gali hinena. Geka lawahi luwaga naka mi Masedoniya Paulo mitehi hi kadakadau. ");
INSERT INTO tbo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo i luhogaleya ipa ina lui omboina u hinena, ma tu wimulitago hi guduguduya ");
INSERT INTO tbo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ma gasi meyageina tanitaniwagana gehouhi naka Paulo a lawa yaka a baha hi himili po hi lupaliyeya hi pa ega ina nenae ani’mboina u gali hinena. ");
INSERT INTO tbo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tu wootuotuhi gehouhi ginouli tapuna hi woototugeya ma gehouhi ginouli tapuna hi woototugeya. Matababana lawa boluhi hi luilui naka hi winugoneina po ega hita hanapugeya awai binei hi lui. ");
INSERT INTO tbo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Lawa gehouhi hi pa Alesana tauna wogalahina ita wiwawali babana mi Yudeya hi baha po i gae bolu u matahi. Ma Alesana nimana i wohepahi po i’mtalagaagala ipa hina todi ma ina paliwelehi naka mi Yudeya ega hina igouhi. ");
INSERT INTO tbo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tamogi Alesana hi gagalena tuhagaya tauna lawa Yudeyagei ugolinei kabudala gaogaona luwaga u hinena hi ototu gogona hi pa, ‘Atemisi Epesogei i gewahaga.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Apoma meyageina tanitaniwagana hai tu’mgiluma lawahi i litodihi ma i pa, ‘U lawa mi Epeso, lawa ataputa ta hanapugeya Epeso meyageina naka Atemisi gegewahagana a numa dalabu tu galena itetena ma gasi gaima yadei i pipeu hopu mai naka tauna tu galena itetena. ");
INSERT INTO tbo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Apega iyai geka ginoulihi ina bowiyehi. Ugolinei ma ipa ona todi ma ega ona dewadewa buubuuwa. ");
INSERT INTO tbo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Geka lawahi o neneihi mai naka ega awai hita daneneya ata numa dalabu ugolina po ega ata talaoloto wawinena hita paliguyoguyougeya. ");
INSERT INTO tbo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ugolinei ma inapa Dimitiliya a tu bagibagi lawa gehouna hina igouya yaka ani luhetala he mamae po tanitaniwaga he mamae. Emoemotana noka hosi hina igou mehi. ");
INSERT INTO tbo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ma tamogi inapa nugonugomi ginouli gehouhi ona wibaabaniyehi yaka apo meyagai lawahi hai omboina ugolina lugagayogei hina lidumalu. ");
INSERT INTO tbo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ma ipa ta nugomatouta babana amalai awai i waawala naka apo wogalahi gouna ta waya. Matababana ega emoemotana baha awai dewadewana ta baheya amalai dewana i waawala ubeina.’ ");
INSERT INTO tbo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Geka a bahana u mulina lawahi boluhi i baha po hi’mnoha. ");
INSERT INTO tbo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wogalahina i yababa po u mulina Paulo tu wimulitago i boinihi po baha winugokadidili i welehi ma i mamalihi. Ma apoma i gelu po i damana u Masedoniya. ");
INSERT INTO tbo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Masedoniya meyageina magomagouna i yayahi po i nenae ma lawa baha winugokadidili i welewelehi ma i nae po Giliki anani taniwaga ugolina i geleta. ");
INSERT INTO tbo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Noka hosi wamahiya tonuga i mamae. I wononogo ipa Siliya ubeina in’omkuka ma i tuhagaya mi Yudeya hi wogatala ipa hina uni. Ega yaka i gunawileya po Masedoniyagei i nae. ");
INSERT INTO tbo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pilasi natuna Sopata Beleyagei po mi Tesalonika luwaga, Alisitaka ma Sekanasi, ma Gayasi Debigei po Timoti ma Tikikasi po Tolopima Asiya tuponanei, geka tauhi atapuhi Paulo mitehi hi nae. ");
INSERT INTO tbo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tauhi hi tahaya nae po u Tolowasi hi otonana. ");
INSERT INTO tbo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Palawa ega haahanana tolehana u mulina u Pilipai Paulo ma tau to’mkuka. Iyeta nimitutu hi kokoe ma apoma u Tolowasi to tuhagahi po noka hosi to mae dalabu gaogaona emosi. ");
INSERT INTO tbo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dalabu ugolina to’mboina gogona po to’mam ma Guyau nugohepana omgogonana to waya ma Paulo i wibaabani lawa ugolihi. I ibaabani naka i nae po upom tipolina i waya babana ipa apo malinatom po ina nae. ");
INSERT INTO tbo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Babanoyana u moyana to yamboina naka lampa i maga. ");
INSERT INTO tbo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hewali gehouna gowana Yutikasi naka hau malamala i duhuduhuna. Paulo a baha i daodao ma Yutikasi i yadayada po amaka i eno hilage. Ma i eneno po i pipeu naka numana hayana witonugana ugolina ma i hopu po hau hipuli i laihilageneya, po hilahilagena hi wohepaya. ");
INSERT INTO tbo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tamogi Paulo i hopu po i pegoya ma i pa, ‘Ega ona genogeno babana yohola e lauyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ma apoma Paulo i gememe po palawa i tomutomuya po hi am. Amna u mulina lawahi mitehi hi ibaabani ma i nae po i lauyayahi ma i nehalehi. ");
INSERT INTO tbo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Hewalina a luyagohanana ma hi weluwaya po hi nae hai u meyagai a nugodumolahi. ");
INSERT INTO tbo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","To tahaya nae hau wam po to’mkuka po to kwakwawila nae u Asosi ipa apo noka hosi Paulo to touli. Paulona tauna i baha po geka pite to dewaya babana tauna ipa apo tepanei ina tagonai. ");
INSERT INTO tbo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ma hougana u Asosi i tutuhagiyai po i gelu po to nae u Maitilini. ");
INSERT INTO tbo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Noka hosi ma to gelugelu naka to welumalatom po Kayosi bonabonana liyaliyanei to nae. Ma malitom po Samosi u bonabonana to gota ma malitom meme po to damana u Mailitasi. ");
INSERT INTO tbo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo a nugotuhu i dewaya po ipa Epeso ina weluwileya po ina nae. Ega nugonugona ipa u Asiya a kabudala ina haleya, matababana i bulibulili ipa u Yelusalem ina lugeleta, Penitikosi tolehana ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ega yaka u Mailitasi ma baha i himili po i nae u Epeso ipa tapalolo tanitaniwagahi hina ototoni. ");
INSERT INTO tbo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ma hougana hi laugeleta naka Paulo i baha ugolihi i pa, ‘Taumi o hanapugena dumaya iyowai u mae galenana u hayami iyeta magomagouna. Hougana a laugeleta wawalai Asiya u tupona po i nei po amalai naka o hanapugena dumaya. ");
INSERT INTO tbo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nugohopuhopugei po tougei u bagibagi a dewaya mei Guyau a tu bagibagi. Mi Yudeya lawahi hi wogatala ipa iyowai ma hina ihiniwiyuwau naka hiniwiyuwahi hinehiyei a wobagibagi. ");
INSERT INTO tbo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","O hanapugena dumaya naka ginouli awai apo ina haguhagumi ega ata nugoneya. Hougana bolu u matahi po numa emosi po emosi ugolina a lauguguya po a iatatiyana naka ginouli atapuna a paliwelemi. ");
INSERT INTO tbo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi Yudeya po tauhi ega mi Yudeya ugolihi a baha kadidili, a pa, “Omi apapoe ona palihalehi ma ona luhagawilemi po Guyau Yesu ona witumaganeya.” ");
INSERT INTO tbo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","‘Ma amalai Alugo Woiyawa a wiponawogogeya po a nenae u Yelusalem. Ma awai apo ugoliu ina waawala noka hosi naka ega ata hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tamogi meyagai emosi po emosi a luiluinihi ugolihi Alugo Woiyawa i paliweleu i pa, “Numa panipani po hiniwiyuwa he ototonim.” ");
INSERT INTO tbo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Hilage po noka ginoulihi atapuhi ega ata genogehi babana tau u luyagohana iyetana hipuli geka ugolina naka ega genona. Ma tamogi awai a genogenogeya naka ipa u bagibagi a luegahi Guyau Yesu i weleweleu naka lawa tuwega dewadewana a paliwelehi Yaubada a lunugotootogo binei. ");
INSERT INTO tbo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","‘Atapumi u hayami Yaubada anani taniwaga binei a lauguguya ma a nae ma a nei. Ma amalai a hanapugeya apega tepau ona galena meya. ");
INSERT INTO tbo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ugolinei ma amalai u baha kadidilina ugolimi, inapa u hayami iyai ina lugowadeya naka ega tau u gou. ");
INSERT INTO tbo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Matababana Yaubada a nugotuhu atapuna i weleweleu ega gehouna ata nugoneya ma amaka atapuna a paliwelemi. ");
INSERT INTO tbo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ona gagalena itetena memi po gasi tu witumagana atapuhi ona gagalena itetehi. Matababana Alugo Woiyawa i witowolimi po taumi tanitaniwaga. Yaubada Natuna a hilage talanei bolu i winihi po tauna galinei. Naka tauhi ona gagalena itetehi mei sipi tu galena itete. ");
INSERT INTO tbo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Matababana a hanapugeya naka gamogamo woyahiyahihi mei kedewa, sipi hai gawiya apo muliugei hina nei u hayami. Ma apeega iyai hina luemuli. ");
INSERT INTO tbo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ma houga e nenei u hayami apo lawa hina towolo po hina ikoyakoyama po hai luhogala ipa tu wimulitago hina wotagohi. ");
INSERT INTO tbo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ugolinei ma ipa matami hina kaya. A touwe ma bolima tonuga u hinena iyetei po uguwei a iatatiyemi naka ona nugonugotuhuya. ");
INSERT INTO tbo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","‘Ma amalai Yaubada u nimana po a lunugotootogo bahana ugolina a hounimi, tauna apo ina winugokadidilimi. Natunatuna waiwoiyawata ubeita ma kawaidewadewa i houni po e mamae apo ina welemi. ");
INSERT INTO tbo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Hougana u hayami ega iyai a mone po a kaleko dewadewahi ata galena luhogalehi. ");
INSERT INTO tbo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Taumi o hanapugeya naka geka nimouhigei a bagibagi po tau po u lawa uyogoiyai ani haguhi a winihi. ");
INSERT INTO tbo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ginouli atapuhi ugolihi amaka a wiatatiyemi naka ipa ta bagibagi po tu tapitapiya ta haguhi. Ma ta nugonugotuhuya naka Guyau Yesu geka pite i baha i pa, “Awai ta tutuhagaya kaohana i habulu ma ombenena kaohana i lata duma.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo geka a bahana u mulina babadahi mitehi itutuhi hi’mtutonetonena ma hi tapalolo. ");
INSERT INTO tbo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Atapuhi Paulona hi talaluluni po hi tutougeya po i kokoe ma hi mamali. ");
INSERT INTO tbo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","A baha ipa apega hina gagalena meya ugolina ma nugonugohi i wiyuwa duma. Ega yaka hi witulani po hi nae hau wam. ");
INSERT INTO tbo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ma hougana to mamalihi ma to nenehalehi naka to’mkuka po dumalu to damana Kosi bonabonana ugolina. Ma malitom po to nae Lodisi bonabonana ugolina po noka hosi ma to nae Patala meyageina ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","U Patala ma wam i nenae u Ponisiya to tuhagaya yaka to gelu damana ugolina po to nae. ");
INSERT INTO tbo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","To nei po Saipilasi bonabonana to galena niyeya ma wam hi buiya po to nae hau tupo yawana ma to gota Taya Siliya u tupona. Wamna ginouli i tutoulihi ipa noka hosi ina hiwogihi. ");
INSERT INTO tbo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ma noka hosi tu wimulitago gehouhi to tuhagahi po mitehi to mae dalabu gaogaona emosi. Alugo Woiyawa a litahatahayagei tu witumaganahi Paulo hi paliweleya hi pa ega ina nenae u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Noka hosi to mamae po i kokoe ma to nehalehi po to nae. To wotowolo hougana ugolina naka agagohi po natunatuhi mitehi hi weluwiniyai po to hopu meyageina u gadowana po noka hosi atapuiyai itutuiyei to’mtutonetonena hau bubu ma to tapalolo po i kokoe ");
INSERT INTO tbo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ma to wimaamala po hau wam to gelugelu ma hi gunawilehi hai yu meyagai. ");
INSERT INTO tbo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","U Taya ma to gelugelu naka u Tolemesi to gota po noka hosi tu wimulitago to mamalihi ma mitehi to mae iyeta emosi. ");
INSERT INTO tbo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ma malitom po to nehalehi po to nae u Sisaliya, po Pilipo a numa to luiya po mitehi to mae. Tauna a bagibagi tuwega dewadewana i guuguyeya. Lawa magouhi 7 u Yelusalem hi towolihi naka tauna gehouna. ");
INSERT INTO tbo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tauna natunatuna guguhinihi wohepali bahapiko bahana hi ibaabaniyeya. ");
INSERT INTO tbo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Noka hosi to mae iyeta wabihaga hota ma tu bahapiko gowana Agabasi Yudeyagei i hopu mai ");
INSERT INTO tbo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ugoliyai po Paulo a dagilolo i waya po aena po nimana i panipani meya ma i pa, ‘Alugo Woiyawa i bahebaheya geka pite i pa: Mi Yudeya lawahi u Yelusalem apo geka dagilolona taniwagana hina numa panipani mei a panipani meu pite; apoma tauhi ega mi Yudeya u nimahi hina houni.’ ");
INSERT INTO tbo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Geka bahahi to noonolihi po tiyai po noka dobuhi lawahi Paulo to talagagali to pa ega ina nenae u Yelusalem. ");
INSERT INTO tbo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tamogi i baha i buiya i pa, ‘Awai o dewadewaya? Po geka pite o tutou ma nugonugou e iyuwa. Tau a nonogo duma ipa u Yelusalem hina paniu ma gasi ipa Guyau Yesu binei a hilage.’ ");
INSERT INTO tbo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ega emoemotiyai ipa nugonugona to buiya yaka to pa, ‘Heki, Guyau tuawana a nugotuhugei ina nae.’ ");
INSERT INTO tbo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Noka hosi to womaamae kikeina ma i ginouli to wononogo ma to nehalehi po Yelusalem binei to nae. ");
INSERT INTO tbo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Tu wimulitago mi Sisaliya gehouhi mitehi to nae. Tauhi hi weluwiniyai po to nae Nasona Saipilasigei a numa ugolina ipa apo noka hosi to mae. Nasona tauna tu wimulitago tahatahayana u Saipilasi. ");
INSERT INTO tbo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hougana u Yelusalem to laugeleta naka tu wimulitago a kaohahi ma hi witutuhageiyai. ");
INSERT INTO tbo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Malitom po Paulo mitehi to nae Yamesa to galeya. Ma tanitaniwaga atapahi noka hosi hi’mboina po hi mamae. ");
INSERT INTO tbo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo i mamalihi po i kokoe. Ma a bagibagi ugolinei Yaubada ginouli emosi po emosi tauhi ega mi Yudeya u hayahi i dewadewahi naka atapuhi i dede pahi. ");
INSERT INTO tbo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tanitaniwagahi a baha hi noonoli po Yaubada hi wotalagiyeya. Ma apoma hi baha nae Paulo ugolina hi pa, ‘Walehiyai, u galeya Yudeya lawahi tausana wabihaga naka Guyau he itumaganeya. Ma tauhi gasi Mose ugolinei lugagayo i nenei naka yohola he wootagoya. ");
INSERT INTO tbo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Lawa gehouhi hi nei po hi igoum hi pa, tam mi Yudeya tauhi ega mi Yudeya hai meyagai ugolihi hi mamae, Mose a lugagayo uta iatatiyena powahi po ipa uta pa, “Mose a lugagayo ta palihaleya,” po uta paliwelehi uta pa, “Ega natunatuta hai wekiwekilala ta huhounihi. Ma gasi ega mi Yudeya ita mae odubohi ta meme tagohi.” ");
INSERT INTO tbo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","U laugeletai tuwegana apo hina nonoli. Ma apo awai ta dewaya? ");
INSERT INTO tbo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ugolinei ma awai to bahebaheya naka una dewa tagoya. Lawa wohepali ugoliyai amaka Yaubada ugolina hi wigwala. ");
INSERT INTO tbo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Geka lawahi una weluwinihi po ona nae po hina laiyeuyeu mehi naka tam mitehi. Ma una wimeiha po apo apalami hina galihalehi. Geka dewana ugolina ma apo lawa ubeim hi ibaabani hina kawaikoyakoyamehi. Ma apo hina pa tam gasi Mose a lugagayo e meme tagohi. ");
INSERT INTO tbo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tamogi tauhi ega mi Yudeya Guyau hi itumaganeya amaka hai baha to himili. Ma to paligaagalihi i wikaha ugolina naka aniani awai talaoloto hi yambenenehi ega hina anani. Muhala waitalana po gadouna he kikiki ega hina anani. Ma gasi to paligaagalihi ipa ega hina matamatamaga.’ ");
INSERT INTO tbo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Malitom ma Paulo lawahi wohepali i weluwinihi po mitehi hi liyeuyeu mehi. Ma numa dalabu baneina i luiya po lawa i paliwelehi apo iyeta awai liyeuyeumehi ina kokoe ma hai ani witalaguyaba hin’ombenenehi. ");
INSERT INTO tbo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Hi laiyeuyeu mehi naka iyeta magouhi 7, hougana geka iyetahi magouhi 7 mei hina kokoe ma mi Yudeya Asiya tuponanei hi nenei naka Paulo hi galeya hau numa dalabuna. Geka tauhi lawahi bolu hi lihunahi po Paulo hi womomohi, ");
INSERT INTO tbo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ma hi ototu hi pa, ‘I lawa mi Yudeya, ona haguiyai. Geka tauna lawana tupo atapuna e wiiwileya ma lawa e iatatiyehi i pa Yudeya lawahi Mose a lugagayo po geka numa dalabuna ega hina iponawogogeya. Ma amalai gasi tauhi ega mi Yudeya i weluwinihi po hi lui mai numa dalabu baneina ugolina, po geka dobu gegena hi wigobugobugeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Geka bahahi hi bahebahehi naka matababana Paulo ma Tolopima Epesogei hi gagalehi ma hi gae ma hi hopu meyageina ugolina. Ma hai nugotuhu hi pa Paulo Tolopimana ita weluwaya po hita lui numa dalabuna baneina u hinena.) ");
INSERT INTO tbo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Wogalahi i geleta u meyageina po lawa hi wibulibulili nae po hau numa dalabuna Paulo hi teina hopuneya ma mateta hi guduhi. ");
INSERT INTO tbo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Lawahi boluhi hi ileta ipa Paulo hina uni ma baha hi himili mi Loma hai tu wigawiya hai taniwaga ugolina hi pa mi Yelusalem atapuhi he itona. ");
INSERT INTO tbo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Taniwagana mala emosi ma a tu wigawiya po tu galena itete i tamihi po hi hopu lawahi boluhi ugolihi. Hougana lawahi tu wigawiyahi po hai taniwaga hi gagaleya ma Paulo hi wilawi woloeya. ");
INSERT INTO tbo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Apoma taniwagana i nae po Paulo ugolina ma i baha po hi womomohi ma gulawa pawapawasi luwaga ugolinei nimana hi panihi. Ma bolu i lubayadehi i pa, ‘Geka lawana iyai? Ma powa awai i dewaya?’ ");
INSERT INTO tbo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Boluna u hinena hai wibaabani gololohi tapuna po tapuna ega ginouli emosi ugolinei hita wigouya. Nugolagalaga i lata duma u hayahi po taniwagana awai moinana i waawala naka ega ita hanapugeya. Ega yaka i baha po a hewahewali ipa Paulona hina giyeya tu wigawiya hai ani mae ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo hi gigiyeya naka hau tete ma hi awali babana bolu mulinei hi nenei uyohi i gigai duma ipa hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ma gasi hi awawali babana lawahi hi ototu hi pa, ‘Ta uni!’ ");
INSERT INTO tbo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tu wigawiyahi mei hai ani mae hina luiluiya ma Paulo i baha nae taniwagana ugolina i pa, ‘Emoemotana apo ginouli gehouna ugolim ata baheya.’ Ma Paulo pona Gilikigei i baha yaka taniwagana i lubayada i pa, ‘Pona Giliki u hanapugeya? ");
INSERT INTO tbo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nugote tam lawa Isipitagei yaka lolowa witona u laiwawali? Ma tu’munugo tausana wohepali ami witona ugolina u tahaehi po mitehi o nae hau balabala yabayababa?’ ");
INSERT INTO tbo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo taniwagana a baha i wimiheya i pa, ‘Tau lawa Yudeyagei. Silisiya u tupona dobu gowana Tasasi ugolina hi guniu. Noka meyageina u Silisiya i geduma ma tau meyageina lawana. A mamala dumam ma una palihaleu po lawa ugolihi a wibaabani.’ ");
INSERT INTO tbo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Taniwagana Paulo i palihaleya yaka hau tete i towolo ma nimanei lawa i litodihi. Hougana lawahi hi wogenuwana naka Paulo Yudeya ponahigei i baha nae ugolihi i pa: ");
INSERT INTO tbo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","‘Walewalehiu po amamau, ona lautanigana ma u matami tau biugei u baha a baheya.’ ");
INSERT INTO tbo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lawahi hi lautanigana ma Paulo mi Yudeya ponahigei i ibaabani yaka hi genuwana imahi. Ma i wibaabani i pa, ");
INSERT INTO tbo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","‘Tau lawa Yudeyagei. Ma Silisiya u tupona meyagai gowana Tasasi ugolina hi guniu, ma tamogi u Yelusalem a lata, po hougana a ihewali Gameliyela ugolina a wisikulu po googata hai lugagayo ugolinei hi wiatatiyeu. Ma a wileta duma po Yaubada ugolina a palipalihalena meu mei gasi atapumi amalai. ");
INSERT INTO tbo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Guyau Yesu tu wotagona a ihiniwiyuwahi po hi hilahilage. Ma ololoto po wiwine a womomohihi po hau numa panipani a hauluiyehi. ");
INSERT INTO tbo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Tu witalaguyaba hai taniwaga po tu wikaha babadahi emoemotana awai a bahebaheya hina wikawamoineya. Tauhi mi Yudeya lawahi u Damaseko hi mamae hai pepa hi gilumihi po ipa a niyehi. Ega yaka a nenae noka hosi po Guyau Yesu tu wotagona ipa gulawa pawapawasigei a panipanihi po a neihi mai u Yelusalem po hina wimihehi. ");
INSERT INTO tbo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","‘Ma a nenae po iyeta bolinai hougana Damaseko a tutuliyaliyani ma mala emosi ma yayata baneina yadei i hopu mai po i yayata wiiwileu. ");
INSERT INTO tbo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ma a peu hopu hau hipuli ma lawa ponana a noonoli ma i pa, “Saulo! Saulo! Awai binei e ihiniwiyuwau?” ");
INSERT INTO tbo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘Apoma tau a lubayada a pa, “Guyau, tam iyai?” ‘Ma lawana i pa, “Tau Yesu Nasaletagei ma houga daodaona e ihiniwiyuwau.” ");
INSERT INTO tbo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Lawa mitehi to nenae naka yayatana hi galeya ma tamogi Yesu i bahabaha mai ugoliu anona ega hita hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","‘Ega yaka a lubayada a pa, “Guyau, apo awai a dewaya?” ‘Ma Guyau ugoliu i baha mai i pa, “Una wotowolo po Damaseko una luiya po noka hosi tahaya bimgei Yaubada i woononogogeya apo hina paliwelem.” ");
INSERT INTO tbo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Noka hougana yayatana a kadidili ugolina ma matau i apapoe. Ega yaka tu witulaniu hi lunimaniu po Damaseko to luiya. ");
INSERT INTO tbo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","‘Noka hosi Yaubada tu wotalagiyena po Mose a lugagayo tu wotagona gowana Ananaya i mamae, ma Yudeya lawahi u Damaseko tu mae hi iyateyateya. ");
INSERT INTO tbo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tauna i nei po u liyaliyau i towolo ma i pa, “Walehiu Saulo, una galena meme.” Noka kabudalana ugolina a galena meme po Ananaya a galeya. ");
INSERT INTO tbo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","‘Ma ugoliu i baha mai i pa, “Googata hai Yaubada i winaganim po ipa a nugotuhu una hanapugeya ugolinei a Tu bagibagi dumadumaluna Yesu amaka u galeya, po ponana amaka u nonoli, ");
INSERT INTO tbo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","matababana tam apo a tu baha moina lawa atapuhi ugolihi awai u gagaleya po awai u noonoli binei. ");
INSERT INTO tbo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma geka kabudalana awai e ototoni? Una towolo po bapatiso una waya ma Guyau gowanei una lupali po am apapoe ina oga halehi. ");
INSERT INTO tbo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","‘Ega yaka a gunawilena meu Yelusalem po numa dalabu baneina u hinena a tapatapalolo po enogagalena a gagaleya. ");
INSERT INTO tbo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Enogalena u hinena Guyau a gagaleya ma i pa, “Una bulili yagiyagina po geka dobuna una nehaleya babana tau biugei ma am wibaabani apo hina wihinigigiyeya.” ");
INSERT INTO tbo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","‘Apoma a pa, “Guyau hi hanapugena dumaya naka tau a nae po numa dalabu atapuhi ugolihi tu witumaganem a panipanihi po a ilawihi. ");
INSERT INTO tbo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Po gasi am tu baha Sitibeni hougana hi ununi naka tau u liyaliyahi a mamae. Omunugona a kawaidewedeweya po tu’munugohi hai kaleko a tamihi.” ");
INSERT INTO tbo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","‘Ma Guyau i baha mai ugoliu i pa, “Yelusalem una nehaleya po una nae tauhi ega mi Yudeya ugolihi, po tam hai tu wituwetuwega.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lawa hi genuwana ma hi lautanigana naka i nei po tauhi ega mi Yudeya bahana ugolina ma hi wootuotugena meya hi pa, ‘Ta uni haleya. Lawa geka pite ega ita dumalu ipa ina lauyagohana.’ ");
INSERT INTO tbo_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ma uyohi i gigai po hi iototu ma hai luilui hi loolohi ma aehigei hipuli hi tutugoiya. ");
INSERT INTO tbo_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yohola hi lauuyogigai ma tu wigawiyahi hai taniwaga a hewahewali i baha po Paulo hi awala niyeya hai ani mae ugolina. Ma i baha po hi kodikodili ipa ina bahena meya awai binei ma mi Yudeya hi luuyogigai ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ega yaka aena ma nimana hi panipanihi po i kokoe. Ma ipa hina wilawi. Ma Paulo gawiya kapenana ugolina i baha nae i pa, ‘Tau lawa Lomagei babana u Tasasi hi guniu Loma a u ani taniwaga ma ata lugagayo i baheya ipa luhetala ina tahaya ma taumi ipa ona wilawiu?’ ");
INSERT INTO tbo_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Hougana gawiya kapenana geka bahana i noonoli po i nae hai taniwaga ugolina i lubayada i pa, ‘Awai ipa una dewaya noka lawana ugolina? Tauna lawa Lomagei.’ ");
INSERT INTO tbo_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ega yaka hai taniwagana i nae po Paulo i lubayadeya i pa, ‘Moina tam Loma lawana?’ Ma Paulo i pa, ‘Ee, tau lawa Lomagei.’ ");
INSERT INTO tbo_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Apoma taniwagana i pa, ‘Tau ega mi Loma natuhi ma mone baneina Loma tanitaniwagahi a welehi ma a lui u hinehi.’ Ma Paulo i pa, ‘Tau mi Loma natuhi babana u Tasasi hi guniu.’ ");
INSERT INTO tbo_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ega yaka tu wilawina mala emosi ma Paulona hi nehaleya. Ma tu wigawiyahi hai taniwaga i gagalena tuhaga po i matouta duma, matababana lugagayo i tulagoni po Paulo Loma lawana ma i baha po aena po nimana hi panipanihi. ");
INSERT INTO tbo_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tu wigawiyahi hai taniwaga a nugotuhu baneina ipa ina hanapugeya awai binei mi Yudeya Paulo hi igouya. Yaka malitom ma i baha po tu witalaguyaba babadahi po tu wiwogatala atapuhi hi’mboina gogona. Apoma Paulo hau numa panipani i wihaleya po niyeya po u naohi i witowoli. ");
INSERT INTO tbo_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo i todi ma tu wiwogatalahi i gagalehi po i pa, ‘Walewalehiu, odubona ma i nei po geka iyetana ugolina naka u luyagohana Yaubada u matana ega wigougou u nugonugou ita mamae.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tu witalaguyaba hai taniwaga gowana Ananaya i baha po lawa Paulo u liyaliyana hi towotowolo Paulona u gamona hi lougo. ");
INSERT INTO tbo_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Apoma Paulo i baha Ananaya ugolina i pa, ‘Tam nonola luwaga, Yaubada apo ina launim. Naka hosi u duhuna ma lugagayogei ipa una luhetaleu ma tamogi lawa u baha po hi laulauniu naka lugagayo u tulagoni.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ma lawa Paulo u liyaliyana hi towotowolo naka hi baha nae Paulona ugolina hi pa, ‘Tam Yaubada a tu witalaguyaba hai taniwaga e palipaliguyoguyougeya!’ ");
INSERT INTO tbo_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ega yaka Paulo i baha i pa, ‘Walewalehiu, ega ata hanapugeya naka tauna tu witalaguyaba hai taniwaga. Itapa ata hanapugeya apega geka pite ata baha, babana Buka odubona ugolina geka pite hi gilumi hi pa, “Am lawa hai taniwaga ega una palipalihopuhopuneya.” ’ ");
INSERT INTO tbo_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo i hanapugeya naka tu wiwogatalahi gehouhi Sadusi ma gehouhi Palisi. Hougana geka boluhi luwaga i gagalena tuhagahi po tu wiwogatala u matahi i wootu i pa, ‘Walewalehiu, tau Palisi natuhi, yaka tau Palisi. Geka a lauhetala babana u witumagana i kadidili po a iotonana apo lawa hilahilagehi hina towolo meme.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paulo geka bahana i bahebaheya po Sadusi ma Palisi hi tugudu po hi igamogahigahi po hi wikahakaha. ");
INSERT INTO tbo_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Hai wikahakaha matababana Sadusi hai bolu hi pa lawa apega hilage ugolinei hina towolo meme. Ma gasi hi pa Yaubada ega a tu winoyanoya po gasi ega alugo. Ma Palisi hai bolu geka ginoulihi tonuga naka ugolihi hi itumagana.) ");
INSERT INTO tbo_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Hi ikahakaha ugolina ma hi lahalaha mehi. Ma lugagayo tanitaniwagahi gehouhi Palisi boluna ugolina hi towolo po hi baha kadidili hi pa, ‘Geka lawana ega a apapoe awai tota tuhagaya. Nugote alugo bo Yaubada a tu winoyanoya moina Paulo ugolina i baha nae.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hai wigamogahigahi i lata po i nenae ma tu wigawiya hai taniwaga i matouta duma naka Paulo apo hina lihilageni. Yaka a tu wigawiya i baha po hi hopu ipa Paulo hina wihaleya tu wiwogatala ugolihi po hai ani mae ugolina hina houni. ");
INSERT INTO tbo_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Upomgei Guyau Paulo u liyaliyana i towolo ma i pa, ‘Una nugokadidili. Geka u Yelusalem amaka biugei u baha ma apo yohola u Loma gasi una wibaabaniyeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Malitom ma mi Yudeya gehouhi hi wiwogatala po hi wigwala hi pa, apega hina am bo hina uma a sigana Paulo hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Lawa magouhi 40 i lagoni naka tauhi geka wogana hi talaya. ");
INSERT INTO tbo_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Apoma hi nae po tu witalaguyaba babadahi po mi Yudeya hai tanitaniwaga ugolihi hi pa, ‘Amaka to wigwala kadidili apega awai to ani dadani a sigana Paulo to uni. ");
INSERT INTO tbo_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ugolinei ma taumi tu wiwogatala mitehi baha ona himili po ina nae mi Loma hai tu wigawiya hai taniwaga ugolina po Paulo ina hopu neiyai ugolimi, ma ona witepa ona pa, “Paulo ipa to niyeya po to lubayabayadena imahiyeya.” Tamogi apo amaka tahaya u liyaliyana to wononogo po to lihilageni.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Tamogi wiwogatalana Paulo auna i nonoli yaka i nae po tu wigawiyahi hai ani mae i luiya po Paulona i paliweleya. ");
INSERT INTO tbo_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ma Paulona gawiya kapenana i paliweleya i pa, ‘Geka hewalina una niyeya ami taniwaga ugolina po baha gehouna ina paliweleya.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ega yaka kapenana hewalina i niyeya po hai taniwaga ugolina i pa, ‘Paulo tauna hau numa panipani i otugeu po a nae po i paliweleu po geka hewalina a neiyai ugolim. A neneiyai matababana ipa baha gehouna ina paliwelem.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ega yaka gawiya taniwagana hewalina i lunimani po hi nae po tuawahi ma i lubayadeya i pa, ‘Ginouli awai ipa una paliweleu?’ ");
INSERT INTO tbo_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ega yaka hewalina i pa, ‘Mi Yudeya gehouhi hi lueena ipa haumalatom hina lubayadem ma Paulo hina hopuneya tu wiwogatala ugolihi, ma apo Paulo lubayabayadana hina witepeya ma hina weluwaya. ");
INSERT INTO tbo_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Tamogi ega hai baha una noonoli babana lawa magouhi 40 i lagoni apo u tahaya hina megowada po Paulo hina ototoni. Ma atapuhi hi igwala hi pa apega hina am bo hina uma a sigana Paulo hina uni. Atapuhi hi nonogo po ipa hina dewaya ma tam am nugotuhu he iotonaneya.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Apoma gawiya taniwagana i pa, ‘U nei po u ibenabenama ega iyai una palipaliweleya.’ Ma hewalina i himili po i nae. ");
INSERT INTO tbo_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tu wigawiya hai taniwaga gawiya kapenahi luwaga i otugehi po i baha nae ugolihi i pa, ‘Tu wigawiya magouhi handele luwaga ma hosi tu geluhi magouhi 70, ma kwasikwasi daodaohigei tu witona magouhi handele luwaga ona wononogogehi po apo mitehi ona nae u Sisaliya. Ona wononogo po uguwei mei eno kabudalana ugolina apo ona wotowolo po ona nae. ");
INSERT INTO tbo_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ma hosi gehouhi ona wonogogehi po apo Paulo ina gelu. Ma ona galena iteteya po ona niyeya Taniwaga Pelikisi ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ega yaka taniwagana Pelikisi a pepa geka pite i gilumi i pa: ");
INSERT INTO tbo_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","‘Tau Kilodiyasi Lisiyasi. Tam Taniwaga baneim Pelikisi ugolim. Tinani baneina. ");
INSERT INTO tbo_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mi Yudeya geka lawana hi womomohi po amaka mei hina ununi. Ma a tuhagaya naka tauna Loma lawana yaka u tu wigawiya mitehi to nae po to haguya. ");
INSERT INTO tbo_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Awai binei ma hi igouya naka ipa a hanapugeya yaka a hopuneya lawa hai tu wiwogatala ugolihi. ");
INSERT INTO tbo_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ma a tuhagaya naka ega a powa awai po ipa ina hilage bo hau numa panipani to houni. Lawahi hi igouya naka tauhi tuawahi hai lugagayogei. ");
INSERT INTO tbo_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ega yaka mi Yudeya gehouhi hi iwogatala po ipa hina uni. Ma hougana hi palipaliweleu naka u nugotuhu a dewaya po a himihimiliyahi ugolim. Ma tu wigouna a paliwelehi po tam u matam hai wigou hina wogeletehi.’ ");
INSERT INTO tbo_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tu wigawiyahi baha hi wotagoya po Paulo hi weluwaya po noka uguwana hi nenae naka Anitipatila. ");
INSERT INTO tbo_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ma malitom po tu wigawiyahi aehigei hi nenae naka hi gunawilehi hai ani mae ugolina. Ma hosi tu gelugelu hi tuhalehi po ipa Paulo mitehi hina nae. ");
INSERT INTO tbo_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Paulo hi weluwaya po hi hopu u Sisaliya po pepana Taniwaga Pelikisi hi weleya ma Paulona hi wodamaneya ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pelikisi pepana i hiyawi po i kokoe ma Paulo i lubayadeya tauna tupo miyei lawana. Hougana i tuhagaya naka Paulo lawa Silisiyagei ");
INSERT INTO tbo_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","yaka i pa, ‘Tu wigoum hina lugeletai ma apoma am baha a nonoli.’ Ma apoma i baha po Heloda numa baneina i wogowogoya ugolina Paulo a tu galena itete mitehi hi hounihi. ");
INSERT INTO tbo_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Iyeta nimitutu hi kokoe ma tu witalaguyaba hai taniwaga gowana Ananaya po tanitaniwaga po tu luhetala gowana Tetalasi mitehi hi hopu u Sisaliya. Tauhi hi hopu mai po Taniwaga Pelikisi ugolina hi wogeletena mehi ipa apo Paulo hina wigouya. ");
INSERT INTO tbo_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tetalasi hi otugeya po geka pite Paulo i igouya i pa, ‘Pelikisi, tam taniwaga baneina. Am galena itete hanahanapu ugolinei nugodumolagei to mae po i nei houga i dao duma. Ata hipuli a dewadewa binei meimahi magomagouhi tam am hanapugei he dewadewahi. ");
INSERT INTO tbo_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Geka maehi tupo atapuna to kaohehi po to mamala dumam. ");
INSERT INTO tbo_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ega ipa am kabudala ugoliyai una hahaleya ma a lupaliyem ipa nugodewagei i baha kukuna una nonoli. ");
INSERT INTO tbo_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","‘Geka lawana to tuhagaya naka tauna lawa apapoe dumana. Hipuli tupo wohepali u hinena mi Yudeya u hayahi houga daodaona wogalahi e talatalaiwawali. Ma Yesu lawa Nasaletagei a bolu e itaniwageya ma e tahatahaehi. ");
INSERT INTO tbo_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tauna gasi i ileta ipa numa dalabu baneina u hinena tauhi ega mi Yudeya ina luiyehi ma to tuhagaya po i lugagayogei ipa to luhetaleya. ");
INSERT INTO tbo_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ma tu wigawiya hai taniwaga gowana Lisiyasi i nei po u nimiyai ma i haloiyai po i niyeya. ");
INSERT INTO tbo_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ma apoma i paliweliyai ipa Paulo tu wigouna hina nei ugolim. Inapa Paulo una lubayabayadeya apo ginouli atapuna una hanapugeya awai binei to igouya.’ ");
INSERT INTO tbo_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mi Yudeya Pelikisi u naona hi towotowolo po hi baha haguhagu hi pa, ‘Tetalasi ginouli atapuna i bahebaheya naka baha moina.’ ");
INSERT INTO tbo_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ega yaka taniwagana Pelikisi i baha po Paulo i ibaabani i pa, ‘A hanapugem tam geka tupohihi ugolihi u lauhetala naka bolima i maga duma, yaka a kaoha duma babana apo u matam biugei a wibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Inapa una wilulubayada apo lawa hina paliwelem naka tau gaogao emosi po tupona amaka hi kokoe a lugeleta Yelusalem po ipa Yaubada a wotalagiyeya. ");
INSERT INTO tbo_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ega iyai mitehi tota igamogahigahi ma mi Yudeya lawahi hita tuhagau. Ma numa dalabu baneina po muhomuhohi po Yelusalem u hinena ega lawa ata laiuyogigeinihi ma hita tuhagau. ");
INSERT INTO tbo_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Geka amalai hi igouwe naka ega emoemotana hina limoinehi. ");
INSERT INTO tbo_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ma geka a palipaliwelem, Yesu a tahaya tu wotagona tau yaka he ikawakoyakoyameu. Tamogi googiyai hai Yaubada a wootalagiyeya ma Mose a lugagayo a wootagoya ma tu bahapiko hai buka ugolina ginouli atapuhi hi gilugilumihi naka tau a itumaganehi. ");
INSERT INTO tbo_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma u winugonugotuhu lagona Yaubada ugolina mei geka tauhi lawahi, naka lawa atapuhi dewadewahi po apapoehi apo hilage ugolina hina towolo meme. ");
INSERT INTO tbo_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ugolinei houga daodaona a ileta ipa u winugonugotuhu Yaubada u matana po lawa u matahi ina dumadumalu. ");
INSERT INTO tbo_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","‘Yelusalem a nenehaleya naka bolima wabihaga. Ma a gunawileu noka hosi ipa i mone tu dayadayabu a welehi ma a witalaguyaba Yaubada ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Geka nugotuhuhi a dewadewahi ma numa dalabu baneina ugolina hi tuhagau. Liyeuyeu dewana a deweya po u mulina ma hi tuhagau. Noka hougana ega bolu tau mitehi po ega dewa yabayababa. ");
INSERT INTO tbo_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tamogi mi Yudeya Asiya tuponanei hi nenei naka noka hosi. Tauhi tamogi hitapa hai nugoapapoe ugoliu yaka hita nei po ugolim hita wigouwe. ");
INSERT INTO tbo_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Heki geka lawahi una baha po tu wiwogatala ugolihi a lauhetala ma u powa awai hi tutuhagaya hina paliwelem. ");
INSERT INTO tbo_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Tamogi moina geka ginoulina emosi tu wiwogatala u matahi ma a wootugeya po nugokahakaha a wiwawali a pa a itumagana lawa hilage ugolina ma apo hina towotowolo meme binei ma taumi o lauhetaleu.’ ");
INSERT INTO tbo_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Iyawoi Yesu a wiatatiyana lawa hi meme tagoya naka Pelikisi i hanapugena dumaya. Ugolinei ma luhetala i guduya ma i paliwelehi i pa, ‘Tu wigawiya hai taniwaga gowana Lisiyasi ina lugeletai apo ami luhetala a winugonugotuhugeya.’ ");
INSERT INTO tbo_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ma Pelikisi gawiya kapenana i paliweleya i pa, ‘Paulo ona galena iteteya, ma tamogi kikeina ona wohaleya po a luhogala awai yaka a lawa hina weleweleya.’ ");
INSERT INTO tbo_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Iyeta wabihaga hi kokoe ma u mulina Pelikisi agona Dusila mitehi hi nei, Dusila Yudeya wawinena. Ma Pelikisi Paulo a baha i himili po hi neiyai po witumagana Yesu Keliso ugolina binei i ibaabani ma hi lautanigana. ");
INSERT INTO tbo_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ma Paulo i baha po i nae po dewadumalu po upuhegoya po Yaubada a Libahibahi iyetana i deedeya naka Pelikisi i matouta. Ega yaka i pa, ‘Amaka ma una nae. Inapa u gaogao a tuhagaya yaka apo a otugena mem.’ ");
INSERT INTO tbo_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pelikisi a luhogala ipa apo Paulo mone ina weleya ugolinei houga magomagouna Paulo i otugeya po mitehi hi ibaabani. ");
INSERT INTO tbo_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bolima luwaga hi kokoe ma u mulina Posiya Petasi Pelikisi taniwaga ugolina i luhaleya. Pelikisi a luhogala ipa mi Yudeya hina kawaidewedeweya. Geka binei ma Paulo i palihaleya po hau numa panipani i mamae. ");
INSERT INTO tbo_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Petasi i nei anani taniwaga ugolina po iyeta tonuga hi kokoe ma u Sisaliya i’mhoe po i gae u Yelusalem, ");
INSERT INTO tbo_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","po noka hosi tu witalaguyaba babadahi po mi Yudeya tu tahaehi Paulo hi igouya naka Petasi hi wibenabenameya. Ma hi lupali gawagawata ");
INSERT INTO tbo_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","hi pa Petasi ina winugodewadewahi po Paulo ina palihaleya po ina nei u Yelusalem. Matababana amaka hi wiwogatala ipa Paulo hau tahaya hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Petasi hai lupali i wimiheya i pa, ‘Paulo u Sisaliya to womomohi po hau numa panipani e mamae ma apo ega daona ma a gunawileu. ");
INSERT INTO tbo_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Inapa powa awai amaka ina dewaya yaka ami babada ona palihalehi po mitehi to nae u Sisaliya po hina wigouya.’ ");
INSERT INTO tbo_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Petasi Yelusalem lawahi mitehi hi mae gaogao emosi ma tupona ma apoma i gunawileya u Sisaliya. Ma malitom po ani luhetala numana ugolina i duhuna ma i baha po Paulo hi luiyeya. ");
INSERT INTO tbo_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Hougana Paulo i luilui mi Yudeya Yelusalemgei hi nenei hi mewiiwileya ma hi igou koyakoyameya. ");
INSERT INTO tbo_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ma Paulo tuawana ubeina i baha nae Petasi ugolina i pa, ‘Mi Yudeya hai lugagayo po numa dalabu baneina a lugagayo po Sisa a lugagayo ega ata tulagona dadani.’ ");
INSERT INTO tbo_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Tamogi Petasi mi Yudeya ipa ina winugodewadewahi yaka Paulo ugolina i pa, ‘Nugonugom una gae u Yelusalem po geka wigouhi bihiyei una luhetala u matau?’ ");
INSERT INTO tbo_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ma Paulo lubayada geka i wimiheya i pa, ‘Eega, geka Sisa anani luhetala ugolina a towotowolo ma geka hosi ipa a luhetala, matababana ega kikina apapoe gehouna mi Yudeya ugolihi ata dewaya, tam u hanapugena dumaya. ");
INSERT INTO tbo_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Inapa lugagayo awai amaka a tulagoni po powa a dewaya naka i dewadewa a hilage. Ega ipa hilage a lowo haleya. Tamogi inapa geka wigouhi koyama apega iyai ina wodamaneu geka lawahi ugolihi. U lupali ipa Sisa ata wasawasa baneina u matana a luhetala.’ ");
INSERT INTO tbo_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Apoma Petasi tu paliteetena mitehi hi ibaabani po i kokoe ma i pa, ‘Sisa u lupaliyeya yaka apo una nae Sisa ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Iyeta wabihaga hi kokoe ma wasawasa Agilipa nouna Benisi mitehi hi nei u Sisaliya ipa Petasi hina mamali. ");
INSERT INTO tbo_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Noka hosi hi mae iyeta wabihaga ma Petasi Paulo a tupo i dedeya Agilipa ugolina i pa, ‘Geka hosi naka lawa gehouna hau numa panipani e mamae ma Pelikisi i nehaleya. ");
INSERT INTO tbo_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ma hougana a nenae u Yelusalem naka tu witalaguyaba babadahi po mi Yudeya hai tanitaniwaga lawana iyowai ma hi igouya naka tuwegana hi paliweleu. Ma hi lupaliyeu hi pa a baha po hina uni. ");
INSERT INTO tbo_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","‘Tamogi a paliwelehi a pa, “Mi Loma i dewa naka ega emoemotana po powa tu dewana to baha po hina uni yababaya a sigana tu wigouna mitehi hina luhetala. Ma powana tu dewana a gaogao to weleya po tuawana binei ina wibaabani.” ");
INSERT INTO tbo_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ega yaka hougana hi laugeletai geka hosi naka ega u houga ata haleya. Ma malitom po hau ani luhetala a duhuna ma a baha po lawana hi neiyai. ");
INSERT INTO tbo_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Hougana tu wigouna hi towolo po hi ibaabani naka powa baneihi a nugonugotuhuhi naka ega gehouna ita dewaya. ");
INSERT INTO tbo_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Awai atapuhi i bahebahehi naka tauhi tuawahi hai witumagana po hai mamae ubeihi. Ma lawa gehouna gowana Yesu hi bahebaheya hi pa, “Amaka i hilage,” ma Paulo i pa, “Eega, yohola e lauyagohana.” ");
INSERT INTO tbo_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ega ata hanapugeya iyowai ma apo dewa geka pite a lidumaluya. Ega yaka Paulo a lubayadeya a pa, “Nugonugom yaka una gae u Yelusalem po hina igoum binei una luhetala?” ");
INSERT INTO tbo_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ma tamogi Paulo i lupali i pa, “Tu galena itete u nimahi a mamae po apo u luhetala Sisa ina winugonugotuhugeya.” Ega yaka a baha po hau numa panipani hi houni po e mamae apo gaogao a tuhagaya yaka a himili po ina nae Sisa ugolina.’ ");
INSERT INTO tbo_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa Petasi ugolina i baha i pa, ‘Nugonugou ipa geka lawana a baha a nonoli.’ Ega yaka Petasi i pa, ‘Hau malatom apo a baha una nonoli.’ ");
INSERT INTO tbo_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ma malitom po Agilipa ma Benisi hai wasawasa lelihigei hi leli ma hi lui ani’mboina numana ugolina. Hi luilui naka gawiya tanitaniwagahi po Sisaliya meyageina babadahi mitehi hi lui. Apoma Petasi a bahagei Paulo hi niyeya numana ugolina. ");
INSERT INTO tbo_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ma Petasi i pa, ‘Wasawasa Agilipa po taumi iyawoi atapumi geka hosi, geka lawana ona galeya. Mi Yudeya atapuhi geka hosi po u Yelusalem hai ompili geka lawana ugolina, ma hi otu hi pa, “Ega ina lauyagohana.” ");
INSERT INTO tbo_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Tamogi a tuhagaya naka ega powa awai ita dewaya po apo binei ma ina hilage, tauna tuawana ipa Sisa ugolina ina luhetala yaka a lueena ipa apo a himila niyeya. ");
INSERT INTO tbo_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tamogi tauna ubeina ega awai ita lugeleteya ipa u guyau Sisa a pepa a gilumi po a paliweleya. Ugolinei ma Paulo a neiyai taumi u matami ma a dumalu tam wasawasa Agilipa u matam. Ta lubayabayadeya po u mulina nugote apo awai ina lugeleteya po apoma Sisa a baha a gilumi Paulona ubeina. ");
INSERT INTO tbo_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Matababana ega ita dumalu ipa lawa hau numa panipani tu mae a himili po ina nenae ma ega ani libahibahi a wogeleteya.’ ");
INSERT INTO tbo_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa i baha Paulo ugolina i pa, ‘Amaka ma bimgei una wibaabani.’ Ega yaka Paulo nimana i wohepaya ma geka pite a baha i witowolihi i pa, ");
INSERT INTO tbo_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","‘Wasawasa Agilipa, a kaoha duma naka amalai apo u matam biugei a wibaabani po mi Yudeya hai wigou atapuna a wimiheya. ");
INSERT INTO tbo_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Matababana tam mi Yudeya ata mamae po ata dewa u hanapugena dumahi. Ugolinei a lupaliyem ipa upum ina hegoya ma u baha una nonoli ma mi Yudeya hai wigou atapuna a wimiheya. ");
INSERT INTO tbo_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","‘A habuluwe ma u mae i nei po amalai mi Yudeya hi hanapugeya. U luyagohana u meyagai po u Yelusalem naka i wawala po i nenei hi hanapugeya. ");
INSERT INTO tbo_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Lolowa amaka hi hanapugeya, ata tapalolo wailugagayo dumana a bolu gowana Palisi naka tau tulahi gehouna. Inapa nugonugohi yaka apo hina bahena geleteya. ");
INSERT INTO tbo_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ma amalai naka geka hosi a towolo ma he lauhetaleu, matababana Yaubada a paliwitumagana googata ugolihi towolo meme binei naka ugolina a iotonana ma a itumagana. ");
INSERT INTO tbo_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ma tamogi ata guguni magouhi 12 iyetei po uguwei Yaubada he wootalagiyeya, ma geka paliwitumaganana ugolina he iotonana ma he itumagana ipa apo hina tuhagaya. Wasawasa tam, geka tauna wiotonanana po witumaganana binei ma mi Yudeya he igouwe babana a ibaabani Yesu a towolo meme binei. ");
INSERT INTO tbo_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Awai binei Yaubada lawa hilage ugolina ma e itowolo mehi ega emoemotana ona witumaganeya? ");
INSERT INTO tbo_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","‘Lolowa a inugonugotuhu ipa ginouli magomagouhi a dewahi po Yesu Nasaletagei gowana a luhopuneya. ");
INSERT INTO tbo_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma geka pite dewa u Yelusalem a deweya. Tu witalaguyaba babadahi hi palihaleu po Yesu tu wotagona hi maga duma hau numa panipani a hounihi. Ma gasi hougana hi ununihi naka tau omunugohi a lueeneya. ");
INSERT INTO tbo_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Houga i maga duma numa dalabu atapuhi u hinehi a baha po hi wimihehi po gasi a wiletahi ipa hai witumagana hina bowiyehi. Ma uyou i gigai duma yaka a nae u meyagai geha po a ihiniwiyuwahi. ");
INSERT INTO tbo_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","‘Geka dewana ugolina ma tu witalaguyaba babadahi ugolihi taniwaga a waya ma hi palihaleu po a nae Damaseko u meyageina. ");
INSERT INTO tbo_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Wasawasa, iyeta bolinai tahayagei a nenae ma yayata namanamalina yadei i hopu mai po tau po lawa mitehi to nenae naka i yayata wiiwileiyai. Geka yayatana naka i kadidili duma ma apoma kabudala yayatana a kadidili. ");
INSERT INTO tbo_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ma atapuiyai to guli hopu hau hipuli po a lautanigana ma lawa gehouna Mi Yudeya ponatiyei i baha mai ugoliu i pa, “Saulo! Saulo! Awai binei e ihiniwiyuwau? Tam e ihiniwiyuwa mem. Galenam mei bulumakau ani lihunahi higeyala kamkamna ugolina, e ilabatena mem.” ");
INSERT INTO tbo_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘A lubayada a pa, “Guyau, tam iyai?” ‘Ma Guyau i pa, “Tau Yesu, houga daodaona e ihiniwiyuwau. ");
INSERT INTO tbo_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Tamogi una welutowolo po aemgei una towolo. A wogeletena meu ugolim ipa a witowolim po tam u tu bagibagi. Amalai awai ugoliu u gagaleya ipa lawa gehouhi una paliwelehi. Ma gasi houga u naota awai ana iatatiyem naka ipa lawa una paliwelehi. ");
INSERT INTO tbo_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Apo a himilim po una nae mi Yudeya po tauhi ega mi Yudeya ugolihi. Geka tauhi lawahi ugolihi apo a wiluyagohanim hai pilipili ubeihi. ");
INSERT INTO tbo_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tam apo hau uguwa matahi una hoenihi ma una wiwilihi po hau yayata hina nae. Ma Tomodulele a manini ugolina ma una wiwilihi po hina nae Yaubada ugolina. Yaka hai witumagana tau ugoliu tepanei apo hai apapoe a paligigilihi. Ma Yaubada a lawa waiwoiyawahi u hayahi apo ani mae hina tuhagaya.” ");
INSERT INTO tbo_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","‘Wasawasa Agilipa, geka binei ma enogalena yadei a ialoni naka ega ata wiponahahaleneya. ");
INSERT INTO tbo_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Yaka lawa u Damaseko a paliwelena tahaehi ma apoma u Yelusalem, po gasi Yudeya tupona atapuna po gasi tauhi ega mi Yudeya. A guuguya ipa hai apapoe hina palihalehi ma hina luhagawilehi Yaubada ugolina. Ma awai hina dewadewahi naka ipa hai nugobui ina wogeletaya. ");
INSERT INTO tbo_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Mi Yudeya numa dalabu baneina u hinena hi womomohiu po hi ileta ipa hina ununiu naka a matababana geka a paliwelem. ");
INSERT INTO tbo_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Tamogi Yaubada i haguhaguwe ma i nei po amalai. Ugolinei ma geka hosi a 