﻿USE sofia;
DROP TABLE IF EXISTS sofia.tblNT_vpl;
CREATE TABLE tblNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tblNT_vpl WRITE;
INSERT INTO tblNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni se kmò kestugoden yóm gónó Jisas Krays gu semfu bè yóm tehe kehbalingen tau. Semfu gu bè yóm tehe Dabid. Ne ke Dabid, sfu yóm tehe Abraham. ");
INSERT INTO tblNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Yóm Abraham ni, du se yóm hol kun mà yóm tehe Isak. Ne mngà yóm Isak, duhen Jakub. Tikóng mngà Jakub, duhen Juda ne yó kem dumun setwoli hono logi. ");
INSERT INTO tblNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Timbow mngà Juda kun, duhen Pérés ne Sira. (Yó boluy yê le, Tamar.) Mngà Pérés, duhen Hisron. Yóm Hisron ni, mà yóm tehe Ram. ");
INSERT INTO tblNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tikóng mngà Ram, duhen Aminadab. Mngà Aminadab, duhen Nasun. ");
INSERT INTO tblNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Mngà Nasun, duhen Salmun. Mngà Salmun, duhen Buas. (Ne yó boluy yê Buas, Rahab.) Mngà yóm Buas, duhen Ubid. (Ne yó boluy yê Ubid, Rut.) Timbow mngà nim Ubid ni, duhen Jisi. ");
INSERT INTO tblNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mngà ke Jisi, duhen Dabid, yóm tehe sotu tau hol geta bè yó kem Ju. Timbow mngà ke Dabid, duhen Selumun. (Yó yê Selumun, yóm tehe yehen Yuraya.) ");
INSERT INTO tblNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Mngà yóm Selumun, duhen Rihubum. Mngà nim Rihubum, duhen Abidya. Mngà Abidya, duhen Asa. ");
INSERT INTO tblNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nim Asa ni, mà yóm tehe Jihusafat. Mngà Jihusafat, duhen Jihuram. ");
INSERT INTO tblNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Mngà Jihuram, duhen Usaya. Yó kun ngà Usaya, duhen Jutam. Ne mngà Jutam, duhen Ahas. Mngà Ahas, duhen Hisikaya. ");
INSERT INTO tblNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nim Hisikaya ni, hol kun mà yóm tehe Manasi. Mngà Manasi, duhen Amon. Mngà Amon, duhen Jusiya. ");
INSERT INTO tblNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Mngà Jusiya, duhen Jékunaya ne wen kem twolihen. Umahu kóm bè yóm kul kdaw yó, yó se yóm gotu kegef le kul ebè Babilun yó kem tau Israél. ");
INSERT INTO tblNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yóm deng kkól le ditu bè Babilun yó kem tau yó koni, mngà Jékunaya, duhen Syaltil. Mngà Syaltil, duhen Sirubabél. ");
INSERT INTO tblNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Mngà ke Sirubabél, duhen Abyud. Ne mngà Abyud, duhen yóm tehe Ilyakim. Mngà Ilyakim, duhen Asor. ");
INSERT INTO tblNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Mngà Asor, duhen Sadok. Mngà ke Sadok, duhen Akim. Mngà Akim, duhen Ilyud. Mngà Ilyud, duhen Élyasar. ");
INSERT INTO tblNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Mngà ke Élyasar, duhen Matan. Mngà Matan, duhen Jakub. ");
INSERT INTO tblNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Mngà Jakub, duhen Jusif. Du se yóm tehe myehen ke Midi, Yê Jisas. Jisas se yóm bnoluy le Misaya, yóm deng nélék Dwata mò kmamal yóm klamangen. ");
INSERT INTO tblNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Duhen yó, sfolò fat duléken mugod lemwót bè Abraham efet kól bè Dabid. Ne bud sfolò fat duléken se mugod lemwót bè Dabid efet kól bè yóm kegef le kul ebè Babilun yóm kdê kem tau Israél. Bud sfolò fat duléken se mugod lemwót bè yóm kegef le kul ebè Babilun efet kól bè yóm ksut Jisas Krays, yóm Misaya. ");
INSERT INTO tblNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ni se mò kewóten yóm tehe ksut Jisas Krays. Yóm yéen Midi, deng leninti yóm sotu sawang logi boluyen Jusif. Okóm yóm gu laan le là deng sgefet, tódô mlutut Midi mlan bè Tulus Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nim Jusif deng leminti ke Midi ni, tau tedeng kloloen yó kem hlau Dwata, okóm bè nim kwen bnutut Midi ni, là móyóen ke wen gónó Midi myak bè gónón wen. Yó gónón tódô tô lemifut mit du skó bè yóm deng klintihen du. ");
INSERT INTO tblNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yóm igoen tolo hemdem du yóm yó, tódô wen hógów Dwata gu bè longit hegfan béléen bè knahen, monen mò du, “Ó Jusif, semfu gu bè Dabid, béi hengayà myehen ke Midi abay se lemwót bè Tulus Dwata yóm bnututen. ");
INSERT INTO tblNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Angat logi yóm ngaen, ne yó boluyem du Jisas, yakà du yóm lemwà yó kem kun tau gu lem salà le.” ");
INSERT INTO tblNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bè ni kem ni, deng tódô tahu edu yóm tehe tulón Dwata hlanen bè yóm sotu tehe gna tugoden, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Angat wen sawang libun tódô mlutut, ne mngà logi, ne boluy le du Imanyuwél (yó lanen yóm boluyen yó, tendo nô bélê tekuy Dwata).” ");
INSERT INTO tblNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Timbow mukat Jusif bè yóm ktungóen yó, tódô nimónen yóm deng monen mò du yóm hógów Dwata, ne tódô nan e nangay Midi, nwiten ebè gónóen. ");
INSERT INTO tblNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Okóm song sentungóen, deng sut yóm ngaen logi. Ne yó boluy Jusif du Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bè Bitlihim tehe gónó Jisas sut, yóm sotu benwu udì bè prubinsya Judiya. Bè yóm kdaw yó, Hirod yóm tau hol geta bè yó. Timbow deng malù legen udì yóm ksut Jisas, wen kem tau hulung hménég blotik gdek bè syudad Jirusalim, lemwót le fi gu dmata kdaw. Wen snólók le bè yó kem tau bè yó, mon le, ");
INSERT INTO tblNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Gónóhen seblà sut de yóm ngà mò angat geta bè yó kem Ju? Deng ton me gu ditu bélê me yóm blotik mò ilô yóm ksuten. Nim nógów me ni, na me e hnódó.” ");
INSERT INTO tblNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mung kungol Hirod du yóm mon le yó, ya tey ktafa nawan, ne senged se yó kem dumu tau bè Jirusalim, gbót tafa nawa le se kul. ");
INSERT INTO tblNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Omin Hirod gotu semtifun yó kem tau geta bè yó kem gel demsù ebè Dwata ne yó kem tau gel tmolok hlau, snólóken bélê le, monen, “Benwu du de gónóhen seblà sut yóm Misaya, yóm deng kun nélék Dwata?” ");
INSERT INTO tblNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mon le se mò du, “Bè Bitlihim gónóhen angat sut, yóm sotu benwu udì bè prubinsya Judiya. Yakà deng wen yóm tehe snulat yóm sotu tehe gna tugod Dwata ekni, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nim Bitlihim, sotu benwu udì glem bè yóm kun benwu Juda. Balù yóm tey kudien, là kóen na a glaan bè yó kem syudad bè yó, yakà bè nim benwu udì ni gónón sut yóm tau mò malak yó kem dou tau Israél.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bè yóm kungol Hirod du yóm tehe hsulat Dwata yó, ominen lemifut tminok yó kem tau hulung hménég blotik yó koni, snólóken bélê le yóm kdaw kegfanen bélê le yóm blotik ton le yó. ");
INSERT INTO tblNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Timbow deng tngónen, ominen hógów kul ebè Bitlihim, monen mò kul, “Hlós ye sen, mógów ye kut ebè Bitlihim na ye e hnebel yóm ngà lomi sut yó. Kesok ton ye, na ye e tulón dou dini anì naw e gbót hnódó se do.” ");
INSERT INTO tblNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tahu se, lemwót le. Bè yóm tolo knô le bè lan, tódô bud ton le yóm blotik tehe gfan bélê le bè benwu le. Ya tey kehligal le bè yóm bud kton le du. Tódô tendo holun tukô gna kul efet htengen ta yóm gónô gónón nô yóm ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yóm kkól le bè yó, tódô le husek elemen, ne ton le se yóm ngà lewu le Midi, yóm yéen. Uni le mton du, tódô le henmung mtud bukol klohoken ne ya tey kdóyón le du. Omin le makat yó kem kimu alì mebtes nwit le mò basa le du. Wen se tahu blówónen, ne wen se yóm alì minggel boohen boluyen insinsu ne mira. ");
INSERT INTO tblNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bè yóm kulék le, tólóng ne lan lolò le, abay se bud wen hekna Dwata kul anì là bud le mlan bè Hirod sok le mulék. ");
INSERT INTO tblNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yóm kogol le mulék yó kem tau hulung hménég blotik yó, wen bud hógów Dwata gu bè longit bud hegfan bè kna Jusif, monen mò du, “Ó Jusif, btiki ne, géhél nwitem yóm ngà lewu le yéen etu bè Idyip. Tódô ye na nô ditu efet kól bè yóm bud khuléku kuy edini, yakà angat hfebel Hirod du yóm ngà anì hfatayen.” ");
INSERT INTO tblNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tahu se, btik Jusif, ne kendel nwiten yóm ngà lewu le yéen, ne tódô le kem mógów kifu etu bè Idyip. ");
INSERT INTO tblNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ngang le nô bè yó efet matay Hirod. Ni se deng kdohoen yóm tehe mon Dwata bè Sulaten, hlanen bè yóm sotu tehe gna tugoden ekni, yóm monen, “Tnabahu yóm Ngau anì mulék gu bè Idyip.” ");
INSERT INTO tblNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Timbow dilô Hirod yóm deng kegsukaten bè yó kem tau hulung hménég kógów blotik, ya tey sidek kebuten. Yó nmoen, gotu hfatayen kdéen ngà logi tolo udì bè Bitlihim ne yó kem dumu benwu hmilol bè yó. Lemwót bè yóm ngà logi tolo hulô efet kól bè yóm ngà logi deng lewu halayen, gotu hfatayen lu. Deng eles nsóhen yóm deng kegenen sut yóm blotik lemwót bè yóm ktulón le du du yó kem tau hulung hménég kógów blotik. ");
INSERT INTO tblNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bè yóm nmò Hirod yó, deng gónón dohò yóm tehe tulón yóm sotu tehe gna tugod Dwata ekni boluyen Jirimaya, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wen tey dmumu mkik bè yóm benwu boluyen Rama. Anì monem dnumu nkik Rakél kem ngaen ne là kô wen gembek mifa du, abay se, deng le gotu matay yó kem ngaen.” ");
INSERT INTO tblNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Timbow deng matay Hirod, wen bud hógów Dwata gu bè longit na a hegfan bè kna Jusif ditu bè Idyip, monen mò du, ");
INSERT INTO tblNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ó Jusif, btiki ne, nwitem mulék yóm ngà lewu le yéen ebè yóm kuy benwu bè Israél. Deng le gotu matay ne yó kem tau tehe tô hmatay du yóm ngà.” ");
INSERT INTO tblNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tahu se, btik Jusif, nwiten yóm ngà lewu le yéen, mulék le ebè Israél. ");
INSERT INTO tblNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Timbow gungol Jusif, yóm ngà Hirod boluyen Arkilus tles mogot bè prubinsya Judiya, yó gónó Jusif likò bud nô bè yó. Bud hekna Dwata ke Jusif anì hlós ebè prubinsya Galili. ");
INSERT INTO tblNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tahu se, ne bè yó gónó le nô bè yóm sotu benwu udì boluyen Nasarit. Ni se deng gónón dohò yóm tehe mon yó kem tehe gna tugod Dwata ekni, yóm mon le, “Angat boluy le du tau lemwót bè Nasarit.” ");
INSERT INTO tblNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bè yóm kdaw yó, sut yóm sotu tau boluyen Jan gel mabtays ditu bè yóm benwu laen hol tau menwu du bè prubinsya Judiya. Yó nmoen, gel hetngónen yóm Udél Dwata bè yó kem tau, yó monen mò kul, ");
INSERT INTO tblNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Hegsel ye ne, knogol ye ne yó kem sidek gel nmò ye, yakà móyónen hto ne yóm buteng Dwata mogot tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nim Jan ni, du se gónón e gbak yóm mon yóm sotu tehe gna tugod Dwata ekni boluyen Isaya, yó monen, “Wen sotu tau tmaba gu bè tum benwu laen hol tau menwu du. Yó utóm tabahen, monen, ‘Eles hen-gifat ye yóm lan angat lolò yóm gónó tekuy mogot. Eles hentedeng ye yóm lan mò loloen.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nim Jan ni, yó nesen nmò le lemwót gu bè bul kamél ne yó hileten kulit ógóf ne són tlangas ne tneb gel kenen. ");
INSERT INTO tblNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tey dê tau tendo gel mógów ebéléen na le e hnungol yóm gel toloken. Wen se lemwót bè syudad Jirusalim, ne wen se gu bè klamangen prubinsya Judiya, ne wen se lemwót bè kem benwu hmilol yóm él Jurdan. ");
INSERT INTO tblNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ni kem tau ni, gotu benkas tulón le ke Jan yó kem salà le, ne bnabtays Jan lu bè yóm él Jurdan. ");
INSERT INTO tblNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Timbow ton Jan yóm kógów le ebéléen yó kem Farisi dalang se yó kem Sadyusi na le e tô hbabtays béléen, tódô monen mò kul, “Ya nim yu, hol ye mkél bè ulal, gel henlóyen ofi. Ilóu ofo kuy ke tô ye gewà lemen yóm angat tafak Dwata tau ke olo ye hbabtays. ");
INSERT INTO tblNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ke deng knogol ye yó kem sidek gel nmò ye, hol hdilô ye bè kmò ye dé. ");
INSERT INTO tblNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne bê ye abay tô ken-gel nawa yó dum kesfu ye gu bè yóm tehe Abraham ke yó tô lan ye gewà. Tódô tulónu kuy, balù ni he kem botu ni dé, botong gbek Dwata hembaling du tau mò semfu gu bè Abraham. ");
INSERT INTO tblNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ke hlingónu du yóm móyón ktafak Dwata kuy, hol lómón ke beyung deng eles mléd lem but yó kem koyu mò angat sfeken kul. Ket koyu ke là gulit kbunguhen, angat senfeken, ne tódô tudà elem ofi.” ");
INSERT INTO tblNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Béléu do,” mon Jan, “él gel babtaysu kuy mò ilô yóm deng kehegsel ye. Okóm yóm huli do, yó kun kmò kbabtays yó kem tau mimón béléen, suen bélê le yóm Tulus Dwata. Bong yó kem tau là mimón le, ofi moen kul. Yóm tau huli do yó, tey mfasang sentahu. Là kóe knóón baluen ke heseke béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hol lómón ke eles mit teef mò teefen yóm angat knusuhen. Ne gotu otunen eta fol yó kem usoken. Lemwót yóm kafahen tódô ntemen bè yóm ofi laen kô dù tul katayen.” ");
INSERT INTO tblNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bè yóm tolo lel Jan mabtays bè él Jurdan, sut béléen Jisas lemwót gu bè prubinsya Galili. Yó nógówen, nan e hbabtays ke Jan. ");
INSERT INTO tblNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Okóm mom yó balà Jan du, monen, “Béi mom hbabtays béléu, ou dé bnabtaysem.” ");
INSERT INTO tblNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bnalà Jisas se, monen, “Kendolen ne. Hyu ke gotu nmò te yóm kóyô Dwata bélê te.” Tahu se, bnabtays Jan Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Timbow hahun gu lem él Jisas, tódô henmungen hnas bè longit, ne tódô tonen se yóm Tulus Dwata htuntun etahen gu bè longit, hol lómó kmoen obun, ne tódô mdef béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne ominen wen mudél gu bè longit, monen, “Ni se hol dou Ngà tendo gónón nô nawahu. Tey kligalu béléen.” ");
INSERT INTO tblNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bè yóm deng kehbabtays Jisas, omin yóm Tulus Dwata mit du etu bè yóm benwu laen dù tau menwu du. Ditu gónó Seitan tendo tô tmilów du. ");
INSERT INTO tblNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Botong fat folò buteng Jisas là mken, ya tey sidek kbitilen. ");
INSERT INTO tblNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tódô sut béléen Seitan, ne monen mò du, “Ke tahu uu Ngà Dwata, henbalingem ken kun ni kem botu nii.” ");
INSERT INTO tblNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Okóm yó balà Jisas du, monen, “Là kô yó du! Igoen deng mon du bè Sulat Dwata, ‘Là són du ken gónón mowil tau, okóm bè kdê yóm Udél Dwata se tahu hlowil du.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Omin Seitan bud mit ke Jisas ebè Jirusalim. Niten ebè yóm hol gónón geta te ketef bè Gónô Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne ominen mon du, “Ke tahuhi Ngà Dwata, kmóhi lemwót bè ni kun, yakà sem deng monen du bè Sulat Dwata, monen, ‘Angat dók Dwata yó kem hógówen gu bè longit mò na a smegef kóm anì là tódóen bè botu tihem.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bnalà Jisas se, monen, “Tahu se yóm monem yó, okóm wen sotu bud monen bè Sulat Dwata, monen, ‘Béem tnilów Dwata, yóm gónóhem mogot.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Omin Seitan bud mit ke Jisas eta tfusù yóm tey bulul geta, ne gotu toloken du kdê yó kem benwu talak tonok ne yóm tey kehyuhen. ");
INSERT INTO tblNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mon Seitan mò ke Jisas, “Gotu hogotu kóm yóm kdéen ni, syan ke mtudi bukol bè soluhu, ne ke béléu gónóm kmulu.” ");
INSERT INTO tblNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bnalà Jisas se, monen, “Mdóhi bè ni, Seitan! Yakà deng monen du bè Sulat Dwata, ‘Béem tnilów Dwata yóm gónóm mogot ne són du hol nimónem.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tahu se, tódô tnagak Seitan Jisas, ne sen-gengen se wen hógów Dwata gu bè longit gdek bè yó mò tmóbóng du. ");
INSERT INTO tblNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sotu kdaw bè yó gefet bè Jisas yóm deng kehblanggù Hirod ke Jan. Bè yóm kungolen du, tódô mulék ebè prubinsya Galili. ");
INSERT INTO tblNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hlós ebè kun benwu bè Nasarit, okóm là meneken bè yó. Bud hlós ebè Kapérnaum, ditu gónóhen hol nô. Nim Kapérnaum ni, sotu benwu bè kilil Lanaw Galili, glem lem yóm kul tehe tonok le Sibulun ne Naftali. ");
INSERT INTO tblNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bè yóm knô Jisas bè yó, deng gónón dohò yóm tehe udél Isaya ekni, yóm sotu tehe gna tugod Dwata, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yóm kun tonok tehe Sibulun, ne kun tonok tehe Naftali, kem benwu hnalak lan ebè mohin, benwu nô fatu yóm él Jurdan, hono benwu glem lem Galili, ne hono kem tau là Ju le nô du. ");
INSERT INTO tblNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hol lómón ke tau le nô lem gónón kmifu, okóm angat wen tey layag ton le. Deng le golu elem hatay, okóm angat hlayagen ebélê le yóm layag yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nbuten bè yó ne, tmolok Jisas. Yó gel monen, “Hegsel ye ne, knogol ye yó kem sidek gel nmò ye, yakà móyónen hto ne yóm buteng Dwata mogot tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sotu kdaw bè yó yóm igò Jisas mentad ebè Lanaw Galili, tonen yó kem lewu tau setwoli hmuket le: Simun boluy yóm sotuhen, yóm gel bnoluy le Pitér ne Andru, yóm twolihen. Yó se kul sana gel nmò hmuket. ");
INSERT INTO tblNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tódô mon Jisas mò kul, “Ó kem tau hmuket, mung ye do ne. Wen tles hmou kuy, hebelu yu tau mò lemolò do.” ");
INSERT INTO tblNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tahu se, kendel tódô tebel le huket le, ne mung le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ngang le bud mógów efet bud ton Jisas yó kem lewu tau setwoli, boluy le Jim ne Jan, hono ngà Sibidi. Tolo le nô lem ówóng le, mung kul mà le. Yó nmò le, bneteng le yó kem ksê huket le. Yóm kton Jisas kul, tódô tnabahen lu. ");
INSERT INTO tblNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tahu se, tódô tagak le bè yó yóm ówóng le ne mà le, mung le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kewót Jisas bè yó, tódô lenngeben prubinsya Galili. Yó nmoen, gel tmolok bè yó kem kul gónó le gel stifun yó kem Ju. Hetngónen kul yóm Tulón Hyu gbak ebè kun kogot tau Dwata, lelen gel hkó des yó kem tau, balù kihu kay des le. ");
INSERT INTO tblNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Deng tódô tfengen ebè klamangen prubinsya Sirya gónó le mungol du yóm nmò Jisas. Yó gónóm mon, gotu nwit le ebè Jisas kdê yó kem tau gemnóm des, yó kem tau semlaw kkólen bè yó kem tau lengel mata, ne yó kem tau snidaf, ne yó kem tau matay sfu lówó le, gotu hkó Jisas des le. ");
INSERT INTO tblNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ya tey tau wen lemolò du lemwót gu bè klamangen Galili ne bè klamangen yóm benwu bnoluy le Sfolò Benwu, ne bè syudad Jirusalim, ne bè klamangen Judiya ne yó kem dumu benwu sentu él Jurdan. ");
INSERT INTO tblNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Timbow ton Jisas yó kem tey tau wen, ominen mneged ete yóm sotu bulul udì ne bè yó gónón myón. Gotu le sbung e klohoken yó kem tau gel lemolò du, ");
INSERT INTO tblNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ominen mbut tmolok kul, monen, ");
INSERT INTO tblNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tey kehyuhen bélê le kul yó kem tau ke dilô le yóm kwen gónó le élél bè kehtahu le, abay se deng le sana gmung ne bè yó kem tau nogot Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tey kehyuhen bélê le kul yó kem tau ke wen lenangag le, abay se Dwata angat mifa kul. ");
INSERT INTO tblNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tey kehyuhen bélê le kul yó kem tau ke là hegeta le knô le bè kem dumu le, abay se angat guta le yóm deng fasad Dwata kul. ");
INSERT INTO tblNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tey kehyuhen bélê le kul yó kem tau ke hol nô bè nawa le mò du yóm kun kóyô Dwata, abay se Dwata angat hol hegsengel nawa le. ");
INSERT INTO tblNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tey kehyuhen bélê le kul yó kem tau ke hol knodu le kem dumu le, abay se angat bud knodu Dwata lu se kul. ");
INSERT INTO tblNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tey kehyuhen bélê le kul yó kem tau ke laen dù belenen yóm kehedem le, abay se angat ton le Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tey kehyuhen bélê le kul yó kem tau ke hulung le semfyu kem dumu le, abay se angat bnoluy Dwata lu kem kun ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tey kehyuhen bélê le kul yó kem tau ke hensidek le lu lemwót bè yóm kimón le ke Dwata, abay se deng le gmung ne bè yó kem tau nogot Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tey kehyuhen bélê ye,” mon Jisas, “ke hennê le yu, ne ke hensidek le yu, ne ke dê sidek udél le eta ye lemwót bè yóm klolò ye do. ");
INSERT INTO tblNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hol hnigal ye dé ke lómón yó kmò le kuy, abay se deng wen tey ofol deng eles fan Dwata kuy bè longit. Yóm keglayam ye yó, hol lómón sem yó ne yóm tehe kul keglayam yó kem tehe gna tugod Dwata ekni.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Bud mon Jisas, “Yu kem tau lemolò do, hol lómón ke yu yóm kahì bè yó kem tau. Bede yóm kahì kesok deng mkó yóm khééten, là kô wen lanem bud hféét du ne. Laen kô bud muhen, tódô bot ne sensdà yó kem tau mógów. ");
INSERT INTO tblNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ne sotuhen, hol lómón ke yu yóm layag bè klamangen benwu. Yóm syudad nô ta bulul, laen kô dù gónón gseng. ");
INSERT INTO tblNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Laen se kô tau hemtom solok ke tlek mom bud hnokoben. Kaem yó dé kmoen du, suen bè gónón mfatu anì lemayag ebè kdéen tau lem gónô. ");
INSERT INTO tblNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yake lómón yó se gel kmò ye bè yóm kuy layag. Hol nmò ye yóm hyu anì ton kem dumu tau, ne anì dóyón le yóm Mà tekuy bè longit.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Bud mon Jisas, “Bê ye tô hendem ke yó hendufu edini naw e kó yó kem tehe hlau Musis ne yó kem tehe gel tolok yó kem gna tugod Dwata. Là kô yó du. Là kô kóhu kul. Nim nógówu edini ni, naw e dnohò yó kem deng tehe eles tolok le yó. ");
INSERT INTO tblNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tódô tulónu kuy ktahuhen, bè yóm igoen tolo wen longit ne tonok, laen se kô mkó du yó kem tehe hlau Musis, balù sotu bè yó kem leneken, efet deng gotu dohò yó kem kdê tulónen. ");
INSERT INTO tblNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Duhen yó, ke wen tau mulé du yó kem hlau yó, balù yó kem olo leneken, ne ke deng mom bud niten kem dumuhen tau mulé du, du se yóm hol glaan bè yó kem tau nogot Dwata bè longit. Okóm yóm tau mimón du yó kem hlau yó, ne lelen tmolok du bè yó kem dumun anì nimón le se kul, angat geta boluyen lem blóng yó kem tau nogot Dwata bè longit yóm tau yó. ");
INSERT INTO tblNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tódô tulónu kuy,” mon Jisas, “song ye gmung bè yó kem tau nogot Dwata bè longit ke hol ye hgulit lemolò du yóm kun kóyô Dwata senta yóm kul kgulit yó kem tau tmolok hlau ne yó kem Farisi.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Deng hónô gungol ye se,” mon Jisas, “yóm sana hlau gnan, yóm monen, ‘Béi abay monok. Yóm tau monok, sal gel nwit le bè kukum.’ ");
INSERT INTO tblNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Okóm ni dou tulón kuy, yóm tau ke lenbuten kem dumuhen, angat nwit le bè kukum. Yóm tau ke monen bè yóm dumuhen, ‘Laen dù muhem tau kóm,’ angat nwit le ebè yóm tau gel hemdeng knukum yóm tau yó. Ne yóm tau ke monen bè yóm dumun, ‘Nungeli. Laen dù muhem tau,’ deng golu elem lanaw ofi ne yóm tau mudél yó. ");
INSERT INTO tblNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yó gónóm mon, ke wen dsuem ebè Dwata, anien ke dengi kól bè yóm gónóhem demsù, okóm ke gtulón bè nawahem wen gónóm seglius bè dumum tau, ");
INSERT INTO tblNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nam na hlun tebel bè yó yóm dsuem, kendeli lemwót, mnihi seflifót bè yóm dumuhem seglius yó. Sok deng, ominem yó mulék nam e henfu demsù ebè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sotuhen,” mon Jisas, “ke wen tau kmamo kóm, ne tô nwiten u bè yóm gónô skukum, tnanahi mit sefyu béléen gu laanen là deng gefet bè yó. Abay se ke dengi kól bè yó, ngem kà nwiten kóm ebè yóm tau gel fen hemdeng kmukum kuy. Ne lemwót kun, blayen u bè fulis mò bmanggù kóm. ");
INSERT INTO tblNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tódô tulónu kóm ktahuhen, là kói na a gewà ke là nam gotu gbayad du yóm salaem.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Deng hónô gungol ye,” mon Jisas, “yóm sana hlau gnan, yóm monen, ‘Béem ndà yehenem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Okóm ni dou tulón kuy, balù bè olo ketngelem ebè yóm libun ke wen óyóem du gu lem, deng timbang snamukem ne, abay se deng deng bè yóm kehedemem du. ");
INSERT INTO tblNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yó gónóm mon, ke mata kwananem mit kóm mò salà, tódô lensitem ne tudaem. Mom hyu béléem he ke lana sotu matahem olo ke nwiten u elem lanaw ofi. ");
INSERT INTO tblNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sotun, ke sigel kwananem mit kóm mò salà, tódô kenlengem ne tudaem. Mom hyu béléem he ke lana sotu sigelem olo ke nwiten u elem lanaw ofi.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bud sotun,” mon Jisas, “monen bè yóm sana hlau gnan, ‘Ke móyô skó bè yehenen yóm logi, hyu ke wen gónón fema mò ilô yóm deng kkóhen du.’ ");
INSERT INTO tblNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Okóm yóm dou tulón kuy, là hyuhen yóm logi ke tódô kóhen yóm yehenen igoen là mdà du. Ke bud myehen dumu logi yóm libun yó, deng mdà yehen se kun, okóm yóm logi gna yehenen, du buten yóm kegsalaen. Ne yóm logi bud myehen du yóm libun yó, bud salaen bè Dwata se kun.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ne sotun,” mon Jisas, “deng hónô gungol ye yóm sotu hlau gnan tehe gel hlau yó kem fù tekuy, yóm monen, ‘Ke wen deng fasadem bè Dwata, ne wen safà mung du, hol dnohoem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Okóm ni dou bud tulón kuy, ke wen fasad ye, bê ye smafà. Bê ye abay safà longit, abay se bè yó gónó Dwata nô, ");
INSERT INTO tblNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","duhen ke tonok, abay se bè yó gónó Dwata hmótól tihen, duhen ke Jirusalim, abay se yó kun benwu yóm Dwata hol geta bè kdéen. ");
INSERT INTO tblNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne bê ye abay tô safà kulu ye, yakem gbek ye se hbukay du duhen hfitem du balù sbalu bè yó kem wek ye. ");
INSERT INTO tblNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tódô hen-el ye ke tahu, ne tódô mon ye ‘là’ ke là se tahuhen. Abay se ke mò ye safà, Seitan gónón gu lemwót yóm yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Sotuhen,” mon Jisas, “deng hónô gungol ye yóm sotu hlau gnan, yóm monen, ‘Ke wen hemsidek yóm kóm mata, tódô bud hensidekem se yóm kun mata. Ne ke wen tau temfok yóm kóm ngihi, tódô bud tenfokem se yóm kun ngihi.’ ");
INSERT INTO tblNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Okóm ni bud dou tulón kuy, bê te abay bneles ke wen hemsidek tekuy. Mom yó nmò tekuy, ke wen temfê kut bè hifi te, bud bayà te du dolihen. ");
INSERT INTO tblNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne ke wen mtuk tekuy, ne yó nóyóen sotu kgal te, bud tennù tekuy sotu kgal sen. ");
INSERT INTO tblNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne ke wen sendalù gmaga kut mit yóm kun nwit bè sotu kilumitru, tódô nwit tekuy béléen bè lewu kilumitru sen. ");
INSERT INTO tblNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ke wen tau mni bélê tekuy, benlay te. Ne ke wen tau tô mdóm bélê tekuy, hendóm te sen.” ");
INSERT INTO tblNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ne sotun,” mon Jisas, “deng hónô gungol ye yóm sotu hlau gnan, yóm monen, ‘Kenbong nawahem yó kem dumuhem ne fen knutó nawahem yó kem hmohon kóm.’ ");
INSERT INTO tblNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Okóm ni dou tulón kuy, kenbong nawa te yó kem hmohon tekuy ne hni te lu bè Dwata yó kem hemsidek tekuy, ");
INSERT INTO tblNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","anì mkél tekuy bè yóm kut Mà bè longit. Ngem se kun, tódô gel homong hnóngen yóm kdaw ebè yó kem tau sidek nmò le. Senged se bè yóm kulón, là són du bè yó kem tau tedeng kmò le gónó Dwata hkulón du. Gomong snéen yó kem tau là tedeng kmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bê ye abay tô hendón ke wen ofol blay Dwata kuy ke són yó olo kenbong nawa ye, són yó kem tau kembong nawa kuy. Balù yó he kem tau gel mtuk bwis, sana kul kesbong nawa se kul. ");
INSERT INTO tblNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Laen kô dù kayen yóm kuy kmò ke són yó hnódó ye, són yó kem hol kuy wè. Balù yó he kem tau là setngón ke Dwata, sana kul kesfódó se kul. ");
INSERT INTO tblNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yó gónóm mon, hol ye hgulit, lómón kgulit yóm Mà tekuy bè longit.” ");
INSERT INTO tblNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ten-gama ye,” mon Jisas, “anì là olo ye hegfan du bè gónón wen yóm gel keblay ye ebè Dwata. Ke yó olo tô mu ye du yóm gel keblay ye mò gónó ye megdóyón bè gónón wen, angat laen kô dù ofol blayen kuy yóm Mà tekuy bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Duhen yó, ke wen blay ye bè yóm tau élél, bê ye abay hegfan lómón yóm kul gel nmò yó kem tau hemtedeng knô. Tey gel kehegfan le du bè gónó le gel stifun ne gu bè lan bè gónón wen. Yó gónó le gel mò du anì dóyón tau lu. Tódô tulónu kuy ktahuhen, deng gotu guta le ne kul ofol yó kem tau yó bè yóm kdóyón tau kul. ");
INSERT INTO tblNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Okóm ke tnóbóng ye yóm tau élél, bê ye abay hetngón, balù bè yóm hol dumuhem swè, ");
INSERT INTO tblNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","anì laen dù dumu tau temngón du. Ne yóm Mà tekuy bè longit, gotu tonen yóm là kehetngón ye du yó, ne du he angat bemlay kuy ofol. ");
INSERT INTO tblNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ke mni ye bè Dwata,” mon Jisas, “bê ye dnalang kul kmò yó kem tau hemtedeng knô. Tey le móyô mdà mni bè Dwata lem gónó le gel stifun ne gu bè kilil lan bè gónón wen anì ton tau lu. Tódô tulónu kuy ktahuhen, deng gotu guta le ne kul ofol yó kem tau yó bè yóm kdóyón tau kul. ");
INSERT INTO tblNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Okóm bélê ye kuy, ke mni ye bè Dwata, ditu lem dfél ye gónó ye mò du, ne hyu tnikeb ye beng ye, ne mni ye bè yóm Mà tekuy bè longit, yóm là ton mata du. Ne yóm Mà tekuy yó, tódô tonen yóm là kehetngón ye du bè dumu tau, ne du he angat bemlay kuy ofol. ");
INSERT INTO tblNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Bè yóm kni ye, omin he ke alì sensulit ye udél ye lómón yóm kul gel nmò yó kem tau hemtahu bè yóm dwata kéng. Ofo kul ke yó gónón hmungol kul yóm kul dwata ke bè yóm ktahà kni le. ");
INSERT INTO tblNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bê ye dnalang yóm kul nmò yó. Kaem deng eles tngón yóm Mà tekuy bè longit yóm wen mu tekuy du gu laan tekuy là deng mni du béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Duhen yó, ke mni ye bè Dwata, ni dé kmò ye du, mon ye, ‘Mà me bè longit, kóyô me ke kdéen tau hol madat yóm kóm boluy. ");
INSERT INTO tblNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kóyô me ke géhél nogotem yóm klamangen. Kóyô me ke hol nmò me te tonok yóm kóm kóyô, lómón yóm gel kmò le du dyó bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Benlayem mi sfeng ken me ket haya. ");
INSERT INTO tblNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hol hnifótem kum kem salà me, lómón yóm gel kehlifót me yó kem tau gemsalà bélê me. ");
INSERT INTO tblNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Béem bayà mi ebè yóm tilów mgel, bede hol kenlungem mi bè Seitan.’ ");
INSERT INTO tblNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ke hnifót ye salà yó kem gemsalà bélê ye, hnifót yóm Mà tekuy bè longit snéen yóm kuy salà. ");
INSERT INTO tblNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Okóm ke là hnifót ye kul, là se hnifót Mà tekuy du bè longit yóm kuy salà.” ");
INSERT INTO tblNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bè yóm gel kfasting ye,” mon Jisas, “bê ye dnalang yóm kul kmò yó kem tau hemtedeng knô. Là kô le hgifat anì dilô tau bélê le yóm kfasting le. Tódô tulónu kuy ktahuhen, deng gotu guta le ne kul ofol yó kem tau yó bè yóm kdóyón tau kul. ");
INSERT INTO tblNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Okóm bélê ye kuy, ke gel ye fasting, hyu ke gel ye hgifat mouf ne semwat ");
INSERT INTO tblNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","anì là dilô tau du bélê ye yóm kmò ye du. Tek són Dwata dé temngón du, yóm Mà tekuy bè longit, yóm là ton mata du. Tódô tonen yóm là kehetngón ye du bè kem dumu tau, ne du he angat bemlay kuy ofol. ");
INSERT INTO tblNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Bê ye kat alì henyu te tonok yóm kendengen ye. Ke bè yó gónó ye hemyu du, gbek kaba hemsidek du, ne nkê fak snéen yó kem dumuhen, ne gbek tau mnagaw husek elemen. ");
INSERT INTO tblNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ni dé nmò ye, henyu ye bè longit dé yóm kendengen ye. Abay se ke ditu gónó ye hemyu du, laen kô dù kaba gembek hemsidek du, ne là kóen nkê fak, ne laen dù hemnagaw du. ");
INSERT INTO tblNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yó se gónón nô kendengen ye, yó se gónón nô nawa ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yóm mata ye,” mon Jisas, “hol henged solok lówó ye. Ke hyu mata ye, hol lómón ke lemayag lem lówó ye. ");
INSERT INTO tblNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Okóm ke là hyu yóm mata ye, hol lómón ke kmifu lem lówó ye. Hol ten-gama ye, déke laen dù layagen yóm lem lówó ye. Ke yó se kmoen, ya tey kget kifuhen.” ");
INSERT INTO tblNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Laen dù tau,” mon Jisas, “ke lewu tau gónón mamo segeng gónón mò nmò. Déke mtukul knutó nawahen, ne mtukul se kenbong nawahen. Déke mtukul fen nimónen, ne mtukul se fen sen-gilen. Dalang se kuy,” mon Jisas, “ke són filak ktes ye, là kô gbek ye mimón ke Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yó gónóhu mon du mò kuy,” mon Jisas, “bê ye abay tnafa nawa yóm kmò kken ye, ne yóm kmò kinum ye, duhen ke kmò knes ye. Sélét mom kken ye ne là gbek Dwata du, anì sem klowil ye du, Dwata tehe mò du. Ne sélét mom knes ye ne là gbek Dwata du, anì sem lówó ye yó du, Dwata tehe mò du. ");
INSERT INTO tblNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tenngel ye dé yó kem onuk koyu. Laen kô hulu le, ne laen se kô dù bang nuta le, ne laen se kô dù fol le. Bede tódô wen gel htukóen kul yóm Mà tekuy bè longit. Milud he yó dum kuy, igoen bong kuy mu senta yó kem onuk koyu. ");
INSERT INTO tblNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Laen dù tau ke gbeken tódô htahà du udì ktauhen lemwót bè alì ktafa nawahen klowilen. ");
INSERT INTO tblNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ne moen de ke lenóngón ye nawa yóm kmò knes ye? Tenngel ye dé yó kem bulók lem bnes. Là kô le mò nmò kul, ne là se kô le mewel mò nes le. ");
INSERT INTO tblNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Okóm tódô tulónu kuy, balù yó hem alì kun kegeta Selumun ekni, ne yóm alì kwen kendengenen, ne yóm alì keklóón yó kem nes gel leseken, là kô nan e gsenged du yóm kul keklóón yó kem bulók. ");
INSERT INTO tblNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Là kóen tahà se kul klowil yó kem bulók, olo le sut nim kdaw ni, ne bud le menes elem haya, ne tódô bot lu elem ofi. Ke minggel kmò Dwata kul yó kem bulók balù yóm tey kukol klowil le, mom milud he knesen kuy. Tey udì kehtahu ye nim yu. ");
INSERT INTO tblNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Duhen yó, bê ye abay tnafa nawa yóm kmò kken ye ne yóm kmò kinum ye ne yóm kmò knes ye. ");
INSERT INTO tblNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ni se gel tnafa nawa yó kem tau là deng temngón ke Dwata. Okóm yóm Mà tekuy bè longit, deng eles tngónen yóm kwen mu ye du ni kem ni. ");
INSERT INTO tblNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ni dé hol nmò ye. Hol hogot ye ke Dwata klowil ye, ne hol nmò ye yóm gel hmoen kuy. Ke yó se nmò ye, Dwata he angat bemlay du kuy yó kem kdê wen mu ye du. ");
INSERT INTO tblNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Duhen yó, bê ye tnafa nawa yóm elem haya. Yó he kehedem ye du yóm yó ke deng bangen sut bélê ye. Ke gel tnafa nawa ye yóm elem haya, olo ye mom bud temnù yó kem mgel deng gel sut bélê ye ket haya.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Bê ye tódô hendeng kul kmò kem dumu ye tau,” mon Jisas, “anì là hendeng Dwata du se yóm kuy kmò. ");
INSERT INTO tblNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bè yóm gel kmò kehedeng ye yóm kul kmò kem dumu ye, bud lómón yó se angat kmò kehedeng Dwata du yóm kuy kmò. Yó se nmò ye bè yó kem dumu ye, bud yó se angat nmò Dwata bélê ye. ");
INSERT INTO tblNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Moen se ke snolò tenngel ye huling kdumu ye igoen tolo wen bótóng geblekel lem yóm kuy mata? ");
INSERT INTO tblNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tedu kmò kton ye mkó du yóm huling kem dumu ye ke tolo wen yóm bótóng geblekel lem yóm kuy mata? ");
INSERT INTO tblNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yu kem tau hemtedeng knô. Na ye gna kó dé yóm tey geblekel lem yóm kuy mata anì hyu kton ye mkó du yóm huling kem dumu ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Bud monen, “Bê ye duil tmulón yóm Udél Dwata bè yó kem tau gel hemnê du, lómón ke blay ye bè ohu yóm kimu alì mebtes. Ngem kà mom nékéten kuy. Ne lómón ke blay ye bè sdô yóm ngom libun alì mebtes. Ngem kà gotu sninà ndaen du elem hitok.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bud mon Jisas, “Ke wen hni ye bè Dwata, angat guta ye. Ke wen hnebel ye, tódô ton ye. Ke mbal ye gu bak sut, tódô wen hotun kuy. ");
INSERT INTO tblNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ket tau ke wen hnihen bè Dwata, gutahen. Ke wen hnebelen, tonen. Ke mbal gu bak sut, hotun Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kmoen se kuy du, yu kem tuha, ke mni mambang bélê ye yóm ngà ye, botu kô blay ye du? ");
INSERT INTO tblNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Duhen ke mni utón él, ulal kô blay ye du? Là kô yó du. ");
INSERT INTO tblNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Balù yóm kuy là kgulit,” mon Jisas, “sana khulung ye bemlay kem ngà ye yóm hyu bélê le. Milud he yóm Mà tekuy bè longit. Ke wen hni ye béléen, angat wen tey hyu blayen kuy. ");
INSERT INTO tblNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yó se nóyô ye nmò tau bélê ye, yó se kuy nmò bélê le. Ni se hol lemen yóm tehe hlau Musis dalang se yóm kul tolok yó kem gna tugod Dwata ekni.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hol hnusek ye yóm bak tikeb sikeb, abay se yóm bak tikeb ebè yóm lanaw ofi, tey lamang, ne tey mahil yóm lan edu, ne tey tau wen lemolò du. ");
INSERT INTO tblNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Okóm tey sikeb yóm bak tikeb ebè yóm klowil laen dù sónen, ne tey mgel lemolò du yóm lan edu, ne là kóen hol wen tau mton du.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Hol ten-gama ye yó kem tau tódô lembù tmugod ke Dwata. Hol lómó ktonem kul, lómón ke ubiha. Okóm bè yóm kmò le, hol le mkél bè yó kem ohu dlag. ");
INSERT INTO tblNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Angat dilô ye lu bè kmò kekdol le. Hol lómón yóm hulu, sal gel dilô ye bè bungu le. Laen kô koyu semnual mungu soging. Ne laen se leteng mungu kmatì. ");
INSERT INTO tblNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yóm koyu hyu, hyu se kbunguhen. Dalang se yóm koyu sidek, sidek se kbunguhen. ");
INSERT INTO tblNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yóm koyu hyu, là kóen na a sidek kbunguhen. Dalang se yóm koyu sidek, là kóen na a hyu kbunguhen. ");
INSERT INTO tblNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yóm koyu là hyu kbunguhen, tódô nofok kmò du, ne tudà elem ofi. ");
INSERT INTO tblNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yó gónóm mon, tódô dilô ye bè kmò kekdol le yó kem tau lembù tmugod ke Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Là kô kdéen du yó kem tau mon du ou yóm gónó le mogot, angat gmung bè yó kem tau nogot Dwata,” mon Jisas. “Tek són olo gmung yó kem tau mimón yóm kun kóyô yóm Mà bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kesok bangen hto yóm kdaw kkukum Dwata tau, angat tey dê tau mon du mò do, ‘Ó Dwata, tehe gel hlan me bè kóm boluy yóm gel ktugod me ke Dwata. Bud hlan me bè kóm boluy se yóm tehe gel kehdó me kem tulus seitan, ne yóm tehe gel kmò me yó kem hentaw ton.’ ");
INSERT INTO tblNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Okóm,” mon Jisas, “angat monu mò kul, ‘Là kô tngónu kuy. Hlayuk ye béléu, yu kem tau gel mò sidek.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Duhen yó,” mon Jisas, “yó se tau hmungol udélu, ne nimónen, hol lómón ke du yóm tau hulung hedem hemdà gónô te botu. ");
INSERT INTO tblNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ne e demsù yóm tey kulón bong, ngangen ne dmunuk yóm él, ne mbel se yóm tey lenos bong. Tódô senloben yóm gónô yó, okóm là kô ghugónen du, abay se deng hdaen te botu. ");
INSERT INTO tblNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Okóm yóm tau hmungol udélu,” mon Jisas, “ne là nimónen du, hol lómón ke du yóm tau là hulungen hedem, hemdà gónô talak helek. ");
INSERT INTO tblNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ne e demsù tey kulón bong, ngangen ne dmunuk él, ne mbel se yóm tey lenos bong, ne tódô senloben yóm gónô yó, ne tódô kendel hugón, ya tey sidek kegbaen.” ");
INSERT INTO tblNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yóm deng ktulón Jisas du kdê ni kem ni, tey kehtaw le du yó kem tau sbung, ");
INSERT INTO tblNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","abay se là mkélen bè yóm kul ktolok yó kem tau gel tmolok hlau bélê le. Alì mfasang yóm kun ktolok Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Timbow deng kól gu lem bulul Jisas bè yóm ktoloken ditu, tey tau bud muluk huli du. ");
INSERT INTO tblNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wen tau gemnóm des mifù hloni ebéléen, ne tódô tuden bukolen bè soluhen, ne hkodu béléen, monen mò du, “Ó Sér, ke yó dum móyói, kaem gbekem tódô hkó du nim desu ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tahu se, na e nenok Jisas yóm tau yó, monen, “Móyóe tmóbóng kóm. Mkó ne desem.” Ne tahu se, tódô sen-gengen se mkó béléen yóm des mifù yóm tau yó. ");
INSERT INTO tblNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mon Jisas mò du, “Hol béem abay tulón yóm deng nmou béléem ni. Tódói hekteng mógów ebè tum tau gel demsù ebè Dwata, nam e hetngel du lówóhem. Elesi se mit mò dsuem anì nmoem yóm sotu hlau Musis ekni mò gónó le milô du kem dumu tau yóm deng kkó yóm desem.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ngang Jisas mógów efet kól bè Kapérnaum. Wen sotu tau kfitan nô bè yó, tau lemwót gu bè Rom. Senlongen Jisas ne hkodu béléen, ");
INSERT INTO tblNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","monen, “Ó Sér, wen sotu tau gel mò nmò béléu nô bè gónóu. Là buden dmemen doli lówóhen, ya tey sidek kegnómen du.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mon Jisas se mò du, “Yó ne, mógówe edyó naw e hkó béléen yóm desen.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Bê, Sér,” mon yóm kfitan yó koni. “Là knóónen ke tói motun bè dou gónô, yakà tauhe lemwót bè Rom dou. Olom tódô hemwit udél ne, kaem tódô mkó he tum desen. ");
INSERT INTO tblNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Henknahu béléu se ke ou,” mon yóm kfitan. “Wen se kem tau geta sentahu gónóhu kmulu, ne gel nimónu. Ne wen se kem sendalù dou nalak, ne sal gel nimón le o. Sok monu mò yóm sotu, ‘Tu ne,’ tahu se, tódô kendel lemwót. Dalang se ke monu, ‘Géhéli,’ tódô kendel sut. Sok monu bè yóm heseku, ‘Nmoem nii,’ yó se tódô nmoen.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Timbow gungol Jisas nim mon nim kfitan ni, tey kehtawen du, ne monen mò yó kem tau gel lemolò du, “Tódô tulónu kuy ktahuhen. Laen dù tau tonu bè klamangen Israél ke lómón ni hol kehtahuhen béléu. ");
INSERT INTO tblNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni tódô tulónu kuy. Bè yóm mò ken bong angat nmò Dwata bè longit bè yó kem tau nogoten, angat tey dê tau là Ju le lemwót fi gu dmata kdaw ne fi gu desdef, angat le gotu na a seyón mken bè tu kem tehe fù me Abraham ne Isak ne Jakub. ");
INSERT INTO tblNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Okóm yó kem Ju, yóm hol bak mfun du yóm kogot Dwata tau, là kô le gmung kul. Angat gotu tudà le lu ditu ebè yóm gónón alì kmifu, ne bè yó tendo gónó le heslaf dmumu mkik, ne sembéhé kakim.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne bud beklil Jisas ebè yóm kfitan yó koni, monen mò du, “Muléki ne. Tonem bunguhen he yóm deng kehtahuhem.” Ne tahu se, tódô sen-gengen se mkó des yóm tau mò nmò bè yóm kfitan yó. ");
INSERT INTO tblNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kewót Jisas bè yó, hlós ebè gónô Pitér. Kól bè yó, tódô glohen tuón Pitér libun gemnóm des kinì là lembó. ");
INSERT INTO tblNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Omin Jisas na a mogot bè sigelen, ne tódô sen-gengen se mkó yóm tey des kinien. Ominen hlingas btik, ne tódô kendel mò ken bè le Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Timbow deng sdef kdaw, tey dê tau lengel mata nwit le ebè Jisas. Hanà tek olo udél Jisas ebélê le deng le sana gotu mdó yó kem tulus seitan malak kul. Kkólen bè yó kem des yó kem dumu tau, gotu hkó Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nim nmoen ni, deng gónóhen dohò yóm tehe udél Isaya, yóm sotu tehe gna tugod Dwata ekni, yóm monen, “Balù kihu des tekuy, gotu kóhen.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bud sotu kdaw bè yó, ton Jisas yóm alì kwen tau sbung ebéléen, monen mò yó kem gel lemolò du, “Hlós tekuy ne efatu lanaw.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Okóm wen sotu bè yó kem tau gel tmolok hlau sut béléen, monen mò ke Jisas, “Ó Sér, lolou uu balù kihu gónóm e mógów.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mom yó balà Jisas du, monen, “Wen lefunges kul gel nulék yó kem bolos, ne mdengen kul sala yó kem onuk koyu, okóm yóm Ngà Tau, laen dù mdengen gónóhen hegnô.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bud wen sotu tau gel lemolò du mon du mò du, “Ó Sér, naw na lebeng mà he, ominu yó lemolò kóm.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mon Jisas se mò du, “Tódô hebengem tu he kem kun dumu là hemtahu yóm maem. Okóm fen, loloem ou kóm.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kogolen bè yó, omin Jisas motun elem yóm ówóng, mung le du yó kem gel lemolò du. ");
INSERT INTO tblNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bè yóm igò le mówóng talak lanaw, tódô mbel yóm tey lenos bong, ne botong tô glimun lewók yóm ówóng le. Okóm ke Jisas kun, deng mom fen tungô. ");
INSERT INTO tblNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tódô le mógów ebéléen yó kem gel lemolò du na le e bentik, mon le mò du, “Ó Sér, tnóbóngem mi. Hatay tekuy ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bnalà Jisas se lu, monen, “Mò ye kat alì likò ni du? Tey udì yóm kehtahu ye.” Ominen yó tódô hboluk btik, ne mudél ebè yóm lenos ne yóm tey lewók, monen, “Botongen ne.” Ne tahu se, tódô sen-gengen se menek gu talak lanaw. ");
INSERT INTO tblNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tey ketnga yó kem tau gel lemolò du, mon le, “Tau du de ni? Balù yóm lenos ne yóm lewók, botong nimón le.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Timbow le gefet fatu lanaw bè benwu yó kem tau Girasin, wen lewu tau lengel mata semlong ke Jisas, lemwót le gu lem yóm kilib gónó le gel lembeng. Tey sidek klóbô le lemwót bè yó kem tulus seitan malak kul. Laen kô dù tau mlos gel mlan ebè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Timbow ton le Jisas ni kem lewu tau ni, ya tey sidek klangat le, mon le mò du, “Uu se Ngà Dwata. Tedu tô nmoem bélê me ni du? Nam e kendel tô tnafak mi kô gu laanen là deng hto yóm hol bantangem mò du?” ");
INSERT INTO tblNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bè yóm kdaw yó, kulel se kul keswól bè yó yó kem tey sdô wen, bede geblà klayuken bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne yó hol henkodu le bè Jisas yó kem tulus seitan yó koni, mon le mò du, “Ke yó hendufem nam e hdó mi, tódô hfusekem mi ebè tu ne kem sdô tuu.” ");
INSERT INTO tblNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tahu se, hlus Jisas lu. Uni le tmagak yó kem lewu tau yó koni, tódô le husek ebè tu kem sdô. Kewót le se kul yó kem tey sdô wen, gotu le sedlu mlóy mosol ebè tubaw kbu yóm lanaw, ne tódô le gotu gekmó elem lanaw, ne gotu le lemneb yóm kdê le. ");
INSERT INTO tblNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kewót le se kul yó kem tau gel semgyok sdô, gotu le mlóy ebè yóm benwu moni bè yó. Gotu tulón le yóm kdê ton le, dalang se yóm deng nmò Jisas bè yó kem lewu tau tehe lengel mata. ");
INSERT INTO tblNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mung kungol le du yó kem tau bè yóm benwu yó, tódô le gotu sguku ebè Jisas. Timbow le ston du, tey kehkodu le béléen anì tnagaken yóm benwu le. ");
INSERT INTO tblNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Bud kewót le Jisas bè yó, motun le elem yóm ówóng, mulék le efatu lanaw ebè yóm benwu gónó Jisas nô. ");
INSERT INTO tblNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bè yóm kkól le ditu, tódô glo Jisas yóm tau deng matay sfu lówóhen, sentihang le ebéléen. Timbow ton Jisas yóm alì kehtahu le béléen, yó gónón tódô mon du ebè yóm tau matay sfu lówóhen, “Hol hgelem nawam, Man. Deng hnifótu ne yó kem salaem.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Timbow gungol yó kem tau gel tmolok hlau yóm udél Jisas yó, mom yó hendem le, “Moen tau ni ke hsengeden knóen bè Dwata?” ");
INSERT INTO tblNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tódô tngón Jisas yóm nô lem hendem le, yó gónón mon du mò kul, “Moen de ke sidek kmò kehedem ye ebéléu? ");
INSERT INTO tblNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Là kóen na a mahil mon du, ‘Hnifótu ne yó kem salaem.’ Ne là se kóen mahil mon du, ‘Btiki, ne mógówi.’ ");
INSERT INTO tblNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ni naw hton kuy yóm kwen kwalisen hmifót salà yóm Ngà Tau yóm igoen tolo nô te tonok.” Ne omin Jisas bud mudél ebè yóm tau deng matay sfu lówóhen yó, monen mò du, “Mdai ne, Man, ne nitem yóm gónó le mit kóm yóó, ne muléki ebè gónóem.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ne tahu se. Tódô btik yóm tau yó koni, ne tódô mulék ebè gónóen. ");
INSERT INTO tblNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Timbow ton yó kem tau sbung nim nmò Jisas ni, tô le likò, lel le dmóyón ke Dwata bè yóm tey kfasang blayen bè tau. ");
INSERT INTO tblNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bud kewót Jisas bè yó, tódô tonen yóm sotu tau fen gel mtuk bwis boluyen Matyu, myón bè fsinaen. Bè yóm kton Jisas du, tódô monen mò du, “Ó Wè, loloem o.” Ne tahu se, mung kdà Matyu bè yó, loloen Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bè yóm igò le Jisas ne yó kem gel lemolò du mken bè gónô Matyu, tey dê bè yó kem dumu tau gel mtuk bwis dalang se yó kem dumu tau gemsalà, gbót seyón kul mken bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Timbow ton yó kem Farisi nim ni, tódô le mógów ebè yó kem tau gel lemolò ke Jisas, ne mon le mò kul, “Moen de yóm tau gónó ye gel htolok ke deng mom segbót mken bè yó kem tau yóó?” ");
INSERT INTO tblNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mung kungol Jisas du yóm mon le yó, yó gónón mon du mò kul bede hningónen, “Yóm tau ke laen dù desen, là kô snoloen du kun yóm tau mulung. Són yóm tau wen desen mebel yóm tau mulung. ");
INSERT INTO tblNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hol hennagì ye dé lanen yóm sotu monen bè Sulat Dwata, ‘Keskodu dé yóm hol nóyóu bélê ye,’ mon Dwata, ‘là kô dsù du.’ Duhen ni se yóm nógówu edini ni,” mon Jisas, “là kô tnabahu kul yó du kem tau tedeng kmò le. Okóm yó tnabahu, yó kem tau gemsalà.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kogolen bè yó, sut le bè Jisas yó kem tau gel lemolò ke Jan yóm gel mabtays, wen snólók le béléen, mon le, “Ó Sér, bélê me kum, dalang se bè yó kem Farisi, gel wen kdaw me fasting. Moen de ke là gel nmò le du yó kem gel lemolò kóm?” ");
INSERT INTO tblNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ne bnalà Jisas lu, bede hningónen, monen, “Ke wen mò ken, là gbek le du ke là gbót le mken yó kem tau hol bak mulu yóm igoen tolo nô bélê le yóm logi myehen. Okóm angat wen kdawen tódô kwa le du bélê le yóm logi myehen. Yó he kton ye kul fasting.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne wen bud tulón Jisas kul bè yóm là kehyu sembool du yóm kun tolok bè yóm tolok gna, bede bud hningónen, monen, “Laen kô dù tau se ke namà kenséen yóm nes lomi mò klefengen yóm kgal bolok. Ke yó tô nmoen, ngem ke kemsong yóm nes lomi, tódô ksê yóm kgal bolok. ");
INSERT INTO tblNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne sotuhen, laen kô dù tau ke ilihen elem yóm sning kulit ógóf deng legen yóm tifas hanà lomi. Kmoen yóm tifas yó ke kmodok, ne mom btù yóm gónóhen e mili du, abay se lemtò bè yóm deng kkodoken. Ne gotu gamà yóm tifas, ne baling sidek yóm gónóhen nô. Yó dé kun yóm tifas ke hanà tolo lomi, ilihem bè yóm sning kulit ógóf hanà tolo lomi snéen. Ke yó se kmoem du, là kóen btù yóm sning kulit ne là se gamaen yóm tifas.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yóm igò Jisas tolo tmulón du kul ni kem ni, wen sotu Ju wen glalen mógów ebéléen, ne tódô na a mtud bukol bè soluhen, ne monen mò du, “Ó Sér, wen yóm ngau libun deng lewaken nawan koni. Okóm holi mung do nam e nenok do anì bud mowil.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tahu se, tódô mung du Jisas ne yó kem gel lemolò du. ");
INSERT INTO tblNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yóm igò le mógów mulit lan, wen sotu libun gemnóm des tenbalung mógów huli ke Jisas, ten-gafit nduen nesen. Abay se deng sfolò lewu halayen kegenen gemnóm du yóm desen. ");
INSERT INTO tblNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yó hendemen, “Baluen ke olohu gemdù nesen, kaem tódô mkó nim desu.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Unin mdù du, beklil se Jisas, ne tódô tonen yóm libun yó, monen mò du, “Hgelem nawam ne, Lenibun. Yóm kehtahuhem béléu, yó se gónón mkó yóm desem.” Ne tahu se, tódô sennganen se mkó yóm desen. ");
INSERT INTO tblNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ne omin Jisas hlós ebè gónô yóm tau wen glalen yó koni. Timbow le kól bè yó, husek elemen, ne tódô tonen yó kem tau stifun tô na a mung lembeng, lel tey kehebnes le. Mon Jisas mò kul, “Na ye hewà bè ni kdê ye. ");
INSERT INTO tblNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Là kóen deng matay he yóm ngà libun yó, tódô olon tungô.” Okóm deng mom són mò le hemkéng du yóm mon Jisas yó. ");
INSERT INTO tblNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Timbow gotu hefewaen yó kem tau, omin Jisas mógów elem dfél yóm ngà libun yó koni, ne nogoten sigelen, ne tódô kendel btik se yóm ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tódô lengeben klamangen benwu le gónón e mból yóm deng nmò Jisas yó. ");
INSERT INTO tblNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Timbow bud lemwót bè yó Jisas, wen lewu tau butô kemtes huli du ne tmaba le ebéléen, mon le, “Ó Sér, sfu tehe Dabid, hol knoduhem mi.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Timbow kól lem yóm gónô gónón e solu Jisas, kól le se béléen yó kem lewu tau butô yó koni, ne wen snólók Jisas bélê le, monen, “Hentahu ye kô yóm kegbeku hton kuy?” Bnalà le se, mon le, “Hentahu me se, Sér.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Omin Jisas mnok bè mata le, monen, “Yó ne, guta ye balaen ne yóm deng kehtahu ye yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne tahu se, tódô sen-geng le se bud mton. Ne tey kehget kmon Jisas du mò kul, “Bê ye abay tulón bè kihu tau nim deng nmou bélê ye ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Okóm bè yóm kulék le, deng mom sensból le bè klamangen yóm benwu yó yóm deng nmò Jisas bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hol le se lemwót yó kem lewu tau tehe butô yó koni, wen dumu tau bud gdek ebè Jisas, wen nwit le tau là buden gudél lemwót bè yóm tulus seitan malak du. ");
INSERT INTO tblNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Timbow hdó Jisas yóm tulus seitan nô béléen, tódô bud gudél se yóm tau yó. Tey ketnga le du yó kem tau sbung bè yó, mon le, “Là kô deng wen ton tekuy bè klamangen Israél deng mò du yóm kun nmò nim tau ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Okóm kul yó kem Farisi, mom yó kmon le du, “Kaem lemwót bè Seitan yóm kul ogot yó kem tulus sidek, yóm kfasangen hdó tulus seitan yóm tau yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kogolen bè yó, lemwót Jisas nan e gotu nauy yó kem benwu lembang kkólen bè yó kem benwu lemnek. Yó nmoen, nan e gel tmolok bè yó kem gónó le gel stifun. Gel tulónen yóm Tulón Hyu lemwót bè kogot Dwata tau, luken hkó kentihen kay des yó kem tau. ");
INSERT INTO tblNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bè yóm gel ktonen yó kem tey tau wen gel sbung ebéléen, tey kkoduhen kul, abay se tey dê gónó le glayam, ne laen kô dù tmóbóng kul. Lómó ktonen kul, lómón yó kem ubiha laen dù tau mdengen semgyok kul. ");
INSERT INTO tblNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yó gónón mudél ebè yó kem gel lemolò du, bede hningónen, monen, “Tey nuta, okóm là holen wen tau muta. ");
INSERT INTO tblNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hol ye mni bè Dwata dé yóm fun nuta anì wen tau hógówen mò na a muta.” ");
INSERT INTO tblNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sotu kdaw bè yó, gotu htaba Jisas yó kem sfolò lewu gel lemolò du, ne gotu benlayen lu kwalis anì gbek le hdó yó kem tulus seitan ne hkó des, balù kihu klasihen. ");
INSERT INTO tblNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yó boluyen kul aposol. Ni se boluy le: Simun yóm boluyen du Pitér ne yóm twolihen Andru. Tmodol du Jim ne yóm twolihen Jan kem ngà Sibidi. ");
INSERT INTO tblNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Omin le Filip ne Bartulumyu, ne Tumas, ne Matyu yóm tau gel mtuk bwis. Ne yóm sotu Jim ngà Elfiyus, ne Tediyus, ");
INSERT INTO tblNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ne yóm sotu Simun yóm tau tehe mung mofin yóm kul benwu, ne Judas Iskariyut yóm tau fen bemlay sumóng ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kewóten bè yó ne, gotu hógów Jisas yó kem sfolò lewu tau néléken, ne wen hlauhen kul, monen, “Bê ye mógów ebè kul benwu yó kem tau là Ju le, dalang se ebè kul benwu yó kem tau Samarya. ");
INSERT INTO tblNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yó gónó ye e mógów ebè tu kem kwen tekuy tau Israél, abay se hol lómón tô le ubiha tabag. ");
INSERT INTO tblNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ne ye e tulón kul yóm móyón kehto yóm buteng Dwata mogot tau. ");
INSERT INTO tblNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hkó ye des yó kem tau semlaw, ne hlowil ye ke wen tau matay. Hkó ye yó kem gemnóm des mifù, ne hdó ye bè yó kem tau lengel mata yó kem tulus seitan malak kul. Deng wen blay Dwata kuy yóm là benli ye du. Duhen yó, ke wen tau angat tnóbóng ye, bê ye abay hbayad lu. ");
INSERT INTO tblNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bè nim kógów ye ni, bê ye abay mit filak. ");
INSERT INTO tblNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bê ye se abay mit bag, ne olon sotu kgal lesek ye, bê ye abay mit mò gewuhen. Bê ye mit tlumfà, duhen ke tuged. Abay se knóón bè yó kem tau mò nmò ke tódô benlay yó kem tau gónó le mò nmò ke wen gónó le élél. ");
INSERT INTO tblNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ke sut ye bè yóm benwu bong duhen ke bè yóm benwu udì,” mon Jisas, “hol hnebel ye yóm tau móyô hmódó kuy. Béléen gónó ye mefet efet kól bè kulék ye. ");
INSERT INTO tblNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ke motun ye bè yóm gónô, yó mon ye mò yó kem tau nô lemen, ‘Dwata he henek nawa ye.’ ");
INSERT INTO tblNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ke hnódó le yu yó kem tau bè yóm gónô yó, angat wen kenek nawa le. Okóm ke là hnódó le kuy, laen se kô kenek nawa le. ");
INSERT INTO tblNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ne ke wen benwu là hmódó kuy, ne ke là dog hnungol le kuy, tódô tnagak ye yóm benwu yó, olo ye tmótók kfung bè ti ye. ");
INSERT INTO tblNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tódô tulónu kuy ktahuhen, ke deng kól yóm kdaw kkukum Dwata tau, angat tey bong ktafaken kul yó kem tau bè yóm benwu yó senta yóm ktafaken yó kem tau tehe alì mò sidek bè Sodom ne Gomora.” ");
INSERT INTO tblNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ngem,” mon Jisas, “bè nim khógówu kuy ni, lómón ke ubiha mógów elem blóng tu kem lóbô lem bnes boluyen wolf. Hol ye hfulung temgama, lómón yóm kul khulung temgama yó kem ulal. Ne hol hninggel ye knawa ye, lómón yóm kul klinggel knawa yó kem obun. ");
INSERT INTO tblNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Eles ye temgama, abay se angat wen kem tau kemfô kuy, nit le yu ebè yóm gónó skukum, ne nabid nfes le yu bè yó kem kul gónô gel stifun yó kem Ju. ");
INSERT INTO tblNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lemwót bè yóm klolò ye do gónó le angat mit kuy bè solu yó kem gubérnor, ne bè yó kem tau hol geta. Yó se kdaw ye tnana hetngón du bélê le yóm Tulón Hyu, dalang se ebè yó kem tau là Ju le. ");
INSERT INTO tblNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ke angat kenfô le yu, bê ye abay tô tnafa nawa yóm mò kbalà ye kul, ne yóm kmò kudél ye ebélê le. Dwata he tmolok du kuy yóm kmò kbalà ye kul sok kól yóm kdaw yó. ");
INSERT INTO tblNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Abay se là kô kuy udél du yóm angat mon ye, okóm udél hmonen kuy yóm kun Tulus yóm Mà tekuy bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bè yóm kdaw yó, angat wen se tau setwoli, glef hekfô le yó kem kul dumu setwoli ne hfatay le. Ne wen se kem mà, glef hekfô le yó kem kul ngà ne hfatay le. Dalang se yó kem ngà, glef hekfô le kem kul tuha ne hfatay le. ");
INSERT INTO tblNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Angat tey dê tau kmutó nawa kuy lemwót bè yóm klolò ye do. Okóm yóm tau ke gbeken hembala du yó kem gónóhen glayam efet kól bè hol sónen, du se gmuta du yóm klowil laen dù tul sónen. ");
INSERT INTO tblNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ke hnayam le yu bè sotu benwu, tódô ye mlóy ebè dumu benwu. Tódô tulónu kuy ktahuhen, là kô na ye e deng gdeng du he yó kem hmou kuy bè kdê yó kem benwu bè klamangen Israél, deng sana bud kól yóm Ngà Tau. ");
INSERT INTO tblNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yóm tau ke hanà tolo dmalang, là kóen geta senta yóm tau tmolok du. Dalang se yóm tau mò nmò, là kóen geta senta yóm gónón mogot. ");
INSERT INTO tblNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hyu nawahen yóm tau dmalang ke deng guliten yóm tau tmolok du. Ne yóm tau mò nmò, hyu nawahen ke deng guliten yóm amohen. Ke Seitan boluy le du yóm gónó ye mogot, milud he ksidek udél le ebélê ye, yu kem mogot béléu.” ");
INSERT INTO tblNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bê ye hlikò bè tau,” mon Jisas. “Kdéen gebnos deng nmò tau, angat gotu gfan. Duhen ke wen bunihen bè kem dumuhen, tódô gotu bud tngón. ");
INSERT INTO tblNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bè yó kem gel tulónu kuy ke kifu, hol bud tulón ye ke kemdaw. Bè yó kem deng gel tulónu kuy sónen yu, hol bud tulón ye bè kdéen tau. ");
INSERT INTO tblNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bê ye abay likò bè tau. Gbek le hmatay lówó ye, okóm yóm lóyóf ye, là kô gbek le hmatay du. Dwata dé hol tahu knikò ye, abay se gbeken hmatay lówó ye, ne gbeken se tmudà lóyóf ye elem lanaw ofi. ");
INSERT INTO tblNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngem yó kem ngà onuk bnes gel hbalù le, tek slad bli yóm lewu botù. Balù yóm kul là kebtes, là kóen na e tódô mosok ebè tonok yóm sotu ke là deng eles tngónen du yóm Mà tekuy bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Milud he yó dum kuy. Balù yó he kem balu wek ye, deng gotu nsó Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yó gónóm mon, bê ye abay hlikò. Bong ye mebtes se kuy senta yó kem tey dê ngà onuk bnes.” ");
INSERT INTO tblNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Bud mon Jisas, “Yóm tau ke gel tulónen yóm kloloen do lem blóng kem dumun tau, angat bud tulónu se kun bè solu Mà bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Okóm yóm tau ke hnalaen yóm kloloen do lem blóng kem dumuhen, angat bud hnalau se do bè solu Mà bè longit.” ");
INSERT INTO tblNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ilóem ofo kuy ke yó hendufu edini ke naw e sensotu nawa tau te tonok. Là, yó hendufu naw e semkla nawa. ");
INSERT INTO tblNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lemwót bè yóm kógówu edini, gotu sekla nawa le yó kem tau smà ne tau syê ne tau stuón. ");
INSERT INTO tblNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Deng mom yó hol hmohon du yóm sotu tau, duhen yóm kun fes lówó. ");
INSERT INTO tblNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yóm tau ke loloen o,” mon Jisas, “okóm ke alì henlom nawahen kem tuhahen, kéngen yóm kloloen do yó. Dalang se ke alì henlom nawahen kem ngaen, kéngen yóm kloloen do. ");
INSERT INTO tblNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yóm tau ke loloen o, okóm là eles tnihangen du yóm kun kros, kéngen yóm kloloen do. ");
INSERT INTO tblNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yóm tau knamaen klowilen, angat lana béléen yóm klowilen yó. Okóm yóm tau là knamaen du yóm klowilen, angat gutahen yóm klowil laen dù sónen.” ");
INSERT INTO tblNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bè nim khógówu kuy ni,” mon Jisas, “yó se tau hmódó kuy, lómón ke ou hnódóhen. Ne yó se tau hmódó do, lómón ke hnódóhen yóm deng hógów do. ");
INSERT INTO tblNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yóm tau ke hnódóhen yóm tau hógów Dwata, abay se dilóen yóm khógów Dwata du, angat tódô senged se yóm ofol blay Dwata kul yóm lewu le. Ne yó se tau hnódóhen yóm tau hyu kmoen, abay se dilóen yóm kehyuhen, tódô senged se yóm ofol blay Dwata kul yóm lewu le. ");
INSERT INTO tblNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tódô tulónu kuy ktahuhen, baluen he ke tek olon él tnaw hinum ye yóm sotu tau gel lemolò do, yóm tau alì glaan bè kdéen, abay se dilô ye yóm kloloen do, angat dohò wen ofol blay Dwata kuy.” ");
INSERT INTO tblNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Timbow deng kehlau Jisas yó kem sfolò lewu gel lemolò du yó koni, ominen lemwót na a tmolok bè yó kem dumu benwu hmilol bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ngangen mból yóm gel nmò Krays efet gefet bè Jan lem blanggù, yóm Jan gel mabtays. Timbow gungolen, ominen wen bè yó kem gel lemolò du hógówen ebè Jisas ");
INSERT INTO tblNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","anì snólók le béléen ke deng duhen du ne yóm tau hógów Dwata tehe gel tulónen, duhen ke na le na nangat he? ");
INSERT INTO tblNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bè yóm ksólók le du bè Jisas, bnalaen se lu, monen, “Mulék ye ne, ne ye e tulón ke Jan yó kem deng gungol ye ne yóm deng ton ye. ");
INSERT INTO tblNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yóm tau butô tódô bud mton, yóm tau hikot bud gógów, yóm tau wen des mifù gnómen gotu mkó, yóm tau bokong bud mungol, yóm tau matay bud mowil. Ne sotuhen, yóm Tulón Hyu lemwót gu bè Dwata deng gefet bè yó kem tau élél. ");
INSERT INTO tblNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hligal kun yóm tau ke là megewu nawahen do.” ");
INSERT INTO tblNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kogol yóm kulék le gu bè Jisas yó kem tau hógów Jan yó, omin Jisas tmulón ke Jan lem blóng yó kem tey tau sbung, monen, “Bè yóm tehe gel kógów ye ebè Jan bè yóm benwu laen hol tau menwu du, tedu se yóm tô nóyô hnebel mata ye béléen du? Yóm bnes tendo mung mgafil bè lenos kô? Là kô yó du. ");
INSERT INTO tblNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tedu se tô hnebel mata ye du? Yóm tau knóón knesen kô? Là kô yó du. Tek són yó gónó ye mton du yóm tau knóón knesen, tek són lem gónô bong yóm tau hol geta. ");
INSERT INTO tblNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tedu se hol hnebel mata ye du bè yóm tehe gel kógów ye ebéléen yó? Tau tugod Dwata kô? Tahu se, tau tugod Dwata yóm Jan. Okóm yóm nmoen, mkay senta yóm kun nmò yóm tugod Dwata, ");
INSERT INTO tblNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yakà du du gónón e dohò yóm tehe hsulat Dwata ekni, yóm monen, ‘Wen hógówu tukô gna kóm mò eles hemgifat du yóm angat lanem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tódô tulónu kuy ktahuhen,” mon Jisas, “laen dù tau talak tonok ke geta senta Jan. Okóm ke deng kól yóm kdaw kogot Dwata tau, balù yó he kem tau alì glaan bè kdéen tau nogot Dwata, angat geta senta Jan. ");
INSERT INTO tblNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lemwót bè yóm kbut Jan tmolok efet kól nim kmoen ni, tey sidek tô kseng le du yóm kogot Dwata tau. Yó kem tau alì lóbô tô mò du. ");
INSERT INTO tblNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yóm kogot Dwata tau ni, deng eles gegna ne ktulón le du yó kem tehe gna tugod Dwata ekni, dalang se ke Musis bè yóm kun hlau efet kól bè yóm kun kdaw Jan. ");
INSERT INTO tblNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ke yó dum móyô ye hemtahu du yóm tehe tulón le yó, kaem Jan yóm Ilaydya, yóm tehe gel mon le bud semfulék. ");
INSERT INTO tblNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yóm tau wen klinguhen, hol hmungol.” ");
INSERT INTO tblNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Bud mon Jisas, “Tedu de kmò kehlingónu kuy yu kem tau kmoen ni? Yó gónóhu e hkél kuy, hol ye mkél bè yó kem ngà là mdengen bè fedyan, tnaba le yó kem dumu le, mon le, ");
INSERT INTO tblNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Deng me hningón mulu, ne lel me tembol, là kô ye dog madal. Ne deng me hningón modung, lel me lemanu, là kô ye dog langag.’ ");
INSERT INTO tblNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngem yó dém kkól Jan lem blóng ye,” mon Jisas, “gel fasting se kun, ne là kô ninumen du kun yóm ninum lóbô. Okóm deng mom slón ye du, ‘Tau wen malak du.’ ");
INSERT INTO tblNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bè yóm deng kkól yóm Ngà Tau, gel mken se kun ne gel minum lómón se yóm kuy. Okóm mom senlón ye, gel mon ye, ‘Ngem dé yóm tau yóó, bong kkenen, ne bong kinumen. Deng mom niten swè yó kem tau gel mtuk bwis ne yó kem dumu tau gemsalà.’ Ewenem,” mon Jisas, “sana kegfanen bè klowil yóm tau mimón yóm khulung Dwata mit tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Omin Jisas mudél kul yó kem tau bè yó kem benwu tehe gónóhen gel mò du yó kem dê hentaw ton gel nmoen, abay se là kô le hegsel, ne là kô knogol le du yó kem sidek gel nmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yó monen mò kul, “Angat tey tafak ye, yu kem tau bè Kurasin. Ne tey tafak ye se kuy, yu kem tau bè Bitsayda. Ke deng tehe ton yó kem tau là Ju le bè Tayal ne bè Sidon ni kem hentaw ton deng nmou lem blóng ye ni, ngem kà tódô le lemsek nes sakù, ne bnulus le kohù lówó le mò ilô yóm deng kehegsel le, ne yóm deng kkogol le yó kem sidek tehe gel nmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tódô tulónu kuy ktahuhen, sok kól yóm kdaw angat kkukum Dwata tau, botong kéng he yóm ktafaken yó kem tau là Ju le bè Tayal ne bè Sidon yóm angat ktafaken kuy. ");
INSERT INTO tblNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dalang se kuy yu kem tau bè Kapérnaum. Ilóem kmon ye ke gefet bè longit yóm alì kehegeta ye knô ye. Ngem kà angat tódô tudà Dwata kuy elem lanaw ofi he. Ke deng tehe ton yó kem tau là Ju le bè yóm tehe benwu Sodom ekni yó kem hentaw ton nmou lem blóng ye ni, hol mou kun ne ke là hegsel le se kul, ne là kô genlà Dwata kul. ");
INSERT INTO tblNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tódô tulónu kuy ktahuhen, sok kól yóm kdaw angat kkukum Dwata tau, botong kéng he yóm ktafaken yó kem tau bè Sodom yóm angat ktafaken kuy.” ");
INSERT INTO tblNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bè yóm keseyón le Jisas yó, tódô mni bè Dwata, monen, “Ó Mà, uu se mogot longit ne tonok. Tey kdóyónu kóm, abay se deng wen heglilebem bè yó kem tau laen dù tngónen, okóm bè yó kem tau wen tngón le, là kô heglilebem du bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Duhen yó se, Mà, yóm kóm kóyô kehlan du.” ");
INSERT INTO tblNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Omin Jisas bud mudél ebè yó kem gel lemolò du, monen, “Deng gotu hkem Mà do yóm kdéen. Laen kô tau temngón du yóm Ngà Dwata, tek són yóm Maen. Ne là kô wen tau temngón du yóm Maen, tek són yóm Ngaen, ne tek són yó kem tau deng néléken mò gónóhen hetngón du. ");
INSERT INTO tblNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mógów ye ebéléu dé, yu kem tau miteg lemwót bè yóm keblat yóm gel nbô ye. Fen henwósu bélê ye yóm blat yó. ");
INSERT INTO tblNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tles nbô ye dé yóm dou nbô, ne hol ye dmalang béléu, abay se ganag nawahu, ne là kóe hegeta knô. Ke yó se kuy nmò, là kô ye na e bud miteg. ");
INSERT INTO tblNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Abay se tey mahil mit du yóm dou hwit kuy, ne là kóen blat yóm tles dou hbô kuy.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sotu kdaw bè yó, lemwót le Jisas ne yó kem gel lemolò du, mlan le hlalak yóm tniba, bede geblà bè yóm Kdaw Kehegnô. Ne tey kbitil yó kem gel lemolò du, yó gónó le ma bungu halay mò nteb le. ");
INSERT INTO tblNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Timbow ton yó kem Farisi, mon le mò ke Jisas, “Tenngelem dé yó kem gel lemolò kóm, deng mom nulé le yóm hlau tekuy bè yóm Kdaw Kehegnô yóm nmò le yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bnalà Jisas lu, monen, “Deng hónô senfala ye yóm tehe nmò Dabid ne yó kem kun tau bè yóm tehe kbitil le. ");
INSERT INTO tblNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tódô husek bè Gónô Dwata Dabid, ne nwahen yóm mambang deng blay le ebè Dwata, ne ominen mken du dalang se yó kem kun tau. Blaem bè yóm hlau tekuy, là kóen hyu kken tau hkawang du yóm mambang yó, tek són yó kem gel demsù ebè Dwata gel mken du. Ewenem, là kô duón Dwata du kul yóm kken le du. ");
INSERT INTO tblNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne sotun,” mon Jisas, “deng hónô senfala ye snéen bè yóm tehe snulat Musis gbak ebè yó kem tau gel demsù ebè Dwata. Bè yóm Kdaw Kehegnô, tódô henlel le mò nmò bè Gónô Dwata se kul, okóm là se kô duón Dwata du kul. ");
INSERT INTO tblNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tódô tulónu kuy, deng wen kól lem blóng ye yóm mfasang senta yó kem dê hlolò le kuy bè Gónô Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wen yóm monen bè Sulat Dwata, ‘Keskodu dé yóm hol nóyóu bélê ye, là kô dsù du.’ Ke deng tngón ye lanen yóm udél Dwata ni, là kô ne ye e tódô hensalà yóm tau laen dù bang salaen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yóm Ngà Tau, du se wen kwalisen fen tmolok du kuy yóm hyu mò du bè yóm Kdaw Kehegnô.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Omin Jisas bud lemwót bè yó, ne hlós ebè yóm gónó le gel stifun yó kem Ju. ");
INSERT INTO tblNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wen sotu tau nô bè yó kimoy doli sigelen. Ne wen se kem dumu tau nô bè yó mebel le lan le dmuón ke Jisas, mon le mò du, “Gsalà bè yóm hlau tekuy kô yóm hkó des bè yóm Kdaw Kehegnô?” ");
INSERT INTO tblNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bnalà Jisas se lu, monen, “Tedu kmò ye du se kuy ke kulel kebtangen lem sol ngelem yóm ubiha ye bè Kdaw Kehegnô, là henmung nalu ye du kô? ");
INSERT INTO tblNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Milud he yó dum tau, abay se bong muhen senta yóm ubiha. Yó gónóm mon, là gsalà tekuy du yóm kut hlau ke wen tau tnóbóng tekuy bè yóm Kdaw Kehegnô.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Omin Jisas mudél ebè yóm tau kimoy sigelen yó koni, monen mò du, “Bentolem sigelem.” Ne tahu se, bentolen, hol lómón ke laen dù tehe desen, lómón yóm dolihen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Okóm yó kem Farisi, tódô le gotu lemwót, ne sensatul le yóm kmò khatay le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tódô tngón Jisas yóm tô khatay le du, yó gónón tmagak yóm benwu yó. Tey dê tau bud lemolò du, ne gotu hkóhen des yó kem tau semlaw. ");
INSERT INTO tblNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne tey kget kehlauhen kul anì là tulón le du bè dumu tau yóm deng nmoen bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bè nim nmò Jisas ni, deng gónón dohò yóm tehe udél Dwata deng tulón yóm sotu tugod Dwata ekni boluyen Isaya, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ni se yóm tau tóbóng lówóhu, yóm deng néléku. Tey bong nawahu du, ne tey kligalu béléen. Angat tódô suu béléen yóm dou Tulus, ne angat heglalagen bè yóm kdéen tau yóm ktedeng kogotu kukum. ");
INSERT INTO tblNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Là kô yó du gungol ye béléen ke mit sgés bè kem dumu tau, duhen ke gel hetê. Ne là kô gungol ye du htétél bè gónón wen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bè yóm któbóngen tau, là kô tennù tenfoken du yóm hulu deng metngù, ne là tennù hnatayen du yóm solok sónmoen mudof. Okóm henlelen yóm któbóngen kul efet hol gfan yóm kukum tedeng nogoten. ");
INSERT INTO tblNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Béléen gónón mgel nawa yóm kdéen tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ne ominen wen sotu tau nit le ebè Jisas, tau butô lelen umew lemwót bè yóm tulus seitan malak du. Tódô hdó Jisas yóm malak du, ne tódô gudél se yóm tau, ne bud mton. ");
INSERT INTO tblNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ya tey ketnga le du yó kem tau sbung bè yó, mon le, “Déke ni yóm mon le semfu gu bè yóm tehe Dabid.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Timbow gungol yó kem Farisi nim mon le ni, mom mon le, “Là kô yó du. Kaem Seitan yóm htulus du yó, yakà són du Seitan kul ogot yó kem tulus sidek.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tódô tngón Jisas yóm nô lem hendem le, ne yó gónón mon du mò kul, “Yóm benwu tendo mesgólól nawa tauhen, ne ke sónmò le sfatay, angat meglà. Balù yóm sotu gmónô, ke là ssotu nawa le, ne ke sónmò le sfatay, angat le tódô seglef. ");
INSERT INTO tblNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Duhen yó, ke sónmò le sfatay yó kem tau nogot Seitan, deng mesgólól ne nawa yó kem tau nogoten, ne yó se angat gónó le meglà. ");
INSERT INTO tblNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ke mon ye lemwót bè Seitan yóm kehdóhu tulus sidek, wen snólóku bélê ye. Tedu se gónón lemwót yóm kehdó le tulus seitan yó kem gel lemolò kuy? Tau du de gel htulus kul? Ke là lemwóten bè Seitan yóm kul kegbek hdó tulus sidek, yó se gónón gdilô yóm ksalà kehedem ye. ");
INSERT INTO tblNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Là kóen na a lemwót bè Seitan yóm kehdóhu tulus sidek, okóm tódô lemwót bè yóm kehtulus Dwata do yóm kegbeku mò du. Ne ni gónó ye temngón du yóm deng kkólen lem blóng ye yóm kogot Dwata tau. ");
INSERT INTO tblNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yóm kul ogot yó kem tulus seitan,” mon Jisas, “hol lómón yóm tau kemgis. Laen kô dù tau gusek elem gónóen na a ma yó kem kimuhen ke là nan gna nfét du yóm tau kemgis yó. Ke deng gféten, yó he kegwahen yó kem nóyóen lem gónóen. Hol lómón yó se yóm deng nmou bè Seitan. ");
INSERT INTO tblNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yóm tau là mungen do, hnohonen ou. Yóm tau là tnóbóngen do semtifun yó kem tau, deng du se fen semkla kul. ");
INSERT INTO tblNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yó gónóhu mon du mò kuy, hnifót Dwata yóm tau balù kihu salà nmoen, ne balù kihu udélen sidek gbak ebéléen. Okóm là kô hnifóten du ke sidek kbaken ebè yóm Tulus Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ne hnifót Dwata yóm tau ke sidek kbaken ebè yóm Ngà Tau. Okóm là kô hnifóten du ke sidek kbaken ebè yóm Tulus Dwata. Ke yó nmò yóm tau, laen kô tul kkóhen tahen yóm salaen yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Bud mon Jisas mò kul, “Yóm koyu hyu, hyu se kbunguhen. Ne yóm koyu sidek, sidek se kbunguhen. Tódô ket koyu mungu, sal dilóem bè kmò kbunguhen ke hyu duhen ke sidek. ");
INSERT INTO tblNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ya nim yu kem tau, knawa ye ulal. Yó gónón sidek kebkó ye, abay se hono sidek yóm nô lem hendem ye. Yó se nô lem hendem yóm tau, yó se sut bè sumóngen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yóm tau hyu, hyu kebkóhen lemwót bè yóm hyu gel suen lem hendemen. Yóm tau sidek, sidek kebkóhen lemwót bè yóm sidek gel suen lem hendemen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tódô tulónu kuy,” mon Jisas, “bè yóm kdaw kkukum Dwata tau, angat gotu snólóken bélê le yóm kdéen deng tehe gel benkó le laen dù muhen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yakà lemwóten bè yóm tehe gel benkó ye gónó Dwata lemwót kmukum kuy, ke angat tnafaken yu duhen ke là.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ne wen bè yó kem tmolok hlau ne bè yó kem Farisi mudél ebè Jisas, mon le, “Ó Sér, kóyô me ke moi kum yóm hentaw ton.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bnalà Jisas se lu, monen, “Tey sidek yó kem tau kmoen ni. Balù udì ke wen nawa ye ebè Dwata. Móyô ye kô ke wen hentaw ton nmou lem blóng ye? Laen kô dù bud nmou ne. Tek són nmou lem blóng ye, són yóm hentaw ton tehe ton le bè Juna ekni, yóm sotu tehe gna tugod Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bè yóm tlu buteng Juna nô lem blutut yóm tey utón bong lem mohin, yó hnigaden yóm tlu butengen angat nô lem lebeng yóm Ngà Tau. ");
INSERT INTO tblNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bè yóm kdaw angat kkukum Dwata tau, tódô le sbung mdà bè yó se kul yó kem tau là Ju le lemwót bè Ninibi, ne angat nsel le yu. Anam yó ne, tek olo Juna he yóm tehe hetngón du kul yóm udél lemwót bè Dwata, ewenem yó, sana kehegsel le, ne tódô tnagak le yóm sidek gel nmò le. Ne deng wen yóm mkay senta Juna deng kól lem blóng ye bè ni, okóm deng mom henda ye. ");
INSERT INTO tblNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bè yóm kdaw angat kkukum Dwata tau, angat mdà bè yó se kun yóm tehe libun boi là Juhen lemwót bè benwu Siba, ne nselen yu. Tehe gloken milo lemwót gu bè kun benwu là sekna lanen na a hemklingu ke Selumun, yóm tehe sotu tau hol geta bélê tekuy ekni, yóm alì hulung hmau. Ne deng wen ne yóm mkay senta Selumun deng kól lem blóng ye bè ni, okóm deng mom henda ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ke deng mdó bè yóm tau yóm tulus seitan gel malak du, yó lanen semibet gu lem bnes mebel gónón e hegnô. Okóm ke laen dù bang tonen, ");
INSERT INTO tblNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yó mon yóm tulus seitan yó, ‘Na bud mulék dé ebè yóm tehe gónóhu lemwót.’ Tahu se. Bè yóm kkólen bè yó, tódô tonen laen kô dù nô du, deng mólós, ne minggel kestifesen yóm tehe gónóhen nô yó. ");
INSERT INTO tblNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ominen na tódô bud lemwót, nan e nangay hitu dumuhen bud nô bè yó, bede yóm alì sidek egem le sentahen. Tikóng le deng kól, tódô le husek bè yóm tau gónó le nô. Yó gónóm mon, mom mkay senta yóm gna tehe alì ksidek kegnómen du. Lómón yó se yóm angat gfà le yó kem tau gel mò sidek nim kmoen ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bè yóm tolo lel Jisas mudél ebè yó kem tey tau sbung ebéléen, sut le se bè yó le yéen ne yó kem twolihen, tô le móyô stulón du, okóm olo le tódô mdà bè lewaen. ");
INSERT INTO tblNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne wen tmulón du ke Jisas, monen, “Tu dé le yéem ne kem twolihem, mdà le bè lewà, móyô le stulón kóm kun.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mom yó balà Jisas kul, monen, “Wen se dumu yéu, ne wen se dumu twolihu.” ");
INSERT INTO tblNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ominen yó temdok ebè yó kem tau gel lemolò du, monen, “Ngem ni kem tau nii, hol lómón ke yéu ne hol lómón ke twolihu. ");
INSERT INTO tblNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Abay se yóm tau mimón yóm kun kóyô Mà bè longit, hol lómón ke twolihu ne libunu ne yéu.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bè yóm kdaw yó, lemwót bè gónô Jisas, mógów etu bè kilil yóm lanaw, ne myón ne tmolok bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ya tey tau genged bud stifun ebéléen. Botong lemwót Jisas motun eta yóm ówóng, ne bè yó gónón myón. Fen le nô bè kilil lanaw kul yó kem tey tau wen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tey dê tulónen kul, bede sal hlanen bè hlingón, monen, “Wen sotu tau nan e sohul bnéken bè dnaduhen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bè yóm ksohulen du, wen se temsik ebè lan, ne sut yó kem onuk koyu, ne tódô gotu tnukô le. ");
INSERT INTO tblNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wen se sohulen gdek elem lusok botu ebè yóm gónón laen hol tonoken. Là kóen legen deng sana tmowok, abay se là mfól tonoken. ");
INSERT INTO tblNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Okóm timbow sut kdaw bè yóm deng ktowoken, tódô kendel menes, abay se monem là holen ngelem dolilen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ne bud wen se sohulen gdek e talak yóm gónón angat mfól kluon. Ne tmowok se, tódô mung senok bè yó kem kluon, okóm deng mom limes kun yóm ngà towok halay lem blóng le. ");
INSERT INTO tblNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Okóm wen se sohulen gdek ebè gónón hyu tonok. Timbow gefet, ya tey kfól bunguhen. Wen se kanguyen mungu lematu, wen se mungu nem folò, wen se mungu tlu folò.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Omin Jisas bud mon du mò kul, “Yóm tau wen klinguhen, hol hmungol.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kogolen bè yó, mógów le ebè Jisas yó kem gel lemolò du, wen snólók le béléen, mon le, “Moen de ke gel hningónem yóm gel ktolokem yó kem tau?” ");
INSERT INTO tblNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bnalà Jisas se, monen, “Wen yóm là heglileb Dwata du bè kem dumu tau bè yóm kmò kogoten tau, okóm deng heglileben bélê ye. ");
INSERT INTO tblNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yóm tau ke wen deng gwahen, angat tendo bud gel tennù Dwata béléen anì hol mdengen yóm gwahen. Okóm yóm tau là suen du lem hendemen yóm deng gungolen, balù yóm udì tehe tngónen, angat bud kó Dwata béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yó gónóhu na gel hmingón du yóm gel tulónu kul, abay se bè yóm kton le du, là kô dog dilô le du. Ne bè yóm kungol le du, là kô dog glileb le du. ");
INSERT INTO tblNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yó deng gónón dohò yóm tehe mon yóm sotu gna tugod Dwata ekni boluyen Isaya, ‘Anien he ke gungol le, là kô glileb le du. Anien he ke ton le, là kô dilô le du. ");
INSERT INTO tblNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Abay se là móyô le dmalang ni kem tau ni, deng mom nseng le klingu le, deng le mom hidong. Ke bê le nmò yó dum yó, dilô le yóm gel ton le ne glileb le lanen yóm gel gungol le. Ngangen ne efet le mimón béléu,’ mon Dwata, ‘ne gotu hnifótu yó kem salà le.’ ");
INSERT INTO tblNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Okóm kuy tey hyu,” mon Jisas, “abay se dilô ye yóm gel ton ye, ne tngón ye lanen yóm gel gungol ye. ");
INSERT INTO tblNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tódô tulónu kuy ktahuhen, tey dê kem tehe tugod Dwata ekni dalang se yó kem dumu tau Dwata, gel tô hendeen le mton du yóm kuy deng ton nim kmoen ni, okóm là kô ton le du. Tô hendeen hnungol le se kul yóm kuy deng gungol ni, okóm là kô gungol le du.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ni hnungol ye,” mon Jisas, “yóm lan yóm hningónu yó koni bè yóm tau smohul. ");
INSERT INTO tblNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ke wen tau mungol du yóm tulón bè kmò kogot Dwata tau, ne là dog hendem le du lanen, hol lómón ke yóm bnék temsik ebè lan. Tódô sut Seitan, nwahen bélê le yóm udél deng gungol le. ");
INSERT INTO tblNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bong yóm bnék gdek elem lusok botu, hol lómón ke yó kem tau hmungol yóm Udél Dwata, ne tódô kendel hentahu le, ne tey ktimu óyô le du. ");
INSERT INTO tblNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Okóm là kóen dmolil, tek likót le tô hemtahu. Timbow wen gfà le duhen ke wen hlayam sut bélê le lemwót bè yóm tô kehtahu le, tódô kendel gkogol le yóm tô kehtahu le yó. ");
INSERT INTO tblNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bong yóm bnék gdek elem yóm angat gónón mfól kluon, hol lómón ke yó kem tau hmungol du yóm Udél Dwata, okóm dê bnukù nawa le bè klowil le, ne gfét nawa le bè kebel le kendengen le. Yó gónón limes yóm kehtahu le, ne laen kô dù bunguhen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Okóm yóm bnék gdek ebè gónón hyu tonok, hol lómón ke yó kem tau hmungol du yóm Udél Dwata, ne glileb le. Tey kbungu le kul, wen se mungu lematu, ne wen se mungu nem folò, ne wen se tlu folò.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Bud wen hningón Jisas bélê le, monen, “Yóm kogot Dwata tau, lómón yóm tau na a smohul yóm bnék hyu bè dnaduhen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sotu kifu bè yó, igò le lemnga tungô yóm kdê le, tódô sut yóm hohon yóm tau fun dnadu nan e bud nulit sohul bè dnadu yóm lem kluon, ominen bud mulék. ");
INSERT INTO tblNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne ominen tmowok yóm halay, ne tmowok se kun yóm lem kluon. Timbow deng nbuten mosò yóm halay, yó he kdilô le du yóm kluon deng gbol lemen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Timbow ton yó kem tau gel mò nmò bè yóm tau fun dnadu yó, omin le kendel mógów ebéléen, ne mon le mò du, ‘Ó Sér, igoen se tey tilob yóm bnék sohulem bè dnaduhem, moen se tu du ke wen gbol lemen?’ ");
INSERT INTO tblNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bnalà yóm tau fun dnadu, monen, ‘Yóm tau hmohon do mò du yóm yó.’ Ne mon yó kem tau mò nmò béléen, ‘Tedu kmò me du du? Gotu kendut me kô yóm deng gbol bè yó?’ ");
INSERT INTO tblNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Tagad he,’ mon yóm tau fun dnadu, ‘déke mom gomong gekdut ye yó dum halay. ");
INSERT INTO tblNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na ye tódô hbungu lemen he yó kem halay. Sok kól bè angat kutahu du, gna hekdutu yó kem tau muta yó kem kluon yó, gotu benkes lu ne ntem le. Omin yó he muta yó kem halay, ne omin ye mogut kul ebè fol.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne bud wen sotu hningón Jisas bélê le, monen, “Yóm kogot Dwata tau, hol lómón yóm lem hulu deng hulu yóm sotu tau bè tnibahen, ");
INSERT INTO tblNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","yóm lem hulu alì lemnek bè kdéen. Okóm ke deng tmowok yóm huluhen yó, tey bong, ne baling koyu, ne gotu le smala gu te hangahen yó kem onuk koyu.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ne bud sotu hningón Jisas bélê le, monen, “Sotu gónó tekuy e hmingón du yóm kogot Dwata tau, hol lómón ke yóm libun mò mambang. Balù tek udì bulung henok boolen bè yóm tey arina deng hnéféen, botong gbeken henok du yóm kbongen.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kdê yó kem tulón Jisas yó kem tey tau sbung, sal gel hlanen bè hlingón. Laen dù tulónen kul ke là hningónen du. ");
INSERT INTO tblNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ni se deng gónón dohò yóm udél yóm sotu tau tugod Dwata ekni, yóm monen, “Angat gel hningónu yó kem gel tulónu kul. Angat tulónu kul yó kem tehe là deng tngón le du lemwót bè hol kbut benwu.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kewót Jisas bè yó, tnagaken yó kem tey tau wen, ominen husek elem gónô. Mógów le ebéléen yó kem gel lemolò du, ne mon le mò du, “Tulónem kum kun lanen yóm hningónem bè yóm halay wen kluon gbol lemen.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tahu se, tulón Jisas kul, monen, “Yóm tau sohulen yóm bnék hyu bè dnaduhen, duhen yóm Ngà Tau. ");
INSERT INTO tblNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ne yóm dnadu, hningónen yóm klamangen benwu. Ne yóm bnék hyu yó, duhen yó kem tau deng nogot Dwata. Yó hningón yóm kluon gbol lemen, duhen yó kem tau deng nogot Seitan. ");
INSERT INTO tblNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ne yóm hohon smohul du yó, duhen Seitan. Yóm deng kgefet yóm halay, hningónen yóm hol són kdaw. Ne yó kem tau muta, duhen yó kem hógów Dwata gu bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bè yóm kekdut le yó kem kluon gbol lemen, ne yóm ktem le kul, hol lómón yó se yóm angat kmoen bè yóm hol són kdaw. ");
INSERT INTO tblNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Angat dók yóm Ngà Tau yó kem hógówen gu bè longit anì gotu kó le yó kem kdéen tau gel mit kem dumu le mò sidek, dalang se yó kem dumu tau gel mò sidek, gotu kó le lu. ");
INSERT INTO tblNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gotu tudà le lu elem lanaw ofi. Ditu gónó le heslaf dmumu mkik, ne sembéhé kakim. ");
INSERT INTO tblNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Okóm kul yó du kem kun tau Dwata, hol lómó angat keslinang le mata kdaw ke sok le deng kól ditu bè yóm benwu nogot Mà le bè longit. Yóm tau wen klinguhen, hol hmungol.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Sotu gónó tekuy e hmingón du yóm kogot Dwata tau,” mon Jisas, “hol lómón ke yóm kimu labi deng tódô ton yóm sotu tau talak yóm dnadu, yóm kimu tehe lebeng yó kem tau gnan ekni. Bè yóm ktonen du, bud lebengen se kun. Ya tey kligalen mulék. Tódô gotu himot hbaluen yó kem kdê nô béléen anì geblihen yóm tonok gónón mton yóm kimu labi.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Sotuhen,” mon Jisas, “sotu gónó tekuy e hmingón du yóm kogot Dwata tau, hol lómón ke yóm sotu tau mebel yóm kimu libun alì mebtes boluyen pérlas. ");
INSERT INTO tblNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Timbow wen tonen sotu alì tilob, ominen mulék, ne gotu himot hbaluen yóm kdê kendengenen anì geblihen yóm pérlas tonen yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Sotu bud gónó tekuy e hmingón du yóm kogot Dwata tau,” mon Jisas, “hol lómón ke yóm huket tudà le e talak lanaw, ne tey dê kay utón él tawanen. ");
INSERT INTO tblNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Timbow deng hnok yóm huket, omin le demyol du ete kembu. Yó nmò le, sentólóng le yó kem utón tawan huket le. Lemwót yó kem utón hyu, sù le lu lem timbà. Ne fen gotu bot le yó kem utón sidek. ");
INSERT INTO tblNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hol lómón yó se mò kmoen sok kól bè yóm hol són kdaw. Lemwót yó kem hógów Dwata gu bè longit, gotu sentólóng le yó kem tau gel mò du yóm hyu bè yó kem tau gel mò du yóm sidek. ");
INSERT INTO tblNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yó kmò le yó kem tau sidek nmò le, gotu tudà le lu elem lanaw ofi. Ditu gónó le alì heslaf dmumu mkik, ne sembéhé kakim.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Snólók Jisas bè yó kem gel lemolò du, monen, “Gotu glileb ye kô lanen ni kem hningónu ni?” Mon le se, “El, Sér, glileb me.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bud mon Jisas, “Yóm tau gel tmolok hlau gnan, ke deng gfi bè kogot Dwata tau, hol lómón ke du yóm tau wen kimu labihen, ne wen kimu lomihen deng denfélen bè gónóen mò gónóhen gel ma yóm wen muhen du.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Timbow deng gotu deng ktulón Jisas du kul ni kem gel hningónen ni, ominen lemwót bè yóm benwu yó, bud mulék ebè hol kun benwu. ");
INSERT INTO tblNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yóm kkólen bè yó, tódô na a tmolok bè yóm gónó le gel stifun yó kem Ju. Ya tey ketnga le du yó kem tau hmungol du, mon le, “Gónón ma du ketngónen tmolok nim tau ni? Ne gónón lemwót yóm ktulusen mò du yó kem hentaw ton gel nmoen? ");
INSERT INTO tblNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Igoen se du ngà yóm tau gel mò gónô. Ne igò sem Midi du yóm yéen. Ne du se twogu le Jim ne Jusif ne Simun ne Judas. ");
INSERT INTO tblNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne yó kem libunen, nô le gu bè ni. Gónón lemwót de yóm tey khulungen nim tau ni?” ");
INSERT INTO tblNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne yó se gónó le kembê du. Mon Jisas mò kul, “Yóm tugod Dwata, laen kô dù madat du bè yóm hol kun benwu. Dalang se yó kem hol kun fes lówó, là kô nadat le du. Tek són yó kem dumu tau bè tólóng benwu madat du.” ");
INSERT INTO tblNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lemwót bè yóm là kehtahu le du, là holen wen hentaw ton nmò Jisas bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bè yóm kdaw yó, gefet bè Hirod yóm gubérnor bè Galili, yóm gel nmò Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bè yóm kungolen du, monen mò yó kem tau smugung béléen, “Deng duhen yó se yóm Jan tehe gel mabtays, deng bud mowil. Yó gónón wen ktulusen gembek mò du yó kem hentaw ton gel nmoen.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yó gónó Hirod mon du yóm yó, abay se du yóm tehe hekfô ke Jan, lelen hfét du, ne heblangguen. Yó gónón mò du béléen yóm yó, lanen tehe mólów du bè yóm tehe kalawen ke Hirudiyas, yehen yóm twolihen boluyen Filip. Tehe gel monen mò ke Hirod, “Deng nuléhem yóm hlau tekuy yóm kalawem yehen twolihem yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bè yóm kungol Hirod du yóm udél Jan yó, hol kóyóen ke tô kendel hfatayen Jan, okóm likò bè yó kem Ju, abay se dilô le hol tugod Dwata yóm Jan. ");
INSERT INTO tblNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ni se tehe kmoen yóm katay Jan. Bè yóm tehe kkól yóm kdaw gel kehligal le du yóm tehe ksut Hirod, hadal le yóm ngà Hirudiyas libun lem blóng yó kem tey tau deng sbung bè yó. Ya tey kehyu nawa Hirod. ");
INSERT INTO tblNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wen fasaden yóm ngà madal yó, monen, “Balù kihu nóyóem, blayu kóm.” Gloken smafà béléen he. ");
INSERT INTO tblNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lemwót se yóm ngà, snólóken bè yéen ke tedu yóm hnihen bè Hirod. Ne yó mon yéen mò du monem mò ke Hirod, “Kulu Jan dé blayem do, hyónem do te huyów.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Timbow gungol Hirod yóm yó, ya tey sidek kegbeng lemen. Okóm lemwót bè yóm deng safaen bè yóm ngà yó, lel le mungol du yó kem tey tau wen bè yó, yó gónón tódô hemlus du béléen yóm hnihen. ");
INSERT INTO tblNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tahu se, tódô heklengen lihol Jan lem blanggù. ");
INSERT INTO tblNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Omin le mit kuluhen ne hyón le te huyów, blay le bè yóm ngà libun. Ne lemwót se kun, blayen ke yéen. ");
INSERT INTO tblNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lemwót lówó Jan, fen nwa yó kem gel lemolò du, ne lebeng le. Timbow deng kebeng le du, omin le mógów ebè Jisas, tulón le du kdéen. ");
INSERT INTO tblNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bè yóm kungol Jisas du yóm deng glumfak Jan, kewót le bè yó són lu smakay ówóng etu fatu lanaw bè yóm gónón tinof. Ne e gungol yó kem tau yóm kewót le Jisas yó, tódô le lemwót se kul gu bè kul benwu, gotu le tmonok mentad hilol lanaw na le e lenebet Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Timbow dmuung le Jisas, tódô tonen yó kem tey tau wen deng gna ebè yó. Ya tey kkoduhen kul, gotu hkóhen yó kem des le. ");
INSERT INTO tblNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Timbow deng kimel, mógów le ebè Jisas yó kem gel lemolò du, mon le, “Deng kimel ne ni, lelen là moni bè tau nim benwu ni. Dókem lu dé ni kem tey tau ni ebè tu kem benwu hmilol anì na le e bemli ken le.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Omin he,” mon Jisas. “Tódô yu ne hemken kul.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mon le se, “Ê, són nô bélê me bè ni, tek són limu botù mambang ne lewu tedek utón él.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Nit ye edini kun,” mon Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tahu se. Omin Jisas gotu hyón yó kem tau bè yóm gónón ukol bnes. Ne nwahen yóm limu botù mambang ne lewu tedek utón él, ne temngel ebè longit, mni bè Dwata. Ominen kembéng yóm mambang, ne oguhen yó kem gel lemolò du anì sagid le ebè yó kem tau. ");
INSERT INTO tblNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tódô kdê le se gotu mken ne gotu le bsow. Timbow deng kken le, gotu sentifun yó kem gel lemolò ke Jisas yóm lukas ken le, botong sfolò lewu abì. ");
INSERT INTO tblNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yó kwen kem logi mken, botong limu libu. Là homong nsó le du kem libun ne kem ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kogolen bè yó, gotu hotun Jisas elem ówóng yó kem gel lemolò du, hegnahen lu efatu lanaw, ominen yó hulék yó kem tau. ");
INSERT INTO tblNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Timbow le deng gotu lemwót, lemwót se ke Jisas kun elem bulul tek sotuhen lanen na a mni bè Dwata. Ngangen nô bè yó lem bulul efet kifu tek sotuhen. ");
INSERT INTO tblNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Blaem yóm ówóng snakay yó kem gel lemolò du, deng kól talak lanaw. Ya tey keglayam le nan e senlong lu yóm tey lenos bong. ");
INSERT INTO tblNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Song sut bélê le Jisas deng móyón mwas, tódô mógów ta él ebélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bè yóm kton le du yóm kógówen ta él, ya tey sidek klikò le, ofo kul mon du ke busaw. Botong le gotu lemangat. ");
INSERT INTO tblNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Omin Jisas kendel mudél ebélê le, monen, “Hgel ye nawa ye dé. Ou ni. Bê ye abay hlikò.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hebkó se ke Pitér, monen, “Ó Sér, ke tahu uu se yó, hógówem o edyó kun ta él.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Géhéli sen,” mon Jisas. Mung tódô kekmó Pitér ta yóm ówóng le, tódô mógów ta yóm él etu bè Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Okóm timbow gnómen yóm tey kgel yóm lenos, tey sidek klikoen, ne tódô sen-gengen se tô lemneb elem él. Ne botong gdawaten Jisas, monen, “Tnóbóngem o, Sér.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Omin Jisas kendel kemfô du bè sigelen, monen, “Tey udì kehtahuhem nim uu. Moen du ke megewu nawam do?” ");
INSERT INTO tblNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ne omin le motun elem yóm ówóng, ne tódô teflok se yóm lenos. ");
INSERT INTO tblNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yó kem dumu gel lemolò ke Jisas nô lem yóm ówóng yó, botong tud le bukol le bè soluhen, mon le, “Tahu uu se yóm Ngà Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngang le mówóng efet le dmuung fi fatu yóm lanaw bè yóm benwu boluyen Ginésarit. ");
INSERT INTO tblNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bè yóm kkól le bè yó, tódô kendel dilô le se Jisas yó kem tau bè yó, ne omin le gotu hetngón du bè yó kem benwu hmilol yóm deng kegdek Jisas bélê le. Tahu se, gotu nwit le ebè Jisas yó kem tau gemnóm des bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Henkodu le béléen baluen ke olo le gemdù kilil nesen yó kem tau gemnóm des. Tahu se, tódô kdéen tau gotu mdù nesen, tódô le gotu bud hyu. ");
INSERT INTO tblNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ne wen kem Farisi ne yó kem gel tmolok hlau mógów ebè Jisas, lemwót le bè syudad Jirusalim. Wen snólók le béléen, mon le, ");
INSERT INTO tblNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Moen de kul yó kem gel lemolò kóm ke là lolò le du yó kem hlau yó kem tehe fù tekuy ekni? Là dog le na molob tdok gu laan le là deng mken.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bnalà Jisas se lu, monen, “Wen se do snólók bélê ye. Moen se kuy du ke là lolò ye du yóm hlau Dwata, mom yó lolò ye yóm hlau lenbù nmò ye? ");
INSERT INTO tblNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Igò Dwata se mon du bè Sulaten, ‘Nadatem maem ne yéem.’ Ne sotuhen, ‘Yóm tau ke sidek kbaken ebè maen ne yéen, tódô hnatay kmò du.’ ");
INSERT INTO tblNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Okóm yóm kuy gel tolok,” mon Jisas, “là kóen sidek kun ke mon te bè kem tuha tekuy, ‘Yóm tô blayu kuy, deng mom blayu ke Dwata.’ ");
INSERT INTO tblNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bè yóm ktolok ye yó, là kóen sidek ke là bud nadat te kem tuha tekuy. Ni se gónón gfan yóm klaen dù mu ye du yóm hlau Dwata. Són lolò ye yóm kuy hlau lenbù nmò. ");
INSERT INTO tblNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tey tau hemtedeng knô nim yu. Deng yu se gónón e gbak yóm tehe udél Isaya, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Són bè sumóng gónó le madat do ni kem tau ni, mon Dwata, okóm yóm nawa le tey mayuk béléu. ");
INSERT INTO tblNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Laen kô dù muhen yóm gel ktaba le ebéléu, abay se són hlau lenbù nmò tau yóm gel tolok le, okóm bè ktolok le du, hol lómón ke hlau lemwót béléu.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ne bud senbung Jisas ebéléen yó kem tey tau wen, monen mò kul, “Ni hol hnungol ye anì tngón ye. ");
INSERT INTO tblNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Là kóen lemwót bè yó kem kihu sungit yóm tau mit du là mólós bè Dwata. Okóm yó mit du là mólós, duhen yóm sidek kebkó gel btang bè sumóngen.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kogol yóm kudél Jisas yó, mógów le ebéléen yó kem gel lemolò du, ne mon le mò du, “Tey sidek kebut le kóm yó kem Farisi tu koni lemwót bè yóm monem ebélê le.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ne bnalà Jisas lu, bede hningónen, monen, “Yóm hulu là kun hulu du yóm Mà bè longit, angat tódô kenduten. ");
INSERT INTO tblNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tódô bayà ye lu yó kem Farisi yó. Hol lómón ke tau le butô tô nalak le kem dumu le butô. Ke salak honon butô, kaem angat le gotu geblos elem sol.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Omin Pitér mudél ebè Jisas, monen, “Tulónem kum dé lanen yóm deng monem là mólós yó koni.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mon Jisas se, “Ilóem laen deng tngón ye kô kuy senta yó kem dumu tau? ");
INSERT INTO tblNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Là tngón ye du kô balù kihu sungit yóm tau, tódô hlós elem blututen, ominen yó bud gel lemwà gu lem lówóhen. ");
INSERT INTO tblNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Okóm yóm sidek kebkó gel btang bè sumóng yóm tau, hono lemwót lem hendemen, ne yó se mit du là mólós bè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kdê yó kem nmò sidek, hono lemwót bè kehedem tau, lómón yóm monok, ne mdà yehen, ne mò samuk, ne mnagaw, ne mò kéng, ne yóm tódô gel semtulón dumu tau. ");
INSERT INTO tblNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yó se yó kem nmò gónó tau là mólós bè Dwata. Tek élél yóm là na kolob tdok gu laan là deng mken.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bud kewót Jisas bè yó, hlós ebè yóm benwu moni bè Tayal ne Sidon. ");
INSERT INTO tblNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Timbow le kól bè yó, wen sotu libun là Juhen lemwót bè yó mógów ebéléen, libun semfu gu bè tau Kanan. Tódô hgelen udélen tmaba ke Jisas, monen, “Ó Sér, sfu tehe Dabid, hol knoduhem ou. Wen yóm ngau libun lengel matahen, ne tey sidek kehlayamen du yóm gel malak du.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Okóm bà sekteb ke bnalà Jisas. Omin le mógów ebéléen yó kem gel lemolò du, mon le mò du, “Yake tódô hulékem yóm libun yó, sónmoen tendo hebnes huli tekuy.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Omin Jisas mudél ebè yóm libun, monen, “Tek són ebè yó kem tau Israél gónó Dwata e hógów dou, yakà mkél le bè yó kem ubiha tabag.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Okóm tódô hegluduk bè ti Jisas yóm libun yó, monen, “Hol tnóbóngem o sen, Sér.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bud bnalà Jisas, bede hningónen, monen, “Là hyu mbot du bè kem ohu yóm kul ken kem ngà.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bud mon yóm libun, “Tahu se yóm monem yó, Sér. Okóm balù yó he kem ohu, sal gel ken le yó kem ubang ken gel btang gu te lemisa yóm tau funen.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Omin Jisas mon du mò du, “Tey bong kehtahuhem, Lenibun. Yó ne, deng gutahem ne yóm hnihem béléu.” Tahu se, tódô sen-gengen se mkó des yóm ngà yóm libun yó. ");
INSERT INTO tblNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bud kewót Jisas bè yó mentad hilol Lanaw Galili, ominen hlós elem bulul, ne myón bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bè yóm knóen bè yó yó, tey dê tau bud mógów ebéléen. Gotu nit le ebéléen yó kem tau tugô, ne yó kem tau butô, ne yó kem tau tiked, ne yó kem tau umew, ne tey dê kem dumu tau gemnóm des snéen. Gotu sù le lu klohok ti Jisas, ne gotu kóhen se yó kem des le. ");
INSERT INTO tblNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tey ketnga le du yó kem tau yóm kton le yó kem umew bud le gudél, yó kem tau tiked gotu bud hyu, ne yó kem tau tugô gotu bud mekteng kógów le, yó kem tau butô gotu bud mton. Ya tey kdóyón le ke Dwata, yóm kul gónó hemtahu yó kem tau Israél. ");
INSERT INTO tblNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Omin Jisas tmaba ebè yó kem gel lemolò du, ne monen mò kul, “Tey klayuk nawahu kul ni kem tau ni. Deng tlu kdaw le ni ne nô béléu bè ni, laen kô dù bud ken le. Ne là se móyóe tódô hulék kul là mken, kô lenmek le gu bè lan.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mon yó se kem gel lemolò du, “Bang tô gónó tekuy ma du mò hken kul bè nim benwu laen hol tau menwu du ni yó kem tey tau wen ni?” ");
INSERT INTO tblNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bud mon Jisas se, “Hilu botù de mambang nô bélê ye?” Mon le se, “Tek hitu botù ne wen ngà utón élen.” ");
INSERT INTO tblNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Omin Jisas gotu hyón kul yó kem tey tau wen. ");
INSERT INTO tblNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne nwahen yóm hitu botù mambang ne yóm udì utón él, ne nan mni bè Dwata. Tikóng deng knihen, ominen kembéng du, ne hsagiden yó kem gel lemolò du. ");
INSERT INTO tblNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gotu le mken kdê le, ne tódô le gotu gemtu. Timbow deng kken le, gotu sentifun yó kem gel lemolò du yóm lukasen, botong hitu abì. ");
INSERT INTO tblNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yó kwen tau mken, botong fat libu logi, là homong nsó le du kem libun ne kem ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Omin Jisas gotu hulék yó kem tau. Lemwót kun bud motun elem yóm ówóng, mógów etu bè yóm benwu glem lem Magadan. ");
INSERT INTO tblNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sotu kdaw bè yó, wen yó kem Farisi ne yó kem Sadyusi mógów ebè Jisas na le e tô tnilów, mon le mò du, “Moi kum kun yóm hentaw ton mò gónó me hemtahu du yóm khógów Dwata kóm.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Okóm yó balà Jisas kul, monen, “Ke deng sdef kdaw, sal gel mon ye, ‘Angat mnóng kdaw ke haya, yakà hulô but longit.’ Ne tahu se. ");
INSERT INTO tblNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne ke hlafus, sal gel mon ye, ‘Angat kmulón ni kdeng, yakà hulô but longit.’ Ne tahu se. Tey ye hulung milô du yó kem gel ton ye bè longit, mon Jisas. Okóm là hulung ye temnef du yóm dê hton Dwata kuy nim kmoen ni. ");
INSERT INTO tblNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hol monu sidek tau nim yu! Bà udì ke wen nawa ye ebè Dwata. Móyô ye kô ke wen hentaw ton nmou lem blóng ye? Laen kô dù bud nmou ne, tek són nmou lem blóng ye, són yóm hentaw ton tehe ton le bè Juna ekni.” Ominen tódô tmagak kul. ");
INSERT INTO tblNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Timbow le deng kól fi fatu yóm lanaw le Jisas, tódô gbel bè nawa yó kem gel lemolò du yóm klaen dù mambang nit le mò bnotu le. ");
INSERT INTO tblNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne wen udél Jisas ebélê le, monen, “Hol ten-gama ye yóm kul bulung henok mambang yó kem Farisi ne yó kem Sadyusi.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Stulón le són lu yó kem gel lemolò du, mon le, “Yó dô gónón mon du yóm yó, yakà klifót tekuy du mit mambang.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tódô tngón Jisas yóm sentulón le, yó gónón mon du mò kul, “Moen de ke sentulón ye yóm là kegwit ye bnotu? Tey udì kehtahu ye. ");
INSERT INTO tblNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Efet ni he là deng glileb ye du dilóu yóm gel nmou. Hentulón ye nawa dé yóm kekbéngu limu botù mambang bè yóm limu libu kem logi, hilu abì de lukasen deng sentifun ye? ");
INSERT INTO tblNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ne yóm le kekbéngu hitu botù mambang bè yóm fat libu kem logi, bud hilu abì lukasen? ");
INSERT INTO tblNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Là kô na e mambang du tendoken yóm tulónu yó koni. Mò ye là gmileb du du yóm monu? Hol ten-gama ye yóm kul bulung henok mambang yó kem Farisi ne yó kem Sadyusi.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Omin le yó he temngón du sundu bulung henok mambang du yóm tendoken, okóm yóm kul ktolok yó kem Farisi ne yó kem Sadyusi. ");
INSERT INTO tblNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bud kewót Jisas bè yó, hlós le etu bè yóm benwu moni bè yóm syudad boluyen Seseriya Flipay. Bè yóm kkól le bè yó, snólók Jisas yó kem gel lemolò du, monen, “Tedu de kul kmò kehedem du yó kem dumu tau yóm Ngà Tau?” ");
INSERT INTO tblNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mon le se, “Wen se mon du, Jan kun yóm tehe mabtays. Mon kem dumu, Ilaydya kun. Sotu tô kmon le du, Jirimaya kun, duhen ke wen bè yó kem dumu tugod Dwata ekni.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ne mon Jisas se mò kul, “Kmò kuy se du? Tedu se kuy kmò kehedem do du?” ");
INSERT INTO tblNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Fen bnalà Simun Pitér, monen, “Uu se yóm Misaya, yóm Ngà yóm Dwata laen kô dù tul katayen.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mon Jisas se mò ke Pitér, “Tey hyu kóm Simun ngà Jan, abay se là lemwóten bè tau yóm kdilóem do, okóm tódô lemwót bè Mà bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ni tódô tulónu kóm, lemwót bè yóm udélem yó gónóhu moluy kóm Pitér, yó lanen botu. Ne bè nim botu ni gónóhu mbut hbegel yóm kehtahu le béléu yóm kdéen tau hemtahu bè klamangen benwu. Balù yóm hatay, là kô gatuen kul. ");
INSERT INTO tblNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yó hmou kóm, blayu kóm yó kem kunsì bè yóm kwalisem bè yóm benwu nogot Dwata. Yó se nmò kenbéem talak tonok, yó se angat bud kenbê Dwata bè longit snéen. Ne yó se nmò là kenbéem du, là se kenbê Dwata du bè longit.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tey mget ktulón Jisas du yó kem gel lemolò du anì là tulón le du bè dumu tau ke du yóm Misaya. ");
INSERT INTO tblNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nbuten bè yó ne, tódô gel hnakang Jisas tmulón du bè yó kem gel lemolò du yóm angat keglayamen, monen, “Là gbeku du ke là mógówe ebè Jirusalim. Bè yóm kkólu bè yó, angat hnayam le o yó kem tuha gónó tekuy gel galak, ne yó kem tau geta gel demsù ebè Dwata, ne yó kem tau gel tmolok hlau. Ngang le mò du efet hfatay le ou. Okóm bè getluhen kdaw, angat bud hlowil Dwata o.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Omin Pitér mit ke Jisas hlayuk udì, ne bnólówen, monen mò du, “Teya he yó, Sér. Yake béen dohò kut yóm monem yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Beklil se Jisas ebè Pitér, monen, “Hlayuki béléu, Seitan. Béem tô henseng yóm nógówu. Là kóen lemwót bè Dwata yóm kehedemem yó, kaem kehedem tau te tonok.” ");
INSERT INTO tblNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ne bud mon Jisas mò yó kem gel lemolò du, monen, “Ke wen tau móyô lemolò do, song hyu ke tódô tebelen yóm kun kóyô, ne eles tnihangen yóm kun kros, ne ominen yó lemolò do. ");
INSERT INTO tblNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yóm tau ke knamaen klowilen, angat lana béléen yóm klowilen yó. Okóm yóm tau ke là knamaen du klowilen lanen lemolò do, angat gutahen yóm klowil laen dù sónen. ");
INSERT INTO tblNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Anien he yóm tau ke gotu gfunen klamangen benwu, laen kô dù ofolen du yóm deng gfunen yó ke lana béléen yóm klowil laen dù sónen. Ke lana béléen yóm klowil yó, laen kô dù bud gónón ma du yóm mò tlesen. ");
INSERT INTO tblNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yakà angaten bud semfulék edini yóm Ngà Tau,” mon Jisas. “Bè yóm kesfuléken yó, gfan béléen yóm tey kegeta Maen, ne gotu le mung du yó kem gel hógów Dwata gu bè longit. Bè yóm kdaw yó, tódô gotu blayen yó kem tau yóm balà yóm tehe deng gel nmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tódô tulónu kuy ktahuhen, angat wen he bélê ye bè ni gmafit mton du yóm bud kesfuléken edini yóm Ngà Tau mò kmamal yóm klamangen.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Timbow deng bud nem kdawen bè yó, lemwót Jisas mneged ebè yóm sotu bulul geta, nwiten Pitér ne yó kem lewu tau setwoli Jim ne Jan, tek sónen lu. ");
INSERT INTO tblNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bè yóm knô le bè yó, tódô sfili kton le ke Jisas. Yóm lem uyóhen hol lómón nóng mata kdaw, ne yóm nesen tódô gotu sminang bukay. ");
INSERT INTO tblNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne tódô hetnga ton le se Musis ne Ilaydya, stulón le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mung tódô kudél Pitér ebè Jisas, monen, “Hyu ni, Sér, deng me nô bè ni. Ke móyói, hdae tlu lowig, sotu kóm, sotu ke Musis, sotu se ke Ilaydya.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yóm igò Pitér tolo mudél, tódô lememek eta le yóm tey lobun sminang bukay, tódô gungol le yóm mudél gu lemen, monen, “Ni se hol dou Ngà, gónón nô nawahu. Tey kligalu béléen. Hol gel hnungol ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bè yóm kungol le yóm udél yó, tódô le gotu hegluduk lemfen bè tonok yó kem tau mung ke Jisas, ya tey sidek klikò le. ");
INSERT INTO tblNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Okóm mógów ebélê le Jisas, ne nenoken lu, ne monen mò kul, “Mdà ye dé. Bê ye mom hlikò.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Omin le tukóng eta, laen kô dù bud tau ton le, tek són Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bud kewót le bè yó, mulék le mosol. Tey kget kmon Jisas du mò kul, “Hol bê ye tagad tulón yóm deng ton ye yó koni ke là nan na mowil yóm Ngà Tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Snólók le bè Jisas yó kem tau mung du yó koni, mon le, “Tahu kô yóm gel mon yó kem tmolok hlau, nan gna kól he yóm tehe Ilaydya, ominen kól yóm Misaya?” ");
INSERT INTO tblNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bnalà Jisas se, monen, “Tahu se yó, nan gna kól yóm Ilaydya mò eles hemtifes yóm kdéen. ");
INSERT INTO tblNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Okóm tódô tulónu kuy,” mon Jisas, “deng sut se Ilaydya, okóm laen kô dù tau dmilô du. Tódô nmò le béléen yóm kul knóyô. Senged se yóm angat nmò le bè yóm Ngà Tau, angat tey kehlayam le du.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ne tódô tngón yó kem tau mung du yó, ebè Jan yóm tehe gel mabtays gónón gbak yóm tulón Jisas ni. ");
INSERT INTO tblNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tikóng le deng bud semfulék ebè yó kem tey tau sbung le Jisas, wen sotu tau sut béléen, tódô tuden bukolen bè soluhen, monen mò du, ");
INSERT INTO tblNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ó Sér, hol knoduhem yóm ngau, wen desen snidaf. Ya tey sidek kehkengkelen ke sok gel sut béléen. Wen se gónón gel mugod elem ofi duhen elem él. ");
INSERT INTO tblNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Deng nitu ebè yó kem gel lemolò kóm, okóm là gbek le du.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Omin Jisas mudél, monen, “Yu kem tau kmoen ni, alì ye hemda. Gel sekban yóm kehedem ye. Deng tey kegenu ne nô lem blóng ye, ne deng tey kehlawihu nawahu bélê ye. Nitem edini kun yóm ngaem.” Tahu se, niten ebéléen. ");
INSERT INTO tblNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tódô hdó Jisas yóm gel malak yóm ngà yó, ne sen-gengen se tódô hyu yóm ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kogolen bè yó, mógów le ebè Jisas yó kem gel lemolò du, tek són lu, mon le mò du, “Moen de kum ke là gbek me hdó yóm tulus seitan malak tum ngà tu koni?” ");
INSERT INTO tblNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mon Jisas se, “Abay se tolo udì kehtahu ye. Tódô tulónu kuy ktahuhen, ke bnotù tekuy yóm kehtahu ye, anien ke olon senged bè kutit yóm lem hulu boluyen mustard, botong gbek ye tódô mon du bè yóm bulul nii, ‘Milihi etuu.’ Nénégem kà tódóen mili. Laen kô dù là gbek ye du. ");
INSERT INTO tblNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Okóm yóm tulus seitan malak yóm ngà yó koni, tek sotu hdó du, tek són yóm kni ye bè Dwata, mung du yóm kfasting ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sotu kdaw bè yó, gotu le stifun bè Galili yó kem gel lemolò ke Jisas, ne mon Jisas mò kul, “Angat blay le elem tdok yó kem tau yóm Ngà Tau ");
INSERT INTO tblNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","mò hfatay le. Okóm bè getluhen kdaw, bud hlowil Dwata.” Bè yóm ktulón Jisas du kul nim ni, ya tey sidek keblat nawa le du yó kem gel lemolò du. ");
INSERT INTO tblNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Timbow le gefet bè Kapérnaum le Jisas ne yó kem gel lemolò du, wen kem tau fen gel mtuk yóm bayad bè Gónô Dwata kól bè Pitér, snólóken, monen, “Gel mayad kô kun yóm tau gónó ye gel htolok yó?” ");
INSERT INTO tblNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mon Pitér se, “Igò se.” Kewót Pitér bè yó, husek elem gónô le. Unihen husek, tódô kendel wen snólók Jisas béléen, monen, “Ó Simun, tedu kóm kehedem du nim ni? Bè ni te tonok, tau du se fen gel mayad bwis bè yóm tau hol geta, kem ngaen kô, duhen ke yó kem tau knamalen?” ");
INSERT INTO tblNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bnalà Pitér se, monen, “Yó kem tau knamalen.” Mon Jisas se, “Ke lómón yó, là dog le mayad ne yó, yó kem hol kun ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Okóm là hyuhen ke hebut tekuy lu ni kem tau mtuk ni. Yake lemwóti dé ebè lanaw na a dmulé. Nwahem yóm utón él tanay semkot ne yóm filak mgel tonem lem baken, yó se mò kut bayad lewu te.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bè yóm kdaw yó, mógów le ebè Jisas yó kem gel lemolò du, snólók le béléen, mon le, “Tau du se hol geta bè yó kem tau nogot Dwata?” ");
INSERT INTO tblNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bè yóm kbalà Jisas kul, wen ngà tnabahen ebéléen, hdaen lem blóng le, ");
INSERT INTO tblNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","monen, “Ngem nim ngà nii, là kô ktesen du yóm kegetahen. Tódô tulónu kuy ktahuhen,” mon Jisas, “ke là tenles ye du yóm kuy kehedem lómón yóm kun kehedem nim ngà ni, là kô ye na a gmung bè kogot Dwata tau. ");
INSERT INTO tblNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Duhen yó, yóm tau là hegetahen knóen bè kem dumuhen lómón yóm kun nmò nim ngà nii, du se yóm hol geta bè yó kem tau nogot Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ne ke wen tau hmódó yóm sotu ngà lómón yóm ngà nii mlan bè dou boluy, lómón se ke o ne yóm hnódóhen.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bud mudél Jisas, monen, “Ke yó nmò yóm sotu tau, ke lemwót béléen gónóhen là bud hemtahu béléu yóm sotu ngà, mom hyu bè yóm tau yó he ke tódô bot elem mohin gu laanen là deng wen ngà hebtangen, tléwéng bè liholen yóm botu bong gónó le gel gmaling mò heblaten etlaan. ");
INSERT INTO tblNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tey kodu le yó kem tau talak tonok, abay se tey dê mit kul là hemtahu. Sal gel sut bè tau se yóm yó, okóm angat tey tafaken yóm tau mò du. ");
INSERT INTO tblNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yó gónóm mon, ke doli sigelem duhen ke doli tihem mit kóm là hemtahu, hyu ke tódô kenlengem, ne botem. Mom hyu béléem he ke lana béléem doli tihem duhen ke doli sigelem syan ke gutahem yóm klowil laen dù sónen. Laen kô ofolem du yóm klewu tihem ne klewu sigelem ke deng mom niten uu elem lanaw ofi, yóm ofi laen kô dù tul katayen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ke sotu matahem mit kóm là hemtahu, tódô lensitem, ne tudaem. Mom hyu béléem he ke lana sotu matahem syan ke gutahem yóm klowil laen dù sónen. Laen kô dù ofolem du yóm klewu matahem ke deng mom tudà le uu elem lanaw ofi.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hyu ke béen abay wen hen-gnok ye bè ni kem ngà nii. Tódô tulónu kuy, eles wen yó kem hógów Dwata tendo gel nô bè Mà bè longit fen gel semgyok kul. ");
INSERT INTO tblNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yó hol nógówen elem benwu yóm Ngà Tau, nan e tnóbóng yó kem tau deng lana. ");
INSERT INTO tblNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mò kehedem ye du se kuy? Ke wen tau mfun lematu ubiha, mò kmoen du de ke sotu lana bélê le? Ngem kà nan na tebel du yó kem syóm folò syóm bè yóm gónón hótób kul talak bilil nan e hnebel yóm sotu tabag bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bè yóm ktonen du, tey kligalen. Tódô tulónu kuy ktahuhen, tey bong he kligalen du yóm sotu lana deng tonen senta yó kem syóm folò syóm là lanahen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Senged se knawa yóm Mà tekuy bè longit. Là kóen móyô ke sotu bè yó kem ngà lómón ni ke tô lana bè soluhen.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ke wen gónón gemsalà béléem yóm dumuhem hemtahu, tódói mógów ebéléen, ne sentulón ye són yu lewu ye yóm salaen béléem. Ke hnungolen uu, bud mulék hyu yóm keswè ye. ");
INSERT INTO tblNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Okóm ke là hnungolen kóm, miti sotu duhen ke lewu tau mò dumuhem bè yóm bud kógówem ebéléen anì gloloem yóm deng monen bè Sulat Dwata, yóm monen, ‘Ke wen gónóm tmifù dumum tau, hyu ke wen lewu duhen ke tlu tau mò fen hmungol du yóm monem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Okóm ke là dog hnungolen kul, tódô gotu tulón ye yóm kdéen bè gónó le gel stifun yó kem Ju. Okóm ke là dogen hmungol balù yóm deng kwit ye du bè gónó le gel stifun yó kem Ju, hol lómón kmò ye ebéléen, lómón yóm kmò ye ebè yó kem tau là hemtahuhen bè Dwata, ne bè yó kem dumu tau gemsalà.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tódô tulónu kuy ktahuhen,” mon Jisas, “yó se nmò kenbê ye talak tonok, angat bud kenbê Dwata bè longit snéen. Yó se nmò là kenbê ye du, là se kenbê Dwata du bè longit snéen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ni mò hol sù ye bè nawa ye. Anien ke tek lewu tau mni bè Dwata, ne deng ssotu nawa le mni du yóm hni le, tódô blay Mà bè longit kul yóm hni le béléen yó. ");
INSERT INTO tblNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Baluen he ke tek lewu duhen ke tlu tau stifun mlan bè dou boluy, senged knóu bélê le.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Omin Pitér mógów ebè Jisas, wen snólóken béléen, monen, “Ó Sér, ke sónmoen gemsalà béléu yóm dumuhu, hilu duléku de hmifót du? Hitu duléku kô?” ");
INSERT INTO tblNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Bnalà Jisas se, monen, “Là tek hitu dulékem du, okóm hitu folò duléken hitu kehlifótem du. ");
INSERT INTO tblNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Abay se yóm kogot Dwata tau, hol lómón yóm sotu hningónu ni. Tehe yu ekni, wen sotu tau hol geta kun mtuk bayad bè yó kem tau gel mò nmò béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yó tanay nit le ebéléen yóm sotu tau mutóng deng hilu kati filak. ");
INSERT INTO tblNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Okóm yóm tau ni koni, laen kô gónón ma mò bud bayaden du yóm tey utóngen yó. Yó tódô tô nmò yóm tau hol geta béléen, tódô tô hbaluen mò klifen, mung du yehenen ne kem ngaen, kkólen bè yó kem kimuhen mò mayad du yóm nutóngen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Okóm tódô na a kendel mtud bukol bè solu yóm tau hol geta yóm tau yó, monen, ‘Nam hanay kut nawam, Sér, angat gotu bnayadu he yó yóm utóngu béléem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tahu se, tódô bud mulék koduhen du yóm tau hol geta yóm tau yó koni. Tódô hnifóten béléen yóm utóngen yó koni, ne tódô hewaen snéen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Timbow deng gewà yóm tau yó koni, bud glebeten se yóm sotu dumuhen mò nmò tehe mutóng béléen, bede olo hilu filak yóm kun utóng. Ominen tódô mogot du nan e nmò hemlong du, monen, ‘Géhél bnayadem ou ni.’ ");
INSERT INTO tblNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Okóm yóm dumuhen yó, tódô na a hegluduk bè solu yóm gónón mutóng, monen, ‘Nam hanay kut nawam, Wè, angat gotu bnayadu he yó yóm utóngu béléem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Okóm là kóen dog móyô yóm tau mtuk yó, mom heblangguen efet gbayaden yóm utóngen béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Timbow ton yó kem dumu tau mò nmò bè yóm tau hol geta yó, ya tey sidek kegnóm le du. Omin le mógów ebè yóm tau hol geta bélê le, ne gotu tulón le du kdéen. ");
INSERT INTO tblNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kewót yóm tau hol geta, bud htabahen yóm tau yó koni. Mung ktonen du, monen, ‘Tey hesek laen dù mu yóm uu. Deng hnifótu béléem yó kem tey utóng bongem lemwót bè yóm kehkoduhem béléu. ");
INSERT INTO tblNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Moen de ke là knoduhem du kedumuhem lómón yóm deng dou kkodu kóm?’ ");
INSERT INTO tblNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ya tey sidek kebut yóm tau hol geta yó koni. Tódô heblangguen mò tafaken du efet gbayaden yóm hol són utóngen.” ");
INSERT INTO tblNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Bud mon Jisas, “Lómón sem ni ne angat nmò Mà bè longit bélê ye ket kuy ne sotu ke là tahu hnifót ye yó kem dumu ye gemsalà bélê ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Timbow deng ktulón Jisas ni kem ni, ominen bud lemwót, tnagaken prubinsya Galili, mógów etu bè yó kem dumu benwu bè prubinsya Judiya fi fatu yóm él boluyen Jurdan. ");
INSERT INTO tblNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tey tau wen bud huli du, ne gotu hkó Jisas yó kem gemnóm des bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yóm knóen bè yó, wen kem Farisi mógów ebéléen, wen snólók le béléen mò dalil gónó le dmuón du, mon le, “Là sideken bè hlau tekuy kô ke skó bè yehenen yóm tau balù kihu buten?” ");
INSERT INTO tblNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bnalà Jisas lu, monen, “Deng hónô senfala ye yóm monen bè Sulat Dwata. Bè yóm hol kbuten nmò Dwata yóm tau, logi ne libun. ");
INSERT INTO tblNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yó mon Dwata, ‘Yó gónóm mon, gtagaken maen ne yéen yóm logi ne setnù le yóm tuha libunen, ne baling le ssotu yóm lewu le yó.’ ");
INSERT INTO tblNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yó gónóm mon, là kô le bud stólóng ne yó kem tau syehen, deng le baling ssotu ne. Duhen yó, yóm deng kun sensotu Dwata, béen abay wen tau bud semkó kul.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bud snólók le béléen yó kem Farisi, mon le, “Ke lómón yó, moen se ke tehe snulat Musis yóm sotu hlau, yóm monen, ‘Ke móyô skó bè yehenen yóm logi, nan ne wen sulat gónón fema mò ilô yóm deng kkóhen du?’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bnalà Jisas se, monen, “Yó gónó Musis smulat du yóm hlau yó, lemwót bè yóm alì kehlom nawa ye mò sidek se. Okóm bè hol kbuten, là kô na a kóyô Dwata du se yóm skó bè yehen. ");
INSERT INTO tblNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tódô tulónu kuy,” mon Jisas, “yóm logi ke kóhen yehenen igoen se là mdà du ne ke bud myehen dumu libun, yó nmoen yóm tau yó, deng ndaen ne yóm libun gna yehenen.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mudél le se kul yó kem gel lemolò ke Jisas, mon le, “Ke là se gbek me skó bè yehen me, dog myehen ne yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bnalà Jisas se lu, monen, “Là kdéen du tau gembek du yóm là myehen. Són gónón gembek du ke tódô Dwata mò du. ");
INSERT INTO tblNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sal stólóng se yóm but gónó le là myehen kem tau. Wen se là myehenen, abay se wen iget le lemwót bè ksut le. Wen se là myehenen lan le kmafun kul. Wen se là myehenen lemwót bè kimón le yóm hmò Dwata kul. Yó se tau gembek lemolò du ni kem monu ni, hol loloen.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wen se kem tau mit ngà ebè Jisas anì na le e hnok du, ne anì hnihen lu bè Dwata. Okóm yó kem gel lemolò ke Jisas, mom bnólów le lu. ");
INSERT INTO tblNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Okóm mon Jisas, “Heflós ye lu edini yó kem ngà yó, bê ye abay henseng lu. Abay se yó kem tau nogot Dwata, hol le mkél bè knawa ni kem ngà lómón ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Omin Jisas gotu mnok kul ne mni bélê le bè Dwata, ominen hlós ebè yóm gónón e solu. ");
INSERT INTO tblNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sotu kdaw bè yó, wen sotu tau mógów ebè Jisas, monen, “Ó Sér, wen snólóku béléem. Tedu de yóm hyu mò nmou anì gutahu yóm klowil laen dù sónen?” ");
INSERT INTO tblNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bnalà Jisas se, monen, “Moen de ke snólókem béléu yóm hyu? Tek són Dwata yóm hyu. Ke hendeenem yóm klowil laen dù sónen, hol nimónem yó kem kun hlau Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mon yóm tau yó, “Hlau du de, Sér?” Bud mon Jisas se, “Béi monok. Béi mdà yehen. Béi mnagaw. Béi tmifù kéng. ");
INSERT INTO tblNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nadatem maem ne yéem. Kenbong nawahem kem dumuhem lómón kbong nawahem yóm kóm knô.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bud mudél se yóm lomi tau yó, monen, “Deng gotu lolou yó kem yó, Sér. Tedu de duen?” ");
INSERT INTO tblNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Bud bnalà Jisas se, monen, “Ke móyói hol gulit, tu ne muléki nam e hbalù kdê nô béléem, ne blayem bè tu kem élél yóm blihen. Ke yó nmoem, angat wen tey kendengenem bè longit. Ne lemwót yó dum kóm, loloem ou.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Timbow gungol nim lomi lemnok ni koni yóm udél Jisas ebéléen yó, tódô lemwót, ya tey sidek keblat nawahen, abay se nalihen yóm tey kendengenen. ");
INSERT INTO tblNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Omin Jisas mudél ebè yó kem gel lemolò du, monen, “Tódô tulónu kuy ktahuhen, tey mgel bè yóm tau wen kendengenen ke tô hogoten ke Dwata klowilen. ");
INSERT INTO tblNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bud nulitu bélê ye. Tey mgel bè yóm tau wen kendengenen ke tô hogoten ke Dwata klowilen. Mom mahil he yóm kamél ke hfusek te bè yóm sol dalum.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bè yóm kungol le du yó kem gel lemolò ke Jisas yóm monen yó, tey ketnga le du, mon le, “Ke lómón yó, tau du de gembek gmuta du yóm klowil laen dù sónen.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Temngel ebélê le Jisas, monen, “Ke bè tau, là gbeken du. Okóm bè Dwata, laen dù là gbeken du.” ");
INSERT INTO tblNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Omin Pitér mudél se kun, monen, “Ngem ni dém mi, Sér, glok me tódô gemtagak yóm kdéen lan me lemolò kóm. Bang tô ofol me se kum du?” ");
INSERT INTO tblNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mon Jisas se mò kul, “Tódô tulónu kuy ktahuhen, ke deng kól yóm lomi benwu, ne ke deng bangen myón bè yóm gónóhen myón kmamal yóm Ngà Tau, wen snéen gónó ye myón kmamal bè yó, yu kem sfolò lewu gel lemolò do ni. Angat ye fen mogot kukum bè yó kem sfolò lewu bung tau semfu gu bè yóm tehe Israél. ");
INSERT INTO tblNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ket tau, ke gloken gemtagak gónóen, ne yó kem dumuhen setwoli, ne yó kem tuhahen, kkólen bè yó kem ngaen, duhen ke tonoken lanen lemolò do, lematu dulék Dwata he bud hulék du ebéléen yóm deng gtebelen yó. Ne lelen yó he angat gmuta du yóm klowil laen dù sónen. ");
INSERT INTO tblNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bede angat tey dê bè yó kem tau deng gegna nim kmoen ni, angat le bud ghuli bè yóm kdaw yó. Ne yó kem ghuli nim kmoen ni, angat le bud gegna bè yóm kdaw yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Bud mon Jisas mò kul, “Yóm kogot Dwata tau, hol lómón ke yóm sotu tau lamang grép huluhen. Sotu kdaw, tódô temkifu lemwót na a mebel tau mò nmò bè yóm huluhen yó. ");
INSERT INTO tblNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tahu se, wen tau tonen, ne eles sentulón le gna yóm kmò ksukéyen kul sendaw. Ominen yó hewót kul mò nmò. ");
INSERT INTO tblNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Timbow deng sóól mneged kdaw, ominen bud lemwót ebè fedyan yóm tau fun hulu, wen tau tonen bliwel mdà gu bè yó laen dù nmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne monen mò kul, ‘Ke móyô ye, ne ye e mò nmò béléu bè huluhu. Henyuhu he ksukéyu kuy.’ ");
INSERT INTO tblNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tahu se, na le e mò nmò yó kem tau yó. Timbow deng gtungu kdaw, bud mebel tau yóm fun hulu. Ne bud sóól mosol kdaw, bud yó se nmoen. ");
INSERT INTO tblNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Timbow móyónen sdef kdaw, ominen bud lemwót, ne tolo wen he dumu tau mdà gu bè yó bè fedyan, snólóken bélê le, monen, ‘Moen ke tódô ye mdà bè ni laen dù nmò?’ ");
INSERT INTO tblNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bnalà le se, mon le, ‘Laen dù tau hmò kum nmò.’ Bud monen se mò kul, ‘Mò ye nmò béléu dé bè huluhu.’ Tahu se, na le e mò nmò. ");
INSERT INTO tblNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Timbow deng seklewet bè yó, ominen mon du mò yóm tau snaligen, ‘Tnabahem ne yó kem tau mò nmò, ne snukéyem lu. Gna snukéyem yó kem tau huli sut, ngangen efet kól bè yó kem tau tanay sut.’ ");
INSERT INTO tblNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tahu se, gna bnayaden yó kem tau hol són huli sut. Tódô blayen kul yóm sukéy geblà bè yóm sukéy le sendaw. ");
INSERT INTO tblNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngangen ne snukéyen yó kem tau gna sut bè yó. Ofo kul ke bong kul sukéy, okóm là. Tódô senged se. ");
INSERT INTO tblNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bè yóm kton le du, tey kestulón le du yóm tau fun hulu yó, ");
INSERT INTO tblNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","mon le mò du, ‘Yó kem tau huli sut yó, là dengen legen he yóm kul kmò nmò, hanà tek sotu uras le. Blaem nim kum, deng sendaw me ni ne htanggas bè nóng kdaw, tódô kóem gotu hsengedem sukéy me.’ ");
INSERT INTO tblNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bnalà yóm tau fun hulu yóm sotu tau mudél ebéléen, monen, ‘Ó Wè, là kô lenugihu kóm. Igò tekuy sem deng hyu semtulón du du eginu yóm sukéy ye sendaw. ");
INSERT INTO tblNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nwa ye ne yóm sukéy ye, ne mulék ye. Tódô dou kóyô hsenged du yóm kun sukéy yóm tau huli sut bè yóm kuy. ");
INSERT INTO tblNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ilóem laen dù dou kwalis mò du yóm dou kóyô bè yóm dou filak? Nófô ye kô yóm kkoduhu yó kem tau huli mò nmò?’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne bud mon Jisas mò kul, “Yó kem ghuli ni kmoen ni, angat bud gegna. Ne yó kem gegna ni kmoen ni, angat bud ghuli.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bè yóm tolo ksubô le Jisas ebè Jirusalim, niten hlayuk udì yó kem sfolò lewu gel lemolò du, wen tulónen kul sónen lu, yó monen mò kul, ");
INSERT INTO tblNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ngem nim kógów tekuy ebè Jirusalim ni, sok kuy kól ditu, angat eted le yóm Ngà Tau elem tdok yó kem geta bè yó kem gel demsù ebè Dwata, ne yó kem tau gel tmolok hlau. Yó angat kukum le du, hatay. ");
INSERT INTO tblNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ne angat blay le elem tdok yó kem tau là Ju le. Tey kehlowon le du, ne lel le mfes du, ngangen efet tnutuk le bè kros. Bede bè getluhen kdaw, tódô bud hlowil Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Timbow kogolen bè yó, mógów bè Jisas tuha libun Sibidi, mung du lewu ngaen logi. Tódô tuden bukolen bè solu Jisas, wen tô nóyô hnihen béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ne mon Jisas se mò du, “Moem de?” Monen se, “Wen tô hnihu béléem dé, Sér. Kesok deng kól du yóm kegetahem, kóyóu ke fasadem dou ke angat le myón klohokem ni kem lewu ngau ni, sotu fi bè kwananem ne sotu se fi bè iwóngem.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bnalà Jisas se, bede mudél ebè yó kem lewu ngaen, monen, “Là kô tngón ye du yóm hni ye yó. Gbek ye hembala du kô ke yu gemfà du yóm angat glumfaku?” Mon le se, “Gbek me.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mon Jisas, “Tahu se, angat glumfak ye se yóm dou glumfak. Okóm laen dù kwalisu mélék du yóm tau myón fi bè kwananu ne fi bè iwóngu. Dwata se mò du yóm yó. Deng wen ne eles néléken mò angat hyónen bè yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Timbow gungol yó kem sfolò gel dumu le lemolò ke Jisas yóm hni yó kem lewu tau setwoli yó, ya tey sidek kebut le kul. ");
INSERT INTO tblNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Omin Jisas gotu bud semtifun kul, monen mò kul, “Deng hónô tngón ye ne kul kmò yó kem tau hol geta talak tonok, tey gel kdansók le yó kem tau nogot le. Ne yó kem tau mogot kukum, tey gulé kwit le yóm kukum nogot le. ");
INSERT INTO tblNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Okóm bélê ye kuy, là kô yó du yóm hyu bélê ye. Ke wen sotu bélê ye móyô ke du baling geta bè kem dumuhen, yake hol nô béléen yóm nawa yóm tau gel tóbóng lówó. ");
INSERT INTO tblNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne ke wen bélê ye móyô ke du hol gegna bè kem dumuhen, yó dé kmoen lem blóng ye, lómón ke du yóm klifen ye. ");
INSERT INTO tblNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yakà lómón ni du se yóm kun nmò yóm Ngà Tau. Là kô yó du nógówen edini ke fen na a hdatù lem blóng kem tau. Okóm yó nógówen mò na e tmóbóng kul. Angat hamaen yóm kun klowil mò msok yó kem tey dê tau gu lem hatay.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Timbow le bud lemwót gu bè Jiriku le Jisas ne yó kem gel lemolò du, ya tey tau wen bud mung du. ");
INSERT INTO tblNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne wen lewu tau butô myón bè kilil lan. Tikóng gungol le yóm klan Jisas bè yó, tódô kendel henmung le tmaba, mon le, “Ó Sér, sfu tehe Dabid, hol knoduhem mi.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Okóm deng mom senbólów le lu yó kem tey tau bè yó, mon le, “Bê ye abay hebnes tmaba.” Tnódónem mom hennolì le tmaba, “Ó Sér, sfu tehe Dabid, hol knoduhem mi.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Timbow gungol Jisas yóm ktaba le, tódô hegsud mdà, ne ominen tmaba kul ebéléen, monen, “Tedu de yóm tô hmò ye do?” ");
INSERT INTO tblNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mon le se, “Htonem mi, Sér.” ");
INSERT INTO tblNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ya tey kkodu Jisas kul yó kem tau yó, ominen mnok bè mata le. Tódô sen-gengen se yóm bud kton le, ne tódô henmung lolò le Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ngang le Jisas mógów ne yó kem gel lemolò du efet le moni bè Jirusalim. Deng le gefet bè yóm sotu benwu udì boluyen Bitfid, nô lem henfek yóm Bulul Ulib. Bè yóm kkól le bè yó, wen lewu bè yó kem gel lemolò du hógów Jisas tukô gna kul, ");
INSERT INTO tblNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","monen mò kul, “Mógów ye do etu bè tum benwu udì ditu tuu. Sok ye kól ditu, angat wen ton ye asnu fét hanà malak nati. Tódô ntó ye, nit ye do edini. ");
INSERT INTO tblNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ke wen tau smólók kuy, mon ye, ‘Wen muhen du yóm gónó tekuy mogot.’ Kaem tódô kendel hlusen kuy.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ni se deng gónóhen dohò yóm tehe snulat yóm sotu tehe tugod Dwata ekni, yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hol tulón ye yó kem tau menwu bè Sayun, mon ye, Ngem deng sut yóm tau hol geta bélê ye, tau là kóen hegeta knô, smakay asnu. Snakayen yóm nati asnu.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tahu se, lemwót yó kem lewu hógówen yó koni, tódô nmò le se yóm deng mon Jisas mò kul. ");
INSERT INTO tblNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nalak le ebè Jisas yóm asnu, mung du ngà natihen, afid le du dumu nes le, ne hsakay le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ne tey dê bè yó kem tey tau mung ke Jisas, gotu nból le mulit lan yó kem dumu nes le. Wen se bélê le ma doun koyu, gotu hlasà le mulit lan mò gónó le hegfan yóm kadat le du. ");
INSERT INTO tblNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tódô le gotu mensag yó kem tau tukô gna du ne yó kem fen tukô huli du, mon le, “Hol dóyón tekuy yóm semfu bè yóm tehe Dabid. Dwata he hol tmóbóng du nim tau deng hógówen ni. Hol dóyón tekuy dé Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Timbow deng kól bè Jirusalim Jisas, ya tey ketnga le du yó kem kdéen tau menwu bè yó, snólók le, mon le, “Tmau du de ni?” ");
INSERT INTO tblNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bnalà yó kem tey tau sbung, mon le, “Ni se yóm Jisas, yóm tugod Dwata lemwót bè Nasarit, yóm sotu benwu bè prubinsya Galili.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tódô hlós elem Gónô Dwata Jisas, tódô glohen yó kem tey tau bemli ne yó kem tey tau hembalù lemen. Yó nmoen, nan e gotu lo lu. Gotu lugoden yó kem lemisa yó kem tau gel lemuluk filak. Dalang se yó kem gónó le gel myón yó kem tau hembalù kfati, gotu lugoden. ");
INSERT INTO tblNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mon Jisas mò kul, “Igò Dwata deng mon du bè Sulaten, ‘Yó muhen yóm dou Gónô mò gónó le gel mni ebéléu yó kem tau.’ Okóm,” mon Jisas, “deng mom henbaling ye gónó le nô yó kem tau gel mnagaw.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bè yóm igò Jisas nô bè yó bè Gónô Dwata, tódô le gotu mógów ebéléen yó kem tau butô ne yó kem tau tugô, ne gotu hkó Jisas yó kem des le. ");
INSERT INTO tblNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Okóm yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem gel tmolok hlau, gotu le mom lembut bè yóm kton le yó kem hentaw ton nmò Jisas ne bè yóm kungol le yó kem ngà tendo dmóyón du bè yó lem Gónô Dwata. Yó tendo mon le, “Hol dóyón tekuy dé yóm sfu yóm tehe Dabid.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mudél le ebè Jisas yó kem tau lembut du yó koni, mon le, “Gungolem kô udél tu kem ngà?” Mon Jisas se, “Gungolu se.” Ne bud monen, “Là deng gesfala ye du kô yóm sotu tulónen bè Sulat Dwata, yóm monen, ‘Ó Dwata, balù yó kem ngà kólen bè yó kem ngà tolo hebón, deng tolokem lu anì hol tódô yóm kdóyón le kóm.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Timbow deng yóm kudél Jisas yó koni, ominen tmagak kul, hlós ebè Bitani, ne ditu gónón tungô. ");
INSERT INTO tblNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Timbow hayahen bè yó, tódô bud temkifu Jisas mulék ebè syudad Jirusalim. Yóm tolo knóen bè lan, gnómen ne kbitilen. ");
INSERT INTO tblNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ne wen tonen sotu koyu mdà kilil lan boluyen fig. Omin Jisas mógów etu, nénégen ke wen bunguhen, okóm laen duen, tódô hono doun. Omin Jisas mudél ebè yóm koyu yó, monen, “Nbuten ni là kói na e bud mungu.” Tódô sen-gengen se mékéng yóm koyu yó. ");
INSERT INTO tblNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ya tey kehtaw le du yó kem tau gel lemolò ke Jisas yóm kton le du yó, mon le, “Kiholen kendel tódô gotu mékéng nim koyu ni?” ");
INSERT INTO tblNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mon Jisas mò kul, “Tódô tulónu kuy ktahuhen, ke wen kehtahu ye, ne ke là megewu nawa ye, gbek ye snéen mò du yóm nmou bè nim koyu ni. Là sónen du yó gbek ye, gbek ye snéen tódô mdók nim bulul nii anì mdó bè ni, ne mili elem mohin, botong tódô nimónen yu. ");
INSERT INTO tblNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ke wen kehtahu ye, balù kihu hni ye bè Dwata, guta ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bud mulék ebè Gónô Dwata Jisas. Yóm igoen tolo tmolok bè yó, sut le béléen yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem tuha gónó le gel galak, mon le mò ke Jisas, “Wen kô kwalisem mò du ni kem deng nmoem bè ni? Tau du se bemlay kóm kwalis mò du?” ");
INSERT INTO tblNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bnalà Jisas se lu, monen, “Wen se dou snólók bélê ye. Ke tngón ye balaen, tulónu kuy se yóm gónón lemwót yóm dou kwalis mò du yóm deng nmou bè ni. ");
INSERT INTO tblNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ni snólóku bélê ye. Bè yóm tehe gel kbabtays Jan yó kem tau, gónón lemwót de kwalisen mò du? Lemwót bè Dwata kô, duhen ke tódô lemwót bè kem tau?” Omin le na stulón són lu yó kem tau smólók ke Jisas yó koni, mon le, “Tedu kmò kbalà tekuy du du? Ke mon tekuy se lemwót bè Dwata, dô monen, ‘Moen de ke là hentahu ye du?’ ");
INSERT INTO tblNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ke bud mon tekuy se lemwót bè tau, déke mom wen sidek nmò le bélê tekuy yó kem tau, abay se bè kul kehedem du, hol tau tugod Dwata yóm Jan.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Omin le malà ke Jisas, mon le, “Là kô tngón me du balaen yóm snólókem yó.” Ne bud mon Jisas se, “Ke là tngón ye du balaen yóm dou snólók, là se tulónu du kuy gónón lemwót yóm dou kwalis mò du yóm deng nmou bè ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Omin Jisas bud mon du mò kul, “Tedu de kmò kehedem ye du nim nii? Wen sotu tau lewu ngaen logi. Lemwót yóm mà le, mógów ebè yóm ngaen twogu, ne monen mò du, ‘Ó ngà, nam e mò kut nmò bè gónó mulu grép dé kemdaw ni.’ ");
INSERT INTO tblNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Okóm mom mon yóm ngaen twogu yó, ‘Bée dou.’ Okóm legen udì bè yó, tenlesen hendemen ne tódô lemwót etu. ");
INSERT INTO tblNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ominen bud mógów ebè yóm ngaen són twoli, ne senged se yóm kmonen du. Ne mon yó sem ngaen, ‘El, mógówe kdeng Mà.’ Okóm là sem dogen dohò.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bud mon Jisas, “Mahi du de bélê le mimón ke mà le?” Ne mon le se, “Yóm ngaen twogu.” Omin Jisas bud mon du mò kul, “Tódô tulónu kuy, mom gna mung bè yó kem tau nogot Dwata yó kem tau gel mtuk bwis, ne yó kem libun hdóyón. Là kuy, là kô ye na a gmung. ");
INSERT INTO tblNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngem yó dém le ksut Jan lem blóng ye yóm tau gel mabtays. Tey kehetngónen du kuy yóm lan hyu bélê ye, okóm là kô ye dog himón. Deng mom yó mimón du yó kem tau gel mtuk bwis ne yó kem libun hdóyón. Igò ye sem deng gotu mton du nim ni, ewenem là kô tenles ye du kehedem ye, là kô dog hentahu ye du yóm gel tulón Jan kuy.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ni hnungol ye,” mon Jisas, “wen bud sotu hningónu bélê ye. Wen sotu tau lamang huluhen yóm sotu kay mungu boluyen grép, ne lenabaten gu hilolen. Ne ominen mò yóm angat gónó le kemmes élen, ne nmoen snéen yóm gónô geta mò gónó le gel nô yó kem tau mentey du. Ne mdengen se kem tau hogoten du yóm huluhen, ominen lemwót milo ebè yóm sotu benwu. ");
INSERT INTO tblNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tikóng deng kól bè kbunguhen yó kem huluhen yó, wen kem tau dóken ebè yó kem tau deng tehe hogoten du anì hwit le ebéléen yóm kun bad. ");
INSERT INTO tblNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Timbow le kól ditu yó kem tau dóken, deng mom yó nmò le bélê le, tódô sensogot le lu. Tey sidek kboug le yóm sotun, ne hnatay le yóm sotuhen, ne sentudà le botu yóm sotuhen. ");
INSERT INTO tblNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ominen bud wen tau hógów yóm tau fun hulu yó koni, malù le wadag. Senged snéen kmò le kul yó kem tau mogot hulu. ");
INSERT INTO tblNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bè yóm hol sónen, yó nmò yóm tau fun hulu, tódô hógówen yóm ngaen logi, monen, ‘Kaem ni se yóm nadat le, yakà ngau du.’ ");
INSERT INTO tblNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Okóm timbow ton yó kem tau mogot hulu yóm ngaen yó, mom mon le, ‘Yó nii yóm ngà yóm tau fun hulu. Lemwót kuy ne, na tekuy e hnatay anì gfun tekuy yóm tonok angat nfunen.’ ");
INSERT INTO tblNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tahu se. Tódô sensogot le yóm ngaen, ne tudà le hulé labat ne ditu gónó le hmatay du.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Omin Jisas bud mon du mò kul, “Ke deng kól bè yó yóm tau fun hulu, tedu se angat nmoen bè yó kem tau deng tehe snaligen yó?” ");
INSERT INTO tblNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bnalà le se, mon le, “Angat gotu hnatayen lu yó kem tau sidek nmò le yó, ne bud hogoten tu kem dumu tau hyu keblay le bad bè ket kgefeten.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Omin Jisas bud mon du mò kul, “Tahu se yóm mon ye. Deng gesfala ye kô kuy yóm tehe mon Dwata bè Sulaten, ‘Wen botu deng senkbê yó kem tau hdà gónô, ofo kul ke laen dù muhen. Anì monem, yó se yóm hol tahu botu mò hembegel du yóm gónô hdà le. Yó se yóm deng nmò Dwata, ne tey kehtaw tekuy du yóm nmoen yó.’ ");
INSERT INTO tblNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tódô tulónu kuy,” mon Jisas, “lemwót bè yóm kekbê ye du yóm botu yó, là kô ye bud gmung ne bè yó kem tau nogot Dwata. Yó bud tles nogoten yó kem tau mò du yóm nóyóen. ");
INSERT INTO tblNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yóm botu monu yó koni, ke wen tau btang etahen, tódô gotu mfutul lówóhen. Ne ke wen tau gdilanen, tódô gotu lemuna.” ");
INSERT INTO tblNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ne tódô tngón yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem Farisi yóm kegbaken ebélê le yó kem hningón Jisas yó. ");
INSERT INTO tblNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yó nmò le, tódô tô kendel kenfô le, okóm likò le yó kem tey tau wen sbung bè yó, yakà hentahu le du hol tugod Dwata yóm Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bud wen tulón Jisas kul hlanen bè hlingón, monen, ");
INSERT INTO tblNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yóm kogot Dwata tau, hol lómón yóm tau hol geta, wen ken bong nmoen bè lówó yóm ngaen logi. ");
INSERT INTO tblNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Timbow deng hto yóm butengen mò du, ominen hógów yó kem tau mò nmò béléen anì na le e nangay tu kem tau deng tinoken. Okóm mom là dog le móyô mógów yó kem tau deng tinoken yó. ");
INSERT INTO tblNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ominen wen dumu tau bud hógówen etu bélê le, monen mò kul, ‘Tulón ye kul deng deng ne yóm ken nmou. Deng wen kem safì tnétéu, dalang se yó kem ngà safì mabù, deng gotu tnétéu. Deng gotu deng ne kdéen. Géhél le do edini ne bè nim ken bong nmou bè lówó yóm ngau logi.’ ");
INSERT INTO tblNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Okóm yó kem tau deng tinoken yó, là kô le dog hekmón, mom henlel le yóm kul nmò. Lemwót sotu, mógów ebè numahen, ne lemwót sotu, mógów ebè tindaen. ");
INSERT INTO tblNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne yó nmò yó kem dumu, mom sensogot le yó kem tau dók yóm tau hol geta, deng mom senboug le lu, ne hnatay le lu. ");
INSERT INTO tblNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ya tey sidek kebut yóm tau hol geta. Tódô hógówen yó kem sendaluen nan e hfatay lu yó kem tau monok yó, gotu htemen yóm kul syudad. ");
INSERT INTO tblNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ominen bud tmaba yó kem tau mò nmò béléen, monen, ‘Deng gotu deng ne kdéen. Yó kem tau deng gna tô tinoku, là kóen knóón kken le du kul nim ken nmou ni. ");
INSERT INTO tblNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mógów ye kut bè tu kem lan lamang, gotu tnaba ye kihu tau ton ye ebè nim ken bong nmou.’ ");
INSERT INTO tblNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tahu se, kewót yó kem tau dóken, gotu le mógów ebè tu kem lan lamang, gotu sentifun le yó kem tau ton le. Wen se bélê le kem tau hyu kmò le. Wen se kem tau gel mò sidek. Gotu sentifun le lu efet tódô meskel lem yóm gónô gónó le mò ken bong yó. ");
INSERT INTO tblNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ominen mógów elem blóng le yóm tau hol geta mò ken yó koni nan e kenlô lu. Okóm wen tau tonen lem blóng le bè yó là lemseken yóm nes gel lesek le bè gónô mò ken. Mung kudélen ebéléen yóm tau hol geta yó koni, monen, ");
INSERT INTO tblNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Kmò khusekem elemen kóm du Wè, igoem là lemsek du yóm nes bè gónô mò ken?’ Ne là se kóen gudél yóm tau yó. ");
INSERT INTO tblNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Omin yóm tau hol geta yó, mdók yó kem tau gel mò nmò béléen, monen, ‘Ni nfét ye sigelen ne tihen, bot ye etu bè lewà bè gónón alì kmifu anì bè yó gónón tendo heslaf ne dmumu mkik, ne sembéhé kakim.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bud mon Jisas, “Hol lómón yó se yóm nmò Dwata. Tey dê tau tinoken, okóm là holen wen néléken.” ");
INSERT INTO tblNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bè yóm kungol kem Farisi du yó kem tulón Jisas yó koni, omin le lemwót mebel lan le gemkfô du bè kudélen. ");
INSERT INTO tblNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yó nmò le, wen tau dók le ebéléen, hono kem tau gel lemolò kul, ne wen se bélê le kem kun tau Hirod. Timbow le kól bè Jisas, mon le mò du, “Ó Sér, tódô tngón me sal gel tahu yóm gel tulónem bè yóm kun kóyô Dwata bè tau. Ne laen dù klikoem tmulón du, abay se laen dù tau mtukul henlom nawahem. ");
INSERT INTO tblNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wen tô snólók me béléem,” mon le. “Gsalà bè hlau tekuy kô yóm gel kbayad te bwis ebè Sisar, yóm tau hol geta bè Rom mogot tekuy? Mò kehedemem du se kóm?” ");
INSERT INTO tblNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Okóm tódô tngón Jisas se yóm tô atul le, ne yó monen mò kul, “Tey tau hemtedeng knô nim yu. Moen de ke tô tnilów hnolot ye ou? ");
INSERT INTO tblNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tolok ye do kun yóm filak mgel mò bayad bwis bè yóm tau hol geta yó.” Tahu se, wen tolok le du. ");
INSERT INTO tblNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne yó monen, “Tulad du de nô du nim filak ni? Ne boluy tau du nô du?” ");
INSERT INTO tblNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mon le se, “Sisar.” “Na,” mon Jisas, “ke Sisar se funen, tódô blay ye ke Sisar yóm kun, ne blay ye ke Dwata se yóm kun.” ");
INSERT INTO tblNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ya tey ketnga le du yóm kbalà Jisas kul yó. Tódô le lemwót, tnagak le Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Segeng bè yóm kdaw yó, wen se bè yó kem Sadyusi sut bè Jisas. Ni kem tau ni là kô hentahu le du ke angat bud hlowil Dwata yó kem tau deng matay. ");
INSERT INTO tblNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wen se kul snólók bè Jisas, mon le, “Ó Sér, tehe gel mon Musis, ke matay yóm logi igò le là deng mngà yóm yehenen, yóm twolihen tmodol béléen bud lemolò yóm kun yehen anì wen ngaen béléen mò kun sfu yóm twoguhen. ");
INSERT INTO tblNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na,” mon le, “tehe yu ekni, wen hitu kem logi ssotu sut le menwu lem blóng me. Ne myehen yóm hol twogu bélê le, bede mom kendel matay igoen là deng wen ngà le. Ne yóm twolihen tmodol béléen bud lemolò yóm yehenen. ");
INSERT INTO tblNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Okóm bud matay snéen kun gu laanen là deng wen ngà le. Ne senged se yóm getlu twolihen. Ngang le stufì slolò efet kól bè yóm ghitu le, ne senged gotu katay le. ");
INSERT INTO tblNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ngangen efet matay se kun yóm libun. ");
INSERT INTO tblNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ni snólók me béléem ni,” mon le, “bè yóm angat kehlowil Dwata tau elem hulin kdaw, mahil du bélê le bud gemyehen du yóm libun yó? Blaem deng tehe gotu sentufì le myehen du yóm hitu le.” ");
INSERT INTO tblNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bnalà Jisas se lu, monen, “Tey salà yóm kehedem ye. Yó duónen, là tngón ye du yóm nô lem yóm Sulat Dwata, ne là se tngón ye du yóm kfasang Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bè yóm angat kehlowil Dwata kem tau deng matay, laen kô dù bud angat syehen, abay se angat le mkél bè yó kem hógów Dwata gel nô bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ne bè yóm snólók ye bè angat bud klowil tau, là deng gesfala ye du kô yóm tehe tulón Dwata kuy bè Sulaten? Yóm monen, ");
INSERT INTO tblNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ou se sana kul Dwata le Abraham ne Isak ne Jakub.’ Bè yóm udél Dwata yó gónó ye temngón du yóm deng bud kehlowil Dwata kul. Abay se yóm Dwata, du se Dwata yó kem mowil, là bè yó kem là mowilen.” ");
INSERT INTO tblNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yóm kungol le yóm ktolok Jisas, ya tey ketnga le du yó kem tey tau wen sbung bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Timbow gungol yó kem Farisi yóm klaen dog gmò le bè Jisas yó kem Sadyusi, omin le stifun se kul, ");
INSERT INTO tblNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ne wen sotu bélê le yóm gel tmolok hlau, tô tmilów smólók ke Jisas se kun, monen, ");
INSERT INTO tblNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ó Sér, mahi du bè yó kem hlau Dwata yóm hol bong muhen bè kdéen?” ");
INSERT INTO tblNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Bnalà Jisas se, monen, “ ‘Kenbong nawahem Dwata, yóm gónóhem mogot. Hotuhem nawahem ebéléen, ne hol hendemem yóm kun kóyô.’ ");
INSERT INTO tblNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yó se,” mon Jisas, “yóm hlau Dwata alì bong muhen bè kdéen, yóm hol tanayen. ");
INSERT INTO tblNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne gewuhen yóm alì bong muhen skél du, duhen yóm monen, ‘Kenbong nawahem kem dumuhem lómón yóm kbong nawahem yóm kóm knô.’ ");
INSERT INTO tblNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ni kem lewu hlau Dwata ni, hol kanguy yóm kdê tehe hlau Musis, ne yóm kdê tehe gel htugod Dwata yó kem gna tugoden ekni.” ");
INSERT INTO tblNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ne wen snólók Jisas bè yó kem tey Farisi sbung bè yó, monen mò kul, ");
INSERT INTO tblNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tedu kuy kmò kehedem du yóm Misaya? Gónón gu semfu du?” Mon le se, “Semfu gu bè Dabid.” ");
INSERT INTO tblNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bud mon Jisas, “Okóm tedu kmò kesfuhen gu bè Dabid du? Igò Dabid se tehe moluy du gónóhen mogot, hmonen du yóm Tulus Dwata, ");
INSERT INTO tblNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ni se udél Dwata ebè yóm gónóhu mogot, yó monen mò du, Myóni bè ni dé fi bè kwananu. Angat gotu ndau lu elaan yó kem hmohon kóm.’ ");
INSERT INTO tblNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yóm Misaya myón bè kwanan Dwata yó, yó kboluy Dabid du ‘Gónóhu mogot.’ Tedu se tô kmò klanen du ke mom du yóm bud semfu gu bè Dabid?” ");
INSERT INTO tblNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Laen dù gembalà du nim snólók Jisas ni. Tódô nbuten bè yó ne laen kô dù bud mlos smólók ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bud mudél Jisas ebè yó kem tey tau sbung ne ebè yó kem gel lemolò du, monen, ");
INSERT INTO tblNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yó kem gel tmolok hlau ne yó kem Farisi, wen se kul glal tmolok du yóm hlau Musis. ");
INSERT INTO tblNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yó gónóm mon, hol nimón ye ne hol lolò ye yóm kdê tolok le kuy. Okóm hol bê ye abay lolò yóm kmò kekdol le, abay se olo le beyen tmolok du kuy yóm hlau, là kô lolò le du. ");
INSERT INTO tblNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ya tey sidek keblaten yó kem hlau gel hbô le kem tau, okóm kul, balù gdù, là kô le tmóbóng mit du yóm blat gel hbô le kuy yó. ");
INSERT INTO tblNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tódô kdê yóm nmò le, són hnebel le yóm ksalù tau kul. Ngem dé kbongen yóm Udél Dwata snulat bkes bè uyó le ne bè sigel le, lel le tey htahà hlumfung bè kilil nes le. ");
INSERT INTO tblNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ke bè gónô mò ken, kóyô le ke hol le myón desyung. Dalang se bè gónô gel stifun, kóyô le ke myón le bè gónó le myón yó kem tau hol nadat. ");
INSERT INTO tblNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dalang se ke mógów le ebè fedyan, kóyô le ke hol nadat tau lu ne ke tnaba le lu ‘Tau tmolok.’ ");
INSERT INTO tblNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Okóm kuy du,” mon Jisas, “hol bê ye abay móyô ke tnaba le yu ‘Tau tmolok.’ Kaem gotu ye setwoli yóm kdê ye, ne tek sotu yóm tmolok kuy. ");
INSERT INTO tblNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne hol béen abay wen tnaba ye ‘Mà’ bè yó kem tau genlal ye te tonok. Abay se tek sotu Mà ye, duhen yóm Mà tekuy bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bê ye abay móyô ke tnaba le yu ‘Gónô mogot,’ abay se tek sotu gónó ye mogot, sónen yóm Misaya. ");
INSERT INTO tblNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yóm tau hol geta bélê ye, yake yó dé kmoen lem blóng ye, lómón ke du yóm tau gel mò nmò bélê ye. ");
INSERT INTO tblNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yó se tau hegetahen knóen, angat heglaan Dwata. Okóm yóm tau heglaanen knóen, angat hegeta Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bud mudél Jisas, monen, “Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Lómón ke deng mom kendadu ye yóm bak dól bè yóm kogot Dwata tau. Là se kô ye dog gusek kuy, ne deng mom henseng ye yó kem tau móyô mung. ");
INSERT INTO tblNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Yu se kem tau fen gel smukat yó kem libun bolu anì gfun ye gónô le, lel ye alì gel htahà kni ye bè Dwata. Yó se gónó Dwata alì hemsidek du yóm angat ktafaken kuy. ");
INSERT INTO tblNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Glok ye mifal mohin mógów bè yó kem dumu benwu mayuk na a mebel bà tek sotu tau mò lemolò kuy. Bè yóm kloloen kuy, deng mom mkay senta yóm ksidek yóm kuy nmò yóm kun ksidek nmò. Yó gónóm mon, knóón bélê ye nô lem lanaw ofi. ");
INSERT INTO tblNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Angat tey tafak ye yu kem tau butô tô malak kem dumuhen butô. Bè kuy ktolok, ke wen tau safaen yóm Gónô Dwata, anien ke nuléhen yóm safaen yó, mom mon ye là sideken. Okóm ke yó safaen yóm tahu blówón nô lem yóm Gónô Dwata, mom mon ye là hyuhen ke nuléhen safaen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tey ye nungel, butô ye. Ilóem kmon ye ke bong muhen yóm tahu blówón senta yóm Gónô Dwata. Là kô yó du. Yó gónón baling mólós bè Dwata yóm tahu blówón yó, abay se deng nô lem Gónóen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne bud sotu gel tolok ye, ke safà yóm tau yóm gónô demsù ebè Dwata, bud mon ye là sideken ke nuléhen. Okóm ke safaen yóm dsuen ebè Dwata, gel mon ye là hyuhen ke nuléhen yóm safaen yó. ");
INSERT INTO tblNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tey ye butô. Ilóem kmon ye ke bong muhen yóm dsù ye ebè Dwata senta yóm gónó ye gel demsù du. Là kô yó du. Yó gónón baling mólós yóm dsù, abay se deng nô bè yóm gónó le demsù du ebè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yó gónóm mon, ke safà yóm tau yóm gónô demsù ebè Dwata, gomong safaen snéen yóm dsuen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ke safaen Gónô Dwata, deng gomong safaen snéen Dwata, yóm nô lemen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ke safaen longit, deng gomong safaen ne yóm bangkù gónó Dwata myón kmamal yóm klamangen, ne gomong snéen Dwata, yóm myón tahen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Balù yó kem som lemnaw ye, sana keblay ye ke Dwata yóm gesfoloen. Okóm deng mom knogol ye yó kem hlau bong muhen, duhen yóm hlau bè ktedeng kmò, ne bè keskodu, ne bè kessalig. Laen dù gónón sidek yóm keblay ye ke Dwata yóm kun ólól, okóm bê ye klifót yó dum hol bong muhen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yu kem tau butô tô malak kem dumuhen butô, tey klolò ye du yó kem hlau lemnek, okóm là nimón ye kul yó kem hlau alì bong muhen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Ke hningónu yóm kmò ye, lómón yóm tgayan ne yóm huyów olo ye molob tahen, là lemen. Igoen yóm nô lemen, tódô hono yóm deng gnaga ye lemwót bè yóm keseglom ye. ");
INSERT INTO tblNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tey ye butô, yu kem Farisi. Na ye gna nolob lemen dé yóm tgayan anì baling mólós tahen snéen. ");
INSERT INTO tblNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Hol ye mkél bè yóm lungun tilob bentulà bukay tahen, okóm lemen hono tiol tau matay, hono unged bolok. ");
INSERT INTO tblNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hol lómón yó se yóm kuy kmò. Tey tilob yóm gel hton ye bè tau, okóm yóm lem hendem ye hono kéng ne hono sidek.” ");
INSERT INTO tblNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Angat tey tafak ye yu kem tau tmolok hlau ne yu kem Farisi, yu kem tau gel hemtedeng knô. Tey tilob yóm gel nmò ye bè yóm tehe gónó le lembeng yó kem tugod Dwata ekni, ne tey keheklóón ye yóm tehe gónó le lembeng yó kem tau tehe tedeng kmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne gel mon ye ke tehe ye deng tau se kuy ekni bè yóm kul kdaw le tehe fù tekuy, là kô ye na a gbót se kuy hmatay yó kem tehe gna tugod Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lemwót bè yóm udél ye yó gónón gdilô yóm hol kesfu ye bè yó kem tau tehe mò des yó kem tehe tugod Dwata ekni. ");
INSERT INTO tblNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yó ne, henfu ye yóm nmò tehe nbut yó kem tehe fù ye, yóm là deng gdeng le du. ");
INSERT INTO tblNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ya nim yu kem tau knawa ulal, hono ye semfu gu bè yó kem tau knawa ulal. Tedu kmò kegewà ye lemen du yóm deng kgolu ye elem lanaw ofi? ");
INSERT INTO tblNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tódô tulónu kuy, angat wen kem tau bud hógówu elem blóng ye, yó kem tau tugod Dwata, ne yó kem tau hulung hedem, ne yó kem tau hulung tmolok. Tódô wen bélê le hnatay ye, wen se tnutuk ye bè kros, ne wen se nfes ye lem gónô ye gel stifun, ne mom ktes ye lu ebè yó kem dumu benwu gónó le e mlóy. ");
INSERT INTO tblNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yó angat guta ye du yóm nmò ye yó, gotu duón Dwata kuy yóm tehe katay le bnonok yó kem tau tedeng kmò le, lemwót bè katay Abél bnonok, yóm tau alì tedeng kmoen, efet kól bè yóm kbonok le ke Sikaraya yóm tehe ngà Berakiya. Tódô kem hnatay le igoen tolo mógów lem blóng yóm Gónô Dwata ne yóm gónó le gel demsù ebè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tódô tulónu kuy ktahuhen, angat tnafak Dwata yu, yu kem tau kmoen ni, bè yóm kdê deng tehe matay bnonok.” ");
INSERT INTO tblNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yu kem tau menwu bè syudad Jirusalim, sal gel hnatay ye yó kem tau tugod Dwata, ne hnatay sentudà ye botu yó kem tau hógów Dwata ebélê ye. Deng hilu duléku ne tô móyô sembung kuy, lómó tô kmou kuy, lómón yóm mlon gel kenleken elaan hafaken yó kem ngaen, okóm là kô ye dog móyô. ");
INSERT INTO tblNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yó se gónó Dwata tódô mayà du yóm Gónóen lem blóng ye. ");
INSERT INTO tblNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tódô tulónu kuy, là kô tagad na ye bud ton dou he ke là nan kól yóm kdaw angat kmon ye du, ‘Dwata he hol tmóbóng du yóm tau deng hógówen.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kewót Jisas bè yó, tnagaken yóm Gónô Dwata. Yóm igoen tolo mógów, ten-gafit yó kem gel lemolò du, tolok le du yó kem gónô mteg hmilol yóm Gónô Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Omin Jisas mon du mò kul, “Hol tenngel ye dé yóm kdê ton tekuy ni. Tódô tulónu kuy ktahuhen, angat kól yóm kdawen laen kô dù tebel bè ni kem beng botu nii, tódô gotu lenusok le.” ");
INSERT INTO tblNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ngang Jisas mógów efet kól bè Bulul Ulib, ne myón bè yó. Omin le mógów ebéléen yó kem gel lemolò du, són lu, snólók le béléen, mon le, “Ó Sér, kilón kdohoen yóm deng tulónem kum yó koni? Tedu de ilô me du yóm bud ksutem ne yóm hol són kdaw?” ");
INSERT INTO tblNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Bnalà Jisas lu, monen, “Hol ten-gama ye anì laen dù tau gónó ye gsukat. ");
INSERT INTO tblNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abay se angat dê tau sut tô hlingu béléu. Yó angat mon le, ‘Ou se yóm Misaya.’ Ne tey dê tau gsukat bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Angat wen gungol ye tau sgida moni bélê ye, ne wen sentulón le gida bè dumu benwu mayuk snéen. Okóm bê ye abay hlikò. Ne gotu dohò ni kem ni, okóm là kô yó du he yóm hol són kdaw. ");
INSERT INTO tblNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Angat wen kem benwu mit sgida bè kem dumu benwu. Ne tey dê benwu gónón mbel bitil bong ne linol bong. ");
INSERT INTO tblNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kdê ni kem ni, yó se ayawen yóm móyón kkól yóm hol són kdaw. Hol lómón yóm libun mlutut, sok kmuleng, ayawen sut yóm ngaen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ne angat tey dê tau bè klamangen benwu kmutó nawa kuy lemwót bè yóm klolò ye do. Tódô kenfô le yu, ne tey kehsidek le kuy, ne hnatay le yu. ");
INSERT INTO tblNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bè yóm kdaw yó, angat tey dê tau knogol le kehtahu le. Ne knutó nawa le yó kem dumu le hemtahu, ne glef le ne hekfô kul. ");
INSERT INTO tblNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Angat tey dê tau sut lembù tmugod ke Dwata, ne tey dê tau gsukat bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lemwót bè yóm alì kmò le sidek yó kem tau bè klamangen benwu, angat monol yóm kesbong le nawa. ");
INSERT INTO tblNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Okóm hol ye hbala efet kól bè sónen anì angat guta ye yóm klowil laen dù sónen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bede nan glalag bè kdéen tau bè klamangen benwu he yóm Tulón Hyu gbak ebè yóm kmò kogot Dwata tau anì hol tngón le, ominen yó he kól yóm hol són kdaw.” ");
INSERT INTO tblNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Bud mon Jisas, “Bè tehe kegenen du Danyél ekni, yóm sotu tau tehe gna tugod Dwata, eles tulónen yóm angat mdà bè Gónô Dwata yóm alì sidek knikò, yóm natuen Dwata. Yóm tau semfala du yóm ni, hol hennagien kmò klanen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ke sok kól yóm kdaw yó, eles le tódô mlóy elem bulul ne yó kem tau menwu bè prubinsya Judiya. ");
INSERT INTO tblNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ke wen tau tolo nô bè gónón henos bè gónóen, hol béen tlek bud husek elemen ke mebel mò niten. ");
INSERT INTO tblNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ke wen tau tolo nô bè tnibahen, hol béen tlek bud mulék eta ne ke tô bud mebel kgal mfól mò niten. ");
INSERT INTO tblNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kodu le yó kem libun mlutut bè yóm kdaw yó, ne yó kem libun tolo semlé ngà. ");
INSERT INTO tblNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hol hni ye bè Dwata anì là geblaen bè yóm bulónen sidek kdaw yóm klóy ye yó, ne anì là geblaen bè yóm Kdaw Kehegnô snéen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Abay se angat tey hlayam bong sok sut bélê ye yóm hlayam monu ni. Ni he yóm hlayam alì sidek bè kdéen hlayam deng sut bè tau lemwót bè hol kbut benwu, ne là se kô bud sneefen du ne. ");
INSERT INTO tblNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Okóm lemwót bè yóm kkodu Dwata kul yó kem tau deng néléken, yó gónón là hol hegen du yóm alì hlayam yó. Ke hegenen, bà sotu ke wen tau bud mowil te tonok. ");
INSERT INTO tblNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Hol bê ye abay hentahu ke wen tau mon du mò kuy, ‘Ngem, ni sii yóm Misaya.’ Duhen ke mon le, ‘Deng gdek dituu kun,’ hol bê ye abay hentahu. ");
INSERT INTO tblNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Abay se angat wen yó kem Misaya kéng sut, ne wen yó kem tau lembù tmugod ke Dwata. Angat tey dê hentaw ton hegfan le mò gónó le hol tô smukat yó kem tau deng kun nélék Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Eles tulónu kuy nim ni,” mon Jisas, “anì hol ye getgama. ");
INSERT INTO tblNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Duhen yó, ke mon kem tau, ‘Deng kól bè yóm benwu là hyu menwu du yóm tau deng nélék Dwata,’ bê ye abay mógów etu. Duhen ke mon le, ‘Ni deng hebnos bè ni,’ bê ye abay hentahu. ");
INSERT INTO tblNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bè yóm angat bud kkól yóm Ngà Tau, hol lómón mkal silà, tódô lemayag klamang longit lemwót dmata kdaw kól desdef. Tódô kdéen tau gotu mton du. ");
INSERT INTO tblNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Angat dohò nim tulónu kuy ni. Lómón yóm gel mon le, ‘Yó se gónón mta lób, yó se gónón e sguku wak.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Sok kogol yóm alì hlayam bè yó kem kdaw yó,” mon Jisas, “angat là buden mnóng kdaw dalang se bulón, ne angat le gotu btang gu bè longit yó kem blotik, ne là bud glolò le lesang le yó kem dumu mnóng gu bè longit. ");
INSERT INTO tblNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ominen yó he angat gfan gu bè longit yóm kun ilô yóm Ngà Tau. Bè yóm kton le du, tódô kentihen tau talak tonok, gotu le dmumu mkik lemwót bè khuli sel le. Tódô ton le se yóm Ngà Tau htuntun gu tta mung bè lobun. Ne ton le se yóm tey kfasangen ne yóm tey kegetahen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne angat tey uni féw bong gu bè longit mò ilô yóm kehewóten yó kem hógówen gu bè longit mò na a semtifun yóm kdéen tau deng nélék Dwata bè klamangen benwu.” ");
INSERT INTO tblNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tódô henkna ye bè yóm koyu fig,” mon Jisas. “Sok tmubed ne nbuten mból dounen, ayawen sut bulónen mnóng kdaw. ");
INSERT INTO tblNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Senged snéen sok deng gotu gfan yóm kdê deng tulónu kuy ni koni, yó se ayawen yóm deng klonihen yóm ksutu, hol lómón ke denge mdà snolu aut ye. ");
INSERT INTO tblNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tódô tulónu kuy ktahuhen, kesok sut ni kem deng tulónu kuy ni, tolo wen he bè ni kem tau kmoen ni gmafit mton du. ");
INSERT INTO tblNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Angat tódô kmanas yóm longit dalang se yóm tonok. Okóm yóm dou udél,” mon Jisas, “là kóen na a lana.” ");
INSERT INTO tblNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Laen kô dù tau temngón du yóm kdaw angat kesfuléku duhen ke tedu urasen,” mon Jisas. “Balù yó kem hógów Dwata gu bè longit, là kô tngón le du se kul. Dalang se do, là kô tngónu du. Tek són Mà bè longit temngón du. ");
INSERT INTO tblNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Gu laanen là deng semfulék he yóm Ngà Tau, yó angat nmò yó kem tau te tonok, hol mkél bè yóm tehe kun kdaw Nuwa ekni. ");
INSERT INTO tblNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yóm gu laanen là deng tehe sut dunuk ekni, yó nmò kem tau mken le, ne minum le, ne syehen le efet yóm khotun Nuwa elem yóm kafal nmoen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Là kô tngón le du yóm angat sut bélê le. Song imò le hetngón, deng sut bélê le yóm dunuk, ne tódô le gotu mung konul. Lómón yó se kmoen yóm kkól yóm Ngà Tau. ");
INSERT INTO tblNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bè yóm kdaw yó, ke lewu tau tmiba, sotu nwiten, sotu se tebelen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ke lewu libun mdek, sotu nwiten, sotu se tebelen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yó gónóm mon, eles ye mingat abay se là kô tngón ye du yóm kdaw angat kkól yóm gónó ye mogot. ");
INSERT INTO tblNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ke eles tngón yóm tau fun gónô yóm kifu nan e knagaw lem gónóen yóm tau mnagaw, eles mabung anì là guseken yóm tau mnagaw. ");
INSERT INTO tblNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Duhen yó, eles tendo ningat ye yóm bud kkólen elem blóng ye yóm Ngà Tau, abay se kulel angat kkólen bè yóm uras là gingat ye du.” ");
INSERT INTO tblNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Tau du de yóm gulit kmoen nmò bè yóm gónón mogot ne yóm hulung hedem? Yó se yóm tau tódô gotu hogoten du yóm tau gónón mogot yó kem dumu tau mò nmò béléen mò fen semgifà kul. ");
INSERT INTO tblNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hligal kun yóm tau mò nmò yó ke tolo lelen hteneb mò nmò bè yóm kkól yóm gónón mogot. ");
INSERT INTO tblNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tódô tulónu kuy ktahuhen, yóm tau gulit kmoen nmò yó, angat hkemen du yóm gónón mogot yóm kdê kimuhen. ");
INSERT INTO tblNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Là, ke yó mefet bè nawahen yóm tau mò nmò yó, ke mom monen, ‘A, legen he ni kkólen yóm gónóhu mogot.’ ");
INSERT INTO tblNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ne nbuten mfes yó kem dumuhen gel mò nmò, ne fen hebsow mken ne hlengel minum kun. ");
INSERT INTO tblNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Timbow kól yóm gónón mogot bè yóm kdaw là ketgamahen, yóm uras là eles tngónen du, ");
INSERT INTO tblNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ne tódô hnatayen yóm tau là gulit kmoen nmò yó, hegbunuen du yóm kul glumfak yó kem tau gel hemtedeng knô. Ne bè yó gónón tendo heslaf ne dmumu mkik sembéhé kakim.” ");
INSERT INTO tblNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Bè yóm kdaw angat kkólu,” mon Jisas, “yóm kmò kogot Dwata tau, hol lómón yóm sfolò kem libun mit solok na a semlong yóm logi myehen. ");
INSERT INTO tblNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Limu bélê le yóm là hulungen hedem, ne limu se hulung hedem. ");
INSERT INTO tblNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lemwót yó kem libun là hulung hedem, là dog le mit lenagas mò tgama le ke gotu yóm gnan. ");
INSERT INTO tblNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Okóm eles wen kul lenagas nwit yó kem libun hulung hedem. ");
INSERT INTO tblNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lemwót yóm logi myehen, wen gónóhen ganggà, là géhélen kól. Yó gónóm mon, deng mom moo ktuk yóm sfolò kem libun, gotu le gtungô. ");
INSERT INTO tblNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Timbow deng sóól buteng, tódô btang lem klingu le yóm tey tmaba, monen, ‘Ni deng kól yóm logi myehen. Géhél ye, ne ye e senlong.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Segeng le se btik yóm sfolò kem libun, gotu nwa le yó kem solok le, ne gotu sentódô le sembwan le. ");
INSERT INTO tblNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yó udél yó kem libun là hulung hedem ebè yó kem libun hulung hedem, mon le, ‘Benlay ye se mi dé, Wè, ke wen dù kuy lenagas. Són moen mudof yóm kum solok.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ne mudél se yó kem libun hulung hedem, mon le, ‘Là bud gsakufen kuy ne nim kum lenagas ni. Tódô ye na a bemli kuy ne bè tindà.’ Tahu se, na le e bemli yó kem libun là hulung hedem. ");
INSERT INTO tblNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kogol yóm kewót le, kól se yóm logi myehen, ne tódô hlós ebè yóm gónô gónó le mò ken bè lówóhen, ne gmung yóm limu kem libun hulung hedem. Yóm kkól le bè yó, gotu le husek elemen, ne tnikeb le beng. ");
INSERT INTO tblNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Legen udì bè yó, gdofì se yó kem libun là hulung hedem. Mdà le bè lewaen, tmaba le, mon le, ‘Ó Sér, hfusekem mi elemen.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Okóm mom mon yóm logi myehen, ‘Bê. Là kô tngónu kuy.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yó gónóm mon,” mon Jisas, “eles ye hol temgama se kuy. Là kô tngón ye du yóm kdaw angat kkólu, duhen ke tedu urasen.” ");
INSERT INTO tblNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Bè yóm kdaw angat kkólu,” mon Jisas, “yóm kmò kogot Dwata tau, hol lómón ke yóm tau mógów ebè yóm sotu benwu mayuk. Gu laanen là deng lemwót yóm tau yó, nan tnaba yó kem tau mò nmò béléen, gotu hogoten kul yó kem kimuhen. ");
INSERT INTO tblNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tódô hogoten kul yóm bang kul gbek. Yó hogoten yóm tanayen, limu libu filak tahu blówón. Ne yó hogoten yóm tmodol, lewu libu. Yó hogoten yóm getluhen, lemibu. Ominen yó lemwót. ");
INSERT INTO tblNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tódô kendel bud lemwót se kun yóm tau mogot limu libu nan e hból yóm kun. Ngangen efet bud limu libu se uléken. ");
INSERT INTO tblNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ne bud lemwót se kun yóm mogot lewu libu. Ngangen hból yóm kun efet bud lewu libu se uléken. ");
INSERT INTO tblNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Okóm yó nmò yóm tau mogot lemibu, deng mom lebengen lem tonok yóm kun. ");
INSERT INTO tblNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Deng tey kegenen mógów ne yóm gónó le mogot, ominen bud kól. Ne gotu htabahen yó kem tau tehe wen hogoten kul. Gotu snólóken bélê le yóm kmò khógów le du yóm filak tehe hogoten kul. ");
INSERT INTO tblNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ominen sut yóm tau tehe hnogoten limu libu, ne monen, ‘Tehe limu libu yóm hogotem dou, Sér. Ni sii yóm uléken, bud limu libu.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ne monen se mò du yóm gónóhen mogot, ‘Wóyón dé. Tey hyu nim uu, teyi gulit. Lemwót bè yóm kgulitem bè yóm udì hogotu kóm, bong ne sigangu tahem. Yó ne, holi mung dou dé anì gmungi lemen yóm dou kligal.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ne bud sut yóm tau tehe lewu libu kun nogot, monen se kun, ‘Tehe lewu libu yóm hogotem dou, Sér. Ni sii yóm bud uléken, lewu libu.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ne bud monen se mò du yóm gónón mogot, ‘Wóyón dé. Tey hyu nim uu, teyi gulit. Lemwót bè yóm kgulitem bè yóm udì hogotu kóm, bong ne sigangu tahem. Yó ne, holi mung dou dé anì gmungi lemen yóm dou kligal.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ominen sut yóm tau tehe mogot lemibu, mom yó monen mò yóm amohen, ‘Tngónu uu, Sér, tódô ket du snoloem. Tódô gel nutahem yóm là kóm hulu du, ne yóm là kóm leniteg du. ");
INSERT INTO tblNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Likoe kóm, yó gónóm mon, deng tódô lebengu yóm filakem. Ni dé yóm filakem.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mung kudél yóm gónóhen mogot, monen, ‘Teyi bakà yóm uu. Alii mduk. Igoem sem deng mon du gel nutahu yóm là dou hulu du ne yóm là dou leniteg du. ");
INSERT INTO tblNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ke yó se yóm dou gel nmò, moem là hemsù du bè bangkù du yóm dou filak anì wen ngaen bè yóm kkólu?’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ne ominen mudél ebè yó kem tauhen, monen, ‘Na ye béléen yóm lemibu hogotu du, blay ye tum tau deng sfolò libu nô béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yóm tau ke gulit kogoten du yóm nô béléen, angat bud wen tnù le du efet gengón. Okóm yóm tau ke là gulit kogoten du yóm deng nô béléen, angat bud nwa le béléen. ");
INSERT INTO tblNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bong yóm tau laen dù mu yó, tódô tudà ye etu bè lewà bè gónón alì kmifu, ne bè yó tendo gónón heslaf ne dmumu mkik sembéhé kakim.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kesok bud kól yóm Ngà Tau mò mogot klamangen,” mon Jisas, “tódô kdéen hógów Dwata gu bè longit gotu semguyun du, ne angat myón bè yóm gónón myón kmukum. ");
INSERT INTO tblNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Angat tódô kdéen tau bè klamangen benwu gotu stifun ebè soluhen, ne sentólóngen lu. Lómó kmò kestólóngen kul, lómón yóm tau semgyok ógóf, gel sentólóngen yó kem ubiha bè yó kem kambing. ");
INSERT INTO tblNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yó kmoen kul, suen bè kwananen yó kem tau tedeng kmò le, ne suen bè iwóngen yó kem tau gel mò sidek. ");
INSERT INTO tblNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Angat monen mò yó kem nô bè kwananen yóm Hol Geta yó, ‘Géhél ye ne, yu kem tau deng tendo gel tnóbóng Mà. Hlós ye ebè yóm benwu deng tehe eles hentifesen bélê ye lemwót bè hol kbut benwu. ");
INSERT INTO tblNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Abay se bè yóm tehe kbitilu, tódô henken ye ou. Ne bè yóm tehe kleengu, tódô hinum ye ou. Ne bè yóm tehe kilohu, tey khódó ye do. ");
INSERT INTO tblNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bè yóm tehe klaen dù nesu, wen blay ye do mò nesu. Ne bè yóm tehe kwen desu, tey gel kesgifà ye do. Ne bè yóm tehe knóu lem blanggù, tódô gel nauy ye ou.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Angat bnalà yó kem tau tedeng kmò le, mon le, ‘Kilón de kton me kóm bitil, Sér, ne kehken me kóm ne khinum me kóm? ");
INSERT INTO tblNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kilón de yóm kton me kóm milo, ne yóm khódó me kóm bè gónô me? Kilón de yóm keblay me kóm nes mò nesem? ");
INSERT INTO tblNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kilón de yóm monem kwen desem, ne yóm knóem lem blanggù, ne yóm kauy me kóm?’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Angat bnalaen se lu yóm Tau Hol Geta, monen, ‘Tódô tulónu kuy ktahuhen, yó se deng nmò ye bè yó kem dumuhu setwoli alì gdanà, lómón ke béléu gónó ye mò du yóm yó.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ominen yó mon du mò yó kem tau fi bè iwóngen, monen, ‘Mdó ye béléu bè ni, yu kem tau deng eles golu elem tafak Dwata. Ditu gónó ye nô lem yóm ofi laen dù tul katayen deng hentifes Dwata bè Seitan ne yó kem hógówen. ");
INSERT INTO tblNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Abay se yóm tehe kbitilu, là kô dog henken ye do. Ne yóm tehe kleengu, là kô dog hinum ye do. ");
INSERT INTO tblNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yóm tehe kilohu, là kô hnódó ye do. Yóm tehe klaen dù nesu, là kô dog benlay ye do. Yóm tehe kwen desu ne yóm tehe knóu lem blanggù, là kô dog sen-gifà ye do.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ne angat bnalà le se, mon le, ‘Kilón de kton me kóm bitil, Sér, ne meeng ne milo? Ne kilón de yóm klaen dù nesem ne yóm kwen desem ne yóm knóem lem blanggù, ne là dog tnóbóng me kóm?’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne yó monen mò kul yóm Tau Hol Geta yó, ‘Tódô tulónu kuy ktahuhen, yóm là dog któbóng ye yó kem tau alì gdanà, lómón se yó ne yóm là dog któbóng ye dou.’ ");
INSERT INTO tblNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Duhen yó,” mon Jisas, “tódô le gotu hlós elem yóm tafak Dwata laen dù sónen. Okóm yó kem tau tedeng kmò le, guta le yóm klowil laen dù sónen.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Timbow deng ni kem tulón Jisas kul ni, ominen mon du mò yó kem gel lemolò du, ");
INSERT INTO tblNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Deng tngón ye lewu ni he kehtohen yóm mò ken bong bélê tekuy bè Kdaw Khius. Segeng du yóm angat keblay le yóm Ngà Tau elem tdok yó kem tau angat tmutuk du bè kros.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Bong yó kem geta bè yó kem gel demsù ebè Dwata kkólen bè yó kem tuha gónó le gel galak yó kem Ju, gotu le stifun bè gónô bong Kyafas, yóm tau geta bè yó kem gel demsù ebè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yó natul le yóm kmò klifut kekfô le ke Jisas anì ghatay le. ");
INSERT INTO tblNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Okóm,” mon le, “bê tekuy hesegeng bè yóm mò ken bong, kô wen sidek nmò le bélê tekuy yó kem tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bè yóm knô Jisas bè Bitani, mken bè gónô yóm sotu tau tehe gemnóm des mifù boluyen Simun. ");
INSERT INTO tblNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yóm igoen mken bè yó, sut béléen yóm sotu libun, wen sobuy alabastér nwiten hnok yóm hboo alì mebtes, ne tey minggel boohen. Tódô gotu msulék koken te kulu Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bè yóm kton le du yó kem gel lemolò du, mo le mom lembut, mon le, “Moen ke gotu namaen yóm yóó? ");
INSERT INTO tblNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mom hyu ke tehe tódô hbaluen, bong he gutahen du, ominen bemlay du bè yó kem élél yóm blihen.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hyu gungol Jisas yóm udél le, yó gónón mon du mò kul, “Moen de ke bnólów ye kun nmò nim libun nii? Igoen tey minggel yóm nmoen béléu ni. ");
INSERT INTO tblNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hyu he kul yó kem tau élél, eles le tendo nô lem blóng ye. Là dou. ");
INSERT INTO tblNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yóm koken béléu ni, mò eles hgifaten dou bè yóm angat kebeng le do. ");
INSERT INTO tblNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tódô tulónu kuy ktahuhen,” mon Jisas, “balù kihu gónón angat e mból bè klamangen benwu yóm Tulón Hyu lemwót bè Dwata, tendo gel gboluy snéen kun nim libun ni lemwót bè yóm deng nmoen béléu.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kogolen bè yó, lemwót Judas Iskariyut, sotu bè yó kem sfolò lewu gel lemolò ke Jisas, tódô mógów etu bè tu kem geta bè yó kem gel demsù ebè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yó snólóken bélê le, monen, “Hilu de blay ye do ke ou fen malak kuy ebè Jisas?” Deng mom yó nmò le, tódô nsó le béléen tlu folò botù yóm kul filak mgel. ");
INSERT INTO tblNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tódô lenwóten bè yó ne, sónmò Judas mebel lanen malak kul ebè Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Timbow hto yóm tanay kdawen bè yóm mò ken bè yóm gel kken yóm mambang laen dù bulung henoken, mógów le ebè Jisas yó kem gel lemolò du, snólók le béléen, mon le, “Gónóm tô hmò du kum de yóm ken tekuy bè nim mò ken bè Kdaw Khius ni?” ");
INSERT INTO tblNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne mon Jisas se mò kul, “Mógów ye ebè yóm sotu tau bè syudad Jirusalim, mon ye mò du, ‘Ni se tinoken ebéléem yóm tau gónó tekuy gel htolok, monen, Deng hto ne yóm buteng tehe olu Dwata do. Nmou bè gónóem yóm mò ken bè Kdaw Khius, mung do yó kem gel lemolò do.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tahu se, tódô lolò le yóm deng mon Jisas mò kul, ne nmò le yóm ken mò ken le bè yóm kifu yó. ");
INSERT INTO tblNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Timbow deng móyón kifu, omin le gotu seyón mken le Jisas ne yó kem sfolò lewu gel lemolò du. ");
INSERT INTO tblNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yóm igò le tolo mken, mudél ebélê le Jisas, monen mò kul, “Tódô tulónu kuy ktahuhen, sotu bélê ye angat mlay do sumóng.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ya tey sidek klóngón nawa le, tódô sotu kun mon du mò ke Jisas, “Là ou du kô yó?” ");
INSERT INTO tblNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mon Jisas se mò kul, “Yó se tau dumuhu segeng mdù elem sóbów yóm mambang, du se yóm angat mlay dou sumóng. ");
INSERT INTO tblNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yóm Ngà Tau nan na matay he,” mon Jisas, “lómón yóm deng tehe eles tulónen bè Sulat Dwata. Bede tey angat kegtafaken yóm tau bemlay sumóng. Mom tumù ne ke béen dog tehe tau.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mudél se Judas, yóm mlay du sumóng, monen, “Ou kô, Sér, gónón e gbak yóm monem yó?” Bnalà Jisas se, monen, “Yó sem deng monem yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yóm igò le tolo mken, nwa Jisas yóm mambang, bede nan ne mni bè Dwata. Ominen kembéng du, ne blayen yó kem gel lemolò du, yó monen, “Ni se yóm dou lówó. Nwa ye, ne ken ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ominen mkay yóm tgayan gónón nô yóm ninum le, nan na bud mni bè Dwata, ominen mon du mò kul, “Ni sensinum ye. ");
INSERT INTO tblNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ni se dou litô mò hemget du yóm deng fasad Dwata bè kem kun tau. Ne tey dê tau gónón gamà nim litóu ni mò lan Dwata hmifót salà le. ");
INSERT INTO tblNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tódô tulónu kuy, hatan bud ninumu he nim ninum ni ke deng kól bè yóm kdaw angat kinum tekuy yóm ninum lomi bè yóm kun benwu nogot Mà.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tikóng deng kinum le, omin le gotu semngal yóm sotu sngal dmóyón ke Dwata, omin le lemwót ebè Bulul Ulib. ");
INSERT INTO tblNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bè yóm tolo lel le mógów, mon Jisas mò yó kem gel lemolò du, “Kifu ni kdeng tódô gotu sentagak ye ou, yakà deng monen du bè yóm Sulat Dwata, yó monen, ‘Angat hfatay Dwata yóm tau semgyok ubiha, ne tódô gotu sekla yó kem ubihahen.’ ");
INSERT INTO tblNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Okóm,” mon Jisas, “sok deng bud hlowil Dwata ou, angate fen gna bélê ye etu bè Galili.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hebkó mudél se ke Pitér kun, monen, “Baluen se ke gotu sentagak le uu yó kem dumuhu, Sér, là kô naw e tnagak kóm dou.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bnalà Jisas se, monen, “Tódô tulónu kóm ktahuhen, Pitér, gu laanen là deng kmóót onuk kifu ni kedeng, deng sana tlu dulékem hmalà yóm ketngónem dou.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mon Pitér se, “Baluen he ke munge matay béléem, Sér, là kô naw e hnalà kóm dou.” Tódô senged se udél yó kem dumu gel lemolò ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngang le Jisas mógów efet le kól bè yóm sotu ngà hungul koyu boluyen Gitsimani, ne mon Jisas mò yó kem gel lemolò du, “Na ye myón bè ni bè yóm igou mni bè Dwata bè tuu.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Niten Pitér ne yó kem lewu ngà Sibidi. Ne tódô gleket béléen yóm tey ksidek kegnómen du. ");
INSERT INTO tblNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Monen mò kul, “Tey sidek gnóm yóm gleket béléu ni, là hol tô gbeku hembala du. Nô ye bè ni ne kuy, ne eles ye mingat.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ominen mógów hlayuk udì, ne tódô hegluduk lemfen bè tonok, ne mni bè Dwata, monen, “Ó Mà, ke yó dum gmò, kóhem tahu dé yóm angat tey hlayamu ni. Okóm balù wen se yóm dou kóyô, tódô hendengem yóm kóm kóyô béléu.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Timbow deng knihen, ominen mulék ebè yó kem tlu tau nwiten, deng le mom gotu henga tungô. Gotu bentiken lu, ne monen mò ke Pitér, “Là gbek ye mingat kô, balù tek sotu uras? ");
INSERT INTO tblNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bê ye tagad tungô dé. Hol ye mni bè Dwata anì là wen gónó ye gsindil bè Seitan. Tngónu wen se óyô ye mò du yóm monu mò kuy ni, okóm là gbek lówó ye du.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bud kewót Jisas bè yó bè gewuhen dulék, ne bud mni bè Dwata. Yó utóm yóm knihen, monen, “Ó Mà, ke là se hyu mkó du béléu yóm angat tey hlayamu ni, tódô henlósem sen yóm kóm kóyô.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ominen bud mulék ebè yó kem tlu tau niten, deng le mom bud henga tungô, là kô dog gukat le du mata le. ");
INSERT INTO tblNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ne ominen bud tmagak kul na e mni bè getluhen dulék, tódô nuliten yóm gna kmò knihen. ");
INSERT INTO tblNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ne bud mulék ebélê le, ne monen mò kul, “Tolo lel ye he kô tungô ne hegnô? Ngem deng kól du ne yóm uras le kemfô du yóm Ngà Tau, ne blay le elem tdok yó kem tau sidek nmò le. ");
INSERT INTO tblNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ngem yó dé yóm tau mlay do sumóng. Btik ye ne, na tekuy e senlong.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Igò Jisas tolo mudél, gdofì bè yó se Judas, yóm sotu bè yó kem sfolò lewu gel lemolò du. Tey tau wen huli du. Wen se lemumak sudeng bélê le, ne wen se kmulóng bogul. Lu se yó kem tau hógów yó kem geta gel demsù ebè Dwata ne yó kem tuha gónó le gel galak yó kem Ju. ");
INSERT INTO tblNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Deng eles tulón Judas yó kem tau mung du, monen, “Yó se tau neleku kdeng, yó se yóm tau hnebel ye. Tódô kenfô ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Timbow gdek Judas, tódô hekteng ebè Jisas, monen, “Na Sér,” ne ominen melek du. ");
INSERT INTO tblNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Omin Jisas mudél ebè Judas, “Yó ne, Wè, géhél nmoem yóm nógówem.” Omin le gotu demlu kemfô ke Jisas, ya tey kget kogot le du. ");
INSERT INTO tblNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sotu bè yó kem gel lemolò ke Jisas kendel kemtos dmilot sudeng, tódô tnibóhen yóm sotu tau, okóm olon sfak doli klinguhen yóm tau tnibóhen yó. Yóm tau hnalì ni, du sotu tau gel dók yóm geta bè yó kem tau gel demsù ebè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Bè yóm kton Jisas yóm tau fen tmibó yó, bnólówen, monen, “Tenesem lem lumaken sudengem. Ngem he yóm tau smalig bè sudeng, angat bud hatayen sudeng. ");
INSERT INTO tblNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ilóem là tngónem du kô yóm kegbeku mni tóbóng bè Mà, ne tódô kendel hógówen balù hilu libu yó kem gel hógówen gu bè longit mò tmóbóng do. ");
INSERT INTO tblNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Okóm ke yó nmou, tedu se tô kdohoen du yóm deng tehe hsulat Dwata golu etahu?” ");
INSERT INTO tblNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Omin Jisas mudél ebè yó kem tey tau wen kemfô du, monen, “Tey, glok ye mit suk ne bogul nim na ye e kekfô dou ni. Ilóem tô heskél ye ou bè yóm tau gel mò sidek. Igou se gel myón tmolok lem Gónô Dwata ket kdaw, là se kô géhél kenfô ye do. ");
INSERT INTO tblNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Okóm nim nmò ye béléu ni, deng gónón dohò yóm tehe hsulat Dwata yó kem gna tugoden.” Bè yóm kekfô le ke Jisas yó, deng mom gotu sentagak yó kem gel lemolò du, mlóy le. ");
INSERT INTO tblNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kewót le bè yó ne, nit le Jisas ebè gónô Kyafas yó kem tau kemfô du yó koni. Nim Kyafas ni, geta bè yó kem tau gel demsù ebè Dwata. Deng le eles gotu stifun bè yó ne yó kem tau gel tmolok hlau ne yó kem tau tuha gónó le gel galak yó kem Ju. ");
INSERT INTO tblNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bè yóm kwit le ke Jisas, fen holun huli Pitér efet kól bè gónô yóm tau geta yó koni. Ne hlós e talak lósól, ne seyón bè yó kem tau gel mentey bè yó, hnilungen yóm mò kmò le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ne lemwót yó kem tau geta bè yó kem gel demsù ebè Dwata ne kdê yó kem tau geta mogot kukum, mebel le dalil mò lan le hfatay ke Jisas lemwót bè yóm gel tifù yó kem dumu tau, baluen ke là tahuhen. ");
INSERT INTO tblNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Okóm laen kô dù ton le, balù yóm tey kdê tifù le du, hono là kóen tahu. Ominen yó wen lewu tau mdà, ");
INSERT INTO tblNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yó kul tifù, mon le, “Gel monen nim tau ni, ‘Gbeku gembà du yóm Gónô Dwata ni, ne gbeku se bud hdà du bè tlu kdaw.’ ” ");
INSERT INTO tblNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ne hebkó mdà se yóm geta bè yó kem gel demsù ebè Dwata, monen mò ke Jisas, “Là bnalaem du kô yóm ktifù le kóm ni?” ");
INSERT INTO tblNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Okóm là dogen mudél Jisas. Ominen bud mudél ebéléen yóm tau geta yó koni, monen, “Wen snólóku béléem. Bè yóm kbalaem du, hol hlanem bè boluy yóm Dwata laen dù tul katayen. Tulónem kum kun ktahuhen ke uu yóm Misaya, yóm hol Ngà Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Bnalà Jisas se, monen, “Yó sii deng monem. Okóm wen tulónu kuy, angat ton ye yóm Ngà Tau myón fi bè kwanan Dwata, yóm laen dù là gbeken du, ne angat ton ye se yóm kesfuléken edini mung bè lobun.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mung kungolen du nim udél Jisas ni yóm tau geta bè yó kem gel demsù ebè Dwata, botong tódô kenséen nesen, monen, “Tô hsengeden knóen bè Dwata. Omin he ke bud wen tifù du. Deng tódô gungol tekuy yóm kehsengeden knóen bè Dwata. ");
INSERT INTO tblNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tedu kuy kmò kmon du yóm tau ni?” Mon le se, “Hyu ke tódô hnatay.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nbut le bè yó ne tendo hemsidek ke Jisas. Gotu sendulak le lem uyóhen, ne sensuntuk le, lel le semtfê du, ");
INSERT INTO tblNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","mon le, “Ke tahu uu se yóm Misaya, tulónem kum kun yóm tau temfê kóm.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sana tolo kyón Pitér talak lósól he kun. Ne mógów ebéléen sotu bè yó kem ngà libun gel dók yóm tau geta bè yó kem gel demsù ebè Dwata, monen mò ke Pitér, “Kaem uu se sotu tau gel mung ke Jisas, yóm tau lemwót bè Galili.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Okóm mom hlalà bélê le Pitér, monen, “Là kô naw e tngón du dou yóm monem yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ne bud mógów ebè bak tikeb yóm labat. Ne bud wen sotu ngà libun mton du, ne monen mò yó kem tau bè yó, “Ni se sotu tau gel mung ke Jisas, yóm tau lemwót bè Nasarit.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ya tey bud kehlalà Pitér, gloken smafà ke tngónen Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tikóng deng bud legen udì bè yó, mógów le ebè Pitér yó kem tau mdà gu bè yó, mon le mò du, “Kaem uu se hol sotu bélê le. Dilô me bè kudélem lemwóti bè Galili.” ");
INSERT INTO tblNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tódô smafà Pitér lem blóng le, monen, “Hol tnafak Dwata se o ne ke kéngu yóm tulónu kuy. Là kô tngónu du dou yóm tau yó.” Ne tódô sen-gengen se kmóót onuk. ");
INSERT INTO tblNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ominen yó gbel bè nawa Pitér yóm deng tehe eles mon Jisas mò du, yóm monen, “Gu laanen là deng kmóót onuk kifu ni kdeng, deng sana tlu dulékem hmalà yóm ketngónem dou.” Unihen gbel bè nawahen yóm tehe mon Jisas mò du, tódô hewà, ya tey sidek kkiken. ");
INSERT INTO tblNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Timbow deng mwas bè yó, gotu le stifun yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem tuha gónó le gel galak yó kem Ju, sensatul le yóm kmò khatay le ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Omin le hmengked mfét du kdina, ne nwit le ebè Paylét, yóm tau lemwót bè Rom gubérnor bélê le. ");
INSERT INTO tblNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Timbow ton Judas, yóm tau tehe mlay ke Jisas sumóng, yóm deng kegtuled Jisas, ya tey khuli selen. Ominen bud tô hulék yóm tlu folò botù filak mgel tehe blay le du yó kem geta bè yó kem gel demsù ebè Dwata, ne yó kem tuha gónó le gel galak yó kem Ju. ");
INSERT INTO tblNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mon Judas, “Tey kegsalau. Deng mom hekfóu yóm tau laen kô dù salaen anì hnatay le.” Bnalà le se, mon le, “Laen kô dù bud kum hentngón du ne yóm monem yó. Tódô kóm ne yó.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tódô gotu legas tudà Judas elem Gónô Dwata yóm filak tehe blay le du, ominen tódô lemwót na a mówól lihol. ");
INSERT INTO tblNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yóm filak tudà Judas, gotu bud nulut yó kem geta bè yó kem gel demsù ebè Dwata ne mon le, “Là hyuhen bè yóm hlau tekuy ke homong te bè yóm filak gel blay le ke Dwata yóm filak ni, yakà filak bli litô tau du.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yó deng kessatul le du yóm filak yó, tódô bli le tonok mò gónó le lembeng ke wen tau là Juhen matay bélê le. Yó boluyen yóm tonok benli le, Tonok yóm Tau Gel Mifil Kuleng. ");
INSERT INTO tblNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Okóm yó tles boluy le du, Tonok Bli Litô, efet yóm kmoen ni. ");
INSERT INTO tblNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yóm nmò le yó deng gónóhen dohò yóm tehe mon yóm sotu tehe gna tugod Dwata boluyen Jirimaya, “Nwa le yóm tlu folò filak mgel yó, yó se kul btes du yó kem tau Israél. ");
INSERT INTO tblNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne bli le tonok yóm tau gel mifil kuleng. Lómón se yóm deng kun kehlan du Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lemwót ke Jisas, nit le ebè solu Paylét, yóm tau lemwót bè Rom gubérnor bélê le. Snólók Paylét Jisas, monen, “Uu kô tau hol geta bè yó kem Ju?” Mon Jisas se, “Yó sii deng monem.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Okóm là kô bnalaen kul yó du kem dê tifù le du yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem tuha gónó le gel galak. ");
INSERT INTO tblNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yó gónó Paylét bud mon du mò ke Jisas, “Gungolem kô yó kem tey dê tifù le kóm?” ");
INSERT INTO tblNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Okóm là dog bnalà Jisas kul, balù sekteb. Ya tey ketnga yóm gubérnor yóm là dog kbalà Jisas kul. ");
INSERT INTO tblNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yó kun adat yóm gubérnor ke sok gel kól yóm mò ken bong bè Kdaw Khius, sal gel wen tau blanggù hefewaen, bede yóm tau kul nélék yó kem tau. ");
INSERT INTO tblNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bè yóm kdaw yó, wen sotu tau blanggù alì tótól, boluyen Jisas Barabas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Timbow le deng gotu stifun ebè yó yóm tey tau wen, snólók Paylét lu, monen, “Tau du de kuy nóyô mò hewau bélê ye, Jisas Barabas duhen ke Jisas yóm Misaya?” ");
INSERT INTO tblNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Deng tódô tngón Paylét se yóm alì kélés nawa le ke Jisas yó kem tau mit du ebéléen yó. ");
INSERT INTO tblNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yóm igò Paylét tolo myón bè yóm gónón myón kmukum, wen sulat hwit yehenen ebéléen, monen, “Hol béi abay gbót hemsidek du kóm yóm tau laen dù salaen yó. Tey sidek kegnómu du ebuteng lemwót bè yóm keknahu du.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Okóm yó nmò yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem tuha gónó le gel galak, nofong le yó kem tau sbung bè yó anì yó hni le Barabas, ne fen hfatay le Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bud snólók Paylét yó kem tau sbung bè yó, monen, “Mahi du bè ni kem lewu tau monu ni koni mò hewau ebélê ye?” Mon le se, “Barabas.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne mon Paylét, “Tedu se tô kmou ke Jisas du, yóm bnoluy le Misaya?” Deng mom yó balà le du, mon le, “Htutukem bè kros kun yó du.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bud snólók Paylét bélê le, monen, “Moen de? Tedu deng salaen bélê ye?” Okóm deng mom lenwê le hetê, mon le, “Tódô htutukem bè kros ne.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Timbow ton Paylét yóm là kegbeken hewà ke Jisas, ne dilóen bè yó kem tey tau sbung bè yó wen tô sidek nmò le béléen ke là nmungen du yóm kul knóyô, yó gónón tódô ma él, ne noloben tdoken lem mata le, monen mò kul, “Laen dù dou du bè yóm khatay ye du nim tau ni. Tódô kuy nbô yóm kgamà litóen.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne mon le se, “Tódô kum nbô ne litóen nim tau ni, dalang se kem kum ngà.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Omin Paylét hewà ke Barabas ebélê le, ne nan na habid hfes Jisas, ne ominen bemlay du ebè yó kem sendalù mò na e tmutuk du bè kros. ");
INSERT INTO tblNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lemwót yó kem sendalù Paylét, nwit le Jisas elem yóm gónô bong yóm gubérnor, ne gotu le sbung ebè yó se kul yó kem dumu sendalù bè yóm kul bung. ");
INSERT INTO tblNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne kó le nes Jisas, hesek le du yóm nes tógó hulô, hningón nmò le tau hol geta. ");
INSERT INTO tblNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne lenikin le yóm sotu kay tinu semnual mò kuruna suub le bè kuluhen, ne wen fes hogot le du bè sigel kwananen. Gotu le mtud bukol bè soluhen, hningón tô nmò le béléen yóm gel kadat le yóm tau hol geta. Ya tey kehlowon le du, mon le, “Ni sii yóm tau hol geta bè kem Ju. Yake hol tahà klowilen.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lel le semdulak du, bud na le yóm fes hogot le du, bud sensulit fes le te kuluhen. ");
INSERT INTO tblNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Timbow le deng tmakas hmowon du, omin le bud mlus yóm nes hesek le du, bud hesek le du yóm sana kun nes. Kewót le bè yó ne tódô nit le ebè yóm gónó le tmutuk du bè kros. ");
INSERT INTO tblNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yóm tolo knô le bè lan, geslong le yóm sotu tau boluyen Simun, lemwót bè Sayrin. Tódô gnaga htihang le du yóm kros Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ngangen ne gefet le bè Golgata. Yó lanen yóm boluy yó, “Bangag Kulu.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wen tô hinum le ke Jisas yóm ninum lóbô, wen bolen yóm sotu kay bulung héét. Bè yóm ktilów Jisas du, là dog henlós ninumen du. ");
INSERT INTO tblNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Omin le tmutuk du bè kros. Yó nmò yó kem sendalù, sensatù le yó kem nes Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tikóng deng yó, tódô le myón bè yó, bnentey le kmò Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wen snulat dket le senta kuluhen yóm udél duón le du, yó monen, “Ni se Jisas, tau hol geta bè yó kem Ju.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ne wen lewu tau gel mò sidek homong tnutuk le, sotu hteg le fi bè kwananen, ne sotu se fi bè iwóngen. ");
INSERT INTO tblNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yó kem tau gel mius bè yó, sónmò le kmotuk, ne sendekà le Jisas, tey dê udél le sidek ebéléen, ");
INSERT INTO tblNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mon le, “Uu kun tô gembà du yóm Gónô Dwata, ne tek tlu kdawem bud hdà du. Yó ne, lenwaem knóem kun ke tahu uu se yóm Ngà Dwata. Kmóhi elaan dé.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Senged se kul kehlowon du yó kem geta bè yó kem gel demsù ebè Dwata, ne yó kem gel tmolok hlau, ne yó kem tuha gónó le galak. ");
INSERT INTO tblNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Yó mon le, “Deng gel hlowilen kem dumu tau, là kô dog gbeken hlowil kun knô. Du kô kun tau hol geta bè yó kem tau Israél? Hentahu tekuy ke gbeken bud kmó elaan. ");
INSERT INTO tblNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Gel smalig bè Dwata kun, ne du kun yóm Ngà Dwata. Nénég ke móyô Dwata lemwà du.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Balù yó kem lewu tau gel mò sidek gomong tnutuk le bè Jisas, gbót le semdekà se kul. ");
INSERT INTO tblNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tikóng deng gtungu kdaw, tódô kmifu talak tonok efet sóól mosol kdaw. ");
INSERT INTO tblNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Timbow deng sóól mosol kdaw, omin Jisas hgel udélen, monen bè hol kun udél, “Eli, Eli, lema sabachthani?” Yó lanen yóm udélen yó, monen, “Ó Dwata, Ó Dwata, moen de ke tódô bayaem ou?” ");
INSERT INTO tblNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wen kem tau mdà bè yó mungol du yóm udél Jisas yó, mon le, “Éhé, tnabahen Ilaydya.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ne wen sotu bélê le bè yó kendel ma yóm lómón tô gófós, ne duen lem yóm ninum lóbô là mebtesen, ominen hemsù du bè tukô yóm ngà koyu mò gónón tô hsef du ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Okóm mom mon kem dumu tau, “Tagad dé. Nénég tekuy ke sut Ilaydya mò lemwà du.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Omin Jisas bud hgel du udélen, ne tódô milot se nawahen. ");
INSERT INTO tblNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Uma kóm bè yóm Gónô Dwata, wen tey nes mfól mò seng yóm dfél hetfing le ebè Dwata. Bè yóm kilot nawa Jisas, tódô sen-gengen lómón ke hninggel dnólóhem bè gónón sóól yóm nes yó, lemwót fi ta kól elaan. Ne tódô sen-gengen se mbel tey linol bong, tódô gotu meskang se yó kem botu lembang. ");
INSERT INTO tblNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ne gotu setngag yó kem kilib gónó le lembeng, ne tey dê bè yó kem kun tau Dwata deng tehe matay, gotu bud hlowil Dwata lu. ");
INSERT INTO tblNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tódô le gotu hewà bè yó kem lebeng le. Ne kogol yóm deng klowil Jisas, mógów le ebè Jirusalim se kul, ne tey dê tau mton kul. ");
INSERT INTO tblNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bè yóm kehto Jisas, tolo mentey yóm kfitan, mung du yó kem sendaluen. Ya tey sidek klikò le bè yóm tey linol ne yó kem dê dumu ton le. Botong mon le, “Tahu duhen ni se yóm Ngà Dwata.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wen se kem libun nô bè yó, olo le tódô temngel mayuk. Tehe le mung ke Jisas lemwót gu bè Galili mò gel tmóbóng du. ");
INSERT INTO tblNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mung kul se yóm Midi lemwót gu bè Megdala, ne yóm sotu Midi, Yê Jim ne Jusif, ne mung kul snéen yehen Sibidi. ");
INSERT INTO tblNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tikóng móyón kimel, wen sotu tau kwasa lemwót bè Arimatiya sut bè yó, boluyen Jusif. Du se sotu tau gel lemolò ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tódô mógów ebè Paylét nan e bal du yóm kwahen yóm lówó Jisas. Tahu se, hlus Paylét du. ");
INSERT INTO tblNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kewót Jusif bè yó, mógów ebè tum gónô Jisas nô, ne nwahen elaan yóm lówóhen, ne bnausen yóm nes bukay hanà lomi. ");
INSERT INTO tblNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Uma kóm deng wen kilib lomi hokol Jusif bè but léhék mò tô kun angat gónô lebeng, ne tódô bè yó gónón lembeng ke Jisas. Ne wen botu bong hluyen ebè yóm bak lebeng mò sengen, ne ominen yó lemwót mulék. ");
INSERT INTO tblNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mung le lembeng se kul le Midi lemwót bè Megdala ne yóm sotu Midi. Myón le bè yó, smolu le ebè yóm bak lebeng. ");
INSERT INTO tblNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Timbow deng hayahen bè yó, uma kóm kul Kdaw Kehegnô yó kem Ju, gotu le mógów ebè Paylét yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem Farisi. ");
INSERT INTO tblNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mon le mò du, “Ó Sér, gtulón bè nawa me yóm tehe monen tum tau mò kéng tu yóm kegenen tolo mowil, ‘Bè getluhen kdaw, bud hlowil Dwata ou.’ ");
INSERT INTO tblNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yó gónóm mon, holi mdók kut sendalù etu bè lebengen mò mentey du efet tlu kdaw anì laen dù lan le mnagaw lówóhen yó kem tehe gel lemolò du, ne omin le yó bud tmulón du kem tau yóm deng klowilen. Ke yó tô nmò le, milud he kegsukat kem tau senta yóm gnan.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mon Paylét se mò kul, “Yó ne, mit ye sendalù anì hol bnentey le tum lebengen.” ");
INSERT INTO tblNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tahu se, lemwót le. Ya tey bud kehget le du yóm seng bè bak lebeng Jisas. Wen deket nmò le bè baken anì dilô le ke wen tau tô mkó du. Ne wen kem sendalù tebel le mò mentey bè yó. ");
INSERT INTO tblNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Timbow kogol yóm Kdaw Kehegnô, yóm hanà tolo minal mwas bè Akad, lemwót Midi, yóm Midi lemwót bè Megdala, ne yóm sotu Midi, tódô le temkifu na le e nauy lebeng Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Timbow le kól ditu, tódô mbel tey linol bong. Ne wen hógów Dwata htuntun gu bè longit sut bè yó, tódô hluyen yóm botu seng bè bak lebeng, ne tódô bud myón tahen. ");
INSERT INTO tblNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tey mnóng lem uyóhen yóm hógów Dwata yó, hol lómón ke mkal silà, ne tey sminang bukay yóm nesen. ");
INSERT INTO tblNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ya tey sidek klikò le yó kem sendalù mentey bè yó, tódô setbol kkel le, ne tódô le gotu masà bè tonok, lómón ke deng le gotu matay. ");
INSERT INTO tblNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ne mudél yóm hógów Dwata ebè yó kem libun, monen, “Bê ye abay hlikò. Tngónu hnebel ye Jisas, yóm lomi tnutuk le bè kros. ");
INSERT INTO tblNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Là buden nô bè ni ne. Deng hlowil Dwata lómón yóm tehe mon Jisas mò kuy. Ngem ni hnénég ye yóm tehe gónón masà. ");
INSERT INTO tblNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Géhél ye mulék ne, ne tulón ye yó kem gel lemolò du, mon ye mò kul, ‘Deng hlowil Dwata Jisas. Deng gna bélê ye ne ebè Galili, ditu he gónó ye ston du.’ Hol bê ye na a klifót yóm deng tulónu kuy ni.” ");
INSERT INTO tblNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tahu se, kendel le lemwót yó kem libun. Ya tey kligal le, mung du yóm klikò le. Tódô le mlóy na le e tô tulón yó kem gel lemolò ke Jisas. ");
INSERT INTO tblNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bè yóm igò le mlóy, tódô senlong Jisas lu, ne monen mò kul, “Dwata he henek nawa ye.” Tódô le hloni ebéléen yó kem libun, mtud le bukol bè soluhen, ne nogot le tihen. ");
INSERT INTO tblNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mon Jisas mò kul, “Bê ye abay hlikò. Na ye e tulón dou tu kem dumuhu setwoli anì mógów le ebè Galili. Ditu he gónó le mton do.” ");
INSERT INTO tblNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tikóng le deng lemwót yó kem libun yó koni, wen bè yó kem sendalù tehe mentey bè lebeng Jisas mulék ebè Jirusalim, mógów le ebè yó kem geta bè yó kem gel demsù ebè Dwata, tódô gotu tulón le kul yóm kdéen. ");
INSERT INTO tblNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Omin le gotu bud stifun se kul yó kem geta bè yó kem gel demsù ebè Dwata ne yó kem tuha gónó le gel galak, sensatul le yóm mò kmò le du. Yó nmò le, wen tey filak blay le bè yó kem sendalù, ");
INSERT INTO tblNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne mon le mò kul, “Yó hol tulón ye bè yó kem tau, deng hennagaw yó kem tehe gel lemolò du yóm lówó Jisas igò ye tolo lemnga tungô. ");
INSERT INTO tblNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ke gungol yóm gubérnor nim ni, mi he hemyu stulón béléen anì laen dù gfà ye.” ");
INSERT INTO tblNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tahu se, nwa yó kem sendalù yóm filak, tódô lolò le se yóm deng hlau le kul. Yó se hlós tulón tendo hból yó kem Ju efet nim kmoen ni. ");
INSERT INTO tblNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lemwót yó kem sfolò sotu dù lemolò ke Jisas, mógów le etu bè yóm sotu bulul bè Galili, yóm bulul tehe eles tulón Jisas kul mò gónó le angat ston du. ");
INSERT INTO tblNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Timbow ton le Jisas bè yó, ya tey kdóyón le du. Okóm wen se bélê le tolo megewu nawa le du yóm deng bud klowilen. ");
INSERT INTO tblNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hloni bélê le Jisas, ne monen mò kul, “Deng gotu blay Dwata do yóm kwalis mogot longit ne tonok. ");
INSERT INTO tblNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yó gónóm mon, mógów ye do ebè kdéen but tau bè klamangen benwu anì baling le tau lemolò do. Bnabtays ye lu hlan ye bè boluy Dwata, yóm Mà tekuy, ne bè boluy yóm Ngaen ne bè boluy yóm Tulusen. ");
INSERT INTO tblNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne yóm kdê deng hlauhu kuy, hol tolok ye kul anì hol nimón le se kul. Ne laen kô mtukul sónen yóm knóu bélê ye efet kól bè yóm hol són kdaw.”");
ALTER TABLE tblNT_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
