﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbk_vpl;
CREATE TABLE tbk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbk_vpl WRITE;
INSERT INTO tbk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ya ra taa yang listaan yang mga kinaampu ni Jesu-Cristo. Tanya sasang kanubli ni Adi David ig sasa kang kanubli ni Abraham. ");
INSERT INTO tbk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Mag̱impisa tung ni Abraham ang asta ra tung ni Adi David sam puluk may epat ang esleb yang mga kinaampu ni Jesu-Cristo: 1. Ti Abraham 2. Ti Isaac 3. Ti Jacob ang yay tatay na Judang magpurutul 4. Ti Juda ang yay tatay ni Fares duruang magkampi ni Zara ang yay ipinangana ni Tamar 5. Ti Fares 6. Ti Esrom 7. Ti Aram 8. Ti Aminadab 9. Ti Naason 10. Ti Salmon 11. Ti Boaz ang yay ipinangana ni Rahab 12. Ti Obed ang yay ipinangana ni Ruth 13. Ti Jesse 14. Ti Adi David ");
INSERT INTO tbk_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Mag̱impisa tung ni Adi David ang asta tung uras ang atiing pinamiag da yang mga masigka Israel tang kadaklan ang pinangkelan duun tung Babilonia, sam puluk si may epat ang esleb yang mga kinaampu ni Jesu-Cristo: 1. Ti Adi David 2. Ti Adi Solomon ang yay ipinangana yang sasang baw̱ay ang ya ra rin ay dating kasawa ni Urias 3. Ti Adi Roboam 4. Ti Adi Abias 5. Ti Adi Asa 6. Ti Adi Josafat 7. Ti Adi Joram 8. Ti Adi Ozias 9. Ti Adi Jotam 10. Ti Adi Acaz 11. Ti Adi Ezequias 12. Ti Adi Manases 13. Ti Adi Amon 14. Ti Adi Josias ang yay apu na Adi Jeconias ang magpurutul. Natuun tung pag̱aradien ni Adi Jeconias ang yang mga masigka Israel tang kadaklan pinamiag dang pinangkelan duun tung Babilonia. ");
INSERT INTO tbk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Mag̱impisa tung uras ang atiing pangkel tung nira ang asta tung pagkapangana tung ni Jesus, sam puluk si may epat ang esleb yang mga kinaampu ni Jesu-Cristo: 1. Ti Adi Jeconias 2. Ti Salatiel 3. Ti Zorobabel 4. Ti Abiud 5. Ti Eliakim 6. Ti Azor 7. Ti Sadoc 8. Ti Aquim 9. Ti Eliud 10. Ti Eleazar 11. Ti Matan 12. Ti Jacob 13. Ti Jose ang kasawa ni Maria ang yay nangana tung ni Jesus 14. Ti Jesus ang ya ra ka man yang pag̱aningen ang Cristo, bilang yang Mananapnay ang pinangakuan yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kapurisu mag̱impisa pa tung ni Abraham ang asta ra tung ni Adi David, may sam puluk da may epat ang esleb yang mga kinaampu ni Jesu-Cristo, ig mag̱impisa pa tung ni Adi David ang asta tung uras ang atiing pangkel tung mga masigka Israel tang kadaklan duun tung Babilonia, may sam puluk si ka may epat ang esleb ig mag̱impisa pa tung uras ang atiing pagpaelak tung nira duun tung Babilonia ang asta ra ilem tung pagkapangana tung pag̱aningen ang Cristo, sam puluk si ka may epat ang esleb. ");
INSERT INTO tbk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maning taa yang nainabu tung pag̱ingtau ni Jesu-Cristo. Atiing pagbinalay pa ilem ti Jose may ti Mariang yay mag̱ing nanay na, baklu nagkakasawaan, nasapuan da ang ti Maria pala pagmatung da. Ug̱aring yang pagmaratungun na belag̱an ang ya nga tengdanay ta tau, kung indi, natetenged ilem tung kagaeman yang Espiritu Santo. ");
INSERT INTO tbk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Simanyan ti Joseng naang binalay na, kumus luyut dang luyut pagbuat yang magkatama ang usuy tung mga katuw̱ulan, dapat da rin ang magpaintindi tung mga usgadu. Ingkasu ilem anday gustu nang pakaeyakan yang binalay na. Purisu anday dumung kinaw̱ut yang isip na, pakiblag̱an na ra ilem tung sikritu. ");
INSERT INTO tbk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Simanyan atiing nag̱apainu-inuan na ta mupia kung ya pa ag̱aring tumanen na yang planu nang atia, may sasang angil ang tinuw̱ul yang Dios ang ya ray nagpaita tung anya tung talakinepen na. Mag̱aning tung anya, “Jose, yawang sasang kanubli ni Adi David, india ra magpadua-duang magpadayun ang mangasawa tung ni Maria, ay nagmatung da tanya natetenged ilem tung kagaeman yang Espiritu Santo. ");
INSERT INTO tbk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kung mangana ra nganing, yang ipangana na sasang lalii ang ya ray paaranan mu tung ni Jesus kipurki ya ray magpaluas tung mga masigkanasyun na tung pagpakirepen nira tung pagpakasalak nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Taa numanyan yang tanan ang atia nagkamaningan da ka man ug̱ud asan da magkamatuud yang sasang ipinaula yang Dios tung sasang manigpalatay yang bitala na atiing tukaw ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“May sasang daralang magmatung ang andang pisan ay laliing masaplid tung anya. Yang ipangana na lalii ang ya ray guuyan tung ni Emmanuel,” mag̱aning. Yang linegdangan yang aran nang atia ya taa: yang Dios pagpakiunung da tung yaten ang mga tau. ");
INSERT INTO tbk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Taa numanyan atiing pagkapuaw ni Jose, tinuman na ra yang ibinitala tung anya yang angil ang atiang tinuw̱ul yang Dios. Dinayunan na rang pinangasawa ti Maria. ");
INSERT INTO tbk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ug̱aring indi ra kanay nagpakidalan tung ni kasawa na ang asta ra ilem kinaw̱ut yang pagkapangana na tung ana nang lalii. Pagkapangana na ra tung anya, ya ray pinaaranan ni Jose tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Taa numanyan ti Jesus duun da ipanganaay tung lansangan ang Betlehem tung sinakepan yang Judea. Natuun tung paggaraemen ni Adi Herodes. Pagkatapus tung pira pang bulan, may namagkaw̱ut dang mga tau duun tung Jerusalem ang mga manigpintu tung mga sinyalis yang mga dumakel. Yang banwang pinanliitan nira ampir duun tung mururaan. ");
INSERT INTO tbk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pagkaw̱ut nira, dayun dang namanalimaan-talimaan tung mga tau ang mag̱aning, “Ay ra kaya ipanganaay yang sasang mula ang yay maggaraemen tung numyung mga Judio? Ay naita ra yamen yang sasang dumakel ang tuminla ampir duun tung mururaan ang ya ray sinyalis ang dineep yamen ang tanya ipinangana ra. Purisu ya ra ka man taang inangay yamen taa ang para magluurami tung katalungaan na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Numanyan pagkagngel ni Adi Herodes yang balita natetenged tung itinalimaan yang mga manigpintung atia, ya ray pinagliwag̱an ta mupia yang isip na pati yang mga isip yang dakeleng mga tau duun tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Purisu pinagpaguuyan na yang tanan ang mga paring arabubwat ta katengdanan tung nasyun ang Israel pati mga sag̱ad tung pinanubli tung mga kinaampu. Tung pagkasagpun nira, dayun na rang tinalimaan ang mag̱aning, “Tung nagkaraula yang mga manig̱ula ming tukaw, ay pa unung banwaay ipanganaay yang pag̱aningen ang Cristo?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mag̱aning tanirang namagtimales, “Duun unu ipanganaay tung Betlehem tung sinakepan yang Judea. Ay maning taa yang bitala yang Dios ang ipinasulat na tung sasang manig̱ula yamen: ");
INSERT INTO tbk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yang lansangan ang Betlehem duun tung sinakepan yang Judea, maskin gesyeng lansangan ka man kung ikumpalar pa tung kadaklan, piru ya pay telengan ta abwat natetenged duun manliit yang sasang magmangulu tung mga tauanung mga Israel,’ mag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagkagngel ni Adi Herodes tia, dayun dang nagpaguuy tung mga bisitang atiang mga manigpintu ang para magkeresen tanira ang tanira tanira ra ilem. Atiing pagkeresen nira, pinasadsaran na ta mupia tung nira kung sanu pa enged yang primirung pagtela yang dumakel ang atiing naita nira. ");
INSERT INTO tbk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pagkaintindi na, dayun na rang ipinaangay tanira duun tung Betlehem ang pinag̱aning, “Paawatan mi enged ang sagyapen yang mulang atii kung ay ra. Ug̱aring kung masagyapan mi ra nganing, magpakdekamu ka taa tung yeen ug̱ud pati yuu mangayaw ra ka duun tung anyang magluud tung katalungaan na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Pagkagngel nira yang inaning yang Adi, dayun dang namagliit. Numanyan tung pagparanawen nira, duun si ka tuminla yang dumakel ang atiing naita nira atiing primirung pagtela na duun tung banwa nira ampir tung mururaan. Pagkatingara nira, pinangampayan da ta kasadyaan nirang duru. Ya ra ka man ay pinasikaran nira ang asta napatagbu ra tung pagtiniran yang mula. ");
INSERT INTO tbk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Numanyan pagpakled nira tung balay, naita ra nira yang mula durua ni Mariang nanay na. Pagkatapus dayun dang namansiluud tung katalungaan yang mula. Pagkatapus pag̱abri nira yang mga bebtangan nira, ipinampalua ra nirang irinigalu tung anya yang mga bulawan may yang duruang klasi ta paamut ang mga mamaalen ang yang sam bilug magkaanggid-anggid tung kamangyan ang yang sam bilug ka ya ray pag̱aningen nirang mira. ");
INSERT INTO tbk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Taa numanyan pinagpaamanan yang Dios tung talakinepen nira ang indi ra tanira mamagbalik tung ni Adi Herodes. Purisu tung pag̱ulik nira tung banwa nira, aparti rang dalanay yang pinanawan nira. ");
INSERT INTO tbk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Taa numanyan atiing namagliit da yang mga manigpintung atia, naa pala may angil si ang tinuw̱ul yang Dios ang ya ray nagpaita tung ni Jose tung talakinepen na ang mag̱aning, “Jose, bangun da! Eklan mu ra yang mulang mag̱ina ang palibriamu ra duun tung Egipto. Duunamu ra kanay magtinir mintras indi pag kaw̱utun yang uras ang ipagpaskeu tung nuyu. Ay yang mula talagang ipasagyap da ni Adi Herodes ug̱ud ipaimatay na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Purisu anday duma, pagbangun ni Jose, dayun na rang ingkelan yang mulang mag̱ina ang namagliit dang lag̱i atiing law̱iing atii ang para mamagdistinu ra duun tung Egipto. ");
INSERT INTO tbk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pagkaw̱ut nira duun, duun da kanay namagtinir ang asta napatay ra ilem ti Adi Herodes. Nagkamaningan da ta maning tia ug̱ud asan da magkamatuud yang sasang ipinaula yang Dios tung sasang manigpalatay yang bitala na atiing tukaw ang mag̱aning, “Guuyanu yang pag̱aningenung anaw ang magliit da duun tung Egipto,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ibaliku ra kanay tung ni Adi Herodes atiing indi ra binalikan yang mga manigpintu. Pagkaintindi na ang tanya pala linuku ra ilem nira, duru rang kasisilag̱en na. Anday dumang binuat na, nagkalalangan da ang pangimatayen da ilem yang tanan ang mga mamulang mga lalii duun tung Betlehem pati tung intirung paliw̱ut na ang kumpurming duruang takun yang idad nira ang asta paranek. Ay inusuy na ra ilem yang pinasadsaran na tung mga manigpintung atia kung sanu pa enged tuminlang primiru yang dumakel. ");
INSERT INTO tbk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Duun da nagkamatuud yang sasang ibinitala ni Jeremias ang yay sasang manigpalatay yang bitala yang Dios ang tukaw ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May tinangit dang nag̱agngel duun tung lansangan ang Rama. May pamagtarangiten dang pamag̱urulimengmengen. Kuari nagbangun da ti dipunta Raquel ang pagpakigtangit da ka natetenged tung mga kanubli na. Indi ra ka enged magpalinga-linga tia, ay anda ra tanira,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Taa numanyan, atiing napatay ra ti Adi Herodes, yang angil ang atiing nagpaaman tung ni Joseng magpalibri, ya si ay tinuw̱ul yang Dios ang magpaita tung anya tung talakinepen na duun tung Egipto. ");
INSERT INTO tbk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Mag̱aning tung anya, “Jose, bangun da! Eklan mu ra yang mulang mag̱ina ang mulikamu ra duun tung baw̱anwaan ming Israel, ay patay ra yang nagbalak ang magpaimatay ra rin tung mula,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Purisu anday duma, pagbangun ni Jose, dayun na rang ingkelan yang mulang mag̱ina ang nansiulik da ka man duun tung baw̱anwaan nirang Israel. ");
INSERT INTO tbk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piru atiing nabalitaan na ra ang ti Arquelao ya ray nagsubli tung pagkaadi ni tatay nang ti dipuntu Adi Herodes duun tung sinakepan yang Judea, inleran dang mag̱istar duun. Numanyan dayun sing pinapanalakinep ang uman yang Dios ang pinaske kung unu pay dapat ang buaten na. Purisu dayun dang lag̱ing nagliit ang minangay duun tung sinakepan yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Duun da nagtinir tung sasang lansangan ang maggug̱uuyan ang Nazaret. Nagkamaningan da ta maning tia ug̱ud asan da magkamatuud yang sasang naula yang mga manigpalatay yang bitala yang Dios atiing tukaw natetenged tung pag̱aningen ang Cristo ang tanya unu mag̱ing tag̱a Nazaret. ");
INSERT INTO tbk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Taa numanyan may pira rang takun baklu ra naglua ti Juan ang manigbenyag tung banwang palag-palag yang tau na duun tung sinakepan yang Judea. Duun da nagparakaw̱utun tung mga tau ang mag̱aning, “Manlignaamu ra tung mga kasalanan mi, ay kinaw̱ut da yang uras ang ipagpundar yang Dios yang paggaraemen nang baklu tung yaten,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ay ti Juan ang naa ya ra yang ipinaula yang Dios tung ni Isaias ang tukaw ang mag̱aning, “May sasang taung magparakaw̱utun tung mga tau duun tung banwang kapas ta maning taa: ‘Katulad ka tung pagsirimpanen tung sasang dalan ang panawan ta sasang Adi ang yag tadlengay, kaministiran kang simpanen mi ra ka ta mupiang tadlengen yang mga kinaisipan mi ang para magpauyunamu ra tung ni Ginuu tang magkakaw̱ut da,’ mag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ti Juan ang naa yang aw̱el na balayw̱u ta pag̱aningen ang kamilyu ang inubra tung tiral. Yang akes na ulit ta sasang ayep. Yang pamangan na apan ang maglutukun may lanaw. ");
INSERT INTO tbk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Taa numanyan yang mga tau sigi-siging pamag̱arangayan duun tung ni Juan. May mga tag̱a Jerusalem, may mga tag̱a maskin ay pang lugaray tung sinakepan yang Judea, may mga tag̱a subang atiang pag̱aningen ang Jordan ang magtirimbang tung tindak may tindak. ");
INSERT INTO tbk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Numanyan kumpurming tinu pay nangamin yang mga kasalanan na tung Dios, ya ra kay binenyag̱an na duun tung subang atia. ");
INSERT INTO tbk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Numanyan pagkaita ni Juan tung mga pamagmangulung nag̱aguuyan tung mga Pariseo may tung mga Saduseo ang duru rang pamansiangay tung anya ang para mampabenyag da ka rin, diritsyu rang pinag̱aning na ang, “Yang kaalimbawaan mi maningamu ra ilem tung mga iraw ang pamagpalibri tung kirib ang nag̱asiruk. Naa pala, pati yamu nag̱aisipamu ra kang magpalibri tung sintinsiang ipadangat yang Dios! ");
INSERT INTO tbk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kaministiran bakluamu ra nga benyag̱ayu kung may pruibang ipinaita mi tung mga ubra-ubra mi ang talagang nanlignaamu ra ka man ang matuud tung mga kasalanan mi. ");
INSERT INTO tbk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Indiamu ra ka maglaum ang kumus yamu mga kanubli ni Abraham, indiamu siguru sakpen yang sintinsia nang atia. Uay, maski yang mga batung atia, iugtulu tung numyu, sarangan ang papag̱ingtauen yang Dios ang para buaten nang mga kanubli ni Abraham. ");
INSERT INTO tbk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yang sintinsia nang atia, maski nganing simanyan, yang kaalimbawaan na maning pa tung sasang parakul ang nabiw̱at dang ipatpa ra ilem tung kapungul yang sasang ayu. Kumpurming unu pang ayuay ang belag̱an matinlu yang burak na, ya ray pelaren ang sirukun tung apuy. ");
INSERT INTO tbk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tung bag̱ay may katengdananu ka man ang magpamenyag tung numyu taa tung wai ang naa ang para asan da nga papruibaay mi ang nanlignaamu ra ka man ang matuud tung mga kasalanan mi. Piru may sasang taung nag̱auri pa tung yeen ang mas abwat ta katengdanan tung yeen, ang basin nganing tung pamitbit da ilem yang sandalyas na, indiaw pa ka enged magkabag̱ay. Yang anyang katengdanan maning pa tung magberenyag̱en ka tung numyu ekel tung pagpatinir na tung numyu yang Espiritu Santo u kung indi, apuy ra yang gamiten na. ");
INSERT INTO tbk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yang kaalimbawaan na maning pa tung sasang taung pag̱ekel ta linung magkaap yang paray ang gineyek na. Yang timlat ya ray ipabtang na tung tambuw̱u na. Piru yang kaap ya ray sirukun na tung apuy ang anda enged ay kapugdaw-pugdawan na,” ag̱aaning duun ti Juan. ");
INSERT INTO tbk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Taa numanyan, ti Jesus nagliit da tung Galilea ang minangay duun tung ni Juan ug̱ud magpabenyag da ka tung anya duun tung subang atiang pag̱aningen ang Jordan. ");
INSERT INTO tbk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piru tung pagkaw̱ut na tung ni Juan, tinag̱aman da rin ni Juan ang sambengen. Mag̱aning tung anya, “Abaa yuuy may kaministiranung magpabenyag tung nuyu, piru yawa pa pala ay magpabenyag tung yeen?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mag̱aning ti Jesus ang minles, “Kung tung bag̱ay, Juan, tama ka rin tiang nuyu. Piru simanyan ang mga uras ang naa, kaministiran ang magpauyuna ra ilem tung yeen. Ay tung maning tia, matuman ta ra yang kumpurming unu pay nag̱ipatuman yang Dios tung yaten,” ag̱aaning. Atii baklu pa nagpauyun ti Juan ang nagbenyag tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Atiing nagpabenyag da ti Jesus, dayun dang nagpatakas. Pagkatakas na, ya ray natingara na yang langit ang gulpi ra ilem ang nag̱abri tung tagbu na ang pagkatapus ya ray naita na yang Espiritu Santong napapariu ra tung kuari kalapati ang paparanek da ang asta nangapun da tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pagkatapus may busis ang liit tung langit ang mag̱aning, “Atia ra yang pag̱aningenung anaw ang nag̱apabuyukanu ta gegmaw ay ya ra kang lag̱i ay nag̱auyunanu ta mupia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Taa numanyan ti Jesus minanguluan da yang Espiritu Santong pinapanaw duun tung banwang kapas ug̱ud duun da kanay tag̱amay ni Satanas ta tuksu. ");
INSERT INTO tbk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Numanyan tung seled epat ang puluk ang kaldaw, law̱iig kaldaw, namlek da tung pagparanganen na ang para mabilug na yang isip na tung pag̱irintindien na tung Dios. Purisu yang pinakaw̱ut na nasuw̱uk da. ");
INSERT INTO tbk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Atii, pinalengtan da yang kanunuksu ang inaning, “Kung matuud ang yawa ka man yang pag̱aningen ang Ana yang Dios, abir, lalangan mu ra yang mga batung atiang mamagyari rang tinapay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mag̱aning ti Jesus ang nagtuw̱al, “Aa, indiaw, kipurki may sasang bitala yang Dios ang napabtang tung kasulatan ang belag̱an ilem unu pamangan ay impurtaen yang sasang tau ang para tung ikalayun na, kung indi, yang mas pa unung impurtaen na ya ra unu yang kumpurming unu pay bitala ang nag̱ianing yang Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkatapus tia, ti Jesus ingkelan da ni Satanas duun tung Jerusalem ang yay pag̱aningen ta mga tau ang siudad ang sagradu. Duun eklay na tung sagpaw enged yang pagtuuan tung Dios ang atiang pinakalusu. ");
INSERT INTO tbk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mag̱aning si tung anya, “Kung matuud ang yawa ka man yang pag̱aningen ang Ana yang Dios, abir, pabugsua ra asan. Tutal may sasang bitala tung kasulatan ang patuw̱ulana ra unu yang Dios tung mga angil nang pabantayan. Sarepena ra ka unu nira ug̱ud indi ra ka matigbak yang kakay mung tempa tung kabatuan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mag̱aning ti Jesus ang nagtimales, “Ee, tama ka rin yang inulit mung atia, piru may dumang bitala tung kasulatan ang dapat unu indiaw magtag̱am ta ingaw̱us tung ni Yawi ang ya unu ay Dios ang may kalalangan tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Utru si, dayun dang ingkelan ni Satanas duun tung bukid ang durug abwat. Ipinaita na tung anya yang tanan ang inadian tung bilug ang kaliw̱utan pati yang katitinlu nira. ");
INSERT INTO tbk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mag̱aning tung anya, “Yang tanan ang atii luw̱us ang ipakdulu tung nuyu basta magluura ra ilem taa tung yeen ang magtuu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dayun da kang binalesan ni Jesus ang inaning, “Paaw̱ig̱a ra ilem taa, Satanas, kipurki may bitala tung kasulatan ang anda unu ay dumang luuranung tuuan, kung indi, ultimu ilem ti Yawi ang yay Dios ang may kalalangan tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagkatapus tia, dayun dang nagliit ti Satanas tung anya. Pagliit na, asan da namansilput yang mga angil ang namag̱asikasu tung mga kaministiran ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Taa numanyan atiing pagkabalita ni Jesus ang ti Juan ang manigbenyag dineep dang ipinakalabus, dayun dang nagliit ang nanganing duun tung sinakepan yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pagkaw̱ut na duun tung lansangan ang Nazaret, indi nagpakeen duun, kung indi, tung pagtaklib yang pira pang kaldaw, nagpadayun da yang pagparanawen na ang para duun da magdistinu tung lansangan ang Capernaum ug̱ud duun da kanay mag̱istar. Yang lansangan ang atia nabtang tung binit yang aw̱uyuk ig lug̱ud ka tung banwang ipinagparti-parti atiing tukaw tung mga kanubli ni Zabulon may ni Neftali. ");
INSERT INTO tbk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nagkamaningan da ta maning tia ug̱ud asan da magkamatuud yang sasang ipinaula yang Dios ang tukaw tung ni Isaias ang sasang manigpalatay na ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Yang mga taung pamag̱istar duun tung banwang ipinagparti-parti atiing tukaw tung mga kanubli ni Zabulon may ni Neftali ampir duun tung aw̱uyuk pati duun tung duw̱ali yang subang Jordan, asta duun tung Galilea ang yay nag̱aistaran yang mga taung belag̱an mga Israel, maskin nag̱akiklepan ka man yang mga kinaisipan nira, piru may maita nirang maning pa tung sasang kaas ang durug sadlaw. Maskin alalawid ka man tanira tung Dios ang maning pa tung patay tung pagterelengen na, piru magkaratingkalan da ka enged yang sadlaw yang maning pa tung kaas ang atia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Taa numanyan, mag̱impisa pa tung pagpakalabus tung ni Juan, ti Jesus ya si kay nagparakaw̱utun tung mga tau ang maning taa: “Manlignaamu ra tung mga kasalanan mi, ay kinaw̱ut da yang uras ang ipagpundar yang Dios yang paggaremen nang baklu tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Taa numanyan atiing pagbakay ni Jesus tung aw̱uyuk ang atiang lug̱ud tung sinakepan yang Galilea, naita na ti Simon duruang mag̱ari ni Andres ang pamanlaman ta ian ay tanira mga manig̱ian. ");
INSERT INTO tbk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mag̱aning ti Jesus tung nira, “Magpakignunutamu ra tung yeen ang magpaugyat. Dati-rati yang mag̱aeklan mi ian. Piru numanyan ugyatanamu ra ka yeen kung ay pa ag̱aring maeklan mi yang mga kinaisipan yang mga tau ang basi pa ra ilem malelyag da kang magpaugyat tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Numanyan lag̱i-lag̱ing binutwanan da nira yang mga laman nira ang namagpakignunut tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Numanyan matukaw-tukaw tanira na Jesus ta gesye, naita na ti Santiago duruang mag̱ari ni Juan ang yay mga ana ni Zebedeo. Asan tanira tung balangay nirang pamag̱eet yang mga laman nira, kasiraan da ka tanira ni tatay nira. Pagkaita ni Jesus tung nirang durua, dayun na rang inimbitar ang mamagpakignunut da tung anyang mamagpaugyat. ");
INSERT INTO tbk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Atii, lag̱i-lag̱ing binutwanan da nira yang balangay nira may ti tatay nira ang namagpakignunut da ka tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Taa numanyan nagliliw̱utun da ti Jesus tung intirung sinakepan yang Galilea. Nag̱intra ra pagturuldukanen tung mga tau ang kada mamagsaragpun-sagpun tung nira nirang mga pagsaragpunan. Nagparakaw̱utun da dayun tung nira yang sasang matinlung balita ang yang Dios mag̱impisa rang magtukud yang paggaraemen nang baklu tung mga tau. Pati yang mga taung may mga laru nira, pinampamaayen na ra ka, maskin unu pang laruay. ");
INSERT INTO tbk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Purisu nagsarambung da yang balita tung intirung banwang atii ang asta duun tung sinakepan yang Siria. Anday dumang dinangat na, duru-durung mga taung ipinagpadangep da tung anyang sari-sari ra ilem yang nag̱asinti nirang mga masiit. Yang duma magsisiitan da ta duru, yang duma magdimunyuen, yang duma may mga kere, yang duma pamamatay ra yang mga tinanguni nira. Numanyan tanirang tanan, luw̱us dang pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Purisu buntun dang pisan yang mga taung namagpakignunut da tung anya. May asan dang mga tag̱a Galilea, may asan da kang mga tag̱a Sampuluk NGa Lansanganan, may asan da kang mga tag̱a siudad ang Jerusalem, may asan da kang mga tag̱a Judea, may asan da kang mga tag̱a duw̱ali yang subang Jordan. ");
INSERT INTO tbk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Numanyan pagkaita ni Jesus tung mga taung atiang buntun, napatungul da ta gesye tung napabukatud ang kuminarung ay magturuldukanen da tung nira. Tung pagkarung na, dayun dang pinalengtan yang mga taung atiang pamagpaugyat da kang lag̱i tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Numanyan nag̱impisa rang nagturuldukanen tung nira ang maning taa: ");
INSERT INTO tbk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming nakapasan dang pisan ta magtalig̱an nira tung mga sadili nira! Ay yang nag̱ikatinlu na asan, laket da tanira tung mga taung pamagpagaem tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming pagsug̱at tung mga kasalanan nira ang asta nag̱ipanangit da ilem nira. Ay kipurki yang nag̱ikatinlu na asan, taniray linga-lingaen da yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming mapinagparanek. Ay kipurki yang nag̱ikatinlu na asan, taniray pakinaw̱angen yang Dios tung kaayenan ang pinangakuan na tung mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung indi ra temegka kung indi ra tumanen nira yang magkatama tung pagterelengen yang Dios ang maning pa tung sasang taung puirti ra yang kasusubkun na ubin pagsinti ra ta puirting kakanalen na. Ay kipurki yang nag̱ikatinlu na asan, taniray papsawen yang Dios tung nag̱alelyag̱an nirang atia. ");
INSERT INTO tbk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming mainildawen tung mga masigkatau nira. Ay kipurki yang nag̱ikatinlu na asan, tanira ra kay ildawan yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming bilug yang mga isip nira tung Dios ang anday dumang pag̱asikad nira, kung indi, ya ra ilem yang kalelyag̱an na. Ay kipurki yang nag̱ikatinlu na asan, taniray maita tung anya tung uri. ");
INSERT INTO tbk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming matinaw̱angen tung mga aruman nirang pagsuayan ang para mag̱inulikay ra. Ay kipurki yang nag̱ikatinlu na asan, taniray agkaw̱ig̱en da yang Dios ang mga ana na natetenged parariu tanira ta pag̱asikad. ");
INSERT INTO tbk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Teed mi tia agkatinlu yang nag̱abtangan yang mga taung kumpurming nag̱apasaran ta padeeg-deeg natetenged tung pagburuaten nira yang magkatama! Ay kipurki yang nag̱ikatinlu na asan, laket da tanira tung mga taung pamagpagaem dang bug̱us tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pati yamu, teed mi tia agkatinlu yang nag̱abtangan mi kung insultuenamu ra nganing ta duma natetenged tung pagtaralig̱en mi tung yeen ubin kung ya ra ka nganing ay ipandeeg-deeg nira tung numyu ubin kung ya ra ka nganing ay ipagpetel nira tung numyu ta sari-saring malalain ang pulus bukli. ");
INSERT INTO tbk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Purisu ya ray pagkalipayan mi enged ta mupia ay natetenged asan da nga pruibaay ang may ibles ka man yang Dios tung numyung durung pisan agkadakul yang kantidad na ang ya ra kay nag̱ibaratu na tung numyu duun tung langit. Kipurki pati nganing yang mga manigpalatay yang bitala nang tukaw, pinamuatan ka ta magkapariu ka tung buw̱uaten nirang atia tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yang kaalimbawaan mi yamu maning pa tung kasin ang yay kaministiran ta tanan ang mga tau taa tung kaliw̱utan ang naa. Ug̱aring yang kasin kung alimbawa manlasay ra, anda ray rimidyung sarang mabuat ang para maulikan pa. Anday duma, kumus anda ray kuinta na, ibukbuk da ka ilem asan tung magliked-likeran ta mga tau. ");
INSERT INTO tbk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yang sam bilug pang kaalimbawaan mi, yamu maning pa tung sasang kaas ang pagpakdul ta masadlaw tung mga tau taa tung kaliw̱utan. Ay kung paniiranamu ta mga masigkatau mi, puidi ra kang mangatultul tung Dios ekel tung numyu. Katulad tung sasang lansangan ang napabukatud ang inding pisan mataluk yang sadlaw na, yang gustuu ang ya ra kay kaalimbawaan yang mga pagburuaten ming matitinlu. ");
INSERT INTO tbk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ayw̱a, tinu pay nag̱aintindian ming tau ang magsindi ta kaas ang pagkatapus ya rag sukluw̱ay na ta baay? Simpri asan ipabtangay na tung tapi-tapi ug̱ud masadlawan da yang tanan ang mga tau tung balay. ");
INSERT INTO tbk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Purisu ta yamu, maning pa tung pasig̱aaken mi ra ta mupia yang mga kaas mi ug̱ud kung maita ra nganing yang mga masigkatau mi yang pagburuaten ming matitinlu, ya ray dayawen nira tung Ama mi duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Indiamu maglaum ang yuu may intinsiunung mag̱imbalidu tung mga katuw̱ulan ang atiing ibinutwan ni Moises ubin tung ipinagpadapat yang pinanuw̱ul yang Dios ang tukaw ang magpalatay yang bitala na. Kung indi, yang pag̱asikaru ang ya ray badbaranu ta maayen ug̱ud asan da nga pakdulayu ta kantidad nirang magkatunung pisan tung pag̱irintindien yang Dios mismu ang yay nagpakdul. ");
INSERT INTO tbk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kipurki iugtulu tung numyu yang kamatuuran, ang asta mapareng da ilem yang kalangitan may yang katanekan, kumpurming unu pay nasambit tung mga katuw̱ulan ang atia, maskin sam parti ilem ang gesye, indi ra ka enged magpurawas ang asta kaw̱utun da ka enged yang katuyuan na. ");
INSERT INTO tbk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Purisu kung tinu pay magbaliwala tung mga katuw̱ulan ang naang ipagngelu tung numyu, maskin sam bilug ilem ang kalaum na belag̱an masyadung impurtanting tumanen, ang pagkatapus maning da tia yang nag̱itulduk na tung duma, yang taung atia, telengan da yang Dios ang belag̱an kang masyadung impurtanti kung ikumpalar pa tung kadaklan ang pamagpagaem tung anya. Piru kung tinu pay pagtuman ang pagkatapus ya ra kay nag̱itulduk na tung duma, asan da ta taung telengan yang Dios ta abwat tung mga taung pamagpagaem tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ag̱aningenamu ra yeen ta maning tia, ay kung yang pag̱urusuyun mi tung magkatama anday nag̱alandawan na tung pag̱urusuyun yang mga sag̱ad may yang mga Pariseo ang asan da ilem ngaeklay nira tung pagpaita-ita ilem nira, tay puis, indiamu enged malg̱ud tung palaksu yang paggaraemen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ipinagngel da tung numyu yang sasang katuw̱ulan ang ipinagpadapat ni Moises tung mga kinaampu tang tukaw ang dapat unu indi ra tanira mangimatay ta masigkatau nira. Nag̱askean mi ra ka ang kung tinu pay mangimatay tung masigkatau na, dapat eklan tung ustisia ang para masintinsiaan dang tumaran ta aksiun. ");
INSERT INTO tbk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piru ya ra taa yang yeen ang pagbaradbaren tung katuw̱ulan ang atia. Kung tinu pay masilag tung aruman nang nunut ta pagdemet na, magkabag̱ay ka rin ang patalungaen tung usgadu ang para masintinsiaan na ra. Kung tinu pay mag̱insultu tung aruman nang ya ra ag̱aningay nang ‘Yawang inutila rang taua,’ magkabag̱ay ka rin ang patalungaen tung mga usgadung pinakaabwat. Kung tinu pay magbuyayaw tung aruman nang ya ra ag̱aaningay nang ‘Kulang-kulanga kang lag̱ing pagkatau’, yang taung atia sintinsiaan yang Dios ang iplek duun tung impirnu ang andang pisan ay kapugdaw-pugdawan yang apuy na. ");
INSERT INTO tbk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Purisu kung alimbawa magpadasag̱amu ta sasang ayep duun tung midyu lamisaan ang atiang darasag̱an, ang pagkatapus mademdeman mi ra ang may sasang putul ming may nag̱asilag̱an na tung numyu natetenged tung sasang binuatan ming malain tung anya, yang buaten mi ya taa. Butwanan mi ra ilem yang ayep asan tung katalungaan yang darasag̱an ang pagkatapus antimanung sagyapen mi ra yang putul ming atia ang para mag̱inintindiayamu rang mag̱inulikay. Ya ra kanay tukawen mi, bakluamu ra magbalik ang magpadayun yang pagpadasag mi. ");
INSERT INTO tbk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kung alimbawa nag̱aguyuranamu ra yang sasang taung para idangepamu ra anya tung ustisia natetenged tung utang ming indi mi pa nag̱abayaran, mas maayen pang magpakigkesenamu ra ta makali tung anya ang para magsunduanamu rang lag̱i mintras asanamu pa pagpanaw tung dalan. Ay kung indi mi buaten tia, muya papirdienamu ra ilem yang wis ang pagkatapus dayunamu rang anyang iintriga tung pulis ang para ipakalabusamu ra. ");
INSERT INTO tbk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iugtulu tung numyu, indiamu ra ka enged malua ang asta mabayaran mi ra yang tanan ang nag̱ipabayad yang wis tung numyu, maskin may nag̱aeped pang san sintabus da ilem. ");
INSERT INTO tbk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ipinagngel da ka tung numyu ang may sasa kang katuw̱ulan yang Dios ang ipinagpadapat ni Moises tung mga kinaampu tang tukaw ang dapat unu indi ra maglimbung tung mga kasawa nira. ");
INSERT INTO tbk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piru ya ra taa yang yeen ang pag̱irintindien tung katuw̱ulan ang atia. Kumpurming tinu pay magteleng pa ilem tung dumang baw̱ay ang may gustu nang pakinaw̱angan, katimbang nang linimbungan na ra ti kasawa na maskin tung pupusukun na pa ilem. ");
INSERT INTO tbk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Purisu kung midyu yang pagteleng mi ya ray makanayan ta ipagpakasalak mi, sibaya maluat da asan yang mata mi tung panguntiel mi tung tuksung atia, tung magpanunut, indiamu ra enged. Kipurki maayen pang maplekanamu ra ta sam parti ilem tung tinanguni mi kay tung anda pay buin yang tinanguni mi ang duunamu ra iplekay tung impirnu. ");
INSERT INTO tbk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kung midyu may sasang buaten mi ang yang kalima ming tuu ya ray gamiten mi ang pagkatapus ya ray makanayan ta ipagpakasalak mi, sibaya mapungkulanamu ra asan ta panguntiel mi tung tuksu, tung magpanunut, indiamu ra enged. Kipurki maayen pang maplekanamu ra ta sam parti ilem tung tinanguni mi kay tung anda pay buin ang duunamu ra manampet tung impirnu. ");
INSERT INTO tbk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ipinagngel da ka tung numyu yang sasa si kang katuw̱ulan yang Dios ang ipinagpadapat ni Moises tung mga kinaampu tang tukaw ang yang sasa unung lalii, kung magpakiblag da tung kasawa na, baklu paliiten na, dapat unung pakdulan na ta kabakeran nang pagpailala ang nagbelag da tanirang magkasawa ig liw̱ianu ra yang baw̱ay ang magpakasawa si tung duma. ");
INSERT INTO tbk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piru ya ra taa yang yeen ang pag̱irintindien tung bag̱ay ang atia. Yang sasang lalii may rasun na ilem ang magpakiblag tung kasawa na kung talagang naglimbung dang matuud tung anya. Piru kung anda, ang pagkatapus belag̱an na ka enged ang asta pangasawaen si ta dumang lalii, katimbang nang asan da nga regsanay na yang kasawa nang maglimbung tung anya. Pati yang lalii kang sam bilug ang mangasawa tung baw̱ay ang atiang binlag̱an da yang dating kasawa na, katimbang na kang asan da ka nga sirungay na yang dating may kasawa. ");
INSERT INTO tbk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Utru si, ipinagngel da ka tung numyu yang sasang katuw̱ulan yang Dios ang ipinagpadapat tung mga kinaampu tang tukaw ang kung may pinangakuan nira tung sasang tau ang pagkatapus sinumpaan nira tung aran yang Dios, dapat ang indi nira talyuran, kung indi, ubligaren da ka enged nira yang pinangakuan nira. ");
INSERT INTO tbk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Piru ya ra taa yang yeen ang pag̱irintindien tung pagsurumpaen ang maning tia. Kung yamu magpangaku tung aruman ming tau, indi mi ra ilem paugtunan ta maskin unu pang panumpaay. Indiamu ra manumpa tung tanek may langit ay kipurki yang tanek may kalalabten ka yang Dios. Kipurki yay maning pa tung parabdungan yang kakay na. Maskin yang langit ya ka ay kipurki yay maning pa tung pagkarungan na. Indiamu ra ka manumpa ang yang siudad ang Jerusalem yay magew̱a kung indi mi matuurun yang nabitalaan mi. Ay kipurki yang siudad ang atia, ya enged ay siudad ang pagtuuan yang mga tau tung Dios ang yay Ading makagag̱aem. ");
INSERT INTO tbk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Indiamu ra ka manumpang ang kuw̱anen pang lag̱i yang bua mi kung indi mi kegngan yang pinangakuan mi ay kipurki maskin pang mga bua mi ilem, may kalalabten pa ka enged yang Dios. Maskin sa nga buaan mi ilem nganing, indi mi masarangan ang mapakuw̱anan ubin mapalag̱em. ");
INSERT INTO tbk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Indiamung pisan manumpa, kung indi, kung magpaeeamu tung aruman mi ay ee ra ilem ang pagkatapus buaten mi ra ilem. Ubin kung mangindiamu tung anya, ay indi ra ilem. Ay kung paugtunan mi pa ta mga maning tiang mga panumpa, anday dumang pagpaisip tung numyu ang yay matinlung buaten mi, ya ra ti Satanas mismu ang yay pinangapunglan ta tanan ang kabuklian. ");
INSERT INTO tbk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ipinagngel da ka tung numyu yang sasang katuw̱ulan yang Dios ang ipinagpadapat ni Moises tung mga kinaampu ta ang kung tinu pa unu ay manluat yang mata yang aruman na, yang sintinsiang ipakdul tung anya, luatan ka unu ta mata na. Dispuis kung tinu pa unu ay mamingaw yang isi yang aruman na, ya si ka unu ay bingawan. ");
INSERT INTO tbk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piru ya ra taa yang yeen ang pag̱irintindien natetenged tung bag̱ay ang atia. Indiamu enged ang pisan mangimalesan tung taung nagbuat ta malain tung numyu. Kung alimbawa tampalingenamu anya tung emet ming tuu, italiling mi pa yang duw̱aling emet ming ipatampaling kung gustu nang dublian. ");
INSERT INTO tbk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kung alimbawa may pinangutangan mi ta kuarta ang yang gustu na idangepamu ra anya tung usgadu ang para yang lambung mu ya ray mataren na bilang pirinda tung nautangan mi, pati yang panlamig mi ipatug̱ay mi ra ka tung anya kung ingalukun na pa. ");
INSERT INTO tbk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kung alimbawa may sundalung tag̱a Roma ang magreg̱es tung numyung magsakan yang mga kargamintu na ta distansia ta sang kilometro, saknen mi tung maayen ang kinaisipan maskin duruang kilometro pa yang pategkaan mi. ");
INSERT INTO tbk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kung alimbawa may mandawat tung numyu, pakdulan mi. Kung may taung mamles tung numyu ta unu pay gustu nang belsan, indi mi ka pangindian, kung indi, pablesen mi ka. ");
INSERT INTO tbk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ipinagngel da ka tung numyu yang sasang katuw̱ulan yang Dios ang ipinagpadapat ni Moises tung mga kinaampu ta atiing tukaw ang dapat unung gegmaan nira ta mupia yang mga aruman nira. May sam bilug pang idinulang ta duma ang maskin demtan unu nira yang kumpurming pagpakigsuay tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piru ya ra taa yang yeen ang pag̱irintindien tung bag̱ay ang atia. Yang dapat ang gegmaan mi pati yang mga taung pagpakigsuay tung numyu. Kung may asan ang pagpandeeg-deeg tung numyu, ya ipag̱ampuay mi tung Dios ang pakaayenen na. ");
INSERT INTO tbk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kung maning tia yay buaten mi, asan da nga pruibaay ang pariuamu ra ta ug̱ali yang Ama mi duun tung langit. Kipurki yang ug̱ali na, maskin yang mga malalain ang mga tau, maskin yang mga maraayen man, parariu ka ilem nag̱apatingkalan na ta sadlaw yang kaldaw ang inimu na. Maskin yang mga taung pamag̱usuy tung kalelyag̱an na, maskin yang pamagpasuag man, parariu ka ilem ang nag̱apakdulan na ta kuran. ");
INSERT INTO tbk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ay kung yang gegmaan mi ya ra ka ilem yang paggegma tung numyu, unu pa pay dayawen yang Dios tung numyu asan? Belag bang maning ka tia yang nag̱abuat yang mga manigpanukut ta mga balayaran tung gubirnu ang yay nag̱alamku ming teleb ta kasalanan? ");
INSERT INTO tbk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kung yang sapten mi ta matinlu ya ka ilem yang mga ungkuy mi, ay pa pay kalandawan na tia? Belag bang maning ka tia yang nag̱abuat yang mga taung indi nganing pamag̱intindi tung Dios? ");
INSERT INTO tbk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Purisu ta yamung mga nag̱apangugyatanu, kumus yang Ama mi duun tung langit timlat yang ug̱ali nang nag̱ipaita na tung tanan ang mga tau ang anday pinilikan, ya ra kay paatuan ming mga ana na. ");
INSERT INTO tbk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Amlig̱an mi ang yang pagburuaten mi yang matinlu ang tung paita-ita ilem tung mga tau. Kipurki kung maning tia ay buaten mi, anda ra ka ilem ay elatan ming ibles yang Ama mi duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pariu ra asan tung paglilimusun mi, kung maglimusamu ra nganing, indi mi ra ilem ipasapet tung duma ang katulad ka tung nag̱abuat yang duma ang pamagpakaayen-ayen ilem, ang baklu maglimus kung duun da tung mga pagsaragpunan nira ubin duun tung mga karsada ang para maita ta durung tau. Ay yang pag̱asikad nira asan ang para dayawen ilem tanira ta mga tau. Manangeramu tung yeen, yang mga taung mga maning tia, anda ray dumang elatan nirang ibles pa yang Dios tung nira, kung indi, asan da ka ilem negka tung pagdarayawen yang mga taung atia tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Piru ta yamu, kung maglimusamu ra nganing, buaten mi ang anda ray masiman tung pag̱abuat mi, maskin pa yang sasang ungkuy ming sebek tung numyu. Ang pagkatapus yang Ama ming atiang nag̱aita yang kumpurming nag̱abuat mi tung taluk, ya ra kay magbales tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Dispuis kung mag̱ampuamu ra nganing, indiamu ra mag̱usuy tung mga taung atiang pamagpakaayen-ayen ilem. Kipurki tanira kung mag̱ampu ra nganing, durung kalelyag nirang duun da magkereng tung parada tung pagsaragpunan ubin duun tung mga kantung palanawan ta durung tau ang para maita ilem tanira ta kadaklan ang pag̱ampu. Manangeramu tung yeen, anda ray dumang elatan nirang ibles pa yang Dios tung nira, kung indi, asan da ka ilem negka tung pagterelengen yang mga taung atia tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Maayen pa ta yamu, kung mag̱ampuamu ra nganing, magpalingew̱amu ra kanay ang mag̱ampu tung ama mi ang indi mi nag̱aita. Ang pagkatapus yang Ama ming atiang nag̱aita yang kumpurming unu pay nag̱abuat mi tung taluk, ya ra kay magbales tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Dispuis, kung mag̱ampuamu ra nganing, indiamu ra ilem magbew̱engat agbew̱engat ta mga bitalang sari-sari ra ilem ang indi ka ilem naluak tung mga pupusukun mi ang katulad ka tung duma ang indi pag̱intindi tung matuud ang Dios. Ay kalaum nira asan da tanira nga sapetay yang mga ginuu-ginuu nira tung pag̱arampuen nirang mag̱umpuk da ilem yang mga bitala nira. ");
INSERT INTO tbk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Indiamu ra mag̱usuy tung nira. Tutal nag̱akdekan dang lag̱i yang Ama mi kung unu pay mga kaministiran mi baklu mi ingalukay tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Purisu mas matinlu maning taa yang pag̱arampuen mi tung Dios: ‘Ama yamen asan tung langit, taw̱angayami ka ang para yang panggalang yamen tung nuyu mag̱atu tung pagkadios mung durung pisan agkasagradu. ");
INSERT INTO tbk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gustu yamen ang tung makali ipabistu mu ra enged ang pisan yang paggaraemen mu tung tanan. Taw̱angayami kang magtuman yang mga kalelyag̱an mu tani tung kaliw̱utan ang nani ang katulad ka tung pagturumanen yang mga angil mu asan tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pakdulayami ka yang pamangan ang kaministiran yamen numaan ang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dispuis Ama, patawarayami ka tung mga kasalanan ang nagkarabuat yamen tung nuyu ang katulad ka tung yamen ang nagpatawarami ra ka tung mga kaarumanan yamen ang nagbuat ta kasalanan tung yamen. ");
INSERT INTO tbk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ig indiami ka ilug̱ut mu tung mga maliliwag ang sukda ang muya indi masarangan yamen, kung indi, ipalibriayami kang pirmi tung taktika ni Satanas ang yay pinangapunglan ta tanan ang malalain ang pag̱urubraen. Tung maning tiang palaksu ipausuyay mi yang pag̱arampuen mi tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Talagang impurtanti tiang pagparatawaren mi tung mga aruman mi ay kipurki kung patawaren mi tung mga kasalanan ang binuat nira tung numyu, atia patawarenamu ra ka yang Ama mi duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piru kung indiamu magpatawad tung mga aruman mi, tay indiamu ka mapatawad yang Ama mi duun tung langit tung mga pagburuaten ming malalain tung pagterelengen na. ");
INSERT INTO tbk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kidispuis pa, tung uras ang ipamlek mi tung pagparanganen mi ang para bilug yang mga isip mi tung pag̱irintindien mi tung Dios, indiamu ra mag̱usuy tung ug̱ali yang mga taung atiang pamagpakaayen-ayen ilem. Kipurki yang mga ityura nira ya ray papungawen nirang nunut da ka ta leg̱ed ta kaw̱u ug̱ud makali rang masapet ta mga tau ang tanira pamlek da tung pagparanganen nira. Manangeramu tung yeen, anda ray dumang elatan nirang ibles pa yang Dios tung nira, kung indi, asan da ilem negka tung pagsarapeten yang mga taung atia tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Maayen pa ta yamu, kung mamlekamu ra nganing tung pagparanganen mi, damusan mi yang mga ityura mi ig salyangen mi ka yang mga bua mi ug̱ud indi masiman ta mga tau ang yamu pamlek da tung pagparanganen mi, kung indi, yang sulaminting maske tia ultimu ilem yang Ama ming indi mi nag̱aita. Ang pagkatapus yang Ama ming atiang nag̱aita yang kumpurming unu pay nag̱abuat mi tung taluk, ya ra kay magbales tung numyu.” ");
INSERT INTO tbk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mag̱aning ti Jesus ang nagpadayun yang pagwaraswasen na, “Indiamu ra magtaluk ta manggad taa tung katanekan. Kipurki kung taa yang manggad mi, puiding tekteken ubin baktaen ta andap ubin takawen ta mga taung ansianung magpamangbang tung mga balay. ");
INSERT INTO tbk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Maayen pa ang yang paderepan mi ang yamu mag̱usuy tung nag̱auyunan yang Dios ang yang kaalimbawaan na maning pa tung ya ray manggad ang nag̱italuk mi duun tung langit. Ay kung duun italukay mi, indi ra tekteken, indi ra ka panganen ta andap, indi ra ka takawen. ");
INSERT INTO tbk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Duunamu magtaluk ta manggad mi ay kipurki kung ariamu pa magmanggad, ay duun da ka nga gamen yang mga isip mi. ");
INSERT INTO tbk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kung ya ipananglitayu yang nag̱aaningung atia, ay maning taa. Yang maning pa tung kaas ang pagpakdul ta masadlaw tung tinanguni mi ya ra yang mga mata mi. Kung masadlaw, pati intirung tinanguni mi damay ra ka tung masadlaw. ");
INSERT INTO tbk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piru kung makiklep, tay pati intirung tinanguni mi umid da ka tung makiklep. Ig disir pati yang isip ming yay maning pa ka tung kaas tung mga sadili mi, maskin kalaum ming bilug tung kalelyag̱an yang Dios, piru kung tung pagkamatuud pagtenakan da, teed mi tiag kakiklep yang nag̱abtangan mi! ");
INSERT INTO tbk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nani pa yang sam bilug ang pananglit. Yang sasang tau indi enged maimung magbilug yang isip na kung duruay pangag̱alenan na. Ay kung durua, anday dumang mainabu, yang sam bilug ya ray maalen nang panirbian ta ustu, piru yang sam bilug, ya ray silag̱an nang duminaren. Purisu asan da ngaintindiay mi ang kung manggad yang nag̱apagamenan mi, indi enged maimu ang yang Dios ya pay mapanirbian mi. ");
INSERT INTO tbk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Purisu ya ra ka man taang nag̱ipag̱aningu tung numyu. Indiamu ra magpakabegbeg ta mga kulu mi natetenged tung pagpangabui mi kung ariamu pa mangkel ta mapangan mi u kung ariamu pa mangkel ta aw̱el ang masuut mi tung mga tinanguni mi. Pinakdulanamu ra nganing yang Dios yang mga linawa mi. Ya pang pamangan mi ilem, indiamu ka sarangan nang pakdulan? Pati mga tinanguni mi, pinakdulanamu ra ka nganing anya. Ya pang aw̱el mi ilem, indiamu ka sarangan nang pakdulan? ");
INSERT INTO tbk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Telengan mi ra ilem yang mga lamlam ang pamaglayug-layug tung pamilat-pilatan. Tanira indi pamagtugda, indi ka pamangayeg, indi ka pamagpatakwal yang mga paray nira tung tambuw̱u nira, piru ag̱asikasuen ka yang Ama mi duun tung langit. Pagkatapus yamung mas maal tung anya kay tung nira, indiamu ka w̱asu asikasuen na? ");
INSERT INTO tbk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Abir, tinu pa w̱asu asan tung numyu ay sarang ang mapagpalagway tung kabui na ta maskin sang uras da ilem ekel tung pagpakabegbeg na tung kulu na? ");
INSERT INTO tbk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Dispuis ayw̱a nag̱apabegbeg̱an mi ta mga kulu mi yang mga aw̱el ang kaministiran mi? Telengan mi ra ilem yang mga talay ang atia tung paliw̱ut ta. Indi ka tanira pamagpakabedlay ang pamagpangabui, indi ka pamagbuat ta mga aw̱el nira tung tiral. ");
INSERT INTO tbk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piru iugtulu tung numyu, maskin nganing ti Adi Solomon ang bantug ang pinakamanggaranen atiing tukaw pa, piru yang katitinlu yang mga bisti na indi pa ka enged temepeng tung katitinlu yang mga talay ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dispuis kung yang ilamunun ka ilem nganing ya pay nag̱apasadyaan yang Dios ta mga talay ang mga maning tiag katitinlu, ang simanyan ya pag dawalay ta, ang pagkatapus andamal ilem, palalaw̱an da ilem ta apuy, ya pa w̱asu yamu, indiamu pa kayanan nang paiwan-iwanan ang pakdulan ta aw̱el? Kung isip-isipenu, midyu tung maluw̱ay pa ka enged yang pagtaralig̱en mi tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Purisu indiamu ra magpakaliw̱eg ta mga kulu mi kung ariamu pa w̱asu mangkel ta mapangan mi u kung ariamu pa w̱asu maita ta matinlung mainem mi u kung ariamu pa w̱asu mangkel ta ablen mi. ");
INSERT INTO tbk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ay muya ya ray mausuy mi yang ug̱ali yang mga taung indi pa ag̱aeyangan ta ipagtalig nirang ustu tung Dios ang kaldaw-kaldaw alus pa ilem ya ra ilem yang mga maning tia ay nag̱apabilug̱an ta mga isip nira. Yang indi mi ipagpakaliw̱eg ta mga kulu mi asan, ay yang Ama mi duun tung langit, ya kang lag̱i ay nag̱aske ang yay kaministiran mi yang tanan ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kung indi, yang ipalusu ming sikaren, ang yamu pirming magparanek ang magpagaem tung Dios ang yang magkatama tung pagterelengen na, ya ray ipalandaw ming tumanen. Atia kung yay sikaren mi, tay puis tanya ray balang mag̱arasikasuen tung tanan ang mga kaministiran mi ang ya ra rin ay nag̱aliw̱eg̱an ta mga kulu mi. ");
INSERT INTO tbk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Purisu indi mi ra enged pabegbeg̱an ta mga kulu mi kung unu pang mga kaliwag̱anay ang mapasaran mi andamal. Ay bala ra tung ni Andamal ang magpakabegbeg ay natetenged yang Dios tanya, simpan dang lag̱ing magpakdul. Tutal bastanti ra yang mga kaliwag̱an ang magsasampet tung numyung kaldaw-kaldaw. Ministir pang dulangan mi pa ta indi pa nag̱ainabu?” ");
INSERT INTO tbk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Taa numanyan nagpadayun ti Jesus yang pagturuldukun na tung nira ang mag̱aning, “Indiamu ra enged magtag̱am ta sintinsia tung mga aruman mi ug̱ud indiamu ra ka sintinsiaan yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kipurki kung ya pa ag̱ari yang pagsirintinsiaen mi tung mga aruman mi, ya ra kay usuyun yang Dios ang magsintinsia tung numyu. Kung unu pay pitik ang gamiten ming magsintinsia tung nira, ya si kay gamiten nang magsintinsia tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ta yamung naanad dang magtag̱am ta sintinsia tung duma, ayw̱a kaya ang yang maning pa tung sasang letek ka ilem tung mata yang putul mi, atii pala yay nag̱apadekdekan mi ang pagkatapus atia ngani tung mata mi may mag̱abatang ang yag keketeg ang indi mi pala nag̱adipara? ");
INSERT INTO tbk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ayw̱a palangaasan mi pa ka enged yang putul ming aningen ang ‘Maimu ilem, putulu, kuaten ta ra tiang letek tung mata mu?’ Ang pagkatapus atia ngani tung mata mi may sasang mag̱abatang ang yag keketeg ang indi mi pala nag̱adipara? ");
INSERT INTO tbk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Abaa yamu ilem agpagpakaayen-ayen! Kaministiran ya ra kanay ay tukawen ming kuaten yang mag̱abatang ang atiang yag keketeg tung mata mi. Atia, manadlaw ra yang paneleng mi ang para tung matinlu yang panguat mi tung letek tung mata yang putul mi. ");
INSERT INTO tbk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Indi mi ikdul tung mga kiru yang sasang bag̱ay ang sagradu. Muya balikdenamu ra ilem nirang tengkaken. Indi mi ka iplek tung mga baw̱uy yang mga musia mi natetenged liked-likeran da ilem nira.” ");
INSERT INTO tbk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mag̱aning si ti Jesus ang nagpadayun yang pagbaradbaren na tung mga isip yamen, “Kung unu pay pagkakulang mi, ya ray ingalukun mi tung Dios ta muya-muya. Atia, ipakdul na tung numyu yang nag̱aingaluk mi. Muya-muyang idangep mi tung anya yang nag̱asagyap mi. Atia, papag̱itaenamu ka anya yang nag̱asagyap mi. Kung ya ra kay pambungun mi yang sasang taung muya-muyang managbalay, ay maning pa tung patakwalenamu ra ka anya. ");
INSERT INTO tbk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ag̱aningenamu yeen ta maning tia, ay kipurki kumpurming tinu pay mag̱ingaluk tung Dios ta muya-muya, ya ray pakdulan na. Kumpurming tinu pay magdangep ta muya-muya tung anya, ya ray papag̱itaen na yang nag̱asagyap na. Kumpurming tinu pay magpakbung tung taung muya-muyang managbalay, ya ray maning pa tung patakwalen na. ");
INSERT INTO tbk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yamung mga amaen, kung yang ana mi pag̱ingaluk da ta tinapay, magkabag̱ay w̱asu ang pakdulan mi ta batu? ");
INSERT INTO tbk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ubin kung yang nag̱aingaluk na ian, magkabag̱ay w̱asu ang pakdulan mi ta iraw? ");
INSERT INTO tbk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ig disir kung yamu nganing ang makinasalananen, nag̱askeamu nganing ang magpakdul yang matinlu tung mga ana mi, ya pa yang Ama mi duun tung langit ang indi w̱asu maskeng magpakdul yang matinlu tung kumpurming tinu pay pag̱ingaluk tung anya? ");
INSERT INTO tbk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kapurisu kung papagbilug̱unu ra yang tanan ang atiang ipinagwaswasu tung numyu, ya ra taa: yang dapat ang buaten mi tung duma, ya ra yang matinlu ang yay nag̱alelyag̱an ming buaten nira tung numyu. Kipurki ya enged ay nagarumbuan yang mga katuw̱ulan ang ibinutwan ni Moises may yang ipinagpadapat yang mga manigpalatay yang bitala yang Dios atiing tukaw,” ag̱aaning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Taa numanyan nagpadayun da ti Jesus yang pagturuldukun na tung yamen ang nagpakdul ta sasang pananglit ang mag̱aning, “Kung gustu ming magsarapenanamu ra yang Dios ang anday katapusan, asanamu ra magpakled tung purtang piet. Kipurki mawayang yang purta ig marugal yang dalan ang duun da manampet tung kadiaduan ang anday katapus-tapusan na. Dakele nganing yang mga taung pamagpakled asan. ");
INSERT INTO tbk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kapiet yang sambilug ang purta ig durung kaliwag̱an ang mapasaran yang kumpurming mag̱usuy tung dalan ang yang panampetan na magsarapenan da tanira yang Dios ta unaynay. Malaka ilem nganing yang mga taung nag̱atultul. ");
INSERT INTO tbk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mangamanamu ra ta mupia tung mga taung pamag̱ambu ang tanira mga manigpalatay yang bitala yang Dios. Kung magpailala ra nganing tung numyu, magpasuad-suad dang durug kaayen ang mga tau ang katulad ka tung sasang karnirung durug kaalam. Piru tung adalem aparti ra yang pag̱asikad nira, ay yang kaalimbawaan nira maning pa tung mga kirung talunun ang pagmalung ta matekeb nira. ");
INSERT INTO tbk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Asan da nga puntusay mi tung mga ubra-ubra nira. Simpri yang mga sapinit indi pamurak ta pumangga ig yang aruma indi ka pamurak ta langka . ");
INSERT INTO tbk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yang ayung madalumama, matinlu ka yang nag̱ipamurak na. Piru yang ayung keseg-keseg, sayud ka yang nag̱ipamurak na. ");
INSERT INTO tbk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Anday ayung matinlu ang sayud yang nag̱ipamurak na. Anda kay ayung sayud ang matinlu yang nag̱ipamurak na. ");
INSERT INTO tbk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yang ayung kumpurming belag̱an matinlu yang nag̱ipamurak na, ya ray pelaren ang iplek tung apuy. ");
INSERT INTO tbk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Purisu duun da tung mga ubra-ubra nira nga deepay mi yang mga taung atiang pamag̱ambu ang tanira unu mga manigpalatay yang bitala yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Belag̱an ang mag̱aning ang yang tanan ang mga tau ang kumpurming pag̱inambit yang aranu ang yuu unu ti Ginuu na ang yay mangalg̱ud tung palaksu yang paggaraemen yang Dios tung uri, kung indi, sulaminti ilem yang kumpurming pagtuman yang nag̱alelyag̱an yang pag̱aningenung Amaw duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ay kung kaw̱utun da nganing yang uras ang ipagsintinsiaw ra tung mga tau, durung mag̱aning tung yeen ang maning taa: ‘Ginuu, Ginuu, palg̱urayami ka kipurki nagparakaw̱utunami ka yang bitala yang Dios tung mga tau ang yang aran mu yay pirming sinambit yamen. Ya kay sinambit yamen ang nagpalayasami tung mga dimunyung namansisuut tung mga tau. Duru-duru nganing ang mga pruibang makabew̱ereng ang ipinagpalapus yamen natetenged tung pagsambit yamen yang aran mu.’ ");
INSERT INTO tbk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pagkatapus prangkaenu ra ilem tanira ang panganingen: ‘Anda kang lag̱i ay kalalabten mi tung yeen. Paaw̱ig̱amu ra ilem taa tung yeen, ay ta yamu nagpadayunamu ra ka enged tung mga ubra-ubra ming balaw̱ag tung kalelyag̱an yang Dios.’ ");
INSERT INTO tbk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Purisu kung tinu pay pamati tung mga bitalaung naang nag̱ipagpadapatu, ang pagkatapus tumanen na ra ka, ya ray nag̱ipananglitu tung sasang taung mawayang yang kinaisipan na. Ay tung pagpakdeng na yang balay na, yang pinabunsaran yang adili na kaw̱ut enged duun tung kabatuan. ");
INSERT INTO tbk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pagkatapus kuminuran da yang banwa ta tudu-tudu ang asta linempanan da. Pati yang palet kumintel da ka ta duru ang asta pinamilug̱an da yang balay nang binungsaran. Piru indi ra ka enged naunu pa ay sangkad tung kabatuan yang mga adili na. ");
INSERT INTO tbk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Piru kung tinu pay pamati tung mga bitalaung naa ang pagkatapus indi na ra ka ilem tumanen, ya si kay nag̱ipananglitu tung sasang taung kiput yang isip na. Ay tung pagpakdeng na yang balay na, duun da ilem ipakdengay na tung kenay. ");
INSERT INTO tbk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pagkatapus kuminuran da ta tudu-tudu, diritsyu rang linempanan yang banwa, pati yang palet kumintel da ka ta duru ang asta pinamilug̱an da yang balay nang binungsaran. Anday dumang pinakaw̱ut na, ya ra magkalipuat ang gew̱a rang pisan,” ag̱aaning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Purisu nagkainabu ra ang atiing pagtapus da ni Jesus tung pagparadapaten na yang mga bitalang atia, durung pagkabereng yang mga tau tung pasais nang nagturuldukanen. ");
INSERT INTO tbk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ay yang naberengan nira tung anya, yang pagturuldukun na tung nira may builu nang maktel ang yay pagpailala ang tanya may katengdanan na ka man ang ipinakdul yang Dios tung anya. Belag̱an pariu tung pasais yang mga sag̱ad ang yay dating mga manigtulduk tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Taa numanyan, tung pandanek ni Jesus tung napabukatud ang atiing pinagtuldukan na, duru-durung mga taung namagpakignunut da tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Buay-w̱uay ta gesye, may sasang taung nagpalenget tung anya ang may dispirinsia tung ulit nang makamamansa. Dayun dang nagluud tung pinagtalungaan nirang durua ang nagpakiildaw tung anyang mag̱aning, “Ameey, kung malelyag̱a ilem, nag̱askeanu ang sarangan mung kuaten tung yeen yang dipirinsiaung naang pagpamansa tung pagkatauu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Numanyan, dayun dang dineenan ni Jesus ang inaning, “Ag̱alelyag̱aw ka, kuatana ra yeen,” mag̱aning. Pagkatapus lag̱i-lag̱ing nakuatan da ka man tung dipirinsia nang atia. ");
INSERT INTO tbk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Numanyan nagkalalangan da ti Jesus tung anyang mag̱aning, “Kuidaw, india ra enged magbaw̱alitaen maskin tung ninu pa natetenged tung binuatung naa tung nuyu. Anday dumang buaten mu, mag̱angaya ra kanay duun tung sasang pari ang magpateleng ang yawa limpiu ra. Pagkatapus magpadasag̱a ra ka dayun tung anya ta sasang ayep ang iprisintar na tung Dios ang katulad ka tung urdinansang ibinutwan ni Moises ang tukaw ug̱ud asan da nga kumpurmiay yang mga tau ang anda ray dapat ang pamiruan nira tung nuyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Taa numanyan, atiing ti Jesus kuminaw̱ut da duun tung lansangan ang Capernaum, may nagpakigbag̱as tung anyang sasang kapitan tung sang grupung mga sundalung atiang mga tag̱a Roma. Durung pakiildaw na tung ni Jesus ang mag̱aning, “Ameey, yang turuw̱ulunu paglaru. Ya ra ileg lalakday takaa tung balay ang indi ra mapangimi-kimi. Durug liwag yang pagkabetang na.” ");
INSERT INTO tbk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mag̱aning ti Jesus ang nagtimales, “Angayenu ra kanay ang pamaayenen.” ");
INSERT INTO tbk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mag̱aning ka yang kapitan ang nagtuw̱al, “Ameey, indi ra. Belag̱anaw bag̱ay tung nuyu ang yawa pay patakwalenu tung balayu. Basta magkalalangana ra ilem, atiang lag̱i magmaayen da yang turuw̱ulunu. ");
INSERT INTO tbk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kipurki maskin nganing yuu, kabisaduaw ra ka tung pagpalalang tung mas abwat ta katengdanan tung yeen ig kabisaduaw ra ka tung pagkalalangan tung mga sundaluu. Kung lalanganu yang sam bilug ang mangay duun, atiang lag̱i magpanaw ra ka man. Pati yang sam bilug ya ka, kung guuyanung magpalenget tung yeen, atiang lag̱i, magpalenget da ka man. Asta yang sasang kirepenu ya ka, kung lalanganung mag̱ubra ta sasang bag̱ay, atiang lag̱i ubraen na ra ka man,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagkagngel ni Jesus tia, nabereng da ta mupia. Dayun dang nagbitala tung mga taung atiang pamagpakignunut tung anya ang mag̱aning, “Iugtulu tung numyu yang kamatuuran, taa tung banwa tang naang Israel, anda pay taung nag̱apanawanung maning taag dakul yang pagtaralig̱en na tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iugtulu tung numyu, kung ipabistu ra nganing yang Dios yang paggaraemen na tung baklung kaliw̱utan, durung mga taung tag̱a maskin ay pang banwaay ang belag̱an pa man mga masigkanasyun ta ang ya ray panlugtan yang Dios ang mamagpakisaru ra tung na Abraham, ni Isaac, may ni Jacob. ");
INSERT INTO tbk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piru yang kadaklan ang mga kanubli nira simanyan ang mabaked yang pagtalig nira ang tanira ray bag̱ay ang mangalg̱ud, ya pa kay pangaskasen yang Dios ang ipamlek duun tung sasang lugar ang makiklep ang alawid ang pisan tung anya. Duun da tanira mamagtarangiten ang mamagkaretket yang mga isi nirang mamagpapinitinsia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pagkatapus dayun na sing inaning yang kapitan ang, “Puidia ra kang mulik. Magkamaningan da ka man yang kumpurming itinalig mu tung yeen,” ag̱aaning. Pagkatapus tung uras ang atii, nagmaayen da ka man yang turuw̱ulun yang kapitan. ");
INSERT INTO tbk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Taa numanyan, pagkaw̱ut ni Jesus duun tung balay ni Pedro, ya ray naita na yang punyangan nang baw̱ay ang ya ra ilem aglalakday asan. Ay agkiniten da. ");
INSERT INTO tbk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Numanyan pagdeen ni Jesus tung kalima na, lag̱i-lag̱ing naumpawan yang maepet. Pagkatapus diritsyu rang nagbangun ang nag̱impisa rang nag̱asikasu tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Numanyan, atiing pagkasantek da yang kaldaw, durung mga taung agdimunyuen ang ipinampadangep da yang mga aruman nira tung ni Jesus. Numanyan sam pabitala ra ilem ni Jesus, antimanung namaglalayasan da yang mga dimunyu. Pati yang mga taung may mga laru, luw̱us na ra kang pinampamaayen tung uras ang atii. ");
INSERT INTO tbk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nagkamaningan da ta maning tia ug̱ud asan da magkamatuud yang sasang ipinaula yang Dios tung ni Isaias ang sasang manigpalatay nang tukaw ang mag̱aning, “Tanya mismu yang magpamaayen tung yaten tung mga kaladuan ta, yay magpanguat tung mga masiit ang nag̱asinti ta,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Taa numanyan pagkaita ni Jesus ang duru-durung mga tau ang pamagrikudu tung anya, nagkalalangan da tung yamen ang mga tauan na ang mag̱aning, “Ala, magpatindakita ra kanay,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Numanyan tamang tamang magsaayami ra rin na Jesus, may sasang sag̱ad tung mga urdinansang pinanubli tung mga kinaampu ang ya ray nagpalenget tung anyang mag̱aning, “Ameey, magpakignunutaw ra tung nuyung magpaugyat, maskin aria pa manganing,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mag̱aning ti Jesus ang minles, “Maayen pa yang mga dayap tung talun, may mga anas nirang siguradu, pati mga lamlam may mga bayay nirang sadili. Indi ra ilem yuung pag̱aningen ang Maninga Tau ang anday pirmaminting pag̱elkanu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pagkatapus may sam bilug pang taung pagpaugyat da tung ni Jesus ang yay nabngang mag̱aning tung anya, “Ameey, bakluaw ra magpadayun tung pagpaugyatu tung nuyu, kung maimu ilem tung nuyu, tugtayaw ra kanay nuyung mulik ang para kung mapatay ra nganing ti tatay, mapalg̱uru ra tung leyang,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mag̱aning ti Jesus ang nagtuw̱al, “Bilug̱un mu ra ilem yang isip mung magpaugyat tung yeen. Yang bag̱ay ang atiang nainambit mu, ipatug̱ay mu ra ilem tung duma ang pamanalugpatay pa tung Dios. Bag̱ay ang pisan tung nirang mamanlug̱ud tung mga aruman nirang patay ra,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pagkatapus tia, dayun da ka enged ang nagsaay ti Jesus tung balangay, kasiraanami ra kang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Numanyan tung pagpalayag yamen tung aw̱uyuk, nainalianami rang binungsaran ta tampung durug ketel ang asta yang balangay gesye ra ilem ang napnukan. Piru ti Jesus tanya sigi ra ilem ang elek. ");
INSERT INTO tbk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Numanyan dayun dang pinalengtan yamen ang pinuaw ang inaning, “Ameey, taw̱ang! Magkaralemesita ra taa,” ag̱aaningami. ");
INSERT INTO tbk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mag̱aning ka ti Jesus ang nagtimales, “Ayw̱a pinatalaw mi ra yang mga isip mi? Midyu tung nag̱apakulangan mi ra yang pagtaralig̱en mi tung yeen,” mag̱aning. Pagkatapus dayun dang nagbangun ang nagsambeng tung palet may tung lakun. Lag̱i-lag̱ing naglinaw rang pisan. ");
INSERT INTO tbk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Atii, durung pagkabereng yamen ang mga kaarumanan na. Purisu nag̱araning-aninganami ra ilem ang mag̱aning, “Unu ra kayang klasiay ta tau taa? Maskin yang palet pati yang lakun, luw̱us dang pamananged tung anya!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Taa numanyan, pagkaw̱ut ni Jesus duun tung tindak yang aw̱uyuk duun tung baw̱anwaan yang mga Gadareno, binag̱as da ta durua nga tauan ang pariung pag̱aekel-ekelan ta mga dimunyu. Duun mamanliit tung may mga leyang ang pinanlug̱uran ta mga patay. Kumus durug karaiseg, anday magpanayang-nayang ang magpanaw duun tung karsadang atia. ");
INSERT INTO tbk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Numanyan pagbag̱as nira tung ni Jesus, dayun dang namaglelpaken yang dimunyung mag̱aning, “Yawang pag̱aningen ang Ana yang Dios, ayw̱a nag̱apasilabtanami pa nuyu? Muya yang inangay mu taa ay parusaanami ra nuyung indi pa nganing agkaw̱utun yang uras ang ipinagtipu yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Numanyan duun tung tukaw-tukaw, may sasang kaayepan ang mga baw̱uy ang gaw̱ung ang pamanulyad-tulyad. ");
INSERT INTO tbk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Numanyan yang mga dimunyung atia, namagpakiluuy ra ilem tung ni Jesus ang mag̱aning, “Kung yami talagang palayasenami ra ka enged nuyu tung mga taung naa, maayen pa duunami ra ilem ipasuutay mu tung mga baw̱uy ang atii,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mag̱aning ti Jesus ang nagtuw̱al, “Ala, sigi ra,” ag̱aaning. Purisu dayun dang namansilayas tung durua nga tauan ang atiang namansilakted tung mga baw̱uy ang namansisuut. Pagkasuut nira tung mga baw̱uy, dayun dang namansikurbut tanirang tanan ang namagpataladtad ang diritsyu ra ilem tung aw̱uyuk ang namampakpa ang asta nagkaralemes da ilem ang luw̱us. ");
INSERT INTO tbk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Taa numanyan yang mga manig̱asikasu tung mga baw̱uy ang atia, dayun dang namaglalaksuan ang namansiangay duun tung lansangan. Pagkaw̱ut nira duun, namagbaw̱alitaen da natetenged tung tanan ang nagkarainabu. Pati yang nainabu tung durua nga tauan ang atiang dinimunyu ra rin, ya enged ay ipinagbalita nira. ");
INSERT INTO tbk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Purisu anday dumang dinangat na, yang mga taung tag̱a lansangan, alus pa ilem tanirang tanan namansilua rang namansiangay duun tung ni Jesus ang namagpakigbag̱as. Numanyan, pagkabag̱as nira tung anya, dayun dang namag̱intra amu-amu tung anya ang basta magliit da ilem duun tung banwa nira. ");
INSERT INTO tbk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Purisu ti Jesus tanya, anday dumang binuat na, dayun da ilem ang nagsaay tung balangay ang nagpatindak si ang asta nagbalik da duun tung Capernaum ang yay lansangan ang pag̱atiniran na. ");
INSERT INTO tbk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naa pala may sasang taung namamilay ra yang mga tinanguni na ang ya ra ilem agtuang-tuangay yang mga aruman na tung papag ang nag̱idangep tung ni Jesus. Numanyan pagkasiman ni Jesus ang tanira may pagtalig nira tung anya, dayun na rang binugnu yang taung atiang namamilay ra yang mga tinanguni nang inaning, “Duduy, paktelen mu ra yang isip mu, ay nag̱apatawara ra yeen tung mga kasalanan mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naa pala may mga tau asan ang yay mga sag̱ad tung mga urdinansang pinanubli tung mga kinaampu ta. Pagkagngel nira yang inaning ni Jesus tung taung atiang namamilay ra yang mga tinanguni na, dayun dang ipinagkesen-kesen nira tung mga isip nirang maning taa: “Abaa yang tau kang naa ka, ya rag pagtiwakaw tung pagkadios yang Dios!” ");
INSERT INTO tbk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kumus nag̱adeep da ni Jesus kung unu pay laksu yang mga pag̱irisipen nira, dayun dang nagbugnu tung nira ang mag̱aning, “Ayw̱a nag̱alaumanaw numyu ta malain? ");
INSERT INTO tbk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kanisip mi ang sungaw ra ilem yang inaningu tung taung naa ang pinatawaru ra tung mga kasalanan na? Piru kung aningenu si ang magbangun dang magpanaw, asan da ngaskeay mi kung yang bitalaw sungaw ra ilem u kung may kamatuuran na. ");
INSERT INTO tbk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Purisu papruibaanu ra numanyan tung numyu ang yuung pag̱aningen ang Maninga Tau, may katengdananu ka man tung katanekan ang magpatawad tung mga tau yang mga kasalanan nira,” mag̱aning. Pagkatapus diritsyu rang pinag̱aning na yang taung atiang pamamilay yang tinanguni na, “Ala, magbanguna ra asan. Eklan mu ra tiang lulubgan mung mulik,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pagkatapus yang taung atia, dayun da ka man ang nagbangun ang minulik tung balay na. ");
INSERT INTO tbk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkaita yang mga taung atiang buntun, nangabereng da ta duru ang nunut da ka ta pagdarayawen nira tung Dios ang may sasang taung pinakdulan na ta katengdanan na ang maning tia. ");
INSERT INTO tbk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pagkatapus tia, ti Jesus dayun dang luminua tung balay ang nagpanaw. Numanyan yuung ti Mateo, naitaaw ra anyang yuug kakarung tung upisinaung pagpanukut tung mga tau yang mga balayaran nira tung gubirnu. Mag̱aning tung yeen ang nagbugnu, “Amus Mateo, magpakignunuta ra tung yeen ang magpaugyat,” ag̱aaning. Pagkagngelu tia, dayunaw rang kumindeng ang nagpakignunut tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Taa numanyan nagkamaning da ang ti Jesus pagpakigsaru ra tung yeen duun tung balayu, kasiraan da ka tanira yang nag̱apangugyatan nang dati. Duru rang mga kaarumananung mga manigpanukut ang namansikaw̱ut da ka, kasiraan da ka tanira yang duma ang nag̱alamku ka ta kadaklan ang durug kakinasalananen. Pagkatapus dayun dang namagpakigsaru tung ni Jesus may tung yamen ang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Taa numanyan may mga Pariseo ka asan ang nangaita tung nainabung atia. Purisu dayun dang namag̱istinggir tung yamen ang nag̱apangugyatan ni Jesus ang mag̱aning, “Ayw̱a asan dag pagpakigsaru yang manigtulduk mi tung mga manigpanukut ang atiang mga mandaraya may tung mga kaarumanan nirang atiang duru kag kakinasalananen?” ");
INSERT INTO tbk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Numanyan pagkagngel ni Jesus tia, ya ray nagtuw̱al ang asan da ipapanaway na tung sasang pananglit ang mag̱aning, “Yang mga taung makektel anday kaministiran nira yang manigbulung, kung indi, ya ra ilem yang mga taung may mga laru. ");
INSERT INTO tbk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Maayen pa, pasadsaran mi ra kanay ta mupia yang sasang napabtang tung kasulatan ang para mamaresmesan mi yang linagpakan yang sasang inaning yang Dios tung mga kinaampu tang mag̱aning, ‘Mas matimbang tung yeen ang mag̱irildawanamu kay tung magpadasag̱amu ta mga ayep ming para ya ag̱iprisintaray mi tung yeen,’ ag̱aaning. Asan da ngaintindiay mi yang linyang pag̱ausuyu. Kipurki yang inangayung mag̱imbitaren ang para magpaugyat tung yeen, belag̱an yang mga taung pagtalig ang tanira matadleng tung pagterelengen yang Dios, kung indi, ya ra ilem yang kumpurming mangamin ang tanya talagang makinasalananen ka man,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Numanyan may mga taung nag̱apangugyatan ni Juan ang manigbenyag ang namansiangay ra tung ni Jesus ang namagkig̱a ang mag̱aning, “Ayw̱a kaya ang yang mga taung naang nag̱apangugyatan mu indi pamamlek tung pagparanganen nira? Ta yamen may yang mga Pariseo, pirmiaming pamlek tung pagparanganen yamen natetenged tung sasang urdinansang pinanubli tang mga Judio,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yang tuw̱al ni Jesus tung nira, yang sadili na ipinananglit na tung laliing pangasawa. Mag̱aning tung nira, “Ayw̱a, kung may kumbira, magkabag̱ay w̱asu ang yang pamagkumpanya tung pangasawa mamagpakapungaw ra ilem ang indi ra mamagpakigsaru mintras asan pa tung tepad nira yang aruman nira? Ug̱aring may uras ang kaw̱utun ang yang aruman nirang atia, lag̱unutun dang eklan tung tepad nira. Atia ya ray uras ang magkabag̱ay rang pisan ang ipamlek nira tung pagparanganen nira natetenged ka man tung kapupungawen da nirang duru. ");
INSERT INTO tbk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ayw̱a, tinu pay nag̱aintindian ming tau ang yang aw̱el nang lag̱i-lag̱i ra ya pay tambelan na ta aw̱el ang baklu ang indi pa nag̱abunakan? Kipurki kung maning tia ya pay buaten na, anday dumang mainabu, yang tinambelan bekngen da ka ilem yang baklung itinambel ang nagkere ang asta mas dang magwangwang yang lasik na kay tung primiru. ");
INSERT INTO tbk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dispuis tinu pay nag̱aintindian ming tau ang yang binung baklung ingkelan tung saralug̱an, asan da ilem papagbaalay na tung parabtangan ang lag̱i-lag̱i ra? Kipurki kung maning tia ya pay buaten na, kung mabaal da nganing tia, belaken na ra ka ilem yang parabtangan. Anday duma, mailas da ka ilem yang binu, pati yang parabtangan, diadu ra ka. Kung indi, mas maayen pa ang yang binung baklu, asan da ibukbukay tung parabtangan ang baklu ka ang malpes ka ilem manleskag ug̱ud parariung indi mangaunu pa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Numanyan, atiing indi pa nag̱atapus ti Jesus ta pagbitala, may sasang may katengdanan tung pagsaragpunan tang mga Judio ang ya ray nagkaw̱ut. Pagkaw̱ut na, dayun dang napadagpa tung pinagtalungaan nira ni Jesus ang nagpakiildaw tung anyang mag̱aning, “Yang anaung baw̱ay baklu pa ilem nabuntukan ta linawa na. Kung maimu ilem tung nuyu, nuntay kanay duun tung balay ang para madeenan mu. Atia, madeenan mu ilem, mabui si,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pagkagngel ni Jesus tia, dayun dang kumindeng ang nagnunut tung anya, kasiraanami ra kang mga nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Numanyan atiing pagnurunutanami ra na Jesus, may sasang baw̱ay ang ya ra ilem agsisikup tung buku ni Jesus ang nagdeen tung sam bilug ang mabilug-bilug ang atiang yag tataked tung sidsiren yang aw̱el nang langkuy. Yang baw̱ay ang naa, tung seled sam puluk may durua rang takun, muya-muya ra ilem ang nag̱aawasan. ");
INSERT INTO tbk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yang ikinesen-kesen na tung isip na maning taa: “Maskin aw̱el na ra ilem yang madeenanu, atiang lag̱i magmaayenaw ra,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Numanyan tung pagdeen yang baw̱ay tung aw̱el na, dayun dang nagbira ti Jesus ang naita tung anya. Pagkaita na, dayun na rang binugnu ang inaning, “Ipag, indi mu ra ilem papagdua-duaen yang isip mu. Nagmaayena ra tung pag̱alaru mung atia ay natetenged itinalig mu ra kang lag̱i tung yeen,” mag̱aning. Purisu mag̱impisa tung uras ang atii, nagmaayen da ka man. ");
INSERT INTO tbk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Numanyan nagpadayun da ti Jesus yang pagparanawen na ang asta kuminaw̱ut da duun tung balay yang manig̱erekelen. Pagpakled na duun, naita na yang mga manigpalauta may yang mga taung pamaggirinla. ");
INSERT INTO tbk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Pagkaita na tung nira, dayun dang nagkalalangan tung nirang mag̱aning, “Ala, magluaamu rang tanan asan. Ti Nini belag̱an patay, kung indi, ag̱elken ilem,” mag̱aning. Pagkagngel nira tia, ya ra ilem agtalangkakay nira. ");
INSERT INTO tbk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Numanyan atiing pagpalua na tung nira, dayun dang nagpakled tung kuartung atiang pag̱alubgan yang mula. Pagpakled na, dayun na rang pinggesan tung kalima na ang pagkatapus nagbangun da ka man yang mula. ");
INSERT INTO tbk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Purisu yang nainabung atia nabantug da tung intirung banwang atii. ");
INSERT INTO tbk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Numanyan atiing pagliit da ni Jesus duun tung balay ang atia, may durua nga burayan ang namag̱impisa rang namagpakignunut tung anya. Sigi ra ilem yang pagkekendalen nirang mag̱aning, “Yawang manubli tung paggaraemen ni Adi David, ildawayami ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Piru ti Jesus tanya, indi ra nagliing-liing, kung indi, nagpadayun da ilem tung pagparanawen na ang asta kuminaw̱ut da duun tung balay ang pag̱atiniran na. Pagkaw̱ut na, dayun dang nagpakled pati yang durua nga burayan, namagpakled da kang namagpalenget tung anya. Numanyan dayun na rang tinalimaan ang mag̱aning, “Panangeramu ka ang kayananung buaten yang nag̱aingaluk ming atia tung yeen?” Mag̱aning tanirang namansituw̱al, “Ee, Ameey, talagang panangerami!” ");
INSERT INTO tbk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Atii, diritsyu rang pinandeenan ni Jesus yang mga mata nirang inaning, “Magkamaninganamu ra ang kumpurmi ra ilem tung nag̱apananged mi tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pagkatapus nangabuskad da ka man yang mga mata nira. Numanyan nagpaaman da ti Jesus tung nira ta malebat-lebat ang mag̱aning, “Kuidaw, indiamu ra enged magbaw̱alitaen maskin tung ninu pa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piru tung pagliit nira tung balay na, maskin pinag̱urdinan da, anday dumang binuat nira, indi ra ka enged nangaegtem, kung indi, namagbaw̱alitaen da ka enged natetenged tung binuat nang atia tung nira ang asta nagsarambung da ilem yang balita tung intirung sinakepan yang banwang atia. ");
INSERT INTO tbk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tamang tamang pamansiliit yang durua nga tauan ang atia tung balay, may sasa si kang taung nag̱iated tung anyang apa. Yang natengeran yang pagkaapa na, tanya agdimunyuen. ");
INSERT INTO tbk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Numanyan tung pagpalayas ni Jesus tung dimunyu, atiang lag̱i napagbitala ra yang taung atia. Ya ray naberengan ta mupia yang mga tau. Purisu namag̱araning-aningan dang mag̱aning, “Indiita pang pisan nag̱aita ta maning tia taa tung banwa tang Israel, kung indi, numaan ilem,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Numanyan pagkagngel yang mga Pariseo tia, namansianing da tanira ang “Aa, yang taung atia, nag̱apagpalayas nganing ta mga dimunyu ay natetenged nag̱apaktel ni Satanas ang yay pagmangulu tung nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kapurisu maning da ka man tia yang nagkarainabu atiing pagliliw̱utun ni Jesus tung mga lansangan pati mga baryu duun tung intirung sinakepan yang Galilea. Yang bida na nagturuldukanen tung mga taung pamagsaragpun-sagpun tung nira nirang mga pagsaragpunan. Nagparakaw̱utun da ka dayun tung nira yang sasang matinlung balita ang yang Dios mag̱impisa rang magtukud yang paggaraemen nang baklu tung mga tau. Nagparamaayenen da ka tung may mga laru maskin unu pang klasing masiitay. ");
INSERT INTO tbk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tung pagterelengen na tung mga taung atiang buntun ang muya-muyang pamagpalenget tung anya, ya ra ngaildaw ta duru tung nira. Ay pamanluluw̱ayan da yang mga isip nira ay pangalingalag da ta duru natetenged nag̱apaw̱aya-w̱ayaan da ilem yang mga manig̱erekelen tung nira natetenged tung pag̱irintindien tung Dios. Yang kaalimbawaan nira maning pa tung mga kaayepan ang anda ray manigpastur ang pagpadag̱en-dag̱en tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Purisu yaming nag̱apangugyatan na, pinag̱aningami ra anyang, “Duru-durung mga tau ang mga simpan dang mamagpamati tung bitalaw. Yang kaalimbawaan nira maning pa tung paray ang malapad ang arayeg̱en da, piru kulang yang mga manig̱ayeg. ");
INSERT INTO tbk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Purisu ya ra kay ipag̱ampu mi tung Dios ang yay maning pa tung pag̱erekelen yang paayeg ang panuw̱ulun na yang mga manig̱ayeg na ang para mamangayeg da yang paray na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Numanyan yaming nag̱apangugyatan ni Jesus ang sam puluk may durua pinapagsaragpunami ra anya ang pagkatapus pinamiaranami ra ka anya ta kagaeman yamen ang magpalayas tung mga dimunyung namagsuut tung mga tau ig magpamaayen ka tung mga taung may mga laru, maskin unu pang laruay. ");
INSERT INTO tbk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ya ra taa yang mga aran yamen ang mga taralig̱an ni Jesus ang sam puluk may durua bilang mga apustul na. Yang pagmangulu-mangulu tung yamen ang tanan ti Simon ang pinapuanggaan tung ni Pedro. Yang aruman na tung pagliliw̱utun yang ari nang ti Andres. Yang magdasun ti Santiagong durua kang mag̱ari ni Juan ang yay mga ana ni Zebedeo. ");
INSERT INTO tbk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Yang magdasun ti Felipe, durua ni Bartolome. Yang magdasun ti Tomas may yuu ka mismung ti Mateo ang atii kanay manigpanukutaw ra rin ta balayaran tung gubirnu. Yang magdasun, ti Santiagong ana ni Alfeo, durua ni Tadeo. ");
INSERT INTO tbk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yang magdasun ti Simon ang sam bilug ang yay kinasakpan da rin yang sasang partidung durug iseg yang pagbaratukun nira tung gubirnu yang mga tag̱a Roma, durua ka ni Judas ang Iscariote ang tung uri, ya ra ka man ay nagtraidur tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Numanyan yaming nag̱apangugyatan nang atiang sam puluk may durua, bakluami papanaway na, may mga bitalang ipinabalun na tung yamen ang maning taa: “Kung magpanawamu ra nganing, indiamu ilem magdistinu tung mga baw̱anwaan yang mga tag̱a duma-rumang nasyun ubin maskin tung mga lansangan yang mga Samarianen. ");
INSERT INTO tbk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kung indi, yang pabilug̱an ming angayen ya ra kanay ilem yang mga masigkanasyun tang mga Israel ang yang kaalimbawaan nira maning pa tung mga karnirung nagkaratalang da. ");
INSERT INTO tbk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ya ray pampakaw̱utan ming panganingen ang kinaw̱ut da yang uras ang ipagpundar yang Dios yang paggaraemen nang baklu tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kung may mapanawan ming mga taung may mga laru nira, pampamaayenen mi, pati mga patay, pampabuien mi si kang uman, asta yang may mga larung tung ulit nirang makabiw̱iru, pampamaayenen mi ka, pati yang mga dimunyung namagsuut tung mga tinanguni yang duma, pampalayasen mi ka. Kumus diw̱aldi ilem yang pagpakdulu tung numyu yang kagaeman ming atia, indi ra ka magkabag̱ay ang pabayaren mi pa yang mga taung atiang pampakaayenen mi. ");
INSERT INTO tbk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Dispuis paisanu ra ilem yang pagparanawen mi. Indiamu magbalun ta kuarta, maskin unu pang klasiay, mag̱ing bulawan man, mag̱ing salapi man, mag̱ing saway man. Indiamu ka mag̱ekel-ekel ta puyu-puyu ang pariu ka tung pag̱aekel-ekelan ta mga manigpalimus. Maskin lambung ming irimaraan mi, sandalyas, ubin bastun pa, indi mi ka ekel-ekelan. Ay yang sasang manigparakaw̱utun, bag̱ay kang asikasuen tung mga kaministiran na ang yay maning pa tung isuul tung anya yang mga taung nag̱apampakaw̱utan na. ");
INSERT INTO tbk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Dispuis kung kumaw̱utamu ra nganing tung sasang lansangan ubin baryu, magpaniiramu ra ta tau ang midyu may kalelyag na kang magpadayun tung numyu tung balay na. Duunamu ra ilem magdayun ang asta magliitamu ra ilem tung banwang atia. ");
INSERT INTO tbk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagkatapus tung pagpakled mi tung balay na, kumustaen mi ka yang pamag̱istar asan ang aningen, ‘Yamung tanan ang pag̱istar taa tung balay ang naa, maimu rang pakaayenenamu ra ka ta mupia yang Dios.’ ");
INSERT INTO tbk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Simanyan kung panangeren nira yang ipagpakaw̱ut mi tung nira natetenged tung yeen, magkamaningan da ka man tanira ang katulad ka tung ikinumusta ming atia tung nira. Piru kung indi mamananged, bawien mi ra ilem yang ikinumusta ming atia tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kung ariamu pang balayay nga dayun u kung ariamu pang lansanganay nga distinu, ang pagkatapus indiamu ka enged risibien nira pati yang bitalang nag̱ipagpakaw̱ut mi indi ka enged pamatien nira, magliitamu ra ilem asan. Ug̱aring tung pagliit mi, pakdulan mi ta sasa pang sinyalis. Yang apuk tung banwa nira ang namandepet tung mga kakay mi, ya ray itagbeng-tagbengay mi ug̱ud asan da nga paamanay mi ang yang pagpakuindi nirang atia tung numyu ya ray panuw̱alan nira tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iugtulu tung numyu, kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung tanan ang mga tau, malakan-lakan pa yang parusang dangaten yang mga tag̱a lansangan ang Sodoma may Gomora kay tung dangaten yang mga taung tag̱a maskin ay pang lansanganay ang kumpurming namagpakuindi tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Papatandaan mi ta mupia yang bitalaw. Ta yamung pag̱atuw̱ulung magparakaw̱utun yang bitalaw, yang kaalimbawaan mi maning pa tung mga karniru ang duunamu ra ipaangayayu tung mga taung maning pa tung mga kirung talunanen ta kaiseg. Purisu yang maayen ang panularen mi ya ra yang mga iraw ang durug tarem yang mga isip nira pati yang mga kalapati ang durug kaamumu. ");
INSERT INTO tbk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nag̱apabantayamu ilem yeen ay may mga masigkanasyun ta mismu ang yay magpadeep tung numyu ang para idimandaamu ra nira tung mga usgadu. Duunamu mismu paburdunay yang pamagmaepet-epet tung mga pagsaragpunan nira. ");
INSERT INTO tbk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kung kaisan guyuranamu nirang patalungaen tung mga gubirnadur may tung mga adi pa natetenged tung pagkererengen mi tung yeen. Panlugtan nganing yang Dios ang magbuat ta maning tia tung numyu ug̱ud asanamu nga pakdulay na ta lugar ming magparakaw̱utun tung nira natetenged tung yeen. Pati yang mga kaarumanan ka nirang belag̱an kang mga masigka Israel ta, mapampakaw̱utan mi ka tung mga uras ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kung pabistaanamu nganing nira ta maning tia, indiamu ilem magpakabegbeg ta mga kulu mi kung unu pay ituw̱al mi u kung ya pa ag̱ari yang pametang-betang mi yang mga bitala mi. Ay kipurki kung kaw̱utun da nganing yang uras ang atia, paisipenamu ra yang Dios kung unu pay ipanuw̱al mi. ");
INSERT INTO tbk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ay yang mga bitalang ipanuw̱al mi tung nira, belag̱an numyung sadiling bitala, kung indi, ya ray ipaisipay tung numyung ipabitala yang Espiritu Santong nag̱ipatinir tung numyu yang Ama mi. ");
INSERT INTO tbk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Maning taa yang mainabu tung sam pamilya. Kung tinu pay mananged tung Matinlung Balita natetenged tung yeen, ya ray demtan yang mga putul nang idangep tung usgadung ipaimatay. Ang kaisan ya ra kay buaten yang sasang ama tung mga ana nang namagpasirung da tung yeen. Ang kaisan, kung yang mga ginikanan ya ray namagpasirung tung yeen, ya ra kay batukan yang mga ana nirang ipaimatay. ");
INSERT INTO tbk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","May uras ang kaw̱utun ang demtanamu ra ka ta maskin tinu pang tauay arangan da ilem tung yeen ang nag̱akegngan mi. Piru kung tinu pay magpatenten yang isip nang magpadayun ka enged tung pagtaralig̱en na tung yeen, maskin imatayen pa, ya ray tapnayen yang Dios ang ipalg̱ud tung kaliw̱utan ang baklu. ");
INSERT INTO tbk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kung yamu dereeg-deeg̱an tung sasang lansangan, magpalaksuamu ra ilem tung dumang lansangan ang para duunamu si magparakaw̱utun. Iugtulu tung numyu yang kamatuuran, baklu mi ra mateptep yang tanan ang mga lansangan taa tung banwa tang naang Israel, ta yuung pag̱aningen ang Maninga Tau, magbalikaw ra. ");
INSERT INTO tbk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Yang sasang taung pagpaugyat indi maglaum ang tanya mas pang galangen kay tung pag̱ugyat tung anya. Pariu ka tung sasang turuw̱ulun. Indi ka maglaum ang tanya mas pang sapten kay tung ag̱alen na. ");
INSERT INTO tbk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Purisu yang sasang pagpaugyat kaministiran ang mag̱ing kuntintu tung isip na ang mapasaran ta pariu ka tung nag̱apasaran yang pag̱ugyat tung anya. Pati yang sasang turuw̱ulun, kung mapasaran ta pariu ka tung nag̱apasaran yang ag̱alen na, ya ka. Kung yuung maning pa tung sasang tatay tung pamalay-w̱alay, yuu ag̱aningay ta mga tau ang ti Satanas, yamung lug̱ud tung pamalay-w̱alayu mas pang pakulainenamu nira. ");
INSERT INTO tbk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Purisu indiamu mag̱eled tung maskin tinu pang tauay ang magkuntra tung numyu. Ay kipurki demdemen mi yang bitalaw: anday nag̱atipig̱an ang indi luw̱awan, anda kay nag̱italuk ang indi makdekan. ");
INSERT INTO tbk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Purisu kung unu pay nag̱ipag̱aningu tung numyu ang ita ita ilem, ya ray ipagpakaw̱ut mi enged tung publiku maskin unu pay buaten yang mga tau tung numyu. Kung unu pay nag̱ipag̱alas-alasu tung numyu, ya ra kay ipagngel mi tung kadaklan. ");
INSERT INTO tbk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Indiamu mag̱eled tung mga taung gustu nirang mangimatay tung numyu ang ya ra ka ilem yang mga tinanguni mi ay sarangan nirang patayen, ang pagkatapus anda kay sarang ang mabuat nirang malain tung ispiritu mi. Kung indi, yang dapat ang eldan mi enged, ya ra yang Dios ang yay sarang ang magbuat ta ikadiadu yang tinanguni yang sasang tau pati ispiritu na duun tung impirnu. ");
INSERT INTO tbk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dispuis para indiamu mag̱eled tung buaten yang mga tau tung numyu, pademdeman mi ra ilem yang mga kutung ang mga balaynen. Indi w̱a, kung mangalangamu tung palingki, maskin duruang bilug, durung pisan agkabaratu? Piru andang pisan ay kutung may sam bilug ang lumagpak tung tanek ang indi magtandaan yang Ama mi. ");
INSERT INTO tbk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ya pa yamung mga tauanu, paw̱aya-w̱ayaanamu pa anya? Ultimung mga bua mi ilem ngani pinamilang na rang tanan. ");
INSERT INTO tbk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Purisu indiamu mag̱eled. Ay yamu mas maal tung anya kay tung mga kutung ang paneng. ");
INSERT INTO tbk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kapurisu kung tinu pay mag̱ubligar tung katalungaan yang mga masigkatau na ang tanya sasa rang tauanu, ig disir ta yeen, kung kaw̱utun da nganing yang uras, yuu kay magpailala tung anya tung katalungaan ni Ama duun tung langit ang tanya sasa ra ka man tauanu. ");
INSERT INTO tbk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piru kung tinu pay mag̱ingwara tung yeen tung katalungaan yang mga masigkatau na ang tanya belag̱an tauanu, ig disir ta yeen, yang buatenu, ingwaraenu ka tung katalungaan ni Ama duun tung langit ang tanya belag̱an ka man tauanu.” ");
INSERT INTO tbk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Indiamu maglaum ang yang inangayu taa ang para yang tanan ang mga tau mamag̱uruyunan dang mamagsarasaan, kung indi, asan da ngani mamagsuruag-suag̱an natetenged tung pagpabetang nira tung yeen ang indi ra magpariu-pariu. ");
INSERT INTO tbk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ayw̱a indiamu paamanenu, sindu anday dumang pakaw̱utun na, kung indi, yang sam pamilya magberelag̱an da ta kinaisipan may kinaisipan. Yang sasang lalii magbelag̱an ta kinaisipan tanirang mag̱ama. Yang sasang baw̱ay magbelag̱an ka ta kinaisipan tanirang mag̱ina. Yang sasang minag̱aren ang baw̱ay magbelag̱an ka ta kinaisipan tanirang magpunyangan ang baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bilang yang magkuntra enged tung sasang tumatalig tung yeen ya ra mismu yang may kaampiran tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Purisu katulad tung sasang ana, kung yang gegma na tung ginikanan na ya ray lusu tung gegma na tung yeen, yang taung atia, indi magkabag̱ay tung yeen ang ugyatanu pa. Pariu ka tung sasang ginikanan. Kung yang gegma na tung ana na ya ray landaw tung gegma na tung yeen, ya ka, indi ka magkabag̱ay tung yeen ang ugyatanu pa. ");
INSERT INTO tbk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kung tinu pay indi magpakatenten ang mag̱agwanta tung mga kaliwag̱an ang maskin ipalansang pa tung krus ig magpalalang ka tung yeen, yang taung atia indi magkabag̱ay tung yeen ang ugyatanu pa. ");
INSERT INTO tbk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kung tinu pay pagsikad ang yang sadili na ang pirmi tung matinlu, asan da nga kapa-kapaay na yang kaampiran na tung yeen. Piru kung tinu pay mamirdi tung sadiling kalelyag̱an na natetenged tung yeen ang yuu ray ipalusu na ta gegma na, asan nga siguruay na yang kaampiran na tung yeen ang yay pagnatisan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tung pagliliw̱utun ming pagparakaw̱utun yang bitalaw, kung tinu pay mag̱asikasu tung numyu tung balay na, katimbang nang yuu kay nag̱asikasuen na. Dispuis kung tinu pay mag̱asikasu tung yeen, katimbang na ka ang yang nagtuw̱ul tung yeen, ya kay nag̱asikasuen na. ");
INSERT INTO tbk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kung tinu pay mag̱asikasu tung numyung pag̱apanuw̱ulung magpalatay yang bitala yang Dios natetenged ag̱ilalaenamu ka anyang maning ka man tii, may ibles yang Dios tung anyang magkapariu ka tung ibles na tung numyung mga manigpalatay. Kung tinu pay mag̱asikasu tung numyung matinumanen tung nag̱auyunan yang Dios natetenged ag̱ilalaenamu ka anyang maning ka man tii, may ibles ka yang Dios tung anyang magkapariu ka tung ibles na tung numyung matinumanen. ");
INSERT INTO tbk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kung tinu pay magtaw̱ang tung numyung mga tauanu, maskin aranek ta pagkabetang ig maskin gesyeng bag̱ay ra ilem yang itaw̱ang na ang katulad ka tung sam basu ra ilem ang waing malamig ang ipainem na tung numyu natetenged ag̱ilalaenamu ra ka anya ang yamu nag̱atuw̱ulu, iugtulu tung numyu, siguradung balesan ka enged yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Numanyan atiing pagkatapus ni Jesus tung pagparabalunun na ta mga bitala tung yamen ang nag̱apangugyatan nang sam puluk may durua, dayun dang nagliit tung lugar ang atii ang nagliliw̱utun tung mga lansangan ang alelengeten ug̱ud magturuldukun tung mga tau ang nunut da ka ta pagparakaw̱utun na tung nira yang Matinlung Balita. ");
INSERT INTO tbk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Numanyan ibalik ta ra kanay tung ni Juan ang atiang manigbenyag ang duun da ka man tung kalabus. Atiing nabalitaan na ra natetenged tung mga buat-buat ni Jesus ang tung anyang pag̱intindi ya ra yang pag̱aningen ang Cristo, nanuw̱ul da tung pinangugyatan nang duma ang mansiangay ra kanay duun tung anyang mamagpasiguru. ");
INSERT INTO tbk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Numanyan tung pagkaw̱ut nira, mag̱aning tung ni Jesus, “Minangayami ilem taa, ay gustu yamen ang magtalimaan tung nuyu kung yawa ka man yang pag̱aningen ang Cristong Mananapnay ang nag̱aelatan kang lag̱i yamen u kung may duma pang dapat ang elatan yamen?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mag̱aning ka ti Jesus ang nagtuw̱al, “Ala, magbalikamu ra duun tung ni Juan. Ibalita mi ra tung anya yang kumpurming nag̱agngel mi kag nag̱aita mi taa. ");
INSERT INTO tbk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aningen mi ang yang mga buray pangaita ra, pati mga barik pangapanaw ra ka, pati mga taung may dispirinsia tung mga ulit nirang makabiw̱iru, nag̱apanguatan da ka ta pagkamansadu nira, pati mga bengel pangagngel da ka, pati mga patay nag̱apampabungkaras da ka. Asta yang mga taung kumpurming aminadu ra ang anda ray sarang ang mabuat nirang matinlu ang para risibien yang Dios, ya ra kay nag̱apampakaw̱utan ta Matinlung Balita kung ya pa ag̱aring mapalg̱uran da nira yang paggaraemen na. ");
INSERT INTO tbk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kidispuis pa aningen mi ka dayun ti Juan ang durug tinlu yang mabtangan yang sasang taung indi enged maplekan ta ipagtalig na tung yeen,” mag̱aning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Numanyan atiing namagliit da yang mga tauan ni Juan ang atia, ya ray pagpasanag ni Jesus tung mga taung atiang buntun natetenged tung ni Juan. Mag̱aning tung nira, “Atiing pag̱angay mi tung ni Juan duun tung banwang atiing palag-palag yang tau na, unu pang klasiay ta tau ang nag̱alaum ming maita mi duun? Yang kalaum mi w̱asu tanya sasang taung guruyud-guyuran ta tau ang katulad ka tung tigbaw ang kung eyepen da nganing ta palet, pagpanunut-nunut da ilem? ");
INSERT INTO tbk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kung belag̱an kang ya tii, unu pa w̱asu ay inangay mi duun? Gustu mi ilem basung magteleng tung sasang taung pagsuut ta durug tinlung aw̱el? Belag ka siguru, ay kipurki yang mga taung mga maning tia yang bisti nira duun da ilem ngaitaay mi tung mga palasiu yang mga adi. ");
INSERT INTO tbk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kung belag̱an kang ya tii ay inangay mi, tay unu pa w̱asu yang katuyuan mi duun? Gustu mi w̱asung magteleng tung sasang taung tinuw̱ul yang Dios ang magpalatay yang bitala na tung numyu? Anday duma, talagang yaa, ya ra ka man tii ay naita mi duun. Piru iugtulu tung numyu yang taung atiing naita mi duun, landaw pa nganing tung mga manigpalatay yang bitala yang Dios ta namagtukaw ang mga panimpu. ");
INSERT INTO tbk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ay kipurki ti Juan ang naa ya ka man ay nag̱adapatan yang sasang inaning yang Dios tung sasang aruman na ang napabtang tung kasulatan ang mag̱aning, ‘May sasang taung tuw̱ulunung magpalatay yang bitalaw tung mga tau ang yay ipatkawu tung nuyu ug̱ud katulad ka tung sasang pagliway yang dalan, yay maning pa tung magliway tung mga isip nira ug̱ud simpan da tanirang mamampauyun da tung nuyu,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iugtulu tung numyu, tung tanan ang mga manigpalatay ta namagtukaw ang mga panimpu, anda ray lumandaw tung ni Juan ang naang manigbenyag. Piru maskin pang maning tia, yang sasang tauanung napalg̱ud da tung palaksu yang paggaraemen yang Dios, maskin pag̱atelengan ang aranek ta pagkabetang, piru may nalandawan na pa ka enged tung ni Juan. ");
INSERT INTO tbk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dispuis, mag̱impisa pa atiing paglua ni Juan ang manigbenyag ang asta ra ilem simanyan ang tung yeen da, yang palaksu yang paggaraemen yang Dios ang naang baklu, mapuirsa yang abanti na ig mapuirsa ka yang mga taung kumpurming pag̱imuras dang magpalg̱ud. ");
INSERT INTO tbk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ang pagkatapus, kung unu pay palaksu yang paggaraemen nang atia, nagkaraula yang tanan ang mga manigpalatay yang bitala yang Dios pati yang nagkaraula ni Moises. Piru baklu pa nag̱impisang nagkamatuud da yang nagkaraula nira, tung paglua ni Juan. ");
INSERT INTO tbk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Ig kung gustu ming mananged tung inula yang sasang manigpalatay, asan da ngaintindiay mi ang ti Juan ang naa ya ray nanubli tung katengdanan ang pinggesan ni Elias ang tukaw. ");
INSERT INTO tbk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Purisu yang nag̱agngel yang mga talinga mi, ipabtang mi tung mga isip mi. ");
INSERT INTO tbk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Piru ay pa w̱a? Yang mga tau simanyan ang indi mamag̱impurmi tung yeen, unu pay mapananglitanu tung nira? Anday duma tanira maning pa tung mga mamula ang pamagkarayam tung plasa ang maskin unyen pa ta paiwan-iwan yang mga kaarumanan nira, indi ka enged mapatunu-tunuan yang kalelyag̱an nira. Ya ra ag̱aningay yang mga kaarumanan nirang, ‘Uay, duruamug kaduruma! Ang magtarangit-tangitenaming mag̱urulimengmeng-ulimengmengen, indiamu ra malelyag ang magpakigsampura. Utru si ang patikanamu yamen, indiamu si ka enged malelyag ang magtaralekan.’ ");
INSERT INTO tbk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Talagang yay magkatamang mapananglitanu tung mga taung atia ay kipurki atiing paglua ra ni Juan ang manigbenyag, maita yang mga tau yang ug̱ali nang pamlek ang kaisan tung pagparanganen na ig indi ka panginem ta binu, indi ra nauyunan nira, kung indi, ya ra ag̱aningay nirang pag̱aekel-ekelan ta dimunyu. ");
INSERT INTO tbk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Utru si ang tung yeen dang pag̱aningen ang Maninga Tau, tung pagluaw tung mga tau, maita ra nganing nira yang ug̱aliu ang indiaw pamlek tung pagparanganenu kag panginemaw kang kaisan ta binu, indiaw ra ka nauyunan nira, kung indi, yuu ka ag̱aningay nirang takaw̱aw ig bulatsiruaw pa kumus pagpakigbarkadaw tung mga manigpanukut may tung duma ang ya kay nag̱alamku nirang mga teleb ta kasalanan. Piru yang planu yang Dios ang atiang nag̱apangindian da nira, duun da nga pruibaay tung mga taung kumpurming pagpauyun tung yamen ni Juan ang talagang durug tinlung planu sigun tung pinakaw̱ut na tung nira,” mag̱aning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Numanyan may uras ang ti Jesus nag̱intra ra biw̱italaen natetenged tung kateteg̱asen yang mga taung tag̱a duma-rumang mga lansangan ang ya ray pinagpaitaan na ta durung mga pruibang maktel ang pagkatapus indi ra ka enged nangapanligna tung mga kasalanan ang pag̱abuat nira. ");
INSERT INTO tbk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Mag̱aning tanyang nagbitala, “Kanugun yang mabtangan yang mga taung atiang tag̱a Corasin may Betsaida. Kipurki kung kisira duunaw ra rin tung Tiro may Sidon napagpalapus ta mga pruibang maktel ang pariu ka tung ipinagpaluaw duun tung mga lansangan nirang atia, siguru yang mga taung atii nabuay ra ka rin ang nangapanligna tung mga kasalanan nira. Nabuay ra ka rin ang nangapagsuut ta mga aw̱el ang magig̱ilek ang nangapagbukbuk ta mga kaw̱u tung mga kulu nira ang para asan da mamagpailala ang tanira pamanligna rang matuud. ");
INSERT INTO tbk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Piru iugtulu tung numyu, kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung tanan ang mga tau, malakan-lakan pa yang parusang dangaten yang mga tag̱a Tiro may Sidon kay tung dangaten yang mga tag̱a Corasin may Betsaida. ");
INSERT INTO tbk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pati yang mga taung atiang tag̱a Capernaum, ya ka, kanugun ka yang mabtangan nira. Ay kipurki yang kanisip nira mamagkatinir da ta dengeg nirang mas abwat ang asta mamanungkuk da duun tung langit ang pagkatapus duun da ka ilem mangalambeg tung Hades. Kipurki yang mga pruibang maktel ang ipinagpalapusu duun tung lansangan nira, kung duun pa rin tung lansangan ang Sodoma nga paluaay atiing tukaw, ang asta ra ilem simanyan duun pa ka rin yang lansangan ang atii. ");
INSERT INTO tbk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Piru iugtulu tung numyu, kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung tanan ang mga tau, malakan-lakan pa ta gesye yang parusang dangaten yang mga tag̱a Sodoma kay tung dangaten yang mga tag̱a Capernaum,” ag̱aaning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Numanyan tung mga uras ang atii ang midyu durung pamagkuntra tung ni Jesus, anday dumang binuat na, nag̱ampu ra tung Dios ang mag̱aning, “Amang makagag̱aem tung tanan, mag̱ing tung kalangitan may tung katanekan man, durug dakul yang pagpasalamatu tung nuyu. Ay pinapaglaw̱uk mu ra yang isip yang mga taung pagtalig tung pagkamataku nira ang para indi ka ilem maintindian nira sigun tung paggaraemen mung naang baklu ang nag̱ipagpakaw̱utu. Ang pagkatapus binuskad mu yang isip yang mga taung mga inusinti ug̱ud mamaresmesan da nira yang mga bag̱ay ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Salamat, Ama, ang nagkamaningan da ka man ta maning tia ay natetenged ya kang lag̱i ay uyun tung kalelyag̱an mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Numanyan pagkatapus na ta pag̱ampu, dayun dang nagpasanag tung mga tau ang mag̱aning, “Yang tanan ang atiang nag̱ipagpalatayu tung numyu, luw̱us dang ipinag̱intriga tung yeen ni Ama. Andang pisan ay nag̱asangkad yang kabag̱ay-bag̱ayan yang pagkabetangu ang yuuy pag̱aningen nang Ana na, kung indi, tanya ilem ang pag̱aningenung Amaw. Pati tanya, anda kang pisan ay nag̱asangkad yang kabag̱ay-bag̱ayan yang pagkabetang nang tanyay pag̱aningenung Amaw, kung belag̱an, yuu ka ilem ang pag̱aningen nang Ana na pati yang kumpurming nag̱alelyag̱anung pabunayag̱an. ");
INSERT INTO tbk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nag̱askeanung magluw̱ayenamu rang aglebatan natetenged tung mga katuw̱ulan ang atiang nag̱ipatuman tung numyu yang mga manigtulduk. Magpalengetamu ra tung yeen ay kuatanamu ra yeen tung lebat ang atiang pag̱asakan mi ug̱ud maenayanamu ra. ");
INSERT INTO tbk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kung tung bakang magsingkawan da ipananglitayu, magpagaemamu ra tung yeen ang magpatulduk. Ay yuu belag̱anaung maiseg ang magkalalangan tung numyu, kung indi, duruaug kaamumu. Purisu kung magpagaemamu ra tung yeen, talagang maenayanamu ra ka man ang matuud tung lebat ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ay kipurki yang nag̱ipatumanu tung numyu, malpes ilem ang pauyunan mi ig malakan ka ilem ang usuyun mi,” mag̱aning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Numanyan may mininsa ang ti Jesus napanaw ra tung dalan ang naknga tung katriguan, kasiraanami ra kang nag̱apangugyatan na. Natuun tung kaldaw ang nag̱ipamaenay tang mga Judio tung mga pag̱urubraen. Kumus yami nag̱aampayanami ra ta suw̱uk, anday dumang binuat yamen, yang pagparanawen yamen ya ra kay pag̱aplut-aplut yamen yang mga kaluay yang trigu ang pagkatapus pag̱akerekese yamen ang pag̱adekem yang mga beyed na. ");
INSERT INTO tbk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Numanyan may mga Pariseo asan ang nangaita tung pag̱abuat yamen ang atia. Pagkaita nira, dayun dang namag̱istinggir tung ni Jesus ang mag̱aning, “Ba tia, ayw̱at pamaglampas da yang mga taung nag̱apangugyatan mung atia tung urdinansa ta ang anday mag̱urubraen ta maning tia tung kaldaw ang nag̱ipamaenay?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mag̱aning ka ti Jesus ang nagtuw̱al, “Ayw̱a, indi mi pa ka enged nag̱amaresmesan yang sasang napabtang tung kasulatan natetenged tung sasang binuat ni Adi David atiing tanya duru ra atiing suw̱uk na pati yang mga aruman na? ");
INSERT INTO tbk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Indi w̱a nagpakled tanya duun tung balay-w̱alay ang atiing pinagtuuan pa rin nira tung Dios atii kanay ang pagkatapus pinangan na yang tinapay ang atiing sagradu ang ya ag̱ipabtangay tung katalungaan yang Dios ang ya pa ka man ay bawal ang panganen na pati mga aruman na kumus belag̱an mga pari? Piru maskin bawal, indi ra ka ipinakusalak yang Dios tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dispuis indi mi pa ka enged nag̱amaresmesan yang sam bilug pang katuw̱ulan ang tung kaldaw ang nag̱ipamaenay may nag̱ipaubra tung mga pari duun tung pagtuuan ang pinakalusu? Purisu kung ikumpalar duun, puiding aningen ta ang ya rag likday nira yang urdinansang bawal ang ipag̱ubra nira tung kaldaw ang nag̱ipamaenay. Piru indi ra ka nag̱ipakusalak yang Dios tung nira yang pag̱urubraen nirang atia. ");
INSERT INTO tbk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Piru iugtulu tung numyu, may sasang kuminaw̱ut da taa tung numyu ang mas pang landaw kay tung pagtuuan ang atiang pinakalusung pag̱ubraan yang mga paring atia tung kaldaw ang nag̱ipamaenay. ");
INSERT INTO tbk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Isipen mi ra kanay yang sasang napabtang tung kasulatan ang mag̱aning, ‘Mas ang may timbang tung yeen ang mag̱irildawanamu kay tung magpadasag̱amu ilem ta mga ayep ang ya ag̱iintrigay mi tung yeen,’ ag̱aaning. Kisira rin ang nag̱amaresmesan mi ra kung unu pay linagpakan na tia, siguru indiamu ra rin nagpakusalak tung mga taung naang belag kang kasalanan yang pag̱abuat nira. ");
INSERT INTO tbk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ag̱aningenamu ra yeen ta maning tia ay yuung pag̱aningen ang Maninga Tau, yuu ray pamala tung mga tauanu kung ya pa ag̱ari yang pag̱urusuyun nira tung katuw̱ulan yang Dios natetenged tung kaldaw ang nag̱ipamaenay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Numanyan nagliit da ti Jesus tung lugar ang atia ang minangay duun tung pagsaragpunan nirang sam bilug ang nagpakled. ");
INSERT INTO tbk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","May tau duun ang napilayan da yang kalima nang sam belak. Taa numanyan may mga Pariseo duun ang ya ray namanalimaan tung ni Jesus ang mag̱aning, “Uyun basu tung urdinansa ang yang sasang taung may dispirinsia tung tinanguni na pamaayenen pa ka enged ta aruman nang tau maskin kaldaw ang nag̱ipamaenay?” Yang ipinagtalimaan nira ta maning tia ay gustu nirang may madeepan nira ta puntus tung anya ang para madimanda nira tung mga ustisia. ");
INSERT INTO tbk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mag̱aning ka ti Jesus ang tuminuw̱al, “Ipabetangu kanay, kung may karniru mi ang nabugsu tung bug̱ang, indi mi w̱asu taw̱angan ang lag̱ing akunun, maskin natuun pa tung kaldaw ang nag̱ipamaenay? ");
INSERT INTO tbk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ig disir kumus yang sasang tau mas maal kay tung sasang karniru, uyun dang pisan tung katuw̱ulan yang Dios ang magbuatita ta ikaayen yang sasang masigkatau ta maskin tung kaldaw ang nag̱ipamaenay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pagkatapus dayun na rang inaning yang taung napilayan yang kalima na, “Ala, iunat mu ra tiang kalima mu,” ag̱aaning. Tamang-tamang ag̱iunat na, naulikan dang lag̱i ang pariu tung duw̱aling kalima na. ");
INSERT INTO tbk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Piru pagkaita yang mga Pariseo tia, dayun dang namaglua ang namag̱urunta-untaan da kung ya pa ag̱ari yang pagpaimatay nira tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Numanyan, pagkabalita ni Jesus ang tanya nag̱atimaan da nira ta maning tia, dayun dang nagliit tung lugar ang atia ang may mga taung duru ang namagpakignunut da tung anya. Pagkatapus kumpurming tinu pa tung nira ay paglaru, luw̱us na rang pinampamaayen. ");
INSERT INTO tbk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tung pagpamaayen na tung nira, dayun na rang pinaglalangan ang indi enged mamagbaw̱alitaen ang natetenged tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tung maning tiang pasais na tung nira, nagkamatuud da yang sasang ipinaula yang Dios tung ni Isaias ang manigpalatay ang tukaw ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Atia yang turuw̱ulunung piniliku. Tanyay nag̱agegmaanu ig ya kay nag̱auyunanu ta mupia. Ya ray patiniranu tung Espiritu Santong para yay magpaktel tung anyang magparakaw̱utun tung mga tag̱a duma-rumang nasyun kung ya pa ag̱aring mapakinaw̱angan nira yang kalibrian ang nag̱isimpanu. ");
INSERT INTO tbk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Piru tung pagparakaw̱utun na tung mga tau, anda tung anya ang magpakigdiskusiun ang pabalalaan. Indi na ka nganing paknulun yang busis nang magdiskursu tung mga karsada. ");
INSERT INTO tbk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kung tinu pay magluw̱ayen dang midyu nag̱aplekan da ta pagtalig na tung Dios, ya ray paamumuan na ta maayen. Kung tinu pay indi na ra sarangan yang sadili na, indi na ka palbatan, kung indi, ya ra nganing ay paitaan na yang kaneeman na. Ya ray prusigiran na ang asta magtukud da yang kalibrian ang mabaked. ");
INSERT INTO tbk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Purisu pati yang mga tag̱a duma-rumang nasyun, ya ra kay panalig̱an nirang magpalua yang kaayenan ang pinangakuan yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Numanyan may nag̱iated da tung ni Jesus ang taung buray ig apa pa natetenged pag̱aekel-ekelan ta dimunyu. Pagkatapus pinamaayen ni Jesus ang asta naita si kag nabitala si. ");
INSERT INTO tbk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pagkaita yang mga taung atiang buntun, durung pagkabereng nirang namag̱araning-aningan dang mag̱aning, “Ya ra w̱asu taa yang manubli tung paggaraemen ni Adi David ang ya kang lag̱i ay nag̱aelatan ta?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Numanyan pagkagngel yang mga Pariseo tia, dayun dang namagsulingaag tung nirang mag̱aning, “Yang taung atia, indi nganing mapagpalayas ta mga dimunyu kung belag̱an tung ni Satanas ang yay pagmangulu tung nira!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Numanyan kumus nag̱askean da kang lag̱i ni Jesus kung unu pay nag̱abtang tung mga isip nira, dayun dang nagbitala tung nirang mag̱aning, “Ag̱aatkean mi, maskin ay pang inadianay, kung mamagkuruntraan da yang mga kinasakpan nang mamagbaratukan, makali ra ilem ang madiadu yang inadian nira. Maskin tung sasang lansangan ubin tung sam pamilya pa, kung magdarapig-dapig̱an da tanirang magsuruay-suayan, rangga ra ka yang pagsarasaan nira. ");
INSERT INTO tbk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kapurisu kung tama yang numyung atia ang ti Satanas yay pagpaktel tung yeen ang pagpalayas tung mga dimunyu, ig disir pagsuruag-suag̱an da pala tanira yang mga dimunyung nag̱amanguluan na mismu. Ya pa ag̱aring magdayun pa yang paggaraemen na? ");
INSERT INTO tbk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dispuis kung tama yang numyung atia ang nag̱apaktelaw ni Satanas ang pagpalayas tung mga dimunyu, tinu pa kaya ay pagpaktel tung mga aruman ming pagpalayas ka tung mga dimunyu? Aningen ming ti Satanas? Belag siguru. Ig disir maski nganing yang mga aruman ming atia, puidi rang mamarik tung katadlengan ming atia. ");
INSERT INTO tbk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Piru kung ya ka man yang Espiritu Santo mismu yang pagpaktel tung yeen ang para mapagpalayasaw tung mga dimunyu, ig disir asan da ka nga pruibaay mi ang kinaw̱utanamu ra ka man yang puirsa yang paggaraemen yang Dios ang naang baklung pag̱atukuru. ");
INSERT INTO tbk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Piru tung pagkamatuud, yang pagkinuntraay yamen ni Satanas ay maning taa tung pananglit ang naa. Kung may sasang mupiang lalii, anday makled tung balay na ang para mag̱akwat da rin tung mga ekel-ekel na kung indi na ra tukawen ang gapusun yang may balay. Atia, pagustu ra yang akwat na tung mga ekel-ekel na. ");
INSERT INTO tbk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Purisu kumus maning da ka man tia yang pagkinuntraay yamen ni Satanas, kung tinu pay indi magpakigsasa tung yeen tung panagpunu tung mga tau, katimbang nang pagpakigkuntra tung yeen ang pagpangwasak tung nira ang para mas dang mamampalawid tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Purisu tandaan mi ta maayen yang bitalaw. Maskin mapatawad yang mga tau tung maskin unu pang kasalananay ang binuat nira, maskin pang duminaren pa nira yang Dios, piru kung yay sawayan nira yang pag̱urubraen yang Espiritu Santo, atia ya ray kasalanan ang indi ra ka enged mapatawad na. ");
INSERT INTO tbk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kung tinu pay magduminar tung yeen ang pag̱aningen ang Maninga Tau, puiding patawaren pa yang Dios tung kasalanan nang atia kung pagsug̱atan na. Piru kung tinu pay mag̱enged ang magduminar tung Espiritu Santo ang yang pag̱urubraen na ya ray sawayan na, tay tia, indi ra ka enged mapatawad yang Dios tung panimpung naa pati tung panimpung kaw̱utun ang anda enged ang pisan ay katapus-tapusan na. ");
INSERT INTO tbk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ipananglitu ra kanay yang bag̱ay ang atia tung mga ayung mga manugburak. Kung yang ayu matinlu, pati yang burak na matinlu ka. Piru kung sayud, pati burak na sayud ka. Kipurki yang sasang ayu asan da tung burak na nga pruibaay kung matinlu u kung sayud. ");
INSERT INTO tbk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yang kaalimbawaan mi, yamu maning pa tung mga iraw ang madaralit. Ya pa ag̱aring mapagbitalaamu ta matinlu atiang malainamu kang lag̱i? Ay simpri kumpurming unu pay nag̱ipabalay yang sasang tau tung isip na, indi maimu ang indi na ipaluang ibitala. ");
INSERT INTO tbk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yang taung maayen, maayen ka yang nag̱ipalua na ay natetenged ang ya ra kang lag̱i ay nag̱ipabalay na tung isip na. Pati yang taung malain, malain ka yang nag̱ipalua na ay natetenged ang ya ra kang lag̱i ay nag̱ipabalay na tung isip na. ");
INSERT INTO tbk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iugtulu tung numyu, kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung mga tau, papanuw̱alen na tanira tung tanan ang mga ibinitala nirang anday kumpas na. ");
INSERT INTO tbk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kipurki kung unu pay nag̱ibitala mi, ya ray pitik ang usuyun nang magpatuw̱al tung numyu kung yamu nga sintinsiaay na tung kalainan u kung yamu nga sintinsiaay nang anday kasalanan,” mag̱aning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Numanyan namansisublang da yang mga Pariseo may yang mga sag̱ad ang mag̱aning tung anya, “Ameey, gustu yamen ang may maita yamen ang pruibang makabew̱ereng ang ipalapus mu rang lag̱i numaan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mag̱aning ka ti Jesus ang minles, “Abaa yang kadaklan ang mga tau simanyan, durug kalain yang palaksu yang mga pag̱irisipen nira. Yang paggeregmaen nira tung Dios nagrusaw ra. Maning pa tung gegma yang sasang baw̱ay ang paglimbung da tung kasawa na. Pamagtag̱am ta reg̱es tung yeen ang magpaitaw ta pruibang makabew̱ereng ang para ya ray magpailala ang yuug tuw̱ulay ka man yang Dios. Piru indi ra paitaanu ta pruiba puira pa tung sam bilug ang magkaanggid tung napanawan ni Jonas ang sasang manigpalatay. ");
INSERT INTO tbk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ay kipurki katulad tung ni Jonas ang tulung kaldaw yang tinir na duun tung tian yang dakulung ian, ta yeen ang pag̱aningen ang Maninga Tau, tulu kang kaldaw yang tiniru tung adalem yang tanek. ");
INSERT INTO tbk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Purisu kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung mga tau ang tanirang tanan pampabungkarasen na, yang mga taung atiing tukaw pa ang tag̱a Ninive, ya ra kay pakdengen yang Dios ang mulidung ipagpasunaid na tung mga tau simanyan. Duun da ka ipatielay na yang katadlengan nang magsintinsia tung nira. Kipurki tanira atiing pinagpakaw̱utan da ni Jonas, lag̱i-lag̱ing namanligna ra tung mga kasalanan nira. Ang pagkatapus, yang mga tau simanyan, indi pa ka enged nag̱apanligna tung mga kasalanan nira ag̱ad naa ra yang sasang landaw pa tung ni Jonas ang pagparakaw̱utun ka tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tung uras ang atia, yang sasang baw̱ay ang yay manigmangulu tung sasang banwa ang ampir duun tung salatan atiing tukaw, ya ra kay pakdengen yang Dios ang sasa kang mulidung ipagpasunaid na tung mga tau simanyan, ang duun da ka tung anya ipatielay na yang katadlengan nang magsintinsia tung nira. Kipurki yang baw̱ay ang atii, maskin alawid ang pisan yang banwang pinanliitan na, piru nagpaawat da ka enged ang nag̱angay taa tung banwa ta, basta mapagpamati ilem tung nag̱itulduk ni Adi Solomon ang makawawayang ta isip. Ang pagkatapus yang mga tau simanyan, ag̱ad naa rang pisan tung tepad nira yang landaw pa ta nag̱askean kay tung ni Adi Solomon ang ya kay pagturuldukun tung nira, ang pagkatapus indi ka nirag pamatien. ");
INSERT INTO tbk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","“Alimbawa, kung may dimunyung lumayas da tung sasang taung sinuutan na ra rin, unu pay mainabu? Anday duma, duun da ilem magpaalyu-alyu tung banwang kapas ay magsagyap da rin ta matiniran na. Piru kung anday maita na, maning taa yang ipagkesen-kesen na tung isip na: ‘Maayen pa magbalikaw ra ilem duun tung dating pinagtiniranung liniitanu.’ Numanyan tung pagbalik na, kaw̱utan na yang taung atiing liniitan na, yang kaalimbawaan na, maning pa tung sasang balay ang sinilig̱an dang ipinatayu-tayu na yang mga garamiten ang pagkatapus bakanti pa. ");
INSERT INTO tbk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Purisu anday dumang buaten yang dimunyung atia, magpangkel da tung mga aruman nang pitu nga dimunyuan ang mas pang malain kay tung anya. Pagkatapus, tanirang tanan dayun dang mamagsuut tung taung atia ang para asan da mamagtinir tung anya. Purisu yang luaan na, mas dang maliwag yang malambeg̱an yang taung atia kay tung primiru ang sam bilug pa ilem din yang dimunyung pag̱ekel-ekel tung anya. Maning kang pisan tia ay malambeg̱an yang kadaklan ang mga tau simanyan ang durug kalain yang palaksu yang mga pag̱irisipen nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Numanyan atiing indi pa nag̱atapus ti Jesus ta pagbitala tung mga taung atiang buntun, asan da namansikaw̱ut ti nanay na may yang mga putul nang mga lalii. Asan da ilem kemdengan tung lua yang balay ang pamag̱elat, ay may gustu nirang mamagpakiksen tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Numanyan may sasang taung nagpaske tung anya ang mag̱aning, “Ameey, nakaa ra tung lua ti nanay mu may yang mga putul mung mga lalii. Gustu nirang mamagpakiksen tung nuyu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mag̱aning ti Jesus ang nagtimales, “Ayw̱a, tung nuyung pag̱intindi, tinu pa w̱asu ay nanayu? Tinu pa w̱asu ay mga putulu?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pagkatapus yaming nag̱apangugyatan na, yami ray pinanulduk na ang nunut da ka ta pasanag nang mag̱aning, “Atia ra yang nanayu may yang mga putulu. ");
INSERT INTO tbk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ay kipurki kumpurming tinu pay pagtuman yang kalelyag̱an ni Ama duun tung langit, yay magkaw̱ig̱enung putulung lalii ubin putulung baw̱ay ubin nanayu,” mag̱aning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Numanyan tung kaldaw ang atii ti Jesus luminua ra tung balay ang nagpabakayan. Duun da kuminarung ay magturuldukanen si. ");
INSERT INTO tbk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Duru-durung mga taung namagtaripukpuk tung anya. Purisu naparugal-rugal dang suminaay tung sasang balangay ang napaabwat-abwat ta gesye. Duun da ilem ngarung ang ya kag tatalunga tung mga taung kemdengan asan tung bakayan. ");
INSERT INTO tbk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Duru-durung mga bag̱ay ang ipinagtulduk na tung nira ang asan da nag̱ipapanaway na tung mga pananglit. Mag̱aning tanyang nagpananglit, “Numanyan may sasang taung minangay duun tung pinagbangteran na, ay magtarakbulun da ta binik ta trigu. ");
INSERT INTO tbk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Numanyan tung pagtarakbulun na, yang dumang binik nalagsik da tung dalan ang palanawan ta mga tau tung kakngaan ang pagkatapus kinaw̱utan da ta mga lamlam ang pinagsumpit. ");
INSERT INTO tbk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yang duma kang binik, duun ka nepa tung tanek ang manipis ang may batung tapik ang unayen ang alenget dang lumput tung ulit yang tanek. Purisu indi ilem nabuay, buminukngil da ay malw̱aw kang lag̱i yang tanek. ");
INSERT INTO tbk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Numanyan pagkapangayag da ang atiing abwat da yang kaldaw, nangaleey ra ang asta namanlumpayeng dang pisan ay indi nangapanlamut ta adalem. ");
INSERT INTO tbk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yang duma kang binik duun ka nepa tung tanek ang may mga laskaw yang sapinit ang indi nadeeg̱an ta kapwa yang aradu. Purisu tung pagkatubu yang mga sapinit, pinanaw̱ed-saw̱eran da nira yang mga trigu ang pinagpig̱es. ");
INSERT INTO tbk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Piru yang dumang binik duun da tung lunsan ang tanek nepa ang asta namansidarakul dang nangapamurak. Yang pangaluay yang duma arabubwat da ang tung kategkaan na ra, yang duma kasarangan, yang duma inisen. ");
INSERT INTO tbk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ta, yang nagngel ta mga talinga mi, ya ra kay painu-inuan mi ta mupia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Numanyan yaming mga nag̱apangugyatan nang dati, nagpalengetami ra tung anyang nanalimaan ang mag̱aning, “Natetenged tung unu pa w̱asu nag̱ipananglit mu ra ilem yang gustu mung ianing tung mga tau?” ");
INSERT INTO tbk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mag̱aning ka ti Jesus ang tuminuw̱al, “Yang nag̱ipagpananglitu tung mga tau ay natetenged belag̱an parariu ta pupusukun. Ta yamung pagpaugyat da tung yeen, linugtanamu ra yang Dios ang makdekan mi ra yang mga bag̱ay ang nag̱aegteman na pa rin ang tukaw natetenged tung paggaraemen nang baklu tung mga tau kung ya pa ag̱aring tukurun na. Piru tung mga taung atiang pamagpamati ka ilem, indi na ilinug̱ut. ");
INSERT INTO tbk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ay ya pa ag̱ari, kumpurming tinu pay maderep ang magpasadsad tung nag̱ipananglitu, dulangan pa yang Dios yang maintindian na ang para anday kulang na. Piru kumpurming tinu pay paw̱aya-w̱ayaen ang magpasadsad, maskin yang gesyeng atiang nag̱aintindian na, bawien da ka enged yang Dios tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Purisu ya ray nag̱ipagpagngelu ta mga pananglit tung nira ay natetenged yang kadaklan maskin sam puluk ang magteleng, maning pa tung anday sinakep ta mga mata nira, basin sam puluk ang mamati, maning pa tung anda kay nagngel nira, kag anda kay naintindian nira. ");
INSERT INTO tbk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Purisu taniray nag̱atemengan da yang sasang ipinaula yang Dios tung ni Isaias ang tukaw ang mag̱aning, ‘Kung pampakaw̱utan da nganing yang mga taung naa yang bitalaw, mamati ra ilem ang mamati, piru indi ra ka enged mangakleran. Magteleng da ilem ang magteleng, piru maning pa tung anday sakpen ta mga mata nira. ");
INSERT INTO tbk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ay pa ag̱ari, yang mga kinaisipan nira pakiputun da nira, pati mga talinga nira pabengelen da ka nira, asta mga mata nira pameyengen da ka nira. Ya ray buw̱uaten nira ay may sasang pangamanan enged nira asan, ang kung disgrasia magkarakleran da yang mga kinaisipan nira, kung mag̱aranting da yang mga talinga nira, kung magkarabuskad da yang mga mata nira, muya mamagsug̱at dang mamagbalik tung yeen ang asan da rin nga panapnayayu,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Piru ta numyu, teed mi tiang kaayenan ang nag̱ipakdul da yang Dios tung numyu! Ay yang kaalimbawaan mi maning pa tung maikas da yang mga talinga mi, buskad da yang mga mata mi. ");
INSERT INTO tbk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ag̱aningenamu ra yeen ta maning tia ay atiing tukaw pang mga panimpu, dakeleng mga manigpalatay, dakele kang mga taung matinumanen tung nag̱auyunan yang Dios ang duru ka rin ang kalelyag nirang mangagngel yang nag̱agngel mi numanyan tung yeen, ang pagkatapus indi ra ka nagngel nira. Duru ka rin ang kalelyag nirang mangaita yang nag̱aita mi numanyan tung yeen ang pagkatapus indi ra ka naita nira. ");
INSERT INTO tbk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Purisu ta numyu, pamatian mi ra kanay ta mupia kung unu pay linegdangan yang ipinananglitung atia natetenged tung manigtakbul. ");
INSERT INTO tbk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kung natetenged tung dalan ang atiang nalagsikan ta binik, yang linegdangan na ya ra yang kumpurming pamati tung nag̱ipagpakaw̱ut tung nira natetenged tung palaksu yang paggaraemen yang Dios ang baklu ang pagkatapus indi ra nira nag̱amaresmesan. Yang nag̱ainabu, nag̱apalengtan dang lag̱i ni Satanas ang yay pinangapunglan ta tanan ang malalain ang pagkatapus ludasen na ra tung mga isip nira yang nagngel nira. ");
INSERT INTO tbk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yang linegdangan yang tanek ang atiang manipis ang may batung natampek, ya ra yang duma ang kung mapamatian da nganing nira yang bitala yang Dios, atiang lag̱i magpauyun da ang duru rag kasadya yang mga isip nira. ");
INSERT INTO tbk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Piru kumus indi nalamut ta ustu tung mga kinaisipan nira, indi ra ilem buay yang pagparanangeren nira. Ay kung mapasaran da nganing ta kaliwag̱an ubin pandeeg-deeg natetenged tung bitalang atiang nag̱apananged da rin nira, atiang lag̱i, mansipalpas da ka ilem. ");
INSERT INTO tbk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yang linegdangan yang tanek ang atiang may mga laskaw ang masapiniten, ya ra yang duma ang maskin pamati tung bitala yang Dios, piru kumus masyadung pagpakabegbeg nira tung mga pagpangabui nira taa tung kaliw̱utan ang naa ubin tung pag̱intris nirang magmanggad, maning pa tung asan da ilem nga pig̱esay yang bitalang nag̱agngel nira ang asta anda ray pinakaw̱ut na. ");
INSERT INTO tbk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yang linegdangan yang tanek ang atiang lunsan ya ra yang duma ang tung pagparamatien nira tung bitala yang Dios ya ray nag̱apamaresmesan nira ta mupia. Ya ra yang mga tau ang yang pag̱irintindien nira may pakaw̱utun nang nag̱auyunan yang Dios. Tung duma may pakaw̱utun nang kategkaan na ra enged, tung duma may pakaw̱utun nang kasarangan, tung duma geg̱esye ka ilem yang pakaw̱utun na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Numanyan nagpagngel si ti Jesus ta sam bilug sing pananglit ang mag̱aning, “Yang palaksu yang paggaraemen yang Dios ang naang baklu maning taa. May sasang taung nagtarakbulun ta analadung binik yang trigu tung pinagbangteran na. ");
INSERT INTO tbk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pagkatapus may sasang law̱ii ang yang sasang taung pagpakigsuay tung anya yay nasubli tung uras ang ierelek da yang mga tau. Ya ra kay nagtarakbulun tung katriguan yang aruman na ang yang ipinanakbul na ya ra yang mga similya yang sasang ilamunun ang may pagkatrigu na Pagkatapus ta pagtarakbulun na, dayun dang nagliit. ");
INSERT INTO tbk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Numanyan tung pagtubu nira, amat-amat dang pinangisian, baklu ra ngailala tung mga kaluay nira ang naa pala laket-laket da yang trigu may yang ilamunun ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Numanyan pagkainsapu yang mga turuw̱ulun yang may trigu, dayun dang namagbalik tung ag̱alen nirang namagbaw̱alitaen ang mag̱aning, ‘Maepet, belag bang analadu yang binik ang atiing ipinatakbul mu tung yamen duun tung pinagbangteran? Ya ra ileg ari kaya ang naglalaketan da ilem yang trigu may yang ilamunun ang atiang may pagkatrigu na?’ ");
INSERT INTO tbk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mag̱aning ka yang ag̱alen nirang minles, ‘Aa, siguru yang taung atiang pagpakigsuay tung yeen, ya ray nagsisting nanakbul tia,’ Mag̱aning ka tanirang namanalimaan, ‘Ta, maepet, gustu mung pamundukun da ilem yamen yang may pagkatrigu na?’ ");
INSERT INTO tbk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mag̱aning ka tanyang tuminuw̱al, ‘Indi ra kanay. Muya pati yang trigu madamay pang mapunduk. ");
INSERT INTO tbk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Maayen pa, paw̱ayaan da ilem kanay ang asta kaw̱utun da yang tilig̱ayeg baklu ra mandarayu yang mga manig̱ayeg ang pamundukun da kanay nira yang ilamunun ang atiing may pagkatrigu na ang pagkatapus pamegkes-begkesen nira ang para sirukun tung apuy. Matapus da nganing nira tia, baklu ra dayunay nirang ayeg̱en yang purung trigu ang tumpien tung tambuw̱uu,’” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Numanyan nagpananglit si ti Jesus ang mag̱aning, “Yang kaalimbawaan yang palaksu yang paggaraemen yang Dios ang baklu ang naang pag̱atukuru, maning pa tung lisu ta mustasa ang ingkelan yang sasang taung ipinanakbul tung sular na. ");
INSERT INTO tbk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maskin pinakagetey tung tanan ang mga lisu, piru kung tumubu ra nganing, ya ray mag̱ing pinakaabwat tung tanan ang kapariu nang luak ang gurulayen. Magyari rang ayu ang mananga-sanga ang pati mga lamlam duun da kag pamangapun ang pamagbayay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pagkatapus may sam bilug sing pananglit ang ipinagngel ni Jesus ang mag̱aning, “Yang kaalimbawaan yang palaksu yang paggaraemen yang Dios ang naang baklu, maning pa tung pampaleskag ang ilinaket ta sasang baw̱ay tung sang palangganang arina ang pag̱abuat nang tinapay ang asta pinaleskag na yang intirung pag̱amasa na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yang tanan ang mga bag̱ay ang atia natetenged tung paggaraemen yang Dios ang baklu luw̱us ang ipinapanaw na tung mga pananglit ang ipinagngel tung mga taung atiang buntun. Indi nagparakaw̱utun tung nira kung indi ipinapanaw na tung mga pananglit. ");
INSERT INTO tbk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Purisu asan da nagkamatuud yang sasang ipinaula yang Dios tung sasang manigpalatay ang tukaw ang mag̱aning, “Kung magparakaw̱utunaw ra nganing tung mga tau, magparananglitenaw. Ipasimanu tung nira yang mga bag̱ay ang inegteman pa rin yang Dios disti pa atiing pag̱imu na yang kaliw̱utan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Numanyan nagpaske ra ti Jesus tung mga tau ang tanya magliit da. Purisu dayun dang minulik duun tung balay na ang nagpakled. Numanyan pinalengtan da yamen ang nag̱apangugyatan nang inaning, “Maimu ilem, pasanag̱ayami ka kung unu pay linegdangan yang ipinananglit mu natetenged tung ilamunun ang atiang may pagkatrigu na ang nalaket tung katriguan.” ");
INSERT INTO tbk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mag̱aning ti Jesus ang nagpaintindi, “Yang taung atiang nagtarakbulun ta analadung binik, yuu ra ang pag̱aningen ang Maninga Tau. ");
INSERT INTO tbk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yang pinagbangteran ya ra yang bilug ang kaliw̱utan. Yang analadung binik ya ra yang mga taung nagpagaem dang bug̱us tung Dios. Yang ilamunun ang atiang may pagkatrigu na, ya ra yang mga taung nag̱amanguluan ni Satanas. ");
INSERT INTO tbk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yang taung atiang nagpakigsuay tung aruman na ang ya kay nagtarakbulun ta similya yang may pagkatrigu na, ya ra ka man mismu ti Satanas. Yang linegdangan yang ayeg, ya ra yang uras ang ipagtapus yang Dios tung panimpung naa. Yang mga manig̱ayeg ya ra yang mga angil. ");
INSERT INTO tbk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Purisu katulad ka tung ilamunun ang atiang may pagkatrigu na ang pinamunduk dang pinagpunpun ang pagkatapus pinagsiruk tung apuy, maning kang pisan tia ay mainabu tung uras ang ipagtapus yang Dios tung panimpung naa. ");
INSERT INTO tbk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ay ta yeen ang pag̱aningen ang Maninga Tau, panuw̱ulunu yang mga angilung punpunun da nira yang mga taung kumpurming pagpagaem-gaem ilem tung yeen. Ya ra yang kumpurming pagsunlug tung mga aruman nirang magpakasalak may yang kumpurming nagpadayun tung paglalampasen nira tung mga katuw̱ulan yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tanirang tanan luw̱us ang ipamlek nira tung impirnu, duun tung apuy ang maning pa tung sasang urnuan. Duun da tanira mamagtarangiten ang mamagkaretket yang mga isi nirang mamagpapinitinsia. ");
INSERT INTO tbk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pagkatapus yang mga taung nag̱abiw̱ilangung salu rang pisan tung pagterelengenu, pampadengeg̱anu ra ta mupia duun tung baklung kaliw̱utan ang paggaeman yang Ama nira ang yang pagkabetang nira masusulaw rang pisan ang anggid tung kaldaw yang kasusulawen nira. Purisu kung unu pay nagngel ta mga talinga mi, ipabalay mi ra tung mga isip mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mag̱aning ti Jesus ang nagpananglit si, “Kung ipananglitu kung unu pay balur na tung sasang tau ang magpalg̱ud da tung palaksu yang paggaraemen yang Dios, maning pa tung may sasang manggad ang itinaluk ang itinampek tung tanek, ang pagkatapus naita ta sasang tau. Pagkaita na, ibinalik na si kang itinampek. Pagkatapus natetenged tung kasasadyaen yang isip nang duru, dayun dang minulik ang nagpaalang da yang tanan ang nabtang tung pudir na ang pagkatapus binalikan na sing inalang yang tanek ang atiing pinagtampekan na yang manggad ang atii. ");
INSERT INTO tbk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yang sam bilug pang ipananglitu tung balur na tung sasang tau ang magpalg̱ud da tung palaksu yang paggaraemen yang Dios, maning pa tung sasang nigusyanti ang pagsagyap ta mga musyang matitinlu ang para alangen na. ");
INSERT INTO tbk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagkatapus atiing may napanawan nang sam bilug ang inding pisan mapakdingan, anday duma, dayun dang minulik ang nagpaalang da yang tanan ang nabtang tung pudir na ang pagkatapus binalikan na sing inalang yang musyang atii.” ");
INSERT INTO tbk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Utru si, nagpakdul da ta sasang pananglit tung mga taung nag̱apangugyatan nang mag̱aning, “Yang palaksu yang Dios tung paggaraemen na tung uri maning pa tung sasang lambat ang itinaktak yang mga manug̱ian tung aw̱uyuk ang pagkatapus sari-saring klasi ta mga ian ang nasapul. ");
INSERT INTO tbk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Numanyan pagbatak nira yang lambat, dayun da nirang ginuyuran tung takas. Asan da ilem nansikarung ang namagpilik yang mga ian. Yang mga matitinlu ipinabtang da nira tung mga tiklis. Yang anday pakinaw̱ang ipinamlek da ka ilem nira asan. ");
INSERT INTO tbk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ya kang pisan tia yang kaalimbawaan yang mainabu tung uras ang ipagtapus yang Dios tung panimpung naa. Tung uras ang atia, panuw̱ulunu ra yang mga angilung mamagliliw̱utun da tung bilug ang kaliw̱utan ang para kumpurming tinu pay pagpadayun tung pagburuaten nirang mga malalain, ya ray paminig̱en nirang ipampablag tung kumpurming tinu pay pagpadayun tung pag̱urubraen nira yang magkatama. Pagkatapus yang ipinampablag nirang atia ya ray ipamlek da nira tung impirnu, duun tung apuy ang maning pa tung sasang urnuan. Duun da tanira mamagtarangiten ang mamagkaretket yang mga isi nirang mamagpapinitinsia.” ");
INSERT INTO tbk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Matapus na yang pagparanangliten na, dayun dang nagtalimaan tung yamen ang nag̱apangugyatan na ang, “Ta, nag̱aintindian mi ra yang linegdangan yang tanan ang pinananglitanung atia?” Ag̱aaningami kang nagtimales, “Ee, nag̱aintindian da ka yamen.” ");
INSERT INTO tbk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mag̱aning ka ti Jesus ang minles, “Maayen ka tia kipurki yang tanan ang mga sag̱ad tung kasulatan ang dati ang kumpurming naugyatanu ra natetenged tung palaksu yang paggaraemen yang Dios ang naang baklu ang pagkatapus dayun da kang nagpagaem ang bug̱us tung yeen, maning taa yang kaalimbawaan nang magturuldukun tung duma. Tanya magkapariu tung sasang manggaranen ang may kuartung pagtalukan na ta mga mamaalen na ang puiding abrian nang para ipalua na ra yang mga mamaalen nang baklu pati yang dati.” ");
INSERT INTO tbk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Numanyan matapus ni Jesus yang pananglit ang atia, dayun dang nagliit tung banwang atia. ");
INSERT INTO tbk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Numanyan, pagbalik na duun tung banwang pinagdakulan na, nag̱impisa rang nagturuldukun tung mga taung namagsarapun da duun tung pagsaragpunan nira. Yang pinakaw̱ut na, nangabereng da ta mupia tung anyang namag̱araning-aningan dang mag̱aning, “Abaa, yang tau kang naa ka, ay pa ngaeklay na yang kataku nang atia ang pagkatapus ya pay magtulduk tung yaten? Pati yang mga pruibang atiang maktel ang nag̱abalitaan tang nag̱apagpalapus na buat, ay pa ngaeklay na? ");
INSERT INTO tbk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Belag bang atia ana ka ilem yang karpintiru ta? Belag bang yang nanay na ti Maria? Belag bang yang mga putul nang lalii ti Santiago, ti Jose, ti Simon, may ti Judas? ");
INSERT INTO tbk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Belag ba ang pati yang mga putul nang mga baw̱ay, taa kang tanan agpamag̱istar tung banwa ta? Ayw̱a, unu pa w̱asu ay pagpabetang na tung sadili na?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Purisu duun da namagmalagana yang mga isip nirang namagdiskumpiar tung anya. Numanyan mag̱aning ti Jesus tung nira, “Talagang matuud ka man pala yang bitala yang mga mamaepet ang yang sasang manigpalatay yang bitala yang Dios, maskin ay pang banwaay nga teyeb, nag̱agalang ta mga tau, puira pa tung banwang natauan na maskin pa tung seled yang sadiling pamalay-w̱alay na, anda ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Purisu gesye ka ilem yang mga pruibang maktel ang ipinagpalapus na duun natetenged tung pagdiskumpiar nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Numanyan tung mga uras ang atii, naang ti Gubirnadur Herodes nabalitaan da yang natetenged tung mga pruibang makabew̱ereng ang nag̱ipagpalapus ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mag̱aning tung mga taralig̱an na, “Anday dumang taung may ubra tia, kung belag̱an ti Juan ang manigbenyag ang ya si kay nabuing uman. Ya ray natengeran na ang may kagaeman nang magpalapus ta mga pruibang maning tiang maktel,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Balikan ta ra kanay ti Juan ang manigbenyag kung unu pay natengeran yang kamatayen na. Atii kanay ipinadeep ni Gubirnadur Herodes ang pagkatapus pinapusasan nang ipinakalabus. Ya ray binuat na natetenged ilem tung ni Herodias ang kasawa na ang yay kinalaw na tung putul nang ti Felipe. ");
INSERT INTO tbk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ay pa ag̱ari, pirmi ilem ang mag̱aningen ni Juan yang Gubirnadur ang lampas da tung katuw̱ulan yang Dios ang magkakasawaan tanira ni ipag na. ");
INSERT INTO tbk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Numanyan maskin gustu rin yang Gubirnadur ang ti Juan ipaimatay na ra ilem, may pangamanan na tung mga tau ang muya mamagpundar ta gulu. Ay yang pagpabetang nira tung ni Juan sasang manigpalatay yang bitala yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Ug̱aring atiing kinaw̱ut da yang ipagsilibra ni Gubirnadur Herodes tung kakaldawan yang pagkapangana tung anya, yang ana ni Herodias ang darala nagtalek da tung katalungaan yang mga imbitasiun ni Gubirnadur. Kumus sinadyaan da ta durung ginanaan tung pagtalek yang darala, dayun dang nagpangaku tung anya ang pinaugtunan na pa ta panumpa ang maskin unu pay ingalukun na tung anya, siguradung ipapakdul na tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Numanyan kumus pinaetaran da ni nanay na kung unu pay ingalukun na, dayun dang nagbitala yang darala ang mag̱aning, “Maginuung Adi, pakdulay kanay yang kulu ni Juan ang manigbenyag. Taa ra ilem ipabtangay tung basyada,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pagkagngel yang Adi tia, pinungaw ra yang isip na. Piru kumus pinanumpaan na yang pangaku na tung katalungaan yang mga imbitasyun na, anday dumang binuat na, nagkalalangan da ilem ang ipakdul da tung darala yang iningaluk na. ");
INSERT INTO tbk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Purisu ti Juan pinatuw̱ulan na ra ilem tung sasang sundalung pinapug̱usan ta dikel na duun tung kalabus. ");
INSERT INTO tbk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pagkatapus ta pagpug̱us, yang kulu na ingkelan da duun tung daralang ipinakdul ang yag bebtang tung basyada. Pagkatapus ingkelan da yang darala tung ni nanay na. ");
INSERT INTO tbk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Numanyan pagkabalita yang mga namagpaugyat da rin tung ni Juan, dayun dang namansiangay duun tung kalabus ang ingkelan yang tinanguni nang ipinalg̱ud tung sasang leyang. Pagkatapus diritsyu rang namansiangay tung ni Jesus ang namagbaw̱alitaen. ");
INSERT INTO tbk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Numanyan atiing nabalitaan da ti Jesus, dayun dang nagliit tung banwang atia. Nagsaay tung balangay ang napaugbay duun tung banwang anday tatau na. Kasiraanami ra kang nag̱apangugyatan na ang yami yami ilem. Numanyan pagkabalita yang mga tau, dayun dang namagliliitan tung mga lansangan ang buntun dang namanikad tung ni Jesus ang ya ra ilem namagbakay. ");
INSERT INTO tbk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Numanyan pagkaw̱ut yamen na Jesus tung lugar ang atiing dinistinu yamen, tung paglampud na tung balangay, ya ray naita na yang mga taung atiang buntun da ang pamag̱elat tung anya. Pagkaita na tung nira, ya ra ngampayay ta kakaildawen nang duru tung nira ang pagkatapus yang may mga laru tung nira, ya ray pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Taa numanyan atiing alenget dang masantek yang kaldaw, yaming nag̱apangugyatan ni Jesus, nagpalengetami ra tung anyang mag̱aning, “Alang-alang da yang uras. Naawita ra tung banwang kapas. Maayen pa pampapanawen mu ra ilem yang mga taung atia tung mga baryung alenget taa ang para mamangalang da ta mapangan nira.” ");
INSERT INTO tbk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mag̱aning ka ti Jesus ang minles, “Anday ministir ang tanira mamagpanaw pa, kung indi, yamu ray magpapaan tung nira.” ");
INSERT INTO tbk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mag̱aning ka tanirang namansituw̱al, “Abee, anday mga balun ang nadipara yamen tung mga taung naa, kung indi, limang bilug ilem ang tinapay ang gereg̱esye may duruang bilug ang ian.” ");
INSERT INTO tbk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mag̱aning si ti Jesus tung yamen, “Ala, eklan mi ra kanay tani tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Numanyan dayun dang nagkalalangan ang yang mga taung atiang buntun mamansikarung da kanay asan tung kailamununan. Pagkatapus pagdawat na yang mga tinapay ang atiang limang bilug may yang mga ian ang atiang duruang bilug, dayun dang tuminingarang nagpasalamat tung Dios natetenged tung pamangan ang atia. Pagkatapus ta pagpasalamat na, dayun na rang pinagpingas-pingas yang mga tinapay ang atia ang pagkatapus ipinamakdul na tung yamen ang nag̱apangugyatan na ang yami si kay nanagtag-tagtag tung mga taung atiang buntun. ");
INSERT INTO tbk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Numanyan tanirang tanan nangapamangan da ang asta namampabial dang luw̱us. Pagkatapus atiing tuw̱urun da yamen yang mga eped nirang namamangan, sam puluk may durua pa nga baayan yang napnuk yamen. ");
INSERT INTO tbk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kung bilangen yang mga taung atiang namamangan, may limang liw̱u nga tauan, puira pa tung mga baw̱ay may tung mga mamula. ");
INSERT INTO tbk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Taa numanyan, atiang lag̱i, yaming nag̱apangugyatan ni Jesus, itinulmunami ra anyang magsaay tung balangay ang magtukawami tung anya duun tung tindak. Ay pampauliken na pa unu yang mga taung atiang buntun ang pampapanawen. ");
INSERT INTO tbk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Numanyan atiing pinampaulik na ra, dayun dang nanungul ta sam bilug duun tung bukid ang para mag̱arampuen da tung Dios. Atiing law̱ii ra yang kaliw̱utan, sam bilug pa ka enged duun. ");
INSERT INTO tbk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yang balangay ang pag̱asaayan yamen duun da tung alauran ang duru rang pagpaasung-asung na tung mga lakun ang darakulu ay sungsung yang palet. ");
INSERT INTO tbk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Numanyan atiing sam parti pa mangayag, ti Jesus baklu pa nanikad tung yamen ang ya ra ileg pagpanaw tung ulit yang aw̱uyuk. ");
INSERT INTO tbk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Maita yamen ang yag pagpanaw tung ulit yang aw̱uyuk, natarantaami ra ta mupia. Kumus dereeg̱enami ra yang eled yamen ang subra, nagkekendalenami rang nag̱araning-aningan ang, “Aruuy, uay, atia ra yang kalag!” ");
INSERT INTO tbk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Atii dirtsyuami rang lag̱ing pinag̱aning ni Jesus ang mag̱aning, “Paiseg̱en mi ra yang mga isip mi. Yuu ra taa. Indiamu ra mag̱eled.” ");
INSERT INTO tbk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Atii, ti Pedro dayun dang nabngang mag̱aning, “Ginuu, kung talagang yawa ra ka man tia, lalangay kanay ang mangay asan tung nuyung magpanaw ka tung ulit yang aw̱uyuk.” ");
INSERT INTO tbk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mag̱aning ka ti Jesus ang nagtimales, “Ala, tania!” Purisu paglampud ni Pedro tung balangay, nag̱impisa ra kang nagpanaw tung ulit yang aw̱uyuk ang para mangay ra rin tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ug̱aring pagkasinti na yang palet ang durug ketel, inleran da. Numanyan atiing nag̱impisa rang nag̱itagbeng, kuminendal da ang mag̱aning, “Ginuu, ilibriay ka!” ");
INSERT INTO tbk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Atii, lag̱i-lag̱ing dinawat ni Jesus ang pinggesan tung kalima nang inaning, “Abaa ungkuy, midyu pinaluw̱ayan mu ra yang pagtaralig̱en mu tung yeen. Ayw̱a pinapagdua-dua mu yang isip mu?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Numanyan pagkasaay nirang durua tung balangay, nag̱elteng da yang palet. ");
INSERT INTO tbk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yaming mga aruman nira tung balangay, dayunami rang nagluud tung pinagtaralungaan yamen na Jesus ang mag̱aning, “Yawa ka man yang pag̱aningen ang Ana Yang Dios!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Taa numanyan, dayun-dayun yang pagpalakted yamen ang asta duunami ra nasampet tung bakayan tung may kadatalan ang nag̱aguuyan tung Genesaret. ");
INSERT INTO tbk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pagkatapus ti Jesus nailala rang lag̱i yang mga lalii ang tag̱a duun ang pagkatapus ya si kay namanuw̱ul tung duma ang mamagbaw̱alitaen da tung mga tau tung intirung paliw̱ut yang banwa nirang atia ang ti Jesus asan da. Pagkatapus kumpurming tinu pay may mga laru ipinampadangep da yang mga aruman nira duun tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Numanyan namagpakiildaw ra tung anya ang kung maimu ilem ang maskin ya ra ilem yang mga mabiw̱ilug-bilug ang yag tataked tung sidsiren yang aw̱el nang langkuy ang ya ray madeenan yang mga aruman nirang may mga laru. Ang pagkatapus kumpurming tinu pay nagdeen, ya ray nagmaayen tung pag̱alaru na. ");
INSERT INTO tbk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tung pira pang kaldaw may mga Pariseo pati mga sag̱ad tung mga urdinansang pinanubli tung mga kinaampu ta ang ya ray namansiangay duun tung ni Jesus ang liit tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Pagkaw̱ut nira, dayun dang namag̱istinggir tung anyang mag̱aning, “Ayw̱a yang mga taung nag̱apangugyatan mung atia pamaglampas tung sasang riglamintung pinanubli ta tung mga kinaampu ta? Ay indi pamangug̱as yang mga kalima nira ta magkabag̱ay baklu mamangan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mag̱aning ti Jesus ang nagsulili, “Ayw̱a, yamu paglampasamu ka tung katuw̱ulan yang Dios basta mapagtumanamu ilem yang urdinansang pinanubli mi ka ilem tung mga kinaampu ta? ");
INSERT INTO tbk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ay kipurki may sasang katuw̱ulan yang Dios ang maning taa yang palaksu na. ‘Galangen mu ti tatay mu may ti nanay mu’. Dispuis may sugpat na pa ka ang mag̱aning, ‘Kung tinu pay magpalagpak ta mga bitalang malain tung ni tatay na u tung ni nanay na, dapat ang ipaimatay ra ilem’. ");
INSERT INTO tbk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Piru yang numyung nag̱ipatuman tung mga tau ay maning taa. Kung tinu pay masilag tung ni tatay na u tung ni nanay na ang ya ra panumpaay nang aningay, ‘Indi mi enged mapakinaw̱angan yang sinisirbianu ra rin ang naa tung numyu ay natetenged ipinag̱intrigaw ra tung Dios,’ yang taung atia indi mi ra ka enged lugtan ang manggalang pang mandul tiing sinisirbian na ra rin tung ginikanan na ay natetenged tung sinumpaan na. Purisu tung pagparatumanen mi tung mga tau tung pinanubli ming atia tung mga kinaampu ta, asan da nga tampekay mi yang bitala yang Dios ang asta anda ray kapulutan na. ");
INSERT INTO tbk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Abaa, yamung pagpakaayen-ayen ka ilem, temeng dang pisan tung numyu yang sasang bitala yang Dios ang ipinagpadapat ni Isaias ang tukaw ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Yang mga taung naa, yang paggaralangen nira tung yeen, tung tumbung ka ilem yang mga dilak nira, ig yang rumbu yang mga isip nira alawid ang pisan tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Anda enged ang pisan ay kapulutan na yang pagturuuen nirang maning tia tung yeen, ay natetenged yang nag̱ipatuman nira tung mga kaarumanan nira ang ya ra ag̱aningay nirang mga katuw̱ulanu buat, ya ra ka ilem yang mga riglamintung inimu-imu ta mga masigkapariu ka ilem nirang mga tau,’” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Numanyan ginuuyan ni Jesus yang mga taung atiang buntun ang mamagpalenget da tung anya ang pagkatapus inaning na rang, “Pamatian mi ra kanay ang intindien yang papintung naang ipagngelu tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Belag̱an ang mag̱aning ang yang magpapakled tung nganga yang sasang tau ang ya ray pagpamansa tung anyang indi ra magkabag̱ay tung pagterelengen yang Dios. Kung indi, yang maglulua tung nganga na yay pagpamansa tung anya,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Numanyan yaming nag̱apangugyatan ni Jesus, nagpalengetami ra tung anyang nagkig̱a ang, “Nag̱askean mu, Ameey, pagkagngel yang mga Pariseo yang inaning mung atia tung nira, ya ray pinaglainan yang mga isip nira tung nuyu.” ");
INSERT INTO tbk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mag̱aning ka ti Jesus ang nagtimales, “Yang mga Pariseong atia kung tung mga luak pa ipananglitayu, belag̱an ti Ama tung langit ang yay may luak tung nira. Purisu anday dumang buaten na tung nira, pamundukun na ra ilem. ");
INSERT INTO tbk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paw̱ayaan mi ra ilem tanira. Ay yang kaalimbawaan nira maning pa tung mga buray ang yang mga aruman nirang mga buray ka ya ray magtag̱aman nirang magmanguluan. Simpri yang sasang buray kung ya pay magguyud tung aruman nang buray, anday dumang pakaw̱utun na, parariu ka ilem tanirang mangabugsu tung lungasug,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ag̱aaning ka ti Pedrong nabnga, “Pasanag̱ayami ka kung unu pay gustung ianing yang papintu mung atia nungayna natetenged tung magpapakled may tung maglulua tung nganga yang sasang tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mag̱aning ka ti Jesus ang minles, “Abaw, pati yamung mga tauanamu pa ka man yeen, indiamu pa ka pala maskeng mag̱intindi? ");
INSERT INTO tbk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ayw̱a, indi mi pa ka enged nag̱aintindian ang kumpurming unu pay magpapakled tung nganga yang sasang tau, tung tian na ra ka ilem manganing ang pagkatapus itaki na ka ilem? ");
INSERT INTO tbk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piru yang kumpurming maglulua tung nganga na, duun nag̱aeyang tung sariling kinaisipan na ang pagkatapus ya ray pagpamansa tung sadili na ang indi ra magkabag̱ay tung pagterelengen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ay kipurki duun tung kinaisipan na nag̱aeyang yang pagtirimaen ang malalain ang ya ra kay maning pa tung panuw̱ul tung anyang mangimatay ra tung masigkatau na, ubin maglimbung da tung kasawa na, ubin mangumbaw̱ay ra ubin mangunlalii ra ubin manakaw ra, ubin manistigus da tung belag̱an kamatuuran, ubin magliw̱ak da tung aruman na. ");
INSERT INTO tbk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yang mga ubra-ubrang mga maning tia ya ray pagpamansa tung bilug ang pagkatau yang sasang tau ang indi ra magkabag̱ay tung pagterelengen yang Dios. Piru ang tanya mamangan ang anday ug̱as-ug̱as yang mga kalima na ang katulad ka tung nag̱apapaktelan nira, atia belag̱an ang yay telengan yang Dios tung anyang indi ra magkabag̱ay tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Taa numanyan ti Jesus nagliit da tung banwang atia ang minangay duun tung kakunayungan yang mga lansangan ang Tiro may Sidon kasiraanami ra kang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Simanyan may sasang baw̱ay ang tag̱a duun ang nagdangep da tung anya. Tanya belag̱an Israel, kung indi, yang mga kinaampu na dating tag̱a Canaan ang atiing tukaw ya pay aran yang banwang atia. Numanyan yang pagpalenget na tung ni Jesus, ya kay pagkekendalen nang mag̱aning tung anya, “Ameey, yawang manubli tung paggaraemen ni Adi David, ildaway ka. Ay yang anaung baw̱ay agdimunyuen ig nag̱aliwag̱an da ta mupia.” ");
INSERT INTO tbk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piru ti Jesus inding pisan nag̱iw̱ek-iw̱ek. Numanyan dayun dang pinalengtan yamen ang nag̱apangugyatan nang nag̱amu-amu tung anyang mag̱aning, “Abaw Ameey, ipapaaw̱ig mu ra ilem yang baw̱ay ang atia! Masyadu ra tiang ginla nang pagpagamu tung yaten,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mag̱aning ka ti Jesus ang minles ang yang baw̱ay ang atia ya kay nag̱apagngel na, “Yang itinuw̱ul yang Dios tung yeen ang taw̱angan ya ilem yang mga masigkanasyun tang mga Israel ang yang kaalimbawaan nira, maning pa tung mga karnirung nagkaratalang da,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Numanyan pagkagngel yang baw̱ay tia, dayun sing nagpalenget tung anyang nagluud tung pinagtalungaan nirang durua ang mag̱aning, “Aay ameey, ildaway kang taw̱angan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Numanyan tung itinuw̱al ni Jesus, yang mga Judio ya ra ipananglitay na tung mga mamula ang mag̱aning, “Indi ra magkabag̱ay ang yang pamangan yang mga mamula ya pa iplekay tung mga kiru.” ");
INSERT INTO tbk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mag̱aning ka yang baw̱ay ang nagtimales, “Kung tung bag̱ay, tama ka rin, Ameey. Piru maskin mga kiru ka man ilem, nag̱asibsib ka nganing yang mga mumu ang pagkarabugsu tung sirung yang lamisaan ang pamanganan yang mga ag̱alen nira.” ");
INSERT INTO tbk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mag̱aning ka ti Jesus ang minles, “Ay ipag, talagang durug dakul pala yang pagtalig mung atia tung yeen. Magkamaningana ra tung nag̱alelyag̱an mung atia,” mag̱aning. Numanyan tung uras kang lag̱ing atii nagmaayen da ka man yang ana nang baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Taa numanyan pagliit da ni Jesus duun tung banwang atii, dayun dang nagparanek duun tung aw̱uyuk ang atiang yag lulg̱ud tung sakep yang Galilea. Kumaw̱ut tung bakayan, dayun dang nagbakay ang pagkatapus nanungul da tung sasang bukid ang kuminarung. ");
INSERT INTO tbk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pagkatapus may mga taung buntun da ang namagpalenget duun tung anya ang may ekel nirang mga taung barik, mga buray, mga pilay, mga apa, may dakele pang may mga laru ka nirang duma. Pagkatapus ipinandangep da nira tung ni Jesus ang ipinamtang tung katalungaan na. Numanyan tanirang tanan luw̱us dang pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yang pinakaw̱ut na, durung pagkabereng yang mga taung atiang buntun tung pagkaita nira tung mga apa ra rin ang simanyan pangabitala ra, pati mga pilay ra rin ang simanyan pangapanaw ra ta matandes, pati mga barik da rin ang simanyan nangaulikan da, asta mga buray ra rin ang simanyan pangaita ra. Purisu durung pagdarayawen nira tung Dios ang ya kang lag̱i ay pag̱atuuan yang nasyun nirang Israel. ");
INSERT INTO tbk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Taa simanyan yaming nag̱apangugyatan ni Jesus dayunami rang ginuuyan nang magpalenget da tung anya ang pagkatapus inaningami anya ang “Abaa, yuu ra nag̱aildaw tung mga taung naang buntun. Teed mi, pangyaklu rang kaldaw taa tung yaten numaan ang pagkatapus nangalubsan da ta mga balun nira. Indiaw ka malelyag ang pampaulikenu tanira mintras indi pa pangapamangan ay muya pampaklag̱an pa ta suw̱uk tung dalan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mag̱aningami kang nagtimales, “Maskin mag̱aninga, ariita pa w̱asu mangkel ta bastanting pamangan ang mapapaan ta tung kinadaramelen nirang atia ang taawita pa ka man tung banwang naang kapas?” ");
INSERT INTO tbk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mag̱aning ti Jesus ang nagtalimaan tung nira, “Ayw̱a, pira pang bilug ang tinapay ang ekel mi asan?” Ag̱aaning ka tanira, “Ay pa taa? Pitu ra ilem ang bilug may pira pa ka ilem ang bilug ang mga ian ang gereg̱esye,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Purisu numanyan nagkalalangan da ti Jesus tung mga taung atiang buntun ang mamansikarung da kanay asan tung tanek. ");
INSERT INTO tbk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pagkatapus dayun na rang dinawat yang mga tinapay ang atiang pitung bilug may yang mga ian ang atia ang ya ray pinasalamatan na tung Dios. Pagkatapus dayun na rang pinagpingas-pingas ang ipinamakdul-pakdul tung yamen ang nag̱apangugyatan na ang ya si kay ipinamparawat-dawat yamen tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pagkatapus numanyan tanirang tanan nangapamangan da ang asta namampabial da. Pagkatapus atiing eepen da yamen yang mga eped nirang namamangan, pitu pa nga begyasan yang napnuk yamen. ");
INSERT INTO tbk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kung bilangen yang mga taung atiang namamangan, nagdangat da tung mga epat ang liw̱u nga tauan, puira pa tung mga baw̱ay may mga mamula. ");
INSERT INTO tbk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Numanyan pinampapanaw ra ni Jesus yang mga taung atiang buntun ang para mamag̱urulikan da. Pagkatapus dayun dang nagsaay tung balangay ang nagpatindak duun tung banwang sinakepan yang Magadan, kasiraanami ra kang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Taa numanyan may mga Pariseong namagpalenget da tung ni Jesus, kasiraan da ka tanira yang mga Saduseo. Kumus gustu nirang mamagtag̱am ta pagtuung tung anya, namag̱ingaluk da tung anya ang paitaan na rang lag̱i ta pruibang maktel ang para ya ray magpailala tung anya ang talagang may kagaeman na ka man ang liit tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mag̱aning ti Jesus ang nagtimales, “Kung masantek da nganing yang kaldaw tung sag̱iid ig maita mi ra ka nganing yang langit ang panipula rang paliw̱ut, mag̱aningamu kang andamal matinlung timpu. ");
INSERT INTO tbk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Utru si kung mandiklat da nganing yang sag̱iid ang manipula ra ka yang langit ig magalem, mag̱aningamu kang kumuran. Matakuamu nganing ang magpamalad tung nag̱aita mi tung kalangitan, piru indiamu pala maskeng magpamalad tung mga pruibang pagkarainabu numanyan ang ya ra kay pagpailala kung unu pang panimpuay ta simanyan. ");
INSERT INTO tbk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abaa yang mga taung naang mga masigkanasyunu simanyan. Durug kalain! Rusaw ra yang gegma nira tung Dios! Purisu ya ray nag̱ipagsagyap nira ta pruiba baklu mamananged tung yeen. Piru anday dumang pruibang ipaita tung nira, kung indi, ya ra ilem yang magkaanggid tung ipinagpaita yang Dios ang tukaw atiing pagkainabu tung ni Jonas,” ag̱aaning. Numanyan pagkaaning ni Jesus tia, dayun na ra ilem ang binutwanan yang mga taung atiang nagliit, kasiraanami ra kang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Taa numanyan pagkatindak yamen na Jesus, naa pala yaming nag̱apangugyatan na, nalipatami rang napagbalun ta mga tinapay. ");
INSERT INTO tbk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Numanyan mag̱aning ti Jesus tung yamen, “Kuidaw, amanan mi ta mupia yang pampaleskag ang nag̱agamit yang mga Pariseo may yang mga Saduseo.” ");
INSERT INTO tbk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pagkagngel yamen tia, dayun dang pinagkeresenan yamen ta maluw̱ay ang mag̱aning, “Siguru napagbitala ra ta maning tia ay pasaplid na ra tung yaten ay indiita ra ka man napagbalun ta mga tinapay.” ");
INSERT INTO tbk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Numanyan pagkasiman ni Jesus kung unu pay nag̱apagkeresen-kesenan yamen, dayunami rang tinalimaan nang inaning, “Ayw̱a ya ray nag̱apagkeresen-kesenan mi ang anday ekel ming balun ang tinapay? Midyu pinaluw̱ayan mi ra yang pagtaralig̱en mi tung yeen natetenged tung mga kaministiran ta. ");
INSERT INTO tbk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ayw̱a, indiamu pa ka enged nag̱aintindi? Indi mi ra pala nag̱ademdeman ang atiing may lima ilem ang bilug ang tinapay ang ipinampapaanu tung limang liw̱u nga tauan kung pira pa nga baayan ang napnuk mi ta mga eped nira? ");
INSERT INTO tbk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pati atiing may pitu ilem ang bilug ang tinapay ang ipinampapaanu tung epat ang liw̱u nga tauan, nag̱alipatan mi ra ka kung pira pa nga begyasan ang napnuk mi ta mga eped nira? ");
INSERT INTO tbk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ayw̱a kaya ang indi mi pa ka enged nag̱aintindian ang belag̱an tinapay yang nag̱adapatan yang inaningung atia tung numyu?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Atii, baklu ra nga maresmesay yamen ang naa pala, yang pampaleskag ang atiang sinambit ni Jesus belag̱an yang pampaleskag ta tinapay, kung indi, ipinananglit na ra ilem tung nag̱itulduk yang mga Pariseo may yang mga Saduseo ang puirting tumagmak tung mga painu-inu yang mga taung pagpatulduk tung nira. Pariu tung pagtagmak yang pampaleskag tung sang masang arina. ");
INSERT INTO tbk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Taa numanyan minangayami ra na Jesus duun tung sinakepan yang lansangan ang nag̱aguuyan tung Cesarea Felipe. Numanyan tinalimaanami ra anyang inaning, “Elat kanay, ang yuung pag̱aningen ang Maninga Tau kung pagkeresen-kesenanaw ta mga tau, unu pay pagpabetang nira tung yeen?” ");
INSERT INTO tbk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mag̱aningaming kang nagtimales, “Mag̱aning yang duma ang yawa unu ti Juan ang manigbenyag ang nabui si kang uman. Yang duma pag̱aning ka ang yawa unu ti Elias. Yang pintu yang duma ang yawa unu ti Jeremias ubin yang duma pang manigpalatay yang bitala yang Dios atiing tukaw ang ya si kay nabuing uman.” ");
INSERT INTO tbk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mag̱aning ti Jesus ang nanalimaan si tung yamen, “Ay ta numyu, unu pay numyung pagpabetang tung yeen?” ");
INSERT INTO tbk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Numanyan ti Simon ang yay pinapuanggaan da kang lag̱i ni Ginuung Jesus tung ni Pedro, ya ray nagtuw̱al ang mag̱aning, “Yawa yang pag̱aningen ang Cristo, bilang yang pag̱aningen ang Ana Yang Dios ang Makagag̱aem!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mag̱aning ka ti Jesus ang minles, “Simon, ana ni Jonas, teed mu tiag katinlu yang ipinagpabunayag yang Dios tung nuyu! Ay kipurki yang sinambit mung atia, belag̱an tau yang nagpaintindi tung nuyu, kung indi, mismu yang Amaw duun tung langit, ya ray nagpabunayag tung isip mu natetenged tung pagkabetangu kung yuu tinu pa. ");
INSERT INTO tbk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Purisu ta yeen, nani ra yang gustuu rang ianing tung nuyu. Yawa, Pedro yang kinaulug̱an yang puangga mung atia, sasang batu ig tung batung naa ipakdengayu yang maning pa tung sasang balay ang dakulu ang ya ray kaalimbawaan yang intirung kabilug̱an yang kumpurming magtalig tung yeen ang magpagaem. Maskin kamatayen pa, anday puirsa nang magdeeg tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Piarana yeen ta katengdanan mung magmangulu tung mga taung kumpurming magpagaem ang bug̱us tung Dios. Kung unu pay bawalen mu tung nira taa tung katanekan, bawal ka duun tung langit. Kung unu pay ilug̱ut mu tung nira taa tung katanekan, lug̱ut ka duun tung langit.” ");
INSERT INTO tbk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pagkatapus ni Jesus yang pagpasanag nang atia tung ni Pedro, dayun dang nagpaseben tung yamen ang tanan ang nag̱apangugyatan nang mag̱aning, “Kuidaw! Indiamu ra kanay magbaw̱alitaen maskin tung ninu pa ang yuu yang pag̱aningen ang Cristo,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Taa numanyan, ya ray ipinag̱impisa ni Jesus ang nagpasanag ta mupia tung yamen ang nag̱apangugyatan na kung unu pay dapat ang panawan na tung uri. Mag̱aning tung yamen, “Yang nag̱aingaluk yang Dios tung yeen ang yuu dapat mangayaw ka enged duun tung Jerusalem. Kung duunaw ra nganing, papinitinsiaanaw ra ta mupia yang mga pamagpakigmaepet may yang mga paring arabubwat ta katengdanan pati yang mga sag̱ad, ang pagkatapus ipaimatayaw ra ka dayun nira. Piru maskin pang maning tia yang dapat ang mapasaranu, tung pagkaw̱ut yang yaklung kaldaw, pabungkarasenaw ra ka enged yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Numanyan pagkagngel ni Pedro tia, dayun na rang ingkelan ti Jesus ang ipinabinit ang pagkatapus pinag̱intraan na ra sambeng ang inaning, “Aay Ginuu, india ra ilem magbiw̱italaen ta maning tia. Paalawid da ilem yang lain tung tinanguni mu ang asta tung sampa ildawana yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Atii dayun dang nagbedleng ti Jesus ang nanalunga tung anyang mag̱aning, “Paaw̱ig̱a ra taa! Yawa ra pala ay pagsatanas tung yeen! Naa pala, nag̱atag̱amanaw ra nuyung patalangen tung pinagplanu yang Dios tung yeen. Kipurki tung pagsambeng mung atia tung yeen, belag̱an yang nag̱aisipan yang Dios yang nag̱usuyun mu, kung indi, ya ka ilem yang isip ta tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Atii dayun dang nagbitala ti Jesus tung yamen ang nag̱apangugyatan nang mag̱aning, “Kung tinu pay nag̱alelyag dang magpaugyat tung yeen, yang sadili na ya ra lipatay na. Yang isip na ya ag̱ipatentenay nang mag̱agwanta tung mga pinitinsia, maskin ilansang pa tung krus. Dapat maning tia yay ipabalay na tung isip na kung gustu nang magpaugyat tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ay kipurki kung tinu pay nag̱alelyag ang yang sadili na ilibri na tung malain, asan da nga kapa-kapaay na yang kaampiran na tung yeen. Piru kung tinu pay mamirdi tung sadiling kalelyag̱an na natetenged ilem tung yeen ang yuu ray nag̱ipalusu na ta gegma na, asan da nga siguruay na yang kaampiran na tung yeen ang yay pagnatisan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ay kipurki unu pa pay ikaayen yang sasang tau ang yang tanan ang nag̱alelyag̱an na taa tung kaliw̱utan ang naa luw̱us dang mag̱apakinaw̱angan na ang pagkatapus asan da nga plekay ta ultimung pagpangabuing magnatis ang asta tung sampa? Anda ra enged ang pisan! Unu pa pay sarang ang mabailu na ang para bawien na pa rin yang ultimung pagpangabuing atiang naplek tung anya? Anda ra enged ay maimu na! ");
INSERT INTO tbk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Agpaamanenamu ra yeen ta maning tia ay natetenged ta yuung pag̱aningen ang Maninga Tau, siguradung magbalikaw ang ya ray uras ang ipagbalesu tung sasa may sasa ang kumpurmi ra ilem tung binuatan na. Ay yuu maggaraemenaw ra tung bilug ang kaliw̱utan ang yang kasusulawen ang pag̱atiniran kang lag̱i ni Ama ya ra kay tiniranu ig magkasira-siraanami ra ka yang mga angilu. ");
INSERT INTO tbk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iugtulu tung numyu yang kamatuuran. May duma asan tung numyu ang baklu magkarapatay, yuung pag̱aningen ang Maninga Tau, mabilug̱an da ka enged nira kung ya pa ag̱arig katinlu yang paggaraemenu,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Taa numanyan pagkataklib da yang enem ang kaldaw, ingkelan da ni Jesus ti Pedro may ti Santiagong duruang mag̱ari ni Juan ang namansitungul tung sasang bukid ang makbu ang tanira tanira ra ilem. ");
INSERT INTO tbk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Atiing duun da tanira, naglew̱ad da yang pagkabetang ni Jesus tung pinagtaralungaan nira. Yang ityura na nagsulaw ra ang midyu tung kasusulawen yang kaldaw, pati yang aw̱el na durung pisan agkakulit ig duru kang pisan agkasulaw. ");
INSERT INTO tbk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Numanyan asan da nansilput ti Moises durua ni Elias. Pamagkeresen tanira ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Numanyan nabnga ra ti Pedrong mag̱aning tung ni Jesus, “Ginuu, maayen ilem naawami ra ka. Kung gustu mu, magpakdengaw ra ta tulu nga layang-layangan, salegsang bilug mi ni Moises may ni Elias,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Numanyan atiing indi pa ag̱atapus ti Pedro ta pagbitala, may sasang panganud ang durug sulaw ang telengan ang ya ray nagpaulung tung nirang tanan. May nagngel da nirang busis ang asan manliit tung panganud ang mag̱aning ang pagbitala, “Uay, atia ra yang pag̱aningenung anaw ang nag̱apabuyukanu ta gegmaw ay ya ra kang lag̱i ay nag̱auyunanu ta mupia. Intindien mi ra ta maayen yang kumpurming ianing na tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Numanyan pagkagngel yang mga aruman yamen ang atia yang busis ang atia, ya ra mamansipadagpa tung tanek ang mamagtuu ay pinandelaan da ta mupia. ");
INSERT INTO tbk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Atii dayun dang pinalengtan tanira ni Jesus ang pinandeenan ta kalima nang inaning, “Ala, kemdengamu ra asan. Indiamu ra magpadla,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Numanyan tingaraen nira, anday dumang naita nira, kung indi, ti Jesus da ilem ang sam bilug. ");
INSERT INTO tbk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Numanyan atiing pamandanek da tanira tung bukid, pinag̱urdinan da tanira ni Jesus ta mupia ang pinag̱aning, “Indiamu ra kanay magbaw̱alitaen maskin tung ninu pa natetenged tung ipinagpaitang atia tung numyu ang asta kaw̱utun da ilem yang uras ang yuung pag̱aningen ang Maninga Tau pabungkarasenaw ra yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Purisu simanyan ya ray ipinagtalimaan nira tung ni Jesus ang mag̱aning, “Ay kung maning tii yang mainabu tung nuyu, ayw̱a kaya nag̱itulduk yang mga sag̱ad ang ti Elias ang atiang baklu ka ilem naita ta dapat unu tukaw ang magbalik baklu lumua yang pag̱aningen ang Cristo?” ");
INSERT INTO tbk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mag̱aning ka ti Jesus ang tuminuw̱al, “Kung tung bag̱ay, tama ka man yang nag̱itulduk nira ang yang pag̱aningen ang Cristo matkawan ni Elias ang lumua ang pagkatapus yay magpaiwan-iwan ug̱ud simpan da yang mga taung mamampauyun tung pag̱uri tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ang pagkatapus iugtulu tung numyu yang kamatuuran, kuminaw̱ut da ka man ti Elias, piru indi ra inilala yang mga tau, kung indi, binuatan da ilem nira yang kumpurming nalelyag̱an nira. Maning ka man tia yang buaten nira tung yeen ang pag̱aningen ang Maninga Tau ang yuu papinitinsiaanaw ka nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Atii baklu ra nga maresmesay nira ang belag̱an pala ti Elias mismu yang nag̱adapatan yang nag̱ianing nang atia tung nira, kung indi, ya ra ti Juan ang manigbenyag ang yay nanubli tung katengdanan ni Elias. ");
INSERT INTO tbk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Taa numanyan pandanek da nira tung bukid, kinaw̱utan da nira yang mga taung buntun. Pagkatapus may sasang taung nagpalenget tung ni Jesus ang ya ra nga luud tung pinagtalungaan nirang durua. ");
INSERT INTO tbk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Mag̱aning tung anya, “Ameey, ildawan mu ka yang anaung lalii. Tanya may laru nang kere. Kung kaw̱utun da nganing, ag̱aliwag̱an da ta mupia. Kung kaisan magtutumba ra ilem tung apuy, ang kaisan tung wai ra ilem numba. ");
INSERT INTO tbk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Idinangepu ra rin nganing tung mga taung nag̱apangugyatan mu, piru indi ra ka ilem nasarangan nirang napamaayen.” ");
INSERT INTO tbk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mag̱aning ti Jesus ang nagtimales ang tung nira kang tanan iparumbuay na yang bitala nang mag̱aning, “Uu, yamung mga tauamung mga masigkanasyunu simanyan! Ay ra yang pagtalig mi? Duru pa ka enged agkabaliskad yang laksu yang pag̱irisipen mi. Midyu tung maglakgasenaw ra tung numyu kung sanuamu ra kaya ngaeyangay ta ipagtalig ming ustu tung yeen. Ayw̱a, kaministiran ang mag̱agwantaw pa ta mabuay tung ug̱ali ming maning tia? Ala, eklan mi ra tani tung yeen yang mula,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pagkaw̱ut na tung anya, dayun na rang linalangan yang dimunyung lumayas da asan ang pagkatapus luminayas da ka man. Purisu tung uras ang atii, lag̱i-lag̱ing nagmaayen da yang mula. ");
INSERT INTO tbk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Numanyan yaming pagpaugyat tung ni Jesus, nagpalengetami ra tung anya ang yami yami ilem. Dayunami rang nagtalimaan tung anyang mag̱aning, “Natetenged tung unu pa w̱asu indiami nasarang ang napagpalayas tung dimunyung atia?” ");
INSERT INTO tbk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Mag̱aning ti Jesus ang nagtuw̱al, “Ay natetenged tung pagtalig ming may pagkakulang na! Kipurki iugtulu tung numyu, kung nag̱aeyanganamu ra rin ta ipagtalig ming maskin mag̱amustasa ilem agkadakul, kayanan mi ra ka rin yang midyu may kaliwag̱an nang buaten. Anda ka rin ay indi mi masarangan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Taa numanyan atiing pagsaragpunami ra duun tung banwang atiang Galilea, mag̱aning ti Jesus tung yamen ang mga nag̱apangugyatan na, “Yuung pag̱aningen ang Maninga Tau, indi ilem buay, iintrigaw ra tung pudir yang mga taung ya ra ka man ay mamagpaimatay tung yeen. Piru tung yaklung kaldaw, pabungkarasenaw ra yang Dios,” mag̱aning. Numanyan pagkagngel da yamen tia, pinamungawami ra ta duru. ");
INSERT INTO tbk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Taa numanyan, pagkaw̱ut nira na Jesus duun tung Capernaum, may mga manigkulikta ang ya ray namagpalenget tung ni Pedro. Yang kuartang magkuliktaen nira yay nag̱agamit kung unu pay mga kakulangan tung pagtuuan ang pinakalusu duun tung Jerusalem. Mag̱aning tanira tung ni Pedro, “Elat kanay, yang ag̱alen mi pagbayad ka yang nag̱ipabayad tung takun-takun para tung pagtuuan tang pinakalusu?” ");
INSERT INTO tbk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mag̱aning ka ti Pedrong minles, “Simpri.” Numanyan pagkaw̱ut ni Pedro tung balay, indi pa nganing nag̱ianing na yang bag̱ay ang atia, tingkawan da ni Jesus ang inaning, “Ta, Simon, tung pag̱intindi mu, tinu pay nag̱apampasukutan yang mga adi ta sidula ubin ta dumang balayaran tung mga inadian nira? Yang may mga kaampiran tung nira u yang dumang mga tau?” ");
INSERT INTO tbk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ag̱aaning ti Pedrong nagtuw̱al, “Simpri yang dumang mga tau.” Mag̱aning si ti Jesus ang suminugpat, “Ig disir kung maning tii, belag̱an ubligadung mamagbayad pa yang may mga kaampiran tung nira. Pariu ka tung yaten ang may mga kaampiran tung Dios. Anda ra ka rin ay ministir ang magbayarita pa yang nag̱ipabayad para tung pagtuuan ang atiang pinakalusu ang ya enged ay pag̱aistaran na. ");
INSERT INTO tbk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ug̱aring ilem kumus anday gustu ta ang yang mga manigkuliktang atia may paglainan ta mga isip nira tung yaten, maayen pang mandaneka ra kanay asan tung aw̱uyuk ang magbila. Yang primirung ian ang maniw̱ak, kung mabatak mu ra nganing, ya ray bengaken mu yang nganga na. Asan da maita mu yang sasang nigal ang magkatama ilem ang pisan ang ibayad tung nag̱ipabayad ang atia tung yaten ang durua nga tauan. Ya ray eklan mung ibayad tung mga manigkuliktang atia,” mag̱aning duun tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Numanyan tung pira pang kaldaw, yaming nag̱apangugyatan ni Jesus, nagpalengetami ra tung anyang nagtalimaan ang mag̱aning, “Ameey, tinu pay pinakalandaw tung tanan ang mga taung lug̱ud tung palaksu yang paggaraemen yang Dios?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Numanyan anday dumang binuat ni Jesus, nagguuy ra tung sasang mula ang ya ray pinakdeng na tung pinagtaralungaan yamen ang tanan. ");
INSERT INTO tbk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Pagkatapus dayun dang nagbitala tung yamen ang mag̱aning, “Iugtulu tung numyu yang kamatuuran, kung indi mi umanen yang mga isip mi ang para magpakbungamu ra tung mga mamulang mapinagparanek, tay puis, indi mi ra enged maispirinsiaan tung mga sadili mi kung unu pay palaksu yang paggaraemen yang Dios tung pagpangabui mi. ");
INSERT INTO tbk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Purisu kung tinu pay magparanek tung sadili nang magpakbung tung mulang naa, asan da ta taung telengan yang Dios ang yay sasang landaw tung tanan ang pamagpagaem tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dispuis pa kung tinu pay magparanek tung sadili nang magsapet tung maskin tinu pa ang aranek tung pagteleng na, maskin sasang mulang maning ilem taa, katimbang nang yuu kay nag̱asapet na ay nag̱usuyun na yang sasang nag̱auyunanu. ");
INSERT INTO tbk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Piru kanugun yang pagkabetang yang sasang tau tung uri ang kumpurming magpatalang tung sasang pagtalig da tung yeen ang asta magpakasalak da ubin mamalpas da tung yeen, maskin sam bilug ilem tung mga mamulang naa. Ay kipurki mas malbat yang kalainan ang maagmaan na kay tung buntug̱an da ilem duun tung alauran. ");
INSERT INTO tbk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kanugun yang mga tau taa tung kaliw̱utan ang naa ay kipurki durung makanayan ta ipagpakasalak nira. Kung tung bag̱ay, indi kang lag̱i malikayan tia, piru kung tinu pang tauay ang matengeran ta ipagbuat yang duma ta maning tia, kanugun yang pagkabetang na tung uri ay mas pang maglebat yang sintinsiang talungaen na. ");
INSERT INTO tbk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dispuis pa, kung midyu may sasang buaten mi ang yang kalima ubin kakay mi yay gamiten ming magpakasalak, sibaya mapungkulanamu ra asan ta panguntiel mi tung tuksu, tung magpanunut, indiamu ra enged. Maayen pang pungkulamung magpasapen tung Dios kay tung duruay kalima mi ubin duruay kakay mi ang duunamu ra ka ilem iplekay tung apuy ang anda enged ang pisan ay kapugdaw-pugdawan na ang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pariu ka kung gamiten mi yang mga mata ming magpakasalak, sibaya maluat da asan tung panguntiel mi, tung magpanunut, indiamu ra enged. Maayen pang sam bilug da ilem yang mata ming magpasapenamu ra tung Dios kay tung duruay mata ming duunamu ra ka ilem iplekay tung impirnu ang yang apuy na anda enged ang pisan ay kapugdaw-pugdawan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Mag̱amlig̱amu ka ang indiamu magtag̱am ta lamku tung mas aranek tung numyu, maskin tung sasa ilem ang mulang maning taa. Kipurki iugtulu tung numyu, maski nganing tanira may mga angil ka duun tung langit ang nag̱apanuw̱ul yang Dios ang mag̱asikasu tung nira. Pirming pag̱irintindian tanira ni Ama duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ta, unu pa tung pag̱intindi mi? Unu pa w̱asu ay buaten yang sasang taung may kaayepan nang sang gatus nga karniruan ang pagkatapus may sam bilug ang natalang da? Simpri butwanan na ra kanay yang siam ang puluk may siam tung pangaraw̱an nira duun tung kabukiran ug̱ud sagyapen na atiing sam bilug ang nalsik da. ");
INSERT INTO tbk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pagkatapus kung maita na ra nganing, iugtulu tung numyu, mas pang magkasadya yang isip na natetenged tung karniru nang atiang nasagyapan na kay tung siam ang puluk may siam ang indi nagkaratalang. ");
INSERT INTO tbk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Maning kang pisan tia tung Ama mi duun tung langit. Anda enged ay gustu na ang tung tanan ang mga tumatalig tung yeen ang may mablag tung anyang asta tung sampa may sam bilug, maskin aranek ta pagkabetang ang katulad ka tung mga mamulang maning taa ilem. ");
INSERT INTO tbk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Dispuis pa, kung may sasang putul ming tumatalig ka tung yeen ang ya ray nagbuat ta kasalanan tung sam bilug tung numyu, yawang binuatan, angayan mu ra kanay ang pakigkesenan ta matinlu natetenged tung binuat na tung nuyu ang yamu yamu ilem ang durua. Kung mamati tung nuyu, asan da mag̱inulikay si yang pagputulan ming durua tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piru kung indi mamati tung nuyu, mag̱imbitara ra tung sasang aruman mu kang tumatalig ubin durua ug̱ud kasiraanamu rang magbalik tung anyang magpaiwan-iwan. Ay tung maning tia, maskin unu pay mapagkeresenan mi, makumpurmian da ta durua ubin tulu nga sistigusan ang katulad ka tung nasambit tung kasulatan. ");
INSERT INTO tbk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Piru kung indi pa ka enged mamati, ipakaw̱ut mi ra ilem tung kadaklan ang mga kaputulan ming sam pundaan ang para mamagsaragpun da kanay ang para tanirang tanan mamagtaraw̱ang ta kunsiu tung anyang mangamin da. Ang pagkatapus ang maskin pa tung intirung sam pundaan indi pa ka enged mamati, indi mi ra ilem sapten, kung indi, ipabetang mi ra ilem ang belag̱an dang putul mi tung yeen ang magkapariu ka tung sasang tag̱a dumang nasyun ang indi kang lag̱i pag̱intindi tung Dios ubin sasang mandarayang manigpanukut ang anday gustu nang magsug̱at. ");
INSERT INTO tbk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iugtulu tung numyu yang kamatuuran, kung tinu pay indi mi patawaren tani tung katanekan, tukaw ra kang lag̱ing indi ra pinatawad yang Dios duun tung langit. Ig kung tinu pay patawaren mi tani tung katanekan, tukaw ra kang lag̱ing pinatawad da yang Dios duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Naa pa yang gustuung isugpat si tung numyung talagang matuud. Maskin duruaamu ilem ubin mas dakeleamu pa taa tung katanekan, kung magsaranyug̱amu rang magpataw̱ang tung ni Ama duun tung langit ang para paeyanganamu ra anya ta ipagsulw̱ad mi tung mga prublimang mga maning tiang nag̱aeyang tung grupu mi, talagang taw̱anganamu ra anya. ");
INSERT INTO tbk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kipurki maskin duruaamu ilem ubin subraamu pa tung durua, maskin sanuamu pang magsaragpun ang mga tauanu ug̱ud magpataw̱angamu ra tung ni Ama, asanaw ka pagpakigsasa tung numyu.” ");
INSERT INTO tbk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Numanyan ti Pedro ya ray nagpalenget tung ni Jesus ang nagtalimaan ang mag̱aning, “Ginuu, asta mapira pang patawarenu yang sasang putulung tumatalig ang nagbuat ta kasalanan tung yeen? Tama ra w̱asu ang asta mapitung bisis?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mag̱aning ka ti Jesus ang minles, “Iugtulu tung nuyu, belag̱an ilem pitung bisis, kung indi, asta tung pitung puluk uliten pa ka ta mapitung bisis. ");
INSERT INTO tbk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ag̱aningenamu ra yeen ta maning tia ay yang palaksu yang paggaraemen yang Dios tung mga tau ay maning taa tung ipananglitung naa. May sasang Adi. Yang Ading naa, naisip dang magrindikuinta tung mga turuw̱ulun na natetenged tung mga utang nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Numanyan atiing naimpisaan na ra ta pagrindikuinta, may sasang turuw̱ulun nang pinatawag̱an nang manalunga tung anya ay natetenged tung kinautangan nang kuminaw̱ut da tung pira-pira rang milyun. ");
INSERT INTO tbk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Numanyan kumus anday kuartang mabayad na, nagkalalangan da yang Adi ang tanirang sam pamilya ipaalang da ilem unu tung duma ang para buaten da ilem ang mga kirepen. Asta yang tanan ang mga ganadus na ipaalang da ka unu ang para yang kabayaran nang kuarta ya ray idata tung kinautangan na. ");
INSERT INTO tbk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Taa numanyan, pagkagngel yang turuw̱ulun yang kalalangan yang Adi ang maning da tii, dayun dang nagluud tung pinagtalungaan nirang durua ang nagpakiluuy tung anyang mag̱aning, ‘Ay Maginuung Adi, kung maimu ilem tung nuyu, pakdulay kanay ta palw̱ad ang para mabayaranu kang luw̱us tung nuyu,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Numanyan pagkagngel yang Adi, ya ra ngaildaw tung turuw̱ulun nang atia. Purisu pinatawad na ra ilem ang inimpas yang tanan ang nag̱ipagpabayad na ra rin tung anya. Pagkatapus dayun na ra kang pinalpasan ang pinapanaw. ");
INSERT INTO tbk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Taa numanyan pagkalua yang turuw̱ulun ang atia, may napanawan na rang sasang masigkaturuw̱ulun na ang may nautangan na ka tung anya ang indi nganing mangikuy-ikuy tung pinatawad yang Adi tung anya. Pagkaita na, dayun na rang pinggesan ang tinag̱aman na ra ta keg̱a ang mag̱aning, ‘Eey, yang utang mu, bayaran mu rang lag̱i numaan tung yeen,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Numanyan ya ra nga luud yang masigkaturuw̱ulun na tung pinagtalungaan nirang durua ang nagpakiluuy tung anyang mag̱aning, ‘Kung maimu ilem tung nuyu, ungkuy, pakdulay kanay ta palw̱ad ang para mabayaranu ka yang nautanganu tung nuyu,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piru yang sam bilug indi ra ka enged nalelyag, kung indi, ya ra ipakalabusay na yang aruman na ang asta mabayaran na yang utang na. ");
INSERT INTO tbk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Taa numanyan, maita yang mga masigkaturuw̱ulun na yang binuat nang atia, duru rang kaerep nira tung anya. Purisu dayun dang namansiangay tung Ading namagkig̱a. ");
INSERT INTO tbk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Purisu numanyan pinaguuyan si yang Adi yang turuw̱ulun nang atiang pinatawad na. Mag̱aning tung anya, ‘Yawa anda enged ay kakuinta-kuinta mung pagkaturuw̱ulun. Pinatawara ra nganing yeen tung tanan ang nag̱ipagpabayaru ra rin tung nuyu natetenged ilem tung pagpakiildaw mu tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Belag bang dapat da ka rin ang naildawa ra ka tung sasang masigkaturuw̱ulun mu ang katulad ka tung yeen ang naildawaw ka nganing tung nuyu?’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Numanyan kumus durung kasilag yang Adi tung turuw̱ulun nang atia, anday duma, ipinakalabus na ra ilem ang para duun da tigbakay ta mupia yang mga manigparusa ang asta mabayaran na ra kang luw̱us. ");
INSERT INTO tbk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Maning kang pisan tia yang buaten tung numyu ni Ama duun tung langit kung alimbawa indiamu ka magpatawad tung sasang putul ming tumatalig tung yeen ang tedek tung mga kinaisipan ming sasa may sasa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Numanyan atiing pagkatapus ni Jesus yang pagparasanag̱en nang atia tung yamen ang mga tauan na, dayun dang nagliit tung Galilea ang minangay duun tung sinakepan yang Judea ampir duun tung subang atiang paggug̱uuyan ang Jordan, kasiraanami ra kang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Duru-durung mga taung namagpakignunut tung anya. Kung tinu pay may mga laru tung nira, ya ray pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Taa numanyan may mga Pariseong namagpalenget da tung anya ay gustu nirang papagmintiraen ang para mabitala ilem ta magbalaw̱ag tung katuw̱ulan yang Dios. Purisu dayun dang namagtalimaan tung anyang mag̱aning, “Uyun basu tung mga katuw̱ulan ang nag̱ausuy ta ang yang sasang lalii puiding magpakiblag tung kasawa na, maskin unu ra ilem ang katadlenganay ang patielan na?” ");
INSERT INTO tbk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mag̱aning ka ti Jesus ang nagtimales, “Siguru nabasa mi ra ka yang sasang napabtang tung kasulatan ang atiing primirung pag̱imu yang Dios tung tau, inimu na unung lalii may baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dispuis may napabtang ka asan ang maning taa: ‘Purisu ya ra kay natengeran na ang yang sasang lalii magliit da tung ni tatay na may tung ni nanay na ay magpakiunung da tung ni kasawa na ang pagkatapus tanirang durua sa nga tinangunian da ilem,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ig disir, belag̱an dang durua pa kung indi sa nga tinangunian da ilem tanira. Purisu yang pinapagsasa ra yang Dios dapat ang indi belag̱en ta tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mag̱aning si yang mga Pariseong namagsulingaag tung anya, “Elat kanay, ayw̱a kaya may urdinansang ibinutwan ni Moises ang yang sasa unung lalii puidi unung magpakiblag tung kasawa na basta pakdulan na ra ilem unu ta bawdukumintu ang yay magpaingmatuud ang tapus da ka man yang pagkakasawaan nira?” ");
INSERT INTO tbk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mag̱aning si ti Jesus ang nagtimales, “Linugtanamu ra ilem ni Moises ang magpakiblag tung mga kasawa mi natetenged ilem tung kateteg̱asen yang mga kinaisipan mi, piru belag̱an enged maning tia yang intinsiun yang Dios atiing pag̱imu na tung primirung lalii may tung primirung baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Purisu iugtulu tung numyu, kung tinu pang laliiay ang magpakiblag tung kasawa na ang pagkatapus mangasawa sing uman tung dumang baw̱ay, asan da nga limbungay na yang kasawa nang dati, puira pa kung yang ipagpakiblag na tung kasawa na yang pagpaluku-luku na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Numanyan yaming nag̱apangugyatan ni Jesus, yami ray nabnga ang mag̱aning tung anya, “Tay kung maning da tii yang kapulutan yang pagkarasawaen, maayen pang indi ra ilem mangasawa yang sasang lalii.” ");
INSERT INTO tbk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Mag̱aning ka ti Jesus ang minles, “Kung tung bag̱ay, may mga lalii ka man ang indi mapag̱usuy tung intinsiun yang Dios ang lalii may baw̱ay magkakasawaan. Kipurki yang duma dispirinsiadu yang pagkabetang nirang mga lalii ang dengan tung pagkatau nira. Yang duma mga kirepen ang ya ra ag̱ipakapunay yang mga ag̱alen nira. May duma pa ang maskin puiding mangasawa, indi ra ka malelyag ay ipinalandaw ra enged nira yang pagpatuw̱ul nira tung Dios ang para mas pang magdakel yang mga taung magpagaem ang bug̱us tung Dios Piru yang kadaklan ang puiding mapag̱usuy tung intinsiun yang Dios ang atia, mag̱usuy ra,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pira pang kaldaw, may mga taung namag̱ekel tung mga ana nira tung ni Jesus ang para pampabisaen da nira tung anya. Piru sinambeng da yamen ang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pagkagngel ni Jesus tia, dayunami rang inampalar nang, “Eey, yang mga mamulang atia, paw̱ayaan mi ra ilem ang mamagpalenget da tani tung yeen. Indi mi ra enged pagsagangen, ay kipurki kung tinu pay may pagtalig nira tung Dios ang katulad ka tung pagtaralig̱en yang mga mamulang naang bug̱us tung mga ginikanan nira, lug̱ud da tung mga taung pamagpagaem ang bug̱us tung Dios.” ");
INSERT INTO tbk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pagkatapus dayun na rang pinampabisa na yang mga mamulang atia. Pagkatapus tia, dayun dang nagliit duun tung banwang atii. ");
INSERT INTO tbk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Taa numanyan may sasang kaldaw ang may sasang taung nagpalenget tung ni Jesus ang mag̱aning, “Ameey, kung maimu ilem, may gustuu rin ang talimaanen tung nuyu. Unu pa w̱asung ubraay ang matinlu ang dapat ang buatenu ug̱ud mapagpasapenaw tung Dios ang anday katapus-tapusan?” ");
INSERT INTO tbk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mag̱aning ka ti Jesus ang nagtimales, “Ayw̱at ministir pang yuu pay talimaanen mu kung unu pang ubraay ang matinlu ang yay dapat ang buaten mu? Ultimu ilem yang sam bilug ang magkabag̱ay ang aningen mung maayen. Tumanen mu yang mga katuw̱ulan na kung gustu mung magpasapen tung anya ang anday katapus-tapusan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Mag̱aning si yang sam bilug, “Ayw̱a, unu pang katuw̱ulanay ang dapat ang tumanenu?” Mag̱aning si ti Jesus ang minles, “Ya taang ulitenu. ‘India mangimatay ta masigkatau mu, india maglimbung tung kasawa mu, india manakaw ta belag̱an nuyu, india manistigus ta bukli tung katalungaan yang ustisia, galangen mu ti tatay mu may ti nanay mu ig gegmaan mu yang aruman mung tau ang katulad ka tung paggeregmaen mu tung sadili mu.’” ");
INSERT INTO tbk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mag̱aning ka yang kaw̱ataan ang atiang minles, “Yang tanan ang atia luw̱us dang nag̱ausuyu. Unu pa pa ka enged ay pagkakulang tung yeen ang dapat pang buatenu?” ");
INSERT INTO tbk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mag̱aning ka ti Jesus ang minles, “Kung yawa talagang gustu mung magpakumplitu, tay mulika ra kanay. Ipaalang mu ra yang tanan ang ganadus mu. Yang kabayaran nang kuarta ipamakdul-pakdul mu ra tung mga maliliwag̱en. Kung ya ray buaten mu tia, tay puis magkatinira ra ta kapakli nang maning pa ka tung manggad duun tung langit. Dispuis pagkatapus ta pamakdul-pakdul mu, magbalika ra tani ang magpakignunut tung yeen ang para ugyatana ra yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Numanyan pagkagngel yang kaw̱ataan yang itinuw̱al ni Jesus ang atia tung anya, dayun da ilem ang nagliit ang duru rag kapungaw yang isip na. Ay ya pa ag̱ari, durung kamanggaran na. ");
INSERT INTO tbk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Atii dayun dang nagbitala ti Jesus tung yamen ang nag̱apangugyatan nang mag̱aning, “Iugtulu tung numyu yang kamatuuran, durug liwag ang yang sasang manggaranen ang magpalamtuk yang pundu yang isip nang magpagaem ta bug̱us tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ulitenu pa ta minsa. Kung maliwag nganing ang yang sasang kamilyu pumuyuk tung buli yang tingway, mas pang maliwag ang yang sasang manggaranen magpalamtuk tung pundu yang isip nang magpagaem ta bug̱us tung Dios.” ");
INSERT INTO tbk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Numanyan pagkagngel da yamen ang yang inaning ni Jesus ang atia, durung pisan agkadakul yang pagkabereng yamen. Mag̱aningami tung anya, “Tay kung maning tii pala ang maski nganing yang mga manggaranen ang tag̱isip yamen ang alenget da tung Dios indi nganing matapnay, ya pa yang kadaklan ang mga tau?” ");
INSERT INTO tbk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Atii dayun dang naneleng-teleng ti Jesus tung nirang mag̱aning, “Kung tung tau ilem ka man, indi maimu tia. Piru kung tung Dios, maimu ra tia ay natetenged tung anya maimu yang tanan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Numanyan ti Pedro ya ray nabnga ang mag̱aning, “Teed mu, Ameey, ta yaming pagpaugyat tung nuyu, binutwanan da yamen yang tanan basta magpakignunutami ra ilem tung nuyu. Unu pa w̱asu ay ibles yang Dios tung yamen?” ");
INSERT INTO tbk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mag̱aning ti Jesus ang minles, “Iugtulu tung numyu yang kamatuuran, kung kaw̱utun da nganing yang kaliw̱utan ang baklu, yuung pag̱aningen ang Maninga Tau, kumarungaw ra tung puistuung maggaraemen ang durung pisan agkasulaw yang pagkabetangu. Tung uras ang atia, ta yamung sam puluk may durua ang nagpakignunut tung yeen taa tung kaliw̱utan ang naa, kumarungamu ra ka tung mga puistu ming maggaraemen tung sam puluk may duruang palaanaan yang nasyun tang Israel. ");
INSERT INTO tbk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dispuis kumpurming tinu pay namutwan tung sadiling pamalay-w̱alay na ubin tung sadiling tanek na, ubin tung mga putul na ubin tung ginikanan na, ubin tung mga ana na arangan da ilem tung gegma nang lusu tung yeen, ya ray pakdulan yang Dios ta kapakli yang tanan ang pinamutwanan nang atia ang pira-pira rang dubli ig tung uri mapagpasapen da tung anya ang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ug̱aring ilem naa w̱a yang dapat ang pangamanan mi. Durung pag̱atelengan ta abwat simanyan ang ya ra iparanekay tung uri ig duru kang pag̱atelengan ta aranek simanyan ang ya ra ka ipaabwatay tung uri,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mag̱aning ti Jesus ang nagsugpat, “Ag̱aningenamu ra yeen ta maning tia ay kipurki yang palaksu yang paggaraemen yang Dios tung mga tau, maning taa tung ipananglitung naa. May sasang taung may kaluakan na. May sasang kaldaw ang atiing timpranu pang pisan, nag̱angay ra duun tung palingki ang para mangaw̱ang da ta mga taung mamag̱ubra duun tung kaluakan na. ");
INSERT INTO tbk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Namag̱iritsuan da tanira ang yang suul nira kumpurmi yang kinaldaw ang kadagmitan ang nag̱isuul tung mga tau tung lugar ang atii. Pagkatapus pinanuw̱ul na rang mamag̱ubra ra duun tung kaluakan na. ");
INSERT INTO tbk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Numanyan atiing pag̱alas nuibi rang timpranu, nagbalik si duun tung palingki. May mga taung naita nang pamagkererengan da ka ilem asan ang pamag̱istambay. ");
INSERT INTO tbk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Purisu dayun na rang pinag̱aning ang, ‘Ala, pati yamu ag̱aw̱angenamu ra ka yeen ang mag̱ubra duun tung kaluakanu. Suulanamu ka yeen ta magkatama.’ ");
INSERT INTO tbk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Purisu dayun da ka man ang namag̱angay duun ang namag̱ubra. Numanyan atiing kereng da yang kaldaw, maning si ka tii yang binuat yang may kaluakan. Pati tung alas tris da yang apun, ya ka. ");
INSERT INTO tbk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Numanyan atiing pag̱alas singku ra yang apun, nagbalik sing uman duun tung palingki. May mga taung duma ang naita na si kang pamagkererengan da ka ilem asan. Purisu dayun na ra kang pinag̱aning ang ‘Eey, ayw̱a nag̱apunamu ra ka ilem taa ang anday ka pala ay nag̱aubra mi?’ ");
INSERT INTO tbk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mag̱aning ka tanirang namansituw̱al, ‘Ayw̱a naang anda kay nagpaubra tung yamen.’ Mag̱aning ka yang may tanek ang nagtimales, ‘Ala, pati yamu ag̱aw̱angenamu ra ka yeen ang mag̱ubra duun tung kaluakanu.’ ");
INSERT INTO tbk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Taa numanyan atiing apun dang pisan yang kaliw̱utan, mag̱aning yang may kaluakan tung kapatas na, ‘Ala, guuyan mu ra kanay yang mga ubrirus ang panuulan. Impisaan mu ra ta suul yang nangauring pisan ang pinangaw̱angu ang pagkatapus ipaluslus mu rang panuulan ang asta kaw̱utun mu yang nangatkaw ang pinangaw̱angu.’ ");
INSERT INTO tbk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Purisu simanyan yang kumpurming pinangaw̱ang tung alas singku, ya ray pinamakdulan da yang mga suul nira ang ya ray ipinatupu tung seled sang kaldaw yang ubra nira. ");
INSERT INTO tbk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Maning dang maning ang asta kinaw̱ut da yang nangatkaw ang pinangaw̱ang. Yang kalaum nira, mas abwat yang marisibi nira, piru yang ipinakdul tung nira ya ka ilem yang isinuul tung kadaklan ang ipinatupu tung seled sang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Numanyan pagkarisibi nira yang mga suul nira, dayun dang namagriklamuan tung may kaluakan ang mag̱aning, ‘Yang mga taung atiang nangauring pinangaw̱ang mu, sang uras da ka ilem yang ipinag̱ubra nira. Piru yami nagbew̱eek pa yang mga ulas yamen tung seled mag̱apun ang durung pisan agkakinit yang kaldaw ang pagkatapus ya ra ka ilem papagpariu-pariuay mu yang panuul mu tung yamen may tung nira?’ ");
INSERT INTO tbk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mag̱aning ka yang may kaluakan ang minles tung sam bilug tung nira, ‘Ungkuy, belag̱an kang malain yang pag̱abuatu tung nuyu. Tutal nagpauyuna ra ka ang yang suul mu kumpurmi yang kinaldaw ang kadagmitan ang nag̱isuul taa tung yaten. ");
INSERT INTO tbk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Purisu eklan mu ra ilem atiang suul mung mulik. Ay yang gustuu ang yang kumpurming nag̱isuulu tung nuyu ya kay nag̱isuulu tung taung naang nauring inaw̱angu. ");
INSERT INTO tbk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ayw̱a, anday ketelung magkalalangan natetenged tung kuartaw ang kumpurming unu pay nag̱alelyag̱anu? Muya yawa ra ilem mag̱aiw̱eg tung mga aruman mu.’” ");
INSERT INTO tbk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Numanyan dayun dang nagsugpat ti Jesus yang bitala nang mag̱aning, “May pag̱atelengan ta aranek simanyan ang ya ray ipaabwatay tung uri ig may pag̱atelengan ta abwat simanyan ang ya ra kay iparanekay tung uri,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Taa numanyan, ti Jesus sigi-sigi ra yang pagparanawen nang panungul duun tung Jerusalem, kasiraanami ra kang nag̱apangugyatan nang sam puluk may durua. Numanyan tung pagparanawen yamen tung karsada, ipinampaligbinami ra kanay anya ay may gustu nang iksen tung yamen ang yami yami ra ilem. ");
INSERT INTO tbk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Mag̱aning tung yamen, “Ta, naawita rag panungul ang panganing duun tung Jerusalem. Muya maberengamu tung ianingung naa tung numyu. Yuung pag̱aningen ang Maninga Tau, anday dumang mainabu tung yeen duun tung Jerusalem, kung indi, iintrigaw ra tung pudir yang mga paring arabubwat ta katengdanan may yang mga sag̱ad tung mga urdinansa, ang pagkatapus sintinsiaanaw ra nira ang ipaimatay. ");
INSERT INTO tbk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pagkatapus dayunaw si ka nirang iintriga tung pudir yang belag̱an mga masigkanasyun ta ang anda enged ay pag̱intindi nira tung Dios. Buatenaw ra ilem nirang sasang kayaman, pagkatapus paburdunanaw ka nira bakluaw ipalansangay nira tung krus. Piru pagkaw̱ut yang yaklung kaldaw, pabungkarasenaw ra ka enged yang Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Numanyan yang kasawa ni Zebedeo ya ray nagpalenget tung ni Jesus, kasiraan da ka tanira yang mga ana nang durua nga laliian. Pagpalenget nira, dayun dang nagluud yang nanay nira tung pinagtaralungaan nira ni Jesus ay may gustu nang ingalukun tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mag̱aning ti Jesus tung anyang nagbugnu, “Unu pay gustu mu, Ineey?” Mag̱aning ka yang nanay nirang nagtimales, “Kung maimu ilem tung nuyu, pangakuay ka ang kung maggaraemena ra nganing, yang mga anaung naang durua pakarungun mu ka tung tepad mung magtimbang.” ");
INSERT INTO tbk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mag̱aning ka ti Jesus ang nagtimales ang asan da iparumbuay na tung duruang atiang magputul, “Indi mi ka ilem nag̱amaresmesan kung unu ra ilem ay nag̱aingaluk mi. Basu kayanan mi kang magpapinitinsia ang katulad ka tung dapat ang pasaranu?” Mag̱aning ka tanirang nansituw̱al, “Ee, kayanan ka yamen.” ");
INSERT INTO tbk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mag̱aning si ti Jesus tung nirang nagsugpat, “Mapasaran mi ra ka man yang mga pinitinsia ang katulad ka tung mapasaranu. Piru kung tinu pay makarung tung teparung magtimbang tung uri, belag yuuy may pudir ang maglug̱ut, kung indi, ya ray nag̱itig̱ana ni Ama tung kumpurming tinu pay pinilik nang kumarung,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Numanyan atiing nabalitaan da yamen ang mga kaarumanan nirang sam puluk, anday duma, nangimunami ra ta mupia tung mga aruman yamen ang atiang duruang magputul. ");
INSERT INTO tbk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Purisu yaming tanan, dayunami rang ginuuyan ni Jesus ang magpalenget tung anya. Mag̱aning tung yamen, “Nag̱askean mi ra ka ang tung kaliw̱utan ang naa yang pamangatengdanan tung mga tag̱a duma-rumang nasyun, yang katengdanan nira ya ag̱ipandeeg-deeg̱ay nira tung mga kinasakpan nira. Muya-muyang manuw̱ul tung mga sakep nira ang para ilalaen da nirang yay abwat tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piru tung numyu, indiaw malelyag ang yay usuyun mi yang sistima nirang atia, kung indi, kung tinu pay malelyag ang telengan ta abwat asan tung numyu, dapat ang yang pagpabetang na tung sadili na tanya sasa ka ilem ang turuw̱ulun ming mga kaarumanan na. ");
INSERT INTO tbk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Dispuis kung tinu pay malelyag ang magmangulu tung numyu, dapat ka ang yang pagpabetang na tung sadili na tanya sasa ka ilem ang kirepen mi. ");
INSERT INTO tbk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bilang magpakbungamu tung yeen ang pag̱aningen ang Maninga Tau. Ay yang katuyuanu, belag̱an ang mag̱aning ang para yuuy magpanuw̱ul tung mga taung magpasikasu, kung indi, ang para yuuy mag̱ing turuw̱ulun nirang mag̱arasikasuen tung nira, ang yang inangayu enged, magpatumbasaw yang linawaw ang para durung mga taung mapaluasu tung pagpakirepen nira tung kalelyag̱an nirang magpakasalak,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Taa numanyan, atiing magluluaami ra na Jesus tung lansangan ang Jerico, buntun ang pisan yang mga taung pamagpakignunut tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Numanyan may durua nga burayan ang kumarungan tung binit yang karsada. Pagkabalita nira ang ti Jesus magtataklib da asan, dayun dang namagkekendalen ang mag̱aning, “Ameey, kumus yawa ray manubli tung paggaraemen ni Adi David, ildawayami ka!” ");
INSERT INTO tbk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Piru ya ra ampalaray yang mga taung atiang buntun. Piru belag ya mamag̱ipes, kung indi, mas pang ya namagkekendalen ang namagkekendalen ang mag̱aning, “Ameey, yawang manubli ra tung paggaraemen ni Adi David, ildawayami ka!” ");
INSERT INTO tbk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Atii dayun dang nagtadeng ti Jesus ang guminuuy tung nirang mag̱aning, “Ta, unu pay gustu ming buatenu para tung numyu?” ");
INSERT INTO tbk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mag̱aning tanirang nansituw̱al, “Aay ameey, gustu rin yamen ang mabuskad da yang mga mata yamen.” ");
INSERT INTO tbk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Atii ya ra ngaildaw ti Jesus ang nagdeen tung mga mata nira. Pagkadeen na, atiang lag̱i nangaita si ka man. Pagkatapus dayun da kang namagpakignunut tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Taa numanyan atiing panungulami rang tanan tung bukid ang atiang durung ayung pag̱aningen ang olibo, ang yang distinu yamen duun tung siudad ang Jerusalem, may sasang baryung nag̱alengtan yamen ang paggug̱uuyan ang Betpage ang alenget-lenget da tung siudad ang Jerusalem. Numanyan atiing nag̱alengetami ra tung baryung atia, nanuw̱ul da ti Jesus tung mga aruman yamen ang durua nga tauan ang mag̱aning, “Ala, mangayamu ra kanay tung baryung naang tung tukawan ta. Kung kumaw̱utamu ra nganing asan, ya rang lag̱i ay mapanawan mi yang sasang asnung inaen ang yag kekedked ang asan ka tung tepad na yang sinday na. Pamadbaren mi ra kanay ang pangguyuran tani tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kung may magbugnu tung numyu, yamu ra ag̱aaning, ‘Kaministiran ni Ginuu ta!’ Magngel na ilem tia, ipampaguyud na ra ilem ang lag̱i tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Taa numanyan yang tanan ang mga bag̱ay ang atia nagkamaningan da ta maning tia ay ug̱ud asan da magkamatuud yang sasang ipinaula yang Dios tung sasang manigpalatay yang bitala nang tukaw ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Panganingen mi yang mga taung pamag̱istar tung Sion ang yang Adi nira panganing da asan tung nira. Durug kapinaurayen ay yang magsasaayan na sasang asnung sinday pa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kapurisu numanyan namagpanaw ra ka man yang mga aruman yamen ang atiang durua. Tinuman da nira yang itinuw̱ul ni Jesus tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pinangguyuran da ka man nira yang asnu may yang sinday na ang ya ray pinanapinan nira yang mga panlamig nira ang pagkatapus dayun da kang nagsaay ti Jesus tung sinday. ");
INSERT INTO tbk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Numanyan yang pagsaay na tung asnu, ya kay paggaralangen tung anya yang mga taung buntun dang pisan. Yang duma yang mga panlamig nira ya ray ipinameklad nira tung karsadang magpanawan yang asnu. Yang duma may mga paklang ang pinaglampang nira ang ya ra kay ipinameklad nira tung karsada. ");
INSERT INTO tbk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Numanyan yang mga taung atiang buntun ang pamagpakigluyug tung ni Jesus, yang duma nabtang tung tukawan na, yang duma tung uri na. Sigi-sigi ra ilem yang pagkekendalen nirang pamag̱araning-aningan ang “Salamat! Naa ra yang manubli tung paggaraemen ni Adi David! Pakaayenen da kang pirmi yang Dios naang pag̱atuw̱ul nang magpalua tung paggaraemen na! Salamat tung anya duun tung kaabwat-abwatan!” ");
INSERT INTO tbk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Numanyan pagpakled ni Jesus tung Jerusalem, namag̱irikbawan da yang mga tau ang namagtaralimaan-talimaanan ang mag̱aning, “Tinu pa kayang tauay tia?” ");
INSERT INTO tbk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Numanyan yang mga taung atiang buntun ang pamagpakigluyug da kang lag̱i tung ni Jesus, ya ray namansituw̱al ang mag̱aning, “Yang taung naa, ya ra ti Jesus mismu ang tag̱a Nazaret duun tung sinakepan yang Galilea. Tanya yang manigpalatay yang bitala yang Dios ang atiing naula nuntukaw ang magkaw̱ut,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Taa numanyan dayun dang nagpakled ti Jesus duun tung palayas yang pagtuuan yamen ang pinakalusu. Pagpakled na, dayun dang nagpalayas tung tanan ang mga manigpaalang ta mga garamiten tung pagparadasag̱en, pati yang tanan ang pamangalang tung nira nagkaraumid da ka ta palayas. Pati yang mga lamisaan ang atiang pinampabtangan ta mga kuartang nag̱ipagpabailu tung mga tau, pinamaliskad na, asta yang mga kakarungan yang mga manigpaalang ta mga kalapati, ya ka. ");
INSERT INTO tbk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mag̱aning tung nira, “May sasang bitala yang Dios ang napabtang tung kasulatan ang yang balay unung naang pag̱atiniran na, dapat unu ang yay pag̱ampuan yang mga tau tung anya. Piru ay pa w̱a? Ta numyu, pag̱abuat mi ra ilem ang kuinta leyang ang pantalukan ta mga tulisan ang taa ra mismu agpandayaay mi yang mga taung pamagtuu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Taa numanyan may mga buray pati mga barik ang ya ray namagpalenget tung ni Jesus duun tung palayas ang pagkatapus ya ray pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Numanyan may mga paring arabubwat ta katengdanan asan ang pamagpaniid, kasiraan da ka tanira yang mga sag̱ad. Pagkaita nira tung ni Jesus ang pagpalapus ta mga buat-buat ang mga maning tiang makabew̱ereng, nangaerepan da ta duru. Belag̱an ilem ya tiay nag̱aerepan nira, kung indi, pati yang nag̱ipagkendal yang mga mamula asan tung palayas ang pamansianing, “Taw̱angan da ta mupia yang Dios yang taung naa ang ya ray pinasubli na tung paggaraemen ni Adi David!” ");
INSERT INTO tbk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Purisu dayun dang namagriklamu tung ni Jesus ang mag̱aning, “Ayw̱a indi mu pagsambengen tia? Indi mu nag̱agngel yang nag̱ipagkendal nirang atia?” Mag̱aning ka ti Jesus ang minles, “Nag̱agngelu ka, piru yang gustuu ilem ang maintindian tung numyu kung nabasa mi ra ka yang sasang napabtang tung kasulatan ang maski nganing yang mga mamula unu nag̱apaeyangan ka unu yang Dios ta ipagdayaw nirang ustu tung anya, maskin yang geg̱esye pa unung pamanusu pa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Numanyan pagkaaning ni Jesus tia, dayun da ilem ang namutwan tung mga taung atia ang naglua tung siudad ang pagkatapus minangay ra duun tung Betania. Duun da ka ngaelek tung law̱iing atii. ");
INSERT INTO tbk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Numanyan pangayag ang timpranu, atiing pagbalik da ni Jesus duun tung siudad, ya ra nga suw̱uk. ");
INSERT INTO tbk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Duun tung binit yang karsada may naita nang sasang ayung pag̱aningen ang igus. Purisu ya ray pinalengtan na, piru naa pala andang pisan ay naita nang burak na, kung indi, purus ilem mga daun. Numanyan dayun na rang itinuluy tung malain yang ayung atiang inaning, “Maayen pa rin ang india ra ilem ang pisan mamurak ang uman!” Pagkatapus lag̱i-lag̱ing nanlumpayeng da ka man yang ayung atia. ");
INSERT INTO tbk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Numanyan pagkaita yamen kung unu pay nainabu tung ayung atia, naberengami ra ta mupia. Dayunami rang nagtalimaan tung anyang mag̱aning, “Ya pa ag̱aring nanlumpayeng dang lag̱i yang ayung atia?” ");
INSERT INTO tbk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mag̱aning ka ti Jesus ang minles, “Iugtulu tung numyu yang kamatuuran, kung magtalig̱amu ta ustu tung Dios ang anday dua-dua yang mga isip mi, mapagbuatamu ka ta magkapariu ka tung binuatung atia tung igus ang atia. Belag̱an da ilem maning tia ay masarangan mi, kung indi, maskin may sasang durug liwag tung pag̱intindi mi ang yay gustu ming ingalukun tung Dios, mainabu ka. ");
INSERT INTO tbk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Purisu maskin unu pang bag̱ayay ang ipag̱ampu mi tung Dios, basta nag̱atalig̱an mi ang yang nag̱aingaluk ming atia ipakdul na tung numyu, atia pakdulanamu ka man anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Taa numanyan, nagpadayun da ti Jesus yang pagparanawen nang nagbalik duun tung palayas yang pagtuuan ang atiang pinakalusu. Numanyan atiing pagturuldukun da tung mga tau duun, pinalengtan da yang mga paring atiang arabubwat ta katengdanan may yang mga pamagpakigmaepet tung banwa. Dayun da nirang inusisang inaning, “Eey, ay pa ngaeklay mu yang katengdanan ang yawa magbuat yang mga maning tia taa tung pagtuuan tang naa? Tinu pay naglug̱ut tung nuyu?” ");
INSERT INTO tbk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ag̱aaning ka ti Jesus ang nagtimales, “Elat kanay, kung mga sarang tung numyu, may sasa kang talimaanenu rin tung numyu. Kung matuw̱al mi, ay tuw̱alenamu ra ka yeen kung ay pa liit yang katengdananung pagbuat ta mga maning tia. ");
INSERT INTO tbk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Abir, ay pa w̱asu liit yang katengdanan ni Juan ang nagpamenyag tung mga tau? Tung Dios manliit u tung tau ka ilem?” Pagkagngel nira tia, dayun dang nag̱aralas-alasan ang mag̱aning, “Unu pa w̱asu ay maayen ang ituw̱al ta? Kung aningen ta ang tung Dios manliit yang katengdanan ni Juan, muya sulilienita si anyang talimaanen ang ayw̱at indiita ra nananged tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piru kung aningen ta ang tung tau ka ilem manliit yang katengdanan na, muya kung unu pay buaten tung yaten yang mga taung naang buntun, indi ta ka ilem maskean. Ay tanirang tanan pamag̱ingmatuud da ang ti dipuntu Juan talagang sasang tinuw̱ul yang Dios ang magpadapat yang bitala na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Purisu numanyan tinuw̱al da ilem nira ti Jesus ang, “Inay, indi ilem nag̱askean yamen.” Mag̱aning si ka ti Jesus ang nagtimales, “Tay kung maning tii, indiaw ra ka mag̱ugtul tung numyu kung ay pa liit yang katengdananung pagbuat ta mga maning tia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Taa numanyan, dayun sing sinugpatan ni Jesus yang bitala na tung mga mamaepet ang atia ang mag̱aning, “Pamatian mi ra kanay yang pananglit ang naang ipagngelu tung numyu kung maumpa tung pag̱intindi mi. May sasang taung duruay ana nang lalii. Numanyan minangay tung ana nang dakulu ang mag̱aning, ‘Duduy, mag̱ubraa ra numaan duun tung kaubasan ta.’ ");
INSERT INTO tbk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mag̱aning ka yang ana nang nagtimales, ‘Indiaw.’ Ang pagkatapus atiing nabuay-w̱uay ra, nag̱uman da yang isip nang minangay duun tung kaubasan ang nag̱ubra. ");
INSERT INTO tbk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Atiing pagkagngel ni tatay na yang tuw̱al yang ana nang atiang dakulu, dayun dang minangay tung ana nang sam bilug ang maning ka tii yang itinuw̱ul na tung anya. Mag̱aning yang ana nang nagtimales, ‘Ee, tatay.’ Ang pagkatapus indi ka minangay duun tung kaubasan. ");
INSERT INTO tbk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta, tinu pa w̱asu tung nirang durua ay nagtuman yang kalelyag̱an yang tatay nira?” Mag̱aning ka tanirang namansituw̱al, “Yang dakulu.” Mag̱aning ka ti Jesus ang minles, “Iugtulu tung numyu yang kamatuuran, yang duruang atiang mag̱ari, yang pisan yang kaalimbawaan mi yang mga manigpanukut asta mga baw̱ay ang malaway yang pangita nira. Ay tanirang nag̱alamku ming indi ra risibien yang Dios, yamu pay nag̱atkawan nirang papalg̱ud tung paggaraemen na. ");
INSERT INTO tbk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ayw̱a indi maaningu, ay kipurki atiing paglua ni Juan ang manigbenyag ang nagpasanag tung numyu kung unu pay nag̱auyunan yang Dios ang yay dapat ang buaten mi, indiamu ka nananged tung anya. Piru yang mga manigpanukut ang atia pati mga baw̱ay ang atiang manigpausar, ya pay namananged tung anyang namanligna tung mga kasalanan nira. Ang pagkatapus ag̱ad ya rag dawalay mi ang dakulu ka man yang pinag̱umanan nira, piru indi mi ra ka enged inuman yang mga isip mi ang para manangeramu ra ka rin tung ni Juan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Pamatian mi ra kanay yang sam bilug pang pananglit ang ipagngelu tung numyu. May sasang taung malapad yang tanek na ang ya ray pinagluakan na ta purus ubas. Pagkatapus pinaliw̱utan na yang kaubasan na ta mga batung tinarutug. Pagkatapus may yuntung binangbangan nang binuat ang lilikdan yang mga burak na ang may saralug̱an ka yang wai na. Pagkatapus nagpakdeng pa ta barantayan. Atiing matapus na ra yang tanan ang atia, ipinaagsa na ra yang kaubasan na tung mga tau. Pagkapiar na tung nira, dayun dang nagliit ang minangay duun tung dumang banwa. ");
INSERT INTO tbk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Numanyan pagkaw̱ut da yang kutitsya na, nagtuw̱ul da tung mga turuw̱ulun nang mamansiangay ra duun tung mga agsadur na ang para eklan da nira yang kaparti na tung patebas. ");
INSERT INTO tbk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Numanyan yang binuat yang mga agsadur na, pinagdeep da ilem nira yang mga turuw̱ulun nang atia. Yang sam bilug pinagtaraw̱angan da nira ta pamalu, yang sam bilug inimatay ra ilem nira, yang sam bilug pinagbatu ra ilem nirang asta napatay. ");
INSERT INTO tbk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Utru si pinaangayan si yang may prupidad tung mga turuw̱ulun nang duma ang mas pang dakele kay tung primiru, ang pagkatapus maning kang pisan tia yang binuat tung nira yang mga agsadur. ");
INSERT INTO tbk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Numanyan tung kauri-urian da, anday dumang tinuw̱ul nang mangay duun, yang ana na mismu. Mag̱aning tung sadili na, ‘Simpri galangen ka enged nira yang anaw.’ ");
INSERT INTO tbk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piru mabandaw ra yang mga agsadur ang ya ra yang ana yang may luak ang magkakaw̱ut da, dayun dang namagkeresen ang mag̱aning, ‘Naa pala taa rag panganing yang manubli tung kaubasan ang naa. Maayen pa, imatayen ta ra ilem ug̱ud yaten da yang surublien na ra rin ang naa!’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Purisu tung pagkaw̱ut na, dayun da ka man nirang dineep ang ginuyuran duun tung lua yang kaubasan ang inimatay. ");
INSERT INTO tbk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ta, kung kumaw̱ut da nganing yang may prupidad, unu pa w̱asu ay buaten na tung mga agsadur nang atia?” ");
INSERT INTO tbk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mag̱aning ka tanirang namansituw̱al, “Talagang pangimatayen na ra ilem yang mga taung atiang durug kalalain. Ang pagkatapus yang kaubasan na, ipaagsa na si tung duma ang ya ray mamagpakdul tung anya yang kaparti na ang kada kaw̱utun yang patebas,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mag̱aning ka ti Jesus ang nagsugpat, “Siguru nabasa mi ra ka yang sasang pananglit ang napabtang tung kasulatan ang may batu unung pinasag̱i ang ya ray pinangindian yang mga manigpakdeng yang balay ang anda unu ay kuinta na, ang pagkatapus ya pa ka enged unu ay nagluang pinakaimpurtanting batung panielan yang lebat yang intirung balay. Anda unu ay dumang nagbawing nagpabalik tung batung atiing pinangindian da nira, kung indi, mismu unu ti Yawi ang duun da unu agpaninluay ta mupia yang mga taung pamagpaniid. ");
INSERT INTO tbk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Purisu iugtulu tung numyu, ta yamung mga masigkanasyunung mga Judio, kumus pinakdulanamu ra yang Dios ta lugar ming magpalg̱ud da rin tung palaksu yang paggaraemen na tung pagpangabui mi, ang pagkatapus nagpakuindiamu ra ka enged, tay anday dumang buaten na, bawien na ra ilem tung numyu yang kaayenan ang atia. Pagkatapus pakdulan na ra ta lugar yang duma ang kuinta nasyun ka ang ya ray mangapagpalua ta nag̱auyunan na ang magkabag̱ay ka tung mga taung kumpurming pagpagaem tung anya.” ");
INSERT INTO tbk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Numanyan yang mga paring atiang arabubwat ta katengdanan may yang mga Pariseo, tung pagpamati nira tung mga pananglit ang atiang ipinagngel ni Jesus, nasiman da nira ang naa pala tanira ray nag̱apatemengan na. ");
INSERT INTO tbk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Purisu tinag̱aman da rin nirang ipadeep. Kasu ilem pamangaman tung mga taung atiang buntun ay natetenged yang pagpabetang nira tung ni Jesus, talagang pag̱atuw̱ul yang Dios ang magpalatay yang bitala na. ");
INSERT INTO tbk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Atii, nagbitala si ti Jesus ang duun si ipapanaway na tung sasang pananglit ang maning taa. “Yang palaksu yang paggaraemen yang Dios tung mga tau maning pa tung sasang kumbirang pinundar ta sasang adi para tung ana nang pangasawa. ");
INSERT INTO tbk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Numanyan nanuw̱ul da yang adi tung mga turuw̱ulun na ang panawag̱en da nira yang mga taung pinag̱imbitar na ra kang lag̱i ang para mamampasakep da tung kumbira na. Piru anda ray gustu nirang mamampasakep. ");
INSERT INTO tbk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Purisu numanyan nanuw̱ul si tung mga turuw̱ulun nang duma ang mag̱aning, ‘Balikan mi sing panganingen yang mga taung atiang pinag̱imbitaru ang simpan da yang mga palanganen. Ipinagpaimatayu ra nganing yang mga turuu pati mga sinday ang pinampatambeku. Purisu yang tanan ang bag̱ay, simpan dang mapakinaw̱angan nira. Purisu mamampasakep da ilem,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piru ya ra ilem mamamatuy-patuy. Namagpadayun da ka ilem tung nira-nirang nag̱intindien. Yang sam bilug ya ra ngangay duun tung kaluakan na, yang sam bilug duun da ilem nag̱intindi tung nigusyu na. ");
INSERT INTO tbk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yang duma ya ra deepay nira yang mga turuw̱ulun yang adi ang pinagtaraw̱angan nira ta palu ang asta nagkarapatay ra ilem. ");
INSERT INTO tbk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Numanyan pagkabalita yang adi, durung kasisilag̱en na. Anday dumang binuat na, nanuw̱ul da tung mga sundalu na ang pangimatayen da ilem nira yang mga inimbitasiun nang atia ang namangimatay tung mga turuw̱ulun na. Pati siudad nira itinuw̱ul na ka tung mga sundalu na ang ya ray palalaw̱an nira ta apuy ang sirukun. ");
INSERT INTO tbk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pagkatapus ginuuyan na si yang mga turuw̱ulun nang duma ang inaning, ‘Telengan mi, simpan da yang tanan ang bag̱ay tung kumbiraw, piru yang mga taung atiang pinag̱imbitaru, belag̱an bag̱ay pala ang irimbitaren. ");
INSERT INTO tbk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Purisu numanyan magluaamu ra tung mga karsadang pagtaripukpukan yang mga tau ang yang kumpurming magkarabag̱as mi ya ray pangimbitaren ming mamampasakep da tung kumbira,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Purisu dayun da ka man ang namansilua yang mga turuw̱ulun nang atia tung mga karsada. Yang kumpurming nagkarapanawan nirang mga tau, ya ray pinangimbitar nirang mamampasakep, maskin maraayen maskin malalain ta mga ug̱ali. Ya ray pinagsagpun-sagpun nirang pinangkelan duun tung may kumbira ang asta punuk dang pisan ta tau yang palasiu yang Adi ang pagkumbiraan. ");
INSERT INTO tbk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Numanyan nagpakled da yang adi ang para pangumustaen na ra yang mga imbitasiun na. Unaw̱is may naita nang sam bilug ang naa pala indi ra napagsuut ta aw̱el ang igsarakep tung kumbira. ");
INSERT INTO tbk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Purisu dayun na rang binugnu ang inaning, ‘Ungkuy, ba tia? Ayw̱a nagpalangaasa ra ka ilem ang nagpakled taa ang naa pala india ra ka nagsuut ta aw̱el ang igsarakep tung kumbira?’ Piru indi ra enged nag̱iw̱ek-iw̱ek yang taung atia. ");
INSERT INTO tbk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Numanyan diritsyu rang nagkalalangan yang adi tung mga turuw̱ulun na ang mag̱aning, ‘Ala, gapusun mi ra ilem yang taung atia tung kalima may kakay ang iplek tung lua duun tung makiklep. Duun da ipaugpuay mi tung mga taung pamagtarangiten ang pamagkaretket yang mga isi nirang pamagpapinitinsia,’ mag̱aning duun yang adi.” ");
INSERT INTO tbk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Numanyan pagkatapus yang pananglit ang atia, dayun dang sinugpatan ni Jesus yang bitala nang mag̱aning, “Ay ya pa ag̱ari, durung taung nag̱aimbitar yang Dios ang magpagaem ang bug̱us tung anya, piru malaka ka ilem yang nag̱apilik na,” ag̱aaning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Taa numanyan yang mga Pariseong naang pamagtimang mamagpadeep tung ni Jesus, namagpaag̱es da kanay ang namag̱urunta-untaan kung ya pa ag̱aring mapamintira nira ti Jesus tung panuw̱al na tung mga talimaan. ");
INSERT INTO tbk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Purisu yang binuat nira, yang mga taung nag̱apangugyatan nirang duma may yang mga partidu ni Adi Herodes ang duma, ya ray pinanuw̱ul nirang mamagpalenget tung ni Jesus ang para mamagtalimaan tung anya. Numanyan tung pagkaw̱ut nira tung anya, dayun da nirang pinagtag̱aman ta buladas ang inaning, “Ameey, nag̱akdekan da ka yamen ang yawa anday bukli, kung indi, pagturuldukuna yang kamatuuran natetenged tung kalelyag̱an yang Dios ang yay dapat ang tumanen ta mga tau. Dispuis tung pagparadapaten mu ta bitala tung nira, anday pinilikan, kung indi, pariu-pariu yang pagterelengen mu tung nira maskin unu pay pagkabetang nira. ");
INSERT INTO tbk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Purisu gustu ka rin ilem yamen ang makdekan kung unu pay pag̱intindi mu tung prublimang naa. Uyun basu tung katuw̱ulan yang Dios ang ta yaten ang mga Judio manggawarita pa yang nag̱ipagpagawad ni Adi Cesar tung yaten u kuntra? Ya gawaray ta u indi?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Numanyan kumus nag̱adeep dang lag̱i ni Jesus yang nag̱atima nirang atiang malain, dayun na rang tinuw̱al ang inaning, “Yamung pagpakaayen-ayen ilem, yang gustu mi tag̱amanaw ra numyung tuungun! ");
INSERT INTO tbk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Abir ipateleng mi ra kanay tung yeen yang nigal ang atiang sam bilug ang nag̱ipagpabayad yang gubirnu,” ag̱aaning. Purisu dayun da nirang ingkel ta kuartang nigal. ");
INSERT INTO tbk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pagkatapus dayun dang nagtalimaan ti Jesus tung nira ang mag̱aning, “Ninu pang ityuraay ang nabtang tung nigal ang naa? Ninu pang aranay ang namarka taa?” ");
INSERT INTO tbk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mag̱aning ka tanirang namagtuw̱al, “Ni Adi Cesar.” Mag̱aning ka ti Jesus ang nagtimales, “Yang kumpurming ipinasuad ni Adi Cesar tung pagkabetang na, ya iintrigaay ta tung anya, pati yang kumpurming ipinasuad yang Dios tung sadili na, ya ka, iintrigaay ta ka tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagkagngel da nira tia, durung pagkabereng nira. Purisu dayun da ka ilem ang namamutwan tung anyang namagliliitan da. ");
INSERT INTO tbk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tung kaldaw kang atii, may mga Saduseo ang ya si kay namagpalenget tung ni Jesus. Yang mga taung atia indi pamananged ang yang mga patay mabui si kang uman. ");
INSERT INTO tbk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Numanyan mag̱aning tanira tung anya, “Ameey, may sasang urdinansang ibinutwan ni Moises tung yaten ang yang sasa unung lalii kung mapatay ang anda pay ana na, yang putul na unu yay dapat ang ipulin tung ni ipag nang nabalu ug̱ud kung maana tung anya, mapabtang dang ana yang putul nang napatay. ");
INSERT INTO tbk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ipabetang ta may pitu nga laliian ang magpurutul. Yang pangulu nangasawa tung sasang baw̱ay ang pagkatapus napatay ang indi naana tung kasawa na. Pagkatapus yang putul nang duminasun tung anya ya ray ipinulin ang ipinakasawa tung ni ipag nang nabalu. ");
INSERT INTO tbk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Numanyan maning ka tia yang nainabu tung anya pati tung pangyaklu nira ang asta ra ilem tung nirang kadaklan ang magpurutul. ");
INSERT INTO tbk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pagkatapus tung kauri-urian da, pati yang baw̱ay napatay ra ka. ");
INSERT INTO tbk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta, kung matuud yang numyung atia ang yang mga patay mangabui si kang uman, abir, kung kaw̱utun da nganing yang uras ang atia, tung nirang pitung magpurutul, tinu pa w̱asu ay magnatis ang may kasawa tung baw̱ay ang atia, sindu parariung nangasawa-kasawa ra tung anya? Abir kung unu pay matuw̱al mu?” ");
INSERT INTO tbk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mag̱aning ka ti Jesus ang nagtuw̱al, “Ta, indi, asanamu rag pagkamali sigun ang indi mi ilem nag̱amaresmesan yang napabtang tung kasulatan pati yang kagaeman yang Dios kung unu pay masarangan na, ya ka, indi mi ka ilem nag̱amaresmesan. ");
INSERT INTO tbk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ayw̱a indiamu aningenu kipurki kung kaw̱utun da nganing yang uras ang yang mga patay pampabungkarasen da yang Dios, indi ra magkarasawaan ang uman, kung indi, mamanulad da tung mga angil duun tung langit ang indi kang lag̱i pagkarasawaan. ");
INSERT INTO tbk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Dispuis pa kung natetenged tung pagpabungkaras yang Dios tung mga patay tung uri ta kaldaw ang yay midyu maliwag ang panangden mi, ayw̱a, indi mi ra ka nabasa tung kasulatan yang sasang ipinaske yang Dios tung numyu ang tanya unu yang Dios ang may mga tauan tung na Abraham ni Isaac may ni Jacob? Yang Dios tanya anday mga tauan nang patay, kung indi, buing tanan. Pati nganing mga tinanguni nira, damayen na ra kang buien si kang uman tung uri,” ag̱aaning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Numanyan pagkagngel yang mga taung atiang buntun yang itinuw̱al ni Jesus ang atia, nangabereng da ta mupia tung palaksu yang pangatadlengan na. ");
INSERT INTO tbk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Numanyan yang mga Pariseong naa, pagkabalita nira ang yang mga Saduseo anday natuw̱al nira tung pangatadlengan ni Jesus, namagsaragpun sing namag̱urunta-untaan kung unu pay dumang rimidyung sarang mabuat nira ang para mapamintira nira ti Jesus tung panuw̱al na. ");
INSERT INTO tbk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Purisu simanyan may sam bilug tung nirang sag̱ad tung mga urdinansa ang ya si ay nagpalenget tung ni Jesus ay gustu nang talimaanen ang basi pa ra ilem ang matuung na. ");
INSERT INTO tbk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ag̱aaning tung anya, “Ameey, kung maimu ilem, may talimaanenu rin tung nuyu. Tung tanan ang mga katuw̱ulan yang Dios ang napabtang tung kasulatan, ay pay kalandawan na enged?” ");
INSERT INTO tbk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mag̱aning ti Jesus ang tuminuw̱al, “Yang pinakalandaw ya taa: ‘Pabuyukan mi ta gegma mi ti Yawi ang yay Dios ang may anya tung numyu. Yang paggeregmaen mi tung anya dapat ang tedek ang pisan tung mga kinaisipan mi ang indi ka magtenakan. Ya ra kay papruibaan mi tung tanan ang mga buat-buat mi.’ ");
INSERT INTO tbk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Atia yay katuw̱ulan ang pinakalandaw tung tanan. ");
INSERT INTO tbk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dispuis may sam bilug pang mag̱atu ka ang maning taa: ‘Gegmaan mi yang aruman mi ang katulad ka tung paggeregmaen mi tung sadili mi.’ ");
INSERT INTO tbk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Asan da maniel tung duruang atia yang kadaklan ang mga katuw̱ulan ang ibinutwan ni Moises tung yaten pati yang kadaklan kang ipinagpadapat yang mga manigpalatay yang bitala yang Dios ang tukaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Taa numanyan kumus indi pa pamagberelag yang mga Pariseong atia, ti Jesus tanya, ya si ay nagtalimaan tung nirang mag̱aning, “Unu pay pag̱intindi mi tung pag̱aningen ang Cristo? Ninu pang kanubliay tanya?” Mag̱aning tanirang namansituw̱al, “Tanya kanubli ni Adi David.” ");
INSERT INTO tbk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Mag̱aning ka ti Jesus ang nagtimales, “Ayw̱a kaya yay sinambit ni Adi David ang Ginuu na? Kipurki may sasang ipinaula yang Espiritu Santo tung anya ang maning taa yang napabtang tung kasulatan: ‘Yang Ginuuu pinag̱aning da ni Yawi ang kumarung da kanay unu tung tepad na tung tuu ang asta pamirdien na unu yang pamagkuntra tung anya ang asan da unu ipampabtangay na tung tarampakan yang kakay na.’ ");
INSERT INTO tbk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kung tanya sinambit nganing ni Adi David ang Ginuu na, ya pa ag̱aring magyaring kanubli na ka ilem? Unu pa w̱asu tung numyung pag̱intindi?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Atii andang pisan ay natuw̱al tung ni Jesus may san tag̱a. Purisu mag̱impisa tung kaldaw ang atii, anda ray napagpalangaas ang nagtalimaan pang uman tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagkatapus tia, dayun dang nag̱intra pasanag ti Jesus tung mga taung atiang buntun pati tung yamen ang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mag̱aning tung yamen, “Naang mga sag̱ad pati naang mga Pariseo, may katengdanan ka man nirang mamagbaradbaren yang mga katuw̱ulan yang Dios ang atiang ibinutwan ni Moises tung nasyun tang Israel. ");
INSERT INTO tbk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Purisu magkabag̱ay kang usuyun mi yang nag̱ipatuman nira tung numyu, basta magkatunu tung intinsiun yang Dios ang may mga katuw̱ulan. Piru yang mga sistima nira indi mi ilem suaren. Ay ya pa ag̱ari, maskin nag̱atuldukanamu nira kung ya pa ag̱ari yang pagturumanen mi yang mga katuw̱ulan ang atia, piru tanira mismu indi ka nganing pamagtuman. ");
INSERT INTO tbk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pamag̱iksir tung mga tau ang mamagtuman yang sari-saring mga urdinansa ang durug liwag ang tumanen ang pagkatapus, kung tung mga sarakanen pa, indi ka enged mamagtaw̱ang ta sakan, maskin tung madeen yang mga kalima nirang mamagduul. ");
INSERT INTO tbk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dispuis pa, maskin unu pay nag̱abuat nira, yang pag̱asikad enged nira ang tanira dayawen ta mga tau ang durug katinuuen tung Dios. Katulad da asan tung mga sag̱upit-sag̱upit ang atiang berebtangan yang mga katuw̱ulan ang nag̱itagkes nira tung mga kikilayen nira ubin tung mga brasu nira ang ya rag padarakulay nira ang para mas malpes ang maita ta mga tau. Pati yang mga mabiw̱ilug-bilug ang atiang nag̱itaked nira tung sidsiren yang mga aw̱el nirang atiang lagwas, ya ka, ya ra kag padarakulay nira. ");
INSERT INTO tbk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sasa ra ka tung ug̱ali nirang mamagpasakep tung mga punsiun. Yang kakarungan ang pinakamatinlu, ya ray piliken nira. Pariu ka ta laksu kung mamagsimba ra nganing tung mga pagsaragpunan. Yang piliken nirang karungan, ya ra yang nag̱itig̱ana tung darakulung mga taung mas abwat ta pagkabetang tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sasa ra ka tung ug̱ali nirang pamasyar tung plasa. Durung kalelyag nirang tingaraen ang saluduen ta mga taung aningen ang Rabbi. ");
INSERT INTO tbk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Piru ta yamung kumpurming mga tauanu, indiamu magsikad ang aningenamu pa ta mga taung Rabbi ang katulad ka tung pag̱asikad nira. Ay kipurki sam bilug ilem yang pagturuldukun tung numyu ig pariu-pariuamu ka ilem ta pagkabetang ang maning pa tung magpurutulamu. ");
INSERT INTO tbk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dispuis dapat ang anday tag̱a taa ka ilem tung katanekan ang ya ray tingaraen ming pinakaama mi ay kipurki sam bilug ilem yang nagyari rang Ama mi ang ya ra ka man yang duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dispuis pa, dapat ang indiamu ka magsikad ang aningenamu pa ta duma ang pagmangulu ang katulad ka tung pag̱asikad nira. Ay kipurki sam bilug ilem yang sarang magmangulu tung numyu. Anday duma yuu ra taang pag̱aningen ang Cristo. ");
INSERT INTO tbk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kung tinu pay pag̱atelengan ang landaw tung numyu, ya ray dapat ang manirbian tung numyung kadaklan ang maning pa tung sasang turuw̱ulun mi ka ilem. ");
INSERT INTO tbk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kumpurming tinu pay pagpaabwat tung sadili na, ya ag̱iparanekay yang Dios ig kung tinu pay pagparanek tung sadili na, ya ag̱ipalandaway na.” ");
INSERT INTO tbk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Aay, yamung mga sag̱ad pati mga Pariseo ang pagpakaayen-ayen ilem, kanugunamu ay kipurki ya ra ag̱ilipat-lipatay mi yang mga tau ang para indi ra nira matultulan kung ya pa ag̱aring magpalg̱ud tung palaksu yang paggaraemen yang Dios. Ay ya pa ag̱ari, ta yamu, indiamu ka enged malelyag ang magpagaem tung anya, pati tanirang pangalelyag da ka rin, ya ra kag papaenteray mi. ");
INSERT INTO tbk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aay, yamung mga sag̱ad pati mga Pariseong pagpakaayen-ayen ilem, kanugunamu ay kipurki ya rag salairay mi yang maskin ay pang banwaay ang basta may makumbinyu ming maglakted tung rilyun mi, maskin sa nga tauan da ilem. Ang pagkatapus kung magpakumbinyu ra nganing tung numyu, nag̱isalid mi yang mga ug̱ali mi tung nira ang asta mas pang magkabag̱ay ang manampet duun tung impirnu kay tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Talagang kanugunamu. Pagturuldukanenamu ka man tung mga tau piru yang kaalimbawaan mi maning pa tung sasang buray ang indi matultul ta dalan. Ay kipurki yang nag̱itulduk mi tung nira maning taa. Kung manumpa ra nganing tanira, basta yang sambiten nira ya ka ilem yang pagtuuan tang pinakalusu, maskin indi ra ubligaren nira. Piru kung yang sambiten nira ya ra yang mga garamiten ang atiang mga bulawan ang duun agbebtang tung kakleran yang pagtuuan tang atia yay mainambit nira, ay talagang ubligadu tanirang magtuman yang nabitalaan nira. ");
INSERT INTO tbk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Abaa yamu, yang kaalimbawaan mi belag̱an ilem ang maning pa tung mga burayamu, kung indi, pati yang laksu yang pag̱irisipen mi, baliskad ang pisan. Ayw̱a, kanisip mi ang mas sagradu yang mga garamiten ang atiang mga bulawan kay tung pagtuuan tang pinakalusu? Indi ka enged magkatama tia, kipurki sagradu ka man ilem nganing yang mga garamiten ang atia gated asan da ka man agbebtang tung pagtuuan ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Dispuis yang sam bilug pang nag̱itulduk mi tung mga tau ay kung manumpa ra nganing tanira, basta sumpaan nira yang nabitalaan nira tung midyu lamisaan ang atiang darasag̱an ta mga ayep ang magew̱a pa rin kung belag̱an matuud yang bitala nira, maskin indi ra nira matuurun yang nabitalaan nira. Piru kung sumpaan nira tung ayep ang asan da nag̱idasag̱ay, dapat kang tumanen nira yang nabitalaan nira. ");
INSERT INTO tbk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Abaa yang kaalimbawaan mi talagang maning pa tung mga burayamu ka man ang matuud. Ayw̱a kanisip mi ang mas sagradu yang ayep ang atiang nag̱idasag kay tung midyu lamisaan ang atiang darasag̱an tung anya? Indi ka enged magkatama tia, kipurki sagradu ka man ilem nganing yang ayep ang atiang nag̱idasag gated duun nag̱idasag̱ay tung midyu lamisaan ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kapurisu yang magkatama ang dapat din ang itulduk mi tung mga tau ay maning taa: yang sasang tau kung sumpaan na yang nabitalaan na tung midyu lamisaan ang atiang darasag̱an, belag̱an ilem asan magsumpaan na, kung indi pati tung ayep ang nag̱idasag asan, damay ra ka. ");
INSERT INTO tbk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pariu ka ta laksu kung sumpaan na yang nabitalaan na tung pagtuuan tang pinakalusu, belag̱an ilem tung pagtuuan ang atia magsumpaan na kung indi pati tung Dios ang asan agpagtinir, damay ra ka tung panumpa na. ");
INSERT INTO tbk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ya kay laksu na kung sumpaan na yang nabitalaan na tung langit. Yang nag̱asumpaan na ya ra mismu yang maning pa tung pagkarungan yang Dios. Ig disir, pati tanya mismung pagkarung asan, damay ra ka tung panumpa nang atia. ");
INSERT INTO tbk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ay yamung mga sag̱ad pati yamung mga Pariseo, midyu tung pagpakaayen-ayenamu ilem. Kanugun yang pagkabetang mi tung uri, ay kipurki maski nganing yang mga luak ming gereg̱esyeng pisan ang ya ilem ag̱ipasaburay mi tung mga sera mi, ya pay panepet-sepeten ming pamateng-patengen ta sam puluk ang parti ang para yang sam parti ya ray nag̱ibuluntad mi tung Dios. Ang pagkatapus yang nag̱ipatuman enged yang Dios tung numyu ang yamu ra rin ay magbuat ta magkatama tung mga masigkatau mi ig ang yamu ra rin ay mag̱ildaw tung nira ig ang yamu ra rin ay mag̱ing matalig̱an ang pisan yang mga aruman mi, ya pay nagbaliwalaen mi. Dapat da rin ang ya enged ay pabilug̱an ming tumanen atiang may mga timbang na ang indi mi ka paw̱ayaan yang pagparartien ming atia tung Dios ta yasampuluk ang parti. ");
INSERT INTO tbk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pagmaranguluenamu ka man tung mga tau, piru yang kaalimbawaan mi yamu talagang maning pa tung sasang buray ang indi matultul ta dalan. Ay tung pagpanepet-sepet ming atia maning pa tung nag̱asaraan mi yang mga uw̱ud-uw̱ud ang nag̱alaket tung igmen mi, ang pagkatapus yang maning pa tung mag̱akamilyug kadakul, ya ray nag̱iklen mi! ");
INSERT INTO tbk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ay yamung mga sag̱ad pati yamung mga Pariseo, midyu tung pagpakaayen-ayenamu ilem. Kanugun yang pagkabetang mi tung uri, ay kipurki duruamug kasinulipeten tung pagrilimpiuen mi tung mga tasa mi may tung mga pinggan mi sigun tung mga riglamintung atiang pinanubli mi tung mga kinaampu ta ang yang kanisip mi ya ray mauyunan yang Dios tung numyu. Piru yang pakled nirang mga pamangan ubin irinemen, duun da ilem ngaeklay mi tung pagpanlepes mi tung duma ang kuw̱ali panalensenamu. ");
INSERT INTO tbk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Abaa yamung mga Pariseo, talagang maning pa tung mga burayamu ka man ang matuud! Yang tukaw ang dapat limpiuen mi ya ra kanay yang nag̱abtang tung mga kinaisipan ming mga maning tia ug̱ud pati mga ubra-ubra mi asan da ka mag̱ing limpiu ka. ");
INSERT INTO tbk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ay yamung mga sag̱ad pati mga Pariseong pagpakaayen-ayen ilem, kanugun yang pagkabetang mi tung uri ay kipurki yang kaalimbawaan mi yamu maning pa tung mga pantiun ang pininturaan ta kulit. Matinlu ka man ang telengan tung sagpaw piru tung adalem punuk ang pisan ta mga duli ta mga tau ubin mga tinanguni nirang rusdak da. ");
INSERT INTO tbk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Maning kang pisan tia tung numyu. Tung sagpaw pag̱atelenganamu ta mga tau ang maraayenamu, piru tung adalem durug kaligna yang nag̱aeyang asan tung mga kinaisipan mi. Punuk ang pisan ta pagtirimaen mi ta mga malalain ang nunut da ka ta pagpakaayen-ayen ming masyadu. ");
INSERT INTO tbk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ay yamung mga sag̱ad pati mga Pariseong pagpakaayen-ayen ilem, talagang kanugunamu. Buat na pa durung pagmaal mi tung mga manigpadapat yang bitala yang Dios ang tukaw may tung mga kaarumanan ka nirang matinumanen tung nag̱auyunan yang Dios. Ay yang mga leyang ang atiang pinanlug̱uran tung nira nag̱apakdengan mi nganing ta matitinlung mga pantiun ig yang mga pantiun ang atia, ya kay nag̱apaisa-isaan mi ka ta mga dikurasiun. ");
INSERT INTO tbk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ag̱aningamu ka ang kung yamu natau rang lag̱i tung uras ang atiing bui pa yang mga kinaampu mi, indiamu ra ka rin nagpasanyug tung nira ang nagpangimatay tung mga manigpadapat ang atii. ");
INSERT INTO tbk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Purisu tung bitala ming atia ya ra kay pangamin mi ang talagang mga irinsiamu ka man yang namangimatay tung mga manigpadapat ang atii. ");
INSERT INTO tbk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ig disir bag̱ay ang pisan tung numyung magsug̱ut tung mga irinsia ming atia ang yamu ray magtapus yang naimpisaan nirang mga kinaampu mi. ");
INSERT INTO tbk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yang kaalimbawaan mi, yamu maning pa tung mga iraw ang durug katraidur! Kanisip mi malibrian mi pa yang sintinsia yang Dios ang duunamu ipaangayay na tung impirnu? ");
INSERT INTO tbk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Purisu ang para matuungamu tung nabitalaan ming atia, yang buatenu ta yeen, paangayanamu ra ka yeen tung mga tauanung mga manigpadapat yang bitalaw ang yay matakung magparasanag̱en tung mga tau. Ang pagkatapus anday dumang buaten mi tung nira, yang duma ya ipaimatayay ming ipalansangay tung krus, yang duma ya paburdunay mi duun mismu tung mga pagsaragpunan mi ang pagkatapus ya panrutus-rutusay mi tung maskin ay pang lansanganay ang pagpalibrian din nira. ");
INSERT INTO tbk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ya ray buatenu ug̱ud yamu enged ay matengeran yang kamatayen yang tanan ang mga taung atiing pinangimatay ang tukaw ang anday binuatan nirang malain, mag̱impisa pa tung ni Abel atiing primirung pisan ang asta ra ilem tung kauri-urian da ang tung ni Zacarias ang ana ni Baraquias ang yay inimatay tung pagtuuan ang pinakalusu. Duun pa ka man mismu imatayay tung pag̱elaan yang karakulan na may yang midyu lamisaan ang atiang darasag̱an ta mga ayep. ");
INSERT INTO tbk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iugtulu tung numyu yang kamatuuran, yamung mga masigkanasyunu numanyan tung panimpung naa, tung numyu enged dilemay yang kamatayen nirang tanan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Numanyan pinadayun ni Jesus yang nag̱abitala nang mag̱aning, “Ay yamung mga tag̱a taa tung siudad ang naang Jerusalem, kanugun yang pagkabetang mi tung uri. Kipurki kada paangayanamu yang Dios tung mga manigpalatay yang bitala na, ya ra ileg batuay ming imatayay. Pira-pira rang bisis ang gustuu rin ang managpun tung numyu ang katulad ka tung manung inayen ang pag̱ayupup tung mga butu na, piru indiamu ra ka enged nalelyag. ");
INSERT INTO tbk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Naa w̱a yang dapat ang isipen mi. Yang siudad ming naa ang tag̱isip mi indi maunu pa, paw̱ayaan da ilem yang Dios ang ilug̱ut tung kadiaduan. ");
INSERT INTO tbk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sanu pa indiamu aningenu ay kipurki iugtulu tung numyu, indi ra ilem buay, indiaw maita ming uman ang asta kaw̱utun da ilem yang uras ang ipag̱ilala mi ka enged tung yeen ang ustu ang nunut da ka ta pag̱ingaluk mi tung Dios ang yuung pag̱atuw̱ul nang mag̱erekelen yang kagaeman na, pakaayenenaw rang pirmi anya,” mag̱aning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Taa numanyan dayun dang luminua ti Jesus duun tung palayas yang pagtuuan ang atiang pinakalusu ang nagpanaw. Tung pagparanawen na, sinikad da yamen ang pinalengtan, ay gustu yamen ang ipasapet da tung anya yang plantar yang pagtuuan ang atia kung unu pag katinlu. ");
INSERT INTO tbk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mag̱aning ti Jesus ang nagtimales tung yamen, “Midyu agtinluanamu rang pagteleng tung tanan ang atia. Piru iugtulu tung numyu yang kamatuuran, may uras ang kaw̱utun ang magew̱a rang pisan yang tanan ang atia. Yang mga batung atiang darakulung pinasag̱i ang tinambi-tambi asan, anda rang pisan ay mabutwan pang magsarampaw-sampawan, kung indi, luw̱us dang magkarapanpan tung tanek,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Numanyan atiing pagkaw̱ut yamen duun tung tag̱aytay yang bukid ang atiang durung naluak ang ayung pag̱aningen ang olibo, dayun dang kuminarung ti Jesus. Pagkatapus tinaripukpukan da yamen ang nag̱apangugyatan na ang yami yami ra ilem. Mag̱aningami tung anya, “Ameey, pakdekayami ka kung sanu pa magkamaning da ta maning tia yang nainambit mu nungayna. Unu pang pruibaay ang sarang matandaan yamen ang yawa maglekat da taa ang ya ra kay ipagtapus yang Dios tung panimpung naa?” ");
INSERT INTO tbk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mag̱aning ka ti Jesus ang nagtuw̱al, “Mangamanamu ta mupia ang para indiamu madayaan ta dumang mapatalang. ");
INSERT INTO tbk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kipurki durung magluang mag̱ambu ang tanya unu ya ray yuung pag̱aningen ang Cristo ang pagkatapus durung taung magkaradayaan nira. ");
INSERT INTO tbk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dispuis tung uras ang atiang panalungaan may magngel ming gulu yang paggiriraan ig duun tung duma-rumang rugal may mga gira kang magkarabalitaan mi. Piru yang pangamanan mi asan ang indiamu ilem magpakataranta. Ay kipurki yang mga bag̱ay ang atia dapat ang magkarainabu, piru indiamu maglaum ang yang magdasun ya ra yang uras ang ipagtapus yang Dios tung panimpung naa. ");
INSERT INTO tbk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ag̱aningenamu yeen ta maning tia ay yang magkarainabu, nasyun may nasyun magsuruayan ang maggiriraan. Dispuis may magpanaw ang mga panuw̱uk tung duma-rumang banwa pati mga yegyeg ya ka. ");
INSERT INTO tbk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yang kaalimbawaan yang mga bag̱ay ang atia kung magkarainabu ra nganing, maning pa tung primirung pagpasiit-siit yang sasang baw̱ay ang paranganaen da. Yay dapat ang magtukaw baklu pa kaw̱utay yang baklung panimpu. ");
INSERT INTO tbk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Dispuis tung uras ang magkarainabu yang mga bag̱ay ang atia, muya-muyaamung ipadeep yang mga taung pamagkuntra tung numyu ang para iintrigaamu ra nira tung mga ustisiang paparusaan, ang asta yang duma tung numyu ipaimatay ra ilem nira. Dispuis demtanamu ka ta mga tau tung maski ariamu pang banwaay nga pangay, arangan da ilem tung yeen ang nag̱akegngan mi. ");
INSERT INTO tbk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tung uras ang atiang pumasar yang kaliwag̱an, durung mamalpas da tung yeen. Mismu yang mga aruman nirang mga tumatalig ka tung yeen, ya ray demtan nirang traidurun ang para iintriga ka nira tung mga ustisia. ");
INSERT INTO tbk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Duru kang magluang mga manig̱imu-imu ta bitala ang ya unu ay bitalang itinalig yang Dios tung nirang ipalatay buat. Ang pagkatapus durung magkaradayaan nirang papanangeren tung kabuklian nira. ");
INSERT INTO tbk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dispuis natetenged tung paglalampasen yang mga tau tung mga katuw̱ulan yang Dios ang subra ra tung uras ang atia, duru kang mga tauanu ang asan da manluw̱ay ang asta manlamig da yang gegma nira tung yeen pati yang gegma nira tung mga kaarumanan nira. ");
INSERT INTO tbk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piru kumpurming tinu pay tauanung magpatenten yang isip nang magpadayun ka enged tung pagtaralig̱en na tung yeen, maskin imatayen pa, ya ray tapnayen yang Dios ang ipalg̱ud tung kaliw̱utan ang baklu. ");
INSERT INTO tbk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dispuis pa, yang Matinlung Balitang naa natetenged tung paggaremen yang Dios ang baklu dapat ang ipagpakaw̱ut da tung bilug ang kaliw̱utan ug̱ud yang tanan ang mga tau, maskin unu pang nasyunay, mapaingmatuuran da. Atia kung masalaid da nganing yang bilug ang kaliw̱utan, baklu ra kaw̱utay yang uras ang ipagtapus yang Dios tung panimpung naa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Tung mga uras ang atiang nag̱ianingu, maita ming ya rag bebtang tung sagradung lugar yang sasang naula ni Daniel ang pagpadamang ang yay makalalaway ang pisan ta isip. (Yuung ti Mateong nagsulat, may yeen kang gesyeng isaleet ang para ipaetaru tung numyung mga manigbasa. Ipasanag mi tung mga taung pamamati kung unu pay linegdangan yang mga bitalang atia.) ");
INSERT INTO tbk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Purisu kung maita mi ra nganing tia, kumpurming tinu pay pagtinir taa tung sinakepan yang Judea, kaministiran magpalaksu rang lag̱i duun tung kabukiran. ");
INSERT INTO tbk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kung tinu pay kaw̱utan yang uras ang atia ang duun dag kakarung tung sagpaw yang balay nang pagpalimasmas, kaministiran ang indi na ra kanugunun yang mga ekel-ekel na duun tung kakleran ang maning paranekan na pang eklan, kung indi, diritsyu ra ilem ang magparanek ang magpalaksu. ");
INSERT INTO tbk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya ka yang taung duun da kaw̱utay tung kaluakan na, indi na ra ka balikan yang panlamig na duun tung balay na. ");
INSERT INTO tbk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kanugun yang pagkabetang yang mga matung may yang mga talaana tung uras ang atia. ");
INSERT INTO tbk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mag̱ampuamu tung Dios ang indi matuun tung abag̱at yang ipagpalaksu mi ubin tung kaldaw ang nag̱ipamaenay. ");
INSERT INTO tbk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ag̱aningenamu yeen ta maning tia ay natetenged tung uras ang atia durung pisan aglebat yang kaliwag̱an ang kumaw̱ut. Disti pa tung katebtew̱an ang atiing pag̱imu yang Dios tung kaliw̱utan ang asta ra ilem simanyan, indi pa nag̱apasaran yang kaliw̱utan ta maning tiag lebat. Maskin pa tung uras ang panalungaan, anda ray magdeeg tii. ");
INSERT INTO tbk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kung indi nganing padiputun yang Dios yang timpung atia, ya rang ya rang maspuk da rin yang mga tau. Piru alang-alang da ilem tung mga taung pinagpilik na kang lag̱ing mga tauan na, ya ra kay ipagpadiput na. ");
INSERT INTO tbk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tung mga uras ang atia, kung aningenamu ta mga tau ang, ‘Uay, nani ra yang pag̱aningen ang Cristo!’ ubin aningenamu nirang, ‘Uay atii ra!’, indiamu enged mananged. ");
INSERT INTO tbk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nag̱apaamanamu yeen ta maning tia ay tung mga uras ang atia may mamaglua rang mga tau ang ya ray mamag̱ambu ang tanira unu ya ray yuung pag̱aningen ang Cristo. May dumang mamaglua kang mga manig̱imu-imu ta bitala ang ya unu ay bitalang itinuw̱ul yang Dios tung nirang ipalatay buat. May mga pruiba nganing ang maktel ang durug kabew̱ereng ang ipalapus nira ug̱ud pati mga taung pinagpilik yang Dios ang mag̱ing mga tauan na, tag̱aman da ka nirang dayaan kanung kayanan pa ka nira. ");
INSERT INTO tbk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Papatandaan mi ta mupia yang inaningung atia tung numyu, ay pinakdekamu rang lag̱i yeen baklu magkarainabu. ");
INSERT INTO tbk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Purisu kung aningenamu ta mga tau ang ‘Aliamu ra, yang pag̱aningen ang Cristo duun da tung banwang kapas!’, indiamu enged mag̱angay duun. Ya ka, kung aningenamu ta duma ang ‘Aliamu, takaa ra tung kakleran pantaluk!’, indiamu ka enged mananged. ");
INSERT INTO tbk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kipurki ta yuung pag̱aningen ang Maninga Tau, kung maglekataw ra nganing, maintindian da tung bilug ang kaliw̱utan. Ay yang kaalimbawaan na maning pa tung kidlat ang kung suminggat da nganing, bistu rang pisan tung duw̱ali magduw̱aling langit. ");
INSERT INTO tbk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Basta maglekataw ra, indi mataluk tia. Magkapariu ra tung nag̱ipananglit yang mga mamaepet ang kung ay pa unu may ayep ang patay indi unu mataluk ay natetenged duun ka unu pamaglanget ang pamagpatipay-tipay yang mga lamlam ang atiang pamamangan ta ayep ang patay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Tung uras ang atiang panalungaan, kung mataklib da nganing yang kaliwag̱an ang atiang durug lebat, maning taa yang magkarainabu ang katulad ka tung napabtang tung kasulatan: ‘Yang kaldaw mangiklep da, pati yang bulan indi ra ka manadlaw. Asta yang mga dumakel duun tung langit magkarataktak da. Bilang yang tanan ang bag̱ay tung kalangitan pampawaldangen da yang Dios tung dating pagkarabetangen nira,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pagkatapus may sasang pruibang maita tung langit ang ya ray magpailala ang yuung pag̱aningen ang Maninga Tau maglekataw ra. Pagkatapus yang kadaklan ang mga tau maskin unu pang nasyunay tung bilug ang kaliw̱utan mamagtarangiten dang mamagpurukpukan tung mga debdeb nira natetenged indi kang lag̱i pamagpakbat tung yeen. Ay maitaw rang pisan nira ang yuug sasaay tung panganud ang liit tung langit ang yuu kag dawalay nirang duru rag kasusulaw yang pagkabetangung paggaraemen. ");
INSERT INTO tbk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pagkatapus, tung uras ang atia may sasang turumpitang eyepen ta durug tunul ig panuw̱ulunu yang mga angilung mamagliliw̱utun da tung bilug ang kaliw̱utan ug̱ud panagpunun da nira yang tanan ang mga tauanung pinamiliku kang lag̱i ang duun mamanliit tung maskin ay pang kabiw̱init-binitanay yang kaliw̱utan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Numanyan, mag̱aning ti Jesus ang nagpadayun yang bitala na, “Pamaresmesan mi ra kanay ta mupia yang pananglitung naa natetenged tung ayung igus. Kung manaringsing da nganing yang mga sanga-sanga na ang mag̱impisa rang manguruk, nag̱aintindian mi rang makali rang kumaw̱ut yang tagkinit. ");
INSERT INTO tbk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Maning ka tia yang kaalimbawaan yang tanan ang atiang nagkarasambitu ta nungayna. Ta yamu, kung maita mi ra nganing ang pagkarainabu ra, asan da ngaintindiay mi ang alenget da yang uras ang ipaglekatu, maning pa tung asanaw rag pag̱elat tung purta ang para magpakleraw ra. ");
INSERT INTO tbk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iugtulu tung numyu yang kamatuuran, baklu magkarapatay yang kadaklan ang mga masigkanasyun ta numanyan, kung magkarainabu ra yang tanan ang atiang inulaw ta nungayna. ");
INSERT INTO tbk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Matunaw yang kalangitan may yang katanekan, piru yang kumpurming nag̱ibitalaw indi ra ka enged ang pisan matunaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Numanyan mag̱aning ti Jesus ang nagsugpat yang bitala na, “Ug̱aring ilem kung unu pang kaldaway ubin kung unu pang urasay ang ipaglekatu, anday nag̱akdek maski yang mga angil duun tung langit, maskin yuu pang pag̱aningen ang Ana Yang Dios, kung indi, ultimu ilem ang nag̱akdek ti Ama. ");
INSERT INTO tbk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ag̱aningenamu ra yeen ta maning tia ay kung ya pa ag̱ari yang palaksu yang pag̱irisipen yang mga tau tung panimpu ni Noe, yang pisan yang palaksu na kung yuung pag̱aningen ang Maninga Tau makaliaw rang maglekat. ");
INSERT INTO tbk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kipurki atiing indi pa ag̱akaw̱ut yang palempan, baliwala ka ilem tung mga isip yang mga tau yang sintinsiang atiang magkakaw̱ut da tung nira. Yang pinadayunan nirang pinabilug̱an, ya ra ka ilem yang pag̱urubraen nira tung pangaldaw-kaldaw ang katulad ka tung pagparanganen nira may tung pag̱irinemen nira may tung pagkarasawaen nira may tung pagparakasawaan nira tung mga ana nira. Ya ra ka ilem tii yang inintindi nira ang asta ra ilem kinaw̱ut yang uras ang ipinagsaay na Noe tung parka. ");
INSERT INTO tbk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Masapuan da ilem nira ang kinaw̱utan da tanira yang palempan ang atia ang ya ra kay nagakdan nirang tanan tung kalainan. Maning kang pisan tia kung uras dang yuung pag̱aningen ang Maninga Tau maglekataw ra. ");
INSERT INTO tbk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ay tung uras ang atia, ipabetangu may durua nga tauan ang pamag̱ubra tung kaluakan, yang sam bilug ya ray eklan yang mga angilung isagpun tung tanan ang mga tauanu. Yang aruman na, mabutwan da ka ilem asan tung karisguan. ");
INSERT INTO tbk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ubin may durua nga baw̱ayan ang pagtinaw̱angay ta paggaling yang beyed yang trigu, yang sam bilug ya ray eklan yang mga angilu, yang katabyang na mabutwan da ka ilem asan tung kaliwag̱an. ");
INSERT INTO tbk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Purisu papabtikamung pirmi ay indi mi nag̱akdekan kung unu pang kaldaway ang ipaglekatu ang yuu ka man ay Ginuu mi. ");
INSERT INTO tbk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naa w̱a ya ray sasang matinlung pademdeman mi. Yang sasang may balay, kung naskean na ra rin ilem kung unu pang urasay tung law̱ii ang ipagkaw̱ut yang takawan, binantayan na ra rin ang pinulawan yang balay na ug̱ud indi ra rin mabangbangan ang mapakleran. ");
INSERT INTO tbk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Purisu kaministiran ang ta yamu pirmiamung riparasiun tung ipaglekatu. Ay yuung pag̱aningen ang Maninga Tau, kung maglekataw ra nganing, muya matuun tung uras ang nalimung-limung da tung mga isip mi yang pagparakbaten mi tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mag̱aning ti Jesus ang nagsugpat yang bitala na, “Yang sasang turuw̱ulun ang katalig̱an ig abwat ta kinaisipan, ya ray nag̱apiaran yang ag̱alen nang mag̱erekelen tung mga kaarumanan nang turuw̱ulun ug̱ud yay mamarti-parti tung nira yang mga pamangan nira ang kada kaw̱utun yang ipagkaministiran nira. ");
INSERT INTO tbk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Teed mi tiag kasadya yang isip yang turuw̱ulun ang atia kung kaw̱utan da yang ag̱alen nang pag̱intindi tung itinuw̱ul nang atia tung anya! ");
INSERT INTO tbk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iugtulu tung numyu, ya ray piaran yang ag̱alen na tung tanan ang prupidad na. ");
INSERT INTO tbk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piru kung yang turuw̱ulun ang atia belag̱an katalig̱an, maning taa yang nag̱asuma-suma na tung isip na: ‘Aa, siguru mabuay pa kang mulik yang ag̱alenu.’ ");
INSERT INTO tbk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ang pagkatapus mag̱intra ra pamalu tung mga masigkaturuw̱ulun na ig pagustuan na ra ilem yang linawa na tung tanan ang masasabur ig magpakibarkada ra ka tung mga taung mga tarainem. ");
INSERT INTO tbk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pagkatapus numanyan inaling kaw̱utan yang ag̱alen na tung kaldaw ang inding pisan nabantay ang andang pisan ay laum-laum nang kumaw̱ut da. ");
INSERT INTO tbk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Anday dumang buaten yang ag̱alen na tung anya, kastiguen na ang anday kategkaan na. Duun da ipaugpuay na tung mga taung pamagpakaayen-ayen kang lag̱i ilem. Duun da tanya magtarangiten ang magkaretket yang isi nang magpapinitinsia ang asta tung sampa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Numanyan mag̱aning ti Jesus ang nagpadayun yang bitala na, “Kung maglekataw ra nganing, yang palaksu yang paggaraemen yang Dios ay maning taa tung ipananglitung naa. May sasang kumbira ig may sam puluk nga daralaan ang mamagpasakep da tung kumbira yang aruman nirang darala. Anday duma, namagpanaw ra ang para mamagpakigbag̱as da tung sasang laliing pangasawa. Anya-anyang kaas sinag̱ekel-ekelay. ");
INSERT INTO tbk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Numanyan yang lima lisik yang mga pag̱irisipen nira, piru yang mga aruman nirang lima ka matandes yang pag̱irintindien nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yang limang naa ya ra ag̱aningayung lisik ay maskin ekel-ekel nira yang mga kaas nira piru indi ra nangapagrisirba ta lana ang ipagkal nira tung mga kaas nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yang mga aruman nirang lima ka, ya ra ag̱aningayung matandes ay belag̱an ilem ang ekel-ekel nira yang mga kaas nira, kung indi, pati mga parabtangan ang punuk ta lana, ekel-ekel ka nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Adyus numanyan may naaw̱alaan da yang pangasawa. Purisu nagkarapuyat da yang mga darala ta pag̱elat ang asta nagkaraalapan da dayun ta elek. ");
INSERT INTO tbk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Numanyan atiing tenganan da ta law̱ii, may nagkendal dang mag̱aning, ‘Alistuamu ra, tani ra yang pangasawa. Bag̱asen mi ra!’ ");
INSERT INTO tbk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Atii dayun dang nangapuaw yang mga daralang namaglumpiu yang mga pabilu yang mga kaas nira ang para masig̱aak da. ");
INSERT INTO tbk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pagkatapus mag̱aning yang mga daralang naang lisik tung mga aruman nirang matandes, ‘Partiayami ka numyu tiang lana mi. Telengan mi w̱a, nag̱aparengdengen da yang mga kaas yamen!’ ");
INSERT INTO tbk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mag̱aning kang nansituw̱al yang mga aruman nirang matandes, ‘Abee, maliwag da tia. Tama-tama ra ka ilem taa tung mga kaas yamen. Maayen pa, mangayamu ra kanay ilem duun tung tindaan ang mangalang.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Numanyan atiing namagpanaw ra yang mga daralang atiang lisik ang para mamangalang da ta lana, nasubli ra yang pangasawa. Naang mga daralang riparasiun dang lag̱i, ya ray nanganunut tung anyang nangapasakep tung kumbira. Numanyan tung pagpakled nira tung pagkumbiraan, dayun dang siniraduan yang purta. ");
INSERT INTO tbk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Buay-w̱uay ta gesye, asan da ka namansikaw̱ut yang limang nga daralaan ang atiang mga lisik. Sigi ra ilem yang pagguuy nirang mag̱aning, ‘Duduy, duduy, paklerayami ka w̱a!’ ");
INSERT INTO tbk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mag̱aning yang pangasawang minles, ‘Iugtulu tung numyu, indiamu nag̱ailalaw kung nainuamu pa.’” ");
INSERT INTO tbk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Numanyan pagkatapus yang pananglit ang atia, dayun dang sinugpatan ni Jesus yang bitala nang mag̱aning, “Purisu ya ra ka man taang nag̱ipag̱aningu tung numyu ang dapat riparasiunamu ra kang pirmi tung paglekatu. Ay indi mi ka man nag̱akdekan kung unu pang kaldaway ubin kung unu pang urasay yang ipaglekatu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Numanyan mag̱aning si ti Jesus ang nagsugpat, “Kung maglekataw ra nganing, yang kaalimbawaan yang mainabu ay maning taa tung pananglit ang naa. May sasang tau ang magliit da tung banwa na ang para magdistinu duun tung dumang lugar. Purisu baklu nagliit, pinampaguuyan na ra kanay yang mga turuw̱ulun na ang pagkatapus ipinamiar na tung nira yang manggad na ang para ipapanaw nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yang sam bilug piniaran na ta limang liw̱u, yang sam bilug duruang liw̱u, ig yang sam bilug san liw̱u. Yang pagpiar na tung nira kumpurmi yang abilidad nirang sasa may sasa ang mag̱erekelen. Numanyan pagkatapus ta piar, dayun dang nagliit. ");
INSERT INTO tbk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Numanyan yang turuw̱ulun ang atiang piniaran na ta limang liw̱u, antimanung ingkelan na yang kuartang atiang ipinapanaw tung nigusyu. Yang pinakaw̱ut na, nag̱umintu ra ta lima pa ka enged ang liw̱u. ");
INSERT INTO tbk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maning ka tia yang binuat yang turuw̱ulun ang atiang sam bilug ang piniaran na ta duruang liw̱u. Yang pinakaw̱ut na durua kang liw̱u yang umintu na. ");
INSERT INTO tbk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piru yang turuw̱ulun ang atiang sam bilug ang piniaran na ta san liw̱u, anday dumang binuat na, nag̱akad da ilem tung tanek ang duun da itampekay na yang kuarta yang ag̱alen na. ");
INSERT INTO tbk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nabuay ra, baklu naglekat yang ag̱alen yang mga turuw̱ulun ang atia. Pagkatapus dayun dang nagrindikuinta tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pagpalenget yang sam bilug ang piniaran na ta limang liw̱u, dayun dang nag̱intriga tung ag̱alen na yang kuartang atia, pati yang umintu nang lima kang liw̱u. Mag̱aning tung ag̱alen na, ‘Ameey, limang liw̱u yang ipiniar mu tung yeen. Ia, pati yang lima kang liw̱u ang tubu na, atia ra ka.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mag̱aning ka yang ag̱alen nang minles, ‘Maayen! Talagang yaway sasang baling turuw̱ulun ig katalig̱an. Kumus pagpailalaa rang maskin gesyeng kantidad matalig̱ana, purisu numanyan piarana si ka yeen ta mas dakulung kantidad. Magpalg̱ura ra tung kasadyaanung naa.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pagkatapus yang sam bilug sing atiing piniaran na ta duruang liw̱u, ya si ay nagpalenget tung ag̱alen nang mag̱aning, ‘Ameey, duruang liw̱u yang ipiniar mu tung yeen. Ia, pati yang durua kang liw̱ung tubu na, atia ra ka.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mag̱aning ka yang ag̱alen nang minles tung anya, ‘Maayen! Talagang yaway sasang baling turuw̱ulun ig katalig̱an. Kumus pagpailalaa rang maskin gesyeng kantidad matalig̱ana, purisu numanyan piarana si ka yeen ta mas dakulung kantidad. Magpalg̱ura ra ka tung kasadyaanung naa.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pagkatapus yang sam bilug sing atiing piniaran na ta san liw̱u, ya si kay nagpalenget tung ag̱alen nang mag̱aning, ‘Ameey, yang nag̱askeanu tung nuyu, yawa sasang durug lepes ang tau. Pagpakinaw̱anga tung indi mu pinakabedlayan. Pagpakaayena tung indi mu pinaturukan ta ulas mu. ");
INSERT INTO tbk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Purisu ya ra kay inleranu tung nuyu, ay muya kung unu ray buaten mu tung yeen. Purisu anday dumang binuatu, itinaluku ra ilem yang kuarta mung itinampek tung tanek. Ia, atia ra ka yang kuarta mu ang indi ka nabuinanu.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mag̱aning ka yang ag̱alen nang minles, ‘Abaa, yawa, inutilang turuw̱uluna! Duruag katatamad! Pag̱aninga ka palang nag̱akdekan mu ang yuu pagpakinaw̱angaw tung indi pinakabedlayanu, maskin yang indi pinaturukanu ta ulasu ya ka. ");
INSERT INTO tbk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ig disir yang dapat da rin ang binuat mu, baskin idinipusitu mu ra ilem yang kuartaw tung bangku ug̱ud tung pagbaliku, maeklanu pa ka rin pati tubu na. Atii ra rin.’ ");
INSERT INTO tbk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pagkatapus dayun dang nanuw̱ul yang ag̱alen na tung mga turuw̱ulun nang duma ang mag̱aning, ‘Ala, eklan mi ra tung anya yang kuartaung atia. Ipakdul mi ra asan tung aruman nang may sam puluk ang liw̱u. ");
INSERT INTO tbk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ay ya pa ag̱ari, kung tinu pay maderep ang magpapanaw tung ipiniar tung anya, piaran pa ka enged ta mas pa ang asta dakulung pisan. Piru kung tinu pay paw̱aya-w̱ayaen tung ipiniar tung anya, maski nganing yang gesyeng atiang ipiniar tung anya, bawien pa ka enged tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kung natetenged tung turuw̱ulunung naang sam bilug ang nagluang inutil, iplek mi ra tung lua duun tung makiklep. Duun da magtarangiten ang magkaretket yang isi nang magpapinitinsia,’” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Numanyan mag̱aning si ti Jesus ang nagpadayun yang bitala na, “Ta yeen ang pag̱aningen ang Maninga Tau, kung maglekataw ra nganing, durung pisan agkasulaw yang pagkabetangu ig yang tanan ang mga angil yay mga arumanu. Ya ray uras ang ipagkarungu tung puistuung maggaraemen da. ");
INSERT INTO tbk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Panuw̱ulunu yang mga angilung mamagpasagpun tung tanan ang mga tau tung bilug ang kaliw̱utan, maskin unu pang nasyunay ang para ipampatalunga tung yeen. Pagkatapus papagbelag̱enu tung duruang grupu ang katulad ka tung magbuw̱uaten yang sasang manigpastur tung mga kaayepan na ang yang mga karniru nag̱ipablag na ka tung mga kambing. ");
INSERT INTO tbk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yang mga karniru asan da pinig̱ay na tung ampir tung tuu na. Yang mga kambing asan da pinig̱ay na tung ampir tung wala na. ");
INSERT INTO tbk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Matapusu ra nganing ta pagpinig tung tanan ang mga tau, kumus yuu ray paggaraemen, panganingenu yang mga taung ampir tung tuuu ta maning taa: ‘Ta yamung pinakaayen da ni Ama, taniamu. Mag̱intraamu ra pakinaw̱ang tung tanan ang kaayenan ang ya ra kang lag̱i ay ipinagsimpan na para tung numyu disti pa atiing indi na pa nag̱aimu yang kaliw̱utan. ");
INSERT INTO tbk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kipurki atiing pagkasuw̱uku, pinapaanaw numyu. Atiing pagkakanalu, pinainemaw ka numyu ta wai. Maskin belag̱anaw pang kailala mi, ingkelanaw ka numyung pinadayun tung mga balay mi. ");
INSERT INTO tbk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Atiing alang-alang da yang pag̱araw̱elenu, pinakdulanaw ka numyu ta aw̱elu. Atiing paglaruu, inasikasuaw ka numyu. Atiing pagkakalabusu, binisitaanaw ka numyung pinaiwan-iwanan,’ maningaw tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pagkatapus yang mga tauanung kumpurming nagtuman yang kalelyag̱an yang Dios, ya ra mamanalimaan tung yeen ang mag̱aning, ‘Abee, Ginuu, sanua pa ngaita yamen ang nasuw̱uka ang pagkatapus pinapaana yamen ubin naitaa yamen ang kinanala ang pagkatapus pinainema ka yamen ta wai? ");
INSERT INTO tbk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sanua pa ngaita yamen ang anday natiniran mu ang pagkatapus pinadayuna ka yamen tung balay yamen ubin naitaa yamen ang naalang-alanga ta pag̱aw̱el mu ang pagkatapus pinakdulana ka yamen ta aw̱el mu? ");
INSERT INTO tbk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sanua pa ngaita yamen ang naglaru ubin nakalabus ang pagkatapus binisitaana ka yamen ang pinaiwan-iwanan?’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pagkatapus yang matuw̱alu tung nira maning taa: ‘Iugtulu tung numyu yang kamatuuran, atiing kada binuatan mi ta mga maning tia yang mga putulung naning pagtalig ka tung yeen, maskin aranek ang pisan ta pagkabetang, katimbang nang yuu ra kay binuatan mi,’ maningaw. ");
INSERT INTO tbk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pagkatapus panganingenu ra ka yang mga taung ampir tung walaw ang maning taa: ‘Ta yamung nag̱asintinsiaan da yang Dios tung kalainan, paaw̱ig̱amu ra taa tung yeen. Duunamu ra manalunga tung apuy ang anda enged ang pisan ay kapugdaw-pugdawan nang asta tung sampa ang ya kang lag̱i ay ipinagsimpan yang Dios para tung ni Satanas may tung mga angil ang namagpaturuw̱ulun tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kipurki atiing pagkasuw̱uku, indiaw pinapaan mi. Atiing pagkakanalu, indiaw ra ka pinainem mi ta wai. ");
INSERT INTO tbk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Atiing anda ray naistaranu, indiaw ka pinadayun mi tung mga balay mi. Atiing naalang-alangaw ra ta pag̱araw̱elenu, indiaw ra ka pinakdulan mi ta aw̱elu. Atiing paglaruu, ubin atiing pag̱akalabusu, indiaw ka binisitaan ming pinaiwan-iwanan,’ maningaw. ");
INSERT INTO tbk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pagkatapus ya mamanalimaan tung yeen ang mag̱aning, ‘Abee, Ginuu, sanua pa ngaita yamen ang nasuw̱uka ubin kinanala ubin anday ray nadayunan mung balay, ubin naalang-alanga ra ta pag̱aw̱el mu ubin naglarua ubin nakalabusa ang india ra ka tinabnuy yamen?’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pagkatapus yang matuw̱alu tung nira, maning taa: ‘Iugtulu tung numyu yang kamatuuran, atiing kada indi mi tinaw̱angan yang mga tauanung nani ang yay pinaglamku ming aranek ang pisan ta pagkabetang, katimbang nang yuu ra kay indi mi tinaw̱angan,’ maningaw tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pagkatapus yang mga taung atia, lalangan da yang Dios ang duun da enged mamanalunga tung parusa ang anda enged ang pisan ay katapus-tapusan na. Piru yang mga taung kumpurming nagtuman yang kalelyag̱an na, ya ray tugtan nang mamagpakigsapen tung anya ang asta tung sampa ang anda ka enged ang pisan ay katapus-tapusan na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Taa numanyan atiing pagtapus ni Jesus tung pagparasanag̱en nang atia natetenged tung uras ang panalungaan, dayun na rang sinugpatan yang bitala na tung yamen ang nag̱apangugyatan na ta maning taa: ");
INSERT INTO tbk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nag̱askean mi ra ka ang tung yaklung kaldaw kumaw̱ut da yang pistang Taklib. Ya ray uras ang yuung pag̱aningen ang Maninga Tau iintrigaw ra tung pudir yang mga tau ang para ipalansangaw ra nira tung krus,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Simanyan tung uras kang atii duun tung balay ni Caifas ang yay paring pinkalandaw, pamagsaragpun da yang mga paring atiang arabubwat ta katengdanan may yang mga pamagpakigmaepet tung banwa. ");
INSERT INTO tbk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pamag̱urunta-untaan da tanira kung unu pay matinlung idyang gamiten ang para mapadeep nira ti Jesus ang anday durung taung makdek ang pagkatapus ipaimatay nira dayun. ");
INSERT INTO tbk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ag̱aaning tanirang pamagkeresen, “Indi ta ilem ituun tung pista. Muya magkagulu yang mga tau,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Taa numanyan, ti Jesus tanya duun tung Betania tung balay ni Simon ang yang tukaw may laru na pa rin tung ulit nang makabiw̱iru. ");
INSERT INTO tbk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Numanyan may sasang baw̱ay ang nagpalenget tung ni Jesus ang may ekel nang midyu tung prasku ang yay punuk ta sasang paamut ang durug kamaal. Pagkatapus ya ray ibinukbuk na tung kulu ni Jesus ang pagpakigsadu. ");
INSERT INTO tbk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Numanyan pagkaita yamen yang binuat yang baw̱ay ang atia, ya ra pakulainay yamen. Ag̱aaningami, “Abaa, gasta ra ilem tia! ");
INSERT INTO tbk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kung ya pa rin ipaalangay na tia, naita pa rin ta dakulung kuarta. Napamakdul-pakdul pa rin tung mga maliliwag̱en!” ");
INSERT INTO tbk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Simanyan pagkasiman ni Jesus, dayun dang nagbitala tung yamen ang mag̱aning, “Ayw̱at nag̱apakdulan mi ta pagliw̱eg̱an yang isip yang baw̱ay ang naa? Durug tinlu yang binuat nang naa tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ay kung natetenged tung mga maliliwag̱en ang atiang nag̱aisip mi, maskin unu pang urasay mataw̱angan mi ay taang pirmi. Piru ta yeen belag̱an ang mag̱aning ang maskin unu pang urasay ang taanaw ang pirmi tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ay tung pagbukbuk na yang paamut ang naa tung yeen, yang kaalimbawaanu maning pa tung patayaw rang lag̱i ang pagkatapus sinimpananaw rang lag̱i anyang pinaamutan ang para ilg̱uraw ra tung leyang. ");
INSERT INTO tbk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iugtulu tung numyu yang kamatuuran, maskin ay pang banwaay tung bilug ang kaliw̱utan ang yang mga tau pampakaw̱utan da yang Matinlung Balita natetenged tung yeen, yang binuatan yang baw̱ay ang naa tung yeen mabalita ka tung mga tau ug̱ud ya ray mademdeman nira tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pagkatapus numanyan ti Judas ang Iscariote ang yay sam bilug tung yamen ang mga tauan ni Jesus ang sam puluk may durua, anday dumang binuat na, nag̱angay ra duun tung mga paring atiang arabubwat ta katengdanan. ");
INSERT INTO tbk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nagpakiksen da tung nirang mag̱aning, “Pira pa w̱asu yang mapakdul mi tung yeen kung alimbawa mapadeepu ti Jesus ang para maintriga ra tung pudir mi?” Purisu binilangan da nira ta tulung puluk ang bilug ang kuartang atiang salapi. ");
INSERT INTO tbk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Purisu mag̱impisa tung uras ang atii, ti Judas ang naa pirmi ra ilem ang pagbantay ta ketat ang para mapadeep na ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Numanyan tung primirung sug̱ud yang Pistang Nag̱ipagpangan Ta Tinapay Ang Indi Pinaliskag, yaming nag̱apangugyatan ni Jesus, nagpalengetami ra tung anyang nagtalimaan ang mag̱aning, “Ariami pa w̱asung balayay magsimpan yang iapun tang para silibraen ta yang pistang naang Taklib?” ");
INSERT INTO tbk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mag̱aning ka ti Jesus ang minles, “Mag̱angayamu ra kanay duun tung siudad. May sasang taung sinambitu ra tung numyu. Yamu ra ag̱aaning tung anya, ‘Yami minangayami ilem taa, ay yang tuyun ni Ameey tang paturuldukanen tung yaten, kinaw̱ut da unu yang uras ang itinipu yang Dios tung anya. Gustu na unu ang asan tung balay mu magsilibra yang pistang naang Taklib, kasiraanami ra ka unung nag̱apangugyatan na,’” ag̱aaning ti Jesus tung yamen. ");
INSERT INTO tbk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Atii dayun da ka man ang tinuman yamen yang itinuw̱ul ni Jesus ang atia tung yamen ang nagsimpan da duun ta iapun yamen ang magsilibra tung pista. ");
INSERT INTO tbk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Numanyan atiing panlikarem da, ti Jesus nagpasintar da tung lamisaan ang para magyapun da, kasiraanami ra kang nag̱apangugyatan nang sam puluk may durua. ");
INSERT INTO tbk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Atiing pagsararuanami ra, mag̱aning ti Jesus tung yamen, “Iugtulu tung numyu, may sam bilug tung numyu ang ray magtraidur tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pagkagngel yamen tia, inampayanami ra ta kapungaw yamen ang duru. Purisu masigtalimaanami tung anyang mag̱aning, “Belag̱an ka siguru yuu, Ginuu, anu?” ");
INSERT INTO tbk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ag̱aaning ka ti Jesus ang minles, “Anday dumang magtraidur tung yeen, kung indi, ya ra yang sasang dating kasaduu mismu ang pagpakidengan ka pa man tung yeen ang pagtekme tung sera. ");
INSERT INTO tbk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kung tung bag̱ay, yuung pag̱aningen ang Maninga Tau, imatayenaw ra ka man ang katulad ka tung naula natetenged tung yeen ang napabtang ka tung kasulatan. Piru yang taung naang magtraidur tung yeen, ya ray nag̱apanganugunanu ta mupia. Ay kipurki durug lebat yang talungaen na tung uri. Mas maayen pa rin ang indi ra ilem ipinangana,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Atii nabnga ra ti Judas ang ya ra ka man mismu yang pagtimang magtraidur tung anya. Mag̱aning tung ni Jesus, “Belag̱an ka siguru yuu, Rabbi, anu?” Mag̱aning ka ti Jesus ang minles, “Yawa ka nganing ay pag̱aning,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Taa numanyan atiing sigi-sigi ra yang pagsararuan yamen, ti Jesus namisik da ta tinapay ang ya ray pinasalamatan na tung Dios. Pagkatapus, dayun na rang pinagpingas-pingas ang ipinarawat tung yamen ang mag̱aning, “Ia, panganen mi ra. Atia ya ra taang tinanguniu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pagkatapus dayun sing namisik ta sam basung binu ang ya si kay pinasalamatan na tung Dios ang pagkatapus dayun na rang ipinarawat tung yamen ang mag̱aning, “Ia, ya ray pagbereles-belesan ming igmen. ");
INSERT INTO tbk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ay kipurki tia ya ra taang dug̱uung ipaturuku ang para ya ray magpabaked tung sasang pagpakigpaig̱ung tukurun yang Dios ug̱ud asan da nga patawaray na yang dakeleng mga tau tung mga kasalanan nira. ");
INSERT INTO tbk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iugtulu tung numyu, ultimu ra ilem taa yang panginemu ta binung maning taang nag̱ipagsilibra ta tung pistang naa. Piru kung kaw̱utun da nganing yang uras ang ipagpabistu ra enged ang pisan yang Dios yang paggaraemen na, magkasira-siraanita si kang magpakasadya tung tanan ang kaayenan na ang yay maning pa tung sasang igmen ta sing baklu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pagkatapus ta pag̱iriapunan yamen ang atia, dayunami rang nagkantang nagdayaw tung Dios. Pagkatapus tia, dayunami rang naglampud ang nagpanaw duun tung bukid ang atiang durung mga ayung pag̱aningen ang olibo. ");
INSERT INTO tbk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Numanyan atiing panungulami ra tung bukid ang atia, mag̱aning ti Jesus ang nagbitala tung yamen, “Numaan ang law̱ii maplekanamu ra ta ipagtalig mi tung yeen natetenged tung mainabu tung yeen. Ayw̱a indiamu ra aningenu ay kipurki magkamatuuranita ra yang sasang ipinananglit yang Dios ang tukaw ang napabtang tung kasulatan ang mag̱aning, ‘Ilug̱utu ra yang manigpastur ang imatayen da ang pagkatapus magkarawasak da ka ilem yang mga karniru na,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piru maskin pang maning tii ay mainabu, kung pabungkarasenaw ra nganing yang Dios, magtukawaw ra tung numyu duun tung Galilea.” ");
INSERT INTO tbk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mag̱aning ti Pedrong nabnga, “Maskin yang kadaklan maplekan da ta ipagtalig nira tung nuyu, piru ta yeen indiaw ka enged maplekan!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mag̱aning ti Jesus ang minles, “Aa Pedro, iugtulu tung nuyu, numaan ang law̱iing naa, baklu manuluk yang manu, maklua ra kang mag̱ingwara tung yeen.” ");
INSERT INTO tbk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mag̱aning ka ti Pedrong tuminuw̱al, “Maskin ipaunungaw pa tung nuyung imatayen, talagang indiaw ra ka enged mag̱ingwara tung nuyu,” mag̱aning. Asta yaming kadaklan maning ka tia yang nabitala yamen. ");
INSERT INTO tbk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Taa numanyan ti Jesus dayun dang nag̱angay duun tung lugar ang paggug̱uuyan tung Getsemani, kasiraanami ra ka. Mag̱aning ti Jesus tung yamen, “Taanamu ra ilem kanay ngarung. Mangayaw pa kanay tani tung tukaw-tukaw ang para mag̱ampuaw,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Numanyan yang ingkelan nang pinanunut, ya ra yang mga aruman yamen ang ti Pedro may yang mga ana ni Zebedeong atiang durua. Numanyan ti Jesus inampayan da ta kapungaw nang duru ig naliwag̱an da ta mupiang pag̱isip. ");
INSERT INTO tbk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mag̱aning tung mga aruman na, “Ag̱ampayanaw ra ta kapupungawenung duru. Arus pa ilem muntuk yang linawaw. Taanamu ra ilem kanay mag̱elat ang magpakipulaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Numanyan pagpatukaw-tukaw ni Jesus ta gesye, ya rag papadagpa tung tanek ang pag̱ampu ang mag̱aning, “Amaw, kung maimu ilem tung nuyu, ipataklib mu ra ilem tung yeen yang pinitinsiang naang nag̱atalungaw. Piru maskin pang nag̱apagbitalaw ta maning tii, belag̱an yang yeen ang kalelyag̱an ay matuman, kung indi, yang nuyu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Numanyan pagbalik na tung mga aruman yamen ang atiang tulu, kaw̱utan na, naa pala mga elek da. Purisu dayun na rang inaning ti Pedro ang “Abaw, ba tia Pedro, maskin sang uras da ilem indiamu ra nasarang ang nagpakipulaw tung yeen ang para mapakiununganaw ra rin numyu tung kaliwag̱anung naa? ");
INSERT INTO tbk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpulawamu ra ta ustung mag̱ampu ug̱ud indiamu ra madeeg̱an ta tuksu. Tung bag̱ay nag̱askeanu ang durung gustu ming manguntiel tung tuksu, piru nusias ilem dereeg̱enamu pa yang kaluluw̱ayen mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Utru si, nagpaalawid-lawid si ti Jesus tung nira ang nag̱arampuen sing uman ang mag̱aning, “Amaw, kung talagang indi ka enged maimu ang indiaw pasaran yang pinitinsiang naang nag̱atalungaw, tay yang kalelyag̱an mu yay matuman,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagkatapus pagbalik na si tung mga aruman yamen ang atiang tulu, kaw̱utan na, mga elek si ka enged ay dereeg̱en da yang puyat nirang duru. ");
INSERT INTO tbk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Utru si binutwanan na sing nagpalawid-lawid ang nag̱arampuen si ta yaklung bisis ang maning ka tia yang ipinag̱ampu na. ");
INSERT INTO tbk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapus pagbalik na si tung mga tauan nang atia, dayun na rang inaning, “Ba tia, elek mi rang elek! Ustu tiang pamaenay mi! Kinaw̱ut da yang uras ang yuung pag̱aningen ang Maninga Tau iintrigaw ra tung pudir yang mga taung malalain. ");
INSERT INTO tbk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ala, magbungkarasamura, ay magpanawita ra. Uay, naa ra yang pagtraidur tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Numanyan, atiing indi pa nganing nag̱atapus ta pagbitala ti Jesus, asan da ka man nakaw̱ut ti Judas ang sasa ka pa man tung yamen ang sam puluk may durua ang nag̱apangugyatan na. Sam paluyug̱an da tanira yang mga taung buntun ang pamag̱ekel-ekel ta mga geed may mga palu. Ay pinanuw̱ul da yang mga paring arabubwat ta katengdanan kasiraan da ka yang mga pamagpakigmaepet tung banwa. ");
INSERT INTO tbk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Atii pala, yang pagtraidur ang naa, may sasang sinyas ang ipinaske na rang lag̱i tung mga kaarumanan na ang mag̱aning, “Kung kumaw̱utita ra nganing duun, yang taung ara-araanu, mag̱aningamu ya ra tia. Deepen mi rang lag̱i,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Purisu pagkaw̱ut ni Judas duun, diritsyu rang nagpalenget tung ni Jesus ang nagbugnu tung anyang mag̱aning, “Mupiang law̱ii asan, Rabbi!” Pagkatapus dayun na ra ka man ang inara-araan. ");
INSERT INTO tbk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mag̱aning ti Jesus ang minles, “Aay ungkuy, ya ra taa yang inangay mu?” mag̱aning. Numanyan pagkaara-ara ni Judas tung anya, diritsyung pinalengtan yang mga kaarumanan nang dineep. ");
INSERT INTO tbk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atii may sasang aruman yamen ang ya ray napanlaw̱ut yang geed nang napanibat tung sasang turuw̱ulun yang paring pinakaabwat ang pagkatapus yang talinga na ra ka ilem ay nalampung. ");
INSERT INTO tbk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pagkatapus dayun dang sinambeng ni Jesus ang inaning, “Eey, itag̱eb mu ra tiang geed mu. Kipurki yang kumpurming paggamit ta matarem, matarem ka yang mapatayan na. ");
INSERT INTO tbk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ayw̱a, indi mu nag̱askean ang kung magpataw̱angaw ilem tung ni Ama, antimanung patuw̱ulanaw ra anya tung mga angil ang liniw̱u-liw̱u ang para mamagdipindir da tung yeen? ");
INSERT INTO tbk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ug̱aring kung magpataw̱angaw tung anya, ya pa ag̱aaring magkamatuud da yang sasang napabtang tung kasulatan natetenged tung yeen ang yuu unu dapat ang pasaran ta maning ka taa?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Numanyan dayun dang nagbitala tung mga taung atiang buntun ang mag̱aning, “Ayw̱a yuu sasang ribildi ang yuu rag sulungay mi ta mga geed may mga palu ang para madeepaw numyu? Kaldaw-kaldaw duunaug kakarung tung palayas yang pagtuuan ang pinakalusung pagturuldukanen tung mga tau ang pagkatapus indiaw pa ka dineep mi? ");
INSERT INTO tbk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piru nag̱askeanu ang nagkamaninganaw ra ta maning taa ay ug̱ud magkamatuud da yang nagkarasulat yang mga manig̱ula ang tukaw natetenged tung yeen,” mag̱aning. Atii, yaming tanan ang nag̱apangugyatan na, dayunami rang namutwan tung anyang nagpalibri. ");
INSERT INTO tbk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Taa numanyan, ti Jesus ingkelan da yang mga taung atiang namagdeep tung anya duun tung balay ni Caifas ang yay paring pinakalandaw. Duun da kang lag̱i pamagsaragpun yang mga sag̱ad may yang mga pamagpakigmaepet. ");
INSERT INTO tbk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Numanyan ti Pedro tanya, ya ra ilem manikad tung ni Jesus, piru atii ra tung kauri-urian da ilem ang pisan. Numanyan pagkaw̱ut na duun tung balay ang atia, dayun dang nagpakled tung plasa-plasa na ang nagpakigkarung da tung mga guardia ug̱ud mapaniiran na kung unu pay buaten tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Numanyan duun tung kakleran, yang mga paring arabubwat ta katengdanan may yang intirung grupu yang mga usgadung pinakalandaw, ya ray pamagdilem ta mga taung magpetel ta malain tung ni Jesus ang para ya ray padatelan nirang mamagsintinsia tung anya ang dapat ang ipaimatay. ");
INSERT INTO tbk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Maskin duru ra ka man ang mga taung namagsistigus ta kabuklian ang kuntra tung ni Jesus, piru anda pa ka enged ay pruibang bastanting naita nira ang para ya ra rin ay patielan nira. Pagkatapus atiing patapus-tapusun da yang pagsiristigusun, may durua nga tauan ang namanalunga ang mag̱aning, “Yang taung atia nagngel da yamen ang pagbitala ang kayanan na unung gew̱aen yang pagtuuan ta tung Dios ang pinakalusu ang pagkatapus tung seled ilem tulung kaldaw, kayanan na ka unung mapakdengan si ta baklu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Numanyan dayun dang kumindeng yang paring pinakalandaw ang nagtalimaan tung ni Jesus ang mag̱aning, “Ta, unu pay matuw̱al mu tung nag̱ibangdan tung nuyu yang duruang atia?” ");
INSERT INTO tbk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piru ti Jesus indi nagliing-liing. Purisu dayun sing inaning yang pari ang “Buinu, papanumpaena ra kanay yeen tung aran yang Dios ang makagag̱aem. Iugtul mu tung yamen kung yawa ka man yang pag̱aningen ang Cristo, bilang yang Ana Yang Dios ang pag̱aningen.” ");
INSERT INTO tbk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mag̱aning ka ti Jesus ang minles, “Yawa ra ka nganing ay pag̱aning. Tung dumang uras, yuung pag̱aningen ang Maninga Tau, maitaaw ra numyung tanan ang yuug kakarung tung tepad yang Dios ampir tung tuu na ang pagkatapus kung maglekataw ra nganing taa, maitaaw ra ka numyung yuug sasaay tung panganud ang liit tung langit.” ");
INSERT INTO tbk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagkagngel yang paring pinakalandaw tia, anday dumang binuat na, ya ra bakbakay na yang aw̱el ang pag̱asuut na ay nasilag da ta duru tung itinuw̱al ni Jesus ang atia. Mag̱aning tung mga kaarumanan na, “Ta, telengan mi, ya rag pagtiwakaway na yang pagkadios yang Dios! Ministir pang magdilemita pa ta sistigus? Nagngel mi ra ka mismu yang pagtiwakaw na. ");
INSERT INTO tbk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta, ya pa ag̱ari yang disisiun mi tung taung naa?” Mag̱aning ka tanirang namansituw̱al, “Bag̱ay ang pisan tung anyang ipaimatay ra ilem,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Numanyan ti Jesus dayun dang linawayan yang duma tung ityura na ang pagkatapus pinagtaraw̱angan da ka yang duma ta suntuk. Inintraan da ka yang duma ta dapal ang nunut da ka ta pagpapintu nira tung anyang mag̱aning, “Ta, atiing bantug da ang yawa unu yang pag̱aningen ang Cristo, abir, pintuen mu kung tinu pa tiang nagtigbak tung nuyu!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Balikan ta ra kanay ti Pedro asan tung lua ang ya pag kakarung tung plasa-plasa yang balay. Numanyan pinalengtan da yang sasang turuw̱ulun ang baw̱ay ang binugnu ang, “Eey, midyu yaway sasang aruman ni Jesus ang nakaang tag̱a Galilea!” ");
INSERT INTO tbk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piru ya ra mag̱ingwara ti Pedro duun ka pa man mismu tung pagtaralungaan nirang tanan. Mag̱aning, “Indi ilem nag̱aintindianu kung unu pay gustu mung ianing!” ");
INSERT INTO tbk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pagkatapus dayun dang nagpauman ang nagpaampir duun tung may purtang magluluaan tung karsada. Numanyan may duma sing turuw̱ulun ang baw̱ay ang ya si ay naita tung anya ang pagkatapus nag̱ugtul da tung mga aruman na ang “Uay, yang taung atia yay sasang aruman ni Jesus ang nakaang tag̱a Nazaret!” ");
INSERT INTO tbk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Atii nag̱ingwara si ti Pedro ang pinaugtunan na pa ta panumpa ang mag̱aning, “Agsumpaanu pa tung aran yang Dios, talagang indi nag̱ailalaw yang taung nakaang nag̱aaning mu kung tinu pa!” ");
INSERT INTO tbk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Buay-w̱uay ta gesye, yang dumang atiang kemdengan asan, ya si ay namagpalenget tung ni Pedrong namagbugnu ang mag̱aning, “Eey, kamatuuran ka man ang yaway sasang aruman na. Anday dumang nag̱adeep yamen tung nuyu ya ra yang puntu yang pamitala mu.” ");
INSERT INTO tbk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Numanyan ti Pedro dayun sing nanumpang uman ang mag̱aning, “Sistigus tung pagkamatuud yang Dios ang yang taung nakaang nag̱aaning mi talagang indi nag̱ailalaw. Parusaanaw pa yang Dios kung belag̱an matuud yang nag̱ianingung atia.” Pagkaaning na tia, may manung nanuluk da. ");
INSERT INTO tbk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Baklu ra nga demdemay na yang inaning ni Jesus tung anya ta nungayna ang mag̱aning, “Baklu manuluk yang manu, Pedro, maklua rang mag̱ingwara tung yeen ang yuu pala indiaw nag̱ailala mu.” Numanyan pagkademdem ni Pedro tii, diritsyu rang luminua ang nag̱intra ra tarangiten ang duru ra kang pagsurug̱aten na. ");
INSERT INTO tbk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Atiing kaldaw ra, yang tanan ang atiang mga paring arabubwat ta katengdanan may yang tanan ang atiang pamagpakigmaepet, ya ray namag̱urunta-untaan kung ya pa ag̱ari yang pagpaimatay nira tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Purisu anday dumang binuat nira, namagkalalangan da ang ti Jesus gapusun dang guyurun duun tung ni Gubirnadur Pilato ug̱ud iintriga ra nira tung pudir nang ipabista. ");
INSERT INTO tbk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Taa numanyan ti Judas ang naang nagtraidur da tung ni Jesus, pagkaintindi na ang tanya pinagsintinsiaan da nira tung kalainan, napag̱inesel da. Purisu dayun na rang ibinalik yang kuartang atiang tulung puluk ang bilug ang salapi tung mga paring atiang arabubwat ta katengdanan may tung mga pamagpakigmaepet. ");
INSERT INTO tbk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mag̱aning tung nira, “Nagkasalananaw ra tung binuatanung atia tung anya ang ya ra traidurayu yang sasang taung anday kasalanan na ang ya ra kay magakdan na tung kamatayen na,” mag̱aning. Mag̱aning ka tanirang namagtimales, “Unu pay kalalabten yamen asan? Bala ra tung nuyu!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pagkagngel ni Judas tia, dayun na rang ibinurarag yang kuartang atia asan tung palayas yang pagtuuan ang pinakalusu ang pagkatapus diritsyu rang nagliit duun tung nira ang nagpanaw. Numanyan anday dumang binuat na, nagbitay ra ilem tung sadili nang naneg̱et. ");
INSERT INTO tbk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Numanyan yang kuartang atiang ibinurarag na, dayun dang inuup yang mga paring atiang arabubwat ta katengdanan. Mag̱aning tanira, “Eey, yang kuartang naa ibinayad tung linawa ta sasang tau. Purisu balaw̱ag tung lai ta ang malaket pa tung kuarta tang pundung pag̱atuw̱ud para tung pagtuuan tang naa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Numanyan pagkatapus nira ta pagparaig̱u nira natetenged tung kuartang atia kung unyen pa nira, ya ray ingkelan nirang ipinangalang tung tanek yang sasang manigbuat ta urun. Ay yang gustu nira tung tanek ang atia, ya ray buaten nirang simintiriu para tung mga taung tag̱a duma-rumang nasyun ang belag̱an mga masigka Judio nira. ");
INSERT INTO tbk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Purisu ang asta ra ilem simanyan yang lugar ang atii ya ray pag̱aningen ang tanek ang inalang yang ibinayad tung linawa ta sasang tau. ");
INSERT INTO tbk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Purisu duun da ka nga matuuray yang sasang ipinaula yang Dios tung ni Jeremias ang sasang manigpalatay yang bitala nang tukaw ang mag̱aning, “Pagkatapus ingkelan da nira yang kuartang atiang tulung puluk ang salapi ang ya ra ka man ay prisiung pinag̱irig̱uan yang dumang mga masigkanasyun tang mga Israel ang para ibayad nira tung linawa na. ");
INSERT INTO tbk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pagkatapus ya ra kay ipinangalang nira tung tanek yang sasang manigbuat ta urun ang katulad ka tung sinambit ni Yawi tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Numanyan ibalik ta ra kanay tung ni Jesus ang duun dag kekdeng tung katalungaan yang Gubirnadur ang pagpabista. Mag̱aning tung anya, “Ta, unu pay idiklara mu? Matuud ang yawa yang Adi yang mga Judio?” Mag̱aning ka ti Jesus ang minles, “Yawa ka nganing ay pag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Numanyan yang mga paring atiang arabubwat ta katengdanan may yang mga pamagpakigmaepet ya si ay namansisublang ang namagbangdan tung ni Jesus. Piru maskin unu pay nag̱ibangdan nira tung anya, indi kang pisan nag̱iw̱ek-iw̱ek. ");
INSERT INTO tbk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Purisu numanyan dayun sing inaning ni Gubirnadur Pilato ang “Ayw̱a india ra matuw̱al? Indi mu nag̱agngel yang nag̱ibangdan nirang atia tung nuyung durug dakel?” ");
INSERT INTO tbk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piru ti Jesus tanya inding pisan natuw̱al tung anya may san tag̱ang bitala, ang ya ra kay naberengan yang Gubirnadur ta duru. ");
INSERT INTO tbk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naang ti Gubirnadur Pilatong naa, may ug̱ali na ang kada kaw̱utun yang pistang atia, may sa nga prisuan ang magpalpasan na. Kumpurmi ka ilem yang nag̱alelyag̱an yang mga tau, yay palpasan na. ");
INSERT INTO tbk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Numanyan tung uras ang atii, may sasang prisung bantug ang durug iseg ang yay nag̱aranan tung ni Barabbas. ");
INSERT INTO tbk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Purisu tung pagsaragpun yang mga taung atiang buntun duun tung katalungaan ni Gubirnadur Pilato, dayun na rang tinalimaan ang inaning, “Tung durua nga tauan ang naa, ay pay nag̱alelyag̱an ming yay palpasanu? Ti Barabbas u ti Jesus ang naang pag̱aningen ta duma may ruma ang Cristo?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Napagtalimaan da yang Gubirnadur ta maning tia, ay gustu na ra rin ang balaw̱ag̱an na yang pag̱asikad yang may mga katengdanan ang atia. Ay kipurki nag̱askean na ra kang lag̱i ang anday dumang ipinag̱intriga nira tung ni Jesus tung pudir na, kung indi, yang pagkirimunun nirang subra tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Numanyan atiing ti Pilato pagkarung da asan tung kakarungan nang atiang dati kang lag̱ing pag̱usgaran na, kinaw̱utan da ta tuyun yang kasawa na ang mag̱aning, “India ra enged magpasanyug tung pamagkuntra tung taung atiang anday kasalanan na. Kipurki tan law̱ii naliwag̱anaw ra ta durung pag̱isip tung tinalakinepu natetenged tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ug̱aring ilem naang mga paring arabubwat may naang mga pamagpakigmaepet, ya ray namagsulsul tung mga taung atiang buntun ang ti Barabbas ang atia ya ray ingalukun nira tung ni Pilatong palpasan na ang pagkatapus ti Jesus ya ra kay ingalukun nira tung anyang ipaimatay na. ");
INSERT INTO tbk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Taa numanyan dayun sing nagtalimaan yang Gubirnadur tung nirang mag̱aning, “Tung nirang durua nga prisuan, tinu pay nag̱alelyag̱an ming palpasanu?” Mag̱aning ka tanirang namansituw̱al, “Ti Barabbas!” ");
INSERT INTO tbk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mag̱aning ka ti Pilatong minles, “Ay ti Jesus ang naang pag̱aningen ta duma may ruma ang Cristo, ya ra ilem unyayu?” Yang tuw̱al nirang tanan, “Ipalansang mu ra ilem tia tung krus!” ");
INSERT INTO tbk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mag̱aning si ti Pilatong minles, “Ayw̱a? Unu pang kasalananay ang binuat na?” Atii mas pang dinulangan nira yang paglelpaken nirang pamansianing, “Ipalansang mu ra ilem tia tung krus!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Numanyan pagkasiman ni Pilato ang kung ireg̱es na pa yang anya, muya mamagkagulu ra ta mupia yang mga tau, anday dumang binuat na, dayun dang nagpaekel ta wai ang pagkatapus nangug̱as da dayun yang mga kalima na asan mismu tung katalungaan yang mga tau. Pinanuntan na ka ta pasanag ang mag̱aning, “Tandaan mi naa. Ta yuu, anda ray panuw̱alanu tung kamatayen yang taung naa. Tung numyu ra dilemay!” ");
INSERT INTO tbk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mag̱aning ka tanirang tanan ang namagtimales, “Ee, yami ray manuw̱al tung kamatayen na pati mga ana yamen!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Purisu numanyan anda ray dumang binuat ni Pilato, ti Barabbas ang atiang nag̱alelyag̱an nira, ya ray pinatuw̱ulan nang palpasan da. Piru ti Jesus tanya, ya ray pinaburdunan na baklu iintrigaay na tung mga sundalu ang para ilansang da nira tung krus. ");
INSERT INTO tbk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Taa numanyan yang mga sundalung pag̱apanuw̱ul yang Gubirnadur, dayun da nirang ingkelan ti Jesus ang ipinakled tung balay ang dakulu ang yay pag̱istaran yang Gubirnadur. Pagkapakled nira, pinagtaripukpukan da nira yang kadaklan ang mga kaugpuan nirang mga sundalu. ");
INSERT INTO tbk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Numanyan yang binuat nira tung anya, pagkaluas nira yang aw̱el na, pinaablan si nira ta aw̱el ang lagwas ang mapula yang kulay na ang midyu tung suruutun ta mga adi. ");
INSERT INTO tbk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pagkatapus namangkel da ta mga balag̱en ang kalarangan ang ya ray binuat nirang binakurung ang isinuklub tung kulu ni Jesus, bilang kuruna. Pagkatapus pinapgesan ka nira dayun ta bastun-bastun tung kalima nang tuu ang buat na pa ya ray pagpailala tung kagaeman yang pagkaadi na. Pagkatapus tia, dayun da nirang pinagluud-luuran tung katalungaan na ang purus ilem tung intrimis ang maning pa tung panggalang. Pagkatapus ya ra ag̱aningay nirang “Basi pa ra ilem ang malawig ka yang kabui mung Adia yang mga Judio!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dispuis pinaglawayan da nira ang pagkatapus yang bastun-bastun ang atiang ipinapges nira tung anya, ya ray kinalaw nirang ipinamalu tung kulu na. ");
INSERT INTO tbk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Numanyan pagkatapus yang pag̱irintrimisen nirang maning tia tung anya, dayun da nirang linuas yang aw̱el ang atiang tapel ang pagkatapus yang dating aw̱el na ya si ay ipinasuut nira tung anya. Pagkatapus tia, dayun da nirang ginuyuran ang para ilansang da nira tung krus. ");
INSERT INTO tbk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Taa numanyan, tung paglua nira tung siudad, may nabag̱as nirang sasang taung tag̱a Cirene ang yay nag̱aranan tung ni Simon. Ya ray pinagreg̱es nirang pinapagsakan yang kaw̱ala yang krus ang pag̱asakan ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Numanyan nangakaw̱ut da tanira duun tung sasang lugar ang naggug̱uuyan tung Golgota ang yang linegdangan yang aran yang lugar ang atia ay kulu ta taung patay. ");
INSERT INTO tbk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Numanyan ti Jesus pinainem da rin nira ta binung linaktan nira ta bulung ang durug pakit ang para disimuladu yang siit na. Piru pagkatimtim na, anday gustu nang manginem. ");
INSERT INTO tbk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Numanyan dayun da nirang linuasan yang mga aw̱el na ang pagkatapus ilinansang da nira tung krus. Pagkalansang nira, dayun dang namagburunutan ang para maintindian da kung unu pang pidasuay yang mga aw̱el ni Jesus yang maeklan yang sasa may sasa tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pagkatapus tia, namansikarung da ilem tanira asan ang namagbantay tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tung tagbu yang kulu na may karatula ang itinaken nira ang yang nasulat asan ya ray nagpailala kung unu pay nag̱ipagbangdan tung anya. Ya taa yang isinulat asan: “Naa ti Jesus ang Adi yang mga Judio.” ");
INSERT INTO tbk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dispuis may durua ka nga ribildian ang iginapil yang mga sundalung ipinanlansang ka tung durua nga krusan ang ipinakdeng tung binit ni Jesus ang nagtimbang. ");
INSERT INTO tbk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Numanyan may mga taung pamagtaraklib-takliw̱an asan ang ya ray pamagkeyeng-keyeng ang pamagtag̱am ta insultu tung anyang mag̱aning, “Ay ra? Yawang manggew̱a tung pagtuuan tang pinakalusu ang pagkatapus pakdengan mu si ta baklu tung seled ilem tulung kaldaw, abir, ilibri mu ra asan yang sadili mu! Kung yawa matuud ang pag̱aningen ang Ana Yang Dios, abir, maglampura rang lag̱i asan tung krus!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Asta yang mga paring arabubwat ta katengdanan may yang mga sag̱ad tung mga katuw̱ulan pati yang pamagpakigmaepet ya ka, namagtag̱am da ka ta insultu tung anya ang mag̱aning, “Yang duma ipinampalibri na, piru yang sadili na pala indi na ra masarangan ang ilibri? Kung matuud ang tanya yang Adi yang nasyun tang Israel, dapat numaan ang lag̱i yag dawalay tang paglampud tung krus ug̱ud asanita ra mananged tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mag̱aning panalig tung Dios, purisu dapat ya ray magpalibri tung anya kung talagang nag̱auyunan na. Tutal tanya mismu ay nag̱aning ang tanya unu ya ra yang pag̱aningen ang Ana Yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Asta yang mga ribilding durua ang atiang ipinagngan tung anyang ipinanlansang tung mga krus, namagtag̱am da ka ta insultu tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Taa numanyan atiing pagkereng da yang kaldaw, nangiklep da yang intirung banwang atii. Baklu ngaulikay yang sadlaw na ang mga pag̱alas tris da yang apun. ");
INSERT INTO tbk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pagkatapus tung uras ang atii, ti Jesus napagkendal da ta tudu ang mag̱aning tung bitala yamen ang Hinebreo “Eli, Eli, lema sabaktani!” ang yang gustu nang ianing, “Ay Diosu, Diosu, ayw̱a pinaw̱ayaanaw ra ka ilem nuyu tani tung kalainan?” ");
INSERT INTO tbk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Numanyan yang dumang kemdengan asan, pagkagngel nira yang inaning nang atia, ya ra ag̱aningay nira, “Uay, ti Elias pala ya ray nag̱apangambayan na!” ");
INSERT INTO tbk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Atii may sa nga tauan ang lag̱i-lag̱ing naglaksung nangkel ta ipinalebleb na tung binung nangaklem da ang asta tagmak da ta binu. Pagkatagmak da, dayun na rang isinakbet tung tumbung yang maninga tigbaw ang yay itinuluy na tung nganga ni Jesus ay tag̱aman na ra rin ang panutnutun. ");
INSERT INTO tbk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Atii, mag̱aning yang duma asan, “Abir kung angayen pa ni Elias ang bawien.” ");
INSERT INTO tbk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Atii nagkendal si ta maknul ti Jesus ang ya ra kay pagkabuntuk yang linawa na. ");
INSERT INTO tbk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","52","Tung pagkabuntuk yang linawa na, yang kurtinang atiang nag̱ipagsalag̱a tung kuartung pinakasagradu duun tung pagtuuan ang pinakalusu, ya ra nga bakbak tung kasubngan na, manliit tung abwat, utas da ang asta tung sidsiren na. Pati yang kaliw̱utan nayegyeg da ka tung uras ang atii, asta yang mga batung padir nagkarabelak da ka, pati mga leyang ang pinanlug̱uran tung mga patay nagkaraabrian da ka. Durung mga tauan yang Dios ang nagkarapatay rang tukaw ang ya si kay nangabuing uman. ");
INSERT INTO tbk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Purisu namansilua ra tung pinanlug̱uran tung nira. Tung pagkabui si kang uman ni Jesus ya ra kay pagpakled nira tung Jerusalem ang yay pag̱aningen ang siudad ang sagradu. Pagkatapus durung mga taung nagkaraita tung nira. ");
INSERT INTO tbk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Numanyan duun tung pinakdengan yang mga krus, yang kapitan yang mga sundalung atiang piniaran yang Gubirnadur may yang mga aruman nang atiang pamagbantay tung ni Jesus, pagkasinti nira yang yegyeg ig pagkaita nira yang dumang nagkarainabung makabew̱ereng, pinamalayan da tanira ta eled nirang duru. Mag̱aning tanirang nangabnga, “Yang taung naa talagang ana yang Dios!” ");
INSERT INTO tbk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dispuis duun tung tukaw-tukaw durung mga baw̱ay ang pamagpaniid tung tanan ang pagkarainabu. Ya ra ka man yang mga baw̱ay ang namagpakignunut ang namagpadag̱en-dag̱en tung ni Jesus atiing pagliit na duun tung Galilea ang para mag̱angay ra duun tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Asan ka tung nira ti Mariang tag̱a Magdala may ti Mariang nanay na Santiago ni Jose may yang kasawa ni Zebedeo. ");
INSERT INTO tbk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Numanyan atiing apun da yang kaliw̱utan, may sasang manggaranen ang tag̱a Arimatea ang nagkaw̱ut da duun tung Jerusalem ang yay nag̱aranan tung ni Jose. Tan taa pa, tanya sasa kang nagpaugyat tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ti Joseng naa, diritsyu rang nag̱angay duun tung ni Gubirnadur Pilato ang nag̱ingaluk tung anya kung puiding itug̱ut na tung anya yang tinanguni ni Jesus ang para ipalg̱ud na tung leyang. ");
INSERT INTO tbk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Purisu nagkalalangan da ti Gubirnadur Pilato ang yang tinanguni ni Jesus itug̱ut da tung anya. Purisu dayun dang ipinatangtang ni Joseng pinasaw̱ed-saw̱eran ta aw̱el ang makulit ang matitinlung klasi ang pagkatapus itinuw̱ul na rang ipalg̱ud da tung sasang leyang ang baklu pa ka ilem ang ipinabangbang na tung batung padir. Pagkapalg̱ud da tung leyang, dayun na rang itinuw̱ul ang paligdan da yang purta na ta sasang batung dakulu ang pinasag̱ing binilug ang para matakepan da. Pagkatapus, dayun dang nagliit. ");
INSERT INTO tbk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Simanyan ti Mariang naang tag̱a Magdala may ti Mariang naang sam bilug, ya ray namagpabutwan duun tung pinanlug̱uran tung ni Jesus ang kumarungan tung talunga yang leyang. ");
INSERT INTO tbk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Numanyan pagkapangayag ang ya ra ka yang kaldaw ang nag̱ipamaenay tang mga Judio, naang mga paring arabubwat ta katengdanan pati naang mga Pariseo, ya ray namagpakigkesen tung ni Gubirnadur Pilato. Mag̱aning tung anya, “Maginuung Gubirnadur, nag̱ademdeman yamen ang atiing bui pa yang mandarayang atia, may sasang ibinitala na ang tanya unu mabui si kang uman tung yaklung kaldaw. ");
INSERT INTO tbk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Purisu kung magpauyuna ra ilem tung yamen, magkalalangana ra ang yang pinanlug̱uran tung anya paguardian da ta mupia ang asta malampas yang tulung kaldaw ug̱ud indi mapakleran yang mga taung pinangugyatan nang takawen yang tinanguni na, ang pagkatapus mamagbaw̱alitaen da tung mga tau ang tanya unu nabui si kang uman buat. Ay kung maabir tia, deeg na pa atiing primirung pagdaya na ang tanya unu yang pag̱aningen ang Cristo,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mag̱aning ka ti Pilatong minles, “Ala, atia ra ka yang mga sundalung mamagguardia. Pangkelan mi ra duun tung pinanlug̱uran tung taung atia. Ya ray pabantayan mi tung nira ta mupia ang kumpurming kayanan ming rimidyuan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Purisu numanyan dayun dang namansiliit ang namansiangay duun tung pinanlug̱uran tung ni Jesus. Pagkatapus yang batung atiang itinakep ya ray pinabuatan da nira ta talandaan ang para maintindian da nira kung may nagtagyu. Pagkatapus itinalig da nira tung mga sundalung atiang pinabantayan. ");
INSERT INTO tbk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Taa numanyan pagkataklib da yang kaldaw ang atiang nag̱ipamaenay ang baklu pa ilem agpandiklat yang sag̱iid tung primirung kaldaw tung seled yang sang linggu, bilang kaldaw ta Linggu, ti Mariang naang tag̱a Magdala may ti Maria kang naang sam bilug, ya si kay namagbalik duun tung pinanlug̱uran tung ni Jesus ang para mamanginsapu si. ");
INSERT INTO tbk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Numanyan may maktel ang yegyeg ay natetenged tung sasang angil ang tinuw̱ul yang Dios ang magparanek duun ang pagkatapus dayun na rang pinalig̱id yang batung atiang itinakep tung pinanlug̱uran ang ya ra ka man dayun ay pinamdungan na. ");
INSERT INTO tbk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Durug kasusulaw ang telengan ang maning pa tung kidlat, pati yang aw̱el na maninga sipsak agkakulit. ");
INSERT INTO tbk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Numanyan yang mga sundalung atiang pamagbantay, pagkaita nira tung anya, durung pagpangerel nira natetenged tung eled nirang subra. Pagkatapus dayun da ilem ang namansitumba tung tanek ang maninga patay ra. ");
INSERT INTO tbk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Numanyan dayun dang nagbugnu yang angil tung mga baw̱ay ang atiang durua ang baklung nansikaw̱ut ang mag̱aning, “Ta yamu, indiamu ra mag̱eled. Nag̱askeanu ang yang nag̱adilem mi taa ti Jesus ang ilinansang tung krus. ");
INSERT INTO tbk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anda ra taa ay pinabungkaras da yang Dios ang katulad ka tung inaning na. Palengetamu ra kanay tani. Telengan mi w̱a yang pinagpalw̱ug̱an tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pagkatapus pakaliamu rang mangay duun tung mga taung nag̱apangugyatan nang panganingen ang ti Jesus binui si kang uman yang Dios ang pagkatapus numanyan nagtukaw ra tung nira duun tung Galilea. Purisu duun da ka tanira mamanikad tung anyang para mag̱irita si ka tanira. Buinu, tandaan mi ta maayen yang itinuyunung atia tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Purisu numanyan namag̱apura ra ka man tanirang namagliit duun tung pinanlug̱uran tung ni Jesus. Maskin pangetab-ketaw̱an da ka man ta mupia natetenged tung naita nirang atia, piru durung pisan agkasadya yang mga isip nirang pamagralaksuan ang para magbaw̱alitaen da tung yamen ang pinangugyatan ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Numanyan tung pagralaksuen nira, unaw̱is ti Jesus mismu ya ray nagpakigbag̱as tung nira. Mag̱aning tung nirang nagbugnu, “Mupiang kaldaw tung numyu!” Pagkatapus dayun da nirang pinalengtan ang pinggesan tung mga kakay na ang nunut da ka ta pagluud nira. ");
INSERT INTO tbk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mag̱aning ti Jesus ang nagpadayun yang bitala na tung nira, “Indiamu ilem mag̱eled, aa? Angayen mi ra kanay yang mga putulung panganingen ang tanira kaministiran dang mamansiangay ra duun tung Galilea ug̱ud duunami ra mag̱irita,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Taa simanyan mintras pamansiangay ra yang mga baw̱ay ang atia duun tung mga tauan ni Jesus, yang dumang mga sundalung naang pinapagbantay tung pinanlug̱uran tung ni Jesus, ya ray nansibalik tung siudad ang namag̱ugtulun da tung mga paring atiang arabubwat ta katengdanan natetenged tung tanan ang nagkarainabu. ");
INSERT INTO tbk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Numanyan dayun dang namagsaragpun tanira yang mga pamagpakigmaepet ang namagparaig̱u. Pagkatapus ta pagparaig̱u nira, dayun dang namagpakdul ta bastanting kuarta tung mga sundalung atia ang nunut da ka ta paetad tung nira ang mag̱aning, “Kung tinu pay manginsapu tung numyu, yamu ra ilem ag̱aaning ang yang tinanguni na tinakaw ra ta law̱ii yang mga taung pinangugyatan na ang ya ray nangasubli tung elek mi. ");
INSERT INTO tbk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kung alimbawa mabalitaan da ni Gubirnadur, yami ray balang mangerengan para tung numyu ang ta yamu anday kasalanan mi ug̱ud anda ray mabegbeg̱an ta mga kulu mi para tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kapurisu pagrisibi nira yang kuarta, inusuy ra ka man nira yang kumpurming ipinaetad tung nirang namagbaw̱alitaen. Purisu ang asta ra ilem simanyan maning ka man tia yang nag̱ibalita-w̱alita yang mga masigka Judio ta. ");
INSERT INTO tbk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Numanyan yaming pinangugyatan ni Jesus ang sam puluk may sasa, nag̱angayami ra ka man tung Galilea, duun tung sasang bukid ang ya ra kang lag̱i ay ipinaske ni Jesus tung yamen tan taa pa ang para duunami ra magbarag̱as. ");
INSERT INTO tbk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkaita yamen tung anya, maskin indi pa nag̱asigurung pisan yamen ang ya ra ka man ti Jesus, dayunami ra ka enged ang nagluud ang nagtuu tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pagkatapus dayunami rang pinalengtan nang inaning, “Yang tanan ang bag̱ay mag̱ing tung kalangitan, mag̱ing tung katanekan man, luw̱us dang ipinabtang yang Dios tung pudiru. ");
INSERT INTO tbk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Purisu magliliw̱utunamung magparakaw̱utun natetenged tung yeen tung tanan ang nasyun tung bilug ang kaliw̱utan ug̱ud mapakdulan da ta lugar nirang magsuku ra tung yeen ang para mag̱ing mga tauanu ka. Kumpurming tinu pay magsuku tung yeen, ya ray benyag̱an mi ug̱ud asan da nga pananglitay na ang tanya nagpagaem dang matuud tung ni Ama may tung yeen ang pag̱aningen nang Ana na may tung Espiritu Santo ang yami ra ka man ay may anya tung anya. ");
INSERT INTO tbk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Dispuis panuldukan mi ka dayun ta mupia ang mamagtuman yang kumpurming itinuw̱ulu tung numyu. Yang tanan ang atia ya ray prusigiran mi ay yuu mismu ay magpakigsasa tung numyung pirmi ang asta kaw̱utun da ilem yang uras ang ipagtapus yang Dios tung panimpung naa,” mag̱aning duun ti Jesus.");
INSERT INTO tbk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yang nag̱ibalitang naang durug tinlu natetenged tung ni Jesu-Cristong yay pag̱aningen ang Ana Yang Dios, maning taa yang pinangapunglan na. ");
INSERT INTO tbk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Atiing tukaw, may sasang isinulat ni Isaias ang sasang manigpalatay yang bitala yang Dios. Duun napabtang yang inaning yang Dios tung sasang tuw̱ulun na ang mag̱aning, “May taung tuw̱ulunung magpalatay yang bitalaw ang yay ipatkawu tung nuyu ug̱ud yay magliway tung mga kinaisipan yang mga tau ang para mampauyun da tung nuyu. ");
INSERT INTO tbk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Duun tung banwang kapas magparakaw̱utun tung mga tau ta maning taa: ‘Katulad ka tung pagsirimpanen tung sasang dalan ang panawan ta sasang Adi ang yag tadlengay, kaministiran kang simpanen mi ra ka ta mupiang tadlengen yang mga kinaisipan mi ang para magpauyunamu ra tung ni Ginuu tang magkakaw̱ut,’” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kapurisu, kumus maning tia yang naula, duun da nagkamatuud tung paglua ni Juan ang manigbenyag duun tung banwang kapas. Nagparakaw̱utun da tung mga tau ang mag̱aning, “Manlignaamu ra tung mga kasalanan ming magbalik tung Dios ang pagkatapus ya ra kay papruibaan ming magpabenyag ug̱ud patawarenamu ra anya,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Duru-durung mga taung tag̱a Judea may tag̱a Jerusalem ang namag̱arangay-angayan duun tung ni Juan. Numanyan kumpurming tinu pay nangamin yang mga kasalanan na tung Dios, ya ra kay binenyag̱an na duun tung subang atiang pag̱aningen ang Jordan. ");
INSERT INTO tbk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ti Juan ang naa, yang aw̱el na balayw̱u ta pag̱aningen ang kamilyu ang inubra tung tiral. Yang akes na ulit ta sasang ayep. Yang pamangan na apan ang maglutukun na may lanaw. ");
INSERT INTO tbk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Numanyan may nag̱ipagpakaw̱ut na tung mga tau ang maning taa: “May sasang taung nag̱auri pa tung yeen ang ya pay mas abwat ta katengdanan tung yeen. Indiaung pisan magkabag̱ay tung anya basin nganing tung pag̱uw̱ad da ilem yang lakgeng yang sandalyas na. ");
INSERT INTO tbk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kung tung bag̱ay, sigun tung katengdananu ka man, pagpamenyag̱aw tung numyu taa tung waing naa ug̱ud simpanamu rang magrisibi tung anya. Piru yang anyang katengdanan, maning pa tung magberenyag̱en ka tung numyu ekel tung pagpatinir na tung numyu yang Espiritu Santo,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Taa numanyan, tung mga uras ang atii, ti Jesus nagliit da duun tung lansangan ang Nazaret ang lug̱ud tung sinakepan yang Galilea ug̱ud mangay ra ka duun tung ni Juan. Pagkaw̱ut na duun, dayun dang nagpabenyag tung anya tung subang atiang pag̱aningen ang Jordan. ");
INSERT INTO tbk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tamang tamang magpatakas da ti Jesus, ya ray natingara na yang langit ang gulpi ra ilem ang nag̱abri tung tagbu na ang pagkatapus ya ray naita na yang Espiritu Santong napapariu ra tung kuari kalapati ang paparanek da ang asta nangapun da tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Atii may busis da ang liit tung langit ang mag̱aning, “Yaway pag̱aningenung anaw ang nag̱apabuyukanu ta gegmaw ay yawa ra kang lag̱i ay nag̱auyunanu ta mupia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pagkatapus tia, yang Espiritu Santo ya ray nagmangulu tung anyang nagpapanaw duun tung banwang kapas. ");
INSERT INTO tbk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tinag̱aman da ni Satanas ta tuksu tung seled epat ang puluk ang kaldaw duun tung banwang atii, ang yang mga ugpu ni Jesus duun pulus ilem mga dayamdam. Pagkatapus tia may mga angil ang namag̱arasikasuen da tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Taa numanyan, atiing nakalabus da ti Juan ang manigbenyag, ti Jesus tanya, nagbalik da duun tung sinakepan yang Galilea. Duun da nagparakaw̱utun tung mga tau yang Matinlung Balita ang ya ra ka man ay itinalig yang Dios tung anyang ipagpakaw̱ut. ");
INSERT INTO tbk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Maning taa yang ipinagpakaw̱ut na tung nira: “Kinaw̱ut da yang uras ang atiing ipinaula yang Dios atiing tukaw ang ya ray ipagpundar na yang paggaraemen nang baklu tung numyu. Purisu manlignaamu ra tung mga kasalanan ming magbalik tung anya ig manangeramu ra ka tung balitang naang nag̱ipagpakaw̱utu tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Taa numanyan, atiing pagbakay ni Jesus tung aw̱uyuk ang atiang lug̱ud tung sinakepan yang Galilea, naita na ti Simon duruang mag̱ari ni Andres ang pamanlaman ta ian ay tanira mga manig̱ian. ");
INSERT INTO tbk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mag̱aning ti Jesus tung nirang nagbugnu, “Magpakignunutamu ra tung yeen ang magpaugyat. Dati-rati yang mag̱eklan mi ian. Piru numanyan ugyatanamu ra yeen kung ya pa ag̱aring maeklan mi yang mga isip yang mga tau ang basi pa ra ilem ang magsuku ka tung yeen ug̱ud basi pa ra ilem magpaugyat da ka tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Numanyan lag̱i-lag̱ing binutwanan da nira yang mga laman nirang namagpakignunut da tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Numanyan matukaw-tukaw tanira na Jesus ta gesye, naita na ti Santiago duruang mag̱ari ni Juan ang yay mga ana ni Zebedeo. Asan tanira tung balangay nirang pamag̱eet yang mga laman nira. Numanyan pagkaita ni Jesus tung nira, dayun na rang binteng ang mamagpakignunut da ka tung anyang para mag̱ing mga tauan na ka. ");
INSERT INTO tbk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Numanyan lag̱i-lag̱ing binutwanan da nira ti Zebedeo ang tatay nira asan tung balangay, kasiraan da ka tanira yang mga tauan na. Ay tanirang durua namagpakignunut da ka tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Taa numanyan, diritsyu rang nansiangay tanira duun tung lansangan ang Capernaum. Numanyan pagkaw̱ut yang kaldaw ang nag̱ipamaenay, nagpakled da ti Jesus tung balay ang pagsaragpun-sagpunan yamen ang mga Judio ang para magturuldukanen tung mga taung pamag̱intindi tung Dios asan. ");
INSERT INTO tbk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Numanyan tung pagpamati nira tung anya, nangabereng da ta mupia tung pasais nang nagturuldukun tung nira. Ay ya pa ag̱ari, yang pagturuldukun na, may builu nang maktel ang yay pagpailala ang may katengdanan na ka man ang ipinakdul yang Dios tung anya. Belag̱an pariu tung pasais yang mga sag̱ad ang pagturuldukun tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Numanyan duun tung pagsaragpunan ang atii, may taung pag̱aekel-ekelan ta dimunyu ang ya ray naglelpaken ang mag̱aning, “Ay Jesus ang tag̱a Nazaret, ayw̱a ag̱apasilabtanami pa nuyu? Ayw̱a, yaming mga dimunyu, yami ray katuyuan mu ang para diaduenami ra nuyu? Sampa india mailalaw. Yawa yang pinilik yang Dios ang magpundar yang paggaraemen nang baklu.” ");
INSERT INTO tbk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Atii, dayun dang sinambeng ni Jesus ang inaning, “Ipes! maglayasa ra ilem asan!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Atii, yang dimunyu dayun na rang linuw̱ag yang tinanguni yang taung atia, ang pagkatapus tung paglayas na tung anya, ya ra kay paglelpaken na ta maknul. ");
INSERT INTO tbk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pagkaita yang mga tau, nangabereng da ta mupia tanirang tanan. Namag̱araning-aningan da ang, “Unu pa w̱asu? Baklu ilem ngagngelay ta yang maning tiang nag̱ipagpakaw̱ut! Yang taung naa may katengdanan nang magkalalangan tung mga dimunyu ang pagkatapus atiang lag̱i pananged da!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kapurisu yang balita natetenged tung binuat ni Jesus ang atia, makali ilem ang nanlakted-lakted tung intirung sinakepan yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Taa numanyan, dayun dang nansilua na Jesus tung pagsaragpunan ang atia ang nansiangay duun tung balay ni Simon durua ni Andres, kasiraan da ka tanira ni Santiago durua ni Juan. ");
INSERT INTO tbk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kaw̱utan nira, naa pala, yang punyangan ni Simon ang baw̱ay yag lulw̱ug ay agkiniten. Purisu ti Jesus, ya ray inugtulan nira. ");
INSERT INTO tbk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Purisu dayun dang pinalengtan ni Jesus ang pinggesan tung kalima nang binangun. Lag̱i-lag̱ing naumpawan da yang maepet ang pagkatapus dayun dang nagsimpan ta mapapaan na tung mga bisita na. ");
INSERT INTO tbk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Taa numanyan, atiing pagsantek da yang kaldaw, duru-durung mga taung may mga laru pati yang duma ang agdimunyuen ang ya ray ipinampadangep yang mga aruman nira tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pagkatapus alus pa ilem yang tanan ang mga tau tung lansangan ang atia namagsaragpun da duun tung talungaan yang balay. ");
INSERT INTO tbk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tung uras ang atii, dakele yang namaglaru ta sari-sari ang pinampamaayen ni Jesus, pati mga dimunyu dakele ka yang pinampalayas na. Gustu ra rin yang mga dimunyung atia ang mamagbaw̱alitaen da natetenged tung anya ay natetenged nag̱ailala ra nira kung tinu pa. Piru indi na ra tinugtan. ");
INSERT INTO tbk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Taa numanyan, atiing sam parti pang mangayag, nagbangun da ti Jesus ang nagpaag̱es duun tung sasang lugar ang anday tatau na ig duun da nag̱intra pag̱arampuen tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Numanyan, pagkapuaw na Simon, dayun da nirang sinagyap. ");
INSERT INTO tbk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkaita nira, dayun da nirang inaning ang, “Abee, panduua ra taa? Nag̱adarawala ra ta durung tau!” ");
INSERT INTO tbk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mag̱aning ti Jesus ang nagtimales, “Amus ta ra. Magpalaluyita ra tung dumang mga lansangan ang alelengeten ug̱ud duunaw ra ka magparakaw̱utun, ay ya ra kang lag̱i ay katuyuanu taa,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kapurisu numanyan nagliliw̱utun da ka man ti Jesus tung intirung sinakepan yang Galilea ang nagparakaw̱utun tung mga tau ang kada mamagsaragpun tung nira-nirang mga pagsaragpunan. Dispuis nagparalayasen da ka tung mga dimunyung namagsuut tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taa numanyan, may sasang taung nagpalenget da tung anya ang may dispirinsia tung ulit nang makamamansa. Dayun dang nagluud tung pinagtalungaan nirang durua ang nagpakiildaw tung anyang mag̱aning, “Ameey, kung malelyag̱a ilem, nag̱askeanung sarangan mung kuaten tung yeen yang dispirinsiaung naa ang yay pagpamansa tung pagkatauu,” ag̱aaning tanya. ");
INSERT INTO tbk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pagkagngel ni Jesus tia, ya ra ngaildaw. Dayun na rang dineenan ang inaning, “Ag̱alelyag̱aw ka, kuatana ra yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lag̱i-lag̱ing nakuatan da ka man yang dispirinsia nang atia. ");
INSERT INTO tbk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Numanyan, atiang lag̱i, pinaliit da ni Jesus ang pinapanaw. Baklu paliitay na, pinagpaamanan na ta malebat-lebat ang bitala ang inaning, “Kuidaw, india ra enged magbaw̱alitaen, maskin tung ninu pa natetenged tung binuatung atia tung nuyu. Anday dumang buaten mu, mag̱angaya ra kanay duun tung sasang pari ang magpateleng ang yawa limpiu ra. Pagkatapus magpadasag̱a ra ka dayun tung anya ta sasang ayep ang iprisintar na tung Dios ang katulad ka tung urdinansang ibinutwan ni Moises ang tukaw ug̱ud asan da nga kumpurmiay yang mga tau ang anda ray dapat ang likayan nira tung nuyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pagkatapus numanyan, pagliit yang taung atia, belag ya mananged tung ipinaaman ni Jesus tung anya, ya mag̱intra baw̱alitaen tung maskin tinu pang tauay. Kapurisu kumus sarambung da yang balita, anday dumang pinakaw̱ut na, indi puiding magpanayang-nayang ti Jesus ang magpakled tung mga lansangan, kung indi, duun da ilem tung lua ang anday mga balay. Piru maskin maning tia, sigi ilem yang pag̱arangayen yang mga tau tung anya ang maskin tag̱a ay pang lugaray. ");
INSERT INTO tbk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Taa numanyan, tung pira pang kaldaw, atiing pagbalik da ni Jesus duun tung lansangan ang Capernaum, nagsarambung da yang balita ang tanya unu duun da tung balay. ");
INSERT INTO tbk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Durug dakel yang mga taung namagsaragpun asan ang asta naggetek da ilem. Maskin pa tung talunga yang purta, anda ray masaleetan. Numanyan ti Jesus nagparakaw̱utun da tung nira natetenged tung paggaraemen yang Dios ang naang baklung pag̱atukud na. ");
INSERT INTO tbk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Numanyan may epat nga tauan ang baklung namansikaw̱ut ang may ekel nirang sasang taung pamamilay ra yang mga tinanguni na. Ya rag tuang-tuangay nirang nag̱idangep tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Numanyan, atiing indi mapalenget nira tung anya natetenged tung mga taung atiang getek dang pisan, anday dumang rimidyung binuat nira, kung indi, itinakwal da ilem nira duun tung aldan ang panganing tung sagpaw yang balay. Pagkatapus tung tagbu ni Jesus, ya ray pinangukab nirang inabrian ang pagkatapus duun da ipapanaway nirang ituntunay yang papag ang nag̱aluw̱ug̱an yang aruman nira. ");
INSERT INTO tbk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Numanyan, pagkasiman ni Jesus ang tanira may pagtalig nira tung anya, dayun na rang binugnu yang aruman nirang atiang pamamilay yang mga tinanguni nang inaning, “Duduy, nag̱apatawara ra yeen tung mga kasalanan mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Numanyan may mga sag̱ad ang kumarungan asan. Pagkagngel nira yang inaning ni Jesus tung taung atia ang maning tii, ya ray ipinagkesen-kesen nira tung mga isip nira ta maning taa: ");
INSERT INTO tbk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Abaa, yang tau kang naa ka, ayw̱at maning da takaa yang nag̱ianing na? Talagang ya ra pagtiwakaway na yang pagkadios yang Dios! Ayw̱a, tinu pa pay sarang ang magpatawad tung mga tau tung mga kasalanan nira kung belag̱an ultimu ilem yang Dios?” ");
INSERT INTO tbk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kumus nag̱adeep dang lag̱i ni Jesus ang maning da tia yang laksu yang pagparainu-inuen nira, dayun na rang binugnung inaning, “Ayw̱a maning da tia yang nag̱ipagkesen-kesen mi tung mga isip mi? ");
INSERT INTO tbk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kanisip mi ang sungaw ilem yang inaningung atia tung taung naang pamamilay yang mga tinanguni na ang pinatawaru ra tung mga kasalanan na? Piru kung aningenu si ang magbangun dang mag̱ekel yang papag nang magpanaw, asan da ngaskeay mi kung yang bitalaw sungaw ilem u kung may kamatuuran na. ");
INSERT INTO tbk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Purisu papruibaanu ra numanyan tung numyu ang yuung pag̱aningen ang Maninga Tau, may katengdananu ka man taa tung katanekan ang magpatawad tung mga tau tung mga kasalanan nira,” mag̱aning. Pagkatapus, diritsyu rang pinag̱aning na yang taung atiang pamamilay yang mga tinanguni na, “Ala, magbanguna ra. Eklan mu ra atiang papag mung mulik,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Atii, diritsyu rang nagbangun yang taung atia ang pagkatapus ingkelan na ra yang papag nang luminua tung katalungaan nirang tanan. Purisu nangabereng da ta mupia tanira ang nunut da ka ta pagdarayawen nira tung Dios. Namag̱araning-aningan dang, “Bakluita ilem naita ta maning tia!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Taa numanyan, dayun dang naglampud ti Jesus tung balay ang nagpabakayan si. Numanyan may mga taung buntun ang namag̱arangay-angayan da tung anya ang ya ra kay pinanuldukan na natetenged tung bitala yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Numanyan tung pagbakay na, naita na yang sasang taung nag̱aranan tung ni Levi ang yay ana ni Alfeo. Yag kakarung tung upisina nang pagpanukut tung mga tau yang mga balayaran nira tung gubirnu. Mag̱aning ti Jesus ang nagbugnu tung anya, “Amus, magpakignunuta ra tung yeen ang magpaugyat,” mag̱aning. Atii, dayun dang kumindeng ti Levi ang nagpakignunut tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Taa numanyan, nagkamaning da ang ti Jesus pagpakigsaru ra duun tung balay ni Levi, kasiraan da ka tanira yang mga taung nag̱apangugyatan nang dati. Dispuis duru kang mga manigpanukut ta balayaran tung gubirnu ang pamagpakisaru ka tung na Jesus, kasiraan da ka tanira yang duma ang parariung nag̱alamku ka ta duma ang durug kakinasalananen, Namagpakisaru ra ka ngani tanira tung ni Jesus ay durung mga taung mga maning tiang klasi ang kadagmitan ang pamagnunut-nunut da kang lag̱i tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Taa numanyan may mga sag̱ad tung mga urdinansa asan ang pamagpaniid. Tanira mga pamagmangulung mga kinasakpan yang sasang grupung nag̱aranan tung mga Pariseo. Numanyan, pagkaita nira tung ni Jesus ang pagpakigsaru ra ka man tung mga manigpanukut pati mga ugpu nirang parariung pag̱atelengan nirang makinasalananen, dayun dang inistinggir nira yang mga tauan ni Jesus ang dati ang inaning, “Ba tia, ayw̱a asan dag pagpakigsaru yang ag̱alen mi tung mga manigpanukut ang atia may tung mga ugpu nirang duru kag kakinasalananen?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Numanyan, pagkadngel ni Jesus tia, ya ray nagtuw̱al ang asan da ipapanaway na tung sasang pananglit ang mag̱aning, “Yang mga taung makektel anday kaministiran nira yang manigbulung, kung indi, ya ra ilem yang may mga laru. Katulad ka tung yeen, ay yang inangayung mag̱imbitaren ang para mag̱ing mga tauanu, belag̱an yang mga taung pagtalig tung mga sadili nira ang tanira matadleng da tung pagterelengen yang Dios, kung indi, ya ra ilem yang kumpurming tinu pay mangamin ang tanya talagang makinasalananen ka man,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Taa numanyan, tung mga uras ang atii, may mga taung nag̱apangugyatan ni Juan ang manigbenyag pati mga taung nag̱apangugyatan yang mga Pariseo ang parariung pamamlek tung pagparanganen nira ang para tung ikabilug yang mga isip nirang pamag̱ampu tung Dios sigun tung sasang urdinansa. Numanyan may mga taung duma ang namagpalenget tung ni Jesus ang namagkig̱a tung anyang mag̱aning, “Yang mga taung nag̱apangugyatan ni Juan ang manigbenyag may yang mga nag̱apangugyatan yang mga Pariseo, parariung pamamlek tung pagparanganen nira. Ayw̱a kaya yang mga taung nag̱apangugyatan mu indi pala pamag̱usuy?” ");
INSERT INTO tbk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tung tuw̱al ni Jesus tung nira, yang sadili na ipinananglit na tung sasang laliing pangasawa. Ag̱aaning tung nira, “Ayw̱a, kung may kumbira, magkabag̱ay w̱asu ang yang mga laliing pamagkumpanya tung pangasawa, mamamlek da tung pagparanganen nira mintras asan pa tung tepad nira yang aruman nira? Simpri mintras asan pa tung nira, indi puiding mamamlek tung pagparanganen nira, kung indi, mamagpakigsaru ka enged tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piru may uras ang kaw̱utun ang yang aruman nirang atia lag̱unutun dang eklan tung tepad nira. Kung kaw̱utun da nganing yang uras ang atia, ya ray uras ang ipamlek nira tung pagparanganen nira natetenged tung kapupungawen da nirang duru. ");
INSERT INTO tbk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ayw̱a, tinu pay nag̱aintindian ming tau ang yang aw̱el nang lag̱i-lag̱i ra ya pa kay tambelan na ta aw̱el ang baklu ang indi pa nag̱abunakan? Kipurki kung maning tia ya pay buaten na, anday dumang mainabu, kung bunakan na ra nganing yang aw̱el nang atiang tinambelan na, bekngen da ka ilem yang baklung itinambel nang nagkere ang asta mas dang magdakul yang lasik na kay tung primiru. ");
INSERT INTO tbk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dispuis, tinu pay nag̱aintindian ming tau ang yang binung baklung ingkelan tung saralug̱an, asan da ilem papagbaalay na tung parabtangan ang lag̱i-lag̱i ra? Kipurki kung maning tia ya pay buaten na, kung mabaal da nganing yang binu, belaken na ra ka ilem yang parabtangan. Anday duma, mailas da ka ilem yang binu, pati yang parabtangan, diadu ra ka. Yang pisan ay kaalimbawaan yang nag̱ituldukung naang baklu. Indi magkatunu tung dating nag̱usuyun mi ang katulad ka tung pamlek mi tung pagparanganen mi. Kung indi, mas maayen pa ang yang binung baklu, asan da ibukbukay tung parabtangan ang baklu ka,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Taa numanyan, may mininsa ang ti Jesus napanaw ra tung dalan ang naknga tung katriguan tung kaldaw ang nag̱ipamaenay tung mga pag̱urubraen, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. Numanyan yang pagparanawen nira asan, ya kay aplut-aplut nira yang mga kaluay yang trigu ang para mangapagsengat-sengat da. ");
INSERT INTO tbk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Numanyan may mga Pariseo asan ang ya ray namag̱istinggir tung ni Jesus ang mag̱aning, “Ba tia, ayw̱at pamaglampas da yang mga taung atiang nag̱apangugyatan mu tung urdinansa ta ang anday mag̱urubraen ta maning tia tung kaldaw ang nag̱ipamaenay?” ");
INSERT INTO tbk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Mag̱aning ka ti Jesus ang nagtimales, “Ayw̱a, indi mi pa ka enged nag̱amaresmesan yang sasang napabtang tung kasulatan natetenged tung sasang binuat ni David atiing alang-alang da yang pagkabetang nang duru rang atiing suw̱uk na pati mga aruman na? Indi w̱a, nagpakled duun tung balay-w̱alay ang atiing pinagtuuan pa rin nira tung Dios atiing ti Abiatar yang paring pinakalandaw? Pagkatapus pinangan na yang tinapay ang atiing sagradu ang ya ag̱ipabtangay tung katalungaan yang Dios ang ya pa ka man ay bawal ang panganen ta duma ang belag̱an mga pari. Piru maskin bawal, ya pay pinangan na ig ipinapaan na pa ka nganing tung mga aruman na, ang pagkatapus indi ka ipinakusalak yang Dios tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nani pa yang dapat ang demdemen ta. Ang sigun tung kaldaw ang nag̱ipamaenay, binuat nganing yang Dios ang para tung ikaayen yang mga tau. Belag̱an ang mag̱aning ang yang mga tau inimu na ang para tung ikaayen yang kaldaw ang atia. ");
INSERT INTO tbk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Purisu yuung pag̱aningen ang Maninga Tau, yuu ray pamala tung mga tauanu kung ya pa ag̱ari yang pag̱urusuyun nira tung katuw̱ulan yang Dios natetenged tung kaldaw ang nag̱ipamaenay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Taa numanyan, nagpakled si ti Jesus tung pagsaragpunan nira. Duun ka may taung napilayan da yang kalima nang sam belak. ");
INSERT INTO tbk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","May duun kang mga Pariseo ang pamagmalung ta maayen tung ni Jesus kung magpamaayen tung napilayan tung kaldaw ang atiang nag̱ipamaenay ug̱ud yang pag̱urubraen nang atia ya ray ipagpakusalak nira tung anyang ipagdimanda tung ustisia. ");
INSERT INTO tbk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Numanyan, dayun dang binugnu ni Jesus yang taung atiang napilayan ang inaning, “Ala, kemdenga ra kanay ang mangay tani tung parada,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagkatapus dayun dang nagpaisip tung mga taung atiang pamagmalung tung anya ang mag̱aning, “Ay pa w̱asu ay magkatamang buaten tung kaldaw ang nag̱ipamaenay ang ita magbuat ta ikaayen ta sasang masigkatau tang ilibri tung malain u ang ita magbuat ta ikalain ta sasang masigkatau ta ang yay magakdan na yang kamatayen na?” mag̱aning. Piru indi ra namag̱iw̱ek-iw̱ek tanira. ");
INSERT INTO tbk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Numanyan tung paneleng-teleng na tung nira, ya ra ngaerepay ang inampayan da ka dayun ta kapupungawen nang duru natetenged tung kateteg̱asen yang mga isip nirang imbitaren tung matinlu. Numanyan dayun na rang inaning yang napilayan ang, “Ala, iunat mu ra tiang kalima mu,” ag̱aaning. Tamang-tamang ag̱iunat na, naulikan dang pisan yang kalima na. ");
INSERT INTO tbk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Atii, dayun dang namaglua yang mga Pariseong namagpakiksen dang lag̱i tung mga partidu ni Adi Herodes ang duma. Yang pinag̱unta-untaan nira, kung ya pa ag̱aring mapaimatay nira ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Taa numanyan nagpalikay ra ti Jesus ang minangay duun tung bakayan yang aw̱uyuk, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. Buntun ang pisan yang mga taung namagpakignunut tung anya. May mga tag̱a Galilea, may mga tag̱a Judea, may mga tag̱a Jerusalem, may mga tag̱a Idumea, may mga tag̱a duw̱ali yang subang atiang pag̱aningen ang Jordan, may mga taung duun mamansiliit tung kakunayungan yang siudad yang Tiro may Sidon. Yang inangay yang mga taung atiang durug damel tung anya, nagkarabalitaan da natetenged tung nagkarabuat na. ");
INSERT INTO tbk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kumus namanlag̱em da ilem asan yang mga taung atia, nanuw̱ul da ti Jesus tung mga taung atiang nag̱apangugyatan na ang tanya simpanan da kanay nira ta balangay ang kung may kaministiran na, ya ray saayan nang magpadistansia ta gesye ang para indi makipit yang mga taung atiang buntun ang pamagdarag̱umukan da tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ay ya pa ag̱ari, kumus dakele ra yang pinampamaayen na, yang kadaklan ang may mga laru, sigi ra ilem yang pagsarageseg̱an nira tung anya ang basta madeen da ilem tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pati yang mga dimunyung pagkemkem tung duma, kada maita nira ti Jesus, ya rag papadagpa tung katalungaan nang paglelpaken da ang mag̱aning, “Talagang yawa ka man yang pag̱aningen ang Ana Yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kada mag̱ilala tung anya ta maning tia, dayun na rang linalangan ang indi ra enged magpaske natetenged tung anya kung tinu pa. ");
INSERT INTO tbk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Taa numanyan, nanungul da ti Jesus duun tung napabukatud. Baklu nanungul, kumpurming tinu pay nalelyag̱an na, ya ray inimbitar nang mamagnunut tung anya. Pagkatapus namagpakignunut da ka man tung anyang namanungul. ");
INSERT INTO tbk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Pagkaw̱ut nira duun, dayun dang tinulduk nang mag̱ing mga apustul na ang para ya ray mamagpakiugpu rang pirmi tung anya kag yadwa pa ang para panuw̱ulun nang mamagparakaw̱utun yang bitala na tung mga tau. Ya ra kay pamakdulan na ta kagaeman nirang mamagpalayas tung mga dimunyung namagsuut tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sam puluk may durua nga tauan ang pinamilik na ang ya ra taa yang mga aran nira. Ti Simon ang ya ray pinapuanggaan na tung ni Pedro. ");
INSERT INTO tbk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yang magdasun, ya ra ti Santiago durua tanirang mag̱ari ni Juan ang yay mga ana ni Zebedeo. Tanirang mag̱ari ya ray pinapuanggaan ni Jesus tung “Boanerges” ang yang gustu nang ianing mainerepen ang pagkatau ang maning pa tung duldul ang ya ra ag̱erepay ang magbitala. ");
INSERT INTO tbk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yang magdarasun, ya ra ti Andres, ti Felipe, ti Bartolome, ti Mateo, ti Tomas, ti Santiagong atiang sam bilug ang yay ana ni Alfeo, ti Tadeo, may ti Simon ang atiang sam bilug ang kinasakpan da rin yang sasang partidung durug iseg yang pagbaratukun nira tung gubirnu yang mga tag̱a Roma. ");
INSERT INTO tbk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yang magdasun pa, ya ra ti Judas Iscariote ang tung uri, ya ra ka man ay nagtraidur tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Taa numanyan, ti Jesus, nagbalik da duun tung balay ang pag̱atiniran na, kasiraan da ka tanira yang mga tauan na. Numanyan dinag̱umukan si ta mga taung buntun ang asta anda ray lugar na Jesus ang mamamangan. ");
INSERT INTO tbk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Numanyan pagkabalita ni nanay na may yang mga putul na duun tung Nazaret ang maning da tii yang pagkabetang na, ya ra ag̱aningay nirang nag̱abariadu-bariadu ra. Purisu ya ray ipinanuldak nira tung lansangan ang para eklan nirang ipaulik. ");
INSERT INTO tbk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Taa numanyan, may mga sag̱ad ang nangakaw̱ut da ang duun mamanliit tung siudad ang Jerusalem. Pamagbangdan kang lag̱i tung ni Jesus ang mag̱aning “Nag̱aekel-ekelan ni Satanas yang taung atia! Bilang yang pagpamangulu tung mga dimunyu yay pagpakdul tung anya ta kagaeman nang pagpalayas tung nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kapurisu pinaguuyan da ni Jesus yang mga sag̱ad ang atiang pinagngelan ta mga pananglit ang mag̱aning, “Ayw̱a, magkatama w̱asu ang yang sasang taung nag̱apaktel ni Satanas, tung anya pa ipampalayasay na yang mga dimunyung yay mga kinasakpan na? ");
INSERT INTO tbk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Dispuis kung may sasang inadian ang mamagkuruntraan dang mamagbaratukan yang mga kinasakpan na, indi ra ka ilem magdayun yang inadian ang atia. ");
INSERT INTO tbk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Maskin tung sam pamilya, kung magdarapig-dapig̱an da tanirang magsuruay-suayan, diadu ra ka yang pagsarasaan nira. ");
INSERT INTO tbk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pariu ka tung ni Satanas. Kung ya pag batukay na yang mga dimunyung atiang nag̱amanguluan na ang asta magsuruag-suag̱an da tanira, ig disir, indi ra rin magdayun yang paggaraemen na, kung indi, ya ra nga tapus da rin. ");
INSERT INTO tbk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kung indi, yang pagkinuntraay yamen ni Satanas, ay maning taa tung pananglit ang naa. Kung may sasang mupiang lalii, anday makled tung balay na ang para mag̱akwat da rin tung mga ekel-ekel na, kung indi, dapat ang gapusun na ra kanay yang may balay. Atia, pagustu ra pag̱akwat na tung mga ekel-ekel na. ");
INSERT INTO tbk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tandaan mi ta maayen yang bitalaw. Kung tung bag̱ay, maskin unu pang kasalananay ang pag̱abuat yang mga tau, maskin magduminar pa tung Dios, maimung mapatawad da. ");
INSERT INTO tbk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Piru kung tinu pay magduminar tung Espiritu Santo ang yang pag̱urubraen na ya ray sawayen na, indi ra ka enged mapatawad yang Dios ang asta tung sampa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Pinagpaamanan da ni Jesus ta maning tia ay natetenged namansianing da yang mga sag̱ad ang atia ang yang pag̱erekelen unu tung ni Jesus ang pagpaktel ya ra unu ti Satanas. ");
INSERT INTO tbk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Taa numanyan, asan da namansikaw̱ut ti nanay ni Jesus may yang mga putul na. Asan da ilem kemdengan tung lua yang balay ang namagpaguuy tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Numanyan duun tung kakleran, durung taung kumarungan tung paliw̱ut ni Jesus ang ya ray namagpakdek tung anyang mag̱aning, “Ameey, nakaa ra pala tung lua ti nanay mu may yang mga putul mu. Nag̱ipaguuya ra nira.” ");
INSERT INTO tbk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mag̱aning ti Jesus ang nagtimales, “Ayw̱a, tung numyung pag̱intindi, tinu pa w̱asu ay nanayu? Tinu pa w̱asu ay mga putulu?” ");
INSERT INTO tbk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pagkatapus dayun dang naneleng-teleng tung mga taung atiang kumarungan tung paliw̱ut na ang nunut da ka ta pasanag na tung nirang mag̱aning, “Naa ra yang nanayu may yang mga putulu. ");
INSERT INTO tbk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ay kipurki kumpurming tinu pay pagtuman yang kalelyag̱an yang Dios, yay magkaw̱ig̱enung putulung lalii ubin putulung baw̱ay ubin nanayu,” mag̱aning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Taa numanyan may uras ang ti Jesus nag̱intra si pasanag tung mga tau duun tung bakayan. Kumus durug damel yang mga taung namagtaripukpuk da tung anya, purisu naparugal-rugal dang suminaay tung balangay ang napaabwat-abwat ta gesye. Duun da ilem ngarung ang ya kag tatalunga tung mga tau asan tung bakayan. ");
INSERT INTO tbk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Durung mga bag̱ay ang ipinagtulduk na tung nira ang asan da nag̱ipapanaway na tung mga pananglit. Tung pagturuldukun na tung nira, maning taa yang palaksu yang pananglit nang sam bilug. ");
INSERT INTO tbk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Mag̱aning ti Jesus tung nira, “Pamasian mi ra kanay ta maayen yang bitalaw. Numanyan may sasang taung minangay ra duun tung pinagbangteran na, ay magtarakbulun da ta binik ang trigu. ");
INSERT INTO tbk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Numanyan tung pagtarakbulun na, yang dumang binik nalagsik da tung dalan ang palanawan ta mga tau tung kakngaan ang pagkatapus kinaw̱utan da ta mga lamlam ang pinagsumpit. ");
INSERT INTO tbk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yang duma kang binik, duun ka nepa tung tanek ang manipis ang may batung tapik ang unayen ang alenget dang lumput tung ulit yang tanek. Purisu indi ilem nabuay, buminukngil da ay malw̱aw kang lag̱i yang tanek. ");
INSERT INTO tbk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Numanyan, pagkapangayag da ang atiing abwat da yang kaldaw, nangaleey ra ang asta namanlumpayeng dang pisan, ay indi ra nangapanlamut ta adalem. ");
INSERT INTO tbk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yang duma kang binik duun ka nepa tung tanek ang may mga laskaw yang sapinit ang indi nadeeg̱an ta kapwa yang aradu. Purisu tung pagtubu yang mga sapinit, pinanaw̱ed-saw̱eran da nira yang mga trigu ang pinagpig̱es. Purisu indi ra nangapamurak. ");
INSERT INTO tbk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yang dumang binik duun da tung lunsan ang tanek nepa ang asta nangapagtubu rang nangapamurak. Yang pangaluay yang duma inisen, yang duma kasarangan, yang duma arabubwat da ang tung kategkaan na ra ka enged.” ");
INSERT INTO tbk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Numanyan tung pagtapus na tung pananglit nang atia, dayun da sinugpatan na yang bitala na tung mga tau ang mag̱aning, “Ta, yang nagngel ta mga talinga mi, ya ra kay painu-inuan mi ta mupia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Taa numanyan, atiing namagparanawan da yang mga taung atiang buntun, ti Jesus pinaalengtan da yang mga taung nag̱apangugyatan na kang lag̱i kasiraan da ka tanira yang sam puluk may durua. Ay namanalimaan da tung anya kung unu pay mga linegdangan yang ipinampananglit na. ");
INSERT INTO tbk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mag̱aning ti Jesus ang nagtuw̱al, “Ta yamung pagpaugyat da tung yeen, linugtanamu ra yang Dios ang makdekan mi yang mga bag̱ay ang nag̱aegteman na pa rin ang tukaw natetenged tung paggaraemen nang baklu tung mga tau kung ya pa ag̱ari yang palaksu na simanyan. Piru tung mga taung atiang indi pa pagpagaem tung anya, asan da nag̱ipapanawayu yang mga bag̱ay ang atia tung pulus pananglit. ");
INSERT INTO tbk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yang nag̱ipagpananglitu tung nira ay ug̱ud magkamaningan da ang katulad ka tung bitala yang Dios ang napabtang tung kasulatan ang mag̱aning, ‘Maskin sam puluk ang magteleng, anday sakpen ta mga isip nira, basin sam puluk ang mamati, anda kay mamaresmesan nira. Ay ya pa ag̱ari, may sasang pangamanan enged nira asan ang kung disgrasia maintindian ilem nira tia, nusias mangapagsug̱at dang mamagbalik tung Dios ang pagkatapus patawaren na ra ka dayun,’ mag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Taa numanyan, dayun dang sinugpatan ni Jesus yang nag̱ituw̱al nang mag̱aning, “Naa pala, indi mi nag̱aintindian yang ipinananglitung atia? Ay kung indi mi maintindian tia, ya pa ag̱aring maintindian mi yang kadaklan? ");
INSERT INTO tbk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yang linegdangan atiing nagpanakbul ta binik ya ra yang sasang pagparakaw̱utun yang bitala yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kung natetenged tung dalan ang atiang nalagsikan ta dumang binik, yang linegdangan na ya ra yang dumang pamamati tung bitala yang Dios, ang kung magngel da nganing nira, nag̱apaalengtan dang lag̱i ni Satanas ang agludasen tung mga isip nira yang bitalang nagngel nira. ");
INSERT INTO tbk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yang linegdangan yang tanek ang atiang manipis ang may batung natampek, ya ra yang duma ang kung mapamatian da nganing nira yang bitala yang Dios, atiang lag̱i magpauyun da ang duru rag sadya yang mga isip nira. ");
INSERT INTO tbk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Piru kumus indi nalamut ta ustu tung mga kinaisipan nira, indi ilem mabuay yang pagparanangeren nira. Ay kung mapasaran da nganing ta kaliwag̱an ubin pandeeg-deeg natetenged tung bitalang atiang nag̱apananged da rin nira, atiang lag̱i, mansipalpas da ka ilem. ");
INSERT INTO tbk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Yang linegdangan yang tanek ang atiang may mga laskaw ang masapiniten, ya ra yang duma ang maskin pamati tung bitala yang Dios, piru kumus masyadung pagpakabegbeg nira tung pagpangabui nira taa tung kaliw̱utan ang naa ubin may intris nirang magmanggad ubin may duma pang nag̱apagamenan ta mga isip nirang eklan, maning pa tung asan da ilem nga pig̱esay yang bitalang nag̱agngel nira ang asta anda ray pinakaw̱ut na. ");
INSERT INTO tbk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Piru yang linegdangan yang tanek ang atiang lunsan ya ra yang dumang pamati tung bitala yang Dios ang yang nag̱agngel nira ya ray nag̱apananged nira ang asta may pakaw̱utun nang nag̱auyunan yang Dios. Tung duma may pakaw̱utun nang geg̱esye ka ilem, tung duma may pakaw̱utun nang kasarangan, tung duma kategkaan na ra enged yang pakaw̱utun na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mag̱aning si ti Jesus ang nagsugpat, “Ayw̱a, tinu pay nag̱aintindian ming tau ang magsindi ta kingki ang pagkatapus ya ra sukluw̱ay na ubin ya ra ipasirungay na tung katri? Simpri asan da ipabtangay na tung tapi-tapi. ");
INSERT INTO tbk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pariu ka tung yeen, anday itinaluku tung nag̱ipananglitu sigun tung palaksu yang paggaraemen yang Dios ang indi ipabunayag̱ayu, anda kay tinipig̱anu asan ang indi ipalw̱awayu. ");
INSERT INTO tbk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pademdeman mi ra kanay yang inaningu tung numyu nungayna ang kung unu pay nagngel ta mga talinga mi, kaministiran ang ya ra kay painu-inuan mi ta mupiang pasadsaran.” ");
INSERT INTO tbk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mag̱aning ka ti Jesus ang nagsugpat yang bitala na, “Intindien mi ta mupia yang nag̱ipagngelu tung numyu. Kung unu pag kaderep yang pagpasadsad mi tung nag̱ipananglitu, ya ra kay paatuan yang Dios ang magbuskad tung mga painu-inu mi ig dulangan na pa ka ngani. ");
INSERT INTO tbk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ay ya pa ag̱ari, kung tinu pay may nag̱aintindian na, dulangan pa ngani yang Dios. Ig kung tinu pay mapinaw̱aya-w̱ayaen tung pag̱irintindien na, maskin yang nag̱aintindian nang gesye, bawien da ka enged yang Dios tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mag̱aning ka ti Jesus ang nagpadayun yang bitala na, “Yang kaalimbawaan yang palaksu yang paggaraemen yang Dios ang naang baklu, maning pa tung taung pagpanakbul ta binik tung pinagbangteran na. ");
INSERT INTO tbk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pagkatapus ta pagtarakbulun na, magpadayun da tung dumang pag̱urubraen na tung pangaldaw-kaldaw mintras pamansipalpak dang pamamansilawlaw yang binik ang ipinanakbul na. Piru anday malai na kung ya pa ag̱ari yang palaksu yang binik ang paglepak. ");
INSERT INTO tbk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ay ya ra kang lag̱i yang natural na. Yang tanek ang pinanakbulan mismu, ya ray magpalpak. Lempak da nganing, yang tukaw ang maita ya ra yang tingway na. Tung kabuayan da gatasan da yang burak na. Tung kauri-urian da, lutuk dang pisan. ");
INSERT INTO tbk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pagkalutuk da nganing, mangaw̱ang da yang may anya tung mga manig̱ayeg ay tilig̱ayeg da,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mag̱aning ti Jesus ang nagsugpat tung bitala na, “Tung unu pa w̱asu ipapariuay ta yang palaksu yang paggaraemenu yang Dios ang baklu ang naang pag̱atukuru? Tung unu pa w̱asu ipananglitay ta ang yay mag̱atu ta maayen? ");
INSERT INTO tbk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Yang kaalimbawaan na, maning pa tung lisu ta mustasa. Maskin pinakagetey tung tanan ang mga lisu tung kaliw̱utan, piru kung ipanakbul da nganing tung tanek, dayun dang tumubu ang asta ya ray magyaring pinakaabwat tung tanan ang kapariu nang luak ang atiang gurulayen. Mananga-sanga ra ta darakulu ang puiding mabayayan ta mga lamlam ang pagpalandungan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Duru pang mga pananglit ang mga maning ka tii yang ipinagngel ni Jesus ang nagparakaw̱utun tung mga tau natetenged tung paggaraemen yang Dios ang baklu ang naang pag̱atukud na. Kumpurmi ra ilem yang maintindian nira, ya ray ipinagngel na tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Indi nagparakaw̱utun tung nira kung indi na ipinapanaw tung mga pananglit. Piru kung tanira tanira ra ilem yang mga taung nag̱apangugyatan na, ya ra kay pagpasanag na tung nira kung unu pay linegdangan yang tanan ang atiang ipinananglit na. ");
INSERT INTO tbk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Taa numanyan, atiing panlikarem da tung kaldaw ang atii, mag̱aning ti Jesus tung mga tauan na, “Ala, magpatindakita ra kanay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Purisu dayun da nirang binutwanan yang mga taung atiang buntun duun tung bakayan ang namansisaay tung balangay ang atiang pag̱akarungan kang lag̱i ni Jesus ang pagkatapus namagpaabwat da. May dumang mga balangay ang namagpaaway ka tung pag̱asaayan nira na Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Numanyan tung pagpalaksu nira tung aw̱uyuk, nainalian dang binungsaran ta tampung durug ketel. Ya rag sasaw̱uy agsasaw̱uy yang lakun ang magsasaay tung balangay. Gesye ra ilem mapnukan. ");
INSERT INTO tbk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti Jesus duun tung buli ag̱elken da ang yang kulu na ya kag kukulun tung kukulunan. Atii, dayun da nirang pinuaw ang inaning, “Ameey, anda tung kulu mu yang pagkabetang tang magkaralemesita ra taa?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pagkapuaw ni Jesus, dayun na rang pinagsambeng yang palet ang mag̱elteng, pati yang aw̱uyuk, pinaglalangan na ra kang maglinaw. Atii, yang palet nag̱elteng dang lag̱i, pati yang aw̱uyuk naglinaw ra ka ang anda rang pisan ay giup-giupun na. ");
INSERT INTO tbk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Numanyan mag̱aning ti Jesus tung mga aruman na, “Ayw̱at nagpatalawamu ra? Ayw̱a, anda pa ka enged ay pagtalig mi tung yeen?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Numanyan nangaimakluan da tanira ta mupiang namagteleng tung anya. Namag̱araning-aningan da ilem ang mag̱aning, “Abaa, unu ra kayang klasiay ta tau taa? Maskin palet, maskin lakun pa, parariu ra ilem ang pamananged tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kapurisu numanyan nangatindak da tanirang nangakaw̱ut duun tung baw̱anwaan yang mga Geraseno. ");
INSERT INTO tbk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Pagkalampud ni Jesus tung balangay, may sasang taung pag̱aekel-ekelan ta dimunyu ang ya ray nagpakigbag̱as tung anya. Baklu ilem nanliit tung may mga leyang ang pinanlug̱uran ta mga patay ang ya ra kay pagpalaug-laug̱an na. Yang taung atia, anda ray masarang tung anyang begkesen pa ta kadina. ");
INSERT INTO tbk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ay muya-muyang tinag̱aman nira ta begkes ang pagkatapus yang kadina tung kalima na ya ra ilem agbuntuk-buntukay na ig yang tung kakay na ya ra ilem ag̱itangkuay na tung batung asta magkaratemek. Purisu anda ray masarang ang magsambeng tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kaldaw law̱ii, paglaug da ilem duun tung may mga leyang may tung kabukiran. Yang bida na pirming paglelpaken. Ang kaisan manga ya nga pisik ta mga batung matatarem ang ya ra ilem ag̱igeret-geretay na tung tinanguni na ang asta magkaralukanan. ");
INSERT INTO tbk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Naa pala, atiing alawid-lawid pa ti Jesus, nabandaw rang lag̱i yang taung atia ang pagkatapus dayun dang nagpataladtad ang nagpakigbag̱as tung anya. Tung pagkaw̱ut na tung anya, ya ra nga luud tung pinagtalungaan nirang durua. ");
INSERT INTO tbk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Atii, dayun dang binugnu ni Jesus yang dimunyung linalangan, “Yawang dimunyua, maglayasa ra ilem asan tung taung atia!” Pagkagngel yang dimunyu tia, ya ra ngalpak ang mag̱aning, “Ay Jesus, yawang pag̱aningen ang Ana Yang Dios ang makagag̱aem, ayw̱a nag̱apasilabtanaw pa nuyu? Pasumpaena ra yeen tung Dios ang indiaw ra parusaan mu.” ");
INSERT INTO tbk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dayun dang tinalimaan ni Jesus ang, “Tinu pay aran mu?” Mag̱aning yang dimunyung nagtuw̱al, “Ti Buntun yang aranu, ay duruamig dakel,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pagkatapus, dayun dang nangamu-amu ta mupia tung ni Jesus ang basta indi na ra ilem paliiten tung banwang atii. ");
INSERT INTO tbk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Numanyan, may sasang kaayepan yang mga baw̱uy ang gaw̱ung ang pamanulyad-tulyad tung napabukatud ang alenget ka ilem duun. ");
INSERT INTO tbk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Purisu yang mga dimunyung atia, namagpakiluuy ra ilem tung ni Jesus ang mag̱aning, “Maayen pa, duunami ra ilem ipasuutay mu tung mga baw̱uy ang atii,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Numanyan tinugtan da ka man ni Jesus. Purisu paglayas nira tung taung atia, insigidang nanuut-suut da tung mga baw̱uy. Pagkasuut nira tung mga baw̱uy, dayun dang namansikurbut ang namampataladtad ang diritsyu ra ilem tung aw̱uyuk ang namampakpa ang asta nagkaralemes da ilem tanirang tanan. Alenget duruang liw̱u yang mga baw̱uy ang atii. ");
INSERT INTO tbk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Taa numanyan, yang mga manig̱asikasu tung mga baw̱uy ang atii, dayun dang namagralaksuan ang namagbaw̱alitaen tung mga taung kumpurming nag̱apanawan nira tung lua ang asta duun tung lansangan. Purisu numanyan yang mga taung atiang nagkarabalitaan da, diritsyu rang namansiangay duun tung bakayan ang para mamanginsapu tung nainabung atii. ");
INSERT INTO tbk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Numanyan kaw̱utan nira ti Jesus, unu pay maita nira, kung indi, ya ra yang taung atiang dinimunyu ra rin. Yag lalaptik asan ang durug kalimeng yang pagkabetang na. Dispuis, belag dang luas, kung indi, napag̱aw̱el da ay naulikan da atiing isip na. Tung pagpaniid nira tung anya, ya ra pandelaay. ");
INSERT INTO tbk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Taa numanyan, yang mga manig̱asikasu ang atiang nangaita tung nainabung atii, binalitaan si nira yang mga taung atiang baklung namansikaw̱ut kung ya pa ag̱aring nagkamaningan da yang taung atiang dinimunyu rin pati natetenged tung kaayepan ang mga baw̱uy. ");
INSERT INTO tbk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Purisu pagkabalita nira tia, dayun dang namag̱intra amu-amu tung ni Jesus ang basta magliit da ilem duun tung banwa nira. ");
INSERT INTO tbk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Numanyan tung pagsaay ni Jesus tung balangay, yang taung atiang dinimunyu ra rin, ya si ay nagpakiildaw tung anya kung puiding magpakignunut da tung anya ang para mag̱ing sasang tauan na. ");
INSERT INTO tbk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piru indi ra tinugtan na, kung indi, ya ra ag̱aningay nang, “Maayen pa, ungkuy, mulika ra ilem tung mga kaarumanan mu. Magbaw̱alitaena ra tung nira kung unu pay binuat ni Ginuu mu tung nuyu, kung ya pa ag̱aring inildawana ra anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kapurisu dayun dang nagpanaw ang nag̱intra ra baw̱alitaen tung mga tau tung intirung banwang atiang sinakepan yang pag̱aningen ang Sam Puluk NGa Lansanganan kung unu pay binuat ni Jesus tung anyang durug tinlu. Yang tanan ang nagkarabalitaan, nangabereng da ta mupia. ");
INSERT INTO tbk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Taa numanyan, nagpatindak si ti Jesus ang nagbalik ang ampir tung pinanliitan na, kasiraan da ka yang mga tauan na Pagparuung nira, buntun da yang mga taung namagpakigbag̱as dang namagtaripukpuk tung anya duun tung bakayan. ");
INSERT INTO tbk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Numanyan may nagpalenget da tung anyang sasang may katengdanan tung pagsaragpunan ta mga Judio ang yay nag̱aranan tung ni Jairo. Pagkaita na tung ni Jesus, dayun da ilem ang nagpadagpa tung pinagtalungaan nirang durua ang nagpakiildaw ta mupia tung anyang mag̱aning, “Yang anaung baw̱ay tag̱umatayen da! Kung maimu ilem tung nuyu, angayen mu ra kanay ang deenan ug̱ud indi madayunan, kung indi, magmaayen da,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pagkatapus, ti Jesus dayun dang nagpakignunut tung anya. Taa numanyan, kadakel da yang mga tau ang namagpakigduman tung anya. Tung pagparanawen nira, ti Jesus ya ray nag̱asag̱ese nira ta mupia. ");
INSERT INTO tbk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Taa numanyan may sasang baw̱ay asan ang tung seled sam puluk may duruang takun muya-muya ra ilem ang nag̱aawasan. ");
INSERT INTO tbk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Durung nagkarapasaran nang pinitinsia tung pagparabulungun na tung dakeleng mga manigbulung ang linakted-lakteran na, ang pagkatapus yang tanan ang kuarta na iginastus na ra ilem ang luw̱us ta pagsuul tung nira. Piru belag ya magmaayen yang laru na, kung indi, ya mag̱eseg. ");
INSERT INTO tbk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kumus nabalitaan da natetenged tung ni Jesus, nagpakilaket da ilem tung mga taung atiang buntun ang pagkatapus sinikup nang dineenan tung aw̱el na. ");
INSERT INTO tbk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ay yang nag̱ipagkesen-kesen na tung isip na ay maning taa: “Maskin aw̱el na ra ilem yang madeenanu, atiang lag̱i, magmaayenaw ra,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Numanyan tung pagkadeen na tung aw̱el na, insigidang pinedkanan dang lag̱i yang dug̱u na. Panimanan na yang tinanguni na, tanya maayen da. ");
INSERT INTO tbk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Atiang lag̱i nasintian da ni Jesus tung sadili na ang may taung nagmaayen da ekel tung kagaeman na. Purisu dayun dang nagbirang nagtalimaan tung mga taung atiang buntun ang mag̱aning, “Eey, tinu pay nagdeen tung aw̱elu?” ");
INSERT INTO tbk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Numanyan yang mga taung nag̱apangugyatan na, ya ray namagtuw̱al ang mag̱aning, “Yawa ra kag teteleng! Yang mga taung atia tung tepad mung pamagsag̱ese tung nuyu duru! Magtalimaana pa ka enged ang tinu pay nagdeen tung nuyu?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piru ti Jesus, sigi ilem yang pagsiman-siman na tung mga ityura yang mga tau ang basi pa ra ilem masiplatan na kung tinu pa tung nira ay nagbuat ta maning tia. ");
INSERT INTO tbk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Numanyan yang baw̱ay, pagkamalamad na yang nainabu tung anya, dinlaan dang nagpangerel. Piru maski pang maning da tia, nagpalenget da ka enged tung ni Jesus ang nagpadagpa ra ilem asan tung pinagtalungaan nirang durua ang pagkatapus nag̱ubligar da tung anya ang anda ray inegteman na. ");
INSERT INTO tbk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pagkatapus tia, dayun dang nagtimales ti Jesus ang mag̱aning, “Ipag, nagmaayena ra nganing tung linaru mung atia ay natetenged itinalig mu ra kang lag̱i tung yeen. Malimeng da yang isip mung mulik tung balay mu ay india ra ka umbalingan yang masiit ang atia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Numanyan, indi pa nganing nag̱atapus ti Jesus ta pagbitala, may namansikaw̱ut da ang duun mamanliit tung balay ni Jairo. Mag̱aning tanira tung may ana, “Napatay ra yang ana mu. Maskin indi mu ra aw̱alaen ti Ameey,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Numanyan indi ra ilem binalut ni Jesus yang ibinalita nirang atia, kung indi, pinaktel na rang lag̱i yang isip yang may ana ang inaning, “Ungkuy, india ra ilem magpadla, kung indi, magtalig̱a ra ilem tung yeen ta ustu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Numanyan yang ingkelan nang pinanunut, ya ra ilem ti Pedro may ti Santiagong duruang mag̱ari ni Juan. ");
INSERT INTO tbk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Taa numanyan mamansikaw̱ut da tanira duun tung balay yang may ana, naita ra ni Jesus yang mga taung pamaggirinla ta mupia ay pamagtarangiten dang pamag̱urulimengmengen. ");
INSERT INTO tbk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Numanyan pagpakled ni Jesus tung balay, dayun na rang pinag̱aning yang mga tau asan tung kakleran ang, “Ayw̱a nag̱atarantaamu ra ta maning tiang pagtarangiten? Belag̱an patay yang mula, kung indi, ag̱elken ilem,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pagkagngel nira yang bitala ni Jesus, ya ra ilem agtalangkakay nira. Piru tanya, anday dumang binuat na, dayun na rang ipinampaluang luw̱us tung balay. Pagkatapus yang ingkelan na duun tung kakleran ang pag̱alubgan yang mula, ya ra ilem yang amaen may yang inaen may yang mga tauan nang atiang tulu. ");
INSERT INTO tbk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Numanyan pagpeg̱es na tung kalima yang mula, dayun na rang inaning tung bitalang natauan nira ang, “Talita kumi” ang yang gustu nang ianing, “Nini, magbungkarasa ra!” ");
INSERT INTO tbk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Atii, lag̱i-lag̱ing nagbungkaras da yang mulang nagpanaw-panaw asan. Yang idad na sam puluk may duruang takun. Numanyan pagkaita yang mga ugpu ni Jesus ang lima, nangabereng da ta dakulung pagkabereng. ");
INSERT INTO tbk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pagkatapus numanyan, nagkalalangan da ti Jesus tung nira ang indi ra enged ang pisan mamagbaw̱alitaen tung duma may ruma. Pagkatapus, dayun na kang inaning yang may mga ana ang maayen pang papaanen da kanay nira yang ana nira. ");
INSERT INTO tbk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Taa numanyan, ti Jesus, nagliit da tung lugar ang atii ang naglekat da duun tung lansangan ang pinagdakulan na, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Numanyan pagkaw̱ut yang kaldaw ang nag̱ipamaenay, nag̱intra ra pasanag duun tung pagsaragpunan nira. Kadakel dang namamati tung anya ang pagkatapus nangabereng da ka ta mupia tung anyang namag̱araning-aningan dang mag̱aning, “Abaa, yang tau kang naa ka, ay pa ngaeklay na yang kataku nang atia ang ya pay magtulduk tung yaten? Pati yang mga pruibang atiang maktel ang nag̱abalitaan tang nag̱apagpalapus na ay pa ngaeklay na? ");
INSERT INTO tbk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Belag bang atia karpintiru ka ilem ang pinalpawan ni Maria? Belag ba ang yang putul nang mga lalii ya ra taa ti Santiago, ti Jose, ti Judas, may ti Simon? Belag ba ang pati yang mga putul nang mga baw̱ay taa ka tung banwa ta agpamag̱istar?” mag̱aning. Purisu duun da namagmalagana yang mga isip nirang namagdiskumpiar tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Purisu dayun dang nanuw̱al ti Jesus tung nira ang mag̱aning, “Talagang matuud ka man yang bitala yang mga mamaepet ang yang sasang manigpalatay yang bitala yang Dios, maskin ay pang banwaay nga teyeb, nag̱agalang ta mga tau, puira pa tung banwang natauan na may tung may mga kaampiran tung anya maskin pa tung seled yang sadiling pamalay-w̱alay na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Numanyan anda ray mga pruibang maktel ang napalapus na duun, puira pa tung pira pa ilem nga tauan ang may mga laru nira ang ya ray pinandeenan nang pinampamaayen. ");
INSERT INTO tbk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Purisu nabereng da ta mupia ti Jesus natetenged tung pagkadiskumpiadu nirang atia tung anya. Taa numanyan, ti Jesus, nagliliw̱utun da tung mga baryung nagturuldukun tung mga tau, kasiraan da ka tanira yang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tung pagliliw̱utun nirang atii, may uras ang ti Jesus nagguuy tung mga tauan nang atiang sam puluk may durua ang para mamagsaragpun da. Pagkatapus pinanuw̱ul na tanirang mamagliliw̱utun ta taludua taludua nga tauan. Pinamiaran na ra ka dayun ta katengdanan nirang mamagpalayas ta mga dimunyung namagsuut tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dispuis nagkalalangan da ka tung nirang mag̱aning, “Kung magpanawamu ra nganing, paktaw ilem yang pagparanawen mi, puira pa tung bastun mi. Indiamu ka magbalun ta pamangan may kuarta, indiamu ka mag̱ekel-ekel ta puyu-puyu ang pariu ka tung pag̱aekel-ekelan ta mga manigpalimus. ");
INSERT INTO tbk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Maskin magsuutamu ta mga sandalyas mi, indiamu mag̱ekel ta lambung ang imaraan mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Numanyan dayun dang sinugpatan na yang bitala na tung nirang mag̱aning, “Dispuis kung patakwalenamu ra nganing tung sasang balay, duunamu ilem magdayun ang asta magliitamu ra ilem tung banwang atia. ");
INSERT INTO tbk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dispuis kung ariamu pang lugaray nga distinu ang pagkatapus indiamu ra risibien yang mga taung pamatian, magliitamu ra ilem asan. Ug̱aring tung pagliit mi, pakdulan mi ta sasang sinyalis. Yang apuk tung banwa nira ang namandepet tung mga kakay mi, ya ray itagbeng-tagbengay mi ug̱ud asan da nga paamanay mi ang yang pagpakuindi nirang atia tung numyu ya ray panuw̱alan nira tung Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kapurisu numanyan namagparanawan da ka man tanirang namagparakaw̱utun tung mga tau ang tanira dapat ang manligna ra tung mga kasalanan nirang magbalik tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dispuis namagpalayas ka tung dakeleng mga dimunyung namagsuut tung mga tau ig namagpamaayen ka tung dakele kang mga taung may mga laru nira ekel tung pag̱aplas nira ta lana. ");
INSERT INTO tbk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Taa numanyan, yang mga buat-buat ang atiang makabew̱ereng, nabalitaan da ni Adi Herodes, ay maknul yang aran ni Jesus maskin ay pa. Mag̱aning yang duma ang namagbaw̱alitaen, “Siguru ya ra ti Juan ang manigbenyag ang ya ray pinabungkaras yang Dios ang binui si kang uman. Purisu ya ray natengeran na ang tanya may kagaeman nang magpalapus ta mga pruibang maning tiang maktel,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Piru mag̱aning ka yang duma, “Ya ti Elias,” ag̱aaning. Mag̱aning ka yang duma, “Ya ra yang sasang manigpalatay yang bitala yang Dios ang katulad ka tung namaglua tung namagtukaw ang mga panimpu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Numanyan pagkabalita yang Adi, ya ra ag̱aningay nang, “Anday duma tia, kung indi, ti Juan dang atiing pinapug̱usanu ta dikel na. Ya si kay binuing uman yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ibalik ta ra kanay yang isturia tung napasaran ni Juan ang atiang manigbenyag. Atii kanay ipinadeep ni Adi Herodes ang pagkatapus pinapusasan nang ipinakalabus. Ya ray binuat yang Adi natetenged ilem tung ni Herodias ang kasawa ra rin ni Felipe ang putul na ang ya ray kinalaw nang pinangasawa. ");
INSERT INTO tbk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ay yang ipinagpadeep yang Adi tung ni Juan ay natetenged ang pirmi ilem ang pag̱aningen ni Juan ang lampas da unu tung katuw̱ulan yang Dios ang mangasawa tung kasawa yang putul na. ");
INSERT INTO tbk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Purisu ti Juan dinemtan da ta mupia ni Herodias. Gustu na ra rin ang ipaimatay na piru indi na mabuat natetenged tung ni Adi Herodes ang anday kalelyag na. ");
INSERT INTO tbk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ay durung panggalang na tung ni Juan ay naskean nang yay sasang taung matinumanen tung nag̱auyunan yang Dios ig bilug yang isip na tung anya. Purisu ya ray dinipindiran na ang para indi ra maunu pa. Dispuis pa, kada mamati tung anya, duun dag paglinget ta maayen yang isip na. Piru maskin dang maning tii, agtinluan pa ka enged ang pamati tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Taa numanyan, tung pira pang kaldaw kinaw̱ut da yang uras ang may lugar da ni Herodias ang magtuman yang kalelyag̱an na. Natuun tung uras ang ipagsilibra yang Adi tung kakaldawan yang pagkapangana tung anya ang ya ra kay uras ang ipinagpundar na ta punsiun ang dakulu. Yang mga taung pinangimbitar nang mamagpasakep, ya ra yang mga upisial tung gubirnu may yang may mga katengdanan tung mga sundalung atiang mga tag̱a Roma asta yang dumang darakulu kang mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Taa numanyan, yang ana ni Herodias ang darala, ya ray nagpakled tung pagpunsiunan ang pagkatapus dayun dang nagtalek. Tung pagpaniid ni Herodes may yang mga bisita na tung daralang pagtalek, pinanadyaan da ta durung pinangganaan. Purisu yang Adi ya ray nabnga ang mag̱aning tung darala, “Nini, maskin unu pay nag̱alelyag̱an mu, ingalukun mu ra ilem tung yeen. Siguradung ipapakdulu tung nuyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pagkatapus sinumpaan na pa yang bitala nang mag̱aning, “Tung Dios may tung tau, maskin unu pay ingalukun mu tung yeen, nini, siguradung ipapakdulu tung nuyu, maskin tengaen ta pa yang pag̱agaemanu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Numanyan dayun dang luminua yang daralang nagtalimaan tung ni nanay nang mag̱aning, “Nanay, unu pay ingalukunu tung Adi?” Mag̱aning ti nanay nang nagtuw̱al, “Yang kulu ni Juan ang manigbenyag, ya ray ingalukun mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Atii, kali-kaling nagbalik tung Ading nag̱ingaluk tung anyang mag̱aning, “Maginuung Adi, gustuu rin ang ipakdul mu rang lag̱i tung yeen numaan yang kulu ni Juan ang manigbenyag. Ipabtang da ilem tung basyada,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Numanyan pagkagngel yang Adi tia, pinungaw ra ta mupia yang isip na. Piru kumus pinanumpaan na yang pangaku na tung katalungaan yang mga imbitasiun na, anday gustu nang isulan na pa yang nabitalaan na tung darala. ");
INSERT INTO tbk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Purisu anday dumang binuat na, tinuw̱ul na ra ilem yang sasang sundalung manigpamug̱us ang yang kulu ni Juan eklan da. Purisu dayun da ka man ang minangay duun tung kalabus ang namug̱us tung dikel ni Juan. ");
INSERT INTO tbk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pagkapug̱us na yang kulu na, dayun na rang ingkelan duun tung daralang ipinakdul ang yag bebtang tung basyada. Pagkatapus dayun dang ingkelan yang daralang inintriga tung ni nanay na. ");
INSERT INTO tbk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Taa numanyan, pagkabalita yang mga taung namagpaugyat da rin tung ni Juan, dayun dang namansiangay tung kalabus ang ingkelan yang tinanguni nang ipinalg̱ud tung sasang leyang. ");
INSERT INTO tbk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Taa numanyan, yang mga taralig̱an ni Jesus ang atiing pinanuw̱ul nang mamagliliw̱utun, namagbalik da tung anyang namagbaw̱alitaen natetenged tung tanan ang nagkarabuat nira pati yang kumpurming ipinagpakaw̱ut nira tung mga tau inulit ka nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Numanyan, durug dakel yang mga taung namanlag̱ud-lag̱ud da asan tung nira. May magkakaw̱ut, may magliliit, may magsusubli, ang asta anda ray uras nira na Jesus ang ipamangan. Purisu numanyan mag̱aning ti Jesus tung mga aruman na, “Mga putulu, amus ta ra. Magpaag̱esita ra kanay duun tung anday tatau na ug̱ud duunita ra kanay mamaenay ta gesyeng uras,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Purisu dayun dang namansisaay tung balangay ang namampaag̱es duun tung anday tatau na ang tanira tanira ra ilem. ");
INSERT INTO tbk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ug̱aring tung pagsaay nira, durung mga taung nangaita tung nirang nangailala. Purisu anday dumang binuat nira, dayun dang namagliliitan tung mga lansangan nirang namagralaksuan ang namagbakay ang asta natkawan da nira na Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Purisu tung paglampud ni Jesus tung balangay, ya ray naita na yang mga taung atiang buntun. Pagkaita na tung nira, ya ra ngampayay ta kakaildawen nang duru tung nira ay natetenged yang pagterelengen na tung nira, maning pa tung kaayepan ang mga karniru ang anda ray manigpastur nira. Purisu dayun dang pinasanag̱an na ta mupia natetenged tung kabag̱ay-bag̱ayan yang paggaraemen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Taa numanyan, atiing apun da, dayun dang namagpalenget tung ni Jesus yang mga taung nag̱apangugyatan nang mag̱aning tung anya, “Ameey, yawa rag teteleng. Naawita ra tung banwang naang kapas. Alang-alang da yang uras. ");
INSERT INTO tbk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Maayen pa, pampapanawen mu ra ilem yang mga taung atia ug̱ud mamansiangay ra tung mga baryung alelengeten ubin mga lansangan ang para mamangalang da ta mapangan nira.” ");
INSERT INTO tbk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mag̱aning ti Jesus ang nagtimales, “Yamu ray magpapaan tung nira.” Mag̱aning ka tanirang namagtimales, “Abee, Ameey, yang gustu mung ianing basu, papanawenami pa nuyung papangalangen ta tinapay ang magbaluran ta duruang gatus ang para ya ray ipapaan yamen tung nira?” ");
INSERT INTO tbk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mag̱aning si ti Jesus ang minles, “Ayw̱a, pira pang bilug ang tinapay ang nag̱adipara mi? Insapuen mi ra kanay asan.” Numanyan pagkainsapu nira, dayun dang namagbalik tung ni Jesus ang namagpaske ang mag̱aning, “May limang bilug ang tinapay ang gereg̱esye may duruang bilug ang ian,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Numanyan nagkalalangan da ti Jesus ang yang mga taung atiang buntun mamaggrupu-grupu ra kanay ang mamansikarung asan tung kailamununan ang atiang madalumu. ");
INSERT INTO tbk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kapurisu kumarung-karungan da ka man tanirang tanan, grupu may grupu. Yang dumang grupu nira may salegsang gatus nga tauan, yang duma taglilimang puluk. ");
INSERT INTO tbk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pagkatapus numanyan, pagkadawat ni Jesus yang mga tinapay ang atiang limang bilug may yang ian ang atiang duruang bilug, dayun dang tuminingarang nagpasalamat tung Dios natetenged tung pamangan ang atia. Pagkatapus ta pagpasalamat na, dayun na rang pinagpingas-pingas yang mga tinapay ang atia ang ya ray ipinamakdul-pakdul na tung mga taung nag̱apangugyatan nang para ipanagtag-tagtag nira tung mga tau. Pati yang mga ian ang atiang duruang bilug, ipinagparti-parti na ra ka ang asta namagkaramped da tanirang tanan. ");
INSERT INTO tbk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Numanyan tanirang tanan nangapamangan dang asta namampabial dang luw̱us. ");
INSERT INTO tbk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkatapus atiing tuw̱urun da yang mga taung atiang nag̱apangugyatan ni Jesus yang mga yeped-yeped yang tinapay may yang ian ang pinamanganan nira, sam puluk may durua pa nga baayan yang napnuk nira. ");
INSERT INTO tbk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kung bilangen yang mga taung atiang namamangan, may limang liw̱u nga tauan, puira pa tung mga baw̱ay may tung mga mamula. ");
INSERT INTO tbk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Taa numanyan, atiang lag̱i, itinulmun da ni Jesus yang mga taung atiang nag̱apangugyatan nang mamagsaay ra tung balangay ang mamagtukaw ra tung anyang mamagpatindak duun tung lansangan ang Betsaida. Ay pampauliken na pa unu yang mga taung atiang buntun ang pampapanawen. ");
INSERT INTO tbk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Numanyan atiing pinampaulik na ra yang mga taung atia, dayun dang nanungul tung bukid ang para mag̱arampuen da tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkalaw̱ii, yang balangay ang pag̱asaayan yang mga tauan na atii ra tung kakngaan yang aw̱uyuk. Ti Jesus sam bilug ilem ang napabutwan tung banwa. ");
INSERT INTO tbk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Taa numanyan nabandaw ra ni Jesus ang yang mga tauan na tung balangay nag̱aliwag̱an dang pamanggayung ay natetenged sungsung yang palet. Numanyan atiing sam parti pa mangayag, baklu pa manikad ti Jesus ang ya ra ilem agpagpanaw tung ulit yang aw̱uyuk. Midyu tung magtataklib da ilem din tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ug̱aring pagkaita nira tung anyang yag pagpanaw tung ulit yang aw̱uyuk, ya ra mag̱irisyakan ay kanisip nirang sasang kalag. ");
INSERT INTO tbk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ay nangataranta ra tanira ta mupia tung pagkaita nira tung anya. Atii, dayun dang nagbitala ti Jesus tung nirang mag̱aning, “Eey, paiseg̱en mi ra yang mga isip mi. Yuu ra taa. Ustu ra tiang pagpakataranta mi!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pagkatapus diritsyu rang nagsaay ti Jesus tung balangay ang nagpakiugpu ra tung nira. Pagkasaay na, dayun dang nag̱elteng yang palet. Pag̱elteng da yang palet, nangabereng da ta mupia yang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ay ya pa ag̱ari, maskin naita nirang nagpapaan tung mga taung atiing buntun, piru indi pa ka enged nag̱amaresmesan nira kung unu pa enged ay linagpakan na, kung indi, maluw̱ay pa ka enged yang mga isip nirang magdeep. ");
INSERT INTO tbk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taa numanyan, dayun-dayun yang pagpalakted nira ang asta duun da nangasampet tanira tung banwang pag̱aningen ang Genesaret. Pagkaduung nira, yang balangay pinunduan da ilem nira asan tung duruungan. ");
INSERT INTO tbk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Numanyan paglampud nira tung balangay, ti Jesus nailala rang lag̱i yang mga tau asan tung bakayan. ");
INSERT INTO tbk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pagkailala nira tung anya, dayun dang namagralaksuan ang namagliliw̱utun tung intirung banwang atia ang namag̱erekelen tung may mga larung lumbug̱an tung mga lulubgan nira. Ay gustu nirang ipampadangep nira tung ni Jesus tung maskin ay pang rugalay ang nag̱abalitaan nira ang tanya duun. ");
INSERT INTO tbk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maskin ay pa nanganing ti Jesus, kung duun tung mga baryu ubin tung mga lansangan ubin tung mga kabiw̱init-binitan, duun da ka tung mga plasa nag̱ipampabtangay nira yang mga kaarumanan nirang may mga laru. Namagpakiildaw ra dayun tung anya ang kung maimu ilem ang maskin ya ra ilem yang mga mabiw̱ilug-bilug ang yag tataked tung sidsiren yang aw̱el nang atiang langkuy ya ray madeenan yang mga kaarumanan nirang atia. Ang pagkatapus, kumpurming tinu pay nagdeen, ya ray nagmaayen tung pag̱alaru na. ");
INSERT INTO tbk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Taa numanyan, may mga Pariseo pati mga sag̱ad tung mga urdinansa ang ya ray namagtaripukpuk tung ni Jesus. Duun tanira mamanliit tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Numanyan tung pagpaniid nira tung mga taung nag̱apangugyatan ni Jesus ang duma, naita ra nira ang basta-w̱asta ilem yang pagparanganen nira. Ay baklu namamisik, indi namangug̱as yang mga kalima nira ang uyun tung sasang urdinansang nag̱apapaktelan nira. ");
INSERT INTO tbk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ay pa ag̱ari, yang kadaklan ang mga masigkanasyun yamen ang mga Judio, kapin pa nganing yang mga Pariseo, pamag̱usuy tung sasang riglamintung pinanubli tung mga kinaampu yamen, ang indi ra kanay mamamangan mintras indi pa nag̱apangug̱asan nira yang mga kalima nirang uyun tung riglamintung atia. ");
INSERT INTO tbk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kung duun liit tung palingki, indi ra kanay mamamangan mintras indi pa nag̱apangug̱as tung maning tia. Dispuis duru-durung mga riglamintung ipinasubli tung nira ang nag̱atutuman nira ang katulad ka tung pag̱urug̱asen nira yang mga irineman nira may yang mga kaldiru nira pati mga garamiten nirang saway. ");
INSERT INTO tbk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kapurisu yang nag̱apapaktelan ang atia yang mga Pariseo may yang mga sag̱ad, ya ray ipinag̱istinggir nira tung ni Jesus ang inaning, “Ayw̱at yang mga taung atiang nag̱apangugyatan mu indi pamagtuman yang riglamintung pinanubli ta tung mga kinaampu ta, kung indi, pamamangan da ilem ta basta-w̱asta ang yang mga kalima nira indi ra ka nira nag̱aug̱asan tung magkatama?” ");
INSERT INTO tbk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mag̱aning ti Jesus ang nagtimales, “Abaa, temeng dang pisan tung numyung pagpakaayen-ayen ilem yang sasang bitala yang Dios ang ipinagpadapat ni Isaias ang tukaw ang mag̱aning, ‘Yang mga taung naa, yang paggaralangen nira tung yeen tung tumbung ka ilem yang mga dilak nira ang pagkatapus yang rumbu yang mga isip nira alawid ang pisan tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Anda enged ay kapulutan na yang pagturuuen nirang maning tia tung yeen ay natetenged yang nag̱ipatuman nira tung mga tau ang ya ra ag̱aningay nirang mga katuw̱ulanu unu buat, ya ka ilem yang mga riglamintung mga maning tiang inimu-imu ta mga masigkapariu ka ilem nirang mga tau,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bilang yang katuw̱ulan yang Dios ya ray nag̱abaya-w̱ayaan mi ang pagkatapus yang riglamintung ipinasubli tung numyu ta mga masigkapariu mi ka ilem ang mga tau ya ray nag̱amaal ming nag̱atutuman. ");
INSERT INTO tbk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Duruamu rag kaansianung magliked tung katuw̱ulan yang Dios basta mapagtumanamu ilem yang sasang pinanubli mi ka ilem tung mga kinaampu ta. ");
INSERT INTO tbk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ayw̱a indiamu aningenu ay kipurki may sasang katuw̱ulan yang Dios ang ipinalatay na tung ni Moises ang maning taa yang palaksu na: ‘Galangen mu ti tatay mu may ti nanay mu.’ Dispuis may sugpat na pa ka ang mag̱aning, ‘Kung tinu pay magpalagpak ta mga bitalang malalain tung ni tatay na ubin tung ni nanay na, dapat ang ipaimatay ra ilem.’ ");
INSERT INTO tbk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Piru yang numyung nag̱ipatuman tung mga tau ay maning taa. Kung tinu pay masilag tung ni tatay na ubin tung ni nanay na ang ya ra panumpaay nang aningay, ‘Indi mi ra enged mapakinaw̱angan yang sinisirbianu ra rin ang naa tung numyu ay Corban da’, yang taung atia indi mi ra ka enged lugtan ang manggalang pang mandul tiing sinisirbian na ra rin tung ginikanan na ay natetenged indi mi lugtan ang bawien na pa yang sinumpaan nang atia. (Yuung ti Marcos ang nagsulat, may yeen kang isaleet ang ipasanag natetenged tung bitalang atiang Corban. Yang gustu nang ianing inintriga ra tung Dios.) ");
INSERT INTO tbk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Purisu tung pagparatumanen mi tung mga tau yang pinanubli ming atia tung mga kinaampu ta, asan da ngaimbaliduay mi yang sasang katuw̱ulan yang Dios mismu ang anda ray kapulutan na. Durung nag̱usuyun ming kamali kang magkapariu ka ta palaksu tung bag̱ay ang atia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Atii dayun sing ginuuyan ni Jesus yang mga taung atiang buntun ang mamagpalenget da ka tung anya ang pagkatapus pinag̱aning na rang, “Yamung tanan, pamatian mi ra kanay ang intindien yang papintung naang ipagngelu tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Anday magpapakled tung sasang tau ang liit tung lua ang ya ray sarang ang magpamansa tung anyang asta indi ra magkabag̱ay tung pagterelengen yang Dios. Kung indi, yang maglulua tung sadili na yay pagpamansa tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Taa numanyan, pagliit ni Jesus tung mga taung atiang buntun, pagpakled na tung balay, dayun dang pinaalengtan yang mga taung atiang nag̱apangugyatan nang tinalimaan natetenged tung papintu nang atia kung unu yapay gustu nang ianing. ");
INSERT INTO tbk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Purisu mag̱aning ti Jesus ang nagtuw̱al tung nira, “Abaw, pati yamung mga tauanamu pa ka man yeen, indiamu pa ka pala maskeng mag̱intindi? Ayw̱a, indi mi pa ka enged nag̱aintindian ang maskin unu pay magpakled tung sasang tau ang liit tung lua belag̱an ang mag̱aning ang yay sarang ang magpamansa tung anyang indi ra magkabag̱ay tung pagterelengen yang Dios? ");
INSERT INTO tbk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ay pa ag̱ari, yang pakleran na, belag̱an yang kinaisipan na, kung indi, ya ra ilem yang tian na ang pagkatapus itaki na ra ka ilem,” ag̱aaning ti Jesus. (Yuung ti Marcos ang nagsulat may yeen kang isaleet ang ipasanag. Yang linagpakan yang inaning ni Jesus ang atii ay maskin unu pang palanganenay, anda ray dapat ang liliien tang mga tumatalig tung anya, kung indi, luw̱us dang puiding mapakinaw̱angan ta.) ");
INSERT INTO tbk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mag̱aning ti Jesus ang nagsugpat yang bitala na, “Yang malain ang nag̱aeyang tung kinaisipan yang sasang tau ya ray pagpamansa tung anyang indi ra magkabag̱ay tung pagterelengen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Kipurki duun tung kinaisipan na nag̱aeyang yang mga pagtirimaen nang malalain ang ya ra kay maning pa tung manuw̱ul tung anyang mangumbaw̱ay ra, mangunlalii ra, manakaw ra, mangimatay ra tung masigkatau na, maglimbung da tung kasawa na, kuw̱ali manalensen, magbuat da ta malalain tung mga masigkatau na, magpandaya ra, magbuat da ta malalaway ang anday eyak-eyak na, mag̱iw̱eg da, magduminar da, magpalandaw ra tung sadili na, ubin magbuat da ta kalukuan ang indi na ra ag̱isipen. ");
INSERT INTO tbk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yang tanan ang mga maning tiang mga ubra-ubrang malalain duun nag̱aeyang tung sadiling kinaisipan yang sasang tau ig ya ka man ay pagpamansa tung anyang indi ra magkabag̱ay tung pagterelengen yang Dios,” ag̱aaning duun ti Jesus tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Taa numanyan ti Jesus nagliit dang minangay duun tung sasang lugar ang kakunayungan yang siudad ang Tiro. Pagpakled na tung balay, gustu na ra rin ang anda ray makdek ang tanya asan da. Piru anday maimu na, kung indi, nasiplatan da ka enged. ");
INSERT INTO tbk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ay may sasang baw̱ay ang may ana nang baw̱ay ang pag̱aekel-ekelan ta dimunyu ang ya ray nabalitaan ang ti Jesus takaa ra tung balay. Purisu dayun na rang inangay. Tung pagkaw̱ut na, dayun da ilem ang nagpadagpa tung pinagtalungaan nirang durua ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yang baw̱ay ang atia belag̱an Judio, kung indi, Sirofenicia yang nasyun na. Numanyan durung pagpakiildaw na tung ni Jesus ang yang dimunyung atiang pag̱ekel-ekel tung ana na palayasen na ra. ");
INSERT INTO tbk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Numanyan tung itinuw̱al ni Jesus, yang mga Judio ya ra ipananglitay na tung mga mamula ang mag̱aning, “Kaministiran ang yang mga mamula ya ray tukaw ang pampapaanen. Indi ra magkabag̱ay ang yang pamangan nira ya pa iplekay tung mga kirung payendeng.” ");
INSERT INTO tbk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mag̱aning ka yang baw̱ay ang nagtimales, “Kung tung bag̱ay, tama ka rin, Ameey. Piru maskin nganing mga kiru ka man ilem asan tung sirung yang lamisaan, nag̱asibsib ka nganing yang mga mumu ang pinamanganan yang mga mamula.” ");
INSERT INTO tbk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mag̱aning ka ti Jesus ang minles, “Durug tinlu pala yang tuw̱al mung atia. Kumus maning da tia yang nag̱abtang tung isip mu, uliken mu ra yang ana mu. Linayasan da yang dimunyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Atii, dayun da ka man ang minulik yang may ana. Kaw̱utan na yang ana na, durug kalimeng yang pagkabetang nang yag lulw̱ug tung katri ay linayasan da ka man yang dimunyu. ");
INSERT INTO tbk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taa numanyan, ti Jesus, nagliit da duun tung lugar ang atiing kakunayungan yang siudad ang Tiro ang nagdistinu duun tung sinakepan yang pag̱aningen ang Sam Puluk NGa Lansanganan, kasiraan da ka tanira yang mga tauan na. Tung pagparanawen nira namagpaliw̱ed da duun ampir tung siudad ang Sidon baklu namanuldak duun ampir tung aw̱uyuk ang atiang dakulu duun tung sinakepan yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Atiing nangakaw̱ut da tanira duun tung banwang atiing dinistinu nira, may idinangep tung anyang sasang tau ang bengel ang pisan yang talinga na ig kung magbitala ya ra ilem agpag̱ungal-ungal. Numanyan ya ray ipinagpakiildaw yang mga aruman na tung ni Jesus ang deenan na ang para magmaayen da. ");
INSERT INTO tbk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Purisu ingkelan da ni Jesus ang ipinaalawid-lawid ta gesye tung mga taung atiang buntun ang para tanira ra ilem ang durua. Pagkatapus dayun na rang ilinuyuk yang tulduk na tung talinga yang taung atiang magtimbang. Pagkatapus ta luyuk na, dayun na rang linawayan yang tulduk nang sam bilug ang ya ray ipiniid na tung dilak yang aruman na. ");
INSERT INTO tbk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pagkatapus, diritsyu rang tuminingarang duminag̱em ang pagkatapus dayun na rang pinag̱aning yang taung atia tung bitalang natauan nira ang “Ipata!” ang tung bitala ta yang gustu nang ianing, “Mangikas da!” ");
INSERT INTO tbk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Atii, insigidang nangikas da ka man yang talinga na ig luminakan da ka man yang dilak nang nag̱impisa rang nagbitala ta matandes. ");
INSERT INTO tbk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pagkatapus dayun dang nagkalalangan ti Jesus tung nirang tanan ang nangaita ang indi enged mamagbaw̱alitaen maskin tung ninu pa. Piru kung ay pa tiing linalangan na ta mupia, asan da kang namagbaw̱alitaen ang mas pa. ");
INSERT INTO tbk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Purisu yang mga taung atiang nabalitaan, nangabereng da ta dakulung pagkabereng. Namag̱araning-aningan dang mag̱aning, “Durug katitinlu yang tanan ang nag̱abuat na. Yang mga taung bengel da rin, nag̱apaanting na ig yang mga taung apa, nag̱apabitala na ka ta matandes,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Taa numanyan tung mga kaldaw ang atii, namagsaragpun si yang mga taung buntun duun tung ni Jesus. Atiing nangalubsan da tanira ta mga balun nirang pamangan, ginuuyan da ni Jesus yang mga taung nag̱apangugyatan nang inaning, “Abaa, yuu ra ag̱aildaw tung mga taung naang buntun. Teed mi, pangyaklu rang kaldaw taa tung yaten numaan ang pagkatapus nangalubsan da ta mga balun nirang pamangan. ");
INSERT INTO tbk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kung pampapanawenu ra ilem ang pampauliken ang indi pa pangapamangan, muya pampaklag̱en pa ta suw̱uk tung dalan, ay alawid ka yang ulikan yang duma.” ");
INSERT INTO tbk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mag̱aning yang mga tauan nang namagtimales, “Maskin mag̱aninga, ay pay pangkelan ta pamangan taa tung banwang naang kapas ang para ipapaan tung mga taung atia?” ");
INSERT INTO tbk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mag̱aning ka ti Jesus ang nagtalimaan tung nira, “Ayw̱a, pira pang bilug ang tinapay ang nadipara mi asan?” Yang tuw̱al nira, “Ay pa taa? Pitu ra ilem ang bilug ang gereg̱esye,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Numanyan, nagkalalangan da ti Jesus tung mga taung atiang buntun ang mamansikarung da kanay asan tung tanek. Pagkatapus dayun na rang dinawat yang mga tinapay ang atiang pitung bilug ang ya ray pinasalamatan na tung Dios. Pagkatapus, dayun na rang pinagpingas-pingas ang ipinamakdul-pakdul tung mga taung atiang nag̱apangugyatan na ang para ipanagtag-tagtag nira tung mga taung atiang buntun. Ang pagkatapus ya ka ra ka man ay binuat nira. ");
INSERT INTO tbk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dispuis may pira pa ilem ang bilug ang mga ian ang gereg̱esye ang nasepet ka nira ang ya si kay pinasalamatan na tung Dios. Pagkatapus itinuw̱ul na ra ka dayun tung mga tauan nang ipamparawat-dawat da ka nira tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Taa numanyan, nangapamangan da tanirang asta namampabial. Pagkatapus atiing eepen da yang mga tauan ni Jesus yang mga eped nirang namamangan, pitu pa nga begyasan yang napnuk nira. ");
INSERT INTO tbk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kung bilangen yang mga taung atiang namamangan, nagdangat da tung mga epat ang liw̱u nga tauan. Pagkatapus numanyan, pinampapanaw ra ni Jesus yang mga taung atiang buntun ang para mamag̱urulikan da. ");
INSERT INTO tbk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pagkatapus, dayun dang nagsaay tung balangay ang nagpatindak duun tung banwang sinakepan yang Dalmanuta, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Taa numanyan, may mga Pariseong namansikaw̱ut dang namag̱intra pakigsug̱a tung ni Jesus. Namag̱ingaluk da tung anya ang paitaan na tanira ta pruibang liit tung langit ang para asan da nga tuungay nira kung may kagaeman na ka man ang liit tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pagkagngel ni Jesus tia, dayun dang duminag̱es ang mag̱aning, “Uu, yamung mga tauamung mga masigkanasyunu simanyan! Ayw̱at pag̱ingalukamu pa ka enged ta pruiba bakluamu ra mananged tung yeen? Iugtulu tung numyu yang kamatuuran ang sumpaanu pa tung Dios, talagang anda enged ay pruiba ang ipaita tung maning tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pagkatapus dayun na ra ilem ang binutwanan yang mga taung atiang nagsaay si tung balangay ang nagpatindak, kasiraan da ka tanira yang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Taa numanyan, tung pagsaay nira, nangalipat da yang mga tauan ni Jesus ang namagbalun ta mga tinapay. Sam bilug ilem yang ekel nira tung balangay. ");
INSERT INTO tbk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Numanyan mag̱aning ti Jesus ang nagpaaman tung nira, “Kuidaw, amanan mi ta mupia yang pampaleskag ang nag̱agamit yang mga Pariseo pati ni Adi Herodes,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pagkagngel nira tia, dayun da nirang pinagkeresenan ta maluw̱ay ang mag̱aning, “Siguru napagbitala ra ta maning tia ay sasang pasaplid na tung yaten ay indiita ra ka man napagbalun ta mga tinapay.” ");
INSERT INTO tbk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Numanyan pagkasiman ni Jesus kung unu pay pinagkeresenan nira, dayun na rang tinalimaan ang inaning, “Ayw̱a ya ray nag̱apagkeresenan mi ang anday ekel ming balun ang tinapay? Indiamu pa ka enged nag̱aintindi? Anda pa ka enged ay nag̱amaresmesan mi? Talagang maluw̱ay pa ka enged yang pagtaralig̱en mi tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","May mata mi, piru indiamu matakung magteleng? May talinga mi, piru indiamu matakung mamati? ");
INSERT INTO tbk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ayw̱a, indi mi ra nag̱ademdeman atiing may lima ilem ang bilug ang tinapay ang pinagpingas-pingasung ipinampapaan tung limang liw̱u nga tauan kung pira pa nga baayan ang punuk ta mga eped nirang ineep mi?” Mag̱aning ka tanirang nansituw̱al, “Sam puluk may durua.” ");
INSERT INTO tbk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mag̱aning si ti Jesus ang nagpadayun yang bitala na, “Pati atiing may pitu ilem ang bilug ang tinapay ang ipinampapaanu tung epat ang liw̱u nga tauan, nag̱alipatan mi ra ka kung pira pa nga begyasan ang punuk ta mga eped nirang ineep mi?” Mag̱aning ka tanirang namagtimales, “Pitu.” ");
INSERT INTO tbk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mag̱aning si ti Jesus ang nagsugpat, “Ta, indiamu pa ka enged nag̱aintindi?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Taa numanyan, namagpatindak si tanira na Jesus duun tung Betsaida. Mamansikaw̱ut duun, may sasang buray ang idinangep yang mga tau tung ni Jesus ang ipinagpakiildaw ang deenan nang pabuskaren yang mata na. ");
INSERT INTO tbk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Purisu dayun dang pinggesan ni Jesus tung kalima nang ingkelan duun tung lua yang lansangan. Numanyan dayun na rang linawayan yang mata nang pagkatapus dineenan na pa kang inaning, “Ta, may nag̱aita mu?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Atii, itineleng na yang mata nang ipinikat-pikat ang pagkatapus dayun dang nagtuw̱al tung ni Jesus ang mag̱aning, “Ee rin. Nag̱aitaw ra rin ta mga taung pamagpanaw-panaw, piru ang telenganu kuari ra ilem mga ayu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Atii dineenan si ni Jesus ang uman yang mata na. Pagkadeen na tung mata na, tumineleng da ta madekdek ang ya ra kay pagkaulik yang paneleng na. Masadlaw ra yang tanan ang pag̱atelengan na. ");
INSERT INTO tbk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Numanyan dayun dang pinaulik ni Jesus duun tung balay na ang may bitalang ipinabalun na tung anyang mag̱aning, “India ra ilem manggetes taa tung lansangan ang magbaw̱alitaen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Taa numanyan, minangay ra ti Jesus duun tung mga baryung sinakepan yang lansangan ang nag̱aguuyan tung Cesarea Felipe, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. Atiing pagpanaw nira tung karsada, napagtalimaan da ti Jesus tung mga aruman nang mag̱aning, “Elat kanay, Kung yuu pagkeresen-kesenan ta mga tau, unu pay pagpabetang nira tung yeen?” ");
INSERT INTO tbk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mag̱aning tanirang namagtimales, “Kalaum yang mga tau ang yawa unu ay sasang taung nagpablag da ang ya si ka unu ay nagbalik taa tung kaliw̱utan ang naa. Ay mag̱aning yang duma ang yawa unu ti Juan ang manigbenyag. Yang duma pag̱aning ka ang yawa unu ti Elias. Yang pintu yang duma ang yawa unu sasang manigpalatay yang bitala yang Dios atiing tukaw ang nabui si kang uman.” ");
INSERT INTO tbk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mag̱aning ti Jesus ang nanalimaan si, “Ay ta numyu, unu pay numyung pagpabetang tung yeen?” Atii, ti Pedro ya ray nagtuw̱al ang mag̱aning, “Yawa yang pag̱aningen ang Cristo.” ");
INSERT INTO tbk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Numanyan dayun dang nagkalalangan ti Jesus tung nirang tanan, “Luay! Indiamu ra kanay magbaw̱alitaen maskin tung ninu pa ang yuu yang pag̱aningen ang Cristo,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Atii, ya ray ipinag̱impisa nang nagpasanag tung mga taung nag̱apangugyatan na ang mag̱aning, “Yang pinalanu yang Dios para tung yeen ang pag̱aningen ang Maninga Tau, dapataung mapasaran ta pinitinsiang durug lebat. Kipurki pangindianaw yang mga pamagpakigmaepet kasiraan da ka tanira yang mga paring arabubwat ta katengdanan may yang mga sag̱ad. Pagkatapus ipaimatayaw ra ka dayun nira. Piru maskin pang maning tia yang dapat ang mapasaranu, tung pagkaw̱ut yang yaklung kaldaw, pabungkarasenaw ra ka enged yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Durug kasanag yang pagpaintindi nang atia tung nira. Numanyan, pagkagngel ni Pedro tia, dayun na rang ingkelan ti Jesus ang ipinabinit ang pagkatapus pinag̱intraan na ra sambeng. ");
INSERT INTO tbk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Atii, nagbedleng da ti Jesus ang pati yang kadaklan ang nag̱apangugyatan na nakatalungaan na ka ang pagkatapus dayun na rang sinambeng ti Pedrong inaning, “Paaw̱ig̱a ra taa! Yawa ra pala ay pagsatanas tung yeen! Ay kipurki tung pag̱ampalar mung atia tung yeen, belag̱an yang nag̱aisipan yang Dios yang nag̱usuyun mu, kung indi, ya ka ilem yang isip ta tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Numanyan dayun dang ginuuyan ni Jesus yang mga taung atiang buntun pati yang mga taung atiang nag̱apangugyatan nang mamagpalenget da tung anya. Pagkatapus dayun na kang inaning, “Kung tinu pay nag̱alelyag dang magpakignunut tung yeen, yang sadili na ya ra lipatay na. Yang isip na ya ag̱ipatentenay nang mag̱agwanta tung mga pinitinsia, maskin ilansang pa tung krus. Dapat maning tia yay ipabalay na tung isip na kung gustu nang magpaugyat tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ay kipurki kung tinu pay ag̱alelyag ang yang sadili na ilibri na tung malain, asan da nga kapa-kapaay na yang kaampiran na tung yeen. Piru kung tinu pay mamirdi tung sadiling kalelyag̱an na natetenged ilem tung yeen ang yuu ray nag̱ipalusu na ta gegma na ig natetenged ka tung Matinlung Balita natetenged tung yeen ang ya ray gustu nang ipagpakaw̱ut tung mga tau, asan da nga siguruay na yang kaampiran na tung yeen ang yay pagnatisan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ay kipurki unu pa pay pakinaw̱ang yang sasang taung magkatinir da ta tanan ang nag̱alelyag̱an na taa tung kaliw̱utan ang naa ang pagkatapus asan da nga plekay ta ipagnatis na tung kaliw̱utan ang baklu? Andang pisan! ");
INSERT INTO tbk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ay kung ya pay maplek tia, unu pa pay sarang ang mabailu na ang para bawien na pa rin? Andang pisan! ");
INSERT INTO tbk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ag̱aningenamu ra yeen ta maning tia ay natetenged yang kadaklan ang mga masigkanasyun mi numanyan durug kakinasalananen ig rusaw ra yang gegma nira tung Dios. Purisu kung tinu pay maeyak ang mangerengan tung yeen ubin yang bitalaw ikaeyak na kang ipagngel tung nira, tay tung uras ang ipaglekatu, ikaeyaku kang ingwaraen ang tanya belag̱an tauanu. Ay ta yeen ang pag̱aningen ang Maninga Tau, kung maggaraemenaw ra nganing tung kaliw̱utan ang baklu, yang kasusulawen ang pag̱atiniran ni Ama ya ra kay tiniranu ig magkasira-siraanami ra ka yang mga angil ang sagradu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mag̱aning ti Jesus ang nagsugpat yang bitala na tung nira, “Iugtulu tung numyu yang kamatuuran. May duma asan tung numyu ang baklu magkarapatay, mabilug̱an da ka enged nira yang puirsa yang paggaraemen yang Dios,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Taa numanyan, pagkataklib da yang enem ang kaldaw, ingkelan na ti Pedro may ti Santiagong durua ni Juan ang namansitungul tung sasang bukid ang makbu ang tanira tanira ra ilem. Atiing duun da tanira, naglew̱ad da yang pagkabetang ni Jesus tung pinagtaralungaan nira. ");
INSERT INTO tbk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yang aw̱el na masulaw ra ig duru rang pisan agkakulit. Maskin unien pa ta baka yang sasang aw̱el ang papanikuliten, anda ray pakdingan ta kakulit tung aw̱el na. ");
INSERT INTO tbk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Numanyan asan da nansilput ti Elias durua ni Moises. Pamagkeresen tanira ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Numanyan nabnga ra ti Pedrong mag̱aning tung ni Jesus, “Rabbi, maayen ilem naawami ra ka. Tugtayami kang magpakdeng ta tulu nga layang-layangan, salegsam bilug mi ni Moises may ni Elias,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Naa pala, napagbitala ra ta maning tia, ay ya ra ilem nabnga na yang kumpurming kinaw̱ut yang isip na ay dinlaan da ta mupia tanira yang mga aruman na. ");
INSERT INTO tbk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Atii, may sasang panganud ang ya ray nagpaulung tung nirang tanan ang pagkatapus may nagngel da nirang busis ang asan manliit tung panganud ang atia ang mag̱aning ang pagbitala, “Uay, atia ra yang pag̱aningenung anaw ang nag̱apabuyukanu ta gegmaw. Intindien mi ra ta maayen yang kumpurming ianing na tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Unaw̱is maneleng-teleng tanira, anda ray naita nira, kung indi, ti Jesus da ilem ang sam bilug. ");
INSERT INTO tbk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Numanyan atiing pamandanek da tanira tung bukid ang atii, pinag̱urdinan da tanira ni Jesus ang pinag̱aning, “Indiamu ra kanay magbaw̱alitaen maskin tung ninu pa natetenged tung naita ming atii ang asta kaw̱utun da ilem yang uras ang yuung pag̱aningen ang Maninga Tau pabungkarasenaw ra yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Numanyan maskin inegteman da ka man nira yang bag̱ay ang atia, piru durung keresen-kesen nira natetenged tung inaning na ang tanya buien si ka yang Dios ang uman, kung unu pa kaya ay lagpakan na. ");
INSERT INTO tbk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Purisu ya ray ipinagtalimaan nira tung anyang mag̱aning, “Ay kung maning tii yang mainabu tung nuyu, ayw̱a kaya nag̱itulduk yang mga sag̱ad ang ti Elias ang atiang baklu ka ilem naita ta, dapat unu tukaw ang magbalik baklu lumua yang pag̱aningen ang Cristo?” ");
INSERT INTO tbk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mag̱aning ti Jesus ang tuminuw̱al, “Kung tung bag̱ay, tama ka man yang nag̱itulduk nirang atia ang yang pag̱aningen ang Cristo matkawan ni Elias ang lumua ang pagkatapus yay magpaiwan-iwan ug̱ud simpan da rin yang mga taung mamampauyun tung pag̱uri tung anya. Piru yang dapat ang paneem-neeman mi ta maayen ya ra yang sasang napabtang tung kasulatan natetenged tung yeen ang pag̱aningen ang Maninga Tau ang yuu unu durung pinitinsiang mapasaranu ay lamkuenaw ta mga tau ang yuu anday kuintaung pagkatau. ");
INSERT INTO tbk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Piru iugtulu tung numyu, kuminaw̱ut da ka man ti Elias piru binuatan ta mga tau yang kumpurming nalelyag̱an nira ang katulad ka tung napabtang tung kasulatan natetenged tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Taa numanyan, pandanek da nira tung bukid, kinaw̱utan da nira yang mga taung nag̱apangugyatan ni Jesus ang nagkarabutwan tung datal. Pagkaw̱ut nira, durug dakel yang mga taung naita nirang pamagtaripukpuk tung mga tauan nang atia ig may mga sag̱ad tung mga riglamintung pamagpakigsug̱a tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Atii, pagkaita yang mga taung atiang buntun tung ni Jesus, nangabereng da ta mupia. Purisu dayun da nirang dinag̱umukan ang kinumusta. ");
INSERT INTO tbk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Numanyan dayun dang tinalimaan ni Jesus yang mga taung nag̱apangugyatan nang atia ang inaning, “Unu pay nag̱apagsurug̱aan mi?” ");
INSERT INTO tbk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Numanyan may sasang tau asan tung mga taung atiang gaw̱ung ang ya ray nagsublang ang mag̱aning tung ni Jesus, “Ameey, ag̱idangepu ra tung nuyu yang anaung lalii ay pag̱aekel-ekelan ta dimunyung yay pagpaapa tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada ulag̱en yang dimunyu, nag̱ilampak na tung tanek. Pagkaretket yang isi na ang nunut da ka ta paglawayway yang nganga na, pagkatapus dayun dang mangekbel. Ipinataw̱angu ra rin tung mga taung naang nag̱apangugyatan mu ang para palayasen nira yang dimunyung atia, piru indi ra ka ilem nasarangan nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Numanyan tung pagtuw̱al ni Jesus, tung nira rang tanan iparumbuay na yang bitala nang mag̱aning, “Uu, yamung mga tauamung mga masigkanasyunu simanyan! Ay ra yang pagtalig mi? Midyu tung maglakgasenaw ra tung numyu kung sanuamu ra kaya ngaeyangay ta ipagtalig ming ustu tung yeen! Ala, eklan mi ra tani tung yeen yang mula,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Atii, dayun dang ingkelan nira yang mula tung anya. Numanyan pagkaita yang dimunyu tung ni Jesus, dayun na rang linuw̱ag yang mulang pinapagkegteng ta mupia ang asta nalampak da ilem tung tanek ang nagpulpul ang nunut da ka ta paglawayway yang nganga na. ");
INSERT INTO tbk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dayun dang tinalimaan ni Jesus yang amaen ang inaning, “Pira rang takun ang maning da tia yang pagkabetang na?” Ag̱aaning yang may anang tuminuw̱al, “Duminalpet tung anya atiing mula pang gesye ang asta ra ilem simanyan. ");
INSERT INTO tbk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Muya-muyang pag̱atag̱aman da rin yang dimunyung imatayen. Ang kaisan, manga ilanggid na tung apuy, ang kaisan manga ilanggid na ka tung wai ang para malmes. Purisu ildawayami kang taw̱angan, kung masarangan mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mag̱aning ti Jesus ang nagtimales, “Unu pay gustu mung ianing kung masaranganu? Kung tinu pay magtalig tung yeen, maimuanu ta maskin unu pa.” ");
INSERT INTO tbk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Atii dayun dang nagkekendalen yang may ana ang mag̱aning tung ni Jesus, “Aay, nag̱apagtalig̱aw ra rin tung nuyu! Iplek mu ra yang pagkadiskumpiaduu!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Numanyan atiing pagkaita ni Jesus yang mga taung atiang buntun ang midyu mamagdag̱umuk si tung anya, dayun dang nagkalalangan tung dimunyung atiang mag̱aning, “Yawang dimunyua ang pagpaapa kag pagpabengel tung mulang naa, lalangana ra yeen ang maglayasa ra asan tung anya ang asta tung sampa indi mu ra enged balikan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Atii, naglelpaken da yang dimunyu ang linuw̱ag na yang mulang pinapagkegteng ta muya-muya, baklu naglayas. Numanyan yang mula, maninga patay ra. Purisu ya ra ka man ag̱aningay yang kadaklan ang mga tau ang, “Patay ra!” ");
INSERT INTO tbk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piru ti Jesus tanya, pagpeg̱es na tung kalima yang mula, dayun na rang pinabungkaras ang asta kumindeng da. ");
INSERT INTO tbk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Taa numanyan, pagkapakled ni Jesus tung balay ang tanira tanira ra ilem yang mga taung nag̱apangugyatan na, dayun da nirang tinalimaan ang inaning, “Natetenged tung unu pa w̱asu indiami nasarang ang napagpalayas tung dimunyung atia?” ");
INSERT INTO tbk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mag̱aning ka ti Jesus ang nagtuw̱al, “Yang maning tiang klasi ta dimunyu indi ta mapalayas kung indi ta ipag̱ampu tung Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Taa numanyan, ti Jesus may yang mga taung atiang nag̱apangugyatan na, dayun dang namagliit tung banwang atii ang namagpadayun yang pagparanawen nira duun tung sinakepan yang Galilea. Gustu ni Jesus ang anday makdek tung pagparanawen nirang atia ug̱ud liw̱ianu rang magpasanag tung mga aruman na. Maning taa yang inaning na tung nira: “Yang mainabu tung yeen ang pag̱aningen ang Maninga Tau, iintrigaw tung pudir yang mga taung ya ra ka man ay mamagpaimatay tung yeen ang pagkatapus kung mapaimatayaw ra nganing nira, tung yaklung kaldaw magbungkarasaw si ka,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ug̱aring indi ilem namaresmesan nira yang ipinasanag nang atia. Yadwa pa pamandalenden pa tanirang mamagtalimaan tung anya kung unu pay gustu nang ianing. ");
INSERT INTO tbk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Taa numanyan, nangakaw̱ut da duun tung lansangan ang Capernaum. Pagkatapus atiing duun da tanira tung kakleran yang balay ang pag̱atiniran nira, nagtalimaan da ti Jesus tung nirang mag̱aning, “Elat kanay, unu pay pinagbaralalaan mi nungayna tung pagparanawen ta?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piru tanira indi namag̱iw̱ek-iw̱ek. Ay ya pa ag̱ari, namagbaralalaan da kung tinu pay pinakalandaw tung nirang tanan ang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Numanyan dayun dang nagkarung ti Jesus ang nagguuy tung mga tauan nang atiang sam puluk may durua ang mamagpalenget da tung anya. Napagbitala ra tung nirang mag̱aning, “Kung tinu pay nag̱alelyag ang telengan yang Dios ta landaw, kaministiran ang yang sadili na ipabtang nang pinakaaranek tung tanan ang mga kaarumanan na ig mapinagpaiwan-iwan tung nirang tanan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Numanyan, may sasang mulang ingkelan ni Jesus ang kinaw̱ed na tung pinagtaralungaan nirang tanan. Pagkatapus, dayun sing nagbitala tung nirang mag̱aning, “Kung tinu pay magparanek tung sadili nang magrisibi tung maskin tinu pa ang aranek ta pagkabetang ang pariu ka tung mulang naa natetenged tung pagtalig na tung yeen, katimbang nang yuu kay nag̱arisibi na. Ig kung tinu pay magrisibi tung yeen, belag da ilem yuuy nag̱asapet na, kung indi, pati yang nagtuw̱ul tung yeen, ya kay nag̱arisibi na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Numanyan pagkagngel ni Juan tia, dayun dang nabnga tung ni Jesus ang mag̱aning, “Ameey, nuntaa pa, may sasang taung naita yamen ang atia pala nag̱apagpalayas ta mga dimunyu ekel tung kagaeman mu ang yang aran mu yay nag̱ainambit na. Purisu dayun dang pinagsambeng yamen ay natetenged belag̱an kang lag̱ing ugpu yamen ang mga tauan mu.” ");
INSERT INTO tbk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mag̱aning ti Jesus ang minles, “Eey, dapat ang indi mi ra rin pinagsambeng. Ayw̱a, yang sasang taung nag̱apagpalapus da nganing ta pruibang maktel ekel tung kagaemanu, indi magsaway agkali tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tutal, yang taung indi nganing pagkuntra tung yaten, katimbang nang pagtaw̱ang ka tung yaten. ");
INSERT INTO tbk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ay kipurki kung tinu pay magpadag̱en-dag̱en tung numyu, maskin gesyeng bag̱ay ra ilem yang itaw̱ang na ang katulad ka tung sam basu ra ilem ang waing ipainem na tung numyu natetenged ag̱ilalaenamu ra ka anya ang pag̱atuw̱ulamu ra yeen ang pag̱aningen ang Cristo, iugtulu tung numyu yang kamatuuran, talagang balesan ka enged yang Dios yang pagtaraw̱angen nang atia tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Piru kanugun yang pagkabetang yang sasang tau tung uri ang kumpurming magpatalang tung sasang pagtalig da tung yeen ang asta magpakasalak da ubin mamalpas da tung yeen, maskin sam bilug ilem tung mga mamulang naa. Ay kipurki mas malbat yang kalainan ang maagmaan na kay tung buntug̱an da ilem duun tung alauran. ");
INSERT INTO tbk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Dispuis pa, kung midyu yang kalima ming tuu yay gamiten ming magpakasalak, sibaya mapungkulanamu ra asan ta panguntiel mi tung tuksu, tung magpanunut, indiamu ra enged. Kipurki maayen pang maplekanamu ra ta sam parti ilem tung tinanguni mi kay tung anda pay buin ang duunamu ra manampet tung impirnu ang yang apuy na andang pisan ay kapugdaw-pugdawan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Pariu ka kung midyu yang kakay mi yay gamiten ming magpakasalak, sibaya mapungkulanamu ra asan ta panguntiel, tung magpanunut, indiamu ra ka enged. Maayen pang pungkul yang kakay ming sam belak, ang mapagpakigsapenamu ra tung Dios kay tung duruay kakay mi ang duunamu ka ilem iplekay tung impirnu. ");
INSERT INTO tbk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pariu ka ta palaksu kung midyu yang pagteleng mi ya ray makanayan ta ipagpakasalak mi, sibaya maluat da asan yang mata mi tung panguntiel mi, tung magpanunut, indiamu ra enged. Maayen pang sam bilug da ilem yang mata ming malg̱ud tung paggaraemen yang Dios tung uri kay tung duruay mata mi ang duunamu ra ka ilem iplekay tung impirnu. ");
INSERT INTO tbk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Duun anda enged ang pisan ay katapus-tapusan yang pinitinsiang maagmaan yang mga tau, kung indi, dumayun ka enged yang pagkadiadu nirang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dapatamu rang manguntiel ta mupia tung mga panuksung mga maning tia, ay kipurki yang tanan kasinan ta apuy. ");
INSERT INTO tbk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kung natetenged tung kasin, kung tung bag̱ay, durug tinlung gamiten. Piru nusias malaktan da ta dumang bag̱ay, anda ray rimidyung sarang ang mabuat ang para maulikan pa yang pagkatema na. Purisu kaministiran ang yang gegma mi tung Dios maning pa tung tema kang pirmi ig yang pag̱uruyunan ming magpurutul pirmi kang eklan mi tung matinlu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Taa numanyan, ti Jesus nagliit da duun tung Galilea ang minangay duun tung sinakepan yang Judea ang asta nagpalakted da tung subang atiang pag̱aningen ang Jordan, kasiraan da ka tanira yang mga tauan na. Atiing duun da, duru sing mga taung namagtaripukpuk tung anya. Purisu dayun sing nagturuldukun tung nira ang katulad ka tung pag̱abuat na kang lag̱i. ");
INSERT INTO tbk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Numanyan may mga Pariseong namansikaw̱ut da. Kumus may gustu nirang papagmintiraen ti Jesus ang para mabitala ilem ta magbalaw̱ag tung katuw̱ulan yang Dios, dayun dang namagtalimaan tung anyang mag̱aning, “Uyun basu tung mga katuw̱ulan ang nag̱ausuy ta ang yang sasang lalii puiding magpakiblag tung kasawa na?” ");
INSERT INTO tbk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mag̱aning ti Jesus ang nagtimales, “Ayw̱a, unu pay katuw̱ulan ang ibinutwan ni Moises atiing tukaw natetenged tung bag̱ay ang atia?” ");
INSERT INTO tbk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mag̱aning ka tanirang namansituw̱al, “Ilinug̱ut ni Moises ang yang sasang lalii puidi unung magpakiblag tung kasawa na basta magpasulat unu ta bawdukumintu ang yay magpaingmatuud ang tapus da ka man yang pagkakasawaan nira.” ");
INSERT INTO tbk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mag̱aning ka ti Jesus ang nagtimales, “Yang ipinagsulat ni Moises yang riglamintung atia para tung numyu ya ra yang kateteg̱asen yang mga kinaisipan mi. ");
INSERT INTO tbk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ay napabtang tung kasulatan ang atiing primirung pag̱imu yang Dios tung tau, inimu na unung lalii may baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Purisu unu ya ra kay natengeran na ang yang sasang lalii magliit da tung ni tatay na may tung ni nanay na ang para magpakiunung da tung ni kasawa na ang pagkatapus unu tanirang durua mag̱ing sa nga tinangunian da ilem. Ig disir, belag̱an dang durua pa, kung indi, sa nga tinangunian da ilem tanira. ");
INSERT INTO tbk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Purisu yang pinapagsasa ra yang Dios dapat ang indi belag̱en ta tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Taa numanyan atiing duun da tanira na Jesus tung balay ang pagdayunan nira, namagpasadsad da yang mga taung atiang nag̱apangugyatan na tung anya natetenged tung inaning nang atia sigun tung pagbelag ta magkasawa. ");
INSERT INTO tbk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mag̱aning ti Jesus ang nagpasanag tung nira, “Kung tinu pang laliiay ang magpakiblag tung kasawa na ang pagkatapus mangasawa sing uman tung dumang baw̱ay, asan da nga limbungay na yang kasawa nang atiang dati. ");
INSERT INTO tbk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dispuis, maskin tung mga baw̱ay, kung tinu pay magpakiblag tung kasawa na ang pagkatapus magpakasawa si tung dumang lalii, asan da ka nga limbungay na yang kasawa nang atiang dati,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Taa numanyan may mininsa ang may mga taung namag̱ekel tung mga ana nira tung ni Jesus ang para pampabisaen nira tung anya. Piru sinambeng da yang mga taung atiang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkaita ni Jesus yang pag̱abuat nira, dayun dang inerepan dang nag̱ampalar tung nirang mag̱aning, “Eey, yang mga mamulang atia, paw̱ayaan mi ra ilem ang mamagpalenget tani tung yeen. Indi mi ra enged pagsagangen, ay kipurki kung tinu pay may pagtalig nira tung Dios ang katulad ka tung pagtaralig̱en yang mga mamulang atiang bug̱us tung mga ginikanan nira, lug̱ud da tung mga taung pamagpagaem ang bug̱us tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iugtulu tung numyu yang kamatuuran, kung tinu pay indi magpagaem tung Dios ang katulad ka tung sasang mulang bug̱us yang pagpagaem na tung nga ginikanan na, yang taung atia indi na ra enged maispirinsiaan tung sadili na kung unu pay palaksu yang paggaraemen yang Dios tung pagpangabui na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pagkatapus dayun na rang pinagsabak-sabak yang mga mamulang atiang pinampabisa. ");
INSERT INTO tbk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Taa numanyan, atiing magpanaw ra rin ti Jesus tung karsada, may sasang taung yag paglaksung pagpakigbag̱as tung anya. Pagkaw̱ut na, dayun dang nagluud tung katalungaan nang nagtalimaan tung anyang mag̱aning, “Ameey, nag̱askeanu ang yawa sasang maayen ang tau. Unu pa w̱asu ay dapat ang buatenu ug̱ud mapagpasapenaw tung Dios ang anday katapus-tapusan?” ");
INSERT INTO tbk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mag̱aning ka ti Jesus ang nagtimales, “Muya indi mu ilem nag̱askean kung unu pay linagpakan na atiing inaningaw ra nuyung maayen. Anday dumang sarang ang maaning mung maayen, kung indi, ultimu ilem yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yang mga katuw̱ulan na nag̱askean mu ra ka siguru. Ulitenu ra kanay ang ipademdem tung nuyu. ‘India mangimatay ta masigkatau mu, india maglimbung tung kasawa mu, india manakaw ta belag nuyu, india manistigus ta bukli tung katalungaan yang ustisia, india magdaya tung masigkatau mu, ig galangen mu ti tatay mu may ti nanay mu.’” ");
INSERT INTO tbk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mag̱aning ka yang taung atiang nagtimales, “Piru elat kanay, Ameey. Yang tanan ang atiang mga katuw̱ulan ang sinambit mu luw̱us dang nag̱atumanu mag̱impisa pang atiing paran-paranaw pa.” ");
INSERT INTO tbk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Numanyan tung pagteleng ni Jesus tung anya, ya ra nga gamen yang isip na tung anyang mag̱aning, “May sam bilug pang dapat ang buaten mu. Mulika ra kanay. Yang tanan ang kamanggaran mu ipaalang mu ra. Yang kabayaran nang kuarta ipamakdul-pakdul mu ra tung mga maliliwag̱en. Kung ya ray buaten mu tia, tay puis magkatinira ra ta kapakli nang maning pa ka tung sasang manggad mu duun tung langit. Dispuis pagkatapus ta pamakdul-pakdul mu, magbalika ra ka tani ang magpaugyat tung yeen ang para mag̱ing tauana ka yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagkagngel na tia, gulpi rang natalmed yang ityura nang nanluluw̱ay. Dayun da ilem ang nagliit ang duru rag kapungaw yang isip na. Ay ya pa ag̱ari, durung kamanggaran na. ");
INSERT INTO tbk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Numanyan paneleng-teleng ni Jesus tung mga taung atiang nag̱apangugyatan na, dayun dang nagbitala tung nirang mag̱aning, “Durug liwag ang yang sasang manggaranen magpalamtuk pa yang pundu yang isip nang magpagaem ang bug̱us tung Dios.” ");
INSERT INTO tbk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pagkagngel nira yang inaning ni Jesus ang atia, nangatingala ra ta duru. Piru ti Jesus dayun na rang sinugpatan yang bitala nang mag̱aning, “Mga putulu, duru ka man agliwag ang yang tau magpagaem tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kung maliwag nganing ang yang sasang kamilyu ang pumuyuk tung buli yang tingway, mas pang maliwag ang yang manggaranen magpalamtuk yang pundu yang isip nang magpagaem ang bug̱us tung Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Atii mas pang nangabereng ang pisan yang mga aruman nang mag̱aning tung anya, “Tay kung maning tii pala ang maski nganing yang mga manggaranen ang tag̱isip yamen ang alenget tung Dios indi nganing matapnay, ya pa yang kadaklan ang mga tau?” ");
INSERT INTO tbk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Atii dayun dang naneleng-teleng ti Jesus tung nira ang mag̱aning, “Kung tung tau ilem ka man, indi maimu tia. Piru kung tung Dios, maimu ra tia ay natetenged tung anya maimu yang tanan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Atii, ya ra ngabnga ti Pedro ang mag̱aning tung anya, “Teed mu, Ameey, ta yaming pagpaugyat tung nuyu, Ameey, binutwanan da yamen yang tanan basta magpakignunutami ra ilem tung nuyu.” ");
INSERT INTO tbk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Mag̱aning ka ti Jesus ang minles, “Iugtulu tung numyu yang kamatuuran, kumpurming tinu pay namutwan tung banwang natauan na ubin tung mga putul na ubin tung ginikanan na ubin tung mga ana na ubin tung mga ganadus na natetenged yuuy ag̱ipalusu na ta gegma na. Yadwa pa durung gustu nang magparakaw̱utun yang Matinlung Balita natetenged tung yeen. Purisu ya ray pakdulan yang Dios ta kapakli yang tanan ang atiang pinamutwanan na ang pira-pira rang dubli. Ay numaan tung panimpung naa, may mga kapakli nang mga balay, mga putul na, mga ginikanan na, mga ana na ig mga ganadus na. Piru denganen kang pasaran ta padeeg-deeg arangan da ilem tung yeen ang pag̱akegngan na. Dispuis kung kaw̱utun da nganing yang baklung panimpu, magsapenan da ka tanira yang Dios ang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ug̱aring ilem naa w̱a yang dapat ang pangamanan mi. Durung pag̱atelengan ta abwat simanyan ang ya ra iparanekay tung uri ig duru kang pag̱atelengan ta aranek simanyan ang ya ra ka ipaabwatay tung uri,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Taa numanyan, sigi-sigi ra yang pagparanawen nira na Jesus tung karsada ang pamanungul duun tung Jerusalem. Ti Jesus ya ray pagtukaw tung mga tauan na ang yay naberengan nira ta duru tung anya. Yang kadaklan ang mga taung pamag̱uri tung nira pamangelbaan da ta mupia. Taa numanyan, yang mga tauan nang atiang sam puluk may durua, pinampaligbin na sing pinapag̱intindi kung unu pay dapat ang mapasaran na. ");
INSERT INTO tbk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mag̱aning tung nira, “Ta, naawita rag panungul ang pag̱angay duun tung Jerusalem. Muya maberengamu tung ianingung naa tung numyu. Yuung pag̱aningen ang Maninga Tau, anday dumang mainabu tung yeen duun, kung indi, iintrigaw ra tung pudir yang mga paring arabubwat ta katengdanan may yang mga sag̱ad tung mga urdinansa, ang pagkatapus sintinsiaanaw ra nirang ipaimatay. Pagkatapus dayunaw si ka nirang iintriga tung pudir yang belag̱an mga masigkanasyun ta ang anda enged ay pag̱intindi nira tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Buatenaw ra ilem nirang sasang kayaman, lawayan pa nira yang tinanguniu ang pagkatapus paburdunanaw ra ka nira bakluaw imatayay nira. Piru pagkaw̱ut yang yaklung kaldaw, pabungkarasenaw ra ka enged yang Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Taa numanyan, namagpalenget da tung ni Jesus ti Santiagong duruang mag̱ari ni Juan ang yay mga ana ni Zebedeo. Mag̱aning tanira tung anya, “Ameey, gustu rin yamen ang kung unu pay ingalukun yamen tung nuyu ya ray ipapakdul mu tung yamen.” ");
INSERT INTO tbk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ag̱aaning ka ti Jesus ang minles, “Ayw̱a, unu pay nag̱alelyag̱an ming ipakdulu tung numyu?” ");
INSERT INTO tbk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mag̱aning ka tanirang nansituw̱al, “Kung kumarunga ra nganing tung puistu mung maggaraemen ang duru rag kasusulaw yang pagkabetang mu, ipakarungayami ka tung tepad mung magtimbang ang para kasiraanita ra kang maggaraemen tung mga tau.” ");
INSERT INTO tbk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mag̱aning ka ti Jesus ang nagtimales, “Indi mi ka ilem nag̱amaresmesan kung unu ra ilem ay nag̱aingaluk mi. Basu kayanan mi kang magpapinitinsia ang katulad ka tung pasaranu? Matenten da w̱asu yang mga isip ming manalunga tung kalainan ang katulad ka tung pag̱atalungaw?” ");
INSERT INTO tbk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mag̱aning ka tanirang nansituw̱al, “Ee, kayanan ka yamen.” Mag̱aning si ti Jesus tung nirang nagsugpat, “Mapasaran mi ka man yang mga pinitinsia ang katulad ka tung mapasaranu, manalungaamu ra ka man tung kalainan ang katulad ka tung pag̱atalungaw. ");
INSERT INTO tbk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piru kung tinu pay makarung tung teparung magtimbang ang para kasiraanaming maggaraemen, belag yuuy may pudir ang maglug̱ut, kung indi, ya ray nag̱itig̱ana yang Dios tung kumpurming tinu pay pinilik nang kumarung,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Numanyan atiing nangabalitaan da yang mga kaarumanan nirang sam puluk, namag̱intra ra kimun tung ni Santiago durua ni Juan. ");
INSERT INTO tbk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Purisu dayun dang ginuuyan ni Jesus tanirang tanan ang pinag̱aning, “Nag̱askean mi ra ka ang yang mga taung pag̱aningen ang may mga katengdanan tung mga tag̱a duma-rumang nasyun, yang katengdanan nira ya ag̱ipandeeg-deeg̱ay nira tung mga kinasakpan nira. Muya-muyang manuw̱ul tung mga sakep nira ang para ilalaen da nirang yay abwat tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piru tung numyu, indiaw malelyag ang yay usuyun mi yang sistima nirang atia, kung indi, kung tinu pay malelyag ang telengan ta abwat asan tung numyu, dapat ang yang pagpabetang na tung sadili na tanya sasa ilem ang turuw̱ulun ming mga kaarumanan na. ");
INSERT INTO tbk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kung tinu pay malelyag ang magmangulu tung numyu, dapat ka ang yang pagpabetang na tung sadili na tanya sasa ilem ang kirepen ming kadaklan. ");
INSERT INTO tbk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ay ya pa ag̱ari, ta yeen ang pag̱aningen ang Maninga Tau, yang katuyuanu belag̱an ang mag̱aning ang para yuuy magpanuw̱ul tung mga taung magpasikasu, kung indi, ang para yuuy mag̱ing turuw̱ulun nirang mag̱arasikasuen tung nira. Yang inangayu enged, ay magpatumbasaw yang linawaw ang para durung mga taung mapaluasu tung pagpakirepen nira tung pagburuaten nira yang kasalanan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Taa numanyan, pagkaw̱ut da ni Jesus duun tung lansangan ang Jerico, diritsyu-diritsyu ra ilem yang panaw nang asta nalua ra tung lansangan ang atia, kasiraan da ka tanira yang mga taung nag̱apangugyatan na pati mga taung buntun. Numanyan may sasang manigpalimus ang buray ang nag̱aranan tung ni Bartimeo ang yag kakarung tung binit yang karsada. Tanya ana ni Timeo. ");
INSERT INTO tbk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Numanyan pagkabalita na ang asan da ti Jesus ang atiang tag̱a Nazaret, dayun dang nagkekendalen ang mag̱aning, “Jesus, yawang panubli ra tung paggaraemen ni David, ildaway ka!” ");
INSERT INTO tbk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pagkatapus durung namagsambeng tung anyang mag̱ipes da. Piru belag ya mag̱ipes, kung indi, mas pang ya magkekendalen ang magkekendalen ang mag̱aning, “Yawang manubli ra tung paggaraemen ni David, ildaway ka!” ");
INSERT INTO tbk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Atii, nagtadeng da ti Jesus ang nagbitala tung mga taung atiang buntun ang mag̱aning, “Ala, guuyan mi ra kanay tia ang magpalenget da tani tung yeen.” Purisu dayun da ka man ang ginuuyan nirang inaning, “Ala, paktelen mu ra yang isip mu! Kemdenga ra asan ay nag̱aguuyana ra anyang magpalenget tung anya!” ");
INSERT INTO tbk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pagkagngel na tii, ya ra mamlek tung panlamig na ang pagkatapus dayun dang nagbungkaras ang nagpalenget tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mag̱aning ti Jesus ang nagbugnu tung anya, “Ta, unu pay gustu mung buatenu para tung nuyu?” Mag̱aning ka yang buray ang minles, “Ay Rabbi, gustuu rin ang maitaw si.” ");
INSERT INTO tbk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mag̱aning ka ti Jesus ang nagtimales, “Ala, mulika ra. Natetenged itinalig mu ra tung yeen yang sadili mu, naulikan da tia.” Atii lag̱i-lag̱ing naita si ka man ig nagpakignunut da dayun tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Taa numanyan, atiing pamanungul da tanira na Jesus tung bukid ang durung ayung pag̱aningen ang olibo ang alenget-lenget da tung siudad ang Jerusalem, may durua nga baryuan ang nag̱apalengtan nira ang paggug̱uuyan tung Betpage may Betania. Numanyan nanuw̱ul da ti Jesus tung durua nga tauan ang nag̱apangugyatan nang mag̱aning, “Ala, mangayamu ra kanay tung baryung atii tung tukawan ta. Kung kumaw̱utamu ra nganing asan, ya rang lag̱i ay mapanawan mi yang sasang asnung sinday pa ang yag kekedked ang inding pisan nag̱asaay-saayan ta tau. Ya ray badbaren ming guyuran tani. ");
INSERT INTO tbk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kung may magbugnu tung numyu ang unyen mi pa yang sinday ang atia, yamu ra ag̱aaning, ‘Kaministiran ni Ginuu ta. Kung matapus na ra nganing ta paggamit, ipabalik na ra kang lag̱i asan tung numyu,’” mag̱aning ti Jesus tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Purisu dayun da ka man ang namagpanaw yang duruang atia. Pagkaw̱ut nira tung baryu, may sasa ka man ang sinday ta asnung naita nira duun tung karsadang yag kekedked tung purta yang sasang balay. Pagkatapus, dayun da nirang binadbad. ");
INSERT INTO tbk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Atiing pag̱abadbad da nira, binugnu ra yang dumang kemdengan asan ang inaning, “Eey, ay tia? Ayw̱a nag̱abadbad mi tiang sinday?” ");
INSERT INTO tbk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dayun dang nansituw̱al yang duruang atia ta maning ka tiing ipinaetad ni Jesus tung nira. Purisu tinugtan da yang namagbugnu ang ipinaguyud. ");
INSERT INTO tbk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pagkatapus dayun dang ginuyuran nira yang sinday duun tung ni Jesus. Pagkaw̱ut nira, dayun dang inapilaan nira yang mga panlamig nira ang pagkatapus dayun da kang sinaayan ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Numanyan yang pagsaay na tung asnu, durung mga taung namagpakigluyug dang namagpaita yang paggaralangen nira tung anya. Yang duma ya ray namagluas yang mga panlamig nirang ipinameklad tung karsadang magpanawan yang asnu. Yang duma ya ray namaglampang ta mga paklang tung mga kabiw̱init-binitan ang ya ra kay ipinameklad nira tung karsada. ");
INSERT INTO tbk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Numanyan yang duma pamagtukaw tung ni Jesus, yang duma pamag̱uri. Sigi ilem yang pagkekendalen nirang pamansianing, “Salamat! Pakaayenen da kang pirmi yang Dios yang pag̱atuw̱ul nang naang magpalua yang paggaraemen na! ");
INSERT INTO tbk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Paktelen na ra ka ta mupia yang paggaraemen na tung yaten ang yay magkapariu ka tung paggaraemen ni Adi David ang kinaampu ta atiing tukaw! Salamat tung Dios duun tung kaabwat-abwatan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Taa numanyan pagpakled ni Jesus tung siudad ang Jerusalem, dayun dang minangay duun tung pagtuuan ang pinakalusu ang nagpakled tung palayas na. Pagpakled na, naneleng-teleng da tung tanan ang pagkarainabu duun. Pagkatapus ta pagpaniid, kumus apun da, dayun dang luminuang nagbalik duun tung Betania, kasiraan da ka tanira yang mga tauan na. ");
INSERT INTO tbk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Taa numanyan, pangayag ang timpranu, atiing pagliit na duun tung Betania ang pagbalik da tung siudad, ya ra nga suw̱uk. ");
INSERT INTO tbk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Atii tung tukawan, may nabandaw nang ayung pag̱aningen ang igus ang durug rabung yang daun na. Purisu ya ray inangay na ang basi pa ilem may mapakinaw̱angan na. Piru kaw̱utan na, andang pisan ay burak na, kung indi, pulus ilem mga daun. Yang ipinagpalenget na tung igus ang atia, maskin belag̱an pa yang uras ang igbururak yang kadaklan ang mga igus, kumus may mga daun na, kalaum nang burakan da. ");
INSERT INTO tbk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Numanyan dayun na rang itinuluy tung malain yang ayung atiang inaning, “Maayen pa rin ang india ra ilem mamurak ang uman,” mag̱aning. Yang ibinitala nang atia, nagngel ka yang mga taung atiang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Taa numanyan, pagkaw̱ut nira na Jesus duun tung Jerusalem, ti Jesus tanya dayun dang nagpakled tung palayas yang pagtuuan ang pinakalusu. Pagpakled na, dayun dang nagpalayas tung mga manigpaalang ta mga garamiten tung pagparadasag̱en, pati yang pamangalang tung nira nagkaraumid da ka ta palayas na. Asta yang mga lamisaan ang atiang pinampabtangan ta mga kuartang nag̱ipagpabailu tung mga tau, pinamaliskad na ra, asta yang mga kakarungan yang mga manigpaalang ta mga kalapati, ya ka. ");
INSERT INTO tbk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dispuis indi na ra ka tinugtan yang duma ang mamagsakan ta mga ekel-ekel nira ang ya ra ilem din agpamanggetes asan tung palayas ang mamansiulik. ");
INSERT INTO tbk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Numanyan dayun dang nagpasanag tung mga tau ang mag̱aning, “Belag ba ang may inaning yang Dios ang napabtang tung kasulatan ang yang balay unung naang pag̱atiniran na, dapat unu ang yay pag̱ampuan tung anya yang tanan ang mga nasyun? Piru ay pa w̱a? Ta numyu, binuat mi ra ilem ang kuinta leyang ang pantalukan ta mga tulisan ay natetenged taa ra mismu agpandayaay mi yang mga tau!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Numanyan may mga paring arabubwat ta katengdanan asan ang pamamati, kasiraan da ka tanira yang mga sag̱ad. Anday dumang nag̱atima nira, kung indi, ang ay pa ag̱aring mapaimatay nira ti Jesus. Ay pamangimun da ta mupia tung anya ay natetenged tung mga sakep nirang atiang buntun ang pamaninluan da ta mupia tung nag̱itulduk na tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Taa numanyan atiing law̱ii ra, ya ra kay paglua na Jesus tung siudad. ");
INSERT INTO tbk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Taa numanyan, atiing pangayag dang timpranu ang pamagtaklib da rin na Jesus duun tung ayung atiing itinuluy na tung malain, naita ra nira ang atia pala nanlumpayeng dang luw̱us asta duun tung mga lamut na. ");
INSERT INTO tbk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ya ra kay pagkademdem ni Pedro kung unu pay ipinag̱aning ni Jesus tung ayung atia. Purisu dayun dang nagpasapet tung anyang mag̱aning, “Rabbi, uay, atia ra yang igus ang itinuluy mu tung malain. Nanlumpayeng da!” ");
INSERT INTO tbk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mag̱aning ti Jesus ang nagtimales tung nira rang tanan, “Kaministiran ang magtalig̱amu ta ustu tung Dios. ");
INSERT INTO tbk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iugtulu tung nuyu yang kamatuuran, kung tinu pay mag̱ingaluk tung Dios ta sasang durug liwag tung pag̱intindi na ang anday dua-dua yang isip na, kung indi, may pagtalig na rang lag̱i ang talagang mainabu ra tiing nag̱aingaluk na, yang taung atia, yay pakdulan yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Purisu ya ra kay nag̱ipag̱aningu tung numyu ang kung unu pay ingalukun mi tung Dios, magtalig̱amu rang lag̱i ang naeklan mi ra atiang nag̱aingaluk mi ang pagkatapus magkamaningan da ka man tia. ");
INSERT INTO tbk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ig dispuis pa, kung kemdengamu ra nganing ang mag̱ampu, kung may nagbuat ta kasalanan tung numyung ya ray paglainan ta isip mi tung anya, patawaren mi rang lag̱i bakluamu ra magdayun ang mag̱ampu. Ay kung patawaren mi, patawarenamu ra ka yang Ama mi duun tung langit tung mga paglalampasen mi tung mga katuw̱ulan na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Taa numanyan, namansikaw̱ut si na Jesus duun tung Jerusalem. Numanyan atiing pagparanaw-panawen na duun tung palayas yang pagtuuan ang pinakalusu, may namagpalenget da tung anyang mga paring atiang arabubwat ta katengdanan may yang mga pamagpakigmaepet tung banwa. ");
INSERT INTO tbk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Dayun da nirang inusisang inaning, “Eey, ay pa ngaeklay mu yang katengdanan ang yawa magbuat yang mga maning tia taa tung pagtuuan tang naang pinakalusu? Tinu pay naglug̱ut tung nuyu?” ");
INSERT INTO tbk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mag̱aning ka ti Jesus ang nagtimales, “Elat kanay, kung mga sarang tung numyu, may sasa kang talimaanenu rin tung numyu. Kung matuw̱al mi, ay tuw̱alenamu ka yeen kung ay pa liit yang katengdananung pagbuat ta mga maning tia. ");
INSERT INTO tbk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Abir, ay pa w̱asu liit yang katengdanan ni Juan ang nagpamenyag tung mga tau? Tung Dios manliit u tung tau ka ilem? Ala, tumuw̱alamu ra.” ");
INSERT INTO tbk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pagkagngel nira tia, dayun dang nag̱aralas-alasan ang mag̱aning, “Unu pa w̱asu ay maayen ang ituw̱al ta? Kung aningen ta ang tung Dios manliit yang katengdanan ni Juan, muya sulilienita si anyang talimaanen ang ayw̱at indiita ra nananged tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piru kung aningen ta ang tung tau ka ilem manliit yang katengdanan na, atiay maliwag,” mag̱aning. (Yuung ti Marcos ang nagsulat, may yeen kang isaleet ang ipasanag. Yang pinangamanan nira ya ra yang mga taung atiang buntun ay yang pagterelengen nirang tanan tung ni dipuntu Juan tanya talagang sasang tinuw̱ul yang Dios ang magpadapat yang bitala na.) ");
INSERT INTO tbk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Purisu numanyan tinuw̱al da ilem nira ti Jesus ang, “Inay, indi ilem nag̱askean yamen.” Mag̱aning si ka ti Jesus ang nagtimales, “Tay kung maning tii, indiaw ra ka mag̱ugtul kung ay pa liit yang katengdananung pagbuat ta mga maning tia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pagkatapus numanyan, anday dumang naisipan ni Jesus, dayun dang nagpagngel ta mga pananglit tung mga pamagpakigmaepet ang atiang pamag̱usisa tung anya. Mag̱aning tung nira, “May sasang taung nagpanluak ta mga ubas. Pagkatapus pinaliw̱utan na yang kaubasan na ta mga batung tinarutug. May yuntu pang pinabangbangan nang pinabuatan na ta lilikdan yang mga burak na ang may saralug̱an ka yang wai na. Pagkatapus nagpakdeng pa ta barantayan. Atiing matapus na ra yang tanan ang atia, ipinaagsa na ra yang kaubasan na tung mga tau. Pagkapiar na tung nira, dayun dang nagliit ang minangay duun tung dumang banwa. ");
INSERT INTO tbk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Numanyan pagkaw̱ut da yang kutitsya na, pinaangayan na yang mga agsadur na tung sasang turuw̱ulun na ang para eklan na yang kaparti na tung patebas. ");
INSERT INTO tbk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Numanyan yang binuat yang mga agsadur na, pinagdeep da ilem nira yang turuw̱ulun nang atiang pinagpalu. Pagkatapus pinabalik da ilem nira ta paisanu. ");
INSERT INTO tbk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Utru si, pinaangayan si yang may kaubasan tung turuw̱ulun nang sam bilug. Pagkaw̱ut na, pinaglukaan da yang mga agsadur yang kulu nang ineyak. ");
INSERT INTO tbk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mag̱uman, may sam bilug sing turuw̱ulun na ang ipinaangay na duun ang pagkatapus ya ray inimatay nira. Dakele pang mga turuw̱ulun nang duma ang ipinampaangay na duun. Yang duma ya ray pinagtag̱aman nira ta palu, yang duma pinangimatay pa ka enged nira. ");
INSERT INTO tbk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Numanyan sam bilug da ilem ang naeped ang sarang matuw̱ul na. Ya ra yang ana nang lalii ang nag̱agegmaan na ta duru. Purisu tung kauri-urian da, ya si ay tinuw̱ul nang mangay duun tung mga agsadur na. Yang ipinagkesen-kesen na tung isip na, maning taa: ‘Simpri galangen ka enged nira yang anaw,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Numanyan pagkabandaw ra yang mga agsadur ang atia ang ya ra yang ana yang may kaubasan ang magkakaw̱ut da, dayun dang namagkeresen ang mag̱aning, ‘Naa pala, taa rag panganing yang manubli tung kaubasan ang naa. Maayen pa, imatayen ta ra ilem ug̱ud yaten da yang surublien na ra rin ang naa!’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Purisu tung pagkaw̱ut na, dayun da ka man nirang dineep ang inimatay. Pagkatapus, yang tinanguni na, ipinlek da ka ilem nira duun tung lua yang kaubasan. ");
INSERT INTO tbk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ta, unu pa w̱asu ay buaten yang may kaubasan? Anday dumang buaten na, angayen na ra ilem ang pangimatayen yang mga agsadur ang atia ig yang kaubasan na ipaagsa na si tung duma. ");
INSERT INTO tbk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Siguru nabasa mi ra ka yang sasang pananglit ang napabtang tung kasulatan ang may batu unung pinasag̱i ang ya ray pinangindian yang mga manigpakdeng yang balay ang anda unu ay kuinta na, ang pagkatapus ya pa ka enged unu ay nagluang pinakaimpurtanting batung panielan yang lebat yang intirung balay. ");
INSERT INTO tbk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anda unu ay dumang nagbawing nagpabalik tung batung atiing pinangindian da nira, kung indi, mismu unu ti Yawi ang duun da unu agpaninluay ta mupia yang mga taung pamagpaniid,” mag̱aning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Numanyan pagkasiman da yang mga pamagpakigmaepet ang taniray nag̱apatemengan tung mga ipinananglit ni Jesus ang atia, tinag̱aman da rin nirang ipadeep. Ingkasu ilem may pangamanan nira tung mga taung atiang buntun ang pamagpauyun tung anya. Purisu binutwanan da ilem nirang namagpanaw. ");
INSERT INTO tbk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Taa numanyan, yang mga Pariseong atiang pamagbalak, pinabalikan da nira ti Jesus tung mga kaarumanan nirang mga Pariseo may tung mga tauan ni Gubirnadur Herodes ang basi pa ilem mapamintira nira tung panuw̱al na tung talimaanen nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Numanyan pagpalenget nira tung anya, dayun da nirang pinagtag̱aman ta buladas ang inaning, “Ameey, nag̱akdekan da ka yamen ang yawa anday bukli. Tung pagparadapaten mu ta bitala tung mga tau, anday pinilikan, ay natetenged indi mu kag intindien yang pagkabetang nira, kung indi, yang nag̱ipagpadapat mu tung nira ya ilem yang kamatuuran natetenged tung kalelyag̱an yang Dios ang yay dapat ang tumanen nira. Purisu tung nuyung pag̱intindi, uyun basu tung katuw̱ulan yang Dios ang ta yaten ang mga Judio manggawarita pa yang nag̱ipagpagawad ni Adi Cesar tung yaten u kuntra? Ya gawaray ta u indi?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kumus nag̱adeep dang lag̱i ni Jesus ang pamagpakaayen-ayen ilem tanira, dayun na rang tinuw̱al ang inaning, “Yang gustu mi tag̱amanaw ra numyung tuungun. Ala, ieklayaw ra kanay numyu ta kuartang nigal ang para matelenganu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Purisu dayun da nirang ingkel ta kuartang nigal. Pagkatapus dayun dang nagtalimaan ti Jesus tung nira ang mag̱aning, “Ninu pang ityuraay ang nabtang tung nigal ang naa? Ninu pang aranay ang namarka taa?” Mag̱aning ka tanirang nansituw̱al, “Ni Adi Cesar.” ");
INSERT INTO tbk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mag̱aning ka ti Jesus ang nagtimales, “Yang kumpurming ipinasuad ni Adi Cesar tung pagkabetang na, ya iintrigaay ta tung anya, pati yang kumpurming ipinasuad yang Dios tung sadili na, ya ka iintrigaay ta tung anya,” mag̱aning. Atii, nanganganga ra ilem tanirang nangabereng ta mupia tung itinuw̱al nang atia. ");
INSERT INTO tbk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Taa numanyan, yang namagdasun ang namagpalenget tung ni Jesus, ya ra yang mga pamagmangulung mga kinasakpan yang sasang partidung nag̱aranan tung mga Saduseo. Yang nag̱apapaktelan nirang nag̱itulduk tung mga tau ay yang mga patay unu indi ra mabuing uman ang ya ra kay gustu nirang isug̱a tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Numanyan mag̱aning tanira tung anya, “Ameey, may sasang urdinansang isinulat ni Moises ang para ibutwan na tung nasyun ta ang maning taa. Kung mapatay unu yang putul yang sasang tau ang pagkatapus may kasawa na unung butwanan na piru anda pay ana nira, yang putul na unu yay dapat ang ipulin tung ni ipag nang nabalu ug̱ud kung maana tung anya, mapabtang dang ana yang putul nang napatay. ");
INSERT INTO tbk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ipabetang ta may pitu nga laliian ang magpurutul. Yang pangulu nangasawa tung sasang baw̱ay ang pagkatapus napatay ang indi naana tung kasawa na. ");
INSERT INTO tbk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pagkatapus yang putul nang duminasun tung anya ya ray ipinulin ang ipinakasawa tung ni ipag nang nabalu ang pagkatapus napatay ka ang indi ra ka naana. Pati yang pangyaklu nira, maning ka tia yang nainabu tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Numanyan pati yang mga ari nirang nagdarasun maning ka tia yang nagkarainabu tung nirang tanan. Nagkaraluw̱us da ilem ang nagkarapatay ang anday binutwanan nirang ana. Pagkatapus tung kauri-urian da, pati yang baw̱ay napatay ra ka. ");
INSERT INTO tbk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta, kung matuud yang numyung atia ang yang mga patay mangabui si kang uman, abir, kung kaw̱utun da nganing yang uras ang atia, tung nirang pitung magpurutul, tinu pa w̱asu ay magnatis ang may kasawa tung baw̱ay ang atia, sindu pinangasawa-kasawa ra nirang tanan? Abir kung unu pay matuw̱al mu?” ");
INSERT INTO tbk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mag̱aning ka ti Jesus ang nagtuw̱al, “Ta, indi, asanamu rag pagkamali? Indi mi pa pala nag̱amaresmesan yang napabtang tung kasulatan pati yang kagaeman yang Dios, indi mi ka ilem nag̱amaresmesan kung unu pay masarangan na. ");
INSERT INTO tbk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ayw̱a indiamu aningenu ay kipurki kung kaw̱utun da nganing yang uras ang yang mga patay pampabungkarasen da yang Dios, indi magkarasawaan ang uman, kung indi, mamanulad da tung mga angil duun tung langit ang indi kang lag̱i pagkarasawaan. ");
INSERT INTO tbk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Dispuis pa, kung natetenged tung pagpabungkaras yang Dios tung mga patay tung uri ta kaldaw ang yay midyu maliwag ang panangden mi, ayw̱a, indi mi pa nag̱abasa tung isinulat ni Moises natetenged tung naita nang palumpung ang nag̱apuy ang pagkatapus indi ra ka nasiruk? Ya ray uras ang ipinagpailala yang Dios tung anya ang tanya unu yang Dios ang may mga tauan tung mga kinaampu nang na Abraham ni Isaac may ni Jacob. ");
INSERT INTO tbk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yang Dios tanya anday mga tauan nang patay, kung indi, pulus bui. Pati nganing mga tinanguni nira, damayen na ra kang buien si kang uman tung uri. Talagang dakulung kamali yang pag̱irintindien mi tung mga bag̱ay ang naa,” ag̱aaning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Numanyan, may sasang sag̱ad tung mga urdinansa ang pamati tung pagsurug̱aan nira na Jesus. Kumus naskean na ang durug tinlu yang itinuw̱al ni Jesus tung mga Saduseo, dayun dang nagpalenget tung anyang nagtalimaan ang mag̱aning, “Tung tanan ang mga katuw̱ulan yang Dios unu pay pinakalandaw enged?” ");
INSERT INTO tbk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mag̱aning ka ti Jesus ang tuminuw̱al, “Yang pinakalandaw ya taang itinulduk ni Moises ang tukaw tung mga kinaampu ta ang mag̱aning, ‘Yamung mga masigkanasyunung mga Israel, mamatiamu. Ti Yawi yay Dios ang pag̱atuuan ta. Anday dumang Dios ang dapat intindien ta kung indi ultimu ilem tanya. ");
INSERT INTO tbk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Purisu magpabuyukamu yang gegma mi tung ni Yawi ang yay Dios mi. Yang paggeregmaen mi tung anya dapat ang tedek ang pisan tung mga kinaisipan mi ang indi ka magtenakan. Ya ra kay papruibaan mi tung tanan ang mga buat-buat mi,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","May sam bilug pang maning taa: ‘Gegmaan mi yang mga masigkatau mi ang katulad ka tung paggeregmaen mi tung sadili mi.’ Anday dumang katuw̱ulan ang lumandaw pa tung duruang atia.” ");
INSERT INTO tbk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mag̱aning ka yang sag̱ad ang minles, “Bali, Ameey! Matuud ka man yang inaning mung atia ang sam bilug ilem yang Dios ig anday dumang Dios kung belag̱an ultimu ilem tanya. ");
INSERT INTO tbk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Purisu ta yaten ang mga tau, dapatitang magpabuyuk yang gegma ta tung anyang ipalusu ig tedek kang pisan tung mga isip ta ig indi ka magtenakan ang ya ka man ay dapat ang papruibaan ta tung tanan ang mga buat-buat ta. Yadwa pa, dapatita kang maggegma tung mga masigkatau ta ang katulad ka tung paggeregmaen ta tung mga sadili ta. Mas matimbang ang ita magtuman yang duruang atia kay tung magpadasag̱ita ta mga ayep ang yag kuw̱ulay ta apuy pati yang indi magkuw̱ulan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Numanyan pagkagngel ni Jesus yang itinuw̱al nang atiang midyu tinimbang-timbang na ra ta mupia tung isip na, dayun dang nagpaktel tung isip nang mag̱aning, “Tama yang palaksu yang pag̱irisipen mu. Kung padayunan mu tia, yang tegkaan na, magpagaema ra ka enged ang bug̱us tung Dios,” mag̱aning. Pagkatapus tia, anda ray napagpalangaas pa ang nagtalimaan pang uman tung ni Jesus. Nangaregda ra. ");
INSERT INTO tbk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Taa numanyan, atiing duun pa ti Jesus tung palayas yang pagtuuan ang atiang pinakalusu ang pagturuldukun tung mga tau, tanya si ay nagtalimaan tung nirang nagpaisip ang mag̱aning, “Kung magturuldukanen da nganing yang mga sag̱ad, ya pa ag̱aring ag̱aningen nira ang yang pag̱aningen ang Cristo kanubli ka ilem ni David? ");
INSERT INTO tbk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ti Adi David nganing mismu aparti yang anyang pagpabetang tung anya. Kipurki may sasang ipinaula tung anya yang Espiritu Santo natetenged tung pag̱aningen ang Cristo ang maning taa yang napabtang tung kasulatan: ‘Yang Ginuuu pinag̱aning da ni Yawi ang kumarung da kanay unu tung tepad na tung tuu ang asta pamirdien na unu yang pamagkuntra tung anya ang asan da unu ipampabtangay na tung tarampakan yang kakay na.’ ");
INSERT INTO tbk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ta, telengan mi. Mismu ti Adi David sinambit na nganing yang pag̱aningen ang Cristo ang Ginuu na. Ya pa ag̱aring magyaring kanubli na ka ilem?” mag̱aning. Numanyan yang mga taung atiang buntun agpamaninluan da ta maayen ang pamagpamati tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Numanyan tung pagpadayun na tung pagparasanag̱en na tung nira, mag̱aning tung nira, “Mangamanamu ang indiamu enged mag̱usuy tung ug̱ali yang mga sag̱ad tung mga urdinansa. Ay maskin unu pay nag̱abuat nira, yang pag̱asikad enged nira ang tanira dayawen ta mga tau. Katulad da asan tung panggawi-gawi nira ang yang aw̱el nirang atiang langkuy, pirmi ra ilem ang nag̱ipabeka nirang nag̱ipasapet tung mga tau. Kung mamasyar da nganing tung mga plasa, duru kang kalelyag nirang kumustaen ta mga taung galangen ta maayen ang tanira darakulu ka man ang mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pariu ka ta laksu kung mamagsimba ra nganing tung mga pagsaragpunan nira. Yang piliken nirang karungan, ya ra yang mga kakarungan ang nag̱itig̱ana tung darakulung mga tau ang mas abwat ta pagkabetang tung nira. Ubin tung mga punsiun man, ya ka. Piliken nira yang pinakamatinlung karungan. ");
INSERT INTO tbk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dispuis masyadung magpanlepes tung mga baw̱ay ang mga balu ang para yang ganadus nira mapiar da tung nira. Pagkatapus ang para manalig da yang isip yang balu, papagmuug̱un da ilem nira yang pag̱arampuen nira. Purisu yang mga taung mga maning tia, asan da nga dulangay nirang nga dulangay yang kalelebaten yang sintinsiang ipakdul yang Dios tung nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Taa numanyan, atiing pagkarung ni Jesus tung talungaan yang mga alkansia, nagpaniid da tung mga taung atiang buntun ang pamagburugsuan ta kuarta ang ya ray nag̱ibuluntad nira tung Dios. Durung mga manggaranen ang pamagburugsuan ang may mga kantidad nang dakulu. ");
INSERT INTO tbk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pagkatapus may sasang baw̱ay ang balu ang maliliwag̱en ang ya ray nagpalenget tung alkansiang namugsu ta nigal ang duruang bilug ang pagbaluran ta pinakabaratu. ");
INSERT INTO tbk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pagkaita ni Jesus, dayun dang naglambay tung mga taung atiang nag̱apangugyatan nang mamagpalenget tung anya ang pagkatapus dayun na rang inaning, “Teed mi tiang balung maliliwag̱en! Iugtulu tung numyu yang kamatuuran, kung timbangen yang Dios, mas dakulu ta kantidad nakaang ibinugsu na tung alkansia kay tung tanan ang ipinamugsu nirang kadaklan. ");
INSERT INTO tbk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ay ya pa ag̱ari, yang kaalimbawaan yang ipinamugsu yang kadaklan, maning pa tung ya ra ilem yang kinalis nira tung gantangan ang nagsubra. Piru tiang balu, maskin anggan da ilem yang kuarta nang nag̱itig̱ana na rin tung pagpangabui na, luw̱us na rang ibinugsu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Taa numanyan atiing pagliit na Jesus duun tung palayas yang pagtuuan ang atiang pinakalusu, binugnu ra yang sasang taung nag̱apangugyatan na ang inaning, “Ameey, uay, telengan mu w̱a yang mga batung atiang tinambi-tambi tung mga padir yang balay ang naa. Kadarakul! Pati yang dumang ipinakdeng asan durug katitinlu!” ");
INSERT INTO tbk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mag̱aning ka ti Jesus ang nagtimales, “Midyu agtinluana rang pagteleng tung mga batung atiang darakulu ka man. Piru iugtulu tung nuyu, may uras ang kaw̱utun ang yang mga batung atiang darakulung pinasag̱i ang tinambi-tambi asan, anda rang pisan ay mabutwan pang magsarampaw-sampawan, kung indi, luw̱us dang magkarapanpan tung tanek,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Numanyan atiing duun da tanira na Jesus tung tag̱aytay yang bukid ang atiang durung ayung pag̱aningen ang olibo, ya rag kakarung ti Jesus. Ya rag bandaway nira yang pagtuuan ang atiang pinakalusu ang yag tatalunga duun tung duw̱aling bukid. Numanyan namagpalenget da tung anya na Pedro, na Santiago, na Juan, may ti Andres. Atiing tanira ra ilem ang lima, namagtalimaan da tung anyang mag̱aning, “Ameey, pakdekayami ka kung sanu pa magkamaning da ta maning tiang nainambit mu nungayna? Unu pang pruibaay ang sarang tandaan yamen ang makali rang magkarainabu yang tanan ang atia?” ");
INSERT INTO tbk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Atii, dayun dang nag̱impisa ti Jesus ang nagpamadbad tung mga isip nirang mag̱aning, “Mangamanamu ta mupia ang para indiamu madayaan ta dumang mapatalang. ");
INSERT INTO tbk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ay kipurki durung magluang mag̱ambu ang tanya unu ya ra yuung pag̱aningen ang Cristo ang pagkatapus durung taung magkaradayaan nira. ");
INSERT INTO tbk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dispuis pa kung magngel mi ra nganing yang gulu yang paggiriraan ubin mabalitaan mi ra ka nganing yang mga gira duun tung duma-rumang rugal, indiamu ilem magpakataranta. Ay kipurki dapat ang magkarainabu yang mga maning tia, piru indiamu ilem maglaum ang yang magdasun ya ra yang uras ang ipagtapus yang Dios tung panimpung naa. ");
INSERT INTO tbk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ag̱aningenamu yeen ta maning tia ay yang magkarainabu, nasyun may nasyun magsuruayan ang maggiriraan. Dispuis may magpanaw ang mga yegyeg tung duma-rumang banwa pati mga panuw̱uk ya ka. Yang kaalimbawaan yang mga bag̱ay ang atia kung magkarainabu ra nganing, maning pa tung primirung pagpasiit-siit yang baw̱ay ang paranganaen da. Yay dapat ang mamagtukaw baklu pa kaw̱utay yang baklung panimpu. ");
INSERT INTO tbk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ta yamu, mangamanamu ay deepenamung idimanda tung mga usgadu. Duunamu ka paburdunay yang pamagmaepet-epet tung mga pagsaragpunan nira mismu. Kung kaisan guyuranamung patalungaen tung mga gubirnadur may tung mga adi pa natetenged tung pagkererengen mi tung yeen. Asanamu ra nga pakdulay ta lugar ming magpaingmatuud tung nira natetenged tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Asta yang tanan ang mga nasyun tung bilug ang kaliw̱utan, dapat kang pampakaw̱utan yang Matinlung Balita natetenged tung yeen baklu kaw̱utay yang uras ang ipagtapus yang Dios tung panimpung naa. ");
INSERT INTO tbk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kung deepenamu ra nganing ang idimanda tung mga usgadu, indiamu ra ilem magpakabegbeg ta mga kulu mi kung unu pay ituw̱al mi, kung indi, kumpurming unu pay ipaisip tung numyu tung mga uras ang atia, ya ray ibitala mi. Ay kung unu pay ibitala mi, belag̱an numyung sadiling pasamintu, kung indi, ya ra ipaisipay tung numyung ipabitala yang Espiritu Santo. ");
INSERT INTO tbk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Maning taa yang mainabu tung sam pamilya. Kung tinu pay mananged tung Matinlung Balita natetenged tung yeen, ya ray demtan yang mga putul nang idangep tung usgadung ipaimatay. Ang kaisan ya ra kay buaten yang sasang amaen tung mga ana nang namagpasirung da tung yeen. Ang kaisan, kung yang mga ginikanan ya ray namagpagaem da tung yeen, ya ra kay batukan yang mga ana nirang ipaimatay. ");
INSERT INTO tbk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dispuis pa, demtanamu ka ta maskin tinu pang tauay arangan da ilem tung yeen ang nag̱akegngan mi. Piru kung tinu pay magpatenten yang isip nang magpadayun ka enged tung pagtaralig̱en na tung yeen, maskin imatayen pa, indi ra maunu pa yang kalibrian nang ipinakdul da yang Dios tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Tung mga uras ang atiang nag̱ianingu, maita mi ra yang sasang pagpadamang ang makalalaway ang pisan ta isip ang ya rag bebtang tung puistung sagradu ang dapat da rin ang indi pabtangan. (Yuung ti Marcos ang nagsulat, may yeen kang gesyeng isaleet ang para ipaetaru tung numyung mga manigbasa. Ipasanag mi tung mga taung pamamati kung unu pay linegdangan yang mga bitalang atia.) Purisu kung maita mi ra nganing tia, kumpurming tinu pay pagtinir tung sinakepan yang Judea, kaministiran magpalaksu rang lag̱i duun tung kabukiran. ");
INSERT INTO tbk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kung tinu pay kaw̱utan yang uras ang atia ang asan dag kakarung tung sagpaw yang balay nang pagpalimasmas, kaministiran ang indi na ra kanugunun yang mga ekel-ekel na duun tung kakleran ang maning eklan na pa, kung indi, diritsyu ra ilem ang magpalaksu. ");
INSERT INTO tbk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya ka yang taung duun da kaw̱utay tung kaluakan na, indi na ra ka balikan yang panlamig na duun tung balay na. ");
INSERT INTO tbk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kanugun yang pagkabetang yang mga matung may yang mga talaana tung uras ang atia. ");
INSERT INTO tbk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mag̱ampuamu tung Dios ang indi matuun tung abag̱at yang ipagpalaksu mi. ");
INSERT INTO tbk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ag̱aningenamu ra yeen ta maning tia ay natetenged tung uras ang atia kumaw̱ut da yang sasang kaliwag̱an ang durung pisan aglebat. Disti pa tung katebtew̱an ang atiing pag̱imu yang Dios yang kaliw̱utan ang asta ra ilem simanyan, indi pa nag̱apasaran yang kaliw̱utan ta maning tiag lebat. Maskin pa tung uras ang panalungaan, anda ray magdeeg tii. ");
INSERT INTO tbk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kung indi nganing padiputun yang Dios yang timpung atia, ya rang ya rang maspuk da rin yang mga tau. Piru alang-alang da ilem tung mga taung pinagpilik na kang lag̱ing mag̱ing mga tauan na, ya ra kay ipagpadiput na. ");
INSERT INTO tbk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tung mga uras ang atia, kung aningenamu ra ta mga tau ang ‘Uay, nani ra yang pag̱aningen ang Cristo’ ubin kung aningenamu ka nirang, ‘Uay, takaa ra’, indiamu enged mananged. ");
INSERT INTO tbk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nag̱apaamanamu yeen ta maning tia ay tung mga uras ang atia may mamaglua rang mga tau ang ya ray mamag̱ambu ang tanira unu ya ra yuung pag̱aningen ang Cristo. May dumang mamaglua kang mga manig̱imu-imu ta bitala ang ya unu ay bitalang itinuw̱ul yang Dios tung nirang ipalatay buat. May mga pruiba nganing ang maktel ang durug kabew̱ereng ang ipalapus nira ug̱ud pati mga taung pinagpilik yang Dios ang mag̱ing mga tauan na, tag̱aman da ka nirang dayaan kanung kayanan pa ka nira. ");
INSERT INTO tbk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Purisu ta yamu, mangamanamu ra ta mupia. Tutal pinakdekamu rang lag̱i yeen natetenged tung tanan ang atia baklu magkarainabu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Tung uras ang atiang panalungaan, kung mataklib da nganing yang kaliwag̱an ang atiang durug lebat, maning taa yang magkarainabu ang katulad ka tung napabtang tung kasulatan: ‘Yang kaldaw mangiklep da, pati yang bulan indi ra ka manadlaw. ");
INSERT INTO tbk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Asta yang mga dumakel magkarataktak da. Bilang yang tanan ang bag̱ay tung kalangitan papagwaldangen da yang Dios tung dating pagkarabetangen nira,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tung uras ang atia, yuung pag̱aningen ang ‘Maninga Tau’, maitaw ra yang mga tau ang yuug sasaay tung panganud ang yuu kag dawalay nirang duru rag kasusulaw yang pagkabetangung paggaraemen. ");
INSERT INTO tbk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dayunaw ra kang manuw̱ul tung mga angil ang mamagliliw̱utun da tung bilug ang kaliw̱utan ug̱ud panagpunun da nira yang tanan ang mga tauanung kumpurming pinagpiliku kang lag̱i ang duun mamanliit tung maskin ay pang kabiw̱init-binitanay yang kaliw̱utan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Numanyan, mag̱aning ti Jesus ang nagpadayun yang bitala na, “Pamaresmesan mi ra kanay ta mupia yang pananglitung naa natetenged tung ayung igus. Kung manguruk da nganing, nag̱aintindian ta rang makali rang kumaw̱ut yang tagkinit. ");
INSERT INTO tbk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Maning ka tia yang kaalimbawaan yang mga bag̱ay ang atiang nagkarasambitu ta nungayna. Ta yamu, kung maita mi ra nganing ang pagkarainabu ra, asan da ngaintindiay mi ang alenget da yang uras ang makaliaw rang maglekat. ");
INSERT INTO tbk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iugtulu tung numyu yang kamatuuran, baklu magkarapatay yang kadaklan ang mga masigkanasyun ta simanyan, kung nagkarainabu ra yang tanan ang atiang inulaw ta nungayna. ");
INSERT INTO tbk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Matunaw yang kalangitan may yang katanekan, piru yang kumpurming nag̱ibitalaw indi ra ka enged ang pisan matunaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Numanyan mag̱aning ti Jesus ang nagsugpat yang bitala na, “Ug̱aring ilem, kung unu pang kaldaway ubin kung unu pang urasay yang ipaglekatu, anday nag̱akdek, maski yang mga angil duun tung langit, maskin yuu pang pag̱aningen ang Ana Yang Dios, kung indi, ultimung nag̱akdek ti Ama ilem. ");
INSERT INTO tbk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Purisu mangamanamu ig papabtikamung pirmi ay indi mi nag̱akdekan kung sanu pa kumaw̱ut yang uras ang atia. ");
INSERT INTO tbk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yang kaalimbawaan na tia maning pa tung sasang taung magdistinu duun tung dumang lugar. Baklu magliit tung balay na, pamiaran na yang mga turuw̱ulun nang mamag̱erekelen tung tanan ang prupidad na. Sasa may sasa tung nira sinagpiaray na ta anya-anyang ubraen. Pati yang purtiru, linalangan na kang pirming magpaabtik tung ipaglekat na. ");
INSERT INTO tbk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Purisu papabtikamung pirmi, ay indi mi nag̱akdekan yang uras ang ipaglekatu ang yuu manulad da tung may balay ang atia. Ay indi mi makdekan kung tung apun-apun, u kung tung tenganan ta law̱ii, u kung tung panuluk yang manu, u kung tung pandiklat da yang sag̱iid. ");
INSERT INTO tbk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nusias kaw̱utanamu yeen ta inali ang yamu pagpaw̱aya-w̱aya tung ipiniaru tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yang nag̱ianingung naa tung numyung epat simanyan, nag̱ianingu ka tung tanan ang mga tauanu ang yamung tanan pirmiamung papabtik tung ipaglekatu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Taa numanyan, magpanaw pa ta duruang kaldaw baklu kaw̱utay yang uras ang ipag̱iapun nira yang pag̱aningen ang Taklib ang yay pag̱impisada yang pistang pag̱aningen ang Nag̱ipamangan Ta Tinapay Ang Indi Pinaliskag. Yang mga paring atiang arabubwat ta katengdanan may yang mga sag̱ad tung mga katuw̱ulan pamagdilem da ta matinlung idya ang para mapadeep nira ti Jesus ang anday durung taung makdek ang pagkatapus ipaimatay ra nira dayun. ");
INSERT INTO tbk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mag̱aning tanirang pamagkeresen, “Indi ta ilem ituun tung pista. Muya magkagulu yang mga tau,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Taa numanyan, ti Jesus tanya duun tung Betania tung balay ni Simon ang yang tukaw may dispirinsia na pa rin tung ulit nang makamamansa. Atiing pagpakigsaru ra ti Jesus, may sasang baw̱ay ang nagpakled ang may ekel nang midyu tung prasku ang yay punuk ta paamut ang pag̱aningen ang nardus ang durug kamaal ig pag̱as. Numanyan pagpungak na yang parabtangan ang atia, dayun na rang ibinukbuk yang paamut tung kulu ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Numanyan yang mga kasadu ni Jesus ang duma namagpakulain da ang namag̱araning-aningan dang mag̱aning, “Ayw̱at ginasta na ra ilem yang paamut ta maning tia? ");
INSERT INTO tbk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Abaa, kung ya pa rin ipaalangay na tia, naita pa rin ta mga tulung gatus ang nigal ang salapi. Napamakdul-pakdul pa rin tung mga maliliwag̱en.” ");
INSERT INTO tbk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Numanyan ti Jesus ya ray nagbitala ang mag̱aning, “Paw̱ayaan mi ra ilem asan. Ayw̱at nag̱apaliwag̱an mi? Durug tinlu yang binuat nang naa tung yeen. ");
INSERT INTO tbk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ay kung natetenged tung mga maliliwag̱en ang atiang nag̱aisip mi, maskin unu pang urasay, mataw̱angan mi, ay taang pirmi. Piru ta yeen, belag̱an ang mag̱aning ang maskin sanu pang urasay ang taanaw ang pirmi tung numyu. ");
INSERT INTO tbk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Binuatanaw rang lag̱i anya ta nasarangan na. Ay tung pagbukbuk na yang paamut ang naa tung yeen, yang kaalimbawaanu maning pa tung patayaw rang lag̱i ang pagkatapus sinimpananaw rang lag̱i anyang pinaamutan ang para ilg̱uraw ra tung leyang. ");
INSERT INTO tbk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iugtulu tung numyu yang kamatuuran, tung maskin ay pang banwaay tung bilug ang kaliw̱utan ipagpakaw̱ut yang Matinlung Balita natetenged tung yeen, yang binuatan yang baw̱ay ang naa tung yeen mabalita ka tung mga tau ug̱ud ya ray mademdeman nira tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taa numanyan, ti Judas ang Iscariote ang yay sam bilug tung sam puluk may durua nga tauan ni Jesus, anday dumang binuat na, nag̱angay ra duun tung mga paring atiang arabubwat ta katengdanan ay gustu na ang ti Jesus iintriga na tung pudir nira. ");
INSERT INTO tbk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagkagngel nira yang gustu na, namagkalipay ra ta duru. Dayun dang namagpangaku tung anya ang pakdulan nira ta kuarta. Purisu numanyan ti Judas ang naa, dayun dang nag̱impisang nagbantay ta ketat ang para may lugar nang magpadeep tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Taa numanyan, kuminaw̱ut da yang primirung sug̱ud yang Pistang Nag̱ipagpangan Ta Tinapay Ang Indi Pinaliskag. Ya ra kay kaldaw ang nag̱ipagdasag nira tung mga karnirung ipagsera nirang mamagsilibra tung Pistang Taklib. Tung kaldaw ang atii, namagpalenget da tung ni Jesus yang mga taung atiang nag̱apangugyatan nang namagtalimaan tung anyang mag̱aning, “Ariami pa w̱asung balayay magsimpan yang iapun tang para silibraen ta yang pistang naang Taklib?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Numanyan dayun dang nanuw̱ul ti Jesus tung mga aruman nirang durua nga tauan ang mag̱aning, “Mag̱angayamu ra kanay duun tung siudad. May sasang laliing mabag̱as ming pagsakan ta tiw̱ud ang punuk ta wai. ");
INSERT INTO tbk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ya ray nuntun mi. Kung ay pang balayay nga pakled, yamu ra ag̱aaning tung taung may balay, ‘Yami, minangayami ra ilem taa, ay yang tuyun ni Ginuu tang pagturuldukanen tung yaten, itulduk mu unu tung yamen yang kuartung pagyapunan nang magsilibra tung pistang naang Taklib, kasiraanami ra ka unung nag̱apangugyatan na.’ ");
INSERT INTO tbk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Atia, itulduk na tung numyu yang kuartung dakulu duun tung yadwang gradu yang balay na ang simpan da ka yang tanan ang garamiten ang tutal kaministiran ta. Duunamu ra magsimpan yang iapun ta,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Numanyan dayun da ka man ang nagliit yang duruang atiang nansiangay duun tung siudad. Pagkaw̱ut nira duun, yang tanan ang atiang sinambit ni Jesus tung nira, ya ra kang pisan ay kinaw̱utan nira. Purisu dayun da ka man ang namagsimpan tanira yang iapun nirang mamagsilibra tung Pistang Taklib. ");
INSERT INTO tbk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkatapus ta pagsimpan nira, dayun dang namagbalik tung ni Jesus. Numanyan atiing panlikarem da yang kaliw̱utan, minangay ra ti Jesus duun tung balay ang atii, kasiraan da ka tanira yang mga taung nag̱apangugyatan nang sam puluk may durua. ");
INSERT INTO tbk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Atiing pagsararuan da tanira, nagbitala ra ti Jesus tung nirang mag̱aning, “Iugtulu tung numyu, may sam bilug tung numyung pagpakigsadu tung yeen ang maning pa tung sasang matinlung ungkuyu ang ya pay magtraidur tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Numanyan yang mga aruman na, pinamungaw ang nangagngel. Purisu masigtalimaan tanira tung anyang mag̱aning, “Belag̱an ka siguru yuu, anu?” ");
INSERT INTO tbk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mag̱aning ka ti Jesus ang minles, “Anday dumang magtraidur tung yeen, kung indi, ya ra yang sam bilug tung numyung sam puluk may durua ang pagpakidengan ka pa man tung yeen ang pagtekme tung sera. ");
INSERT INTO tbk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kung tung bag̱ay, yuung pag̱aningen ang Maninga Tau, imatayenaw ka man ang katulad ka tung naula natetenged tung yeen ang napabtang ka tung kasulatan. Piru yang taung magtraidur tung yeen, ya ray nag̱apanganugunanu ta mupia. Ay kipurki durug lebat yang talungaen na tung uri. Mas maayen pa rin ang indi ra ilem ipinangana,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Taa numanyan, atiing sigi-sigi ra yang pagsararuan nira, ti Jesus namisik da ta tinapay ang ya ray pinasalamatan na tung Dios. Pagkatapus, dayun na rang pinagpingas-pingas ang ipinarawat tung mga tauan nang mag̱aning, “Ia, ya ra taang tinanguniu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pagkatapus dayun dang namisik ta sam basung binu ang ya si kay pinasalamatan na tung Dios ang pagkatapus dayun na rang ipinarawat tung nira. Numanyan ya ray pinagbereles-belesan nirang tanan ang ininem. ");
INSERT INTO tbk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ag̱aaning ti Jesus ang nagpasanag, “Atia ya ra ka taang dug̱uung ipaturuku ang para ya ray magpabaked tung sasang pagpakigpaig̱u nang pinangakuan na ug̱ud asan da nga tapnayay na yang dakeleng mga tau. ");
INSERT INTO tbk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iugtulu tung numyu, ultimu ra ilem taa yang panginemu ta binung maning taang nag̱ipagsilibra ta tung pistang naa. Piru kung kaw̱utun da nganing yang uras ang ipagpabistu ra enged ang pisan yang Dios yang paggaraemen na, magpakasadyaw ra tung tanan ang kaayenan na ang yay maning pa tung sasang igmenu sing baklu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pagkatapus ta pag̱iriapunan nirang atia, dayun dang namagkantang namagdayaw tung Dios. Pagkatapus nira ta pagkanta, dayun dang namaglampud ang namagpanaw ampir duun tung bukid ang atiang durung mga ayung pag̱aningen ang olibo. ");
INSERT INTO tbk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Numanyan atiing pamagpanaw ra tanira, napagbitala ra ti Jesus tung nirang mag̱aning, “Yamung tanan, maplekanamu ra ta ipagtalig mi tung yeen, ay mamatuuranita ra yang sasang ipinananglit yang Dios ang tukaw ang napabtang tung kasulatan ang mag̱aning, ‘Ilug̱utu ra yang manigpastur ang imatayen da ang pagkatapus magkarawasak da ka ilem yang mga karniru na,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piru maskin pang maning tii ay mainabu, kung pabungkarasenaw ra nganing yang Dios, magtukawaw ra tung numyu duun tung Galilea.” ");
INSERT INTO tbk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mag̱aning ti Pedrong nabnga, “Maskin yang kadaklan maplekan da ta ipagtalig nira tung nuyu, piru ta yeen, indiaw ka enged maplekan!” ");
INSERT INTO tbk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mag̱aning ka ti Jesus ang minles, “Aa Pedro, iugtulu tung nuyu, numaan ang law̱iing naa, baklu ra manuluk yang manu ta madua, maklua rang mag̱ingwara tung yeen.” ");
INSERT INTO tbk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Atii, nagpatireg̱es ti Pedrong nagtuw̱al, “Maskin ipaunungaw pa tung nuyung imatayen, talagang indiaw ra ka enged mag̱ingwara tung nuyu,” mag̱aning. Asta yang kadaklan ang mga tauan ni Jesus, maning ka tia yang nagkaraaning nira. ");
INSERT INTO tbk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Taa numanyan, atiing pagkaw̱ut nira yang mga taung nag̱apangugyatan na duun tung lugar ang paggug̱uuyan tung Getsemane, napagbitala ra ti Jesus tung nirang mag̱aning, “Taanamu ra ilem kanay ngarung. Ay mag̱ampuaw pa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Numanyan yang ingkelan nang pinanunut, ya ra na Pedro na Santiago may ti Juan. Numanyan ti Jesus pagkelbaan da ta duru ig nag̱aliwag̱an da ta mupia ta pag̱isip. ");
INSERT INTO tbk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mag̱aning tung mga aruman na, “Ag̱ampayanaw ra ta kapungawung duru. Arus pa ilem muntuk yang linawaw. Taanamu ra ilem kanay mag̱elat ang magpakipulaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Numanyan nagpatukaw-tukaw ra ti Jesus ta gesye, ya rag papadagpa agpapadagpa tung tanek ang nag̱arampuen ang kung maimu ilem, ipaluas da tanya yang Dios tung uras ang atiang lain ang nag̱atalungaan na. ");
INSERT INTO tbk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mag̱aning yang pag̱arampuen na, “Aay Amaw, sarangan mu yang tanan. Ipataklib mu ra ilem tung yeen yang lain ang naang nag̱atalungaw. Piru maskin pang nag̱apagbitalaw ta maning tii, belag̱an yang yeen ang kalelyag̱an ay matuman, kung indi, yang nuyu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Numanyan pagbalik na tung mga aruman nang tulu, kaw̱utan na, naa pala mga elek da. Purisu dayun na rang inaning ti Simon Pedro ang, “Abaa, ba tia, Simon, elek mu rang elek! Maskin sang uras da ilem, india ka enged nasarang ang nagpakipulaw? ");
INSERT INTO tbk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magpulawamu ra ta ustung mag̱ampu ug̱ud indiamu madeeg̱an ta tuksu. Tung bag̱ay, nag̱askeanu ka ang durung kalelyag ming mag̱usuy tung kalelyag̱an yang Dios. Piru nusias ilem dereeg̱enamu pa yang kaluluw̱ayen mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Utru si, nagpaalawid-lawid si ti Jesus ang nag̱arampuen sing uman ang pariu ka tung ipinag̱ampu na ta nungayna. ");
INSERT INTO tbk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagkatapus pagbalik na si tung mga aruman nang atia, kaw̱utan na, mga elek si ka enged, ay dereeg̱en da yang puyat nirang duru. Pagkapuaw na tung nira, nanganganga ra ilem ang nangateleng tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Numanyan tung yaklung balik na tung nira, dayun na rang inaning, “Ba tia, elek mi rang elek! Ustu ra tiang pamaenay mi! Kinaw̱ut da yang uras ang yuung pag̱aningen ang Maninga Tau, iintrigaw ra tung pudir yang mga taung malalain. ");
INSERT INTO tbk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ala, magbungkarasamu ra ay magpanawita ra. Uay, naa ra yang pagtraidur tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Numanyan, atiing indi pa nganing nag̱atapus ta pagbitala ti Jesus, asan da ka man nakaw̱ut ti Judas ang sasa ka pa man tung nirang sam puluk may durua ang nag̱apangugyatan na. Sam paluyug̱an da tanira yang mga taung buntun ang pamag̱ekel-ekel ta mga geed may mga palu. Ay pinanuw̱ul da yang mga paring arabubwat ta katengdanan, kasiraan da ka tanira yang mga sag̱ad may yang mga pamagpakigmaepet tung banwa. ");
INSERT INTO tbk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Atii pala, yang pagtraidur ang naa, may sinyas ang ipinaske na rang lag̱i tung mga kaarumanan na ang mag̱aning, “Kung kumaw̱utita ra nganing duun, yang taung ara-araanu, mag̱aningamu ya ra tia. Deepen mi rang lag̱ing eklan duun tung namanuw̱ul tung numyu. Bantayan mi ta mupia!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Purisu tung pagkaw̱ut ni Judas duun, diritsyu rang nagpalenget tung ni Jesus ang nagbugnu tung anyang mag̱aning, “Mupiang law̱ii asan, Rabbi!” ag̱aaning. Pagkatapus dayun na ra ka man ang inara-araan. ");
INSERT INTO tbk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pagkaara-ara na, diritsyung lag̱ing pinggesan yang mga kaarumanan ni Judas ang dineep. ");
INSERT INTO tbk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atii may sam bilug ang yag kekdeng asan ang ya ray napanlaw̱ut yang geed nang napanibat tung turuw̱ulun yang paring pinakalandaw ang pagkatapus yang talinga na ya ray nalampung. ");
INSERT INTO tbk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Numanyan ti Jesus dayun dang nagbugnu tung mga taung atia ang mag̱aning, “Ayw̱a, yuu sasang ribildi ang yuu rag sulungay mi ta mga geed may mga palu ang para madeepaw numyu? ");
INSERT INTO tbk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaldaw-kaldaw pagturuldukanenaw duun tung palayas yang pagtuuan ang pinakalusu ang pagkasira-siraanita ra ka. Ang pagkatapus indiaw pa ka enged dineep mi. Piru nag̱askeanu ang nagkamaninganaw ra ta maning taa ug̱ud magkamatuud da yang napabtang tung kasulatan natetenged tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Numanyan tanirang tanan ang mga taung atiang nag̱apangugyatan ni Jesus, ya ra ka ilem mamamutwan tung anyang namaglalaksuan da. ");
INSERT INTO tbk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Duun may sasang kaw̱ataan ang pagpakignunut ka tung ni Jesus. Yang sulaminting pag̱asuut na ya ra ilem yang kuklun ang inamben na. Yang taung atia ya ra ka rin ay tinag̱aman nirang dineep. ");
INSERT INTO tbk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Piru ya ra nga puklut ang napalaksu ta luas ang yang aw̱el ang inamben na ra rin, ya ra butwanay na tung kalima nira. ");
INSERT INTO tbk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Taa numanyan dayun dang ginuyuran nira ti Jesus duun tung balay yang paring pinakalandaw. Ay duun kang lag̱i pamagsaragpun yang tanan ang mga paring arabubwat ta katengdanan kasiraan da ka yang mga pamagpakigmaepet may yang mga sag̱ad. ");
INSERT INTO tbk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Numanyan ti Pedro tanya, ya ra ilem manikad tung ni Jesus, piru atii ra tung kauri-urian da ilem ang pisan. Numanyan pagkaw̱ut na duun tung balay ang atia, dayun dang nagpakled tung plasa-plasa na ang nagpakigkarung da tung mga guardiang pamamarang tung apuy. ");
INSERT INTO tbk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Numanyan duun tung kakleran, yang mga paring arabubwat ta katengdanan may yang kadaklan ang mga kaarumanan nirang pamagpakigmaepet ka, ya ray pamagdilem ta mga taung magpetel ta malain tung ni Jesus ang para ya ray padatelan nirang mamagsintinsia tung anya ang dapat ang ipaimatay. Piru anday pruibang bastanting naita nira. ");
INSERT INTO tbk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tung bag̱ay, dakeleng sistigus ang namagpetel ta kasalanan tung ni Jesus. Dipirinsia ilem, indi magturunu yang bitala nira. ");
INSERT INTO tbk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Numanyan may duma asan ang nansikdeng dang namagsistigus ta kabuklian ang kuntra tung ni Jesus ang mag̱aning, “Yang taung atia nagngel da yamen ang pag̱aning ang tanya unu ay manggew̱a tung pagtuuan tang pinakalusung binuat ka ilem unu ta mga tau ang pagkatapus tung seled ilem tulung kaldaw, pakdengan na si unu ta baklu ang belag̱an unu pastikular ang ubra ta tau,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piru maskin pang maning tii yang nag̱ibangdan nira tung anya, indi ka enged nagturunu yang bitala nira. ");
INSERT INTO tbk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Numanyan dayun dang kumindeng yang paring pinakalandaw tung katalungaan nirang tanan ang nagtalimaan tung ni Jesus ang mag̱aning, “Ta, anday matuw̱al mu tung nag̱ibangdan nirang atia tung nuyu?” ");
INSERT INTO tbk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Piru ti Jesus indi nagliing-liing. Purisu dayun sing tinalimaan yang pari, “Unu pa? Matuud ang yawa yang pag̱aningen ang Cristo, bilang yang Ana yang Dios ang pag̱aningen?” ");
INSERT INTO tbk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mag̱aning ka Jesus ang minles, “Ee, yuu ka man tia. Ig tung dumang uras, yuung pag̱aningen ang Maninga Tau, maitaaw ra numyung tanan ang yuug kakarung tung tepad yang Dios ampir tung tuu na ang pagkatapus kung maglekataw ra nganing taa, maitaaw ra ka numyung yuug sasaay tung panganud ang liit tung langit.” ");
INSERT INTO tbk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagkagngel yang paring pinakalandaw tia, anday dumang binuat na, ya ra bakbakay na yang aw̱el nang pag̱asuut na ay nasilag da ta duru tung itinuw̱al ni Jesus ang atia. Mag̱aning tung mga kaarumanan na, “Ta, ministir pang magdilemita pa ta sistigus? ");
INSERT INTO tbk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nagngel mi ra kang pagtiwakaw tung pagkadios yang Dios. Ya pa ag̱ari yang disisiun mi tung taung naa?” Numanyan tanirang tanan namagsintinsia ra tung anya ang bag̱ay ang pisan tung anyang ipaimatay ra ilem. ");
INSERT INTO tbk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Numanyan pagkasintinsia nira tung anya ta maning tia, dayun dang linawayan yang duma. Dayun da nirang pinedengan ang pagkatapus pinagtaraw̱angan da ka nira ta suntuk. Kada suntukun nira, aningen pa nirang, “Ta, atiing bantug da ang yawa unu yang pag̱aningen ang Cristo, abir, pintuen mu kanay kung tinu pa atiang nagtigbak tung nuyu!” Pati yang mga guardia asan, pinagtaraw̱angan da ka nira ta dapal. ");
INSERT INTO tbk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Balikan ta ra kanay ti Pedro duun tung aranek tung plasa-plasa yang balay. Numanyan may sasang baw̱ay ang turuw̱ulun yang paring atiang pinakalandaw ang ya ray nagpalenget tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkaita nang pamarang tung apuy, dayun na rang pinateek-teekan ta mupia ang inilala ang pagkatapus dayun na ra kang binugnung inaning, “Eey, midyu yaway sasang aruman ni Jesus ang nakaang tag̱a Nazaret!” ");
INSERT INTO tbk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pagkagngel ni Pedro tia, dayun dang nag̱ingwara ang mag̱aning, “Indi ilem nag̱aintindianu kung unu pay gustu mung ianing,” mag̱aning. Pagkatapus dayun dang nagpauman ang nagpaampir duun tung may purtang pagluluaan tung karsada. Atii may manung nanuluk da. ");
INSERT INTO tbk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pagkaita si yang turuw̱ulun ang atia tung anya, dayun dang nag̱ugtulun tung mga taung kemdengan asan ang mag̱aning, “Yang taung atia talagang sasang aruman na.” ");
INSERT INTO tbk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Atii, nag̱ingwara si ti Pedro. Buay-w̱uay si ta gesye, binugnu si yang mga taung atiang kemdengan asan ang inaning, “Eey, kamatuuran ka man ang yaway aruman na ay kipurki yawa sasang Galileanena ka!” ");
INSERT INTO tbk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Atii, dayun dang nanumpang mag̱aning, “Sistigus tung pagkamatuud yang Dios ang yang taung nakaang nag̱aaning mi talagang indi nag̱ailalaw. Parusaanaw pa yang Dios kung belag̱an matuud yang nag̱ianingung atia!” ");
INSERT INTO tbk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pagkaaning na tia, nanuluk si yang manu, bilang madua rang manuluk. Baklu nga demdemay na yang inaning ni Jesus tung anya ta nungayna ang mag̱aning, “Baklu manuluk yang manu, Pedro, maklua rang mag̱ingwara tung yeen ang yuu pala indiaw nag̱ailala mu.” Numanyan pagkademdem na tii, nag̱intra ra tarangiten ang duru ra kang pagsurug̱aten na. ");
INSERT INTO tbk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Taa numanyan atiing kaldaw ra, yang mga paring arabubwat ta katengdanan kasiraan da ka tanira yang mga pamagpakigmaepet pati yang mga sag̱ad asta yang tanan ang mga upisialis yang mga Judio, ya ray kali-kaling namag̱urunta-untaan. Pagkatapus anday dumang binuat nira, namagkalalangan da ang ti Jesus gapusun dang para guyurun duun tung ni Gubirnadur Pilato ug̱ud iintriga ra nira tung pudir nang pabistaan. ");
INSERT INTO tbk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pagkaw̱ut nira duun tung katalungaan ni Gubirnadur Pilato, kumus ti Jesus pag̱abangdanan dang lag̱i nira ang tanya unu pag̱ambu ang yay Adi nirang mga Judio, dayun dang binista yang Gubirnadur ang inaning, “Ta, unu pay idiklara mu? Matuud ang yawa yang Adi yang mga Judio?” Mag̱aning ka ti Jesus ang tuminuw̱al, “Aa, yawa ka nganing ay pag̱aning,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Numanyan yang mga paring atiang arabubwat ta katengdanan durung nag̱ibangdan nira tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Purisu numanyan dayun sing tinalimaan ni Gubirnadur Pilato ang, “Ay tia, india ra matuw̱al? Durug dakel yang nag̱ibangdan nirang atia tung nuyu!” ");
INSERT INTO tbk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piru ti Jesus, indi ra kang pisan nagliing-liing. Purisu ya ra kay naberengan ni Gubirnadur Pilato ta duru. ");
INSERT INTO tbk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ug̱aring kada kaw̱utun yang pistang atia, may sa nga prisuan ang pagpalpasan ni Gubirnadur Pilato, ang kumpurming tinu pay ingalukun yang mga tau tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naa pala tung uras ang atii, may sasang taung nag̱aranan tung ni Barabbas ang nakalabus, kasiraan da ka tanira yang mga masigkaribildi na. Ay atiing pagbatuk nira tung gubirnu, may mga taung pinangimatay nira. ");
INSERT INTO tbk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Numanyan may mga taung buntun ang namansitakwal asan ang ya ray namag̱ingaluk tung ni Gubirnadur ang palpasan na yang sa nga prisuan ang pariu ka tung nag̱abuat nang takun-takun. ");
INSERT INTO tbk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mag̱aning ka ti Gubirnadur Pilatong nagtimales, “Yang Adi ming mga Judio, yay gustu ming palpasanu?” ");
INSERT INTO tbk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Napagtalimaan da yang Gubirnadur ta maning tii, ay may gustu nang magpabalagbag tung pag̱asikad yang mga paring atiang arabubwat ta katengdanan ay kipurki nadeep na ra kang lag̱i ang anday dumang ipinag̱intriga nira tung ni Jesus tung pudir na, kung indi, yang kimun nirang subra tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ug̱aring ilem naang mga paring arabubwat ya ray namagpausbung tung kulu yang mga taung atiang buntun ang anday dumang ingalukun nira tung ni Gubirnadur ang palpasan, kung indi, ti Barabbas da. ");
INSERT INTO tbk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Taa numanyan, pagkaingaluk nira, dayun sing tinalimaan ni Gubirnadur Pilatong inaning, “Ay kung yay palpasanu tia, ay ti Jesus ang naang pag̱aningen ming Adi ming mga Judio, ya ra ilem unyayu?” ");
INSERT INTO tbk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Atii namangiseg dang namaglelpaken yang mga taung atiang buntun ang mag̱aning, “Ipalansang mu ra ilem tia tung krus!” ");
INSERT INTO tbk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mag̱aning si ti Gubirnadur Pilatong nagtimales, “Ayw̱a? Unu pang kasalananay ang binuat na?” Atii, mas pang dinulangan nira yang paglelpaken nirang pamansianing, “Ipalansang mu ra ilem tia tung krus!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Numanyan naisip da ni Gubirnadur Pilato ang kung indi na ra pauyunan yang kalelyag̱an yang mga taung atiang buntun, muya yay maliwag̱an na. Purisu anday dumang binuat na, kung indi, ti Barabbas ang atiang nag̱alelyag̱an nira, ya ray pinatuw̱ulan nang palpasan da. Pagkatapus ti Jesus tanya ya ray pinaburdunan na baklu iintrigaay na tung mga sundalu ang para ilansang da nira tung krus. ");
INSERT INTO tbk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Taa numanyan, dayun dang ingkelan nirang ipinakled tung balay ang dakulu ang yay pag̱istaran yang Gubirnadur. Pagkatapus ginuuyan da nira yang mga kaugpuan nirang mga sundalu. ");
INSERT INTO tbk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Numanyan yang binuat nira tung anya, pagkaluas nira yang aw̱el na, pinaablan si nira ta aw̱el ang lagwas ang tapel yang kulay na ang midyu tung suruutun ta mga adi. Pagkatapus namangkel da ta mga balag̱en ang kalarangan ang ya ray binuat nirang binakurung ang sinuklub tung kulu ni Jesus, bilang kuruna ta Adi. ");
INSERT INTO tbk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dayun dang pinagtag̱aman nira ta saludu-saludung intrimis ang inaning, “Basi pa ra ilem ang malawig ka yang kabui mung Adia yang mga Judio,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pagkatapus dayun da nirang linampesan tung kulu na ta maninga bastun-bastun ang nunut da ka ta paglaway nira tung tinanguni na. Pagkatapus tia, dayun da nirang pinagluud-luuran tung katalungaan na ang purus ilem tung intrimis yang paggaralangen nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Numanyan, pagkatapus yang pag̱irintrimisen nirang maning tia tung anya, dayun da nirang linuas yang aw̱el ang atiang tapel ang pagkatapus yang dating aw̱el na, ya si ay ipinasuut nira tung anya. Pagkatapus tia, dayun da nirang ginuyuran ang para ilansang da nira tung krus. ");
INSERT INTO tbk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Taa numanyan, tung paglua nira tung siudad, may sasang taung napanawan nirang duun liit tung lua yang siudad ang ya rag papakled. Ya ray pinagreg̱es nirang pinapagsakan yang kaw̱ala yang krus ang pag̱asakan ni Jesus. Yang taung atia, nag̱aranan tung ni Simon ang tag̱a Cirene ang yay tatay ni Alejandro durua ni Rufo. ");
INSERT INTO tbk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Numanyan ginuyuran da nira ti Jesus duun tung sasang lugar ang naggug̱uuyan tung Golgota ang yang linegdangan yang aran na ay kulu ta taung patay. ");
INSERT INTO tbk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Numanyan tinag̱aman da nirang paigmen ta binung linaktan ta pag̱aningen nirang mira ang yay pandisimular tung siit, piru pinangindian na. ");
INSERT INTO tbk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pagkatapus dayun da nirang linuasan yang mga aw̱el na ang pagkatapus ilinansang da nira tung krus. Pagkalansang nira, dayun dang namagburunutan ang para maintindian da kung unu pang pidasuay ta mga aw̱el ni Jesus yang maeklan nira sasa may sasa. ");
INSERT INTO tbk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yang uras ang ipinaglansang nira tung anya mga alas nuibing timpranu. ");
INSERT INTO tbk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dispuis may karatula ang sinulatan kung unu pay nag̱ipagbangdan tung anya. Yang isinulat asan ya taa: “Yang Adi yang mga Judio.” ");
INSERT INTO tbk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Dispuis may durua ka nga ribildian ang iginapil yang mga sundalung ipinanlansang ka tung durua nga krusan ang ipinakdeng tung binit ni Jesus ang nagtimbang. ");
INSERT INTO tbk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Numanyan may mga taung pamagtaraklib-takliw̱an asan ang ya ray pamagkeyeng-keyeng ang pamagtag̱am ta insultu tung ni Jesus ang mag̱aning, “Ta, yawang manggew̱a yang pagtuuan tang pinakalusu ang pagkatapus pakdengan mu si ka ta baklu tung seled ilem tulung kaldaw, abir, ilibri mu ra yang sadili mung maglampud asan tung krus!” ");
INSERT INTO tbk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Asta yang mga paring atiang arabubwat ta katengdanan may yang mga sag̱ad, ya ka, namagtag̱am da ka ta insultu tung anyang namag̱araning-aningan dang mag̱aning, “Yang duma ipinampalibri na, piru yang sadili na indi na ra pala masarangan ang ilibri. ");
INSERT INTO tbk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Atiay pag̱aningen ang Cristo ang yay Adi yang nasyun tang Israel? Kaministiran numaan ang lag̱i yag dawalay tang maglampud tung krus ug̱ud asanita ra mananged tung anya,” mag̱aning. Pati yang mga ribilding atiang durua ang ipinagngan tung anyang ipinanlansang tung mga krus, namagtag̱am da ka ta insultu tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Taa numanyan atiing kereng da yang kaldaw, nangiklep da yang intirung banwang atii. Baklu ngaulikay yang sadlaw na ang mga pag̱alas tris da yang apun. ");
INSERT INTO tbk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tung uras ang atii, ti Jesus napagkendal da ta tudu ang mag̱aning tung bitala yamen ang Hinebreo, “Eloi, Eloi, lema sabaktani!” ang yang gustu nang ianing, “Ay Diosu, Diosu, ayw̱a pinaw̱ayaanaw ra ka ilem nuyu tani tung kalainan?” ");
INSERT INTO tbk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Numanyan yang dumang kemdengan asan, pagkagngel nira yang inaning nang atia, ya ra ag̱aningay nira, “Uay, ti Elias pala ya ray nag̱apangambayan na!” ");
INSERT INTO tbk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Atii may sa nga tauan ang lag̱i-lag̱ing naglaksung nangkel ta ipinalebleb na tung binung nangaklem da ang asta tagmak da ta binu. Pagkatagmak da, dayun na rang isinakbet tung tumbung yang maninga tigbaw ang yay itinuluy na tung nganga ni Jesus ay tag̱aman na ra rin ang panutnutun. Pagtuluy na, ya kay pag̱aning na tung mga kaarumanan nang mag̱aning, “Abir, kung angayen pa ni Elias ang tangtangen tung krus,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Atii nagkendal si ta maknul ti Jesus ang ya ra kay pagkabuntuk yang linawa na. ");
INSERT INTO tbk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tung pagkabuntuk yang linawa na, yang kurtinang nag̱ipagsalag̱a tung kuartung pinakasagradu duun tung pagtuuan ang pinakalusu, ya ra nga bakbak tung kasubngan na, manliit tung abwat, utas da ang asta tung sidsiren na. ");
INSERT INTO tbk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Numanyan duun tung pinakdengan yang mga krus, yang kapitan yang mga sundalung atiang piniaran ni Gubirnadur Pilato, duun agtatalunga tung ni Jesus. Pagkaita na yang pag̱apatay ni Jesus ang nunut da ta kendal, dayun dang nabnga ang mag̱aning, “Yang taung naa talagang Ana Yang Dios!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dispuis duun tung tukaw-tukaw may mga baw̱ay ang pamagpaniid tung tanan ang pagkarainabu. Duun ka tung nira ti Mariang tag̱a Magdala may ti Maria kang sam bilug ang yay nanay ni Santiagong atiang gesye durua ni Joses. Pati ti Salome duun ka. ");
INSERT INTO tbk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yang mga baw̱ay ang atiang tulu, atiing pagliliw̱utun pa ti Jesus duun tung Galilea, ya ray namagpakigduman tung anyang namag̱asikasu tung mga kaministiran na. Duru kang mga baw̱ay ang duma duun ang ya kay namagpakigluyug tung ni Jesus atiing pagdistinu na duun tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Taa numanyan, atiing apun da yang kaliw̱utan, kinaw̱ut da yang uras ang dapat ipagtapus yang mga tau tung tanan ang mga pag̱urubraen nira ang para simpan da tanira tung pagkaw̱ut yang uras ang ipamaenay nira ang ya ray mag̱impisa tung pagkasantek yang kaldaw. Purisu may sasang tau ang tung makali nag̱ulag dang minangay duun tung ni Gubirnadur Pilato. Yang taung atia nag̱aranan tung ni Jose ig tag̱a Arimatea. Duru kang lag̱ing pagpakbat na tung uras ang ipagpalapus yang Dios yang paggaraemen nang magbawi tung nasyun nira. Maskin sasang pagpakigmaepet ang pag̱agalang ka pa man ta mupia yang mga kaarumanan nang mga pamagpakigmaepet tung banwa, pinaiseg na ra ka enged yang isip na ang asta nagpalangaas da ilem ang nag̱ingaluk tung ni Gubirnadur kung maimung itug̱ut na tung anya yang tinanguni ni Jesus ang para kaldaw pa mapalg̱ud dang lag̱i duun tung leyang. ");
INSERT INTO tbk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Numanyan pagkagngel ni Gubirnadur Pilato yang iningaluk ni Jose, nabereng da ta mupia ang ayw̱at kakaling napatay ti Jesus. Purisu dayun na rang pinaguuyan yang kapitan ang atiing piniaran nang magpalansang tung ni Jesus ang pagkatapus tinalimaan na kung patay ra ka man ang matuud. ");
INSERT INTO tbk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Numanyan pagkasiguru na ra tung kapitan ang patay ra ka man, dayun dang nagkalalangan ang itug̱ut da tung ni Jose yang tinanguni ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Numanyan pagkatug̱ut tung anya, dayun dang nangalang ta aw̱el ang kulit ang pira pang yarda ang matitinlu kang klasi. Pagkatapus dayun na ra kang inangayan ti Jesus ang ipinatangtang tung krus. Dayun na rang pinasaw̱ed-saw̱eran yang aw̱el ang atia ang pagkatapus itinuw̱ul na rang ipalg̱ud da duun tung sasang leyang ang ibinangbang tung batung padir. Numanyan pagkapalg̱ud da tung leyang, dayun na rang itinuw̱ul ang paligdan da yang purta na ta batung dakulu ang pinasag̱ing binilug ang ya ray itinakep. ");
INSERT INTO tbk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Simanyan ti Mariang naang tag̱a Magdala may ti Mariang naang sam bilug ang yay nanay ni Joses pamagpaniid ka ang ay pa ipalg̱uray nira ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Taa numanyan, pagkalampas da yang kaldaw ang nag̱ipamaenay ang atiing Sabadu rang santek da yang kaldaw, ti Mariang naang tag̱a Magdala may ti Maria kang naang sam bilug ang nanay ni Santiago may ti Salome ya ray namangalang ta mga paamut. Yang planu nira, tung pangayag, mamansiangay ra duun tung pinanlug̱uran tung ni Jesus ang para yang paamut ang atia, ya ray ipandasek nira tung aw̱el ang atiang isinaw̱ed-saw̱ed tung tinanguni na. ");
INSERT INTO tbk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Numanyan atiing pagkapangayag da ang timpranung pisan tung primirung kaldaw tung seled yang sang linggu, bilang kaldaw ta Linggu, ya ra kay pag̱angay nira duun tung pinanlug̱uran. Yang kaldaw baklu pa ka ilem ang lumimpak tung sag̱iid. ");
INSERT INTO tbk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Numanyan tung pagparanawen nira, namagkeresen da kung tinu pa kaya ay maaraw̱a nirang magpalig̱id yang batung atiang itinakep tung purta yang leyang ang para mapakleran nira. ");
INSERT INTO tbk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Numanyan atiing naalenget-lenget da tanira, bandawen nira, naa pala yang batung atia napalig̱id dang napabinit ag̱ad durug dakul ang batu. ");
INSERT INTO tbk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Purisu tung pagkaw̱ut nira duun, dayun-dayun yang pagpakled nira tung pinanlug̱uran. Pagkapakled nira, may naita nirang sasang midyu kaw̱ataan ang yag kakarung ampir tung tuu nira ang may nag̱asuut nang aw̱el ang langkuy ig nangaklag da ta duru. ");
INSERT INTO tbk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Numanyan ya ray nagbugnu tung nirang mag̱aning, “Eey, indiamu ra meled. Nag̱askeanu ang yang nag̱asagyap mi taa ti Jesus ang atiang tag̱a Nazaret ang ilinansang tung krus. Pinabungkaras da yang Dios, anda ra taa. Uay, nani ra yang pinagpalw̱ug̱an tung anya. ");
INSERT INTO tbk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ta ala, magpanawamu ra. Panganingen mi yang mga taung pinangugyatan na ang tanya nagtukaw ra tung nira duun tung Galilea. Duun da mamag̱irita tanira ang katulad ka tung inaning na tung nirang tan taa pa. Ti Pedro enged yay siguruen ming aningen,” mag̱aning duun yang kaw̱ataan. ");
INSERT INTO tbk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Purisu numanyan pagkagngel nira yang inaning yang kaw̱ataan, diritsyu ra ka man ang namansilua tanira tung pinanlug̱uran ang namagralaksuan. Pangetab-ketaw̱an da ay natetenged tung pagkabereng nirang subrang alus indi ra kaw̱utun ta pag̱intindi nira. Dispuis tung pagralaksuen nirang pamag̱impurta duun tung mga taung nag̱apangugyatan ni Jesus, anda ray naaning nira tung duma may ruma, ay natetenged pinamangelbaan da ta duru. ");
INSERT INTO tbk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Atiing nagbungkaras da ti Jesus, ang timpranu pang pisan tung primirung kaldaw tung seled sang linggu, bilang kaldaw ta Linggu, yang tingkawan nang pinagpaitaan, ya ra ti Mariang naang tag̱a Magdala ang ya ray pinalayasan na ta pitu nga dimunyuan ang tukaw. ");
INSERT INTO tbk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pagkatapus tia, ti Mariang naa diritsyu rang minangay duun tung dating mga ugpu ni Jesus. Kaw̱utan na tanira, pamagtarangiten ang pamag̱urulimengmengen. Kapurisu dayun dang suminublang ang nagbaw̱alitaen tung nira. ");
INSERT INTO tbk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pagkagngel nira yang balita na ang ti Jesus bui ra unu ig sinakep da unu ta mata na, indi ra ilem pinananged nira. ");
INSERT INTO tbk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Numanyan tung pira pang kaldaw, nagpaita ra ti Jesus tung mga tauan nang durua atiing pamagpanaw tanira duun tung lua yang siudad ang Jerusalem. Ug̱aring tung pagpaita na tung nira, indi pa rin nailala nira ay naglew̱ad da yang pagkabetang na. ");
INSERT INTO tbk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pagkailala nira ang ya ra ka man ti Jesus, dayun dang nansibalik duun tung Jerusalem ang namagbaw̱alitaen tung mga kaarumanan nirang kadaklan. Piru indi ra ka enged pinananged nira. ");
INSERT INTO tbk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Taa numanyan, tung pangultimung pagpailala ni Jesus, nagpaita tung mga tauan nang atiang sam puluk may sasa atiing pamagsararu ra tanirang tanan. Binasul na tanira natetenged tung pagdiskumpiar nira ang ayw̱at mateg̱as yang mga isip nirang indi namananged tung mga aruman nirang yay naita tung anyang pagkatapus ang pinabungkaras da yang Dios. ");
INSERT INTO tbk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pagkatapus dayun na rang sinugpatan yang bitala nang mag̱aning tung nira, “Magliliw̱utunamung magparakaw̱utun yang Matinlung Balita natetenged tung yeen tung tanan ang mga tau tung bilug ang kaliw̱utan. ");
INSERT INTO tbk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kumpurming tinu pay magsuku tung yeen ang magtalig yang sadili na ang yang pagtalig nang atia tung yeen ipananglit na yang nag̱adapatan nang magpabenyag, ya ray tapnayen yang Dios. Piru kumpurming tinu pay indi ra magsuku tung yeen ang magtalig, tung uri ta kaldaw yay sintinsiaan yang Dios tung kalainan ang asta tung sampa ang anda enged ang pisan ay katapus-tapusan na. ");
INSERT INTO tbk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Dispuis yang kumpurming nagtalig tung yeen, paktelenu ra ang para mapagpalapus ta mga pruibang makabew̱ereng ang mga maning taa. Mapagpalayas tung mga dimunyu ekel tung katengdanan ang ipakdulu tung nira. Mapagbitala ka tung dumang mga bitalang indi pinag̱aralan nira. Kung alimbawa mapges tung mga iraw ubin mainem ta may laket nang lasun, indi ra maunu pa. Kung deenan nira yang may mga laru, asan da ka magmaayen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kapurisu numanyan, pagkatapus ni Jesus ta pagbitala tung mga tauan na, dayun dang ingkelan yang Dios duun tung langit. Duun da nagkarung tung ampir tung tuu na ang para kasiraan da tanirang mamaggaraemen. ");
INSERT INTO tbk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Taa numanyan, yang mga tauan nang atiang nangabutwan, ya ray namagliit duun tung Jerusalem ang namagparakaw̱utun tung maskin ay pang banwaay. Tinaw̱angan ta mupia ni Ginuung Jesus tung pagparakaw̱utun nira ang yang bitalang nag̱ipagpakaw̱ut nira tung mga tau yay pinapruibaan na ang talagang matuud ang liit tung Dios ekel tung mga pruibang mga maning tiang nag̱ipalua nira. Taa numanyan, mansikaw̱ut yang mga baw̱ay ang atia tung na Pedro, antimanung namagbaw̱alitaen da tung nira yang tanan ang itinuw̱ul yang kaw̱ataan tung nira. Numanyan tung pira pang kaldaw, ti Jesus mismu ya ray nanuw̱ul tung mga tauan nang mamagliliw̱utun tung bilug ang kaliw̱utan ang para mamagparakaw̱utun tung mga tau yang sagradung bitala ang andang pisan ay kauman-umanan na kung ya pa ag̱aring tanira matapnay yang Dios ang asta tung sampa.");
INSERT INTO tbk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Maginuung Teofilo, Nag̱askean mu ra ka ang dakeleng mga aruman yamen ang namagprusigir ang namagsulat natetenged tung kapanawan yang mga bag̱ay ang nagkamatuud da tani tung yamen ang ya ka man mismu ay nagkaraulang tukaw. ");
INSERT INTO tbk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yang pinausuyan nirang namagsulat, ya ra yang balitang ipinag̱intriga tung yamen yang mga kaarumanan ni Jesus ang dati ang disti pa tung primiru yay nangaita yang tanan ang atia ig tung nira ra ka ipiaray na ang para ibalita nira tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Purisu, Maginuung Teopilo, naisipu ra ka ang matinlu ka siguru ang yuu si kay magsulat natetenged tung kapanawan yang mga bag̱ay ang atii ay natetenged pinagpasadsaranu ra ta mupiang sinulipet, mag̱impisa pa tung kapungul na ang asta tung tumbung na. Isinulatu ra nganing tiang sinugpat-sugpat ta maayen ug̱ud asan da nga siguruay mung talagang matuud yang ipinagtulduk yang duma tung nuyu. ");
INSERT INTO tbk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Atiing paggaraemen ni Gubirnadur Herodes tani tung intirung Judea, may sasang pari ang nag̱aranan tung ni Zacarias. Tanya sakep yang sasang grupu yang mga pari ang pinamuaran ni Abias ang tukaw. Ti Zacarias ang naa may kasawa nang nag̱aranan tung ni Elisabet. Tanya sasa kang ana ta pari ang pariu ka tung kasawa na. ");
INSERT INTO tbk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yang duruang magkasawang naa, parariung matandes tung pagterelengen yang Dios ay matinumanen tung tanan ang mga katuw̱ulan na. ");
INSERT INTO tbk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Andang pisan ay ana nira ay natetenged ti Elisabet bakyaw ra kang lag̱i ig numanyan masyadu ra ka atiing pagkamemepten nirang durua. ");
INSERT INTO tbk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Taa numanyan, kinaw̱ut da yang uras ang ipagsirbisyu yang grupu na Zacarias tung seled san linggu tung katalungaan yang Dios duun tung pagtuuan ang atiang pinakalusu. ");
INSERT INTO tbk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Taa simanyan sigun tung ug̱ali nirang mga pari ang mamagburunutan, ti Zacarias ya ray natemengan ang magpataw̱uk yang paamut. Purisu dayun dang nagpakled tung pagtuuan nira tung ni Yawi ang atiang pinakalusu ang para magpataw̱uk yang paamut. ");
INSERT INTO tbk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Numanyan yang mga taung buntun ang namagsaragpun duun tung lua yang pagtuuan, pamag̱arampuen da ay ya ray uras ang nag̱ipagpataw̱uk yang paamut duun tung kakleran. ");
INSERT INTO tbk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mintras pagpataw̱uk ni Zacarias yang paamut, may sasang angil ang nag̱atuw̱ul yang Dios ang yay nagpaita tung anya. Yag kekdeng tung tapalang ni Zacarias tung binit yang kuari lamisaan ang pagpataw̱ukan na ta paamut ang ampir tung wala na. ");
INSERT INTO tbk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkaita ni Zacarias, ya ra ngaklag ig binalayan da ka ta eled nang duru. ");
INSERT INTO tbk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mag̱aning yang angil ang nagbugnu tung anya, “Zacarias, india ra ilem mag̱eled ay kipurki pinamati ra yang Dios yang ipinag̱ampu mu. Yang kasawa mung ti Elisabet, mangana ra ka enged ta ana mung lalii. Mapangana na ra nganing tia, paaranan mu tung ni Juan. ");
INSERT INTO tbk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sadyaana rang pisan tung uras ang atia ig duru kang mga taung panadyaan da ka natetenged tung pag̱ingtau na. ");
INSERT INTO tbk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kipurki yang ana ming atia, abwat yang katengdanan na tung pagterelengen yang Dios. Dispuis yang ug̱ali na, talagang inding pisan manginem ta binu, maskin unu pang irinemenay ang pamuu, kung indi, manguluan dang lag̱i yang Espiritu Santo, maskin tung tian pa ni nanay na. ");
INSERT INTO tbk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Purisu ekel tung bitalang ipagpadapat na tung mga masigkanasyun nang mga Israel, duru rang mamagsug̱at ang mamagbalik tung ni Yawi ang ya kang lag̱i ay Dios ang pag̱atuuan nira. ");
INSERT INTO tbk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tanya magyaring palaskaw na. Paktelen ta mupia yang Espiritu Santo yang bitalang ipagpakaw̱ut na ang katulad ka tung pagpadlut na tung bitalang ipinagpakaw̱ut ni Elias atiing tukaw. Purisu asan da mag̱urulikan ta kinaisipan may kinaisipan yang mamag̱ama ang yang pag̱aranaan nira narangga ra rin. Pati yang mga taung pagpasuag tung kalelyag̱an yang Dios, mamanmanan da ka yang mga isip nira ang asta eyangan da ka ta pag̱irintindien ang magkapariu ka tung mga kaarumanan nirang matinumanen. Kipurki yang sikaren nang magparakaw̱utun ta maning tia, ay ang para simpan da yang mga taung mamagpauyun da tung ni Ginuu tang magkakaw̱ut,” ag̱aaning duun yang angil tung ni Zacarias. ");
INSERT INTO tbk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mag̱aning ka ti Zacarias ang nagtimales, “Ya pa ag̱aring masiguruu ang atia mainabu ka man tung yamen ang magkasawa? Ay naang maepetaw ra ka pa man. Maski yang kasawaw, maepet da ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mag̱aning ka yang angil ang nagtuw̱al, “Nag̱atkean mu, yuu ti Gabriel ang pirmiaung yag kekdeng tung katalungaan yang Dios. Tanya ra nganing ay nagtuw̱ul tung yeen ang magpakigkaw̱ut tung nuyu yang balitang atiang durug tinlu. ");
INSERT INTO tbk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naa w̱a ya ray tandaan mu. India ra maimung magbitala ang asta kaw̱utun da ilem yang uras ang magkamaningan da yang mga bag̱ay ang atiang ipinagngelu tung nuyu. Ya ray mainabu tung nuyu natetenged india ra nananged tung ibinitalaw tung nuyu, ang yay magkamatuud da ka enged tung uras ang ipinagtipu yang Dios,” ag̱aaning yang angil duun tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Simanyan yang mga tau duun tung lua, pamag̱elat da tung ni Zacarias ang lumua. Durung pagkabereng nira kung unu ray ag̱abuayan na duun tung kakleran yang pagtuuan. ");
INSERT INTO tbk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Simanyan paglua na, naa pala indi ra mabitala tung nira. Asan da nga simanay nira ang may ipinadakat yang Dios tung paneleng na duun tung kakleran. Numanyan kumus indi ra mabitala, nag̱intra ra ilem sinyas tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Simanyan atiing pagkumplitu ra ni Zacarias yang panirbian na duun tung pagtuuan, dayun dang minulik. ");
INSERT INTO tbk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Numanyan pag̱ulik na tung balay, tung pira pang bulan, namuu ra ka man ti Elisabet ang kasawa na. Tung seled limang bulan, nagpameneng da ilem asan tung balay nira. ");
INSERT INTO tbk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Maning taa yang ikinesen-kesen na tung isip na, “Numanyan ang mga uras ang naa, durug tinlu yang pagtaraw̱angen ni Yawi tung yeen. Naang kakaeyakenu rin tung mga arumanung mga baw̱ay ang indiaw mangana, kinuat na ra,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Numanyan, atiing pag̱enem dang bulan yang pagmaratungun ni Elisabet, naang angil ang naang ti Gabriel, tinuw̱ul si yang Dios ang mangay duun tung sasang lansangan ang paggug̱uuyan ang Nazaret ang yay lug̱ud tung sinakepan yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ay may bitalang ipakaw̱ut na tung sasang daralang nag̱aranan tung ni Maria. Tanya binalay yang sasang laliing nag̱aranan tung ni Jose ang yay sasang kanubli ni Adi David. ");
INSERT INTO tbk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Numanyan, pagkaw̱ut ni Gabriel, dayun dang nagbugnu tung ni Maria ang mag̱aning, “Numanyan yang mga taung buntun ang namagsaragpun duun tung lua yang pagtuuan, pamag̱arampuen da ay ya ray uras ang nag̱ipagpataw̱uk yang paamut duun tung kakleran,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pagkagngel ni Maria tia, ya ray naliw̱eg̱an na ta mupia. Ipinagkesen-kesen na ra ilem tung isip na yang ibinugnu nang atia tung anya kung unu pa kayay gustu nang ianing. ");
INSERT INTO tbk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mag̱aning yang angil ang nagsugpat, “Maria, india ra ilem mabereng ay pinilika ra yang Dios ang pakdulan ta dakulung kaayenan mu. ");
INSERT INTO tbk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Anday duma, magmatunga ra. Pagkatapus kung kuw̱utun da nganing yang uras, manganaa ra ta sasang lalii ang yay paaranan mu tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yang ana mung atia magkatinir ta katengdanan nang abwat. Aningen nganing yang Dios ang Makagag̱aem ang ya ra yang pag̱aningen nang Ana Na natetenged yay papanublien na tung pag̱aradien ni Adi David ang kinaampu na. ");
INSERT INTO tbk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Purisu yay maggaraemen ang asta tung sampa tung nasyun ming mga kanubli ni Jacob. Anda enged ang pisan ay katapus-tapusan yang paggaraemen na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mag̱aning ti Mariang nagtimales, “Abee, ya ra ag̱ari w̱asung magkamaninganaw ra ang katulad ka tung inaning mung atia sindu anda ngani ay laliing nag̱asaplid tung yeen?” ");
INSERT INTO tbk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mag̱aning yang angil ang tuminuw̱al, “Maria, yang Espiritu Santo yay maglampud tung nuyu ang para yang ketel yang Dios ang makagag̱aem, yay masirungan mu. Purisu yang mulang ipangana mu limpiung pisan yang pagkatau na. Aningen nganing yang Dios ang ya ray pag̱aningen nang Ana Na enged. ");
INSERT INTO tbk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","India ra ilem mabereng kung balitaana ra yeen yang natetenged tung nainabu tung sasang kaparintian mung ti Elisabet. Maskin maepet da, piru numanyan pagpanaw ra tung enem ang bulan yang pagmaratungun na, ag̱ad pag̱aningen da ka rin ang bakyaw. ");
INSERT INTO tbk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kapurisu asan da ka ngaintindiay mu ang andang pisan ay indi kayanan yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mag̱aning ti Mariang minles, “Simpanaw rang magpaturuw̱ulun tung ni Yawi ang kumpurming unu pay lalang na tung yeen. Magkamaninganaw ra tia tung inaning mung atia tung yeen,” ag̱aaning. Pagkagngel yang angil tia, dayun dang nagliit. ");
INSERT INTO tbk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Taa numanyan tung mga kaldaw ang atii, ti Maria nag̱apura rang nagpanaw ang para mangay ra tung ni Elisabet duun tung sasang lansangan ang nabtang tung kabukiran ang yay lug̱ud tung sinakepan yang Judea. ");
INSERT INTO tbk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagkaw̱ut na duun tung balay na Zacarias, dayun dang nagpakdul ta mupiang kaldaw tung ni Elisabet. ");
INSERT INTO tbk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pagkagngel ni Elisabet yang busis ni Maria, yang mula tung tian na, gulpi ra ilem ang nangiswal-kiswal. Pati ti Elisabet tanya, dayun dang minanguluan yang Espiritu Santo. ");
INSERT INTO tbk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Purisu napagbitala ra ta maknul ang mag̱aning, “Maria, tung tanan ang mga baw̱ay, yawa enged ay nag̱apakaayen yang Dios. Pati yang mulang atiang ipangana mu, pakaayenen na ka. ");
INSERT INTO tbk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nag̱aberengaw ta dakulung pagkabereng ang ayw̱at yuung aranek ang pisan ta pagkabetang, yuu pay nag̱abisitaan mu ang yaway magyaring nanay ni Ginuu tang maggaraemen tung yaten. ");
INSERT INTO tbk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kipurki teed mu, Maria, ta nungaynang pagkagngelu yang pagpakdul mu ta mupiang kaldaw, yang mulang pag̱imatungu, dayun dang inampayan ta kasadyaan nang nangiswal-kiswal tung tianu. ");
INSERT INTO tbk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Teed mu tiang kasadya yang isip mung nanangera rang lag̱i ang magkamatuud da yang pinag̱aning tung nuyung liit tung ni Yawi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mag̱aning ti Mariang nagbitala, “Agdayawenu ta mupia ti Yawi. ");
INSERT INTO tbk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ag̱aampayanaw ra ta kasadyaanung duru natetenged tung anyang yay Mananapnayu. ");
INSERT INTO tbk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ay kipurki maskin yuu sasang turuw̱ulun nang aranek ang pisan ta pagkabetang, piru dinemdemaw ra ka enged anya. Teed mi, mag̱impisa simanyan, maskin pira-pira rang esleb ta mga taung mamagsurubli-sublian, yuu ra ag̱aningay nirang tanan ang sasang pinasadyaan enged yang Dios ang pinakaayen ta mupia. ");
INSERT INTO tbk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ya ray maaning nira natetenged tung bag̱ay ang naang durung pisan agkatinlu ang binuat tung yeen yang Dios ang Makagag̱aem ig durug kasagradu. ");
INSERT INTO tbk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Maskin pira-pira rang esleb ta mga tau ang mamagsurubli-sublian, anda enged ay kabuntuk-buntukan yang kaildaw na ang nag̱ipaita na tung kumpurming panggalang tung anyang may ekel na kang pag̱eled na. ");
INSERT INTO tbk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kapurisu asan da nga siguruayu ang indi ra ilem buay, ipalapus na ra enged yang puirsa na. Pangaskasen na rang pangwasaken yang mga taung masyadug abwat yang pagpabetang nira tung mga sadili nira. ");
INSERT INTO tbk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pati yang may mga katengdanan ang abwat, ipampalagpak na ra kang panguaten tung mga katengdanan nira. Piru yang mga taung aranek ta pagkabetang ya si ay ipampalandaw na. ");
INSERT INTO tbk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yang mga manggaranen pampaliiten na ang andang pisan ay mabitbit nira. Piru yang mga taung nag̱apasaran ta suw̱uk, ya ray asikasuen na ta mupia tung tanan ang mga kaministiran nira. ");
INSERT INTO tbk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kipurki yang nasyun tang naang Israel ang yay pinilik nang tukaw ang para magpaturuw̱ulun tung anya, ya ray taw̱angan na ta mupia. Ay indi na ra malipatan yang pinangakuan na tung ni Abraham ang tukaw ang tanya pati yang mga kanubli na, pangildawan na ang asta tung sampa ang katulad ka tung nagkaraulit na tung mga kinaampu tang namagsurubli-subli tung ni Abraham,” ag̱aaning duun ti Maria. ");
INSERT INTO tbk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Taa simanyan nagpadayun ti Maria tung na Elisabet ta mga tulung bulan, baklu pa minulik duun tung Nazaret. ");
INSERT INTO tbk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Taa numanyan ti Elisabet tanya, kinaw̱ut da yang uras ang ipangana na ang pagkatapus nangana ra ka man ta ana nang lalii. ");
INSERT INTO tbk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Simanyan yang mga kamalay na may yang may mga kaampiran tung anya, pagkagngel nira yang balita kung ya pa ag̱arig katinlu yang kaildaw ang ipinagpaita yang Dios tung anya, namagpakigdamay ra ka tung anya tung kasadyaan na. ");
INSERT INTO tbk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pagkatapus numanyan, pagkaw̱ut da yang yawalung kaldaw, namagbalik si tung balay na Elisabet ang para yang mula pabuatan da ta tanda tung tinanguni na. Naa pala, yang duma may planu ka nira ang kung tapus da nganing yang pag̱urubraen ang atia tung mula, paaranan da nirang ipatukayu tung ni tatay nang ti Zacarias. ");
INSERT INTO tbk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Numanyan pagkasiman yang nanay na, dayun dang nabngang mag̱aning, “Eey, belag̱an ang yay aran na tia, kung indi, ti Juan yang aran na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mag̱aning si ka tanirang namagtimales, “Ya pa ag̱ari tia, sindu yawa anday may kaampiran tung nuyu ang maning tia yang aran na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dayun da nirang sininyasan yang tatay yang mula kung unu pay nag̱alelyag̱an nang ipaaran na tung ana na. ");
INSERT INTO tbk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nagsinyas da ka ang tanya pakdulan da ta pagsulatan na. Numanyan anday dumang isinulat na duun, kung indi, ya taa: “Yang aran na ti Juan.” Pagbasa nira yang aran na, durug dakul yang pagkabereng nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pagkasulat ni Zacarias tia, lag̱i-lag̱ing nabutayag da yang busis nang napagbitala. Yang primirung nainambit na, nag̱intra ra dayaw tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Numanyan, pagkagngel yang mga kamalay nira ang napagbitala ra ti Zacarias, nangabereng da ta mupia ay nasiman da nira ang yang nainabung atia sasang patakaran yang Dios. Purisu ibinalita-w̱alita ra nira ang asta nagsarambung da duun tung banwang atiang Judea, basin ay pang kabukaturanay na, basin ay pang kalegnaanay na man. ");
INSERT INTO tbk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kumpurming nagngel yang balita, ipinagkesen-kesen nira tung mga isip nira kung unu pa kayay luaan na yang mulang atia, ay bistu ra nira yang puirsa yang Dios ang pag̱erekelen tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ibalik ta ra kanay tung uras ang atiang pagsaragpun nira tung balay na Zacarias. Numanyan ti Zacarias ang naang tatay yang mulang atia, kumus nag̱amanguluan da yang Espiritu Santo ang nag̱apasanag̱an yang pagparainu-inuen na, napag̱ula ra ta maning taa: ");
INSERT INTO tbk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Itang mga nasyun ang Israel, dapatitang magdayaw tung ni Yawi ang yay Dios ang nag̱atuuan ta. Kipurki ta yaten ang mga tauan na, palengtanita ra anyang ipalibri. ");
INSERT INTO tbk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ay paangayanita ra anya tung sasang maktel ang manigpanapnay tung yaten ang yay sasang kanubli ni Adi David ang sasang turuw̱ulun na atiing tukaw. ");
INSERT INTO tbk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yang pagpaangay na tung anya, uyun ang pisan tung ipinaula nang tukaw tung mga taung pinamilik nang magpalatay yang bitala na. ");
INSERT INTO tbk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Napagpangaku ra ang ipalibriita anya tung kemkem yang mga taung pamagdemet tung yaten ekel tung manigpanapnay ang atia. ");
INSERT INTO tbk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Simpri demdemen na ra ka enged yang nabitalaan na tung mga kinaampu ta ang yang nasyun ta ildawan na. Kegngan na ka enged yang pinangakuan nang atiang sagradu, ang ya ra kay pinabaked nang sinumpaan pa tung ni Abraham ang yay namuad tung nasyun ta. ");
INSERT INTO tbk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Ay yang pinangakuan na tung anya, ang ta yaten ang mga kanubli na, bawienita anya tung kemkem yang mga taung pamagpakigsuay tung yaten, ug̱ud erek-erek tang magtuu tung anya ang anda ray eldan ta ang bilug ka yang mga isip tang magtuman yang magkatama ang uyun tung kalelyag̱an na, mintras buiita pa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Atii, dayun dang inaning ni Zacarias yang ana na ta maning taa: “Pati yawa duduy, puidia ra kang ulaanu ang buatena ra yang Dios ang makagag̱aem ang yaway sasang manigpalatay yang bitala na tung mga tau. Purki yaway mag̱ing palaskaw ni Ginuu ta ang para yang maning pa tung dalan ang panawan na simpanen mu. ");
INSERT INTO tbk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bilang yaway magpaintindi tung mga masigkanasyun tang mga Judio kung ya pa ag̱aring mampatapnay tanira tung Dios ang asan da nga patawaray na tanira tung mga kasalanan nira. ");
INSERT INTO tbk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anday dumang ipagtapnay na tung yaten ang mga tau, kung indi, yang kakaildawen nang duru. Ay ekel tung kakaildawen nang atia, paangayanita ra anya tung sasang manliit tung langit, ang yang kaalimbawaan na pariu tung kaldaw ang baklung pagmura. ");
INSERT INTO tbk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ay yay magpasanag tung mga kinaisipan tang nag̱akiklepan ekel tung pagpaalawid ta tung Dios. Ya ray papanaw nang magmangulu tung yaten ang asta matultulan ta ra yang dalan ang pagbalikan ta tung Dios,” mag̱aning duun ti Zacarias ang pinapag̱ula yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Taa numanyan, naang mulang naang ti Juan, nagdakul dang nagdakul. Mintras pagdakul, yang pag̱irintindien na tung Dios pagdakul ka. Atiing dakulu ra enged, nagtinir da tung mga lugar ang palag-palag yang mga tau na ang yay pinagpalakted-lakteran nang asta kinaw̱ut da yang uras ang ipaglua na tung mga masigkanasyun nang mga Israel. ");
INSERT INTO tbk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Taa numanyan, tung uras ang atii, yang Maginuung Ading Pinakalandaw duun tung Roma ang nag̱aranan tung ni Agosto, ya ray naglansar ta sasang urdinansa ang yang tanan unung mga kinasakpan na, maskin ay pang banwaay, dapat unung mamagpasalista. ");
INSERT INTO tbk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yay primirung pasalista atiing ti Quirinio yang Gubirnadur duun tung banwang pag̱aningen ang Siria. ");
INSERT INTO tbk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Purisu numanyan anday duma, yang tanan ang mga tau duun, kung ay pay dating banwang natauan yang mga kinaampu nira, duun ka namag̱arangayan ang para mamagpasalista. ");
INSERT INTO tbk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Asta naang ti Joseng naang binalay ni Maria ya ka. Kumus tanya sasang kanubli ni Adi David, anday duma, nagliit da duun tung lansangan ang Nazaret ang lug̱ud tung sinakepan yang Galilea ang para magdistinu duun tung sasang lansangan ang paggug̱uuyan ang Betlehem ang lug̱ud tung sinakepan yang Judea. Ay yay banwang natauan ni Adi David ang kinaampu na atiing tukaw. ");
INSERT INTO tbk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ay duun magpasalista, durua tanira ni Mariang binalay na ang paranganaen da. ");
INSERT INTO tbk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Purisu numanyan, atiing pagkaw̱ut nira duun tung Betlehem, kinaw̱ut da yang uras ang ipangana ni Maria. ");
INSERT INTO tbk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Purisu duun da ilem nangana ta ana nang lalii ang ya ray ana nang pangulu. Pagkapangana na, dayun na rang sinaw̱ed-saw̱eran ta mga gayg̱ay ang pagkatapus ipinalw̱ug na ra ilem tung sasang pasungan. Ay ya pa ag̱ari, andang pisan ay lugar ang masaleetan nira tung balay ang darayunan ta mga dayuan ay getek dang pisan ta mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Taa numanyan, duun tung banwang atii, may mga manigpastur ang pagberelesan ta pagpulaw tung mga kaayepan nira duun tung lua yang lansangan. ");
INSERT INTO tbk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Numanyan limput da tanira ta sasang angil ang tinuw̱ul yang Dios. Atiang lag̱i nasinggatan da tanira ta durug sulaw ang ya ra yang kasusulawen ang pag̱atiniran yang Dios. Purisu pinamalayan da ta eled nirang duru. ");
INSERT INTO tbk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mag̱aning yang angil ang nagbugnu tung nira, “Indiamu ra mag̱eled ay yuu may sasang ibalitaw tung numyung durug tinlu ang yay makasasadyang pisan ta mga isip yang tanan ang mga masigkanasyun mi. ");
INSERT INTO tbk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kipurki numaan ang law̱ii, ipinangana ra yang manigpanapnay tung numyu ang ya ra yang pag̱aningen ang Cristong pinilik yang Dios ang maggaraemen tung numyu. Duun da ipinangana tung Betlehem ang ya kay pinanganaan ang tukaw tung ni Adi David ang kinaampu na. ");
INSERT INTO tbk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Para mapruibaan ming matuud yang nag̱ipag̱aningung naa tung numyu, may mulang maita mi duun ang sinaw̱ed-saw̱eran ta mga gayg̱ay ang ya kag lulw̱ug tung sasang pasungan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Numanyan pagkatapus ta pagbitala yang angil, nainali rang inugpuan ta mga kaarumanan nang paneng ang pisan ang irigkit yang paglinya-linyaan nira, ang duun da ka mamansiliit tung langit. Pamagdayaw tung Dios ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Salamat! Nainabu ra yang sasang ikadengeg enged yang Dios duun tung kaabwat-abwatan. Ig yang pakaw̱utun na tung kaliw̱utan, puidi ra maulikan yang rilasyun yang mga tau tung Dios ang kumpurming magrisibi tung kaneeman na,” mag̱aning yang mga angil ang atiang namagdarayawen tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Taa numanyan, pagliit da yang mga angil ang atiang namagbalik da duun tung langit, naang mga manigpastur namag̱araning-aningan dang mag̱aning, “Amus ta ra, mangayita ra duun tung Betlehem ang para insapuen ta ra yang nainabung naang ipinakdek da yang Dios tung yaten,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Purisu namag̱apura rang namansiangay duun tung Betlehem ang pagkatapus nasagyapan da ka man nira ti Maria durua ni Jose. Pati yang mula naita ra ka nira ang asan ka man tung pasungan aglulw̱ug. ");
INSERT INTO tbk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Atiing pagkaita ra nira yang mulang atia, dayun dang namagbaw̱alitaen natetenged tung nagngel nira tung mga angil ang natetenged tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Purisu numanyan yang tanan ang nagkarabalita-w̱alitaan da, nangabereng da ta mupia natetenged tung ibinalita yang mga manigpastur ang atia. ");
INSERT INTO tbk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ug̱aring naang ti Mariang naa, pinagpaneem-neeman na ta maayen yang tanan ang atia ang ya ra kay ipinagkesen-kesen na tung isip na kung unu ra ilem ay pakaw̱utun na. ");
INSERT INTO tbk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Numanyan, yang mga manigpastur ang atia, namagbalik da ka tung mga kaayepan nira. Durung pagdarayawen nira tung Dios natetenged tung tanan ang atiang nagkaragngel nira kag nagkaraita nira ang ya ray nagkatunung pisan tung pinag̱aning yang angil tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Taa numanyan, kinaw̱ut da yang yawalung kaldaw ang iparanganaen tung mulang atia, ya ray uras ang ipagbuat ta tanda tung tinanguni na. Pagkatapus tia, dayun dang pinaaranan da yang ginikanan na tung ni Jesus. Ay ya ra kang lag̱i ay aran ang sinambit yang angil tung ni Maria ang ipaaran na tung anya atiing indi pa nag̱imatung na. ");
INSERT INTO tbk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Taa numanyan kinaw̱ut da yang uras ang ipagtuman nirang magkasawa yang sasang urdinansang ibinutwan ni Moises sigun tung sasang baw̱ay ang baklung nangana. Usuyun nira tia ug̱ud liw̱ianu rang magtuu tung Dios tung pagtuuan ang atiang pinakalusu duun tung Jerusalem. Kung unu pay magkatamang ipadasag nira duun, maning taa yang napabtang tung urdinansang atiang ipinakdul yang Dios tung nira: “Kung belag̱an duruang bilug ang kalapati, maskin duruang bilug ang ladeng mga butu pa.” Kapurisu numanyan tanirang magkasawa namansiangay ra ka man duun tung Jerusalem ang para mamagtuman da yang katuw̱ulan ang atia. Pati yang ana nira, ingkelan da ka nira duun ug̱ud iintriga ra ka nira dayun tung Dios. Ay may sasa kang katuw̱ulan yang Dios ang ubligadung tumanen da ka nira ang maning taa yang palaksu na: “Kung tinu pay mamlak tung tinanguni ni nanay na, kung lalii, yay dapat ang ipatug̱ay yang mga ginikanan na tung Dios ang para magamit na sigun tung planu na tung anya.” ");
INSERT INTO tbk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Taa numanyan, duun tung Jerusalem, may sasang maepet ang nag̱aranan tung ni Simeon. Bilug yang isip na tung Dios ig durug katinumanen tung mga katuw̱ulan yang Dios. Dispuis, durung pagpakbat na tung pinangakuan yang Dios ang tung uri ta kaldaw, yang nasyun nirang Israel, bawien na rang ipaltaw. Dispuis pa yang taung naa, nag̱apasanag̱an yang Espiritu Santo yang painu-inu na. ");
INSERT INTO tbk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Purisu may sasang ipinasanag na tung anya ang baklu ra unu mapatay tanya, kung nabilug̱an na ra yang pag̱aningen ang Cristong pinilik yang Dios ang magbawi. ");
INSERT INTO tbk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Naa pala tung uras dang atii, ti Simeon ang naa pinaisip da yang Espiritu Santo ang magpakled tung pagtuuan ang atiang pinakalusu. Atiing nabuay-w̱uay ra tung kakleran, asan da ka magpapakled yang ginikanan ni Jesus ang para mamagprisintar da yang ana nirang pangulu tung Dios ang katulad ka tung kinaug̱alian nirang mga Judio ang napabtang tung katuw̱ulan. ");
INSERT INTO tbk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Numanyan pagkaita ni Simeon yang mula, diritsyu rang dinawat nang sinapupu, ang pagkatapus nag̱intra ra dayaw tung Dios ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Numanyan Yawi, ta yeen ang sasang turuw̱ulun mu, maskin tugtanaw ra nuyung pablag da ay malimeng da yang isipu. Tutal kindengan mu ra yang pangaku mu tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Kipurki sinakep da ta mataw yang Mananapnay. Pinagsimpan mu ang para tung ikaayen yang tanan ang mga nasyun yang kalibrian ang tukurun na. ");
INSERT INTO tbk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tanya maning pa tung sasang kaas ang yay magparasanag̱en tung mga kinaisipan yang mga tag̱a duma-rumang nasyun ug̱ud matultulana ra ka nira ig ya ra kay magpakdul ta kadengeg̱an tung nasyun yamen ang naang Israel ang ya ray mga tauan mung sadili,” ag̱aaning ti Simeon ang nagdarayawen tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Numanyan, yang ginikanan yang mula, nangabereng da ta mupia tung inaning ang atia ni Simeon natetenged tung ana nira. ");
INSERT INTO tbk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Numanyan nag̱ampu ra yang maepet ang tanirang sam pamilya pakaayenen yang Dios ta mupia. Pagkatapus, dayun da kang nagbugnu tung ni Maria ang mag̱aning, “Teed mu, yang ana mung atia, pinilik yang Dios ang yay pagbelag̱anan ta kinasipan may kinaisipan yang tanan ang mga masigkanasyun tang mga Israel. Ay natetenged tung pagpabetang nira tung anya, dakele ra yang magkaralambeg tung kadiaduan ig dakele ra ka yang magkaratapnay. Tanya maning pa tung sasang pruiba ang ipaita yang Dios ang pagkatapus ya pa kay kuntraen ta kadaklan. ");
INSERT INTO tbk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Purisu ta yawa, maning pa tung asan da nga saksakay ta matarem yang pupusukun mu. Pinilik man nganing yang Dios yang ana mung magkamaningan da ta maning tia ay ug̱ud yang laksu yang pag̱irisipen yang tanan ang mga taung taluk pa rin, duun da ngalw̱away,” ag̱aaning duun yang maepet. ");
INSERT INTO tbk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Taa simanyan, may sasang baw̱ay ang nag̱aranan tung ni Anna ang duun da ka nga sakpay tung uras ang atii. Tanya sasang manigpalatay yang bitala yang Dios ang yay nag̱ipasanag na tung painu-inu na. Yang tatay na ti Fanuel ang sasang kanubli ni Aser. Yang baw̱ay ang naa, masyadu ra yang pagkamaepet na. Ay pag̱idaran da ta walung puluk may epat ang takun. Dispuis, tung tantung kabuay ra yang ibaraluen na, ay pitung takun ilem yang pagkasawa nirang magkasawa pagkatapus nabalu ra. Taa numanyan yang ug̱ali yang baw̱ay ang naa, muya-muyang pagpakled tung pagtuuan ang atia ang para magtuu tung Dios maskin kaldaw maskin law̱ii. Tung pagturuuen na tung Dios duun, pirming pag̱ampu ang kung kaisan, pelek yang pagparanganen na natetenged tung kadererepen nang pag̱ampu. ");
INSERT INTO tbk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Taa numanyan tung uras ang atiing pagkaprisintar nira tung ni Jesus, lumimput da yang maepet ang naang baw̱ay ang nagpalenget tung nira. Pagkaita na yang mula, ya ray pinasalamatan nang dinayaw tung Dios natetenged yang nag̱aelatan na kuminaw̱ut da. Mag̱impisa tung kaldaw ang atii nag̱intra ra baw̱alitaen natetenged tung mulang atiing naita na tung kumpurming pagpakbat tung pag̱aningen ang Cristong magpalibri tung nasyun nirang Israel. ");
INSERT INTO tbk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Taa numanyan pagtuman yang ginikanan yang mula yang tanan ang atiang napabtang tung katuw̱ulan yang Dios, namansiulik da tanirang sam pamilya duun tung Nazaret ang lug̱ud tung sinakepan yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yang mula tanya sigi-sigi yang pagdakul na. Pati yang pag̱irisipen na, pagdakul da kang pagdakul ang asta nagwayang ang pisan yang pag̱irintindien na. Ay tanya nag̱apadag̱en-dag̱enan ta mupia yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taa numanyan yang ug̱ali yang mga ginikanan ni Jesus, takun-takun pansiangay duun tung Jerusalem ang para mamagpasakep tung pistang pag̱aningen ang Taklib. ");
INSERT INTO tbk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kapurisu atiing ti Jesus pag̱idaran da ta sam puluk may duruang takun, sigun tung ug̱ali nirang atia, namanungul-tungul da tanira duun tung Jerusalem ang para mamagpasakep tung pistang atia. ");
INSERT INTO tbk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Atiing tapus da yang pista, namag̱urulikan da yang mga tau. Piru yang mula tanya, nagpabutwan da ilem duun tung Jerusalem ang indi ilem nangaske yang ginikanan na. ");
INSERT INTO tbk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kanisip nira takaa ka ilem tung mga kaarumanan nirang pamagpaluyug. Purisu sigi ra ilem yang pagparanawen nira ang asta naapunan da ilem. Atiing apun dang pisan ang namagtadeng da tanirang sam paluyug̱an, baklu pa ngainsapuay nira yang mula kung asan tung may mga kaampiran tung nira ubin tung mga kailala nira. ");
INSERT INTO tbk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tay kumus indi nira naita, pangayag yang kaliw̱utan, diritsyu sing nansibalik duun tung Jerusalem ang para mamagdilem tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tung yaklung kaldaw, baklu pa nga sagyapay nira yang mula duun tung pagtuuan ang atiang pinakalusu. Yag kakarung asan tung kakngaan yang mga manigtulduk ang pamati tung nirang pamagkeresen natetenged tung pag̱irintindien nira tung Dios. Ang kaisan may nag̱atalimaan na ka tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yang kumpurming nagngel tung anya, nabereng da ta duru natetenged tung isip nang durug tarem ig tung nag̱ipanuw̱al nang asintadu tung nag̱ipanalimaan nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Numanyan, atiing pagkaita yang mga ginikanan na tung anya, nangabereng dang pisan tung anya. Purisu ti nanay na dayun dang nagbasul tung anya ang mag̱aning, “Duduy, ayw̱a binuatanami ra nuyu ta maning tia? Duru rag kaaburidu yang mga kulu yamen ni ama mung pinapagsagyapami nuyu ang aria ra ilem agbebtang!” ");
INSERT INTO tbk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mag̱aning ka ti Jesus ang tuminuw̱al, “Ayw̱a nanay, indi mi naskean ang ariaw pa sagyapay mi? Indi mi pala siguru naintindian ang kung ay pay pagkeresenan yang nag̱adapat tung ni Ama, kaministiran ang duunaw ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piru indi ra namaresmesan nira ta mupia kung unu pay linagpakan yang itinuw̱al nang atia. ");
INSERT INTO tbk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Taa numanyan ti Jesus nagpakignunut da ilem tung nirang namanuldak-tuldak duun tung Nazaret. Ay maskin unu pang bag̱ayay mapinanangeren tung ginikanan na. Piru naang ti nanay na, yang tanan ang atiang nainabu, luw̱us ang nag̱ipagkesen-kesen na tung isip na. ");
INSERT INTO tbk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Numanyan, mintras pagdakul da ti Jesus, pagwayang da ka yang pag̱irintindien na. Ig mintras nag̱abuay rang nag̱abuay, mas pang nag̱auyunan ang nag̱auyunan yang Dios pati yang mga masigkatau na. ");
INSERT INTO tbk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taa numanyan, ilakted ta ra kanay tung kapanawan ni Juan ang atiang ana ni Zacarias. Atiing duun dag pagpaluyu-luyu tung banwang atiing palag-palag yang tau na, duun da intrigaay yang Dios yang bitala na ang nunut da ka ta pagpaktel na ang para simpan dang magparakaw̱utun tung mga tau. Yang uras dang atii, ya taa yang mga taung pamangatengdanan. Yang pinakalandaw ang adi ang paggaem tung intirung sinakepan yang nasyun ang Roma, ya ra ti Adi Tiberio. Tung uras ang atii, pagpanaw ra ta sam puluk may limang takun yang paggaraemen na. Yang gubirnadur duun tung Judea, ya ra ti Poncio Pilato. Yang gubirnadur tung Galilea, ya ra ti Herodes. Yang gubirnadur tung Iturea may tung Traconite, ya ra ti Felipe ang putul ni Herodes. Yang gubirnadur tung Abilinia, ya ra ti Lisanias. Dispuis duun tung Jerusalem, yang mga paring pinakalandaw ta katengdanan ya ra ti Anas duruang magminag̱ad ni Caifas. ");
INSERT INTO tbk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Purisu numanyan ti Juan ang naa, kumus pag̱atuw̱ul da yang Dios, anday duma, nandanek da duun tung kakunayungan yang subang pag̱aningen nirang Jordan. Nagparakaw̱utun da tung mga taung pamag̱arangayan tung anyang mag̱aning, “Kaministiran manlignaamu ra tung mga kasalanan ming magbalik tung Dios ang pagkatapus ya ra kay papruibaan ming magpabenyag ang para patawarenamu ra anya,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Naang pagparakaw̱utun ni Juan ang maning tia, naula kang lag̱i ni Isaias ang sasang manigpalatay yang bitala yang Dios ang tukaw ang mag̱aning, “May sasang taung magparakaw̱utun tung mga tau duun tung banwang kapas ta maning taa: ‘Katulad ka tung pagsirimpanen tung sasang dalan ang panawan ta sasang Adi ang yag tadlengay, kaministiran kang simpanen mi ra ka ta mupiang tadlengen yang mga kinaisipan mi ang para magpauyunamu ra tung ni Ginuu tang magkakaw̱ut da. ");
INSERT INTO tbk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Purisu kung ay pay nagdaleman, kaministiran ang yay panampekan. Kung ay pay napabukid u napabukatud, kaministiran kang yay pamantag̱en. Kung ay pay napakilu, kaministiran kang yay panadlengen. Kung ay pay napalebeng-lebeng, kaministiran kang yay pamantayen ang asta magdalanu. ");
INSERT INTO tbk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kumpurming tinu pay magsimpan yang isip na ta maning tia, anday dumang mabilug̱an na, ya ra yang kalibrian ang pag̱iparawat yang Dios tung anya,’ mag̱aning.” Atia yay naula ni Isaias natetenged tung ni Juan ang naang nagparakaw̱utun. ");
INSERT INTO tbk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kapurisu simanyan duru-durung mga tau ang namagdarag̱umukan duun tung ni Juan ang para masigpabenyag da ka rin tung anya. Ang pagkatapus, ya ra ag̱aningay nang, “Yang kaalimbawaan mi maningamu ra ilem tung mga iraw ang pamagpalibri tung kirib ang nag̱asiruk. Tinu pa kayay nagpaetad tung numyu ang basta magpabenyag̱amu ra ilem, indiamu ra sakpen yang sintinsiang ipadangat yang Dios? Talagang belag̱an yuu. ");
INSERT INTO tbk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kaministiran bakluamu ra nga benyag̱ayu kung may pruibang ipinaita mi ra tung mga ubra-ubra mi ang talagang panlignaamu ra ka man ang matuud tung mga kasalanan mi. Muya maglaumamu ra ilem ang kumus yamu mga kanubli ni Abraham, indiamu ra sakpen yang sintinsia ang atia. Uay, maski nganing yang mga batung atia, iugtulu tung numyu, sarangan ang papag̱ingtauen yang Dios ang para buaten nang mga kanubli ni Abraham. ");
INSERT INTO tbk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yang sintinsia nang atia, maskin nganing simanyan, yang kaalimbawaan na, maning pa tung parakul ang nabiw̱at dang ipatpa ra ilem tung kapungul yang sasang ayu. Kumpurming unu pang ayuay ang belag̱an matinlu yang burak na, ya ray pelaren ang sirukun tung apuy,” mag̱aning ti Juan tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Atii muya-muyang mamagtalimaan yang mga tau tung anya ang mag̱aning, “Tay kung maning tii yang bitala mu, unu pa w̱asu ay dapat ang buaten yamen ang para indiami ka magkamaningan?” ");
INSERT INTO tbk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mag̱aning ti Juan ang nagtimales, “Maning taa yang dapat ang buaten mi. Kung tinu pay nagduruay lambung na, yang sam bilug itunggal na tung aruman nang anday lambung na. Kung tinu pay may pamangan, kaministiran mamarti tung aruman nang andang pisan ay mapangan na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Taa numanyan, may mga tau asan ang pamamati ang yang pangabui nira mga manigpanukut ta mga balayaran tung gubirnu. Yang inangay nira asan, mampabenyag da ka rin tung ni Juan. Ya si kay namagtalimaan tung anyang mag̱aning, “Ay yami w̱asu, Ameey, unu pay dapat ang buaten yamen?” ");
INSERT INTO tbk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mag̱aning ka ti Juan ang nagtimales, “Indi mi ra pagsukutun yang mga taung subra ra tung urdinansang ipinakdul tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Taa numanyan may mga sundalu ka asan ang pamamati ang ya si kay namagdasun ang namagtalimaan tung anyang mag̱aning, “Maskin yami pa rin, kung puidiami ka rin nuyung mapainunukuan, unu pa w̱asu ay dapat ang buaten yamen ang para indiami ka magkamaningan ang katulad ka tung inaning mu nungayna?” Mag̱aning ti Juan ang minles, “Tabtaw̱en mi ra atiang panlepes mi tung mga tau ang yang duma ya rag paleg̱ay mi ang para mamakdul ta kuarta tung numyu, ang yang duma kung indi mamakdul, ya ra ileg dataay mi ta kasalanan ang para ipakaw̱ut tung abwat. Dispuis yang magkatama, kumpurmi ra ilem yang nag̱isuildu tung numyu, ya ra ilem ay pasalamatan ming risibien,” mag̱aning ti Juan tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Taa numanyan, yang pinakaw̱ut yang pagparakaw̱utun ni Juan ta maning tia, ya ray pinanlatayan yang mga isip yang mga tau tung pag̱aningen ang Cristo ang ya kang lag̱i ay pag̱aelatan nira. Ti Juan ya ray nag̱apagkesen-kesenan yang mga isip nira kung nusias ya ra. ");
INSERT INTO tbk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Purisu inag̱apan ang lag̱i ni Juan yang mga paglaum nirang maning tii ang inaning, “Tung bag̱ay may katengdananu ka man ang magpamenyag tung numyu taa tung waing naa. Piru may sasang taung nag̱auri pa tung yeen ang mas abwat ta katengdanan tung yeen. Indiaw ang pisan magkabag̱ay tung anya, basin nganing tung pag̱uw̱ad da ilem yang lakgeng yang sandalyas na. Yang anyang katengdanan maning pa tung magberenyag̱en ka tung numyu ekel tung pagpatinir na tung numyu yang Espiritu Santo u kung indi, apuy ra yang gamiten na. ");
INSERT INTO tbk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yang kaalimbawaan na, maning pa tung sasang taung pag̱ekel ta linung magkaap yang paray ang gineyek na. Yang timlat ya ray ipabtang na tung tambuw̱u na. Piru yang kaap ya ray pagkalan na ta apuy ang anda enged ay kapugdaw-pugdawan na,” ag̱aaning duun ti Juan. ");
INSERT INTO tbk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kapurisu tung pagparakaw̱utun ni Juan yang matinlung balita tung mga tau natetenged tung pag̱aningen ang Cristo, sari-saring papanaw nang nagpaktel tung mga isip nirang mamananged da. ");
INSERT INTO tbk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Maski ti Herodes ang atiang Gubirnadur tung Galilea, tung kauri-urian da yang pagparakaw̱utun ni Juan, pinaintindi na ka natetenged tung kasalanan nang nangasawa tung ni Herodias ang ya ra rin ay kasawa yang putul nang ti Felipe. Pati yang kadaklan ang nagkarabuat-buat yang Gubirnadur ang mga malalain tung pagterelengen yang Dios, ya kay ipinatalunga ni Juan tung anyang ipinagpaaman. ");
INSERT INTO tbk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ang pagkatapus ti Herodes ang atia, inunung mas pang nagdulang yang kasalanan na, ang ti Juan ya ra ipakalabusay na. ");
INSERT INTO tbk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Taa numanyan, balikan ta ra kanay yang kapanawan ni Juan ang indi pa rin nag̱akalabus. Atiing duru-durung mga taung namampabenyag da tung anya, pati ti Jesus nagpabenyag da ka. Pagkatapus ta pagpabenyag na, dayun dang nag̱ampu. Mintras pag̱arampuen, yang langit maning pa tung inaling nag̱abri ra ang duun da manliit yang Espiritu Santo. Diritsyung nagparanek ang nangapun tung ni Jesus ang napapariu ra tung kuari kalapati. Pagkatapus may busis dang nagngel ang liit tung langit ang mag̱aning, “Yaway pag̱aningenung anaw ang nag̱apabuyukanu ta gegmaw ay yawa ra kang lag̱i ay nag̱auyunanu ta mupia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Naa ti Jesus, atiing pagpabenyag na ang ya ra kay paglua na tung mga tau, yang idad na mga tulung puluk dang takun. Yang pagterelengen yang mga tau tung anya, tanya unu ana ni Jose. Piru kung usu-usuen ta yang pinanliit-liitan na, duun da impisaay ta tung apu na ang yay ama ni nanay nang nag̱aranan tung ni Eli. ");
INSERT INTO tbk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Kung ya ipabalikay tang pag̱usu-usu tung mga ginikanan nirang nagdarasun-dasun ya ra taa yang listaan yang mga aran nira. Ti Eli, ti Matat, ti Levi, ti Melqui, ti Jana, ti Jose, ti Matatias, ti Amos, ti Nahum, ti Esli, ti Nagai, ti Mahat, ti Matatias, ti Simi, ti Josek, ti Juda, ti Yohanan, ti Resa, ti Zorobabel, ti Sealtiel, ti Neri, ti Melqui, ti Adi, ti Cosam, ti Elmadam, ti Er, ti Josue, ti Eliezer, ti Jorim, ti Matat, ti Levi, ti Simeon, ti Juda, ti Jose, ti Jonan, ti Eliakim, ti Melea, ti Mena, ti Matata, ti Natan, ti Adi David, ti Jesse, ti Obed, ti Boaz, ti Salmon, ti Naason, ti Aminadab, ti Admin, ti Arni, ti Hesron, ti Perez, ti Juda, ti Jacob, ti Isaac, ti Abraham, ti Tera, ti Nahor, ti Serug, ti Reu, ti Peleg, ti Eber, ti Sela, ti Cainan, ti Arpaksad, ti Sem, ti Noe, ti Lamek, ti Metusela, ti Enoc, ti Jared, ti Cainan, ti Enos, ti Set, may ti Adan mismu ang yay primirung taung inimu yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Taa numanyan, ti Jesus atiing pagpabenyag na duun tung subang atiang pag̱aningen ang Jordan, kumus nag̱amanguluan da yang Espiritu Santo, nagliit da duun ang para mulik da tung banwa na. Atiing mag̱ulik da rin, ingkelan da yang Espiritu Santong ipinaski duun tung banwang palag-palag yang tau na. ");
INSERT INTO tbk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Atiing duun da, pinalengtan da ni Satanas ang pinag̱intraan na tuksu tung seled epat ang puluk ang kaldaw. Numanyan tung mga uras ang atii, ti Jesus andang pisan ay pangan-pangan. Purisu atiing patapus-tapusun da yang mga kaldaw ang atii, duru rang kasusubkun na. ");
INSERT INTO tbk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mag̱aning ti Satanas tung anya, “Ta, kung matuud ang yawa ka man yang pag̱aningen ang Ana Yang Dios, abir, lalangan mu ra kanay yang batung atiang magyari rang tinapay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mag̱aning ka ti Jesus ang nagtuw̱al, “Aa, indiaw, kipurki may bitala yang Dios ang napabtang tung kasulatan ang belag̱an ilem unu pamangan ay impurtaen yang sasang tau ang para ikalayun na.” ");
INSERT INTO tbk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatapus, dayun dang ingkelan ni Satanas duun tung rugal ang durug kaabwat. Ipinaita na tung anyang kinalitan yang tanan ang inadian tung bilug ang kaliw̱utan. ");
INSERT INTO tbk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mag̱aning ti Satanas tung anya, “Yawa ray papgesenu ta kagaeman mu tung tanan ang atiang nag̱aita mung durug katitinlu. Kipurki tia, luw̱us dang ipinag̱intriga tung yeen. Purisu numanyan puiding ipakdulu tung kumpurming tinu pay nag̱alelyag̱anu. ");
INSERT INTO tbk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Purisu baskin yawa, basta magtuua ilem tung yeen, ipakdulu ra tung nuyu yang tanan ang atia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mag̱aning ti Jesus ang nagtimales “Aa, indiaw, kipurki may bitala tung kasulatan ang anda unu ay dumang luuranung tuuan, kung indi, ultimu ra ilem ti Yawi ang yay Dios ang may kalalangan tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Taa numanyan, dayun sing ingkelan ni Satanas duun tung Jerusalem, duun enged tung sagpaw yang pagtuuan ang atiang pinakalusu. Mag̱aning tung anya, “Ta, kung matuud ang yawa ka man yang pag̱aningen ang Ana Yang Dios, abir, pabugsua ra kanay asan. ");
INSERT INTO tbk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kipurki may bitala yang Dios tung kasulatan ang patuw̱ulana unu anya tung mga angil nang pabantayan. ");
INSERT INTO tbk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Sarepena ka unu nira ug̱ud indi ka matigbak yang kakay mung tempa tung kabatuan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mag̱aning ti Jesus ang minles, “Indiaw, kipurki may dumang bitala tung kasulatan ang dapat unu indiaw magtag̱am ta ingaw̱us tung ni Yawi ang ya unu ay Dios ang may kalalangan tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kapurisu atiing nalw̱usan da ti Satanas ta taktika ang sarang gamiten na tung ni Jesus, pinaw̱aya-w̱ayaan na ra ilem kanay asan ang binutwanan ang asta may ketat na si. ");
INSERT INTO tbk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Taa numanyan, ti Jesus, nagpadayun da yang pagparanawen nang minulik duun tung Galilea. Pirming nag̱amanguluan yang Espiritu Santo ang yay pagpaktel ta mupia tung anyang pagpalua ta mga pruibang makabew̱ereng. Purisu indi ra ilem buay nagsarakmu ra yang balita natetenged tung anya duun tung banwang atii pati duun tung mga banwang kakunayungan na. ");
INSERT INTO tbk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sigi-sigi ka yang pagparakaw̱utun na yang bitala yang Dios tung mga tau ang pamagsaragpun-sagpun tung nira-nirang mga balay ang pagsaragpunan. Anday dumang dinangat na durung pagdarayawen nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pira pang kaldaw minangay ra ti Jesus duun tung Nazaret ang yay banwang pinagdakulan na. Pagkaw̱ut yang kaldaw ang nag̱ipamaenay, nagpakiglaket da duun tung pagsaragpunan nira ay ya ra kang lag̱i ay ug̱ali na. Numanyan dayun dang kumindeng asan tung parada ang para magbasa tung nira yang bitala yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Anday dumang ipinarawat tung anyang basaen, ya ra yang isinulat ni Isaias ang sasang manigpalatay yang bitala yang Dios atiing tukaw. Taa numanyan, anday duma, dayun na rang sinulw̱aran yang kasulatan ang atiang yag lululun ang asta nasagyapan na yang sam bulus ang gustu nang basaen ang maning taa yang napabtang: ");
INSERT INTO tbk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yang Espiritu Santong ipinagpatinir da ni Yawi tung yeen, ya ray pagmangulu tung yeen ang pagpaktel. Ay yuu ra kang lag̱i ay pinilik ni Yawing magparakaw̱utun yang Matinlung Balita tung mga taung aranek ta pagkabetang ang simpan da ti Yawing magtaw̱ang tung nira. Tinuw̱ulaw ra ka anyang magpasanag tung mga taung nag̱akemkem ta mga tau ang tanira ipampaluas da ni Yawi tung kumpurming unu pay pagpakemkeman nira. Pati mga buray, paintindienu ra ka ang tanira pamuskaren da ni Yawi yang mga mata nira. Pati yang mga taung nag̱adegdeg̱an ta duma, pasanag̱anu ra ka ang tanira ipampalibri ra ni Yawi. ");
INSERT INTO tbk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bilang tinuw̱ulaw ra anyang magbandilyu tung tanan ang mga tau ang kuminaw̱ut da yang uras ipagpaita ni Yawi yang kaneenman na tung nira,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Numanyan, pagkatapus ta pagbasa na, dayun na rang linulun yang kasulatan ang atiang ibinalik tung manig̱epet. Pagkatapus, kuminarung da ilem asan ang para magturuldukanen da tung mga tau. Yang mga mata nirang tanan, maninga isinamwag da tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Numanyan dayun dang nagbitala tung nirang mag̱aning, “Numaan ang kaldaw ang naa, mintras pamatiamu tung yeen ang pagparakaw̱utun, nag̱aimpisaanu rang agmatuurun yang naulang atiang baklung binasaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Numanyan yang mga taung atiang pamamati, pinaninluan dang namagdarayawen tung anya, ay naberengan nira ta mupia yang kinatakwanan nang pametang-betang ta mga bitala. Ug̱aring ang naisip da nira yang linagpakan na, unaw̱is pinaninekan da. Dayun dang namag̱araning-aningan ang mag̱aning, “Belag bang yang taung naa ana ni Jose? Ayw̱a, tanyang sasang masigkatau ta ka ilem mag̱ambu pa ta maning tia?” ");
INSERT INTO tbk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Atii dayun dang nagtimales ti Jesus ang mag̱aning, “Muya pasulitanaw pa numyu yang sasang sarabyen ang yang sasa unung manigbulung, dapat unu ang yang tukawen nang pamaayenen, ya ra unu yang sadili na mismu. Muya aningenaw ka numyu ang yang mga pruibang atiang makabew̱ereng ang nabalitaan ming ipinagpaluaw duun tung Capernaum, dapat taa si kay ipalapusayu tung sadiling banwaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pagkatapus dayun na rang sinugpatan yang bitala nang mag̱aning, “Iugtulu tung numyu yang kamatuuran, anday manigpalatay yang bitala yang Dios ang nag̱agalang tung sadiling banwa na. ");
INSERT INTO tbk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Isipen mi ra ilem ta maayen yang ipademdemung naa tung numyu kung indi magkatirnung pisan tung numyu. Atiing panimpu pa ni Elias atiing inding pisan pinakuran yang Dios yang banwang naa tung seled tulung takun may tenga ang puirti ra yang panuw̱uk ang kuminaw̱ut tung intirung banwa tang naang Israel, duru kang mga balung mga baw̱ay ang nagkaraliwag̱an ta duru. ");
INSERT INTO tbk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ang pagkatapus andang pisan ay pinatuw̱ulan ni Yawi tung ni Elias ang taw̱angan, kung indi, suluminti ilem yang sasang balung baw̱ay ang belag̱an ka pa man masigka Judio nira ang pagtinir tung lansangan ang Sarepta duun tung sinakepan yang Sidon, ya pay pinatuw̱ulan na tung anyang tabnuyun. ");
INSERT INTO tbk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dispuis pa atiing panimpu ni Eliseo duru kang mga taung may dispirinsia nirang makamamansa tung mga ulit nira taa tung banwa tang naang Israel, ang pagkatapus, anday kinuatan na ta dispirinsia nirang atia, kung indi, suluminti ilem ti Naaman ang tag̱a Siriang belag̱an ka pa man masigka Judio na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Numanyan yang mga tau asan tung pagsaragpunan, pagkagngel da nira yang inaning ni Jesus ang atia, ang midyu tanira nag̱aliig-liig na, pinanungkukan da ta kasisilag̱en nirang duru tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Anday dumang binuat nira, diritsyu rang namagkererengan ang ipinagtulmun da nira ti Jesus duun tung lua yang lansangan. Duun da ideldelay nira tung palda yang bukid ang nabtangan yang lansangan nira ang para duun enged tung napatiplay na ilambeg̱ay nira. ");
INSERT INTO tbk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piru naa ti Jesus tanya, dayun da ilem ang nagbira ang duun da ilem tung nira naneyang-seyang ang asta pinamutwanan na ra ka ilem tanira. ");
INSERT INTO tbk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Taa numanyan, diritsyu rang nanuldak duun tung Capernaum ang sasa kang lansangan ang lug̱ud ka tung sinakepan yang Galilea. Pagkaw̱ut yang kaldaw ang nag̱ipamaenay, dayun dang nagturuldukanen tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pagkagngel nira, nangabereng ta mupia tung pasais nang nagturuldukun tung nira. Ay ya pa ag̱ari, yang pagturuldukun na may builu nang maktel ang yay pagpailala ang tanya may katengdanan na ka man ang ipinakdul yang Dios tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Taa numanyan duun tung pagsaragpunan ang atii, may taung agdimunyuen ang ya ray naglelpaken ta mupia ang mag̱aning, ");
INSERT INTO tbk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aay, Jesus ang tag̱a Nazaret, ayw̱a ag̱apasilabtanami pa nuyu? Ayw̱a, yaming mga dimunyu yay katuyuan mu taa ang para diaduenami ra nuyu? Sampa india mailalaw? Yawa yang pinilik yang Dios ang magpundar yang paggaraemen nang baklu!” ");
INSERT INTO tbk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Atii, dayun dang sinambeng ni Jesus ang inaning, “Ipes! Maglayasa ra ilem asan.” Atii, yang dimunyu dayun na rang ibinegsak yang taung atia asan tung pinagtaralungaan nira na Jesus, baklu nagliit tung anya. Piru indi ka natigbak yang tau, ag̱ad ibinegsak na pa. ");
INSERT INTO tbk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pagkaita yang mga tau, nangabereng da tanirang tanan. Namag̱araning-aningan dang mag̱aning, “Unu pang kalalanganay tia? May katengdanan na palang magpalayas tung mga dimunyu. Sam pabitala na ilem, paglayas dang lag̱i!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kapurisu yang balita natetenged tung binuat ni Jesus ang atia, indi nabuay-w̱uay ang nanlakted-lakted tung mga banwang atiang kakunayungan yang Capernaum. ");
INSERT INTO tbk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Taa numanyan, atiing pagliit ni Jesus tung pagsaragpunan ang atii, minangay ra duun tung balay ni Simon. Pagkatapus ya ray natakwalan na yang punyangan nang baw̱ay ang pagkiniten ta duru. Purisu numanyan anday duma, ya ray ipinataw̱ang nira tung anya ang para pamaayenen na. ");
INSERT INTO tbk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Purisu pagpalenget na, pagsurung na, diritsyung nagkalalangan dang “Magliita ra asan ang kinita.” Pagkatapus lag̱i-lag̱ing naumpawan da yang maepet. Pagkaumpaw na, atiang lag̱i nagbangun dang nag̱asikasu tung mga bisita na. ");
INSERT INTO tbk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Taa numanyan, atiing pagsantek da yang kaldaw, yang tanan ang mga taung pamaglaru ta sari-sari, ipinampadangep da asan tung ni Jesus yang mga aruman nira. Pagkatapus, anday dumang binuat ni Jesus, pinandeen-deenan na sasa may sasa ang pinampamaayen. ");
INSERT INTO tbk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dakele kang mga taung pinampalayasan na tung mga dimunyu. Kung maglayas da nganing, maglelpaken dang mag̱aning, “Yawa pala yang pag̱aningen ang Ana Yang Dios!” mag̱aning. Namagbitala ta maning tia ay natetenged nag̱askean da nira ang ti Jesus ya ra yang pinilik yang Dios ang magpundar yang baklung paggaraemen na tung bilug ang kaliw̱utan. Piru indi na ra tinugtan ang magbaw̱alitaen natetenged tung katengdanan na, kung indi, sinambeng na rang lag̱i ang inampalar. ");
INSERT INTO tbk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Taa numanyan atiing paminag-binag da yang kaliw̱utan, luminua ti Jesus tung lansangan ang nagpaag̱es duun tung lugar ang anday tatau na. Numanyan anday dumang binuat yang mga tau, namagsagyap da tung anya ang asta naita ra nira. Atiing pagkasagyap da nira, tinag̱aman da rin nirang inawiran ang indi ra ka magliit duun tung banwa nira. ");
INSERT INTO tbk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piru mag̱aning ti Jesus ang nagtimales tung nira, “Kaministiran mangayaw ra ka tung dumang mga lansangan ug̱ud magparakaw̱utunaw ra ka tung mga tau yang sasang matinlung balita ang yang Dios mag̱impisa rang magtukud yang paggaraemen nang baklu tung mga tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kapurisu numanyan nagliliw̱utun da ka man ti Jesus tung intirung sinakepan yang Judea. Nagparakaw̱utun tung mga tau ang kada mamagsaragpun tung nira nirang balay ang pagsaragpunan. ");
INSERT INTO tbk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Taa numanyan, may dumang kaldaw ang ti Jesus yag kekdeng tung binit yang aw̱uyuk ang atiang pag̱aningen ang Genesaret. Durug dakel yang mga tau ang pamagsereksekan ang pamagpalenget tung anya ang para mabilug̱an nira yang bitala yang Dios ang nag̱ipagpakaw̱ut na. ");
INSERT INTO tbk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Numanyan may naita nang durua nga balangayan ang yag sasanglad asan tung bakayan. Ay yang mga manig̱ian, namansilampud da ang para mamamunlaw yang mga lambat nira. ");
INSERT INTO tbk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Purisu anday dumang binuat ni Jesus, dayun dang nagsaay tung sam bilug ang balangay ang yay balangay ni Simon. Pagkatapus, dayun na rang inaning, “Ungkuy, itulud mu ra kanay taning balangay mu ang ipaabwat-abwat ta gesye tung bakayan.” Pagkatapus, asan da tung abwat-abwat, dayun dang kuminarung tung balangay ay magpadayun da yang pagparakaw̱utun na tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Taa numanyan pagkatapus na ta pagbitala, dayun dang nagkalalangan tung ni Simon ang mag̱aning, “Ala, magsaayita ra kanay ang pakbi. Ipataktak mu si yang mga lambat ug̱ud maekelamu ta ian,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mag̱aning ka ti Simon ang nagtuw̱al, “Ameey, nagdamal yang bedlay yamen ang nagpapuyat. Andang pisan ay naeklan yamen may sam bilug. Piru kumus yaway pagkalalangan, ipataktaku ra ilem ug̱ud,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Taa numanyan dayun da ka man ang namansisaay tung balangay ang namagpakbi. Pagkatapus dayun da kang namanaktak yang mga lambat nira. Numanyan pagguyud nira yang mga lambat, ya ray nasapulan nira yang mga ian ang paneng. Sam puntu ilem nagkarabakbak yang mga lambat natetenged tung kadaramelen yang mga ian. ");
INSERT INTO tbk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Purisu anday duma, dayun dang linambayan nira yang mga aruman nira tung sam bilug ang balangay asan pa tung bakayan ang para mamagtaw̱ang. Purisu pagkaw̱ut yang mga aruman nira, tinaraw̱angan da nira yang mga ian ang asta napnuk da yang durua nga balangayan ang sam puntu ra ilem mansitegdang. ");
INSERT INTO tbk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkaita ni Simon Pedro tia, anday dumang binuat na, ya ra ngalw̱u tung tuud ni Jesus ang luminuud ang mag̱aning ang pagbitala, “Ay Ginuu, maayen pang pablag̱a ra ilem taa tung yeen. Indiaw magkabag̱ay tung nuyu, ay yuu telew̱aw ang pisan ta kasalanan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Napagbitala ta maning tia, ay nabereng da ta mupia tung mga ian ang naeklan nirang duru. Pati yang mga aruman na tung balangay na, ya ka, nangabereng da ka. ");
INSERT INTO tbk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Asta na Santiago, durua ni Juan ang mga ana ni Zebedeo tung sam bilug kang balangay ang yay mga kabakas ni Simon, ya ka, nangabereng da ka ta duru tung nainabung atia. Taa numanyan pagkagngel ni Jesus yang inaning ni Pedrong atia tung anya, dayun dang nagpaktel tung isip na ang mag̱aning, “Simon, india magpaluw̱ay. Kipurki, mag̱impisa simanyan, belag da ian yang maeklan mu, kung indi, ya ra yang isip yang mga tau ang basi pa ra ilem mamansisuku ra ka tung yeen ang mamagpaugyat,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Taa numanyan, namamparanek da tung bakayan. Pagkasanglad, dayun da nirang binutwanan yang tanan ang mga bag̱ay ang para mamagpakignunut da tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Numanyan may dumang kaldaw ang ti Jesus duun tung sasang lansangan. May tau asan ang may dispirinsia tung ulit nang makamamansa ang leep da yang intirung tinanguni na. Pagkaita na tung ni Jesus, dayun dang nagluud tung pinagtalungaan nira ang nagpakiluuy tung anyang mag̱aning, “Ameey, kung malelyag̱a ilem, ag̱askeanung sarangan mung kuaten yang dispirinsiaung naa ang yay pagpamansa tung pagkatauu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pagkatapus ti Jesus, tanya, dayun dang nagdeen tung tinanguni na ang mag̱aning, “Ag̱alelyag̱aw ka, kuatana ra yeen,” mag̱aning. Pagkatapus lag̱i-lag̱ing nakuatan da ka man tung dispirinsia nang atia. ");
INSERT INTO tbk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atii nagkalalangan da ti Jesus tung anya ang mag̱aning, “Kuidaw, india ra enged magbaw̱alitaen baskin tung ninu pa natetenged tung binuatung atia tung nuyu. Anday dumang buaten mu, mangaya ra kanay duun tung sasang pari ang magpateleng ang yawa limpiu ra. Pagkatapus magpadasag̱a ra ka dayun tung anya ta sasang ayep ang iprisintar na tung Dios ang katulad ka tung sasang urdinansang ibinutwan ni Moises ang tukaw ug̱ud asan da nga kumpurmiay yang mga tau ang anda ray dapat ang likayan nira tung nuyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Piru naa pala, ang ay pa tiing sinambeng ni Jesus, duun da nagsarambung yang balita ang asta kuminaw̱ut da tung mga banwang alalawid. Kapurisu anday dumang dinangat na, nangiklep da ilem yang mga tau ang namagsaragpun ang para mamagpamati tung anya. Yang may mga laru tung nira, namagdangep da dayun tung anya ang para pamaayenen na. ");
INSERT INTO tbk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ug̱aring ti Jesus, kung kaisan, yang pag̱abuat na, pagpalikay-likay ang pagpaelak-elak duun tung banwang palag-palag yang tau na, ang para mabug̱us na yang isip na tung pag̱arampuen na. ");
INSERT INTO tbk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Taa numanyan may dumang kaldaw ang ti Jesus pagturuldukanen tung mga taung nagkarasagpun tung balay. May duun kang mga Pariseo ang kumarungan asan, kasiraan da ka tanira yang mga sag̱ad. Duun mamanliit tung maskin ay pang baryuay ang lug̱ud tung sinakepan yang Galilea pati Judea. Yang duma duun mamanliit tung siudad ang Jerusalem mismu. Taa numanyan ti Jesus nag̱apaktel da yang Dios ang para mapagpamaayen tung mga taung may mga masiit nira. ");
INSERT INTO tbk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naa pala may sasang taung namamilay ra yang mga tinanguni na ang ya ra ilem ag̱idangepay yang mga aruman na duun tung ni Jesus. Numanyan pagkaw̱ut nira duun tung balay, tinag̱aman da rin nirang ipakled ang para ipakaw̱ut tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piru indi ra ka enged nangaselsel ay natetenged yang balay getek ang pisan ta tau. Purisu anday dumang rimidyu ang binuat nira, namansitakwal da ilem duun tung aldan ang panganing tung sagpaw yang balay. Pagkatapus ya ray pinangukab nirang inabrian ang duun ka ipapanaway nirang ituntunay yang aruman nirang yag lulw̱ug tung papag ang asta nadasen da tung kakngaan yang pagtaralungaan na Jesus may yang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Numanyan pagkasiman ni Jesus ang tanira may pagtalig nira tung anya, dayun na rang binugnu yang aruman nirang paglaru ang inaning, “Putulu, nag̱apatawara ra yeen tung mga kasalanan mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Numanyan yang mga sag̱ad may yang mga Pariseo, pagkagngel nira yang inaning ni Jesus tung taung atia ang maning tii, ya ray ipinagkesen-kesen nira tung mga isip nira ang maning taa: “Abaa yang tau kang naa ka! Unu ray pagpabetang na tung sadili na ang yang pagkadios yang Dios ya rag pagtiwakaway na? Ayw̱a, tinu pa pay sarang ang magpatawad tung mga tau tung mga kasalanan nira kung belag̱an ultimu ilem yang Dios?” ");
INSERT INTO tbk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kumus nag̱adeep da ni Jesus kung unu pay palaksu yang mga pag̱irisipen nira, dayun na rang binugnu ang inaning, “Ayw̱at maning da tia yang nag̱ipagkesen-kesen mi tung mga isip mi? ");
INSERT INTO tbk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kanisip mi ang sungaw ra ilem yang inaningu tung taung naa ang pinatawaru ra tung mga kasalanan na? Piru kung aningenu si ang magbangun dang magpanaw, asan da ngaskeay mi kung yang bitalaw sungaw ra ilem u kung may kamatuuran na. ");
INSERT INTO tbk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Purisu papruibaanu ra numanyan tung numyu ang yuung pag̱aningen ang Maninga Tau, may katengdananu ka man taa tung katanekan ang magpatawad tung mga tau tung mga kasalanan nira,” mag̱aning. Pagkatapus diritsyu rang pinag̱aning na yang taung atiang pamamilay yang mga tinanguni na, “Ala, magbanguna ra. Eklan mu ra tiang lulubgan mung mulik,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pagkatapus yang taung atia, pagkagngel na yang inaning ni Jesus tung anya, lag̱i-lag̱ing nagbungkaras da tung pinagtaralungaan nirang tanan ang pagkatapus dayun na rang ingkelan yang limbug̱an nang minulik. Yang pag̱ulik na, ya kay pagdarayawen na tung Dios ta duru. ");
INSERT INTO tbk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Numanyan yang mga taung atiang nangaita, pinangampayan da ta pagkabereng nirang duru ang nunut da ka ta pagdarayawen nira tung Dios. Nangaimakluan da tanira tung pagterelengen nira tung ni Jesus natetenged tung binuat nang atia. Namag̱araning-aningan da, “Durung pisan agkabew̱ereng yang naita ta numaan ang kaldaw ang naa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapus tia, ti Jesus, dayun dang naglampud tung balay ang nagpanaw ang asta luminua ra tung lansangan. Duun may naita nang sasang manigpanukut ta mga balayaran tung gubirnu ang yay nag̱aranan tung ni Levi. Yag kakarung tung upisina nang pagpanukut tung mga tau. Mag̱aning ti Jesus ang nagbugnu tung anya, “Amus, magpakignunuta ra tung yeen ang magpaugyat,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Numanyan ti Leving naa, anday dumang binuat na, dayun dang kumindeng ang nagpakignunut tung ni Jesus. Andang pisan ay binalikid na, kung indi, luw̱us na rang binutwanan ang para tanya magpakignunut da tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pagkatapus ti Leving naa, anday dumang nabtang tung isip na, nagtukud da ta punsiun ang dakulu asan tung balay na ang para tung ni Jesus. Numanyan duru rang mga kaarumanan ni Leving mga manigpanukut asta yang duma pang mga tau ang namagpakigsaru ra ka tung na Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Numanyan atiing pamagsararu ra tanira, may mga Pariseo kang pamagpaniid, kasiraan da ka tanira yang mga kaarumanan nirang mga sag̱ad. Pamag̱istinggir tung mga taung pamagpaugyat tung ni Jesus ang mag̱aning, “Ba tia, ayw̱a asanamu rag pagpakigsaru tung mga manigpanukut ang atiang mga mandaraya may tung mga ugpu nirang atiang mga teleb ang pisan ta kasalanan?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Numanyan ti Jesus ya ray nagtuw̱al ang asan da ipapanaway na tung sasang pananglit ang mag̱aning, “Yang mga taung makektel anday kaministiran nira yang manigbulung, kung indi, ya ra ilem yang may mga laru. ");
INSERT INTO tbk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Katulad ka tung yeen, ay yang inangayung mag̱imbitaren belag̱an yang mga taung pagtalig tung sadili nira ang tanira maayen tung pagterelengen yang Dios, kung indi, ya ra ilem yang mga taung nag̱askean nira ang tanira talagang makinasalananen ka man ang para manligna ra tung mga kasalanan nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Taa numanyan may mga tau asan ang nagriklamu tung ni Jesus ang mag̱aning, “Yang mga taung nag̱apangugyatan ni Juan ang manigbenyag muya-muyang pamamlek tung pagparanganen nira ang nunut da ka ta pag̱arampuen nira, pati yami kang nag̱apangugyatan yang mga Pariseo ya kay nag̱usuyun yamen. Piru yang mga tauan mu pala, anda ra tung pag̱intindi nira yang riglamintung atia!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yang tuw̱al ni Jesus tung nira, yang sadili na ipinananglit na tung laliing pangasawa. Ag̱aaning tung nira, “Ayw̱a, kung may kumbira, kanisip mi ang yang mga laliing pamagkumpanya tung aruman nirang pangasawa, bag̱ay w̱asung ampalaren tung pagsararuan nira ang ya pag teparay nira yang aruman nira? ");
INSERT INTO tbk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ug̱aring may uras ang kaw̱utun ang yang aruman nirang atia lag̱unutun dang eklan tung tepad nira. Atia ya ray uras ang magkabag̱ay rang pisan ang ipamlek nira tung mga pagparanganen nira natetenged tung kapupungawen da nirang duru,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pagkatapus nagpananglit si ti Jesus ang mag̱aning, “Ayw̱a, tinu pay nag̱aintindian ming tau ang may aw̱el nang baklu ang ya pay lasiken nang pangkelan ta itambel na tung aw̱el nang lag̱i-lag̱i ra? Kipurki kung ya pay buaten na tia, belag̱an ilem ang marangga ra yang aw̱el nang baklu, kung indi, pati yang lag̱i-lag̱ing tinambelan na may yang baklung itinambel na, indi ra ka enged magtirnuan. ");
INSERT INTO tbk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Dispuis, tinu pay nag̱aintindian ming tau ang yang binung baklung ingkelan tung saralug̱an, asan da ilem papagbaalay na tung parabtangan ang lag̱i-lag̱i ra? Kipurki kung maning tia ya pay buaten na, kung mabaal da nganing tia, manleskag da yang parabtangan ang asta mablak. Anday duma, mailas da ka ilem yang binu, pati yang parabtangan, diadu ra ka. ");
INSERT INTO tbk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kung indi, yang dapat ang buaten, yang binung baklu asan da ibukbukay tung parabtangan ang baklu ka. ");
INSERT INTO tbk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dispuis pa, tinu pay nag̱aintindian ming tau ang malelyag pang manginem ta binung baklung sinaruk ang atiing naanad da tung binung baal da? Ay yang binung baal da yay pag̱aningen nang mas masabur. Pariung pisan tung mga taung anad da tung pag̱urusuyun tung dating nag̱apgesan nira. Indi ra ka malelyag ang mag̱usuy tung baklung sistimang naang nag̱itulduku,” ag̱aaning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Taa numanyan tung sasang kaldaw ang nag̱ipamaenay yang mga Judio tung pag̱urubraen nira, ti Jesus napanaw ra tung dalan ang naknga tung katriguan, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. Numanyan tung pagparanawen nira, ya kay aplut-aplut yang mga aruman na yang mga kaluay yang trigu ang nag̱akerekese tung palad nirang pag̱adekem. ");
INSERT INTO tbk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Numanyan may mga Pariseo asan ang ya ray namag̱istinggir tung nirang mag̱aning, “Ba tia, ayw̱at paglampasamu ra tung sasang urdinansa ta ang bawal ang mag̱urubraen ta maning tia tung kaldaw ang nag̱ipamaenay?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Numanyan anday dumang nagtuw̱al, ti Jesus. Mag̱aning tung nira, “Ayw̱a, indi mi pa ka enged nag̱amaresmesan yang sasang nabtang tung kasulatan natetenged tung binuat ni David atiing tanya duru rang suw̱uk na pati yang mga aruman na? ");
INSERT INTO tbk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Indi w̱a, nagpakled tanya duun tung balay-w̱alay ang atiing pinagtuuan pa rin yang mga tau tung Dios atii kanay ang pagkatapus yang tinapay ang atiing sagradu ang ipinabtang tung katalungaan yang Dios, ya pay pinisik nang pinangan ag̱ad bawal ang panganen ta duma ang belag̱an mga pari? Piru maskin bawal, ya pay pinangan na ig ipinapaan na pa ka nganing tung mga aruman na, piru indi ka ipinakusalak yang Dios tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Purisu yuung pag̱aningen ang Maninga Tau yuu ray pamala tung mga tauanu kung ya pa ag̱ari yang pagturumanen nira yang katuw̱ulan yang Dios natetenged tung kaldaw ang nag̱ipamaenay,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Taa numanyan, may duma sing kaldaw ang nag̱ipamaenay ang kuminaw̱ut si. Ti Jesus tanya, nagpakled da duun tung sasang pagsaragpunan nirang nagparakaw̱utun tung mga taung pamagsaragpun duun. Duun ka natagbu yang sasang taung napilayan da yang kalima nang tuu. ");
INSERT INTO tbk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","May mga Pariseo kag mga sag̱ad ang pamagpasakep ka. Nag̱apaniiran nira ta mupia ti Jesus kung magpamaayen tung kaldaw ang atiang nag̱ipamaenay, ug̱ud ya ray ipagpakusalak nira tung anyang ipagdimanda tung ustisia. ");
INSERT INTO tbk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piru ti Jesus, kumus naskean na rang lag̱i yang nabtang tung mga kinaisipan nira, purisu dayun dang nagkalalangan tung napilayan yang kalima nang mag̱aning, “Ala kemdenga ra kanay ang mangay tani tung parada,” mag̱aning. Numanyan kumindeng da ka man yang napilayan ang minangay asan tung parada. ");
INSERT INTO tbk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pagkatapus dayun dang nagbitala ti Jesus tung mga taung atiang pamagpaniid tung anya ang mag̱aning, “Yuu may talimaanenu ra rin tung numyu. Ay pa w̱asu ay magkatamang buaten tung kaldaw ang nag̱ipamaenay ang ita magbuat ta sasang ikaayen ta sasang masigkatau tang ilibri tung malain u ang ita magbuat ta sasang ikalain ta sasang masigkatau ta ang yay magakdan na ta ikadiadu yang pagkabetang na?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Numanyan pinaneleng-telengan ni Jesus tanirang tanan. Pagkatapus dayun na rang inaning yang napilayan ang, “Ala, iunat mu ra tiang kalima mu,” mag̱aning. Tamang tamang ag̱iunat na, naulikan dang pisan yang kalima na. ");
INSERT INTO tbk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Numanyan yang mga Pariseo, pagkaita nira tia, pinanungkukan da yang mga isip nira ta kasisilag̱en nirang subra tung ni Jesus. Purisu numanyan, dayun da nirang pinagkeresenan kung unyen pa nira. ");
INSERT INTO tbk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Taa numanyan, may pira pang kaldaw ang nagtaklib, ti Jesus nagpaelak-elak da duun tung kabukiran ang para mag̱arampuen da tung Dios. Nagdamal da duun tung pag̱arampuen na. ");
INSERT INTO tbk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Numanyan atiing kaldaw ra, yang mga taung nag̱apangugyatan na, ya ray pinaguuyan nang mamagpalenget tung anya. Pagkatapus ya ray pinamilikan na ta sam puluk may durua ang ya ray binuat nang mga taralig̱an na bilang yang pag̱aningen ang mga apustul na. ");
INSERT INTO tbk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ya taa yang mga aran nirang pinagpilik na. Ti Simon ang yay pinapuanggaan na tung ni Pedro, ti Andres ang ari ni Pedro, ti Santiago, ti Juan, ti Felipe, ti Bartolome, ");
INSERT INTO tbk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ti Mateo, ti Tomas, ti Santiagong atiang ana ni Alfeo, may ti Simon ang atiang sam bilug ang kinasakpan da rin yang sasang partidung durug iseg yang pagbaratukun nira tung gubirnu yang mga tag̱a Roma. ");
INSERT INTO tbk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Magdasun ya ra ti Judas ang atiang ana ni Santiagong sam bilug, may yang tukayu nang atiang sam bilug ang ti Judas Iscariote ang tung uri ya ra ka man ay nagyaring traidur tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Taa numanyan ti Jesus nagparanek da, kasiraan da ka yang baklung pinagpilik na. Mangalensad da nganing tanira tung datal, duun da ka kaw̱utay nira yang mga taung buntun. Yang duma nag̱apangugyatan na kang lag̱i, yang duma duun mamanliit tung baskin ay pang banwaay tung sakep yang Judea, ang yang duma duun mamanliit tung siudad mismu yang Jerusalem. May duma pang alalawid pa ka enged yang pinanliitan nira ang ya ra yang siudad yang Tiro may yang siudad yang Sidon, ang yay nabtang tung binit yang bakayan. ");
INSERT INTO tbk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yang inangay nirang tanan tung ni Jesus, ay gustu nirang mamagpamati tung anya ig tanira pamaayenen na tung mga laru nira. Ay may asan ka tung nirang pag̱aekel-ekelan ta mga dimunyu. Numanyan pagdangep nira tung anya, luw̱us dang pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dispuis tanirang tanan namag̱impurta ra ang basta madeen ilem tung anya. Kipurki may ketel ang pagliit tung tinanguni na ang ya ray pinagmaayenan nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pagkatapus numanyan, ti Jesus naneleng-teleng da tung mga taung nag̱apangugyatan nang atia ang mag̱aning tung nira, “Ta yamung kumpurming mga maliliwag̱en ang anda ray magtalig̱an mi tung mga sadili mi, teed mi tia agkatinlu yang nag̱abtangan mi! Ay yang nag̱ikatinlu na asan, lug̱uramu ra tung mga taung pamagpagaem tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ta yamung nag̱apasaran da ta pasuw̱uk numanyan natetenged ilem tung pagpakignunut mi tung yeen, teed mi tia agkatinlu yang nag̱abtangan mi. Ay sipurki tung uri maning pa tung pabialenamu ra yang Dios tung sasang kaayenan ang indi enged ang pisan mapasiring-siringan. Ta yamung nag̱ampayan da ta kapupungawen ming duru numanyan ang kung kaisan ya ray nag̱ipanangit mi, teed mi tia agkatinlu yang nag̱abtangan mi. Ay sipurki tung uri talagang yamu ray patalangkaken ka enged yang Dios natetenged tung kasadyaan ming duru. ");
INSERT INTO tbk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dispuis, kung alimbawa, pakulainenamu yang mga masigkatau mi natetenged tung pagkererengen mi tung yeen ang pag̱aningen ang Maninga Tau, kung ya ra kay indi ipagsapet nira tung numyu, ubin ya ra kay ipag̱insultu nira tung numyu ang yamu kaskasen da nirang mag̱ing malain tung pagterelengen nira, tay tia duru rag tinlu yang mabtangan mi. ");
INSERT INTO tbk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Purisu kung buatanamu ra nganing nira ta maning tia, magpakasadyaamu enged ang yamu ag̱alikting-likting. Yang ikasadya mi asan ay natetenged asan da nga pruibaay ang may ibles ka man yang Dios tung numyung durung pisan agkadakul yang kantidad na ang ya ra kay nag̱ibaratu na tung numyu duun tung langit. Kipurki pati nganing yang mga manigpalatay yang bitala na atiing tukaw, pinamuatan ka ta mga aruman nira ta magkapariu ka tung buw̱uaten yang mga kanubli nira tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Piru ta yamung mga manggaranen ang yang kamanggaran mi yay nag̱apanalig̱an mi, kanugunamu. Ay kipurki nag̱apapsawan mi ra yang tanan ang kasadyaan ang tegka ra ka ilem asan. ");
INSERT INTO tbk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ta yamung nag̱apagpagustu ra numanyan tung tanan ang nag̱alelyag̱an mi, kanugunamu. Ay kipurki tung uri maning pa tung pasubkanamu ka enged yang Dios ay pakapasanamu anya tung sasang kaayenan ang anda enged ang pisan ay katapus-tapusan na. Ta yamung panalig tung pagkabetang ming maayen numanyan, ang ya ra kay nag̱ipagtalangkak-talangkak mi, kanugunamu. Ay kipurki tung uri papungawenamu ka enged yang Dios ta duru ay pawaraanamu ka anya tung ultimung kasadyaan ang ya ray pagtangitan mi. ");
INSERT INTO tbk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dispuis, kung dayawenamung pirmi ta kadaklan, kanugun yang pagkabetang mi. Anday dumang panganugunan mi asan, ay natetenged tung uri, sasay panampetan mi yang mga tau ta namagtukaw ang namag̱imu-imu ta bitala ang ya unu ay bitala yang Dios buat. Kipurki yang mga bitala nira, ya kay nauyunan ang ipinagdayaw tung nira yang mga masigkabanwa nira ang ya ra kay pinanliitan yang mga irinsia yang mga taung pamagdayaw tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Piru tung numyung pananged da tung yeen, nani yang pag̱ianingu tung numyu. Gegmaan mi yang mga taung pagpakigsuay tung numyu, asta yang pagdemet tung numyu, buatan mi ka ta ikaayen nira. ");
INSERT INTO tbk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kung iampuamu ta duma tung Dios ang ituluy tung kalainan, anday dumang ibales mi tung anya, tanya si kay iampu mi tung Dios ang pakaayenen na. Asta yang mga taung mga manlelepes tung numyu, ya ka, iampu mi ka tung Dios ang para pakaayenen na. ");
INSERT INTO tbk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kung alimbawa may manampaling tung numyu, italiling mi yang duw̱aling emet ming ipatampaling. Kung alimbawa may magreg̱es ang mangalaw yang panlamig mi, paw̱ayaan mi ra ilem. Pati lambung mi, kung talagang eklan na ka, ipatug̱ay mi ra ilem tung anya ta paluas. ");
INSERT INTO tbk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kung may mandawat tung numyu, pakdulan mi. Kung may mangkel tung mga kasangkapan mi, indi mi bawien tung anya, kung indi, paw̱ayaan mi ra ilem. ");
INSERT INTO tbk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yang dapat ang buaten mi tung duma ya ra yang matinlu ang yay nag̱alelyag̱an ming buaten nira tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Elat kanay, kung yang gegmaan mi, ya ka ilem yang nag̱agegma tung numyu, unu pa pay dayawen yang Dios tung numyu asan? Ay napakitablaamu ka ilem tung mga taung pagpasuag tung anyang pagpakasalak. Kipurki maski nganing tanira, yang nag̱agegmaan nira, ya ka ilem yang nag̱agegma tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Dispuis kung yang taw̱angan mi ya ka ilem yang mga taung pagtaw̱ang ka tung numyu, unu pa pay dayawen yang Dios tung numyu asan? Ay napakitablaamu ka ilem tung mga taung pagpasuag tung anyang pagpanandili. Kipurki maski nganing tanira, yang magtaw̱angan nira ya ka ilem yang mga aruman nirang pagtaw̱ang tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kidispuis pa kung yang ag̱apautang mi ya ka ilem yang mga taung nag̱akumpiansaan ming tagbayad, unu pa pay dayawen yang Dios tung numyu asan? Kipurki napakitepengamu ka ilem tung mga taung pagbatuk tung anyang pagpanadili. Kipurki maski nganing tanira, yang magpautangen nira, ya ka ilem yang mga kaarumanan nirang nag̱akumpiansaan nirang tagbayad. ");
INSERT INTO tbk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kung indi, ta numyu, gegmaan mi yang mga taung pagpakigsuay tung numyu, buatan mi ka enged ta ikaayen nira. Kung may magministir tung numyung mangutang, pautangen mi, maskin anday kumpiansa ming tagbayad. Ay kung maning tia yang usuyun mi, tung uri may ibles yang Dios tung numyung durug tinlu. Kipurki maning tia pagpailalaamu ra ang yamu mga anaamu anyang matuud, ay pagsug̱utamu tung anya. Kipurki durug kaayen tung tanan ang mga tau, maskin tung mga malain ang mga tau ang indi maskeng magdemdem yang utang nirang kaneeman tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kumus tanyang nagyari rang Ama mi, mainildawen tung tanan ang mga tau, yamung mga ana na, dapat kang sakaen mi yang ug̱ali na ang yamu mainildawenamu ka tung mga masigkatau mi, maskin tung ninu pa. ");
INSERT INTO tbk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Indiamu ra enged magtag̱am ta sintinsia tung mga aruman mi ug̱ud indiamu ra ka sintinsiaan yang Dios. Kung may aruman ming nagbuat ta malain, indiamu ra mag̱aning ang yay dapat ang parusaan ug̱ud indiamu ra ka parusaan yang Dios. Patawaren mi ra ka yang kumpurming nagbuat ta malain tung numyu. Atia, bunayag da kang patawarenamu ra ka yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Magpamakdulamu ka tung mga kaarumanan ming may mga kaministiran. Atia pakdulanamu ra ka yang Dios yang mga kaministiran mi. Yang kaalimbawaan yang pagparakdulun na tung numyu maning pa tung gantangan ang magyekyeken na pang nag̱idasek ang pakuw̱ungan na pa ngani baklu pa ibukbukay na tung bebtangan mi. Kipurki kung unu pang pitikay ang usuyun ming magpamakdul tung mga kaarumanan mi, ya kay usuyun yang Dios ang magpamakdul tung numyu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Taa numanyan nagpagngel da ti Jesus ta sasang pananglit ang mag̱aning, “Ayw̱a, tinu pay nag̱aintindian ming buray ang magpangaas pang magguyud tung aruman nang buray? Kipurki kung ya pay buaten na, anday duma, matukaw-tukaw ra nganing, pariu ra ka ilem tanirang mangabugsu tung lungasug. ");
INSERT INTO tbk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yang sasang taung pagpaugyat belag̱an ang yay landaw tung pag̱ugyat tung anya. Piru kung makumplitu na ra nganing yang pagpaugyat na, asan da magluang magkapariu ra ka ta ug̱ali yang nag̱ugyat tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ta yamung naanad dang magtag̱am ta sintinsia tung duma, ayw̱a kaya ang yang maning pa tung letek ka ilem tung mata yang putul mi, atii pala yay nag̱apadekdekan mi ang pagkatapus atia ngani tung mata mi may mag̱abatang ang yag keketeg ang indi mi pala nag̱adipara? ");
INSERT INTO tbk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ayw̱a palangaasan mi pa ka enged yang putul ming aningen ang ‘Maimu ilem putulu, kuaten ta ra tiang letek tung mata mu?’ Ang pagkatapus atia ngani tung mata mi may sasang mag̱abatang ang yag keketeg ang indi mi pala nag̱adipara? Abaa, yamu ilem agpagpakaayen-ayen! Kaministiran ya ra kanay ay tukawen mi rang kuaten yang mag̱abatang ang atiang yag keketeg tung mata mi. Atia manadlaw ra yang paneleng mi ang para tung matinlu yang panguat mi tung letek ang atia tung mata yang putul mu. ");
INSERT INTO tbk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ag̱aningenamu ra yeen ta maning tia ay telengan mi ra ilem yang mga ayu. Anday ayung matinlu ang sayud yang nag̱ipamurak na. Anda kay ayung sayud ang matinlu yang nag̱ipamurak na. ");
INSERT INTO tbk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kipurki yang sasang ayu, tung burak na nga pruibaay kung matinlu u kung sayud. Simpri yang mga sapinit indi pamurak ta pumangga ig yang aruma indi ka pamurak ta langka. ");
INSERT INTO tbk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yang taung maayen, maayen ka yang nag̱ipalua na, ay natetenged ang ya kang lag̱i ay nag̱ipabalay na tung isip na. Pati yang taung malain, malain ka yang nag̱ipalua na ay natetenged ang ya ra kang lag̱i ay nag̱ipabalay na tung isip na. Ay simpri, kumpurming unu pay nag̱ipabalay yang sasang tau tung isip na, indi maimu ang indi na ipalua ang ibitala. ");
INSERT INTO tbk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ayw̱a, magkatama w̱asu ang aningenaw numyung Ginuu mi ang pagkatapus indi mi kag tumanen yang nag̱ipanuw̱ulu tung numyu? ");
INSERT INTO tbk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kung tinu pay pagpalenget tung yeen ang para magpamati tung nag̱itulduku ang pagkatapus ya ra kay tumanen na, yang kaalimbawaan yang taung atia maning taa. ");
INSERT INTO tbk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tanya maning pa tung sasang taung pagpakdeng yang balay na, ang yang akad na, durug dalem. Sinangkad na yang kabatuan ang ya kay pinamugsuan na yang mga adili na. Numanyan pagkatapus ta pagpakdeng yang balay na, kinaw̱utan da ta palempan, pati yang balay na binungsaran da ka yang beek. Piru indi ka enged naunu pa ay durug baked yang pagparakdengen yang may balay. ");
INSERT INTO tbk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Piru kung tinu pay pamati tung bitalaw ang pagkatapus indi na ra ka ilem tumanen, ya si kay nag̱ipananglitu tung sasang tau ang tung pagpakdeng na yang balay na, ya ra ilem ag̱iakarakaray na tung ulit yang tanek. Duun da ka ilem ipalg̱uray na yang mga adili na. Pagkaw̱ut yang balyu, pati yang balay na binungsaran da ka yang beek, gulpi ra ilem ang nagkalipuat. Gew̱a rang pisan yang balay ang atii,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Numanyan atiing tapus da yang tanan ang gustu ni Jesus ang ianing tung mga taung atiing pamamati tung anya, anday duma, dayun sing minangay tung Capernaum. ");
INSERT INTO tbk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Duun may sasang Kapitan tung sang grupung mga sundalung atiang tag̱a Roma. Yang Kapitan ang naa, may turuw̱ulun na ang yay nag̱amaal na ta mupia. Piru dinalpetan da ta laru nang matigbak ang pagkatapus tag̱umatayen da. ");
INSERT INTO tbk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Numanyan yang Kapitan ang naa, pagkagngel na yang balita natetenged tung mga buat-buat ni Jesus ang durug tinlu, anday dumang binuat na, nagpangay ra tung mga pamagpakigmaepet ang mga Judio ang para mamagpataw̱ang da tung ni Jesus ang kung maimu ilem paawatan na ra kanay ang angayen yang turuw̱ulun nang pamaayenen. ");
INSERT INTO tbk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Numanyan, pagkaw̱ut nira tung ni Jesus, dayun dang namagpakiildaw tung anyang mag̱aning, “Naa ti Kapitan, magkabag̱ay ang pisan ang taw̱angan mu. ");
INSERT INTO tbk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kipurki durug kaginegmaen tung nasyun ta. Nagpadag̱en-dag̱en nganing tung yamen ang nagpakagasta tung pagparakdengen yang balay ang pagsaragpunan ta,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kapurisu numanyan ti Jesus dayun da ka man ang nagnunut tung nira. Numanyan atiing alenget da rin ilem tung balay na, yang Kapitan ang naa, ya si ay nagpangay tung mga ungkuy nang mamagpakigbag̱as da tung ni Jesus. Numanyan yang pagbag̱as nira tung anya, dayun da nirang binalitaan yang bitala ni Kapitan ang mag̱aning, “Ameey, yang bitala ni Kapitan, anday bali unu, maskin india ra unu magpakabedlay ang magpakigkaw̱ut tani tung balay na, ay tanya unu belag̱an unu bag̱ay tung nuyu ang yawa pay magtakwal tung balay na. ");
INSERT INTO tbk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ya ra ka man nganing unu tia ang indi ra nagpakigbag̱as tung nuyu. Kung indi, maskin magkalalangana ra ilem unu asan, atia unu magmaayen da ka man yang turuw̱ulun na. ");
INSERT INTO tbk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kipurki maski nganing tanya unu, anad da ka unung magpalalang tung mas abwat tung anya, anad da ka unung magkalalangan tung mga sundalu nang mas aranek tung anya. Kung lalangan na unu yang sam bilug ang magpanaw, atiang lag̱i magpanaw ra ka man. Baskin yang sam bilug unu, kung guuyan nang magpalenget tung anya, atiang lag̱i unu magpalenget da ka man. Ang basin pa yang turuw̱ulun na unu, kung lalangan nang mag̱ubra ta sasang bag̱ay, atiang lag̱i, ubraen na ra ka man,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Numanyan pagkagngel ni Jesus yang mga bitalang atia ni Kapitan ang pinag̱ulit nira tung anya, ya ray naberengan na ta mupia tung ni Kapitan. Dayun dang nagbira ang nanalunga tung mga taung atiang buntun ang pamagpakignunut tung anyang mag̱aning, “Iugtulu tung numyu, basin nganing tung numyung mga masigkanasyunu taa tung banwa tang naang Israel, anda pay nag̱abag̱asung maning takaag dakul yang pagtaralig̱en na tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Numanyan yang mga taung atiang pinanuw̱ul ni Kapitan ang mamagpakigbag̱as tung ni Jesus, dayun dang namansibalik tung balay ni Kapitan. Pagkaw̱ut nira duun, maita nira yang turuw̱ulun na, maayen da ka man. ");
INSERT INTO tbk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pagkatapus tia, indi ilem nabuay, minangay ra ti Jesus duun tung lansangan ang Nain, kasiraan da ka tanira yang mga taung atiang nag̱apangugyatan na asta yang mga taung buntun. ");
INSERT INTO tbk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Numanyan tamang tamang mag̱aalenget da tung purtang parakleran tung lansangan ang atia, naa pala, may sasang taung patay ra ang nag̱ipalua nirang para ipalg̱ud da tung leyang. Ya pa ka man ay bugtung ang anang lalii yang sasang baw̱ay ang nabalu. Durug dakel yang mga tag̱a lansangan ang pamagkumpanya tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Numanyan pagkaita ni Ginuu ta tung may ana, ya ra ngaildaw ang mag̱aning tung anya, “Ineey, ustu ra tiang pagtarangiten mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pagkatapus dayun na rang pinalengtan yang kabaung ang inawiran ang asta namagtadeng da yang pamagtuang. Pagtadeng nira, dayun dang nagbugnu ti Jesus tung patay ang mag̱aning, “Duduy, magtuw̱uluna ra yeen ang magbungkarasa ra!” ");
INSERT INTO tbk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pagkatapus diritsyu ra ka man ang nagbungkaras yang taung atiang patay ra rin ang nag̱impisa ra kang nagbitala. Numanyan dayun dang inintriga ni Jesus tung ni nanay na. ");
INSERT INTO tbk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Purisu numanyan yang mga taung atiang nangaita, luw̱us dang nangaimakluan da yang pagterelengen nira tung ni Jesus. Namag̱intra ra dayaw tung Dios ang namag̱araning-aningan dang mag̱aning, “Kinaw̱utanita ra ta maktel ang manigpalatay yang bitala yang Dios. Itang mga tauan na, talagang nag̱apalengtanita ra anyang para tukuranita ra anya ta kalibrian ta,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kapurisu yang balita natetenged tung binuat ni Jesus ang atia, nagsarambung da tung intirung Judea ang asta duun da ka tung mga banwang nagtarambi tung Judea. ");
INSERT INTO tbk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Numanyan ti Juan ang naang manigbenyag ang duun ka man tung kalabus, binalitaan da ka yang dumang nag̱apangugyatan na natetenged tung tanan ang atiang mga binuat-buat ni Jesus. Purisu numanyan, ginuuyan na yang durua tung nirang pinanuw̱ul ang mansiangay ra duun tung ni Ginuung Jesus ang para mamanalimaan tung anya kung tanya ya ra ka man yang pag̱aningen ang Mananapnay ang nag̱apakbat kang lag̱i nira u kung may duma pang dapat ang elatan nira. ");
INSERT INTO tbk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Taa numanyan, pagkaw̱ut yang durua nga tauan ang atii tung ni Jesus, mag̱aning tanira tung anya, “Minangayami ilem taa, ay tinuw̱ulami ra ni Juan ang manigbenyag ang para mapasiguruana ra yamen kung yawa ra ka man yang pag̱aningen ang Mananapnay ang nag̱apakbat kang lag̱i yamen u kung may duma pang dapat ang elatan yamen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Taa numanyan, yang uras dang atiing pag̱angay nira duun, nagkatuun ang duru-durung mga taung pamaglaru ang nag̱apampamaayen ni Jesus. Yang duma may mga laru nirang matitigbak, yang duma agdimunyuen, ig duru kang mga buray ang nag̱apampabuskad na yang mga mata nira. ");
INSERT INTO tbk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Purisu numanyan, pagkagngel ni Jesus yang bitala yang durua nga tauan ang atiang tinuw̱ul ni Juan, dayun dang nagtuw̱al ang mag̱aning tung nira, “Ala, magbalikamu ra duun tung ni Juan. Balitaan mi yang kumpurming nagkaraita mi kag nagkaragngel mi taa. Aningen mi ang yang mga buray pagkaraita ra, pati mga barik pagkarapanaw ra ka, pati mga taung may dispirinsia tung mga ulit nirang makamamansa, nag̱akuatan da ka, pati mga bengel pagmaraanting da ka, pati mga patay pagkarabui ra ka. Asta yang mga taung aranek ta pagkabetang ang kumpurming nakapasan dang pisan ta magtalig̱an nira tung mga sadili nira, ya ra kay nag̱apampakaw̱utan yang Matinlung Balita ang yang Dios simpan dang magtaw̱ang tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kidispuis pa aningen mi ka dayun ang durug tinlu yang nag̱abtangan yang sasang taung indi enged nag̱aplekan ta ipagtalig na tung yeen,” mag̱aning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Taa numanyan, atiing namagliit da yang duruang atiing pinanuw̱ul ni Juan, ya ray pagpasanag ni Jesus tung mga taung atiang buntun natetenged tung ni Juan. Mag̱aning tung nira, “Ta, atiing pag̱angay mi tung ni Juan duun tung banwang atiing palag-palag yang tau na, unu pang klasiay ta tau ang nag̱alaum ming maita mi duun? Yang kalaum mi w̱asu tanya sasang taung guruyud-guyuran ta tau ang katulad ka tung tigbaw ang kung eyepen da nganing ta palet, pagpanunut-nunut da ilem? ");
INSERT INTO tbk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kung belag̱an kang ya tii yang katuyuan mi, unu pa w̱asu ay inangay mi duun? Gustu mi ilem basung magteleng tung sasang taung pagsuut ta durug tinlung aw̱el? Belag ka siguru ay kipurki yang mga taung pamagbisti ta matitinlu ig pamagpapsaw tung kumpurming unu pay nag̱alelyag̱an nira, duun da ilem ngaitaay mi tung mga palasiu yang mga adi. ");
INSERT INTO tbk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kung belag̱an kang ya tii ay inangay mi, tay unu pa w̱asu yang katuyuan mi duun? Gustu mi w̱asung magteleng tung sasang taung tinuw̱ul yang Dios ang magpalatay yang bitala na tung numyu? Anday duma, talagang yaa, ya ra ka man tii ay naita mi duun. Piru iugtulu tung numyu, yang taung atiing naita mi duun, landaw pa nganing tung mga manigpalatay yang bitala yang Dios ta namagtukaw ang mga panimpu. ");
INSERT INTO tbk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kipurki ti Juan ang naa ya ka man ay nag̱adapatan yang sasang inaning yang Dios tung aruman na ang napabtang tung kasulatan ang mag̱aning, ‘May sasang taung tuw̱ulunung magpalatay yang bitalaw tung mga tau ang yay ipatkawu tung nuyu ug̱ud katulad ka tung sasang pagliway ta dalan, yay maning pa tung magliway tung mga isip nira ug̱ud simpan da tanirang mamampauyun da tung nuyu,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iugtulu tung numyu, tung tanan ang mga manigpalatay ta namagtukaw ang mga panimpu, anda ray lumandaw tung ni Juan ang naa. Piru maskin pang maning tia, yang sasang tauanung napalg̱ud da tung palaksu yang paggaraemen yang Dios, maskin pag̱atelengan ang aranek ta pagkabetang, piru may nalandawan na pa ka enged tung ni Juan. ");
INSERT INTO tbk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Dispuis pa, papagsunairen ta ra kanay yang pagparamatien yang mga tau tung bitalang ipinagpakaw̱ut ni Juan tung nira. Yang kadaklan namampauyun da tung iningaluk yang Dios tung nira, kapin da enged yang mga manigpanukut ta mga balayaran tung gubirnu. Purisu namanligna rang lag̱i tung mga kasalanan nira ang pagkatapus ya ra kay pinapruibaan nirang namampabenyag tung ni Juan. ");
INSERT INTO tbk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piru naang mga Pariseo may naang mga sag̱ad tung pinanubli, pagkapamati nira tung bitalang ipinagpakaw̱ut ni Juan, belag da ya mamagpauyun, ya ra mamagpasuag tung kalelyag̱an yang Dios para tung nira ang ya ra ka rin ay ikaayen nira. Ay indi ra namanligna tung mga ubra-ubra nirang makalalaway ta isip na, indi ra ka namampabenyag tung ni Juan. ");
INSERT INTO tbk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Purisu yang mga tau numanyan, unu pa pay mapananglitanu tung nira? Unu pa enged ay mapapariuu tung nira? ");
INSERT INTO tbk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Anday duma, tanira maning pa tung mga mamulang pamagkarayam tung plasa ang yang duma maskin unyen pa ta paiwan-iwan yang mga kakayam nira, indi ka enged mapatunu-tunuan yang kalelyag̱an nira. Ya ra ag̱aningay yang mga kaarumanan nirang, ‘Uay, duruamug kaduruma! Ang magtarangit-tangitenaming mag̱urulimengmeng-ulimengmengen, indiamu malelyag ang magpakiintra. Utru si, ang patikanamu yamen, indiamu si ka enged malelyag ang magtaralekan.’ ");
INSERT INTO tbk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Talagang yay magkatamang mapananglitanu tung mga taung atiang indi ra pamagpauyun ay kipurki atiing paglua ra ni Juan ang manigbenyag, maita nira yang ug̱ali nang pamlek ang kaisan tung pagparanganen na ig indi ka panginem ta binu, indi ra nauyunan nira, kung indi, ya ra ag̱aningay nirang pag̱aekel-ekelan ta dimunyu. ");
INSERT INTO tbk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Utru si ang tung yeen dang pag̱aningen ang Maninga Tau, tung pagluaw tung mga tau, maita ra nganing nira yang ug̱aliu ang indiaw pamlek tung pagparanganenu kag panginemaw kang kaisan ta binu, indiaw ra ka nauyunan nira, kung indi, yuu ka ag̱aningay nirang takaw̱aw ig bulatsiruaw pa kumus pagpakibarkadaw tung mga manigpanukut may tung duma ay ya ra kang lag̱i ay nag̱alamku nirang mga teleb ta kasalanan. ");
INSERT INTO tbk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piru yang planu yang Dios ang atiang nag̱apasuag̱an nira, duun da nga pruibaay tung kumpurming pagpauyun tung yamen ni Juan ang talagang durug tinlung planu sigun tung pinakaw̱ut na tung nira,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Numanyan may sasang kinasakpan yang mga Pariseo ang napag̱imbitar da tung ni Jesus ang magpakigsaru tung balay na. Purisu ti Jesus nagnunut da tung anyang nagpakigsaru. ");
INSERT INTO tbk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Duun tung lansangan ang atii, may sasang baw̱ay ang ilaladung makinasalananen. Numanyan pagkagngel na yang balita ang ti Jesus unu duun da tung balay yang Pariseo agpagpakigsaru, anday dumang binuat na, dayun dang minangay ang may ekel nang midyu tung praskung punuk ta paamut ang durug maal. ");
INSERT INTO tbk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Numanyan pagpakled na tung balay, dayun dang nagpasagpi tung kakay ni Jesus ang yang mga luuk na duun da ka ilem nagkarapatak. Pagkatapus nag̱atarapuan na yang bua na ang nunut da ka ta pag̱ara-ara na tung kakay na ta muya-muya. Ang pakatapus binukbukan na yang paamut ang atiang durug maal. ");
INSERT INTO tbk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Numanyan naang Pariseong naang nag̱imbitar tung ni Jesus, pagkaita na tia, ya ray ipinagkesen-kesen na tung isip nang mag̱aning, “Yang taung naa, kung talagang matuud ang prupita, maskean na ra ka rin kung unu pang klasiay ta baw̱ay ang pagdeen tung anya ang teleb ta kasalanan.” ");
INSERT INTO tbk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Atii, nagbugnu ra ti Jesus tung anyang mag̱aning, “Simon, kung maimu ilem, may sasang iksenu rin tung nuyu.” Ag̱aaning ka ti Simon ang nagtimales, “Ala, Ameey, magbitalaa ra ilem asan ug̱ud!” ");
INSERT INTO tbk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Numanyan, dayun dang nagpakdul ti Jesus ta sasang pananglit ang mag̱aning, “May durua nga tauan ang nagkarautangan tung sasang taung manigpautang. Yang sam bilug may utang nang kinintus, yang sam bilug singkuinta. ");
INSERT INTO tbk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Numanyan, yang duruang naa, kumus indi ra mangabayad yang mga utang nira, pariu ra ilem tanirang pinatawad yang pinangutangan nirang inimpas. Ta, tung nuyung pag̱intindi, tinu pa w̱asu tung nirang durua ay mas ang magegma tung nagpatawad tung nira?” ");
INSERT INTO tbk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ag̱aaning ka ti Simon ang minles, “Tung yeen ilem ang pag̱intindi, siguru yang pinatawad na ta dakulung kantidad.” Ag̱aaning ka ti Jesus ang minles, “Tama, ya ka man tia.” ");
INSERT INTO tbk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Numanyan diritsyu rang minalyed ti Jesus tung baw̱ay ang sigi kang pakigkesen na tung ni Simon ang mag̱aning, “Ta, Simon, telengan mu yang baw̱ay ang naa w̱a. Ta nungaynang pagpakleru taa tung balay mu, indiaw ra ka pinatuw̱ulan mu tung turuw̱ulun mung mangug̱as yang kakayu, ag̱ad yuu sasang imbitasiun mu. Piru yang baw̱ay ang naa, lumismu yang luuk na ya pay ipinangug̱as na tung kakayu, pati yang bua na, ya pay ipinagtrapu na. ");
INSERT INTO tbk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pagpakleru taa, indiaw ra ka inistimar mung inara-araan ag̱ad imbitasiunaw nuyu. Piru tanya, yuu ilem ngakled, anday katadeng-tadengan yang pag̱iristimaren na tung yeen ang basin kakayu ra ilem, ya ray pirming nag̱ara-araan na. ");
INSERT INTO tbk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pagpakleru taa, indiaw ra ka ginalang mung linangisan tung kuluu, ag̱ad bisitaw nuyu. Piru yang panggalang na tung yeen, mismung paamut ang durug maal, ya pay ilinangis na ang baskin tung kakayu ra ilem. ");
INSERT INTO tbk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kapurisu Simon, iugtulu tung nuyu, yang baw̱ay ang naa, yang paggegma nang naang durug kalutuk ang nag̱ipaita na, ya ray pagpailala tung pagkamatuud ang tanya napatawad da tung mga kasalanan nang duru. Piru yang tau man ang pinatawad ka ilem ta gesye, gesye ka ilem yang gegmang mapaita na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pagkatapus, dayun dang nagbugnu ti Jesus tung baw̱ay ang mag̱aning, “Ipag, pinatawad da ka man ang matuud yang mga kasalanan mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Numanyan pagkagngel yang dumang pamagsararu asan, ya ray ipinagkesen-kesen nira tung mga isip nirang mag̱aning, “Abaa, tinu pa taang palangaasenay ang buat na pa pagpatawad ta mga kasalanan?” ");
INSERT INTO tbk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Piru ti Jesus, belag ya mag̱intindi tung nira, ya magsugpat tung baw̱ay ang mag̱aning, “Ipag, tan taa pang pagtalig mu tung yeen yang mga kasalanan mu, tinapnaya rang lag̱i yang Dios. Purisu numanyan, ala mulika ra, may pagbakeran da yang isip mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Taa numanyan, pagpanaw ra ta pira pang kaldaw, nagliliw̱utun da ti Jesus tung mga lansangan pati tung mga baryu. Nagparakaw̱utun yang sasang matinlung balita ang yang Dios mag̱impisa rang magtukud yang paggaraemen nang baklu tung mga tau. Yang mga tauan nang atiang sam puluk may durua ya ra kay namag̱ugpu tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kidispuis pa may mga baw̱ay asan ang namagpakignunut da ka tung anya ang tan taa pa pinampamaayen na tung mga laru nira ang yang duma dinimunyu ra rin. Katulad ka tung ni Mariang atiang tag̱a Magdala ang dinimunyu ra rin ta pitu nga dimunyuan ang ya ray pinalayas ni Jesus tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yang sam bilug pang baw̱ay ang pagpakignunut ka tung ni Jesus, yay nag̱aranan tung ni Juana ang kasawa ni Chusa ang may katengdanan duun tung palasiu ni Adi Herodes. Yang sam bilug pang baw̱ay yay nag̱aranan tung ni Susana. Kidispuis pa, dakele pa kang mga baw̱aing duma ang namagpakignunut da ka tung nira ang ya ray namaggastus ang namag̱arasikasuen tung mga kaministiran na Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Numanyan atiing pagliliw̱utun da ti Jesus, durug dakel yang mga taung namag̱arangayan tung anya ang yang pinanliitan nira maskin ay pang lansanganay. Numanyan kumus saragpun da tanirang tanan, pinakdulan da ni Jesus ta sasang pananglit. ");
INSERT INTO tbk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mag̱aning tanya, “Numanyan may taung minangay tung pinagbangteran na, ay magtarakbulun da ta binik ang trigu. Numanyan tung pagtarakbulun na, yang dumang binik nalagsik da tung dalan ang palanawan ta mga tau tung kakngaan. Purisu nagkaraliked-likeran da. Tegka na, kinaw̱utan da ta mga lamlam ang pinagsumpit. ");
INSERT INTO tbk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yang duma duun nepa tung tanek ang manipis ang may batung tapik ang unayen ang alenget dang lumput tung ulit yang tanek. Numanyan tamang tamang pamagbukngil da, indi ka ilem nabuay, namanlumpayeng da, ay natetenged langu yang tanek ang magtedeken yang kinit. ");
INSERT INTO tbk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yang duma duun nepa tung tanek ang may mga laskaw yang sapinit ang indi nadeeg̱an ta kapwa yang aradu. Purisu derengan da ka ilem tanirang namagtubu ang asta pinanaw̱ed-saw̱eran da yang mga trigung asta indi ra namurak. ");
INSERT INTO tbk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Piru yang dumang binik duun da tung lunsan ang tanek nepa. Purisu nangapagtubu ra ang asta nangapamurak da ang yang mga pangaluay na arabubwat da ang tung kategkaan na ra,” ag̱aaning. Numanyan tung pagtapus na tung pananglit nang atia, dayun dang nagpadakul yang busis nang mag̱aning, “Ta, yang nagngel ta mga talinga mi, ya ra kay painu-inuan mi ta mupia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Numanyan yang mga taung atiang nag̱apangugyatan na, ya ray namanalimaan tung anya kung unu pay linegdangan yang ipinananglit nang atia. ");
INSERT INTO tbk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tumuw̱al tanya, “Ta yamung pagpaugyat da tung yeen, linugtanamu ra yang Dios ang makdekan mi yang mga bag̱ay ang nag̱aegteman na pa rin ang tukaw natetenged tung paggaraemen nang baklu tung mga tau kung ya pa ag̱ari yang palaksu na simanyan. Piru tung kadaklan, yang mga bag̱ay ang atia asan da ilem nag̱ipapanawayu tung pulus pananglit. Yang nag̱ipagpananglitu tung nira ay ug̱ud maskin sam puluk ang magteleng, anday sakpen ta mga isip nira, basin sam puluk ang mamati, anda ra kay mamaresmesan nira. ");
INSERT INTO tbk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Piru para maintindian mi, ya ra taa yang linegdangan yang ipinananglitu ta nungayna. Yang binik ang atiang ipinanakbul, ya ra yang bitala yang Dios ang nag̱ipagpakaw̱ut tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kung natetenged tung dalan ang atiang nalagsikan ta dumang binik, yang linegdangan na ya ra yang dumang pamamati tung bitala yang Dios ang pagkatapus nag̱apalengtan dang lag̱i ni Satanas ang ludasen yang bitalang nag̱agngel nira ug̱ud indi ra ilem mananged tanira ang magpatapnay ra rin tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yang linegdangan yang tanek ang atiang manipis ang may batung manipis ang natampek, ya ra yang duma ang kung mapamatian da nganing nira yang bitala yang Dios, magpauyun dang lag̱i ang duru rag sadya yang isip nira. Piru kumus indi nalamut ta ustu tung mga kinaisipan nira, indi ilem mabuay yang pagparanangeren nira. Ay kung mapasaran da nganing ta tuksu, mamalpas da ka ilem. ");
INSERT INTO tbk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yang linegdangan yang tanek ang atiang may mga laskaw ang masapiniten, ya ra yang duma ang maskin pamati tung bitala yang Dios, piru tung pagpanaw yang uras, kumus durung pagpakabegbeg nira tung pagpangabui nira ubin may gustu nirang magmanggad ubin may gustu nirang magpapsaw ra ilem tung mga kalelyag̱an nirang sadili, yang bitalang nagngel nira maning pa tung asan da ilem nga kipit ang asta anday pinakaw̱ut na. ");
INSERT INTO tbk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Piru yang linegdangan yang tanek ang atiang lunsan, ya ra yang duma ang malemek ta kinaisipan ang yang bitala yang Dios ang nag̱agngel nira, ya ray nag̱ipatedek enged nira ta mupia tung mga isip nira ang asta may pakaw̱utun na ra ka enged ang nag̱auyunan na. Maskin mapasaran pa ta mga kaliwag̱an ubin tuksu man, ya pa ka enged ay nag̱apadanayan nirang magtumanen yang mga kalelyag̱an yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ayw̱a, tinu pay nag̱aintindian ming tau ang magsindi ta kingki ang pagkatapus ya rag sukluw̱ay na ubin ya ra ag̱ipasirungay na tung katri? Simpri asan da ag̱ipabtangay na tung tapi-tapi, ug̱ud kung tinu pay magtakwal, yag dawalay nira yang sadlaw na. ");
INSERT INTO tbk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pariu ka tung yeen, anday itinaluku tung nag̱ipananglitu sigun tung palaksu yang paggaraemen yang Dios ang indi ipabunayag̱u, anda kay tinipig̱anu asan ang indi ipalw̱awu. ");
INSERT INTO tbk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Purisu amlig̱an mi ta mupia kung ya pa ag̱ari yang pagparamatien mi tung nag̱ipananglitu. Kipurki yang taung maderep ang magpasadsad, mas pang paeyangan yang Dios ta ipag̱intindi na. Ig kung tinu pay mapinaw̱aya-w̱ayaen tung pag̱irintindien na, maskin yang gesyeng nag̱alaum nang nag̱akdekan na, bawien da ka enged yang Dios tung anya,” ag̱aaning duun ti Jesus tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Atii ya ra kay pagkaw̱ut yang nanay ni Jesus may yang mga putul nang mga lalii. Ug̱aring ilem indi mangaalenget tung anya natetenged tanya ya ngaknga tung mga taung durug damel. ");
INSERT INTO tbk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Numanyan inugtul da tung anya ang duun tung lua yang nanay na may yang mga putul nang mga lalii ang may gustu nirang mamagpakiksen tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mag̱aning ti Jesus ang nagtimales, “Yang magkaw̱ig̱enung nanayu ubin mga putulung mga lalii ya ra yang kumpurming pamati tung bitala yang Dios ang naang nag̱ipagpakaw̱utu, ang pagkatapus magtumanen na ra ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Numanyan, may dumang kaldaw ang ti Jesus nagsaay ra tung sasang balangay, kasiraan da ka tanira yang mga taung nag̱apangugyatan na. Ag̱aaning ti Jesus tung nira, “Ala, magpatindakita ra kanay.” Pagkatapus dayun dang namagpaabwat. ");
INSERT INTO tbk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Numanyan atiing pamagpalayag da tanira, ti Jesus tanya, inalapan da ta elek. Buay-w̱uay ta gesye, binungsaran da tanira ta tampung durug ketel. Numanyan alang-alang da yang pagkabetang nira, ay yang balangay nag̱apnukan dang nag̱apnukan. ");
INSERT INTO tbk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Numanyan dayun dang pinaalengtan nira ti Jesus ang pinuaw ang inaning, “Ameey, Ameey, magkaralemesita ra!” Pagkapuaw ni Jesus, dayun dang nagsambeng tung palet may tung mga lakun ang atiang durug kadarakul. Lag̱i-lag̱ing nag̱elteng da yang palet, pati yang aw̱uyuk nag̱intang dang naglinaw rang anda rang pisan ay giup-giupun na. ");
INSERT INTO tbk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pagkatapus, mag̱aning ti Jesus tung mga tauan na, “Ayw̱a, ay ra ilem ag̱ari w̱asu yang pagtaralig̱en mi tung yeen?” Numanyan nangaimakluan da tanirang namagteleng tung anya ang nunut da ka ta pagkabereng nirang subra tung naita nirang atia. Namag̱araning-aningan da ilem ang mag̱aning, “Abaa, tinu pa kayang tauay taa? Baskin palet, baskin lakun pa, basta lalangan na ra ilem nganing, gulpi ra ilem ang mamananged!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Taa numanyan namagpadayun da yang pagsaay nira ang asta namanampet da duun tung baw̱anwaan yang mga Geraseno ang yag pagtinindakay yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Numanyan pagkalampud pa ilem ni Jesus tung balangay, may sasang taung tag̱a lansangan ang pag̱aekel-ekelan ta mga dimunyu ang yay nagpakigbag̱as tung anya. Tung tantung kabuay ra, indi nag̱asuut-suut ta aw̱el. Dispuis indi magtinir tung balay, kung indi, duun da ilem agpaglaug-laug tung mga leyang ang pinanlug̱uran ta mga patay. ");
INSERT INTO tbk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Taa numanyan, pagbag̱as na tung ni Jesus, dayun dang nagluud tung pinagtalungaan nira ig yang dimunyung pag̱ekel tung anya naglelpaken dang mag̱aning, “Ay Jesus, yawang pag̱aningen ang Ana Yang Dios ang makagag̱aem, ayw̱a nag̱apalabtanaw pa nuyu? Yang nag̱ipagpakiildawu w̱a tung nuyu ang indiaw ra parusaan mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Napagpakiildaw ra nganing ta maning tia yang dimunyu, ay linalangan dang lag̱i ni Jesus ang maglayas da tung taung atia. Luyut dang luyut, yang taung atia muya-muyang pinaggaeman yang dimunyung atia. Kidispuis pa, kada masinti yang mga masigkabanwa na ang tanya kaw̱utun si, dayun da nirang deepen ang begkesen ta kadina tung kalima na may tung kakay na para tung matinlung pagbantay nira tung anya, piru indi ka enged magnaet. Agbuntuk-buntukun na, ang pagkatapus, ya rag liw̱erengay yang dimunyung ekel-ekelan duun tung mga kabiw̱init-binitan ang malaka ka ilem yang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Taa numanyan tinalimaan ni Jesus yang dimunyu kung tinu pay aran na. Mag̱aning kang nagtimales, “Yang aranu ti Buntun.” Tama ka man tiing tuw̱al na ay duru-duru ka man ang mga kaarumanan nang mga dimunyung pamag̱ekel-ekel tung taung atia. ");
INSERT INTO tbk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Numanyan yang binuat yang mga dimunyu, namag̱intra ra amu-amu tung ni Jesus ang tanira indi na lalangan ang ipaangay duun tung pag̱aningen ang bulalut. ");
INSERT INTO tbk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Numanyan may sasang kaayepan yang mga baw̱uy ang gaw̱ung ang pamanulyad-tulyad tung napabukatud ang alenget ilem duun. Purisu yang mga dimunyung atia, namagpakiluuy ra ilem tung ni Jesus ang basin duun da ilem tung mga baw̱uy tugtay nang mamansisuut. Pagkatapus tinugtan na ra ka man. ");
INSERT INTO tbk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Purisu numanyan pagliit nira tung taung atia, diritsyu ra ka man ang namansilakted tung mga baw̱uy ang namansisuut. Pagkasuut nira tung mga baw̱uy, dayun dang namansikurbut ang namagpataladtad ang diritsyu ra ilem tung aw̱uyuk ang namampakpa ang asta nagkaralemes da ilem ang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Taa numanyan, yang mga manig̱asikasu tung mga baw̱uy, pagkaita nira yang nainabung atia, dayun dang namaglalaksuan ang namagbaw̱alitaen tung mga taung kumpurming nag̱apanawan nira duun tung lua ang asta duun tung lansangan. ");
INSERT INTO tbk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Purisu numanyan yang mga taung nagkarabalitaan, diritsyu rang namansilua duun tung bakayan ang para mamanginsapu tung nainabung atii. Numanyan kaw̱utan nira ti Jesus, unu pay maita nira, kung indi, ya ra yang taung atiang dinimunyu ra rin. Yag lalaptik tung tanek tung pinagtalungaan nira ni Jesus ang pagpatulduk ta maderep tung anya. Dispuis, belag da luas, kung indi, napag̱aw̱el da ay naulikan da yang pag̱irisipen na. Numanyan pagpaniid yang mga taung atia tung anya, ya rag pandelaay. ");
INSERT INTO tbk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Numanyan yang mga manig̱asikasu ang atiang nangaita tung nainabung atia, ya ray namagbaw̱alitaen tung mga taung naang baklung namansikaw̱ut kung ya pa ag̱aring nagmaayen da yang taung atiang dinimunyu ra rin. ");
INSERT INTO tbk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Purisu anday dumang dinangat na, tanirang tanan ang mga Gerasenong nagkasagpun asan, namagpakigkesen da tung ni Jesus ang magliit da ilem duun tung nira. Ya ray iningaluk nira, ay natetenged pinamalayan da ta eled nirang duru tung binuat ni Jesus ang atia. Kapurisu ti Jesus, pagkagngel na yang bitala nira, dayun da ka man ilem ang suminaay tung balangay ang para magbalik si duun tung pinanliitan na. ");
INSERT INTO tbk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Pagkatapus, simanyan yang taung atiang pinalayasan na tung mga dimunyu, ya si ay nagpakiildaw tung anya kung puiding magpakignunut da tung anya ang para mag̱ing sasang tauan na. Piru indi ra tinugtan na, kung indi, ya ra ag̱aningay nang, “Maayen pa, ungkuy, mulika ra ilem, magbaw̱alitaena ra tung mga masigkabanwa mu natetenged tung tanan ang binuat yang Dios tung nuyu,” ag̱aaning. Purisu yang taung atia, diritsyu rang minulik ang naglig̱u ra tung intirung lansangan ang nagbaw̱alitaen tung mga tau kung unu pay binuat ni Jesus tung anyang durug tinlu. ");
INSERT INTO tbk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Taa numanyan, atiing pagparuung na Jesus duun tung tindak, durug dakel yang mga taung namagpakigbag̱as da tung anya, ay tanirang tanan pamagpakbat da kang lag̱i tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yang uras dang atii, may taung baklung kaw̱ut ang nag̱aranan tung ni Jairo. Tanya sasang may katengdanan tung pagsaragpunan ta mga masigka Judio na. Pagkaw̱ut na tung ni Jesus, ya rag padagpa tung pinagtalungaan nirang durua ang nagpakiluuy tung anyang mangay ra kanay duun tung balay na. ");
INSERT INTO tbk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ay yang ana nang baw̱ay ang bugtung ka pa man tag̱umatayen da. Pag̱idaran da ta sam puluk may duruang takun. Numanyan atiing pagkanunutan da tanira ni Jesus, yang mga tau pamagpakigsag̱ese tung anya ang asta imurat da ilem ang mapanaw. ");
INSERT INTO tbk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Taa numanyan tung kinadamel yang mga taung atia, naa pala may sasang baw̱ay ang nalaket ang tung seled sam puluk may duruang takun muya-muya ra ilem ang nag̱aawasan. ");
INSERT INTO tbk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Purisu numanyan, anday dumang binuat na, yag sisikup ang papalenget tung ni Jesus ang nagdeen tung sam bilug ang mabiw̱ilug-bilug ang atiang yag tataked tung sidsiren yang aw̱el nang langkuy. Pagkadeen na, atiang lag̱i nagpeet da ka man yang dug̱u na. ");
INSERT INTO tbk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Numanyan mag̱aning ti Jesus ang nagtalimaan, “Tinu pay nagdeen tung yeen?” Kumus anda ray nangamin, ti Pedro ya ray nabngang nagtuw̱al ang mag̱aning, “Ginuu, magtalimaana pa ka enged atiang duru rang taung nangaliw̱ut tung nuyung pamagsag̱ese?” ");
INSERT INTO tbk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mag̱aning ti Jesus ang nagtuw̱al, “Indi! Talagang may nagdeen tung yeen ta nungayna, ay natetenged napanimananu rang lag̱i tung sadiliu ang may sasang taung nagmaayen da ekel tung kagaemanu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Numanyan pagkasinti yang baw̱ay ang atii pala indi nataluk, anday dumang binuat na, nagpalenget da ka enged ang nagpadagpa ra ilem tung pinagtalungaan nirang durua ang duru ra atiing pagpangerel na. Maskin duru pa ka man ang mga taung pamamati, binatas na ra ka enged yang eyak nang nag̱ubligar tung ni Jesus kung unu pay ipinagdeen na tung anya ang pagkatapus ya ra kang lag̱i ay pinagmaayenan yang pag̱alaru na. ");
INSERT INTO tbk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Numanyan mag̱aning ti Jesus ang nagsugpat tung anya, “Ipag, nagmaayena ra nganing tung linaru mung atia ay natetenged itinalig mu ra kang lag̱i tung yeen. Ala, mulika ra, may paglimengan da yang isip mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Taa numanyan, indi pa ngani nag̱atapus ti Jesus ta pagbitala, asan da kuminaw̱ut yang sasang taung duun manliit tung balay ni Jairo ang ya ray nagbaw̱alitaen tung anyang mag̱aning, “Napatay ra yang ana mu. Maskin indi mu ra aw̱alaen ti Ameey,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pagkagngel ni Jesus tia, dayun na rang pinaktel yang isip ni Jairo ang inaning, “India ra ilem magpadla, kung indi, magtalig̱a ra ilem tung yeen ta ustu. Atia, mabui si kang uman yang ana mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Numanyan pagkaw̱ut nira tung balay, anday dumang tinugtan nang numunut tung anyang magpakled, kung indi, ya ra ilem ti Pedro, may ti Juan, duruang mag̱aka ni Santiago, pati yang amaen may yang inaen. ");
INSERT INTO tbk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Numanyan asan tung kakleran, durung mga taung pamagtarangiten dang pamag̱urulimengmengen natetenged tung mulang naang napatay. Pagkaita ni Jesus, dayun dang nagbitala tung nirang mag̱aning, “Ustu ra tiang tangit mi. Belag̱an patay yang mula, ang indi ag̱elken ilem,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pagkagngel nira yang bitala ni Jesus, ya ra ilem agtalangkakay nira, ay natetenged nag̱asiguru ra nira ang talagang patay ra. ");
INSERT INTO tbk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Piru ti Jesus tanya, anday dumang binuat na, pinalengtan na yang mulang pinggesan tung kalima na ang pagkatapus pinadakul na yang busis na ang mag̱aning, “Nini, magbungkarasa ra!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pagkatapus naulik da yang linawa yang mula, lag̱i-lag̱ing nagbungkaras da. Pagkatapus nagkalalangan da ti Jesus ang papaanen da kanay yang mulang baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Numanyan yang ginikanan na, nangabereng da ta mupia. Purisu pinagpaamanan dang lag̱i ni Jesus ang indi rang pisan mamagbaw̱alitaen tung duma may ruma ang natetenged tung nainabung atia. ");
INSERT INTO tbk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","May dumang kaldaw ang ti Jesus nagpasagpun da tung mga tauan nang atiang pinagpilik nang sam puluk may durua. Pagkatapus pinamiaran na ta kagaeman nirang mamagpalayas ta maskin unu pang mga dimunyuay ang namagsuut tung mga tau ig mamagpamaayen ka tung mga taung may mga laru. ");
INSERT INTO tbk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dayun dang nanuw̱ul tung nira ang mamagliliw̱utun dang mamagparakaw̱utun natetenged tung paggaraemen yang Dios ang baklu tung mga tau kung ya pa ag̱aring mapalg̱uran da nira. Pinanuw̱ul na kang mamagpamaayen tung may mga laru. ");
INSERT INTO tbk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Baklu papanaway na, sinugpatan na pang inaning, “Kung magpanawamu ra nganing, paisanu ilem. Indi mi ka isipen ang mag̱ekel-ekelamu pa ta suyud, maskin puyu-puyu pa ang pariu ka tung pag̱aekel-ekelan ta mga manigpalimus, maskin pamangan, maskin kuarta, maskin mga aw̱el pang irimaraan mi. ");
INSERT INTO tbk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dispuis kung ariamu pang balayay nga patakwalay, duunamu ilem magdayun ang asta magliitamu ra ilem. ");
INSERT INTO tbk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piru kung ariamu pa pangindiay ta mga tau, bakluamu magliit, pakdulan mi ta sasang sinyalis. Yang apuk tung banwa nirang nag̱adepet tung mga kakay mi, ya ray itagbeng-tagbengay mi ug̱ud asan da nga paamanay mi ang yang pagpakuindi nirang atia tung numyu ya ray panuw̱alan nira tung Dios,” mag̱aning. Atia, ya ray mga tuyun ang ipinakdul ni Jesus tung nira baklu papanaway na. ");
INSERT INTO tbk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kapurisu numanyan namagpanaw ra ka man tanira ang namagliliw̱utun tung tanan ang mga baryu. Maskin ay pa mamagpanaw, sigi yang pagparakaw̱utun nira may yang pagparamaayenen nira tung mga taung may mga laru. ");
INSERT INTO tbk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Taa numanyan nabalitaan da ni Adi Herodes natetenged tung mga bag̱ay ang atiang makabew̱ereng ang pagkarainabu ig naliw̱eg̱an da ta mupia yang kula na natetenged ang pamansianing da yang duma ang ya unu ay kabuat-buatan ni Juan ang manigpamenyag ay nabui si ka unung uman. ");
INSERT INTO tbk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Piru may dumang pamansianing ang ya unu ay kabuat-buatan ni Elias ang nagbalik da. May duma pa ka enged ang pamansianing ang ya unu ay kabuat-buatan yang sam bilug pang manigpadapat yang bitala yang Dios ang tukaw ang mga panimpu ang ya si ka unu ay nabuing uman. ");
INSERT INTO tbk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Numanyan pagkagngel ni Adi Herodes yang balitang nagsari-sari ra ilem, ag̱aaning tung sadili na, “Ti Juan yuu mismu ay nagpapug̱us yang dikel na. Tinu pa kayang tauay tiang sam bilug ang nag̱abalitaanung pagpalapus ta mga maning tiang pruiba?” ag̱aaning. Purisu kumus nag̱aliwag̱an da ta mupia yang pag̱irisipen na, indi ra temegka mintras indi na mabag̱as ti Jesus ang para masisiguru na. ");
INSERT INTO tbk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Taa numanyan atiing pagbalik da yang mga taralig̱an ni Jesus ang sam puluk may duruang atiang pinanuw̱ul nang mamagliliw̱utun, namagbaw̱alitaen da tung anya natetenged tung tanan ang nagkarabuat-buat nirang kaayenan tung mga tau. Pagkatapus pinangkelan da ni Jesus ang ipinampaag̱es duun ampir tung lansangan ang pag̱aningen ang Betsaida, ang tanira tanira ra ilem. ");
INSERT INTO tbk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Numanyan yang mga taung buntun asan, pagkaintindi nira ang ti Jesus duun da nagpaag̱es, dayun da nirang sinikad. Pagkaw̱ut nira, dayun na rang sinapet ang pinapag̱intindi natetenged tung paggaraemen yang Dios ang naang baklung pag̱atukud na. Dispuis kumpurming tinu pay nangaministiran tung anyang pamaayenen tung laru na, luw̱us da kang pinampamaayen na. ");
INSERT INTO tbk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Numanyan atiing papakerep da yang kaldaw tung bukid, yang mga taung nag̱apangugyatan ni Jesus ang atiang sam puluk may durua, namagpalenget da tung anyang mag̱aning, “Ameey, maayen pa, pampapanawen mu ra ilem yang mga taung atia ug̱ud mamansiangay ra ilem duun tung mga baryung alelengeten, ang basi pa ra ilem mangaita ta mapangan nira may mga balay kang maelkan nira. Ay naawita ra ka pa man tung rugal ang naang kapas,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mag̱aning ti Jesus ang nagtimales, “Yamu ray magpapaan tung nira.” Mag̱aning ka tanirang namagtimales, “Abee yang nadipara yamen tung mga taung naa ya ra ilem yang limang bilug ang tinapay ang gereg̱esye may durua ka ilem ang bilug ang ian. Nusias yang gustu mung ianing basu, yami pay papangalangen mu ta mapangan nira, yang kinadaramelen nirang atia pa man?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nangapagbitala ta maning tia ay yang kinadakel yang mga taung atii, pagdangat tung limang liw̱u nga tauan, puira pa tung mga baw̱ay may tung mga mamula. Numanyan ag̱aaning ti Jesus ang nagtimales, “Ala, bereblag̱en mi ra kanay ta mga tag lilimang puluk nga tauan kaw̱a pampakarungun mi ra ka tung tanek,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pagkatapus dayun da nirang ipinampakarung ta maning ka tiing itinuw̱ul na tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Numanyan ti Jesus, pagkadawat na yang mga tinapay ang atiang limang bilug may yang ian ang atiang duruang bilug, dayun dang tuminingarang nagpasalamat tung Dios. Pagkatapus diritsyu rang pinagpingas-pingas nang ipinamakdul-pakdul tung mga aruman na ang para ipanagtag-tagtag da nira tung mga taung atiang buntun. ");
INSERT INTO tbk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Numanyan tanirang tanan nangapamangan dang asta namampabial dang luw̱us. Pagkatapus atiing tuw̱urun da yang mga aruman ni Jesus yang mga yeped-yeped yang pinamanganan nira, sam puluk may durua pa nga baayan yang napnuk nira. ");
INSERT INTO tbk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Taa numanyan, may dumang kaldaw ang ti Jesus nag̱ampu ang tanya ilem ang sam bilug. Pati yang mga taung nag̱apangugyatan na duun ka. Matapus ta pag̱ampu na, dayun dang nagtalimaan tung nirang mag̱aning, “Elat kanay, ang yuu pagkeresen-kesenan ta mga tau, unu pay pagpabetang nira tung yeen?” ");
INSERT INTO tbk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mag̱aning ka tanirang namagtimales, “Mag̱aning yang duma ang yawa unu ti Juan ang manigpamenyag ang nabui si kang uman. Yang duma pag̱aning ka ang yawa unu ti Elias. Yang pintu yang duma ang yawa unu sasang manigpalatay yang bitala yang Dios ta nagtukaw ang timpu ang ya si kay nabuing uman,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mag̱aning ti Jesus ang nanalimaan si, “Ay ta numyu, unu pay numyung pagpabetang tung yeen?” Numanyan ti Pedro ya ray nagtuw̱al ang mag̱aning, “Yawa ra ka man yang pag̱aningen ang Cristo!” ");
INSERT INTO tbk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Atii, dayun dang nagkalalangan ti Jesus tung nirang mag̱aning, “Luay! Indiamu ra kanay magbaw̱alitaen maskin tung ninu pa ang yuu yang pag̱aningen ang Cristo. ");
INSERT INTO tbk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ay ya pa ag̱ari, yang nag̱aingaluk ni Ama tung yeen ang pag̱aningen ang Maninga Tau, dapataung mapasaran ta pinitinsiang durug lebat ay pangindianaw yang mga pamagpakigmaepet may yang mga paring arabubwat ta katengdanan may yang mga sag̱ad ang pagkatapus ipaimatayaw ra ka dayun nira. Piru maskin pang maning tiang dapat ang mapasaranu, tung pagkaw̱ut yang yaklung kaldaw, pabungkarasenaw ra ka enged yang Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Atii dayun dang nagpasanag tung nirang mag̱aning, “Kung tinu pay nag̱alelyag dang magpakignunut tung yeen, yang sadili na ya lipatay na. Kaldaw-kaldaw yang isip na ya ag̱ipatentenay nang mag̱agwanta tung mga pinitinsia, maskin ilansang pa tung krus. Dapat maning tia yay ipabalay na tung isip na kung gustu nang magpaugyat tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ay kipurki kung tinu pay ag̱alelyag ang yang sadili na ilibri na tung malain, asan da nga kapa-kapaay na yang kaampiran na tung yeen. Piru kung tinu pay mamirdi tung sadiling kelelyag̱an na natetenged ilem tung yeen ang yuu ray nag̱ipalusu na ta gegma na, yang taung atia, asan da ka nga siguruay na yang kaampiran na tung yeen ang yay pagnatisan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kipurki unu pa pay pakinaw̱ang yang sasang taung magkatinir da ta tanan ang nag̱alelyag̱an na taa tung kaliw̱utan ang naa ang pagkatapus asan da nga plekay ta ipagnatis na tung kaliw̱utan ang baklu? Andang pisan! ");
INSERT INTO tbk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ag̱aningenamu ra yeen ta maning tia ay natetenged kung tinu pay maeyak ang mangerengan tung yeen taa tung kaliw̱utan ang naa ubin yang bitalaw ikaeyak na kang ipagngel tung mga masigkatau na, tung uri, tanya ra kay ikaeyakung ingwaraen ang belag̱an tauanu. Ay ta yeen ang pag̱aningen ang Maninga Tau, kung maglekataw ra nganing ang para maggaraemenaw ra tung kaliw̱utan ang baklu, duru rag kasusulaw yang pagkabetangu ang yang pisan yang kasusulawen ang pag̱atiniran kang lag̱i ni Ama pati mga angil ang sagradu. ");
INSERT INTO tbk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iugtulu tung numyu yang kamatuuran. May duma asan tung numyu ang baklu magkarapatay, mabilug̱an da ka enged nira yang palaksu yang paggaraemen yang Dios kung ya pa ag̱ari,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Numanyan atiing pagpanaw ra ta mga san linggu tung pagkainambit ni Jesus yang mga bag̱ay ang atia, nanungul da tung sasang bukid ang para duun da mag̱arampuen tung Dios. Pati ti Pedro may ti Juan durua ni Santiago ingkelan na ra ka duun. ");
INSERT INTO tbk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Numanyan atiing yang pag̱arampuen da, inaling naglew̱ad da yang ityura na. Pati yang aw̱el na durung pisan agkakulit ig duru kang pisan agkasulaw. ");
INSERT INTO tbk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pagkatapus may durua nga tauan ang inaling nansilput duun ang ya ra ti Moises, durua ni Elias. Pamagkeresen tanira ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yang pirsunal nira duru ra kag kasusulaw ang telengan. Taa numanyan, anday dumang nadapatan yang keresen nirang tulu, kung indi, natetenged tung pagtalus ni Jesus tung ipiniar yang Dios tung anya ang indi ra ilem buay, tanya magpakugmatay ra duun tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Taa numanyan na Pedro manek dang pisan yang elek nira. Tung pagkapuaw nira, ya ray napuawan nira ti Jesus ang duru rag kasulaw pati naang durua nga tauan ang kemdengan tung tepad na. ");
INSERT INTO tbk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Numanyan atiing pagpablag da rin yang duruang atia tung ni Jesus, ya ray pagbitala ni Pedro tung anyang mag̱aning, “Ginuu, maayen ilem naawami ra ka. Tugtayami kang magpakdeng ta tulu nga layang-layangan, salegsam bilug mi ni Moises may ni Elias,” mag̱aning. Naa pala ti Pedro, nagbitala ra ilem ta indi na naskean. ");
INSERT INTO tbk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Numanyan indi pa nganing ag̱atapus ta pagbitala, kinaw̱utan da tanirang tanan ta sasang panganud ang ya ray nagpaulung tung nira. Pagkatapus atiing pinutus da ka tanira tung panganud ang atia, pinandelaan da na Pedro ta mupia. ");
INSERT INTO tbk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Atii may nagngel da nirang busis ang asan manliit tung panganud ang mag̱aning, “Uay, atia ra yang pag̱aningenung Anaw ang pinilikung magtalus tung kalelyag̱anu. Intindien mi ta maayen yang kumpurming ianing na tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagkatapus yang busis ta pagbitala, telengan nira, naa pala, ti Jesus da ilem ang sam bilug ang yag mana-mana. Kapurisu mag̱impisa pa tii, namag̱ekmeng da ilem tanira. Mintras pagnurunutan pa tanira na Jesus, tung tanan ang naita nira tung uras ang atii, anda enged ang pisan ay nabalita-w̱alita nira tung duma may ruma, may san tag̱a. ");
INSERT INTO tbk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Numanyan pangayag yang kaliw̱utan, baklu namagdanekan. Numanyan duun tung aranek, durug dakel yang mga taung namagpakigbag̱as tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pagkatapus, may sasang tau asan ang pagkekendalen da tung anyang mag̱aning, “Aay, Ameey, ildawan mu ka nakaang anaw ang bugtung ka pa man ilem. ");
INSERT INTO tbk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ay kipurki muya-muyang balik-balikan ta sasang dimunyung papaggaluaken ta inali. Pagkatapus, dayun na rang papagpedlet-pedleten ang papagkegtengen ang asta magbura ra yang nganga na ang pagkatapus mag̱ingtang da ilem yang tinanguni nang pinanluluw̱ayan. Alus pa ilem indi na ra paw̱ayaan. ");
INSERT INTO tbk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Dispuis idinangepu ra rin tung mga taung naang nag̱apangugyatan mung inamu-amu ang para palayasen da nira yang dimunyung atia, piru indi ra ka ilem nasarangan nira,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Numanyan magtimales ti Jesus, tung nira rang tanan asan iparumbuay na yang bitala nang mag̱aning, “Uu, yamung mga tauamung mga masigkanasyunu simanyan! Ay ra yang pagtalig mi? Duru pa ka enged agkabaliskad yang laksu yang mga pag̱irisipen mi. Midyu tung maglakgasenaw ra tung numyu ang sanuamu ra kaya ngaeyangay ta ipagtalig ming ustu tung yeen. Kaministiran pang mag̱agwantaw ta mabuay tung ug̱ali ming maning tia?” Pagkatapus dayun na rang inaning yang may ana, “Ala, eklan mu ra tani tung yeen yang ana mu.” ");
INSERT INTO tbk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Numanyan atiing pagpalenget da yang mula tung anya, gulpi ra ilem ang ibinegsak yang dimunyu tung tanek ang pinapagkegteng. Piru ti Jesus, pagkaita na, dayun na rang linalangan yang dimunyu ang maglayas da tung mula. Maning tia yang pagpamaayen na tung mula ang pagkatapus dayun na rang inintriga tung may ana. ");
INSERT INTO tbk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Purisu yang mga taung atiang nangaita, nangabereng da ta mupia tung paggaraemen yang Dios ang durug puirsa ang ya ray nabilug̱an nira tung ni Jesus. Taa numanyan, durung pagkabereng yang kadaklan ang mga tau tung tanan ang mga maning tiang buat-buat na. ");
INSERT INTO tbk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Purisu ti Jesus tanya nagpaaman dang lag̱i tung mga taung nag̱apangugyatan na. Mag̱aning tung nira, “Ta yamu, ipabtang mi tung mga isip mi yang nag̱ianingung naa tung numyu ang para indi mi malipatan. Yuung pag̱aningen ang Maninga Tau anday dumang mabtanganu tung uri, yuu ra ag̱intrigaay tung pudir yang mga tau,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Piru yang mga aruman na, anday naerem kung unu pay nalagpakan yang ibinitala nang atia. Yang indi nira nasangkad yang linegdangan na, ay nakiputan da tanira ta pag̱irisipen nira. Dispuis pa, may dalenden nirang magtalimaan pa tung anya kung unu pay gustu nang ianing. ");
INSERT INTO tbk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Taa numanyan, yang mga tauan ni Jesus ang atia, namag̱intra ra baralalaan kung tinu pay pinakalandaw tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Numanyan pagkasiman ni Jesus yang laksu yang pag̱irisipen nira, anday dumang binuat na, may sasang mulang ingkelan na ang ya ra kay ipinakdeng na tung tepad na. ");
INSERT INTO tbk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mag̱aning tung nira, “Kung tinu pay magsapet tung mulang maning ka ilem taa yang pagkabetang nang aranek ang pisan arangan da ilem tung yeen, katimbang nang yuu kay nag̱asapet na. Dispuis pa, kung tinu pay magsapet tung yeen, katimbang nang yang nagtuw̱ul tung yeen, ya kay nag̱asapet na. Kipurki tung numyung tanan, kung tinu pay mapinagparanek, ya ray pinakalandaw tung pagterelengen yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Numanyan pagkagngel ni Juan tia, dayun dang nabngang nag̱ubligar ang mag̱aning, “Ginuu, nuntaa, may sasang taung naita yamen ang atia pala nag̱apagpalayas ta mga dimunyu ekel tung kagaeman mu ang yang aran mu yay ininambit na. Purisu dayun dang pinagsambeng yamen ay natetenged belag̱an kang lag̱ing ugpu yamen ang mga tauan mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mag̱aning ti Jesus ang minles, “Eey, dapat ang indi mi ra rin pinagsambeng. Tutal yang taung indi nganing pagbatuk tung yaten katimbang nang pagtaw̱ang ka tung yaten,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Taa numanyan, ti Jesus, kumus ag̱alenget-lenget da yang uras ang itinipu tung anya ang tanya pablag dang eklan duun tung langit, anday dumang binuat na, pinatenten na ra ilem yang isip nang magdistinu ra ka enged duun tung Jerusalem, maskin unu pay mapasaran na duun. ");
INSERT INTO tbk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Numanyan may pira pa nga tauan ang pinanuw̱ul nang mamagtukaw ra tung anyang mamagsimpan da yang tanan ang mga kaministiran na. Numanyan namagpanaw ra ka man ang namansiangay tung sasang baryu ang yang mga sakep na pulus Samarianen yang nasyun nira. ");
INSERT INTO tbk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Numanyan pagkainsapu yang mga taung atia ang yang rumbu ni Jesus anda duun tung nira, kung indi, duun enged tung Jerusalem, ya ray pinaglainan yang mga isip nira ang indi ra pinadayun nira na Jesus tung baryu nira. ");
INSERT INTO tbk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Numanyan pagkasinti yang mga tauan nang ti Santiago duruang mag̱ari ni Juan, ya ray namagkig̱a tung ni Jesus. Pagkatapus dayun dang nagtalimaan ang mag̱aning, “Ginuu, gustu mung pabungsaran da ilem yamen ta apuy ang supukun?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piru ti Jesus tanya, dayun dang nagbedleng tung nirang nag̱ampalar. ");
INSERT INTO tbk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yang pinakaw̱ut na, duun da ilem namagpadayun tung dumang baryu. ");
INSERT INTO tbk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Numanyan atiing pagparanawen nira tung dalan, may sasang taung nagprisintar tung ni Jesus ang mag̱aning, “Magpakignunutaw ra tung nuyung magpaugyat, maskin aria pa manganing,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mag̱aning ti Jesus ang minles, “Maayen pa yang mga dayap tung talun, may mga anas nirang siguradu, pati mga lamlam, may mga bayay nirang sadili. Indi ra ilem yuung pag̱aningen ang Maninga Tau ang anday pirmaminting pag̱elkanu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pagkatapus may sam bilug pa asan ang inimbitar ni Jesus ang inaning, “Magpakignunuta ra ka tung yeen ang magpaugyat.” Mag̱aning ka yang taung atiang minles, “Ameey, bakluaw ra magpakignunut tung nuyu, kung maimu ilem, tugtayaw ra kanay nuyung mulik ang para mapalg̱uru tung leyang ti tatay,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mag̱aning ti Jesus ang nagtuung tung baliw̱ad na, “Ipatug̱ay mu ra ilem tia tung duma ang pamanalugpatay pa tung Dios. Bag̱ay ang pisan tung nira ang mamagpalg̱ud tung leyang tung mga aruman nirang patay ra. Piru ta yawa, bilug̱un mu ra ilem yang isip mung magparakaw̱utun tung mga tau natetenged tung paggaraemen yang Dios ang naang baklung pag̱atukuru, kung ya pa ag̱aring mapalg̱uran da nira.” ");
INSERT INTO tbk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Atii, may sam bilug pa ka enged ang nagprisintar tung anyang mag̱aning, “Ginuu, magpakignunutaw ra tung nuyung magpaugyat. Ug̱aring kung maimu ilem tung nuyu, mulikaw ra kanay ang magpaske tung na nanay.” ");
INSERT INTO tbk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mag̱aning ti Jesus ang minles, “Indi mu ra ilem pambungun yang sasang manig̱aradu ang napges da tung kaling yang aradu ang pagkatapus yag baw̱alikid. Kipurki kung ya ray pambungun mu, indi ra magkabag̱ay ang palg̱uruna pa yeen tung paggaraemen yang Dios ang naang baklung pag̱atukuru,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Taa numanyan tung pira pang kaldaw, ti Ginuu ta nagpanulduk-tulduk si tung dumang mga tauan nang pitung puluk may durua ang para pamakdulan na ra ka ta mga katengdanan nira. Pagkatapus ya ray pinanuw̱ul nang mamagpanaw ra ta taludua-taludua nga tauan ang para mamagtukaw ra tung anya duun tung mga lansangan may tung mga baryu ang kumpurming nag̱aplanu nang bisitaan. ");
INSERT INTO tbk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Numanyan, baklu ra papanaway na yang mga tauan nang atii, pinampagngel na pa ta sasang pananglit ang mag̱aning, “Duru-durung mga tau ang simpan dang mamagpamati tung bitalaw. Yang kaalimbawaan nira, maning pa tung paray ang malapad ang arayeg̱en da. Piru durug kakulang yang mga manig̱ayeg. Purisu kumus yang Dios yay maning pa tung pag̱erekelen yang ayeg, mag̱ampuamu ra tung anya ang may duma pang matuw̱ul nang mamagtaw̱ang ta ayeg yang paray na. ");
INSERT INTO tbk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Purisu ala, magpanawamu ra tung pag̱ipanuw̱ulu tung numyu. Piru mangamanamu. Yang kaalimbawaan mi, yamu maning pa tung mga karnirung mga butu pa ang duunamu ra ipaangayayu tung mga taung maning pa tung mga kirung talunanen ta kaiseg. ");
INSERT INTO tbk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ug̱aring indiamu ilem mag̱ekel-ekel ta mga kuarta pati mga puyu-puyu ang pariu ka tung pag̱aekel-ekelan ta mga manigpalimus. Maskin mga sandalyas pang mga risirba mi, anda ray kaministiran ang mag̱ekel-ekelamu pa. Kidispuis pa, alimbawa kung may mga taung mabag̱as mi tung dalan, indiamu magpaerek-erek ang magpakalingat ang mangesen-kesen tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dispuis kung ariamu pang balayay ngangay, bakluamu ra magtakwal, aningen mi yang may balay ang ‘Yamung tanan ang pagtinir asan, puidiamu rang pakaayenen ta mupia yang Dios.’ ");
INSERT INTO tbk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pagkatapus, kung mamananged tanira tung ipagpakaw̱ut mi tung nira natetenged tung kaayenan ang atiang sinambit mi, tung nira ra ka man mag̱ineteg. Piru kung indi ra mamananged, indi ra ka mangapakinaw̱ang tung kaayenan ang atiang ipakdul da rin yang Dios tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dispuis pa, kung ariamu pang balayay patakwalay, ay duunamu ra ilem magdayun ang mag̱ineteg. Ang papaanenamu ra nganing nira, mamanganamu ra ilem ang anday dalenden mi. Ay yang sasang manigparakaw̱utun, bag̱ay kang asikasuen tung mga kaministiran na ang yay maning pa tung suul na. Indiamu ilem maglakted-lakted tung duma-rumang balay. ");
INSERT INTO tbk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dispuis kung ariamu pang lansanganay nga distinu, kung risibienamu nira, kumpurmi ilem yang ipapaan nira tung numyu, ya ray pasalamatan ming risibien. ");
INSERT INTO tbk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dispuis, kung tinu pay may mga laru tung lansangan ang atia, pampamaayenen mi. Panganingen mi ka dayun yang mga tau ang, ‘Atia, ya ray pruibang pagpailala ang kinaw̱utanamu ra ka man yang puirsa yang paggaraemen yang Dios ang baklu.’ ");
INSERT INTO tbk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Piru kung ariamu pang lansanganay nga distinu, kung alimbawa, indiamu ka enged risibien nira, tung paglua mi tung lansangan nira ang duunamu pa tung mga karsadag pagpanaw, yamu ra ag̱aaning tung mga taung atia, ‘Maskin apuk da ilem taa tung lansangan mi ang nadpet tung mga kakay yamen, pipien pa yamen ang ibutwan ang para asan da nga maladmaray mi ang yang kasalanan asan da ilem tung numyung mag̱ineteg. Piru naa w̱a yang dapat ang intindien mi. Pinakdulanamu ra ka ta lugar ming magpalg̱ud da rin tung paggaraemen yang Dios ang baklu, ang pagkatapus yamu kay panulmun.’ Maning tia, ya ray ianing mi tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iugtulu tung numyu, kung kaw̱utun da nganing yang uras ang ipagpabungkaras yang Dios tung tanan ang belag̱an mga tauan na ang para sintinsiaan na, malakan-lakan pa yang sintinsiang dangaten yang mga tag̱a lansangan ang Sodoma kay tung dangaten yang mga taung tag̱a maskin ay pang lansanganay ang kumpurming indi ra namagrisibi tung numyu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mag̱aning ti Jesus ang nagsugpat yang bitala na, “Iugtulu tung numyu, tung uri ta kaldaw, kanugun yang mabtangan yang mga taung tag̱a Corasin may yang tag̱a Betsaida. Kipurki kung duunaw ra rin tung Tiro may Sidon napagpalapus ta mga pruibang maktel ang pariu ka tung ipinagpaluaw duun tung mga lansangan nirang atia, siguru nabuay ra ka rin ang nangapanligna tung mga kasalanan nira. Nabuay ra ka rin ang nangapagsuut ta aw̱el ang magig̱ilek ang nangapagrumug ta kaw̱u tung mga tinanguni nira ang para asan da mamagpailala ang tanira pamanligna rang matuud. ");
INSERT INTO tbk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Piru maskin indi ka man nangapanligna, kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung tanan ang mga tau, malakan-lakan pa yang parusang dangaten yang mga tag̱a Tiro may Sidon kay tung dangaten yang mga tag̱a Corasin may tag̱a Betsaida. ");
INSERT INTO tbk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pati yang mga taung atiang tag̱a Capernaum, ya ka, kanugun ka yang mabtangan nira. Ay kipurki ang kanisip nira mamagkatinir da ta dengeg nirang mas abwat ang asta mamanungkuk da tung langit, ang pagkatapus duun da ka ilem mangalambeg tung pag̱aningen ang Hades. ");
INSERT INTO tbk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kapurisu ta yamung pag̱apanuw̱ulu, tandaan mi yang bitalaw. Kung tinu pay mamati tung numyu, katimbang nang yuu kay pamatien na. Piru kung tinu pay magpakuindi tung numyu, katimbang na kang yuu kay pangindian na. Kidispuis pa, belag̱an ilem yuuy pangindian na, kung indi, pati yang nagtuw̱ul tung yeen, ya kay pangindian na,” mag̱aning. Atia ya ray ipinampaetad ni Jesus tung mga tauan na baklu papanaway na. ");
INSERT INTO tbk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Taa numanyan tung pagbalik yang pitung puluk may dura nga tauan ang atia, pinangampayan da ta kasadyaan nirang duru. Mag̱aning yang balita nira, “Ginuu, maskin nganing yang mga dimunyung pamagpasilaw̱et tung mga tau, kung lalangan nganing yamen, antimanung mamananged dang lag̱ing mamaglayas ay natetenged tung kagaeman ang ipinagpiar mu tung yamen.” ");
INSERT INTO tbk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mag̱aning ti Jesus ang minles, “Anday dumang pagpamalaru tung pagparanangeren nirang atia tung numyu, kung indi, duun da nga bistu ang ti Satanas ang pagmangulu tung nira talagang lumagpak da ka enged tung uri. Manulad tung kudlap ang gulpi ra ilem ang lumagpak. ");
INSERT INTO tbk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kapurisu asan da ngaintindiay mi ang matuud ka man ang pinakdulanamu ra yeen ta kagaeman mi ang para madeeg̱an mi yang pag̱apanuw̱ul ni Satanas ang atia. Maskin durug kaansianu tanira ang katulad ka tung mga iraw, maskin madalit pa ang katulad ka tung mga sipitan, kayanan mi ka enged yang tanan ang puirsa nirang deeg̱en. Indiamu maunu pa tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ug̱aring ilem, kaministiran ang belag̱an masyadu ang yay ipagkalipay mi yang pagsurukuen yang mga dimunyu tung numyu, kung indi, yang pagkalipayan mi enged ang yamu rinisibiamu ra yang Dios ang yang mga aran mi ipinaglista na ra duun tung langit,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yang uras dang atii, ti Jesus pinaeyangan da yang Espiritu Santo ta kasadyaan nang duru ang nag̱ampu tung Dios ang mag̱aning, “Amang makagag̱aem tung tanan, mag̱ing tung kalangitan may tung katanekan man, durug dakul yang pagpasalamatu tung nuyu. Ay pinapaglaw̱uk mu ra yang isip yang mga taung pagtalig tung pagkamataku nira ang para indi ka ilem maintindian nira sigun tung paggaraemen mung naang baklu ang nag̱ipagpakaw̱utu. Ang pagkatapus binuskad mu yang isip yang mga taung mga inusinti ug̱ud mamaresmesan da nira yang mga bag̱ay ang atia. Salamat, Ama, ang nagkamaning da ka man ta maning tia, ay natetenged ya kang lag̱i ay uyun tung kalelyag̱an mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Numanyan pagkatapus na ta pag̱ampu, dayun dang nagpasanag tung mga tau ang mag̱aning, “Yang tanan ang atiang nag̱ipagpalatayu tung numyu, luw̱us dang ipinag̱intriga tung yeen ni Ama. Andang pisan ay nag̱asangkad yang kabag̱ay-bag̱ayan yang pagkabetangu ang yuuy pag̱aningen nang Ana na, kung indi, tanya ilem ang pag̱aningenung Amaw. Pati tanya, anda kang pisan ay nag̱asangkad yang kabag̱ay-bag̱ayan yang pagkabetang na ang tanyay pag̱aningenung Amaw kung belag̱an yuu ka ilem ang pag̱aningen nang Ana na pati yang kumpurming nag̱alelyag̱anung pabunayag̱an,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Numanyan, pagkatapus ta pagpasanag na tung mga tau, dayun dang nanalunga tung mga taung atiang nag̱apangugyatan na. Ay may iksen na tung nira ang indi na mapagngel tung kadaklan. Mag̱aning tung nira, “Teed mi tiang kaayenan ang nag̱ipakdul yang Dios tung numyung nag̱aita tung mga bag̱ay ang nag̱aita mi simanyan tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ag̱aningenamu ra yeen ta maning tia ay atiing tukaw pang mga panimpu, dakeleng mga manigpalatay yang bitala yang Dios pati mga adi pa ang duru ka rin ang kalelyag nirang mangaita yang nag̱aita mi numanyan tung yeen, ang pagkatapus indi ra ka naita nira. Duru ka rin ang kalelyag nirang mangagngel yang nag̱agngel mi numanyan tung yeen ang pagkatapus indi ra ka nagngel nira,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Taa numanyan may sasang pagpakigmaepet asan ang sag̱ad tung pinanubli tung mga kinaampu ang ya ray kumindeng ang nagtalimaan tung ni Jesus ang basi pa ra ilem matuung na. Mag̱aning, “Ameey, may gustuu rin ang magtalimaan tung nuyu. Unu pa w̱asu ay dapat ang buatenu ang para mapagpasapenaw tung Dios ang anday katapus-tapusan?” ");
INSERT INTO tbk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mag̱aning ka ti Jesus ang tuminuw̱al, “Abir, unu pay napabtang tung kasulatan? Unu pay pag̱intindi mu tung nag̱abasa mu asan?” ");
INSERT INTO tbk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tumuw̱al yang pagpakigmaepet, “Yang katuw̱ulan ang nag̱aintindianu maning taa: ‘Pabuyukan mi ta gegma mi ti Yawi ang yay Dios mi. Yang paggeregmaen mi tung anya dapat ang tedek ang pisan tung mga kinaisipan mi ang indi ka magtenakan. Ya ra kay papruibaan mi tung tanan ang mga buat-buat mi,’ mag̱aning. Dispuis may sam bilug pang mag̱aning, ‘Gegmaan mi yang mga aruman mi ang katulad ka tung paggeregmaen mi tung sadili mi,’ mag̱aning. Atia, yay nag̱askeanu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mag̱aning ka ti Jesus ang minles, “Tama ka man tiang tuw̱al mu. Kung yay pirming tumanen mu, atia mapagpasapena ra tung Dios ang anday katapus-tapusan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Numanyan yang taung atia, kumus naseekan da, yang gustu na, magdipinsa tung sadili na. Purisu dayun na sing tinalimaan ti Jesus ang inaning, “Piru Ameey, tinu pa enged ay arumanu ang dapat ang gegmaanu?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Numanyan anday dumang itinuw̱al ni Jesus tung anya, kung indi, nagpananglit dang mag̱aning, “May sasang taung nanliit tung Jerusalem ang minangay duun tung Jerico. Numanyan atiing panuldak da tung karsada, napanawan da ta mga tulisan. Pagdeep nira tung anya, dayun da nirang linuasan ta mga aw̱el na ang pagkatapus tinaraw̱angan da nira ta palu ang pinaepdan da ilem nira ta linawa nang gesye, baklu butwanay nira. ");
INSERT INTO tbk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Taa numanyan may sasa kang paring panuldak da ka tung karsadang atii. Numanyan pagkaita na tung taung atiang tinulisan, dayun na ra ka ilem ang linilingan ang tinakliw̱an. ");
INSERT INTO tbk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Utru si may sasa kang manig̱asikasu tung pagtuuan ang pinakalusu ang pagpanaw ka tung karsadang atii. Kaw̱utan na yang tinulisan, pinaalengtan nang tinelengan ang pagkatapus, tinakliw̱an na ra ka ilem ang binutwanan. ");
INSERT INTO tbk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Taa numanyan may sasang Samarianen ang pagpanaw ra ka tung karsadang atii. Kaw̱utan na yang tinulisan, pagteleng na, ya ra ngaildaw. ");
INSERT INTO tbk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Anday dumang binuat na, dayun na rang pinaalengtan ang binulung yang mga luka na. Ninagnag̱an na ra ta irinemen ang gesye, ang pagkatapus piniiran na ra ka ta lana, baklu putusay na ta sinabat. Pagkatapus ta pagbulung na, dayun na rang ipinasaay tung asnung atiang pag̱asaayan na ra rin ang ginuyuran duun tung balay ang darayunan ta mga dayuan ang para masikasu na duun. ");
INSERT INTO tbk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pangayag yang kaliw̱utan, dayun dang nanduuk ta kuarta tung puyu-puyu nang ipinakdul tung may balay ang mag̱aning, ‘Kung mga sarang tung nuyu, asikasuen mu ra kanay yang taung naa. Ug̱aring kung alimbawa magkakulang da yang ipinakdulu tung nuyu, kung pira pay magastus mu tung anya, yuu ray balang magbayad tung nuyu tung uman ang pagbaliku taa,’ ag̱aaning yang Samarianen duun tung may balay.” ");
INSERT INTO tbk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ag̱aaning ti Jesus ang nagsugpat yang bitala na tung pagpakigmaepet, “Ta, tung nuyung pag̱intindi, tung tulung atiing nagkarapanaw duun tung taung atiing tinulisan, tinu pa w̱asu tung nira ay nag̱ilala tung anyang yay aruman nang dapat ang gegmaan na?” ");
INSERT INTO tbk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mag̱aning yang pagpakigmaepet ang tuminuw̱al, “Siguru yang naildaw tung anya.” Tumuw̱al ti Jesus, “Ala, pati yawa, maning ka tia yang buaten mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Taa numanyan atiing pagpadayun da na Jesus yang pagparanawen nirang pamagdistinu tung Jerusalem, nanakluy ra kanay ti Jesus tung sasang baryu. May baw̱ay duun ang nag̱aranan tung ni Marta ang yay nag̱imbitar tung anyang magpadayun tung balay na. ");
INSERT INTO tbk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yang baw̱ay ang naa may ari nang nag̱aranan tung ni Maria ang ya ray luminupakpak tung pinagtalungaan nira ni Jesus ang para mamati tung pag̱itulduk na. ");
INSERT INTO tbk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ug̱aring naang aka na, yang isip na duru rag kalingalag tung pagsirimpanen nang duru. Purisu numanyan, anday dumang binuat na, nagpalenget dang nagkig̱a tung ni Jesus ang mag̱aning, “Ay yawa Ginuu, anda ra pala tung isip mu ang yang ariung atiang ya ra ilem aglupakpak asan, pinaw̱ayaanaw ra ilem anya tani tung tanan ang pagsirimpanenung naa? Purisu kung panganuguna ka w̱a tung yeen, aningen mu ra kanay ang magtaw̱ang da tani tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mag̱aning ka ti Ginuu tang nagtimales, “Aa Marta, midyu nag̱abegbeg̱an da ta mupia yang kulu mu. Duru-durung nag̱apatarantaan mu. ");
INSERT INTO tbk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Piru sam bilug ilem yang dapat ang impurtaen. Yang ipinalandaw ni Maria, ya ra yang durug tinlu ang indi ra enged mabawi tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Taa numanyan may dumang kaldaw ang ti Jesus pag̱ampu tung Dios duun tung sasang lugar. Numanyan pagkatapus yang pag̱arampuen na, mag̱aning yang sasang nag̱apangugyatan na tung anya, “Ginuu, tuldukayami kang mag̱ampu ang katulad ka tung binuat ni Juan ang manigbenyag tung mga tauan na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kapurisu, mag̱aning ti Jesus ang minles, “Kung mag̱ampuamu ra nganing tung Dios, maning taa yang ianing mi tung anya: ‘Ama, taw̱angayami ka ang para yang panggalang yamen tung nuyu mag̱atu tung pagkadios mung durung pisan agkasagradu. Gustu yamen ang tung makali ipabistu mu ra enged ang pisan yang paggaraemen mu tung tanan. ");
INSERT INTO tbk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pakdulayami ka yang kaministiran yamen ang mapangan tung kaldaw-kaldaw. ");
INSERT INTO tbk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dispuis, patawarayami ka, tung mga kasalanan ang nagkarabuat yamen tung nuyu ay natetenged ta yami nag̱apatawad da ka yamen yang kumpurming pagbuat ta kasalanan tung yamen. Indiami ka ilug̱ut mu tung mga maliliwag ang sukda ang muya indi masarangan yamen.’ Tung maning tiang palaksu ipausuyay mi yang pag̱arampuen mi tung Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Numanyan dayun da ti Jesus ang nagpananglit ang mag̱aning tung nira, “Ipabetangu, yamu may sasang ungkuy mi tung baryu ang ya ray pandampan mi tung tenganan ta law̱ii ang aningen, ‘Ungkuy, pablesay kanay ta tulung bilug ang tinapay. ");
INSERT INTO tbk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bakluaung kinaw̱utan ta bisita ang sasa kang ungkuyu ang alawid yang pinagliitan na. Kulangaw pa ka man ta mapapaanu tung anya.’ ");
INSERT INTO tbk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Magkatama w̱asung tuw̱alenamu ra anyang, ‘Aa ungkuy, indiaw ra pasilabtan mu. Yawa rag teteleng, siradu ra yang purta, lumbug̱anami ra nganing ang mamag̱ana. Ya pa ag̱aring mabangunaw pang mapamakdul tung nuyu, ungkuy?’ ");
INSERT INTO tbk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iugtulu tung numyu, alimbawa, maskin baliwalaen na pa yang pag̱inungkuyay mi, piru natetenged anday gustu nang mapaeyak tung kadaklan ang mga masigkabaryu mi, anday dumang buaten na, kung indi, magbungkaras dang lag̱i ang para magpakdul da yang kumpurming unu pay nag̱aministir mi tung anya. Ya pa yang Dios ang indi maskeng magkereng tung unur nang mag̱asikasu tung mga kaministiran mi? ");
INSERT INTO tbk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kidispuis pa, nani pa yang sam bilug ang ag̱ipaetaru tung numyu natetenged tung pag̱arampuen mi tung Dios. Kung unu pay pagkakulang mi, ya ray ingalukun mi tung Dios ta muya-muya. Atia, ipakdul na tung numyu yang nag̱aingaluk mi. Muya-muyang idangep mi tung anya yang nag̱asagyap mi. Atia, papag̱itaenamu ka anya yang nag̱asagyap mi. Kung ya ray pambungun mi yang taung muya-muyang managbalay, ay patakwalenamu ra ka anya. ");
INSERT INTO tbk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ag̱aningenamu ra yeen ta maning tia, ay kipurki kumpurming tinu pay mag̱ingaluk tung Dios ta muya-muya, ya ray pakdulan na. Kumpurming tinu pay magdangep ta muya-muya tung anya, ya ray papag̱itaen na yang nag̱asagyap na. Kumpurming tinu pay mambung tung taung muya-muyang managbalay, ya ray maning pa tung patakwalen na. ");
INSERT INTO tbk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yamung mga amaen, kung yang ana mi pandawat da ta ian tung numyu, magkabag̱ay w̱asu ang yang ipakdul mi, iraw? ");
INSERT INTO tbk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kung pandawat ta kiklug, magkatama w̱asu ang yang ipakdul mi, sipitan? ");
INSERT INTO tbk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ig disir kung yamu nganing ang mga taung pagkamali pa ngani, nag̱askeamu nganing ang magpakdul yang matinlu tung mga ana mi, ya pa yang Ama mi duun tung langit ang indi maskeng magpatinir tung Espiritu Santo tung kumpurming pag̱ingaluk tung anya?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Taa numanyan may dumang kaldaw ang ti Jesus nagpalayas da ta dimunyu ang yay nagpaapa tung taung atiang pag̱aekel-ekelan na. Purisu numanyan, pagkalayas da yang dimunyu, diritsyu rang nabitala yang taung atiang nag̱apa ra rin. Pagkagngel yang mga tau, ya ray naberengan nira ta mupia. ");
INSERT INTO tbk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piru may duma asan ang namansianing, “Natetenged ilem tung ni Satanas ang pagmangulu tung mga dimunyu, nag̱apagpalayas ta mga dimunyu yang taung atia!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yang duma may gustu nirang mamagtag̱am ta tuung tung ni Jesus. Purisu pirming pag̱asig̱-asig nirang magpaita ta pruibang liit tung langit ang para ya ray magpailala tung anyang talagang may kagaeman na ka man ang liit tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Numanyan ti Jesus, kumus nag̱askean na ra kang lag̱i kung unu pay laksu yang pag̱irisipen nira, dayun dang nagtuw̱al ang mag̱aning tung nira, “Ag̱askean mi, maskin ay pang inadianay, kung mamagkuruntraan da yang mga kinasakpan nang mamagbaratukan, makali ra ilem ang madiadu yang inadian ang atia. Maskin tung sam pamilya, kung magkuruntraan dang magsuruayan, diadu ra ka yang pagsarasaan nira. ");
INSERT INTO tbk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kapurisu kung tama yang numyung rasun ang ti Satanas yay pagpaktel tung yeen ang pagpalayas tung mga dimunyu, ig disir, pagsuruag-suag̱an da rin tanira yang mga dimunyung nag̱amanguluan na. Ya pa ag̱aring magdayun pa yang paggaraemen na? ");
INSERT INTO tbk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kidispuis pa kung tama yang numyung atia ang yuug paktelay ni Satanas, tinu pa kaya ay pagpaktel tung mga aruman ming pagpalayas ka tung mga dimunyu kung belag̱an ka tanya! Maski nganing yang mga aruman ming atia, puidi ra kang mamarik tung katadlengan ming atia. ");
INSERT INTO tbk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ug̱aring kung ya ka man yang Dios mismu yang pagpaktel tung yeen ang para mapagpalayasaw tung mga dimunyu, ig disir, duun da ka nga pruibaay mi ang kinaw̱utanamu ra ka man yang puirsa yang paggaraemen nang naang baklung pag̱atukuru. ");
INSERT INTO tbk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Para maintindian mi yang pagkinuntraay yamen ni Satanas, maning taa tung pananglit ang naa. Kung may sasang mupiang lalii ang armadung pisan ang yay pagbantay tung balay na, indi maunu pa yang mga ekel-ekel na. ");
INSERT INTO tbk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piru kung may sasang mas maktel tung anya ang yay manuyu duun tung anya, ya ray mandeeg tung anyang magpangalaw yang mga armas nang atiang panalig̱an na ra rin. Pati mga ekel-ekel nang pinanulisan na tung duma, pangkelan na ra ka ilem ang ipamarti-parti tung mga kaarumanan na. ");
INSERT INTO tbk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Intunsis kumus maning da ka man tia yang pagbinatukay yamen ni Satanas, kung tinu pay indi magpakigsasa tung yeen tung panagpunu tung mga tau, katimbang nang pagpakigkuntra tung yeen ang pagpangwasak tung nira ang para mas dang mamampalawid tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Numanyan dayun dang sinugpatan ni Jesus yang bitala nang mag̱aning, “Alimbawa, kung may dimunyung lumayas da tung sasang taung sinuutan na ra rin, unu pay mainabu? Anday duma, duun da ilem magpaalyu-alyu tung banwang palag-palag yang tau na, ay magsagyap da rin ta taung masuutan na. Piru kung anday maita na, maning taa yang ipagkesen-kesen na tung isip na: ‘Maayen pang magbalikaw ra ilem duun tung dating pinagtiniranung liniitanu.’ ");
INSERT INTO tbk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Numanyan tung pagbalik na, kaw̱utan na yang taung atiing liniitan na, yang kaalimbawaan na, maning pa tung sasang balay ang sinilig̱an dang ipinatayu-tayu yang mga garamiten. ");
INSERT INTO tbk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Purisu anday dumang buaten yang dimunyung atia, magpangkel da tung mga aruman nang pitu nga dimunyuan ang mas pang malain kay tung anya. Pagkatapus tanirang tanan, dayun dang mamagsuut tung taung atia ang para asan da mamagtinir tung anya. Purisu yang luaan na, mas dang maliwag yang malambeg̱an yang taung atia kay tung primiru ang sam bilug pa ilem din yang dimunyung pag̱ekel-ekel tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pagkaaning ni Jesus tia, may sasang baw̱ay asan ang pamati ang tininluan da ta mupia tung pagparasanag̱en nang atia. Purisu dayun dang nabnga ang nagpadakul yang busis nang mag̱aning tung anya, “Talagang pinakaayen da yang Dios ta mupia yang nangana tung nuyung nanalaana, ay natetenged tung nuyung ana nang ag̱ikadengeg na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mag̱aning ti Jesus ang minles, “Sabag̱ay tama ka man. Piru mas pang pakaayenen na yang kumpurming pag̱intindi tung bitala nang nag̱ipagpakaw̱utu ang pagkatapus ya ra kay magtumanen na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Taa numanyan atiing ya rag pagdulang agpagdulang yang kinadakel yang mga taung pamagsaragpun asan, napagbitala ra ti Jesus ang mag̱aning, “Durug kalain yang palaksu yang pag̱irisipen yang kadaklan ang mga tau simanyan. Pamagtag̱am ta reg̱es tung yeen ang magpaitaw ta pruibang makabew̱ereng ang para ya ray magpailala ang yuug tuw̱ulay ka man yang Dios. Piru indi ra paitaanu ta pruibang maning tia, puira pa tung sam bilug ang magkaanggid tung napanawan ni Jonas. ");
INSERT INTO tbk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kipurki tung napanawan nang atia, asan da nga pruibaay yang mga tag̱a Nineve ang tanya tinuw̱ul ka man yang Dios ang magparakaw̱utun tung nira. Pariu ka tung yeen ang pag̱aningen ang Maninga Tau. Ay may sasang mapanawanu ang asan da ka nga pruibaay mi ang yuu tinuw̱ul ka man yang Dios ang magparakaw̱utun tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kung kaw̱utun da nganing yang uras ang ipagsintinsia yang Dios tung mga tau ang tanirang tanan pampabungkarasen na, yang sasang baw̱ay ang yay manigmangulu tung sasang banwa ang ampir duun tung salatan atiing tukaw, ya ray pakdengen yang Dios ang sasa kang mulidung ipagpasunaid na tung mga taung katulad ka tung nainambitu nungayna ang duun da ka ipatielay na yang katadlengan nang magsintinsia tung nira. Kipurki yang baw̱ay ang atii, maskin alawid ang pisan yang banwang pinanliitan na, piru nagpaawat da ka enged ang nag̱angay taa tung banwa ta, basta mapagpamati ilem tung nag̱itulduk ni Adi Solomon ang makawawayang ta isip. Ang pagkatapus yang mga taung naang nainambitu, ag̱ad nani rang pisan tung tepad nira yang sasang taung landaw pa ta nag̱askean kay tung ni Adi Solomon ang ya kay pagturuldukun tung nira, ang pagkatapus indi ra ka nirag pamatien. ");
INSERT INTO tbk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Dispuis pa tung uras ang atia, pati yang mga taung atiing tukaw pa ang tag̱a Ninive, ya ra kay pakdengen yang Dios ang sasa kang mulidu ang ipagpasunaid na tung mga taung katulad ka tung nainambitu nungayna. Duun da ka ipatielay na yang katadlengan nang magsintinsia tung nira. Kipurki yang mga tag̱a Ninive, atiing pinagpakaw̱utan da ni Jonas, lag̱i-lag̱i rang namanligna tung mga kasalanan nira. Ang pagkatapus yang mga taung naang nainambitu, indi pa ka enged nag̱apanligna tung mga kasalanan nira, ag̱ad nani ra tung tepad nira yang sasang landaw pa tung ni Jonas ang pagparakaw̱utun ka tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ayw̱a, tinu pay nag̱aintindian ming tau ang magsindi ta kaas ang pagkatapus ya ra italukay na ubin ya ra sukluw̱ay na? Simpri asan ipabtangay na tung bistuan ug̱ud masanag̱an da yang mga taung pamagtakwal. Ya ray kaalimbawaanung pagparasanag̱en tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ipananglitu ra kanay tung mga tinanguni mi. Yang maning pa tung kaas na, ya ra yang mga mata mi. Kung masadlaw, pati intirung tinanguni mi, damay ra ka tung masadlaw. Piru kung makiklep, tay pati intirung tinanguni mi, umid da ka tung makiklep. ");
INSERT INTO tbk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kuidaw, pati mga isip ming maning pa ka tung kaas tung mga sadili mi ang kanisip ming malemek, nusias nag̱apateg̱as mi pa ka enged tung nag̱ipagpasanag̱u ra rin tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Piru kung yang pambungun mi, ya ra yang sasang taung masadlaw yang mata na ang yang intirung tinanguni na damay ra ka tung masadlaw ang andang pisan ay makiklep ang nag̱alaket, ig disir, kayananamu ra ka yeen ang pasanag̱an. Maning pa tung asanamu ra nga patingkalayu ta kaas,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatapus ni Jesus ta pagbitala, may sasang Pariseo ang yay nag̱imbitar tung anyang mamangan tung balay na. Purisu dayun dang nagpakled ti Jesus tung balay nang nagpakigsaru tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Numanyan yang Pariseong naa, durug dakul yang pagkabereng na tung ni Jesus ang ayw̱at indi ra nangug̱as yang kalima na ta magkabag̱ay baklu namisik yang pamangan. ");
INSERT INTO tbk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Numanyan pagkaita ni Ginuu ta yang pagkabereng yang Pariseong atia, dayun na rang inaning, “Abaa yamung mga Pariseo, duruamug kasinulipeten tung pagrilimpiuen mi tung mga tasa mi may tung mga pinggan mi sigun tung mga riglamintung atiang pinanubli mi tung mga kinaampu ta ang yang kanisip mi ya ray mauyunan yang Dios tung numyu. Piru naa pala yang tung pundu yang mga pupusukun mi, indi mi pala ag̱insapuen ang yay kargadung pisan ta mga malalain ang pagtirimaen. Kuw̱ali panalensenamu tung tanan ang bag̱ay sibaya malepes mi yang mga masigkatau mi. ");
INSERT INTO tbk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Midyu baliskad dang pisan yang mga pag̱irisipen mi. Ayw̱a, yang nag̱imu tung sagpaw ang yag dawalay belag ba ang pati yang tung adalem ang indi maita ya kay inimu na? Belag bang dapat ang ya kay intindien ming insapuen? ");
INSERT INTO tbk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Purisu yang tung sagpaw indi mi pagsulipeten ang limpiuan, kung indi, yang mas matinlung buaten mi, kung unu pay nag̱ipabtang mi tung tasa mi may mga pinggan mi, ya ray ipamarti-parti mi tung mga taung nag̱aliwag̱an. Indiamu ilem mabereng ang aningenamu ra yeen ang kung ya ray pabilug̱an ming usuyun, pati nganing yang tanan ang garamiten mi, limpiu ra tung pagterelengen yang Dios, maskin indi mi intraan pangug̱as sigun tung pinanubli ming atia. ");
INSERT INTO tbk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Piru ay pa w̱a? Yamung mga Pariseo, kanugun yang pagkabetang mi tung uri ay kipurki maski nganing yang mga luak ming gereg̱esyeng pisan ang ya ilem ag̱ipasaburay mi tung mga sera mi, pati yang tanan ang gurulayen mi, ya pay panepet-sepeten ming pamateng-patengen ta sam puluk ang parti ang para yang sang parti ya ray nag̱ibuluntad mi tung Dios. Piru yang nag̱ipatuman enged yang Dios tung numyu ang yamu ra rin ay magpabuyuk yang gegma mi tung anya ig ang yamu ra rin ay magbuat ta magkatama tung mga masigkatau mi, ya pay nagbaliwalaen mi. Dapat da rin ang ya enged ay pabilug̱an ming tumanen atiang may mga timbang na ang indi mi ka paw̱ayaan yang pagpalartien ming atia tung Dios ta yasampuluk ang parti. ");
INSERT INTO tbk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yamung mga Pariseo, kanugun yang pagkabetang mi tung uri. Kipurki yang pag̱asikad ming magsimba tung mga pagsaragpunan mi ang yamu pakleramung kumarung tung parada ang para maitaamu ra ta kadaklan ang mga tau ang yamu dayawen nirang duruamu kag katinuuen. Dispuis pa kung yamu mamasyar tung mga plasa, yang kalelyag mi ang pakigbag̱asanamu ta tanan ang mga taung kumustaen. ");
INSERT INTO tbk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yang sasa pang panganugunanu tung numyu ya taa. Yang kaalimbawaan mi yamu maning pa tung leyang ang pinanlug̱uran ta taung patay ang pagkatapus anday marka na. Ang masag̱iran ta mga tau, anday kaliw̱utan nirang asan da tanira nga mansaay ta sasang patay. Yang pisan yang kalimbawaan mi ay natetenged yang mga taung pamagpatulduk tung numyu, anda kay kaliw̱utan nira ang naa pala asan da ka tanira nga saliray tung mga ug̱ali ming sayud,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Atii, may sasang sag̱ad ang mataku tung mga urdinansang pinanubli ang ya ray suminublang ang mag̱aning, “Elat kanay, Ameey. Ang magbitalaa, anda kay pagpateng-pateng mu! Pati yami ag̱igapil mu kang nag̱insultuen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mag̱aning ti Jesus ang minles, “Pati yamung mga sag̱ad, ya ka, kanugun ka yang pagkabetang mi tung uri. Kipurki yang mga tau ya rag palbatay ming nag̱iksiren tung sari-sari ilem ang mga urdinansang inimu-imu mi ka ilem ang idinulang tung mga katuw̱ulan yang Dios. Kung tung mga sarakanen pa, imurat da ilem ang kayanan nira. Piru indiamu ka enged magtaw̱ang ta sakan, maskin tung madeen da ilem yang mga kalima ming magduul. ");
INSERT INTO tbk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Talagang kanugun yang pagkabetang mi tung uri. Buat na pa durung pagmaal mi tung mga manigpalatay yang bitala yang Dios ang tukaw sindu yang mga leyang ang pinanlug̱uran tung nira nag̱apaisa-isaan mi nganing ang nag̱apakdengan ta mga matitinlung pantiun. Piru yang mga kinaampu mi yay namagpangimatay tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Purisu asanamu ra pagpailala ang yang binuat nirang atii nag̱apauyunan mi ka gated taniray namagpangimatay, yamung may mga irinsia tung nira, yamu ray pagpaisa-isang pagtapus tung inimpisaan nira. ");
INSERT INTO tbk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kapurisu para matuungamu, ya taa yang disisiun yang Dios para tung numyu: Paangayanamu si ka anya tung mga manigpalatay yang bitala na ang yay magparakaw̱utun tung numyu ang katulad ka tung binuat na tung mga kinaampu ming tukaw ang para asanamu ra nga sukdaay na kung ya pa ag̱ari yang paggaralangen mi tung nira. Pagkatapus anday dumang buaten mi tung nira, yang duma ya ra ipaimatayay mi, yang duma ya ra pandeeg-deeg̱ay ming panigbakay. ");
INSERT INTO tbk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Purisu yang pagpakuindi ming atia tung nira, anday dumang pakaw̱utun na, tung numyu enged ang mga masigkanasyunu nga dilemay yang Dios yang dug̱u yang tanan ang mga manigpadapat yang bitala na, mag̱impisa pa tiing primiru tung ni Abel ang asta ra tung kauri-urian ang tung ni Zacarias ang yay inimatay yang mga kinaampu mi tung kakleran yang pagtuuan ang pinakalusu. Duun ka pa man mismu imatayay nira tung pag̱elaan yang karakulan na may yang midyu lamisaan ang atiang darasag̱an ta mga ayep. Iugtulu tung numyu yang kamatuuran, yamung mga masigkanasyunu numanyan tung panimpung naa, talagang tung numyu enged dilemay na yang kamatayen nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Dispuis pa yamung mga sag̱ad kanugun yang pagkabetang mi tung uri, ay dakulu yang panuw̱alan mi tung Dios. Ay yang maning pa tung liabi ang ipag̱abri mi ra rin tung linegdangan yang kasulatan, ipinlek mi ra. Purisu indi mi ra nag̱atultulan yang gustu nang ianing. Pati yang mga taung nag̱apanuldukan mi ang duru ka rin ang kalelyag nirang matultul, ya ra ilem ag̱intraay mi ta lingalag,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Taa numanyan, paglampud ni Jesus asan tung balay ang atiing pinamanganan na, pag̱ademtan da ta mupia naang mga Pariseo may naang mga sag̱ad tung pinanubli. Purisu nag̱apabalitektekan nirang nag̱apabalitektekan ta pagpaisplikar tung sari-saring bag̱ay ang para madeepan ilem nira ta puntus tung mga tuw̱al na, ang yay sarang ang mapadatelan nira ta kasalanan. ");
INSERT INTO tbk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Numanyan mintras nag̱apatareg̱esan nira ta pabalitektek ti Jesus, ya kay pagsaragpun yang mga taung liniw̱u-liw̱u ang asta pagliliked-likeran da ilem. Numanyan ti Jesus may gustu nang ianing ang teed ilem tung mga taung atiang nag̱apangugyatan na. Mag̱aning tung nira, “Kuidaw, indiamu ra enged mag̱usuy tung ug̱ali yang mga Pariseo ang yang kadagmitan tung nira pamagpatunu-tunu ilem. Muya masaliranamu ra ilem nira tung ug̱ali nirang atia ang yang kaalimbawaan na maning pa tung pampaleskag tung san masang tinapay ang gulpi ra ilem ang tumagmak ang indi ra masuspindian. ");
INSERT INTO tbk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Agpaamanenamu ra yeen ta maning tia ay natetenged anday nag̱atipig̱an ang indi luw̱awan, anday kay nag̱italuk ang indi makdekan. ");
INSERT INTO tbk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kapurisu kung unu pay inaning mi tung sikritu, magngel da ka enged tung publiku. Kung unu pay ialas-alas mi tung kakleran, mabandilyu ra ka enged tung kadaklan. ");
INSERT INTO tbk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga ungkuyu, iugtulu tung numyu, indiamu mag̱eled tung mga taung gustu nirang mangimatay tung numyu, ang ya ka ilem yang mga tinanguni mi ay sarangan nirang patayen, ang pagkatapus anda ra kay dumang mabuat nira tung numyung malain. ");
INSERT INTO tbk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kung indi, yang dapat ang eldan mi enged, ipakdeku ra tung numyu. Anday duma, ya ra yang kung tapusun na ra nganing yang linawa yang sasang tau, may pudir na pa tung uri ang mamlek tung anya duun tung impirnu. Atia, iugtulu tung numyu, yay mas pang dapat ang eldan mi. ");
INSERT INTO tbk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dispuis para tung indiamu mag̱eled tung buaten yang mga tau tung numyu, pademdeman mi ra ilem yang mga kutung ang mga balaynen. Indi w̱a, kung mangalangamu tung palingki, maskin limang bilug, durung pisan agkabaratu? Piru inding pisan nag̱apaw̱aya-w̱ayaan yang Dios, may sam bilug. ");
INSERT INTO tbk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ya pa yamung mga tauanu, paw̱aya-w̱ayaanamu pa anya? Ultimung mga bua mi ilem ngani pinamilang na rang tanan. Kipurki sasa may sasa tung numyu, mas maalamu tung Dios kay tung mga kutung ang paneng. ");
INSERT INTO tbk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kidispuis pa, iugtulu tung numyu, kung tinu pay mag̱ubligar tung katalungaan yang mga masigkatau na ang tanya sasa rang tauanu, ig disir ta yeen ang pag̱aningen ang Maninga Tau, kung kaw̱utun da nganing yang uras, yuu kay magpailala tung anya tung katalungaan yang mga angil ang pag̱apanuw̱ul yang Dios ang tanya sasa ra ka man ang tauanu. ");
INSERT INTO tbk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piru kung tinu pay mag̱ingwara tung yeen tung katalungaan yang mga masigkatau na ang tanya belag̱an tauanu, ig disir, ta yeen, yang buatenu, ingwaraenu ka tung katalungaan yang mga angil ang pag̱apanuw̱ul yang Dios ang tanya belag̱an ka man ang tauanu. ");
INSERT INTO tbk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Kidispuis pa tung mga taung ituw̱ulu tung numyung pampakaw̱utan yang Matinlung Balita natetenged tung yeen ang pag̱aningen ang Maninga Tau, kung tinu pay magpakuindi tung yeen, puiding pasinsiaen yang Dios basta pagsug̱atan na. Piru kung tinu pay manambing tung Espiritu Santong pagtandeg tung kinaisipan nang magpasirung din tung yeen, atia indi ra enged patawaren yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kidispuis pa kung lag̱unutunamu ra nganing ta mga tau ang para ipabistaamu ra nira tung mga pamagpakigmaepet duun tung mga pagsaragpunan nira ubin duun tung katalungaan yang ustisia, indiamu magpakabegbeg kung ya pa ag̱ari yang pagdipinsa mi tung mga sadili mi u kung unu pay maayen ang ituw̱al mi tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kipurki yang Espiritu Santong pag̱erekelen tung numyu, yay magpainunuku tung numyu tung uras ang atiang mainabu tung numyu, kung unu pay matinlung ituw̱al mi,” mag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Numanyan may sasang tau asan tung mga taung atiang buntun ang yay nagbugnu tung ni Jesus ang mag̱aning, “Ameey, maimu ilem, aningen mu ra kanay naa ti manung ang ipakdul na tung yeen yang partiu tung surublien yamen tung ni tatay yamen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mag̱aning ti Jesus ang minles, “Abee, yang taung naa! Ayw̱a, kanisip mu ang yuuy may pudir ang mag̱ariglu tung numyung durua ang para magpamarti tung numyu yang surublien mi tung ginikanan mi?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pagkatapus tia, dayun dang nagbira tung mga tau ang nagpasanag tung nirang mag̱aning, “Yamung tanan asan, mangamanamu ang indiamu mag̱amluk ang kuw̱ali manalensenamu tung maskin unu pang bag̱ayay! Kipurki yang matinlung pagpangabui yang sasang tau, belag̱an liit tung mga kaayenan ang sarang maeklan na tung kaliw̱utan ang naa, maskin unu pag kadakel,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pagkatapus, dayun dang nagpakdul ti Jesus ta sasang pananglit ang mag̱aning, “May sasang manggaranen ang puirti yang umintu yang kaluakan na. ");
INSERT INTO tbk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Simanyan, pag̱akesen-kesen na yang isip nang maning taa: ‘Unu pa kaya ay maayen ang buatenu? Kulang yang pagluug̱anu yang patebas yang kaluakanu,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Numanyan pagkatimbang na tung isip na, mag̱aning si tung sadili na, ‘Aa, nag̱askeanu ra yang buatenu. Pampatastasanu ra ilem yang mga tambuw̱uung pampadakulun, ang para bastanti ra yang pagluug̱anu yang tanan ang pruduktu yang kaluakanu pati mga garamitenu. ");
INSERT INTO tbk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Matapusu ra nganing ta pagpaubra, matimes dang pisan yang tanan ang kaministiranu, maskin pira-pira rang takun, indiaw ra ka enged kulangen. Maenayanaw ra ka tung tanan ang pag̱urubraenu, mapapsawaw ra ka tung kumpurming iblen yang linawaw, mapagustuaw ra kang mapagtarangwayanaming magbararkada ang para mapagpakasadyaami ta ustu,’ ag̱aaning. Atia, ya ray ipinagkesen-kesen na tung isip na. ");
INSERT INTO tbk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Numanyan mag̱aning yang Dios tung anya, ‘Naa pala, anday isip mung pagkatau! Indi mu nag̱askean? Muyang law̱ii, bawienu ra yang kabui mung ipinablesu ra ka ilem tung nuyu. Ta, yang tanan ang atiang pinagluug mu, tinu pa pa w̱asu ay makinaw̱ang?’ ag̱aaning yang Dios tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Purisu yang pisan ay kaalimbawaan yang taung pagtuw̱ud dang pagtuw̱ud ta manggad, ang pagkatapus, belag̱an kang manggaranen tung nag̱auyunan yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Numanyan dayun dang nanalunga ti Jesus tung mga taung atiang nag̱apangugyatan nang nagsugpat yang bitala na. Mag̱aning tung nira, “Purisu ya man taang nag̱ipag̱aningu tung numyu, ang indiamu enged magpakabegbeg ta kulu natetenged tung pagpangabui mi, kung ariamu pa mangkel ta mapangan mi, u kung ya pa ag̱ari yamu mangkel ta aw̱el ang masuut mi tung mga tinanguni mi. ");
INSERT INTO tbk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kipurki telengan mi. Pinakdulanamu ra nganing yang Dios yang mga linawa mi. Ya pang pamangan mi ilem, indiamu sarangan nang pakdulan? Pati mga tinanguni mi, pinakdulanamu ra ka nganing anya. Ya pang aw̱el mi ilem, indiamu sarangan nang paablan? ");
INSERT INTO tbk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Telengan mi ra ilem yang mga lamlam. Indi pamagtugda, indi ka pamangayeg. Anda kay mga pagtalukan nira ta pamangan ang para luug nira tung timpung pamig̱a-pig̱a. Piru indi ka pangalulutan, ay natetenged ag̱asikasuen yang Dios. Pagkatapus yamung mas maal tung anya kay tung mga lamlam, indiamu ka w̱asu asikasuen na? ");
INSERT INTO tbk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sam pulukamung magpakabegbeg ta mga kulu mi, inding pisan mataw̱ang ang mapalagway tung mga kabui mi basin tung sang uras ilem. ");
INSERT INTO tbk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kapurisu kung indi mi nganing kayanan yang gesyeng bag̱ay ang atiang sang uras ilem, ya pa yang dumang bag̱ay ang pabegbeg̱an mi pa? ");
INSERT INTO tbk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kidispuis, kung natetenged tung pag̱araw̱elen mi, isipen mi ra kanay yang mga talay. Indi pagpakabedlay tung tanek, anda kay tiral ang pag̱ubraan nira ta mga aw̱el nira. Piru iugtulu tung numyu, maski nganing ti Adi Solomon ang yay nag̱askean tang pinakamanggaranen atiing tukaw ang durung pisan agkatitinlu yang mga bisti na, yang katitinlu na inding pisan temepeng tung katitinlu yang mga talay ang naa. ");
INSERT INTO tbk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kidispuis pa, kung yang ilamunun ka ilem nganing ya pay nag̱apatinlu yang Dios ang nag̱apaeyangan ta mga talay ang simanyan yag dawalay mi ang pagkatapus mangayag yang kaliw̱utan, puiding sirukun da ka ilem, ya pa yamu, indiamu pa kayanan nang patinluen ang paablan? Masyadug kageg̱etey yang pagtaralig̱en mi tung Dios! ");
INSERT INTO tbk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Purisu ta yamu, indiamu ra magpakalingalag natetenged tung mga pagpangabui mi. Belag̱an ya tia ay pabegbeg̱an mi. ");
INSERT INTO tbk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Indi mi sakaen yang kadaklan ang mga tau tung bilug ang kaliw̱utan ang alawid pa tung Dios ang alus pa ilem ya ra ilem ay pag̱asikad nira tung kaldaw-kaldaw. Yang indi mi ipagpakabegbeg ta mga kulu mi tung pangabui mi, ay natetenged yamu may Ama mi ang yay nag̱askeng pisan kung unu pay mga kaministiran mi. ");
INSERT INTO tbk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kung indi, yang ipalusu ming sikaren ang yamu pirming magparanek ang magpagaem tung Dios. Atia, kung yay sikaren mi, tay puis tanya ray balang mag̱arasikasuen tung tanan ang mga kaministiran mi ang ya ra rin ay nag̱aliw̱eg̱an ta mga kulu mi. ");
INSERT INTO tbk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yamung mga tauanu ang pirming nag̱abantayanu ang pariu ka tung sasang kaayepan, tung bag̱ay gesyeamu ka man ilem, anday puirsa mi tung kaliw̱utan ang naa kung ikumpalar pa tung mga darakulung mga tau. Piru indiamu ra ilem magpatalaw. Kipurki uyun ang pisan tung isip ni Ama ming palg̱urunamu ra anya tung mga kaayenan ang ipinagsimpan na tung kumpurming pagpagaem ang bug̱us tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Purisu ipaalang mi yang mga ganadus mi. Yang kabayaran na, ipamakdul-pakdul mi tung mga maliliwag̱en. Ay maning ka tia yang pagtaralukun mi ta manggad duun tung langit ang anda ray kaluw̱us-luw̱usan na. Kung duun yang manggad ming ipinagtaluk mi, indi maalengtan ta takawan, indi ka mapangan ta andap. ");
INSERT INTO tbk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Purisu maayen pa duunamu ra ilem magtaluk yang manggad mi. Kipurki kung ariamu pa magmanggad, duun da ka nga gamen yang mga isip mi,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Kaministiran ang yang pambungun mi, ya ra yang mga turuw̱ulun ang pamag̱elat tung ag̱alen nira ang duun manliit tung sasang kumbirang pinasakpan na. Yang pagpakbat nira tung anya, pirming riparasiun ig pirming dekal yang mga kaas nira ug̱ud kung kumaw̱ut da nganing tanya ang gumuuy tung nira, alistu ra ilem ang abrian nirang pakleren. ");
INSERT INTO tbk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Kung tinu pay mga turuw̱ulun nang kaw̱utan nang pamagpulaw, durug dakul yang kaayenan ang ipakdul na tung nira. Maskin tenganan da ta law̱ii yang ipagkaw̱ut na, maskin alenget dang mangayag, ang tanira pamagpulaw pa ka enged, anday dumang ibles na tung nira, tanya ra mismu ang ag̱alen nira ya pay mag̱asikasu tung nirang maglamisa. ");
INSERT INTO tbk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Naa w̱a ya ra kay sasang isipen mi. Yang sasang may balay, kung naskean na ra rin yang uras ang ipagkaw̱ut yang takawan, indi na ra rin pinaw̱ayaan ta pamangbang yang balay na, kung indi, pinulawan na ra rin ang binantayan ta mupia. ");
INSERT INTO tbk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Purisu ta yamu kaministiran ang pirmiamung riparasiun tung ipaglekatu. Ay ta yeen ang pag̱aningen ang Maninga Tau, yang uras ang ipaglekatu inali. Muya matuun tung uras ang yang laum mi indiaw pa malkat,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Numanyan mag̱aning ti Pedrong nagtalimaan, “Ginuu, tinu pay ag̱apatemengan mu tung ipinananglit mung atia? Yami ilem ang mga tauan mu u maskin tinu pa?” ");
INSERT INTO tbk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Numanyan mag̱aning ti Jesus ang nagtimales, “Yang sasang turuw̱ulun ang katalig̱an ig mawayang ta kinaisipan, ya ray nag̱apiaran yang ag̱alen nang mag̱erekelen tung mga kaarumanan nang mga turuw̱ulun ug̱ud yay mamarti-parti yang mga pamangan nira ang kada kaw̱utun yang ipagkaministiran nira. ");
INSERT INTO tbk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Teed mi tiang kasadya yang isip yang turuw̱ulun ang atia kung kaw̱utan da yang ag̱alen nang pag̱intindi tung itinuw̱ul nang atia tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iugtulu tung numyu, ya ray piaran yang ag̱alen na tung tanan ang prupidad na. ");
INSERT INTO tbk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piru, ipabetangu, kung yang turuw̱ulun ang atiang nag̱ianingu, maning taa yang kesen-kesen yang isip na, ‘Aa, siguru mabuay pang kumaw̱ut yang ag̱alenu.’ Ang pagkatapus mag̱intra ra pamalu tung mga masigkaturuw̱ulun na, tig lalii tig baw̱ay, pariu ilem yang aplit na, ig pagustuan na ra ilem yang linawa na tung tanan ang mga pamangan ang masasabur ig magpakigbarkada ra ka tung mga taung mga tarainem, atia aparti kusas. ");
INSERT INTO tbk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pagkatapus numanyan inaling kaw̱utan yang ag̱alen na tung uras ang inding pisan nabantay ang andang pisan ay laum-laum nang kumaw̱ut da. Anday dumang buaten yang ag̱alen na tung anya, kastiguen nang anday kategkaan na. Duun da ipaugpuay na tung mga taung belag̱an kang katalig̱an. ");
INSERT INTO tbk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Utru si ipabetangu si, kung may kirepen ang maskin nag̱aintindian na yang itinuw̱ul yang ag̱alen na tung anya, piru inding pisan nanalugkamay ang para magtuman da rin, anday dumang buaten tung anya, paburdunan da ta mupia yang ag̱alen na. ");
INSERT INTO tbk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piru yang sam bilug ang indi nakdek kung unu pay kalelyag̱an yang ag̱alen na, ang pagkatapus napagbuat ta kamali ang yay dapat ang masalapuan na ka ta paburdun, paburdunan ka, piru malakan-lakan pa tung ipinakdul tung sam bilug. Kung tinu pay piniaran yang Dios ta dakele, sagyapan na ka ta dakele. Kung tinu pay piniaran na ta mas dakele kay tung mga aruman na, dileman na ka ta mas dakele kay tung nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Yang inangayu taa tung kaliw̱utan ang naa, magpagkalaw ta maninga sasang apuy. Basi pa ra ilem ang tung makali madeetan da. ");
INSERT INTO tbk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piru baklu ra madeetan dang magdekal, kung napasaranu ra yang pinitinsiang malbat ang yay dapat ang pasaranu. Baklu ra lumakan yang isipu kung yuu napasar da. ");
INSERT INTO tbk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ayw̱a, kanisip mi ang yang inangayu taa ang para yang tanan ang mga tau mamag̱uruyunan dang mamagsarasaan? Iugtulu tung numyu, anday dumang dangaten na, mamagsuruag-suag̱an da natetenged tung pagpabetang nira tung yeen ang indi enged magkapariu. ");
INSERT INTO tbk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ayw̱a indiamu paamanenu sindu anday dumang pakaw̱utun na, mag̱impisa ra simanyan puiding may sam pamilya ang limang mamag̱ana ang magberelag ta kinaisipan may kinaisipan natetenged tung yeen. Puidi ang yang tulu mamagpasirung tung yeen, yang durua ya ra kay mamagpakuindi. Ubin yang durua mamagkereng tung yeen, yang tulu ya ra kay mamagkuntra. ");
INSERT INTO tbk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ang kaisan yang mga mamaepet yay mamagpasirung tung yeen, ang yang mga ana nira, mamagpakuindi. Ang kaisan yang mga mamula yay mamagpasirung tung yeen, ang yang mga ginikanan nira yay mamanambing. Ang kaisan tung magpurungyangan, yang mga mamaepet yay mamagpasirung tung yeen, ang yang mga minag̱ad nira, indi. Ang kaisan yang mga minag̱aren yay mamagpasirung tung yeen, piru yang mga punyangan nira yay mamagpakuindi. Purisu magsuruag-suag̱an dang magberelag ta kinaisipan natetenged tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Taa numanyan ti Jesus dayun dang nagbitala tung mga taung atiang buntun ang pamagtaripukpuk tung anya ang mag̱aning, “Kung mabandaw mi ra nganing yang galem ang pag̱unup dang ampir tung abag̱at, diritsyuamu rang mag̱aning ang kumuran da buay-w̱uay. Ang pagkatapus kumuran da ka man. ");
INSERT INTO tbk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kidispuis kung mag̱eyep da nganing yang salatan, mag̱aningamu ka ang manginit da ta duru. Ang pagkatapus manginit da ka man. ");
INSERT INTO tbk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Matakuamu nganing ang magpamalad tung nag̱aita mi tung kaliw̱utan may tung kalangitan, piru yang palaksu yang pagkarainabu tung panimpu tang naa, indiamu pala maskeng magpamalad yang nag̱adapatan na? ");
INSERT INTO tbk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ayw̱a kaya indiamu maskeng magtimbang-timbang tung mga isip mi kung unu pay dapat ang buaten mi tung mga uras ang naa? ");
INSERT INTO tbk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Para maintindian mi yang dapat ang buaten mi, magpananglitaw ra kanay. Ipabetangu, may utang ming dakulu tung sasang tau. Piru kumus panginluasamu ang anday nautangan mi, anday duma, eklanamu ra ilem anya duun tung ustisia. Maayen pa indiamu ra mag̱elat, kung indi, atiang lag̱i ang duunamu pa tung dalan, magsukuamu rang lag̱i tung anya. Indiamu ra mag̱aning ang taw̱en da intindiay mi ang yamu duun da tung katalungaan yang usgadu. Kipurki kung duunamu ra nganing, masintinsiaanamu ra nganing anya, anday duma, ipiaramu ra ilem anya tung sasang pulis ang yamu ra iplekay na duun tung kalabus. ");
INSERT INTO tbk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iugtulu tung numyu, indiamu ka enged palpasan ang asta indi mi mabayaran yang utang ming luw̱us ang andang pisan ay pagkakulang na, may sang iki. Yang pisan ay kaalimbawaan mi simanyan ang mga uras ang naa,” ag̱aaning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yang uras dang atii, may mga taung namagpalenget da tung ni Jesus ang namagbaw̱alitaen natetenged tung mga taung tag̱a Galilea ang ipinagpaimatay ni Gubirnadur Pilato atiing pagpadasag nira ta mga ayep ang nag̱iprisintar nira tung Dios duun tung pagtuuan ang pinakalusu. Purisu yang dinangat na, yang dug̱u nira may yang dug̱u yang mga ayep ang atiang nag̱ipadasag nira naglalaketan da ilem duun. ");
INSERT INTO tbk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mag̱aning ti Jesus ang nabalitaan, “Ayw̱a, yang kanisip mi tia ang yang kamatayen ang atiing nalambeg̱an nira, ya ray pruiba ang tanira mas pang naklew̱an ta kasalanan kay tung kadaklan ang mga kaarumanan nirang tag̱a Galilea? ");
INSERT INTO tbk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Belag kang maning tii! Kung indi, iugtulu tung numyu, pati yamung tanan taa, kung indiamu enged manlignang lag̱i tung mga kasalanan mi, pati yamu, masapulamu ra ka tung kalainan. ");
INSERT INTO tbk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pati yang sam puluk may walu nga tauan ang atiing naktangan yang laturi duun tung Siloe, muya maning si ka yang laum mi tung nira, ang kumus maning da tii yang kamatayen ang nalambeg̱an nira, purisu ya ray pruiba ang tanira mas pang naklew̱an ta kasalanan kay tung kadaklan ang mga kaarumanan nirang pamag̱istar ka duun tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Belag kang maning tii! Kung indi, iugtulu tung numyu, pati yamung tanan taa, kung indiamu enged manlignang lag̱i tung mga kasalanan mi, pati yamu, masapulamu ra ka tung kalainan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Atii, dayun dang nagpakdul ta sasang pananglit ang mag̱aning, “May sasang tau ang may sang kapungul ang pag̱aningen ang igus duun tung kaluakan na. Numanyan tinelengan na yang igus na kung may burak na. Naa pala, anday burak na. ");
INSERT INTO tbk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Purisu dayun na rang ginuuyan yang manig̱asikasu nang inaning, ‘Teed mu! Pagpanaw ra tung tulu rang takun yang pagpabalik-baliku taang panginsapu tung igusung naa kung may burak na, piru anda enged ang pisan ay nag̱aitaw, may sam bilug. Maayen pa pelaren mu ra ilem. Linget da ilem taa tung tanek ang kindengan na ang anda ka ilem ay pakinaw̱ang tung anya,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mag̱aning ka yang manig̱asikasu ang nagtimales tung ag̱alen na, ‘Kung yuu pay patimbangen mu, maayen pa siguru ang paw̱ayaan ta ra kanay ilem. Pamalaran ta ra kanay ta seled san takun. Yang buatenu, kalug̱anung paliw̱ut, pagkatapus pabtanganu ra ta mga abunu. ");
INSERT INTO tbk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Basi pa ra ilem ang mamurak taa tung matakun. Piru kung indi pa ka enged mamurak, baklu ra ituw̱ulay mu tung yeen ang pelaren,’” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Taa numanyan, may dumang kaldaw ang nag̱ipamaenay ang ti Jesus pagparakaw̱utun da tung mga tau duun tung pagsaragpunan nira. ");
INSERT INTO tbk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Naa pala duun may sasang baw̱ay ang pagpasakep ka ang tung seled sam puluk may walung takun pag̱aekel-ekelan ta dimunyu ang yay pagpabuktut tung anya ang indi ra manuklid. ");
INSERT INTO tbk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Numanyan pagteleng ni Jesus tung anya, dayun na rang ginuuyan ang magpalenget. Tung pagpalenget na, dayun na rang inaning, “Ipag, libria ra tung pag̱alaru mung atia.” ");
INSERT INTO tbk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yang pag̱aning nang atia, ya ra kay pagdeen na tung anya. Pagdeen na tung anya, lag̱i-lag̱ing nanuklid da yang pagkererengen na ang pagkatapus duru rang pagdarayawen na tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Numanyan yang sasang pagmaepet-epet asan, duru rang kasilag na tung ni Jesus natetenged yang kaldaw ang nag̱ipamaenay, ya ray ipinag̱ubra na buat ang nagpamaayen tung baw̱ay ang atia. Purisu diritsyung nagbitala tung mga taung pamagsaragpun asan ang mag̱aning, “Tung seled san linggu, nag̱apakdulanita ra yang Dios ta enem ang kaldaw ang yay dapat ang ipag̱ubra ta. Purisu yang mga kaldaw ang atia, ya ray ag̱ipagdangep mi tung sasang tau ang para pamaayenenamu anya, belag̱an tung kaldaw ang nag̱ipamaenay ta,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Numanyan ti Ginuu ta, yay nagtuw̱al tung anya, “Abaa yamung pag̱aning ang duruamug katinuuen tung Dios, piru naa pala pagpakaayen-ayenamu ilem. Pati nganing yamu, maskin kaldaw ang nag̱ipamaenay, nag̱abadbaran mi nganing yang baka mi ubin asnu mi ang para maguyuran mi duun tung wai ang papaigmen. ");
INSERT INTO tbk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya pa taang baw̱ay ang naa ang sasa pa ka man ang kanubli ni apu tang Abraham ang katulad ka tung yaten, ang tung seled sam puluk may walung takun, maning pa tung kinemkem ni Satanas, indi w̱a yay dapat ang taw̱angan ang ipapuklut tung kagaeman na, maskin natuun da ka man tung kaldaw ang nag̱ipamaenay ta?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Numanyan tung itinuw̱al ni Jesus ang atia, yang mga taung atiang pamagkuntra tung anya, luw̱us dang nangapaeyak ta mupia. Piru yang kadaklan ang mga taung atiang buntun, durung pagkalipay nira natetenged tung tanan ang atiang pag̱abuat ni Jesus ang durung pisan agkatinlu. ");
INSERT INTO tbk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pagkatapus tia, ti Jesus nagpadayun da yang pagparakaw̱utun na tung mga tau ang mag̱aning, “Tung unu pa w̱asu ipananglitay ta yang palaksu yang paggaraemen yang Dios ang baklu tung mga tau? Tung unu pa w̱asu ipapariuay tang yay mag̱atu ta maayen? ");
INSERT INTO tbk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Puiding ipananglit ta tung lisu ta mustasa ang ingkelan yang sasang taung ipinanakbul tung sular na. Pagkatapus may tuminubu rang nagyari rang sasang ayu ang yang mga lamlam duun da mamagbayay tung mga sanga na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Numanyan nagsugpat si ti Jesus yang bitala nang mag̱aning, “Tung unu pa si ipananglitay ta yang palaksu yang paggaraemen yang Dios ang baklu tung mga tau? ");
INSERT INTO tbk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Puiding ipananglit ta tung pampaleskag ang ilinaket yang sasang baw̱ay tung sang palangganang arina ang pag̱abuat nang tinapay ang asta pinaleskag na yang intirung pag̱amasa na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Taa numanyan, sigi-sigi yang pagparanawen ni Jesus ang yang rumbu na duun tung Jerusalem. Yang bida na, panakluy-takluy tung mga lansangan pati mga baryu ang pagparakaw̱utun yang bitala yang Dios tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Taa numanyan may nagtalimaan tung anyang mag̱aning, “Ameey, gesye ilem w̱asu yang mga taung tapnayen yang Dios ang ipalibri tung sintinsia na?” ag̱aaning. Numanyan yang itinuw̱al ni Jesus, tung nira rang tanan iparumbuay na. ");
INSERT INTO tbk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Mag̱aning, “Yang kalibrian maning pa tung may purta nang durug kapiet. Purisu kaministiran ang ya imurasay ming selselay ang para mapakleran mi. Kipurki iugtulu tung numyu, duru-durung mga tau ang mamagtag̱am ang mamagpakled din, piru indi mangapakled. ");
INSERT INTO tbk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ay yang purtang naang nag̱ianingu, kung kaw̱utun da nganing yang uras ang yang may balay kemdeng da nganing ang magsiradu, ta yamu, asanamu ra ilem tung lua magkererengan, ang yang kanisip mi abrianamu pa ka anya. Ang pagkatapus ang indiamu abrian na, magtag̱amamu ra ilem ta guuy ang mag̱aningamu tung anya, ‘Ameey, kung maimu ilem, paklerayami ka asan.’ Piru tuw̱alenamu ra ka ilem anyang aningen, ‘Indiamu nag̱ailalaw kung tag̱a ariamu pa. Anday kalalabten mi tung yeen!’ ");
INSERT INTO tbk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pagkatapus dayunamu rang magriklamu tung anyang mag̱aningamu, ‘Elat kanay, “‘Ameey. Belag bang nagpakisaruami ra tung nuyu? Belag bang nagpamatiami ra ka tung nuyung pagturuldukun tung mga banwa yamen? Umpat indiami ra nag̱ailala mu?’ ");
INSERT INTO tbk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piru tuw̱alenamu si anyang aningen, ‘Iugtulu tung numyu, indiamu nag̱ailalaw kung tag̱a ariamu pa. Anday kalalabten mi tung yeen! Paaw̱ig̱amu ra taa tung yeen, ay ta yamu, nagpadayunamu ra ka enged tung mga ubra-ubra ming malalain tung pagterelengenu,’ ag̱aaning. Maning ang pisan tia yang ituw̱alu tung numyu tung uri. ");
INSERT INTO tbk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pagkatapus, kung maita mi ra nganing yang mga kinaampu tang na Abraham, ni Isaac, may ni Jacob pati yang tanan ang mga manigpalatay yang bitala yang Dios ang tukaw ang pamagsararuan da tung kaliw̱utan ang baklu ang nag̱agaeman da yang Dios, ang pagkatapus yamu ag̱ipapaw̱ig̱ay duun tung lua, mag̱intraamu rang magtarangiten ang nunut da ka ta pangereketek mi. ");
INSERT INTO tbk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dispuis pa, may mga tau kang tag̱a maskin ay pang banwaay ang tag̱a duma-rumang nasyun ang ya ra kay panlugtan yang Dios ang mamagpakigsaru ka tung nira asan tung baklung kaliw̱utan. ");
INSERT INTO tbk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Indiamu mabereng ang aningenamu ra yeen ang may mga taung pag̱atelengan ang aranek numanyan ang tung uri ya pay ipampaabwatay ig may mga tau kang pag̱atelengan ang abwat simanyan ang tung uri ya pay ipamparanekay,” mag̱aning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yang uras dang atiing pagbitala ni Jesus, may mga Pariseong baklung namansikaw̱ut ang ya ray namagbaw̱alitaen tung anyang mag̱aning, “Maayen pa, magliita ra ilem taa. Ay ti Adi Herodes ang yay may kagaeman taa, nag̱atimaana ra anya ang yawa ipaimataya ra ilem anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mag̱aning ka ti Jesus ang nagtuw̱al, “Durug kaidya pala yang Ading naa. Aningen mi ang papatandaan na ta mupia yang bitalaung naa. Yuu magpadayunaw pa kanay tung pag̱urubraenung naang pagpalayasaw tung mga dimunyu tung mga tau kag pagpamaayenaw tung may mga laru ig may uras ka man ang kaw̱utun ang ya ray ipagtapusu tung mga pag̱urubraenung naa. ");
INSERT INTO tbk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ug̱aring naa w̱a yang gustuung ianingu tung numyu. Dapataw pa kanay magpadayun yang pagparanawenung naa ay natetenged yang sasang manigpalatay yang bitala yang Dios indi enged magkabag̱ay ang imatayen tung ay pa, kung indi, duun enged tung siudad ang Jerusalem,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Numanyan atiing pagkasambit ni Jesus yang siudad ang atiang Jerusalem, ya ra manganugun ang mag̱aning, “Aay yang mga taung naang tag̱a Jerusalem, kanugun yang pagkabetang nira tung uri. Kada paangayan yang Dios tung mga manigpadapat yang bitala na, ya ra ileg batway nirang imatayay. Pira-pira rang bisis ang gustuu rin ang managpun tung nira ang katulad ka tung manung inayen ang pag̱ayupup tung mga butu na. Piru indi ra ka enged mangalelyag ang mamagpaayupup tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Naa w̱a yang dapat ang isipen nira. Yang siudad nira ang kanisip nirang indi ra maunu pa, paw̱ayaan da ilem yang Dios ang ilug̱ut tung kadiaduan. Talagang indiaw ra maita nirang uman ang asta kaw̱utun da ilem yang uras ang ipag̱ilala ka enged nira tung yeen ang ustu ang nunut da ka ta pag̱ingaluk nira tung Dios ang yuung pag̱atuw̱ul nang mag̱erekelen yang kagaeman na, pakaayenenaw ra kang pirmi anya,” mag̱aning ti Jesus duun. ");
INSERT INTO tbk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Taa numanyan, may dumang kaldaw ang nag̱ipamaenay ang ti Jesus inimbitar da ta sasang pagpakigmaepet tung mga Pariseo ang para magpakigsaru duun tung balay na. Numanyan yang mga imbitasiun nang duma, nag̱amalungan nira ta mupia ti Jesus kung unu pay urubraen nang lampas tung riglamintu nira sigun tung kaldaw ang atia. ");
INSERT INTO tbk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naa pala may sasang laliing nagpakigtalunga tung ni Jesus ang paglambuk yang mga tinanguni na. ");
INSERT INTO tbk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Numanyan ti Jesus, tanya, dayun na rang binugnu yang mga kasadu nang atiang mga Pariseo pati mga sag̱ad tung pinanubli. Ag̱aaning tung nira, “Elat kanay, kung mga sarang tung numyu, unu pay pag̱intindi mi tung katuw̱ulan natetenged tung kaldaw ang nag̱ipamaenay? Uyun w̱asu ang yang taung paglaru puiding pamaayenen, u bawal?” ");
INSERT INTO tbk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Numanyan pagkagngel nira yang itinalimaan nang atia, inding pisan namag̱iw̱ek-iw̱ek. Pagkatapus, anday dumang binuat ni Jesus, diritsyu rang dineenan na yang taung atia ang pinamaayen. Pagkatapus tinugtan na rang mulik. ");
INSERT INTO tbk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Numanyan dayun na rang pinakdulan ta pag̱isipan nira yang mga kasadu nang atia ang inaning, “Alimbawa kung may sasang ana mi ubin baka mi ang nabugsu tung bug̱ang, indi mi w̱asu bataken ang lag̱i ang ipalua maskin natuun tung kaldaw ang nag̱ipamaenay ta?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Atii, andang pisan ay mabitala nira, may san tag̱a. ");
INSERT INTO tbk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","8","Numanyan nag̱apaniiran ni Jesus yang mga aruman nang mga imbitasiun ang pamagkaralaw tung mga puistung nag̱itig̱ana para tung darakulung mga tau. Purisu dayun dang nagpakdul ta sasang alimbawa ang mag̱aning, “Alimbawa, kung imbitarenamu ra nganing ta sasang taung magpasakep tung kumbira yang ana na, maayen pang indiamu magpilik ta mga puistung nag̱itig̱ana na para tung darakulung mga tau. Muya may kumaw̱ut dang dumang inimbitar na ang mas abwat ta pagkabetang tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anday duma, palengtanamu ra anyang aningen ang, ‘Ungkuy, indi ilem maglain yang isip mu. Ipatug̱ay ta ra tia tung aruman tang naang baklung kaw̱ut.’ Unaw̱is maeyakamu ra ka ilem ang magpapuistu tung binit. ");
INSERT INTO tbk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kung indi, yang mas maayen pang usuyun mi, kung imbitarenamu ra nganing tung sasang punsiun, ay duunamu ra kanay ilem magpapuistu tung binit. Ay tia, kung may gustu yang may punsiun, palengtanamu ka anyang aningen ang ‘Ungkuy, tania ra magpapuistu tung alenget-lenget tung yeen.’ Ta, indi magkadengeg̱anamu ra tung katalungaan yang kadaklan ang mga kasadu mi? ");
INSERT INTO tbk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ay ya pa ag̱ari, kung tinu pay pagpalandaw tung sadili na, ya iparanekay, piru kung tinu pay pagparanek tung sadili na, ya ipalandaway,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Numanyan dayun na rang inaning yang nag̱imbitar tung anyang mag̱aning, “Ungkuy, tung dumang uras, kung mag̱imbitara ra nganing tung mga tau tung balay mu ang para mamagsararuanamu ra, india magpilik ang maning ya ra ilem yang mga barkada mu may yang mga putul mu may yang may mga kaampiran tung nuyu may yang mga kamalay mung maraayen ka ta pagkabetang. Kipurki anday dumang pakaw̱utun na, balesena si ka ilem nirang imbitasiunun. Asana ra ka ilem nga balesay tung binuat mu. ");
INSERT INTO tbk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kung indi, yang pangimbitaren mu enged, ya ra yang mga maliliwag̱en, yang mga barik, yang mga pilay, asta yang mga buray. ");
INSERT INTO tbk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ay kung yay buaten mu, talagang pakaayenena ra yang Dios, ay kipurki maskin anda ka man ay mables nira tung nuyu, balesana ka enged yang Dios tung uras ang ipagpabungkaras na tung mga taung kumpurming matadleng tung pagterelengen na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Taa numanyan yang sam bilug ang kasadu ni Jesus, pagkagngel na tia, dayun dang nabnga ang mag̱aning tung anya, “Tama ka man tia, pakaayenen da ka man yang Dios yang kumpurming tugtan nang magpakigsaru tung punsiun ang dakulu ang tukurun na tung uras ang ipagpabistu na ra enged yang paggaraemen na tung kaliw̱utan ang baklu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pagkagngel ni Jesus tia, dayun dang nagtimales ang nagpagngel ta sasang pananglit ang mag̱aning, “May sasang taung pagtukud ta punsiun nang dakulu ig dakele ra yang mga taung pinangimbitar na. ");
INSERT INTO tbk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Numanyan pagkaw̱ut da yang uras ang ya ray tipu yang pagpunsiun na, nanuw̱ul da tung sasang turuw̱ulun nang mag̱aning, ‘Panliguen mu ra yang tanan ang mga taung pinangimbitaru. Panganingen mu ang mag̱arangayan da, ay simpan da yang tanan ang bag̱ay,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Numanyan tung paglig̱u yang turuw̱ulun na, naa pala sasa may sasa tung mga imbitasiun yang ag̱alen na, masigbaliw̱ad da ang indi ra masakep. Mag̱aning yang sam bilug ang nagbaliw̱ad, ‘Aningen mu ti ungkuy ang tanya ra kanay ay balang magpasinsia tung yeen ta dakulung pagpasinsia. Indiaw masakep, ay bakluaung nangalang ta tanek. Kaministiran angayenu ra kanay ang telengan,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mag̱aning ka yang baliw̱ad yang sam bilug, ‘Aningen mu ti ungkuy ang tanya ra kanay ay balang magpasinsia tung yeen ta dakulung pagpasinsia. Indiaw masakep, ay bakluaung nangalang ta limang pariang mga baka. Kaministiran ang angayenu ra kanay ang para maprubalanung iaradu,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yang sam bilug kang imbitasiun, yang anyang baliw̱ad maning taa: ‘Bakluaw ilem ang pisan nga kasawa. Purisu indiaw ra siguru masakep,’ ag̱aaning. Maning dang maning yang baliw̱ad yang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Numanyan pagkatapus yang turuw̱ulun ta paglig̱u na, dayun dang nagbalik tung ag̱alen nang nagbaw̱alitaen. Pagkagngel yang ag̱alen na, durung kasilag na. Dayun sing nanuw̱ul tung turuw̱ulun nang mag̱aning, ‘Ala, pakalia rang maglilig̱uen tung mga karsada taa tung lansangan, pati mga dalan pabalik-balikan mu. Kung tinu pa man ay mapanawan mung maliliwag̱enay, kung mga barik, basin mga buray, ubin mga pilay man, ya ray pangkelan mu taa,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Numanyan indi ilem nabuay yang turuw̱ulun na ta paglig̱u, asan da tung anya nagbalik ang mag̱aning, ‘Ameey, tinumanu ra yang itinuw̱ul mu tung yeen. Piru kulang pa midyu, malugar pa yang balay ta,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Numanyan diritsyu sing nanuw̱ul yang ag̱alen na tung anyang mag̱aning, ‘Kung malugar pa, maayen pa lumua kanay duun tung mga kabiw̱init-binitan, maskin ay pang dalanay patungul paranek man, yay usuyun mu. Kumpurming tinu pa man ang tauay mapanawan mu, yay pangimbitaren mung magpasakep tung punsiun ta ug̱ud getek dang pisan ta tau yang balay ta,’ ag̱aaning yang ag̱alen na tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Atia, ya ray pananglit ang nagngel mi ra tung yeen. Purisu iugtulu tung numyu, kumpurming tinu pay imbitarenu ang pagkatapus ya ray pangindian na yang pag̱imbitaru tung anya, indi ra enged mapagpakigsaru tung punsiun ang tukurunu tung uri,” ag̱aaning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Numanyan ti Jesus nagpadayun da yang pagparanawen na. Durug dakel yang mga taung pamagpakignunut tung anya. Numanyan dayun dang nagtadeng ti Jesus ang nagbedleng tung nirang nanalunga. ");
INSERT INTO tbk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mag̱aning tung nira, “Kung tinu pay magpalenget tung yeen ang para magpaugyat da tung yeen, kaministiran yuuy ipalusu na enged tung tanan ang nag̱agegmaan na ang katulad ka tung ginikanan na ubin tung kasawa na ubin tung mga ana na ubin tung mga putul na ang kapin da enged tung sadili na. Kaministiran ang yang gegma na tung yeen lusu enged ang pisan ang kung ikumpalar pa tung gegma na tung duma, ya ra ag̱aningay nirang demet. Kung belag maning tiag kalusu yang gegma na tung yeen, indi pa ka enged maimung magpaugyat tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kung tinu pay indi magpakatenten ang mag̱agwanta tung mga kaliwag̱an ang maskin ipalansang pa tung krus, yang taung atia indi ka enged puiding magpaugyat tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Talagang matuud tia, ay kipurki maskin tung numyu, kung may sam bilug asan ang malelyag dang magpakdeng ta balay nang dakulu, simpri baklu impisaay na, ipaenay na ra kanay ang ipamateng-pateng kung pira pay magastus na ang para maskean na kung yang kuartang natuw̱ud na bastanting ipagpatapus na tung balay na u kung kulangen. ");
INSERT INTO tbk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ay kung indi na ra pateng-patengen ang ya ra ileg kali-kaliay nang impisaan ta pakdeng yang mga adili na, muya indi na ra ka ilem mapatapus yang balay na. Kung tinu pay magteleng asan, intraan da ilem nira talangkak ang mag̱araning-aningan ang ‘Abaa yang taung nakaa! Naimpisaan na ra ta pakdeng yang balay na, piru naa pala, indi na ra ka ilem masarangan ang mapatapus,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Utru si ipabetangu, may sasang ading pag̱isip dang magbatuk tung gira. Yang ading naa may mga sundalu nang mga sam puluk ang liw̱u nga tauan. Yang ading kabatuk nang pag̱ayat ta gira, may mga sundalu nang duruang puluk ang liw̱u nga tauan. Simpri baklu magpadayun yang sam bilug tung panuyu na, ipaenay na kanay ang ipamateng-pateng ta mupia kung kayanan nirang talungaen yang kuntrariu nira. ");
INSERT INTO tbk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kung mapateng-pateng na ra nganing ang midyu indi nira masarangan, anday dumang buaten na, mintras alawid pa yang kabatuk na, manuw̱ul da tung mga tauan nang mamagpakigbag̱as da duun tung Ading sam bilug ang panuyu ra ang para mamagpakigkesen da kung unu pay kundisiun ang para indi ra idayun yang gira. ");
INSERT INTO tbk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kapurisu ya ra ka man tiang nag̱ipag̱aningu tung numyu, maskin tinu pa asan tung numyu ang indi manalyud tung tanan ang nag̱amaal na ang para yuuy ipalusu na ta gegma na, ay tia, indi pa ka enged puiding magpaugyat tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Maskin tung kasin puidi kang ipananglitu. Kung tung bag̱ay masabur ang gamiten. Piru kung magkasa-kasa ra natetenged nalaktan da ta dumang bag̱ay, anda ray rimidyung sarang mabuat ang para maulikan pa yang pagkatema na. ");
INSERT INTO tbk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Indi ra ka tia magamit tung dumang bag̱ay, maskin iabunu pa, basin ilaket pa tung tarambakan ang pangkelan ta abunu, andang pisan ay gamitan na. Kung indi, anday dumang buaten asan, iplek da ilem. Kapurisu, kung tinu pay ag̱agngel, ipabalay na ra tung isip na yang nag̱agngel na,” ag̱aaning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Taa numanyan durung mga taung namagpalenget tung ni Jesus ang para mamagpamati tung nag̱itulduk na. Ya ra yang mga manigpanukut ta mga balayaran tung gubirnu pati yang dumang atiang pag̱atelengan ka ta duma may ruma ang teleb ang pisan ta kasalanan. ");
INSERT INTO tbk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","May duun kang mga Pariseo may yang mga sag̱ad tung pinanubli. Pagkaita nira tung ni Jesus ang midyu durung kalelyag na tung mga taung mga maning tia, dayun dang namagburutung-butungan ang namag̱araning-aningan ang mag̱aning, “Yang taung naa durug ka sayud yang pag̱abuat na. Pagpakibarkada pala tung mga taung atiang anday kuinta ang punuk ang pisan ta kasalanan. Pagpakisadu pa ngani tung nira!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Numanyan pagkasiman ni Jesus yang laksu yang pag̱irisipen nira, dayun dang nagpagngel tung nira ta mga pananglit. ");
INSERT INTO tbk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Mag̱aning ti Jesus tung nira, “Ipabetangu may asan tung numyung sasang manigpastur ta kaayepan ang sang gatus nga karniruan. Numanyan ang bilangen na, naa pala may sam bilug ang nalsik. Unu pa w̱asu ay buaten na? Simpri anday dumang buaten na asan, yang siam ang puluk may siam, butwanan na ra ilem kanay duun tung pangaraw̱an nira ang italig tung mga aruman na ug̱ud naang sam bilug ang naplek, ya ray dilemen na ang asta maita na. ");
INSERT INTO tbk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Numanyan, kung maita na ra nganing, anday duma, saknen na ra ilem ang mulik ang pagkasadya ra ta duru. ");
INSERT INTO tbk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Numanyan kumaw̱ut da nganing tung balay, dayun dang mag̱imbitar tung mga kamalay na may tung mga ungkuy nang mag̱aning, ‘Aliamu ra, mangayamu ra tani! Magkalipayitaamu ra. Ay yang karniruung naang naplek, naitaw ra.’ Maning tia ya ray ianing na tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iugtulu tung numyu, maning kang pisan tia duun tung langit. Mas magkalipay yang Dios tung sam bilug ang makinasalananen ang panligna ra tung mga ubra-ubra na kay tung siam ang puluk may siam ang buat na pa maraayen ang mga tau ang yang kalaum nira anday kaministiran nirang manligna,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Mag̱aning ti Jesus ang nagsugpat, “Utru si ipabetangu si, may sasang baw̱ay ang may kuarta nang sam puluk ang bilug ang pulus nigal, ang pagkatapus naplek da yang sam bilug. Ta, unu pa w̱asu ay buaten na, kung indi, magsindi ra kanay ta kingki, pagkatapus dayun na rang silig̱an yang balay nang magdilem ta mupia tung kuarta na ang asta maita na. ");
INSERT INTO tbk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Numanyan kung maita na ra nganing, dayun dang mag̱imbitar tung mga kamalay na may tung mga ungkuy nang mag̱aning, ‘Aliamu ra, mangayamu ra tani, magkalipayitaamu, ay yang kuartaung naang naplek, naitaw ra.’ Maning tia ya ray ianing na tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Purisu iugtulu tung numyu, maning kang pisan tia tung mga angil ang pag̱apanuw̱ul yang Dios. Kung maita ra nganing nira yang sasang tau ang makinasalananen ang panligna ra tung mga ubra-ubra na, durug dakul yang kasadyaan nirang pamagteleng tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mag̱aning si ti Jesus ang nagsugpat, “Utru si ipabetangu si, may sasang maepet. Yang maepet ang naa, duruay ana nang lalii. ");
INSERT INTO tbk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Numanyan mag̱aning yang gesye tung ni tatay na, ‘Tatay, ipakdul mu rang lag̱i numaan tung yeen yang partiu ang masubliu tung nuyu,’ mag̱aning. Purisu numanyan yang maepet, nagpauyun da ilem ang namarti yang intirung ganadus na tung nirang duruang mga ana na. ");
INSERT INTO tbk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Numanyan yang gesye, indi pa ilem nabuay tung kalima na yang anyang kaparti, ipinaalang na ra, ang pagkatapus yang bayad nang kuarta ingkelan na rang naglayas duun tung alalawid ang banwa. Ang duun da, sigi ra ilem yang pagwaraswasen na yang kuarta na tung mga barkada na ang anda ray pamateng-pateng na. ");
INSERT INTO tbk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Numanyan atiing nalw̱usan da ta kuarta na, kinaw̱utan da ta puirting panuw̱uk yang banwang atiing pinaglayasan na. Purisu pati tanya nadamay ra ka duun ang nagkaliwag ta duru. ");
INSERT INTO tbk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Purisu kumus alang-alang da yang pagkabetang na, anday dumang naisip na, nagpalenget da tung sasang tau ang tag̱a duun. Ya ray pinag̱amu-amu na ang maskin anday suul na, basta papaanen da ilem tanya. Purisu anday dumang ipinakdul tung anyang trabaw, yang kaaranekan ang pisan, manigbuug da ilem tung mga baw̱uy. ");
INSERT INTO tbk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Numanyan kumus kulang yang nag̱ipapaan tung anya, maski nganing yang mga burak ang atiang mapakit-pakit ang nag̱apapangan yang mga baw̱uy, ya ray nalelyag̱an nang mabialan na ra rin. Basin maning da tii yang pagkabetang na, piru anda ka enged ay nagteleng tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Numanyan atiing namanmanan da, pinagkesen-kesen na ra yang isip nang maning taa: ‘Duun tung ni tatay, kadakel yang mga ubrirus na ang pagustu ilem yang pamangan nira. Piru yuu taa, yuu ra ag̱alulutay! ");
INSERT INTO tbk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maayen pa magpanawaw rang mulik duun tung ni tatay. Maning taa yang bitalaenu tung anya, “Ama, nagbuataw ta kasalanan ang durug dakul tung Dios, pati tung nuyu. ");
INSERT INTO tbk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Indi ra enged magkabag̱ay ang aningenaw pa nuyung ana mu. Maayen pa, ipaklerayaw ra ilem nuyung sasa ra ilem ang ubrirus mu.”’ Atia, ya ray ipinagkesen-kesen na tung isip na. ");
INSERT INTO tbk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kapurisu numanyan, nagpanaw ra ka man ang minulik duun tung ni tatay na. Numanyan atiing alawid-lawid pa tung baryu, nabandaw ra ni tatay na. Pagkabandaw na, inampayan da ta kaildaw nang duru. Anday duma, ya rag paglaksung pagpakigbag̱as tung ana na, ang pagkatapus ya ra ngalw̱u tung anyang inara-araan ta mupia. ");
INSERT INTO tbk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pagkatapus dayun dang nagbitala yang ana nang mag̱aning, ‘Ama, nagbuataw ta durug dakul ang kasalanan tung Dios, pati tung nuyu. Indi ra enged magkabag̱ay ang aningenaw pa nuyung ana mu,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Numanyan yang maepet, dayun dang nagkalalangan tung mga turuw̱ulun nang namanikad da ka tung anya ang mag̱aning, ‘Ala, kalitan mi ra kanay ang eklan yang aw̱elung atiing langkuy, atiing pinakamatinlu. Ya ray ipasuut mi taa tung anaw. Pati yang titingu, eklan mi ra kang ipasuut tung tulduk na, asta sapatusu pa, ya ka, eklan mi ra kang ipasuut tung kakay na. ");
INSERT INTO tbk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pati tiang sinday tang baka ang pinatambek ta, eklan mi ra ka duun tung balay ang imatayen. Ay magpasalamatitang magkumbira. ");
INSERT INTO tbk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kipurki yang anaung naa, yang kanisipung pisan patay ra, piru maning pa tung nabui sing uman. Naplek da rin tung yeen, ang pagkatapus naitaw si,’ ag̱aaning ti tatay na. “Purisu numanyan duun tung balay namag̱impisa ra tanirang namagsararuan. ");
INSERT INTO tbk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yang uras dang atii, yang ana yang maepet ang dakulu, duun tung kaluakan pag̱ubra. Pagkatapus numanyan atiing ag̱ulik da rin ang alenget da tung balay, naa pala, may nagngel na rang pamagkarantaan tung kakleran, may nasirib na pang pamagtaralekan. ");
INSERT INTO tbk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Numanyan anday dumang binuat na, ginuuyan na yang mulang lalii ang pamagkarayam tanira yang mga aruman na asan tung lua. Pagpalenget yang mula, pinabalitaan na kung unu pa kaya ay nag̱adapatan na tii. ");
INSERT INTO tbk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mag̱aning yang mulang minles, ‘Yang ari mu takaa ra, minulik da. Purisu ti ama mi nagpaimatay ra yang sinday ming baka ang pinatambek mi, ay natetenged tung ari mung naulik dang maayen ang tinanguni,’ ag̱aaning duun yang mula. ");
INSERT INTO tbk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Numanyan, pagkagngel na tia, nasilag da ta duru. Anda ra enged ay gustu nang magpakled pa tung balay. Piru ti tatay na ya pa ka enged ay naglua ang nag̱intra ra alam-alam tung anya ang para magpasakep tung kumbira. ");
INSERT INTO tbk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piru tinabkaw yang ana nang inaning, ‘Teed mu, tung tantung kabuay rang pira-pira rang takun yang pagpakirepenu tung nuyu, indiaw ang pisan naglampas tung katuw̱ulan mu may sam bilug. Piru indiaw ang pisan pinakdulan mu ta maskin kambing da ilem ang para mapagkalipayami ka rin yang mga barkadaw. ");
INSERT INTO tbk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pagkatapus pagbalik yang ana mung nakaa ang yang manggad mu ya ra ilem durug̱asay nang iginastus tung mga baw̱ay ang impurtada, pagkatapus ya pa ka enged ay pinaimatayan mu yang sinday tang baka ang pinatambek ta?’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mag̱aning ti tatay nang nagtuw̱al, ‘Abaa, anaw, pirmia taa tung yeen. Purisu yang tanan ang bag̱ay taa tung ganadus ta nuyu kang lag̱i. ");
INSERT INTO tbk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Piru indi maimu ang yang ari mu indi ta ipagkasadya ang kumbiraen ay natetenged yang kanisip ta tia patay ra, ang pagkatapus maning pa tung baklu sing nabui. Naplek da rin tung yaten, ang pagkatapus naita ta si,’ ag̱aaning yang maepet duun tung ana nang dakulu. Atia, ya ray mga pananglit ang painu-inuan mi ta maayen,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Utru si nagpagngel si ti Jesus ta sasang pananglit tung mga taung nag̱apangugyatan nang mag̱aning, “May sasang manggaranen. Yang manggaranen ang naa, may kubransadur na. Numanyan naugtul da tung manggaranen ang yang kamanggaran na unu nag̱apalangaasan da yang kubransadur na. ");
INSERT INTO tbk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Purisu anday dumang binuat yang manggaranen, dayun na rang pinaguuyan yang kubransadur nang inaning, ‘Unu pa taang nag̱adengel-dengelu ang natetenged tung nuyu?’ Yang kubransadur na, inding pisan nag̱iw̱ek-iw̱ek. Mag̱aning si yang ag̱alen na tung anya, ‘Buinu, ipakdul mu ra tung yeen yang tanan ang listaan yang mga agsaduru, ay indi ra puidi ang yawa magpadayun pa tung pagkakubransadur mu taa tung yeen.’ ");
INSERT INTO tbk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Numanyan dayun dang luminampud yang maning kubransadur na rin. Yang mabtangan na ya ray ipinagkesen-kesen na tung isip nang maning taa: ‘Abaa, ya ra ag̱ari w̱asu taa, naang magkuatenaw ra pa man yang ag̱alenu tung pagkakubransaduru? Indiaw ka pa man makayan ang mag̱agsa, makakaeyak kang magpalimusaw. ");
INSERT INTO tbk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, nag̱askeanu ra yang pagpalusutanu. Kung yay magdayun yang planuung naa, maskin paliitenaw ra nganing tung ubraw, may mga tau kang mag̱asikasu tung yeen tung mga pamalay-w̱alay nira,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Purisu numanyan yang binuat na, yang tanan ang atiang mga agsadur ang may mga paraulikan tung ag̱alen na, luw̱us dang pinampaguuyan nang sasa may sasa ang kinsen. Numanyan yang primirung kuminaw̱ut, tinalimaan na ang, ‘Ta, magkatama ka taa yang paraulikan mu tung ag̱alenu?’ ");
INSERT INTO tbk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mag̱aning ka yang agsadur ang nagtuw̱al, ‘Ee, walung gatus ka man ang galun ang lana.’ Mag̱aning ka yang kubransadur, ‘Ia, yang listaan mu. Kumarunga ra kanay asan. Umanen mu yang nabtang asan. Epat da ilem ang gatus yang ilista mu asan. Kali-kalien mu, aa?’ ");
INSERT INTO tbk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pagkatapus, pagkaw̱ut yang nagdasun, tinalimaan na kang, ‘Ta, magkatama ka taa yang paraulikan mu tung ag̱alenu?’ Mag̱aning ka yang agsadur ang nagtuw̱al, ‘Ee, sang gatus ka man ang sakung trigu.’ Mag̱aning ka yang kubransadur, ‘Ia, yang listaan mu. Umanen mu, walung puluk da ilem yang ilista mu asan.’ Maning dang maning yang binuat na tung nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Numanyan tung pagpakdul na yang mga listaan tung ag̱alen na, naskean da yang ag̱alen na kung unu pay binuat na. Pagkatapus ya rag dayaway na yang kubransadur na rin ang mandaraya, belag̱an natetenged tung pagdarayaen na, kung indi, natetenged ginamit na yang isip na. Kipurki duru ka man agtaku yang mga taung pamagpaguyud tung sistimang pangkaliw̱utan tung pagpakignunut nira tung mga masigkatau nira. Kung isip-isipenu, midyu magdereeg̱en nira ta kataku yang mga taung namampalakted da tung kasadlawan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mag̱aning si ti Jesus tung nirang nagsugpat yang bitala na, “Taa numanyan, may gustuu pang ianing tung numyu. Gamiten mi yang manggad ming pangkaliw̱utan ang itaw̱ang tung mga putul ming pagparakaw̱utun natetenged tung yeen. Ay kung ya ray buaten mi, kung kaw̱utun da nganing yang uras ang anda ray kaministiran mi, yang kumpurming nagkarataw̱angan ming para magkatinir da ka ta kalibrian, duru rag sadya yang mga isip nirang mamagpakigbag̱as tung numyu duun tung sasang pamalay-w̱alay ang ya ray pagnatisan ming tanan ang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kipurki yang taung matalig̱an, maskin tung gesye ilem ang bag̱ay, maski tung dakulu, puidi kang matalig̱an. Piru yang taung indi nganing matalig̱an maskin tung gesye ilem ang bag̱ay, maskin tung dakulu, indi ra ka enged matalig̱an. ");
INSERT INTO tbk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kapurisu kung indiamu matalig̱an tung manggad ang pangkaliw̱utan simanyan, ya pa ag̱aring matalig̱anamu tung matuud ang manggad tung uri? ");
INSERT INTO tbk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ig kung indiamu matalig̱an tung belag̱an kang lag̱ing numyung sadili ang ya ka ilem kanay nag̱ipaepetay yang Dios tung numyu, ya pa ag̱aring matalig̱anamu anya tung kaayenan ang pag̱ielat na ang ya ra rin ay gustu nang ipasadili tung numyu? ");
INSERT INTO tbk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yang sasang tau, indi enged maimung magbilug yang isip na kung duruay pangag̱alenan na. Ay kung durua, anday dumang mainabu, yang sam bilug ya ray maalen nang panirbian ta ustu, piru yang sam bilug, ya ray silag̱an nang duminaren. Purisu asan da ngaintindiay mi ang kung manggad yang nag̱apagamenan mi, indi enged maimu ang yang Dios ya pay mapanirbian mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Atii pala, may mga Pariseo asan ang tung pagkagngel nira yang tanan ang atiang inaning ni Jesus, dayun da nirang dinag̱esan. Ay ya pa ag̱ari, tanira durug kaamluk tung kuarta. ");
INSERT INTO tbk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Purisu ti Jesus, dayun dang nagtuw̱al tung nirang mag̱aning, “Yamu, yang ug̱ali mi, pagpaita-itaamu ilem tung katalungaan yang mga tau. Piru yang Dios yay nag̱asangkad kung unu pa enged ay pag̱asikad mi. Ay ya pa ag̱ari, may nag̱apakumaal ta mga tau ang ya kang pisan ay nag̱alawayan yang Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mag̱aning si ti Jesus tung nirang nagpadayun, “Nag̱askean mi ang yang mga katuw̱ulan yang Dios pati yang ipinagpadapat yang mga manigpalatay yang bitala na ya ray pag̱andar ang asta luminua ra ti Juan ang manigbenyag. Mag̱impisa tii, nag̱ipagpakaw̱ut da yang Matinlung Balita ang yang Dios magtukud da yang paggaraemen nang baklu tung mga tau. Purisu duru rang mga taung pamag̱imuras dang mampalg̱ud. ");
INSERT INTO tbk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piru belag̱an ang mag̱aning ang yang mga katuw̱ulan yang Dios naplekan da ta puirsa na. Ay matunaw pa yang langit may yang kaliw̱utan, indi ka enged magpurawas yang mga katuw̱ulan ang atia, maskin sam parti ilem ang gesye. ");
INSERT INTO tbk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kapurisu kung tinu pay magpakiblag tung kasawa na ang pagkatapus mangasawa sing uman tung dumang baw̱ay, tung pagterelengen yang Dios, asan da nga limbungay na yang kasawa nang dati. Dispuis pa kung tinu pay mangasawa tung sasang baw̱ay ang binlag̱an da yang dating kasawa na, tung pagterelengen yang Dios, asan da ka nga sirungay na yang dating may kasawa,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mag̱aning ti Jesus ang nagpananglit, “May sasang manggaranen. Yang manggaranen ang naa, yang pag̱asuut na pulus mga aw̱el ang pinakamatitinlu ang durug maal. Dispuis kaldaw-kaldaw kang pagpundar ta midyu sasang punsiun ang ya ray pagkalipayan nirang magbararkada. ");
INSERT INTO tbk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Numanyan may sasang maliliwag̱en ang nag̱aranan tung ni Lazaro. Ya ra ileg lalakday asan tung pirgula yang balay yang manggaranen. Yang tinanguni na baw̱akukangen. ");
INSERT INTO tbk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yang gustu na ang basi pa ra ilem asan da masngat tung mga eped nirang pamamangan duun tung lamisaan yang manggaranen ang ya ra ka ilem ag̱ipamlekay tung lua. Belag̱an ilem maning tia yang pagkabetang na, kung indi, pati mga kirung pagpalenget tung anya, indi na ra kayanan ang taw̱uyun, kung indi, nag̱apaw̱ayaan na ra ilem asan ta patilak-tilak tung mga luka na. ");
INSERT INTO tbk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Numanyan may sasang kaldaw ang yang maliliwag̱en ang naa nadayunan da ka enged ang napatay. Yang ispiritu na dinulung da yang mga angil ang ingkelan duun tung pag̱atiniran ni Abraham ang kinaampu ta ang para magpakpad da duun tung anyang magpakiugpu tung kasadyaan. Pagkatapus pati naang manggaranen, unaw̱is napatay ra ka ang pagkatapus ipinalg̱ud da ka tung leyang. ");
INSERT INTO tbk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tung pag̱apatay na, yang ispiritu na diritsyu rang minangay duun tung pag̱aningen ang Hades, ang yang pagkabetang na duun, durung pinitinsiang nag̱aagmaan na. Numanyan natingara na ti Abraham duun tung alawid, durua tanira ni Lazarong pagteparan. ");
INSERT INTO tbk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pagkatingara na, dayun dang nangendal ang mag̱aning, ‘Ay, apung Abraham, ildaway ka! Tuw̱ulun mu ra kanay ti Lazaro ang maskin ya ra ilem yang tulduk na ay itulpuk na tung wai ang pagkatapus iangay na tani ang ipaturuk tani tung dilaku ang para malinaynayan ka ta gesye. Kipurki ya ray nag̱apasaranu yang pinitinsiang naang durug lebat tani tung apuy ang nani,’ mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mag̱aning ka ti Abraham ang nagtimales, ‘Ay duduy, ya ra ilem ay demdemen mu atiing buia pa rin tung kaliw̱utan, ang napagustua ra ka tung tanan ang kaayenan ang nakalima mu, piru naa ti Lazaro, yang natiniran na pulus kaliwag̱an. Pagkatapus numanyan tanya aglinga-lingaen da tani, ang ta yawa, durug kapinitinsia yang nag̱aagmaan mu asan. ");
INSERT INTO tbk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yadwa pa, atii w̱a tung pag̱erelaan ta may bulalut ang yag ngangang durug dalem. Nagkamaning da ta maning tia ay ug̱ud yang mga tau tani, kung alimbawa malelyag da rin ang magpalakted asan tung numyung magtaw̱ang, indi maimung malakted asan. Asta yang tag̱a asan ka tung numyu indi ka maimung malakted tani.’ ");
INSERT INTO tbk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mag̱aning ka yang manggaranen ang nagtimales, ‘Tay kung maning tii, apu, anday dumang ipakiildawu tung nuyu, kung maimu ilem, tuw̱ulun mu ra kanay ti Lazarong mangay duun tung balay yang tatayu. ");
INSERT INTO tbk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kipurki may mga putulu duun ang lima nga laliian. Paamanen na tanirang mamanligna ra tung mga kasalanan nira ug̱ud indi ra ka magkaradayun tani tung lugar ang naang durug kapinitinsia.’ ");
INSERT INTO tbk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ag̱aaning ka ti Abraham ang nagtimales, ‘Dengel nirang pirmi yang kasulatan. Pirming agbasaan yang isinulat ni Moises may yang nagkarasulat yang mga manigpalatay yang bitala yang Dios atiing tukaw. Kaministiran yay intindien nira ta mupia kung unu pay gustu nang ianing.’ ");
INSERT INTO tbk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mag̱aning ka yang manggaranen ang nagtimales, ‘Aa apu, kulang pa siguru tia. Piru kung may sasang minatay ang magbungkaras dang magbalik duun tung nira ang bilug ang tinanguni, talagang asan da mamanligna tung mga kasalanan nira.’ ");
INSERT INTO tbk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ag̱aaning ka ti Abraham ang nagtimales, ‘Kung yang isinulat ni Moises may yang nagkarasulat yang mga manigpalatay ya ra nganing ay nag̱apabengel-w̱engelan nira, maskin pang may sasang minatay ang magbungkaras pang magpaaman tung nira, indi ra ka enged tia mamag̱impurmi,’ mag̱aning. Atia ya ray pananglit ang painu-inuan mi ta mupia,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Numanyan mag̱aning ti Jesus tung mga taung nag̱apangugyatan na, “Indi maimung anday makanayan ta ipagpatalang yang sasang taung may pagtalig na tung yeen ang asta magpakasalak da ubin mamalpas da dayun tung yeen. Ug̱aring kung tinu pay matengeran yang pagpakasalak na ubin yang pamalpas na, kanugun yang pagkabetang na tung uri. Ay mas malbat yang kalainan ang maagmaan na kay tung buntug̱an da ilem duun tung alauran. Indi ilem magdayun ang papagtalangen na yang maskin sam bilug ang aranek ta pagkabetang ang pariu ka tung mga mamulang naa. ");
INSERT INTO tbk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Purisu ya man taang nag̱ipag̱aningu tung numyu ang magbantayamu ta mupia tung mga sadili mi. “Dispuis pa kung may aruman ming nagbuat ta kasalanan tung numyu, pakigkesenan mi ta matinlu ang basi pa ra ilem mademdeman na yang binuat na. Kung tanya aminadu tung kasalanan na, ay tia patawaren mi. ");
INSERT INTO tbk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maski pang muya-muyang magbuat ta kasalanan tung numyu ang pagkatapus kada magpakasalak, kung aminen na ka tung numyu, dapat mi ka enged ang patawaren,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mag̱aning yang mga apustul ni Ginuu ta tung anya, “Ginuu, kung maimu ilem, taw̱angayami kang para mas dumakul yang pagtaralig̱en yamen tung Dios.” ");
INSERT INTO tbk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mag̱aning ka ti Ginuu tang nagtimales, “Maskin mag̱adawa ra ilem din agkadakul yang pagtaralig̱en mi tung anya, kayanan mi ra rin ang buaten yang pag̱atelengan ming midyu indi maimung buaten,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mag̱aning si ti Jesus tung mga tauan na, “Ipabetangu, yamu may sasang turuw̱ulun ming pag̱aradu, ubin pagpastur tung kaayepan mi. Kung matapus na ra nganing yang ubra nang mulik da tung balay, magkatama w̱asung aningen mi ang tanya ra kanay ay tukaw ang mamangan? ");
INSERT INTO tbk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Belag bang yang ianing mi tung anya ang tanya ra kanay ay magsimpan yang mayapun mi ang pagkatapus mangimara rang maglamisa tung numyu ang asta matapusamu ra ta pagyapun mi, baklu ra mamangan tanya? ");
INSERT INTO tbk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ayw̱a, may utang mi pang kaneeman tung turuw̱ulun ming atia natetenged tung pagturumanen na yang itinuw̱ul mi tung anya? ");
INSERT INTO tbk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maning kang pisan tia tung numyung mga tauanu. Kung matuman mi ra nganing yang tanan ang ag̱ituw̱ulu tung numyu, yamu ra ag̱aaning, ‘Yami, mga turuw̱ulun mu ka ilem. Belag bag̱ay ang yami balesan mu pa. Tutal, yang tinuman yamen, ya ra ka ilem yang dapat kang lag̱ing ubligaren yamen,’” ag̱aaning duun ti Jesus tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Taa numanyan sigi-sigi yang pagparanawen ni Jesus ang pagdistinu duun tung Jerusalem. Duun tanya napanaw tung pag̱elaan yang Samaria may yang Galilea. ");
INSERT INTO tbk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Numanyan, atiing alenget da tung sasang baryu, may napanawan nang sam puluk nga laliian ang may mga dispirinsia nira tung mga ulit nirang makamamansa tung sadili nira. Namagtadeng da ilem ang namagpadistansia ang sigi ra ilem yang pagkekendalen nirang mag̱aning, “Maginuung Jesus, ildawayami ka!” ");
INSERT INTO tbk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Numanyan pagteleng ni Jesus tung nira, dayun na rang inaning, “Ala, mangayamu ra kanay duun tung mga paring masigparikisa tung nira yang mga tinanguni mi kung puidiamu rang tugtan nirang magpakilaket si tung mga kaarumanan mi,” mag̱aning. Numanyan tung pagparanawen nira, namagmaayen da. ");
INSERT INTO tbk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Numanyan yang sam bilug, mapanimanan na yang tinanguni nang maayen da, diritsyu rang nagbalik tung ni Jesus ang durug tunul yang busis nang nagdarayawen tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pagkaw̱ut na tung ni Jesus, ya ra papadagpa tung pinagtalungaan nirang durua ang nagpasalamat. Naa pala yang taung naa sasang Samarianen. ");
INSERT INTO tbk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Numanyan pagteleng ni Jesus tung anya, dayun dang nagbitala tung mga aruman nang mag̱aning, “Belag bang sam puluk nga tauan ang namagmaayen da? Ay ra kaya yang siam? ");
INSERT INTO tbk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Naa pala anda ray dumang nagbalik taa ang para magdayaw tung Dios, ya ra ilem taang sam bilug ang belag ka pa man masigkanasyunu ta?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pagkatapus dayun na rang binugnu yang taung atiang pinamaayen nang inaning, “Ala, kemdenga ra, padayunan mu ra kanay yang pagparikisa mu tung mga pari. Natetenged itinalig mu ra tung yeen yang sadili mu, nagmaayena ra,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Numanyan may mga Pariseong namagtalimaan tung ni Jesus kung sanu pa kumaw̱ut yang paggaraemen yang Dios tung bilug ang kaliw̱utan. Ag̱aaning ti Jesus ang nagtuw̱al, “Yang paggaraemen yang Dios, anday mga sinyalis nang matandaan kung sanu pa kumaw̱ut. ");
INSERT INTO tbk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Belag kang igbaralita ang mag̱aning, ‘Uay, telengan mi w̱a, nani ra!’ ubin ‘Uay, atii ra!’ Kipurki yang palaksu yang paggaraemen yang Dios naa ra tung tepad mi, pag̱andar da nganing,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pagkatapus dayun dang nagbira ang nagpasanag tung mga taung atiang nag̱apangugyatan nang mag̱aning, “May uras ang kaw̱utun ang duru rang paglalangkag̱en mi tung yeen ang pag̱aningen ang Maninga Tau ang para balikanamu ra yeen tung makali ug̱ud ipalapusu ra yang kabug̱usan yang paggaraemen yang Dios tung bilug ang kaliw̱utan. Piru indi mapalapusu mintras indi pag kaw̱utun yang tipu nang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Muya aningenamu ta mga tau ang, ‘Uay, yang pag̱aningen ang Cristo nani ra!’ ubin aningenamu nirang, ‘Uay, atii ra!’ Indiamu enged magsagyap. ");
INSERT INTO tbk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kipurki ta yuung pag̱aningen ang Maninga Tau, kung magpalapusaw ra nganing yang kabug̱usan yang paggaraemen yang Dios, maintindian da tung bilug ang kaliw̱utan. Ay yang kaalimbawaan na, maning pa tung kidlat ang inali yang singgat na ang bistu ra tung duw̱ali magduw̱aling langit. ");
INSERT INTO tbk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piru baklu ra ipalapusayu tia, kaministiran ang mapasaranaw ra ta pinitinsiang durug lebat natetenged tung panambing tung yeen yang mga masigkanasyun ta. ");
INSERT INTO tbk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Dispuis pa kung ya pa ag̱ari yang palaksu yang panimpu ni Noe, yang pisan yang palaksu yang panimpu ang yuung pag̱aningen ang Maninga Tau makaliaw rang maglekat. ");
INSERT INTO tbk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kipurki atii kanay, baliwala ka ilem tung mga isip yang mga tau yang sintinsiang magkakaw̱ut da tung nira. Yang pinadayunan nirang pinabilug̱an ta mga isip nira, ya ka ilem yang mga pag̱urubraen nira tung pangaldaw-kaldaw ang katulad ka tung pagparanganen nira may yang pag̱irinemen nira may yang pagkarasawaen nira may tung pagparakasawaan nira tung mga ana nira. Ya ra ka ilem tii yang inintindi nira ang asta ra ilem kinaw̱ut yang uras ang ipinagsaay na Noe tung parka, ang pagkatapus kuminaw̱ut da yang palempan ang ya ra kay nalmesan nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pati yang mga tau atii kanay ang tag̱a Sodoma tung timpu pa ni Lot pariu kang pisan yang palaksu yang mga pag̱irisipen nira. Baliwala ka ilem tung mga isip nira yang sintinsiang magkakaw̱ut da tung nira. Yang pinagamenan yang mga isip nira, ultimu ka ilem yang pagparanganen nira, yang pag̱irinemen nira, yang pag̱aralangen nira ta mga kaministiran nira, yang pagnirigusyuen nira, yang pagluluaken nira, may yang pagparakdengen nira ta mga balay nira. Asan da ilem agtetegka yang mga isip nira. ");
INSERT INTO tbk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Piru pagkaw̱ut yang uras ang na Lot namansiliit da duun tung siudad ang atiing Sodoma, inaling pinabungsaran yang Dios yang banwang atii ta apuy ang midyu tung kuran ang may kalaket na kang asupri ang ya ray nagsupuk tung nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Maning kang pisan tia yang palaksu yang pag̱irisipen yang mga tau kung uras dang yuung pag̱aningen ang Maninga Tau makaliaw rang maglekat taa tung kaliw̱utan ang naa ang para magsintinsiaaw ra tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kung kaw̱utun da nganing yang uras ang atia, kung tinu pay pagpalimasmas tung sagpaw yang balay na, indi na ra kanugunun yang mga ekel-ekel na duun tung kakleran ang maning paranekan na pang eklan. Ya ka yang taung duun dag kaw̱utay tung kaluakan na, indi na ra balikan yang balay na. ");
INSERT INTO tbk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pademdeman mi ra ilem yang nainabu tung kasawa ni Lot atiing pagbalyed nang nangandem tung mga ekel-ekel nang nagkarabutwan duun tung Sodoma. ");
INSERT INTO tbk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kipurki kung tinu pay ag̱alelyag ang yang sadili na ilibri na tung malain, asan da nga kapa-kapaay na yang kaampiran na tung yeen. Piru kung tinu pay mamirdi tung sadiling kalelyag̱an na natetenged ilem tung yeen ang yuu ray nag̱ipalusu na ta gegma na, asan da nga siguruay na yang kaampiran na tung yeen ang yay pagnatisan nang asta tung sampa. ");
INSERT INTO tbk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iugtulu tung numyu, tung uras ang atiang kaw̱utun, kung alimbawa law̱ii yang ipaglekatu, puiding may durua nga tauan ang mag̱elken ang pagdalan. Yang sam bilug eklan, yang aruman na mabutwan. ");
INSERT INTO tbk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ubin may durua nga baw̱ayan ang pagtinaw̱angay ta paggaling yang beyed yang trigu, yang sam bilug eklan, yang aruman na mabutwan. ");
INSERT INTO tbk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dispuis duun tung kaluakan puiding may durua ka nga tauan ang pamag̱ubra. Yang sam bilug eklan, yang aruman na mabutwan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Numanyan mag̱aning yang mga tauan nang namagtalimaan, “Ginuu, ay pang banwaay kaya mainabu yang mga bag̱ay ang atia?” Mag̱aning ti Jesus ang tuminuw̱al, “Basta mainabu, indi mataluk tia. Magkapariu ra tung nag̱ipananglit yang mga mamaepet ang kung ay pa unu ay may patay, indi unu mataluk ay natetenged duun ka unu pamaglanget ang pamagpatipay-tipay yang mga lamlam ang atiang pamamangan ta mga ayep ang patay,” ag̱aaning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Numanyan may sam bilug sing pananglit ang ipinagngel ni Jesus tung mga tauan na. Yang pag̱asikad na ang tanira pirming magpaderep ang mag̱ampu tung Dios, ang maskin magpanaw pa tung mabuay-w̱uay yang tuw̱al na, indi ka enged magpaluw̱ay yang mga kinaisipan nira. ");
INSERT INTO tbk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mag̱aning yang pananglit na, “Numanyan may sasang wis ang pagtinir duun tung sasang lansangan. Yang wis ang naa, anday pag̱eled na tung Dios ig anda kay panggalang na tung mga masigkatau na, maskin tinu pa. ");
INSERT INTO tbk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Numanyan may sasang balung baw̱ay tung lansangan ang atii. Pirming pagpabalik-balik tung wis ang pagpataw̱ang enged ang mag̱aning, ‘Maginuung wis, taawaw si pagdangep tung nuyu, taw̱angay kang dipindiran tung taung atiing panlepes tung yeen,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nabuay ra yang pagpabalik-balik na, piru indi ra ka enged sinapet yang wis. Numanyan atiing masyadu ra enged yang pagpataw̱ang yang balu, napag̱isip da yang wis. Pinapagkesen-kesen na ra yang isip nang maning taa: ‘Yuu, tung bag̱ay anday pag̱eleru tung Dios, pagpadamelaw ra ilem yang ityuraw tung mga masigkatauu. ");
INSERT INTO tbk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Abaa piru magamu ra ilem tung kuluu yang pagpabera-w̱era yang balung naa tung yeen. Maayen pa dipindiranu ra ilem tung makali ang para mapalus da tung kuluu. Muya kung indi taw̱anganu, paluw̱ayanaw ra ilem anya ta pagpabalik-balik.’” ");
INSERT INTO tbk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Numanyan mag̱aning ti Ginuu tang nagpasanag, “Ta, isipen mi ra kanay ta mupia yang inaning yang wis ang atiang durug kasayud ta ug̱ali. ");
INSERT INTO tbk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yang Dios pa kaya ang pulus tama yang pag̱abuat na, indi w̱a mas pang magdipindir tung mga tauan nang sadili ang yay pangambay tung anyang pagpataw̱ang kaldaw law̱ii? Ayw̱a kanisip mi tia paw̱aya-w̱ayaan na ra ilem tanira? ");
INSERT INTO tbk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iugtulu tung numyu, dipindiran na tia tung makali. Ug̱aring ilem, ta yeen ang pag̱aningen ang Maninga Tau, kung kaw̱utun da nganing yang uras ang ipaglekatu taa tung kaliw̱utan ang naa ang duru ka man agliwag yang nag̱apasaran yang mga tau, duru pa w̱asung kaw̱utanung pagpadayun pa ka enged yang pagtaralig̱en nira tung yeen?” ");
INSERT INTO tbk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Numanyan may sasa si kang pananglit ang ipinagngel ni Jesus. Yang rumbu na para tung duma asan ang pagtalig tung mga sadili nira ang tanira nagkabag̱ay ra tung pagterelengen yang Dios ang yang mga masigkatau nira yay nag̱alamku nirang teleb ta kasalanan. ");
INSERT INTO tbk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Maning taa yang pananglit na, “Simanyan may durua nga tauan ang nanungul duun tung pagtuuan ang pinakalusu ang para magtuu tung Dios. Yang sam bilug Pariseo, yang sam bilug manigpanukut ta mga balayaran tung gubirnu. ");
INSERT INTO tbk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Numanyan, pagkaw̱ut nira duun, naang Pariseo nagpaag̱es-ag̱es da tung kadaklan ang yay nag̱apamiruan na ang pagkatapus nag̱ampu ra ta maning taang pag̱arampuen ang ya ka ag̱ipagngelay na tung sam bilug. ‘Ampuanung Dios, pagpasalamataw tung nuyu ang yuu belag̱anaw pariu tung kadaklan ang mga manlelepes, mga mandaraya, mga maniglimbung, ang katulad da enged tung manigpanukut ang naang talagang teleb ang pisan ta kasalanan. ");
INSERT INTO tbk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ay ta yeen, tung seled san linggu may duruang kaldaw ngani ang ag̱ipamleku yang pagparanganenu. Dispuis yang tanan ang mga pangitaw pati yang tanan ang mga pruduktuu, luw̱us agparti-partienu ngani ta sam puluk ang parti ang para yang sam parti yay nag̱ikdulu tung nuyu,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Taa numanyan naang manigpanukut tanya, duun da ilem ngakdeng tung alawid-lawid tung kadaklan ang pamagtuu ang yang anyang pag̱arampuen, indi ra nganing natingara tung langit, kung indi, ya ra ilem mamukpuk tung debdeb naang mag̱aning, ‘Ay Ampuanung Dios, duruaug kakinasalananen. Ildaway kang patawaren ug̱ud indiaw dangaten yang kasisilag̱en mu.’” ");
INSERT INTO tbk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Numanyan mag̱aning ti Jesus ang nagpasanag, “Iugtulu tung numyu, yang taung naang sam bilug, baklu ra nandanek ang minulik tung balay na, ya ra kang lag̱i ay inusgaran yang Dios ang salu rang pisan tung pagterelengen na, belag̱an yang sam bilug. Kipurki kung tinu pay pagpaabwat tung sadili na, ya iparanekay yang Dios ang kaskasay. Piru kung tinu pay pagparanek tung sadili na, ya ipaabwatay nang tapnayay,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Taa numanyan maskin mga mamulang gereg̱esye, pag̱apangkelan da yang mga ginikanan nira duun tung ni Jesus ang para pampabisaen da nira tung anya. Piru pagkaita yang mga taung atiang nag̱apangugyatan ni Jesus, diritsyu rang sinambeng nira. ");
INSERT INTO tbk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piru ti Jesus tanya, anday dumang binuat na, yang mga mamulang atia ginuuyan nang mamagpadayun da ka enged tung anyang mamagpalenget. Pagkatapus dayun na rang inaning yang mga taung nag̱apangugyatan na ang “Eey, yang mga mamulang atia, paw̱ayaan mi ra ilem ang mamagpalenget da tani tung yeen. Indi mi ra enged pagsagangen, ay kipurki kung tinu pay may pagtalig nira tung Dios ang katulad ka tung pagtaralig̱en yang mga mamulang naang bug̱us tung mga ginikanan nira, lug̱ud da tung mga taung pamagpagaem dang bug̱us tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iugtulu tung numyu yang kamatuuran, kung indiamu ra magpakbung tung mga mamulang mapinagparanek tung mga may idad tung nira, tay puis, indi mi ra enged maispirinsiaan tung mga sadili mi kung unu pay palaksu yang paggaraemen yang Dios tung pagpangabui mi.” ");
INSERT INTO tbk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Numanyan may sasang taung may katengdanan duun tung banwang atii ang ya ray nagbugnu tung ni Jesus ang mag̱aning, “Ameey, nag̱askeanu ang yawa sasang maayen ang tau. Kung mga sarang tung nuyu, may gustuu rin ang talimaanenu tung nuyu. Unu pay dapat ang buatenu ang para mapagpasapenaw tung Dios ang anday katapus-tapusan?” ");
INSERT INTO tbk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mag̱aning ka ti Jesus ang nagtimales, “Muya indi mu ilem nag̱askean kung unu pay linagpakan na atiing inaningaw ra nuyung maayen. Anday dumang sarang ang maaning mung maayen kung indi ultimu ilem yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yang mga katuw̱ulan na, nag̱askean mu ra ka siguru. Ulitenu ra kanay ang ipademdem tung nuyu. ‘India maglimbung tung kasawa mu, india mangimatay tung masigkatau mu, india manakaw, india manistigus ta bukli tung katalungaan yang ustisia, ig galangen mu ti tatay mu may ti nanay mu.’” ");
INSERT INTO tbk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ag̱aaning ka yang taung atiang nagtimales, “Piru elat kanay, Ameey. Yang tanan ang atiang mga katuw̱ulan ang sinambit mu, luw̱us dang nag̱atumanu mag̱impisa pang atiing paran-paranaw pa.” ");
INSERT INTO tbk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagkagngel ni Jesus yang tuw̱al na, mag̱aning tung anya, “Ya ra ilem taa yang pagkakulang tung nuyu. Mulika ra kanay. Yang tanan ang kamanggaran mu ipaalang mu ra. Yang kabayaran nang kuarta ipamakdul-pakdul mu ra tung mga maliliwag̱en. Kung yay tumanen mu, ay tia simpanana ra yang Dios ta kamanggaran mu duun tung langit. Pagkatapus ta pamakdul-pakdul mu, magbalika ra ka tani ang magpaugyat tung yeen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Numanyan pagkagngel na tia inampayan da ta kapupungawen nang duru. Ay ya pa ag̱ari, durung kamanggaran na. ");
INSERT INTO tbk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Numanyan pagkaita ni Jesus tung anyang magpungawen da, dayun dang nagbitala tung mga tau ang mag̱aning, “Durug liwag ang yang sasang manggaranen magpalamtuk yang pundu yang kinaisipan nang magpagaem ta bug̱us tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kung maliwag ngani ang yang kamilyu pumuyuk tung buli yang tingway, mas pang maliwag ang yang sasang manggaranen magpalamtuk yang pundu yang kinaisipan nang magpagaem ta bug̱us tung Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Atii, yang nangagngel tung inaning ni Jesus ang atia, namag̱araning-aningan da, “Tay, kung maning tii pala ang maski nganing yang mga manggaranen ang kanisip tang alenget tung Dios, indi nganing pala matapnay, ya pa yang kadaklan ang mga tau?” ");
INSERT INTO tbk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mag̱aning ka ti Jesus ang nagtuw̱al, “Yang indi kayanan ta mga tau, yay kayanan yang Dios,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Atii, ti Pedro ya ray nabngang mag̱aning, “Teed mu, Ameey, ta yaming pagpaugyat tung nuyu, pinalpasan da yamen yang tanan ang nabtang tung pudir yamen basta magpakignunutami ra ilem tung nuyu.” ");
INSERT INTO tbk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Mag̱aning ti Jesus ang nagtimales tung nirang tanan, “Iugtulu tung numyu, kumpurming tinu pay namutwan tung sadiling pamalay-w̱alay na ubin tung kasawa na, ubin tung mga putul na, ubin tung mga ginikanan na, ubin tung mga ana na man arangan da ilem tung pagparakaw̱utun na tung mga tau natetenged tung paggaraemen yang Dios ang naang baklung pag̱atukuru, ya ray pakdulan na ta kapakli yang tanan ang atiang pinamutwanan na ang pira-pira rang dubli numanyan tung panimpung naa ig tung baklung panimpung kaw̱utun tung uri, magpasapen da ka tung Dios ang asta tung sampa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Numanyan yang mga tauan ni Jesus ang atiang sam puluk may durua, pinampaligbin nang pinampasanag̱an ang inaning, “Ta, taawita rag panungul ang panganing duun tung Jerusalem. Muya maberengamu tung ianingung naa tung numyu. Kung kumaw̱utita ra nganing duun, magkamatuud da yang tanan ang nagkarasulat yang mga manig̱ula natetenged tung yeen ang pag̱aningen ang Maninga Tau. ");
INSERT INTO tbk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Kipurki iintrigaaw ra tung pudir yang belag̱an mga masigkanasyun ta ang anda enged ay pag̱intindi nira tung Dios. Buatenaw ra nirang sasang kayaman, deeg-deeg̱anaw ra ka nirang lawayan yang mga tinanguniu ang pagkatapus pikadaanaw ra ka nira ta burdun bakluaw ra imatayay nira. Piru tung pagkaw̱ut yang yaklung kaldaw, pabungkarasenaw ra ka enged yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Piru yang mga aruman nang pinag̱aning na, midyu tung anda ray naerem. Midyu tung sasang pasig̱em ang indi enged nira namaresmesan kung unu pay nag̱adapatan na. ");
INSERT INTO tbk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Numanyan atiing alenget da tanira tung Jerico, may sasang buray ang yag kakarung tung binit yang dalan ang pagpalimus. ");
INSERT INTO tbk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Numanyan, pagkasinti na ang may mga taung buntun ang pamagtaklib da, nagtalimaan da tung mga taung katepad na kung unu pay nag̱adapatan na. ");
INSERT INTO tbk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mag̱aning ka yang dumang nagtimales, “Ti Jesus ang atiang tag̱a Nazaret magtataklib da.” ");
INSERT INTO tbk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pagkagngel na ang ti Jesus da tia, dayun dang nagkekendalen ang mag̱aning, “Jesus, yawang manubli ra tung paggaraemen ni Adi David, ildaway ka!” ");
INSERT INTO tbk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Numanyan yang mga taung atiang pamagtukaw tung nirang sam paluyug̱an, ya ray namagsambeng tung anyang mag̱ipes da. Piru belag ya mag̱ipes, kung indi, mas pang ya magkekendalen ang magkekendalen ang mag̱aning, “Yawang manubli ra tung paggaraemen ni Adi David, ildaway ka!” ");
INSERT INTO tbk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Numanyan diritsyu rang nagtadeng ti Jesus ang nagkalalangan tung mga tau ang yang buray guyuran da kanay duun tung anya. Numanyan pagkaw̱ut yang buray, dayun dang tinalimaan ni Jesus ang inaning, ");
INSERT INTO tbk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ta, unu pay gustu mung buatenu para tung nuyu?” Mag̱aning yang buday ang nagtuw̱al, “Ay Ameey, gustuu rin ang maitaw si.” ");
INSERT INTO tbk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ag̱aaning ti Jesus ang minles, “Ala, maitaa si! Natetenged itinalig mu ra tung yeen yang sadili mu, naulikan da tia!” ");
INSERT INTO tbk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Atii, lag̱i-lag̱ing naita si ka man. Pagkatapus dayun dang nagpakignunut tung ni Jesus ang sigi-sigi ra ilem yang pagdarayawen na tung Dios. Asta yang tanan ang mga taung nangaita tung nainabung atia, duru kang pagdarayawen nira tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pagkatapus ti Jesus nagpadayun da yang pagparanawen na duun tung lansangan ang Jerico. Pagkaw̱ut na, namalaknga ra ilem tung lansangan ang pagpanaw. ");
INSERT INTO tbk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Duun may sasang taung nag̱aranan tung ni Zaqueo. Tanya sasang manigpanukut ta mga balayaran tung gubirnu ang abwat ta katengdanan. Purisu ya ray pinagmanggaranan na. ");
INSERT INTO tbk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Numanyan pagkagngel na ang ti Jesus magtataklib da, gustu na rin ang magteleng tung anyang mangilala. Piru yang mga taung pamagpakigluyug tung ni Jesus buntun. Purisu anday maimu ni Zaqueo ang magteleng ay tanya putut ang tau. ");
INSERT INTO tbk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kapurisu yang binuat na, napalaksu ra tung tukawan ang panawan ni Jesus, pagkatapus dayun dang nagtakwal tung sasang ayung dakulu ug̱ud kung tumaklib da nganing ti Jesus, ya ray masurungan na. ");
INSERT INTO tbk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Simanyan, pag̱akpeng da ni Jesus asan tung ayung atia, tiningara na ti Zaqueong binugnu ang inaning, “Zaqueo, pakalia ra. Paaraneka ra tani ay numaan kaministiran ang yuu asanaw ra rin magdayun tung balay mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Atii, kali-kali ra ka man ang nagparanek ti Zaqueo ang nag̱asikasu tung ni Jesus duun tung balay nang duru rag sadya yang isip na. ");
INSERT INTO tbk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Numanyan atiing pagkaita yang duma tung ni Jesus ang nagnunut da tung ni Zaqueo duun tung balay na, dayun dang namagburutung-butungan ang mag̱aning, “Abaa, ti Jesus ang naa ka, kaduma ka! Nag̱akdekan na ka tia teleb ang pisan ta kasalanan, tung anya pa ka enged magdayun?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Taa simanyan, buay-w̱uay ra ta gesye, nagkereng da ti Zaqueo ang nagbitala tung ni Ginuu ta ang mag̱aning, “Buinu, Ginuu, binilug̱u ra yang isipu. Anday dumang buatenu, ya ra taa: Yang katengaan yang kamanggaranu ipamakdul-pakdulu ra tung mga maliliwag̱en. Kung tinu pay nadayaanung pinanukutan ta subra, paulikanu ra ka ta epat ang dubli,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ag̱aaning ka ti Jesus ang nagbitala, “Numaan ang kaldaw, yang sam pamilyang naa kinaw̱utan da ta kalibrian ay natetenged pinapruibaan da yang pagmangulu ang ya ray nasug̱ut na yang irinsia ni Abraham ang nagtalig ka tung Dios ang bug̱us yang isip na. ");
INSERT INTO tbk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kipurki yuung pag̱aningen ang Maninga Tau, yang inangayu taa tung kaliw̱utan ang naa ay ug̱ud magsagyapaw tung mga taung kumpurming natalang da ang ya ra ka rin ay ikadiadu nira ang para yay tapnayenung ipaulik tung Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Numanyan yang mga taung atiang pamamati tung inaning ni Jesus ang atia tung ni Zaqueo, ya si ay pinasanag̱an nang pinagngelan ta pananglit. Kumus tanya alenget da tung Jerusalem, yang kalaum nira, kung makaw̱ut da nganing duun tung siudad, atiang lag̱i ipalapus na ra enged yang kabug̱usan yang paggaraemen yang Dios ang duru ra atiing pagpakbat nira. ");
INSERT INTO tbk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Purisu maning taa yang pananglit ang ipinagngel na: “May sasang taung abwat ta pagkabetang ang nagdistinu duun tung alawid ang banwa ang para pakdulan da ta katengdanan nang maggaraemen tung banwa na kung uras dang magbalik. ");
INSERT INTO tbk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Numanyan baklu nagliit duun tung banwa na, pinampaguuyan na ra kanay yang mga turuw̱ulun nang sam puluk nga tauan. Numanyan pinamakdulan na ta kuarta ang pariu-pariu yang kantidad ang ipinamakdul na tung sasa may sasa. Mag̱aning tung nirang nagbutwan ta bitala, ‘Yang kuartang atia, ya ray buaten ming puunan ang ipagnigusyu mi ang asta kaw̱utun yang ipaglekatu.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Piru atia pala yang mga masigkabanwa nang yay magaeman na tung pagbalik na, anday gustu nira tung anya. Purisu yang binuat nira, namanuw̱ul da tung mga kaarumanan nira ang mamanikad da duun tung banwang atiing nag̱adistinu na ang para duun da mamagriklamu tung mas abwat tung anya ang talagang anda enged ay gustu nira tung anya ang yay maggaraemen tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Numanyan duun da tung banwang inangayan na, piniaran da ka enged ta katengdanan nang maggaraemen duun tung banwa na. Pagkatapus, dayun dang naglekat duun. Pagkaw̱ut na, dayun na rang pinampaguuyan yang mga turuw̱ulun nang atiing pinamakdulan na ta kuarta ang para insapuen na tung nira kung unu pay pinakaw̱ut yang pagnigusyu nira. ");
INSERT INTO tbk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Numanyan pagpalenget yang sam bilug, mag̱aning tung anya, ‘Maginuung Adi, yang kuarta mung atiing ipiniar mu tung yeen, nag̱umintu ra ta sam puluk ang dubli.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mag̱aning yang ag̱alen nang minles, ‘Maayen! Talagang yaway sasang baling turuw̱ulun. Kumus pagpailalaa rang maskin gesyeng bag̱ay, matalig̱ana, purisu piarana si ka yeen ta katengdanan mung mag̱erekelen tung sam puluk nga siudaran taa tung banwa ta.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pagkatapus, pagpalenget si yang sam bilug, mag̱aning tung ag̱alen na, ‘Maginuung Adi, yang kuarta mung naang ipiniar mu tung yeen, nag̱umintu ra ta limang dubli.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mag̱aning ka yang ag̱alen nang minles, ‘Pati yawa piarana ra ka yeen ta katengdanan mung mag̱erekelen tung lima nga siudaran taa tung banwa ta.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Numanyan ya si yang sam bilug ang nagpalenget ang mag̱aning, ‘Maginuung Adi, atia ra yang kuarta mu. Pinagputusu ra ilem tung panyu ang pinagtaluk ta maayen ang para indi maplek. ");
INSERT INTO tbk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ya ray binuatu ay kipurki duru kang lag̱ing eleru tung nuyu, ay yang nag̱askeanu tung nuyu, yawa durua ka pa man ag̱igpit ang tau. Pagpakinaw̱anga tung indi mu pinakabedlayan, pagpakaayena tung belag̱an pinaturukan ta ulas mu.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mag̱aning yang Ading minles, ‘Abaa, yawang inutilang turuw̱uluna! Mismung sadiling bitala mu ya ra kay ibaliku tung nuyung ipatemeng. Ag̱aaninga ka palang nag̱askean mu ang yuu duruaug kaigpit ang tau. Pagpakinaw̱angaw tung indi pinakabedlayanu, maskin yang indi pinaturukanu ta ulasu, ya ka. ");
INSERT INTO tbk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ayw̱a, indi mu idinipusitu yang kuartaw tung bangku ug̱ud tung pagbaliku, maeklanu pa ka rin pati tubu na? Atii ra rin.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Atii, diritsyu rang nagbira ang nanalunga tung mga turuw̱ulun nang kadaklan ang kemdengan asan. Mag̱aning tung nira, ‘Ala, eklan mi ra tung anya yang kuartaung atia. Ipakdul mi ra asan tung aruman nang napakaw̱ut ta sam puluk ang dubli.’ ");
INSERT INTO tbk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ag̱aaning tanirang namagriklamu, ‘Abee, Maginuung Adi, may kuarta na kang lag̱ing sam puluk ang dubli!’ ");
INSERT INTO tbk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mag̱aning yang Ading nagtuw̱al, ‘Iugtulu tung numyu, kung tinu pay maderep ang magpapanaw tung ipiniar tung anya, piaran pa ka enged ta mas pa. Piru yang taung paw̱aya-w̱ayaen tung ipiniar tung anya, maski nganing yang gesyeng atiang ipiniar tung anya, bawien pa ka enged tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Piru kung natetenged tung mga taung atiang pamagpakigkuntra tung yeen ang anday gustu nirang mamagpagaem tung yeen, ala, pangkelan mi ra tani ang para pangimatayen ming luw̱us tung katalungaanu,’ ag̱aaning yang Adi tung mga turuw̱ulun na.” ");
INSERT INTO tbk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Numanyan pagkatapus ni Jesus ta pagpananglit, nagpadayun da yang pagturungulun na ang yang rumbu na duun tung Jerusalem. Nagtukaw-tukaw ra tung mga kaarumanan nang sam paluyug̱an. ");
INSERT INTO tbk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Numanyan atiing pamanungul da na Jesus tung bukid ang atiing durung ayung pag̱aningen ang olibo ang alenget da duun tung Betania may tung Betpage, nanuw̱ul da tung durua nga tauan ang nag̱apangugyatan nang mag̱aning, “Ala, mangayamu ra kanay tung baryung atii tung tukawan ta. Kung kumaw̱utamu ra nganing asan, ya rang lag̱i ay mapanawan mi yang sasang asnung sinday pa ang yag kekedked ang inding pisan nag̱asaay-saayan ta tau. Ya ray badbaren ming guyuran tani. ");
INSERT INTO tbk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kung tinu pay magbugnu tung numyung ayw̱a nag̱abadbad mi tiang asnu, yamu ra ag̱aaning ‘Kaministiran ilem ni Ginuu ta.’” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kapurisu numanyan namagpanaw ra ka man yang durua nga tauan ang atiang pinanuw̱ul ni Jesus. Mansikaw̱ut tanira tung baryu, ya ka man ang pisan ay napanawan nira. ");
INSERT INTO tbk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Numanyan atiing nag̱abadbaran da nira yang asnung sinday, binugnu ra ka man yang may mga asnung inaning, “Ay tia, ayw̱a ag̱abadbaran mi ra atiang sinday?” ");
INSERT INTO tbk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mag̱aning yang duruang atiang nansituw̱al, “Kaministiran ilem ni Ginuu ta.” ");
INSERT INTO tbk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pagkatapus dayun dang ginuyuran nira tung ni Jesus. Pagkaw̱ut nira, dayun da nirang sinapinan ta mga panlamig nira ang pagkatapus ya ray pinasaayan nira tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Numanyan yang pagsaay na tung asnu, ya kay paggaralangen yang mga tau tung anya ang maskin yang mga panlamig nira, ya ray pinanluas nirang ipinameklad tung dalan ang pagpanawan yang asnu. ");
INSERT INTO tbk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Numanyan pagkaw̱ut nira tung salapay yang bukid ang atiing durung ayung pag̱aningen ang olibo, nabandaw ra nira yang siudad tung tukawan. Pagkabandaw yang tanan ang mga taung atiang, nag̱apangugyatan nang pamagpakigluyug tung anyang durug dakel, pinangampayan da ta kasadyaan nirang duru ang pamag̱aw̱ayag dang nunut da ka ta pagdarayawen nira tung Dios. Yang idinayaw nira tung anya ay natetenged nademdeman nira yang tanan ang nagkaraita nirang mga pruibang makabew̱ereng ang ipinagpalapus ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Maning taa yang mga bitala nira: “Pakaayenen dang pirmi yang Dios yang Ading naang ya kang lag̱i ay pag̱aelatan ta ang yay pag̱atuw̱ul nang magpalua yang paggaraemen na. Ya ray magtukud yang kalibrian ta ang yay dayawen ta tung Dios duun tung kaabwat-abwatan!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Taa numanyan, may mga Pariseong namagpakiglaket asan tung mga taung atiang buntun ang pamagpakigluyug da kang lag̱i tung ni Jesus. Numanyan, pagkagngel nira yang bitala yang mga tau, dayun dang namagriklamu tung ni Jesus ang mag̱aning, “Ameey, sambengen mu ka yang mga taung atiang nag̱apangugyatan mu!” ");
INSERT INTO tbk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mag̱aning ti Jesus ang nagtuw̱al, “Iugtulu tung numyu, kung sambengenu tia, yang mga batu ya si ay mamansibles ang mamagkerendalen ang mamagdarayawen tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Numanyan atiing nag̱alenget-lenget da ti Jesus tung siudad ang ya rag bandaway na tung tukawan, unaw̱is ya ra nga panangit natetenged tung panganugun na tung mga tag̱a Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Maning tanya, “Aay, kanugunamung tag̱a Jerusalem! Kisira rin pati yamu, nag̱amaresmesan mi ra rin numaan kung unu pay dapat ang buaten mi ang para tung ikalimeng mi ra rin. Piru indiamung pisan maintindi. ");
INSERT INTO tbk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kipurki may uras ang kaw̱utun ang yang siudad mi liw̱utun da yang mga kuntrariu mi. Yang mga tanek idesel da nira tung padir na ang para may pamdungan nirang mamagtumbak ang asta magew̱a. Lesew̱enamung pisan nirang sangsangen. ");
INSERT INTO tbk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pagkatapus kung pakleranamu ra nganing nira, gew̱aen dang pisan nira yang siudad mi, pati yamung pagtinir asan diaduenamu ra ka nira. Pati mga balay mi, mga padir pa, lubsun da nira ta panumba, ang asta andang pisan ay batung pinasag̱ing maita ang mag̱aning ang magderepetan pa. Yang tanan ang atiang nag̱ianingu talagang yay mapasaran mi ay natetenged ang yang mga uras ang naa ang ya ra rin ay uras ang ipagtapnay yang Dios tung numyu, ang pagkatapus andang pisan ay naerem tung mga isip mi, kung indi, ag̱ipataklib mi ra ka ilem,” mag̱aning. Atia ya ray mga bitala ni Jesus ang ipinanangit nang nanganugun tung mga taung atiang tag̱a Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Taa numanyan, atiing duun da tanira na Jesus tung siudad, tanya nagpakled da tung palayas yang pagtuuan ang atiing pinakalusu. Pagpakled na, dayun dang nagpalayas tung tanan ang mga nigusyanting kumpurming pinangaw̱utan na duun. ");
INSERT INTO tbk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mag̱aning tung nira, “May sasang inaning yang Dios ang napabtang tung kasulatan ang yang balay unung naang ya enged ay pag̱atiniran na, dapat unu ang yay pag̱ampuan yang mga tau tung anya. Piru ay pa w̱a? Ta numyu binuat mi ra ilem ang kuinta leyang ang pantalukan ta mga tulisan, ay natetenged taa ra mismu agpandayaay mi yang mga tau,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Numanyan kaldaw-kaldaw pagturuldukanen ti Jesus tung mga taung pamagsaragpun-sagpun duun tung palayas yang pagtuuan nirang atiing pinakalusu. Piru yang mga paring arabubwat ta katengdanan may yang mga sag̱ad pati mga pamagpakigmaepet, anday dumang pag̱atima nira tung uras ang atii, kung indi, kung ya pa ag̱ari yang pagpaimatay nira tung ni Jesus. Pati mga taung arabubwat ka ta mga pagkabetang, namampasanyug da ka tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kasu ilem anday rimidyung mabuat nira ay pamangaman tung mga taung atiang buntun ang sumasakep tung pista. Ay tung pagparamatien nira tung nag̱itulduk ni Jesus pamangganaan ta maayen. ");
INSERT INTO tbk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Numanyan may sasang kaldaw ang ti Jesus duun tung pagtuuan ang pinakalusu pagturuldukun tung mga tau ig nunut da ka ta pagparakaw̱utun na natetenged tung paggaraemen yang Dios kung ya pa ag̱aring mapalg̱uran da nira. Numanyan limput da yang mga paring arabubwat ta katengdanan may yang mga sag̱ad, pati yang mga pamagpakigmaepet tung banwa nira. ");
INSERT INTO tbk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mag̱aning tung anya, “Eey, iugtul mu ra tung yamen kung ay pa ngaeklay mu yang katengdanan ang yawa magbuat yang mga maning tia taa tung pagtuuan tang naa? Tinu pay naglug̱ut tung nuyu?” ");
INSERT INTO tbk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ag̱aaning ka ti Jesus ang nagtimales, “Elat kanay, kung mga sarang tung numyu, may talimaanenu rin tung numyu. Naang pagberenyag̱en ni dipuntu Juan tung mga taung pamanligna tung mga kasalanan nira, ay pa liit yang katengdanan na? Tung Dios manliit u tung tau ka ilem?” ");
INSERT INTO tbk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Atii, pagkagngel nira, nag̱aralas-alasan dang mag̱aning, “Unu pa kaya ay maayen ang ituw̱al ta? Kung aningen ta ang tung Dios manliit yang katengdanan ni dipuntu Juan, muya sulilienita si anyang talimaanen ang ayw̱at indiita ra nananged tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piru kung aningen ta ang tung tau ka ilem manliit, muya taraw̱anganita ra ta pamatu yang mga taung naang imatayen, kipurki yang pagterelengen nira tung ni dipuntu Juan tanya talagang sasang tinuw̱ul yang Dios ang magpadapat yang bitala na,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Purisu numanyan anday dumang natuw̱al nira, namanginay ra ilem. ");
INSERT INTO tbk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mag̱aning si ka ti Jesus ang nagtimales, “Tay kung maning tii, indiaw ra ka mag̱ugtul tung numyu kung ay pa liit yang katengdananung pagbuat ta mga maning tia,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pagkatapus numanyan, anday dumang naisipan ni Jesus, dayun dang nagpagngel ta sasang pananglit tung mga taung atiang pamamati ang mag̱aning, “Numanyan may sasang tau ang may tanek nang pinagluakan na ta panay ubas. Pagkatapus ipinasikasu na tung mga agsadur na. Pagkapiar na tung nira, dayun dang nagliit ang minangay duun tung dumang banwa ang duun da nagtinir ta mabuay. ");
INSERT INTO tbk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Numanyan pagkaw̱ut da yang kutitsya na, nagtuw̱ul da tung sasang turuw̱ulun nang mangay duun tung mga agsadur na ang para eklan na ra yang kaparti na tung patebas. Numanyan pagkaw̱ut yang turuw̱ulun na duun, anday dumang binuat yang mga agsadur tung anya, pinagtag̱aman da nira ta palu. Pagkatapus pinabalik da ilem nira ta paisanu. ");
INSERT INTO tbk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Utru si, pinaangayan si yang may prupidad tung sam bilug ang turuw̱ulun na. Pagkaw̱ut na, pinagtag̱aman da ka yang mga agsadur ta palung ineyak. Pagkatapus pinabalik da ka ilem nirang paisanu ang andang pisan ay ekel na. ");
INSERT INTO tbk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mag̱uman, may turuw̱ulun nang pangyaklu ang ipinangay na duun. Pagkaw̱ut na, pinagtigbak nira ta mupia ang pagkatapus ibinalilang da ka ilem nira duun tung lua yang kaubasan. ");
INSERT INTO tbk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Numanyan pagkabalita yang may tanek, napag̱isip da ang mag̱aning tung sadili na, ‘Unu pa kayay maayen ang buatenu? Maayen pa siguru, yang anaung naang nag̱agegmaanu ta duru, ya si ay tuw̱ulunu ang mangay duun. Basi pa ra ilem ang ya ray galangen nira.’ ");
INSERT INTO tbk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Numanyan pagkabandaw ra yang mga agsadur tung ana nang magkakaw̱ut da, namagkeresen dang namagparaig̱u ang mag̱aning, ‘Naa pala, taa rag panganing yang manubli tung kaluakan ang naa. Maayen pa, imatayen ta ra ilem ug̱ud yaten da yang surublien na ra rin ang naa,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Purisu numanyan dayun da ka man nirang dineep ang ginuyuran duun tung lua yang kaubasan ang inimatay. Ta, unu pa w̱asu ay buaten yang may prupidad tung mga agsadur na? ");
INSERT INTO tbk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iugtulu tung numyu, anday dumang buaten na, angayen na ra ilem ang pangimatayen. Pagkatapus yang kaubasan na, ipaagsa na ra ilem tung duma,” ag̱aaning. Numanyan naang pamamati, pagkaintindi nira yang linegdangan yang pananglit ang atia, dayun dang namansituw̱al ang mag̱aning, “Belek eey! Indi ka tia siguru kunsibiren yang Dios!” ");
INSERT INTO tbk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Numanyan pagkagngel ni Jesus yang bales nira, baklu nagpadayun ang nagpaintindi yang gustu nang ianing, tinelengan na ra kanay tanira. Pagkatapus mag̱aning tung nira, “Tay kung tama yang numyung atia, ay pa ag̱ari yang pag̱intindi mi tung sam bilug pang pananglit ang naang napabtang tung kasulatan ang may batu unung pinasag̱i ang ya ray pinangindian yang mga manigpakdeng yang balay ay anda unu ay kuinta na, ang pagkatapus ya pa ka enged unu ay nagluang pinakaimpurtanting batung panielan yang lebat yang intirung balay? ");
INSERT INTO tbk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Utru si kung tung dumang batu ipananglitayu ang katulad ka tung napabtang tung kasulatan, kung tinu pa unu ay mabugsu ang tempa tung batung naa, asan da ilem unu nga barik-barikay. Dispuis, kung tinu pa unu ay mabugsuan na, pulbus da unung pisan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Numanyan yang mga sag̱ad tung mga urdinansa may yang mga paring arabubwat, pagkagngel nira yang mga pananglit ang atia, tinag̱aman da rin nirang deepen dang lag̱i ti Jesus tung uras ang atia. Ay pa ag̱ari, durung kasilag nira tung anya, ay nasiman da nira ang taniray nag̱apatemengan na tung mga pananglit ang atiang ibinitala na. Kasu ilem may pangamanan nira tung mga taung atiang buntun ang pamagpauyun tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kapurisu numanyan anday dumang binuat yang may mga katengdanan ang atia, namagbantay ra ilem ta ketat ang para matinlung ipagpadeep nira tung anya. Purisu namanuul da tung mga tau ang para mamagpaseen da ilem ang mamagpatulduk tung anya ang basi pa ra ilem madeepan nira ta kamali tung pamitala na, ang para may mapadatelan yang namanuw̱ul tung nirang mamagdimanda tung ni Adi Herodes. ");
INSERT INTO tbk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kapurisu numanyan yang mga taung atiing pinanuulan, namagpalenget da tung ni Jesus. Primiru pinagtag̱aman da nira ta buladas ang pinagdayaw-dayaw ang inaning, “Ameey, nag̱akdekan da yamen ang yang mga nag̱itulduk mu tung mga tau natetenged tung Dios purus tama. Dispuis tung pagparadapaten mu ta bitala tung nira, anday pinilikan, kung indi, pagturuldukuna yang kamatuuran kung unu pay kalelyag̱an yang Dios ang yay dapat ang tumanen nira. ");
INSERT INTO tbk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kung mga sarang tung nuyu, may talimaanen din yamen tung nuyu. Naang mga balayaran ang naang pag̱ipagawad ni Adi Cesar tung yaten ang mga Judio, uyun w̱asu tung mga katuw̱ulan yang Dios ang ita manggawad u balaw̱ag?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Piru kumus nadeep dang lag̱i ni Jesus yang manyu nira, napag̱aning da tung nira ang, “Ipateleng mi ra kanay tung yeen yang sam pidasung kuarta.” Pagteleng na, dayun dang nagtalimaan tung nira, “Ninu pang itsyuraay ang nabtang taa tung nigal ang naa? Ninu pang aranay ang namarka taa?” Mag̱aning ka tanirang namansituw̱al, “Ni Adi Cesar.” ");
INSERT INTO tbk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mag̱aning ka ti Jesus ang nagtimales, “Ig disir, yang kumpurming ipinasuad ni Adi Cesar tung pagkabetang na, ya iintrigaay ta tung anya, pati yang kumpurming ipinasuad yang Dios tung sadili na, ya ka iintrigaay ta tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Purisu indi ra nasarangan nira ti Jesus ang papagkamalien tung pamitala na ang para ya ra rin ay ipagpakulain tung anya yang mga taung pamamati. Kung indi, kumus dineeg da yang pagkabereng nirang duru tung itinuw̱al nang atia tung nira, namagpaekmeng da ilem. ");
INSERT INTO tbk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Taa numanyan, yang namagdasun ang namagpalenget tung ni Jesus, ya ra yang mga pamagmangulung mga kinasakpan yang sasang partidung nag̱aranan tung mga Saduseo. Yang nag̱apaktelan nirang nag̱itulduk tung mga tau ay yang mga tau unung mga patay, indi ra unu magkarabui si kang uman. ");
INSERT INTO tbk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Numanyan mag̱aning tanira tung anya, “Ameey, may sasang urdinansang isinulat ni Moises ang ibinutwan na tung yaten ang kung mapatay unu yang sasang laliing kasawaan piru anda pay ana nira, yang putul nang kadasun na, ya unu ay dapat ang ipulin tung ni ipag nang nabalu ug̱ud kung maana tung anya, mapabtang dang ana yang putul nang napatay. ");
INSERT INTO tbk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ipabetang ta may pitu nga laliian ang magpurutul. Yang pangulu nangasawa tung sasang baw̱ay ang pagkatapus napatay ang indi naana. ");
INSERT INTO tbk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Numanyan yang putul nang nagdasun tung anya, ya si kay ipinulin ang ipinakasawa tung ni ipag nang nabalu. Ya ka, napatay ka ang indi ka naana. ");
INSERT INTO tbk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pati yang putul nirang pangyaklu, ya ka, ang asta ra ilem tung yapitu. Luw̱us dang nagkarapatay ang andang pisan ay naana tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pagkatapus tung kauri-urian da, pati yang baw̱ay, napatay ra ka. ");
INSERT INTO tbk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ta, ag̱aaninga ka ang yang mga taung nag̱apatay mabui si kang uman. Kung matuud ang yang pitung atiang magpurutul pati yang baw̱ay pabungkarasen yang Dios tung uri, abir, tinu pa w̱asu tung nira ay magnatis ang may kasawa tung baw̱ay ang atia, sindu parariung nangasawa-kasawa ra tanirang pitu tung anya? Abir, kung unu pay matuw̱al mu asan,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mag̱aning ti Jesus ang nagtuw̱al, “Simanyan tung panimpung naa, pagkarasawaan ka man yang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piru kumpurming tinu pang laliiay ubin baw̱ay ang binilang da kang lag̱i yang Dios ang magkabag̱ay ang magpalg̱ud tung panimpung baklu ang ya ra kay uras ang ipagpabungkaras na tung nira, tanira yay indi magkarasawaan ang uman. ");
INSERT INTO tbk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ministir pang magkarasawaan ay indi ra enged mapatay ang uman natetenged mamanulad da tung mga angil ang anday kamatayen. Bilang mga ana ra ka man yang Dios ang analadu gated pinagpabungkaras na ra nganing ang banal da. ");
INSERT INTO tbk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dispuis pa kung natetenged tung pagpabungkaras yang Dios tung mga patay tung uri ta kaldaw ang yay midyu maliwag ang panangden mi, maski nganing ti Moises mismu ang yay panalig̱an mi, nagpakdek da nganing ang talagang yay buaten yang Dios. Duun mi beklaray tung isinulat na natetenged tung naita nang palumpung ang atiing nag̱apuy ang pagkatapus indi ra ka nasiruk. Ya ray uras ang ipinagpailala yang Dios tung anya ang tanya unu ti Yawi ang yay Dios ang may mga tauan tung mga kinaampu nang na Abraham ni Isaac may ni Jacob. ");
INSERT INTO tbk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yang Dios tanya anday mga tauan nang patay, kung indi, pulus bui. Ay kipurki yang tanan ang mga tauan na, luw̱us bui tung anya ig pati nganing mga tinanguni nira, damayen na ra kang buien si kang uman tung uri,” ag̱aaning duun ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Numanyan may mga taung mga sag̱ad tung mga urdinansa asan ang pamamati. Pagkagngel nira yang ipinamarik ni Jesus tung katadlengan yang mga Saduseo, dayun dang inaning nira ti Jesus ang, “Ameey, talagang puirti yang pangatadlengan mung atia,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nangapagbitala ra ta maning tia, ay naita ra nira ang yang mga Saduseo namampaluw̱ay ra ilem ang indi ra namagpalangaas ang mamagpakigsug̱ang uman tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kapurisu simanyan, anday dumang binuat ni Jesus, yang mga sag̱ad ang atia, ya ray tinalimaan nang inaning, “Naang pag̱aningen ang Cristo, ya pa ag̱aring ag̱aningen yang duma ang tanya kanubli ka ilem ni Adi David? ");
INSERT INTO tbk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ti Adi David nganing mismu aparti yang anyang pagpabetang tung anya. Kipurki may isinulat na tung librung atiang pag̱aningen ang mga Karantaen ang maning taa yang bitala na. ‘Yang Ginuuu pinag̱aning da ni Yawi ang kumarung da kanay unu tung tepad na tung tuu ang asta pamirdien na unu yang pamagkuntra tung anya ang asan da ka unu ipampabtangay na tung tarampakan yang kakay na.’ ");
INSERT INTO tbk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ta, telengan mi. Yang pag̱aningen ang Cristo duun da sambitay ni Adi David ang Ginuu na. Ya pa ag̱aring magyaring kanubli na ka ilem?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Numanyan may bitalang ipinagngel ni Jesus tung mga taung atiang nag̱apangugyatan na ang nagngel ka yang kadaklan ang pamamati. ");
INSERT INTO tbk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ag̱aaning tung nira, “Mangamanamu ang indiamu enged mag̱usuy tung ug̱ali yang mga taung naang mga sag̱ad tung mga urdinansa ay yang pag̱asikad enged nira ang tanira dayawen ta mga tau. Katulad da asan tung panggawi-gawi nira ang yang aw̱el nirang atiang langkuy, pirmi ra ilem ang nag̱ipabeka nirang nag̱ipasapet tung mga tau. Ig kung mamasyar da nganing tung mga plasa, duru kang kalelyag nirang kumustaen ta mga taung galangen ta maayen ang tanira darakulu ka man ang mga tau. Pariu ka ta laksu kung mamagsimba ra nganing tung mga pagsaragpunan. Yang piliken nirang karungan, ya ra yang nag̱itig̱ana tung darakulung mga tau ang mas abwat ta pagkabetang tung nira. Ubin tung mga punsiun man, ya ka. Piliken nira yang pinakamatinlung karungan. ");
INSERT INTO tbk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dispuis pa masyadung magpanlepes tung mga baw̱ay ang mga balu ang para yang mga ganadus nira mapiar da tung nira. Pagkatapus ang para manalig da yang isip yang balu, papagmuug̱un da ilem nira yang pag̱arampuen nira. Purisu yang mga taung mga maning tia, asan da nga dulangay nirang nga dulangay yang kalelebaten yang sintinsia ang ipakdul tung nira,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Numanyan, atiing duun pa ti Jesus tung pagtuuan ang atiang pinakalusu, pagpaniid da tung mga manggaranen ang pamagburugsuan ta kuarta tung mga alkansia, ang ya ray nag̱ibuluntad nira tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pagkatapus, may sasang baw̱ay ang balu ang durug liwag yang pakabetang na ang yay nagpalenget tung alkansiang namugsu ta nigal ang duruang bilug ang pagbaluran ta pinakabaratu. ");
INSERT INTO tbk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pagkaita ni Jesus, dayun dang nagbitala tung mga tau, “Teed mi tiang balung maliliwag̱en! Iugtulu tung numyu yang kamatuuran, kung timbangen yang Dios, mas dakulu ta kantidad nakaang ibinugsu na kay tung tanan ang nakaang ipinamugsu nirang kadaklan. ");
INSERT INTO tbk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ay ya pa ag̱ari, yang kaalimbawaan yang ipinamugsu nira, maning pa tung ya ra ilem yang kinalis nira tung gantangan ang nagsubra. Piru tiang balu, maskin anggan da ilem yang kuarta nang nag̱itig̱ana na ra rin tung pagpangabui na, luw̱us na ra ilem ang ibinugsu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Numanyan yang mga tauan ni Jesus ang duma pamagkeresen-kesen da natetenged tung pagtuuan ang atiang pinakalusu. Pamaninluan dang pamagteleng tung mga batung darakulung malinang-linang ang tinambi-tambi tung padir na may tung mga pasadyang ipinamuluntad ta duma may ruma ang ipinadpet asan. ");
INSERT INTO tbk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mag̱aning ti Jesus ang nagngel yang keresen-kesen nira, “Kung natetenged tung mga bag̱ay ang atiang mag̱atelengan mi numanyan, may uras ang kaw̱utun ang yang mga batung atiang darakulung pinasag̱i ang tinambi-tambi asan, anda rang pisan ay mabutwan pang magsarampaw-sampawan, kung indi, luw̱us dang magkarapanpan tung tanek,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pagkagngel nira tia, dayun dang namagtalimaan tung anyang mag̱aning, “Ameey, sanu pa w̱asu magkamaning da ta maning tiang nainambit mu nungayna? Unu pang pruibaay ang sarang matandaan yamen ang alenget dang kumaw̱ut?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ag̱aaning ti Jesus ang nagtimales, “Mangamanamu ta mupia ang para indiamu madayaan ta dumang mapatalang. Kipurki durung maglua ang mag̱ambu ang tanya unu ya ray yuung pag̱aningen ang Cristo. Aningenamu ka anya ang kinaw̱ut da unu yang uras ang ipagpalua na unu yang paggaraemen na. Piru ta numyu indiamu enged magpaekel ta kulu ming magpanunut tung mga taung mga maning tia. ");
INSERT INTO tbk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dispuis, kung mabalitaanamu ra nganing natetenged tung mga gira ubin mga gulu, indiamu ilem magpakataranta. Ay kipurki yang mga bag̱ay ang atia, dapat ang magkarainabu, piru indiamu maglaum ang yang magdasun, ya ra yang uras ang ipagtapus yang Dios tung panimpung naa.” ");
INSERT INTO tbk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mag̱aning ti Jesus ang nagsugpat yang bitala na, “Nasyun may nasyun magbaratukan. ");
INSERT INTO tbk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dispuis may magpanaw ang mga yegyeg ang maktel tung duma-rumang banwa pati mga panuw̱uk ya ka, asta mga dilikadung mga laru dumalpet ka tung mga tau ang maninga panilig. Dispuis pa may mga pruibang maktel duun tung langit ang maita yang mga tau ang ya ray eldan nirang ipagpangerel ta duru. ");
INSERT INTO tbk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Piru baklu magkarainabu yang mga bag̱ay ang atia, deepenamu ra ta mga taung papinitinsiaen. Idimandaamu ra ka nirang ipabista tung mga pamagmaepet-epet duun tung pagsaragpunan nira ang pagkatapus ipakalabusamu ra nira. Ang kaisan guyuranamung patalungaen tung mga adi may tung mga gubirnadur natetenged ilem tung yeen ang nag̱akegngan mi. ");
INSERT INTO tbk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Asanamu ra nga pakdulay ta lugar ming magpaingmatuud tung nira natetenged tung nag̱askean mi natetenged tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yang ipabtang mi rang lag̱i tung mga isip mi ang indiamu magsuma-suma ta mga katadlengan mi bakluamu manalunga tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anday ministir ming magsimpan ta maning tia, ay kipurki yuuy magpainunuku tung numyu ta matinlung ipanuw̱al mi tung pamagkuntra tung numyu ang inding pisan masarangan nirang bariken. ");
INSERT INTO tbk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dispuis, maski nganing yang sadiling mga ginikanan mi, sadiling mga putul mi ubin yang may mga kaampiran tung numyu, pati mga ungkuy mi, ya pay mamagdimanda tung numyu tung katalungaan yang mga usgadu ig may duma pa asan tung numyu ang ipaimatay pa nira. ");
INSERT INTO tbk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dispuis demtanamu ra ka ta maskin tinu pang tauay arangan da ilem tung yeen ang nag̱akegngan mi. ");
INSERT INTO tbk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piru maskin imatayenamu nira, indi ra maunu pa yang kaampiran mi tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kung magpatentenamu yang mga isip ming magpadayun ka enged tung pagtaralig̱en mi tung yeen, maskin imatayenamu pa, asan da nga siguruay mi yang kaampiran mi tung Dios ang asta tung sampa magsarapenanamu ra. ");
INSERT INTO tbk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Piru kung maita mi ra nganing yang siudad ang naang Jerusalem ang magkulungun da ta mga sundalung buntun, ya ray pruibang tandaan mi ang makali rang magew̱a. ");
INSERT INTO tbk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pagkaw̱ut yang uras ang atia, kung tinu pay pagtinir tung sinakepan yang Judea, kaministiran ang magpalaksu rang lag̱i duun tung kabukiran. Kung tinu pay kaw̱utan na taa tung siudad ang naa, kaministiran ang maglua rang lag̱i. Kung tinu pay kaw̱utan na tung lua yang siudad, kaministiran ang indi magpakled ang para magpakubri, ang indi, magpalaksu ra ka. ");
INSERT INTO tbk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kipurki tung uras ang atia, ya ray uras ang ipagbales yang Dios tung nasyun ang naang Israel natetenged tung mga kabuat-buatan nira. Ay magkamatuud da ka enged yang tanan ang napabtang tung kasulatan ang natetenged tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kanugun yang pagkabetang yang mga baw̱ay ang pamagmalbat may yang mga talaana tung uras ang atia. Kipurki durug liwag yang pinitinsiang magkaw̱ut tung banwang naa. Talagang parusaan da ka enged yang Dios ta mupia yang nasyun ang naang mga Israel. ");
INSERT INTO tbk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yang duma panibatan da ilem ta sabling pangimatayen. Yang duma, pandeepen da ilem ang pangguyuran duun tung maskin ay pang banwaay tung bilug ang kaliw̱utan. Asta yang siudad ang naang Jerusalem, kemkemen ta duma-rumang nasyun ang ya ray magsurubli-subli ang mamaggaraemen ang asta kumampus da yang uras ang itinug̱ut yang Dios tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Dispuis pa, tung uri ta kaldaw, may mga pruibang makakaeled ang magkaraita tung kalangitan. Duun maita tung kaldaw, tung bulan, may tung mga dumakel. Dispuis tung katanekan, durug kagulu ay natetenged yang tanan ang mga tau, maskin unu pang nasyunay, mangataranta rang mamag̱iwaleg ta mupia. Ay yang pagkurian ta pag̱isip nira, ya ra yang teeb natetenged tung lakun ang pamag̱eyang ang belag dang patinumas yang kadarakul nira. Kung mamuka ra nganing, pamngel yang mga talinga nira natetenged tung dinag̱unu. ");
INSERT INTO tbk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Purisu panluluw̱ayan da ilem tanira tung eled nirang pamag̱elat tung kalainan ang magdarangat tung kaliw̱utan. Ay kipurki yang tanan ang bag̱ay tung kalangitan papagwaldang-waldangen da yang Dios tung dating pagkarabetangen nira. ");
INSERT INTO tbk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kung magkarainabu ra nganing tia, yuung pag̱aningen ang Maninga Tau maitaw ra yang mga tau ang yuug sasaay tung panganud ang paparanek ang yuu ra kag dawalay nirang duru rag kasusulaw yang pagkabetangung paggaraemen. ");
INSERT INTO tbk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Purisu ta numyung mga tauanu, kung mag̱impisa ra nganing ang magkarainabu ra yang mga pruibang atiang nag̱ianingu, indiamu magpaluw̱ay, kung indi, magpakasadyaamung pagpakbat tung yeen, ay alenget da yang uras ang ipagpalibriu tung numyu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Numanyan dayun dang nagsugpat ti Jesus tung nira ang nagpagngel ta sasang pananglit ang mag̱aning, “Isipen mi ra kanay yang ayung igus ubin maskin unu pang ayuay. ");
INSERT INTO tbk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kung maita mi ra nganing ang panguruk da, maskean mi ra ang makali rang kumaw̱ut yang tagkinit. ");
INSERT INTO tbk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Maning ka tia tung numyu. Kung maita mi ra nganing yang mga bag̱ay ang atiang nagkarasambitung pagkarainabu ra, maskean mi ra ka ang alenget da yang uras ang ipagpalapus da enged yang Dios yang paggaraemen na tung bilug ang kaliw̱utan. ");
INSERT INTO tbk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iugtulu tung numyu yang kamatuuran, baklu ra magkarapatay yang kadaklan ang mga masigkanasyun ta simanyan, kung magkarainabu ra yang tanan ang atiang inulaw ta nungayna. ");
INSERT INTO tbk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Matunaw yang kalangitan may yang kaliw̱utan, piru yang kumpurming nag̱ibitalaw indi ra enged ang pisan matunaw. ");
INSERT INTO tbk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Ug̱aring ta yamung mga tauanu, kaministiran ang insapuen ming pirmi yang mga sadili mi. Indiamu enged magpakalingat tung pagpakasadyang subrang pagpabuu. Pati yang pagpangabui mi tung kaliw̱utan ang naa, indi mi ka paliw̱eg̱an ta mga kulu mi. Muya kaw̱utanamu ra yang uras ang atiang makakaeled ang belag̱anamu riparasiun ang yang kaalimbawaan na maning pa tung sasang balatik ang inali ra ilem ang meyas. Kipurki yang tanan ang mga tau tung sagpaw yang kaliw̱utan, luw̱us ang mangasapul tung uras ang atia. ");
INSERT INTO tbk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Purisu pirmiamu rang riparasiun ang nunut da ka ta pag̱arampuen mi tung Dios ang paktelenamu ra enged anya ug̱ud kayanan ming agwantaen yang tanan ang mga bag̱ay ang atiang magkarainabu ang indiamu ka enged mamalpas tung yeen. Ay kung maagwantaan mi ra tia, anda ray ikaeyak ming manalunga tung yeen ang yuu ka man yang pag̱aningen ang Maninga Tau,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Numanyan kaldaw-kaldaw pagparakaw̱utun ti Jesus tung mga taung pamamati tung anya duun tung pagtuuan nirang atiang pinakalusu. Kung law̱ii ra nganing, ya ray paglua na tung siudad ang para mangay duun tung tinenaran yang bukid ang atiang durung mga ayung pag̱aningen ang olibo, ay duun nag̱aelek. ");
INSERT INTO tbk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dispuis, yang mga tau, timpranu pang pisan, duun da pamagtaragbu tung anya tung pagtuuan ang atia ay natetenged durung kalelyag nirang mamagpamati tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Taa simanyan alenget da yang pistang pag̱aningen yang mga Judio ang Nag̱ipagpangan Ta Tinapay Ang Indi Pinaleskag ang lug̱ud yang iapun nirang pag̱aningen ang Taklib. ");
INSERT INTO tbk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tung uras ang atii, yang mga paring arabubwat may naang mga sag̱ad tung mga urdinansa, pamagdilem da ta matinlung idya ang para ipaimatay nira ti Jesus. Yang indi ilem nira mapasinawan ang mapadeep ay pamangaman tung mga taung naang buntun ang pamagpauyun tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pagkatapus numanyan naang ti Judas ang Iscariote ang yay sam bilug tung nirang mga tauan ni Jesus ang sam puluk may durua, pinaalengtan da ni Satanas yang isip nang linuyuk ang asta nagbilug. ");
INSERT INTO tbk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Purisu numanyan, anda ray dumang binuat na, diritsyu rang nag̱angay duun tung mga paring arabubwat ta katengdanan may tung mga kapitan yang mga manigbantay yang pagtuuan ang pinakalusu. Nagpakigkesen da tung nira kung ya pa ag̱aring mapadeep na ti Jesus ang para maintriga ra tung pudir nira. ");
INSERT INTO tbk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Numanyan pagkagngel nira tia, namagkalipay ra ta duru. Dayun dang namagpangaku tung anya ang mapadeep na ilem ti Jesus, ay pakdulan nira ta kuarta. ");
INSERT INTO tbk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Purisu nagpaayag da tung nira. Numanyan nagbantay ra ta ketat ang para mapadeep na ti Jesus tung nira ang indi ka makdekan ta kadaklan ang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Taa numanyan kuminaw̱ut da yang pistang pag̱aningen ang Nag̱ipagpangan Ta Tinapay Ang Indi Pinaleskag ang ya ra kay kaldaw ang dapat ipagdasag nira tung mga karnirung ipagsera nira tung iapun nirang pag̱aningen ang Taklib. ");
INSERT INTO tbk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Purisu ti Jesus nanuw̱ul da tung ni Pedro durua ni Juan ang mag̱aning, “Ala, magsimpanamu ra yang iapun tang para silibraen ta yang pistang naang Taklib,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mag̱aning tanirang namagtimales, “Ariami pa w̱asung balayay magsimpan?” ");
INSERT INTO tbk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mag̱aning ti Jesus ang nagtuw̱al, “Patandaan mi, kumaw̱utamu ra nganing duun tung siudad, may mabag̱as ming sasang laliing pagsakan ta tiw̱ud ang punuk ta wai. Ya ray nuntun mi ang asta pumakled tung balay. ");
INSERT INTO tbk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kung magpakleramu ra nganing duun, yamu ra ag̱aaning tung may balay, ‘Yami minangayami ra ilem taa, ay yang tuyun ni Ginuu tang pagturuldukanen tung yaten, itulduk mu unu tung yamen yang kuartung pagyapunan nang magsilibra tung pistang naang Taklib, kasiraanami ra kang mga taung nag̱apangugyatan na.’ ");
INSERT INTO tbk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Atia itulduk na ra tung numyu yang kuartung dakulu duun tung yadwang gradu yang balay ang simpan da ka yang tanan ang garamiten ang tutal kaministiran ta. Asanamu ra magsimpan yang yapun ta,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kapurisu numanyan, nansiangay ra ka man duun tung siudad yang durua nga tauan ang atia. Pagkaw̱ut nira duun, kumpurming unu pay inaning ni Jesus tung nira, ya ra kang pisan ay kinaw̱utan nira. Purisu numanyan duun da ka man namagsimpan yang yapun nirang mamagsilibra tung pistang Taklib. ");
INSERT INTO tbk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Numanyan pagkaw̱ut yang uras ang ipagsilibra nira, nagpasintar da ti Jesus tung lamisaan ang para magyapun da, kasiraan da ka tanira yang mga taralig̱an na. ");
INSERT INTO tbk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Numanyan mag̱aning ti Jesus tung nira, “Duru-durung paglalangkag̱enu ang bakluaw mapasaran ta pinitinsia ang ita mapagsararuan da tung yapun tang naang pag̱ipagsilibra ta tung pistang Taklib. ");
INSERT INTO tbk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kipurki iugtulu tung numyu, yang yapun tang naa, may mas pang nag̱adapatan na ang indi pa maglutawan. Purisu yuu maskin indiaw ra mapagsilibrang uman yang yapun ang naa, yang nag̱aelatanu enged, kung mabilug̱an dang pisan yang ultimung nag̱adapatan na tung uras ang ipagpabistu rang pisan yang Dios yang paggaraemen na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pagkatapus numanyan namisik da ta sam basung binu ang ya ray pinasalamatan na tung Dios ang pagkatapus ipinarawat na tung mga aruman nang inaning, “Ia, ya ray pagbereles-belesan ming igmen. ");
INSERT INTO tbk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kipurki iugtulu tung numyu, mag̱impisa numanyan, indiaw ra manginem ang uman ta binung maning taa. Bakluaw ra manginem si kung kaw̱utun da nganing yang uras ang ipagpabistu ra enged ang pisan yang Dios yang paggaraemen na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pagkatapus numanyan dayun dang namisik ta tinapay ang ya ray pinasalamatan na tung Dios. Pagkatapus ya ra kay piningas-pingas nang ipinarawat tung mga aruman nang mag̱aning, “Atia, ya ra taang tinanguniu ang ya ray buatenung sasang dasag ang para asanamu ra nga paluasay tung sintinsia yang Dios. Kada mapangan mi tia, ya ray ipagdemdem mi tung yeen ang nagpakugmatay para tung numyu.” ");
INSERT INTO tbk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Numanyan pagkatapus nira ta pag̱iapun, maning ka tia yang binuat na tung sam basung binu. Tung pagparawat na tung nira, mag̱aning tung nirang nagpasanag, “Yang binung atiang inemen mi, ya ra taang dug̱uu ang ipaturuku arangan da ilem tung numyu ang para ya ray mapatielan yang Dios ang magtukud tung baklung ipagpakigpaig̱u na tung mga tau ug̱ud asan da nga panapnayay na. ");
INSERT INTO tbk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Piru teed mi, yang magtraidur tung yeen pagpakigsadu ra nganing taa tung lamisaan ang naa! ");
INSERT INTO tbk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tung bag̱ay, ta yeen ang pag̱aningen ang Maninga Tau, lug̱ud kang lag̱i tung planu yang Dios tung yeen ang yuug imatayay. Piru kanugun yang taung naang magtraidur tung yeen. Durug dakul yang panuw̱alan na tung uri,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Numanyan, pagkagngel yang mga aruman na, diritsyu rang namagbaralalaan ang namagturugyan-tugyanan ang tinu pa tung nira ay pagtimang magbuat yang maning tia. ");
INSERT INTO tbk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Taa numanyan, indi ilem nabuay, namagbaralalaan si kung tinu pa tung nira ay telengan ang abwat. ");
INSERT INTO tbk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Numanyan pagkagngel ni Jesus yang pagbaralalaan nirang atia, dayun dang nagpainunuku tung nirang mag̱aning, “Telengan mi ra ilem yang mga ading pamaggaraemen tung duma-rumang banwa. Yang kagaeman nira ya ag̱ipandeeg-deeg̱ay nira tung mga kinasakpan nira. Teed mi, tanirang pamagpanlepes tung mga sakep nira, ya pay pamagpadayaw ang tanira unu pamagpakaayen buat yang banwa! ");
INSERT INTO tbk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piru ta numyu, indiaw ka enged malelyag ang yay usuyun mi yang sistima nirang atia. Kung indi, kung tinu pa tung numyu ay pag̱atelengan ang abwat yang mga aruman na, anday dumang pagpabetang na tung sadili na, tanya maning pa tung sasang ari nirang tanan. Dispuis kung tinu pa man tung numyu ay pagmangulu tung mga kaarumanan na, yang pagpabetang na tung sadili na, tanya maning pa tung sasang maniglamisa tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tinu pa w̱asu ay abwat tung sasang pagpalamisa may tung paglamisa tung anya? Belag bang yang pagpalamisa yay abwat? Piru ta yeen, yang pusisiunu tung grupu ta maningaw ra ilem tung sasang maniglamisa tung numyu. ");
INSERT INTO tbk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Piru maskin nag̱apagbitalaw ra ta maning tia, pagpasalamataw ka enged ang ta yamu durug tinlu yang pagpakiunung mi tung yeen tung tanan ang mga kaliwag̱an ang napasaranu. ");
INSERT INTO tbk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Purisu ta yeen, kumus pinakdulanaw ra ni Ama ta katengdananung maggaraemen tung uri, pakdulanamu ra ka yeen ta maning ka tia ug̱ud kung kaw̱utun da nganing yang uras ang atia, yang kaalimbawaan ta, maning pa tung sa nga lamisaananita ra ilem ang magsararuan ay pakarungunamu ra yeen tung mga puistu ming abubwat ang para maggaraemenamu ra tung sam puluk may duruang pinalaana yang nasyun tang Israel,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pagkatapus numanyan, ti Simon Pedro ya ray binugnu ni Jesus ang inaning, “Aay Simon, pagkeba-keba ra yang dedlaanu natetenged tung nuyu. Ag̱askean mu, ti Satanas napag̱ingaluk da ang yamung tanan itug̱ut da tung anya ang para tuungunamu ra anya. Yang kaalimbawaan yang pagtuung na tung numyu, maning pa tung taung pangaap ta paray. Muya yang pagtaralig̱en mi tung yeen, manulad da ka ilem tung kaap ang kalpes da ilem ang iplad. ");
INSERT INTO tbk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Piru atiing pag̱ingaluk na tung numyu, yawa enged ay ipinag̱ampuu, Simon, ang yang pagtaralig̱en mu tung yeen, indi na ra masarangan ang ludasen ang pisan. Purisu kung mademdema si nganing tung yeen ang magbalik, yawa ray magpadag̱en-dag̱en tung mga kaarumanan mu ang para mas pang kemeet yang pagtaralig̱en nira tung yeen,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mag̱aning ti Simon ang nagtimales, “Ginuu, bilug da yang isipung magpakiunung tung nuyu maskin yawa kalabusay, maskin yawa imatayay!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mag̱aning ti Jesus ang minles, “Aa Pedro, iugtulu tung nuyu, numaan ang law̱iing naa, baklu ra manuluk yang manu, maklua rang mag̱ingwara tung yeen ang indiaw pala ag̱ailala mu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Numanyan nagbitala ra ti Jesus tung nirang tanan ang mag̱aning, “Ta, atiing tinuw̱ulamu ra yeen ang magliliw̱utun ang indiamu tinugtanung mag̱ekel ta balun ming kuarta ubin mga balutan yang aw̱el ming irimaraan, pati mga sandalyas mi pang mga risirba, nakulanganamu ra w̱asu tung mga kaministiran mi?” Mag̱aning tanirang namansituw̱al, “Andang pisan ay kakulangan yamen.” ");
INSERT INTO tbk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mag̱aning ka ti Jesus ang nagtimales, “Piru numanyan aparti ra. Purisu kung tinu pa tung numyu ay may kuarta na ubin mga aw̱el nang irimaraan, kaministiran ang ekel-ekelan na rang magpanaw-panaw. Kung tinu pay anday sabli na, ipaalang na ra kanay yang lambung na ang para may ipangalang na ta sabli na. ");
INSERT INTO tbk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kipurki iugtulu tung numyu, may sasang napabtang tung kasulatan ang dapat ang magkamatuud da ang yuu unu, ipabtangaw ra ilem yang mga tau ang sasang kriminal ang dapat ang sintinsiaan tung kalainan. Ag̱askeanu ang indi ra ilem buay, ya ray mapasaranu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mag̱aning yang mga aruman na, “Ginuu, nani w̱a may durua ra nga sablian.” Mag̱aning ti Jesus ang minles, “Aa ustu ra tia. Midyu indiita ra ka ilem nagperetetan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Numanyan paglampud ni Jesus tung balay ang pinagyapunan nira, dayun dang nag̱angay duun tung tinenaran yang bukid ang atiang durung mga ayung pag̱aningen ang olibo. Ay ya ra kang lag̱i ay ug̱ali na kung mga law̱ii. Pati yang mga taung nag̱apangugyatan na, namagpakignunut da ka tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Numanyan pagkaw̱ut na duun tung lugar ang atii, pinag̱aning na yang mga aruman nang, “Mag̱ampuamu ra tung Dios ang paktelen na yang mga isip mi ang para indiamu madeeg̱an ta tuksu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Pagkatapus, nagpaag̱es da kanay tung nira ang yang pinaalawiran na, kumpurmi yang kaw̱utun yang ketel yang sasang taung mamatu. Pagkaw̱ut na duun, dayun dang luminuud ang nag̱intra ra pag̱arampuen ang mag̱aning, “Amaw, kung uyun ilem tung kalelyag̱an mu, ipataklib mu ra ilem tung yeen yang lain ang naang nag̱atalungaw. Piru maskin pag̱ianingu tii, belag̱an yang yeen ang sadiling kalelyag̱an ay matuman, kung indi, yang nuyu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Atii, may sasang angil ang liit tung langit ang ya ray nagpaita tung anyang nagpaktel tung kinaisipan na sigun tung kalelebaten na ang nag̱aliwag̱an na ta mupia ang ya ra kay nag̱ipagpadegte na tung pag̱arampuen nang duru. Ay nag̱aeyangan da ta ulas nang midyu ra ilem tung dug̱u ang magbuw̱ugsuk tung tanek. ");
INSERT INTO tbk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Numanyan, pagkatapus ni Jesus ta pag̱ampu, diritsyung kumindeng ang nagbalik tung mga aruman nang tulu. Kaw̱utan na tanira, naa pala mga elek da. Atii pala pinangampayan da ta kapungaw nirang duru ang ya ray inlek nira. ");
INSERT INTO tbk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Numanyan dayun dang pinamuaw ni Jesus ang inaning, “Baa tia! Elek mi rang elek! Ala, magbungkarasamu rang mag̱ampu tung Dios ug̱ud indiamu ra madeeg̱an ta tuksu!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Numanyan atiing indi pa nganing nag̱atapus ta pagbitala, asan da namansilput yang mga taung buntun. Anday dumang pag̱erekelen tung nira, ya ra taa ti Judas ang naang sasang aruman nirang mga tauan ni Jesus ang sam puluk may durua. Pagkaw̱ut na, dayun dang nagpalenget tung ni Jesus ang para ara-araan na. ");
INSERT INTO tbk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ag̱aaning ti Jesus tung anyang nagbugnu, “Baa tia, Judas, yuung pag̱aningen ang Maninga Tau, pag̱aara-araanaw ka nuyu, piru naa pala, yuu rag traiduray mu!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Numanyan naang mga kaarumanan ni Jesus, pagkasinti nira yang mainabu, ag̱aaning tanira tung anya, “Ta, Ginuu, mag̱aninga ilem kung taraw̱angan da yamen ta sibat.” ");
INSERT INTO tbk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Unaw̱is may sam bilug tung nirang nanibat tung sasang turuw̱ulun yang paring pinakalandaw ang pagkatapus yang talinga na tung tuu, ya ray nalampung. ");
INSERT INTO tbk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Numanyan pagkaita ni Jesus tia, dayun dang nagsambeng tung anyang mag̱aning, “Eey, ustu ra tia!” Pagkatapus diritsyung pinisik na yang talinga yang turuw̱ulun ang atiang inulik duun tung nalampungan na, ang ya ra kay pinagmupiaan na dayun. ");
INSERT INTO tbk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Numanyan asan tung mga taung atiang namanuyu duun ang para mamagdeep tung ni Jesus, may mga paring arabubwat ta katengdanan may mga kapitan tung mga manigguardia tung pagtuuan ang pinakalusu may mga pamagpakigmaepet tung nasyun nirang mga Judio. Numanyan yang mga taung atia, ya ra enged ay binugnu ni Jesus ang inaning, “Ayw̱a yuu sasang ribildi ang yuu rag sulungay mi ta mga geed may mga palu? ");
INSERT INTO tbk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ayw̱a kung yuu may kasalananu, ayw̱a indiaung lag̱ing dineep mi tan taa pa? Tutal kaldaw-kaldaw nagkasira-siraanita ra ka duun tung pagtuuan ang pinakalusu. Piru nag̱askeanu, nagkamaningaw ra ta maning taa, ay ya ra ka man taa yang uras ang ilinug̱ut yang Dios tung numyu ang kumpurming unu pay kalelyag̱an ming buaten tung yeen, matutuman mi ra yang tanan. Ay ya pa ag̱ari, ya ra ka man taa yang uras ang kemtel da enged yang trabaw ni Satanas ang durug kiklep,” ag̱aaning ti Jesus duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Atii dayun da ka man nirang dineep ang ingkelan duun tung balay yang paring pinakalandaw. Naa ti Pedrong naa, nanikad da ka tung nira, piru atii ra tung kauri-urian da ilem ang pisan. ");
INSERT INTO tbk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","May apuy ang pinagkalan duun tung kakngaan yang plasa-plasa yang balay. Nagpakilaket da ti Pedro tung mga taung kumarungan tung paliw̱ut yang apuy ang pamamarang. ");
INSERT INTO tbk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Numanyan may sasang turuw̱ulun ang baw̱ay ang naita tung ni Pedrong yag kakarung tung pag̱alanyag̱an yang apuy ang pamarang. Pinateek-teekan na ta mupia ang inilala. Pagkatapus dayun na rang binugnu ang, “Uay, atia pala sasa kang tauan yang taung nakaang nadeep!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pagkagngel ni Pedro tia, dayun dang nag̱ingwara ang mag̱aning, “Bee, yang baw̱ay kang naa ka! Indi nganing nag̱ailalaw yang taung atiang nag̱ianing mu kung tinu pa!” ");
INSERT INTO tbk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Buay-w̱uay ta gesye, may duma sing naita tung anya ang pagkatapus nagbugnu ka tung anyang mag̱aning, “Eey, yawa talagang sasang aruman na!” Mag̱aning ti Pedrong nagtuw̱al, “Bee, yang tau kang naa ka, yuu belag̱anaw tauan na, ey!” ");
INSERT INTO tbk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Numanyan, siguru may mga sang uras dang nagtaklib, may sam bilug sing tau asan ang nagpaugtun tung mga aruman nang nangilala. Ya si ay nabngang mag̱aning tung mga ugpu na, “Eey, kamatuuran ka man, yang taung naa, talagang sasang aruman yang taung nakaa, kipurki sasa kang Galileanen.” ");
INSERT INTO tbk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mag̱aning ti Pedrong nagtuw̱al, “Indi ilem nag̱aintindianu kung unu pay gustu mung ianing!” Numanyan atiang lag̱ing indi pa nganing nag̱atapus ta pagbitala, may manung nanuluk da. ");
INSERT INTO tbk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pagkatuluk da yang manu, ti Ginuu ta dayun dang nagbalyed ang tumineleng tung ni Pedro. Pagbinag̱asay yang mga mata nirang durua, baklu ra nga demdemay ni Pedro yang inaning ni Ginuu na tung anya ta nungayna, ang mag̱aning, “Pedro, numaan ang law̱ii, baklu manuluk yang manu, ang maklua rang mag̱ingwara tung yeen ang yuu pala indiaw ag̱ailala mu.” ");
INSERT INTO tbk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Numanyan pagkademdem ni Pedro tii, diritsyu rang luminua ang nag̱intra ra tarangiten ang duru rang pagsurug̱aten na. ");
INSERT INTO tbk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Taa numanyan yang mga taung naang pamagbantay tung ni Jesus, yang binuat nira tung anya, pinaalengtan da nirang pinedengan. Pagkatapus, pinikadaan da nira ta suntuk ang ya ray pagkalipayan nirang pag̱atalangkakan. Kada suntukun, dayun da nirang talimaanen ang, “Ta, atiing yawa bantug ang prupita, abir, pintuen mu kung tinu pa atiang nagtigbak tung nuyu!” ");
INSERT INTO tbk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dispuis duru pang mga bitalang malalain ang nag̱ipanalunga nira tung anyang nag̱ipagsaway. ");
INSERT INTO tbk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","Numanyan atiing pangayag da yang kaliw̱utan, namagsaragpun da yang mga pamagpakigmaepet tung nasyun ang Israel, may yang mga paring arabubwat ta katengdanan asta yang mga sag̱ad tung mga urdinansa. Pagkasagpun da nirang tanan, dayun da nirang pinaguuyan ti Jesus ang pinatalunga ang para bistaen da nira. Mag̱aning tanira tung anyang pamagbista, “Kung matuud ang yawa yang pag̱aningen ang Cristo, idikta mu taa mismu tung katalungaan yamen,” ag̱aaning. Tumuw̱al ti Jesus, “Aa maskin magtuw̱alaw pa, indiaw ra ka ilem panangeren mi. ");
INSERT INTO tbk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Dispuis kung unu pay talimaanenu tung numyu, indiaw ra ka ilem tuw̱alen mi. ");
INSERT INTO tbk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piru yang nag̱ianingu tung numyu ya ra taa. Yuung pinag̱ulang tukaw ang Maninga Tau, maskin naanaw ra tung pudir mi simanyan, piru indi ilem buay, pakarungunaw ra yang Dios tung tepad na tung tuu ug̱ud kasiraanami rang maggaraemen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pagkagngel nira tia, pinabalitektekan si nirang tinalimaan ang, “Ayw̱a, yang gustu mung ianing yawa yang pag̱aningen ang Ana Yang Dios?” Ag̱aaning ka ti Jesus ang nagtimales, “Yamu ka nganing ay pag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pagkagngel da nira tia, dayun dang namag̱araning-aningan dang mag̱aning, “Ta, telengan mi. Ayw̱a magkaministiranita pa ta dumang magsistigus, sindu atia ra, nagngel ta ra, nabitala na ra!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Numanyan tanirang tanan, diritsyu rang namansikdeng ang namag̱ekel tung ni Jesus duun tung katalungaan ni Gubirnadur Pilato ang para bistaen na. ");
INSERT INTO tbk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mamansikaw̱ut tanira duun, ti Jesus pinag̱intraan da nira bangdan ta sari-saring kasalanan. Mag̱aning tanira, “Maginuung Gubirnadur, yang taung naa nadeep yamen ang pagsulsul tung mga masigkanasyun yamen ang para mamagbatuk tung gubirnu ta. Nagngel da nganing yamen ang pagsunlug tung nira ang indi ra mamaggawad yang nag̱ipagpagawad ni Maginuung Adi Cesar duun tung Roma. Ay ya pa ag̱ari, pag̱ambu ang tanya unu yang pag̱aningen ang Cristo. Bilang tanya unu yang pinilik yang Dios ang maggaraemen tung yamen,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Numanyan pagkagngel ni Pilato tia, dayun na rang binista ti Jesus ang inaning, “Ta, atii matuud? Yawa yang Adi yang mga Judio?” Ag̱aaning ti Jesus ang tuminuw̱al, “Yawa ka nganing ay pag̱aning.” ");
INSERT INTO tbk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Numanyan pagkagngel ni Gubirnadur Pilato yang itinuw̱al ni Jesus, dayun dang nagbitala tung mga paring arabubwat ta katengdanan ang atiang pamagbangdan may tung mga taung nagkarasagpun da duun tung pag̱usgaran na. Mag̱aning tung nira, “Kung tung yeen mi ngaeklay yang disisiun, tung pagbistaw tung anya, andang pisan ay naitaung kasalanan ang para matumaranu ta aksiun,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piru naang pamagbangdan, belag ya mamagpauyun tung disisiun ni Gubirnadur Pilato, ang indi, ya mamagpatireg̱es ang mag̱aning, “Piru elat kanay, Maginuung Gubirnadur, yang taung naa, ekel tung nag̱itulduk na tung mga tau, pagpausbung tung kulu nirang para mamagbatuk tung gubirnu ta. Ya ray nag̱abuat nang impisa pa atiing primirung paglua na duun tung sinakepan yang Galilea, pati tung intirung sinakepan mung naang Judea, asta ra ilem simanyan ang taa ra tung siudad ang naa,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagkagngel ni Gubirnadur Pilato tia, dayun dang nagtalimaan tung nirang mag̱aning, “Ayw̱a, yang taung naa tag̱a Galilea?” ");
INSERT INTO tbk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Numanyan, pagkaintindi ni Pilato ang ti Jesus tag̱a duun ka man tung Galilea, anday dumang binuat na, diritsyu rang ipinaated na tung ni Gubirnadur Herodes ang yay may katengdanan tung banwang atii, ay nagkatuun ang tanya duun ka tung Jerusalem tung uras ang atii. Yang ipinagpangay ni Gubirnadur Pilato duun ay ug̱ud basi pa ra ilem ang ti Gubirnadur Herodes yay madisisiun. ");
INSERT INTO tbk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Numanyan pagkaw̱ut ni Jesus duun tung ni Adi Herodes, sinadyaan da ta mupia yang Adi. Ay tung tantung kabuay ra, gustu nang mag̱ilalaan da tanira natetenged tung nagkarabalitaan na natetenged tung anya. Ay yang pag̱asikad na enged ang basi pa ra ilem ang maita na ti Jesus ang magpalapus ta pruibang makabew̱ereng. ");
INSERT INTO tbk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Purisu numanyan duru-durung talimaan na tung anya, piru ti Jesus tanya, inding pisan nag̱iw̱ek-iw̱ek. ");
INSERT INTO tbk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Numanyan yang mga paring arabubwat may yang mga sag̱ad, ya ray namagpakigtalunga tung Adi ang namag̱intra ra bangdan ta mga malelbat tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Purisu numanyan, anday dumang dinangat na, ti Adi Herodes may yang mga badigard na, namag̱intra ra saway tung pagkabetang ni Jesus ang ya ray pag̱atag̱aman nira ta talangkak. Pinasuutan pa nganing nira ta aw̱el ang durug tinlung biristien ta mga adi. Pagkatapus ipinabalik da ilem ni Adi Herodes duun tung ni Gubirnadur Pilato ang maning da tia yang pagkabetang na. ");
INSERT INTO tbk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Naa pala, ti Adi Herodes ang naa may ti Gubirnadur Pilato, nabuay rang nagkasuayan tanira, piru tung kaldaw ang atii, nag̱inulikay ra yang pag̱ilalaan nira natetenged tung pagginalangay nirang nag̱inilalaay yang anya-anyang katengdanan. ");
INSERT INTO tbk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Numanyan, pagkabalik ni Jesus tung ni Gubirnadur Pilato, naang mga paring arabubwat ta katengdanan pati naang mga pamagpakigmaepet asta yang mga taung atiang buntun, pinampaguuyan na rang para mamagsaragpun si tung katalungaan na. ");
INSERT INTO tbk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pagkasagpun nira, dayun na rang inaning, “Yang taung naa ingkelan mi ra taa tung yeen ta nungayna ay pag̱abangdanan ming pagsulsul tung mga tau ang para mamagbatuk tung gubirnu. Pagkatapus pagbistaw tung anya taa tung katalungaan mi mismu, andang pisan ay naitaung kasalanan tung anya ang katulad tung nag̱ibangdan mi tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pati ti Gubirnadur Herodes, anda kay naita nang kasalanan tung anya. Telengan mi ra ilem, ipinabalik na ra nganing tung yeen. Purisu tama ka man ang yang taung naa, anday nabuatan nang kasalanan ang dapat ang matumbasan yang linawa na. ");
INSERT INTO tbk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Purisu maayen pa, paburdunanu ra ilem, baklu palpasayu,” ag̱aaning ti Gubirnadur Pilato. ");
INSERT INTO tbk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ang kasu ilem, belag ya mamagpauyun yang mga taung atiang buntun da tung nag̱aplanu ni Pilato, ya mamag̱intra kerendalen ang mag̱aning, “Yang taung atia dapat ang patayen da ilem! Ti Barabbas, yay gustu yamen ang palpasan mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Naa pala ti Barabbas ang naang pag̱aingaluk nira, kinalabus natetenged tung gulung tinukud na tung siudad ang Jerusalem ang pagkatapus tung gulung atii, may tau pang inimatay na. ");
INSERT INTO tbk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Numanyan, kumus yang kagustuan ni Gubirnadur Pilato ang ti Jesus yay palpasan na, ya ra kay inulit na tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Atii namangiseg dang namaglelpaken yang mga taung atiang buntun ang mag̱aning, “Ipalansang mu ra ilem tia tung krus!” ");
INSERT INTO tbk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Atii inulit si ni Gubirnadur Pilato yang inaning na ta nungayna. Bilang maklu rang bisis ang inaning na ang, “Ayw̱a, unu pang kasalananay ang binuatan na? Andang pisan ay naitaw tung anya ang dapat ang matumbasan yang linawa na. Purisu paburdunanu ra ilem baklu palpasayu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piru mas pang namagpatireg̱es ang namaglelpaken ang ti Jesus unu dapat ang ipalansang da ilem tung krus. Pagkatapus ya pay namandeeg ta nganga. ");
INSERT INTO tbk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Purisu numanyan anda ray dumang binuat ni Gubirnadur Pilato, nagpauyun da ilem tung pagpatireg̱es nira. ");
INSERT INTO tbk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yang taung pinatuw̱ulan nang pinalpasan, ya pa ka enged yang pag̱aingaluk nira ang ya pa ka man ay nagtukud ta gulu ang nangimatay ka pa man ta tau ang ya ra kay nakalabusan na. Ang pagkatapus, ti Jesus tanya, ya ra ipatug̱ayay na tung kalelyag̱an yang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kapurisu numanyan, ti Jesus, ginuyuran da yang mga sundalu duun tung lua yang siudad ang para ilansang da nira tung krus. Numanyan tung pagparanawen nira, may sasang taung nabag̱as nirang tag̱a Cirene ang nag̱aranan tung ni Simon. Duun liit tung lua ang ya rag papakled tung siudad. Yang taung naa, ya ray pinapagsakan nira yang kaw̱ala yang krus ang pag̱asakan ni Jesus ang pagkatapus pinapagdasun da ilem nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Numanyan duru-durung mga taung namagdasun tung ni Jesus ang para mamagpaniid. Dakele kang mga baw̱ay ang nangalaket ang pamagtarangiten dang pamamukpuk yang mga debdeb nira natetenged tung panganugun nira tung anyang duru. ");
INSERT INTO tbk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Numanyan pagkagngel ni Jesus yang pagtarangiten nira, dayun dang minalikid ang nagbitala tung nira ang mag̱aning, “Yamung mga baw̱ay ang pag̱istar taa tung Jerusalem, belag da yuuy pagtangitan mi, kung indi, ya ra mismu yang mga sadili mi may yang mga ana mi, ya ray dapat ang pagtangitan mi. ");
INSERT INTO tbk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kipurki iugtulu tung numyu, may uras ang kumaw̱ut tung banwang naa yang sasang kaliwag̱an ang durug lebat. Ya ray uras ang yang mga tau mamag̱araning-aningan dang maayen pa unu yang mga baw̱ay ang mga bawas ang inding pisan napasar ta panalaana. Indi ilem yang mga kaarumanan nira ang may mga ana nira. Kipurki mabtangan ang pisan ta mga mata nira yang mga ana nirang pamagpaanut tung pinitinsia. ");
INSERT INTO tbk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kipurki kung kaw̱utun da nganing yang uras ang atiang nag̱ianingu, yang mga bukid ya ray tag̱aman nira ta lalang ang aningen, ‘Aay, tambakayami ra ilem!’ Pati yang mga bundu aningen ka nirang, ‘Aay, italukayami ra ilem,’ ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Talagang kumaw̱ut ang kumaw̱ut yang mga uras ang atia. Kipurki naa ra ilem tung yeen nga pruibaay mi. Kung maning taa nganing yang pag̱abuat yang mga taung naa tung yeen ang anda nganing ay nabuatanung kasalanan, ya pa yamung panalana tung uras ang panalungaan, malikayan mi pa w̱asu yang durug lebat ang atia?” mag̱aning ti Jesus duun tung mga baw̱ay. ");
INSERT INTO tbk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Taa numanyan may durua nga tauan ang mga kriminal ang pag̱aguyuran ka yang mga sundalu ang para ipagngan da nira tung ni Jesus ang imatayen. ");
INSERT INTO tbk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Numanyan yang rumbu nira duun tung sasang bundu ang yay pag̱aguuyan nirang Kulu. Numanyan pagkaw̱ut nira duun, ti Jesus dayun da nirang ilinansang tung krus. Asta naang durua nga kriminalan, ipinanlansang da ka nira tung krus tung binit ni Jesus ang nagtimbang. ");
INSERT INTO tbk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Numanyan ti Jesus tanya, nag̱ampu ra tung Dios ang mag̱aning, “Ama, patawaren mu tanira kipurki indi nira nag̱amaresmesan yang pag̱abuat nirang naa,” ag̱aaning. Numanyan anday dumang binuat yang mga sundalu, namagburunutan dang para maintindian da kung unu pang pidasuay ta mga aw̱el ni Jesus yang maeklan yang sasa may sasa tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Numanyan atiing pagpapinitinsia ra ti Jesus tung krus, yang bida yang mga tau, paniid da ilem ang paniid tung anya. Naang mga pamagpakigmaepet, ya ray namag̱insultu tung anya ang pamag̱araning-aningan dang mag̱aning, “Ag̱aaningamu ang duru rang napalibri nang tau. Ay ra takaa? Kung matuud ang tanya yang pag̱aningen ang Cristong pinilik yang Dios, abir, kung kayanan na ra ka yang sadili nang ilibri,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pati naang mga sundalu, binuat da ka ilem nirang kayaman. Nag̱apalengtan nirang nag̱apatuuy-tuuyan ta binung baratung pisan ang belag̱an bag̱ay ang irinemen ta sasang adi. ");
INSERT INTO tbk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ya ra ag̱aningay nira, “Abir, kung yawa matuud ang Adi yang mga Judio, ipalibri mu ra asan yang sadili mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dispuis pa belag̱an ilem maning tia ay pag̱abuat nira tung anya, kung indi, may sasa pang karatula ang itinaked duun tung tagbu yang kulu na ang yay pagpailala yang nag̱ipagbangdan tung anya, ang yang isinulat asan ya taa: “Naa yang Adi yang mga Judio.” ");
INSERT INTO tbk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pati atiang sam bilug ang ribildi ang ilinansang tung krus tung tepad ni Jesus, pagtaw̱ang da ka ta insultu tung anyang mag̱aning, “Mag̱aning ang yaway pinilik yang Dios ang magpundar yang paggaraemen na. Ala, bawien mu ra yang sadili mu, pati yami bawien mu ra ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pagkatapus ya ra sambengay yang aruman na kang ribildi tung duw̱ali ni Jesus ang inaning, “Abaa yang nuyung atia, india pa ka enged ag̱eyangan ta ipag̱eled mu tung Dios, naang naawita ra tung sa nga sintinsiaan? ");
INSERT INTO tbk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ta yaten ang durua, tung rugal yang sintinsiang naang ipinakdul tung yaten, ay magbalesenita ra natetenged tung mga binuatan ta. Piru yang aruman tang naa, andang pisan ay binuatan nang malain.” ");
INSERT INTO tbk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pagkatapus, dayun na rang inaning ti Jesus ang, “Jesus, demdemayaw ka kung kaw̱utun da nganing yang uras ang ipaggaraemen mu.” ");
INSERT INTO tbk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tumuw̱al ti Jesus “Naang bitalaung naa ang ipagngelu tung nuyu, ya ray pagbakeran yang isip mu. Numaan ang kaldaw, magkanunutanita ra duun tung kaismayaan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Numanyan atiing pagkereng da yang kaldaw, nangiklep da yang intirung banwang atii. Baklu ra ngaulikay yang sadlaw na ang mga pag̱alas tris da yang apun. ");
INSERT INTO tbk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Dispuis atiing makiklep pa, duun tung siudad, tung pagtuuan nirang atiang pinakalusu, yang kurtinang atiang yag sasalag̱a tung kuartung pinakasagradu, unaw̱is ya ra nga bakbak ang nautas tung kasubngan na. ");
INSERT INTO tbk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Numanyan duun tung krus, ti Jesus tanya nagkendal da ta maknul ang mag̱aning, “Amaw, italig̱u ra tung nuyu yang ispirituu.” Pagkabitala na tia, ya ra kay pagkabuntuk yang linawa na. ");
INSERT INTO tbk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Numanyan yang kapitan ang atiang pag̱erekelen tung mga sundalung namanlansang tung na Jesus, pagkaita na yang tanan ang atiang nagkarainabu, ya ra ngabnga ang mag̱aning, “Matuud ka man ang yang taung naa, andang pisan ay binuatan nang kasalanan,” mag̱aning. Yang ibinitala nang atii, midyu tung sasang pagdayaw na tung Dios. ");
INSERT INTO tbk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Numanyan yang tanan ang mga taung namagsaragpun da duun ang para mamagpaniid, pagkaita nira yang nainabu, namag̱urulikan da ilem ang masigpamukpuk yang anya-anyang debdeb natetenged tung kapupungawen nirang duru ang nangasakep tung sasang durug kalain ang buat. ");
INSERT INTO tbk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dispuis duun tung tukaw-tukaw may mga kailala ni Jesus pati mga baw̱ay ang atiing namagpakigluyug tung anyang atiing pagliit na duun tung Galilea ang para mag̱angay ra tung Jerusalem. Pamagpaniid da ka tung mga bag̱ay ang atiang pagkarainabu. ");
INSERT INTO tbk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Naa pala may sasang tau duun ang nag̱aranan tung ni Jose. Tanya duun ipanganaay tung Arimatea ang yay sasang lansangan ang pag̱istaran ta mga Judio. Dispuis tanya maayen ang tau ig matinumanen ka tung mga katuw̱ulan yang Dios. Maski sasa kang pagpakigmaepet tung nasyun nirang mga Judio, piru indi na ra ka enged pinauyunan yang pinag̱irig̱uan yang mga kaarumanan na ang ti Jesus dapat ang ipaimatay nira. Dispuis tanya durung pagpakbat na tung uras ang ipagpalapus yang Dios yang paggaraemen nang magbawi tung nasyun nira. ");
INSERT INTO tbk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Purisu numanyan naa ti Joseng naa, ya ray minangay duun tung ni Gubirnadur Pilato ang nag̱ingaluk kung maimung itug̱ut na tung anya yang tinanguni ni Jesus ang para ipalg̱ud na tung leyang. ");
INSERT INTO tbk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Numanyan pagkatug̱ut tung anya, dayun na rang binalikan ang ipinatangtang tung krus. Pagkatapus dayun na ra kang pinasaw̱ed-saw̱eran na ta aw̱el ang makulit ang matitinlung klasi. Pagkatapus tia, itinuw̱ul na rang ipalg̱ud da tung sasang leyang ang ipinabangbang na kang lag̱i tung batung padir. Dispuis pa yang leyang ang atia, baklung pagwad, indi pa nganing nag̱apalg̱uran ta taung patay. ");
INSERT INTO tbk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yang uras dang atii nagkatuun da tung uras ang dapat ang ipagtapus yang mga tau tung tanan ang pag̱urubraen nira ang para simpan da tanira tung pagkaw̱ut yang uras ang nag̱ipamaenay nira ang ya rang ya rang mag̱impisa tung pagkasantek yang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Taa numanyan atiing pag̱ekel na Jose tung tinanguni ni Jesus duun tung leyang ang atia, naang mga baw̱ay ang namagpakigluyug tung ni Jesus atiing pagliit na duun tung Galilea, namagpakignunut da ka tung nira. Purisu naita ra ka nira yang pinanlug̱uran tung anya. Pati yang pagpalg̱ud na Jose tung anya duun tung leyang, naita ra ka nira kung ya pa ag̱ari. ");
INSERT INTO tbk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pagkatapus, diritsyu ra tanirang namansibalik tung siudad ang namagsimpan da ta mga paamut ang para idulang nirang ipandasek tung aw̱el ang atiang isinaw̱ed-saw̱ed tung tinanguni ni Jesus. Numanyan pagkasantek da yang kaldaw ang ya ray uras ang ipag̱impisa tung kaldaw ang nag̱ipamaenay nira, namamaenay ra ka tanira ang katulad ka tung nag̱asambit tung katuw̱ulan yang Dios. ");
INSERT INTO tbk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Numanyan pagkaw̱ut yang primirung kaldaw tung seled sang linggu, bilang kaldaw ta Linggu ang baklu pa ilem agpandiklat yang sag̱iid, namagbalik da tanira duun tung pinanlug̱uran tung ni Jesus. Ekel-ekel nira tiing mga paamut ang pinagsimpan nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Numanyan pagkaw̱ut nira duun tung leyang, naa pala abirtu ra. Yang batung atiang pinasag̱ing bilug ang itinakep tung purta na, napalig̱id da tung sam belak. ");
INSERT INTO tbk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Purisu numanyan diritsyu rang namampakled. Pagkapakled nira, indi ra nira naita yang tinanguni na. ");
INSERT INTO tbk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Numanyan atiing nag̱aliwag̱an da ta durung pamag̱isip kung unu pa kayay linagpakan na, pinainalian dang limput ta durua nga laliian ang pamag̱aw̱el ta durug kasusulaw. ");
INSERT INTO tbk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Numanyan kumus pinamalayan da ta eled nirang duru, indi nganing mangateleng ta ustu tung mga laliing atia. Purisu ya ray nansibugnu tung nirang mag̱aning, “Ay tia, ayw̱at taa ra tung leyang ang naa agsagyapay mi yang taung bui? ");
INSERT INTO tbk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Anda ra taa, kung indi, pinabungkaras da yang Dios. Demdemen mi ra kanay yang inaning na tung numyu atiing duunamu pa rin tung Galilea ang tanya unung pag̱aningen ang Maninga Tau dapat unung iintriga tung pudir yang mga tag̱a dumang nasyun ang mga malalain ang mga tau, ang pagkatapus ilansang ka unu nira tung krus ang imatayen ang pagkatapus tung yaklung kaldaw unu magbungkaras ka,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Atii, baklu ra nga demdemay nira yang pinag̱aning ni Jesus ang atii tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Numanyan diritsyu tanirang namansiliit duun tung leyang ang namansibalik tung siudad. Pagkaw̱ut nira duun, namagbaw̱alitaen da tung mga tauan ni Jesus ang atiang dating sam puluk may sasa, pati tung kadaklan ang mga tauan na ang kinaw̱utan nira duun. ");
INSERT INTO tbk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ya ra taa yang mga aran yang mga baw̱ay ang atiing namagbaw̱alitaen tung mga apustul: ti Mariang atiang tag̱a Magdala, ti Juana, may ti Mariang atiang sam bilug ang yay nanay ni Santiago, pati yang mga kaarumanan ka nirang duma. ");
INSERT INTO tbk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dispirinsia ilem, kung pamatian yang mga apustul yang nag̱ibalita nira, indi ra ilem pinananged nira ay midyu tung anday kapulutan na tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piru ti Pedro tanya, pagkagngel na yang balita nira, diritsyu rang kumindeng ang naglaksu duun tung leyang. Numanyan tung pagkaw̱ut na, dayun na rang tinirib yang kakleran. Anday dumang natirib na, ya ra ilem yang mga aw̱el ang atiang ipinagsaw̱ed-saw̱ed tung tinanguni ni Jesus ang ya ra ileg bebtang asan. Pagtirib na, dayun dang nagbalik ang duru rang pagkabereng na tung naita nang atii. ");
INSERT INTO tbk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Taa numanyan tung kaldaw ang atii, tung nirang tanan ang mga tauan ni Jesus, may mga aruman nirang durua ang pansiangay ra duun tung baryung paggug̱uuyan ang Emaus, ang yang lawid na tung Jerusalem mga sam puluk may sasang kilometro. ");
INSERT INTO tbk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Numanyan yang pagparanawen nira ya kay pagkesen nira natetenged tung tanan ang atiang nagkarainabu. ");
INSERT INTO tbk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Numanyan atiing siging kesen nira ang nag̱alaktan da ta balalaan nirang kaisan, ti Jesus mismu nagpalenget da tung nirang nagpakignunut. ");
INSERT INTO tbk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tung bag̱ay, naita ra nira, piru indi ilem nailala nira ay natetenged pinapanlaw̱uk-law̱uk da yang Dios yang paneleng nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Numanyan mag̱aning ti Jesus ang nagbugnu tung nira, “Elat kanay, unu pa atiang pagkesenan ming pagbalalaan?” Atii, dayun dang nansitadeng. Indi mataluk tung mga itsyura nira ang tanira may pag̱asinti nirang kapupungawen ang duru. ");
INSERT INTO tbk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Numanyan yang sam bilug ang yay nag̱aranan tung ni Cleopas, ya ray nagtimales ang mag̱aning, “Siguru yawa ilem ang sam bilug ang pagdayu duun tung Jerusalem ang anday kaliw̱utan kung unu pay nagkarainabu.” ");
INSERT INTO tbk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mag̱aning ka tanyang nagtimales, “Ayw̱a, unu pay nagkarainabu?” Ag̱aaning ka tanirang nansituw̱al, “Atii w̱a, yang nagkarainabu tung ni Jesus ang tag̱a Nazaret. Tanya sasang manigpalatay yang bitala yang Dios ang bistung pisan yang kagaeman na tung mga pruibang ipinagpalapus na may tung ipinagtulduk nang durug kabuilu. Nauyunan da ngani ta mupia yang Dios, pati yang kadaklan ang mga tau. ");
INSERT INTO tbk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ang pagkatapus, yang mga paring arabubwat may yang pamagmangulu tung nasyun ta, anday dumang binuat nira tung anya, ya ra iintrigaay nira tung ni Gubirnadur Pilato ug̱ud masintinsiaan nang dapat ang imatayen ang pagkatapus ya ra ka dayun ipalansangay nira tung sasang krus. ");
INSERT INTO tbk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Abaw, piru ta yami, ya ra rin ay natalig̱an yamen ang magbawi tung nasyun tang Israel. Dispuis pa yaklu rang kaldaw numaan yang ikinagmatay na. ");
INSERT INTO tbk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Belag̱an ilem ya tii ay nainabu, kung indi, naberengami ra ka ta dakulung pagkabereng tung ibinalita tung yamen yang dumang mga aruman yamen ang mga baw̱ay. Ay kipurki ta nungaynang pangayag, namansiangay ra duun tung leyang ang atiing pinanlug̱uran tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kaw̱utan nira, indi ra naita nira yang tinanguni na. Purisu tung pagbalik nira, yang balita nira tung yamen, belag ilem ya tii, kung indi, tanira unu limput da ta mga angil ang ya unu ay namagbaw̱alitaen tung nira ang tanya unu nabui ra. ");
INSERT INTO tbk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Purisu pagkabalita yamen tung nira, may mga aruman yamen ang namansiangay ra ka duun tung pinanlug̱uran tung anya. Insapuen nira, ya ra ka man ang pisan tiing ibinalita yang mga baw̱ay. Piru ang ayw̱at indi ra ka naita nira tanya?” ");
INSERT INTO tbk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mag̱aning ka tanyang minles, “Aay, midyu tung anday naerem mi! Durug liwag pala tung mga isip mi ang yang tanan ang nagkarasulat yang mga manigpadapat ang tukaw yay luw̱us ang panangden mi! ");
INSERT INTO tbk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Belag bang may nagkaraula nira ang yang mga pinitinsia unung mga maning tiang naaning mi, ya unu ay dapat ang mapasaran yang pag̱aningen ang Cristo baklu unu nga padengeg̱ay yang Dios?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pagkatapus dayun na rang pinamadbaran yang mga painu-inu nira tung tanan ang napabtang tung kasulatan ang kumpurming nag̱adapat tung sadili na, impisa pa tung isinulat ni Moises ang asta ra tung nagkarasulat yang tanan ang mga manigpadapat sasa may sasa. ");
INSERT INTO tbk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Numanyan atiing alenget-lenget da tanira tung baryung nag̱adistinu yang durua, ti Jesus tanya midyu tung manlaw̱unus da ilem. ");
INSERT INTO tbk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pagkasinti nira, dayun da nirang inag̱apan ang inasig̱-asig ang inaning, “Ungkuy, maayen pang taawa ra ilem magdayun tung yamen. Apun da ka pa man. Muya malaw̱iiana pa tung dalan,” ag̱aaning. Numanyan, kumus matinlung imbitar tung anya, nagpaaw̱ek dang nagdayun duun tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pagkatapus numanyan atiing pagtaralungaan da tanira tung lamisaan ang mamagyapun da, ti Jesus ya ray nagmangulung namisik yang tinapay. Pagpisik na, dayun na rang pinasalamatan tung Dios yang yapun nira. Pagkatapus yang tinapay, ya ray piningas-pingas nang ipinarawat tung nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Atii, baklu ra nga liwayay yang paneleng nira tung anya. Duun da ngailalaay nira tung pag̱urulag̱en nang atii. Pagkatapus, napareng da ilem ang napalipat tung pagteleng nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Numanyan yang duruang naang nagkarabutwan, nagkesen dang mag̱aning, “Aa ka pala ya ray natengeran na nungayna tung dalan ang ginanaan dang lag̱i ta mupia yang mga isip tang namati tung anyang pagbadbad yang kasulatan tung yaten,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Numanyan anday dumang binuat nira, atiang lag̱i, nansikdeng dang nansibalik duun tung Jerusalem. Numanyan kaw̱utan nira yang sam puluk may sasang mga tauan ni Jesus ang atiang dati, saragpun da tanira yang mga kaarumanan ka nirang duma. ");
INSERT INTO tbk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Taa numanyan tingkawan da tanirang binalitaan yang kinaw̱utan nirang inaning, “Matuud ka man pala, ti Ginuu ta binui si ka man ang uman yang Dios! Nagpaita ra nganing tung ni Simon!” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pagkatapus yang duruang naa, pinatug̱uran da nira yang balita kung unu pay nainabu tung pagparanawen nira tung dalan, kung ya pa ag̱ari yang pagkailala nira tung ni Jesus atiing pagpingas-pingas na yang tinapay. ");
INSERT INTO tbk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Numanyan atiing indi pa nganing ag̱atapus tanira ta pagbitala, asan da lumimput ti Jesus tung pinagtaralungaan nirang tanan. Mag̱aning tung nira, “Paeyanganamu ra yang Dios ta paglimengan yang mga isip mi.” ");
INSERT INTO tbk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Atii ya ra ngaklag tanirang pinamalayan da ta eled nirang duru. Ay kanisip nira ang yang nag̱aita nirang atia sasang kalag. ");
INSERT INTO tbk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Purisu ag̱aaning ti Jesus tung nira, “Ayw̱a nag̱atarantaamu ra? Ayw̱a pagdua-dua pa yang mga isip mi? ");
INSERT INTO tbk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ala, telengan mi w̱a yang mga pursuu pati mga kakayu ang yuu ra ka man taa mismu. Ala pameg̱es-peg̱esanaw ra ka numyu ug̱ud masiguru mi ra ang yuu belag̱anaw sasang kalag. Kipurki yang kalag, anday isi na, anda kay duli na ang katulad ka tung yeen ang yag dawalay ming bilug ang tinanguni.” ");
INSERT INTO tbk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pagkaaning na tia, dayun na rang ipinaita tung nira yang mga ulat na tung pursu na may tung kakay na. ");
INSERT INTO tbk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Numanyan kumus dereeg̱en pa yang kasadyaan nirang subra may yang pagkabereng nirang duru, kanisip nira ang muya tanira ya ra ilem agkalang-kalangay. Purisu anday dumang binuat ni Jesus ang para makuat yang pagdua-dua nirang atia, nagtalimaan da tung nirang mag̱aning, “Anday pamangan mi asan?” ");
INSERT INTO tbk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pagkatapus dayun da nirang pinakdulan ta sam pukis ang ian ang kiniaw. ");
INSERT INTO tbk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pagdawat na yang ian, diritsyu rang pinangan na tung pinagtaralungaan nirang tanan. ");
INSERT INTO tbk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pagkatapus numanyan, dayun dang nagpasanag ti Jesus tung nirang mag̱aning, “Yang mga bag̱ay ang naang pinasaranu ya ra kang lag̱i ay ipinakdeku tung numyu tan taa ang pagnurunutanita pa rin ang yay dapat ang mainabu. Kipurki ag̱aaningaw kang lag̱i tung numyu ang yang tanan ang ipinagpasulat yang Dios ang tukaw tung ni Moises pati yang ipinagpasulat na tung mga manig̱ula asta yang napabtang tung Mga Karantaen, yang tanan ang atia ang kumpurming nag̱adapat tung yeen, ag̱aaningaw, indi maimung lumalis, kung indi, dapat luw̱us dang magkamatuud,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pagkatapus, yang mga painu-inu nira dayun na rang pinamadbaran tung mga kasulatan ang atia ang para mamaresmesan da nira ta mupia yang kumpurming nag̱adapat tung anya. ");
INSERT INTO tbk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Numanyan atiing alenget dang matapus yang pagbaradbaren na, mag̱aning tung nira, “Ta, kung papagbilug̱unu ra yang tanan ang atiang ipinagpasanag̱u tung numyu, yang pinakaisi na ya ra taa. Yang pag̱aningen unung Cristo, dapat unung mapasaran ta pinitinsiang durug lebat ang imatayen ang pagkatapus magbungkaras da ka unu tung yaklung kaldaw. ");
INSERT INTO tbk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yadwa pa, ekel unu tung pagpakugmatay nang atia pati pagbungkaras na, ya unu ay panielan yang Dios ang magpatawad tung mga tau ang kumpurmi unung manligna tung mga kasalanan na. Ya unu ay kamtangan yang balita ang dapat unung ipagpakaw̱ut tung tanan ang nasyun tung bilug ang kaliw̱utan, mag̱impisa unu taa tung siudad ang naang Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Purisu ta yamu, yang intindien mi ta mupia ang magpaingmatuuramu ra tung mga tau natetenged tung yeen ang yang nagkaraulang atiang napabtang tung kasulatan luw̱us da ka man ang nagkamatuud tung yeen. ");
INSERT INTO tbk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta yeen, paangayanamu ra yeen tung sasang pinangakuan ni Amang ang ipatinir na tung numyu. Purisu ta yamu magpabutwanamu ra kanay taa tung siudad ang asta malampuranamu ra yang Espiritu Santong liit tung langit ang yang kaalimbawaan mi pasuutanamu ra yeen tung puirsa na ang yay maning pa tung sasang aw̱elen mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Taa numanyan may sasang kaldaw ang ingkelan da ni Jesus yang mga tauan nang naglua tung siudad ang asta nangakaw̱ut da duun tung alenget yang Betania. Pagkaw̱ut nira duun, ti Jesus dayun dang nagpaabwat yang kalima nang nag̱ingaluk tung Dios ang paktelen na ra ta mupia yang mga aruman na. ");
INSERT INTO tbk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Numanyan mintras pag̱arampuen pa tanya ta maning tia, amat-amat dang papaabwat ay pag̱aeklan da yang Dios duun tung langit. ");
INSERT INTO tbk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Numanyan tanirang nagkarabutwan, dayun dang namagpadagpa tung tanek ang namagtuu tung anya. Pagkatapus namansibalik da duun tung Jerusalem ang duru rag kasadya yang mga isip nira. ");
INSERT INTO tbk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Numanyan yang kadagmitan tung nira, muya-muyang mamagsaragpun-sagpun duun tung pagtuuan ang atiang pinakalusu ang para mamagdarayawen tung Dios.");
INSERT INTO tbk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Atiing anda pay nag̱aimu, asan da kang lag̱i yang sasang maning pa tung bitalang ipinag̱aning yang Dios. Pagrinampilay kang lag̱i tanira yang Dios ig yang pagkadios yang Dios ya kay pagkadios na. ");
INSERT INTO tbk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tanya asan da kang lag̱i pagpakirampil tung Dios. ");
INSERT INTO tbk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yang tanan ang bag̱ay ipinaimu yang Dios tung anya. Kung belag̱an tung anya, andang pisan ay naimu, may sam bilug. ");
INSERT INTO tbk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tanya kang lag̱i yang nagpaguad yang baklung pagpangabui ang nag̱auyunan yang Dios ig katulad ka tung sasang kaas ang pagpasanag, yay kaalimbawaan nang nagpasanag tung kinaisipan yang mga tau ug̱ud asan da ngaeyangay ta ipag̱intindi nira tung Dios ang magkatama. ");
INSERT INTO tbk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Anday kabuntuk-buntukan yang pagparasanag̱en na tung makiklep ig indi ra enged nag̱adeeg̱an yang makiklep ang atia. ");
INSERT INTO tbk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Simanyan, may sasang taung tinuw̱ul yang Dios ang ti Juan yang aran na. ");
INSERT INTO tbk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yang inangay na taa ay magpaingmatuud tung mga tau natetenged tung kaas ang naa, ug̱ud yang tanan ang mga tau mamagtalig da tung anya natetenged tung pag̱ibalita na. ");
INSERT INTO tbk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Belag̱an ang mag̱aning ang tanya yang kaas, ang indi, yang inangay na ang tanya magpaingmatuud natetenged tung kaas. ");
INSERT INTO tbk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kung masig̱aak yang sasang kaas ang pagpasanag, mas pa yang maning pa tung kaas ang naa, ay nag̱apalengetan na yang kinaisipan yang mga tau taa tung kaliw̱utan ang naa ang para magpasanag tung nira. ");
INSERT INTO tbk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Taa kang lag̱i tanya tung kaliw̱utan ang naa ig yang intirung kaliw̱utan pati yang tanan ang mga betang na luw̱us ang ipinaimu yang Dios tung anya. Piru ya pa kay indi ra inilala yang mga tau taa tung kaliw̱utan. ");
INSERT INTO tbk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Maskin duun mismu tung sadiling banwa na naglua, piru indi ra ka enged pinauyunan yang mga masigkanasyun na. ");
INSERT INTO tbk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piru kumpurming tinu pay nagpauyun tung anyang nagtalig, ya ray pinakdulan na ta pudir nirang mag̱ing mga ana yang Dios. ");
INSERT INTO tbk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nagyari rang mga ana na ka man belag̱an ang mag̱aning ang natetenged yay natauan dang lag̱i nira ekel tung ama nirang naana tung nira, kung indi, yang Dios mismu ya ray maning pa tung naana tung nira. ");
INSERT INTO tbk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Simanyan, yang maning pa tung bitalang naang ipinag̱aning yang Dios, nag̱ing taung bilug ig nagpakigsapen da tung yamen. Pinateek-teekan ka yamen yang kadengeg̱an na ang yay bag̱ay ang pisan tung anya ay lusung pisan yang pag̱anaan nirang mag̱ama ang tanya duun ka man nanliit tung pag̱aningen nang Ama na. Ay pinaitaanami ra nganing anya ta kaneeman nang durung pisan agkatinlu ig duun ka tung anya nga bilug̱ay yamen yang ultimung pagkadios yang Dios ang anday pagkakulang. ");
INSERT INTO tbk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pati nganing ti Juan ang naang manigbenyag, nagpaingmatuud da ka natetenged tung maning pa tung bitalang naang ipinag̱aning yang Dios ay nagparakaw̱utun da tung mga tau ang maning taa: “Atia ra yang taung ibinalitaw ra kang lag̱i tung numyu ang atiing pag̱aningu ang may sasang taung maglua ang maskin nag̱auri pa tung yeen, piru mas abwat ta katengdanan tung yeen ay natetenged bakluaw natau, tanya asan da kang lag̱i.” Yay aning ni Juan ang nagpaingmatuud tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ag̱aningenu ang tung anya ka man nga bilug̱ay yamen yang ultimung pagkadios yang Dios ay maskin yaming tanan tani, ikinaayen da ka yamen yang katinlu yang isip na ay anda enged ang pisan ay kaluw̱us-luw̱usan yang kaneeman nang atiang durung pisan agkaaw̱unda. ");
INSERT INTO tbk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ayw̱a indi maaningu tia ay kipurki telengan mi ra ilem. Atiing tukaw yang mga katuw̱ulan yang Dios ibinutwan ni Moises tung nasyun ta. Ang pagkatapus numanyan, kung ipasunaid pa tung unu pa enged ay kantidad yang kaneeman yang Dios may yang kamtangan yang pagkadios na, asan da enged nga bilug̱ay ta tung ni Jesu-Cristo. ");
INSERT INTO tbk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yang Dios, disti pa atii tung katebtew̱an, andang pisan ay taung naita tung pirsunal na, may sam bilug. Piru naang sasang inding pisan mapakdingan ang ya ka man mismu yang Dios ang pirming pagsinasaay tanirang mag̱ama, ya ray nagbadbad tung mga isip yamen natetenged tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kung natetenged tung pagpaingmatuud ni Juan ang naa tung mga tau, maning taa yang nainabu. Yang mga manigmangulu tung nasyun yamen ang mga Judio duun tung Jerusalem, ya ray namanuw̱ul tung mga aruman nirang mamagpasiguru ra kanay tung ni Juan kung unu pay katengdanan na. Yang pinanuw̱ul nira ya ra yang mga pari, kasiraan da ka tanira yang mga katabyang nirang duma. ");
INSERT INTO tbk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tung pagpasiguru nira tung ni Juan kung unu pay pagpabetang na tung sadili na, indi nag̱ambu, kung indi, nag̱ugtulun da yang matuud ang mag̱aning, “Yuu belag̱anaw yang pag̱aningen ang Cristo ang katulad ka tung pag̱alaum mi.” ");
INSERT INTO tbk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mag̱aning tanirang namagtimales, “Tay kung maning tii, tinua pang tauay? Yawa w̱asu ti Elias ang ya kang lag̱i ay nag̱aelat-elatan tang magbalik?” Mag̱aning ti Juan ang nagtuw̱al, “Belag!” Dayun da nirang pinasulitan ang tinalimaan ang, “Yawa w̱asu yang sasang manigpalatay yang bitala yang Dios ang atiing pinangakuan nang magkaw̱ut?” Mag̱aning ka tanya, “Belag ka!” ");
INSERT INTO tbk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Numanyan, namagpabalitektek pa ka enged ang namanalimaan tung anyang mag̱aning, “Balitaayami ka ta ustu kung tinua pang tauay ug̱ud mabalita ka yamen tung namanuw̱ul tung yamen. Unu pay pagpabetang mu tung sadili mu?” ");
INSERT INTO tbk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Numanyan tung tuw̱al ni Juan, ya ra ilem ulitay na yang sasang naula ni Isaias ang yay sasang manigpalatay yang bitala yang Dios atiing tukaw. Mag̱aning yang tuw̱al na, “Anday duma, yuu ra yang pinag̱ula tung kasulatan ang ya unu ay maglua taa tung banwang naang kapas ang para magparakaw̱utunaw tung mga tau. Yang ianingu unu tung nira, ang katulad ka tung pagtaradlengen tung sasang dalan ang panawan ta sasang Adi, kaministiran kang panadlengen da ka nira ta mupia yang mga kainaisipan nira ang para simpan dang mampauyun tung ni Ginuu tang magkakaw̱ut da,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yang mga taung atiang pamagpabalitektek tung ni Juan, pinanuw̱ul yang mga Pariseo. ");
INSERT INTO tbk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Taa numanyan, dayun-dayun yang pagpabalitektek nira tung ni Juan ang mag̱aning, “Naa pala, ag̱aaninga ka ang yawa belag̱an yang pag̱aningen ang Cristo, belag̱ana ka ti Elias, maski yang manigpalatay yang bitala yang Dios ang nag̱aelat-elatan ta, belag ka. Ay kung maning tii, ayw̱at pagpamenyag̱a pa ka enged tung mga tau? Unu pay kalelyag mung ianing?” ");
INSERT INTO tbk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yang tuw̱al ni Juan, maning taa: “Kung tung bag̱ay, yuu pagpamenyag̱aw ka man tung mga tau. Piru may sasang taung nalaket asan tung numyu ang indi mi pa nag̱ailala. ");
INSERT INTO tbk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Maskin nag̱auri pa tung yeen, piru mas abwat ta katengdanan tung yeen ang maskin nganing tung panguw̱ad da ilem yang lakgeng yang sandalyas na, indiaung pisan magkabag̱ay tung anya,” mag̱aning duun ti Juan. ");
INSERT INTO tbk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yang mga bag̱ay ang atia nainabu tung Betania, duun tung duw̱ali yang subang pag̱aningen ang Jordan, ay duun agpagberenyag̱en ti Juan tung mga tau. ");
INSERT INTO tbk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pangayag yang kaliw̱utan, ti Jesus naita ra ni Juan ang pagpalenget da tung anya. Diritsyu rang ipinasapet na tung mga tau ang mag̱aning, “Uay, atia raw̱a yang taung tinuw̱ul yang Dios ang manulad tung sasang karnirung sinday pa ang ya ag̱idasag̱ay ug̱ud duun da nga kuat yang pagkamakinasalananen tang mga tau tung pagterelengen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ya ra ka man tiang ibinalitaw ra kang lag̱i tung numyung tan taa pa ang atiing pag̱aningu ang may sasang taung maglua, mag̱aningaw, ang maskin nag̱auri pa tung yeen, piru mas abwat ta katengdanan tung yeen ay natetenged bakluaw natau, tanya asan da kang lag̱i. ");
INSERT INTO tbk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tan taa, maskin yuu ngani, indi pa nag̱ailalaw kung tinu pa. Piru minangayaw taa ang para magpamenyag tung mga tau ay ug̱ud asan da ngaipailalaayu yang taung atia tung intirung nasyun tang Israel,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Numanyan, ti Juan, dayun da yang pagpaingmatuud na tung nirang mag̱aning, “Atiing pagpameyag̱aw ra tung mga tau, may sasang taung naitaw rang pinangapunan dang pinakeenan yang Espiritu Santong napapariu ra tung kuari kalapati ang duun manliit tung langit. ");
INSERT INTO tbk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Baklu naitaw, indi pa ka man nag̱ailalaw, basta pinakdekaw ilem yang nagtuw̱ul tung yeen ang magberenyag̱en tung mga tau ang kung tinu pay maitaung pangapunan yang Espiritu Santong pakeenan, ya ra yang maning pa tung magberenyag̱an ka tung mga tau ekel tung pagpatinir na tung nira yang Espiritu Santo. ");
INSERT INTO tbk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Simanyan yang bag̱ay ang atia, sinakep dang pisan yang mataw. Purisu nag̱apagpaingmatuuraw ra nganing tung numyu ang yang taung atia talagang ya ra ka man yang pag̱aningen ang Ana Yang Dios,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pangayag, asan si ti Juan, kasiraan da ka tanira yang durua nga tauan nang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Numanyan pagpamalad ni Juan tung ni Jesus ang magtataklib da, ipinasapet na si tung mga aruman nang atiang durua ang mag̱aning, “Uay, atia raw̱a yang taung tinuw̱ul yang Dios ang magpakbung tung sasang karnirung sinday ang ya ag̱idasag̱ay,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagkagngel nira tia, dayun dang namagpakignunut tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Simanyan, pagbalyed ni Jesus, naita na ra tanirang pamagpakignunut da tung anya. Purisu tinalimaan na tanirang inaning, “Unu ray ministir mi?” Mag̱aning tanirang namagtimales, “Anda, Rabbi. Gustu ilem yamen ang makdekan kung aria pag pag̱istar.” (Tung bitala yamen ang mga Judio, yang puntus yang pangguuy nirang atiang Rabbi tung anya ay sasang manigtulduk.) ");
INSERT INTO tbk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mag̱aning ti Jesus ang minles, “Taniita, ug̱ud maita mi.” Kapurisu, nansinunut da ka man tung anyang asta naita ra ka man nira yang pag̱istaran na. Duun da ka namagdayun tung anya tung apun ang atia ay yang uras ang ipinagbarag̱as nira, mga alas kuatru ra kang lag̱i yang apun. ");
INSERT INTO tbk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yang sam bilug tung durua nga tauan ang atiing nagngel ka tung ipinasapet ni Juan ang pagkatapus nagpakignunut da tung ni Jesus, ya ra ti Andres ang ari ni Simon Pedro. ");
INSERT INTO tbk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Simanyan ya ray nagsagyap tung aka na. Pagbag̱as nira, dayun dang nagbaw̱alitaen tung anyang mag̱aning, “Manung, naita ra yamen yang Mananapnay ang pinangakuan yang Dios ang yay pag̱aningen tang Mesias,” mag̱aning. (Kung tung bitalang Giniriego, Cristo yang pangguuy yamen ang atia tung anya.) ");
INSERT INTO tbk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pagkatapus, dayun na rang ingkelan ti manung na tung ni Jesus. Numanyan, tung pagpamalad ni Jesus tung anya, dayun na rang inaning ang, “Yawa ti Simon ang ana ni Juan. Piru simanyan, papuanggaana ra yeen tung ni Cefas,” mag̱aning. (Kung ilakted tung bitalang Giniriego, yang papuangga nang atia ti Pedro). ");
INSERT INTO tbk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pangayag, naisip da ti Jesus ang mag̱angay duun tung parti Galilea. Kumaw̱ut duun, sinagyap na ti Felipe. Pagkasagyap na, dayun na rang inaning, “Felipe, magpakignunuta ra ka tung yeen ang magpaugyat,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti Felipeng naa, masigkabanwa ni Andres durua ni Pedro ang parariu tanirang tag̱a Betsaida. ");
INSERT INTO tbk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Simanyan, ti Felipe dayun dang nagsagyap tung ni Natanael. Pagkaita na, dayun na rang inaning ang, “Ungkuy, naita ra yamen yang taung pag̱aelatan tang inula ni Moises. Pati mga manigpalatay yang bitala yang Dios atiing tukaw pa nagkaraula ka natetenged tung anya. Ya ra ti Jesus ang ana ni Jose ang tag̱a Nazaret.” ");
INSERT INTO tbk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mag̱aning ti Natanael ang nagtimales, “Abee, ayw̱a, may tag̱a Nazaret ang maayen ang tau?” Mag̱aning ti Felipeng minles, “Alia, telengan mu w̱a,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Taa, simanyan, pagkaita ni Jesus tung ni Natanael ang pagpalenget da tung anya, ya ra ag̱aningay na, “Atia ka man ta taung bag̱ay ang pisan ang aningen ang kinasakpan yang nasyun tang naang Israel. Indi maskeng mag̱egtem kung unu pay nabtang tung isip na.” ");
INSERT INTO tbk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mag̱aning ti Natanael ang nagngel, “Abaa, ya pa ag̱aring nag̱askean mu ra yang ug̱aliu?” Mag̱aning ka ti Jesus ang nagtuw̱al, “Baklua ra g̱uuyay ni Felipe ta nungayna, nabandawa rang lag̱i yeen atiing duuna pa rin tung maglandungan yang igus mu.” ");
INSERT INTO tbk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mag̱aning ti Natanael ang minles, “Rabbi, talagang yawa yang pag̱aningen ang Ana Yang Dios ang nag̱aelatan yamen ang maggaraemen tung nasyun tang Israel.” ");
INSERT INTO tbk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mag̱aning ti Jesus, “Naa pala, Natanael, kalpesa ka ilem ang mananged tung yeen sigun tung inaningung atia tung nuyu ang nabandawa rang lag̱i yeen atiing duuna pa rin tung kapungul yang igus? Kulang pa tia. May mas pang makabew̱ereng ang maita mu.” ");
INSERT INTO tbk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mag̱aning ti Jesus ang nagpadayun yang bitala na, “Iugtulu tung numyung tanan yang kamatuuran. Yuung pag̱aningen ang ‘Maninga Tau’ kumus naawaw ra tung kaliw̱utan, mabilug̱anaw ra numyung yuu ray pagrarampilan yang mga tau may yang Dios. Ay may maita mi ra tung yeen ang magkaanggid-anggid tung nabag̱ay tung tinalakinep ni dipuntu Jacob atiing tukaw ang yang langit maning pa tung nag̱abri ra tung tagbu na ig may mga angil ang pag̱apanuw̱ul yang Dios ang namagpabalik-balik tung anya,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Taa simanyan tung yaklung kaldaw, may kumbira tung lansangan ang Cana duun ka tung sinakepan yang Galilea. Yang nanay ni Jesus duun agpagtaw̱ang. ");
INSERT INTO tbk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Asta ti Jesus may yaming nag̱apangugyatan na, pinag̱imbitarami ra kang magpasakep. ");
INSERT INTO tbk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Simanyan atiing pagkakulang da yang irinemen ang atiang pag̱aningen ang binu, nagpakdek da yang nanay ni Jesus tung anya ang mag̱aning, “Anda ray binu, nalubsan da tanira.” ");
INSERT INTO tbk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Diritsyung nagtuw̱al ti Jesus ang mag̱aning, “Siguru maskin indiaw ra aningen mu kung unu pay buatenu. Indi pag kaw̱utun yang urasu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Simanyan yang mga sirbintis ya ray inaning yang nanay nang mag̱aning, “Maskin unu pay ituw̱ul na tung numyu, buaten mi,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Taa numanyan may enem ang bilug ang tapayan asan ang parabtangan ta wai. Yang mga tapayan ang atia batung binangbangan. Ipinabtang asan ay tung dating pagturuuen yamen ang mga Judio tung Dios, durung mga riglamintung nag̱ausuy yamen sigun tung pag̱urug̱asen. Yang pakled nira, mga talaepat asta tung talaenem ang lata. ");
INSERT INTO tbk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Simanyan, mag̱aning ti Jesus tung mga sirbintis, “Ala, pamungkun mi ra kanay ta wai yang mga tapayan ang atia,” mag̱aning. Diritsyung pinamunuk nirang pisan. ");
INSERT INTO tbk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pagkapnuk, mag̱aning si ti Jesus tung nira, “Ala, sarukun mi ra kanay ang eklan duun tung kuimi,” mag̱aning. Pagkatapus dayun da ka man ang ingkelan nira tung kuimi. ");
INSERT INTO tbk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Simanyan, pagkatikmi na yang waing atiang nag̱imu rang binu, nabereng. Anday kaliw̱utan na kung ay pa liit yang binung atia, piru yang mga sirbintis ang namanaruk ya ilem ay nangakdek. Purisu yang binuat na, dayun na rang ginuuyan yang pangasawa ang inaning, “Yang nuyung atia, aparti ka. Yang kadagmitan ang buw̱uaten tung mga kumbira, simpri yang matinlung klasi ta binu ya ray ipatkaw ang ipalua. Kung midyu nangapagustu ra ngani ta inem yang mga bisita, baklu ra ipalapusay tiang mga sigunda. Naa pala ta nuyu, yang matinlu ya itig̱anaay mu! Numaan da ilem ipaluaay mu!” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yang binuat ni Jesus ang atia tung Cana duun tung sinakepan yang Galilea, yay primirung pisan ang pruibang makabew̱ereng ang binuat na. Ya ray nagpailala yang kagaeman na tung yamen ang nag̱apangugyatan na. Purisu asan da mas pang nagbaked yang pagtaralig̱en yamen tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Taa numanyan, tung pira pang kaldaw, nanuldak da ti Jesus duun tung lansangan ang Capernaum, kasiraan da ka tanira na nanay na, may yang mga putul na, asta yaming nag̱apangugyatan na. Duunami ra nagtinir ta pira pa ilem ang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Simanyan kumus gesye ra ilem yang uras ang kaw̱utun da yang pista yamen ang mga Judiong paggug̱uuyan ang Taklib, ti Jesus nanungul-tungul da duun tung Jerusalem, kasiraanami ra kang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kumaw̱ut tung pagtuuan ang atiang pinakalusu, duun da tung palayas na nga panaway na yang mga manigpaalang ta mga baka, mga karniru, may mga kalapati. May duun kang mga manigbailu yang kuarta yang mga tau ang para ikambiu tung kuarta nirang mga Judio. Kumarungan tung mga lamisaan nira. ");
INSERT INTO tbk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Numanyan, pagkaita ni Jesus tung nira, anday duma, nagpamegkes da ta mga pinling binuat na rang latigu. Ya ray ipinagpamurdun na tung nirang tanan ang ipinampalua, pati karniru pati baka. Asta yang mga lamisaan yang mga manigbailu ang atiang punuk ta mga kuarta, ya ray pinamaliskad na ang asta nagkaraburarag da ilem. ");
INSERT INTO tbk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pati mga manigpaalang ta kalapati, linalangan na ra kang inaning, “Eey, pangkelan mi ra ka tia duun tung lua! Yang balay ang naang pag̱atiniran ni Ama, indi mi ra pangaasan ang buaten ang palingki,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pagkagngel da yamen ang nag̱apangugyatan na, ya ra nga demdemay yamen yang sasang nabtang tung kasulatan ang mag̱aning, “Aay, Ampuanung Dios, yang kadererepenung pagdipindir tung kadengeg̱an yang balay mu, ya ra kay ikadiaduu,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Taa numanyan, kumus binuat da ni Jesus ta maning tia, dayun dang inusisa yang mga pamagmangulu tung nasyun yamen ang mga Judio ang inaning, “Abir, ipaita mu ra taa tung yamen yang sasang pruiba bilang kabakeran mu ang yaway may katengdanan ang magbuat ta maning tia taa tung pag̱atiniran enged yang Dios ang naa.” ");
INSERT INTO tbk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mag̱aning ka ti Jesus ang minles, “Ala, kung diaduen mi yang pag̱atiniran nang naa, puidi ka, piru tung seled yang tulung kaldaw pakdenganu si ka ta baklu.” ");
INSERT INTO tbk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mag̱aning tanirang namansituw̱al, “Abaa, tung seled ilem yang tulung kaldaw mapakdengan mu si ka ta baklu, ang epat dang puluk may enem ang takun yang pagparakdengen yang pag̱atiniran nang naa?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piru kung pasadsaran ta enged yang gustu ni Jesus ang ianing, anday dumang pag̱atiniran enged yang Dios ang atiang nag̱ianing na, kung indi, ya ra yang sadiling tinanguni na mismu. ");
INSERT INTO tbk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Purisu numanyan, atiing pinabungkaras da yang Dios, nademdeman da yamen ang pinagugyatan na ang ya ray nag̱abitala nang kaisan. Purisu duunami rang nag̱ingmatuud tung napabtang tung kasulatan natetenged tung pagkabui na si kang uman. Asta yang ibinitalang atia ni Jesus, pinananged da ka yamen. ");
INSERT INTO tbk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Taa, simanyan, atiing duun pa ti Jesus tung Jerusalem tung uras yang pistang atiing pag̱aningen ang Taklib, kadakel dang namananged da tung anya ang ya ra ka man yang pag̱aningen ang Cristo ay natetenged tung mga pruibang makabew̱ereng ang binuat na ang ya ray nagkaraita nira. ");
INSERT INTO tbk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piru ti Jesus tanya, indi na itinalig yang sadili na tung nira, ay kipurki kabisadu na ra ka tanirang tanan. ");
INSERT INTO tbk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Anday kaministiran nang balitaan pa natetenged tung ninu pang tauay, ay deep nang pisan yang pundu yang kinaisipan nira sasa may sasa. ");
INSERT INTO tbk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Numanyan, may sasang taung nag̱aranan tung ni Nicodemo. Tanya sasang kinasakpan yang grupung nag̱aranan tung mga Pariseo ig sasa kang pagpakigmaepet tung nasyun yamen ang mga Judio. ");
INSERT INTO tbk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","May sasang law̱ii ang minangay ra tung ni Jesus. Mag̱aning tung anya, “Rabbi, nag̱askean da yamen ang yaway sasang manigtulduk ang tinuw̱ul yang Dios ang magpasanag tung yamen. Kipurki anday mapagpalua ta mga pruibang mga maning tiang nag̱abuat mu kung indi nag̱apakigsasaan yang Dios.” ");
INSERT INTO tbk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mag̱aning ti Jesus ang minles, “Iugtulu tung nuyu yang kamatuuran, yang sasang tau, kung indi ipanganang uman, indi enged maimung maispirinsiaan na yang paggaraemen yang Dios tung anya.” ");
INSERT INTO tbk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mag̱aning ti Nicodemong minles, “Ya pa ag̱aring ipanganang uman yang sasang taung maepet da? Ayw̱a, makled pa kaya ang uman tung tian yang nanay na ang para ipangana na sing uman?” ");
INSERT INTO tbk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mag̱aning ka ti Jesus ang nagtuw̱al, “Iugtulu tung nuyu yang kamatuuran, kung tinu pay indi ipanganang uman ekel tung wai ig tung pag̱urubraen yang Espiritu Santo tung kinaisipan na, indi enged maimung malg̱ud tung paggaraemen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kipurki kung tinu pay ipinangana ta tau, yang pagkatau na tung tau ka manliit. Katulad ka tung sasang taung ipinanganang uman yang Espiritu Santong linimpiuan, may baklu ra kang pagkatau nang ipinaeyang da yang Dios tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","India ilem mabereng tung inaningung atia tung nuyu. Yang dapat mainabu tung numyung tanan ang ipanganaamu rang uman. ");
INSERT INTO tbk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Telengan mu ra ilem yang palet. Kung ay pay gustu nang meyep, duun da ilem meyep. Yang agrut na magngel mu, piru indi mu maskean kung ay pa manliit kung ay pa manganing. Yang pisan ay matinlung pananglitanu tung sasang taung ipinangana ra yang Espiritu Santo. Ay kung unu pay natengeran na ang yang taung atia nag̱uman da, indi enged masangkad ta tau. Piru mabistu ra enged tung pinakaw̱ut yang inubra na tung pagpangabui yang taung atia.” ");
INSERT INTO tbk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mag̱aning si ti Nicodemong minles, “Ya ra ilem ag̱ari kaya?” ");
INSERT INTO tbk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mag̱aning ti Jesus ang nagtuw̱al, “Yaway sasang nag̱abantug ang maayen ang magturuldukun tung mga masigkanasyun tang mga Israel, piru naa pala yang mga bag̱ay ang naa, indi mu nag̱aintindian. ");
INSERT INTO tbk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iugtulu tung nuyu yang kamatuuran, yang nag̱ipagpakaw̱ut yamen nag̱aintindian kang lag̱i yamen. Yang naita yamen mismu, ya ray nag̱ipagpaingmatuud yamen, piru ay pa w̱a? Indi mi ra ka ilem agpanangden yang nag̱ipagpaingmatuud yamen. ");
INSERT INTO tbk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kung indiaw ra ka ilem panangden ming pagpaingmatuud natetenged tung nag̱ainabu taa tung kaliw̱utan ang naa ang katulad ka tung nag̱ianingung atia nungayna, ya pa ag̱aring panangdenaw pa numyu kung magpaingmatuuraw pa natetenged tung nag̱ainabu duun tung langit? ");
INSERT INTO tbk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Andang pisan ay taung nag̱apagpaabwat duun tung langit ang para maskean na ra rin kung unu pay pagkarainabu duun. Piru ta yuung pag̱aningen ang Maninga Tau ultimu ra ilem yuuy kabisadu tung mga bag̱ay ang atia, ay duunaw ka man tung langit nanliit ang nagparanek taa. ");
INSERT INTO tbk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Dispuis, yang pambungunu pariu tung iraw ang atiing saway ang itinaken ni Moises tung ayu ang pagkatapus ya ag̱ipaabwatay duun tung banwang kapas. Bilang yuung pag̱aningen ang Maninga Tau, yuu kay ipaabwatay ug̱ud kung tinu pay magtalig yang sadili na tung yeen, indi ra magdayun yang pagkablag na tung Dios, kung indi, asan da kang lag̱i nga paeyangayu ta ipagpangabui nang baklu ang anday pagtapusan na,” mag̱aning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Natetenged ang durung pisan agkalutuk yang gegmang ibinuluntad yang Dios tung yaten ang mga tau, mismu yang pag̱aningen nang Ana nang inding pisan mapakdingan, ya ray ipinaangay na taa tung kaliw̱utan ang naa bilang maning pa tung sasang dasag. Ya ray binuat na ug̱ud kung tinu pay magtalig yang sadili na tung anya, indi ra magdayun yang pagkablag na tung Dios ang asta tung sampa, kung indi, asan da kang lag̱i nga paeyangay na ta ipagpangabui nang baklu ang anday pagtapusan na. ");
INSERT INTO tbk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kipurki yang ipinagpangay yang Dios tung pag̱aningen nang Ana Na taa tung kaliw̱utan ang naa, belag̱an ang mag̱aning ang para ya ray magsintinsia tung mga tau tung kalainan, ang indi, ug̱ud ekel tung anya magkaratapnay ra tanirang ipampalibri tung sintinsiang atia. ");
INSERT INTO tbk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kung tinu pay magtalig yang sadili na tung anya, indi ra ka enged sakpen yang sintinsiang atia. Piru kung tinu pay indi malelyag ang magtalig tung anya, katimbang nang pininig na rang lag̱i yang sadili na ang tanya sintinsiaan da ilem yang Dios tung kalainan. Ay indi na ra itinalig yang sadili na tung pag̱aningen ang “Ana Yang Dios” ang indi mapasiring-siringan. ");
INSERT INTO tbk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ay yang mga maning tiang tau, maning taa yang palaksu yang pagpapinig nira tung mga sadili nira. Ang patalungaen tung maning pa tung kaas ang naang nagkaw̱ut da tung kaliw̱utan, indi malelyag. Ang indi, yang makiklep ya pa ka enged ay pagmamaalen nira ay natetenged tung pagburuaten nirang mga malain. ");
INSERT INTO tbk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ay natural, kung tinu pay pagpadayun tung pagburuaten nang anday kuinta, pag̱alikayan na ta mupia yang kaas. Indi ra ka tia magpalenget tung kaas, nusias lumbaw ra yang mga buat-buat nang malalain. ");
INSERT INTO tbk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piru kung tinu pay pagpadayun tung pag̱urusuyun na tung nag̱akdekan nang magkatama, yay pagpalenget tung kaas ug̱ud mabistu ra ang tanya nag̱apakigsasaan da yang Dios tung mga buat-buat na. ");
INSERT INTO tbk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Taa numanyan, ti Jesus, dayun dang nagpanaw ang minangay duun tung sinakepan yang Judea, kasiraanami ra kang nag̱apangugyatan na. Duunami ra nag̱urugpu ta pira pang kaldaw ang nunut da ka yang pagberenyag̱en na tung mga tau duun. ");
INSERT INTO tbk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Taa, simanyan duun tung Enon ang alenget tung Salim, ti Juan ang naa, pagberenyag̱en da ka tung mga tau, ay bastanting wai duun. Purisu sigi-sigi ra yang pag̱arangayen yang mga tau duun tung anyang pamagpabenyag. ");
INSERT INTO tbk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yang uras ang atii ti Juan indi pa nag̱akalabus. ");
INSERT INTO tbk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Numanyan yang dumang nag̱apangugyatan ni Juan namagpakigsug̱a ra tung sasang masigka Judio nira natetenged tung mga patakaran ang nag̱usuyun ang para mapunasan da yang mga tau ta kasalanan nira. ");
INSERT INTO tbk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pagkatapus namagdangep da tung ni Juan ang namagkig̱a tung anyang mag̱aning, “Rabbi, nag̱ademdeman mung atiing duuna pa rin tung duw̱ali yang Jordan, may sasang aruman mung ipinagpailala mu tung mga tau? Naa pala, tanya unu pagberenyag̱en da ka! Yang kadaklan ang mga tau tung anya ra unu agpamagdangep!” ");
INSERT INTO tbk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mag̱aning ti Juan ang nagtuw̱al, “Ayw̱a, nag̱askean ta ra kang lag̱i ang maski tinu pa, kung may dengeg na, ay tia pinakdulan da yang Dios. ");
INSERT INTO tbk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Maski yamu mismu mapagsistigusamu ka tung pagkamatuud ang nag̱aningaw ra kang lag̱i ang belag̱anaw yang pag̱aningen ang Cristo, ang indi, yuu ilem agtuw̱ulay yang Dios ang mag̱ing palaskaw na. ");
INSERT INTO tbk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kung alimbawa may kumbira, yang laliing pangasawa ya ray may kasawa, belag̱an yang ungkuy nang nagpaiwan-iwan tung kumbira na. Ug̱aring, yang ungkuy na, kung magngel na ra nganing yang nangasawa ang pagbaw̱alitaen ang matinlu ra ka atiing pagkakasawaan nirang durua, pag̱ampayan ka ta kasadyaan nang duru ay durug tinlu yang pinakaw̱ut yang pagpaiwan-iwan na. Ya tia yay kaalimbawaan yamen ni Jesus. Purisu simanyan agsadyaanaw ra ta duru tung nag̱ibalita ming atia tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kaministiran ang tanyay mapadengeg̱an ang mas pa. Piru ta yeen, maskin maaranek da yang kadengeg̱anu. ");
INSERT INTO tbk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Yang duun liit tung abwat, landaw tung tanan. Yang taa liit tung kaliw̱utan, tau ka ilem ang tanekanen. Yang nag̱ianing na, natetenged ilem tung mga bag̱ay taa tung kaliw̱utan. Kapurisu yang duun liit tung langit landaw tung tanan. ");
INSERT INTO tbk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yang kumpurming naita na kag nagngel na duun ya ray nag̱ipagpaingmatuud na tung mga tau, piru indi ra nag̱apauyunan ta kadaklan. ");
INSERT INTO tbk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ug̱aring kung tinu pay magpauyun tung nag̱ipagpaingmatuud na, asan dag pagpailala ang yang Dios talagang matalig̱an nang magkereng tung kumpurming pinangakuan na. ");
INSERT INTO tbk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kipurki yang tinuw̱ul yang Dios, yay pagpakaw̱ut yang bitala na. Ay tanya nag̱apatiniran yang Dios tung Espiritu Santo ang anday sukatan yang pagparaketelen na tung anya tung tanan ang mga pag̱urubraen na. ");
INSERT INTO tbk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ay ya pa ag̱ari, tanyang pag̱aningen ang Ana nag̱agegmaan ta duru yang pag̱aningen nang Ama na. Purisu yang tanan ang bag̱ay ipinabtang na tung pudir na. ");
INSERT INTO tbk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kapurisu kung tinu pay pagtalig tung anyang pag̱aningen ang Ana, may baklu rang pagkatau na ang ya ray pagnatisan nang asta tung sampa. Piru kung tinu pay indi magpalalang tung anya, indi na ra mabag̱as yang baklung pagkatau na rin, ang indi, yay pag̱ineteg̱an yang kasisilag̱en yang Dios.” ");
INSERT INTO tbk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Taa, simanyan, may balitang nagngel yang mga Pariseo ang ti Jesus unu mas dakele tung ni Juan ta mga taung nag̱apangkelan nang magpaugyat tung anya ang ya ra ka unu ay nag̱apamenyag̱an na dayun. ");
INSERT INTO tbk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piru tung kamatuuran, belag̱an ti Jesus yang nagpamenyag tung mga taung atii, ang indi, yami ra ilem ang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kapurisu, simanyan, pagkaske ni Jesus ang yang mga Pariseo nangabalitaan da ta maning tia, dayun dang nagliit tung Judea ang nagbalik da duun tung Galilea. ");
INSERT INTO tbk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ug̱aring baklu makaw̱ut duun, kaministiran manggetes da kanay ilem duun tung Samaria. ");
INSERT INTO tbk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Simanyan, atiing duunami ra tung sinakepan yang Samaria, may kinaw̱utan yamen ang sasang lansangan ang paggug̱uuyan ang Sicar. Alenget ilem duun yang tanek ang ipinakdul ni Jacob ang kinaampu yamen tung ana nang ti Jose atiing tukaw pang mga panimpu. ");
INSERT INTO tbk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Duun ka yang buw̱un ang pinaakaran ni Jacob. Purisu, simanyan, ti Jesus, kumus pinilayan da ta pagpanaw, diritsyu ra ilem ang kuminarung tung biw̱il yang buw̱un ang atia. Yang uras ang atii kereng da yang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Buay-w̱uay ta gesye, may sasang baw̱ay ang minangay duun tung buw̱un ang para manaw̱u ta wai. Yang nasyun na Samarianen. Kumaw̱ut duun, dayun dang binugnu ni Jesus ang inaning, “Paigmay ka ta wai.” ");
INSERT INTO tbk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ya ray pinandawatan na, ay yaming nag̱apangugyatan na nagpadayunami ra duun tung lansangan ang para mangalangami ta pamangan. ");
INSERT INTO tbk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mag̱aning yang baw̱ay ang minles, “Abaa, yuu baw̱ay, Samarianenaw pa, pandawatanaw pa nuyu ta wai ang yawa sasang Judio?” (Napagbitala ta maning tia, ay yang mga Judio pamamiru kang lag̱i tung mga Samarianen. Indi nganing pamaggamit ta mga garamiten nira.) ");
INSERT INTO tbk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mag̱aning ti Jesus ang minles, “Kung nag̱askean mu ilem kung unu pay pag̱ipakdul yang Dios ta diw̱aldi ig kung nag̱ailala mu ilem kung tinu pay pandawat ta wai tung nuyu, yawa ra rin yang mandawat tung anya, pinakdulana pa rin anya ta waing bui.” ");
INSERT INTO tbk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mag̱aning yang baw̱ay ang minles, “Ameey, anday ipanimba mu. Kaadalem yang buw̱un. Ay pa ngaeklay mu atiang waing buing atiang nag̱aaning mu? ");
INSERT INTO tbk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ayw̱a w̱asu, maglandawa pa ka enged tung ni Jacob ang kinaampu ta ang ya kay nagpasubli yang buw̱un ang naa tung yamen? Tanya mismu nanginem taa, may yang mga ana na, asta yang mga kaayepan na!” ");
INSERT INTO tbk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Magtuw̱al ti Jesus, “Kung tinu pay manginem yang waing naa, kanalen ka enged ang uman. ");
INSERT INTO tbk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piru kung tinu pay manginem yang waing ipakdulu tung anya, indi ra ka enged kanalen ang asta tung sampa, kung indi, yang waing ipakdulu tung anya, ya ray magyaring waing tubdun tung sadili na ang magbulyak-bulyak bilang ya ray ipagpangabui nang baklu ang anday pagtapusan na.” ");
INSERT INTO tbk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mag̱aning yang baw̱ay tung anya, “Ala, Ameey, pakdulay ka yang waing atia ug̱ud indiaw ra kanalen ang uman. Anda ra kay ministirung magpabalik-balik pa taang manaw̱u.” ");
INSERT INTO tbk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mag̱aning ka ti Jesus ang nagtimales, “Ala, mulika ra. Guuyan mu ra kanay yang kasawa mu ang pagkatapus magbalikamu ra ka taa.” ");
INSERT INTO tbk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mag̱aning yang baw̱ay ang minles, “Yuu anday kasawaw.” Magbales ti Jesus, “Tama ka man yang bitala mu ang anday kasawa mu. ");
INSERT INTO tbk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sipurki nagpakasawa-kasawaa ra ilem tung lima nga laliian kag yang aruman mu numanyan, apen-apen mu ilem. Talagang matuud ka man yang bitala mung atia.” ");
INSERT INTO tbk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mag̱aning yang baw̱ay, “Naa pala, Ameey, yawa sasang prupita! ");
INSERT INTO tbk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yang mga kinaampu yamen ang mga Samarianen, tung bukid ang atii namagtuu tung Dios. Piru yamung mga Judio, pag̱aningamu ang yang lugar ang dapat pagtuuan tung Dios ay ultimu ilem duun tung Jerusalem.” ");
INSERT INTO tbk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mag̱aning ti Jesus ang minles, “Ipag, manangera tung yeen, may uras ang kaw̱utun ang andang pisan ay kalalabten na kung ay pang banwaay mamagtuu yang mga tau tung ni Ama, kung tung bukid ang atii, u kung duun man tung Jerusalem. ");
INSERT INTO tbk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kidispuis pa, yamung mga Samarianen pagtuuamu ka man tung Dios, piru indi mi ilem nag̱abilug̱an kung tinu pay pag̱atuuan mi. Piru yaming mga Judio, kunisidu yamen yang pag̱atuuan yamen. Tutal kung magtukud da nganing yang Dios yang kalibrian, ay tung nasyun yamen ang mga Judiong mag̱eyang. ");
INSERT INTO tbk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ug̱aring, magkakaw̱ut da yang uras, kuminaw̱ut da ka enged ang ipagtuu ra ta ustu yang mga tau tung ni Ama. Ay yang pagturuuen nira tung anya, ya ag̱ipaeyangay yang Espiritu Santong ig uyun tung kamatuuran. Asan da ta mga taung nag̱asagyap nang magtuu tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kumus ispiritu tanya, ig disir, kung tinu pay magtuu tung anya, kaministiran yag paktelay yang Espiritu Santo ang para magkatunu tung kamatuuran yang pagturuuen na.” ");
INSERT INTO tbk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mag̱aning yang baw̱ay, “Nag̱askeanu ka ang yang pag̱aningen ang Mesias bilang yang pag̱aningen ang Cristo, kung kumaw̱ut da nganing, ya ray magpasanag tung yaten yang tanan ang bag̱ay.” ");
INSERT INTO tbk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mag̱aning ti Jesus ang minles, “Yuu ra taang kakesen mu atiang nag̱aaning mu,” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Simanyan, indi pa nganing nag̱atapus yang pagkesen nirang durua, yaming nag̱apangugyatan na kuminaw̱utami rang nanliit duun tung lansangan. Naberengami ra ta mupia tung ni Jesus ang ayw̱at pangesen-kesen tung sasang baw̱ay. Piru maski pang durung pagkabereng yamen, anday nabnga tung yamen ang nagtalimaan kung panduu ra asan yang baw̱ay, u kung unu pay nag̱ipangesen-kesen ni Jesus tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Simanyan, anday dumang binuat yang baw̱ay, diritsyung binutwanan na yang tiw̱ud nang nagbalik da duun tung lansangan. Kumaw̱ut, dayun dang nagbaw̱alitaen tung mga tau ang mag̱aning, “Aliamu w̱a. Telengan mi ra kanay yang sasang taung yay nag̱ulit tung yeen yang tanan ang nagkarabuat-buatu. Ya ra w̱asu takaa yang pag̱aningen ang Cristo?” ag̱aaning. ");
INSERT INTO tbk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kapurisu, simanyan yang mga taung atiang nagkarabalitaan da, dayun dang namansilua tung lansangan ang namansiangay tung ni Jesus duun tung buw̱un. ");
INSERT INTO tbk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Numanyan, duun tung buw̱un, yaming nag̱apangugyatan ni Jesus, durung eret-eret yamen tung anyang mamangan da. Mag̱aningami tung anya, “Ala, Rabbi, mamangana ra kanay.” ");
INSERT INTO tbk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mag̱aning ti Jesus ang minles, “Yuu may pamangan ang indi mi ilem nag̱askean.” ");
INSERT INTO tbk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Atii, nagtaralimaan-talimaananami rang mag̱aning, “Unu pa w̱asu, may nag̱ekel ta pamangan taa tung anya?” ");
INSERT INTO tbk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mag̱aning ti Jesus ang nagsublang, “Yang pamangan ang masabur tung yeen ya ra yang pagturumanenu yang kalelyag̱an yang nagtuw̱ul tung yeen ang yuu magtalusaw tung itinuw̱ul na tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Indi w̱a, pag̱aningamu ang epat pang bulan baklu kaw̱utay yang tilig̱ayeg? Piru bandawen mi w̱a kanay atiing pamanikulit ang atii. Midyu ra ka tung trigung lutuk da ang arayeg̱en da ilem. ");
INSERT INTO tbk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Simpri yang sasang manig̱ayeg may suul na. Anday duma, ya ra yang taung mismung maning pa tung ayeg̱en na ang ya ra ka man yang mga taung pinaeyangan da yang Dios ta baklung ipagpangabui nirang anday pagtapusan na. Kapurisu yang manigtakbul may yang manig̱ayeg kasiraan da ka tanirang mamagpakasadya. ");
INSERT INTO tbk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Ay asan da magkamatuud yang sasang bitala yang mga mamaepet ang kaisan unu duma ray panakbul, duma ra kay pangayeg. ");
INSERT INTO tbk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Purisu tuw̱ulunamu yeen ang mangayeg tung indi mi pinakabedlayan. Duma ray namagpakabedlay ang pagkatapus yamu ray mangayeg tung pinakabedlayan nira,” mag̱aning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Taa numanyan, durung mga Samarianen ang tag̱a lansangan ang atii ang namagtalig da yang mga sadili nira tung ni Jesus natetenged tung ibinalita yang baw̱ay ang atia tung nira ang isinayud na unu tung anya yang tanan ang nagkarabuat-buat na. ");
INSERT INTO tbk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kapurisu, simanyan, mamansikaw̱ut da tanira duun tung ni Jesus, dayun dang inimbitar nirang magpadayun da kanay tung nira. Kapurisu nagpadayun da ka man duun ta seled duruang kaldaw. ");
INSERT INTO tbk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Taa, simanyan, yang pinakaw̱ut na, mas duru pa ka enged yang namagtalig tung anyang namagpatapnay natetenged tung mga bitalang ipinagpakaw̱ut na tung nira. ");
INSERT INTO tbk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pamansianing tung baw̱ay, “Numaan, belag̱an da ilem yang ibinalita mu tung yamen yang ipinagtalig yamen tung anyang nagpatapnay, ang indi, yami mismu ay nagpamati tung anya. Purisu, nabilug̱an da enged yamen ang talagang ya ra ka man taa yang nag̱aelatan yamen magpanapnay tung mga tau.” ");
INSERT INTO tbk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Taa numanyan, pagtaklib yang duruang kaldaw ang atii, nagliit da ti Jesus ang nagpadayun da yang pagparanawen nang minangay duun tung sinakepan yang Galilea, kasiraanami ra kang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yang ipinag̱angay na duun ay may sasang bitala ta mga mamaepet ang nag̱atemeng da tung anya ang yang sasa unung manigpalatay yang bitala yang Dios, kung duun tung sadiling banwa na, indi unug galangen ang sapten ta ustu. ");
INSERT INTO tbk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kapurisu atiing pagkaw̱ut na duun tung Galilea, kung tung bag̱ay, sinapet ka man yang mga Galileanen, piru yang ipinagsapet nira tung anya ay natetenged ilem tung tanan ang nagkarabuat nang makabew̱ereng ang ya ray naita nira duun tung Jerusalem atiing pagsilibra nira yang pistang atiang pag̱aningen ang Taklib. Ay kipurki pati tanira namagpasakep ka tung pistang atia. ");
INSERT INTO tbk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kapurisu numanyan, ti Jesus duun si nagbalik tung Cana duun tung sinakepan yang Galilea ang ya ray banwang pinagbuatan na yang wai ang binu. Duun tung sinakepan yang Galilea, may sasang upisial yang gubirnu ang pagtinir tung lansangan ang Capernaum ang yang ana na paglaru. ");
INSERT INTO tbk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Purisu pagkabalita na ang ti Jesus nagliit da duun tung Judea ang minangay tung Galilea, dayun na rang inangay duun tung Cana ang dinangepan kung puiding magnunut da tung anya duun tung Capernaum, ang para magpamaayen tung ana nang tag̱umatayen da. ");
INSERT INTO tbk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Numanyan pagkaintindi ni Jesus yang ministir na, mag̱aning tung anyang nagsukda, “Yamung tag̱a Galilea, kung indiamu maita ta mga pruibang makabew̱ereng, indiamu ra ka enged magtalig tung yeen!” ");
INSERT INTO tbk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mag̱aning yang upisial ang nagpakigluuy, “Ameey, ildaway kang nuntun, tag̱umatayen da ti duduy!” ");
INSERT INTO tbk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mag̱aning ti Jesus ang minles, “Ala, mulika ra. Maayen da yang ana mu,” ag̱aaning. Simanyan yang inaning ni Jesus ang atia, ya ray pinagtalig̱an nang minulik. ");
INSERT INTO tbk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Numanyan, atii pa tung panenga-tengaan yang dalan ang nag̱apanuldakan na, binag̱as da yang mga turuw̱ulun nang binalitaan ang maayen da unu yang ana na. ");
INSERT INTO tbk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pagkagngel na yang balita, diritsyung tinalimaan na kung unu pang urasay naulikan yang ana na. Mag̱aning tanira, “Ta nungapun pang mga ala una ngaumpaway yang kinit na,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Atii, nademdeman na ra ang yang pisan yang uras ang ipinag̱aning ni Jesus tung anya ang maayen da yang ana na. Kapurisu, asan da nagbilug yang pagtaralig̱en na tung ni Jesus. Asta yang intirung pamilya na pati mga turuw̱ulun na namagtalig da kang tanan yang mga sadili nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Atia, ya ray yadwang pruibang ipinagpalapus ni Jesus duun tung sinakepan yang Galilea atiing pagliit na duun tung Judea ang minangay duun tung Galilea. ");
INSERT INTO tbk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Taa numanyan, tung pira pang kaldaw, kinaw̱ut da yang uras ang ipagsilibra si yamen ang mga Judio ta pista. Purisu ti Jesus nanungul si duun tung Jerusalem ang para magpasakep. ");
INSERT INTO tbk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Duun tung Jerusalem ang alenget tung purtang parakleran ta mga karnirung nag̱ipandasag, may pagdirigwan ang tung bitala yamen ang Hinebreo paggug̱uuyan ang Betesda. Tung binit na may lima ngaintabladuan ang paralirungan ta mga tau. ");
INSERT INTO tbk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Durung mga taung may mga laru nirang lumakdayan asan. May mga buray, may mga barik, may mga taung kapeypeyen. ");
INSERT INTO tbk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Asan may sasang tau ang tulung puluk may walu rang takun yang pag̱alaru na. ");
INSERT INTO tbk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Simanyan naita ra ni Jesus ang yag lalakday asan. Naskean na ra ka ang tung tantung kabuay ra yang paglaru na. Purisu dayun na rang inaning, “Yawa, malelyag̱a rang magmaayen?” ");
INSERT INTO tbk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mag̱aning yang taung atiang minles, “Ameey, anday mag̱ekel tung yeen ang para manulpuk tung wai kung uras dang bumulyak. Mintras ag̱imurasenu ra rin ang paranekan, ag̱atkawanaw ka enged ta duma.” ");
INSERT INTO tbk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mag̱aning ti Jesus tung anya, “Ala, kemdenga ra, eklan mu ra tiang papag mung magpanaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Atii, lag̱i-lag̱ing nagmaayen da yang taung atia. Diritsyu ra ka man ang ingkelan na yang papag nang nagpanaw. Taa numanyan yang nainabung atia natuun tung kaldaw ang nag̱ipamaenay. ");
INSERT INTO tbk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kapurisu, yang mga pamagpakigmaepet tung nasyun yamen ang mga Judio, pagkaita nira yang taung atiang nagmaayen da, pinag̱istinggir da nirang inaning, “Eey, indi mu nag̱aintindian, numanyan kaldaw ang nag̱ipamaenay? Bawal ang mag̱ekel-ekela tiang papag mu!” ");
INSERT INTO tbk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mag̱aning yang taung minles, “Yang taung nagpamaayen tung yeen, yay nag̱aning tung yeen ang eklanu ra yang papag̱ung magpanaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dayun da nirang tinalimaan, “Tinu pang tauay nag̱aning tung nuyung eklan mu ra yang papag mung magpanaw?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piru yang taung atiang pinamaayen, anday kaliw̱utan na kung tinu pa. Ay ti Jesus nagpanaw rang lag̱ing nanakat-sakat tung kadamlan yang mga tau. ");
INSERT INTO tbk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Buay-w̱uay ra ta gesye, napanawan si ni Jesus yang taung atia duun tung pagtuuan ang pinakalusu. Dayun na rang inaning ang, “Ta, maayena ra simanyan. Purisu india ra ilem magpadayun tung pagpakasalak mu, ug̱ud india ra mataktakan ta mas maliwag,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Atii, diritsyu rang nagpanaw yang taung atiang minangay tung mga pamagpakigmaepet. Nag̱ugtulun da ang ti Jesus yang nagpamaayen tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Simanyan natetenged tung buat-buat ni Jesus ang mga maning tia tung kaldaw ang nag̱ipamaenay, ya ray ipinakusalak yang mga pamagpakigmaepet tung anyang nagaraan yang pagpakigkuntra nira tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kapurisu, simanyan, dayun dang nagbitala ti Jesus tung mga pamagpakigmaepet ang atia ang mag̱aning, “Ti Ama, ang asta ra ilem simanyan, anday kapaenay-enayan yang pag̱urubraen nang pagpakaayen tung mga tau. Purisu ta yuu, ya ka. Anda kay kapaenay-enayanu tung pag̱urubraenu.” ");
INSERT INTO tbk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pagkadngel nira tia, mas pang naglain yang isip nirang namagdisididung mamagpaimatay tung anya. Ay belag ilem ang yang riglamintu nira natetenged tung kaldaw ang nag̱ipamaenay ay pinaglikdan na, kung indi, ginuuyan na pa ka yang Dios ang ya enged ay anyang sadiling Ama. Bilang nagpakpeng da tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kapurisu, nagpadayun si ti Jesus yang bitala na tung nirang mag̱aning, “Iugtulu tung numyu yang kamatuuran, yuung pag̱aningen yang Dios ang Ana Na, anday mabuatu tung sadiling kalelyag̱anu ilem. Ang indi, kumpurmi yang nag̱aitaw ang pag̱abuat ni Ama, ya ka ilem ay pag̱abuatu. Bilang kumpurming unu pay pag̱abuat na, ya ka mismu ay pag̱abuatu. ");
INSERT INTO tbk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ay kipurki nag̱agegmaanaw anya. Purisu ya ray nag̱ipagpaita na tung yeen yang tanan ang pag̱abuat nang para ya kay buatenu. May mas pa nganing ang ipaita na tung yeen ang para buatenu ug̱ud yamu ray mabereng. ");
INSERT INTO tbk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ay katulad tung anyang may kagaeman nang magpabungkaras tung mga minatay ang para mangabui si kang uman, yuung pag̱aningen nang Ana Na, ya ka. May kagaemanu kang magpaeyang ta baklung pagkatau tung mga taung kuari mga patay tung pagterelengen yang Dios ang kumpurming tinu pay nag̱alelyag̱anu. ");
INSERT INTO tbk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Asta yang pagsirintinsiaen tung kalainan tung uri ta kaldaw, belag̱an ang mag̱aning ang ti Ama yay magsintinsia tung mga tau, kung indi, yuung pag̱aningen nang Ana Na, yuu ray piniaran nang magsintinsia tung nira. ");
INSERT INTO tbk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ay yang ipinagpiar na tung yeen tia, ay ug̱ud yang tanan ang mga tau mamagpadengeg tung yeen ang pag̱aningen nang Ana Na ang kumpurmi yang pagpadengeg nira tung anyang pag̱aningenung Amaw. Purisu, kung tinu pay indi magpadengeg tung yeen ang pag̱aningen nang Ana Na, indi na kag padengeg̱an ti Amang nagtuw̱ul tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Iugtulu tung numyu yang kamatuuran, kung tinu pay pananged tung bitalang naang nag̱ipagpakaw̱utu ang asan dag pagpailala yang pagtaralig̱en na tung ni Amang nagtuw̱ul tung yeen, may pagkatau na rang baklu ang ya ray pagnatisan nang asta tung sampa. Anda ray elatan nang sintinsiaan pa tung kalainan, kung indi, naliit da tung dating pagkatau nang alawid tung Dios ang nalakted da tung baklung pagkatau nang uyun tung Dios. ");
INSERT INTO tbk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iugtulu tung numyu yang kamatuuran, magkakaw̱ut da yang uras, kuminaw̱ut da ka enged ang yang mga taung alawid tung Dios ang maning pa tung patay tung pagterelengen na, magngel da nira yang busisung pag̱imbitar tung nira ang yuu ka man yang pag̱aningen ang Ana yang Dios. Kumpurming tinu pay magpabteng tung yeen, asan da magkatinir ta pagkatau nang baklu. ");
INSERT INTO tbk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ay kipurki katulad ka tung ni Ama ang yay may pudir ang magpaeyang ta baklung ipagpangabui yang mga tau, yuung pag̱aningen nang Ana Na, ya ka, ay natetenged pinakdulanaw ra anya ta pudirung magpaeyang ka ta maning ka tia. ");
INSERT INTO tbk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Belag ilem maning tia, ang indi, pinakdulanaw ra ka anya ta pudirung magsintinsia tung kalainan tung mga tau natetenged yuu ka man yang pag̱aningen ang Maninga Tau. ");
INSERT INTO tbk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Indiamu mabereng tung inaningu ang atiang yuu yang manigsintinsia. Ay kipurki may uras ang kaw̱utun ang yang tanan ang mga taung nagkarapatay ra magngel da nira yang busisu ang magkalalangan tung nira. ");
INSERT INTO tbk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Magngel da ngani nira yang busisu, mamansilapus da tung pinanlebngan tung nira. Kung tinu pay nagpadayun tung mga ubra-ubrang nag̱auyunan yang Dios, ya kay pabungkarasenu ang para magpasapen da tung anya ang asta tung sampa. Yang kumpurming nagpadayun man tung mga buat-buat nang anday kuinta, ya kay pabungkarasenu ang para sintinsiaanu ra tung kalainan. ");
INSERT INTO tbk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Belag̱an ang mag̱aning ang beet-beetanu ra ilem yang pagsirintinsiaenung atia. Ang indi, kumpurmi ra ilem yang ipagngel ni Ama tung yeen, ya ray usuyunung magsintinsia. Purisu tamang pisan yang sintinsiang ipakdulu. Kipurki belag̱an yang sadiling kalelyag̱anu ang yay pag̱asikaru, ang indi, ultimu ilem yang kalelyag̱an yang nagtuw̱ul tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kung alimbawa, yuu ilem ang sam bilug ay pagkereng tung sadiliu, intunsis puiding maskin indiaw ra panangden mi. ");
INSERT INTO tbk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piru may sam bilug pang pagpaingmatuud natetenged tung yeen. Kidispuis ag̱askeanu ang yang nag̱ipagpaingmatuud na natetenged tung yeen talagang tama. ");
INSERT INTO tbk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yamu nganing ay nagtuw̱ul tung mga kaarumanan ming mamanginsapu tung ni Juan ang pagkatapus yay nagdiklara yang kamatuuran natetenged tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Belag̱an ang mag̱aning ang yuu pagkaministiran ta tau ang para magkereng ilem tung yeen. Ang indi, nag̱asambitu ilem tiang pagpaingmatuud ni Juan tung yeen ug̱ud basi pa ra ilem magpauyunamu ra kang magpatapnay tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kipurki ti Juan ang naa, maning pa tung sasang kaas ang nagdekal ang nagpasanag ta mupia. Piru ta numyu, midyu gesye ka ilem yang uras ang ikinasadya mi yang ipinagpasanag na tung numyu. ");
INSERT INTO tbk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Piru, yuu, may sasang pagpaingmatuud natetenged tung yeen ang mas landaw pa kay tung pagpaingmatuud ni Juan. Ay kipurki yang mga buat-buat ang naang nag̱ipaitaw ang ya ra kang lag̱i ay itinalig ni Ama tung yeen ang talusunu, ya ra kay pagpailala tung yeen ang pag̱atuw̱ulaw ka man anya. ");
INSERT INTO tbk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pati nganing ti Amang nagtuw̱ul tung yeen, ya kay pagpaingmatuud natetenged tung yeen. Kung tung bag̱ay, yang busis na indi mi nag̱agngel, pati pirsunal na, indi mi ka nag̱aita. ");
INSERT INTO tbk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Asta yang bitala nang nag̱ipagpagngelu tung numyu, indi mi ra ka nag̱ipabalay tung isip mi. Talagang matuud tia, ay telengan mi ra ilem. Yuung tinuw̱ul na mismu, indiaw ra ka ilem agpanangden mi. ");
INSERT INTO tbk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tung bag̱ay pagpasadsaramu ta mupia tung kasulatan, ay yang kalaum mi tung pagsurulipeten mi yang mga katuw̱ulan na, asanamu ngaeyangay ta pagkatau ming baklu ang ya ra ka rin ay pagnatisan ming asta tung sampa. Piru yang kasulatan ang atiang nag̱apaderepan mi, yuu ra ka man taang nag̱adapatan na! ");
INSERT INTO tbk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ang pagkatapus indiamu ra ka enged nag̱alelyag ang magpagaem tung yeen ang para magkatiniramu ra rin yang pagkatau ming atiang baklu ang uyun tung Dios. ");
INSERT INTO tbk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Indiaw pagsikad ang yuu dayawen ta mga tau. ");
INSERT INTO tbk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Piru suutung pisan yang pundu yang mga kinaisipan mi ang yamu ang anda enged ay paggegma ming ustu tung Dios. ");
INSERT INTO tbk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yuu nagluaaw ra taa tung publiku, natetenged tung katengdanan ang ipinakdul ni Ama tung yeen ang pagkatapus nag̱apangindianaw ra ka ilem numyu. Kung may duma pang maglua taa tung numyu tung sadiling beet-beet na ilem, atia ya ray dilantadung pauyunan mi. ");
INSERT INTO tbk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ya pa ag̱aring mapagtalig̱amu tung yeen ang maning da tiang pag̱amaal mi ang yamu magparabantug-bantug̱an? Piru ang yamu bantug̱un yang ultimung Dios ang yay indi mapakdingan, belag̱an ang yay magsikaren mi. ");
INSERT INTO tbk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Indiamu maglaum ang yuu pay magbangdan tung numyu tung katalungaan ni Ama ang ayw̱at indiamu ra nananged tung yeen. Kipurki may sasang magbangdan tung numyu. Anday duma, ya ra ti Moises. Ya ka man mismu yang panalig̱an ming mangerengan tung numyu natetenged tung pagturumanen mi yang mga katuw̱ulan ang ipinagsulat na. ");
INSERT INTO tbk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sipurki kung panangeramu ta ustu tung isinulat na, intunsis simanyan, nanangeramu ra ka rin tung yeen. Ay yuu ra ka man taang nag̱adapatan yang isinulat na. ");
INSERT INTO tbk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piru simanyan kumus indiamu pananged tung isinulat na, ya pa ag̱aring panangden mi yang yeen ang nag̱ipagpakaw̱ut tung numyu?” mag̱aning ti Jesus. ");
INSERT INTO tbk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Numanyan, pira pang kaldaw, ti Jesus nagpalakted da tung tindak yang aw̱uyuk ang paggug̱uuyan ang Galilea. (Tung panimpu ta numanyan, yang aw̱uyuk ang atia, paggug̱uuyan ang Tiberias). ");
INSERT INTO tbk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pagkaw̱ut na, buntun yang mga taung namagpakignunut da tung anya, natetenged naita ra nira yang mga pruibang ipinagpalapus nang nagpamaayen tung mga taung pamaglaru. ");
INSERT INTO tbk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Simanyan, nanungul da ti Jesus tung bukid ang kuminarung, kasiraanami ra kang nag̱apangugyatan na. ");
INSERT INTO tbk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yang uras ang atii, alenget da ka ilem ang kumaw̱ut yang pista yamen ang mga Judiong pag̱aningen ang Taklib. ");
INSERT INTO tbk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Taa simanyan, pamandaw ni Jesus, ya ray naita na yang mga taung atiing buntun ang pamagtungul tung anya. Purisu, dayun na rang tinalimaan ti Felipe ang mag̱aning, “Ta, Felipe, ariita ra kaya w̱asu maalang ta tinapay ang mapapaan ta tung mga taung atii?” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Naa pala, napag̱aning da ta maning tii, ay ti Felipe nag̱asukdaan na. Piru tanya nag̱askean na ra kang lag̱i kung unu pay buaten na. ");
INSERT INTO tbk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Simanyan, mag̱aning ti Felipeng minles, “Maskin balur ta mga duruang gatus yang tinapay ang alangen, maskin mekel ilem ta geg̱esye ang ipagsengat-sengat nira sasa may sasa, indi ka enged magkaramped, yang kinadaramelen nirang atia!” ");
INSERT INTO tbk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Simanyan, tung yamen ang nag̱apangugyatan ni Jesus, may sam bilug ang suminaleet ang ti Andres ang ari ni Simon Pedro. ");
INSERT INTO tbk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Mag̱aning tanya, “Nakaa w̱a, may kaw̱ataan ang may balun nang limang bilug ang tinapay ang geg̱esye ig may ian na kang duruang bilug. Piru pira ra ka enged takaa tung kinadaramelen nirang atia?” ");
INSERT INTO tbk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Numanyan, mag̱aning ti Jesus tung yamen, “Pampakarungun mi ra kanay yang mga tau,” mag̱aning. Duun tung bukid ang atii, durung ilamunun. Purisu ya ray pinangarung-karungan nirang tanan. Ang bilangen yang mga lalii ilem, nagdangat tung limang liw̱u nga tauan. ");
INSERT INTO tbk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Taa numanyan, dinawat da ni Jesus yang mga tinapay ang atia, ang ya ra kay pinasalamatan na tung Dios. Pagkatapus ta pagpasalamat na, dayun na rang ipinampatagtag tung nirang kumarungan asan. Asta yang mga ian maning ka tia yang binuat na. Tanirang tanan nangapagustu ra kang namamangan. ");
INSERT INTO tbk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Atiing mga bial da tanira, mag̱aning ti Jesus tung yamen ang nag̱apangugyatan na, “Ala, pangimesen mi ra kanay yang namagsubra. Muya magasta,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Purisu dayun dang pinangimes yamen ang may sam puluk may durua nga baayan ang napnuk. Ya ray nagkaraeped tung limang bilug ang tinapay ang atiang pinamanganan nira. ");
INSERT INTO tbk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Simanyan, pagkaita yang mga tau yang pruibang atiang ipinalapus ni Jesus ang makabew̱ereng, namag̱araning-aningan da tanira ang mag̱aning, “Talagang ya ra ka man taa yang manigpalatay yang bitala yang Dios ang nag̱aelatan tang maglua tung kaliw̱utan,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Simanyan, pagkasiman ni Jesus ang tanya ray nag̱aisipan nirang regsen ang papag̱adien tung banwa nira, dayun dang nagliling si duun tung kabukiran, ang tanya ilem ang sam bilug. ");
INSERT INTO tbk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Taa simanyan, atiing panlikarem da, yaming nag̱apangugyatan ni Jesus, nandanekami ra tung bakayan. ");
INSERT INTO tbk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Diritsyuaming nagsaay tung balangay ang para magpalakterami ra rin duun tung Capernaum. Taa simanyan, nalaw̱iianami ra ta pag̱elat ang ti Jesus indi pa ka enged nag̱alput tung bakayan. Purisu, diritsyuami rang nagpatabuk. ");
INSERT INTO tbk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Taa, simanyan, nagketel da yang palet, darakulu ra yang lakun. ");
INSERT INTO tbk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sigi-sigi yang paggarayungun yamen. Atiing alawirami ra tung bakayan ang liniitan yamen, distansia ta mga lima asta enem ang kilometro, naita ra yamen ti Jesus ang pagpanaw tung ulit yang aw̱uyuk ang pagpalenget tung yamen tung balangay. Purisu binalayanami ra ta eled yamen ang duru. ");
INSERT INTO tbk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mag̱aning ti Jesus ang nagtalna tung yamen, “Eey, indiamu ra magpakataranta! Yuu ka taang aruman mi.” ");
INSERT INTO tbk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pagkagngel da yamen yang busis na, duun da kumintel yang mga isip yamen ang nagpasaay tung anya tung balangay. Tung pagsaay na, atiang lag̱i, nanampet da yang balangay duun tung nag̱adistinuan yamen. ");
INSERT INTO tbk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pangayag yang kaliw̱utan, yang mga taung atiing buntun ang nangabutwan, duun pa ka. Nademdeman nira ang ta nungapun, sam bilug ka ilem yang balangay duun tung bakayan. Yadwa pa, naskean da ka nira ang ti Jesus indi nanunut tung yamen ang nag̱apangugyatan na, ang indi, ta yami ilem ay nagsaay tung balangay ang atia. ");
INSERT INTO tbk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Naa pala asan tung tukaw-tukaw ang belag̱an alawid tung pinamanganan nira yang tinapay ang atiing pinasalamatan ni Ginuung Jesus, may pira pang bilug ang balangay ang namansiparuung dang duun liit tung lansangan ang Tiberias. ");
INSERT INTO tbk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Purisu, pag̱asiguru ra nira ang ti Jesus anda ra duun, pati yaming nag̱apangugyatan na anda ka, diritsyu rang namanaayan yang duma tung mga balangay ang atia ang namampatindak duun tung lansangan ang Capernaum ang para mamagsagyap da duun tung ni Jesus. ");
INSERT INTO tbk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Simanyan, atiing namampalakted da duun tung tindak, naita ra nira. Dayun da nirang tinalimaan ang mag̱aning, “Rabbi, sanua pa pa taa?” ");
INSERT INTO tbk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mag̱aning ti Jesus ang minles, “Iugtulu tung numyu, yang nag̱ipagsagyap mi tung yeen belag̱an natetenged ang panangeramu ra tung yeen natetenged tung mga pruibang atiang ipinagpaitaw tung numyu, ang indi, natetenged ilem tung tinapay ang atiing ipinapaanu tung numyu ang yay pinagustuan ming nabialan. ");
INSERT INTO tbk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Indi mi ra impurtaen yang pamangan ang maning tiang nag̱arangga, ang indi, yang sikaren mi, ya ra yang pamangan ang anday karanggaan na, ang asanamu ra nga paeyangay ta baklung pagpangabui ming ya kay pagnatisan ming asta tung sampa. Yang pamangan ang atia, yuung pag̱aningen ang Maninga Tau, yuu ray magpakdul tung numyu, sipurki yuuy pinakdulan ta katengdanan yang Dios ang ya kay pag̱aningenung Amaw.” ");
INSERT INTO tbk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Simanyan, mag̱aning tanirang namagtalimaan, “Unu pay dapat ang ubraen yamen ang para asanami ra ngauyunay yang Dios?” ");
INSERT INTO tbk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mag̱aning ti Jesus ang nagtuw̱al, “Ya taa yang dapat buaten ming para mauyunanamu ra anya. Magtalig̱amu ra ilem yang mga sadili mi tung yeen ang tinuw̱ul na.” ");
INSERT INTO tbk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mag̱aning ka tanirang namagtimales, “Ay kung maning tia, abir, unu pang pruibaay ang mapalua mu ang para yay maita yamen bakluami magtalig yang mga sadili yamen tung nuyu? Telengan ta, kung unu pay mapalapus mu! ");
INSERT INTO tbk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Basu mapalandawan mu pa yang pruibang atiing ipinagpaita tung mga kinaampu tang tukaw atiing duun pa rin tanira tung banwang kapas? Ay kipurki tanira nangapamangan nganing ta sasang palanganen ang ginuuyan nirang mana ang katulad ka tung napabtang tung kasulatan ang may pamangan unung liit tung langit ang ya ray ipinapaan na tung nira.” ");
INSERT INTO tbk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mag̱aning si ti Jesus ang minles, “Iugtulu tung numyu yang kamatuuran, belag̱an ang mag̱aning ang ti Moises yang nagpapaan tung mga kinaampu ta yang pamangan ang atiing liit tung langit, ang indi, ti Ama yay nagpamakdul. Kidispuis pa, yang pamangan ang atii, belag̱an ang ultimung liit tung langit. Piru simanyan ang mga uras ang naa, ti Ama ya ra kay pagpakdul tung numyu yang maning pa tung pamangan ang ultimung liit tung langit. ");
INSERT INTO tbk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ay kipurki yang maning pa tung pamangan ang naang nag̱ipakdul yang Dios tung numyu ya ra yang sasang nanliit tung langit ang nagparanek taa ang para magpaeyang tung mga tau ta baklung pagpangabui nirang uyun tung Dios.” ");
INSERT INTO tbk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mag̱aning tanirang namagtimales, “Pakdulayami kang pirmi yang pamangan ang atiang nag̱ianing mu.” ");
INSERT INTO tbk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mag̱aning si ti Jesus ang nagtimales, “Yuu ra taa yang maning pa tung pamangan ang atiang magpaeyang ta baklung pagpangabui. Kung tinu pay magtalig yang sadili na tung yeen ang magpagaem, kung ipananglit pa tung pag̱asuw̱uk may pag̱akanal, indi ra enged masuw̱uk ang uman ig indi ra ka kanalen ang uman. Ay ya pa ag̱ari, nabilug̱an na ra yang pinagyenget-yengetan yang isip na kung ya pa ag̱aring magkabag̱ay ra tanya tung pagterelengen yang Dios. ");
INSERT INTO tbk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ug̱aring ilem katulad tung inaningu tung numyu nungayna, ang ag̱ad naitaw ra ka man numyung pagpalapus ta mga pruiba, piru indiamu ka enged magtalig yang mga sadili mi tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Piru yang tanan ang nag̱ipagtalig ni Ama tung yeen, luw̱us ang magkaradangep tung yeen ang para mampatapnay tung yeen, ig kumpurming tinu pay magdangep tung yeen, indi ra ka enged pangindianu. ");
INSERT INTO tbk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sipurki nanliitaw tung langit ang nagparanek taa belag̱an ang mag̱aning ang para magtumanaw yang sadiling kalelyag̱anu, ang indi, para magtalusaw tung kalelyag̱an yang nagpangay tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ya taa yang kalelyag̱an yang nagpangay tung yeen, ang tung nirang tanan ang nag̱ipagtalig na tung yeen, andang pisan ay maplek tung yeen, may sam bilug. Kung indi, tanirang tanan luw̱us dang pampabungkarasenu tung uri ta kaldaw. ");
INSERT INTO tbk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sipurki ya taa yang kalelyag̱an ni Ama. Kung tinu pay mag̱intindi tung yeen ang pag̱aningen ang Ana Na ang asta magtalig da ka dayun yang sadili na tung yeen ang magpagaem, atiang lag̱i, paeyanganu ra ta baklung pagpangabui nang anday pagtapusan na. Ay ya pa ag̱ari, yang taung atia, yuu ray magpabungkaras tung anya tung uri ta kaldaw,” mag̱aning. ");
INSERT INTO tbk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Atii, yang mga pamagpakigmaepet pinaninekan dang pamamati. Namagtarag̱aman da ta burutung-butung natetenged tung bitala na ang tanya unu maning pa tung pamangan ang duun manliit tung langit. ");
INSERT INTO tbk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Namag̱araning-aningan dang mag̱aning, “Ta, indi, yang taung naa, ti Jesus ang atiang ana ni Joseng atiang nag̱ailala ta, asta ti nanay na nag̱ailala ta ka? Buat na pa tanya nanliit duun tung langit?” ");
INSERT INTO tbk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mag̱aning ti Jesus ang nagngel, “Ustu ra tiang pagburutung-butungun mi. ");
INSERT INTO tbk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Anday masarang ang magdangep tung yeen kung indi yang kinaisipan na bekngen da ni Ama ang yay nagpangay tung yeen. Ang pagkatapus, yuu ray magpabungkaras tung taung atia tung uri ta kaldaw. ");
INSERT INTO tbk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Katulad tung isinulat yang sasang manig̱ula atiing tukaw ang may kaldaw unung kaw̱utun ang tanirang tanan pasanag̱an da ta mupia yang Dios mismu. Bilang kung tinu pay magpauyun tung nag̱ipagpasanag ni Ama tung anya natetenged tung yeen, asan da ngabteng yang isip nang para magdangep tung yeen. ");
INSERT INTO tbk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yang gustuung ianing tia, belag̱an ang mag̱aning ang may naita tung ni Ama ay natetenged ultimu ilem yuung nanliit tung anya, ultimu ilem yuu ay naita tung anya. ");
INSERT INTO tbk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iugtulu tung numyu yang kamatuuran, kung tinu pay magtalig yang sadili na tung yeen ang magpagaem, atiang lag̱i paeyanganu 