﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbg_vpl;
CREATE TABLE tbg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbg_vpl WRITE;
INSERT INTO tbg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tota hoqarero Kotiva naaruvavata vatavata autu kero vatora. ");
INSERT INTO tbg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Vatavano qumina vauvaro kia vo haikavanovata vauvaro konkira aru haikava nora namariqaa mantaaqa kovaro Kotira Maraquravano namari viraqaa vi ani vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kotiva mintima tiro: Aatitaane, tuvaro aatita vura. ");
INSERT INTO tbg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kotiva aatitora tavovaro koqe iro vauvaro aatitora vira voqaa vatero konkiraiqura voqaa vatora. ");
INSERT INTO tbg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kotiva aatitora autu nteharo, Ikarave, tivakero konkiraiqura autu nteharo, Entaqive, tura. Entamaqiro viviro aatita vuvaro vi entava hoqarenaa enta taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Vi entara tonavuvanovata mamanavuvanovata nora namariqaa hihipaa iro vauvaro Kotiva tiharo, Ruqema vira virini oriniraro nora namarivano miani vairaro avutana qaqi variarire, tiro. Minti tuvaro Kotiva tunte iro, tonavuvanovata mamanavuvanovata nora namariqaahairo ruqema viro virini orini vauvaro, nora namarivano miani vauvaro avutana qaqi vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kotiva qaqi vaura vira autu nteharo, Naaruvave, tura. Entamaqiro viviro aatita vuvaro vi entava taara enta taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Vira qararaa Kotiva tiharo, Nora namari miani vairava vohaanaini otiniraro aahara vatavano qovaraiqama viro variarire, tiro. Minti tuvaro Kotiva tunte iro, namarivano vohaanaini otinuvaro aahara vatavano qovaraiqaa viro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kotiva aahara vata autu nteharo, Vatave, tivakero namarivano vohaanaini otu vaura autu nteharo, Nora namarive, tura. Kotiva tavovaro nai autu kero vato haikava koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mintuvaro Kotiva tiharo, Vatavano vairaro viraqihairo qampiqaarira haikava qovarai qiarire. Vo ukau vo ukauvano tava iraariravavata, vo katari vo katarivano tava iraariravavata qovaraiqiarire, tuvaro Kotiva tunte iro, vi haikava vi haikava qovaraiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Vataqihairo qampiqe vau haikava qovarama vura. Vo ukau vo ukauvano tava ireharo kia hampi tava iraraitiro, nai tavaqai iraqiro vi vauvaro, vo katari vo katarivanovata tava ireharo nai tavaqai iraqiro vi vaura. Mintiaqiro vi vauvaro Kotiva tavovaro koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Entamaqiro viviro aatita vuvaro vi entava taaramo enta taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Vira qararaa Kotiva tiharo, Naaruvaini ataa i vaina haikava, vo haika vo haikavano qovarama viraro hini haikavano entaqira itaarira haikava vairaro hini haikavano aatitaainaraqaa itaarira haikava variarire. Vi haikava vi haikava vaiharo kara uti entarave, kara qanti entarave, tora itaqiro viro vuru taiqaaina entarave, ihi taiqaaina entarave, numiqaqiro vuanarove. ");
INSERT INTO tbg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Vi haikava vi haikava naaruvaini viri kanta itaqiro viharo vataini ataama nimitaarire, tuvaro Kotiva tunte iro, vi haikava ataa iharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kotiva ataama nimitaaina haikara nora haika taaraqanta autu kero vatora. Kuarivano aatitaainaraqaa itaqiro vuarire tiro, autu kero vatero, toravano entaqira itaqiro vuarire tiro, autu kero vatora. Viva makauve, quhaive, opuve, vaahoqurave, vi haikaravata autu kero vatora. ");
INSERT INTO tbg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Vataini ataama nimitaqi vuarire tiro, Kotiva ekaa vi haikara naaruvaini vatora. ");
INSERT INTO tbg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Vi haikava vi haikava aatitaainaraqaavata entaqivata itaqiro vuarire tiro, naaruvaini ekaa vi haikara autu kero vatora. Konkiraiqirava nariara vairaro aatitaarirava nariara variarire tiro, Kotiva vi haikara vi haikara autu kero naaruvaini vatora. Kotiva tavovaro nai autu kero vato haikava koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Entamaqiro viviro aatita vuvaro vi entava erakaimaante enta taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Vira qararaa Kotiva tiharo, Vo haika vo haika qaqi variqiro vuarira haikava nora namariqi qovaramavi mpiqaate. Vo uviri vo uvirivano ata vare vi aniha naaruvainivata mpiqaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Minti tivakero Kotiva nora aantauvahi nora namariqi ni vai haikara autu kero ekaa vi haikava namariqi qaqi variqiro vuaina haikarave, ekaa nana nana haika qakiaina haikarave, vo haika vo haika autu kero vatero, vo uviri vo uviri aroka vataaka autu kero vatora. Kotiva tavovaro nai autu kero vato haikava koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kotiva vi haikara vi haikara koqema nimitero tiharo, Ne namariqi varia aantauka kuvuaramaqi vivaro airiqiharo namariqi mpiqaarire. Ne uvirivata kuvuaramaqi vivaro airiqiarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Entamaqiro viviro aatita vuvaro vi entava kauquru enta taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Vira qararaa Kotiva tiharo, Vataqaa vo aantau vo aantauvano qaqi variqiro viharo nuarire. Kuvu vate aantaurave, qaakau aantauve, toveqive, memaruve, ekaa aantauvahivano vo aantau vo aantauvano vataqaa nuarire, tiro. Minti tuvaro Kotiva tunte iro, vi haikava vi haikava qovarama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kotiva qaakau aantau, vo aantau vo aantau autu kero, kuvu vate aantaura, vo aantau vo aantauvata autu kero, memaruve toveqive vo haika vo haikavata autu kero vatora. Kotiva tavovaro nai autu kero vato haikava koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mintuvaro Kotiva tiharo, Kaiqe tentanavu voqaara vaiinti autu kaari vika nora namariqi vai havukaukave, naaruvaini ataqi ni vai uvirikave, vataini kuvu vai aantaukave, qaakau aantauve, ekaa vikaqaa raqikiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Minti tivakero Kotiva vaiinti vira nai voqaara autu kora. Viva nai voqaara qoraintivata nahentivata autu kero vatora. ");
INSERT INTO tbg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kotiva vitanta koqema nimitero tiharo, Netanta vainti kuvuaramaqi vimanta nitanta vainti airiqiha vata maata mpiqaate. Te nitanta noraiqama kaari netanta nora namariqi vai havukaukave, naaruvaini ata vare ni vai uvirikave, ekaa vataqaa vai aantaukave, netanta ekaa vikaqaa raqikiqi vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kotiva minti tivakero qaiqaa tiharo, Ekaa ahaikavano iraaina tavarave, ekaa katarivano iraaina tavarave, te vi haikara nitanta nimiariraro nitanta karama varianarove. ");
INSERT INTO tbg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ekaa aantauvahi vataini vaikave, ekaa aantauvahi naaruvaini vaikave, ekaa memaruve toveqive vataini vaikave, vika ne karava vaireva, ekaa mare vaina haikavama varianarove, tiro. Minti tuvaro Kotiva tunte iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kotiva ekaa haika nai autu kero vato haikara tavovaro voqama kero koqe iro vaura. Entamaqiro viviro aatita vuvaro vi entava 6 enta taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mintima kero Kotiva naaruvavata vatavata autu taiqakero vatora. ");
INSERT INTO tbg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kotiva 6 entara kaiqa varaqiro viviro, ekaa haika autu taiqa kero, viva 7 entaqaa kia kaiqa vararaitiro, auraara vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kotiva kaiqa varaqiro viviro, ekaa haika autu taiqa kero 7 entaqaa nora auraara vaurara tiro, viva vi entara 7 enta koqema amitero virara, Maa entava aahuva enta auraara entama varianarove, tura. ");
INSERT INTO tbg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Naaruvavata vatavata autukero vato okarava mintima vaura. Noravano Kotiva naaruvavata vatavata autukero vato entara, ");
INSERT INTO tbg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hoqarero Noravano Kotiva kia aaqu vara kovarora tiro, kia katarive ukauve qampiqovaro vata tuqantaa kaarirava kia vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","vataqihainaa namarivanoqai qovarama viro ekaa vata maata putaiqama keharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mintima vauvaro Noravano Kotiva vata varakero vaiinti autu kero vatero, nai qaqi variqiro vuaina aihora vaiinti vira aiqiana vuaqa kovaro viva qaqi variqiro vuarirava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mintuvaro Noravano Kotiva nai autukero vato vaiintira vira vita varero kuari uruntonaini Ideni vataini nai ututo naahoraqi vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Vi naahoraqi Noravano Kotiva tuvaro koqe katari, vo katari vo katarivano qampiqero vauvaro vika tava vaireva, koqe katari tava, ne tavava vaura. Naaho avuta viraqi katari taaraqanta vaura. Katari vo qaqi variqi vi katariva vauvaro, katari vo koqe kaiqave qora kaiqave tave vai katariva vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ideni naahoqihairo namari vo otu viharo vi naahora putaiqama kareva otu viharo naahoqihairo namari viva raira viro 4navuqaa otu vura. ");
INSERT INTO tbg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Vi namariva raira viro hoqare vura autu vaireva, Pisoni Namarive tura. Vi namariva otu viharo Havila vataini virante airantemaqiro vura. ");
INSERT INTO tbg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Havila vataini kori ori vauvaro, koqe unta u haikava vauvaro, vaheheqi/vaataiqi vau orivavata vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Pisoni Namari vauvaro vira naantiara namari vo, Gihoni Namari vaura. Gihoni Namarivano Kusi vataini virante airantemaqiro otu vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Taara namari mintimake vauvaro vo namari Taigarisi Namari vaura. Taigarisi Namarivano Asiria vataini kuari uri mantaraini otu vi vaura. Ekaanaini Iufaretisi Namarivano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Noravano Kotiva vaiinti vira vita varero nai naahoqi Ideni vataini vuru kero tiharo, Maaqi vaihara kaiqa varehara koqema kera ti naahoqaa raqikiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Minti tivakero Noravano Kotiva kempukaiqama kero vaiinti vira tiva amiro tiharo, Ekaa katari tava irataainara homa hiqi kera nenarave. ");
INSERT INTO tbg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Katari vo, koqe kaiqavata qora kaiqavata tave vaira, vi katarira tava kia hiqikera naane. Are vira nama kairera, are qutuma vinarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Noravano Kotiva tiharo, Vaiinti viva nariaraa vaivaro kiama koqe ivo. Kaiqe te vira kahaqiainara nai voqaara vo autu amitaare, tura. ");
INSERT INTO tbg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Hoqarero Noravano Kotiva vata vara kero viraqohairo ekaa aantauvahi vataini ni vaika autu kero vatero, ekaa aantau naaruvaini ni vaikavata autu kero vatero, vika vika ntita varero vaiintivano vika nutu ntava taarire tiro, viva vaunaini vika vuru kovaro vaiinti viva ekaa vika nutu ntava tovaro vika nutuvano mintimakero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Vaiinti viva vika nutu ntavaqiro viharo ekaa vataini kuvu vai aantaukave, qaakau aantauve, ekaa naaruvaini viri kanta ataqi ni vai uvirikave, viva ekaa vika vika nutu ntava tora. Adaamuva mintiaqiro vuvaro kia vikaqihairo vovano nai vira voqaava vira kahaqiarirava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kia vauvarora tiro, Noravano Kotiva vaiinti vira vaita kovaro viva vaita aavata vuvaro vaiinti vira aantera vonku nkaqu kero qaiqaa mati tinta tora. ");
INSERT INTO tbg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Noravano Kotiva aantera vaiintiqihairo nkaqu tora viraqohairo nahenti autu kero nahenti vira vita varero vaiinti viva vaunaini vuru kovaro ");
INSERT INTO tbg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","vaiinti viva vira tavero tiharo, Hove, viva ti voqaarama vaivo. Vira vuhaarivata ti vuhaarivata vohaama vaivo. Vira mativata ti mativata vohaama vaivo. Viva ti vaiintiqaahairo vara kero vira autu kairara ti, te virara nahentive turo, tiro. Minti tivakero turama. ");
INSERT INTO tbg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kotiva mintimakero autu amitairara tiro, vate maa entara vaiintivano nai noka qoka kero nai naatantiro tampama viraro vitanta vaatavano vohaa vaatama varianaro. ");
INSERT INTO tbg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Vaiintivano nai naatantiro vauvaro vitanta utavaaqa kia vaumanta toka vaihatanta kia kaurihatanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Noravano Kotiva ekaa aantau autukero vatoraqihairo memaruvano voqama kero uqerara uva ti vauva vaiharo nahentiara tiharo, Quqaae Kotiva nitanta qioqama teharo ekaa katari tava maa naahoraqi iratainara kia naate tirave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Minti tuvaro nahenti viva memaruara tiharo, Tetanta ekaa katari tava maa naahoraqi iratainara homa nararave. ");
INSERT INTO tbg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Naaho avutaini vai katarira vohaiqa vira tavaqaima Kotiva titantara tiharo, Kia naate, kia utu varaate. Netanta vi tavara utu vare nama kaivera, netanta qutuma vivarave, tirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Minti tuvaro memaruvano nahentiara tiharo, Aqao, netanta kiama qutu vivarave. ");
INSERT INTO tbg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Netanta vira nama kaivaro nitanta avu aatovano kenko tirama netanta koqe kaiqavata qora kaiqavata ho tavehama Kotira nai voqaarama vaivarave. Kotiva virara iriharo nitantara kia naate tiva tairave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Memaruvano minti tuvaro nahentivano vi katarira tavovaro koqe katari tava iratovaro kaiqe ekaa kaiqa ho tavaare tivakero katari vira tava hiqi kero nero. Neharoma hini nai vaativata amuvaroma vivavata nero. ");
INSERT INTO tbg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Vitanta nama kovaro vitanta avu aatovano kenko tumanta náitanta vaata tavovaro toka vaumanta kaurihatanta oru maura raqake irake náitanta vaata naavumate vaura. ");
INSERT INTO tbg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Vitanta vaiha iruvaro eronaini Noravano Kotiva vi naahoraqi tuvu ni vaumanta vitanta oru katari avutaini kukeqavitanta viraqi vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Noravano Kotiva vaiinti vira aarero tiharo, Are taraqie variaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Minti tuvaro vaiinti viva tiharo, Are naahoqi tuvu nihara kunkukai tianara irima te toka vaihara tima, qetake maini ani kukeqavi vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Vaiinti viva minti tuvaro Kotiva tiharo, Tavave ai vaatara toka vaivo tivarae are kukeqa vuaro? Te qioqama tauna katari tavarae are nama kaaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Minti tuvaro vaiinti viva tiharo, Are nahenti ti timiarava, vivama katari tava hiqi kero tivata timimanta nauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Minti tuvaro Noravano Kotiva nahentiara tiharo, Are nanae vara kaaro? tuvaro nahenti viva tiharo, Aqao, memaruvano tiriara una uva timantama te katari tava hiqike nauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Minti tuvaro Noravano Kotiva memaruara tiharo, Are una uva tianara kaara are ekaa aantauvahiqihaira qoraiqama vinarave. Vira kaara are konkoma kanta vaiharama auhaqaahaira ninarave. Mintimaqira niharama konkoma namaqira viharama qutu vinarave. ");
INSERT INTO tbg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Are kuvuara iravavata nahentivano kuvuara iravavata vitanta navutaiqiha variqi vivarave. Naantiara nahentivano kuvuara iarirava vovano ai qiata rukavu kairara are vira aiqu ataa nkaqa kenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Minti tivakero Kotiva nahentiara tiharo, Are vainti taiqama viraro ai voqamakero aihavi vairara vainti taiqamavira variqira vinarave. Are vainti vatareva ihara aihavi vairarama vatenarave. Ai antuqavano nina vaatiara vairaro viva ariqaa raqikiqiro vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Minti tivakero Kotiva Adaamurara tiharo, Are nena naata uva irihara te qioqama tauna katari tavara nama kaanara kaara vatavano qoraiqama vuanarove. Are vataini variqira vina entara vukaari utiharama kara utu namaqira vinarave. ");
INSERT INTO tbg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nimiri vankukavano urikuma vi vairara are ahakaqi karavano qampiqainara namaqira vinarave. ");
INSERT INTO tbg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ari toqaavu nte vairara kara utu namaqira vivira, vuru qutu vira qaiqaa vataqira vinarave. Te vataqohai ai autu taurara variaravave. Are qutu vira qaiqaa vataiqama vinarave, tiro. Kotiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nahenti viva ekaa vo vatanaa vo vatanaaka vika nova variarirava vaurara tiro, Adaamuva nai naata autu nteharo Evaarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Noravano Kotiva aantau paha varakero viraqohairo utavaaqa autu kero Adaamuravata vira naatavata nonku nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Noravano Kotiva tiharo, Ho tavaane. Vaiintivano tinavu aanantama kero vaiharo koqe kaiqavata qora kaiqavata tave vaiva vaivo. Hauri viva nai kauqu tutukero vo katari tava, qaqi variqi vi vai katari tavara hiqi kero nama kero ekaa enta qaqi variqiro vuantorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Minti tivakero Noravano Kotiva vaiintiara tiharo, Te ai vataqohai autu taurava are aaqaini vaihara vata autamaqira vuane, tivakero Ideni naahoqihairo atitama kovaro aaqaini vurama. ");
INSERT INTO tbg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Noravano Kotiva vaiinti nahenti vitanta nititama komanta aaqaini vuvaro Ideni naaho hini mantaraini kuari avu urunaini maimaraara raqikiate tiro, enseli kempukanavu mini komanta vaura. Qaqi variqi vi vai katari tavara hiqike nevorave ti, vinavuka mini maimaraara raqikiha vauvaro iha ito iqoka paipevavata tuqantaa taqantaa iharo aera aera iharo mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adaamuva nai naata Evaakantiro nuvaro Evaava vainti taiqama viro vuru qorainti vainti vatatero vira autu nteharo, Kenirave, tiro. Viva tiharo, Noravano Kotiva ti kahaqimanta te qorainti vainti vatatauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Minti tivakero varikero qaiqaa vainti taiqama viro vuru vira qata Abelira vatatero. Abelira vira vatatovaro noruqama viro Abeliva viva sipisipiqaa raqiki vauvaro vira vakaava Keniva naaho kaiqa vareharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mintiaqitanta viha Keniva nai naahoqihairo kara qantu varero vuru Nora Kotira amitero. ");
INSERT INTO tbg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Amitovaro Abeliva nai sipisipi vovano hoqare vatato naatira vonku aru kero vira teqa kero mati koqera varero vuru Kotira amitora. Vitanta mintimake Nora Kotira amitovaro Noravano Kotiva Abelira quahama amitero, Abeliva sipisipi aru amitora viravata quahama amitero, ");
INSERT INTO tbg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Keniravata, Keniva kara amitoravata, Noravano Kotiva kia quahama amitovaro vira kaara Kenira arara itovaro inaara viri aratero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Keniva inaara viri aratero vauvaro Noravano Kotiva Kenirara tiharo, Nana kaarae ai arara itaivara variaro? Nana kaarae are inaara viri aratera variaro? ");
INSERT INTO tbg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Are koqe kaiqa varairera, te homa ai quahama amitararave. Are kia koqe kaiqa varairera, qora kaiqavano qentiana vaara autute vaiharo ai ravaaqavu kaanarove. Qora kaiqavano ai ravaaqavu kaantorave tira, are kempukaiqama kera qora kaiqa aatara kaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Noravano Kotiva minti tuvaro Keniva kia vira uva iriraitiro, variro nai qatara tiharo, Varaiqetanta aaraini nuare, tivakero nai qata vita varero viro vuru Keniva nai qata Abelira ahakaqi aru kora. ");
INSERT INTO tbg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Aru kovaroma Noravano Kotiva Kenira irero tiharo, Ai qatavano Abeliva tantoe vaivo? tiro. Minti tuvaroma Keniva tiharo, Te kiama vira tavauro. Kia te tenta qataqaa raqiki vauraukavauve, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Minti tuvaro Noravano Kotiva tiharo, Are nana haikae vara kaaro? Te tavauraro ai qata naarevano vataqaa nteharo tiriara nai vuntu kaane tivera, te are nena qata aru kaanara kaara ");
INSERT INTO tbg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ai qoraiqama amitarerave. Are nena qata aru kaararo vira naarevano nteharo vataqi otiqetaira kaara vatavano kiama ho ai kahaqianarove. ");
INSERT INTO tbg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Are kara utu terava kiama koqema kero qampiqaanarove. Are kia vohaa vatainiqai vairaitira, are katu varera hampiqama kera vo vata vo vataini variqira vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Noravano Kotiva minti tuvaro Keniva tiharo, Oho, are noraiqama kera ti titianara kaara te kia ho qaqi vairarave. ");
INSERT INTO tbg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Are maa vataraqaahaira ti tititaaravera te kia ai avuqaa ho vairaiti, te katu vare vo vata vo vataini hampiqamavi ni variariraro vo vaiintivano ti ranta kaarirava ti haruma kaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Keniva minti tuvaro Noravano Kotiva aqao tiro. Kiave, vovano ai aru kairera, te vaiinti 7navu aruke ariqaa vuntu karerave, tiro. Minti tivakero vovano Kenira ranta kero vira aru kaantorave tiro, Noravano Kotiva vira vaataqaa vuka voqaara qara ntuva tora. ");
INSERT INTO tbg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mintima kovaro Keniva Kotira avuqaahairo katu varero kuari avu uruntonaini, Vi-Ania-Vatarave tunaini vaireva vurama. ");
INSERT INTO tbg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keniva nai naatantiro nuvaro vira naatavano vainti taiqama viro vuru qorainti vainti Enokira vatatora. Vatatovaro vi entara Keniva nora vatuka autu kero vaiharo nai maaqu Enokira autu vara kero vi vatukaravata autu ntava teharo Enokive tura. ");
INSERT INTO tbg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enokiva noruqama viro qorainti vainti Iraatira vatatovaro Iraativa noruqama viro nai maaqu autu nteharo Mehuserirave tura. Mehuseriva Metuserira qova vauvaro Metuseriva Lamekira qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamekiva noruqama viro nahenti taaraqanta vara tovaro avuhainaa nahenti autu Adaava vauvaro vira naantiara varato nahentira autu Silaava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adaava qorainti vainti vatatova vira autu Iabaariva noruqama viro ekaa vaiinti nahenti seri naavuqi variqi viha purumakau kaiqave sipisipi kaiqave varoka, vika qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Iabaariva vauvaro vira qata Iubaariva vaireva, ekaa vaiinti aanumaara/noma vuaqe vaukave, kitaa voqaara ruquti vaukave, viva vika qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Adaava vainti vatatotanta mintima vauvaro Silaava qorainti vainti vira autu Tubaari-Kenira vatatora. Tubaari-Keniva noruqama viro aini orivata baraasi orivata vara kero viraqohairo kaiqa varo haikara, vo haika vo haika autu kora. Tubaari-Keniva vauvaro vira aura autu Namaava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamekiva nai naatatantara mintima tiro: Adaao, Silaao, netanta ti uva iriate. Te Lamekikave, netanta ti naatatanta iri vaiqe tiare. Vaiinti vovano ti teqa kaira kaara te nai aru kauro. Vi vaiintiva quvaaraa vaintivano ti ruqutimanta te vira kaara nai aru kauro. ");
INSERT INTO tbg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Vaiinti vovano Kenira ranta kero aru kairera, vira kaara vaiinti 7navu aru keroma viraqaa vuntu taanarove. Vaiinti vovano te vaiinti vo aru kaunara kaara ti Lamekika aru kairera, vira kaara vaiinti 77navu aru keroma tiqaa vuntu kaanarove, tura. ");
INSERT INTO tbg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adaamuva qaiqaa nai naatantiro nuvaro vira naatavano vainti taiqama viro vuru qorainti vainti vatatero vira autu nteharo, Setirave, tivakero mintima tiro: Kotiva Keniva Abelira aru kairara iriharo qorainti vainti vo ti timivo, tura. ");
INSERT INTO tbg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setiva noruqama viro qorainti vainti vo vatatero virara, Enosirave, tura. Vi entaraqaahai vaiinti vika hoqaramake Nora Kotira aare vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adaamura anku okara vaireva, maantimama vairo: Kotiva vaiinti autu kareva iharo viva nai voqaara autu kero vatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Viva vaiinti nahenti vitanta autu kero vitanta quahama nimitero vitantara vaiintive nahentive tura. ");
INSERT INTO tbg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ho Adaamuva 130 ihi vara kero qorainti vainti vo vatatovaro vi vaiintiva nai qora voqaara vauvaro vira autu nteharo, Setirave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Setira vatato entaraqaahairo Adaamuva 800 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adaamuva maa vataraqaa 930 ihi qaqi variqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Setiva 105 ihi vara kero viva qorainti vainti Enosira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Viva Enosira vatato entaraqaahairo 807 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Setiva 912 ihi qaqi varaqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosiva 90 ihi vara kero viva qorainti vainti Kenaanira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Viva Kenaanira vatato entaraqaahairo 815 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosiva 905 ihi qaqi variqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenaaniva 70 ihi vara kero viva qorainti vainti Mahararerira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Viva Mahararerira vatato entaraqaahairo 840 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenaaniva 910 ihi qaqi varaqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maharareriva 65 ihi vara kero viva qorainti vainti Jaretira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Viva Jaretira vatato entaraqaahairo 830 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maharareriva 895 ihi qaqi variqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaretiva 162 ihi vara kero qorainti vainti Enokira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Viva Enokira vatato entaraqaahairo 800 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jaretiva 962 ihi qaqi variqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enokiva 65 ihi vara kero qorainti vainti Metuseraara vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Viva Metuseraara vatato entaraqaahairo 300 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enokiva 365 ihi qaqi variqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enokiva Kotira avuqaa koqema kero ni vauvaro Kotiva vira vita varovarora tiro, viva maa vataraqaahairo tuqaakuma vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuseraava 187 ihi vara kero qorainti vainti Lamekira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Viva Lamekira vatato entaraqaahairo 782 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuseraava 969 ihi qaqi variqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamekiva 182 ihi vara kero qorainti vainti vatatero ");
INSERT INTO tbg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","vira autu nteharo, Noaarave, tivakero mintima tiro: Noravano Kotiva Adaamura atiharo maa vatava qoraiqamama vuanarove tura kaara tenavu vukaari utiha kara utu namaqi vi vaunarave. Ho maa vaintiva noruqama viro tinavu kahaqairaro vuaqa ntairaqe tenavu vi kaiqara varaare, tura. ");
INSERT INTO tbg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noaara vatato entaraqaahairo Lamekiva 595 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamekiva 777 ihi qaqi variqiro viviro vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noaava 500 ihi vara kero Semiravata Haamuravata Iapetiravata vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Vaiinti nahenti maa vataraqaa vaiha vainti kuvuaramaqi vivi, airi nahenti vaintivata vatatomanta ");
INSERT INTO tbg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","kempuka vaiintinavu tavomanta qaqi vaiintivano vatato nahenti vaintika koqe nahenti vaumanta vika nái vi nahentika varaataa umanta vare vaura. ");
INSERT INTO tbg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Minti vauvaro Noravano Kotiva tiharo, Vaiintivano variqi vi vuru qutu vikama variavo. Vira kaara te tenta aiho vaiintiqi vuaqa kaarirava kiama ekaa enta vikaqi variqiro vuanarove. Vika 120 ihiqai maa vataraqaa qaqi variqi vuate, tura. ");
INSERT INTO tbg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Vi entaravata naantiara entavata uritarake vau vaiintika maa vataraqaa vaura. Kempuka vaiintinavu qaqi vaiinti vatato nahenti vaintika varate vaumanta vika vaintinavu vaireka, uritarake vau vaiintika vaiha nora kaiqa vare vauvaro vika nutuvanovata uritara kero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Noravano Kotiva vaiharo tavomanta vaiinti nahenti vika maa vataraqaa variqi vi vauvaro vika qora kaiqavano uritara kero vauvaro vika avu aatoqi qora kaiqa vaaqu kaiqa varevaqai vaura. ");
INSERT INTO tbg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mintuvaro vira kaara Kotira muntukavano qoraiquvaro viva tiharo, Oho, kia te vaiinti autuke vataqaa vataataarave, ");
INSERT INTO tbg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","tivakero tiharo, Te vaiinti nahenti autuke vataurauka te vika vehi autu kaari vika kia maa vataraqaa variate. Vaiinti nahentive, aantauve, toveqive, memaruve, vataqaa ni vaikave, naaruvaini ata vare ni vaikave, te ekaa vika vehi autu karerave. Ti muntukavano qoraiqama ivo. Kia te vi haikara autuataarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Minti tivakero Noravano Kotiva Noaararaqai quaheharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noaara okara maantimama vairo: Noaava koqe vaiintivano vaiharo avuqavu ni vau vaiintiva vaumanta vaiinti nahenti viraqaa uva vateva kia vauvaro viva Kotira uva iriqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Viva qorainti vainti taaramonavu Semirave, Haamurave, Iapetirave, vatakero vatora. ");
INSERT INTO tbg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Vi entara Kotiva tavomanta maa vataraqaa vauka qoraiqama vi vauvaro qora kaiqa varevave, iqoka raqivave, vi haikavaqai maa vataraqaa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kotiva tavomanta maa vataraqaa vau vaiinti nahentika qora aaraqaa nireka auti vaiha voqamake qoraiqama vi vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","viva Noaarara mintima tiro: Vaiinti nahenti qora kaiqa vare variavarora tiro, iqoka raqi okaravaqaima vataini vaivo. Vira kaara te vaiinti nahenti namariqohai vehi autu karerave. Te vikavata vatavata vehi autu taiqa karerave. ");
INSERT INTO tbg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Virara iriharama are sipi vo koqe katariqohaira autuane. Viraqi vo kavaqaara vo kavaqaara autu kera vatera, sipi avutaqivata vahaaqainivata vankora iva/qume taatau taane. ");
INSERT INTO tbg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Maantima kerama autuane: Sipi hini hini mantaraini 130 mita autu tera, taurini hini hini mantaraini 22 mita avatama kera autu tera, viriniara 13 mita avatama kera autuane. ");
INSERT INTO tbg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mintima autu vuru taiqa kera sipi qiatavata autu taiqa kera, qiata vira muntuvi auvahianta kia ekaara tinta karaitira, inaaraiqa hini mita qaqi kairaro ataa iarire. Avutaqi tainta vo autu tera, vira vuruvi tavaarana tainta vo autu tera, vira vuruvi ekaaraqaa tainta vo autu taane. Sipi vira hini taaqeni qenti vo aututaane. ");
INSERT INTO tbg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mintima kera sipi autu vuru taiqa kairaqe te huvura namariqohai ekaa qaqi variqi vi vai haikara vehi autu taiqa karerave. ");
INSERT INTO tbg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mintimakevata, te ainti vaiha vohaa uva tiva taatauke vatarerave. Arevata nena maaqunavuvata, nena naatavata, nena maaqu naatanavuvata, sipi viraqi oriqetaate. ");
INSERT INTO tbg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Vo aantau vo aantau qaqi variate tira, vikaqihaira nahe qora vohaiqa vohaiqa ntita varera vuru sipi viraqi vera kaane. ");
INSERT INTO tbg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Vo uviri vo uvirive, ekaa vo aantau vo aantauve, ekaa toveqive memaruve, nahe qoraqai ainti sipiqi vaiha kia qutu viraiti, qaqi variate. ");
INSERT INTO tbg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Are nentanavu karavata, ekaa aantauvahi karavata, qantukera varera vuru sipi viraqi vatairaro ninavu karavata, vika karavata, ho variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Minti tuvaro Noaava Kotiva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Noravano Kotiva minti tivakero mintima tiro: Te tavaurara areqaima nena navunaa vaiintiqihaira koqe vaiinti varianarara tira, arevata nena vaiinti nahentivata sipi viraqi oriqete variate. ");
INSERT INTO tbg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Aantauvahiqihaira ne ho ne aantauvahira nahe 7navu qora 7navu ntita vara vera sipiqi kaane. Qaiqaa aantauvahiqihaira ne kia ho ne aantauvahira nahevata qoravata ntita vara vera sipiqi kaane. ");
INSERT INTO tbg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Are vo uviri vo uviriqihairavata nahe 7navu qora 7navu ntita vara vera sipiqi kaane. Are mintima kehara ekaa aantauvahi vara vera sipiqi kairamanta vika kia qutiraiti, qaqi variqi vuate. ");
INSERT INTO tbg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Maa entaraqaahai 7 entanavu aitarairaqe te aaqu vara kaariraro aaquvano qaqiqai ntuvaqiro viharo 40 entara, entaqivata aatitainaraqaavata ntuvaqiro viharo vataini qaqi variqiro vi vai haikara te autuke vataurauka ekaa aru taiqa kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Minti tuvaro Noaava Noravano Kotiva tunte iro ekaa haika autu vuru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ho Noaava 600 ihi vara ko entara huvura namarivano ekaa maa vatara aqu ravaaqavu kora. ");
INSERT INTO tbg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noaavavata, vira maaqunavuvata, vira naatavanovata, vitanta maaqunavu naatavaravata, huvura namarivano haruantorave tivake, sipi viraqi oriqete vaura. ");
INSERT INTO tbg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Qaqi aantauvata, kia naa aantauravata, vo uviri vo uvirivata, memaruvata toveqivata, ekaa vataini vau aantauvahika ");
INSERT INTO tbg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","qoravata nahevata Kotiva tunte iro Noaava sipiqi vika vara vera kovaro ");
INSERT INTO tbg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","enta 7navu aitarovaro huvura namarivano vataini qovarama vura. ");
INSERT INTO tbg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noaava 600 ihi varako entara, 17 enta 2 toraqaa, vataqihairo nora namarivano kumpetaqiro uri vauvaro naaruva qantua vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","nora aaquvano ntura. Nora aaqu ntuvaqiro viharo 40 enta, entaqivata aatitoraqaavata nti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Aaqu ntire u entara Noaava nai maaqunavu Semiravata Haamuravata Iapetiravata, Noaara naatavata, vitanta maaqunavu naatavaravata ntita varero sipi viraqi oriqetora. ");
INSERT INTO tbg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Vinavuka sipiqi oriqete vaumanta ekaa qaakau aantauvahive, ekaa kuvu vate aantauvahive, ekaa memaruve toveqive, ekaa aroka vataa uvirive, vika vika vinavuka hampata sipiqi oriqete vaura. ");
INSERT INTO tbg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Kotiva Noaarara tuntemake ekaa qaqi variqi vi aantauvahika qoravata nahevata sipi viraqi oriqete vauvaro Noravano Kotiva naivano vika qenti tinta nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Qenti tinta nimitovaro aaquvano 40 entara ntuvaqiro vi vauvaro huvura namarivano vataqihairo qaqiqai uriharo sipi vira auku varovaro namari turu kanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Huvura namarivano qaqiqai kumpetaqiro uri vauvaro sipivano namari turu kanta vaiharo vi ani vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","huvura namarivano qaqiqai kumpetaqiro uriro ekaa vata maatavata nora aiqinavata nampiqama kora. ");
INSERT INTO tbg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Huvura namarivano qaqiqai kumpetaqiro uriro ekaa nora aiqinavata uri aatara kero oru viro, oru voqavata 7 mitaqaa oru ntero taiqora. ");
INSERT INTO tbg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Huvura namarivano mintimake vaumanta ekaa vataqaa qaqi variqi vi vau haikauka, uvirive, kuvu aantauvahive, qaakau aantauvahive, vaiinti nahentive, ekaa qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Aahara vataqaa aiho vare vau haikauka ekaa qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ekaa qaqi variqi vi vau haikauka, vaiinti nahentive, aantauvahive, uvirive, ekaa vi haikara vi haikara Noravano Kotiva vehi autu taiqa komanta Noaavavata, vira hampata vaukavata, vikaqai sipiqi qaqi vaiha koqemake vaura. ");
INSERT INTO tbg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Huvura namarivano 150 entara vaiharo ekaa vata maata ravaaqavu kovaro namari virivanoqai vauvaro kia vata maata virivanovata vaura. ");
INSERT INTO tbg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Noaavavata vira hampata vaukavata sipi viraqi vauvaro Kotiva qaiqaa vikara iriharo uvai varakovaro uvaivano uti vauvaro namarivano otini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Huvuravano 40 entara kumpetaqiro uri vauvaro, viraqaahairo naaruva tinta kovaro aaqu ntuva tanta vuvaro vataqihairo kumpetaqiro uri vau namarivavata taiqa vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","namarivano oti vaiqi oti vaiqimaqiro viharo kauquru torara mintiaqiro vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","7 tora 17 entaqaa sipi vira Araraata Aiqinaqaa muntu kovaro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Viraqaata vauvaro namarivano oti vaiqi oti vaiqimaqiro vi vauvaro 10 tora 1 entaqaa aiqina qoqaa qoqaa iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mintuvaro 40 entanavu aitarovaro Noaava vata aaharaiqiainara ampeqamake tavareva uintua vo qantuakero ");
INSERT INTO tbg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","memora atitovaro vahaaqaini oru viro qumina ata varero virante airante i vauvaro vatavano aaharaiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Memoravano mintiaqiro viharo kia orurante anuvaro Noaava vata aaharaiqiainara ampeqamake tavareva viva uviri vo mirura voqaara atitovaro oru niharo tavovaro ");
INSERT INTO tbg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","namarivano qaqiqai vataqaa vauvaro vi uviriva utaarirava kia ho vauvaro viva orurantero qaiqaa anintero, Noaava sipiqi vauraqi oriqetareva uvaro Noaava nai kauqu tutukero vira utu varero sipiqi vara vera kora. ");
INSERT INTO tbg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Viraqaahairo 7 entanavu aitarovaro Noaava sipiqihairo qaiqaa vi uvirira atitovaro ");
INSERT INTO tbg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","uviri viva oru niro eronaini orurantero orivi katari mare qaraaka raaqu varero anuvaro Noaava vira tavero kankomakero iruvaro huvura namarivano vataqaahairo otinuvaro ");
INSERT INTO tbg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","viraqaahairo Noaava naavuqi 7 entanavu voqavata varikero, qaiqaa uviri vira atitovaro viro, kia qaiqaa orurantero aniraitiro, ekaara mini vura. ");
INSERT INTO tbg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noaava 601 ihi vara kovaro 1 ihi 1 entaqaa ekaa huvura namarivano otinuvaro vatavano aaharaiqama vuvaro Noaava sipi qiataqaa aquto haikara qaqini varakero viti viri tavovaro vata maata aaharaiqama vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","2 tora 27 entaqaa tavovaro vatavano anoma kero aaharaiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Vatavano aaharaiqama vuvaro Kotiva Noaarara tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Arevata, ai naatavanovata, nitanta maaqunavuvata, vika naatanavuvata, nenavu sipiqihai veva ntaate. ");
INSERT INTO tbg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ekaa aantauvahivata uvirivata ninavu hampata variaka vara veva kairamanta vika kuvu aramaqi viha ekaa vata maata mpiqaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Minti tumanta Noaavavata, vira naatavanovata, vitanta maaqunavuvata, vika naatanavuvata sipiqihai veva ntomanta ");
INSERT INTO tbg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ekaa aantauvahivata uvirivata sipiqihai nai naantiara nai naantiara vahaaqaini vevante vura. ");
INSERT INTO tbg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noaava vevantero Nora Kotira quahama amitareva iharo vo ori vo ori varakero ofaa tainta aututero viraqaahairo ho Kotira amiaina uviri aantauraqihairo hini varakero arukero, taintaqaa Kotira kaintu iha quara amitero. ");
INSERT INTO tbg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Iha quara amitovaro Noravano Kotiva vira tavero quahakero tiharo, Te vaiinti okara iruramanta vika vainti naatikaahai qora kaiqa varevaqai vika avu aatoqi vaimanta variarave. Mintiamantavata, kia te qaiqaa vaiintivano qora okara autira kaara maa vatarara tiariraro qoraiqama vuanarove. Kia te qaiqaa ekaa qaqi variqi vi vai haikara namariqohai vehi autu taiqa karerave. ");
INSERT INTO tbg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Maa vatava variqiro viraro kara uti entavave, kara qanti entavave, vi entava vi entava homa varianarove. Antaaina entavave, totoqaaina entavave, nora kuari itaaina entavave, kia nora kuari itaaina entavave, entaqive aatitaainaraqaave, maa vatava vairaro vi entava vi entava variqiro vuanarove, tiro. Minti turama. ");
INSERT INTO tbg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kotiva Noaaravata vira maaqunavuvata koqema nimiteharo tiharo, Ne vainti vata kuvuaramaqi vimanta ni vaintivara airiqiha vata maata mpiqaate. ");
INSERT INTO tbg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ekaa vataqaa vai aantauvahikave, ekaa naaruvaini ataqi ni vai uvirikave, ekaa namariqi vai havukaukave, vika ni naatu qeteha vaivarave. Te ekaa vi haikara nima nimuro. ");
INSERT INTO tbg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Vi haikava vi haikava ekaa qaqi variqi vi haikauka ni karama vaivarave. Haaru enta te naaho maatara tiha, Ni karama varianarove, tiavaunarave. Ho vate te qaiqaama ni tiva nimuro, Ekaa qaqi vaina haikava ni karama varianarove. ");
INSERT INTO tbg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Vohaa haikaqai ni qioqama tauro. Matiqi naare vainara, viraqaima kia naate. Naareqaahairo ekaa haikavano qaqi variqiro vi vairara ti, te naare qioqama teha kia naate turo. (Kaiqa Varora 15:20) ");
INSERT INTO tbg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Niqihairo vaiinti vo aru kairaro vira naarevano ntava viraro qutu virera, vira kaara uvama varianarove. Aantauvahivano vaiinti vo aru kairera, vira nai aru kaate. ");
INSERT INTO tbg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Te vaiinti tenta voqaara autuke vataunarara ti, kia vaiinti aru kaate turo. Vaiinti vovano vo vaiinti aru kairera, vira kaara naivata arukevama varianarove. ");
INSERT INTO tbg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ne vaintivata kuvuaramaqi vimanta ni vaintivara airiqiha ekaa vata maata variate turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kotiva minti tivakero viva Noaararavata vira maaqunavuaravata tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Te tiari iriate. Te nivata ne kuvuarama tekaravata irihama, maa uvara tiva taatauke vatarerave. ");
INSERT INTO tbg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Sipiqihai ekaa aantauvahive uvirive vevantaaka vikaravata irihama te minti turo. ");
INSERT INTO tbg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Te kia qaiqaa ekaa qaqi variqi vi haikara huvura namariqohai vehi autu taiqa karerave. ");
INSERT INTO tbg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ne vo haika taveha tiha, Ho quqaama Kotiva minti tivakero uva tiva taatau tairave, tiate ti, te tenta ontanta naaruvaini vataari vataini vaika vira viraaqamake tavaate. ");
INSERT INTO tbg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Te tonavuvata aaquvata varakaaina entara vi entara ontantavanovata vairaqe ");
INSERT INTO tbg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","te vira taveha, te vate nivata ekaa aantauvahivata vaiha uva tiva taunara iritarerave. Vi uvara iritehama te kia qaiqaa ekaa qaqi variqi vi haikara huvura namariqohai vehi autu karerave. ");
INSERT INTO tbg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ontantavano naaruvaini qovarama vuaina entara te vira taveha, te ekaa vataqaa qaqi variqi vi haikara hampata vaiha uva tiva taunara iritarerave. Te uva tiva taarirava qaqi variqiro vuanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Minti tivakero Kotiva Noaarara tiharo, Ontantavano vairamanta ekaa vataini qaqi variqi vika vira taveha, te uva tiva taatau tau nara iritevarave, tiro. Kotiva minti turama. ");
INSERT INTO tbg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Sipiqihai Noaara maaqunavu vevantonavuka nutu vaireva, Semivavata, Haamuvavata, Iapetivavata vaura. (Haamuva Kenaanira qova vaura.) ");
INSERT INTO tbg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noaara maaqu taaramonavuqihai ekaa vo vatanaa vo vatanaaka qovarama vi, oru vo vataini vo vataini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noaava naaho kaiqa vare vau vaiintiva vaiharo viva naane naahoqi uaini naaqunta ututora. ");
INSERT INTO tbg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Viva uaini naaqunta ututova qampiqero mpeqaiqama vuvaro viva vira hiqi kero tati kovaro vi namariva ntera vuvaro uaini vira namakero vueraiqaaviro nai seri naavuqi oriqetero nai utavaaqa nonku tora ekaa viqu vaaquma kero vaita aavata vura. ");
INSERT INTO tbg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mintuvaro Kenaanira qova Haamuva oriqetero tavovaro vira qova tokavano vaite vauvaro viraqihairo vevantero vuru nai vakaatanta tiva nimiro. ");
INSERT INTO tbg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Haamuva vitanta tiva nimumanta Semika Iapetika vukai tavuna vo varetanta náitanta qova toka vainara tavaarorave ti, náitanta viri qaqini taveha, tavuna tauvaqaihai utu vare rahininimaqi vi vuru nái qora aqu amitora. ");
INSERT INTO tbg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ho Noaava vaitoraqihairo himpuvaro vira avu aatovano koqema vuvaro vira maaqu vitihainaava kaiqa varorara iriro, vira kaara viva Haamura vaintivara qoraiqama vuate tiro, mintima tiro: ");
INSERT INTO tbg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Oho, kairaro Kotiva Haamura maaqu Kenaanira qoraiqama amiteharo vira vara kairaro viva tuvitarero nai vakaukavara kaiqa vaiintivano vaiharo vika paanaa haika vara nimitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Noaava minti tivakero qaiqaa mintima tiro: Te Semira Variqa Nora Kotira autu tuaherake vauro. Kairaro Kenaaniva tuvitarero Semira paanaa vainti variarire. ");
INSERT INTO tbg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kairaro Kotiva Iapetira vaintivara kahaqiramanta vika airi variate. Kairamanta Iapetiva kuvuarama taikavata Semiva kuvuarama taikavata vohaaraqi maateraiqiha variqi vivaro, Kenaaniva Iapetira paanaa haika varaarire, tiro. Noaava minti turama. ");
INSERT INTO tbg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nora huvura namarivano taiqo entaraqaahairo Noaava 350 ihi voqavata varaqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noaava maa vataraqaa 950 ihi qaqi varaqiro viro vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noaara maaqunavu Semivavata Haamuvavata Iapetivavata nora huvura namarivano taiqo entaraqaahai vinavuka vaiha vo vainti vo vainti vatatora. Vinavuka vainti vatato okarava vaireva, maantimama vairo: ");
INSERT INTO tbg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iapetira maaqunavu vaireka, Gomevave, Menkokivave, Madaivave, Javaanivave, Tubaarivave, Mesekivave, Tiraasivave, vinavuka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Mintima vaumanta Gomera maaqunavu vaireka, Asakenaasivave, Ripaativave, Tonkamavave, vinavuka vaumanta ");
INSERT INTO tbg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javaanira maaqunavu vaireka, Elisaavave, Tasisivave, Kitimivave, Dodaanivave, vinavuka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Javaanira maaqunavu vaintivara hininavu nora namari auvahini otu vaumanta hininavu nora namari avutaqi vau vataraqaa otu vaiha vika vo anku vo anku vaiha vo uva vo uva ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Haamura maaqunavu vaireka, Kusivave, Isipivave, Putivave, Kenaanivave vinavuka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Mintima vaumanta Kusira maaqunavu vaireka, Sebaavave, Havilaavave, Sapataavave, Ramaavave, Sapatekavave, vinavuka vaura. Mintima vaumanta Ramaara maaqutanta vaireka, Sebaavavata, Dedaanivavata vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusira maaqu vo Nimirotiva noruqama viro nora vaiintivano vaiharo airi vaiinti nahentiqaa raqikiqiro vi vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Noravano Kotiva vira quahama amitovaro viva voqama kero qaakau aantauvahi ari vau vaiintiva vaura. Viva minti vau vaiintiva vauvarora tiro, vira autuvano uritara kero vaumanta vaiinti nahenti nái vaintiara tiha, Ike, Noravano Kotiva nivata quahama nimitaira nevata Nimirotira aanante qaakau aantauvahi arivera, tenavu virara koqeve tiataarave ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimirotiva nora vaiintivano vaiharo tota taaramo vatuka, Babelive, Erekive, Akatave, vinavuraqaa raqiki vaura. Taaramo vatuka vinavuva Sinaa vataini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ho Nimirotiva Sinaa vata mini kero oru Asiria vataini vaiharo qaiqaa vatuka vonavu Niniveve, Rehoboti-Irave, Karaave, ");
INSERT INTO tbg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resenive, autu kora. Ninive hini vauvaro nora vatuka Karaa hini vauvaro Reseni vatukavano vitanta avutana vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Maa vatanaaka Lidiave, Anaamive, Lehaapive, Napatuve, ");
INSERT INTO tbg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarusive, Kasaluve, Kapatoritive, Isipiva ekaa vi vatanaaka qovama vaura. Kasalu vatanaakaqihai Pirisia vatanaaka qovaramavi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenaanira maaqu vo avuni vatatova Saidoniva Saidoni vatanaaka qova vauvaro vira maaqu vo Hitiva Hiti vatanaaka qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenaaniva vitanta qova vaiharo maa vatanaaka vika qovavata vaura: Jebusive, Amove, Girigaasive, ");
INSERT INTO tbg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivive, Akave, Sinive, ");
INSERT INTO tbg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avative, Semaave, Hamaative, Kenaaniva ekaa vi vatanaaka qova vaura. Kenaanira vaintivara vo anku vo anku airiqamavi vonaini vonaini vura. ");
INSERT INTO tbg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Vika vevara Saidoni vatukaihai vivi, vevara Gasa vatuka Geraa vataini vura. Hini kuka vevara Saidoni vatukaihai vivi, vevara Sodomi vatukave, Gomora vatukave, Atamaa vatukave, Seboimu vatukave, vura. Hini kuka vevara Saidoni vatukaihai vivi, verara Lasa vatukaini vura. ");
INSERT INTO tbg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Haamura maaquvara kuvuarama toka mintima vaura. Vika vo anku vo anku, vo vataini vo vataini vaiha, vo uva vo uva ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semiva Iapetira vakaava vaiharo viva Ebe vatanaaka vika qovama vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semira maaqunavu vaireka, Elaamuvave, Asuvave, Apakasaativave, Rutivave, Araamivave, vinavuka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Araamira maaqunavu vaireka, Usivave, Huluvave, Getevave, Masivave, vinavuka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apakasaativa Seraara qova vauvaro Seraava Ebera qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeva qorainti vainti taaraqanta vatatovaro vainti vovano vira autu Perekiva vaura. Perekiva qaqi vau entara vataini vau vaiinti nahentika rairavi vaurara tiro, vira autu Perekirave-Rairaive tura. Perekiva vauvaro vira qatavano Jokitaaniva vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokitaanira maaqunavu vaireka, Alamodaativave, Serepivave, Hasamaavetivave, Jeraavave, ");
INSERT INTO tbg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraamuvave, Usarivave, Dikalaavave, ");
INSERT INTO tbg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obaalivave, Abimaelivave, Sebaavave, ");
INSERT INTO tbg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiaavave, Havilaavave, Jobaapivave, vaura. Vika ekaa Jokitaanira maaqunavu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Jokitaanira vaintivara vau vatava vaireva, Mesaqaahairo viviro, kuari uruntonaini verara Sefaa vataini vuru taiqora. ");
INSERT INTO tbg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Semira maaqunavu mintimake vaiha, vika vo anku vo anku vaiha, vo vataini vo vataini oru vaiha vo uva vo uva ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ekaa vi vatanaa vi vatanaaka vaireka, Noaara vaintivara vaiha vika rairavi vo vataini vo vataini vura. Nora huvura namarivano taiqo entaraqaahai ekaa vatanaaka maa vataraqaa vauka Noaava kuvuarama toka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hoqare vataini vauka kia vo uva vo uva tiraiti, vohaa uvaqai ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Vohaa uva tivaqi viha vika kuarivano uruntonaini vivi, Sinaa Uqitaini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Vika mini vaiha mintima ti: Kaiqenavu vata taatauke airi briki autuke ihaqohai haimike ˻maahota variaina naavura, vo naavu vo naavu kaqaare˼ tivake, vika airi briki autuke, iva/qume varake briki vira taatau keha naavu kaqe vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Vika mintiaqi viha qaiqaa tiha, Tenavu raumpirimavi vo vata vo vataqaa oru variarorave. Kaiqenavu maini vaiha naavu maaqa kaqate, nora naavu vo kaqa taariraro vira qiatavano nai naaro muntuka vairaro tinavu hutuvanovata uritarakero variarire, ti. ");
INSERT INTO tbg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Minti tivake vi naavura kaqe vauvaro Noravano Kotiva naavu maaqavata nora naavuvata tavareva tuvuntero ");
INSERT INTO tbg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","tiharo, Vataini variaka vohaa vatanaaka vaiha vohaa uva ti vaiha nora kaiqa hoqarama taavo. Oho, vika mintiaqi vivera, vika nái varaataa i kaiqara, hampi kaiqa vo kaiqa vo kaiqa varaqi vivarave. ");
INSERT INTO tbg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kaiqe tenavu vika maaqiri tuqantaa kaari vika vo uva vo uva tihama qumimaqa iha kia nai uva nai uva ho iriate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Minti tivakero Noravano Kotiva vika maaqiri hampiqama komanta vaiinti nahenti kia nai uva nai uva ho iriraiti, kaiqa vare vauravata qaqirake vo vataini vo vataini vi anima vura. Mintimakero Noravano Kotiva vika raumpirima kora. ");
INSERT INTO tbg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Noravano Kotiva vataini vauka vika maaqiri hampiqama korara ti, vi vatukara autu nteha, Babelive – Hampiqama korave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semira ankuvano maantimama vairo: Nora huvura namarivano taiqovaro taara ihi aitarovaro Semiva 100 ihi varakova qorainti vainti vo Apakasaatira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Semiva Apakasaatira vatato entaraqaahairo viva 500 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apakasaativa 35 ihi varakero viva qorainti vainti vo Seraara vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Apakasaativa Seraara qova vau entaraqaahairo viva 403 ihi varaqiro viharo vo vainti vo vainti qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Seraava 30 ihi varakero viva qorainti vainti vo Ebera vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Seraava Ebera vatato entaraqaahairo viva 403 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeva 34 ihi varakero viva qorainti vainti vo Perekira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ebeva Perekira vatato entaraqaahairo viva 430 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Perekiva 30 ihi varakero viva qorainti vainti vo Reura vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Perekiva Reura vatato entaraqaahairo viva 209 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reuva 32 ihi varakero viva qorainti vainti vo Serukira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reuva Serukira vatato entaraqaahairo viva 207 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serukiva 30 ihi varakero viva qorainti vainti vo Nehora vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serukiva Nehora vatato entaraqaahairo viva 200 ihi varaqiro viharo vo vainti vo vainti, qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nehova 29 ihi varakero viva qorainti vainti vo Teraara vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nehova Teraara vatato entaraqaahairo viva 119 ihi varaqiro viharo vo vainti vo vainti qoraintivata nahentivata vataqiro viviro, vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teraava 70 ihi varako entaraqaahairo viva qorainti vainti vonavu Eparaamira, Nehora, Haraanira, vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teraara ankuvano maantimama vairo: Teraava Eparaamira, Nehora, Haraanira, vatatovaro Haraaniva Rotira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Vira qova Teraava qaqi vau entara Haraaniva Uri vatuka Kaludia vataini nai vatatonaini vaiharo qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Eparaamiva nahenti vo Saraira varatero vauvaro Nehova Haraanira raavura Mikaara varatero vaura. Haraanira raavura vo, Isakaava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraiva Eparaamira naatavano kia vainti vataraitiro, naahiara/qururaiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teraava nai maaqu Eparaamiravata, nai maaqu Haraanira vainti Rotiravata, Eparaamira naata Sarairavata, vinavuka ntita varero Kaludia vata Uri vatuka mini kero, katu varero Kenaani vataini oru vairare tiro, mini viharo tavero qaqirakero Haraani vatukaini oruntero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teraava 205 ihi varakero Haraani vatukaini qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Noravano Kotiva Eparaamirara tiharo, Nena vatave, nena naavu maaqave, nena qora naavuqi variakave, maini kera katu varairaqe te qaraaka vata ai umiqaarirara are mini vuane. ");
INSERT INTO tbg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Are mintiraqe te are vainti kuvuarenara airiqama amitaare. Te ai koqema amiteha ai autuvata noraiqama kaarirara are ekaa ˻vo vatanaa vo vatanaaka˼ koqema nimitaane. ");
INSERT INTO tbg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Vokika ai koqema amitaiqe te vika náivata koqema nimitarerave. Vokika ai qoraiqama amitaiqe te vika náivata qoraiqama nimitarerave. Naantiara are kuvuarama teraukaqihai te ekaa naato vataini vaika koqema nimitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Minti tuvaro Eparaamiva Noravano Kotiva tunte iro viva 75 ihi varakova Haraani mini kero vurama. Viva vuvaro Rotivavata vikantiro vurama. ");
INSERT INTO tbg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eparaamiva nai naata Sarairavata, nai qata maaqu Rotiravata, nai kaiqa vaiintinavuvata ntita varero Haraanini vaiharo ekaa airaira vatora viravata katu varero Kenaani vataini vireva vura. Mini oruntero ");
INSERT INTO tbg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","vi vataraqaa viharo Sekemi vatuka nora oqiva vaunaini More Oqivave tunaini oruntora. Vi entara Kenaani vatanaaka vi vataraqaa vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Noravano Kotiva Eparaamira avuqaa qovarama viro virara tiharo, Te maa vatara are kuvuarama terauka nimirerave, tiro. Minti tivakero Kotiva Eparaamira avuqaa qovarama vurara tiro, Eparaamiva orinavu varakero ofaa tainta autukero Nora Kotira autu tuahera kora. ");
INSERT INTO tbg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Viraqaahairo Eparaamiva oru viro Beteli vatuka vira vuruvi kuari uruntonaini oruntero, mini nai seri naavu kaqa tero vaura. Beteli vatuka hini vauvaro Ai vatuka hini vauvaro viva tavaarana nai seri naavu kaqa tero vaura. Eparaamiva mini vaiharo Nora Kotira quahama amitareva ofaa tainta vo autukero Nora Kotira aarora. ");
INSERT INTO tbg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Eparaamiva mini varikero qaiqaa katu varero voqi voqi variqiro viviro, Nekevi vataini vurama. ");
INSERT INTO tbg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Vi entara karara aavoqu entava vauvaro Eparaamiva vaunaini kia karavata vauvarora tiro, viva Isipini vahuqa vaireva vura. ");
INSERT INTO tbg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Viva aaraini oru viharo tavovaro Isipi aumanto vauvaro Eparaamiva nai naata Sarairara tiharo, Are koqe viri vaata vataa nahentivano variaro. ");
INSERT INTO tbg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isipi vatanaaka ai taveha ariara ti naatave tivake ai varareka iha ti harukevorave. ");
INSERT INTO tbg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Are vi vatanaakara tihara, Te vira auravanove, tiane. Minti tiramanta vika ariarao ti, kia ti haru karaiti, ti vehakuma timitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Minti tivake vika Isipini vumanta Isipi vatanaaka tavovaro Saraiva koqe viri vaata vataa nahentivano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Isipi vika nora vaiintinavu vi nahentira tave, nai avuhainaa vaiinti, Pero vaiinti tiva ami tiha, Virara koqe nahentive tivake, avuhainaa naavuqi vira vita vare vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Avuhainaa vaiinti viva vi nahentirarao tiro, Eparaamira quahama amiteharo sipisipive, memeraave, purumakauve, donkive, kaiqa vaiintive, kaiqa nahentive, kamerive, vira amura. ");
INSERT INTO tbg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mintuvarovata, Noravano Kotiva Pero vaiinti Eparaamira naata kaara vo rovara vo rovara viraqaavata vira navunaakaqaavata vatovaro ");
INSERT INTO tbg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pero vaiintivano Eparaamira aarama kero virara tiharo, Oho, are nana okarae tiqaa qovarama kaaro? Saraiva ai naatavano vaivara are nantiharae virara kia vutukera ti tiva timira iaro? ");
INSERT INTO tbg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nantiharae are virara tihara, Ti auravano vaivo, tiaramantae te vira varauro? Ho nena naata vita varera vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Avuhainaa vaiintivano minti tivakero nai kaiqa vaiintinavu nititomanta vika Eparaamira atitama kovaro Eparaamiva nai naatavata ekaa nai u haikaravata varero vurama. ");
INSERT INTO tbg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Atitama kovaro Eparaamiva Isipi mini kero anirantero Nekevini vura. Viva nai naatavata ekaa viva nai u haikaravata varero vuvaro Rotivavata vikantiro vurama. ");
INSERT INTO tbg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Vi entara Eparaamiva airi haika, purumakauve, sipisipive, memeraave, kori orive, silvaa orive, vatova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Eparaamiva Nekevini varikero, viraqaahairo katu varero voqi voqi variqiro viro, qoqaraanaini Beteli maaqaini oruntora. Beteli vatuka hini vauvaro Ai vatuka hini vauvaro avutana haaru viva nai seri naavu kaqa tero vaiharo ");
INSERT INTO tbg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ofaa tainta autu tonaini oruntero, mini vaiharo qaiqaa Nora Kotira autu tuahereharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Eparaamiva mini vauvaro Rotivavata vikantiro vaiharo airi airaira sipisipive, memeraave, purumakauve, vatomanta vira kaiqa vaiintinavuvata airi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Rotika Eparaamika vohaa vaihatanta tavomanta vitanta sipisipive, memeraave, kara neva kia ho vaumanta ");
INSERT INTO tbg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","vira kaara vitanta sipisipiqaave memeraaqaave raqiki vauka tirori vaura. (Vi entara Kenaani vatanaakavata Peresi vatanaakavata vi vataraqaa vaura.) ");
INSERT INTO tbg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Vika tirori vauvaro Eparaamiva Rotirara tiharo, Tetanta vohaa qata vakaa vaunarara ti, hauri tetanta tirorimaqi vuari titanta kaiqa vaiintinavuvata tirorivorave. ");
INSERT INTO tbg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ho tavaane. Airi vatama maini vaivo. Kaiqe rairavi te vo vataqaa variarirara are vo vataqaa variane. Are muani otu vairera, te maini variare. Are maini vairera, te muani otu variare. Are nena muntuka vaina vatara kaamatera variane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Eparaamiva minti tuvaro Rotiva muani vuavu tavovaro Iotani Namarivano tuvi vauvaro uqita vata koqeva viviro, muntu Soaa vataini taiqora. Vi vatava vaireva, Ideni vata voqaarave, Isipi vata voqaarave, koqe vata vaura. (Vi entara Noravano Kotiva Sodomivata Gomoravata kia vehi autuko entara vi vatukatanta qaqi vauvaro koqe vatavano mini vaura.) ");
INSERT INTO tbg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Rotiva ekaa Iotani Uqitaini nai kaama tero kuari uruntonaini katu varero vaireva vura. Viva Eparaamira kero mini vura. ");
INSERT INTO tbg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eparaamiva Kenaanini vauvaro Rotiva muani uqita kanta otu nora vatukanavu vaunaini Sodomi aaqaini nai seri naavu maaqa kaqa tero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomiqi vauka qora kaiqa vareha Nora Kotira uva, vo uva vo uva raqaqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Rotiva Eparaamira mini kero vuvaro viraqaahairo Noravano Kotiva Eparaamirara tiharo, Are maaqaa vaihara ekaa vata maata vutu vuru aituqama kera tavaane. ");
INSERT INTO tbg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ekaa vutu vuru tavena vatara te vi vatara aivata are kuvuarama teraukavata nimiariraro vi vatava ni vatavanoma ekaa enta variqiro vuanarove. ");
INSERT INTO tbg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Te ai kahaqiari are kuvuarama terauka nai airitahaama vaivarave. Vika vaireka, nai nuqa voqaara airitahaama vaivarave. Vaiintivano nuqa kia ho kaara ntintemake, ai vaintivaravata kia ho kaara ntivarave. ");
INSERT INTO tbg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Himpira oru nihara ekaa vi vatara tavaane. Vi vatava ai amiarira vatavama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kotiva minti tuvaro Eparaamiva katu varero Mamare Oqiva vaunaini Hebaroni vatukaini vaireva oruntero, nai seri naavu maaqa kaqatero Nora Kotira quahama ami tareva, ofaa tainta vo autu kora. ");
INSERT INTO tbg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Vi entara avuhainaa vaiinti 4navu: Amarafeliva Sinaaqaa raqikuvave, Ariokiva Elasa vatukaqaa raqikuvave, Kedo-Laomeva Elami vatukaqaa raqikuvave, Titaamiva Goimu vatukaqaa raqikuvave, ");
INSERT INTO tbg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","vinavuka avuhainaa vaiinti 5navu hampata raqireka vura. Avuhainaa vaiinti 5navu nutu vaireva, Beraava Sodomi vatukaqaa raqikuvave, Birasaava Gomora vatukaqaa raqikuvave, Sinaapiva Atamaa vatukaqaa raqikuvave, Semebeva Seboimu vatukaqaa raqikuvave, vo avuhainaava Belaaqaa raqikuvave, vinavuka vaura. (Belaa vatuka vo autu Soaave tura.) ");
INSERT INTO tbg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Avuhainauka 5navu nái iqoka vaiinti ntita vare Sidimi Uqitakanta ruvaaqumavi vaiha vaqa ntiha vaura. (Maa entara Qutu vi Varuvava minima vairo.) ");
INSERT INTO tbg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tota King Kedo-Laomeva 12 ihiara variqiro viharo avuhainaaka 5navuqaa raqikiqiro vi vaura. Ho 12 ihi aitarovaro 13 ihiqaa avuhainaa vaiinti 5navu Kedo-Laomerara tiha, Tenavu kia qaiqaa ai vevaaraini vairerave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Vinavuka minti tuvaro ihi vo aitarovaro King Kedo-Laomeva nai tontinavu avuhainaa vaiinti 3navu naarama komanta vinavuka Kedo-Laomera kahaqireka vohaaraqi avitumavi nái iqoka vaiinti ntita vare oru Asateroti-Kanaimi vataini vaiha Refaimi vatanaaka hampata raquqi viha vika naatarake, viraqaahai vinavuka Haamu vatukaini oru vaiha Susumi vatanaaka naatarake, viraqaahai vinavuka oru Kiriataimi uqitaini Emimi vatanaaka naatarake, ");
INSERT INTO tbg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","oru verara Seiru aiqinaini Hori vatanaaka naatara keha, vinavuka vika aru ntataqi vivi, aahara vata auvahini Eli-Paraanini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Viraqaahai avuhainauka 4 vinavuka orurante Kadesi vatuka, vo autu Eni-Misipative tunaini vaiha, Amareki vatanaaka ekaa naatarake, oru Hasasoni-Tema vatukaini vaiha Amo vatanaakavata naatara kora. ");
INSERT INTO tbg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mintiaqi vumanta avuhainaa vaiinti 5navu Sodomiqaa raqikuvave, Gomoraqaa raqikuvave, Atamaaqaa raqikuvave, Seboimuqaa raqikuvave, Belaaqaa raqikuvave, vinavukavata nái iqoka vaiinti ntita vare Sidimi Uqitakanta ruvaaqumavi vaiha iqoka raqireka vaqa nti vaumanta ");
INSERT INTO tbg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedo-Laomeva nai tonti 3navu vatamakero 5navu hampata raqireka vaqa nti vaura. Ho avuhainauka 4navuvano avuhainauka 5navu hampata raquqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidimi Uqita kanta airi ruvu/mpumpi vauvaro viraqi vankora iva/qume vauraqi Sodomi avuhainaara iqoka vaiintive, Gomora avuhainaara iqoka vaiintive, vika qetake ruqemake viha, vokuka ruvuqi/mpumpiqi aqu vumanta, vokuka ruqemake aiqinaini vura. ");
INSERT INTO tbg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mintumanta avuhainaa vaiinti 4navu vinavuka naataraqi viha, oru Sodomi vatukaqihaivata Gomora vatukaqihaivata ekaa airairavata karavata raqiake vare vurama. ");
INSERT INTO tbg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Eparaamira qata vainti Rotiva Sodomi vatukaqi vaumanta vika viravata ravaaqavu vare, viva u haikaravata vare vura. ");
INSERT INTO tbg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ho mintuvaro vovano ruqema kero vuva vuru Eparaamira Hiparu vatanaa vaiinti Rotirara tiva amura. Vi entara Eparaamiva nora oqiva vauraqi vauvaro Amo vatanaa vaiinti Mamareva oqiva qova vivavata, Mamarera qatatanta Esikolika Aneka vitantavata, Eparaamira tontiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Vinavuka Eparaamira hampata vauvaro Eparaamiva Rotira ravaaqavuke rumpa varo uvara iriro viva 318 iqoka vaiinti nai vaunaini vauka naarama kero, avuhainaa vaiinti 4navu hampata raqireva vinavuka avataqiro viviro, Daani maaqaini oruntora. ");
INSERT INTO tbg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mini oruntovaro enta uvaro Eparaamiva nai iqoka vaiintinavu rairakero taara vara autukero vatomanta vika entaqi navutaaka hampata raquqi vura. Eparaamiva nai iqoka vaiinti hampata vika aru ntataqi vivi, Hoba vatukaini Damasikusi noti mantaraini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eparaamiva mintiaqiro viharo vika raqia vare vu airairara qaiqaa varero, nai qata vainti Rotiravata kuvantu kero vitero, Rotiva u haikaravata qaiqaa varero, nahenti vonavuvata kuvantu kero ntitero, vo vaiinti nahentinavuvata kuvantu kero ntita varero orurantero anura. ");
INSERT INTO tbg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Eparaamiva King Kedo-Laomeravata avuhainaa vaiinti 3navuvata naatara kero orurantero aaraini ani vauvaro Sodomi vatanaakaqaa raqiku vaiintiva Eparaamira vita kareva Save Uqitainive, Avuhainaara Uqitainive tunaini vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Merikisitekiva vivavata Eparaamira vita kareva vura. Merikisitekiva vaireva, viva Saremi vatuka avuhainaava nai virini kantaaqaini vai Variqara kaiqa vara amite vau vaiintiva vaura. Viva oru Eparaamira vita kero mparetivata uainivata vira amiro ");
INSERT INTO tbg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","nai kauqu tuaherakero vira koqema amitero tiharo, Nai virini kantaaqaini vai Variqava naaruvavata vatavata autukero vataiva, viva ai Eparaamira koqema amitaarire. ");
INSERT INTO tbg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nai virini kantaaqaini vai Variqava ai kahaqiharo navutaaka ai kauquqi kaivara are vika naatara kaanarara ti, tenavu vira autu tuahere vauro, tiro. Merikisitekiva minti tuvaro Eparaamiva navutaaka kauquqihairo vare anu airairara rairakero kauqurutanta vatoraqihairo vohaiqa Merikisitekira amuvaro varora. ");
INSERT INTO tbg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Merikisitekiva vohaiqa varovaro Sodomi vatanaaka avuhainaa vaiintivano Eparaamirara tiharo, Are ti navunaaka kuvantu taarauka vikaqai tinta timiane. Navutaaka vika airaira varataara are vi haikara kia ti timiraitira, nena totaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Sodomi vatanaaka avuhainaa vaiintivano minti tuvaro Eparaamiva aqao tiro, Noravano Kotiva nai virini kantaaqaini vai Variqava, viva naaruvavata vatavata autukero vataivave. Te vira avuqaa vaiha te tenta kauqu aiqiqaa aqukeha virara minti tunarave: ");
INSERT INTO tbg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Vika Sodomi vatanaaka airaira vare vuaraqihai kia te voqavata vararerave, tunarave. Te ni airaira varaarirara hauri are tiriara tihara, Te Eparaamira airi airaira amuraro viva airi haika vataivo, tirorave. Virara irihama kia te ni airaira voqavata vararerave. ");
INSERT INTO tbg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tenta vaiintinavu vaaka namakaa karara, vi kararaqai te niqihai varaunarave. Ti hampata vuaka, Anerave, Esikolirave, Mamarerave, vinavuka are nena airaira hini rairakera nimiramanta varaate, tura. ");
INSERT INTO tbg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Vo entanavu aitarovaro Eparaamiva kia vaitaraitiro, qaqi vaiharo taira tave vauvaro Noravano Kotiva virara tiharo, Kiama qetehara variane. Vo haikavano ai aruantorave tiha, te kainke voqaara vaiha ai antua amitarerave. Te nora koqaama ai amirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Minti tuvaro Eparaamiva tiharo, Mpo Noravauvo, are ekaa haikaqaa raqiki variaravama variaro. Are nana haikae ti timinarave? Te kia vainti vatatauro. Ti maaquvano kia vairera, te qutu vuariraro ti kaiqa vaiinti Elieseva Damasikusihainaava te iaina haikara varaanarove. Viva mintiantorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Eparaamiva minti tuvaro Noravano Kotiva tiharo, Vi vaiintiva kiama are ina haikara varaanarove. Nina maaquvano vi haikara varaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kotiva minti tiva kero Eparaamira vita varero vevantero tiharo, Virini tavaane. Ai vaintivara vaireka, opu makau voqaara airitahaama vaivarave. Are kia ho opu makau kaara ntinantema kera, nena vaintivaravata kia ho kaara ntinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kotiva minti tuvaro Eparaamiva kia vainti vataraitiro, naampaiqama vuva vaiharo Noravano Kotiva tu uvarara, quqaave, tura. Eparaamiva quqaave tiva kero Kotirara kempukaiqama kero iruvarora tiro, Kotiva tiharo, Te Eparaamirara avuqavu ni vai vaiintirave turo, tura. ");
INSERT INTO tbg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kotiva qaiqaa Eparaamirara tiharo, Te Noravano Kotikave. Maa vatara te ai amiariraro ekaa enta ai vata variarire ti, te Uri vatuka Kaludia vataihai ai vita vare anuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Minti tuvaro Eparaamiva aqao tiro. Mpo Noravauvo, are ekaa haikaqaa raqiki variaravama variaro. Are vata ti timire ina okarara te nantiakee virara kankomake irirarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Minti tuvaro Noravano Kotiva tiharo, Are purumakau nahe vo, memeraa nahe vo, sipisipi qora vo, taaramo ihi varakeka vara viri timiane. Inaara uviri taaraqantavata vara viri timiane, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eparaamiva Kotiva tuntema kero purumakauve memeraave sipisipive varero arukero kuhia kero avutaqaa nkahi kero, hini hini naiqi naiqi vataqiro viro taiqa kero, uvirivata aru kero kia toqa karaitiro, qaqi vatora. ");
INSERT INTO tbg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Eparaamiva mintima kero vatovaro mati ne vau uvirika tuvu viraqaata utama vuare tuvaro viva memora vinavuka ruhaaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ruhaaqi vauvaro kuarivano aquvireva otu vi vauvaro Eparaamiva vaita aavata vuvaro aatu ite vauvaro voqama kero qeteharo vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Noravano Kotiva ˻tairakaa˼ virara tiharo, Are kuvuarama terauka, vika naantiara vo vatanaaka vataini katu vare oru vaivarave. Vika mini oru vaimanta vi vatanaaka vika rumpa teha qoraiqama nimite vaimanta ai vaintivara vi vatanaaka paanaa kaiqa varevarave. Ai vaintivara vi vataraqaa 400 ihi variqi vi vaiqe ");
INSERT INTO tbg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","viraqaahai te vi vatanaaka ntaihaari ai vaintivara airi airaira vare, vi vatara ke orurante anivarave. ");
INSERT INTO tbg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Are qaqi variqira vihara anoma kera naampaiqama vira qaqi qutu vinarave. ");
INSERT INTO tbg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ai vaintivara kiama vaaka orurante anivarave. Maa vatanaaka Amo vatanaaka qora kaiqa varaqi viha anomake qora kaiqa vare vaiqe te vi entara Amo vatanaaka ntaihama kaari ai vaintivara maini homa orurante anivarave. Ai vaintivara vo vataini oru vaiha mini variqi vi vuru qutu vimanta, vika vaintivaravata qutu vimanta, vika naintivaravata qutu vimanta, vika naantiaraini vaika qaqi variqi vi entara vika vi vatara ke maini orurante anivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kotiva minti tuvaro kuarivano ruhunku vuvaro entama vuvaro Eparaamiva tavovaro ova ite vauvavata, taveqihairo muravano oru vi vauvavata, qovarama viro mati toqa kero vatoraqaa tavaarantuna aitare vaura. ");
INSERT INTO tbg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mintuvaro vi entaraqaa Noravano Kotiva Eparaamikantiro uva tiva taatautero tiharo, Isipi vataqaahairo vatavano viviro vuru Iufaretisi Namari auvahini taiqaaina vatara ai amirerave. ");
INSERT INTO tbg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kini vatanaakave, Kenisi vatanaakave, Kataamoni vatanaakave. ");
INSERT INTO tbg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti vatanaakave, Peresi vatanaakave, Refaimi vatanaakave, ");
INSERT INTO tbg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amo vatanaakave, Kenaani vatanaakave, Girigaasi vatanaakave, Jebusi vatanaakave, vika vika vatavano ai vaintivara vatama varianarove, tura. ");
INSERT INTO tbg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Eparaamira naatavano Saraiva kia vira vainti vata amitaraitiro, qaqi vauvaro Saraira paanaa nahenti vo, Isipihainaa nahenti vira autu Hagaava vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraiva Eparaamirara tiharo, Eparaamio, Noravano Kotiva kia ti kahaqivera kia te vainti vata amitauro. Are ti paanaa nahenti vikantira nihara vaitairaro viva hoe ti vainti vata timitaanarove, kiae ho vata timitaanarove? tiro. Saraiva minti tuvaro Eparaamiva eo tura. ");
INSERT INTO tbg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Vi entara Eparaamiva Kenaani vataini 10 ihi varakero vauvaro Saraiva nai paanaa nahenti Isipihainaara Hagaara vita varero vuru Eparaamira amuvaro ");
INSERT INTO tbg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eparaamiva vira varatero vikantiro ni vauvaro Hagaava vainti taiqama vura. Hagaava nai vainti taiqama vurara iriro, nai mahuta tiharo Sarairara, Viva vehi nahentivanoma vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Minti ti vauvaro Saraiva Eparaamirara tiharo, Oho, ai okara kaarama vi nahentiva tiriara qora uva ti vaivo. Te tentavano vi nahentira ai amuraro viva vainti taiqama viro viraqaahairo tiriara qora uva ti vaivo. Oho, Noravano Kotiva titanta uva iriharo ariqaa uva vatairaqe te hove tiataarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Saraiva minti tuvaro Eparaamiva Saraira nai tiva amiro tiharo, Aqao, vi nahentiva ai kaiqa nahentima vaivo. Homa vi nahentira nana okara autu amitaataa irera, autuane, tiro. Eparaamiva minti tuvaro Saraiva oru Hagaara voqama kero qoraiqama amitaqiro vuvarora tiro, Hagaava qetakero ruqemakero vura. ");
INSERT INTO tbg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagaava ruqemakero aahara vataini, Suri vataini vi vau aarara ruvu namari tataaqa oru vauvaro Noravano Kotiva atito enseliva vira tataaqa qovarama viro ");
INSERT INTO tbg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","tiharo, Hagaao, are Saraira paanaa nahentima variaro. Taihaira aniarava taini virevae iaro? tuvaro Hagaava nai tiva amiro tiharo, Te tenta nora nahenti aatu qetake ruqemake maini anuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Minti tuvaro enseli viva tiharo, Anirantera oru nena nora nahentivano vainanaini vira paanaa kaiqa varehara vira vevaaraini variane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Minti tivakero enseli viva tiharo, Te ai kahaqiariraro ai vaintivara airitahaa vaivaro kia vovanovata vika ho kaara ntuanarove. ");
INSERT INTO tbg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Are vainti taiqama vuarava qorainti vaintima vatatenarave. Are qoraiqamavira ke ke tiana uvara Noravano Kotiva irirara tira, are nena vainti autu ntavateharama virara Isamairirave — Noravano Kotiva Irirave, tiane. ");
INSERT INTO tbg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ai vaintivano noruqama viro vaiharo qaakau donki voqaara vaiharo viva voqama kero raquarira vaiintiva vairamanta vo vaiinti vo vaiinti vira hampata raquqi vivarave. Viva nai navunaaka hampata navutaiqamaqiro viharo varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Enseli viva Hagaarara vi uvara tuvaro Hagaava nai aatoqi mintima keroma iriro, Ike, Kotiva ti tave vaivama vaivo. Quqaae Kotiva ti tave vaira te vira taveha kia qutu viraiti, qaqi vauro? Virara irihama te Kotirara, Are ti tave variaravama variaro, turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hagaava minti turara ti, maa entara vaiinti nahenti vi namarira autu nteha, Be-Lahai-Roi-Qaqi Variqiro Vi Vaiva ti tave vaira vira namarive, ti variara. Vi ruvu namariva vaireva, Kadesi vatuka hini vaivaro Bereti vatuka hini vaivaro avutaini vaira. ");
INSERT INTO tbg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagaava variqiro viro vuru Eparaamira qorainti vainti vata amitovaro Eparaamiva vira autu nteharo, Isamairirave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Eparaamiva 86 ihi varako entara Hagaava vira Isamairira vata amitora. ");
INSERT INTO tbg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Eparaamiva 99 ihi varakova vauvaro Noravano Kotiva Eparaamira avuqaa qovarama viro tiharo, Te Kotika ekaa kempuka vatauraukave. Are ti avuqaa avuqavuqama kera niraro kia ariqaa uva variarire. ");
INSERT INTO tbg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Are mintiaqira viraqe te ai vataake vaiha uva tiva taatauke vate ai vaintivara airiqama karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Minti tuvaro Eparaamiva vataini hiqinti viro nai viri vataini vatero vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Kotiva tiharo, Te ai vataake vaiha maa uvara tiva taatauke vatarerave. Te tenta kauqu aiqiqaa aqukeha ariara mintima ti, Quqaama are vo vatanaa vo vatanaaka vika qovama vainarave. ");
INSERT INTO tbg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Te ai autu Eparaamira qaqini varake, qaraaka autu nteha ariara Eparahaamivave – Airi Vatanaaka Vika Qovavema turo. Are vo vatanaa vo vatanaaka vika qova vainarara ti, te minti turo. ");
INSERT INTO tbg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Te ai vaintivara airiqama kaari vikaqihai vonavu avuhainaakama vaivarave. Ai vaintivara airiqamavi vaiha vo vatanaa vo vatanaakama vaivarave. ");
INSERT INTO tbg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Te vate kauqu aiqiqaa aqukeha tiva taatau tauna uvara ariaravata ai vaintivararavata irihama kia vi uvara raqa karerave. Te ai Variqavano vaiha, naantiaravata te ai vaintivara Variqavanovata vairerave. ");
INSERT INTO tbg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Maa entara are Kenaani vata maaqaa vo vatanaaka voqaara variaro. Ho te aivata ai vaintivaravata maa vatara nimiariraro vi vatava ni vata ekaa enta vairaqe te ni Variqavano vaiha niqaa raqikiqi virerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kotiva minti tivakero vo uvavata Eparahaamirara mintima tiro: Te vate tiva taatau tauna uvara arevata naantiara ai vaintivara vaikavata virara eo tivake tenavu vi uvara iriqi virerave tiate. ");
INSERT INTO tbg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Te vate tiva taatau tauna uvara arevata naantiara ai vaintivara vaikavata irihama ekaa qorainti vainti vaata toqa kaate. ");
INSERT INTO tbg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Are nena vaatavata toqa kairaro te uva tiva taatau taarirava kempukaiqama vuarire. ");
INSERT INTO tbg_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Maa entaraqaahaira ne ekaa qorainti vainti vatateka 8 enta vara kaimanta vi entaraqaa vika vaata toqa nimitaate. Ni hampata vaika, vika qorainti vaintivata vaata toqa kaate. Ne kaiqa vaiinti vo vataihai koqaama teka, vikavata vika qorainti vaintivata vaata toqa kaate. ");
INSERT INTO tbg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ne vaata toqake okarara mintimake iriqi viha, ne te uva tiva taatau taunaravata kia taurukaraiti, ekaa enta iriqi vivarave. ");
INSERT INTO tbg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Qorainti vainti vo vira vaata kia toqa kaivera, vi vaintiva te tiva taatau tauna uvara raqa kaainara kaara te vi vaintirara kia ti vaintima vaivo tirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Minti tivakero Kotiva qaiqaa Eparahaamirara tiharo, Nena naatara kia qaiqaa Sarairave tiane. Vi autura qaqini varakera virara Seraarave – Avuhainaa Vaiinti Raavurave, tiane. ");
INSERT INTO tbg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Te vira koqema amitaariraro viva airi vatanaaka vika nova vairamanta vira vainti vonavu avuhainaakama vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kotiva minti tuvaro Eparahaamiva vatakanta hiqinti viro nai virivata vataini kero vi uvara iriro nai aatoqi irikero tiharo, Ike, te naampaiqamavi 100 ihi vara kauraro Seraava kontaiqama viro 90 ihi varakaivo. Nantiakee tetanta ho vainti vatatararave? tivakero naaraihama kero ");
INSERT INTO tbg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","viraqaahairo Kotira irero tiharo, Ti maaqu Isamairiva vaivo. Are hoe vira koqema amitairaro viraqira are uva tiva terava vivau variarire? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Eparahaamiva minti tuvaro Kotiva aqao tiro, Kiave. Ai naatavano Seraava qorainti vainti vata amitairara are virara Aisaakirave – Naaraihirave tiane. Te vate uva tiva taarirava viraqivata vira vaintivaraqivata ekaa entama qaqi variqiro vuanarove. ");
INSERT INTO tbg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Are Isamairirara tianara te iruro. Te viravata koqema amitaari viva kuvuara irauka airitahaa vaivarave. Isamairiva nora vaiinti 12navu qova vairaqe te naantiara vika vaintivara koqema nimitaari nora vatanaakama vaivarave. ");
INSERT INTO tbg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ho kia Isamairiraqi te vate uva tiva taatau taurava vairaitiro, vi uvava Aisaakiraqima varianarove. Maa entaraqaahairo ihi aitarairaro Seraava vainti taiqama viro vi vaintira vatataanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kotiva minti tivakero nai uva taiqa kero Eparahaamira mini kero vurama. ");
INSERT INTO tbg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ho vohaa vi entaraqaa Eparahaamiva Kotiva tunte iro nai maaqu Isamairiravata ekaa qorainti vira naavuqi vaukavata vaata toqa kora. Ekaa vira kaiqa vaiinti vira vatukaini vatatokavata, niaraihai monu aqukeha koqaamato vaiintikavata, viva ekaa vika vaatavata toqa nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Vi entara Eparahaamiva 99 ihi varakova nai vaata toqa kero ");
INSERT INTO tbg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","nai maaqu Isamairiva 13 ihi varakora ");
INSERT INTO tbg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","vira vaatavata vohaa vi entaraqaa toqa amitora. ");
INSERT INTO tbg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Vohaa vi entaraqaa nai kaiqa vaiintivata vaata toqa nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Eparahaamiva Mamarera Oqiva vauraqi vauvaro Noravano Kotiva vira avuqaa qovarama vura. Vi uvara okara maantimama vairo: Kuarivano uriro qiataqaa noraiqama kero itoraqaa Eparahaamiva aumaqaaraini nai seri naavu qentiana oquviro vaiharo viti tavomanta ");
INSERT INTO tbg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","vaiinti taaramonavu vahaaqaini himpite vaura. Mini himpite vauvaro Eparahaamiva vinavuka tavero ˻qaqi qumina vaiintinavuve tivakero˼ kantero oru vinavuka ntitakero vatakanta hiqinti viro nai viri vataini vatero ");
INSERT INTO tbg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","tiharo, Ti vaiintinavuvauvo, kia qaqi aitare vuate. Te ni kaiqa vaiintima vauro. ");
INSERT INTO tbg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kaiqe te tiariraro vovano namari kaqa varero ni aiqu hiqama nimitairaro paru iramanta ne katari okara auraara vaiqe ");
INSERT INTO tbg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","te kara nimiari ne naivaro kempukaiqiramanta nenta aaraini vuate. Nenavu ti vatukaini aniamantama te mintimake ninavu quahama nimitarerave, tiro. Eparahaamiva minti tumanta vinavuka, eo mintiane, ti. ");
INSERT INTO tbg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tuvaro Eparahaamiva kantero naavuqi oriqetero nai naata Seraarara tiharo, Vaaka koqe porusi varakera mpareti untaane, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","kantero oru nai purumakaunavuqihairo purumakau naati koqera vonku varakero nai kaiqa vaiinti amuvaro viva vaaka vira qerama tareva vura. ");
INSERT INTO tbg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ho kara ita vuvaro Eparahaamiva kara vira varakero purumakau naama taapairavata qaqi vau naamaravata varakero vuru vinavuka aaqanto vatora. Vinavuka katari okara mini vauvaro Eparahaamiva naivano vinavuka kara nimumanta nora. ");
INSERT INTO tbg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Vinavuka kara namake Eparahaamira ireha ti, Ai naata Seraava taraqie vaivo? tuvaro Eparahaamiva tiharo, Viva vitira seri naavuqima vaivo, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","vovano tiharo, Ihi varake vohaa qaramake vate aniaina entaraqaa te qaiqaa orurante anirerave. Vi entara ai naatavano Seraava qorainti vainti vatatero vikantiro varianarove, tiro. Minti tuvaro Seraava Eparahaamira naantiaraini seri naavu qentiana himpi vaiharo vi uvara irura. ");
INSERT INTO tbg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Seraaka Eparahaamika konta naampaiqama vutanta vaiha Seraava vainti vataarira entava haaru taiqa vuvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Seraava vi uvara iriro nai araraqihairo naaraihiharo nai irikero tiharo, Te tenta vaatinti konta naampaiqama vuro. Nantiakee te vainti vatake quaheha vairarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Seraava mintimakero nai aatoqi iruvaro Noravano Kotiva Eparahaamira irero tiharo, Nantivaroe Seraava naaraihiharo tiharo, Te kontaiqama vuro. Nantiakee te vainti ho vatararave, tivo? ");
INSERT INTO tbg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Te Noravano Kotika ekaa kaiqa vare vauraukama vauro. Ho te vaaka tunantemake, ihi varake qaiqaa orurante aniariraro vi entaraqaa ai naatavano Seraava qorainti vainti vatatero vikantiro varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Minti tuvaro Seraava qeteharora tiro, viva aqao tiro, Kia te naaraihuro, tuvaro viva tiharo, Quqaama te turo. Are naaraihama iaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Minti tivakero taaramonavu himpi Sodomi vatuka tavareka vuvaro Eparahaamiva vinavuka aarana vuru kareva ntita varero vura. ");
INSERT INTO tbg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Aaraini vi vauvaro Noravano Kotiva tiharo, Te Sodomi vatanaaka autu nimitare iaina okarara kukeqate Eparahaamira kia tiva amiarorave. ");
INSERT INTO tbg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Eparahaamira vaintivara noraiqamavi kempuka vatanaakama vaivarave. Eparahaamiva kuvuarama tainaraqihai te ekaa vataini vaika koqema nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Eparahaamiva nai vaintivaravata ti uva iriqi vuate ti, te vira tenta kaama taunarave. Vira vaintivara avuqavuqamake nivera, te kauqu aiqiqaa aqukeha Eparahaamirara tiva tauna uvara iriha minti minti irerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Minti tivakero Noravano Kotiva Eparahaamirara tiharo, Sodomihainaakavata Gomoraihainaakavata vaaqu aaraqaa ni variavo tiamanta irunarave. Vika vaaqu kaiqavano uritarakero vaira kaara ");
INSERT INTO tbg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","te tenta otu vika tavarerave. Quqaae vika mintiavo, kiae mintiavo, te otu vika tavarera vuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Minti tumanta vaiinti votanta ˻enselitanta˼ vira mini ke Sodomini vi vau aararaqaa vuvaro Noravano Kotiva Eparahaamikantiro mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Viva mini vauvaro Eparahaamiva Noravano vaunaini oruntero vira irero tiharo, Quqaae are vaaqu vaiinti nahenti vehi autu kehara koqe vaiinti nahentivata vika hampata vehi autu kenarave? ");
INSERT INTO tbg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Are tavairamanta mini vaiinti nahenti koqeka 50navu vaivera, are qaqiqai Sodomi vatukaqi variaka ekaa vehi autu kenarave? 50navu qaqi variate tira, are kiae vi vatukara vehakuma amitenarave? ");
INSERT INTO tbg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Are vaiinti nahenti koqeka qora vaiinti nahenti hampata aru kerorave. Kia mintiane. Qora vaiinti nahenti kaara koqe vaiinti nahentivata aru kerorave. Are vataini variakaqaa raqikiharama are avuqavu ko tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Eparahaamiva minti tuvaro Noravano Kotiva tiharo, Te tavaari vaiinti nahenti koqeka 50navu vaivera, te vikara irihama ekaa vi vatanaakavata vehakuma nimitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Noravano minti tuvaro Eparahaamiva tiharo, Oho, Noravauvo, te qumina vaiintivanoma vauro. Te ainti uva tivaqi vuarirava kia ho vaimanta te vo uva tiarirara are kia ti titiane. ");
INSERT INTO tbg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kia anomake koqeka 50navu vaivera, 45navuqai vaivera, are vikara iriharama kiae vi vatanaaka vehi autu kenarave? tiro. Minti tuvaro Noravano Kotiva tiharo, Te tavaari vaiinti nahenti koqeka 45navuqai vaivera, vikara irihama kiama te vi vatanaaka vehi autu karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Minti tuvaro Eparahaamiva qaiqaa tiharo, Vaiinti nahenti koqeka 40navuqai vaivera vo? Are nantie inarave? tuvaro Kotiva tiharo, Vaiinti nahenti koqeka 40navuqai vaivera, vikara iriha kiama te vi vatukara vehi autu karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Minti tuvaro Eparahaamiva tiharo, Noravauvo, kia ai arara itairara are ti titiane. Vaiinti nahenti koqeka 30navuqai vaivera vo? Are nantie inarave? tuvaro Kotiva tiharo, Vaiinti nahenti koqeka 30navuqai vaivera, te kia vi vatukara vehi autu karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Minti tuvaro Eparahaamiva tiharo, Oho, are Noravano variaramanta te qumina vaiintivano ariara ti vauro. Vaiinti nahenti koqeka 20navuqai vaivera vo? Are nantie inarave? tuvaro Noravano tiharo, Te tavaari vaiinti nahenti koqeka 20navuqai vaivera, te kia vi vatukara vehi autu karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Minti tuvaro Eparahaamiva tiharo, Noravauvo, kia ai arara itaarire. Te qaiqaa vohaiqaqai ai ireha tavarerave. Vaiinti nahenti koqeka 10navuqai vaivera vo? Are nantie inarave? tiro. Minti tuvaro Kotiva tiharo, Vaiinti nahenti koqeka 10navuqai vaivera, vikara iriha kiama te vi vatanaaka vehi autu karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Minti tiva taiqa kero Noravano Kotiva Eparahaamira mini kero vuvaro Eparahaamiva tuvurantero nai maaqaini vura. ");
INSERT INTO tbg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Enselitanta otu vuvaro entama vumanta vitanta Sodomi vatukaini otunte tavovaro Rotiva vaantaavura qentiana oquviro vaura. Rotiva mini vaiharo enselitanta tavero ˻qaqi qumina vaiintitantave tivakero˼ himpiro oru vitanta ntitakero uva manteharo nai viri vataini vatero ");
INSERT INTO tbg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","tiharo, Ti vaiintitantao, te nitanta kaiqa vaiintima vauro. Netanta ani ti naavuqi vaitaate. Netanta nenta aiqu hiqamake vaite, hura toqaqi nentatanta vuate, tiro. Rotiva minti tumanta vitanta aqao ti, Tetanta vahaaqaini qaqi qumina vatuka kanta vaitarerave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Minti tuvaro Rotiva kempukaiqama kero tumanta vitanta Rotira naavuqi oriqete vauvaro Rotiva kia noqavu mparetira untakero vitanta nimumanta nora. ");
INSERT INTO tbg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Vitanta kara namake vaitarare tumanta Sodomi vatukaqi vauka hihai hihai naampainavuve, qaraaka vaiintinavuve, aninte Rotira naavu vahaaqaini ututumate vaiha ");
INSERT INTO tbg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Rotirara naverai tiha, Vaaka ania vaiintitanta taraqie variavo? Vitanta vara veva kairaqe vitanta hampata nuare, ti. ");
INSERT INTO tbg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Minti ti vauvaro Rotiva vevantero qenti tintatero tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ti navunaataarito, eqaate. Kia vi kaiqara vaaqu kaiqa varaate. ");
INSERT INTO tbg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ho tavaate. Ti raavuratanta qaraaka varaatatanta variavo. Ne vitanta varema nenta varaataa ina kaiqara varaate. Vaaka aniatanta kia utu varaate. Vi vaiintitanta ti naavuqi ani variamantara ti, te vitantaqaa raqikiariravama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Rotiva minti tumantavata, vika tiha, Are vinuane. Are vo vatanaava maini ani vahuqa variaravave. Kia tinavu ravaaqavuane. Are kia tinavu vaaraqairera, tenavu aivata voqamake qoraiqama amitarerave, ti. Minti tivake vika Rotira venta qaqini ke oru qenti rukavu kareka auti vaumanta ");
INSERT INTO tbg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","vaaka anu vaiintitanta vitanta nái kauqu tutuke Rotira rarau vera naavuqi ke qenti tintate, ");
INSERT INTO tbg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","viraqaahai vitanta aaquakaa voqaara utu kovaro vi vatanaaka avu arukomanta vika nái avuara qumimaqa iha kia ho qenti qantua kora. ");
INSERT INTO tbg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Vi vatanaaka kia ho qenti qantua komanta vaiinti vitanta naavuqi vaiha Rotirara tiha, Ai navunaa vonavu maa vatukaraqi varie iavo? Ai airaamaquve, ai maaquve, ai raavurave, ai navunaakave vaivera, vika vaaka ntita varera maa vatukaraqihaira vuane. ");
INSERT INTO tbg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Tetanta maa vatukara vehi autu taiqa karerave. Maa vatanaaka Noravano Kotiva ti uvara voqamake raqake variavaro vika vaaqu kaiqavano uritarakero vaira kaara Noravano titanta tititaimanta maa vatukara vehi autu taiqa karera tuvuro, ti. ");
INSERT INTO tbg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Minti tuvaro Rotiva vevantero oru nai raavuratanta varare u vaiintitantara tiharo, Noravano Kotiva maa vatukara vehi autu taiqa kareva auti vaivo. Kante maaqihai vonaini vuate, tumanta vira airaamaqutanta Rotira uva kia iriraiti, virara virera uvaqaima ti vaivo tura. ");
INSERT INTO tbg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ho aatitare umanta enselitanta Rotira vihi tiha, Kantera nena naatavata nena raavuratantavata ntita varera vonaini vuane. Maa vatukava vehiqama viramanta nevata taiqa vivorave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Vitanta minti tuvaro Rotiva kia vaaka vitanta uva irireva auti vauvaro Noravano Kotiva Rotirara aaqurihama amitorara ti, vitanta Rotiravata vira naatavata vira raavuratantavata ntitavare vika kauqu utu rarau vare vuru vatuka aaqaini vaati ke. ");
INSERT INTO tbg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Vitanta vika vita vuru aaqaini ke enseli vovano tiharo, Nivata vehi autu kaantorave. Kantema kiama antavi tavamaqi viraiti, kiama vona vona varika varikamaqi vuate. Niaraini vuruni aiqinainima kante vuate. Nevata maini uqitaini vaiha taiqa vivorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Minti tuvaro Rotiva aqao tiro, Nora vaiintitantao, kia minti tiate. ");
INSERT INTO tbg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Netanta ti nenta kaiqa vaiinti koqema timiteha ti vehakuma timitaakama variavo. Oho, te kia ho aiqina vainaini virarave. Te aaraini vi variariraro qora haikavano tivata vehi autu kaantorave. ");
INSERT INTO tbg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ho tavaate. Inaara vatuka vo vutuni vaivo. Netanta ti qaqi kaiqe te ruqemake viraqi oru ho variare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Minti tuvaro enseli vovano tiharo, Hove. Te are tianante irerave. Te kia vi vatukara vehi autu karerave. ");
INSERT INTO tbg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ho kante vuane. Te kia vo haika qovarama karaiti, qaqi variarara are mini oru ntairaqe te maa vatukara vehi autu karerave, tura. Rotiva vi vatukarara inaara vatukave turara ti, vaiinti nahenti vi vatukarara Soaave — Inaara Vatukave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Rotiva vi vauvaro kuari uruntovaro Soaa vatukaini oruntora. ");
INSERT INTO tbg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Viva Soaini oruntovaro vaaka Noravano Kotiva naaruvaihairo iha ito salfara vara kovaro aaqu ntintema kero Sodomi vatukaqaavata Gomora vatukaqaavata vi haikava hiqinti hiqinti i vaura. ");
INSERT INTO tbg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Mintiaqiro viharo vi vatukatanta vehi autukero, vi vatanaakavata vehi autukero, ekaa uqitaini qampiqe vau haikaravata ekaa naaho maatavata vehi autu taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mintiaqiro vi vauvaro Rotira naatavano aaraini viharo kaiqe tuqantaavi tavaare tivakero tuqantaa vuvaro vira vaatavano hore kuquviro katari aratora voqaara mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Vira qararaa Eparahaamiva toqaqi himpiro kantero hoqare Nora Kotira hampata uva tunaini qaiqaa otuntero ");
INSERT INTO tbg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","viavi Sodomi vatukavata Gomora vatukavata tavarare tuvaro uqita vi kantahairo iha muravanoqai uri vaura. Nora iha iteharo muravano auti vaintema kero, vi kantahairo nora muravano uri vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kotiva uqitaini vau vatukara vehi autu kareva iharo Eparahaamirarao tiro, Rotira vehakuma kovaro Rotiva ho ruqema kero vurama. ");
INSERT INTO tbg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Rotiva qeteharo kia ho te Soaini vairarave tivakero, nai raavuratanta ntita varero Soaa mini kero verara oru ori onavuqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Rotiva nai raavuratanta hampata viraqi vauvaro vo enta vira nakaava nai aurara tiharo, Oho, titanta qova naampaiqama vuarirava aumaiqivo. Tetanta varaarira qoraintika kia maa vataraqaa variamanta nantiakee tetanta ho vainti vatararave? ");
INSERT INTO tbg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kaiqetanta uaini tentatanta qora amiariraro nama kairaro vira avu aatovano hampi qiraqe tetanta vira hampata vaiteha vainti taiqama vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Minti tivake entaqi vitanta uaini nai qora amuvaro ˻vueraiqama vuvaro˼, vira nakaava naane nai qokantiro vaitovaro vira qova kia virara kankomakero irura. ");
INSERT INTO tbg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mintuvaro vira qararaa vira nakaava nai aurara tiharo, Te enta entaqi vikanti vaitauro. Kaiqetanta qaiqaa uaini amiariraro nama kairaro vira avu aatovano hampi qirara arevata vikantira vaitaane. Tetanta mintiaqi vuariraro titanta qova titanta vainti taiqama kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Minti tivake entaqi vitanta qaiqaa uaini nai qora amuvaro nama kovaro avu aato hampi quvaro vira auravano vikantiro vaitovaro vira qova kia virara kankomakero irura. ");
INSERT INTO tbg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Vira raavuratanta mintima kovaro Rotiva vitanta vainti taiqama kora. ");
INSERT INTO tbg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Vira nakaava vainti taiqama viro vuru qorainti vainti vatatero virara Moapirave tura. Vi vaintiva noruqama viro ekaa Moapi vatanaaka qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Vira auravanovata vainti taiqama viro qorainti vainti vatatero virara Ben-Amirave tura. Vi vaintiva noruqama viro Amoni vatanaaka qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Eparahaamiva Mamarera Oqiva vauraqi variro, viraqaahairo katu varero vevara vo vataini vura. Kadesi vatuka hini vauvaro Suri aahara vata hini vauvaro Eparahaamiva avutana otu vaura. Viva mini varikero viraqaahairo Geraa maaqaini oru vaura. Viva mini oru vaiharo ");
INSERT INTO tbg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","nai naatara, Viva ti aurave, tuvarora tiro, King Abimelekiva, Geraa vatukaqaa raqikuva Seraarara tiharo, Vira vita vare ti naavuqi vuru kaate, tumanta vita vuru kovaro ");
INSERT INTO tbg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","vo enta Abimelekiva entaqi vaiteharo taira tave vauvaro Kotiva virara tiharo, Are vi nahentira vara taanara kaara qutuma vinarave. Vi nahentira vora naatama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Minti tuvaro Abimelekiva kia Seraakantiro nuvara tiro, viva Kotirara aqao tiro, Noravauvo, kia te virara irunarave. Are qumina tivata, ti navunaakavata, vehi autu taiqa kerorave. ");
INSERT INTO tbg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Eparahaamiva naivano vi nahentirara tiharo vira ti aurave tivaro vi nahentiva naivata tiharo, Viva ti vakaavave tirave. Vitanta minti tiaverama te kia qora kaiqa vararaiti, virara qaqi nahentive tima, vira vita vare tenta naavuqi vuru kaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Minti tuvaro Kotiva tiharo, Ho te irurarama are virara qaqi nahentive tivakera, vira vita varera nena naavuqi vuru kaanarave. Ariara ti uva raqa kerorave ti, te ai ravaaqavu kaurarama are kia vira varera iaro. ");
INSERT INTO tbg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ho nai naata qaiqaa nai amiane. Vi vaiintiva ti uva tiva nimi vai vaiintivama vaivo. Viva ti haarairaqe te ai vehakuma amitaarirara are kia qutu viraitira, qaqi vainarave. Are kia vira naata nai qaiqaa amirera, vira kaara are nena navunaaka hampata qutu taiqama vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Minti tuvaro vira qararaa Abimelekiva vaaka toqaqi himpiro nai qiata vaiinti naarama kero, vi uvara tiva nimumanta vika voqamake naatu itomanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Mintuvaro Abimelekiva Eparahaamira aarama kero virara tiharo, Are nantivarae tinavu mintima timitaaro? Tenavu nana qora kaiqa vara amitaurarae are virara irihara mintima kera tinavu qoraiqama timitaararo Kotiva tinavuqaa nora uva vataivo? Are nena naatara kia minti tiataara vaivarama minti tiaro. ");
INSERT INTO tbg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Are nana kaarae mintira iaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Minti tuvaro Eparahaamiva nai tiva amiro tiharo, Oho, te mintimake irunarave. Maa vatanaaka kia Kotirara iriaka vika ti naata varareka iha ti harukevorave ti, te virara iriha ti aurave tunarave. ");
INSERT INTO tbg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ho ti naatavano quqaama ti auravano vaivo. Viva ti qora raavuravano vaiharo viva kia ti nora raavura tanava vaimanta te vira vara tauraroma viva ti naataiqama vivo. ");
INSERT INTO tbg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kotiva ti qora maaqaihairo ti tititaimanta te vo vatanaaka vataini vi aniha te tenta naatara mintima ti, Are ti kahaqiharama vo vaiinti vo vaiinti tiva nimihara tiriara ti vakaavavema tiane tunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Minti tuvaro Abimelekiva Seraara Eparahaamira nai amiro viraqaahairo sipisipivata, purumakauvata, kaiqa vaiintivata kaiqa nahentivata amiro ");
INSERT INTO tbg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","virara tiharo, Ti vataqaima vutuni vuruni ai avuni vaivo. Are maini ta vataraqaa variataa irera, viraqaa oru variane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Minti tivakero viva Seraarara tiharo, Te ai vakaara silvaa monu 1,000 amiariraro vi uvava taiqaarire. Virara irihama ekaa vaiinti nahenti ariara viva kia qora kaiqa varaivo tivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Minti tuvaro Eparahaamiva Abimelekirara iriharo Kotira aarama amitovaro Kotiva Abimelekiravata, vira naatavata, vira kaiqa nahentivata, koqema nimitomanta vinavuka ho qaiqaa vainti vatora. ");
INSERT INTO tbg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Tota Eparahaamira naata Seraara kaara Noravano Kotiva ekaa vi nahentika kia vainti vataate tiro, kuvaikomanta vika naahiaravi/qururaiqamavi vaiha kia vainti vatora. ");
INSERT INTO tbg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Noravano Kotiva Seraarara viva vainti vataanarove turara tiro, viva Seraara koqema amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Seraava vainti taiqama viro vuru Eparahaamira qorainti vainti vata amitora. Eparahaamiva naampaiqama vu entara vi vaintira vatatora. Kotiva kaamato entaraqaa Seraava vi vaintira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Vatatovaro Eparahaamiva nai maaqu vira autu ntavateharo Aisaakirave – Naaraihirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Minti tuvaro Aisaakiva 8 enta varakovaro Eparahaamiva Kotiva tunte iro vira vaata toqa amitora. ");
INSERT INTO tbg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aisaakira vatato entara Eparahaamiva 100 ihi varakova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Seraava vainti vatatero tiharo, Kotiva ti koqema timitaimantara ti, te vainti vatate quaheha naaraihihama vauro. Vaiinti nahenti ti vaintiara irihama vikavata virara quaheha naaraihivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Minti tivakero viva tiharo, Ike, tavave tota Eparahaamirara tiharo, Ai naatavano vainti naama amiaina nahentivama varianarove, tirave? Ho tavaate. Eparahaamiva naampaiqama vimanta te vira vainti vata amitauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Minti tuvaro vainti viva noruqama viro naama qaqirako entaraqaa Eparahaamiva nai navunaaka hampata vainti vira quahama amiteharo nora kara nora. ");
INSERT INTO tbg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ho vo enta Isipihainaa nahenti Hagaava Eparahaamira vata amito vaintiva, Isamairiva Seraara maaqu Aisaakira vataakero ruheharo vira memera ti vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Seraava vitanta tavero oru Eparahaamirara tiharo, Aqao, are kaiqa nahenti vira atitairaro viva nai maaquntiro vuarire. Vi nahentira maaquvano ti maaqu hampata vaiharo naantiara ai airaira hini varaantorave. Ekaa vi haikava Aisaakirainima naantiara varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Isamairivavata Eparahaamira maaqu vaurara tiro, Seraava minti tura kaara Eparahaamira muntukavano qoraiquvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mintima vauvaro Kotiva Eparahaamirara tiharo, Kia vitanta nokara ai muntukavano qoraiqirara variane. Te tota tenta kauqu aiqiqaa aqukeha ariara tiha, Ai maaqu Aisaakiraqaahai ai vaintivara airitahaa qovarama vivarave tunarara tira, are Seraava tintema kera vira atitaane. ");
INSERT INTO tbg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ai kaiqa nahenti vira maaquvata ai maaqu vaimantara ti, te vira vaintivaravata airiqama kaari vikavata nora vatanaakama vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kotiva minti tuvaro vira qararaa Eparahaamiva vaaka toqaqi himpiro karavata namari taquvata Hagaara amiro vira atitovaro Hagaava nai maaquntiro vura. Viva nai maaquntiro oru viviro, aahara vata, Besebaini oru mini vaiharo vi ani vaura. ");
INSERT INTO tbg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mini vi aniharo namari nama taiqa kovaro Hagaava nai maaqu katari okara aumaqaaraini kero ");
INSERT INTO tbg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","tiharo, Mpo, ti maaquvano qutu vuainara kia tavaataa ivo tivakero, vutuntoqamakero oru oquviro vaiharo iqi rateharo vairo. ");
INSERT INTO tbg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ho Kotiva vira maaquvano iqi rate vaura iruvaro Kotiva atito enseliva naaruvaihairo Hagaarara naverai tiro tiharo, Hagaao, nana kaarae ai muntukavano qoraiqivara variaro? Kia qetaane. Kotiva ai maaquvano iqi ratai uvara irivo. ");
INSERT INTO tbg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ho oru nena maaqu ravuku varaane. Naantiara te vira vaintivaraqaahai nora vatanaakama qovarama kararave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Enseli viva minti tuvaro Kotiva Hagaara avu qantua kovaro Hagaava viti tavovaro vata quvitoraqi namarivano vauvaro viva namari taqu varero oru namari kaqa varero viri nai maaqu amuvaro nora. ");
INSERT INTO tbg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kotiva vira maaqu koqema amitovaro viva noruqama viro aahara vata, Paraanini variqiro viharo kempuka vaiintivano vaiharo koqema kero huru ari vau vaiintiva vaura. ");
INSERT INTO tbg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mini vauvaro vira nova Isipi vatanaa nahenti vo vira vara amuvaro Isamairiva vira varatero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Vi entara Abimelekiva nai iqoka vaiintiqaa raqiki vaura Pikorikantiro Eparahaamiva vaunaini oruntero tiharo, Te tavauraro Kotiva ai kahaqi vaivara are vo kaiqa vo kaiqa vare varianarave. ");
INSERT INTO tbg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ho Kotira avuqaa vaihara nena kauqu aiqiqaa aqukeharama tiriaravata, ti vaintiaravata, ti naintiaravata, tihara, Kia te vika una tiva nimitarerave, tiane. Te tota kia ai qoraiqama amitaraiti, ai koqema amitaunarave. Are vo vatanaava maini maa vataraqaa vaiharama tivata, ti navunaakavata, kia qoraiqama timitaraitira, tinavu koqema timitaqira vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abimelekiva minti tuvaro Eparahaamiva nai kauqu aiqiqaa aqukero tiharo, Quqaama te mintirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Minti tivakero Eparahaamiva tiharo, Ho te tiarirara iriane. Ai kaiqa vaiinti vonavu aninte tenavu namari kaqarera quvitaunaraqaa tinavu kuvaike variarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Minti tuvaro Abimelekiva tiharo, Oho, kia te virara irunarave. Nai taukae mintiavo? Are vaaka vi uvara ti tiva timiataarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Minti tuvaro Eparahaamiva nai sipisipivata purumakauvata rairakero vonavu vuru Abimelekira amiro, viraqaahai vitanta vohaa vaiha uva tiva taatau tora. ");
INSERT INTO tbg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Eparahaamiva sipisipi naati nahe 7navu rairakero voqaa vatovaro ");
INSERT INTO tbg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelekiva Eparahaamira irero tiharo, Are nantivarae 7 vinavuka voqaa vataaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Minti tuvaro Eparahaamiva tiharo, Are sipisipi maanavura varerama, te namari kaqarera quvitaunarara tihara, Quqaama Eparahaamiva vira quvitairave, tiane. Are minti tiraro vi uvava taiqaarire, tura. ");
INSERT INTO tbg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Vitanta mini vaiha vohaa uva tiva taatauke vatorara ti, vaiinti nahenti vi namarira kaqe vaura autu nteha, Beseba Namarive – Kauqu Aiqiqaa Aqukeha Tivato Namarivave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ho viraqaahairo Abimelekiva nai iqoka vaiintiqaa raqiki vaura Pikorikantiro anirantero Pirisia vataini vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Eparahaamiva Besebaini vaiharo airi ihi variqiro vi vai katarira ututero, viraqaahairo Nora Kotira aarero tiharo, Kotiva ekaa enta qaqi variqiro vi vaivama vaivo, tura. ");
INSERT INTO tbg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eparahaamiva Pirisia vataini vukaiqama kero variqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Vo enta Kotiva Eparahaamira avatareva iharo virara tiharo, Eparahaamio, tuvaro Eparahaamiva tiharo, Te mainima vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Minti tuvaro Kotiva tiharo, Nena maaqu vohaiqa ai voqama kero muntuka vainara, Aisaakira, vira vita varera Moraia vataini vuane. Mini oruntairaqe te aiqina vo ai umiqaarirara are nena vainti vita varera viraqaa vaarirera mini vaihara, ekaara kaintu iha quarake ofaara timitentema kera, nena maaqu mintima timitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Minti tuvaro vira qararaa Eparahaamiva vaaka toqaqi himpiro ekaara kaintu iha quarake ofaarara iriharo iha teqakero nai donki tauvaqaqaa vaari vatero viraqaa rumpatero nai kaiqa vaiintitanta ntita varero nai maaqu Aisaakiravata vita varero Kotiva tunaini vireva vura. ");
INSERT INTO tbg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Vinavuka aaraini vivi, taaramo enta varake Eparahaamiva vuru tavovaro vuruni vi aiqinava vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Eparahaamiva nai kaiqa vaiintitantara tiharo, Netanta maini vaiha donkiqaa raqiki vaiqe te tenta maaqunti vururaqaa oru vaiha Kotira quahama amite, tetanta orurante tuvirerave, ");
INSERT INTO tbg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","tivakero Eparahaamiva ofaa iha nai maaqu aqu amitero ihativata qehaivata/muhupavata nai varero, náitanta qoka aiqinaqaa virekatanta vurama. ");
INSERT INTO tbg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisaakiva aaraini viharo nai qora irero tiharo, Qaao, tuvaro viva tiharo, Ho tiraqe iriare, tuvaro Aisaakiva vira irero, Tetanta ihavata ihativata vare uri vauro. Sipisipi naati Kotira ofaa iha quara amitaainara tantoe vaivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Minti tuvaro Eparahaamiva nai maaquara tiharo, Kotiva naivanoma sipisipi naati timianarove, tiro. Minti tivaketanta qoka oru vi oruntora. ");
INSERT INTO tbg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Vitanta Kotiva tunaini orunte Eparahaamiva ori varakero ofaa tainta autukero viraqaata iha raukutero nai maaqu rumpakero viraqaa vatero ");
INSERT INTO tbg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","qehai/muhupa vare vura varakero viraqohairo nai maaqu arukaare tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","naaruvaihairo Noravano Kotiva atito enseliva aarero tiharo, Eparahaamio, Eparahaamio, tuvaro viva tiharo, Te mainima vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Minti tuvaro enseli viva tiharo, Kia nena vainti aruane. Kia vira qoraiqama amitaane. Te tavaurara are nena maaqu kia qaqi tuataraitira, Kotira amireva auti varianarara ti, te ariara Kotira uva iri vai vaiintivave turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Enseli viva minti tuvaro Eparahaamiva vuruvi tavovaro sipisipi qoravano nai komu katari kaaraqi rutaqutero vauvaro viva oru vira qaqini varakero kia nai maaqu arukero Kotira ofaa iha quara amitaraitiro, sipisipi vira arukero Kotira ekaara kaintu iha quara amitovaro sipisipivano Aisaakira vatuka varovaro Aisaakiva qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Eparahaamiva vi vatara autu nteharo, Noravano Kotiva Naima Timi Vaivama Vaivo, tura. Eparahaamiva vi uvara turara ti, maa entara vaiinti nahenti tiha, Noravano Kotiva nai aiqinaqaa vaiharo tinavu timi vaivama vaivo, ti variara. ");
INSERT INTO tbg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Eparahaamiva minti tuvaro Noravano Kotiva atito enseliva qaiqaa naaruvaihairo Eparahaamirara naveraitiharo, ");
INSERT INTO tbg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Te tenta hutuqaa tiha, Tota te ai avateha tavarera ariara nena maaqu vohaiqa ti timiane turara are kia nena maaqu qaqi tuataraitira, ti timireva auti varianarara ti, ");
INSERT INTO tbg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","te ai koqema amitaari ai vaintivara opu makau voqaara airitahaa vaivarave. Vika nora namari auvahini vaina nuqara voqaara airitahaa vaivarave. Ai vaintivara mpeqa vaiha nai navutaaka naatarake vika vatuka vo vatuka vo vatuka varevarave. ");
INSERT INTO tbg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Are ti uva irianarara tiro, are kuvuarama terava vovano ekaa vo vatanaa vo vatanaaka koqema nimitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Minti tuvaro Eparahaamiva ˻nai maaquntiro˼ ururantero nai kaiqa vaiintitanta konaini otuntero oti vitantavata ntitake qaiqaa anirante Besebaini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Eparahaamiva mini vauvaro vovano anintero vira tiva amiro tiharo, Ai qata Nahora naata Mikaava qorainti vainti maantuma vatataivo: ");
INSERT INTO tbg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","22","Hoqare Usira vatatero, viraqaahairo Busirave, Kemuerirave, Kesetirave, Hasorave, Piladaasirave, Jitilapirave, Betuelirave, vinavukama vatataivo. Vira vaintinavuqihairo Kemueriva noruqama viro qorainti vainti vo Araamira vatataivo. ");
INSERT INTO tbg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueliva noruqama viro nahenti vainti Rebekaara vatataivo. Nehora naatavano vi vaintinavuka 8navu vatataivaro ");
INSERT INTO tbg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","vira qiariva Reumava qorainti vainti Tepaarave, Gahamurave, Tahasirave, Makaarave, vinavukama vatataivo, tuvaro Eparahaamiva irura. ");
INSERT INTO tbg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Seraava airi ihi 127 ihi varakero Hebaroni vatuka Kenaani vataini vaiharo qutu vuvaro Eparahaamiva oru viva qutu vunaini vaiharo virara iqi rata amitora. ");
INSERT INTO tbg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Eparahaamiva nai naata vaata qaqi mini kero oru Hiti vatanaakara tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Te vo vatanaa vaiintivano maa vataraqaa ni hampata ani vauro. Ne vata vo ti timiqe te ni koqaa nimi, vi vataraqaa te tenta naata vuru quntama taare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Eparahaamiva minti tumanta Hiti vatanaaka vira nai tiva ami tiha, ");
INSERT INTO tbg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Nora vaiintio, are tinavu hampata vaihara kempuka vaiinti noravano varianarave. Tenavu tentanavu vaiinti nahenti qutuaka qunte vaunara koqeraqi are homa nena naata viraqi quntama tenarave. Kiama tinavuqihairo vovano aqao tianarove. Tenavu ekaa hoveqaima tirarave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Vika minti tuvaro Eparahaamiva himpiro nai qiata vataini kero Hiti vatanaakara koqema iavo tivakero ");
INSERT INTO tbg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","tiharo, Ne tiriara homa nena naata maa vataraqaa quntenarave tiavera te tiari iriate. Sohaara maaqu Efaroniva vata vo vataivaro vira auvahini ori onavu vo vira autu Makapera ori onavuve tia vatava vaivo. Ne tiriara irihama ne hoe Efaronira iraivaro viva vi vatara ti timiraqe te tenta navunaaka qutivaqe viraqi quntaare? Te vi vatara koqaa nora monu Efaronira amirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eparahaamiva minti tuvaro Hiti vatanaa vaiinti Efaroniva nai navunaaka hampata vatuka qentiana oquvi vaumanta vira navunaaka vira aaqanto vaiha vira uva iri vauvaro viva Eparahaamirara tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nora vaiintio, kiama vi vatarara koqaa timinarave. Vi vataravata vi vataraqi vai onavuravata te ai qaqi amirerave. Te tenta navunaaka nivuqaa vaihama vi vatara ai amuro. Homa nena naata viraqi quntenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Efaroniva minti tuvaro Eparahaamiva qaiqaa nai qiata vataini kero ");
INSERT INTO tbg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ekaa vaiinti nahenti ruvaaquma vuka vira uva iriate tiro viva Efaronirara tiharo, Ho ti uva iri vairaqe tiare. Te vata koqaa ai amiarirara are varairaqe te tenta naata vare vuru viraqi quntaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Minti tuvaro Efaroniva Eparahaamirara tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ho kaiqe te ai tiva amiare. Vi vatara koqaa vaireva, 400 silvaa monuma vaivo. Arevata tevata vi koqaarara kia nora koqaave tirarave. Homa vi vatara varera nena naata viraqi quntaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Efaroniva minti tuvaro Eparahaamiva hove tivakero vi silvaa monu sikeriqaa hirikero avuqavu rairakero Efaroniva kaamato koqaara vaiinti nahenti nivuqaa vaiharo vi koqaara Efaronira amura. ");
INSERT INTO tbg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mintima kero Eparahaamiva Efaronira vata Makapera vata varora. Vi vatava Mamarera Oqiva vaura vutu mantaraini vaura. Vatave ori onavuve vi vataraqaa vau katarirave Eparahaamiva varomanta ");
INSERT INTO tbg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","vi entaraqaa Hiti vatanaaka ruvaaqumavi vaiha vi vatarara Eparahaamira vatave tura. ");
INSERT INTO tbg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Eparahaamiva vi vatara varero viraqaahairo nai naata Seraara vaata varero vuru Makapera onavuqira Kenaani vataini quntama tora. ");
INSERT INTO tbg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mintimake Hiti vatanaaka vatavata onavuvata Eparahaamira amuvaro viva viraqi nai naata quntama tora. ");
INSERT INTO tbg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Eparahaamiva airi ihi varakero naampaiqama vuva vauvaro Noravano Kotiva vira koqema amitovarora tiro, ekaa Eparahaamira kaiqavano ho vaura. ");
INSERT INTO tbg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Ho Eparahaamiva nai kaiqa vaiinti avuniqamake vaura vira aarora. Vi vaiintiva naampaiqama vuva ekaa Eparahaamira kaiqaqaa raqiki vauva vauvaro Eparahaamiva vira aarama kero tiharo, Noravano Kotiva naaruvaqaavata vataqaavata raqiki vaira avuqaa vaiharama are ti uva iriharama nena kauqu ti aiquqaa vatehara te mintirerave tiane. Ti maaqu nahenti vara amire iharama, kia maa vatanaa nahenti, Kenaani nahenti vira vara amiane. ");
INSERT INTO tbg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Oru tinta maaqaihaira ti navunaa nahenti vo varera viri ti maaqu Aisaakira amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Eparahaamiva minti tuvaro vira kaiqa vaiintivano vira irero tiharo, Vi nahentiva kia aniataa iraro viva kia tintiro maini anirera, te hoe ai maaqu nai vita vare ai navunaaka inaini vuru kararave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","7","Minti tuvaro Eparahaamiva aqao tiro, Noravano Kotiva naaruvaini vai Variqava, viva tota vi vataraqaahairo ti tititaimanta maini anuraukave. Viva nai kauqu aiqiqaa aqukero tiharo, Maa vatara ai vaintivara nimirerave, turave. Minti turara tira, are kia ho ti maaqu mini vite vinarave. Are nena viraro Kotira enseli vovano ai avuni viharoma viva ai kahaqirara are homa vihaira ti maaquara irihara nahenti vo vita varera aninarave. ");
INSERT INTO tbg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Vi nahentiva kia aintiro maini aniataa irera, kiama te vate tuna uvava ai ravaaqavu kaanarove. Vi nahentiva kia maini aniataa irera, are kiama ho ti maaqu mini vite vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Eparahaamiva minti tuvaro vira kaiqa vaiintivano nai kauqu aiqiqaa aqukero tiharo, Te are tinantemake mintirerave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Eparahaamiva koqaa airaira nai kaiqa vaiinti amuvaro viva kameri kauqurutantaqaa koqaa airaira rumpa varero viro, Nehora vatuka Mesopotemia vatainiara oru vura. ");
INSERT INTO tbg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Vira kaiqa vaiintivano viviro, vi vatukara aaqaini oruntovaro erovaro viva otu namari kaqe vaura tataaqa vaiharo nai kamerinavu vara vataini vaitakero vauvaro nahenti namari tuvu kaqeva aumaiquvaro ");
INSERT INTO tbg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","viva Kotira aarero tiharo, Noravauvo, are ti nora vaiinti Eparahaamira Variqavanoma variaro. Ta nahentirae te Aisaakira vara amirarave? Are Eparahaamirara quaheharama Aisaakira amina nahentira ti humiqaane. ");
INSERT INTO tbg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Te maini nahenti namari kaqe varianainima vauro. ");
INSERT INTO tbg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nahenti vovano namari kaqareva aniraqe te virara namari kaqa timiraqe naare tiariraro viva ti timiharo ti kamerivata kaqa nimirera, ho te virara are Aisaakira kaama amitaana nahentirave tirarave. Nahenti vovano mintirera, te ariara quqaama are ti nora vaiinti Eparahaamirara quaheharama variaro tirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Viva mintima kero Kotira aare vauvaro nahenti vo, vira autu Rebekaava namari kaqareva taqu aqu varero tuvuntora. Vi nahentiva Betuelira raavuravano vauvaro Betueliva Nehoravata, vira naata Mikaaravata, vitanta maaquvano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebekaava koqe viri vaata vataa varaatavano tuvuntero, tuvu namari kaqa varero tuvurante vuare tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Eparahaamira kaiqa vaiintivano kantero oru vira vitakero virara tiharo, Are hoe nena taquqihaira namari tivata timiraqe naare? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Minti tuvaro nahenti viva tiharo, Nora vaiintio, homa nenarave, tivakero vaaka namari taqu vara vataini viavi tuata amite vauvaro Eparahaamira kaiqa vaiintivano namari vira nora. ");
INSERT INTO tbg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Viva namari ho novaro nahenti viva tiharo, Kairaqe namari qaiqaa otu kaqa vare vuru ai kamerinavuvata nimiari naate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Minti tivakero viva vaaka nai namari taqu kaqatora vira kamerivano ne vau tanuraqi qihiakero qaiqaa kantero otu namari kaqa varero vuru vira kamerinavu ekaa nimumanta ho nora. ");
INSERT INTO tbg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nimumanta ne vauvaro Eparahaamira kaiqa vaiintivano kia uvavata tiraitiro, qaqi vira aituti vaiharo tiharo, Maa nahentirae Noravano Kotiva Aisaakira amianarove? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Aituti vauvaro nahenti viva kamerinavu namari nimi taiqa kovaro Eparahaamira kaiqa vaiintivano nora monu aquke vau haikara, aiqiana ukute ringira koriqohai aututoravata, koriqohai aututora naahuhura taaraqantavata, urequkero vira amiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mintima kero amiro nahenti vira irero tiharo, Ai qora tarave? Te tenta kaiqa vaiintinavu vatamake hoe ai qora naavuqi oru vaitararave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Minti tuvaro nahenti viva tiharo, Ti qova Betuelivave. Viva Nehoka Mikaaka maaquvano vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ai kamerinavu kara neva ho vaivaro nenavu vaitevavata homa ti qora naavuqi vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nahenti viva minti tuvaro Eparahaamira kaiqa vaiintivano nai viri vataini vatero Nora Kotira autu tuahera keharo tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Noravano Kotiva ti nora vaiinti Eparahaamira Variqavanoma vaivo. Viva nai kauqu aiqiqaa aqukeharo tivatai uvara kia tauru karaitiro, viva vaaka Eparahaamira navunaaka ti humiqairara ti, te vira autu tuahera kauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Eparahaamira kaiqa vaiintivano minti tuvaro vi varaatava kantero nai nora naavuqi oruntero ekaa vi haikara qovaraiqura nai nora tiva amura. ");
INSERT INTO tbg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebekaava nai nora tiva ami vauvaro vira vakaava Labaaniva tavovaro vira aura aiqiana ringi ukutova vauvaro vira kauquqi naahuhura nonkutoravata tavero Rebekaava vi vaiintirara nai nora tiva ami vau uvaravata iriro, viva kantero ruvu namari kaqe vaunaini vi vaiintira tavareva viro, tavovaro vi vaiintiva nai kamerinavu tataaqa mini himpitero vauvaro viva virara tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ti vaiintio, Noravano Kotiva ai koqema amitaivarama aniaro. Varaiqetanta naavuni vuare. Te ainivata ai kaiqa vaiintinavuaravata naavu qerama vate, ai kameriaravata qerama vatauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Minti tuvaro Eparahaamira kaiqa vaiintivano vikantiro naavuni vumanta kamerivano airaira vare anu haikara vara qaqini ke kara nimuvaro, Labaaniva namari kaqa varero Eparahaamira kaiqa vaiintiara tiharo, Are nena kaiqa vaiintinavu vatamake aiqu hiqama kaivaro paru iarire, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","karavata vira aaqanto vatero, Ho naate, tiro. Minti tuvaro Eparahaamira kaiqa vaiintivano aqao tiro, Kaiqe te tenta vakaaka naane ai tiva ami, viraqaahai kara naare, tuvaro Labaaniva tiharo, Ho tiraqe iriare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Minti tuvaro viva tiharo, Te Eparahaamira kaiqa vaiintima vauro. ");
INSERT INTO tbg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Noravano Kotiva ti nora vaiinti koqema amitaivarora tiro, viva vo airaira vo airaira airi airaira vataivama vaivo. Sipisipive, purumakauve, silvaa orive, kori orive, kaiqa vaiintive, kaiqa nahentive, kamerive, donkive, Kotiva ekaa vi haikara vi haikara amivaro vatairave. ");
INSERT INTO tbg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ti nora vaiinti naatavano, Seraava kontaiqama viro qorainti vainti vata amitaivaro vi vaintiva noruqama viro vaivo. Ho vira maaqu viva ekaa Eparahaamiva iaina haikara varaariravama vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mintima vaivarora tiro, ti nora vaiintivano tiriara tiharo, Nena kauqu aiqiqaa aqukeharama tihara, Te ai uva avatarerave, tiane. Te Kenaani vatanaaka vatainima vauro. Kia Kenaani vatanaakaqihaira ti maaqu nahenti vara amiane. ");
INSERT INTO tbg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Are oru tinta qora maaqaihaira ti maaqu nahenti vara viri amiane, tirave. ");
INSERT INTO tbg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ti nora vaiintivano minti timanta te vira ireha tiha, Ai navunaa nahentivano kia maini aniataa iraro kia tintiro maini anirera, te nantie irarave? turaro ");
INSERT INTO tbg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","viva tinta tiva timiro tiharo, Noravano Kotiva vaimanta te vira avuqaa ni vauraukave. Vivama nai enseli vo atitairaro viva ai kahaqi vairara are homa ti navunaaka maaqaihaira nahenti vo ti maaqu vara viri aminarave. ");
INSERT INTO tbg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Are ti navunaaka varianaini viramanta vika nahenti ai amiverave kia amiverave, te vate tura uvava kiama ho ai ravaaqavu kaanarove, tirave. ");
INSERT INTO tbg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Minti timanta te vira mini kema maini ani ruvu namari kaqe varianaini vaiha te Kotira aareha mintima ti, Noravauvo, are ti nora vaiinti Eparahaamira Variqavano variaro. Ta nahentirae te Aisaakirara varaainarave? Are Eparahaamirara quahairera, Aisaakira amina nahentira ti humiqaane. ");
INSERT INTO tbg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Te maini nahenti namari kaqe varianaini ani vauro. Varaata vovano namari kaqareva aniraqe te virara namari kaqa timiraqe naare tiariraro ");
INSERT INTO tbg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","viva ti timiharo ti kamerivata namari nimirera, ho te vi nahentirara are Aisaakira kaama amitaana nahentirave tirarave. Nahenti vovano mintirera, te ariara quqaama are ti nora vaiinti Eparahaamirara quaheharama variaro tirarave, tunarave. ");
INSERT INTO tbg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Te mintimake Kotira aareha vi uvara kia taiqa kauraro Rebekaava nai namari taqu aqu varero ruvu namariqi otu kaqa varero urimanta te virara namari timiraqe naare turaro ");
INSERT INTO tbg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","viva vaaka nai taqu vataini viavi kero tiriara ho naane tivakero ti kamerinavuvata namari kaqa nimitarerave timanta te namari nama kauraro viva ti kamerinavuvata namari kaqa nimimanta naarave. ");
INSERT INTO tbg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Viva mintimanta te vira ireha tiha, Ai qora tarave? turaro viva tiharo, Ti qora autu Betuelirave. Viva Nehoka Mikaaka maaquvano vaivo, timanta te viraqaahai vira aiqiana ringi uku amite kauquqi naahuhura nonku amite, ");
INSERT INTO tbg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","te tenta viri vataini ke Nora Kotira autu tuaherake tiha, Noravauvo, are ti nora vaiinti Eparahaamira Variqavano variaro. Are avuqavu aara ti humiqaaramanta te tenta nora vaiinti qata nainti rantake vira maaqu homa nahenti vara amirarave, tunarave. Te mintimake Kotirara tunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Minti tivakero viva Labaanirara tiharo, Ho ne nantie ivarave? Ne ti nora vaiintiara quaheha vira quqaa kahaqama amitareka ivera, ti tiva timiqe iriare. Ne vi varaatara kia timiataa ivera, vutuke ti tiva timiqe te tenta varare iaina okarara ho iriare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Minti tumanta Labaanika Betuelika nai tiva ami tiha, Noravano Kotiva ai kahaqama amitairara ti, tetanta vo uva ai tiva amitaarorave. ");
INSERT INTO tbg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ho tavaane. Rebekaava maa vairove. Ho vira vita varera vuane. Noravano Kotiva ai umiqaintema kero, viva homa ai nora vaiinti vira maaqu naatavano varianarove, ti. ");
INSERT INTO tbg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Vitanta minti tuvaro Eparahaamira kaiqa vaiintivano vitanta uva iriro nai viri vataini kero Nora Kotira autu tuaherakero ");
INSERT INTO tbg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","vo airaira vo airaira utavaaqave, kori orive, silvaa orive, viraqohai aututo haikara hankaarorove/kukukakaarave urequkero Rebekaara amiro, viraqaahairo nora monu aquko haikaravata, vira vakaaravata vira noravata nimiro, ");
INSERT INTO tbg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","viraqaahairo viva nai kaiqa vaiintiaravata karavata namarivata namake viraqi vaitora. Vira qararaa Eparahaamira kaiqa vaiintivano tiharo, Ho ti tititaiqe tenta nora vaiintivano vainaini vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Minti tumanta vira vakaava nai nokantiro aqao ti, Kairaro vi varaatava tinavu hampata vohaa uikie taara uikie vari kairara are vitakera vuane, ti. ");
INSERT INTO tbg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Vitanta minti tuvaro viva aqao tiro, Kia ti ravaaqavu kaate. Noravano Kotiva ti kahaqimantara ti, te vaaka virerave. Netanta ti tititaiqe te tenta nora vaiintivano vainaini vaaka vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Minti tumanta vitanta tiha, Kairaqe tetanta vi varaatara aaramake nai vira ireha tavaare, ");
INSERT INTO tbg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","tivake Rebekaara aaramake vira ireha tiha, Vate are hoe maakantira vinarave? tuvaro viva tiharo, Eo, te vate vikanti virerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Minti tuvaro vitanta vi varaataravata viraqaa raqiku nahentiravata nititomanta vitanta Eparahaamira kaiqa vaiintivata vira kaiqa vaiintinavuvata hampata vurama. ");
INSERT INTO tbg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Vitanta Rebekaara atitehama mintima ti: Tinavu aurao, kairamanta ai vaintivara airiqama vi variqi viha, vika voqavata airiqama vi variate. Kairamanta ai vaintivara vika nái navutaaka naatarake vika vatuka vo vatuka vo vatuka varaate, ti. ");
INSERT INTO tbg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Minti tumanta Rebekaava nai qaraaka kaiqa nahentinavu vataakero qerama varero, kameriqaa vaarinte viraqaahai Eparahaamira kaiqa vaiinti hampata vura. Mintima kero Eparahaamira kaiqa vaiintivano Rebekaara vitakero vurama. ");
INSERT INTO tbg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisaakiva Be-Lahai-Roi namari kaqe vaura mini kero Nekevi vataini oru vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","erovaro aara nireva viharo vutu tavomanta kamerinavu ani vaura. ");
INSERT INTO tbg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekaava vivavata ani vaiharo vutu tavovaro Aisaakiva vutuni ani vauvaro viraqaahairo Rebekaava kameriqaahairo vaavintero Eparahaamira kaiqa vaiinti irero tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ta vaiintivave vutura tinavu tivita kareva ani vaivo? tiro. Minti tuvaro viva tiharo, Vi vaiintiva ti nora vaiinti vira maaquvanove, tiro. Minti tuvaro Rebekaava tiharo, Ti viri qoqaa variantorave, tivakero nai viri naavuma varero viro. ");
INSERT INTO tbg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mintuma varero vuvaro Eparahaamira kaiqa vaiintivano nai nu uvara vuru Aisaakira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Aisaakiva vi nahentira vita varero nai nora Seraara seri naavuqi vuru kero varatovaro Rebekaava vira naatavano vaura. Tota vira nova qutu vuvaro Aisaakira muntukavano qoraiquvaro variqiro viro, viraqaahairo Rebekaarara antuqa aruvaro vira varatero vauvaro vira muntuka qihaaquvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Seraava qutu vuvaro Eparahaamiva variqiro viro viraqaahairo nahenti vo vira autu Keturara varatora. ");
INSERT INTO tbg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Eparahaamiva vi nahentira varatovaro viva qorainti vainti 6navu vatatora. Simiraanirave, Iokasaanirave, Mentaanirave, Midianirave, Isabaakirave, Suaarave, vinavuka vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iokasaaniva noruqama viro Sebaaka Dedaanika qova vaura. Dedaaniva maa vatanaaka Asuve, Retusive, Reumive, vika qova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midianira maaqunavu vaireka, Efaavave, Efevave, Hanokivave, Abidaavave, Eladaavave, vinavuka vaura. Ekaa vi vaintika Keturara naintinavuma vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Eparahaamiva qaqi vau entara viva nai maaqu vo nahentiqaahainaaka airaira raira nimiro vika nokavata raira nimiro, viraqaahairo nai maaqu Aisaakiva vaunaihairo vika nititama komanta kuari avu urunaini niaraini vika nariara vaireka vuvaro, Aisaakivaqai nai qora Eparahaamira airaira varaarirava mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Eparahaamiva airi ihi 175 ihi varakero viva anoma kero naampaiqama viro qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Eparahaamiva qutu vumanta vira maaqutanta Aisaakika Isamairika ori onavu Makapera Onavuve turaqi náitanta qora quntama tora. Tota vi vatava vaireva, Efaronira Soaara maaqu Hiti vatanaa vatavano vauvaro, Eparahaamiva koqaa autukero vi vatara varero nai naata Seraara quntama toraqi Eparahaamiravata vira maaqutanta mini quntama tora. ");
INSERT INTO tbg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Eparahaamiva qutu vuvaro viraqaahairo Kotiva Aisaakira koqema amitovaro Aisaakiva namari kaqe vaura, vira autu Be-Lahai-Roi Namari vaunaini variqiro vi vaura. (Be-Lahai-Roi – Qaqi Variqiro Vi Vaiva ti tave vaira vira namarive) ");
INSERT INTO tbg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Seraara kaiqa nahenti Hagaava Isipihainaa nahentivano Eparahaamira qorainti vainti vata amitovaro Isamairiva noruqama viro vainti vatato okarava maantimama vairo: ");
INSERT INTO tbg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isamairiva qorainti vainti hoqare vatatoka vika nutu maantimama vairo: Nepaiotirave, Kedaarave, Atabelirave, Mipisaamirave, ");
INSERT INTO tbg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misimaarave, Dumaarave, Masaarave, ");
INSERT INTO tbg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaatirave, Temaarave, Jeturave, Napisirave, Kentemarave, vinavuka 12navu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isamairira maaqu 12navuqihairo 12 ankunavu hoqarama tomanta vaura. Vira vainti nutuvata vira ankunavu autuvata vohaa qaramake vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isamairiva qaqi variqiro viro 137 ihi varakero vuru qutu vumanta vira quntama tora. ");
INSERT INTO tbg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Viva qutu vumanta vira vaintivara Havila vatainivata Suri vatainivata variqi vi vaura. Vi vatava vaireva, Asiria vataini vi vau aarara Isipi vata auvahini vaura. Isamairira vaintivara vika nariara vaiha Eparahaamira vaintivara vonavu navutaiqama nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aisaakira uva maantimama vairo: ");
INSERT INTO tbg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaakiva 40 ihi varakero viva Rebekaara varatero vaura. Rebekaava Betuelira raavuravano vauvaro Betueliva Araamihainaava Mesopotemia vataini vaura. Rebekaara vakaava Labaaniva vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebekaava kia vainti vataraitiro, naahiara/ururaiqama viro vauvaro Aisaakiva virara iriharo Nora Kotira aarovaro viva vira uva iruvarora tiro, Rebekaava vainti taiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Viva vainti taiqama viro vaumanta vira vaintitanta auhaqi vaiha nai vente nai vente iha vauvaro vitanta nova tiharo, Nantihae vitanta ti auhaqihai minti variavo? tivakero viva oru Nora Kotira aarovaro ");
INSERT INTO tbg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Noravano Kotiva virara tiharo, Vainti taaraqantama ai auhaqi variavo. Vainti vovano vo vatanaaka qova vairaro vovano vo vatanaaka qovama varianarove. Vovano kempukaiqama kero vaiharo vora aatara kaanarove. Vira vakaava tuvitarero nai qata paanaa kaiqama varaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Minti tuvaro Rebekaava variqiro viro, qorainti vainti taapitanta vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Viva avuni vainti vatora vaata vaireva naare vaataqai vauvaro kaukivano tuqarama kero viraqaa vauvarora tiro, vira autu nteharo Isorave – Kaukirave tura. ");
INSERT INTO tbg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Vainti vovata vate vauvaro vi vaintiva auhaqihairo aniharo nai vakaara aiqu ataa tote vaurara ti, vira autu nteha Iekopirave – Aiqu Ataa Totairave tura. Aisaakiva 60 ihi varako entara Rebekaava taapi vainti vitanta vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Vira maaqutanta noruqamavi, Isova koqema kero aantau ari vau vaiintiva vauvaro Iekopiva tiremakero vatukaini vau vaiintiva vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isova aantau arukeharo viri nai qora ami vaurara tiro, Aisaakiva aantaura quaheharo Isorara antuqa aruvaro vauvaro Rebekaava Iekopirara antuqa aruvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Vo enta Iekopiva naare kohe/naavara unte vauvaro vira vakaava Isova aantaura nunaihairo anintero ");
INSERT INTO tbg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","voqama kero karara antuqa aruvaro nai qata Iekopirara tiharo, Tota naare kohe/naavara unta taanara hini ti timiraqe naare. Ti nora hantuqama harivo, tiro. (Viva minti turara iriha vokuka vira vara autu nteha Idomurave – Naarerave tura.) ");
INSERT INTO tbg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Isova minti tuvaro vira qatavano Iekopiva aqao tiro, Are hoqarenaava titanta qora airaira vareravama variaro. Are tuvitarairaqe te oritare ai avuni vaiha titanta qora airaira varaarirauka variare. Are mintimake tuvitarairera, te ai homa kohe/naavara amirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Minti tuvaro Isova tiharo, Ho te mintirerave. Te narara vaiha qutu vuariraro te airaira varaarirava kiama ti ho kahaqianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Minti tuvaro Iekopiva tiharo, Aqao, are unahaa tirorave. Are kauqu aiqiqaa aqukehara minti tiane, tuvaro vira vakaava Isova nai kauqu aiqiqaa aqukero tiharo, Quqaama te tuvitare vairerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Minti tuvaro Iekopiva kohe/naavara vonavu kureqihairo raaqukero mparetivatama kero amuvaro Isova nama kero namarivata nama kero himpiro vurama. Mintuma kero vira vakaava Isova nai hoqarero avuni vau auturara kia noraiqaakero iriraitiro, qaqira kero tuvitarero naantiarainiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Haaru Eparahaamiva vau entara karara qaavoqu entava qovarama vuntema kero, qaiqaavata Aisaakiva vau entaraqaa karara qaavoqu entava qovarama vura. Mintuvaro Aisaakiva katu varero Geraa vatukaini Abimelekiva Pirisia vatanaaka avuhainaa vaiintivano vaunaini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Viva mini oru vauvaro Noravano Kotiva Aisaakira avuqaa qovarama viro virara tiharo, Kia katu varera Isipini vuane. Te ariara variane tiaina vatara miniqaima variane. ");
INSERT INTO tbg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Are maini variqira vi vairaqe te ainti vaihama ai koqema amitaqi vuare. Te ekaa maa vatara aivata are kuvuarama teraukavata nimirerave. Te tenta kauqu aiqiqaa aqukeha ai qora Eparahaamiraqaa tiva taatau tauna uvava, vi uvava ariqivatama varianarove. ");
INSERT INTO tbg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Te ai kahaqiari are kuvuarama terauka opu makau voqaara airitahaama vaivarave. Te vika ekaa maa vatara nimirerave. Naantiara are kuvuarama teraukaqihai te ekaa vataini vaika koqema nimitararave. ");
INSERT INTO tbg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Eparahaamiva ti uva iriqiro viharo te tiva tauna uvara iriqiro vurara ti, te aivata mintimake koqema amitaqi virerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kotiva minti tuvarora tiro, Aisaakiva Geraa vataini variqiro vurama. ");
INSERT INTO tbg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Aisaakiva mini variqiro viharo vi vatanaa vaiinti naatu qeteharora tiro, nai naata Rebekaarara ti aurave tura. Aisaakiva tiharo, Hauri te virara ti naatave tiari vi vatanaaka Rebekaarara koqe viri vaata vataa nahentive tivakeha vira varareka autiha ti harukevorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Minti tivakero Aisaakiva vi vataraqaa airi enta variqiro vuvaro Abimelekiva Pirisia vatanaaka avuhainaa vaiintivano nai naavuqi vaiharo uintuanahairo vaavi kunaarima kero tavovaro Aisaakiva nai naata Rebekaara tote vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","viva Aisaakira aarama kero tiharo, Vi nahentiva quqaama ai naatama vaivo. Nantiharae are virara ti aurave tiaro? tiro. Minti tuvaro Aisaakiva vira nai tiva amiro tiharo, Oho, hauri vira varareka iha ti harukevorave tima, te virara ti aurave tunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Minti tuvaro Abimelekiva tiharo, Oho, are nana okarara iriharae mintira iaro? Are minti tiararo maa vatanaa vaiinti vovano ai naatantiro nitirio, tenavu nora uvama varauraitirio, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelekiva minti tivakero viva nai navunaaka qioqama teharo vikara tiharo, Niqihairo vovano maa vaiintirae vira naatae utu varairera, vira kaara te tiari vira aruma kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Minti tuvaro Aisaakiva mini variqiro viharo kara ututovaro Noravano Kotiva vira koqema amitovarora tiro, vira karavano qampiqeharo airi kara iratero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mintuvaro Aisaakiva airi airaira vato vaiintiva variqiro viro nora vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aisaakiva airi haika vatova vauvaro vira purumakauve, sipisipive airi vaumanta vira kaiqa vaiintinavuvata airi vaumantara ti, Pirisia vatanaaka viva vato haikara tavovaro muntuka nti vaumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mintumanta vika orunte Aisaakira qoraiqama amitareka Pirisia vatanaaka vira qova Eparahaamiva qaqi vau entara vira kaiqa vaiintinavu namari kaqareka vata quvitora, ekaa vona vona rahirama kora. ");
INSERT INTO tbg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Mintimake qoraiqama amitovaro Abimelekiva Aisaakirara tiharo, Tinavu vataqaahaira katu varera vuane. Are maini kempukaiqama vira variqira vihara, tinavu haatara kerorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Abimelekiva minti tuvaro Aisaakiva katu varero otu Geraa Uqitaini nai seri naavu maaqa kaqatero mini variqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Haaru vira qova Eparahaamiva qaqi vau entara vira kaiqa vaiintinavu namariara quvitova vonaini vonaini vauvaro Eparahaamiva qutu vumanta viraqaahai Pirisia vatanaaka ekaa vinavura ani rahirama kora. Ho Aisaakiva qaiqaa namari kaqoraqi vata qaqini vaqita kovaro koqe namarivano ekaa viraqi qaiqaa vaura. Vira qova autu ntava tontema kero, viva qaiqaa vinavura vohaa qaramakero autu ntava tora. ");
INSERT INTO tbg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ho Aisaakira kaiqa vaiintinavu uqita kanta namariara quvike qaraaka ruvu namari rantake vira kaqaare tumanta ");
INSERT INTO tbg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Geraa vatanaaka nái sipisipiqaa raqiki vauka orunte tiroriha tiha, Aqao, maa namarira tinavu namarive, tuvaro Aisaakiva vi namarira autu nteharo, Eseki-Namarive – Tiroria Namarirave, tivakero qaqira kero oru vura. ");
INSERT INTO tbg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Oru vumanta vira kaiqa vaiintinavu qaiqaa namariara quvike ruvu namari vo ranta komanta vi vatanaaka qaiqaa aninte vi namarirara tirori vauvaro Aisaakiva vi namarira autu nteharo Sitinave – Navutaiqia-Namarirave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Minti tivakero qaqira kero katu varero qaiqaa oru vonaini namariara quvikero ruvu namari vo ranta kero mini vaumanta kia vika qaiqaa aninte tiroriavarora tiro, Aisaakiva vi namarira autu nteharo Rehobotive – Kia Mauqantaa Namarirave, tivakero mintima tiro: Noravano Kotiva tenavu ho variaina vatara tinavu timivo. Tenavu homa maini vaiha koqemake variqi virarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ho Aisaakiva Besebaini oru viro ");
INSERT INTO tbg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","entaqi oru mini vauvaro Noravano Kotiva vira avuqaa qovarama viro virara tiharo, Te ai qora Eparahaamira Variqavanoma vauro. Te ainti variqi vuainarara tira, kia qetehara variane. Te tenta kaiqa vaiinti Eparahaamirarao ti, te ai koqema amiteha are kuvuarama teraukavata airiqama kararave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Minti tuvaro Aisaakiva mini vaiharo oriqohairo ofaa tainta vo autu kero Nora Kotira aareharo quahama amitora. Mintumanta vira kaiqa vaiintinavu qaiqaa vata quvike namari kaqera vo rantakora. ");
INSERT INTO tbg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ho Aisaakiva mini vauvaro Abimelekiva Geraa vatukaihairo Aisaakira tavareva viharo vaiinti vo, Ahusaatira koqe avu aato ami vau vaiintiravata, vaiinti vo, nai iqoka vaiintinavuqaa raqiki vau vaiintira Pikoriravata ntitakero Aisaakiva vaunaini vura. ");
INSERT INTO tbg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Vinavuka mini oruntovaro Aisaakiva vinavukara tiharo, Nenavu ti navutaiqama timiteha tiriara katu varera vuane tiaka, nana kaarae ti tavareka maini aniavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Minti tumanta vinavuka tiha, Tenavu kankomake tavauraro Noravano Kotiva ai kahaqi vaivara variaro. Virara irihama tenavu tiha, Kaiqenavu vohaa vaiha uva vohaa tiva taatauke maateraiqamake variare. Tenavu tota kia ai qoraiqama amitaraiti, maateraiqamake ai atitama kaunarave. Virara iriharama are kia tintanavuvata qoraiqama timitaane. Tenavu tavauraro Noravano Kotiva ai koqema amitaivara variaro, ti. ");
INSERT INTO tbg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Vinavuka minti tuvaro Aisaakiva vinavuka nora kara unta nimitomanta vinavuka vira karavata namarivata nora. ");
INSERT INTO tbg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Namake vaite vira qararaa vaaka toqaqi vika himpi vohaiqa vohaiqavano nái kauqu aiqiqaa aqukeha maateraiqi uvara tiva vate Aisaakira mini ke nái maaqaini anirante vurama. ");
INSERT INTO tbg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Vinavuka vumanta vohaa vi entaraqaa Aisaakira kaiqa vaiintinavu namariara vata quvike vuru Aisaakira tiva ami tiha, Tenavu koqe namari vo ranta kauro, ti. ");
INSERT INTO tbg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Vika minti tuvaro Aisaakiva vi namarira autu nteharo, Siva Namarive – Kauqu Aiqiqaa Aqukaa Namarirave, tura. Aisaakiva minti turara iriha, maa entaravata vaiinti nahenti vatuka vo autu nteha Be-Sivave ti variara. ");
INSERT INTO tbg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isova 40 ihi varakero oru Hiti vatanaa nahenti varaatatanta varatero vaura. Vo nahenti Berira raavura Iutitiva vauvaro vo nahenti Elonira raavura Basemaativa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isova vitanta vo vatanaa nahentitanta varatora kaara Aisaakika Rebekaaka muntuka qoraiqumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisaakiva naampaiqama vuvaro vira avu makuquqama vuvaro viva Isora nai maaqu avuhainaara aarama kero tiharo, Ti maaquo, tuvaro viva tiharo, Qaao, te mainima vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Minti tuvaro Aisaakiva tiharo, Te naampaiqamama vuro. Te tenta qutuaina okarara kiama iruro. ");
INSERT INTO tbg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Are huru veva varera oru ahakaqi nihara aantau aru kera viri untakera ");
INSERT INTO tbg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ti voqama kero hantuqa harina karara untakera viri timiraqe naare. Are mintiraqe te kia qutiraiti, qaqi variainanto vi karara namake viraqaahai te tenta kauqu tuaherakeha ai koqema amitaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aisaakiva nai maaqu Isorara minti ti vauvaro vira naata Rebekaava, vivavata vi uvara irura. Ho Isova ahakaqi aantaura vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekaava nai maaqu Iekopirara tiharo, Te aato vatanteha iruraro ai qova ai vakaara Isorara mintima tivo: ");
INSERT INTO tbg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Aantau aru viri untakera hiakaa i vaina karara vara viri timiraqe namake, te kia qutiraiti qaqi variainanto Nora Kotira avuqaa vaiha tenta kauqu tuaherakeha ai koqema amitaare, tirave. ");
INSERT INTO tbg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ai qova minti tirara ti, te tiarirara are te tiainante iane. ");
INSERT INTO tbg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Are oruntera memeraa vairaqihaira naati koqera taaraqanta aru varera viri timiraqe te ai qora antuqa vaina karara hiakaa inara unta amitaarirara ");
INSERT INTO tbg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","are varera vuru nena qora amiraro viva nama kero, viva kia qutiraitiro, qaqi vaina entara nai kauqu tuahera keharo ai koqema amitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Vira nova Rebekaava minti tuvaro Iekopiva aqao tiro, Ti vakaava Isova kauki vaata vataava vaimanta te qaqi vaata vataukama vauro. ");
INSERT INTO tbg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Hauri ti qova ti tivaata autama kero tavero, tiriara are unaqarama kerama anira iaro tiantorave. Vira kaara viva kia ti koqema timitaraitiro, ti qoraiqama timiteharo qora uvama ti tiva timitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Iekopiva minti tuvaro vira nova tiharo, Ti maaquo, ai qova ariara qora uva tirera, vi uvava kiama ariqaa varianarove, tiqaama varianarove. Are te tiainantema kera, oru memeraa naati taaraqanta ruqutu viri timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Minti tuvaro nai nova tuntema kero Iekopiva oru memeraa naati taaraqanta ruqutu varero viri nai nora amuvaro viva vira qora antuqa vau karara hiakaa ura unta amitora. ");
INSERT INTO tbg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Unta amitero viraqaahairo Rebekaava oru nai naavuqihairo Isora utavaaqa koqera varero muntu Iekopira nonku amitero ");
INSERT INTO tbg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","memeraa pahi varakero Iekopira kauquqaavata vaantaariqaavata naavuma amitero ");
INSERT INTO tbg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","hiakaa u kararavata mparetivata untatora amuvaro ");
INSERT INTO tbg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iekopiva vira varero nai qova vauraqi oruntero tiharo, Qaao, tuvaro vira qova vo tivakero vira irero, Ti maaquo, nena autu ntaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Minti tuvaro Iekopiva nai qorara tiharo, Te Isoka, ai maaqu avuhainaukave. Te are tianantemake aantau aru unta vare anuro. Aantau unta amitaunara himpira vaavi vaihara nerama, kauqu tuahera kehara ti koqema timitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Minti tuvaro Aisaakiva nai maaquara tiharo, Aqao, are vate vuaravama vaaka orurante anira iaro, tuvaro Iekopiva tiharo, Noravano Kotiva ai Variqavano ti kahaqimanta te vaaka aantau ranta kauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Minti tuvaro Aisaakiva Iekopirara tiharo, Are quqaae ti maaqu Isovae, vo vaintivanoe variaro? Are vainto aivaiqiraqe te ai vaata auteha tavaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Minti tuvaro Iekopiva nai qora aaqanto ori vaiquvaro vira qova vira vaata autama kero tavero tiharo, Uvama Iekopira uva vaivarovata, vaatama Isora vaata vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Iekopira kauquvano Isora kauqu voqaara kauki kauqu vauvarora tiro, Aisaakiva kia Iekopira viraaqama kero tavaraitiro, viva vira koqema amitareva iharo qaiqaa irero, ");
INSERT INTO tbg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ho quqaae are ti maaqu Isovave, tuvaro Iekopiva tiharo, Te quqaa maa vikave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Minti tuvaro Aisaakiva tiharo, Ho ti maaquo, hini aantau unta taanara vara viri timiraqe namake kauqu tuaherake ai koqema amitaare, tiro. Aisaakiva minti tuvaro Iekopiva kara vare vuru amuvaro nama kovaro uainivata amuvaro nama kero ");
INSERT INTO tbg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","viraqaahairo vira qova Aisaakiva virara tiharo, Anira ti moqa kaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Minti tuvaro Iekopiva oru vira moqa kovaro Aisaakiva vira utavaaqa uhirama kero nai kauqu tuahera kero vira koqema amitareva mintima tiro: Noravano Kotiva koqe vataqaa naaho ututaira koqema amitaivaro koqe unta intema kero, ti maaqu vaataqaahairovata koqema kero unta ivo. ");
INSERT INTO tbg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kairaro Kotiva naaruvaihairo varavu vara kairaro ai naaho maatavano koqema kero qampiqairaro ai uitivata uainivata airi variarire. ");
INSERT INTO tbg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kairamanta vo vatanaa vo vatanaaka ai paanaa kaiqa vara amiteha, ai vevaaraini variate. Are noraiqama vira, nena qata vakaukavaraqaama raqikiqira vuane. Kairamanta ai nora vira maaquvara vika ai aiqutaraini vaiha ai autu tuahera kaate. Kairaro vovano ai qoraiqama amitairava naivata qoraiqama vuarire. Vovano ai koqema amitainara naivata koqema amitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisaakiva minti tivakeharo koqema amitovaro Iekopiva nai qora mini kero vuvaro vira vakaava Isova aantaura niniro anintero ");
INSERT INTO tbg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","aantau vira untakero varero nai qova vauraqi oruntero tiharo, Qaao, himpira vaavi vaihara maa aantaura aruke unta taunara hini namakera kauqu tuaherakera ti koqema timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isova minti tuvaro vira qova Aisaakiva vira irero tiharo, Oho, are tavave? tuvaro Isova virara tiharo, Te ai maaqu Isoka avuhainaukave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Minti tuvaro Aisaakira aiqu kauqu voqama kero ntiri ntiri i vauvaro tiharo, Oho, tavave vaaka aantau aru unta viri timimanta nama kauro? Te vira aantau namakema vira koqema amitauro. Te vaaka kauqu tuaherake koqema amitauna uvara kia ho qaiqaa tirarave. Vivaqaima vi uvara varero koqema viro varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Viva minti tuvaro Isova vira uva iriro, noraiqaakero mpo ike tivakero nai qorara tiharo, Mpo, qaao, kauqu tuahera kehara tivata koqema timitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Minti tuvaro vira qova tiharo, Aqao, ai qatavano unaqaraama kaimanta te kauqu tuahera keha koqema amiteha ekaa vi uvara tiva amuraro viva varero vivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Vira qova minti tuvaro Isova tiharo, Oho, quqaa vira autu Iekopivave – Una uva ti vaivave. Viva taara tataama ti unaqaraiqama kairave. Hoqarero avuni ti vatatai autura viva varairave. Vate are kauqu tuahera kera ti koqema timitareva iana uvaravata vivaqai varaivo, tiro. Minti tivakero viva nai qorara mpo ike tiro, Qaao, kiae voki uvaravata vaivo? Vokira vairera, are vi uvara hoe ti tiva timinarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isova minti tuvaro Aisaakiva nai tiva amiro tiharo, Te vaaka vira tiva amunarara tiro, ai qatavano ariqaama raqikianarove. Ekaa vira navunaaka vira paanaa kaiqama varevarave. Viva ututaarira karava koqema kero qampiqaanarove. Te ekaa vi uvara minti tiva kaunarara ti, nana uva qaqi vainarae ai tiva amirarave? Kiama vo uvavata qaqi vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Aisaakiva minti tuvaro Isova nai qorara tiharo, Mpo, qaao, are koqema timiterava vohaiqae vaivo? Kauqu tuaherakera tivata koqema timitaane, tivakero noraiqaakero iqi rateharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Minti tivakero iqi rateharo vauvaro vira qova Aisaakiva vira tiva amiro tiharo: Are kia koqe vata vainanaini variqira viraro mini aaqu kia koqema kero ntirarama vainarave. ");
INSERT INTO tbg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Are iqoka paipe totehara raquqira viharama kara varenarave. Mintiaqira viharama are nena qata kaiqa vara amitaqira vivira, viraqaahaira are vira kauquqihaira ruqemakera kuvantuvira nenaraa vainarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Vira qova kauqu tuahera kero Iekopira koqema amitora kaara Isora arara itovaro tiharo, Ti qova qutuarirava aumantoma vaivo. Viva qutu viraqe te virara iqi rata amite, viraqaahai tenta qata aru karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ho Rebekaava Isova nai qata aru kaaina okarara iriro, viva Iekopira aarama kero virara tiharo, Ho iriane. Ai vakaava Isova ai aru kaaina entara virara vekaiqiharo vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ho are te tiainante iane. Kantera ti vakaava Labaaniva Haraanini vainaini oru vairaro ");
INSERT INTO tbg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ai vakaara araravano vaahama vuarire. ");
INSERT INTO tbg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Viva are vira autu amitaana okarara tauru kairaqe te vaiinti vo atitaariraro viva vuru ai tiva amiro ai vite aniarire. Mpo, ti maaqutanta netanta nai aruke nai aruke ivaqe te vohaa entaqaa nitantara iqi rata nimitaarorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekaava minti tivakero viva oru Aisaakirara tiharo, Isova Hiti vatanaa nahentitanta vara taira kaara ti popohaivo. Iekopivavata Hiti vatanaa nahenti varairera, vira kaara te kia qaqi variqi viraiti, vaakama qutu virarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Rebekaava minti tuvarora tiro, Aisaakiva Iekopira aarama kero vira uva mantero tiharo, Kia Kenaani vatanaa nahenti varaane. ");
INSERT INTO tbg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Qaqira kera oru Mesopotemia vataini ai naaquva Betueliva vainaini oru nena naura Labaanira raavurama vo varaane. ");
INSERT INTO tbg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kairaro Kotiva ekaa kempuka vataava ai koqema amitaira ai vaintivara airiqama vivara are nora vatanaaka qovama variane. ");
INSERT INTO tbg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kairaro Kotiva Eparahaamira koqema amitontema kero, viva aivata are kuvuarama teraukavata koqema nimitairaro maa vatava nini variarire. Are vate variana vatava vaireva, vo vatanaaka vatama vaivo. Kairaro Kotiva ai koqema amitairara are naantiara maa vatara, Kotiva Eparahaamira kaama amito vatara varaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Minti tivakero Aisaakiva Iekopira atitovaro viva Mesopotemia vataini nai nauva Labaaniva vaunaini oru vaura. Betueliva Araamihainaava vauvaro vira maaqu Labaaniva Rebekaara vakaava vauvaro Rebekaava Iekopika Isoka nova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Aisaakiva kauqu tuaherakero Iekopira koqema amitero, viraqaahairo viva Iekopirara kia Kenaani nahenti varaane tivakero, virara Mesopotemia vataini nahenti varaarire tiro, vira atitama kovaro Iekopiva nai noka qoka tu uvara iriharo Mesopotemia vataini nahenti varareva vura. Ho Isovavata vi uvara iruvaro ");
INSERT INTO tbg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","vira aato kenko tuvaro tiharo, Oho, te vo vatanaa nahentitanta varataunara kaarama ti qova kia tiriara quaheharo vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Minti tivakero Isova oru Eparahaamira maaqu Isamairira ankuqaahairo Maharaatira varatora. Maharaativa Nebaiotira auravano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iekopiva Beseba mini kero Haraanini vireva vurama. ");
INSERT INTO tbg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Viva aaraini vi vauvaro kuari avu aqu vuvaro entama vuvaro viva qaqi kanta vaitareva iharo ori vo turu ntuva kero vaiteharo ");
INSERT INTO tbg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","taira tavora. Viva taira tave vauvaro aika vukaivano vataihairo viviro naaruvaini vaumanta enselinavu aika vivau oru vi tuvi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Minti vauvaro Iekopira maraquravano tavovaro Noravano Kotiva vira tataaqa himpitero vaiharo tiharo, Te Noravano Kotika Eparahaamika Aisaakika Variqavanoma vauro, tiro. Minti tivakero viva qaiqaa tiharo, Are vaite variana vatara, maa vatara te aivata are kuvuarama teraukavata nimirerave. ");
INSERT INTO tbg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Are kuvuarama terauka airitahaama vaivarave. Vika vona vona ekaa vata maatama vaivarave. Te ariaravata vikaravata irihama ekaa vataini vaika koqema nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Te ainti vaiha ariqaa raqiki variarirara are oru ninirama qaiqaa maini orurante ani narave. Te ariara tuna uvara kia qaqira karaiti, te ainti vaiha maa uvara tiva taunara ekaa autu taiqa karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Minti tuvaro Iekopiva vaitonaihairo himpiro nai aatoqihairo irikero tiharo, ");
INSERT INTO tbg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Oho, te maa vatara aatu qete vauro. Nora Kotira naavu vatukama maini vaivo. Naaruvaini vi varia qentiva mainima vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Minti tivakero vira qararaa Iekopiva vaaka toqaqi himpiro turu ntuva kero vaito orira varakero vaavi aratero ori viraqaa vahavera qihiakero ");
INSERT INTO tbg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","vi vatara autu nteharo, Betelive – Kotira Maaqave, tura. (Haaru vaiinti nahenti vi vataraqaa vau vatukara autu nteha Lusive, tura.) ");
INSERT INTO tbg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Minti tivakero Iekopiva nai kauqu aiqiqaa aqukeharo Kotirara tiharo, Are tintira vaiharama koqema kera tiqaa raqikiharama karave, utavaaqa nonkuainarave, ti timi vairaqe te niara aara oru ninima ");
INSERT INTO tbg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","orurante aitare tenta qora maaqaini vuare. Are mintima kera koqema kera tiqaa raqikirera, te ariara are Noravano Kotiva ti Variqavano variaro tirerave. ");
INSERT INTO tbg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Maa orira vataqi vaavi arataurava vainaraqaa vaiinti nahenti ruvaaqumavi vaiha ai autu tuahera kevarave. Are nana nana haikae ti timinaraqihai, te 9navu tenta tuate vohaiqa nina amirerave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ho Iekopiva aaraini viviro, kuari avu urunaini Mesopotemia vataini oru ntora. ");
INSERT INTO tbg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mini oru ntero tavovaro namari kaqe vauva vo vauvaro vira tataaqa taaramonavuqaa sipisipi ruvaaqumavi vaiha namari nareka veka vaura. Namari vira noqaa aquto oriva, nora ori maara nto oriva vaumantara ti, ");
INSERT INTO tbg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","vo enta vo enta vika kia vi orira vaaka qaqini varakaraiti, vika nái kana vaiinti veka vaumanta vika ekaa ani ruvaaqumavi vaiha nora ori aqutora venta qaqini keha, namari kaqake sipisipinavu nimi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ho sipisipiqaa raqikuka taaramonavu nai navunaaka veka vauvaro Iekopiva mini oru ntero tiharo, Ti qata vakaao, nenavu taihaie maini ani variavo? tumanta vinavuka tiha, Tenavu Haraanihaive, ti. ");
INSERT INTO tbg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Minti tuvaro Iekopiva vinavuka irero, Nenavu vaiinti vo, Nehora nainti Labaanira tavaarave, kiae tavaarave? tumanta vinavuka tiha, Vira tavaunarave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Minti tuvaro Iekopiva vinavuka qaiqaa irero, Labaaniva qaqie vaivo? tumanta vinavuka tiha, Eo, viva qaqima vaivo. Ho tavaane. Vira raavuravano Reseriva vira sipisipi hampata maini ani vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Minti tuvaro Iekopiva vinavukara tiharo, Ho tavaate. Kuarivano qaqi qiataqaa ite vairara ti, ne sipisipi avutaqi vita vuru keva vatema varianarove. Ne namari kaqake sipisipi vika nimi, ntita vare anirante ukau vainaini vuru kaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Minti tumanta vinavuka aqao ti, Namari noqaa aqutaa oriva nora orima vaivo. Ekaa vo vaiinti vo vaiinti sipisipi aniqe tenavu ori vira venta qaqini ke namari vika kaqa nimirerave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Vika minti tuvaro Iekopiva vinavuka hampata qaqi uva ti vauvaro Reseriva nai qora sipisipi hampata oru ntora. Viva sipisipiqaa raqiku nahentiva vaiharora tiro, viva sipisipi hampata oru ntovaro ");
INSERT INTO tbg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Iekopiva tavovaro vira naura Labaanira raavuravano Reseriva Labaanira sipisipi hampata vauvaro vira tavero quahakero oru nariaraa nora ori namari noqaa aqutora venta qaqini kero nai naura sipisipinavu namari kaqakero nimura. ");
INSERT INTO tbg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Namari kaqa nimiro viraqaahairo Iekopiva oru Reserira moqakero virara iqi rata amitero ");
INSERT INTO tbg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","tiharo, Te ai qora nauntivanove. Te Rebekaara maaquvanove, tuvaro Reseriva kantero vuru nai qora tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labaaniva vi uvara iriro tiharo, Ike, viva ti aura maaquvanove, tivakero viva kantero oru Iekopira vitakero vira kukuqama kero vatero moqa kero, viraqaahairo vira vita varero vuru nai naavuqi kora. Labaaniva nai naavuqi vira vuru kovaro Iekopiva ekaa vi uvara vi uvara Labaanira tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labaaniva tiharo, Quqaama are ti vohaa naarevano variaro. Tetanta vohaara vaintima vauro, tiro. Labaaniva minti tuvaro Iekopiva vikantiro vohaa tora vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","viraqaahairo Labaaniva Iekopirara tiharo, Kia are tiriara te vira nauntive tivakehara ti kaiqa qaqi vara timitaane. Are ti kaiqa vara timitenarara te nana koqaae ai amirarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","17","Minti tuvaro Iekopiva tavomanta vira raavura taaraqanta vaura. Vira nakaara autu Riaava vauvaro vira avuvano kia koqe avu vaura. Vira auravano Reseriva koqe viri vaata vataava vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iekopiva Reserirara antuqa aruvaro vaiharo viva Labaanirara tiharo, Kaiqe te ai kaiqa varehama 7 ihi varake ai raavura naantiaraara Reserira varaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Minti tuvaro Labaaniva nai tiva amiro tiharo, Hove. Vo ankuqihairo vovano vira varaantorave. Are homa maini ti kaiqa vara timitera, vira varenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Minti tuvaro Iekopiva Reserira varareva 7 ihiara Labaanira kaiqa vara amitora. Viva Reserirara antuqa aruvaro vira varaainarara iriharo tiharo, Te 7 ihi navu kaiqa varaarirava kia vukai entanavu vairaitiro, taaraiqama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Minti tivakero 7 ihi navuara kaiqa varaqiro viro vuru taiqa kero, viraqaahairo oru Labaanirara tiharo, Ho te ai kaiqa vara amitaqi vi, vuru taiqa kauro. Ho are tinta naata timiraqe varaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Minti tuvaro Labaaniva Iekopiva nahenti varaarire tiro, hihai hihairo vaiinti nahenti naarama ruvaaquma kero kara nimuvaro ");
INSERT INTO tbg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","entama vuvaro Labaaniva kia nai raavura Reserira Iekopira amiraitiro, viva Riaara vitero vira amuvaro ˻Iekopiva virara Reserirave tivakero˼ vikantiro nai naavuqi vaitora. ");
INSERT INTO tbg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labaaniva nai kaiqa nahenti vo, Riaara amuvaro vi nahentiva Siripaava Riaara kaiqa nahenti vaura.) ");
INSERT INTO tbg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Labaaniva Riaara vuru Iekopira amuvaro Iekopiva vikantiro vaitero vira qararaa toqaqi himpiro tavovaro vira nakaava Riaava vira naata vaura. Ho vira kaara Iekopiva oru Labaanirara aqao tiro, Nantiharae ti mintima timitaaro? Te Reserira vararera ai kaiqa vara amitaunarave. Nana kaarae are ti unaqarama timitaaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Minti tuvaro Labaaniva tiharo, Aqao, tinavu okara mintima vairave. Tenavu kiama aura naane vaiinti amiraiti, nakaara naane vaiinti ami vaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Vohaa uiki maa karara ne entava taiqa viraqe tenavu homa vira aura ai amirarave. Are vira varenarara irihara qaiqaa 7 ihi vonavuvata ti kaiqa vara timitenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Minti tuvaro Iekopiva eo tivakero vohaa uiki varakovaro Labaaniva nai raavura Reserira amuvaro Iekopiva vira varatero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Labaaniva nai kaiqa nahenti vo, Reserira amuvaro vi nahentiva Bilihaava Reserira kaiqa nahenti vaura.) ");
INSERT INTO tbg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iekopiva Reserira varatero vaiharo virara voqama kero antuqa aruvaro Riaarara inaaraiqaqai antuqa aruvaro vaura. Iekopiva mini vaiharo 7 ihi vonavuvata Labaanira kaiqa vara amiteharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Noravano Kotiva tavovaro Iekopiva Riaarara inaaraiqaqai antuqa aruvaro viraqaahairo Kotiva Riaara kahaquvaro Riaava vainti taiqama viro vauvaro Reseriva naahiara/qururaiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Riaava vainti taiqama viro qorainti vainti vo vatatero tiharo, Noravano Kotiva tavaivaro kia ti vaativano tiriara quahaira kaara viva ti kahaqama timitaivo. Vate maaqaahairo ti vaati hantuqavano tiriara varianarove, tivakero nai maaqu avuhainaarara Rubenirave – Muntuka Maara Ntaira Tavairave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Riaava qaiqaa vainti taiqama viro qorainti vainti vo vatatero tiharo, Ti vaativano kia tiriara quahaira kaara Noravano Kotiva qaiqaa maa vaintiravata ti timivo, tiro. Minti tivakero nai maaquara Simionirave – Uva Iri Vairave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Minti tivakero Riaava variro qaiqaa vainti taiqama viro qorainti vainti vo vatatero tiharo, Te tenta vaati taaramo vainti vata amitaunarara tiro, vira hantuqavano tiriara varianarove, tivakero virara Rivairave – Vohaa Avitumavirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Minti tivakero Riaava qaiqaa vainti taiqama viro qorainti vainti vo vatatero tiharo, Vi vaintirara irihama te Nora Kotira autu tuahera karerave tivakero, viva vi vaintirara Iutaarave – Vira Autu Tuahera Karerave, tiro. Minti tivakero kia qaiqaa vainti vataraitiro, qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Riaava vi vaintinavuka vatatovaro Reseriva kia vainti vataraitiro, vira kaara nai nakaara nota amiteharo oru Iekopirara tiharo, Are kia vainti ti timirera, te qutu virerave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iekopira arara itovaro tiharo, Aqao, te kia Kotikavauve ai vainti ho amirarave. Vivama ai naahiarama/qururaiqama kaivarama are kia vainti vataaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Minti tuvaro Reseriva tiharo, Are ti kaiqa nahenti Bilihaakantira vaitairaro viva ti vainti vata timitaarire. Viva mintiraqe te vainti noka homa vairarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Minti tivakero viva nai kaiqa nahenti Bilihaara amuvaro Iekopiva vikantiro vaitovaro ");
INSERT INTO tbg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilihaava vainti taiqama viro vuru qorainti vainti vata amitora. ");
INSERT INTO tbg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Reseriva tiharo, Kotiva ti uva iriharo avuqavuma timitaivo. Te vira aarauraro viva ti uva iriharoma qorainti vainti ti timivo, tivakero vi vaintira autu nteharo Daanirave – Uva Avuqavuma Timitairave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Minti tuvaro Bilihaava qaiqaa variro vainti taiqama viro Iekopira qorainti vainti vo vata amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Reseriva tiharo, Te tenta nakaakanti raquqi vivima vira aatara kauro, tivakero vi vaintira autu nteharo Napataarirave – Te Raqunarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Minti tivakero vauvaro Riaava tavovaro viva qaiqaa vainti vataarirava kia vauvaro viva nai kaiqa nahenti Siripaara Iekopira amuvaro Iekopiva vikantiro vaitovaro ");
INSERT INTO tbg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Siripaava qorainti vainti Iekopira vata amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Riaava tiharo, Ti koqema timitaimanta qaiqaa vainti varauro, tivakero vi vaintirara Gaatirave – Koqe Haika Timirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Minti tuvaro Siripaava qaiqaa qorainti vainti Iekopira vata amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Riaava tiharo, Te voqamake quahema vauro. Vaiinti nahenti tiriara quahe vai nahentiravema tivarave, tivakero vi vaintirara Aserave – Quahaunarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ho uiti teqe entava anintovaro Riaara maaqu Rubeniva mini oru vaiharo maura vo ranta kora. Nahenti vika vi maurara tiha, Vira namake vainti taiqama virarave, ti vau maurara ranta kero varero vuru nai nora Riaara amuvaro Reseriva vira tavero Riaarara tiharo, Ai maaquvano rantatai maurara tivata hini timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Reseriva minti tuvaro Riaava aqao tiro, Are tiqaahaira ti vaati varaanarara hove tiataara vaivara are kia minti tiraitira, are ti maaqu mauraravata ti naari variaro, tuvaro Reseriva tiharo, Are nena maaqu maura vira ti timirera, are homa Iekopikantira entaqi vaitenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Minti tuvaro erovaro Iekopiva naaho kaiqa vara taiqakero anuvaro Riaava vira oru vitakero tiharo, Are vate entaqi tintira vaitenarave. Ti maaquvano maura varakero timiraqohai te Reserira koqaama kaunarara ti, te entaqi ainti vaitarerave, tiro. Minti tuvaro Iekopiva entaqi vikantiro vaitora. ");
INSERT INTO tbg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ho Kotiva Riaara uva iriro vira kahaquvaro Riaava vainti taiqama viro qorainti vainti vo Iekopira vata amitora. Riaara maaqu 5navu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Riaava vainti vatatero tiharo, Te tenta kaiqa nahenti tenta vaati amurarora tiro, Kotiva tiriara quaheharo qorainti vainti vovata ti timivo, tivakero virara Isakaarave – Koqaa Timirave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Riaava qaiqaa vainti taiqama viro vuru qorainti vainti vo Iekopira vata amitora. Mintumanta Riaara maaqu 6navu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Riaava tiharo, Kotiva koqe haika ti timitairave. Te tenta vaati vira maaqu 6navu vata amitaunarara tiro, viva tiriara quaheharo varianarove tivakero, virara Sebulunirave – Ti Vaativano Tintiro Varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Minti tivakero varikero vira naantiara Riaava nahenti vainti vatatero virara Dainaarave tura. ");
INSERT INTO tbg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Minti tuvaro viraqaahairo Kotiva Reserirara iritero, vira aaro uvara iriro vira kahaqama amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","viva vainti taiqama viro qorainti vainti vatatero tiharo, Te kia vainti vataunara kaara kaurira haika varaunara Kotiva taiqa timitaivo, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","virara Iohepirave – Voqavata Timiarire, tiro. Minti tivakero viva tiharo, Kairaro Noravano Kotiva qaiqaa qorainti vainti voqavata ti timiarire, tiro turama. ");
INSERT INTO tbg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Reseriva Iohepira vatatovaro Iekopiva Labaanirara tiharo, Te airi ihiara ai hampata vaiha ai kaiqa vara amiteha nahenti varatema vaintivata vatatauro. Ho ti tititairaqe tenta naata vainti ntita vare tenta maaqaini vuare. Te nora kaiqa ai vara ami taunara virara kankomake irianarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Minti tuvaro Labaaniva aqao tiro, Te tiarirara are iriane. Te hepi kaiqa varake tavaurara are maini variararo Noravano Kotiva ai koqema amiteharo tivata koqema timite vairave. ");
INSERT INTO tbg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kia vuane. Are maini vairaqe te koqaavata ai amiare. Are nana koqaae varareva inara tiraqe ai amiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Minti tuvaro Iekopiva tiharo, Te ai kaiqa vara amiteha ai sipisipive memeraaqaave raqiki vauramanta vika airitahaa variarave. Are virara irianarave. ");
INSERT INTO tbg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Te kia maini anuna entara ai sipisipi memeraa taaraiqaqai vaurave. Maa entara vika airitahaama variavo. Te maini vaurarora tiro, Noravano Kotiva aivata koqema amitairave. Vate maa entara te tenta vainti nahentiara iriha vika kaiqa vara nimitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Minti tuvaro Labaaniva tiharo, Ho maini variqira viraqe te nana nana koqaae ai amirarave? tiro. Minti tuvaro Iekopiva virara tiharo, Kia vo koqaa ti timiane. Te vo uva ai tiva amiarirara are hove tirera, te maini vaiha ai sipisipi memeraaqaa raqikiqi virerave. ");
INSERT INTO tbg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Are kairaqe te vate ai sipisipiqihai ekaa naati konkira rairake tuate, ai memeraaqihai ekaa kaakantaarinara rairake tuateha vikara tenta quarave tiare. Vikama ti koqaa vaivarave. ");
INSERT INTO tbg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Naantiara are ani ti konkira sipisipive kaakantaarira memeraave aitutumake tavairaro viraqi vo vaata vataakavata vaivera, are homa tiriara vira muara vara taanarave tinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Iekopiva minti tuvaro Labaaniva tiharo, Hove, are tianantema kero vi uvava varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Labaaniva minti tivakero vohaa vi entaraqai viva kantero oru evaara nai sipisipi memeraa rairakero, memeraa kaakantaarira qoravata nahevata nariaraa vatero, sipisipi konkiravata varakero nariara vatero nai maaqunavu vonaini nititama kero tiharo, ˻Iekopiva maaka varaantorave.˼ ");
INSERT INTO tbg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nenavu vika ntita vare taaramo enta niaraini oru vaihama vikaqaata raqikiha variate, tumanta vika vuvaro Iekopiva maaqaini vaiharo hini sipisipi memeraaqaa raqikiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iekopiva vikaqaa raqikiharo oru vo qara vo qara u katari kaarara teqa kero varero, vika paha vona vona turikero vona vona qaqi kero ");
INSERT INTO tbg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","varero vuru sipisipi memeraa namari ne vaura voqi voqi aratora. Mintima kero viva memeraa mini ntita vuru komanta vika namari nareka ani ");
INSERT INTO tbg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","katari vira aratora avuqaa vaiha qaramaqi vi vaumanta viraqaahai vika naati vatareka vaakuvirive, qarantaurirave, kaakantaarirave, vate vaura. ");
INSERT INTO tbg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Iekopiva Labaanira sipisipiqaa raqikiharo vikaqihairo nahe sipisipi rairakero nariara vatero, konkira sipisipi nai ura vika hampata komanta vika kuvuaramaqi viha Iekopirainiqama vura. Mintiaqi viha Iekopira sipisipi vika airiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Iekopiva tavovaro memeraa nahe koqeva qora hampata nireva auti vauvaro viva vira vita varero katari aratora tataaqa qaraarire tiro, vita vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Memeraa nahe kia kempuka vauka qora hampata nireka auti vauvaro Iekopiva vika qaqi kanta komanta qaramaqi vi vaurama. Mintiaqi vuraqaahairo uqerara memeraavano Labaanirainiqama vuvaro koqe memeraa kempukavano Iekopirainiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Minturaqaahai Iekopira sipisipi memeraa airiqama vuvaro Iekopiva airi haika vato vaiintiva vaumanta vira kaiqa vaiintive, kaiqa nahentive, kamerive, donkive, airitahaa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Iekopiva vaiharo irumanta Labaanira maaqunavu nuntu nauntu tiha, Oho, Iekopiva ekaa tinavu qova i haikarama varaivo. Iekopiva tinavu qova i haikara varairaqaahairo noraiqama vivo, ti. ");
INSERT INTO tbg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Minti tuvaro Iekopiva tavovaro Labaanivavata kia tota virara quahontema kero, virara quaheharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mintuvaro Noravano Kotiva Iekopirara tiharo, Ho are nena qora maaqaini anirantera vuane. Are mini viraqe te ai kahaqama amiteha ainti vairarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kotiva minti tuvaro Iekopiva nai sipisipi memeraaqaa raqikiharo nai naatatanta Riaaka Reserika naarama kero ");
INSERT INTO tbg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","vitantara tiharo, Nitanta qova kia tota quahaintema kero, tiriara quaheharo vaivo. Ho Kotiva ti kahaqama timite vaimanta vaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Te nitanta qora koqemake kaiqa vara amitauraro ");
INSERT INTO tbg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","viva unaqaraiqama keharo vo enta vo enta kia ti koqaa avuqavu timi vairave. Viva ti qoraiqama timitareva auti vaivarovata, Kotiva kia vira qaqi kaivaro viva kia ti qoraiqama timitaivo. ");
INSERT INTO tbg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Viva tiriara tiharo, Kaakantaarira memeraaqaima ai koqaa varianarove, tu entara vira memeraavano kaakantaarira vatatomanta te varaunarave. Viva qarantaurira memeraaqaima ai koqaa varianarove, tu entara vira memeraavano qarantaurira vatatomanta te varaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mintima keharo Kotiva ti kahaqama timiteharo nitanta qora sipisipi memeraa ti timirave. ");
INSERT INTO tbg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Qoravano nahe hampata nu entara te taira tavauramanta qora memeraa vaakuvirive, qarantaurirave, kaakantaarirave, vinavuka nahe hampata ni vaura. ");
INSERT INTO tbg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ho te taira tave vauraro Kotiva atito enseliva tiriara tiharo, Iekopio, tumanta te tiha, Vo, te mainima vauro, turaro ");
INSERT INTO tbg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","viva tiriara tiharo, Ho tavaane. Qora memeraa vika vaakuvirive, qarantaurirave, kaakantaarirave, nahe hampatama ni variavo. Labaaniva ai qoraiqama amite vaira te tavaunarara ti, te ai memeraa airiqama karerave. ");
INSERT INTO tbg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Haaru are Beteli vataini variaramanta te qovarama vura Variqauka te maa vikave. Vi entara are ori vo vataqi aratera vahavera viraqaata qihia kera nena kauqu aiqiqaa aqukehara tiriara uva tiva taanarave. Ho te vate ariara, Maa vatara kera anirantera nena maaqaini vuanerama, turo, tiro. Kotiva ˻enseli noqihairo˼ minti tumanta te taira tavaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Iekopiva minti tumanta Reserika Riaaka Iekopirara tiha, Titanta qova ina haikaraqihai kiama tetanta vo haikavata ho varaainarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Vo vatanaa nahenti qoraiqama nimitaintema kero, viva titantavata qoraiqama timitaivo. Ike, are titanta varehara amiana koqaara, ekaa vi koqaara naiqai nama kairave. ");
INSERT INTO tbg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kotiva vira airaira varakero ai amira, vira kia titanta qova nai iravauve. Vi airairava vaireva, titantainivata titanta vaintairavata airairama vaivo. Mintima vairara tira, are Kotiva ti uvara avataane, ti. ");
INSERT INTO tbg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Vitanta minti tuvaro Iekopiva nai naata vainti vika kameriqaa vaari vatero, ");
INSERT INTO tbg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","nai sipisipi memeraa avuni kero ruhaaqiqi viharo, Haraanini vaiharo varato airairara, ekaa vi haikaravata rumpa varero, nai qova Aisaakiva Kenaani vataini vaunaini vireva vurama. ");
INSERT INTO tbg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Vi entara Labaaniva vonaini nai sipisipi kauki toqa kareva vuvaro Reseriva virera iharo, oru nai qova ura oritanta, variqave tutanta, muara varero vura. ");
INSERT INTO tbg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iekopiva vireva iharo kia Labaanira tiva amiraitiro, evaara ");
INSERT INTO tbg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","oru nai u haikara varero ruqemakero vurama. Viva oru Iufaretisi Namari taqa varero verara Gileaati vatainiara vurama. ");
INSERT INTO tbg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Iekopiva evaara vuvaro taaramo enta aitarovaro vovano Labaanira vuru tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labaaniva nai navunaaka ntita varero 7 entara Iekopira avataqiro viviro, tavovaro Iekopiva verara Gileaati vataini vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","entama vuvarora tiro, Labaaniva vaiteharo taira tavovaro Kotiva virara tiharo, Are raurihara kiama oru Iekopira antua uva tiva amitaane, tura. ");
INSERT INTO tbg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ho Iekopiva nai seri naavu Gileaati aiqinaini kaqatero vauvaro Labaanivavata nai navunaaka hampata mini nái seri naavu kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Mintuvaro Labaaniva oruntero Iekopirara tiharo, Are nantivarae evaara viharama vaiintivano iqoka raqiharo nahenti raqia varaintema kera, ti raavuratanta ntita varera maini aniaro? ");
INSERT INTO tbg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nantivarae are ti unaqaraiqama kera evaara aiqu aututera aniaro? Are ti tiva timira tenta maaqaini virerave tiaraitirio, te ariara kara unta amite, ihi tiva amite, ai quahama amiteha ai atitauraitirio. ");
INSERT INTO tbg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Are vireva ihara qaqi kairaqe te tenta raavuratantavata tenta naintinavuvata moqake kauqu nimi nititaari vuataara vaivara, are kia mintiraitira, kia avu aato vataava voqaara uve ntitakera anianarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Te ho ai qoraiqama amitaare turarovata, ai qora Variqavano tairakaa ti tiva timiro tiharo, Are raurihara kiama oru Iekopirara antua uva tiva amitaane, tivera te virara irihama kia ai qoraiqama amitarerave. ");
INSERT INTO tbg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Te irurara are nena qora maaqaini vireva iharama ti maini kera iaro. Ho nantivarae are vireva ihara ti variqatanta muara varera aniaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Labaaniva minti tuvaro Iekopiva nai tiva amiro tiharo, Te ariara viva kempukaiqiharo nai raavuratanta tiqaahairo ravaaqavu kaantorave ti, ai aatu qetakema maini evaara anuro. ");
INSERT INTO tbg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Are tavairaro vovano ai variqatanta muara varaiva vairera, vi vaiintiva kia ho qaqi variqiro vuanarove. Ekaa vaiinti nahenti nivuqaa vaihara vi haikara rantaqira vuane. Are tavairaro are ina haikava vairera, nena varaane, tiro. Iekopiva kia iruvaro Reseriva una variqa vitanta muara varova vaura. ");
INSERT INTO tbg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Iekopiva minti tuvaro Labaaniva Iekopira seri naavuqi verantero tavovaro kia viraqi vauvaro Riaara seri naavuqivata vitanta kaiqa nahenti seri naavuqivata verantero tavovaro kia viraqi vauvaro Reserira seri naavuqi verantora. ");
INSERT INTO tbg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Reseriva una variqatanta varakero nai kameriqaa oquvi vau taintaraqi kukeqatero, tainta vira nai seri naavuqi vuru vatero viraqaata oquvi vauvaro, Labaaniva viraqi oriqetero ekaa haikaqi qumina ranteharo tavovaro kia vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Reseriva tiharo, Qaao, are maaqi uriqetaaramanta te kia himpiraiti, ai avuqaa qaqi oquvi vaunara kaara kia ti titiane. Toravano ti harimanta te oquvi vauro, tiro. Minti tivakero oquvi vauvaro vira qova vi haikarara qumina rantaqiro viharo kia ho ranta kora. ");
INSERT INTO tbg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Labaaniva kia vi haikara ranta kovaro Iekopira arara itovaro Labaanirara tiharo, Te nana vaaqu kaiqa vara kaunara kaarae are mintira iaro? Te nana uva raqa kaurarae are ti tivataqira aniaro? ");
INSERT INTO tbg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Are ekaa te una haikaraqi rantehara nana haikae ranta kaaro? Vi haikara nena navunaakavata, ti navunaakavata nivuqaa qovarama kaira tavaate. Vika titanta uva homa rairake avuqavu qivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Minti tivakero Iekopiva qaiqaavata tiharo, Oho, te ainti vaiha 20 ihi vara kaunarave. Te ai sipisipi memeraaqaa koqemake raqiki vauramanta vika kia hampiqamake naati vatorave. ");
INSERT INTO tbg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Qaakau vairivano ai sipisipi vonavu aruko entara, kia te ai umiqeha tiha kia ti kaarave tiraiti, te tenta unaraqohai vira vatukara iriha ai amunarave. Entaqive aatitoraqaave vokuka ai sipisipi memeraa muara varaa entara, are tiqihaira koqaa naaruma kera varaanarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Oho, te ai sipisipi memeraaqaa raqiki vauraro aatitairaqaa kuarivano voqama kero ti tatoqe vaivaro, entaqi iqaravanove toqavanove ti hari vaimanta kia ho vaite vaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Te mintiaqi viha 20 ihiara ai kaiqa vara amitaunarave. Te ai raavuratantara iriha 14 ihiara ai kaiqa vara amite, viraqaahai ai sipisipi memeraara 6 ihiara ai kaiqa vara amitaunarave. Are tiriara ti sipisipi memeraa airi varaantorave tira, votataa votataa are ti koqaa teqake varianarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Oho, ti kaivaqara Variqavano Eparahaamiraqaavata ti qora Aisaakiraqaavata raqiki vaiva kia ti kahaqitirio, are ti vehi vaiinti voqaarama titiaraitirio. Te vukaari utuke kaiqa varaunarara Kotiva iriharora tiro, viva entaqi ai atiharo tiriara kia virara antua uva tiane tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Iekopiva minti tuvaro Labaaniva vira nai tiva amiro tiharo, Ike, vi nahentitanta ti raavuratantama variavo. Maa vaintinavuka ti vaintima variavo. Maa sipisipi memerauka te uraukama variavo. Ekaa are tave variana haikava te una haikavama vaivo. Kia te tenta raavuratantavata tenta naintinavuvata nitirerave. ");
INSERT INTO tbg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kaiqetanta vohaa uva tiva taatauke vatetanta maateraiqamavi qaqi variare. Tetanta vi uvara tauru kaarorave ti, kaiqe ori varake naiqaa naiqaa rukitaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Labaaniva minti tuvaro Iekopiva nora ori vo varakero vataqi aratero ");
INSERT INTO tbg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","nai navunaakara, Nevata ori mpaqi vare maini rukitaate, tumanta vika orinavu mpaqi vare vuru vohaanaini rukite, viraqaahai vika ori rukitora tataaqa vaiha kara nora. ");
INSERT INTO tbg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labaaniva nai Araami uvaqihairo vi orira autu nteharo, Jega-Sahadutave tuvaro Iekopiva nai Hiparu uvaqihairo vi orira autu nteharo Galetive tura. ");
INSERT INTO tbg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Minti tuvaro Labaaniva tiharo, Tetanta uva tiva taurava qaqi variqiro vuarire ti, tetanta maa orinavura ruki tauro, tura. Viva minti turara ti, vi oriranavura autu nteha Galetive – Taurukerorave tura. ");
INSERT INTO tbg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labaaniva minti tivakero viva qaiqaa tiharo, Maa entaraqaahai tetanta kia vohaa vairaiti, raira vuariraro Noravano Kotiva titantaqaa raqiki vairaqe tetanta kia nai qoraiqama amite nai qoraiqama amitararave, tura. Labaaniva minti turara ti, vi orinavura vo autuvata nteha Misipaave – Raqikiane tura. ");
INSERT INTO tbg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labaaniva minti tivakero viva qaiqaa tiharo, Are ti raavuratantae qoraiqama nimitairerave, are vo nahentie varairerave, are mintirera, te virara kia ho iriarirarovata, Kotiva titantaqaa raqiki vaiva, vivama virara ho iri tavaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labaaniva minti tivakero viva vo uvavata tiharo, Tetanta maa orira arate maa orinavura mpaqi vare vuru ruki taurava titanta tavaarana vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tetanta uva tiva taatau taunara tauru kaarorave ti, maa orira arataunaravata vo orinavuvata ruvaaqumake vatauro. Te maihai kia maa orira aatarake ai oru qoraiqama amitarerave. Arevata vihaira kia maa orira ai aatara kera ani ti qoraiqama timitenarave. ");
INSERT INTO tbg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kairaro Eparahaamika Nehoka Variqavano titantaqaa raqiki vairaqe tetanta kia nai qoraiqama amite nai qoraiqama amite irerave, tiro. Labaaniva minti tuvaro Iekopiva nai kauqu aiqiqaa aqukero tiharo, Ti qova Aisaakiva qete vai Variqara autuqaa te are uva tiva taanara iriqi virerave turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Minti tivakero viva aiqina vataini vaiharo nai ˻sipisipi˼ vo arukero Kotira ofaa iha quara amitero, nai navunaaka naarama kero vika hampata kara nama kero mini vaitora. ");
INSERT INTO tbg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Vika mini vaite vira qararaa Labaaniva himpiro nai naintinavuvata nai raavuratantavata moqakero nai kauqu tuaherakero vika koqema nimitero, vika mini kero anirantero nai maaqaini vurama. ");
INSERT INTO tbg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Labaaniva nai maaqaini anirantero vuvaro Iekopiva aaraini viharo tavomanta Kotiva nitito enselika vira vita kareka ani vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Iekopiva vika tavero tiharo, Ike, maini Kotira seri naavu maaqa kaqate varianainive, tivakero vi vatara autu nteharo, Mahanaiminive, tura. ");
INSERT INTO tbg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Iekopiva nai kaiqa vaiinti vonavu naane nititomanta vinavuka vira vakaava Isova Seiru vataini vaunaini vura. Vi vatava Idomu vata avutaini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Iekopiva nai kaiqa vaiinti vonavu nititareva iharo tiharo, Ne mini oruntema ti nora vaiinti Isorara maantimake tiriara tiate: Te Iekopika ai kaiqa vaiintivano Labaanikanti variqi vi, vate vihaima anuro. ");
INSERT INTO tbg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Te purumakauve, donkive, sipisipive, memeraave, kaiqa vaiintive, kaiqa nahentive, vatauraukave. Are tiriara quahaane ti, te maa uvara vara kauro, tiate. Ne mintimake Isora tiva amiate, tivakero vika nititomanta vika vuru vi uvara Isora tiva ami ");
INSERT INTO tbg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","vihai orurante viri Iekopirara tiha, Tenavu ai vakaaka Isora vuru tiva amuraro viva ai vita kareva airi vaiinti 400 vaiinti hampata ani vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vinavuka minti tuvaro Iekopira voqama kero aatu itovaro viva ekaa nai vainti nahentivata, sipisipive, memeraave, purumakauve, kamerive, vikavata rairakero taaraqantaqaa vatero ");
INSERT INTO tbg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","tiharo, Isova maini ani hini vainti nahenti hampata raqirera, ne hini vainti nahenti ruqemake kantama vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Minti tivakero viva Kotira aarero tiharo, Mpo, Kotio, are ti naaqura Eparahaamiravata ti qora Aisaakiravata vitanta Variqavano variaro. Noravauvo, are tiriara, Nena maaqaini oru vairaqe te ai koqema amitaarirara are koqemakera variqira vuane, tianarave. ");
INSERT INTO tbg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Oho, te kia koqe vaiinti vaurara are ti nena kaiqa vaiinti koqema timitera kia ti qaqira kaanarave. Haaru te maihai Iotani Namari taqa vare vuavauna entara te kauruqai tuata vare vuavaunarave. Are ti kahaqiaravera te vihai aniha taara anku hampata anuro. ");
INSERT INTO tbg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ti vakaara Isora kauquqihaira ti antuara timitaanerama te ai aarauro. Oho, viva anintero kia tiqai hariraitiro, viva ti vainti nahentivata ntaihama kaantorave ti, te qetehama vauro. ");
INSERT INTO tbg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Are haaru tiriara tihara, Te ai koqema amitaarirara are koqema kera vairamanta are kuvuarama teraukavata airiqamavi nora namari auvahini vai nuqara voqaara airitahaa vaivarave tianarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Iekopiva minti tivakero vaitero vira qararaa himpiro nai quaranavuqihairo vonavu rairakero Isora maantimakero amitero: ");
INSERT INTO tbg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Memeraa nahe 200, memeraa qora 20navu, sipisipi nahe 200, sipisipi qora 20navu, ");
INSERT INTO tbg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kameri nahe nai naati vataakero 30navu, purumakau nahe 40navu, qora 10navu, donki nahe 20navu, qora 10navu rairakero amitora. ");
INSERT INTO tbg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Mintima kero vo quara vo quara rairakero voqaa voqaa vatero, nai kaiqa vaiinti vo atitero tiharo, Are naane maanavuka varera vuru Isora amiane, tivakero, qaiqaa kaiqa vaiinti vo atitero tiharo, Are vira naantiara maanavuka varera vuru Isora amiane, tivakero qaiqaa kaiqa vaiinti vo atitero tiharo, Are maanavuka varera vuru Isora amiane, tivakero minti tivaqiro viharo nai kaiqa vaiinti vohaiqa vohaiqa nititomanta ekaa vinavuka quara vare vuru Isora amireka vura. ");
INSERT INTO tbg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Iekopiva vika nititeharo avuni atito vaintirara tiharo, Are viraro Isova ani ai vitakero ariara, Tara kaiqa vaiintivanove? Are taini virevae aniaro? Are tara quarae ruhaaqi varera ani variaro? tirara ");
INSERT INTO tbg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","are nai mintima tiva amiane, Ai kaiqa vaiinti Iekopiva irave. Iekopiva ti tititaimanta te vi haikara vare vuru vira nora vaiinti Isora amirerave. Iekopiva tinavu naantiaraini ani vaivo. Minti tivakerama Isora tiva amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Minti tivakero Iekopiva vo vaiinti vo vaiinti nititero vikaravata tiharo, Nevata Isora oru vitake vohaa uvaqaima Isorara tiate. ");
INSERT INTO tbg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ne kiama tauruke tiha, Ai kaiqa vaiinti Iekopiva tinavu naantiaraini ani vaivo, tiate, tiro. Iekopiva minti tivakero nai irikero tiharo, Te vo quara vo quara naane Isora amiariraro vira arara vaahaarire. Mintiraqe vira naantiara te oru vira vita kaariraro viva quqaae tiriara quahaanarove? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Minti tivakero Iekopiva quaranavu naane avuni vara kero nai kia viraitiro, mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Iekopiva mini vaiharo vohaa vi entara entaqi himpiro nai naatatantavata, nai naata kaiqa nahentitantavata, nai maaqu 11navuvata, ntita varero Jaboku Namari taqa varero ");
INSERT INTO tbg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","vika hini mantaraini ntita vuru kero, viraqaahairo viva orurantero ekaa nai airaira namari hini mantaraini vuru kaate tumanta vuru kovaro ");
INSERT INTO tbg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","viva nariaraa hini mantaraini vaura. Iekopiva mini vauvaro ˻naaruvaihainaa˼ vaiinti vovano oruntero Iekopira ravaaqavu tuateharo vikantiro raquqiro viviro aatita kora. ");
INSERT INTO tbg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Raquqiro viharo vi vaiintiva tavovaro viva kia ho Iekopira aatara kaarirava vauvaro viva vira onkerura vuhaari ntuva kovaro Iekopira auka/auika vuhaari nkaqu vuvaro aiha vuvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mintuvaro vi vaiintiva Iekopirara tiharo, Ho aatitama vivo. Ti tuta kaane, tuvaro Iekopiva aqao tiro, Are nena kauqu tuaherakera ti koqema timitairaqe te ai tuta kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Minti tuvaro vaiinti viva Iekopirara tiharo, Ho nena autu ntaane, tuvaro Iekopiva tiharo, Te Iekopikave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","vaiinti viva tiharo, Kia qaiqaavata Iekopirave tiane. Are Kotiravata vaiintivata raquqira vihara aatara kaanarara ti, te ariara Isarerirave – Kotikantiro Raqi Vaivave tirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Minti tuvaro Iekopiva virara tiharo, Are nena autu ntaane, tuvaro viva aqao tiro, Nantiharae ti hutuara iraaro? tivakero kia nai autu vira tiva amiraitiro, nai kauqu tuaherakero Iekopira koqema amitero ");
INSERT INTO tbg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","vuvaro Iekopiva tiharo, Te Kotira viri tave vauraro ti vehakuma timitaimanta kia te qutu viraiti qaqi vaunarara ti, te maa vatara autu nteha Penierive – Kotira Virive turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Minti tivakero Iekopiva Penieri mini kero aaraini vi vauvaro kuari uruntovaro vira auka/auika ntuva kora kaara aiha vuvaro rentuqaa rentuqaamaqiro vura. ");
INSERT INTO tbg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Iekopira auka/auika ntuva korara ti, maa entara Isareri vatanaaka mati neha auka/auika tataaqa vai matira kia naara. ");
INSERT INTO tbg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Iekopiva aaraini oru viharo vutu tavovaro Isova 400 vaiinti hampata ani vauvaro Iekopiva nai vainti rairakero hininavu Riaara amiro, hininavu Reseriravata vira kaiqa nahentitantavata nimura. ");
INSERT INTO tbg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Viva avuni nai kaiqa nahentitantavata vitanta vaintivata vatero, vika naantiara Riaaravata vira vaintinavuvata vatero, vika naantiara vitini Reseriravata vira vainti Iohepiravata vatora. ");
INSERT INTO tbg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mintima kero Iekopiva naane avuni oruntero tori kauru araviro nai viri vataini kero himpiro, qaiqaa ori vaiqiro tori kauru araviro nai viri vataini kero himpiro, 7 tataa mintiaqiro viro, oru nai vakaara vita kora. ");
INSERT INTO tbg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Iekopiva mintiaqiro vi vauvaro vira vakaava Isova kantero oru nai qata Iekopira vitakero vira kukuqama kero vira moqakero vatero, vitanta vohaatanta vaiha nai iqi rata amite nai iqi rata amite i vaura. ");
INSERT INTO tbg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mintiharo Isova vutu tavomanta Iekopira vainti nahenti vauvaro viva Iekopira irero, Vitira taukae ai hampata aniaka variavo? tiro. Isova minti tuvaro Iekopiva nai tiva amiro tiharo, Vika Kotiva tiriara quaheharo ti timi vainti nahentikave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Minti tumanta Iekopira kaiqa nahentitanta nái vainti hampata aumanto aninte vatakanta hiqintivi vaiha nai viri vataini keha Isora uva mantomanta ");
INSERT INTO tbg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","vika naantiara Riaava nai vaintiaravata aninte vatakanta hiqintivi vaiha vikavata nái viri vataini ke vira uva mantomanta vika naantiara vitini Iohepika Reserika aninte vatakanta hiqintivi vaiha náitanta viri vataini keha vira uva mantora. ");
INSERT INTO tbg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Vika vira uva mantovaro Isova Iekopira irero tiharo, Te aaraini aniha vo quara vo quara tavaunarara vo? Vi quarauka tara quarave? tiro. Minti tuvaro Iekopiva tiharo, Are ti quahama timitaane ti, te ai amitauna quaraukave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Minti tuvaro Isova aqao tiro, Ti qatao, te airi haikama vatauro. Nena ina haikara qaqi tuataane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Minti tuvaro Iekopiva tiharo, Aqao, are tiriara quahairera, are vi quarara varaane. Are ti vitakera ti quahama timitaanarara ti, te Kotira viri taveha quahaunantema ke, te ai virivata tavehama quahauro. ");
INSERT INTO tbg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kotiva ti koqema timitaimanta te airi airaira vataunarara tira, are te quara amitaainara homa varenarave, tiro. Minti tivakero kempukaiqaakero tuvarora tiro, Isova Iekopira quara varora. ");
INSERT INTO tbg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Mintima kero Isova tiharo, Varaiqetanta vuare. Te ainti aaraini virerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Minti tuvaro Iekopiva aqao tiro, Nora vaiintio, are naane viraqe te ai naantiara vuare. Ti vaintivara uqerara vainti variamanta ti sipisipive purumakauve nái naati hampata kia ho kantevarave. Tenavu vohaa entara vika vuanamake ruhaaqiqi vuarera, vika qutuma vivarave. Virara virara irihama te qakomake virerave. ");
INSERT INTO tbg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nora vaiintio, are naane avuni vi vairaqe te qakomake ai naantiara quara ruhaaqiqi viha tenta vaintaira hampata qakomake varika varikamaqi vivi, are vainanaini Seiru vataini oruntarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Minti tuvaro Isova tiharo, Ho kaiqe te tenta vaiinti hininavu raira kaari vika ai hampata viha ˻ni antua nimitaate˼, tuvaro Iekopiva aqao tiro, Nantivarae mintiaro? Are tiriara quahairera, qaqi kairaqe te tentaraa vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Minti tuvaro vohaa vi entara Isova nai kaiqa vaiinti hampata anirantero Seiru vataini vireva uvaro, ");
INSERT INTO tbg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Iekopiva kia mini viraitiro, qakoma kero viviro vata vo, Sukotini oruntero mini vaiharo nai naavu vo kaqatero, nai quarara haraara naavu, vo naavu vo naavu kaqa nimitora. Iekopiva minturara ti, vi vatarara, Sukotive – Haraara Naavuve, tura. ");
INSERT INTO tbg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Iekopiva Mesopotemia mini kero niara aaraini viviro, Kenaanini oruntero Sukotini varikero, viraqaahairo oru vatuka vo, Sekemi aaqaini vaiharo nai seri naavu maaqa kaqatero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Viva mini vaiharo 100 silvaa monu aqukero vata vo varora. Sekemira qora Hamora ankuqaahairo vi vatara koqaama kero varero ");
INSERT INTO tbg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kotira autu tuahera kareva, ofaa tainta vo autukero vira autu ntero, El Elohe Israel – Kotiva Isareri Variqavano Vaivo tura. ");
INSERT INTO tbg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Iekopiva Sekemini vauvaro Riaara raavuravano Dainaava vi vatanaa nahentinavu tavareva vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamova Hivi vatanaaka qiata vaiinti vauvaro vira maaqu Sekemiva Dainaara tavero vira ravaaqavu kero vikantiro muara niro. ");
INSERT INTO tbg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Vikantiro nuvakero, viva virara koqe nahentive tivakero virara antuqa aruvaro Dainaava tiriara hantuqa haruarire tiro, virara qihaaqama kero uva tiharo ˻nai naavuqi vita vuru kero˼ ");
INSERT INTO tbg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","oru nai qora Hamorara tiharo, Are oru maa nahentira navunaaka hampata vaihara koqaa autukera vika nimiraqe te maa nahentira varaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Minti tuvaro Iekopiva nai raavura qoraiqama amitorara iriro, vira maaqunavu ahakaqi quaraqaa raqiki vauvarora tiro, viva qihaaqama kero vaiharo nai maaqunavu veka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ho vika quaraqaa raqikunaihai anintovaro Sekemira qova Hamova anintero Iekopira vataakero uva tireva anura. ");
INSERT INTO tbg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Hamova anintero Iekopira vataakero uva ti vaumanta Iekopira maaqunavu Sekemiva Dainaara qoraiqama amitorara iruvaro voqama kero vika arara itomanta vika tiha, Oho, Sekemiva Iekopira raavura kia mintimakero qoraiqama amitaataarave, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamova anintero Iekopirara tiharo, Ti maaqu Sekemira muntukavano ai raavurara vaivo. Are vira amiraro vira naata variarire. ");
INSERT INTO tbg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ne maini vaiha tinavu nahenti varaiqe tenavu ni nahenti varaare. ");
INSERT INTO tbg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ne homa maini airi enta variqi vivarave. Maa vataraqaa ne homa nenta quaraqaa raqikivarave. Maini variqi viha koqaa kaiqa vareha vo vata vo vata koqaamake varaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Minti tuvaro vira maaqu Sekemiva Dainaara qoraravata vira qata vakaukavararavata tiharo, Ne tiriara quaheha Dainaara ti timivera, te ne tivate koqaara ni nimirarave. ");
INSERT INTO tbg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ne nora koqaa naarivera, te vi koqaara homa ni nimirarave. Mpo, vi nahentira ti timiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sekemiva minti tumanta Iekopira maaqunavu nai aura nakaa qoraiqama amitora kaara vika arara itomanta unaqaraamake uqerara uva tiha, ");
INSERT INTO tbg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Tenavu vaata toqa kaakama vauro. Vaiinti vovano kia nai vaata toqa kainara tenavu kiama ho tentanavu aura Dainaara amirarave. ");
INSERT INTO tbg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ne qorainti nenta vaata toqa kaiqe, viraqaahai tenavu niara tinavu voqaaka variavo tivakeha ");
INSERT INTO tbg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","tentanavu raavura ni nimiha, ni raavura tenavu varaare. Ne mintiqe tenavu ni hampata variqi viha vohaa vatanaaka variare. ");
INSERT INTO tbg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ne kia tinavu uvara eo tivake nenta vaata kia toqa kaivera, tenavu Dainaara kia ni nimiraiti, tentanavu qaqi vita vare virerave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Iekopira maaqunavu minti tumanta Hamovavata vira maaqu Sekemivavata vi uvarara hove tura. ");
INSERT INTO tbg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekemiva Iekopira raavurara muntuka vauvarora tiro, viva kia varikaraitiro, vaaka nai vaata toqa kora. Sekemira navunaaka virara nora vaiintive ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamova nai maaqu Sekemikantiro oru nái navunaaka vatuka vaantaavura qentiana ruvaaqumavi vaunaini orunte vikara tiha, ");
INSERT INTO tbg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Vi vaiintika tinavuara quahehama variavo. Ne vika qaqi kaimanta maini ho vi aniate. Maini nora vata vaimantara ti, vikavata homa tinavu hampata vaivarave. Homa tenavu vika nahenti varaari vika tinavu nahenti varaate. ");
INSERT INTO tbg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Vika vohaa uvaqai kempukaiqaake tiha, Ne qorainti tinavu aanante nenta vaata toqa kaate, tiavo. ");
INSERT INTO tbg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kaiqenavu mintiake tentanavu qorainti vaata toqakeha, vika nahenti varaqi viha vika airairavata quaravata varaare, ti. ");
INSERT INTO tbg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hamoka Sekemika minti tumanta ekaa vi vatanaaka hove tivake ekaa qorainti vika vaata toqa kora. ");
INSERT INTO tbg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Qorainti vika nái vaata toqa kovaro taaramo enta aitarovaro vika qaqiqai aihavi vaumanta Dainaara vakaatanta, Simionika Rivaika iqoka paipe varetanta vika vatukaqi oruntomanta vi vatanaaka vitanta tave qaqima aniavo tumanta, vitanta oru vatuka viraqi vi aniha ekaa qorainti aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Simionika Rivaika oru Hamora nai maaqu Sekemira vataake aruke, Sekemira naavuqihai náitanta aura Dainaara vita vare vumanta ");
INSERT INTO tbg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Iekopira maaqu hininavu orunte nái aura nakaa qoraiqama amitora kaara vi vatukaraqihai vo airaira vo airaira varora. ");
INSERT INTO tbg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Vi vatanaaka sipisipive, purumakauve, donkive, vika vare, ekaa vatukaqi vau haikarave, aaqaini vau haikarave, ");
INSERT INTO tbg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ekaa vi vatanaaka vato airairara vare, ekaa vika nahentivata vaintivata, ekaa naavuqi vau haikaravata, vare vura. ");
INSERT INTO tbg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mintuvaro Iekopiva Simionika Rivaika nitiharo vitantara tiharo, Netanta mintihama nora uvama tiqaa vataavo. Maa vataraqaa variaka Kenaani vatanaakave Peresi vatanaakave tiriara vaaqu vaiintivema tivarave. Tenavu kiama airi vaiinti vauro. Ekaa vi vatanaaka avitumavi tinavu hampata raqireka autivera, vika homa tinavu vehi autu taiqa kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Iekopiva minti tumanta vitanta tiha, Aqao, hampi nariro ni vai nahentira hampata nuantema kero, vi vaiintiva titanta aura hampata ni vairara are virarae hove tiaro? ti. Vitanta minti tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Iekopiva ˻Sekemini˼ vauvaro Kotiva virara tiharo, Himpira oru Betelini variane. Mini oru vaihara ofaa tainta vo ti autu timitaane. Te Kotikave. Haaru are nena vakaara Isora aatu qetakera aaraini vihara Betelini vaitaaramanta te ai avuqaa qovarama vunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kotiva virara minti tuvaro Iekopiva nai vainti nahentiaravata, vira hampata vaukaravata, tiharo, Ne una variqa haika vataarave, nenta avu aatoqi qora kaiqa varera iritera qaqirake, namari tuntuke koqe utavaaqa nonkute ");
INSERT INTO tbg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","vare aniqenavu Betelini vuare. Te mini oru vaiha Kotira ofaa tainta vo autu amitarerave. Haaru te nora maaraqi variavauraro Kotiva ti uva iriharo ti kahaqama timitorave. Te vo vataini vo vataini variavauraro Kotiva tintiro vaiharo ti kahaqama timite vaurave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Iekopiva minti tumanta vika nái una variqa haika vatorave, ˻hepi kaiqa varerara iriha˼ nái aatoqi ukuto ringirave, vi haikara vi haikara Iekopira amuvaro Iekopiva ekaa vi haikara varero muntu Sekemini oqiva okaraqi quntama tora. ");
INSERT INTO tbg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ho mintumake vika ekaa aaraini vi vauvaro Kotiva mini vo vatuka vo vatukaqi vauka qetara haika nimimanta vi vatanaaka kia vika ntataqi viraiti, qaqi mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Iekopiva ekaa nai navunaaka vataakero oru viro Lusi vatuka Kenaani vataini oruntora. Lusi vatuka vo autu Betelive tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Haaru Iekopiva nai vakaara aatu ruqemakero aaraini viharo mini vaitovaro Kotiva vira avuqaa qovarama vurara tiro, Iekopiva ofaa tainta vo autukero vira autu nteharo, Eli Betelive – Kotiva Betelini Vaivo, tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Vika mini vauvaro Rebekaara kaiqa nahenti Deboraava qutu vumanta vira Beteli oqiva okara muani muntu quntama tora. Vira quntama to vatara autu nteha, Aloni‑Bakuti‑Iqi Rata Amito Oqivarave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iekopiva Mesopotemia vataihairo orurantero Kenaanini ani vauvaro Kotiva vira avuqaa qaiqaa qovarama viro vira koqema amitero ");
INSERT INTO tbg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","tiharo, Ai autu Iekopirave. Vaiinti nahenti kia ariara qaiqaa Iekopirave tivarave. Vika ariara Isarerirave tivarave, tiro. Minti tivakero Kotiva vira qaraaka autu ntavateharo, Isarerirave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Minti tivakero Kotiva qaiqaa tiharo, Te Kotika ekaa kempuka vataukave. Are kuvuaramaqira viramanta ai vaintivara airiqamaqi vuate. Ariqihai vo vatanaa vo vatanaaka qovarama vivarave. Ariqihai hininavu avuhainaa vaiinti qovarama vivarave. ");
INSERT INTO tbg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Te Eparahaamika Aisaakika nimuna vatara, vi vatara aivata amiariraro vi vatava aini vaiharo are kuvuarama terauka vika vatavatama varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Minti tivakero Kotiva tuvurantero naaruvaini vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Iekopiva Kotiva vikantiro uva ti vaunaini nora ori varakero aratero, ofaa autu amitareva iharo, uainivata vahaveravata viraqaata qihia kero ");
INSERT INTO tbg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kotiva vikantiro uva tu vatara autu nteharo, Betelive – Kotiva Vainainive, tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Vika Betelini variqi vi, viraqaahai katu vare Efaraata vatukaini vireka aaraini vi vauvaro Reseriva vainti vatareva iharo kia vaaka vataraitiro, ");
INSERT INTO tbg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","noraiqaakero ke ke ti vauvaro vira kahaqu nahentiva virara tiharo, Reserio, kia qetaane. ");
INSERT INTO tbg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Are qorainti vaintima vatataaro, tuvaro Reseriva qutuarirava aumaiquvaro viva nai maaqu vira autu nteharo, Benonirave – Ke Ke Tiha Vatataunarave, tura. Minti tivakero Reseriva qutu vuvaro Iekopiva vi autura qaqira kero vo autu nteharo, Benaminirave – Ti Kauqu Tanaraini Vairave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Reseriva qutu vumanta vira vaata Efaraataini vi vau aarara auvahini quntama tora. Maa entara Efaraata vatuka vira vo autu nteha, Betarihemive, ti variara. ");
INSERT INTO tbg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Reserira quntama toraqaa Iekopiva ori vo vaavi aratora. Maa entara vaiinti nahenti vi orira taveha, Reserira quntama toraqaave, ti variara. ");
INSERT INTO tbg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isareriva ˻vira vo autu Iekopiva˼ qaiqaa katu varero oru Mikatari-Ede vatuka vututoqama kero nai seri naavu maaqa kaqa tero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Viva mini vauvaro vira maaqu Rubeniva nai qora naata, Bilihaara ˻Reserira kaiqa nahentintiro˼ nuvaro vira qova vi uvara irura. (Okara 49:4) Iekopira maaqu 12navu vaura. Vika nutu vaireva, maantimama vairo: ");
INSERT INTO tbg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Riaara maaqunavu: Rubeniva (Iekopira maaqu hoqarenaara kara hunka) Simioniva, Rivaiva, Iutaava, Isakaava, Sebuluniva ");
INSERT INTO tbg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reserira maaqutanta: Iohepika Benaminika ");
INSERT INTO tbg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Reserira kaiqa nahenti Bilihaara maaqutanta: Daanika Napataarika ");
INSERT INTO tbg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Riaara kaiqa nahenti Siripaaraqaa vatatoka: Gaatika Aseka Iekopira maaqu 12navu mintimake vaura. Iekopiva Mesopotemia vataini vaiharo vi maaqunavuka vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iekopiva vihairo nai qova Aisaakiva vaunaini Mamarera Oqiva vauraqi Hebaronini anintora. Vi vatava Eparahaamika Aisaakika vau vatava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Iekopiva mini ani vauvaro vira qova Aisaakiva 180 ihi varakero qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Viva anoma kero naampaiqama viro qutu vumanta vira maaqutanta Isoka Iekopika vira quntama tora. ");
INSERT INTO tbg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Isova vira vo autu Idomuvave – Naarevave tuva vauvaro vira anku maantima vaura: ");
INSERT INTO tbg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isova Kenaani nahentinavu varatovaro nahenti vo, Adaava vauvaro vira qova Hitihainaava Eloniva vaura. Isora nahenti vo, Oholibaamava vaura. Oholibaamara qova Anaava vauvaro vira naaquva Hivihainaava Sibeoniva vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Isora nahenti vo, Basemaativa vauvaro vira qova Isamairiva vaura. Basemaativa Nempaiotira auravano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Isora naata Adaava qorainti vainti Elifaasira vatatovaro, Basemaativa Ruelira vatatovaro, ");
INSERT INTO tbg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibaamava qorainti vainti taaramonavu Jeusirave, Jalaamurave, Koraarave vatatomanta vaura. Ho Isova Kenaani vataini vau entara vi vaintinavuka vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Isoka Iekopika vohaaraqi vaiha tavovaro vitanta sipisipive, memeraave, purumakauve, airitahaa vauvaro vika kara neva kia ho vauvarora tiro, Isova nai naata vaintive, nai airairave, katu varero Kenaani kero veraini Seiru vataini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Isora vira vara autu Idomuvave tuva mini vaurara ti, vi vataravata autu nteha Idomuve tura. ");
INSERT INTO tbg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isova Idomu vatanaaka qova Seiru vata aiqinaini vaumanta viva kuvuarama toka maantimake vaura: ");
INSERT INTO tbg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isora naata Adaava qorainti vainti Elifaasira vatatovaro Isora naata Basemaativa qorainti vainti Ruelira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Isora maaqu Elifaasira maaquvara vaireka, Temaanivave, Omaavave, Sepovave, Gataamuvave, Kenaasivave, vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaasira naata vo, Timinaava qorainti vainti Amarekira vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Isora maaqu Ruelira maaquvara vaireka Nahaativave, Seraavave, Samaavave, Misaavave, vaura. Vika Isora naata Basemaatira naintinavu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isora naata vo, Oholibaamava qorainti vainti Jeusarave, Jalaamurave, Koraarave, vatatora. Oholibaamava Anaara raavuravano vauvaro Anaava Sibeonira maaquvano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Isora naintinavu vo anku vo anku vika qokanavu vaura. Isora maaqu hoqarenaava Elifaasiva maa ankunavuka qova vaura: Temaanira, Omaara, Sepora, Kenaasira, Koraara, Gataamura, Amarekira. Vinavuka Isora naata Adaara naintinavu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isora naata Basemaativa Kenaanini vaiharo qorainti vainti Ruelira vatatovaro Rueliva maa ankunavuka qova vaura: Nahaatira, Seraara, Samaara, Misaara. ");
INSERT INTO tbg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","19","Isora naata Oholibaamara maaqunavu anku vaireka, Jeusara, Jalaamura, Koraara. Oholibaamava Anaara raavuravano vaura. Ekaa vi ankunavuka vaireka, Isova kuvuarama toka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Horihainaa vaiinti Seiruva Idomu vataini vaiharo qorainti vainti vonavu vatatomanta vinavuka maa ankunavuka qoka vaura: Lotaanira, Sobaalira, Sibeonira, Anaara, Disonira, Esera, Disaanira. ");
INSERT INTO tbg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Seirura maaqu Lotaanira maaqutanta Horika Hemanuka vaura. Lotaanira auravano Timinaava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Seirura maaqu Sobaalira maaqunavu vaireka, Alavaanivave, Manahaativave, Ebaalivave, Sepovave, Onaamivave, vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Seirura maaqu Sibeonira maaqutanta vaireka, Aiaaka, Anaaka vaura. (Anaava noruqama viro nai qora Sibeonira donkinavuqaa raqikiharo aahara vataini vi aniharo ahakaavi namarira qovarama kora.) ");
INSERT INTO tbg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anaava Disonira qova vauvaro Disonira maaqunavu vaireka, Hemudaanivave, Esabaanivave, Itaraanivave, Keraanivave, vaura. Anaara raavura Oholibaamava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esera maaqunavu vaireka, Bilihaanivave, Savaanivave, Akaanivave, vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disaanira maaqutanta vaireka, Usika Araanika vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Hori vatanaaka vika nora vaiintinavu nutu vaireva, Lotaanirave, Sobaalirave, Sibeonirave, Anaarave, Disonirave, Eserave, Disaanirave, vaura. Vinavuka Seiru vataini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kia Isareri vatanaaka avuhainaa vaiinti vau entara Idomu vatanaaka avuhainaa vaiintinavu vauvaro vinavuka nutu maantimama vairo: ");
INSERT INTO tbg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beora maaqu Belaava avuhainaa vaiintiqama viro Idomu vatanaakaqaa raqiki vauvaro vira vatuka autu vaireva Dinihaaba vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belaava qutu vuvaro Serara maaqu Jobaapiva Bosaraihainaava Belaara vatuka varero Idomu vatanaakaqaa raqikiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobaapiva qutu vuvaro Temaanihainaava Husaamuva Jobaapira vatuka varero Idomu vatanaakaqaa raqikiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husaaniva qutu vuvaro Bedaatira maaqu Hadaativa Husaamura vatuka varero Idomu vatanaakaqaa raqikiharo vaura. Hadaativa oru Moapini raquqiro viharo Midiani vatanaaka naatara kora. Hadaativa vau vatukara autu vaireva Avitive tura. ");
INSERT INTO tbg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaativa qutu vuvaro Masarekaihainaava Samaarava vira vatuka varero Idomu vatanaakaqaa raqikiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samaarava qutu vuvaro Soriva vira vatuka varero Idomu vatanaakaqaa raqikiharo vaura. Soriva Rehobotihainaava vauvaro vi vatukava Iufaretisi Namari hini mantaraini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Soriva qutu vuvaro Akabora maaqu Baali-Hanaaniva vira vatuka varero Idomu vatanaakaqaa raqikiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali-Hanaaniva qutu vuvaro Hadaativa vira vatuka varero Idomu vatanaakaqaa raqikiharo vaura. Hadaativa Pauhainaava vaiharo nahenti vo Mehetabelira Mataretira raavura varatero vaura. Mataretiva Me-Sahaapira raavuravano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Isova Idomu vatanaaka anku maanavuka qova vaura: Timinaara, Alavaara, Jetetira, Oholibaamara, Elaara, Pinonira, Kenaasira, Temaanira, Mimpasaara, Makadielira, Iraamura. Vi ankuva vi ankuva vonaini vonaini vauvaro anku autuvanovata vika mini vau vatara autuvanovata vohaa autuqai vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iekopiva nai qova vau vatara Kenaani vataini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iekopira maaqunavu uva vaireva, maantimama vairo: Iohepiva qaraaka vaiintivano 17 ihi varakova vaiharo nai vakaukavara hampata sipisipive, memeraave, vikaqaa raqiki vaura. Iohepiva nai qora naatatanta Bilihaaka Siripaaka maaqunavu hampata vi quararaqaa raqikiro viro, viraqaahairo viva nai qora vuru tiva amiro tiharo, Ti vakaukavara qora kaiqama vare variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Vira qova Iekopiva vira autu vo Isareriva, naampaiqama vu entara Iohepira vata amitorara tiro, viva ekaa nai maaqunavuqihairo Iohepirara voqama kero antuqa aruvaro vukai tavuna koqera autu kero vira amumanta ");
INSERT INTO tbg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","vira vakaukavara tavuna vira tave tiha, Oho, tinavu qora muntukavano Iohepiraraqai vaivo, tivake vira kaara vika Iohepira iri qoraiqama amiteha kia virara koqe uva tiraiti, vira toma amite vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Vika minti vauvaro vo enta Iohepiva taira tavero viraqaahairo taira vira tavora nai vakaukavara tiva nimumanta vira kaara vinavuka anomake Iohepira iri qoraiqama amite vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iohepiva vikara tiharo, Kaiqe te tenta taira tavaunara ni tiva nimiare. ");
INSERT INTO tbg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tenavu naahoqi uiti teqataunara rumpe vauraro, te rumpa taurava vaaviarama viro vaivaro, nenavu rumpataava te rumpa taunara vira ututumate vaiha, vira ravenka amite variarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Iohepiva minti tumanta vira vakaukavara oho tiha, Are qora tairahaama tavaaro. Are taira vira tavaanarara iriharama, hauri are tihara, Te vikaqaa raqikirerave, tirorave, ti. Minti tivake vika Iohepiva taira tavora kaaravata, Iohepiva vikara tu uvara kaaravata, vika anomake Iohepira iri qoraiqama amite vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mintuvaro Iohepiva qaiqaa taira vo tavero nai vakaukavarara tiharo, Te qaiqaa taira vovata tavauro. Te vaiha tavauramanta kuarivanovata, toravanovata, opu makau 11navuvanovata, ravenkavi vaiha ti quahama timite variarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Iohepiva nai taira tavorara nai qoravata tiva amuvaro vira qova Iohepira atiharo tiharo, Oho, are qora tairahaama tavaaro. Virara irihara hauri are tihara, Ti novavata ti vakaukavaravata ti qovavata ravenkavi vaiha ti quahama timitevarave, tirorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Minti tumanta Iohepira vakaukavara taira kaara arara itomanta Iohepira toma amite vauvarovata, vira qova vi uvara qaqi iriqiro viharo aato tara iharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Vo enta Iohepira vakaukavara vika nái qora sipisipi vita vare Sekemini oru vaiha sipisipiqaa raqiki vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Iekopiva Iohepirara tiharo, Are nena vakaukavara Sekemini sipisipiqaa raqiki varianaini vuane, tuvaro Iohepiva tiharo, Te mini virera qeramate vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Minti tuvaro vira qova tiharo, Ai vakaukavarave sipisipive hoe variavo, kiae ho variavo? Are vika oru tavera viri ti tiva timiane, tiro. Minti tivakero vira qova Iohepira atitovaro viva Hebaroni Uqitaini vura. Iohepiva Sekemini oruntero ");
INSERT INTO tbg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","nai vakaukavarara qumina ranteharo vi ani vauvaro vo vaiintivano vira tavero tiharo, Nana haikarae rante variaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Minti tuvaro Iohepiva tiharo, Te tenta vakaukavara sipisipiqaa raqiki variakarama rante vauro. Are hoe vika variara tiva timinarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Minti tuvaro vaiinti viva tiharo, Vika vaakama maihai vuavo. Te iruramanta vika tiha, Dotaanini virerave, tiarave, tiro. Minti tuvaro Iohepiva nai vakaukavara avataqiro viro Dotaanini oruntero tavomanta vika mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Iohepiva aumanto oruntomanta vira vakaukavara vira vutu tave vika vira arukerara nai tiva ami nai tiva amiha ");
INSERT INTO tbg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","tiha, Oho, taira tave vai vaiintiva ani vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kaiqenavu vira aruke namariara vata quvitaavaro aaharauqama viraqi vira vaata vaavi aqu kaare. Tenavu vira vaata viraqi aquke virara qaakau vairivano aru kaivo tiare. Tenavu mintiariraro viva taira tavairava quqaae varianarove, kiae quqaa varianarove? ti. ");
INSERT INTO tbg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Vika hininavu minti tuvaro Rubeniva vika uva iriro vika Iohepira arukevorave tiro, vikara aqao tiro, Kaiqenavu kia vira arukaare. ");
INSERT INTO tbg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tenavu kia vira arukaraiti, namariara vata quvitaavaro aaharauqama viraqi vira qaqi vara vaavi aqukaare, tiro. Viva nai aatoqi iriro tiharo, Naantiara te vira ruaruamake qaqi vita vare nai qova inanaini vuru karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ho vika vauvaro Iohepiva anintomanta vika vira ravaaqavuke vira tavuna koqera ravaqaake qaqini ke ");
INSERT INTO tbg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Iohepira vara muntu haaru namariara quvitovaro aaharauqama vuraqi vara vaavi aqukora. ");
INSERT INTO tbg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mintumake vika kara nareka oquvi vaiha vutu tavomanta Isamairi vatanaaka Gileaati vatukaihai ani vaura. Vi vatanaaka airi airaira koqe untavu haikarave, karaqaa hiakaa u haikara aatorave, vi haikara vi haikara vika nái kameriqaa rumpa vare Isipini vuru nimiha koqaa varareka ani vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ani vauvaro Iutaava nai qata vakaukavarara tiharo, Tenavu tentanavu qata aruke vira arukaaina uvara kukeqa kaainaraqaahairo kia tinavu kahaqiaina haikava qovaraiqianarove. ");
INSERT INTO tbg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kaiqe kia tentanavu kauquqohai Iohepira qoraiqama amitaraiti, Isamairi vatanaaka ani variakaqaa vira nimiha koqaa varaare. Tenavuvata vivavata vohaa naarema vauro, tumanta vira qata vakaukavara vi uvarara hove tumanta ");
INSERT INTO tbg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midiani vatanaaka anintomanta Iohepira vakaukavara namariara quvitoraqi vira aqu kora qaqini vara vaarike, Iohepira Isamairi vatanaaka nimiha, silvaa monu 20navu varomanta vi vatanaaka Iohepira vita vare vuru Isipini kora. ");
INSERT INTO tbg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Vika Iohepira vita vare vuvaro Rubeniva oruntero namariara quvitoraqi tavovaro Iohepiva viraqi kia vauvaro vira kaara vira muntukavano qoraiquvaro oho tivakero nai utavaaqa qunahi qaanahima kero ");
INSERT INTO tbg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","nai qatanavuara tiharo, Te tavauraro Iohepiva kia viraqi vaivo. Mpo, te nantie irarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Minti tumanta vinavuka Iohepira tavuna qaqini ravaqaa kora vare, memeraa vo aruke Iohepira tavuna vira naareqi quntamake vare ");
INSERT INTO tbg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","anirante vuru nái qora umiqeha tiha, Tenavu maa haikara ranta kaunara are aitutiha tavaane. Iohepira tavunae vaivo, vo vaiinti tavunae vaivo? ti. ");
INSERT INTO tbg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Minti tuvaro vika qova Iohepira tavuna viraaqama kero tavero tiharo, Oho, maa ti maaqu Iohepira tavunave. Qaakau vairi vovano vira aru kaivo. Quqaama qaakau vairi vovano ti maaqu Iohepira arukero ruqeqaama kaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Iekopiva minti tivakero nai utavaaqa qunahi qaanahima kero kovaara utavaaqa nonkutero airi enta variqiro viharo nai maaquara iqi rataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Vira maaqu raavura aninte vira muntuka kukuqama amitarare tuvarovata, Iekopiva kia vika tu uvara irura. Viva aqao tiro, Te tenta maaquara qaqi iqi rataqi vivi, vuru qutu virerave, tivakero nai maaquara qaqi iqi rataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mintuvaro Midiani vatanaaka vika vo autu Isamairi vatanaakave, vika Iohepira vita vare Isipini orunte Iohepira Potipaara amiha monu varora. Potipaava nora vaiintivano vaiharo viva iqoka vaiintinavuqaa raqiki vaumanta vika Pero vaiinti avuhainaa naavuqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Vi entara Iutaava nai qata vakaukavara mini kero oru Adulaamu vatukaini vo vaiinti Hiraara vataakero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Iutaava mini vaiharo tavovaro Kenaani vatanaa nahenti Suaara raavuravano vauvaro Iutaava vi nahentira varatero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Iutaava vira varatero vauvaro vi nahentiva vainti taiqama viro vuru qorainti vainti vatatero vira autu nteharo Erurave tura. ");
INSERT INTO tbg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Iutaara naatavano qaiqaa vainti taiqama viro qorainti vainti vo vatatero vira autu nteharo Onaanirave tura. ");
INSERT INTO tbg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Iutaara naatavano qaiqaa qorainti vainti vo vatatero vira autu nteharo Seraarave tura. Vira naatavano Kesipini vaiharo Seraara vatatora. ");
INSERT INTO tbg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mintuvaro Eruva tota avuni vatato vaintiva noruqama vuvaro Iutaava vira nahenti vo vara amuvaro vi nahentira autu Temaara. ");
INSERT INTO tbg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ho Noravano Kotiva tavovaro Eruva qora kaiqaqai vare vauvaro vira kaara viva vira arukora. ");
INSERT INTO tbg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Eruva qutu vuvaro Iutaava nai maaqu vo Onaanirara tiharo, Are nena vakaarara irihara vira naatantira vaitehara vainti kuvuarama amitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Minti tuvaro Onaaniva nai iriro tiharo, Te tenta vakaara naatanti vaitaariraro viva vatataaina vaintiva kiama ti vainti varianarove. Vira kaara kia te tenta vakaara vainti vata amitarerave, tivakero vikantiro niharo nai nora qaqini rauru kovaro vi nahentiva kia vainti taiqura. ");
INSERT INTO tbg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onaaniva mintura kaara Noravano Kotiva virara qora okarama autuaro tivakero viravata aru kora. ");
INSERT INTO tbg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Onaaniva qutu vuvaro Iutaava nai naaqutu Temaarara tiharo, Are nena qora naavuqi tentoqa variqira vi vairaro ti maaqu naantiaraava Seraava noruqama virara are vira varaane, tiro. Iutaava nai maaqu naantiaraara nai vakaatanta aanantero qutu vuantorave tiro, Temaarara vi uvara tuvaro Temaava nai qora naavuqi vaireva vurama. ");
INSERT INTO tbg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Temaava mini vuvaro airi enta aitarovaro Iutaara naata Suaara raavuravano qutu vuvaro Iutaava virara iqi rata amitero, viraqaahairo viva Timinaini nai sipisipi kauki toqe vaunaini vura. Iutaava mini vuvaro vira tonti Adulaamuhainaa vaiinti Hiraava vikantiro vura. ");
INSERT INTO tbg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Iutaava mini vuvaro vovano Temaara vuru tiva amiro tiharo, Ai tonaqova nai sipisipi kauki toqareva Timinaini vireva vivo, ");
INSERT INTO tbg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","tuvaro Temaava nai kovaara utavaaqa nonkutora qaqini vara kero, ti viri viraaqama kero tavaantorave tiro, nai viri naavuma tero, oru Enaimi vatuka qentiana oquviro vaura. Vi vatukava Timinaini vi vau aararaqaa vaura. Temaava tavovaro Iutaara maaqu Seraava noruqama viro vauvaro kia Iutaava Temaara vira amura. ");
INSERT INTO tbg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Temaava mini vaantaavura qentiana oquvi vauvaro Iutaava Timinaini viharoma Enainini oruntero vi nahentira tavovaro viva nai viri naavuma torara tiro, Iutaava virara aarana hampi ni vai nahentirave tura. ");
INSERT INTO tbg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Iutaava kia kankomake iruvaro vi nahentiva vira naaqutuvano vauvaro Iutaava vi nahentiva aara auvahini oquviro vaunaini oruntero tiharo, Kaiqe ai hampata nuare, tiro. Iutaava minti tuvaro nahenti viva vira irero, Are ti hampata nuvakera nana haikae ti timinarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Minti tuvaro Iutaava tiharo, Te ainti nuvake vo vaiinti atitaariraro viva ti memeraa naati vo varero ai vuru amiarire, tiro. Iutaava minti tuvaro nahenti viva tiharo, Are nena ina haikara vo haika ti vahuqa timiraqe te vira tuataarirara are memeraa naati ti timiraqe te nina vi haikara amiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Nahenti viva minti tuvaro Iutaava tiharo, Ho nana haikae ai vahuqa amiarirara tuatenarave? tiro. Minti tuvaro nahenti viva tiharo, Nena ringi naaqunta vataakero vairavata, nena kauruvata, ti timiraqe te vahuqa tuataare, tuvaro Iutaava vi nahentira vi haikara amiro, vira hampata nuva kovaro nahenti viva vainti taiqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Temaava nai tonaqokantiro nuva kero, viraqaahairo viva nai maaqaini oruntero nai viri naavuma tora qaqini vara kero, qaiqaa nai kovaara utavaaqa nonkutero vaura. ");
INSERT INTO tbg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Viva nai maaqaini vuvaro Iutaava nai vahuqa vi nahentira amuvaro tuato haikara varareva iharo memeraa naati nai tonti Adulaamuhainaa vaiinti amiro tiharo, Are vi nahentira vara vuru amiane, tuvaro viva varero oruntero tavovaro vi nahentiva kia mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Vi nahentiva kia mini vauvaro Iutaara tontivano vi vatanaaka irero tiharo, Aarana hampi ni vai nahentiva Enaimi aara auvahini vaiva tantoe vaivo? tiro. Minti tumanta vi vatanaaka aqao ti, Aarana hampi ni vai nahentiva kia maini vaivo. Totavata kia maini vairave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Vi vatanaaka minti tuvaro vira tontivano anirantero vuru Iutaara tiva amiro tiharo, Te vi nahentira ranteha tavauraro kiama vaivo. Vi vatanaakavata tiha, Haaruvata kia minti nahentiva maini vairavema tiavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Minti tuvaro Iutaava tiharo, Ho qaqi kairaro vi nahentiva te vahuqa amuna haikara qaqi tuataqiro vuarire. Hauri vi nahentira kaara vaiinti nahenti titanta naaraihama timitevorave. Te memeraa naati vira amitaurara, are oru qumina nihara kia vira ranta kaaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Iutaava minti tuvaro taaramo tora aitarovaro vaiinti vovano Iutaara tiva amiro tiharo, Ai naaqutu Temaava hampi nuvakero vainti taiqama vivo, tuvaro Iutaara arara itovaro tiharo, Vi nahentira ihaqi aqu kaivaro tatoqa viro qutu vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Minti tumanta vi nahentira ravaaqavu vare anuvaro Temaava nai tonaqova Iutaava vaunaini uva varakero mintima tiro: Maa haikara ti timiva, vivama ti vainti taiqama kaivo. Are maa ringira vira naaquntavata, kauruvata, viraaqama kerae tavaaro, kiae viraaqama kera tavaaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Minti tuvaro Iutaava vi haikara viraaqama kero tavero tiharo, Oho, kia maa nahentiraqaa uva vaivo. Tiqaama uva vaivo. Te qorahaama auturo. Te tenta maaqu Seraara vira amiataara vaimanta kia vira amunarave, tivakero Iutaava kia qaiqaavata vira hampata nura. ");
INSERT INTO tbg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Temaava variqiro vuvaro viva vainti vataarira entava anintovaro viva tavovaro vira auhaqi vainti taaraqanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Viva vainti vate vauvaro vira vainti vovano nai kauqu auhaqihairo tutu kovaro Temaara kahaqi vau nahentiva vira tavero tiharo, Maa vaintira vira naanema vatataanarove, tivakero vira viraaqama tavaare tiro, naare naaqunta vi vaintira kauquqaa rumpa tero. ");
INSERT INTO tbg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mintuvaro qorainti vainti viva kia tuviraitiro, nai kauqu qaiqaa raqantaatero auhaqi vauvaro vira nova vo vainti naane avuni vatatora. Vo vainti avuni vatatovarora tiro, Temaara kahaqu nahentiva qorainti vainti virara tiharo, Ike, are nantivarae kia naantiara tuviraitira, avuni tuvu ntaaro? tiro. Minti tivakero vi vaintira autu nteharo, Peresirave – Avuniqamavivave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","viraqaahairo qorainti vainti vo vira kauquqi naare naaqunta rumpatora vatatovaro vira autu nteharo, Siraarave – Naare ˻Naaquntarave˼ tura. ");
INSERT INTO tbg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isamairi vatanaaka Iohepira vitavare Isipini oruntovaro vihainaa vaiinti vovano Potipaava vika monu nimiharo Iohepira varora. Potipaava nora autu vataa vaiintivano iqoka vaiintinavuqaa raqiki vaumanta vika Pero vaiinti avuhainaa naavuqaa maimaraara raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ho Iohepiva Potipaara kaiqa vareharo vira naavuqi vauvaro Noravano Kotiva Iohepira kahaquvaro Iohepira kaiqavano koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Iohepiva koqe kaiqa vare vauvaro Potipaava tavovaro Noravano Kotiva Iohepira kahaquvarora tiro, Iohepira kaiqavano uritarakero koqe iro vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potipaava Iohepirara quahakero vira noraiqama kero tiharo, Are ti naavuqi kaiqa vareharama ekaa te una haikaraqaa raqikiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Potipaava minti tivakero Iohepira noraiqama kovaro Iohepiva ekaa vira kaiqaqaa raqiki vauvaro vi entaraqaahairo Noravano Kotiva Iohepirara iriharo Potipaara koqema amitovaro Potipaava kara ututovave, koqaa kaiqa varovave, koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Mintuvaro Potipaava Iohepirara tiharo, Are ekaa ti kaiqaqaa raqikiqira vuane, tuvaro Iohepiva ekaa vira kaiqaqaa raqikiqiro vi vauvaro Potipaava kia nai kaiqara airi aato iriraitiro, Iohepirara homa vi kaiqara varaanarove tivakero viva qaqi vaiharo karaqai neharo vaura. Ho Iohepiva koqe viri vaata vataa vaiintivano vaiharo Potipaara kaiqaqaa raqiki vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Potipaara naatavano Iohepira tavovaro muntuka ntuvaro virara avu autiharo Iohepirara tiharo, Anira tintira vaitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Minti tuvaro Iohepiva aqao tiro, Te maa naavuraqi vaiha vira kaiqaqaa raqiki vaurarora tiro, ti nora vaiinti Potipaava kia maa kaiqarara airi aato iri vairave. Viva ti noraiqama kaimanta te ekaa vira kaiqa haikaqaa raqiki vauro. ");
INSERT INTO tbg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Te vira voqaantemake maaqi vaiha vira kaiqaqaa raqiki vauro. Potipaava kia vo haika ti qioqama taivo. Are vira naatavano variararora tiro, viva ariaraqai iriharoma ti qioqama taivo. Vira kaara te qora kaiqa vareha Kotira uva raqa kaarorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iohepiva minti tuvaro vi nahentiva vo enta vo enta vira aare vauvaro Iohepiva kia vira uva iriraitiro, kia vira aaqanto oru vaura. ");
INSERT INTO tbg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Vo enta kia vi naavuraqi kaiqa vaiintie kaiqa nahentie vonavu vauvaro Iohepiva nariaraa naavuqi kaiqa varareva oriqetovaro ");
INSERT INTO tbg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potipaara naatavano Iohepiva tavunauta ruvutora tuatero tiharo, Are tintira vaitaane, tuvaro Iohepiva nai tavunauta viqukero vi nahentira kauquqi kero vahaaqaini veva ntero kantama vura. ");
INSERT INTO tbg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Iohepiva kantama vuvaro vi nahentiva tavovaro viva nai tavunauta vira kauquqi kero naavuqihairo kantama vuvaro ");
INSERT INTO tbg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","vira voqama kero arara itovaro naavuqi kaiqa varoka naarama kero vikara tiharo, Ho tavaate. Ti vaativano Hiparu vatanaa vaiinti maa vita varero tinavu naavuqi viri kaiva, viva ti qoraiqama timitareva auti vaivo. Viva maaqi uriqetero ti hampata nuare timanta te oi oi turaro ");
INSERT INTO tbg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","viva te oi oi tunara iriro qetakero nai tavunauta maini keroma vahaaqaini veva ntero kantama vivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Minti tivakero Iohepira tavunauta qaqi vatero nai vaati veka vauvaro Potipaava vira vaativano anuvaro ");
INSERT INTO tbg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","viva tavunauta vira umiqeharo tiharo, Hiparu vatanaa kaiqa vaiinti vita viri kaarava, viva ti qoraiqama timitareva auti vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Viva ani ti utu varaimanta te oi oi turaroma qetakero nai tavunauta maini kero veva ntero kantama vivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Vira naatavano una uva minti tuvaro nora vaiinti Potipaava nai naata uvara quqaa uvave tivakero vira arara itovaro ");
INSERT INTO tbg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","oru Iohepira ravaaqavu varero karapuhiqi muntu kora. Pero vaiinti uva raqakoka vauraqi Iohepiravata karapuhiqama kovaro viraqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ho Noravano Kotiva vira kahaqama amite vauvarora tiro, karapuhi naavuqaa raqiku vaiintiva Iohepira koqema amite vaura. ");
INSERT INTO tbg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Viva Iohepirara quaheharo vira noraiqama kero ekaa karapuhi vaiintiqaa raqikiane tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Iohepiva vi kaiqara vare vauvaro Noravano Kotiva vira kahaquvaro Iohepira kaiqavano uritarakero vauvaro karapuhi naavuqaa raqiku vaiintiva kia Iohepira kaiqara airi aato iriraitiro, viva Iohepirara tiharo, Viva nai homa vaiharo vi kaiqara varaanarove, tivakeharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Iohepiva karapuhiqi variqiro vuvaro vo enta Isipi vatanaaka avuhainaa vaiinti Pero vaiintivano nai kaiqa vara amito vaiintika votanta vo uva kaara vitanta karapuhiqama kora. Vira kaiqa vaiinti vovano Pero vaiinti uaini ami vau vaiintiva vauvaro, vira kaiqa vaiinti vovano Pero vaiinti mpareti unte vau vaiintiva vaura. Pero vaiintivano vitanta karapuhiqama komanta vitantavata Iohepiva vauraqi otu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pero vaiintiqaa maimaraara raqiku vaiintikaqaa raqikuva Iohepirara tiharo, Are qaraaka karapuhi vaiintitantaqaavata raqikiane, tuvaro Iohepiva vitantaqaavata raqiki vaura. Vitantaqaa raqiki vaumanta vitanta karapuhiqi variqi vuvaroma airi enta aitaromanta ");
INSERT INTO tbg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pero vaiinti uaini ami vauvavata, Pero vaiinti mpareti unte vauvavata, vitanta vohaa enta entaqi vaiteha taira tavora. Vovano vo taira tavovaro vovano vo taira tavora. ");
INSERT INTO tbg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Vitanta taira tavovaro vira qararaa toqaqi Iohepiva vitanta vauraqi oruntero tavovaro vitanta muntukavano qoraiqumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Mintumake vauvaro Iohepiva vitanta irero tiharo, Netanta nana kaarae notate variavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Minti tumanta vitanta tiha, Tetanta entaqi taira tavaunara kia vira okara iruro. Vovano taira okara titanta tiva timiarirava kia maini vaivo, tuvaro Iohepiva tiharo, Kotiva vaiinti kahaqi vaivaro viva taira okara ho iri vairave. Netanta taira tavaara ti tiva timiqe iriare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Iohepiva minti tuvaro Pero vaiinti uaini ami vau vaiintiva viva naane nai taira tavora Iohepira tiva amiro tiharo, Te vaiteha taira tavauraro ti tivuqaa uaini naaqunta vairave. ");
INSERT INTO tbg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Vi naaquntava qampiqeharo vaimanta vira kaqi taaramonavu variavaro kaqiqaahairo tava irataivaro aquita vimanta ");
INSERT INTO tbg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","te tave vira hiqike tatike vi namarira kaapuqi vare vuru Pero vaiinti vira kauquqi amunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Minti tuvaro Iohepiva vira nai tiva amiro tiharo, Are taira tavaanara vira okara maantimama vaivo: Kaqi taaraqanta vohaiqa vaira tavaanara vira okara vaireva, taaramo entama vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Taaramo entanavu aitarairaroma Pero vaiintivano qaiqaa ai aarama kairara, are vira kaiqa vareharama tota varaanantema kera, qaiqaama are vira kauquqi kaapu vara vuru aminarave. ");
INSERT INTO tbg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mpo, are mintimakera koqemavi vaihara, tiriara tauru kerorave. Are tiriara iriteharama Pero vaiinti tiva amiraro viva ti karapuhiqihairo kuvantu kaarire. ");
INSERT INTO tbg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Haaru te Hiparu vatanaa vaiintivano tenta maaqaini variavauramanta ti muara vare maini viri korave. Te maini vaiha kia qora kaiqa vararaiti variavauraro, qumina ti karapuhiqama kaamanta vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Iohepiva minti tuvaro Pero vaiinti mpareti unte vau vaiintiva iruvaro Iohepiva vo vaiinti taira okara koqemakero tuqantaakero tiva amuvaro, vivavata Iohepira tiva amiro tiharo, Tevata ˻entaqi˼ taira vo tavaunarave. Te tanu taaramonavuqi mpareti ntuvake tenta qiataqaa aquvare anunarave. ");
INSERT INTO tbg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ventaaqaa vai tanuraqi Pero vaiintiara unta tauna mparetira, vo mpareti vo mparetinavu vaimanta uvirinavu ani mpareti vira varake ne variarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Minti tuvaro Iohepiva vi vaiintira nai tiva amiro tiharo, Are taira tavaana okarava maantimama vaivo: Tanu taaramonavu vaira vira okara vaireva, taaramo entama vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Taaramo enta aitarairaro Pero vaiintivano karapuhiqihairo ai vita vuru kero, ai aunta teqakero ai vaata katariqaa hiritairaro uvirivano ani ai vaata mati nama kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Iohepiva minti tuvaro taaramo entanavu aitarovaro Pero vaiintivano tiharo, Ti vatato entava qovarama vivo, tivakero vi entarara quaheharo nai nora vaiinti naarama kero kara nimiharo tumanta karapuhi naavuqihai vira uaini amu vaiintiravata, vira mpareti unte vau vaiintiravata, ntita vare nora vaiintinavu kara nonaini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vuru kovaro viva vira uaini amu vaiintirara tiharo, Are qaiqaa qaqima ti kaiqa varenarave, tuvaro vi vaiintiva qaiqaa uaini kaapu Pero vaiinti vira kauquqi amuvaro ");
INSERT INTO tbg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero vaiintivano tumanta vira mpareti unte vau vaiintira aruke Iohepiva tuntemake, vira vaata katariqaa hiritora. ");
INSERT INTO tbg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mintuvaro Pero vaiinti uaini amu vaiintiva qaiqaa Pero vaiinti kaiqa vareharo kia Iohepirara iriraitiro, virara tauru kora. ");
INSERT INTO tbg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Iohepiva karapuhiqi qaqi variqiro vuvaro taara ihi aitarovaro Pero vaiintivano entaqi vaiteharo taira vo tavora. Vira tairavano maantimama vairo: Pero vaiintivano Nairi Namari hini mantaraini himpitero vaiharo tavomanta ");
INSERT INTO tbg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","purumakau 7navu koqe vaata vatauka nora hauntivano namariqihai vaarinte oru namari auvahianta vaiha ukau ne vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Vira naantiara qaiqaa purumakau 7navu namariqihai vaarinte vaura. Vinavuka kia koqe vaata vatauka, vuhaariruqai aquvuka namariqihai vaarinte oru purumakau koqeka tataaqa himpite vaiha ");
INSERT INTO tbg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","vika aruke nama kora. Mintuvaro Pero vaiintivano taira vira tavero vaitonaihairo himpura. ");
INSERT INTO tbg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ho viva qaiqaa vaita viro taira vovata tavora. Viva taira vo tavova maantimama vairo: Viva tavovaro qantivi/kakuma voqaava vauvaro vira veha vohaiqaqaahai nora koqeka 7navu irate mpeqaiqamavi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mintuvaro vira naantiara vo qantivi/kakuma vira voqaava nora 7navu iratovaro kuarivano noraiqaakero ite vauvaro uvaivano utiharo vira tatoqa aqukovaro kia koqe tava iratora. ");
INSERT INTO tbg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kia koqe tava 7navu iratoka oru koqe tava 7navu iratoka nampiqama aqukora. Mintuvaro Pero vaiintivano vaitonaihairo qaiqaa himpiro tiharo, Oho, te tairama tavauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Minti tivakero vira qararaa toqaqi Pero vaiintivano nai taira tavorara airi avu aato utiharo Isipi vatanaa vaiinti vo okara vo okara tavokavata, vaana kaiqa vare vau vaiintinavukavata, naarama kero viva nai taira tavora tiva nimumanta kia vikaqihairo vovano vira taira okara tiva amiarirava vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mintuvaro Pero vaiinti uaini ami vau vaiintiva oho tiro, Te vatema vo uva irikauro. Vi uvara haaru ai tiva amiataara vaimanta kia tiva amunarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Haaru ai arara itovara are tivata, ai mpareti unte vau vaiintiravata, karapuhiqama koramanta tetanta karapuhiqi variavaunarave. Ai naavuqaa raqiki varia vaiintinavukaqaa raqiki vai vaiintira naavuqi are titanta karapuhiqama koramanta ");
INSERT INTO tbg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","tetanta viraqi vaiha vohaa enta entaqi vaiteha taira tavaunarave. Te vo taira tavauraro viva vo taira tavorave. ");
INSERT INTO tbg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ho vi entara Hiparu vatanaa vaiinti vovanovata karapuhiqi vaurave. Vi vaiintiva haaru ai naavuqaa maimaraara raqiki varia vaiintikaqaa raqiki vai vaiintira kaiqa varorave. Viva titanta hampata karapuhiqi vaumanta tetanta tentatanta taira tavaunara vi vaiintira tiva amuraro viva ti taira okara kankomakero tinta tiva timiro, vo vaiinti nai taira okaravata kankoma kero tiva amurave. ");
INSERT INTO tbg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ho viva titanta tiva timuntema kera, are tiriara qaiqaa nena kaiqa varaane tivakera, vo vaiinti vira arukera katariqaa hiritaanarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Viva minti tuvaro Pero vaiintivano Iohepira vite aniate tumanta vokuka kante otu karapuhiqihai vira vitakovaro Iohepiva okau muqukero vo utavaaqa nonkutero oru Pero vaiinti avuqaa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Vira avuqaa oru vauvaro Pero vaiintivano virara tiharo, Te taira tave vira okarara vo vaiinti vo vaiinti irauramanta vika kia ho tiva timiarave. Vovano ariara taira okara ho tiva nimi vaivave timanta irunarave. Vi uvava quqaae vaivo, kiae quqaa vaivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Pero vaiintivano minti tuvaro Iohepiva aqao tiro, Te qaqi qumina vaiintivano kia ho ai tiva amirarave. Kotiva ti kahaqiraqe te homa taira okara ai Pero vaiinti tiva amirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Minti tuvaro Pero vaiintivano Iohepirara tiharo, Te taira tavehama, te Nairi Namari hini mantaraini himpite vaiha tavauramanta ");
INSERT INTO tbg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","purumakau 7navu koqe vaata vatauka nora hauntivano namariqihai vaarinte oru namari auvahianta vaiha ukau ne variarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Vira naantiara qaiqaa purumakau 7navu namariqihai vaarinte vaurave. Vika kia koqe vaata vatauka, vuhaariruqai aquvuka namariqihai vaarintaarave. Haaru te Isipi vataini vaiha, kia vira voqaara vuhaari otaiqamavi purumakaura tavaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Vuhaari otaiqamavua purumakauka oru koqe vaata vatauka nama taiqa kaarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Vika nama kaavaro kia vika vaatavano koqemakero nora vairaitiro, tota vaintema kero qora vaataqai vairave. Te mintimake taira tave, viraqaahai himpunarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Te himpi, qaiqaa vaitavi taira vovata tavaunarave. Te tavauraro qantivi/kakuma voqaava vaivaro vira veha vohaiqaqaahai nora koqeka 7navu irataarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mintimake irataavaro vira naantiara 7 vonavuvata irataavaro uvaivano utiharo vira tatoqa aqu kaimanta kia koqemake variarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ho kia koqeka 7navuvano oru koqeka 7navu nampiqama kaarave. Te taira mintimake tave, vi uvara vaana kaiqa vare varia vaiintika tiva nimuramanta vika kia ho vi uvara okara tinta tiva timiavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Minti tuvaro Iohepiva Pero vaiintiara tiharo, Are taara taira tavaanara, vitanta okara vaireva, vohaa qaramakero vairave. Kotiva nai naantiara autireva i okarara ai tairakaa umiqaivo. ");
INSERT INTO tbg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Are purumakau koqeka 7navu tavaanara, vira okara vaireva, koqe ihi 7navuma naantiara qovaraiqianarove. Qantivi/Kakuma voqaara nora koqera 7navu irataira, vira okaravata vaireva, vohaa qaramakero koqe ihi 7navuma naantiara qovaraiqianarove. ");
INSERT INTO tbg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Purumakau 7navu naantiara qovarama vuaka vuhaariru aquvuaka, vika okara vaireva, kia koqe ihi 7navuma naantiara qovaraiqianarove. Qantivi/Kakuma voqaava kia koqera 7navu irataira uvaivano utiharo tatoqa kaira, vira okaravata vaireva, vohaa qaramakero kia koqe ihi 7navuma naantiara qovaraiqianarove. ");
INSERT INTO tbg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Te vaaka tunarave. Kotiva naantiara nai kaiqa autireva i okarara ai tairakaa umiqairave. ");
INSERT INTO tbg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Isipi vata maini karavano 7 ihiara koqema kero qampiqeharo varaqiro vuanarove. ");
INSERT INTO tbg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ho koqe ihi 7navu taiqa viraro viraqaahairo qaiqaa 7ihiara karavano kia vaira aavoqi entava qovarama viramanta koqe ihinavu vairara tauruma kevarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Vi entava anomakero qora enta variainarara ti, vaiinti nahenti airi kara variaina entarara tauru kevarave. ");
INSERT INTO tbg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kotiva uva tiva tero vaaka vi entara qovarama kareva auti vairara tira, are taira taaraqanta vohaa vaka tavaanarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Iohepiva minti tivakero qaiqaa Pero vaiintiara tiharo, Virara iriharama are vaiinti vo, koqe avu aato vataara ranta kera, vira noraiqama kairaro viva ekaa Isipi vataqaa raqikiarire. ");
INSERT INTO tbg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Vi vaiintira noraiqama kera are vaiinti vonavuvata noraiqama kaira vinavuka vaiha ekaa kara qantu vare aniraqaahai vika takisi varaate. Vinavuka kara varehama vaiinti nahentiara nenta 4navu tuate vohaiqa tinavu timiate, tiate. ");
INSERT INTO tbg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Vinavuka ai Pero vaiinti autuqaama koqe ihinavu variqi viha, kara ruvaaqumake vo vatuka vo vatuka kara vate naavuraqi vataivaro ");
INSERT INTO tbg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","naantiara 7 ihiara karara aavoqiva anintaira karavano ho variarire. Vinavuka mintimake kara vataimanta Isipi vatanaaka kia narara vairaiti, ho kara varake neha variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iohepiva minti tuvaro Pero vaiintivanovata, vira nora vaiinti vonavuvata, vira uvara koqe uvave tura. ");
INSERT INTO tbg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pero vaiinti viva tiharo, Nantima vaina vaiintirae noraiqama kararave? Kotiva Iohepira avu aato koqema amitairara ti, qumina tenavu vo vaiinti noraiqama kaarorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Minti tivakero Pero vaiintivano Iohepirara tiharo, Kotiva vi uvara okara ai umiqairara tiro, vovano kiama ai voqaantema kero koqe avu aato vataava vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Virara irihama te ai noraiqama kaarirara are ti avuhainaa naavuqaa raqiki vairamanta ekaa ti vaiinti nahenti ai uva iriqi vuate. Tentaqai ai avuni nora vaiinti vairerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pero vaiinti viva minti tivakero qaiqaa Iohepirara tiharo, Vate te ai noraiqama kaarirara are ekaa Isipi vataqaa raqikiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Minti tivakero qaqi vaiinti nahenti Iohepira noraiqama kairara iriate tiro, Pero vaiintivano nai vuqaqi nonkuto ringira, nai autuvano viraqaa vau ringira, rahunku kero Iohepira vuqaqi nonku amitero, koqe utavaaqa nonku amitero, hankaaroro/kukukakaara koriqohai aututora vira auntaqi ruvu amitero, ");
INSERT INTO tbg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ohivata iqoka kaariravata Iohepira amuvaro Iohepiva Pero vaiinti naantiaraihainaava vaiharo iqoka kaariqi vi vaumanta vaiinti vonavu Iohepira avuni kantamaqi viha tiha, Iohepiva ani vaivo. Ne uqaurivaro viva aniarire, ti vaura. Mintima kero Pero vaiintivano Iohepira noraiqama kovaro Iohepiva ekaa Isipi vataqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pero vaiintivano Iohepirara tiharo, Te avuhainauka ariara mintima turo: Are kia hove tirera, Isipi vatanaakaqihai kia ho vovano nai irikero vo kaiqa varaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Minti tivakero viva Iohepira qaraaka autu ntava amitero virara Sapenaati Paneaarave tivakero nahenti vo, Asenaatira vira amura. Asenaativa Potiperaara raavuravano vauvaro Potiperaava kuariara tinavu variqave tivakeharo vira aare vau vaiintiva Oni vatukaqi vaura. Iohepiva ekaa Isipi vataini vi aniharo raqikiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iohepiva 30 ihi varakova Pero vaiinti Isipi vika avuhainaara kaiqa hoqarama tero varaqiro vura. Iohepiva Pero vaiintivano vaura mini kero Isipini vi aniharo kaiqaqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ho 7 ihinavuara karavano koqema kero qampiqaqiro vu entara ");
INSERT INTO tbg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Iohepiva ekaa vi karara qantutora varero vuru vo vatuka vo vatukaqi vatora. Vo vatuka auvahini naaho ututora Iohepiva vi karara qantu keharo nai vi vatukara kara naavuqi vuru vatero, mintiaqiro viharo vo vatuka vo vatuka naavuqi kara qantu keharo vate vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nora namari auvahini nuqavano airi vaintema kero, Iohepiva airi kara qantu varero vo naavu vo naavuqi mpiqakero vatovaro airi karavano voqavata vauvarora tiro, Iohepiva hini karaqai vukuqi qara ntuva tero, hini kara kia vukuqi qara ntuva taraitiro, qaqi naavuqi vatora. ");
INSERT INTO tbg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Karara aavoqu entava kia anu entara, Asenaativa Potiperaara raavuravano qorainti vainti taaraqanta Iohepira vata amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Iohepiva nai maaqu avuni vatatora autu nteharo Manaserave – Taurukaunarave, tiro. Iohepiva tiharo, Kotiva ti kahaqimanta tinta vakaukavara ti qoraiqama timitora tauruke, tenta karapuhiqi vukai enta variavaunaravata tauru kauro, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Iohepiva nai maaqu vira naantiara vatatora autu nteharo Efaraimurave – Vainti Timirave, tiro. Iohepiva tiharo, Te ˻Isipini˼ vaiha nora maaraqi variavauraro Kotiva vainti taaraqanta ti timivo, tura. ");
INSERT INTO tbg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ho Isipini koqe ihi 7navu taiqovaro ");
INSERT INTO tbg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Iohepiva tuntema kero, karara aavoqu ihiva 7navu qovaraiqireva hoqarama tora. Mintuvaro ekaa vo vataini vo vataini kara kia vauvaro Isipi vatainiqai karavano vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Karara aavoqu entava anintomanta Isipi vatanaaka Pero vaiintiara tiha, Mpo, kara tinavu timiane, tuvaro Pero vaiintivano vikara tiharo, Ne Iohepiva vainaini oruntema, viva tinante iate, tura. ");
INSERT INTO tbg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ho karara aavoquva ekaa Isipini vi anuvaro Iohepiva vo naavuqi vo naavuqi kara qantu vuru vatora oru qenti qantuakero monu vareharo vi vatanaaka kara nimi vaura. Karara aavoquva ekaa Isipini qovaraiquvaro tiro, Iohepiva minti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Vo vataini vo vatainivata kia kara vaumanta vo vatanaa vo vatanaaka Isipini Iohepiva vaunaini kara varareka ani vaura. ");
INSERT INTO tbg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kenaani vatainivata kia kara vauvaro Iekopiva iruvaro Isipini kara vauvaro viva nai maaqunavuara tiharo, Ne qumina maini vaiha nai tave nai tave iha vaivorave. ");
INSERT INTO tbg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipini kara vaivo tiamanta irunarave. Nenavu mini otunte monu aqukehama kara vara viri tinavu timiqe tenavu kara vira nehama kia qutu viraiti, qaqi variqi vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Iekopiva minti tivakero Iohepira vakaukavara 10navu nititomanta vika kara koqaa ireka Isipini vura. ");
INSERT INTO tbg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Vika vire uvaro Iekopiva kia Benaminira Iohepira qata atitaraitiro tiharo, Viravata atitaariraro vo haikavano vira qoraiqama amitaantorave, tura. ");
INSERT INTO tbg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kenaanini karara aavoqu entava anintomantara ti, vokukavata Iekopira maaqunavu hampata kara koqaa ireka Isipini vura. ");
INSERT INTO tbg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ho Iohepiva ekaa Isipiqaa raqiki vauva vaiharo vo vataihainaa vo vataihainaaka monu vareharo vika kara nimi vaumanta, Iohepira vakaukavaravata viva vaunaini orunte vira avuqaa hiqirivi kankakaavuvi vaiha nái viri vataini ke vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iohepiva nai vakaukavara vika viraaqama kero tavero, viva kia vika viraaqamakero tavaantemakero, vikara tamoqaraiqama kero irero tiharo, Ne taihai aniakave? tumanta vika tiha, Tenavu Kenaanihai kara koqaa irera anuraukave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Vika minti tivake kia Iohepira viraaqamake tavaraiti vauvaro, Iohepivaqai nai vakaukavara viraaqama kero tavora. ");
INSERT INTO tbg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Vika kankakaavuvi vauvaro Iohepiva haaru nai taira tavora iritero vikara tiharo, Aqao, nenavu vo haika ampeqamake tavareka aniakave. Nenavu maini aninte tenavu kia koqemake maimaraara raqikiainara tavareka aniakave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Iohepiva minti tumanta vika tiha, Nora vaiintio, tenavu kia mintirera anuraukavauve. Tenavu ai kaiqa vaiintinavu vaiha kara koqaa irera anuraukave. ");
INSERT INTO tbg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tenavu vairera, qata vakaukavara vauraro tinavu qova vohaiqavanoma vaivo. Kia tenavu maa vatanaaka ampeqirera anuraukavauve. Tenavu quqaa uvaqai tura vaiintikama anuro, ti. ");
INSERT INTO tbg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Vika minti tuvaro Iohepiva tiharo, Nenavu unahaama tiavo. Nenavu maini aninte tenavu kia koqemake maimaraara raqikiainara tavareka aniakave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Iohepiva minti tumanta vika tiha, Tenavu tota vairera, qata vakaukavara 12navu vauraro tinavu qova vohaiqavano Kenaanini vaivo. Tinavu qata vovano qutu vuvaro tinavu qata vitihainaava tinavu qokantiro vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Vika minti tuvaro Iohepiva aqao tiro, Te vaaka tunarave. Ne maini ampeqireka aniakave. ");
INSERT INTO tbg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ho te maantimake ni avateha tavarerave. Te tenta kauqu aiqiqaa aqukeha Pero vaiinti autuqaa mintima turo: Ninavu qatavano kia maini anirera, nenavu kiama ho maihai vivarave. ");
INSERT INTO tbg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ninavuqihairo vovano oru ni qata vita varero maini aniarire. Viva vira vitareva viraqe te ni hininavu karapuhiqama taari nenavu maini vaiqe te ni uvara quqaave unave tiare. Te tavaariraro ni uva una uva vairera, te niara maini ampeqireka aniakave tirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Iohepiva minti tivakero taaramo enta vika karapuhiqi komanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Vika karapuhiqi taaramo enta vauvaro Iohepiva anintero vikara tiharo, Ho te Kotira aatu qeteha vauraukama vauro. Te vo uva tiari ne vi uvara irivera, te ni vehakuma nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ne quqaa uva ti varia vaiintika vaivera, niqihairo vovano karapuhi maaqi vaira ne hininavu anirante kara vare vuru nenta navunaaka narara vaika nimi, ");
INSERT INTO tbg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","viraqaahai nenta qata vita vare te iainanaini viri kaiqe tavaare. Te vira tave, niara quqaa uva ti variakave tivakehama ni vehakuma nimitaare, tumanta vika eo tenavu mintirerave tura. ");
INSERT INTO tbg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","23","Iohepiva Isipi vatanaaka uvaqihairo ti vauvaro vovano vira uva tuqantaakero vira vakaukavara tiva nimi vaumantara ti, vika Iohepirara vo vatanaava vaiharo kia tinavu uva ho irianarove tivake, vika nái uvaqihai nai tiva ami nai tiva ami iha tiha, Oho, haaru tenavu tentanavu qata vo qoraiqama amitaunara kaara Kotiva vate tinavuqaa nora maara vataivo. Haaru tinavu qatavano iqi rateharo tinavuara kia mintiate timanta tenavu kia vira uva iriraiti, kia vira aaqurihama amitaunarave. Vira kaara vate nora maaravano tinavuqaa qovarama vivo, ti. Vika hininavu minti tuvaro Rubeniva tiharo, Oho, vi entara te niara tiha, Kia vira qoraiqama amitaate, turamanta ne ti uva iriataara vaimanta kia iriarave. Ne vira arukaara kaarama vate tinavuqaa nora maara vaivo, tiro. Minti tumanta vika Iohepirara kiama tinavu uva ho irianarove tuvarovata, Iohepiva vika tu uvara ekaa irura. ");
INSERT INTO tbg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Iohepiva vika uva iruvaro vira muntukavano qoraiquvaro viva tuqantaaviro uve iqi ratakovaro, vira auntavano ho uva tiarirava vauvaro viva qaiqaa tuqantaa viro kauqu aave vateharo nai kaiqa vaiintinavuara tiharo, Vi vaiintira karapuhiqi kaate, tumanta vika Simionira vikaqihai rumpa vare muntu karapuhiqi kora. ");
INSERT INTO tbg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Mintuvaro Iohepiva nai kaiqa vaiintinavu evaara tiva nimiro tiharo, Ne kara vare vika utaqi mpiqa nimite, vika monu nái utaqi qaiqaa ntuva nimitaate. Vika aaraini viha kara neravata ntuva nimitaate, tiro. Minti tumanta vira kaiqa vaiintinavu Iohepiva tuntemake, kara ntuva nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Iohepira vakaukavara kara ntuvato utara vara vaari nái donki tauvaqaqaa rumpate nái maaqaini vireka vurama. ");
INSERT INTO tbg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Vika aaraini vuvaro entama vumanta kaiqe maini vaitaare tivake mini vauvaro, vovano nai utaqihairo kara oqikero nai donki amiare tivakero tavovaro viva karara aquko monuva nai uta noqaa qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Viraqi vauvaro viva nai qata vakaukavara naarama kero tiharo, Ho tavaate. Te karara aqu kaura monuva tinta utaqi qaqima vaivo, tiro. Minti tumanta vika voqamake naatu itomanta qeteha aiqu kauqu ntiri ntiri iha tiha, Oho, Kotiva tinavuara nantiharoe mintivo? ti. ");
INSERT INTO tbg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Vika minti tivake oru vi, nái qova vaunaini Kenaanini orunte nái nu vakaakara Iekopira tiva ami tiha, ");
INSERT INTO tbg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Isipiqaa raqiki vai vaiintiva tinavuara tamoqaraiqama kero tiharo, Ne Isipi vatanaaka ampeqireka aniakave, tirave. ");
INSERT INTO tbg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Viva minti timanta tenavu tiha, Aqao, kia tenavu Isipi vatanaaka ampeqirera anuraukavauve. Tenavu quqaa uvaqai tura vaiintika anuraukave. ");
INSERT INTO tbg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tenavu qata vakaukavara 12navu vauraro tinavu qova vohaiqavano vaivo. Tinavu qata vovano qutu vurave. Tinavu qata vo, vitihainaava qaqi tinavu qokantiro Kenaaninima vaivo, turaro ");
INSERT INTO tbg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","vi vaiintiva tiharo, Ne quqaa uva ti variaka vaivera, niqihai vonku maini karapuhiqi ke, ne hininavu anirante kara vare vuru nenta navunaaka narara vaika nimi, ");
INSERT INTO tbg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","viraqaahai nenta qata vira vita vare te iainanaini viri kaiqe te vira tavaare. Ho te vira tave, viraqaahai niara quqaa uva ti varia vaiintikave tivakeha, niara kia maini ampeqireka aniakave tirarave. Minti tivakema te ni qata vakaara vo kuvantuke ninta nimiari ne homa maini monu aqukeha kara varevarave, tirave. Isipiqaa raqiki vai vaiintiva tinavuara minti tirave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Minti tivake vika nái kara ntuvato utara urequke tavovaro vika karara aquko monuva vo uta vo utaqi qaqi vaumanta vika nái qora vatamake voqamake qeteha vaura. ");
INSERT INTO tbg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Vika qova Iekopiva tiharo, Oho, ninavu okaraqaa ti vaintivara taiqama vivarave. Mpo, Iohepiva qutu vurave. Simioniva kiama vaivo. Ne Benaminiravata mini vita vuru kareka auti variavo. Oho, vo maara vo maaravano tiqaa qovaraiqi vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Minti tuvaro Rubeniva nai qorara tiharo, Benaminira ti timiraqe tevano viraqaa raqikiqi vima, qaiqaa nina vita viri amiare. Te kia orurante nina vita viri amiarera, are homa ti maaqutanta aru kenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Minti tuvaro Iekopiva aqao tiro, Kia te tenta maaqu vitihainaara ai amiarirara vite vinarave. Vira vakaava qutu vuvaro vivaqaima qaqi vaivo. Ne vira vita vare vivaro qora haikavano viraqaa qovaraiqirera, vira kaara ti muntuka qoraiqirava ti erera kauki vatauka aruma kaanarove. Kiama ho ne vira vite vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Iekopiva minti tuvaro karara aavoqu entava qaqiqai variqiro vumanta ");
INSERT INTO tbg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","vika Isipihai vare anu karara nama taiqa kovaro vika qova vikara tiharo, Ne anirante oru qaiqaa kara koqaama keha, inaara kara voqavata vare aniate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Minti tuvaro Iutaava aqao tiro, Tenavu ai tiva amunarave. Isipiqaa raqiki vai vaiintiva tinavu titiharo minti tirave: Ne kia nenta qata vo vite aniqe te vira tavaarera, ne kia ho te iainanaini qaiqaa ani kara varevarave, tirave. ");
INSERT INTO tbg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Are Benaminiravata tinavu hampata kairaqe tenavu vira vataake Isipini kara vararera vuare. ");
INSERT INTO tbg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nora vaiintivano minti tirave: Ni qata vovano kia ni hampata anirera, ne kia te iainanaini ho anivarave tirave. Are kia vira atitairera, tenavuvata kia ho mini virarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Minti tuvaro Iekopiva vira vo autu Isareriva tiharo, Ne vi vaiintira nenta qatara kia tiva amiataarave. Oho, ne minti tiara kaara tiqi nora maarama qovaraiqivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Minti tumanta vika tiha, Aqao, vi vaiintiva vo uva vo uvara tintanavuvata, tinavu hampata vaukaravata irairave. Viva tiharo, Ni qova qaqie vaivo? Ni qata vovano vairove? tirave. Minti tivera, tenavu vi uvara vi uvara nai tiva amunarave. Tenavu nai tiva amiha kia tenavu viva nenta qata maini vite aniate tiaina uvara iriraiti, qaqi ti vauraro viva naivano vi uvara tirave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Vika minti tuvaro vikaqihairo Iutaava nai qora Isarerirara tiharo, Are vi vaintira ti vataakera atitairaqe tenavu vaaka vuare. Tenavu kia vaaka vuarera, tinavu vainti nahentivata arevata qutivarave. ");
INSERT INTO tbg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Tevano vi vaintiraqaa koqemake raqikiariraro kia qora haikavano viraqaa qovaraiqiarire. Te vira kia nina qaiqaa vita viri amiarera, vira kaara vi uvava tiqaa ekaa entama varianarove. ");
INSERT INTO tbg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tenavu vaaka karara vuataarave. Tenavu vaaka vuraitirio, homa taara tataa oru vi orurante anuraitirio, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Iutaava kempukaiqama kero minti tuvaro vika qova tiharo, Ne mini quqaa vireka ivera, ne maihai koqe airaira vare vuru vi vaiintira amivaro viva niara quahaarire. Koqe vahaverave, hanive, karaqaa aataataarave, pinaati voqaarave, vi haikara vi haikara vare vuru amiate. ");
INSERT INTO tbg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ninta utaqi ntuvataa monura nai qaiqaa vuru amiha, vo monuvata viraqaa tomaqake amiate. Vovano qumimaqa iharoe ni utaqi vi monura ntuva tairave? ");
INSERT INTO tbg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Nenta qatavata vita vare vaaka vuate. ");
INSERT INTO tbg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ne vi vaiintira avuqaa oru vaivaro Kotiva ekaa kempuka vataava ni aaqurihama nimitairaro vi vaiintiva ni qata vakaa vovata Benaminiravata qaqi kaira ho ne vitanta ntita vare orurante aniate. Oho, ti vaintivara taiqavi kia vaivera, vika taiqama vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Minti tumanta vika vira ami airairara vare, monuvata taara tataa vare, ho Benaminiravata vita vare vaaka Isipini Iohepiva vaunaini oruntora. ");
INSERT INTO tbg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Oruntovaro Iohepiva Benaminira tavero nai naavuqaa raqiku vaiintirara tiharo, Are maa vaiintinavuka ntita varera ti naavuqi vuru kera, memeraa vo arukera unta tairamanta vi vaiintinavuka ikaraqaa ti hampata kara naate, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","vira kaiqa vaiintivano Iohepiva tuntema kero, vira vakaukavara Iohepira naavuqi ntita vuru kora. ");
INSERT INTO tbg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Vika ntita vuru Iohepira naavuqi kora kaara vika naatu itomanta tiha, Oho, tota tinavu utaqi monu ntuvataara kaarae viva tinavu maaqi vuru kaivo? Viva tinavu ravaaqavu kero rumpatero, tinavu donkivata varero, tinavuara ne ti qumina kaiqa vaiinti variate tianarove, ti. ");
INSERT INTO tbg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Vika minti tivake oru naavu qentiana vaiha Iohepira kaiqa vaiintiara tiha, ");
INSERT INTO tbg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Nora vaiintio, tota hoqare tenavu maihai kara vare tentanavu maaqaini anirante ");
INSERT INTO tbg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","aaraini vuraro entama vimanta aarana vaitarera iha tavauraro tenavu karara aqu kauna monura tintanavu utaqi qaqi ntuva taava vairave. Vovano tinavuara muara varaavo tiantorave ti, tenavu qaiqaa vi monura vare anuro. ");
INSERT INTO tbg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tenavu vo monuvata viraqaa tomaqake kara vararera qaiqaa vare anuro. Nai tavave tinavu utaqi monu vira ntuvatairave? ti. ");
INSERT INTO tbg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Vika minti tuvaro Iohepira kaiqa vaiintivano tiharo, Hove, kia qetaate. Nivata ni qora Variqavano, vivama vi monura ninavu utaqi ntuvatairave. Tema tota vi entara ni monu varaunarave, tivakero viva oru Simionira karapuhiqihairo kuvantukero vika vaunaini viri kora. ");
INSERT INTO tbg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mintima kero Iohepira kaiqa vaiintivano vika ntita vuru Iohepira naavuqi kero, vikara nái aiqu hiqaate tiro, namari kaqa nimiro, vika donkivata kara nimiro, ");
INSERT INTO tbg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","vikara tiharo, Ne ikaraqaa Iohepira vataake kara nevarave, tumantara ti, vika Iohepira amireka vare anu haikara qeramake vatora. ");
INSERT INTO tbg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Qerama vate vahaaqaini vauvaro Iohepiva vihairo nai naavuqi oruntomanta vira qata vakaukavara nái vare anu haikara vare, naavuqi oriqete Iohepira amiha vataini kankakaamavi vaiha nái viri vataini keha vaura. ");
INSERT INTO tbg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Mintimake Iohepira avuqaa vauvaro Iohepiva vika irero, Nenavu hoe variavo? tivakero viva qaiqaa vika irero tiharo, Ho ni qova naampaiqama vivo tiava vo? Viva qaqie vaivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Minti tumanta vika tiha, Ai kaiqa vaiinti tinavu qova, viva qaqi vaiharo homa vaivo, tivake vika qaiqaa kankakaamavi nái viri vataini keha vaura. ");
INSERT INTO tbg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Vika mintimake Iohepira avuqaa vauvaro Iohepiva vika aitutumaqiro viharo nai nora maaqu, Benaminira tavero vika irero tiharo, Ne nenta qata vitihainaarave tiava, maa vivae vaivo? tivakero Iohepiva Benaminirara tiharo, Ti maaquo, Kotiva ai koqema amitaarire turo, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","nai qata qaiqaa tavorara tiro, Iohepiva iqi rataarirava aumaiquvaro viraqihairo viva kantero oru vo rumuqi nariaraa vaiharo nai qatara iqi ratora. ");
INSERT INTO tbg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nai qatara iqi rata kero viva nai viriqi auquru nunka kero, anirantero nai qata vakaukavara vauraqi oru vaiharo nai kaiqa vaiintinavuara tiharo, Ho kara raaquate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Minti tivakero Iohepiva vo taintaqaa nariaraa oquvi vaumanta, Iohepira kaiqa vaiintinavu kara raaquke Iohepira ami, Iohepira qata vakaukavara vo taintaqaa oquvi vauka kara raaquke nimi, Isipi vaiinti vonavu vika nariaraa vo taintaqaa oquvi vaukavata kara raaquke nimura. Isipi vatanaaka tiha, Tenavu Hiparu vatanaa hampata kara naarorave ti, vika nariaraa vo taintaqaa kara ne vaura. ");
INSERT INTO tbg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Iohepira qata vakaukavara kara nareka uvaro Iohepiva vika rairakero mini mini oquvi vaiha kara naate tumanta, vika oquvi vaiha tavovaro vika vakaara avuhainaaraqaahairo oquviro viro, muntu vitihainaaraqaa kora. Iohepiva mintimakero vika raira komanta vika tave, voqamake aato tara iha tiha, Nantiakeroe viva tinavu noka tinavu vatataa okarara irirave? ti. ");
INSERT INTO tbg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Vika minti tivake oquvi vaumanta Iohepira kaiqa vaiintinavu Iohepira taintaqaahai kara vare muntu vika nimiha, Benaminira amireka anomake amitora. Benaminira mintimake amumanta vika ekaa karavata namarivata namake quahe vaura. ");
INSERT INTO tbg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Vika kara novaro viraqaahairo Iohepiva nai kaiqa vaiinti naavuqaa raqikura tiva amiro tiharo, Kara varera vika utaqi ntuva mpiqakera nimitera, nái vare ani monuravata nái utaqi qaqi ntuva nimitaane. ");
INSERT INTO tbg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mintima kera oru ti silvaa kaapu koqera varera muntu vika qata vitihainaara utaqi nái monu vataakera ntuva amitaane, tiro. Minti tuvaro viva Iohepiva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ho vira qararaa vaaka toqaqi vika nititomanta Iohepira qata vakaukavara nái donki hampata nái maaqaini vireka vurama. ");
INSERT INTO tbg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Vika kia niaraiqamake aaraini vuvaro Iohepiva nai naavuqaa raqiku vaiintirara tiharo, Kantera vi vaiintinavuka avataqira vuane. Vika aaqanto oruntera vikara mintima tiane: Ti nora vaiintivano ni koqema nimitaimanta ne nantihae nai qoraiqama amitaavo? ");
INSERT INTO tbg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ne nantihae ti nora vaiinti kaapu koqera muara vare aniavo? Viva vi kaapuraqihairo namari ne vairave. Viva vi kaapuraqohairo naantiara qovaraiqiaina haikara tave vairave. Ne mintihama qora kaiqama varaavo, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Iohepiva minti tivakero vira atitovaro vira kaiqa vaiintivano kantero vika oru ntitakero vi uvara tumanta ");
INSERT INTO tbg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","vika aqao ti, Nantiharae are tinavuara minti tiaro? Tenavu kiama vira kaapu muara vare anuro. ");
INSERT INTO tbg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tota tenavu Kenaanini orunte, tentanavu utaqihai monu ranta kaavaunara, vi monura qaqi nai amunarave. Tenavu minturaukara ti, kiama ai nora vaiinti naavuqihai vo haikavata muara varaainarave. ");
INSERT INTO tbg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Are rantaqira vihara tavairaro tinavuqihairo vo vaiinti utaqi vi kaapuva vairera, vi vaiintira arukera tinavuvata rumpa tairaqe tenavu ai nora vaiinti vira qumina kaiqa vaiinti variare, ti. ");
INSERT INTO tbg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Vika minti tuvaro Iohepira kaiqa vaiintivano tiharo, Hove. Kaapu muara varero anina vaiintira, viraqaima te rumpa kararave. Ne hininavu homa nenta maaqaini qaqi vivarave, tumanta ");
INSERT INTO tbg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","vika ekaa nái uta vataini vaavi ke, no rumpatora qantuke vatovaro ");
INSERT INTO tbg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Iohepira kaiqa vaiintivano avuni vika vakaara utaqihairo aitutumaqiro viro, muntu vitihainaaraqaa kora. Viva vika qata Benaminira vitihainaara utaqihairo kaapu vira ranta kora. ");
INSERT INTO tbg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Vika tavovaro nái qata utaqi kaapuvano vaumanta vika nái utavaaqa qunahi qaanahimake, voqamake qeteha nái kara ntuvato utanavura vara vaari nái donkiqaa rumpate, anirante vatukaini vurama. ");
INSERT INTO tbg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Iohepiva nai naavuqi qaqi vauvaro Iutaava nai qata vakaukavara hampata orunte vata kanta hiqintivi vauvaro ");
INSERT INTO tbg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Iohepiva vikara tiharo, Ne nana okarae ti vara timitaavo? Ne kiae iriavo? Te hepi kaiqa vareha naantiara qovaraiqiaina haikara tave vauraukama vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Iohepiva minti tuvaro Iutaava tiharo, Oho, tenavu nana uvae tirarave? Nana uvae tenavu tiarirara are vi uvarara quqaave tivakehara tinavuara kia muara varaavo tinarave? Tenavu vaaqu kaiqa varaunara kaara Kotiva tinavu qora kaiqa qovarama kaivaro qoqaa vaivo. Ho tenavu maa entaraqaahai are rumpatena vaiintikama vairarave. Vira utaqihai kaapu rantakaa vaiintiva vivavata, tenavu vira vakaukavaravata, ai qumina kaiqa vaiinti vairerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Iutaava minti tuvaro Iohepiva aqao tiro, Kia te ni ekaa rumpa karaiti, vira utaqi ti kaapu rantakaa vaiintira, viraqai rumpa taariraro viva maini vaiharo ti qumina kaiqa vaiinti variarire. Ne hini kiaka homa nenta qova vainaini qaqi vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Iohepiva minti tuvaro Iutaava Iohepira aumanto oruntero virara tiharo, Mpo, nora vaiintio, kairaqe te vo uva ai tiva amiare. Te minti tiarirara are nora autu vataava Pero vaiinti voqaava variarava kia ti titiane. ");
INSERT INTO tbg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Are tota tinavuara tihara, Ni qova qaqie vaivo? Ni qata vovano vairove? tiaramanta ");
INSERT INTO tbg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","tenavu tiha, Tinavu qova naampaiqama viro qaqima vaivo. Viva naampaiqama viva vaiharo qorainti vainti vo vatatairave. Vira nova vitanta vatatairaqihairo vira vakaava qutu vuvaro vira qatavanoqai qaqi vaivaro vira qora muntukavano virara voqama kero vairave. ");
INSERT INTO tbg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tenavu vi uvara ai tiva amurara are tihara, Vi vaintira vita vare aniqe tevata vira tavaare, tiaramanta ");
INSERT INTO tbg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","tenavu ariara tiha, Nora vaiintio, vi vaintiva kia ho nai qora mini kero anianarove. Viva nai qora mini kero anirera, vira qova vaakama qutu vuanarove, tunarave. ");
INSERT INTO tbg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tenavu minti turara are tinavuara tihara, Ne kia nenta qata vira vita vare anivera, ne kia ho qaiqaa te iainanaini tuvu kara varevarave, tiaramanta ");
INSERT INTO tbg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","tenavu qaiqaa tentanavu qova vainaini orunte are tiana uvara vira tiva amuraro ");
INSERT INTO tbg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","viva tiharo, Anirante qaiqaa oru kara varaate timanta ");
INSERT INTO tbg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","tenavu virara aqao ti, Kia tenavu tentanavu qata vita vare vuarera, tenavu kia ho vi vaiintiva vainanaini qaiqaa virerave. Tinavu qatavano kia virera, tenavuvata kiama virerave, tunarave. ");
INSERT INTO tbg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tenavu minti turaro tinavu qova tinavuara tiharo, Ne iriarave. Ti naata vovano qorainti vainti taaraqanta vata timitairave. ");
INSERT INTO tbg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Vitantaqihairo vovano tiqaahairo ekaara viro, kia qaiqaa orurantero anumanta te virara oho, qaakau vairivano vira arukero ruqeqaama kaivo tivake kia vira qaiqaavata tavaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ne maa vaintiravata vita vare vivaro qora haikavano viraqaa qovaraiqirera, vira kaara ti muntuka qoraiqirava ti erera kauki vatauka aruma kaanarove, tirave. ");
INSERT INTO tbg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Tinavu qova minti tirara ti, te kia vira maaqu vitihainaara vita vare qaiqaa anirante vuariraro ti qova tavairaro viva kia ti hampata vairera, viva vaakama qutu vuanarove. Vira maaqu vitihainaava qaqi vairara tiro, tinavu qova qaqi vaivo. Vira maaquvano qutu viraro vira qovavata kia qaqi vairaitiro, qutuma vuanarove. Tenavu kia vi vaintira vita vare vuarera, vira muntukavano qoraiqirava vira erera kauki vataara aruma kaanarove. ");
INSERT INTO tbg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Te tenta qorara minti tunarave: Tevano viraqaa raqikiariraro kia qora haikavano viraqaa qovaraiqiarire. Te vira kia nina qaiqaa vita viri amiarera, vi uvava tiqaa ekaa entama varianarove, tunarave. Te tenta qorara minti tunarave. ");
INSERT INTO tbg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Mpo, nora vaiintio, virara iriharama tiqai rumpa tairaqe te tenta qata vira vatuka vare, maini ai qumina kaiqa vaiinti variariraro ti qata viva nai vakaukavara hampata qaqi vuarire. ");
INSERT INTO tbg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Te kia vira vita vare vuarera, nantiakee te tenta qova vainaini ho virarave? Mpo, kia ti tititairaqe te tenta qova vainaini orunte vira muntukavano nai maaquara qoraiqinara tavaare, tiro. Iutaava minti tura. ");
INSERT INTO tbg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iutaava minti tuvaro Iohepira muntukavano voqama kero qoraiquvaro vaiharo tavovaro nai kaiqa vaiintinavu nivuqaa iqi rataarirava aumaiquvaro viva ekaa vikara tiharo, Ne ekaa maaqihai vevante vuate, tumanta ekaa vevante vuvaro Iohepivaqai nai qata vakaukavara hampata vaiharo nai okarara vika tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Iohepiva tiva nimiharo voqama kero iqi rate vaumanta Isipi vatanaaka viva iqi rate vaura irumanta ekaa Pero vaiinti naavuqi kaiqa vare vaukavata Iohepiva iqi rate vaura irura. ");
INSERT INTO tbg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Iohepiva nai qata vakaukavarara tiharo, Te maa Iohepikave. Ti qova qaqie vaivo? tiro. Minti tumanta vira vakaukavara vi uvara iruvaro voqamake naatu itomantara ti, vika uva tiva kia vaura. ");
INSERT INTO tbg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Mintuvaro Iohepiva vikara vainto aniate tumanta vika vainto anuvaro Iohepiva tiharo, Te ni qata Iohepikama vauro. Ne vo vatanaakaqi ti monuara keha varomanta vika ti tivita vare Isipi maini viri korave. ");
INSERT INTO tbg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ho vate ne kia ti aatu qetaraiti, kia ne nentara airi avu aato utiha tiha, Kia tenavu mintiataarave tiate. Kotiva airi vaiinti nahentiara kia qutu viraiti qaqi variate tiro, viva ti naane ni nivuni vara komanta te aniavaunarave. ");
INSERT INTO tbg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Karara aavoqia ihiva taaraqanta aitaraivaro, 5 ihinavu qaqima vaivo. Kauquru ihiara vaiinti nahenti kiama ho kara utuke qantuke varevarave. ");
INSERT INTO tbg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ho Kotiva nivata ni vaintivaravata ruaruama nimitaari kia qutu viraiti qaqi variqi vuate tiro, viva ti naane maini tititairave. ");
INSERT INTO tbg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Mintirara ti, te kia niara ti tititaamantama anunarave tiraiti, te Kotiva ti varakaimanta maini anunarave turo. Kotiva ti varakaiva vivama ti noraiqama kaimanta te Pero vaiinti vira kaiqa vaiinti avuniqamake vaiha, ekaa Isipi vataqaa raqiki vauro. ");
INSERT INTO tbg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ne vaaka anirante vuru ti qora tiva amiha mintima tiate: Ai maaqu Iohepiva ariara mintima tivo. Kotiva ti noraiqama kaimanta te ekaa Isipi vataqaa raqiki vauro. Are kia mini varikera aniraitira, vaakama te unanaini aniane. ");
INSERT INTO tbg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Are homa Isipi maini ani vaihara vata vo Gosenini vainarave. Vi vatava ti aumantoma vaivo. Are, nena vaintivarave, nena naintivarave, nena sipisipive, memeraave, purumakauve, nena airaira vataanarave, ekaa vi haikara vi haikara katu varera maini ani vairaqe ");
INSERT INTO tbg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","te ariqaa raqikiare. Karara aavoqi ihiva 5navu qaqima vaivo. Are kia maini anirera, arevata ai hampata variakavata vehiqama vivorave. Mintima ti qora tiva amiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Iohepiva minti tivakero qaiqaa nai vakaukavarara tiharo, Nevata ti qata Benaminivavata ti tave variamanta te quqaa Iohepikama vauro. ");
INSERT INTO tbg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pero vaiintivano ti noraiqama kairaravata, ne ekaa haika maini Isipini vaiha tavaaravata, vuru ti qora tiva amiate. Viraqaahaima vira vaaka vita vare maini aniate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Iohepiva minti tivakero oru nai qata Benaminira kukuqama amiteharo iqi rate vauvaro Benaminivavata nai vakaara Iohepirara iqi rata amite vaura. ");
INSERT INTO tbg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Mintima kero Iohepiva nai vakaukavara vohaiqa vohaiqa moqakeharo kukuqama nimitora. Mintumanta vira naantiara Iohepira vakaukavara vira vataake uva ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mintuvaro Iohepira qata vakaukavara aninto vakaakava avuhainaa naavuqi vumanta Pero vaiintivano nai nora vaiintinavu vataakero vi uvara iri quaheha vaura. ");
INSERT INTO tbg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pero vaiintivano Iohepirara tiharo, Nena qata vakaukavara mintima tiva nimiane: Ne nenta donkiqaa kara vara vaari rumpa vare anirante Kenaanini oruntema ");
INSERT INTO tbg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","nenta qorave, nenta vainti nahentive, ntita vare orurante maini ani vaiqe te koqe vata vo ni nimiari ne viraqaa koqemake variate, tiane. ");
INSERT INTO tbg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Minti tivakera qaiqaa maa uvaravata vika tiva nimiane: Ne maihai ohinavuvata ohi vekanavuvata vare vuru kaimanta ni vainti nahentivata ni qovavata viraqi vaarinte vaiha ho aniate. ");
INSERT INTO tbg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nenta hini airaira mini kerara kiama noraiqaake iriate. Maini Isipini koqe airaira vai haikava ni airairama varianarove tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Pero vaiintivano tuntema kero Iohepiva nai qata vakaukavara ohinavuvata ohi vekanavuvata nimumanta vika anirante vurama. Vika vire uvaro Iohepiva vika aaraini viha ne kararavata nimiro, ");
INSERT INTO tbg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","viva vika vohaiqa vohaiqa qaraaka utavaaqavata nimiro. Mintiharovata, Benaminira 300 silvaa monuvata qaraaka utavaaqa 5navu vatama kero amura. ");
INSERT INTO tbg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Maa haikara Iohepiva nai qora amitora: Isipihainaa koqe airaira, vo airaira vo airaira vara vaari qora donki 10navuqaa rumpa tero, mparetive, vo kara vo karave, vira qova aaraini aniharo naainara nahe donki 10navuqaa rumpa amitora. ");
INSERT INTO tbg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Mintima kero Iohepiva nai qata vakaukavara nititomanta vire uvaro viva vikara tiharo, Ne aaraini viha kiama nai ati nai ati iate, tivakero vika nititomanta vurama. ");
INSERT INTO tbg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nititomanta Iohepira qata vakaukavara Isipi mini ke Kenaanini nái qova vaunaini orunte ");
INSERT INTO tbg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","vira tiva ami tiha, Iohepiva qaqima vaivo. Viva Isipini vaiharo ekaa vi vataraqaa raqikiharoma vaivo, ti. Vika minti tuvaro Iekopiva voqamakero rantuma viro kia vika uvara quqaave tiraitiro vaumanta, ");
INSERT INTO tbg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","viraqaahai vika Iohepiva ekaa uva vika tiva nimura nái qora Iekopira tiva amuvaro viva ohi vekanavu Iohepiva varakora tavero, viraqaahairo vira muntukavano koqe uvaro viva quahakero ");
INSERT INTO tbg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","tiharo, Ne quqaama tiavo. Ti maaquvano Iohepiva qaqima vaivo. Kaiqe te qaqi variainanto vira tave, viraqaahai te qutuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Iekopiva minti tivakero viva ekaa nai u haikara katu varero Isipiniara vura. Viva aaraini viharo Besebaini oruntero nai qora Aisaakira Variqara ofaa vo iha quara amitora. ");
INSERT INTO tbg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mintimakero entaqi Iekopiva vaiteharo taira tave vauvaro Kotiva vira aarero tiharo, Iekopio, Iekopio, tuvaro Iekopiva tiharo, Vo, te mainima vauro, tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kotiva virara tiharo, Te Kotikave. Te ai qora Variqavanoma vauro. Are Isipini vinarara kia qeta raitira, qaqi mini vuane. Are Isipini oru vairaqe te are kuvuarama terauka airiqama kaari vika nora vatanaakama vaivarave. ");
INSERT INTO tbg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Are Isipini vi vairaqe te ai vataake mini virerave. Naantiara te Isipihai are kuvuarama terauka ntita vare qaiqaa maini vuru karerave. Are qutina entara ai maaqu Iohepiva ai vataakero varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kotiva minti tuvaro Iekopiva Beseba mini kero vura. Vira maaqunavu Pero vaiintivano ohi vekanavu nimura varake, nái naata vaintivata nái qora Iekopiravata, viraqi vika vaarike Isipini vurama. ");
INSERT INTO tbg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Vika Kenaanihai varato haikara, sipisipive purumakauve memeraave, voku airairavata varovaro Iekopiva ekaa nai kuvuarama toka hampata Isipini vura. ");
INSERT INTO tbg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iekopiva ekaa nai maaqu raavurave, nai naintinavuve, ntita varero Isipini vura. ");
INSERT INTO tbg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Iekopira hampata Isipiniara vu vaiinti nahentika nutu vaireva, maantimama vairo: Rubeniva (Iekopira maaqu avuhainaara) ");
INSERT INTO tbg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenira vira maaqunavu: Hanokira, Parura, Hesaronira, Kaamira. ");
INSERT INTO tbg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simioniva Simionira maaqunavu: Jemuelira, Jaminira, Ohaatira, Jakinira, Sohaara, Saurira. (Kenaani vatanaa nahenti vovano Saurira vatatora.) ");
INSERT INTO tbg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Rivaiva Rivaira maaqunavu: Gesonira, Kohaatira, Meraarira. ");
INSERT INTO tbg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Iutaava Iutaara maaqunavu: Erura, Onaanira, Seraara, Peresira, Siraara. (Eruka Onaanika Kenaanini vaiha qutu vura.) Peresira maaqutanta: Hesaronira, Hamurira. ");
INSERT INTO tbg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakaava Isakaara maaqunavu: Toraara, Puvara, Iopura, Simironira. ");
INSERT INTO tbg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuluniva Sebulunira maaqunavu: Seretira, Elonira, Iarerira. ");
INSERT INTO tbg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Rubeniva vo, Simioniva vo, Rivaiva vo, Iutaava vo, Isakaava vo, Sebuluniva vo, vinavuka Riaara maaqunavu vauvaro Riaava Mesopotemia vataini vaiharo vinavuka Iekopira vata amitora. Riaava nahenti vainti vovata Dainaara vatatora. (Riaara vaintivata naintivata vaireka, 33navu vaura.) ");
INSERT INTO tbg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaativa Gaatira maaqunavu: Sifionira, Hagira, Sunira, Esibonira, Erira, Arodira, Arelira. ");
INSERT INTO tbg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseva Asera maaqunavu: Imunaara, Isavaara, Isavira, Beriaara. Asera raavura: Seraara. Beriaara maaqutanta: Hebeka, Marakierika. ");
INSERT INTO tbg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Vinavuka 16navu Siripaara vaintive naintive vaura. Siripaava Riaara kaiqa nahenti variarire tiro, Labaaniva Siripaara vira amura. ");
INSERT INTO tbg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Iohepika Benaminika. Vitanta Iekopira naata Reserira maaqutanta vaura. ");
INSERT INTO tbg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iohepira maaqutanta: Manaseka Efaraimuka. Iohepira naata Asenaativa vi vaintitanta vatatora. Asenaativa Potiperaara raavuravano vauvaro Potiperaava kuariara tinavu variqave tivakeharo vira aare vau vaiintiva Oni vatukaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benaminira maaqunavu: Belaara, Bekera, Asabelira, Geraara, Nemaanira, Ehira, Rosira, Mupimira, Hupimira, Atira. ");
INSERT INTO tbg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Vi vaintinavuka 14navu Iekopika Reserika vaintive naintive vaura. ");
INSERT INTO tbg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daaniva. Daanira maaqu Husimira. ");
INSERT INTO tbg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napataariva. Napataarira maaqunavu: Jaselira, Gunira, Jesera, Siremira. ");
INSERT INTO tbg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Vi vaintika 7navu Bilihaara vaintive naintive vaura. Bilihaava Reserira kaiqa nahenti variarire tiro, Labaaniva Bilihaara vira amura. ");
INSERT INTO tbg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iekopira vaintive naintive vira hampata Isipini vuka kaara ntireka, 66navu vaura. (Iekopira maaqunavu naatavara kia kaara ntumanta vikavata Isipini vura.) ");
INSERT INTO tbg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Iekopivavata vira vaintive naintive Isipini vukavata, Iohepiravata, Iohepira maaqutanta Isipini vatatokavata, vika vika kaara ntireka, 70navu vaura. ");
INSERT INTO tbg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iekopiva Isipini oru viharo nai maaqu Iutaara atitero tiharo, Are avuni oruntera Iohepira tiraro viva Gosenini ani tinavu tivita kaarire, tivakero Goseni vataini oruntovaro ");
INSERT INTO tbg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Iohepiva nai ohi kaari qeramatoraqi vaari ntero nai qora vita kareva Gosenini oru vura. Iohepiva vika vaunaini oruntero nai qora ravaaqavutero kukuqeharo vukaiqama kero nai qorara iqi rata amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Iekopiva Iohepirara tiharo, Ho vate te tenta tivuqohai ai tavaurara are qaqi variaramantara ti, te qutirera qeramate vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Iekopiva minti tuvaro Iohepiva nai qata vakaukavaravata, nai qora vainti nahentinavuvata, tiva nimiro tiharo, Te oru Pero vaiintiara minti tirerave: Ti qata vakaukavarave, ti qora vainti nahentive, Kenaanini variaka vika te unanaini anintaavo. ");
INSERT INTO tbg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Vinavuka sipisipive, memeraave, purumakauve vikaqaa raqiki variakave. Vika nái quaravata airairavata katu vare maini anintaavo, tirerave. ");
INSERT INTO tbg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Te minti tivake Pero vaiinti tiva amiariraro viraqaahairo viva ni irero tiharo, Ne nana kaiqa vare variakave? tiramanta ");
INSERT INTO tbg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ne mintima tiate: Tentanavu qoka aanante, tenavu vaintikaa vaiha sipisipive memeraave vikaqaa raqikiqi vi vauraukave, tiate. Ne minti tivaro Pero vaiintivano niara, Ne homa Gosenini nentaraa vaiha nenta quara vataake variqi vivarave, tianarove, tiro. Isipi vatanaaka quaraqaa raqiki varia vaiintika hampata kia vohaaraqi vairerave tura kaara Iohepiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Iohepiva minti tivakero oruntero Pero vaiintiara tiharo, Ti qovavata ti qata vakaukavaravata Kenaani mini ke, nái quaravata airairavata ekaa varema maini Gosenini anintaavo, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","viraqaahairo nai qata vakaukavaraqihairo 5navu ntitakero Pero vaiinti avuqaa vuru kovaro ");
INSERT INTO tbg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pero vaiintivano vinavuka irero tiharo, Ne nana kaiqa vare variakave? tumanta vinavuka tiha, Tenavu tentanavu qoka aanante quaraqaa raqiki vauraukave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Minti tivake vinavuka tiha, Kenaani vatainivata kia kara vaivaro tinavu quaravata kara neva kia vaivo. Hoe are tinavu qaqi kairaqe tenavu Gosenini variare? ti. ");
INSERT INTO tbg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Vinavuka minti tuvaro Pero vaiinti viva Iohepirara tiharo, Ai qovavata ai qata vakaukavaravata are iananaini aniavo. ");
INSERT INTO tbg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ho Isipi vatavano vika vatavatama varianarove. Are koqe vata vo vika nimira vika nái quara vataake mini variate. Vika kairamanta Gosenini variate. Are tavaira vikaqihai vokiaka purumakauqaa raqiki kaiqara anomake taveka vaivera, vika homa ti purumakauqaavata raqikivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Minti tuvaro Iohepiva nai qora Iekopira vitero vuru Pero vaiinti avuqaa kovaro Iekopiva vira uva mantama amitovaro ");
INSERT INTO tbg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pero vaiintivano Iekopira irero tiharo, Are nanti nanti ihie vara kaaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Minti tuvaro Iekopiva Pero vaiintiara tiharo, Te maa vataraqaa vona vona variqi niha 130 ihima vara kauro. Ti qovavata ti kaivaqavavata airi ihiara variqi variaka variamanta te kia vika aanante airi ihi vairaiti, te vukaari utuqi viha variqi vunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Minti tivakero Iekopiva nai kauqu tuahera kero Pero vaiintiara Kotiva ai koqema amitaarire tivakero vira mini kero vurama. ");
INSERT INTO tbg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iohepiva nai qoravata nai qata vakaukavaravata ntita varero Pero vaiintivano tuntema kero, koqe vata vaunaini vika muntu kora. Vi vatava ekaa Isipini vau vatara, vo vata vo vata naatara kero koqe vata vauvaro vi vatava vatuka vo, Ramesesi tataaqa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Iohepiva vika mini vuru kero nai qoravata, nai qata vakaukavaravata, ekaa vika vainti nahentivata, kara nimumanta vika ho neha mini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Vi entara karara aavoquva anomakero ekaa vataini vauvaro Isipinivata Kenaaninivata kia kara vaumanta vi vatanaaka karara antuqa arura kaara kia vika kempuka vaumanta ");
INSERT INTO tbg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","vika oru Iohepiva vaunaihai monu aqukeha kara koqaamake varovaro Iohepiva vi monura vareharo vuru avuhainaa naavuqi vate vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isipi vatanaakavata Kenaani vatanaakavata kara vareha nái monu aquqi vivi, vuru taiqa kora. Mintumanta Isipi vatanaaka Iohepiva vaunaini orunte tiha, Mpo, kara qaqi tinavu timiane. Are kia tinavu kara timiraqe tenavu qutu vuarorave. Tinavu monu taiqama vivo. Mpo, qaqi tinavu kahaqiane, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Vika minti ti vauvaro Iohepiva tiharo, Ni monu taiqa virera, nenta quara ti timihama kara varaate, tumanta ");
INSERT INTO tbg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","vika nái ohive, sipisipive, memeraave, purumakauve, donkive, Iohepira amiha kara vare vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ho mintiaqi vuvaro vi ihiva aitarovaro vo ihi anintomanta Isipi vatanaaka qaiqaa Iohepiva vaunaini orunte tiha, Nora vaiintio, tenavu maa uvara kukeqa kaarorave. Tinavu monu taiqa vivaro ekaa tinavu quara vairi ariniqama vivo. Mpo, nana haikae ai amiha kara varaainarave? Tintanavu vaatave tintanavu vatave, vi haikavaqaima qaqi vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Are kia tinavu kara timirera, tenavu qutuma virarave. Mpo, are tinavu kahaqiane. Tenavu tentanavu vata airante taiqa vuarorave. Are kara tinavu timihara tinavuvata, tinavu vatavata, varaane. Tenavu rumpatai vaiintira voqaara vaiha Pero vaiinti kaiqa vara amitaariraro tinavu vatavano virainiqama vuarire. Mpo, karavata kuvukanaavata tinavu timiraqe tenavu kia qutiraiti, qaqi variqi viha utuke namaqi vuare, tura. ");
INSERT INTO tbg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Karara aavoqu ihiva qaqi vaumantara ti, Isipi vatanaaka minti tuvaro Iohepiva vika kara nimiharo vika vata varovaro vika vatavano Pero vaiintiniqama vura. ");
INSERT INTO tbg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mintuvaro Iohepiva ekaa Isipi vataihairo ekaa vi vatanaaka koqaama komanta vika Pero vaiinti paanaa kaiqa vara amitoka vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Iohepiva vika vata vareharo viva Isipi vatanaaka variqa kaiqa vara nimite vauka vata kia varora. Pero vaiintivano vika monu nimumanta kara varake ne vaurara ti, vika nái vata qaqi tuatora. ");
INSERT INTO tbg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Iohepiva vaiinti nahentiara tiharo, Ho te karaqohai nivata ni vatavata koqaama kauramanta nevata ni vatavanovata Pero vaiintiniqama vuavo. Ho maa kuvukanaara varema vuru vataqi utuate. ");
INSERT INTO tbg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Karavano qampiqero mpeqaiqira ne qantu vare rairake, 4navu nenta tuate, vohaiqa Pero vaiinti amiate. Ne vira tuateha namaqi vihama, hini kuvu varake qaiqaa utuqi vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Iohepiva minti tumanta vi vatanaaka tiha, Nora vaiintio, are kara tinavu timiaravera tenavu kia qutu viraiti, qaqi vauro. Mpo, are tinavu koqema timitera iaro. Tenavu Pero vaiinti paanaa kaiqa vara amitaqi virerave, ti. ");
INSERT INTO tbg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ho Iohepiva Isipi vatanaakara tiharo, Ne kara ututera rairake nenta 4navu tuate vohaiqa Pero vaiinti amiate, tivakero taatauto uvava maa entaravata qaqima vairo. Isipi vatanaaka nái variqa kaiqa vara nimite vauka vikaqai nái vata qaqi tuatovaro vika vatavano kia Pero vaiintini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ho Iekopivave vira vo autu Isareriva nai vainti nahenti hampata Isipini Goseni vataini variqiro vi vaura. Vika vato haikava airiqama vumanta vika vaintivaravata airitahaa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iekopiva 17 ihinavu Isipini variqiro viro, 147 ihi varakero qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Viva qutu vuarira entava aumaiquvaro Isareriva nai maaqu Iohepira aarama kero tiharo, Are nena kauqu aiqiqaa aqukehara nena kauqu hini ti avuntaraqaa vateharama tiriara, Kia ai Isipi vataini quntama tarerave, tiane. ");
INSERT INTO tbg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Te qutu vuarirara are Isipiqihaira ti vaata varera vuru ti qoravata ti kaivaqaravata quntama tonaini quntama taane, tuvaro Iohepiva tiharo, Are tianantemake te mintirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Minti tuvaro vira qova tiharo, Nena kauqu aiqiqaa aqukeharama te quqaa mintirerave tiane, tuvaro Iohepiva te quqaama mintirerave tuvaro viraqaahairo Isareriva nai taintaqaa vaiteharo Kotira autu tuahereharo vaura. ");
INSERT INTO tbg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Iekopiva variqiro vuvaro vo enta vovano Iohepira tiva amiro tiharo, Ai qova rovara varaivo, tuvaro Iohepiva nai maaqutanta Manaseravata, Efaraimuravata, ntita varero Iekopiva vaunaini vura. ");
INSERT INTO tbg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mini oruntovaro vovano Iekopira tiva amiro tiharo, Ai maaqu Iohepiva ai tavareva anintaivo, tuvaro Iekopiva vi uvara iriro inaaraiqa kempuka varero nai vaito taintaraqaahairo vaaviarama viro vaiharo ");
INSERT INTO tbg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Iohepirara tiharo, Te haaru Kenaanini Lusi vataini variavauraro Kotiva ekaa kempuka vataava ti tivuqaa qovarama viro ti koqema timitareva ");
INSERT INTO tbg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","tiharo, Te ai koqema amitaarirara are naantiara airi vainti vatatairamanta are kuvuarama terauka airima vaivarave. Are kuvuarama tenaraqaahai vo vatanaa vo vatanaaka qovarama vivarave. Te maa vatara ai amiariraro vi vatava aivata are kuvuarama teraukavata vika vatavanoma variqiro vuanarove turave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Iekopiva minti tivakero qaiqaa Iohepirara tiharo, Te kia Isipi maini anuna entara ai naatavano qorainti vainti taaraqanta ai vata amitairave. Te ai maaqu vitantara kia ti naintive tiraiti, te vitantara ti maaqutantave tirerave. Rubenika Simionika ti maaqutanta variantemake, ai maaqutanta Manaseka Efaraimuka ti maaqutantama vaivarave. ");
INSERT INTO tbg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Naantiara ai maaqu vonavu qovarama vivera, kia te vikara ti maaquve tiraiti, te vikara ti naintivema tirarave. Naantiara vinavuka nái vakaatantaqaahai vata varevarave. ");
INSERT INTO tbg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","˻Ai nova Reseriva kia vainti vonavuvata vataraitiro, vaaka qutuvira kaara te ai maaqutantara minti turo.˼ Haaru tenavu Mesopotemia vataihai Kenaanini aninte, Efaraata vatuka aumanto anuraro ai nova Reseriva qutu vimanta te aara auvahini vira quntama kaunarave, tiro. (Efaraata vatuka autu vo Betarihemi.) ");
INSERT INTO tbg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Iekopiva minti tivakero viva Iohepira maaqutanta tavero Iohepira irero tiharo, Maa tatantave? tuvaro ");
INSERT INTO tbg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iohepiva tiharo, Maa ti maaqutantave. Te Isipi maini vauraro Kotiva vitanta ti timirave, tuvaro Iekopiva tiharo, Vitanta ntite aniraqe te vitanta koqema nimitaaina uvara tiva nimiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Iekopiva anoma kero naampaiqama vuvaro vira avuvano kia koqema kero tavovarora tiro, Iohepiva nai maaqutanta vainto ntita vuru kovaro vira qova vitanta moqakero kukuqama nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Mintima kero Iekopiva Iohepirara tiharo, Ike, te haaru ai viri kia qaiqaa tavaainarave tiavauraro Kotiva ti qaqi kaimanta te ai viri tave, ai maaqutanta virivata tavauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Minti tuvaro Iohepiva oru nai qora auvoqihairo nai maaqutanta ntitero nai qora avuqaa kankakaaviro nai viri vataini kero, ");
INSERT INTO tbg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","viraqaahairo nai maaqu Manasera avuhainaara vitero Iekopira kauqu tanaraini kero, vira qata Efaraimura Iekopira kauqu kaanaaqaini kora. ");
INSERT INTO tbg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mintuvarovata, Iekopiva nai kauqu tanara tutukero ˻kia vira vakaaraqaa vataraitiro˼, vira qata Efaraimura qiataqaa vatero, hini kauqu kaanaaqa tutukero vira vakaara Manasera qiataqaa vatero, ");
INSERT INTO tbg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","viraqaahairo Iohepira koqema amitero tiharo, Kairaro Eparahaamika Aisaakika kaiqa vara amito Variqava maa vaintitanta koqe nimitaarire. Kairaro Kotiva tiqaa ekaa enta raqiki vaiva vitanta koqema nimitaarire. ");
INSERT INTO tbg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Vo haika vo haikavano ti qoraiqama kaantorave tiro, ti ruaruama timitai enseliva, vivama ai maaqutanta koqema nimitaarire. Kairamanta vaiinti nahenti maa vaintitantara iriha, ti naaqura Eparahaamira autuve, ti qora Aisaakira autuve, ti hutuve kia taurukaraiti, qaqi iriqi vuate. Kairamanta vitanta kuvuarama teka airiqamavi, airitahaa variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Iekopiva minti tivakero nai kauqu tanara vira qata Efaraimura qiataqaa vatovaro Iohepiva vira tavero kia quaharaitiro, nai qora kauqu tanara varakero vo vainti qiataqaa vatarare tiro, ");
INSERT INTO tbg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","nai qorara aqao tiro, Maa vaintira hoqarenaarave. Are nena kauqu tanara vira qiataqaa vataane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Minti tuvarovata, vira qova tiharo, Ti maaquo, te virara irunarave. Virara irunarave. Vira vakaara Manasera vaintivara vaireka, vikavata nora vatanaakama vaivarave. Mintirarovata, vira qata Efaraimuva nai vakaaravata aatara kero nora vaiintivano vairamanta viva kuvuarama taariraukavata nora vatanaaka, vo vatanaa vo vatanaaka vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Iekopiva minti tivakero viva Iohepira maaqutanta koqema nimitero tiharo, Naantiara Isareri vatanaaka vonavu vo vaiinti koqema nimitareka iha vika nitanta nutu ntevarave. Vika mintima tivarave: Kairaro Kotiva ni koqema nimitaira ne Efaraimuka Manaseka voqaantemake variate tivarave, tiro. Mintimakero Iekopiva vira qata Efaraimura avuni vatero, vira vakaara naantiaraini vatora. ");
INSERT INTO tbg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Iekopiva minti tivakero viva Iohepirara tiharo, Ho tavaane. Te qutu vuarirava aumantoma vaivo. Te qutu vuariraro Kotiva niqaa raqikiqi viharo naantiara viva ni ntita varero anirantero ninta naaqu taatoka vatainima vuru kaanarove. ");
INSERT INTO tbg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te Amo vatanaaka hampata tenta veva huruqohai raquqi viha vika naatarake varataavauna vatara, te vi vatara kia ai qata vakaukavara nimiraiti, aiqaima amuro, tura. ");
INSERT INTO tbg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Iekopiva minti tivakero ekaa nai maaqunavu naarama kero tiharo, Ne maini ani ruvaaquma vi vaiqe te naantiara niqaa qovaraiqiaina haikarara ni tiva nimiare. ");
INSERT INTO tbg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ne ti Iekopira maaqunavu ruvaaqumavi vaiha te tiaina uvara iriate. Te ni qoka Isarerika tiaina uvara iriate. ");
INSERT INTO tbg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubenio, arema te hoqare vatatauravave. Te qaraaka vaiinti variavauna entara ai vatatehama te ho vainti vataariraukave tiavaunarave. Arema avuni vatataurava vaiharama are nora vaiinti variararo ai kempukavata uritarakero vaivo. ");
INSERT INTO tbg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Are vaireva, huvura namarivano ekaa haika raaqu varaintema kera varianarave. Are hoqarenaa vaintivano vaiharavata, vo okara autuanara kaara are tuvitarairaro ai qata vovano ai vatuka varaanarove. Are ti nena qoka naata vontira nuvakera ti nena qoka vaitauna taintara qoraiqama kaanarave, tiro. (35:22) ");
INSERT INTO tbg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Minti tivakero Simionika Rivaikara tiharo, Vitanta qata vakaatantama variavo. Vitanta nai auvihehavaaqohai airi vaiinti arukaatantama variavo. (34:25-26) ");
INSERT INTO tbg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Vitanta kukeqavi vaiha uva tivaterara kia te quaheha vairarave. Vitanta ruvaaqumavi vaiinti aruke uvarara tiqe kia te vitanta hampata vairerave. Vitanta arara itomanta vaiinti arukorave. Purumakau qora vika kia ho qaiqaa nuate ti, vitanta vika aiqu aururu teqa korave. ");
INSERT INTO tbg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Oho, kairaro vitanta voqama kero arara itora kaara Kotiva vitanta qoraiqama nimitaarire. Naantiara te vitanta kuvuarama teka raumpirima kaari vika Isareri vataini vona vona hampiara voqaara vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Iekopiva minti tivakero viva Iutaarara tiharo, Iutaao, ai qata vakaukavara ai autuma tuahera kevarave. Are nena navutaaka naatarama kenarave. Ai qora maaqunavu ravenkavi ai quahama amitevarave. ");
INSERT INTO tbg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Are qaraaka raionivano aantau arukero nama kero anirantero nai vauraqi aiqu kauqu tututero vaitaira voqaarama variaro. Ti haruantorave tiro, kia vaiinti vovano vira vauraqama kairave. ");
INSERT INTO tbg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Iutaara ankuvano avuhainaa kauru totaqi vi vaivaro naantiara kauru qova tanava qovaraiqianarove. Vi vaiintiva Iutaara ankuqihairo qovarama viramanta ekaa naato vatanaaka vira uva iriqi vivarave. ");
INSERT INTO tbg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","˻Iutaara vaintivara airi uaini naaho vateva variainarara tiro˼, viva nai donki uaini naaqunta viraqaa kantaruma taanarove. Naare uaini tava tatike vate tanuraqi viva nai utavaaqa hiqaanarove. ");
INSERT INTO tbg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Vira avuvano vankora uaini voqaara vairaro, vira aaraivano naama hantaiqira voqaarama varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Iekopiva minti tivakero Sebulunirara tiharo, Sebuluniva nora namari auvahianta vairamanta vo sipi vo sipi viva vainanaini otu koqemake vaivarave. Sebulunira vatavano viviro, Saidoni vatuka aumanto vuru taiqaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Minti tivakero viva Isakaarara tiharo, Kempuka donkivano airaira ntuvataa utatanta avutana vaite vaira voqaara Isakaava vairave. ");
INSERT INTO tbg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Viva tavairaro aana varaaina vatukava koqe iro vairaro koqe vatavanovata mini vairaro viva qumina kaiqa vaiintivano vaiharo vukaari utiharo vo vaiinti kaiqa vara nimitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Minti tivakero viva Daanirara tiharo, Isareri hini anku vaintema kero, Daaniva nai navunaaka uva avuqavuqama nimitaanarove. (30:6) ");
INSERT INTO tbg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daaniva quqahivano/quaihavano aara auvahini vaintema kero varianarove. Ohivano anivaro quqahivano/quaihavano vira aiqu nkaqa kaivaro ravuku vivaro vira tauvaqaqaa vaiva tauvaqaihairo umpaihavu virave. Quqahivano/Quaihavano nkaqa kaintemakero, viva ˻nai navutaaka ntaihaanarove˼, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Minti tivakero viva tiharo, Noravauvo, te are tinavu ruaruama timitena entara vekama vauro, tivakero ");
INSERT INTO tbg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gaatirara tiharo, Gaativa vairamanta muara vaiintinavu vira arireka anivaro viva tuqantaaviro vika nái ntaihamaqiro vuanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Iekopiva minti tivakero Aserara tiharo, Aseva koqe vataqaa vairaro vi vataraqaahairo koqe karavano qampiqaanarove. Avuhainaa vaiinti ne karava vira vataqaahairo qampiqaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Viva Napataarirara tiharo, Napataariva diaavano nai vuataa ivaro kantaintema kero viva kantama vuanarove. Diaa naati koqera voqaantemake vira vaintivara vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iekopiva minti tivakero Iohepirara tiharo, Iohepiva naaquntavano airi tava irataira voqaara vairave. Vi naaquntava ruvu namari tataaqa vaivaro vira kaqivano hohaa vaura oru vi vairave. ");
INSERT INTO tbg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Iohepira navutaaka huru veva vare vira qoraiqama amitareka vira aruqi vuvarovata, ");
INSERT INTO tbg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Iohepiva kempukaiqama kero nai huru tuatovaro vira kauquvano kia popohovaro vaurave. Ti Iekopika Variqavano Iohepira kauqu kempukaiqama amitorave. Tinavu Isareriqaa Raqiki Vaiva Mpeqavano Iohepira kauqu kempukaiqama amitorave. ");
INSERT INTO tbg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ti ai qoka Variqavano ariqaa raqiki vairave. Kotiva ekaa kempuka vataava ai koqema amite vairara tiro, aaqu nti vaivaro vataqihairo koqe ruvu namari nte vairave. Kotiva ai koqema amitaira ai vaintivarave, ai purumakauve airi variate. ");
INSERT INTO tbg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kotiva ai koqema amitairaro are kara vara ututerava koqema kero qampiqaarire. Aiqinavano airi ihi varaintema kero, Kotiva ai koqema amitaarirava airi entama variarire. Iohepiva nai qata vakaukavaraqihairo nora vaiintivano vairara tiro, te koqema amitaaina uvava, ekaa vi uvava Iohepira qiataqaa variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Iekopiva minti tivakero Benaminirara tiharo, Qaakau vairivano karara voqama kero antuqa arivaro nintema kero, Benaminiva ni vairave. Viva toqaqivata erainainivata aantau aruke ne vairave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isareri anku 12navu vairara tiro, Iekopiva minti minti tivakeharo nai maaqu vinavuka vohaiqa vohaiqa uva tiva nimiharo koqema nimitora. ");
INSERT INTO tbg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Iekopiva minti tivakero viva nai maaqunavuara qaiqaa tiharo, Te inaaraiqa varike qutu vi, tenta kaivaqaukavara hampata vairerave. Te qutu vuari ne ti vaata vare vuru ti kaivaqauka quntama to onavuraqi tivata quntama taate. Vi onavuva Hitihainaa vaiinti Efaronira vataini vairave. ");
INSERT INTO tbg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Haaru Eparahaamiva nai naata quntareva iharo Efaronira koqaa amiharo vi onavura varorave. Vi onavuva Kenaani vataini Mamarera Oqiva vainaini vaivaro vira tataaqa Makapera vatavano mini vairave. ");
INSERT INTO tbg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Eparahaamiravata vira naata Seraaravata viraqi quntama torave. Aisaakiravata vira naata Rebekaaravata viraqi quntama torave. Te tenta naata Riaaravata viraqi quntama taunarave. ");
INSERT INTO tbg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Eparahaamiva Hiti vatanaaka monu nimiharo onavu viravata, vatavata varorave. Ho minima tivata quntama taate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ho Iekopiva ekaa vi uvara nai maaqunavu tiva nimi taiqa kero, viraqaahairo viva nai taintaqaa vuru vaiteharo qutu vura. ");
INSERT INTO tbg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iekopiva qutu vuvaro vira maaqu Iohepiva nai qora vaataqaa aquviro vira moqa kero virara iqi rata amitora. ");
INSERT INTO tbg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mintimakero Iohepiva nai kaiqa vaiintinavuara tiharo, Ti qora vaata ntera vuantorave. Ne vira vaataqaa vo qara i haikara aqu amitaivaro kia nteraarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Minti tumanta vi kaiqara tavoka 40 enta kaiqa varaqi viha vira vaata kempukaiqama amitovaro kia ntera vura. Ho Isipi vatanaaka 70 entanavu variqi viha Iekopirara iqi rata amitora. ");
INSERT INTO tbg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Iekopirara iqi rata amito entava taiqa vuvaro Iohepiva Pero vaiinti koqe avu aato ami vaukara tiharo, Ne maa uvara vare vuru Pero vaiinti tiva amiate, ");
INSERT INTO tbg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ti qova qutu vireva iharo tiriara tiharo, Nena kauqu aiqiqaa aqukehara mintima tiane: Tenta qova qutu viraqe te nai kaivaqaukavara quntama tonaini vira vaata quntama tarerave, tiane, tirave. Vi vatava Kenaanini vairave. Are ti qaqi kairaqe te tenta qora mini vuru quntama te qaiqaa orurante aniare. Minti tivakema ne Pero vaiinti tiva amiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Iohepiva minti tumanta vika vuru Pero vaiinti tiva amuvaro viva Iohepirara tiharo, Nena kauqu aiqiqaa aqukehara tinantema kera, nena qora vare vuru quntaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Pero vaiintivano minti tuvaro Iohepiva nai qora quntareva vura. Viva vire umanta Pero vaiinti koqe avu aato ami vaukavata, Isipi vatanaaka nora vaiinti vonavuvata, Iohepira hampata vumanta ");
INSERT INTO tbg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Iohepira qata vakaukavaravata, ekaa vira vainti nahentivata, vira hampata vurama. Vika vumanta vika vaintairave, sipisipive, memeraave, purumakauve, vikaqai Isipi vata Gosenini vaura. ");
INSERT INTO tbg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Airi vaiinti iqoka kaariqive, ohi tauvaqaqaave, Iohepira hampata vura. ");
INSERT INTO tbg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Vika oru vi, Ataati vatukaini uiti rapa qaqini varake vaunaini oruntora. Vi vatukava Iotani Namari hini mantaraini vaumanta vika mini orunte voqamake iqi rate vauvaro Iohepiva 7 entanavu mini vaiharo nai qorara iqi rata amitora. ");
INSERT INTO tbg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Vika mini vaiha noraiqaake iqi rate vaumanta Kenaani vatanaaka vika tave tiha, Ike, tavaate. Vika noraiqaake vo vaiintiara iqi rate variavo, tivake vi vatara autu nteha, Aperi-Misaraamive – Isipi Vatanaaka Iqi Rataanainive, tura. ");
INSERT INTO tbg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Iekopiva qutu vumanta vira maaqunavu viva tuntemake, ");
INSERT INTO tbg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","vira vaata vare vuru Kenaanini Makapera vataini ori onavuqi quntama tora. Eparahaamiva nai naata quntareva iharo Hitihainaa vaiinti vo Efaronira monu amiharo vi vatara varovaro vi vatava Mamarera Oqiva vaura tataaqa vaura. ");
INSERT INTO tbg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Iohepiva nai qora quntama tero, viraqaahairo vivavata ekaa vira hampata anukavata anirante Isipini vura. ");
INSERT INTO tbg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Vika qova qutu vumanta Iohepira vakaukavara tiha, Tinavu qova qutu vivo. Oho, tota tenavu Iohepira qora okara autu amitaunara kaara viva virara iritairera, tinavu qoraiqama timitaanarove, ti. ");
INSERT INTO tbg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Vika minti tivake vo vaiinti atiteha tiha, Are Iohepirara mintima tiane. Tinavu qova qaqi vau entara ");
INSERT INTO tbg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","viva ariara minti tirave, Ai vakaukavara ai qora okara autu amite uvara nunka nimitaane, turave. Mpo, are viva tuntema kera, vi uvara tinavu nunka timitaane. Tenavu ai qora Variqa vira kaiqa vaiintinavuma vauro, tiane, ti. Vika minti tuvaro viva Iohepira vuru tiva amuvaro Iohepiva vika uva iriharo iqi ratora. ");
INSERT INTO tbg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Mintumanta vira vakaukavara náivano Iohepiva vaunaini orunte vira avuqaa vataini kankakaamavi vaiha tiha, Ho tavaane, tenavu ai qumina kaiqa vaiintiqaima vauro, ti. ");
INSERT INTO tbg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Vika minti tuvaro Iohepiva aqao tiro, Kia qeteha variate. Kia te Kotira vatuka vareha niqaa uva vatareravauve vauro. ");
INSERT INTO tbg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Haaru ne qora okara autu timitareka uvarovata, Kotiva vi kaiqara tuqantaakero ti koqema timiteharo viva airi vaiinti nahenti kahaqama nimitomanta vika kia qutu viraiti, maa entara qaqi variarave. ");
INSERT INTO tbg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ho virara irihama ne kia vo haika aatu qeteha variate. Te niqaavata ni vaintivaraqaavata koqemake raqikiqi virerave, tiro. Iohepiva minti tivakero koqe uva nai vakaukavara tiva nimumanta vika kia qetaraiti, koqemavi vaura. ");
INSERT INTO tbg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iohepiva nai qora vainti nahenti hampata Isipini variqiro viro, 110 ihi varakero qutu vurama. ");
INSERT INTO tbg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iohepiva qaqi vau entara viva nai maaqu Efaraimura vaintivata, vira naintivata, tavora. Iohepiva Manasera maaqu Makiara, viravata taveharo quahama amitora. ");
INSERT INTO tbg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ho Iohepiva naampaiqama viro vaiharo nai qata vakaukavara naarama kero vikara tiharo, Te qutu vuarirava aumaiqivo. Te qutu vuariraro Kotiva niqaa raqikiqiro viharo ni ntita varero Isipiqihairo Kenaanini vuru kaanarove. Kotiva haaru nai kauqu aiqiqaa aqu keharo vi vatara Eparahaamira vo, Aisaakira vo, Iekopira vo, tiva nimiro tiharo, Te vi vatara ninavu nimirerave, turave, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Minti tivakero viva Iekopira vainti nahentiara tiharo, Ne nenta kauqu aiqiqaa aqukeha tenavu mintirerave, tiate. Naantiara Kotiva ni ntita varero Kenaanini vire ina entara, tenavu ai vuhaarivata vare, mini vuru quntama tarerave tiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Iohepiva minti tivakero viva 110 ihi varakova Isipini qutu vura. Viva qutu vumanta vira vaata ntera vuantorave ti, vo qara vo qara u haikara viraqaa aqu amite kempukaiqamake, viraqaahai vokiseqi vaati vatora. ");
INSERT INTO tbg_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iekopiva Isipiniara vumanta vira maaqunavu nái vaiinti nahentivata ntita vare vira vataake mini vura. Iekopira maaqunavu vira vataake vuka vika nutu vaireva: ");
INSERT INTO tbg_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubenirave, Simionirave, Rivairave, Iutaarave, ");
INSERT INTO tbg_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakaarave, Sebulunirave, Benaminirave, ");
INSERT INTO tbg_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daanirave, Napataarirave, Gaatirave, Aserave, vika vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iekopira vaintinavuvata vira naintinavuvata vaireka, 70navu vaura. Iohepiva naane avuni Isipini otu vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Iohepivavata vira qata vakaukavaravata Isipini variqi vi, vuru qutu vumanta vika navunaakavata Isipini variqi vi vuru qutu vura. ");
INSERT INTO tbg_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Vika qutu vumanta vika vaintivara Isareri vatanaaka vi vataraqaa variqi viha vainti kuvuaramaqi vumanta vika airiqamavi Isipiqi mpiqavi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mintuvaro Pero vaiinti vovano Iohepirara kia iruva qovarama viro Isipiqaa raqikiqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Viva nai vaiinti nahentiara tiharo, Ho tavaate. Isareri vatanaaka airitahaama variavo. Vika voqavata airiqamaqi viha tinavu haatara kevorave. ");
INSERT INTO tbg_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Naantiara iqoka raqi entava qovaraiqiramanta vika tinavu navutaaka hampata avitumavi tinavu hampata raquqi viha, maa vataraqaahai ruqemake vo vataini vivorave. Kaiqe tenavu vo aara ranta kaari vika kia voqavata airi qiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Minti tumanta viraqaahai Isipi vatanaaka vo vaiintinavu noraiqamake vinavukara tiha, Nenavu Isareri maara ntaina kaiqara nimimanta vika nora toqaavu nte vaira tinavu kaiqa vara timitaate, tumanta Isareri vika kaiqa vareha nora vatukatanta Pitomivata Ramesesivata autu nimitora. Pero vaiinti kara naavu variarire ti, vi vatukatanta autu amitora. ");
INSERT INTO tbg_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Isipi vatanaaka voqavata Isareri qoraiqama nimite vaumantavata, Isareri vika voqavata airiqamaqi vi vaura. Isareri vika qaqiqai airiqamaqi vi vaura kaara Isipi vatanaaka vika naatu voqamake qeteha vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Vika qete vaiha voqamake vihi vaahi tivaqi viha nora kaiqa, vo kaiqa vo kaiqa vika nimi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Isipi vika Isareriqaa kempukaiqamake raqiki vaumanta Isareri vika aaqatai vata taatauke naavu kaqera briki autukeve, naavu kaqe kaiqarave, naaho kaiqave vare vaura. Isareri vika nora kaiqa vare vaumanta Isipi vika kia vikara mpo ike tiva nimitaraiti, qaqiqai vihi vaahi ti vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Vi entara Siparaaka Puaaka vainti vatare u nahentika kahaqi vau nahentitanta vauvaro Pero vaiintivano vitantara tiharo, ");
INSERT INTO tbg_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Netanta tavaimanta Hiparu vatanaa nahenti vainti vatare imanta netanta vika kahaqiha tavaivaro qorainti vainti vatataivera, vika aruma kaate. Nahenti vainti vata taivera, netanta vika qaqi kaimanta variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Minti tumanta vitanta Kotira aatu qeteha kia Pero vaiinti uva iriraiti, Hiparu nahenti vika qorainti vainti vatatora qaqi ke vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Vitanta mintiaqi vuvaro Pero vaiintivano vitanta naarama kero irero, Netanta nantihae mintiavo? Nantihae netanta Hiparu nahenti vika qorainti vainti vatataara qaqi ke variavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Viva minti tumanta vitanta Pero vaiinti nai tiva ami tiha, Aqao, Hiparu nahenti vika vaireka, kia Isipi nahenti voqaara qakomake vainti vate variarave. Vika kempuka nahenti vaihara ti, vika vaaka vainti vatakaamanta naantiara tetanta ani vaunarave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Vitanta Kotira aatu qeteha kia qorainti vainti arukaraiti vauvarora tiro, Kotiva vitanta koqema nimitomanta vitanta náitantavata ho vainti vatatora. Ho mintimake Isareri vika vainti vataqi vivi, voqavata airiqamavi kempukaiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mintiaqi vi vauvaro Pero vaiintivano nai navunaa vaiinti nahenti tiva nimiro tiharo, Ne tavaimanta Hiparu qorainti vainti qaraaka vatateka vaivera, vika ravaaqavu vare Nairi Namariqi muntu aqu kaate. Hiparu nahenti vainti vatateka, vikaqaima qaqi kaate, tura. ");
INSERT INTO tbg_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Vi entara Rivaira ankuqiraa vaiinti vovano Rivaira vohaa ankuqiraa nahenti vo varatora. ");
INSERT INTO tbg_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Vi nahentiva vainti taiqama viro vuru qorainti vainti vatatero tavovaro vi vaintiva voqaraa vainti vauvaro vira nova Pero vaiinti aatu qeteharo taaramo torara vainti vira kukeqa tora. ");
INSERT INTO tbg_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Taaramo tora aitarovaro kia ho vira qaiqaa kukeqa taarirava vauvaro vira nova iri tavokero tanu vo rutantu kero, vira ataani kempuka iva/qumeqohairo taatau kero, vainti vira vaati viraqi vaita kero, tanu vira varero Nairi Namari qupu vauraqi muntu vatovaro ");
INSERT INTO tbg_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","vira nakaava vutunto himpi vaiharo nai qata viraqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mini vauvaro Pero vaiinti vira raavuravano namari tuntireva Nairi Namari tuvunaini nai kaiqa nahentinavu hampata otuntero hini mantaraini vaiharo tavovaro tanuvano qupu vauraqi vauvaro, viva nai kaiqa nahenti tanu vira varaarire tiro, atitovaro viva otu tanu vira mpaqi varero vuru amura. ");
INSERT INTO tbg_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Vuru amuvaro Pero vaiinti raavuravano tanu vira avu ravaqaakero tavovaro qorainti vainti naatiruvano viraqi vaura. Viraqi vaiharo iqi rate vauvaro vira tavero virara ike mpo tiva amitero tiharo, Mpo, maa vaintiva Hiparu vatanaa vaintiruma vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Viva minti tivakero vauvaro vainti vira nakaava oruntero Pero vaiinti vira raavurara tiharo, Hoe te Hiparu nahenti vo tiariraro viva vi vaintira naama ami vairara are viraqaa raqikiane? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Minti tuvaro viva tiharo, Ho mintiane. Oru nahenti vo vita varera aniane, tuvaro vira nakaava oru nai vi vaintira nora vita varero anuvaro ");
INSERT INTO tbg_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pero vaiinti raavuravano virara tiharo, Vainti naati maarauru vita varera naama ami vairaqe te virara iriha ai koqaa amiare, tuvaro vira nova nai vainti vira vitero naama ami vaura. ");
INSERT INTO tbg_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ho vainti viva noruqama vuvaro nahenti viva vainti vira vitero Pero vaiinti raavuravano vaunaini vuru kovaro viva virara nai maaqu variarire tiro, vira virikero vatora. Viva vainti vira autu nteharo, Mosirave – Mpaqikaunarave, tiro. Viva tiharo, Te vi vaintira namariqihai mpaqi kaunarave, tura. ");
INSERT INTO tbg_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ho Mosiva noruqamaviro vaiharo vo enta viva oru nai navunaaka kaiqa vare vaunaini oruntero tavomanta Isipi vaiintinavu vikaqaa raqiki vaiha vihi vaahi ti vaumanta vika nora kaiqa vukaari utukeha vare vaura. Mosiva mini vaiharo tavovaro Isipi vaiinti vovano Hiparu vaiinti vo, vira navunaara ruquti vaura. ");
INSERT INTO tbg_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Vira ruquti vauvaro Mosiva tuqantaa viro hini hini tavovaro kia vaiinti vovano vauvaro Mosiva oruntero Isipi vaiinti vira arukero, nuqa vauqita kero viraqi vira vaata kukeqa tora. ");
INSERT INTO tbg_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ho vira qararaa qaiqaa oruntero tavomanta vira navunaaka Hiparu vaiintitanta nai ari nai ari vauvaro Mosiva oruntero raqireva hoqaro vaiintirara eqaane tiro, Are nantiharae nena navunaara Hiparu vaiintintira raqi variaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mosiva minti tuvaro vi vaiintiva Mosira nai tiva amiro tiharo, Ae, tavave ai noraiqama kaivarae are tinavuqaa raqikihara tinavu uva avuqavuqireva auti variaro? Oho, are enta Isipi vaiinti vo aru kaanantema kera, tivata arukaare tirae auti variaro? tiro. Minti tuvaro Mosiva vi uvara iruvaro vira voqama kero aatu itovaro nai iriro tiharo, Oho, vaiinti nahenti te Isipi vaiinti aru kauna uvara iriavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ho Pero vaiinti vivavata vi uvara iriro vira kaara Mosira arukaare tuvaro Mosiva Isipiqihairo ruqemakero Midiani vataini variare tiro, mini oruntero namari kaqake nareka vata quvitora tataaqa oquviro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ho vaiinti vo Jetarova, viva vaiinti nahentiara Kotira aarama nimite vau vaiintiva vaumanta vira raavura 7navu vaura. Mosiva mini vaumanta Jetarora raavura 7navu aninte tiha, Kaiqe namari kaqake taanuqi qihia kaari tinavu qora sipisipivata memeraavata naate, tivake anintomanta ");
INSERT INTO tbg_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","vaiinti vonavu vikavata sipisipiqaa raqikuka nahenti vika namariqaahai nitite vauvaro Mosiva himpiro nahenti vika kahaqiharo namari kaqakero vika quara nimura. ");
INSERT INTO tbg_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mintumanta nahenti vika anirante nai qova Jetarova vaunaini oruntovaro viva vika irero, Nantihae vate ne vaaka orurante aniavo? ");
INSERT INTO tbg_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","tumanta vika tiha, Sipisipiqaa raqikia vaiintika namariqaahai tinavu titite vauvaro, Isipi vatanaa vaiinti vovano tinavu ruaruama timiteharo namari kaqakero tinavu quara nimimantara ti, tenavu vaaka anuro, ti. ");
INSERT INTO tbg_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Minti tuvaro viva nai raavura vika irero tiharo, Vi vaiintiva tanto vaimantae neqai aniavo? Vira aaraivaro maini ani tinavu hampata kara naarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Minti tumanta Mosira aarovaro mini vuvaro Jetarova virara tinavu hampata maini variane tuvaro Mosiva eo tuvaro Jetarova nai raavura vo, Siporara amuvaro varatero vaura. ");
INSERT INTO tbg_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Varatero vauvaro Siporava vainti taiqama viro qorainti vainti vatatovaro Mosiva vira autu nteharo, Gesomurave – Vo Vatanaarave, tiro. Viva tiharo, Te vo vataini vaiha vo vatanaa vaiintiqama vuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ho Mosiva vi vataraqaa airi ihiara vau entara Pero vaiintivano Isipini qutu vura. Mintumantavata, Isareri vika Isipini rumpatoka ke ke tivaqi viha tavave tinavu kahaqianarove ti vauvaro ");
INSERT INTO tbg_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Kotiva vika ke ke ti vaura iriro, nai kauqu aiqiqaa aqukeharo Eparahaamirave, Aisaakirave, Iekopirave, vinavukaqaa tivato uvara iritero ");
INSERT INTO tbg_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Isareri vika rumpatora tavero vikara iriharo vaura. ");
INSERT INTO tbg_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosira airaaviva Jetarova Midianihainaa vaiinti nahentiara iriharo Kotira aarama nimite vau vaiintiva vauvaro, vo enta Mosiva vira sipisipiqaavata memeraaqaavata raqiki vaiharo viva vika ntita varero aahara vata hini auvahini viro, Horepi Aiqinaini oruntora. Vi aiqinarara Kotira Aiqinave tunaini oruntero tavovaro ");
INSERT INTO tbg_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","inaara katariqaa iha ite vauvaro Noravano Kotiva atito enseliva iha auru voqaava qovarama viro vauvaro, Mosiva tavovaro ihavano kia katari vira tatoqa karaitiro, qaqi ite vaura. ");
INSERT INTO tbg_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Qaqi ite vauvaro Mosiva vira tavero tiharo, Ike, aahuva ihave. Nantivaroe ihavano kia katari tatoqake vaivo? Kaiqe te aumantohai orunte tavaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mosiva minti tuvaro Noravano Kotiva tavovaro Mosiva aumanto ani vauvaro viva katari avutaini vaiharo Mosira aarero tiharo, Mosio, Mosio, tuvaro Mosiva, Vo, te mainima vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Minti tuvaro Kotiva tiharo, Kia voqavata aumanto aniane. Are te vauna vatara turuaraini varianarara tira, ");
INSERT INTO tbg_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","nena aiquqaa nonku taanara qaqini rahunku kera variane. Te ai kaivaqaukavara Variqavanoma vauro. Te Eparahaamirave, Aisaakirave, Iekopirave, vikaqaa raqiki vauraukave, tiro. Kotiva minti tuvaro Mosiva qeteharo vira viri tavaarorave tivakero nai viri naavuma tero vaura. ");
INSERT INTO tbg_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mosiva mintima kero vauvaro Noravano Kotiva tiharo, Ti vaiinti nahenti Isipini variamanta Isipi vika qoraiqama nimite variara te tavaunarave. Isipi vaiinti kaiqaqaa raqiki variaka ti vaiinti nahenti vihi vaahi ti variamanta vika nora maaraqi vaiha ke ke ti varia uvara te irunarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Virara irihama te Isipi vatanaaka kauquqihai vika ruaruama nimitarera tuvuraukave. Te vika ntita vare nora vata, koqe vata vainaini vuru karerave. Maa entara vo vatanaa vo vatanaaka Kenaanive, Hitive, Amove, Peresive, Hivive, Jebusive, vi vataraqaa variarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Te tenta vaiinti nahenti ke ke ti varia uvara iri, Isipi vatanaaka vika qoraiqama nimite variaravata tavaunarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Are ti vaiinti nahenti ntita varera Isipi kera aitarera vuane ti, te ai Pero vaiintivano vainanaini atitaarirara vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Minti tuvaro Mosiva aqao tiro, Te qumina vaiintima vauro. Kia te ho Pero vaiintivano vainanaini orunte vira tiva ami, viraqaahai Isareri ntita vare Isipiqihai anirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Minti tuvaro Kotiva tiharo, Te ainti vairerave. Are ti vaiinti nahenti Isipiqihaira ntita viri kera, vika hampata maa aiqinaraqaa ti hutu tuahera kenarave. Vi entarama te ai atitauna okarara kankoma kera irira tihara, Quqaama Kotiva ti tititaivo tinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kotiva minti tuvaro Mosiva tiharo, Te Isareri vainaini orunte vikara tiha, Ni kaivaqaukavara Variqavano ti tititaimanta te ne ianaini anuro, tiari vika ti ireha, Ai atitai variqara autu ntaane, tivera, te vika nái nana uvae tiva nimirarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Minti tuvaro Kotiva Mosirara tiharo, Te Qaqi Variqi Vi Vauraukama vauro. Are Isareri vikara mintima tiane: Qaqi Variqiro Vi Vaiva, vivama ti tititaivo tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kotiva minti tivakero qaiqaa Mosirara tiharo, Maa uvarama Isareri vika tiva nimiane: Ni kaivaqaukavara Variqavano Noravano Kotiva viva Eparahaamirave, Aisaakirave, Iekopirave, vikaqaa raqiki vaiva, vivama ti tititaimanta anuro, tiane. Ti hutu mintimama vaivo. Vaiinti nahenti maa entara variakavata, naantiara enta vaikavata, vika mintima keha ti hutu ntevarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Are oruntera Isareri vaiinti noranavu ruvaaquma kera vikara mintima tiane: Ni kaivaqaukavara Variqa Noravano Kotiva viva Eparahaamirave, Aisaakirave, Iekopirave, vikaqaa raqiki vaiva, viva ti tivuqaa qovarama viro niara mintima tivo: Te ne varianaini otunte Isipi vatanaaka ni qoraiqama nimite variara tavaunarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Isipi vatanaaka ni qoraiqama nimite variara kaara te ni tenta vaiinti nahenti ntita vare Isipiqihai koqe vata vainaini ni vuru karerave. Maa entara vo vatanaa vo vatanaaka Kenaanive, Hitive, Amove, Peresive, Hivive, Jebusive, vi vataraqaa variarave. Kotiva niara mintima tivo tiane. ");
INSERT INTO tbg_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Are minti tiramanta Isareri vaiinti noranavu ai uva irivarave. Are vi uvara vika tiva nimira, vika ntita varera Pero vaiintivano vainaini oruntera virara mintima tiane: Noravano Kotiva Hiparu vatanaaka Variqavano tinavu avutana qovarama virave. Viva mintirara tira, are tinavu qaqi kairaqe tenavu Isipi maini ke, taaramo entara aahara vatavau vivi, mini orunte vaiha tentanavu Variqa vira ofaa iha quara amitaare, tiane. ");
INSERT INTO tbg_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ho Pero vaiintivano tiaina okarara te iruro. Kia te tenta kempuka okara vira umiqaarera, viva kiama ho niara vuate tianarove. ");
INSERT INTO tbg_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Virara irihama te tenta kempukaqohai Isipi vika ntaihaari vika te varaaina kaiqara aatu qete vaivaro, Pero vaiintivano ni qaqi kaira vivarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Te ni kahaqiari Isipi vika ni koqema nimitaimanta ne kia qumina viraiti, vika nimi airairaravata vare vivarave. ");
INSERT INTO tbg_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isareri nahentinavu vireka iha, vika oru Isipi nahenti nái tataaqa vaika utavaaqave, kori orive, silvaa orive aututaa haikara, vi haikara vi haikara timiate timanta nimimanta vare, vika vi airairara varake nái maaqu raavuraqaa aqu nimitaimanta vare vivarave. Mintima kehama vika Isipi ia haikara vare vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Minti tuvaro Mosiva tiharo, Te orunte Isareri vika tiva nimiari vika ti uvara una uvave, kia ai uva irirerave, kia Noravano Kotiva ai avuqaa qovarama virave tivera, viraqaahai te nantie irarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mosiva minti tuvaro Noravano Kotiva tiharo, Ho are nena kauquqi nana haikae tuataaro? tuvaro viva tiharo, Te kauruma tuatauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Minti tuvaro Noravano Kotiva tiharo, Are vira vataqaa aqu kaane, tuvaro Mosiva kauru vira vataqaa aqu kovaro kauru viva memaru kuqu vura. Memaru kuqu vuvaro Mosiva qeta kero kantovaro ");
INSERT INTO tbg_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Noravano Kotiva Mosirara tiharo, Are ravenkavira vekaihaira vira utu varaane, tuvaro Mosiva ravenkaviro vekaihairo vira utu varovaro memaruvano qaiqaa kauru kuqu vura. ");
INSERT INTO tbg_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mintuvaro Kotiva Mosirara tiharo, Isareri vika ariara tiha, Tinavu kaivaqaukavara Variqa Noravano Kotiva viva Eparahaamirave, Aisaakirave, Iekopirave, vikaqaa raqiki vaiva, quqaama viva ai avuqaa qovarama virave tiate, tira, are vika nivuqaa vaihara nena kauru qaiqaa vataqaa aqukaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Noravano Kotiva minti tivakero viva qaiqaa Mosirara tiharo, Are nena kauqu vo varakera nena vukai tavunaqi kukeqa taane, tuvaro Mosiva Kotiva tuntema kero nai kauqu kukeqa kero, viraqaahairo qaqini vara kero tavovaro vaata ne vau numuarava vira kauqu voqi voqi hantaiqiro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mintuvaro Kotiva tiharo, Qaiqaa nena kauqu tavunaqi kukeqa taane, tuvaro Mosiva Kotiva tuntema kero veta vatero qaqini vara kero tavovaro vira kauquvano hini vaata voqaantema kero, koqe kauqu vaura. ");
INSERT INTO tbg_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mintuvaro Noravano Kotiva tiharo, Are mintima kehara aahuva kaiqa nora kaiqa avuni varairamanta vika kia virara noraiqaake iriha ai uvara quqaave tivera, are naantiara varena kaiqara tavehama vika ai uvara quqaave tivarave. ");
INSERT INTO tbg_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Vika kaiqa vitanta tave, viraqaahai kia ai uvara quqaave tivera, are otu Nairi Namariqihaira namari kaqa varera vuru aahara vataqaa qihia kaane. Are mintiraro vi namariva naare kuqu viro vataqaa vairamanta vika vira tavehama ai uvara quqaave tivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Noravano Kotiva minti tuvaro Mosiva tiharo, Oho, Noravauvo, haaruvata maa entaravata kia te vaiinti nahenti nivuqaa vaiha koqe uva ti vaura vaiintika vaunarave. Te uva tirare turaro ti novano maara nte vaimanta vaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Minti tuvaro Noravano Kotiva tiharo, Vaiintivano vaivaro tavave vira no amivaro ho uva ti vairave? Tavave vira avu rampai kaivaro viva ho tave vairave? Tavave vira avu qimpa kaivaro kia ho tave vairave? Te Noravano Kotika vi kaiqara vi kaiqara vare vauraukave. ");
INSERT INTO tbg_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Are virara irihara oru viraqe te vaiha ai kahaqiarirara are ho uva tinarave. Te tenta uva ai tiva amiarirara are vi uvarama tinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Minti tuvaro Mosiva mpo tiro, Noravauvo, kia ti vara karaitira, vo vaiinti vara kairaro vi kaiqara varaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mosiva minti tuvaro Kotira arara itovaro viva tiharo, Ho ai vakaava Eroniva Rivaira ankuqiraavama vaivo. Viva koqema kero vaiinti nahenti nivuqaa vaiharo uva tiva nimi vairara irunarave. Viva ai vita kareva aaraini ani vaivo. Viva ai ani tavero quahaanarove. ");
INSERT INTO tbg_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Are uva vira tiva amiraro viva ai kahaqiharo vi uvara tiarire. Te vaiha nitanta kahaqiha nitantara vi uvara tiate tirerave. ");
INSERT INTO tbg_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Eroniva ai kahaqiharoma vaiinti nahenti uva tiva nimianarove. Are ti Kotika uva Eronira tiva amiraro viva ti uva vira vaiinti nahenti tiva nimiqiro vuarire. ");
INSERT INTO tbg_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Are nena kauruvata varera vuane. Are viraqohaira aahuva kaiqa nora kaiqa varairamanta vaiinti nahenti ti mpeqa okara tavaate, tiro. ...Kotiva minti tuvaro Mosiva oru nai naata vaintivata ntita varero Midiani mini kero anirantero aaraini viharo Horepi Aiqinaini nai vakaara Eronira vita kero ekaa vi uvara vira tiva amura... ");
INSERT INTO tbg_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ho Mosika Eronika Isipini orunte, Isareri vika qiata vaiintinavu ruvaaquma kora. ");
INSERT INTO tbg_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Vika ruvaaquma kero Eroniva Noravano Kotiva Mosirara tu uvara, ekaa vi uvara vika tiva nimuvaro Mosiva vika nivuqaa vaiharo aahuva kaiqa nora kaiqa varomanta vika ");
INSERT INTO tbg_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","vi kaiqara tave tiha, Quqaama Kotiva ai varakaivara aniaro, tivake tiha, Quqaama Kotiva tuvuntero Isipi vika tinavu qoraiqama timite variara tavaivo, tivake viraqaahai vika nái viri vataini ke, Kotira autu tuahere vaura. ");
INSERT INTO tbg_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ho viraqaahai Mosika Eronika Pero vaiintivano vaunaini orunte virara tiha, Isareri vatanaakaqaa raqiki vai Variqava Noravano Kotiva mintima tivo: Are ti vaiinti nahenti qaqi kairamanta vika oru aahara vataini vaiha ti quahama timiteha ti hutu tuahera kaate, tirave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Minti tuvaro Pero vaiintivano aqao tiro, Tavave nitanta Variqa Noravano Kotiva vaivo? Nanarae te vira uva iriha ni Isareri kuvantu kaari vivarave? Kia te ni Variqa Nora Kotirara irunarave. Te kiama ni Isareri kuvantu kaari vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Viva minti tumanta vitanta tiha, Tinavu Hiparu vatanaaka Variqavano tinavu avutana qovarama virave. Are tinavu qaqi kairaqe tenavu aahara vataini taaramo entara vivi, mini oru vaiha Nora Kotira ofaa iha quara amitaare. Tenavu kia mintiarera, Kotiva nora aiha viraarae tinavu timianarove, iqoka paipeqohairoe tinavu haruanarove, ti. ");
INSERT INTO tbg_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Vitanta minti tuvaro Pero vaiintivano Mosika Eronika tu uvara kia iriraitiro, vitantara tiharo, Oho, nantimantae netanta minti tiamanta vaiinti nahenti kia ti kaiqa vararaiti, qaqirake variavo? Netanta vika tiva nimimanta vika vaaka qaiqaa kaiqa varaate. ");
INSERT INTO tbg_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ne Isareri airiqamaqi vi vaiha tinavu Isipi haatarake tinavu kaiqa qaqira kareka auti variavo, tura. ");
INSERT INTO tbg_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Vohaa vi entaraqai Pero vaiintivano Isipi vaiintinavuve, Isareri vaiintinavuve kaiqaqaa raqikukara tiharo, ");
INSERT INTO tbg_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Hoqare ne Isareri kaiqa vaiintiqaa raqikiha vika kahaqiha ahaka veha varakeha nimi variamanta, vika aaqatai vata hampata taataukeha briki auti variarave. Ho vate maa entaraqaahai ne qaqira kaimanta, vika náivano ahaka veha rantakeha varaate. ");
INSERT INTO tbg_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Vika vira varakeha tota airi briki autuantemake, qaiqaavata vohaa qaramake autuate. Vika nanta muntuvike briki autivorave. Vika popohaimanta vaihara ti, vika qaqiqai tiriara tiha, Tinavu qaqi kairaqe tenavu oru tentanavu Variqa ofaa iha quara amitaare, ti variavo. ");
INSERT INTO tbg_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ne kaiqaqaa raqiki variaka vaiha, nora kaiqa vika nimimanta vare vaivaro toqaavu nte vaira vika kia ho Mosiva una uva tinara iriate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Pero vaiintivano minti tumanta Isipi vaiintinavuve, Isareri vaiintinavuve kaiqaqaa raqikuka vevante Isareri vika tiva nimi tiha, Pero vaiintivano mintima tivo: Kia nenavu qaiqaavata ahaka veha vare vuru Isareri kaiqa vaiinti nimiate. ");
INSERT INTO tbg_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kaimanta vika náivano voqi voqi niha ahaka veha rantakeha aaqatai vata hampata taataukeha briki autuate. Vika mintiaqi viha kiama taaraiqa autiraiti, tota airi briki autintemake, qaiqaavata vohaa qaramake autuate tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Minti tumanta Isareri vika ahaka veha rantareka ekaa Isipi vataini vi ani vaura. ");
INSERT INTO tbg_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Isipi vaiinti kaiqaqaa raqikuka vihi vaahi tivaqi viha vikara tiha, Hoqare tenavu ahaka veha ni nimura ne minti mintimake briki autuarave. Ho vate maa entaravata ne vohaa qaramake airi autuate, ti. ");
INSERT INTO tbg_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Isipi vaiinti kaiqaqaa raqikuka minti tumanta Isareri vika kia airi briki autu karaiti, taaraiqaqai autukora kaara Isipi vika oru Isareri vaiinti kaiqaqaa raqikuka qora kaavu numiqake vate tiha, Ni navunaaka airi briki tota autintemake, entavata vatevata autuataarave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Vika minti tumanta Isareri vaiinti kaiqaqaa raqikuka Pero vaiintivano vaunaini orunte nuntu nauntu tiha, Are nantiharae tinavu nena kaiqa vaiinti mintima kera qoraiqama timitaaro? ");
INSERT INTO tbg_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Are kia tinavu ahaka veha timitaraitira, tinavuara briki autuate tianarave. Ho ahaka veha kia vaimanta tenavu kia ho airi briki autu kaunara kaara Isipi vaiinti kaiqaqaa raqiki variaka tinavu qora kaavu humiqake vataavo. Oho, kia tinavu okaravauve vaivo, ninta Isipi okarama vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Minti tuvaro Pero vaiintivano aqao tiro, Ne popohara vaiintive. Ne mintiakara ti, ne tiriara tiha, Kairaqe tenavu tentanavu Variqa Nora Kotira ofaa iha quara amitaare, ti variavo. ");
INSERT INTO tbg_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Vaaka oru qaiqaa kaiqa varaate. Ne kiama ho tinavuqaahai ahaka veha varevarave. Ne nenta ahaka veha varakeha tota airi briki autintemake, maa entaravata vohaa qaramake airi autuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Pero vaiintivano tota autintemake maa entaravata airi autuate tura kaara Isareri vaiinti kaiqaqaa raqikuka iruvaro Pero vaiintivano nora maara vikaqaa vatomanta vika Pero vaiinti mini ke ");
INSERT INTO tbg_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","tavomanta Mosika Eronika vika veka vaumanta vika vitantara tiha, ");
INSERT INTO tbg_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Oho, kairaro Noravano Kotiva nintatanta kaiqa kaara nitanta qoraiqama nimitaarire. Nitanta okara kaara Pero vaiintivanovata, Isipi vaiinti kaiqaqaa raqiki variakavata, tinavu qoraiqama timite variavo. Vika tinavu aruke aarara netanta qovarama nimitaavo, tura. ");
INSERT INTO tbg_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Vika minti tuvaro Mosiva qaiqaa anirantero Nora Kotira aarero tiharo, Noravauvo, nantiharae are nora maara maa vatanaakaqaa vataaro? Oho, are mintirevae ti varakaanarave? ");
INSERT INTO tbg_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Te oru Pero vaiinti ai uva tiva amuna entaraqaahairo viva Isareri vika qoraiqama nimite vaivo. Vika qoraiqama nimite vaivara are nantiharae kia vika kahaqama nimitera iaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Minti tuvaro Noravano Kotiva Mosirara tiharo, Te Pero vaiinti autu amitaaina okarara are vate vaihara tavenarave. Te tenta kempuka vira umiqaariraro viva ni Isareri qaqi kairamanta vivarave. Te mintimake vira vahauru kaariraro Pero vaiintivano nai vataqihairo ni Isareri ntata kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","... Minti tivakero Kotiva Mosirara tiharo, Te Noravano Kotikave. Are te ekaa ai tiva amiaina uvara Isipiqaa raqiki vaira Pero vaiinti tiva amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Minti tuvaro Mosiva aqao tiro, Are irianarave. Kia te koqe uva ti vaura vaiintika vaunarara tiro, Pero vaiintivano kiama ti uva irianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mosiva minti tuvarovata, Noravano Kotiva tiharo, Te ai kempukaiqama kaariraro Pero vaiintivano ariara variqavema tianarove. Ai vakaava Eroniva paropeti vaiintivano uva tinantema kero, ai uva Pero vaiinti tiva amianarove. ");
INSERT INTO tbg_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Are te ekaa uva ai tiva amiainara Eronira tiva amiraro viva Pero vaiintiara Isareri qaqi kairamanta maa vataraqihai vuate tiarire. ");
INSERT INTO tbg_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Ho te Pero vaiinti avu aato kempukaiqama kaariraro viva kia nitanta uva ho irianarove. Are aahuva kaiqa, vo kaiqa vo kaiqa vira avuqaa qovarama kairarovata, viva kiama ai uva irianarove. Viva mintiaqiro viraqe, viraqaahai te anomake Isipi vika ntaihamake, tenta vaiinti nahenti vo anku vo anku ntita vare vi vataraqihai aitare virerave. ");
INSERT INTO tbg_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Te tenta kauqu tutuke Isipi vika ntaihamake, viraqaahai tenta vaiinti nahenti Isipiqihai ntita vare vuru kaaina entara Isipi vika ti okara kankomake iri tave tiha, Quqaama viva Noravano Kotivave tivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Viva minti tumanta Mosika Eronika Noravano Kotiva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Vitanta Pero vaiinti vataake uva tu entara Mosiva 80 ihi varakova vauvaro Eroniva vira vakaava 83 ihi varakova vaura. ");
INSERT INTO tbg_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Noravano Kotiva Mosika Eronikara tiharo, ");
INSERT INTO tbg_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Pero vaiintivano nitantara aahuva kaiqa vo qovarama kaiqe tavaare tirara are Eronirara nena kauru vata kanta aqukaane tiraro viva nai kauru vata kanta aqu kairaro vira kauruvano memaru kuqu vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kotiva minti tumanta vitanta Noravano Kotiva tuntemake Pero vaiintivano vaunaini orunte, viraqaahairo Eroniva Pero vaiinti avuqaavata, vira koqe avu aato ami vau vaiintika nivuqaavata, vaiharo nai kauru vata kanta aqu kovaro vira kauruvano memaru kuqu viro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mintuvaro Pero vaiintivano nai vure/quaha vaiintive, vo kaiqa vo kaiqa tavo vaiintikave, naarama komanta vika ani nái hepi kaiqa vareha ");
INSERT INTO tbg_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","vikavata nai kauru vata kanta aqu kovaro memaru kuqu vura. Mintuvaro Eronira memaruvano vika memaru ekaa nampiqama kora. ");
INSERT INTO tbg_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ho Noravano Kotiva Mosira tiva amuntemakero Pero vaiinti avu aatovano qaqiqai kempukaiqiro vauvaro viva kia vitanta uva iriraitiro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Mintuvaro Noravano Kotiva Mosirara tiharo, Pero vaiinti avu aatovano qaqiqai kempukaiqiro vaivaro viva kiama vaiinti nahenti qaqi kaira vivarave. ");
INSERT INTO tbg_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ho hura toqaqi Pero vaiintivano Nairi Namari vainaini otu virara arevata mini vuane. Tota ai kauruvano memaru kuquvira, viravata varera otu vira veka namari auvahini variane. ");
INSERT INTO tbg_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Are vira vita kera mintima tiva amiane: Noravano Kotiva Hiparu vatanaaka Variqavano ariara mintima tivo: Are ti vaiinti nahenti qaqi kairamanta vika oru aahara vataini vaiha ti hutu tuahera kaate. Tota te vi uvara ai tiva amurara are iriataara vaivara kia irianarave, tiane. ");
INSERT INTO tbg_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Qaiqaa Noravano Kotiva mintima tivo: Te vo kaiqa qovarama kaarirara are vi kaiqara taveharama tiriara quqaa viva Noravano Kotivave tinarave. Are minti tivakera Pero vaiinti qaiqaa tiva amiane: Are tavairaqe te tuatauna kaururaqohai Nairi Namari ruqutu kaariraro Nairi Namarivano naare kuqu vuarire. ");
INSERT INTO tbg_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Te mintima kaariraro Nairi Namariqi varia havukauka qutu vivaro vi namariva unta i vairamanta Isipi vika kia ho vi namarira nevarave, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Minti tivakero Noravano Kotiva qaiqaa Mosirara tiharo, Are Eronira mintima tiva amiane: Nena kauru tuata varera oru nora namariqaave, inaara namariqaave, aave vatairaro ekaa namarivano naare kuqu vuarire, tiane. Viva mintima kairaro ekaa namarivano Isipini naareqai kuquviro vairaro namari kaqake ne kurerave taqurave ekaa viraqi naare namarivanoqai variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Noravano Kotiva minti tumanta Mosika Eronika Kotiva tunte ura. Eroniva Pero vaiinti avuqaavata vira koqe avu aato ami vauka nivuqaavata vaiharo nai kauruqohairo Nairi Namariqaa aave vatovaro namarivano naareqama vuvaro ");
INSERT INTO tbg_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nairi Namariqi vau havukauka qutu vuvaro vi namariva voqama kero unta umanta Isipi vika kia ho vi namarira kaqake novaro naare namarivanoqai Isipini ekaa vo namari vo namariqi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Eroniva mintima komanta Isipi vure/quaha vaiintinavu vikavata nai hepi kaiqa autu kovaro namarivano naare kuqu vura. Mintuvaro Pero vaiinti avu aatovano qaqiqai kempukaiqiro vauvaro viva Noravano Kotiva ˻Mosira˼ tiva amuntema kero, kia Mosika Eronika tu uvara irura. ");
INSERT INTO tbg_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Viva kia vi haikarara noraiqaakero iriraitiro, qaqira kero nai avuhainaa naavuqi oru vaura. ");
INSERT INTO tbg_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nairi Namari kaqake neva kia vaura kaara Isipi vika namari kaqake nareka Nairi Namari auvahianta ora quvike namari kaqe vaura. ");
INSERT INTO tbg_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Noravano Kotiva Nairi Namari ruqutu kovaro 7 entanavu aitarora. ");
INSERT INTO tbg_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Viraqaahairo Noravano Kotiva qaiqaa Mosirara tiharo, Are Pero vaiintivano vainanaini qaiqaa oruntera ti uva maantima kera vira tiva amiane: Noravano Kotiva ariara mintima tivo: Are ti vaiinti nahenti qaqi kairamanta vika oru vaiha ti hutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Are kia vika kuvantu kairera, te airi eqavoka qovarama kaari vika Isipini vaiha ni Isipi vatanaaka qoraiqama nimitevarave. ");
INSERT INTO tbg_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nairi Namariqi eqavokavano airitahaa mpiqa viro, viraqihairo ai avuhainaa naavuqive, are vaite varianaraqive, are vaite variana taintaraqaave, mini mini vuanarove. Eqavokavano ai koqe avu aato ami varia vaiintika naavuqive, ai navunaaka naavuqive, kara unta ne varia hantaraqive, kara untareka tuqantaavi varia tanuraqive ekaa mini mini vuanarove. ");
INSERT INTO tbg_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Eqavokavano arive, ai koqe avu aato ami variakave, ai navunaakave, ekaa vikaqaa ravuku nteharo varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Noravano Kotiva minti tivakero qaiqaa Mosirara tiharo, Are Eronira mintima tiva amiane: Nena kauquqi kauru totenara tutukera nora namariqaavata inaara namariqaavata aave vataira namari viraqihai eqavoka airitahaa qovaramavi Isipi vataini vi aniate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kotiva minti tuvaro Eroniva Isipini nora namariqaave inaara namariqaave nai kauru aave vatomanta namariqihai eqavoka airitahaa qovaramavi Isipi vataqaa hihipaamavi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mintumantavata, Isipi vure/quaha vaiinti vikavata nái hepi kaiqa vareha vikavata eqavoka qovarama komanta namariqihai vataini vaarintora. ");
INSERT INTO tbg_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mosika Eronika eqavoka qovarama kovaro Pero vaiintivano vitanta naarama kero tiharo, Netanta Nora Kotira aaraivaro viva eqavoka tiqaahairovata, ti vaiinti nahenti vikaqaahairovata, vara qaqini kaarire. Netanta mintiqe te nitanta navunaaka qaqi kaari vika Nora Kotira ofaa iha quara amitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Minti tuvaro Mosiva Pero vaiintiara tiharo, Hove. Are vi entara kaama tairaqe te vi entaraqaa arive, ai koqe avu aato ami varia vaiintikave, ai navunaakave, vikara irihama Kotira aarama nimitaari eqavoka ekaa taiqa vimanta Nairi Namariqiqai qaqi variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mosiva minti tuvaro Pero vaiintivano tiharo, Hurama Kotira aarama timitaane, tiro. Minti tuvaro Mosiva tiharo, Ho hura are tinantemake, te Kotira aarama amitaarirara viraqaahaira are Nora Kotirara vivaqaima Variqavano vaivo tinarave. ");
INSERT INTO tbg_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Hura eqavokavano ai naavunive, ai koqe avu aato ami varia vaiintika naavuqive, ai vaiinti nahenti naavuqive, kia vairaiti, vika Nairi Namariqiqai vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Minti tivakero Mosika Eronika Pero vaiinti mini ke vevante vura. Mosiva Nora Kotira aareharo eqavoka qaqini varakaane tuvaro ");
INSERT INTO tbg_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Noravano Kotiva Mosiva tunte umanta eqavoka naavuqive, vahaaqainive, naahoqive vauka ekaa qutuvi taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Vika ekaa qutu vumanta Isipi vika eqavoka voqaa voqaa ruvaaqumake vatovaro ntereharo voqama kero unta i vaura. ");
INSERT INTO tbg_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero vaiintivano tavovaro eqavoka taiqa vuvaro viva nai avu aato kempukaiqama kero qaiqaa kia Mosika Eronika uva irireva auti vaura. Noravano Kotiva ˻Mosira˼ tiva amuntema kero, Pero vaiintivano kia vitanta uva irura. ");
INSERT INTO tbg_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ho Noravano Kotiva qaiqaa Mosirara tiharo, Are Eronirara mintima tiane: Nena kauruqohaira vataini konkoma rupitaitama kaane, tiane. Viva mintima kairaro Isipini konkomavano aaquqa kuqu vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kotiva minti tuvaro Eroniva nai kauruqohairo vataini konkoma rupitaitama kovaro, viraqihairo aaquqavano qovarama viro vaiintiqaave, quaraqaave, hihipaa iro vaura. Ekaa Isipi vataini konkomavano aaquqa kuqu vura. ");
INSERT INTO tbg_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mintumanta vure/quaha vaiinti vikavata mintiare tivake, nái hepi kaiqa autuvarovata, kia qovaraiqura. Ho aaquqa airitahaa vaiintiqaave, quaraqaave, hihipaa iro vaumanta ");
INSERT INTO tbg_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","vure/quaha vaiintinavu Pero vaiintiara tiha, Oho, Kotiva nai kempukaqohairo maa haikara qovarama kaivo, ti. Minti tuvarovata, Pero vaiinti avu aatovano kempukaiquvaro viva Noravano Kotiva ˻Mosira˼ tiva amuntema kero, kia vitanta uva iriraitiro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ho Noravano Kotiva qaiqaa Mosirara tiharo, Hura are vaaka toqaqi himpira Pero vaiintivano Nairi Namarini tuvuainara otu vitakera virara mintima tiane: Noravano Kotiva ariara mintima tivo: Are ti vaiinti nahenti qaqi kairamanta vika oru vaiha ti hutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Are kia vika nititairera, te vauvaari vara kaari vika ariqaave, ai koqe avu aato ami varia vaiintikaqaave, ai navunaakaqaave, hihipaamavi vaivarave. Vauvaari vika ni Isipi vatanaaka naavu maaqaqi mpiqavi, vatainivata hihipaamavi vaivarave. ");
INSERT INTO tbg_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Gosenini ti vaiinti nahenti varianaini, te mini qaqi vehakuma kaariraro kia vauvaarivano mini varianarove. Te mintiarirara are te Noravano Kotika maa vataraqaa variaina okarara kankomake irinarave. ");
INSERT INTO tbg_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Te ai vaiinti nahenti qoraiqama nimiteha, tenta vaiinti nahenti qaqi vehakuma nimitarerave. Hurama are te vi kaiqara varaainara tavenarave. Are minti tivakera Pero vaiinti tiva amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Noravano Kotiva minti tivakero vira qararaa viva vi haikara qovarama komanta vauvaari vika qovaramavi, airitahaa Pero vaiinti naavuqive, vira koqe avu aato ami vau vaiintika naavuqive, mpiqavi ekaa Isipi vataqaa hihipaamavi vaiha vi vatara qoraiqama kora. ");
INSERT INTO tbg_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mintuvaro Pero vaiintivano Mosika Eronika naarama kero vitantara tiharo, Netanta nenta navunaaka ntita vare, Isipi maini nenta Variqa ofaa iha quara amitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Minti tuvaro Mosiva aqao tiro, Kia tenavu maini vaiha Nora Kotira ofaa iha quara amitararave. Hauri tenavu mintiari vira kaara Isipi vika tinavuara qorahaama autuavo tivake ori utuvare, tinavu ruqutuqi viha tinavu haru kevorave. ");
INSERT INTO tbg_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tenavu Kotiva tintemake, Isipi maini ke taaramo entara aahara vatavau vivi, mini orunte tentanavu Variqa Nora Kotira ofaa iha quara amitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Minti tuvaro Pero vaiintivano tiharo, Hove, te ni qaqi kaari ne nenta Variqa Nora Kotirara iriha oru aahara vataini vaiha, nenta Variqa ofaa iha quara amitaate. Ne kia niaraini viraiti, aumanto oru vaihama ofaa iha quaraate. Ho tiriaravata irihama nenta Variqa Nora Kotira aarama timitaivaro ˻vauvaari taiqa vuarire˼, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Minti tuvaro Mosiva nai tiva amiro tiharo, Te ai maini ke, vate vira te Nora Kotira aaraariraro viva tiraro vauvaarivano niqaahairo taiqa vuarire. Hurama vauvaari vika arive, ai koqe avu aato ami varia vaiintikave, ai navunaakave, vika niqaahai vivarave. Oho, are kiama qaiqaa titanta una tiva timitehara, Isareri vatanaaka ravaaqavu kaira vika kia Nora Kotira ofaa iha quara amitareka vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Minti tivakero Mosiva Pero vaiinti mini kero, Nora Kotira aarovaro ");
INSERT INTO tbg_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","viva Mosiva tuntema kero vira uva irura. Vauvaari vika Pero vaiintive, vira koqe avu aato ami vau vaiintikave, vira navunaakave, mini ke vuvaro, kia qaiqaa vauvaari voqavanovata vaura. ");
INSERT INTO tbg_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mintuvaro Pero vaiintivano nai avu aato kempukaiqama kero, kia Isareri qaqi komanta vura. ");
INSERT INTO tbg_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ho qaiqaa Noravano Kotiva Mosirara tiharo, Are Pero vaiintivano vainaini oruntera mintima tiane: Noravano Kotiva Hiparu vatanaaka Variqavano ariara mintima tivo: Are ti vaiinti nahenti qaqi kairamanta vika oru vaiha ti hutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Are kia vika kaira vivera, ");
INSERT INTO tbg_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","te nora aiha viraara vara kaari ai ohive, donkive, kamerive, purumakauve, sipisipive, memeraave, ekaa qutu vivarave. ");
INSERT INTO tbg_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Te Isipi vika quaraqai qoraiqama nimite Isareri quara qaqi vehakuma nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Te Noravano Kotika hura mintirerave. Minti tivakera Pero vaiinti tiva amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ho vira qararaa Noravano Kotiva tuntema komanta ekaa Isipi quara rovara vare qutu vumanta Isareri quaraqihairo kia voqavanovata qutu vura. ");
INSERT INTO tbg_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mintuvaro Pero vaiintivano vi okarara nai navunaaka iromanta vika vira tiva ami tiha, Isareri quaraqihairo kia voqavanovata qutu vivo, ti. Minti tuvarovata, viva qaqiqai nai avu aato kempukaiqiharo kia Isareriara vuate tura. ");
INSERT INTO tbg_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ho Noravano Kotiva qaiqaa Mosika Eronikara tiharo, Netanta oru briki unte/nute varia naavuraqihai iha hanta varaate, tivakero Mosirara tiharo, Are Pero vaiinti avuqaa vaihara hanta vira virini aqu kaane. ");
INSERT INTO tbg_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Are mintima kairaro hanta viva konkoma voqaara ekaa Isipi vataini vi aniraro vaiintiqaavata quaraqaavata veqavano qovarama viro nora numuara itaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Minti tumanta vitanta oru briki unte vau naavuraqihai hanta vare, Pero vaiinti avuqaa oru vaura. Mosiva hanta virini aqu kovaro viraqaahairo vaiintiqaavata quaraqaavata veqavano qovarama viro nora numuara itora. ");
INSERT INTO tbg_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mintumanta Pero vaiinti vira vure/quaha vaiinti vika Mosira avuqaa oru variare tuvaro veqavano vikaqaavata vaura kaara vika kia ho Mosiva unaini oruntora. Veqavano vikaqaavata ekaa Isipi vatanaakaqaavata vauvaro ");
INSERT INTO tbg_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Noravano Kotiva Pero vaiinti avu aato kempukaiqama kovarora tiro, Noravano Kotiva Mosira tiva amuntema kero, Pero vaiintivano kia Mosika Eronika uva irura. ");
INSERT INTO tbg_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ho Noravano Kotiva qaiqaa Mosirara tiharo, Hura vaaka toqaqi himpira oru Pero vaiinti vita kera virara mintima tiane: Noravano Kotiva tinavu Hiparu vatanaaka Variqavano ariara mintima tivo: Are ti vaiinti nahenti qaqi kairamanta vika oru ti hutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Are kia vikara vuate tirera, te aivata, ai koqe avu aato ami varia vaiintikave, ai navunaakave, anomake ntaiharerave. Te mintiarirara are tiriara tihara, Mpo, kia vira voqaava vovano vataini vaivo. Vivaqaima Variqavano vaivo, tinarave. ");
INSERT INTO tbg_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Oho, te tenta kauqu tutuke nora rovaraqohai ni ntaihauraitirio, are nena navunaaka hampata haaruma taiqa vuaraitirio. ");
INSERT INTO tbg_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Are ti kempuka tavaira ekaa maa vataraqaa vaikavata ti hutuara iriate ti, te ai qaqi vehakuma amitaurara are qaqi varianarave. ");
INSERT INTO tbg_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Te ai mintima amite vauraravata, ai avu aatovano kempukaiqivara are kia ti vaiinti nahentiara ho vuate tiaro. ");
INSERT INTO tbg_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Vira kaara te hura maa kuari avuraqaa tiariraro taaruvano/kaampuravano noraiqaakero Isipi vataqaa ntuanarove. Haaru entavata maa entaravata kia minti taaruva/kaampurava nti vairave. ");
INSERT INTO tbg_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Virara irihara are nena navunaaka tiva nimira vika nái quara ntita vare haraara naavuni vuru kaate. Vaiintive quarave vahaaqaini vaivaro taaruvano/kaampuravano ntiharo vika ekaa aru taiqama kaanarove. Minti tivakera Pero vaiinti tiva amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kotiva minti tuvaro Mosiva Pero vaiinti tiva amumanta Pero vaiinti vira koqe avu aato ami vau vaiintika hini kuka Noravano Kotiva tu uvara iriha qeteha kante nái quaravata nai kaiqa vaiintivata ntita vare haraaraqi komanta ");
INSERT INTO tbg_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","hini kuka kia Noravano Kotiva tu uvarara noraiqaake iriraiti, nái kaiqa vaiintivata quaravata vahaaqaini komanta vaura. ");
INSERT INTO tbg_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mintuvaro Noravano Kotiva Mosirara tiharo, Nena kauqu tutukera naaruvaini aave vatairaro taaruvano/kaampuravano Isipi vataqaa ntiharo vahaaqaini vai haikara vaiintive, quarave, kara qampiqe vairave, ruqutu taiqa kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Minti tuvaro Mosiva nai kauruqohairo naaruvaini aave vatovaro Noravano Kotiva tuvaro naaruvavano karara ti vauvaro taaruvano/kaampuravano nti vauvaro aaquakaavano voqama kero airi tataa utiharo vata ari vaura. Noravano Kotiva tuvarora tiro, taaruvano/kaampuravano Isipi vataini nti vaura. ");
INSERT INTO tbg_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Taaruvano/Kaampuravano nti vauvaro aaquakaavano qaiqaa qaiqaa uti vaura. Haaru entavata kia taaruvano/kaampuravano mintima keharo Isipi vataini ntumanta tavora. ");
INSERT INTO tbg_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ekaa vi vataraqaa taaruvano/kaampura vano ntiharo ekaa vahaaqaini vau haikara vaiintive, quarave, karave, aru taiqa kora. Taaruvano/Kaampuravano ntiharo naahoqi kara qampiqora ekaa vataini ravantau vatero, ekaa katarivata hiqama kovaro kia marevata vaura. ");
INSERT INTO tbg_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mintuvaro Gosenini Isareri vatanaaka vaunaini kia mintura. ");
INSERT INTO tbg_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Mintima kero nti vauvaro Pero vaiintivano Mosika Eronika naarama kero tiharo, Oho, vate te Kotira uva raqama kauro. Noravano Kotiva avuqavu kaiqa varaimanta te tenta navunaaka hampata qora kaiqama varauro. ");
INSERT INTO tbg_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mpo, taaruvano/kaampuravano nti vaivaro naaruvavano karara ti vaivaro ti voqamakero haatu itaivo. Te ni nititaari homa vivarave. Te kia ni ˻Isareri˼ qaiqaavata ravaaqavu karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Minti tuvaro Mosiva nai tiva amiro tiharo, Te vevante maa vatukara maini ke te tenta kauqu tutuke Nora Kotira aaraariraro viva tiraro naaruvavano kia voqavata karara tiraro taaruvanovata/kaampuravanovata taiqa vuarire. Noravano Kotiva mintima kairara are Kotiva maa vataraqaa raqikiainarara kankomakera irinarave. ");
INSERT INTO tbg_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ho te iruramanta arevata ai koqe avu aato ami varia vaiintikavata kia Nora Kotirara noraiqaake iriraiti, kia vira aatu qeteha variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Vi entara baalivano mpeqaiqurara tiro, taaruvano/kaampuravano vira ravantau taiqa kero, utataari kuto naaquntara repa voqaara viravata ravantau taiqa kovaro, ");
INSERT INTO tbg_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","uitivano qaqi ahora vauvarora tiro, kia vira ravantau kora. ");
INSERT INTO tbg_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ho Mosiva Pero vaiinti mini kero vevantero vatuka aaqaini vaiharo nai kauqu naaruvaini tutukero Nora Kotira aarovaro aaqu tanta vuvaro taaruvano/kaampuravano taiqovaro naaruvavano kia uva tiraitiro, tirema vaura. ");
INSERT INTO tbg_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mintuvaro Pero vaiintivano tavovaro tirema vauvaro viva qaiqaa qora kaiqa varero. Vivavata vira koqe avu aato ami vau vaiintikavata nái avu aato kempukaiqamate vaura. ");
INSERT INTO tbg_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Noravano Kotiva Mosira tiva amuntema kero, Pero vaiintivano kia Isareriara vuate tura. ");
INSERT INTO tbg_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Noravano Kotiva qaiqaa Mosirara tiharo, Pero vaiintivano vainaini vuane. Vivavata vira koqe avu aato ami varia vaiintikavata ti nora kaiqa, vo kaiqa vo kaiqa tavaate ti, te vika avu aato kempukaiqama nimitauramanta vika kia ai uva iriavo. ");
INSERT INTO tbg_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Are naantiara nena vaintivata nena naintivata te Isipi vatanaaka ntaiheha nora kaiqa varaainarara vika tiva nimiane ti, te nora kaiqa vika nivuqaa qovaramake vaunarave. Te Noravano Kotika variaina okarara nevata kankomake iriate ti, te minti vaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kotiva minti tuvaro Mosiva Eronikantiro Pero vaiintivano vaunaini oruntero virara tiharo, Noravano Kotiva tinavu Hiparu vatanaaka Variqavano ariara mintima tivo: Nanti nanti entae are ti uva kia iriraitira, kia ti vevaaraini vainarave? Are ti vaiinti nahenti qaqi kairamanta vika oru ti hutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Are vikara kia vuate tirera, te hura kaintaaqa airitahaa maa vataraqaa qovarama karerave. ");
INSERT INTO tbg_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Vika airitahaa qovaramavi, vata maata hihipaama vivara are kia ho vata tavenarave. Vika vaiha taaruvano/kaampuravano kia qoraiqama kai naaho maatara namaqi viha taiqa kevarave. Vika naahovata, naahoqi vaina katariravata, ekaa nama taiqa kevarave. ");
INSERT INTO tbg_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Vika ai naavuqivata, ai koqe avu aato ami varia vaiintika naavuqivata, ni Isipi vatanaaka naavuqivata, oriqete mpiqama kevarave. Haaru entavata maa entaravata ai naaqukave, ai kaivaqaukave, kaintaaqa airitahaa qovarama vuainara kia tavorave, tiro. Mosiva minti tivakero tuqantaa viro Pero vaiinti mini kero vuvaro ");
INSERT INTO tbg_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pero vaiinti koqe avu aato ami vauka virara tiha, Oho, vi vaiintiva airi enta vaiharo tinavu qoraiqama timitaqi vuantorave. Are Isareri qaqi kaira vika oru nai Variqa Nora Kotira autu tuahera kaate. Are kiae kankoma kera iriaro? Isipi vatavano qoraiqama vivo, ti. ");
INSERT INTO tbg_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Vika minti tuvaro Pero vaiintivano Mosika Eronika qaiqaa naarama kero vitantara tiharo, Netanta nentatanta navunaaka ntita vare oru nenta Variqa Nora Kotira autu tuahera kaate, tiro. Minti tivakero vitanta irero tiharo, Netanta tauka taukae ntita vare vivarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Minti tuvaro Mosiva nai tiva amiro tiharo, Tenavu Nora Kotira autu tuahera karera vuainarara ti, tenavu ekaa tentanavu vaiinti nahenti qaraakaukave, konta naampaive, maaqu raavurave, purumakauve, sipisipive, memeraave, ekaa ntita vare virerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Minti tuvaro Pero vaiintivano aqao tiro nai kauqu aiqiqaa aqukero tiharo, Te nitanta Variqa Nora Kotira autuqaa mintima turo: Kia te ni nahenti vaintiara vuate tirerave. Oho, te tavaura ne ekaara ruqemake vireka auti variavo. ");
INSERT INTO tbg_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ne nenta Variqa Nora Kotira autu tuahera kareka ivera, ne vaiintiqai mini vuate, tiro. Pero vaiintivano minti tumanta vira kaiqa vaiinti vonavu Mosika Eronika ventaqi vi, vitanta vahaaqaini veva kora. ");
INSERT INTO tbg_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ho Noravano Kotiva qaiqaa Mosirara tiharo, Nena kauqu tutukera Isipi vataqaa aave vatairaro kaintaaqavano qovarama viro maa vataraqaa vi aniharo taaruvano/kaampuravano kia qoraiqama kai naaho maatara namaqi viharo taiqa kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Minti tuvaro Mosiva nai kauruqohairo Isipi vataqaa aave vatovaro Noravano Kotiva tuvaro uvaivano kuari urinaihairo vi entaraqaavata entaqivata utuqiro vi vaumanta vira qararaa toqaqi kaintaaqa vika uvai vataake anura. ");
INSERT INTO tbg_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Vika airitahaa Isipini orunte ekaa vataqaa hihipaamavi vaura. Haaru enta kia vira voqaara qovarama vurave. Naantiara entavata kia vira voqaara qovaraiqianarove. ");
INSERT INTO tbg_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kaintaaqa vika Isipi vataqaa hihipaamavi vauvaro vatavano konkiraiqama vurarama turo. Kaintaaqa vika taaruvano/kaampuravano qaqi ko naaho maatarave, katari tavave, namaqi viha ekaa nama taiqa kovaro Isipini katari mareve, naaho mareve, kia voqavata vaura. ");
INSERT INTO tbg_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Mintuvaro Pero vaiintivano vaaka Mosika Eronika naarama kero tiharo, Oho, te nitanta Variqa Nora Kotira uvavata nitanta uvavata raqa kauro. ");
INSERT INTO tbg_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Netanta ti qora uva qaiqaa tauru timite, nenta Variqa Nora Kotira aaraivaro viva kaintaaqa taiqa kairaqe te kia qutiraiti, qaqi variare, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Minti tuvaro Mosiva Pero vaiinti mini kero Nora Kotira aarovaro ");
INSERT INTO tbg_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Noravano Kotiva uvai tuqantaa kovaro uvaivano kuari avu ruhunkinaihairo utiharo kaintaaqa vikavata varero vevara Naare Namariqi muntuvi kovaro kaintaaqa voqavanovata kia Isipi vataini qaiqaa vaura. ");
INSERT INTO tbg_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mintuvarovata Noravano Kotiva Pero vaiinti avu aato kempukaiqama amitovaro viva Isareri vika kia qaqi komanta vura. ");
INSERT INTO tbg_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ho Noravano Kotiva qaiqaa Mosirara tiharo, Nena kauqu naaruvaini tutu kairaro konkiraiqiva Isipi vata maata anomakero ravaaqavu kairaro vaiintivano tupaupauma kero vi aniharo nuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Minti tuvaro Mosiva nai kauqu naaruvaini aave vatovaro konkiraiquva taaramo entara variqiro viharo Isipi vata maata ravaaqavu kora. ");
INSERT INTO tbg_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mintumanta Isipi vika kia ho vo vaiintivata tavaraiti, kia ho nái naavuqihai vevantaraiti vauvaro, Isareri vika vaunainiqai qaqi aatiteharo vaura. ");
INSERT INTO tbg_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Mintuvaro Pero vaiintivano Mosika Eronika naarama kero vitantara tiharo, Netanta nenta navunaaka hampata oru nenta Variqa Nora Kotira autu tuahera kaate. Ni nahentivata vaintivata homa ni hampata vivarave. Nenta sipisipive, memeraave, purumakauve, vikaqai maini ke vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Minti tuvaro Mosiva aqao tiro, Tenavu kia vikavata ntita vare viraiti qaqi vuarera, tenavu kia ho Nora Kotira ofaa ekaara kaintu iha quara amitarerave. ");
INSERT INTO tbg_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tenavu kia quara voqavata maini karaiti, ekaa ntita vare virerave. Tenavu tentanavu quara vikaqihai hini aruke Nora Kotira ofaa iha quara amitarerave. Tenavu mini kia viraiti maini variarera, tenavu vi quarara vi quarara arukaaina okarara kiama irirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mosiva minti tuvaro Noravano Kotiva Pero vaiinti avu aato kempukaiqama amitovaro Pero vaiintivano Isareriara kiama ho vivarave tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pero vaiintivano Mosirara tiharo, Kia ti avuqaa variane. Vuane. Kia qaiqaa ti aaqanto ani variane. Are qaiqaa ti aaqanto ani vaina entara are qutuma vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Pero vaiintivano minti tuvaro Mosiva nai tiva amiro tiharo, Ho are tinantemake, kiama te qaiqaa ai aaqanto ani vairerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ho Noravano Kotiva qaiqaa Mosirara tiharo, Te qaiqaa vohaa tataa Pero vaiintivata Isipi vikavata ntaihama kaariraro Pero vaiintivano ni qaqi kairamanta vuate. Vi entara viva ni nititeharo vuana vaina tiramanta ne ekaa vivarave, tura... ");
INSERT INTO tbg_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mosika Eronika Isipini vauvaro Noravano Kotiva vitantara tiharo, ");
INSERT INTO tbg_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ne Isareri maa torarama avuni vai toraravema tiate. Qaraaka ihi anintairaro vi toravama avuni varianarove. ");
INSERT INTO tbg_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Netanta ekaa Isareriara mintima tiate: Maa torara 10 entaqaa vaiintivano nai naata vaintiara iriharo memeraa naative, sipisipi naative, vohaiqa varaanarove. Ekaa Isareri vatanaa vaiinti vika nái naata vaintiara iriha mintima kehama varevarave. ");
INSERT INTO tbg_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Vaiintivano tavairaro kia vira vaintaira airi vaivera, viva homa nai aaqanto vaina vaiintira hampata memeraa naative, sipisipi naative, vohaiqa aruke nevarave. Ekaa vika mati namakeva ho vairera, vitanta homa vohaiqaqai aruke nevarave. ");
INSERT INTO tbg_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Viva arukaaina sipisipie, memeraae vaireva, qora vohaa ihi varakaainara vairaro vira vaataqaa kia numuara variarire. ");
INSERT INTO tbg_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ekaa Isareri vatanaaka nái sipisipi naatie, memeraa naatie, koqemake tuataqi vivi, vi torara 14 entaqaa vira aru kaate. ");
INSERT INTO tbg_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Vira aruke, vira naare kaqa vare, sipisipi naatie, memeraa naatie nareka i naavura qentiqaa aqutaate. Qenti vira hini hini auvahitantavata, virinivata, naare aqutaate. ");
INSERT INTO tbg_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mintimake viraqaahai ne sipisipi naati virae, memeraa naati virae, qaqi ihaqaa untake, entaqi vaiha vira naate. Ne vira nareka ihama naahara hunkavinaravata, mpareti kia taupatitira vainaravata, mati vira vataake naate. ");
INSERT INTO tbg_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ne mati vira kia qaraaka naate. Kia mati vira namariqi arake naate. Kia vira arara tuvu qaqini varakaraiti, qaqi vira kaintu ihaqaa untake naate. ");
INSERT INTO tbg_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ne kiama hini mati qaqi kaate. Toqaqi hini qaqi vairera, vira varake ihaqira quara kaivaro ita vuarire. ");
INSERT INTO tbg_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ne aaraini vireka i utavaaqara nonkute, suvata nonkute, kauru quru vare viravata kauquqi tuate, viraqaahai vi karara vaaka naate. Ne vi entara te Nora Kotika ni Vehakuma Nimitaaina Kararama nevarave. ");
INSERT INTO tbg_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Vi entara te entaqi Isipi vataini vi aniha ekaa avuni vatatera, qorainti vaintive, aantauvahi qora vaikave, aru taiqa karerave. Mintima keha te Noravano Kotika Isipi vika una variqanavu qoraiqama nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ne qenti hini hini katariqaa naare aqutera vira tave, virara te ni Isareri naavuma vaivo tirerave. Te naare vira taveha, ni vehakuma nimiteha qaqi aitare oru Isipi vikaqai ntaiharerave. ");
INSERT INTO tbg_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Te Noravano Kotika ni vehakuma nimitaaina okarara irihama, ne vo ihi vo ihi vi entaraqaa qaiqaa vi karara naate. Nevata ni vaintivaravata mintiaqi vuate. ");
INSERT INTO tbg_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Minti tivakero Noravano Kotiva qaiqaa tiharo, Ne 7 entara variqi viha taupatitira vataake untate mparetira kia naraiti, qaqi mparetiqai naate. Ne hoqarenaa entaqaa nenta naavuqihai ekaa taupatitira qaqira muntu aqukaivaro kia ni naavuqi variarire. Ne 7 entanavu variqi viha kia noqai mparetira viraqai naate. Niqihairo vovano taupatitira vataake untate mparetira namakairera, te vi vaiintirara kia ti navunaarave tirerave. ");
INSERT INTO tbg_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hoqarenaa entaqaavata ekaanaini 7 entaqaavata ne ruvaaqumavi vaiha ti hutu tuahera kaate. Vi entatantaqaa kia vo kaiqavata vararaiti, karaqai untakeha naate. ");
INSERT INTO tbg_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Naantiara ne vo ihi vo ihi maa entaraqaa ruvaaqumavi vaiha qaqi mpareti nehama maa entara te ni Isipihai ntita vuru kaaina entarara iritaate. Nevata ni vaintivaravata vi entara vo ihi vo ihiara iriqi viha variate, tiro... ");
INSERT INTO tbg_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kotiva minti tuvaro Mosiva Isareri vika nora vaiintinavu naarama kero vikara tiharo, Nenavu oru sipisipi naatie, memeraa naatie, kaamate vira aruke, nenta naata vaintiara irihama Kotiva vi entara ni Vehakuma Nimiteharo qaqi ori aatara kaaina karara qeramataate. ");
INSERT INTO tbg_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ne vi quarara aruke vira naare tanuqi kaqa vare, katari mare okuvera voqaara varake, naareqi quntamake naavu qenti hini hini auvahitantaqaa aqute, qenti virinivata aqute, viraqaahai naavuqi oru variate. Ne naavuqihai kia vevantaraiti, qaqi variqi vivi aatitake, toqaqi vevantaate. ");
INSERT INTO tbg_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Entaqi Noravano Kotiva Isipi vataini vi aniharo Isipi vika qorainti vainti kara hunka aruqi viharo viva ne qentiqaa naare aqutera taveharo, ni vehakuma nimitero qaqi vitaraanarove. Kotiva qioqama tairaro Arukaaina Enseliva kia ni naavuqi oriqetero ni qorainti vainti kara hunka aru kaanarove. ");
INSERT INTO tbg_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nevata nenta kuvuarama tekavata ekaa vo ihi vo ihi maa okararama avataqi vuate. ");
INSERT INTO tbg_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Naantiara Noravano Kotiva ni nimireva ina vataraqaa orunte, ne qaqiqaima vi karara namaqi vuate. ");
INSERT INTO tbg_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ni vaintivara niara ne nana karae ne variavo timanta ");
INSERT INTO tbg_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ne vika tiva nimi tiha, Haaru Noravano Kotiva tinavu Isareri vehakuma timiteharo tinavu naavu qaqi ai aatarakero oru Isipi vika qorainti vainti kara hunka aru korave tiate, tiro. Mosiva minti tumanta Isareri vika vi uvara iri, viraqaahai vika kankakaamavi vaiha Nora Kotira autu tuahera kora. ");
INSERT INTO tbg_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Noravano Kotiva Mosika Eronika tiva nimuntemake, Isareri vika mintura. ");
INSERT INTO tbg_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Vi entara enta avuta Noravano Kotiva Isipi vika qorainti vainti kara hunka avuhainaaka ekaa aru taiqa kora. Pero vaiinti vira vaintive, ekaa vo vainti vo vaintive, karapuhiqi vau vaiintika vika vainti kara hunkave, aantauvahi qora avuni vatatokave, ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Aru taiqa komanta Pero vaiintivanove, vira koqe avu aato ami vau vaiintikave, ekaa Isipi vikave, entaqi vika himpi, nái qorainti vainti qutu vura kaara noraiqaake iqi rate vaura. Ekaa Isipi vika naavuqihairo kia qorainti vainti kara hunka voqavanovata qaqi vauvaro ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ho vi entara entaqi Pero vaiintivano Mosika Eronika naarama kero vitantara tiharo, Netanta ekaa Isareri hampata himpi, tinavu Isipi ke, katu vare vuate. Netanta tota tintemake, oru mini Nora Kotira autu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Netanta tintemake, nenta sipisipive, memeraave, purumakauve, ntita vare vuate. Ne vireka iha nenta Variqa aaraivaro viva tivata koqema timitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Pero vaiintivano minti tumanta Isipi vikavata tiha, Oho, Isareri vika kia vaaka vivera, tenavu ekaa qutuma virarave, tivakeha Isareri vikara vihi vaahi tiha vaaka vuate ti vaura. ");
INSERT INTO tbg_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Minti ti vaumanta Isareri vika nái mpareti kia taupatitira vataake tuqantaatora kia untaraiti, qaraaka mpareti tanuqi qaqi vatora varake, tavunaqohai vira naavumake aqu vare vura. ");
INSERT INTO tbg_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mosiva tuntemake Isareri vika oru Isipi vika naariha tiha, Kori oriqohai aututaa haikarave, silvaa oriqohai aututaa haikarave, utavaaqave, timiate tumata Isipi vika vi haikara vi haikara vika nimura. ");
INSERT INTO tbg_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Noravano Kotiva Isareri vika kahaqurara ti, Isipi vatanaaka vikara nora vaiinti nahentive tivakeha vika vi haikara vi haikara qaqi nimumanta vare vura. Mintima keha Isareri vika Isipi vatanaaka vato airairara varora. ");
INSERT INTO tbg_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isareri vika himpi Ramesesi vatuka mini ke, vatavau vivi, Sukoti vatukaini oruntora. Vika vaiinti vaireka, 600,000 vaumanta vika nahentivata vaintivata airitahaa vaura. ");
INSERT INTO tbg_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Vika nái sipisipive, memeraave, purumakauve, ruhaaqiqi viha vumanta airi vo vatanaakavata vika hampata vura. ");
INSERT INTO tbg_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Isareri vika aaraini viha nái mpareti vare vura untake nora... Isipi vatanaaka vikara vuana vaina tumantara ti, Isareri vika kia ho mpareti taupatitira vataake untaraiti, vika aaraini viha vi mparetira qaqi untake nora. ");
INSERT INTO tbg_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isareri vika Isipi vataini 430 ihinavu variqi vura. ");
INSERT INTO tbg_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ho 430 ihi aitarovaro Noravano Kotiva vika kahaqumanta vika vi vatara ke, katu vare vurama... ");
INSERT INTO tbg_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","... Pero vaiintivano Isareriara ho vuate tuvaro Kotiva Isareri vika ntita varero kia Pirisia vataini qiqu aaraqaa viraitiro, viva vo aara, vukai aaraqaa vika ntita varero vura. Viva tiharo, Vika qiqu aaraqaa vimanta vo vatanaaka vika hampata raqireka auti vaivera, vika naatu qetake anirante qaiqaa Isipini vivorave, tivakero vika vukai aaraqaa ntita varero vura. ");
INSERT INTO tbg_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kotiva Isareri vika vo aaraqaa ntita varero aahara vataini viro, Naare Namari vaunainiara vumanta Isareri vika nái auvihehavaavata vare vura. ");
INSERT INTO tbg_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Haaru Iohepiva qutu vireva iharo viva nai qata vakaukavara Isarerira maaqunavuara tiharo, Kotiva naantiara ni kahaqira homa ne Isipihai katu vare vivarave. Vi entara ti vuhaarivata vare vuate, tivakero nai qata vakaukavarara tiharo, Nenavu kauqu aiqiqaa aqukeha tenavu mintirerave tiate, turara tiro, Mosiva vireva iharo viva oru Iohepira vuhaarivata varero Kenaanini quntareva vura. (Okara 50:25) ");
INSERT INTO tbg_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ho Isareri vika Sukoti mini ke oru Etamini aahara vata auvahini nái seri naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Vika aatitoraqaa aaraini vi vauvaro Noravano Kotiva quromuravano vaavi vauraqi vaiharo vika avuni viharo aara numiqomanta vi vaura. Entaqi Noravano ihavano vaavi ite vauraqi vaiharo vika aara ataama nimite vaumanta vika aara ho taveha vi vaura. Kotiva mintima nimite vaumanta Isareri vika aatitoraqaavata entaqivata ho aaraini vi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Aatitoraqaa quromuravano kia vika qaqira karaitiro, qaqi viva avuni vaavi vauvaro entaqi ihavano kia vika qaqira kero viraitiro, viavi iteharo vika avuni vi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","... Isareri aaraini vi vaumanta vokuka Pero vaiinti tiva ami tiha, Vika ruqemake vuavo, tumanta Pero vaiintivanovata vira koqe avu aato ami vau vaiintikavata tiha, Oho, tenavu kia vikara vuate tiataarave. Tenavu vikara vuate turamanta vika vuamanta tinavu kaiqa vara timiteka kia variavo, ti. ");
INSERT INTO tbg_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Minti tivake Pero vaiintivano tiharo, Ti iqoka kaarinavu qerama timitaate, tumanta qerama amitovaro viva nai iqoka vaiintinavuvata ntita varero vika avata varero vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Viva iqoka kaari 600vata varero, Isipini ekaa vo iqoka kaarinavuvata varora. Iqoka kaari vira varaqi nukavata vauvaro Pero vaiintivano vika hampata Isareri avataqiro vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Isareri vika ruqemake aaraini viha quahake vi vauvaro, Noravano Kotiva Pero vaiinti avu aato kempukaiqama amitovaro viva nai iqoka vaiinti ntita varero vika avataqiro vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Isipi iqoka vaiinti vokuka iqoka kaariqi vi vaumanta vokuka ohi tauvaqaqaa oquvi vi vaumanta vokuka vatavaura avataqi viha tavomanta Isareri vika Naare Namari auvahianta, Pi-Hahiroti vatukavata Baali-Sefoni vatukavata vaunaini, nái seri naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Isareri vika mini vaiha vutu tavovaro Pero vaiintivano nai iqoka vaiintinavu ntita varero ani vaumanta vika voqamake naatu itomanta oi aai ti vaiha Nora Kotira aare vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Vika Mosirara tiha, Oho, Isipini tinavu qunte vatava kia vaivarae are tinavu tivita varera maini aahara vataini aniaramanta tenavu maini qutu virarave? ");
INSERT INTO tbg_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Oho, quqaae tenavu Isipini vaiha ariara tinavu qaqi kairaqe tenavu Isipi vika kaiqa vara nimitaqi vuare tunarave? Oho, tenavu kia maini aniraiti, Isipi vika kaiqa vara nimitaqi vuataara vaimanta, tenavu qumina maini aahara vataini vaiha qutu virarave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Vika minti tuvaro Mosiva vika nái tiva nimiro tiharo, Ne kia qetaate. Ne kempukaiqamake vaiha Noravano Kotiva vate ni ruaruama nimitaaina okarara tavaate. Ne Isipi vatanaaka vate tave variaka kia qaiqaavata tavevarave. ");
INSERT INTO tbg_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Noravano Kotiva naivano ni kahaqiharo ni navutaaka hampata iqoka raquanarove. Ne kia iqoka raqiraiti, qaqima vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Minti tuvaro Noravano Kotiva Mosirara tiharo, Nantiharae are ti haare variaro? Are Isareriara tiramanta vika himpi vuate. ");
INSERT INTO tbg_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Are nena kauru tutukera nora namariqaa aave vatairaro namari vira hini hini rairaviraro avutantuna aahara vata vairamanta Isareri vika mintuna vuate. ");
INSERT INTO tbg_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Te Isipi vika avu aato kempukaiqama kaari vika qaiqaa ni avataqi vuate. Pero vaiintivanove, vira iqoka vaiintinavuve, iqoka kaarinavuve, ohinavuve, mintimake aniqe te vika naatara kaariraro ti hutuvano uritara kero varianarove. ");
INSERT INTO tbg_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Isipi iqoka vaiinti vikavata namari taqareka ivaqe te tenta okara vika numiqarerave. Vate Isipi vika anomake te Noravano Kotika mpeqa okara autuainara tavevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kotiva minti tuvaro viva atito enseliva, Isareri iqoka vaiintinavu avuni vura qaqira kero orurantero Isareri vika tauvaqaini aitare vauvaro, quromuravano vaavi vauvavata vika avuni vunaihairo aitarero vika tauvaqaini ani vaavi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Quromura viva Isareri hini Isipi hini avutana vaura. Mintiharo entaqi Isareri vika ataama nimiteharo, Isipi vika konkira aru nimitomanta vika kia ho tavora. Mintumantara ti, Isipi vika Isareri hampata raqiva kia ho vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ho Mosiva nai kauqu tutukero nora namariqaa aave vatovaro entaqi Noravano Kotiva tuvaro uvaivano noraiqaakero utiharo namari venta ventamaqiro vuvaro aahara vatavano qovarama viro vauvaro namarivano rairaviro hini hini vaumanta ");
INSERT INTO tbg_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isareri vika namari avutana aahara vata vaura vura. Namarivano hini hini vaavi vauvaro avutantuna aahara vata vauraqaa vika oritare vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mintumanta Isipi vika aninte tiha, Kaiqe tenavuvata mintuna vika avataqi vuare, tivake, Pero vaiinti ohinavuve, iqoka kaarinavuve, ohiqaa raqikukave, vikavata mintuna vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mintuvaro vira qararaa Noravano Kotiva quromuravano iha iteharo vaavi vauraqihairo tavomanta Isipi vika iqoka vaiintinavu mintuna vi vauvaro viva vika avu aato hampiqama kora. ");
INSERT INTO tbg_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Viva vika mintuma kora kaara, vika iqoka kaari aiqunavu horaqi rupeqa vumanta vika vukaari utukeha vi vaura. Vika tiha, Oho, Noravano Kotiva Isareri vikarao tiro, tinavu hampata raqi vaivo. Kaiqenavu qaqirake anirante vuare, ti. ");
INSERT INTO tbg_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Minti tuvaro Noravano Kotiva Mosirara tiharo, Nena kauqu qaiqaa tutukera namariqaa aave vatairaro namarivano anirantero viharo Isipivata, vika iqoka kaarivata, vika ohivata, ravaaqavu kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kotiva minti tuvaro Mosiva qaiqaa nai kauqu tutukero namariqaa aave vatovaro aatitareva ruvaahama vuvaro namarivano anirantero qoqaraanaini vura. Isipi vika ruqemake virare tuvaro Noravano Kotiva vika namariqohairo raqutu komanta vika namariqi qutu taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Namarivano anirantero viharo vika iqoka kaarivata, iqoka kaariqaa raqiku vaiintikavata, ekaa Isipi vatanaaka iqoka vaiintinavuvata, ravaaqavu kora. Isipi vika Isareri avataqi vuare tuvaro namarivano vika raqutu komanta qutu taiqa vuvaro kia voqavanovata qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isareri vikaqai qaqi aahara vatavaura vi vauvaro namarivano hini hini vaavi araviro vaumanta vika qaqi vitare vura. ");
INSERT INTO tbg_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Vi entara Noravano Kotiva Isareri kahaqiharo Isipi kauquqihairo ruaruama komanta Isareri vika tavovaro Isipi qutu vuka vaatavano namari auvahianta vona vona vaura. ");
INSERT INTO tbg_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isareri vika tavovaro Noravano Kotiva mpeqaiqama kero Isipi vika naatara komanta vika Nora Kotira aatu qeteha Kotira uvavata, vira kaiqa vaiinti Mosira uvavata irireka auti vaura. ");
INSERT INTO tbg_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Vi entara Mosiva Isareri hampata ihi tiharo Nora Kotirara mintima tiro: Noravano Kotiva tinavu navutaaka kempukaiqama kero naatara kairara ti, te vira autu tuahera keha virara ihi tirerave. Kotiva vika ohivata ohi tauvaqaqaa variakavata namariqi vara aqu kairave. ");
INSERT INTO tbg_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Noravano Kotiva ti kempukaiqama timitaimantara ti te ihi ti vauro. Vivama ti ruaruama timitaivo. Vivama ti Variqavano vaimanta te vira autu tuahera karerave. Viva ti qora Variqavano vaimanta te viva Noravano vainarara ihi tirerave. ");
INSERT INTO tbg_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Noravano Kotiva iqoka raqi vaiva taruvama vaivo. Vira autuvano vaireva Noravano Kotivave. ");
INSERT INTO tbg_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Viva Isipi iqoka vaiintinavuvata vika iqoka kaarinavuvata namariqi vara aqu kairave. Isipi vika iqoka vaiinti tarukavata Naare Namariqi aquvi qutu vuarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Varuva namari noravano vika ravaaqavu kairave. Orivano namariqi otinintemake, vikavata otinuarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Noravauvo, ai kauqu tanara nai mpeqa kauquma vaivo. Noravauvo, are viraqohaira nena navutaaka rukavu raakavumake varianarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Are Noravano mpeqaiqama kehara nina arireka iaka vara vataini aquke varianarave. Ihavano ahaka tatoqa kaintema kero, ai arara ite vaiva vika tatoqa aqu kairave. ");
INSERT INTO tbg_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Are nena aiho vuaqa kaararo nora namarivano hini hini vaavi araviro vairave. Vaantaavuravano vaavi vaintema kero, namarivano vaavi vairave. Nora namari veva muntukaraqi vai vatava aaharaiqama viro kempukaiqama viro vairave. ");
INSERT INTO tbg_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tinavu navutaaka tiha, Kaiqe tenavu vika avataqi vi, vika ravaaqavu kaare. Tenavu vika airaira raqiake vare, tentanavu antuqaqaa vi haikara rairake vararerave. Tenavu tentanavu iqoka paipeqohai vika vehi autu taiqa karerave, tiarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Minti tiavaravata, are nena aiho vuaqa kaararo namarivano Isipi vika raqutu kairave. Maara ntai oriva namariqi otinintemake, vikavata nora namariqi otinuarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Noravauvo, ta variqavave ari voqaara kempukavano vaivo? Areqaima kempukavano variaro. Areqaima Noravano variaro. Ai koqe okaravano uri aatarakero vaivo. Are nora kaiqa, aahuva kaiqa vare variaramanta vaiinti nahenti ai kaiqa taveha qete variarave. Kia vovano ai kaiqa voqaantemake varaariravama vaivo. ");
INSERT INTO tbg_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Are nena kauqu tanara tutu kaararo vatavano ai navutaaka nampiqama kairave. ");
INSERT INTO tbg_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Are tinavu aaqurihama timitehara tinavu kuvantu timitera tinavu tivita varera anianarave. Are nena kempukaqohaira tinavu tivita varera, nena takuqukera vainanaini tinavu vuru kenarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Naantiara vo vatanaa vo vatanaaka ai nora kaiqara iriha ai aatu qeteha aiqu kauqu ntiri ntiri iha vaivarave. Piristia vatanaaka voqamake naatu ite vairamanta vaivarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idomu avuhainaaka, vikavata naatu ite vairamanta vaivarave. Moapi vatanaaka vika qiata vaiintinavuvata qeteha aiqu kauqu ntiri ntiri iha vaivarave. Kenaani vatanaaka kia iqoka raquataa iramanta qaqira keha vaivarave. ");
INSERT INTO tbg_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ekaa vika ai okara taveha voqamake qeteha vaivarave. Noravauvo, vika ai mpeqa okara taveha voqamake qete vaiha qaqi himpite vaiqe tenavu ai vaiinti nahenti vika vara mini ke, qaqi vitare virerave. Tenavu are kuvantu timiterauka, vika vara mini ke qaqi vitare virerave. ");
INSERT INTO tbg_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Naantiara are tinavu tivita varera nena aiqinaqaa vuru kenarave. Noravauvo, vi aiqinarara are tihara, Te maini vairerave, tiananaini, are nena kauquqohaira aututaanara turuaraini tenavu vairerave. ");
INSERT INTO tbg_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Noravauvo, are avuhainaava vaihara ekaa entama raqikiqira vinarave, tiro. Minti tivakero Mosiva Isareri hampata ihi tura. ");
INSERT INTO tbg_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Isareri vika nora namari taqa vare aahara vatavaura vumanta Isipi vika iqoka kaarivata ohivata ohiqaa raqikukavata mintiare tuvaro Noravano Kotiva qaiqaa namari vira varakovaro namarivano vika raqutu komanta qutu vura. ");
INSERT INTO tbg_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mintuvaro Miriaamiva paropeti nahenti Eronira nakaava nai kauquqi tamparini tuatero rintatimaqiro viharo ihi ntavaqiro vumanta ekaa nahentivata vira avataqi viha nái kauquqi tamparini tuataqi viha ihi nte vauvaro ");
INSERT INTO tbg_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriaamiva vikara ihi maantimakero tiro: Noravano Kotiva tinavu navutaaka naatara kairara ti, te vira autu tuaherakeha ihi tiva amite vauro. Viva vika ohivata ohi tauvaqaqaa variakavata nora namariqi vara aqu kairave, tiro. Miriaamiva minti tivakeharo nai kena nahenti hampata vaiharo ihi tura. ");
INSERT INTO tbg_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Vika mintuvaro viraqaahairo Mosiva Isareri vika ntita varero Naare Namari mini kero taaramo enta Suri Aahara vataini viharo tavovaro kia vika ne namariva vaura. ");
INSERT INTO tbg_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kia vauvaro Mosiva vika ntita varero Marainive – Hunkavinainive tunaini oruntora. Vika mini vau namarira naare tuvaro namarivano voqama kero hunka vumantara ti, vika vi namarira kia ho nora. Vi namariva hunkavi namariva vaurara ti, mini autu nteha Hunkavinainive tura. ");
INSERT INTO tbg_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Namarivano hunkavura kaara vaiinti nahenti Mosirara nuntu nauntu tiha, Oho, tenavu nana namarie ho nararave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mosiva mpo ike tiharo Nora Kotira aarovaro Noravano Kotiva katari hanka vo vira umiqovaro Mosiva katari vira varero muntu namariqi aqu kovaro viraqaahairo namarivano koqema viro ho neva vaura. Isareri vika mini vauvaro Noravano Kotiva vikara nai uva maara iriha variqi vuate tiro, uva tiva nimiro, vika virara kempukaiqamake iriraravata avateharo vikara mintima tiro: ");
INSERT INTO tbg_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Te Noravano Kotika variari ne ti uva iriqi viha avuqavu kaiqa varaqi vivera, te niarao ti, Isipiqaa aihavira haika vataavaunara, vira kia niqaavata vatarerave. Te Noravano Kotika ne aihavira haika vare variaraqihai ni koqema nimite vauraukama vauro, tura. ");
INSERT INTO tbg_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ho Isareri vika aaraini vivi, Elimi vataini oruntora. Mini ruvu namari 12navu vauvaro deti katari vira tava ho neva 70navu vaumanta vika nái seri naavu maaqa namari vira tataaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isareri vika Elimini varike viraqaahai himpi aaraini oru vivi, aahara vata vo Senini oruntora. Isareri vika Isipi mini ke vuvaro taara toravata 15 entavata aitaromanta vika Senini oruntora. Elimi vata hini vauvaro Sainai vata hini vauvaro Seni vatavano tavaarana vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Vika aahara vata mini vauvaro kara neva kia vaumanta vika Mosika Eronika vaunaini orunte nuntu nauntu tiha vitantara mintima ti: ");
INSERT INTO tbg_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Oho, tenavu Isipini variavauna entara Noravano Kotiva tinavu harukaataarave. Tenavu Isipini variavauna entara, tenavu tentanavu naataa u karara mative, vo karave, ho neha variavaunarave. Netanta tinavu maini aahara vataini tivita viri kaamanta tenavu nararama vauro. Netanta mintiara kaara tenavu kia kara naraiti, qutuma virarave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Minti tuvaro Noravano Kotiva Mosira tiva amiro tiharo, Te naaruvaihai kara viavi tuta kaari ne ho varake naate. Vo enta vo enta vaiinti nahenti vi kararama nuntuke varevarave. Ne mintiaqi vi vaiqe te ne ti uva iri vaira avatamake tavarerave. ");
INSERT INTO tbg_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ne kara nuntuqi vivi, 6 entaqaa ˻7 entaravata irihama˼ kara nerara taara tataa airiqamake nuntuke vataate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Minti tumanta Mosika Eronika vaiinti nahenti ruvaaqumake tiva nimi tiha, Vate erainainima ne tiha, Quqaama Noravano Kotiva tinavu Isipihairo tivita varero maini viri kaimanta vauro, tivarave. ");
INSERT INTO tbg_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ne nuntu nauntu ti variara Noravano Kotiva irirara ti, ne toqaqima Nora Kotira mpeqa okara takuqi vaira tavevarave. Tetanta qaqi qumina vaiintitanta Kotira uva ni tiva nimi vaurauka vaunarara ti, ne kia titantara vauve nuntu nauntu ti variavo, ne Kotirarama nuntu nauntu ti variavo, ti. ");
INSERT INTO tbg_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mosika Eronika minti tivake qaiqaa Mosiva tiharo, Noravano Kotiva ne nuntu nauntu ti varia uvara irirara tiro, viva erainainima ni mati nimira, ne ho varake naivaro viva toqaqi ni vo karavata nimiramanta ne ho varake nevarave. Ne nuntu nauntu tiha kia titantaravauve minti ti variavo, ne Nora Kotirarama nuntu nauntu ti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mosiva minti tivakero Eronirara tiharo, Are vaiinti nahentiara mintima tiane: Noravano Kotiva ne virara nuntu nauntu ti varia uvara irirara ti, ne ruvaaqumavi vira avuqaa himpi variate, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Minti tuvaro Eroniva vaiinti nahenti qaqi tiva nimi vaumanta vika tuqantaavi aahara vata vaunaini vutu tavovaro vate vira tonavuqihairo Nora Kotira mpeqa okaravano takuqi vaiva qovarama vuvaro ");
INSERT INTO tbg_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Noravano Kotiva Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Isareri vika nuntu nauntu ti varia uvara te iruro. Are vikara mintima tiane: Vate enta ire iramanta ne mati varake ne, hura toqaqi vo karama nevarave. Ne mintimake viraqaahai te Noravano Kotika ni Variqavano vaunarara kankomake irivarave, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Minti tumanta vi entara eronaini uviri muavu voqauka airitahaavano qovaramavi vika seri naavu maaqa kaqatonaini hihipaamavi vaura. Mintuvaro vira qararaa toqaqi varavuvano vika naavu maaqa tataaqa vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ho varavuvano aaharauqama vumanta vaiinti nahenti tavovaro inaara katari hanka voqauka vo kanta vo kanta vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ho Isareri vika vevante vi haikara tave, vika nái uvaqihai tiha, Manaave? – Nana Haikave? tura. Vika vi haikara kia tavorara minti tuvaro Mosiva vika tiva nimiro tiharo, Vi haikava Noravano Kotiva ni nimitai karavama vaivo. ");
INSERT INTO tbg_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Noravano Kotiva niara tiharo, Ne vohaiqa vohaiqavano nuntuke varehama, nenta nentemake varaate. Nenta seri naavuqi variaka vikaravata irihama, vohaa kure vohaa kure mpiqakeha varaate tirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Mosiva minti tumanta Isareri vika vi karara nuntukeha varora. Hini vaiinti airi nuntuke varomanta hini vaiinti kia airi nuntuke varora. ");
INSERT INTO tbg_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Vika mintiaqi vivi tavomanta airiqamake manaa nuntuke varoka vika neva hoqai vauvaro kia airiqamake manaa nuntuke varoka vika nevavata vohaa qarama kero hoqai vaura. Vika vohaa entaqaa ne kararaqai nuntuke varora. ");
INSERT INTO tbg_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Vi karara nuntuke varovaro Mosiva tiharo, Ne kia qaqi kaivaro hini karavano hura qaqi variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Minti tumanta hini vaiinti nahenti kia Mosira uva iriraiti, vi karara hini qaqi vate, vira qararaa narare ti tavovaro iviruqavano vi kararaqi vauvaro vi karava ntereharo unta ura. Mintura kaara Mosiva vikara arara itovaro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Vo enta vo enta toqaqi vika vi karara nái ho nentemake nuntuke varovaro kuarivano uruntovaro hini qaqi ko karava ravitaviro taiqa vi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Vika vo enta vo enta nuntuqi vivi, 6 entaqaa 7 entaravata iriha taara tataa nuntuke varora. Mintumanta vika qiata vaiintinavu Mosiva unaini orunte vi uvara tiva amura. ");
INSERT INTO tbg_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mosiva vikara tiharo, Noravano Kotiva tiharo, Hura ti entama varianarove. Vi entaraqaa ne qaqi auraarama variate, tirave. Noravano Kotiva minti tirara ti, ne vate untate karara nema, hura ne karara qaqi vataate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mosiva minti tumanta vika 6 entaqaa vi karara hini namake, hini qaqi vate, vira qararaa tavovaro vi entaraqaa vi karava kia ntera viraitiro, qaqi vauvaro kia iviruqavanovata viraqi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mintuvaro Mosiva vaiinti nahentiara tiharo, Maa entara tenavu auraara variaina entava vaimantara ti, ne enta nuntu vataa karara vate naate. Vate tenavu Nora Kotirara iriha auraara vairerave. Ne vate vevante tavaivaro kiama vi karava vataqaa varianarove. ");
INSERT INTO tbg_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ne vo uiki vo uiki 6 entanavuara variqi viha vi karara nuntuke varevarave. Auraara Enta 7 entaqaa vi karava kiama vataqaa varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mosiva minti tumanta 7 entaqaa hini vaiinti nahenti kaiqe vi karara nuntuke varaare tivake vevante tavovaro vi karava kia vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mintuvaro Noravano Kotiva Mosirara tiharo, Oho, ne ti uva iriataarave. Taireve ne ti uva kia raqa karaiti, iriqi vivarave? ");
INSERT INTO tbg_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ne maa uvarama iritaate. Te Noravano Kotika niara vi entaraqaa auraara variate tunarara ti, te 6 entaqaa ni airi kara nimiari vi entaraqaa ne kararavata, vira qararaa ne kararavata, nuntuke varevarave. Ne 7 entaqaa kia nenta naavuqihai vevantaraiti, qaqi viraqi variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kotiva minti tumantara ti, vaiinti nahenti vi entaraqaa kia kaiqa varora. ");
INSERT INTO tbg_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isareri kara virara manaave tura. Manaavano vaireva, inaara auru hanta auru voqaara vauvaro vaiintivano vira neharo tiharo, Maa karava hani hampata untataa visiketira voqaarama vaivo, tura. ");
INSERT INTO tbg_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosiva tiharo, Noravano Kotiva tinavuara mintima tivo: Te Isipihai ni ntita vare vuru kauramanta ne aahara vataini variamanta te manaa ni nimunara, vi karara ne kuvuarama teka tavaate ti, vira nuntuke taqu voqi nonkuke qaqi vataate tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mosiva minti tivakero viva Eronirara tiharo, Are taqu vo varakera manaa viraqi mpiqa kera, Nora Kotira avuqaa vatairaro vairamanta naantiara vai vaiinti nahentika vi karara tavaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Mosiva minti tuvaro Noravano Kotiva Mosirara tuntema kero, Eroniva taqu voqi manaa mpiqa kero Kotiva uva tivakero taatauto Vokisera tataaqa vatovaro vaura. ");
INSERT INTO tbg_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isareri vika 40 ihinavuara aahara vataini variqi viha manaaqai namaqi vivi, viraqaahai vika Kenaani vataini oru vauvaro manaavano taiqa vura... ");
INSERT INTO tbg_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isareri vika Seni Aahara Vataini varike, viraqaahai qaiqaa aaraini vura. Vika aaraini vi vauvaro Noravano Kotiva vikara mini variate maini variate ti vaumanta vika vona vona variqi vi vaura. Ho vika Repintimi vataini orunte mini nái seri naavu maaqa kaqate tavovaro namari neva kia vaura. ");
INSERT INTO tbg_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kia vaumanta vika Mosiva unaini orunte qaiqaa nuntu nauntu tiha, Oho, are tinavu namari timiraqe naare, ti vauvaro Mosiva aqao tiro, Ne nantihae ti titi variavo? Ne nantihae Nora Kotira avate variavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Minti tumanta vaiinti nahenti namariara voqamake naataa umanta vika Mosirara nuntu nauntu tiha, Oho, are nantiharae tinavu Isipihai tivita varera maini aniaro? Are tinavuara vika nái vaintivata nái quaravata kia namari naraiti qutu vuate tirae, maini tinavu tivita varera viri kaaro? ti. ");
INSERT INTO tbg_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Vika minti tuvaro Mosiva Nora Kotirara mpo ike tiharo vira aarero, Te maa vatanaaka nantie irarave? Vika namari kaara ori utu vare ti haru kareka auti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mosiva minti tuvaro Noravano Kotiva virara tiharo, Are Isareri qiata vaiinti hininavu ntita varera, vaiinti nahenti avuni vihara nena kauru, haaru viraqohaira Nairi Namari ruqutukonara varera, ");
INSERT INTO tbg_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","oru Horepi Aiqinaqaa nora ori vovano vainaini vairaqe te ai aaqanto mini variarirara are kauru viraqohaira ori vira ruqutu kairaro namarivano viraqihairo tuvi vairamanta vaiinti nahenti vira naate, tiro. Minti tuvaro Mosiva Kotiva tunte iro Isareri qiata vaiinti nivuqaa vaiharo ori vira ruqutu kovaro namarivano viraqihairo tuvi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Isareri vika nuntu nauntu tiha Nora Kotira avateha, Viva tinavu kahaqianarove kiae kahaqianarove? turara ti, vaiinti nahenti vi vatara autu nteha Masave – Nuntu Nauntuve, Meribave – Avatorave tura. ");
INSERT INTO tbg_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Isareri vika Repintimini vaumanta Amareki vatanaaka orunte vika hampata raqi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Vika hampata raqi vauvaro Mosiva Iosuaarara tiharo, Hura are vaiinti vonavu ntita varera Amareki vatanaaka hampata raquane. Ne vika hampata raqi vaiqe te oru aiqina voqaa himpite vaiha, Kotiva tiriara tuataqira vuane ti kaurura vira tenta kauquqi tuateha vairerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Minti tuvaro Iosuaava Mosiva tunte iro Amareki vatanaaka hampata oru raqi vaumanta Mosiva vo, Eroniva vo, Huriva vo, vinavuka aiqinaqaa oru vaura. ");
INSERT INTO tbg_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mosiva viraqaa vaiharo nai kauqu rantutatero vaumanta Isareri vika navutaaka naatarake vauvaro, viraqaahairo Mosira kauquvano vataini tuvi vumanta Amareki vatanaaka Isareri naatarake vaura. ");
INSERT INTO tbg_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mosira kauquvano qutu ntava vumanta Eronika Hurika nora ori vo mpaqi vare vuru vatovaro Mosiva viraqaa oquvi vaumanta Eronika Hurika vira hini hini himpite vaiha, Mosira kauqutanta rantutake tuate vaumanta qaiqaa Isareri iqoka vaiinti nai navutaaka naatarake vaura. Vitanta Mosira kauqu tuataqi vi vauvaro kuarivano ruhunku vura. ");
INSERT INTO tbg_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mintima kero Iosuaava Amareki vatanaaka hampata raquqiro viharo vika naatara kora. ");
INSERT INTO tbg_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ho Noravano Kotiva Mosirara tiharo, Ne Amareki vatanaaka naatara kaa uvara tauru kevorave tira, are vi uvara vukuqi qara ntuva taane. Iosuaara vuru tiva amiane: Te naantiara Amareki vatanaaka ekaa vehi autu taiqa karerave, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kotiva minti tuvaro Mosiva mini vaiharo ofaa tainta vo autukero tiharo, Noravano Kotiva ti vutorama/qarareqama vaivo. ˻Vi uvara vutuke tirera: Noravano Kotiva ti kahaqi vaimanta te navutaaka naatarake vaunarave˼, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mosiva tiharo, Te tenta kauqu tuaherake Nora Kotira aare vaunarara tiro, viva ti kahaqi vairave. Viva ekaa enta variqiro viharo Amareki vatanaaka qaqiqai naataraqiro vuanarove, tura. ");
INSERT INTO tbg_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","... Jetarova Mosira airaaviva, viva Mosira naatavata, vira maaqutantavata, ntita varero Mosira tavareva aahara vataini vura. Vi entara Mosiva Kotira aiqina tataaqa nai seri naavu maaqa kaqatero vauvaro ");
INSERT INTO tbg_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetarova uva vara kero Mosirara tiharo, Tenavu ai tavarera ani vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Minti tuvaro Mosiva vi uvara iriro nai airaavira vita kareva oruntero vira avuqaa kankakaa viro vira uva mantama kero, viraqaahairo vira moqa kero, vita varero nai seri naavuqi vura. ");
INSERT INTO tbg_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ho Mosiva vo uva vo uva Noravano Kotiva Isareri vika ruaruama nimiteharo Pero vaiintive, Isipi vatanaakave, qoraiqama nimitora, ekaa vi uvara vi uvara Jetarora nai airaavira tiva amura. Isareri vika Isipihai aaraini aniha nora maaraqi vauvaro Noravano Kotiva vika kahaqu uvaravata vira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Tiva amuvaro Jetarova vi uvara iriro quaha kero ");
INSERT INTO tbg_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","tiharo, Pero vaiintivanovata Isipi vatanaakavata ni rumpa taavaro Noravano Kotiva ni kuvantu kero ni ruaruama nimitaimanta ne maini aniara virara irihama te Nora Kotira autu tuahera kauro. ");
INSERT INTO tbg_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Isipi vika Isareri qoraiqama nimite vaura kaara Noravano Kotiva vika nái qoraiqama nimitairave. Kotiva mintirara ti, te kankomake iruraro viva ekaa vo variqa vo variqa naatara kero vivaqai avuni vai Variqavama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetarova Mosira airaaviva minti tivakero ofaa vo varero Kotira ekaara kaintu iha quara amitero, vo ofaanavuvata Kotira iha quara amitomanta, viraqaahai Eronivavata, Isareri nora vaiintinavuvata, aninte Mosira airaavira hampata kara neha Kotira autu tuahere vaura. ");
INSERT INTO tbg_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ho vira qararaa Mosiva vo uva vo uva irireva oru ko taintaqaa oquvi vaumanta vaiinti nahenti nái uva vare viva vaunaini vuvaro Mosiva toqaqihairo uva iriqiro viviro entama kora. ");
INSERT INTO tbg_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mintuvaro vira airaaviva vi kaiqara tavero Mosirara tiharo, Are nantiharae nenaraa vaihara toqaqihaira uva iriqira vivira vuru entama kaaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Minti tuvaro Mosiva vira tiva amiro tiharo, Vaiinti nahenti Kotira antuqa vaina okarara irireka te vaunanaini ani variavo. ");
INSERT INTO tbg_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Vika avutana tirorira uvavano qovarama vimanta vika te unanaini aniamanta te vikara Kotira uvavano mintimama vairave, Kotiva mintima tiva tairave, tivakeha vika uva avuqavuqama nimite vaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Minti tuvaro vira airaaviva tiharo, Are nenaraa mintiaqira vuararo kiama koqe ivo. ");
INSERT INTO tbg_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Arevata, vaiinti nahenti are vainanaini ani vaikavata, vaakama popohama vivarave. Vi kaiqava nora kaiqa vaivarara tira, are nenaraa vi kaiqara varerorave. ");
INSERT INTO tbg_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Are iri vairaqe te koqe avu aato ai amiariraro Kotivavata ai kahaqiarire. Are homa vaiinti nahentiara irihara vika uva varera Kotira avuqaa vuru vatenarave. ");
INSERT INTO tbg_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Are vaiinti nahenti kahaqiharama Kotiva uva tivataira vika tiva nimiane. Are vikara tihara, Minti mintima keha Kotira aaraqaa vihama vi kaiqara vi kaiqara varaqi vuate, tiane. ");
INSERT INTO tbg_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Are vi kaiqara nenaraa varerorave. Are avu aato vataa vaiinti vonavu kaama taira vikavata ko kaiqaqaa raqikiate. Vikaqihai hininavu 1,000 vaiinti nahentiqaa raqiki vaimanta, hini vaiintinavu 100navuqaa raqiki vaimanta, hini vaiintinavu 50navuqaa raqiki vaimanta, hini vaiintinavu 10 navuqaa raqikiate. ");
INSERT INTO tbg_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Vinavuka homa iasi kaiqa vareha inaara uva vainara avuqavu ivarave. Nora uva vairera, vika ariarama vi uvara avuqavu iane tivarave. Mintimakeha vika ai kahaqi vaivaro ai kaiqavano vuaqa ntairara variane. ");
INSERT INTO tbg_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Are te tiva amuna uvara avatairaro Kotivavata ariara maantima kera kaiqa varaqira vuane ti uvara irirera, ai kempukavano kia taiqa viramanta vaiinti nahentivata nái uva vaaka avuqavuqama kerara iriha, quahakeha nái maaqa vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Jetarova minti tuvaro Mosiva nai airaaviva tuntema kero, vira uva avatora. ");
INSERT INTO tbg_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mosiva Isareri vikaqihairo avu aato vato vaiintika vonavu kaamatero vika noraiqama komanta vika 1,000navuve, 100navuve, 50navuve, 10navuve, vikaqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Vika iasiqamavi vaiha inaara uvavano qovarama vura avuqavuqama keha, nora uvavano qovarama vura virara Mosirara are vi uvara avuqavu qiane, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Jetarova Mosira airaaviva Mosikantiro varikero nai maaqaini vireva uvaro Mosiva virara ho nena vuane tuvaro Jetarova anirantero vura. ");
INSERT INTO tbg_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isareri vika Isipi mini ke, taaramo tora avuhainaa entaqaa Sainai Aahara Vataini oruntora. ");
INSERT INTO tbg_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Vika Repintimi mini ke Sainai Aahara Vataini oruntovaro Sainai Aiqinavano vika avuni vaumanta vika nái seri naavu maaqa mini kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Vika mini vauvaro Mosiva Kotira aarareva aiqinaqaa vaarintovaro Noravano Kotiva aiqinaqaahairo Mosira aaramakero tiharo, Isareri Iekopira vaintivara mintima tiva nimiane: ");
INSERT INTO tbg_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Haaru ne tavomanta te Isipi vika qoraiqama nimitaavaunarave. Qutauvuvano nai naati arokaqaa aaqu varaintemake, te ni Isareri Isipihai ntita vare tenta vaunanaini anunarave. ");
INSERT INTO tbg_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Te ni hampata vaiha uva tiva taatau taainara ne vi uvara kia raqa karaiti, ekaa iriqi vivera, te ekaa vo vatanaa vo vatanaakaqihai niaraqaima tinta vaiinti nahenti variavo tirerave. Ekaa maa vatava ti vataqai vaimantavata, ");
INSERT INTO tbg_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","te niaraqai tenta kaama tauna vaiinti nahentikave tiari neqai ti kaiqa vara timitevarave. Ne koqe kaiqa varaqi viha ti vaiinti nahentima vaivarave. Minti tivakerama ti uva Isareri vika tiva nimiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kotiva minti tuvaro Mosiva ururantero muntu Isareri nora vaiintinavu naarama kero Noravano Kotiva minti tivakera tiane tu uvara tiva nimumanta ");
INSERT INTO tbg_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ekaa vaiinti nahenti vi uvara iri, vohaa uva vate tiha, Noravano Kotiva ti uvara tenavu ekaa vi uvara avatarerave, tuvaro Mosiva tuvurantero vika tu uvara Nora Kotira vuru tiva amireva vura. ");
INSERT INTO tbg_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Vuvaro Noravano Kotiva Mosirara tiharo, Vaiinti nahenti te ainti tiaina uvara iriha tiha, Quqaama Noravano Kotiva Mosikantiro uva ti vaivo, tivake ariara, Quqaama viva Kotira uva ti vaivave tiate ti, te tonavuvano voqama kero taatau vinaraqi are vainanaini otu virerave, tiro. Minti tuvaro Mosiva vaiinti nahenti tu uvara Nora Kotira tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Noravano Kotiva Mosirara tiharo, Are vaiinti nahenti varianaini otuntera vikara mintima tiva nimiane: Ne Kotira autu tuaherareka iha, vatevata huravata koqemake vaiha nenta avu aato muntuka hiqama keha variate. Ne nenta utavaaqavata hiqamake qeramate Kotira veka vaivaro viva hura vira qararaa tuvuarire. ");
INSERT INTO tbg_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Vi entaraqaa Noravano Kotiva Sainai Aiqinaqaahairo tuvu vaiinti nahenti nivuqaa varianarove. ");
INSERT INTO tbg_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Vaiinti nahenti aiqinaqaa oru vivorave tira, are aiqina vira auvahianta vuka vatairamanta kia vuate. Are vaiinti nahenti qioqama tehara mintima tiane: Ne kia aiqinaqaa oru vuate. Kiama vi aiqinara auvahianta utu varaate, tiane. Vaiinti vovano kia ai uva iriraitiro aiqina utu varairera, vira aruma kaate tiane. ");
INSERT INTO tbg_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Vi vaiintira kia nenta kauquqohai utu vararaiti, vevaqohaie oriqohaie vira arukaate. Vaiintivanoe aantauvahivanoe aiqina vira utu varairera, viva kiama ho qaqi varianarove. Viravata aruma kaate, tiane. Ne mintimake uqitakanta vaiha, aanumaara/noma vuaqaaina uvara iri, viraqaahai ne homa aiqinaini vivarave, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kotiva minti tuvaro Mosiva ururantero otu vaiinti nahentiara tiharo, Ne Kotira autu tuahera kerara irihama qeramateha variate, tumanta vaiinti nahenti nai utavaaqa hiqama kovaro ");
INSERT INTO tbg_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mosiva vikara tiharo, Ne kia nenta naata hampata niraiti, hura vira qararaa vira veka variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mosiva minti tuvaro taaramo entaqaa toqaqi naaruvavano uva ti vauvaro aaquakaavano uti vauvaro voqama kero taatauvu tonavuva aiqinaqaa hihipaama viro vaumanta vaiinti nahenti iruvaro aanumaara/noma vuaqa kovaro noraiqamakero uva tumanta ekaa vaiinti nahenti nái seri naavuqi vauka naatu itomanta aiqu kauqu ntiri ntiri iha vaura. ");
INSERT INTO tbg_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Vika qete vauvaro Mosiva vika Kotira avuqaa oru variate tiro, vika ntita varero vumanta vika oru aiqina auvoqi himpite vaura. ");
INSERT INTO tbg_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Vika orunte tavovaro Noravano Kotiva iha ite vauraqi tuvuntero Sainai Aiqinaqaa vauvarora tiro, iha muravano ekaa aiqinaqaa hihipaama viro vaura. Nora ihavano ite vaivaro muravano veraini vi vaintema kero, iha muravano kumpetaqiro vi vauvaro, vaturavanovata vi aiqinara qaki qaki i vaura. ");
INSERT INTO tbg_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Minti vauvaro aanumaara/noma vuaqa kovaro voqavata uva tivaqiro viharo noraiqaakero uva ti vauvaro, viraqaahairo Mosiva Kotira aareharo uva tuvaro Kotiva Mosira nai tiva amiharo naaruvavano uva tuntema kero uva tura. ");
INSERT INTO tbg_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Noravano Kotiva tuvu Sainai Aiqina noraqaa vaiharo Mosira aarama kovaro Mosiva Kotiva unaini viro aiqina noraqaa oru vauvaro ");
INSERT INTO tbg_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Noravano Kotiva virara tiharo, Vaiinti nahenti airitahaa qutu vivorave tira, are ururantera vikara kia vuka arataanara vira aatarake maini ti tavareka uruate, tiane. ");
INSERT INTO tbg_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Vaiinti nahentiara iriha ti kaiqa vara timite varia vaiintika, vikavata kia nái avu aato muntuka hiqama karaiti, kia te unanaini ho urivarave. Vika qaqi urivera, te vikavata ntaiharerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Noravano Kotiva minti tuvaro Mosiva virara tiharo, Are nena qioqama tehara, Aiqina vira auvahianta vuka arataate, tianarara ti, kiama vaiinti nahenti vi aiqinaraqaa urivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mosiva minti tuvaro Noravano Kotiva tiharo, Are ururantera otu Eronira vita varera qaiqaa uruane. Ti kaiqa vara timite varia vaiintikavata, qaqi vaiinti nahentivata, vika vuka aatarake maini urivorave. Vika mintiqe te vika ntaiharerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Minti tuvaro Mosiva ururantero vi uvara muntu vaiinti nahenti tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kotiva maa uvara mintima tiro: ");
INSERT INTO tbg_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Te Noravano Kotika ni Variqavanoma vauro. Isipi vika ni rumpa tomanta ne qoraiqamavi vauraqihai tema ni kuvantuke ntita vare maini viri kaunarave. ");
INSERT INTO tbg_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ne kia vo variqa autu tuaheraraiti, ti hutuqai tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Naaruvaini vai haikarave, vataini vai haikarave, namariqi vai haikarave, ne kia vi haikarara irihama vika maraqura/varaha autu keha tinavu variqave tivakeha vika nutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Una variqa aututaa haikava vaimanta ne kia vi haikara avuqaa hiqintivi vaiha vika nutu tuahera kaate. Tema Noravano Kotika ni Variqavano vaihara ti, kia te ni qaqi kaari ne una variqa autu tuahera kevarave. Vaiinti nahenti ti qoririmake una variqa autu tuahera kaivera, vira kaara te vi vaiinti nahentika ntaihamake, viraqaahai naantiara te vika vaintivata, vika naintivata, vika naintivara vaintivata, qoraiqama nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Vaiinti nahenti tiriara hantuqa vairamanta ti uva iriqi vivera, ti muntukavano vikara vairaqe te vikavata, vika vaintivaravata, ekaa vika kuvuarama tekavata, koqema nimitaqi virerave. ");
INSERT INTO tbg_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ne kia qumina kauqu aiqiqaa aqukeha ti hutu ntaraiti, kia qumina ntaate. Vovano mintirera, vira kaara te Nora Kotika ni Variqavano viraqaa uva vatarerave. ");
INSERT INTO tbg_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ekaa uiki 7 entaqaa Kotira entave tiate. ");
INSERT INTO tbg_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ne 6 entanavu nenta kaiqa varaqi vivi, ");
INSERT INTO tbg_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","viraqaahai 7 entaqaa ne tiriara irihama auraara variate. Vi entaraqaa kiama kaiqa varaate. Nevata ni maaquve, ni raavurave, ni kaiqa vaiintive, ni kaiqa nahentive, ni quara vairive, vo vatanaaka ni hampata variakave, ekaa ne vika vikavata vi entaraqaa kia kaiqa varaate. ");
INSERT INTO tbg_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Te Noravano Kotika 6 entanavu kaiqa varaqi viha naaruvave vatave nora namarive ekaa haikave autuke, vira qararaa 7 entaqaa te auraara variavaunarara ti, te Noravano Kotika vi entara koqema amiteha tinta entama varianarove tunarave. ");
INSERT INTO tbg_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Nenta noka qoka koqe okaraqai autu nimitaate. Ne mintihama vukai enta te Noravano Kotika ni Variqavano nimiaina vataraqaa qaqi variqi vivarave. ");
INSERT INTO tbg_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ne kia vaiintie nahentie aru kaate. ");
INSERT INTO tbg_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ne kia vora naatae vora vaatie vira vataake nuate. ");
INSERT INTO tbg_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ne kia muara autuate. ");
INSERT INTO tbg_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ne kia una uva vo vaiintiqaae vo nahentiqaae vataate. ");
INSERT INTO tbg_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ne kia vora naavue, vora naatae, vora kaiqa vaiintie, vora kaiqa nahentie, vora kaiqa purumakaue, donkie, vora airairae, virara muntuka ntiramanta variate, tiro. Kotiva vi uvara tivatora. ");
INSERT INTO tbg_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Isareri vika mini vauvaro naaruvavano karara karara ti vauvaro, aaquakaavano uti vauvaro, aanumaara/noma vuaqe vauvaro, nora uva tivaqiro vuvaro, iha muravano aiqinaqaahairo veraini oru vi vaumanta vaiinti nahenti vi haikara vi haikara iri tave, vika voqamake qeteha aiqu kauqu ntiri ntiri i vaumanta vaura. Vika vi haikara vi haikara aatu qeteha niara kanta vaiha ");
INSERT INTO tbg_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mosirara tiha, Oho, are nena vi uvara tinavu tiva timiraqe iriare. Kotiva naivano tinavu uva tiva timirera, tenavu qutu vuarorave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Vika minti tuvaro Mosiva vaiinti nahentiara tiharo, Kia qetaate. Kotiva ni avatamake tavareva tuvivo. Ne Kotira aatu qetaivera, ne kiama qora kaiqa varaqi vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mosiva minti tumanta vaiinti nahenti qaqiqai niara kanta vauvaro Mosiva Kotiva vaunaini vankora ari vau tonavuva vauraqi vura... ");
INSERT INTO tbg_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Noravano Kotiva Mosirara tiharo, Are te vauna aiqinaraqaa uruane. Are Eronira vo, Nadaapira vo, Abihura vo, nora vaiinti 70navuvata, ntita varera uruane. Are vika hampata uru niara kanta vataini hiqintivi vaiha ti hutu tuahera kaate. ");
INSERT INTO tbg_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Viraqaahaira are vika mini kera nenaqai ti Nora Kotika aaqanto uruane. Vo kiaka ai hampata ti aaqanto urivorave. Qaqi vaiinti nahentivata kiama aiqinaqaa urivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Minti tuvaro Mosiva muntu Noravano Kotiva tu uvarave, viva uva tivatorave, vaiinti nahenti tiva nimumanta vika vohaa no vate tiha, Noravano Kotiva tivatai uvara, tenavu ekaa vi uvara avataqi virerave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","viraqaahairo Mosiva Noravano Kotiva tu uvara ekaa vi uvara qara ntuvatora. Mintumakero vira qararaa vaaka toqaqi viva himpiro ofaa tainta vo aiqina auvoqi autukero, Isareri vika anku 12navuara iriharo nora ori 12navu vara kero vataqi vaavi aratora. ");
INSERT INTO tbg_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Viraqaahairo Mosiva qaraaka vaiinti 12 navu nititomanta vinavuka ofaa taintaqaa ofaa vo Kotira ekaara kaintu iha quara amite, viraqaahai vinavuka qaraaka purumakau qoranavu aruke Kotiva Isareri vika hampata vohaa vaurara iriha purumakau vonavu Nora Kotira iha quara amitora. ");
INSERT INTO tbg_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Vinavuka purumakau qoranavu arukoraqihairo Mosiva hini naare taqu vonavuqi kaqa vatero, hini naare ofaa taintaqaa rintatima kora. ");
INSERT INTO tbg_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Viraqaahairo viva Kotiva tivato uvara qara ntuvato vukuraqihairo kaara ntuva komanta vaiinti nahenti vi uvara iri tiha, Noravano Kotiva tivatai uvara tenavu ekaa vi uvara avataqi virerave, ti. ");
INSERT INTO tbg_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Minti tuvaro Mosiva taquqi naare kaqa tora varakero vaiinti nahentiqaa rintatiharo tiharo, Ne Noravano Kotiva tivatai uvara iri, virara tiha, Tenavu ekaa vi uvara avataqi virerave, tiarave. Ho Noravano Kotiva tiva tai uvavavata, ne tivataa uvavavata, kempukaiqama vuarire ti, te maa naareraqohai vi uvara kempukaiqama kauro, tiro... ");
INSERT INTO tbg_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Noravano Kotiva Mosirara tiharo, Are te iainanaini aiqina maaqaa uru vairaqe te tanuqi orira taaraqantaqaa tenta uva qara ntuvataunara ai amiare. Vaiinti nahenti ti uva, vo uva vo uva iriqi vuate ti, te vi uvara ai amirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kotiva minti tuvaro Mosiva nai kaiqa kahaqi vau vaiintira Iosuaaravata vitakero Kotira aiqinaqaa vura. ");
INSERT INTO tbg_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Viva vireva iharo Isareri nora vaiintinavuara tiharo, Ne maini vaiha titanta veka vaiqe tetanta orurante tuvuare. Eronika Hurika ninavu hampata maini variavo. Vo vaiintivano voraqaa uva vatareva irera, viva homa vitanta inaini oru viramanta vitanta vi uvara avuqavu iate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Minti tivakero Mosiva aiqinaqaa oru vuvaro tonavuvano aiqina viraqaa hihipaama viro vauvaro ");
INSERT INTO tbg_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","18","Sainai Aiqina viraqaa Nora Kotira mpeqa okaravano takuqi vauvaro vaura. Isareri vika uqitaini vaiha Kotira mpeqa okara takuqi vaura taveha tiha, Ike, vi haikava nora iha iteharo ataa i vaira voqaarama vaivo, ti vaura. Ho 6 entanavu tonavuvano aiqina viraqaa hihipaama viro vauvaro 7 entaqaa Noravano Kotiva tonavuqi vaiharo Mosira aarovaro Mosiva aiqina viraqaa oruntero 40 entara aatitoraqaavata entaqivata mini variqiro vura. ");
INSERT INTO tbg_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mosiva Kotiva vaunaini oruntovaro Noravano Kotiva virara tiharo, ");
INSERT INTO tbg_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Are Isareri vatanaa vaiinti nahentiara mintima tiane: Ne Kotirara irihama nenta airaira hini vira amiate, tiane. Nai taukae ti Kotika timiataa ivera, vika vohaiqa vohaiqavano nái i haikara ai amivara are vara vataane... ");
INSERT INTO tbg_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Vika ekaa vi haikara ai amivara are tiramanta vika Seri Naavu vo kaqa timitaiqe te vika hampata variare. ");
INSERT INTO tbg_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Te ai umiqaainantema kema, ne Seri Naavu vira kaqatema, naavu viraqi vate haikaravata autu kaate. ");
INSERT INTO tbg_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Seri Naavu vira kaqa timite, viraqaahai ne koqe katari akaasi varake vokise vo autu timitaate. Vi vokisera vukai vaireva 110 sentimita vairaro vira hini hini 66 sentimita vairaro vira virini miani 66 sentimita variarire. ");
INSERT INTO tbg_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Vi vokisera autuke viraqaahai kori ori kakanairi/kavanairima teraqohai vokise vira avutaqivata aaqainivata naavuma taate... ");
INSERT INTO tbg_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Viraqaahai vokise aqu varera kori oriqohai ringi 4navu autuke, vokise aiqu vainanaini hini hini arutaate. ");
INSERT INTO tbg_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Akaasi katari vukaitanta humuquke, vitantavata kori oriqohai naavumate ringi hini hini vainaraqi nonkutaate. ");
INSERT INTO tbg_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Hini hini mantaraini katari vitanta ringiqi ruqiake vataimanta naantiara aaraini vireka iha vokise vira aqu vare vuate. ");
INSERT INTO tbg_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Katari vukai vitanta ringiqi veta ruqiake vatera kia qaqini varake vataraiti, ringi viraqi qaqi kaivaro variarire. ");
INSERT INTO tbg_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Naantiara tenta uva oritantaqaa qara ntuva taainara ni nimiari ne ori vitanta vokiseqi vataate. ");
INSERT INTO tbg_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kori oriqohai vokise vira avu maantimake autuate: vira vukai 110 sentimita vairaro vira hini hini 66 sentimita variarire. Vi avuva vaireva, te vaiinti nahenti aaqurihama nimitaaina avuvama varianarove. ");
INSERT INTO tbg_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Vokise vira avuqaa hini hini vitini kori oriqohai enseli aroka vaira maraqura/varaha taaraqanta autuke vataate. ");
INSERT INTO tbg_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Enseli vovano vokise vira hini vitini vairaro vovano hini vitini variarire. Kia vokise avu nariara autuke maraqura haika nariara autuke vataraiti, ekaa vi haikara autireka iha kori ori kaintu varake viraqohai autu kaate. ");
INSERT INTO tbg_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Enseli vitanta náitanta avuqaa náitanta aroka rairake/airake vokise vira avu mantaaqate, Kotiva aaqurihama nimitaainara avu vira viavi tave vaira autu taate. ");
INSERT INTO tbg_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mintimake autu kaivara are avu vira vokise noqaa aqutera, viraqaahaira naantiara tenta uva qara ntuva taainara ai amiarirara are vokise viraqi vataane. ");
INSERT INTO tbg_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Naantiara enseli maraquratanta hini vitini hini vitini vaivaqe te tuvu vokise avuqaa vaiha tenta uva ai tiva amiarirara, are Isareri vika tiva niminarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kotiva minti tivakero qaiqaa tiharo, Ne akaasi katari varake tainta vo autu kaate. Vira vukai 88 sentimita vairaro vira hini hini 44 sentimita vairaro vira virini miani 66 sentimita variarire. ");
INSERT INTO tbg_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tainta vira autuke kori ori kakanairima teraqohai tainta vira naavuma taate... ");
INSERT INTO tbg_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tainta vira ho aqu vare viva variarire ti, ne ringi 4navu kaataraini aiquqaa arutaate. ");
INSERT INTO tbg_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","28","Viraqaahai tainta vira aqu vare viva variarire ti, akaasi katari vukaitanta varake ringiqi ruqiake vataate. Katari vitanta kori ori kakanairima teraqohai naavuma taate. ");
INSERT INTO tbg_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tainta viraqaa variaina tanura, vo tanu vo tanu kori oriqohai autuke vate, uaini tanu vonavu ofaa rauru keravata kori oriqohai autukaate. ");
INSERT INTO tbg_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ti unta timite mparetira, vare vuru tainta viraqaa vataivaro ti tivuqaa vo enta vo enta qaqi variarire. ");
INSERT INTO tbg_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Tainta vira autuke viraqaahai ova nonku taivaro itaaina kairiqara kori oriqohai autu kaate... ");
INSERT INTO tbg_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Vi kairiqava vaireva, 7navuma vohaaraqaa varianarove. Avutaqaa kairiqa vohaiqavano vairaro hini mantaraini kairiqa taaramonavu vairaro hini mantaraini kairiqa taaramonavu variarire... ");
INSERT INTO tbg_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kairiqa vira autuke raamu 7navuvata autuke kairiqa viraqaata vataivaro ti Seri Naavu avutaqi vaiharo koqema kero ova iteharo ataa iarire, tiro... ");
INSERT INTO tbg_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","...Noravano Kotiva Sainai Aiqina qaa vaiharo Mosira ekaa uva tiva amiqiro viviro vuru taiqa kero, viraqaahairo viva nai uva tiva tora nai vuqaqohairo ori taaraqantaqaa qara ntuvatora Mosira amuvaro varero tuvura. ");
INSERT INTO tbg_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mosiva Sainai Aiqinaqaa vaumantavaiinti nahenti tavovaro airi enta aitarovaro Mosiva kia tuviraitiro, vukaiqama kero miniqai vaumanta vika Eroniva unaini ruvaaqumavi vaiha virara tiha, Mosiva tinavu Isipihairo tivita varero maini viri kai vaiintiva, viva tainie vivo? Kiama tenavu iruro. Are variqa maraqura/varaha vo tinavu autu timitairaro viva tinavu variqavano vaiharo maihairo tinavu tivita varero vuarire, ti. ");
INSERT INTO tbg_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Vika minti tuvaro Eroniva tiharo, Ne oru nenta naatave, maaqu raavurave, vika kori oriqohai nái aatoqi taaqimataarave, auntaqi ruvutaarave, vare viri timiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Minti tumanta ekaa vaiinti nahenti vi haikara rahunkuke Eronira vuru amuvaro ");
INSERT INTO tbg_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Eroniva vi haikara varakero vata quvi kero purumakau maraqura vo autukero vatoraqi viva kori vi haikara varatora ihaqohairo ravita kero qihia kovaro viraqi vi anima viro kempukaiqama vura. Kempukaiqama vuvaro vi haikara vataqihairo mpaqi vaari kero vira humuqu kero vatomanta vaiinti nahenti tiha, Ho iriate. Maa haikava tinavu variqavanoma vaivo. Vivama tinavu Isipihairo tivita varero maini viri kairave, tura. ");
INSERT INTO tbg_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Vika minti tuvaro Eroniva purumakau maraqura/varaha aututora vira avuni vaiharo ofaa tainta vo autu kero tiharo, Kaiqe tenavu hura ruvaaqumavi vaiha nora kara neha Nora Kotira autu tuahera kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Minti tumanta vira qararaa vaiinti nahenti vaaka toqaqi himpi ekaara kaintu iha quarake ofaaravata, Kotira hampata vohaa tampamavi vai ofaaravata iha quaratora. Vika mintiake karavata kempuka uainivata namake, viraqaahai oru qora okara autiha hampi ruhe tutiqe vaura. ");
INSERT INTO tbg_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mintuvaro Noravano Kotiva Sainai Aiqinaqaa vaiharo Mosirara tiharo, Ai vaiinti nahenti are Isipihaira vika ntita varera aniarauka, vika qora kaiqa vareha ti qoririma timite variarara tira, are vaaka ururantera vika vainaini otu vuane. ");
INSERT INTO tbg_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Te vikara tinta uva iriqi vuate turamantavata, vaakama vika ti uva qaqirakeha purumakau maraqura/varaha autuke, vi haikarara tinavu variqave tivakeha vira autu tuaherake variavo. Vika vi haikara avuqaa kankakaamavi vaiha vira quahama amiteha vi haikara ofaa iha quara amite tiha, Maa haikava tinavu variqavano Isipihairo tinavu tivita varero maini viri kairave, ti variavo. ");
INSERT INTO tbg_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Te tavauramanta maa vatanaaka ti uva qaqirakeha nái uvaqai avataqi vireka auti variarave. ");
INSERT INTO tbg_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Oho, ti voqamakero vikara tirara itaivo. Are ti maini kera viraqe te vi vatanaaka vehi autu taiqa kaare. Te vika mintimake, qaiqaa are kuvuarama teraukaqaahai nora vatanaaka qovarama karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Noravano Kotiva minti tuvaro Mosiva aqao tiro, Mpo, Noravauvo, are mpeqaiqama kera nena vaiinti nahenti Isipihaira ruaruama kera ntita varera maini viri kaarauka variavara hauri are vikara arara itairara vehi autu kerorave. ");
INSERT INTO tbg_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Are mintiramanta Isipi vika ariara mintima tivarave: Kotiva nai vaiinti nahenti vehi autu kareva Isipihairo vika ntita varero vetaini vuru kero vehi autu kaivo, tivarave. Virara iriharama kia vikara arara itairara qaqira kera kia nena vaiinti nahenti ntaihaane. ");
INSERT INTO tbg_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Are nena kaiqa vaiintinavu Eparahaamirave, Aisaakirave, Iekopirave, vikara tiva taana uvara iritaane. Are nena kauqu aiqiqaa aqu kehara vinavukara tihara, Te nenavu kuvuarama teka noraiqama kaari vika vaireka, opu makau voqaara airitahaa vaivarave, tianarave. Are vikara tihara, Te ekaa maa vatara vika nimiariraro maa vatava vika vatama ekaa enta varianarove, tianarave. Are vi uvara irihara kia nena vaiinti nahenti vika vehi autu kaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mosiva minti tuvaro Noravano Kotiva te vika ntaiharerave tu avu aatora qaqira kero, kia vika ntaihora. ");
INSERT INTO tbg_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Mintuvaro Mosiva ururantero Kotiva nai uva tivatora oritantaqaa qara ntuvatora varero vura. Kotiva ori vitantaqaa taara mantaraini qara ntuva tovaro Mosiva vitanta varero ururantero vura. ");
INSERT INTO tbg_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iosuaava Mosikantiro ururantero otu viharo irumanta vaiinti nahenti nora uva ti vauvaro viva Mosirara tiharo, Vaiinti nahenti seri naavu maaqa kaqataaraqihai raqi vaihama ti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Iosuaava minti tuvaro Mosiva aqao tiro, Vi uvava vaireva, kia vora nti varia uvaravauve vaivo. Kia navutaaka naatara kaa uvaravauve vaivo. Vika ihi tihama oi aai ti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mosiva minti tivakero seri naavu maaqa kaqatora aumanto otuntero tavovaro purumakau maraqura/varaha vaumanta vika ihi nte vauvaro vira kaara vira arara itora. Viva aiqina auvoqi otuntero oritanta vare tuvura vata kanta aqu kovaro tairi taarima vura. ");
INSERT INTO tbg_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Viraqaahairo Mosiva oru vika purumakau autu tora vara kero ihaqi aqu kovaro ravita vuvaro vi haikara varakero rukoki raakokima kero namari vataakero tuqantaakero, Isareri vika vahaurukero naate tumanta vika vi namarira nora. ");
INSERT INTO tbg_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Vika vi namarira novaro Mosiva Eronirara tiharo, Vaiinti nahenti ariara nanti tiavarae are vika ntita varera vuaramanta vika noraiqaake Kotira uva raqake qora kaiqa varaavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Minti tuvaro Eroniva tiharo, Nora vaiintio, kia ti titiane. Are maa vaiinti nahentika okara tavaanarave. Vika qora kaiqa varareka vaaka auti variakave. ");
INSERT INTO tbg_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Vika aninte tiriara mintima tiavo: Mosiva tinavu Isipihairo tivita varero maini viri kai vaiintiva, viva tainie vivo? Kiama tenavu iruro. Are variqa maraqura/varaha vo tinavu autu timitairaro viva tinavu variqavano vaiharo maihairo tinavu tivita varero vuarire, tiamanta ");
INSERT INTO tbg_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","te viraqaahai vikara mintima turo: Vaiinti nahenti kori oriqohai vahehemate/vaataiqamate haikara rahunkuke viri ti timiate, turamanta vi haikara viri ti timiamanta vare, te vi haikara ihaqira aqu kauraro ihaqihairo purumakau maraqurahaavano qovarama vivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Eroniva minti tuvaro Mosiva tavovaro viva kia vaiinti nahenti qioqama karaitiro, vika qaqi komanta vika nái varaataa u kaiqara qora kaiqaqai vare vaura kaara vika navutaaka vika tave naaraihama nimitevaqai vaura. ");
INSERT INTO tbg_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mosiva vatuka qentiana oru himpi vaiharo tiharo, Taukae Nora Kotira mantaraini vaika vika te iainanaini aniate, tumanta ekaa Rivaira anku vika vira aiquantakaa vura. ");
INSERT INTO tbg_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Vika vuvaro Mosiva vikara tiharo, Noravano Kotiva Isareri Variqavano mintima tivo: Ne vohaiqa vohaiqavano iqoka paipe tuata vare, vatukaqi vi anihama ˻purumakau maraqura/varaha autu tuahere variaka˼ aru taiqa kaate. Ni qata vakaukavarave, ni tontive vaivera, vikavata ekaa aru taiqa kaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mosiva minti tumanta Rivaira ankuqihainaa vaiintinavu Mosiva tuntemake, vatukaqi vi aniha 3,000 vaiinti aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mintuvaro Mosiva vikara tiharo, Ne vate Noravano Kotiva ti uvara iriha nenta maaquve, qata vakaukavarave, kia vehakuma nimitaraiti, vikavata aruqi vivi ekaa taiqa kaarara tiro, Kotiva ni koqema nimiteharo niara vika maa entaraqaahai ti kaiqa vaiinti vaiha tinta kaiqa ho vara timitevarave, tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mosiva minti tivakero vira qararaa vaiinti nahenti ruvaaquma kero vikara tiharo, Ne qora kaiqa varaava uritara kero vaivo. Vate te qaiqaa Noravano Kotiva vainanaini aiqinaqaa oru virerave. Te mini oru vaiha ne qora kaiqa vare uvara vira iraariraro viva ne qora kaiqa vare uvara nunkae nimitaanarove, kiae nunka nimitaanarove? tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mosiva minti tivakero qaiqaa tuvurantero Noravano Kotiva vaunaini aiqinaqaa oruntero tiharo, Oho, vi vaiinti nahentika nai noraiqama kema qora kaiqa vara kaavo. Vika kori oriqohai una variqa autuke, virara tinavu variqave tivakeha vira autu tuahera kaarave. ");
INSERT INTO tbg_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ho te vate ariara vika qora kaiqa varaa uvara nunka nimitaane turo. Are kia mintirera, are nena vukuqi nena vaiinti nahenti nutu qara ntuva taanaraqihaira ti hutuvata nunka kaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mosiva minti tuvaro Noravano Kotiva nai vira tiva amiro tiharo, Vaiinti nahenti ti uva raqa kaaka vika nutuqai tenta vukuqihai nunka karerave. ");
INSERT INTO tbg_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ho are ururantera vuane. Te ai tiva amuna vatara minima vaiinti nahenti ntita varera vuane. Are vika ntita varera aaraini viraro ti enseli vovano ai avuni vuanarove. Vaiinti nahenti qora kaiqa varaara kaara te vika ntaihaaina entava anintairaqe vi entaraqaa te vika ntaiharerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Minti tivakero vo enta Noravano Kotiva nora rovara vara kero viraqohairo Eroniva aututo purumakau maraqurara autu tuaherakora kaara vika ntaihama kora... ");
INSERT INTO tbg_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Noravano Kotiva Mosirara tiharo, Te tota oritanta ai amurara are muntu tairi kaanara vira voqaatanta qaiqaa teqa kera vara viri timiraqe te tota tuna uvara qaiqaa viraqaa qara ntuva taare. ");
INSERT INTO tbg_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Hura toqaqi qerama varera te variainara Sainai Aiqina noraqaa uruntera ti tivita kaane. ");
INSERT INTO tbg_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kiama vo vaiintivanovata ai vatakero uruarire. Kiama vo vaiintivanovata aiqina aumanto ani variarire. Sipisipive, purumakauve, vikavata kiama aiqinaqaa ani vaiha ukau naate, tiro. ");
INSERT INTO tbg_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Viva minti tuvaro Mosiva Noravano Kotiva tuntema kero, ori taaraqanta nkauru kero vatero vira qararaa vaaka toqaqi himpiro ori vitanta varero Kotiva tuntema kero, Sainai Aiqinaqaa vurama. ");
INSERT INTO tbg_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mosiva noraqaa vaarintovaro Noravano Kotiva tonavuqi tuvuntero Mosira vitakero nai nora autu nteharo, Te Noravano Kotikave tura. ");
INSERT INTO tbg_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Minti tivakero Noravano Kotiva Mosira avuqaa aitareharo tiharo, Te Noravano Kotika vairera, te aaqurihama nimite vaura Variqaukama vauro. Te kia vaaka arara ite vauraukama vauro. Ti muntukavano vaiinti nahentiara voqamakero vaimanta te kia vika vaaka qoririmake vaunarave. ");
INSERT INTO tbg_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ti muntukavano airi tauseni vaiinti nahentiara vaimanta te vika qora kaiqa vare varia uvarave, vika ti qoririmake varia uvarave, vi uvara vi uvara nunka nimite vaunarave. Te mintimake vaihavata, vika noka qoka qora kaiqa varera kaara te vika vaintivata vika naintivata vika naintivara vaintivaravata ntaihama karerave, tura... ");
INSERT INTO tbg_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosiva Nora Kotikantiro 40 enta entaqivata aatitoraqaavata variqiro viharo kia namarivata karavata nora. Viva Kotiva uva maara tivatora oritantaqaa qara ntuva tora. Kotiva kempuka uva 10navu tivatora viva qara ntuva tora. ");
INSERT INTO tbg_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ho Mosiva Sainai Aiqinaqaahairo ururantero oritantavata varero tuviharo kia tavovaro vira virivano ataa i vaiharo takuqi vaura. Viva Nora Kotikantiro uva tuvarora tiro, vira virivano mintiro vauvaro viva tuvuntomanta ");
INSERT INTO tbg_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Eronivavata ekaa Isareri vikavata Mosira tavovaro vira virivano takuqi vaumanta vika qetake kia vira aumanto oru vura. ");
INSERT INTO tbg_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mintuvarovata, Mosiva vika naarama komanta Eronivavata vaiinti nahenti vika nora vaiintinavuvata orurante Mosiva vaunaini aumanto vuvaro Mosiva vika hampata uva tura. ");
INSERT INTO tbg_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Vira naantiara Isareri vatanaa vaiinti nahenti ekaa Mosiva vaunaini aumanto vuvaro Mosiva Noravano Kotiva Sainai Aiqinaqaa vaiharo uva maara tivatora vika tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosiva uva tiva nimiqiro viro vuru taiqa kero viraqaahairo tavuna vara kero nai viri mantaaqa tero vaura. ");
INSERT INTO tbg_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mosiva Kotira Seri Naavuqi Kotira aarareva vireva iharo tavuna vira qaqini vara kero oru Kotira aarora. Viva Kotira aarama taiqa kero vevantero Kotira uva Isareri vaiinti nahenti tiva nimi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Viva uva tiva nimireva umanta vaiinti nahenti tavovaro vira virivano ataa iharo takuqi vauvaro Mosiva qaiqaa tavunaqohairo nai viri naavuma tero variqiro viro, qaiqaa Nora Kotira aarareva iharo tavuna vira nai viri naavuma tora qaqini varake vaura. Mosiva mintiaqiro vi vaura... ");
INSERT INTO tbg_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Ho Noravano Kotiva Besaleliravata, Ohorapiravata, vo vaiintinavuvata, koqe avu aato nimumanta vika Kotira nai Seri Naavu ho kaqeka vaurara tiro, Mosiva vika vi kaiqara nimura. Mosiva vi vaiintinavukara Noravano Kotiva tinantemake, ekaa vi kaiqara varaate, tura. ");
INSERT INTO tbg_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mosiva minti tivakero vi vaiintinavuka naarama kero vi kaiqara nimiro Kotira Seri Naavu hoqarama taate tivakero ... ");
INSERT INTO tbg_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isareri vaiinti nahenti vi naavura kaqerara iriha Mosira vo airaira vo airaira amuvaro viva vi haikara vi vaiintinavuka nimumanta vinavuka viraqohai Kotira Seri Naavu kaqareka hoqarama tora... ");
INSERT INTO tbg_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","...Mosiva Noravano Kotiva tunte makero, Kotira Seri Naavu kaqa vuru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Vohaa ihi aitarovaro avuhainaa enta 1 toraqaa, vi entara Isipihai katu vare anu entaraqaa, Kotira Seri Naavu kaqa vuru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosiva tumanta vika avuni katari naavu kaara aratera vataini vuqite, viraqaata naavu kaara vaavi arate, viraqaa katari taurini vate, viraqaata kiari hirite, ");
INSERT INTO tbg_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","vira naantiara seri tavuna varake vi vaura aqutora. Noravano Kotiva tuntema kero, Mosiva tumanta vika vi kaiqara autukora. ");
INSERT INTO tbg_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Seri Naavu kaqa taiqa kovaro Mosiva Kotiva nai uva qara ntuvato oritanta varero vuru Kotiva uva tivakero taatauto Vokiseraqi vaati vatero, viraqaahairo ringiqi vukai katari hini hini ruqiatero, Vokise vira avuvata taatautero, ");
INSERT INTO tbg_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","23","viraqaahairo viva Kotiva uva tivakero taatauto Vokisera Seri Naavuqi vuru vatora. Noravano Kotiva tuntema kero, Mosiva Vokise viva nariara variarire tiro, tavuna nora varakero hiritovaro kavaqaara autiro vaura. Kavaqaara vira hini mantaraini Mosiva tainta vo vatero, viraqaata Nora Kotira amito mparetira vuru vatora. ");
INSERT INTO tbg_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Mosiva ova vate kairiqara varero vuru tainta vira hini mantaraini vuru vatora. ");
INSERT INTO tbg_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Mosiva viraqi Nora Kotira avuqaa vaiharo ova 7navu qumpi tovaro iteharo vaura. Noravano Kotiva tuntema kero, Mosiva mintura. ");
INSERT INTO tbg_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Viraqaahairo Mosiva kori tainta vo, koqe mura autuaina ofaa taintara, vira vuru kavaqaara tataaqa vatero, ");
INSERT INTO tbg_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","muntavu haikara vuquru tovaro iteharo koqe unta i vaura. Noravano Kotiva tuntema kero, Mosiva mintura. ");
INSERT INTO tbg_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mosiva Seri Naavu qentiqaa nora tavuna vo hiritovaro qenti vira mantaaqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Mintima kero Mosiva ofaa tainta vo, vahaaqaini qentiana vatora. Vi taintaraqaa Mosiva ekaara kaintu iha quare ofaaravata, uiti auruvata Kotira iha quara amitora. Noravano Kotiva tuntema kero, Mosiva mintura. ");
INSERT INTO tbg_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ofaa tainta hini vauvaro Seri Naavu hini vauvaro tavaarana Mosiva nora tanu vatero, viraqi namari kaqa varero vuru mpiqa kero vatora. ");
INSERT INTO tbg_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Mosika Eronikavata, Eronira maaqunavuvata, Kotira Seri Naavuqi vireka ihave, vika Kotira ofaa iha quara amitareka ihave, vika nái aiqu kauqu naane vi tanuraqi hiqamakeha vaura. Noravano Kotiva tuntemake vika mintura. ");
INSERT INTO tbg_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Seri Naavu vahaaqaini vatuka variarire tiro, Mosiva hohaa arakero avuta ntuvatero, tavuna varakero hohaa qentiana hiritora. Mosiva mintiaqiro viharo ekaa vi kaiqara vara taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ekaa vi kaiqara vara vuru taiqa kovaro viraqaahairo tonavuvano tuvu Seri Naavu viraqaa hihipaa iro vaura. Noravano Kotiva tonavuqi vauvarora tiro, vira mpeqa okara takuqi vaiva Seri Naavu viraqi mpiqaviro ataa iharo vaura. ");
INSERT INTO tbg_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mintimakero takuqi vauvarora tiro, Mosiva Seri Naavu viraqi oriqetaarirava kia ho vaura. ");
INSERT INTO tbg_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tonavuvano Seri Naavuqaa hihipaa iro vau entara Isareri vika miniqai variqi vi vaura. Viraqaahai vika tavovaro tonavuvano Seri Naavu kero vumanta vi entara vika tonavu vira avataqi viha, nái seri naavu maaqa rampai vare tonavu vira avataqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tonavuvano Seri Naavu qiataqaa vau entara Isareri vikavata kia viraiti, mini vaura. ");
INSERT INTO tbg_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ho aatitoraqaa vo enta vo enta vika tavovaro Noravano Kotiva tonavu viraqi vauva Seri Naavu qiataqaa vaumanta entaqi vika tavovaro tonavu viraqi ihavano ite vaura. Isareri vika aahara vataini nuvaqi vu entara vika mintimake vi haikara tavora. ");
INSERT INTO tbg_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Noravano Kotiva Mosira tiva ami haro mintima tiro: ");
INSERT INTO tbg_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Vate are tiramanta silvaa ori vokinara varakema hamaqohai vira ruqutuke kakanairima kema, viraqohai aanumaara/noma taaraqantama autu kaate. Are vaiinti nahenti ruvaaquma kareva ina entara, are tiramanta aanumaara vuaqa kaimanta are inanaini ani ruvaaquma vuate. Qaiqaa ne katu vare vonaini vireka i entara, are tiramanta aanumaara vuaqa kaimanta are inanaini ani ruvaaquma vuate. ");
INSERT INTO tbg_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Vo vaka are tiramanta aanumaara taara vitanta vukaiqamake vuaqa kaimanta, ekaa vaiinti nahenti ani ti Seri Naavu qentiana ruvaaquma vuate. ");
INSERT INTO tbg_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Are tiraro aanumaara vohaiqaqai vuaqa kairamanta ekaa ankuqihai qiata vaiintinavuqai ani ai hampata ruvaaquma vuate. ");
INSERT INTO tbg_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Are tiramanta aanumaara votataa votataa inaaraiqa vuaqa kairamanta, kuari avu uri mantaraini vai vaiinti nahentika vika naane himpi katu vare vuate. ");
INSERT INTO tbg_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Sauti mantaraini vai vaiinti nahentika vikavata himpi katu vare vuate tira, qaiqaavata votataa votataa inaaraiqa aanumaara vuaqaate. Ne vonaini katu vare vi entara, mintimake aanumaara vuaqa kaate. ");
INSERT INTO tbg_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Are vaiinti nahenti ruvaaquma kareva ina entara, are tiramanta aanumaara vukaiqamake vuaqa kaate. ");
INSERT INTO tbg_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Eronira maaqunavu ti kaiqa vara timite variaka, vikaqaima aanumaara vira vuaqevarave. Nevata, ni vaiinti nahenti naantiara qovaraiqikavata, te vate vi uvara tiva taunara kia qaqira karaiti, qaqi iriqi vuate. ");
INSERT INTO tbg_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Naantiara ne nenta vataini vaimanta navutaaka ni hampata raqireka animanta, ne aanumaara vira vuaqehama vaiinti vara himpima kaimanta navutaaka hampata raqireka vuate. Ne mintiqe te Noravano Kotika ni Variqavano ni ruaruama nimitaari vika kia ho ni naatara kevarave. ");
INSERT INTO tbg_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ne quaheha ovata ne entarave, qaraaka tora itaaina entara vaiha ovata ne entarave, voki entara nora entave tivakeha ovata ne entarave, ne vi entara vi entaraqaa ekaara kaintu iha quare ofaaravata, ti hampata vohaa tampamavi vai ofaaravata ti timitehama, aanumaaravata vuaqa kaate. Ne mintiqe te niara irihama ni kahaqama nimitarerave. Te Noravano Kotika ni Variqavanoma vauro, tiro. Noravano Kotiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Isareri vatanaaka Isipi mini ke vuvaro taara ihi aitarovaro 20 enta 2 toraqaa Kotira Seri Naavuqaa vaavi vau quromurava vi naavuraqaahairo virini ori vaiqiro vura. ");
INSERT INTO tbg_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ori vaiqiro vumanta Isareri vira tave, vika himpi Sainai qumina kanta vaura mini ke vura. Vuvaro vaavi vau quromurava viro, qumina vata Paraanive tunaini oru himpitero vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mini oru vauvaro Noravano Kotiva avuniqamakero Mosira uva tiva amuvaro Mosiva Isareriara minti mintimake vuate tumanta vika vira uva iriha vura. ");
INSERT INTO tbg_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","16","Vika vo vatukaqi vo vatukaqi oru viha kia hampiara voqaara viraiti, Iutaara ankuvata, Isakaara ankuvata, Sebulunira ankuvata, vika naane avuni vi vaura. Vika rairavi, vonavu vonavu nai vutora nai vutora utu vareha vura. Aminadaapira maaqu Nasoniva Iutaara anku qiata vaiintivano vauvaro, Suara maaqu Netanieriva Isakaara anku qiata vaiintivano vauvaro, Helonira maaqu Eliaapiva Sebulunira anku qiata vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ho vi ankuka vi ankuka avuni vumanta Rivaira ankuqihai Gesonira ankuvata Meraarira ankuvata vika Kotira Seri Naavu rampaike vatora vira aqu vare vura. ");
INSERT INTO tbg_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","20","Vika aqu vare vumanta vika naantiara Rubenira ankuvata Simionira ankuvata Gaatira ankuvata vura. Vika vonavu vonavu viha nai vutora nai vutora utu vareha vurama. Sedeura maaqu Elisuva ekaa vika qiata vaiintivano vauvaro, Surisadaira maaqu Selumieriva Simionira anku qiata vaiintivano vauvaro, Duelira maaqu Eliasaapiva Gaatira anku qiata vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ho vika vumanta vika naantiara Rivaira ankuqihai Kohaatira anku vinavuka Kotira Seri Naavuqihai Kotira kaiqara iriha vato haikara, vi haikara vi haikara vare vura. Vika vi haikara vi haikara vareha, vokuka Kotira Seri Naavu avuni vare vuru kaqatonaini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","24","Mintumanta vika naantiara Efaraimura ankuvata, Manasera ankuvata, Benaminira ankuvata, vura. Vikavata viha nai vutora nai vutora utu vareha vurama. Amihutira maaqu Elisamaava Efaraimura anku qiata vaiintivano vauvaro, Pentaasura maaqu Gamelieriva Manasera anku qiata vaiintivano vauvaro, Gideonira maaqu Abidaaniva Benaminira anku qiata vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ho vika vumanta vika naantiara ekaanaini Daanira ankuvata, ˻Asera ankuvata, Napataarira ankuvata˼ vura. Vikavata viha nai vutora nai vutora utu vareha vuvaro Amisadaira maaqu Ahieseva ekaa vika qiata vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okaraanira maaqu Pagieriva Asera anku qiata vaiintivano vauvaro, ");
INSERT INTO tbg_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enaanira maaqu Ahiraava Napataarira anku qiata vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Vo enta vo enta Isareri vika naavu rampaike vireka u entara, vika mintima keha nai naantiara nai naantiara vi vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ho Mosiva Jetarora maaqu nai aituara Hobaapira Midianihainaara tiva amiro tiharo, Vate tenavu himpi haaru Noravano Kotiva tinavuara tiharo, Vi vatara ni nimirerave tunaini virerave. Viva nai kauqu aiqiqaa aqukero tinavuara tiharo, Ne vi vataraqaa vaiha koqemake variqi vivarave, turave. Noravano Kotiva minti turara ti, te ariara tinavu hampata aniraqe tenavu ai koqema amitaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Mosiva minti tuvaro Hobaapiva tiharo, Aqao, kia te mini virerave. Te tenta maaqaini anirante oru tenta navunaaka hampata vairerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Hobaapiva minti tuvaro Mosiva tiharo, Mpo, are kia tinavu kaane. Qumina vataini vaiinti nahenti seri naavu maaqa ho kaqake vai vatukara, are vi vatara vi vatara tavaanarave. Are tinavu vi aarara humiqaqira viraqe tenavu ho vuare. ");
INSERT INTO tbg_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Are tinavu hampata anirera, tenavu Noravano Kotiva ekaa koqe haika tinavu timireva iainara rairake hini aivata amiare, tiro. Mosiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ho vaiinti nahenti Nora Kotira aiqina, Sainai Aiqina mini ke vika taaramo entara aaraini vi vaura. Vika aaraini vi vaumanta Noravano Kotiva uva tiva taatauto Vokisera aqu vare vi vauka, vi vaiintinavuka avuni viha, vika seri naavu kaqe vatukara rantaqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Vika aaraini viha vonaini vonaini vi vauvaro Nora Kotira quromuravano vaavi himpitero vika vi vauraqaa vaura. Ekaa enta aatitoraqaa quromuravano mintima keharo vaura. ");
INSERT INTO tbg_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Vika Kotira Vokise vare vire u entara, ekaa vi entaraqaa Mosiva tiharo, Noravauvo, are himpira oru nena navutaaka ntaihehara vika raumpirima kairamanta qetake vuate. Are ai navutaiqi variaka ntaihaira vika qetake kantama vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ho vika aaraini anikoka auraara vaireka, Kotira Vokise vataini vuru vato entara Mosiva qaiqaa Kotira aareharo tiharo, Noravauvo, are orurantera tinavu Isareri vo anku vo anku vaurauka hampata ani variane, tiro. Mosiva vi entara vi entaraqaa minti tura. ");
INSERT INTO tbg_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Vi entara vaiinti nahenti tinavuqaa nora maaravanoma vaivo tivake nuntu nauntu ti vauvaro Noravano Kotiva vika uva irura. Viva vika uva iruvaro vira kaara vira arara itovaro viva iha vara kovaro ihavano vika naavu maaqa kaqatova auvahihataa vaura ita taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Mintumanta vaiinti nahenti tave, viraqaahai Mosirara, Mpo, tinavu kahaqiane, tuvaro Mosiva Nora Kotira aarovaro ihavano qimpa vura. ");
INSERT INTO tbg_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mintumanta vika vi vatukara autu nteha tiha, Taberave – Ihavano-Itako-Vatukarave, tura. Noravano Kotiva varako ihava vika avutana iteharo qoraiqama nimitorara ti, vika minti tura. ");
INSERT INTO tbg_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Airi vo vatanaaka Isareri hampata vuka, vo enta vo enta vohaa karaqai namaqi vuvaro popohomanta vika vo karavata naataa umanta vaura. Isareri vikavata karara nuntu nauntu tiha, Mpo, tinavu mativata naataa ivo. ");
INSERT INTO tbg_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tenavu Isipini vaiha, airi havuka kia koqaa aqukaraiti, qumina varakeha naavaunarave. Tenavu mini vaiha naaqerave, merenive, qaniqanive, kempuka qaniqanive, vi karara vi karara qaqi qumina varakeha naavaunarave. ");
INSERT INTO tbg_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Vate maini vauraro tinavu kempuka taiqa vimanta kia karavata vatauro. Manaaqai vaivaro tinavu vi karara popohaivo, tura. ");
INSERT INTO tbg_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manaa vaireva, hanta auru kohe/naavara tava voqaara vaura. ");
INSERT INTO tbg_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Vi entara entaqi varavuvano vatukaqi qovaraiquraqaa, manaavano varavu hampata hiqintiro vaura. Toqaqi vaiinti nahenti vevante vi aniha manaa vira nunti vaura. Hini kuka vira nuntu vare vuru oriqohai rukokakima komanta, hini kuka kaavuqohai vira ruqutu ruqutumake ataara ntuvake vate vaura. Ataaraiqama vumanta hini kuka vira kureqi arate vaumanta, hini kuka vira untake bisiketi voqaara autuke vaura. Vika mintimake vira neha tavovaro orivi vahaveraqohai untato mparetira voqaara vaura. ");
INSERT INTO tbg_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ho mati kia vaura kaara ekaa vaiinti nahenti nái vaintivara hampata nái seri naavu maaqa qentiana vaiha voqamake iqi rate vauvaro Mosiva vika iqi ratora irura. Mintuvaro Noravano Kotiva vikara voqama kero arara itovaro vauvaro vira kaara Mosira muntukavano qoraiquvaro ");
INSERT INTO tbg_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nora Kotira aareharo tiharo, Mpo, Noravauvo, nantivarae are ti qoraiqama timitaaro? Nantivarae are tiriara kia quahaaro? Nantivarae are vaiinti nahentiqaa raqikia kaiqara ti vohaiqaqaaqai vataaro? ");
INSERT INTO tbg_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kia te vika kuvuarama tauraukavauve. Kia te vika noka vaiha vika vata tauraukavauve. Mpo, nantivarae are tiriara tihara, Nahentivano vaintiqaa raqikiharo vira kaqa varero vuru vonaini kaintema kera, are maa vatanaaka ntita varera vuru tenta kauqu aiqiqaa aqukehama nimirerave tuna vataraqaa vuru kaane, tianarave? ");
INSERT INTO tbg_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Maa vaiinti nahentika qaqiqai rateha matiara ti naari variavo. Te taihaie airi mati varake vika nimiari nevarave? ");
INSERT INTO tbg_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Te tentaraa kia ho maa vaiinti nahentikaqaa raqikiqi virarave. Vi maarara kia ho varaainarave. ");
INSERT INTO tbg_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Are mintima kera ti qoraiqama timitaqi virera, are homa ti harukaiqe te qutuvi kia qaiqaa vukaari utiha vi maarara varaqi vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mosiva minti tuvaro Noravano Kotiva vira tiva amiro tiharo, Are tavera vaiinti nahenti nivutaini qiata vaiinti koqe autu vatauka 70navu ntita kera aniane. Are vika ntita varera ti Seri Naavuvano vainanaini viri kairamanta vika ai hampata mini himpite variate. ");
INSERT INTO tbg_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ne mini ani vaiqe te tuvunte ai hampata uva tirerave. Te tenta Maraqura ai amunantemake, vikavata tenta Maraqura nimirerave. Te mintiariraro vika avu aato koqe iramanta vika homa ai kahaqiha vaiinti nahenti maara vikavata varevarave. Vika mintimake ai kahaqi vaivara, are kia nenaraa vi maarara varenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Noravano Kotiva minti tivakero qaiqaa Mosirara tiharo, Ho vate are vaiinti nahenti mintima tiva nimiane: Ne hurara iriha, vate nenta avu aato muntuka hiqamake qeramateha variate. (Katu Varora 19:10) Hurama ne mati nevarave. Ne voqamake matiara antura ntuavaro Noravano Kotiva virara irivo. Viva irimanta ne tiha, Tenavu Isipini vaiha koqemake vaunarave, tiarave. Ho iriate. Noravano Kotiva mati ni nimiramanta ne nevarave. ");
INSERT INTO tbg_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Noravano Kotiva mati ni nimiramanta ne kiama vohaa entave, taara entave, kauquru entave, kauqurutanta entave, 20 entaqaive, nevarave. ");
INSERT INTO tbg_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ne vohaa torarama mati namaqi viqata viqata tima, popohamavi, qaiqaa neha vuru vihivaro, vuruvano ni aiqi ntunahairovata tuvuanarove. Noravano Kotiva ni hampata vaimantavata, ne mati kaara vira qoririma amitaarave. Ne nuntu nauntu tiha, Nantihae tenavu Isipi ke maini anuro? tiarave. Ne minti tiara kaara vi haikava niqi qovaraiqianarove, tiane, tiro. Kotiva Mosirara vaiinti nahenti minti tivakehara tiva nimiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Noravano Kotiva minti tuvaro Mosiva nai tiva amiro tiharo, Noravauvo, iriane. Te airi vaiinti nahenti 600,000navuqaa raqiki vaurarama are tihara, Te homa vohaa torara vika mati nimirerave, tiaro. Ho are taihairae mati vira rantakera vika nimirevae tiaro? ");
INSERT INTO tbg_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ike, tenavu ekaa purumakauve sipisipive aruke nimiari vika nama taiqake, vika ho naurove tivarave? Ekaa havuka nora namariqiraara vika nimiariraro kia ho vikaqi varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Minti tuvaro Noravano Kotiva Mosira nai tiva amiro tiharo, Are tiriarae vira kempukavano kia ho vaivo tiaro? Are inaaraiqakaa varikerama tavenarave. Are vaihara tavairaro te tiarira haikava qovaraanarove kiae qovaraanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Noravano Kotiva minti tuvaro Mosiva iriro, vahaaqaini veva ntero Noravano Kotiva tu uvara vaiinti nahenti tiva nimiro, viraqaahairo viva qiata vaiinti 70navu naarama kero, vikara Seri Naavu ututumate variate tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Minti tumanta vika ututumate vauvaro Noravano Kotiva vira naantiara quromuraqi tuvuntero Mosikantiro uva tivakero, viraqaahairo viva Mosira amu Maraquraraqihairo voki kempukara varakero qiata vaiinti 70navu nimura. Mintiakero nimuvaro Maraqura viva vikaqi vaumanta vikavata paropeti vaiinti uva tuntemake, uva ti vaura. Kia vo entavata vika minti tiraiti, vi entaraqai vika paropeti uva mintimake tura. ");
INSERT INTO tbg_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ho vinavuka paropeti uva ti vaumanta, qiata vaiinti votanta Eladaatika Medaatika kia qiata vaiinti vokuka Kotira Seri Naavuni ruvaaquma vunaini viraiti, vitanta qaqi vatukaini vauvarovata, Noravano u Maraqurava vitantaqaavata tuvu vaumanta vitantavata vaiha paropeti vaiintivano uva tuntemake, Kotira uva tiva qoqaiqi vaura. ");
INSERT INTO tbg_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Vitanta minti ti vaumanta qaraaka vaiinti vovano kantero vuru Mosira tiva amiro tiharo, Eladaatika Medaatika vatukaini vaiha paropeti vaiinti voqaantemake, uva ti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Minti tuvaro Nunira maaqu Iosuaava, qaraaka vaiintivano vau entaraqaahairo Mosira hampata vaiharo vira kaiqa kahaqamaqi ani vauva, Mosirara tiharo, Nora vaiintio, are vuru tira vitanta kia uva tiraiti, uve variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Iosuaava minti tuvaro Mosiva aqao tiro, Vovano ti vatuka varaainara are virarae nora aato iriaro? Kia virara noraiqaakera iriane. Noravano Kotiva nai Maraqura vaiinti nahenti nimira ekaa vikavata paropetivano Kotira uva qoqaiqama kaintemake tivera, te hovema tirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mosiva mini vaiharo ekaa vi uvara tiva taiqakero Isareri qiata vaiintinavu hampata anirantero vatukaini vura. ");
INSERT INTO tbg_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Noravano Kotiva uvai vara kovaro uvaivano utiharo nora namariqaahairo airi uviri ventaqiro anura. Vika muavu voqaara vau uvirika ata vare, vata vauvau niha vatuka avutaqivata, vatuka aaqainivata, unutete vaura. Airitahaavano ekaa ho tave vata maatara, aru mpiqake unutete vaura. ");
INSERT INTO tbg_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mintumanta vaiinti nahenti kuariqaavata entaqivata ni vaiha uviri vira nuntuke vare vaura. Qaiqaa vira qararaavata qaqiqai nuntuke vare vaura. Vika vohaiqa vohaiqavano airi uviri varora maaravano vaireva, 1,000 kilo aatarakero vaura. Vika uviri vira qumpihia keha vatukaqaa auruma tovaro kuarivano iteharo uviri mati vira aaharaiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ho vaiinti nahenti uviri vira qaqi ne vauvaro Noravano Kotiva vikara arara itovaro nora aihaviraara vara kovaro vikaqi tuvumanta vika vi aihaviraara vare airi vaiinti nahenti qutu vura. ");
INSERT INTO tbg_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Airi vaiinti nahenti vi entara qutu vumanta mini quntama torara ti, vika vi vatara autu nteha tiha, Kibaroti-Hataava – Voqamake-Mati-Naataa-Uka-Quntama- Taanainive, tura. ");
INSERT INTO tbg_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ho Isareri vika vi vatara ke, Haserotini orunte mini seri naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Vi entara vika Haserotini vauvaro Mosira naata Sudani vatanaa nahentivano vaumanta Eronika Miriaamika Mosiva vi nahentira varorara iriha vitanta Mosirara pupiteha qora uva tura. (Katu Varora 2:21) ");
INSERT INTO tbg_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Vitanta mintima ti: Noravano Kotiva Mosira noqaahairoqaie nai uva ti vairave? Kiave, viva titanta noqihairovata ti vairave, tura. Vitanta minti ti vauvaro Noravano Kotiva vitanta tu uvara irura. ");
INSERT INTO tbg_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Mosiva kia nai mahuta tiraitiro, viva nai autu vara muntuvi vatainiqaa keharo ni vauva vauvaro, kia maa vataraqaahainaa vaiinti vovano Mosira voqaantema kero, nai autu vara muntuviqama keharo vaiva vairave) ");
INSERT INTO tbg_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Mosiva mintima vau vaiintiva vaumanta Eronika Miriaamika virara pupiteha qora uva ti vauvaro vaakama Noravano Kotiva vinavukara tiharo, Ne taaramonavu vaakama ti Seri Naavu vainanaini aniate, tiro. Minti tumanta vinavuka himpi mini vura. ");
INSERT INTO tbg_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Vika mini oru vauvaro Noravano Kotiva quromuraqi tuvuntero nai Seri Naavu qentiqaa himpitero vaiharo Eronika Miriaamika naarama kero tiharo, Netanta aniate, tumanta vitanta vira aumanto ori vaiqura. ");
INSERT INTO tbg_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ori vaiquvaro Noravano Kotiva vitanta tiva nimiro tiharo, Ti uva iriate. Paropeti vaiinti vovano ni Isareri avutana vai entara, te tenta okara vira umiqare iha, tairakaa umiqeha uvavata tairakaaqai vira tiva ami vaunarave. ");
INSERT INTO tbg_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tenta kaiqa vaiinti Mosira tiva amire iha kia paropeti vainti tiva nimunantemake vira tiva amiraiti, vo qaramake vira tiva ami vaunarave. Te ekaa tenta kaiqa vira amitauraro viva vi kaiqara ho vare vairave. ");
INSERT INTO tbg_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Vaiintivano nai tontintiro uva tintemake, te vira hampata uva ti vaunarave. Te vikanti uva tirera iha, kiama uva tuqantaake tiva amiraiti, ekaa uva vutukeqai vira tiva ami vaunarave. Minti ti vauraro viva ti hampata uva tiharo ti tave vairave. Ho nantihae netanta kia qetaraiti, Mosirara pupiteha qora uva tiavo? Viva ti kaiqa vaiintima vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nora Kotira arara itovaro minti tivakero vitanta noraiqama kero nitikero vatero tuvurantero vurama. ");
INSERT INTO tbg_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kotira quromuravano Seri Naavu mini kero vuvaro vaakama vaata ne vau rovarava Miriaamiraqaa qovarama vuvaro vira vaatavano hantaiqama vura. Mintima vauvaro Eroniva tuqantaa viro tavovaro vi rovarava Miriaamira vaataqaa ekaa raapama vura. ");
INSERT INTO tbg_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Mintima vuvaro Eroniva Mosirara tiharo, Mpo, nora vaiintivauvo, tetanta kia koqe avu aato iriraiti, qora kaiqa varehama Kotira uva raqa kauro. Ho are titanta aaqurihama timitera, qaqi kairaqe tentatanta qora okara varaunara kaara kia vi maarara varaare. ");
INSERT INTO tbg_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Oho, nai nora auhaqi qutu vi vaintira vatataivaro vira hini vaata nteravira voqaara vira viri vaata variantorave. Kia are Miriaamira qaqi kairaro mintimakero variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Eroniva minti tuvaro Mosiva Nora Kotira aareharo tiharo, Mpo, Noravauvo, are Miriaamira kahaqiraro viva qaiqaa ho variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mosiva Kotirara minti tuvaro Noravano Kotiva nai tiva amiro tiharo, Miriaamira vira qova vo uva kaara vira viriqi taara vihitaitirio, Miriaamiva vohaa uikima vaiharo kaurira haika varaitirio. Vira voqaantema kero, Miriaamiva vohaa uikiara vatuka aaqaini variqi viro, qaiqaa vatukaqi uruarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Noravano Kotiva minti tumanta vohaa uikiara Miriaamira atitama kovaro viva vatuka aaqaini otu vaura. Viva vatuka aaqa mini vaumanta vaiinti nahenti kia katu vare viraiti, vika Miriaamiva qaiqaa vatukaqi uruainara vira veka vaura. ");
INSERT INTO tbg_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Miriaamira veka vauvaro viva vatukaqi urumanta vika Haseroti mini ke oru aahara vata Paraanini seri naavu maaqa qaiqaa kaqateha vaura. ");
INSERT INTO tbg_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Noravano Kotiva Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Te Kenaani vata vira ni Isareri nimirerave tunarara iriharama, are vaiinti vonavu nititaira vika oru vi vataraqaa vi aniha ampeqamake tavaate. Are 12 ankunavuqihaira qiata vaiinti vohaiqa vohaiqa kaama tera nititaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kotiva minti tuvaro Mosiva qumina vataini Paraanini vaiharo Noravano tunte iro qiata vaiinti vika nititomanta mini vura. ");
INSERT INTO tbg_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Qiata vaiinti vika nutu maantimama vairo: Rubenira ankuqihainaava Sakura maaqu Samuaava, ");
INSERT INTO tbg_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simionira ankuqihainaava Horira maaqu Sapaativa, ");
INSERT INTO tbg_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Iutaara ankuqihainaava Jefunera maaqu Kalepiva, ");
INSERT INTO tbg_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakaara ankuqihainaava Iohepira maaqu Igaliva, ");
INSERT INTO tbg_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efaraimura ankuqihainaava Nunira maaqu Hoseaava, ");
INSERT INTO tbg_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benaminira ankuqihainaava Rapura maaqu Palitiva, ");
INSERT INTO tbg_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sebulunira ankuqihainaava Sodira maaqu Gadieriva, ");
INSERT INTO tbg_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manasera ankuqihainaava Susira maaqu Gadiva, ");
INSERT INTO tbg_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Daanira ankuqihainaava Gemalira maaqu Amieliva, ");
INSERT INTO tbg_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asera ankuqihainaava Maikerira maaqu Seturiva, ");
INSERT INTO tbg_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Napataarira ankuqihainaava Vopisira maaqu Nabaava, ");
INSERT INTO tbg_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gaatira ankuqihainaava Makira maaqu Gueriva, Vika vika nutu mintima vaura. ");
INSERT INTO tbg_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mosiva qiata vaiinti vinavuka nititomanta vinavuka Kenaanini vi aniha ampeqama keha tavora. Mosiva Nunira maaqu Hoseaara vo autuvata ntava tero virara Iosuaarave tura. ");
INSERT INTO tbg_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mosiva vinavuka nititareva iharo mintima tiro: Ne Nekevi vata vara maini kema veranto vuate. ");
INSERT INTO tbg_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ne mini niha koqemake aitutumaqi vuate. Veranto vai vatava vaireva, nana vatae vaivo? Vi vatanaaka kempuka vatanaakae, uqerara vatanaakae variavo? Vika airie variavo, kiae airi variavo? ");
INSERT INTO tbg_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Vika vatavano koqe vatae vaivo, qora vatae vaivo? Vi vatanaaka qumina vatukanavuqie variavo, vaantaavura aututaa vatukanavuraqie variavo? ");
INSERT INTO tbg_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Vi vataraqi kara koqema keroe qampiqe vaivo, kiae koqema kero qampiqe vaivo? Nantavatae vaivo, kiae nantavata vaivo? Vi haikara vi haikara rantakeha tavaate. Nenavu kia qetaraiti, vi vataraqaahainaa katari tava vokira hiqi vare maini aniqe tenavuvata tavaare, tiro. Uaini tava hoqare mpeqaiqi entara Mosiva vi uvara minti tiva kero vinavuka tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Mosiva vinavuka nititomanta vinavuka hoqaramake Seni qumina kanta ampeqama keha tavamaqi vivi, vo vatuka Rehoni aumanto oru ntora. Rehoniqaahairo aara vovano Hamaati vatukaini oruntora. ");
INSERT INTO tbg_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Viraqaahai vinavuka vata vo Nekevive tunaini orunte, vihai vatuka vo, Hebaronini vura. Vinavuka mini orunte tavomanta Anaaki vatanaaka vaintivara mini vaura. Haaru Anaaki vatanaaka vukai vuhaari vatauka vaumanta vika naintivara Ahimaanura ankuvata, Sesaira ankuvata, Tarimaira ankuvata, Hebaronini vaura. (Vi vatanaaka naane Hebaroni vatuka autu kovaro ihi 7navu aitaromanta Isipi vatanaaka Soani vatuka autu kora.) ");
INSERT INTO tbg_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","24","Ho Mosiva nititoka vivi, Esikoli uqita kanta orunte, mini vaiha uaini naaquntaqaahairo airi tava irato kaarara vohaiqa teqa kora. Vi kaararaqaa airi tava vohaaraqi iratovaro voqama kero maara ntovarora tiro, vohaa vaiintivano kia ho varaarirava vaumanta taaraqantavano vira rumpake aqu vare vura. Vinavuka mintimake uaini tava aqu varorara ti, Isareri vi vatara autu nteha Esikolive – Kaara-vohaiqaqaa-airi-tava-iratorave, tura. Vinavuka uaini tavavata, fiki katari tavavata, pomigraneti katari tavavatamake, vare vura. ");
INSERT INTO tbg_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","26","Mosiva nititoka vi vataraqaa 40 entanavuara rantake tavamaqi vivi taiqake, vinavuka vihai orurante Mosivavata Eronivavata ekaa Isarerivata unaini anura. Vi entara ekaa vika Kadesi qumina vataini Paraanini vaumanta vinavuka vihai orurante nái nu vakaakara vika tiva nimiha, vi katari tavara vare anuravata vika numiqora. ");
INSERT INTO tbg_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Vinavuka Mosira tiva ami tiha, Are tinavu tititehara oru vi vatara aitutumake tavaate tianara, tenavu oru tavauraro karavano koqemakero mini qampiqaaina vatavama vaivo. Ho tavaane. Tenavu vi vataraqaahainaa kara vokira vare anuro. ");
INSERT INTO tbg_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Vatavano koqe vata vaimantavata, vihainaaka kempuka vatanaaka variavaro vika vatukavano nora vatuka vaivaro vika vaantaavuravata kempuka vaantaavurama vaivo. Ike, tenavu tavauramanta Anaaki vatanaaka naintivara nái naaqu taatoka vuhaari voqaara vukai vuhaari vataukama mini variavo. ");
INSERT INTO tbg_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Tenavu tavauramanta hini mantaraini Nekevi vataqaa Amareki vatanaaka variamanta, hini mantaraini verara aiqina vainaini Hiti vatanaakavata, Jebusi vatanaakavata, Amo vatanaakavata, variamanta, Kenaani vatanaaka hini kiaka nora namari Meditarenia Namari auvahini variamanta hini kiakama Iotani Namari auvahini variavo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Minti tumanta Isareri vinavuka tu uvara iri, qeteha Mosirara nuntu nauntu ti vauvaro Mosiva nititokaqihairo vaiinti vo vira autu Kalepiva vika uva mpampaira atakero tiharo, Nana kaarae ne nuntu nauntu ti variavo? Tinavu kempuka voqavata vaikave. Vate tenavu homa vika aru naatarake vika vata varaainarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Viva minti tumanta Kalepira hampata vuka kempukaiqamake tiha, Aqao, vi vatanaaka kempuka voqavata vaimanta variarara ti, tenavu kiama ho vika hampata raqirarave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","33","Vinavuka minti tivakeha kia koqe uva vi vatarara tiraiti, maa uvaravata tiha, Tenavu vi vataraqaa niha tavauraro kia koqe vata vaivaro inaara karaqai vaimanta vaiinti nahenti karara aavoqiha variavo. Tenavu tavauramanta vaiinti nahenti noraqora hauntivano mini variavo. Anaaki vatanaaka naintivara vukai vuhaari vataukama mini variavo. Tenavu vi vatanaaka tave vika nivuqaa kaintaaqa voqaara vauramanta vikavata tinavu tavaamanta tenavu kaintaaqa voqaarama vauro, ti. Vinavuka minti tuvaro vi uvava vi ani umanta ekaa Isareri vi uvara irura. ");
INSERT INTO tbg_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mintumanta vaiinti nahenti vinavuka tu uvara iri, vika entaqi voqamake oi aai ti vaiha iqi rataqi vivi aatita kora. ");
INSERT INTO tbg_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ekaa vika Mosika Eronikara nuntu nauntu tivaqi viha vitantara tiha, Mpo, koqemama tenavu Isipinie, maini aahara vatainie, variqi vi vuru qutu vuataarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nantivaroe Noravano Kotiva tinavu tivita varero vi vataraqaa virevae auti vaivo? Vi vatanaaka raqiha tinavu haruke, tinavu vaintive nahentive ravaaqavu kaimanta vika paanaa vaintima vaivarave. Tenavu Isipini qaiqaa anirante vuariraro koqe iataarave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Vika minti tivake nai tiva ami nai tiva amiha tiha, Aniqenavu qiata vaiinti vo kaamate vira noraiqama kaariraro viva qaiqaa tinavu tivita varero Isipini anirantero vuarire, ti. ");
INSERT INTO tbg_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Vika minti ti vaura kaara Mosika Eronika vaiinti nahenti nivuqaa vataini hiqintivi, náitanta viri vataini ke vaura. ");
INSERT INTO tbg_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Mintumanta Nunira maaqu Iosuaavavata, Jefunera maaqu Kalepivavata, vitanta vi entara Kenaani vata ampeqama keha tavotanta, vika tu uvara kaara muntuka qoraiqumanta vitanta náitanta utavaaqa qunahi qaanahimake, ");
INSERT INTO tbg_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","vaiinti nahenti tiva nimi tiha, Tenavu vi vatara tavauraro koqe vatama vaivo. ");
INSERT INTO tbg_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Noravano Kotiva tinavuara quahairera, viva homa tinavu tivita varero karavano koqemakero qampiqaaina vataraqaa vuru kaanarove. ");
INSERT INTO tbg_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ne kiama vaiinti nahenti mini variakara qeteha Kotira uva raqaate. Tenavu kiama vukaari utiraiti, vika naatara kararave. Noravano Kotiva tinavu hampata vaimantara ti, vika una variqanavu kiama ho vika antua nimitevarave. Mintima vairara ti, kia vika naatu qetaate, ti. ");
INSERT INTO tbg_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Vitanta minti tumanta Isareri vika kia Iosuaaka Kalepika tu uvarara quqaave tiraiti, vika tiha, Aniqe ori varake ˻Mosika Eronika˼ ruqutu kaare, tivake vika ori varake vitanta ruqutuare tuvaro vate virave tiro vaakama Kotiva vaunaini voqama kero takuqi vau ovava Kotira Seri Naavuqaa ite vaumanta vika ova aatu qeteha kia vitanta ntaihora. ");
INSERT INTO tbg_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mintuvaro Noravano Kotiva Mosira tiva amiro tiharo, Maa vaiinti nahentika qaiqaa qaiqaa ti qoririmake variavo. Te aahuva kaiqa, nora kaiqa vika avutana vara kauramantavata, vika tiriara viva tinavu kia ho kahaqianarove ti variavo. ");
INSERT INTO tbg_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Vira kaara kaiqe te qora aihaviraara vara kaariraro vika vehi autu taiqa kaarire. Te vika taiqake, viraqaahai ai Mosira kahaqiarirara are vo vatanaaka qova vairamanta vi vatanaaka kia maa vatanaaka voqaara vairaiti, vika uri aatarake nai kempuka vatanaaka airitahaama vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Noravano Kotiva minti tuvaro Mosiva aqao tiro, Mpo, Noravauvo, are nena kempukaqohaira maa vaiinti nahentika Isipihaira ntita varera maini viri kaarava vaihara are vika vehi autu kairera, Isipi vika virara iri, ");
INSERT INTO tbg_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","viraqaahai vika maa vataraqaa variakavata tiva nimivarave. Maa vataraqaa variaka kankomake iriavara are nena vaiinti nahenti hampata variaramanta ai vaiinti nahenti ai tave variarave. Maa vataraqaa variaka iriavara are kuariqaa quromuravano vaavi vairaqi vaihara tinavu avuni vihara, entaqi ihavano viavi ite vairaqi are tinavu avuni vi varianarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Are ekaa nena vaiinti nahenti vehi autu taiqa kairera, vo vatanaa vo vatanaaka ai nora kaiqara iriaka, vika ariara mintima tivarave: ");
INSERT INTO tbg_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Noravano Kotiva nai kauqu aiqiqaa aqukeharo vi vatara tenta vaiinti nahenti nimirerave tivakerovata, viva vika ntita varero qumina vataini viharo vika ekaa vehi autu taiqa kaivo, tivarave. Vika minti tivorave. ");
INSERT INTO tbg_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Noravauvo, haaru are nena kauqu aiqiqaa aqukehara te mintirerave tiana uvara irihara, nena kempuka tinavu humiqaane. Haaru are nena minti tianarave: ");
INSERT INTO tbg_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Te Noravano Kotika kia vaaka arara ite vaikave. Te vaiinti nahentiara voqamake aaqurihama nimite vauraukave. Te tenta uva ekaa enta avataqi vi vauraukave. Te ekaa vika vaaqu kaiqa vare variaravata, ti uva raqake variaravata, nunka nimite vauraukave. Mintihavata, te vika qora kaiqa varaara kaara vika ntaihama keha vika vaintivata, vika naintivaravata, vika naintivara vaintivaravata, ntaihama karerave, tianarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Mpo Noravauvo, are vaiinti nahentiara voqama kera aaqurihama nimite variaravara tira, are maa vaiinti nahentika qora kaiqa varaa uvara nunka nimitaane. Vika Isipihai anu entaraqaahaira are qaiqaa qaiqaa vika qora kaiqa varo uvara nunka nimitaanantema kera, maa entaravata vika uva nunka nimitaane turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mosiva minti tuvaro Noravano Kotiva nai tiva amiro tiharo, Hove, are tianantemake, te vika qora kaiqa varaa uvara nunka nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Te vika uva nunka nimiteha, vo uvavata tirerave. Te ekaa enta variqi vi vaurauka vauraro ti mpeqa okaravano ekaa vataini takuqiharo mpiqe vairave. Mintiverama te kauqu aiqiqaa aqukeha maa uvara kempukaiqamake mintima ti: ");
INSERT INTO tbg_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Maa vaiinti nahentikaqihairo kia voqavanovata te ni nimirera iaina vataraqaa vuanarove. Maa vaiinti nahentika Isipinivata qumina vatainivata vaiha, ti takuqi vai okararavata taveha, te nora kaiqa, vo kaiqa vo kaiqa varaunaravata tavaarave. Vika tavehavata, airi tataa ti uva raqakeha kia ti uva avate variarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Haaru te kauqu aiqiqaa aqukeha vika kaivaqaukavarara tiha, Ni vaintivara vi vatara nimirerave tuna vataraqaa maa vaiinti nahentika kia ho vivarave. Maa vaiinti nahentika ti qoririma timitaara kaara, kia voqavanovata mini ho vuanarove. ");
INSERT INTO tbg_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ti kaiqa vaiinti Kalepira avu aatovano vo qarama kero vaivaro viva tinta hantuqa avate vairara ti, te vira vita vare viva vaaka aitutuma kero tavai vatara mini vuru karerave. Te vira mini vuru kaariraro viva mini vairaro vi vatava vira naintivara vatama varianarove. ");
INSERT INTO tbg_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Maa entara Amareki vatanaakavata Kenaani vatanaakavata uqita kantama variavo. Virara irihama hura ne ekaa himpi katu vare anirante Naare Namari vainaini vi ani varia aararaqaa vivi, qumina vo kanta oru variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Noravano Kotiva Mosika Eronika tiva nimiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Maa vaiinti nahentika qora kaiqa vare variaka, vika airi entama tiriara nuntu nauntu ti variavaro ti popohaivo. Tairentae vika minti ti vai uvara qaqira kevarave? ");
INSERT INTO tbg_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ho netanta ti uva maa, vika tiva nimiate, Te Noravano ekaa enta variqi vi vauraukama te tenta kauqu aiqiqaa aqukeha niara mintima turo: Ne nuntu nauntu tiha, Tenavu maini qumina kanta variqi vi vuru qutu virerave, tia uvara iruro. Ho ne nenta tiantemake, tevata ni mintima karerave. ");
INSERT INTO tbg_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ne qutivaro ni vaatavano aahara vata, vi kanta hampiara voqaara varianarove. Ne tiriara nuntu nauntu ti vaiha tirori variara kaara ne ekaa 20 ihiqaahai voqavata varakeka kia ho vi vataraqaa vivarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Haaru te tenta kauqu aiqiqaa aqukeha niara vi vataraqaa oru variate tunarave. Vate ne ekaa kia ho mini vivarave. Ho Kalepika Iosuaakaqai vi vataraqaa vivarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ne tiha, Vi vatanaaka tinavu hampata raqiha tinavu haatarake tinavu vaintivara rumpatevarave, tiarave. Ho te vi vaintika ntita vare ne vi vatara qoririma kenaini vuru kaari vika vi vatara varema mini vaivarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ne kia mini viraiti, ne qumina vata maini vaihama qutu taiqa vivarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Nahentivano nai vaati qaqira kero vo vaiinti hampata nintemake, nevata ti qaqirake kia ti uva iriavo. Vira kaara ni vaintivara 40 ihiara aahara vata maini vi aniha, nora maara variqi vimanta ne vika noka qoka ekaa qutu taiqa vivarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Niqihai vaiinti vonavu 40 entanavu oru vi aniha vi vatara aitutumake tavaamanta viraqaahai ne ti uva raqa keha kia vi vataraqaa virerave tiara kaara te kia niara 40 entanavuara tiraiti, te niara 40 ihiarama ne nora maara varaqi vivarave. Ne mintimake variqi vivaro ni aato kenko tiramanta ne mintima tivarave: Oho, Noravano kia tinavuara quaheharo nora maarama tinavu timi vaivo, tivarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ne qora kaiqa vare variaka vaiha ne vohaa avu aato vateha ti qoririma timitaara kaara ne ekaa vohaiqa vohaiqavano qumina vataini vaiha qutu vivarave turo. Te Noravano Kotikama vi uvara tivatauro, tiro. Kotiva minti turama. ");
INSERT INTO tbg_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Mosiva vaiinti vonavu nititomanta vinavuka vi vatara aitutumake tavareka vunavuka, vinavuka orurante viri vaiinti nahentiara unahaa tiha, Vi vatara qora vatama vaivo, tumanta ekaa vaiinti nahenti vi uvara iri, Kotirara nuntu nauntu tura. Minti tura kaara Noravano qora rovara vara kovaro vi vaiintinavuka arukomanta vaaka qutu vura. ");
INSERT INTO tbg_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Vaiinti 12navu vi vatara oru aitutumake tavokaqihai 10navu qutu vumanta Iosuaaka Kalepikaqai kia qutiraiti, qaqi koqemake vaura. ");
INSERT INTO tbg_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mosiva Noravano Kotiva tu uvara Isareri tiva nimumanta vika vi uvara iriha voqamake iqi ratora. ");
INSERT INTO tbg_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Vika voqamake iqi ratake, vira qararaa toqaqi vika himpi vuru Mosira tiva ami tiha, Are iriane. Tenavu Noravano ti uvara raqake qora kaiqama vara kauro. Ho vate tenavu Noravano tinavu timireva tivatai vataraqaa virerave, ti. Vika minti tivake himpi veraini Kenaani hampata raqireka vurama. ");
INSERT INTO tbg_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Iqoka raqireka auti vauvaro Mosiva vikara aqao tiro, Nana kaarae ne Nora Kotira uva raqa keha kia vira uva irireka auti variavo? Ne mintivera, ne kia ho vi vatanaaka naatara kevarave. ");
INSERT INTO tbg_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Qaqirake kia vuate. Noravano Kotiva kiama ni hampata vaivo. Hauri ne vimanta navutaaka ni naatara kevorave. ");
INSERT INTO tbg_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ne mini orunte Amarekivata Kenaanivata hampata raqivera, vika ni aruma kevarave. Ne Nora Kotira qoririmake vira uva kia avataqi vuara kaara viva kia ni hampata vairaitiro, kiama ni kahaqianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Mosiva minti tumanta vika kempukaiqamake vira uva kia iriraiti, tenavu navutaaka homa naatara kararave tivake, vika hampata raqireka veraini vuvaro Mosiva kia vika hampata viraitiro, qaqi vatukaini vaura. Vika Nora Kotira Vokisevata kia vararaiti, qaqi vatukaini ke vura. ");
INSERT INTO tbg_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ho Isareri raqireka aaraini vi vaumanta vika navutaaka Amarekivata, Kenaanivata, veraihai uqitakanta tuvu Isareri hampata raqiha Isareri naatara kora. Vika Isareri aru ntataqi tuvi, muntu Homaa vatukaini kora... ");
INSERT INTO tbg_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Vaiinti vonavu Mosira uva kia irireka auti vaura. Vi vaiintinavuka nutu: Rivaira ankuqihairo Koraava. (Viva Isihaara maaquvano vauvaro vira kaivaqava Kohaativa vaura.) Rubenira ankuqihai Dataaniva, Abiraamuva, Oniva. (Dataanika Abiraamuka Eliaapira maaqutanta vauvaro Oniva Peretira maaquvano vaura.) Erakaimaante vaiinti vinavuka Isareri qiata vaiinti 250navu ntitake, kia Mosira vevaaraini vaireka auti vaura. Isareri vi vaiintinavuka kaama tomanta vinavuka vaiinti nahenti nivuqaa nora autu vatauka vaura. ");
INSERT INTO tbg_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ho vinavuka Mosika Eronika vaunaini ani ruvaaqumavi vaiha vitantara oho ti, Netanta iriate. Tenavu ekaa Noravano kaama taikama vauro. Kia netantaqaivauve viva kaama taika variavo. Noravano Kotiva ekaa tinavu hampatavatama vaivo. Mintimanta nantihae netanta nentatanta autu tuahereha tinavuqaa raqiki variavo? Netanta mintia okarava kiama avuqavuqivo, tuvaro ");
INSERT INTO tbg_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mosiva vika tu uvara iriro, vatakanta hiqinti viro nai viri vataini kero Kotira aarero. ");
INSERT INTO tbg_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Kotira aarama kero viraqihairo himpiro Koraaravata vira hampata anukavata tiva nimiro tiharo, Ho iriate. Hura toqaqi Noravano Kotiva nai mantaraini vai vaiintira tinavu humiqaanarove. Viva nai kaama tai vaiintira, viraqaima qaqi kairaro vira ofaa tainta tataaqa oru varianarove. ");
INSERT INTO tbg_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ho Koraao, arevata, ai avataqi aniakavata, nenavu mintima iate: Hura toqaqi nenavu tanu vohaiqa vohaiqa vare, ");
INSERT INTO tbg_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","vi tanuraqi iha aurivata koqe munta iaina haikaravata vate, tanu vira vare oru ofaa tainta tataaqa Nora Kotira avuqaa himpite variate. Ne mintivaro viva tinavuqihairo vaiinti vo kaama tairaqe tenavu vi vaiintirara vivama Noravano Kotiva i vaiintivave tiare. Ike, ne Rivaira anku Kotiva ni nimi kaiqaraqai varaataara vaimanta ne vo kaiqavata varareka auti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mosiva minti tivakero Koraara tiva amiro tiharo, Ne Rivaira anku iriate. ");
INSERT INTO tbg_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ike, ne kiae Kotiva ni nimi kaiqarara noraiqaake iriavo? Kotiva tinavu Isareri Variqavano tinavu Isareriqihairo ni Rivaira ankuqai rairakero kaama tero niara tiharo, Vikaqai ti aumanto orunte, ti Seri Naavuqi kaiqa vareha, vaiinti nahenti nivuqaavata himpi vaiha, vika kahaqama nimitaate, tirave. ");
INSERT INTO tbg_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kotiva nivata, ekaa hinikia Rivaikavata, qaqi kaimanta neqai vi kaiqara vare variavaro ni nutuvano noraiqiro vaivo. Ne vi kaiqara vareha hove tiataara vaimanta ne Kotira kaiqa vara amite vai vaiintira vira kaiqavata varareka auti variavo. ");
INSERT INTO tbg_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Kotiva Eronira noraiqama kairara ti, ne kia Eroniraravauve nuntu nauntu ti variavo. Ne Nora Kotirarama nuntu nauntu ti variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Minti tivakero Mosiva Eliaapira maaqutanta Dataaniravata, Abiraamuravata, naaromanta vitanta aqao ti, Kia tetanta virerave. ");
INSERT INTO tbg_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Are Isipini airi karavano koqemakero qampiqe vainaihaira tinavu tivita varera maini viri qumina aahara vataini kaaramantara ti, vira kaara tenavu maini vaiha qutuma virarave. Oho, are mintimakera tinavu qoraiqama timitaarava vaiharama qaiqaavata tinavuqaa raqikireva auti variaro. ");
INSERT INTO tbg_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Are tinavu tivita varera vo vata koqe vata vainaini vuru kaataarave. Tenavu airi naaho vateha uaini naahovata vataataara vaivara, are kia vo vata tinavu timira iaro. Are tinavu minta ireva auti variaro. Tetanta kia are inanaini virerave. ");
INSERT INTO tbg_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Vitanta minti tuvaro Mosiva vi uvara iruvaro vira voqama kero arara itovaro viva Nora Kotirara tiharo, Are vika ofaa kia varaane. Te vikaqaa raqikiha kia vikaqihai donki voqa muara vararaiti, kia te vikaqihai vaiinti vovata qoraiqama amitaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Minti tivakero Mosiva Koraara tiva amiro tiharo, Hura toqaqima are 250 vaiinti ai avataqi ni variaka ntita varera, Kotira Seri Naavu vainaini aniane. Are vika hampata aniraroma Eronivavata aniarire. ");
INSERT INTO tbg_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ne ekaa vohaiqa vohaiqavano iha vate tanuraqi koqe munta iainara viraqi vate, vare oru ofaa tainta tataaqa variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Mosiva minti tumanta toqaqi vika ekaa nai tanu nai tanu vare, viraqi iha aurivata koqe munta iainaravata vate, vare oru Mosika Eronika hampata Kotira Seri Naavu qentiqaa himpite vaura. ");
INSERT INTO tbg_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Vika vauvaro Koraava ekaa vaiinti nahentivata ruvaaquma komanta vika Kotira Seri Naavu qenti kanta vaiha Mosika Eronika taveha vaumanta vitantavata Kotira Seri Naavu qentiana himpite vaura. Mintimake ruvaaqumavi vauvaro vate virave tiro vaakama Noravano Kotiva viraqi vau ovava, voqama kero takuqi vau ovava ite vaumanta ekaa vaiinti nahenti ruvaaqumavi vauka vira tavora. ");
INSERT INTO tbg_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Vika tave vauvaro Noravano Kotiva Mosika Eronikara tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Netanta vaiinti nahenti ke qaqini viniqe te ekaa vika vehi autu taiqa kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Minti tumanta Mosika Eronika vaakama vataini hiqintivi náitanta viri vataini vate tiha, Mpo Kotio, areqaima Variqavano ekaa vaiinti nahenti maraquraqaa raqiki variaravama variaro. Vohaiqavano qora kaiqa vara kaira kaarae are ekaa vaiinti nahentiara arara itaaro? ti. ");
INSERT INTO tbg_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Vitanta minti tuvaro Noravano Kotiva Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Are ekaa vaiinti nahenti tiva nimiramanta vika Koraara Dataanira Abiraamura vinavuka seri naavu ke niaranto orini variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Kotiva minti tuvaro Mosiva himpiro Dataanika Abiraamuka vaunaini vumanta Isareri qiata vaiintinavu vira avataqi vuvaro ");
INSERT INTO tbg_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mosiva vinavuka vaunaini oruntero ekaa vaiinti nahenti tiva nimiro tiharo, Maa vaiintinavuka qora vaiintinavu seri naavuqaahai niara kanta ori vaiqi variate. Mini vaiha ne kiama vinavuka i haikara vo haikavata utu varaate. Hauri nevata vika aumanto vaiha vika qora kaiqa kaara qutivorave, ");
INSERT INTO tbg_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","tumanta vaiinti nahenti vi uvara iri, Koraara Dataanira Abiraamura vika seri naavu mini ke vumanta, Dataanika Abiraamuka náitanta seri naavuqihai vevante qentiana tuvu náitanta vainti nahentiaravata himpite vaura. ");
INSERT INTO tbg_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mintimake vauvaro Mosiva vaiinti nahenti tiva nimiro tiharo, Kia te tenta hantuqaqaa niqaa raqikiha vi kaiqara vi kaiqara vare vaunaravauve. Noravano Kotiva ti kaama tero ti tititaimanta te niqaa raqikiha vi kaiqara vi kaiqara vare vaunarave. Ne vaiha vo haika qovaraiqiainara tave, viraqaahai ne kankomake Noravano ti kaama tairara irivarave. ");
INSERT INTO tbg_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ho tavaate. Kotiva kia maa vaiintinavuka ntaihama karaitiro, vinavuka qaqi kairamanta variqi vi qako naampaiqamavi qutu vivera, ne tiriara ho tiha, Kotiva kia vira kaama tero atitaivave, tivarave. ");
INSERT INTO tbg_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ho Noravano Kotiva ni vo qara i haikara numiqairaro vatavano qantuara viramanta maa vaiintinavuka qaqi variaka nái ia haikara hampata qutu vuaka varianaini vivera, ne vinavuka Kotira qoririma amiterara kankomake irivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mosiva uva tiva taiqa kovaro vaakama vatavano Dataanika Abiraamuka vauraqaa qantua viro nora no autiro vaura. ");
INSERT INTO tbg_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Vatavano mintima kero qantuara vuvaro Dataanika Abiraamuka náitanta vainti nahentiaravata, ekaa Koraara vainti nahentivata, ekaa nái u haikara hampata vataqi otiqetovaro vatavano vika aqu ravaaqavu kora. ");
INSERT INTO tbg_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Vika qaqi vauka vaiha mintimake nái u haikara hampata qutu vuaka varianaini vuvaro vatavano vika aqu ravaaqavu komanta vaiinti nahenti kia qaiqaavata vika tavora. ");
INSERT INTO tbg_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Vika vataqi otiqeteha voqamake keke ti vaumanta ekaa Isareri vika aaqanto vauka tiha, Oho, kantama vuate. Hauri vatavano tinavuvata ravaaqavu kaantorave, tivake kantama vura. ");
INSERT INTO tbg_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Vika kantama vuvaro Noravano Kotiva naaruvaihairo iha vara kovaro tuvuntero 250 vaiintinavu koqe munta ura iha quare vauka tatoqa taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ihavano vika tatoqa kovaro Noravano Kotiva Mosirara tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Are Eronira maaqu Eleasaava ti kaiqa vara timite vai vaiintirara tiraro viva oru ihavano tatoqa kai vaiintinavuka ia tanura, ekaa vi tanura varakero ori vaiqiro tanuqi vai iha aurira aqu aquma kaarire. Vi tanunavuka kia qumina tanu vairaiti, ti Nora Kotika kaiqara iriha kaamataa tanukama variarave. ");
INSERT INTO tbg_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Vi tanunavura vare koqe munta i murara autireka ti ofaa tainta tataaqa oru varia tanuva vairave. Tanunavu varake hamaqohai ruqutu kakanairimake vuru ti ofaa taintaqaa aqu taatau taate. Nái qora kaiqa varaara kaara qutu vua vaiintika tanunavuqohai mintimanta Isareri vika ti tainta vira taveha, vikavata kia vohaa qaramake vinavuka qora kaiqa varentemake varaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Kotiva Mosirara minti tuvaro Mosiva Kotira kaiqa vara amite vau vaiintira Eleasaara tiva amuvaro Eleasaava vi tanunavura varero vuru komanta vi tanura ruqutu kakanairima kovaro Eleasaava viraqohairo ofaa taintaqaa aqu taatau tora. ");
INSERT INTO tbg_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Tainta viraqaa aqu taatautora taveha Isareri vika tiha, Hauri qumina vaiintivano kia Eronira ankuqihainaava koqe munta i murara iha quarareva Nora Kotira ofaa tainta tataaqa vuantorave. Qumina vaiintivano mintirera, Noravano Kotiva Koraaravata vira avataqi ni vaukavata qoraiqama nimitaintema kero, vi vaiintiravata qoraiqama amitaanarove, tura. Isareri mintiate tiro, Noravano Kotiva Mosira tiva amuvaro Eleasaava ekaa haika Noravano tuntema kero autu kora. ");
INSERT INTO tbg_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Vira qararaa ekaa vaiinti nahenti Mosika Eronikara nuntu nauntu tiha vitantara mintima ti: Netanta mintihama Kotira vaiinti nahenti hini kiaka arukaavo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Vika minti tivake ruvaaqumavi vaiha Mosika Eronika nitiha tuqantaavi tavovaro Kotira Seri Naavu vaunaini vate virave tiro vaakama quromuravano Kotira Seri Naavu naavuma kovaro Noravano Kotiva viraqi vau ovava, voqama kero takuqi vau ovava qovarama viro ite vaura. ");
INSERT INTO tbg_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ite vaumanta Mosika Eronika oru naavu vira qentiana himpite vauvaro ");
INSERT INTO tbg_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Noravano Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Netanta vinuate. Netanta vi vaiintika ke niaranto ori vaiqi vaiqe te vika vehi autu taiqa kaare, tiro. Minti tumanta vitanta vi uvara iri vataini hiqintivi náitanta viri vataini vate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mosiva Eronirara tiharo, Mpo, nena iha quare variana tanuravata, koqe munta iaina haikaravata varera, oru ofaa taintaqaahaira iha auri varakera tanu viraqi vatera, kantera vaiinti nahenti vainaini oruntera, vikara irihara Kotira iha quara amitairaro viva vika qora kaiqa vare uvara nunka nimitaarire. Nora Kotira voqama kero vikara arara itaivaro viva qora rovara vara kaivaro vika qoraiqama nimite vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Mosiva minti tuvaro Eroniva Mosiva tunte iro, viraqi iha quarato tanura varero kantero vi vaiinti nahentika ruvaaqumavi vaunaini vika nivutaini oruntero tavovaro qora rovaravano vikaqaa vaaka qovarama vura. Mintuvaro Kotiva vika qora kaiqa vare uvara nunka nimitaarire tiro, Eroniva koqe munta u haikara iha auriqaa aqu aquma kovaro muravano oru vura. ");
INSERT INTO tbg_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Mosiva tuntemakero Eroniva vaiinti nahenti vaaka qutu vukavata qaqi vaukavata nivutana himpi vauvaro vi rovarava taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Tota Koraara hampata airi vaiinti nahenti qutu vuvaro viraqaahairo vi rovarava Isareri vikaqi qovaramaviro 14,700 vaiinti nahenti aru kora. ");
INSERT INTO tbg_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ho Eroniva vaiinti nahenti nivutaini vauvaro vi rovarava taiqa vuvaro viva orurantero Mosiva Kotira Seri Naavu qentiana vaunaini anura. ");
INSERT INTO tbg_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Noravano Kotiva Mosirara tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","3","Are Isareri tiva nimiramanta vika kauru 12navu ai amiate. Vohaa anku vohaa anku qiata vaiintiqihaira kauru vohaiqa vohaiqa varera, vika nutu kauru viraqaa qara ntuva tera, Rivaira ankuqiraa kauruqaa Eronira autu qara ntuva taane. ");
INSERT INTO tbg_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Viraqaahaira vi kaurunavura varera, ti Kotika Seri Naavuqi oriqetera ti Vokisevano vainaini, te ni hampata mini vaiha uva ti vaunanaini vuru vataane. ");
INSERT INTO tbg_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mintiakera kauru vinavura vatairaro te kaama tauna vaiintira kauruqaahairo maumau/aimau arakero qampiqaainara vika tavaate. Vika tave, viraqaahai te vi vaiintira kaama taunarara kankomake iri tavevarave. Isareri vo enta vo enta ariara nuntu nauntu ti vai uvara te mintimake taiqa karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Kotiva minti tuvaro Mosiva vi uvara Isareri tiva nimumanta vika 12 ankuqihai qiata vaiinti vohaiqa vohaiqavano nái kauru vare, Eronira autu vato kaururavata vare, viri Mosira amuvaro ");
INSERT INTO tbg_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","viva kauru vinavura varero Kotira Seri Naavuqi vira Vokise tataaqa vuru vatora. ");
INSERT INTO tbg_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ho vira qararaa Mosiva Kotira Seri Naavuqi oriqetero tavovaro Rivaira ankuara iriharo amu kauruva, Eronira autu vau kaururaqaa maumau/aimau aratero amoni katari tava iratero mpeqaiqiro vaura. ");
INSERT INTO tbg_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ho mintuvaro Mosiva Kotira Seri Naavuqihairo ekaa kauru varero vahaaqaini muntu Isareri numiqomanta vika tavora. Tavama komanta qiata vaiinti vika ani nai kauru nai kauru varora. ");
INSERT INTO tbg_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ani varovaro Noravano Kotiva Mosirara tiharo, Eronira autu vaina kaurura qaiqaa varera vuru ti Seri Naavuqi ti Vokise tataaqa vataane. Mintiakera vatairamanta ti uva raqe vaika vi kaururara iriha tiha, Hauri tenavu qaiqaa nuntu nauntu tivaqi vuariraro Kotiva tinavu aru kaantorave, tivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Noravano Kotiva minti tuvaro Mosiva viva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Isareri Mosirara tiha, Oho, tenavu ekaa qutuma virarave. Tenavu ekaa taiqa vuariraukama vauro. ");
INSERT INTO tbg_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Vaiinti vovano Kotira Seri Naavu tataaqa oru virera, Kotiva vira aruma kaanarove. Mpo, Kotiva tinavu ekaae arukaanarove? ti vaura. ");
INSERT INTO tbg_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Avuhainaa toraqaa Isareri vaiinti nahenti qumina aahara vata Seni Vata Kadesini oru vaura. Mini vauvaro ˻Mosika Eronika nakaava˼ Miriaamiva qutu vumanta quntama tora. ");
INSERT INTO tbg_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Vi vataraqaa kia namarivata vaumanta vira kaara vaiinti nahenti Mosika Eronika vaunaini oru ruvaaqumavi vaiha ");
INSERT INTO tbg_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","vitantara nuntu nauntu tiha Mosira atiha tiha, Mpo, koqemama Kotira Seri Naavu tataaqa tentanavu navunaaka hampata tenavu qutu vuataarave. ");
INSERT INTO tbg_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nana kaarae netanta tinavu tivita vare qumina aahara vataini viri kaavo? Tenavu tentanavu quara vairi hampata maini qutu vuate tie, netanta tinavu tivita vare aniavo? ");
INSERT INTO tbg_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Netanta nantihae Isipihai tinavu tivita vare qora vata maini tenavu kia ho karavata utuke naainanaini viri kaavo? Kia maini uitivata koqe katari tavavata vaivaro, kia uainivata pomigranetivata vaivo. Mpo, tenavu namarivata naarirava kiama vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Vika minti tumanta Mosika Eronika vi uvara iri, vaiinti nahenti mini ke, oru Kotira Seri Naavu qentiana vaiha, vataini hiqintivi náitanta viri vataini vate vaura. Vitanta mintimake vauvaro Noravano Kotiva viraqi vau ovava, voqama kero takuqi vauva qovarama viro ite vaura. ");
INSERT INTO tbg_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Noravano Kotiva Mosirara tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Oru ti Vokise tataaqa vai kaurura varera, arevata Eronivavata ekaa vaiinti nahenti vohaaraqaa ruvaaquma kera, vika nivuqaa vaihara nora ori vitini vairara uva tiraro namarivano viraqihairo tuvuarire. Are mintima kairaro vi oriraqihairo namari aquvi aquvi iharo tuviramanta vaiinti nahentivata vika purumakauvata sipisipivata vo quaravata vi namarira naate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Noravano minti tuvaro Mosiva viva tunte iro oru vi kaurura varora. ");
INSERT INTO tbg_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mosika Eronika ekaa vaiinti nahenti vi orira tataaqa ruvaaqumake, Mosiva vaiinti nahenti nitiharo tiharo, Ne Kotira qoririma amite variaka, iriate. Tetanta maa oriraqihaie namari ni kaqa nimiainarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Minti tivakero ˻Mosiva kiama Kotiva tunte iro ori virara uva tiraitiro˼, viva nai kauru tuahera kero taara tataama kauruqohairo vi orira ruqutiro. Ruqutu kovaro ori viraqihairo nora namari aquvi aquvi iharo tuvimanta ekaa vaiinti nahentivata, ekaa purumakauve sipisipive vo quarave vika vika, vi namarira nora. ");
INSERT INTO tbg_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mintuvaro Noravano Kotiva Mosika Eronika nitiharo tiharo, Vate maa entara netanta kia tiriara kempukaiqamake iriraiti, netanta Isareri vaiinti nahenti nivuqaa vaiha kia ti hutu tuaherakeha, ti mpeqa okara takuqi vaira vika numiqaavo. Netanta mintiara kaara kia netanta te nimirera tuna vataraqaa Isareri ntita vare vivarave, tiro. Kotiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Isareri vi namarira autu nteha, Meribave – Nuntu Naunturave tura. Vika mini vaiha Kotirara nuntu nauntu tuvaro Noravano Kotiva nai takuqiro vai okarara vika numiqora. ");
INSERT INTO tbg_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Isareri Kadesini vau entara Mosiva vaiinti vonavu nititomanta vinavuka Mosira uva vare Idomuni avuhainaa vaiintivano vaunaini vura. Mosiva mintima tiro: Tenavu Isareri ai navunaakama maa uvara qara ntuva tauro. Airi maaravano tinavuqi qovaraiqimanta ani vaunarara are irianarave. ");
INSERT INTO tbg_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Haaru tinavu naaqukavara katu vare Isipini otu airi ihiara mini vaurave. Mini vaumanta vi entara Isipi vika tinavu naaqukavata, tinavuvata qoraiqama timite vaurave. ");
INSERT INTO tbg_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Mintumanta tenavu Nora Kotirara tinavu kahaqiane tiavauraro viva tenavu vira aarauna uvara iriro enseli vo varakovaro viva tuvuntero tinavu Isipiqihairo tivita varero viri kaimanta vate tenavu Kadesi maini vauro. Vi vatava ai vata auvahini vaivo. ");
INSERT INTO tbg_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tenavu ai ireha tiha, Hoe are tinavu qaqi kairaqe tenavu ai vata tavaarana vitare vuare? Tenavu tentanavu purumakau hampata kiama ni uiti naahoqive, uaini naahoqive, aiqu ntavaqi viraiti, ne namariara quvitaaraqi kia kaqake naraiti, tenavu qaqi nora aaraqaa avata vare vitare virarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mosiva minti tivakero uva vara komanta Idomu vika nai tiva ami tiha, Aqao, ne kia tinavu vataqaa ho aitarevarave. Ne kia tinavu uva iriraiti anivera, tenavu ni hampata raquainarave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Tumanta Isareri vika nái tiva nimi tiha, Tenavu nora aaraqai avata vare virerave. Tenavu tentanavu quara vairi hampata ni namari naarera, tenavu ni koqaa nimirarave. Tenavu ni vataqaa qaqi vitare vuairava, vivaqaima vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Isareri mintimake Idomu iromanta vika qaiqaa qaqiqai kempukaiqaake tiha, Ne kia ho tinavu vataqaa aitare vivarave, tivake nái iqoka vaiinti airitahaa ntita vare Isareri hampata raqirera anura. ");
INSERT INTO tbg_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Idomu nái vataini Isareri qioqama tomantara ti, Isareri qaqirake vo aaraqaa rante vura. ");
INSERT INTO tbg_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ekaa Isareri Kadesi mini ke vivi ");
INSERT INTO tbg_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Horu Aiqinaqaa Idomu vata auvahini oruntovaro Noravano Kotiva Mosika Eronikara tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Netanta Meribaini vaiha ti uva raqakaara kaara Eroniva kiama ho te Isareri nimirera tuna vataraqaa viraitiro, viva qutuma vuanarove. ");
INSERT INTO tbg_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Mosio, are Eroniravata vira maaqu Eleasaaravata ntita varera Horu Aiqinaqaa vuane. ");
INSERT INTO tbg_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Vitanta mini vuru kerama Eroniva ti Kotika Naavuqi kaiqa vareharo nonkutai utavaaqara viqu kerama, vira maaqu Eleasaarama nonku amitaane. Eroniva vi aiqinaraqaama qutu vuanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Minti tuvaro Mosiva Noravano tunte iro Eronika Eleasaaka ntita varomanta ekaa Isareri tave vaumanta vinavuka aiqinaqaa vurama. ");
INSERT INTO tbg_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mosiva Eroniva Kotira kaiqa vara amiteharo nonkuto utavaaqara viraqaahairo viqukero, vira maaqu Eleasaara nonku amitovaro Eroniva aiqina viraqaa vaiharo qutu vura. Qutu vumanta Mosika Eleasaaka ˻vira quntama te˼, aiqina ke tuvura. ");
INSERT INTO tbg_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Tuvunte vitanta ekaa vaiinti nahenti tiva nimi tiha, Eroniva qutuma vivo, tumanta ekaa vaiinti nahenti vika virara iriha 30 entanavuara vaiha iqi rata amitora. ");
INSERT INTO tbg_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Vi entara Kenaani vatanaaka avuhainaa vaiinti vovano viva Araati vatuka Nekevini vaiharo irumanta Isareri Atarimi aaraqaa ani vaura. Mintimake ani vauvaro avuhainaa vaiinti viva iriro nai iqoka vaiintivata ntita varero otu Isareri hampata raquqi viharo Isareri vokuka ravaaqavu varero vura. ");
INSERT INTO tbg_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Mintumanta viraqaahai Isareri nái kauqu aiqiqaa aqukeha Nora Kotirara tiha, Are tinavu qaqi kairaqe tenavu vi vaiintika naatara kaarera, tenavu kia vika vatukanavuqihai vo haikavata vararaiti, ekaa vi vatukara vehi autu taiqa karerave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Vika minti tuvaro Noravano Kotiva vika uva iriro Isareri vika kahaqumanta vika Kenaani vatanaaka hampata raquqi viha vika naatara kora. Isareri Kenaani vatanaakavata, vika vatukavata ekaa vehi autu taiqa korara ti, vi vatara autu nteha Homaave – Vehi autu taiqa korave tura. ");
INSERT INTO tbg_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isareri Horu Aiqina mini ke, Idomuni vuarorave tivake vika vo aara, Naare Namarini vira inaara autu Akapa Namarini vu aararaqaa rante vura. Vika vi aararaqaa vi vauvaro voqama kero popohora. ");
INSERT INTO tbg_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Vika nuntu nauntu tiha Kotika Mosika nitiha tiha, Nana kaarae netanta tinavu Isipiqihai tivita vare, maini aahara vataini viri kaavo? Tenavu maini vaiha qutuma virarave. Karavata namarivata kia maini vaivo. Vo kara timi varianara virara tinavu voqamakero popohaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Isareri vika minti ti vauvaro Noravano vika nuntu nauntu ti vau uvara iriro, vira kaara quqahi/quaiha varakomanta vika vaiinti nahenti nkaqe vaumanta airitahaa qutu vura. ");
INSERT INTO tbg_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Mintumanta vaiinti nahenti Mosiva unaini aninte virara tiha, Mpo, tenavu Nora Kotiravata aivata qora uva tiva nimitauro. Are Kotira aarairaro viva quqahi/quaiha vika tinavuqihairo vara kaarire, tuvaro ho Mosiva vaiinti nahentiara iriharo Kotira aarora. ");
INSERT INTO tbg_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mintuvaro Noravano Kotiva Mosirara tiharo, Are quqahi/quaiha maraqura/varaha vo autu kera, katari aratera viraqaa vira hiritaane. Tau vaiinti nahentikae quqahivano/quaihavano nkaqa tairauka vira maraqura vuruvi tavaivera, vika kia qutiraiti, qaqi vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Kotiva minti tuvaro ho Mosiva quqahi/quaiha maraqura baraasi oriqohairo autu kero, katariqaa hiritero. Mintiakero hiritomanta quqahivano/quaihavano nkaqato vaiinti nahentika vuruvi vira maraqura taveha, vika kia qutiraiti, qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isareri vika Horu Aiqina ke, vivi, Obotini oru naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Obotini varike qaiqaa vihai katu vare oru haarua naavu nuqihi vaunaini Abarimini qaiqaa naavu maaqa kaqate vaura. Moapi vatavano vauvaro kuari avu uruntonaini Abarimivano aahara vataini vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Qaiqaa vika Abarimi ke, katu vare Sereti uqitaini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Qaiqaa vika Sereti ke, katu vare Aanoni Namari hini mantaraini aahara vataini naavu maaqa kaqate vaura. Vi vatava aahara vatavano viviro, Amo vatanaaka vata avutaini oruntora. Aanoni Namarivano o ntuvataantema kero, Moapi vatanaaka vata hini antuarero Amo vatanaaka vata hini antuarero vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Vo vuku vira autu, Noravano Kotiva raqurave tu vukuraqi mintima tiro: Wahepi vatukavano Sufaa vata mantaraini vaivaro uqita vatavanovata Aanoni Namarivanovata ");
INSERT INTO tbg_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","viviro vatuka vo Aruni oruntero, Moapi vata auvahinivata oruntairave, tura. ");
INSERT INTO tbg_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Qaiqaa Isareri vika mini ke, katu vare, oru vo vata, Namariara Quvitonainive tunaini vura. Isareri mini vauvaro Noravano Kotiva Mosirara tiharo, Vaiinti nahenti naarairamanta ani ruvaaqumavi vaiqe te vika namari nimiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tumanta vi entara Isareri maa ihira tiha: Ruvu namarivauvo, nena qovarama vira vuane. Qovarama viraqe tenavu vira taveha quaheha ihi tiare. ");
INSERT INTO tbg_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Qiata vaiintivata nora vaiintivata vi ruvu namarira quvitaarave. Qiata vaiinti kauruqohaivata, qaqi uruqi nua kaururaqohaivata quvitaarave. Kaiqenavu virara ihi tiare, tura. Qaiqaa Isareri aahara vata ke, katu vare Matanaini vura. ");
INSERT INTO tbg_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Qaiqaa vika Matana ke, katu vare Naharieri uqitaini otu vaura. Qaiqaa vika katu vare oru veraini Bamoti vataini vura. ");
INSERT INTO tbg_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Qaiqaa vika Bamoti ke, katu vare otu uqita vataini Moapi vata Pisiga Aiqina vaunaini vura. Pisiga Aiqinaqaahai vaiinti nahenti aahara vata maata vutu vuru taveva ho vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isareri mini vaiha uva varakovaro Amo vatanaaka avuhainaa vaiintivano Sihoniva inaini vura. Vika mintima ti: ");
INSERT INTO tbg_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Hoe are tinavu qaqi kairaqe tenavu ai vata tavaarana vitare vuare? Tenavu tentanavu purumakau hampata kiama ni uiti naahoqive, uaini naahoqive, aiqu ntavaqi viraiti, ne namariara quvitaaraqi kia kaqake naraiti, tenavu qaqi nora aaraqaa avata vare vitare virarave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Vika minti tuvaro King Sihoniva Isareri vikara tiharo, Ne kia ho mintivarave, tivakero viva nai iqoka vaiinti ruvaaquma kero ntita varero oru Jahasi vatukaini aahara vataini vaiharo Isareri hampata iqoka raqura. ");
INSERT INTO tbg_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Iqoka raqumanta Isareri vika kempukaiqamake raqiha airi Amo aru taiqa keha vika vatavata varora. Vika Amo vatanaaka vata varova vaireva, Aanoni Namariqaahairo hoqarama kero viviro vuru Jaboku Namari noti mantaraini vuru taiqora. Mini vo vatanaaka Amoni vatanaaka kempuka vatanaaka vaumantara ti, Isareri Amo vatanaaka vataqai vare, kia Amoni vataini vura. Amoni vata auvahini Amoni iqoka vaiinti airitahaa vaumanta Isareri kia mini vura. ");
INSERT INTO tbg_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ho Isareri Hesaboni vatuka vare, hini vatukanavu vira tataaqa vauravata vare, ekaa Amo vatukavata vare, vi vatukara vi vatukaraqi oru vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Amohainaa King Sihoniva Hesaboni vatukaqi vaura. Haaru Sihoniva Moapi avuhainaa vaiinti vontiro raqiharo vira aatarakero vira vata ekaa varora. Vi vatava viviro Aanoni Namarivano otu vunaini muntu taiqora. ");
INSERT INTO tbg_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Haaru Sihoniva mintimakero Moapi vatanaaka naatara korara ti, ihi ti vau vaiintika maa ihira tura: Ne Hesabonini vatukaqi ani vaiha qaiqaa vi vatukara autuate. Sihonira vatukavano haaru koqema kero vauntemake, vi vatukara qaiqaa autuate. ");
INSERT INTO tbg_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ihavano iteharo ukau itakontemake, haaru Sihonira iqoka vaiinti Hesaboni vatukaihai iqoka raquqi vivi, Aru vatuka Moapi vataini vaura vehi autu taiqake, verara Aanoni Namari aruvuni vaukavata aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moapi vaiinti nahentivauvo, niara oho tiva nimitauro. Una variqa Kemosira autu tuahere variaka, mpo, ni vehi autu taiqama kaavo. Ni una variqavano kia ni iqoka vaiinti kahaqiraitiro, viva ni navutaaka qaqi kaimanta vika ni iqoka vaiinti aru ntata kaarave. Ni una variqavano Amohainaa King Sihonira qaqi kaivaro viva ni nahentinavu ravaaqavu kairave. ");
INSERT INTO tbg_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mintiaveravata, vate tenavu vika naatarama kauro. Tenavu iqoka raquqi vivi, Hesaboni vatukavata Diboni vatukavata vehi autu taiqake, qaiqaa raquqi vivi, Medeba vatuka aumanto vai vatukara Nofainivata vehi autu taiqa kaunarave, ti. Minti tivake ihi tura. ");
INSERT INTO tbg_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ho Isareri vika Amo vatukanavu vare mini vaura. ");
INSERT INTO tbg_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mini vauvaro viraqaahairo Mosiva vaiinti vonavu Jase vatuka ampeqama keha tavaate tiro, vinavuka nititomanta oru tavora. Viraqaahai Isareri iqoka raqiha Jase vatuka vare, vira tataaqa vau vatukaravata varora. Vika mintiake vareha Amo vatanaaka vi vatukaraqi vauka aru ntata komanta vurama. ");
INSERT INTO tbg_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Viraqaahai Isareri tuqantaavi Basaani vataini vu aarara avata vare vura. Vika mini oruntovaro Basaanihainaa King Okuva nai iqoka vaiinti ntita varero tuvuntero Isareri hampata Edarei vatuka vaunaini raqura. ");
INSERT INTO tbg_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Noravano Kotiva Mosirara tiharo, Ne kia King Okura aatu qetaate. Te ni kahaqiari ne vira aatarake, vira vatavata varevarave. King Sihoniva Hesaboni vatukaqi vaiharo Amo vatanaakaqaa raqiki vaira qoraiqama amitaantemake, ne viravata vohaa qarama amitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Noravano Kotiva minti tumanta Isareri viva tuntemake, King Okuravata, ekaa vira maaqunavuvata, ekaa vira iqoka vaiintinavuvata aru taiqa kora. Aru taiqake viraqaahai Isareri vika vatavata varora. ");
INSERT INTO tbg_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isareri mini varike, vihai vika oru Moapi vataini vivi, Iotani Namari hini mantaraini uqita kanta vika naavu maaqa kaqate vaura. Vika uqita kanta vauvaro Ieriko vatukavano Iotani Namari hini mantaraini vuruniqama vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Isareri mini vauvaro Moapi avuhainaa vaiinti Sipora maaqu Balaakiva vaiharo Isareri Amo vatanaaka aru taiqa korara iriro, ");
INSERT INTO tbg_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","vivavata Moapi vatanaakavata tavomanta Isareri airitahaa vaumanta ekaa vika Isareri naatu voqamake qeteha vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ho vika qete vaiha Midiani vatanaaka nora vaiintinavu tiva nimi tiha, Oho, purumakau qoravano vaaka ukau nama taiqa kaintemake, vi vatanaaka tenavu vataaina haikara ekaa vara taiqama kevarave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Minti tuvaro King Balaakiva vaiinti vo, Balaamiva aniarire tiro, vaiinti vonavu viva unaini vara kora. Vi entara Beora maaqu Balaamiva nai maaqa Petorini Iufaretisi Namari tataaqa vaura. Balaakiva vaiintinavu vara keharo Balaamirara mintima tiate tiro: Mpo, vo vatanaaka Isipi ke, ekaa vata maata raapamake aniaka, vika vate tinavu aumanto vaiha tinavu vatavata varareka auti variavo. ");
INSERT INTO tbg_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Vika airitahaa variarara ti, tenavu kia ho vika naatara kararave. Mintimake variaverama te ai aarauro. Are maini anintera nena variqanavu naarairamanta vinavuka vi vatanaaka qoraiqama nimitaate. Are mintiraqe tenavu ho vika hampata raqiha vika naatarake tentanavu vataqaahai vika aru ntata kaari vuate. Te irunarave. Are vaiinti nahentiara vika kaimanta koqemake variate tiaramanta ai variqanavu vika koqema nimite variamanta variarave. Are tihara, Kaimanta vika qoraiqama vuate, tiaramanta ai variqanavu vika qoraiqama nimite variarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Balaakiva minti tumanta Moapihaivata Midianihaivata nora vaiintinavu vi uvara vare, Balaamiva unaini vura. Balaamiva Isareri qoraiqama nimitaaina uvara tiarire ti, vika vira koqaavata vare, viva unaini orunte King Balaakiva tu uvara vira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Vinavuka tiva amuvaro viva iriro, vinavukara tiharo, Ne entaqi ti naavuqi vaitaiqe te hura toqaqi Noravano Kotiva vonare tina uvara ni tiva nimiare, tumanta nora vaiinti vinavuka vira hampata mini vaitora. ");
INSERT INTO tbg_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ho entaqi Kotiva Balaamiva unaini tuvuntero vira irero tiharo, Tau vaiintikae ai hampata variavo? Vika nana haika varareka aniakae variavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Kotiva minti tuvaro Balaamiva Kotirara tiharo, Balaakiva Moapi avuhainaava vinavuka nititaimanta vinavuka viri ti mintima tiva timiavo: ");
INSERT INTO tbg_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Mpo, vo vatanaaka Isipi ke, ekaa vata maata raapamavi aniaka, vika vate tinavu aumanto vaiha tinavu vatavata varareka auti variavo. Are anira, nena variqanavu naarairamanta vinavuka vi vatanaaka qoraiqama nimitaate. Are mintiraqe tenavu vika hampata raqiha, vika naatarake tentanavu vataihai vika aru ntata kaari vuate tiavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Minti tuvaro Kotiva Balaamirara tiharo, Aqao, are kia vi vaiintinavuka hampata mini vuane. Te Isareri hampata vaiha vika koqema nimite vaunarara tira, are kia ti aarehara vika qoraiqama nimitaane tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Noravano Kotiva minti tuvaro Balaamiva toqaqi himpiro vuru Balaakiva nora vaiintinavu nititokara tiharo, Neqai anirante vuate. Noravano Kotiva ti qioqama taimantara ti, te kia ho ni hampata virarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Balaamiva minti tumanta vinavuka anirante Balaakiva unaini orunte vira tiva ami tiha, Tenavu Balaamirara tinavu hampata aniane turaro viva kia virerave tivakeroma mini vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Minti tuvaro Balaakiva qaiqaa qiata vaiinti airitahaa nora autu vatauka, avuni nititoka vika nutuvata naatara koka naarama ruvaaquma kero ");
INSERT INTO tbg_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","viva vika nititomanta vika Balaamiva unaini orunte tiha, Balaakiva ariara mintima tivo: Are te iainanaini aniane. Are kia qaqi kairaro vo haikavano ai ravaaqavu kaarire. ");
INSERT INTO tbg_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Are te iainanaini aniraqe te homa ai airi haika amiarirara, are tiriara minti minti iane tiraqe te are tinantema kema iainarave. Mpo, maini anintera nena variqanavu naarairamanta vinavuka maa vatanaaka qoraiqama nimitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaakiva minti tumanta vika vuru Balaamira tiva amuvaro Balaamiva vi uvara iriro, Balaakiva nitito vaiintinavuka tiva nimiro tiharo, Balaakiva nai avuhainaa naavuqi ekaa silvaa orive kori orive vataira ti timirera, te kiama ho Nora Kotira tenta Variqa uva, nora uvae, inaara uvae, raqa kararave. ");
INSERT INTO tbg_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mpo, tota vonavu untemake, nenavuvata vate entaqi ti naavuqi vaitaiqe te variariraro Noravano Kotiva tiriara vonare tirera, ni tiva nimiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Minti tumanta vika mini vaitovaro entaqi Kotiva Balaamiva unaini tuvuntero vira tiva amiro tiharo, Vi vaiintinavuka ai vitareka aniarara tira, are homa vika hampata vinarave. Are vika hampata virama, te ariara tiainantema iane. Kiama nena irikera vo haikavata autuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Noravano Kotiva Balaamirara minti tuvaro toqaqi Balaamiva himpiro nai donkiqaa tavuna vuqitero viraqaa vaarintero oquviro Moapihainaa qiata vaiintinavu hampata vurama. ");
INSERT INTO tbg_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balaamiva vura kaara Kotira arara itora. Balaamiva nai donkiqaa oquviro vumanta vira kaiqa vaiinti taaraqantavata vira hampata vuvaro Noravano Kotiva atito enseliva aaraqaa himpitero vaiharo aara kuvai kareva auti vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mintuvaro donkivano tavovaro enseli viva iqoka paipe tuatero aaraqaa himpitero vauvaro donkivano vira tavero aaraqaa vura qaqira kero ahakaqi vura. Mini vuvaro Balaamiva donkivano aaraqaa qaiqaa vuarire tiro, vira airi tataa ruquti vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mintiakero donki ruquti vauvaro donkivano qaiqaa aaraqaa vuvaro uaini naaho taaraqanta vauraqi aaravano vitanta avutana vuvaro aara auvahianta ori ohaavano hini hini vauvaro aaravano muaqeqiro vauvaro enseli viva qaiqaa himpitero viraqaa vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Donkivano enseli vira tavero, oritarare tiro, ohaa tataaqa viharo Balaamira aiqu oriqaa ratatiaqa kovaro vira kaara Balaamiva qaiqaa donki vira airi tataa ruquti vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Mintiakero donki ruqutuvaro enseli viva qaiqaa oru Balaamira avuni inaaraiqakaa ori vaiqiro anoma muaqeqama vaunaini himpitero aara kuvaitero vauvaro ");
INSERT INTO tbg_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","donkivano tavovaro viva kia vira vaaraqama amitaarira aarava vauvaro, donki viva aara viraqaa vaitatero vauvaro, Balaamira voqama kero arara itovaro viva nai kauruqohairo donki qaiqaa airi tataa ruqutura. ");
INSERT INTO tbg_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Vira ruquti vauvaro Noravano Kotiva donki vira kahaquvaro donkivano vaiintivano uva tintema kero, Balaamirara tiharo, Te ai nantima kaurarae are taaramo tataa vaihara, ti haruaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Donkivano minti tuvaro Balaamiva virara tiharo, Are ti varakera kia avu aato vai vaiintira voqaara autu timitaanara kaara te ai ruquti vauro. Te iqoka paipe vatauraitirio, ai aruma kauraitirio, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Balaamiva minti tuvaro donkivano vira tiva amiro tiharo, Te ai donkivano vaurara are ekaa enta tiqaa oquvira variqira anira maa entara anintaaro. Te vate autuna okarara haaruvata mintunarave, kiae mintunarave? tuvaro Balaamiva tiharo, Aqao, kia are haaru mintianarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Minti tuvaro Noravano Balaamira avu qantua kovaro viva tavovaro Noravano atito enseliva iqoka paipe totero aaraqaa himpitero vaura. Aaraqaa himpite vauvaro Balaamiva qetakero vaakama vata kanta hiqintiviro nai viri vatainiqama kero vaura. ");
INSERT INTO tbg_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mintimake vauvaro Noravano atito enseliva vira irero tiharo, Nana kaarae are nena donki taaramo tataa ruqutuaro? Are kia ˻Baraakiva inaini˼ vuataara vaivarama aniaro. Vira kaara te ai aara kuvaikarera anuraukave. ");
INSERT INTO tbg_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ai donkivano ti taveroma taaramo tataa te unanaihairo tuqantaaviro vivo. Ai donkivano kia mintitirio, te vira vehakuma amiteha ai aruma kauraitirio, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Noravano Kotiva atito enseliva minti tuvaro Balaamiva tiharo, Oho, te qora kaiqama vara kauro. Te kiama are ti aara kuvai timitaanara tavauro. Vate te mini vuainarara are kia quahairera, te homa maihai anirante vuainarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Balaamiva minti tuvaro enseli viva tiharo, Hove, are vika hampata vuane. Vika hampata viharama kiama are nena irikera vo uvavata tiraitira, te ai tiva amiaina uvara viraqaima tiva nimiane, tiro. Enselivano minti tuvaro ho Balaamiva Balaakira qiata vaiintinavu hampata vurama. ");
INSERT INTO tbg_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaamiva vinavuka hampata vuvaro Balaakiva Balaamiva anu uvara iriro, viva oru Aanoni Namari tataaqa Moapi vata auvahini vau vatukara mini Balaamira vita kareva vura. ");
INSERT INTO tbg_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaakiva Balaamira vita kero virara tiharo, Mpo, te avuni vaiinti varake ari oru vite aniate tunarave. Are nantivarae vi entara kia aniaro? Are tiriara kia ho airi monu airaira ti timianarove tirae mini variaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Tuvaro Balaamiva vira tiva amiro tiharo, Ho tavaane, te vate anima ntauro. Ho nana uva Kotiva ti tiva timinara, vi uvaraqai te ho ni tiva nimirerave. Kia te tenta irike vo uvavata ni tiva nimirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ho minti tivakero Balaamiva Balaakikantiro vatuka vo Husotini oru vauvaro ");
INSERT INTO tbg_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaakiva mini vaiharo purumakauvata sipisipivata arukero hini mati Balaamiravata qiata vaiinti vira hampata anukavata unta nimura. ");
INSERT INTO tbg_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ho vira qararaa vaaka toqaqi Balaakiva Balaamira vita varero vuruni Bamoti-Baali vatukaqaa vuru kovaro, Balaamiva mini vaiharo vuavu tavovaro Isareri naavu maaqa kaqake vau vatukava hini qoqaa vaura. ");
INSERT INTO tbg_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamiva mini vaiharo Balaakirara tiharo, Are maini ofaa tainta 7navu autu terama, purumakau qora 7navuvata, sipisipi qora 7navuvata, varera maini aniane, tuvaro ");
INSERT INTO tbg_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaakiva Balaamiva tunte ura. Vitanta purumakauvata sipisipivata vohaiqa vohaiqa vare, ekaa ofaa tainta vohaiqa vohaiqaqaa vateha iha quarora. ");
INSERT INTO tbg_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Vitanta mintiake ofaa iha quaratovaro Balaamiva Balaakirara tiharo, Are maini ihavano ekaa ita kaaina ofaara tataaqa himpira vairaqe te vuruni vuare. Te mini vuariraro Noravano te unanaini qovaraiqianarove, kiae qovaraqianarove? Viva tiriara vonare tiraqe te vi uvara ai tiva amirerave, tivakero aiqinaqaa vura. ");
INSERT INTO tbg_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mini oruntovaro Kotiva Balaamiva vaunaini tuvuntero vikantiro vauvaro Balaamiva Kotirara tiharo, Te ofaa tainta 7navu autuke vate, purumakau qora vo vare, sipisipi qora vo vare, ekaa vi taintaraqaa vatema iha quara tauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Minti tuvaro Noravano vi uvara iriro, Balaamira nai uva tiva amiro vira atitero tiharo, Are ururantera Balaakiva inaini otuntera vi uvara tiva amiane, tuvaro ");
INSERT INTO tbg_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","viva ururantero otu tavovaro Balaakiva qiata vaiinti Moapihainaaka hampata iha quara tovaro ekaa itavu ofaara tataaqa vaura. ");
INSERT INTO tbg_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Vinavuka mini vauvaro Balaamiva Kotiva vira tiva amu uvara vika muntu tiva nimiro tiharo, Moapi avuhainaa vaiinti Balaakiva Siriaihairo kuari avu uri aiqinaihairo ti tivita kaimanta te maini anuro. Viva tiriara tiharo, Are anira nena variqanavu naarairamanta vinavuka Isareri qoraiqama nimitaate, tivo. ");
INSERT INTO tbg_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Viva minti timanta te nantiakee minti tirarave? Kotiva kia vikara, Ne qoraiqama vuate tirara ti, nantiakee te Kotirara vika qoraiqama nimitaane tirarave? Te minti tiarorave. Noravano Kotiva kia vikaqaa qora uva vatairara ti, nantiakee te vi uvara tirarave? ");
INSERT INTO tbg_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Te nora ori qiataqaa vaiha vi vatanaaka viavi tave vauro. Te vururaqaahai vika viavi aitutiha tave vauro. Te tavauramanta vi vatanaaka náiqai nuntuvi vo kanta variavo. Vika nariara tiha, Kia tenavu qumina vo vatanaa vo vatanaaka voqaara vauraukavauve ti variarave. ");
INSERT INTO tbg_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Iekopira vaintivara nuqa voqaara airi variarara ti, kia tenavu ho vika kaara ntirarave. Ti qaqi kairaqe te Kotira vaiinti nahenti variqi vivi vuru qutintemake qutuare. Ti qaqi kairaqe te avuqavu ni varia vaiintika qutintemake, qutuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaakiva vi uvara iriro Balaamirara aqao tiro, Are nantivarae vi uvara tiaro? Are tiramanta ai variqanavu ti navutaaka qoraiqama nimitaate ti, te ai maini vite anurarama, are kia minti tiraitira, are vika koqema nimitena uvaraqai tiaro. ");
INSERT INTO tbg_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Viva minti tuvaro Balaamiva vira tiva amiro tiharo, Te mpoma turo. Kia te ho vo uva tiraiti, Noravano Kotiva ti tiva timina uvara, viraqai ho tirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaamiva minti tuvaro Balaakiva virara tiharo, Aniqetanta vona vuare. Mini oru vaihara are kia Isareri ekaa tavaraitira, hininavuqai ho tavenarave. Ho mini vaihara vikara qora uva tiva tairamanta vika qoraiqama vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Balaakiva minti tivakero Balaamira vita varero Pisiga Aiqinaini Sofimi uqita kantave tunaini vuru kero, mini ofaa tainta 7navu autukero purumakau qora vo, sipisipi qora vo, varakero ekaa vohaiqa vohaiqa vi taintanavuraqaa vatero iha quarora. ");
INSERT INTO tbg_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ho Balaakiva mintuvaro Balaamiva virara tiharo, Are ihavano ekaa ita kaaina ofaara tataaqa vairaqe te vutuni oru Kotira vataake variare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Balaamiva minti tivakero vuvaro Noravano Kotiva viva unaini tuvuntero vikantiro vaiharo Balaamira uva tiva amiro tiharo, Are ururantera Balaakiva inaini otuntera vi uvara tiva amiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Kotiva minti tuvaro Balaamiva ururantero otu tavovaro Balaakiva Moapihainaaka qiata vaiinti hampata iha quara tovaro ekaa itavu ofaara tataaqa vauvaro Balaamiva otuntovaro Balaakiva vira irero tiharo, Noravano Kotiva nana uvae ai tiva amivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Tuvaro Balaamiva maa uvarama tiro: Sipora maaqu Balaakio, te maa uvara tiainara iriane. ");
INSERT INTO tbg_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Kotiva kia tinavu vaiinti aanantero una ti vaivama vaivo. Viva kia tinavu aanantero vo avu aato utira qaqirakero vo avu aato uti vairave. Viva nai kauqu aiqiqaa aqukeharo te mintirerave tiva taira kia qaqira karaitiro, viva quqaa auti vairave. Viva te mintirerave ti uvava quqaa vi vau vairave. ");
INSERT INTO tbg_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Kotiva nai Isareri koqema nimite vaimantara ti, te Kotirara vika koqema nimitaane tiariravaqaima vaivo. Kia te vo uvaqohai Kotira uva ho nunka kararave. ");
INSERT INTO tbg_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Te tavauramanta naantiara Isareri vika koqemake vaivaro kia qora haikavanove, maara ntaaina haikavave, vika qoraiqama nimitevarave. Noravano Kotiva vika Variqavano vaiharo viva vika hampata vaimanta vika virara tiha, Viva tinavu avuhainaavama vaivo, ti variarave. ");
INSERT INTO tbg_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Kotiva vika Isipiqihairo ntita varero aniva, viva vika kempukaiqama kaimanta vika qaakau purumakauvano raqintemake, raqi variarave. ");
INSERT INTO tbg_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Vika navutaaka vo qara vo qara i uhirave, hikaaqave, Isareri autu nimitaivera, vi haikava kia ho Isareri qoraiqama nimitaanarove. Vo vatanaaka Isareriara mintima tivarave: Ike, Kotiva nora kaiqa vareharo vika kahaqama nimite vaivo, tivarave. ");
INSERT INTO tbg_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Isareri vika vaireka, kempuka raioni voqaara variarave. Raionivano auraara vaireva, viva aantauvahi naane arukero rapepaama kero naarevata mativata nero vira naantiara auraara vaintemake, Isareri nái navutaaka hampata raquqi viha vika aru taiqake ˻vira naantiara auraara vaivarave˼, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Minti tuvaro Balaakiva vi uvara iriro Balaamirara tiharo, Aqao, are Isareri qoraiqama nimitena uvara kia tiataa irera, kia vika koqema nimitena uvara tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Minti tuvaro Balaamiva nai tiva amiro tiharo, Te vaaka ai tiva amunarave. Noravano Kotiva ti tiva timinantemake, te vi uvaraqai tirarave. Kia te vo uvavata ho tirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ho Balaakiva Balaamira tiva amiro tiharo, Are aniraqe te ai vita vare vonaini vuare. Are mini vairaro Kotiva ai qaqi kairara are Isareriara qora uva tinarave kiae tinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Minti tiva kero Balaamira vita varero Peora Aiqina noraqaa vuru kora. Vi aiqinaraqaahai ekaa aahara vata maata ho taveva vaura. ");
INSERT INTO tbg_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ho Balaakiva vira vita varero mini vuvaro Balaamiva tiharo, Are maini iha quare taintara 7navu autu terama, purumakau qora 7navuvata, sipisipi qora 7navuvata, varera aniane, ");
INSERT INTO tbg_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","tuvaro Balaakiva Balaamiva tunte iro viva purumakau qora vo, sipisipi qora vo, varakero ekaa ofaa taintaqaa vohaiqa vohaiqa vatero iha quara tora. ");
INSERT INTO tbg_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaamiva tavovaro Noravano Kotiva Isareri koqema nimitaari rava vauvarora tiro, viva kia qaiqaa avuni untema kero, oru vure/quaha kaiqa vararaitiro, viva tuqantaaviro aahara vataini vuavu tavora. ");
INSERT INTO tbg_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Viva mini vuavu tavomanta Isareri vo anku vo anku nai seri naavu maaqa kaqate vauvaro viva mini vauvaro Kotira Maraquravano viraqaa tuvu ntovaro ");
INSERT INTO tbg_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","viva paropeti uva mintima tiro: Te Beora maaqu Balaamika maa uvara tirerave. Te naantiara qovaraiqiaina haikara tave vauraukama uva tirerave. ");
INSERT INTO tbg_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Kotiva uva ti vaimanta te vira uva iri vaurauka, te vira uva tirerave. Kotiva ekaa kempuka vataava, viva ti tairakaa vo haika humiqaivera te vi haikara tave, vataini hiqintivi vaiha vi haikara okara kankomake tavaunarave. ");
INSERT INTO tbg_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Te Isareri seri naavu maaqa kaqataara tavauraro nai koqe iro vairave. ");
INSERT INTO tbg_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Te tavauraro vika seri naavu maaqavano vaireva, vata raavuravano viviro niaraini otu vira voqaara vairave. Qaiqaa vika seri naavu maaqavano vaireva, vo naaho vo naahovano nora namari auvahianta vaira voqaara vairave. Qaiqaa vika naavu maaqavano vaireva, Noravano koqe katari alo katari ututaira voqaara vairave. Qaiqaa vika naavu maaqavano vaireva, sidaa katari naiqi naiqi namari auvahianta vaira voqaara vairave. ");
INSERT INTO tbg_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Airi aaquvano Isareri vataqaa ntiramanta vika vata koqeraqi nái kara utivarave. Isareri avuhainaa vaiinti vovano King Agaakira aatarakero nora vaiintivano vaiharo airi vaiinti nahentiqaa raqikianarove. ");
INSERT INTO tbg_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Kotiva vika Isipiqihairo ntita varero aniva, viva Isareri kempukaiqama kaimanta vika qaakau purumakauvano kempukaiqama kero raqintemake, vika iqoka raqiha nái navutaaka naatarake, vika veva huru kaavu rauhaantimake, vika vuhaarivata kinta kaantamake variarave. ");
INSERT INTO tbg_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Isareri kempukavano raioni voqaara vairave. Raionivano vaite vaivaro vaiintivano ti harukaantorave tiro kia vira vauraqama kaintemake, Isareri raioni vira voqaara variarave. Vovano Kotirara Isareri koqema nimitaane tirera, Kotiva naivata koqema amitaanarove. Vovano Kotirara Isareri qoraiqama nimitaane tirera, Kotiva naivata qoraiqama amitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaamiva minti tuvaro Balaakiva vi uvara iruvaro arara itovaro nai kauqutanta ruqutukero Balaamirara tiharo, Oho, te ariara anintera tiramanta ti navutaaka qoraiqama vuate ti, te ai aaraurara are anintera kia minti tiraitira, taaramo tataama nena Variqa aarehara vika koqema nimitaane tiaro. ");
INSERT INTO tbg_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ho vaaka nena maaqaini vuane. Avuni te kauqu aiqiqaa aqukeha airi monuvata airairavata ai amirera turaro ai Noravano ai aara tinta kaira kaara are kia ho vi haikara varenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Minti tuvaro Balaamiva vira nai tiva amiro tiharo, Ho iriane, Are ti tivitaate tira nititaana vaiintikara te vika minti tiva nimunarave: ");
INSERT INTO tbg_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Balaakiva ekaa nai naavuqi silvaa orive kori orive vataira ti timirera, te kiama ho Kotira uva raqake tenta irike vo haikavata autirarave. Te ekaa uva, Noravano tiane tina uvara viraqai tirerave, tunarave. Te minti tivake are nititaana vaiintika tiva nimunarave. ");
INSERT INTO tbg_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ho vate te tenta vaiinti nahenti vainaini anirante virerave. Are qaqi kairaqe te naantiara Isareri ai navunaaka qoraiqama nimite uvara ai tiva ami vuare, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balaamiva minti tivakero qaiqaa paropeti uva tiharo mintima tiro: Te Beora maaqu Balaamika maa uvara tirerave. Te naantiara qovaraiqiaina haikara tave vaurauka uva tirerave. ");
INSERT INTO tbg_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Kotiva uva ti vaimanta te vira uva iri vaurauka, te vira uva tirerave. Kotiva ekaa kempuka vataava, viva ti tairakaa vo haika humiqaivera te vi haikara tave, vataini hiqintivi vaiha vi haikara okara kankomake tavaunarave. ");
INSERT INTO tbg_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Te naantiara qovaraiqiaina haikara tavehama Isarerivata tave vauro. Te tavauraro opu vovano noraiqaakero itaintema kero, Isareriqihairo avuhainaa vaiinti vovano qovarama vuanarove. Vi vaiintiva Isareri avuhainaaka kauru tuateharo kempuka vaiintivano vaiharo oru Moapi tiri vuhaari rukavu kero, viraqaahairo oru Setira qiata vuhaari rukavu kaanarove. (Vi uvara vutuke tirera: Viva iqoka raquqi viharo Moapi vatanaakavata, Seti vatanaakavata naatara kaanarove.) ");
INSERT INTO tbg_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Viva nai navutaaka Idomu naatara kero vika vatavata varaanarove. Isareri qaqiqai vika aruqi vivi, ");
INSERT INTO tbg_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","naatara kaivaro kia voqavanovata qaqi varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaamiva minti tivakero viva taira tavontema kero, Amareki vatanaaka tavero, vikaravata paropeti uva tiharo mintima tiro: Ekaa vo vatanaa vo vatanaakaqihai Amareki vatanaaka avuni vaiha kempuka vatanaaka variarave. Ho naantiara vika ekaara vehi autuvi taiqama vivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balaamiva minti tivakero viva qaiqaa taira tavontema kero, Kini vatanaaka tavero, vikaravata paropeti uva tiharo mintima tiro: Memoravano aihaiqi vai oriraqaa naavu kaqakero vaintemake, ne Kini vatanaaka variamanta ni navutaaka kia ho ni ntaiheka variamanta variavo. ");
INSERT INTO tbg_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ne mintiake vaimantavata, naantiara Asiria vatanaaka ni Kini hampata raqiha, ni hini kika aru vehi autu taiqake, ni hini kika rumpa vare vo vataini vuru kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaamiva minti tivakero paropeti uva vo tiharo mintima tiro: Naantiara vevara noti mantaraini sipiqi ni varia vatanaaka ruvaaquma vivarave. ");
INSERT INTO tbg_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Vika ruvaaqumavi Saiparusihai airi sipiqi aninte, oru Asiriavata Ebevata hampata iqoka raqiha vika naatara kevarave. Vika naatarake vaimanta viraqaahai vo vatanaaka aninte vika náivata vehi autu taiqa kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaamiva ekaa vi uvara tiva taiqa kero, anirantero nai maaqaini vuvaro Balaakivavata nai maaqaini vurama. ");
INSERT INTO tbg_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isareri vatanaaka Sitimi Uqitaini naavu maaqa kaqate vaumanta Moapi vatanaa nahenti Isareri vaiinti naaromanta vika hoqaramake Moapi nahenti hampata hampi qaramaqi ni vaura. ");
INSERT INTO tbg_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Vi nahentika Isareri vaiinti naaromanta vika Moapi nái una variqa ofaa quahama nimite vaunaini oru vaiha, una variqa unta nimito karara neha vika quahama nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Isareri mintimake Moapi hampata vohaaraqi vaiha Peora Aiqinaqaa una variqa Baalira quahama amite vauvaro vira kaara Nora Kotira arara ite vaura. ");
INSERT INTO tbg_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Noravano Kotiva Mosirara tiharo, Ne ekaa Isareri nenta qiata vaiinti ˻hampi kaiqa varaaka˼ ntita vare viri vaiinti nahenti nivuqaa arukaate. Ne mintima kaivaro kia qaiqaavata vaiinti nahentiara ti tirara itaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Noravano minti tuvaro Mosiva Isareri nora vaiintiara mintima tiro: Ne vohaiqa vohaiqavano ekaa nenta ankuqihai Peora Aiqinaqaa Baalira quahama amiteka arukaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Minti tivakero Mosivavata vaiinti nahentivata Kotira seri naavu qentiana rate vaiha tavovaro Isareri vaiinti vovano Midianihainaa nahenti vo vita varero nai seri naavuqi oriqetora. ");
INSERT INTO tbg_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Vite oriqetovaro vaiinti vo Finiaasivavata vitanta tavora. Finiaasiva Eleasaara maaquvano vauvaro Eleasaava Kotira kaiqa vara amito vaiintira Eronira maaquvano vaura. Ho Finiaasiva vitanta tavero, vaiinti nahenti mini kero vaaka oru nai vaantaara varero ");
INSERT INTO tbg_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","9","vitanta avata varero seri naavuqi oriqetero vaantaara viraqohairo vitanta vaataqi aru tampama tovaro vaantaaravano vaiinti aru varero otu nahentivata aru ruqiakomanta vitanta qutu vura. Finiaasiva mintiakero vitanta aru kovaro qora rovaravano airi vaiinti nahenti ari vauva taiqa vura. Vi rovarava aruqiro viharo Isareri 24,000 arukora. ");
INSERT INTO tbg_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Finiaasiva vitanta aru kovaro Noravano Kotiva Mosirara tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Finiaasiva tiriara noraiqaakero iriharoma, una variqa autu tuahereva ni Isareriqi qovarama vuantorave tiro vitanta aru kaivarora tiro, ti tirara itaiva humpama vimanta te kia qaiqaa ni vehi autu taiqa karerave. ");
INSERT INTO tbg_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ho are Finiaasira mintima tiva amiane: Te vira hampata maateraiqamake variaina uvara tiva taariraro vi uvava ekaa entama varianarove. ");
INSERT INTO tbg_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Viva tiriara noraiqaakero iriharo una variqa autu tuahereva niqi qovarama vuantorave tiro vitanta arukairave. Viva mintima keharo te Isareri qora uva nunka nimitaaina aarara ti Kotika autu timi tairara ti, vivavata, vira naintivaravata ti Kotika kaiqa ekaa entama vara timitaqi vivarave, tiro. Kotiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isareri vaiintivano Midiani nahenti hampata vauvaro Finiaasiva aruko vaiintira autu Simirira. Simiriva Sarura maaquvano vauvaro Saruva qiata vaiinti Simionira vohaa ankuqiraava vaura. ");
INSERT INTO tbg_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Midiani vatanaa nahenti vira autu Kosibira. Vira qova Suriva Midiani anku vonavuqaa raqiki vauva vaura. ");
INSERT INTO tbg_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Noravano Kotiva Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","18","Midiani vatanaaka Peora Aiqinaqaa vaiha ni navutaiqiha niara una uva tiara kaaravata, Kosibira kaaravata, ne oru Midiani hampata iqoka raqiha vika aru vehi autu taiqa kaate. Peora Aiqinaqaa una variqanavu quahama nimitaara kaara te Isareri qora rovaraqohai ntaihauna entara, Finiaasiva Midiani nora vaiinti raavura Kosibira aru kaivo, tura. ");
INSERT INTO tbg_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Nora rovaravano Isareri ntaiho entava taiqovaro Noravano Kotiva Mosiravata, Eronira maaqu Eleasaaravata tiva nimiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Netanta ekaa Isareri vo anku vo anku ruvaaqumake vika ho iqoka raqi vaiintika 20 ihi varekave, vo ihivata varekave, vika nutu qara ntuva taate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Noravano Kotiva minti tumanta Mosika Eleasaaka viva tuntemake Iotani Namari vutu mantaraini Ieriko vauvaro Moapi uqita kanta vitanta vaiha ekaa mintima ihi varo vaiintika naarama komanta ruvaaquma vura... ");
INSERT INTO tbg_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ho Mosika Eleasaaka ekaa vi vaiintika nutu qara ntuva tovaro vika nutu vaireva, 601,730 nutu vaura... ");
INSERT INTO tbg_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Iotani Namari vutu mantaraini Ieriko vauvaro Moapi uqita kanta Mosika Eleasaaka vaiha vi vaiintika vo anku vo anku ruvaaqumake vika nutu vukuqi qara ntuvatora. ");
INSERT INTO tbg_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Haaru Mosika Eronika Sainai Aiqina auvoqi vaiha avuni hoqaramake Isareri vaiinti nutu vukuqi qara ntuva toka, ekaa vi vaiintika qutu vuvaro kia voqavanovata vi entara vika hampata qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Haaru Noravano Kotiva vika tiva nimiro tiharo, Ne ekaa aahara vataini variqi vi qutu vivarave tu uvava vaurara ti, vika ekaa qutu vumanta Jefunera maaqu Kalepivavata, Nunira maaqu Iosuaavavata, vitantaqai kia qutiraiti, qaqi vaura. (14:26-35) ");
INSERT INTO tbg_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Noravano Mosira tiva amiro tiharo, Are Abarimi Aiqinaqaa vaarintera te Isareri nimirera iaina vatara vuavu tavaane. ");
INSERT INTO tbg_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","14","Are tavama kera, vira naantiara are nina vakaava Eroniva qutintema kera qutinarave. Haaru Isareri aahara vata Senini vau entara, vika Meribaini nuntu nauntu ti vaumanta netanta vika nivuqaa vaiha kia ti hutu tuaherake ti mpeqa okara takuqi vaira vika numiqaanara kaara are vi vataraqaa kia viraitira, nina vakaava Eroniva qutintema kera qutinarave, tiro. Meriba ruvu namarivano Kadesini aahara vata Senini vaura. (20:1-13) ");
INSERT INTO tbg_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Noravano Kotiva minti tuvaro Mosiva tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Noravauvo, are Variqavano ekaa vaiinti nahenti maraquraqaa raqiki variaravama variaro. Mpo, are vo vaiinti noraiqama kairaro vi vaiintiva Isareriqaa raqikiarire. ");
INSERT INTO tbg_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Iqoka raqi entara vi vaiintiva vika ntita varero vi aniarire. Hauri sipisipi qova kia vaintemake, ai vaiinti nahenti hampi vaivorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","19","Mosiva minti tuvaro Noravano Mosirara tiharo, Nunira maaqu Iosuaava, viva homa ti kaiqa varaarira vaiintivama vaivo. Are vira vita varera vuru Eleasaava ti kaiqa vara timite vai vaiintivavata, ekaa Isarerivata, varianaini kera, vika nivuqaa vaihara nena kauqu vira qiataqaa vatera, vaiinti nahenti tiva nimira mintima tiane: Iosuaava ti vatuka varaariravama vaivo, tiane. ");
INSERT INTO tbg_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Minti tivakera are vaiinti nahenti nivuqaa vaihara nena varena kaiqara hini Iosuaara amira, vira noraiqama kairamanta ekaa vaiinti nahenti Iosuaava tina uvara iriha vira avataate. ");
INSERT INTO tbg_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Iosuaava ti hantuqa vaina okarara maantima kero irianarove: Iosuaava Eleasaava ti kaiqa vara timite vai vaiintiva vainanaini viraro Eleasaava Urimi Tumimi okara tave vaiva, viva vi haikaraqohairo ti hantuqa vaina okarara kankoma kero tavero, Iosuaara tiva amiraro viva iriarire. Iosuaava ni Isareriara minti minti iate tirama ne Isareri viva tintema iate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Noravano Kotiva minti tuvaro Mosiva Noravano tunte ura. Viva Iosuaara vita varero Eleasaava Kotira kaiqa vara amite vau vaiintivavata ekaa vaiinti nahentivata vaunaini vuru kovaro ");
INSERT INTO tbg_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Iosuaava vika nivuqaa himpitero vauvaro Mosiva nai kauqu Iosuaara qiataqaa vatero vaiinti nahenti Iosuaarara tiva nimiro tiharo, Maa vaiintiva ti vatuka varaarira vaiintivama vaivo, tiro. Mosiva Noravano tiva amuntema kero tura. ");
INSERT INTO tbg_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Noravano Kotiva Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Are Midiani vatanaaka ni Isareri qoraiqama nimitorara irihara vika nái qoraiqama nimitaane. Are vika qoraiqama nimitera viraqaahaira ho are qutu vinarave. ");
INSERT INTO tbg_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Kotiva minti tuvaro Mosiva Isareri tiva nimiro tiharo, Ne timanta niqihai iqoka vaiinti hini kiaka auvihehavaa vare oru Midiani hampata raqiha vika Nora Kotira qoraiqama amitorara irihama vika náivata qoraiqama nimitaate. ");
INSERT INTO tbg_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Ne Isareri 12 anku vohaiqa vohaiqaqihai 1,000 iqoka vaiinti kaamate vara kaimanta vika raqireka vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Mosiva minti tumanta Isareri vika nái anku vohaiqa vohaiqaqihai 1,000 iqoka vaiinti kaamaqi vivi, 12,000 iqoka vaiinti ntita vatovaro ");
INSERT INTO tbg_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mosiva vika iqoka raquate tiro nititora. Viva Kotira kaiqa vara amite vau vaiintira Eleasaara maaqu Finiaasira viravata atitovaro Finiaasiva vireva iharo Kotira Naavuqiraa haika vonavu varero, aanumaara/noma vonavuvata, iqoka vaiintiara mini vuate maini aniate tiro vuaqe vau aanumaarara, vinavuvata varero vura. ");
INSERT INTO tbg_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ho Noravano Kotiva Mosira tiva amuntemake, vika oru Midiani hampata raqiha Midiani vaiinti ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Vika raqiha Midiani avuhainaa vaiinti kauqurunavu Evirave, Rekemirave, Surirave, Hururave, Rebaarave, aruke, Beora maaqu Balaamiravata aru kora. ");
INSERT INTO tbg_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Aru taiqake Isareri Midiani vika nahentive, vaintive, ekaa purumakauve, sipisipive, vika ekaa koqe airaira vatorave, ");
INSERT INTO tbg_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","vi haikara vi haikara ekaa vare, viraqaahai Midiani vika naavu maaqavata vatukavata iha quara kora. ");
INSERT INTO tbg_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Mintiake vika nahentive, vaintive, purumakauve, sipisipive, ekaa vi haikara vi haikara vare ");
INSERT INTO tbg_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Mosika, Eleasaaka, Isareri hampata vaunaini vuru kora. Vi entara vika uqita kanta vauvaro Ieriko vatukavano Iotani Namari hini mantara vuruni vaura. ");
INSERT INTO tbg_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mosivavata Eleasaavavata ekaa Isareri nora vaiintinavuvata vatuka mini ke, oru nái iqoka vaiinti ntita kareka vumanta ");
INSERT INTO tbg_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","1,000 iqoka vaiintiqaave, 100 iqoka vaiintiqaave, raqiku opisaaka raqunaihai orurante anuvaro Mosiva vika nitura. ");
INSERT INTO tbg_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Viva vika nitiro tiharo, Ne nantihae nahenti kia arukaraiti, qaqi vika ntita vare aniavo? ");
INSERT INTO tbg_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ne kankomake iri tavaarave. Nahenti vikama Balaamira uva avate vaura kaara tinavu vaiinti nahenti Peoraini vau entara Nora Kotira qaqirake una variqa quahama amitovaro vira kaara qora rovaravano Kotira vaiinti nahentiqi qovarama vurave. ");
INSERT INTO tbg_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Virara irihama ne ekaa qorainti vaintivata, ekaa nahenti qorainti hampata vaitekavata, aru taiqa kaate. ");
INSERT INTO tbg_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mintiake aruke, ekaa nahenti kia qorainti hampata nika, vikama nenta varataate. ");
INSERT INTO tbg_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Ne vaiinti arukekave, qutu vuaka utu varekave, ne kia vatukaini viraiti, 7 entanavu aaqainima variate. Mini vaiha, taaramo entaqaavata, 7 entaqaavata, ne avu aato muntuka hiqe okarara iriha nentavata, ne iqokaqihai ntite ani nahentikavata, vi okarara avateha variate. Ne mintimake, ne Kotira avuqaa homa vaivarave. (19:11) ");
INSERT INTO tbg_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ne vi okarara avataivaro ne vate haikavavata Kotira avuqaa ho variarire. Ekaa ni utavaaqave, purumakau pahiqohai autu taarave, memeraa kaahiqohai autu taarave, katariqohai autu taarave, vi haikara vi haikara mintima keha hiqaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mosiva minti tuvaro Kotira Naavuqi kaiqa varo vaiintiva Eleasaava raquanaihai anu vaiintikara tiharo, Noravano Kotiva Mosirara tivato uvara ne avataqi vuate. Mintimama vaivo: ");
INSERT INTO tbg_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Ihavano kia ho ita kaainara, kori orive, silvaa orive, aini orive, baraasi orive, vo orive, vi orira vi orira ihaqi vataivaro ihavano qumina haika ori vataakero vainara ita kairaro orivanoqai variarire. Ekaa voki haikara ihavano ita kaantorave ti, namariqi quntama kaivaro hiqama vuarire. ");
INSERT INTO tbg_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ne mintiaqi viha 7 entaqaa nenta utavaaqa hiqamake, ne Kotira avuqaa ho hiqamavi vaika vaiha ho vatukaqi oriqetevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Eleasaava minti tuvaro qaiqaa Noravano Kotiva Mosira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Arevata, Eleasaavavata, vo anku vo anku qiata vaiintivata, nenavu vaiha iqokaqihai ntite aniaka, nahentive, vaintive, quara vairive, ekaa vika kaara ntuate. ");
INSERT INTO tbg_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Nenavu ekaa vi haikara rairake taaraqantaqaa vate, voqaahainaara iqoka vaiinti raqireka vuaka nimi, voqaahainaara maaqaini variaka nimiate. ");
INSERT INTO tbg_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Nenavu iqoka vaiinti nimiraqihai ti Nora Kotikara irihama takisi varaate. Nenavu 500 vainti nahenti rumpavare aniakaqihai vohaiqa ti timi, purumakaue, sipisipie, memeraae, donkie, 500 qihai vohaiqa vohaiqa varake, ti timitaate. ");
INSERT INTO tbg_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ho ne vi takisira Eleasaara amivaro viva ti Kotikara iriharo tuataarire. ");
INSERT INTO tbg_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Nenavu vaiinti nahenti maaqaini variaka nimireka iraqihaivata takisi varaate. Nenavu ekaa 50 vainti nahenti rumpa vare aniakaqihai vohaiqa vare, purumakaue, sipisipie, memeraae, donkie, 50 qihai vohaiqa vohaiqa varake, vira Rivaira anku ti seri naavuqaa raqikiaka nimiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Noravano Kotiva minti tumanta Mosika Eleasaaka viva Mosira tiva amuntemake, vi haikara rairakora. ");
INSERT INTO tbg_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Iqoka vaiinti nai navutaaka hampata raquraqihai vare anu haikava vaireva, maantimama vairo: Sipisipi 675,000 ");
INSERT INTO tbg_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","purumakau 72,000 ");
INSERT INTO tbg_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","donki 61,000 ");
INSERT INTO tbg_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","varaata kia vaiinti hampata vaitoka 32,000. ");
INSERT INTO tbg_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Vi haikara avutaqaa rairake, hini iqoka vaiinti iqoka raqireka vuka nimura: 337,500 sipisipi. ");
INSERT INTO tbg_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","(675 sipisipi Nora Kotira takisi amitora.) ");
INSERT INTO tbg_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 purumakau. (72 purumakau Nora Kotira takisi amitora.) ");
INSERT INTO tbg_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 donki. (61 donki Nora Kotira takisi amitora.) ");
INSERT INTO tbg_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 varaata. (32 varaatanavu Nora Kotira takisi amitora.) ");
INSERT INTO tbg_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mosiva vi haikara takisi amitora varakero Eleasaara Noravano tuntema kero amura. ");
INSERT INTO tbg_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","Mosiva iqoka vaiinti raira nimuntema kero, vaiinti nahentivata raira nimura. Vaiinti nahenti vika 337,500 sipisipi vare, 36,000 purumakau vare, 30,500 donki vare, 16,000 varaatanavu varora. ");
INSERT INTO tbg_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Mosiva vi haikara mintima kero rairakero ekaa 50 vainti nahenti rumpa vare anukaqihairo voqa vita varero, purumakau vo, sipisipi vo, donki vo, memeraa vo varero, Noravano Kotiva tunte iro, Rivaira anku Kotira seri naavuqaa raqiki vauka nimura. ");
INSERT INTO tbg_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Mintiakero nimumanta opisaa vaiinti 1,000 iqoka vaiintiqaave, 100 iqoka vaiintiqaa raqikukavata, Mosiva unaini orunte ");
INSERT INTO tbg_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","vira tiva ami tiha, Nora vaiintio, tenavu tentanavu iqoka vaiinti ekaa kaara ntuvake tavauramanta iqoka raqunaraqihairo kia voqavanovata qutu vivo. ");
INSERT INTO tbg_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Mintiverama tenavu kori oriqohai aututaa haikara, irarave kaatavave aatoqi vahehema/vaataiqama taarave auntaqi ruvutaarave, tenavu ekaa vi haikara vare anunara vira Kotira amitarerave. Noravano Kotiva kia navutaaka qaqi kaimanta tinavu qoraiqama timitaarara iriha, tenavu vi haikara vira amirerave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Opisaa vaiintinavu minti tumanta Mosika Eleasaaka kori oriqohai aututo haikara nimura varora. ");
INSERT INTO tbg_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Kori oriqohai aututo haikara vira maaravano vaireva, aumaqaa 200 kilo vaura. ");
INSERT INTO tbg_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Qaqi iqoka vaiinti vika iqoka raqiha vi haikara vi haikara varora kia Mosika Eleasaaka nimiraiti, qaqi nái tuatora. ");
INSERT INTO tbg_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Noravano Kotiva Isareriara iriharo vika kahaqiarire ti, Mosika Eleasaaka opisaa vaiintinavu nimu kori orira vare, Kotira Seri Naavuqi vuru vatora. ");
INSERT INTO tbg_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubenira ankuvata Gaatira ankuvata airi purumakau vatoka tavovaro Jase vatainivata Gileaati vatainivata purumakauvano ho naaina ukauva vaura. ");
INSERT INTO tbg_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Vi ukauva mini vaumanta vika Mosika Eleasaaka unainivata vaiinti nahenti qiata vaiinti unainivata orunte vikara tiha, ");
INSERT INTO tbg_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Nora vatuka Atarotive, Dibonive, Jaseve, Nimrave, Hesabonive, Elealeve, Sipimaave, Nebove, Beonive, ");
INSERT INTO tbg_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","vi vatukava vi vatukava mini vai vatara Noravano tinavu Isareri kahaqimanta varaunarave. Mini purumakau ne ukauva ho vaimanta tinavu purumakau airitahaama variavo. ");
INSERT INTO tbg_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ho nenavu tinavuara quahaivera, vi vatara tinavu timiqe tenavu vi vatara vare viraqaa variare. Ne tinavu tivita vare Iotani Namari hini mantaraini vuru kaiqe mini variainarara kia tinavu hantuqavano vaivo. Tinavu kia mini vuataa ivo, ti. ");
INSERT INTO tbg_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Vika minti tuvaro Mosiva Rubenira ankuaravata Gaatira ankuaravata tiharo, Hauri ne nenta kena Isareri kia kahaqiraiti, maini qaqi vaimanta vika vutu mantaraini oru vaiha iqoka raqivorave. ");
INSERT INTO tbg_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ne maini vaimanta hauri ni kena Isareri vika tinavu kempuka kia ho vaivo tivakeha mainiqai vaireka autiha, Iotani Namari vutu mantaraini Kotiva vi vatara vika nimireva tinaini kia vivorave. ");
INSERT INTO tbg_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Haaru ni qokavara minturave. Vi entara tenavu Kadesi-Baanea mini vaiha te vinavuka nititaura vinavuka vi vatara ampeqamake tavareka vurave. ");
INSERT INTO tbg_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Vinavuka vi vatara viti viri tavamaqi viha Esikori Uqitakanta orunte, vihai qaiqaa orurante aninte, nai kena Isareri qetara uva tiva nimumanta vira kaara vika tinavu kempuka kia ho vaivo tivakeha kia vi vatara Noravano Kotiva nimireva tunaini vurave. ");
INSERT INTO tbg_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Vika mintuvaro vi entara Kotira arara itovaro viva nai kauqu aiqiqaa aqukero tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Vi vaiintika ekaa 20 ihiqaahai voqavata varakaaka Isipi ke aniha, kia tiriara kempukaiqamake iriqi viraiti, ti qoririma kaara, vira kaara kia ho vikaqihairo voqavanovata te kauqu aiqiqaa aqukeha Eparahaamiravata Aisaakiravata Iekopiravata nimirera tuna vataraqaa oru vivarave. ");
INSERT INTO tbg_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Taaraqantaqaima vi vataraqaa ho vivarave. Kenaasira ankuqiraara Jefunera maaqu Kalepivavata, Nunira maaqu Iosuaavavata, vitantaqai kia ti Nora Kotika qoririma karaiti, tiriara kempukaiqamake iriqi vuarara ti, vitantaqaima mini vivarave, turave. ");
INSERT INTO tbg_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Mintiakero Noravano Kotiva vaiinti nahenti nitiharo vikara tiharo, Ne 40 ihiara qumina aahara vatainiqai nuvaqi vivi, vuru qutu vivarave, tumantara ti, ekaa vi entara vau vaiinti nahentika qora kaiqa vira varoka, qumina aahara vataini nuvaqi vivi, vuru qutu taiqa vurave. ");
INSERT INTO tbg_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Mintimake vika qutu vumanta vate ne nenta qokavara vatuka vare, ne vika vaintivara vaiha vohaa qaramake qora kaiqaqai vare variavaro vira kaara Nora Kotira anomakero arara ite vairave. ");
INSERT INTO tbg_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ne Rubenira ankuvata, Gaatira ankuvata, tuqantaavi kia Nora Kotira avataqi vivera, vira kaara viva tinavu Isareri ekaa qaiqaa qaqira kairaqe, tenavu qaiqaa qumina aahara vataini nuvaqi vivi, vuru qutu taiqama virarave. Tenavu mintimake qoraiqama vuarera, vira ni okara kaarama tenavu mintima virarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Mosiva minti tumanta vika vi uvara iri, vika Mosiva unaini orunte virara tiha, Hoe are tinavu qaqi kairaqe tenavu ohaa autuke sipisipi viraqi vate, tentanavu vatuka vaantaavuravata autu taari tinavu vainti nahenti viraqi koqemake variate? ");
INSERT INTO tbg_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Tenavu mintimake vira naantiara tenavu qerama vare tenavu naane tentanavu kena Isareri avuni viha navutaaka hampata raquqi viha vika naatarake, viraqaahai tentanavu kena Isareri ntita vare, vika nái vaireka i vataraqaa vuru kaare. Tenavu ekaa vatukanavu vaantaavura autuke vate, ekaa haika tumaara maaramake avutaqi vataari maihainauka kia tinavu vaiinti nahenti qoraiqama nimitaate. ");
INSERT INTO tbg_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Avuni tenavu tentanavu kena Isareri kahaqiari ekaa vika naane nái varare i vatara varaiqe, viraqaahai tenavu orurante tentanavu maaqaini anirerave. ");
INSERT INTO tbg_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Tenavu Iotani Namari maini kuari avu uruntainaini vata varaunarara ti, tenavu kia ho Iotani Namari hini mantaraini vaina vatara naarumake varaainarave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Vika minti tuvaro Mosiva vikara tiharo, Ne nenta tiantemake quqaa mintireka ivera, ho ne Nora Kotira avuqaa iqoka raqireka qeramate variate. ");
INSERT INTO tbg_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Ekaa ni iqoka vaiinti vika Nora Kotira vevaaraini vaiha, Iotani Namari taqa vare oru hini mantaraini navutaaka hampata raqivaro Noravano Kotiva vika naatara kaira navutaaka vata vira varaate. ");
INSERT INTO tbg_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Ne mintimake Noravano Kotiva kaiqa niminara taiqake, ne nenta kena Isareri kahaqama nimitevavata taiqa virera, viraqaahai ne homa orurante maini ani vaivaro kia niqaa uva varianarove. Ne mintivaro Noravano Kotiva Iotani Namari hini mantaraini kuari avu urunaini vai vatarara ninavu vatama vaivo tiarire. ");
INSERT INTO tbg_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Oho, te tiari iriate. Ne nenta kauqu aiqiqaa aqukeha tivate uvara kia avataqi vivera, vira kaara ne Nora Kotira uva raqakaivaro ne qora kaiqa vare uvava kia kukeqa viraitiro, qoqaama varianarove. ");
INSERT INTO tbg_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Ho ne vatukave vaantaavurave sipisipi ohaave autu kaate. Autuke viraqaahai nenta kauqu qaiqaa aqukeha raqirerave tivatera irihama raqireka vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Mosiva minti tumanta Gaatira ankuvata Rubenira ankuvata virara tiha, Nora vaiintivauvo, tenavu ai kaiqa vaiinti vaiha ai uvaqai avataqi virerave. ");
INSERT INTO tbg_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Tinavu nahentive vaintive, purumakauve, sipisipive, vika maini Gileaati vatukanavuqi vaiqe ");
INSERT INTO tbg_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ekaa tenavu vaiinti qerama vare, Nora Kotirara iriha oru raqirerave. Tenavu are tinantemake, Iotani Namari taqa vare oru navutaaka hampata raqirerave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Vika minti tuvaro Mosiva Kotira kaiqa vara amite vau vaiintira Eleasaaravata, Nunira maaqu Iosuaaravata, Isareri nora vaiinti vo anku vo ankuqaa raqikukavata, tiva nimiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Ne iriate. Gaatira ankuqiraa vaiintivata, Rubenira ankuqiraa vaiintivata, vika Kotirara iriha, auvihehavaa vare oru Iotani Namari taqa vare, ni kahaqiramanta ne navutaaka hampata raqiha vika naatarake vi vatara varaivera, ho ne Gileaati vata vika nimivaro vi vatava vikaini variarire. ");
INSERT INTO tbg_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ho vika kia ni hampata Iotani Namari taqa vare ni kahaqamake raqireka vivera, ho vika ni aanante Kenaani vataqaima varevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Mosiva minti tumanta Gaatira ankuvata Rubenira ankuvata nai tiva ami tiha, Hove, Noravano Kotiva tintemake tenavu mintirerave. ");
INSERT INTO tbg_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Tenavu Nora Kotirara iriha namari taqa vare Kenaani vataini oru vi vatanaaka hampata raqirerave. Tenavu iqoka raqu taiqake, viraqaahai tenavu Iotani Namari maa mantaraini vai vataraqaa ani vairerave, ti. ");
INSERT INTO tbg_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Vika minti tuvaro Mosiva ekaa Amo King Sihoriva u vataravata, Basaani King Okuva u vataravata, vi vatara aumanto vau vatukanavuravata, kaama tero, Gaatira ankuvata, Rubenira ankuvata, Manasera anku hininavuvata, vi vatara nimura. ");
INSERT INTO tbg_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Mintuvaro Gaatira ankuvano haaru ori vaantaavura vau vatukanavura qaiqaa autu kora. Vika maa vatukanavura qaiqaa autu kora: Diboni, Ataroti, Aroe, ");
INSERT INTO tbg_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Ataroti-Sofaani, Jase, Jokubeha, ");
INSERT INTO tbg_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beti-Nimura, Beti-Haraani. ");
INSERT INTO tbg_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubenira anku vika maa vatukanavura autu kora: Hesaboni, Eleale, Kiriataimi, ");
INSERT INTO tbg_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Sipimaa, Baali-Meoni. Vika Baali-Meoni vatuka vo autu ntava tora. Vika mintimake ekaa vatukanavu qaiqaa autuke, qaraaka autuvata ntava tora. ");
INSERT INTO tbg_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manasera maaqu Makira ankuvano Gileaati vataini oruntero Amo vatanaaka hampata raqiharo vika aru ntata komanta vinuvaro vi ankuva vi vataraqaa vaurara tiro, ");
INSERT INTO tbg_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mosiva Gileaati vata Makira anku amuvaro vi vatava vi ankura vata vaura. ");
INSERT INTO tbg_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Vaiinti vo Jairiva Manasera ankuqihainaava, viva nai navunaaka vokuka ntita varero oru vo vatukanavu hampata raqiharo vika naatara kero vi vatukanavura varero vinavura autu nteharo Jairura-Vatukanavuve tura. ");
INSERT INTO tbg_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Qaiqaa Nobaava nai navunaaka ntita varero oru Kenati vatukavata, vira tataaqa vau vatukanavuvata, raqiharo vinavura varero viva nai autuara iriharo Kenati vatuka vira autu nteharo Nobaa vatukave tura. ");
INSERT INTO tbg_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Mosika Eronika Isipi ke Isareri ntita vare qumina aahara vataini katu vare aniha voqi voqi naavu maaqa kaqateha vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mintuvaro Noravano Kotiva tuvaro Mosiva Isareri naavu maaqa kaqate vaura, vira autu vohaiqa vohaiqa vukuqi qara ntuvatora. Vi vatukanavura autu maantimama vairo: ");
INSERT INTO tbg_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","4","Haaru avuhainaa tora 15 entaqaa Isareri Isipiqihai katu vare Ramesesi mini ke anura. Noravano Kotiva Isareri vehakuma nimito entara vira qararaa Isipi vatanaaka nái qorainti vainti kara hunka qutu vuka qunte vaumanta Isareri kia Isipi naatu qetaraiti, vika nivuqaa qoqaa katu vare vi vaura. Noravano Kotiva mintiakero nai kempuka numiqeharo Isipi vika una variqa vara muntuviqama komanta ");
INSERT INTO tbg_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Isareri Ramesesi ke, vika katu vare Sukotini oru naavu maaqa kaqate vaura. (Katu Varora 12:37) ");
INSERT INTO tbg_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Qaiqaa vika Sukoti ke, katu vare aahara vata auvahini Etamini oru naavu maaqa kaqate vaura. (Katu Varora 13:20) ");
INSERT INTO tbg_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Qaiqaa vika Etami ke, vihai anirante Pi-Hahiroti vataini kuari avu uruntonaini Baali-Sefoni vata vira tataaqa Mikadoli vatuka aumanto oru naavu maaqa kaqate vaura. (Katu Varora 14:2) ");
INSERT INTO tbg_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Qaiqaa vika Pi-Hahiroti ke, vihai Naare Namari taqa vare aahara vata Surini vura. Vika taaramo entara aahara vatavaura nuvaqi vi, Maraini oru naavu maaqa kaqate vaura. (Katu Varora 14:22; 15:22-23) ");
INSERT INTO tbg_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Qaiqaa vika Mara ke, katu vare oru Elimi vataini naavu maaqa kaqate vaura. Elimini ruvu namari 12navu vauvaro deti katari 70navuvata mini vaura. (Katu Varora 15:27) (Deti katari vaireva, vira mare vakaavara mare voqaara vaivaro deti tava vira kara naarama vairo.) ");
INSERT INTO tbg_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Qaiqaa vika Elimi ke, vihai Naare Namari vaunaini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Qaiqaa vika Naare Namari ke, aahara vata Sinive tunaini orunte naavu maaqa kaqate vaura. (Katu Varora 16:1) ");
INSERT INTO tbg_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Qaiqaa vika aahara vata Sini ke, vihai katu vare oru Dopikaini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Qaiqaa vika Dopika ke, oru Alusini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Qaiqaa vika Alusi ke, oru Repintimini naavu maaqa kaqate vaura. Mini namari nevavata kia vaura. (Katu Varora 17:1) ");
INSERT INTO tbg_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Qaiqaa vika Repintimi ke, aahara vata Sainaini naavu maaqa kaqate vaura. (Katu Varora 19:1-2) ");
INSERT INTO tbg_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Qaiqaa vika Sainai ke, oru Kibaroti-Hataavaini naavu maaqa kaqate vaura. (11:34) ");
INSERT INTO tbg_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Qaiqaa vika Kibaroti-Hataava ke, oru Haserotini naavu maaqa kaqate vaura. (11:35) ");
INSERT INTO tbg_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Qaiqaa vika Haseroti ke, oru Ritimaini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Qaiqaa vika Ritima ke, oru Rimoni-Peresini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Qaiqaa vika Rimoni-Peresi ke, orunte Lipinaini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Qaiqaa vika Lipina ke, orunte Risaini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Qaiqaa vika Risa ke, orunte Kehelataini naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Qaiqaa vika Kehelata ke, Seferi Aiqina auvoqi orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Qaiqaa vika Seferi ke, Haradaini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Qaiqaa vika Harada ke, Makihelotini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Qaiqaa vika Makiheloti ke, Tahaatini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Qaiqaa vika Tahaati ke, Teraini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Qaiqaa vika Tera ke, Mitikaini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Qaiqaa vika Mitika ke, Hasamonaini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Qaiqaa vika Hasamonai ke, Moserotini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Qaiqaa vika Moseroti ke, Bene-Jakaanini orunte naavu maaqa kaqate vaura. (Lo 10:6) ");
INSERT INTO tbg_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Qaiqaa vika Bene-Jakaani ke, Horu-Hagitigatini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Qaiqaa vika Horu-Hagitigati ke, Jotabataini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Qaiqaa vika Jotabata ke, Abaronaini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Qaiqaa vika Abarona ke, Esioni-Gebeni orunte naavu maaqa kaqate vaura. (Lo 2:8) ");
INSERT INTO tbg_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Qaiqaa vika Esioni-Gebe ke, aahara vata Senini orunte Kadesini naavu maaqa kaqate vaura. (20:1) ");
INSERT INTO tbg_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Qaiqaa vika Kadesi ke, Horu Aiqinaqaa Idomu vata auvahini orunte naavu maaqa kaqate vaura. (20:23) ");
INSERT INTO tbg_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","Vika Isipiqihai katu vare vuvaro 40 ihi aitarovaro 5 tora avuhainaa entaqaa Eroniva qutu vura. Kotiva tuntema kero, Eroniva Kotira kaiqa vara amite vauva oru Horu Aiqinaqaa qutu vura. Viva 123 ihi varakero qutu vura. (20:25-28) ");
INSERT INTO tbg_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Isareri vika mini vauvaro Araati avuhainaa vaiintivano Kenaani vata Nekevini vaiharo Isareri ani vau uvara irura. (21:1) ");
INSERT INTO tbg_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Isareri Horu Aiqina ke, Salmonaini orunte naavu maaqa kaqate vaura. (21:4) ");
INSERT INTO tbg_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Qaiqaa vika Salmona ke, Punonini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Qaiqaa vika Punoni ke, Obotini orunte naavu maaqa kaqate vaura. (21:10) ");
INSERT INTO tbg_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Qaiqaa vika Oboti ke, Moapi vata auvahivano vaunaini, Iye-Abarimini orunte naavu maaqa kaqate vaura. (21:11) ");
INSERT INTO tbg_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Qaiqaa vika Iye-Abarimi ke, Diboni-Gaatini orunte mini naavu maaqa kaqate vaura. (21:30) ");
INSERT INTO tbg_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Qaiqaa vika Diboni-Gaati ke, Alamonu-Dipalaataimini orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Qaiqaa vika Alamonu-Dipalaataimini ke, Nebo Aiqina tataaqa Abarimi Aiqinaqaa orunte naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Qaiqaa vika Abarimi Aiqina ke, Moapi vataini vivi, Iotani Namari hini mantaraini uqita kanta naavu maaqa kaqate vaura. Vika uqita kanta vauvaro Ieriko vatukavano Iotani Namari hini mantara vuruni vaura. (22:1) ");
INSERT INTO tbg_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Vika Moapi uqitaini Iotani Namari tataaqa naavu maaqa kaqate vauvaro Beti-Jesimoti vatukavano hini mantaraini vauvaro Sitimi vatukavano hini mantaraini vaumanta Isareri vika avutana vaura. (25:1) ");
INSERT INTO tbg_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","51","Vika mini vauvaro hini mantara vuruni Ieriko vauvaro vi entara Noravano Kotiva Mosiva Isareri tiva nimiarire tiro, maa uvara Mosira tiva amiro tiharo: Ne Iotani Namari taqavare Kenaani vataini orunte, ");
INSERT INTO tbg_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ho vi vataraqaa varia vaiinti nahentika ekaama aru ntata kaimanta vuate. Vika una variqa maraqura aini oriqohaive ori tanaraqohaive aututaara vara rukavu raakavuma taiqake, vika una variqanavu quahama nimite varia vatukanavuravata qoraiqama kaate. ");
INSERT INTO tbg_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Vi vatava ne i vatava variarire ti, te vira ni nimuro. Ne vi vatara oru vare mini variate. ");
INSERT INTO tbg_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ne satu arukeha vi vatara raira keha, ekaa vo anku vo anku nimiate. Airi varia ankuka nora vata rairake nimi, kia airi varia ankuka inaara vata nimiate. ");
INSERT INTO tbg_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ne kia vi vataraqaa varia vaiinti nahentika ekaa aru ntata karaiti, hini kiaka qaqi kaivera, vika auqu vai haikava ni avuqivata vaataqivata ranteqe vaintemake, qaiqaa qaiqaavata ni qoraiqama nimitevarave. ");
INSERT INTO tbg_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ne kia vika ekaa aru ntata kaivera, te vika qoraiqama nimitarera iritaainara, vira nintama qoraiqama nimitararave, tiro. ˻Noravano Kotiva minti tivakero Mosirara Isareri vi uvara tiva nimiane tura˼... ");
INSERT INTO tbg_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mosiva Moapi uqita vata kero aiqina vo, vira nora autu Nebo, vira inaara autu Pisigave tunaini, noraqaa oru vaura. Vi aiqinava kuari urinaini vauvaro Iotani Namari hini mantaraini Ieriko vatuka vaura. Mosiva aiqina viraqaa himpite vauvaro Noravano Kotiva Isareri nimirerave tu vatara ekaa vira umiqora. Viva Gileaati vataihairo Mosira umiqaqiro viviro, Daani vatukavano vaunaini vuru taiqora. ");
INSERT INTO tbg_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Ekaa vo anku vo anku Napataarira vatave, Efaraimura vatave, Manasera vatave, Iutaara anku vatave, umiqaqiro viviro, Meditarenia Namari kuari avu aqu vinaini vau vataravata umiqora. ");
INSERT INTO tbg_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Noravano Kotiva Mosira nora vata, Iutaa uqitaini vau vatara sautini vaura umiqero, airi deti katari vau vatukara Ierikovata qumiqero, viraqaahairo hini sauti mantaraini Soaa vatukavata umiqora. ");
INSERT INTO tbg_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Noravano Kotiva Mosira ekaa vi vatara umiqero virara tiharo, Te tenta kauqu aiqiqaa aqukeha Eparahaamirave, Aisaakirave, Iekopirave, vika naintivarave, vi vatara nimirerave tiavaunarave. Minti tunarara ti, vate te vi vatarama ai umiqauro. Te vate ai qaqi kaurara are avuqohaira vi vatara tavaaro. Ho te kia ai qaqi kaarirara are mini vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Viva minti tuvaro Mosiva Nora Kotira kaiqa vaiintivano Moapini vaiharo Noravano tiva amuntema kero, mini vaiharo qutu vura. ");
INSERT INTO tbg_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Viva qutu vuvaro Noravano Kotiva naivano Moapi uqitakanta Mosira quntama tora. Vira quntama tova vauvaro vatuka vo, vira autu Beti-Peo, vutuni vaura. Vate kia vo vaiintivanovata Mosira quntama to vatara kankomake iri tavaara. ");
INSERT INTO tbg_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Mosiva 120 ihi varakero qutu vura. Viva qutuarirava aumanto vauvaro viva kia anoma naampaiqama viraitiro vauvaro, vira kempukavano qaqi vauvaro vira avuvanovata koqe iro vaura. ");
INSERT INTO tbg_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Mosiva qutu vumanta Isareri vika Moapi uqita kanta 30 entanavuara vaiha, Mosirara iqi rata amitaqi vura. ");
INSERT INTO tbg_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Isareri vika Mosirara iqi rataqi vi, vuru taiqa kovaro Iosuaava Mosira vatuka varora. Haaru Mosiva nai vatuka varaarire tiro vira noraiqama korara tiro, Kotiva Nunira maaqu Iosuaara koqe avu aato amura. Mintumanta vaiinti nahenti Iosuaara uva iriha vika Noravano Kotiva Mosira tiva amu uva maarara avataqi vura. ");
INSERT INTO tbg_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Taara vaiintitanta vohaa vaiha uva tuntema kero, Noravano Kotiva Mosikantiro uva ti vaura. Minturara tiro, vi entaraqaahairo kia paropeti vovano Mosira voqaara qovarama viva vaira. ");
INSERT INTO tbg_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Kia vokia paropetika Mosiva nora kaiqa varaintemake kaiqa varaara. Noravano Kotiva Mosira atitovaro viva aahuva vo qara vo qara u kaiqara Isipini vareharo Isipi avuhainaa vaiintivata, vira nora vaiintinavuvata, ekaa Isipi vatanaakavata qoraiqama nimitora. ");
INSERT INTO tbg_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Mosiva ekaa Isareri nivuqaa vaiharo nai nora kaiqa, aatu ite vai kaiqara autu nimitora. Vokia paropetika kia ho Mosiva kaiqa varaintemake varaara. ");
INSERT INTO tbg_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Nora Kotira kaiqa vaiinti Mosiva qaqi vau entara Nunira maaqu Iosuaava Mosira kahaqi vau vaiintiva vaura. Ho Mosiva qutu vuvaro Noravano Kotiva Iosuaarara tiharo, ");
INSERT INTO tbg_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Ti kaiqa vaiinti Mosiva qutu vimantara ti, te ni Isareri vata nimiaina entava anima ntaivo. Arevata ekaa Isarerivata Iotani Namari taqa vare, vi vataraqaa virara qera iha variate. ");
INSERT INTO tbg_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Te haaru Mosira tiva amunantemake, ne vi vataraqaa nenta aiqu ntavatera, ekaa vi vatara ni nimirerave. ");
INSERT INTO tbg_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Ni vata viva vaireva, maantimakero varianarove: Aahara vata sauti mantaraihairo hoqaramatero viviro, Lebanoni aiqinavano noti mantaraini vainaini taiqaanarove. Qaiqaa nora namari Iufaretisi Namari kuari urunaihairo vi vatava hoqaramatero viviro, Hiti vatanaaka vata vara maini kero viviro, Meditarenia Namari auvahini kuari ruhunkinaini vuru taiqaanarove. ");
INSERT INTO tbg_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Are qaqi variqira vina entara kia ho vovano iqoka raqiharo ai aatara kaanarove. Te kia ai qaqira karaiti, te Mosira vataake variqi vunantemake, ai vataake variqi virerave. ");
INSERT INTO tbg_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Haaru te tenta kauqu aiqiqaa aqukeha ni kaivaqaukavarara vi vatara ni Isareri nimirerave tunarave. Arema maa vaiinti nahentika ntita varera vi vataraqaa vuru keravara tira, kia qetaraitira, kempukaiqama kera variane. ");
INSERT INTO tbg_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Are kia qetaraitira, kempukaiqama kera variqira vihara, ti kaiqa vaiinti Mosiva uva maara ai tiva amura, ekaa vi uvara iriqira vuane. Are kia vi uvaraqihaira inaara uva voqavata qaqira karaitira, ekaa vi uvara iriqira virera, are taini tainie vi anihara, koqema keraqaima variqira vinarave. ");
INSERT INTO tbg_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Vi uvara Mosiva qara ntuvatai vukuraqihaira vo enta vo enta kaara ntuvaqira vuane. Aatitainaraqaavata entaqivata vi uvara aatoqi iriqira vihara ekaa vi uvara avataqira vuane. Are mintiaqira virera, are varena kaiqava koqe iro vairara are koqema kera variqira vinarave. ");
INSERT INTO tbg_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Te vaaka ariara kia qetaraitira, kempukaiqama kehara variqira vuane, tunarave. Are taini tainie vi aniraqe te Noravano Kotika ai Variqavano ai vataake variainarara tira, are kia vo haika aatu qetairaro ai muntukavano maara ntaarire, turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Kotiva minti tuvaro Iosuaava qiata vaiintinavuara tiharo, ");
INSERT INTO tbg_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","Nenavu seri naavu maaqa kaqa taanaini vi aniha vaiinti nahentiara karakaaqa qeramake vataate. Taaramo enta aitaraira ne Iotani Namari taqa vare Noravano Kotiva ni Variqavano nimire ti vatara oru varevarave, tiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Iosuaava minti tivakero viva Rubenira ankuaravata, Gaatira ankuaravata, Manasera anku hininavuaravata, tiharo, ");
INSERT INTO tbg_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","Haaru Nora Kotira kaiqa vaiinti Mosiva niara tu uvara ne qaiqaa iriate. Mosiva minti turave: Noravano Kotiva maa vatara ni nimiraro vi vatava nini varianarove, turave. ");
INSERT INTO tbg_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Mosiva minti turara ti, ni nahentive vaintive, ni quara vairive, Iotani Namari hini mantara maini vaimanta, ekaa ni iqoka vaiinti vikaqai auvihehavaa vaqa ntuva vare, nái qata vakaukavara kahaqireka vika naane vutura hini mantaraini taqa vare vuate. ");
INSERT INTO tbg_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Vika mini oru vaiha nái qata vakaukavara kahaqamaqi vivaro Noravano Kotiva ekaa vi vatara nái vika nimireva ti vatara vikavata nimira varaate. Viraqaahai ne orurante, Iotani Namari maa mantaraini ani vaiha Nora Kotira kaiqa vaiinti Mosiva ninta nimu vataraqaa nenta ani variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Iosuaava minti tumanta vika vira nái tiva ami tiha, Are tinavu tiva timiana uvara, tenavu ekaa vi uvara avataqi virerave. Are taini tainie tinavu tititairaqe tenavu are tinantemake mini mini virerave. ");
INSERT INTO tbg_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Haaru tenavu Mosira uva koqemake iriqi vunantemake, vate tenavu ai uvavata koqemake iriqi virerave. Noravano Kotiva Mosira vataakero variqiro vuntema kero, viva qaiqaa ai vataakero variqiro vuanarove. ");
INSERT INTO tbg_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Ta vaiintivave kia ai uva iriraitiro, ai uva raqa kaaina vaiintira, vi vaiintira tenavu tiari aruma kevarave. Are kia qetaraitira, kempukaiqama kera variqira vuane, ti. ˻Qiata vaiinti vika minti tura.˼ ");
INSERT INTO tbg_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Isareri vika Sitimi vataini vauvaro Iosuaava vaiinti taaraqanta Kenaani vata ampeqamake tavaate tiro, vitanta nititora. Viva vitantara tiharo, Netanta Kenaanini oru ampeqamake tavamaqi vivi, oru Ieriko vatukaini anomake ampeqamake tavaate, tiro. Minti tumanta vitanta Ierikoni orunte, hampi nariro ni vau nahentira, Rehaapira naavuqi oru vaitora. ");
INSERT INTO tbg_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Ho Ieriko avuhainaava irumanta Isareri vaiinti taaraqanta Kenaani vataini ampeqireka aniavo tuvaro ");
INSERT INTO tbg_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","viva uva vara kovaro Rehaapiva unaini vura. Viva vi nahentirara mintima tiro: Taara vaiinti Kenaanini ampeqireka ani ai naavuqi variavo. Nena naavuqihaira vitanta vara veva kaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","Ho vaaka Rehaapiva vitanta nai naavu qiata tanuqi kanta ntita vaari kero, repa kaqi vatoraqohairo vitanta vauvu tomanta vaura. Avuhainaa vaiintivano vitantara nena naavuqihaira vara veva kaane, tuvaro Rehaapiva aqao tiro, Vitanta vaakama vuavo. Quqaama vitanta vaaka ti naavuqi ani variarave. Ho vitanta vihai ania okarara kia te irunarave. Eraimanta vaantaavura qenti kia tintaaraqaa vitanta naane vevante otitare vuavo. Tainie nái vuavo? Vitanta kia tivata tiva timiavo. Ne vitanta vaaka rantakareka ivera, ne homa vitanta avataqi vivi, ravaaqavu kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Rehaapiva minti tumanta avuhainaava nititoka Ieriko ke, vitanta ravaaqavu kareka vuvaro Ieriko vaantaavura qenti tinta tora. Avuhainaava nititoka Isareri vaiintitantara qumina rantaqi vivi, Iotani Namari taqa vare vi ani vaunaini otunte tavomanta vitanta kia mini vaura. ");
INSERT INTO tbg_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Ho Isareri vaiintitanta entaqi naavu qiataqaa vaitareka uvaro Rehaapiva oru ntero ");
INSERT INTO tbg_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","vitantara tiharo, Noravano Kotiva maa vatara ni Isareri kaama nimitairara te irunarave. Ekaa tenavu maa vataraqaa vaurauka ni Isareri naatu voqamake qeteha vauro. ");
INSERT INTO tbg_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Ne Isareri Isipi ke anuvaro Noravano Kotiva ni avuni viharo Naare Namari aaharaiqama nimitomanta ne ho anu uvara tiamanta irunarave. Iotani Namari hini mantaraini Amo vatanaaka avuhainaa vaiintitanta Sihonika Okuka ne Isareri vitanta arukoravata tiamanta irunarave. ");
INSERT INTO tbg_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Tenavu vi uvara iri, voqamake qeteha vauraro tinavu kempukavata taiqa vimanta vauro. Oho, Noravano Kotiva ni Variqavano naaruvaqaavata, vataqaavata raqiki vaivama vaivo. ");
INSERT INTO tbg_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Ho te nitanta koqema nimi taunarara irihama netanta Nora Kotira autuqaa mintima tiate: Are titanta koqema timitaanantemake, tetanta ai nina vaiinti nahentiaravata koqema nimitarerave, tiate. Netanta vo haika ti humiqaiqe te vi haikara tave, nitanta uvara quqaave tiare. ");
INSERT INTO tbg_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Netanta kauqu aiqiqaa aqukeha mintima tiate: Tenavu Isareri ai noka qokave, ai qata vakaukave, ai aura nakaukave, vika vaintivarave, kiama aru kaainarave, tiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Rehaapiva minti tumanta vitanta nái kauqu aiqiqaa aqukeha tiha, Tetanta ai tiva amuna uvara raqa kaarera, homa Kotiva titanta arukaanarove. Are tetanta vare vauna kaiqara kia qovarama kairera, Noravano Kotiva maa vatara tinavu Isareri kauquqi kaaina entara tenavu kia ni qoraiqama nimitaraiti, koqema nimitarerave, tura. ");
INSERT INTO tbg_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Rehaapira naavuvano Ieriko vatuka vaantaavuraqaa akukumate kaqa tova vauvaro Rehaapiva naaqunta varakero uintu anahairo vitanta aaqaini vaati tutakora. ");
INSERT INTO tbg_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Viva tiharo, Ieriko avuhainaava nititaika nitanta ranta kevorave ti, netanta aiqinaini oru kukeqavi variate. Vika taaramo entara nitantara ranteha tave qaqirake maini orurante animanta, netanta nenta navunaaka ianaini vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Minti tumanta vitanta tiha, Tetanta kauqu aiqiqaa aquke tiva tauna uvava quminaiqama vuantorave tira, ");
INSERT INTO tbg_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","are maa uvara koqema kera avataane: Tenavu Isareri iqoka raqirera maini aniarirara are titanta tutakena uintuaraqaa naare naaqunta rumpa tairaqe tenavu Isareri naaqunta vira ho tavaare. Mintimatera are oru nena noka qokave, nena qata vakaukave, ekaa nena vaintivarave, ntita varera nena naavu maaqi viri kaira variate. ");
INSERT INTO tbg_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Mintiraro vovano naavu maaqihairo qaqirakero vahaaqaini veva ntero viramanta vira arukaivera, vira nai okarama varianarove. Kia titanta okaravauve varianarove. Isareri vika ai naavu maaqihai vaiinti vo qoraiqama kaivera, vi uvava titantaqima varianarove. ");
INSERT INTO tbg_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Ho raurihara variane. Are tetanta ampeqi vauna uvara vora tiva amirera, tetanta ariara kauqu aiqiqaa aqukeha tiva tauna uvava quminaiqama ianarove, ti. ");
INSERT INTO tbg_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Vitanta minti tuvaro Rehaapiva tiharo, Eo hove. Netanta tintema kero varianarove, tivakero vitanta nititama komanta vura. Vitanta vuvaro viva naare naaqunta varakero uintuaqaa rumpa tovaro vaura. ");
INSERT INTO tbg_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Vitanta aiqinaini oru kukeqavi vaumanta Ieriko avuhainaava nititoka taaramo entara vitantara qumina rantaqi vivi, qaqirake nai orurante anura. ");
INSERT INTO tbg_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Vika anumanta viraqaahai ampeqireka anutanta aiqinaihai tuvunte, Iotani Namari taqa vare Iosuaava vaunaini orunte, vitanta ekaa náitantaqaa qovaraiqu uvara vira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Vitanta vi uvara tiva taiqake qaiqaa tiha, Noravano Kotiva quqaama vi vatara tinavu Isareri kauquqi kaanarove. Vi vataraqaa variaka tinavu Isareri aatu voqamake qeteha variavo, tura. ");
INSERT INTO tbg_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Vira qararaa vaaka toqaqi Iosuaava ekaa Isareri hampata Sitimi mini ke, otunte Iotani Namari auvahini nái seri naavu maaqa kaqate, Iotani Namari taqera veka vaura. ");
INSERT INTO tbg_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Vika mini vauvaro taaramo enta aitaromanta viraqaahai Isareri qiata vaiintinavu vaiinti nahenti seri naavu maaqa kaqatoraqi vi aniha ");
INSERT INTO tbg_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","vika tiva nimi tiha, Ne tavaimanta Kotira kaiqa vara amite varia vaiintika, Rivaira anku ni Variqa Noravano Kotiva uva tiva taatauto Vokisera aqu vare avuni vimanta, ne nenta i haikaravata vare, vika naantiaraini vuate. ");
INSERT INTO tbg_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ne kia mini vua aarara tavaakara ti, ne vika naantiaraini vimanta vikama vi aarara ni numiqaate. Ne mini viha kia Kotiva uva tiva taatauto Vokisera aquvare vika aaqanto oru viraiti, ne 1 kilomitae vututoqamake aniha, vika naantiaraini vuate, ti. ");
INSERT INTO tbg_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Isareri qiata vaiintinavu minti tuvaro Iosuaavavata vaiinti nahentiara tiharo, Hura Noravano Kotiva ni avutana nora kaiqa varaainarara ti, vate ne nenta avu aato muntukaqihai Kotiraraqai iriqi viha tuekaamake variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Minti tivakero viva Kotira kaiqa vara amito vaiintikara tiharo, Ne naane Kotiva uva tiva taatauto Vokis era aqu vare vaiinti nahenti avuni vuate, tumanta vika viva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Mintuvaro Noravano Kotiva Iosuaarara tiharo, Te vate nora kaiqa vara nimitaari Isareri vira tave, maa entaraqaahai vika ariara nora vaiintive tivaqi vivarave. Haaru te Mosira hampata vaunantemake, vatevata te ai hampata variainara, viraravata vika kankomake irivarave. ");
INSERT INTO tbg_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ho ti kaiqa vara timite variaka te uva tiva taatau tauna Vokisera aqu vare variaka mintima tiva nimiane: Ne vi Vokisera aqu vare otu Iotani Namari vainaini otunte, namari viraqi otu himpite variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Noravano Kotiva minti tuvaro Iosuaava Isareriara tiharo, Ne vainto ani vaiha iri vaiqe te Noravano Kotiva ni Variqavano ti uvara ni tiva nimiare. ");
INSERT INTO tbg_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Vate ne Kotiva nora kaiqa varaainara tave, viraqaahai ne kankomake irivaro qaqi variqiro vi vai Variqava ni hampata vaiharo viva quqaama Kenaani vataqaahairo ni navutaaka, Kenaani vatanaakave, Hiti vatanaakave, Hivi vatanaakave, Peresi vatanaakave, Girigaasi vatanaakave, Amo vatanaakave, Jebusi vatanaakave, aru ntatama kaanarove. ");
INSERT INTO tbg_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ho tavaate. Noravano Kotiva ekaa maa vataraqaa raqiki vaira, vira Vokisevano naane avuni Iotani Namari taqareva vuanarove. ");
INSERT INTO tbg_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ne Isareri 12 anku vohaiqa vohaiqaqihai vaiinti 12navu kaama taate. ");
INSERT INTO tbg_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Noravano Kotiva ekaa maa vataraqaa raqiki vaira Vokise, vira kaiqa vara amite variaka vira aqu vare ni nivuni Iotani Namariqi otunte, vika nái aiqu namariqi ntava taivaro namarivano kia tuvitare viraitiro, kumpetaqiro viharo vaaviarama viro varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Iosuaava minti tumanta vaiinti nahenti nái seri naavu maaqa rampaike vare Iotani Namari taqareka vumanta, Kotira kaiqa vara amite vauka avuni viha Kotiva uva tiva taatauto Vokisera aqu vare vura. ");
INSERT INTO tbg_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Kara qanti vau entava anintovaro Iotani Namarivano nora huvura tuvi vaura. Mintumantavata, Kotira kaiqa vara amite vauka Kotira Vokise aqu vare Iotani Namariqi otunte vika nái aiqu namariqi ntava tovaro ");
INSERT INTO tbg_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","aruvuhairo tuvi vau namariva kia tuvitare viraitiro, kumpetaqiro viharo Saretaani vatuka tataaqa vau vatukara Adaamuni vaavi araviro vaura. Aruvuhainaava mintuvaro aateraini vitare vi vauva kia Qutuvi-Varuvava vaunaini oru viraitiro, aaharaiqama vura. Ieriko vatukavano vurunto vaumanta vaiinti nahenti Iotani Namari aahara vau taqa vare hini mantaraini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Kotira kaiqa vara amite vauka Kotira Vokise aqu vare, Iotani Namari avutaqaa, aaharaiqu vataraqaa himpite vaumanta, ekaa Isareri taqa vare vivi, hini mantaraini oritare vura. ");
INSERT INTO tbg_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Ekaa Isareri Iotani Namari taqa vare vuvaro Noravano Kotiva Iosuaarara tiharo, ");
INSERT INTO tbg_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","Isareri anku 12navuqihaira vaiinti vohaiqa vohaiqa kaamatera ");
INSERT INTO tbg_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","vikara mintima tiane: Kotira kaiqa vara amite variaka Iotani Namari avutaqaa himpi variara viraqaahai ne Isareri anku 12navuara irihama, nora ori 12navu mpaqike aqu vare tenavu vaitarera iainanaini vuru vataate, tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Minti tuvaro Iosuaava vaiinti 12navu kaamatoka naarama kero ");
INSERT INTO tbg_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","vikara tiharo, Nenavu nenta Variqa Nora Kotira Vokisevano Iotani Namariqi vainaini otunte, vuruntoqamake nora ori vohaiqa vohaiqa mpaqike aqu vare uruate. Nenavu Isareri anku 12navuara irihama ori 12navu aqu vare uruate. ");
INSERT INTO tbg_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Noravano Kotiva vate ni Isareri vara nimitai kaiqara naantiara ne tauru kevorave ti, vika ori 12navu vare vuru vohaaraqaa vatevarave. Naantiara ni vaintivara ori vira okarara iraimanta ");
INSERT INTO tbg_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ne mintima tiate: Haaru Nora Kotira Vokisevano Iotani Namari avutaqaa vauvaro namarivano aaharaiqama vurave, tiate. Naantiara Isareri vika ori vinavura taveha, maa entara qovaraiqirara kia tauru karaiti, qaqi iritevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Iosuaava minti tumanta vika viva tunte ura. Noravano Kotiva Iosuaarara tuntemake, vika otu Iotani Namari avutaqaahai ori 12navu mpaqike vare urura. Vika Isareri anku 12navuara iriha nora ori vohaiqa vohaiqa aqu vare seri naavu maaqa kaqa tonaini vuru vatora. ");
INSERT INTO tbg_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Mintuvaro Iosuaava ˻tumanta˼ vokuka vo ori 12navu varake, Kotira kaiqa vara amite vauka Kotira Vokise aqute Iotani Namari avutaqaa himpite vaunaini ruvaaqumake vatora. Vi orinavuva vate maa entara qaqima vairo. ");
INSERT INTO tbg_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Nora Kotika Mosika ekaa uva Iosuaara tiva amuntemake, Kotira kaiqa vara amite vauka Kotira Vokise aqute Iotani Namari avutaqaa himpite vaumanta vaiinti nahenti vaaka namari taqa vare hini mantaraini oritarora. ");
INSERT INTO tbg_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Vika ekaa hini mantaraini oritare vaumanta, viraqaahai Kotira kaiqa vara amite vauka Nora Kotira Vokise aqu vare, oritare qaiqaa vaiinti nahenti avuni oru vaura. ");
INSERT INTO tbg_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Mosiva tuntemake, iqoka vaiinti Rubenira ankuve, Gaatira ankuve, Manasera anku hinive, iqoka raqireka qerama vare, vika naane vaiinti nahenti avuni Iotani Namari hini mantaraini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Nora Kotira avuqaa 40,000 iqoka vaiinti nái auvihehavaa vaqa ntuva vare Ieriko tataaqa uqitakanta oru vaura. ");
INSERT INTO tbg_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Vi entara Noravano Kotiva vaiinti nahenti nivuqaa nora kaiqa vara nimitorara iriha, ekaa Isareri vika Iosuaarara nora vaiintive tura. Vika tota Mosirara nora vaiintive tuntemake, Iosuaava qaqi vau entara viraravata nora vaiintive ti vaura. ");
INSERT INTO tbg_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","˻Ho ekaa Isareri Iotani Namari hini mantaraini oritarovaro˼ Noravano Kotiva Iosuaarara tiharo, ");
INSERT INTO tbg_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Ti kaiqa vara timiteha te uva tiva taatau tauna Vokisera aquteha variaka, are tiramanta vika Iotani Namari avutaqaahai uruate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Minti tuvaro Iosuaava vikara tiharo, Nenavu Iotani Namari avutaqaahai uruate, tumanta ");
INSERT INTO tbg_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","vika Iosuaava tuntemake qaqini vaarinte vuvaro, vaaka Iotani Namarivano qaiqaa huvura namarivano tuvi vauntema kero, tuvi vaura. ");
INSERT INTO tbg_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Avuhainaa tora 10 entaqaa ekaa Isareri Iotani Namari taqa vare hini mantaraini orunte, Ieriko tataaqa Giligaali vatukaini oru nái seri naavu maaqa kaqate vaura. Giligaali Ieriko tataaqa kuari avu urinaini vaura. ");
INSERT INTO tbg_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Vika nái seri naavu maaqa kaqate mini vauvaro Iosuaava vaiinti vonavu ori 12navu Iotani Namariqihai mpaqitora varakero, vohaaraqaa vaavi aratero ");
INSERT INTO tbg_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Isareriara tiharo, Naantiara ni naintivara nái qokavara ireha tiha, Nana haikara irihae maa orinavura vaavi aratorave? timanta ");
INSERT INTO tbg_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","vika mintima tivarave: Haaru ekaa Isareri vaiinti nahenti Iotani Namari aaharaiqama vuraqaa taqa vare vu entarara irihama maa orinavura vaavi aratorave, tivarave. ");
INSERT INTO tbg_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Vate Noravano Kotiva ni Variqavano Iotani Namari aaharaiqama nimitaimanta ne taqa vare maini aniarave. Vate ni mintima nimitaintema kero, haaruvata Noravano Kotiva tinavu Variqavano Naare Namari aaharaiqama timitaimanta tenavu Isareri vi namarira taqa vare anunarave. ");
INSERT INTO tbg_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Noravano Kotiva minti minti irara ti, ekaa vataini variaka Nora Kotira kempukara kankomake irivarave. Ne vira aatu qeteha ekaa enta vira autu tuaheraqi vuate tiro, Nora Kotiva ni Variqavano ekaa vi kaiqara ni vara nimitairave, tiro. Iosuaava minti tura. ");
INSERT INTO tbg_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Amo vatanaa avuhainauka Iotani Namari hini mantaraini kuari avu ruhunkinaini vaukave, Kenaani avuhainauka Meditarenia Namari auvahini vaukave, vikavata iruvaro Noravano Kotiva Isareri namari ho taqa vare vuate tiro, Iotani Namari aaharaiqama nimitora. Vika vi uvara iruvaro voqama kero naatu itomanta vika iqoka raqi kempukava kia vaumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Vi entara Noravano Kotiva Iosuaarara tiharo, Ne roqori ori vaihairaqohai nenta Isareri qorainti vaata toqa kaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Minti tuvaro Noravano Kotiva tunte iro Iosuaava ori vaihaira vara komanta ekaa Isareri qorainti vika nái vaata toqa kora. Vika vi vatara autu nteha, Gibeati-Haaraloti – Vaata Toqakaa Aiqinarave, tura. ");
INSERT INTO tbg_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Haaru Isipini vau entara Isareri vika ekaa vaiintive, vika maaquvarave, vaata toqakoka vaura. Ho vika Isipi mini ke 40 ihiara aahara vataini vi ani vau entara, qorainti vainti mini vatatoka kia vaata toqa nimitora. Vika Isipiqihai anu entara 40 ihi aitaromanta ho iqoka raqi vaiintika aahara vataini variqi vivi, Nora Kotira uva raqakora kaara mini ekaa qutu vura. Tota Noravano Kotiva nai kauqu aiqiqaa aqukero vikara tiharo, Ne ti uva raqakaara kaara, te ni kaivaqaukavarara tiha, Te karavano koqema kero qampiqaaina vatara ni Isareri nimirerave tuna uvava kiama niqi varianarove, tura. ");
INSERT INTO tbg_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Noravano Kotiva minti tumanta vi vaiintika variqi vi vuru qutu vumanta vika maaquvara noruqamavi kia vaata toqa koka vauvarora tiro, Iosuaava vikara tumanta vika vaata toqa nimitora. ");
INSERT INTO tbg_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Vika vaata toqa nimitova tavanta vuarire ti, ekaa Isareri vika nái seri naavu kaqatoraqi qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Mintuvaro Noravano Kotiva Iosuaarara tiharo, Ne Isareri Isipini vau entara vi vatanaaka ni rumpa tomanta ne vika paanaa kaiqa vare vaura kaara kaurira haikavano niqaa vaurave. Ho vate te kaurira haika vira niqaahai qaqini varake taiqama kauro, tiro. Noravano minti turara ti, vika vi vatara autu nteha, Giligaalive — Qaqini-Vara-Korave tura. Maa entaravata vaiinti nahenti vi vatara autu qaqi nte variara. ");
INSERT INTO tbg_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Ho avuhainaa tora 14 entaqaa Isareri vika Ieriko uqita kanta Giligaalini nái seri naavu maaqa kaqatonaini vaiha, haaru enselivano Isareri vika Qaqi Vehakuma Nimito entarara iriha kara nora. ");
INSERT INTO tbg_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Vira qararaa vika Kenaani vataini naahoqi baali qampiqora teqake vare, hini baali ihaqi untake ne, hini baali kia noqai mparetira untake nora. (Baali vaireva, raisive voqaarama vairo.) Vi entaraqaa vika avuni hoqaramake Kenaani vataini qampiqo karara varake nora. ");
INSERT INTO tbg_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Vika vi karara novaro vira qararaa manaavano kia qaiqaa hiqintumanta vika kia vi karara qaiqaavata varake nora. Vi entaraqaahai Isareri vika Kenaanini qampiqo karara varakeha ne vaura. Iqoka paipe tote vau vaiintira ");
INSERT INTO tbg_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Vo enta Iosuaava Ieriko tataaqa vaiharo vuruvi tavovaro vaiinti vovano iqoka paipe nai kauquqi totero vira avuni himpitero vaura. Mintuvaro Iosuaava raukuviro viva unaini oruntero virara tiharo, Are tinavu iqoka vaiintivanoe variaro, tinavu navutaavae variaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Iosuaava minti tuvaro viva aqao tiro, Te kia ni iqoka vaiintivauve vauro. Te kia ni navutaakavauve vauro. Te Nora Kotira iqoka vaiinti vika avuhainaukama vauro, tiro. Minti tuvaro Iosuaava vatakanta hiqinti viro nai viri vataini kero vi vaiintira quahama amiteharo tiharo, Mpo, nora vaiintio, te ai kaiqa vaiintima vauro. Te nana kaiqae ai vara amitararave? tiro. ");
INSERT INTO tbg_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Minti tuvaro Nora Kotira iqoka vaiinti vika avuhainaava tiharo, Are te vauna vatara turuaraini himpi varianarara tira, nena aiquqaa nonku taanara qaqini rahunku kera variane, tuvaro Iosuaava viva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ieriko vatukaqi vauka Isareri naatu qeteha ekaa vaantaavura qenti tinta tomanta vika avutaqihai aaqaini viva kia ho vaumanta aaqaihai avutaqi uriqetevavata kia ho vaura. ");
INSERT INTO tbg_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ho Noravano Kotiva Iosuaarara tiharo, Iriane. Te Ieriko vatukavata, vira avuhainaa vaiintivata, vira iqoka vaiintinavuvata, ai kauquqi karerave. ");
INSERT INTO tbg_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Are nena iqoka vaiintiaravata oru Ieriko auvahianta vohaa enta vohaa tataa vi vatukara virante airante ututumakeha vuate. Ne 6 entanavuarama mintiaqi vuate. ");
INSERT INTO tbg_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ne mintiaqi vimanta ni avuni ti kaiqa vara timite variaka 7navu sipisipi qora komuqohai aututaa aanumaarara/nomara nái kauquqi tuata vare vi vaimanta vika naantiara ti Vokise aqu vareka vuate. Ne 6 entanavuara mintiaqi vivi, 7 entaqaa ne 7 tataa Ieriko virante airante i vaimanta ti kaiqa vara timite variaka ni avuni viha nái aanumaara vuaqaqi vuate. ");
INSERT INTO tbg_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Vika vuaqaqi vivi, ekaanaini vukaiqaake vuaqaate. Vika vukaiqaake vuaqe vaimanta ne vi uvara iri, ne ekaa noraiqaake naverai tivaro Ieriko ori vaantaavuravano rukavu raakavuma vuarire. Mintiramanta ne kia varike viraiti, ne ekaa vaakama vi vatukaraqi oriqetaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Minti tuvaro Nunira maaqu Iosuaava Kotira kaiqa vara amite vau vaiintika naarama kero vikara tiharo, Ne Noravano Kotiva uva tiva taatauto Vokisera aqu vare vi vaimanta niqihai vaiinti 7navu aanumaara tuata vare ni avuni vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Minti tivakero Iosuaava Isareri vika tiva nimiro tiharo, Ne vi vatukara aaqaini virante airante iate. Iqoka vaiinti vokiaka naane avuni nái auvihehavaa vare vimanta vika naantiara Nora Kotira Vokise aqu vare vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","9","Iosuaava minti tumanta viva tuntemake auvihehavaa varoka vokuka avuni vumanta vika naantiara Kotira kaiqa vara amite vauka aanumaara vuaqaqi vumanta, vinavuka naantiara Kotira Vokise aqu varoka vumanta, vika naantiara auvihehavaa varoka vokukavata vura. Vika vatuka aaqaini virante airante i vaumanta aanumaara tuatoka nái aanumaara vuaqe vaura. ");
INSERT INTO tbg_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Vika vuaqe vauvaro Iosuaava ekaa Isareriara ne kia uvavata tiraiti, evaara vaiqe te niara naverai tiate tiari ne naverai tiate turara ti, vika kia uvavata tiraiti, evaara vatuka aaqaini virante airante i vaura. ");
INSERT INTO tbg_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Vika Iosuaava tuntemake, Nora Kotira Vokise aqu vare, vohaa tataa Ieriko vatuka aaqaini virante airantemake, viraqaahai Isareri vika nái seri naavu maaqa kaqatonaini anirante oru entaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","13","Mintuvaro vira qararaa Iosuaava vaaka toqaqi himpumanta qaiqaa Kotira kaiqa vara amite vaukavata, Isareri iqoka vaiintivata, avuni untemake, Ieriko aaqaini vohaa tataa virante airante ura. Auvihehavaa varoka vokuka avuni vumanta vika naantiara Kotira kaiqa vara amitevauka 7navu aanumaara vuaqaqi vumanta, vika naantiara Nora Kotira Vokise aqu varoka vumanta, vika naantiara auvihehavaa varoka vokukavata vura. Vika vatuka aaqaini virante airante i vaumanta aanumaara tuatoka nái aanumaara vuaqe vaura. ");
INSERT INTO tbg_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ho vira qararaa taara entaqaa vika Ieriko aaqaini qaiqaa oru vohaa tataa virante airantemake, viraqaahai vika orurante nái seri naavu maaqa kaqatonaini oru vaura. Vika 6 entanavuara mintiaqi vura. ");
INSERT INTO tbg_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Mintiaqi vivi, 7 entaqaa vika aatitare uraqaa himpi oru avuni untemake, Ieriko aaqaini virante airante ura. Vi entara vika kia vohaa tataaqai virante airante iraiti, vika 7 tataa Ieriko aaqaini virante airante ura. ");
INSERT INTO tbg_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Vika 7 tataa virante airante i vaumanta Kotira kaiqa vara amite vauka nái aanumaara/noma vukaiqamake vuaqe vauvaro Iosuaava vaiinti nahentiara tiharo, Ne ekaa naverai tiate. Noravano Kotiva vi vatukara vate nima nimivo. ");
INSERT INTO tbg_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Tenavu Ieriko vatukavata, ekaa viraqi vaina haikaravata, vehi autu taiqake ofaa voqaara vi vatukara Nora Kotira amirerave. Hampi nariro ni vai nahentiva Rehaapiva tinavu vaiintitanta ampeqamake tavareka vuatanta kukeqa tairara ti, tenavu viravata vira naavuqi variakavata vehakuma nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Ne ekaa haika vehi autuke, kia vo haikavata nenta varaate. Ne vo haika varaivera, vira kaara tinavu Isareriqaa nora maaravano qovaraiqiraro tenavu vehi autuvi taiqa vuariravama varianarove. ");
INSERT INTO tbg_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Silvaave, korive, baraasive, ainive, vi oriraqohai aututaa haikava, ekaa vi haikava Noravano Kotiva i haikavaqaima varianarove. Ne vi haikara vi haikara vare vuru Kotira monu vate varia naavuraqi vataate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Iosuaava minti tumanta Kotira kaiqa vara amite vauka nái aanumaara vuaqa komanta ekaa Isareri vika noraiqaake naverai tuvaro Ieriko vaantaavuravano ruku raakurama vura. Mintumanta Isareri iqoka vaiinti vaaka vatuka avutaqi oriqete, vi vatukara varora. ");
INSERT INTO tbg_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Vika nái iqoka paipeqohai vi vatukaraqi ekaa haika qaqi vauka aru taiqa kora. Ekaa vaiintive nahentive, naampai kontave, vaintive, purumakauve, sipisipive, donkive, ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Minti vauvaro Iosuaava haaru vaiintitanta ampeqamake tavotantara tiharo, Netanta kauqu aiqiqaa aqu keha tivataa uvara iriha oru hampi nariro ni vai nahentiravata, vira naavuqi variakavata, ntita vare vahaaqaini veva kaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Minti tumanta vitanta oru Rehaapiravata, vira noka qokavata, vira qata vakaukavata, vira vaiinti nahenti vonavuvata, vira kaiqa vaiinti nahentivata, ntita vare vahaaqaini veva ke, vika ntita vare Isareri seri naavu maaqa kaqatora tataaqa muntu kora. ");
INSERT INTO tbg_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Vikaqai vehakuma nimite, viraqaahai vika Ieriko vatuka iha tuta kovaro ihavano vi vatukaravata, viraqi vau haikaravata, ita taiqa kora. Silvaave, korive, baraasive, ainive, viraqohai aututo haikaraqai vika vare Nora Kotira monu vato naavuraqi vuru vatora. ");
INSERT INTO tbg_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Iosuaava taara vaiinti nititomanta vitanta Ierikoni ampeqamake tavareka vuvaro Rehaapiva vitanta kukeqa torara tiro, Iosuaava Rehaapiravata, vira navunaakavata, vehakuma nimitero kia vika arukora. (Rehaapiva kuvuarama taika maa entara Isareri vataini qaqi variara.) ");
INSERT INTO tbg_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Vi entara Iosuaava vaiinti nahenti kempukaiqama kero tiva nimiro tiharo, Vaiinti vovano maa vatukara Ieriko qaiqaa autu kairera, Noravano Kotiva vira qoraiqama amitaanarove. Vi vaiintiva vi kaiqara hoqaramatero ori vataqi ntava taina entara vira maaqu hoqarenaava qutu vuanarove. Vi vaiintiva vaantaavura qenti vaaviarama kaina entara vira maaqu vitihainaava qutu vuanarove, tiro. (1 King 16:34) ");
INSERT INTO tbg_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Noravano Kotiva Iosuaara hampata vauvarora tiro, Iosuaava nora kaiqa vare vau uvava vi vataraqaa vi ani vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Hoqarero avuni Noravano Kotiva Isareriara kempukaiqama kero uva tiva nimiro tiharo, Ekaa Ierikoqi vai haikaraqihai kia vo haikavata nenta vararaiti, ekaa vi haikara vehi autu taiqa kaate, tura. Viva minti tumantavata, Isareri vika vi uvara raqakora. Isareri vaiinti vo Akaaniva Kotira uva raqakero vo haika varakora kaara Noravano Kotiva Isareriara voqamakero arara itora. Akaanira qova Kaamiva vauvaro Kaamira qova Sapadiva vauvaro Sapadira qova Seraava vauvaro Seraara ankuvano Iutaara ankuqiraava vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Ho Iosuaava Ieriko vatukaini vaiharo vatuka vo Ai vatukavano vai vatara ampeqamake tavaate tiro, vo vaiintinavu nititomanta vika vira ampeqamake tavareka vura. Ai vatukavano vauvaro vira aumanto Beti-Abeli vatukavano vauvaro vira hini mantaraini kuari ruhunkinaini Beteli vatukavano vira tataaqa vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Ho vi vaiintinavuka Iosuaava tuntemake, oru niha tave, viri Iosuaara tiva ami tiha, Kia airi vaiinti vi vatukaraqi variavo. Are qumina ekaa iqoka vaiinti mini vara kerorave. Are iqoka vaiinti 2,000e 3,000e nititaira vika oru Ai vatanaaka hampata raquate, ti. ");
INSERT INTO tbg_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Vinavuka minti tumanta Isareri 3,000 iqoka vaiinti mini raqireka oru vumanta Aihainaa vaiinti kempukaiqamake vika hampata iqoka raqumanta, Isareri vika aiqu autute orurante anura. ");
INSERT INTO tbg_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Aihainaaka nái vatuka qentiqaahai Isareri aru ntataqi vivi, nora oriqaahai naavu kaqe orira teqake vare vaunaini vuru kora. Aihainaaka onkaiqi vika aru ntataqi otu viha Isareri vaiinti 36navu arukora. Vira kaara Isareri aatu itovaro vika kempukavanovata taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Mintuvaro Iosuaava nai utavaaqa qunahi qaanahima kero, oru Nora Kotira Vokise avuqaa vataini hiqinti viro, mini variqiro viviro entama kora. Isareri nora vaiintivata hora varake nái qiataqaa aqute Iosuaara hampata vataini hiqintivi vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Iosuaava Kotira aarero tiharo, Noravauvo, are ekaa haikaqaa raqiki variaravama variaro. Mpo, nantivarae are tinavu Iotani Namari hini mantaraihaira tivita varera maa vataraqaa viri kaaro? Are tinavu Amo vatanaaka kauquqi kairamanta vika tinavu ekaa aru taiqa kaate tirae, tinavu maini viri kaaro? Oho, tenavu Isareri kia Kenaanini aniraiti, Iotani Namari hini mantaraini mini variataarave. ");
INSERT INTO tbg_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Mpo, Noravauvo, Isareri iqoka vaiinti navutaaka aatu qetake aiqu autute aniara kaara te nana uvae tiainarave? ");
INSERT INTO tbg_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Kenaani vatanaakavata, vo vatanaaka maini variakavata, vi uvara iri, viraqaahai vika ani tinavu ututumate aru taiqama kevarave. Vika tinavu ai vaiinti nahenti aru taiqake ariara tiha, Isareri vika variqavano kia nai vaiinti nahenti antua nimitaivo, tivarave. Hauri vika minti tivakeha ai nora autu vatainiqama kevorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Minti tuvaro Noravano Kotiva Iosuaarara tiharo, Himpuane. Nantiharae are vataini hiqintira variaro? ");
INSERT INTO tbg_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Are iriane. Isareri qora okarama ti autu timitaavo. Te kempukaiqamake uva tiva taataute Isareriara tiha, Ierikoqi vaina haikaraqihai kia vo haikavata nentara vararaiti, ekaa haika vehi autu taiqa kaate turamantavata, vika te tuna uvara raqake vo haika muara vare unahaa tiha, Ekaa vi haikara vehi autu taiqa kauro, tivakeha vika vi haikara varatora vuru nái ia haikara hampata vataarave. ");
INSERT INTO tbg_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Mintiara kaara te vika vehi autu taiqa kaariravaqaima vaivo. Vika vehi autuvi taiqa viva vaira kaara vika kia ho nái navutaaka hampata kempukaiqamake raqiraiti, vika qetake aiqu autute aniarave. Ne kia te qioqama tauna haikara vehi autu taiqa kaivera, te kia qaiqaavata ni hampata vaiha ni kahaqamaqi virarave. ");
INSERT INTO tbg_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Ho are oru vaiinti nahenti qerama taira vika hura tuekaamavi ti tivuqaa ho variate. Are vikara tihara, Noravano Kotiva ni Isareri Variqavano niara mintima tivo: Ne Isareri vaiinti nahentivauvo, te niara vo haika kia varaate tivake qioqama tauna haikara ne vi haikara kia vehi autu taiqa karaiti, qaqi vare iavo. Ne vi haikara varaara kia vara qaqini kaivera, ne kiama ho nenta navutaaka naatara kevarave. ");
INSERT INTO tbg_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Ho hura toqaqima ne nora anku, vo anku vo ankuvano te iainanaini aniate. Ne mintiqe te niqihai vo anku kaamate vikara aniate tiari vi ankuka ti aumanto aniate. Te vi ankukaqihai inaara anku vo kaamate aniate tiari vika aniate. Te inaara anku vikaqihai vo naavuqi vo naavuqi variaka kaamate aniate tiari vika aniate. Te vikaqihai vo naavuqi vaika kaamate aniate tiari vikaqihai vaiinti vohaiqa vohaiqavano aniate. ");
INSERT INTO tbg_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Ta vaiintivae te qioqama tauna haikara varainara ne vira rantake, vira nai vainti nahenti hampata aruke, vikavata vira airairavata ihaqohai tatoqa kaate. Vi vaiintiva anomakero qora okara autiharo, Isareri kaurira haika nimivo. Viva mintiharo te Noravano Kotika tenta vaiinti nahenti hampata uva tiva taatau taunara raqa kaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Noravano Kotiva minti tuvaro Iosuaava vaaka toqaqi himpiro Isareri nora anku, vo anku vo anku naarama komanta ani vauvaro ˻Noravano˼ ekaa anku vikaqihairo Iutaara anku naane kaama tomanta vika ani avuni vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Ani vauvaro ˻Noravano˼ Iutaara ankuqihairo Seraara anku kaama tomanta vika ani avuni vauvaro Iosuaava tumanta Seraara ankuqihai vo naavu vo naavuqi vauka vika vohaiqa vohaiqavano ani vauvaro ˻Noravano˼ Sapadira naavuqi vauka kaama tora. ");
INSERT INTO tbg_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Sapadira naavuqi vauka anuvaro Iosuaava tumanta vi naavuraqi vauka vohaiqa vohaiqavano anuvaro ˻Noravano˼ vikaqihairo Akaanira kaama tora. Akaaniva Kaamira maaquvano vauvaro Kaamiva Sapadira maaquvano vauvaro Sapadiva Siraara maaquvano Iutaara ankuqiraava vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Ho Iosuaava Akaanirara tiharo, Ti vaiintio, vate are tinavu Isareri vatanaaka Variqa Nora Kotira avuqaa himpi vaihara, kia una tiraitira, nena autina okarara qoqaa tiva qovarama kaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Iosuaava minti tuvaro Akaaniva vira tiva amiro tiharo, Oho, quqaama te Nora Kotira tinavu Isareri Variqa uva raqakehama qora okara autu kaunarave. Te vi uvara ai tiva amirerave. ");
INSERT INTO tbg_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Tenavu iqoka raqiha Ieriko vatanaaka naatarake vika airaira, vo airaira vo airaira varauna entara, te tavauraro Babironi vatanaaka tavuna koqera aututaava vaivaro, silvaa monu 200vata vaivaro, kori vira maaravano vohaa kilo vairave. Te vi haikara tavauraro ti muntuka ntimanta te ekaa vi haikara vare viri tenta seri naavuqi vata quvike, silvaa monu vevanto vate, ekaa vo haikavata viraqi quntama taunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Akaaniva minti tuvaro Iosuaava vaiinti vokuka nititomanta vika kante Akaanira seri naavuqi oru rantake tavovaro viva tuntema kero, ekaa vi haikava viraqi vaura. ");
INSERT INTO tbg_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Vika ekaa vi haikara vare Iosuaava Isareri hampata vaunaini vuru Nora Kotira avuqaa vatakanta vatora. ");
INSERT INTO tbg_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Ho Iosuaava ekaa Isareri hampata oru Akaanira ravaaqavuke vita vare, viva ekaa haika ura, silvaave tavunave korive vare, vira maaqu raavurave, vira purumakauve donkive sipisipive vare, vira seri naavuvata ekaa vo airairavata vare, muntu Ako Uqitaini kora. ");
INSERT INTO tbg_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Mini kovaro Iosuaava tiharo, Oho, nantivarae are mintihara tinavu Isareri qoraiqama timitaaro? Are mintianara kaarama vate Noravano Kotiva ninavata qoraiqama amitaanarove, tumanta ekaa Isareri vika ori varake Akaanira nai vainti nahenti hampata aruke, vira nai airaira hampata ihaqohai tatoqa kora. ");
INSERT INTO tbg_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Mintimake viraqaahai vika ori airitahaa nuntu ruvaantumake, Akaanira vaataqaa ntava tora. Vika ori nuntu ruvaaqumake ntavatova vate maa entara qaqima vairo. Vaiinti nahenti vi vatara autu nteha Ako Uqitainive – Nora Maara Nimito Uqitarave ti variara. Akaanira arukovaro Nora Kotira arara itova vaahama vura. ");
INSERT INTO tbg_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Noravano Kotiva Iosuaarara tiharo, Kia qetaraitira, kempukaiqama kera variane. Are Isareri iqoka vaiinti ekaa ntita varera oru Ai vatanaaka hampata raquane. Are vika hampata raqi vairaqe te Ai avuhainaaravata, vira vaiinti nahentivata, vatukavata, vatavata, ai amirerave. ");
INSERT INTO tbg_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Are Ieriko avuhainaa vaiintivata Ierikohainaakavata vehi autu taiqa kaanantema kera, Ai avuhainaaravata Aihainaakavata vehi autu taiqa kaane. Ne homa ekaa vi vatanaaka quara vairive airairave varevarave. Ho iqoka raqireva ihara are avuni iqoka vaiinti vokiaka naane nititaira vika oru vatuka vira tauvaqaini vaara autute variate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Minti tumanta Iosuaavavata, Isareri iqoka vaiinti vikavata, Ai vatanaaka hampata iqoka raqireka qera i vaura. Iosuaava nai iqoka vaiintiqihairo iqoka vaiinti tarauka 30,000 kaama tero vika entaqi varakero tiharo, ");
INSERT INTO tbg_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Ne oru vatuka tauvaqaini aumanto vaara autute variate. Ne raqirara iriha qeramate variate. ");
INSERT INTO tbg_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Ne mini oru vaiqe te tenta iqoka vaiinti hampata qoqaa vatukaini virerave. Tenavu vatuka aumanto oruntaari Aihainaa iqoka vaiinti tinavu harireka vatukaqihai aaqaini aniqe tenavu tota unantemake, orurante aiqu autute anirerave. ");
INSERT INTO tbg_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Tenavu qaqi kaari vika tinavu haruqi aniqe tenavu raqu kuntamaqi aniari vika mintima tivarave: Tavaate. Tuvana Isareri qetake vuantemake, vatevata vika aiqu autute kante variavo, tivarave. Ho vika minti tivake nái vatuka mini ke niaraiqamake animanta ");
INSERT INTO tbg_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ne kante vaara aitu vare, vatukaqi variaka naatara kaate. Noravano Kotiva ni Variqavano vi vatukara nima nimianarove. ");
INSERT INTO tbg_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ne vi vatukara utu vare, Noravano Kotiva tintemake, vi vatukara iha quara kaate. Ho ne te tuna uvara iri varema koqemake avataate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Iosuaava minti tivakero nai iqoka vaiinti hini kuka nititomanta vika oru vaara autireka vura. Ai vatukavano hini vauvaro Beteli vatukavano hini vaumanta tavaarana kuari avu ruhunkinaini vika oru vaara autute vaura. Vika mini vuvaro Iosuaava vi entara entaqi Isareri naavu maaqa kaqatonaini vaura. ");
INSERT INTO tbg_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Ho vira qararaa vaaka toqaqi Iosuaava himpiro nai iqoka vaiinti naarama ruvaaquma kero, vivavata Isareri nora vaiintivata iqoka vaiinti vika ntita vare avuni viha Ai vatukainiara vura. ");
INSERT INTO tbg_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Iqoka vaiinti Iosuaara hampata vuka oru vi vatukara nora qentivano vaunaini orunte, vika Ai vatuka noti mantaraini nái seri naavu maaqa kaqa tora. Vika mini vauvaro Ai vatukavano vauvaro uqita vatavano tavaarana vaura. ");
INSERT INTO tbg_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Iosuaava 5,000 vaiinti nititomanta vika vaara autireka Ai vatuka kuari avu ruhunki mantaraini vura. Ai vatukavano hini vauvaro Beteli vatukavano hini vaumanta vika tavaarana oru vaura. ");
INSERT INTO tbg_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Ho avuni vuka qera i vaumanta Ai vatuka noti mantaraini nái seri naavu maaqa kaqatonaini vaukavata qera i vaura. Vi entara entaqi Iosuaava uqita kanta vaireva vura. ");
INSERT INTO tbg_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Ho vira qararaa Ai avuhainaava Isareri iqoka vaiinti vutu tavero, viva vaaka nai iqoka vaiinti ntita varero Isareri hampata raqireva Iotani uqita kanta vura. Viva avuni Isareri hampata mini raqi vaura. Isareri iqoka vaiinti hini kuka vatuka tauvaqaini vaara autute vauvaro, Ai avuhainaava kia vikara iriraitiro, viva nai iqoka vaiinti ntita varero vuvaro ");
INSERT INTO tbg_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Iosuaava nai iqoka vaiinti hampata unaqaraiqama kero aiqu aututero aahara vataini vireva auti vauvaro ");
INSERT INTO tbg_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Ai avuhainaava tavero vatukaqi vau vaiintika ekaa naarama kero tiharo, Ne Isareri aru ntataqi vuate, tumanta vika Iosuaara avataqi vura. Iosuaava mintima kero vika kuntamaqiro vumanta Ai vika nái vatuka mini ke vika ntata vare anura. ");
INSERT INTO tbg_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Ekaa Aihainaa vaiinti vika vatuka ke, kia vaantaavura qentivata tintaraiti, Isareri ntata vare vura. ");
INSERT INTO tbg_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Mintuvaro Noravano Kotiva Iosuaarara tiharo, Nena vaantaara tuahera kera Ai vatuka mantaraini aave vatehara variane. Vate te Ai vatuka ai kauquqi kaainarara tira, are mintiane, tuvaro Iosuaava viva tunte iro, nai vaantaara Ai vatuka mantaraini tuahera kero totero vaura. ");
INSERT INTO tbg_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Iosuaava mintumanta vira iqoka vaiinti vaara autute vauka vira tave, vaaka vaara aiti, vatukaqi oriqete viraqi vau vaiinti nahentika ntaihamake naavu maaqavau iha tutakovaro itora. ");
INSERT INTO tbg_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","21","Mintuvaro Iosuaava nai iqoka vaiinti hampata tavovaro Ai vatukaqihairo iha muravano veraini oru vi vaumanta, vika irumanta nai navunaaka vatukaqi oriqete naavu maaqavau iha qumpiarama tovaro ite vaura. Ite vaumanta vika tuqantaavi Ai iqoka vaiinti ntaihareka orurante qaiqaa anura. Mintumanta Aihainaa iqoka vaiintivata tuqantaavi tavovaro iha muravano veraini oru vi vaumanta vika tavovaro vika ruqemake vi aarava kia vaura. ");
INSERT INTO tbg_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Isareri iqoka vaiinti vatuka avutaqi oriqetoka vevante Aihainaa iqoka vaiinti ntaihareka hihai anumanta, Isareri vokuka hihai anumanta Aihainaa iqoka vaiinti avutana vaumanta, Isareri vika ekaa aru taiqa kovaro kia Aihainaa iqoka vaiinti voqavanovata qaqi vauvaro kia voqavanovata ruqema kero vura. ");
INSERT INTO tbg_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Isareri vika aru taiqake Ai avuhainaa vaiintiqai kia arukaraiti, vira vita vare Iosuaava vaunaini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Aihainaa iqoka vaiinti vika Isareri aahara vataini ntataqi vumanta Isareri vika tuqantaavi Aihainaa iqoka vaiinti ekaa aru taiqa kovaro kia voqavanovata qaqi vaumanta, viraqaahai Isareri vika Ai vatukaini orunte, viraqi vau vaiinti nahentikavata ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Vi entara Isareri vika Ai vatukaqi vau vaiinti nahentika 12,000 ekaa arukora. ");
INSERT INTO tbg_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Iosuaava nai vaantaara kia nanta muntuvi karaitiro, vira qaqi tuahera kero Ai vatuka aave vate vaumanta, Isareri vika viraqi vau vaiinti nahentika ekaa vehi autu taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Noravano Kotiva Iosuaara tiva amuntemake, Isareri vika vi vatukaraqihai quara vairive vo airaira vo airairave nariara varora. ");
INSERT INTO tbg_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Iosuaava Ai vika naavu maaqa ihaqohairo tatoqa taiqa kovaro kia vovanovata vi vatukara qaiqaa autu kora. Vate maa entara naavu kaqato oriva vo ori vo orivano kiri kairiro mini vairo. ");
INSERT INTO tbg_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Iosuaava Ai avuhainaa vaiinti arukero vira vaata katariqaa hiritovaro mini variqiro viro entama kora. Entama vuvaro Iosuaava tumanta vira vaata viquke vare muntu vatuka qentiana aquke, ori airitahaa nuntu ruvaaqumake avuhainaa vaiinti vira vaataqaa ntava tora. Vi orira ntavatova maa entaravata qaqima mini vairo. ");
INSERT INTO tbg_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Ho viraqaahairo Iosuaava oru Ebaali Aiqinaqaa Isareri Variqa Nora Kotira ofaa tainta vo autu amitora. ");
INSERT INTO tbg_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Nora Kotira kaiqa vaiinti Mosiva tuntemakero, Iosuaava vi taintara aututora. Haaru Mosiva vi uvara tivakero vukuqi qara ntuva tova mintima tiro: Ne ofaa tainta autihama kiama ainiqohai toqate orira varake autiraiti, qaqi ori varake vira autuate, tura. Iosuaava vi uvara iriharo vi taintara aututomanta vika viraqaa ofaa vo, Nora Kotira kaintu iha quara amite, Nora Kotikanti vohaa vairara iriha ofaa vovata iha quara amitora. ");
INSERT INTO tbg_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Ho vi entara Isareri Iosuaara tave vauvaro viva Kotiva Mosiraqaa tivato uvara qara ntuvatora varakero, vo ori tanuqiraqaa qaiqaa vi uvara qara ntuvatora. ");
INSERT INTO tbg_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Ekaa Isareri nora vaiintive, iqoka vaiintiqaa raqiki vaukave, iasinavuve, vo vatanaaka Isareri hampata vaukave, vika Noravano Kotiva uva tiva taatauto Vokisera tataaqa hini hini himpi vaura. Vika himpi vaumanta Rivaira anku Kotira kaiqa vara amite vauka vi Vokisera aqu vare vika avuni himpite vaura. Hini vaiinti nahenti himpi vaunaini Gerisimu Aiqinavano vika tauvaqaini vauvaro, hini vaiinti nahenti himpi vaunaini Ebaali Aiqinavano vika tauvaqaini vaura. Haaru Nora Kotira kaiqa vaiinti Mosiva Isareri tiva nimiro tiharo, Ne mintimake himpi vaiqe te kauqu aave vataariraro Kotiva ni koqema nimitaarire, tuntemake vika himpite vaura. ");
INSERT INTO tbg_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Vika himpi vauvaro Iosuaava Kotiva tivato uvara Mosiva qara ntuvatora kaara nti vaumanta vika iri vaura. Iosuaava Kotiva vaiinti nahenti koqema nimitaaina uvarave, vika qoraiqama nimitaaina uvarave, Kotiva ekaa uva tivatora kaara ntuva nimitora. ");
INSERT INTO tbg_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Ho Iosuaava Mosiva qara ntuvato uvara kaara ntiharo kia vo uvavata qaqira karaitiro, ekaa vi uvara kaara nti vaumanta ekaa Isareri, vaiintive, nahentive, vaintive, vikavata vo vatanaaka Isareri hampata vaukavata, ekaa mini ruvaaqumavi vaiha vi uvara irura. ");
INSERT INTO tbg_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ehutiva qutu vumanta Isareri vika qaiqaa Nora Kotira qora kaiqa vara amitora. ");
INSERT INTO tbg_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Mintuvaro vira kaara Kotiva Jabinira qaqi kovaro viva vika naatara kora. Jabiniva Kenaani avuhainaava vovano vaiharo Haso vatukaqaa raqiki vauvaro vira iqoka vaiintiqaa raqikuva Siseraava Haroseti-Hagoimi vatukaihainaava vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Jabiniva iqoka kaari ainiqohai aututora 900 vatova viva Isareriqaa raqikiharo vika kia aaqurihama nimitaraitiro, 20 ihiara qoraiqama nimiteharo vikaqaa nora maara vataqiro vura kaara Isareri vika Nora Kotirara tinavu kahaqiarire ti, vira aare vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Vi entara Lapidotira naata paropeti nahenti Deboraava vaiharo Isareriqaa raqikiharo vika uva avuqavu i vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Viva deti katari okara oquvi vaumanta Isareri viva unaini aninte nái uva viraqaa avuqavu i vaura. Vi katariva Ramaa vatukavata Beteli vatukavata avutana Efaraimu aiqina vaunaini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Vo enta Deboraava Abinoamira maaqu Baraakira Napataari vataini Kedesi vatukaini vaura aaramakero virara tiharo, Tinavu Noravano Kotiva ariara mintima tivo: Oru Napataarika Sebulunika ankuqihaira 10,000 vaiinti ntita kera Tabo Aiqinaqaa vuru kaira variate. ");
INSERT INTO tbg_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Mini vuru kairamanta vaiqe te Jabinira iqoka vaiintiqaa raqiki vaira Siseraara kuntama vare viri kaariraro viva ai hampata Kisoni Namari vainaini raquarire. Viva nai iqoka kaarivata nai iqoka vaiintivatama kero aniraqe te vika ai kauquqi vatarerave, tivo tiro. ");
INSERT INTO tbg_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Minti tuvaro Baraakiva vi uvara iriro viva Deboraarara tiharo, Are tintira anirera, te virerave. Are kia tintira anirera, te kia virerave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Deboraava tiharo, Hove te ainti virerave. Are minti tianara kaara are iqoka aatarakera kiama are nena nora autu varenarave. Noravano Kotiva Siseraara nahenti kauquqima vataanarove, tivakero Deboraava Baraakikantiro Kedesi vatukaini vura. ");
INSERT INTO tbg_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Mini vuvaro Baraakiva Sebulunika Napataarika ankuqihairo 10,000 iqoka vaiinti naaramakero ntita varero raqireka vuvaro Deboraavavata vira hampata vura. ");
INSERT INTO tbg_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Vi entara Hebeva Kini vataihainaava nai navunaaka kero, katu varero oru Kedesi vatuka auvahini, Sananimini oqiva okara nai seri naavu kaqa tora. Kini vatanaaka vaireka, Mosira aituara Hobaapira naintivara vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Ho Siseraava Baraakiva Tabo Aiqinaqaa vivo tu uvara iriro, ");
INSERT INTO tbg_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","viva iqoka kaari ainiqohai aututora 900 varero, ekaa nai iqoka vaiintivata naaramakero ntita varero Haroseti-Hagoimi kero, Kisoni Namari vaunaini vuvaro ");
INSERT INTO tbg_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Deboraava Baraakirara tiharo, Ho iqoka raquane. Vate Noravano Kotiva ai avuni viharo viva Siseraara ai kauquqi kaanarove, tuvaro Baraakiva nai 10,000 iqoka vaiinti ntita varero Tabo Aiqina kero vura. ");
INSERT INTO tbg_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Baraakiva nai iqoka vaiinti hampata oruntero iqoka hoqarama tovaro Noravano vira navutaaka qetara haika nimiro vika avu aato hampiqama komanta Siseraaravata ekaa vira iqoka kaariqi vaukavata vira iqoka vaiintivata vika vaaka ruqemake vi ani vaura. Siseraava paparuqiharo nai iqoka kaari mini kero vataqaa qeta kero vuvaro ");
INSERT INTO tbg_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Baraakiva iqoka vaiintivata iqoka kaarivata ntataqiro Haroseti-Hagoimini vuru komanta Baraakira iqoka vaiinti vika Siseraara iqoka vaiinti ekaa aru taiqa kovaro kia voqavanovata qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Siseraava ˻vataqaa˼ ruqemakero Jaelira seri naavu vaunaini oruntora. Jaeliva Kinihainaara Hebera naatavano vauvaro vi entara King Jabiniva Hasora avuhainaava Hebera navunaaka hampata maateraiqiharo vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Jaeliva tavovaro Siseraava anuvaro viva vira vitakareva veva ntero Siseraarara tiharo, Ti nora vaiintio, naavuqi uriqetaane. Kia qetaraitira, ti seri naavuqi uriqetaane, tuvaro Siseraava viraqi oriqetovaro Jaeliva paraanke varakero vira kukeqa tovaro ");
INSERT INTO tbg_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Siseraava nahentiara tiharo, Ti namari naataa ivo. Namari ti timiraqe naare, tuvaro Jaeliva memeraa naama vira amuvaro novaro Jaeliva qaiqaa vira vara kukeqa tora. ");
INSERT INTO tbg_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Siseraava nahenti virara tiharo, Ho are seri naavu qentiana vaihara tavairaro vo vaiintivano anintero ai ireharo, Vovano viraqi vairove? tirera, are kiavema tiane, ");
INSERT INTO tbg_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","tivakero vaata popohovaro viva vaita aavata vura. Vaita aavata vuvaro Jaeliva hamaavata seri naavu nirivata varero, Siseraava vaitonaini evaara oruntero hamaaqohairo niri vira vuahaaraqaa ruqutu kovaro nirivano vuahaaraqi otiqetero qaqini otu vatavata qumputaata aru tovaro Siseraava qutu vura. ");
INSERT INTO tbg_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Ho Baraakiva Siseraara rantareva anuvaro Jaeliva vira vitakareva vevantero virara tiharo, Aniraqe te are vi vaiintirara rante varianara ai umiqaare, tuvaro Baraakiva vikantiro seri naavuqi oriqetero tavovaro Siseraava vataqaa qutu viro vauvaro vuahaaraqi niri arutova qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Vi entara Kotiva Isareri kahaqimanta vika Jabinira Kenaani avuhainaa vaiinti aatara kora. ");
INSERT INTO tbg_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Isareri vika qaiqaa qaiqaavata Jabinira hampata raquqi vivi, ekaara vira vehi autukora. ");
INSERT INTO tbg_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Qaiqaa Isareri vika Kotira uva raqake qora kaiqa vare vauvaro vira kaara Noravano Kotiva vika Midiani vatanaaka kauquqi komanta vi vatanaaka 7 ihinavu variqi viha Isareriqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Midiani vika kempuka voqavata vaumanta vika Isareri qoraiqama nimitaqi vi vaumanta Isareri nora maara vare vaura. Mintura kaara Isareri vika qetake aiqinaini oru onavuqive, vonaini kia ho vika vaaka rantakenainive, kukeqavi vaura. ");
INSERT INTO tbg_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Isareri kara ututo entara vaakama Midiani vatanaakave, Amareki vatanaakave, kuari avu urunaihai vokukave, vika Isareri hampata raqireka ani ");
INSERT INTO tbg_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Isareri vataqaa nái seri naavu maaqa kaqate vi aniha, Isareri naaho maata qantuke vareha, vika naaho maata qoraiqama nimite vaura. Vika mintiaqi vivi, muntu Gasa vatuka auvahini vau naaho maataravata qoraiqama nimitora. Vika Isareri sipisipive, purumakauve, donkive, ekaa vare, kia vo haikavata qaqi kovaro Isareri kara nái nevavata kia vaumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Korika airitahaa ani variantemake, navutaaka airitahaa ani Isareri vataini nái seri naavu maaqa kaqate vaura. Vika vaiintive, purumakauve, kamerive, airitahaa vauvaro vika kaara ntiva kia ho vaura. Vika Isareri vatave, naaho maatave, qoraiqama nimite vaumanta ");
INSERT INTO tbg_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Isareri nora maara varaqi vivi, viraqaahai vika Kotira aareha tinavu kahaqiane tura. ");
INSERT INTO tbg_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Midiani vatanaaka Isareri voqamake qoraiqama nimite vaumanta Isareri vika Kotira aareha tinavu kahaqiane tuvaro ");
INSERT INTO tbg_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","Kotiva paropeti vaiinti vo atitovaro vi vaiintiva Isareri vikara tiharo, Noravano Kotiva ni Isareri Variqavano niara mintima tivo: Haaru Isipi vatanaaka ni rumpa tomanta ne vika kaiqa vare vaumanta te vi vataraqaahai ni ntita vare aniavaunarave. ");
INSERT INTO tbg_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Te Isipi vatanaaka kauquqihaive, vo vatanaaka ni hampata iqoka raquqi vi vauka kauquqihaive, ni ruaruama nimitaavaunarave. Vi entara ne navutaaka hampata iqoka raqi vaumanta te vika ni nivuqaa aru ntata kauramanta ne maa vataraqaa ani vaurave. Te maa vatara ni nimiha ");
INSERT INTO tbg_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","mintima ti: Te Noravano Kotika ni Variqavanoma vauro. Ne maa entara Amo vatanaaka vataqaa variqi viha, kia vika una variqanavu nutu tuahera kaate, tunarave. Te minti turamantavata, ne kia ti uva iriraiti, ne vika una variqanavu nutuqai tuaherake variarave, turave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Paropeti vaiinti viva minti tuvaro vo enta Nora Kotira enselivano vatuka vo Ofaraini otuntero, oqiva okaraini oquviro vaura. Vi vatukaraqi vaiinti vo vira autu Ioaasiva viva Abiesera vohaa ankuvano vauvaro, vira maaqu Gideoniva uiti varakero rintati vaura. Midiani vatanaaka vira tavevorave tiro, Gideoniva kia qoqaa vi kaiqara vararaitiro, viva uaini tava tati vaunaini oru vaiharo uiti rintati vauvaro ");
INSERT INTO tbg_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Nora Kotira enselivano qovarama viro Gideonirara tiharo, Are iqoka vaiinti taruvama variaro. Noravano Kotiva ai vataakero vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Viva minti tuvaro Gideoniva tiharo, Aqao, Noravano Kotiva tinavu hampata vaitirio, kiama vo haika vo haikavano tinavuqaa qovaraiqiharo nora maara tinavu timitirio. Tinavu qokavara tiha, Haaru Noravano nora kaiqa aahuva kaiqa vareharo Isipihairo tinavu kaivaqaukavara ntita vuru korave, tiamanta irunarave. Ho vate maa entara Noravano nora kaiqa vare vaiva tantoe vaivo? Mpo, viva tinavu qaqira kero, Midiani vatanaaka kauquqi tinavu tuta kaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Gideoniva minti tuvaro Noravano Kotiva virara tiharo, Are nena kempukaqohaira oru Midiani vatanaaka kauquqihaira Isareri ruaruama nimitaane. Tema ai atitauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Minti tuvaro Gideoniva tiharo, Mpo, Noravauvo, te nantiakee oru Isareri ruaruama nimitararave? Manasera ankuqihai tinavu ankuvano anomakero uqerara ankuma vaivo. Te tenta qata vakaukaqihai qaqi qumina vaiintima vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Gideoniva minti tuvaro Noravano Kotiva virara tiharo, Te ai vataake variainarara tira, are vohaa vaiinti aatara kenantema kera, are ekaa Midiani vatanaaka naatara kenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Minti tuvaro Gideoniva tiharo, Mpo, are quqaa tiriara quahairera, vo haika humiqairaqe te vi haikara tavehama ariara quqaama Noravano tiriara minti tivo tiare. ");
INSERT INTO tbg_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Ho kia vaaka viraitira, maini vairaqe te oru kara qerama vare viri ai amitaare, tiro. Minti tuvaro Noravano Kotiva ˻enseli vira noqihairo˼ tiharo, Te maini ai vekama vairarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Minti tuvaro Gideoniva nai naavuqi oriqetero memeraa naati unta kero, vorusi vira maara 10 kilo vaura varakero, viraqohairo kia noqavu mparetira untakero vatero, viraqaahairo viva memeraa mati untatora rutantuto utaraqi vatero, mati vira namarivata taveqi qihiakero, ekaa vi karara varero Nora Kotira enselivano oqiva okaraini oquviro vaunaini vuru vira amura. ");
INSERT INTO tbg_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Vira amuvaro Nora Kotira enseli viva tiharo, Are mativata mparetivata nora ori maaqaa vatera, mati vira namari taveqihaira kara viraqaata raurutaane, tuvaro Gideoniva viva tunte ura. ");
INSERT INTO tbg_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Mintuvaro Nora Kotira enseli viva nai kauquqi tuato kaururaqohairo mativata mparetivata viti autama kovaro vaaka oriqaahairo ihavano aurumaviro mativata, mparetivata tatoqa taiqa aqukora. Mintima kovaro enseli vivavata Gideonira avuqaahairo tuqaaka/uqaarama vura. ");
INSERT INTO tbg_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Mintuvaro Gideoniva kankoma kero iriro tiharo, Te Nora Kotira enseli vataakema uva turo, tuvaro vira aatu itovaro tiharo, Ike, Noravauvo, are ekaa haikaqaa raqiki variaravama variaro. Oho, te ai enseli aaqanto vaiha vira viri tavauro, tuvaro ");
INSERT INTO tbg_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Noravano Kotiva virara tiharo, Ai muntukavano qihaaqirara variane. Kia qetaane. Are kiama qutu vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Minti tuvaro Gideoniva vi vatukaraqaa Nora Kotirara iriharo ofaa tainta vo autukero vatero, vi taintara autu ntero tiharo, Noravano Kotiva Muntuka Qihaaqamake Vaiva Vairave tura. Vate maa entara vi taintava Abiesera anku vika vatuka Ofaraini qaqima vairo. ");
INSERT INTO tbg_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Ho vohaa vi entara entaqi Noravano Kotiva Gideonirara tiharo, Are oru nena qora purumakau qora 7 ihi varakaira varaane. Ai qova una variqa Baalirara iriharo ofaa tainta autukero vataira, vira rampaikera, vira tataaqa una nahenti variqa Aseraara maraqura vai pohira nkaurutaara, vi pohira teqa kera, ");
INSERT INTO tbg_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","qoqaraara vi vatukaraqaa ofaa tainta vo, naitarama kera autukera vatera, viraqaahaira purumakau vira arukera ofaa tainta viraqaata kaintu iha quara timitaane. Aseraara pohi, vira ruvarikera viraqohaira purumakau vira iha quara timitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Noravano Kotiva minti tuvaro Gideoniva nai kaiqa vaiinti 7navu ntita varero oru Noravano tunte ura. Viva nai naavuqi vaukavata, vi vatukaraqi vokuka vaukavata, vika naatu qeteharora tiro, viva kia vi kaiqara aatitoraqaa vararaitiro, entaqi varora. ");
INSERT INTO tbg_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Entaqi vi kaiqara vara komanta vira qararaa vi vatukaraqihainaaka himpi oru tavovaro una variqa Baalira ofaa taintavano kia vauvaro una variqa Aseraara pohivanovata kia vauvaro vi vatukaraqaa qaraaka ofaa taintavano vauvaro viraqaata purumakau qora iha quara tovaro ite vaura. ");
INSERT INTO tbg_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Mintumanta vika vira tave, nai ire nai ireha tiha, Tavave maa haikara autu kaivo? tumanta vokuka tiha, Joaasira maaqu Gideoniva vi kaiqara autu kaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Minti tumanta vika Joaasirara tiha, Nena maaqu vita veva kairaqe tenavu vira arukaare. Viva Baalira ofaa tainta rampai aqukero, Aseraara pohivata teqa aqu kaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Vika arara itomanta minti tuvaro Joaasiva aqao tiro, Ne Baalira kahaqirekae antua uva ti variavo? Ne Baalira ruaruama amitarekae aniavo? Nai ta vaiintivae Baalira kahaqireva autiharo iqoka raqirera, vi vaiintiva toqaqi kia kuarivano urinaraqaa qutu vuanarove. Baaliva quqaa variqavano vairera, ne vira qaqi kaivaro viva naivano nai ofaa tainta rampai kainara aru vuntu kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Ioaasiva minti tumanta vi entaraqaahai vika Gideonirara qaraaka autu nteha tiha, Ieru-Baalirave tura. Vi autura maa uvaraqihai tirera: Qaqi kaivaro Baaliva nai aru vuntuarire, tura. Gideoniva Baalira ofaa tainta rampaikorara ti, vika minti tura. ");
INSERT INTO tbg_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Vi entara Midiani vatanaakavata, Amareki vatanaakavata, vo vatanaa mini vaukavata, ekaa vika avitumavi vohaaraqi vaiha iqoka raqireka Iotani Namari taqa vare Isareri vataini ani, Jeseriri Uqitaini nái seri naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Vika mini vauvaro Kotira Maraquravano ani Gideonira vataakero vauvaro Gideoniva aanumaara/noma vuaqa keharo nai navunaaka Abiesera anku naarama kora. ");
INSERT INTO tbg_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Viva vo vaiintinavu nititomanta vinavuka Manasera ankuvano vaunaini vi aniha vaiinti naaramake, viraqaahai Asera ankuvata, Sebulunira ankuvata, Napataarira ankuvata, vaunaini vi aniha vaiinti naarama komanta, vika hihai hihai Gideoniva vaunaini anura. ");
INSERT INTO tbg_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Mintuvaro Gideoniva Kotirara tiharo, Are tiriara tihara, Te ai atitaarirara arema Isareri vatanaaka ruaruama nimitenarave, tiana uvara, te vi uvara avateha tavarerave. ");
INSERT INTO tbg_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Tenavu uiti rintatunanaini te oru sipisipi kauki toqakaunara vataqaa vate ˻ani vaite˼, hura toqaqi qaiqaa oru kauki vira tuantike tavarerave. Te tavaariraro varavuvano kauki vira putaiqama kairaro vira tataaqa vaina vatava qaqi aahara vairera, te kankomake virara iri, ariara tiha, Quqaama viva ti kahaqiraqe te Isareri ruaruama nimitararave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Minti tivakero viva ˻sipisipi kauki vuru vatero ani vaitero˼ vira qararaa toqaqi viva himpiro oru tavovaro sipisipi kauki viva Kotirara tuntema kero vaura. Gideoniva oru sipisipi kauki vira varakero tati kovaro varavu namarivano tanu vo mpiqa kora. ");
INSERT INTO tbg_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Tanu vo mpiqa kovaro Gideoniva qaiqaa Kotirara tiharo, Mpo, kia ti titiane. Are ti qaqi kairaqe te vo uvavata tiare. Are ti qaqi kairaqe te qaiqaa sipisipi kaukiqohai are tiana uvara avateha tavaare. Qaiqaa vatevata are qaqi kairaro sipisipi kaukivano aahara vairaro varavuvano ekaa vata putaiqama kaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Minti tuvaro entaqi Kotiva Gideoniva tunte ura. Sipisipi kaukivanoqai aahara vauvaro ekaa vatavano putaiqama vura. ");
INSERT INTO tbg_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Vo enta vaaka toqaqi Gideoniva, vira vo autu Ieru-Baaliva, vivavata vira aiquantakaa vukavata oru Haroti Ruvu Namari tataaqa nái seri naavu maaqa kaqate vaura. Vika mini vaumanta Midiani vatanaaka muani More Aiqina auvoqi nái seri naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Mini vauvaro Noravano Kotiva Gideonirara tiharo, Ai iqoka vaiinti airitahaa variavo. Vika mintimake vaiqe te vika kahaqiari Midiani vatanaaka naatara kaivera, te vika kahaqiainarara tauruke tiha, tenavu tentanavu kempukaqohai navutaaka naatara kauro, tivakeha nái mahutaqaima tivarave. ");
INSERT INTO tbg_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Vika minti tivorave tira, are vikara mintima tiane: Niqihai vonavu navutaaka naatu qetaivera, ne homa anirante nenta maaqaini viqe tenavu hini kiarirauka maini Gileaati Aiqinaqaa vairerave tiane, tiro. Noravano Kotiva minti tuvaro Gideoniva viva tunte iro vika tiva nimumanta 22,000 vaiintinavu qaqirake nái maaqaini anirante vumanta 10,000 vaiintinavu kia viraiti, qaqi mini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Ho qaiqaa Noravano Kotiva Gideonirara tiharo, Ai iqoka vaiinti qaqiqaima airitahaa variavo. Are vika ntita varera namarivano tuvinaini otu vairaqe te vika raira amitaare. Te vo vaiintiara vira vitaane tiarirara are vira vitaane. Te vo vaiintiara vira atitairaro vuarire tiarirara are vira atitairaro vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Minti tuvaro Gideoniva nai iqoka vaiinti ekaa ntita varero namari tuvunaini otuntero vauvaro Noravano Kotiva qaiqaa tiharo, Vaiinti vonavu vairi aanante namari mpuike neka rairakera vo kanta vatera, vokiaka tori kauru aravi vaiha namari neka vika rairakera vo kanta vataane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Minti tuvaro Gideoniva tavomanta 300 vaiintinavu nái kauquqi namari kaqake mpuike ne vaumanta ekaa hini kuka tori kauru aravi vaiha namari ne vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Vika mintuvaro Noravano Kotiva Gideonirara tiharo, Ho namari maaqiriqohai mpuike naa vaiintika 300navuma variavo. Te vinavukaqohai ai ruaruama amiteha Midiani vatanaaka ai kauquqi karerave. Are ekaa vo vaiintinavuara nenta maaqaini anirante vuate tiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Minti tuvaro Gideoniva ekaa Isareri vaiinti hini kuka nái maaqaini nititero, 300 vaiintinavuqai qaqi tuatero viva ekaa hini kuka ura karavata aanumaaravata varora. Ho Isareri seri naavu maaqa kaqatova vuruni vauvaro Midiani vatanaaka seri naavu maaqa kaqatova muani uqitaini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Mintima vauvaro vi entara entaqi Noravano Kotiva Gideonirara tiharo, Himpira otu Midiani seri naavu maaqa kaqa taanaini iqoka raquane. Te ai kahaqiarirara are homa vika naatara kenarave. ");
INSERT INTO tbg_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Are vika aatu qetehara kia vika hampata iqoka raqirera autirera, are nena kaiqa vaiinti Puraara vita varera Midiani seri naavu maaqa kaqa taanaini otu vaihara, ");
INSERT INTO tbg_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","vika nai tiva ami nai tiva ami i vai uvara iriane. Are vika ti vai uvara iriraro ai muntukavano paru irara are kia qetaraitira iqoka homa raqinarave, tiro. Minti tuvaro Gideoniva nai kaiqa vaiinti Puraara vita varero Midiani seri naavu maaqa kaqatora aaqaini otu vura. ");
INSERT INTO tbg_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Midiani vatanaakave, Amareki vatanaakave, vo vatanaaka aahara vataqaa vaukave, vika korika airitahaa vohaaraqi ukuvi aniantemake, Isareri vataini ani vaiha, nái seri naavu maaqa uqitakanta vo kanta vo kanta kaqate vaumanta, vika kamerivata airitahaa nampisini airi nuqa vaira voqaara vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Ho Gideoniva mini otuntero ampeqiharo iruvaro vaiinti vovano nai taira tavorara nai kena vaiinti tiva ami vaura. Vi vaiintiva nai kena vaiintiara tiharo, Mpo, te taira tavauraro baaliqohairo untatai mparetiva, kamporivano koviri kaavirimaqiro tuviro tenavu Midiani vatanaaka seri naavu maaqa kaqataunaraqi tuvu seri naavu vo paama tivakero ruqutu ravantau kaivaro vataini vairave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Minti tuvaro vira kena vaiintivano tiharo, Oho, mpareti vira okaravano vaireva, viva Isareri vaiinti Joaasira maaqu Gideonira iqoka paipeve. Vira okaravano kiama vo haikara vaivo. Kotiva ekaa tinavu Midiani vatanaakavata vo vatanaakavata Gideonira kauquqima kaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Vitanta minti tuvaro taira tavoravata vira okaravata Gideoniva iriro, viva tori kauru araviro Kotira autu tuahera kero, viraqaahairo oturantero Isareri seri naavu maaqa kaqatonaini uruntero tiharo, Ho himpiqenavu vuare. Vate quqaama Noravano Kotiva tinavu kahaqiraqe tenavu Midiani vika naatarama kararave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Minti tivakero viva nai iqoka vaiinti 300 navu taaramo ankuqaa rairakero vatero, aanumaaravata/nomavata, vataqohai aututo taveravata, vika vohaiqa vohaiqa nimura. Ekaa taveqi viva ova iha ite vauravata vatero vika vohaiqa vohaiqa nimiro, ");
INSERT INTO tbg_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","vika tiva nimiro tiharo, Ne ti tave vaiqe te vika seri naavu maaqa kaqataara aaqaini otu ntaari nevata te iainante iate. ");
INSERT INTO tbg_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Te tenta iqoka vaiinti hampata aanumaara vuaqaari nevata aaqaini voqi voqi vaiha nenta aanumaara vuaqake viraqaahai naverai tiha, Tenavu Nora Kotika Gideonika iqoka vaiintima vauro, tiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Minti tivakero Gideoniva nai anku 100 navu hampata viro vika seri naavu maaqa kaqatora aaqaini otu ntora. Enta tavaaraiqireva umanta Midiani maimaraara raqiki vauka hininavu vaitareka vumanta, vika vatuka vo vaiintinavu maimaraara raqikireka ani vaumanta, Gideoniva nai iqoka vaiinti hampata otunte nái aanumaara/noma vuaqake, nái tave vare vura rukavu komanta ");
INSERT INTO tbg_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","vo ankutantavata vika voqaantemake, voqi voqi aaqaini vaiha nái aanumaara/noma vuaqake, nái tave vare vuravata rukavu kora. Vika nái kauqu kaanaaqaini ova tuate, nái kauqu tanaraini aanumaara/noma tuate, naverai tiha, Tenavu Nora Kotika Gideonika iqoka vaiintima iqoka paipe tuateha vauro, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Minti tivakeha vika ekaa aaqaini himpite vaumanta vika navutaaka qetakeha oi aai tivaqi viha aiqu autute kantama vura. ");
INSERT INTO tbg_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Gideonira iqoka vaiinti 300navu nái aanumaara/noma vuaqe vauvaro Noravano Kotiva vika navutaaka avu aato hampiqama komanta vika nái paipeqohai nai ari nai ari i vaura. Vika mintiaqi viha kantamaqi vivi, Saretaani vatuka tataaqa Beti-Sitaini vi, vihai Tabaati tataaqa Abeli-Mehola vatukaini oruntora. ");
INSERT INTO tbg_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Vika qetake aiqu autute kantama vuvaro Gideoniva uva vara komanta Isareri vaiinti Napataarira ankuve, Asera ankuve, ekaa Manasera ankuve, vika Midiani vatanaaka ntataqi viha aruqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Qaiqaa Gideoniva uva vara kovaro aiqinaini Efaraimura ankuvano vaunaini vura. Gideoniva vikara mintima tiro: Nevata Midiani vatanaaka hampata raqireka tuvuate. Ne naane avuni Iotani Namariqaavata, vo namari vo namariqaavata maimaraara raqikiqi vivi, Beti-Bara vatukaini otu ntaate. Midiani vatanaaka mini namari taqa vare vivorave, tiro. Minti tumanta vika vi namarinavuraqaa maimaraara raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Vika Midiani vatanaaka avuhainaa vaiinti Orepika Sepika ravaaqavu kora. Vika Orepira ori vo vaunaini aruke, vi orira autu nteha Orepira-Orive tura. Vika Sepira uaini tati vauraqi aruke, uaini tatura vira autu nteha Sepira-Uaini-Taturaqive tura. Viraqaahai vika Midiani vatanaaka qaqiqai aru ntataqi vivi, viraqaahai vika Sepira qiatavata Orepira qiatavata vare, Gideoniva Iotani Namari vaunaini muntu amura. ");
INSERT INTO tbg_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Qaiqaa Isareri vika Nora Kotira uva raqaqi vura kaara Noravano qaqi komanta Pirisia vatanaaka 40 ihiara vikaqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Vi entara vaiinti vo, vira autu Manoaava, Sora vatukaqi vaura. Viva Daanira vohaa anku vauvaro vira naatavano qaqi naahiara/qururaiqama viro kia vainti vataraitiro, vaura. ");
INSERT INTO tbg_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Noravano Kotiva atito enseliva vira avuqaa qovarama viro tiharo, Are naahiara/qururaiqama vira kia vainti vataraitira variarava, are vainti taiqama vira qorainti vainti vatatenarave. ");
INSERT INTO tbg_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Virara irihara raurihara variane. Kia uainive, vo iha namarive, naane. Kotiva qioqama tai karara kia naane. ");
INSERT INTO tbg_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Ai maaquvano Kotiva kaama taina kaiqara varaarira vaiintivama variainarara ti, vira vatatena entaraqaahai kia vira qiata kauhi toqa kaate. Viva Pirisia kauquqihairo Isareri ruaruama nimitaina kaiqara hoqarama taanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Minti tuvaro nahenti viva vuru nai vaati tiva amiro tiharo, Kotiva atitai vaiintiva te unanaini anitairave. Vira virivano Kotira enseli viri voqaara vaivaro ti haatu itairave. Te kia virara taihairae aniaro? turaro viva kia nai autu ntava timivo. ");
INSERT INTO tbg_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Viva kia minti tiraitiro, tiriara tiharo, Are vainti taiqama vira qorainti vainti vatatenarave. Raurihara variane. Vira vatatena entaraqaahairo ai maaquvano nai qaqi vaina entara Kotiva kaama taina kaiqara varaqiro vuainarara tira, are kia uainive, vo iha namarive, naane. Kotiva qioqama tai karara kia naane tirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Minti tuvaro Manoaava Nora Kotira aarero tiharo, Mpo, Noravauvo, qaqi kairaro are atitaana vaiintiva qaiqaa orurantero tetanta iainanaini tuvu titanta uva tiva timiraqe tetanta naantiara vatataaina vaintira koqemake raqiki variariraro noruqama vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Minti tuvaro Kotiva Manoaava tunte uvaro enseli viva orurantero nahentivano naahoqi vauraqi tuvura. Viva tuvuvaro vira vaativano kia vikantiro mini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Enselivano tuvu ntovaro nahentivano kantero nai vaati tiva amireva oruntero virara tiharo, Ike, viva tuvu vaivo. Ti avuqaa qovaramavi vaiintiva qaiqaa tuvu ntaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Minti tuvaro Manoaava himpiro nai naata avata varero, vi vaiintiva vaunaini oruntero vira irero tiharo, Are ti naatantira uva tiaravae variaro? tuvaro viva tiharo, Te maa vikave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Minti tuvaro Manoaava vira irero tiharo, Ho ai uvavano vivau vaina entara tetanta nana kaiqae vira umiqaqi virarave? Viva nana kaiqae varaqiro vuanarove? tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Minti tuvaro Noravano atito enseliva nai tiva amiro tiharo, Ai naatavano te tiva tauna uvara iriqiro vuarire. ");
INSERT INTO tbg_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Viva uaini tava kia naarire. Viva uainive, vo iha namarive, Kotiva qioqama tai kararave, kia naarire. Viva ekaa uva te vira tiva amunara avataqiro vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Minti tuvaro Manoaava Noravano atito enselirara tiharo, Ho kia vuane. Are qaqi kairaqe tetanta memeraa naati vo ai unta amiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Viva Noravano atito enselira vataakero uva ti vaurara kia kankomakero iruvaro enselivano virara tiharo, Te maini variarera, te kia ai kara narerave. Are vi karara qerama vatairera, Nora Kotira vi ofaara iha quara amitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Minti tuvaro Manoaava Noravano atito enselirara tiharo, Ho nena autu ntairaqe tetanta are tiana uvava qovaraiqiaina entara ai autu tuahera kaare, tuvaro ");
INSERT INTO tbg_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","viva tiharo, Nantivarae ti hutuara iraaro? Ti hutu voqaraa autu vairara tira, are kia ho virara kankomakera irinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Minti tuvaro Manoaava ofaa autireva iharo, memeraa naati vo varakero, uiti vonavuvata varero, Nora Kotira nora oriqaa iha quara amitora. Ho Manoaava nai naatantiro tave vauvaro Noravano Kotiva aahuva kaiqa vara nimitora. ");
INSERT INTO tbg_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Vitanta tave vauvaro ihavano voqamakero iteharo auru vakaa vakaa i vauvaro Noravano atito enseliva ihaqira naaruvaini vura. Manoaava nai naatantiro vira tave, vitanta vataini hiqintivi naitanta viri vataini ke vaura. ");
INSERT INTO tbg_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Manoaara aato kenko tuvaro irivuvaro vi vaiintiva Noravano atito enseliva vaura. Ho enseli viva kia qaiqaavata vitanta avuqaa qovarama vura. ");
INSERT INTO tbg_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Manoaava nai naatara tiharo, Oho, tetanta variqa vo tavaunara kaara qutuma virarave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","vira naatavano aqao tiro, Noravano Kotiva titanta arukareva itirio, viva tetanta ofaa iha quara amitaunara kia varero nai nora kaiqavata kiama titanta humiqaitirio. Viva kiama tiriara are qorainti vainti vatenarave titirio, tura. ");
INSERT INTO tbg_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Ho nahenti viva variro qorainti vainti vatatero vira autu nteharo Samsonirave tura. Vi vaintiva noruqama vuvaro Noravano Kotiva vira koqema amite vaura. ");
INSERT INTO tbg_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Samsoniva Mahane-Daani vatukaqi vau entara Nora Kotira Maraquravano hoqaramatero vira kempukaiqama amite vaura. Sora vatuka hini vauvaro Estaolira vatuka hini vauvaro Mahane-Daani tavaarana vaura. ");
INSERT INTO tbg_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Vo enta Samsoniva Timna vatukaini otuntero tavovaro Pirisia varaata vovano mini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Ho Samsoniva oturantero nai noka qokara tiharo, Te Timnaini vaiha tavauraro Pirisia nahenti vovano vaivo. Netanta vira vite uriqe te vira varaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Minti tumanta vira noka qoka aqao ti, Kiae are tinavu ankuqihairave, tinavu Isareriqihairave, nahenti vo varerava vaivo? Nantivarae are Pirisia vo vatanaakaqihaira nahenti varareva auti variaro? Vika qorainti vaata kia toqake variakave, ti. Minti tuvarovata, Samsoniva nai qorara tiharo, Vi nahentirara ti hantuqa harivo. Are vira otu vite uriraqe te vira varaare, tura. ");
INSERT INTO tbg_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","(Vira noka qoka kia iruvaro Noravano Kotiva Pirisia hampata iqoka qovaraiqiarire tiro, vi avu aatora Samsonira amura. Vi entara Pirisia vika Isareriqaa raqiki vaura.) ");
INSERT INTO tbg_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Ho Samsoniva nai noka qoka hampata Timnaini vura. Vinavuka Timna tataaqa uaini naaho vaunaini otuntovaro vaakama qaraaka raioni vovano Samsonira arukareva noraiqaakero uva tivaqiro anura. ");
INSERT INTO tbg_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Mintuvaro Nora Kotira Maraquravano Samsonira kempukaiqama kovaro viva qaqi nai kauquqohairo memeraa naati tavaara nkahi kaintemakero, raioni vira nkahi kora. Viva raioni arukero kia nai noka qoka tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Mintima kero Samsoniva otu vi nahentira hampata uva ti vauvaro vira antuqavano virara vaura. ");
INSERT INTO tbg_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Ho vo entanavu aitarovaro Samsoniva vi nahentira varareva vura. Viva mini viharo raioni arukora tavareva aara kero oru tavovaro airi bivata hanivata raioni vaataqi vauvaro ");
INSERT INTO tbg_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","viva nai kauquqohairo hani vaqitakero varero aaraini viharo hani vira namaqiro viro oru nai noka qoka qaiqaa ntitakero hani vitantavata nimura. Viva hani raioni vaataqihairo varatora kia vitanta tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Ho vira qova nahenti vira tavareva vuvaro Samsoniva qaraaka vaiinti nahenti varare u okarara avataqiro viharo nora kara vi vatanaaka mini unta nimura. ");
INSERT INTO tbg_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Pirisia vika Samsonira tave, vika qaraaka vaiinti 30navu vira airuqiate ti, viva unaini varakora. ");
INSERT INTO tbg_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Samsoniva vikara tiharo, Kaiqe te uva vo tuqantaake ni tiva nimiare. Tenavu 7 entara maa karara namaqi vi variari ne vi uvara okara ho tiva timivera, te tavuna 30navuvata, utavaaqa 30navuvata ni nimirerave. ");
INSERT INTO tbg_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Ne kia ho vi uvara okara ti tiva timivera, ne tavuna 30navuvata, utavaaqa 30navuvata ti timiate, tumanta vika tiha, Ho vi uvara tuqantaakera tinavu tiva timiane. Are tiraqe iriare, ti. ");
INSERT INTO tbg_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Minti tuvaro viva tiharo, Kara ne vai haikaraqihairo kara naa haikava qovaraiqivo. Kempuka haikaqihairo hiakaa i haikava qovaraiqivo, tiro. Minti tumanta vika taaramo enta aato utuqi viha kia vi uvara okara rantakora. ");
INSERT INTO tbg_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ho 4 entaqaa vika Samsonira naatara tiha, Nena vaatiara uqerara uva tiraro viva vi uvara okara ai tiva amiarire. Are kia mintirera, tenavu ai qora naavu iha umpiarama kaariraro ihavano aivata tatoqa kaarire. Netanta tinavu airaira muara vararekae tinavu haaraavo? ti. ");
INSERT INTO tbg_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Minti tuvaro Samsonira naatavano oru vira avuqaa iqi rateharo tiharo, Mpo, ai kia tiriara hantuqa harivo. Ai muntukavano kia tiriara vaivo. Are ti navunaaka uva tuqantaakera tiva nimira, kia tivata vi uvara okara tiva timira iaro, tuvaro viva aqao tiro, Kia te vi uvara okara tenta noka qokavata tiva nimunarave. Nana kaarae te ai tiva amiainarave? tura. ");
INSERT INTO tbg_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Ho 7 entara nora kara ne vauvaro vi nahentiva ekaa vi entara iqi rataqiro vuvaro ekaara 7 entaqaa Samsonira popohovaro nahenti viva virara qaiqaa qaiqaa nuntu nauntu tivaqiro vura kaara viva uva tuqantaakero tura okara vira tiva amura. Tiva amuvaro nahenti viva nai navunaaka Pirisia tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Mintuvaro 7 entaqaa kia kuarivano ruhunku vumanta vi vatukaraqi vau vaiintika oru Samsonirara tiha, Nana hiakaa i haikava hani uri aatarakaivo? Nana haikavano raioni kempuka uri aatarakaivo? tura. Vika minti tuvaro Samsoniva tiharo, Ne kia ti purumakauqohai vata koraatirio, ne kiama ho vi uvara okara ti tiva timiatirio, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Minti tuvaro Nora Kotira Maraquravano vira kempukaiqama kovaro viva Askeloni vatukaini oruntero, ˻Pirisia˼ vaiinti 30navu arukero vika vaataqaahairo utavaaqa qaqini varakero vi utavaaqara uva okara tiva amuka vuru nimura. Samsonira voqamakero arara ite vauvaro viva nai qora maaqaini oturantero urura. ");
INSERT INTO tbg_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Samsoniva kia vi nahentira vararaitiro qaqirakero vumanta, vika vi nahentira ˻Pirisia˼ vaiinti vo amura. Vi vaiintiva Samsoniva nahenti varo entara vira tataaqa himpite vau vaiintiva vaura. ");
INSERT INTO tbg_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Ho naantiara vo enta uiti teqe vau entara Samsoniva qaraaka memeraa vo varero nai naata tavareva ˻Timnaini˼ vura. Viva mini otuntero nahenti vau rumuraqi virare tuvaro nahenti vira qova qioqama kero ");
INSERT INTO tbg_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","tiharo, Te ariara vira antuqavano kia virara vaivo tivake, vira vo vaiintima amuro. Ho vira aura vo voqavata koqe viri vaata vataavama vaivo. Are homa vira varenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Minti tuvaro Samsoniva tiharo, Oho, te ni Pirisia qoraiqama nimitaarirava ho vaimantara ti, te ni qoraiqama nimitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Minti tivakero viva vevantero oru 300 qaakau vairi ravaaqavukero, vika taaraqanta taaraqanta veka nkuruqama tero, nkuruqama tairaqi ova umpikero ");
INSERT INTO tbg_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","hampakuma tero, vairi vika ruhaaqi komanta, vika Pirisia uiti naaho ututoraqi vi ani vaura. Mintimakero Samsoniva vika uiti iha quara tatoqakora. Ihavano qaqi vau uitirave, teqake vato uitirave, vika uaini naahove, orivi ututorave, ekaa tatoqa kora. ");
INSERT INTO tbg_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Pirisia vira tave tiha, Oho, tavave mintima kaivo? tumanta vokuka tiha, Timnihainaara airaamaqu Samsonivave. Vira airaaviva vira naata vo vaiinti amirave. Vi vaiintiva Samsoniva nahenti varai entara vira tataaqa himpite vai vaiintivave, tumanta Pirisia vika oru Samsonira airaavira naavu iha umpiarate, vira raavuravata nai qokanti iha tatoqa kora. ");
INSERT INTO tbg_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Mintuvaro Samsoniva vikara tiharo, Oho, ne mintiara kaara te kia qaqi vairaiti, ni qoraiqama nimitaqi vivi, ni ekaa qoraiqama nimitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Minti tivakero viva vaana viriviri uvaro vika ntaihemaqiro viviro airi arikora. Vika arukero viraqaahairo viva Etaamu ori onavuqi otu vaura. ");
INSERT INTO tbg_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Ho Pirisia vika oru Iutaa vataini nái seri naavu maaqa kaqate, vi vataraqaa vi aniha oru Lehi vatuka aumanto vumanta ");
INSERT INTO tbg_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Iutaa vaiinti vikara aqao ti, Ne nantihae tinavu harireka auti variavo? tumanta vika tiha, Tenavu Samsonira rumparera anuro. Viva tinavu qoraiqama timitaintemake, tenavu naivata qoraiqama amitarerave, tura. ");
INSERT INTO tbg_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Minti tumanta Iutaa vaiinti 3,000 Samsoniva Etaamu ori onavuqi vaunaini otunte virara tiha, Oho, are kiae irianarave? Pirisia vika tinavuqaa raqiki variakama variavo. Ai okara kaara vika tinavuqaa maara voqavata vatevarave, tuvaro Samsoniva tiharo, Vika ti qoraiqama timitaamanta virara iriha te náivata qoraiqama nimitauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Minti tumanta vika tiha, Tenavu ai rumpa vare Pirisia kauquqi vuru karera tuvuraukave, tuvaro Samsoniva tiharo, Ho ne kauqu aiqiqaa aqukeha kia tenavu ai arukarerave tiate, tumanta ");
INSERT INTO tbg_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","vika tiha, Kia tenavu ai arukarerave. Tenavu ai qaqi rumpa vare Pirisia kauquqi vuru karerave, ti. Vika minti tivake qaraaka naaquntaqohai vira rumpate ori onavuqihai vita vare vura. ");
INSERT INTO tbg_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Vika vivi, Lehi vatukaini oruntomanta Pirisia vika naveraitiha kantamaqi Samsoniva ani vaunaini anuvaro Nora Kotira Maraquravano vira kempukaiqama kovaro naaqunta tatoqavira vaaka hatoka kaintema kero, Samsoniva nai kauquqaa rumpataa naaquntara hatoka aqukora. ");
INSERT INTO tbg_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Vira kauquqihairo naaqunta hiqintuvaro Samsoniva tavovaro donki maatiri vuhaari, qaraaka mini vauvaro viva vira utu varero viraqohairo vaiinti aruqiro viharo 1,000 vaiinti arukora. ");
INSERT INTO tbg_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Samsoniva ihi tiharo, Te donki maatiriqohai 1,000 vaiinti arukauro. Te vika aruke vika vaata voqaa voqaa ruvaaqumake vatauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Minti tivakero donki maatiri vira vataini aqukero vi vatara autu ntero tiharo, Ramaati Lehi – Maatiri Aiqinave, tura. ");
INSERT INTO tbg_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Ho Samsonira voqamakero namari naataa uvaro Nora Kotira aarero tiharo, Mpo, are ti nena kaiqa vaiinti kempukaiqama kaaramanta te iqoka aatara kauro. Hauri ti namari naataa iraqe qutu vuari kia nái vaata toqakaaka ti vaata varevorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Minti tuvaro Kotiva Lehini vata tomavira nkahikovaro viraqihairo namarivano nte vaura. Samsoniva vi namarira novaro vira aunta paru uvaro vira kempuka qaiqaa ho vaura. ");
INSERT INTO tbg_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Vika ruvu namari vira autu nteha En Hakore – Aarovaro Qovaraiqu Namarirave tura. ");
INSERT INTO tbg_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Vo enta Samsoniva ˻Pirisia˼ vatuka vo Gasaini otuntero tavovaro hampi nariro ni vau nahentiva mini vauvaro viva vikantiro entaqi vaitareva vira naavuqi vura. ");
INSERT INTO tbg_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Mintumanta Gasaqi vauka iruvaro Samsoniva viraqi vaumanta vika vaantaavura qenti vaunaini vaara autute vira veka vaura. Vika tiha, Aatitairaro viva aniraqe tenavu vira arukaare, tivake evaara mini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Vauvaro Samsoniva kia naavuqi vukaiqaakero vairaitiro, viva enta tavaara himpiro oru vaantaavura qenti utu varero vira nkaqukora. Viva qentive hini hini vau posirave, taurini kuvaito katarirave, nkaqukero nai kururuqaa aqu varero vuru inaara aiqina voqaa vatora. Vi aiqinara virivano Hebaroni mantaraini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Vira naantiara Samsoniva vo nahenti vira autu Delailaarara voqama kero antuqa aruvaro vaura. Vi nahentiva Soreki Uqitaini vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ho Pirisia avuhainaaka ˻5navu vauka˼ viva unaini orunte tiha, Nana haikavanoe Samsonira kahaqi vaivaro vira kempukavano uritara kero vaivo? Nantiakee tenavu vira kempuka taiqa kararave? Are Samsonirara uqerara uva tiraro viva vi uvara okara qoqaa ai tiva amirara irira tiva timiraqe tenavu vira aatarake rumpakaare. Are mintiraqe tenavu vohaiqa vohaiqavano 1,100 silvaa monu ai amiare, ti. ");
INSERT INTO tbg_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Minti tuvaro Delailaava Samsonirara tiharo, Nana haikavanoe ai kahaqi vaivaro ai kempukavano uritara kero vaivo? Nantiakeroe vovano ai rumpatairaro ai kempukavano kia variarire? ");
INSERT INTO tbg_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Minti tuvaro Samsoniva nai tiva amiro tiharo, Vika qaraaka hinta kia aaharaiqira viraqohai ti rumpata taivera, ti kempuka kia vairaqe te qaqi vaiinti voqaara vairarave, tura. ");
INSERT INTO tbg_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Ho Pirisia avuhainaaka hinta 7navu kia aaharaiqura Delailaara amuvaro viva viraqohairo Samsonira rumpatora. ");
INSERT INTO tbg_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Vo vaiintinavu rumu voqi kukeqavi vauvaro Delailaava naveraitiharo, Samsonio, veve, Pirisia ani variavo, tuvarovata, Samsoniva naaqunta tatoqavira hatoka kaintema kero, Samsoniva nai vaataqaa rumpataa hintara hatoka kora. Mintima komanta, vika Samsonira kempuka okarara kia kankomake irura. ");
INSERT INTO tbg_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Delailaava Samsonirara tiharo, Mpo, are virera uva tiharama tiriara una uva tiaro. Mpo, nantiakeroe vovano ai ho rumpataanarove? Virara ti tiva timiraqe iriare, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Minti tuvaro viva tiharo, Vika qaraaka naaqunta nora kia vo kaiqa varera viraqohai ti rumpataivera, ti kempuka kia vairaqe te qaqi vaiinti voqaara vairarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Minti tuvaro Delailaava qaraaka naaqunta vonavu varakero vira rumpatora. Vaiinti vonavu vo rumuqi kukeqavi vauvaro viva naveraitiharo, Samsonio, veve, Pirisia ani variavo, tuvaro viva tavuna naaqunta hatoka kaintema kero nora naaqunta hatoka kora. ");
INSERT INTO tbg_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Delailaava Samsonirara tiharo, Are virera uva qaqiqai tihara tiriara una uva ti variaro. Mpo, nantiakeroe vovano ai rumpataanarove? Virara ti tiva timiraqe iriare, tuvaro viva tiharo, Are ti qiata kauhi vunta taunara 7navu varakera paraanke autua maasiniraqi vo naaqunta hampata taatautera, kairiqaqohaira ti kauhivata naaquntavata raqikikera rumpatairaro, ti kempuka kia vairaqe te qaqi vaiinti voqaarama vairarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Minti tivakero vauvaro Delailaava tavovaro viva vaite vauvaro viva vira qiata kauhi vuntatora varakero paraanke naaqunta hampata vira taataukero, kairiqaqohairo vira kauhivata naaquntavata raqikitero, viraqaahairo naveraitiharo, Samsonio, veve, Pirisia ani variavo, tuvaro viva vaitonaihairo himpiro nai qiata kauhi maasiniqaahairo qaqini raraukora. ");
INSERT INTO tbg_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Viva mintima kovaro Delailaava virara aqao tiro, Are kukeqa taana uvara kia tivata tiva timiaravara tira, are qumina tiriara tihara, Ti muntukavano ariara vaivo, tiaro. Are taaramo tataa kia nena kempuka okarara ti tiva timiraitira, qaqiqai virera uva tihara tiriara una uva ti variaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Minti tivakero viva vo enta vo enta vi uvaraqai tivaqiro vi vauvaro vira voqamakero popohovaro ");
INSERT INTO tbg_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","viva ekaara vitini vira vutukero tiva amura. Viva tiharo, Ti vatatai entaraqaahai Kotira kaama amitaarara ti, vika kia ti qiata kauhi toqakaarave. Vika ti qiata kauhi muqukaivera, ti kempukavano taiqa viraqe te qaqi vaiinti voqaarama vairarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Minti tuvaro Delailaava tavovaro viva quqaa uva tuvaro viva uva varakovaro Pirisia avuhainauka vaunaini vura. Viva tiharo, Nenavu qaiqaavata maini aniate. Viva ekaa vi uvara qoqaa ti tiva timivo, tumanta Pirisia avuhainauka silvaa monuvata vare anura. ");
INSERT INTO tbg_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Delailaava Samsonirara ani ti auvoqi vaitaane tuvaro viva mini vaita aavata vuvaro viva vaiinti vo aarovaro viva ani Samsonira qiata kauhi 7navu vuntatora toqakora. Nahenti viva mintima kero vira qoraiqama kovaro vira kempukavano taiqa vura. ");
INSERT INTO tbg_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Mintuvaro nahenti viva naveraitiharo, Samsonio, veve, Pirisia ani variavo, tuvaro viva vaitonaihairo himpiro nai iriro tiharo, Kaiqe te tota unantemake tenta vaata qakiqakimake qaqi variare, tivakero viva kia iruvaro Noravano Kotiva vira qaqirakero kia vira hampata vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Ho Pirisia vika vira ravaaqavuke vira avutanta vauruke vira vita vare Gasa vatukaini otunte mini baraasi seniqohai vira rumpatovaro viva karapuhiqi vaiharo uitive baalive rukavu nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Viva karapuhiqi vauvaro vira qiata kauhivano qaiqaa qampiqe vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Pirisia avuhainauka nái una variqa Dagonira nora ofaa iha quara amitareka ruvaaqumavi vaiha tiha, Tinavu variqavano tinavu navutaara Samsonira tinavu kauquqi kaivo, ti. Vinavuka minti tumanta ");
INSERT INTO tbg_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","vaiinti nahenti vikavata Samsonira tave tiha, Tinavu variqavano tinavu navutaara vira tinavu kauquqi kaivo. Vi vaiintiva tinavu naaho maata qoraiqamakero tinavu navunaakavata airitahaa arukaivama vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Vika minti tivake airi uaini namaqi viha naveraitiha, Samsonira aaraivaro viva uruntero tinavu quahama timitaarire, tumanta vokuka vira karapuhiqihai vita kovaro viva vika nivuqaa uru vaiharo ruhamaqiro vi vaura. Ho vika Samsonira naavu naaqura taaraqanta vaunaini himpima tovaro ");
INSERT INTO tbg_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Samsoniva vainti nankuavano vira kauqu toteharo vi ani vaurara tiharo, Are ti vita varera maa naavuraqi ori naaquratanta vainaini vuru kairaqe te vitanta auteha tavaare. Te vitantaqaa muntuvi vairerave, tura. ");
INSERT INTO tbg_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Ho vaiinti nahenti airitahaa vi naavuraqi vaura. Pirisia avuhainauka 5navuvata viraqi vaumanta naavu qiataqaa 3,000 vaiinti nahenti vaiha Samsoniva vika quahama nimitora tave vaura. ");
INSERT INTO tbg_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Mintuvaro Samsoniva Nora Kotira aarero tiharo, Mpo Noravauvo, are ekaa haikaqaa raqiki variaravama variaro. Ho vate ti iri timitaane. Qaqi voqavata ti kempukaiqama timitairaqe te Pirisia ti tivutanta vaurukaaraqaa vuntu kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Minti tivakero Samsoniva nai kauqutanta ratuta kero naavu aqute vau naaquratanta utu varareva kauqu tanaraqohairo naaqura vo utu varero kaanaaqaqohairo vo utu varero ");
INSERT INTO tbg_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","naveraitiro, Qaqi kairaqe te Pirisia hampata qutu vuare, tivakero viva ekaa nai kempukaqohairo naaquratanta venta aqukovaro naavuvano ekaa raputama vura. Naavuvano raputama viharo Pirisia avuhainaukave, vaiinti nahenti naavuqi vaukave, vikaqaa hiqintura. Vi entara Samsoniva qutiharo airi vaiinti nahenti arukova viva qaqi vau entara arukokavata naatara kora. ");
INSERT INTO tbg_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Ho viraqaahairo vira qata vakaukavarave, vira qora naavuqi vaukave tuvunte, vira vaata vare tuvurante nai qora Manoaara quntama tonaini quntama tora. Sora vatuka hini vauvaro Estaoli vatuka hini vaumanta vika vira vaata tavaarana quntama tora. ");
INSERT INTO tbg_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Haaru, kia King Soruvave King Devitivave qovaraiqu entara, qiata vaiinti vo vaiinti vo vaiintivano Isareriqaa hampiara voqaara raqiki vau entara, karara aavoqu entava qovaraiqura. Vi entara Betarihemi vatuka Iutaa vataini vau vaiintiva nai nahentivata nai maaqutanta vatamakero Moapi vataini oru vahuqa vaireva vura. ");
INSERT INTO tbg_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Vi vaiintira autu Elimerekira, vira naata autu Naomira, vira maaqutanta autu Maalonika Kilionika. Vinavuka Efaraatara ankuqihainaaka Betarihemi vatuka Iutaa vataini vaura ke, Moapi vataini vaireka, vuvaro ");
INSERT INTO tbg_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Elimerekiva mini variro vuru qutu vuvaro Naomiva tentoqa vaiharo nai maaqutanta hampata mini vaura. ");
INSERT INTO tbg_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ho Naomiva Moapi mini vaumanta vira maaqutanta Moapihainaa nahentitanta Oripaaka Rutika varate vaura. Vitanta varate vauvaro 10 ihi aitaromanta ");
INSERT INTO tbg_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Maalonika Kilionika vitantavata qutu vura. Vira vaativanovata vira maaqutantavata qutu vuvaro Naomiva nariaraa mini vaura. ");
INSERT INTO tbg_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ho Noravano Kotiva Iutaini nai vaiinti nahenti koqema nimitovaro vi vataraqaa kara koqema kero qampiqero mpeqaiquvaro Naomiva Moapini vaiharo vi uvara iriro, viva nai naaqututanta hampata Moapi vata mini kero nai maaqaini anirantero vuainarara qeramatero vaura. ");
INSERT INTO tbg_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Naomiva nai naaqututanta hampata himpiro anirantero nai maaqa Iutaini vireva aaraini viharo ");
INSERT INTO tbg_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","nai naaqututantara tiharo, Netanta anirante nenta maaqaini nenta noka qoka hampata variate. Mpo, netanta tivata, qutu vuanavukavata, koqema timitaantema kero, Noravano Kotiva nintatanta koqema nimitaarire. ");
INSERT INTO tbg_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ho Noravano Kotiva nitanta kahaqira netanta qaiqaa vaati varatetanta, qaiqaa koqemaketantama vaivarave, tiro. Naomiva minti tivakero viva nai naaqutu vitanta moqakero kukuqama nimitero vuare tumanta vira naaqututanta voqamake iqi ratora. ");
INSERT INTO tbg_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Vitanta iqi rateha virara tiha, Mpo, kiave. Tetanta ainti ai navunaaka varianaini virerave, ti. ");
INSERT INTO tbg_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Minti tuvaro Naomiva vitantara aqao tiro, Mpo ti raavuratantavauvo, netanta anirantetanta vuate. Nana haikara irihae netanta ti hampata vireka auti variavo? Netanta tiriara viva qorainti votanta vatataira vitanta noruqamavi titanta varaate, tivakehae ti hampata vireka auti variavo? ");
INSERT INTO tbg_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Te kontaiqamama vuro. Kiama ho te qaiqaa qorainti varaainarave. Ho netanta anirante nentatanta maaqaini vuate. Te vate qorainti vare vo enta vaintitanta vatataarera, ");
INSERT INTO tbg_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","netanta hoe vitanta veka vaimanta noruqama vivarave? Netanta kia vo qorainti vararaiti, vitanta veka hoe qaqi vaivarave? Kiave. Netanta kia ho mintivarave. Mpo, Noravano Kotiva ti qoraiqama timitaimanta nitanta vaati kia variamantara ti, te nitantara voqamake mpo turo. ");
INSERT INTO tbg_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Minti tumanta Rutika Oripaaka qaiqaa iqi ratora. Viraqaahairo Oripaava nai tonanora Naomira moqakero ho vuro tivakero nai anirantero vuvaro Rutivaqai Naomikantiro vaireva, kia vira tuatora tuta karaitiro, qaqi tuatero vaura. ");
INSERT INTO tbg_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Vira qaqi tuatero vauvaro Naomiva Rutirara tiharo, Ho tavaane. Ai hanava nai navunaaka ianainivata, nai kaivaqaukavara variqanavu varianainivata vivo. Are vikantira anirante vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Minti tuvaro Rutiva tiharo, Are kia ti vihi tihara, Ti kera anirantera vuane, tiane. Ekaa are virera inanaini tevata mini virerave. Ekaa are vairera vainanaini tevatama vairerave. Ai navunaaka ti navunaakavatama vaivarave. Ai Variqavano, viva ti Variqavanovatama varianarove. ");
INSERT INTO tbg_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Are qutiramanta quntama teraqi tivata quntama tevarave. Mpo, ti okara kaara vo haikavano titanta raira kairera, Noravano Kotiva homa voqamakero ti qoraiqama timitaanarove. Qutira haikavanoqaima titanta ho raira kaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Minti tuvaro Naomiva tavovaro Rutiva vikantiro vuarirava kempukaiquvaro viva kia qaiqaavata virara vo uva tuvaro ");
INSERT INTO tbg_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Rutiva vikantiro Betarihemini oruntora. Naomika Rutika Betarihemini oruntomanta ekaa vihainaaka vitanta tave ravuku vumanta nahentinavu Naomira tave tiha, Ike, viva Naomivave? tuvaro ");
INSERT INTO tbg_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomiva tiharo, Mpo, ne kia tiriara Naomirave – Quahairave tiate. Noravano Kotiva ekaa kempuka vataava ti qoraiqama timiteharo hunkavi haikara ti timitaira kaara ne ti hutu nteha Hunkairave tiate. ");
INSERT INTO tbg_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Te maa vatukara ke vuavauna entara te airi haika, vo haika vo haika vaative, vaintive, vataake vuavaunarave. Vate Noravano Kotiva ti tivita varero maini animantama te kia vo haikavata vatauro. Mintirara ti, ne nantihae tiriara Naomirave – Quahairave tiavo? Mpo, Noravano Kotiva ekaa kempuka vataava tiqaa uva vataimanta te qoraiqamavi vauraukama vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ho mintima kero vira muntuka qoraiquvaro Naomiva Moapi vata mini kero orurantero nai naaqutu Moapihainaa nahenti Rutikantiro anura. Vitanta Betarihemini baali mpeqaiqura hoqaramate teqare u entaraqaa oruntora. ");
INSERT INTO tbg_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ho Naomira vaati Elimerekira vohaa anku vaiinti vo vira autu Boaasiva vaura. Boaasiva nora autu vataa vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Mintima vauvaro vo enta Moapihainaa nahenti Rutiva Naomirara tiharo, Are ti qaqi kairaqe te baali naahoqi kaiqa varaare. Kaiqa vaiinti vokika tiriara hove tivera, te vika naantiaraini viha, baali teqake vareha hini vataini kera, nuntuke varaare, tiro. Rutiva minti tuvaro Naomiva virara tiharo, Naaqutuo, ho mintiane, tuvaro ");
INSERT INTO tbg_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Rutiva baali naaho voqi oruntero kaiqa vaiinti nahenti vika naantiaraini viharo baali hiqintura nuntu keharo vare vaura. Viva vi kaiqara vare vaiharo tavovaro vi naahova vira tonaqora vohaa anku Boaasiva u naahova vaura. ");
INSERT INTO tbg_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ho Rutiva vi naahoraqi kaiqa vare vauvaro Boaasiva naivano Betarihemi mini kero nai kaiqa vaiinti nahenti vaunaini anintero vika uva manteharo tiharo, Noravano Kotiva ni hampata variarire, tumanta vika nái viraravata tiha, Noravano Kotiva ninavata koqema amitaarire, ti. ");
INSERT INTO tbg_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Mintimake uva mantovaro Boaasiva kaiqa vaiinti nahentiqaa raqiku vaiintira irero tiharo, Qaraaka nahenti vitira taihainaarave? ");
INSERT INTO tbg_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","tuvaro viva Boaasira tiva amiro tiharo, Viva Moapi vatanaa nahentivano Naomikantiro Moapihairo anivave. ");
INSERT INTO tbg_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Viva kaiqa vaiinti nahentinavu naantiaraini baali hiqintira nuntu ruvaaquare tivakero ti iraimanta te hove turaroma viva vi kaiqara vare vaivo. Viva toqaqihairo kaiqa varaqiro viviro, vohaa tataaqai haraara naavuqi auraara inaaraiqakaa varikeroma, qaiqaa kaiqa varaqiro ani vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Minti tuvaro Boaasiva Rutirara tiharo, Mpo, ti raavuravauvo, iriane. Are vo naahoqi kia baali nuntu ruvaaqiraitira, maaqihairaqaima nuntu ruvaaquane. Are ti kaiqa vaiintinavu baali teqeka tavehara oru ti kaiqa nahentinavu baali nunti vainaini vika naantiaraini oru viharama kaiqa varaane. Te tenta kaiqa vaiintinavu tiva nimuramanta vika kiama ai qoraiqama amitevarave. Ai namari naataa irera, are homa oru vika kureqi namari kaqake vatera nenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Boaasiva minti tuvaro Rutiva tori kauru araviro nai viri vataini kero Boaasirara tiharo, Mpo, te vo vatanaa nahenti vaurara are tiriara noraiqaakera iriaro. Nantivarae are mintima kera ti koqema timitaaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Tuvaro Boaasiva vira tiva amiro tiharo, Ai vaativano qutu vuvara are nena tonanora koqema amitaana uvara tiamanta te ekaama vi uvara iruro. Te irurara are nena tonanora kia qaqira kairaitira, are nena noka qoka kera, nena maaqa kera, are kia tavaana vatanaaka maaka hampata maini vaireva, anianarave. ");
INSERT INTO tbg_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Are minti ianarara iriharo Noravano Kotiva ai koqema amitairaqe te hove tiataarave. Are Isareri Variqavano Noravano Kotiva inaini anira virara ti antua timitaane tianarara tiro, viva koqe koqaa voqavata ai amiraqe te hove tiataarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Boaasiva minti tuvaro Rutiva tiharo, Mpo, are ti koqemama timitaaro. Te ai kaiqa nahenti vika vevaaraini vauraravata, are tiriara qihaaqama kera tiana uvava ti kempukaiqama timitaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Tumanta ekaa vira kaiqa vaiinti nahenti ruvaaqumavi vaiha kara ne vauvaro Boaasiva Rutira tiva amiro tiharo, Are maini ani mpareti vo vara kera, uainiqi quntama kera naane, tiro. Minti tuvaro Rutiva kaiqa vaiinti hampata oquviro vauvaro Boaasiva baali ihaqaa haimitora vira amuvaro Rutiva vira varakero nora. Boaasiva airi baali vira amuvaro viva ho nero hini qaqi vatora. ");
INSERT INTO tbg_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Ho Rutiva kara nama taiqa kero viva himpiro qaiqaa vi kaiqara varareva vuvaro Boaasiva nai kaiqa vaiinti tiva nimiro tiharo, Ne kia Rutira qio tiraiti, vira qaqi kaivaroma viva ne baali rumpake vatera tataaqa vainara nuntu keharo varaarire. Ne baali rumpake vateraqihai vokinara rarauke vataini kaivaro viva viravata nuntu keharo varaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Boaasiva nai kaiqa vaiintinavuara minti tuvaro Rutiva naahoqi baali nuntu ruvaaqi vauvaro kuari avu aqu vura. Mintuvaro viva baali ruvaaqumatora ruqutu kero auru vira varakero ntuvakero tavovaro vira maaravano 10 kilo aumanto vaura. ");
INSERT INTO tbg_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rutiva baali auru varero vatukaini vuru nai tonanora umiqero, kuariqaa neharo hini qaqi ko kararavata varero vuru nai tonanora amuvaro ");
INSERT INTO tbg_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomiva nai naaqutu Rutira irero tiharo, Are taihairae baali maa varaaro? Are ta vaiintira naahoqi kaiqa varaaravave? Vi vaiintiva ai tavero ai kahaqirara iriharo Noravano Kotiva vira koqema amitaarire, tiro. Minti tuvaro Rutiva tiharo, Te vate vo vaiinti Boaasirave tia vaiintira naahoqi kaiqa varauraukave, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Minti tuvaro Naomiva tiharo, Noravano Kotiva vi vaiintira koqema amitaarire. Noravano nai kauqu aiqiqaa aqukeharo qutu vua vaiintikarave qaqi variakarave tivatai uvara kia tauruke vairave, tiro. Minti tivakero viva qaiqaa tiharo, Vi vaiintiva tinavu vohaa naareve. Tinavu Isareri okaravano vaireva, mintimakeha varia vaiintika tenavu tentoqa vauraukara iriha, tinavuqaa raqikikama variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Naomiva minti tuvaro ho Rutiva vira tiva amiro tiharo, Boaasiva ti vo uvavata tiva timirave. Viva tiriara nai kaiqa nahenti hampata qaqi kaiqa varaqira vihara baali nuntu ruvaaqumaqira viraro baali entavano taiqaarire tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Minti tuvaro Naomiva Rutirara tiharo, Ho ti naaqutuvauvo, vira quqaama tivo. Are oru vo vaiinti naahoqi kaiqa vare vaira vira kaiqa vaiinti ai qoraiqama amitevorave. Ho are Boaasira kaiqa nahenti hampataqai kaiqa varaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Minti tuvaro Rutiva Boaasira kaiqa nahenti hampata kaiqa varaqiro vuvaro baalivata uitivata teqo entava taiqa vura. Ekaa vi entara Rutiva nai tonanokantiro variqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Vo enta Naomiva Rutirara tiharo, Naaqutuo, te qorainti vo ranteke ai amiarirara are vira varatairaro viva ai varatero ariqaa raqikirara are koqema kera variane. ");
INSERT INTO tbg_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ho are iriane. Vaiinti vira Boaasira vira kaiqa nahenti hampata are kaiqa varaanara, vira tinavu vohaa naarema vaivo. Vate entaqi viva oru kaiqa vareharo baali mareve kaqive vara qaqini qaqini ianarove. ");
INSERT INTO tbg_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ho are oru namari tuntukerama koqe munta iaina vahaverara aqu varerama koqe utavaaqa nonku varerama viva kaiqa varainanaini vuane. Virama kia vira avuqaa qovarama viraitira, kukeqavi vaihara tavairaroma viva karavata namarivata nama taiqa kaarire. ");
INSERT INTO tbg_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Nama taiqa kero viva vaitareva virarama are viva vaitareva vinanaini koqema kerama tavaane. Taverama are viva vinanaini orunterama viva vaitainanaini oru vira paraanke aiquni ravaqaara kera, vira aiqutaraini vaitaane. Are vira tataaqa vaitairaroma viva ariara nana uvae tinantemakera iane, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Naomiva minti tuvaro Rutiva tiharo, Hove. Te are tianantemake mintirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Minti tivakero ho Rutiva Boaasiva baali mareve kaqive vara qaqini qaqini unaini oruntero Naomiva tiva amuntema kero mintura. ");
INSERT INTO tbg_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boaasiva karavata namarivata nama taiqakovaro vira vaatavano koqe uvaro vira avu tauntovaro oru baali teqake vatora tataaqa vaitora. Vaitovaro Rutiva qakoma kero viva vaitonaini oruntero qihaaqama kero paraanke ravaqaara kero Boaasira aiqutaraini vaitora. ");
INSERT INTO tbg_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Vira aiqutaraini vaite vauvaro Boaasiva enta tavaara vaitoraqihairo tuqantaa vuare tiro ravukuviro tavovaro vira aiqutaraini nahenti vovano vaite vaura. ");
INSERT INTO tbg_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Vaite vauvaro tavero vira irero tiharo, Are tavave? tuvaro Rutiva virara tiharo, Te Rutikave. Te ai kaiqa nahenti vovanove. Are Elimerekira vohaa naarevano ti tentoqa nahentiqaa raqiki varianarara tira, are ti varataane, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Minti tuvaro Boaasiva virara tiharo, Mpo, ti raavuravauvo, Noravano Kotiva ai koqema amitaarire. Are vate maantiana okarava viva nena tonanoravata koqema amitaanara aatarama kaivo. Are vira mintihara, vate ti voqavatama koqema timitera iaro. Qaraaka vaiinti, airi airaira vataakave, kia airi airaira vataakave, airitahaa variavaravata, are kia vikaqihaira vo varareva autuanarave. ");
INSERT INTO tbg_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ho ekaa vatukaqi variaka tavaavara are koqe nahentivano varianarave. Mintimakera varianarara tira, kia qetaane. Te ekaa uva are tinantemake mintirerave. ");
INSERT INTO tbg_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Are quqaama tiriara tihara, Are ti tonaqora vira vohaa naarevanoma variaro. Are homa tiqaa raqikinarave, tiaro. Ho vo vaiintivanovata vaivo. Vivama ti avuniqama kero vi kaiqaraqaa raqikivama vaivo. ");
INSERT INTO tbg_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Vate are entaqi maini vairaqe te hura toqaqi oru vi vaiintira avu aatoqi vainara rantake iriare. Viva ariqaa raqikireva irera, vira hove. Viva kia ariqaa raqikireva irera, te ariqaa raqikirerave. Te qaqi variqiro vi vai Variqara Nora Kotira autuqaa ariara te mintirerave turo. Ho are maini vaitera toqaqi vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Minti tivakero Boaasiva Rutira tiva amiro tiharo, Hauri vaiinti nahenti are maini aninara tavevorave, tuvaro Rutiva qaiqaa Boaasira aiqutaraini vaitero vira qararaa vaiinti tavevorave tiro, kia aatitoraqi himpiro vura. ");
INSERT INTO tbg_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Viva vire uvaro Boaasiva Rutirara tiharo, Are nena tavuna aqutaanara varera viri vatakanta vuqitaane, tuvaro Rutiva tavuna vira varero viri vuqitovaro Boaasiva baali tavuna viraqaa rauru amitora. Baali vira maaravano vaireva, 20 kilo vauvaro Boaasiva Rutira kahaqama kero baali qauku aqu amitovaro Rutiva aqu varero anirantero vatukaini vura. ");
INSERT INTO tbg_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ho Rutiva naavuni oruntovaro vira tonanova tiharo, Naaqutuo, ho te tunantema kerae iaro? tuvaro Rutiva nai tonanora ekaa vi uvara tiva amura. ");
INSERT INTO tbg_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Vi uvara tiva taiqa kero viva qaiqaa tiharo, Boaasiva tiriara viva nai tonanova inaini qumina vuantorave tiro, viva baali raira timimantama vare anuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Minti tuvaro Naomiva tiharo, Naaqutuo, Boaasiva kiama qumina vairaitiro, viva vaakama vi haikara avuqavuma kaanarove. Virara iriharama are qihaaqamakera vaihara tavairaro vi haikava qovaraiqiarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ho Boaasiva vaantaavura qenti vaunaini vaiinti nahenti ruvaaqumavi vaunaini oru oquvi vauvaro vihairo viva Rutirara tu vaiintiva Elimerekira vohaa naareqiraava vihairo anura. Vi vaiintiva anuvaro Boaasiva virara tiharo, Ti vakaao, ani maini oquvuane, tuvaro vi vaiintiva oru Boaasira tataaqa oquviro vauvaro ");
INSERT INTO tbg_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","viraqaahairo Boaasiva Betarihemihainaa nora vaiinti 10 navuvata naarama kero, maini ani oquvuate tumanta vinavukavata ani mini oquvi vaura. ");
INSERT INTO tbg_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Vinavukavata ani mini oquvi vauvaro Boaasiva nai vohaa naareqiraarara tiharo, Naomiva Moapini vaira mini kero orurantero mainima ani vaiharo vata vo, nimiharo monu varareva auti vaivo. Vi vatava Elimerekira titanta vakaara vatavano vairave. ");
INSERT INTO tbg_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Mintivera te ariara tiha, Arema Elimerekira qatavano avuniqamakera variavara tira, are naane homa vi vatara varenarara tinarave. Ai antuqavano vata virara vairera, are nora vaiinti maaqi variaka nivuqaa vaihara vi vatara koqaama kaane. Virara kia ai antuqavano vairera, ti tiva timiraqe te iriare. Te ai naantiaraini vi vatara varaainarara ho tirerave, tiro. Minti tuvaro vi vaiintiva tiharo, Ho te vi vatara vararerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Minti tuvaro Boaasiva vira tiva amiro tiharo, Hove. Are Naomira vata vira koqaama kera varairera, ho are tentoqa nahenti Moapihainaara Rutiravatama varenarave. Mintiakera varairaroma vi vatava qutuvi vaiintira vira vaintivara vatavano variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Boaasiva minti tuvaro vi vaiintiva tiharo, Vira quqaama tiaro. Te vi vatara avuniqamake varaariraukama vauro. Te vi vatara varaariraro naantiara vi vatava kia ti vaintinavu vata vairaitiro, vi nahentira vaintivara vatama varianarove. Virara irihama te qaqirake kia vi vatara vararerave. Are nenama vi vatara koqaa iane, tura. ");
INSERT INTO tbg_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Haaru Isareri vaiinti vika vatave, vo haikave, koqaamake vare vau uvara kempukaiqamake vau okarava maantimama vairo: Vaiinti vovano vo haika vo vaiinti amireva iharo, viva nai su vo rahunku kero vo vaiinti vira amura. Viva vaiinti nahenti nivuqaa mintumanta vika tiha, Viva avuqavu koqaama autivo, ti vaura. Isareri vika mintimake nái airaira nimi vau uvara kempukaiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ho vi vaiintiva Boaasira tiva amiro tiharo, Are nenama vi vatara koqaamake varaane, tivakero viva nai su vo rahunku kero Boaasira amiro. ");
INSERT INTO tbg_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Amuvaro Boaasiva nora vaiintinavuaravata vaiinti nahenti mini vaukaravata tiharo, Ne ekaa vaiha tavaamanta te Naomira vata koqaamake varauro. Hoqare vi vatava Elimerekiravata vira maaqutanta Maalonika Kilionika vatavano vaurave. Ho vate te vi haikara ekaama koqaama kauraro vi haikava tiniqama vivo. ");
INSERT INTO tbg_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Te vinavuka ia haikara varehama, Maalonira tentoqa nahenti Moapihainaara Rutiravatama varauro. Te Rutira varaariraro Maalonira vatavano vaireva, nai vira anku vika vatama varianarove. Mintiraro Maalonira autuvanovata kia nunka viraitiro, Betarihemi kansoru vika vukuqi qaqima varianarove. Ho ne ekaa vaiha tavaamanta vate te vi vatarave vi haikarave koqaamake varauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Boaasiva minti tumanta nora vaiintinavuvata ekaa vaantaavura qenti vaunaini ruvaaqumavi vaukavata tiha, Eo, tenavu maini vaiha ekaama vi haikara iri tavauro. Vate ai naavuqi aniaina nahentira Noravano Kotiva koqema amitairaro viva Reserika Riaaka Iekopira vainti vata amitontema kero, viva airi vaintima vataanarove. Mintirarama are Efaraataa ankuqihainaa nora vaiintivano vaiharama, Betarihemi vatukaqi nora autu vataavama vainarave. ");
INSERT INTO tbg_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Noravano Kotiva nitanta airi vainti nimiramanta nitanta vaintivara airi vaiinti Iutaaka Tamaaka maaqu Peresira vaintivara voqaarama vaivarave, tura. ");
INSERT INTO tbg_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ho Boaasiva Rutira varatovaro Noravano Kotiva vitanta koqema nimitovaro Rutiva vainti taiqama viro qorainti vainti vo vatatora. ");
INSERT INTO tbg_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Vatatomanta Naomira kena nahentinavu virara tiha, Kaiqe tenavu Kotira autu tuahera kaare. Noravano Kotiva kia ariara tauru karaitiro, vaiinti vovano ariqaa raqikiarire tiro, viva vate qorainti vainti vo ai amivaro vi vaintiva ai naintivanoma vaivo. Vi vaintiva noruqamaviro Isareri vikaqihairo nora autu vataavama varianarove. ");
INSERT INTO tbg_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ai naaqutuvano ariara voqama kero antuqa ari vaiva ai nainti vo vatataivo. Ai maaqu 7navu variatirio, vinavuka kia ai naaqutuvano ai kahaqintemake ai kahaqiatirio. Ho ai naintivano qovarama virara tira, are qaraaka nahenti voqaarama vainarave. Naantiara are kontaiqama viraro viva ariqaa koqema kero raqikianarove, tura. ");
INSERT INTO tbg_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ho vinavuka minti tuvaro Naomiva vainti vira ravuku teharo viraqaa koqemakero raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Mintumanta vatuka vihainaa nahentinavu tiha, Hove. Vi vaintiva Naomira maaqu voqaarama vaivo, tivake vainti vira autu nteha Obetirave tura. Obetiva Iesira qova vauvaro Iesiva Devitira qova vaura. ");
INSERT INTO tbg_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peresiva Hesaronira qova vauvaro Hesaroniva Raamira qova vauvaro ");
INSERT INTO tbg_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Raamiva Aminadaapira qova vauvaro ");
INSERT INTO tbg_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadaapiva Naasonira qova vauvaro Naasoniva Saramonira qova vauvaro ");
INSERT INTO tbg_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Saramoniva Boaasira qova vauvaro Boaasiva Obetira qova vauvaro ");
INSERT INTO tbg_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obetiva Iesira qova vauvaro Iesiva Devitira qova vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Efaraimura ankuqi vau vaiintiva, Elakanaava Efaraimu aiqinaini vau vatukara Ramaaqi vaura. Elakanaara anku okara maantima vaura: Elakanaara qova Jerohaamuva vauvaro Jerohaamura qova Elihuva vauvaro Elihura qova Tohuva vauvaro Tohura qova Sufuva vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elakanaava nahenti taaraqanta Hanaaka Peninaaka varatovaro Peninaava vainti vonavu vatatovaro Hanaava kia vainti vataraitiro, qaqi naahiarama/qururaiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ho Elakanaava Noravano Kotiva ekaa kempuka vatai Variqara autu tuahereharo ofaa iha quara amitareva vo ihi vo ihi Ramaa mini kero Silo vatukaini vi vaura. Elira maaqutanta Hopinika Finiaasika Siloqi Nora Kotira kaiqa vara amite vautanta vauvaro ");
INSERT INTO tbg_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Elakanaava oru vitanta unaini vaiharo vitanta kaamato entaraqaa ofaa iha Kotira quara amite vaura. Ho vi entaraqaa viva Kotira ofaa iha quara amitareva u matira viraqihairo hini mati raira keharo Peninaara, nai vaintiaravata vohaa tataa nimiro, ");
INSERT INTO tbg_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Hanaara vira taara tataa ami vaura. Elakanaava vo ihi vo ihi mintima keharo mati raira keharo vinavuka nimi vaura. Viva Hanaarara voqama kero antuqa aruvarora tiro, viva mati airiqama kero Hanaara ami vaura. Ho Noravano Kotiva Hanaara kia vainti amuvaro viva qaqi naahiarama/qururaiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Hanaava kia vainti vatora kaara vira qiariva virara uva virera tiva amitaqiro vuvaro Hanaara muntukavano qoraiquvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Vo ihi vo ihi vinavuka Silo vatukaini Nora Kotira naavuqi vi vau entara Peninaava mintima keharo Hanaara uva virera tiva amitaqiro vi vauvaro Hanaava Peninaava tu uvara kaara kia karavata naraitiro, qaqi variqiro viharo iqi rataqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Viva iqi rate vauvaro Elakanaava vira irero tiharo, Mpo, are nana kaarae iqi ratehara kia karavata naraitira variaro? Nana kaarae ai muntukavano qoraiqivara variaro? Quqaama are kia vainti vataarava variaro. Mpo, are maaqu kauqurutanta vatataaraitirio, kiae ai muntukavano tiriara avuni vaitirio? tiro. Elakanaava minti turama. ");
INSERT INTO tbg_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Ho vo enta vinavuka Siloqi vaiha kara nama taiqa kovaro Hanaava himpiro oru Kotira Seri Naavu vaunaini vauvaro vira muntukavano voqamakero qoraiquvaro iqi rateharo Nora Kotira aare vaura. Vi entara Kotira kaiqa vara amite vau vaiintiva, Eliva Nora Kotira Seri Naavu qentiana oquviro vauvaro ");
INSERT INTO tbg_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Hanaava Kotira aareharo nai kauqu aiqiqaa aqu kero tiharo, Noravauvo, are ekaa kempuka vataavama variaro. Mpo, te ai kaiqa nahentivano nora maaraqi vaunara taveharama kia tiriara tauru kaane. Mpo, are qorainti vainti vo ti timirera, te vira nina kaama amiteha nina amiariraro viva ai kaiqa vaiinti vaiharo nai qaqi variqiro vuaina entara ai kaiqaqai varaqiro vuarire. Te qioqama taari vira qiata kauhi kia toqa karaiti, vira okauvata kia muqu kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","Hanaava vukaiqama kero Nora Kotira evaara aaramaqiro viharo kia uva tiraitiro, nai avu aatoqihairo Nora Kotira aare vaura. Viva mintima kero Nora Kotira aare vauvaro Eliva vitini vaiharo tavovaro Hanaara novano qaki qaki i vauvaro nai aatoqihairo irikero tiharo, Viti nahentiva airi uaini namakero vueraiqamama vivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Minti tivakero virara tiharo, Taireve are vueraiqina okarara qaqira kenarave? Are maa naavuraqihaira vevantera viraro ai avu aatovano kanko iarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Eliva minti tuvaro Hanaava nai tiva amiro tiharo, Aqao, nora vaiintio, kiama te biaave, uainive, neha vueraiquro. Tiqi nora maaravano vaivaro ti muntukavanovata voqama kero qoraiqira kaara te ekaa vi maarara Nora Kotira tiva ami vauro. ");
INSERT INTO tbg_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Are kia tiriara qora nahentive tiane. Ti muntukavano voqama kero qoraiqimanta te Kotira aareha ekaa vi uvara vira tiva ami vaurara are ti taveharama minti tiaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Hanaava minti tuvaro Eliva virara tiharo, Mpo, ai muntukavano qihaaqirara vuane. Tinavu Isareri Variqavano are nana haikara vira irenara ai amianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Eliva minti tuvaro Hanaava tiharo, Mpo, nora vaiintio, are ti koqema timitaanara virara koqevema turo, tiva kero viraqaahairo oru kara novaro vira maaravano taiqa vuvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Ho vira qararaa toqaqi vinavuka himpi oru Nora Kotira autu tuaherake, viraqaahai anirante nái maaqa Ramaini oru vaura. Elakanaava nai naata Hanaakantiro nuvaro Noravano Kotiva Hanaava vira aaro uvara hoqama amitora. ");
INSERT INTO tbg_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Mintuvaro Hanaava vainti taiqama viro qorainti vainti vatatero vira autu nteharo Samuerirave – Kotiva irirave tiro. Hanaava tiharo, Te Nora Kotira naaruraro viva ti qorainti vainti timivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ho vi ihira Elakanaava nai Kotirara mintirerave tivatai uvarara iriharo, viva nai naata vaintiaravata qaiqaa Silo vatukaini oru ofaa Nora Kotira iha quara amitareva vuvaro ");
INSERT INTO tbg_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hanaava kia mini viraitiro, viva Elakanaarara tiharo, Vaintiruvano naama qaqira kaaina entara te vira vita vare vuru Nora Kotira amiariraro viva nai qaqi variqiro vuaina entara Nora Kotira Naavu viraqi variarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Minti tuvaro Elakanaava tiharo, Ho are nena avu aato utinara vira avataane. Are maini variqira viraro vaintivano naama qaqira kaarire. Are nena kauqu aiqiqaa aqukera tivataana uvara Noravano Kotiva ai kahaqiraro vi uvava vivau variarire, tiro. Minti tuvaro Hanaava maaqaini vaiharo nai maaqu viraqaa raqikiqiro vuvaro ");
INSERT INTO tbg_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","viva naama qaqira kora. Ho Samueriva vainti naatiru vau entara vira nova vira vita varero vuru Nora Kotira amireva vura. Viva vira vite vireva iharo, purumakau qora vo taaramo ihi varakoravata, porihi/voruhi uta noravata, memeraa pahiqi uaini kaqatoravata, varero, Nora Kotira Naavuvano Silo vatukaini vaunaini ˻vokuka hampata˼ vura. ");
INSERT INTO tbg_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Mini orunte vinavuka purumakau vira aruke ˻Kotira ofaa iha quara amite˼, viraqaahai Samuerira vita vare Eliva vaunaini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Mintuvaro Hanaava Elirara tiharo, Nora vaiintio, are tiriara irie taaro, kiae iritaaro? Haaru te maini himpite vaiha Nora Kotira aare vaunarave. ");
INSERT INTO tbg_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Te Nora Kotira aareha tiha, Mpo, vainti ti timiane, tivake vira irauraro viva ti uva iriro vainti ti timirave. ");
INSERT INTO tbg_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Viva mintirara ti, vate te vi vaintirura Nora Kotira nai amirerave. Vi vaintiva ekaa nai qaqi variqiro vuaina entara Nora Kotira kaiqaqai vara amitaqiro vuarire, tumanta vinavuka mini vaiha Nora Kotira quahama amiteha vira autu tuahera kora. ");
INSERT INTO tbg_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Ho Hanaava Nora Kotira aareharo mintima tiro: Noravauvo, are ti koqema timitaanara virara te tenta muntukaqihai voqamake quaheha vauro. Are ti kempuka timiaramanta te tenta navutaaka naaraihama nimite vauro. Kotio, are ti kahaqama timitaaravera te quaheha vauro. ");
INSERT INTO tbg_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Noravauvo, kia vovano ai aanantero takuqu kero vaiva vairave. Kiama variqa vovanovata vairave. Arema tinavu Variqavano vaihara tinavu antua timite variaravama variaro. ");
INSERT INTO tbg_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Noravano Kotiva tinavu okara kankoma kero iri vaiva, viva tenavu nana nana qora kaiqave koqe kaiqave vare vaunara rairakero tave vairara ti, ne nenta nutu tuahera keha vo uva vo uva ti variaka, ne qaqirake kia nenta mahuta tiraiti, kia uvavata tiate. ");
INSERT INTO tbg_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Kempuka iqoka vaiinti huru kaavu Noravano Kotiva rauhaantima keharo, viva kia kempuka vatauka vika kempukaiqama nimite vairave. ");
INSERT INTO tbg_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Haaru airi kara ne variaka, vate vika kara neva kia vaimanta variarave. Haaru karara qaavoqiha narara variaka, vate Kotiva vika airi kara nimimanta ho neha variarave. Tota naahiara/qurura vai nahentiva vate vainti 7navu nova vairave. Airi vainti nova vate qumina nariaraa vaiharo nai vainti vikara iqi rate vairave. ");
INSERT INTO tbg_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Noravano Kotiva vo kiaka arukeharo, vo kiaka qaqi kaimanta variarave. Noravano Kotiva hini kiaka qutu vuaka varianaini keharo, hini kiaka qaiqaa qaqi vara himpima kaimanta variarave. ");
INSERT INTO tbg_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Noravano Kotiva hini kiaka vehiqama kaimanta variavaro, hini kiaka airi airaira nimimanta vate variarave. Viva hini kiaka nutu vatainiqama keharo, hini kiaka nutu tuaherake vairave. ");
INSERT INTO tbg_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Noravano Kotiva anomake vehiqamavi konkomaqi variaka vika vara himpima kero ntita varero vuru nora vaiinti vika hampata keharo nora autuvata vika nimi vairave. Noravano Kotiva naivano maa vatara tuqa aratero viraqaata maa vatara autu kero vatairave. ");
INSERT INTO tbg_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Viva nai vaiinti nahentiqaa koqema kero raqikiqiro viharo, qora kaiqa vare variaka konkira arinaini kaimanta uve variarave. Vaiinti vovano nai kempukara noraiqaakero iri vairava vairaro vira kempukavano kia ho vira kahaqianarove. ");
INSERT INTO tbg_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Nora Kotira navutaiqama amitareka auti vaika, viva ekaa vika vehi autu kaanarove. Naaruvavano karara tintemakero, vira uvavano vika vehi autu kaanarove. Naantiara Noravano Kotiva ekaa maa vataraqaa vaika ko tiharo vika koqe okarave qora okarave raira kaanarove. Noravano Kotiva nai noraiqama kaina vaiintira kempukaiqama amiteharo, nai kaama taina vaiintira kahaqi vairaro viva kempuka vaiinti varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Hanaava Kotira aarama taiqa kero, Elakanaakantiro anirantero Ramaini vuvaro vira maaqu Samueriva Siloqi vauvaro Eliva viraqaa raqiki vauvaro viva Nora Kotira kaiqa vara amite vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Elira maaqutanta Hopinika Finiaasika qora vaiintitanta vaura. Vitanta Kotira kaiqa vara amite vaiha, Nora Kotirara kia noraiqaake iriqi viraiti vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Vitanta Nora Kotira ofaa iha quara amite vau okarara kia naitaramake avate vaura. Vitanta maantimake hampi kaiqa vare vaura: Vaiinti vovano Kotira ofaa amitareva umanta vitanta vira amito matira varake nora kureqi arate vaura. Viraqaahai vitanta kaiqa vaiinti vo atitovaro viva poku taaramo viaru vaura varero, oru nora kure vira tataaqa vaiharo ");
INSERT INTO tbg_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","poku viraqohairo kure viraqi vaati kero, nai nana matie poku viraqaa ranteqakero varero, kaiqa vaiinti viva vira vuru vitanta nimi vaura. Mintima keha vitanta Isareri vaiinti nahenti Siloqi Kotira ofaa amura hampiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Vaiintivano kaantavu varakero ofaa iha quarareva auti vauvaro vitanta kaiqa vaiintivano anintero tiharo, Kotira kaiqa vara amite variatantara irihara, are vaaka mati hinikira ti timiraqe te vare vuru vitanta nimiare. Kureqi arataa matira kiama vitanta naataa ivo. Ne qaraaka mati ti timiqe te vare vuru vitanta nimiari vitanta ihaqira untake naate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Ofaa iha quarareva u vaiintiva tiharo, Aqao, qaqi kairaqe te ofaa iha quare okarara naitaramake avateha, kaantavu naane iha quara taarirara, viraqaahaira are mati varaataa irera varaane, tuvaro vitanta kaiqa vaiintivano kempukaiqama kero tiharo, Kiave, are vaaka maa vira ti timiane. Are kia ti timirera, tentavano varaare, tivakeharo mati vira varero vuru vitanta nimi vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Mintima keha Elira maaqu vitanta vaiinti nahenti Nora Kotira ofaa iha quara amitare i vaura qoraiqama nimite vauvaro Noravano Kotiva tavovaro vitanta okaravano anoma kero qoraiqiro vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Ho vitanta mintimake kaiqa vare vauvarovata, Samueriva vaintiruvano mini vaiharo Nora Kotira avuqaa koqe kaiqa varaqiro vi vaura. Kotira kaiqa vara amite vauka nonkute vau tavunara, efotive tura, vivavata nonku teharo kaiqa vare vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Ekaa vo ihi vo ihiara vira nova vukai tavuna vira autu amite vaura. Vira noka qoka Nora Kotira ofaa iha quara amitareka iha, tavuna vira vareha vuru Samuerira ami vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Eliva vitanta koqema nimiteharo Elakanaara tiva amiro tiharo, Kairaro Noravano Kotiva ai naata kahaqiraro viva vainti vokikavata vatataira vika are Nora Kotira kaamatera amiana vaiintira vira vatuka varaate, tiro. Vo ihi vo ihi Eliva minti tiva nimite vaumanta vitanta anirante nái maaqaini vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Ho Noravano Kotiva Hanaara koqema amitovaro Hanaava qorainti vainti taaramonavu vatatero nahenti taaraqanta vatatora. Mintuvaro Samueriva Siloqi Kotira Naavuqi Kotira avuqaa variqiro viharo noruqama vura. ");
INSERT INTO tbg_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Eliva anomakero naampaiqama viro vaiharo irumanta airi enta vira maaqutanta Isareri vaiinti nahenti qoraiqama nimite vaura. Vitanta qora kaiqa varaqi viha oru Kotira Seri Naavu qentiqaa raqiki vau nahentika hampata vaite vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Minti vaura kaara Eliva vitantara tiharo, Oho, netanta nantihae qora okara auti variavo? Airi vaiinti nahenti netanta qora okara auti variara ti tiva timiamanta irunarave. ");
INSERT INTO tbg_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Ti maaqutantao, vi okarara qaqira kaate. Nora Kotira vaiinti nahenti netanta qora okara auti varia uvara tivaqi vi ani variavo. ");
INSERT INTO tbg_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Vo vaiintivano nai kena vaiinti vo qora okara autu amitairera, Kotivama vira uva avuqavuqama amitaanarove. Vaiinti vovano Nora Kotira qora okara autu amitairera, tavave vitanta tavaarana vaiharo vitanta uva avuqavu qianarove? tiro. Noravano Kotiva vitanta arukaainarara tiro, vitanta avu aatovano kempukaiqumanta kia nái qova tu uvara irura. ");
INSERT INTO tbg_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Ho vi entara Samueriva noruqe vaumanta Noravano Kotivavata vaiinti nahentivata virara quaheha vaura. ");
INSERT INTO tbg_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Vo enta paropeti vaiinti vovano Eliva vaunaini oruntero tiharo, Noravano Kotiva ariara mintima tivo: Haaru Isipini Pero vaiintivano ai kaivaqara Eroniravata, vira ankuvata, rumpataa entara, te vika kahaqirera tuvunte tenta mpeqa okara vika numiqaura vika tavaarave. ");
INSERT INTO tbg_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Isareri vo anku vo anku variamanta te vikaqihai ai kaivaqara Eronira ankuqai kaamate, vikaraqai ti kaiqa vara timiteka vaivarave, tunarave. Te vikaqaima qaqi kaari ti Kotika ofaa taintaqaa iha quara timitaate, tunarave. Vikaqaima koqe unta iaina haikara iha quara timiteka vaivarave, tunarave. Vikaqaima ti Kotika avuqaa vaiha efoti tavuna nonku teha ti kaiqa vara timitevarave, tunarave. Te vikaqai tiva nimi tiha, Isareri vika ti ofaa taintaqaa iha quara timiteraqaahai ne homa hini mati varake nevarave, tunarave. ");
INSERT INTO tbg_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Ho nantiharae are te tiva tauna uvara qaqira kera ti ofaa okara vehiqama kera iaro? Are nena maaqutanta qaqi kaaramanta vitanta Isareri vika ti ofaa iha quara timite variaraqihai koqe mati varakeha namaqi vi variavaro vitanta vaatavano noruqe vaivo. Are vitanta qaqi kehara, vitanta autu noraiqama kera, ti hutu vatainiqama kaaro. Nantiharae are minti okarara auti variaro? ");
INSERT INTO tbg_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Oho, te tiarirara iriane. Te Noravano Kotika ni Isareri Variqavano vauro. Haaru te ai kaivaqara Eronira nai vaintiaravata tiha, Vika homa ekaa enta ti kaiqa vara timitaqi vivarave, tunarave. Ho ninavu qora okara kaarama te vate vo uva tirerave. Te mintima turo: Vaiintivano ti hutu noraiqama kainara tevata nai autu noraiqama karerave. Vaiintivano ti qoririma kainara tevata nai qoririma karerave, turo. ");
INSERT INTO tbg_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Ho iriane. Vo enta anintairaqe te vi entaraqaa ai anku qoraiqama nimiteha ekaa qaraaka vaiinti vikavata arukarerave. Ai ankuqihairo kiama vo vaintivano qaqi variqiro viro vuru naampaiqianarove. ");
INSERT INTO tbg_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Te Isareri hini kika koqema nimitaari vika koqemake vaivara are vika tavehara taara nenarave. Vika koqemake variqi vivaro, ai ankuqihairo kiama vaiinti vovanovata variqiro viro vuru naampaiqama vuanarove. ");
INSERT INTO tbg_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Ai ankuqihai kia qutiraiti, qaqi vaika, vika nora maaraqi variqi vivaro vika muntuka qoraiqiramanta variqi vi vaiqe te navutaaka qaqi kaari vika are kuvuarama terauka ekaama aru taiqa kevarave. ");
INSERT INTO tbg_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Ai maaqutanta Hopinika Finiaasika vitanta vohaa vakama qutu vivarave. Vitanta qutu vi entara, ai aato kenko tirara are quqaama vi uvava vivau vaivo tinarave. ");
INSERT INTO tbg_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Naantiara te vo vaiinti noraiqama kaariraro vi vaiintiva ti muntukavano vaina kaiqarara noraiqaakero iriqiro viharo, koqema kero ti kaiqa vara timitaqiro vuanarove. Te qaqi kaari vira vainti vika te kaamate noraiqama kaarirauka kaiqa vara nimitaqi vuate. ");
INSERT INTO tbg_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Vi entara ai vainti vikaqihai tau vaiintikae qaqi vaika, vika oru ti Kotika kaiqa vara timite variaina vaiintira vorara tiha, Mpo, karave monuve, timiraqe tenavu ho variare. Hoe are tinavu qaqi kairaqe tenavu Kotira kaiqa vo vara amiteha, koqaa vare oru kara varaare, tivarave, tirave. Noravano Kotiva minti tivakero ariara minti tivakera tiva amiane tivera te vi uvarama vate ai tiva amuro, tiro. Paropeti vaiinti viva minti tura. ");
INSERT INTO tbg_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Ho Samueriva quvaaraa vaintivano vaiharo Nora Kotira kaiqa vara amite vauvaro Eliva viraqaa raqiki vaura. Vi entara Noravano Kotiva kia airi uva qoqaiqama kero Isareri vika tiva nimiraitiro vauvaro, airi ihi aitarora. Vohaa enta vohaa entaqai tairakaa viva uva vika tiva nimi vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Ho Eliva naampaiqama vuvaro aumakaa vira avuvano ekaara qimpa vire ura. Vo enta entaqi viva Kotira Naavu rumu vo nai vaite vauraqi vaite vauvaro ");
INSERT INTO tbg_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samueriva Kotira Naavu viraqi Kotiva uva tiva taatauto Vokisera vato rumuraqi vaite vauvaro aumakaa aatitare uvaro Kotira Naavuqi ova qumpitova qaqiqai ite vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Mintuvaro Noravano Kotiva Samuerira aareharo, Samuerio, tuvaro Samueriva, Vo, tiro. Te mainima vauro, tivakero ");
INSERT INTO tbg_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","himpiro kantero oru Elirara tiharo, Are ti haaraaravera te anuro, tuvaro Eliva aqao tiro, Kiama te ai aarauro. Qaiqaa oru nena taintaqaa vaitaane, tuvaro viva anirantero oru nai taintaqaa vaitatero vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Mintuvaro Noravano Kotiva qaiqaa vira aareharo, Samuerio, tuvaro viva himpiro qaiqaa Eliva unaini oruntero tiharo, Are ti haaraaravera te anuro, tiro. Minti tuvaro Eliva tiharo, Ti maaquo, te kiama ai aarauro. Qaiqaa oru nena taintaqaa vaitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Noravano Kotiva kia haaruvata vikantiro uva turara tiro, Samueriva Nora Kotira uva vira kia viraaqama kero iriraitiro vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Ho taaramo tataa Noravano Kotiva Samuerira aarovaro Samueriva himpiro Eliva unaini oruntero tiharo, Are ti haaraaravera te anuro, tiro. Minti tuvaro Elira aatovano kenko tuvaro iruvaro Noravano Kotiva Samuerira aare vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Mintuvaro Eliva Samuerira tiva amiro tiharo, Are qaiqaa nena taintaqaa oru vaite vairaro viva qaiqaa ai aarairera, are mintima tiane: Noravauvo, are tiraqe iriare. Te ai kaiqa vaiintivano irihama vauro, tiane, tuvaro Samueriva Eliva tunte iro oru taintaqaa qaiqaa vaitatero vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Vaite vauvaro Noravano Kotiva anintero himpiro vaiharo vira avuni aarontema kero qaiqaa aarero tiharo, Samuerio, Samuerio, tuvaro Samueriva tiharo, Noravauvo, are tiraqe iriare. Te ai kaiqa vaintivano irihama vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Minti tuvaro Noravano Kotiva vira tiva amiro tiharo, Koqema kera iriane. Aumakaama te Isareri vika avutaini vo kaiqa qovarama kaari ekaa vi uvara irika voqamake ravuku vivarave. ");
INSERT INTO tbg_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Vi entara te Elira ankuqi ekaa qora okara qovarama karerave tiva tauna uvava, ekaa vi uvava vivauma varianarove. ");
INSERT INTO tbg_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Te tota Elira tiva amunarave: Elira maaqutanta qora kaiqa vare vaiha ti Nora Kotika qoraiqama timite variavaro viva vitanta qora kaiqa vare variara iriharovata, kia vitanta qioqama kaira kaara, te viraqaa uva vataarirava kia taiqa viraitiro, ekaa entama varianarove. ");
INSERT INTO tbg_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Te kauqu aiqiqaa aqukeha Elira ankuara mintima turo: Vika nana nana ofaave, ti iha quara timiteva kia ho vika qora kaiqa vare uvara nunka taiqa nimitaanarove. Vi uvava ekaa enta qaqiqai varianarove turo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samueriva vi uvara iriro nai vaite vau taintaraqaa variqiro viro aatita kora. Toqaqira viva himpiro oru Nora Kotira naavu qentinavu qantuareharo Elira aatu qeteharo taira voqaara tavora kia vira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Mintuvaro Eliva Samuerira aarero tiharo, Samuerio, ti maaquo, aniane, tuvaro Samueriva vo tivakero, Te maa virama anuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Minti tuvaro Eliva vira irero tiharo, Noravano Kotiva ariara nana uvae tivo? Are kiama vo uvavata kukeqa taane. Are vo uva kukeqa tairaro Kotiva ai anoma kero qoraiqama amitaantorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Minti tuvaro Samueriva kia vo uva kukeqa karaitiro, ekaa vi uvara tiva amuvaro Eliva vi uvara iriro tiharo, Viva nai Noravano Kotivave. Kairaro viva nana haika tiqaave ti ankuqaave autuataa iraro autuarire, tura. ");
INSERT INTO tbg_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Ho Samueriva noruqe vauvaro Noravano Kotiva vikantiro vaiharo vira kahaqama amite vauvarora tiro, Samueriva vaiinti nahenti vikara minti mintima vaina haikava qovaraiqianarove tuntema kero, vi haikava vi haikava qovaraiqi vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Mintumanta ekaa Isarerini vauka kankomake iruvaro Noravano Kotiva Samuerira quqaa kaama tovaro, viva Nora Kotira uva qovaraiqamake vau vaiintiva, paropeti vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Tota Silo vatukaini qovarama viro nai uva Samuerira tiva amuntema kero, Noravano Kotiva qaiqaa qaiqaavata nai uva vira tiva ami vauvaro Samueriva vi uvara Isareri vika tiva nimi vaumanta vika iri vaura. ");
INSERT INTO tbg_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Vi entara Pirisia vatanaaka Isareri hampata iqoka raqireka umanta Isareri iqoka vaiinti vika Ebenesa vatuka aumanto nái seri naavu maaqa kaqa tomanta Pirisia vika Afeki vatuka aumanto nái seri naavu maaqa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Viraqaahai Pirisia iqoka vaiinti vika Isareri hampata ani iqoka raqiha, Isareri naatara keha 4,000 vaiinti aru kora. ");
INSERT INTO tbg_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Mintumanta Isareri iqoka vaiinti hini kuka orurante nái seri naavu maaqa vaunaini anumanta Isareri qiata vaiintinavu vikara tiha, Nana kaarae Noravano Kotiva Pirisia qaqi kaimanta vika tinavu haatara kaavo? Kaiqe tenavu vaiinti vonavu nititaari vika Siloqihai Noravano Kotiva uva tiva taatauto Vokisera vare aniate. Tenavu raqirera viha, vi Vokisera aqu vare vuariraro Noravano Kotiva tinavu hampata vairamanta tinavu navutaaka kia tinavu haatara kaate, ti. ");
INSERT INTO tbg_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Qiata vaiinti vika minti tivake vaiinti vonavu nititomanta Siloni orunte Noravano Kotiva ekaa kempuka vatai Variqava uva tiva taatauto Vokisera vira vare anura. Vi Vokiseraqaa enseli maraqura/varaha taaraqanta vauvaro vitanta avutana Noravano Kotiva oquviro vau vatukava vaura. Vika uva tiva taatauto Vokisera vare anuvaro Elira maaqutanta Hopinika Finiaasika Vokise viraqaa raqikiqi anumanta vare anura. ");
INSERT INTO tbg_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Vika Noravano Kotiva uva tiva taatauto Vokisera vare seri naavu maaqa kaqatonaini anintomanta Isareri vika ekaa quaheha noraiqaake naverai tuvarora tiro, vatavanovata qaki qaki i vaura. ");
INSERT INTO tbg_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Mintumanta Pirisia vika uva nontanta/otata iri tiha, Oho, Hiparu vatanaaka seri naavu maaqaqihai nana kaarae naveraiti variavo? tivake vaiha irumanta Nora Kotira Vokisevano vika seri naavu maaqa kaqatonaini ani vaura. ");
INSERT INTO tbg_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Mintumanta vika qeteha tiha, Variqa vovano Isareri seri naavu maaqa kaqataaraqi ani vaivo. Oho, vate tenavu qoraiqama virarave. Haaru kia minti haikava tinavuqaa qovaraiqi vairave. ");
INSERT INTO tbg_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Mpo, tavave tinavu ruaruama timitairaro vika Variqa kempukavano kia tinavu qoraiqama timitaarire? Vi Variqava qora haika, vo qara vo qara i haikaraqohairo Isipi vika qoraiqama nimitaimanta vika airitahaa aahara vataini qutu vuarave. ");
INSERT INTO tbg_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Ho Pirisia vatanaakao, kaiqe tenavu kempukaiqamake qorainti taruka raqintemake raquare. Kia mintiarera, tota vika tinavu paanaa kaiqa vara timitaantemake, tenavuvata vika nái paanaa kaiqa vara nimitaarorave. Ho aniqe kempukaiqamake vaiha qorainti taruka raqintemake raquare, ti. ");
INSERT INTO tbg_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Minti tivake Pirisia vika kempukaiqamake raquqi viha Isareri naatara komanta Isareri vika qetake ruqemake nai maaqa nai maaqaini vura. Vi entara Pirisia vika Isareri airitahaa 30,000 vaiinti aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Vika Elira maaqutanta Hopinika Finiaasika aruke, Nora Kotira vira Vokisevata raqiake vare vura. ");
INSERT INTO tbg_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Mintuvaro vohaa vi entaraqai Benaminira ankuqihairo iqoka vaiinti vovano iqoka raqi vaura mini kero kantero Silo vatukaini oruntora. Vi vaiintiva nai utavaaqa qunahi qaanahima kero hora vara kero nai qiataqaa aqutero kantero Siloni oruntovaro ");
INSERT INTO tbg_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Eliva mini aara auvahini nai oquvi vau taintara aratoraqaa oquviro vaiharo Nora Kotira Vokise qaiqaa vare anirara noraiqaakero avu aato utiharo vira veka vaura. Viva mini vauvaro iqoka vaiinti viva vatukaini anintero raqu vakaakara vaiinti nahenti tiva nimumanta ekaa vika ike mpo tiha noraiqaake oi aai ti vaura. ");
INSERT INTO tbg_vpl VALUES ("S14_14","010_4_14","1SA","4","14","15","Ho Eliva airi ihi 98 ihi varakero anomakero naampaiqama vuvaro vira avuvanovata qimpa vuvaro viva aara auvahini vaiharo uva nontanta/otata iriro tiharo, Nana kaarae noraiqaake oi aai ti variavo? tiro. Eliva minti tuvaro iqoka vaiinti viva kantero oruntero Elira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Te vate raquaraqihai ruqemakema maini anuro, tuvaro Eliva vira irero tiharo, Ti maaquvauvo, iqoka raqua uvava nantiakeroe vaivo? Tiraqe iriare, tuvaro ");
INSERT INTO tbg_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","vi vaiintiva Elira tiva amiro tiharo, Pirisia vika raquqi viha tinavu haatarake tinavu iqoka vaiinti airitahaa arikaamanta tenavu vika naatu qetake ruqemake vi anima vuro. Vika ai maaqutanta Hopinika Finiaasika aruke, Kotira Vokisevata raqia vare vuavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Eliva Kotira Vokise vare vu uvara iriro, viva nai oquvi vau taintaraqaahairo tauvaqaihairo umpaihavuviro Kotira Naavu qenti vaunaini hiqintura. Viva anoma naampaiqama vuvaro vira vaatavano voqama kero noruqama tovarora tiro, viva hiqintiro nai anu kinta kero qutu vura. Eliva 40 ihiara Isareri vikaqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Vi entara Elira naaqutu Finiaasira naatavano vainti taiqama vuvaro vainti vataarira entava aumaiquvaro vovano Pirisia vatanaaka Kotira Vokise vare vurave, vira vaati arukorave, vira tonaqova qutu vurave, ekaa vi uvara vira tiva amuvaro irura. Viva vi uvara irira kaara vainti vataarira aihavirava vaaka hoqarama tovaro viva voqamakero keke tivaqiro viro vuru vainti vatatora. ");
INSERT INTO tbg_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Viva aumakaa qutu vire umanta vira kahaqama amito nahentika vira tiva amiha tiha, Kia qetaane. Are qorainti vaintima vatatera iaro, tuvarovata, vi nahentiva kia nai aato vika nimiraitiro, kia vika uvavata nái tiva nimiraitiro, ");
INSERT INTO tbg_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","nai vainti vira autu ntavatero tiharo, Ikabotirave – Kotira mpeqa okara takuqi vaiva Isareri kero vivo, tura. Vika Kotira Vokise vare vurave, vira tonaqova nai maaquntiro qutu vurave virara iriharo vi autura ntava tora. ");
INSERT INTO tbg_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Viva tiharo, Vika Kotira Vokise Isareri vataihai vare vuara kaara, Kotira mpeqa okara takuqi vaivavata Isareriqaahairo ekaarama vinivo, tivakero qutu vura. ");
INSERT INTO tbg_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Pirisia iqoka vaiinti Kotiva uva tivakero taatauto Vokisera vare Ebenesa vatuka vara maini ke nái nora vatuka Asadotini orunte ");
INSERT INTO tbg_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Vokise vira vare vuru nái una variqa Dagonira quahama amite vau naavuraqi vatora. Vika Dagonira maraqura/varaha oriqohai autuke vatora vira tataaqa Vokise vira vatora. ");
INSERT INTO tbg_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Viraqi vatomanta vira qararaa toqaqi Asadotihainaaka nái una variqa naavuqi oriqete tavovaro Dagoniva hiqintiro nai viri vataini kero, Nora Kotira Vokise avuqaa vaura. Mintumanta vika Dagonira maraqura/varaha vara vaaviaramake qaiqaa nai vaunaini vatora. ");
INSERT INTO tbg_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Vika entaqi vaite qararaa toqaqi ani tavovaro Dagonira maraquravano/varahavano qaiqaa virianaihairo vata kanta hiqintiro Nora Kotira Vokise avuqaa vaura. Dagonira qiatavata kauquvata kintavi qenti kanta nariara vauvaro vira vaatavanoqai qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Mintura kaara vate maa entaravata Dagonira kaiqa vara amite variakave, vokiakave, vira qiatavata kauquvata qentiana hiqinti vainaini aiqu ntava taarorave ti, vika aiqu vaatinte vaarintemaqi vi ani variara. ");
INSERT INTO tbg_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Ho Noravano Kotiva Asadoti vatukaqi vaukavata, vira aumanto vaukavata, qoraiqama nimitovaro meqa/veqa numuaravano vika vaataqaa qovarama viro ite vaumanta vika voqamake qete vaura. ");
INSERT INTO tbg_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Mintumanta Asadoti vatukaqi vauka vi haikara vi haikara qovaraiqura tave tiha, Isareri Variqavano tinavuvata, tinavu variqa Dagoniravata qoraiqama timiteharo nora maara tinavuqaa vate vaivo. Vira kaara Isareri Variqa vira Vokisevano kia maini variarire, ti. ");
INSERT INTO tbg_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Vika minti tivake Pirisia avuhainaa vaiinti 5navu naarama komanta vika vinavuka ireha tiha, Isareri Variqa Vokise vira tenavu nantie irarave? tumanta vinavuka vika tiva nimi tiha, Ne vi Vokisera vare muntu Geti vatukaini vataate, tumanta vika vira vare Pirisia nái vatuka vo, Geti mini muntu vatora. ");
INSERT INTO tbg_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Geti mini muntu vatovarovata, Noravano Kotiva vi vatukaraqi vaukavata qoraiqama nimitomanta vika voqamake qete vaura. Noravano Kotiva meqa/veqa numuara vara kovaro ekaa vaiinti nahenti, qaraakaukave, konta naampaive, vika vaataqaa ite vaura. ");
INSERT INTO tbg_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Mintumanta Getihainaaka Kotira Vokise vira vara kovaro Pirisia vatanaaka vatuka vo Ekaronini vura. Mini oru ntomanta vi vatanaaka noraiqaake oi aai tiha, Oho, vika tinavu ekaa aru taiqa karekama Isareri Variqa Vokise vira vare maini aniavo, ti. ");
INSERT INTO tbg_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Minti tivake vika Pirisia avuhainaa vaiintinavu naaramake vikara tiha, Mpo, nenavu Isareri Variqa Vokise vara kaivaro anirantero nai maaqaini vuarire. Nenavu kia mintivera, viva tinavu tintanavu vaiinti nahenti hampata aru taiqama kaanarove, tura. Kotiva vika qoraiqama nimitomanta airi vaiinti nahenti qutu vura kaara vi vatanaaka voqamake qete vaura. ");
INSERT INTO tbg_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Vokuka kia qutiraiti, qaqi vauka vika vaataqaa meqa numuaravano qoraiqama kero ite vaumanta vika nái una variqanavuara ike mpo tiha, Tinavu kahaqiate, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Nora Kotira Vokisevano Pirisia vataini vaiharo 7 toranavu vara komanta ");
INSERT INTO tbg_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","vika una variqa kaiqa vara nimitokave, vure vaiinti vikave, naaramake vinavuka ireha tiha, Nora Kotira Vokise vira tenavu nantie irarave? Tenavu Isarerini qaiqaa vara kaariraro vuarire ti, nana haika hampatae vira vara kaariraro vuanarove? ti. ");
INSERT INTO tbg_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Vika minti tumanta vinavuka tiha, Ne Isareri vika Variqa Vokise qaiqaa vara kareka iha, kiama qumina vara kaivaro vuarire. Ne vika Variqara irihama, ofaa hampata vara kaivaro viraroma viva ni qora okaravata nunka nimiteharo ni rovaravata taiqa kaarire. Mintihama ne kankomake iri tiha, Tota tenavu kia vira Vokise vara kaunara kaara Isareri Variqavano tinavu qoraiqama timite vairave tivarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Vinavuka minti tumanta vaiinti nahenti qaiqaa vinavuka ireha tiha, Tenavu Vokise vira hampata nana ofaae vara kaariraro vuanarove? tumanta vinavuka tiha, Vohaa qaramake vai rovarava nivata, ni Pirisia avuhainaa vaiinti 5navuvata, arirara ti, ne kori oriqohai meqavano ni vaataqaa numuara ite vaira maraqura/varaha 5navu autuke, tuvura maraqura/varaha 5navuvata autu kaate. ");
INSERT INTO tbg_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Ne meqa numuara maraqura/varaha autuke, ni naahoqi tuvuravano kara qoraiqama nimite vaira maraqura/varaha autuke, vira vara kaivaro Isareri Variqa Vokise hampata vuarire. Ne mintima keha Isareri Variqa autu tuahera kaivaro, viva kia qaiqaa nintave, ni variqave, ni vatave, qoraiqama nimitaraitiro, ni vehakumae nimitaanarove, kiae mintianarove? ti. ");
INSERT INTO tbg_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Vinavuka minti tivake qaiqaa tiha, Isipi vatanaaka Pero vaiinti hampata nái avu aato kempukaiqamate Isareriara kia ho vivarave tiara kaara Isareri Variqavano Isipi vika ntaihama kaintema kero, hauri nivata ntaihaantorave. Isareri Variqavano vika voqama kero qoraiqama nimitaira kaara ekaara vitini Isipi vika Isareri qaqi kaamanta vuarave. ");
INSERT INTO tbg_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Ho iriate. Ne qaraaka ohi veka vo autuke, viraqaahai purumakau nahe taaraqanta kia rumpataivaro kaiqa varainara vitanta naativano qaqi naama ne vainara rantake vare aniate. Ne purumakau vitanta vare vuru ohi veka viraqaa kantaruma taate. Mintimake viraqaahai vitanta naati ntita vare vuru avutaqi kaate. ");
INSERT INTO tbg_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Ho Nora Kotira Vokise vara vaari ohi veka viraqi vataate. Vika Variqavano ni qora okara nunka nimitaarire ti, ne tuvuravata meqavata/veqavata koriqohai autute haikara varake vo vokiseqi vate, vokise vira vara vaari Kotira Vokise tataaqa vate, viraqaahai purumakau vitanta ruhaaqi kaimanta ohi veka vira rarau vare náitanta vuataa ina aararaqaa vuate. ");
INSERT INTO tbg_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Vitanta vi vaimanta ne aitutiha tavaate. Vitanta ˻kia náitanta naatitanta avutaqi kenaini viraiti, qaqirake˼ Isareri vatuka vo, Beti-Semesini vi varia aararaqaa vivera, ne ho mintima tivarave: Quqaama Isareri Variqavanoma tinavuqi qora maara vara kaivaro tuvivo, tivarave. Ne tavaimanta vitanta ohi veka rarau vare kia mini vivera, ne mintimama tivarave: Kia Isareri Variqavanovauve nora maara vara kaivaro tinavuqi qovaraiqivo. Nai quminama maaravano tinavuqi qovaraiqivo, tivarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Vinavuka minti tumanta vika vinavuka uva tuntemake, purumakau nahe taaraqantaqaa qaraaka ohi veka aututora kantarumate, viraqaahai vika purumakau nahe vitanta naati ntita vare vuru náitanta avutaqi vaati ke, ");
INSERT INTO tbg_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","viraqaahai vika Nora Kotira Vokisevata, koriqohai meqavata/veqavata, tuvuravata autuke vato vokisera viravata vara vaari ohi vekaqi vatora. ");
INSERT INTO tbg_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Vika minti mintimake, viraqaahai purumakau vitanta ruhaaqi komanta vitanta ohi veka vira rarau vare viha, kia hampi vo aara vo aaraqaa viraiti, avuqavuqamake Beti-Semesi aaraqaa viha mmm mmm tivaqi vi vaura. Vitanta aaraini vi vaumanta Pirisia avuhainaa vaiinti 5navuvano ohi veka vira ampeqama vare vivi, Beti-Semesi aumanto oruntora. ");
INSERT INTO tbg_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Mini oruntomanta Beti-Semesihainauka uqita kanta vaiha uiti ututora teqe vaiha vutu aaraini tavovaro Kotira Vokisevano mini vauvaro vika muntukaqihairo quahara haikavano qovaraiqumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Purumakau vitanta ohi veka rarau vare Beti-Semesihainaa vaiinti vo, Iosuaara naaho vaunaini nora ori tataaqa himpite vaumanta Rivaira ankuqihai vaiinti vonavu aninte, Nora Kotira Vokisevata, koriqohai aututo haikava vau Vokiseravata varake, ori viraqaa vaari vatora. Ho vinavuka mintumanta vaiinti nahenti vika Nora Kotirara quahama amitareka, ohi veka vira rakavuke iha quarate, purumakau nahe vitanta aruke ofaa Nora Kotira ekaara kaintu iha quara amitora. ");
INSERT INTO tbg_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Vika mintumanta Pirisia vika avuhainaa vaiinti 5navu niaraini vaiha ampeqamake taveke, vohaa vi entaraqai vika anirante nái maaqa Ekaronini vura. ");
INSERT INTO tbg_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Pirisia vika Noravano Kotiva nái qora okara autura nunka nimitaarire ti, vika nái nora vatuka 5navu, Asadotive, Gaasave, Asakelonive, Getive, Ekaronive, vinavurara iriha maraqura/varaha 5navu aututora. ");
INSERT INTO tbg_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Pirisia avuhainaa vaiinti 5navu raqiki vau vatukara, vaantaavura ututorave, qaqi vau vatukarave, virara iriha, vika kori oriqohai tuvura maraqura/varaha aututora. Nora Kotira Vokise varake vato oriva, Beti-Semesihainaa vaiinti Iosuaara naahoqi vaura. Vate maa entaravata nora ori viva qaqi mini vaimanta vaiinti nahenti vi orira taveha, vi entara qovaraiqura viraravata iriha variara. ");
INSERT INTO tbg_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Ho Vokise viva mini vaumanta Beti-Semesihainaa vaiinti vonavu tiha, Kaiqe Vokise avutaqi tavaare tivake, viraqi qantuake tavora kaara Noravano Kotiva vihainaa vaiinti 70navu arukora. Mintumanta vaiinti nahenti Noravano Kotiva vinavuka arukorara iriha, noraiqamake iqi ratora. ");
INSERT INTO tbg_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Vika mpo ike ti, Nai tavave Noravano Kotiva nai voqama kero takuqukero vai Variqara avuqaa ho himpi varianarove? Viva tinavuara arara itairera, kia vovanovata qaqi himpi varianarove. Oho, tenavu tainie Vokise vira vara kaariraro vuanarove? ti. ");
INSERT INTO tbg_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Minti tivake vika vaiinti vonavu nititomanta vinavuka Kiriati-Jearimi vatukaqi vaukara tiha, Pirisia vika Nora Kotira Vokise vara kaavaro qaiqaa tenavu unanaini ani vaivo. Ho ne tuvu vira vare vuru nenta maaqaini vataate, tura. ");
INSERT INTO tbg_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Vika minti tumanta Kiriati-Jearimihainaaka Nora Kotira Vokise vira ani vare Abinadaapira naavuvano inaara aiqinaqaa vaunaini vuru vate, Abinadaapira maaqu Eleasaara kaamate tiha, Arema Kotira Vokise viraqaa raqikiane, ti. ");
INSERT INTO tbg_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Vika minti tivake Nora Kotira Vokise vira Kiriati-Jearimini naavuqi vatovaro, Vokise viva 20 ihi varakero naavu viraqiqai vaumanta ekaa Isareri vika mpo ike tiha, Noravauvo, ˻kia tinavu qaqira karaitira,˼ tinavu kahaqiane, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Ho Samueriva himpiro Isareri vika ekaa tiva nimiro tiharo, Ne quqaiqamake qora aara qaqirake, Nora Kotira uva qaiqaa iriqi vireka ivera, ne vo vatanaaka una variqa vaterave, una variqa nahenti Astaatera maraqura/varaha haikave, qaqirake, Nora Kotira vevaaraini vaiha, Kotira kaiqa vaiinti nahentiqai vaiha, vira autuqai tuaheraqi vuate. Ne mintivaro Kotiva Pirisia vatanaaka kauquqihairo ni ruaruama nimitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Samueriva minti tumanta Isareri vika viva tuntemake, una variqa maraqura/varaha Baaliravata Astaateravata vara qaqirake, Nora Kotira autuqai tuaheraqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Vo enta Samueriva Isareri vika naarama kero tiharo, Ne Misipaa vatukaini ani ruvaaqumavi vaiqe te Nora Kotira ni aarama nimitaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Ho Isareri vika Misipaa vatukaini ani ruvaaqumavi vaiha namari kaqakeha kia naraiti, Nora Kotira ofaa amiteha namari vira qaqi vata kanta qihiake vaura. Vohaa vi entara vika karavata qioqamate kia naraiti, qaqi variqi vi, entama kora. Vika nái qora kaiqa varo uvaravata tiva qovarama keha tiha, Mpo, tenavu Nora Kotira uva raqakeha qora kaiqa vare vaunarave, ti vaura. Samueriva Misipaa vatukaini vau entara viva Isareri vika qiata vaiinti vaiharo vika uvavata iriharo avuqavuqama nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Ho Pirisia vika Isareri Misipaa vatukaini ruvaaqumavi vaurara iri, viraqaahai vika avuhainaa vaiinti 5navuvano nái iqoka vaiinti ntita vare oru Isareri hampata iqoka raqireka vumanta Isareri vika anura iri, voqamake qete vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Vika Samuerirara tiha, Mpo, are tinavu Variqa Nora Kotira aaramaqira vihara kia taiqa karaitira, qaqiqai aaramaqira vi vairaro viva Pirisia kauquqihairo tinavu ruaruama timitaarire, ti. ");
INSERT INTO tbg_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Vika minti tuvaro Samueriva sipisipi naati vo varakero vira arukero Nora Kotira ofaa kaintu iha quara amiteharo viva Isareri kahaqiarire tiro, vira aarovaro Noravano Kotiva Samueriva tu uvara iriro Isareri vatanaaka kahaqama nimitora. ");
INSERT INTO tbg_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Samueriva Nora Kotira ofaa qaqi iha quara amite vaumanta Pirisia iqoka vaiintinavu aumanto aninte Isareri hampata raqireka auti vauvaro Noravano Kotiva tuvaro naaruvaihairo naaruvavano Pirisia iqoka vaiinti qiata vau taku takaa ti vaumanta vika avu aatovano hampiqi vaumanta qetake ruqeqaamake vi ani vaumanta Isareri vika naatara kora. ");
INSERT INTO tbg_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Isareri vika Misipaa vara maini ke Pirisia iqoka vaiinti ntataqi viha airi vaiinti aruqi vivi, Beti-Kaa aumanto oruntora. ");
INSERT INTO tbg_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Mintuvaro viraqaahairo Samueriva ori nora vo varakero, Misipaa vatuka hini Seni vatuka hini tavaarana ori vira vuru vaaviarama tero tiharo, Te maa orira autu ntehama, Ebe-Nesaave – Kahaqama-Timitai-Orirave, turo. Noravano Kotiva vate tinavu kahaqama timitairara irihama te minti turo, tura. ");
INSERT INTO tbg_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Ho Isareri vika Pirisia naatarako entaraqaahairo Noravano Kotiva Pirisia vika kuvai komanta, vika Samueriva vau entara kia qaiqaavata Isareri vataini iqoka raqireka ani vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Haaru Pirisia vika iqoka raqiha Ekaronivata Getivata, vi vatukatanta tavaarana vau vatukara vonavuvata varora qaiqaa Isareri nái nimumanta varora. Vi entara Isareri kia Kenaani vatanaaka hampata raqiraiti, qaqi maateraiqiha vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Ho Samueriva nai qaqi vau entara Kotira kaiqa vara amiteharo Isareri vikaqaa raqikiqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Vo ihi vo ihi Samueriva Betelinive, Giligaalinive, Misipainive, vi aniharo Isareri vika uva iriharo avuqavuqama nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Viva mintima keharo anirantero nai maaqa Ramaini oru vaiharo vika uvavata avuqavuqama nimite vaura. Viva mini vaiharo Nora Kotira ofaa tainta vo autu amitora. ");
INSERT INTO tbg_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Samueriva naampaiqama viro nai maaqutanta noraiqama komanta vitanta Isareriqaa raqikiqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Samuerira maaqu hoqarenaava Joeliva vauvaro vira qata Abiaava vaura. Vitanta Beseba vatukaini vaiha vaiinti nahenti uva avuqavuqama nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Vitanta kia náitanta qova koqe kaiqa varontemake vararaiti, vitanta monu varerara noraiqaake iriha, qutaru monu naarumake vareha vika uva kia avuqavuqamake iriraiti, hampiqama keha iri nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Mintura kaara Isareri nora vaiintinavu Samueriva Ramaini vaunaini orunte ruvaaqumavi ");
INSERT INTO tbg_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","virara tiha, Ho are iriane. Are naampaiqama vuaramanta ai maaqutanta kia are koqe okara autuanantemake autiraiti, vitanta qora okarama auti variavo. Vira kaara are vaiinti vo noraiqama kairaro viva tinavu avuhainaa vaiintiqama viro vaiharo tinavuqaa raqikiarire. Ekaa vo vatanaa vo vatanaaka avuhainaa vaiinti vataantemake, tenavuvata vo vataare, ti. ");
INSERT INTO tbg_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Nora vaiinti vika minti tuvaro Samueriva vika avuhainaa vaiinti vo kaama timitaane tu uvarara kia quaharaitiro, vikara tiharo, Kaiqe te Nora Kotira aaraariraro viva vonare tiraqe ni tiva nimiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Minti tivakero viva Nora Kotira aarovaro Noravano Kotiva Samuerira tiva amiro tiharo, Ho are ekaa vika ti uvara iriane. Vika kia arivauve qoririmake variavo. Vika ti Kotika vika avuhainaakama qoririmake variavo. ");
INSERT INTO tbg_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Oho, haaru Isipiqihai te Isareri vika ntita vare viri kauna entaraqaahai vika ti tauvaqa utu timitehama una variqa autuqai tuaheraqi aniavaro vate maa entava anintaivo. Ho vika ti qoraiqama timitaantemake, vohaa vikaqai aivata qoraiqama amite variavo. ");
INSERT INTO tbg_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ho minti tiarara irihara are nái tiantema kera, are vaiinti vo noraiqama kairaro viva vika avuhainaa vaiintivano variarire, turo. Are mintima keravata, vikara rauriha variate tiane. Avuhainaa vaiintivano vikaqaa raqikiharo nana nana okara autuainarave, nana nana qora maara vikaqaa vataainarave, virara virara vutukera vika tiva nimiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Viva minti tuvaro Samueriva vika avuhainaa vaiintiara naarumatoka vaunaini oruntero, Noravano Kotiva tu uvara ekaa vika tiva nimura. ");
INSERT INTO tbg_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Viva tiharo, ˻Ne kia paparuqama keha tiriara avuhainaa vaiinti vo noraiqama timitaane tiate. Ne kiae iriavo?˼ Avuhainaa vaiinti vovano niqaa raqikiharo niara minti minti iatema tianarove: Viva ni maaquvara ntita vatairamanta vika vira iqoka vaiintiqamavi vaivarave. Vokika vika iqoka kaariqi ni vaimanta, vokika ohiqaa oquvi nivarave. ˻Vaiinti nahenti vinuate ti,˼ vokika avuhainaara iqoka kaariqi avuni kantamaqi vivarave. ");
INSERT INTO tbg_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Viva vokika noraiqama kaira vika 1,000 iqoka vaiintiqaa raqikimanta vokika 50navuqaa raqikivarave. Viva ni maaqu vokika ntita vataira vika avuhainaara naaho kaiqa vara amiteha vata quvike, kara ututaivaro karavano mpeqaiqinara qantu vare viri vira amitevarave. Vokika ntita vataira vika auvihehavaave, iqoka kaarive, autu amitevarave. ");
INSERT INTO tbg_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Viva ni raavura vokika ntita vataira vika avuhainaara koqe unta i vahaverara autu amiteha, vo kara vo karavata unta amitevarave. ");
INSERT INTO tbg_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Viva ni koqe vatave, uaini naahove, orivi naahove, niqaahairo varakero, nai kaiqa vaiinti vika nimianarove. ");
INSERT INTO tbg_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Ne uitive, uaini tavave, varake, 10navu vateraqihai rairake vohaiqa vira amivarave. Viva vi karara varakero raira kero nai qiata vaiintive, qaqi kaiqa vaiintive vika nimianarove. ");
INSERT INTO tbg_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Vira kaiqa vara amitaate tiro, avuhainaava viva ni kaiqa vaiintive, ni kaiqa nahentive, ni purumakauve donkive koqekaqaima varaanarove. ");
INSERT INTO tbg_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Viva ni sipisipi 10navuqihairo vohaiqama varaanarove. Ne vira paanaa kaiqa vara amitekama vaivarave. ");
INSERT INTO tbg_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Naantiara avuhainaa vaiinti viva niqaa vi maarara vataira vi entara ne mpo ike tivaqi viha nuntu nauntu tihama Kotirara tinavu kahaqiane tivarave. Ne nentama vi vaiintira noraiqama taavaro viva avuhainaa vaiintiqama virara ti, Noravano Kotiva vi entara kiama ni uva irianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Samueriva minti tumantavata, vika kia vira uva iriraiti, vika kempukaiqamake tiha, Avuhainaa vaiinti vo tinavu noraiqama timitairaro viva tinavuqaa raqikiarire. ");
INSERT INTO tbg_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Tenavu vo vatanaa vo vatanaaka variantemake variariraro tinavu avuhainaa vaiinti viva tinavuqaa raqiki vaiharo, tinavu tivita varero avuni viraqe tenavu navutaaka hampata iqoka raquare, ti. ");
INSERT INTO tbg_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Vika minti tuvaro Samueriva vika uva iriro vuru Nora Kotira tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Noravano Kotiva vira tiva amiro tiharo, Hove. Are vika uva avatehara vika avuhainaa vaiinti vo kaama nimitaane, tiro. Minti tuvaro Samueriva Isareri vika tiva nimiro tiharo, Ne ekaa nenta maaqa nenta maaqaini oru vaiqe naantiara te qaiqaa ni naaraare, tiro. Samueriva minti tura. ");
INSERT INTO tbg_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Benaminira ankuqihainaa vaiinti vo vira autu Kisiva vaura. Kisiva airi haika vatova vauvaro vira autuvanovata nora autu vaura. Vira anku okaravano maantimama vairo: Kisira qova Abieliva vauvaro Abielira qova Serova vauvaro Serora qova Bekoraativa vauvaro Bekoraatira qova Afiaava vaura. ");
INSERT INTO tbg_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kisira maaqu vo vira autu Soruva vaura. Soruva qaraaka vaiinti koqe viri vaata vataava vauvaro Isareri vikaqihai kia vovano Sorura voqaantema kero vukai vuhaantaari vataava vauvaro Soruva ekaa Isareri vikavata uri naatara kero vukai vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Ho vo enta Kisira donki vonavu ruqemake vi anima vi kakakima vura. Mintuvaro Kisiva nai maaqu Sorurara tiharo, Are kaiqa vaiinti vo vita varera vikantira oru donki vika ranta timitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Minti tumanta vitanta himpi verara Efaraimunivata, vo vata Salisainivata rantaqi viha tavomanta donki vinavuka kia mini vaumanta vitanta Saliminivata oru tavomanta kia vaumanta viraqaahai vitanta Benaminira ankuvano vau vatara minivata oru tavomanta kia vaura. ");
INSERT INTO tbg_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Vitanta mintiaqi vi, Sufu vatuka vaunaini orunte, Soruva nai kaiqa vaiintiara tiharo, Ho aniqetanta qaqirake anirante maaqaini vuare. Hauri ti qova donki vikara kia noraiqama kero iriraitiro, titantara noraiqaa kero iriantorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Soruva minti tuvaro vira kaiqa vaiintivano virara tiharo, Ho iriane. Sufu vatukaqi Kotira uva tiva nimi vai vaiintiva vovano vairave. Ekaa viva ti vai uvava quqaaqai vairara ti, vaiinti nahenti vi vaiintira nora autu amiarave. Aniqe tetanta viva inaini oru vuariraro viva titantara donki vikara mini mainima variavo tiainara iriare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Viva minti tuvaro Soruva nai kaiqa vaiinti virara tiharo, Ho tetanta viva inaini oruntaarera, nana haikae vira amirarave? Titanta karavano taiqa vivaro qumina utaqaima vaivo. Tetanta vo haika vira amiarirava kiama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Soruva minti tuvaro vira kaiqa vaiintivano tiharo, Te silvaa monu inaaraiqa ntuva tauro. Te vira amiariraro viva donki vika ta mantarainie vairara titanta tiva timiarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_9","010_9_9","1SA","9","9","11","Minti tuvaro Soruva virara tiharo, Ho are koqema tiaro. Aniqetanta kukeqavi vai haikara tave vai vaiintira oru tavaare, tivake vitanta Kotira uva tiva nimi vau vaiintiva vaunaini vireka vura. Vi entara Isareri vatanaaka paropeti vaiintiara viva kukeqavi vai haikara tave vai vaiintivama vaivo ti vaurara tiro, Soruva minti tura. Ho vitanta vivi, vuruni vau vatukara aumanto oruntomanta varaatanavu vatukaqihai namari kaqareka tuvumanta vitanta vinavuka ireha tiha, Kukeqavi vai haikara tave vai vaiintiva vatukaqi vairove kiae vaivo? ti. ");
INSERT INTO tbg_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Minti tumanta varaata vika vitanta tiva nimi tiha, Eo, kukeqavi vai haikara tave vai vaiintiva vatukaqima vaivo. Vaiinti nahenti vururaqaa Kotira ofaa iha quara amiterara iriharo viva vate viqanama vatukaqi uruntaivo. Viva naanema nitanta avuni vivo. Netanta kante oru vira ranta kaate, ti. ");
INSERT INTO tbg_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Varaata vika minti tivake qaiqaa tiha, Netanta vatukaqi oriqete tavaivaro viva varianarove. Viva varikeroma vururaqaa vuanarove. Vururaqaa variaka kia vaaka kara naraiti, vira veka vaivaro viva vika inaini oruntero Kotira ofaa iha quara amiterara iriharo Kotirara koqeve tiramanta, viraqaahai viva naarama taika vi karara nevarave. Netanta kante orunte homa vira tavevarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Minti tumanta vitanta vaantaavura qentiana orunte tavovaro Samueriva nora vatukaqihairo vuruni vaiinti nahenti ruvaaqumavi vaunaini vuare tiro anura. ");
INSERT INTO tbg_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Soruva vi vatukaraqi anu entara vira naantiara toqaqi Noravano Kotiva Samuerira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","Hura toqaqi te Benaminira ankuqihai vaiinti vo atitaariraro are inanaini anianarove. Are vi vaiintira noraiqama tehara vira qiataqaa vahavera aqu amitairaro viva tinta vaiinti nahenti Isareri vika avuhainaa vaiintivano variarire. Te tavauramanta Pirisia vatanaaka nora maara Isareri vika nimi variamanta vika ike mpo ti varia uvara te irunarave. Ho vi vaiintiva Pirisia vika kauquqihairo Isareri ruaruama nimitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Minti tuvaro vira qararaa Soruva Samuerira avuqaa qovarama vuvaro Noravano Kotiva Samuerirara tiharo, Ho tavaane. Te enta ai tiva amuna vaiintiva, maa vivama vaivo. Viva ekaa ti vaiinti nahentiqaa raqikianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Minti tuvaro Soruva nora vatuka qentiana Samuerira ranta kero irero tiharo, Kukeqavi vai haikara tave vai vaiintira naavu tainie vaivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Minti tuvaro Samueriva vira tiva amiro tiharo, Te maa vikama vauro. Are kantera ti tivuni oru vururaqaa ruvaaqumavi varianaini vaihara vate ti vataakera kara naane. Hura toqaqima are nana nana haikara irenara te ai tiva ami, viraqaahai te ai atitaarirara vinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Minti tivakero viva qaiqaa tiharo, Te iruraro ni donkinavu kakakima vuavaro taaramo entama aitaraivo. Ho kia vikara noraiqaa kera avu aato utuane. Vo vaiintinavu donki vika rantama kaavo. Ho iriane. Isareri vatanaaka ta vaiintirarae voqamakero antuqa arimanta variavo? Vika ariaravata ai qora ankuaravata antuqa arimanta variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Viva minti tuvaro Soruva aqao tiro, Te Benaminira ankuqiraakama vauro. Isareri ankuqihai Benaminira anku taaraiqavano tuvitarero vitini vairave. Vi ankuraqihairo ti qora ankuvano ekaanaini vitini vairave. Mintivarama are nantivarae vi uvara tiriara tiaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Minti tuvaro Samueriva Soruravata vira kaiqa vaiintivata ntita varero vuruni vau naavuraqi oriqetero, nora rumu vauraqi oru vaura. Vi rumuraqi Samueriva vaiinti 30 navu naarama komanta kara nareka oquvi vauvaro Samueriva vika vauraqihairo oritarero avuni vau taintaraqaa Soruravata vira kaiqa vaiintivata oquvuate tumanta oqu vuvaro ");
INSERT INTO tbg_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Samueriva kara unte vau vaiintira tiva amiro tiharo, Te mati ai amiha vira tinta timitaane turara vataanara, are vira varera aniane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Minti tuvaro kara unte vau vaiintiva purumakau aiqu mati koqera varero vuru vi rumuraqi Sorura avuqaa vatovaro Samueriva Sorura tiva amiro tiharo, Are te naarama taura vaiintika hampata kara naane ti, te maa matira ariara iriha kaama taunarave. Ho vira naane, tuvaro Soruva vi entaraqaa Samuerikantiro vaiharo kara vira nora. ");
INSERT INTO tbg_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Kara namake vika Kotira ofaa iha quara amite vau vatukara mini ke ururante nora vatukaini vurama. Mini vuvaro entama vuvaro Samueriva nai naavu qiata tanuqi kanta taari vuqi amitovaro Soruva mini vaitora. ");
INSERT INTO tbg_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Ho vira qararaa toqaqi Samueriva himpiro Sorura aarero tiharo, Ho himpuane. Te ai atitaarirara nena maaqaini vuanerama turo, tivakero viva Sorukantiro vahaaqaini vevante vura. ");
INSERT INTO tbg_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Vitanta vivi, nora vatuka aaqaini orunte, Samueriva Sorurara tiharo, Nena kaiqa vaiinti tiva amiraro viva naane avuni vuarire, tuvaro vira kaiqa vaiintivano avuni vuvaro Samueriva qaiqaa Sorurara tiharo, Are inaaraiqakaa tintira maini vairaqe te Kotiva ariara ti uvara ai tiva amiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Minti tivakero Samueriva orivi vahavera taqu varakero vahavera vira Sorura qiataqaa aqu amitero vira moqa kero tiva amiro tiharo, Are Nora Kotira vaiinti nahenti, Isareri vikaqaa raqikihara vika avuhainaa vaiintivano variane tiro, Noravano Kotiva ai kaama tero ai noraiqama kaimantara ti, te ariqaa vahavera aqu amitauro. Are Isareri vikaqaa raqikiharama navutaaka Isareri tataaqa hini hini variaka kauquqihaira vika ruaruama nimitaane. Vo haikavano ariqaa qovaraiqiainara te ari tiva amiarirara are tavairaro vi haikava ariqaa qovarama virara are mintima tiane: Quqaama Noravano Kotiva nai vaiinti nahentiqaa raqikiarire tiro, ti kaama taivo tinarave. Vi haikava maantima keroma qovaraiqianarove: ");
INSERT INTO tbg_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Are ti maini kera vivira, Benamini vataini Selsa vatukaini otu ntenarave. Are mini otuntera, Reserira ori onavuqi quntama tora tataaqa tavaira vaiinti taaraqantavano ariara mintima tivarave: Are donkinavuara rante varianara rantama kaavo. Ai qova kiama donki vikara noraiqaa kero iriraitiro, viva vate ariaraqaima noraiqama kero iriharo nantiakee tenta maaqu ranta kararave ti vaivo, tivarave. ");
INSERT INTO tbg_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Vitanta minti tivara are vitanta mini kera vivira nora oqiva vo, Tabo Oqivave tianaini oruntera are taaramo vaiintinavu tavenarave. Vinavuka ofaa vare Betelini Kotira amireka anivarave. Vinavukaqihairo vovano memeraa naati taaramonavu varero aniraro, vovano mpareti taaramonavu varero aniraro, vovano uaini taqu varero anianarove. ");
INSERT INTO tbg_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Vinavuka ai uva manteha ariara, Mpareti taaraqanta varenarave? tivara are hove tivakera varaane. ");
INSERT INTO tbg_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Viraqaahaira, are Kotira aiqinave tianaini vatuka vo Gibea, Pirisia iqoka vaiinti seri naavu maaqa kaqate varianaini vuane. Are vi vatukara aumanto oruntera tavairamanta paropeti vaiinti vonavu ofaa taintavano vainaihai tuvivarave. Paropeti vika ihi nteha kitaave kuleleve, ruqutiha, tamparini tuateha rintatimaqi viha, aanumaara/noma vuaqeha Kotira uva tiva qoqaiqama keha tuvivarave. ");
INSERT INTO tbg_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Vinavuka mintimaqi tuvivaro Nora Kotira Maraquravano ariqira tuvu vaiharo ai kempukaiqama kairara are paropeti vaiinti vika hampata vaihara, arevata vika autintema kera mintinarave. Kotira Maraquravano ai avu aato qaraakaiqama kairara are vo qaramakera vaina vaiintiva vainarave. ");
INSERT INTO tbg_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Te vate tura haikava ariqaa qovaraiqirara, are kankoma kera Kotiva aintiro variainarara irinarave. Viraqaahaira are Kotiva ai nana nana kaiqa amiainara varaqira vuane. ");
INSERT INTO tbg_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Are avuni oruntera Giligaalini 7 entara ti veka mini vairaqe te mini ai ranta kaare. Te mini orunte Kotira ofaa vo, ekaara kaintu iha quara amite, viraqaahai Kotikanti vohaa variainarara irihama ofaa vo iha quara amitaare. Te ainti mini vaiha are nana nana haika autirera inara te ai tiva amiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Samueriva minti tuvaro Soruva vira mini kero vuare tuvaro Kotiva Sorura avu aato qaraakaiqama kovaro vohaa vi entara Samueriva tuntema kero, ekaa vi haikava Soruraqaa qovaraiqura. ");
INSERT INTO tbg_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Soruva nai kaiqa vaiintintiro Gibeaini oruntomanta paropeti vaiinti vika vitanta anunaini anintovaro vaakama Kotira Maraquravano Sorura kempukaiqama kovaro Soruva paropeti vika hampata vaiharo vika uva tuntema kero, vivavata Kotira uva tiva qoqaiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Soruva minti ti vaumanta vaiinti nahenti tota Sorura tavoka tavovaro Soruva paropeti vika hampata Kotira uva tiva qoqaiqamake vaumanta vika nai ire nai ire iha tiha, Nana haikavanoe Kisira maaqu Soruraqaa qovaraiqivo? Soruva vivavatae paropeti vaiintiqama vivo? ti. ");
INSERT INTO tbg_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Vika minti tuvaro vihainaa vaiinti vovano aqao tiro, Te tavauramanta paropeti vaiinti maaka qoka vikavata kia paropeti vaiinti variarave, tura. (Sorurara vivavata paropeti vaiintiqama vivo tu uvava vi anumanta vika tavaavaro vo vaiintivano kia nai qova varai kaiqara vararaitiro, qaraaka kaiqa vare vaumanta vika vi vaiintirara tiha, Ike tavaate. Vivavatae paropeti vaiintiqama vivo, ti vaura.) ");
INSERT INTO tbg_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Ho Soruva Kotira uva tiva qoqaiqama taiqa kero, viraqaahairo viva ofaa taintavano aiqinaqaa vaunaini vura. ");
INSERT INTO tbg_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Soruva nai kaiqa vaiintintiro maaqaini anuvaro vira qova vovano vitanta irero tiharo, Ike, netanta taini vuanahaie aniavo? tuvaro Soruva tiharo, Tetanta donkinavu kakakima vuakara qumina ranteha tavauramanta kia variaverama tetanta Samuerira oru tavema anuro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Minti tuvaro viva tiharo, Samueriva nitantara nana uvae tivo? tuvaro ");
INSERT INTO tbg_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Soruva vira tiva amiro tiharo, Samueriva titanta mintima tiva timiro tiharo, Vo vaiintinavu donki vika rantama kaavo tivo, tiro. Viva minti tiharovata, Samueriva nai avuhainaa vaiintiqama vuainarara kiama nai varaqora vira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Samueriva Isareri vika ekaa naarama komanta vika Misipaa vatukaini ani Nora Kotira avuqaa ruvaaqumavi vaura. ");
INSERT INTO tbg_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Vika ruvaaqumavi vauvaro Samueriva vikara tiharo, Noravano Kotiva tinavu Isareri Variqavano mintima tivo: Te Isipiqihai ni Isareri ntita vare anunarave. Isipi vikavata vo vatanaakavata ni Isareri qoraiqama nimite variamanta te vika kauquqihai ni ntita vare anunarave. ");
INSERT INTO tbg_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Ne qora okaraqive, vo maara vo maaraqive variamanta te ni Variqavano viraqihai ni ruaruama nimite vaunarave. Te minturamantavata, ne ti qoririma keha tiha, Are vaiinti vo noraiqama kairaro viva avuhainaa vaiinti vaiharo tinavuqaa raqikiqiro vuarire, ti variarave. Ho vatema ne vo anku vo anku ruvaaqumavi, ti Nora Kotika avuqaa himpite variate. Noravano Kotiva niara mintima tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Samueriva minti tivakero ekaa vo anku vo anku aumanto ani variate tuvaro Noravano Kotiva ekaa vi ankukaqihairo Benaminira ankuqai kaamatora. ");
INSERT INTO tbg_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Mintuvaro Samueriva Benaminira ankuqihairo inaara anku, vo anku vo anku naaromanta anuvaro Noravano Kotiva vi ankukaqihairo Matirira ankuqai kaamatora. Qaiqaa Samueriva tumanta Matirira ankuvano anuvaro Noravano Kotiva vikaqihairo Kisira maaqu Soruraqai kaamatora. Ho vika Sorurara ranteha tavovaro kia viva mini vaura. ");
INSERT INTO tbg_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Vika Nora Kotira ireha tiha, Ike, vi vaiintiva tainie vaivo? tuvaro Noravano Kotiva vika tiva nimiro tiharo, Ne vo haika vataara vira avutaqima Soruva kukeqaviro vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Noravano Kotiva minti tumanta vika kante oru Sorura vita vare aninte tavovaro Soruva vukai vaiinti vaiharora tiro, viva vaiinti nahenti avutana himpiro ekaa mini vauka naatarakero vukai vaiinti vaura. ");
INSERT INTO tbg_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Ho vira vita vare anuvaro Samueriva vaiinti nahenti tiva nimiro tiharo, Noravano Kotiva kaama tai vaiintira ne tavaate. Kiama niqihairo vo vaiintivano Sorura voqaantema kero vaivo, tumanta ekaa vaiinti nahenti naveraitiha, Soruva tinavu avuhainaa vaiintivanoma vaivo. Viva avuhainaava vaiharo vukaiqamakero qaqi variqiro vuanarove, tura. ");
INSERT INTO tbg_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Minti tuvaro Samueriva avuhainaa vaiintivano vaiinti nahentiqaa raqikiaina okarara vika tiva nimiro, viraqaahairo viva vi uvara vukuqi qara ntuva tero, vuku vira varero vuru Nora Kotira naavuqi vatero, viraqaahairo Samueriva vaiinti nahenti nititomanta nai maaqa nai maaqaini vura. ");
INSERT INTO tbg_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Soruvavata anirantero nai maaqa Gibeaini vura. Viva mini vireva uvaro Kotiva kempuka vaiinti vonavu avu aato vara himpuma komanta vikavata Sorura airuqama vare vura. ");
INSERT INTO tbg_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Mintumantavata, qora vaiinti vonavu voqamake antua ti vauka tiha, Aqao, nantima keroe maa vaiintiva tinavu ho kahaqianarove? ti. Vika Sorurara iri qoraiqama amiteha, kia quahara haikavata vira amura. Mintuvarovata, Soruva kia vikara vo uvavata tiraitiro, evaara vaura. ");
INSERT INTO tbg_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Soruva nai maaqaini oru vauvaro vohaa tora aitarovaro King Nahaasiva Amoni vatanaava nai iqoka vaiinti ntita varero Gileaati vataini ani Jabesi vatuka ututumatero vaumanta vihainaaka Nahaasirara tiha, Mpo, are tinavu hampata vohaa uva tiva taatau tera tinavu qaqi kairaqe tenavu ai hampata vaiha ai vevaaraini variare. ti. ");
INSERT INTO tbg_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Vika minti tuvaro Nahaasiva tiharo, Te ni hampata uva tiva taatau taarira aarava vohaiqaqaima vaivo. Te ni Jabesi vatanaaka kauqu tanaraini vaina avura vauru qaqini kaari ekaa Isareri vatanaaka kaurira haika varaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Minti tumanta Jabesi vatanaaka qiata vaiinti vika vi uvara iri, Nahaasirara tiha, Are 7 entanavuara vekaiqi vairaqe tenavu vaiinti nititaari vika oru Isarerini vi aniha tiva nimimanta vika ani tinavu kahaqiate. Kia tinavu kahaqi vaiintika vaivera, homa are tinavuqaa raqikinarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Minti tivake vika vaiinti vonavu nititomanta Isarerini vi anura. Vi vaiintika Sorura vatuka Gibeaini orunte Nahaasiva tu uvara vihainaaka tiva nimumanta vika vi uvara iri qeteha noraiqaake iqi rate vaura. ");
INSERT INTO tbg_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Ho Soruva kaiqa varonaihairo kaiqa varo purumakauka ntita varero aniharo irumanta vaiinti nahenti iqi rate vauvaro viva anintero vika irero tiharo, Ne nana haikarae iqi rate variavo? tumanta vika Jabesihai anu vaiintika tu uvara Sorura tiva amura. ");
INSERT INTO tbg_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Soruva vika tu uvara iruvaro Kotira Maraquravano vira kempukaiqama kovaro Sorura voqamakero arara itovaro vaura. ");
INSERT INTO tbg_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Mintuvaro Soruva kaiqa purumakau taaraqanta arukero teqa taaqama kero vaiinti nimiro tiharo, Maa varema vuru Isareri vaiinti vika numiqeha mintima tiate: Ta vaiintivae kia Soruka Samuerika kahaqiharo Amoni vatanaaka hampata raqirera, Soruva purumakau maa teqa taaqama kaintema kero, viravata teqa taaqama kaanarove tiate, tivakero vaiinti vika nititama komanta vika vi aniha vi uvara tiva nimura. Isareri vika vi uvara iruvaro aatu itomanta Nora Kotira aatu qeteha ekaa vika himpi anuvaro kia vaiinti vovanovata maaqaini vaura. ");
INSERT INTO tbg_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Vika hihai hihai Soruva vaunaini Besekini anuvaro viva tavomanta Iutaa vaiinti vaireka, 30,000 vaiinti vaumanta hini Isareri vaiinti vaireka, 300,000 vaiinti vaura. ");
INSERT INTO tbg_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Soruva Jabesihainaa vaiintinavuara tiharo, Nenavu nenta navunaaka vuru tiva nimiate: Hura kuarivano qiataqaa uruntairaqe tenavu ani ni ruaruama nimitarerave tiate, tumanta vika vi uvara vuru Jabesiqi vauka tiva nimumanta vika vi uvara iruvaro vika muntukaqihairo quahara haikavano qovaraiqura. ");
INSERT INTO tbg_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Vika Nahaasira tiva ami tiha, Hura tenavu tentanavu auvihehavaa qaqirake ai vevaaraini variarirara are tinavuqaa nana haika autirera irera, homa autinarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Vika minti tivake vauvaro Soruva nai iqoka vaiinti rairakero taaramo anku autukomanta vira qararaa kia anoma aatitoraqaa vika kante oru Amoni vika seri naavu maaqa kaqatonaini orunte, vika hampata raquqi viha vika aru ntataqi vi vauvaro kuarivano qiataqaa uruntomanta Amoni iqoka vaiinti vika vohaiqa vohaiqavano qetake ruqemake vi anura. ");
INSERT INTO tbg_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Mintumanta Isareri vika Samuerirara tiha, Tuvana vaiinti vonavu Sorurara hauri viva tinavuqaa raqikiantorave tiaka ntita viri kairaqe tenavu vika arukaare, tuvaro ");
INSERT INTO tbg_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Soruva aqao tiro, Vate Noravano Kotiva Isareri ruaruama nimitairara ti, kia tenavu tentanavu navunaaka vikaqihai voqavata arukarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Minti tuvaro Samueriva himpiro vaiinti nahentiara tiharo, Aniqe tenavu Giligaalini orunte mini vaiha qaiqaavata Sorurara viva tinavu Isareri avuhainaa vaiintivano vaivo tiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Minti tumanta ekaa vika Giligaalini orunte Nora Kotira avuqaa uva tiva qovaramake tiha, Soruvama tinavu Isareri avuhainaa vaiintivano vaivo, tivake ofaa vo, Nora Kotira hampata vohaa vairara iriha Nora Kotira iha quara amitora. Mintimake Soruvavata ekaa Isareri vikavata voqamake quahora. ");
INSERT INTO tbg_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Ho Isareri vika Giligaalini ruvaaqumavi vauvaro Samueriva himpiro vika tiva nimiro tiharo, Ne iriate. Ne tiriara mintiane tiantemake, te ni avuhainaa vaiinti vo nimuro. ");
INSERT INTO tbg_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Viva ti vatuka varero avuhainaa vaiintivano vaiharo ni qiata vaiinti varianarove. Te naampaiqama vuraro ti qiataqi erera arataivaro ti maaqu vikavata ni hampata variavo. Te qaraaka vaiintikaahai ni qiata vaiintivano variqi anima vate naampaiqama vuro. ");
INSERT INTO tbg_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Ho vate te ni nivuqaama himpite vauro. Te ni qoraiqama nimitauna uvava vairera, ne vate homa Nora Kotira avuqaavata, viva kaamatai vaiintira Sorura avuqaavata, tiqaa uva vatevarave. Tara kaiqa purumakauve, donkive, te raqia varaunarave? Ta vaiintirae te unaqaraiqama keha viva i haikara muara varaunarave? Ta vaiintirae te qoraiqama amiteha nora maara viraqaa vataunarave? Ta vaiintira kauquqihaie te qutaru monu varaunarave? Te mintimake ni qora kaiqa vara nimitaurava vairera, ne ti tiva timiqe te homa vi uvara avuqavu qiainarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Minti tumanta vika Samuerirara aqao ti, Are kia tinavu unaqaraiqama kehara tinavu airaira voqavata varaanaravauve. Are kia tinavu qoraiqama timitehara nora maara tinavuqaa vataanaravauve. Are kia vo vaiinti qaqi kaararo viva qutaru monu ai amivara varaanaravauve, ti. ");
INSERT INTO tbg_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Vika minti tuvaro Samueriva vikara tiharo, Vate Noravano Kotivavata, viva kaamatai vaiintivavata, vitanta tave variamanta ne tiriara tiha, Viva kia qora kaiqa voqavata tinavu vara qoraiqama timitairave tiavo, tumanta vika tiha, Eo quqaama tenavu Nora Kotira avuqaa vaihama minti turo, ti. ");
INSERT INTO tbg_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Vika minti tuvaro Samueriva qaiqaa vikara tiharo, Haaru Noravano Kotiva naivano Mosika Eronika kaama tero Isipiqihairo ni kaivaqaukavara ntita varero maini viri korave. ");
INSERT INTO tbg_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Ho ne himpi vaiqe te Nora Kotira avuqaa vaiha niqaa uva vataare. Kaiqe te naane Noravano Kotiva ni kaivaqauka vikavata, nivata, koqe kaiqa vara nimitairara ni tiva nimiare. ");
INSERT INTO tbg_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Haaru Iekopiva nai vaintivara hampata Isipini otu variamanta Isipi vatanaaka vikaqaa nora maara vateha vika qoraiqama nimite variamanta, ni kaivaqaukavara Nora Kotirara ike mpo tiha tinavu kahaqiane ti variavaro Noravano Kotiva Mosika Eronika nititaimanta vitanta ni kaivaqaukavara ntita vare maini viri kaarave. ");
INSERT INTO tbg_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Vika maini ani vaiha nái Variqa Nora Kotirara kia noraiqaake iriraiti variavaro vira kaara viva Hasohainaa iqoka vaiintiqaa raqiki vai vaiintira Siseraara qaqi kaivaro viva ani ni kaivaqaukavara hampata raqiharo vika naatara kairave. Vi entara Noravano Kotiva Pirisia vatanaakavata, Moapi vatanaakavata, qaqi kaimanta vikavata ani ni kaivaqaukavara hampata raquqi viha vika naatara kaarave. ");
INSERT INTO tbg_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Mintimanta vika Nora Kotira aareha nái qora okara tiva qovarama keha tiha, Noravauvo, tenavu una variqa Baalika Astaateka kaiqa vara nimiteha, ai uva raqake ai qaqirake tauvaqa utu amitaunarave. Mpo, vate are navutaaka kauquqihaira tinavu ruaruama timitairaqe tenavu ai kaiqaqai vara amitaare tiarave. ");
INSERT INTO tbg_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Vika minti tiavaro Noravano Kotiva Gideonira naane ni Isareri nimiro, vira naantiara Baraakira nimiro, vira naantiara Jepataara nimiro, ekaara vitini ti Samuerikavata ni nimirave. Mintimanta tenavu ekaa vinavuka navutaaka kauquqihai ni ruaruama nimitauramanta vi entara ne Isareri ho variarave. ");
INSERT INTO tbg_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Ne ho variqi ani, tavaavaro Amoni avuhainaava King Nahaasiva ni hampata iqoka raqireva auti vaimanta ne qetake tiriara tiha, Are avuhainaa vaiinti vo kaama timitairaro vi vaiintiva tinavu raqikiharo ˻navutaaka naatara timitaarire tiarave. Noravano Kotiva ni avuhainaava vaimantavata, ne minti tiarave. ");
INSERT INTO tbg_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Ho ne avuhainaa vaiinti kaamataava maa virave. Ne virara iraavaro Noravano Kotiva maa virama ni nimivo. ");
INSERT INTO tbg_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Ne nenta avuhainaa vaiinti vira hampata Nora Kotira aatu qeteha variqi viha, vira autuqai tuaheraqi viha, vira uvavata kia raqa karaiti, viraqai avataqi vivera, ho Noravano Kotiva ni Variqavano ni koqema nimitaqiro vuanarove. ");
INSERT INTO tbg_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Ne Nora Kotira uva kia iriraiti, viva uva vatainara viravata raqa kaivera, ho viva ni kaivaqaukavara qoraiqama nimitaintema kero, nivata qoraiqama nimitaanarove. ");
INSERT INTO tbg_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Ho ne maini himpite vaivaro Noravano Kotiva nai kempuka kaiqa vo ni numiqairamanta ne nenta avuqohai vira tavaate. ");
INSERT INTO tbg_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ne iriarave. Vate maa entara uitivano mpeqaiqi entava vaivaro kia aaqu ntuaina entava vaivo. Ho vate te Nora Kotira aaraariraro viva tiraro naaruva uva tiraro aaquvata ntuarire. Ne vi haikara tave vaivaro ni aato kenko tiramanta ne mintima tivarave: Oho, tenavu avuhainaa vaiinti vo timiane tuna uvava Nora Kotira qoraiqama amitaivaro vira kaara tinavuqaa nora uvama vaivo, tivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Minti tivakero Samueriva Nora Kotira aarovaro vohaa vi entaraqai Noravano Kotiva tuvaro naaruva uva tuvaro aaquvata ntura. Mintumanta vaiinti nahenti mini vauka tave, kauqu runkinkiri i vaiha Nora Kotira aatuvata, Samuerira aatuvata voqamake qeteha vaura. ");
INSERT INTO tbg_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Vika Samuerirara ike mpo tiha, Are nena Variqa Nora Kotira aarairaro viva tinavu aaqurihama timitairaqe tenavu kia qutu vuare. Mpo, tenavu qora kaiqa vo kaiqa vo kaiqa auti vaurauka vaiha, avuhainaa vaiinti vo kaama timitaane tivakehama qora kaiqa voqavata auti vaunarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Vika minti tuvaro Samueriva vika tiva nimiro tiharo, Kia qetaate. Quqaama ne qora okara autu kaarave. Hauri vira kaara ne Nora Kotira tauvaqa utu amitevorave. Ne kia vira tauvaqa utu amitaraiti, ekaa nenta avu aato muntukaqihai vira kaiqa vara amitaqi vuate. ");
INSERT INTO tbg_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Kiama una variqa vika avataqi vuate. Una variqa vika qumina haikaqai vaihara ti, vika kia ho ni koqema nimitaraiti, vika kia ho navutaaka kauquqihai ni ruaruama nimitevarave. ");
INSERT INTO tbg_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Noravano Kotiva nai antuqaqaa ni nai kaama taimanta ne vira vaiinti nahenti variarara tiro, viva nai nora autuara iriharo kiama ni qoririma kaanarove. ");
INSERT INTO tbg_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Hauri te ni qaqirake kia ekaa enta niara iriha Nora Kotira aarama nimitaraiti, vira uva raqa kaarorave. Te ekaa entama niara iriha Nora Kotira aarama nimitaqi virerave. Koqe okarave, avuqavu ni okararave, te vi okarara vi okararavata ni numiqaari ne koqemake variqi vuate. ");
INSERT INTO tbg_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Noravano Kotiva niarao tiro nora kaiqa, vo kaiqa vo kaiqa ni vara nimitairara irihama, ne Nora Kotira aatu qetehama virara kempukaiqama keha iriqi viha, ne ekaa nenta avu aato muntukaqohai vira kaiqa vara amitaate. ");
INSERT INTO tbg_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Ne rauriha variate. Ne qora kaiqa qaqiqai varaqi vivera, Noravano Kotiva ni avuhainaa vaiinti viravata nivata vehi autu taiqama kaanarove, tiro. ˻Samueriva minti tivakero Isareri vaiinti nahenti tiva nimura.˼ ");
INSERT INTO tbg_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Soruva qaraaka vaiinti vaiharo avuhainaa vaiintiqama viro Isareriqaa taara ihiara raqikiqiro viviro, ");
INSERT INTO tbg_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","viraqaahairo viva Isareri iqoka vaiinti ruvaaquma kero vikaqihairo 3,000 vaiinti ntita vatero, vokuka nititomanta anirante maaqaini vura. Vika vuvaro Soruva iqoka vaiinti ntita vatokaqihairo viva 2,000 vaiintinavu ntita vatomanta nai hampata Mikimaasini Beteli aiqina vaunaini vauvaro, viva 1,000 vaiintinavu nititomanta vika nái maaqu Ionataanira hampata oru Benaminira anku vika vataini Benaminive tunaini Gibea vatukaini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Vika mini vauvaro viraqaahairo Ionataaniva nai iqoka vaiinti ntitero oru Pirisia iqoka vaiinti Geba vatukaqi vauka hampata raquqi viharo vika naatara kora. Mintima komanta Pirisia hini kuka vi uvara iri, Isareri hampata iqoka raqireka auti vaura. Mintuvaro Soruva vaiinti vonavu nititero tiharo, Nenavu ekaa Isareri vataini oru vi aniha aanumaara/noma vuaqaimanta iqoka vaiinti ani ti Soruka kahaqiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Minti tumanta vi vaiintinavuka vi aniha vaiinti nahenti tiva nimi tiha, Soruva raqiharo Pirisia vokiaka naatara kaira kaara Pirisia vika tinavu Isareri anomake navutaiqama timite variavo, ti. Minti tumanta vaiinti vika vi uvara iri, Sorura hampata Giligaalini ani ruvaaquma vura. ");
INSERT INTO tbg_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Vi entara Pirisia iqoka vaiinti airitahaa ruvaaqumavi vaiha Isareri ntaihareka auti vaura. Vika iqoka kaari 3,000 vaumanta, vika iqoka vaiinti 6,000vano ohiqaa oquvi vaumanta, qaqi iqoka vaiinti vika airitahaa nuqa voqaara vaura. Ho Pirisia iqoka vaiinti vika oru Mikimaasini nái seri naavu maaqa kaqate vaura. Beti-Abeni vatukavano vauvaro Mikimaasi vatukavano kuari avu urunto mantaraini vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Ho Pirisia vika Isareri hampata iqoka raqi vaumanta Isareri vika tavovaro Pirisia vika kempukavano voqavata vaumanta Isareri vika qetake aiqu autute, vokuka oru ori onavuqive, vata ntoma viraqive, kukeqavi vaumanta vokuka namariara vata quvitoraqive, airi nora ori vaunainive, ruvuqive/mpumpiqive, kukeqavi vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Vokuka Iotani Namari taqa vare Gaatira anku vika vataini Gileaatini oru vura. Mintuvaro Soruva kia iqoka raqura mini viraitiro, viva nai iqoka vaiinti hampata Giligaali miniqai vaumanta vira iqoka vaiinti mini vaiha aiqu kauqu ntiri ntiri i vaumanta vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Samueriva tuntema kero, Soruva 7 entanavuara Giligaalini vaiharo vira veka vauvaro viva kia oruntomanta Sorura iqoka vaiinti hini kuka qaqirake vi anima vura. (10:8) ");
INSERT INTO tbg_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Mintuvaro Soruva vika ekaa vivorave tivakero tiharo, Ne ofaa vo viri ti timiqe te vira Kotira kaintu iha quara amitaariraro viva tinavuara quaheharo tinavu kahaqiarire. Te ofaa vo, Kotiva Isareri hampata vohaa variaina ofaaravata iha quara amitaare, tiro. Soruva minti tivakero viva kia Samuerira veka voqavata vairaitiro, viva naivano ofaa vo, Kotira kaintu iha quara amitora. ");
INSERT INTO tbg_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Soruva ofaa vira iha quara taiqa kero tavovaro Samueriva anintora. Viva anintovaro Soruva vira uva mantareva vuvaro ");
INSERT INTO tbg_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Samueriva Sorura atiro tiharo, Are nana haikae autu kaaro? tiro. Minti tuvaro Soruva aqao tiro, Te tavauramanta ti iqoka vaiinti ti qaqirake raumpirima vireka auti variamanta, te are anirera tianara iri, ai veka vaurara are kia vaaka anintaaro. Mintivera te tavauramanta Pirisia vika Mikimaasini iqoka raqireka ruvaaquma vi variamantara ti, ");
INSERT INTO tbg_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","te mintimake iruro: Pirisia vika ani Giligaalini tinavu hampata raqireka auti variavo. Virara irihama te kia vaaka ofaa vo Nora Kotira iha quara amitaariraro hauri viva kia tinavu kahaqiantorave tivakema, te tentavano ofaa vo Nora Kotira kaintu iha quara amitauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Soruva minti tuvaro Samueriva virara tiharo, Are mintihara hampi kaiqama vara kaaro. Are mintiharama Noravano Kotiva ai Variqavano ai tiva ami uvara kia iriraitira, vira uva raqama kaaro. Are koqema kera Nora Kotira uva avataaraitirio, viva are kuvuarama teraukara homa Isareriqaa ekaa enta raqikiqi vivarave titirio. ");
INSERT INTO tbg_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Vate are kiama vukaiqama kera Isareriqaa raqikiqira vinarave. Are viva tivatai uvara raqa kaanara kaara, Noravano Kotiva ai qaqira kero, vo vaiinti, nai uva koqema kero iriaina vaiintira rantakero, vi vaiintira noraiqama kairaro viva nai vaiinti nahentiqaa raqikiarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Samueriva uva tiva taiqa kero Giligaali mini kero vo vataini vura. Soruvavata Giligaali mini kero Benaminini Gibea vatukaini oru nai iqoka vaiinti hampata vaireva, vura. Soruva mini oruntero nai iqoka vaiinti kaara ntuva kero tavovaro 600navuqai vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Ho Soruva nai maaqu Ionataanikantiro náitanta iqoka vaiinti hampata Benaminini Geba vatukaini oru vaumanta Pirisia iqoka vaiinti vika nái seri naavu maaqa kaqatoraqi Mikimaasini vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Pirisia iqoka vaiinti vikaqihai taaramo anku autuke, Isareri hampata iqoka raqireka vura. Vo ankuvano Ofaraini Suali mantaraini vuvaro, ");
INSERT INTO tbg_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","vo ankuvano Beti-Horoni vatukavano vau mantaraini vuvaro, vo ankuvano aiqinanavu vaunaini vura. Aiqinanavu mini vauvaro muani aahara vata Qaakau-Vairi-Uqitainive tuva vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Vi entara Pirisia vika tiha, Hauri Hiparu vika iqoka paipeve, aini vaantaarave, vo auvihehavaave, autu kevorave, tivakeha vika Isareri qioqamate tiha, Kia ne mintima vaina haikara autuate, tura. Vika minti turara ti, Isareri vikaqihai kia ihaqira aini untake okarara ho tave vaiintika vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Kia vaumanta ekaa Isareri vika Pirisia vika unaini vumanta vihai vi kaiqara tave vauka vika vata kore haikarave, rorive, saarepive, ihaqira untake ruqutukeha nuvi ana nimiteha vikaqihai koqaa vare vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Nora haika, vata kore haikarave, pikive, ihaqira untakeha ruqutu keha nuvi ana nimitora vira koqaa vaireva, 6 kinaa vaura. Inaara haika, rorive, saarepive, vo kaiqa varo haikarave, ihaqira untakeha ruqutu keha nuvi ana nimitora vira koqaa vaireva, 3 kinaa vaura. ");
INSERT INTO tbg_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Ho Isareri vikaqihai vi kaiqara tavoka kia vaurara ti, raqi vau entara Soruka Ionataanika vitantaqai iqoka paipevata vaantaaravata vatomanta ekaa Isareri iqoka vaiinti vika kia vi haikaravata vatora. ");
INSERT INTO tbg_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Vi entara Pirisia vika nái iqoka vaiinti vokuka nititomanta vika oru Mikimaasini aara muaqena kuvaite raqikiha vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Vo entanavu aitarovaro Sorura maaqu Ionataaniva nai auvihehavaa vare ni vau vaiintirara tiharo, Aniqetanta uqita maa varake hini mantaraini oru Pirisia seri naavu maaqa kaqate varianaini oru ampeqiha tavaare, tiro. Minti tivakero Ionataaniva mini vireva iharo kia nai qora Soruravata tiva amiraitiro, evaara vura. ");
INSERT INTO tbg_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Vi entara Soruva Mikironi vatuka Gibeaini pomigraneti katari okara nai seri naavu kaqa toraqi vaumanta iqoka vaiinti 600navu vira hampata Mikironi mini vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Vika hampata vaiinti vo Ahiaava Kotira kaiqa vara amite vau vaiintiva nai kaiqa varo tavunara, efotive tura nonkutero vaura. Ahiaava Ahitupira maaquvano vauvaro Ahitupiva nai qata Ikabotikantiro Finiaasira maaqutanta vauvaro Finiaasiva Elira maaquvano vaura. Eliva qaqi vau entara viva Siloqi vaiharo Kotira kaiqa vara amite vau vaiintiva vaura. Ho Ionataaniva vinumanta Sorura iqoka vaiinti vika Ionataaniva vura kia iri tavora. ");
INSERT INTO tbg_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Ionataaniva nai paanaa vaiintintiro Pirisia seri naavu maaqa kaqate vaunaini vireva oru viviro, aara muaqena vaunaini oruntero tavovaro aara hini mantaraini qora onkai Bosesi-Onkaivano vauvaro aara vutu mantaraini qora onkai vo Sene-Onkaivano vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Onkai vovano sauti Mikimaasi mantaraini vauvaro onkai vovano noti Geba mantaraini vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Ho vitanta orunte onkai hini mantaraini noraqaa himpi vaiha vutu tavomanta onkai voqaa Pirisia nái seri naavu maaqa kaqatova vauvaro Ionataaniva nai paanaa vaiintiara tiharo, Ho aniraqetanta vutura hini mantaraini navutaaka Pirisia varianaini vuare. Noravano Kotiva titanta kahaqianarove kiae kahaqianarove? Viva titanta kahaqirera, tetanta homa vika naatara kararave. Viva iqoka vaiinti airiqohairove, taaraiqaqohairove, homa vika kahaqiramanta navutaaka naatara kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Ho Ionataaniva minti tuvaro vira paanaa vaiintivano tiharo, Hove, are nana haika autireva irera, tevata ainti mintirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Viva minti tuvaro Ionataaniva virara koqeve tivakero, Ho varaiqetanta qoqaa vuari vika titanta tavaate. ");
INSERT INTO tbg_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Vika titanta tave titantara tiha, Netanta mini vaiqe tenavu nitanta hampata mini oru raquare tivera, tetanta kia mini viraiti, vika veka maini variare. ");
INSERT INTO tbg_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Vika titantara tiha, Netanta tenavu unanaini uriqe raquare tivera, tetanta vika ianaini vuare. Vika minti tivera, tetanta kankomake iriariraro Noravano Kotiva vika titanta kauquqima kaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Minti tivakero Ionataaniva nai paanaa vaiintintiro otuntero qaqi kanta qovarama vumanta Pirisia vika hini mantaraini vauka vutu vitanta tave naaraihama nimiteha tiha, Ike tavaate. Hiparu vaiintitanta onavuqi kukeqavi varianaihai qaqi kanta ani variavo, ti. ");
INSERT INTO tbg_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Minti tivake Pirisia iqoka vaiinti vika Ionataanira nai paanaa vaiintinti aareha tiha, Netanta maini vaarinte uriqe tenavu vo haika nitanta numiqaare, tuvaro Ionataaniva nai paanaa vaiintiara tiharo, Are ti avataqira aniane. Vate tetanta iri tavauraro Noravano Kotiva vika tinavu Isareri kauquqima kaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Ho Ionataaniva qora onkai viraqira raumaumaqiro oru viviro, noraqaa vaarintovaro vira paanaa vaiinti vivavata vira naantiara oru vuvaro Ionataaniva viharo Pirisia vika ruqutuqiro vi vaumanta vika vataini hiqinti hiqinti i vauvaro vira paanaa vaiinti viva vira naantiara oru viharo iqoka paipeqohairo vika ekaara aru aavata ke vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Ionataaniva nai paanaa vaiintintiro hoqarero raqiharo 20 vaiintinavu arukoka vika vaatavano vohaa kantaqai hiqintiviro vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Mintumanta Pirisia iqoka vaiinti seri naavu maaqa kaqatoraqi vaukavata, vona vona raqireka vukavata, voqamakero naatu itovaro aiqu kauqu ntiri ntiri i vaumanta vaura. Vaturavanovata uti vaiharo vata qaki qaki i vaura. Mintima kero Kotiva vika qetara haika nimumanta vika voqamake qeteha, vika nái avu aatoqihai ruqemake vivaqai vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Mintumanta Sorura iqoka vaiinti Benaminini Gibea vatukaini maimaraara raqiki vauka vaiha tavomanta Pirisia vika nái seri naavu maaqa kaqatora viraqihai oi aai tivaqi viha, hampiara voqaara kante vi ani vaumanta ");
INSERT INTO tbg_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","vika tave vuru Sorura tiva amuvaro Soruva nai iqoka vaiintiara tiharo, Nenavu tinavu iqoka vaiinti kaara ntuvake tavaate. Taukae kia maini variavo? tumanta vika nái kanauka kaara ntuvaqi viha tavovaro Ionataaniva nai auvihehavaa vare vau vaiintikantiro kia vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Vi entara Kotiva uva tiva taatauto Vokiseva Gibea vatukaini vaura. Mintuvaro Soruva Kotira kaiqa vara amite vau vaiintira Ahiaarara tiharo, Kotira Vokise varera maini aniraqe te Nora Kotira vira antuqavano vainara rantake tavaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Soruva minti tivakero Kotira kaiqa vara amite vau vaiintira Ahiaakantiro uva ti vaiharo irumanta Pirisia iqoka vaiinti vika nái seri naavu maaqa kaqatoraqihai voqavata oi aai ti vaiha, kante vi ani vauvaro viva Ahiaarara tiharo, Ho qaqira kaane. Tenavu vaaka raqirera virerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Soruva minti tiva kero nai iqoka vaiinti 600navu ntita varero Pirisia hampata raqireva oruntero tavomanta Pirisia vika anomake qete vauvaro vika avu aatovano hampiqama vumanta vika nái iqoka paipeqohai nai aruke nai aruke i vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Ho Hiparu vaiinti vokuka haaru Pirisia iqoka vaiinti tontiqama keha vika seri naavu maaqa kaqatoraqi vauka, vikavata oru Soruka Ionataanika kahaqiha Isareri mantaraini vaiha raqi vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Isareri vaiinti vokuka Efaraimu aiqina vaunaini kukeqavi vauka, vika irumanta Pirisia vika qetake ruqeqaamake vi vaumanta, vikavata aninte nái navunaaka kahaqiha Pirisia vika aru ntata kora. ");
INSERT INTO tbg_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Vika aru ntataqi vivi, Beti-Aveni vatuka vara maini ke, voqavata ntata vare vuru niaraini kora. ˻Mintima kero vi entara Noravano Kotiva Isareri vika ruaruama nimitora.˼ ");
INSERT INTO tbg_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Vi entara Soruva iqoka raqireva iharo kempuka uva Isareri iqoka vaiinti tiva nimiro tiharo, Te vateqai tenta navutaaka náivata qoraiqama nimitarerave. Virara iriha te qioqama taari ne karavata kia naraiti, qaqi vaivaroma kuari avuvano ruhunku vuarire. Vaiinti vovano ti uva raqa keharo kara nairera, Kotiva vi vaiintira qoraiqama amitairaro vaaquqama vuarire, tiro. Soruva minti tura kaara vika kara kia novaro voqama kero antuqa ntaihomanta vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Ho nora antuqavano vika ntaihomanta vika vivi oru nanta voqi tavovaro bivano nkuruto haniva airitahaavano vatakanta hiqintivi vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Mintumanta vika Soruva uva tivatora kaara qeteha hani vira kia varake nora. ");
INSERT INTO tbg_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Ho Ionataaniva nai qova qioqamato uvara kia iruvara tiro, viva nai kairiqa tuatoraqohairo hani vira ravakiri kero nero. Viva namakero viraqaahairo vaakama viva kempuka varora. ");
INSERT INTO tbg_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Viva mintuvaro vo vaiintivano vira tiva amiro tiharo, Oho, nora antuqavano tinavu ekaa harimantama vauro. Ai qova tinavuara kara qioqama tero tiharo, Vate kara nairava vaaquqama vuanarove, tira kaara tenavu kia kara nauraro tinavu kempukavano kia vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Minti tuvaro Ionataaniva aqao tiro, Ti qova minti tiharo qorahaama tivo. Viva ekaa tinavu Isareri qoraiqama timitaivo. Ne ti tavaate. Te hani inaaraiqa nama kema qaiqaa tenta kempuka varauro. ");
INSERT INTO tbg_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Tinavu iqoka vaiinti vate navutaakaqihai raqiake varataa karara nama kaatirio, vika qaiqaa kempuka vare homa Pirisia vika kia taaraiqa aru karaiti, airima arukaatirio, tura. ");
INSERT INTO tbg_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Vohaa vi entara Isareri vika iqoka raqiha, Mikimaasiqihai hoqaramate Pirisia ntaihamaqi vivi, Aisaroni vatukaini oru ntora. Mintumanta Isareri iqoka vaiintinavu antuqavano voqama kero ntaihovaro vika kempukavanovata kia ho vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Ho kuari avu ruhunku vumanta Isareri vika kante oru nái navutaaka u haikara sipisipive purumakauve raqiake vare, vi vatukara mini vaiha vi haikara aruke, kia naare ntava tati karaiti, naare vira hampata mati nora. ");
INSERT INTO tbg_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Vika naare hampata mati ne vaumanta vokuka vuru Sorura tiva ami tiha, Oho, iriane. Iqoka vaiinti vika sipisipi mative, purumakau mative, naare hampatama ne variavo. Vika mintihama Noravano Kotiva qioqamato uvara raqake variavo, ti. Vika minti tuvaro Soruva nai iqoka vaiinti vikara tiharo, Oho, ne mintihama qorahaama autu kaavo, tivakero qaiqaa tiharo, Ho nora ori vo, tanuqinara venta vare viri maini vuqi timitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Minti tivakero viva tiharo, Ne ori vira naane vara viri timi, viraqaahai iqoka vaiinti tiva nimimanta vika purumakauve sipisipive vare aninte, ori viraqaata arukaivaro naarevano ekaara ntava taiqa viramanta mati vira varake untake naate. Hauri vika kia naitaramake arukaraiti, naare hampata mati vira neha Nora Kotira uva raqa kevorave, tiro. Minti tumanta enta viraqiqai iqoka vaiinti vika purumakauve sipisipive vara viri ori viraqaa naitaramake vateha aruke vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Vika aru taiqa kovaro viraqaahairo Soruva ori vira kaama tero tiharo, Maa oriva Nora Kotira ofaa taintama varianarove, tura. Vi taintava avuniqamakero Soruva autuko ofaa taintava vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Ho Soruva nai iqoka vaiinti vikara tiharo, Aniqenavu otu Pirisia hampata raquqi vivi aatita kaare. Tenavu otu vika ekaa aru taiqake, vika airaira varaare, tumanta vika tiha, Hove, aniqenavu are tinantemake mintiare, tuvarovata, Kotira kaiqa vara amite vau vaiintiva aqao tiro, Kaiqe tenavu Kotira naane ireha tavaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Viva minti tuvaro Soruva Kotira irero tiharo, Hoe tenavu otu Pirisia ntaihararave, kiae ntaihararave? Are hoe tinavu kahaqiraqe tenavu vika naatara kararave? tiro. Soruva minti tuvaro Kotiva vi entara kia vira uva nai tiva amura. ");
INSERT INTO tbg_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Mintuvaro Soruva Isareri iqoka vaiinti taruka naarama kero tiharo, Oho, tavave qora kaiqa vara kaivaroe Noravano Kotiva kia ti uva tiva timivo? Nenavu aniqe tenavu vi vaiintira rantake qovarama kaare. ");
INSERT INTO tbg_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Noravano Kotiva ekaa enta variqiro vi vaiva viva tinavu Isareri ruaruama timite vaira autuqaa te mintima turo: Vaiinti vovano qora kaiqa autu kaiva qutuma vuanarove. Ta vaiintivae vo vaiintivanoe, ti maaquvanoe, mintima kaiva vairera, vi vaiintiva qutuqaima vuanarove, tuvaro kia vikaqihairo vovanovata uva tura. ");
INSERT INTO tbg_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Vika kia uva tuvaro Soruva vikara tiharo, Ne ekaa oru vitiraqaa himpi vaiqe tetanta Ionataanika maini maaqaa himpi variariraro Kotiva vi uvara avuqavu iarire, tumanta vika hove tivake vika oru voqaa vaumanta Soruka Ionataanika voqaa vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Viraqaahairo Soruva Nora Kotira aarero tiharo, Noravauvo, are tinavu Isareri Variqavanoma variaro. Mpo, are nana kaarae te ai aarauna uvara kia irira tinta tiva timiaro? Are Urimi Tumimi okaraqohaira nena kaiqa vara amite vai vaiintira umiqairaro viva vi vaiintira qovarama kaarire. Vitiraqaa himpite variaka avutana vi vaiintiva vairera, are nena kaiqa vara amite vai vaiintira kahaqiraro viva Urimi ori utu varaarire. Titanta Ionataanikaqihairo vi vaiintiva vairera, are nena kaiqa vara amite vai vaiintira kahaqiraro viva vo ori, Tumimi ori utu varaarire, tiro. Minti tuvaro Kotira kaiqa vara amite vau vaiintiva Urimi Tumimi okara autu keharo Tumimi ori utu varora. Mintumanta vika iruvaro vitini himpite vauka avutana kia vi vaiintiva vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Mintuvaro Soruva tiharo, Vohaa qarama kehara titanta Ionataanika avatehara tavaane, tuvaro Kotira kaiqa vara amite vau vaiintiva qaiqaa vi okarara autu kovaro Tumimi orivano Ionataanira qovarama kora. ");
INSERT INTO tbg_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Mintuvaro Soruva Ionataanira irero tiharo, Oho, are nana haikae vara kaanarave? tuvaro Ionataaniva aqao tiro, Te hani inaaraiqa kairiqaqohai ravakirike naunarave. Qumina vi haikara kaarae ti harukaiqe qutuvirarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Minti tuvaro Soruva tiharo, Eo, are vira kaara qutuma vinarave. Te ai qaqi kaarirara are kia qutu virera, Kotiva homa ti ruqutu kairaqe te qutu virarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Soruva minti tumanta iqoka vaiinti vika Sorurara aqao ti, Eqaane. Ionataaniva Pirisia kauquqihairo tinavu Isareri ruaruama timitairave. Vivae qutu vuanarove? Kiave. Noravano Kotiva ekaa enta qaqi variqiro vi vaira autuqaama tenavu ariara kempukaiqamake tiha, Vate Kotiva Ionataanira kahaqivaro viva iqoka aatara kairara tiro, kia vovanovata vira qoraiqama amitaanarove. Kia vovano inaaraiqavata vira qoraiqama amitaanarove, ti. Vika minti tivakeha kempukaiqama keha Ionataanira ruaruama amitovarora tiro, kia vira arukora. ");
INSERT INTO tbg_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Vika minti tuvaro Soruva qaqira kero kia qaiqaavata Pirisia vika aru ntatomanta vika nái maaqaini anirante vura. ");
INSERT INTO tbg_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Soruva Isareri avuhainaa vaiinti vau entara viva nai iqoka vaiinti ntitero Isareri navutaaka hini hini vauka hampata raquqiro vi vaura. Moapive, Amonive, Idomuve, Pirisiave, Soba vatanaaka avuhainaa vaiintinavuve, viva vika hampata iqoka raquqiro vi vaura. Soruva nai vona vona iqoka raqiharo viva nai iqoka vaiinti hampata ekaa vi vatanaa vi vatanaaka naatara keharo vika qoraiqama nimite vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Soruva kempukaiqama kero raquqiro viharo Amareki vatanaakavata naatara kora. Viva mintiaqiro vumantara ti, Isareri vika hini hini vau vatanaaka qaqirake, kia qaiqaavata Isareri hampata raqireka anura. ");
INSERT INTO tbg_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Sorura maaqu taaramonavu vaireka, Ionataaniva vo, Isaviva vo, Malikisuava vo, vaura. Vira raavuratanta vaireka, Meraapiva vo, vira aura Mikaaliva vo, vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Sorura naata Ahinoamiva Ahimaasira raavuravano vaura. Sorura iqoka vaiinti vika qiata vaiinti Apineva vaura. Viva Nera maaquvano vauvaro Neva Sorura qora vira qatavano vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Sorura qova Kisiva vo, Apinera qova Neva vo, vitanta Abielira maaqutanta vaura. ");
INSERT INTO tbg_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Soruva qaqi vau entara Pirisia vika qaqiqai ani Isareri hampata iqoka raquqi vi vaura. Soruva tavovaro kempuka vaiintie, kia qete vau vaiintivae vauvaro viva vira aaramakero tiharo, Are anira ti iqoka vaiintinavu hampata variane, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Vo enta Samueriva Sorurara tiharo, Are avuhainaa vaiinti vaihara Isareri vikaqaa raqikiane tiro, Noravano Kotiva ti tititaimanta te vahavera ariqaa aquteha ai kaama taurauka vaunarara tira, are vate Noravano Kotiva tivatai uvarama iriane. ");
INSERT INTO tbg_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Noravano Kotiva ekaa kempuka vataava mintima tivo: Haaru Isareri vika kaivaqaukavara Isipi ke anumanta Amareki vika Isareri qoraiqama nimitorave. Ho vira kaara te vate Amareki vika náivata qoraiqama nimitarerave. ");
INSERT INTO tbg_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Are nena iqoka vaiinti ntita varera oru Amareki hampata raqiharama vika aru vehi autu taiqa kaane. Are vaiintive nahentive vaintive, purumakauve, sipisipive, memeraave, kamerive, donkive, ekaama aru taiqa kaane. Kiama voqavata qaqi kaira qaqi variate. Noravano Kotiva ariara mintima tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Samueriva minti tuvaro Soruva vi uvara iriro nai iqoka vaiinti naarama komanta vika Telemi vatukaini oru ruvaaquma vura. Iutaa iqoka vaiinti 10,000 vaumanta hini Isareri vika 200,000 vaura. ");
INSERT INTO tbg_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Ho Soruva vika ntita varero oru Amareki vatukaini oruntero, haaru namarivano aaharauqama vuraqi oru kukeqavi vaura. ");
INSERT INTO tbg_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Soruva viraqi vaiharo Kini vatanaaka vaunaini uva varakero mintima tiro: Ne Amareki vatuka mini ke vonaini oru variate. Hauri tenavu Amareki ntaiheha nivata ntaihama kaarorave. Tinavu kaivaqaukavara Isipi ke maini anu entara ni kaivaqaukavara vika koqema nimitorave. Virara irihama te kia ni ntaiharerave, tiro. Soruva minti tumanta Kini vika Soruva tuntemake Amareki vatuka mini ke vonaini vura. ");
INSERT INTO tbg_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Vika vuvaro Soruva Amareki vika hampata raquqi viharo vika naatara kora. Viva Havila vataihairo raquqi viviro, Suri aahara vataini oru ntora. Isipi vatavano vauvaro Suri vatavano kuari avu uruntonaini vaura. ");
INSERT INTO tbg_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Soruva Amareki vika King Agaakira kia aru karaitiro, qaqi ravaaqavu tomanta Isareri vika Amareki vatanaaka ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Soruva nai iqoka vaiinti hampata ekaa vi vatanaaka aru taiqa keharo, King Agaakira qaqi vehakuma amitero, vika sipisipive purumakauve qoraiquka aru taiqakero, koqe sipisipive purumakauve kia arukaraitiro, qaqi vare vura. ");
INSERT INTO tbg_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Mintuvaro Noravano Kotiva Samuerira tiva amiro tiharo, ");
INSERT INTO tbg_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Oho, te kia Sorura kaama taataarave. Te vira noraiqama kauraro viva Isareri avuhainaa vaiintivano vaiharo viva kia ti uva avataraitiro, ti uva raqa kairave, tiro. Minti tuvaro Samuerira muntukavano voqamakero qoraiquvaro viva vohaa vi entara entaqi Nora Kotira aaramaqiro viharo ike mpo tivaqiro viviro aatita kora. ");
INSERT INTO tbg_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Ho vira qararaa toqaqi Samueriva himpiro Sorura rantareva vumanta vokuka vira tiva ami tiha, Soruva Kaameli vatukaini vivo. Viva raqiharo iqoka naatara kero nora autu varairara iriharo, ori vo kaamatero vaaviarama kero, viraqaahairo Giligaalinima otu vivo, ti. ");
INSERT INTO tbg_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Minti tuvaro Samueriva Soruva vaunaini oruntovaro Soruva vira uva mantero tiharo, Samuerio, Noravano Kotiva ai koqema amitaarire. Ho Noravano Kotiva tintemake, te mintima kaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Viva minti tuvaro Samueriva virara aqao tiro, Oho, nantimantae purumakau mmm mmm ti variamanta sipisipi vika mae mae tiamanta te iri vauro? tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Minti tuvaro Soruva nai tiva amiro tiharo, Iqoka vaiinti vika Amareki purumakauve sipisipive ekaa hini aru taiqa kaavo. Vika ai Variqa Nora Kotira ofaa iha quara amitareka iha, sipisipive purumakauve koqekaqai qaqi vare viri vataavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Soruva minti tuvaro Samueriva Sorurara eqaane tiro, Are vairaqe te Noravano Kotiva entaqi ti tiva timi uvara ai tiva amiare, tuvaro Soruva, Ho, tiva timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Minti tuvaro Samueriva Sorurara tiharo, Haaru are nenara tihara, Te qumina vaiinti vauro tianarave. Vate maa entara are Isareri avuhainaa vaiintivano varianarave. Noravano Kotiva naivano ai kaama tairave. ");
INSERT INTO tbg_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ho Noravano Kotiva ai atitero tiharo, Are oru Amareki hampata raquqira viharama, vi vatanaaka vaaqu kaiqa vare variaka ekaama aru taiqa kaane, tirave. ");
INSERT INTO tbg_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Viva minti tivara are nantiharae Nora Kotira uva kia avataaro? Nana kaarae are kantera oru Amareki vika ia haikara raqia varaaro? Are mintianara kaara Noravano Kotiva ariara vaaqu kaiqama varaivo tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Samueriva minti tuvaro Soruva aqao tiro, Te Noravano Kotiva tiva timintemake, oru iqoka raqunarave. Te oru Amareki vika ekaa arukema King Agaakiraqai qaqi ravaaqavu vare anunarave. ");
INSERT INTO tbg_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Ti iqoka vaiinti vikama purumakauve, sipisipive, koqekaqai kia arukaraiti, ai Variqa vira kaamate tiha, Kaiqenavu oru Giligaalini Nora Kotira ofaa iha quara amitaare, tiavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Soruva minti tuvaro Samueriva vira irama amitero tiharo, Noravano Kotiva nana okararae avuni antuqa arivo? Ofaa iha quara amite vai okararae avuni antuqa arivo, tenavu nai uva iri variaina okararae avuni antuqa arivo? Ho iriane. Nora Kotira nai uva iriha avataqi vua okarava, vi okarava ekaa vo okara vo okara naatara kero avuniqama kero vairave. Viva avuni vaivaro kaintu iha quara amite vai ofaavave vo ofaave vira naantiaraini vairave. ");
INSERT INTO tbg_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Nora Kotira uva raqake kia avataqi vua okarava vaireva, uhiakaa auti varia okarara voqaara vairave. Kotira qaqirake nariaraqai noraiqaake iri varia okarava vaireva, una variqara noraiqaake iri varia okarara voqaara vairave. Are Nora Kotira uva qoririma kaanara kaara, viva aivata, ˻are kuvuarama terauka vikavata, qoririma kaira kia ho avuhainaa vaiinti kaiqa varaqi vivarave tirave,˼ tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Samueriva minti tuvaro Soruva tiharo, Oho, quqaama te qora okarama autu kaunarave. Te Nora Kotira uva raqa kema ai uvavata raqa kaunarave. Te tenta iqoka vaiinti vika naatu qetake, vika tiantemake qora okara autu kaunarave. ");
INSERT INTO tbg_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Mpo, are ti qora okara vira nunka kera tauru timitera, tintira aniraqe Nora Kotira autu tuahera kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Soruva minti tuvaro Samueriva aqao tiro, Kia te ainti virerave. Are Nora Kotira uva qoririma kaanara kaara, Noravano Kotiva ninavata qoririma keharo ariara viva kia Isareri avuhainaa vaiintivano varianarove tivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Samueriva minti tiva kero tuqantaaviro vuare tuvaro Soruva virara vuantorave tiro, Samueriva nonkuto tavunara utu varovaro qunahi vura. ");
INSERT INTO tbg_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Qunahi vuvaro Samueriva vira tavero Sorurara tiharo, Ho tavaane. Are ti tavuna qunahi kaanantema kero, Noravano Kotiva vate are Isareriqaa raqikiana kaiqara vira ariqaahairo varakero, vovano aivata uri aatarakero variaina vaiintira vi kaiqara amianarove. ");
INSERT INTO tbg_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Isareri vika Variqavano takuqukero vaiva viva kia vo uva tivataira qaqira kero vo uva ti vairave. Viva kia vaiintivano avu aato utintemakero vo kaiqa varareva tira qaqirakero vo kaiqa vare vairavauve, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Samueriva minti tuvaro Soruva vira tiva amiro tiharo, Mpo, quqaama te qora okara autuma kauro. Are hoe tintira aniraqe tetanta oru Isareri qiata vaiintive, qaqi vaiinti nahentive, vika ruvaaqumavi varianaini vaiha Nora Kotira ai Variqa autu tuahera kaare. Are mintiraqe te vika nivuqaa variariraro kia ti hutuvano vataini tuvi vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Viva minti tuvaro ho Samueriva Sorukantiro vuvaro Soruva Nora Kotira autu tuahera kora. ");
INSERT INTO tbg_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Viraqaahairo Samueriva tiharo, Ne Amareki avuhainaara King Agaakira vita vare aniate tumanta vira vite anura. Agaakiva nai iriro tiharo, Soruva ti qaqi vehakuma timitairara ti, vika kiama ti arukevarave, tivakero ani vaura. ");
INSERT INTO tbg_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Mintuvaro Samueriva tiharo, Are nena iqoka paipeqohaira airi vaiinti aru taiqa kaaramanta vika nokavara vainti kaimaara variarave. Ho vohaa qaramakero, ai novavata vainti kaimaara varianarove, tivakero Samueriva Giligaalini Nora Kotira avuqaa vaiharo Agaakira aru kero teqa taaqama kora. ");
INSERT INTO tbg_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Viraqaahairo Samueriva anirantero Ramaini vuvaro Soruva nai maaqa Gibeaini vura. ");
INSERT INTO tbg_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Vi entaraqaahairo Samueriva nai qaqi vau entara kia qaiqaavata Sorura oru tavaraitiro, viva Sorurara iruvaro vira muntuka qoraiquvaro virara mpo tiva amiteharo vaura. Noravano Kotiva Sorura noraiqama kovaro Isareri avuhainaava vairara iriro tiharo, Kia te vi vaiintira noraiqama kaataarave, tura. ");
INSERT INTO tbg_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Noravano Kotiva Samuerirara tiharo, Nanti nanti entarae are qaqiqai Sorurara iqi rataqira vinarave? Te vira qoririma kauraro viva kiama Isareri avuhainaa vaiintivano variqiro vuanarove. Are inaara taqu vara kera viraqi orivi vahavera qihia varera Betarihemini oruntera, Iesira maaqu voqaa vahavera vira. ");
INSERT INTO tbg_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Minti tuvaro Samueriva tiharo, Oho, te mintima kaarera, Soruva vi uvara iriro ti haruma kaanarove, tuvaro Noravano Kotiva vira tiva amiro tiharo, Kiave. Are qaraaka purumakau nahe vo varera, Betarihemiqi variakara tihara, Te maa purumakaura Nora Kotira ofaa iha quara amitarera vare anuro, tiane. ");
INSERT INTO tbg_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Are mini ofaa autireva ihara Iesira aarairaro vivavata aniarire. Viva mini ani vairaqe te are autina okarara ai tiva amiare. Te ai umiqaaina vaiintira vira qiataqaama are vahavera aqu amitehara vira kaama taane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Ho Samueriva Noravano Kotiva tuntema kero, Betarihemini oruntomanta vihainaaka nora vaiintinavu aiqu kauqu ntiri ntiri i vaumanta vira vitake ireha tiha, Are vo haika kaarae aniaro, qaqie aniaro? ti. ");
INSERT INTO tbg_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Minti tuvaro Samueriva tiharo, Te Nora Kotira ofaa iha quara amitarerama anuro. Ho ne nenta avu aato muntuka hiqe okarara iriha qerama vare aniqe ofaa iha quaraare, tivakero Iesira nai maaquaravata tiharo, Nenavuvata mintimake qerama vare ofaa autuainara mini vuate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Minti tivakero Samueriva ofaa autireva unaini vaumanta vikavata anuvaro Samueriva Iesira maaqu hoqarenaara Eliaapira tavero nai aatoqi iriro tiharo, Quqaama viti vaiintira Noravano Kotiva kaama tai vaiintirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Minti tuvaro Noravano Kotiva virara aqao tiro, Are vukai vaiinti koqe viri vaata vataara tavehara, hauri are tiriara vira kaama tai vaiintirave tirorave. Te kia vaiintivano rairake tave variantemake, vaiinti rairake tave vauraukavauve. Ne qumina vaiinti viri vaatainiqai tave variarave. Te Noravano Kotika vaiinti avu aatoqive, muntukaqive, tave vauraukara ti, te Eliaapira qoririma kauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Minti tuvaro Iesiva nai maaqu vo Abinadaapira vita varero Samueriva unaini vuru kovaro Samueriva tiharo, Kiave. Noravano Kotiva kiama vi vaiintira kaama taivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Minti tuvaro Iesiva Samaara vita varero Samueriva unaini vuru kovaro viva tiharo, Aqao, Noravano Kotiva viravata kiama kaama taivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Samueriva minti tuvaro Iesiva nai maaqu 4navu mini vaukavata ntita varero Samueriva unaini vuru kovaro Samueriva tiharo, Aqao, Noravano Kotiva kiama vinavukaqihairo vo kaama taivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Minti tivakero viva Iesira irero tiharo, Ho maa vinavukaqaie ai maaqunavu variavo? tuvaro Iesiva tiharo, Vinavuka qata vovanovata vaivo. Viva sipisipiqaama raqiki vaivo, tuvaro Samueriva tiharo, Vo vaiinti atitairaro oru vira vita varero aniarire. Vivavata maini ani vairaqe tenavu Nora Kotira ofaa iha quara amitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Minti tuvaro vo vaiinti atitovaro oru vi vaiintira vita varero anura. Vi vaiintiva qaraaka vaiinti vauvaro vira virivano koqe iro vauvaro vira avuvano koqe avu vauvaro vira vaatavanovata koqe vaata vaura. Vi vaiintiva anuvaro Noravano Kotiva Samuerirara tiharo, Maa vi vaiintirave. Are himpira, vahavera vira qiataqaa aqu amitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Minti tuvaro Samueriva orivi vahavera vare anura vira vara kero, vira vakaukavara nivuqaa Devitira qiataqaa vahavera aqu amitora. Mintuvaro Nora Kotira Maraquravano vaaka tuvuntero Devitiraqaa vaiharo vira kempukaiqama amiteharo vi entaraqaahairo vikantiro variqiro vura. Samueriva Devitira kaama tero, viraqaahairo viva anirantero nai maaqa Ramaini vura. ");
INSERT INTO tbg_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Vi entara Nora Kotira Maraquravano Sorura qaqira kovaro Noravano Kotiva qora maraqura vo vara kovaro Sorura qoraiqama amite vaura. ");
INSERT INTO tbg_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Mintumanta Sorura kaiqa vaiintinavu Sorurara tiha, Tavaane. Kotiva qora maraqura vo vara kaivaro ariqi tuviqetero vaiharo ai qoraiqama amite vaivo. ");
INSERT INTO tbg_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Are hove tirera, tenavu oru vaiinti vovano koqemakero musiki ruquti vainara rantake, vira vita vare aniare. Kotiva varakai maraqurava ai qoraiqama amitaina entara vi vaiintiva musiki ai ruqutu amitairaro ai avu aatovano koqema kero variarire, ti. ");
INSERT INTO tbg_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Vinavuka minti tuvaro Soruva tiharo, Ho mintiate. Nenavu oru koqema kero musiki ruquti vaina vaiintira rantake, vira vite te iainanaini aniate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Minti tuvaro vira kaiqa vaiinti vovano Sorurara tiharo, Te tavauraro Betarihemini Iesira maaqu vovano koqema kero musiki ruquti vaivama vaivo. Vi vaiintiva kia navutaaka naatu qete vaiva vaiharo, uvavata koqema kero ti vairave. Viva koqe viri vaata vataava vairave. Noravano Kotiva vira hampata vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Minti tuvaro Soruva vi uvara iriro nai kaiqa vaiinti vonavu nititomanta oru Iesira tiva ami tiha, Soruva mintima tivo: Nena maaqu sipisipiqaa raqiki vaira Devitira atitairaro te iainanaini aniarire, tivo, ti. ");
INSERT INTO tbg_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Vinavuka minti tuvaro Iesiva vika uva iriro viraqaahairo viva donki vo varakero, vira tauvaqaqaa mpareti uta taaraqantavata, uaini taquvata kantaruma tero, qaraaka memeraa vo varero Devitirara maa haikara varera vuru Sorura amiane tivakero vira atitovaro Soruva unaini vura. ");
INSERT INTO tbg_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Devitiva Soruva unaini oruntero vira kaiqa vaiinti vaura. Ho Sorura antuqavano voqama kero Devitirara vauvaro Soruva vira noraiqama kovaro Devitiva Sorura auvihehavaa aqu vare ni vauva vovano vaura. ");
INSERT INTO tbg_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Mintuvaro Soruva uva vara kero Iesirara tiharo, Te Devitirara quahe vauro. Are vira qaqi kairaro viva maini vaiharo ti kaiqa varaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Ho Devitiva Sorukantiro vauvaro Kotiva qora maraqura varakova Sorura qoraiqama amite vau entara, Devitiva musiki varakero ruqutu amite vauvaro qora maraqura viva qaqini vinuvaro Sorura avu aatovano koqema vuvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Pirisia vika airitahaa iqoka raqireka Soko vatukaini ruvaaqumavi vaura. Vi vatukava Iutaini vauvaro Asekaa vatuka vutuni vaumanta tavaarana Efesi-Damimi Uqitaini vika nái seri naavu maaqa airitahaa kaqate vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Vika mintumanta Soruvavata, ekaa Isareri iqoka vaiinti vikavata, ruvaaqumavi Elaa Uqitakanta nái seri naavu maaqa kaqate vaiha Pirisia hampata iqoka raqireka qera iha vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Pirisia iqoka vaiinti vika aiqina voqaa vaumanta Isareri iqoka vaiinti vika aiqina voqaa vauvaro tavaarana qumina uqita vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Mintimake vauvaro vaiinti vo vira autu Golaiaativa Pirisia iqoka vaiinti vikaqihairo otuntero uqita kanta himpitero vaura. Vi vaiintiva Geti vatukaihainaava, nai vukai vuhaantaari vataava, 3 mita vau vaiintiva vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_5","010_17_5","1SA","17","5","6","Vi vaiintiva baraasi oriqohairo nai qiatave, vaatave, aiqunive, naavuma tero vaura. Viva naavumato haikara maaravano 50 kilo vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Vi vaiintiva nora vaantaara nai kururuqaa aqutero vauvaro vaantaara vira aquvano nora qora vauvaro vira viaru ainiqohai autu tora maaravano 7 kilo vaura. Vi vaiintiva mintimakero vauvaro vo vaiintivano vira kainke aqu varero vira avuni vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Golaiaativa oru quminaini uqita kanta himpi vaiharo Isareriara naveraitiharo, Ne nana haika autirekae auvihehavaa tuateha qera i variavo? Ho ne Sorura paanaa kaiqa vare variaka iriate. Te Pirisia qoraintivanove. Niqihai vaiinti vo vara kaivaro vi vaiintiva ti hampata ani raquarire. ");
INSERT INTO tbg_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Vi vaiintiva ti haatara kero haru kairera, tenavu ni qumina kaiqa vaiinti vairarave. Te vi vaiintira aatarake vira arukaarera, ne tinavu qumina kaiqa vaiinti vaivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Golaiaativa minti tivakero viva qaiqaa tiharo, Ho vate te ni Isareri kempuka avateha tavarerave. Ne vaiinti vo ti timiqe te vira hampata iqoka raquare, tumanta ");
INSERT INTO tbg_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Soruvavata ekaa Isarerivata vi uvara iri, oho oho tivakeha voqamake qeteha vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Devitiva Iesira maaquvano vauvaro Iesiva Efaraatara ankuqiraava vaura. Viva Betarihemi Iutaa vataini vaiharo qorainti vainti 8navu vatatero variqiro viro King Soruva vau entara viva anoma naampaiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Vira maaqu avuni vatatoka taaramonavu iqoka raqireka Sorura aiquantakaa vura. Avuni vatatova Eliaapiva vauvaro vira naantiara Abinadaapiva vauvaro vira naantiara Samaava vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Iesira maaqunavuqihairo Devitiva ekaanaini vatatova vaumanta vira vakauka taaramonavu avuni vatatoka Sorura aiquantakaa vuvaro ");
INSERT INTO tbg_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Devitiva hini entanavu vinavuka hampata oru varikero, viraqaahairo orurantero hini entanavu ani Betarihemini vaiharo nai qora sipisipiqaa raqiki vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Ho Golaiaativa toqaqivata eronainivata 40 entara variqiro viharo Isareriara naveraitiharo, Ne vaiinti vo ti timiqe te vira hampata iqoka raquare, tivaqiro vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Ho vo enta Iesiva nai maaqu Devitirara tiharo, Are te uiti ihaqi untake utaqi ntuva taunara varera, mpareti 10navuvata varera, seri naavu maaqa kaqate varianaini vivira, vuru nena vakaukavara nimiane. ");
INSERT INTO tbg_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Sipisipi naama tatike aaharaiqama taara 10navuvata varera iqoka vaiintiqaa raqiki vai vaiintira vuru amiane. Ai vakaukavara hoe variavo, kiae ho variavo? Are vika virara iramakera irira, viri tivata tiva timiane. Are vihaira vo haikavata varera viri ti humiqairaqe te vi haikara tave, ariara quqaama mini vivave tirarave. ");
INSERT INTO tbg_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","King Soruvavata, ai vakaukavaravata, ekaa Isarerivata, vika Elaa Uqitakanta vaiha Pirisia hampata iqoka raqi variavo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Vira qova minti tuvaro vira qararaa vaaka toqaqi Devitiva himpiro vo vaiintiara sipisipiqaa raqiki timitaane tivakero kara varero oru Iesiva tunte ura. Devitiva Isareri seri naavu maaqa kaqatonaini oruntero tavomanta Isareri vika iqoka raqunaini viha, iqoka ihi haampu tivaqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Vika iqoka vatukaini oru vaiha vika hini mantaraini qeramate vaumanta Pirisia vika hini mantaraini qeramate vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Mintuvaro Devitiva kara vare vura ekaa karaqaa raqiki vau vaiintira amiro, kantero iqoka raqireka qera i vaunaini oruntero nai vakaukavara uva mantero. ");
INSERT INTO tbg_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Viva uva mante vauvaro Golaiaativa nai navunaaka mini kero oru qumina kanta vaiharo vo enta vo enta nai Isareriara ti vau uvara qaiqaa tuvaro Devitivavata vi uvara tura irura. ");
INSERT INTO tbg_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Viva minti tumanta Isareri vika Golaiaatira tave vira aatu qetake kanteha ");
INSERT INTO tbg_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","nai tiva ami nai tiva ami iha tiha, Oho, tavaate. Vi vaiintiva qaiqaa qaiqaavata antua aantua ti vaivo. King Soruva tiharo, Vira aru kaaina vaiintira te nora monu ami, airairavata ami, tenta raavuravata vi vaiintira ira amitarerave. Vi vaiintira qora naavuqi vaika kiama takisi aqivarave. Soruva minti tirave, ti vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Ho vika qeteha kante vauvaro Devitiva nai tataaqa vau vaiintika irero tiharo, Vo vaiintivano Pirisia vaiinti vira arukero tinavuqaa kaurira haika vatainara taiqa kairera, nana koqaae vira amivarave? Pirisia vaiinti viva qaqi qumina vatanaavama vaivo. Viva tinavu Variqa qaqi variqiro vi vaira, vira iqoka vaiintiara antua aantua ti vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Minti tumanta vika qaiqaa Devitira tiva ami tiha, Vira arukaaina vaiintira avuhainaa vaiintivano minti mintima keroma amianarove, ti. ");
INSERT INTO tbg_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Minti tuvaro Eliaapiva Devitira vakaava hoqarenaava tavovaro Devitiva vika hampata uva ti vauvaro vira arara itovaro Devitirara tiharo, Are nantivarae maini ani variaro? Tavave ai vehi sipisipi aahara vataini kaanaraqaa raqiki vaivo? Are hama hama ianarara te irunarave. Are qumina iqoka raqira tavareva aniaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Minti tuvaro Devitiva nai vakaarara aqao tiro, Te vo haikara kankomake irirera maaka ire vauro. Kia te ho virara vika ireha tavaainarave? tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Minti tivakero viva tuqantaaviro vo vaiinti vo vaiinti vohaa vi uvaraqai iramaqi vumanta vikavata vohaa vi uvaraqai nai tiva ami vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Minti ti vaumanta vaiinti vonavu Devitiva tu uvara iri, vuru Sorura tiva amuvaro Soruva tiharo, Vira aaraivaro aniarire, tumanta Devitira aarovaro Soruva unaini oruntero ");
INSERT INTO tbg_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","virara tiharo, Avuhainaa vaiintio, tenavu qumina Pirisia vaiinti vira aatu qetaarorave. Te oru vira hampata raqirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Minti tuvaro Soruva aqao tiro, Are kia ho Pirisia vaiinti hampata iqoka raqinarave. Are qaraaka vaiintivano variaro. Vi vaiintiva qaraaka vaiinti vai entaraqaahairo airi ihiara iqoka raquqiro vi vai vaiintivama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Tuvaro Devitiva tiharo, Avuhainaa vaiintio, Te tenta qora sipisipiqaa maimaraara raqiki vauraukave. Te tavauraro raionivanoe, beavanoe, sipisipi naati aruke nareva ravaaqavukero vare vumanta ");
INSERT INTO tbg_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","te vira avataqi vivi, vira ruqutuke sipisipi naati vira noqihai tenta qaqi varaunarave. Raionivanoe, beavanoe, tuqantaaviro ti harireva autimanta te vira aunta kauki tuate, vira ruqutuqivi, vira arukaunara. ");
INSERT INTO tbg_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Avuhainaa vaiintio, te raionivata beavata aru kaunarave. Te vika arukaunantemake, homa te maa vaiintira qumina vatanaara, Pirisia vaiinti arukararave. Viva tinavu Variqavano qaqi variqiro vi vaira, vira iqoka vaiintiara antua aantua ti vaivo. ");
INSERT INTO tbg_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Noravano Kotiva raionive beave vikaqaahairovata ti ruaruama timitairara tiro, viva homa Pirisia vaiinti viraqaahairovata ti ruaruama timitaanarove, tiro. Devitiva minti tuvaro Soruva tiharo, Hove. Are viraro Noravano Kotiva ai hampata vuarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Soruva minti tivakero viva nai iqoka utavaaqa ˻qaqi vatora˼ Devitira amura. Viva vira qiataqaa baraasi tovaqa aqu amitero, baraasi siotivata vira nonku amitero. ");
INSERT INTO tbg_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Mintuvaro Devitiva Sorura iqoka paipe rumpatero oru virare tuvaro kia tota vi haikara nonkutovara tiro, kia ho vuarirava vauvaro viva tiharo, Kia te tota maa haikara nonkunarara ti, kia te ho vira nonkute iqoka raqirerave, tivakero vi haikara ekaa qaqini rahunku kora. ");
INSERT INTO tbg_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Mintimakero viva nai sipisipiqaa raqiku kaururaqai tota varero oru inaara namarivano tuvuraqihairo ori kampori 5navu vara kero nai utaqi ntuva tero, viraqaahairo ori vataaina naaquntara varero, Golaiaatira hampata raqireva vura. ");
INSERT INTO tbg_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Devitiva Golaiaatira hampata raqireva vuvaro Golaiaativa vira tavero vira aumanto anuvaro vira kainke vare vau vaiintiva vira avuni ani vaura. Golaiaativa vaini vaini ");
INSERT INTO tbg_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","aniharo tavovaro Devitira virivano koqe viri, qaraaka vaiinti viri vauvaro viva Devitira naaraihama amitero tiharo, Viva qaqi qaraaka vaiintive. Viva kiama ho tintiro raquanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Minti tivakero viva tiharo, Are tiriara vairivano vaivo tivakerae kairiqaqohaira ti harireva aniaro? tivakero nai variqa, vo variqa vo variqa naareharo vikara Devitira qoraiqama amitaate tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Minti tivakero viva Devitirara tiharo, Ho aniane. Are aniraqe te ai aruke ai vaata uvirivata qaakau vairivata nimiari naate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Golaiaativa minti tuvaro Devitiva nai tiva amiro tiharo, Are iqoka paipevata, vaantaaravata, tuaterama ani ti hampata raqireva auti variaro. Are mintiaramanta te Noravano Kotiva ekaa kempuka vataira autuqaa ai hampata raqirera anuro. Variqavano tinavu Isareri iqoka vaiintiqaa raqiki vaira, are virara qora uva ti varianarave. ");
INSERT INTO tbg_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ho vatema Noravano Kotiva ti kauquqi ai kaanarove. Te vate ai aruke ai aunta teqa karerave. Vate tenavu Isareri ni Pirisia vaata uvirivata qaakau vairivata nimiari nevarave. Tenavu mintiari ekaa vataini variaka iri tiha, Quqaama Isareri Variqavano vaivo, tivarave. ");
INSERT INTO tbg_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Vate ekaa vaiinti maini ruvaaqumavi variaka, vika tavaivaro Noravano Kotiva kia iqoka paipeve, vaantaarave, virara noraiqaakero iriraitiro, viva nai kempukaqohairo homa nai vaiinti nahenti ruaruama nimitaanarove. Vate Noravano Kotiva ni naatara kero viva ni tinavu kauquqi kaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Devitiva minti tuvaro Golaiaativa qaiqaa Devitiva vaunaini vireva auti vauvaro Devitiva kantero vira aumanto ori vaiqiro, ");
INSERT INTO tbg_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","aumanto oruntero nai utaqihairo ori vo urequ kero naaquntaqi vatero, pope popema kero aqu kovaro orivano Golaiaatira tiri vuhaariqi viqe tovaro viva virianaihairo vatakanta hiqintura. ");
INSERT INTO tbg_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Devitiva kia iqoka paipevata nai kauquqi tuataraitiro, viva ori vaati naaquntaqi vatero, pope popema kero aquko haikaraqohairo Golaiaatira arukero vira aatarakora. ");
INSERT INTO tbg_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Golaiaativa vatakanta hiqintuvaro Devitiva kantero oru vira tataaqa himpiro vaiharo Golaiaativa iqoka paipe ntuvatora rarau varero, viraqohairo Golaiaatira aunta teqa aqukora. Mintima komanta Pirisia tavovaro vika iqoka vaiinti taruva avuni vauva qutu vumanta vika qetake tuqantaavi aiqu autute kantama vura. ");
INSERT INTO tbg_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Mintumanta Isarerivata Iutaavata vika naveraitivaqi viha, Pirisia vika aru ntataqi vivi, Geti vatuka aumanto oruntora. Hini kuka Pirisia aru ntataqi vivi, Ekaroni vatuka vaantaavura qentiana vuru kora. Vika Pirisia arikovaro vika vaatavano Saraimini vi vau aararaqaavata, Getinivata Ekaroninivata vi vau aararaqaa vona vona vaura. ");
INSERT INTO tbg_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Isareri vika Pirisia aru ntata vuru ke, orurante ani Pirisia seri naavu maaqa kaqatoraqihai ekaa haika varora. ");
INSERT INTO tbg_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Devitiva Golaiaatira auvihehavaa varero vuru nai seri naavuqi vatero, vaiinti nahenti Ieruharemini variaka tavaate tiro, Golaiaatira qiata teqakora varero Ieruharemini vuru kora. ");
INSERT INTO tbg_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Devitiva Golaiaatira hampata raqireva vuvaro Soruva nai iqoka vaiinti vika qiata vaiinti Apinera irero tiharo, Apineo, viti vaiintira vira qora tarave? tuvaro Apineva tiharo, Avuhainaa vaiintio, kia te vira qora autu irunarave, tuvaro ");
INSERT INTO tbg_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Soruva tiharo, Vo kiaka virara iramakera irira, viri ti tiva timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Ho Devitiva Golaiaatira arukero vira aunta teqa kero vira qiata nai kauquqi tuata varero orurantero anuvaro, Apineva vira vita varero Soruva vaunaini viri kora. ");
INSERT INTO tbg_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Mintuvaro Soruva Devitira irero tiharo, Ti vaiintio, ai qora tarave? tuvaro Devitiva tiharo, Ai kaiqa vaiinti Betarihemini vaira Iesirave, tura. ");
INSERT INTO tbg_vpl VALUES ("S118_1","010_18_1","1SA","18","1","2","Soruva Devitikantiro uva tiva taiqa kero Devitira ravaaqavu tovaro kia nai maaqaini viraitiro, Sorukantiro mini vaura. Mini vauvaro Sorura maaqu Ionataaniva Devitira tontiqama kero nariara antuqa arintema kero, Devitirara antuqa arivaro vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Mintuvaro Ionataaniva nai kauqu aiqiqaa aqukero Devitirara tiharo, Quqaama ti muntukavano ekaa entama ariara varianarove, tivakero ");
INSERT INTO tbg_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","nai vukai utavaaqa nonku toravata, iqoka utavaaqavata viqukero Devitira amura. Viva iqoka paipeve, huruve, retive, ekaa vi haikara vi haikara Devitira amura. ");
INSERT INTO tbg_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Ho Devitiva Sorukantiro vauvaro Soruva Devitira atitovaro viva iqoka vaiinti ntita varero Pirisia hampata raqiharo iqoka aatarake vaura. Devitiva qaiqaa qaiqaavata minti vaurara tiro, Soruva vira noraiqama kovaro Devitiva iqoka vaiinti vika opisaa noravano vaumanta ekaa vaiinti nahentivata, Sorura opisaa ekaa vikavata, Devitira noraiqama korara quahe vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Ho Devitiva Golaiaatira arukomanta Isareri iqoka vaiinti orurante ani vaumanta Isareri nahenti vika vo vatuka vo vatukaqihai aninte King Sorura vira quahama amitora. Vika ihi nteha quaha quahamaqi viha, tamparinivata kitaavata ruqutuqi viha ihi tivaqi vi vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Vika ihi tivaqi viha tiha, Soruva airi vaiinti aru kaivaro Devitiva viravata uri aatarakero nai airi vaiintima aru kaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Nahenti vika minti tivakeha ihi ti vauvaro Soruva vika tu ihirara kia quahora. Vira arara itovaro viva tiharo, Vika tiriara airi vaiinti arukaivo, tivake Devitirara viva uri aatara kero nai airi vaiintima arukaivo, ti variavo. Oho, vika antuqavano Devitiva ti vatuka varero avuhainaa vaiintivano variarire tie minti ti variavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Soruva minti tivakero vi entaraqaahairo vi haikarara noraiqaakero iriharo, Devitira toma amiteharo vira iri qoraiqama amite vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Ho vira qararaa Soruva nai naavuqi vauvaro Noravano Kotiva qaqi kovaro qora maraquravano Soruraqi tuviqetovaro vaakama vira avu aatovano hampiqama vuvaro viva vuera ntai vaiintira voqaara naveraiti vaura. Minti vauvaro Devitiva vo enta vo enta nai musiki ruquti vauntema kero, vi entaravata ruquti vauvaro Soruva vaantaara vara tuatero nai iriro tiharo, ");
INSERT INTO tbg_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Kaiqe te vaantaara aqu kaariraro Devitira poruvaaqaa aru taatau taarire, tivakero vaantaara vira aqu kovaro Devitiva ruhiti vuvaro vaantaara viva qaqini aru viro. Qaiqaa vovata aruvaro Devitiva ruhiti vuvaro qaqini aruvura. ");
INSERT INTO tbg_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Soruva tavovaro Noravano Kotiva vira qoririma kero Devitikantiro vaurara tiro, viva Devitira aatu qeteharo vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Vira aatu qeteharo virara ti hampata variantorave tivakero, vira atitero tiharo, Are 1,000 iqoka vaiintiqaa raqikihara iqoka raquane, tuvaro Devitiva vika ntita varero navutaaka hampata oru raqi vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Ho Noravano Kotiva Devitikantiro vauvarora tiro, viva navutaaka hampata vo tataa vo tataa raquqi viharo vika naatarake vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Soruva tavovaro Devitiva mintima kero navutaaka naatarake vauvaro Soruva vira aatu voqama kero qetora. ");
INSERT INTO tbg_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Ekaa Isarerivata Iutaavata tavovaro Devitiva koqema kero iqoka vaiinti ntita varero navutaaka naatarake vaurara ti, vika virara quahe vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Ho Soruva Devitira arukaainarara nai iriro tiharo, Hauri te tenta Devitira arukaarorave. Kaiqe te vira atitaariraro viva iqokaqi viramanta Pirisia vika vira arukaate, tivakero viva Devitirara tiharo, Are kia qetaraitira, Nora Kotirara irihara kempukaiqama kera iqoka raqirera, te tenta raavura avuniara Meraapira ai amirerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Minti tuvaro Devitiva aqao tiro, Te qumina vaiintima vauro. Ti qora ankuvanovata kia autu vataa ankuvano vaimanta, virara iriha te kia ho avuhainaa vaiinti raavura varaainarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Minti tuvaro Soruva kempukaiqaakero vo enta kaama tero tiharo, Vi entaraqaa are Meraapira varenarave, tuvaro vi entava anintovaro Soruva qaqirakero kia vira amiraitiro, Mehoraihainaa vaiinti Adarielira amura. ");
INSERT INTO tbg_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Mintuvaro Sorura raavura vo Mikaaliva voqama kero Devitirara antuqa aruvaro vaumanta vokuka vi uvara vuru Sorura tiva amuvaro Soruva vi uvara iriro quahora. ");
INSERT INTO tbg_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Soruva naiqai iriro tiharo, Hove, te Mikaaliraqohai Devitira mintama vararerave. Te vira Devitira amiariraro viva Mikaalirao tiro, oru iqoka raqiramanta Pirisia vika Devitira arukaate, tiro. Mintimakero iriro Soruva qaiqaa Devitirara tiharo, Are ti raavura vo homa varenarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Soruva minti tivakero nai kaiqa vara amite vaukara tiharo, Nenavu tavaivaro Devitiva nariaraa vairamanta virara mintima tiate: Ho tavaane, avuhainaa vaiinti vivavata, vira kaiqa vaiinti vikavata ariara quaheha variavo. Homa are maa entara vira raavura varenarave tiate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Soruva minti tumanta vinavuka viva tuntemake Devitira tiva amuvaro viva aqao tiro, Te vehi vaiinti vaiha kia monu airairavata vatauraro ti hutuvanovata kia vaimanta vaunarara ti, te kia avuhainaara raavura ho varaainarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Devitiva minti tumanta Sorura kaiqa vaiintinavu vuru vi uvara tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","viva vinavukara tiharo, Nenavu vuru Devitira mintima tiva amiate: Avuhainaa vaiinti viva kia ariara nora koqaa autuane, tivo. Viva ariara tiharo, Are oru navutaaka Pirisia iqoka vaiinti 100navu arukera tiqaa vuntu kaane. Are vika arukera vika qake paha toqakera 100navu viri ti timiraqe te vira tave, virara ti raavura koqaa homa vaivo tirarave tivo, tiate, tiro. Soruva mintima kero Devitira arukerara nai aatoqi iri vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_26","010_18_26","1SA","18","26","27","Ho Sorura kaiqa vaiintinavu vi uvara vuru Devitira tiva amuvaro Devitiva quahakero tiharo, Te homa vi koqaara autuke Sorura raavura varaainarave, tivakero Soruva kaamato entava kia aintoraqaa Devitiva vaakama nai iqoka vaiinti ntita varero oru iqoka raqiharo 200 Pirisia vaiinti arukero, vika paha toqakero vare anura Sorura avuqaa vaiharo kaara ntuvakero vira amura. Mintuvaro Soruva Mikaalira vira amuvaro Devitiva vira varatero vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Soruva kankoma kero iruvaro Noravano Kotiva Devitira hampata vauvaro vira raavura Mikaalira muntukavano Devitirara vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Mintuvaro Soruva voqavata Devitira aatu qeteharo, ekaa nai qaqi vau entara vira navutaiqama amite vaura. ");
INSERT INTO tbg_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Ho Pirisia vika airi tataa Isareri hampata iqoka raqi vauvarovata, Devitiva vika naatarake vaura. Minturara ti, Devitiva Sorura iqoka vaiinti taruva avuniqama kero vaumanta vaiinti nahenti vira nora autu amura. ");
INSERT INTO tbg_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Soruva Devitira arukaaina uvara nai maaqu Ionataaniravata, nai kaiqa vaiintinavuvata, tiva nimura. Minti tuvaro Ionataaniva Devitirara voqamakero antuqa aruvarora tiro, ");
INSERT INTO tbg_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","viva oru Devitira rantakero virara tiharo, Ti qova ai arukareva auti vaivo. Mpo, raurihara variane. Hura toqaqira are vonaini oru kukeqavira variane. ");
INSERT INTO tbg_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Are kukeqavi vairaqe te tenta qokanti mini ai tataaqa oru himpi vaiha, te ariara vira tiva amiariraro viva vonare tirera, ai viri tiva amiare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Minti tivakero vira qararaa toqaqi Ionataaniva nai qokantiro oru mini vaiharo Devitirara Sorura tiva amiro tiharo, Are avuhainaa vaiintivano vaihara kiama nena kaiqa vaiinti Devitira qoraiqama amitaane. Devitiva kiama ai qoraiqama amitaraitiro, viva vo kaiqa vo kaiqa ai vara amiteharo ai koqema amite vaivama vaivo. ");
INSERT INTO tbg_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Haaru Devitiva nai qutuainararave nai qaqi variainararave kia noraiqaakero iriraitiro, viva oru Golaiaatira arukairave. Devitiva mintivaro Noravano Kotiva tinavu Isareri kahaqama timiteharo tinavu navutaaka naatara kairave. Vi entara are nenavano vira tavera voqama kera quahaanarave. Mpo, Devitiva kia qora okara autiraitiro, koqe vaiinti vaivara, are qumina vira aru kareva auti variaro. Nana kaarae? Are qumina vira aru kairera, ai kaiqavano qora kaiqama varianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Minti tuvaro Soruva Ionataaniva tu uvara iriro, Quqaama tiaro, tivakero nai aiqiqaa kauqu aqu kero tiharo, Noravano Kotiva ekaa enta qaqi variqiro vi vaira autuqaa te quqaama turo. Kiama te Devitira aru karerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Soruva minti tivakero ˻vuvaro˼ Ionataaniva Devitira aaramakero Soruva tu uvara ekaa vi uvara vira tiva amiro, viraqaahairo vira vita varero Soruva unaini vuru kovaro Devitiva haaru King Sorukantiro vaiharo kaiqa vara amitontema kero, qaiqaavata vara amite vaura. ");
INSERT INTO tbg_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Ho qaiqaa Pirisiavata Isarerivata iqoka raqi vaura. Devitiva nai iqoka vaiinti ntita varero oru kempukaiqama kero Pirisia ntaihamaqiro viharo vika naatara komantara ti, Pirisia vika qetake aiqu autute kantama vura. ");
INSERT INTO tbg_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Mintuvaro vo enta Soruva nai naavuqi oquvi vaiharo nai kauquqi vaantaara totatero vauvaro Noravano Kotiva qora maraqura vo atitovaro viva Soruraqi tuviqetero vauvaro Devitiva Sorukantiro vaiharo musiki ruqutiharo vauvaro ");
INSERT INTO tbg_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Soruva tiharo, Kaiqe vaantaara aqu kaariraro vira porovaaqaa aru taatau taarire, tivakero vira aqu kovaro Devitiva ruhiti vuvaro vaantaara viva qaqini aru vuvaro Devitiva ruqema kero vura. ");
INSERT INTO tbg_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Ho vohaa vi entara entaqi Soruva nai kaiqa vaiinti vonavu nititero tiharo, Nenavu oru Devitira naavuqaa raqiki vaivaro aatita viramanta oru vira aru kaate, tiro. Minti tuvaro Devitira naata Mikaaliva Devitira tiva amiro tiharo, Ai arukevorave. Himpira maaqihaira ruqemakera vuane. Are kia vate entaqi virera, hura toqaqima ai arukevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Mikaaliva minti tiva kero naaqunta vara kero uintuana kantaruma tovaro Devitiva naaqunta vira utu varero vataini viavi ntero ruqema kero viro. ");
INSERT INTO tbg_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Vuvaro Mikaaliva una variqa katariqohai aututo haikara vara kero Devitiva vaito taintaraqaa vaitakero, tavuna varakero viraqaata aqutero, memeraa kauhivata varakero vira qiataini ntuva amitora. ");
INSERT INTO tbg_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Ho mintumanta Sorura kaiqa vaiintinavu ani Devitira ravaaqavu kaare tuvaro Mikaaliva vikara tiharo, Devitiva aiha vivaroma vaivo, tumanta ");
INSERT INTO tbg_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","vika anirante vuru Sorura tiva amuvaro Soruva vikara tiharo, Ne anirante oru nenta avuqohai naavuqi Devitira tavaate. Ne vira tave, vira nai tainta hampata auku vare aniqe te vira aru kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Minti tumanta vika anirante oru Devitira naavuqi oriqete tavovaro una variqa aututo haikava vira taintaqaa vauvaro vira qiataini memeraa kaukiqai vaura. ");
INSERT INTO tbg_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Ho Soruva Mikaalira irero tiharo, Nantivarae are ti unaqaraiqama kera ti navutaara qaqi kaararo ruqema kero vivo? tuvaro Mikaaliva nai tiva amiro tiharo, Aqao, Devitiva tiriara tiharo, Are kia ti kahaqirera, te ai aruma kararave, tivera te vira kahaqama amitauro, tura. ");
INSERT INTO tbg_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Ho Devitiva ruqema kero Ramaini Samueriva vaunaini oruntero, Soruva nai vira arukareva auti vau uvara ekaa vi uvara Samuerira tiva amiro, viraqaahairo viva vikantiro Naioti vatukaini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Mini vaumanta vokuka Sorura tiva ami tiha, Devitiva Naiotini Ramaa vatuka aumanto vaivo, ti. ");
INSERT INTO tbg_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Minti tuvaro Soruva vaiinti vokuka nititero tiharo, Nenavu oru Devitira ravaaqavu vare aniate, tumanta vika mini orunte tavomanta paropeti vaiinti vika Kotira uva tiva qoqaiqamake vauvaro Samueriva vika qiata vaiinti vaiharo mini himpiro vaura. Minti vauvaro Kotira Maraquravano Soruva nititokaqaavata tuvu vaiharo kempukaiqama nimitomanta vikavata Kotira uva tiva qoqaiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Ho Soruva vi uvara iriro, viva qaiqaa vokuka nititomanta vikavata orunte vohaa qaramake Kotira uva tiva qoqaiqamake vauvaro, Soruva qaiqaa vokukavata nititomanta vikavata orunte vohaa qaramake Kotira uva tiva qoqaiqamake vaura. ");
INSERT INTO tbg_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Vika mintuvaro Soruva nai himpiro Ramainiara vura. Viva nora ruvu namari vaura Sekuni oruntero vihainaa vaiinti irero tiharo, Samuerika Devitika tainie variavo? tumanta vika tiha, Vitanta Naiotini Ramaa aumantoma variavo, ti. ");
INSERT INTO tbg_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Minti tuvaro Soruva aaraini vi vauvaro Kotira Maraquravano tuvu Soruraqaa vauvaro vivavata naveraitiharo Kotira uva qoqaiqamaqiro viharo Naiotini oruntora. ");
INSERT INTO tbg_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Soruva nai utavaaqa rahunku qaqini kero vivavata Kotira uva tiva qoqaiqamake vau vaiintika tuntemakero, Samuerira aaqanto vaiharo vohaa vi entara entaqivata aatitoraqaavata vataini toka vaiharo uva ti vaura. Minti ti vaurara tiro, vi uvava vi ani vaumanta vaiinti nahenti tiha, Quqaae Soruvavata paropeti vaiintiqama vivo? tura. ");
INSERT INTO tbg_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Ho Devitiva Sorura aatu qetakero Naiotini vaura kero ruqema kero Ionataaniva vaunaini oruntero Ionataanira irero tiharo, Oho, Ionataanio, nana kaarae ai qova ti haru kareva auti vaivo? Kiama te ai qora qora okaravata autu amite vira qoraiqama amite vaunarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Minti tuvaro Ionataaniva nai tiva amiro tiharo, Aqao, kiama ti qova ai arukareva auti vaivo. Viva ekaa nora haikave inaara haikave autireva iharo viva ti naane tiva timi vaivama vaivo. Viva ai arukareva itirio, viva kiama vi uvara kukeqa karaitiro, ti tivama timitirio. Kiama viva ai arukareva auti vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Minti tuvaro Devitiva aqao tiro, Ai qova kankoma kero tavaivaro ai antuqavano tiriara vairave. Mintima vaivarora tiro, ai qova ti aru kaaina uvara kia ai tiva amiraitiro, viva vi uvara kukeqatero tiharo, Hauri te vi uvara Ionataanira tiva amiariraro vira muntukavano qoraiqiantorave, tirave. Ho Noravano Kotiva ekaa enta qaqi variqiro vi vaira autuqaa te quqaama turo. Ai qova ti haru kaarirava aumantoma vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Minti tuvaro Ionataaniva Devitirara tiharo, Mpo, te nantiakee ai kahaqama amitararave? Are nana nana haikara ti autu timitaane tiraqe te ai autu amitarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Ionataaniva minti tuvaro Devitiva tiharo, Hura Qaraaka Torara iriha kara neraqaa te oru ai qokanti vaiha kara naariravama vaivo. Are ti qaqi kairaqe te kia mini viraiti, oru naahoqi kukeqavi variare. Te huravata moravata miniqai kukeqavi variqi viha entama karerave. ");
INSERT INTO tbg_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Ai qova kara neharo ai irero tiriara tainie vaivo tirera, are mintima tiane: Devitiva tiriara tiharo, Hoe te ti ankuvano Kotira ofaa iha quara amite entava qovaraiqinaini Betarihemini oru variainarave? tivera te hove tunarave. Minti tivakera nena qora tiva amiane. ");
INSERT INTO tbg_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Are minti tivakera nena qora tiva amiraro viva koqeve tirera, are te koqemake variainarara kankoma kera irinarave. Are tavairaro vira arara itairera, are viva ti qoraiqama timitaainarara kankoma kera irinarave. ");
INSERT INTO tbg_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Mpo, are Nora Kotira avuqaa vaihara tiriara tihara, Te ekaa enta ai tonti taruka vairerave tiva taanara iriharama, are ti nena kaiqa vaiinti koqema timitaane. Quqaa te ai qora qora okara amitaarirava vairera, are nenavano ti haru kaane. Hauri are nena qora kauquqi ti vuru kairaro ti harukaantorave tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Devitiva minti tuvaro Ionataaniva aqao tiro, Kia mintima kera avu aato utuane. Oho, te tavaariraro ti qova ai qoraiqama amitareva irera, te vaakama ai vuru tiva amirarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Minti tuvaro Devitiva vira irero tiharo, Are tiriara nena qora tiva amiraro viva tiriara arara itairera, tavave vi uvara ti viri tiva timianarove? tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Devitiva minti tuvaro Ionataaniva tiharo, Aniqetanta naahoqi oru vaiha uva tiare, tivaketanta naahoqi vura. ");
INSERT INTO tbg_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Vitanta naahoqi orunte Ionataaniva Devitirara tiharo, Nora Kotira tinavu Isareri Variqa autuqaa te una tiarera, viva ti qoraiqama timitaarire. Huravata vira qararaavata te tenta qora ariara ireha tavarerave. Viva ariara quahairera, te are inanaini uva vara karerave. ");
INSERT INTO tbg_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Ti qova ai qoraiqama amiteharo ai aru kareva irera, te ai tivama amirarave. Te kia ai tiva amiraiti, kia ariara ruqemakera vuane tiarera, Noravano Kotiva anoma kero ti qoraiqama timitaarire. Mpo, Noravano Kotiva haaru ti qokantiro vaintema kero, aintirovata vairera, te hove tiataarave. ");
INSERT INTO tbg_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Naantiara te qaqi variarera, are Nora Kotira avuqaa nena kauqu aiqiqaa aqukera tiva tenantema kera, tiriara ike mpo tiva timitaane. Te qutu vuarera, ");
INSERT INTO tbg_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","are ti vaintivara kia qoraiqama nimitaraitira, ekaa enta ekaa entama vika koqema nimitaqira vuane. Noravano Kotiva ekaa ai navutaaka aru taiqa kairara, are vi entara kiama tetanta tivataaina uvara tauru kaane. ");
INSERT INTO tbg_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Areve, ai vaintivarave, vi uvara tauru kaivera, Noravano Kotiva ni qoraiqama nimitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Ionataaniva minti tivakero viva nariara antuqa arintema kero, Devitiraravata muntuka vateharora tiro, viva tiharo, Mpo, Devitio, quqaa ai muntukavano tiriara vairera, are qaiqaa nena kauqu aiqiqaa aqu kehara virara ti tiva timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Minti tivakero Ionataaniva Devitirara tiharo, Hura Qaraaka Torara kara ne entava varianarove. Hura ti qova kara nareka inaini vaiharo tavairaro ai virivano kia vairaro viva ariara, Tainie vaivo? tianarove. ");
INSERT INTO tbg_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Ho hura vira qararaa erainaini are tota kukeqavira variana oriva vainaini, qaiqaa mini oru kukeqavira ti veka variane. ");
INSERT INTO tbg_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Are mini vairaqe te veva vare, vo haika arireka intemake, taaramo tataa veva vi oriva vaavi vainaini arute, ");
INSERT INTO tbg_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","viraqaahai tenta kaiqa vaiintiara oru veva rantakera nkaqu viri timiane tirerave. Te vira tiva ami tiha, Vevavano mainima vaivo. Vira vara viri timiane tiarera, are te iainanaini aniane. Noravano Kotiva ekaa enta qaqi variqiro vi vaira autuqaa te quqaama turo. Te minti tiarera, ti qova kiama ai qoraiqama amitaanarove. Are homa himpira aninarave. ");
INSERT INTO tbg_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Te tenta kaiqa vaiintiara, Vevavano vutunima vaivo tiarera, are himpira vonaini ruqema kera vuane. Are Noravano Kotivama ti titite vaivo tivakera vonaini vuane. ");
INSERT INTO tbg_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Ho tetanta Nora Kotira avuqaa vaiha uva tiva taatau taunarara ti, hauri tetanta vi uvara tauru kaarorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Ionataaniva minti tuvaro Devitiva naahoqi oru kukeqaviro vaura. Mini vauvaro vira qararaa King Soruva Qaraaka Torara kara nerara iriharo kara nareva unaini vura. ");
INSERT INTO tbg_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Viva naavuqi oriqetero nai mantaraini porovaa tataaqa oquviro vauvaro, Ionataaniva vira avuqaa nai mantaraini oquviro vauvaro, Apineva Sorura tataaqa oquviro vauvaro Devitiva oquviro vaunaini kia viva vauvaro qumina vatuka vaura. ");
INSERT INTO tbg_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Soruva tavovaro Devitiva kia vauvaro viva kia uva tiraitiro, qaqi nai aatoqi iriro tiharo, Nantivaroe Devitiva kia vaivo? Vo haikavano Devitira qoraiqama amitaivaroe Kotira avuqaa kia takuquvi vairaitiroe, kia anivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Ho vira qararaa vika qaiqaa ruvaaqumavi kara nareka iha tavovaro Devitiva oquvi vaunaini qaiqaa qumina vauvaro Soruva nai maaqu Ionataanirara tiharo, Oho, Iesira maaqu Devitiva nantiharoe entavata vatevata kia kara nareva anivo? tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Minti tuvaro Ionataaniva nai qora tiva amiro tiharo, Devitiva Betarihemini vire iharo ti maantima kero ti irairave: ");
INSERT INTO tbg_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Ti qata vakauka Nora Kotira ofaa iha quara amitareka iavaro, ti vakaava vovano tiriara uva vara kaivaro anivo. Are ti tontivano vairera, ti qaqi kairaqe te oru tenta qata vakaa tavaare, timanta te vira qaqi kauraro vivo. Devitiva mini vaiharoma kia aintiro ani kara naivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Minti tuvaro Sorura araravano Ionataanirara voqama kero itovaro virara tiharo, Oho, are hampi aaraqaahainaa nahenti maaquvanove. Te tavaurara are Iesira maaqu tontiqama kera vira mantaraini variaravave. Vira kaara are nena nokantira kaurira haikama varenarave. ");
INSERT INTO tbg_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Are kiae iriaro? Devitiva kia qutiraitiro, qaqi variqiro virera, are kiama ho avuhainaa vaiintiqama vira Isareriqaa raqikinarave. Ho are vaaka vaiinti vokiaka nititaira oru Devitira vite aniqe te vira aru kaare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Soruva minti tuvaro Ionataaniva aqao tiro, Devitiva nana qora okara autira kaarae are vira aru kareva auti variaro? tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Minti tuvaro Soruva Ionataanira arukaare tiro, nai vaantaara aqukovaro Ionataaniva ruhiti vuvaro kia vira arura. Ho Ionataanira aato kenko tuvaro iruvaro vira qova Devitira aru kaarira avu aatova kempukaiqiro vaura. ");
INSERT INTO tbg_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Mintima kovaro Ionataanira voqamakero arara itovaro viva himpiro kia kara naraitiro, vevantero viro. Qaraaka Torara iriha qaiqaa kara nareka u entava vauvaro Ionataaniva kia vi karara naraitiro, nai qova Devitira qoraiqama amitaainara kaara vira muntukavano qoraiquvaro vaura. ");
INSERT INTO tbg_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Vira qararaa toqaqi Ionataaniva himpiro vainti voru vita varero tota náitanta Devitika tuntema kero, naahoqi vura. ");
INSERT INTO tbg_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Ionataaniva vainti virauruara tiharo, Te veva vutuni aampaaqi taarirara are oru rantaane. Ho kantera vuane, tuvaro vi vaintiruva kantero vuvaro Ionataaniva veva vo aruvaro vainti vira ori aatarakero aruvura. ");
INSERT INTO tbg_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Vaintiruvano veva aruvunaini oruntovaro Ionataaniva vira aarero tiharo, Vevavano vutuntoqamama vaivo. Are voqavata ori vaiquane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Ionataaniva qaiqaa vi vaintirura aarero tiharo, Kantera vuane. Kia qumina viraqaa variane, tiro. Ionataaniva minti tuvaro vainti viva veva oru nkaqu varero qaiqaa Ionataaniva unaini aniro. ");
INSERT INTO tbg_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Vi vaintiruva Ionataaniva tu uvara okara kia kankoma kero iriraitiro vaumanta, Ionataanika Devitika náitantaqai vira okara irura. ");
INSERT INTO tbg_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Ho Ionataaniva huruvata vevavata vaintiru amiro tiharo, Varera vatukaini vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Tuvaro vainti viva vuvaro Devitiva ori hini mantaraini kukeqavi vauraqihairo Ionataaniva vaunaini anintero vira avuqaa taaramo tataa tori kauru araviro nai viri vataini kero, viraqaahairo himpiro Ionataanira utu varero nai kukuqe nai kukuqe ihatanta iqi rate vaura. Devitiva Ionataanirara iqi ratova Ionataaniva virara iqi ratoravata uri aatara kora. ");
INSERT INTO tbg_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Ho Ionataaniva Devitirara tiharo, Ho ai muntukavano qihaaqirara vuane. Noravano Kotiva vaiharo tavaimanta tetanta vira autuqaa tiha, Tetanta ekaa enta kia navutaiqiraiti koqemake variari, tetanta kuvuarama taarirauka vikavata mintima variqi vivarave, tunarave, tiro. Ionataaniva minti tivakero anirantero vatukaini vuvaro Devitiva vo vataini vura. ");
INSERT INTO tbg_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Devitiva Sorura aatu qetakero Nopi vatukaini Kotira kaiqa vara amite vau vaiintira Ahimerekira tavareva oruntovaro viva Devitira tavero aiqu kauqu ntiri ntiri i vauvaro vira irero tiharo, Oho, nantivarae are nenaraa aniaro? Nantimantae kia vaiinti vonavu ai hampata aniavo? tiro. ");
INSERT INTO tbg_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Ahimerekiva minti tuvaro Devitiva tiharo, Te avuhainaa vaiinti kaiqara irihama maini anuro. Avuhainaa vaiinti viva ti tititero tiharo, Kia vo vaiintivata tiva nimiraitira, evaara vi kaiqara varaane tivera, kia te virara ai tiva amirerave. Tenta iqoka vaiinti vikara vona ruvaaqumavi vaiha ti veka variate tunarave. ");
INSERT INTO tbg_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Devitiva minti tiva kero vi vaiintira irero tiharo, Are nana karae vataaro? Mpareti 5navu vatairera, ti timiane. Mpareti kia vatairera, vo kara timiane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Devitiva minti tuvaro viva tiharo, Te kiama qaqi qumina mpareti vataraiti, Kotira amitaa mparetiraqaima vatauro. Ai iqoka vaiinti vika nái nahenti hampata kia vaiteka vaivera, are homa vi mparetira varera vika niminarave. tiro. ");
INSERT INTO tbg_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Minti tuvaro Devitiva tiharo, Vika kia nahenti hampata vaitaakave. Vo enta vo enta vika navutaaka hampata raqirara iriha, vika nái ia haikara hampata takuquvi variavo. Vate tinavuqi vo qara i kaiqava qovaraiqimantara ti, tenavu anomake takuquvima vauro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Devitiva minti tuvaro kia vo kara vau varora tiro, viva Kotira amito mparetira aavataiqura varakero Devitira amura. (Vika mpareti Kotira Naavuqi vatora aavataiqura vara qaqini ke qaiqaa qaraaka vate vaura.) ");
INSERT INTO tbg_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Vi entara Sorura kaiqa vaiinti vo, Idomu vatanaava Doekiva vo kaiqa Kotira vara amitaainarara iriharo mini vaiharo ˻tavovaro Ahimerekiva mpareti vira varakero Devitira amura˼. Doekiva Sorura purumakauqaa raqiki vau vaiintika qiata vaiintivano vaura. ");
INSERT INTO tbg_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Ho Devitiva Ahimerekira qaiqaa irero tiharo, Are vaantaarave iqoka paipeve vokira vaterae, kiae vataaro? Avuhainaa vaiintivano ti vihi vaahi ti vaimanta te kia tenta auvihehavaa vararaiti, qaqi qumina anuraukave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Minti tuvaro Ahimerekiva vira tiva amiro tiharo, Pirisia vaiinti Golaiaatira, are Elaa Uqitakanta vaihara aru kaana vaiintira, vira iqoka paipeqaima maaqi vaivo. Tenavu tavunaqohai vira apuqamake efoti utavaaqa vira tauvaqaini vatauro. Are vira varaataa irera, homa varenarave. Kia vo auvihehavaavata maaqi vaivo, tiro. Minti tuvaro Devitiva tiharo, Vira nai voqaraa paipeve. Vira ti timiane, tura. ");
INSERT INTO tbg_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Ho vohaa vi entara Devitiva Sorura aatu ruqemakero King Akisiva Geti vatanaakaqaa raqiki vauva vaunaini oru ntora. ");
INSERT INTO tbg_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Oru ntovaro King Akisira kaiqa vaiinti vika Akisira tiva ami tiha, Ike, Devitiva maava Isareri avuhainaa vaiintivanove? Nahenti vika virara ihi nteha maantimake ihi tiarave: Soruva airi vaiinti aru kaivaro Devitiva viravata uri aatarakero nai airi vaiintima aru kaivo, tiarave, ti. ");
INSERT INTO tbg_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Vika minti tuvaro Devitiva vi uvara iriro tiharo, Oho, ˻te vira navunaaka airi aru kaunara kaara˼ King Akisiva ti haru kaantorave, tiva kero vira aatu voqama kero qete vaura. ");
INSERT INTO tbg_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Devitiva qeteharo avuhainaa vaiinti avuqaavata vira kaiqa vaiinti nivuqaavata vaiharo vuera vaiinti voqaantema kero vi ani vaura. Viva minti vaumanta avuhainaa vaiintivano nai kaiqa vaiinti hampata Devitira ravaaqavu karare tuvaro viva vuera vaiinti voqaantema kero, vaantaavura qentiqaa kakahiakara i vaiharo qaqi kovaro auvaantuvano vira noqihairo nteharo okauvau tuvi vaura. ");
INSERT INTO tbg_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Devitiva mintima kero unaqaraiqi vauvaro Akisiva vira tavero nai kaiqa vaiintiara tiharo, Tavaate. Maava vueraiqama vivo. Nantihae ne vira vita vare te unanaini aniavo? ");
INSERT INTO tbg_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Vueraiqama vuaka airitahaa maa vataraqaa variamanta ne nantihae vuera vaiinti vovata ti naavuqi vite aniavo? tiro. King Akisiva minti tiva kero Devitira qaqi kovaro vura. ");
INSERT INTO tbg_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Devitiva ruqemakero Geti vatuka mini kero Adulaamu vatuka aumanto aiqina vaunaini ori onavuqi oru vaura. Viva mini vaumanta vira vakaukavarave, vira navunaa vonavuve Devitiva mini vaivo tu uvara iri, vikavata vira hampata mini otu vaura. ");
INSERT INTO tbg_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Vaiinti vokuka vo maara vo maaraqi vaukave, airi dinauqi vaukave, vo haika kaara kia koqemake vaukave, vika vika 400vano Devitiva vaunaini oru vuvaro viva vika qiata vaiintiqama viro vaura. ");
INSERT INTO tbg_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Ho Devitiva mini varikero, viraqaahairo viva nai noka qoka ntita varero Misipaa vatuka Moapi vataini vura. Devitiva oruntero Moapi avuhainaa vaiintiara tiharo, Are qaqi kaira ti noka qoka ai hampata maini variqi vi vaiqe te vaiha tavaariraro Kotiva ti nana haikae autu timitaarire, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Devitiva minti tuvaro Moapi avuhainaa vaiinti viva hove tuvaro Devitiva nai noka qoka mini komanta vira hampata vauvaro Devitiva oru qaiqaa ori onavuqi kukeqa viro vaura. ");
INSERT INTO tbg_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Viva viraqi vauvaro paropeti vaiinti Gaativa Devitiva vaunaini oruntero virara tiharo, Are kia qaiqaavata ori onavu maaqi variane. Himpira Iutaa vataini vuane, tuvaro Devitiva viva tunte iro, Iutaini Heretive tu nantaraqi oru vaura. ");
INSERT INTO tbg_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Ho vo enta Soruva Gibea vatukaini oru aiqinaqaa nora katari okara oquvi vaiharo nai vaantaara kauquqi totatero vaura. Vira iqoka vaiinti vira ututumate vaumanta vaiinti vokuka Devitiva kukeqaviro vaurara vuru Sorura tiva amura. ");
INSERT INTO tbg_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Minti tiva amuvaro Soruva nai iqoka vaiintiara tiharo, Ne Benaminira ankuqirauka koqemake iriate. Ne iri tiha, Devitiva noraiqama viro, viva qaqi naahovata uaini naahovata tinavu timianarove tiarave. Quqaae Devitiva ni vohaiqa vohaiqa noraiqama kaira ne 1,000 iqoka vaiintive, 100 iqoka vaiintiqaave, raqikivarave? ");
INSERT INTO tbg_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Ne virara virara irihae ti qoraiqama timite uvara ti variavo? Oho, ne kia tiriara noraiqaake iriavo. Kia niqihairo vovano ti maaquvano Devitikantiro uva tiva taatau kairara ti tiva timirave. Kia niqihairo vovanovata ti tiva timiro tiharo, Ai maaquvano Devitira vihi ti vaivaro viva kukeqavi vaiharo ai arukaina aarara rante vaivo tirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Soruva minti tuvaro vi entara Idomu vatanaa vaiinti Doekiva Sorura iqoka vaiinti hampata himpi vaiharo Sorurara tiharo, Te Nopini vaiha tavauraro Devitiva Ahitupira maaqu Ahimerekiva vainaini oruntairave. ");
INSERT INTO tbg_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ahimerekiva Devitirara iriharo Nora Kotira aarama amitero, viraqaahairo karavata Golaiaatira iqoka paipevata Devitira amirave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Doekiva minti tuvaro King Soruva vaiinti vokuka nititomanta vika Nopini orunte Ahimerekiravata, ekaa Ahimerekira anku Nopini vaiha Kotira kaiqa vara amite vau vaiintikavata, ntita vare Soruva vaunaini anura. ");
INSERT INTO tbg_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Vika ntita vare Soruva vaunaini viri kovaro Soruva Ahimerekirara tiharo, Te tiarirara iriane, tuvaro Ahimerekiva tiharo, Nora vaiintivauvo, ho tiraqe iriare, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Ahimerekiva minti tuvaro Soruva vira irero tiharo, Nana kaarae are Devitikantira ti qoraiqama timitena uvara tiva taatau taaro? Are Devitira karavata iqoka paipevata amira, virara Nora Kotira aarama amitaanarave. Are minti tianara kaara vate Devitiva ti navutaiqiharo ti haru kareva auti vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Soruva minti tuvaro Ahimerekiva aqao tiro, Ai iqoka vaiintiqihairo Devitiva avuni vaiharo ariara kempukaiqaa kero iri vaivama vaivo. Viva ai airaamaquvano vaiharo ai iqoka vaiinti vokiaka qiata vaiintivano vaiharo koqema kero ariqaa raqiki vaivama vaivo. Ekaa ai naavuqi variaka Devitiva koqe kaiqa varairara irihama vira nora autu ami variarave. ");
INSERT INTO tbg_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Quqaama te Kotira ireha Devitira uva tiva amiane tunarave. Te haaruvata vohaa enta vohaa enta mintunarave. Mpo, avuhainaa vaiintio, are kia tiqaavata ti ankuqaavata uva vataane. Tenavu kiama ai qoraiqama amitaaina uvara tiva taatau taunarave. Te kia iri tavauna haikarara are ti variaro, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Viva minti tuvaro King Soruva tiharo, Qaqira kaane. Kia te ai uva irirerave. Are nena anku hampata qutinarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","King Soruva minti tivakero iqoka vaiintinavu vira tataaqa vaiha viraqaa maimaraara raqiki vauka tiva nimiro tiharo, Ne Nora Kotira kaiqa vara amite variaka, maaka aru kaate. Vika Devitiva ruqema kero vurara iri tavevata, kia ti viri tiva timiarave. Vika Devitira mantaraini varia vaiintikama variavo, tiro. Soruva Nora Kotira kaiqa vara amite vauka aru kaate tumanta iqoka vaiinti vika aqao ti, Hauri tenavu Nora Kotira kaiqa vara amite variaka arukaarorave tivake kia vika arukaataa umanta qaqi vaura. ");
INSERT INTO tbg_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Mintuvaro Soruva Doekira tiva amiro tiharo, Arema vika aru kaane, tuvaro Doekiva Soruva tuntema kero, oru Kotira kaiqa vara amite vau vaiintika 85navu aru taiqa kora. Vi vaiintika efoti tavuna rumpateha Kotira kaiqa vara amitoka aru kora. ");
INSERT INTO tbg_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Doekiva vika arukovaro viraqaahairo Soruva nai iqoka vaiinti nititomanta vika Kotira kaiqa vara amite vau vaiintika vaunaini Nopini orunte, vaiintive, nahentive, vaintive, naama ne vaukave, purumakauve, sipisipive, donkive, ekaa aru taiqa kora. ");
INSERT INTO tbg_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Vika Nopihainaaka ekaa arukehavata, Ahimerekira maaqu vo Abiataaraqai kia arukora. Abiataava ruqema kero viro, Devitiva vaunaini oruntero, vira iqoka vaiinti hampata vohaaraqi vaura. ");
INSERT INTO tbg_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Soruva nai iqoka vaiintinavu nititomanta vika orunte Nora Kotira kaiqa vara amite vauka aruko uvara Abiataava Devitira tiva amuvaro ");
INSERT INTO tbg_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Devitiva tiharo, Oho, te ai qokanti uva ti vauna entara Doekivavata vairave. Ho te tiha, Quqaama vi entara Doekiva titanta uva iriro, vuru Sorura tiva amivo, turo. Mpo, ti okara kaarama Soruva ai anku ekaa aru taiqa kaivo. ");
INSERT INTO tbg_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Viva mintira kaara kiama qetaane. Soruva aivata tivata arukareva auti vaivo. Are ti hampata vairaqe te ariqaa raqiki variarirara are homa vainarave, tiro. Devitiva minti tura. ");
INSERT INTO tbg_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Ho Devitiva mini vaumanta vokuka vuru Devitira tiva ami tiha, Pirisia vika Keiraqi variaka hampata iqoka raqi variavo. Keiraqihainaaka uiti qantu vare vuru vo naavu vo naavuqi vataara, vika iqoka raqiha vi karara vare variavo, ti. ");
INSERT INTO tbg_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Devitiva vika tu uvara iriro Nora Kotira irero tiharo, Hoe te otu Pirisia hampata raquainarave, kiae ho raquainarave? tuvaro Noravano Kotiva Devitira nai tiva amiro tiharo, Hove. Are otu Pirisia hampata raqihara, Keiraqi varia vaiinti nahentika ruaruama nimitaane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Noravano Kotiva minti tumanta Devitira hampata vau vaiintika aqao ti, Vate tenavu maini Iutaini vaiha Sorura aatu qeteha vauro. Oho, tenavu Keiraini otu Pirisia iqoka vaiinti hampata raquainarara voqamake qeteha vauro, ti. ");
INSERT INTO tbg_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Vika minti tuvaro Devitiva qaiqaa Nora Kotira irovaro Noravano Kotiva Devitira nai tiva amiro tiharo, Ne himpi Keiraini otunte Pirisia vika ntaihaate. Te ni kahaqiari ne vika homa naatara kevarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Noravano Kotiva hove tuvarora tiro, Devitiva nai iqoka vaiinti ntita varero Keiraini otu ntero Pirisia hampata raqiharo Keiraqi vauka ruaruama nimitora. Devitiva nai iqoka vaiinti hampata Pirisia vika airitahaa aru kero vika purumakauvata varora. ");
INSERT INTO tbg_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Ahimerekira maaqu Abiataava Devitiva vaunaini ruqema kero vuva, vivavata Devitira vataakero Keiraini vura. Viva viharoma efoti tavunavata varero vura. ");
INSERT INTO tbg_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Ho Devitiva Keiraqi vaumanta vo vaiintinavu vuru Sorura tiva amuvaro Soruva tiharo, Ho Kotiva vira ti kauquqi kaanarove. Vaantaavuravano vi vatukara ututumatero vaivaro vaantaavura qentivanovata mini vairara tiro, Devitiva viraqi vaiharo karapuhiqi voqaarama vaivo, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Minti tiva kero Soruva nai iqoka vaiinti naaramakero vika hampata Keiraini otu Devitiva nai vaiintinavu hampata vau vatukara ututuma tareva vura. ");
INSERT INTO tbg_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Mini vireva vuvaro Devitiva vi uvara iriro Kotira kaiqa vara amite vau vaiintira Abiataarara tiharo, Efoti tavuna vare aniane, tuvaro ");
INSERT INTO tbg_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Abiataava vira vare anuvaro Devitiva Kotira aarero tiharo, Noravauvo, are tinavu Isareri Variqavano variaramanta te ai kaiqa vaiintivanoma vauro. Mpo, te iruraro Soruva ti kaara maaqi variaka vehi autu kaaina avu aatora utiharo maini tuvivo. ");
INSERT INTO tbg_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Keira vatuka maaqi varia vaiinti nahentika vika ti Sorura kauquqi kevarave, kiae kevarave? Soruva maini tuvuaina uvava quqaae vaivo? Noravauvo, are tinavu Isareri Variqavanove. Te ai iraaina uvara ti tiva timiane, tuvaro Noravano Kotiva vira tiva amiro tiharo, Eo, viva tuvuanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Minti tuvaro Devitiva qaiqaa Nora Kotira irero tiharo, Keira vika ti tinta vaiintinavu hampata Sorura kauquqi vatevarave, kiae vatevarave? tuvaro Noravano Kotiva tiharo, Vika mintima ivarave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Noravano Kotiva minti tuvaro Devitiva vi uvara iriro vaaka nai iqoka vaiinti 600navu ekaa ntita varero Keira vatuka mini kero ruqema kero vona vona vura. Soruva Devitiva vu uvara iriro, qaqira kero kia Keiraini vura. ");
INSERT INTO tbg_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Devitiva ruqema kero viro, Sifi vatuka hini mantaraini aiqinaini oru vaura. Mini nora orivanovata vaunaini vauvaro Devitiva koqema kero kukeqaviro vauvaro Soruva Devitira aru karare tiro, vo enta vo enta vira rante vauvaro Kotiva kia Sorura qaqi kovaro Devitira ranta kora. ");
INSERT INTO tbg_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Ho vo enta Devitiva Sifi vatuka aumanto Horesive tunaini vaiharo iruvaro Soruva Devitira rantakero arukaare tiro, Sifi vatukaini vireva auti vaura. ");
INSERT INTO tbg_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Devitiva qihaaqira muntuka varaarire tiro, Ionataaniva oru virara tiharo, Kotiraraqai kempukaiqama kera iriqira vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","Minti tivakero viva tiharo, Mpo, are kia qetaane. Ti qova Soruva kiama ho ai ranta kero ai qoraiqama amitaanarove. Naantiara arema Isareri avuhainaa vaiintivano vairaqe te ai naantiaraini vairarave. Ti qovavata vi uvarara iri tavairave, tura. ");
INSERT INTO tbg_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Tivakero Nora Kotira avuqaa vitanta náitanta vohaana tampamavi vaire tu uvara qaiqaa tiva taatau tora. Vitanta uva tiva taiqake Ionataaniva nai maaqaini vuvaro Devitiva Horesini vaura. ");
INSERT INTO tbg_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Ho Sifihainaaka vokuka oru Soruva Gibea vatukaini vaunaini orunte virara tiha, Devitiva tinavu maaqa Iutaa sauti mantaraini Hakila Aiqina Horesinima kukeqaviro vaivo. ");
INSERT INTO tbg_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Avuhainaao, are tairentae mini aniataa irera, aniraqe tenavu vira ravaaqavuke ai amiare, ti. ");
INSERT INTO tbg_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Vika minti tuvaro Soruva vika tiva nimiro tiharo, Hove. Ne tiriara noraiqaake iriarara tiro, Noravano Kotiva ni koqema nimitaarire. ");
INSERT INTO tbg_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Vo kiaka tiha, Devitiva avu aato vataa vaiintivano vaimantara ti, ne kia ho vira vaaka ranta kevarave, tiamanta irunarave. Ho ne anirante oru qaiqaavata kankomake viva vaina vatukara tave, vira tave vaiintikavata kankomake tavaate. ");
INSERT INTO tbg_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Ho viva voqi voqi kukeqaviro variainara, ne viravata rantake tave, vaakama kante viri ti tiva timiqe te ni hampata orunte tavaare. Oho, viva vi mantaraini vairera, te homa vira ranta kararave. Viva kia mini vairera, te ekaa Iutaini vi aniha vira rantarerave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Soruva minti tumanta Sifihainaaka anirante vika naane nái maaqaini vura. Vika orunte tavovaro Devitiva nai iqoka vaiinti hampata Iutaa hini mantaraini Maoni Aahara Vataini vaura. ");
INSERT INTO tbg_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Devitiva mini vau uvara Soruva iriro, nai iqoka vaiinti ntita varero vira rantareva vumanta vokuka Devitira vuru tiva amuvaro Devitiva Maonini orivano kirikairiro vaunaini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Mini vauvaro Soruva nai iqoka vaiinti hampata vi aiqinara hini mantaraini Devitirara rante vauvaro Devitiva Sorura aatu qetakero aiqina hini mantaraini nai iqoka vaiinti hampata kantama vura. Ho Soruva nai iqoka vaiinti hampata oru aumakaa Devitira nai iqoka vaiinti hampata ravaaqavu karare tuvaro ");
INSERT INTO tbg_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","vo vaiintivano anintero Sorura tiva amiro tiharo, Oho, Pirisia vika ai navunaaka hampata raqirekama aniavo. Are kantera anirantera vuane, tiro. ");
INSERT INTO tbg_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Viva minti tuvaro Soruva vi uvara iriro kia qaiqaa Devitira avataqiro viraitiro, anirantero Pirisia hampata raqireva vura. Soruva qaqirakero vi aiqinaraqaahairo vurara ti, maa entara vi aiqinara autu nteha, Sela-Ha-Maklekotive – Qaqirakero-Vu-Orirave, ti variara. ");
INSERT INTO tbg_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Ho Devitiva mini vaura kero oru Eni-Gedi vataini vaiintivano koqemake kukeqavi vaunaini vura. ");
INSERT INTO tbg_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Soruva Pirisia ntata vuru kero orurantero ani vaumanta vokuka Sorura tiva ami tiha, Devitiva Eni-Gedi Aahara Vatave tianainima vaivo, tura. ");
INSERT INTO tbg_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Vika minti tuvaro Soruva Isareri iqoka vaiintiqihairo kempuka vaiinti 3,000navu kaama tero ntita varero Devitira nai vaiintivara hampata rantareva Qaakau-Memera-Onkaiqive tura aumanto vura. ");
INSERT INTO tbg_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Soruva oruntovaro ori onavu vovano aiqina vira vevaqi aara aumanto vauvaro sipisipi ohaavata mini vaura. Ho Soruva raha tareva onavuqi oriqetero, viva Devitiva nai vaiinti hampata onavu tauvaqaini kukeqavi vaura kia tavora. ");
INSERT INTO tbg_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Ho viraqi vauka Sorura tave Devitirara tiha, Ho tavaane. Haaru Noravano Kotiva ariara minti tirave: Te ai navutaara ai kauquqi kaarirara are nana okara autuataa inara homa viraqaa autinarave, tirave. Vate vi entavama anintaivo. Ho vaaka vuane, tuvaro Devitiva qako qakomaqiro Soruva vaunaini oruntero, vira tavuna hini viti toqa varovaro Soruva kia virara iri tavora. ");
INSERT INTO tbg_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Devitiva Sorura tavuna toqa varero viraqaahairo viva tiharo, Oho, te kia mintiataarave, tivakero ");
INSERT INTO tbg_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","nai vaiintivara vaunaini oruntero vikara tiharo, Mpo, Noravano Kotiva kia ti qaqi kairaqe te tenta avuhainaa vaiinti qoraiqama amitaare. Viva avuhainaa vaiinti variarire tiro, Noravano Kotiva vira kaama tairara ti, hauri te viva kaama tai vaiintira qoraiqama amitaarorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Devitiva minti tivakero nai iqoka vaiinti nitiharo qioqama komanta kia Sorura arukora. Mintuvaro Soruva viraqihairo himpiro vevantero vura. ");
INSERT INTO tbg_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Viva vuvaro Devitiva onavuqihairo Sorura naantiara vevantero vira aarero tiharo, Nora vaiinti ti avuhainaao, tuvaro Soruva tuqantaa viro tavovaro Devitiva vira avuqaa kankakaama viro nai viri vatainiqama kora. ");
INSERT INTO tbg_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Viva Sorurara tiharo, Mpo, are nantiharae vo kiaka tiriara viva ai qoraiqama kareva auti vaivo tia uvara iri variaro? ");
INSERT INTO tbg_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ho tavaane. Vate are onavuqi variararo Noravano Kotiva ai ti kauquqi kaimanta ti iqoka vaiinti hini kiaka ti vihi tiha, Ho vira arukaane tiamantavata, te kia ai arukaraiti, qaqi vehakuma amitauro. Te tiha, Hauri te tenta nora vaiinti Noravano Kotiva kaama taira arukaarorave, tivake kia ai arukauro. ");
INSERT INTO tbg_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Ti qo, te ai tavuna viti tenta kauquqi tuataunara tavaane. Te ai vaataqaahai vira toqa varevata, kia ai arukaunarave. Ho are kankoma kera iriane. Te kia qora kaiqa ai autu amitaraiti, kia ai qoraiqama amitaunarave. Minti vauraravata, are quminama ti haru kareva rante variaro. ");
INSERT INTO tbg_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Ho Noravano Kotiva naima titanta raira kero tavairaro ariqie qora okaravano vaivo, tiqie qora okaravano vaivo tianarove. Are ti qoraiqama timitaanara kaara Noravano Kotiva naima tiqaa muntu kaarire. Hauri te tenta kauquqohai ai qoraiqama amitaarorave. ");
INSERT INTO tbg_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Maa uvara haaru tivatora iriane: Qora vaiinti vikaqihairo vaaqu kaiqavano qovarama vi vairave, turave. Te qora vaiinti vaihavauve, ai qoraiqama amitararave. ");
INSERT INTO tbg_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Are tinavu Isareri avuhainaa vaiintivano ta vaiintira ravaaqavu karevae auti variaro? Are ti arukarevae ti avataqira ni variaro? Te nantima vauraukae vauro? Te vairera, qutuvi vairirave, qumina taruve, voqaarama vauro. ");
INSERT INTO tbg_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Ho Noravano Kotiva naima titantaqihairo raira kero tavairaro tiqie aiqie qora okaravano vaivo tianarove. Viva ti auta ntiharo viva tiriara kia viraqi qora okaravano vaivo tianarove. Viva minti tivakeharoma ti ai kauquqihairo ruaruama timitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Devitiva minti tuvaro Soruva vira irero tiharo, Mpo, Devitio, ti maaquo, aree tiriara minti ti variaro? tiva kero iqi rate vaura. ");
INSERT INTO tbg_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Viva Devitirara tiharo, Arema koqe vaiintivano variaramanta tema qora vaiintivano vauro. Are ti koqema timite variaramanta te ai qoraiqama amite vaunarave. ");
INSERT INTO tbg_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Mpo, vate are ti koqema timitaanarara tiaramanta te iruro. Quqaama, Noravano Kotiva ti ai kauquqi kaivara are kia ti haru karaitira, ti koqema timitaaro. ");
INSERT INTO tbg_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Te irunarave. Vo vaiintivano nai navutaara qoraiqama amitareva iharo, viva kiama ho vira qaqi kairaro vuanarove. Mpo, are ti koqema timitaanarara iriharoma Noravano Kotiva ai koqema amitaarire. ");
INSERT INTO tbg_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Ho te vate kankomake iri tavaurara are naantiara Isareri avuhainaa vaiintiqama vira, vikaqaa koqema kera raqikiqira vi vairamanta vika koqemake variqi vivarave. ");
INSERT INTO tbg_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Are Nora Kotira autuqaa mintima iane: Naantiara avuhainaa vaiintivano vaihara kiama ti anku vaiinti nahenti ntaihama kaane. Hauri are vika arukairaro ti hutuvanovata vika nutuvanovata ekaara taiqa vuantorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Soruva minti tuvaro Devitiva Nora Kotira autuqaa te mintima ianarave tuvaro Soruva anirantero nai maaqaini vuvaro Devitiva nai iqoka vaiinti hampata anirantero nái kukeqavi vau aiqinaraqi vura. ");
INSERT INTO tbg_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Samueriva qutu vumanta ekaa Isareri vika ani ruvaaqumavi vaiha virara iqi rata amitora. Vika virara iqi rata amite, nai maaqa Ramaini vira quntama tora. Ho vo entanavu aitarovaro Devitiva nai iqoka vaiintinavu ntita varero Paraani Aahara Vataini oru vaura. ");
INSERT INTO tbg_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","Maoni vatukaihainaa vaiinti vo Nabaarirave – Kia-Avu-Aato-Vataarave tu vaiintiva vaura. Viva Kalepira vohaa ankuvano vauvaro vira vatavano Kaameli nora vatuka aumanto vaura. Nabaariva airi airaira vato vaiintiva vaiharo sipisipi 3,000 vatero, memeraa 1,000 vatora. Vira naata Avikeriva koqe avu aato vataava vauvaro vira viri vaatavanovata koqe iro vaura. Mintima vauvarovata, vira vaati Nabaariva voqama kero vaiinti niti vau vaiintiva vaiharo nai airaira kampaiqama kero tuate vauva vaura. ");
INSERT INTO tbg_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Ho Devitiva aahara vataini vaiharo iruvaro Nabaariva Kaameli vataini vaiharo nai kaiqa vaiinti hampata sipisipi kaahi teqe vauvaro ");
INSERT INTO tbg_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Devitiva vaiinti 10navu nititero tiharo, Nenavu Kaamelini otunte ti hutu nteha Nabaarira uva mantama timitaate, tiro. ");
INSERT INTO tbg_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","Minti tivakero viva tiharo, Nenavu vira tiva ami tiha, Devitiva ariara mintima tivo: Arevata ai vaiinti nahentivata koqemake vaiqe te hove tiataarave. ");
INSERT INTO tbg_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Ne maa entara sipisipi kaahi teqe variarara vokiaka tiamanta te irunarave. Ai sipisipiqaa raqikia vaiintika maini Kaamelini tinavu hampata variamanta tenavu kia vika qoraiqama nimitaraiti, vika airaira kia voqavata muara varaunarave. ");
INSERT INTO tbg_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Are nena kaiqa vaiinti irairamanta vikavata vohaa uvaqaima tivarave. Ho virara irihara are te qaraaka vaiintinavu nititaurauka quahama nimitehara vinavukavata, ti nena maaqu Devitikavata, hoe kara vatenara tinavu timinarave? turo, tiro. Devitiva minti tiate tivakero vi vaiintinavuka nititomanta ");
INSERT INTO tbg_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","vinavuka Nabaariva vaunaini otunte Devitiva tu uvara Nabaarira tiva ami vira veka vaura. ");
INSERT INTO tbg_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Devitiva nitito vaiintika Nabaarira veka vauvaro viva vinavukara aqao tiro, Devitiva nai ta vaiintivave? Iesira maaqu viva ta vaiintivave? Kia te vira tavaunarave. Vate maa entara airi kaiqa vaiinti nái nora vaiinti aatu ruqemake vuavaro vivavata ruqema kero virave. ");
INSERT INTO tbg_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Hauri te tenta kara, mparetive, namarive, mative, tenta kaiqa vaiinti nimirera iainara varake, kia tavauna vaiintika nai taihai aniaka qumina nimiarorave, tiro. ");
INSERT INTO tbg_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Nabaariva minti tumanta Devitiva nitito vaiintika tuvurante vuru ekaa viva tu uvara Devitira tiva amura. ");
INSERT INTO tbg_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Vira tiva amuvaro viva tiharo, Oho, ne ekaa iqoka paipe qera iate, tumanta vika Devitiva tuntemake, qerama tovaro Devitiva naivata iqoka paipe taaqeni rumpa varero nai iqoka vaiinti 400navu ntita varero viharo 200navu nái airairaqaa raqikiate tiro mini kora. ");
INSERT INTO tbg_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Mintuvaro Nabaarira kaiqa vaiinti vovano vuru vira naata Avikerira tiva amiro tiharo, Devitiva aahara vataini vaiharo nai vaiinti vokiaka nititaimanta vika tuvu tinavu nora vaiinti uva mantaavaro viva kia vika quahama nimitaraitiro, vikara qora uvaqaima tivo. ");
INSERT INTO tbg_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Ho tenavu sipisipiqaa raqiki vauna entara vi vaiintika kia tinavu qoraiqama timitaraiti, vika tinavu koqe okara autu timiteha kia tenavu una haikara vo haikavata muara varaarave. ");
INSERT INTO tbg_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Tenavu mini vaiha entaqive, aatitairaqaave, sipisipiqaa raqiki vauramanta Devitira vaiinti vika tinavuqaa raqikiha koqemake antua timite variarave. ");
INSERT INTO tbg_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Mpo, Avikerio, vatema Devitiva nai iqoka vaiinti hampata tuvu tinavu nora vaiinti qoraiqama amitero, ekaa vira hampata vaurauka tinavuvata qoraiqama timitaanarove. Viva mintiantorave tira, are koqema kera avu aato utukera vo aara ranta kairaro vi maarava kia tinavuqaa qovaraiqiarire. Nabaariva nai qora vaiintivano vaiharora tiro, viva kia tenavu tiaina uvara ho irianarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Viva minti tuvaro Avikeriva vaakama mpareti 200navu vara vatero, memeraa pahiqi uaini kaqatora taaraqanta vara vatero, sipisipi 5navu untatora vara vatero, uiti untatora 20 kilo vaura vara vatero, uaini tava aaharaiqamake taatautora 100 navu vara vatero, fiki tava aaharaiqamake taatautora 200navu vara vatero, ekaa vi karara donkinavu tauvaqaqaa vara vaari vatora. ");
INSERT INTO tbg_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Vatero viraqaahairo nai kaiqa vaiinti tiva nimiro tiharo, Nenavu vare avuni vi vaiqe te ninavu naantiaraini vuare, tiro. Minti tivakero Avikeriva kiama nai vaati Nabaarira tiva amiraitiro qaqi viro. ");
INSERT INTO tbg_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Viva donkiqaa oquviro Devitira rantareva aaraini viviro, aiqina muaqentuna oruntero tavovaro Devitiva nai iqoka vaiinti hampata vihairo tuvuvaro Avikeriva vika ntita kora. ");
INSERT INTO tbg_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Devitiva tuviharo nai aatoqi mintimama iriro: Te aahara vataini vaiha viva i haikara koqemake raqiki amiteha, kia tenavu vira airaira voqavata muara varaunarave. Te mintima amitaurarovata, vi vaiintiva ti qoraiqama timitaivo. Oho, te qumina viva i haikara raqiki amitaunarave. ");
INSERT INTO tbg_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Mintiverama te vate entaqiqai vi vaiintira nai kaiqa vaiinti hampata aru taiqa kaariraro toqaqi kia voqavanovata qaqi variarire. Te kia mintiarera, Kotiva homa ti qoraiqama timitaanarove, tiro. ");
INSERT INTO tbg_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Devitiva minti tiva kero aaraini tuvi vauvaro Avikeriva Devitira tavero vaakama donkiqaahairo vataini vaavintero Devitira avuqaa hiqintiviro vaura. ");
INSERT INTO tbg_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Viva Devitira aiquqi vaiharo virara tiharo, Mpo, nora vaiintio, are qaqi kairaqe te ai kaiqa nahentivano uva tiare. Mpo, te tiarirara iriane. Are ekaa Nabaarira uva tiqaaqai vataane. ");
INSERT INTO tbg_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Viva qora vaiintivano vaivo. Are kia virara noraiqaa kera iriane. Viva nai autu Nabaarira – Kia-Avu-Aato-Vataara aanantero, kia avu aato vataava vaiharo hampi kaiqaqai vare vaivama vaivo. Mpo, nora vaiintio, are nititaana vaiintika te kiama tavaunarave. ˻Te vinavuka tavauraitirio, te vika kara nimuraitirio.˼ ");
INSERT INTO tbg_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Hauri are Nabaarira qora okara kaara nai kaiqa vaiinti hampata vika aru taiqa kerorave tiro, Noravano Kotivama ai ravaaqavu kaivo. Ho te Nora Kotira avuqaavata ai avuqaavata vaiha