﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbg_a_vpl;
CREATE TABLE tbg_a_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbg_a_vpl WRITE;
INSERT INTO tbg_a_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Haau hoqareo Vaiqavano Kotiva naauavata vakavaka auku seo vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Aukuseo vakovo haau vi entaa vakavano vaieva hampiqama vio vaihao qumina vakaqai vauvo sa vo ahasavanovaka vauvo sonkira aru ahasavaqai noa namai ventaqaara mantaaqa sovo vaua. Vi entaa vakavano minkima vauvo Kotia Maraquavano noa namai ventaqaara ruvauvau ihao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kotiva minkima kio: Aakikaane, kuvo Kotiva kunte io aakika vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kotiva aakikoa kavovo soqe io vauvo raira sehao aakikoa voqaa vakeo sonkiraiqua voqaa vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kotiva aakikoaa auku ntehao, Isarama ivo, kivaseo sonkiraiquaa auku ntehao, Entaqive, kua. Entamaqio vivio aakika vuvo vi entava hoqarenaa enta kaiqa vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Vi entaa konavuvanovaka mamanavuvanovaka noa namaiqaa qapuqio vauvo Kotiva kihao, Ruqema via viini oiniao noa namaivano miani variao avukana qaqi variaie, kio. Minki kuvo Kotiva kunte io konavuvanovaka mamanavuvanovaka noa namaiqaahairo ruqema vio viini oini vauvo noa namaivano miani vauvo avukana qaqi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kotiva qaqi vaua auku ntehao, Naauave, kua. Entamaqio vivio aakika vuvo vi entava kaara enta kaiqa vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Via qararaa Kotiva kihao, Noa namai miani vaiava vohaanaini okiniao aahara vakavano qovaama vio vaiaie, kio. Minki kuvo Kotiva kunte io namaivano vohaanaini okinuvo aahara vakavano qovaama vio vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kotiva aahara vaka auku ntehao, Vakave, kivaseo namaivano vohaanaini oku vaua auku ntehao, Noa namaive, kua. Kotiva kavovo nai auku seo vako ahasava soqe io vaura. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Minkima soqe io vauvo viaqaankaio Kotiva kihao, Vakavano vaiao viaqinkaio vo ahasa vo ahasavano qampiqaaiava qovaama variaie. Vo usau vo usauvano kava iraaiavavaka, vo sakai vo sakaivano kava iraaiavavaka qovaa ianarove, kuvo Kotiva kunte io vi ahasava vi ahasava qovaama vio vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Vakaqinkaio qampiqe vau ahasava qampiqoa. Vo usau vo usauvano kava irehao sa hampi kava iraraio, nai kavaqai iraqio vi vauvo vo sakai vo sakaivanovaka kava irehao nai kavaqai iraqio vi vaua. Minkimaqio vi vauvo Kotiva kavovo soqe io vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Entamaqio vivio aakika vuvo vi entava kaaramo enta kaiqa vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Via qararaa Kotiva kihao, Naauaini ikaa ia ahasava vo ahasa vo ahasavano qovaama via hini ahasavano entaqia ikaaia ahasava vaiao hini ahasavano aakikaainaaqaa ikaaia ahasava variaie. Vi ahasava vi ahasava vaihao ntara uki entaave, ntara qantu ne entaave, koa ikaqio vio vuu kaiqaaina entaave, ihi kaiqaaina entaave, numiqaqio vuanaove. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Vi ahasava vi ahasava naauaini vii ntaka ikaqio vihao vakaini aakika nimikaanarove, kio. Minki kuvo Kotiva kunte io aakikehao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kotiva aakikaaina ahasaa noa kaaraqanta auku seo vakoa. suaivano aakikaainaaqaa ikaqio vuaie kio, auku seo vakeo koravano entaqia ikaqio vuaie kio, auku seo vakoa. Kotiva vikanta auku seo vakeo masauve, ovuroave, vahoquave, auku seo vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kotiva vi ahasava vi ahasava vakaini aakika nimikaqi vuaie kio, naauaini auku seo vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Vi ahasava vi ahasava aakikaainaaqaavaka entaqivaka ikaqi vuaie kio, naauaini vi ahasaa auku seo vakoa. Sonkiraiqiava nariaraa vaiao aakikaaiava nariaraa variaie kio, Kotiva vi ahasaa vi ahasaa auku seo naauaini vakoa. Kotiva kavovo nai auku seo vako ahasava soqe io vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Entamaqio vivio aakika vuvo vi entava kaaraqanta kaaraqanta enta kaiqa vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Via qararaa Kotiva kihao, Vo ahasa vo ahasa qaqi vaiqio vuaia ahasava noa namaiqi vi aniha mpiqaake. Vo uvii vo uviivano aka vare vi aniha naauainivaka mpiqaake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Minki kivaseo Kotiva noa aantauvahi noa namaiqi ni ahasaa auku seo aiqava vi ahasava namaiqi qaqi vaiqio vuaina ahasaave, nana nana ahasa qasiaina ahasaave, vo ahasa vo ahasa auku seo vakeo, viaqaankaio vo aantau vo aantau aarosa vakaa aantauaqai auku seo vakeo. Auku seo vakeo Kotiva kavovo nai auku seo vako ahasava soqe io vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kotiva vi ahasaa vi ahasaa soqema nimikeo kihao, Ne namaiqi vai aantausa suvuaramaqi vivo airiqihao namaiqi mpiqaaie. Ne uviivanovaka suvuaramaqi vivo airiqiaie, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Entamaqio vivio aakika vuvo vi entava sauqu hiniu enta kaiqa vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Via qararaa Kotiva kihao, Vakaqaa vo aantau vo aantauvano qaqi vaiqio vihao nuaie. Suvu vake aantauave, qaasau aantauve, koventive, memauve, aiqava aantauvahivano vo aantau vo aantauvano vakaqaa nuaie, kio. Minki kuvo Kotiva kunte io vi ahasava vi ahasava qovaama vio vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kotiva qaasau aantau, vo aantau vo aantau auku seo, suvu vako aantaua, vo aantau vo aantauvaka auku seo, memauve koventive vo ahasa vo ahasavaka auku seo, vakoa. Kotiva kavovo nai auku seo vako ahasava soqe io vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Minkima vauvo Kotiva kihao, saiqe kenkanavu voqaama vaiinki auku saaiao vi vaiinkiva vaihao noa namaiqi vaina hampusaqaave, naauaini akaqi ni vaina uviiaqaave, vakaini suvu vaina aantauaqaave, qaasau aantauqaave, aiqava vi aantaua vi aantauaqaa raqisiaie, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Minki kivaseo Kotiva vaiinki via nai voqaama auku seo. Kotiva nai voqaama qorainkivaka nahentivaka auku seo vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kotiva vikantaa quahama nimikeo kihao, Nekanta vaihama vainki suvuaramaqi vivo airiqihama nikanta vainkiqaima vakamaaka mpiqa saake. Ke nikanta noaiqama saai noa namaiqi vai hampusaqaave, naauaini aka vareo nina uviiaqaave, aiqava vakaqaa vaina aantauaqaave, nekanta visaqaa raqisiqi vuake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kotiva minki kivaseo qaiqaa kihao, Aiqava ahasavano iraaina kavaave, aiqava sakaivano iraaina kavaave, ke vi ahasaa nikanta nimiaio nikanta ntaraqaima varianarove. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Aiqava aantauvahivano vakaqaa vaiavave, aiqava aantauvano naauaini vaiavave, aiqava memau koventivano vakaqaa vaiavave, visa ntara vaieva aiqava sakai mareve usauve vusanaa vainaa, vi ahasaa vi ahasaa visa ntarama varianarove, kio. Minki kuvo Kotiva kunte io vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kotiva aiqava ahasa nai auku seo vako ahasaa kavovo voqama seo soqe io vaua. Entamaqio vivio aakika vuvo vi entava sauqu hiniu io hini sauquni vohaiqa enta kaiqa vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Minkuma seo Kotiva naauavata vakavaka aiqava ahasavaka auku vuu kaiqa soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kotiva sauqu hiniu io hini sauquni vohaiqa enta saiqa vaaqio vihao aiqava ahasa auku vuu kaiqa seo. Vuu kaiqa seoa kio, via qararaa 7 entaqaa sa saiqa vararaio, noa horiaa vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kotiva saiqa vaaqio vihao aiqava ahasa vuu kaiqa seo 7 entaqaa noa horiaa vauvaa kio, viva vi entaa 7 enta soqema amikeo, maa entava aahuva enta horiaa entama varianarove, kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Naauavata vakavaka auku so osarava minkima vaua. Noavano Kotiva naauavata vakavaka auku soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ho hoqareo vi entaa Noavano Kotiva sa aaqu akikovoa kio, sa vusanaa vau ahasava vauvo sa suvu voqavaka qampiqovo sa vaka auvuu ntuva saaiava vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","vakaqinkainaa namaivanoqai qovaama vio aiqava vaka pukaiqama sehao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Minkima vauvo Noavano Kotiva vaka vaaseo vaiinki auku seo nai qaqi vaiqio vuaina aihoa via aiqiana vuaqa sovo vaiinkivano qaqi vaiqio vi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Vaiinkivano minkima seo qaqi vaiqio vuvo Noavano Kotiva nai aukuko vaiinkia via vika vareo suaivano uinaini Ideni vakaini nai naaho ukukoaqi vuu soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Vi naahoaqi Noavano Kotiva kuvo soqe sakai vo sakai vo sakaivano qampiqeo vauvo via kava vaieva soqe sakai kava, ne kavava vaua. Naaho avukaqi sakai kaaraqanta vaua. Sakai vovano qaqi vaie u sakaiva vauvo sakai vovano soqe saiqave manta saiqave kavare u sakaiva vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ideni vakaqinkaio namai vo qovaama vio vi naahoa pukaiqama saaia namaiva vaihao oku vihao naahoqaankaio namaivano nkahivio kaaraqanta kaaraqantaqaa oku vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Vi namaiva nkahivio hoqarenaa namai auku vaieva Pisoni Namai vaua. Pisoni Namaivano oku vihao Havila vakaqi virante airantemaqio vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Havila vakaini soqe kora oi vauvo soqe nunka u ahasavavaka vauvo vaiinkivano vaakaiqi vau oiva soqe oivaka vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Hoqarenaa namai auku Pisoni Namai vauvo via naankiara namai vo via auku vaieva Gihoni Namai vaua. Gihoni Namai Kusi vakaqi virante airantemaqio oku vio oku vi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Namai kaaraqanta minkima vi vauvo namai auku vo vaieva Taigarisi Namaivano vaua. Taigarisi Namai Asiria vakaqi suai ui vankaraini oku vi vaua. Namai kaaramonavu minkima vauvo vinavusa naankiara namai auku vo vaieva Iufarekisi Namai vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Noavano Kotiva vaiinki via vika vareo nai naahoqi Ideni vakaini vuu seo kihao, Maaqi vaihaama saiqa varehaama soqema sea ki naahoqaa raqisiane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Minki kivaseo Noavano Kotiva mpeqaiqama seo vaiinki via kiva amio kihao, Aiqava sakai kava irainaa homa hiqi sea nehaama ninaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Sakai vo soqe saiqavaka manta saiqavaka kavare i sakaia, vi sakaia kavaqaima sa naane. Ke qioma vake uo. Ae via nea are qukuma vinaave, kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Noavano Kotiva kihao, vaiinki viva nariaraa vaivo sama soqe ivo. saiqe ke via saihaqiainaa nai voqaama vo auku amikaae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Noavano Kotiva minki kivaseo vaka vaa seo vakaqonkaio aiqava aantauvahi vakaqaa nusa auku seo, aiqava aantau naauaini nusavaka auku seo, visa visa ntika vareo vaiinki viva visa nuku vakaae kio, viva vaunaini vuu sovo vaiinki viva vi aantaua vi aantaua auku vakovo vaiinki viva kuntema seo visa nuku vaieva minkima vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Vaiinki viva visa nuku vakaqio vihao aiqava vakaini suvu vau aantauave, qaasau aantauve, aiqava naauaini vii ntaka akaqio nu aantauave, viva aiqava visa visa nuku vakao. Vaiinki viva minkimaqio vuvo sa visaqinkaio vaiinki nai voqaava via saihaqiaiava vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nai voqaava via saihaqiaiava sa vauvoa kio, Noavano Kotiva vaiinki via vaika sovo vaika aavaka vuvo vaiinki via aantea vonku nkaqu seo maki qaiqaa kinka koa. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Noavano Kotiva aantea vaiinkiqinkaio nkaqu soa viaqo nahenki auku seo nahenki via vika vareo vaiinki viva vaunaini vuu sovo ");
INSERT INTO tbg_a_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","vaiinki viva via kaveo kihao, Hove, viva ki voqaavama vaio ivo. Via vuhaai ki vuhaai vohaaqaamama vaio ivo. Via makivaka ki makivaka vohaaqaamama vaio ivo. Viva ki vaiinkiqaankaio vaa saiaa ki, ke viaa nahenkive ki uo, kio. Minki kivaseo kuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kotiva minkima auku amikoaa kio, vake maa entaa vaiinkivano nai nosa qosa mini seo nai naakantio qampama vivo vikanta vaaka vaieva vohaa vaakaqaima vaio. ");
INSERT INTO tbg_a_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Vaiinki vivavaka via naakavanovaka vauvo vikanta ukavaaqa sa vaumanka kosa vaihama sa sauiha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Noavano Kotiva aiqava aantau auku seo vakoaqinkaio memauvano voqama seo uqeraa uva ki vauva vaihao nahenkiaa kihao, Quqaae Kotiva nikanta qio kivakehao aiqava sakai kava maa naahoaqi irainaa sa naake kiva kaiave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Minki kuvo nahenki viva memauaa kihao, Kekanta aiqava sakai kava maa naahoaqi irainaa homa naraave. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Naaho avukaini vai sakaia vohaiqa via kavaqaima Kotiva kikantaa kihao, Sa naake, sa uku varaake. Nekanta vi kavaa uku vare namase quku vivaave, kiva kaiave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Minki kuvo memauvano nahenkiaa kihao, Aqao, nekanta sama quku vivaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nekanta nama saivo nikanta avu aako kenko kiama nekanta soqe saiqavaka manta saiqavaka ho kavehama vaiqa voqaama vaivaave. Kotiva viaa iihao nikantaa sa naake kiva kaiave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Memauvano minki kuvo nahenkivano vi sakaia kavovo soqe sakai kava irakovo saiqe aiqava saiqa ho kavaae kivaseo sakai via kava hiqi seo neo. Nehaoma hini nai vaakivaka amio. Amuvoma vivavaka neo ");
INSERT INTO tbg_a_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","vikanta nama sovo vikanta aako kenko kumanka náikanta vaaka kavovo kosama vaumanka sauiha vikanta ou maua raqase irase rumpake vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Vikanta vaiha iuvo eroaqi Noavano Kotiva vi naahoaqi kuvu ni vaumanka vikanta ou sakai avukaini quqekavi viaqi vauvoma ");
INSERT INTO tbg_a_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Noavano Kotiva vaiinki via aareo kihao, Ae kaaqie variarao? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Minki kuvo vaiinki viva kihao, Ae naahoqi kuvu nihaama kunkusai kianaa iima ke kosa vaihaa kima, qeke maini ani quqekavi vai uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Vaiinki viva minki kuvo Kotiva kihao, Kavave ai vaakaa kosama vaio ivo kivaae are quqeka vuarao? Ke qio kivakauna sakai kavaae are nama saarao? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Minki kuvo vaiinki viva kihao, Ae nahenki ki kimiavama, vivama sakai kava hiqi seo kivaka kimimanka ne uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Minki kuvo Noavano Kotiva nahenkiaa kihao, Ae nanaiqamae varaarao? kuvo nahenki viva kihao, Aqao, memauvano kiriara una uva kimanka ke sakai kava hiqise ne uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Minki kuvo Noavano Kotiva memauaa kihao, Ae una uva kinaa saara are aiqava aantauvahiqinkaia mantaiqama vinaave. Via saara are konkoma ntaka vaihaama auhanaihaiaqaima ninaave. Minkimaqia nihaama konkoma namaqia vihaama quku vinaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ae suvuara iavavaka nahenkivano suvuara iavavaka vikanta navukaiqiha vaiqi vivaave. Naankiara nahenkivano suvuara iava vovano ai qiaka rakavu saiaa are via aiqu akaa nkaqa senaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Minki kivaseo Kotiva nahenkiaa kihao, Ai voqama seo aiha vi vaiaa vainki vakaqi vinaave. Are vainki vakaqi vio aiha vi vaiaama vakenaave. Ai antuqavano ai vaakiarama vaio viva aiqaa raqisiqio vuaie, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Minki kivaseo Kotiva vaiinkiaa kihao, Are nena naaka uva iihaama ke qio kivakauna sakai kavaa nama saaraoa kio, via saara vakavano mantaiqama vuanarove. Are vakaini vaiqia vina entaama vusaai ukihaama ntara uku namaqia vinaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Numii vankusavano uisuma vi vaiaa are ahasaqi ntaravano qampiqainaaqai namaqia vinaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ai koqaavu nte vaiaa ntara uku namaqia vivia vuu quku via qaiqaa qoqaraanaini vakaqi vinaave. Ke vakaqonkai ai kaaqau kauaa variaavave. Are quku viama qaiqaama vakaiqama vinaave, kio. Minki kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nahenkivano aiqava vo vakanaa vo vakanaasa visa nova variaiava vauaa kio, vaiinki viva nai naaka auku ntehao Evaaave, kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Noavano Kotiva aantau paka vaaseo viaqonkaio ukavaaqa auku seo vaiinkivaka via naakavaka nimumanka vikanta via aankaumake vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Noavano Kotiva kihao, Ho kavaane. Vaiinkivano kinavu voqaiqama vio vaihao soqe saiqavaka manta saiqavaka kave vaiva vaio ivo. Viva nai sauqu kukuseo vo sakai kava, qaqi vaiqio vuaina sakai kavaa hiqi seo nama seo aiqava enta qaqi vaiqio vuanto, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Minki kivaseo Noavano Kotiva vaiinkiaa kihao, Ke ai vakaqonkai kaaqau kauava are aaqaini vaihaa vakaqai auvuu ntuvaqia vinaave, kivaseo Ideni naahoqinkaio akikama sovo aaqaini vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Noavano Kotiva vaiinkivaka nahentivaka vikanta nikikama somanka aaqaini vuvo Ideni naaho hini vankaraini suai avu uunaini vinavusa maintaraa raqisiake kio, enseli mpeqanavu mini somanka vaua. Qaqi vaiqio vuaina sakai kavaa vaiinkivano hiqi seo naanto kumanka vinavusa mini maintaraa raqisiha vauvo iha iko saavuvavaka aea aea ihao mini vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adaamuva nai naaka Evaasantio ni vauvoma Evaava vainki kaiqama vio vuu qorainki vainki vakaseo via auku ntehao, Keniave, kio. Viva kihao, Noavano Kotiva ki saihaqimanka ke qorainki vainki vakase uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Minki kuvo via vainkivano nouqama vuvo qaiqaa vainki kaiqama vio vuu via qaka Abelia vakaseo. Abelia via vakasovo nouqama vio Abeliva viva sipisipiqaa raqisi vauvo via vasaava Keniva naaho saiqa vaehao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Minkimaqi vikanta viha Keniva nai naahoqinkaio ntara qantu vareo vuu Noa Kotia amikeo. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Amikovo Abeliva nai sipisipi vovano hoqare vakako naakia vonku aru seo via keqa seo maki soqera vareo vuu Kotia amikoa. Vikanta minkimase Noa Kotia amikovo Noavano Kotiva Abelia quahama amikeo, Abeliva sipisipi aru amikoa viavaka quahama amikeo, ");
INSERT INTO tbg_a_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Keniavaka, Keniva ntara amikoavaka, sa Noavano Kotiva quahama amikeo. Sa quahama amikovo via saara Kenia arara ikovo ua vii arakeo komaseo vaura. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Keniva ua vii arakeo komaseo vauvo Noavano Kotiva Keniaa kihao, Nana saarae ai arara ikaivaa variarao? Nana saarae are ua vii arakea variarao? ");
INSERT INTO tbg_a_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Are soqe saiqe varaiea, ke homa ai quaha amikaraave. Are sa soqe saiqa varaiea, manta saiqavano qentiana vaara aukuke vaihao ai ravaaqau saanaove. Manta saiqavano ai ravaaqavu saantoa, are mpeqaiqama sea manta saiqa aakara saane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Noavano Kotiva minki kuvo Keniva sa via uva iiaio vaio nai qakaa kihao, Varaiqekanta qaqi aaraini ou nuae, kivaseo nai qaka vika vareo vio vuu Keniva nai qaka Abelia ahasaqi aru seo. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Aru sovoma Noavano Kotiva Kenia ireo kihao, Ai qakavano Abeliva kankoe vaio ivo? kio. Minki kuvoma Keniva kihao, Ke sama via kave uo. Sa ke kenka qakaqaa raqisi vauausavauve, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Minki kuvo Noavano Kotiva kihao, Are nana ahasae varaarao? Ke kavauo ai qaka naarevano vakaqaa hiqintivea ke are nena qaka aru saanaa saara ");
INSERT INTO tbg_a_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ai mantaiqama amikareave. Are nena qaka aru saarao via naarevano ntehao vakaqi okiqekaia saara vakavano sama ho ai saihaqianaove. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Are ntara uku keava sama soqema seo qampiqaanaove. Are sa vohaa vakaqaa ho vainaave. Are saku varea hampiqama sea vo vaka vo vakaqaa vaiqia vinaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Noavano Kotiva minki kuvo Keniva kihao, Oho, are noaiqama sea ki kikiavea ke via saara sa ho qaqi vaiaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Are maa vakaaqaankaia ki kikikavea ke sa ai avuqaa ho vaiaave. Ke saku vare vo vaka vo vakaqaa hampiqamavi ni variaiao vo vaiinkivano ki ranta saaiava ki haru saanarove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Keniva minki kuvo Noavano Kotiva aqao kio. Save, vovano ai aru saiea, ke vaiinki 7 navu aruse aiqaa vuntu saraave, kio. Minki kivaseo vovano Kenia ranta seo via aru saanto kio, Noavano Kotiva vira vaakaqaa vusa voqaama qara ntuva koa. ");
INSERT INTO tbg_a_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Minkia sovo Keniva Kotia avuqaankaio saku vareo Ideni vakaihaio suai avu uuntonaini, Noti vakaini vaieva vuama... ");
INSERT INTO tbg_a_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Kanaha vakaini nai qova vaiqi vu vakaraqaa Iakovovavaka vi vakaaqaa vaiqi vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iakovoa vaiktinavu uva maankimama vaio: Iosepeva qaraasa vaiinkivano 17 ihi vaaseo vaihao nai vasausavaanavu hampaka vaihao sipisipiqaavaka, mimiqaavaka, raqisi vaua. Via qoa naakakanta Bilihaasa Siripaasa vaiktinavu hampaka vi quararaqaa raqisio viaqaankaio Iosepeva vuu nai qoa kiva amio kihao, Ki vasausavaanavu manta saiqaqaima vare variavo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Via qova Iakovova via vo auku Isiraiva, viva sontaiqama vuva Iosepea vaka kovaa kio, viva aiqava nai vainkinavuqinkaio Iosepeaa voqama seo antuqa auvo vaihao viaa quahehao suaharavano via aruanto kio, vaaqa soqera auku seo via amio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Via qova vaaqa soqera Iosepea auku amumanka via vasausavaanavu vaaqa via kave kiha, Oho, kinavu qova Iosepeaaqai antuqa aivaro vaio ivo, kivase visa via saara Iosepeaa nirara ikomanka vaiha sa viaa soqe uva kiai, via koma amikoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Vika minki vauvo vo enta Iosepeva kaira kaveo viaqaankaio kaira kavoa viva nai vasausavaanavu kiva nimumanka via saara via vasausavaanavu Iosepeaa voqama seo nirara ikomanka vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iosepeva visaa kihao, Saiqe ke kenka kaira kavaaina osaraa ni kiva nimiae. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kenavu naahoqi uiti rumpase vauo viaqaankaio ke uiti rumpa kauava himpi vaaviarama vio vaimanka nenavu uiti rumpa kaasa visa ke rumpa kaunaa ukukumavi vaiha ke uiti rumpa kaunaa quaha amikeha ravenkavi variaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Iosepeva minki kumanka via vasausavaanavu kiha, Oho, are manta kairahaama kavaarao. Are vi kairaa kavaanaa iihaama are kihaa, Ke visaqaa raqisieave, kioave, ki. Minki kivase visa Iosepeva kaira kavoa saaravaka, Iosepeva visaa ku uvaa saaravaka, visa Iosepeaa voqama seo nirara ikomanka vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Minkima vauvo Iosepeva qaiqaa kaira vo kaveo nai vasausavaanavuaa kihao, Ke qaiqaa kaira vo kave uo. Ke vaiha kavauamanka suaivanovaka, koravanovaka, masau ovuroa 11 navuvanovaka, vinavusa ravenkavi vaiha ki quahama kimike vaiavo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Iosepeva vinavusa kiva nimio viaqaankaio nai kaira kavoaa nai qoavaka kiva amuvo via qova Iosepea akihao kihao, Oho, are manta kairahaama kavaarao. Are kaira kavaanaa iihaa kihaa ki novavaka ki vasausavaanavuvaka ki qovavaka ravenkavi vaiha ki quahama kimikevaave kioave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Minki kumanka Iosepea vasausavaanavu via saara nirara ikomanka Iosepea koma amike vauvo via qova vi uvaa iiqio vihao aako ukihao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Vo enta Iosepea vasausavaanavu visa nái qoa sipisipi vika vare Sekemini ou vaiha sipisipiqaa raqisi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Iakovova Iosepeaa kihao, Are nena vasausavaanavu sipisipiqaa raqisinaini Sekemini vuane, kio. Minki kuvo Iosepeva kihao, Ke mini viea henuqamase vai uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Minki kuvo via qova kihao, Ai vasausavaanavu hoe variavo, sae ho variavo? Are visa ou kavea vii ki kiva kimiane, kio. Minki kivaseo via qova Iosepea akikovo viva Hebaroni kaaqi ntaka vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Iosepeva ou vio Sekemini ou nteo nai vasausavaanavuaa qumina rantehao vi ani vauvo vo vaiinkivano via kaveo kihao, Nana ahasaae rante variarao? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Minki kuvo Iosepeva kihao, Ke kenka vasausavaanavu sipisipiqaa raqisiasaama rante vai uo. Are visa vuanainiaa iianaave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Iosepeva minki kuvo vaiinki viva kihao, Visa vaasama maihai vuavo. Ke iiua visa kiha, Dotaani kaaqi ntaka vieave, kiaave, kio. Minki kuvo Iosepeva nai vasausavaanavu ntakaqio vio Dokaanini ou nteo kavomanka visa mini vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Iosepeva aumanko ou ntomanka via vasausavaanavu vukuni vuku via kave visa via arusea nai kiva ami nai kiva amiha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Visa kiha, Oho, kaira kave vai vaiinkiva ani vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Saiqe kenavu via aruse namaiaa vaka quvukaavo aaharaiqama viaqi via vaaka vaavi aqu saae. Kenavu via vaaka viaqi aquse viaa qaasau vairivano aru seo ivo kiae. Kenavu minkiaio viva kaira kavaiava quqaae varianaroe, sae quqaa vi vaua varianarove? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Visa hini usa minki kuvo Rubeniva visa uva iio visa Iosepea arusevoave kivaseo visaa aqao kio, Saiqe kenavu sa via arusaae. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kenavu sa via arusarai namaiaa vaka quvukaavo aaharaiqama viaqi via qaqi aqusaae, kio. Viva visaa minki kivaseo viva nai iiseo kihao, Ke naankiara via ruaruamase viaqaankai nai qova vainaini vika vare vuu saraave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Rubeniva minki kumanka visa vauvo Iosepeva ani ntomanka visa via ravaaqause via vaaqa soqera via vaakaqaankai ravaqaase qaqini se ");
INSERT INTO tbg_a_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Iosepea vikavaare munku haau namaiaa quvukovo aaharaiqama vuaqi via aqusoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Visa Iosepea viaqi aquse viaqaankai visa ntara naesa oquvi vaiha vukuni vuku kavomanka Isamaia vakanaasa Gileaati vakusaihai ani vaua. Vi vakanaasa airi aiaia soqe untavu ahasaave, ntaraqaa hiasaa u ahasaa aakakoave, vi ahasaa vi ahasaa visa nái kameriqaa rumpa vare Isipini vuu nimiha soqaa varaesa ani vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ani vauvo Iutiva nai qaka vasausaa kihao, Kenavu kenkanavu qaka aruse via arusaainaa uva quqeka saainaaqaankaio sa kinavu saihaqiaina ahasava qovaama ianaove. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Saiqe sa kenkanavu sauquqonkai Iosepea airai vaiai, Isamaia vakanaasa aniqe via visa nimiai visa soqaa kinavu kimiake. Kenavuvaka vivavaka vohaa vaiinkima vai uo. Kenavu via aru saaoave, kio. Iutiva minki kumanka via qaka vasausa hove kumanka ");
INSERT INTO tbg_a_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Isamaia vakanaasave Midiani vakanaasave, visa anumanka Iosepea vasausavaanavu namaiaa quvukoaqi via aqu soaqinkai via qaqini vaa vaaise, Isamaia vakanaasa Iosepea nimihama 20 silvaa munima varomanta vi vakanaasa Iosepea vika vare vuu Isipini soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Vi vakanaasa Iosepea vika vare vuvo Rubeniva ounteo namaiaa quvukoaqi ani kavovo Iosepeva viaqi sa vauvo via saara via munkusa mantaiquvo oho kivaseo nai ukakaai nahaqu seo ");
INSERT INTO tbg_a_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ou nai qakanavuaa kihao, Ke kavauo Iosepeva sa viaqi vaio ivo. Oho ke nankie iaave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Minki kumanka vinavusa Iosepea vaaqa qaqini rahunku soa vare mimi vo aruse Iosepea vaaqa mimi naare viaqi quntamase vare ");
INSERT INTO tbg_a_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","anirante visa vuu nái qoa umiqeha kiha, Kenavu maa ahasaa ranta saunaa are aikukiha kavaane. Iosepea vaaqae vo vaiinki vaaqae vaio ivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Vinavusa minki kuvo visa qova Iosepea vaaqa uqauama seo kaveo kihao, Oho, maa ki maaqu Iosepea vaaqave. Qaasau vairi vovano via aruseo nama seo ivo. Quqaama qaasau vairivano via aruseo via vaaka keqaaqama seo ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Iakovova minki kivaseo nai ukakaai nahaqu naahaquma seo manta ukakaaiqai ankaumasero airi enta vaiqio vihao nai maaquaa iqi rakaqio vi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Via maaqu hini usavaka via raavuanavuvaka via munkusa susuqama amikaae kuvo Iakovova sa visa ku uvaa iio. Viva aqao kio, Ke kenka maaquaa iihama qaqi iqi rakaqi vivi vuu quku viaave, kivaseo nai maaquaa iqi rakaqio vi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mintuvo Midiani vakanaasave Isamaia vakanaasave, visa Iosepea vika vare Isipini ou vaiha Iosepea Potipaa amihama munima varoa. Potipaava noa vaiinkivano vaihao viva iqosa vaiinkinavuqaa raqisi vaumanka visa Pero vaiinki naavu noa naavuqaa raqisi vaua... ");
INSERT INTO tbg_a_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isamaia vakanaasa Iosepea vika vare Isipini ou vuvo mihainaa vaiinki vovano Potipaava visa munima nimihao Iosepea varoa. Potipaava noa auku vakaa vaiinkiva iqosa vaiinkinavuqaa raqisi vaumanka visa Pero vaiinki naavu noa naavuqaa maintaraa raqisi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Isipi vakanaa vaiinkivano munima aquseo Iosepea varovo Iosepeva Potipaa saiqa vaehao via naavuqi vauvo Noavano Kotiva Iosepea sahaiquvo Iosepea saiqavano soqe saiqa vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Iosepeva soqe saiqa vare vauvo Potipaava kavovo Noavano Kotiva Iosepea saihaquvoa kio, Iosepea saiqavano uikareo vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potipaava Iosepeaa quahaseo via noaiqama seo kihao, Are ki naavuqi saiqa varehaama aiqava ki saiqa ahasaqaa raqisiane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Potipaava minki kivaseo Iosepea noaiqama sovo Iosepeva aiqava via saiqaqaa raqisi vauvo vi entaaqaankaio Noavano Kotiva Iosepeaa iihao Potipaa soqema amikovo Potipaava ntara ukukovave, soqaa saiqa varoave, soqe io vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Minkima vauvo Potipaava Iosepeaa kihao, Are aiqava ki saiqaqaa raqisiqia vuane, kuvo Iosepeva aiqava via saiqaqaa raqisiqio vi vauvo Potipaava sa nai saiqaa airi aako iiaio, homa Iosepeva vi saiqaa varaanaove kihao viva qaqi vaihao ntaraqai nehao vaua. Minkimaqio vuvo Iosepeva soqe vii vaaka vakaa vaiinkivano vaihao Potipaa saiqaqaa raqisi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","viaqaankaio Potipaa naakavano Iosepea kavovo munkusa ntuvo viaa avu akihao Iosepeaa kihao, ania kintia vaikaane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Minki kuvo Iosepeva aqao kio, Ke maa naavuaqi vaiha via saiqaqaa raqisi vauoa kio, ki noa vaiinkivano Potipaava sa maa saiqaraa airi aako iivo. Viva ki noaiqama saimanka ke aiqava via saiqa ahasaqaa raqisi vai uo. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ke via aana ntavavi sema maaqi vaiha via saiqaqaa raqisi vai uo. Potipaava sa vo ahasa ki qioma kiva keo ivo. Are via naakavano variaaroa kio, viva ariaraqai iihaoma ki qioma kiva keo ivo. Via saara ke manta saiqa vaeha Kotia uva raqa saaoave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iosepeva minki kuvo vi nahenkiva vo enta vo enta Iosepea aare vauvo Iosepeva sa via uva iiaio, sa viva vaunaini ou vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Vo enta sa vi naavuaqi saiqa vaiinkie saiqa nahenkie vonavu vauvo Iosepeva naavuqi saiqa vaaeva oiqekovo ");
INSERT INTO tbg_a_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potipaa naakavano Iosepeva vaaqa ruvukoa ukukeo kihao, Are kintia vaikaane, kuvo Iosepeva nai vaaqa viquseo vi nahenkia sauquqi via mini seo vahaaqaini veva nteo santama vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Iosepeva santama vuvo vi nahenkiva kavovo Iosepeva nai vaaqa via sauquqi seo naavuqinkaio santama vuvo ");
INSERT INTO tbg_a_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","vi nahenkia voqama seo arara ikovo naavuqi saiqa varosa naarama seo visaa kihao, Ho kavaake. Ki vaakivano Hiparu vakanaa vaiinki maa vika vareo kinavu naavuqi vii saivama, viva ki mantaiqama kimikaeva auki vaio ivo. Viva maaqi oiqekeo kintio nuae kimanka ke oi aai kuaoma ");
INSERT INTO tbg_a_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","viva ke oi aai kunaa iio qekeo nai vaaqa maini seoma aiqu aukuseo vahaaqaini veva nteo santama vivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Minki kivaseo Iosepea vaaqa qaqi vakeo nai vaaki vesa vauvo Potipaava via vaakivano anuvo ");
INSERT INTO tbg_a_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","viva vaaqa via nai vaaki umiqehao kihao, Hiparu vakanaa saiqa vaiinki vika vii saarava, vivama ki mantaiqama kimikaeva auki vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Viva ani ki uku varaimanta ke oi aai kuaoma viva qekeo nai vaaqauka maini seo naavuqinkaio veva nteo santama vivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Via naakavano una uva minki kuvo Iosepea noa vaiinkivano Potipaava nai naaka uvaa quqaa uvave kio via arara ikovo ");
INSERT INTO tbg_a_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ou Iosepea ravaaqau vareo karavusaqi vuu soa. Vi naavuaqi Pero vaiinki uva raqaso vaiinkisa vauaqi Iosepea karavusa amikovo Iosepevavaka viaqi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Viaqi vauvo Noavano Kotiva via saihaqi vauvoma kio, karavusa naavuqaa raqisu vaiinkiva Iosepea soqema amikoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Karavusa naavuqaa raqisu vaiinkiva Iosepeaa quahehao via noaiqama seo aiqava karavusa vaiinkiqaa raqisiane kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Minki kuvo Iosepeva vi saiqaa vare vauvo Noavano Kotiva via sahaiquvo Iosepea saiqavano uikarovo karavusa naavuqaa raqisu vaiinkiva sa Iosepea saiqaa airi aako iiaio, viva Iosepeaa kihao, Viva nai homa vaihao vi saiqaa varaanarove, kivasehao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Iosepeva karavusa naavuqi vaiqio vuvo vo enta Isipi vakanaasa kave vakaava Pero vaiinkivano nai saiqa vaa amiko vaiinki vokanta vo uva saara vikanta karavusa nimikoa. Via saiqa vaiinki vovano Pero vaiinki namai amu vaiinkiva vauvo via saiqa vaiinki vovano Pero vaiinki mpereti nunke vau vaiinkiva vaua. Pero vaiinkivano vikanta karavusa nimikovo Iosepeva karavusa naavuqi vaumanka vikantavaka viaqi ou vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pero vaiinki naavuqaa maintaraa raqisu vaiinkisaqaa raqisuva vi naavuaqaavaka raqisihao Iosepeaa kihao, Are qaraasa vaiinkikantaqaavaka raqisiane, kuvo Iosepeva vi vaiinkikantaqaavaka raqisi vaua. Minkima seo raqisi vaumanka vikanta karavusa naavuqi vaiqi vuvoma airi enta aikaromanka ");
INSERT INTO tbg_a_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pero vaiinki namai amu vaiinkivavaka, Pero vaiinki mpereti nunke vau vaiinkivavaka, vikanta vohaa enta entaqi vaikeha kaira kavoa. Vovano vo kaira kavovo vovano vo kaira kavoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Vikanta kaira kavovo via qararaa koqaqi Iosepeva vikanta vauaqi ou nteo kavovo vikanta munkusavano mantaiqumanka viaqi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Vikanta munkusavano mantaiqumanka vauvo Iosepeva vikanta ireo kihao, Nekanta nana saarae ua vii arake variavo? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Minki kumanka vikanta kiha, Kekanta entaqi kaira kavaunaa sa via osara ii uo. Kaira osara kikanta kiva kimiaiava sa maini vaio ivo, kinka. Vikanta minki kuvo Iosepeva kihao, Kotiva vaiinki saihaqivoma viva kaira osara ho iiave. Nekanta kaira kavea ki kiva kimiqe iriae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Iosepeva minki kuvo Pero vaiinki namai amu vaiinkiva viva naane nai kaira kavoa Iosepea kiva amio kihao, Ke vaikeha kaira kavauo ki kivuqaa uaini santavano vaiave. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Vi santava qampiqehao vaimanka via saqi kaaraqanta vohaiqa vaiavo saqiqaankaio kava irakaivo aquika vimanka ");
INSERT INTO tbg_a_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ke kave via hiqise vi kavaa kakise vi namaira kapaqi vare vuu Pero vaiinki sauquqi ami uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Minki kuvo Iosepeva via nai kiva amio kihao, Are kaira kavaanaa via osara minkimama vaio ivo: Saqi kaaraqanta vohaiqa vaia kavaanaa via osara vaieva kaaramo entama vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Enta kaaramonavu aikaraiaoma Pero vaiinkivano qaiqaa ai aarama saiaa are via saiqa varehaama haau vara vuu amianantema sea, qaiqaama are via kapa nai sauquqi vuu aminaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Are qaiqaa soqemavi vaihaa Pero vaiinki saiqa varehaama kiriara kauru seoave. Are kiriara iisehaama kiriara Pero vaiinki kiva amiao viva ki karavusa naavuqinkai rahunku saaie. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Haau ke Hiparu vakanaa vaiinkivano kenka maaqaini variavau ki muara rarau vare maini anuave. Ke maini vaiha sa manta saiqa vararai variavauo qumina una uva saara ki karavusa naavuqi saimanka vai uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Iosepeva minki kuvo Pero vaiinki mpereti nunko vaiinkiva kavovo Iosepeva vo vaiinki kaira osara soqema seo kiva amuvo vivavaka Iosepea kiva amio kihao, Kevaka kaira vo kave uo. Ke kaaramo kanunavuqi mpereti ntuvase kenka qiakaqaa vaa aquvare ani uo. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ventaaqaara vai kanuaqi Pero vaiinkiaa nunka kauna mpereti, vo mpereti vo mpereti vaimanka uviinavu ani vi kanuaqinkai mpereti varase ne variaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Minki kuvo Iosepeva vi vaiinkia nai kiva amio kihao, Are kaira kavaana osarava minkimama vaio ivo: Kanu kaaramonavu vaia via osara vaieva kaaramo entama vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kaaramo enta aikaraiao Pero vaiinkivano karavusa naavuqinkaio ai vikeo ai aunta keqaseo ai vaaka sakaiqaa arukaaio uviivano ani ai vaaka maki nama saanarove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Iosepeva minki kuvo enta kaaramonavu aikarovo Pero vaiinkivano kihao, Ki vakai entava qovaama vivo, kivaseo vi entaa quahehao nai sena noa vaiinki naarama seo ntara nimio karavusa naavuqinkaio viva nai saiqa vaiinkikanta via namai amu vaiinkiavaka, via mpereti nunke vau vaiinkiavaka, vikanta ntika vareo noa vaiinkinavu ntara nonaini vuu seo. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vuu mini seo via namai amu vaiinkiaa kihao, Are qaiqaa qaqi ki saiqa varenaave, kuvo vi vaiinkiva qaiqaa namai kapa Pero vaiinki sauquqi vakovo ");
INSERT INTO tbg_a_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero vaiinkivano nai mpereti nunke vau vaiinkia aruseo Iosepeva kuntema seo, via vaaka sakaiqaa arukoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Minki uvo Pero vaiinki namai amu vaiinkiva qaiqaa Pero vaiinki saiqa vaehao sa Iosepeaa iiaio, via kauru soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Iosepeva karavusa naavuqi qaqi vaiqio vuvo ihi kaaraqanta aikarovo Pero vaiinkivano entaqi vaikehao kaira kavoa. Viva kaira kavova maankimama vaio: Pero vaiinki maraquavano Nairi Namai hini vantaraini auhianta himpikeo vaihao kavomanka ");
INSERT INTO tbg_a_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","vi namaiaqinkai vurimakaua soqesa 7 navu qovaamavi namaiqinkai vaainte ou namai auhianta vaiha usau ne vaua. Vi vurimakauanavu soqe vaaka vakausa noa hauntivano vaiha usau ne vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ne vaumanka via naankiara namaiqinkai vo vurimakaua 7 navu qovaama vua. Vinavusa sa vaakavaka vausa, vuhaaiqai vausa namaiqinkai vaainte ou vurimakaua soqesa hampaka vaiha ");
INSERT INTO tbg_a_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","visa aruse nama soa. Minkuvo Pero vaiinkivano kaira via kaveo vaikonaihaio himpio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pero vaiinkivano himpio viki vii kaveo qaiqaa vaika vio kaira vo kaveo. Viva kaira vo kavova maankimama vaio: Via maraquavano kavovo sankuma voqaama vauvo via veha vohaiqaqaankaio noa 7 navu soqera irakeo mpeqaiqama vio vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Noa soqe 7 navu minkima vauvo via naankiara vo sankuma voqaama irakeo noa 7 navu irakovo suaivano noaiqamaseo ike vauvo uvaivano iha voqaama ukihao via kakoqa aqu sovo sa soqe kava irakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sa soqe kava 7 navu irakova ou soqe kava 7 navu irakoa nampiqama soa. Minki uvo Pero vaiinkivano vaikonaihaio himpio kihao, Oho, ke kairama kave uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Minki kivaseo via qararaa koqaqi Pero vaiinkivano nai kaira kavoa saara aako ukihao vaihao Isipi vakanaa vaiinki vo osara vo osara kavosavaka, vaana saiqa vare vau vaiinkinavusavaka, visa naarama seo viva kaira kavoa visa kiva nimumanka visaqinkai sa vovano via kaira osara sankunka seo ho kiva amiaiava vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Visa sa Pero vaiinkivano kaira kavoa osara ho kiva amiai vauvo Pero vaiinki namai amu vaiinkiva oho kio, Ke vakeqai vo uva iike uo. Haau ke vi uvaa ai kiva amiakaara vaimanka sa ai kiva amunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Haau ai arara ikovaa are kivaka, vo vaiinkivano ai mpereti nunke vau vaiinkiavaka, kikanta karavusa kimikomanka kekanta karavusa naavuqi variavaunaave. Ai naavuqaa maintaraa raqisi vaia vaiinkinavusaqaa raqisi vai vaiinkia naavuqi are kikanta karavusa kimikomanka ");
INSERT INTO tbg_a_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","kekanta viaqi vaiha vohaa enta entaqi vaikeha kaira kavaavaunaave. Ke vo kaira kavaavauo vo vaiinkivano vo kaira kavo. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kekanta kaira kave sa via osara iiai variavauo Hiparu vakanaa vaiinkivanovaka karavusa naavuqi vauave. Vi vaiinkiva haau ai naavuqaa maintaraa raqisi vaia vaiinkisaqaa raqisi vai vaiinkia saiqa varoave. Vi vaiinkiva Hiparu vakanaa vaiinkivano kikanta hampaka karavusa naavuqi vaumanka kekanta kenkakanta kaira kavaavaunaa vi vaiinkia kiva amiavauo viva ki kaira osara kinka sankunka kiva kimio vo vaiinki kaira osara viavaka nai sankunka seo kiva amuave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ho viva kikanta kiva kimuntema sea are kiriara qaiqaa ki saiqa varaane kivasea, vo vaiinki via arusea sakaiqaa arukonaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pero vaiinki namai amu vaiinkiva minki kuvo Pero vaiinkivano Iosepea aarama sovo vovano santeo karavusa naavuqinkaio via vika varovo Iosepeva osau nuquseo vo ukavaaqa ankaumaseo ou Pero vaiinki aaqanko vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Iosepeva ou Pero vaiinki aaqanko vauvo Pero vaiinkivano viaa kihao, Ke kaira kave via osaraa vo vaiinki vo vaiinki iraua visa sa ki kaira osara ho kiva kimiavo. Vovano ariara kaira osara ho nai kiva nimi vaivave kimanka iunaave. Vi uvava quqaae vaio ivo, sae quqaa vaio ivo? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Pero vaiinkivano minki kuvo Iosepeva aqao kio, Ke qaqi vaiinkivano vaiha sa ho ai kiva amiaave. Kotiva ki saihaqiaqe ke homa via osara ai Pero vaiinki kiva amiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Minki kuvo Pero vaiinkivano Iosepeaa kihao, Ke kaira kavauo ki maraquavano Nairi Namai hini vantaraini himpikeo vaihao kavaimanka ");
INSERT INTO tbg_a_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","namaiqinkai vurimakaua soqe 7 navu visa vaaka soqema seo nouqosa qovaama vi, vaainte ou namai auhianta vaiha usau ne variaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Visa mini usau ne variamanka visa naankiara vo vurimakaua 7 navu namaiqinkai qovaamavi, visa sa soqe vaaka vakausa vaiha vuhaaiqi variasa variaave. Ke haau Isipini vaihavaka via voqaama vehi vurimakaua sa kavaavaunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Vuhaaiqi varia vurimakauasa 7 navu namaiqinkai vaainte ou haau hoqare namaiqinkai vaainte usau ne vaia vurimakauasa aruse nama kaiqa saarave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Visa vo vurimakauanavu aru nama kaiqa saavo visa vaakavano haau vauntema seoqai, vuhaaiqi vaiave. Sa visa vaakavano vaaka vaumanka mantaqumavio vaimanka variaave. Ke mintimase kaira kave vaikaunaihai qaqi himpi uo. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ke qaqi himpi viaqaankai qaiqaa vaikavi kaira vo kave uo. Ke kaira vo kavauo sankuma voqaama vaivo via veha vohaiqaqaankaio noa soqe 7 navu irakaiave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Minkima irakeo via naankiara noa 7 navu vonavuvaka irakaiave. Irakaivo uvaivano iha voqaama ukihao via kakoqa aqu saivo via naankiara noa 7 navu irakaiva sa soqema vaiave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Viaqaankaio noa 7 navu sa soqeva ou noa 7 navu soqea nampiqama saiave. Ke kaira minkimase kave viaqaankai vi uvaa vaana saiqa vare varia vaiinkisa kiva nimuamankavaka, visa sa vi uvaa osara ho kinka kiva kimiavo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Minki kuvo Iosepeva Pero vaiinkiaa kihao, Are kaira kaaraqanta kavaanaa, vikanta osara vaieva vohaa osaraqaima vaio ivo. Kotiva nai naankiara varae i osaraa kairasaama ai umiqeo ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Kotiva vi uvaaqaa ntuva seo minkima kivo: Are vurimakaua soqe 7 navu kavaanaa, via osara vaieva ihi soqe 7 navuma naankiara varianarove. Sankuma voqaama noa soqea 7 navu irakaia, via osaravaka vaieva ihi soqe 7 navuma naankiara varianarove. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Vo vurimakaua 7 navu naankiara qovaama vuasa vuhaaiqi variasa, visa osara vaieva, ihi sa soqe 7 navuma naankiara varianarove. Sankuma voqaama sa soqe irakaia 7 navu vaivo uvaivano iha voqaama ukihao kakoqa saia, via osaravaka vaieva ihi sa soqe 7 navuma naankiara varianarove. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kotiva naankiara nai saiqa varae i osaraa kairasaama ai umiqeo ivo kunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Vi kairaaqaa Kotiva ntuva seo minkima kivo: Maa entaaqaankaio maini Isipini ntaravano 7 ihi vaaqio vihao soqema seo qampiqaqio vuanarove. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ntaravano soqema seo qampiqaqio viao 7 ihi soqea kaiqaiao viaqaankaio 7 ihi vaaqio vihao ntaravano sa ho qampiqaanarove. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Vi entaa sa soqe enta vaimankaa ki, vaiinki nahenki airi ntara variaina entaa kauru sevaave. Are kaira kavaana osarava minkimama vaio ivo: ");
INSERT INTO tbg_a_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kotiva uva kiva keo vaasama vi entaa vi uvaa qovaama saeva auki vaivaa kia, are kaira kaaraqanta vohaa vasa kavaarao, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Iosepeva minki kivaseo qaiqaa Pero vaiinkiaa kihao, Viaa iihaama vaiinki vo, avu aako vakaa vaiinki ranta sea via noaiqama saiao viva Isipini vaihao aiqava saiqaqaa raqisiaie. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Vi vaiinkia noaiqama sea vaiinki vonavuvaka noaiqama saiama vinavusa vaiha aiqava ntara qantu vare aniraqaankai hini ntara takisi varentemase vaevaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Vinavusa ntara vaehama qaqi vaiinki nahenkiaa nenka 4 navu ukuke vohaiqa kinavu kimiake kivaqi vivaave. Vinavusa ai Pero vaiinki auku ntehama takisi varentemase, ntara vareha 7 ihi ntara soqema seo qampiqainaa vi ntaraa vaaqi viha vuu vo vakusa vo vakusaqi noa naavuqi vuu qaqi vakaivo ");
INSERT INTO tbg_a_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","naankiara 7 ihi sa ntara qampiqaina ihiva ani ntaiao ntara ho variaie. Vinavusa minkima saivo naankiara sa ntara variaina entava ani ntaimanka maa vakanaasa antuqa aruaia entava anintaimanka sa ntaraa qukuaiaki, qaqi vaivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iosepeva minki kuvo Pero vaiinkivanovaka, via noa vaiinki vonavuvaka, Iosepea uvaa soqe uvave kivase, vaiinki vo noaiqama seaa iiha ");
INSERT INTO tbg_a_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pero vaiinkivano kihao, Nankima vaina vaiinkiae noaiqama saraave? Kotiva Iosepea avu aakoqaa soqema seo raqisi vaivoa kio, viva vi uvaa osara kinavu kiva kimivo. Sa vovano Iosepea aakara saaiava vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Minki kivaseo Pero vaiinkivano Iosepeaa kihao, Kotiva vi uvaa osara ai kiva amivo ai avu aakovano ho vaivaa varianaraa kio, vovano ai aakara saaiava sama vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Viaa iihama ke ai noaiqama saaiaa arema ki noa naavuqaa raqisi vaiama aiqava ki vaiinki nahenki ai uva iiqi vuake. Keqaima Pero vaiinkivano vaiha ai noa vaiinkima vaiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pero vaiinkivano minki kivaseo qaiqaa Iosepeaa kihao, Vake ke ai noaiqama saaiaa are aiqava Isipiqaa raqisiqia vuane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Minki kivaseo qaqi vaiinki nahenki Iosepeva noaiqama vuainaa iriake kio, Pero vaiinkivano nai vuqaqi nonkuko ringia rahunku seo Iosepea vuqaqi nonku amikeo, soqe ukavaaqa nonku amikeo, kora oi hankaroro via auntaqi ruvu amikeo, ");
INSERT INTO tbg_a_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","qosavaka qosaqaa santarumako kaariavaka Iosepea amuvo Iosepeva Pero vaiinki naankiaraini noa vaiinkivano vaihao iqosa kaariqi vauvo qosavano via rarauqi vi vaumanka vaiinki vonavu Iosepea avuni santamaqi ou viha kiha, Iosepeva ani vaio ivo. Ne vinivo viva aniaie, ki vaua. Minkima seo Pero vaiinkivano Iosepea noaiqama sovo Iosepeva aiqava Isipiqaa raqisi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pero vaiinkivano Iosepeaa kihao, Ke Pero vaiinkivano ai noaiqama se uo. Are sa hove kiea, maa vakanaasa sa ho nái iise saiqa varevaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Minki kivaseo Pero vaiinkivano Iosepea qaraasa auku ntava amikeo viaa Sapenaati-Paneaave kivaseo nahenki vo via auku Asenaatia via amua. Vi nahenkiva Potipea raavuavano vauvo Potipeva Isipi vaiinki nahenkiaa iihao suaiaa kinavu vaiqave kihao via aarehao vau vaiinkiva vakusa vo Oniqi vaua. Iosepeva Potipea raavua Asenaatia vaakeo vaihao aiqava Isipini vi anihao saiqaqaa raqisihao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iosepeva noaiqama vio viva 30 ihi vaasova vaihao Pero vaiinki saiqa hoqarama keo vaaqio vua. Iosepeva Pero vaiinkivano vaua mini seo Isipini vi anihao saiqaqaa raqisi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ihi 7 navu vaaqio vihao ntaravano soqema seo qampiqaqio vuvo ");
INSERT INTO tbg_a_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Iosepeva vi entaa vi ntaraa vareo vo vakusa vo vakusaqi vuu vakoa. Vo vakusa vo vakusavano vauvo Iosepeva vakusa kakaaqa qampiqo ntaraa vi ntaraa qantuseo nai vi vakusaaqi vuu vakeo, vo vakusaqi qampiqo ntaraa qantuseo nai vi vakusaaqi vakeo, minkimaqio vihao vo vakusa vo vakusaqi ntara qantu sehao vuu vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Iosepeva nuqavano airi vaintema seo, viva airi ntara qantu vareo vo naavu vo naavuqi mpiqaseo vakovo airi ntara vauvoa kio, Iosepeva hini ntaraqai mpukaqi qara ntuva keo hini ntara sa mpukaqi qara ntuva karaio, qaqi naavuqi vuu vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sa ntara qampiqo entava sa ani ntovo soqe ntara qampiqo entava qaqi vau entaa Asenaativa Potipea raavuavano vainki kaaraqanta Iosepea vaka amikovo ");
INSERT INTO tbg_a_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Iosepeva nai vainki hoqare vakakoa auku ntehao Manaseave — Kaurusaunaave , kio. Iosepeva kihao, Kotiva ki saihaqimanka kinka vasausavaanavu ki mantaiqama kimikoa kauruse, kenka karavusa naavuqi vusai enta variavaunaavaka kauru se uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Minki kivaseo Iosepeva nai vainki via naankiara vakakoa auku ntehao Efaraimuave — Vainki Kimiave , kio. Iosepeva kihao, Ke maa vakaini variavauo ki vaaka maara ntomanka variavauo Kotiva ki sahaqivo kinka vaakaiqimanka vauo Kotiva vainki ki kimivo, kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ho Isipini soqe ntaravano qampiqaqio vuvo 7 ihi kaiqovo ");
INSERT INTO tbg_a_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Iosepeva kuntema seo, sa ntara qampiqo ihiva 7 navu anieva hoqarama koa. Vi entava ani ntovo vo vakaini vo vakaini sa ntara vauvo Isipiniqaima ntara qantu vuu naavuqi vakova ho vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sa ntara qampiqo entava anintomanka Isipi vakanaasa ntaraa antuqa ntaihomanka vaiha Pero vaiinkiaa ntara kinavu kimiane kuvo Pero vaiinkivano visaa kihao, Ne Iosepeva vainaini ou vima, viva kiaina uvaa iriake, kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Isipini voqi voqi ntara sa vauvo Iosepeva vo naavuqi vo naavuqi ntara qantu vuu vakoa ou qenti qankuaseo munima vaehao ntara vi vakanaasa nimua. Aiqava Isipini ntara sa qampiqovoa kio, Iosepeva minkua. ");
INSERT INTO tbg_a_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Vo vakaini vo vakainivaka sa ntara vaumanka vo vakanaasa vo vakanaasa Isipini Iosepeva vaunaini ntara varaesa vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kanaha vakainivaka ntara sa vauvo Iakovova vaihao iuvo Isipini ntara vauvo viva nai maaqunavuaa kihao, Ne qumina maini vaiha nai kave nai kave iha vaivoave. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipini ntara vaio ivo kiamanka iunaave. Nenavu mini oku ntema munima aqusehama ntara vara vii kinavu kimiqe kenavu ntara via nehama sa quku viai, qaqi vaiqi vuae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Iakovova minki kivaseo Iosepea vasausavaa 10 navu nikikomanka visa munima aquseha ntara varaesa Isipini vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Visa vie uvo Iakovova sa Benaminia Iosepea qaka akisaraio kihao, Viavaka akikaaiao vo ahasavano via mantaiqama amikaanto, kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaha vakaini noaiqamaseo ntaraa antuqa aru entava ani ntomankaa ki, vo vaiintinavuvaka Iakovoave Isaraiave via maaqunavuvaka ntara varaesa Isipini vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Vuvo Iosepeva aiqava Isipiqaa raqisi vauva vaihao vo vakaihainaasa vo vakaihainaasa visa munima vaehao ntara nimi vaumanka Iosepea vasausavaanavuvaka Iosepeva vaunaini ou nte via avuqaa vaiha hiqintivi kankakaavuvi visa nái vii vakaini se vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iosepeva nai vasausavaanavu vii uqauama seo kaveo, viva sa visa vii uqauamaseo kavovaa voqaama vaihao Iosepeva visa anoqama seo ireo kihao, Ne kaihai aniasae iavo? kio. Minki kumanka visa kiha, Kenavu Kanaha vakaihai ntara varaea anuausave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Visa minki kiha visa sa Iosepea vii uqauqamase kavovo Iosepevaqai nai vasausavaanavu vii uqauama seo kavoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Visa sa Iosepea vii uqauqamase kavarai, kankakaavuvi vauvo Iosepeva nai haau kaira kavoa viaa qaqi iikeo visaa kihao, Aqao, nenavu vo ahasaa ampeqiesa aniavo. Nenavu maini ani kinavu ampeqamase kaveha kenavu sa soqemase raquainaa kavaesa aniasave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Iosepeva minki kumanka visa kiha, Noa vaiinkio, kenavu sa minkiea anuausave. Kenavu ai saiqa vaiinkinavu vaiha munima aquseha ai ntara varaea anuausave. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kenavu vaiea qaka vasausa vauo kinavu qova vaiinki vohaiqavano vaio ivo. Sa kenavu maa vakanaasa ampeqiea anuausaauve. Kenavu quqaa uvaqai kua vaiinkisama aninte uo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Visa minki kuvo Iosepeva kihao, Nenavu unahaama kiavo. Nenavu maini ani kinavu ampeqamase kaveha kenavu sa soqemase raquainaa kavaesa aniasave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Iosepeva minki kumanka visa kiha, Kenavu haau vaiea qaka vasausa 12 navu vauo kinavu qova vohaa vaiinkivano Kanaha vakainima vaio ivo. Kinavu qaka vovano quku vuvo kinavu qaka naankiaraihainaava kinavu qoavakamaseo vaio ivo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Visa minki kuvo Iosepeva aqao kio, Ke vaasa kunaa, ne maa vakanaasa ampeqiesama aniavo. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Maankimase ke ni uva avakeha kavaeave. Ke kenka sauqu aiqiqaa aquseha Pero vaiinki auku ntehama minkima ki: Ninavu qakavanovaka sa maini aniea, nenavu sa maihai ho vivaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ninavuqinkaio vohaiqavano ou ni qaka vika vareo maini aniaie. Viva via vikareva viaqe ke ni hini usa karavusaqima kaaia nenavu maini vaiqe ke ni uvaa quqaave unave kiae. Ke kavaaio ni uva una uva vaiea, ke niara maa vakanaasa ampeqiesa aniasave kiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Iosepeva minki kivaseo kaaramo enta visa karavusa naavuqi somanka vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Visa karavusa naavuqi mini vauvo kaaramo enta aikarovo Iosepeva anintero visa kiva nimio kihao, Ho ke Kotia uva ii vaua vaiinkisama vai uo. Ke vo uva kiai ne vi uvaa ho iivea, ke ni vehasuma nimikararave. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ne quqaa uva ki vai vaiinkisa vaivea, niqinkaio vovano maaqi karavusa naavuqi vaiama ne hini usa anirante ntara vare vuu nenka navunaasa sa ntara vakesa nimi, ");
INSERT INTO tbg_a_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","viaqaankai nenka qaka vika vare ke iainanaini munku saiqe kavaae. Ke via kave, niara quqaa uva ki vaiasave kihama ni vehasuma nimikararave, kio. Iosepeva minki kumanka visa eo kenavu minkieave kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","23","Iosepeva Isipi vakanaa uvaqinkaio ki vauvo vovano via uva uantaseo via vasausavaanavu kiva nimumankaa ki, visa Iosepeaa vo vakanaava vaihao sa kinavu uva ho iivo kivase, visa nái uvaqinkai nai kiva ami nai kiva ami iha kiha, Oho, haau kenavu kenkanavu qaka vo mantaiqama amikaavaunaa via saara Kotiva vake kinavu noa maara kimivo. Haau kinavu qakavano iqi rakehao kinavuaa sa minkiake kumanka kenavu sa via uva iiai, sa via aaquhikama amikaavaunaave. Via saara vake noa maaravano kinavuqi qovaama vio ivo, kinka. Visa hini usa minki kuvo Rubeniva kihao, Oho, vi entaa ke niara kiha, Sa via mantaiqama amikaake, kiavau ne ki uva iiakaa vaumanka sa ki uva iuave. Ne minkimase via arusoa saarama vake kinavuqaa noa uva vaio ivo, kio. Minki kumanka visa Iosepeva sa kinavu uva ho iianarove kivaseha nai kiva ami nai kiva ami i vauvo Iosepeva vaihao visa aiqava uva kua ho iua. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Iosepeva visa uva iuvo via munkusavano mantaiquvo viva visa vauaqaankaio uantavio nai vii qaqini vakeo evaara iqi rakaseo qaiqaa via auntavano ho uva kiaiava vauvo viva uanta vio sauqu aave vakehao nai saiqa vaiinkinavuaa kihao, Vi vaiinkiaqi karavusaqi saake, kumanka visa Simioniva nai qaka vasausavaa hampaka vau vaiinkia, visa via rumpa vare vuu karavusa naavuqi soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Via rumpa vare karavusa naavuqi vuu sovo Iosepeva nai saiqa vaiinki evaara kiva nimio kihao, Ne ntara vare visa uka mpiqa sehama visa silvaa munima nái nimihama visa ukaqi ntuva nimikaake. Aaraini viha vika ntara neavaka ntuva nimikaake, kio. Minki kumanka via saiqa vaiinkinavu Iosepeva kuntemase, ntara ntuva nimikoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Iosepea vasausavaanavu ntara ntuvako ukaa vaa vaai nái donki auvaqaqaa rumpase vakusa mini se nái maaqaini viesa vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Visa aaraini vuvo entama vumanka saiqe mini qaqi ntaka vaikaae kivase mini vauvo vovano nai ukaqinkaio ntara equseo saiqe kenka donki amiae kivaseo kavovo nai ntaraa aquso munimava ukaqi qaqi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Viaqi vauvo viva nai qaka vasausa naarama seo kihao, Maa kavaake. Ke silvaa munima mini ntaraa aqu sauava ukaqi qaqi vaio ivo, kio. Minki kumanka visa voqamase naaku ikomanka qekeha aiqu sauqu nti nti iha kiha, Oho, Kotiva kinavuaa nankihaoe minkivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Visa minki kivase ou vi Kanaha vakaini nái qova vaunaini ou nte visa nái nu vasaasaa Iakovoa kiva ami kiha, ");
INSERT INTO tbg_a_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Isipiqaa raqisi vaiinkiva kinavuaa kamoqara kihao, Ne Isipi vakanaasa ampeqiesa aniasave, kivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Viva minki kimanka kenavu kiha, Aqao, sa kenavu Isipi vakanaasa ampeqiea aniausaauve. Kenavu quqaa uvaqai kua vaiinkisama ani uo. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kenavu qaka vasausa 12 navu vauo kinavu qova vohaa vaiinkivanoqai vaio ivo. Kinavu qaka vovano quku vuave. Kinavu qaka vo naankiaraihainaava qaqi vaihao kinavu qosantio Kanaha vakainima vaio ivo, kuo ");
INSERT INTO tbg_a_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","vi vaiinkiva kihao, Ne quqaa uva ki vai vaiinkisa vaivea, niqinkaio vovano karavusa naavuqi vaiama ne hini usa anirante ntara vare vuu nenka navunaasa sa ntara vakesa nimi, ");
INSERT INTO tbg_a_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","viaqaankai nenka qaka vika vare ke iainanaini via vii saiqe ke via kavaae. Ke via kave niara quqaa uva kia vaiinkisave kihama niara sa maa vakanaasa ampeqiesa aniasave kiaave. Minki kivasema ke ni qaka vasaara vo karavusa naavuqi saainaa ninka nimiaima ne ho maini vaiha munima aquseha ntara varevaave, kiave. Mini Isipiqaa raqisi vai vaiinkiva kinavuaa minkima kiave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Minki kivase visa nái ntara ntuvako ukaa ontontiaqama seha kavovo visa ntaraa aquso silvaa munimava vo uka vo ukaqi qaqi vaumanka visavaka visa qovavaka voqamase qekeha vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","visa qova Iakovova kihao, Oho, ne aiqava ki vainkivaanavu kaiqa saesa auki variavo. Umpo, Iosepeva quku vuave. Simioniva sama vaio ivo. Ne Benaminiavaka mini vika vuu saesa auki variavo. Oho, vo ahasa vo ahasa maara ntai ahasava kiqima vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Minki kuvo Rubeniva nai qoaa kihao, Benaminia ki kimiaqe kire viaqaa raqisiqi vima qaiqaa nina vika vii amiae. Ke sa ourante nina vika vii amiaea, are homa ki maaqukanta aru senaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Minki kuvo Iakovova aqao kio, Sa ke kenka maaqu naankiaraama ai amiaiama vike vinaave. Via vasaava quku vuvo vivaqaima qaqi vaio ivo. Ne via vika vare vivo vo ahasavano via mantaiqama amikaiaqe ke erera sauhi vakausa munkusa mantaiqiaqe quku viaave. Sa ne ho via vike vivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Iakovova sa ho via vike vivaave kuvo sa ntara vau entava qaqi vaiqio vumanka ");
INSERT INTO tbg_a_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","visa Isipi vakaihai vare anu ntaraa nama kaiqa sovo visa qova visaa kihao, Ne anirante ou qaiqaa munima aquseha ampara ntara voqavaka vare aniake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Minki kuvo Iutiva aqao kio, Kenavu ai kiva amunaave. Isipiqaa raqisi vaiinkiva kinavu kikihao minkima kivo, Ne sa nenka qaka vo vike aniqe ke via kavaaea, ne sa ho ke iainanaini qaiqaa ani ntara vaevaave, kiave. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Are Benaminiavaka kinavu hampaka akikaiaqe kenavu via vakamase Isipini ntara varaea vuae. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Noa vaiinkivano minkima kivo: Ni qaka vovano sa ni hampaka kuviea, ne sa ke iainanaini ho anivaave kia, via saara are sa viavaka akikaiea, kenavuvaka sa ho mini viaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Minki kuvo Iakovova via vo auku Isiraiva kihao, Ne vi vaiinkia nenka qakaa sa kiva amiakaara vaimanka ne nenka qakaa via kiva amiaave. Ne viaa via kiva amiaraa kio, via saara kiqima noa maara ntai ahasava vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Minki kumanka visa kiha, Aqao, vi vaiinkiva vo uva vo uvaa kinavuvaka ki navunaasavaka iraiave. Viva kihao, Ni qova qaqie vaio ivo? Ni qaka vovano vaiove? kiave. Minki kivea, kenavu vi uvaa vi uvaa nai kiva amunaave. Kenavu nai kiva amiha sa kenavu viva nenka qaka maini vike kuvuake kireva i uvaa iiai, qaqi uva ki vauo viva nai vi uvaa kiave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Visa minki kuvo visaqinkaio Iutiva nai qoa Isaraiaa kihao, Are vi vainkia ki vakamasea akikaiaqe kenavu vaasa vuae. Kenavu sa vaasa vuaea, kinavu vainkivaavaka aevaka quku vivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kevano vi vainkiaqaa raqisiqi vieave. Vi vainkiva mantaiqama viea, are kiqaaqai vi uvaa vakenaave. Ke via vika vare ou ni ourante sa vii nina qaiqaa amiaea, via saara kiqaa uva vaiaqe ke aiqava enta qaqi vaiqi viha vi uvaa vararaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kenavu ntaraa vaasa vuakaarave. Kenavu vaasa vuae ki, homa kaara naini ou vi ourante anuntauaikiio, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Iutiva minki kuvo via uvavano mpeqaiquvo visa qova Isiraiva kihao, Ne mini quqaa viesa ivera, ne maihai soqe aiaia vare vi vaiinkia vuu qaqi amivo viva niara quahehaoma variaie. Vaakaqaa aqua vahaveaave, saaqa voqaa namaive, ntaraqaa aakaave, saivu voqaamave, vi ahasaa vi ahasaa vuu qaqi amiake. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nenta ukaqi kavaavo munima vaia, vi silvaa munimaavaka nai amiha qaiqaa voqavaka amiake. Vovano qumimaqa ihaoe ni ukaqi vi munimaa qaqi ntuva kaiave? Ne viaavaka ireha kavaake. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Nenta qakavaka vika vare vaasa vuake. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ne vi vaiinkia avuqaa ou vaivo Kotiva ni naaquhikama nimikaiao vi vaiinkiva ni qaka vasaara vovaka Benaminiavaka qaqi saiama ne vikanta ho ntika vare ourante aniake. Oho, ki vainki kaiqavi sa vaivea, kentaraama vaiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Minki kumanka visa aiaia vare, silvaa munima kaara naini vare, Benaminiavaka vika vare vua. Visa sante Isipini orunte Iosepeva vaunaini vuvo ");
INSERT INTO tbg_a_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Iosepeva Benaminia kaveo nai naavuqaa raqisu saiqa vaiinkiaa kihao, Are maa vaiinkinavusa ntika varea ki naavuqi vuu sea vurimakaua arusea nunka kaimanka vi vaiinkinavusa isaraqaa kivaka ntara naake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Minki kuvo via saiqa vaiinkivano Iosepeva kuntema seo, via vasausavaanavu Iosepea naavuqi ntika vuu soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Minkima seo ntika vuu somanka visa Iosepea naavuqi vuu soa saara naaku ikomanka kiha, Haau kinavu ukaqi ntuvako munimaa saarae viva kinavu maaqi vuu seo ivo? Viva kinavu ravaaqau seo rumpaseo, kinavu donkivaka vareo, kinavuaa ne karavusa vaiha ki saiqaqai qumina varaake kianarove, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Visa minki kivase ou naavu qentiana vaiha Iosepea saiqa vaiinkiaa kiha, ");
INSERT INTO tbg_a_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Noa vaiinkio, haau hoqare kenavu ntara vaaea anuausa maihai ani vare kenkanavu maaqaini anirante ");
INSERT INTO tbg_a_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","aaraini vuavauo entama vumanka aarana vaikaea iha kavaavauo kenavu ntaraa aqu saavauna munimaa kinavu ukaqi qaqi ntuva kova vauave. Vovano kinavuaa muara varaavo kianto ki, kenavu qaiqaa qaqi vi munimaa vare anuro ");
INSERT INTO tbg_a_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kenavu vo silvaa munimavaka ntara vaaea vare ani uo. Nai kavave munima kinavu ukaqi ntuva koave? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Visa minki kuvo Iosepea saiqa vaiinkivano kihao, Hove, sa qekaake. Ninavu vaiqavanovaka ninavu qoa vaiqavanovaka Kotiva, vivama vi munimaa ninavu ukaqi ntuva koave. Kema haau vi entaa ni munima varaavaunaave, kio. Minki kivaseo viva ou Simionia karavusa naavuqinkaio suvantu seo vika vareo visa vaunaini vii soa. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Simionia visa vaunaini vii seo Iosepea saiqa vaiinkivano visa ntika vuu Iosepea naavuqi seo visa nái aiqu mintuqaake kio, namai saqa nimio, visa donkivaka ntara nea nimio, ");
INSERT INTO tbg_a_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","visaa kihao, Ne isaraqaa Iosepea vakamase ntara nevaave, kumankaa ki, visa Iosepea amiesa vare anu ahasaa henuqamase vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Henuqama vake vahaaqaini vauvo Iosepeva mihaio anio nai naavuqi oiqekeo vumanka via qaka vasausavaanavu visa nái vare anu ahasaa vare, naavuqi oiqeke Iosepea amiha vakaini hiqintivi kankankaavi vaiha visa nái vii vakaini seha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Mintimase Iosepea avuqaa vauvo Iosepeva visa ireo, Nenavu vo? Nenavu hoe vaiavo? kivaseo viva qaiqaa visa ireo kihao, Ho ni qova sontaiqama viave kiava vo? Viva qaqie vaio ivo? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Minki kumanka visa kiha, Ai saiqa vaiinkivano kinavu qova, viva qaqi vaihao homa vaio ivo, kivase visa qaiqaa kankankaavi nái vii vakaini seha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Visa minkima Iosepea avuqaa vauvo Iosepeva visa aikukumaqio vihao nai noa via vainki, Benaminia kaveo visa ireo kihao, Ne nenka qaka naankiaraaave kiava, maa vivae vaio ivo? kivaseo Iosepeva Benaminiaa kihao, Ki maaquo, Kotiva ai soqema amikaaie ki uo, kivaseo ");
INSERT INTO tbg_a_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","nai qaka vii qaiqaa kavoaa kio, Iosepeva iqi rakaaiava aumanko vauvo viva viaqinkaio santeo ou vo rumuqi nariaraa vaihao nai qakaa iqi rakeo. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nai qakaa iqi raka seo Iosepeva nai viiqinkaio auquru nunka seo vuaqaia ukuseo, nai iqi rakoa kaiqa seo, qaiqaa aniranteo nai qaka vasausa vauaqi ou vaihao nai saiqa vaiinkinavuaa kihao, Ho ntara raaquake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Minki kivaseo Iosepeva vo kaintaqaa nariaraa oquvi vaumanka Iosepea saiqa vaiinkinavu ntara raaquse Iosepea amumanka Iosepea qaka vasausavaanavu vo kaintaqaa oquvi vaumanka ntara raaquse nimumanka Isipi vaiinki vonavu visa nariaraa vo kaintaqaa oquvi vaumanka ntara raaquse nimua. Isipi vakanaasa kiha, Kenavu Hiparu vakanaa vaiinkinavu hampaka ntara naaoave, ki, visa nariaraa vo kaintaqaa ntara ne vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Iosepea qaka vasausavaanavu ntara naesa uvo Iosepeva visa rairaseo vi kaintaaqaa vi kaintaaqaa oquvi vaiha ntara naake kumanka visa oquvi vaiha kavovo avuniaraqaankaio visa vasaava nai qakantioqai nai qakantioqai oquvio vaua. Iosepeva minkima avuqavuqama seo visa raira somanka visa viaa voqamase aako kaa iha kiha, Nankimaseoe viva kinavu nova kinavu vakakai osaraa ho iivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Visa minki kivase oquvi vaumanka Iosepea saiqa vaiinkinavu Iosepea kaintaqaankai ntara vare, visa nimiqi viha Benaminia amihama airi naini via ntara amua. Benaminia minkima amumanka visa aiqava ntaravaka namaivaka ho noa. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Visa ntara novo viaqaankaio Iosepeva nai naavuqaa raqisu saiqa vaiinkia kiva amio kihao, Ntara varea visa ukaqi mpiqasea visa ntaraa aqusaa munimaavaka visa ukaqi nai qaqima ntuva nimikaane. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Minkima sea ou ki silvaa kapa soqea varea visa qaka naankiaraama ukaqi via munima vakamasea ntuva amikaane, kio. Minki kuvo viva Iosepeva kuntema seo, minkima nimikoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Minkima nimikovo via qararaa visa nikikomanka Iosepea qaka vasausavaanavu visa nái donki hampaka nái maaqa viesa vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Visa nái maaqa viesa ou vi amparaiqaqai aaraini vuvo Iosepeva nai naavuqaa raqisu saiqa vaiinkiaa kihao, Santea vi vaiinkinavusa vakaqia vuane. Visa vinaini ou ntea visaa minkima kiane, Ki noa vaiinkivano ni soqema nimikaimanka ne nankihae nai mantaiqama amikaavo? ");
INSERT INTO tbg_a_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ne nankihae ki noa vaiinki kapa soqea muara varaavo? Viva vi kaparaqinkaio namai naiave. Viva vi kaparaqonkaio naankiara vo saiqa vo saiqavano qovaa iaina kavaaina kapava vaio ivo. Ne vi kaapaa muara vareha manta saiqa varaavo, kiane. Are minkima visaa kiane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Iosepeva minki kivaseo via akikovo via saiqa vaiinkivano santeo visa ou ntikaseo vi uvaa kiva nimumanka ");
INSERT INTO tbg_a_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","visa aqao ki, Nankihaae are kinavuaa minki kiarao? Kenavu sama via kapa muara vare ani uo. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Haau Kanaha vakaini kenavu silvaa munima kinavu ukaqinkai ranta saavaunaa, vi munimaa qaqi naima amunaave. Kenavu vi munimaa nai amuausaa ki, sama ai noa vaiinki naavuqinkai vo ahasavaka muara vararaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Are rantaqia vihaa kavaiao kinavuqinkaio vo vainki ukaqi vi kapava vaiea, homa vi vaiinkia aru sea kinavuvaka rumpa kaiaqe kenavu ai noa vaiinki via saiqa vaiinkima vaiaave. Sa kenavu via kapa muara vare ani uo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Visa minki kuvo Iosepea saiqa vaiinkivano kihao, Hove. Kaapa muara vareo aniaina vaiinkia, viaqaima ke rumpa saraave. Ne hini isa homa nenka maaqa qaqi vivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Minki kumanka visa vaasa nái uka nái uka vakaini vaavi se, no rumpa koa vantuse vakovo ");
INSERT INTO tbg_a_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Iosepea saiqa vaiinkivano visa vasaara ukaqinkaio naane ranta seo kavovo sa vauvo rantaqio vihao visa qaka Benaminia esaanaihainaara ukaqi ranta seo kavovo kapavano via ukaqi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Visa qaka ukaqi kapavano vaumanka visa kave, visa nái ukavaaqa nahaqu naahaqimase, voqamase qekeha visa nái ntara ntuvako ukanavua vara vaai nái donkiqaa rumpase anirante Iosepea vakusaini qaiqaa vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Visa Iosepea vakusaini anirante vuvo Iosepeva sa nai naavuqinkaio vevanteo viaio, qaqi viaqi vauvo Iutiva nai qaka vasausavaanavu hampaka Iosepea naavuqi oiqeke vaka ntaka hiqintivi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Iosepeva visaa kihao, Ne nana ahasae varaavo? Ne sae iriavo? Ke naankiara qovaa iaina ahasaa kave vauausama vai uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Iosepeva minki kuvo Iutiva kihao, Oho, kenavu nana uvae ho kiaave? Nana uvae kenavu kiaiaa are vi uvaa quqaave kihaa sa muara varaavo kiane? Sa kenavu minki kiaima uvava vaio ivo. Kenavu vaaqu saiqa varaunaraa kio, Kotiva kinavu qoa saiqa qoqaama seo ivo. Ho kenavu maa entaaqaankai rumpakesa voqaama vaiha ai saiqa vaiinkiqaima vaiaave. Via ukaqi kapa ranta sai vaiinkivavaka, kenavu via vasausavaanavuvaka, ai saiqa vaiinkiqaima vaiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Iutiva minki kuvo Iosepeva aqao kio, Sa ke ni aiqava rumpa karaave. Via ukaqi ki kapa ranta saina vaiinkiva, vivaqai maini vaihao ki saiqa vaiinkima varianarove. Ne hini asa homa nenka qova vainanaini qaqi vivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Iosepeva minki kuvo Iutiva Iosepea aumanko ou nteo viaa kihao, Umpo, noa vaiinkio, saiqae ke uva vo ai kiva amiae. Ke minki kiaiaa are noa vaiinki Pero vaiinki voqaama vaihaama sa ki kikiane. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Are haau kinavuaa kihaa, Ninavu qova qaqie vaio ivo ninavu qaka vovano vaio ivo kiaa ");
INSERT INTO tbg_a_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","kenavu kiha, Kinavu qova sontavano qaqima vaio ivo. Kinavu qova sontaiqama viva vaihao vainki vo vakakaivo qaqima nai qosantio vaio ivo. Vi vainkiva qaqi vaivo via vasaava quku vuvo vivaqai nai noa Raikea via maaquvano qaqi vaivoa kio, via qova voqama seo viaa antuqa aivo vaio ivo, kunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kenavu vi uvaa ai kiva amuaa are kihaa, Vi vainkia vika vare aniqe kevaka via kavaae, kiaama ");
INSERT INTO tbg_a_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","kenavu ariara kiha, Noa vaiinkio, vi vainkiva sa ho nai qoa mini seo anianarove. Viva nai qoa mini seo aniea, via saara via qova quku vuanarove, kunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kenavu minki kuaa are kinavuaa kihaa, Ne sa nenka qaka vika vare anivea, ne sa ho ke iainanaini kuvu ntara varevaave, kianaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Are minki kiaama kenavu qaiqaa kinavu qova vainaini vi ou nte are kiana uvaa via kiva amunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Via kiva amuo kinavu qova kihao, Anirante qaiqaa ou ntara varaake kimanka ");
INSERT INTO tbg_a_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","kenavu viaa aqao ki, Sa kenavu kenkanavu qaka vika vare vuaea, kenavu sa ho vi vaiinkiva vainanaini ho viaave. Kinavu qakavanovaka sa viea, kenavuvaka sa vieave, kunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kenavu minki kuo kinavu qova kinavuaa kihao, Ne iiaave. Ki naaka vovano qorainki vainki kaaraqanta vaka kimikeo ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Vovano kiqaankaio vio sa qaiqaa ouranteo anumanka ke viaa oho, qaasau vairivano via aruseo ruqeqaama seo ivo kivaseha sa via vii qaiqaavaka kavaunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ne maa vainkiavaka vika vare vivo vo ahasavano via mantaiqama amikaiea, via saara ke erera sauhi vakausa ki munkusa mantaiqiaqe ke quku viaave, kiave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Kinavu qova minki kiaa ki, kenavu sa via maaqu naankiaraama vika vare qaiqaa anirante vuaea, kinavu qova kavaiao via maaqu naankiaraava sa kinavu hampaka vaiao viva vaasama quku vuanarove. Via maaqu naankiaraava qaqi vaivoa kio, kinavu qova qaqi vaio ivo. Via maaquvano quku viao via qovavaka sa qaqi varianarove, qukuma vuanarove. Kenavu sa vi vainkia vika vare vuaea, via saara kinavu qoa munkusavano mantaiqiao quku vuanarove. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ke kenka qoaa minkima kunaave, Kema viaqaa raqisiqi vuaiao viva homa varianarove. Ke ourante sa viavaka vika vare aniaea, kiqaama aiqava enta vi uvava varianarove, kunaave. Ke kenka qoaa minkima kunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Noa vaiinkio, viaa iihaama kiqaima rumpa kaiaqe ke kenka qaka vakusa vare, maini vaiha ai saiqa vaiinki variaiao ki qaka viva nai vasausavaanavu hampaka qaqi vuaie. ");
INSERT INTO tbg_a_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ke sa via vika vare vuaea, nankimase ke kenka qova vainanaini ho viaave? Sa ho viaave. Umpo, sa ki kikikaiaqe kenka qova vainanaini ou vaiha via munkusavano nai maaqu saara mantaiqinaa kavaae, kio. Iutiva minki kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iutiva minki kuvo Iosepea munkusavano voqama seo mantaiquvo vaihao iuvo nai saiqa vaiinkinavu nivuqaa iqi rakaaiava aumanko vauvo viva aiqava nai saiqa vaiinkinavuaa kihao, Ne aiqava maaqinkai ki maini se vuake, kumanka visa vuvo sa vovanovaka vauvo Iosepeva nai qaka vasausa hampaka vaihao nai osaraa visa kiva nimua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Iosepeva kiva nimio voqama seo rakehao vaumantaa ki, Isipi vakanaasa voqi vausa viva iqi rake vaua iumanka aiqava Pero vaiinki naavuqi saiqa vare vausavaka Iosepeva iqi rakoa iua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Iosepeva nai qaka vasausaa kihao, Ke Iosepesave. Ki qova qaqie vaio ivo? kio. Minki kumanka via vasausavaanavu vi uvaa ii voqamase naaku ikomankaa ki, visa uva kiva sa ho vaumanka vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Visa minkima vauvo Iosepeva vainko aniake kumanka visa vainko anuvo Iosepeva kihao, Ke ni qakavano Iosepesama vai uo. Ne vo vakanaasa ki nimiha munima varomanta visa ki kivika vare maini Isipini vuu soave. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ho vake ne sa ki aaku qekaake. Sa vi uvava kinavuqaa vaio ivo kiake. Kotiva vo vaiinki vo vaiinki sa quku viai qaqi variake kio, ki kikikomanka ke naane maini ni nivuni aniavaunaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ntara sa variaina ihiva kaaraqantaqaima qovaama vio kaiqa vivo sauqu hiniu ihima qaqima vaio ivo. Sauqu hiniu ihi vaiinki nahenki sama ho ntara ukuse qantu nevaave. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ho Kotiva maa entaa iihaoma niara visavaka visa vainkintivaka sa quku viai qaqi vaiqi vuake kio, ki naane maini kikikeo kiqonkaio viva ni saihaqama nimikaiae. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ke viaa iihama sa niaa ne ki kikikaamanka anunaave kiaave. Kotiva ki vi aaraa aukimanka maini anunaave kiaave. Kotiva ki kikikaimanka maini ani vauo vivaqaima ki noaiqama saimanka ke Pero vaiinki via saiqa vaiinki avuniaasama vai uo. Ke aiqava Pero vaiinki via vakaqaa raqisi vauausave. Ke aiqava Isipi vakanaasaqaa raqisi vauausave. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ne sante vuu ki qoa kiva amiha minkima kiake: Ai maaquvano Iosepeva ariara minkima kivo, Kotiva ki noaiqama saimanka ke aiqava Isipi vakaqaa raqisiha vai uo. Are sa mini vaisea aniane. Vaasama ke iainanaini aniane. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Are homa maini Isipini vaihaa vaka vo Gosenini vainaave. Vi vakava ki aumankoma vaio ivo. Arevaka, nena vainkivaanavuvaka, nena nainkinavuvaka, nena sipisipivaka, mimivaka, vurimakauvaka, nena aiaia vakenaavaka, aiqava vi ahasaa vi ahasaa saku varea maini ani vaiaqe ");
INSERT INTO tbg_a_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ke aiqaa raqisiae. Ntara sa variaina ihiva sauqu hiniunavu qaqima vaio ivo. Are sa maini aniea, aevaka are vakena ahasavavaka vehiqama vivo. Minkimama ki qoa kiva amiake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Iosepeva minki kivaseo qaiqaa nai vasausavaanavuaa kihao, Nevaka ki qakavano Benaminivavaka ne ki kavaamanka ke quqaama Iosepesama vai uo. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pero vaiinkivano ki noaiqama sainaa ne anirante ki qoa vuu kiva amiake. Ne aiqava ahasa maini Isipini vaiha kaveavaka vuu ki qoa kiva amiake. Vi uvaa kiva amima, via vaasa vika varema maini aniake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Iosepeva minki kivaseo ou nai qaka Benaminia ukukeo iqi rake vauvo Benaminivavaka nai vasaara Iosepeaa iqi rakeo náikanta nai susuqe nai susuqe i vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Iosepeva nai qaka suseqehao iqi rakehao ou nai vasausavaa vohaiqa vohaiqa susuqama nimikeo. Viva visa susuqama nimikomanka visa Iosepea vakamase uva ki vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Iosepevavaka via qaka vasausavaanavuvaka uva ki vauvo Iosepea qaka vasausavaanavu aninto vasaasava Pero vaiinkivano vau naavuaqi vumanka Pero vaiinkivanovaka, via sana saiqa vaiinkivanovaka, vi uvaa iiha quaheha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pero vaiinkivano Iosepea kiva amio kihao, Nena qaka vasausavaanavuaa minkima kiane, Ne nenka donkiqaa ntara vaa vaai rumpa vare anirante Kanaha vakaini ou vi ou ntema ");
INSERT INTO tbg_a_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","nenka qoavaka, nenka vainki nahentivaka, ntika vare ourantema ke iainanaini kuvu vaiqe ke soqe vaka ni nimiai ne viaqaa vaiha soqemavi variake, kiane. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Nena qaka vasausavaanavuaa minki kivasea maa uvaavaka visa kiva nimiane: Ne maihai qosavaka qosa kaarivaka vare vuu saimanka ni vainki nahentivaka ni qovavaka viaqi vaihama ho aniake. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nenta hini aiaia mini seraa sama noaiqamase iriake. Maini Isipini soqe aiaia vaia ni aiaiaqaima varianarove kiane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Pero vaiinkivano minki kuvo Iosepeva nai qaka vasausavaanavu qosanavuvaka qosa kaarinavuvaka nimumanka Pero vaiinkivano kuntemase, visa anirante vuama. Visa vie uvo Iosepeva visa aaraini viha ne ntaraavaka nimio, ");
INSERT INTO tbg_a_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","visa vohaiqa vohaiqa qaraasa ukavaaqa nimio, Benaminia 300 silvaa munimavaka ukavaaqa sauqu hiniunavu vakama seo amio. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Iosepeva nai qoavaka aiaia amikeo. Maa ahasanavua nai qoa amikeo: donki sauqu hiniukanta amio donkiqaa vo aiaia vo aiaia soqe aiaia Isipi vakaihainaa vaa vaai donkiqaa rumpa keo donki vo sauqu hiniukanta nahe donki visavaka nai qoa amikeo, vo ntara vo ntara mparetive, vo ntarave, via qova aaraini anihao naaina ntaraa vi donkiaqaa rumpa amikeo. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Minkima seo rumpa amikeo Iosepeva nai qaka vasausavaanavu nikikomanka visa vie uvo Iosepeva visaa kihao, Ne aaraini viha sa nai aki nai aki iake, kivaseo visa nikikomanka vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nikikomanka Iosepea qaka vasausavaanavu Isipi mini se ou vi Kanaha vakaini nái qova vaunaini ou ntoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Mini ou nte visa nái qoa kiva ami kiha, Iosepeva qaqima vaio ivo. Viva Isipini vaihao aiqava vi vakaaqaa raqisihaoma vaio ivo, kinka. Visa minki kuvo Iakovova sa visa uvaa quaheo ne unahaama kiavo kumanka visa ");
INSERT INTO tbg_a_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","viaqaankai Iosepeva visa kiva nimu uvaa nái qoa kiva ami, Iosepeva qosa kaarinavu nimua nái qoa umiqovo visa qova Iakovova vi uvaa iio qosa kaarinavu kaveo, viaqaankaio via munkusavano soqe uvo viva quahaseo ");
INSERT INTO tbg_a_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","kihao, Ne quqaama kiavo. Ki maaquvano Iosepeva qaqima vaio ivo. Saiqe ke qaqi variainanko ou via kave, ho viaqaankai ke quku viaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Iakovova minki kivaseo viva aiqava nai u ahasaa saku vareo Isipini vieva vua. Viva aaraini vihao Besebaini ou nteo Kotiva nai qoa Aisaakiaqaa raqisuva vauvoa kio, ofaa vaaseo Kotia iha quara amikoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kotia iha quara amikeo entaqi Iakovova vaikehao kaira kave vauvo Kotiva via aarehao kihao, Iakovoo, Iakovoo, kuvo Iakovova kihao, Vo, ke mainima vai uo, kuvo ");
INSERT INTO tbg_a_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kotiva viaa kihao, Ke Kotisave. Ke ai qoa Vaiqavano vaihama viaqaa raqisi vauausave. Are sa qekehaa Isipini vuane. Qaqi vuane. Are Isipini ou vaiaqe ke ai vainkinki airiqama saaima visa noaiqamavi noa vakanaasama variake. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Are Isipini ou viaqe ke ainti vaiha aiqaa raqisiqi vi naankiara Isipi vakaihai are suvuaama kerausa vika vare maini qaiqaa vuu saae. Naankiara are qukie ina entaa ai maaquvano Iosepeva ai vakamaseo vaiaama are quku vinaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kotiva minki kuvo Iakovova Beseba mini seo vua. Viva vieva umanka via maaqunavu Pero vaiinkivano qosa kaarinavu nimua varase, nái naakanavuvaka, nái vainkinavuvaka, nái qoa Iakovoavaka, viaqi visa ntuva vare Isipini vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Visa Isipini vie iha visa Kanaha vakaini vaiha visa nái sipisipive vurimakauave mimive vakoa vare, aiaiavaka vakoa vare, Isipini vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iakovova nai maaqunavuvaka nai nainkinavuvaka aiqava nai vainki nahenki ntika vareo Isipini vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Iakovoa vakamase vaiinki nahenki Isipini vusa, visa nuku vaieva minkimama vaio: Rubeniva (Iakovoa maaqu ntara hunkavano) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenia maaqunavu: Hanokiva, Paruva, Hesaroniva, Kaamiva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simioniva Simionia maaqunavu: Jemueliva, Jaminiva, Ohaativa, Jakiniva, Sohaava, Sauriva. (Kanaha vakanaa nahenki vovano Sauria vaka koa.) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Rivaiva Rivaia maaqunavu: Gesoniva, Kohaativa, Meraariva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Iutiva Iutia maaqunavu: Eruva, Onaaniva, Seraava, Peresiva, Siraava. (Erusa Onaanisa Kanaha vakaini vaiha quku vua.) Peresia maaqukanta: Hesaroniva, Hamuriva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakaava Isakaa maaqunavu: Toraava, Puvava, Iopuva, Simironiva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuluniva Sebulunia maaqunavu: Seretiva, Eloniva, Iareriva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(Rubenivavata, Simionivavaka, Rivaivavaka, Iutivavaka, Isakaavavata, Sebulunivavata, vinavusa Riaa maaqunavu vauvo Riaava Mesopotemiaini vaihao vi vainkinavusa Iakovoa vaka amikoa. Riaava nahenki vainki vo Dainaa vaka koa. Riaa vainkivaka naintivata vaiesa 33 vaiinki nahenki vaua.) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaativa Gaatira maaqunavu: Sifioniva, Hagiva, Suniva, Esiboniva, Eriva, Arodiva, Areliva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseva Asea maaqunavu: Imunaava, Isavaava, Isaviva, Beriaava. Asea raavuavano: Seraava. Beriaa maaqukanta: Hebeva, Marakieriva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(Vi vainkisa 16 navu Siripaa vainkive naintive vaua. Labaaniva Siripaa Riaa amuvo Siripaava Riaa saiqa nahenkivano vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Iosepeva, Benaminiva. (Vikanta Iakovoa naaka Raikea maaqukanta vaua.) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iosepea maaqukanta: Manaseva, Efaraimuva. (Iosepea naakavano Asenaativa vi vainkikanta vaka koa. Asenaativa Potipea raavuavano vauvo Potipeva Isipi vakanaa vaiinki nahenkiaa iihao suaiaa via vaiqavanove kivaseo via aare vau vaiinkiva vaihao vakusa vo Onini vaua.) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benaminia maaqunavu: Belaava, Bekeva, Asabeliva, Geraava, Nemaaniva, Ehiva, Rosiva, Mupimuva, Hupumuva, Ativa. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(Vi vainkinavusa 14 navu Iakovosa Raikesa vainkivaka naintivata vaua.) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daaniva. Daania maaqu Husimuva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napataariva Napataaria maaqunavu: Jaseliva, Guniva, Jeseva, Siremiva. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(Vi vainkisa 7 navu Bilihaa vainkivaka naintivata vaua. Labaaniva Bilihaa Raikea amuvo Bilihaava Raikea saiqa nahenkivano vaua.) ");
INSERT INTO tbg_a_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iakovoa vainkivaka via naintivata Isipini vusa saara ntiea 66 navuma mini vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sa via maaqunavu naakanavu saara ntiai, qaqi via vainkivaka via naintivata saara ntuvase 66 ve ki uo. Iakovoa vainkive naintive Isipini vusavaka, Iakovoavaka, Iosepeavaka, Iosepea vainkikanta Isipini vakakosavaka, visa visa saara ntiea visa 70 navuma vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iakovova Isipini ou vihao nai maaqu Iutia naane akikeo kihao, Are ou Iosepea kiao Gosenini ani kinavu kivikaaie, kivaseo via Iosepeva vaunaini akikovo vuvo ");
INSERT INTO tbg_a_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Iosepeva nai qosa kaari henuqama vakoa viaqi vaai nteo nai qoa vika saeva Gosenini vio ou via vika seo nai qoa ravaaqavu ukukeo via susuqama seo vusaiqama seo nai qoaa iqi raka amikeo. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Iqi raka amikovo via qova Iakovova Iosepeaa kihao, Ho vake ke kenka kivuqo ai vii kave uo. Are quqaa qaqi variaama ki, ke quahehama quku viaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Iakovova minki kuvo Iosepeva nai qaka vasausavaanavuvaka, nai qoa vainki nahenkinavuvaka, kiva nimio kihao, Ke ou Pero vaiinkivano vainanaini vaiha viaa minkima kieave: Ki qaka vasausavaanavuvaka, ki qoa vainki nahentivaka, visa Kanaha vakaini variasa visa ke unanaini anintaavo. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Vinavusa sipisipiqaave, mimiqaave, vurimakauaqaave, raqisi vaiasave. Visa nái quaravaka aiaiavaka saku vare maini aniavo, kieave. ");
INSERT INTO tbg_a_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ke minki kivase Pero vaiinki kiva amiaiao viaqaankaio viva ni irehao, Ne nana saiqa varaasave? kiama ");
INSERT INTO tbg_a_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ne minkima kiake, kenkanavu qoa aanante, kenavu vainki naakiusa vaiha sipisipiqaave mimiqaave raqisiqi vi vauausave, kiake. Ne minki kivo Pero vaiinkivano niara, Ne homa Gosenini nenkaraa vaiha nenka quara vakamase vaiqi vivaave, kianarove, kio. Isipi vakanaasa sa quaraqaa raqisi vaiinkisa hampaka vohaaraqi vaieave kuaa kio, Iosepeva minki kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Iosepeva minki kivaseo viva Pero vaiinkivano vaunaini vio ounteo via kiva amio kihao, Ki qovavaka ki qaka vasausavaanavuvaka Kanaha mini se, nái quaravaka nái aiaiavaka aiqava varema maini Gosenini anintaavo, kivaseo ");
INSERT INTO tbg_a_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","viaqaankaio nai qaka vasausavaanavuqinkaio sauqu hiniunavu ntikeo Pero vaiinkivano vinavusa kavaaie kio, vinavusa vuu umiqoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Umiqovo Pero vaiinkivano vinavusa ireo kihao, Ne nenka maaqaini vaiha nana nana saiqa varaasave? kio. Minki kumanka vinavusa kiha, Kenavu kenkanavu qoa aanante quaraqaa raqisiqi vi vauausave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Minki kivase vinavusa kiha, Kanaha vakainivaka sa ntara vaivo kinavu quaravano ntara naaiava sa vaimankaa ki, kenavu Gosenini vaieave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Vinavusa minki kuvo Pero vaiinkivano Iosepeaa kihao, Ai qovavaka ai qaka vasausavaanavuvaka are iananaini aniavo. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Isipi vaka visa vakavakama varianarove. Are vaka soqea visa nimia visa nái quara vakamase mini variake. Visa qaqi saiama Gosenini variake. Are kavaia visaqinkai vonavu vurimakauaqaa raqisi saiqaa anomase kavaivea, vi vaiinkinavusa homa ki vurimakauaqaavaka raqisivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Pero vaiinkivano minki kuvo Iosepeva nai qoa Iakovoa vikeo vuu Pero vaiinkivano vaunaini sovo Iakovova via uva mantovo ");
INSERT INTO tbg_a_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pero vaiinkivano Iakovoa ireo kihao, Are nanki nankima ihie vaase iao? kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Minki kuvo Iakovova Pero vaiinkiaa kihao, Ke maa vakaaqaa vona vona vaiqi niha 130 ihi varase uo. Ki qovavaka ki saivaqavavaka airi ihi vakaini vaiqi vusa vaumanka ke sa visa aanante airi ihi vaiqi viai, ke vaiqi viha vusaai qukuqi viha mantaiqamavi vaiha vaiqi vunaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Minki kivaseo Iakovova nai sauqu kure ra seo Pero vaiinkiaa Kotiva ai soqema amikaaie kivaseo Pero vaiinki mini seo vuama. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iosepeva nai qoavaka nai qaka vasausavaanavuvaka ntika vareo Pero vaiinkivano kuntema seo, soqe vaka vaunaini visa vuu somanka mini vaua. Vi vakava aiqava Isipi vaka, vo vaka vo vaka aakara seo soqe vaka vauvo vakusa vo, Ramesesi kakaaqa vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Iosepeva visa mini vuu seo nai qoavaka, nai qaka vasausavaanavuvaka, aiqava visa vainki nahentivaka, viva visa ntara nea nimumanka visa ho neha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Vi entaa ntara sa qampiqovo Isipinivaka Kanaha vakainivaka sa ntara vaumanka vi vakanaasa vi vakanaasa ntaraa antuqa auvo sa visa mpeqa vaumanka vaiha ");
INSERT INTO tbg_a_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","visa ou Iosepeva vaunaihai munima aquseha ntara varovo Iosepeva vi munimaa vareo Pero vaiinki amua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isipi vakanaasavaka Kanaha vakanaasavaka ntara varaesa munima aquqi vivi vuu nái munima kaiqa soa. Isipi vakanaasa Iosepeva vaunaini ou nte kiha, Umpo, ntara qaqi kinavu kimiane. Are ntara sa kinavu kimiaqe kenavu quku vuaoave. Kinavu munima kaiqama vivo. Umpo, qaqi kinavu saihaqiane, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Visa minki kuvo Iosepeva kihao, Ni munima sa vaiea, nenka quara ki kimihama ntara varaake, kumanka ");
INSERT INTO tbg_a_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","visa nái qosave, sipisipive, mimive, vurimakauave, donkive, Iosepea amihama ntara varoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Vi ihia ntara sa vaumanka vi vakanaasa minkimaqi vuvo vo ihi anintomanka Isipi vakanaasa Iosepeva vaunaini qaiqaa ou nte kiha, Noa vaiinkio, kenavu maa uvaa quqeka saaoave. Kinavu munima kaiqama vivo kinavu quara vairi ainiqama vivo. Umpo, nana ahasae ai amiha ntara vararaave? Kintanavu vaakavanovaka kinavu vakavanovakaqaima qaqima vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Are sa kinavu ntara kimiaqe kenavu quku vuaoave. Umpo, are kinavu saihaqiane. Kenavu kenkanavu vaka vakamase kaiqa vuaoave. Are ntara kinavu kimihaama kinavuvaka, kinavu vakavaka, varaane. Kenavu Pero vaiinki karavusa vaiinki voqaama vaiha via saiqa vaa amikaaiao kinavu vakavano viainiqama vuanarove. Ntaravaka suvuvaka kinavu kimiaqe kenkanavu ukuseha namaqi viha qaqi variae, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Sa ntara vau entava manta entaqai vaumankaa ki, Isipi vakanaasa minki kuvo Iosepeva visa ntara nimihao Pero vaiinkiaa iihao visa vaka varovo visa vakavano Pero vaiinkiniqama vio. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Visa vakavano Pero vaiinki viainiqama vumanka aiqava Isipi vakanaasa Pero vaiinki via saiqa varosaqai vaua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Iosepeva ntara nimihao Isipi vakanaasa vaka vareo vo vaiinkinavu vakaqaima sa varoa. Vi vaiinkinavusa Isipi vakanaasa vaiqa nuku kure re vau vaiinkisa vauvo Pero vaiinkivano visa ho variake kio munima visa nimi vauvoa kio, Iosepeva sa visa vaka varomanta visa nái vaka qaqi ukukoa. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Iosepeva qaqi vaiinki nahenkiaa kihao, Ho ke ntara ni nimihama nivaka ni vakavaka varauo nevaka ni vakavanovaka Pero vaiinkiniqama vivo. Ho maa ntara suvua vare vakaqi vuu ukuake. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ntaravano qampiqeo mpeqaiqia ne ntara qantu vare rairase, kaaraqanta kaaraqanta nenka ukuke, vohaiqa Pero vaiinki amiake. Ne hini ntara ukukeha homa namaqi viha qaiqaa qukuqi vivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Iosepeva minki kumanka vi vakanaasa kiha, Noa vaiinkio, are ntara kinavu kimiaavea kenavu sa quku viai, qaqi vai uo. Umpo, are kinavu soqema kimikaarao. Kenavu homa Pero vaiinki via saiqa vaaqi viaave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Visa minki kuvo Iosepeva vi uvaa mpeqaiqama seo vakehao Isipi vakanaasaa kihao, Ne ntara ukukea nenka hini nehama hini Pero vaiinki amiake, kua. Maa entaavaka Iosepeva kivako uvava qaqima vaio. Isipi vakanaasa vaiqa nuku kure re vau vaiinkisaqaima nái vaka qaqi ukukeha vauvo visa vakavano sa Pero vaiinkiniqama vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Iakovovavaka via vainki nahentivaka Gosenini vaiqi viha airi aiaia vakomanka visa vainkintivaka airiqama vumanka visaa Isiraia vakanaasave kua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakovova Isipini 17 ihi vaiqio vio 147 ihi vaasova quku vua. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Viva quku vuaia entava aumanko vauvo Iakovovave Isiraivave nai maaqu Iosepea aarama seo kiva amio kihao, Are nena sauqu aiqiqaa aqusehaama nena hini sauqu ki avuntaaqaa vakehaama kiriara kihaama, Sa ai Isipi vakaqi quntama kareave, kiane. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ke quku vuaiaa are ki vaaka varea Isipi maini sea ki qoavaka ki saivaqaavaka quntama keaqi ki vaakavaka vuu mini quntama kaane, kio. Via qova minki kuvo Iosepeva kihao, Are kinantemase ke minkieave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Minki kuvo via qova kihao, Nena sauqu aiqiqaa aqusehaama ke quqaa minkieave kiane, kuvo Iosepeva ke quqaama minkieave kuvo viaqaankaio Isiraiva nai kaintaqaa vaikehao Kotia auku kure rehao vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Isuva vaihao vaiinki nahenki uva vo uantaseo kiva nimio, Kotiva vaiinki nahenkiqaa raqisiainaa maa uvaa via voqaama vaio ivo. Vaiinki vovano soqe suvu uiti suvu nai avukaqi ukukeo ");
INSERT INTO tbg_a_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ou entaqi nai navunaasa hampaka vaike vauvo via navukaava vovano aninteo uiti ukukoaqi numii uku amikoave. (Vi numiiva via saqive mareve uiti saqi mare vohaa vaivo via kavaqai sa vohaa vaiave.) Via navukaava numii uku amikeo vuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Uitivano numii vakamaseo vohaaraqi qampiqakeo amparaiqasa kava irakaeva auki vaumanka via saiqa vainkinavu kavovo vi numiiva uiti vakamaseo qampiqa keo vaumanka ");
INSERT INTO tbg_a_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","via saiqa vainkinavu vuu naaho qoa kiva amiha kiha, Noa vaiinkio, ae sae soqe suvu ukukaarao? Kaihaioe vi numiiva anio ivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Minki kuvo viva oho kio, Ki navukaava vovano numii uku kimikeo ivo, kumanka via saiqa vainkinavu via irehama, Hoe kenavu ou vi numiia nuqu saraave? kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","viva aqao kio, Sa numii via nuqu saake. Ne numii nuqu sehama uiti vakamase rauvusevoave. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Qaqi saivo uitivanovaka numiivanovaka vohaaraqi qampiqaaie. Uitivano mpeqaiqama viaqe ke ki ntara qantu vare anisaraama minkima kieave. Vi numiia naane keqase rumpa sema vuu iha quara kimikema viaqaankaima uiti keqasema vuu ki ntara naavuqima vuu kimikaake kiaave, kio. Isuva vi uvaa uantaseo kiva nimua... ");
INSERT INTO tbg_a_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Isuva vaiinki nahenki uva uantaseo kiva nimiqi vio viaqaankaio viva vaiinki nahenki mini seo naavuqi vumanka via vainkinavu viva vauaqi uu ntema kihama, Vaasa kianaa via navukaava numii via avukaqi uku amiko uvaa vi uvaa osara kiva kimiaqe iriae, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Via vainkinavu minki kuvo Isuva vinavusa kiva nimio kihao, Vaiinki vovano soqe suvu ukuko vaiinkiva vaieva ke visave. Ke vakaini vakakai vainkisa ke vi vaiinkisave. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vi vaiinkia avukaqi vau vakava vaieva via vaka aiqava maa vakaa aiqava naako vakama vaio ivo. Soqe suvuvano vaieva suvuvano Kotia uva iia vaiinki nahenkisama vaiavo. Numiivano vaieva sa Kotia uva iia vaiinki nahenkisama Satanaa vainkima vaiavo. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Via navukaava uku amiko vaiinkiva vaieva viva Satanavave. Ntara qantu vare anu entava vaieva aiqavaa entave maa vakaa kaiqaaina entava vaio ivo. Ntara qantu vare anu vainkisa vairesa visa naauaihainaasave. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Via saiqa vainkinavu numii keqa sema rumpa sema vuu iha quara amikontemase naankiara aiqavaa entaqaa minkima qovarai qianaove. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ke vakaini vakakai vainkisa vaiqi vi aiqavaa entaqaa ke naauaihainaasa nikikaaia visa oku ke raqisiaina vakaaqaankai ki vainki mantaiqama nimike vai vaiinki nahenkisa rumpa vare vaaqu saiqa vare vaisa rumpa vare ");
INSERT INTO tbg_a_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ntika vuu noa iha ikainaaqi aqu saimanka visa ihaqi vaiha iqi rakaqi viha aarai kenki kiha vaivaave. ");
INSERT INTO tbg_a_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Visa mini vuu aqusaimanka avuqavumase ni vaiinki nahenkisa suaivano ikainantemase ikaqi vivo Kotiva visa qova visaqaa raqisiqio via vaiqi vivaave. Ni aako vaiea vi uvaa osara iriake, kua. Isuva kuama. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Isuva ntara nimio viaqaankaio nai vainkinavu nikikeo kihao, Ne kaanuqi vaai nte varuva namai hini vankaraini ne naane ou vi vaiqe ke vaiinki nahenki nikikaaia nai maaqa nai maaqa vuake kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Minki kivaseo viva vaiinki nahenki nai maaqa nai maaqa mini nikikama seo viaqaankaio Kotia aaraeva veraa aiqinaqaa vuvo entama vuvo viva mini nariaraa vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kaanuvano vakaihaio niaa ntaka vauvo uvaivano visa viea unaihaio anuvoa kio namaivano kaanu veqa veqamaqi vi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Uvai uki vauvo namaivano kaanu veqa veqamaqi vi vauvo amparaiqasa aakikaeva uvo Isuva namai avu vau nuvaqi vio visa vunaini vumanka ");
INSERT INTO tbg_a_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","via vainkinavu kavovo viva namai avu vau ni vaumanka visa voqamase aaku ikomanka noaiqaase qeke vaiha oi oi kiha vaanave kiha vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Isuva vaasa visaa kihao, Mpeqaiqamavi qaqi variake. Ke visave. Sa qekaake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Isuva minki kuvo Pitaava kihao, Noavauvo, ae quqaa vaiea kiva kimiaqe kevaka namai auha vau ae vainanaini vuae, kio. Pitaava minki kuvo Isuva ho kuvuane kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kuvo Pitaava kaanuqinkaio vaavi nteo kaanu mini seo namai avu vau Isuva vaunaini vio. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Viva mini vihaoma ho viae kivaseo kavovo uvaivano voqamaseo uki vauvo viaa iihao viva qekehao viaqaankaio namaiqi kukuvieva auki vaihao Isua aaramaseo, Noavauvo, ki ukuvaraane, kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isuva vaasama nai sauqu kukuseo via ukuvaeo kihao, Ae sa uvaivano ukiaa iiakaa kiriaraqai iiakaave. Sa kiriara kaara aako iriane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Isuva minki kivaseo visanti kaanuqi vaai ntovo uvaivano vaasa kaiqa vumanka ");
INSERT INTO tbg_a_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","via vainkinavu kaanuqi vausa Isua quahama amikeha kiha, Ae quqaama Kotia maaquvano variarao, kio kuama. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Isuva minki kuvo Isua 12 vainkinavuqinkaio vo vaiinkivano via auku Iuntaasi Ikeriotiva veva nteo Kotia saiqa vara amike vau vaiinkisa visa noa vaiinkinavu vaunaini vio ");
INSERT INTO tbg_a_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ou visa ireo, Ke Isua ni sauquqi vuu kuka saaea ne nana soqaae ki kimivaave? kumanka visa oi munima 30 navu saara ntuvase amuvo Iuntaasiva vi munimaa vaeo ");
INSERT INTO tbg_a_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","vi entaaqaankaio nai visa sauquqi Isua kuka saaina aaraa aikukiha vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa noqavi mpareti saraa ovaka naaina entanavuva ani ntovo hoqarenaa entaqaa via vainkinavu Isuva vaunaini aninte kiha, Karaqie kenavu ou henuqama amikaaiaa ae vehasumako entaa iihaama vi ntaraa nenaave? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Vinavusa minki kuvo Isuva kihao, Nenavu Ierusaremi vakusaini ou vi vaiinkiaa minkima kiake. Kinavu maara ki vai vaiinkiva kihao ki entama aninteo ivo. Ke kenka vainki hampaka ai naavuqi vehasumako ntaraa naeave kio ivo kiake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Isuva minki kumanka via vainkinavu vi ntaraa kuntemase henuqama vakoa. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Henuqama vakovo entuvo Isuva nai vainkinavu hampaka ou ntara kaintaqaa oquvi vaihao ");
INSERT INTO tbg_a_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ntara nehao kihao, Ke kiaima iriake. Niqinkaio vovano navukaasa nivuqaa ki qovarama saanaove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Minki kuvo via vainkinavu munkusa mantaiqumanka vinavusa vohaiqa vohaiqa Isua irema, Noavauvo, ae kiriarae ki variarao? Sa ke visavauve, sa ke visavauve, kivaqi vi. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Minki kivaqi vuvo Isuva kihao, Nai mpareti varaseo ki vakamaseo kanuqi vaaki quntaaseo ne vaina vaiinkiva vi vaiinkiva ki qovarama saanaove. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ki vakaini vakakai vainkisa kiriara vekanko entaqaa minkima ki haruseaa qara ntuva koave. Vi uvava vivauma vaianaove. Ki vakaini vakakai vainkisa qovarama saaina vaiinkiaa oho kiva amike uo. Via nova sa via vakakaiaqe hove kiakaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Isuva minki kuvo Iuntaasiva via qovarama saaiava Isua ireo, Maara ki variara vaiinkio, kiriarae ki variarao? kuvo Isuva kihao, Eo, ae kianaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Isua vainkinavu ntara ne vauvo Isuva mpareti ntara varaseo Kotiaa soqema iarao kivaseo nkuiseo nai vainkinavu nimio kihao, Maa ntaraa vara naake. Maa mparetiva ki vaakama vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Minki kivaseo viva uaini namai viaqi vau kaapaa vaaseo Kotiaa soqema iarao kivaseo vinavusa viki nimihao kihao, Ne aiqava maa namaia naake. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Maa namaiva ki naarema vaio ivo. Kotiva vaiinki nahenki hampaka vohaaraqi ruvaantumavi vaieva qaraasa uva vakaevave. Vi uvava mpeqaiqama vuaie kio ki naarevano vi uvaa mpeqaiqama saanaove. Ki haru saivo ki naarevano ntehao airi vaiinki nahenki saihaqihao visa manta uva nunka nimikaanaove. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ke kiaima iriake. Maa entaaqaankai ke sa uaini namai qaiqaa naeave. Ke sa narai minkiaqi vuaia ne ki qova raqisiainaaqi ki vakamase ou vaiqe vi entaaqaa ni hampaka vaiha qaraasa uaini namai naeama ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Isuva minki kivaseo nai vainki hampaka Kotiaa ihi kivaseo veva nteo Orivi aiqinaqaa vuama. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Vinavusa mini vuvo Isuva vinavusa kiva nimio, Nenavu vake entaqi ki maini sema aiqu aukuke santama vivarae. Kotia vukaqi qara ntuva ko uvava vake vivauma vaianaove. Minkima kio: Sipisipiqaa raqisina vaiinkia Kotiva via ruquku saia sipisipi visa qekase nariara nariara vona vona vivaave, kuave. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ho naankiara ki vaa qaqi himpima saiaqe vaiha ni nivuni ke naane Kariri vakaini vieave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Isuva minki kuvo Pitaava aqao kio, Aiqava vinavusa ai maini se aiqu aukuke santama vivea keqai ainti maini vaieave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pitaava minki kuvo Isuva kihao, Ke kiaiama iriane. Vake entaqi kokoraavano sa uva kiaa ae kaaramo naini kiriara kihaa sa via kavaunaave kinaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Isuva minki kuvo Pitaava aqao kio, Ke sa ariara sa kavaunaave kiaave. Ai vakamase kivaka haru saivea sa ke minki kiaave, kio. Pitaava minki kumanka Isua vainki hini usavaka vi uvaaqai kua. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Viaqaankaio Isuva nai vainki hampaka ou vio saqava ukukoaqi via auku Kesemani viaqi ou nteo nai vainkinavuaa kihao, Nenavu maini oquvi vaiqe ke vuuni ou Kotia aaraae, kivaseo, ");
INSERT INTO tbg_a_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pitaaravaka Sepakia maaqukantavaka vinavusaqai ntika vaeo mini vihao noa aako iuvao via munkusavano mantaiquvo ");
INSERT INTO tbg_a_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","viva kaaramonavuaa kihao, Ki munkusavano noaiqaaseo mantaiqama ihavihao ki haru saeva voqaama vaimanka vai uo. Nenavu maaqaa vaiha ki vakamase vaiha avu rampai sehama aikukiha variake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Minki kivaseo viva amparaiqasa ou vio viihaio ou vakaini hiqinti vio Kotia aarehao kihao, Umpo, ki qo, ae hove kiea ke ihavina namaia naainaa voqaama ae vi namaia qaqini vaa kimikaane. Ho sa ke kenka varaakaa iraqe vaaeave. Ke ae varaakaainaa vaaeave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Isuva minki kivaseo uuranteo nai vainki kaaramonavu sonaini kuvu kavomanka vinavusa avu kauntomanka vaike vauvo viva Pitaaraa kihao, Nankihae ne kaaramonavu ki vakamase amparaiqa vaiha sa avu rampai seha aikukiha vaiavo? ");
INSERT INTO tbg_a_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ninavuaa vinavusa manta saiqa varaake kio Satanava ninavu avakaantoa viaa iiha aikuki vaiha Kotia aareha variake. Ninavu maraquavano minkiakaa ivo ni vaakavanoqai sa ho mpeqaiqimanka vaiavo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Isuva minki kivaseo qaiqaa kaaramonavu mini seo ou qaiqaa Kotia aarehao kihao, Umpo ki qo, maa kaapaqia vaina namaia sa ae qaqini vaa saraia qaqi naane kiea ke ae varaakaainaa varaeave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Minki kivaseo qaiqaa ouranteo kuvu kavovo via vainki kaaramonavu avu kauntomanka vaikake vinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Vinavusa vaikake vauvo Isuva qaiqaa vinavusa mini seo qaiqaa ou vio Kotia kaaramo naini aarehao vaasa kuntema seo qaiqaa kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kotia aarama kaiqaseo Isuva ouranteo kaaramonavuaa kihao, Ise, nenavu ho ihae vaike vaiavo? Ho kavaake. Ki entama aninteo ivo. Ki vakaini vakakai vainkisa ki ravaaqau vare vuu qoa saiqa vare vaisa sauquqi kuka sevaave. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Himpiqenavu vuae. Ki qovarama saaia vaiinkiva anima vaio ivo, kio... ");
INSERT INTO tbg_a_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","...Isuva minki kumanka visa via ravaaqau somanka via vainkinavu via mini se aiqu aukuke vuama. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Via vainkinavu aiqu aukuke vumanka Isua ravaaqau kosa via vika vare Kotia naavuqi saiqa vare vausa visa avuniaa vaiinkivano vauaqi Kaiapaasia naavuqi vuu somanka vi naavuaqi maara osara ki vau vaiinkinavusavaka Iuntaa vaiinki noanavuvaka usi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Isua vika vuu se vauvo Pitaava niaraihaio visa avakaqi vio Kaiapaasia naavu vakusaini ou nteo uvisaqinkaio vaakinteo avukaqi vio vi ahasava qovarai qiainaa kavaeva ou vi naavua maintaraa raqisi vau vaiinkinavusa hampaka oquvi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pitaava mini vahaaqaini vaumanka naavuqi Kotia naavuqaa raqisu vaiinkisavaka aiqava viaqi usi vau vaiinkisavaka visa Isua arusaesa Isuaqaa una uva vakaae kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","sa vi uvava vaumanka qumina vi uvaa rantehama vo vaiinki vo vaiinki himpi Isuaa una uva kua. Minkimaqai kumanka viaqaankai vaiinki kaaraqanta himpi ");
INSERT INTO tbg_a_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Isuaa kiha, Maa vaiinkiva minki kimanka kekanta iunaave. Viva kihao, Ke homa Kotia naavu rampai aquse viaqaankai kaaramo entaqai vaiha vi naavua qaiqaa saqa kaiqa saraave kiave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Vikanta minki kuvo Kotia saiqa vaa amike vausa visa avuniaa vaiinkivano himpio Isuaa kihao, Vikanta minkima aiqaa uva vakeha ki vaiavo. Ae vo? Naikantaa nana uvae kinaave? kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Isuva sa uva kiaio evaara vauvo qaiqaa avuniaa vaiinkivano Isuaa kihao, Ke Kotia avuqaa vaiha via auku ntehama ariarama quqaa uva kiane ki uo. Quqaae Kotiva ai akikaivaae ae kinavu saihaqiava mesaia vaiinkivano variarao? Quqaae ae Kotia maaquvano variarao? Kinavu kiva kimiaqe iriae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Viva minki kuvo Isuva kihao, Ae kianaa ke maa visave. Ke kiaima ne iriake. Ne naankiara kavaiqe ke vakaini vakakai vainkisa noaiqamavi Kotiva mpeqavano vaiainanaini via sauqu kanaraini oquvi vaiha konavuqaa kuvieave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Isuva minki kuvo Kotia saiqa vaa amike vausa visa avuniaa vaiinkivano nai ukavaaqa nahaqu aquseo kihao, Oho, viva Kotia avuqaa vaihao vaaqu uva kio ivo. Vo vaiinki viaqaa uva vakaaina vaiinkia qumina aarevoave. Kavaake. Ne ii vaiavo viva Kotia avuqaa vaihao vaaqu uva kio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Via saara ne Isuaa nana uvae kivaave? Kiqe iriae, kio. Minki kumanka visa kiha, Via vaaqu saiqa urimakareo ivo. Via saara via arusaaiavaqaima vaio ivo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Visa minki kivase ou Isua viiqi kaara vihise visa nai sauquqo via ruqukuse via avu aako ruqema aquseha ");
INSERT INTO tbg_a_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","visa ruheha viaa kiha, Mesaia vaiinkio, ae quqaa uva qoqaiqama sea vaiinkiva vaiea sa kavaraia ai arina vaiinkia auku ntaiaqe iriae, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Naavuqi minkiaqi vi vauvo Pitaava vahaaqaini vakusaqaa oquvi vauvo saiqa nahenki vovano Pitaara aumanko vio viaa kihao, Aevaka Isua Kariri vakaihainaa visanti variaravave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Viva minki kuvo Pitaava visa nivuqaa vaiha aqao kio, Ae kiana uvaa sa ke ii uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Viva minki kivaseo ou uvisa qentiana vauvo saiqa nahenki vovano via kaveo mini himpi vausaraa kihao, Maa vaiinkiva Isua Naasaretihainaa visanti vaivave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Minki kuvo Pitaava sauqu aiqiqaa aquseo kihao, Sa ke vi vaiinkia kavaunaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Minki kivaseo amparaiqa vaumanka mini himpike vausa Pitaava vaunaini ou nte viaa kiha, Isua vainkinavu vi vakanaasa vaiavaa quqaama aevaka vohaa vi vakanaavaqaima variarao. Visa uantase maa uvaa ki vaiantema sea aevaka ki variarao, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Visa minki kuvo Pitaava sauqu aiqiqaa aquseo kihao, Ke sa quqaa uva kiaio Kotiva ki homa haruanaove. Ke quqaama ki uo. Ne ki vaia vaiinkia sa ke via kavaunaave, kio. Pitaava minki kuvo vakeni kokoraavano uva kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pitaava viaqaankaio Isuva kiva amu uvaa iikeo. Isuva minkima kuave. Kokoraavano sa uva kiaa ae kaaramo naini kiriara sa via kavaunaave kinaave ku uvaa iikeo viva aaqaini vuvo via munkusavano mantaiquvo iqi rakoa... ");
INSERT INTO tbg_a_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Entuvo Arimatihainaava airi aiaia vake vau vaiinkiva ou nteo. Via auku Iosepeva viva Isua vainki vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Vi vaiinkiva ou nteo Pairaativa vauaqi ou Isua vaaka kimiaqe quntama saae kuvo Pairaativa nai sontia vaiinki nikikeo Isua vaaka via amiake kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosepeva ou via vaaka sakaiqaankaio viqu munkuvi seo qaraasa kavuna eqara kavuna varaseo via apuqama seo ");
INSERT INTO tbg_a_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","munku nai qukuainaa iihao vaka ntukoqaqi qaraasa oi ntukoaqi vea vakeo noa oi vo via veqa vaeo oi ntukoa via nona vii kinkaseo mini vumanka ");
INSERT INTO tbg_a_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariava Makataahainaavavaka via varanova vo Mariavavaka vikanta oquvi vauvo vukua hini vantaraini Isua quntamako oiva vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Qaiqaa Isuva varuva namai avaini ou vaihao vaiinki nahenki uva vasaasa kiva nimiae kumanka vaiinki nahenki airinti ruvaantumavi via ukukuma sovoa kio viva qaqia seo kaanuqi vaainteo viaqi oquvio namaiqaa vaumanka vaiinki nahenki vuku vantaraini namai ausini vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Visa vakaini namai ausini vauvo Isuva vo uva vo uva uantaseo kiva nimio. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Viva kihao, Ke kiaima iriake. Vaiinki vovano suvu qintaeva vuave. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Viva suvu qintaqi vuvo hini suvuvano aara ausini hiqintuvo uviivano ani nama aqu soave. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Minkuvo suvu hininavuvano oi vakaqaa hiqintuvo vakavano sa vevakoma vau vakava vauvoma kio hiqivio vaasa qampiqa kovo ");
INSERT INTO tbg_a_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","suaivano uunteo ikehao aahara usu sovo via kuqa sa veva nto oku vuaa kio aahara usu vuave. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Minkuvo suvu hininavuvano numii qampiqoaqi hiqivio numii hampaka qampiqa kovo numiivano ravaaqau sovo sa kavavaka irovo. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Minkuvo suvu hininavuvano soqe vakaqaa hiqivio soqema seo qampiqehao vuu soqe kava irakovo hini suva via aakara seo qampiqehao vuu soqe kava airi kava irakovo hini suvavaka via aakara seo soqe kava airi kava irakoave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Isuva vi uvaa uantaseo kiva kaiqa seo kihao, Ni aako vaiea vi uvaa osara sankunkase iriake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Isuva uva kiva nimi kaiqa somanka vaiinki nahenki nai maaqa nai maaqa vuvo Isuva nariaraa vaumanka via vainki 12 navuvaka vo susavaka viva vaunaini ani nte Isuva uva uantaseo ku osaraa sa iirai viraa irovo ");
INSERT INTO tbg_a_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Isuva kiva nimio, Kotiva vaiinki nahenkiqaa raqisiaina uvaa quqekakai uvaa vi uvaraa Kotiva niara visa qaqi saia vi uvaa osara iriake kivaseo qaqi vaiinki nahenki aaqaini vaisaa vi uvaa osara sa vukusea kiva nimiane kivea ke vi uvaa uantase visa kiva nimi vai uo. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ke uva uantase kiaima vaiinki nahenki kavehama sa sankunkase kavevaave. Visa ki uvaa aako kara i vaiha sa anoma iivaave. Visa ki uva iihama visa nai manta saiqa qaqia saivovauve Kotiva visa nai manta saiqa vare uvaa nunkama nimikaanaove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Isuva minki kivaseo vinavusaa kihao, Ne vo? Ke uva uantase kuna osaraa sae iriavo? Ne sa vi uvaa osara iirai ke naankiara uantase kiaina uvaa ne nankimase ho iivaave? ");
INSERT INTO tbg_a_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ke vaasa uva uantase kuna osaraa kieave. Vaiinkivano suvu qintakoa vi uvaa osara vaieva Kotia uvama vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Suvu aaraqaa hiqintu uvaa via osara vaieva vaiinki nahenki hininavu via suvu voqaama vaiaave. Vi vaiinki nahenkisa Kotia uva iiavo Satanava ani nteo visa munkusa aakoqinkaio raqia saiave. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hini vaiinki nahenki oi vakaqaa hiqintu suvua voqaama vaiaave. Vinavusa Kotia vasaasa ii vi uvaraa quahamase vaiavo ");
INSERT INTO tbg_a_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","uvavano sa visa munkusaqi oku vimanka vi vaiinki nahenkisa sa vaivaqaima vaiqi vi sa vi uvaa iirai vaiamanka vi uvaa saara vo sisa visa mantaiqama nimikaesa auki vaiamanka visa ki haruanto kiha Kotia uva vaasama qaqiase vaia vaiinki nahenkisa vaiaave. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hini vaiinki nahenki numii qampiqoaqi qintako suvua voqaama vaiaave. Vi vaiinki nahenkisa Kotia uva ii ");
INSERT INTO tbg_a_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","viaqaankai visa vakaihainaa ahasaa noaiqamase iiqi viha munima aiaiaa quahaseha vo ahasa vo ahasa varaesa iiqi viha Kotia uva qaqia saavo Kotia uvavano sa vi vaiinki nahenkisaqi vaivaiqama vaiqi vi vaimanka vaiaave. ");
INSERT INTO tbg_a_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Visa minki vaiamanka hini vaiinki nahenki soqe vakaqaa qintako suvua voqaama vaiaave. Vi vaiinki nahenkisa Kotia uva ii vi uvaraa quqaave kivase vi uvaa iiqi viha soqe saiqa Kotia vara amikaqi vi vaiaave. Hini vaiinki nahenki vi uvaa iiha soqe saiqa Kotia vara amikaqi vi vaiamanka hini vaiinki nahenki visa naakarase Kotia saiqa soqemase vara amikaqi vi vaiamanka hini vaiinki nahenki visa saiqa naakarase uikare Kotia saiqa soqemase vara amikaqi vi vaiaave, kio. Isuva kuama... ");
INSERT INTO tbg_a_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Vi vakanaasa Isuaa sa maasa maaqaini variane kuvo Isuva kaanuqi ani ranteo namai kaqa vareo varuva namai hini vantaraini vumanka mini vaiinki nahenki airima ruvaantumavi viva vaunaini ukukumavi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","vaiinki vovano vi vakusaaqi maara naavuqaa raqisi vauva Sairaasiva ani nteo Isua kaveo via aiqukaaini hiqinti vio Isuaa ");
INSERT INTO tbg_a_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","umpo ise kihao, Ki raavuauvano quku vuaiava aumaiqio ivo. Ae ania nena sauqu viaqaa vakaiao via auriaavano kaiqa viao ho qaqi vaiaie, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Vi vaiinkiva minki kuvo Isuva visanti vua... ");
INSERT INTO tbg_a_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","...Isuva visanti aaraini vi vaumanta vaiinkinavu Sairaasia vikase viaa kihama, Ai raavuavano qukuma vio ivo. Maara ki vaina vaiinkia sa qaiqaa ravaaqavu saane, kuvo ");
INSERT INTO tbg_a_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Isuvavaka vinavusa uva iio maara naavuqaa raqisi vau vaiinkiaa kihao, Sa qekaane. Kiriara mpeqaiqihaa variane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Isuva minki kivaseo viva Pitaaravaka Semisiavaka Semisia qaka Iohaneavaka vinavusaqai ntika vareo ");
INSERT INTO tbg_a_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sairaasia naavuqi ou nteo kavomanka vaiinki nahenki noaiqamase oi oi kiha umpo ise kiha iqi rake vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isuva naavuqi oiqekeo kihao, Nana ahasaae iqi rake vaiavo? Vi nahenki vainkiva sa quku vio ivo. Viva qaqi vaikema vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Isuva minki kumanka visa Isua uvaa naahaama amike vauvo Isuva aiqava vaiinki nahenki vara veva vahaaqaini seo nahenki vainkiu via nosa qosavaka kaaramonavu nai vakamase anusavaka vinavusaqai ntika vareo nahenki vainkiu quku vunaini ou nteo ");
INSERT INTO tbg_a_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","via sauqu ukuvareo nai uvaqinkaio kihao, Tarita kumi, maa nahenkivauvo, ke ariara himpuanema ki uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Isuva minki kuvoma vi nahenki vainkiuva vaasa himpio nio. Viva 12 quara varaseo himpio ni vaumanka vinavusa via kave rankumavi voqamase sauqu runkinkii i vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Isuva vinavusa nikihao kihao, Ho maara kavaaraa sama voa kiva amiake. Maa nahenkiua ntaraqai amiake, kuama. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","... Vi entaa vaiinki nahenki airinti Isua kavaesa vi ani vaumankaa ki Isuvavaka via vainkinavuvaka sa ho ntara narai vaua. Minkuvo Isuva kihao, Varaiqenavu ou qumina ntaka kenkanavu vaiaia nenavu via voka variake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Isuva minki kivaseo vinavusa ntika vaeo kaanuqi vaai nteo qumina ntaka vieva vua. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Vinavusa mini se vumanka airi vaiinki nahenki vinavusa kave vinavusa vie unainiaa iikaiqa vo vakusaqinkai vo vakusaqinkai visa sante varuva auhianta vakantuna ou Isuva vieva unaini visa naane ou nte vinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Visa naane ou ntovo Isuva ou nteo kaanuqinkaio vakaini vaavi nteo vaiinki nahenki airinti ruvaantuma vusa kaveo visaa naaquhikama nimikeo kihao, Ise, vaiinkivano sa raqisi vaimanka sipisipi nai niniha ni vaia sipisipia voqaama maa vaiinki nahenkisa vaiavo, kio. Minki kivaseo viaqaankaio Isuva uva vasaasa visa kiva nimi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Isuva kivaqi vuvo suai vikini kuvi vumanka Isua vainkinavu viva vaunaini ou nte kiha, Suaivano vikini kuvi vivoma maini qumina ntakave. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ae vaiinki nahenki nikikaia ou vo vakusa vo vakusa niha munima nimiha ntara varaake. Visa sa ntara ntuvavae aniasave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Via vainkinavu minki kuvo Isuva aqao kio, Nenavu visa ntara nimiake, kio. Kumanka vinavusa Isua irehama, Kenavu noa munimae 200 kinaae aquseha ntara varase nimiaave? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Minki kuvo Isuva vinavusa irehao, Nanki nankimae mpareti ntara ntuvavae aniavo? Ou kavaake, kumanka vinavusa ou kavamase vii kiva ami, Mpareti ntara vohaa sauqu hiniuqaima vaio ivo. Hampusa kaaraqantaqaima vaio ivo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Via vainkinavu minki kuvo Isuva vaiinki nahenki kiva nimio, Ne aiqava vo ntaka vo ntaka usauntaka oquvi variake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Minki kumanka visa vo ntaka 100 navu oquvi vaumanka vo ntaka 50 navu oquvi vaumanka minkiaqi vi aiqava vaiinki nahenki oquvi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Isuva mpareti sauqu hiniunavu vaaseo hampusa kaaraqanta vaaseo naauaini aikukihao Kotiaa soqema iarao kivaseo mpareti nkuiseo vi ntaraa nai vainkinavu nimio kihao, Ho vae vuu nimia aiqava naake, kivaseo hampusa kaaraqantavaka raira seo aiqava vaiinki nahenki nimio ");
INSERT INTO tbg_a_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","vi ntaraa raira nimumanka vaiinki nahenki aiqava homa nanka. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ho nomanka Isua vainkinavu viaqaankai rukantuko ukaa noa uka vare vaiinki nahenki neha rausuko mparetiavaka hampusaavaka nunku vare ukaqi ntuva keha 12 uka mpiqa soa. ");
INSERT INTO tbg_a_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vi entaa vaiinki airinti 5,000 vaiinki vi ntaraa ho noa... ");
INSERT INTO tbg_a_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Isuva nai vainki hampaka ou vio Ieriko vakusaini ou nteo vi vakusaa vara mini saeva auki vaumanka vaiinki nahenki airinti via vakaqi vi vauvo avu qimpavu vaiinkiva Vaatimiasiva, Timiasia maaquvano vaihao aiaia naauihao kimiake ki vau vaiinkiva aara ausini oquvi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Viva mini vaihao Isuva Naasaretihainaava aikaraainaa iio viaqaankaio viva noaiqamaseo Isua aarehao kihao, Isuo, Ntevitia maaquo, kiriara umpo ise kiva kimikaane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Avu qimpavu vaiinkiva minki ki vaumanka airi vaiinki nahenki via akihama kinka, Ae nena no kinkaane, kinka. Kuvo viva sa visa uva iirai qaiqaa voqama seoma aararo, Ntevitia maaquo, kiriara umpo ise kiva kimikaane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Minki kivaqi vuvo Isuva ani viaqaa himpio kihao, Aaraivo aniaie, kumanka visa avu qimpavua aaramase kinka, Ho quahehaa variane. Ae himpuane. Viva aima aareo ivo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Minki kumanka vaiinki viva nai vaaqauka aqukoa ravaqaaseo qaqini seo himpio ou Isuva himpi vaunaini vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isuva via ireo, Ke ai nankiea uaae ania iarao? kio. Minki kuvo avu qimpavu vaiinkiva kihao, Maara ki vaiara vaiinkio, ki kivu rampai saane kima ani uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Minki kuvo Isuva kiva amio, Homa ae vinaave. Kiriara ae ki saihaqi iravave kiaraoma ai avu soqema vio ivo, kio. Minki kuvoma via avuvano vaasa rampai vuvo viva ho kaveo. Viva ho kavehao Isua vakaqio aaraini vuama. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Isuva minki kivaseo uva uantaseo visa kiva nimio kihao, Vaiinki vovano uaini santa ukukeo auhianta uvisa araseo vaka quseo uaini kava kakiainaa aukukeo kainta aukuseo maintaraa hiikeo vakeo niara vakaini vieva ihao vo susa kiva nimio, Ne ki naahoqaa raqisi kimikeha hini kava nenka hiqise vaeha hini kava vara kimikaake, kio. Minki kivaseo viva niaraini vo vakaini vio. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mini ou vauvo kava hiqiaina entava ani ntovo viva nai saiqa vainki vo akikeo kihao, Ou ki naahoqaa raqisi kimike vaisa vuu kiva nimiamanka uaini kava kintavaka hiqi kimikaake, kuvo mini vumanka ");
INSERT INTO tbg_a_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","via naahoqaa raqisi amike vau vaiinkisa via saiqa vainki via ravaaqau sekaiqanaara saavu via umiqase vake sa uaini kava hiqi amirai qaqi akikovo aniranteo vio. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Qaqi aniranteo vuvo naaho via qova nai saiqa vainki vo akikovo vumanka via naahoqaa raqisi amike vausa via qiaka rukavuse sauia ahasa aminka. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Minkuvo naaho qova nai saiqa vainki vo akikovo vumanka via aruse. Ho minkiaqi vi hini nai saiqa vainki nikikoa saavu visa numiqaase vake hini arusoaama ki. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ho vaiinki kaiqa sovo vaiinki vohaiqaqai vaua. Vi vaiinkia via qova nai maaquaa voqamase antuqa ari vau vaiinkiva vauvo via qova viavaka naankiara esaanaini akikehao kihao, Visa ki maaqu kavamase kiriara maaquve kihama via soqema amikevaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Minki kivaseo akikovo mini vumanka via naahoqaa raqisi amike vau vaiinkisa via kave nai kiva ami nai kiva amiha, Maa vaiinkiva nai qova quku viao nai qoa vakavaka aiaiavaka varaaiavama vaio ivo. Aniqe via arusaaio viva vaaeva ia ahasava kinavuniqama aniaie, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Visa minki kivase via ravaaqause aruse via naahoqinkai aaqaini vaaki aqusoave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Isuva minki kivaseo visa irama nimikeo, Minkuaa kio naaho qova nai maaqu arusea saara nankie ianaove? Naaho qova aninteo nai naahoqaa raqisi vaiinkisa vehi aukuseo vonavuaa ki naahoqaa raqisi kimikaake, kianaove. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ne sae Kotia vukaqi maa uvaa saara ntuvaseha iiaave? Minkima kio: Oi naavu saqehao vo oi, sa soqe oive, kivaseo qaqirasai oiva vi oiva naaquraiqama vio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kotiva vi oia noaiqama saiaqe ki kenavu via saiqa kave voqaraa saiqave ki uo, kuave. Kotia vukaqi minkima qara ntuva koave. Ne sae vi uvaa saara ntuvase iiaave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Isuva minki kumanka Iuntaa noa vaiinkinavu aako kenko kumanka iivuvo Isuva uaini naahoqaa raqisi amiko vaiinkisaa kihaoma uva uantaseo visaa kumanka via ravaaqau vare kota amiae kivase vaiinki nahenki viaqi ruvaantuma vusa kikivo kiha qekeha Isua sa ravaaqau sarai qaqiase vuama. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Via qararaa koqaqi Kotia saiqa vaa amike vausa visa noa vaiinkinavuvaka, Iuntaa noa vaiinkinavuvaka, maara osara ki vau vaiinkisavaka, aiqava kansoru vaiinkinavuvaka, visa ruvaantumavi vaiha visa auki osaraa kiva avuqavumase Isua seni santaqo via rumpa vare Pairaativa kamaania noa vaiinkivano vauaqi vuu se. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Vuu sovo Pairaativa Isua ireo, Quqaae ae Iuntaa vakanaasa avuniaa vaiinkivano variarao? kuvo Isuva kihao, Ae kianaa ke maa visave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Minki kumanka Kotia saiqa vaa amike vau vaiinkisa visa noa vaiinkinavu vo uva vo uva saara Isua aki vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pairaativa visa uva iihao qaiqaa Isua ireo, Ae sae visa nai kiva niminaave? Visa airi uva saara ai aki vaiavo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Minki kuvo Isuva qaiqaa mpeqaiqihao sa uva kiaio vauvo Pairaativa airi aako ii vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vo ihi vo ihi vehasumako ntaraa no entaaqaa kamaania avuniaa vaiinkivano vaiinki nahenki quahama nimikaeva karapusa vaiinki vo suvantu seo akikovo maaqaini vua. Vaiinki nahenki vi vaiinkia suvantu kimikaane kuvo vi vaiinkia suvantu nimike vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vi entaa vaiinkinavu kamaania hampaka raqua saara karapusa naavuqi vauvo vi vaiinkinavusaqinkaio vovano via auku Varapaasiva viva vaiinki arusoa saara karapusa naavuqi vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ho vi entaaqaa vaiinki nahenki usi vaiha karapusa vaiinki vantu saainaa viaa iiha usi vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pairaativa visa ireo, Ke ka karapusa vaiinkiae vantu nimikaraave? Ke Iuntaa vakanaasa avuniaa vaiinkie vantu nimikaraave? Ne kiva kimiqe iriae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pairaativa iumanka noa vaiinkinavu Isuva noaiqama vuanto kiha via koma amikehaa ki visa via vuu via sauquqi kukasoa. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pairaativa ka karapusa vaiinkiae vantu nimikaraave kivaseo vaiinki nahenki ire vaumanka Kotia saiqa vaa amike vau vaiinkisa visa noa vaiinkinavu ou vaiinki nahenki nivukana vaiha mpeqa uva kiva nimikeha kiha, Sa Isua vantu kimikaane kiai Varapaasia vantu kimikaane kiake, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Visa vaiinki nahenki kiva nimiha minki kiake kiha viha kumanka visa Varapaasia vantu kimikaane kuvo Pairaativa qaiqaa vaiinki nahenki ireo, Ne Isuaa kihama Iuntaa vakanaasa avuniaa vaiinkivanove kiavo. Ke vi vaiinkiaa nankie iaave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Minki kumanka visa navea kiha, Via sakaiqaa arusaake, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Minki kuvo Pairaativa ireo, Nana saarae via sakaiqaa arusaraave? Viva nana manta saiqae varaseo ivo? kumanka visa qaqiqai noaiqaase navea kiha, Via sakaiqaa arusaake, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Visa minki kuvo Pairaativa vaiinki nahenki quahama nimikaeva Varapaasia vantu nimikeo viaqaankaio nai sontia vaiinkiaa Isua saavu umiqasaake kumanka via saavu umiqa sovo viaqaankaio via sakaiqaa arusaake kio Pairaativa via nai sontia vaiinkinavu sauquqi kukasoa. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pairaativa nai sontia vaiinkinavu sauquqi Isua kuka somanka visa via vika vare vuu kamaania naavuqi se visa nai sana sontia vaiinki aiqava naarama ruvaantumase ");
INSERT INTO tbg_a_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","via avaakiha avuniaa vaiinki ukavaaqa nonku amikaresaa voqaama naare vaaqa aqu amike viaqaankai auquroa santa varase raqantaase kave voqaama aukuke Isua qiakaqaa aqu amike ");
INSERT INTO tbg_a_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","qasasaima seha visa nai sauqu kiriqaa aquseha uva avaakiha kiha, Iuntaa vakanaasa avuniaa vaiinkio, vaihaave? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Minki kivase visa saavuqo via qiaka rukavuse viaqaa kaara vihise via avuqaa koi sauru aravi vaiha vieaiqama seha quahama amike vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Minkiaqi viha avaakiha naaihaama amike kaiqase viaqaankai visa naare vaaqa aqu amikoa ravaqaase via ukavaaqa nonku amike via sakaiqaa aruse hiisaesa via vike vua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sontia vaiinkinavu Isua sakaiqaa aruse hiikaesa iha via vika vare vakusa aaqaini aarana vi vauvo vaiinki vovano via auku Saimoniva vihaio noa vakusaini viae kumanka visa viaa mpeqaiqamase kiha, Isua sakai aqu vaea vuu amikaane kuvo Saimoniva via sakai aqu vaeo vuu amikoa. Saimoniva Sairini vakaihainaava viva Arekisantasa Rupusa vikanta qovama vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Visa Isua vika vare vuu qumina ntaka Korokotave kunaini soa. Korokota maa uvaaqinkai kiea Qiaka Vuhaaintakave kunaini Isua vuu se ");
INSERT INTO tbg_a_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","uaini namai viaqi hunkavu ahasaa uantase vako namaia via amiae kuvo Isuva sa neo. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sa nomanka visa via sakaiqaa pirimaqo aruse via ukavaaqa vaase kausa kausae ho vaevaave kivaseha kaasi ruhantema seha oi aquseha via ukavaaqa rairase vaoa. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Qararaa suaivano vuahaaraini uumanka Isua sakaiqaa arusoa. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Via sakaiqaa aruse Isua qiakaini uva vo via kota kiva amiko uvaa qara ntuva ke sakaiqaa arusovo vi uvava minkima kio: Maa Vaiinkiva Iuntaa Vakanaasa Avuniaa Vaiinkive, kio. Vi qarava minkima vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Visa Isua sakaiqaa aruse Isua vakamase vaiinki vokanta arusomanka vikanta ruquku seha muara vare vau vaiinkikanta vaumanka visa vaiinki vo Isua sauqu kanaraini aruse vaiinki vo via saakaraini arusoa. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Isua vakamase vikanta arusoaa kio Kotia vukaqi uva vo qara ntuva kova vivauma vaua. Minkima kio: Viva manta vaiinki vakamaseo vaianaove, kua. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Minkima arusomanka vaiinki nahenki vikare aikare iha nai anu runkinkiiha mauru maimiqa amikeha Isua manta uva kiva amikeha kiha, Oho, ae kihaama Kotia naavu rampaise kaaramo enta saiqa vaehama qaiqaa saqa kaiqa saraave kianaa vo? ");
INSERT INTO tbg_a_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ho nena saihaqiane. Nena sakaiqaankaia vaavi ntaane, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Visa minki ki vaumanka visa aanante Kotia saiqa vaa amike vausa visa noa vaiinkinavuvaka, maara osara ki vau vaiinkisavaka, visa via naahaama amikeha kiha, Viva vo sisa saihaqi vaiva sama nai ho saihaqianaove. ");
INSERT INTO tbg_a_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Viva Kotiva akikai vaiinkiva mesaia vaiinkivano vaio ivo. Vi vaiinkiva Isarai vakanaasa avuniaa vaiinkivanoma vaio ivo. Saiqe kenavu vaiha kavaaio viva nai sakaiqaankaio viquvio vakaini kuviea kenavu viaa quqaave kiae, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Saririqa Iuntaa vakanaasa maara enta kaiqomanka Mariava Makataa vakusaihainaa nahenkivanovaka, via varanova Semisia novavaka, Saomivavaka, vi nahenkinavusa munima aquseha soqema seo untavi vau ahasaa vare Isua vaakaqaa aqu amikaesa vi. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Maaraqaa qararaa suaivano muani uu ntomanka vinavusa Isua quntama koaqi viesa vua. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aarana viha vinavusa nai ire nai ireha kiha, Kenavu mini ou ntaaio kavave noa oi qentiana kinkakai oia uqauruma kimikaanaove? Vi oiva noa oima vaio ivo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Minki kivase vinavusa ou nte kavovo oi uqauruma sovo vaua. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oi uqauruma sovo vaumanka vinavusa oiqi oiqeke kavovo vaiinki vo qaraasa vaiinkivano eqara ukavaaqa nonkuko vaiinkiva viaqi hini vantaraini oquvi vaua. Viva viaqi vaumanka via kave vinavusa qeke vauvo ");
INSERT INTO tbg_a_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","viva kihao, Sa qekeha variake. Isua Naasaretihainaa sakaiqaa arusaa vaiinkia ne viaae aikuki vaiavo? Viva sa maaqi vaio ivo. Viva qaqima himpio ivo. Nenavu kavaake. Maini via vakaanaini sa vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ho maa uvaa vare vuu via vainkinavuvaka Pitaaravaka kiva nimiake. Minkima kiva nimiake. Viva naane ni nivuni Kariri vakaini vio ivo. Nenavuvaka mini ou vi via kavevaave. Haau vaihao viaa ninavu kiva nimua vake vivauma vaio ivo. Vi uvaa kiake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Viva minki kumanka qekehaa ki vinavusa Isua quntama koaqinkai veva nte sante viha sa voravaka kiva amiaiki vua. ");
INSERT INTO tbg_a_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naankiara amparaiqasa Isuva vo vakusa via auku Neni vakusaini vumanka via vainkinavuvaka airi vaiinki nahenkivaka via vakamase vuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Isuva vi vakusaa qentiana ou nteo kavomanka vakusaqinkai vaiinki nahenki quku vu vaiinkia kainta vae via quntaeave kivase anua. Quku vu vaiinkiva ehaara nahenki maaqu vaumanka airi vaiinki nahenki vi nahenkia vakamase anuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Isuva vi nahenkia kaveo munkusaqinkaio umpo ise kiva amikeo viaa kihao, Sa iqi rakaane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Minki kivaseo ou kainta ukuvaromanka vaiinkinavu kainta ani varosa himpi vauvo Isuva kihao, Qaraasa vaiinkio, ke ariara himpuane ki uo, kuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","quku vu vaiinkiva himpio vaavi aravio uvavaka kuvo Isuva vi vainkia nai noa amio. ");
INSERT INTO tbg_a_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Minkuvo visa aiqava voqamase aaku ikomanka Kotia auku kure reha kiha, Poropeti vaiinki noavano kinavu avukaqi qovarama vio ivo, kinka. Kotiva sa kinavu nai vainkinavuaa kauru seo ivo, kinka... ");
INSERT INTO tbg_a_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","... ");
INSERT INTO tbg_a_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","O Ki navunaao, ni vaakaqai arusesa sa visa aaku qekaake. Visa ni aruse sa ni maraquavaka ho arusevaave. ");
INSERT INTO tbg_a_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne kararae qekeha vaivaave? Saiqe ke ni kiva nimiae. Ne Kotia aaku qekeha variake. Viva mpeqavano vaihao vaiinki aruseo viaqaankaio homa via qukuvisa vinaini aqu saaiavama vaio ivo. Eo, ke niarama ki uo ne Kotia aaku qekehama variake... ");
INSERT INTO tbg_a_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","...Isuva aiqava vaiinki nahenki kiva nimio, Ne rauriha variake. Ne airi aiaiave airi munimave vaea viaa noaiqaase iiha vaiqi vivoave. Ne kiha airi aiaia vakeha homa vaiqi viaave kivoave. Sa aiaiavano ni saihaqia ne soqemase vaiqi vivaavauve, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Isuva minki kivaseo viva uva uantaseo kiva nimio, Vaiinkivano airi aiaia vakova ntara ukukeo airi ntara qantu vaeo ");
INSERT INTO tbg_a_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","nai kivaseo iio, Ke maa ntaraa ka naavuaqie vakaraave? Aiqava ki naavuqi ntaravano mpiqama vio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Minki kivaseo viva kihao, Saiqe ke aiqava naavu rampaise qaiqaa noa naavu vo naavu vo naavu saqase viaqi ntaravaka aiaiavaka vakaae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ke vi saiqaa vuu kaiqase minkima kiaa, Ke soqemama vai uo. Airi ntara airi aiaia vaimanka ke airi ihi voka vaiqi viha maa ntaraavaka namaiavaka namaqi viha soqemase vaiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Vi vaiinkiva minki kuvo Kotiva via kiva amio, Sa ai avu aako vaivave. Maa entaa entaqi ae quku vinaave. Ae quku viao vovano ai aiaia kenka ukukaeave kiana aiaiaa varaanaove, kuave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Isuva minki kiva nimi kaiqaseo viva kihao, Vaiinkivano aiaiaaqai iihao aiqava aiaia uikareo vakaiava vaiao Kotiva vi vaiinkiaa kihao, Ai aiaia qumina ahasave. Ke kavauaa ae vehi vaiinkiqaima variaao. Ae qumina quku vinaave, kianaove, kio... ");
INSERT INTO tbg_a_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isuva minki kivaseo viva kihao, Vaiinki vovano qorainki vainki kaaraqanta vakakovoma ");
INSERT INTO tbg_a_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","via vainki naankiaraihainaava vaihao nai qoaa kihao, Naankiara ki kimieva kinaa aiaia vakeqai kimiane, kio. Kuvo via qova aiaia rairaseo nai maaqukanta voavaka voavaka nimuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","via maaquvano naankiaraihainaava amparaiqaqai vaio nai aiaiaqo soqaa aukuseo munima vaeo niara maaqa vio ou mini vaihao manta vaiinki hampaka vaihao ");
INSERT INTO tbg_a_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","munima vare vua vuu kaiqa seo. Vuu kaiqa sovo viaqaankaio sa ntaravaka vau entava ani ntovo ");
INSERT INTO tbg_a_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","viva vehi vaihao ou vi vakaaqaankainaa vaiinki hampaka saiqa vaeo. Saiqa vare vauvo ou quara ntara amiane kuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","viva quara ntara nimihao kio, Ise, kevaka quara ntara viki nimunaa naakaave kuvo ntara amiaiava sa vauvo ");
INSERT INTO tbg_a_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","narara vaihao uvo aako kenko kuvo iivuvo viva naiqai minki kivaseo iio. Ki qoa saiqa vare vaia vainkisa airi vaiavao ntara airiqimanka neha vaiamanka ke maini vaiha narara vai uo. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Saiqe ke himpi kenka qova inanaini anirante vuae. Ke ou nte kenka qoaa minki kieave. Ki qo, ke Kotiavaka aivaka manta saiqa vaa nimike uo. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ke via saara sa ai vainki soqesa ho vaiaave. Ae ki amparaiqama saiaqe ke ai saiqa vainkiqai vaiae. Ke minki kivase kieave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Minki kivaseo himpio nai qova unaini anio. Nai qoa naavu aumanko anuvo via qova vukua niaraihaio via kaveo quaha seo santeo ou nai maaqu ravaaqau seo susuqehao vauvo via maaquvano kihao, ");
INSERT INTO tbg_a_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ki qo, ke Kotiavaka aivaka manta saiqa vaa nimike uo. Ke via saara sa ai vainki soqesa ho vaiaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kuvo via qova nai saiqa vainki kiva nimio, Sante ne ou ukavaaqa soqeaqaima vara vii amiake. Saankava irara vara vii usu amikaake. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Purimakaua naaki soqea aruse nunkaake. Vake maasa viaa quahama amikaeama ivo. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ki maaquvano quku vivo kuoma qaqi aninteo ivo. Ki maaquvano raumpiima vivo kuaoma qovarama vio ivo, kio. Minki kivaseo nai maaqu quahama amikeo ntara varaseo kavaaruqama amikeo. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kavaaruqama amike vauvo via vasaava saiqaqinkaio naavu aumanko aninteo iuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ihi nte vauvo viva nai qoa saiqa vainki vo irovo viva minkima kio, ");
INSERT INTO tbg_a_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ai qakavano vekaihaio anintaivo ai qova viaa quahehao purimakaua naaki soqea aruseo nunka amikeo ivo. Ai qaka soqema seo nai vikeo quahehaoma minkio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Minki kuvo via vasaaa arara ikovo komaseo kihao, Sa ke naavuqi vieama ivo, kivaseo vahaaqaini vauvo via qova veva nteo aarovo viva minkima kio, ");
INSERT INTO tbg_a_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ke airi ihi varaqi vihama ai saiqa vainki voqaantemase ai saiqa vaehama sa ke vo entavaka ai no antua viai vai uo. Ke kenka konti quahama nimikaea kuaa ae sama mimi naaki vonku ruquku kimia iarao. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Maava ai maaquvano hampi naio ni vai nahenkiaqaa ae iana ahasaa vaeo vuu kaiqa seo anivaama purimakaua naaki soqea qumina ruquku amia iarao, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Minki kuvo via qova aqao kio, Ki maaquvauvao, ae vo enta vo enta ki vakamasea vaiavave. Ke una ahasaa aiqava aiaia kenkakanta unaave. ");
INSERT INTO tbg_a_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ai qakavano quku vivo kuoma qaqi aninteo ivo. Viva raumpiima vio ivo kuoma qaqi qovaama vio ivo. Minkiaa ki kenavu vake via quahama amikaeave, kuave, kio. Isuva kuama. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Isuva minki kivaseo viva kiva nimio, Vaiinki vovano airi aiaia vakova soqe ukavaaqaqai nonkuseo vo enta vo enta hiasaa u ntaraaqai nehao vauave. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Viva vi ntaraaqai neha vaumanka vaiinki vo via auku Rasarusia vika vae vuu airi aiaia vako vaiinkia naavu qentiana sovo vaua. Vi vaiinkiva sa aiaiavaka vakova vehi vaiinkivano vauvo numuaravanoqai aiqava via vaakaqaa ike vauvo ");
INSERT INTO tbg_a_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","vaihao viva airi aiaia vako vaiinkiva ntara nehao viki aqusoa viaqai nunku naeva vaua. Mini vauvo vairivano vikare aikare ihao via numuara mpui ne vaua. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sa aiaia vako vaiinkiva quku vumanka naauaihainaasa via vika vare vuu Avarahaava nai saivaqaa vaunaini vuu soa. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Vuu sovo airi aiaia vako vaiinkiva vivavaka vaio quku vuvo vakaqi quntama kovo viva quku vuasa vaianaini vaihao ankua ntihao vaio. Mini vaihao viva vuuvi kavovo Rasarusiva Avarahaasanti quahehao niaraini vaua. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Vauvo viva Avarahaaa aareo kihao, Avarahaao, ki qo, kiriara umpo ise kiva kimikaane. Ae Rasarusia akikaio viva nai vuqa ou namaiqia vaavi quntama vaeo munku ki maaqiiqaa vakaiao nupima kimikaaie, kio. Ke noa iha ikaiaqi vaiha ankua ntiha vai uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Viva minki kuvo Avarahaava aqao kio, Ki vainkivauvo, ae iriane. Ae haau qaqi vauna entaa soqe ahasa vakoao Rasarusiva manta ahasaqai vakoave. Vake viva maini vaihao quahehao vaivaa ae mini ankua ntihaa vaiarao. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ae qaiqaavaka ii vaiaqe ke voqa ai kiva amiae. Ke vaunaa ae vaianaa avukana onkai noama vaio ivo. Maihaio vuantoave vihaio aniantoave kio onkai noama avukana vakaiave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Avarahaava minki kuvo vi vaiinkiva kihao, Umpo, ki qo, ke ariara umpo ise ki uo. Rasarusia akikaiao viva ki qoa naavuqi ou nteo ");
INSERT INTO tbg_a_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ki qaka vasausa sauqu hiniunavu vaisa kiva nimiaie. Visavaka maini aiha vinanaini anivoave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Minki kuvo Avarahaava aqao, kio. Mosevavaka poropeti vaiinkinavuvaka qara ntuva ko uvava vaiove. Visa vi uvaa homa iivaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kuvo qaqi vau entaa airi aiaia vako vaiinkiva kihao, Save, ki qo, Avarahaao, quku viava aniranteo vuu kiva nimia visa via uva iihama manta aara qaqia sevaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Minki kuvo Avarahaava aqao kio. Visa Mosea uvavaka poropeti vaiinki uvavaka sa iivea visa quku viava aniranteo vuu kina uvaavaka sa ho iivaave, kuave, kio. Isuva minki kuama. ");
INSERT INTO tbg_a_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Isuva mini vaihao qaqi ki vaumanka vaiinki airi vaiinkinavu anintoa. Isua vainki 12 navuqinkaio Iuntaasiva airi vaiinki ntika vaeo viva naane visa avuni anio Isuva vaunaini aninteo Isua moqa saeva auki vauvo ");
INSERT INTO tbg_a_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Isuva kihao, Iuntaasio, ae ki moqa sehaae ki vakaini vakakai vainkisa navukaasa nivuqaa ki qovarama senaave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Isuva minki kumanka via vainkinavu via vakamase vausa kavomanka visa Isua ravaaqau saesa auki vaumanka vinavusa Isuaa kiha, Noavauvo, kenavu sopiqoe visa keqa saraave? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kivaseo vovano Kotia saiqa vaa amike vau vaiinkisa visa avuniaa saiqa vainki vo keqaseo via aako keqa aqu sovo hiqintuvo Isuva aqao kio hove kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kivaseo vi vaiinkia aakoqaa nai sauqu vakovo qaiqaa kavanta vua. ");
INSERT INTO tbg_a_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kotia saiqa vaa amike vau vaiinkisa visa noanavuvaka, Kotia naavuqaa raqisi vau porisisa opisaaravaka, noa vaiinki vonavuvaka, visa Isua ravaaqau saesa anusaa Isuva kihao, Ne kamaania vakamase iqosa raquaina vaiinkia voqaama ravaaqau saesae sopi saavu vare aniavo? ");
INSERT INTO tbg_a_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ke ni hampaka vo enta vo enta Kotia naavuqi vaiqi vi vauamanka ne sa ki ravaaqau saarave. Ho vake maa entaa ni entama vaio ivo. Vake sonkiaiqi vaia ahasava mpeqaiqianaove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Manta vaiinki vovano hini sakaiqaa arusova vivavaka Isua manta uva kiva amihao kihao, Quqaae ae mesaia vaiinkivano variarao? Ae nenavano kikantavaka saihaqiane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Minki kuvo manta vaiinki vovano aqao kio, Sae ae Kotia aaku qekehaa variarao? Visa kikanta aanantamase viavaka arusaavo. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Visa homa kikanta arusevaave. Visa kikanta manta saiqa saara kikanta arusaavo. Vi vaiinkiva sa manta saiqa varaivave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Minki kivaseo viva Isuaa kihao, Isuo, ai noaiqama saaina entaa kiriarama irikaane, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Minki kuvo Isuva kihao, Ke ai kiva amiaiama iriane. Vake ae ki vakamaseama soqe vakusaini vainaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Minkuvo suai qiakaqaa uu ntovo viaqaankaio sonkiaiqama vuvo sa suai ikovo sonkiaqai aruqio vuvo suai vikiniqamavio 3 kiroki quvo qaiqaa aakikoa. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ierusaremi vakusaini Kotia naavuqi saankusa voqaama noa kavuna hiikova avukaqaa nai nahaqu vuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isuva noaiqaaseo oi oi kihao, Ki qo, ki maraqua varaane, kio. Minki kivaseo viva quku vio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Isuva quku vuvo sontiaqaa raqisi vau vaiinkiva Isuva minkua kaveo Kotia auku kure ra seo kihao, Quqaama maa vaiinkiva avuqavu ni vai vaiinkivave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Minki kumanka vi saiqaa kavaesa ruvaantuma vusa visa vaiha kavamase viaqaankai visa nai maaqaini anirante vihama munkusa mantaiqumanka nai mimia ruquku seha vuama. ");
INSERT INTO tbg_a_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Visa vumanka Isua vaiinki nahenkivaka, nahenki vonavu Kariri vakaihai via vakaqi nusavaka, visa niara ntaka vaiha vi saiqaa kave vaua... ");
INSERT INTO tbg_a_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Vi entaaqaa Isua vainki kaaraqanta vo vakusa Emeasi vakusaini viesa vua.(Urara vaivo Kainantu vaivo via voqaama Ierusaremi vauvo Emeasi vakusa vaua.) ");
INSERT INTO tbg_a_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Vikanta aarana viha Isua aruso uvaa kivaqi vi. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Vikanta kivaqi vuvo Isuva nai aninteo vikanta vakamaseo ou vumanka ");
INSERT INTO tbg_a_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","vikanta via kaveha sa via uqauqamase kavarai vo vaiinkivanove kuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isuva vikantaa kihao, Nekanta aarana aniha nana uvae nai kiva ami nai kiva ami ani vaiavo? kio. Minki kumanka vikanta ani viaqaa himpike munkusavano mantaiqumanka ");
INSERT INTO tbg_a_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","vovano Siriopasiva Isua ireo, Maa entaa airi vaiinkinavu ani Ierusaremini variavaa ae vohaiqavanoqaie kuvana qovaraiqi uvaa sae iriarao? kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Minki kuvo Isuva nana uvave kumanka vikanta kiha, Isuva Naasaretihainaa uvave. Vi vaiinkiva poropeti vaiinkivano vaihao Kotia avuqaavaka vaiinki nahenki nivuqaavaka noa saiqa vaehao soqe uva kio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Viva vaimanka Kotia saiqa vaa amike vaia vaiinkisa visa noa vaiinkinavuvaka, kinavuqaa raqisi vaiasavaka, visa via amiavo viva via arusaake kimanka via sakaiqaa pirimaqo arusaavo. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kenavu haau vi vainkiaa Kotiva via akikaivo viva vo vakanaasa aakara seo kinavu Isarai vainkiqaa raqisiaiavave kunaave. Uva vovakama vaio ivo. Via arusaavo vake kaaramo enta aikareo ivo. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Vake kekanta nahenkinavu kia uvaa ii rankuma vi uo. Vinavusa vaasa qararaa via quntama kaaraqi ou nte sa via vaaka kavaavo. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Vinavusa anirante vuu kiva nimiha, Naauaihainaasa kinavuaa viva qaqima vaio ivo kiavo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Vinavusa minki kiamanka kinavuqinkai hini vaiinkinavu via quntama kaaraqi ou vi ou kavaavo nahenkivano ki uvaa vivauma vaimanka via vaakavaka sa kavaave, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Vikanta minki kuvo Isuva vikanta kiva nimio, Nikanta avu aakovaka sama vaio ivo. Haau poropetinavu kiva ko uvaa nekanta vi uvaa quqaave kiakaa vaimanka nekanta qasomase vi uvaa ii vaiavo. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nekanta sae iriavo? Kotiva akikaaia vaiinkiva mesaia vaiinkivano aihavina ahasaa vaiqio vio viaqaankaio noaiqama vio mpeqa vaiinkivano vaianaove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Minki kivaseo Isuva mesaia vaiinkiaa Kotia vukaqi qara ntuva ko uvaa vikanta kiva nimieva hoqareo Mosea vukaqinkaio kiva nimiqio vio poropetinavu vukaqinkaio kiva nimiqio vua. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Minki ki vauvo vikanta viesa u vakusava aumanko vauvo Isuva aarana qaqi vieva voqaama auki vauvo ");
INSERT INTO tbg_a_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","vikanta aqao ki, Amparaiqaqaa entievave. Qaqia sea kikanta vakamasea vaikaane kuvo vikanta vakamaseo vaieva naavuqi vio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Viva viaqi vaihao ntara kaintaqaa vikanta vakamaseo oquvio Kotiaa soqema iarao kivaseo mpareti ntara nkuiseo rairaseo nimumanka ");
INSERT INTO tbg_a_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","vikanta avu aako kenko kuvo iivumanka vikanta via uqauqamase kave. Vikanta via uqauqamase kavovo Isuva vikanta nivuqaankaio uantavio sa vaio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Isuva uantavio sa vaumanka vikanta nai kiva ami nai kiva amihakanta, Viva aarana anihao Kotia vukaqinkainaa uva kikanta kiva kimi vaivo quqaama kikanta munkusaqinkaio soqema vio ivo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Minki kivase vikanta vaasa himpikanta anirante Ierusaremini ou Isua vainki 11 navu rantase kavomanka vinavusa vo vaiinkinavu vakamase ruvaantumavi kiha, ");
INSERT INTO tbg_a_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Noavano quqaama qaiqaa himpio ivo. Saimoniva vivama kaveo ivo, kumanka ");
INSERT INTO tbg_a_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","vikantavaka aaraini niha kavoaa visa kiva nimi. Vikanta kiha, Viva mpareti ntara nkui saimanka viaqaankai kenka noa vaiinki sankunkase kave uo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Vikanta uva visa kiva nimi vauvo vakeni noavano vivama qovaraiqama vio visa kakaaqa himpikeo vaihao kihao, Ni munkusaqinkai qihaasi vaia variake, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Minki kumanka visa voqamase qekeha vaanavano qovarama vivo kuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Isuva visaa kihao, Ne nankihae qeke vaiavo? Ne nankihae kiriara kaara aako vake ii vaiavo? ");
INSERT INTO tbg_a_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ki sauqu aiqu kavaake. Ke visama ivo. Ki aukeha kavaake. Ke vaiinkima vai uo. Sa vaanavano ki aananteo makivaka vuhaaivaka vaiavauve, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Minki kivaseo viva nai sauquvaka aiquvaka numiqomanka ");
INSERT INTO tbg_a_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","visa voqamase quaheha sauqu runkinkii iha kiha, Sa ho viaa quqaave, kiae kuvo Isuva kihao, Ntara naainaa vaio ivo, kumanka ");
INSERT INTO tbg_a_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","hampusa nunkakoa ampara amuvo ");
INSERT INTO tbg_a_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","viva visa nivuqaa vaihao varaseo noa. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Isuva hampusa namaseo visa kiva nimio, Haau ni hampaka vaiha ke maa uvaa ni kiva nimunaave. Kiriara haau Moseva vukaqi qara ntuva ko uvaave, poropeti vaiinkinavu qara ntuva ko uvaave, Saami vukaqi qara ntuva ko uvaave, ke ni kiva nimiha vi uvaa vivauma vaianaove kunaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Minki kivaseo visa Kotia vukaqi qara ntuva ko uvaa sankunka iriake kio viva vi uvaa vi uvaa kiva nimio kihao, ");
INSERT INTO tbg_a_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Maa uvaa qara ntuva koave. Mesaia vaiinkiaa viva aihavina ahasaa vaeo vuu quku vio kaaramo enta vaio qaiqaa qaqi himpuanaove. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Viaqaankai ne ki saiqaa ki hukuaa iihama vaiinki nahenki kiva nimiqi viha manta aara qaqia saivo Kotiva ne manta saiqa vare uvaa nunka nimikaaie kiake. Vi uvaa kiva nimiqi viha Ierusaremini naane vi uvaa kiva nimiqi vi viaqaankai vo vakaqaa vo vakaqaa kiva nimiqi vuake. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nenavu nenka avuqo vi ahasaa vi saiqaa kavaama ivo. ");
INSERT INTO tbg_a_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ki qova sauqu aiqiqaa aqusehao kenka ni nimieave kiainaa kema via akikaeave. Ne maa vakusaaqi vaiqi vivo naauaihaio viva kuvio niqaa vaihaoma ni mpeqaiqama nimikaaie, kio... ");
INSERT INTO tbg_a_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Paresi vaiinki vovano vauvo via auku Nikontimaava. Viva Iuntaa vakanaasa avuniaa vaiinki vovano vaua. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Viva vaihaoma entaqi Isua ou kaveo kihao, Maara ki variaa vaiinkio, kenavu kavauao Kotiva ai akikaivaa kiama ae maara uva ki variaava ani iarao. Sa Kotiva ai saihaqiae kivaa ae sama noa saiqa varaaraikiio, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Viva minki kuvo Isuva kiva amio, Ke quqaa uva kiaiama iriane. Vaiinki nouqama viava vaiao via sa qaiqaavaka vakakaiea viva sama Kotiva raqisina vakusaa ho kavaanaove, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kuvo Nikontimaava kihao, Nankimaseoe nouqama vina vaiinkia qaiqaa vakakaanaove? Viva qaiqaa nai noa araraqi viqekaiaoe via vakakaanaove? kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kuvo Isuva kihao, Ke quqaa ki uo. Namaiqi vakakaiava vaiao sa Kotia maraquavano via qaiqaa vakakaiao viva sa Kotiva raqisina vakusainia vuanaove. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vaaka ahasavano vaaka ahasaqaima vakakaiave. Maraqua ahasavano maraqua ahasaqai vakakaiave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ke ni qaiqaa vakakaainaama kiva amuaa ae viaama rankuma via iarao. Sama minkiane. Ke uva uantase ai kiva amieave. Uvaivano ukihao mini mini vuakaaivo vi vaio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Uvaivano uki vaivaa ae sa via kavaraia ae via uvaqai iianaave. Ae viva aniaina osaraave viva vuaina osaraave sa iia iarao. Ho Kotia maraquavano vakai osaraa via voqaama vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Isuva minki kuvo Nikontimaava, Nankimaseoe minkianaove? kuvo ");
INSERT INTO tbg_a_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isuva kihao, Ae Isaraia vainkinti maara uva kiva nimi variarava vaihaae vi uvaa sa iianaave? ");
INSERT INTO tbg_a_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ke quqaa ki uo. Kenavu sankunkase iuna ahasaa ni kiva nimi vai uo. Kenavu kenkanavu kivuqo kavauna ahasaa qoqaa ni kiva nimi vai uo. Minki vauamanka ne sa kinavu uva iriavo. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ke vakaihainaa ahasaa ni kiva nimuamanka ne viaa sa quqaa uvave kiavo. Ne minkiavea ke naauaihainaa ahasaa kiaima nankise ne vi uvaa ho iivaave? ");
INSERT INTO tbg_a_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sa vaiinki vovano naauaini Kotiva vainaini viave. Keqaima vihaima kuvi uo. Ki vakaini vakakaisa ke naauaini variavauausave. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Haau ni saivaqava Moseva qumina vakaini vaihao memau maraqua oiqo aukuseo via sakai arakoaqaa kure ra soave. (Vaiinki nahenki via kave sa quku vuake kio Moseva minkuave.) Ho ke vakaini vakakaisa ke vaiaia haau Moseva memau maraqua aukuseo vakontema sema kivaka sakaiqaa kure ra saia ");
INSERT INTO tbg_a_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","vaiinki nahenki kiriara quqaa vivave kisa sa quku vi kaiqa viaiki aiqava enta enta qaqi vaiqi vivaave, kio. Isuva minki kuama. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Vaiqa Kotiva vakaini vaiasaa voqamaseo munkusa vakehaoa kio viva nai maaqu vohaiqa vakakaia kinavu kimio. Minkiaa ki vaiinki nahenki via maaquaa quqaave kisa sa quku vi kaiqa viai visa aiqava enta enta qaqi vaiqi vivaa. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kotiva nai maaqu akikovo viva sa vaiinki nahenkiqaa uva vakaeva kuvio. Vaiinki nahenki soqemavi variake kio viva kuvio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Vovano via maaquaa quqaa vivave ki vaiava vivama sa uva varaanao. Vovano viaa sa vivave ki vaiava vivama noa uva varaanao. Vake maa entaa Kotiva kota kivaseo vi vaiinkia via qoiima seo. Viva Kotia maaqu vohaiqa vakakaiaa sa quqaa vivave kia saara Kotiva via qoiima seo. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Maa ahasaa saara uva vaianao. Ovavano vakaini kuvimanka vaiinki nahenki sa via quahama amikarai visa sonkia ariraaqai quahe vai. Vaiinki nahenki saiqavano manta saiqa vaimankaa ki visa sa vi ovaa quahama amike. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Manta saiqa vare vai vaiinkiva vovano vovano navukaiqihaoma sa vi ovaa quahama amikaraio sa ovavano vainaini vio. Ovavano ki vaaqu saiqa akaama kimikaanto kihao sa ovavano vainaini vio. ");
INSERT INTO tbg_a_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Viva minkima vaivo quqaa saiqa vare vai vaiinkiva sa qekaraio ovavano vainaini vio. Viva vivo ovavano via saiqa akaama amikaimanka vaiinki nahenki kavaavo vi vaiinkiva Kotia uva iihao Kotia saiqa vare vaia. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Isuva ou vihao kavovo vaiinki vovano nai noa auhaqinkaio avu qimpa vuva vaumanka ");
INSERT INTO tbg_a_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Isua vainkinavu Isua irema, Maara ki vaiaa vaiinkio, kavave manta saiqa vaa saivoe via saara vi vaiinkia avu nai noa auhaqinkaio qimpa vio ivo? Naie, via nosa qosae manta saiqa vara saavaoe via saara via avu qimpa vio ivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Minki kuvo Isuva aqao kio, Sama nai manta saiqa varaia saara via avu qimpa vio ivo. Sama via nosa qosa manta saiqa vararaa saara via avu qimpa vio ivo. Ne vi vaiinkiaqinkai Kotia saiqa kavaake kio via avu qimpa vio ivo. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kotiva ki kikikai saiqaa kenavu aakikainaaqaa varaqi vieave. Entama viao sa vovano ho saiqa varaanaove. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ke vakaini vaiha ke ovavano ikaintema se ikaqi vuaia vakaini vaisa ho kavevaave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Minki kivaseo Isuva vakaqaa kaara vihiseo kaaraqo horaiqama seo viki avu qimpa vua avuqaa kaaqau amikeo kihao, ");
INSERT INTO tbg_a_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Oku Siromi varuvaqi, Akikaia namaiqi munku nena vii mintuqaane, kio. Minki kuvo vi vaiinkiva kunte io munku nai vii mintuqa sovo via avu rampai vuvo viva vihaio okuranteo ho kavamaqio uio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Viva ho kavamaqio ui vaumanka via aaqa vausa kavovo aarana vaihao aiaia kimiake ki vau vaiinkiva qaqi uumanka visa via kavema kiha, Ka vaiinkivae uio ivo? ");
INSERT INTO tbg_a_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aarana oquvio vaihao aiaia kimiake ki vai vaiinkivave? kinka. Kumanka hini usa kiha, Ho vivama ivo, kinka. Kumanka hini usa aqao kinta, Vovanoma uio ivo. Via vii voqaama vaiva uio ivo, kuvo vi vaiinkiva uu nteo nai kihao, Ke maa visama ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Minki kumanka visa via irehama, Nankuma saivoe ai avu rampai vio ivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kuvo viva visa kiva nimio kihao, Vaiinki vovano via auku Isuva viva kaara vihiseo horaiqama seo ki kivuqaa kaaqau kimikeo kiriara kihao, Siromi varuvaqi munku nena vii mintuqaane, kimanka ke munku mintuqa sauo ki kivu rampai vimanka ke ho kavamaqi uuo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Minki kumanka visa via irema, Viva kaini vivaae uuarao? kinka. Kuvo, Nai kainie vio ivo? Sa ke kave uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kumanka visa haau avu qimpa vua vika vae vuu Paresi vaiinkinavu vaunaini sanka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Isuva maara entaqaa hora kaaqau seo vi vaiinkia avu rampai soa. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Visa Paresi vaiinkinavu vaunaini via vuu somanka Paresi vaiinkinavu vi vaiinkia irehama, Nankuma saivoe ai avu rampai vio ivo? kuvo viva kihao, Viva hora vaaseo ki kivuqaa kaaqau kaimanka munku kenka vii mintuqa sauo ki kivu rampai vimanka ke ho kave uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Viva minki kumanka Paresi vaiinki hini susa kihama, Vi saiqaa varaiva maara entaqaa minkio ivo. Viva maara entaqaa sa minkiakaa vaivo viva uva raqa sehao minkio ivo. Minkivaa kio viva sa Kotiva inaihaio kuvivave, kinka. Kumanka hini susa kihama, Aqao, nankumaseoe manta vaiinkivano vi saiqaa noa saiqa ho varaanaove? kinka. Minki kivase hini usa vo uva kumanka hini usa vo uva kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Qaiqaa Paresi vaiinkinavu via irehama, Ae viva ki kivu rampai seo ivo kianaave. Vi vaiinkiaa ae nana uvae kiarao? Viva nankuma vai vaiinkivae ai avu rampai se ivo? kuvo vaiinki viva kihao, Viva poropeti vaiinkivanove. Kotiva via saihaqi vaivo viva saiqa vae vaio ivo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Minki kumanka Iuntaa vaiinkinavu sa via uvaa quqaave kirai vi vaiinkiaa kiha, Ae una kihaama ki kivu rampai vivo kiarao. Haau sa ai avu qimpa vuave, kinka. Minki kivase vi vaiinkia nosa qosa naaromanka vikanta ");
INSERT INTO tbg_a_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","anumanka vikanta irehama, Vaiinki maa nikanta maaquve? Quqaae via nai noa auhaqinkaio avu qimpa vuave? Nankuma saivoe via avu rampai vivoe ho kaveo ivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kumanka via nosa qosa kihama, Maa vaiinkia kikanta maaquve. Via avu haau auhaqinkaio qimpa vuave. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nai nankuma saivoe via avu rampai vio ivo? Nai kavave via avu rampai seo ivo? Viva nouqamavivave. Ne nenka via ireha kavaake. Viva homa ninka kiva nimianaove, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Vikanta Iuntaa vaiinki kave vakausa naaku qekehama minki kuama. Iuntaa vaiinki noanavu vaasa uva kivase kihama, Vaiinki vovano Isuaa mesaia vaiinkivano kinavu saihaqieva anivave kiantoave. Vovano minki kiea via saara via akihama maara naavuqinkai akikamasaaio veva nteo esaara vuaie, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Minki kivaseha uva kivakoaa ki via nosa qosa Iuntaa vaiinki noanavu naaku qekehama kiha, Viva nouqamavivave. Nenka via ireha kavaake, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kumanka visa qaiqaama haau avu qimpa vua aarema kihama, Ae Kotia quahama amikaakaave. Isuva manta vaiinkive, kinka. Kuvo vi vaiinkiva kihao, ");
INSERT INTO tbg_a_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Isuva nai manta vaiinkie soqe vaiinkie ke sama via osara ii uo. Ki kivu qimpa vua rampai saiaa viaaqaima ii uo, kio. Kumanka visa via irehama, ");
INSERT INTO tbg_a_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Viva ai nankie ivo? Viva nankumaseoe ai avu rampai seo ivo? kinka. Kuvo viva kihao, ");
INSERT INTO tbg_a_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ke viaa ni kiva nimuamanka ne sa iriavo? Nankihae vi uvaa qaiqaa iiesave? Nevaka vo? Nevaka via vainki vaiesae qaiqaa vi uvaa iraavo? kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kumanka visa via noaiqamase akiha kiha, Arema via vainki vaihaa via uva iiaravave. Kenavu kenka saivaqaa Mosea uva iiqi vuausave. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kotiva Moseaa uva kivakoa kenavu iiqi vunaama ivo. Isuaa vi vaiinkiva qumina vaiinkive. Kenavu sama viva vihaio ani osaraa ii uo, kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Visa minki kuvo viva sauqu runkinkii ihao Ise, kio, Ki kivu rampai kimikaiaa viva vihaio ani osaraa ne sae iriavo? ");
INSERT INTO tbg_a_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kenavu iuo Kotiva sama manta vaiinki uva ii vaivama ivo. Kotiva nai uva iiha ni vaia vaiinkisa visa uvaqai ii vaivama ivo. Via auku kure re vaiasa visa uvaqai Kotiva ii vaivama ivo. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Haau maa vakaa hoqaramako entaaqaankaio sa vaiinki vovano nai noa auhaqinkaio avu qimpa vua rampai amikoama ivo. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Isuva sa Kotiva inaihaio kuvuae kio sa ki kivu ho rampai kimikaikiio, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Vi vainkiva minki kumanka visa kihama, Ai vaaqu vainki vakakaivave. Ae vo? Ae kinavuvakae maara uva humiqenaave? kinka. Minki kivase visa vaiinki via rarau vae veva maara naavuqinkai vahaaqaini aquse. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Via vahaaqaini aqu sovo Isuva visa via rarau aqusoaa iio vi vaiinkia ranta seo kihao, Ae vakaini vakakai vainkiaae quqaa vivave kinaave? kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kuvo vaiinki viva irehaoma, Noa vaiinkio, viva kavave? Ae kiva kimiaqe ke viaa quqaa vivave kiae, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kuvo Isuva kiva amio, Ae kave vaiaausa ke maa visama ariara ki vai uo, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Minki kuvo viva kihao, Noa vaiinkio, quqaama ae vivave, kio. Kivaseo viva Isua avuqaa koi sau aravio via quahama amikeo vauvo ");
INSERT INTO tbg_a_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isuva kihao, Ke vaiinki nahenki raira saea vakaini kuvuausave. Avu qimpa visa kavaakea kuvuausave qaqi kavesa avu qimpa vuakea kuvuausave, kio. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Minki kumanka Paresi vainkinavu vi uvaa ii Isua irehama, Kinavu kivue qimpa vio ivo? kinka. ");
INSERT INTO tbg_a_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kuvo Isuva kiva nimio, Ni nivu qimpa viavauve sa niqaa uvavano vaianaove. Ne kiha kenavu ho kave uo ki vaiavo. Minki ki vaiaraa kio via saara niqaa uva vaianaove, kio. Isuva minki kuama. ");
ALTER TABLE tbg_a_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
