﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbf_vpl;
CREATE TABLE tbf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbf_vpl WRITE;
INSERT INTO tbf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ine arie man vinateteik katsep mi tietie se Iesu Karisito. E Iesu eie e tubuon e Davit. E Davit eie e tubuon e Abaraam. ");
INSERT INTO tbf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","E Abaraam eie e taman e Isak. E Isak eie e taman e Iakop. E Iakop eie e taman e Iuda ma bu kasien. ");
INSERT INTO tbf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","E Iuda eie e taman ba baser kasien e Peres ma e Tsera. E kinaguor, e Tamar. E Peres eie e taman e Esron. E Esron eie e taman e Ram. ");
INSERT INTO tbf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","E Ram eie e taman e Aminadap. E Aminadap eie e taman e Nason. E Nason eie e taman e Salmon. ");
INSERT INTO tbf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","E Salmon eie e taman e Boas, ma e kinan, e Raap. E Boas eie e taman e Obet, ma e kinan, e Rut. E Obet eie e taman e Iesse. ");
INSERT INTO tbf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","E Iesse eie e taman e Davit mi kovakova ka leong. E Davit eie e taman e Solomon. E kinan, eie ta be nga muna reie e Uria. ");
INSERT INTO tbf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","E Solomon eie e taman e Reoboam. E Reoboam eie e taman e Abia. E Abia eie e taman e Asa. ");
INSERT INTO tbf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","E Asa eie e taman e Iospat. E Iospat eie e taman e Ioram. E Ioram eie e taman e Usia. ");
INSERT INTO tbf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","E Usia eie e taman e Iotam. E Iotam eie e taman e Aas. E Aas eie e taman e Esekia. ");
INSERT INTO tbf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","E Esekia eie e taman e Manase. E Manase eie e taman e Amon. E Amon eie e taman e Iosia. ");
INSERT INTO tbf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","E Iosia eie taman e Iekonia ma bu kasien. Ian simi avareit bu Babilon gi ta nga kerie sien bu Israel nia ra tsatsang vinatoreis i Babilon. ");
INSERT INTO tbf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","I murien mi kinakir sibu Israel rakot i Babilon, e Iekonia eie e taman e Sealtiel. E Sealtiel eie e taman e Serubabel. ");
INSERT INTO tbf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","E Serubabel eie e taman e Abiut. E Abiut eie e taman e Eliakim. E Eliakim eie e taman e Asor. ");
INSERT INTO tbf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","E Asor eie e taman e Sadok. E Sadok eie e taman e Akim. E Akim eie e taman e Eliud. ");
INSERT INTO tbf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","E Eliud eie e taman e Eleasar. E Eleasar eie e taman e Mattan. E Mattan eie e taman e Iakop. ");
INSERT INTO tbf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","E Iakop eie e taman e Iosep, e Iosep eie ken labeit e Maria. E Maria e kinan e Iesu ese gi ta vuotongie va mi Messia. ");
INSERT INTO tbf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Io, a nga sinangavur kes ma voveit bu kienakav kokouk sibu tam ma sibu nout kovuni se Abaraam beit se Davit, ma mi sinangavur kes ma voveit te buer bu kienakav sibu tam ma sibu nout kovuni se Davit beit simi avareit bu Babilon gi ta nga kerie bu Israel rakot nia tsatsang vinatoreis i Babilon. Io, vakaek ian en beit si ken kienakav mi Karisito a nga sinangavur kes ma voveit te buer bu kienakav sibu tam ma sibu nout. ");
INSERT INTO tbf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ine arie vasa ken kienakav e Iesu Karisito a nga tsorubeit ven. E Maria, e kinan, gi nga kubutsie va eguor e Iosep va guor ta nga rei. Eiekesen i muan guor ta kap ngas nga mon kokouk, gi nga vorotan va e Maria a te nga kour simi ngesengesien mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","E Iosep, ken labeit, eie mi ka duis i matan e Raban. A kap nga lalaron nia vamangarie e Maria i matan mi lobaram. Io, a nga vodon nia kitipie keguor rei menemenen mo. ");
INSERT INTO tbf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sien ta nga vor ve vodovodon surie ine, ken angelo mi Nguts a nga tsorubeit seie i aron mi binorea ma a nga vakokoit ven ne, “Iosep, natuon e Davit. Kian va e ta motou nia kerie e Maria va ke vevien, simi vunan ine mi madar eie tate tian ngan, a kuvu simi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eie ta kava ka madar tamat, ma e ta ngas vuotongie ngan e Iesu, simi vunan eie ta vatoa ken kulou si kegi sar sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ine bu kepineits kokouk gi nga tsorubeit nia vara tuktuk ngan mi sana nama e Raban ta nga terie i ngutsuon mi propet, ");
INSERT INTO tbf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mi vevien vour ese ta kap ngas telekire ka, ta tian nge kava ka natu madar tamat, ma gi ta vuotongie ngan e Immanuel”, man vuevue va “E Raban a mon meie giet.” ");
INSERT INTO tbf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sien e Iosep ta nga pan, a nga tsana malan ken angelo e Raban ta nga oeng sien, ma a nga reie e Maria. ");
INSERT INTO tbf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Eiekesen, a kap nga mutur meie tuir oit ta nga kava e Natuon tamat, ma e Iosep a nga tour asan ngan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Io, gi nga kava e Iesu i Betilem i aron mi enamon leong i Iudea sibu ra e Erot mi kovakova ka leong ta nga vuortie. Ian sibu ra, ba ka sievei kuvu simi korot mi matanias ta rar tsour en, gituo nga nemei i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma gituo nga virei, “Ivangan ine mi madar gi tanga kava va eie magi Kovakova ka leong bu Iuda? Gatuo nga pare man kaemkaem sien gatuo ta nga mon simi korot mi matanias ta rar tsour en ma ine gatuo te nemei nia rangarie.” ");
INSERT INTO tbf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sien e Erot mi kovakova ka leong ta nga rongomie ine, ine mi nama a nga tsola beitsak ken vienviendon ma buer kegi vienviendon mi kulou kokouk i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma sien e Erot tate nga kuk kakuon bu prist leong ma bu vavvasengei simi vinuor kokouk, a nga vereie gie va ivie mi Messia gi ta kava en. ");
INSERT INTO tbf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Gi nga kuil nama, “I Betilem i aron mi enamon leong i Iudea. Simi vunan arie misa mi propet ta nga vataro, ");
INSERT INTO tbf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Ma evoi, i Betilem, simi kaber se Iuda, e kap lili beitsak i matan bu muomuo ni vuor i Iudea, simi vunan ka muomuo ni vuor ta kovuni sevoi ese va ta naneie kong kulou i Israel malan mi ka nennei sipsip.’” ");
INSERT INTO tbf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Samo e Erot a nga kukuo nge virei menentan ine ba ka sievei, ma a nga vorotan segituo mi sana ra tuktuk mi kaemkaem a nga tsorubeit segituo. ");
INSERT INTO tbf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A nga tura gituo rakot i Betilem meie ngan mi nama malan ne, “Ngatuo ta veis nge neneis kalei ngan ian mi Madar. Ma sien va ngatuo tate vorotan, ngatuo ta muerengei nemei nge me pengan seou, terengien va eou buer o ta mang ra rangarie.” ");
INSERT INTO tbf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","I murien gituo tate nga rorong simi kovakova ka leong, gituo nga sorvekenan. Ma sien gituo ta nga tsuok nge vineis, gituo nga pare te buer ine mi kaemkaem gituo ta be nga pare simi korot mi matanias ta rar tsour en. Io, ine mi kaemkaem a nga muonge gituo oit a nga so tuir i popon mi korot ivie mi natu madar ta nga mon en. ");
INSERT INTO tbf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ma gituo nga res beitsak sien gituo ta nga pare ine mi kaemkaem. ");
INSERT INTO tbf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sien gituo tate nga beit nge rubukien ian simi vonuo, gituo nga pare mi natu madar meie e Maria e kinan. Ma gituo nga sege pukupukukaek nge rangarie. Samo gituo nga tsitsingie kegituo sar poukpouk nge tabeir ngan kegituo sar tienebeir. Ine bu tienebeir arie mi vout kutsukutsuleip gi vuotongie ngan mi gold, a, mi turou sosong gi ko tsana ngan mi uiluiltan mi ei, ma mi mira. ");
INSERT INTO tbf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Io, gituo nga muerengei nge ka simi rosar mene rakot si kegituo enamon, simi vunan e Raban a nga vangenge gituo simi binorea va gituo ta kap nga muerengei rakot se Erot. ");
INSERT INTO tbf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","I murien gituo tate nga veis, ken angelo mi Nguts a nga beit se Iosep i aron mi binorea nge pevien, “Tsuok tamtuir, kerie mi natu madar ma e kinan nge vi rakot i Isip. Ngatuo ta mon ian en oit simi ra o ta ba oeng sevoi, simi vunan e Erot a nesie ine mi natu madar nia kenvamate.” ");
INSERT INTO tbf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Io, a nga tsuok tamtuir nge kerie mi natu madar ma e kinan ian sikati ma gituo nga tsuok nge vineis rakot i Isip. ");
INSERT INTO tbf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma gituo nga mon ian en oit si ken miensei e Erot. Ine mi kepineits a nga tsorubeit nia vaotie mi sana nama mi Nguts ta nga terie i ngutsuon mi propet ven ne, “Kovuni i Isip, o kuk tsana e Natung tamat.” ");
INSERT INTO tbf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sien e Erot tate nga vorotan va ba ka sievei gituo te nga bitie, a nga kengeir beitsak. Ma a nga terie mi nama ngeisngeis nia kenvamate bu natunatu madar tamat kokouk i Betilem ma sibu enamon vatavatat ese gi ta nga avareit luo ma peuk i keim. A nga tsang malan ngan ine vemusurie mi ra ba ka sievei gituo ta nga me pengan surie ken kienakav e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Io, mi sana nama e Raban ta nga terie i ngutsuon e Ieremia mi propet a nga me tsorubeit tuktuk: ");
INSERT INTO tbf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mi kulou gi nga rongomie mi tina leong beitsak i Rama, E Rakel a nga tengisie bu natuon. Ma mi kulou gi nga konon nia vamada, eiekesen a kap nga tor, simi vunan kap te ka natuon a ba buer nga to.” ");
INSERT INTO tbf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","I murien e Erot tate nga maet, ken angelo mi Nguts a nga tsorubeit se Iosep i Isip i aron mi binorea. ");
INSERT INTO tbf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ma a nga oeng ven ne, “Tsuok tamtuir nge kerie mi natu madar ma e kinan nge muerengei rakot simi kaber i Israel, simi vunan egie ese gi ta nga lalaro kenvamate ine mi natu madar, gi te maet.” ");
INSERT INTO tbf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Io, a nga tsuok tamtuir nge kerie mi natu madar ma e kinan nge muerengei rakot simi kaber i Israel. ");
INSERT INTO tbf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Eiekesen, sien ta nga rongomie va e Arkelaus a te nga tsorubeit mi kovakova ka leong i Iudea i murien e taman e Erot, a nga motou nia rakot en. Io, a nga veis rakot simi enamon i Galili vemusurie mi vienengeng ta nga beit sien i aron mi binorea mene te buer. ");
INSERT INTO tbf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ma a nga veis rakot nge mon i aron mi taon mi asan i Nasaret. Ine a nga tsorubeit nia vaotie misana nama e Raban ta nga terie i ngutsugie bu propet ven ne, “Gi ta vuotongie va eie mi kangi Nasaret.” ");
INSERT INTO tbf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ian sibu ra, e Ioanes mi ka ni sinusuruiv a nga beit simi beir simi enamon leong i Iudea ma a nga tsuok vakaek nge vavatei ngan ken nama e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A nga vavatei malan ne, “Nga ta ngas vodon vuris, simi vunan mi ra va e Raban ta vuor a te vatavatat.” ");
INSERT INTO tbf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","E Isaia mi propet a te nga vakokoit surie e Ioanes sien ta nga pevien, “Mi inan mi ka a koupkoup pevien simi beir, ‘Tsang rorois ngan ken rosar mi Nguts. Tsang vodusie ken sar baiveisveis.’” ");
INSERT INTO tbf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Io, e Ioanes a nga ko tsekie man tsetstseik gi ta nga virie ngan mi vuruvuru kamel nge verevere ngan mi piripiri vinavinar, ma man nginonginou mi tsiko ma mi masiu. ");
INSERT INTO tbf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ian sibu ra, egie i Ierusalem ma sibu enamon kokouk i Iudea meie mi kulou kokouk gi ta nga mon vatavatat simi da i Ioridan, gi nga ra nemei se Ioanes. ");
INSERT INTO tbf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma gi nga vakokoit katsep ngan kegi sar sinavei tsokor. Ma e Ioanes a nga tsana mi sinusuruiv segie simi da i Ioridan. ");
INSERT INTO tbf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eiekesen, sien e Ioanes ta nga pare palan bu Parisaio ma bu Sadukaio gi ta nga nemei nia por sinusuruiv, a nga pevien, “Enga bu natuon mi tsotsoi tsak! Ese a nga oeng senga va nga ta oit nia vi ngan ken aor rarap e Raban ian va ta nemei? ");
INSERT INTO tbf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nga ta ngas vua ngan mi banga vuovuo nia vara tuktuk ngan va nga te vodon vuris. ");
INSERT INTO tbf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kian va nga ta vodon va nga ta oit nia pevien ne senga kesenga, ‘E Abaraam, eie e tamagei.’ O oeng senga. E Raban a oit nia tsana ine bu vunavout va gi ta tsorubeit bu natuon e Abaraam. ");
INSERT INTO tbf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mi matou a te mon rorois te i vunan bu ei, ma bu ei kokouk gi ta kap vua ngan kavo banga vuovuo, gi ta tara nge tomekan simi leing.” ");
INSERT INTO tbf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Eou, o tsana mi sinusuruiv senga ngan mi da nia tourtelekiran va nga te vodon vuris. Eiekesen mi ka ta vemusurie iou, a ngeisngeis rio iou. Ma o kap kalei oit nia sorokie man ba poppop. Ma eie ta tsana mi sinusuruiv senga ngan mi Moromoruo Tamat ma mi leing. ");
INSERT INTO tbf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mi napa sosos a te mon siba riman. Eie ta so vitseir rivie mi biror sibu nginonginou, ma ta teir kakuon bu banga nginonginou i aron ken vonuo teteir nginonginou, eiekesen ta tunie bu biror simi leing ian ta kap oit nia maet.” ");
INSERT INTO tbf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Io, e Iesu a te nga kovuni simi enamon leong i Galili nge rakot simi da i Ioridan va ta nga ra por sinusuruiv se Ioanes. ");
INSERT INTO tbf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Eiekesen e Ioanes a nga lalaro vangenge, ma a nga pevien, “Eou o pinat surie va o ta por sinusuruiv sevoi. Surie misa e ta ra nemei seou?” ");
INSERT INTO tbf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eiekesen e Iesu a nga kuil nama, “Sunuir ngan ine va ta malan. Terengien, giet ta mang vaotie bu sinavei duis kokouk e Raban ta lalaro giet nia tsana.” Io, e Ioanes a nga sunurie. ");
INSERT INTO tbf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sien e Iesu tate nga por sinusuruiv voto nge kienbeit simi da, ian ngas te, mi rangit a nga katsep, ma a nga pare mi Morumoruan e Raban a nga tsour peuk malan mi buen nge mogos i popon. ");
INSERT INTO tbf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma mi ien kovuni simi rangit a nga vakokoit ven ne, “Ine e Natung. Eie mi ateung tuktuk ma o resmatan beitsak.” ");
INSERT INTO tbf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Samo mi Moromoruo Tamat a nga kir terie e Iesu simi beir, terengien va mi kovan bu tsaka moromoruo ta nga ra konon. ");
INSERT INTO tbf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma e Iesu a nga vorvor ba sinangavur voveit bu ra ma ba sinangavur voveit bu kati, ma i muir sien a nangba nga vitor. ");
INSERT INTO tbf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Io, ine mi ka ni konokonon, a te nga beit sien nge pevien, “Sien va evoi e Natuon e Raban, oeng ngeisngeis ine sibu vout va gi ta tsorubeit mi tsoik.” ");
INSERT INTO tbf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","E Iesu a nga kuil nama ven ne, “Mi Pakpak Leong a pevien ne, ‘Mi ka a kap oit nia tino ngan mi tsoik mo, eiekesen ta ngas tino ngan bu nama kokouk ian ta kuvu i ngutsuon e Raban.’” ");
INSERT INTO tbf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Samo mi kovan bu tsaka moromoruo, a nga kerie rakot i Ierusalem mi taon tamat, ma a nga ra voturie simi korot ta nga tsiroup i kur simi Vona rengeir leong. ");
INSERT INTO tbf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma a nga oeng sien, “Sien va evoi e Natuon e Raban, tsibour peuk i keim, simi vunan mi Pakpak Leong a pevien, “‘E Raban ta turan ken sar angelo nia pernge no. Gi ta sor terie no i kur ngan bu rimagie, terengien va e ta kap mang duorngan mi kame si ka vout.’” ");
INSERT INTO tbf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","E Iesu a nga kuil nama sien ven ne, “Ma buer mi Pakpak Leong a pevien, ‘Kian va e ta konon mi Nguts, ma Raban.’” ");
INSERT INTO tbf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Samo mi kovan bu tsaka moromoruo a te nga kerie e Iesu kien simi pout i kur beitsak ma a nga vasangan sien bu mangmagoso nguts kokouk simi kaber meie magi sar matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma a nga pevien sien, “Sien va e ta sege pukupukukaek nge rangarie iou, o ta terie sevoi ine bu kepineits kokouk.” ");
INSERT INTO tbf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","E Iesu a nga pevien sien, “Satan! Tsupek sorvekena iou. Mi Pakpak Leong a pevien, ‘E ta ngas rangarie ma Raban mi Nguts ma e ta ngas tsatsang seie mo.’” ");
INSERT INTO tbf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Samo mi kovan bu tsaka moromoruo a te nga sorvekenan, ma bu angelo gi nga ra nemei nge perngan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sien e Iesu tate nga rongomie va gi te nga vurukude e Ioanes simi vona vinatoreis, a nga sorvekenan i Iudea nge rakot i Galili. ");
INSERT INTO tbf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sien ta nga sorvekenan i Nasaret, a nga ra mon i Kapernaum ian ta mon i gegen mi barateis i Galili, si magi kaber mi matabu Sebulon ma Naptali. ");
INSERT INTO tbf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E Iesu a nga veis ven ne, terengien va ta vaotie mi nama e Raban ta nga vorotsoruo i ngutsuon e Isaia mi propet ven ne: ");
INSERT INTO tbf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Magi kaber mi matabu Sebulon ma magi kaber mi matabu Naptali, simi bienangaev peuk simi barateis, i bingan mi da i Ioridan, simi enamon leong i Galili ivie bu Kibang gi ta ko mon en. ");
INSERT INTO tbf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mi kulou gi ta be nga mon simi ngingi leong, gi te nga me pare mi berber leong. Mi kulou gi ta be nga mon simi kaberan mi minoruvien mi miensei, mi berber a te nga rarangie gie.” ");
INSERT INTO tbf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tsuok vakaek ian simi ra, e Iesu a nga vakaek nge vavatei simi kulou ven ne, “Nga vodon vuris, simi vunan mi ra va e Raban ta vuor a te vatavatat.” ");
INSERT INTO tbf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sien e Iesu ta nga vor ve veisveis i gegen mi barateis i Galili, a nga pare ba baser kasien, e Simon gi vuotongie ngan e Petro, ma e kasien e Andre. Guor nga tomeke ben i aron mi barateis, simi vunan eguor ba ka vongovongon. ");
INSERT INTO tbf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma e Iesu a nga oeng seguor, “Ngado nemei nge vemusurie iou. Ma o ta tsana ngado va ngado ta tsorubeit ka nia vangoda mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ian ngas te, guor nga sorvekenan keguor sar ben ma guor nga vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","E Iesu a te buer nga veis rakot i pek lili, ma a nga pare ba baser kasien mene buer, e Iakobo meie e Ioanes, ba natuon e Sebedi. Guor nga mon i popon mi galeu meie e tamaguor e Sebedi ma gi nga name kegi sar ben. Io, e Iesu a nga kukuo guor. ");
INSERT INTO tbf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ian ngas te, guor nga sorvekenan mi galeu meie e tamaguor, ma guor nga vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","E Iesu a nga veis ververiris i Galili kokouk nge vavasengei si kegi sar vona rengeir bu Iuda. Ma a nga vavatei ngan mi Banga Vinavatei surie ken mangmagoso Nguts e Raban ma a nga vatoa bu tamat mienarouk sibu suasua mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Surie ine ken banga tsientsang, gi nga valalame sibu korot kokouk simi provins i Siria. Io, bu mei gi nga kir terie sien egie ese gi ta nga suvuon bu suasua mienarouk ma vinavasor leong, ma bu mei mene bu tsaka moromoruo gi ta nga tsegerie gie, ma bu muru ma bu gong. Ma e Iesu a te nga vatoa gie kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma mi bineit leong kovuni i Galili, i Dekapolis, i Ierusalem, i Iudea ma simi kaber ta mon simi bienangaev ka nikot simi da i Ioridan, gi nga vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sien e Iesu ta nga pare ine mi bineit leong, a nga veis kien i bingan mi pout nge mogos. Ma ken sar madar tovtov gi nga nemei sien. ");
INSERT INTO tbf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Io, a nga vakaek nge vavasengei segie nge pevien: ");
INSERT INTO tbf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mi nires leong ta mon segie ese gi ta ko deng kielala va gi pinat simi morumoruagie, simi vunan gi ta so suvu vavatamaes kovuni si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mi nires leong ta mon segie ese gi ta mon ngan mi tina, simi vunan e Raban ta so vamada gie. ");
INSERT INTO tbf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mi nires leong ta mon segie ese gi ta vous ngan mi molu, simi vunan e Raban ta so vosuvu vunie gie ngan mi kaber. ");
INSERT INTO tbf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mi nires leong ta mon segie ese gi ta ko vietoron nge moruon nia tsana mi sana e Raban ta lalaron va gi ta tsana, simi vunan e Raban ta so vovosuo gie. ");
INSERT INTO tbf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mi nires leong ta mon segie ese gi ta ko aor molous ngan bu mei, simi vunan e Raban ta aor molous nge gie. ");
INSERT INTO tbf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mi nires leong ta mon segie ese kegi tino ta tamat, simi vunan gi ta so pare e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mi nires leong ta mon segie ese gi ta ko vabatie mi ni vedeng i kotubuon mi kulou, simi vunan mi kulou gi ta so vuotongie gie va egie bu natuon e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mi nires leong ta mon segie ese gi ta suvu vinekikin surie gi ta tino ngan mi sinavei duis i matan e Raban, simi vunan gi ta so suvu vavatamaes kovuni si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mi nires leong ta mon senga sien mi kulou gi ta vavangiets nge nga, nge vikikinie nga, ma gi ta pouts bit nge nga ngan bu suasuada tsaka nama surie iou. ");
INSERT INTO tbf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nga ta res beitsak simi vunan e Raban ta so rorois ngan kenga voirvoir leong simi rangit. Ine arie simi rosar kes mo, gi te nga vikikinie bu propet gi ta nga muna tino senga. ");
INSERT INTO tbf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Enga man barateis mi kaber. Eiekesen sien va mi barateis va ta kapangan te ken barabaratasie, kap ka mei a ba oit nia vara barabaratasie ngan te buer. A kap ba kalei nia tsana ngan ka kepineits. Gi ta poro mo nge tomekan ma mi kulou gi ta popoporie. ");
INSERT INTO tbf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Enga man berber mi mangmagoso enaenamon. Mi taon i popon mi pout a kap oit nia kokoiv. ");
INSERT INTO tbf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mi kulou buer gi kap ko vakartie ka bember nge terie i pakien ka koi leong. Eiekesen gi ko poro nge vogosongie si man mogomogos ma ine mi bember ta teir berber sibu mei kokouk i aron mi vonuo. ");
INSERT INTO tbf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Malan mo, kenga sar berber ta ngas ber i matan mi kulou, terengien va gi ta mang pare kenga sar banga tsientsang ma gi ta puongan e Tamanga die i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kian va nga ta vodon va o nga nemei nia tsang rivie mi Vinuor se Moses ma bu nama sibu propet. O kap nga nemei nia tsang rivie gie eiekesen o me tsang vaotie gie. ");
INSERT INTO tbf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","O oeng tuktuk senga. Kap ka puk mat vinavataor lili o, kap ka puk ba tottok lili ine simi Vinuor ta tsereiv, tuir oit ine bu nama kokouk simi vinuor ta muna tsorubeit pu. Ma i muir, mi rangit ma mi kaber guor ta tsereiv. ");
INSERT INTO tbf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Io, eie ese ta pop vuturungie mi meinmenien bu vuna vinuor ta lili beitsak ma ta vasangan sibu mei mene nia tsang malan ngan buer, e Raban ta so terie sien mi as lili beitsak i aron ken mangmagoso Nguts. Eiekesen eie ese ta vemusurie bu vuna vinuor nge vasangan sibu mei mene va gi ta vemusurie, e Raban ta so terie sien mi as leong i aron ken mangmagoso Nguts. ");
INSERT INTO tbf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","O oeng tuktuk senga. Sien va kenga sinavei nia vemusurie mi namanien e Raban ta kap rio ian sibu Parisaio ma sibu vavvasengei sibu vinuor se Moses, nga ta kap oit nia rubukien si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nga te nga rongovan va e Raban ta nga vakokoit simi kulou muomuo malan ne, ‘Kian va e ta kenvamate ka mei. Eie ese ta kenvamate ka mei, ta so tuir simi vinuor.’ ");
INSERT INTO tbf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Eiekesen, o oeng senga, eie ese ta aor rarap veie ka kasien, eie ta so tuir simi vinuor. Ma buer, eie ese ta pevien ngan e palapalan, ‘Evoi mi mat maermaer!’, eie ta ngas so tuir i matan mi Sanedrin. Ma eie ese ta pevien ngan e palapalan, ‘Evoi mi be!’, eie ta so rubukien simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Io, sien va e ta visi terie ke tienebeir rakot se Raban simi korot nia tu tienebeir ma samo e si vodonomie va e palapala a suvuon mi putu veie no, vuturungie ke tienebeir i muan mi korot nia tu tienebeir ma e ta muna rakot nge vodusie mi putu meie e palapala. Samo e ta ba muerengei nge me terie ke tienebeir. ");
INSERT INTO tbf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Sien va mi mei mene ta visi kir terie no simi vinuor, vodusie volopusuo mi putu meie i muan va ngado ta rakot simi vinuor. Sien va e ta kap tsana malan ne, eie ta masi so terie no simi ka ni vuor nama, ma mi ka ni vuor nama ta masi so terie no simi girigirir, ma mi girigirir ta masi so terie no i aron mi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","O oeng tuktuk sevoi, e ta kap oit nia rov tsour simi vona vinatoreis tuir oit va e ta voir vuruvan mi lakep vekvekitip simi vinatoreis.” ");
INSERT INTO tbf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nga te nga rongovan e Raban ta nga vakokoit malan ne, ‘Kian va e ta tsana mi sinavei nia rei puer.’ ");
INSERT INTO tbf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Eiekesen o oeng senga, eie ese ta deng aroie ka vevien, a te tsana mi sinavei nia rei puer i aron. ");
INSERT INTO tbf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sien va ke katsomat suv ta vokorongie no va e ta tsana mi sinavei tsokor, gaol rivie nge tomekan. Simi vunan a kalei va ka korot kes simi kurikuri ta kapangan, surie a kap kalei va mi kurikuri kokouk gi ta tomekan simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma sien va ke riem suv va ta vokorongie no va e ta tsana mi sinavei tsokor, tava nge tomekan. Simi vunan a kalei va ka korot kes simi kurikuri ta kapangan, surie a kap kalei va mi kurikuri kokouk gi ta rubukien simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nga te nga rongovan e Raban ta nga vakokoit malan ne, ‘Ese ka ta ture rivie ken vevien, ta ngas terie sien mi pakapaka rorou nia tourtelekiran va guor te vekapot si keguor mienagos ni rei.’ ");
INSERT INTO tbf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Eiekesen o oeng senga, ese ka ta vekapot sorvekenan ken vevien misasien a kap ngas tsana ka sinavei tetteririv, a tsana ken vevien va ta tsorubeit mi mei simi sinavei ni rei puer. Ma eie ese ta reie ine mi vevien ken labeit ta sorvekenan, eie buer a tsana mi sinavei nia rei puer. ");
INSERT INTO tbf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ma buer, nga te nga rongovan e Raban ta nga vakokoit simi kulou muomuo malan ne, ‘Kian va e ta tsana ka vakavakariem ngan mi binit, eiekesen e ta tuir vemusurie bu vakavakariem e ta nga tsana rakot simi Nguts.’ ");
INSERT INTO tbf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Eiekesen o oeng senga, kian rovoriu va nga ta vakavakariem ngan mi rangit simi vunan eie ken mogomogos e Raban, ");
INSERT INTO tbf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o, ngan mi kaber simi vunan eie ken poppop, o, ngan i Ierusalem simi vunan eie ken taon leong mi Kovakova ka leong beitsak. ");
INSERT INTO tbf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma kian va e ta vuotkov, simi vunan e kap oit nia tsana ka vurvur kes va ta puneits o, megeot. ");
INSERT INTO tbf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nga ta pevien ‘io’ sien va ‘a io’ ma nga ta pevien ‘a kap’ sien va ‘a kap.’ Ka nama mene va nga ta vuotongie a kovuni simi Tsaka Ka. ");
INSERT INTO tbf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nga te nga rongovan e Raban ta nga vakokoit malan ne, ‘Sien va e ta vakale ka mei mene gi ta vakale no buer. Ma sien va e ta tsopukie ka rivon ka mei mene, gi ta tsopukie buer ka rivo.’ ");
INSERT INTO tbf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Eiekesen, o oeng senga, kian va nga ta tuir biritie ka tsaka ka. Sien va ka mei va ta pan ka si ke peir suv, terie buer ke peir kieir. ");
INSERT INTO tbf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sien va ka mei va ta lalaro terie no simi vinuor surie ma kuirkuir, terie sien buer ke lavlav. ");
INSERT INTO tbf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sien va ka mei ta votsuoke no nia veis ka kilomita kes, veisngie meie si kaba kilomita luo. ");
INSERT INTO tbf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tabarie ese ta nongie no, ma kian va e ta ruit se ese ta lalaro poro ka kepineits sevoi. ");
INSERT INTO tbf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nga te nga rongovan e Raban ta nga vakokoit malan ne, ‘E ta ngas tovie bu palapala, ma karto ma matakorot.’ ");
INSERT INTO tbf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eiekesen o oeng senga, nga tovie manga sar matakorot ma nga nongie e Raban surie gie ese gi ta vikikinie nga, ");
INSERT INTO tbf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","terengien va ta mang vara tuktuk ngan va enga bu natuon mi Tam die i kur simi rangit. A ko tsana ken matanias va ta rar i popon mi kulou tsokor ma mi kulou kalei. Ma a ko vovuosongie mi bat i popon mi kulou gi ta duis i matan e Raban ma egie gi ta kap duis. ");
INSERT INTO tbf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ta kap man ka voirvoir sien va nga ta tovie gie ese gi ta tovie nga. Mi kulou porpor takis buer gi ko tsana malan, va gerek? ");
INSERT INTO tbf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sien va nga ta kalei ngan mo bu palapalanga, nga kap kalei vekenan bu mei mene. Bu Kibang buer gi ko tsana malan, va gerek? ");
INSERT INTO tbf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Io, nga ta ngas dokei rovoriu malan mo e Tamanga die i kur simi rangit ta dokei rovoriu. ");
INSERT INTO tbf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nga nenei kalei va nga ta kap tsang vasangan kenga sar sinavei duis i matan mi kulou va gi ta mang tienenge nga surie. Sien va nga ta tsana malan ne, nga ta kap so poro kenga voirvoir se Tamanga simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Io, sien va e ta lalaro tabarie ka sinaortsak, kian va e ta tsana malan bu malamala ka duis gi ta ko tsana. Gi ko kuiv tuvuir i aron bu vona rengeir sibu Iuda ma sibu rosar, terengien va mi kulou gi ta mang puonge gie. O oeng tuktuk senga, gi te por vuruvan kegi voirvoir. ");
INSERT INTO tbf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Eiekesen, sien va e ta lalaro tabarie ka sinaortsak, vemusurie mi saran va ke riem kieir ta kap telekiran misa ke riem suv a tsana. ");
INSERT INTO tbf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Terengien ke sinavei nia tabeir ta mang mon mumuningei. Ma e Tama ta pare misa e ta tsang muningan, ta terie ke voirvoir.” ");
INSERT INTO tbf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ma sien va nga ta no, kian va nga ta malan bu malamala ka duis. Gi ko lalaron beitsak nia tuir nge no i aron bu vona rengeir sibu Iuda ma sibu tangatso rosar va mi kulou gi ta mang pare gie. O oeng tuktuk senga, gi te por vuruvan kegi voirvoir. ");
INSERT INTO tbf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Eiekesen sien va e ta no, rubukien i ruom ma bokutie mi matavanuo nge no rakot se Tama ese kap ka mei ta oit nia pare. Ma e Tama ta pare misa e ta tsang muningan, ta terie ke voirvoir. ");
INSERT INTO tbf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma sien va nga ta no, kian va nga ta teie bu nama palan malan bu Kibang. Gi si vodon va e Raban ta rongomie kegi sar no simi vunan gi teie bu nama palan. ");
INSERT INTO tbf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kian va nga ta mala gie, simi vunan e Tamanga a te muna telekiran mi sana kepineits nga ta lalaro nongie sien. ");
INSERT INTO tbf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Io, nga ta ngas no malan ne; “‘Tamagei die i kur simi rangit, a kalei va gei ta ngas mangaran mi asa. ");
INSERT INTO tbf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A kalei va ke vinuor ta ngas vuortie gei. A kalei va gei ta tor sevoi ine simi mangmagoso enaenamon malan gi ta tor sevoi die i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tabarie gei ngan mi nginonginou ta oit simi ra vere. ");
INSERT INTO tbf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vodon rivie kegei sar sinavei tsokor malan egei gei ta vodon rivie bu sinavei tsokor gi ta tsana segei. ");
INSERT INTO tbf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma kian va e ta tsupuk rivie gei sibu konokonon, eiekesen, vatoa gei i riman mi Tsaka Ka. Mi mangmagoso Nguts, ma mi ngeisngeis, ma mi matvinavaso ta mon sevoi mo sibu ra bu ra. Amen.’ ");
INSERT INTO tbf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sien va nga ta vodon rivie bu sinavei tsokor bu mei gi ta tsana senga, e Tamanga die i kur simi rangit ta vodon rivie buer kenga sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Eiekesen, sien va nga ta kap vodon rivie kegi sar sinavei tsokor bu mei mene, e Tamanga ta kap oit nia vodon rivie kenga sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sien va nga ta vorvor, kian va nga ta mat masitinoiv malan bu malamala ka duis. Gi kap ko vavaso kalei va mi kulou gi ta mang deng kielala va gi vorvor. O oeng tuktuk senga, gi te por vuruvan kegi voirvoir. ");
INSERT INTO tbf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Eiekesen, sien va e ta vorvor, e ta ngas dosie mi vuruvuru kova ngan mi oel nge papariu. ");
INSERT INTO tbf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Terengien mi kulou gi ta kap mang telekiran va e vorvor. Eiekesen e Tama mo ese kap ka mei ta oit nia dengarie, ma ese ta dengarie bu kepineits e ta tsang muningan, ta terie ke voirvoir. ");
INSERT INTO tbf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kian va nga ta teir toungan kenga sar mos ine simi kaber ivie bu ngitsilik ma bu om gi ta tsang vatsakatie, ma bu ka puerpuer gi ta bemrubikien nge pure. ");
INSERT INTO tbf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Eiekesen, teir toungan kenga sar mos die i kur simi rangit ivie bu ngitsilik ma bu om gi ta kap oit nia tsang vatsakatie, ma bu ka puerpuer gi ta kap oit nia bemrubikien nge pure. ");
INSERT INTO tbf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Simi vunan ivie ke mos ta mon en, mi aro buer ta mon en. ");
INSERT INTO tbf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mi katsomat eie man bember mi kuirkuir. Sien va ba katsomata ta kalei, mi kurikuri kokouk ta vous ngan mi berber. ");
INSERT INTO tbf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Eiekesen sien va mi katsomata ta tsak, mi kurikuri kokouk ta vous ngan mi ngingi. Sien va mi berber i aro a ngingi, e tate suvuon mi ngingi e kinagie. ");
INSERT INTO tbf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kap ka mei a oit nia tsatsang petspets si kaba ka leong luo. Eie ta karto ka mei ma ta lalaron ka mei mene. O, eie ta vodon veleongtie ka mei mene ma ta matagout ngan ka mei mene. Nga kap oit nia tsatsang petspets se Raban ma simi lakep. ");
INSERT INTO tbf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Io, o oeng senga, ‘Kian va nga ta vodovodon palan si kenga tino va misa nga ta nganie nge unumie, o misa va nga ta karie ngan kenga pirpir.’ Vasa, mi tino a kap putu rio mi nginonginou, ma mi pirpir a kap putu rio bu poul? ");
INSERT INTO tbf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nga pare bu ma die i kur simi mariu. Gi kap ko tsutsuor niagie o, por nginonginou i tau, o toungan magi kavo nginonginou. Eiekesen e Tamanga die i kur simi rangit a ko tabarie gie. Vasa, a kap vodon veleongtie nga rio bu ma? ");
INSERT INTO tbf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ese mei senga a oit nia vakuora ka keipkepide ra si ken tino ngan mi vodovodon palan? ");
INSERT INTO tbf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma surie misa nga ta vodovodon palan surie man poul bu piripiringa? Nga pare bu gaelgael i uot vasa gi to ven. Gi kap ko tsatsang niagie kesegie o, gi kap ko tsana kavo kepineits nia karie kegi pirpir. ");
INSERT INTO tbf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Eiekesen o oeng senga, e Solomon buer i aron man sar matvinavaso kokouk a kap nga vavaso kalei beitsak malan ka gaelgael. ");
INSERT INTO tbf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E Raban a ko vosonie vakalaie bu uotuot tso ian gi ta to nevere ma sivo gi ta vo tomeke terie gie simi leing. Io, eie ta vosonie nga rio ine bu uotuot tso. Kian va kenga vodovodon tuktuk ta lili mo. ");
INSERT INTO tbf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Io, kian va nga ta vodovodon palan nge pevien, ‘Misa gei ta nganie? o, misa gei ta unumie? o, misa gei ta vavaso ngan?’ ");
INSERT INTO tbf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ine arie bu kepineits bu Kibang gi ko vodovodon palan surie. E Tamanga die i kur simi rangit a telekiran va nga pinat surie ine bu kepineits kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Eiekesen, vourvour, nga ta ngas vengeis nia mon i pakien ken vinuor e Raban ma nga ta ngas vengeis nia tino duis i matan e Raban. Ma e Raban ta ba vosuvu vunie nga ngan ine bu kepineits kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Io, kian va nga ta vodovodon palan surie mi ra sivo, simi vunan mi ra sivo ta vo suvuon man putu kesen. Mi ra keskes a suvuon man putu oit nian ian mi ra. ");
INSERT INTO tbf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kian va nga ta vuortie ka mene surie mi sinavien, simi vunan e Raban ta masi so vuortie nga surie bu sinavinga. ");
INSERT INTO tbf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","E Raban ta so vuortie nga malan vasa nga ta vuortie venengan ka ka mene. Ma mi sana puppuo nga ta pua ngan ka ka mene, arie mo mi puppuo e Raban ta so pua nge nga. ");
INSERT INTO tbf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Surie misa e ta muna dengarie mi poko tsop i matan e kasi ma e kap vodon surie mi poko ei i katsomata kese? ");
INSERT INTO tbf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","E suvuon mi poko ei i mata. Vasa e ta oit ven va e ta oeng se kasi nge kia, ‘Kasi, o ta tsang rivie mi tsop ian i mata,’ ");
INSERT INTO tbf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Evoi mi malamala ka duis! E ta ngas muna tsang rivie mi poko ei i katsomata kese, io, e ta mang so dedeng kalei nge tsang rivie mi poko tsop i katsomatan e kasi. ");
INSERT INTO tbf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kian va e ta terie ka kepineits tamat sibu kopuen. Gi ta vuris mo nge aratie no. Kian va e ta tomekan ke sar re rakot sibu bor. Gi ta bumbut i popon nge tsang vatsakatie. ");
INSERT INTO tbf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nga no ma e Raban ta tabarie nga. Nga neneis ma e Raban ta kulie nga nia neis vorotan. Nga pinpin ma e Raban ta tsitsi vara nga. ");
INSERT INTO tbf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Io, egie ese gi ta no, e Raban ta tabarie gie. Egie ese gi ta neisneis, e Raban ta kulie gie nia neis vorotan. Ma egie ese gi ta pinpin, e Raban ta tsitsi vara gie. ");
INSERT INTO tbf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nga kap ko terie ka vout si ka natunga sien va ta nongie man ka puk tsoik. ");
INSERT INTO tbf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma nga kap ko terie ka tsotsoi si ka natunga sien va ta nongie man ka ie. ");
INSERT INTO tbf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Misasien kenga sinavei a tsokor, nga telekiran nia terie bu banga kepineits sibu natunga. Ma ine, a tuktuk rovoriu va e Tamanga die i kur simi rangit ta lalaron beitsak nia tabarie gie ese gi ta nongie ngan bu banga kepineits. ");
INSERT INTO tbf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Io, sibu kepineits kokouk, tsana sibu mei mene malan e ta lalaron va gi ta tsana sevoi. Ine arie mi petsuon mi Vinuor se Moses ma bu nama sibu propet. ");
INSERT INTO tbf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nga ta ngas rubukien ka simi matasar ta bargurutsits, simi vunan mi matasar simi miensei a lebelebe ma mi rosar nia rakot en a molous ma buer palan bu mei gi veis ka en. ");
INSERT INTO tbf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Eiekesen mi matasar simi tino a bargurutsits ma mi rosar nia rakot en a ngeisngeis beitsak ma ba mei kap vovo mo gi vorotan ian mi rosar. ");
INSERT INTO tbf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nga nenei kalei sibu propet bitbit va gi ta nemei. Simi baidendeng i marar gi ta mala sipsip, eiekesen si kegi tino gi mala kopuen tso. ");
INSERT INTO tbf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nga ta deng kielalagie simi vuovuagie. Bu mei gi kap ko dikitie mi vuavua ta o, mi bereu simi suo tsotso. ");
INSERT INTO tbf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mi banga ei ta vua ngan mi banga vuovuo ma mi tsaka ei ta vua ngan mi tsaka vuovuo. ");
INSERT INTO tbf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mi banga ei a kap oit nia vua ngan ka tsaka vuovuo ma mi tsaka ei a kap oit nia vua ngan ka banga vuovuo. ");
INSERT INTO tbf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma mi sana ei ta kap vua ngan ka banga vuovuan, gi ta tara nge tomekan simi leing. ");
INSERT INTO tbf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Malan ine, nga ta ba deng kielalagie bu propet bitbit simi tsinatsangagie. ");
INSERT INTO tbf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kap va egie kokouk gi ta ko pevien seou va ‘mi Nguts, mi Nguts,’ gi ta so rubukien si ken mangmagoso Nguts e Raban, eiekesen egie ese gi ta ko vemusurie ken lalaron e Tamoung die i kur simi rangit, gi ta so rubukien. ");
INSERT INTO tbf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sien va mi ra e Raban ta vuor ta beit, palan gi ta pevien seou, ‘mi Nguts, mi Nguts. Vasa, gei kap nga vavatei ngan ken nama e Raban simi asa? Ma vasa, gei kap nga kareir rivie bu tsaka moromoruo nge tsana palan bu kepineits ni vovokudier simi asa?’ ");
INSERT INTO tbf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Samo, o ta vakokoit katsep segie, ‘O kap telekira nga rovoriu. Nga tsupek sorvekena iou! Mi sana nga ta nga tsana, a kap toun meie mi vinuor.’ ");
INSERT INTO tbf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Io, eie ese ta rongomie ine kong sar nama nge vemusurie gie, eie a malan mi ka sievei ta nga tsana ken vonuo i popon mi ropoil. ");
INSERT INTO tbf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mi bat a nga uos peuk ma bu da gi nga taev, ma mi mour a nga tsour ngeisngeis veie mi vonuo. Eiekesen mi vonuo a kap nga kor, simi vunan a nga tuir i popon mi ropoil. ");
INSERT INTO tbf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eiekesen eie ese ta rongomie kong sar nama eiekesen ta kap vemusurie gie, eie a malan mi ka be ta nga tsana ken vonuo i popon mi koen. ");
INSERT INTO tbf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mi bat a nga uos peuk, bu da gi nga taev, ma mi mour a nga tsour ngeisngeis nge tsopukie mi vonuo. Ma mi vonuo a nga katsoup kor.” ");
INSERT INTO tbf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sien e Iesu ta nga vaton ine ken sar nama kokouk, mi bineit gi nga kudier tsak ngan ken vinasengei, ");
INSERT INTO tbf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","simi vunan, a kap nga vavasengei malan magi sar vavvasengei sibu vinuor se Moses, eiekesen a nga vateteik ngan mi ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sien e Iesu tate nga peuk kovuni simi pout, mi bineit leong gi nga vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma mi ka ta nga suvuon mi mienarouk lepra a nga nemei seie nge sege pukupukukaek i matan, ma a nga pevien, “Mong Nguts, sien va e ta sunuir, e oit nia vara melemelen nge iou.” ");
INSERT INTO tbf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Io, e Iesu a nga tsotsokan mi riman nge soburo ma a nga oeng sien, “O sunuir. E ta melemelen!” Ian ngas te, a nga tsorubeit melemelen si man mienarouk lepra. ");
INSERT INTO tbf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Samo e Iesu a nga oeng sien, “Rorong! kian va e ta pengan si ka mei mene, eiekesen rakot duis nge vasanga no simi prist, ma terie mi tienebeir rakot se Raban ian e Moses ta nga vokokotie, terengien e ta mang vara tuktuk ngan sibu mei kokouk va e te to si ma mienarouk.” ");
INSERT INTO tbf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sien e Iesu ta nga beit i Kapernaum, mi muomuo simi kulou ni minakiur sibu Roma a nga nemei sien nge no masitinoiv surie ken kuilkuil. ");
INSERT INTO tbf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A nga pevien, “Mi Nguts, kong petspets a morouk mutur i popon mi tsur nikot si kong vonuo. A kap oit va ta vovureis ma a suvuon mi vinavasor leong.” ");
INSERT INTO tbf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","E Iesu a nga oeng sien, “O ta rakot nge vatoa si man mienarouk.” ");
INSERT INTO tbf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ine mi muomuo a nga kuil nama, “Mi Nguts! O kap kalei oit va e ta rubukien si kong vonuo. Eiekesen, e ta vakokoit mo, ma kong petspets ta mang ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Simi vunan eou buer o mon i pakien ken vinuor mong muomuo ma o suvuon buer kong sar petspets gi ta mon i pakien kong vinuor. Ma sien va o ta oeng ngeisngeis seie ine, ‘Veis!’, io, eie ta veis. Ma sien va o ta oeng ngeisngeis seie nikot, ‘nemei!’, io, eie ta nemei. Ma sien va o ta oeng ngeisngeis si kong petspets, ‘Tsana ine!’, io, eie ta tsana.” ");
INSERT INTO tbf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sien e Iesu ta nga rongomie ine, a nga kudier ma a nga pevien simi kulou gi ta nga vemusurie, “O oeng tuktuk senga. O kap nga vorotan ka mei i Israel va ta nga suvuon mi vodovodon tuktuk leong malan ine. ");
INSERT INTO tbf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","O oeng senga! Palan mi kulou gi ta nemei kovuni simi matanias ta rar tsour en ma simi matanias ta ros en. Ma gi ta mogos nge ngou ngan mi nires meie e Abaraam, e Iakop ma e Isak i aron ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Eiekesen egie ese gi ta nga muna mon i aron ken mangmagoso Nguts e Raban, gi ta tomeke vorotsoruo gie simi ngingi e kinagie ma gi ta tata nge vengvengio bu rivogie.” ");
INSERT INTO tbf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Samo e Iesu a nga pevien simi muomuo, “Rakot si ke vonuo! Ta tsorubeit malan e tate vodovodon tuktuk surie.” Ian ngas te, ine mi petspets a te nga ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sien e Iesu ta nga rakot si ken vonuo e Petro, a nga vorotan ken koko e Petro ta nga mutur i popon mi tsur ngan mi mienarouk kuirkuir rarap. ");
INSERT INTO tbf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A nga soburo mi riman ma ine mi vevien a nga to si man mienarouk. Ma a nga tsuok tamtuir nge tsang man nginonginou e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sien tate nga reivreiv seserigo, mi kulou gi nga kir nemei ngan se Iesu palan bu mei bu tsaka moromoruo gi ta nga tsegerie gie. Ma a nga kareir rivie bu tsaka moromoruo ngan mi namanien ma a nga vatoa gie kokouk gi ta nga morouk. ");
INSERT INTO tbf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ine nia vaotie misa e Isaia mi propet ta nga vokokotie, “Eie ngas te, a nga sorokie magiet sar mienarouk ma a nga tsang rivie magiet sar mienarouk.” ");
INSERT INTO tbf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Simi ra mene, sien e Iesu ta nga pare mi bineit gi ta nga beit viririsie, a nga oeng ngeisngeis si ken sar madar tovtov va gi ta nga rakot simi bienangaev ka nikot simi barateis i Galili. ");
INSERT INTO tbf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma samo mi vavvasengei sibu vinuor se Moses a nga nemei sien ma a nga pevien, “Vavvasengei! O ta vemusurie no ivie va e ta rakot en.” ");
INSERT INTO tbf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","E Iesu a nga kuil nama, “Bu kopuen tso gi suvuon magi sar mat nia mutur ma bu ma gi suvuon magi sar tou, eiekesen e Natuon mi Ka a kap ken ka korot nia vuturungie mi kovan.” ");
INSERT INTO tbf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mi meinmenien ken sar madar tovtov a nga pevien, “Mi Nguts, e ta sunuir va o ta be ra muna puonongie e tamoung.” ");
INSERT INTO tbf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Eiekesen e Iesu a nga kuil nama, “Vemusurie iou. tsupuk rivie bu tamat miensei, gi ta puonongie bu turagie miensei.” ");
INSERT INTO tbf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Samo e Iesu a nga ka simi galeu meie ken sar madar tovtov nge tsuk. ");
INSERT INTO tbf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Samo mi lon a si nga tsorungie gie simi barakatsep ma bu naov gi nga vakaek nge kopo vovoi simi galeu. Ian simi keipkepide ra e Iesu a nga muang. ");
INSERT INTO tbf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bu madar tovtov gi nga rakot sien ma gi nga vapada nge oeng sien, “Mi Nguts, Vatoa giet! Giet tate tsokor!” ");
INSERT INTO tbf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","E Iesu a nga kuil nama, “Surie misa nga ta motou? Vasa, kenga vodovodon tuktuk a lili mo?” Samo a nga tuir nge oeng ngeisngeis simi lon ma a nga tiko mi barateis. ");
INSERT INTO tbf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Egie kokouk gi nga kudier tsak nge pevien, “Mi sana suada mei ine? Misasien mi mour ma bu peiv, gi tor surie ken nama!” ");
INSERT INTO tbf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sien e Iesu tate nga beit simi enamon i Gadara simi bienangaev ka nikot simi barateis i Galili, ba ka guor ta nga ko mon sibu rie puppuon guor nga rovotsour nge suoeie e Iesu. Ine ba ka bu tsaka moromoruo gi te nga tsegerie guor ma buer guor nga ko ngengeir beitsak, ma kap ka mei a ba nga oit va ta nga veis ka ian simi rosar. ");
INSERT INTO tbf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Samo guor nga koup leong, “Natuon e Raban, ke sana baitutuir meie gor? E te nemei nia me votorosie gor i muan mi ra e Raban ta nga totok telekiran?” ");
INSERT INTO tbf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mi varin bor leong gi nga vivieir nikot i pek lili. ");
INSERT INTO tbf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Samo bu tsaka moromoruo gi nga oeng se Iesu, “Sien va e ta kareir rivie gei, ture varakoto gei i aron nikot bu bor.” ");
INSERT INTO tbf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Nga rakot!” e Iesu a nga oeng segie. Io, gi nga tsour vekena guor ma gi nga rakot i aron bu bor. Ine mi varin bor kokouk, gi nga soer peuk simi mala tsetseir ma gi nga tsibour i rou nge kong maet. ");
INSERT INTO tbf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mi kulou gi ta nga naneie bu bor, gi nga vi nge soer rakot simi taon nge pengan ine bu kepineits kokouk ta nga tsorubeit ma misa ta nga beit siba ka bu tsaka moromoruo gi ta nga tsegerie guor. ");
INSERT INTO tbf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Io, bu mei kokouk kovuni simi taon gi nga rovotsour va gi ta nga ra suoeie e Iesu. Sien gi tate nga vorotan, gi nga oeng sien va ta nga sorvekenan kegi enamon. ");
INSERT INTO tbf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Io, e Iesu a nga ka simi galeu leong ma a nga tsourarak simi barateis i Galili nia muerengei rakot si ken enamon. ");
INSERT INTO tbf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma ba ka gituo nga sor terie sien mi muru ta nga mutur i popon mi tsur. Sien e Iesu ta nga deng kielala kegituo vodovodon tuktuk, a nga oeng simi muru, “Kian va e ta vodovodon palan, natung. Ke sar sinavei tsokor o te vodon rivie.” ");
INSERT INTO tbf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma bu vavvasengei sibu vinuor se Moses gi nga ngungu lili segie kesegie nge kia, “Ine mi ka a oeng balapoik ngan e Raban!” ");
INSERT INTO tbf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","E Iesu a te nga telekiran misa gi nga vodonomie. Samo a nga oeng segie, “Surie misa nga ta suvu tsaka vienviendon? ");
INSERT INTO tbf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mi sana nama a molous nia vokokotie? ‘Ke sar sinavei tsokor o te vodon rivie.’ o, ‘Tsik tamtuir nge veis.’? ");
INSERT INTO tbf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Io, o ta vakatsepa senga va e Natuon mi Ka a suvuon mi duis i popon mi kaber nia vodon rivie bu sinavei tsokor.” Ma a nga oeng simi muru, “Tsik tamtuir. Sorokie ke mutumutur nge rakot si ke enamon.” ");
INSERT INTO tbf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Io, ine mi ka a nga tsik tamtuir nge muer rakot si ken enamon. ");
INSERT INTO tbf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sien mi bineit gi ta nga pare ine, gi nga kudier tsak ma gi nga puongan e Raban ese ta nga turan mi ka meie ngan ine mi suada ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E Iesu a nga sorvekenan ian mi enamon. Ma sien ta nga vor ve veisveis, a nga pare mi ka porpor takis, mi asan e Mataio. A nga mogos i aron ken korot nia tsatsang. E Iesu a nga oeng sien, “Vemusurie iou!” Ma e Mataio a nga tamtuir nge vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sien e Iesu ma ken sar madar tovtov gi ta nga vor ve ngongou i aron ken vonuo e Mataio, palan bu ka porpor takis ma mi kulou tsokor, gi nga nemei nge me ngou kokouk meie gie. ");
INSERT INTO tbf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bu mene segie bu Parisaio gi nga pare ine ma gi nga vereie ken sar madar tovtov e Iesu, “Surie misa manga vavvasengei ta ngou meie bu ka porpor takis ma mi kulou tsokor?” ");
INSERT INTO tbf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","E Iesu a nga rongomie gie ma a nga kuil nama, “Mi kulou gi ta tino kalei, gi kap pinat surie ka porpor oiv, eiekesen egie mo gi ta suvu mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nga ta rakot nge menise surie mi sana mi vunan mi Pakpak Leong ta vakokoit malan ne, ‘O lalaron mi aor molous, kap va mi tienebeir ni varam. Kap va mi varam ngan mi vinavinar’ O kap nga nemei nia me kukuo mi kulou duis i matan e Raban, eiekesen bu mei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Samo ken sar madar tovtov e Ioanes mi ka ni sinusuruiv gi nga nemei se Iesu nge vosuoreie, “Surie misa egei ma bu Parisaio gei ko vorvor, eiekesen ke sar madar tovtov gi kap ko vorvor?” ");
INSERT INTO tbf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","E Iesu a nga kuil nama, “Ken sar vasier mi ka rei vour, gi ta kap oit nia masitinoiv sien va ta ngas mon meie gie. Eiekesen mi ra ta beit, va gi ta kir tsana ine mi ka rei vour i kotubugie. Io, gi ta nangba so vorvor.” ");
INSERT INTO tbf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kap ka mei a ko dekitie ka poko lavlav vour ta kap ngas suok si ka lavlav kebeir, simi vunan ian mi poko lavlav vour ta suok nge tsana mi kadeir ta leong. ");
INSERT INTO tbf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma a kap buer ka mei a ko soe teir dangi vain vour i aron bu utut kebeir gi ta tsana nge piripiri vinavinar. Sien va gi ta tsang malan ngan, bu utut gi ta puor kapot, ma mi dangi vain ta puos ririv ma bu utut gi ta tsak. Eiekesen, gi ko soe terie mi dangi vain vour i aron bu utut vour, terengien eguor kokouk guor ta mang mon kalei.” ");
INSERT INTO tbf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sien e Iesu ta ngas nga vor ve vokovokokotie ine bu nama, mi muomuo simi vona rengeir sibu Iuda a nga nemei ma a nga sege pukupukukaek i matan ma a nga pevien, “E natung vevien ine mo a ba maet. Eiekesen, nemei nge me soburo, terengien va ta mang to.” ");
INSERT INTO tbf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","E Iesu a nga tamtuir ma a nga nomeie ine mi muomuo, ma ken sar madar tovtov gi nga vemuir buer. ");
INSERT INTO tbf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Samo mi vevien, ese ta nga suvuon mi mienarouk nia kavakava mi dar sibu avareit mi sinangavur kes ma luo, a nga ka i murien e Iesu. Ma a nga tobelie ken lavlav. ");
INSERT INTO tbf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ine mi vevien a nga vodon i aron ven ne, “Sien va o ta tobelie mo ken lavlav, o ta ketseketseng.” ");
INSERT INTO tbf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","E Iesu a nga vuvuris nge pare ma a nga pevien, “Natung, kian va e ta vodovodon palan! Ke vodovodon tuktuk a te vatoa no.” Ian ngas te mi vevien a nga ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sien e Iesu tate nga so rubukien i aron ken vonuo ian mi muomuo, a nga pare ba ka guor ta nga kuvie ba tatu ngan bu paka miensei ma egie ian gi ta nga ta i babaren mi tetsikevien. ");
INSERT INTO tbf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma a nga pevien, “Nga tsupek varan mi tetsikevien. Ine mi tetsikevien a kap mesei, a muang mo.” Eiekesen gi si nga vavangiets ngan. ");
INSERT INTO tbf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","I murien mi bineit gi tate nga rovotsour i marar, e Iesu a nga rubukien si ken korot mutumutur ian mi tetsikevien ma a nga por ka i riman ma mi tetsikevien a nga tsiktamtuir. ");
INSERT INTO tbf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mi nama surie ine mi kepineits a nga rorongovei sibu enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sien e Iesu tate nga veis kovuni en ian, ba kael guor nga vemusurie, ma guor nga koupkoup, “Tovie gor, Natuon e Davit!” ");
INSERT INTO tbf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sien e Iesu tate nga so rubukien i aron mi vonuo, ian ba kael guor nga nemei seie, ma a nga vosuoreie guor, “Ngado vodovodon tuktuk va o oit nia vakalaie bu katsomatangado?” Guor nga kuil nama, “Io, mi Nguts.” ");
INSERT INTO tbf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Samo a nga soburo bu katsomataguor nge pevien, “Surie mo kengado vodovodon tuktuk ine ta tsorubeit malan sengado.” ");
INSERT INTO tbf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma bu katsomataguor a nga katsep. E Iesu a nga vengeng vangvangasie guor, “Ngado ta kap pengan ine si ka mei mene.” ");
INSERT INTO tbf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eiekesen guor nga rovotsour ma guor nga veis nge vor ve pepengan sibu enamon kokouk misa ta nga tsorubeit seguor. ");
INSERT INTO tbf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sien e Iesu meie ken sar madar tovtov gi tate nga veis rovotsour, mi kulou gi si nga kir terie se Iesu mi ka ese mi tsaka moromoruo ta nga tsegerie nge vara ngong ngan. ");
INSERT INTO tbf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma sien e Iesu tate nga kareir rivie mi tsaka moromoruo sien, a nangba nga vakaek nge patar. Mi bineit gi nga kudier tsak ma gi nga pevien, “Kap ka kepineits malan ne gei nga pare i Israel oit nevere.” ");
INSERT INTO tbf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Eiekesen bu Parisaio gi nga pevien, “Eie a kareir rivie bu tsaka moromoruo ngan mi ngesengesien mi kovan bu tsaka moromoruo.” ");
INSERT INTO tbf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","E Iesu a nga veisngie bu taon ma bu enamon kokouk. Ma a nga vavasengei i aron kegi sar vona rengeir bu Iuda. Ma a nga vavatei ngan mi Banga Vinavatei surie ken sinavei nia vuor e Raban, ma a nga vatoa bu tamat mienarouk sibu suasuada mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sien e Iesu ta nga pare mi bineit, a nga tovie gie, simi vunan gi nga mon ngan mi mientou ma mi masitinoiv malan bu sipsip kap magi ka ka nennei. ");
INSERT INTO tbf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Samo e Iesu a nga oeng si ken sar madar tovtov, “Mi nginonginou tate komois a palan beitsak, eiekesen mi kulou ni tsientsang nia por nginonginou i tau a kap palan. ");
INSERT INTO tbf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nga ta nongie e Taman mi tau ian tate komois va ta turan mi kulou ni tsientsang nia por nginonginou si ken tau.” ");
INSERT INTO tbf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","E Iesu a nga kukuo mi sinangavur kes ma luo ken sar madar tovtov nemei sien ma a nga teir ngeisngeis segie nia kareir rivie bu tsaka moromoruo ma nia vatoa bu tamat mienarouk sibu suasua mienarouk simi kuirkuir ma bu mienarouk leong. ");
INSERT INTO tbf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ine arie bu asagie mi sinangavur kes ma luo bu aposol; mi mei vourvour, e Simon (ese gi ta vuotongie ngan e Petro) ma e kasien e Andre, e Iakobo meie e Ioanes ba natuon e Sebedi, ");
INSERT INTO tbf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","e Pilipo, e Bartolomeu, e Tomas, e Mataio mi ka porpor takis, e Iakobo e natuon e Alpeo ma e Tadeo, ");
INSERT INTO tbf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","e Simon mi Silot, ma e Iudas Iskariot ese ta nga tuir murien veie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ine mi sinangavur kes ma luo, e Iesu a nga ture vavasie gie ngan ine bu nama vinavanou, “Kian va nga ta rakot i kotubuon bu Kibang o, rubukien si ka taon mene sibu Samaria. ");
INSERT INTO tbf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Eiekesen, nga ta rakot mo nia ra nesie bu sipsip kovuni i Israel gi ta nga veis bebeir. ");
INSERT INTO tbf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sien va nga ta veis, nga ta vavatei ngan ine mi nama, ‘Mi ra va e Raban ta vuor a te vatavatat.’ ");
INSERT INTO tbf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nga ta vatoa bu tamat mienarouk ma bu tamat miensei. Nga ta vara melemelen nge gie ese gi ta suvuon mi mienarouk lepra, ma kareir rivie bu tsaka moromoruo. O te nga teir resres ngan senga ine mi ngeisngeis, io, enga buer nga ta ngas tabeir resres. ");
INSERT INTO tbf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kian va nga ta poro kavo gold, silva, o, kina ma toea meie nga. ");
INSERT INTO tbf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kian va nga ta poro ka vovvoi nian mi vineis o, kavo vevveleis o, ka poppop mene o, ka vaong. Simi vunan, mi ka tsientsang, gi ta vaotie ken sar pinat. ");
INSERT INTO tbf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mi sana taon o, enamon nga ta rubukien en, nga ta nesie ka mei ta oit nia marangata nga. Ma nga ta mon meie si ken vonuo oit nga ta sorvekenan ine mi enamon. ");
INSERT INTO tbf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sien va nga ta rubukien si ka vonuo, vuot kalei segie. ");
INSERT INTO tbf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sien va ine mi vonuo gi ta resmata nga, momonongie mi namani molu meie gie, ma sien va gi ta kap resmata nga, por muerngan mi namani molu segie. ");
INSERT INTO tbf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sien va ka mei ta kap resmata nga o, ta kap rorong si kenga sar nama, titike rivie mi puit sibu kamenga sien va nga ta sorvekenan ian mi vonuo o, mi taon. ");
INSERT INTO tbf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","O oeng tuktuk senga, simi rangi vinuor, mi vinatoreis segie i Sodom ma i Gomora ta mamavuek beitsak vekenan simi kulou ian simi taon. ");
INSERT INTO tbf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","pare! O tura nga malan bu sipsip i kotubuon bu kopuen tso. Io, nga ta sievei malan bu tsotsoi ma nga ta menemenen malan bu buen. ");
INSERT INTO tbf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Nenei kalei simi kulou, surie gi ta terie nga simi vinuor, gi ta tsatsakie nga i aron bu vona rengeir sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Surie iou mo, gi ta voturie nga i matan bu gavana ma bu kovakova ka leong va nga ta vavatei ngan mi Banga Vinavatei segie ma sibu Kibang. ");
INSERT INTO tbf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Eiekesen, sien va gi ta voturie nga simi vinuor, kian va nga ta vodovodon pilang surie misa nga ta pengan o, vasa nga ta vakokoit ven. Ian simi keipkepide ra, nga ta so telekiran mi sana nga ta pengan. ");
INSERT INTO tbf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Simi vunan kap va enga nga ta vakokoit, eiekesen mi Morumoruan e Tamanga ta vakokoit i ngutsunga. ");
INSERT INTO tbf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mi kulou gi ta so roev terie bu kasigie va gi ta kenvamate gie, ma bu tam gi ta tsana ine mi sinavei kes malan mo sibu natugie. Bu nout gi ta leiltsei sibu tam ma kien ma gi ta terie bu tamagie ma kinagie va gi ta kenvamate gie. ");
INSERT INTO tbf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mi kulou kokouk gi ta so matakorot nge nga surie mi asoung, eiekesen eie ese ta tuir ngeisngeis oit simi votovoto, e Raban ta so vatoa. ");
INSERT INTO tbf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sien va gi ta tsang vatsakatie nga si ka enamon, sorvekena gie rakot si ka enamon mene. O oeng tuktuk senga, nga ta kap ngas oit nia vuruvan kenga tsientsang sibu taon kokouk i Israel i muan va e Natuon mi Ka ta muerengei. ");
INSERT INTO tbf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kap ka madar tovtov a leong si man vavvasengei, o, kap ka petspets va ta leong si man ka leong. ");
INSERT INTO tbf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eiekesen, a oit ka madar tovtov va ta tsorubeit malan man vavvasengei, ma ka petspets ta tsorubeit malan man ka leong. Ma sien va mi kovan mi tietie arie mi mei va gi ta vuotongie ngan e Belsebul, egie ian simi tietie, gi ta suvuon bu as ta tsak rovoriu. ");
INSERT INTO tbf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Io, kian va nga ta motovagie. Mi sana kepineits ian gi ta nga sarkuva, ta vasvas, ma mi sana kepineits ta mumuningei, ta tsorubeit simi taparang. ");
INSERT INTO tbf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Misa o ta vokokotie senga simi ngingi, nga ta vokokotie simi taparang, ma misa o ta vemisir ngan i tateringanga, nga ta kuiv tuvuir ngan i pungan mi vonuo. ");
INSERT INTO tbf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kian va nga ta motovagie ese gi ta kenvamate mo mi pirpir eiekesen gi ta kap oit nia kenvamate mi moromoruo. Eiekesen nga ta ngas motovan e Raban ese ta oit nia voguersan kokouk mi moromoruo ma mi pirpir simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nga ta oit nia vorie kaba ma luo ngan ka toea kes mo, eiekesen kap ka ma ta kor simi kaber sien va e Tamanga ta kap sunuir. ");
INSERT INTO tbf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma buer ian bu vurvur i kovanga, a te mon simi aesaes se Raban. ");
INSERT INTO tbf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Io, kian va nga ta motou. Kenga tino a potokivout rio bu ma palan. ");
INSERT INTO tbf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Sien va ka mei ta vakokoit vasangan simi kulou va eie seou, eou buer o ta ba vakokoit vasangan i matan e Tamoung simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Eiekesen, sien va ka mei ta vakokoit i matan mi kulou va a kap vodovodon tuktuk seou, eou buer o ta ba vakokoit i matan e Tamoung va eie kap va seou. ");
INSERT INTO tbf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kian va nga ta vodon va o nemei nia terie mi molu ine simi kaber. O kap nga nemei nia terie mi molu, eiekesen mi sele nian mi minakiur. ");
INSERT INTO tbf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma o nemei nia tsana va, “‘mi ka ta matakorot veie e taman, mi vevien ta matakorot veie e kinan, ba baser anan guor ta ve matakorot, ");
INSERT INTO tbf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","man matakorot mi ka ta kovuni ngas te i aron ken vonuo.’ ");
INSERT INTO tbf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Eie ese ta lalaron beitsak e taman o, e kinan rio iou, a kap kalei oit nia tsorubeit kong ka ni tsientsang. Ma eie ese ta lalaron beitsak e natuon tamat o, e natuon vevien rio iou, a kap kalei oit nia tsorubeit kong ka ni tsientsang, ");
INSERT INTO tbf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ma eie ese ta kap sorokie man koitskoits nge vemusurie iou, eie a kap kalei oit nia tsorubeit kong ka ni tsientsang. ");
INSERT INTO tbf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Eie ese ta ruit ngan ken tino ta votsorovie, ma eie ese ta votsorovie ken tino surie iou ta suvuon mi tino. ");
INSERT INTO tbf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Eie ese ta suguo nga, a suguo iou, ma eie ese ta suguo iou, a suguo eie ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Eie ese ta resmatan mi propet simi vunan eie mi propet, ta suvuon ken potpot si ken voirvoir mi propet. Ma eie ese ta resmatan mi ka duis simi vunan eie mi ka ta duis i matan e Raban, ta suvuon ken potpot si ken voirvoir ine mi ka duis. ");
INSERT INTO tbf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma sien va ka mei ta teir vunie ngan ka mei sasavoir ka koi da tuong surie eie kong madar tovtov, o oeng tuktuk senga, eie ta kap ba votsorovie ken voirvoir.” ");
INSERT INTO tbf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","I murien e Iesu tate nga vakokoit vasangan mi tsientsang simi sinangavur kes ma luo ken sar madar tovtov, a nga sorvekenan ian mi korot nge rakot sibu taon i Galili ivie a nga ra vavasengei nge vavatei ngan mi Banga Vinavatei en. ");
INSERT INTO tbf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sien e Ioanes mi ka ni sinusuruiv ta nga mon i aron mi vona vinatoreis nge rongovan bu kepineits e Iesu Karisito ta nga tsana, a nga turan ken sar madar tovtov rakot sien. ");
INSERT INTO tbf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma gi nga ra vosuoreie, “Pengan segei. Arie evoi te, ian mi Ka va ta ba beit, o, gei ta rosie ngas ka mei mene?” ");
INSERT INTO tbf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","E Iesu a nga kuil nama, “Nga ra pengan se Ioanes misa nga ta rongomie nge pare. ");
INSERT INTO tbf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bu kael gi te dedeng, bu peong gi te veis, ma egie ese gi ta suvuon mi mienarouk lepra gi te tsorubeit melemelen, bu pi gi te rorong, bu mei maet gi te to muerengei simi miensei ma bu sinaortsak gi te rongomie mi Banga Vinavatei. ");
INSERT INTO tbf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mi nires leong ta mon seie ese ken vodovodon tuktuk seou ta kap kor.” ");
INSERT INTO tbf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sien ken sar madar tovtov e Ioanes gi tate nga muerengei, e Iesu a nga vakaek nge vakokoit simi bineit surie e Ioanes, “Sien nga ta nga rakot simi beir, misa nga nga visi ra pare? Mi rir mi mour ta uvie? ");
INSERT INTO tbf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Sien va a kap, mi sana nga nga ra visi dengarie? Mi ka ta vavaso ngan bu banga tsetstseik? A kap, egie ese gi ta ko vavaso ngan bu banga tsetstseik gi ko mon i aron bu vonuo sibu kovakova ka leong. ");
INSERT INTO tbf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Io, surie misa nga ta nga rakot en? Nia ra pare mi propet? A tuktuk, o oeng senga, nga te nga pare mi ka mi tsinatsangan ta rio mi propet. ");
INSERT INTO tbf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ine arie mi ka ese gi ta nga vavataor surie simi Pakpak Leong, “‘O ta turan kong ka ni vavatei muo sevoi, ese ta rorois ngan ke rosar i muo sevoi.’ ");
INSERT INTO tbf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","O oeng tuktuk senga, i kotubugie ian mi langei gi ta nga kava gie, a kap ka mei a leong rio e Ioanes mi ka ni sinusuruiv, eiekesen mi mei ese ta lili sibu mei gi ta mon si ken mangmagoso Nguts e Raban, eie a leong rio e Ioanes. ");
INSERT INTO tbf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Vakaek sibu ra se Ioanes mi ka ni sinusuruiv tuir oit ine, ken mangmagoso Nguts e Raban a vor ve leongleong meie ngan mi ngeisngeis leong, ma mi kulou per gi routsana meie ngan mi ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bu propet ma mi Vinuor se Moses, tuir oit se Ioanes, gi nga vokokotie surie mi sana kepineits va ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma sien va nga ta tor nia vodovodon tuktuk si kegi sar nama, vodovodon tuktuk va e Ioanes arie eie e Eliia ese gi ta nga vokokotie va ta nga beit. ");
INSERT INTO tbf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eie ese ta suvu taterieng nia rorong, ta ngas rorong. ");
INSERT INTO tbf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Misa o ta oit nia pua ngan mi kuoluon ine bu ra? Gi malan bu natu madar gi ta mogos simi korot nia verikuil nge kepineits. Mi gargar ka ie gi koupkoup rakot simi gargar ka ie malan ne, ");
INSERT INTO tbf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Gei kuvie bu pak ngan bu poko veos va nga ta sieng, eiekesen nga kap sieng. Gei kavarie bu pak nian mi miensei, eiekesen nga kap ta.’ ");
INSERT INTO tbf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E Ioanes a nga beit ma a kap nga ngou nge un dangi vain, ma bu mei kokouk gi nga pevien, ‘Eie a suvuon mi tsaka moromoruo!’ ");
INSERT INTO tbf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","E Natuon mi Ka a nga beit ma a nga ngou nge un, ma bu mei gi nga pevien, ‘Nga pare! Eie mi ka ngo ngeis ma mi ka unun, ma e palapalan mi kulou porpor takis meie mi kulou tsokor!’ Eiekesen mi kulou ese gi ta tino ngan mi banga vienviendon se Raban, gi vara tuktuk ngan va ine mi banga vienviendon a duis.” ");
INSERT INTO tbf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Samo e Iesu a nga vakaek nge vakokoit petseir veie bu taon ivie palan bu kepineits ni vovokudier a nga tsana en, simi vunan gi kap nga vodon vuris. ");
INSERT INTO tbf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mi tsienakor leong ta ba so beit sevoi, i Korasin! Ma evoi buer i Betsaida! Sien va ian bu kepineits ni vovokudier o ta nga tsana senga va o nga tsana i Turos ma i Sidon, kebeir ngas te, va gi nga tsekie bu tsetstseik bita nge soute puit i popogie nia vasangan va gi te nga vodon vuris. ");
INSERT INTO tbf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eiekesen o oeng sengado, simi rangi vinuor, ngado ta so suvuon mi vinatoreis leong rio i Turos ma i Sidon. ");
INSERT INTO tbf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma evoi i Kapernaum, vasa, gi ta tsuok terie no i kur kien simi rangit? A kap, gi ta tomeka no peuk rovoriu i keim i Ades Sien va bu kepineits ni vovokudier o ta nga tsana sevoi va o nga tsana i Sodom, nevere va a ngas mon. ");
INSERT INTO tbf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eiekesen o oeng sevoi, simi rangi vinuor, e ta so suvuon mi vinatoreis leong rio i Sodom.” ");
INSERT INTO tbf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ian simi keipkepide ra, e Iesu a nga pevien, “Tama. Evoi man Nguts mi rangit ma mi kaber. O puonge no surie e nga muningan ine bu kepineits sibu ka sievei ma segie ese gi ta nga suvu vinasengei, eiekesen e nga vasangan sibu natu madar. ");
INSERT INTO tbf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A tuktuk, Tama, si ke lalaron kese, ine mi kepineits a nga tsorubeit malan.” ");
INSERT INTO tbf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ine bu kepineits kokouk e Tamoung a te nga terie seou. Kap ka mei a telekiran va mi Nout eie ese, eiekesen mi Tam kesen mo, ma kap ka mei a telekiran va mi Tam eie ese, eiekesen mi Nout kesen mo ma egie ese mi Nout ta vile gie nia vasangan segie. ");
INSERT INTO tbf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Enga kokouk ese nga ta matpomaer nge sorokie mi sinor putu, nga nemei seou. Ma o ta terie mi minaes senga. ");
INSERT INTO tbf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nga poro kong aigor nge terie i poponga, ma nga ta tovtov seou, simi vunan o suvuon mi molu ma mi sinavei menemenen, ma nga ta so vorotan mi minaes si kenga tino. ");
INSERT INTO tbf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Simi vunan mi aigor va o ta terie senga, a molous ma mi sinor va o ta terie senga, a mamavuek.” ");
INSERT INTO tbf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Io, ba ra a te nga rovoriu ma simi Rangi Minaes te, e Iesu meie ken sar madar tovtov gi nga veis ka i aron bu tau wit. Ma ken sar madar tovtov gi te nga vitor ma gi nga do tsana bu kievkiev wit mene nge nganie. ");
INSERT INTO tbf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sien bu Parisaio gi ta nga pare ine, gi nga oeng se Iesu, “Pare! ke sar madar tovtov gi tsana mi sinavei a kap vemusurie man vinuor mi Rangi Minaes.” ");
INSERT INTO tbf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E Iesu a nga oeng segie, “Vasa, nga kap ngas nga ase mi sana e Davit ma bu palapalan gi ta nga tsana sien gi ta nga vitor? ");
INSERT INTO tbf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A nga rubukien si ken vonuo e Raban, meie bu palapalan ma gi nga nganie mi tsoik tamat ian gi ta kap nga oit nia nganie vemusurie mi vinuor, eiekesen bu prist mo gi ta oit nia nganie. ");
INSERT INTO tbf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Vasa, nga kap ngas ase mi nama simi Vinuor se Moses ian ta pevien va sibu Rangi Minaes, bu prist gi ko pop vuturungie mi Vinuor simi vunan gi ko tsana kegi tsientsang prist simi Vona rengeir leong, eiekesen gi pevien va bu prist gi kap tsana ka tsienakor? ");
INSERT INTO tbf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","O oeng senga, mi kepineits ian ta leong rio mi Vona rengeir leong, a te beit. ");
INSERT INTO tbf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mi vinavataor simi Pakpak Leong a vakokoit malan ne, ‘O lalaron mi aor molous, kap va mi tienebeir ni varam. A kap va mi varam ngan mi vinavinar’ Sien va nga katsep si man papapleis ine mi nama, nga kap oit nia votorosie bu mei gi ta kap suvu bienebeir, ");
INSERT INTO tbf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","simi vunan e Natuon mi Ka eie man Nguts mi Rangi Minaes.” ");
INSERT INTO tbf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E Iesu a nga veis sorvekenan ian mi korot, ma a nga rubukien si kegi vona rengeir bu Iuda. ");
INSERT INTO tbf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mi ka riem maet a nga mon ian en. Io, gi nga vosuoreie e Iesu, “A duis simi vinuor nia vatoa ka tamat mienarouk simi Rangi Minaes?” gi nga virei malan ne simi vunan gi nga lalaro vepitsie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","E Iesu a nga oeng segie, “Sien va ka mei senga a suvuon ken ka sipsip ma ine mi sipsip a kor loloim si ka mat simi Rangi Minaes, vasa, ine mi ka ta kap tei terie i kur ine mi sipsip?” ");
INSERT INTO tbf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eiekesen, mi ka, ken tino a potokivout rio mi sipsip. Io, a duis i matan mi vinuor va giet ta tsana mi banga sinavei simi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Samo e Iesu a nga oeng ian simi ka malan ne, “Kadosan mi rima.” Io, a nga kadosan mi riman ma mi riman a te buer nga kalei malan mi riman ka ie. ");
INSERT INTO tbf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Eiekesen bu Parisaio gi nga rovotsour nge ra roev nian e Iesu va vasa gi ta nga kenvamate venengan. ");
INSERT INTO tbf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E Iesu a nga telekiran misa bu Parisaio gi ta nga tsana, ma a nga sorvekenan ian mi korot. Palan mi kulou gi nga vemusurie ma a nga vatoa gie kokouk si magi sar mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma a nga vangenge gie va gi ta kap nga pepengan va eie ese. ");
INSERT INTO tbf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ine a vaotie mi sana e Isaia mi propet ta nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ine arie kong ka ni tsientsang, ese o ta nga vile, mi mei o ta tovie nge resmatan. O ta terie mi Morumoruong i popon ma eie ta vavatei ngan mi sinavei duis nia vuor sibu Kibang. ");
INSERT INTO tbf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eie ta kap vevvengeis nge nama o, koupkoup, ma kap ka mei ta rongomie mi inan sibu rosar. ");
INSERT INTO tbf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eie a kap oit nia do rivie ka pakapaka meitsmeits ta korot tekiu. Ma ta kap oit nia kuiv vamate ka puk berber lili, tuir oit va ta tsana mi sinavei duis ian va ta tseiptseiprio mi sinavien mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma simi asan, bu Kibang gi ta terie kegi vodovodon tuktuk sien.” ");
INSERT INTO tbf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Samo gi nga kir nemei ngan se Iesu mi ka ese mi tsaka moromoruo ta nga tsegerie, a nga kael ma a nga ngong. Ma e Iesu a nga vatoa ine mi ka, io, a nangba nga oit nia vakokoit nge dedeng. ");
INSERT INTO tbf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mi kulou kokouk gi nga kudier tsak ma gi nga pevien, “Tavakier, ine mi ka eie nieng e natuon e Davit?” ");
INSERT INTO tbf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Eiekesen sien bu Parisaio gi ta nga rongomie ine, gi nga pevien, “Ine mi ka a kareir rivie bu tsaka moromoruo ngan mo mi ngesengesien e Belsebul mi kovan bu tsaka moromoruo.” ");
INSERT INTO tbf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","E Iesu a nga telekiran kegi sar vienviendon ma a nga oeng segie, “Ka mangmagoso nguts va ta vekapot nge veveken meie eie kesen, ta tsereir. Ma ka enamon o, ka tietie va ta vekapot nge veveken meie eie kesen, ta kap oit nia tuir ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sien va e Satan ta kareir rivie e Satan, eie a potakie eie kesen nge veveken, vasa ta ba oit nia tuir ngeisngeis ven ken mangmagoso nguts? ");
INSERT INTO tbf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma sien va o kareir rivie bu tsaka moromoruo ngan mi ngesengesien e Belsebul, se ese ken ngeisngeis, bu natunga gi ta oit nia kareir rivie ngan bu tsaka moromoruo? Io, gi ta so vara tuktuk ngan va enga nga kap duis. ");
INSERT INTO tbf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eiekesen sien va o ta kareir rivie bu tsaka moromoruo ngan mi ngesengesien mi Morumoruan e Raban, ine a vasangan va nga te mon i pakien ken vinuor e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma buer, vasa ka mei ta oit nia rubukien ven si ken vonuo ka ka per, nge sor vingan ken sar kepineits? Eie ta ngas muna vis vuturungie ian mi ka per, samo ta mang ba oit nia pure ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Eie ese ta kap tsok seou, eie a matakorot meie iou, ma eie ese ta kap kakakir, eie a kerekereir. ");
INSERT INTO tbf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Io, o oeng senga, bu tsaka sinavei ma bu tsaka nama mi kulou gi ta oeng balapoik veie ngan e Raban, e Raban ta vodon rivie, eiekesen eie ese ta oeng balapoik ngan mi Moromoruo Tamat, e Raban ta kap oit nia vodon rivie. ");
INSERT INTO tbf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Eie ese ta oeng balapoik ngan e Natuon mi Ka, e Raban ta vodon rivie. Eiekesen eie ese ta oeng balapoik ngan mi Moromoruo Tamat, e Raban ta kap oit nia vodon rivie ine sibu ra ma buer ian sibu ra va ta nemei. ");
INSERT INTO tbf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mi banga ei ta vua ngan bu banga vuovuo, ma mi tsaka ei ta vua ngan bu tsaka vuovuo. Mi ei a kilakilal ngan mi vuovuan. ");
INSERT INTO tbf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Enga bu tsotsoi tsak! Enga mi kulou tsak! Vasa nga ta oit nia vokokotie ven ka banga nama? Simi vunan mi ngutsuon mi mei a vokokotie misa ta vous i aron. ");
INSERT INTO tbf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mi banga ka a ko vorotsoruo bu banga kepineits ta noutngan i aron, ma mi tsaka ka a ko vorotsoruo bu tsaka kepineits ta noutngan i aron. ");
INSERT INTO tbf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eiekesen o oeng senga, simi rangi vinuor, nga ta ngas so vakokoit vasangan mi vunan bu nama sasavoir kokouk nga ta nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Io, ngan kenga sar nama, e Raban ta so tienenge nga sien va nga duis, ma eie ta so votorosie nga sien va nga kap duis.” ");
INSERT INTO tbf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Samo ba mei mene sibu Parisaio ma bu vavvasengei sibu vinuor se Moses gi nga oeng sien, “Vavvasengei, gei lalaro pare va e ta vasangan ka totourlekier ni vovokudier.” ");
INSERT INTO tbf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","E Iesu a nga kuil nama, “Mi kuoluon ine bu ra ese mi sinavigie ta tsokor meie mi sinavei tetteririv gi virei ngan ka totourlekier ni vovokudier! A kap ka totourlekier mene gi ta pare, eiekesen man totourlekier e Iona mi propet mo. ");
INSERT INTO tbf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E Iona a nga mon i aron mi ie leong ba rosisiat tour ma ba rokati tour. Ta malan mo e Natuon mi Ka ta mon i mendien mi kaber ba rosisiat tour ma ba rokati tour. ");
INSERT INTO tbf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Simi rangi vinuor, mi kulou i Nineve gi ta so tuir veie mi kuoluon ine bu ra, ma gi ta so vuortie gie, simi vunan gi nga vodon vuris si ken vinavatei e Iona, ma ine, mi mei ese ta tsiroup rio e Iona a te beit. ");
INSERT INTO tbf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Simi rangi vinuor, mi kovakova vevien leong i Siba ta so tamtuir veie mi kuoluon ine bu ra, ma ta so vuortie gie, simi vunan a nga kovuni i tangatson mi kaber nia me rongomie ken sar banga vienviendon e Solomon, ma ine, mi mei ese ta tsiroup rio e Solomon a te beit. ");
INSERT INTO tbf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sien va ka tsaka moromoruo ta rovotsour vekenan ka mei, ta veisngie bu korot kap ka da en nia nesie ka korot va ta maes en, eiekesen ta kap vorotan. ");
INSERT INTO tbf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Samo ta pevien, ‘O ta muer surie mi vonuo o ta nga sorvekenan.’ Sien va ta muerengei, ta vorotan va ine mi vonuo kap ka mei a monongie, ma gi te videir vakalaie, ma bu kepineits gi mon duis. ");
INSERT INTO tbf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Samo ta muerengei nge ra kerie mi napaririem potsu luo bu tsaka moromoruo mene gi ta tsokor rio eie, ma gi ta me rubukien nge mon ian en. Ma ken tino ian mi ka ta tsokor vekenan vourvour. Ma ine ta malan mo simi kuoluon ine bu ra bu sinavigie ta tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sien e Iesu ta ngas nga vor ve vakvakokoit simi bineit, e kinan ma bu kasien gi nga me tuir i marar, ma gi nga lalaro vakokoit meie. ");
INSERT INTO tbf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mi mene a nga oeng se Iesu, “E kina ma bu kasi die gi tuir i marar. Gi lalaro vakokoit meie no.” ");
INSERT INTO tbf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Eiekesen e Iesu a nga kuil nama, “Ese e kinoung ma ese bu kasiung?” ");
INSERT INTO tbf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A nga tusuo ken sar madar tovtov ma a nga pevien, “Pare, egie ine arie bu kinoung ma bu kasiung. ");
INSERT INTO tbf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Eie ese ta tsang vemusurie ken lalaron e Tamoung die i kur simi rangit, arie eie e kasiung ma e vevineung ma e kinoung.” ");
INSERT INTO tbf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ian simi ra, e Iesu a nga rovotsour simi vonuo nge ra mogos i gegen mi barateis i Galili. ");
INSERT INTO tbf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mi bineit leong gi nga beit viririsie e Iesu. Samo a nga kesie mi galeu nge mogos i popon. Ma mi bineit gi nga tuir i koen. ");
INSERT INTO tbf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Io, a nga vokokotie segie bu kepineits palan ngan mi nama puppuo. A nga pevien, “Nga rorong! Mi ka tsuotstsuor a nga ra rivie ken sar pi ei. ");
INSERT INTO tbf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sien ta nga rivie bu pi ei, bu pei mene gi nga kor i gegen mi baiveisveis ma bu ma gi nga nemei nge nganie gie. ");
INSERT INTO tbf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bu pi ei mene gi nga kor i popon mi popopeliets ivie mi pier a kap nga leong en. Bu pei gi nga tsutsuleik lalapus simi vunan mi pier a nga lili mo. ");
INSERT INTO tbf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Eiekesen sien mi matanias ta nga par, bu ei tsuotstsuor gi nga bileits nge bukuk simi vunan a kap kavo uvigie. ");
INSERT INTO tbf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bu pi ei mene gi nga kor i kinorotuon bu suo tsotso. Ine bu suo tsotso gi nga to leong ma gi nga pipitsie bu ei tsuotstsuor. ");
INSERT INTO tbf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bu pei mene, gi nga kor simi banga pier. Gi nga to leong nge vua nge vuovuo. Bu mene keskes gi nga vua ngan bu vuovuo a nga oit mi sinangavur kes koboit (100), bu mene a nga oit bu sinangavur napaririem potsu kes ma bu mene a nga oit ba sinangavur tour rio misa gi ta nga tsuorkie. ");
INSERT INTO tbf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eie ese ta suvu taterieng ta rorong.” ");
INSERT INTO tbf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ken sar madar tovtov e Iesu gi nga nemei ma gi nga vosuoreie, “Surie misa e ta vakokoit rakot simi kulou ngan bu nama puppuo?” ");
INSERT INTO tbf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E Iesu a nga kuil nama, “E Raban a te nga terie senga mi sinavei nia telekiran bu kepineits mumuningei surie ken mangmagoso Nguts, eiekesen segie a kap. ");
INSERT INTO tbf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Io, segie ese gi ta tor surie kong sar vinasengei, e Raban ta buer veleongtie kegi sinavei. Ma gi ta vous ngan mi sinavei. Eiekesen segie ese gi ta kap lalaron nia tor surie kong sar vinasengei, misasien kegi puk sinavei ta lili, e Raban ta por tsana segie. ");
INSERT INTO tbf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","O vokokotie segie bu kepineits ngan mi nama puppuo, simi vunan, “Misasien gi ta dedeng, gi ta kap dengarie, misasien gi ta rorong, gi ta kap rongomie o, katsep sien. ");
INSERT INTO tbf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ine mi sinavigie gi vara tuktuk ngan ken nama peteteir e Isaia mi propet ian ta pevien, “‘Nga ta munu rongomie kong sar nama eiekesen nga ta kap katsep, nga ta munu dengarie mi sana o ta tsana eiekesen nga ta kap deng kielala. ");
INSERT INTO tbf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Surie bu arogie ine mi kulou a te teng, ma bu tateringagie a kap oit nia rorong, ma gi te vamoge bu katsomatagie. Sien va a kap nga malan ian, va gi nga dedeng ngan bu katsomatagie, ma gi nga rorong ngan bu tateringagie, ma bu arogie a nga katsep nge vuvuris, ma o nga vatoa gie.’ ");
INSERT INTO tbf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Eiekesen nga ta ngas res simi vunan bu katsomatanga gi dengarie ma bu tateringanga gi rongomie. ");
INSERT INTO tbf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","O oeng tuktuk senga, palan bu propet ma bu ka gi ta duis i matan e Raban, gi nga lalaron beitsak nia dengarie nge rongomie misa nga tate dengarie nge rongomie, eiekesen gi kap nga oit. ");
INSERT INTO tbf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Io, nga rong poro misa man vuevue man nama puppuo mi ka tsuotstsuor. ");
INSERT INTO tbf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sien va ka mei ta rongomie mi nama surie ken mangmagoso Nguts e Raban ma a kap katsep sien, mi Tsaka Ka ta nemei nge tsang rivie misa gi tate nga tsuorkie i aron. Ine arie a malan mi pei ta nga kor simi baiveisveis. ");
INSERT INTO tbf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bu pei gi ta nga kor i popon mi popopeliets, a malan egie ese gi ta suvuon mi nama ngan mi nires sien va gi ta rongomie. ");
INSERT INTO tbf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Eiekesen ine mi nama a kap peuk i mendien ken tino ine mi ka, ma a mon lili mo. Sien va ka putu o, ka vinekikin ta beit sien surie ine mi nama, ine mi ka ta kor lalapus. ");
INSERT INTO tbf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bu pei gi ta nga kor i kinorotuon bu suo tsotso, a malan mi mei ese ta rongomie mi nama, eiekesen man sar aor tsak ine mi tino ma bu lalaron ni suvuram ta pipitsie ine mi nama ma ta tsana va ta kap vua. ");
INSERT INTO tbf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma bu pei gi ta nga kor simi banga pier, a malan mi kulou gi ta rongomie mi nama ma gi ta katsep sien. Gi ta vua nge vuovuo. Bu mei keskes segie gi ta vua nge vuovuo ta oit mi sinangavur kes koboit (100), bu mei mene ta oit bu sinangavur napaririem potsu kes, ma bu mei mene buer ta oit ba sinangavur tour rio misa gi tate nga tsuorkie.” ");
INSERT INTO tbf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","E Iesu a nga vokokotie mi nama puppuo mene malan ne, “Mi sinavien e Raban nia vuor a malan mi sana kepineits ta nga tsorubeit sien mi ka ta nga tsuorkie bu banga pi ei si ken tau. ");
INSERT INTO tbf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sien bu mei kokouk gi tate nga muang, man matakorot a nga nemei nge tsuorkie mi tsaka uotuot i kotubuon bu wit, ma a nga veis sorvekenan ine mi tau. ");
INSERT INTO tbf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sien bu wit gi tate nga to leong nge vua, ine bu tsaka uotuot buer gi te nga to leong. ");
INSERT INTO tbf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ken sar petspets ine mi ka ken tau, gi nga ra vosuoreie ven ne, ‘Ka leong! Vasa, e kap nga tsuorkie bu banga pi ei mo i aron ke tau? Ine bu tsaka uotuot, ivie gi kovuni en?’ ");
INSERT INTO tbf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mi ka ken tau a nga kuil nama, ‘Ka matakorot a tsana ine.’ “Bu petspets gi nga vosuoreie, ‘E lalaron va gei ta rakot nge tet rivie ine bu tsaka uotuot?’ ");
INSERT INTO tbf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“A nga kuil nama, ‘A kap, simi vunan sien va nga ta tet rivie bu tsaka uotuot, nga ta masi tet rivie meie ngan bu wit buer. ");
INSERT INTO tbf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nga ta sunuir va eguor kokouk guor ta to oit simi ra nia kakarie mi tau. Io, sien mi ra nia kakarie mi tau ta beit, o ta oeng simi kulou nia kakarie mi tau va gi ta muna tet rivie bu tsaka uotuot nge pokotsie gie sibu pokpok ma gi ta tunie gie. Samo nga ta ba kakarie bu wit nge terie i aron kong vonuo teteir nginonginou.’” ");
INSERT INTO tbf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","E Iesu a nga vokokotie segie mi nama puppuo mene malan ne, “Mi sinavien e Raban nia vuor a malan mi sana kepineits ta nga tsorubeit sien mi ka ta nga poro mi pi mastat nge ra tsuorkie si ken tau. ");
INSERT INTO tbf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Misasien ine mi pei a lili beitsak sibu pei kokouk, sien va ta to leong, ta rio bu tsientsuor kokouk i aro tau, ma ta tsorubeit mi ei leong ivie bu ma simi mariu gi ta me tou sibu rakarakan.” ");
INSERT INTO tbf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","E Iesu a nga vokokotie segie mi nama puppuo mene buer. “Mi sinavien e Raban nia vuor a malan mi sana kepineits ta nga tsorubeit sien mi vevien ta nga poro mi puk iis nge leik meie ngan ba puol plaua tuir oit ine mi plaua kokouk a nga popoek.” ");
INSERT INTO tbf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","E Iesu a nga vokokotie ine bu kepineits kokouk simi bineit ngan mo bu nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A nga vakokoit malan ne nia vara tuktuk ngan mi sana mi propet ta nga vokokotie, “O ta vakokoit ngan mi nama puppuo sien va o ta vakokoit segie. O ta pengan segie bu kepineits ian ta nga mumuningei vakaek si man tsuoktsuok vakaek mi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Samo a nga sorvekenan mi bineit ma a nga rubukien simi vonuo. Ken sar madar tovtov gi nga nemei sien ma gi nga pevien, “Palsie segei man nama puppuo mi tsaka uotuot ta to simi tau.” ");
INSERT INTO tbf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E Iesu a nga kuil nama, “Mi mei ese ta tsuorkie bu banga pi ei arie e Natuon mi Ka. ");
INSERT INTO tbf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mi tau arie mi mangmagoso enaenamon ma bu banga pi ei a tourtelekiran bu mei gi ta mon i aron ken mangmagoso Nguts e Raban. Bu tsaka uotuot arie egie bu natuon mi Tsaka Ka. ");
INSERT INTO tbf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma mi matakorot ese ta tsuorkie gie arie mi kovan bu tsaka moromoruo. Mi ra nia kakarie mi tau arie man votovoto mi mangmagoso enaenamon. Ma mi kulou tsientsang nia por nginonginou i tau arie bu angelo. ");
INSERT INTO tbf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Malan mo gi ta tet rivie nge tunie bu tsaka uotuot simi leing, ta so kokouk si man ra vekvekitip mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","E Natuon mi Ka ta so turan ken sar angelo ma gi ta so vitseir rivie egie ese gi ta vokorongie mi kulou simi sinavei tsokor ma egie ese gi ta tsana bu sinavei tsokor si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gi ta tomeka gie i aron mi leing leong ivie va gi ta so tata nge vengvengio en bu rivogie. ");
INSERT INTO tbf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Samo mi kulou gi ta duis i matan e Raban gi ta so rar malan mi matanias si ken mangmagoso Nguts e Tamagie. Eie ese ta suvu taterieng ta rorong.” ");
INSERT INTO tbf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","E Iesu a nga vor ve vakvakokoit, “Mi sinavien e Raban nia vuor a malan mi sana kepineits ta nga tsorubeit sien mi ka ta nga neis vorotan mi mos ta nga mumuningei i aron mi tau ma a nga puonongie te buer. Io, si ken nires a nga muerengei nge poro ken sar kepineits kokouk ma a nga verikuil ngan nge lakep. Ma a nga ra voir tsana ian mi tau. ");
INSERT INTO tbf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma buer, mi sinavien e Raban nia vuor a malan mi sana kepineits ta nga tsorubeit sien mi ka suvuram ta nga vorotan mi banga re. ");
INSERT INTO tbf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Io, sien tate nga ra neis vorotan ian mi banga re matkalei beitsak, a nga muerengei nge poro ken sar kepineits kokouk ma a nga verikuil ngan nge lakep. Ma a nga ra voir tsana ine mi banga re. ");
INSERT INTO tbf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ma buer, mi sinavien e Raban nia vuor a malan mi sana kepineits ta nga tsorubeit sien mi kulou vongovongon gi ta nga nun ngan kegi sar ben i rou ma bu suasuada ie gi nga me tuveir sien. ");
INSERT INTO tbf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sien mi ben tate nga vous nge ie, mi kulou vongovongon gi te nga te vatare i koen. Samo gi nga mogos nge vierta gie bu ie. Gi nga terie bu ie kalei sibu leke, ma gi nga tomekan bu ie tsak. ");
INSERT INTO tbf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ine arie vasa ta so ven simi ra vekvekitip si man votovoto mi mangmagoso enaenamon. Bu angelo gi ta nemei ma gi ta vierta gie bu tsaka mei sorvekenan bu mei gi ta duis i matan e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma gi ta tomeka gie simi leing leong ivie va gi ta tata nge vengvengio en bu rivogie.” ");
INSERT INTO tbf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","E Iesu a nga vosuoreie gie, “Vasa, nga katsep ine sibu kepineits?” Gi nga kuil nama, “Io, gei katsep.” ");
INSERT INTO tbf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Samo e Iesu a nga oeng segie, “Io, bu vavvasengei kokouk sibu vinuor gi tate tsorubeit mi kulou nia vemusurie ken sar vinuor e Raban, a malan mi mei ese ta sor vorotsoruo bu kepineits vour ma bu kepineits kebeir si ken vonuo teteir kepineits.” ");
INSERT INTO tbf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sien e Iesu tate nga vakokoit vaton ine bu nama puppuo, a nga sorvekenan ian mi enamon. ");
INSERT INTO tbf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma a nga muerengei rakot si ken enamon i Nasaret. Io, e Iesu a nga vakaek nge vavasengei i aron kegi vona rengeir bu Iuda, ma egie ese gi ta nga rongomie gi nga kudier. Gi nga pevien, “Ine mi ka ivie a poro en ine mi banga vienviendon ma mi ngeisngeis nia tsana bu kepineits ni vovokudier? ");
INSERT INTO tbf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Giet si kia va eie mo e natuon mi ka tsangtsang vonuo ma e kinan e Maria, ma bu kasien, e Iakobo, e Iosep, e Simon, ma e Iudas. ");
INSERT INTO tbf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma bu vevinen buer ine gi mon meie giet. Ma ine mi ka ivie a mang poro en ine bu kepineits?” ");
INSERT INTO tbf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma gi nga mekitsan e Iesu. Eiekesen e Iesu a nga oeng segie, “Mi propet a suvu minangarei sibu enamon mene eiekesen si ken enamon ma si ken vonuo, a kap.” ");
INSERT INTO tbf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma a kap nga tsana kavo kepineits ni vovokudier palan en, simi vunan gi kap nga vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ian sibu ra e Erot, mi kovakova ka leong simi enamon i Galili, a nga rongomie mi vinavatei surie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma a nga pevien si ken sar ka ni tsientsang, “A tuktuk te, ine arie e Ioanes mi ka ni sinusuruiv. A te buer to muerengei simi miensei! Arie mi vunan a suvuon mi ngeisngeis nia tsana bu kepineits ni vovokudier.” ");
INSERT INTO tbf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Muomuo, e Erot a nga tuturei nia rakopie e Ioanes nge terie simi vona vinatoreis, simi vunan e Ioanes a nga ko munu oeng matan va a kap duis simi vinuor va a nga reie e Erodias, ken vevien e Pilipo, e kasien. ");
INSERT INTO tbf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","E Erot a nga lalaro kenvamate e Ioanes, eiekesen a nga motovan mi kulou, simi vunan gi nga telekiran va e Ioanes eie mi propet. ");
INSERT INTO tbf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Simi nginou nia barabaramatan ken kienakav e Erot, e natuon vevien e Erodias a nga sieng i matan bu vasier ma a nga varese beitsak e Erot. ");
INSERT INTO tbf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Arie mi vunan e Erot a nga vakavakariem nia terie sien ka sana kepineits ta nga nongie. ");
INSERT INTO tbf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","E kinan ine mi tosuor, a nga oeng ka i aron ngan misa va ta nga nongie. Io, a nga oeng se Erot, “Ine ngas te, e ta terie seou mi kovan e Ioanes mi ka ni sinusuruiv i aron ka leisleis.” ");
INSERT INTO tbf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ine mi kovakova ka leong a nga aor tsak, eiekesen surie ken vakavakariem ta nga tsana i matan ken sar vasier, a nga terie mi nama ngeisngeis nia tsang vaotie ken nono ine mi tosuor. ");
INSERT INTO tbf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Io, a nga turan bu mei nia ra kitip tsana mi kovan e Ioanes i aron mi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Gi nga vuotie mi kovan i aron mi leisleis nge ra vetserie ine simi tosuor, ma a nga sor rakot ngan se kinan. ");
INSERT INTO tbf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ken sar madar tovtov e Ioanes gi nga nemei nge me poro mi piripirien. Ma gi nga ra puonongie. Samo gi nga rakot nge ra pengan se Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sien e Iesu ta nga rongomie misa ta nga tsorubeit se Ioanes, a nga sorvekena gie nge kesie mi galeu eie kesen rakot simi korot ta nga menemenen. Sien mi kulou gi ta nga rongovan va e Iesu a nga ka galeu, mi kulou gi nga veis vemusurie kovuni si kegi sar taon ka i sar. ");
INSERT INTO tbf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sien e Iesu tate nga so tsaer, a nga pare mi bineit leong ma a nga tovie gie nge vatoa gie si magi sar mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sien tate nga reivreiv seserigo, ken sar madar tovtov gi nga nemei sien nge vosuoreie, “Ine mi korot a mon peken bu enamon, ma a te vatvatta ngingi. Turan mi bineit muerengei, terengien gi ta veis rakot sibu enamon ma gi ta mang ra vorie magi kavo nginonginou.” ");
INSERT INTO tbf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","E Iesu a nga kuil nama segie, “Gi ta kap veis. Enga ngas te nga ta tabarie gie.” ");
INSERT INTO tbf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gi nga kuil nama, “Giet suvuon mo ba tsoik napaririem ma ba ie luo meses.” ");
INSERT INTO tbf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","A nga pevien, “Nga me terie gie seou.” ");
INSERT INTO tbf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma a nga oeng simi kulou va gi ta nga mogos i keim simi potpotbor. A nga poro ba tsoik napaririem ma ba ie meses ma a nga dedeng kien i kur simi rangit nge vatamase gie. Ma a nga potakie bu tsoik. Samo a nga terie gie sibu madar tovtov nia tabarie mi bineit. ");
INSERT INTO tbf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Egie kokouk gi nga ngou nge ti. Ma bu madar tovtov gi nga vuotie bu leke mi sinangavur kes ma luo ngan bu kepide nginonginou. ");
INSERT INTO tbf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mi aesaes simi kulou gi ta nga ngou a nga oit malan bu sinangavur mi napaririem soloba (5,000). Ma gi kap nga ase mi langei ma bu natu madar. ");
INSERT INTO tbf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Samo e Iesu a nga oeng si ken sar madar tovtov va gi tate nga ka galeu nge muo rakot simi bienangaev ka nikot simi barateis. Ma eie va ta be nga mon nge vavasie mi bineit. ");
INSERT INTO tbf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I murien tate nga ture vavasie gie, a nga veis kien i gegen mi pout eie kesen nia ra no. Sien tate nga reivreiv seserigo, eie kesen mo a te nga mon. ");
INSERT INTO tbf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Eiekesen gi te nga mon i pek sorvekenan i koen. Ma mi galeu a nga vosuvosuvie sibu naov simi vunan gi nga samsuoeie mi mour. ");
INSERT INTO tbf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Simi to vagoso ador tate nga ta, e Iesu a nga veis i popon mi barateis beit segie. ");
INSERT INTO tbf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sien bu madar tovtov gi ta nga pare e Iesu ta nga veis i popon mi barateis, gi nga motou, ma gi nga pevien “Mi tonuo nikot!” Ma gi nga koup ngan mi mientou. ");
INSERT INTO tbf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Eiekesen e Iesu a nga oeng lalapus segie, “Bu aronga ta menemenen! Arie eou mo. Kian va nga ta motou.” ");
INSERT INTO tbf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E Petro a nga pevien, “Mi Nguts! Sien va arie evoi mo, oeng seou va o ta veis rakot sevoi i popon mi barateis.” ");
INSERT INTO tbf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","E Iesu a nga pevien, “Nemei.” Samo e Petro a nga tsour simi galeu nge vakaek nge veis i popon mi barateis rakot se Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Eiekesen sien ta nga pare mi mour, a nga motou ma a nga vakaek nge luluis. Ma a nga koup, “Mi Nguts, kulie iou!” ");
INSERT INTO tbf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Puk lalapus mo e Iesu a nga tsotsokan mi riman nge takivan, ma a nga pevien, “Ke vodovodon tuktuk a lili mo. Surie misa e ta basbaslieng?” ");
INSERT INTO tbf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sien guor ta nga ka simi galeu, mi mour a nga voto. ");
INSERT INTO tbf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Samo egie ian gi ta nga mon i aron mi galeu, gi nga rangarie nge pevien, “A tuktuk rovoriu, evoi e Natuon e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sien gi tate nga tsourarak, gi nga so tsaer i Genesaret. ");
INSERT INTO tbf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma sien mi kulou ian en gi ta nga kielala va e Iesu, gi nga vavasie mi nama rakot sibu enamon ververiris. Mi kulou gi nga kerie kegi sar tamat mienarouk nemei sien. ");
INSERT INTO tbf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma gi nga no masitinoiv va ta nga sunuir ngan bu tamat mienarouk va gi ta nga tobelie mo mi tangatson man tsetstseik, ma egie ese gi ta nga tobelie, gi nga ketseketseng si magi sar mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Samo bu Parisaio mene ma bu vavvasengei sibu vinuor se Moses gi nga kovuni i Ierusalem ma gi nga nemei se Iesu nge vosuoreie. ");
INSERT INTO tbf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Surie misa ke sar madar tovtov gi ta pop vuturungie mi sinavei sibu tubugiet? Gi kap vavano bu rimagie i muan va gi ta ngou!” ");
INSERT INTO tbf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","E Iesu a nga kuil nama, “Ma surie misa nga ta pop vuturungie mi vuna vinuor se Raban nia vara matkalei ngan mi sinavei sibu tubunga? ");
INSERT INTO tbf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Surie e Raban a te nga pevien, ‘Mangaran e tama ma e kina,’ ma, ‘Eie ese ta oeng vatsakatie e taman o, e kinan, gi ta ngas kenvamate.’ ");
INSERT INTO tbf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Eiekesen enga nga ko pevien, ‘Sien va ka mei ta oeng se taman o, e kinan, “Mi sana kepineits o ta nga oit nia kulie ngado ngan, o te nga terie se Raban,” a kalei va ta kap mangaran e taman o, e kinan.’ Io, nga te beir rivie ken vinuor e Raban ngan mi sinavei sibu tubunga. ");
INSERT INTO tbf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enga bu malamala ka duis! A nga duis te ken nama peteteir e Isaia mi propet ta nga vokokotie surie nga: ");
INSERT INTO tbf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Ine mi kulou gi mangara iou ngan bu ngutsugie mo, eiekesen bu arogie a pek sorvekena iou. ");
INSERT INTO tbf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kegi rengeir nemei seou a sasavoir mo, kegi sar vinasengei, egie bu vinuor mo mi kulou gi te vabatie.’” ");
INSERT INTO tbf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Io, i murien e Iesu ta nga kukuo mi bineit nemei sien, a nga pevien, “Nga rorong seou terengien va nga ta mang katsep kalei. ");
INSERT INTO tbf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mi sana ta rubukien i ngutsuon mi mei a kap vara bita ngan, eiekesen mi sana mi mei ta vorotsoruo kovuni i ngutsuon, arie misa a vara bita ngan.” ");
INSERT INTO tbf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Samo bu madar tovtov gi nga nemei sien ma gi nga vereie, “E telekiran buer va bu Parisaio gi aor putu veie no sien gi ta rongomie ine mi nama?” ");
INSERT INTO tbf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","E Iesu a nga kuil nama, “Bu ei kokouk e Tamoung simi rangit ta kap nga tsuorkie, gi ta tet rivie. ");
INSERT INTO tbf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nga vodon tsupuk rivie gie ian bu muomuo. Egie bu muomuo kael. Sien va ka kael ta muongan ka turan kael, eguor kokouk guor ta kor i aron ka mat.” ");
INSERT INTO tbf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Samo e Petro a nga pevien, “Palsie segei ine mi nama puppuo.” ");
INSERT INTO tbf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","E Iesu a nga oeng segie, “Vasa, kenga teletelekirei a ngas poitpoit? ");
INSERT INTO tbf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nga kap ngas katsep? Mi sana kepineits ta rubukien i ngutsuon mi mei a peuk mo simi kititan ma samo a te buer rovotsour. ");
INSERT INTO tbf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Eiekesen bu kepineits ian ta rovotsour kovuni i ngutsuon mi mei a kuvu si ken vienviendon, ma ine arie a vara bita ngan. ");
INSERT INTO tbf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kovuni i aron mi mei, a vorotsoruo bu tsaka vienviendon, mi sinavei nia kenvamate ka mei, mi sinavei nia rei puer, mi sinavei tetteririv, mi sinavei nia puer, mi sinavei nia vokokotie mi nama binit i matan mi vinuor, ma mi sinavei nia oengoeng tsak. ");
INSERT INTO tbf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ine bu kepineits arie gi vara bita ngan mi mei, eiekesen simi ngou ngan bu riem kap vavvaon a kap vara bita ngan.” ");
INSERT INTO tbf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","E Iesu a nga sorvekenan ian mi enamon, ma a nga rakot simi korot i Turos ma i Sidon. ");
INSERT INTO tbf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mi vevine Kanaan kovuni ian sibu enamon vatavatat, a nga nemei se Iesu ma a nga koupkoup, “Mi Nguts, natuon e Davit. Tovie iou! E natung vevien a suvuon mi putu leong beitsak simi vunan mi tsaka moromoruo a tsegerie.” ");
INSERT INTO tbf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","E Iesu a kap nga kulie ken ka nama. Ma ken sar madar tovtov gi nga nemei nge no ngeisngeis sien, “Ture muerngan, simi vunan a vor ve koupkoup vemusurie giet.” ");
INSERT INTO tbf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Samo e Iesu a nga kuil nama, “E Raban a nga tura iou nian mo mi kuoluon i Israel ian gi ta malan bu sipsip gi ta bebeir.” ");
INSERT INTO tbf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Eiekesen ine mi vevien a nga nemei nge sege pukupukukaek i matan, ma a nga pevien, “Mi Nguts, kulie iou!” ");
INSERT INTO tbf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E Iesu a nga kuil nama, “A kap duis nia poro magi tsoik bu natu madar nge tomeke terie sibu kopuen.” ");
INSERT INTO tbf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma mi vevien a nga kuil nama, “Io, mi Nguts. Eiekesen bu kopuen buer gi ko nganie bu mememuru nginonginou ian ta ko kor kuvu simi tsur ngongou sibu tamagie.” ");
INSERT INTO tbf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Samo e Iesu a nga pevien, “Vevien, ke vodovodon tuktuk a leong beitsak! Mi sana e ta lalaron, ta tsorubeit malan.” Ma ian ngas te simi poko keipkepide ra, e natuon vevien a nga ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","E Iesu a nga sorvekenan ian mi korot ma a nga veis i gegen mi barateis i Galili. Samo a nga veis kien i gegen mi pout nge ra mogos. ");
INSERT INTO tbf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mi bineit leong gi nga nemei sien, meie bu muru, bu kael, egie bu karatogie gi ta nga tsak, bu ngong ma bu suasua tamat mienarouk mene buer. Ma gi nga vuturungie gie i babaren ba kamen e Iesu. Ma a nga vatoa gie kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mi bineit gi nga kudier tsak sien gi ta nga pare bu ngong gi nga vakokoit, bu mei ta nga tsokor bu karatogie gi nga tsorubeit kalei, bu muru gi nga veis ma bu kael gi nga dedeng. Ma gi nga puongan magi Raban bu Israel. ");
INSERT INTO tbf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ma e Iesu a nga kukuo ken sar madar tovtov nemei seie ma a nga pevien, “O tovie gie beitsak ine mi bineit. Gi te mon meie iou ba ra tour ma gi kap suvuon te ka kepineits nia ngou. O kap lalaro ture muer nge gie meie ngan mi vientor. Kavo mei mene segie ta masi so girigirir bu katsomatagie i sar.” ");
INSERT INTO tbf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ken sar madar tovtov gi nga kuil nama, “Ivie a oit va giet ta por tsoik palan en ine simi korot beir nia tabarie mi sua bineit leong malan ne?” ");
INSERT INTO tbf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma e Iesu a nga virei, “A voveis bu tsoik nga suvuon?” Gi nga kuil nama, “Mi napaririem potsu luo, ma ba natu ie meses.” ");
INSERT INTO tbf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Io, a nga oeng simi bineit va gi ta nga mogos i keim simi kaber. ");
INSERT INTO tbf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Samo e Iesu a nga poro bu tsoik mi napaririem pouts luo ma ba ie meses, ma sien tate nga vuot kalei ngan se Raban, a nga potakie gie nge terie si ken sar madar tovtov. Ma gi nga vakaek nge tabarie ngan mi bineit. ");
INSERT INTO tbf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Egie kokouk gi nga ngou nge ti. Ma bu madar tovtov gi nga tsuokopie bu kepide nginonginou nge vovosuo mi napaririem potsu luo bu leke leong. ");
INSERT INTO tbf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mi aesaes simi kulou gi ta nga ngou a nga oit ba sinangavur voveit soloba (4,000), ma gi kap nga ase mi langei ma bu natu madar. ");
INSERT INTO tbf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","I murien e Iesu tate nga ture vavasie mi bineit a nga ka simi galeu ma a nga tsorurak rakot sibu enamon vatavatat i Magadan. ");
INSERT INTO tbf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bu Parisaio ma bu Sadukaio gi nga nemei se Iesu ma gi nga konon ngan mi vinirei. Gi nga vosuoreie va ta nga tsang vasangan segie ka totourlekier ni vovokudier kovuni simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","E Iesu a nga kuil nama, “Sien va tate reivreiv, nga ko pevien, ‘Mi banga ra ta vo beit simi vunan mi rararangien mi matanias a mereik!’ ");
INSERT INTO tbf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma tsourvovo nga ko pevien, ‘Nevere ta uos ma ta mour, simi vunan mi matanias a rar mereik ma a bungou.’ Nga telekiran vasa nga ta palsie venengan mi baidendeng surie mi matanias, eiekesen nga kap oit nia palsie man sar totourlekier ine bu ra. ");
INSERT INTO tbf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mi kuoluon ine bu ra ese mi sinavigie ta tsokor meie mi sinavei tetteririv, gi nesie ka totourlekier ni vovokudier. Eiekesen a kap ka totourlekier mene gi ta pare, eiekesen man totourlekier e Iona.” Samo e Iesu a nga veis sorvekena gie. ");
INSERT INTO tbf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sien gi tate nga tsourarak simi barateis i Galili, bu madar tovtov gi nangba nga so vodonomie va gi kap nga poro ka tsoik. ");
INSERT INTO tbf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","E Iesu a nga pevien segie, “Nga nenei kalei. Nga ta ngas naneie nga simi iis sibu Parisaio ma bu Sadukaio.” ");
INSERT INTO tbf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gi nga vevuor surie ine mi nama i kotubugie ma gi nga pevien, “A vakokoit ven ne simi vunan giet kap poro kavo tsoik.” ");
INSERT INTO tbf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","E Iesu a te nga telekiran mi sana gi nga vevuran ma a nga virei, “Kenga sar vodovodon tuktuk a lili ngas te. Mi sana mi vunan nga ta vevuor surie va nga kap suvu tsoik? ");
INSERT INTO tbf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vasa, nga kap ngas katsep? Nga te vodon punan o ta nga tabarie bu sinangavur mi napaririem soloba (5,000) mi kulou ngan ba tsoik mi napaririem? Ma a nga voveis bu leke nga nga vovosuo nge kapekapien? ");
INSERT INTO tbf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O, nga te vodon punan buer o ta nga tabarie ba sinangavur voveit soloba (4,000) ngan bu tsoik mi napaririem potsu luo, ma a nga voveis bu leke nga nga vovosuo nge kapekapien? ");
INSERT INTO tbf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Surie misa nga ta kap katsep va o kap vakokoit senga surie mi tsoik? Eiekesen nga ta ngas naneie nga simi iis sibu Parisaio ma bu Sadukaio.” ");
INSERT INTO tbf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I murien ine, bu madar tovtov gi nangba nga katsep va e Iesu a kap nga oeng segie va gi ta nga naneie gie simi iis nia tsang tsoik, eiekesen surie bu vinasengei sibu Parisaio ma bu Sadukaio. ");
INSERT INTO tbf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sien e Iesu tate nga beit simi korot leong i Kaesarea Pilippoi, a nga vosuoreie ken sar madar tovtov, “Mi kulou gi ko pevien va e Natuon mi Ka eie ese?” ");
INSERT INTO tbf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gi nga kuil nama, “Bu mei mene gi pevien va eie e Ioanes mi ka ni sinusuruiv, a, bu mei mene gi pevien va eie e Eliia, ma bu mei mene buer gi pevien va eie e Ieremia o, ka meinmenien bu propet.” ");
INSERT INTO tbf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","E Iesu a nga vosuoreie gie, “Ma enga vasa? Nga pevien va eou ese?” ");
INSERT INTO tbf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","E Simon Petro a nga kuil nama, “Evoi mi Messia e Natuon e Raban ta tino.” ");
INSERT INTO tbf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Io, e Iesu a nga kuil nama, “Simon, natuon e Iona. E ta res, simi vunan kap ka mei a nga pengan sevoi ine mi nama, eiekesen e Tamoung die i kur simi rangit a nga pengan sevoi. ");
INSERT INTO tbf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma buer o oeng sevoi va evoi e Petro. Ma i popon ine mi vunavout, o ta tsuok voturie kong kulou ni vodovodon tuktuk malan mi ka tsangtsang vonuo ta voturie mi vonuo i popon mi vunavout. Ma mi ngesengesien mi miensei ta kap oit nia tseiptseiprio gie. ");
INSERT INTO tbf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","O ta terie sevoi bu tsitstsi nian mi mangmagoso Nguts se Raban. Bu sana kepineits e ta rorotsie ine i keim simi kaber gi ta rorotsie i kur simi rangit. Ma bu sana kepineits e ta ruobatie i popon mi kaber gi ta ruobatie buer i kur simi rangit.” ");
INSERT INTO tbf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","I murien ine, a nga vangenge gie ken sar madar tovtov va gi ta kap nga pengan si ka mei mene va eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Vakaek ian simi ra, e Iesu a nga vakaek nge palsie si ken sar madar tovtov va eie ta ngas nga rakot i Ierusalem ma ta suvu vinekikin palan kuvu i riman bu muomuo sibu Iuda, bu prist leong ma bu vavvasengei simi vinuor. Ma gi ta kenvamate, ma simi ra ta tourngan ta to muerengei. ");
INSERT INTO tbf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","E Petro a nga kir terie e Iesu i gege ma a nga vakaek nge patsarie. Ma a nga pevien, “A kap, mi Nguts! Ine mi kepineits ta kap tsorubeit sevoi!” ");
INSERT INTO tbf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","E Iesu a nga vuris ma a nga oeng se Petro, “Satan! tsupek vekena iou. Evoi mi kepineits nia tsuotsuobakei seou. Bu vienviendon e ta suvuon a kap kovuni se Raban, eiekesen kovuni simi ka mo.” ");
INSERT INTO tbf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Samo e Iesu a nga pevien si ken sar madar tovtov, “Sien va ka mei ta lalaro vemusurie iou, eie ta ngas vodon rivie ken sar lalaron surie eie kesen ma ta ngas tsuok sorokie man koitskoits nge vemusurie iou. ");
INSERT INTO tbf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Eie ese ta ruit ngan ken tino, ta rivie ken tino. Eiekesen eie ese ta kap ruit ngan ken tino surie iou, ta so suvuon mi tino. ");
INSERT INTO tbf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mi sana man kienelei, sien va ka mei a suvuon mi kaber kokouk eiekesen eie ta rivie ken tino? O, mi sana kepineits mi ka ta oit nia verikuil meie ngan ken tino? ");
INSERT INTO tbf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","E Natuon mi Ka ta muerengei meie ken sar angelo si man matvinavaso e Taman, ma ian simi ra ta vorie mi kulou kokouk vaotie mi sana sinavei gi tate nga tsana. ");
INSERT INTO tbf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","O oeng tuktuk senga. Kavo mene senga gi ta tuir ine, gi ta kap so maet i muan mi ra va gi ta pare e Natuon mi Ka va ta muerengei nia vuor malan mi kovakova ka leong.” ");
INSERT INTO tbf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","I murien bu ra mi napaririem potsu kes, e Iesu a nga kerie e Petro meie ba baser kasien e Iakobo ma e Ioanes, ma a nga kir kien nge gituo i popon mi pout leong ivie egie mo gi ta nga mon kesegie en. ");
INSERT INTO tbf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ian en, a nga tsorubeit kekineits si kegituo baidendeng, ma mi matan a nga rar malan mi matanias ma man sar tsetstseik a nga tsorubeit puneits malan mi rararangien mi matanias. ");
INSERT INTO tbf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Samo e Moses ma e Eliia guor nga beit i matagituo ma guor nga vakokoit meie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","E Petro a nga oeng se Iesu, “Mi Nguts, a kalei sien giet ta mon ine, sien va e ta lalaron, o ta tsana kaba papael tour, ke ka mene, a, ken ka mene e Moses, ma ken ka mene e Eliia.” ");
INSERT INTO tbf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sien ta ngas nga vor ve vakvakokoit, mi balbal ta nga rar beitsak a nga kuva gie ma mi ien kovuni simi balbal a nga pevien ne, “Ine arie e Natung, ese o ta tovie ma o resmatan beitsak. Nga rorong sien!” ");
INSERT INTO tbf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sien ba madar tovtov gituo ta nga rongomie ine, gituo nga motou beitsak ma gituo nga kor mutur matan i keim simi kaber. ");
INSERT INTO tbf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Eiekesen e Iesu a nga nemei ma a nga soburo gituo nge pevien, “Ngatuo tamtuir. Ngatuo ta kap motou.” ");
INSERT INTO tbf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sien gituo ta nga dedeng kien, gituo kap nga pare ka mei mene eiekesen e Iesu kesen mo te. ");
INSERT INTO tbf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sien gi ta nga vor ve peukpeuk kovuni simi pout e Iesu a nga vengeng vangvangasie gituo ven ne, “Kian va ngatuo ta pengan si ka mei mene misa ngatuo tate pare, oit simi ra va e Natuon mi Ka ta to muerengei simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ba madar tovtov gituo nga vosuoreie, “Surie misa bu vavvasengei sibu vinuor gi ta pevien va e Eliia ta ngas muna beit?” ");
INSERT INTO tbf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","E Iesu a nga kuil nama, “A tuktuk, e Eliia ta ngas muna beit nge vuduis muerngan bu kepineits kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eiekesen o oeng sengatuo, e Eliia a te nga beit ma gi kap nga deng kielala. Gi nga tsana bu suada kepineits kokouk gi ta nga lalaro tsana sien. Io, simi rosar kes mo, e Natuon mi Ka ta so suvu vinekikin i naparimagie.” ");
INSERT INTO tbf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Samo gituo nangba nga katsep va e Iesu a nga vakokoit surie mo e Ioanes mi ka ni sinusuruiv. ");
INSERT INTO tbf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sien gi tate nga muerengei vorotan mi bineit, mi ka a nga nemei se Iesu ma a nga sege pukupukukaek i matan. ");
INSERT INTO tbf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ma a nga pevien, “Mi Nguts, Tovie e natung tamat. A ko gong ma a suvuon mi vinekikin leong. A ko munu kor i popon mi leing ma i aron mi da. ");
INSERT INTO tbf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","O kir nemei ngan si ke sar madar tovtov, eiekesen gi kap oit nia vatoa.” ");
INSERT INTO tbf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","E Iesu a nga kuil nama, “Enga mi kuoluon ine bu ra, kap kenga ka vodovodon tuktuk ma mi sinavinga a tsokor. Ese a ba nga pare o ta nga mon meie nga? Ma ese a ba nga pare o ta nga sorokie kenga sar putu? Nga kir nemei ngan mi madar seou.” ");
INSERT INTO tbf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","E Iesu a nga patsarie mi tsaka moromoruo ma a nga tsourvekenan mi madar. Ma ian ngas te, a nga ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Samo bu madar tovtov gi nga nemei se Iesu ma gi nga virei menentan, “Surie misa gei ta kap oit nia kareir rivie ine mi tsaka moromoruo?” ");
INSERT INTO tbf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E Iesu a nga kuil nama, “Simi vunan kenga vodovodon tuktuk a lili beitsak. O oeng tuktuk senga, sien va kenga vodovodon tuktuk va a lili malan mo mi pi mastat, nga oit nia oeng ine simi pout, ‘Tamtuir en ne nge rakot nikot,’ ma ta tamtuir nge rakot. Ta kap ka kepineits ta mavev senga. ");
INSERT INTO tbf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Eiekesen ine mi suada tsaka moromoruo nga oit nia kareir rivie ngan mo mi nono ma mi vorvor.” ");
INSERT INTO tbf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sien bu madar tovtov kokouk gi tate nga me beit kouk i Galili, e Iesu a nga oeng segie, “E Natuon mi Ka gi ta so roev terie i napariman mi kulou. ");
INSERT INTO tbf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Gi ta so kenvamate, ma simi ra ta tourngan ta to muerengei simi miensei.” Ma bu madar tovtov gi nga vous ngan mi aor tsak. ");
INSERT INTO tbf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","I murien e Iesu ma ken sar madar tovtov gi tate nga beit i Kapernaum, bu ka porpor takis nian mi Vona rengeir leong gi nga nemei se Petro ma gi nga vosuoreie, “Manga vavvasengei a ko vorie buer mi takis rakot simi Vona rengeir leong?” ");
INSERT INTO tbf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","E Petro a nga kuil nama, “Io, a ko vovoir.” Sien e Petro tate nga me rubukien i aron mi vonuo, e Iesu a nga muna vakokoit nge virei, “Vasa ke vienviendon, Simon? Ese a ko voir takis rakot sibu muomuo leong simi mangmagoso enaenamon? Bu natugie o, bu mei mene?” ");
INSERT INTO tbf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","E Petro a nga kuil nama, “Bu mei mene.” E Iesu a nga oeng sien, “Io, a mat malan va bu nout gi ta kap vovoir. ");
INSERT INTO tbf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Eiekesen, giet ta masi vamangarie gie. Peuk i koen nge tomekan ke suoauil. Poro mi ie vourvour va e ta aulie nge por vapanganga mi ngutsuon ma e ta so vorotan kaba silva lakep. Poro nge ra terie gie sibu ka porpor takis nian kenata takis.” ");
INSERT INTO tbf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ian simi keipkepide ra, bu madar tovtov gi nga nemei se Iesu nge vereie, “Ese a tsiroup i aron ken mangmagoso Nguts e Raban?” ");
INSERT INTO tbf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","E Iesu a nga kukuo mi natu madar ma a nga voturie i kotubugie. ");
INSERT INTO tbf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma a nga pevien, “O oeng tuktuk senga, sien va nga ta kap vurise aor nge tsorubeit malan bu natu madar, nga ta kap oit nia rubukien si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Io, eie ese ta vilikitie eie kesen malan ine mi natu madar, eie a leong beitsak i aron ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ma eie ese ta suguo ka natu madar malan ne simi asoung, a suguo iou. ");
INSERT INTO tbf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Eiekesen sien va ka mei ta vokorongie ka mei segie ine bu sinavoir gi ta vodovodon tuktuk seou va ta tsana mi sinavei tsokor, ta kalei beitsak va gi ta pala ka dodou leong i konokonon nge ra votsorovie simi raman megeot. ");
INSERT INTO tbf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Mi tsienakor ta leong simi mangmagoso enaenamon surie bu kepineits gi ta vokorongie mi kulou va gi ta tsana mi sinavei tsokor! Bu suada kepineits ine ta ngas tsorubeit, eiekesen mi tsienakor ta leong simi ka ta tsang vabatie ine bu kepineits! ");
INSERT INTO tbf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sien va mi rima o, mi kame ta vokorongie no va e ta tsana mi sinavei tsokor, tav rivie nge tomekan. A kalei beitsak sien va e ta rubukien simi tino rovoriu meie ngan mo ka riem o, ka kaek kes, sien a kap kalei va e ta suvuon ba rima o, ba kame luo ma gi ta tomeka no simi leing ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma sien va mi katsomata ta vokorongie no va e ta tsana mi sinavei tsokor, gaol rivie nge tomekan. A kalei beitsak va e ta rubukien simi tino rovoriu meie ngan mo mi katsomata kes, sien a kap kalei va e ta suvuon ba katsomata luo ma gi ta tomeka no simi leing leong ian ta kap ko mesei.” ");
INSERT INTO tbf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","E Iesu a te buer nga vakokoit, “Nenei kalei, kian va nga ta matagout ngan ka mei segie ine bu mei kap asna. O oeng senga, magi sar angelo die i kur, gi ko munu pare mi matan e Tamoung die i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","E Natuon mi Ka a nga me vatoa mi kulou gi ta nga bebeir. ");
INSERT INTO tbf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sien va ka ka a suvuon bu sipsip mi sinangavur kes koboit (100), ma ka mei segie a veis bebeir, vasa, eie ta kap be voturie bu sinangavur napaririem potsu voveit ma mi napaririem potsu voveit (99) bu sipsip simi kuitskuits nge ra nesie ian mi mene ta nga veis bebeir? ");
INSERT INTO tbf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","O oeng tuktuk senga, sien va ta neis vorotan, ta resmatan beitsak ine mi sipsip rio bu sinangavur napaririem potsu voveit ma mi napaririem potsu voveit (99) bu sipsip gi ta kap nga veis bebeir. ");
INSERT INTO tbf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Malan mo, e Tamanga die i kur simi rangit a kap lalaron va ka mei ine sibu mei kap asna va ta veis bebeir. ");
INSERT INTO tbf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Sien va e kasi ta tsana mi sinavei tsokor veie no, rakot nge vasangan sien ken bienebeir. Tsana i kotubungado mo. Sien va ta rorong sevoi, e te buer kir muerngan e kasi. ");
INSERT INTO tbf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Eiekesen sien va ta kap rorong sevoi, kerie ka ka kes o, luo meie no, terengien bu nama kokouk e ta vokokotie sien, ine ba ka luo o, a tour gituo ta mang vakokoit katsep ngan va a tuktuk. ");
INSERT INTO tbf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sien va ta mereis nia rorong segituo ine ba ka, pengan simi kulou kokouk ni vodovodon tuktuk. Sien va ta kap rorong buer, tsana sien malan nga ta ko tsana sibu Kibang o, sibu ka porpor takis. ");
INSERT INTO tbf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“O oeng tuktuk senga, mi sana nga ta rorotsie ine simi kaber, e Raban ta rorotsie buer die i kur simi rangit, ma mi sana nga ta ruobatie ine simi kaber, e Raban ta ruobatie buer die i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“O ta buer pengan senga, sien va kaba mei luo senga guor aor kes ngan ka kepineits, nga ta no surie ine simi kaber. E Tamoung die i kur simi rangit ta tsang vaotie senga, simi vunan, ivie a luo o, a tour, gituo oir kouk en simi asoung, ian en, o mon i kotubugituo.” ");
INSERT INTO tbf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Samo e Petro a nga nemei se Iesu ma a nga vosuoreie, “Mi Nguts! Ta voveis bu keipkepide ra o ta ngas vodon rivie bu sinavei tsak e kasiung ta munu tsana seou? Ta oit mi napaririem potsu luo bu keipkepide ra?” ");
INSERT INTO tbf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","E Iesu a nga kuil nama, “O oeng sevoi, a kap va bu keipkepide ra mi napaririem potsu luo mo, eiekesen bu pokpok keipkepide ra simi napaririem potsu luo va ta ra toun beit bu sinangavur mi napaririem potsu luo (70 x 7). ");
INSERT INTO tbf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Mi sinavien e Raban ta vuor a malan mi muomuo leong ta nga visi vodusie mi sinasoren ken sar lakep meie ken sar petspets, ");
INSERT INTO tbf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sien ta nga vakake ken tsientsang nia vuduis, gi nga kir nemei ngan mi mei ese ta nga poro sien bu lut lakep talent bu sinangavur sinangavur soloba (10,000). ");
INSERT INTO tbf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ine mi petspets a kap nga oit nia kulie ine bu lakep, io, ine mi muomuo leong a nga tuturei va ine mi petspets meie ken vevien ma bu natuguor ma bu kepineits kokouk ta nga suvuon va gi ta nga verikulie nge lakep ma gi ta nga poro ine mi lakep nge kulie ngan bu lakep ta nga poro. ");
INSERT INTO tbf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ine mi petspets a nga sege pukupukukaek i matan ine mi muomuo leong ma a nga no masitinoiv, ‘E ta onvidit nge iou ma o ta kuil muerngan bu lakep kokouk.’ ");
INSERT INTO tbf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Man muomuo leong ine mi petspets a nga tovie nge beir rivie ken ora ma a nga ture vavasie. ");
INSERT INTO tbf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Eiekesen sien ine mi petspets ta nga rovotsour a nga suoeie e turan petspets ese ta nga poro sien bu lakep denari mi sinangavur kes koboit (100). A nga rakopie nge vakaek nge kuts konokonon ma a nga oeng sien, ‘Lalapus, kulie bu lakep e ta nga poro seou!’ ");
INSERT INTO tbf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ine e turan petspets a nga sege pukupukukaek i matan ma a nga no masitinoiv, ‘E ta onvidit nge iou ma o ta kuil muerngan kong ora o ta nga poro.’ ");
INSERT INTO tbf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Eiekesen ine mi petspets a kap nga rorong, a nga poro ine e turan petspets ma a nga vurukude simi vona vinatoreis tuir oit va ta nga kuil vuruvan ken ora. ");
INSERT INTO tbf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sien bu petspets ka ie gi ta nga pare mi sana kepineits ta nga tsorubeit, gi nga aor putu beitsak ma gi nga rakot nge pengan ian si magi muomuo leong bu kepineits kokouk ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ine mi muomuo a nga kuk vurukude ine mi petspets ma a nga oeng sien. ‘Evoi mi tsaka petspets. O nga vodon rivie bu lakep kokouk e ta nga poro, simi vunan e nga no masitinoiv seou. ");
INSERT INTO tbf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A nga oit mo va e ta nga aor molous ngan e tura petspets malan mo eou o ta nga aor molous nge no.’ ");
INSERT INTO tbf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Meie ngan ken pientseir leong ine mi muomuo leong a nga terie ine mi petspets i napariman mi ka nennei simi vona vinatoreis va gi ta nga votorosie oit va ta ngas nga kulie bu lakep kokouk ta nga poro sien. ");
INSERT INTO tbf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ine arie vasa e Tamoung die i kur simi rangit ta so tsang venenga nga keskes, sien va nga ta kap vodon rivie tuktuk sibu aronga bu sinavei tsak bu kasinga gi ta tsana senga.” ");
INSERT INTO tbf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sien e Iesu tate nga vakokoit vaton ine bu nama, a nga sorvekenan i Galili ma a nga rakot simi enamon leong i Iudea simi bienangaev ka nikot simi barada i Ioridan. ");
INSERT INTO tbf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mi bineit leong gi nga vemusurie, ma a nga vatoa gie si magi sar mienarouk ian en. ");
INSERT INTO tbf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bu Parisaio mene gi nga nemei se Iesu nia konon. Ma gi nga vosuoreie, “Vasa, a duis simi vinuor va ka mei va ta vekapot sorvekenan ken vevien surie ka vunan vende eie a telekiran?” ");
INSERT INTO tbf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","E Iesu a nga kuil nama, “Vasa, nga kap nga ase mi Pakpak Leong ian ta pevien va simi tsuoktsuok vakaek e Raban a nga tsana mi ka ma mi vevien? ");
INSERT INTO tbf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Arie mi vunan mi ka ta ngas sorvekenan e taman meie e kinan ma ta mon meie ken vevien, ma guor ta tsorubeit kes. ");
INSERT INTO tbf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Io, guor kap ba buer luo eiekesen guor te kes. Io, misana e Raban tate nga votsok kakakuon, kian va mi ka ta potakie.” ");
INSERT INTO tbf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bu Parisaio gi nga vosuoreie, “Surie misa e Moses ta nga terie mi vinuor va mi ka ta teir vunie ngan ken vevien ka pakapaka rorou nia tourtelekiran va keguor mienagos ni rei a te vekapot ma ta ture rivie ken vevien?” ");
INSERT INTO tbf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","E Iesu a nga kuil nama, “E Moses a nga tor va nga ta vekapot sorvekenan kenga sar vevien simi vunan bu aronga a nga bakiet. Eiekesen a kap nga malan ian si man tsuoktsuok vakaek mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma o oeng senga, ese ka ta vekapot sorvekenan ken vevien nge reie ka vevien mene misasien ken vevien a kap tsana ka sinavei nia tetteririv, a te tsana mi sinavei nia rei puer.” ");
INSERT INTO tbf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ken sar madar tovtov gi nga pevien, “Sien va mi mienagos ni rei ta malan ne, a kalei va kian te mi rei.” ");
INSERT INTO tbf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","E Iesu a nga kuil nama, “Ine bu nama vavasengei a kap rakot sibu mei kokouk, eiekesen segie mo ese e Raban ta teir vunie nge gie. ");
INSERT INTO tbf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kavo mei gi kap oit nia rei simi vunan gi nga beit malan te si ken kienakav. Ma kavo mei mene gi kap oit nia rei simi vunan mi kulou gi nga tsana va gi ta nga tsorubeit malan. Ma kavo mei mene gi kap rei surie mi tsientsang simi mangmagoso Nguts e Raban. Eie ese ta oit nia suvuon ine mi nama vavasengei, ta vemusurie.” ");
INSERT INTO tbf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mi kulou gi nga kir nemei ngan bu natu madar se Iesu va ta nga teir riem i popogie nia vatamase nge no surie gie. Eiekesen bu madar tovtov gi nga patsarie mi kulou. ");
INSERT INTO tbf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eiekesen e Iesu a nga pevien, “Nga ta ngas sunuir va bu natu madar gi ta nemei seou ma kian va nga ta vangenge gie, simi vunan mi vavatamaes kovuni si ken mangmagoso Nguts e Raban a sogove gie bu suada mei malan ne.” ");
INSERT INTO tbf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E Iesu a nga teir riem i popogie ma a nga veis sorvekena gie. ");
INSERT INTO tbf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mi ka a nga ra nemei se Iesu ma a nga virei, “Vavvasengei! Mi sana banga kepineits o ta ngas tsana nia suvuon mi tino rovoriu?” ");
INSERT INTO tbf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","E Iesu a nga kuil nama, “Surie misa e ta vosuoreie iou ngan va misa a kalei? E Raban kesen mo a kalei. Sien va e ta lalaro suvuon mi tino rovoriu, e ta ngas vemusurie bu vuna vinuor kokouk.” ");
INSERT INTO tbf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A nga virei, “Bu sana vuna vinuor?” E Iesu a nga kuil nama, “Kian va e ta kenvamate ka mei. Kian va e ta tsana mi sinavei nia rei puer. Kian va e ta puer. Kian va e ta vokokotie ka nama binit i matan mi vinuor. ");
INSERT INTO tbf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","E ta ngas mangaran e tama ma e kina. Ma e ta ngas tovie e palapala malan e ta tovie no kese.” ");
INSERT INTO tbf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ine mi ka vour a nga kuil nama, “Ine bu vuna vinuor kokouk o te nga vemusurie. Ma misa buer o ta ngas tsana?” ");
INSERT INTO tbf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","E Iesu a nga kuil nama, “Sien va e ta lalaro tsorubeit duis, veis nge ra verikuil ngan ke sar sinsuv nge lakep ma terie sibu sinaortsak, io, e ta ba so suvuon mi banga mos die i kur simi rangit. I muir, e ta nemei nge vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sien ine mi ka vour ta nga rongomie ine, a nga mesirik ma a nga veis sorvekenan, simi vunan a nga suvuram beitsak. ");
INSERT INTO tbf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Samo e Iesu a nga oeng si ken sar madar tovtov, “O oeng tuktuk senga, a ngeisngeis si ka ka suvuram va ta rubukien si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","O ta buer oeng senga. A ngeisngeis beitsak simi ka suvuram va ta rubukien si ken mangmagoso Nguts e Raban rio mi kamel ta bilok ka i aron mi mat simi pide re.” ");
INSERT INTO tbf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sien bu madar tovtov gi ta nga rongomie ine, gi nga kudier ma gi nga pevien, “Sien va ta malan, ese mo ta ba oit nia suvuon mi vavato?” ");
INSERT INTO tbf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","E Iesu a nga dedeng duis rakot segie ma a nga kuil nama, “Ine a mavev simi kulou eiekesen se Raban bu kepineits kokouk a oit va ta tsana.” ");
INSERT INTO tbf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Samo e Petro a nga pevien, “Pare! Gei nga sorvekenan kegei sar kepineits kokouk nge vemusurie no. Ma mi sana kepineits gei ta so suvuon?” ");
INSERT INTO tbf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E Iesu a nga oeng segie, “O oeng tuktuk senga. Si ka ra mene bu kepineits kokouk gi ta so tsorubeit vour ma e Natuon mi Ka ta so mogos si ken mogomogos ni Nguts meie ngan mi matvinavaso. Ma ian simi ra, enga ese ine nga tate nga vemusurie iou, enga buer nga ta so mogos i popon mi sinangavur kes ma luo bu mogomogos ni nguts nge vuortie ian mi sinangavur kes ma luo bu matabu sibu Israel.” ");
INSERT INTO tbf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma egie ese gi ta nga sorvekenan kegi sar vonuo, o, bu kasigie, o, bu tamagie, o, bu kinagie, o, bu natugie, o, kegi sar tau surie mi asoung, gi ta suvuon mi sinangavur kes koboit (100) i popon kegi sinsuv ian gi ta nga sorvekenan, ma gi ta so suvuon mi tino rovoriu. ");
INSERT INTO tbf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Eiekesen palan bu mei gi ta muomuo ine, gi ta so vevemuir te, ma palan bu mei gi ta vevemuir ine, gi ta so muomuo. ");
INSERT INTO tbf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Io, mi sinavien e Raban nia vuor a malan ne. Mi ka a nga vo veis sivovo nia kerie kavo petspets nia tsatsang suri lakep si ken tau vain. ");
INSERT INTO tbf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A nga sunuir va ta nga vorie gie ngan mi silva lakep kes ian simi ra, ma a nga tura gie nia tsatsang si ken tau vain. ");
INSERT INTO tbf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“E taman mi tau vain a nga rakot simi korot nia verikuil nge kepineits simi 9 kilok sivovo, ma a nga pare mi kulou mene gi ta nga veririu tuvuon mo en ian. Gi kap nga tsana ka tsientsang. ");
INSERT INTO tbf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A nga oeng segie, Enga buer nga rakot nge ra tsatsang si kong tau vain, ma o ta vorie nga ngan man voirvoir mi ra kes. ");
INSERT INTO tbf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Io, gi nga veis rakot simi tau vain. “Samo, sisiat potaram e taman mi tau vain a te buer nga ra kakir ma simi 3 kilok sireivreiv, a te buer nga tsana malan. ");
INSERT INTO tbf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A te nga vatvatta mi 5 kilok sireivreiv, a te buer nga rakot simi korot nia verikuil nge kepineits ma a nga pare bu mei mene te buer gi ta ngas nga vor ve verveririu tuvuon mo en ian. Ma a nga vosuoreie gie, ‘Surie misa nga ta veririu tuvuon ine simi ra pu ma nga kap tsana ka tsientsang?’ ");
INSERT INTO tbf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Gi nga kuil nama, ‘Simi vunan kap ka mei a kerie gei nia tsatsang suri lakep.’ Io, ine e taman mi tau vain a nga oeng segie, ‘Enga buer nga ta rakot nge tsatsang si kong tau vain.’ ");
INSERT INTO tbf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Sien tate nga reivreiv seserigo, e taman mi tau a nga oeng simi ka ta nga muomuo ngan mi tsientsang ven ne, ‘Kuk kakaku gie bu petspets ma vorie gie ngan magi sar voirvoir, vakaek nge gie gi ta beit i muir ma voto ngan egie gi ta muna vo beit nia tsatsang.’ ");
INSERT INTO tbf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Bu petspets gi ta nga tsuok vakaek simi 5 kilok sireivreiv a nga vorie gie ngan mi silva lakep keskes segie kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Io, sien bu petspets ese gi ta nga muna beit nia tsatsang, gi nga nemei nia por voirvoir. Gi si nga vodon va gi ta nga popor palan. Eiekesen egie buer a nga vorie gie ngan mi silva lakep keskes mo segie kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sien gi ta nga poro kegi sar voirvoir, gi nga vakaek nge nama vevengeis meie e taman mi tau vain. ");
INSERT INTO tbf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Gi nga pevien, ‘Ine bu petspets ese e tate kerie gie i muir, gi te tsatsang mi aua kes mo. Eiekesen e te vorie gie malan mo e tate vorie gei ese gei tate tsatsang ngeisngeis simi ra pu i aron mi parpar leong.’ ");
INSERT INTO tbf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“E taman mi tau a nga kuil nama simi mei segie, ‘Palapala. O kap nga bitie no. Vasa, e kap nga tor nia tsana mi tsientsang nia poro mi silva lakep kes mo? ");
INSERT INTO tbf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Poro ke voirvoir nge veis. O lalaro vorie gie ese gi ta ba me tsatsang i muir kokouk malan evoi e ta muna tsatsang. ");
INSERT INTO tbf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Vasa, o kap suvuon mi duis nia tsana misa o lalaro tsana ngan kong sar lakep? Tavakier nieng nga ngungutsuo iou simi vunan eou mi ka tabetabeir?’ ");
INSERT INTO tbf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Io, egie ese gi ta vevemuir te, gi ta so muomuo, ma egie ese gi ta muomuo, gi ta so vevemuir te.” ");
INSERT INTO tbf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sien e Iesu tate nga veis rakot i Ierusalem, a nga kerie mi sinangavur kes ma luo ken sar madar tovtov rakot i gege ma a nga oeng segie, ");
INSERT INTO tbf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Giet tate rakot i Ierusalem, ma e Natuon mi Ka gi ta terie i riman bu prist leong ma bu vavvasengei sibu vinuor se Moses. Ma gi ta so vuor terie simi miensei. ");
INSERT INTO tbf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma gi ta terie i riman bu Kibang ese va gi ta vavangiets ngan nge beilbeiltsie nge vetekiuo simi koitskoits. Eiekesen simi ra ta tourngan ta ba buer to muerengei simi miensei!” ");
INSERT INTO tbf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Samo e kinan ba natuon tamat e Sebedi, e Iakobo ma e Ioanes, a nga ra nemei se Iesu meie ba natuon, ma a nga me sege pukupukukaek i matan nge vereie va ta nga tsang vaotie ken lalaron. ");
INSERT INTO tbf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","E Iesu a nga vosuoreie, “Misa e lalaron?” A nga pevien, “Sunuir ngan va ka mei kes ine siba natung ta so mogos si ke riem suv ma ka mei mene si ke riem kieir sien va e ta so tsorubeit mi kovakova ka leong.” ");
INSERT INTO tbf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","E Iesu a nga kuil nama, “Ngatuo kap telekiran misa ngatuo vovosurei ngan. A oit va ngado ta un ine simi koi ni vinekikin ian o tate rorois nia unumie?” Guor nga kuil nama sien, “Gor oit.” ");
INSERT INTO tbf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","E Iesu a nga oeng seguor, “Ngado oit nia un si kong koi. Eiekesen, o kap suvuon mi duis nia vile ese va ta mogos si kong riem suv, o, si kong riem kieir. Ine ba mogomogos segie ese e Tamoung tate tsang rosie gie ngan.” ");
INSERT INTO tbf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sien mi sinangavur kes bu madar tovtov mene gi ta nga rongomie ine, gi nga aor putu veie ine ba baser kasien. ");
INSERT INTO tbf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Io, e Iesu a nga kuk kakaku gie nge pevien, “Nga telekiran va bu muomuo ni vuor sibu Kibang, gi suvu ngeisngeis nia vuortie mi kulou gi ta mon si kegi nennei. Ma magi sar muomuo gi ko ngeisngeis va mi kulou gi ta vemusurie kegi sar vinuor. ");
INSERT INTO tbf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kenga mienagos ta kap malan ine. Eie ese ta lalaron va ta leongleong i kotubunga, eie ta ngas muna tsorubeit kenga petspets. ");
INSERT INTO tbf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma eie ese ta lalaron va ta muomuo eie ta ngas tsorubeit va eie kenga petspets. ");
INSERT INTO tbf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Malan mo e Natuon mi Ka a kap nga nemei va gi ta tsatsang petspets sien, eiekesen a nga nemei nia tsatsang petspets segie mi kulou ma nia terie ken tino nia voir tsana mi kulou palan.” ");
INSERT INTO tbf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sien e Iesu ma ken sar madar tovtov gi tate nga sorvekenan i Ieriko, mi bineit leong gi nga vemusurie gie. ");
INSERT INTO tbf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ba kael guor nga mogos i gegen mi rosar. Sien guor tate nga rongomie va e Iesu a nga me veis rov riu ine simi rosar, guor nga vakaek nge koupkoup, “Mi Nguts, Natuon e Davit, tovie gor!” ");
INSERT INTO tbf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mi bineit gi nga patsarie guor nge oeng seguor va guor ta nga bong, eiekesen guor nga koupkoup leong beitsak, “Mi Nguts, Natuon e Davit, tovie gor!” ");
INSERT INTO tbf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","E Iesu a nga so tuir nge kukuo guor, ma a nga vosuoreie guor, “Misa ngado lalaron va o ta tsana sengado?” ");
INSERT INTO tbf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Guor nga kuil nama, “Mi Nguts, gor lalaron va gor ta dedeng.” ");
INSERT INTO tbf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E Iesu a nga tovie guor ma a nga tobelie bu katsomataguor. Ma ian ngas te bu katsomataguor a nga katsep ma guor nga vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sien gi ta nga beit vatvatta i Ierusalem, gi te nga beit i Betpage i popon mi pout i Oliv. Ian en, e Iesu a nga turan ba madar tovtov luo, ");
INSERT INTO tbf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma a nga oeng seguor ven ne, “Ngado ta rakot simi enamon i muangado, ma ian en, ngado ta so pare mi kina dongki gi pala meie e natuon i babaren. Ngado ta ruobatie guor nge kir nemei ngan. ");
INSERT INTO tbf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sien va ka mei ta pengan ka sana nama sengado, ngado ta oeng sien va mi Nguts a pinat surie, ma ian ngas te ta ruom terie sengado.” ");
INSERT INTO tbf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A nga tsorubeit malan ine nia vara tuktuk ngan mi sana mi propet ta nga vokokotie: ");
INSERT INTO tbf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pengan se natuon vevien i Sion. ‘Pare, ma kovakova ka leong ian a nemei sevoi. A menemenen mi sinavien ma a mogos i popon mi dongki, e natuon mi kina dongki.’” ");
INSERT INTO tbf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ine ba madar tovtov guor nga veis nge tsang malan ngan e Iesu tate nga vokokotie seguor. ");
INSERT INTO tbf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Guor nga kir nemei ngan mi dongki meie e natuon, ma guor nga poro maguor sar tsetstseik nge terie i popon ba dongki ma e Iesu a nga mogos i popon. ");
INSERT INTO tbf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mi bineit leong gi nga poro magi sar tsetstseik nge paparan i sar, ma bu mei mene gi nga tara bu pakapaka bebei nge paparan i sar. ");
INSERT INTO tbf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mi kulou gi ta nga muo ngan e Iesu ma e gie gi ta vemuir gi nga koupkoup, “Osana, rakot se Natuon e Davit! E Raban ta vatamase eie ese ta nemei simi asan mi Nguts! Osana i kur beitsak!” ");
INSERT INTO tbf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sien e Iesu tate nga rubukien i Ierusalem mi kulou kokouk i aron mi taon leong gi nga tsuorovo ma gi nga virei, “Ese ine?” ");
INSERT INTO tbf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mi bineit gi nga kuil nama, “E Iesu, mi propet kovuni i Nasaret i Galili.” ");
INSERT INTO tbf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E Iesu a nga rubukien i mararan mi Vona rengeir leong, ma a nga kareir vorotsoruo egie kokouk ese gi ta nga vevoir ma egie ese gi ta nga terie kegi sar kepineits nia vovoir ian en. A nga vuir matan ngan i keim kegi sar tsur vovvoturu bu ka ververieis nge lakep ma kegi sar tsur bu mei gi ta nga verikuil nge lakep ngan bu buen. ");
INSERT INTO tbf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma a nga oeng segie, “Mi Pakpak Leong a pevien, ‘Kong vonuo gi ta vuotongie va mi vonuo nia rengeir.’ Eiekesen nga me tsana va magi rie kokkoiv bu ka puerpuer!” ");
INSERT INTO tbf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bu kael ma bu muru gi nga nemei sien simi vona rengeir, ma a nga vatoa gie. ");
INSERT INTO tbf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Eiekesen sien bu prist leong ma bu vavvasengei simi vinuor se Moses gi ta nga pare bu banga kepineits ta nga tsana, ma buer bu natu madar gi ta nga koupkoup i mararan mi vona rengeir ven ne, “Osana rakot se Natuon e Davit,” gi nga aor rarap. ");
INSERT INTO tbf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma gi nga vereie e Iesu, “E rongomie mi sana ine bu natu madar gi ta koupkoup pevien?” A nga kuil nama, “Io. Vasa, nga kap ngas ase mi Pakpak Leong ian ta pevien malan ne? “‘Kovuni i ngutsuon bu natu madar ma bu natu madar sosor, e Raban a te nga vasangan segie mi sinavei nia tietienengei.’” ");
INSERT INTO tbf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma e Iesu a nga veis sorvekena gie i Ierusalem nge rakot i Betani ivie a nga ra mutur en ian sikati. ");
INSERT INTO tbf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tsourvovo mokuopkuop sien e Iesu tate buer nga muerengei rakot i Ierusalem, a nga vitor. ");
INSERT INTO tbf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A nga pare mi ei fik i gege sar, ma a nga veis rakot sien, eiekesen a kap nga vorotan kavo vuovuo, eiekesen bu pakpak mo. Samo a nga oeng simi ei, “E ta kap ba buer oit nia vua ngan kavo vuovuo!” Ian ngas te ine mi ei a nga bukuk. ");
INSERT INTO tbf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sien bu madar tovtov gi ta nga pare ine, gi nga kudier, ma gi nga virei, “Vasa a bileits lalapus ven ine mi ei fik?” ");
INSERT INTO tbf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","E Iesu a nga kuil nama, “O oeng tuktuk senga, sien va nga suvu vodovodon tuktuk ma nga kap basbaslieng, nga oit nia tsana misa ta tsorubeit ine simi ei fik, ma buer nga oit nia oeng ine simi pout, ‘Tamtuir nge tsibour i rou,’ ma ta tsorubeit malan. ");
INSERT INTO tbf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sien va nga ta vodovodon tuktuk, nga ta suvuon mi sana nga ta nongie i aron kenga sar nono.” ");
INSERT INTO tbf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E Iesu a nga rubukien i mararan mi Vona rengeir leong. Ma sien ta nga vor ve vavvasengei, bu prist leong ma bu muomuo simi kulou gi nga nemei sien nge vereie, “Ngan mi sana duis e tsana ine bu kepineits? Ma ese a terie sevoi ine mi duis?” ");
INSERT INTO tbf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","E Iesu a nga kuil nama, “Eou buer o ta vereie nga ngan mi virevirei kes. Sien va nga ta kuil vaotie ine kong vinirei, eou buer o ta pengan senga ngan mi sana duis o tsana ine bu kepineits. ");
INSERT INTO tbf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ken sinusuruiv e Ioanes, ivie a nga kovuni en? A kovuni simi rangit, o, a kovuni simi kulou?” Gi nga vevuran i kotubugie ma gi nga pevien, “Sien va giet ta pevien va a kovuni simi rangit, eie ta virei, ‘Ma surie misa nga ta kap nga vodovodon tuktuk sien?’ ");
INSERT INTO tbf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma sien va giet ta pevien va a kovuni simi kulou, giet ta ngas moungmoung simi kulou, simi vunan gi vodovodon tuktuk va e Ioanes eie mi propet.” ");
INSERT INTO tbf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Io, gi nga kuil nama se Iesu, “Gei kap telekiran.” Ma a nga pevien, “Eou buer o ta kap pengan senga ngan mi sana duis o tsana ine bu kepineits. ");
INSERT INTO tbf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Vasa kenga vienviendon? Mi ka a nga suvuon ba natuon luo. A nga rakot simi mei vourvour ma a nga oeng sien, ‘Natung, nevere, rakot nge tsatsang simi tau vain.’ ");
INSERT INTO tbf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“E natuon a nga kuil nama, ‘O ta kap ra tsatsang.’ Eiekesen i muir, a nga vurisan ken vienviendon ma a nga veis nge ra tsatsang. ");
INSERT INTO tbf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Samo e tamaguor a nga rakot simi mei ka ie nge oeng sien malan mo ken nama simi mei vourvour. A nga kuil nama, ‘O ta tsatsang, tama,’ eiekesen i muir, a kap nga ra tsatsang. ");
INSERT INTO tbf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mi sana mei ine siba baser kasien a nga tsang vaotie ken lalaron e tamaguor?” Gi nga kuil nama, “Mi mei vourvour.” E Iesu a nga oeng segie, “O oeng tuktuk senga, mi kulou porpor takis ma bu tetteririv nia por lakep, gi ta muna rubukien si ken mangmagoso Nguts e Raban i muo senga. ");
INSERT INTO tbf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Surie e Ioanes a nga nemei senga nia me vasangan mi saran mi duis, ma nga kap nga vodovodon tuktuk sien, eiekesen mi kulou porpor takis ma bu tetteririv nia por lakep, gi nga vodovodon tuktuk sien. Misasien nga tate nga pare ine, nga kap nga vodon vuris nge vodovodon tuktuk sien.” ");
INSERT INTO tbf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nga rorong ine simi nama puppuo mene. Mi ka a nga mon ese ta nga suvuon ken poko pier, a nga tsuorkie mi tau vain. A nga oir viririsie ine mi tau nge tsopuo mi mat nia pop poltsan bu kievkiev vain ma a nga tsana mi vonuo nennei tau. Samo a nga oeng terie ken tau simi kulou tsuotstsuor va i muir gi ta ba nga pot terie ken ka potpot sibu vuovuo. ");
INSERT INTO tbf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sien mi ra nia kakarie mi tau tate nga beit, a nga turan ken sar petspets rakot simi kulou tsuotstsuor nia ra poro ken potpot sibu vuavua vain. ");
INSERT INTO tbf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Mi kulou tsuotstsuor gi nga rakopie ken sar petspets, mi mene kes gi nga tsatsakie, mi mene gi nga kenvamate, ma mi mene a tourngan gi nga tome nge vout. ");
INSERT INTO tbf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Samo a nga turan bu petspets mene te buer rakot segie, gi nga palan rio ba mei vourvour, ma bu ka tsuotstsuor gi nga tsang malan nge gie mo ba mei vourvour. ");
INSERT INTO tbf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","I muir rovoriu mi ka ken tau a nga turan e natuon tamat rakot segie, ma a nga vodon nge kia, ‘Gi ta mang so mangaran e natung.’ ");
INSERT INTO tbf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Eiekesen, sien bu ka tsuotstsuor gi ta nga pare e natuon, gi nga pevien segie keskes, ‘Arie eie ine ta so suvuon bu sinsuv se taman. Maga, giet ta kenvamate nge poro ken sar sinsuv.’ ");
INSERT INTO tbf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Io, gi nga raok tomeke vorotsoruo i muirmuir simi tau vain ma gi nga kenvamate. ");
INSERT INTO tbf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Io, sien va e taman ine mi tau vain va ta nemei, misa ta me tsana segie ian bu ka tsuotstsuor?” ");
INSERT INTO tbf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Gi nga kuil nama, “Eie ta ngas kenvamate gie ine bu tsaka ka, ma ta terie mi tau vain simi kulou tsuotstsuor mene egie ese gi ta terie ken potpot sibu kievkiev vain simi ra nia poro bu vuovuo.” ");
INSERT INTO tbf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","E Iesu a nga oeng segie, “Vasa, nga kap ko ase bu nama simi Pakpak Leong ian ta pevien malan ne? “‘Mi vunavout ian mi kulou tsangtsang vonuo gi ta nga purusie, a me tsorubeit mi vout mogos; mi Nguts a nga tsang vabatie ine, ma a matmatot si kegiet baidendeng.’ ");
INSERT INTO tbf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Io, o oeng senga, kenga duis nia mon i pakien ken vinuor e Raban, eie ta por tsana senga ma ta terie simi kulou ese gi ta vabatie bu banga vuovuo si kegi tino. ");
INSERT INTO tbf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Egie ese gi ta kor i popon ian mi vunavout gi ta katokatoim vuolili, eiekesen egie ese ian mi vunavout ta kor i popogie, gi ta kaviekaviets.” ");
INSERT INTO tbf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sien bu prist leong ma bu Parisaio gi ta nga rongomie ken nama puppuo e Iesu, gi nga telekiran va a nga vakokoit surie gie. ");
INSERT INTO tbf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Io, gi nga nesie ka rosar nia rakopie, eiekesen gi nga motovan mi bineit, simi vunan mi kulou gi nga telekiran va eie mi propet. ");
INSERT INTO tbf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","E Iesu a te buer nga vakokoit ngan mi nama puppuo sibu mei ven ne. ");
INSERT INTO tbf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Mi sinavien e Raban nia vuor a malan mi kovakova ka leong ese ta nga potsie mi nginou ni verei se natuon. ");
INSERT INTO tbf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A nga turan ken sar petspets nia ra oeng segie ian bu mei tate nga muna nongie gie va gi tate nga beit ian simi nginou, va gi tate nga nemei. Eiekesen gi nga mereis nia nemei. ");
INSERT INTO tbf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Samo a nga turan te buer ken sar petspets mene nge pevien, ‘Nga ra oeng segie ian bu mei o ta nga nongie gie malan ne; O te rorois ngan kong nginou. Kong sar bulumakau tamat ma kong sar banga ginem gi te keda gie, ma bu kepineits kokouk gi te rorois. Nga tate ra nemei ine simi nginou ni verei.’ ");
INSERT INTO tbf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Eiekesen gi kap nga rorong ma gi nga veis muirmuir. Mi mei mene a nga rakot si ken tau, ma mi mei mene a nga rakot si ken vonuo nia verikuil nge kepineits. ");
INSERT INTO tbf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma bu mei mene gi nga rakopie ine bu petspets nge tsatsakie gie nge kenvamate gie. ");
INSERT INTO tbf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ine mi kovakova ka leong a nga petseir beitsak, ma a nga turan ken sar ka ni minakiur nia ra voguersan ian mi kulou kenken nge tunie kegi taon. ");
INSERT INTO tbf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Samo a nga oeng sibu petspets, ‘Mi nginou ni verei a te rorois, eiekesen ian mi kulou o ta nga kukuo gie, gi kap kalei oit nia me ngou. ");
INSERT INTO tbf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nga ta rakot sibu tangatso rosar nge kukuo nemei ngan simi nginou ese mune nga ta vorota gie.’ ");
INSERT INTO tbf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Io, bu petspets gi nga rakot sibu tangatso rosar nge kerie mi kulou kokouk gi ta nga vorota gie, bu mei kalei ma bu mei tsokor, ma ian mi vona verei a nga vous nge vasier. ");
INSERT INTO tbf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Eiekesen, sien mi kovakova ka leong ta nga rubukien nia pare gie bu vasier, a si nga pare mi ka mene a kap nga vavaso ngan man ka tsetstseik nian mi verei. ");
INSERT INTO tbf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma a nga pevien, ‘Palapala, vasa e rubukien ven sien e ta kap tsekie ma ka tsetstseik nian mi verei?’ Eiekesen mi ka a nga bong mogos. ");
INSERT INTO tbf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Samo ine mi kovakova ka leong a nga oeng sibu petspets, ‘Nga visie ba riman ma ba kamen nge tomeke terie simi ngingi e kinagie ivie ta so tata nge vengvengio en bu rivon.’ ");
INSERT INTO tbf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Io, E Raban a kukuo bu mei palan eiekesen ta vile mo ba mei kap vovo.” ");
INSERT INTO tbf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Samo bu Parisaio gi nga sorvekenan, ma gi nga roev nia romuo e Iesu ngan kavo vinirei. ");
INSERT INTO tbf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Io, gi nga turan kegi sar madar tovtov meie mi kulou simi gargar se Erot. Ma gi nga pevien, “Vavvasengei, gei telekiran va evoi mi ka simi tuktuk. Ma e ko vavasengei ngan mi saran e Raban ngan mi tuktuk. E kap ko vemusurie mi tinatakien ka mei mene, simi vunan e kap ko oeng potakie mi ka ta asna ma mi ka ta kap asna. ");
INSERT INTO tbf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Io, be pengan segei, vasa e vodon ven. A duis va giet ta voir takis rakot se Kaesar o, a kap?” ");
INSERT INTO tbf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Eiekesen e Iesu a te nga telekiran ian kegi tsaka roevroev, ma a nga kuil nama, “Enga bu malamala ka duis! Surie misa nga ta lalaro kono iou? ");
INSERT INTO tbf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nga vasangan seou ka silva lakep sibu Roma nga ta ko voir takis ngan.” Gi nga por nemei ngan seie mi mene nge silva lakep. ");
INSERT INTO tbf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma a nga vereie gie, “Mi patsapatsan ma mi asan ese a mon ine simi lakep?” ");
INSERT INTO tbf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Gi nga kuil nama, “E Kaesar.” Ma e Iesu a nga pevien, “Terie rakot se Kaesar ian se Kaesar, ma terie rakot se Raban ian se Raban.” ");
INSERT INTO tbf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sien gi ta nga rongomie ine, gi nga kudier ma gi nga sorvekenan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ian simi ra ngas te bu Sadukaio ese gi ta nga ko pevien va kap ka tino mumuerengei, gi nga nemei se Iesu nge me vosuoreie ngan mi virevirei. ");
INSERT INTO tbf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Gi nga pevien, “Vavvasengei, e Moses a nga pevien, ‘Sien va ka ka ta maet sorvekenan ken vevien ma a kap ka natuon, ka kasien tuir muir ta ngas reie te buer ine mi vevien nge suvu nout ken e kasien.’ ");
INSERT INTO tbf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mi napaririem potsu luo bu baser kasien gi nga mon. Mi muariem a nga rei ma a nga maet. Ma a kap nga suvu nout ine si ken vevien, io, e kasien a te buer nga reie ine mi vevien. ");
INSERT INTO tbf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Simi rosar kes mo a nga malan se kasien ta luo ngan ma ta tour ngan, beit se kasigie mi vemuir vekvekitip ian simi napaririem potsu luo. ");
INSERT INTO tbf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","I muir nangba mi vevien a nga maet. ");
INSERT INTO tbf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Io, simi tino mumuerengei, ese te ken vevien segie ine mi napaririem potsu luo bu baser kasien, simi vunan egie kokouk gi nga reie?” ");
INSERT INTO tbf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","E Iesu a nga kuil nama, “Nga bebeir, simi vunan nga kap telekiran mi nama simi Pakpak Leong o, mi ngesengesien e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Simi tino mumuerengei, mi kulou gi ta kap ba so rei, eiekesen gi ta tsorubeit malan bu angelo die i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Eiekesen surie mi tino mumuerengei, vasa, nga kap ko ase mi nama simi Pakpak Leong misa e Raban ta pengan senga? ");
INSERT INTO tbf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","A nga pevien, ‘Eou man Raban e Abaraam, a, man Raban e Isak, ma man Raban e Iakop.’ Io, eie a kap va magi Raban bu mei maet, eiekesen magi Raban bu mei gi ta tino.” ");
INSERT INTO tbf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sien mi bineit gi ta nga rongomie ine, gi nga kudier tsak si ken vinakokoit. ");
INSERT INTO tbf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sien bu Parisaio gi ta nga rongomie va e Iesu a te nga vabongo gie bu Sadukaio, egie kokouk gi nga nemei. ");
INSERT INTO tbf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma mi meinmenigie, eie mi ka sinavei sibu vinuor se Moses, a nga konon e Iesu ngan mi vinirei. ");
INSERT INTO tbf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Vavvasengei, mi sana vinuor eie a tsiroup sibu Vuna Vinuor kokouk?” ");
INSERT INTO tbf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","E Iesu a nga kuil nama, “‘E ta ngas lalaron beitsak mi Nguts ma Raban ngan mi aro kokouk ma mi morumorua kokouk ma mi vinavinadodo kokouk.’ ");
INSERT INTO tbf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ine arie mi vuna vinuor ian ta tsiroup ma eie mi vunan bu vuna vinuor kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma mi vinuor a luongan a malan ne, ‘E ta ngas tovie e palapala malan e ta tovie no kese.’ ");
INSERT INTO tbf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bu Vinuor se Moses kokouk ma bu vinasengei sibu propet gi vunan ine siba vuna vinuor luo.” ");
INSERT INTO tbf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sien bu Parisaio gi ta nga mon kouk, e Iesu a nga vereie gie, ");
INSERT INTO tbf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nga vodon va mi Messia eie ese? Eie mi tietie se ese?” Ma gi nga kuil nama, “Eie mi tietie se Davit.” ");
INSERT INTO tbf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Samo e Iesu a nga virei, “Ma surie misa mi Moromoruo Tamat ta nga teir vienviendon se Davit va e Davit ta nga vuotongie mi Messia va ‘mi Nguts’? E Davit a nga oeng malan ne, ");
INSERT INTO tbf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Mi Nguts a nga pevien si mong Nguts; “Mogos si kong riem suv oit o ta terie ma sar matakorot i pakien ba naparikame.” ’ ");
INSERT INTO tbf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Sien va e Davit a nga vuotongie va eie man Nguts, vasa te buer va mi Messia eie mi tietie se Davit?” ");
INSERT INTO tbf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A kap ka Parisaio va ta nga oit nia kulie ken vinirei e Iesu. Ma vakaek ian ma i muir kap ka mei a ba nga vanvando vereie ngan ka vinirei te buer. ");
INSERT INTO tbf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Samo e Iesu a nga oeng simi bineit ma si ken sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bu vavasengei simi vinuor se Moses ma bu Parisaio arie egie gi sievei nia vasangan mi vinuor se Moses. ");
INSERT INTO tbf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Io, nga ta ngas vemusurie bu kepineits kokouk gi ta vokokotie senga va nga ta tsana. Eiekesen kian va nga ta vemusurie misa gi ta ko tsana, simi vunan gi kap ko vemusurie misa gi ta ko vavasengei ngan. ");
INSERT INTO tbf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gi ko puputungie nge vosorkie gie mi kulou ngan mi sinor putu, eiekesen egie kesegie gi ta kap sunuir va gi ta terie ka pitsipitsiriem nia kuil ian simi sinor. ");
INSERT INTO tbf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Gi ko tsana bu suasuada kepineits va mi kulou gi ta mang pare gie. Gi ko vavataor tsana bu vinavataor simi Pakpak Leong nge vuotie sibu puk vovvoi a leong rio sibu mei ka ie ma gi ko rorotsie terie i matadigie ma i rimagie. Ma gi ko tsana mi napa lavlav kuar nge ruovan ian ta tsiu peuk i keim. ");
INSERT INTO tbf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma gi ko lalaron beitsak kegi mogomogos bu muomuo sibu nginou ma si kegi sar vona rengeir. ");
INSERT INTO tbf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma gi ko lalaron beitsak va mi kulou sibu korot nia verikuil nge kepineits, gi ta mangara gie. Ma gi ko lalaron buer va gi ta ve vuotongie gie va egie bu ‘Vavvasengei.’ ");
INSERT INTO tbf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Eiekesen kian va nga ta sunuir va gi ta vuotongie nga va enga bu ‘Vavvasengei’, simi vunan enga bu baser kasien ma manga vavvasengei a kes mo. ");
INSERT INTO tbf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma kian va nga ta vuotongie ka mei ine simi kaber va e tamanga, simi vunan e Tamanga a kes mo die i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma kian buer va nga ta sunuir va gi ta vuotongie nga va enga bu ka leong, simi vunan manga ka leong a kes mo, ma eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Eie ese ta muomuo senga, eie ta ngas tsorubeit kenga petspets. ");
INSERT INTO tbf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Io, eie ese ta veleveleongtie eie kesen, e Raban ta so vilikitie, ma eie ese ta vilikitie eie kesen, e Raban ta so veleongtie. ");
INSERT INTO tbf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mi tsienakor leong ta monongie nga bu vavvasengei sibu vinuor ma enga bu Parisaio! Enga bu malamala ka duis! Nga ko tuir kitipan mi kulou va gi ta kap rubukien si ken mangmagoso Nguts e Raban. Ma enga buer nga kap ko rubukien, ma nga kap ko tuir vara gie ese gi ta ko lalaron nia rubukien. ");
INSERT INTO tbf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mi tsienakor leong ta monongie nga bu vavvasengei sibu vinuor se Moses ma bu Parisaio. Enga bu malamala ka duis! Nga ko bit tsana kegi sar vonuo bu vevien naor gi tate nga mamaet labeit ma nga ko vakam ngan mi nono kuar. Io, nga ta suvuon mi vinatoreis leong. ");
INSERT INTO tbf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mi tsienakor leong ta monongie nga bu vavvasengei simi Vinuor ma bu Parisaio! Enga bu malamala ka duis! Nga ko veisngie bu enamon nge tsourrak barateis nia oeng vikisie bu vinavinadodon mi kulou nia vemusurie kenga sinavei nia rengeir. Sien va nga ta vikisie kegi vienviendon kavo mei, nga ko tsana va magi vinekikin i aron mi leing leong ian ta kap ko mesei ta so leong vuluo rio senga. ");
INSERT INTO tbf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mi tsienakor leong ta monongie nga, enga bu muomuo nga kael! Nga ko pevien, ‘Sien va ka mei ta vakavakariem ngan mi vona rengeir, ian a tuvuon, eiekesen sien va ka mei ta vakavakariem ngan bu gold i aron mi vona rengeir, ian a tuktuk ma a ngeisngeis.’ ");
INSERT INTO tbf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Enga bu kael ma nga be! Misa a potokivout senga, mi gold o, mi vona rengeir ian a tsana mi gold va ta tsorubeit tamat? ");
INSERT INTO tbf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma nga ko pevien buer, sien va ka mei ta vakavakariem ngan mi korot nia tu tienebeir, ian a tuvuon, eiekesen sien va ka mei ta vakavakariem ngan mi tienebeir i popon mi korot nia tu tienebeir, ian a tuktuk ma a ngeisngeis? ");
INSERT INTO tbf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Enga bu kael! Misa a potokivout? Mi tienebeir o, mi korot nia tu tienebeir arie eie a tsana mi tienebeir va ta tamat? ");
INSERT INTO tbf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Io, eie ese ta vakavakariem ngan mi korot nia tu tienebeir, a vakavakariem ngan meie ngan bu tienebeir i popon. ");
INSERT INTO tbf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma eie ese ta vakavakariem ngan mi Vona rengeir leong, a vakavakariem ngan meie ngan eie ese ta mon i aron. ");
INSERT INTO tbf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma eie ese ta vakavakariem ngan mi rangit, a vakavakariem ngan ken mogomogos e Raban meie ngan eie ese ta mogos sien. ");
INSERT INTO tbf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mi tsienakor leong ta monongie nga bu vavvasengei sibu vinuor ma enga bu Parisaio! Enga bu malamala ka duis! Nga ko terie se Raban mi korot kes simi karton mi sinangavur kes si kenga sar tsientsuor nia vesena mi nginonginou gi ta vuotongie ngan mi mint, mi dill, ma mi kumin. Eiekesen nga te vodon sasavoir ngan bu vinasengei ian ta leong simi Vinuor, malan mi duis, mi aor molous ma mi vodovodon tuktuk. Ine arie ba kepineits kokouk nga ta ngas tsang vaotie ma kian va nga ta vodon sasavoir ngan kavo vinuor ka ie. ");
INSERT INTO tbf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Enga bu muomuo nga kael! Nga ko tsang rivie bu ngenngen i aron manga sar koi da, eiekesen nga ko konobiel ngan mi kamel! ");
INSERT INTO tbf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mi tsienakor leong ta monongie nga bu vavvasengei simi vinuor ma enga bu Parisaio! Enga bu malamala ka duis! Nga ko govorie mi kurikurien kenga sar koi unun ma kenga sar koi ngongou, eiekesen i aron a vous ngan mi sinavei nia ngaguo ma mi sinavei nia vavada. ");
INSERT INTO tbf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Evoi mi Parisaio! Evoi mi kael! E ta ngas muna govoir rivie misa ta mon i aron mi koi unun ma mi koi ngongou ma mi kurikurien buer ta melemelen! ");
INSERT INTO tbf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mi tsienakor leong ta monongie nga bu vavvasengei simi vinuor ma enga bu Parisaio! Enga bu malamala ka duis! Nga malan bu monmon ian gi ta kovuo nge puneits. Ma a matkalei ka i marar, eiekesen, i aron, a vous ngan bu tsirien bu mei mesei ma bu kepineits molubiets. ");
INSERT INTO tbf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Malan be mo, i marar nga matkalei i matan bu mei kokouk, eiekesen bu aronga a vous ngan mi sinavei nia malamala ka duis ma bu sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mi tsienakor leong ta monongie nga bu vavvasengei simi vinuor ma enga bu Parisaio! Nga tsana magi sar tetteir bu propet ma nga vosonie magi sar monmon mi kulou gi ta duis i matan e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma nga pevien ne, ‘Sien va gei nga mon ian sibu ra simi tubugei, gei kap nga oit nia tuir meie gie gi ta nga kenvamate bu propet.’ ");
INSERT INTO tbf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Io, enga kesenga nga vavatei katsep ngan va enga bu natuon egie ese gi ta nga kenvamate bu propet. ");
INSERT INTO tbf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Maga, nga vuruvan misa bu tubunga gi tate nga tsuok vakake! ");
INSERT INTO tbf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Enga bu tsotsoi! Enga bu natuon bu tsotsoi tsokor! Vasa nga ta vi ven si manga vinatoreis kuvu simi leing leong ian ta kap ko mesei? ");
INSERT INTO tbf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Io, o te ture terie senga bu propet ma bu ka sinavei ma bu vavvasengei. Kavo mei mene segie nga ta kenvamate, a, kavo mei mene, nga ta vetekiuo simi koitskoits, ma kavo mei mene, nga ta tsatsakie gie i aron kenga sar vona rengeir nge vikikinie gie sibu taon kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Io, surie ine, mi vinatoreis leong ta kor i poponga surie mi daran mi kulou kokouk gi ta duis i matan e Raban, vakaek simi daran e Abel ese ta duis i matan e Raban, beit simi daran e Sakaria e natuon e Barakia ese nga ta nga kenvamate i kotubuon mi Vona rengeir leong ma mi korot nia tu tienebeir. ");
INSERT INTO tbf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","O oeng tuktuk senga, man vinatoreis ine bu kiden ta kor i popon mi kuoluon ine bu ra. ");
INSERT INTO tbf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalem, Ierusalem! Evoi e nga kenvamate bu propet nge tomerie nge vunavout egie ese e Raban ta nga ture terie sevoi. Palan bu ra o nga lalaro govite kakakuon bu natu, malan mi kina to ta govitan bu natuon i pakien ba poroporuon, eiekesen e kap nga sunuir seou! ");
INSERT INTO tbf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pare! Ke vona rengeir tate mon tuvuon nge ringringidin. ");
INSERT INTO tbf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","O oeng senga, “Nga ta kap dengarie iou te buer, tuir oit va nga ta pevien, ‘Mi vavatamaes ta mon seie ese ta nemei ngan mi asan mi Nguts.’” ");
INSERT INTO tbf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sien e Iesu tate nga sorvekenan mi Vona rengeir leong, ken sar madar tovtov gi nga nemei sien nge tus vasangan seie bu vonuo i mararan mi Vona rengeir leong. ");
INSERT INTO tbf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Io, a nga pevien segie, “Nga pare ine bu vonuo leong? O oeng tuktuk senga. Kap ka vout kes ta so muturungie ka turan vout. A tuktuk, bu vout kokouk gi ta vatsarerie vuturungie gie i keim.” ");
INSERT INTO tbf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sien e Iesu ta nga mogos simi pout i Oliv bu madar tovtov gi nga nemei kesegie mo sien ma gi nga vereie, “Pengan segei. Venenges ine mi ra va ta beit ma man sana totourlekier ke minuer ma man votovoto mi mangmagoso enaenamon?” ");
INSERT INTO tbf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","E Iesu a nga kuil nama, “Nga ta nenei kalei. Kian va ka mei ta bitie nga. ");
INSERT INTO tbf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Palan bu mei gi ta nemei ngan mi asoung nge pevien, ‘Eou mi Messia,’ ma gi ta bitie palan bu mei. ");
INSERT INTO tbf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma nga ta so rongovan bu vinevineken vatavatat ma bu nama i sar surie bu vinevineken i pek. Eiekesen kian va nga ta aor tsak. Ine bu kepineits ta ngas tsorubeit, eiekesen man votovoto mi mangmagoso enaenamon ta kap ngas beit. ");
INSERT INTO tbf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bu enamon leong gi ta veken nge gie kesegie, bu mangmagoso nguts gi ta vemikiur nge gie kesegie ma bu se ma bu oen ta beit sibu korot palan. ");
INSERT INTO tbf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ine bu kepineits ta malan mi vinavasor vourvour simi vevien va ta por madar. ");
INSERT INTO tbf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Samo gi ta so rakopie nga nge terie nga va gi ta vikikinie nga nge kenvamate nga. Mi kulou gi ta karto nga simi vunan nga vodovodon tuktuk seou. Bu mei kokouk gi ta matakorot nge nga surie mi asoung. ");
INSERT INTO tbf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ian simi ra, palan bu mei gi ta so kor vekenan e Raban, ma gi ta so veroev nge terie gie kesegie ma vematakorot nge gie. ");
INSERT INTO tbf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma palan propet bitbit gi ta so tamtuir nge bitie palan bu mei. ");
INSERT INTO tbf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma surie mi sinavei tsokor ta beit leong, palan bu mei gi ta so tsupuk rivie kegi sar lalaron sibu palapalagie. ");
INSERT INTO tbf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Eiekesen eie ese ta tuir ngeisngeis oit simi ra votovoto ta so suvuon mi vavato. ");
INSERT INTO tbf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma ine mi Banga Vinavatei surie ken sinavei nia vuor e Raban gi ta vavatei ngan i aron mi mangmagoso enaenamon kokouk terengien bu mei gi ta mang oit nia vodovodon tuktuk, ma i muir mi ra votovoto ta ba beit. ");
INSERT INTO tbf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Io, sien va nga ta pare ‘mi kepineits ian ta molubiets’ va tate tuir simi korot tamat malan e Daniel mi propet ta nga vokokotie, egie gi ta mon i Iudea gi ta ngas vi ra kien sibu pout. Io, eie ese ta ase ine ta ngas katsep. ");
INSERT INTO tbf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sien va ka mei ta mon i pungan ken vonuo, kian va ta tsour nge rubukien nia poro ken sar kepineits. ");
INSERT INTO tbf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sien va ka mei ta mon i tau, kian va ta muerengei nge poro man kuirkuir. ");
INSERT INTO tbf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lavei! Mi masitinoiv leong segie mi langei gi ta tian ma mi langei vusus ian simi keipkepide ra. ");
INSERT INTO tbf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nga no va kenga vini ta kap tsorubeit sibu rangi bat o, simi Rangi Minaes, ");
INSERT INTO tbf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","simi vunan ian simi ra mi tsienakor leong beitsak ta so beit, ian ta kap nga tsorubeit vakaek si man tsuoktsuok vakaek mi mangmagoso enaenamon oit nevere, ma i murien ta kap kavo kepineits tsak malan te buer. ");
INSERT INTO tbf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sien va e Raban a kap nga por potiepotien ine bu ra, va kap ka mei a nga to, eiekesen ine bu ra, eie ta ngas por potiepotiegie nia kulie ken kulou vivviel. ");
INSERT INTO tbf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ian sibu ra, sien va ka mene ta pevien senga, ‘Pare, ine arie mi Messia! o, eie nikot!’ kian va nga ta vodovodon tuktuk sien, ");
INSERT INTO tbf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","simi vunan bu Messia bitbit ma bu propet bitbit gi ta beit ma gi ta so tsana bu suasuada totourlekier leong ma bu kepineits leong ni vovokudier. Sien va ta oit, gi ta bit tsana ken kulou vivviel e Raban. ");
INSERT INTO tbf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","pare! O te muna pengan senga ine bu kepineits i muan va gi ta ba so beit. ");
INSERT INTO tbf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Io, sien va ka ka ta pengan senga, ‘Pare eie nikot a mon simi beir,’ kian va e ta rakot o, sien va ta pevien, ‘Pare eie die a mon i ruom,’ kian va e ta vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sien va e Natuon mi Ka ta nemei eie ta malan mi kutsukutsuleip ian ta kutsuleip simi mariu kovuni simi matanias ta rar tsour oit simi matanias ta ros. ");
INSERT INTO tbf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ivie mi piripirien bu mei maet gi ta mon en, bu moduram gi ta beit kokouk en. ");
INSERT INTO tbf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“I murien duis ian bu ra ni vinekikin tsokor, “‘mi matanias ta rar bungou, ma mi vura ta kap puits, bu kaemkaem gi ta kor kovuni simi rangit, ma man sar ngeisngeis mi mariu gi ta moruor.’ ");
INSERT INTO tbf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Io, man totourlekier e Natuon mi Ka ta tsorubeit vasvas simi mariu ma bu vuna enamon kokouk simi kaber gi ta ta. Gi ta pare e Natuon mi Ka ta nemei i popon mi balbal simi mariu meie ngan mi ngeisngeis ma mi banga matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma e Raban ta turan ken sar angelo ngan mi tienengen mi tuvuir, ma gi ta kir kakaku gie ken kulou vivviel e Raban kovuni siba mata mour voveit, kovuni simi tangatson mi mangmagoso enaenamon, oit simi tangaots ka ie. ");
INSERT INTO tbf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nga por vavakatsep simi sinavien mi ei mi fik. Sien va bu rakarakan va gi tate beit mangmangeda ma vakaek nge bira, nga telekiran va man vura mi parpar a te vatavatat. ");
INSERT INTO tbf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Io, sien va nga ta pare ine bu kepineits ta vor ve tsotsorubeit, nga ta telekiran va a te vatavatat ian mi ra, ma a te tuir i matavanuo. ");
INSERT INTO tbf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","O oeng tuktuk senga, mi kuoluon ine bu ra gi ta kap ngas voto tuir oit ine bu kepineits kokouk ta tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mi rangit ma mi kaber ta so voto eiekesen kong sar nama ta kap so voto.” ");
INSERT INTO tbf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kap ka mei a telekiran venenges ian mi ra o, mi keipkepide ra va ta beit. Bu angelo simi rangit ma e Natuon buer gi kap telekiran. E Raban kesen mo a telekiran. ");
INSERT INTO tbf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sien e Natuon mi Ka va ta beit, ta malan misa ta nga tsorubeit ian sibu ra se Noa. ");
INSERT INTO tbf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","I aron ian bu ra i muan mi tubuik leong, mi kulou gi nga mon ngan mi ngou, a, mi un, a, mi verei, ma mi vavuo bu natugie, tuir oit simi ra e Noa ta nga rubukien si man mon. ");
INSERT INTO tbf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Eiekesen gi kap nga telekiran misa va ta nga beit oit mi tubuik leong a nga nemei ma a nga sorara gie. Ine arie ta malan simi ra va e Natuon mi Ka va ta beit. ");
INSERT INTO tbf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ian simi ra ba ka luo guor ta mon i tau nge tsatsang, e Natuon mi Ka ta kir tsana mi mei kes seguor, ma mi mei mene ta mon. ");
INSERT INTO tbf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ba vevien luo guor ta leik leseik, e Natuon mi Ka ta kir tsana mi mei kes seguor ma mi mei mene ta mon. ");
INSERT INTO tbf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Io, nga ta ngas nenei kalei simi vunan nga kap telekiran venenges manga Nguts va ta beit. ");
INSERT INTO tbf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Eiekesen nga ta ngas telekiran ine, sien va e taman mi vonuo a telekiran mi keipkepide ra mi ka puerpuer va ta beit sien, eie ta pan rorois va mi ka puerpuer ta kap mang me rubukien si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Io, enga buer nga ta ngas rorois, simi vunan e Natuon mi Ka ta nemei simi keipkepide ra nga ta vodon va ta kap beit sien. ");
INSERT INTO tbf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ese mi banga petspets sievei ma a ko tuktuk si ken tsientsang? Arie eie man ka leong ta terie ken baitutuir nia naneie ken sar petspets nge tabarie gie duis sibu kato ra nia ngou. ");
INSERT INTO tbf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mi nires leong ian simi petspets sien va man ka leong ta me beit vorotan va a ngas tuir si ken baitutuir simi tsientsang. ");
INSERT INTO tbf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","O oeng tuktuk senga. Ine mi ka leong ta terie ine ken petspets nia naneie ken sar sinsuv kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Eiekesen, sien va ine mi tsaka petspets ta pevien seie kesen nge kia, ‘Ta potaram te mong ka leong ta ba muerengei,’ ");
INSERT INTO tbf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma samo ta vakaek nge tsatsakie bu turan petspets, ma ta mon ngan mi ngou ma mi un nge be, ");
INSERT INTO tbf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","io, man ka leong ian mi petspets ta ra nemei si ka ra ta vodon va ta kap beit sien ma si ka keipkepide ra eie ta kap telekiran. ");
INSERT INTO tbf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma ta me tsetstseik vatsakatie ine mi petspets nge teir meie nge gie bu malamala ka duis ivie va gi ta so tata nge vengvengio en bu rivogie. ");
INSERT INTO tbf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ian simi ra, mi sinavien e Raban nia vuor ta malan mi sinangavur kes mi langei vour gi ta nga poro kegi sar bember ma gi nga rakot nia suoeie mi ka va ta nga rei vour. ");
INSERT INTO tbf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ba vevien vour napaririem ka ie gituo nga be ma ba mene napaririem ka ie gituo nga sievei. ");
INSERT INTO tbf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ba mei gituo ta nga be gituo nga poro mo kegituo sar bember, eiekesen gituo kap nga por man karasin. ");
INSERT INTO tbf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Eiekesen ba mei gituo ta nga sievei gituo nga poro kegituo sar bember meie ngan bu utut a nga vous nge karasin. ");
INSERT INTO tbf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mi ka va ta nga rei vour a kap nga beit lalapus ma gi nga mat mumuang nge muang. ");
INSERT INTO tbf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Sikati potaram gi nga koupkoup ‘Eie te mi ka va ta rei! Nga nemei nge me suoeie!’ ");
INSERT INTO tbf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Samo mi langei vour kokouk gi nga pan nia vakartie kegi sar bember. ");
INSERT INTO tbf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ba mei gituo ta nga be gituo nga oeng segituo ian gituo ta nga sievei, ‘Ngatuo terie segatuo kegatuo ka puk karasin mene, kegatuo sar bember gi te maet.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ba vevien gituo ta nga sievei gituo nga kuil nama, ‘A kap. Ta masi kap oit segiet kokouk. Misasien, ngatuo rakot segie gi ta ko verikuil nge lakep ngan mi karasin ma ngatuo ta ra vovoir.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Eiekesen i murien gituo ta nga veis nia ra voir karasin, mi ka rei vour a te nga beit. Ba vevien mene ese gituo ta nga rorois, gituo nga rubukien meie ine mi ka rei vour simi nginou ni verei. Ma gi nga bokutie mi matavanuo. ");
INSERT INTO tbf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“I muir sien ba vevien be gituo ta nga nemei, gituo nga virevirei, ‘Ka leong! Ka leong! Tsitsi vara gatuo!’ ");
INSERT INTO tbf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Eiekesen a nga kuil nama, ‘O oeng tuktuk sengatuo. O kap telekira ngatuo!’ ");
INSERT INTO tbf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Io, nga ta ngas nenei kalei, simi vunan nga kap telekiran mi ra ma mi keipkepide ra va e Natuon mi Ka ta beit. ");
INSERT INTO tbf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ma buer mi sinavien e Raban ta vuor a malan mi ka ese ta nga visi veis simi vineis kuar, a nga kukuo ken ba petspets ma a nga terie ken sar sinsuv i naparimagituo. ");
INSERT INTO tbf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Simi mei vourvour a nga terie sien bu lut lakep talent mi napaririem, ma simi mei vuluongan a nga terie sien ba lut lakep talent luo, ma simi mei mene buer a nga terie sien mi lut lakep talent kes. A nga teir malan ngan ian nia vaotie ken sinavei mi ka keskes. Samo a nga veis si ken vineis. ");
INSERT INTO tbf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mi ka ese ta nga tserie bu lut lakep talent mi napaririem, ian ngas te a nga veis nge ra tsatsang ngan bu lakep, ma a nga vabatie bu lut lakep talent mi napaririem te buer. ");
INSERT INTO tbf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Io, ian buer mi mei ta nga tserie ba lut lakep talent luo a nga veis nge ra tsatsang ngan ma a nga vabatie ba lut lakep talent luo te buer. ");
INSERT INTO tbf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Eiekesen mi ka ese ta nga tserie mi lut lakep talent kes a nga veis ma a nga ra tsuopuo mi mat ma a nga muningan ken sar lakep man ka leong. ");
INSERT INTO tbf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“I murien bu ra palan, man ka leong ian ba petspets a nga muerengei ma a nga me vereie gituo vasa gituo nga tsatsang venengan ken sar lakep. ");
INSERT INTO tbf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mi ka ese ta nga tserie ba lut lakep talent mi napaririem a nga nemei nge pevien, ‘Ka leong e nga terie i naparimoung ba lut lakep talent mi napaririem. Pare! O te buer vabatie ba lut lakep talent mi napaririem mene te buer.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Man ka leong a nga kuil nama, ‘Mi banga tsientsang, evoi mi banga petspets ma e ko tuktuk si ke tsientsang! E te nga ko tuktuk si ke tsientsang siba kepineits kap vovo. O ta terie no va e ta kovan bu kepineits palan. Nemei nge me suv si ken nires ma ka leong!’ ");
INSERT INTO tbf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mi ka ese ta nga tserie ba lut lakep talent luo a nga nemei buer nge pevien, ‘Ka leong, e nga terie i naparimoung ba lut lakep talent luo. Pare, o te buer vabatie ba lut lakep talent luo mene te buer.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Man ka leong a nga kuil nama, ‘Mi banga tsientsang, evoi mi banga petspets ma e ko tuktuk si ke tsientsang! E te nga ko tuktuk si ke tsientsang siba kepineits kap vovo. O ta terie no va e ta kovan bu kepineits palan. Nemei nge me suv si ken nires ma ka leong!’ ");
INSERT INTO tbf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Samo ian mi petspets ese ta nga tserie mi lut lakep talent kes a nga nemei nge pevien, ‘Ka leong. O nga telekiran va evoi mi ka kov ngeisngeis. E ko por nginonginou ivie e ta kap nga tsutsuor en ma e ko sere kakakuon ivie e ta kap nga riv pei en. ");
INSERT INTO tbf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Io, o nga motou ma o nga veis nge ra muningan ke lut lakep talent simi kaber. Pare, ine arie ke lut lakep talent e ta nga terie seou.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Man ka leong a nga kuil nama, ‘Evoi mi tsaka petspets mat maermaer! Io, e telekiran va o ko por nginonginou ivie o ta kap nga tsutsuran ma o ko sere kakakuon ivie eou o ta kap nga riv pei en. ");
INSERT INTO tbf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Io, a nga kalei beitsak sien va e nga poro kong sar lakep nge ra terie simi vonuo teteir lakep va gi ta nga ra tsatsang ngan, terengien sien va o ta muerengei, o ta mang suvuon kavo lakep mene i popon kong sar lakep. ");
INSERT INTO tbf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Nga por tsana mi lut lakep talent sien nge terie seie ian ta suvuon bu lut lakep talent mi sinangavur kes.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Segie ese gi ta suvuon, e Raban ta buer teteir i popon ma gi ta suvuon ta palan beitsak, eiekesen segie ese gi ta kap suvuon, misasien va ka puk lili gi ta suvuon, e Raban ta por tsana segie. ");
INSERT INTO tbf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","‘Nga ta tomeke vorotsoro ine mi petspets mat maermaer simi ngingi e kinagie, ivie va ta tata nge vengvengio en bu rivon.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sien va e Natuon mi Ka va ta nemei ngan man matvinavaso meie bu angelo kokouk, eie ta mogos i popon ken mogomogos ni Nguts meie man matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bu vuna enamon kokouk gi ta kir kakaku gie beit i matan, ma ta vierta gie malan mi ka nennei sipsip ta viertan bu sipsip sorvekenan bu meme. ");
INSERT INTO tbf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eie ta pot terie bu sipsip si ken riem suv ma bu meme si ken riem kieir. ");
INSERT INTO tbf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Samo mi kovakova ka leong ta oeng segie si ken riem suv, ‘Nga nemei, enga ese e Tamoung ta vatamase nga. Nga me suvuon kenga vavatamaes si ken mangmagoso Nguts e Raban ian e Raban ta nga rorois ngan va senga vakaek te simi vinagoso. ");
INSERT INTO tbf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","O nga vitor ma nga nga tabarie iou. Ma o nga moruo ma nga nga vuvunumie iou. Ma o nga mala kibang ma nga nga marangata iou si kenga sar vonuo. ");
INSERT INTO tbf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","O nga pinat surie lavlav ma nga nga vosonie iou. Ma o nga morouk ma nga nga naneie iou. Ma o nga mon simi vona vinatoreis ma nga nga nemei nia me iro iou.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Samo bu ka gi ta duis i matan e Raban, gi ta kuil nama sien, ‘Mi Nguts, sisa gei nga pare no e nga vitor ma gei nga tabarie no, o, sien e ta nga moruo ma gei nga vuvunumie no? ");
INSERT INTO tbf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sisa gei nga pare no va e nga malan mi kibang ma gei nga marangata no si kegei sar vonuo, o, e nga pinat suri lavlav ma gei nga vosonie no? ");
INSERT INTO tbf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sisa gei nga pare no e nga morouk, o, e nga mon i aron mi vona vinatoreis ma gei nga ra iro no?’ ");
INSERT INTO tbf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mi kovakova ka leong ta kuil nama, ‘O oeng tuktuk senga, mi sana kepineits e ta nga tsana si ka meinmenien ine bu kasiung kap asna, e te nga tsana seou.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Samo ta oeng segie ian si ken bieng kieir. ‘Nga tsupek sorvekena iou. Enga e Raban a te nga oeng subira nga. Nga rakot simi leing ta kap man ka votovoto nian e Satan ma ken sar angelo. ");
INSERT INTO tbf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","O nga vitor eiekesen nga kap nga tabarie iou. O nga moruo eiekesen nga kap nga vuvunumie iou. ");
INSERT INTO tbf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","O nga mala kibang eiekesen nga kap nga marangata iou si kenga sar vonuo. O nga morouk nge mon i aron mi vona vinatoreis eiekesen nga kap nga naneie iou.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma egie gi ta kuil nama, ‘Mi Nguts, sisa gei nga pare no e nga vitor, o, moruo, o, mala kibang, o, pinat suri lavlav, o, morouk, o, mon simi vona vinatoreis, ma gei kap nga kulie no?’ ");
INSERT INTO tbf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Eie ta kuil nama, ‘O oeng tuktuk senga, mi sana kepineits nga ta kap nga tsana si ka meinmenien ine bu kasiung kap asna, nga kap nga tsana seou.’ ");
INSERT INTO tbf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Samo, gi ta rakot simi vinatoreis kap man ka votovoto, eiekesen bu ka gi ta duis i matan e Raban, gi ta rakot simi tino rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","I murien e Iesu tate nga vokokotie ine bu kepineits kokouk, a nga oeng si ken sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Malan nga tate telekiran, mi Nginu Pasova ba ra luo mo a te kitipan. Ian simi ra gi ta terie e Natuon mi Ka va gi ta vetekiuo simi koitskoits.” ");
INSERT INTO tbf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Samo bu prist leong ma bu muomuo simi kulou gi nga beit kouk i mararan ken vonuo e Kaiapas mi kovan bu prist, ");
INSERT INTO tbf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ma gi nga roev nia raok menentan nge kenvamate e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gi nga pevien, “Eiekesen giet ta kap tsana i aron mi nginou. Mi kulou gi ta masi tsuokvakake ka tseng.” ");
INSERT INTO tbf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E Iesu a nga mon i Betani i aron ken vonuo e Simon ese ta nga suvuon mi mienarouk lepra muomuo. ");
INSERT INTO tbf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sien e Iesu ta nga mogos i bingan mi tsur ngongou, mi vevien a nga nemei sien ngan mi utut vout ta nga vous ngan mi da sosong ivie man voirvoir ta nga vaen ma a nga soan i kovan. ");
INSERT INTO tbf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sien bu madar tovtov gi ta nga pare ine, gi nga petseir, ma gi nga virei, “Surie misa ine mi vevien ta soe tuvuon ngan ine mi da sosong?” ");
INSERT INTO tbf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ine mi da sosong, a oit nia verikuil ngan nge lakep palan ma ian mi lakep ta oit nia kulie bu sinaortsak. ");
INSERT INTO tbf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E Iesu a nga telekiran mi sana gi ta nga vokokotie, ma a nga oeng segie, “Surie misa nga ta nama palan ngan ine mi vevien? Eie a tsana mi banga kepineits seou. ");
INSERT INTO tbf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bu sinaortsak gi ta mon meie nga sibu ra kokouk, eiekesen eou o ta kap mon meie nga sibu ra kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sien ta soan ine mi da sosong i kurikuriung, a te tsana nia rorrois ngan mi piripiriung nian kong mintur simi monmon. ");
INSERT INTO tbf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","O oeng tuktuk senga, simi sana korot simi mangmagoso enaenamon gi ta vavatei ngan mi Banga Vinavatei, mi sana kepineits ine mi vevien ta tsana gi ta vavatei ngan buer nia vodonomie ngan eie.” ");
INSERT INTO tbf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Samo mi meinmenien mi sinangavur kes ma luo bu madar tovtov, mi asan e Iudas Iskariot, a nga rakot sibu prist leong, ");
INSERT INTO tbf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma a nga vereie gie, “Misa nga res nia terie seou sien va o ta roev terie e Iesu i naparimanga?” Io, gi nga aes terie sien ba sinangavur tour bu silva lakep. ");
INSERT INTO tbf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Vakaek te ian, e Iudas a nga dedeng ngan ka kientsep nia roev terie e Iesu i rimagie. ");
INSERT INTO tbf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Simi ra vourvour simi nginou nian mi Tsoik kap ka iis sien, bu madar tovtov gi nga nemei se Iesu nge vereie, “Ivie e lalaron va gei ta rorois ngan en mi Nginou nian mi Pasova va e ta ra nganie?” ");
INSERT INTO tbf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","E Iesu a nga kuil nama, “Nga rubukien simi taon nge rakot simi ka ma nga ta oeng sien, ‘Mi vavvasengei a pevien; Kong keipkepide ra a te vatavatat. O ta barabaramatan mi Nginu Pasova meie kong sar madar tovtov si ke vonuo.’” ");
INSERT INTO tbf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Io, bu madar tovtov gi nga tsana malan e Iesu ta nga oeng segie ma gi nga ra tsang rorois ngan mi Nginu Pasova en. ");
INSERT INTO tbf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sien tate nga reivreiv seserigo, e Iesu ma mi sinangavur kes ma luo ken sar madar tovtov gi nga mogos viririsie mi tsur ngongou. ");
INSERT INTO tbf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma sien gi tate nga vakaek nge ngou, a nga pevien, “O oeng tuktuk senga, ka mei senga ta roev terie iou simi matakorot.” ");
INSERT INTO tbf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gi nga mesirik ma gi nga vakaek nge virei vovokes rakot se Iesu, “A tuktuk, kap va eou, va gerek, mi Nguts?” ");
INSERT INTO tbf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","E Iesu a nga kuil nama, “Mi mei ese ta tsonga mi poko tsoik meie iou i aron mi koi ngongou, arie eie ta roev terie iou simi matakorot. ");
INSERT INTO tbf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","E Natuon mi Ka ta mesei malan mo mi Pakpak Leong ta vakokoit surie. Eiekesen, mi tsienakor leong ian simi ka ese ta roev terie iou simi matakorot! A kalei sien va gi kap nga kava.” ");
INSERT INTO tbf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Samo e Iudas ese ta nga roev terie a nga pevien, “A tuktuk, kap va eou, va gerek, Vavvasengei?” E Iesu a nga kuil nama, “Io, arie evoi mo.” ");
INSERT INTO tbf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sien gi ta nga vor ve ngongou, e Iesu a nga poro mi tsoik, ma a nga vuot kalei nge potakie nge terie si ken sar madar tovtov ma a nga pevien, “Nga poro nge nganie. Ine arie mi piripiriung.” ");
INSERT INTO tbf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Samo a nga poro mi koi unun ma a nga vuot kalei se Raban ma a nga terie segie nge pevien, “Nga un sien ine, enga kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ine arie mi daroung simi kinubuits ian ta tamasoei nian bu mei palan nia vodon rivie kegi sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","O oeng senga, o ta kap ba buer unumie mi dangi vuavua vain vakaek ine oit ian simi ra va o ta so unumie mi dangi vuavua vain vour meie nga i aron ken mangmagoso Nguts e Tamoung.” ");
INSERT INTO tbf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sien gi tate nga keveir vaton mi paka rengeir gi nga veis rovotsour rakot simi pout i Oliv. ");
INSERT INTO tbf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E Iesu a nga pevien segie, “Enga kokouk nga ta kor si kenga sar vienviendon surie iou, surie mi Pakpak Leong a pevien ne, “‘O ta keda mi ka nennei sipsip, ma bu sipsip gi ta vi vepitsitsei.’ ");
INSERT INTO tbf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eiekesen i murien va o ta to muerengei simi miensei, o ta muo senga rakot i Galili.” ");
INSERT INTO tbf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","E Petro a nga oeng ngeisngeis, “Misasien va egie kokouk gi ta murien veie no, eou kap.” ");
INSERT INTO tbf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","E Iesu a nga oeng sien, “O oeng tuktuk sevoi. Ine sikati i muan va mi to ta kurkuku, e ta so vamoie iou votour.” ");
INSERT INTO tbf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Eiekesen e Petro a nga oeng ngeisngeis sien, “Misasien va o ta mesei meie no, o ta kap oit nia vamoie no.” Ma bu madar tovtov kokouk gi nga vakokoit malan buer. ");
INSERT INTO tbf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Samo e Iesu a nga veis meie ken sar madar tovtov rakot simi korot gi vuotongie va i Getsemane, ma a nga oeng segie, “Nga mogos en ne. O ta rakot en nikot nge ra no.” ");
INSERT INTO tbf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A nga kerie e Petro ma ba natuon e Sebedi meie. Ma a nga rongmetsikien mi aor tsak leong ma mi putu. ");
INSERT INTO tbf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Samo a nga oeng segituo, “Mi aroung a vous ngan mi aor tsak ma a te vatvatta kenvamate iou. Ngatuo ta mon en ne nge nenei meie iou.” ");
INSERT INTO tbf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E Iesu a nga veis rakot i pek lili ma a nga tsibour matan i keim simi kaber ma a nga no, “Tama, sien va a oit, por tsana seou ine mi koi simi vinekikin. Eiekesen, vemusurie ke lalaron ma a kap va kong lalaron.” ");
INSERT INTO tbf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Samo a nga muerengei rakot si ken ba madar tovtov ma a nga vorota gituo sien gituo tate nga muang, ma a nga vosuoreie e Petro, “Vasa, ngatuo kap oit nia pan nge nenei meie iou ka aua kes? ");
INSERT INTO tbf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ngatuo ta pan nge no, terengien ngatuo ta kap mang kor simi konokonon. Mi moromoruo a pets, eiekesen mi pirpir a kap suvu ngeisngeis.” ");
INSERT INTO tbf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","E Iesu a nga veis sorvekena gituo te buer mi keipkepide ra a luongan, ma a nga ra no, “Tama, sien va e kap oit nia por tsana seou ine mi koi, ma sien va o ta ngas un sien, a kalei, tsatsang vemusurie ke lalaron.” ");
INSERT INTO tbf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma a te buer nga me vorota gituo sien gituo ta nga muang simi vunan bu katsomatagituo a nga putu. ");
INSERT INTO tbf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Io, a nga sorvekena gituo te buer ma a nga veis nge ra no mi keipkepide ra a tourngan. A nga no vemusurie mo malan ken nono vourvour ta nga vuotongie. ");
INSERT INTO tbf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Samo a nga muerengei rakot si ken ba madar tovtov ma a nga oeng segituo, “Vasa, ngatuo ngas vor ve mumuang nge maes? Ngatuo dedeng, mi keipkepide ra a te vatavatat, ma e Natuon mi Ka gi tate roev terie i napariman bu ka tsokor. ");
INSERT INTO tbf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nga tamtuir! Giet tate ra. Eie te mi ka va ta roev terie iou simi matakorot!” ");
INSERT INTO tbf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sien ta ngas nga vor ve vakvakokoit, e Iudas mi meinmenien mi sinangavur kes ma luo bu madar tovtov a nga beit. Mi kulou palan gi nga nomeie ma gi nga sorokie kegi sar kuor ma bu bam. Bu prist leong ma bu muomuo simi kulou gi nga tura gie. ");
INSERT INTO tbf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Io, ine mi ka ni roev terie e Iesu a nga rove mi totourkilal meie gie ven ne, “Mi mei ese o ta so ngungurie, arie eie mi ka. Nga ta rakopie.” ");
INSERT INTO tbf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E Iudas a nga lalapus rakot se Iesu ma a nga pevien, “Mi kati, Vavvasengei!” Ma a nga ngungurie. ");
INSERT INTO tbf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","E Iesu a nga oeng sien, “Palapala, tsana misa e ta me visi tsana.” Samo gi nga nemei nge rakopie e Iesu nge visie. ");
INSERT INTO tbf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sien gi tate nga tsang malan ngan ine, mi mene segie ese gi ta nga mon meie e Iesu a nga te vorotsoruo ken kuor ma a nga tseir rivie mi tateringan ken petspets mi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","E Iesu a nga oeng sien, “Teir muerngan ke kuor si man sovsov, simi vunan egie kokouk ese mune gi ta ken nge kuor, gi ta kenvamate gie ngan mi kuor. ");
INSERT INTO tbf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Vasa, e vodon va o kap oit nia kukuo e Tamoung ma ine ngas te ta turan mi sinangavur kes ma luo bu gargar leong sibu angelo simi minakiur? ");
INSERT INTO tbf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eiekesen vasa ta oit nia tsorubeit tuktuk ven mi nama simi Pakpak Leong ian ta pevien va ta ngas tsorubeit malan ne?” ");
INSERT INTO tbf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Samo a nga oeng simi kulou, “Vasa, nga kia va eou mi ka kenken? Arie mi vunan nga te nemei ngan bu kuor ma bu bam nia me rakopie iou? Sibu ra kokouk o nga mogos i mararan mi Vona rengeir leong nge vavasengei ma nga kap nga rakopie iou. ");
INSERT INTO tbf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Eiekesen ine bu kepineits a tsorubeit nia vaotie bu vinavataor sibu propet.” Samo ken sar madar tovtov kokouk gi nga murien veie nge vi. ");
INSERT INTO tbf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Egie ese gi ta nga rakopie e Iesu gi nga kerie rakot se Kaiapas, mi kovan bu prist. Ian en bu vavasengei simi vinuor ma bu muomuo simi kulou gi te nga oir kouk en. ");
INSERT INTO tbf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Eiekesen e Petro a nga vor vevemuir oit te i mararan ken vonuo mi kovan bu prist, ma a nga rubukien nge mogos meie mi kulou nennei va ta nga pare misa va ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bu prist leong ma bu Sanedrin kokouk gi nga nesie man kavo nama binit e Iesu, terengien va gi ta mang nga kenvamate. ");
INSERT INTO tbf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eiekesen gi kap nga vorotan kavo nama, misasien palan gi ta nga rovotsour nge vokokotie bu nama binit. I muir, ba mei luo guor nga rovotsour, ");
INSERT INTO tbf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma guor nga pevien, “Ine mi ka a pevien, ‘O oit nia vatsarerie ine ken vona rengeir e Raban, ma o ta tsang muerngan i aron ba ra tour.’” ");
INSERT INTO tbf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Samo mi kovan bu prist a nga tamtuir ma a nga vereie e Iesu, “Vasa, e ta kap kulie ka nama? Mi sana suada nama ine, ine ba ka guor vepitsie nge no?” ");
INSERT INTO tbf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Eiekesen e Iesu a kap nga vokokotie ka nama. Mi kovan bu prist a nga oeng sien, “O oeng sevoi ngan mi ngesengesien e Raban ta tino. Pengan segei sien va a tuktuk va evoi mi Messia, e Natuon e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","E Iesu a nga kuil nama sien, “A malan ian e tate pengan. Eiekesen o oeng senga kokouk, vevemuir, nga ta pare e Natuon mi Ka ta mogos si ken riem suv eie ese ta ngeisngeis rovoriu ma ta nemei i popon mi balbal simi rangit.” ");
INSERT INTO tbf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Samo mi kovan bu prist a nga derikie ken lavlav ma a nga pevien, “Eie a te oeng balapoik ngan e Raban! Surie misa nga tate buer lalaron kavo nama mene? Nga pare, ine nga te rongomie mi namani oeng balapoik ngan e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“Vasa nga vodon ven?” Gi nga kuil nama, “Eie ta ngas maet.” ");
INSERT INTO tbf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Samo gi nga ebisie mi matan. Ma gi nga tutuo ngan bu rimagie. Bu mei mene gi nga pantsie, ");
INSERT INTO tbf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma gi nga pevien, “Pengan segei, Messia! Ese a tutuo no?” ");
INSERT INTO tbf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ian simi keipkepide ra, e Petro a nga mogos i mararan ken vonuo mi kovan bu prist ma mi vevien petspets a nga nemei sien ma a nga pevien, “Evoi buer e nga ko nomeie e Iesu kovuni i Galili.” ");
INSERT INTO tbf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Eiekesen e Petro a nga vamoi i matagie kokouk nge pevien, “O kap telekiran misa e pengan.” ");
INSERT INTO tbf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Samo a nga veis rovotsour simi rumrubukien. Ian en mi vevien petspets mene a te buer nga pare ma a nga oeng segie gi ta nga mon ian en, “Ine mi ka, a nga ko nomeie e Iesu kovuni i Nasaret.” ");
INSERT INTO tbf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E Petro a te buer nga vamoi nge vakavakariem, “O kap telekiran ian mi ka!” ");
INSERT INTO tbf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Samo a kap nga potaram, egie ian gi ta nga tuir kouk gi nga nemei se Petro ma gi nga pevien, “A tuktuk, evoi mi meinmenigie, simi vunan mi ina a vasanga no.” ");
INSERT INTO tbf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Samo a nga vakaek nge vakavakariem ngan e Raban i matagie, “O kap telekiran ian mi ka!” Ma ian ngas te, mi to a nga kurkuku. ");
INSERT INTO tbf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Samo e Petro a nga vodonomie ken nama e Iesu ta nga vokokotie malan ne, “I muan mi to va ta kurkuku, e ta so vamoie iou votour.” Ma e Petro a nga rovotsour ma a nga ta beitsak. ");
INSERT INTO tbf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsourvovo mokuopkuop, bu prist leong ma bu muomuo simi kulou gi nga beit simi vienviendon kes va e Iesu ta ngas nga maet. ");
INSERT INTO tbf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gi nga visie ba riman nge kir rakot ngan ma gi nga terie i napariman e Pilato mi gavana. ");
INSERT INTO tbf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sien e Iudas, ese ta nga roev terie ta nga pare va gi te nga votorosie e Iesu, a nga maduo ma a nga teir muerngan ian ba sinangavur tour bu silva lakep sibu prist leong ma bu muomuo. ");
INSERT INTO tbf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma a nga pevien, “O te tsana mi sinavei tsokor, simi vunan o te roev terie mi ka kap ken ka tsienakor.” Ma gi nga kuil nama, “Kap kegei ka korot ba buer sien. Ian, sevoi ke baitutuir en te.” ");
INSERT INTO tbf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Io, e Iudas a nga tomeke vurukude bu lakep simi Vona rengeir leong. Ma a nga veis nge ra lilio. ");
INSERT INTO tbf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mi meinmenien bu prist leong a nga tsuokopie ine bu lakep ma a nga pevien, “Ine bu lakep mi dar a mon sien ma a kap duis simi vinuor va giet ta terie simi korot teteir lakep simi Vona rengeir leong.” ");
INSERT INTO tbf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Io, gi nga beit simi vienviendon nia poro ine bu lakep nge vorie ngan mi poko kaber simi ka tsangtsang koi pier va ine mi poko kaber ta nga tsorubeit mi puppuon sibu kibang. ");
INSERT INTO tbf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Arie mi vunan gi nga vuotongie ngan va ‘mi Pier simi Dar’ oit te ine sibu ra. ");
INSERT INTO tbf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Io, misa e Ieremia mi propet ta nga vokokotie a nga tsorubeit tuktuk. A nga pevien, “Gi nga poro ba sinangavur tour bu silva lakep ian mi kulou i Israel gi ta nga sunurie nia vovoir ngan. ");
INSERT INTO tbf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma gi nga vorie ngan mi poko kaber simi ka tsangtsang koi pier, malan mi Nguts ta nga oeng seou.” ");
INSERT INTO tbf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E Iesu a nga tuir i matan e Pilato ma e Pilato a nga vosuoreie, “Arie evoi mi kovakova ka leong sibu Iuda?” E Iesu a nga kuil nama, “A malan e tate vuotongie.” ");
INSERT INTO tbf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sien bu prist leong ma bu muomuo gi ta nga vepitsie nge nama, a kap nga vuotongie ka nama. ");
INSERT INTO tbf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Samo e Pilato a nga vosuoreie, “Vasa, e kap rongomie ine bu kepineits gi ta vepitsie no ngan?” ");
INSERT INTO tbf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Eiekesen e Iesu a kap nga kulie ka nama surie bu kepineits gi ta nga vepitsie ngan. Ma mi muomuo a nga kudier beitsak. ");
INSERT INTO tbf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sibu Nginu Pasova kokouk, mi gavana a ko ruom rivie ka mei tsatsang vinatoreis vemusurie kegi lalaron mi kulou. ");
INSERT INTO tbf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ian sibu ra mi ka tsokor a nga mon simi vona vinatoreis, mi asan e Barabas. ");
INSERT INTO tbf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Io, sien mi kulou gi tate nga me beit kouk, e Pilato a nga vosuoreie gie, “Ese mei nga lalaron va o ta ruom rivie terie senga? E Barabas o, e Iesu ese gi ta vuotongie va mi Messia?” ");
INSERT INTO tbf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A nga telekiran va gi nga terie e Iesu i napariman simi vunan gi nga ngungutsuo si ken tsientsang. ");
INSERT INTO tbf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sien e Pilato ta nga vor ve mogomogos simi mogomogos ni vuor, ken vevien a nga turan ine mi nama rakot sien, “Kian va e ta tsana ka kepineits ine simi ka ian ta duis i matan e Raban, simi vunan sikati o berevan ine mi ka, ma ine mi binorea a tsang vatsakatie iou.” ");
INSERT INTO tbf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eiekesen bu prist leong ma bu muomuo simi kulou gi nga oeng ka i aron mi kulou va gi ta nga nongie va ta nga ruom rivie e Barabas eiekesen e Iesu va ta nga sunuir terie simi miensei. ");
INSERT INTO tbf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","E Pilato a nga virei, “Ese seguor ine nga lalaron va o ta ruom rivie terie senga?” Gi nga kuil nama, “E Barabas.” ");
INSERT INTO tbf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","E Pilato a buer nga virei, “Ma misa o ta tsana se Iesu ese gi ta vuotongie va mi Messia?” Egie kokouk gi nga kuil nama, “Vetekiuo simi koitskoits!” ");
INSERT INTO tbf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","E Pilato a nga virei, “Surie misa? Mi sana tsaka sinavei a nga tsana?” Eiekesen gi nga koup ngeisngeis, “Vetekiuo simi koitskoits!” ");
INSERT INTO tbf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sien e Pilato tate nga deng kielala va a kap nga oit nia tsang vaotie ka kepineits, ma mi tseng leong a te nga lalaro tamtuir, a nga poro mi da ma a nga vavano ba riman i matagie kokouk nge pevien, “O ketseketseng simi daran ine mi ka. Kenga baitutuir en te!” ");
INSERT INTO tbf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma egie kokouk gi nga kuil nama, “E ta ngas sunuir va mi daran ta kor i popogei ma bu natugei!” ");
INSERT INTO tbf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Samo a nga ruom rivie e Barabas terie segie. Eiekesen a nga tuturei ma gi nga beilbeiltsie e Iesu. Ma a nga terie va gi ta nga ra vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Samo ken sar ka ni minakiur mi gavana gi nga kir rubukien ngan e Iesu si ken vonuo mi gavana gi ta vuotongie ngan mi Praetorium. Ma gi nga kukuo mi gargar kulou simi minakiur kokouk ma gi nga tuir viririsie. ");
INSERT INTO tbf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gi nga tsion rivie man sar tsetstseik nge vavatsekie ngan mi lavlav dav. ");
INSERT INTO tbf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma gi nga ruonie man kovage ngan bu suo tsotso ma gi nga vavatsekie ngan mi kovan. Gi nga poro mi poko ei nge terie i riman ma gi nga sege pukupukukaek i matan nge vavangiets ngan. Ma gi nga pevien, “E ta tino kuar, kovakova ka leong sibu Iuda!” ");
INSERT INTO tbf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gi nga ebisie, ma gi nga poro mi poko ei nge nisnis ka i kovan. ");
INSERT INTO tbf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","I murien gi tate nga vavangiets vaton, gi nga tsang rivie mi lavlav dav sien ma gi nga vavatsekie ngan man sar tsetstseik kesen. Samo gi nga kir varakoto nia ra vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sien gi ta nga vor ve veisveis rovotsour simi taon, gi nga suoeie mi kangi Kurene mi asan e Simon ma gi nga votsuoke nia sorokie mi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gi nga beit simi korot gi ta vuotongie ngan i Golgota (man vuevue va, ‘Mi Korot simi Paptikov’). ");
INSERT INTO tbf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ian en, gi nga terie se Iesu mi dangi vain gi ta nga gula meie ngan mi da bo va ta nga unumie, eiekesen i murien ta nga daem pare, a nga mereis nia unumie. ");
INSERT INTO tbf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I murien gi tate nga vetekiuo simi koitskoits, gi nga paluo satu nia potakie man sar tsetstseik i kotubugie. ");
INSERT INTO tbf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ma gi nga mogos nge moun ngan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Simi napa ei i kovan mi koitskoits gi nga vataro ian mi nama gi ta nga vuortie surie ngan, ‘Ine e Iesu, magi Kovakova ka leong bu Iuda.’ ");
INSERT INTO tbf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba ka puerpuer luo buer gi nga vetekiuo siba koitskoits i bingan e Iesu, mi mei kes si ken bieng suv ma mi mei mene si ken bieng kieir. ");
INSERT INTO tbf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Egie ese gi ta nga veis rov riu gi nga erire kov nge oeng balapoik ngan, ");
INSERT INTO tbf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ma gi nga pevien, “E nga pevien va e ta vatsarerie mi Vona rengeir leong nge voturie te buer siba ra tour. Maga, sien va evoi e Natuon e Raban, vatoa no kese nge tsour simi koitskoits!” ");
INSERT INTO tbf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Simi sinavei kes mo bu prist leong, ma bu vavvasengei sibu vinuor, ma bu muomuo simi kulou gi nga oeng balapoik ngan, ma gi nga pevien, ");
INSERT INTO tbf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A nga vatoa bu mei mene, eiekesen a kap oit nia vatoa eie kesen! Eie mi kovakova ka leong sibu Israel! Nga ta sangan, ta tsour simi koitskoits va giet ta mang vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eie a vodovodon tuktuk se Raban! Nga ta sangan e Raban ta vatoa sien va ta lalaron, simi vunan a nga pevien va eie e Natuon e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ian ba ka puerpuer gi ta nga vetekiuo guor siba koitskoits i bingan e Iesu, guor nga oeng balapoik ngan buer. ");
INSERT INTO tbf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Vakaek sisiat potaram beit simi 3 kilok sireivreiv, mi ngingi leong a nga kuva mi enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Vatvatta mi 3 kilok sireivreiv, e Iesu a nga koup leong, “Eloi, Eloi, lama sabaktani?” Man vuevue va, “Mong Raban, mong Raban, surie misa e tate murien veie iou?” ");
INSERT INTO tbf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sien bu mei segie gi ta nga tuir vatavatat nge rongomie ine, gi nga pevien, “Nga rorong, eie a kukuo e Eliia.” ");
INSERT INTO tbf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Io, ian ngas te, mi mei segie a nga soer rakot nge ra vosuvie mi kukui kovuni i rou simi dangi vain monour, ma a nga rorotsie simi poko ei nge vutuirse terie se Iesu va ta nga un. ");
INSERT INTO tbf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mi kulou kokouk gi nga pevien, “Kian be! Giet ta be pare va e Eliia ta nemei nge me vatoa.” ");
INSERT INTO tbf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma e Iesu a te buer nga koup leong ma a nga tsupuk rivie mi Morumoruan. ");
INSERT INTO tbf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ian ngas te simi keipkepide ra, mi baba gi ta nga tsana ngan mi lavlav leong nia bangie kitipan mi Korot Tamat Rovoriu simi Vona rengeir leong a nga kedeir napaluo kovuni i kur beit i keim. Mi kaber a nga oen ma bu vunavout gi nga kapot. ");
INSERT INTO tbf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Bu monmon gi nga katsep ma bu piripirien palan mi kuoluon e Raban gi tate nga maet gi nga to muerengei. ");
INSERT INTO tbf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gi nga rovotsour sibu monmon. Ma i murien e Iesu tate nga to muerengei, gi nga rubukien simi taon tamat ma gi nga beit vasvas sibu mei palan. ");
INSERT INTO tbf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mi kulou ni minakiur ma magi muomuo gi ta nga naneie e Iesu, gi nga pare mi oen ma ian bu kepineits kokouk ta nga tsorubeit. Io, gi nga kudier beitsak nge pevien, “A tuktuk te, ine mi ka eie e Natuon e Raban!” ");
INSERT INTO tbf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Palan mi langei gi nga mon, gi nga tuir i pek nge dedeng. Ine mi langei gi nga vemusurie e Iesu kovuni i Galili nia kulie si ken sar pinat. ");
INSERT INTO tbf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E Maria kovuni i Magadala, e Maria e kinan e Iakobo ma e Iosep, ma e kinan ba natuon e Sebedi, gi nga mon i kotubuon ine mi langei. ");
INSERT INTO tbf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sien tate nga reivreiv seserigo, mi ka suvuram kovuni i Arimatea a nga nemei, mi asan e Iosep. Eie buer a nga vodovodon tuktuk se Iesu. ");
INSERT INTO tbf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A nga rakot se Pilato ma a nga ra vosuoreie ngan mi piripirien e Iesu. Io, e Pilato a nga tuturei va gi ta nga poro mi piripirien nge terie sien. ");
INSERT INTO tbf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","E Iosep a nga poro mi piripirien nge ovutie ngan mi lavlav puneits vour. ");
INSERT INTO tbf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma a nga ra vuturungie i aron ken tetteir vour ta nga kole simi vunavout. Ma a nga vuvuil kitipan mi monmon ngan mi vunavout leong nge veis. ");
INSERT INTO tbf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","E Maria kovuni i Magadala ma e Maria ka ie, guor nga mogos matan veie ine mi monmon. ");
INSERT INTO tbf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Simi ra vemusurie, eie mi Rangi Minaes, bu prist leong ma bu Parisaio gi nga rakot se Pilato, ma gi nga pevien, ");
INSERT INTO tbf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ka leong, gei vodonomie ken nama ine mi nguts bitbit. Sien ta ngas nga to, a nga pevien, ‘Simi ra a tourngan o ta to muerengei.’ ");
INSERT INTO tbf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Io, e ta ngas terie ka nama ngeisngeis va gi ta naneie vakalaie mi monmon oit simi ra a tourngan, surie ken sar madar tovtov gi ta masi nemei nge me pure mi piripirien nge bitie bu mei va a te to muerengei. Ine mi binit vevemuir ta tsokor rio mi binit vourvour.” ");
INSERT INTO tbf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","E Pilato a nga kuil nama, “Nga ta kerie kavo ka ni minakiur nia ra nenei, ma nga ta rakot nge ra biritie vakalaie ine mi monmon malan nga ta telekiran.” ");
INSERT INTO tbf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Io, gi nga rakot nge ra terie mi golgol mi asan e Pilato ta nga mon sien. Ma i muir, gi nga voturie ba ka ni nenei. ");
INSERT INTO tbf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I murien mi Rangi Minaes sibu Iuda, tsourvovo mokuopkuop simi ra vourvour simi wik, e Maria kovuni i Magadala ma e Maria ka ie, guor nga rakot nia ra dengarie mi monmon. ");
INSERT INTO tbf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ian simi keipkepide ra mi oen leong a nga beit simi vunan ken angelo mi Nguts a nga tsourpeuk kovuni simi rangit ma a nga rakot simi monmon nge vuvuil rivie mi vunavout ma a nga mogos i popon. ");
INSERT INTO tbf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ken baidendeng a nga malan mi kutsukutsuleip ma man sar tsetstseik a nga puneits malan mi busobuso naov. ");
INSERT INTO tbf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mi kulou ni minakiur gi ta nga naneie mi monmon gi nga motou beitsak ma a nga sigosigong bu arogie ma gi te nga malan bu ka maet. ");
INSERT INTO tbf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mi angelo a nga oeng siba vevien, “Kian va ngado ta motou. O telekiran va ngado nesie e Iesu ese gi ta nga vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eie a kap mon en ne, a te to muerengei, malan mo ta nga vokokotie. Ngado nemei nge me pare mi korot ivie ta nga mutur en. ");
INSERT INTO tbf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ngado ta muerengei lalapus nge ra pengan si ken sar madar tovtov va a te to muerengei simi miensei ma a te muo rakot i Galili. Ian en nga ta so pare. Ngado ta vodonomie misa o tate pengan sengado.” ");
INSERT INTO tbf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Io, ba vevien guor nga lalapus sorvekenan mi monmon. Guor nga motou eiekesen bu aroguor a nga vous ngan mi nires, ma guor nga soer nia ra pengan sibu madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Puk lalapus mo, e Iesu a nga beit seguor ma a nga pevien, “Mi vovo kalei,” guor nga nemei sien ma guor nga rakopie ba kamen nge rengeir rakot sien. ");
INSERT INTO tbf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Samo e Iesu a nga oeng seguor, “Ngado ta kap motou. Ngado rakot sibu kasiung nge ra oeng segie va gi ta rakot i Galili. Ian en gi ta so pare iou.” ");
INSERT INTO tbf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sien ba vevien guor ta ngas nga vor ve veisveis muerengei, bu mei simi kulou ni minakiur gi ta nga naneie mi monmon, gi nga rubukien simi taon nge ra pengan sibu prist leong bu kepineits kokouk ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bu prist leong gi te nga vakokoit meie bu muomuo leong ma gi nga rove va gi ta nga terie bu lakep palan simi kulou ni minakiur, ");
INSERT INTO tbf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma gi ta nga oeng segie, “Nga ta ngas pevien ne, ‘Ken sar madar tovtov gi nga nemei sikati nge me pure mi piripirien sien gei ta nga muang.’ ");
INSERT INTO tbf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sien va ine mi nama ta ra beit simi gavana, egei gei ta ba ra vuduis nama meie nia piknge nga simi tsienakor.” ");
INSERT INTO tbf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Io, mi kulou ni minakiur gi nga poro bu lakep ma gi nga tsana malan ngan gi ta nga oeng teteir segie. Ma ine mi pinouts a nga puorkan i kotubuon bu Iuda kokouk tuir oit ine sibu ra. ");
INSERT INTO tbf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Samo ian mi sinangavur kes ma kes bu madar tovtov gi nga rakot i Galili, simi pout ivie e Iesu ta nga oeng terie gie en. ");
INSERT INTO tbf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sien gi ta nga pare e Iesu, gi nga rengeir rakot sien, eiekesen bu mei mene a nga bakiet kegi sar vienviendon. ");
INSERT INTO tbf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Samo e Iesu a nga nemei segie ma a nga pevien, “Bu ngeisngeis kokouk simi rangit ma simi kaber e Raban a te nga terie seou. ");
INSERT INTO tbf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Io, nga ta veis nge ra tsana mi kuoluon bu vuna enamon kokouk va gi ta tsorubeit kong sar madar tovtov. Io, nga ta tsana mi sinusuruiv segie simi asan mi Tam ma e Natuon ma mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma nga ta vasangan segie nia vemusurie bu kepineits kokouk o tate nga oeng ngeisngeis ngan senga. Ma a tuktuk rovoriu, o ta mon meie nga tuir oit si man ra vekvekitip mi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ine arie man tsuoktsuok vakaek mi Banga Vinavatei surie e Iesu Karisito e Natuon e Raban. ");
INSERT INTO tbf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","E Isaia mi propet a nga vataro ven ne simi Pakpak Leong, “O ta turan kong ka ni vavatei muo sevoi, ese va ta rorois ngan ke rosar.” ");
INSERT INTO tbf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Mi inan mi ka a koupkoup pevien simi beir, ‘Tsang rorois ngan ken rosar mi Nguts. Tsang vodusie ken sar baiveisveis.’” ");
INSERT INTO tbf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Io, e Ioanes a nga beit ine simi beir nge tsana mi sinusuruiv. Ma a nga vavatei va mi kulou gi ta mang nga vodon vuris nge por sinusuruiv terengien va e Raban ta mang vodon rivie kegi sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mi kulou kokouk kuvu i Ierusalem ma sibu enamon kokouk i Iudea gi nga beit seie. Ma gi nga vakokoit katsep ngan kegi sar sinavei tsokor. Ma e Ioanes a nga tsana mi sinusuruiv segie simi da i Ioridan. ");
INSERT INTO tbf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E Ioanes a nga ko tsekie man tsetstseik gi ta nga tsana ngan mi vuruvuru kamel ma a nga ko verevere ngan mi piripiri vinavinar, ma man nginonginou, mi tsiko ma mi masiu. ");
INSERT INTO tbf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma ine arie ken vinakokoit vavakatsep, “Mi ka va ta vemusurie iou, eie a ngeisngeis rio iou. O kap kalei oit nia korgout nge ruobatie mi suo si man ba poppop. ");
INSERT INTO tbf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","O tsana mi sinusuruiv senga ngan mi da, eiekesen, eie ta tsana mi sinusuruiv senga ngan mi Moromoruo Tamat.” ");
INSERT INTO tbf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ian sibu ra, e Iesu a nga kovuni i Nasaret simi enamon leong i Galili, ma a nga por sinusuruiv se Ioanes simi da i Ioridan. ");
INSERT INTO tbf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Duis sien e Iesu ta nga kien beit simi da, a nga pare mi rangit a nga katsep ma mi Moromoruo Tamat a nga peuk i popon malan mi buen. ");
INSERT INTO tbf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma mi ien kuvu simi rangit a nga pevien, “Evoi e natung, o tovie no. Ma o resmata no beitsak.” ");
INSERT INTO tbf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ian ngas te, mi Moromoruo Tamat a nga turan e Iesu rakot simi beir. ");
INSERT INTO tbf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma e Iesu a nga mon simi beir bu ra ba sinangavur voveit ma e Satan a nga konon. A nga mon meie bu vinavinar tso ma bu angelo gi nga perngan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","I murien gi tate nga vurukude e Ioanes simi vona vinatoreis, e Iesu a nga rakot i Galili ma a nga vavatei ngan man Banga Vinavatei e Raban. ");
INSERT INTO tbf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A nga pevien, “A te beit nangba mi keipkepide ra e Raban ta nga vile. Mi ra va e Raban ta vuor a te vatavatat. Nga vodon vuris nge vodovodon tuktuk simi Banga Vinavatei!” ");
INSERT INTO tbf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sien e Iesu ta nga vor ve veisveis i gegen mi barateis i Galili, a nga pare ba baser kasien e Simon ma e Andre guor ta nga tomekan mi ben simi barateis, simi vunan eguor ba ka vongovongon. ");
INSERT INTO tbf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma e Iesu a nga oeng seguor, “Ngado nemei nge vemusurie iou. Ma o ta me veseveie ngado nia vangoda mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ian ngas te, guor nga sorvekenan keguor sar ben ma guor nga vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sien tate buer nga veis rakot i pek lili, e Iesu a nga pare e Iakobo ma e Ioanes, ba natuon e Sebedi, i popon mi galeu guor ta nga name kegi sar ben. ");
INSERT INTO tbf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ian ngas te, a nga kukuo guor ma guor nga sorvekenan e Sebedi e tamaguor i aron mi galeu meie bu petspets nia tsatsang suri lakep. Ma guor nga vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gi nga rakot i Kapernaum. Ma simi Rangi Minaes tate nga beit, e Iesu a nga rubukien simi vona rengeir sibu Iuda ma a nga vakaek nge vavasengei. ");
INSERT INTO tbf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mi kulou gi nga kudier si ken sar vinasengei, simi vunan a nga vavasengei segie malan mi ka ta suvu ngeisngeis, ma a kap nga malan bu vavvasengei sibu vinuor se Moses. ");
INSERT INTO tbf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ian ngas te, i aron kegi vona rengeir, mi ka mi tsaka moromoruo ta nga tsegerie a nga koup leong, ");
INSERT INTO tbf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Misa e lalaro tsana segei, Iesu kovuni i Nasaret? Vasa, e nemei nia me voguersa gei? O telekiran va evoi ese. Evoi ken Ka Tamat e Raban!” ");
INSERT INTO tbf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","E Iesu a nga patsarie, “Bong! Rovotsour sorvekenan ine mi ka!” ");
INSERT INTO tbf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mi tsaka moromoruo a nga tomeke vuturungie nge vedederie ine mi ka ma a nga koup leong nge rovotsour sorvekenan. ");
INSERT INTO tbf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mi kulou gi ta nga mon i aron mi vona rengeir gi nga kudier tsak nge vevuor i kotubugie nge pevien, “Mi sana ine? A vavasengei meie ngan mi ngeisngeis! Ma a terie mi nama ngeisngeis buer sibu tsaka moromoruo ma gi rorong sien.” ");
INSERT INTO tbf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma man vinavatei e Iesu a nga puorkan lalapus te sibu enamon kokouk i Galili. ");
INSERT INTO tbf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Duis sien e Iesu ma ken sar madar tovtov gi tate nga sorvekenan ine mi vona rengeir, gi nga nomeie e Iakobo ma e Ioanes rakot si ken vonuo e Simon ma e Andre. ");
INSERT INTO tbf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ken koko e Simon a nga mutur simi tsur ngan mi mienarouk mi kuirkuir rarap. Ma gi nga pengan se Iesu ine mi vevien. ");
INSERT INTO tbf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Io, e Iesu a nga rakot sien ma a nga por ka i riman nge kulie nia tsuok vogosongie. Io, mi kuirkuir rarap a nga sorvekenan ine mi vevien ma a nga tsang nginonginou niagie. ");
INSERT INTO tbf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sien tate nga reivreiv seserigo, bu mei gi nga kir nemei ngan se Iesu bu tamat mienarouk ma bu mei bu tsaka moromoruo ta nga tsegerie gie. ");
INSERT INTO tbf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bu mei kokouk ian simi taon gi nga beit kouk simi matavanuo. ");
INSERT INTO tbf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma e Iesu a nga vatoa palan segie gi ta nga suvuon bu suasuada mienarouk. Ma buer a nga kareir rivie palan bu tsaka moromoruo, eiekesen a kap nga sunurie bu tsaka moromoruo va gi ta nga vakokoit simi vunan gi nga telekiran va Eie ese. ");
INSERT INTO tbf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Simi to vagoso ador, e Iesu a nga pan tamtuir nge sorvekenan mi vonuo ma a nga rakot simi korot menemenen nge ra no en. ");
INSERT INTO tbf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E Simon ma bu palapalan gi nga veis nge ra nesie. ");
INSERT INTO tbf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma sien gi tate nga ra vorotan, gi nga oeng sien, “Bu mei kokouk gi nesie no!” ");
INSERT INTO tbf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","E Iesu a nga kuil nama, “Giet ta rakot si kavo enamon mene vatavatat, terengien va o ta mang ra vavatei en buer. Arie mi vunan o ta nga nemei.” ");
INSERT INTO tbf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma a nga veis ververiris i Galili kokouk nge vavatei i aron bu vona rengeir sibu Iuda ma a nga kareir rivie bu tsaka moromoruo. ");
INSERT INTO tbf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mi ka ta nga suvuon mi mienarouk lepra a nga nemei se Iesu nge sege pukupukukaek ma a nga no masitinoiv sien. “Sien va e ta sunuir, e ta oit nia vara melemelen nge iou.” ");
INSERT INTO tbf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E Iesu a nga tovie beitsak ma a nga soburo ngan mi riman. Ma a nga pevien ne, “O sunuir, e ta melemelen!” ");
INSERT INTO tbf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ian ngas te mi mienarouk lepra a nga voto ine simi ka ma a nga tsorubeit melemelen. ");
INSERT INTO tbf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ma e Iesu a nga ture vavasie meie ngan mi nama ngeisngeis malan ne, ");
INSERT INTO tbf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kian va e ta so pepengan ine mi kepineits si ka mene. Eiekesen, e ta so rakot nge vasanga no simi prist, ma e ta ra terie mi tienebeir nia vara tuktuk nge no i matan bu mei va e te melemelen, malan e Moses ta nga vokokotie.” ");
INSERT INTO tbf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma ine mi ka a nga veis, eiekesen a nga vakaek nge vavatei ngan misa e Iesu ta nga tsana sien. Surie ine, e Iesu a kap ba nga oit nia rubukien si ka taon i matan mi lobaram. Io, a te nga ko mon mo sibu korot beir. Eiekesen mi kulou kovuni sibu enamon kokouk gi ngas nga ko nemei sien. ");
INSERT INTO tbf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","I murien ba ra mene tate nga rovoriu, sien e Iesu tate buer nga muerengei rakot i Kapernaum, mi kulou gi nga rongovan va e Iesu a te buer nga beit ian en. ");
INSERT INTO tbf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mi bineit a nga palan beitsak ma a kap ba ka kientsep i aron mi vonuo ma i matavanuo buer. Ma a nga vavatei ngan mi namanien e Raban segie. ");
INSERT INTO tbf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ba ka voveit gituo nga sorokie mi muru nge nemei ngan se Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eiekesen gituo kap nga oit nia sor terie ine mi muru rakot se Iesu, surie mi bineit. Io, gituo nga tseperie mi mat i pungan mi vonuo duis ivie e Iesu ta nga tuir en. I murien gituo ta nga tseperie mi mat, gituo nga vunurie mi tsur mi muru ta nga mutur i popon. ");
INSERT INTO tbf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sien e Iesu ta nga pare kegituo vodovodon tuktuk, a nga oeng simi muru, “Natung, o te vodon rivie ke sar sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bu vavvasengei sibu vinuor se Moses buer gi nga mogos ian en. Ma gi nga vukulik nge kia, ");
INSERT INTO tbf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Surie misa ine mi ka ta vakokoit malan ine? A oeng balapoik ngan e Raban! Kap ka mei a oit nia vodon rivie bu sinavei tsokor, eiekesen e Raban kesen mo a oit.” ");
INSERT INTO tbf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ian ngas te, e Iesu a nga telekiran simi Morumoruan misa gi nga vodonomie sibu arogie. Ma a nga oeng segie, “Surie misa nga ta suvuon ine bu suada vienviendon? ");
INSERT INTO tbf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mi sana nama a molous nia vokokotie ine simi muru? ‘Ke sar sinavei tsokor o te vodon rivie.’ o, ‘Tsik tamtuir nge poro ke tsur nge veis.’? ");
INSERT INTO tbf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Io, o ta vakatsepa senga va e Natuon mi Ka a suvuon mi duis i popon mi kaber nia vodon rivie bu sinavei tsokor.” E Iesu a nga oeng simi muru, ");
INSERT INTO tbf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O oeng sevoi. Tsik tamtuir. Sorokie ke tsur nge rakot si ke enamon.” ");
INSERT INTO tbf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ine mi muru a nga tamtuir ian ngas te nge sorokie ken tsur ma a nga veis rovotsour i matagie kokouk. Io, gi nga kudier beitsak ma gi nga puongan e Raban nge pevien, “Gei kap ngas nga pare ka kepineits malan ine!” ");
INSERT INTO tbf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E Iesu a te buer nga veis rakot i gegen mi barateis i Galili. Mi bineit leong gi nga nemei sien, ma a nga vakaek nge vavasengei segie. ");
INSERT INTO tbf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sien ta nga vor ve veisveis, a nga pare e Levi e natuon e Alpeo ta nga mogos simi vona porpor takis. E Iesu a nga oeng sien, “Vemusurie iou.” Ma e Levi a nga tamtuir nge vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sien e Iesu ta nga ngou si ken vonuo e Levi, palan bu ka porpor takis ma bu ka tsokor gi nga ngou meie ma ken sar madar tovtov. Io, palan bu suada mei malagie gi nga vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sien bu vavvasengei simi Vinuor ese bu meinmenigie bu Parisaio gi ta nga pare e Iesu ta nga ngou meie bu ka tsokor ma bu ka porpor takis, gi nga vereie ken sar madar tovtov, “Surie misa eie ta ngou nge un meie bu ka porpor takis ma mi kulou tsokor?” ");
INSERT INTO tbf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sien e Iesu ta nga rongomie ine, a nga oeng segie, “Kap va egie gi ta tino kalei gi pinat surie ka porpor oiv, eiekesen egie gi ta morouk. O kap nga nemei surie gie mi kulou duis i matan e Raban, eiekesen o nga nemei surie egie mi kulou tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Io, ken sar madar tovtov e Ioanes ma bu Parisaio gi nga ko vorvor. Bu mei gi nga nemei nge vosuoreie e Iesu, “Surie misa bu madar tovtov se Ioanes ma sibu Parisaio gi ko vorvor, eiekesen ke sar madar tovtov gi kap ko vorvor?” ");
INSERT INTO tbf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","E Iesu a nga kuil nama, “Vasa, a oit va bu vasier simi nginou ni verei, gi ta vorvor sien mi ka rei vour ta ngas mon meie gie? A kap, gi ta kap oit nia vorvor sien va mi ka rei vour a ngas mon meie gie. ");
INSERT INTO tbf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Eiekesen mi ra ta beit va ine mi ka rei vour, gi ta kir tsana segie, ma ian simi ra gi ta nangba so vorvor. ");
INSERT INTO tbf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kap ka mei a ko dekitie terie ka poko lavlav vour ta kap ngas suok, si ka lavlav kebeir. Sien va ta tsana malan, mi poko lavlav vour ta suok ma ta katsaep sorvekenan ine mi lavlav kebeir ma ta tsana mi kadeir ta leong. ");
INSERT INTO tbf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma kap ka mei a ko soe teir dangi vain vour i aron bu utut kebeir gi ta tsana nge piripiri vinavinar. Sien va ta tsana malan, mi dangi vain vour ta tsana bu utut kebeir va gi ta puor kapot, ma mi dangi vain meie bu utut kebeir egie kokouk gie ta tsak. Eiekesen eie ta soe teir dangi vain vour i aron bu utut vour gi ta tsana ngan mi piripiri vinavinar.” ");
INSERT INTO tbf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Simi Rangi Minaes, e Iesu meie ken sar madar tovtov gi nga veis ka i aron bu tau wit. Ma ken sar madar tovtov gi nga do tsana bu kievkiev wit. ");
INSERT INTO tbf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma bu Parisaio gi nga oeng se Iesu, “Pare, surie misa gi ta tsana mi sinavei ian ta kap vemusurie man vinuor mi Rangi Minaes?” ");
INSERT INTO tbf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","E Iesu a nga kuil nama, “Vasa, nga kap ngas nga ase misa e Davit a nga tsana sien eie ma bu palapalan gi ta nga vitor nge suvu pinat? ");
INSERT INTO tbf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sibu ra e Abiata ta nga kovan bu prist, e Davit a nga rubukien si ken vonuo e Raban ma a nga nganie mi tsoik tamat ian mi Vinuor a kap sunuir va ka mei mene gi ta nganie eiekesen bu prist mo. E Davit a nga tabarie ngan buer bu palapalan.” ");
INSERT INTO tbf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Samo, e Iesu a nga oeng segie, “Mi Rangi Minaes e Raban a nga tsana nian ken kalekalei mi ka, kap va mi ka nian mi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Io, e Natuon mi Ka, eie buer man Nguts mi Rangi Minaes.” ");
INSERT INTO tbf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Simi ra mene te buer, e Iesu a nga rubukien simi vona rengeir sibu Iuda ma mi ka riem maet a nga mon ian en. ");
INSERT INTO tbf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bu Parisaio gi nga moun ngan nia telekiran va ta nga vatoa ine mi ka riem maet simi Rangi Minaes, terengien va gi ta mang nga vepitsie. ");
INSERT INTO tbf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","E Iesu a nga oeng simi ka riem maet, “Tamtuir nge me tuir i matan mi lobaram.” ");
INSERT INTO tbf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Samo e Iesu a nga vereie gie, “Mi sana a duis i matan mi vinuor nia tsana simi Rangi Minaes? Nia tsana mi kienelei o, nia tsana mi tsienakor? Nia vatoa mi tino o, nia kenvamate?” Eiekesen gi nga bong mo. ");
INSERT INTO tbf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E Iesu a nga dedeng petseir veie gie, ma a nga aor putu beitsak surie kegi aor papan, ma a nga oeng ian simi ka, “Kadosan mi rima.” A nga kadosan mi riman ma a te buer nga kalei ruruvei. ");
INSERT INTO tbf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Samo bu Parisaio gi nga rovotsour ma gi nga vakaek nge roev meie mi gargar se Erot nian e Iesu va vasa gi ta nga kenvamate venengan. ");
INSERT INTO tbf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","E Iesu ma ken sar madar tovtov gi nga veis peuk i gege da ma ine mi bineit leong kovuni i Galili gi nga vemusurie gie. ");
INSERT INTO tbf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Sien gi ta nga rongovan bu kepineits kokouk e Iesu ta nga tsana, bu mei palan gi nga nemei sien kovuni i Iudea, a, i Ierusalem, a, i Idumea ma sibu enamon ka nikot i Ioridan ma veriris i Turos ma i Sidon. ");
INSERT INTO tbf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Surie ine mi bineit, e Iesu a nga oeng si ken sar madar tovtov va gi ta nga rorois ngan ka galeu, simi vunan a nga lalaro tuir kitipan mi bineit va gi ta masi nga vususungie. ");
INSERT INTO tbf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Simi vunan e Iesu a te nga vatoa palan bu tamat mienarouk, bu tamat mienarouk gi nga sikei rakot seie nia tobelie. ");
INSERT INTO tbf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sibu keipkepide ra kokouk bu tsaka moromoruo gi ta nga pare e Iesu, gi nga ko kor mutur i matan ma gi nga koupkoup, “Evoi e Natuon e Raban!” ");
INSERT INTO tbf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eiekesen e Iesu a nga vengeng vangvangasie gie va gi ta kap nga pepengan va eie ese. ");
INSERT INTO tbf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","E Iesu a nga veis kien simi pout ma a nga kuk nemei ngan egie ese ta nga lalaro gie, ma gi nga nemei sien. ");
INSERT INTO tbf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Samo a nga totok telekiran mi sinangavur kes ma luo bu ka. Ma a nga vuotongie gie va bu aposol. A nga oeng segie, “O vile nga va nga ta mon meie iou. O ta ba tura nga nia ra vavatei. ");
INSERT INTO tbf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma buer nga ta suvuon mi ngeisngeis nia kareir rivie bu tsaka moromoruo.” ");
INSERT INTO tbf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ine arie mi sinangavur kes ma luo bu ka ta nga totok telekiran; e Simon (ese e Iesu ta nga tutuo ngan mi as Petro), ");
INSERT INTO tbf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e Iakobo ma e Ioanes ba natuon e Sebedi (seguor ine a nga tutuo nge guor mi as Boaneges, man vuevue ine mi as va eguor ba natuon mi tengteng), ");
INSERT INTO tbf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","e Andre, e Pilipo, e Bartolomeu, e Mataio, e Tomas, e Iakobo e natuon e Alpeo, e Tadaios, e Simon mi Silot, ");
INSERT INTO tbf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma e Iudas Iskariot ese ta nga murien veie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Samo e Iesu a nga rubukien simi vonuo ma mi bineit gi te buer nga oir kouk. Surie ine, eie ma ken sar madar tovtov gi kap ba nga oit nia ngou. ");
INSERT INTO tbf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sien e kinan ma bu kasien ma bu vevinen gi ta nga rongovan ine, gi nga nemei nia vangenge, simi vunan bu mei gi nga pevien, “Eie a te be.” ");
INSERT INTO tbf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma bu vavvasengei sibu vinuor se Moses ese mune gi ta nga kovuni i Ierusalem gi nga pevien ne, “E Belsebul a tsegerie! A kareir vorotsoruo bu tsaka moromoruo ngan mi ngesengesien mi kovan bu tsaka moromoruo.” ");
INSERT INTO tbf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Io, e Iesu a nga kukuo gie ma a nga vakokoit segie ngan bu nama puppuo, “Vasa e Satan ta oit nia kareir rivie venengan e Satan? ");
INSERT INTO tbf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sien va ka mangmagoso nguts ta potakie eie kesen, ine mi mangmagoso nguts ta kap oit nia tuir. ");
INSERT INTO tbf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sien va ka tietie ta potakie eie kesen, ine mi tietie ta kap oit nia tuir. ");
INSERT INTO tbf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma sien va e Satan ta veveken meie eie kesen ma ta potakie eie kesen, a kap oit va ta tuir, man votovoto a te beit. ");
INSERT INTO tbf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A tuktuk, kap ka mei a oit nia rubukien si ken vonuo ka ka per nge sor vingan ken sar kepineits. Eie ta ngas muna visie ine mi ka per. Samo, ta ba oit nia pure bu kepineits si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","O oeng tuktuk senga. Bu sinavei tsokor ma bu oengoeng balapoik simi kulou, e Raban ta vodon rivie, ");
INSERT INTO tbf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","eiekesen eie ese ta oeng balapoik ngan mi Moromoruo Tamat, e Raban ta kap oit nia vodon rivie. Eie a tsana mi sinavei tsokor kap man ka votovoto.” ");
INSERT INTO tbf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","E Iesu a nga vakokoit ven ne simi vunan gi nga pevien, “Eie a suvuon mi tsaka moromoruo.” ");
INSERT INTO tbf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Samo e kinan ma bu kasien e Iesu gi nga beit. Gi nga tuir i marar, ma gi nga turan mi mei mene va ta nga ra kukuo. ");
INSERT INTO tbf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mi bineit gi nga mogos viriviririsie e Iesu ma gi nga oeng sien, “E kina ma bu kasi gi mon i marar ma gi nesie no.” ");
INSERT INTO tbf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A nga virei, “Ese e kinoung ma bu kasiung?” ");
INSERT INTO tbf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Samo, a nga dengarie gie ese gi ta nga mogos viririsie ma a nga pevien, “Ine arie egie e kinoung ma bu kasiung! ");
INSERT INTO tbf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eie ese ta vemusurie ken lalaron e Raban, arie eie e kasiung ma e vevineung ma e kinoung.” ");
INSERT INTO tbf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Io, e Iesu a te buer nga vavasengei i gegen mi barateis i Galili. Mi bineit ian gi ta nga beit viririsie a nga palan beitsak. Io, e Iesu a nga ka simi galeu nge mogos i popon. Mi galeu a nga mogos i rou ma mi bineit gi nga tuir i koen. ");
INSERT INTO tbf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A nga vavasengei segie ngan bu kepineits palan ngan bu nama puppuo. Ma si ken vinasengei a nga pevien ne, ");
INSERT INTO tbf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nga rorong! Mi ka tsuotstsuor a nga ra rivie ken sar pi ei. ");
INSERT INTO tbf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sien ta nga rivie bu pi ei, bu pi ei mene gi nga kor simi baiveisveis. Ma bu ma gi nga nemei nge nganie gie. ");
INSERT INTO tbf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bu pi ei mene gi nga kor i popon mi popopeliets ivie mi pier a kap nga leong en. Ine bu pi ei gi nga tsutsuleik lalapus, simi vunan mi pier a nga lili mo. ");
INSERT INTO tbf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Eiekesen sien mi matanias ta nga par, bu ei tsuotstsuor gi nga bileits nge bukuk, simi vunan a kap kavo uvigie. ");
INSERT INTO tbf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bu pei mene gi nga kor i kinorotuon bu suo tsotso. Ine bu suo tsotso gi nga to leong ma gi nga pipitsie bu ei tsuotstsuor. Io, gi kap ba nga oit nia vua nge vuovuo. ");
INSERT INTO tbf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bu pei mene gi nga kor simi banga pier. Gi nga tsutsuleik rovotsour nge to leong ma gi nga vua nge vuovuo. Bu mene keskes gi nga vua nge vuovuo a oit ba sinangavur tour, bu mene a oit bu sinangavur mi napaririem potsu kes, ma bu mene a oit mi sinangavur kes koboit (100) rio misa gi ta nga tsuorkie.” ");
INSERT INTO tbf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Samo e Iesu a nga pevien, “Eie ese ta suvu taterieng nia rorong, ta ngas rorong.” ");
INSERT INTO tbf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sien e Iesu ta nga mon kesen, mi sinangavur kes ma luo bu madar tovtov ma bu mei mene gi nga nemei sien ma gi nga vosuoreie ngan mi vunan ine ken nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","E Iesu a nga oeng segie ven ne, “E Raban a te nga terie senga mi sinavei nia telekiran bu kepineits mumuningei surie ken mangmagoso Nguts e Raban. Eiekesen bu kepineits kokouk o vokokotie sibu nama puppuo segie ian kap va kong kulou. ");
INSERT INTO tbf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Terengien, “‘Gi ta dedeng nge dedeng, eiekesen gi ta kap dedeng kilal ma gi ta rorong nge rorong, eiekesen gi ta kap rong telekiran. Sien va a kap malan ian, va gi mang vurisan bu arogie, ma e Raban a mang vodon rivie kegi sar sinavei tsokor!’” ");
INSERT INTO tbf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Samo e Iesu a nga oeng segie, “Vasa, nga kap katsep ine simi nama puppuo? Sien va nga ta kap katsep, vasa nga ta oit nia katsep ven si ka nama puppuo mene? ");
INSERT INTO tbf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mi ka tsuotstsuor a tsuorkie ken nama e Raban. ");
INSERT INTO tbf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bu pei gi ta kor simi baiveisveis arie egie ese gi ta rongomie mi nama ma i murien ine, e Satan a nemei ma a me tsang rivie ine mi nama gi ta nga tsuorkie i arogie. ");
INSERT INTO tbf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bu pei gi ta nga kor i popon mi popopeliets arie egie ese gi ta rongomie mi nama ma ian ngas te, gi poro ngan mi nires. ");
INSERT INTO tbf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Eiekesen, gi to lili mo, a, gi maet simi vunan a kap ka uvigie. Sien va ka tsienakor o, kavo vinekikin va ta beit surie ine mi nama, gi ta kor lalapus mo. ");
INSERT INTO tbf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bu pei gi ta kor i kotubuon bu suo tsotso arie egie ese gi tate nga rongomie mi nama. ");
INSERT INTO tbf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Eiekesen, man sar aor tsak ine mi tino, ma bu lalaron nia suvuram, ma bu lalaron nia suvuon bu suasuada kepineits, gi rubukien, ma gi pipitsie ine mi nama nge tsana va ta kap vua. ");
INSERT INTO tbf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bu pei gi ta kor i popon mi banga pier arie egie ese gi ta rongomie ine mi nama nge suvuon si kegi tino. Ma gi vua nge vuovuo. Bu mene keskes gi nga vua nge vuovuo a nga oit ba sinangavur tour, bu mene a nga oit bu sinangavur mi napaririem potsu kes, ma bu mene a nga oit mi sinangavur kes koboit (100) rio misa gi ta nga tsuorkie.” ");
INSERT INTO tbf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","E Iesu a nga oeng segie, “Vasa, nga ko poro mi bember nge terie i pakien mi utut o, mi tsur? A kap, nga ko terie i popon man mogomogos. ");
INSERT INTO tbf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mi sana kepineits ta mumuningei ta tsorubeit simi taparang ma mi sana kepineits ta kokoiv ta tsorubeit vasvas. ");
INSERT INTO tbf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sien va ka mene a suvu taterieng nia rorong, ta rorong.” ");
INSERT INTO tbf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A nga pevien buer, “Vodon surie misa nga ta rongomie. E Raban ta pua nga ngan mi puppuo nga ta puangan bu mei mene, eiekesen ta terie te buer ta leong i popon vunie nga. ");
INSERT INTO tbf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Segie ese gi ta tor surie kong sar vinasengei, e Raban ta buer veleongtie kegi sar sinavei. Ma segie ese gi ta kap suvu sinavei, misasien va kegi puk sinavei ta lili mo, e Raban ta por tsana segie.” ");
INSERT INTO tbf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","E Iesu a te buer nga pevien, “Ken sinavei e Raban nia vuor, a malan ne. Mi ka a nga riv pi ei i popon mi pier. ");
INSERT INTO tbf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma a nga muang sibu rokati nge pan sibu rosisiat ma mi pi ei a nga papak nge to leong veisveis. Eiekesen ine mi ka a kap telekiran vasa a nga to ven. ");
INSERT INTO tbf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mi pier kesen a tsana ine mi pei va ta to leong nge vua ven ne, ‘vourvour mi aien, samo mi kievkiev, ma samo bu vuovuo die i aron’. ");
INSERT INTO tbf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sien va mi kievkiev va tate komois, ta lem tsana ngan mi sele, simi vunan mi ra nia kakarie mi tau a te beit.” ");
INSERT INTO tbf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E Iesu a te buer nga pevien, “Mi sana kepineits giet ta oit nia pua ngan mi sinavien e Raban nia vuor va a malan, o, mi sana nama puppuo giet ta oit nia vokokotie nia pua ngan? ");
INSERT INTO tbf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mi sinavien e Raban nia vuor a malan mi pi mastat. Ine mi pi mastat a lili beitsak sibu pi ei kokouk gi ta tsuorkie simi pier. ");
INSERT INTO tbf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eiekesen, sien va gi ta tsuorkie, ta to ma ta leong rio bu tsientsuor kokouk i tau. Ma buer bu ma gi ta oit nia tsana magi sar tou simi minoruvien bu rakarakan leong.” ");
INSERT INTO tbf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ngan bu nama puppuo palan malan ine, e Iesu a nga vasangan segie ngan bu kepineits palan gi ta nga oit nia katsep sien. ");
INSERT INTO tbf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","E Iesu a nga ko vavasengei segie ngan mo bu nama puppuo. Eiekesen, sien va ta nga mon kesen meie ken sar madar tovtov a nangba nga ko palsie man vuevue bu nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sien tate nga reivreiv seserigo ian simi ra, a nga oeng si ken sar madar tovtov, “Giet ta rakot simi bienangaev ka nikot.” ");
INSERT INTO tbf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Io, gi nga sorvekenan mi bineit ma gi nga tsuk ngan mi galeu e Iesu tate nga ka sien. Bu galeu mene buer gi nga soer kokouk meie. ");
INSERT INTO tbf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Samo mi lon a te nga tamtuir, ma bu naov gi nga vakaek nge kopo vovoi simi galeu, ma a te nga vatvatta luluis. ");
INSERT INTO tbf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","E Iesu a nga kuraeng ngan mi kurakuraeng ma a nga muang i taven mi galeu. Bu madar tovtov gi nga vapada nge oeng sien, “Vavvasengei, a kap putu si ke vienviendon sien va giet ta luluis?” ");
INSERT INTO tbf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Io, a nga tsik tamtuir nge oeng ngeisngeis simi mour ma bu peiv, “Bong nge tiko!” Io, mi mour a nga kor girir ma a nga tiko rovoriu. ");
INSERT INTO tbf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A nga oeng si ken sar madar tovtov, “Surie misa nga ta motou? Vasa, nga kap ngas suvu vodovodon tuktuk?” ");
INSERT INTO tbf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Gi nga motou beitsak ma gi nga vevirei nge gie keskes, “Ese ine? Misasien buer mi mour ma bu peiv gi rorong sien!” ");
INSERT INTO tbf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gi nga soer kitipie mi barateis i Galili rakot simi korot leong i Gerasa. ");
INSERT INTO tbf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sien e Iesu tate nga tsour simi galeu, a nga suoeie mi ka ta nga rovotsour kovuni sibu rie puppuon. Ine mi ka mi tsaka moromoruo a nga tsegerie. ");
INSERT INTO tbf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma a nga ko mon i kotubuon bu monmon ma kap ka mene a ba nga oit nia rakopie nge visie, misasien bu tsen. ");
INSERT INTO tbf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Palan bu ra gi nga ko visie ba riman ma ba kamen, eiekesen a nga ko motukie bu tsen ma bu baivinis aen siba kamen. Kap ka mene a nga ngeisngeis oit nia tseiptseiprio. ");
INSERT INTO tbf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sibu rokati ma rosisiat, i kotubuon bu monmon ma i popon bu kuitskuits ine mi ka a nga ko koup kuar nge tava eie kesen ngan bu poko vunavout. ");
INSERT INTO tbf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sien ta nga pare e Iesu i pek lili ngas te, a nga soer rakot sien ma a nga sege pukupukukaek i matan. ");
INSERT INTO tbf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma ine mi ka a nga koup leong, “Iesu, Natuon e Raban ese ta tsiroup! Ke sana baitutuir meie iou? O nongie no simi asan e Raban va e ta kap votorosie iou!” ");
INSERT INTO tbf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A nga koup ven ne, simi vunan e Iesu a te nga oeng sien, “Moromoruo tsak! Rovotsour sorvekenan ine mi ka.” ");
INSERT INTO tbf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Samo e Iesu a nga vosuoreie, “Ese mi asa?” A nga kuil nama, “Mi asoung e Gargarleong, simi vunan gei palan.” ");
INSERT INTO tbf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma a nga vor ve nono masitinoiv se Iesu va ta kap nga matokera gie ian simi korot. ");
INSERT INTO tbf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mi varin bor leong gi nga vivieir simi kuitskuits vatavatat. ");
INSERT INTO tbf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bu tsaka moromoruo gi nga no masitinoiv se Iesu, “Tura gei rakot i kotubugie bu bor va gei ta mang rubukien segie.” ");
INSERT INTO tbf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","E Iesu a nga tor, ma bu tsaka moromoruo gi nga rovotsour ma gi nga rubukien sibu bor. Mi varin bor, mi aesaes sien a nga vatvatta ba sinangavur luo soloba (2,000), gi nga soer peuk simi malamala tsetseir nge tsibour i rou, ma gi nga kong maet. ");
INSERT INTO tbf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bu ka gi ta nga naneie bu bor, gi nga vi nge ra vavatei ngan ine mi kepineits i aron bu taon ma bu enamon i uot i Gerasa. Ma mi kulou gi nga rakot nge ra pare mi sana kepineits ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sien gi ta nga me beit se Iesu, gi nga pare ine mi ka bu tsaka moromoruo gi ta be nga tsegerie ta nga mogos, ma a te nga lavlav nge suvu banga vienviendon. Ma egie kokouk gi nga motou. ");
INSERT INTO tbf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Egie ese gi ta nga me pare ine mi kepineits, gi nga potsukie simi kulou mi sana kepineits ta nga tsorubeit ine simi ka bu tsaka moromoruo gi ta be nga tsegerie ma buer misa ta nga tsorubeit sibu bor. ");
INSERT INTO tbf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Surie ine, mi kulou gi nga vakaek nge nongie e Iesu nia sorvekenan kegi enamon. ");
INSERT INTO tbf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sien e Iesu tate nga visi ka simi galeu, ine mi ka bu tsaka moromoruo gi ta be nga tsegerie, a nga nongie e Iesu va ta nga nomeie. ");
INSERT INTO tbf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","E Iesu a kap nga tor ngan, eiekesen a nga oeng sien, “Muerengei rakot sibu patsa nge vateie gie ngan mi sana kepineits mi Nguts tate nga tsana sevoi ma vasa a nga toiv venenga no.” ");
INSERT INTO tbf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Io, ine mi ka a nga veis rakot i Dekapolis ma a nga vakaek nge vavatei ngan bu sana kepineits e Iesu ta nga tsana sien. Ma mi kulou kokouk gi nga kudier tsak. ");
INSERT INTO tbf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E Iesu a te buer nga tsourarak nge galeu rakot simi bienengeiv ka nikot simi barateis. Sien tate nga so mon i koen, mi bineit leong gi nga beit viririsie. ");
INSERT INTO tbf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Samo e Iairo mi muomuo simi vona rengeir sibu Iuda a nga beit en ian. Sien ta nga pare e Iesu, a nga sege pukupukukaek i matan. ");
INSERT INTO tbf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma a nga no masitinoiv ngeisngeis sien, “E natung vevien lili a te vatvatta mesei. O nongie no va e ta nemei nge me soburo, terengien va ta mang ketseketseng si man mienarouk ma ta to.” ");
INSERT INTO tbf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Io, e Iesu a nga nomeie. Mi bineit leong gi nga vemusurie ma gi nga bubutit viririsie. ");
INSERT INTO tbf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma mi vevien a nga mon ian en buer ese ta nga suvuon mi mienarouk nia kavakava mi dar sibu avareit mi sinangavur kes ma luo. ");
INSERT INTO tbf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A nga ko rongmetsikien mi vinavasor leong. Palan bu porpor oiv gi te nga pilang nia vatoa si man mienarouk. Io, a te nga vaton ken sar lakep, eiekesen man mienarouk a kap nga voto mo ma a si nga vor ve tsotsorubeit leong. ");
INSERT INTO tbf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sien ta nga rongovan e Iesu, a nga veis nemei ka i murien e Iesu i kotubuon mi bineit. Ma a nga tobelie ken lavlav e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Simi vunan, a nga vodon ven ne, “Sien va o ta tobelie ken lavlav, ta voto mong mienarouk.” ");
INSERT INTO tbf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ian ngas te, a kap nga kava te mi dar ma a nga rongmetsikien simi kurikurien va a te nga ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ian ngas te, e Iesu a nga telekiran va mi ngeisngeis a nga tsour sorvekenan. E Iesu a nga tuir vuris ma a nga virei, “Ese a tobelie kong lavlav?” ");
INSERT INTO tbf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ken sar madar tovtov gi nga kuil nama sien, “E pare mi bineit ine gi ta viririsie no. Surie misa e ta virei va ese a tobelie no?” ");
INSERT INTO tbf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eiekesen e Iesu a ngas nga vor ve dendeng veriris nia pare ian mi vevien ese ta nga tobelie. ");
INSERT INTO tbf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Samo ine mi vevien ta nga tobelie a nga telekiran mi sana kepineits ta nga tsorubeit sien. A nga nemei nge me sege pukupukukaek i kamen ma a nga dedeir ngan mi mientou nge pengan se Iesu mi tuktuk. ");
INSERT INTO tbf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","E Iesu a nga oeng sien, “Natung, ke vodovodon tuktuk a te vatoa no si ma mienarouk. Veis ngan mi molu. E te ketseketseng si ke sar vinavasor.” ");
INSERT INTO tbf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sien e Iesu ta ngas nga vor ve vakvakokoit, bu mei gi nga kovuni si ken vonuo e Iairo, mi muomuo simi vona rengeir sibu Iuda. Ma gi nga pevien, “E natu vevien a te maet. Kian va e tate buer vobusie mi vavvasengei.” ");
INSERT INTO tbf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","E Iesu a nga vodon sasavoir ngan misa gi ta nga pengan ma a nga oeng se Iairo, “Kian va e ta aor tsak, vodovodon tuktuk mo.” ");
INSERT INTO tbf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E Iesu a kap nga tor ngan ka mei mene va ta nga vemusurie, eiekesen mo e Petro, a, e Iakobo, ma e Ioanes e kasien e Iakobo. ");
INSERT INTO tbf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sien gi tate nga beit si ken vonuo ian mi muomuo simi vona rengeir, a nga dengarie mi vegululo ma bu mei gi ta nga ta masitinoiv nge ta koupkoup. ");
INSERT INTO tbf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A nga rubukien ma a nga oeng segie, “Nia sa ine bu vegululo ma mi tina? Mi tetsikevien a kap maet, eiekesen a muang mo.” ");
INSERT INTO tbf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eiekesen gi si nga vavangiets ngan. I murien tate nga ture vorotsoruo gie kokouk, e Iesu a nga kerie e taman ma e kinan ine mi tetsikevien ma ba madar tovtov ian gituo ta nga nomeie. Ma gi te nga rubukien simi korot ivie ine mi tetsikevien ta nga mutur en. ");
INSERT INTO tbf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E Iesu a nga popor i riman ine mi tetsikevien ma a nga oeng sien, “Talita koum!” (man vuevue va, “Tetsikevien, o oeng sevoi, tamtuir!”.) ");
INSERT INTO tbf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ian ngas te, ine mi tetsikevien a nga tamtuir nge veisveis. A te nga sinangavur kes ma luo ken sar avareit. Surie ine mi kepineits, gi nga kudier beitsak. ");
INSERT INTO tbf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","E Iesu a nga vengeng vangvangasie gie va gi ta kap nga pepengan sibu mei mene, ma a nga oeng segie va gi ta nga tabarie ine mi tetsikevien. ");
INSERT INTO tbf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E Iesu a nga veis sorvekenan en ne ma a nga rakot si ken enamon i Nasaret ma ken sar madar tovtov gi nga nomeie. ");
INSERT INTO tbf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sien mi Rangi Minaes tate nga beit, a nga vakaek nge vavasengei simi vona rengeir sibu Iuda ma palan bu mei gi ta nga rongomie gi nga kudier. Gi nga vevirei nge gie, “Ivie ine mi ka a nga tserie en ine bu kepineits? Mi sana banga vienviendon a te suvuon va ta tsana buer bu kepineits ni vovokudier? ");
INSERT INTO tbf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Giet si kia va eie mo mi ka tsangtsang vonuo ma e natuon e Maria, ma bu kasien, e Iakobo, e Ioses, e Iudas ma e Simon. Bu vevinen gi mon ine meie giet.” Ma gi nga mekitsan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E Iesu a nga oeng segie, “Mi propet a suvu minangarei sibu enamon mene, eiekesen si ken enamon, ma sibu patsan, ma si ken vonuo, a kap.” ");
INSERT INTO tbf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E Iesu a kap nga oit nia tsana ka kepineits ni vovokudier en ne, eiekesen a nga teir riem i popon ba tamat mienarouk mo ma a nga vatoa gie. ");
INSERT INTO tbf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma a nga nak nge gie sien gi ta kap nga vodovodon tuktuk. Samo, e Iesu a nga veis rakot sibu enamon ververiris en ne ma a nga vavasengei simi kulou. ");
INSERT INTO tbf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A nga kukuo mi sinangavur kes ma luo ken sar madar tovtov, ma a nga ture luoluo nge gie. Ma a nga teir ngeisngeis segie nia kareir rivie bu tsaka moromoruo. ");
INSERT INTO tbf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ine, arie ken sar nama vavakatsep. “Kian va nga ta poro ka kepineits nian mi vineis, eiekesen mi vaong mo. Kian va nga ta poro ka tsoik, lapa, ma lakep meie nga. ");
INSERT INTO tbf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tseik poppop sibu kamenga, eiekesen kian va nga ta por vevveleis. ");
INSERT INTO tbf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sien va nga ta rubukien si ka vonuo, mon ian en oit va nga ta sorvekenan ine mi enamon. ");
INSERT INTO tbf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma sien va ka enamon ta kap resmata nga o, rorong senga, titikan mi puit sibu kamenga nge sorvekena gie. Ine arie mi kepineits nia vasangan segie va e Raban ta votorosie gie.” ");
INSERT INTO tbf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gi nga veis ma gi nga vavatei simi kulou va gi ta ngas nga vodon vuris. ");
INSERT INTO tbf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gi nga kareir rivie palan bu tsaka moromoruo, ma gi nga soe oel sibu tamat mienarouk palan nge vatoa gie. ");
INSERT INTO tbf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E Erot, mi kovakova ka leong simi enamon i Galili, a nga rongovan ine bu kepineits surie e Iesu, simi vunan mi asan e Iesu a te nga rorongovei. Bu mei gi nga pevien, “E Ioanes mi ka ni sinusuruiv a te buer to muerengei simi miensei, ma arie mi vunan ine, a suvuon ine bu ngeisngeis nia tsana bu kepineits ni vovokudier.” ");
INSERT INTO tbf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bu mei mene gi nga pevien, “Eie e Eliia.” Ma bu mei mene ngas buer gi nga pevien, “Eie mi propet, malan mi meinmenigie bu propet muomuo ngas te.” ");
INSERT INTO tbf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eiekesen, sien e Erot ta nga rongovan ine, a nga vor ve pepevien, “Eie e Ioanes o ta nga kitip tsana mi kovan, a te to muerengei!” ");
INSERT INTO tbf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","E Erot a nga vakokoit ven ne, simi vunan eie ngas te a nga tuturei va gi ta nga rakopie e Ioanes nge terie simi vona vinatoreis. A nga tsana malan ine surie e Erodias ese ta be nga muna reie e Pilipo, e kasien. Eiekesen e Erot a te buer nga reie ine mi vevien. ");
INSERT INTO tbf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","E Ioanes a nga ko munu oeng matan e Erot ven ne, “A kap duis sevoi va e ta reie ken vevien e kasi.” ");
INSERT INTO tbf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Surie ine, e Erodias a nga karto e Ioanes ma a nga lalaro kenvamate. Eiekesen a kap nga oit nia keda, ");
INSERT INTO tbf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","simi vunan e Erot a nga motovan e Ioanes ma a nga ko tuir kitipan va e Erodias ta masi nga kenvamate e Ioanes, surie a nga telekiran va e Ioanes eie mi ka ese mi sinavien a nga tamat, ma a nga naneie vakalaie e Ioanes. Sien e Erot ta nga rongomie e Ioanes, a nga mangmangarien bu namanien, eiekesen a ngas nga ko lalaro rorong sien. ");
INSERT INTO tbf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Simi rangi barabaramatan ken kienakav e Erot, e Erodias a nangba nga suvuon mi kientsep nia keda e Ioanes. Ian simi ra e Erot a nga tsana mi nginou leong nian ken sar kovakova ka i pakien ken vinuor ma bu muomuo leong simi kulou ni minakiur ma bu muomuo i Galili. ");
INSERT INTO tbf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sien e natuon vevien e Erodias ta nga rubukien nge me sieng, a nga varese e Erot ma ken sar vasier. Mi kovakova ka leong a nga oeng simi tosuor, “Nongie ka sana kepineits e ta lalaron seou ma o ta terie sevoi.” ");
INSERT INTO tbf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma a nga kukubuits ngan mi vakavakariem, “Mi sana kepineits e ta nongie iou, o ta terie sevoi, misasien va mi kapien buer si kong mangmagoso nguts.” ");
INSERT INTO tbf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ine mi tosuor a nga veis rovotsour ma a nga ra vereie e kinan, “Mi sana kepineits o ta virei ngan?” E kinan a nga kuil nama, “Mi kovan e Ioanes mi ka ni sinusuruiv.” ");
INSERT INTO tbf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ian ngas te, ine mi tosuor a nga lalapus rakot simi kovakova ka leong meie ngan ken lalaron nge pevien, “O lalaron va e ta terie seou mi kovan e Ioanes mi ka ni sinusuruiv i aron ka leisleis ine ngas te.” ");
INSERT INTO tbf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mi kovakova ka leong a nga aor tsak beitsak, eiekesen surie ken vakavakariem ma ken sar vasier gi te nga rongomie ken vakavakariem, a kap ba nga lalaro vuvurisei sien. ");
INSERT INTO tbf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Io, ian ngas te, a nga turan mi ka simi minakiur ngan mi tinuturei nia por nemei ngan mi kovan e Ioanes. Ine mi ka a nga rakot nge ra kitip tsana mi kovan e Ioanes i aron mi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ma a nga por muerngan mi kovan i aron mi leisleis nge ra vetserie ine simi tosuor, ma a nga sor rakot ngan se kinan. ");
INSERT INTO tbf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sien ken sar madar tovtov e Ioanes gi ta nga rongovan ine, gi nga nemei nge me poro mi piripirien ma gi nga ra puonongie. ");
INSERT INTO tbf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bu aposol gi nga muerengei ma gi nga me pengan se Iesu bu kepineits kokouk gi ta nga tsana ma gi ta nga vasangan. ");
INSERT INTO tbf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","E Iesu ma ken sar aposol gi kap nga suvuon ka kientsep nia ngou, simi vunan a nga palan bu mei gi nga mono nemei ma muerengei. Io, e Iesu a nga oeng segie, “Nga nomeie iou ma giet ta rakot si ka korot ta menemenen ma nga ta por minaes en.” ");
INSERT INTO tbf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Io, gi nga ka simi galeu egie kesegie mo nge tsourarak rakot simi korot ta nga menemenen. ");
INSERT INTO tbf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Eiekesen sien gi ta nga tsuk, palan bu mei gi nga pare gie. Ma bu mei gi nga soer kovuni sibu enamon kokouk nge muna so beit segie. ");
INSERT INTO tbf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sien e Iesu tate nga so tsaer nge pare mi bineit leong, a nga tovie gie, simi vunan gi nga malan bu sipsip kap magi ka ka nennei. Io, a nga vakaek nge vavasengei segie ngan bu kepineits palan. ");
INSERT INTO tbf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sien tate nga vor reivreiv, ken sar madar tovtov gi nga nemei sien, ma gi nga pevien, “A te reivreiv ma ine mi korot a mon peken bu enamon. ");
INSERT INTO tbf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ture vavasie mi bineit va gi ta mang rakot sibu korot tsangtsang tau ma sibu enamon, va gi ta mang ra vorie magi kavo nginonginou.” ");
INSERT INTO tbf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eiekesen e Iesu a nga kuil nama, “Nga tabarie gie ngan kavo nginonginou!” Gi nga oeng sien, “E lalaron va gei ta voir nginonginou ngan ba sinangavur luo koboit (200) bu lakep denari nge tabarie gie?” ");
INSERT INTO tbf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A nga virei, “Nga suvuon a vovies bu tsoik? Nga ra dedeng.” Sien gi ta nga muerengei, gi nga pevien, “Ba tsoik mi napaririem ma ba ie luo meses gei vorotan.” ");
INSERT INTO tbf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Samo, e Iesu a nga oeng simi bineit va gi ta nga mogos sibu gargar i popon mi potpotbor. ");
INSERT INTO tbf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Io, gi nga mogos sibu gargar. Bu gargar mene a nga oit mi sinangavur kes koboit (100) mi aesaes kokouk segie ma bu gargar mene a nga oit bu sinangavur mi napaririem (50). ");
INSERT INTO tbf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","E Iesu a nga poro ba tsoik napaririem ma ba ie meses luo, ma a nga dedeng kien i kur simi rangit nge vatamase gie. Ma a nga potpot terie bu tsoik si ken sar madar tovtov nia tabarie mi bineit. A nga potakie ba ie luo buer i kotubuon mi bineit kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma gi nga ngou ma gi nga ti. ");
INSERT INTO tbf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma bu madar tovtov gi nga vovosuo bu leke mi sinangavur kes ma luo ngan bu keipkepide tsoik ma ie. ");
INSERT INTO tbf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mi aesaes kokouk sibu ka gi ta nga ngou a nga oit bu sinangavur mi napaririem soloba (5,000). ");
INSERT INTO tbf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ian ngas te, e Iesu a nga oeng si ken sar madar tovtov va gi tate nga ka simi galeu nge muo rakot i Betsaida. Sien eie va ta be nga ture vavasie mi bineit. ");
INSERT INTO tbf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I murien tate nga ture vavasie gie, e Iesu a nga veis kien i gegen mi pout nia ra no. ");
INSERT INTO tbf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sien tate nga reivreiv seserigo, mi galeu a te nga mon i kutum simi barateis ma e Iesu kesen mo a te nga mon i koen. ");
INSERT INTO tbf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A nga pare bu madar tovtov gi tate nga keilkeilgo tarave bu voes simi vunan gi nga suoeie mi mour. Simi to vagoso ador tate nga ta, e Iesu a nga veis i popon mi barateis rakot segie ma a te nga vatvatta veis rov rio gie. ");
INSERT INTO tbf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sien gi ta nga pare ta nga veis i popon mi barateis, gi si nga kia va eie mi tonuo. Ma gi nga kudier koupkoup, ");
INSERT INTO tbf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","simi vunan egie kokouk gi nga pare ma gi nga motou beitsak. Ian ngas te, e Iesu a nga oeng segie, “Bu aronga ta menemenen. Kian va nga ta motou! Arie eou mo.” ");
INSERT INTO tbf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Samo a nga rov ka simi galeu meie gie ma mi mour a nga voto. Ma gi nga kudier beitsak, ");
INSERT INTO tbf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","simi vunan gi kap nga katsep si man vuevue ian mi kepineits ta nga tsorubeit sibu tsoik, surie bu arogie a nga teng. ");
INSERT INTO tbf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sien gi tate nga tsourarak, gi nga so tsaer i Genesaret, ma gi nga koroir vangvangasie mi galeu ian en. ");
INSERT INTO tbf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ian ngas te sien gi tate nga tsour simi galeu, mi kulou gi nga deng kielala e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma gi nga soer veriris ian simi enamon kokouk ma gi nga sorokie bu tamat mienarouk i popon bu tsur rakot sibu sana korot gi ta nga rongovan va e Iesu a nga mon en. ");
INSERT INTO tbf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma sibu korot kokouk va ta nga rakot en, bu enamon, o, bu taon o, bu korot tsangtsang tau, gi nga ko vogosongie bu tamat mienarouk sibu korot nia verikuil nge kepineits. Ma gi nga ko no masitinoiv seie va ta nga tor nge gie va gi ta nga tobelie mo mi tangatson man tsetstseik. Ma egie ese gi ta nga tobelie, gi nga ketseketseng si magi sar mienarouk. ");
INSERT INTO tbf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bu Parisaio ma bu vavvasengei sibu vinuor se Moses gi ta nga kovuni i Ierusalem, gi nga oir kouk i babaren e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma gi nga pare ken sar madar tovtov mene e Iesu gi kap nga vavano bu rimagie ma gi nga ngou ngan bu rimagie bita. ");
INSERT INTO tbf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Bu Parisaio ma bu Iuda kokouk gi kap nga ko ngou oit va gi ta muna vavano bu rimagie vemusurie bu sinavei sibu tubugie. ");
INSERT INTO tbf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sien va gi ta nga muerengei simi korot nia verikuil nge kepineits, gi ta kap nga ngou oit va gi ta muna vara melemelen nge gie ngan mi da. Ma gi nga vemusurie palan bu sinavei mene sibu tubugie, malan mi sinavei nia govorie bu koi unun, bu utut ma bu sosopen.) ");
INSERT INTO tbf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Io, bu Parisaio ma bu vavvasengei simi vinuor gi nga vosuoreie e Iesu, “Surie misa ke sar madar tovtov gi ta kap vemusurie bu sinavei sibu tubugiet? Gi si ngou ngan bu riem bita.” ");
INSERT INTO tbf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","E Iesu a nga kuil nama, “Ken nama e Isaia ta nga vokokotie surie nga, a tuktuk va enga bu malamala ka duis. Malan mi Pakpak Leong ta pevien, “‘Ine mi kulou gi mangara iou ngan bu ngutsugie mo, eiekesen bu arogie a pek sorvekena iou. ");
INSERT INTO tbf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kegi rengeir nemei seou a sasavoir mo, simi vunan gi ko vasengei ngan bu vinuor mi kulou mo gi ta nga vabatie.’ ");
INSERT INTO tbf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nga ko tsupuk rivie bu vuna vinuor se Raban eiekesen nga ko vemusurie bu sinavei simi kulou mo.” ");
INSERT INTO tbf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma e Iesu a nga oeng segie, “Nga ko sievei beitsak nia tsupuk rivie Ken vuna vinuor e Raban terengien nga ta mang vemusurie bu sinavei sibu tubunga! ");
INSERT INTO tbf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","E Moses a nga pevien, ‘Nga ta mangaran bu tamanga ma bu kinanga’, ma ‘Eie ese ta oeng vatsakatie e taman o, e kinan, gi ta ngas kenvamate.’ ");
INSERT INTO tbf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eiekesen nga ko pevien va sien va ka mei ta oeng se taman o, se kinan, ‘Mi kepineits o ta oit nia kulie ngado ngan, eie te mi Korban,’ (Mi Korban eie mi tienebeir rakot se Raban), ");
INSERT INTO tbf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","io, nga ko sunuir va mi ka ta kap tsana ka kepineits nia kulie e taman o, e kinan. ");
INSERT INTO tbf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma surie ine, nga ko beir rivie ken nama e Raban ngan bu sinavei sibu tubunga ian nga tate vasangan sibu natunga. Ma nga ko tsana buer palan bu kepineits malan ian.” ");
INSERT INTO tbf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Io, i murien e Iesu ta nga kukuo mi bineit nemei sien, a nga pevien, “Nga rorong seou terengien va nga ta mang katsep kalei. ");
INSERT INTO tbf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kap ka kepineits ta mon i marar si ka mei a oit nia vara bita ngan sien va ta rubukien i aron. Eiekesen, mi sana kepineits ta rovotsour kovuni i aron, arie a vara bita ngan. ");
INSERT INTO tbf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Eie ese ta suvu taterieng nia rorong, ta ngas rorong.” ");
INSERT INTO tbf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","I murien e Iesu tate nga sorvekenan mi bineit nge rubukien simi vonuo, ken sar madar tovtov gi nga vosuoreie surie ngan ine mi nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","E Iesu a nga pevien, “Vasa, nga kap ngas katsep? Kap ka kepineits ta rubukien i aron mi mei kuvu i marar, a oit nia vara bita ngan. ");
INSERT INTO tbf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Simi vunan, a kap rubukien i aron, eiekesen a rubukien mo simi kititan, ma samo a te buer rovotsour.” (E Iesu ta nga vuotongie ine mi nama nia vakatsepa va bu nginonginou kokouk a melemelen.) ");
INSERT INTO tbf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","E Iesu a nga pevien buer, “Mi sana kepineits ta rovotsour simi mei, arie mi kepineits a vara bita ngan. ");
INSERT INTO tbf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bu tsaka kepineits gi ta kovuni die i aron mi ka. Arie egie bu tsaka vienviendon, mi sinavei nia tetteririv, mi sinavei nia puer, mi sinavei nia kenvamate mi mei, mi sinavei nia rei puer, ");
INSERT INTO tbf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma mi sinavei nia ngaguo, mi sinavei malangiets, mi sinavei ni pouts bit, mi sinavei ni mala kopuen, mi sinavei ni ngunguts, mi sinavei ni oengoeng tsak, mi sinavei ni kakaleong, ma mi sinavei ni mala be. ");
INSERT INTO tbf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ine bu tsaka kepineits gi kovuni die i aron mi ka ma gi vara bita ngan.” ");
INSERT INTO tbf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E Iesu a nga sorvekenan ian mi enamon ma a nga veis beit vatavatat simi enamon i Turos. Ma a nga so rubukien simi vonuo ma a kap nga lalaron va ka mei ta nga telekiran ken bineit, eiekesen a kap nga oit nia muningan ken bineit. ");
INSERT INTO tbf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Io, mi vevien ese e natuon vevien mi tsaka moromoruo ta nga tsegerie, a nga nemei lalapus sien ta nga rongovan va e Iesu a te nga beit. Ma a nga me sege pukupukukaek i kamen e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ine mi vevien eie mi Kibang, kap va mi Iuda, gi nga kava i Ponisia i aron mi enamon leong i Siria. A nga no masitinoiv se Iesu va ta nga kareir rivie mi tsaka moromoruo se natuon vevien. ");
INSERT INTO tbf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","E Iesu a nga oeng simi vevien, “Vourvour, gei ta be tabarie bu natu madar vaotie kegi lalaron. Surie a kap duis va gei ta poro magi tsoik bu natu madar nge tomeke terie sibu kopuen.” ");
INSERT INTO tbf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mi vevien a nga kuil nama, “A tuktuk, mi Nguts, eiekesen bu kopuen i pakien mi tsur ngongou buer gi ko nganie bu mememuru nginonginou sibu natu madar.” ");
INSERT INTO tbf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Samo e Iesu a nga oeng ine simi vevien, “Surie ine ke nama, e tate veis. Mi tsaka moromoruo a te sorvekenan e natu vevien.” ");
INSERT INTO tbf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sien ine mi vevien ta nga muerengei beit si ken vonuo, a nga so vorotan va e natuon ta nga mutur i popon mi tsur ma mi tsaka moromoruo a te nga tsour sorvekenan. ");
INSERT INTO tbf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Samo e Iesu a nga sorvekenan mi enamon vatvatta i Turos, ma a nga veis rov riu ka i kotubuon mi enamon i Sidon, ma a nga peuk simi barateis i Galili simi enamon leong i Dekapolis. ");
INSERT INTO tbf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ian en, bu mei gi nga kir nemei ngan seie mi ka ngong. Ma gi nga no masitinoiv se Iesu va ta nga teir riem i popon ine mi ka. ");
INSERT INTO tbf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I murien e Iesu tate nga kir kesevan ine mi ka rakot i gege sorvekenan mi bineit, a nga tsure terie ba pitsipitsi riman siba tateringan ine mi ka. Samo a nga kinouts simi pitsipitsiriman ma a nga tobelie mi karamen ine mi ka. ");
INSERT INTO tbf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","E Iesu a nga dedeng kien simi rangit ma a nga maesaram nge pevien ne simi ka, “Epata!” (man vuevue va, “E ta katsep!”) ");
INSERT INTO tbf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ian ngas te, ba tateringan ine mi ka a nga katsep, ma mi karamen a te nga ketseketseng ma a nga vakaek nge vakvakokoit kalei. ");
INSERT INTO tbf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","E Iesu a nga oeng ngeisngeis segie va gi ta kap nga pengan si ka mei mene. Eiekesen, misasien ta nga vangenge gie, gi ngas nga vor ve pepengan. ");
INSERT INTO tbf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mi kulou gi nga kudier tsak ma gi nga pevien, “Eie a te tsang vititirie bu kepineits kokouk. A tsana buer va mi pi ta rorong ma mi ngong ta vakokoit.” ");
INSERT INTO tbf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ian sibu ra, mi bineit leong mene gi te buer nga me beit kouk. Ma sien gi ta kap nga suvuon te ka puk nginonginou, e Iesu a nga kukuo ken sar madar tovtov ma a nga pevien, ");
INSERT INTO tbf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“O tovie ine mi bineit. Gi te me mon meie iou en ne oit ba ra tour, ma kap te magi kavo nginonginou. ");
INSERT INTO tbf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sien va o ta ture muer nge gie rakot si kegi sar enamon meie mi vientor, ta so girigirir bu matagie i sar, simi vunan bu mei mene segie gi veis kovuni te i pek.” ");
INSERT INTO tbf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ken sar madar tovtov gi nga kuil nama, “Ivie giet ta oit nia por tsoik en ine simi korot beir nia tabarie gie kokouk?” ");
INSERT INTO tbf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","E Iesu a nga virei, “A voveis bu tsoik nga suvuon?” Gi nga kuil nama, “Mi napaririem potsu luo.” ");
INSERT INTO tbf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Io, e Iesu a nga oeng simi bineit va gi ta nga mogos i keim simi kaber. Sien tate nga poro bu tsoik mi napaririem potsu luo nge vuot kalei se Raban, a nga potakie gie ma a nga terie gie si ken sar madar tovtov va gi ta nga tabarie ngan mi bineit. Io, gi nga tsana malan. ");
INSERT INTO tbf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gi nga suvuon ba natu ie meses buer. E Iesu a nga vuot kalei ngan buer se Raban surie ine ba ie ma a nga oeng sibu madar tovtov nia potakie gie. ");
INSERT INTO tbf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mi kulou gi nga ngou nge ti. Ma bu madar tovtov gi nga tsuokopie bu kepide nginonginou nge vovosuo ngan mi napaririem potsu luo bu leke leong. ");
INSERT INTO tbf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mi aesaes kokouk ine simi bineit a nga oit malan ba sinangavur voveit soloba (4,000). Ma e Iesu a nga ture vavasie gie, ");
INSERT INTO tbf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma ian ngas te, a nga rov ka simi galeu meie ken sar madar tovtov ma gi nga rakot simi enamon leong i Dalmanuta. ");
INSERT INTO tbf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bu Parisaio gi nga nemei ma gi nga vakaek nge vetei nge nama meie e Iesu. Gi nga vosuoreie nia konon va ta nga tsana ka totourlekier ni vovokudier kovuni simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","E Iesu a nga maesaram ma a nga pevien, “Surie misa mi kuoluon ine bu ra, gi ta virei surie ka totourlekier ni vovokudier? O oeng tuktuk senga, kap ka totourlekier nga ta pare.” ");
INSERT INTO tbf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Samo a nga sorvekena gie ma a nga ka muerengei simi galeu ma a nga tsourarak rakot simi bienengeiv ka nikot. ");
INSERT INTO tbf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bu madar tovtov gi nga vodon punan nia por tsoik. Eiekesen gi nga suvuon mi tsoik kes mo i aron mi galeu. ");
INSERT INTO tbf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","E Iesu a nga vanuo gie, “Nga nenei kalei. Nga ta ngas naneie nga simi iis sibu Parisaio ma se Erot.” ");
INSERT INTO tbf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gi nga vevuor surie ine mi nama i kotubugie nge pevien, “A vakokoit ven ne simi vunan giet kap suvu tsoik.” ");
INSERT INTO tbf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E Iesu a nga telekiran mi sana gi ta nga vevuran ma a nga vereie gie, “Surie misa nga ta vevuor va nga kap suvu tsoik? Nga kap ngas katsep? Bu aronga a ngas bakiet? ");
INSERT INTO tbf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","‘Nga suvu katsomat. Vasa, nga kap oit nia dedeng ngan? Nga suvu taterieng. Vasa nga kap oit nia rorong ngan?’ Ma vasa, nga kap vodonomie? ");
INSERT INTO tbf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sien o ta nga potakie ba tsoik mi napaririem nian bu sinangavur mi napaririem soloba (5,000) mi kulou, a voveis bu leke nga nga vovosuo ngan bu kepide nginonginou?” Gi nga kuil nama, “Mi sinangavur kes ma luo.” ");
INSERT INTO tbf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma sien o ta nga potakie bu tsoik mi napaririem potsu luo nian ba sinangavur voveit soloba (4,000) mi kulou, a voveis bu leke nga nga vovosuo nge kapekapien? Gi nga kuil nama, “Mi napaririem potsu luo.” ");
INSERT INTO tbf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","E Iesu a nga oeng segie, “Ma vasa, nga kap ngas katsep?” ");
INSERT INTO tbf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gi nga beit i Betsaida, ma bu mei gi nga kerie mi kael ma gi nga no masitinoiv se Iesu va ta nga soburo. ");
INSERT INTO tbf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","E Iesu a nga popor ka i riman mi kael ma a nga kir vorotsoruo i marar simi enamon. I murien e Iesu tate nga kientsuo ba katsomatan nge teir riem i popon, a nga vereie, “E pare ka kepineits?” ");
INSERT INTO tbf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mi kael a nga dedeng nge pevien, “O pare bu mei gi mat malan va bu ei gi veisveis.” ");
INSERT INTO tbf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","E Iesu a buer nga teir riem i popon ba katsomatan ine mi ka, io, ine mi ka a nga aan vangvangasie, ma samo ken baidendeng a te nga kalei ma a nga deng vititirie te bu kepineits kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E Iesu a nga oeng sien, “Rakot duis si ke vonuo. Ma kian va e ta rakot nge pengan sibu mene simi enamon.” ");
INSERT INTO tbf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","E Iesu ma ken sar madar tovtov gi nga veis rakot sibu enamon viririsie mi enamon leong i Kaesarea Pilippoi. Sien gi ta nga vor ve veisveis, a nga vosuoreie gie, “Mi kulou gi pevien va eou ese?” ");
INSERT INTO tbf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gi nga kuil nama, “Bu mei mene gi pevien va evoi e Ioanes mi ka ni sinusuruiv; a, bu mei mene gi pevien va evoi e Eliia, ma bu mei mene ngas buer gi pevien va evoi mi meinmenien bu propet.” ");
INSERT INTO tbf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma a nga vereie gie, “Ma enga vasa? Nga pevien va eou ese?” E Petro a nga kuil nama, “Evoi mi Messia.” ");
INSERT INTO tbf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","E Iesu a nga vangenge gie va gi ta kap nga pepengan si kavo mei mene va eie ese. ");
INSERT INTO tbf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Samo e Iesu a nga vakaek nge vavasengei si ken sar madar tovtov va e Natuon mi Ka ta ngas suvu vinekikin palan. Ma bu muomuo simi kulou, bu prist leong, ma bu vavvasengei sibu vinuor se Moses gi ta so sunuran ma gi ta kenvamate. Ma i murien ba ra tour ta to muerengei. ");
INSERT INTO tbf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E Iesu a nga vakatsepa vititirie ine mi nama. Ma e Petro a nga kir terie i gege ma a nga vakaek nge patsarie. ");
INSERT INTO tbf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Eiekesen sien e Iesu ta nga vuris nge pare ken sar madar tovtov, a nga patsarie e Petro nge pevien, “Satan, tsupek vekena Iou! Bu vienviendon e ta suvuon a kap kovuni se Raban, eiekesen a kovuni mo simi ka.” ");
INSERT INTO tbf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Samo e Iesu a nga kuk nemei ngan seie mi bineit meie ken sar madar tovtov nge pevien, “Sien va ka mei ta lalaro vemusurie iou, eie ta ngas vamoie eie kesen ma ta ngas tsuok sorokie man koitskoits nge vemusurie iou. ");
INSERT INTO tbf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Simi vunan eie ese ta ruit ngan ken tino, ta rivie ken tino. Eiekesen eie ese ta rivie ken tino surie Iou ma surie mi Banga Vinavatei, ta suvuon mi tino. ");
INSERT INTO tbf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mi sana man kienelei, sien va ka mei a suvuon mi kaber kokouk eiekesen eie ta rivie ken tino? ");
INSERT INTO tbf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O, mi sana kepineits mi ka a oit nia verikuil meie ngan ken tino? ");
INSERT INTO tbf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi kuoluon ine bu ra gi mon simi sinavei tetteririv ma simi sinavei tsokor. Io, sien va ka mei a mengemengeir rivie Iou ma mi Namaniung, e Natuon mi Ka ta so mengemengeir rivie buer, sien va ta nemei meie ngan man matvinavaso e Taman meie ken sar angelo e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma e Iesu a nga oeng segie, “O oeng tuktuk senga, kavo mei senga gi ta tuir en ne, gi ta kap so maet i muan va gi ta pare e Raban ta so vuor mi mangmagoso enaenamon ngan mi ngeisngeis.” ");
INSERT INTO tbf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","I murien bu ra mi napaririem potsu kes, e Iesu a nga kerie e Petro, a, e Iakobo ma e Ioanes. Ma a nga kerie gituo kien i popon mi pout leong ivie egie kesegie mo gi nga ra mon en. Ian en, e Iesu a nga tsorubeit kekineits si kegituo baidendeng. ");
INSERT INTO tbf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Man sar tsetstseik a nga tsorubeit puneits nge kutsukutsuleip. A nga puneits beitsak rio mi busobuso naov. ");
INSERT INTO tbf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Samo e Eliia ma e Moses guor nga beit i matagituo nge vakokoit meie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","E Petro a nga oeng se Iesu, “Vavvasengei, a kalei sien giet ta mon en ne. Gatuo ta voturie kaba papael tour, ke ka mene, a, ken ka mene e Moses, ma ken ka mene e Eliia.” ");
INSERT INTO tbf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","E Petro a kap ba nga telekiran vasa va ta nga vakokoit ven, simi vunan gituo te nga motou beitsak. ");
INSERT INTO tbf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Samo mi balbal a nga tsorubeit nge kuva gie ma mi ien kovuni simi balbal a nga pevien ne, “Ine arie e Natung ese o ta tovie beitsak. Nga rorong sien!” ");
INSERT INTO tbf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Puk kam lalapus, gituo ta nga dedeng veriris, eiekesen gituo kap nga pare te ka mei mene, eiekesen e Iesu kesen mo te. ");
INSERT INTO tbf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sien gi tate nga vor peukpeuk kovuni simi pout, e Iesu a nga vengeng vangvangasie gituo va gituo ta kap nga pepengan si ka mei mene misa gituo ta nga pare oit va e Natuon mi Ka va ta ba to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gituo nga vodon terie segituo kesegituo mo ine mi nama, ma gituo nga vevuor tarave va misa man vuevue, “Mi tino mumuerengei simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma gituo nga vosuoreie e Iesu, “Surie misa bu vavvasengei sibu vinuor se Moses gi ta pevien va e Eliia ta ngas muna beit?” ");
INSERT INTO tbf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","E Iesu a nga kuil nama, “A tuktuk, e Eliia ta ngas muna beit nge tsang muerngan bu kepineits kokouk. Ma surie misa mi Pakpak Leong ta pengan va e Natuon mi Ka ta ngas suvu vinekikin palan ma gi ta mugumitsan? ");
INSERT INTO tbf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eiekesen, o oeng sengatuo, e Eliia a te nga beit. Ma gi nga tsana bu suada kepineits kokouk gi ta nga lalaro tsana sien malan be mo gi tate nga vataro surie simi Pakpak Leong.” ");
INSERT INTO tbf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sien gi tate nga muerengei vorotan bu madar tovtov mene, gi nga pare mi bineit leong viririsie gie, ma bu vavvasengei sibu vinuor se Moses gi nga vevuor meie gie. ");
INSERT INTO tbf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sien mi bineit gi ta nga pare e Iesu, gi nga kudier tsak ma gi nga soer rakot nia ra res suoeie. ");
INSERT INTO tbf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A nga virei, “Misa nga vevuor meie gie surie?” ");
INSERT INTO tbf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mi ka i aron mi bineit a nga kuil nama, “Vavvasengei, o kir nemei ngan e natung sevoi, ese mi tsaka moromoruo ta tsegerie ma a kap oit nia vakokoit. ");
INSERT INTO tbf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sibu keipkepide ra kokouk sien va mi tsaka moromoruo ta tsegerie, ta tomekan simi kaber, ma ta kat nge guruos mi ngutsuon nge vengvengio bu rivon, ma a ko vadotso mi kurikurien. O te vosuoreie ke sar madar tovtov va gi ta kareir rivie mi tsaka moromoruo, eiekesen gi kap oit.” ");
INSERT INTO tbf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","E Iesu a nga oeng segie, “Enga mi kuoluon ine bu ra, kap kenga ka vodovodon tuktuk. Ese a ba nga pare o ta nga mon meie nga? Ma ese a ba nga pare o ta nga sorokie kenga sar putu? Nga kir nemei ngan seou mi madar.” ");
INSERT INTO tbf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Io, gi nga kir nemei ngan. Ine mi tsaka moromoruo sien tate nga pare e Iesu, ian ngas te, a nga vedederie ine mi madar. Ine mi madar a nga tsibour mutur nge vuilvuil simi kaber, ma mi ngutsuon a te nga kat nge guruos. ");
INSERT INTO tbf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","E Iesu a nga vosuoreie e taman mi madar, “Venenges te a nga malan ne?” A nga kuil nama, “Vakaek ngas te ta nga natu madar. ");
INSERT INTO tbf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A nga ko tomekan i aron mi leing ma mi da nia kenvamate. Eiekesen sien va e ta oit nia tsana ka kepineits, tovie gei nge kulie gei.” ");
INSERT INTO tbf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","E Iesu a nga pevien, “Surie misa e ta pevien va, ‘Sien va e ta oit?’ Bu kepineits kokouk a oit seie ese ta vodovodon tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ian ngas te, e taman ine mi madar a nga pevien, “O vodovodon tuktuk. Kulie iou va kong vodovodon tuktuk ta mang leong!” ");
INSERT INTO tbf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sien e Iesu ta nga pare mi bineit gi ta nga veis lalapus nemei, e Iesu a nga patsarie mi tsaka moromoruo, “Evoi mi tsaka moromoruo simi pi ma mi ngong. O oeng ngeisngeis sevoi, rovotsour sorvekenan ma kian va e ta ba buer tsegerie.” ");
INSERT INTO tbf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ine mi tsaka moromoruo a nga koup nge vadotso vangvangasie ine mi madar ma a nga rovotsour. Ine mi madar a te nga mat malan va a nga mesei ma palan bu mei gi nga pevien, “A te maet.” ");
INSERT INTO tbf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eiekesen e Iesu a nga popor i riman ma a nga tsuok voturie ma a nga tuir. ");
INSERT INTO tbf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","I murien e Iesu tate nga rubukien simi vonuo, ken sar madar tovtov gi nga virei menentan, “Surie misa gei ta kap oit nia kareir rivie ine mi tsaka moromoruo?” ");
INSERT INTO tbf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E Iesu a nga pevien segie, “Ine mi suada tsaka moromoruo nga oit nia kareir rivie ngan mo mi nono.” ");
INSERT INTO tbf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gi nga sorvekenan ine mi enamon ma gi nga veis ka i aron i Galili. E Iesu a kap nga lalaron va ka mei ta nga telekiran ivie gi nga mon en, ");
INSERT INTO tbf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","simi vunan a nga vavasengei si ken sar madar tovtov. Ma a nga pevien, “E Natuon mi Ka, gi ta roev terie i riman mi kulou. Gi ta kenvamate ma i murien ba ra tour ta to muerengei.” ");
INSERT INTO tbf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eiekesen gi kap nga katsep simi sa ta nga vokokotie. Ma gi nga motou nia vosuoreie surie ine mi namanien. ");
INSERT INTO tbf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Samo gi nga nemei i Kapernaum. Sien e Iesu tate nga mon i aron mi vonuo, a nga vereie gie, “Misa nga vevuor surie i sar?” ");
INSERT INTO tbf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eiekesen gi kap nga kuil nama simi vunan gi nga vevuor surie va ese a tsiroup. ");
INSERT INTO tbf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","E Iesu a nga mogos, ma a nga kukuo mi sinangavur kes ma luo bu madar tovtov nge pevien, “Sien va ka mei ta lalaro muomuo, eie ta ngas vevemuir, ma eie ta ngas petspets segie kokouk.” ");
INSERT INTO tbf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A nga kerie mi natu madar nge voturie i kotubugie. Ma a nga govitan nge pevien, ");
INSERT INTO tbf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Eie ese ta suguo ka mei segie ine bu natu madar simi asoung, a suguo iou. Ma eie ese ta suguo iou, kap va a suguo iou mo, eiekesen a suguo buer eie ese ta nga tura iou.” ");
INSERT INTO tbf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","E Ioanes a nga pevien, “Vavvasengei, gei nga pare mi ka a nga kareir rivie bu tsaka moromoruo ngan mi asa. Ma gei nga vangenge simi vunan eie kap va mi meinmenigiet.” ");
INSERT INTO tbf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","E Iesu a nga pevien, “Kian va nga ta vangenge, simi vunan eie ese ta tsana bu kepineits ni vovokudier simi asoung, a kap ba buer oit nia oeng vatsakatie iou. ");
INSERT INTO tbf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Eie ese ta kap murien veie giet eie segiet. ");
INSERT INTO tbf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","O oeng tuktuk senga, eie ese ta terie ka koi da senga simi vunan enga ken sar madar tovtov e Karisito, eie ta kap ba votsorovie ken voirvoir.” ");
INSERT INTO tbf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ma sien va ka mei ta vokorongie ka mei segie ine bu mei lili gi ta vodovodon tuktuk seou va ta tsana mi sinavei tsokor, ta kalei beitsak va gi ta pala ka dodou leong i konokonon nge ra votsorovie i rou. ");
INSERT INTO tbf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sien va mi rima ta vokorongie no nia tsana mi sinavei tsokor, tav rivie. A kalei va e ta rubukien simi tino rovoriu ngan ka riem kes mo, sien a kap kalei va e ta suvuon ba rima kokouk nge rubukien ngan simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ian en, ‘Bu kunkun gi kap ko maet, ma mi leing a kap ko mesei.’ ");
INSERT INTO tbf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma sien va mi kame ta vokorongie no nia tsana mi sinavei tsokor, tav rivie. A kalei va e ta rubukien simi tino rovoriu ngan ka kaek kes mo, sien a kap kalei va e ta suvuon ba kame kokouk ma gi ta tomeka no simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ian en, ‘Bu kunkun gi kap ko maet, ma mi leing a kap ko mesei.’ ");
INSERT INTO tbf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma sien va mi katsomata ta vokorongie no nia tsana mi sinavei tsokor, gaol rivie. A kalei beitsak va e ta rubukien si ken mangmagoso Nguts e Raban ngan mo ka katsomat kes, sien a kap kalei va e ta suvuon ba katsomata kokouk ma gi ta tomeka no meie simi leing leong ian ta kap ko mesei. ");
INSERT INTO tbf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ian en, “‘Bu kunkun gi kap ko maet, ma mi leing a kap ko mesei.’ ");
INSERT INTO tbf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mi kulou kokouk mi leing ta vara melemelen nge gie malan mi barateis ta vara melemelen ngan mi nginonginou. ");
INSERT INTO tbf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mi barateis a kalei, eiekesen sien va ta voto ken barabaratasie, vasa nga ta ba buer oit nia vara barabaratasie venengan? Nga ta ngas suvuon mi barateis si kenga tino, ma nga ta suvu banga mienagos i kotubunga.” ");
INSERT INTO tbf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Samo e Iesu a nga sorvekenan ian mi enamon ma a nga veis rakot simi enamon leong i Iudea ma a nga veis kitipie mi da i Ioridan. Mi bineit gi nga nemei sien te buer, ma a nga vavasengei segie malan ta nga ko tsana. ");
INSERT INTO tbf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bu Parisaio mene gi nga nemei sien nia konon. Ma gi nga vosuoreie, “Vasa, mi vinuor a tor va mi ka ta vekapot sorvekenan ken vevien?” ");
INSERT INTO tbf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A nga kuil nama, “Mi sana vinuor e Moses a nga oeng ngeisngeis ngan senga?” ");
INSERT INTO tbf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Gi nga pevien, “E Moses a nga tor ngan ka ka va ta vataro ka pakapaka rorou nia vavakatsep va keguor rei a te vekapot ma ta ture rivie.” ");
INSERT INTO tbf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","E Iesu a nga kuil nama, “Bu aronga a nga bakiet, arie mi vunan, e Moses a nga vataor vunie nga ngan ine mi vinuor. ");
INSERT INTO tbf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Eiekesen simi tsuoktsuok vakaek simi vinagoso, e Raban a nga tsana mi ka ma mi vevien. ");
INSERT INTO tbf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Arie mi vunan, mi ka ta ngas sorvekenan e taman meie e kinan ma ta toun meie ken vevien. ");
INSERT INTO tbf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ma eguor guor ta tsorubeit mi kurikuri kes. A tuktuk, guor kap ba luo eiekesen guor te kes. ");
INSERT INTO tbf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mi sana e Raban tate nga votsok kakuon, e Raban a kap sunuir va ka mei ta potakie.” ");
INSERT INTO tbf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sien gi tate buer nga mon i aron mi vonuo, bu madar tovtov gi nga vosuoreie e Iesu ngan ine. ");
INSERT INTO tbf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A nga kuil nama, “Mi ka ese ta vekapot sorvekenan ken vevien ma a te buer reie ka vevien mene, eie a te tsana mi sinavei nia rei puer varaveie ken vevien vourvour. ");
INSERT INTO tbf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma sien va ka vevien ta vekapot sorvekenan ken labeit ma a te buer reie ka ka mene, eie a te tsana mi sinavei nia rei puer.” ");
INSERT INTO tbf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mi kulou gi nga kir nemei ngan bu natu madar se Iesu va ta nga soburo nia vatamase gie, eiekesen bu madar tovtov gi nga patsarie mi kulou. ");
INSERT INTO tbf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sien e Iesu ta nga pare ine, a nga petseir veie ken sar madar tovtov ma a nga oeng segie, “Nga ta ngas sunuir va bu natu madar gi ta nemei seou, ma kian va nga ta vangenge gie, simi vunan mi vavatamaes kovuni si ken mangmagoso Nguts e Raban a sogove gie bu suada mei malan ne. ");
INSERT INTO tbf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","O oeng tuktuk senga, ese mei ta kap lalaron va e Raban ta vuortie ken tino malan mi natu madar, eie ta kap oit nia so rubukien si ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma a nga govitan bu natu madar ma a nga teir riem i popogie ma a nga vatamase gie. ");
INSERT INTO tbf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sien e Iesu tate nga vakaek nge veis, mi ka a nga soer nemei sien ma a nga sege pukupukukaek i matan ma a nga virei, “Banga vavvasengei, misa o ta ngas tsana nia suvuon mi tino rovoriu?” ");
INSERT INTO tbf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","E Iesu a nga kuil nama, “Surie misa e ta vuotongie iou va eou mi banga vavvasengei? Kap ka mei a kalei eiekesen e Raban kesen mo. ");
INSERT INTO tbf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E telekiran bu vuna vinuor ian ta pevien, ‘Kian va e ta kenvamate ka mei. Kian va e ta tsana mi sinavei nia rei puer. Kian va e ta puer. Kian va e ta vokokotie ka nama binit i matan mi vinuor. Ma kian va e ta bitie ka mei. Mangaran e tama ma e kina.’” ");
INSERT INTO tbf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ine mi ka vour a nga pevien, “Vavvasengei, o nga vemusurie ine bu vinuor kokouk vakaek te sien o ta ngas nga madar lili.” ");
INSERT INTO tbf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E Iesu a nga dengarie nge tovie ma a nga pevien, “Mi kepineits kes e kap ngas tsana. E ta ngas veis nge ra verikuil ngan ke sar sinsuv kokouk nge lakep nge terie sibu sinaortsak, ma e ta ba so suvuon mi banga mos die i kur simi rangit. I muir, nemei nge vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sien ine mi ka ta nga rongomie ine mi nama, a nga mesirik ma a nga veis sorvekenan, simi vunan a nga suvuram beitsak. ");
INSERT INTO tbf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","E Iesu a nga dedeng veriris ma a nga oeng si ken sar madar tovtov, “A ngeisngeis beitsak segie gi ta suvuram va gi ta rubukien si ken mangmagoso Nguts e Raban!” ");
INSERT INTO tbf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bu madar tovtov gi nga kudier tsak ine si ken nama. Eiekesen e Iesu a te buer nga pevien, “Bu natung, a ngeisngeis nia rubukien si ken mangmagoso Nguts e Raban! ");
INSERT INTO tbf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A ngeisngeis beitsak simi ka ta suvuram va ta rubukien si ken mangmagoso Nguts e Raban rio mi kamel va ta bilok ka i aron mi mat simi pide re.” ");
INSERT INTO tbf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bu madar tovtov gi nga kudier tsak beitsak ma gi nga veveoeng segie keskes, “Sien va ta malan, ma ese mo a ba oit nia suvuon mi vavato?” ");
INSERT INTO tbf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","E Iesu a nga pare gie nge pevien, “Ine a mavev simi kulou eiekesen se Raban bu kepineits kokouk a oit va ta tsana.” ");
INSERT INTO tbf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","E Petro a nga pevien, “Pare, gei te nga sorvekenan kegei sar kepineits kokouk nia vemusurie no!” ");
INSERT INTO tbf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","E Iesu a nga kuil nama, “O oeng tuktuk senga, eie ese ta sorvekenan ken vonuo, bu kasien, bu vevinen, e kinan, e taman, bu natuon, o, ken sar tau surie iou ma surie mi Banga Vinavatei, ta suvuon palan i aron ken tino. ");
INSERT INTO tbf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Eie ta suvuon mi sinangavur kes koboit (100) i popon bu kepineits keskes tate nga sorvekenan (ken vonuo, bu kasien, bu vevinen, e kinan, bu natuon ma ken sar tau meie buer bu vinevinekikin.) Ma eie ta so suvuon mi tino rovoriu ian sibu ra va ta nemei. ");
INSERT INTO tbf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Eiekesen palan bu mei gi ta muomuo ine, gi ta so vevemuir, ma palan bu mei gi ta vevemuir ine, gi ta so muomuo.” ");
INSERT INTO tbf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E Iesu ma mi kulou gi te buer nga veis rakot i Ierusalem ma e Iesu a nga veis muo. Ma bu madar tovtov gi nga kudier, ma egie gi ta nga vemuir gi nga motou. Samo, a te buer nga kerie mi sinangavur kes ma luo ken sar madar tovtov rakot i gege, ma a nga oeng segie ngan misa va ta nga so tsorubeit seie. ");
INSERT INTO tbf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A nga pevien, “Giet ta rakot i Ierusalem. Ma e Natuon mi Ka gi ta so terie i riman bu prist leong ma bu vavvasengei sibu vinuor se Moses. Ma gi ta so vuor terie simi miensei ma gi ta terie i napariman bu Kibang. ");
INSERT INTO tbf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gi ta vavangiets ngan nge kientsuo ma gi ta so beiltsie nge kenvamate. Ma i murien ba ra tour ta to muerengei simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Samo e Iakobo ma e Ioanes, ba natuon tamat e Sebedi, guor nga nemei sien, ma guor nga pevien, “Vavvasengei, gor lalaron va e ta tsana segor mi sana kepineits va gor ta vosuoreie no ngan.” ");
INSERT INTO tbf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A nga virei, “Mi sana kepineits ngado lalaron va o ta tsana kengado?” ");
INSERT INTO tbf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Guor nga kuil nama, “E ta ngas tor va ka mei kes segor ta mogos si ke riem suv ma ka mei mene si ke riem kieir i aron ke banga mangmagoso Nguts, terengien gor ta mang so vuor meie no sien va e ta so tsorubeit mi kovakova ka leong.” ");
INSERT INTO tbf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","E Iesu a nga pevien, “Ngado kap telekiran mi sana ngado vovosurei ngan. A oit va ngado ta un simi koi da o ta un sien? Ma ngado oit nia suvuon mi sinusuruiv malan mi sinusuruiv o ta suvuon?” ");
INSERT INTO tbf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Guor nga kuil nama, “Gor oit!” E Iesu a nga oeng seguor, “Ngado ta so un simi koi da o ta un sien, ma ngado ta so suvuon mi sinusuruiv malan mi sinusuruiv o ta suvuon. ");
INSERT INTO tbf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eiekesen, o kap suvuon mi duis nia vile ese va ta mogos si kong riem suv, o, si kong riem kieir. Ine ba mogomogos segie mo ese e Raban tate nga tsang rosie gie ngan.” ");
INSERT INTO tbf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sien mi sinangavur kes bu madar tovtov gi ta nga rongomie ine, gi nga aor putu veie e Iakobo ma e Ioanes. ");
INSERT INTO tbf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","E Iesu a nga kuk kakaku gie nge pevien, “Nga telekiran va egie ese gi ta vuotongie va bu muomuo ni vuor sibu Kibang, gi suvu ngeisngeis nia vuortie mi kulou gi ta mon si kegi nennei. Ma magi sar muomuo gi ko ngeisngeis va mi kulou gi ta vemusurie kegi sar vinuor. ");
INSERT INTO tbf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kenga mienagos ta kap malan ine. Eie ese ta lalaron va ta leongleong i kotubunga, eie ta ngas muna tsorubeit kenga petspets. ");
INSERT INTO tbf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma eie ese ta lalaron va ta muomuo eie ta ngas tsorubeit va eie kenga petspets. ");
INSERT INTO tbf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Surie e Natuon mi Ka buer a kap nga nemei va gi ta tsatsang petspets sien, eiekesen a nga nemei nia tsatsang petspets segie mi kulou ma nia terie ken tino nia voir tsana palan mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Samo gi nga beit i Ieriko. Ma sien e Iesu ma ken sar madar tovtov kokouk meie mi bineit leong, gi tate nga sorvekenan i Ieriko, mi kael mi asan e Batimeus (eie e natuon e Timeus), a nga mogos i gege sar nge vor ve nono kepineits. ");
INSERT INTO tbf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sien tate nga rongomie va e Iesu kovuni i Nasaret a nga veis rov riu, a nga vakaek nge koupkoup, “Iesu, Natuon e Davit. Tovie iou!” ");
INSERT INTO tbf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Palan gi nga patsarie nge oeng sien va ta nga bong, eiekesen eie a ngas nga koupkoup leong, “Natuon e Davit. Tovie iou!” ");
INSERT INTO tbf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","E Iesu a nga so tuir ma a nga pevien, “Nga kuk nemei ngan.” Io, gi nga kukuo mi kael nge oeng sien, “E ta res! Tamtuir! E Iesu a kukuo no.” ");
INSERT INTO tbf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A nga tsion terie man kuirkuir i gege ma a nga rov tamtuir nge nemei se Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","E Iesu a nga vereie, “Misa e lalaron va o ta tsana sevoi?” Mi kael a nga pevien, “Vavvasengei, o lalaron va o ta dedeng.” ");
INSERT INTO tbf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","E Iesu a nga pevien, “Veis! Ke vodovodon tuktuk a te vatoa no.” Ian ngas te, ba katsomatan guor nga katsep ma a nga vemusurie e Iesu i sar. ");
INSERT INTO tbf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sien gi tate nga beit i Betpage ma i Betani simi pout i Oliv vatvatta i Ierusalem, e Iesu a nga turan ken ba madar tovtov luo. ");
INSERT INTO tbf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma a nga oeng seguor, “Ngado rakot simi enamon i muangado, ma sien va ngado ta so beit en, ngado ta so pare mi natu dongki gi pala, ivie ka mei a kap ngas nga kesie. Ngado ta so ruobatie nge kir nemei ngan. ");
INSERT INTO tbf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sien va ka mei ta vosuoreie ngado, ‘Surie misa ngado ta ruobatie ine mi dongki?’ Ngado ta oeng sien, ‘Mi Nguts a pinat surie, ma samo ta ba ture muerngan.’” ");
INSERT INTO tbf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Io, guor nga veis ma guor nga so pare mi natu dongki i marar simi rosar gi ta nga pala simi rumrubukien. Sien guor tate nga ruobatie, ");
INSERT INTO tbf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ba mei gituo ta nga tuir ian en gituo nga vereie guor, “Misa ngado tsana? Surie misa ngado ta ruobatie ian mi natu dongki?” ");
INSERT INTO tbf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Guor nga kuil nama malan e Iesu tate nga vokokotie seguor, ma gituo nga tsupuk rivie guor. ");
INSERT INTO tbf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Guor nga kir nemei ngan mi natu dongki se Iesu. Sien guor ta nga terie maguor sar tsetstseik i popon mi dongki, e Iesu a nga mogos i popon. ");
INSERT INTO tbf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Palan bu mei gi nga peperan magi sar tsetstseik i sar, ma bu mei mene gi nga peperan bu pakapaka bebei ian gi ta nga tara i uot. ");
INSERT INTO tbf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Egie ese gi ta nga muo ma egie ese gi ta nga vemuir, gi nga koupkoup. “Osana!” “E Raban ta vatamase eie ese ta nemei ngan mi asan mi Nguts!” ");
INSERT INTO tbf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“E Raban ta vatamase ken mangmagoso nguts e Davit e tamagiet ian va ta nemei!” “Osana die i kur beitsak!” ");
INSERT INTO tbf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","E Iesu a nga rubukien i Ierusalem ma a nga rakot simi Vona rengeir leong. A nga dedeng veriris sibu kepineits kokouk. Ma sien a te nga reivreiv, e Iesu a nga veis rakot i Betani meie mi sinangavur kes ma luo bu madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Simi ra vemusurie, sien gi tate nga sorvekenan i Betani, e Iesu a nga vitor. ");
INSERT INTO tbf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I pek lili, a nga pare mi ei fik a nga vous nge pakpak, e Iesu a nga rakot sien va ta nga ra pare va a nga vua, o, kap. Sien ta nga me beit simi fik, a kap nga vorotan ka vuovuo, eiekesen bu pakpak mo, simi vunan kap va man vura bu fik nia vua. ");
INSERT INTO tbf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Samo a nga oeng simi ei, “Kap ka mei ta ba buer nganie ka vuovuo sevoi.” Ma ken sar madar tovtov gi nga rongomie misa ta nga pengan. ");
INSERT INTO tbf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sien gi tate nga beit i Ierusalem, e Iesu a nga rubukien i mararan mi Vona rengeir leong, ma a nga vakaek nge kareir vorotsoruo gie ese gi ta nga vevoir ma egie ese gi ta nga terie kegi sar kepineits nia vovoir ian en. Samo a nga vuir matan ngan i keim kegi sar tsur vovvoturu bu mei gi ta nga ververieis nge lakep, ma kegi sar tsur vovvoturu bu mei gi ta nga verikuil nge lakep ngan bu buen. ");
INSERT INTO tbf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma a kap nga sunurie ka mene va ta nga sor kepineits nia vovoir ka i aron mi mararan mi Vona rengeir leong. ");
INSERT INTO tbf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma sien e Iesu ta nga vavasengei segie, a nga pevien, “Mi Pakpak Leong a pevien, “‘Kong vonuo gi ta vuotongie va mi vonuo nia rengeir sibu mei kokouk simi mangmagoso enaenamon.’ Eiekesen enga nga te tsana va ‘magi rie kokkoiv bu ka puerpuer.’” ");
INSERT INTO tbf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bu prist leong ma bu vavvasengei sibu vinuor se Moses gi nga rongomie ine ma gi nga vakaek nge nesie ka rosar nia kenvamate e Iesu. Eiekesen gi nga motovan e Iesu, simi vunan bu mei kokouk gi nga kudier ngan ken sar nama. ");
INSERT INTO tbf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sien tate nga reivreiv seserigo, gi nga veis sorvekenan i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sivovo, sien gi ta nga vor veisveis, gi nga pare ian mi fik tate nga bukuk vakaek sibu pakpak peuk sibu buon. ");
INSERT INTO tbf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","E Petro a nga vodonomie misa e Iesu ta nga pengan ma a nga oeng se Iesu, “Vavvasengei, pare! Ine mi ei fik e ta subiran, a te bukuk!” ");
INSERT INTO tbf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","E Iesu a nga kuil nama, “Nga ta vodovodon tuktuk se Raban. ");
INSERT INTO tbf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","O oeng tuktuk senga. Sien va ka mei ta oeng ine simi pout, ‘Tamtuir nge ra tsibour i rou,’ ma a kap basbaslieng mi aron eiekesen ta vodovodon tuktuk va misa ta vokokotie ta tsorubeit malan, e Raban ta tsang vaotie ine. ");
INSERT INTO tbf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Surie ine, o oeng senga, misa nga ta nongie si kenga sar nono, nga ta vodovodon tuktuk va nga te suvuon, ma e Raban ta terie senga. ");
INSERT INTO tbf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sien va nga ta tuir nge no, vodon rivie bu sinavei tsokor gi ta tsana senga, terengien, e Tamanga die i kur simi rangit ta mang vodon rivie kenga sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eiekesen sien va nga ta kap vodon rivie kegi sar sinavei tsokor, e Tamanga die i kur simi rangit buer ta kap vodon rivie kenga sar sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gi te buer nga beit i Ierusalem, ma sien e Iesu ta nga vor ve veisveis i mararan mi Vona rengeir leong, bu prist leong ma bu vavvasengei sibu vinuor se Moses ma bu muomuo simi kulou gi nga nemei sien. ");
INSERT INTO tbf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma gi nga virei, “Ngan ke sana duis, e tsana ine bu kepineits? Ma ese a terie sevoi mi duis nia tsana ine?” ");
INSERT INTO tbf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","E Iesu a nga kuil nama, “O ta vereie nga ngan mi virevirei kes ma nga ta pengan seou, va o ta mang pengan senga ngan mi sana duis o tsana ine bu kepineits. ");
INSERT INTO tbf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ken sinusuruiv e Ioanes, a nga kovuni se Raban, o, a nga kovuni simi kulou? Nga pengan seou!” ");
INSERT INTO tbf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gi nga vevuran i kotubugie kesegie ma gi nga pevien, “Sien va giet ta pevien, ‘A kovuni se Raban,’ e Iesu ta virei, ‘Ma surie misa nga ta kap nga vodovodon tuktuk sien?’ ");
INSERT INTO tbf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eiekesen sien va giet ta pevien, ‘A kovuni simi kulou,’ mi kulou gi ta matakorot nge giet.” (gi nga motovan mi kulou simi vunan mi kulou kokouk gi nga vodovodon tuktuk va e Ioanes eie mi propet tuktuk.) ");
INSERT INTO tbf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Io, gi nga kuil nama se Iesu, “Gei kap telekiran.” E Iesu a nga pevien, “Eou buer o ta kap pengan senga mi sana duis o tsana ngan ine bu kepineits.” ");
INSERT INTO tbf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","E Iesu a nga vakaek nge vokokotie bu nama puppuo segie, “Mi ka a nga tsuorkie mi tau vain, ma a nga oir viririsie. Samo a nga tsuopuo mi mat nia pop poltsan bu kievkiev vain. Ma i muir, a nga tsana mi vonuo nennei tau. I muir sien, a nga oeng terie simi kulou tsuotstsuor meie ngan mi kinubuits va bu kievkiev vain mene, magi voirvoir te. Ma a nga veis rakot simi enamon i pek. ");
INSERT INTO tbf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Io, simi ra mi tau tate nga komois te, a nga turan ken petspets rakot simi kulou tsuotstsuor nia ra poro ken potpot eie sibu kievkiev vain. ");
INSERT INTO tbf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eiekesen gi nga rakopie ine mi petspets nge tsatsakie. Ma gi nga ture muerngan riem kapasen. ");
INSERT INTO tbf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Samo a nga turan ken petspets mene te buer. Ma gi nga nis porie mi kovan ma gi nga tsang vatsakatie nge mamangarie. ");
INSERT INTO tbf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A te buer nga turan mi mei mene ma ian mi mei gi nga kenvamate. Ma a nga turan te buer palan ken sar petspets mene, bu mei mene gi nga tsatsakie gie, ma bu mei mene gi nga kenvamate gie. ");
INSERT INTO tbf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“A te nga suvuon mo ken mei kes nia turan. Eie e natuon tamat mi aten. I muir rovrovoriu sien kap te ka mei nia turan, a nga turan e natuon rakot ian simi kulou tsuotstsuor. Eie a nga vodon nge kia, ‘Gi ta mang so mangaran e natung.’ ");
INSERT INTO tbf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Eiekesen mi kulou tsuotstsuor, gi nga roev i kotubugie ine, ‘Arie eie ta so suvuon bu sinsuv se taman. Nga lapus, giet ta kenvamate. Ma bu kepineits ian va ta so suvuon, segiet mang.’ ");
INSERT INTO tbf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Io, gi nga rakopie nge kenvamate ma gi nga tomekan die i muirmuir simi tau. ");
INSERT INTO tbf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Mi sana nieng, e taman mi tau ta tsana? Ta nemei nge voguersan ine mi kulou tsuotstsuor ma ta terie mi tau simi kulou tsuotstsuor mene. ");
INSERT INTO tbf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vasa, nga kap nga ase ine mi vinavataor simi Pakpak Leong ian ta pevien, “‘Mi vout mi kulou tsangtsang vonuo gi ta nga purusie, a me tsorubeit mi vout mogos; ");
INSERT INTO tbf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mi Nguts a nga tsana ine, ma a matmatot si kegiet baidendeng.’” ");
INSERT INTO tbf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bu muomuo sibu Iuda gi nga nesie ka rosar nia rakopie e Iesu, simi vunan gi nga rong telekiran va e Iesu a nga vokokotie ine mi nama puppuo surie gie. Eiekesen gi nga motovan mi bineit, ma gi nga veis sorvekenan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Io, gi nga turan bu Parisaio ma mi gargar se Erot rakot se Iesu nia ruom tsang nama sien. ");
INSERT INTO tbf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gi nga nemei sien ma gi nga pevien, “Vavvasengei, gei telekiran va evoi mi ka simi tuktuk. E kap ko vemusurie mi tinatakien ka mei mene, eiekesen e ko vavasengei ngan mi saran e Raban ngan mi tuktuk. Vasa, a duis nia voir takis rakot se Kaesar, o, kap? ");
INSERT INTO tbf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Vasa, giet ta ngas vovoir, o, giet ta kap vovoir?” Eiekesen e Iesu a te nga telekiran kegi vinirei binit ma a nga virei, “Surie misa nga ta lalaro virei bitie iou? Nga terie seou ka silva lakep sibu Roma va o ta pare.” ");
INSERT INTO tbf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gi nga por terie mi silva lakep sien, ma e Iesu a nga vereie gie, “Mi patsapatsan ma mi asan ese a mon ine simi lakep?” Gi nga kuil nama, “E Kaesar!” ");
INSERT INTO tbf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Samo e Iesu a nga oeng segie, “Terie rakot se Kaesar ian se Kaesar, ma terie rakot se Raban ian se Raban.” Ma gi nga kudier beitsak sien. ");
INSERT INTO tbf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Samo bu Sadukaio ese gi ta pevien va kap ka tino mumuerengei, gi nga nemei se Iesu ngan mi virevirei. ");
INSERT INTO tbf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma gi nga vereie, “Vavvasengei. E Moses a nga vavataor vunie giet ven ne, ‘Sien va ka ka ta maet sorvekenan ken vevien ma a kap ka natuon, ka kasien tuir muir ta ngas reie ine mi vevien ma ta suvu nout ken e kasien.’ ");
INSERT INTO tbf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Io, mi napaririem potsu luo bu baser kasien gi nga mon. Mi muariem a nga rei ma a nga maet sorvekenan ken vevien ma kap ka natuon. ");
INSERT INTO tbf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","E kasien a luongan a nga reie ine mi vevien, eiekesen eie buer a nga maet, ma kap ka natuon. A nga kokouk malan mo se kasien a tourngan. ");
INSERT INTO tbf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Io, kap ka mei ine sibu baser kasien mi napaririem potsu luo a nga suvu madar. Vevemuir te, ine mi vevien a nga maet buer. ");
INSERT INTO tbf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Simi tino mumuerengei, surie ine mi napaririem potsu luo bu baser kasien gi ta nga reie ine mi vevien, ese te ken vevien segie?” ");
INSERT INTO tbf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","E Iesu a nga kuil nama, “Surie misa nga ta tsana ine mi bienebeir? Vasa, nga kap katsep simi namanien mi Pakpak Leong, o, mi ngesengesien e Raban? ");
INSERT INTO tbf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Simi tino mumuerengei, gi ta kap so rei ma vavuo gie te buer, eiekesen gi ta tsorubeit malan bu angelo simi rangit. ");
INSERT INTO tbf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Io, surie mi tino mumuerengei, vasa, nga kap nga ase mi vinavataor se Moses surie mi ei to ta nga ngang? Ian en, e Raban a nga oeng se Moses ‘Eou man Raban e Abaraam, man Raban e Isak, ma man Raban e Iakop.’ ");
INSERT INTO tbf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eie kap va magi Raban bu mei maet, eiekesen magi Raban bu mei gi ta tino. Enga nga te bebeir kalei te!” ");
INSERT INTO tbf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mi vavvasengei sibu vinuor se Moses a nga nemei nge rongomie gie gi ta nga vevuor. A nga pare va e Iesu a nga terie segie bu banga nama kuilkuil. Samo a nga vereie e Iesu, “Mi sana vinuor a tsiroup sibu vuna vinuor kokouk?” ");
INSERT INTO tbf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","E Iesu a nga kuil nama, “Mi vinuor ian ta tsiroup segie kokouk, a malan ne, ‘Rorong, Israel, mi Nguts magiet Raban, eie mi Nguts a kes mo. ");
INSERT INTO tbf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma e ta ngas lalaron beitsak mi Nguts ma Raban ngan mi aro kokouk ma mi morumorua kokouk ma mi vinavinadodo kokouk, ma mi ngisingisi kokouk.’ ");
INSERT INTO tbf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mi vuna vinuor a luongan a malan ne, ‘E ta ngas tovie e palapala malan e ta tovie no kese.’ A kap kavo vinuor mene a tsiroup rio ine ba vuna vinuor.” ");
INSERT INTO tbf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ine mi vavvasengei sibu vinuor a nga pevien, “Vavvasengei, ke banga nama kuilkuil. A tuktuk e ta vakokoit malan ine. E Raban a kes mo, ma a kap ka mei mene te buer. ");
INSERT INTO tbf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mi ka ta ngas lalaron beitsak e Raban ngan mi aron kokouk ma ken teletelekirei kokouk ma ken ngeisngeis kokouk. Ma eie ta ngas tovie bu palapalan malan ta tovie eie kesen. Ine ba vinuor a tsiroup rio kokouk bu tintu ma bu tienebeir ni varam.” ");
INSERT INTO tbf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","E Iesu a nga pare va ine mi vavvasengei sibu vinuor a nga kuil vakalaie ken nama, ma a nga oeng sien, “E kap mon i pek nia tsorubeit mi meinmenigie mi kulou ese gi ta mon i pakien ken vinuor e Raban.” Ma i murien ian, kap ka mei a ba nga vanvando vereie te buer. ");
INSERT INTO tbf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","E Iesu a nga vavasengei i mararan mi Vona rengeir leong ma a nga virei, “Surie misa bu vavvasengei sibu vinuor se Moses gi ta nga pevien ngan mi Messia va eie e Natuon e Davit? ");
INSERT INTO tbf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mi Moromoruo Tamat a nga teir vienviendon se Davit va ta nga vakokoit katsep ngan: “‘E Raban a nga pevien si mong Nguts: “Mogos si kong riem suv, oit va o ta terie ma sar matakorot i pakien ba naparikame.” ’ ");
INSERT INTO tbf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","E Davit kesen a nga vuotongie mi Messia va ‘mi Nguts’. Vasa ta me beit ven va mi Messia eie e Natuon e Davit?” Mi bineit leong gi nga rorong se Iesu ngan mi nires. ");
INSERT INTO tbf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sien e Iesu ta nga vavasengei, a nga pevien, “Nga ta nenei kalei nge nga kesenga sibu vavvasengei sibu vinuor. Gi ko lalaro vakam nge veis tateie magi sar tsetstseik kuar, ma gi ko lalaron va mi kulou gi ta ve mangara gie sibu korot nia verikuil nge kepineits. ");
INSERT INTO tbf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma gi ko lalaron kegi sar mogomogos bu muomuo si kegi sar vona rengeir ma kegi sar mogomogos mi kulou asna sibu nginou. ");
INSERT INTO tbf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gi ko bit tsana kegi sar kepineits bu vevien naor gi tate mamaet labeit. Ma gi ko vakam nge vuotongie kegi sar nono kuar. Mi sua kulou ine, gi ta so suvuon mi vinatoreis leong.” ");
INSERT INTO tbf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E Iesu a nga mogos matan veie mi korot teteir tienebeir simi Vona rengeir leong, ma a nga pare gie gi ta nga terie kegi sar lakep i aron ine mi korot teteir lakep. Palan mi kulou suvuram gi nga terie kegi sar lakep leong. ");
INSERT INTO tbf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eiekesen mi vevien sinaortsak tate nga mamaet labeit a nga nemei nge terie ba natunatu lakep luo mi putu sien a oit malan mi toea kes mo. ");
INSERT INTO tbf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","E Iesu a nga kukuo ken sar madar tovtov ma a nga oeng segie, “O oeng tuktuk senga, ine mi vevien sinaortsak a terie mi tienebeir leong beitsak rio bu mei mene gi ta teteir. ");
INSERT INTO tbf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Egie kokouk gi terie mo mi mememoruon kegi sar sinsuv, eiekesen ine mi vevien si ken mienagos ni sinaortsak, a teir vuruvan te ken sar sinsuv kokouk ian ta oit nia tino ngan.” ");
INSERT INTO tbf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sien e Iesu tate nga sorvekenan mi Vona rengeir leong, mi meinmenien ken sar madar tovtov a nga pevien sien, “Pare, vavvasengei! Madar! Vasa ine bu banga vout ma bu banga vonuo!” ");
INSERT INTO tbf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","E Iesu a nga kuil nama, “E pare ine bu vonuo leong? Kap ka vout kes ta so muturungie ka turan vout. Bu vout kokouk gi ta vatsarerie vuturungie gie i keim.” ");
INSERT INTO tbf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sien e Iesu ta nga mogos simi pout i Oliv matan veie mi Vona rengeir leong, e Petro, e Iakobo, e Ioanes, ma e Andre gi nga virei menentan, ");
INSERT INTO tbf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Pengan segei, venenges ine bu kepineits ta ba tsorubeit? Ma bu sana totourlekier gi ta me vara tuktuk ngan?” ");
INSERT INTO tbf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","E Iesu a nga oeng segie, “Nga ta ngas nenei kalei va kap ka mei ta bitie nga. ");
INSERT INTO tbf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Palan bu mei gi ta nemei ngan mi asoung nge pevien, ‘Arie eou mi Karisito ine.’ Ma gi ta bitie palan bu mei. ");
INSERT INTO tbf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sien va nga ta rongovan bu vinevineken vatavatat ma bu nama i sar surie bu vinevineken i pek, kian va nga ta kudier tsak. Bu suasuada kepineits malan ine ta ngas tsorubeit, eiekesen man votovoto ine mi kaber ta kap ngas beit. ");
INSERT INTO tbf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ka enamon mene ta tamtuir nge makiur meie ka enamon mene, ka mangmagoso nguts mene ta makiur meie ka mangmagoso nguts mene. Kavo enamon mene gi ta suvuon mi oen leong ma bu se. Ine bu kepineits ta malan man vakavakaek mi vinavasor simi vevien va ta por madar. ");
INSERT INTO tbf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nga nenei kalei. Gi ta rakopie nga nge voturie nga i matan bu ka simi vinuor, ma gi ta tsatsakie nga i aron bu vona rengeir sibu Iuda. Surie mi asoung, gi ta voturie nga i matan bu gavana ma bu kovakova ka leong, terengien va nga ta mang vakokoit vakatsepa gie ngan mi Banga Vinavatei. ");
INSERT INTO tbf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eiekesen i muan man votovoto mi mangmagoso enaenamon va ta tsorubeit, gi ta ngas muna vavatei ngan mi Banga Vinavatei sibu vuna enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sien va gi ta rakopie nga nge kerie nga rakot simi vinuor, kian va nga ta vodovodon palan surie mi sana nama va nga ta so vokokotie simi keipkepide ra nia vuor nama. Nga ta so vokokotie mi sana kepineits mi Moromoruo Tamat ta terie senga ian simi keipkepide ra, simi vunan kap va enga nga ta so vakokoit, eiekesen mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ka ka ta so roev terie e kasien simi miensei, ma ta malan buer mo, si kaba baser taman. Bu madar gi ta so matakorot meie bu tamagie ma bu kinagie ma gi ta terie bu tamagie ma bu kinagie simi miensei. ");
INSERT INTO tbf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mi kulou gi ta so matakorot nge nga surie mi asoung, eiekesen eie ese ta so tuir ngeisngeis oit simi ra vekvekitip, mi Nguts ta so vatoa. ");
INSERT INTO tbf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nga ta ba pare ‘mi kepineits ta molubiets’ va ta tuir simi korot tamat ivie ta kap oit va ta tuir en. (Mi mene ta ase ine mi nama, ta ngas katsep.) Sien va ine mi kepineits ta beit, egie ese gi ta mon i Iudea, gi ta ngas vi ra kien sibu pout. ");
INSERT INTO tbf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Eie ese ta mon i pungan ken vonuo, kian va ta tsour nge rubukien nia poro ken sar kepineits. ");
INSERT INTO tbf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma buer eie ese ta mon i tau, kian va ta muerengei nia poro man kuirkuir. ");
INSERT INTO tbf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lavei! Mi masitinoiv leong segie mi langei gi ta tian ma mi langei vusus ian simi keipkepide ra! ");
INSERT INTO tbf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nga no va ine bu kepineits tsokor gi ta kap mang beit sibu rangi bat, ");
INSERT INTO tbf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","simi vunan ian simi ra mi tsienakor leong beitsak ta so beit, ian ta kap nga tsorubeit vakaek si man tsuoktsuok vakaek mi vinagoso oit nevere, ma i murien ta kap kavo kepineits tsak malan te buer. ");
INSERT INTO tbf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sien va e Raban a kap nga por potiepotien ine bu ra, va kap ka mei a to. Eiekesen surie ken kulou vivviel, a te por potiepotien ine bu ra. ");
INSERT INTO tbf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ian sibu ra, sien va ka mei ta pevien senga, ‘Pare, ine arie mi Messia o, eie nikot!’ kian va nga ta vodovodon tuktuk sien, ");
INSERT INTO tbf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","simi vunan bu messia bitbit ma bu propet bitbit gi ta beit. Ma gi ta so tsana bu suasuada totourlekier ma bu kepineits ni vovokudier. Sien va ta oit, gi ta bit tsana ken kulou vivviel e Raban. ");
INSERT INTO tbf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Io, nga nenei kalei. Pare! O te muna pengan senga ine bu kepineits i muan va gi ta ba so beit.” ");
INSERT INTO tbf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ian sibu ra, vemusurie ine bu ra ni vinekikin tsokor, “‘mi matanias ta so rar bungou, ma mi vura ta kap so puits; ");
INSERT INTO tbf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bu kaemkaem gi ta so kor kovuni simi rangit, ma man sar ngeisngeis mi mariu gi ta so moruor.’ ");
INSERT INTO tbf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ma gi ta pare e Natuon mi Ka va ta nemei i popon mi balbal meie mi ngeisngeis leong ma mi matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma e Raban ta turan ken sar angelo nia kir kakaku gie ken kulou vivviel kuvu siba matamour voveit, kovuni simi tangatson mi mangmagoso enaenamon, oit simi tangaots ka ie. ");
INSERT INTO tbf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nga ta por vavakatsep simi sinavien mi ei fik. Sien va bu rakarakan va gi tate beit mangmangeda ma vakaek nge bira, nga ta telekiran va man vura mi parpar a te vatavatat. ");
INSERT INTO tbf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Io, sien va nga ta pare ine bu kepineits gi ta vor ve tsotsorubeit, nga ta telekiran va a te vatavatat ian mi ra. ");
INSERT INTO tbf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","O oeng tuktuk senga, mi kuoluon ine bu ra gi ta kap ngas voto rovoriu tuir oit ine bu kepineits kokouk ta tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mi rangit ma mi kaber ta so voto eiekesen kong sar nama ta kap so voto. ");
INSERT INTO tbf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kap ka mei a telekiran venenges ian mi ra ma mi keipkepide ra va ta tsorubeit. Bu angelo simi rangit ma e Natuon buer gi kap telekiran, eiekesen mi Tam kesen mo a telekiran. ");
INSERT INTO tbf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nga ta nenei kalei ma nga ta mat panpan! Simi vunan nga kap telekiran venenges ine mi ra va ta beit. ");
INSERT INTO tbf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ine mi ra ta malan mi ka ta nga veis sorvekenan ken vonuo rakot simi enamon i pek. Ma a nga teir tsientsang vovokes si ken sar petspets. Ma a nga oeng simi petspets ta nga naneie mi matavanuo va ta nga nennei kalei. ");
INSERT INTO tbf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Io, nga nenei kalei, simi vunan nga kap telekiran venenges e taman ian mi vonuo va ta muerengei. Tavakier, sireivreiv, o, sikati potaram, o, simi to ta kurkuku, o, sivovo mokuopkuop. ");
INSERT INTO tbf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sien va ta muerengei lalapus, ta masi me vorota no va e ta mon muang. ");
INSERT INTO tbf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Misa o pengan senga, o pengan sibu mei kokouk. ‘Nga nenei kalei!’” ");
INSERT INTO tbf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ba ra a te nga luo karie mo, mi Nginu Pasova ma nian mi Tsoik kap ka iis sien. Bu prist leong ma bu vavvasengei sibu vinuor se Moses gi nga vor ve nesienesie ka rosar nia raok menentan nge kenvamate e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Eiekesen gi nga pevien, “Kian va giet ta tsana i kinorotuon mi nginou. Mi kulou gi ta masi tsuok vakake ka tseng.” ");
INSERT INTO tbf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Simi ra mene sien e Iesu ta nga mon i Betani, a nga mogos i bingan mi tsur ngongou i aron ken vonuo e Simon ese ta nga suvuon mi mienarouk lepra muomuo. Sien ta nga mon ian en, mi vevien a nga nemei ngan mi utut vout ta nga vous ngan mi da sosong gi ta tsana ngan mi dangien mi nat matan kesen. Man voirvoir ine mi da sosong a vaen beitsak. A nga porie mi ngutsuon ine mi utut, ma a nga soan mi da sosong i kovan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bu mei mene segie gi ta nga mon, gi nga petseir nge oengoeng palan, “Surie misa ta soe tuvuon ngan ine mi da sosong? ");
INSERT INTO tbf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ine mi da sosong, a oit va giet ta verikuil ngan ba sinangavur tour koboit (300) bu lakep denari. Ma ian mi lakep giet oit nia terie sibu sinaortsak.” Ma gi nga nasaran ine mi vevien. ");
INSERT INTO tbf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","E Iesu a nga pevien, “Nga tsupuk rivie. Surie misa nga ta nama palan ngan ine mi vevien? Eie a tsana mi banga kepineits seou. ");
INSERT INTO tbf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bu sinaortsak gi ta mon meie nga sibu ra kokouk, ma nga ta oit nia kulie gie sibu ra sien va nga ta lalaron. Eiekesen eou o ta kap mon meie nga sibu ra kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ine mi vevien a te tsana misa a oit va ta tsana. A soan mi da sosong i kurikuriung nian kong mintur i aron mi monmon i muan kong miensei. ");
INSERT INTO tbf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","O oeng tuktuk senga, simi sana korot simi mangmagoso enaenamon gi ta vavatei ngan en mi Banga Vinavatei, mi sana kepineits ine mi vevien ta tsana gi ta vavatei ngan buer nia vodonomie ngan eie.” ");
INSERT INTO tbf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Samo e Iudas Iskariot, mi meinmenien mi sinangavur kes ma luo bu madar tovtov, a nga rakot sibu prist leong nia roev terie e Iesu segie. ");
INSERT INTO tbf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Gi nga res beitsak nia rongomie ine mi namanien ma gi nga kukubuits nia teir lakep sien. Io, e Iudas a nga dedeng ngan ka kientsep nia roev terie e Iesu segie. ");
INSERT INTO tbf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mi ra vourvour simi nginou nian mi Tsoik kap ka iis sien, a te nga beit va gi ta keda sien ka natu sipsip va mi tienebeir ni varam simi Nginu Pasova. Io, ken sar madar tovtov e Iesu gi nga vosuoreie, “Ivie e lalaron va gei ta rakot nge rorois ngan en mi Nginu Pasova va e ta ra nganie?” ");
INSERT INTO tbf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Io, a nga turan ken ba madar tovtov luo ma a nga oeng seguor, “Ngado rubukien i Ierusalem, ma ngado ta so vesuei meie mi ka a sorokie ken utut mi da sien. Ngado ta so vemusurie. ");
INSERT INTO tbf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma ngado ta so oeng se taman mi vonuo ine mi ka ta rubukien en ven ne, ‘Mi vavvasengei a virei, “Iva ngan mi roruom ken bu vasier va o ta nganie en mi Nginu Pasova meie kong sar madar tovtov?” ’ ");
INSERT INTO tbf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eie ta vasangan sengado mi roruom leong i kur, bu mogomogos ma mi tsur ngongou a mon en. Ngado ta ra tsang rorrois ngan mi nginonginou niagiet ian en.” ");
INSERT INTO tbf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ba madar tovtov guor nga veis rubukien i Ierusalem nge vorotan bu kepineits kokouk malan mo e Iesu tate nga vokokotie seguor. Io, guor nga tsang rorrois ngan mi Nginu Pasova en. ");
INSERT INTO tbf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sien tate nga reivreiv seserigo, e Iesu meie ken sar madar tovtov mi sinangavur kes ma luo gi nga beit. ");
INSERT INTO tbf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sien gi tate nga mogos viririsie mi tsur ngongou nge ngou, a nga pevien, “O oeng tuktuk senga, ka mei senga ese ta ngou meie iou ta roev terie iou simi matakorot.” ");
INSERT INTO tbf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gi nga mesirik, ma egie keskes gi nga vereie e Iesu, “A tuktuk, kap va eou, va gerek?” ");
INSERT INTO tbf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","E Iesu a nga kuil nama, “Mi mei senga mi sinangavur kes ma luo, ese ta tsonga mi poko tsoik meie iou i aron mi koi ngongou, arie eie. ");
INSERT INTO tbf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","E Natuon mi Ka ta mesei vemusurie malan mo mi Pakpak Leong ta vakokoit. Eiekesen, mi tsienakor leong simi ka ese va ta roev terie iou simi matakorot! Ta kalei sien va gi kap nga kava.” ");
INSERT INTO tbf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sien gi tate nga vor ve ngongou, e Iesu a nga poro mi tsoik nge vuot kalei se Raban ma a nga potakie nge terie si ken sar madar tovtov. Ma a nga pevien, “Nga poro nge nganie, ine arie mi piripiriung.” ");
INSERT INTO tbf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Samo, a nga poro mi koi unun ma a nga vuot kalei ngan se Raban ma a nga vetserie segie ma egie kokouk gi nga un sien. ");
INSERT INTO tbf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A nga oeng segie, “Ine arie mi daroung nian mi kinubuits vour va ta tamasoei nian bu mei palan. ");
INSERT INTO tbf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","O oeng tuktuk senga, o ta kap ba buer unumie mi dangi vuavua vain oit simi ra va o ta nangba so unumie mi dangi vain vour i aron ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sien gi tate nga keveir vaton mi paka rengeir, gi nga veis rovotsour rakot simi pout i Oliv. ");
INSERT INTO tbf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","E Iesu a nga pevien segie, “Enga kokouk nga ta so murien veie iou surie mi Pakpak Leong a pevien ne, “‘O ta keda mi ka nennei sipsip, ma bu sipsip gi ta vi vepitsitsei.’ ");
INSERT INTO tbf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Eiekesen i murien va o ta to muerengei simi miensei, o ta muo senga rakot i Galili.” ");
INSERT INTO tbf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","E Petro a nga oeng sien, “Misasien va egie kokouk gi ta murien veie no, eou o ta kap.” ");
INSERT INTO tbf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","E Iesu a nga oeng sien, “O oeng tuktuk sevoi. Ine sikati ngas te i muan va mi to ta kurkuku vuluo, evoi kese ngas te, e ta so vamoie iou votour.” ");
INSERT INTO tbf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eiekesen e Petro a nga vakokoit ngeisngeis, “Misasien va o ta so mesei meie no, o ta kap oit nia vamoie no.” Ma egie kokouk gi nga vakokoit malan buer. ");
INSERT INTO tbf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gi nga rakot simi korot gi ta nga vuotongie ngan i Getsemane, ma e Iesu a nga oeng si ken sar madar tovtov, “Nga mogos en ne. O ta ra no.” ");
INSERT INTO tbf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A nga kerie e Petro, e Iakobo ma e Ioanes, ma a nga vakaek nge rongmetsikien mi putu ma mi masitinoiv leong. ");
INSERT INTO tbf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma a nga oeng segituo, “Mi aroung a te vous ngan mi aor tsak ma a te vatvatta kenvamate iou. Ngatuo ta mon en ne nge nennei.” ");
INSERT INTO tbf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A nga veis rakot lili sorvekena gituo. Ma a nga tsibour mutur simi kaber. Ma a nga no va ine mi keipkepide ra ta mang nga evisie sien va a oit. ");
INSERT INTO tbf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A nga no, “Abba, Tama, bu kepineits kokouk a oit mo va e ta tsana. Por tsana seou ine mi koi simi vinekikin. Eiekesen vemusurie ke lalaron ma a kap va kong lalaron.” ");
INSERT INTO tbf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Samo e Iesu a nga muerengei rakot si ken ba madar tovtov ma a nga vorota gituo gituo ta nga muang. A nga oeng se Petro, “Simon Petro, e muang? A kap oit va e ta pan meie iou si ka aua kes? ");
INSERT INTO tbf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngatuo ta pan nge no, terengien ngatuo ta kap mang kor simi konokonon. Mi moromoruo a sunuir, eiekesen mi pirpir a kap suvu ngeisngeis.” ");
INSERT INTO tbf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","E Iesu a te buer nga veis sorvekena gituo nge ra no malan mo vourvour. ");
INSERT INTO tbf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sien ta nga muerengei, a te buer nga me vorota gituo gituo ta nga muang, simi vunan bu katsomatagituo a nga putu. Gituo kap nga telekiran misa va gituo ta nga pengan sien. ");
INSERT INTO tbf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sien ta nga muerengei votour ngan, a nga oeng segituo, “Ngatuo ngas vor ve mumuang mo nge maes? A te oit! Mi keipkepide ra a te beit. E Natuon mi Ka gi tate roev terie i riman bu ka tsokor. ");
INSERT INTO tbf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ngatuo tamtuir! Giet tate ra! Pare, eie te mi ka va ta roev terie iou i rimagie bu ka tsokor!” ");
INSERT INTO tbf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ian ngas te, sien ta ngas nga vor ve vakvakokoit, e Iudas mi meinmenien mi sinangavur kes ma luo bu madar tovtov a nga beit. Mi kulou palan gi nga nomeie ma gi nga sorokie kegi sar kuor ma bu bam. Bu prist leong ma bu vavvasengei sibu vinuor se Moses ma bu muomuo simi kulou gi nga tura gie. ");
INSERT INTO tbf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Io, ine mi ka ni roev terie e Iesu a te nga rove mi totourkilal meie gie ven ne, “Mi mei ese o ta so ngungurie, arie eie mi ka. Nga ta rakopie. Ma nga ta rur kitipan si ken sar madar tovtov.” ");
INSERT INTO tbf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","E Iudas a nga lalapus rakot se Iesu ma a nga pevien, “Vavvasengei!” Ma a nga ngungurie. ");
INSERT INTO tbf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mi kulou gi nga rakopie e Iesu nge visie. ");
INSERT INTO tbf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Samo mi mene segie ese ta nga tuir vatavatat, a nga teie vorotsoruo ken kuor ma a nga tseir rivie mi tateringan ken petspets mi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Samo a nga oeng simi kulou, “Vasa, nga kia va eou mi ka kenken? Arie mi vunan nga te nemei ngan bu kuor ma bu bam nia me rakopie iou? ");
INSERT INTO tbf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sibu ra kokouk o nga mon meie nga nge vavasengei i mararan mi Vona rengeir leong ma nga kap nga rakopie iou. Eiekesen ine bu kepineits a tsorubeit nia vaotie bu nama simi Pakpak Leong.” ");
INSERT INTO tbf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Samo ken sar madar tovtov kokouk gi nga sorvekenan nge vi. ");
INSERT INTO tbf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mi ka vour a nga vemusurie e Iesu ma a nga kukuov ngan mi lavlav mo. Sien gi tate nga rakopie e Iesu, ");
INSERT INTO tbf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ine mi ka vour a nga soer sorvekenan ken lavlav ma a nga vi beol. ");
INSERT INTO tbf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gi nga kerie e Iesu rakot simi kovan bu prist. Ma bu prist leong kokouk, bu muomuo simi kulou ma bu vavvasengei sibu vinuor se Moses gi nga beit kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","E Petro a nga vemusurie e Iesu i pek lili oit a nga rubukien i mararan ken vonuo mi kovan bu prist. Ian en, a nga mogos meie mi kulou nennei ma a nga miriur simi leing. ");
INSERT INTO tbf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bu prist leong ma mi Sanedrin kokouk, gi nga nesie kavo nama vinepipits nia vuortie e Iesu, terengien va gi ta mang nga oit nia kenvamate, eiekesen gi kap nga vorotan kavo nama. ");
INSERT INTO tbf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Palan bu mei gi nga vokokotie bu suasua nama binit veie. Eiekesen kegi sar nama gi kap nga soer kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Samo, bu mei gi nga tamtuir ma gi nga vokokotie ine bu namani binit surie eie, ");
INSERT INTO tbf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Gei nga rongomie a nga pevien malan ne, ‘O ta vatsarerie ine mi Vona rengeir leong mi kulou gi ta nga tsana. Ma i murien ba ra tour, o ta tsana mi mene ian mi ka ta kap oit nia tsana.’” ");
INSERT INTO tbf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eiekesen kegi sar nama gi kap ngas nga soer kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Samo mi kovan bu prist a nga tsik tamtuir i matagie ma a nga vereie e Iesu, “Vasa, e ta kap kulie ka nama ine sibu nama mi kulou gi ta vepitsie no ngan?” ");
INSERT INTO tbf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Eiekesen e Iesu a nga tuir bong mo ma a kap nga kuil nama. Mi kovan bu prist a te buer nga vereie e Iesu, “Arie evoi mi Messia e Natuon e Raban ese giet ta ko puongan.” ");
INSERT INTO tbf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","E Iesu a nga pevien, “Arie eou mo, ma e ta ba pare va e Natuon mi Ka ta mogos si ken riem suv e Raban a ngeisngeis beitsak ma ta nemei i popon bu balbal simi mariu.” ");
INSERT INTO tbf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mi kovan bu prist a nga derikie man kuirkuir nge pevien, “Surie misa giet ta pinat surie ka nama mene te buer nia vuortie? ");
INSERT INTO tbf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nga te rongomie ine mi namani oeng balapoik ngan e Raban. Vasa kenga vienviendon?” Egie kokouk gi nga vuor terie e Iesu simi miensei malan va a nga tsana ka tsaka sinavei ian ta otien mi miensei. ");
INSERT INTO tbf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Samo bu mei gi nga vakaek nge kientsuo ma gi nga rorotsie mi poko lavlav i matan ma gi nga tutuo ngan bu rimagie ma gi nga pevien, “Pengan ese a tutuo no!” Ma mi kulou nennei gi nga kerie nge tsatsakie. ");
INSERT INTO tbf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sien e Petro ta nga mon i keim simi marara vuor nama, mi vevien petspets simi kovan bu prist a nga ra nemei. ");
INSERT INTO tbf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sien ta nga pare e Petro ta nga mariur, ine mi vevien a nga deng vangvangasie. Ma a nga pevien, “Evoi buer e nga ko mon meie e Iesu kovuni i Nasaret.” ");
INSERT INTO tbf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eiekesen e Petro a nga vamoi. Ma a nga pevien, “O kap telekiran, o, o kap katsep simi sana e ta vokokotie.” Ma a nga veis rakot simi rumrubukien ian simi marara vuor nama. Samo mi to a nga kurkuku. ");
INSERT INTO tbf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sien ine mi vevien petspets ta nga pare eie ian en, a te buer nga oeng segie ian gi ta nga tuir kouk, “Ine mi ka, eie mi meinmenigie.” ");
INSERT INTO tbf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E Petro a te buer nga vamoi. I muir lili, egie gi ta nga tuir kouk, gi nga pevien se Petro, “A tuktuk, evoi mi meinmenigie, simi vunan evoi mi kangi Galili buer.” ");
INSERT INTO tbf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Samo a nga vakaek nge vakavakariem ngan e Raban i matagie, “O kap telekiran ian mi ka nga ta pepengan.” ");
INSERT INTO tbf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ian ngas te, mi to a nga kurkuku vuluongan. Samo, e Petro a nga vodonomie mi nama e Iesu ta nga vokokotie sien ven ne, “I muan va mi to ta kurkuku vuluo, e ta vamoie iou votour.” Ma a nga tsuok nge tina. ");
INSERT INTO tbf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsourvovo mokuopkuop, bu prist leong ma bu kovakova ka meie bu vavvasengei sibu vinuor ma mi Sanedrin kokouk, gi nga beit simi vienviendon kes. Ma gi nga visie e Iesu nge kir rakot ngan ma gi nga terie i napariman e Pilato. ");
INSERT INTO tbf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","E Pilato a nga vosuoreie, “Arie evoi mi kovakova ka leong sibu Iuda?” E Iesu a nga kuil nama, “A malan e tate vuotongie.” ");
INSERT INTO tbf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bu prist leong gi nga vepitsie ngan bu kepineits palan. ");
INSERT INTO tbf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Samo e Pilato a te buer nga vosuoreie, “Vasa, e ta kap kulie ka nama? Pare, a vovies bu kepineits palan gi ta vepitsie no ngan.” ");
INSERT INTO tbf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Eiekesen e Iesu a kap nga kuil nama te, ma e Pilato a nga kudier ngan. ");
INSERT INTO tbf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sibu Nginu Pasova kokouk, mi gavana a nga ko ruom rivie ka ka tsatsang vinatoreis vemusurie kegi lalaron mi kulou. ");
INSERT INTO tbf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mi ka mi asan e Barabas a nga mon simi vona vinatoreis meie egie ese gi ta nga ko matakorot meie mi gavaman. Gi nga kenvamate bu mei sien gi ta nga mon simi tseng leong. ");
INSERT INTO tbf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mi bineit gi nga beit nge vosuoreie e Pilato va ta nga ruom rivie ka ka tsatsang vinatoreis malan ta nga ko munu tsana. ");
INSERT INTO tbf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","E Pilato a nga virei, “Nga lalaron va o ta ruom terie senga ine mi kovakova ka leong sibu Iuda?” ");
INSERT INTO tbf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A nga telekire vititirie va bu prist leong gi nga terie e Iesu i napariman simi vunan gi nga ngungutsuo surie ken tsientsang. ");
INSERT INTO tbf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eiekesen bu prist leong gi nga tut ka i murien mi bineit va e Pilato ta nga ruom rivie e Barabas rakot segie nia verikulie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","E Pilato a nga vereie gie, “Misa o ta tsana sien ine mi ka nga ta vuotongie va eie mi kovakova ka leong sibu Iuda?” ");
INSERT INTO tbf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Gi nga koupkoup, “Vetekiuo simi koitskoits!” ");
INSERT INTO tbf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","E Pilato a nga virei, “Surie misa? Mi sana tsienakor a nga tsana?” Eiekesen gi nga koupkoup leong beitsak, “Vetekiuo simi koitskoits!” ");
INSERT INTO tbf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E Pilato a nga lalaro varese mi bineit. Io, a nga ruom rivie e Barabas terie segie. E Pilato a nga oeng va gi ta nga beilbeiltsie e Iesu. Ma a nga terie e Iesu va gi ta nga vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mi kulou ni minakiur gi nga kir rubukien ngan e Iesu si ken vonuo mi gavana, gi ko vuotongie ngan va mi Praetorium, ma gi nga kuk kakuon mi gargar simi kulou ni minakiur. ");
INSERT INTO tbf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gi nga vavatsekie ngan mi lavlav dav, ma gi nga ruonie man kovage ngan bu suo tsotso nge vavatsekie simi kovan. ");
INSERT INTO tbf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma gi nga vakaek nge koup rakot sien, “E ta tino kuar, mi kovakova ka leong sibu Iuda!” ");
INSERT INTO tbf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gi nga nisnis ka i kovan ngan mi vaong nge kientsuo. Gi nga sege pukupukukaek ma gi nga rangarie. ");
INSERT INTO tbf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma sien gi tate nga vavangiets vaton, gi nga tsang rivie mi lavlav dav sien ma gi nga vavatsekie ngan man sar tsetstseik kesen. Samo gi nga kir varakoto nia ra vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","E Simon mi kangi Kurene, eie e taman e Aleksandro ma e Rupus. A nga kovuni si ken enamon ma a nga veis rov rio gie nia rubukien simi taon. Ma gi nga votsuoke nia sorokie mi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gi nga kerie e Iesu rakot simi korot gi ta vuotongie ngan i Golgota (man vuevue va, ‘Mi Korot simi Paptikov’) ");
INSERT INTO tbf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Samo gi nga terie sien mi puk dangi vain gi nga guol meie ngan mi dangi ei bo, eiekesen a kap nga unumie. ");
INSERT INTO tbf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma gi nga vetekiuo simi koitskoits. Gi nga potakie man sar tsetstseik, ma gi nga paluo ngan mi pinaluo nia pare va ese mei segie va ta nga poro ken ka sana kepineits. ");
INSERT INTO tbf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gi nga vetekiuo e Iesu simi koitskoits simi 9 kilok sivovo. ");
INSERT INTO tbf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mi vinavataor vavakatsep surie mi sana nama gi ta nga vuortie ngan a nga aes malan ne, ‘MAGI KOVAKOVA KA LEONG BU IUDA’ ");
INSERT INTO tbf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Gi nga vetekiuo ba ka puerpuer luo siba koitskoits i bingan e Iesu, mi mei kes si ken bieng suv ma mi mei mene si ken bieng kieir. ");
INSERT INTO tbf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ma mi mat vinavataor simi Pakpak Leong a nga me tsorubeit tuktuk sien ta nga pevien, “Gi nga aes meie ngan bu ka tsokor.” ");
INSERT INTO tbf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Egie ese gi ta nga veis rov riu gi nga erire kov nge oeng balapoik ngan ma gi nga pevien, “Arie evoi, e pevien va e ta vatsarerie mi Vona rengeir leong ma e ta ba buer tsuok voturie i aron ba ra tour! ");
INSERT INTO tbf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tsour peuk vekenan mi koitskoits nge vatoa no kese!” ");
INSERT INTO tbf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ine simi rosar kes mo, bu prist leong ma bu vavvasengei sibu vinuor se Moses gi nga vavangiets ngan e Iesu i kotubugie ma gi nga pevien, “A nga vatoa bu mei mene eiekesen a kap oit nia vatoa eie kesen! ");
INSERT INTO tbf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Giet ta be pare ine mi Messia, mi kovakova ka leong sibu Israel, va ta tsour peuk vekenan mi koitskoits. Terengien giet ta mang pare nge vodovodon tuktuk sien!” Ba ka gi ta nga vetekiuo siba koitskoits i bingan e Iesu, guor nga oeng balapoik ngan buer. ");
INSERT INTO tbf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sisiat potaram beit simi 3 kilok sireivreiv, mi ngingi leong a nga kuva mi enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma simi 3 kilok sireivreiv e Iesu a nga koup leong, “Eloi, Eloi, lama sabaktani?” Man vuevue va, “Mong Raban, mong Raban, surie misa e tate murien veie iou?” ");
INSERT INTO tbf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sien bu mei segie gi ta nga tuir vatavatat nge rongomie ine, gi nga pevien, “Nga rorong, eie a kukuo e Eliia.” ");
INSERT INTO tbf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mi ka a nga soer rakot nge ra vosuvie mi poko kukui kuvu i rou simi dangi vain monour, ma a nga rorotsie simi poko ei nge vutuirse terie se Iesu va ta nga un. Ma a nga pevien, “Kian be! Giet ta be pare va e Eliia ta nemei nge por terie i keim.” ");
INSERT INTO tbf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","E Iesu a nga koup leong, ma a nga maes rivie ken tino. ");
INSERT INTO tbf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mi baba gi ta nga tsana ngan mi lavlav leong nge bangie kitipan mi Korot Tamat Rovoriu simi Vona rengeir leong a nga kedeir napaluo kovuni i kur beit i keim. ");
INSERT INTO tbf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma sien mi muomuo simi kulou ni minakiur ta nga tuir i muan e Iesu ta nga pare vasa a nga mesei ven, a nga pevien, “A tuktuk te, ine mi ka eie e Natuon e Raban!” ");
INSERT INTO tbf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mi langei mene gi nga tuir i pek ma gi nga dedeng. I kinorutugie ine, e Maria kovuni i Magadala, a, e Maria e kinan e Ioses, e kasien lili e Iakobo, ma e Salome. ");
INSERT INTO tbf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I Galili, ine bu vevien gi nga ko vemusurie e Iesu ma gi nga ko deng surie ken sar pinat. Palan bu vevien mene gi ta nga nomeie e Iesu rakot i Ierusalem, gi nga mon buer. ");
INSERT INTO tbf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ine mi ra mi ra i muan mi Rangi Minaes. Mi ra nia tsatsang rorrois. Io, sien tate nga reivreiv seserigo, ");
INSERT INTO tbf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","e Iosep kovuni i Arimatea a nga rakot ngan mi aor ngeisngeis se Pilato nge vosuoreie nia poro mi piripirien e Iesu. Eie mi ka aiminangarei i kotubuon mi Sanedrin ma eie buer a nga rorois surie ian mi ra va e Raban ta vuor. ");
INSERT INTO tbf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","E Pilato a nga kudier sien ta nga rongomie va e Iesu a te nga maet. E Pilato a nga tuturei surie mi muomuo simi kulou ni minakiur ma a nga vosuoreie va e Iesu a nga maet kebeir te. ");
INSERT INTO tbf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sien e Pilato tate nga rorong kalei simi muomuo simi kulou ni minakiur va e Iesu a te nga maet, a nga sunuir terie mi piripirien e Iesu se Iosep. ");
INSERT INTO tbf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Io, e Iosep a nga vorie bu lavlav puneits ma a nga por votsorungie mi piripirien e Iesu nge gulie ngan bu lavlav puneits ma a nga ra vuturungie i aron mi monmon ta nga kole simi vout. Samo, a nga vovulie mi vunavout leong kitipan mi rumrubukien simi monmon. ");
INSERT INTO tbf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E Maria kovuni i Magadala meie e Maria e kinan e Ioses, guor nga pare ivie ta nga vuturungie en. ");
INSERT INTO tbf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sien mi Rangi Minaes tate nga voto, e Maria kovuni i Magadala, e Maria e kinan e Iakobo, ma e Salome gituo nga voir da sosong va gituo ta mang nga rakot nge ra vososongo mi piripirien e Iesu. ");
INSERT INTO tbf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tsourvovo simi ra vourvour simi wik, sien mi matanias tate nga rar tsour, gituo nga veis rakot simi monmon. ");
INSERT INTO tbf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma gituo nga vevirei nge gituo keskes, “Ese ta so vuvuil rivie mi vunavout i matan mi monmon?” ");
INSERT INTO tbf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eiekesen, sien gituo ta nga so dedeng kien, gituo nga pare ine mi vout gi te nga vuvuil rivie. Ine mi vout a nga leong beitsak. ");
INSERT INTO tbf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sien gituo ta nga rubukien simi monmon, gituo nga pare mi ka vour ta nga tsekie man tsetstseik puneits a nga mogos simi bienengeiv suv, ma gituo nga kudier. ");
INSERT INTO tbf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A nga pevien, “Ngatuo ta kap kudier. O telekiran va ngatuo nesie e Iesu kovuni i Nasaret ese gi ta nga vetekiuo simi koitskoits. Eie a kap mon ine. A te to muerengei! Ngatuo pare mi korot gi ta nga vuturungie mi piripirien en. ");
INSERT INTO tbf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngatuo veis nge ra pengan si ken sar madar tovtov ma e Petro ven ne, ‘E Iesu a te muo nge nga rakot i Galili. Ian en, nga ta so pare eie malan mo ta nga vokokotie senga.’” ");
INSERT INTO tbf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Gituo nga kudier tsak nge dendeir ma gituo nga rovotsour nge vi simi monmon. Gituo kap nga pengan ka kepineits si ka mei mene, simi vunan gituo nga motou. ");
INSERT INTO tbf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tsourvovo simi ra vourvour simi wik, sien e Iesu tate nga to muerengei simi miensei, a nga muna vasvas se Maria kovuni i Magadala ese e Iesu ta nga kareir rivie sien bu tsaka moromoruo mi napaririem potsu luo. ");
INSERT INTO tbf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","E Maria kovuni i Magadala a nga rakot ma a nga pengan segie ese gi ta nga ko nomeie e Iesu. Gi nga mon ngan mi tina ma mi aor tsak. ");
INSERT INTO tbf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sien gi ta nga rongomie va e Iesu a te nga to ma gi ta nga rongomie va e Maria a te nga pare, gi kap nga vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","I muir, e Iesu a nga beit vasvas ngan mi baidendeng vour siba mei luo segie sien guor ta nga vor ve veisveis i sar. ");
INSERT INTO tbf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Guor nga muerengei rakot i Ierusalem nge vateie gie kokouk, eiekesen gi kap nga vodovodon tuktuk seguor buer. ");
INSERT INTO tbf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","I muir te buer, e Iesu a nga tsorubeit vasvas simi sinangavur kes ma kes bu madar tovtov sien gi ta nga vor ve ngongou. Ma a nga nasara gie surie gi ta kap nga suvu vodovodon tuktuk se Raban, ma surie bu arogie a nga bakiet nia vodovodon tuktuk segie ese gi ta nga pare e Iesu va a te nga to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E Iesu a nga oeng segie, “Nga ta veis rakot sibu korot kokouk simi kaber ma nga ta vavatei ngan mi Banga Vinavatei sibu mei kokouk simi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Eie ese ta vodovodon tuktuk nge por sinusuruiv, e Raban ta so vatoa. Eiekesen eie ese ta kap vodovodon tuktuk, e Raban ta so votorosie. ");
INSERT INTO tbf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","E Raban ta terie mi ngeisngeis nia tsana bu kepineits ni vovokudier segie ese gi ta vodovodon tuktuk: simi asoung gi ta kareir rivie bu tsaka moromoruo; gi ta vakvakokoit ngan bu vuna nama vour. ");
INSERT INTO tbf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sien va gi ta tsuokopie bu tsotsoi ngan bu rimagie, ma sien va gi ta unumie bu dangi mu, gi ta kap oit nia babas. Gi ta soburo bu tamat mienarouk ngan bu rimagie ma ian magi sar mienarouk ta voto.” ");
INSERT INTO tbf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Io, i murien mi Nguts e Iesu tate nga vakokoit voto segie, e Raban a nga kir kien ngan simi rangit ma ine a mogos simi riem suv se Raban. ");
INSERT INTO tbf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bu madar tovtov gi nga veis ma gi nga vavatei ngan mi Banga Vinavatei sibu korot kokouk, ma mi Nguts a nga tsatsang meie gie. Ma a nga vara tuktuk ngan ine mi Banga Vinavatei sibu kepineits ni vovokudier gi ta nga tsana. ");
INSERT INTO tbf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ka leong Tiopilus. Palan mi kulou gi nga konon nia vavataor vuturungie ian bu kepineits gi ta nga tsorubeit tuktuk i kinorutugei. ");
INSERT INTO tbf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mi kulou ese gi ta nga pare ine bu kepineits ngan bu katsomatagie ma mi kulou vavvatei ngan mi namanien e Raban, gi nga me vateie gei ngan ine bu kepineits. Arie mo gi nga vavataor vemusurie. ");
INSERT INTO tbf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Io, eou buer o nga menise vititirie ine bu kepineits kokouk ta nga tsorubeit vakaek si man vakavakaek, ma o vodon buer va ta kalei sien va o ta vavataor petan ine bu kepineits rakot sevoi, Tiopilus mi ka leong, ");
INSERT INTO tbf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","terengien va e ta mang telekire vititirie ine bu nama gi ta nga vateie no ngan, va a tuktuk rovoriu. ");
INSERT INTO tbf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sibu avareit e Erot ta nga muomuo i Iudea, mi prist a nga mon. Mi asan e Sakaria. Eie mi prist simi tietie se Abia ma ken vevien, mi asan e Elisabet. Eie simi tietie se Aron. ");
INSERT INTO tbf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Keguor tino a nga dokei i matan e Raban. Guor nga vemusurie vititirie bu vuna vinuor ma mi saran mi tino simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eiekesen guor kap nga suvu nout, simi vunan e Elisabet a kap nga oit nia porpor madar, ma guor te nga komois. ");
INSERT INTO tbf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Simi ra mene sien mi gargar se Sakaria gi ta nga tsatsang prist, ine mi ra va eie e Sakaria ta nga tsatsang prist sien i matan e Raban, ");
INSERT INTO tbf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","simi vunan gi te nga vile vemusurie mi saran mi tsinatsangagie bu prist va ta nga rubukien simi vona rengeir simi Nguts nia ra tunie mi buliebuliet saien sosong. ");
INSERT INTO tbf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ian simi poko ra ta nga tunie mi buliebuliet saien sosong, mi bineit leong gi ta nga mon i marar, gi nga no. ");
INSERT INTO tbf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Samo ken angelo mi Nguts a nga beit sien ma a nga tuir simi bienengeiv suv simi korot nia tu buliebuliet saien sosong. ");
INSERT INTO tbf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sien e Sakaria ta nga pare mi angelo, a nga kudier tsak ma a nga motou. ");
INSERT INTO tbf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Eiekesen mi angelo a nga oeng sien, “Sakaria, kian va e ta motou. E Raban a te rongomie ke sar no. Ke vevien, e Elisabet, ta kava mi madar tamat. Ma e ta so tour asan ngan e Ioanes. ");
INSERT INTO tbf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","E ta so vous ngan mi nires leong ma palan bu mei gi ta res meie no sien va e kinan ta kava, ");
INSERT INTO tbf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","simi vunan, eie ta suvu as leong i matan mi Nguts. Eie ta kap un dangi vain ma da ngeisngeis. Ma sien ta ngas mon i aron e kinan, ta vous ngan mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eie ta kir muerngan palan bu Israel rakot simi Nguts magi Raban. ");
INSERT INTO tbf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eie ta suvuon mi moromoruo ma mi ngeisngeis malan se Eliia ma ta muo ngan mi Nguts. Eie ta vurisan bu arogie bu tam nia aor kes meie bu natugie, ma ta vurisan kegi tino mi kulou rong tsak va gi ta mang tino vemusurie mi sinavien mi kulou duis. Ine arie vasa eie ta tsang rorois venengan mi kulou nia rosie mi Nguts.” ");
INSERT INTO tbf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","E Sakaria a nga vereie mi angelo, “Vasa o ta telekire venengan va ine mi nama a tuktuk? O te komois ma kong vevien buer a te labatevien.” ");
INSERT INTO tbf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mi angelo a nga kuil nama, “Eou e Gabriel. O ko munu mon i matan e Raban. Ma a nga tura iou nia me vateie no ngan ine mi banga vinavatei. ");
INSERT INTO tbf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Rorong. Ine e ta ngong, ma e ta kap oit nia vakokoit tuir oit simi ra va ine bu kepineits gi ta tsorubeit tuktuk, simi vunan e kap vodovodon tuktuk ine si kong sar nama ian va gi ta tsorubeit tuktuk si magi sar keipkepide ra duis.” ");
INSERT INTO tbf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sien ine mi kepineits ta nga tsorubeit, mi kulou gi nga rosie e Sakaria, ma gi nga vodovodon palan surie a te nga mon pilang te i aron mi vona rengeir simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sien ta nga rovotsour, a kap nga oit nia vakokoit segie. Ma gi nga telekiran va a nga pare ka baidendeng i aron mi vona rengeir, sien tate nga tsana mi vinakokoit ngan mo ba riman rakot segie surie a te nga ngong. ");
INSERT INTO tbf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sien ken tsientsang tate nga voto, a nga muerengei rakot si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","I murien ine, ken vevien e Elisabet a te nga kour. Ma a nga mon mo simi vonuo ba vura mi napaririem, ma a nga pevien, ");
INSERT INTO tbf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Sibu ra ine, mi Nguts a pernge iou. Ma a te tsang rivie kong mienengeir i matan mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sien tate nga napaririem potsu kes bu vura e Elisabet tate nga tian sien, e Raban a nga turan e Gabriel mi angelo rakot simi taon i aron i Galili gi nga vuotongie ngan i Nasaret. ");
INSERT INTO tbf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Io, e Gabriel a nga ra vorotan mi vevien vour ese gi tate nga vouo ngan mi ka mi asan e Iosep. E Iosep eie mi ka simi tietie se Davit. Mi asan ine mi vevien vour e Maria. ");
INSERT INTO tbf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ma a nga beit sien nge pevien, “Mi molu ta mon meie no. E Raban a resmata no! Mi Nguts a mon meie no.” ");
INSERT INTO tbf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","E Maria a nga rongomie ine mi nama ma a nga kudier nge vodon, “Mi sana nama ine?” Mi aron e Maria a nga bakiet surie ken sar nama ine mi angelo ma a nga vodovodon palan va mi sana man vuevue ine mi vinakokoit. ");
INSERT INTO tbf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mi angelo a nga oeng sien, “Maria! Kian va e ta motou. E Raban a te lalaro vatamase no. E Raban a resmata no. ");
INSERT INTO tbf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Rorong! E ta so tian nge kava mi madar tamat. Ma e ta so tourasan ngan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eie ta suvuon mi as leong, ma gi ta vuotongie ngan e Natuon e Raban ese ta tsiroup. Mi Nguts e Raban ta terie sien ken mogomogos ni nguts e Davit e tubuon. ");
INSERT INTO tbf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma eie ta vuortie mi tietie se Iakop sibu ra bu ra, ma ken vinuor ta kap voto.” ");
INSERT INTO tbf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma e Maria a nga vereie mi angelo, “Eou o kap ngas telekire ka. Vasa ine mi kepineits ta tsorubeit ven?” ");
INSERT INTO tbf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mi angelo a nga kuil nama, “Mi Moromoruo Tamat ta nemei sevoi ma mi ngesengesien e Raban ese ta tsiroup ta kuva no. Arie mi vunan, ine mi madar ken tino ta tamat ma gi ta vuotongie va e Natuon e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Rorong! E patsa, e Elisabet, misasien a te labatevien, a te tian ngan mi madar tamat. Gi nga ko pevien va eie mi vevien a kap ko porpor madar, eiekesen a te tian sibu vura mi napaririem potsu kes. ");
INSERT INTO tbf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Surie a kap ka kepineits a mavev se Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma e Maria a nga pevien, “A kalei, eou ken petspets mi Nguts. Mi sana kepineits e tate oeng ngan seou, ta tsorubeit malan.” Samo mi angelo a nga sorvekenan. ");
INSERT INTO tbf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","I murien ine, e Maria a nga tamtuir lalapus rakot simi taon simi enamon i popon bu kuitskuits i Iudea. ");
INSERT INTO tbf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A nga rubukien i aron ken vonuo e Sakaria ma a nga oeng vatamase e Elisabet. ");
INSERT INTO tbf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sien e Elisabet ta nga rongomie ken nama e Maria, mi madar i aron a nga kolueits ma mi Moromoruo Tamat a nga vovosuo e Elisabet. ");
INSERT INTO tbf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma a nga oeng leong malan ne, “Ken vatavatamse e Raban a leong sevoi i kotubuon mi langei kokouk. E Raban ta vatamase ian mi natu madar va e ta kava! ");
INSERT INTO tbf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Surie misa ine mi kepineits ta tsorubeit seou va e kinan mong Nguts ta me iro iou? ");
INSERT INTO tbf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pare! Sien o ta rongomie mi ina, mi madar i aroung a kolueits ngan mi nires. ");
INSERT INTO tbf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","E Raban ta vatamase no, simi vunan evoi e vodovodon tuktuk simi sana nama mi Nguts ta vokokotie sevoi va ta tsorubeit tuktuk!” ");
INSERT INTO tbf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E Maria a nga pevien; “Mi aroung a puongan mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ma mi morumoruong a resmatan e Raban kong vavato, ");
INSERT INTO tbf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","surie a te nga vodonomie iou misasien eou ken petspets tuvuon mo. Rorong! Vakaek ine ma i muir, mi kulou kokouk gi ta so pevien va a te nga vatamase iou, ");
INSERT INTO tbf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","simi vunan eie ese ta ngeisngeis beitsak, a te nga tsana bu kepineits leong surie iou, ma mi asan a tamat. ");
INSERT INTO tbf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ma ta vasangan ken aor molous segie ese gi ta mangaran, si kegi sar tietie sibu kienakav kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A te nga tsana bu tsientsang ngeisngeis ngan mi riman. Ma a te nga sunura gie mi kulou gi ta vodon sibu arogie va egie gi asna. ");
INSERT INTO tbf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A te nga pop terie gie i keim bu muomuo ni vuor si kegi sar mogomogos ni vuor, ma a nga tsuok terie i kur egie ese gi ta nga vilikitie gie kesegie. ");
INSERT INTO tbf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A te nga vetingie mi kulou gi ta nga vitor ngan bu banga kepineits, ma egie ese gi ta nga suvuram a nga ture muernga gie ngan bu riem kapasen. ");
INSERT INTO tbf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A te nga kulie i Israel ken petspets, surie a nga vodonomie va ta aor molous nge gie, ");
INSERT INTO tbf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","e Abaraam ma bu natuon sibu ra bu ra, malan ta nga pengan sibu tubugiet.” ");
INSERT INTO tbf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","E Maria a nga mon meie e Elisabet siba vura tour ma i muir, a nga muerengei rakot si ken enamon. ");
INSERT INTO tbf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Io, mi ra nia por madar a te nga beit se Elisabet, ma a nga kava mi madar tamat. ");
INSERT INTO tbf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bu palapalan ma bu patsan gi nga rongovan va mi Nguts a te nga vasangan ken aor molous leong sien, ma gi nga res meie. ");
INSERT INTO tbf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Simi ra ta nga napaririem potsu tourngan, gi nga me varapuo, ma gi te nga lalaro tourasan ngan e Sakaria vemusurie e taman. ");
INSERT INTO tbf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Eiekesen e kinan a nga pevien, “A kap! Mi asan gi ta vuotongie ngan e Ioanes.” ");
INSERT INTO tbf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Gi nga oeng sien, “Eiekesen kap ka mei sibu patsa a nga suvuon ine mi as!” ");
INSERT INTO tbf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Samo, gi nga teik matan e taman nia telekiran vasa ken lalaron surie mi asan. ");
INSERT INTO tbf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A nga revie gie ngan ka napa ei ma a nga vavataor, “Mi asan e Ioanes.” Ma egie kokouk gi nga kudier tsak. ");
INSERT INTO tbf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ian ngas te, mi ngutsuon ma mi karamen a nangba nga ketseketseng. Ma a nga tsuok vakaek nge vakokoit ma a nga puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bu palapalan gi ta nga mon vatvatta, bu arogie a nga vous ngan mi mientou. Ma sibu enamon i popon bu kuitskuits kokouk i Iudea, mi kulou gi nga vor ve vokovokokotie ine bu kepineits kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mi kulou kokouk ese gi ta nga rongomie ine, gi nga vodovodon palan nge virei, “Ine mi madar, vasa ta so tsorubeit ven vevemuir?” Simi vunan mi ngesengesien mi Nguts a te mon meie. ");
INSERT INTO tbf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","E taman e Ioanes, e Sakaria a nga vous ngan mi Moromoruo Tamat ma a nga vokokotie mi nama peteteir malan ne; ");
INSERT INTO tbf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Giet ta puongan e Raban mi Nguts sibu Israel, simi vunan a nga nemei nge vara ketseketseng ngan mi kuoluon. ");
INSERT INTO tbf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A nga terie segiet mi ka ni vavato ese ta ngeisngeis beitsak, kuvu simi tietie se Davit, ken petspets, ");
INSERT INTO tbf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","malan tate nga vakokoit i ngutsugie ken sar propet muomuo te ");
INSERT INTO tbf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","va ta vatoa giet si magiet sar matakorot, ma i riman bu mei kokouk gi ta nga ko karto giet. ");
INSERT INTO tbf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A nga pevien va ta vasangan ken aor molous sibu tubugiet, ma a nga vodonomie ken kinubuits ian ta tamat, ");
INSERT INTO tbf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","mi kinubuits ta nga tsana se tubugiet e Abaraam. ");
INSERT INTO tbf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A te nga vatoa giet i riman magiet sar matakorot, terengien giet ta kap motou ma giet ta mang tsatsang sien, ");
INSERT INTO tbf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","simi sinavei ta tamat ma ta duis i matan sibu ra kokouk si kegiet sar tino.” ");
INSERT INTO tbf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Evoi, e natung, gi ta vuotongie no ngan ken propet e Raban ese ta tsiroup, surie e ta muo ngan mi Nguts nia rorois ngan mi rosaran, ");
INSERT INTO tbf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","terengien va mi kuoluon gi ta mang telekiran va ta vodon rivie kegi sar sinavei tsokor nge vatoa gie. ");
INSERT INTO tbf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","E Raban a nga tsana malan ne, simi vunan ken aor molous a leong beitsak. Ma surie ine, a tsana va mi matanias ta rar tsour i popogiet kuvu simi rangit, ");
INSERT INTO tbf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","terengien va ta mang rarangie mi kulou gi ta mon simi ngingi ma simi minoruvien mi miensei, ma nia vavasie kegiet vineis rubukien simi saran mi molu.” ");
INSERT INTO tbf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Io, ine mi natu madar, a nga vor ve leongleong ma ken tino simi moromoruo a nga tsorubeit ngeisngeis. Ma a nga mon simi beir tuir oit simi ra ta nangba nga tsorubeit vasvas simi kulou i Israel. ");
INSERT INTO tbf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ian sibu ra, e Kaesar Augustas a nga terie mi nama ngeisngeis va gi ta nga ra por asan bu mei kokouk i aron bu enamon bu Roma gi ta nga naneie. ");
INSERT INTO tbf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sien ine mi por as vourvour ta nga tsorubeit, e Kurenio a nga vuor i Siria. ");
INSERT INTO tbf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma egie keskes gi nga rakot si kegi sar taon kesegie nia ra teir as. ");
INSERT INTO tbf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Io, e Iosep buer a nga kien kovuni i Galili, simi taon i Nasaret rakot i Iudea, simi taon se Davit gi nga vuotongie va i Betilem, simi vunan eie kovuni simi tietie se Davit. ");
INSERT INTO tbf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eie a nga rakot ian en nia ra teir as meie e Maria, ese gi tate nga kubutsie va ta nga reie. Ian sibu ra e Maria a te nga tian. ");
INSERT INTO tbf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sien guor tate nga mon ian en, mi keipkepide ra a te nga beit va e Maria tate nga por madar. ");
INSERT INTO tbf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma a nga kava ken muariem, mi madar tamat. A nga ovutie nge poko lavlav ma a nga vuturungie i aron magi ngongou bu vinavinar, simi vunan kap te ka niagituo simi vonuo mutumutur. ");
INSERT INTO tbf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mi kulou nennei sipsip gi nga mon si kegi sar korot i uot nge naneie kegi sar sipsip ian sikati. ");
INSERT INTO tbf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Samo ken angelo mi Nguts, a nga beit segie, ma man matvinavaso mi Nguts a nga rar viririsie gie. Ma gi nga motou beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eiekesen mi angelo a nga oeng segie, “Kian va nga ta motou! Nga rorong! O nemei nia vateie nga ngan mi banga vinavatei nian mi nires leong va ken mi kulou kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nevere, i aron mi taon se Davit, mi Ka ni vavato gi te kava. Eie mi Karisito mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nga ta so deng kielala malan ine. Nga ta so vorotan mi natunatu madar gi ta ovutie nge poko lavlav ma a mutur i aron magi ngongou bu vinavinar.” ");
INSERT INTO tbf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma puk kam lalapus, mi gargar angelo leong simi rangit gi nga tsorubeit vorotan ian mi angelo, ma gi nga puongan e Raban malan ne, ");
INSERT INTO tbf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mi matvinavaso rakot se Raban die i kur beitsak, ma simi kaber, mi molu ta kuva gie ese e Raban ta resmata gie.” ");
INSERT INTO tbf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sien bu angelo gi tate nga sorvekena gie kien i kur simi rangit, mi kulou nennei sipsip gi nga veveoeng i kotubugie, “Giet ma. Giet tate rakot i Betilem nge dengarie ine mi kepineits ian ta tsorubeit, ivie mi Nguts tate oeng ngan segiet.” ");
INSERT INTO tbf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Io, gi nga lalapus rakot ma gi nga so vorotan e Maria meie e Iosep, ma mi natunatu madar ta nga mutur i aron magi ngongou bu vinavinar. ");
INSERT INTO tbf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma sien gi tate nga dengarie, gi nga pouts ngan ine mi nama mi angelo ta nga vokokotie surie ine mi natu madar. ");
INSERT INTO tbf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma egie kokouk ese gi ta nga rongomie ine, gi nga kudier tsak surie mi sana mi kulou nennei sipsip gi ta nga pengan segie. ");
INSERT INTO tbf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Eiekesen e Maria a nga rong toungan ine bu nama kokouk i aron ma a nga ko vodonomie gie. ");
INSERT INTO tbf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Io, mi kulou nennei sipsip gi nga muerengei. Gi nga keveir nge puongan e Raban surie bu kepineits kokouk gi tate nga rongomie nge dengarie malan ngas te mi angelo ta nga pengan segie. ");
INSERT INTO tbf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","I murien bu ra mi napaririem pouts tour, gi te nga varapuo ine mi natu madar ma gi nga tourasan ngan e Iesu. Ine mi as, mi angelo a nga terie sien, sien ta kap ngas nga vou i aron e kinan. ");
INSERT INTO tbf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sien keguor keipkepide ra nia tsorubeit melemelen vemusurie mi Vinuor se Moses tate nga voto, e Iosep meie e Maria guor te nga kerie ine mi natu madar rakot i Ierusalem nia ra vasangan va eie simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Guor nga tsana ine malan gi tate nga vataro i aron mi Vinuor simi Nguts malan ne, “Mi muariem tamat, gi ta ngas vuotongie va eie mi natu vavaku simi Nguts.” ");
INSERT INTO tbf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma buer guor nga ra terie mi tienebeir ni varam vemusurie mi Vinuor simi Nguts ian ta pevien, “Ka ba buen luo o, ka ba natu bour luo.” ");
INSERT INTO tbf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Io, mi ka a nga mon i Ierusalem, mi asan e Simeon. Eie mi ka duis ma a nga mangaran e Raban. Eie a nga rorois surie man vavaman i Israel, ma mi Moromoruo Tamat a nga mon meie. ");
INSERT INTO tbf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma mi Moromoruo Tamat a te nga vakatsepa va ta kap nga maet tuir oit va ta nga dengarie ken Messia mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mi Moromoruo a nga vavasie ma a nga rubukien i mararan mi Vona rengeir leong. Sien e Maria ma e Iosep guor tate nga sor rubukien ngan mi madar e Iesu nia tsana sien mi sana mi Vinuor ta vokokotie, ");
INSERT INTO tbf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","e Simeon a nga tserie ine mi madar ma a nga puongan e Raban nge pevien, ");
INSERT INTO tbf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mi Nguts! Vere e tate vavasie ke petspets ngan mi molu, vemusurie ke nama. ");
INSERT INTO tbf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ba matoung guor te dengarie ine mi Ka ni vavato, ");
INSERT INTO tbf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ian e tate nga rorois ngan i matan mi kulou kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Eie mi berber ni vavakatsep ngan e Raban rakot sibu Kibang ma eie man matvinavaso ke kulou i Israel.” ");
INSERT INTO tbf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","E taman meie e kinan guor nga kudier tsak ngan misa ta nga vokokotie surie ine mi madar. ");
INSERT INTO tbf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Io, e Simeon a nga vatamase gituo ma a nga pevien ne se Maria, e kinan mi madar, “Rorong! Ine mi madar, e Raban a te vile nia tsana palan mi kulou i Israel gi ta kor ma palan gi ta tamtuir, ma eie mi totourlekier kovuni se Raban ian va palan mi kulou gi ta so oge, ");
INSERT INTO tbf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","terengien, bu vinavinadodogie bu mei palan ta mang mon simi kientsep. Ma ka kuor simi vinevineken ta tsoka buer mi ate.” ");
INSERT INTO tbf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mi propet vevien a nga mon buer. Mi asan e Ana, e natuon vevien e Panuel, simi matabu Aser. Eie a te nga labatevien tsak te. Eguor ken labeit guor nga rei sibu avareit mi napaririem pouts luo ma ken labeit a te nga maet vekenan. ");
INSERT INTO tbf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma a nga mon naor tuir oit ken sar avareit a nga oit bu sinangavur mi napaririem pouts tour ma voveit (84). E Ana a kap nga ko sorvekenan mi vona rengeir, ma a nga ko tsatsang se Raban ma a nga ko vorvor nge no sibu rokati ma bu rosisiat. ");
INSERT INTO tbf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Io, ian ngas te, a nga veis kien seguor, ma a nga vakaek nge puongan e Raban. Ma a nga vakokoit surie ine mi madar rakot segie kokouk ese gi ta nga rorrois va e Raban ta nga vara ketseketseng ngan i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sien e Iosep meie e Maria guor tate nga tsang vaotie bu kepineits kokouk vemusurie mi Vinuor simi Nguts, gituo nga muer rakot i Galili, si kegituo taon i Nasaret. ");
INSERT INTO tbf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma mi madar a nga vor ve leongleong ma mi kurikurien a nga tsorubeit ngeisngeis. Ma a nga vous ngan mi banga vienviendon, ma ken tentoiv e Raban a nga kuva. ");
INSERT INTO tbf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sibu avareit kokouk, e taman meie e kinan, guor nga ko rakot i Ierusalem simi Nginu Pasova. ");
INSERT INTO tbf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sien tate nga sinangavur kes ma luo ken sar avareit e Iesu, gituo nga rakot te buer ian simi Nginou malan gi ta nga ko tsana. ");
INSERT INTO tbf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","I murien mi Nginou tate nga voto, mi kulou gi te nga muerengei, eiekesen mi madar e Iesu a ngas nga mon i Ierusalem. Ma e kinan ma e taman guor kap nga telekiran. ");
INSERT INTO tbf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Guor si nga vodon va eie a nga veis meie gie ian bu mei gi te nga veis muerengei. Io, guor nga veis muer mi ra pu. Samo guor nga vakaek nge nesie i kotubuon bu patsaguor ma bu palapalaguor. ");
INSERT INTO tbf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sien guor ta kap nga vorotan, guor nga muerengei rakot i Ierusalem nia ra nesie. ");
INSERT INTO tbf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I murien ba ra tour, guor nangba nga ra deng vorotan i aron mi Vona rengeir leong. A nga mogos i kotubuon bu vavvasengei nge rorong segie ma a nga ververeie gie ngan bu virevirei. ");
INSERT INTO tbf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Egie kokouk ian gi ta nga rongomie e Iesu, gi nga kudier tsak si ken banga teletelekirei ma si ken sar nama kuilkuil sibu vinirei. ");
INSERT INTO tbf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sien e taman meie e kinan, guor ta nga vorotan, guor nga kudier tsak, ma e kinan a nga pevien sien, “Natung, surie misa e ta tsang malan ngan ine segor? Egor e tama, gor te pilang neisneis sevoi.” ");
INSERT INTO tbf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","E Iesu a nga virei, “Surie misa ngado ta nesie iou? Ngado kap telekiran va o ta ngas mon i aron ken vonuo e Tamoung?” ");
INSERT INTO tbf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eiekesen guor kap nga katsep simi sa ta nga vokokotie seguor. ");
INSERT INTO tbf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","E Iesu a nga muerengei rakot i Nasaret meie guor, ma a nga ko mangara guor. Eiekesen e kinan a nga perngan ine bu nama kokouk i aron. ");
INSERT INTO tbf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma e Iesu a nga vor ve leongleong meie ngan mi banga vienviendon. Ma buer e Raban ma mi kulou gi nga resmatan beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Io, simi avareit ta nga sinangavur kes ma mi napaririem ngan e Tiberius Kaesar ta nga vuor sien, e Pontio Pilato a nga gavana i Iudea. Ian simi avareit, e Erot a nga vuortie i Galili. Ma e Pilipo e kasien e Erot a nga vuortie i Ituria ma i Trakonitis. Ma e Lisanias a nga vuortie i Abilene. ");
INSERT INTO tbf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma, sien e Annas ma e Kaiapas guor ta nga mon kovan bu prist, ken nama e Raban a nga beit se Ioanes e natuon e Sakaria sien ta nga mon simi beir. ");
INSERT INTO tbf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Io, e Ioanes a nga rakot sibu korot kokouk vatvatta mi da i Ioridan nge vavatei simi kulou gi ta nga beit ian en va gi ta nga vodon vuris vekenan kegi sar sinavei tsokor nge por sinusuruiv, terengien va e Raban ta mang vodon rivie kegi sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A nga vavatei vemusurie bu vinavataor ta mon simi Pakpak Leong e Isaia mi propet ta nga vataro, ven ne, “Mi inan mi ka a koupkoup pevien simi beir, ‘Tsang rorois ngan ken rosar mi Nguts. Tsang vodusie ken sar baiveisveis. ");
INSERT INTO tbf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vovosuo bu korot gi ta kopiekopien kokouk, ma tsoup pepekutsie bu pout ma bu kuitskuits kokouk, ma vodusie bu rosar vilvilguo, ma tsang vakalaie bu rosar gi ta tsongetsonge. ");
INSERT INTO tbf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Terengien mi kulou kokouk gi ta mang telekire surie ken vavato e Raban.’” ");
INSERT INTO tbf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mi bineit gi nga nemei se Ioanes va gi ta nga me por sinusuruiv. Ma a nga pevien segie, “Enga bu natuon mi tsotsoi tsak! Ese a nga oeng senga va nga ta oit nia vi ngan ken aor rarap e Raban ian va ta nemei? ");
INSERT INTO tbf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nga ta ngas vua ngan bu banga vuovuo nia vara tuktuk ngan va nga te vodon vuris. Kian va nga ta konon nia pevien ne senga kesenga, ‘E Abaraam, eie e tamagiet.’ O oeng senga. E Raban a oit nia tsana ine bu vunavout va gi ta tsorubeit bu natuon e Abaraam. ");
INSERT INTO tbf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mi matou a te mon rorois i vunan bu ei, ma bu ei kokouk gi ta kap vua ngan kavo banga vuovuo, gi ta tara gie nge tomekan simi leing.” ");
INSERT INTO tbf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Io, mi bineit gi nga vosuoreie, “Mi sana gei ta ngas tsana?” ");
INSERT INTO tbf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","E Ioanes a nga kuil nama, “Sien va ka mei man kaba kuirkuir luo, eie ta ngas terie ka mei si ka mei kap man ka kuirkuir, ma sien va ka mei ken kavo nginonginou eie buer ta ngas tsana malan mo.” ");
INSERT INTO tbf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bu ka porpor takis buer gi nga nemei nge me por sinusuruiv, ma gi nga vosuoreie, “Vavvasengei, mi sana kepineits gei ta ngas tsana?” ");
INSERT INTO tbf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A nga kuil nama, “Kian va nga ta por lakep rio misa mi vinuor ta pengan.” ");
INSERT INTO tbf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Samo mi kulou ni minakiur gi nga vosuoreie, “Mi sana gei ta ngas tsana?” Ma a nga kuil nama, “Kian va nga ta teie tsana tuvuon ngan kegi sar kepineits bu mei mene nge vepitsie gie ngan kavo namani binit. Nga ta ngas vodon surie va kenga sar voirvoir eie a te oit.” ");
INSERT INTO tbf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mi kulou gi nga vor ve rorrois surie mi Messia va ta nga beit ma i arogie gi nga vodon va e Ioanes arie eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma e Ioanes a nga kuil nama segie kokouk, “O tsana mi sinusuruiv senga ngan mi da. Eiekesen mi ka eie ese ta ngeisngeis rio iou, ta nemei, ma o kap kalei oit va o ta ruobatie man ba poppop. Eie ta tsana mi sinusuruiv senga ngan mi Moromoruo Tamat ma mi leing. ");
INSERT INTO tbf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mi napa sosos a te mon siba riman. Eie ta so vitseir rivie mi biror sibu nginonginou, ma ta teir kakakuon bu banga nginonginou i aron ken vonuo teteir nginonginou, eiekesen ta tunie bu biror simi leing ian ta kap oit nia maet.” ");
INSERT INTO tbf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Io, e Ioanes a nga vavatei ngan mi Banga Vinavatei simi kulou nia vangasie gie ngan bu suada rosar palan. ");
INSERT INTO tbf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","E Ioanes a nga oeng matan e Erot mi kovakova ka leong, surie mi sinavei tsokor ta nga tsana se Erodias ken vevien e kasien ma surie palan bu sinavei tsokor ta nga tsana buer. ");
INSERT INTO tbf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Samo e Erot a te buer nga tsana mi sinavei tsokor mene, sien ta nga terie e Ioanes simi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Io, sien mi kulou kokouk gi tate nga por sinusuruiv, e Iesu buer a nga por sinusuruiv. Ma sien ta nga vor ve nono, mi rangit a nga katsep. ");
INSERT INTO tbf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ma mi Moromoruo Tamat a nga tsour peuk seie malan mi buen, ma mi ien kovuni simi rangit a nga vakokoit malan ne, “Evoi e natung mi ateung. Ma o resmata no beitsak.” ");
INSERT INTO tbf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sien e Iesu tate nga tsuok vakake ken tsientsang, ken sar avareit a te nga oit malan va ba sinangavur tour. Ma bu mei gi nga telekiran va eie e Natuon e Iosep. E Iosep e natuon e Eli. ");
INSERT INTO tbf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","E Eli e natuon e Matat. E Matat e natuon e Levi. E Levi e natuon e Melki. E Melki e natuon e Ianai. E Ianai e natuon e Iosep. ");
INSERT INTO tbf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","E Iosep e natuon e Matatias. E Matatias e natuon e Amos. E Amos e natuon e Naum. E Naum e natuon e Esli. E Esli e natuon e Nagai. ");
INSERT INTO tbf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","E Nagai e natuon e Mat. E Mat e natuon e Matatias. E Matatias e natuon e Semein. E Semein e natuon e Iosek. E Iosek e natuon e Ioda. ");
INSERT INTO tbf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","E Ioda e natuon e Ioanan. E Ioanan e natuon e Resa. E Resa e natuon e Serubabel. E Serubabel e natuon e Salatiel. E Salatiel e natuon e Neri. ");
INSERT INTO tbf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","E Neri e natuon e Melki. E Melki e natuon e Adi. E Adi e natuon e Kosam. E Kosam e natuon e Elmadam. E Elmadam e natuon e Er. ");
INSERT INTO tbf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E Er e natuon e Iosua. E Iosua e natuon e Elieser. E Elieser e natuon e Iorim. E Iorim e natuon e Matat. E Matat e natuon e Levi. ");
INSERT INTO tbf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","E Levi e natuon e Simeon. E Simeon e natuon e Iuda. E Iuda e natuon e Iosep. E Iosep e natuon e Ionam. E Ionam e natuon e Eliakim. ");
INSERT INTO tbf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","E Eliakim e natuon e Melea. E Melea e natuon e Mena. E Mena e natuon e Matata. E Matata e natuon e Natan. E Natan e natuon e Davit. ");
INSERT INTO tbf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","E Davit e natuon e Iesi. E Iesse e natuon e Obet. E Obet e natuon e Boas. E Boas e natuon e Salmon. E Salmon e natuon e Nason. ");
INSERT INTO tbf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","E Nason e natuon e Aminadap. E Aminadap e natuon e Atmin. E Atmin e natuon e Ram. E Ram e natuon e Esron. E Esron e natuon e Peres. E Peres e natuon e Iuda. ");
INSERT INTO tbf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","E Iuda e natuon e Iakop. E Iakop e natuon e Isak. E Isak e natuon e Abaraam. E Abaraam e natuon e Tera. E Tera e natuon e Naor. ");
INSERT INTO tbf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","E Naor e natuon e Seruk. E Seruk e natuon e Reu. E Reu e natuon e Pelek. E Pelek e natuon e Eber. E Eber e natuon e Sela. ");
INSERT INTO tbf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","E Sela e natuon e Kainan. E Kainan e natuon e Arpaksat. E Arpaksat e natuon e Sem. E Sem e natuon e Noa. E Noa e natuon e Lamek. ");
INSERT INTO tbf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","E Lamek e natuon e Matusela. E Matusela e natuon e Enok. E Enok e natuon e Iaret. E Iaret e natuon e Maalalel. E Maalalel e natuon e Kainan. ");
INSERT INTO tbf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","E Kainan e natuon e Inos. E Inos e natuon e Set. E Set e natuon e Adam. E Adam e natuon e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","E Iesu a nga vous ngan mi Moromoruo Tamat nge muerengei kovuni i Ioridan. Ma mi Moromoruo Tamat a nga muongan rakot simi korot beir. ");
INSERT INTO tbf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ian en, e Satan a nga konon sibu ra ba sinangavur voveit. E Iesu a kap nga ngou i aron ine bu ra. I murien ian bu ra, e Iesu a nangba nga vitor. ");
INSERT INTO tbf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma e Satan a nga oeng sien, “Sien va evoi e Natuon e Raban, oeng ngeisngeis ine sibu vout va gi ta tsorubeit tsoik.” ");
INSERT INTO tbf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","E Iesu a nga kuil nama sien ven ne, “Mi Pakpak Leong a pevien ne, ‘Mi ka a kap oit nia tino ngan mi tsoik mo.’” ");
INSERT INTO tbf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ma e Satan a nga kerie e Iesu kien simi korot i kur ma ian ngas te, a nga vasangan se Iesu bu mangmagoso nguts kokouk simi kaber. ");
INSERT INTO tbf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma a nga oeng sien, “O ta terie kegi sar ngeisngeis kokouk nia vuor ma magi sar matvinavaso sevoi, simi vunan o te suvuon ine bu kepineits, ma a oit va o ta terie seie ese o ta lalaron. ");
INSERT INTO tbf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Io, o ta terie sevoi ine bu kepineits kokouk sien va e ta rengeir nemei seou.” ");
INSERT INTO tbf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","E Iesu a nga kuil nama sien, “Mi Pakpak Leong a pevien, ‘E ta ngas rangarie mi Nguts ma Raban ma e ta ngas tsatsang seie mo.’” ");
INSERT INTO tbf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Samo e Satan a nga kerie rakot i Ierusalem ma a nga ra voturie simi korot ta nga tsiroup simi Vona rengeir leong. Ma a nga oeng sien, “Sien va evoi e Natuon e Raban, tsibour peuk i keim, ");
INSERT INTO tbf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","simi vunan mi Pakpak Leong a pevien, “‘E Raban ta turan ken sar angelo nia pernge no. ");
INSERT INTO tbf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gi ta sor terie no i kur ngan bu rimagie terengien va e ta kap mang duorngan mi kame si ka vout.’” ");
INSERT INTO tbf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","E Iesu a nga kuil nama, “Ken nama e Raban a pevien, ‘Kian va e ta konon mi Nguts, ma Raban.’” ");
INSERT INTO tbf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","I murien e Satan tate nga vaton ken sar konokonon kokouk, a nga sorvekenan oit ka ra mene va ta ba buer nga me konon. ");
INSERT INTO tbf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Io, e Iesu a nga vous ngan mi Moromoruo Tamat ma a nga muer rakot i Galili. Ma man vinavatei e Iesu a nga puorkan bu enamon kokouk ververiris i Galili. ");
INSERT INTO tbf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Io, a nga vakaek nge vavasengei i aron bu vona rengeir sibu Iuda. Ma bu mei kokouk gi nga puongan. ");
INSERT INTO tbf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Io, e Iesu a nga rakot i Nasaret ivie ta nga leong en. Ma simi Rangi Minaes, a nga rubukien simi vona rengeir sibu Iuda malan ta nga ko tsana. Ma a nga tamtuir nia ase mi Pakpak Leong. ");
INSERT INTO tbf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gi nga terie sien mi Pakpak Leong e Isaia mi propet ta nga vataro. Ma a nga pakate ine mi Pakpak Leong nge vorotan mi korot ta nga vavataor ven ne, ");
INSERT INTO tbf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mi Morumoruan mi Nguts a kuva iou, simi vunan a te nga vokunie iou va o ta vavatei ngan mi Banga Vinavatei sibu sinaortsak. A te nga tura iou va o ta vakokoit katsep segie gi ta mon simi vinatoreis va gi ta mon ketseketseng, ma segie gi ta kael va gi ta buer dedeng, ma a nga tura iou va o ta ra vara ketseketseng ngan mi kulou gi ta mon simi putu leong. ");
INSERT INTO tbf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma a nga tura iou va o ta vakokoit katsep ngan mi rito mi Nguts va ta vatoa mi kuoluon sien.” ");
INSERT INTO tbf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Io, e Iesu a nga pomutie mi Pakpak Leong ma a nga teir muerngan simi ka nennei Pakpak Leong ma a nga ra mogos. Mi kulou kokouk i aron mi vona rengeir gi nga aan ngan. ");
INSERT INTO tbf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma a nga pevien segie, “Nevere mi namanien e Raban a te tsorubeit tuktuk si kenga bairorrong.” ");
INSERT INTO tbf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Egie kokouk gi nga tienengan ma gi nga kudier ngan ken sar banga nama ta nga vokokotie. Ma gi nga pevien, “Vasa! Kap va eie e natuon e Iosep?” ");
INSERT INTO tbf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","E Iesu a nga oeng segie, “A tuktuk, nga ta vokokotie ine mi namani vinavanou terie seou, ‘Porpor oiv! Vatoa no kese. Tsana ine si ke vuna enamon mi sana gei ta nga rongomie va e nga tsana i Kapernaum.’” ");
INSERT INTO tbf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma a nga pevien, “O oeng tuktuk senga. Kap ka propet a suvu minangarei si ken vuna enamon. ");
INSERT INTO tbf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Si man tuktuk, o oeng senga, sibu avareit se Eliia, palan bu vevien naor gi tate nga mamaet labeit, gi nga mon i Israel. Ma siba avareit a tour ma mi kapien a kap nga uos sien, ma mi se leong a nga betingie mi enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","E Raban a kap nga turan e Eliia rakot si ka kangi Israel ngas te, eiekesen a nga turan rakot simi vevien naor tate nga mamaet labeit i Sarepta i aron mi enamon leong i Sidon. ");
INSERT INTO tbf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma sibu avareit se Elisa mi propet, palan mi kulou i Israel gi nga suvuon mi mienarouk lepra. E Raban a kap nga vatoa gie si magi sar mienarouk, eiekesen e Naaman kesen mo mi kangi Siria.” ");
INSERT INTO tbf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bu mei kokouk gi ta nga mon i aron mi vona rengeir, gi nga aor rarap veie e Iesu sien gi ta nga rongomie ine mi nama. ");
INSERT INTO tbf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gi nga tamtuir ma gi nga veis babate vorotsoruo sorvekenan ine mi taon. Ma gi nga kerie e Iesu rakot i popon mi vam ivie ian gi ta nga tsana ine mi taon en, simi vunan gi nga lalaron va gi ta nga ra duo tomekan e Iesu en. ");
INSERT INTO tbf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Eiekesen a nga veis muer duis ka i aron mi vintuir nge sorvekena gie. ");
INSERT INTO tbf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Io, e Iesu a nga rakot i Kapernaum mi taon i Galili, ma a nga vavasengei simi kulou i aron mi vona rengeir sibu Iuda simi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma gi nga kudier si ken vinasengei simi vunan mi namanien a nga suvu ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","I aron mi vona rengeir, mi ka a nga mon mi tsaka moromoruo ta nga tsegerie. A nga koupkoup leong. ");
INSERT INTO tbf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tsupuk rivie gei! Ke sana tsientsang meie gei, Iesu kuvu i Nasaret? E nemei nia me voguersa gei? O telekiran va evoi ese. Evoi ken Ka Tamat e Raban!” ");
INSERT INTO tbf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","E Iesu a nga patsarie nge pevien, “Bong! Rovotsour sorvekenan ine mi ka!” Samo, ine mi tsaka moromoruo a nga tomeke vuturungie i keim i matagie kokouk nge tsour sorvekenan ine mi ka ma a kap nga tsana ka tsienakor i kurikurien. ");
INSERT INTO tbf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mi kulou kokouk gi nga kudier tsak nge vevirei nge gie, “Mi sana suada nama ine? Ine mi ka a tuturei ngan mi duis ma mi ngeisngeis sibu tsaka moromoruo ma gi rovotsour!” ");
INSERT INTO tbf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma mi nama surie e Iesu a nga puorkan bu korot ververiris ine simi enamon. ");
INSERT INTO tbf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Io, e Iesu a nga sorvekenan mi vona rengeir ma a nga rakot si ken vonuo e Simon. Ken koko e Simon a nga morouk, mi kurikurien a nga rarap. Ma gi nga nongie e Iesu va ta nga me kulie. ");
INSERT INTO tbf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","E Iesu a nga ra tuir i babaren nge kareir rivie mi mienarouk kuirkuir rarap. Io, ian ngas te mi kuirkuir rarap a nga sorvekenan ma ine mi vevien a nga tamtuir nge tsang nginonginou niagie. ");
INSERT INTO tbf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sien mi matanias tate nga nane man mat, mi kulou gi nga kir nemei ngan se Iesu egie gi ta nga suvuon bu suasua mienarouk. Ma a nga soburo nge vatoa gie kokouk si magi sar mienarouk. ");
INSERT INTO tbf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bu tsaka moromoruo buer gi nga rovotsour sorvekenan bu mei palan nge koupkoup pevien, “Evoi e Natuon e Raban!” Eiekesen e Iesu a nga patsarie bu tsaka moromoruo va gi ta kap nga vakokoit, simi vunan gi nga telekiran va eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsourvovo mokuopkuop, e Iesu a nga veis rakot simi korot a nga menemenen. Mi kulou gi nga nesie e Iesu ma sien gi tate nga me vorotan, gi nga konon nia rutie va ta kap nga veis sorvekena gie. ");
INSERT INTO tbf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Eiekesen a nga pevien, “O ta ngas vavatei sibu taon mene buer ngan mi Banga Vinavatei surie ken mangmagoso Nguts e Raban. Ine arie mi vunan e Raban ta nga tura iou surie.” ");
INSERT INTO tbf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma a nga ra vavatei ververiris i Iudea si kegi sar vona rengeir bu Iuda. ");
INSERT INTO tbf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Simi ra mene, e Iesu a nga tuir i gegen mi barateis i Genesaret, ma mi bineit gi nga tuir gonie nge rongomie mi namanien e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","E Iesu a nga pare ba galeu leong luo. Bu ka vongovongon gi nga vogosongie i bourbournga koen, ma gi nga suruvie kegi sar ben. ");
INSERT INTO tbf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A nga ka simi galeu se Simon, ma a nga oeng se Simon va ta nga tsure terie i rou lili. E Iesu a nga mogos i popon ine mi galeu ma a nga vavasengei simi bineit. ");
INSERT INTO tbf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","I murien tate nga vavasengei voto, a nga oeng se Simon, “Vuruos peuk simi raman nge vululusie kenga sar ben.” ");
INSERT INTO tbf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","E Simon a nga kuil nama, “Ka leong, gei te pilang vongovongon simi rokati pu. Eiekesen, sien e ta oeng malan, o ta vululusie ine bu ben.” ");
INSERT INTO tbf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sien gi tate nga tsana malan, gi nga sovie bu ie palan, ma bu ben gi nga vakaek nge kabem. ");
INSERT INTO tbf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Io, gi nga revie bu turagie ka vongovongon simi galeu mene va gi ta nga me kulie gie. Ma gi nga me vakaek nge vovosuo ine ba galeu kokouk, ma guor te nga vatvatta luluis. ");
INSERT INTO tbf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sien e Simon Petro ta nga pare mi sana kepineits ine ta nga tsorubeit, a nga sege pukupukukaek i matan e Iesu, ma a nga pevien, “Sorvekena iou, mi Nguts. Eou mi ka tsokor!” ");
INSERT INTO tbf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A nga tsana malan ine simi vunan e Petro ma bu turan ka vongovongon gi nga kudier tsak ngan ine bu ie palan beitsak gi ta nga sovie. ");
INSERT INTO tbf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","E Iakobo ma e Ioanes, ba natuon e Sebedi, eguor ba turan ka vongovongon e Simon, guor nga kudier tsak buer. Io, e Iesu a nga oeng se Simon, “Kian va e ta motou. Vakaek ine, e tate vangoda mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Gi nga teie terie i kur magi ba galeu, ma gi nga sorvekenan bu kepineits kokouk nge vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Simi ra mene, e Iesu a nga mon simi meinmenien ine bu taon. Ian en, mi ka ta nga suvuon mi mienarouk lepra i kurikurien kokouk, a nga nemei. Sien ta nga pare e Iesu, a nga sege pukupukukaek nge matan i keim ma a nga no masitinoiv, “Mi Nguts, sien va e ta sunuir, e oit nia vara melemelen nge iou.” ");
INSERT INTO tbf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","E Iesu a nga tsotsokan mi riman nge soburo ine mi tamat mienarouk, ma a nga pevien, “O sunuir. E ta melemelen!” Ma ian ngas te, man mienarouk a nga voto. ");
INSERT INTO tbf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","E Iesu a nga oeng ngeisngeis ian simi ka, “Kian va e ta pengan sibu mei mene eiekesen rakot nge vasanga no simi prist. Ma terie ke tienebeir malan e Moses ta nga oeng ngan senga, simi vunan e te tsorubeit melemelen. Ma ian ta vara tuktuk ngan sibu mei mene va ma mienarouk a te voto.” ");
INSERT INTO tbf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Eiekesen mi vinavatei surie e Iesu a te nga puorkan bu enamon ian en ma bu enamon i pek buer. Io, palan mi kulou gi nga ra nemei seie nia rorong, ma gi nga nemei seie surie va ta mang nga vatoa gie si magi sar mienarouk buer. ");
INSERT INTO tbf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Eiekesen e Iesu a nga sorvekena gie nge rakot simi beir nge ra no. ");
INSERT INTO tbf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Simi ra mene, sien e Iesu ta nga vavasengei simi kulou, bu Parisaio ma bu vavvasengei sibu vinuor se Moses buer gi nga mogos. Gi nga kovuni sibu kato enamon keskes i aron i Galili, i Iudea ma i Ierusalem. Ma mi ngesengesien mi Nguts a nga mon meie nia vatoa bu tamat mienarouk. ");
INSERT INTO tbf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Io, ba ka gituo nga sorokie mi muru ngan mi tsur nemei, ma gituo nga lalaro sor terie mi muru i ruom simi vonuo nia ra vuturungie i matan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gituo kap nga oit nia vorotan ka kientsep nia rubukien surie mi bineit a nga beitsak. Io, gituo nga sorvavane i pungan mi vonuo, ma gituo nga bemvaran nge vunurie i kinorotuon mi kulou, duis peuk i matan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","E Iesu a te nga telekiran kegi vodovodon tuktuk, ma a nga pevien, “Palapala, o te vodon rivie ke sar sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma bu vavvasengei sibu vinuor se Moses ma bu Parisaio, gi nga ngungu lili i kotubugie kesegie ven ne, “Nge kia va eie ese ine mi ka ta oeng balapoik ngan e Raban? Ese mei a oit nia vodon rivie mi sinavei tsokor? Ine mi tsientsang, se Raban kesen mo.” ");
INSERT INTO tbf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","E Iesu a te nga telekiran kegi sar vienviendon, ma a nga virei, “Surie misa nga ta suvuon bu suasuada vienviendon sibu aronga? ");
INSERT INTO tbf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mi sana nama a molous nia vokokotie? ‘Ke sar sinavei tsokor o te vodon rivie.’ o, ‘Tsuok tamtuir nge veis.’? ");
INSERT INTO tbf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Io, o ta vakatsepa senga va e Natuon mi Ka a suvuon mi duis i popon mi kaber nia vodon rivie bu sinavei tsokor.” E Iesu a nga oeng simi muru, “O oeng sevoi. Tsuok tamtuir. Sorokie ke tsur nge rakot si ke enamon.” ");
INSERT INTO tbf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ian ngas te, ine mi ka a nga tsuok tamtuir i matagie nge tsuokopie ken tsur ta nga ko mutur ngan ma a nga veis rakot si ken enamon ma a nga puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mi kulou kokouk gi nga kudier tsak nge puongan e Raban. Gi nga vous ngan mi mientou nge pevien, “Giet te pare mi kepineits a kekineits rovoriu nevere.” ");
INSERT INTO tbf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","I murien ine, e Iesu a nga rovotsour ma a nga pare mi ka porpor takis ta nga mogos simi vona porpor takis. Mi asan ine mi ka e Levi. Ma e Iesu a nga kukuo, “Vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Io, e Levi a nga tamtuir nge sorvekenan bu kepineits kokouk nge vemusurie. ");
INSERT INTO tbf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Samo e Levi a nga tsana mi nginou leong si ken vonuo nian e Iesu. Palan mi kulou porpor takis ma palan bu mei mene buer gi nga mogos nge ngou meie guor. ");
INSERT INTO tbf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma bu Parisaio ma bu vavvasengei sibu vinuor se Moses, gi nga nama palan veie ken sar madar tovtov e Iesu nge pevien, “Surie misa nga ta ngou ma un meie bu ka porpor takis ma mi kulou tsokor?” ");
INSERT INTO tbf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","E Iesu a nga kuil nama, “Mi kulou gi ta tino kalei gi kap pinat surie ka porpor oiv, eiekesen bu tamat mienarouk mo. ");
INSERT INTO tbf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","O nga nemei nia kukuo mi kulou tsokor va gi ta mang vodon vuris, a kap va mi kulou duis.” ");
INSERT INTO tbf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma gi nga oeng se Iesu, “Sibu ra palan ken sar madar tovtov e Ioanes gi ko vorvor nge nono. Ma bu madar tovtov sibu Parisaio buer gi ko tsana malan, eiekesen ke sar madar tovtov gi ko tsatsang ngan mo mi ngou ma mi un.” ");
INSERT INTO tbf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","E Iesu a nga oeng segie, “Vasa, nga oit nia oeng sibu vasier va gi ta vorvor sien va mi ka rei vour a ngas mon meie gie? ");
INSERT INTO tbf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Eiekesen mi ra ta beit va gi ta kir tsana ine mi ka rei vour segie. Ian sibu ra gi ta nangba so vorvor.” ");
INSERT INTO tbf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma e Iesu a nga vokokotie mi nama puppuo buer segie. A nga pevien, “A kap ka mei a ko derikie ka poko lavlav simi lavlav vour nge dekitie meie ngan mi lavlav kebeir. Sien va ta tsang malan ngan ine, eie ta tsang vatsakatie ine mi lavlav vour. Ma ian mi poko lavlav vour ta kap venvenioit meie mi lavlav kebeir. ");
INSERT INTO tbf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma a kap ka mei a ko soe teir dangi vain vour i aron bu utut kebeir gi ta tsana nge piripiri vinavinar. Sien va ta tsang malan ngan ine, mi dangi vain vour ta tsana bu utut kebeir va gi ta puor kapot. Ma mi dangi vain tate puos ririv, ma bu utut buer tate tsak. ");
INSERT INTO tbf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Io, gi ta ngas utuvie mi dangi vain vour simi utut vour. ");
INSERT INTO tbf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma eie ese ta unumie mi dangi vain kebeir, ta kap ba lalaron mi dangi vain vour. Eie ta pevien, ‘Mi dangi vain kebeir eie a kalei.’” ");
INSERT INTO tbf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Simi Rangi Minaes, e Iesu meie ken sar madar tovtov gi nga veis i aron bu tau wit. Ma ken sar madar tovtov gi nga do tsana bu kievkiev wit, ma gi nga gosaran sibu rimagie nge nganie bu pi wit. ");
INSERT INTO tbf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bu meinmenien bu Parisaio gi nga oeng se Iesu, “Surie misa nga ta tsana mi sinavei ian ta kap vemusurie man vinuor mi Rangi Minaes?” ");
INSERT INTO tbf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","E Iesu a nga kuil nama, “Nga kap ngas nga ase misa e Davit ta nga tsana sien eie ma bu palapalan gi ta nga vitor? ");
INSERT INTO tbf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A nga rubukien si ken vonuo e Raban, ma a nga poro mi tsoik tamat, ma a nga nganie. Vemusurie mi vinuor, ine mi tsoik kap ka mene a oit nia nganie eiekesen bu prist mo. Ma a nga tabarie ngan buer bu palapalan.” ");
INSERT INTO tbf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Samo a nga oeng segie, “E Natuon mi Ka eie man Nguts mi Rangi Minaes.” ");
INSERT INTO tbf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma simi Rangi Minaes mene e Iesu a nga rubukien i aron mi vona rengeir sibu Iuda nge vavasengei, ma mi ka a nga mon ian en, mi riman suv a nga maet. ");
INSERT INTO tbf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bu vavvasengei sibu vinuor ma bu Parisaio gi nga moun ngan nia dengarie va ta nga vatoa ka tamat mienarouk simi Rangi Minaes, terengien va gi ta mang nga vepitsie. ");
INSERT INTO tbf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Eiekesen e Iesu a te nga muna telekiran kegi sar vienviendon ma a nga oeng ian simi ka riem maet, “Tamtuir nge me tuir i matan mi lobaram.” Io, a nga tsuok tamtuir nge me tuir. ");
INSERT INTO tbf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Samo e Iesu a nga oeng segie, “O ta vereie nga, mi sana a duis i matan mi vinuor nia tsana simi Rangi Minaes? Nia tsana mi kienelei, o, nia tsana mi tsienakor? Nia vatoa mi mei, o, nia voguersan?” ");
INSERT INTO tbf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E Iesu a nga dedeng veriris segie kokouk, ma samo a nga oeng ian simi ka, “Kadosan mi rima.” Io, a nga tsana malan, ma mi riman a te buer nga kalei. ");
INSERT INTO tbf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eiekesen gi nga ngengeir nge vakaek nge vevuor surie mi sana va gi ta nga oit nia tsana se Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ian simi ra, e Iesu a nga veis kien simi pout nia ra no ma a nga nono rakot se Raban ian simi rokati. ");
INSERT INTO tbf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ma sivovo sien, a nga kuk nemei ngan ken sar madar tovtov ma a nga me viel tsana mi sinangavur kes ma luo segie, ma a nga vuotongie gie va bu aposol. ");
INSERT INTO tbf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Arie egie ine. E Simon (ese ta nga vuotongie ngan e Petro), e Andre e kasien, e Iakobo, e Ioanes, e Pilipo, e Bartolomeu, ");
INSERT INTO tbf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Mataio, e Tomas, e Iakobo e natuon e Alpeo, e Simon ese gi ta nga vuotongie ngan mi Silot, ");
INSERT INTO tbf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Iudas e natuon e Iakobo, ma e Iudas Iskariot, ese ta nga tsorubeit mi ka nia roev terie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","E Iesu a nga tsotsour peuk meie gie nge tuir simi kato kaber duis. Mi gargar leong si ken sar madar tovtov gi nga mon ian en meie mi bineit leong beitsak kovuni sibu korot kokouk i Iudea, kovuni i Ierusalem, ma kovuni sibu enamon i koen i Turos ma i Sidon. ");
INSERT INTO tbf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gi nga nemei nia rongomie e Iesu terengien va ta mang nga vatoa gie si magi sar mienarouk. Ma egie ese bu tsaka moromoruo ta nga vikikinie gie, gi nga kalei. ");
INSERT INTO tbf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma mi kulou kokouk gi nga konon nia tobelie e Iesu, simi vunan mi ngeisngeis a nga kovuni seie ma a nga vatoa gie kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","E Iesu a nga dedeng rakot si ken sar madar tovtov nge pevien, “Mi nires leong ta mon senga ese nga ta deng kielala va nga pinat sibu morumoruanga, simi vunan nga ta so suvuon mi vavatamaes kovuni si ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mi nires leong ta mon senga ese nga ta vitor ine, simi vunan e Raban ta so vitingie nga. Mi nires leong ta mon senga ese nga ta ta ine, simi vunan nga ta so ngiets. ");
INSERT INTO tbf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mi nires leong senga sien gi ta karto nga nge purusie nga, ma gi ta vavangiets nge nga, nge tsang vatsakatie bu asanga surie e Natuon mi Ka. ");
INSERT INTO tbf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Nga ta ngas res ian simi ra nge kolueits ngan mi nires, simi vunan kenga voirvoir ta leong die i kur simi rangit. Ine simi sinavei kes mo, bu tubugie gi nga tsana sibu propet. ");
INSERT INTO tbf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Eiekesen mi tsienakor leong ta monongie nga ese nga ta suvuram, simi vunan nga te suvuon mi tino ta molous. ");
INSERT INTO tbf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mi tsienakor leong ta monongie nga ese nga ta ngou kalei ine, simi vunan nga ta so vitor. Mi tsienakor leong ta monongie nga ese nga ta ngiets ine, simi vunan nga ta so masitinoiv nge ta. ");
INSERT INTO tbf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mi tsienakor leong ta monongie nga sien mi kulou kokouk gi ta vakokoit tienenge nga, surie malan ian, bu tubugie gi nga tsana sibu propet bitbit. ");
INSERT INTO tbf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Eiekesen o oeng senga ese nga ta rorong seou. Nga ta ngas tovie manga sar matakorot, nge kalei ngan egie ese gi ta karto nga. ");
INSERT INTO tbf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nga ta ngas vatamase gie ese gi ta oeng subira nga. Ma no surie egie ese gi ta tsak nge nga. ");
INSERT INTO tbf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sien va ka mei ta pantsie ke peir kes, vuris terie sien ke peir ka ie buer. Sien va ka mei a poro ma kuirkuir ka i marar, kian va e ta vangenge va ta poro ma kuirkuir ka i ruom buer. ");
INSERT INTO tbf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tabarie bu mei kokouk gi ta nongie no, ma sien va ka mei a poro misa va sevoi, kian va e ta no muerngan. ");
INSERT INTO tbf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tsana sibu mei mene malan nga ta lalaron va gi ta tsana senga. ");
INSERT INTO tbf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Sien va nga ta tovie mo egie ian ese gi ta tovie nga, vasa nga ta suvuon ven ka vavatamaes? Misasien bu ka tsokor, gi ko tovie egie ese gi ta tovie gie. ");
INSERT INTO tbf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma sien va nga ta tsana mi kepineits ta kalei segie ese gi ta muna tsana mi kienelei senga, vasa nga ta suvuon ven ka vavatamaes? Misasien bu ka tsokor, gi ko tsana malan buer. ");
INSERT INTO tbf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma sien va nga ta vavatsir segie ese nga ta vodon va nga ta poro man venemuer, vasa nga ta suvuon ven ka vavatamaes? Misasien bu ka tsokor, gi vavatsir buer rakot sibu ka tsokor meie ngan kegi vienviendon nia por muerngan man voirvoir pu. ");
INSERT INTO tbf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eiekesen nga ta ngas tovie manga sar matakorot. Tsana mi kienelei segie, ma nga ta vavatsir segie nge kap vodon nia por muerngan ka kepineits segie. Ma kenga voirvoir ta so leong, ma nga ta so tsorubeit bu natuon e Raban ese ta tsiroup, simi vunan eie a kalei ngan egie gi ta kap ko vuot kalei sien ma bu tsaka mei. ");
INSERT INTO tbf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nga ta ngas vous ngan mi aor molous, malan mo e Tamanga ta vous ngan mi aor molous. ");
INSERT INTO tbf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ma kian va nga ta vuortie ka mei mene, terengien e Raban ta kap mang vuortie nga. Kian va nga ta votorosie ka mei mene, terengien e Raban ta kap mang votorosie nga. Nga vodon rivie kegi sar sinavei tsokor, terengien e Raban ta mang vodon rivie kenga sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tabetabeir, terengien e Raban ta mang tabarie nga. E Raban ta vovosuo ma ta vous puospuos vunie nga. A tuktuk, mi sana puppuo nga ta pupuo ngan, e Raban ta tsang malan ngan mo senga.” ");
INSERT INTO tbf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","E Iesu a nga pengan segie buer ine mi nama puppuo, “Ka kael a kap oit nia muongan ka turan kael, va gerek? Vasa, guor ta kap so kor rubukien i aron ka mat? ");
INSERT INTO tbf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ka madar tovtov a kap tsiroup si man vavvasengei, eiekesen eie ese man vavvasengei ta vavasengei kalei sien, ta so tsorubeit malan man vavvasengei. ");
INSERT INTO tbf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Surie misa e ta dengarie mi kato tsop i matan e kasi ma e kap vodon surie mi poko ei i mata kese? ");
INSERT INTO tbf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vasa ta oit ven va e ta oeng se kasi nge kia, ‘Kasi, o ta tsang rivie mi tsop ian i mata,’ eiekesen evoi e kap oit nia dengarie mi poko ei i mata kese? Evoi mi malamala ka duis. Vourvour, e ta muna tsang rivie mi poko ei i mata, ma samo e ta nangba oit nia dedeng kalei nia tsang rivie mi tsop i matan e kasi. ");
INSERT INTO tbf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kap ka banga ei a vua ngan ka tsaka vuovuo, o, ka tsaka ei ta vua ngan ka banga vuovuo. ");
INSERT INTO tbf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mi ei keskes a kilakilal nan simi vuovuan kesen. Bu mei gi kap dikitie mi vuavua ta o, mi vuavua bereu simi suo tsotso. ");
INSERT INTO tbf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mi banga ka a vorotsoruo bu banga kepineits sibu banga kepineits ta noutngan i aron, ma mi tsaka ka a vorotsoruo bu tsaka kepineits sibu tsaka kepineits ta noutngan i aron. Mi kulou gi ko vokokotie mi sana ta vous i arogie. ");
INSERT INTO tbf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Surie misa nga vuotongie iou va, ‘Mi Nguts, mi Nguts,’ ma nga kap tsana misa o ta pengan? ");
INSERT INTO tbf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","O ta vasangan senga vasa ta ven eie ese ta nemei seou nge rongomie kong sar nama nge tsang vemusurie. ");
INSERT INTO tbf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Eie a malan mi ka ta nga tsana mi vonuo ese ta nga reiv peuk beitsak i keim nge voturie man arir mi vonuo i popon mi ropoil. Mi taev a nga nemei nge soraran ian mi vonuo eiekesen a kap nga oit nia une, simi vunan a nga tsang vititirie. ");
INSERT INTO tbf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Eiekesen mi mei ese ta rongomie kong sar nama ma a kap tsang vemusurie, eie a malan mi mei ese ta nga tsana mi vonuo i popon mi pier a kap ka poil en. Sien mi taev leong ta nga soraran ian mi vonuo, a nga katsoup kor nge sereir ruruvei.” ");
INSERT INTO tbf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sien e Iesu tate nga vavasengei voto ngan ine bu kepineits simi kulou, a nga veis beit i Kapernaum. ");
INSERT INTO tbf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ian en, ken petspets mi muomuo simi kulou ni minakiur a nga mon, ma man muomuo a nga ko lalaron beitsak. Eiekesen a nga morouk nge vatvatta mesei. ");
INSERT INTO tbf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mi muomuo simi kulou ni minakiur a nga rongovan e Iesu ma a nga turan bu meinmenien bu muomuo sibu Iuda rakot sien nia ra vereie va ta nga nemei nge me vatoa ken petspets. ");
INSERT INTO tbf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sien gi ta nga nemei se Iesu, gi nga me no masitinoiv sien malan ne, “Ine mi ka, a oit ngas va e ta kulie, ");
INSERT INTO tbf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","simi vunan eie a tovie gei bu Iuda ma a te nga voturie kegei vona rengeir.” ");
INSERT INTO tbf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Io, e Iesu a nga nomeie gie. Sien tate nga so beit vatavatat simi vonuo, mi muomuo simi kulou ni minakiur a nga turan bu palapalan nia ra oeng sien malan ne, “Mi Nguts, kian va e ta voruruit beitsak, simi vunan o kap kalei oit nia tor va e ta nemei si kong vonuo. ");
INSERT INTO tbf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ine arie mi vunan o kap vodon buer va o kalei oit nia nemei sevoi. Eiekesen, vuotongie mo ka nama, ma kong petspets ta kalei. ");
INSERT INTO tbf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Eou buer o mon i pakien mi vinuor, ma buer mi kulou ni minakiur gi mon i pakien kong vinuor. O ta oeng seie ine, ‘Veis,’ ma eie ta veis, ma seie nikot o ta oeng sien, ‘nemei,’ ma eie ta nemei. O oeng si kong petspets, ‘Tsana ine,’ ma eie ta tsana.” ");
INSERT INTO tbf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sien e Iesu ta nga rongomie ine, a nga kudier beitsak surie mi namanien ine mi ka, ma a nga vuvuris teteir simi bineit gi ta nga vemusurie nge pevien, “O oeng senga, o kap ngas nga vorotan ka suada vodovodon tuktuk ta leong malan ine, misasien i Israel buer.” ");
INSERT INTO tbf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Samo mi kulou ian mi muomuo ta nga tura gie, gi nga muer rakot si ken vonuo ma gi nga so vorotan ine mi petspets tate nga kalei. ");
INSERT INTO tbf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","I muir sien, e Iesu a nga rakot simi taon i Nain. Ma ken sar madar tovtov meie mi bineit leong gi nga nomeie. ");
INSERT INTO tbf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma sien tate nga so beit simi rumrubukien simi taon, mi kuoluon ine mi taon gi nga sor vorotsoruo mi mei maet, eie e natuon kes mo mi vevien naor tate nge mamaet labeit. Ma mi bineit leong simi taon gi nga nomeie. ");
INSERT INTO tbf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sien mi Nguts ta nga pare ine mi vevien, a nga tovie beitsak nge pevien, “Kian va e ta ta.” ");
INSERT INTO tbf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Samo a nga veis rakot nge soburo mi tsur gi ta nga sorokie ngan mi tonuo, ma egie ian gi ta nga sorokie, gi nga tuir vendir. Ma a nga pevien, “Ka vour, o oeng sevoi. Tsuok tamtuir!” ");
INSERT INTO tbf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mi ka ese ta nga mesei a nga mogos ma a nga vakaek nge vakokoit, ma e Iesu a nga teir muerngan se kinan. ");
INSERT INTO tbf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Egie kokouk gi nga vous ngan mi mientou ma gi nga puongan e Raban nge pevien, “Mi propet ngeisngeis a te tsorubeit i kotubugiet. E Raban a te nemei nia kulie ken kulou.” ");
INSERT INTO tbf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ine mi vinavatei surie e Iesu a nga puorkan kokouk i Iudea ma bu enamon ververiris. ");
INSERT INTO tbf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ken sar madar tovtov e Ioanes gi nga pengan sien ine bu kepineits kokouk. Io, e Ioanes a nga kuk nemei ngan ba mei luo segie. ");
INSERT INTO tbf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ma a nga tura guor rakot simi Nguts nia ra vereie malan ne, “Arie evoi te ian mi ka va ta ba beit, o, gei ta ngas rosie ka mei mene?” ");
INSERT INTO tbf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sien ba ka guor tate nga nemei se Iesu, guor nga pevien, “E Ioanes mi ka ni sinusuruiv a tura gor nemei sevoi nia me virei malan ne, ‘Arie evoi te ian mi ka va ta ba beit, o, gei ta ngas rosie ka mei mene?’” ");
INSERT INTO tbf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ian simi keipkepide ra e Iesu a nga vatoa palan egie ese gi ta nga suvuon bu suada mienarouk ma egie ese bu tsaka moromoruo ta nga tsegerie gie. Ma a nga vatoa palan bu kael. ");
INSERT INTO tbf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Io, e Iesu a nga kuil nama siba ka guor ta nga veis teie mi nama, “Ngado muer nge so pengan se Ioanes mi sana ngado tate pare nge rongomie. Bu kael gi te dedeng, bu peong gi te veis, egie ese gi ta suvuon mi mienarouk lepra gi te ketseketseng, bu pi gi te rorong, bu mei maet gi te to muerengei simi miensei ma bu sinaortsak gi te rongomie mi Banga Vinavatei. ");
INSERT INTO tbf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mi nires leong ta mon seie ese ken vodovodon tuktuk seou ta kap kor.” ");
INSERT INTO tbf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","I murien ine ba ka e Ioanes ta nga turan guor tate nga veis, e Iesu a nga vakaek nge vakokoit rakot simi bineit surie e Ioanes. “Sien nga ta nga rakot simi beir, misa nga nga visi ra pare? Mi rir mi mour ta uvie? ");
INSERT INTO tbf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sien va a kap, mi sana nga nga ra dengarie? Mi ka a vavaso ngan bu banga tsetstseik? A kap, egie ese gi ta vavaso ngan bu tsetstseik ta matmatot ma gi ta ko mon simi sinavei nia pinike tuvuon ngan kegi lakep leong nia varese mo kegi tino simi pirpir, gi mon i aron bu vonuo sibu kovakova ka leong. ");
INSERT INTO tbf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eiekesen, surie misa nga ta nga rakot en? Nia ra pare mi propet? A tuktuk, o oeng senga, nga te nga pare mi ka mi tsinatsangan ta rio mi propet. ");
INSERT INTO tbf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ine arie mi ka ese gi ta nga vavataor surie simi Pakpak Leong: “‘O ta turan kong ka ni vavatei muo sevoi, ese ta rorois ngan ke rosar i muo sevoi.’ ");
INSERT INTO tbf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","O oeng senga, i kotubugie ese ian mi langei gi ta nga kava gie, a kap ka mei a leong rio e Ioanes, eiekesen mi mei ese ta lili i aron ken mangmagoso Nguts e Raban, eie a leong rio e Ioanes.” ");
INSERT INTO tbf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Mi kulou kokouk ma mi kulou porpor takis buer, sien gi ta nga rongomie ken sar nama e Iesu, gi nangba nga teorbeten va mi sinavien e Raban a nga duis, simi vunan gi te nga por sinusuruiv se Ioanes. ");
INSERT INTO tbf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Eiekesen bu Parisaio ma bu vavvasengei sibu vinuor se Moses gi nga purusie ken vienviendon e Raban surie egie kesegie, simi vunan gi kap nga por sinusuruiv se Ioanes.) ");
INSERT INTO tbf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Samo e Iesu a te buer nga vakokoit, “Mi sana o ta oit nia pua meie mi kuoluon ine bu ra? Gi mala sa? ");
INSERT INTO tbf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Egie gi malan bu madar gi ta mogos simi korot nia verikuil nge lakep ma gi koupkoup vunie egie ka ie. “‘Gei kuvie bu pak ngan bu poko veos va nga ta sieng, eiekesen nga kap sieng, gei kavarie mi pak nian mi miensei, eiekesen nga kap ta.’ ");
INSERT INTO tbf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","O pengan senga ine surie e Ioanes mi ka ni sinusuruiv tate nga nemei. A kap nga me ngou tsoik, ma un dangi vain, ma nga ko pevien va eie a suvuon mi tsaka moromoruo. ");
INSERT INTO tbf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","E Natuon mi Ka a nga nemei ma a nga ngou nge un, ma nga ko pevien, ‘Pare! Eie mi ka ngangeis ma mi ka unun, ma e palapalan mi kulou porpor takis meie mi kulou tsokor!’ ");
INSERT INTO tbf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eiekesen mi kulou ese gi ta tino ngan mi banga vienviendon se Raban, gi vara tuktuk ngan va ine mi banga vienviendon a duis.” ");
INSERT INTO tbf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mi meinmenien bu Parisaio a nga nongie e Iesu va ta nga ra ngou meie. Io, e Iesu a nga rakot si ken vonuo ian mi Parisaio ma a nga so mogos meie gie i bingan mi tsur ngongou. ");
INSERT INTO tbf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi vevien ian simi taon mi sinavien a nga tsokor, a nga vakierngie va e Iesu a nga ngou si ken vonuo ine mi Parisaio. Io, a nga por nemei ngan mi utut mi da sosong i aron. ");
INSERT INTO tbf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma a nga me tuir i murien e Iesu, ma a nga sege pukupukukaek siba kamen nge ta. Ma a nga vakaek nge pupuluka ba kamen ngan ken sar dunutina. Samo a nga dou vopura ngan bu vuruvuru kovan, ma a nga ngungurie ba kamen nge soan mi da sosong i popon ba kamen. ");
INSERT INTO tbf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sien mi Parisaio ese ta nga nongie nemei ngan e Iesu ta nga dengarie ine, a nga oeng veie mi aron, “Sien va eie mi propet, a oit nia telekiran mi sana suada vevien ine a tobelie, surie eie mi vevien tsokor.” ");
INSERT INTO tbf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","E Iesu a nga kuil nama, “Simon, o lalaro pengan sevoi mi kepineits.” E Simon a nga pevien, “Pengan seou, Vavvasengei.” ");
INSERT INTO tbf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Ba ka luo, guor nga por lakep nia kuil muerngan simi ka. Mi mei a nga poro bu sinangavur mi napaririem koboit (500) bu lakep denari ma mi mei mene bu sinangavur napaririem (50) bu silva lakep. ");
INSERT INTO tbf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A kap ka mei seguor a nga suvu lakep oit nia kuil muerngan ine simi ka. Io, ngan mi aor molous, a nga vodon tsupuk rivie seguor. Ma ine, e vodon ese seguor ta lalaron beitsak ine mi ka?” ");
INSERT INTO tbf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","E Simon a nga kuil nama, “O vodon va ian mi mei ta nga poro ta palan ma va ta kap ba kuil muerngan.” E Iesu a nga pevien, “A duis ke nama.” ");
INSERT INTO tbf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Samo a nga vuvuris rakot simi vevien ma a nga pevien se Simon, “E pare ine mi vevien? O nemei i aron ke vonuo. Evoi e kap terie seou ka da nian ba kameung, eiekesen eie a pupuluka ba kameung ngan ken sar dunutina ma a dou vopura ba kameung ngan mi vuruvuru kovan. ");
INSERT INTO tbf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","E kap ngungurie iou, eiekesen ine mi vevien, vakaek o ta rubukien, a kap matpomaer nia ngungurie ba kameung. ");
INSERT INTO tbf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","E kap soe teir oel i kovoung, eiekesen eie a soan mi da sosong siba kameung. ");
INSERT INTO tbf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Io, o oeng sevoi, ken lalaron ine mi vevien nemei seou a leong beitsak, simi vunan o te vodon rivie palan ken sar sinavei tsokor. Eiekesen eie ese o ta vodon rivie ken sar sinavei tsokor ta kap palan, ken lalaron nemei seou ta lili.” ");
INSERT INTO tbf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","E Iesu a nga oeng simi vevien, “Ke sar sinavei tsokor o te vodon rivie.” ");
INSERT INTO tbf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bu vasier ka ie, gi nga vakaek nge vevuor i kotubugie kesegie, “Nge kia va eie ese ine mi ka? Bu sinavei tsokor buer a vodon rivie gie.” ");
INSERT INTO tbf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","E Iesu a nga oeng simi vevien, “Ke vodovodon tuktuk a te vatoa no. Veis ngan mi molu.” ");
INSERT INTO tbf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","I murien ine, e Iesu a nga veisngie bu taon ma bu enamon keskes, ma a nga vavatei katsep simi kulou ngan mi Banga Vinavatei surie ken mangmagoso Nguts e Raban. Mi sinangavur kes ma luo bu madar tovtov gi nga nomeie. ");
INSERT INTO tbf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bu vevien mene e Iesu ta nga kareir rivie bu tsaka moromoruo segie nge vatoa gie si magi sar mienarouk, egie buer gie nga nomeie. Mi meinmenigie, e Maria kovuni i Magadala ese e Iesu ta nga kareir rivie mi napaririem potsu luo bu tsaka moromoruo sien, ");
INSERT INTO tbf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma ba meinmenien mene, e Ioana ken vevien e Kusa mi ka nennei si ken vonuo e Erot, a, e Susana, ma palan bu mei mene gi nga nomeie. Ine bu vevien gi nga kulie e Iesu meie ken sar madar tovtov ngan kegi sar kepineits kesegie. ");
INSERT INTO tbf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sien mi kulou gi ta nga vor ve beitbeit kovuni sibu taon kokouk nge vorotan e Iesu, a nga vokokotie mi nama puppuo segie. ");
INSERT INTO tbf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mi ka tsuotstsuor a nga ra rivie ken sar pi ei. Sien ta nga rivie bu pi ei, bu pei mene gi nga kor i popon mi baiveisveis. Mi kulou gi nga popoporie ma bu ma gi nga nganie gie. ");
INSERT INTO tbf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bu pei mene gi nga kor simi popopeliets. Gi nga tsutsuleik rovotsour eiekesen gi nga bukuk nge maet simi vunan kap ka da simi pier. ");
INSERT INTO tbf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bu pei mene gi nga kor i kinorotuon bu suo tsotso. Ine bu suo tsotso gi nga to leong meie bu ei tsuotstsuor ma gi nga pipitsie bu ei tsuotstsuor. ");
INSERT INTO tbf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma bu pei mene, gi nga kor simi banga pier ma gi nga to leong nge vua nge vuovuo. Bu pei keskes gi nga vua ngan bu vuovuo a nga oit mi sinangavur kes koboit (100) rio misa gi ta nga tsuorkie.” Sien e Iesu ta nga vaton ken nama puppuo, a nga oeng leong, “Eie ese ta suvu taterieng nia rorong, ta ngas rorong.” ");
INSERT INTO tbf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ken sar madar tovtov gi nga vereie e Iesu ngan man vuevue ine mi nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Io, a nga pevien, “E Raban a te nga terie senga mi sinavei nia telekiran bu kepineits mumuningei surie ken mangmagoso Nguts. Eiekesen sibu mei mene, o vakokoit surie ine ngan mi nama puppuo. Terengien, “‘va gi ta kap mang dedeng kilal misasien gi ta dedeng nge dedeng, va gi ta kap mang telekiran misasien gi ta rorong nge rorong.’ ");
INSERT INTO tbf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Man papapleis ine mi nama puppuo a malan ne. Ine mi pi ei, eie ken nama e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bu pei gi ta nga kor simi baiveisveis, egie gi malan bu mei gi ta rongomie mi nama. I murien ine, e Satan a nemei ma a tsang rivie ine mi nama sibu arogie, terengien va gi ta kap mang vodovodon tuktuk ma e Raban ta kap mang vatoa gie. ");
INSERT INTO tbf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bu pei mene gi ta nga kor simi korot bu vout en, egie gi malan bu mei gi ta rong poro mi nama ngan mi nires. Eiekesen kap kavo uvigie. Kegi vodovodon tuktuk ta to lili mo, ma gi ta kor sien va ka konokonon ta beit. ");
INSERT INTO tbf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bu pei gi ta nga kor i kinorotuon bu suo tsotso, egie gi malan bu mei gi ta rongomie mi nama, eiekesen si kegi minon, bu suasua vienviendon aor tsak, mi sinsuv ma bu nires simi tino, gi ta pipitsie ma bu vuovuan gi kap oit nia komois. ");
INSERT INTO tbf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eiekesen bu pei gi ta nga kor simi banga pier, gi malan bu mei gi ta rongomie mi nama ngan mi banga aor nge rong toungan si kegi sar tino ma gi tuir ngeisngeis nge vua nge vuovuo. ");
INSERT INTO tbf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kap ka mei a ko vakartie ka bember nge kuva ngan mi koi o, a ko terie i pakien mi tsur. Eiekesen a ko poro nge vogosongie si man mogomogos, terengien egie ese gi ta rubukien gi ta mang pare mi berber. ");
INSERT INTO tbf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bu kepineits kokouk gi ta mon mumuningei, gi ta beit simi taparang, ma bu kepineits kokouk gi ta mon kokoiv, bu mei gi ta telekiran o, gi ta beit simi kientsep. ");
INSERT INTO tbf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Io, nga ta ngas vedidir surie kenga sar bairorrong. Segie ese gi ta tor surie kong sar vinasengei, e Raban ta buer veleongtie kegi sinavei. Eiekesen segie ese gi ta kap lalaron, misasien misa gi ta vodon va gi suvuon, e Raban ta por tsana segie.” ");
INSERT INTO tbf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Samo e kinan ma bu kasien e Iesu gi nga nemei nia me pare. Eiekesen gi kap nga oit va gi ta nga pare surie mi bineit a nga kitipan. ");
INSERT INTO tbf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mi ka mene a nga pengan se Iesu, “E kina ma bu kasi, die gi tuir i marar, ma gi lalaro pare no.” ");
INSERT INTO tbf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A nga kuil nama, “Mi kulou gi ta rongomie mi namanien e Raban nge vemusurie, arie egie bu kinoung ma bu kasiung.” ");
INSERT INTO tbf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Simi ra mene, e Iesu a nga ka simi galeu leong meie ken sar madar tovtov ma a nga oeng segie, “Giet ta rakot simi bienengeiv ka nikot simi barateis.” Ma gi nga tsuk. ");
INSERT INTO tbf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Simi poko ra mi galeu ta nga soer, e Iesu a te nga muang. Ma mi lon a nga tsorungie gie i rou. A, mi naov gi nga vakaek nge kopo vovoi simi galeu. Ma gi nga vatvatta luluis. ");
INSERT INTO tbf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ken sar madar tovtov gi nga vapada nge oeng sien, “Ka leong, Ka leong, giet te vatvatta luluis!” Ma a nga tamtuir nge oeng ngeisngeis veie mi mour ma bu peiv. Ma a nga tiko. ");
INSERT INTO tbf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma a nga vereie ken sar madar tovtov, “Iva kenga vodovodon tuktuk?” Gi nga motou nge kudier tsak ma gi nga vevuor i kinorutugie malan ne, “Mi sana suada ka ine? Misasien mi mour ma bu peiv, a oeng ngeisngeis segie ma gi rorong sien.” ");
INSERT INTO tbf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Samo gi nga soer rakot i Gerasa, mi enamon simi bienengeiv ta matan veie i Galili. ");
INSERT INTO tbf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sien e Iesu ta nga tsour vataer simi galeu, mi ka kovuni ian simi taon bu tsaka moromoruo gi ta nga tsegerie, a nga veis samsuoeie. A te nga potaram te, ine mi ka a kap nga ko lavlav ma a kap nga ko mon si ka vonuo, eiekesen a nga ko mon sibu rie tetteir tonuo. ");
INSERT INTO tbf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sien ta nga pare e Iesu, a nga koup nge tsibour mutur i matan e Iesu nge koupkoup pevien, “Iesu, evoi e Natuon e Raban ese ta tsiroup. Ke sana baitutuir meie iou? O no masitinoiv. Kian va e ta votorosie iou!” ");
INSERT INTO tbf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A nga koup malan ine simi vunan e Iesu a nga oeng ven va mi tsaka moromoruo ta nga sorvekenan ine mi ka. Mi tsaka moromoruo a nga ko tsegerie. Misasien va bu mei gi ta nga rorotsie nge tsen ba riman ma ba kamen nge tuir karie, a nga ko motukie bu tsen. Ma mi tsaka moromoruo a nga ko tsal ngan rakot sibu korot kap kavo mei en. ");
INSERT INTO tbf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","E Iesu a nga vereie, “Ese mi asa?” A nga kuil nama, “e Gargarleong,” simi vunan bu tsaka moromoruo palan gi nga tsegerie. ");
INSERT INTO tbf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma bu tsaka moromoruo gi nga no masitinoiv rakot se Iesu va ta kap nga sunura gie rakot simi Mat kap ka vunan. ");
INSERT INTO tbf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ian en, mi varin bor leong gi nga vivieir simi kuitskuits. Bu tsaka moromoruo gi nga nongie e Iesu va ta nga ture vurukude gie i aron bu bor. Ma e Iesu a nga sunuir terie gie. ");
INSERT INTO tbf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma bu tsaka moromoruo gi nga sorvekenan ine mi ka rakot ine sibu bor. Ine mi varin gi nga soer peuk simi malamala tsetseir ma gi nga tsibour nge kong maet i rou. ");
INSERT INTO tbf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sien bu ka nennei bor, gi ta nga pare ine mi kepineits ta nga tsorubeit, gi nga vi nge soer rakot nge ra vavatei ngan simi taon ma sibu enamon. ");
INSERT INTO tbf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma mi kulou gi nga me pare ine mi kepineits ta nga tsorubeit. Sien gi tate nga me beit se Iesu, gi nga vorotan ine mi ka bu tsaka moromoruo gi tate nga tsour sorvekenan, a nangba nga lavlav ma a te nga tsorubeit muerengei nangba ken vienviendon. Ma a nga mogos i babaren ba kamen e Iesu. Io, gi nga motou. ");
INSERT INTO tbf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mi kulou gi ta nga pare ine mi kepineits, gi nga pouts ngan sibu mei mene vasa ine mi ka bu tsaka moromoruo gi ta be nga tsegerie, a nga ketseketseng ven. ");
INSERT INTO tbf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Samo mi kulou kokouk sibu enamon ververiris i Gerasa gi nga nongie e Iesu va ta nga sorvekena gie simi vunan mi mientou leong a te nga vara sigosigong ngan mi enamon. Ma e Iesu a nga ka simi galeu nge tsuk sorvekena gie. ");
INSERT INTO tbf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ine mi ka bu tsaka moromoruo gi tate nga tsour sorvekenan, a nga no masitinoiv se Iesu va ta nga nomeie. Eiekesen e Iesu a nga ture muerngan ma a nga oeng sien, ");
INSERT INTO tbf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Muerengei rakot si ke enamon nge ra oeng katsep ngan mi sana banga tsientsang leong e Raban a te tsana sevoi.” Io, ine mi ka a nga veis nge ra vavatei ngan bu banga tsientsang leong e Iesu ta nga tsana sien, simi kulou kokouk simi taon. ");
INSERT INTO tbf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Si ken minuer e Iesu, mi bineit gi nga res suoeie, simi vunan gi nga vor ve rosierosie. ");
INSERT INTO tbf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Samo, mi ka mi asan e Iairo a nga nemei, eie mi muomuo simi vona rengeir sibu Iuda. A nga me sege pukupukukaek i matan e Iesu. Ma a nga no masitinoiv va e Iesu ta nga nomeie rakot si ken vonuo, ");
INSERT INTO tbf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","simi vunan e natuon vevien mi kav kes, ese ken sar avareit tate nga sinangavur kes ma luo, a te nga vatvatta mesei. Sien e Iesu tate nga veis rakot, mi bineit gi nga vususungie. ");
INSERT INTO tbf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Io, mi vevien a nga mon i kotubugie. Ine mi vevien a nga suvuon mi mienarouk nia kavakava mi dar sibu avareit mi sinangavur kes ma luo, eiekesen kap ka mei a nga oit nia vatoa si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A nga ka i murien e Iesu nge tobelie mi tangatson ken lavlav. Ma ian ngas te, a kap nga kava te mi dar. ");
INSERT INTO tbf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma e Iesu a nga virei, “Ese a tobelie iou?” Egie kokouk gi nga pevien va gi kap nga telekiran. E Petro a nga pevien, “Ka leong, bu mei palan beitsak ine, gi vususungie no.” ");
INSERT INTO tbf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Eiekesen e Iesu a nga pevien, “Mi mei ngas te a tobelie iou. O rongmetsikien va mi ngeisngeis a te tsour sorvekena iou.” ");
INSERT INTO tbf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Sien ine mi vevien tate nga telekiran va a kap ba nga oit nia mumuningei, a nga dedeir nge veis rakot se Iesu. Ma a nga sege pukupukukaek i matan. I matan ine mi vintuir, a nga pengan se Iesu mi vunan ta nga tobelie ma vasa man mienarouk a nga voto lalapus ven. ");
INSERT INTO tbf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","E Iesu a nga oeng ine simi vevien, “Natung vevien. Ke vodovodon tuktuk a te vatoa no si ma mienarouk. Veis ngan mi molu.” ");
INSERT INTO tbf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sien e Iesu ta ngas nga vor ve vakvakokoit, mi ka kuvu si ken vonuo ian mi muomuo simi vona rengeir sibu Iuda a nga ra nemei nge oeng simi muomuo, “E natu a te maet. Misasien. Kia nge vururutie te mi vavvasengei.” ");
INSERT INTO tbf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eiekesen e Iesu a nga rongomie ine, ma a nga oeng se Iairo, “Kian va e ta motou. Vodovodon tuktuk mo ma e natu vevien ta to.” ");
INSERT INTO tbf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sien e Iesu tate nga beit si ken vonuo mi muomuo, a kap nga sunuir va kavo mei gi ta nga vemusurie rubukien i ruom, eiekesen a nga kerie mo e Petro, e Ioanes, e Iakobo, ma e taman meie e kinan ian mi tetsikevien. ");
INSERT INTO tbf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mi kulou gi nga aor tsak nge tengisie ian mi tetsikevien, ma e Iesu a nga oeng segie malan ne, “Kian va nga ta ta, simi vunan a kap maet, a muang be mo.” ");
INSERT INTO tbf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gi nga ngitsan e Iesu simi vunan gi nga telekiran va a te nga maet. ");
INSERT INTO tbf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eiekesen e Iesu a nga popor i riman nge pevien, “Tsuok tamtuir, natung!” ");
INSERT INTO tbf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Samo, mi morumoruan a nga muerengei, ma ian ngas te, a nga tsuok tamtuir. Ma e Iesu a nga tura gie va gi ta nga tabarie ngan man ka puk nginonginou. ");
INSERT INTO tbf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","E taman meie e kinan, guor nga kudier tsak, eiekesen e Iesu a nga oeng ngeisngeis seguor va guor ta kap nga vateie ka mei ngan ine mi kepineits ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","E Iesu a nga kuk kakuon mi sinangavur kes ma luo ken sar madar tovtov nemei sien ma a nga teir ngeisngeis ma duis segie nia kareir rivie bu tsaka moromoruo kokouk ma nia vatoa bu tamat mienarouk. ");
INSERT INTO tbf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma a nga ture vavasie gie nia ra vavatei ngan mi sinavien e Raban nia vuor ma nia vatoa bu tamat mienarouk. ");
INSERT INTO tbf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A nga oeng segie, “Kian va nga ta poro ka kepineits nian mi vineis. Kian va nga ta poro ka vaong, ka vovvoi, ka tsoik, kavo lakep, ma kavo vevveleis. ");
INSERT INTO tbf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mi sana vonuo gi ta marangata nga en, nga mon ian en oit nga ta sorvekenan ine mi taon. ");
INSERT INTO tbf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sien va mi kulou gi ta kap marangata nga, sorvekenan kegi sar taon nge titike riv puit sibu kamenga nia vakatsepa segie va egie mo te meie e Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Io, bu madar tovtov gi nga sorvekenan nge veis ka i aron bu enamon keskes, ma gi nga vavatei ngan mi Banga Vinavatei nge vatoa bu tamat mienarouk sibu enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sien e Erot, mi kovakova ka leong simi enamon i Galili, ta nga rongomie bu nama surie misa ta nga tsorubeit, a nga basbaslieng beitsak simi vunan mi kulou mene gi nga pevien va e Ioanes mi ka ni sinusuruiv a te nga to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bu mei mene gi nga pevien va e Eliia a te nga beit vasvas, ma bu mei mene buer gi nga pevien va eie mi meinmenien bu propet muomuo ngan te, a nga to muerengei. ");
INSERT INTO tbf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","E Erot a nga pevien, “O nga tuturei nia kitip tsana mi kovan e Ioanes. Eiekesen ese ine mi ka o rongomie man sar vinavatei?” Ma a nga konon nia dengarie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sien ken sar aposol gi tate nga muerengei, gi nga me pengan se Iesu bu kepineits kokouk gi ta nga tsana. Io, e Iesu a nga kerie bu madar tovtov rakot simi taon mi asan i Betsaida ivie gi nga oit nia ra mon egie kesegie en. ");
INSERT INTO tbf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sien mi bineit gi ta nga telekiran ivie e Iesu ta nga rakot en, gi nga vemusurie. Ma e Iesu a nga res suoeie gie nge vakokoit surie mi sinavien e Raban nia vuor ma a nga vatoa bu tamat mienarouk gi ta nga pinat surie mi vavato. ");
INSERT INTO tbf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sien tate nga vor reivreiv, mi sinangavur kes ma luo bu madar tovtov gi nga me oeng se Iesu, “Ture vavasie mi bineit, terengien gi ta mang veis rakot sibu enamon ma sibu korot tsangtsang tau gi ta mon viririsie giet nge vorotan bu vonuo mutumutur ma magi kavo nginonginou, simi vunan ine mi korot a mon peken bu enamon.” ");
INSERT INTO tbf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eiekesen e Iesu a nga oeng segie, “Enga ngas te, nga tabarie gie.” Gi nga kuil nama, “Gei suvuon mo ba tsoik a napaririem ma ba ie meses luo. Sien va gei ta kap veis nge ra voir magi nginonginou ine mi bineit kokouk, gei kap oit nia tabarie gie.” ");
INSERT INTO tbf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gi nga pevien malan ine, simi vunan mi aesaes sibu ka a nga oit bu sinangavur mi napaririem soloba (5,000). Eiekesen a nga oeng si ken sar madar tovtov, “Oeng segie mi bineit va gi ta mogos a oit ba sinangavur mi napaririem simi gargar keskes.” ");
INSERT INTO tbf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bu madar tovtov gi nga tsana malan, ma egie kokouk gi nga mogos. ");
INSERT INTO tbf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","E Iesu a nga poro mi napaririem bu tsoik ma ba ie meses luo ma a nga dedeng kien i kur simi rangit nge vatamase gie. Ma a nga vor ve potpot terie bu tsoik sibu madar tovtov nia tabarie mi bineit. ");
INSERT INTO tbf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Egie kokouk gi nga ngou nge ti, ma bu madar tovtov gi nga tsuokopie bu kapekapien nge votie mi sinangavur kes ma luo bu leke. ");
INSERT INTO tbf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Simi ra mene sien e Iesu ta nga ra no eie kesen, ken sar madar tovtov gi nga me vorotan, ma a nga vosuoreie gie, “Mi kulou gi ko pevien va eou ese?” ");
INSERT INTO tbf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gi nga kuil nama, “Bu mei mene gi pevien va evoi e Ioanes mi ka ni sinusuruiv, a, bu mei mene gi pevien va evoi e Eliia, ma bu mei mene buer gi pevien va evoi mi propet muomuo ngan e to muerengei.” ");
INSERT INTO tbf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","E Iesu a nga vosuoreie gie, “Ma enga vasa? Nga pevien va eou ese?” E Petro a nga kuil nama, “Evoi mi Messia se Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","E Iesu a nga vangenge gie ken sar madar tovtov va gi ta kap nga vateie ngan ka mei mene ine mi kepineits. ");
INSERT INTO tbf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma a nga pevien, “E Natuon mi Ka ta ngas suvu vinekikin palan, ma bu muomuo, bu prist leong ma bu vavvasengei sibu vinuor se Moses gi ta sunuran. Ma gi ta kenvamate ma simi ra a tourngan, ta to muerengei.” ");
INSERT INTO tbf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Samo a nga pevien segie kokouk, “Sien va ka mei ta lalaro vemusurie iou, eie ta ngas vodon rivie ken sar lalaron surie eie kesen ma ta ngas tsuok sorokie man koitskoits sibu ra kokouk nge vemusurie iou. ");
INSERT INTO tbf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Eie ese ta ruit ngan ken tino, ta rivie ken tino. Eiekesen eie ese ta tsupuk rivie ken tino surie iou, ta so suvuon mi tino. ");
INSERT INTO tbf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mi sana man kienelei, sien va ka mei ta suvuon mi kaber kokouk eiekesen eie ta rivie ken tino kesen? ");
INSERT INTO tbf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sien va ka mei a mengemengeir rivie iou ma mi namaniung, e Natuon mi Ka buer ta so mengemengeir rivie, sien va eie ta nemei meie ngan man matvinavaso ma man matvinavaso mi Tam ma magi matvinavaso ken sar angelo e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","O oeng tuktuk senga, kavo mei senga gi ta tuir ine, gi ta kap so maet i muan va gi ta pare e Raban ta so vuor simi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","I murien ne, a nga malan va bu ra mi napaririem potsu tour tate nga rovoriu sien e Iesu tate nga vakokoit vaton ine ken sar nama, a nga kerie e Petro, a, e Ioanes ma e Iakobo nge kien simi pout nia ra no. ");
INSERT INTO tbf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sien e Iesu ta nga no, mi matan a nga tsorubeit kekineits si kegituo baidendeng ma man sar tsetstseik a nga tsorubeit puneits malan mi busobuso naov. ");
INSERT INTO tbf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ma ian ngas te, ba ka luo, e Moses ma e Eliia, guor nga tsorubeit vasvas ngan mi matvinavaso nge vakokoit meie e Iesu. Gituo nga vakokoit surie ken minaet e Iesu, ian tate nga vatavatat va ta nga tsang vaotie i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","E Petro ma ba turan madar tovtov gituo nga mat mumuang nge muang, eiekesen sien gituo ta nga ra pan, gituo nga pare man matvinavaso e Iesu ma ba ka luo guor ta nga tuir meie. ");
INSERT INTO tbf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sien ba ka guor tate nga sorvekenan e Iesu, e Petro a nga oeng sien, “Ka leong, a kalei va giet ta mon en ne. Giet ta tsana kaba papael tour, ke ka mene, a, ken ka mene e Moses, ma ken ka mene e Eliia.” Eie a kap nga telekiran misa a nga pengan. ");
INSERT INTO tbf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sien e Petro ta ngas nga vor ve vakvakokoit, mi balbal a nga tsorubeit nge kuva gituo. Ma gituo nga motou sien gituo ta nga mon i aron mi balbal. ");
INSERT INTO tbf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma mi ien kovuni simi balbal a nga pevien ne, “Ine arie e Natung ese o ta nga vile. Nga rorong sien!” ");
INSERT INTO tbf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sien ine mi ien tate nga vakokoit voto, gituo nga dengarie e Iesu kesen mo te. Ba madar tovtov gituo nga toungan ine mi kepineits sibu arogie ma gituo kap nga pengan si ka mei ian sibu ra misa gituo ta nga pare. ");
INSERT INTO tbf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Simi ra vemusurie, sien gi tate nga muerengei peuk kovuni simi pout, mi bineit leong gi nga samsuoeie. ");
INSERT INTO tbf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Io, mi ka a nga mon i aron mi bineit a nga koup pevien, “Vavvasengei, o lalaron va e ta tovie e natung tamat kes. ");
INSERT INTO tbf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rorong! Mi tsaka moromoruo a ko tsegerie ma a ko koupkoup, ma a ko vedederie nge tomekan i keim ma a ko kat nge guruos mi ngutsuon. Ma a te tsang vatsakatie ma a kap lalaro sorvekenan. ");
INSERT INTO tbf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","O nongie ke sar madar tovtov nia kareir rivie ine mi tsaka moromoruo, eiekesen gi kap oit nia tsang vaotie.” ");
INSERT INTO tbf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E Iesu a nga kuil nama, “Enga mi kuoluon ine bu ra, kap kenga ka vodovodon tuktuk ma mi sinavinga a tsokor. Ese a ba nga pare o ta nga mon meie nga? Ma ese a ba nga pare o ta nga sorokie kenga sar putu? Kerie nemei ngan e natu ine.” ");
INSERT INTO tbf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sien ine mi madar ta nga veis nemei, mi tsaka moromoruo a nga tomeke vuturungie i keim simi kaber nge vadotso. Eiekesen e Iesu a nga patsarie mi tsaka moromoruo nge vatoa ine mi madar. Ma a nga teir muerngan se taman. ");
INSERT INTO tbf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma egie kokouk gi nga kudier tsak simi ngesengesien e Raban. Sien mi kulou kokouk gi ta nga vor ve vodovodon surie bu kepineits kokouk e Iesu ta nga tsana, a nga pevien si ken sar madar tovtov, ");
INSERT INTO tbf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nga rorong kalei simi sana o lalaro pengan senga. E Natuon mi Ka gi ta roev terie i riman mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eiekesen gi kap nga katsep si man vuevue ine ken nama. A te nga mumuningei segie, terengien va gi ta kap mang nga telekiran. Ma gi nga motou nia vosuoreie ngan ine ken vinakokoit. ");
INSERT INTO tbf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mi vinetei a nga beit i kotubuon bu madar tovtov va ese segie a tsiroup i kotubugie. ");
INSERT INTO tbf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","E Iesu a nga telekiran kegi sar vienviendon, io a nga kerie mi natu madar ma a nga voturie i bingan. ");
INSERT INTO tbf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma a nga oeng segie, “Eie ese ta suguo ine mi natu madar simi asoung a suguo iou, ma eie ese ta suguo iou, eie a suguo ian eie ese ta nga tura iou. Eie ese ta lili i kotubunga eie a tsiroup senga.” ");
INSERT INTO tbf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E Ioanes a nga pevien, “Ka leong, gei nga pare mi ka a kareir rivie bu tsaka moromoruo ngan mi asa ma gei nga konon nia vangenge simi vunan a kap va eie mi meinmenigiet.” ");
INSERT INTO tbf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","E Iesu a nga kuil nama, “Kian va nga ta vangenge, simi vunan eie ese ta kap matakorot nge nga, eie senga.” ");
INSERT INTO tbf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sien mi keipkepide ra tate nga vatavatat va e Iesu ta nga kien i kur simi rangit, a nga tsana ken vienviendon va ta nga rakot i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma a nga ture muongan ba ka ni tinuturei va gituo ta nga rakot simi enamon sibu Samaria nia ra rorois ngan bu kepineits surie eie. ");
INSERT INTO tbf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Eiekesen mi kulou ian en, gi kap nga lalaron nia suguo simi vunan a nga tsana ken vienviendon va ta nga rakot i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Sien ba madar tovtov e Iakobo ma e Ioanes guor ta nga rongomie ine, guor nga pevien, “Mi Nguts, e lalaron va gor ta kukuo mi leing kovuni i kur simi rangit va ta voguersa gie?” ");
INSERT INTO tbf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Eiekesen e Iesu a nga vuvuris nge nasara guor nge pevien, “Ngado kap telekiran engado simi sana suada moromoruo. E Natuon mi Ka a kap nga nemei nia voguersan kegi tino mi kulou, eiekesen a nga nemei nia vatoa gie.” ");
INSERT INTO tbf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ma gi nga rakot simi enamon mene. ");
INSERT INTO tbf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sien gi ta nga vor ve veisveis i sar, mi ka a nga oeng se Iesu, “O ta vemusurie no sibu korot kokouk ivie va e ta rakot en.” ");
INSERT INTO tbf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","E Iesu a nga kuil nama sien, “Bu kopuen tso gi suvuon magi sar mat ma bu ma gi suvuon magi sar tou, eiekesen e Natuon mi Ka a kap suvuon ken ka korot nia vuturungie mi kovan.” ");
INSERT INTO tbf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E Iesu a nga oeng simi ka mene, “Vemusurie iou.” Eiekesen a nga kuil nama, “Mi Nguts. E ta sunuir va o ta be ra muna puonongie e tamoung.” ");
INSERT INTO tbf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","E Iesu a nga oeng sien, “Tsupuk rivie bu tamat miensei gi ta puonongie bu turagie miensei, eiekesen evoi, ra vavatei ngan ken mangmagoso Nguts e Raban sibu enamon kokouk.” ");
INSERT INTO tbf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mi ka mene buer a nga pevien, “O ta vemusurie no mi Nguts, eiekesen e ta muna sunuir nge iou va o ta be ra tsekireriem meie kong tietie.” ");
INSERT INTO tbf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","E Iesu a nga kuil nama, “Mi ka ese ta tsatsang ngan ba bulumakau nia tsuopuo mi kaber ma a munu ermuer, eie a kap kalei oit nian mi tsientsang si ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","I murien ine, mi Nguts a nga vile bu sinangavur napaririem potsu luo ma luo bu mei ma a nga ture luoluo nge gie muo sien rakot sibu taon keskes ma bu enamon keskes ivie va ta nga rakot en. ");
INSERT INTO tbf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A nga oeng segie, “Mi nginonginou tate komois a palan, eiekesen mi kulou nia kakarie mi tau a kap palan. Io, nga ta nongie man Nguts mi tau ian tate komois va ta turan mi kulou nia kakarie mi tau. ");
INSERT INTO tbf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Veis! O tura nga malan bu natu sipsip gi ta rakot i kotubuon bu kopuen tso. ");
INSERT INTO tbf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kian va nga ta sorokie ka lapa o, ka vovvoi o, ka poppop ma kian va nga ta so valalaem meie ka mei i sar. ");
INSERT INTO tbf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Sien va nga ta so rubukien si ka vonuo, nga muna pevien, ‘Mi molu ta mon ine simi vonuo.’ ");
INSERT INTO tbf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sien va ka ka simi molu a mon ian, kenga molu ta kor kuva. Sien va kap, kenga molu ta muerengei nemei senga. ");
INSERT INTO tbf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mon ian simi vonuo ma nganie nge unumie mi sana gi ta tabarie nga ngan, simi vunan mi ka ni tsientsang ta ngas suvuon ken voirvoir. Kian va nga ta totop matavanuo. ");
INSERT INTO tbf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Sien va nga ta beit simi taon ma gi suguo nga, nga ta nganie mi sana nginonginou gi ta tabarie nga ngan. ");
INSERT INTO tbf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma nga ta vatoa bu tamat mienarouk gi ta mon ian en, ma nga ta oeng segie, ‘Mi ra va e Raban ta vuor, a te vatavatat.’ ");
INSERT INTO tbf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Eiekesen sien va nga ta beit si ka taon ma gi kap suguo nga, veisngie kegi sar rosar nge pevien, ");
INSERT INTO tbf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Misasien mi puit si kenga taon ian ta tsok sibu kamegei, gei titike veie nge nga ngan. Eiekesen nga ta ngas katsep sien ine. Mi ra va e Raban ta vuor a te vatavatat.’ ");
INSERT INTO tbf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","O oeng senga, simi rangi vinuor, ian mi taon ta so suvuon mi tsienakor leong rio i Sodom.” ");
INSERT INTO tbf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mi tsienakor leong sevoi i Korasin! Ma mi tsienakor leong sevoi i Betsaida! Sien va ine bu kepineits ni vovokudier gi ta nga tsana sengado va gi nga tsana i Turos ma i Sidon, kebeir ngas te va gi nga vodon vuris nge tseik tsetstseik bita ma soute puit i popogie.” ");
INSERT INTO tbf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eiekesen simi rangi vinuor, ngado ta so suvuon mi tsienakor leong rio bu Turos ma bu Sidon. ");
INSERT INTO tbf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma evoi i Kapernaum, vasa, e ta tsuok terie no kese i kur kien simi rangit? A kap, e ta so peuk i keim i Ades. ");
INSERT INTO tbf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Eie ese ta rorong senga, a rorong seou. Eie ese ta mekitsa nga, a mekitsa iou, ma eie ese ta mekitsa iou, a mekitsan eie ese ta nga tura iou.” ");
INSERT INTO tbf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bu sinangavur napaririem potsu luo ma luo bu madar tovtov gi nga muer ngan mi nires ma gi nga pevien, “Mi Nguts, bu tsaka moromoruo buer gi nga rorong segei sien gei ta nga oeng ngeisngeis segie ngan mi asa.” ");
INSERT INTO tbf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","E Iesu a nga kuil nama, “O te pare e Satan a kor malan mi kutsukutsuleip kovuni i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rorong! O te terie senga mi ngeisngeis nia veis i popon bu tsotsoi ma bu novuot ma nia tseiptseiprio bu ngesengesien mi matakorot, ma ta kap ka kepineits ta vabasa nga. ");
INSERT INTO tbf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eiekesen, kian va nga ta res va bu tsaka moromoruo gi rorong senga, eiekesen nga ta res simi vunan e Raban a te vataro bu asanga die i kur simi rangit.” ");
INSERT INTO tbf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ian simi ra, mi Moromoruo Tamat a nga vovosuo e Iesu ngan mi nires ma a nga pevien, “Tama. Evoi man Nguts mi rangit ma mi kaber. O puonge no surie e nga muningan ine bu kepineits sibu ka sievei ma segie ese gi ta nga por vinasengei, eiekesen e nga vasangan sibu natu madar. A tuktuk, Tama, si ke lalaron kese, ine mi kepineits a nga tsorubeit malan.” ");
INSERT INTO tbf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sien ta nga vaton ken nono, a nge pevien simi kulou, “Bu kepineits kokouk e Tamoung a te nga terie seou. Kap ka mei a telekiran va mi Nout eie ese, eiekesen mi Tam kesen mo. Ma kap ka mei a telekiran va mi Tam eie ese, eiekesen mi Nout kesen mo ma egie ese mi Nout ta vile gie nia vasangan segie.” ");
INSERT INTO tbf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Samo e Iesu a nga vuris rakot si ken sar madar tovtov nge vakokoit menen segie, “Mi nires sibu katsomat ese gi ta pare mi sana kepineits nga tate pare. ");
INSERT INTO tbf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","O oeng senga, palan bu propet ma bu kovakova ka leong gi nga lalaron nia pare misa nga tate pare, eiekesen gi kap nga oit nia pare, ma gi nga lalaron nia rongomie misa nga tate rongomie, eiekesen gi kap nga oit nia rongomie.” ");
INSERT INTO tbf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Simi ra mene mi ka sinavei sibu vinuor se Moses a nga visi ruom tsang nama se Iesu ma a nga vereie, “Vavvasengei, misa o ta ngas tsana nia suvuon mi tino rovoriu?” ");
INSERT INTO tbf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A nga oeng sien, “Mi Pakpak Leong, vasa a vakokoit ven? Ma vasa ke teletelekirei surie?” ");
INSERT INTO tbf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ine mi ka a nga kuil nama, “E ta ngas lalaron beitsak ma Raban ngan mi aro kokouk ma mi morumorua kokouk ma mi ngisingisi kokouk ma mi vinavinadodo kokouk. Ma e ta ngas tovie e palapala malan e ta tovie no kese.” ");
INSERT INTO tbf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma e Iesu a nga oeng sien, “Ke nama kuilkuil a duis. Tsana malan ine ma e ta so suvuon mi tino.” ");
INSERT INTO tbf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eiekesen a nga lalaro vara matkalei ngan eie kesen, io, a nga vereie e Iesu, “Ese e polopoloung?” ");
INSERT INTO tbf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","E Iesu a nga kuil nama, “Mi ka a nga veis kovuni i Ierusalem rakot i Ieriko. Ma i sar, a nga samsuoeie bu ka puerpuer. Gi nga tsion rivie man sar tsetstseik nge tsatsakie ma gi nga veis sorvekenan sien tate nga mesei oum. ");
INSERT INTO tbf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma mi prist buer a si nga vemusurie ine mi rosar. Ma sien ta nga me pare ian mi ka, a nga veis evisie nge rov riu. ");
INSERT INTO tbf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Malan buer mo mi tu Levi a nga veis nemei. Ma sien ta nga me beit ian simi korot, a nga me pare ma a nga veis evisie nge rov rio. ");
INSERT INTO tbf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Eiekesen mi kangi Samaria a nga veis buer ian simi rosar. Sien ta nga me beit ian simi korot mi ka ta nga mutur en, a nga pare ma a nga tovie. ");
INSERT INTO tbf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A nga rakot sien ma a nga soe teir oel ma dangi vain sibu kiem nge pipitsie. Samo a nga sor terie i popon man dongki nge por rakot ngan simi vona vasier ivie a nga ra naneie en. ");
INSERT INTO tbf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Simi ra vemusurie a nga poro ba lakep denari luo ma a nga terie simi ka nennei simi vona vasier nge pevien, ‘E ta ngas naneie vakalaie ine mi ka. Sien va o ta muerengei o ta ba me kulie kavo lakep mene e ta tomekan nia naneie ine mi ka.’ ");
INSERT INTO tbf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ese segituo e vodon va eie e palapalan ine mi ka, bu ka puerpuer gi ta nga keda?” ");
INSERT INTO tbf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mi vavvasengei sibu vinuor a nga kuil nama, “Mi mei ese ta nga tovie.” E Iesu a nga oeng sien, “Veis nge ra tsana malan mo.” ");
INSERT INTO tbf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sien e Iesu ma ken sar madar tovtov gi ta nga vor ve veisveis, gi nga beit simi enamon ivie mi vevien mi asan e Mata a nga mon en ma e Mata a nga kuk vurukude si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","E kasien vevien a nga mon, mi asan e Maria. A nga mogos i babaren ba kamen mi Nguts nge rongomie misa ta nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Eiekesen e Mata a nga vodovodon palan surie bu kepineits nia rorois ngan niagie. Ma a nga nemei nge vosuoreie e Iesu, “Mi Nguts, a kalei sevoi sien eou keseung mo o ta voruruit sibu tsientsang ma e kasiung vevien ta kap kulie iou? Oeng sien va ta me kulie iou!” ");
INSERT INTO tbf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mi Nguts a nga kuil nama, “Mata, Mata. E vodovodon palan nge aor putu surie bu kepineits palan, ");
INSERT INTO tbf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","eiekesen mi kepineits kes mo e pinat surie. E Maria a vile misa ta kalei, ma o ta kap oit nia por tsana sien.” ");
INSERT INTO tbf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Simi ra mene e Iesu a nga ra no simi korot. Sien ta nga no voto, mi mei si ken sar madar tovtov a nga oeng sien, “Mi Nguts, vasangan segei mi sinavei nia no, malan e Ioanes ta nga vasangan si ken sar madar tovtov.” ");
INSERT INTO tbf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Io, a nga oeng segie, “Sien va nga ta no, nga ta pevien: “‘Tama, a kalei va gei ta ngas mangaran mi asa, a kalei va ke vinuor ta ngas vuortie gei. ");
INSERT INTO tbf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tabarie gei ngan mi nginonginou ta oit simi ra vere, ");
INSERT INTO tbf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Vodon rivie kegei sar sinavei tsokor, malan egei gei ta vodon rivie bu sinavei tsokor bu mei gi ta tsana segei. Ma kian va e ta tsupuk rivie gei sibu konokonon.’” ");
INSERT INTO tbf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma a nga oeng segie, “Ka mene senga ese va ka palapalan, a nga rakot sien sikati potaram nge pevien, ‘Palapala, teir vunie nge iou kaba tsoik tour, ");
INSERT INTO tbf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","simi vunan e polopoloung a veisngie mi vineis ma a beit vorota iou, ma o kap suvuon ka nginonginou nia tabarie ngan.’ ");
INSERT INTO tbf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Eiekesen ian mi mei i ruom a nga kuil nama, ‘Kia nge memekitsie iou. Mi matavanuo a te bouk, ma buer egei bu natung gei te muang. O kap ba buer oit nia tamtuir nge por terie ka kepineits sevoi.’ ");
INSERT INTO tbf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","O oeng senga, ine e palapalan ta kap oit nia tamtuir nge terie sien kaba tsoik surie keguor baser palapalan, eiekesen surie mo ken viningir, ta tamtuir nge tsang vaotie ken pinat. ");
INSERT INTO tbf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Io, o oeng senga. Nga no, ma nga ta suvuon. Nga neis, ma nga ta vorotan. Nga pinpin, ma mi matavanuo ta katsep vunie nga. ");
INSERT INTO tbf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Egie ese gi ta no, gi ta suv. Ma egie ese gi ta neisneis, gi ta vorotan. Ma egie ese gi ta pinpin, mi matavanuo ta katsep vunie gie. ");
INSERT INTO tbf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ese senga bu tam, sien va ka natuon ta nongie ngan ka ie, ta si terie sien ka tsotsoi? ");
INSERT INTO tbf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, sien va a nongie ngan ka katoru to, ta si terie sien ka novuot? ");
INSERT INTO tbf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Misasien enga bu tsaka mei, enga nga telekiran va nga ta terie bu banga tienebeir sibu natunga. Ma ine, a tuktuk rovoriu va e Tamoung die i kur simi rangit ta teir vunie nge gie mi Moromoruo Tamat segie ese gi ta nongie!” ");
INSERT INTO tbf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E Iesu a nga kareir rivie mi tsaka moromoruo simi ngong. Ma sien mi tsaka moromoruo tate nga sorvekenan ian mi ka ta be nga ngong, a nga vakokoit ma mi bineit gi nga kudier tsak. ");
INSERT INTO tbf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eiekesen bu mei segie gi nga pevien, “A kareir rivie bu tsaka moromoruo ngan mi ngesengesien e Belsebul, mi kovan bu tsaka moromoruo.” ");
INSERT INTO tbf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma bu mei segie gi nga lalaro konon ma gi nga vereie ngan ka totourlekier ni vovokudier kovuni simi rangit. ");
INSERT INTO tbf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","E Iesu a te nga telekiran kegi sar vienviendon ma a nga oeng segie, “Ka mangmagoso nguts ta vekapot nge veveken, ta tsereir. Ma ka tietie ta vekapot nge veveken, ta tsereir. ");
INSERT INTO tbf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sien va e Satan a vekapot nge veveken meie eie kesen, vasa ta oit nia tuir ven ken mangmagoso nguts? O vakokoit ven ne simi vunan nga pevien va o kareir rivie bu tsaka moromoruo ngan mi ngesengesien e Belsebul. ");
INSERT INTO tbf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Io, sien va o kareir rivie bu tsaka moromoruo ngan mi ngesengesien e Belsebul, ngan mi ngesengesien ese, kenga sar madar tovtov gi ko kareir rivie bu tsaka moromoruo? Io, gi ta so vara tuktuk ngan va enga nga kap duis. ");
INSERT INTO tbf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma sien va o ta kareir rivie bu tsaka moromoruo ngan mi pitsipitsiriman e Raban, ine a vasangan va mi ra va e Raban ta vuor a te beit senga. ");
INSERT INTO tbf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Sien va ka ka ngeisngeis, a pernge vakalaie ken vonuo kesen meie ngan ken sar kepineits nia veveken, ma ken sar kepineits gi ta mon kalei. ");
INSERT INTO tbf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Eiekesen sien va ka mei mene a ngeisngeis rio, ma a me veveken meie nge tseiptseiprio, ta por tsana sien bu kepineits nia veveken ta ko per popon ma ta pot vepats ngan bu kepineits ian tate por tsana simi vinevineken. ");
INSERT INTO tbf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Eie ese ta kap mon seou, eie a matakorot meie iou, ma eie ese ta kap kulie iou nia teie kakakuon mi kulou, eie a kareir vepitsitsei nge gie. ");
INSERT INTO tbf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sien va ka tsaka moromoruo ta rovotsour vekenan ka mei, ta veisngie bu korot kap ka da en nia nesie ka korot va ta maes en. Eiekesen va ta kap vorotan ka korot, ta pevien, ‘O ta muer surie mi vonuo o ta nga sorvekenan.’ ");
INSERT INTO tbf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sien va ta muerengei, ta vorotan mi vonuo va gi tate videir vakalaie, ma bu kepineits gi mon duis. ");
INSERT INTO tbf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Samo ta muerengei nge ra kerie mi napaririem potsu luo bu tsaka moromoruo mene gi ta tsokor rio eie, ma gi ta me rubukien nge mon ian en. Ma ken tino ian mi ka ta tsak vekenan vourvour.” ");
INSERT INTO tbf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sien e Iesu ta ngas nga vor ve vokovokokotie ine bu kepineits, mi vevien i aron mi bineit a nga koup pevien sien, “Mi nires ta mon meie ese ta nga kava no nge vosusuo no.” ");
INSERT INTO tbf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma e Iesu a nga pevien, “Eiekesen mi nires tuktuk ta mon segie ese gi ta rongomie mi namanien e Raban nge vemusurie.” ");
INSERT INTO tbf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sien mi bineit tate nga vor ve beitbeit palan, e Iesu a nga pevien, “Mi kuoluon ine bu ra gi tsokor. Gi virei ngan ka totourlekier ni vovokudier, eiekesen kap ka totourlekier gi ta pare eiekesen man totourlekier e Iona. ");
INSERT INTO tbf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","E Iona a nga tsorubeit mi totourlekier sibu Nineve. Malan mo, e Natuon mi Ka eie ta so tsorubeit man totourlekier mi kuoluon ine bu ra. ");
INSERT INTO tbf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Simi rangi vinuor, mi kovakova vevien leong simi enamon i Siba ta so tamtuir veie mi kuoluon ine bu ra ma ta so votorosie gie, simi vunan a nga kovuni i tangatson mi kaber nia me rongomie ken sar banga vienviendon e Solomon. Ma ine, mi mei ese ta tsiroup rio e Solomon a te beit. ");
INSERT INTO tbf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mi kuoluon i Nineve gi ta so tamtuir simi rangi vinuor veie mi kuoluon ine bu ra nge votorosie gie, simi vunan gi nga vurise aor sibu vinavatei se Iona, ma ine mi mei ta leong se Iona a te beit ine. ");
INSERT INTO tbf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kap ka mei a ko vakartie ka bember nge terie si ka korot ivie va ta mumuningei, o, i pakien ka utut. Eiekesen eie ta vogosongie i popon man mogomogos, terengien egie ese gi ta rubukien gi ta mang dengarie mi berber. ");
INSERT INTO tbf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mi katsomat eie man bember mi kurikuri. Sien va ba katsomata ta kalei, mi kurikuri kokouk buer ta vous ngan mi berber. Eiekesen sien va ba katsomata ta tsak, mi kurikuri buer ta vous ngan mi ngingi. ");
INSERT INTO tbf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Io, nennei kalei, va ian mi berber ta mon i aro, ta masi tsorubeit ngingi. ");
INSERT INTO tbf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sien va mi kurikuri ta vous nge berber ma kap ka korot sien a ngingi, eie ta taparang rovoriu, malan mi rararangien mi bember ta rarangie no.” ");
INSERT INTO tbf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sien e Iesu tate nga vakokoit voto, mi Parisaio a te nga nongie va ta nga ra ngou meie. Io, a nga rubukien nge mogos rorois nia ngou. ");
INSERT INTO tbf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Eiekesen ine mi Parisaio a nga kudier sien ta nga pare e Iesu ta kap nga vavaon i muan va ta nga ngou. ");
INSERT INTO tbf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Io, mi Nguts a nga oeng sien, “Rorong. Enga bu Parisaio, nga ko govorie mi kurikurien kenga sar koi unun ma kenga sar koi ngongou, eiekesen bu aronga a vous ngan mi sinavei ngangaguo ma mi sinavei malangiets. ");
INSERT INTO tbf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Enga bu be! Vasa, e Raban a nga tsana mo bu pirpir ka i marar, ma a kap nga tsana te buer ka i ruom? ");
INSERT INTO tbf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eiekesen terie misa ta mon i aron ke koi sibu sinaortsak, ma bu kepineits kokouk ta melemelen vunie nga. ");
INSERT INTO tbf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mi tsienakor leong ta monongie nga bu Parisaio, simi vunan nga ko terie se Raban mi korot kes simi karton mi sinangavur kes si kenga sar tsientsuor nia vesena mi nginonginou gi ta vuotongie ngan mi mint, a, mi balases ma mi reie. Eiekesen nga ko vodon sasavoir ngan mi sinavei duis ma mi lalaron rakot se Raban. Ine arie ba kepineits kokouk nga ta ngas tsang vaotie ma kian va nga ta vodon sasavoir ngan ka mei kes seguor. ");
INSERT INTO tbf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mi tsienakor leong ta monongie nga bu Parisaio, simi vunan nga lalaron beitsak kegi sar mogomogos bu muomuo si kenga sar vona rengeir ma nga lalaron va gi ta mangara nga sibu korot nia verikuil nge lakep. ");
INSERT INTO tbf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mi tsienakor leong ta monongie nga, simi vunan nga malan bu monmon kap kilakilal ivie mi kulou gi ta veis ka i popon ma gi kap telekiran.” ");
INSERT INTO tbf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mi meinmenien bu vavvasengei sibu vinuor a nga pevien sien ine, “Vavvasengei, sien e ta oeng ven ian, e te oeng balapoik nge gei buer.” ");
INSERT INTO tbf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E Iesu a nga kuil nama, “Mi tsienakor leong buer ta monongie nga bu vavvasengei sibu vinuor, simi vunan nga terie mi sinor i popon mi kulou ian ta mavev nia sorokie, eiekesen enga ngas te nga kap terie ka pitsipitsiriem nia kuil ian simi sinor. ");
INSERT INTO tbf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Mi tsienakor ta monongie nga, simi vunan nga tsana bu totourkilal si magi sar monmon bu propet ian bu tubunga gi ta nga kenvamate gie. ");
INSERT INTO tbf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Io, nga te vara tuktuk nge aor kes ngan misa bu tubunga gi ta nga tsana. Gi nga kenvamate bu propet, eiekesen nga tsana magi sar monmon. ");
INSERT INTO tbf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Surie ine mi vunan mo e Raban si ken banga vienviendon a pevien, ‘O ta ture terie segie bu propet ma bu aposol. Gi ta kenvamate gie kavo mei nge vikikinie gie.’ ");
INSERT INTO tbf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Io, mi kuoluon ine bu ra gi ta suvu vinatoreis surie mi daran bu propet vakaek si man tsuoktsuok vakaek mi mangmagoso enaenamon, ");
INSERT INTO tbf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","vakaek simi daran e Abel beit simi daran e Sakaria ese gi ta nga kenvamate i kotubuon mi korot nia tu tienebeir ma mi korot tamat. Io, O oeng senga, mi kuoluon ine bu ra gi ta suvu vinatoreis surie gie kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mi tsienakor leong ta monongie nga bu vavvasengei sibu vinuor, simi vunan nga te por tsana mi tsitstsi nian mi teletelekirei simi namanien e Raban, eiekesen enga kesenga nga kap ko rubukien. Ma nga ko tuir kitipan mi kulou gi ta nga lalaron nia rubukien.” ");
INSERT INTO tbf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sien e Iesu tate nga rovotsour, bu Parisaio ma bu vavvasengei sibu vinuor gi nga vakaek nge kengeir veie nge virevirei sara surie bu kepineits palan, ");
INSERT INTO tbf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","simi vunan gi nga lalaro ruom tsang nama sien. ");
INSERT INTO tbf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sien ine mi kepineits ta nga tsorubeit, mi bineit leong beitsak gi nga beit kouk, ma gi nga vekeir nge gie. Ma e Iesu a nga muna vakokoit si ken sar madar tovtov, “Nga ta ngas naneie nga simi iis sibu Parisaio, arie ian mi sinavei nia malamala ka duis. ");
INSERT INTO tbf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bu sana kepineits gi ta kuov muningan, gi ta mon vasvas, ma bu sana kepineits gi ta mon kokoiv, gi ta mon simi kientsep ma mi kulou gi tate telekiran. ");
INSERT INTO tbf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Io, bu sana kepineits nga ta vokokotie simi ngingi, gi ta rongomie simi taparang, ma mi sana kepineits nga ta vemisir ngan senga kesenga i aron mi vonuo, gi ta vavatei katsep ngan i kur i pungan mi vonuo. ");
INSERT INTO tbf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“O oeng senga bu polopoloung. Kian va nga ta motovagie ian gi ta ko kenvamate mi pirpir mo ma i muir sien, gi kap oit nia tsana ka kepineits mene te buer. ");
INSERT INTO tbf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Eiekesen o ta oeng senga ese va nga ta motovan. Nga ta ngas motovan e Raban ese ta oit nia kenvamate nga nge suvu duis nia tomeke nga simi leing leong ian ta kap ko mesei. Io, o oeng senga, arie eie mo nga ta motovan. ");
INSERT INTO tbf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Vasa, nga kap ko verikuil ngan mi napaririem bu kamkambaliel ngan ba natu lakep luo? Eiekesen e Raban a kap ko vodon sasavoir ngan ka mei segie. ");
INSERT INTO tbf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A tuktuk, bu vurvur i kovanga e Raban a te ase gie. Kian va nga ta motou, enga nga kalei rio gie bu kamkambaliel palan. ");
INSERT INTO tbf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“O oeng senga, eie ese ta vakokoit vavakatsep i matan mi kulou va eie seou, e Natuon mi Ka buer ta so vakokoit vavakatsep i matan ken sar angelo e Raban va eie seie. ");
INSERT INTO tbf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Eiekesen eie ese ta vamoie iou i matan mi kulou, e Natuon mi Ka buer ta so vamoie eie i matan ken sar angelo e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Eie ese ta tomeke man nama e Natuon mi Ka, e Raban ta vodon rivie, eiekesen eie ese ta oeng balapoik ngan mi Moromoruo Tamat, e Raban ta kap oit nia vodon rivie ine. ");
INSERT INTO tbf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Sien va gi ta voturie nga simi vinuor i aron bu vona rengeir sibu Iuda, o, i matan bu gavana o, bu muomuo ni vuor, kian va nga ta vodovodon palan surie mi sana nama nga ta so pengan nia tuir karie nga, ");
INSERT INTO tbf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","simi vunan mi Moromoruo Tamat ta veseveie nga ian simi keipkepide ra ngan misa va nga ta ngas pengan.” ");
INSERT INTO tbf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mi ka i kotubuon mi bineit a nga oeng se Iesu, “Vavvasengei, oeng se kasiung va ta potakie i kotubugor bu sinsuv se tamagor.” ");
INSERT INTO tbf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","E Iesu a nga kuil nama, “Polopoloung, kap ka mei a nga terie seou mi duis nia vuortie o, nia potakie mi sinsuv i kotubungado.” ");
INSERT INTO tbf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma a nga oeng segie, “Nga nenei kalei! Kian va nga ta lalaron beitsak nia suvu kepineits palan, simi vunan kenga tino a kap vunan simi suvu sinsuv palan.” ");
INSERT INTO tbf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Io, e Iesu a nga pengan segie ine mi nama puppuo, “Ken tau mi ka suvuram a nga konom beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A nga vodonomie eie kesen, ‘Misa o tate tsana? Kap kong ka vonuo nia teir toungan kong sar nginonginou.’ ");
INSERT INTO tbf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ma a nga pevien, ‘Ine arie vasa o ta tsang venengan. O ta bemengie kong sar vonuo totou nge nginonginou, ma o ta tsana kavo mene leong. Ma i aron ine bu vonuo leong, o ta teir toungan bu nginonginou ma kong sar sinsuv kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma o ta vakokoit seou keseung, “E suvuon ke sar kepineits palan ian e oit nia mon kalei ngan sibu avareit palan. E tate mogos kalei nge ngou, un, nge res.” ’ ");
INSERT INTO tbf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Eiekesen e Raban a oeng sien, ‘Evoi mi be! Ine sikati, ke tino ta voto. Ma ese ta so suvuon ine bu kepineits e ta nga teir toungan?’ ");
INSERT INTO tbf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ine arie mi sana ta tsorubeit segie bu mei gi ta teir toungan kegi sar kepineits niagie kesegie, eiekesen gi mala sinaortsak i matan e Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma a nga pevien si ken sar madar tovtov, “Io, o oeng senga. Kian va nga ta vodovodon palan surie kenga tino, va misa nga ta nganie, o, surie mi kurikuringa, va misa nga ta poul ngan. ");
INSERT INTO tbf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mi tino a putu rio mi nginonginou ma mi pirpir a putu rio mi poul. ");
INSERT INTO tbf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nga pare bu bour, gi kap ko tsuor nge por nginonginou i tau ma buer gi kap suvuon ka vonuo totou nge nginonginou, eiekesen e Raban a ko tabarie gie. Ma kenga tino a putu rio bu ma! ");
INSERT INTO tbf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ese mei senga a oit nia vakuora ken tino ngan mi sinavei nia vodovodon palan? ");
INSERT INTO tbf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sien va nga ta kap oit nia tsana ka kepineits lili malan ine, surie misa nga ta vodovodon palan surie bu kepineits ka ie? ");
INSERT INTO tbf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nga vodon surie bu gaelgael vasa gi to ven. Gi kap ko tsatsang o, tsang poul niagie kesegie, eiekesen o oeng senga, man sar matvinavaso e Solomon buer a kap nga matmatot malan ka mene ine sibu gaelgael. ");
INSERT INTO tbf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","E Raban ngas te a ko vosonie gie bu uotuot ian gi ta to nevere ma sivovo gi ta vo tomekan simi leing. Sien va a malan ine, vasa, e Raban a kap oit nia vosonie nga? Madar! kenga vodovodon tuktuk a lili te! ");
INSERT INTO tbf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma kian va nga ta nesie nge vodovodon palan surie mi sana va nga ta nganie nge unumie. ");
INSERT INTO tbf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mi kuoluon ine mi kaber gi ko nesie ine bu kepineits, eiekesen e Tamanga a telekiran va nga pinat surie gie. ");
INSERT INTO tbf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eiekesen nga ta ngas neis vorotan mi saran e Raban va ta vuortie kenga tino, ma ine bu kepineits, e Raban ta teir vunie nge nga. ");
INSERT INTO tbf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Enga, mi gargar sipsip lili, kian va nga ta motou, simi vunan e Tamanga a res nia terie senga mi vavatamaes kovuni si ken mangmagoso Nguts. ");
INSERT INTO tbf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nga verikuil ngan kenga sar kepineits nge lakep nge terie sibu sinaortsak. Nga tsana kenga kavo vovvoi kesenga ian ta kap oit nia metseir. Ine mi vovvoi arie eie mi mos die i kur simi rangit ian ta kap oit nia voto ma bu ka puerpuer gi ta kap nemei vatvatta ma bu ngitsilik gi ta kap tsang vatsakatie. ");
INSERT INTO tbf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ian ke sinsuv ta mon en, mi aro ma ke vienviendon ta mon en buer. ");
INSERT INTO tbf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nga verevere kalei ma kenga sar bember ta ngas ber rorois, ");
INSERT INTO tbf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","malan bu petspets gi ta rosie magi ka leong va ta muerengei kuvu simi nginou ni verei, terengien va puk lalapus mo, gi ta mang oit nia tsitsi varan sien va ta ra nemei nge me pinpin. ");
INSERT INTO tbf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mi nires leong segie ian bu petspets sien va magi ka leong ta beit vorota gie va gi ta rorois. O oeng tuktuk senga, ine mi ka leong ta verevere kalei eie kesen nian mi tsientsang, ma ta kuk vogosongie gie i bingan mi tsur ngongou nge tabarie gie. ");
INSERT INTO tbf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mi nires leong segie ian bu petspets, sien va magi ka leong ta beit vorota gie va gi rorois, misasien eie ta ra nemei sikati potaram o, sivovo tarara. ");
INSERT INTO tbf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Eiekesen nga ta ngas telekiran ine. Sien va e taman mi vonuo ta telekiran va simi sana keipkepide ra mi ka puerpuer va ta me puer sien, ta kap oit nia sunuir va ian mi ka puerpuer ta bem rubukien si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Enga buer nga ta ngas rorois, simi vunan e Natuon mi Ka ta ra nemei simi keipkepide ra nga vodon va ta kap nemei sien.” ");
INSERT INTO tbf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","E Petro a nga vosuoreie, “Mi Nguts, e pengan ine mi nama puppuo segei mo o, sibu mei kokouk?” ");
INSERT INTO tbf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mi Nguts a nga kuil nama, “Ese eie mi ka nennei a sievei ma a ko tuktuk si ken tsientsang? Arie eie man ka leong ta terie sien mi duis nia naneie ken sar petspets nge tabarie gie duis sibu kato ra nia ngou. ");
INSERT INTO tbf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mi nires leong ian simi petspets sien va man ka leong ta me beit vorotan va a ngas tuir si ken baitutuir simi tsientsang. ");
INSERT INTO tbf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","O oeng tuktuk senga. Ine mi ka leong ta terie ine ken petspets nia naneie ken sar sinsuv kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Eiekesen, sien va ine mi petspets ta pevien seie kesen, ‘Ta potaram te mong ka leong ta ba muerengei,’ ma ta vakaek nge tsatsakie gie bu petspets ka ma vevien, ma ta mon ngan mo mi ngou ma mi un nge be, ");
INSERT INTO tbf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","io, man ka leong ian mi petspets ta ra nemei si ka ra va ta vodon ta kap beit sien ma si ka keipkepide ra eie ta kap telekiran. Ma ta me tsetseik vatsakatie ine mi petspets nge teir meie nge gie bu petspets rong tsak. ");
INSERT INTO tbf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ma sien va ian mi petspets ta telekiran ken lalaron man ka leong, eiekesen eie a kap rorois nge tsatsang vemusurie ken lalaron man ka leong, man ka leong ta tsetseik vatsakatie. ");
INSERT INTO tbf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eiekesen mi mei ese ta tsana bu kepineits ian ta otien mi vinatoreis, eiekesen a kap nga telekiran, man ka leong ta tsetseik vakalaie mo. Eie ese ta tserie bu kepineits ta palan, eie ta kuil muerngan ta palan. Ma eie ese ta tserie bu kepineits palan nia naneie, eie ta ngas kuil muerngan ta palan beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“O nemei nia tunie mi kaber, ma o vodon ta kalei sien va a te nga vakaek nge ngang. ");
INSERT INTO tbf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","O suvuon mi sinusuruiv mene ngas. Ine mi kepineits a tsang vatsakatie ngas mi aroung tuir oit va ta tsorubeit tuktuk. ");
INSERT INTO tbf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nga si vodon va o nga nemei nia terie mi molu ine simi kaber? A kap, kap va mi molu, eiekesen mi vinekapot. ");
INSERT INTO tbf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tsuok vakaek ine, mi napaririem bu baser tamagie gi ta vekapot, a tour gituo ta matakorot ngan a luo ma a luo guor ta matakorot ngan a tour. ");
INSERT INTO tbf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mi tam ma e natuon tamat guor ta vematakorot nge guor, mi kien ma e natuon vevien guor ta vematakorot nge guor, ma ba baser anan guor ta ve matakorot nge guor.” ");
INSERT INTO tbf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","E Iesu a nga pevien simi bineit, “Sien nga ta pare mi rangit ta voturie simi korot mi matanias ta ros, puk lalapus nga ta pevien, ‘tate uos,’ ma ta ngas uos. ");
INSERT INTO tbf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma sien va mi moru tunumeit ta beit, nga ta pevien va mi enamon ta rarap, ma ta ngas malan te. ");
INSERT INTO tbf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Enga bu malamala ka duis! Nga telekire vakalaie mi sana ta beit sien nga ta pare bu kepineits ta tsorubeit simi kaber ma simi rangit. Ma surie misa nga ta kap telekire vakalaie ine bu kepineits gi ta vor ve beitbeit duis ine sibu ra? ");
INSERT INTO tbf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Surie misa enga kesenga nga ta kap deng kielala mi sana ta duis? ");
INSERT INTO tbf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sien va e ta veis rakot simi vinuor meie ian mi ka ta terie no simi vinuor, konon nia vuduis nama meie ngas i sar. Eie ta masi so terie no simi ka ni vuor nama, a, mi ka ni vuor nama ta masi terie no simi girigirir, ma mi girigirir ta masi terie no simi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","O oeng senga, e ta kap oit nia rovotsour simi vona vinatoreis tuir oit e ta kuil vaton bu natu lakep kokouk.” ");
INSERT INTO tbf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mi kulou mene gi ta nga mon ian simi ra, gi nga pengan se Iesu mi kulu Galili ese e Pilato ta nga kenvamate gie sien gi ta nga tu terie kegi sar tienebeir ni varam. ");
INSERT INTO tbf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E Iesu a nga virei, “Vasa, nga vodon va ine mi vinekikin bu kangi Galili gi ta nga suvuon, a nga vasangan va egie gi tsokor rio bu Galili mene? ");
INSERT INTO tbf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","O oeng senga. A kap! Sien va nga ta kap vodon vuris sorvekenan kenga sar sinavei tsokor, enga kokouk buer nga ta maet malagie. ");
INSERT INTO tbf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma vasa nga vodon venengan ine mi sinangavur kes ma mi napaririem potsu tour bu mei i Siloam ese gi ta nga maet sien mi vonuo kuar ta nga kor i popogie? Vasa, nga vodon ine a vasangan va egie gi tsokor rio mi kulou mene gi ta mon i Ierusalem? ");
INSERT INTO tbf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","O oeng senga. A kap! Sien va nga ta kap vodon vuris sorvekenan kenga sar sinavei tsokor, enga kokouk buer nga ta maet mala gie.” ");
INSERT INTO tbf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Samo e Iesu a nga vokokotie segie ine mi nama puppuo, “Mi ka a nga tsuorkie mi kapiek i aron ken tau. Ma a nga ko nemei nge neis vuovuo sien, eiekesen a kap nga ko vorotan ka vuovuo kes. ");
INSERT INTO tbf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Io, a nga oeng si ken ka nennei tau, ‘Pare, siba avareit tour, o nga munu nemei nge me neis vuovuo sien ine mi kapiek ma o kap ngas vorotan ka vuovuo kes sien. Tar tomekan! Surie misa ta vaton mi monokien mi kaber?’ ");
INSERT INTO tbf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Eiekesen ine mi ka a nga kuil nama, ‘Ka leong, be buer tsupuk rivie si ka avareit kes. O ta be buer tsoup viririsie mi vunan ine mi kapiek nge vomuta. ");
INSERT INTO tbf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Io, sien va mi ei ta vua simi avareit ian i kur, eie a kalei! Sien va ta kap, io, e ta oeng ma o ta tar tomekan.’” ");
INSERT INTO tbf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Simi Rangi Minaes mene, e Iesu a nga vavasengei i aron mi vona rengeir sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mi vevien a nga mon ian, ese mi tsaka moromoruo a nga vaguo mi tsir ram i vunaturuon sibu avareit mi sinangavur kes ma mi napaririem potsu tour. Mi tsir ram a nga guo ma a kap nga oit nia vodusie mi vunaturuon rovoriu. ");
INSERT INTO tbf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sien e Iesu ta nga pare, a nga kuk nemei ngan sien nge pevien. “Vevien, e te ketseketseng si ma mienarouk.” ");
INSERT INTO tbf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Samo a nga teir riem i popon, ma ian ngas te, a nga vodusie mi vunaturuon ma a nga vakaek nge puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mi muomuo simi vona rengeir a nga petseir simi vunan e Iesu a nga vatoa ine mi vevien simi Rangi Minaes, ma a nga vor ve vakvakokoit simi bineit, “Giet suvuon bu ra mi napaririem potsu kes nia tsatsang. Io, nemei i aron ine bu ra nge me suvuon mi vavato, eiekesen kap va simi Rangi Minaes.” ");
INSERT INTO tbf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mi Nguts a nga kuil nama sien nge pevien, “Enga bu malamala ka duis! Enga keskes nga ko tsitsi vorotsoruo kenga sar bulumakau o, kenga sar dongki si magi oiroir nge kerie nia ra vuvunumie simi Rangi Minaes, va gerek? ");
INSERT INTO tbf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma ine e tubuon vevien e Abaraam ese e Satan ta nga visie bu avareit mi sinangavur kes ma mi napaririem potsu tour, vasa, a kap oit va ta ketseketseng ine si man baivinis simi Rangi Minaes?” ");
INSERT INTO tbf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sien ta nga oeng ven ne, a nga vamangarie man sar matakorot, eiekesen mi lobaram kokouk gi nga resmatan bu banga kepineits mata tietienengei ta nga tsana. ");
INSERT INTO tbf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Io, e Iesu a nga virei, “Mi sinavien e Raban nia vuor, a malan misa? Misa o ta vepuan ngan? ");
INSERT INTO tbf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eie a malan mi pi mastat mi ka ta nga poro nge tsuorkie si ken tau. Ine mi ei tsuotstsuor a nga to leong ma bu ma gi nga me tou sibu rakarakan.” ");
INSERT INTO tbf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma a te buer nga virei, “Misa o ta vepuan ngan mi sinavien e Raban nia vuor? ");
INSERT INTO tbf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A malan mi iis mi vevien ta nga poro nge leik meie ngan ba puol plaua tour oit ine mi plaua kokouk a nga popoek.” ");
INSERT INTO tbf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sien e Iesu ta nga vor ve veisveis rakot i Ierusalem, a nga veisngie bu taon ma bu enamon keskes nge vavasengei. ");
INSERT INTO tbf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Io, mi mei a nga vosuoreie, “Mi Nguts, vasa, e Raban ta vatoa kaba mei mene mo?” E Iesu a nga kuil nama segie, ");
INSERT INTO tbf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nga ta vengeis nia rubukien ka ian simi matavanuo matgurutsits, simi vunan, o oeng senga, palan mi kulou gi ta konon nia rubukien eiekesen gi ta kap oit. ");
INSERT INTO tbf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sien e taman mi vonuo ta bokutie mi matavanuo, nga ta tuir i marar nge pinpin ma nga ta pevien, ‘Mi Nguts, tsitsi vadara gei!’ “Ma eie ta kuil nama, ‘O kap telekiran ivie nga kuvu en!’ ");
INSERT INTO tbf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Samo nga ta kuil nama sien, ‘Gei nga ngou ma un meie no, ma e nga vavasengei si kegei sar taon.’ ");
INSERT INTO tbf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Eiekesen eie ta buer pevien, ‘O kap telekiran ivie nga kuvu en. Nga tsupek sorvekena iou. Enga mi kulou tsokor!’ ");
INSERT INTO tbf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ian en, nga ta so ta nge vengvengio bu rivonga sien va nga ta pare e Abaraam, a, e Isak, a, e Iakop ma bu propet i aron ken mangmagoso Nguts e Raban, ma enga gi ta tomeke vorotsoruo nga. ");
INSERT INTO tbf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mi kulou gi ta nemei kovuni simi matanias ta rar tsour en ma simi matanias ta ros en, ma i matan mi enamon ma i murien mi enamon, ma gi ta so mogos i bingan mi tsur ngongou i aron ken mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A tuktuk, egie ese gi ta vevemuir te gi ta so muomuo, ma egie ese gi ta muomuo gi ta so vevemuir te.” ");
INSERT INTO tbf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ian ngas te, bu Parisaio mene gi nga nemei se Iesu nge oeng sien, “E ta ngas tsupek en ne nge rakot si ka korot mene, simi vunan e Erot a lalaron va ta kenvamate no.” ");
INSERT INTO tbf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma e Iesu a nga kuil nama segie, “Rakot nge oeng ian simi kopuen tso ven ne, ‘Pare! Nevere ma sivo o ta kareir rivie bu tsaka moromoruo ma o ta vatoa bu tamat mienarouk ma simi ra ta tour ngan o ta vaton kong tsientsang. ");
INSERT INTO tbf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Eiekesen, nevere, sivo ma simi ra ta vemusurie, o ta ngas veisngie kong sar vineis, simi vunan a kap duis va ka propet ta maet si ka korot mene eiekesen i Ierusalem!’ ");
INSERT INTO tbf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ierusalem, Ierusalem! E ko kenvamate bu propet nge tomerie gie nge vunavout egie ese e Raban ta nga ture terie sevoi. Palan bu ra, o nga lalaro kir kakuon ke kulou, malan mi kina to ta govitan bu natuon i pakien ba poruoporuon, eiekesen e kap nga sunuir. ");
INSERT INTO tbf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pare! Ke vonuo tate ringringidin. Ma o oeng sevoi, e ta kap buer pare iou tuir oit va e ta pevien, ‘Mi vavatamaes ta mon seie ese ta nemei ngan mi asan mi Nguts.’” ");
INSERT INTO tbf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Simi Rangi Minaes mene, e Iesu a nga rakot nge ngou si ken vonuo mi muomuo mene sibu Parisaio, ma mi kulou gi nga mounnge vititirie. ");
INSERT INTO tbf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Io, mi ka ese ba kamen ma ba riman ta nga ti, a nga mon i muan. ");
INSERT INTO tbf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","E Iesu a nga vereie bu Parisaio ma bu vavvasengei sibu vinuor se Moses, “Kegiet vinuor a sunurie va giet ta vatoa ka mei simi Rangi Minaes, o, kap?” ");
INSERT INTO tbf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eiekesen gi kap nga vokokotie ka nama. Io, e Iesu a nga soburo ine mi ka nge vatoa si man mienarouk ma a nga ture vavasie. ");
INSERT INTO tbf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Samo e Iesu a nga vosuoreie gie, “Sien va ka mei senga va e natuon o, ken ka bulumakau a kor loloim si ka matada simi Rangi Minaes, vasa, eie ta ra teie tsana ian ngas te, o, kap?” ");
INSERT INTO tbf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eiekesen gi kap nga oit nia kulie ine ken vinirei. ");
INSERT INTO tbf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sien ta nga pare bu vasier gi ta nga vile bu mogomogos ian ta otien mi kulou asna, e Iesu a nga vokokotie segie ine mi nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sien va ka mei ta nongie no va e ta ra ngou si ka nginou ni verei, kian va e ta so mogos si ka mogomogos simi kulou asna, simi vunan e taman mi nginou ta masi nongie buer ka ka as leong rio no va ta beit. ");
INSERT INTO tbf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sien va ta malan ian, e taman mi nginou ese ta nongie ngado kokouk, ta me oeng sevoi va e ta terie ke mogomogos ian simi ka as leong rio no. Ma e ta mengemengeir nge ra mogos si ka mogomogos ian ta otien mi kulou sasavoir. ");
INSERT INTO tbf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Eiekesen, sien va gi ta nongie no, be ra mogos si ka mogomogos ian ta otien mi kulou sasavoir, terengien sien va e taman mi nginou ta nemei, ta mang me oeng sevoi, ‘Palapala, ra mogos nikot simi mogomogos asna.’ Ine ta terie sevoi mi as leong i kotubuon bu vasier kokouk ian gi ta beit. ");
INSERT INTO tbf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Eie ese ta veleveleongtie eie kesen, gi ta por terie i keim mi asan ma eie ese ta vilivilikitie eie kesen, gi ta tsuok terie i kur mi asan.” ");
INSERT INTO tbf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Samo e Iesu a nga pevien seie ese ta nga nongie va ta nga me ngou meie, “Sien va e ta tsana ka nginou sisiat o, sikati, kian va e ta kerie bu palapala, bu kasi o, bu patsa o, ka palapala suvuram. Sien va e tsang malan ngan ine, gi ta masi nongie no buer si ka nginou nge kulie sevoi. ");
INSERT INTO tbf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sien va e ta tsana ka nginou, kerie bu sinaortsak, bu peong, bu muru ma bu kael. ");
INSERT INTO tbf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ma e Raban ta so vatamase no, simi vunan gi ta kap oit nia kulie sevoi. Eiekesen e Raban ta ba so kulie sevoi sien va bu ka duis gi ta so to muerengei simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sien mi mei segie bu vasier ta nga rongomie ine mi nama, a nga oeng se Iesu, “E Raban ta vatamase mi ka ese ta ngou simi nginou i aron ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","E Iesu a nga oeng sien, “Mi ka a nga potsie mi nginou leong ma a nga nongie bu vasier palan va gi ta nga nemei. ");
INSERT INTO tbf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma simi ra nian te mi nginou, a nga turan ken petspets nia ra oeng segie ese tate nga muna nongie gie nia nemei simi nginou nge pevien, ‘Nga nemei. Mi nginou a te rorois.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Eiekesen egie kokouk gi nga vakaek nge vokokotie bu namani tuir bibirit. Mi mei vourvour a nga pevien, ‘O ba vorie mo mi poko pier, ma o ta ngas rakot nge ra pare. A kalei va e ta vodon tsupuk rivie iou.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“A, mi mei ka ie a nga pevien, ‘O ba vorie mo bu bulumakau a otien bu aigor napaririem, ma o ta ngas ra konon nia tsatsang nge gie. A kalei va e ta vodon tsupuk rivie iou.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ma mi mei buer ka ie a nga pevien, ‘Ine mo o ba rei. O kap oit nia nemei.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Io, ken petspets a nga muer ma a nga me pengan si man ka leong. Samo e taman mi vonuo a nga petseir ma a nga oeng sien, ‘Rakot sibu rosar ma sibu tangatso rosar simi taon ma kir nemei ngan bu sinaortsak, bu peong, bu kael ma bu muru.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Io, mi petspets a nga pevien, ‘Ka leong, misa e tate nga tura iou nia tsana, o te tsang vaotie, eiekesen a kap ngas vous mi vonuo.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Samo mi ka leong a nga oeng si ken petspets, ‘Rakot sibu rosar ma sibu enamon i marar simi taon nge gagei gie bu mei kokouk rubukien terengien kong vonuo ta mang vous. ");
INSERT INTO tbf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","O oeng senga, kap ka mei segie ine mi kulou o ta nga nongie gie, ta tsuokopie man ka puk ine si kong nginou.’” ");
INSERT INTO tbf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Io, mi bineit leong gi nga nomeie e Iesu. Ma a nga vuris nge oeng segie. ");
INSERT INTO tbf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sien va ka mei ta nemei seou ma ta kap karto e taman ma e kinan, ken vevien ma bu natuon, bu kasien ma bu vevinen ma buer ken tino, a kap oit va ta tsorubeit kong madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma eie ese ta kap sorokie man koitskoits nge vemusurie iou, eie a kap oit va ta tsorubeit kong madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sien va ka mei senga ta lalaro tsana ka vonuo kuar, vourvour ta mogos nge ase ken sar lakep nia telekiran va ken lakep a oit nia tsang vuruvan mi vonuo, va gerek? ");
INSERT INTO tbf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sien va ta kap muna ase ken lakep, eie ta kap oit nia tsang vuruvan mi tsientsang simi vonuo i murien va tate tsuok voturie bu arir. Ma bu mei gi ta pare ine, gi ta vavangiets ngan. ");
INSERT INTO tbf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ma gi ta pevien, ‘Ine mi ka a nga vakaek nge tsana mi vonuo ma a kap oit te nia tsang vuruvan.’ ");
INSERT INTO tbf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O, sien va ka kovakova ka leong ta lalaro veveken meie ka kovakova ka leong mene, vourvour eie ta muna mogos nge deng telekiran va a ngeisngeis oit ngan ine bu sinangavur sinangavur kes soloba (10,000) ken kulou ni minakiur va gi ta veveken meie mi mei ka ie meie ngan bu sinangavur sinangavur luo soloba (20,000) ken kulou ni minakiur, va gerek? ");
INSERT INTO tbf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sien va ta deng telekiran va a kap oit, eie ta turan ken ka ka nia ra konon nia vabatie mi ni vedeng i kotubuguor sien guor ta kap ngas me tuir matan vesuei. ");
INSERT INTO tbf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Io, mi mei senga ese ta kap tsupuk rivie ken sar sinsuv kokouk, eie ta kap oit nia tsorubeit kong madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mi barateis a kalei, eiekesen sien va ken barabaratasie tate kapangan, kap ka mei ta ba oit nia vara barabaratasie ngan te buer. ");
INSERT INTO tbf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma a kap ba kalei oit buer nia terie simi kaber o, teir muneik sien, eiekesen gi tate tomekan mo. “Eie ese ta suvu taterieng, ta ngas rorong.” ");
INSERT INTO tbf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Simi ra mene mi kulou porpor takis ma mi kulou tsokor gi nga nemei vatavatat se Iesu va gi ta nga me rongomie ken sar nama. ");
INSERT INTO tbf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bu Parisaio ma bu vavvasengei sibu vinuor se Moses gi nga ngungu lili ngan e Iesu ven ne, “Ine mi ka a ko suguo mi kulou tsokor ma a ko ngou meie gie.” ");
INSERT INTO tbf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Io, e Iesu a nga oeng ngan segie mi nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sien va ka mene kes senga a suvuon bu sipsip mi sinangavur kes koboit (100), ma sien va ka sipsip kes a veis bebeir, vasa, ine mi ka ta kap be voturie bu sinangavur mi napaririem pouts voveit ma mi napaririem pouts voveit (99) bu sipsip simi poko roterir nge ra nesie ian mi mei ta nga veis bebeir oit va ta neis vorotan? ");
INSERT INTO tbf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sien va ta neis vorotan, ta tsuok sorokie terie i karakaran ngan mi nires. ");
INSERT INTO tbf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ma sien ta veis muer beit ngan i marar, ta kukuo bu palapalan ma bu patsan kokouk nge oeng segie, ‘Nga res meie iou. O te neis vorotan kong sipsip kes ta nga veis bebeir.’ ");
INSERT INTO tbf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","O oeng senga, simi rosar kes mo, mi nires die i kur simi rangit surie ka ka tsokor va ta vodon vuris, ta leong beitsak rio mi nires surie bu sinangavur mi napaririem pouts voveit ma mi napaririem pouts voveit (99) mi kulou duis ese gi ta kap ba pinat surie mi ni vodon vuris.” ");
INSERT INTO tbf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Sien va ka vevien a suvuon mi sinangavur bu silva lakep ma a rivie ka mene kes segie, eie ta vakartie mi bember nge videir i aron mi vonuo, ma ta neis kalei oit va ta neis vorotan ken lakep. ");
INSERT INTO tbf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sien va tate neis vorotan, eie ta kuk kakuon bu palapalan ma egie ese gi ta mon kouk simi enamon kes nge pevien, ‘Nga res meie iou. O te neis vorotan kong silva lakep kes ian o ta nga rivie.’ ");
INSERT INTO tbf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Io, o oeng senga, a kokouk malan mo, ken sar angelo e Raban, gi ta res beitsak surie ka tsaka ka kes va ta vodon vuris.” ");
INSERT INTO tbf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma e Iesu a nga pevien, “Mi ka a nga suvuon ba natuon tamat luo. ");
INSERT INTO tbf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mi vemuir ngan a nga oeng se taman, ‘Tama, e tate pot terie kong potpot ian si ke sinsuv.’ Io, e tamaguor a nga potakie ken sinsuv i kotubuguor. ");
INSERT INTO tbf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“I murien mo ba ra, mi vemuirngan a nga por kakakuon ken sar kepineits nge veis rakot simi enamon i pek, ma ian en, a nga ra tomeke tuvuon ngan ken sar kepineits sibu suasuada sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I murien tate nga tomeke vaton ken sar kepineits, mi se leong a nga beit ian simi enamon. Ine mi madar a te nga suvuon mi pinat leong. ");
INSERT INTO tbf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Io, a nga ra vire tsientsang simi ka ian simi enamon, ma a nga turan rakot si ken oiroir bor va ta nga ra tabarie gie. ");
INSERT INTO tbf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A nga lalaron beitsak nia nganie magi sar nginonginou bu bor, simi vunan kap ka mei va ta nga tabarie ngan ka kepineits. ");
INSERT INTO tbf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Io, a nga tovarebar nge pevien, ‘Ken sar petspets e tamoung gi suvu nginonginou palan, eiekesen eou o tate vitor maet en ne! ");
INSERT INTO tbf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","O ta ngas tamtuir nge muerengei rakot se tamoung. Ma o ta so oeng sien, “Tama, o te nga tsana mi tsienakor se Raban ma sevoi. ");
INSERT INTO tbf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","O kap kalei oit va e ta ba buer vuotongie iou ngan va eou e natu. Tsana iou malan va eou ke petspets.” ’ ");
INSERT INTO tbf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Io, a nga tamtuir nge muerengei rakot se taman. “Eiekesen sien ta ngas nga mon i pek, e taman a nga deng kielala, ma mi aron a nga vous ngan mi tentoiv leong. Io, a nga soer susueie, ma a nga rakopie nge ngungurie e natuon. ");
INSERT INTO tbf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“E natuon a nga oeng sien, ‘Tama, o te nga tsana mi tsienakor se Raban ma sevoi. O kap kalei oit va e ta ba buer vuotongie iou ngan va eou e natu.’ ");
INSERT INTO tbf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Eiekesen e taman a nga oeng si ken sar petspets, ‘Lalapus! Nga ra por nemei ngan mi banga kuirkuir vour matkalei nge me vavatsekie ngan. Ma vasoan man ka muguir i riman ma nga ta vavatsekie ngan kaba poppop siba kamen. ");
INSERT INTO tbf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nga ra visie mi natu bor dasong nge me keda. Giet ta tsana mi nginou ma giet ta res, ");
INSERT INTO tbf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","surie ine e natung a te nga mesei, eiekesen eie a te buer to muerengei. A nga veis bebeir ma ine a te muer beit.’ Ma gi nga me teie vabatie. ");
INSERT INTO tbf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sien ine mi kepineits ta nga tsorubeit, ken muariem a nga mon i tau. Sien tate nga muerengei nge veis vatavatat i marar, a si nga rongomie mi keneveir ma mi sinieng. ");
INSERT INTO tbf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Io, a nga kukuo mi petspets nge vereie, ‘Mi sana kepineits a tsorubeit?’ ");
INSERT INTO tbf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mi petspets a nga kuil nama, ‘E kasi a te muerengei beit ine. E tama a te keda mi natu bor dasong, simi vunan e kasi a ngas to ma a te beit muerengei.’ ");
INSERT INTO tbf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mi muariem a nga petseir, ma a kap nga lalaro rubukien. Io, e taman a nga rovotsour ma a nga me oeng vamada va ta nga rubukien. ");
INSERT INTO tbf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Eiekesen a nga kuil nama se taman, ‘Pare! ine bu avareit kokouk, o nga tsatsang sevoi malan mi petspets mo. Ma o kap nga rong tsak si ke ka ni tinuturei kes. Eiekesen e kap ngas terie ka natu meme nia varese iou meie bu polopoloung. ");
INSERT INTO tbf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ine e natu a nga tomeke tuvuon ngan ke sar kepineits simi sinavei nia tabeir bor nge pirpir. Eiekesen sien ta muerengei beit i marar, e tovie ma e keda ine mi natu bor dasong!’ ");
INSERT INTO tbf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“E taman a nga oeng sien, ‘Natung, E ko mon meie iou sibu ra kokouk ma bu kepineits kokouk o ta suvuon ine, sevoi. ");
INSERT INTO tbf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Eiekesen, a sogove va giet ta ngas res nge teie vabatie, simi vunan ine e kasi a te nga mesei ma ine a te to muerengei. A nga veis bebeir ma ine a te muer beit.’” ");
INSERT INTO tbf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","E Iesu a te buer nga oeng si ken sar madar tovtov, “Mi ka suvuram a nga suvuon mi ka nennei ese ta nga ko naneie ken sar sinsuv. Eiekesen mi kulou gi nga pengan sien, va ine mi ka nennei a nga tsatsang tsak ngan bu sinsuv. ");
INSERT INTO tbf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Io, ine mi ka suvuram a nga virei vurukude nge vereie, ‘Mi sana ine o rongomie surie no? Me vasangan seou bu tsientsang kokouk e ta nga tsana si kong sar sinsuv ian gi ta nga mon si ke nennei, simi vunan e ta kap ba buer oit nia tsatsang nia naneie kong sar sinsuv.’ ");
INSERT INTO tbf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Io, ine mi ka nennei a nga oeng veie eie kesen nge kia va, ‘Misa o tate tsana? Mong ka leong a te tsang rivie iou si kong tsientsang. O kap ngeisngeis te nia tsuopuo mi kaber, ma o mengemengeir nia vor ve nono masitinoiv. ");
INSERT INTO tbf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O te telekiran misa o ta tsana! Sien va o ta tsana ine, mi kulou gi ta mang suguo iou si kegi sar vonuo sien va mong ka leong ta voto iou si kong tsientsang.’ ");
INSERT INTO tbf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Io, a nga kuk kakaku gie ese gi ta nga por kepineits si man ka leong nge kap ngas nga kuil muerngan. Ma a nga vereie mi mei vourvour, ‘A voveis e suvuon nia kuil muerngan si mong ka leong?’ ");
INSERT INTO tbf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“A nga pevien, ‘Bu sinangavur napaririem pouts tour koboit (800) bu galan oel.’ “Ine mi ka nennei a nga oeng sien, ‘Poro ine mi pakapaka rorou ta vasangan a voveis bu kepineits va e ta kulie. Ma mogos lalapus. Ma vurisan nge vataro ba sinangavur voveit koboit (400).’ ");
INSERT INTO tbf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Samo, a nga vereie mi ka a luongan, ‘Ma evoi a voveis e ta kuil muerngan?’ “A nga kuil nama, ‘Mi sinangavur kes koboit (100) bu lut wit.’ “Ine mi ka nennei a nga oeng sien, ‘Poro ine mi pakapaka rorou ta vasangan a voveis bu kepineits va e ta kulie. Ma vurisan nge vataro bu sinangavur napaririem pouts tour (80).’ ");
INSERT INTO tbf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Man ka leong a nga tienengan ine mi ka nennei nguts bitbit, simi vunan ken sinavei a nga soer simi tsientsang ian ta nga tsana. A tuktuk va mi kuoluon ine mi kaber, gi sievei beitsak nia vodusie kegi sar sinavei mi kulou ine sibu ra rio mi kulou simi taparang. ");
INSERT INTO tbf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ma o oeng senga, tsatsang ngan man sar sinsuv mi kaber nia baser palapalan meie kavo mei palan, terengien, sien va kenga sar sinsuv ta so voto, gi ta mang so kir vurukude nga simi enamon ivie gi ta tino rovoriu en. ");
INSERT INTO tbf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Eie ese ta tuktuk nia naneie ian ta lili, ta oit tuktuk nia naneie buer ian ta palan. Ma eie ese ta kap tuktuk nia naneie ian ta lili, ta kap oit tuktuk nia naneie buer ian ta palan. ");
INSERT INTO tbf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Io, sien va nga ta kap tuktuk nia naneie bu sinsuv simi kaber, ese ta oit nia terie bu sinsuv tuktuk i naparimanga? ");
INSERT INTO tbf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma sien va nga ta kap tuktuk nia naneie ken ka kepineits ka mei mene, ese ta teir vunie nge nga kenga ka kepineits kesenga? ");
INSERT INTO tbf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kap ka petspets a oit nia tsatsang si kaba ka leong luo, simi vunan ta tsak ngan ka mei ma ta tovie mi mei mene, o, eie ta tsok meie ka mei ma ta matagout ngan mi mei mene. Nga kap oit va nga ta tsatsang kokouk se Raban ma sibu sinsuv simi kaber.” ");
INSERT INTO tbf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bu Parisaio ese gi ta ko lalaron beitsak mi lakep, gi nga rongomie ine bu namanien, ma gi nga vavangiets ngan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma e Iesu a nga oeng segie, “Enga arie bu mei ese nga ta vara matkalei nge nga kesenga i matan mi kulou, eiekesen e Raban a telekiran bu aronga. Mi sana kepineits mi kulou gi ta vodon veleongtie, eie a mat minogumiets i matan e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Bu Vinuor se Moses ma bu vinavataor sibu propet, gi nga vavatei ngan tuir oit sibu ra se Ioanes mi ka ni sinusuruiv. Vakaek sibu ra se Ioanes, gi vavatei ngan mi Banga Vinavatei surie ken sinavei nia vuor e Raban, ma bu mei kokouk gi terie kegi ngeisngeis nia vemusurie. ");
INSERT INTO tbf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A ngeisngeis va mi rangit ma mi kaber guor ta kapangan eiekesen a ngeisngeis beitsak va ka puk ba tottok lili sibu mat vinavataor simi Vinuor ta kapangan. ");
INSERT INTO tbf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mi ka ese ta vekapot sorvekenan ken vevien nge reie ka vevien mene, a te tsana mi sinavei nia rei puer, ma mi ka ese ta reie ka vevien ken labeit tate nga vekapot sorvekenan, a te tsana buer mi sinavei nia rei puer. ");
INSERT INTO tbf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Mi ka suvuram a nga mon. Eie a nga ko vavaso ngan man sar tsetstseik dav matmatot ma a nga ko mon simi sinavei nia pinike tuvuon ngan ken lakep leong nia varese mo ken tino simi pirpir. ");
INSERT INTO tbf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Simi rumrubukien si ken vonuo, gi nga ko me sor vogosongie mi sinaortsak. Mi asan e Lasaro, ma mi kurikurien a nga kibakibak. ");
INSERT INTO tbf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma a nga ko lalaron va ta nga ve nganie bu sumusumu nginonginou ta nga ko korkor kovuni si ken tsur ngongou ian mi ka suvuram. Ma bu kopuen buer gi nga ko nemei nge daemdaemkie ken sar kiem. ");
INSERT INTO tbf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Samo, ine mi sinaortsak a nga maet ma bu angelo gi nga me sorokie teteir i bingan e Abaraam. Mi ka suvuram buer a nga maet ma gi nga puonongie. ");
INSERT INTO tbf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I Ades ivie ine mi ka suvuram ta nga mon simi vinekikin leong, a nga dedeng kien i kur nge dengarie e Abaraam i pek beitsak. Ma e Lasaro buer a nga mon i bingan. ");
INSERT INTO tbf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Io, a nga koup pevien, ‘Tama Abaraam, aor molous nge iou ma turan e Lasaro nia votsolopan mi louru pitsipitsiriman simi da nge me votunga ngan mi karameung, simi vunan o mon simi vinekikin leong ine simi leing!’ ");
INSERT INTO tbf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Eiekesen e Abaraam a nga kuil nama, ‘Natung, vodonomie bu ra e ta nga tino sien. E nga suvuon bu banga kepineits, eiekesen e Lasaro a nga suvuon bu tsaka kepineits. Eiekesen nevere eie a te mon simi vavaman en ne ma evoi e te mon simi vinekikin leong. ");
INSERT INTO tbf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma buer, i kotubugor ma evoi, mi moror leong a mon, terengien va egie ese gi ta mon en ne nge lalaro rakot sevoi, gi ta kap mang oit, ma ta kap oit va ka mei ta tsourarak kovuni ian en nemei ne segor.’ ");
INSERT INTO tbf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma ine mi ka suvuram a nga kuil nama, ‘Eiekesen o no masitinoiv sevoi, tama. Turan e Lasaro teteir si ken vonuo e tamoung, ");
INSERT INTO tbf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","simi vunan o suvuon bu kasiung a oit mi napaririem. Turan nia ra terie mi namani venengeng segie terengien va gi ta kap mang nemei ine simi enamon ni vinekikin.’ ");
INSERT INTO tbf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“E Abaraam a nga kuil nama, ‘Gi suvuon e Moses ma bu propet. Vodon tsupuk rivie gie. Gi ta ngas rorong segie.’ ");
INSERT INTO tbf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ma a nga pevien, ‘A kap, tama Abaraam, sien va ka mei kovuni simi miensei ta ra oeng segie, gi ta mang vodon vuris.’ ");
INSERT INTO tbf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“E Abaraam a nga oeng sien, ‘Sien va gi ta kap rorong se Moses ma bu propet, misasien buer ka ka va ta to muerengei simi miensei, ta kap oit nia vakokoit vurisan bu arogie.’” ");
INSERT INTO tbf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","E Iesu a nga pevien si ken sar madar tovtov, “Bu kepineits ta vokorongie bu mei simi sinavei tsokor, ta tamtuir, eiekesen mi tsienakor leong seie ese ta vabatie gie ine. ");
INSERT INTO tbf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sien va ka mei ta vokorongie ka mei segie ine bu sinavoir va ta tsana mi sinavei tsokor, ta kalei beitsak va gi ta pala ka dodou leong i konokonon nge ra votsorovie i rou. ");
INSERT INTO tbf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Io, naneie no kese simi sana va e ta tsana. “Sien va ka kasi ta tsana mi sinavei tsokor, oeng matan. Ma sien va ta vodon vuris, vodon rivie ken sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sien va ta tsana mi sinavei tsokor sevoi bu keipkepide ra mi napaririem pouts luo i aron mi ra kes, ma sien va bu keipkepide ra mi napaririem potsu luo a ra nemei nge me pevien, ‘O te vodon vuris,’ vodon rivie eie.” ");
INSERT INTO tbf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bu aposol gi nga pevien simi Nguts, “Be veleongtie kegei sar vodovodon tuktuk!” ");
INSERT INTO tbf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma mi Nguts a nga kuil nama, “Sien va kenga vodovodon tuktuk a lili malan mo ine mi pi mastat, va nga oit nia oeng ine simi ei va ta tetekie bu buon nge ra tuir i rou, ma ta ngas rorong senga. ");
INSERT INTO tbf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Sien va ka mei kes senga a suvuon mi petspets ta ko tsatsang i tau o, naneie bu sipsip, ma sien va ta muerengei simi korot nia tsatsang, vasa, eie ta oeng si ken petspets va ta nemei nge ngou meie? ");
INSERT INTO tbf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","A kap. Eie ta oeng sien, ‘Rorois ngan mong nginonginou. Ma verevere kalei nge tsatsang vunie iou sien va o ta ngou nge un. I muir, e ta ba ngou nge un.’ ");
INSERT INTO tbf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Vasa, eie ta vuot kalei ian simi petspets surie a nga tsana bu kepineits vemusurie mi tinuturei? ");
INSERT INTO tbf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","A kokouk buer senga, sien va nga ta tsana bu kepineits kokouk vemusurie mi tinuturei, nga ta pevien, ‘Kap va egei bu banga petspets. Gei tsang vemusurie mo kegei sar baitutuir.’” ");
INSERT INTO tbf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sien e Iesu ta nga veis rakot i Ierusalem, a nga veis ka i kotubuon i Samaria ma i Galili. ");
INSERT INTO tbf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma sien tate nga visi beit simi enamon, mi sinangavur kes bu tamat mienarouk lepra gi nga veis nemei sien. Ma gi nga tuir i pek ");
INSERT INTO tbf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nge koup pevien, “Iesu, Ka leong, tovie gei!” ");
INSERT INTO tbf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","E Iesu a nga pare gie nge pevien, “Nga rakot nge vasanga nga sibu prist.” Ma sien gi ta nga veis sorvekenan, bu kurikurigie a te nga tsorubeit melemelen. ");
INSERT INTO tbf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mi mei kes segie a nga pare va a te nga to si man mienarouk, a nga muerengei nge puongan e Raban ngan mi kinokinoup leong. ");
INSERT INTO tbf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A nga me sege pukupukukaek i kamen e Iesu nge vuot kalei sien. Ine mi ka, eie mi kangi Samaria. ");
INSERT INTO tbf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","E Iesu a nga pevien, “O si kia va mi sinangavur kes gi te melemelen. Iva ngan mi napaririem potsu voveit? ");
INSERT INTO tbf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Surie misa ine mi kibang, eie kesen mo a muerengei nia puongan e Raban?” ");
INSERT INTO tbf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma a nga oeng sien, “Tamtuir nge veis, ke vodovodon tuktuk a te vatoa no.” ");
INSERT INTO tbf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bu Parisaio gi nga vosuoreie e Iesu va venenges mi ra va e Raban ta vuor va ta nemei. Io, a nga kuil nama, “Mi sinavien e Raban nia vuor, eie a kap va mi kepineits nga ta oit nia dengarie. ");
INSERT INTO tbf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kap ka mei va ta oit nia pevien, ‘Pare, eie te ine!’ o, ‘Eie te nikot!’ simi vunan ken sinavei nia vuor e Raban a mon i aronga.” ");
INSERT INTO tbf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma a nga pevien si ken sar madar tovtov, “Mi ra ta nemei va nga ta lalaron beitsak nia mon meie e Natuon mi Ka i aron ken sar ra, eiekesen nga ta kap oit. ");
INSERT INTO tbf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mi kulou gi ta pevien senga, ‘Eie te nikot!’ o, ‘Eie te ine!’ Kian va nga ta dederivagie. ");
INSERT INTO tbf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sien va e Natuon mi Ka ta nemei, eie ta tsorubeit vasvas malan mi kutsukutsuleip ian ta kutsuleip nge rarangie bu korot kokouk simi mariu. ");
INSERT INTO tbf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Eiekesen ta be muna suvuon bu vinekikin palan ma mi kuoluon ine bu ra gi ta purusie. ");
INSERT INTO tbf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Sien e Natuon mi Ka va ta nemei, ta malan misa ta nga tsorubeit ian sibu ra se Noa. ");
INSERT INTO tbf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mi kulou gi nga mon ngan mi ngou, mi un, mi verei, ma mi vavuo bu natugie, tuir oit e Noa ta nga rubukien si man mon. Samo mi tubuik leong a nga me sorara gie. ");
INSERT INTO tbf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ma sibu ra se Lot buer, mi kulou gi nga mon ngan mi ngou, un ma verikuil nge kepineits ma tsuor tau nge sunge vonuo. ");
INSERT INTO tbf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Eiekesen sien e Lot ta nga sorvekenan i Sodom, mi leing meie bu vout lemlemka a nga kor kuvu simi rangit malan mi bat ma a nga tsang vatsakatie gie kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ine arie ta malan simi ra va e Natuon mi Ka ta tsorubeit vasvas. ");
INSERT INTO tbf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ian simi ra, sien va ka mene ta mon i pungan mi vonuo ken sar kepineits ta mon i aron, kian va ta tsour nia poro ken sar kepineits. Malan mo sien va ka mene ta mon i tau, kian va ta muerengei. ");
INSERT INTO tbf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Vodonomie ken vevien e Lot! ");
INSERT INTO tbf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Eie ese ta konon nia ruit ngan ken tino, ta rivie ken tino, ma eie ese ta kap ruit ngan ken tino, eie ta suvuon ken tino. ");
INSERT INTO tbf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","O oeng senga, ian sikati ba mei luo guor ta mutur simi tsur kes, eiekesen e Natuon mi Ka ta kerie ka mei kes seguor ma ka mei mene ta mon. ");
INSERT INTO tbf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ba vevien luo guor ta leik leseik kokouk, eiekesen e Natuon mi Ka ta kerie ka mei kes ma ka mei mene ta mon.” ");
INSERT INTO tbf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ba ka luo guor ta tsatsang i tau, eiekesen e Natuon mi Ka ta kerie ka mei kes ma ka mei mene ta mon. ");
INSERT INTO tbf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma bu madar tovtov gi nga vosuoreie e Iesu, “Mi Nguts, ivie ine bu kepineits ta tsorubeit en?” E Iesu a nga kuil nama, “Ivie mi piripirien ka mene mesei ta mon en, bu moduram gi ta beit kokouk en.” ");
INSERT INTO tbf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Samo e Iesu a nga oeng si ken sar madar tovtov ngan mi nama puppuo nia vasangan segie mi sinavei nia no va gi ta kap mang matpomaer sien. ");
INSERT INTO tbf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Simi taon mene mi ka ni vuor nama a nga mon. Eie a kap nga ko motovan e Raban ma buer a kap nga ko mangaran mi kulou. ");
INSERT INTO tbf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma ine simi taon mi vevien naor tate nga mamaet labeit buer a nga mon. A nga buburikie mi nemei nge oeng sien ven ne, ‘Kulie iou si mong matakorot.’ ");
INSERT INTO tbf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“A te nga potaram te ine mi ka ni vuor nama ta nga marsi kulie ine mi vevien, eiekesen i muir sien, a nga pevien seie kesen ven ne, ‘O kap ko motovan e Raban ma o kap ko mangaran mi kulou. ");
INSERT INTO tbf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Eiekesen surie ine mi vevien ta munu memekitsie iou, o ta dedeng sien nge kulie. Sien va o ta kap kulie, eie ta ngas nemei seou sibu ra ma ta vamare iou!’” ");
INSERT INTO tbf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma mi Nguts a nga pevien, “Nga rongomie nge por sinavei simi sana ine mi tsaka ka ni vuor nama ta nga pevien. ");
INSERT INTO tbf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Vasa, e Raban ta kap kulie ken kulou ian tate nga viel tsana gie, sien va gi ta no masitinoiv sibu rosisiat ma sibu rokati? Ma buer eie ta kap lalapus nia kulie gie? ");
INSERT INTO tbf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","O oeng senga, e Raban ta lalapus nge kulie gie. Eiekesen sien va e Natuon mi Ka ta nemei, vasa, eie ta oit nia vorotan ka mei ta suvu vodovodon tuktuk ine simi kaber?” ");
INSERT INTO tbf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E Iesu a te buer nga vokokotie ine mi nama puppuo simi kulou gi ta vodon veleongtie gie kesegie nge matagout ngan bu mei mene. ");
INSERT INTO tbf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ba ka luo guor nga kien simi Vona rengeir leong nia ra no. Mi mei kes mi Parisaio, ma mi mei mene mi ka porpor takis. ");
INSERT INTO tbf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mi Parisaio a nga tuir eie kesen ma a nga no ven ne, ‘O vuot kalei, Raban, surie eou o kap malan bu ka puerpuer, bu ka tsokor, ma bu ka simi tetteririv, ma buer o kap malan ine mi ka porpor takis. ");
INSERT INTO tbf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","O ko vorvor ba ra luo i aron mi wik kes, ma o ko terie sevoi a kes simi sinangavur kes sibu kepineits o ta poro.’ ");
INSERT INTO tbf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Eiekesen mi ka porpor takis a nga tuir i pek, ma kap va ta nga dedeng kien simi rangit, eiekesen a nga tutuo mi bongabongan ma a nga pevien, ‘Raban, aor molous nge iou. Eou mi ka tsokor!’ ");
INSERT INTO tbf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“O oeng senga, ine mi ka porpor takis, arie eie e Raban a te nga tourtelekiran va eie mi ka duis, ma kap va mi Parisaio. Egie ese gi ta veleveleongtie gie kesegie, e Raban ta vilikitie gie, ma egie ese gi ta vilivilikitie gie kesegie, e Raban ta veleongtie gie.” ");
INSERT INTO tbf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mi kulou gi nga kir nemei ngan buer bu natunatu madar se Iesu terengien va ta mang nga soburo nge vatamase gie. Eiekesen ken sar madar tovtov gi nga pare ine ma gi nga patsarie gie. ");
INSERT INTO tbf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Eiekesen e Iesu a nga kukuo gie bu natu madar nemei seie nge pevien, “Nga ta ngas sunuir terie bu natu madar nemei seou, ma kian va nga ta vangenge gie, simi vunan mi vavatamaes kovuni si ken mangmagoso Nguts e Raban a sogove gie bu suada mei malan ine. ");
INSERT INTO tbf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","O oeng tuktuk senga, eie ese ta kap lalaron va e Raban ta vuortie ken tino malan ine mi natu madar, eie ta kap oit rovoriu nia rubukien si ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mi muomuo ni vuor a nga vosuoreie e Iesu, “Banga vavvasengei, misa o ta ngas tsana nia suvuon mi tino rovoriu?” ");
INSERT INTO tbf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","E Iesu a nga oeng sien, “Surie misa e ta vuotongie iou va mi banga vavvasengei? Kap ka mei a kalei eiekesen e Raban kesen mo. ");
INSERT INTO tbf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","E telekiran bu vuna vinuor ta pevien ne, ‘Kian va e ta tsana mi sinavei nia rei puer. Kian va e ta kenvamate ka mei. Kian va e ta puer. Kian va e ta vokokotie ka nama binit i matan mi vinuor. Ma e ta ngas mangaran e tama meie e kina.’” ");
INSERT INTO tbf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma ine mi ka a nga kuil nama, “Tsuok vakaek te, o ta ngas nga madar vour, o nga vemusurie ine bu vinuor.” ");
INSERT INTO tbf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sien e Iesu ta nga rongomie ine, a nga pevien, “Mi kepineits kes e kap ngas tsana. E ta ngas verikuil ngan ke sar sinsuv kokouk nge lakep nge terie sibu sinaortsak, io, e ta ba so suvuon mi banga mos die i kur simi rangit. I muir, e ta nemei nge vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eiekesen ine mi muomuo, sien ta nga rongomie ine, a nga aor tsak, simi vunan eie a nga suvuram beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","E Iesu a nga pare ken aor tsak ine mi muomuo, ma a nga pevien, “Egie ese gi ta suvuram, a ngeisngeis segie nia rubukien si ken mangmagoso Nguts e Raban! ");
INSERT INTO tbf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A ngeisngeis beitsak simi ka suvuram va ta rubukien si ken mangmagoso Nguts e Raban, rio mi kamel ta bilok ka i aron mi mat simi pide re.” ");
INSERT INTO tbf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mi kulou gi ta nga rongomie e Iesu, gi nga virei, “Sien va ta malan, ma ese mo ta ba oit nia suvuon mi vavato?” ");
INSERT INTO tbf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","E Iesu a nga kuil nama, “Mi sana ta mavev simi kulou, a kap mavev se Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","E Petro a nga pevien, “Pare! Gei te sorvekenan kegei sar sinsuv ma gei vemusurie no!” ");
INSERT INTO tbf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","E Iesu a nga pevien segie, “O oeng tuktuk senga, eie ese ta sorvekenan ken vonuo o, ken vevien o, bu kasien o, e taman meie e kinan o, bu natuon surie ken lalaron nia mon i pakien ken vinuor e Raban, ");
INSERT INTO tbf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","eie ta so suvuon mi voirvoir leong beitsak ine sibu ra, ma ta suvuon mi tino rovoriu ian sibu ra va ta nemei.” ");
INSERT INTO tbf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","E Iesu a nga kir kakuon terie i gege mi sinangavur kes ma luo ken sar madar tovtov nge oeng segie, “Nga rorong! Nevere giet ta rakot i Ierusalem. Ian en, bu kepineits kokouk bu propet gi ta nga vataro surie e Natuon mi Ka, ta so tsorubeit tuktuk. ");
INSERT INTO tbf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ma gi ta terie i napariman bu Kibang. Ma gi ta so vavangiets ngan, ma gi ta so vamangarie nge kientsuo. ");
INSERT INTO tbf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma gi ta so beilbeiltsie nge kenvamate, eiekesen simi ra ta tourngan ta to muerengei simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Eiekesen bu madar tovtov gi kap nga katsep ine sibu namanien. Man vuevue ine mi nama a nga mumuningei segie, ma gi kap nga katsep simi sana e Iesu ta nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sien e Iesu tate nga nemei vatavatat i Ieriko, mi kael a nga mogos i gege sar ma a nga vor ve nono kepineits. ");
INSERT INTO tbf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sien ta nga rongomie mi bineit gi ta nga me veis rov riu, a nga virei, “Misa ine?” ");
INSERT INTO tbf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Io, gi nga pengan sien, “E Iesu kovuni i Nasaret die a rov riu.” ");
INSERT INTO tbf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma a nga koup pevien, “Iesu, Natuon e Davit, tovie iou!” ");
INSERT INTO tbf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mi kulou gi ta nga veis muo, gi nga patsarie nge oeng sien va ta nga bong. Eiekesen a nga koupkoup leong beitsak, “Natuon e Davit, tovie iou!” ");
INSERT INTO tbf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Io, e Iesu a nga so tuir, ma a nga tuturei surie ine mi kael va gi ta nga kir nemei ngan seie. Sien tate nga nemei vatavatat se Iesu, e Iesu a nga vosuoreie. ");
INSERT INTO tbf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Misa e lalaron va o ta tsana sevoi?” Mi kael a nga kuil nama, “Mi Nguts, o lalaro dedeng te buer.” ");
INSERT INTO tbf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma e Iesu a nga oeng sien, “Vakakan nge dedeng! Ke vodovodon tuktuk a te vatoa no!” ");
INSERT INTO tbf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ian ngas te mi kael a nga dedeng te buer. Ma a nga vemusurie e Iesu nge puongan e Raban. Sien mi bineit gi ta nga pare ine, egie kokouk gi nga puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E Iesu a nga beit i Ieriko ma a te nga visi rov riu. ");
INSERT INTO tbf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ian en mi ka a nga mon mi asan e Sakaio. Eie mi muomuo simi kulou porpor takis ma a nga suvuram. ");
INSERT INTO tbf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A nga lalaron va ta nga pare e Iesu, eiekesen a kap nga oit, simi vunan a nga poitpoit ma mi bineit buer a nga beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Io, a nga soer muo nge ra vaen simi ei mi Sikamo nia pare, simi vunan e Iesu a nga visi rov riu ka ian en. ");
INSERT INTO tbf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sien e Iesu ta nga me beit ian simi korot, a nga dedeng kien i kur ma a nga oeng sien, “Sakaio, tsour lalapus. Nevere, o ta ngas mon si ke vonuo.” ");
INSERT INTO tbf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Io, ian ngas te a nga tsour ma a nga ra marangatan ngan mi nires. ");
INSERT INTO tbf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Samo mi kulou kokouk gi nga pare ine ma gi nga vakaek nge ngungu lili, “A te ra mon vasier si ken vonuo mi ka tsokor.” ");
INSERT INTO tbf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","I muir sien, e Sakaio a nga tamtuir nge pevien simi Nguts, “Pare, mi Nguts! Ine o tate terie mi kapien si kong sar sinsuv sibu sinaortsak, ma sien va o te nga bitie ka mei ngan ken kavo lakep, o ta kuil muerngan ta vovoveit rio mi sana o ta nga poro sien.” ");
INSERT INTO tbf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","E Iesu a nga pevien, “Nevere mi vavato a te beit ine simi vonuo, simi vunan eie buer e natuon e Abaraam. ");
INSERT INTO tbf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","E Natuon mi Ka a nga nemei nia me nesie nge vatoa ese ta nga bebeir.” ");
INSERT INTO tbf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sien mi kulou gi ta ngas nga vor ve rorrong sibu nama, e Iesu a nga vakaek nge vokokotie segie mi nama puppuo, simi vunan a te nga vatvatta i Ierusalem ma mi kulou gi si nga vodon va mi ra e Raban ta vuor va tate nga so beit ian ngas te. ");
INSERT INTO tbf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Io, a nga pevien, “Mi ka asna a nga rakot simi enamon i pek va ta nga tsorubeit mi kovakova ka leong ma i muir va ta ba nga ra muerengei. ");
INSERT INTO tbf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A nga kukuo mi sinangavur kes ken sar petspets ma a nga terie segie mi sinangavur kes bu gold lakep nge pevien, ‘Nga tsatsang ngan ine bu lakep, tuir oit va o ta ra muerengei.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Eiekesen mi kuoluon ian mi enamon gi nga aor putu veie ma gi nga turan bu mei vemusurie nia ra pevien, ‘Gei kap lalaron va ine mi ka ta tsorubeit magei kovakova ka leong.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Io, a nga tsorubeit mi kovakova ka leong, ma i muir, a nga muerengei nemei si ken enamon. Samo a nga tuturei surie ian bu petspets ta nga teir gold lakep segie va ta nga me telekiran a voveis lakep gi te buer nga vabatie ngan ian bu lakep ta nga terie segie. ");
INSERT INTO tbf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Mi petspets vourvour a nga nemei ma a nga pevien, ‘Ka leong, o te nga vabatie mi sinangavur kes bu lakep mene te buer i popon ke sar lakep.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Mi muomuo a nga pevien, ‘Mi banga tsientsang, kong banga petspets! E ta so kovan bu taon mi sinangavur kes, simi vunan e te nga tuktuk nia tsatsang kalei simi puk tsientsang lili.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Mi petspets a luongan a nga nemei ma a nga pevien, ‘Ka leong, o te nga vabatie mi napaririem ba lakep mene te buer i popon ke sar lakep.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Mi muomuo a nga pevien, ‘E ta kovan bu taon mi napaririem.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Samo mi petspets mene a nga nemei ma a nga pevien, ‘Ka leong, ine arie ke lakep, o nga muningan i aron mi poko lavlav. ");
INSERT INTO tbf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","O nga motova no, simi vunan evoi mi ka kov ngeisngeis. E ko por tsana misa e ta kap nga teir toungan, ma e ko poro bu nginonginou i tau ian e ta kap nga tsuorkie.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mi muomuo a nga pevien, ‘O ta vuortie no ngan ke sar nama kese. Evoi mi tsaka petspets! E telekiran va eou mi ka kov ngeisngeis, ma e telekiran va o ko por tsana misa o ta kap nga teir toungan, ma o ko poro bu nginonginou i tau ian o ta kap nga tsuorkie. ");
INSERT INTO tbf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Surie misa e ta kap nga terie kong lakep simi vona teteir lakep, va gi ta nga tsatsang ngan, terengien, sien va o ta muerengei, o ta mang me poro kavo lakep mene i popon kong sar lakep.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Samo a nga oeng segie ian gi ta nga tuir i babaren, ‘Nga por tsana sien ken sar lakep nge terie simi mei ian ta nga vabatie mi sinangavur kes bu lakep.’ ");
INSERT INTO tbf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Eiekesen gi nga pevien, ‘Ka leong! Eie a te suvuon mi sinangavur kes bu lakep!’ ");
INSERT INTO tbf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“A nga kuil nama, ‘O oeng senga, segie ese gi ta suvuon, e Raban ta buer teteir i popon, eiekesen segie ese gi ta kap suvuon, misasien va ka puk lili gi ta suvuon, e Raban ta por tsana segie. ");
INSERT INTO tbf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eiekesen surie mong sar matakorot, ese gi ta kap nga lalaron va o ta nga tsorubeit magi kovakova ka leong, nga kir nemei nge gie nge kenvamate gie ine i matoung.’” ");
INSERT INTO tbf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","I murien e Iesu tate nga vokokotie vaton ine bu nama, a nga veis muo nge gie rakot i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sien gi tate nga beit vatavatat i Betpage ma i Betani, simi pout i Oliv, a nga turan ken ba madar tovtov luo, ma a nga oeng seguor, ");
INSERT INTO tbf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ngado ta rakot simi enamon nikot, ma sien va ngado tate so beit, ngado ta so vorotan mi dongki vour gi pal voturie ma kap ngas ka mei a nga kesie. Ngado ta so ruobatie nge kir nemei ngan. ");
INSERT INTO tbf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sien va ka mei ta vosuoreie ngado, ‘Surie misa ngado ta ruobatie?’ Ngado ta oeng sien, ‘Mi Nguts a pinat surie.’” ");
INSERT INTO tbf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Io, guor nga veis ma guor nga so vorotan bu kepineits a nga malan e Iesu tate nga vokokotie seguor. ");
INSERT INTO tbf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sien guor tate nga ruobatie ian mi dongki, ba taman ian mi dongki gituo nga vereie guor, “Surie misa ngado ta ruobatie ine mi dongki?” ");
INSERT INTO tbf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Guor nga kuil nama, “Mi Nguts a pinat surie.” ");
INSERT INTO tbf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Io, guor nga kir nemei ngan se Iesu, ma guor nga terie maguor sar tsetstseik i popon mi dongki nge kulie e Iesu va ta nga mogos i popon. ");
INSERT INTO tbf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sien tate nga mogos i popon mi dongki nge vor ve veisveis, mi kulou gi nga poro magi sar tsetstseik nge peperan i sar. ");
INSERT INTO tbf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma sien tate nga beit simi korot ivie mi rosar kovuni simi pout i Oliv tate me tsotsour peuk en, bu madar tovtov kokouk gi nga vakaek nge puongan e Raban ngan bu inagie i kur meie ngan mi nires leong surie bu kepineits ni vovokudier kokouk gi tate nga pare. ");
INSERT INTO tbf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“E Raban ta vatamase mi kovakova ka leong ese ta nemei ngan mi asan mi Nguts; Mi molu simi rangit ma mi matvinavaso rakot se Raban die i kur beitsak simi rangit!” ");
INSERT INTO tbf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bu Parisaio mene i aron mi bineit gi nga oeng se Iesu, “Vavvasengei, nasaran ke sar madar tovtov!” ");
INSERT INTO tbf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","E Iesu a nga kuil nama, “O oeng senga, sien va gi ta bong, ine bu vunavout gi ta koupkoup.” ");
INSERT INTO tbf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sien e Iesu tate nga beit vatavatat i Ierusalem nge pare, a nga tengisie. ");
INSERT INTO tbf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma a nga pevien, “Sien va e nga deng kilala misa ta oit nia vabatie mi ni vedeng nevere, va e Raban a kap nga muningan sevoi. ");
INSERT INTO tbf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mi ra ta beit va ke sar matakorot gi ta tutuvol viririsie no ma gi ta sikei vatavatat sevoi siba bienengeiv kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Gi ta vatsarerie vuruva no meie mi kulou kokouk i aron ke oiroir, ma gi ta kap oit nia deng rivie ka vunavout va ta mutur i popon ka turan vunavout, simi vunan e kap nga deng kielala mi keipkepide ra e Raban ta nga me iro no sien.” ");
INSERT INTO tbf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Io, e Iesu a nga rubukien i mararan mi Vona rengeir leong ma a nga vakaek nge kareir vorotsoruo gie ese gi ta nga verikuil nge lakep ngan kegi sar kepineits. ");
INSERT INTO tbf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma a nga oeng segie, “Mi Pakpak Leong a pevien, ‘Kong vonuo eie mi vonuo nia rengeir’, eiekesen nga si me tsana va ‘magi rie kokkoiv bu ka puerpuer.’” ");
INSERT INTO tbf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma sibu ra kokouk a nga vavasengei simi vona rengeir. Eiekesen bu prist leong, bu vavvasengei sibu vinuor se Moses ma bu muomuo simi kulou, gi nga konon va gi ta nga kenvamate. ");
INSERT INTO tbf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Eiekesen gi kap nga oit nia vorotan ka rosar nia keda, simi vunan mi kulou kokouk gi nga lalaron beitsak nia rongomie ken sar nama. ");
INSERT INTO tbf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Simi ra mene sien e Iesu ta nga vavasengei simi kulou i aron mi Vona rengeir leong nge vavatei ngan mi Banga Vinavatei, bu prist leong ma bu vavvasengei sibu vinuor se Moses, kokouk meie bu muomuo, gi nga nemei sien. ");
INSERT INTO tbf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma gi nga pevien, “Pengan segei, ngan mi sana duis e tsana ine bu kepineits? Ma ese a teir vunie nge no ine mi duis?” ");
INSERT INTO tbf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","E Iesu a nga kuil nama, “O ta vereie nga ngan buer mi vinirei. Nga pengan seou. ");
INSERT INTO tbf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mi sinusuruiv se Ioanes a nga kovuni i kur simi rangit o, simi ka?” ");
INSERT INTO tbf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Gi nga vevuran i kotubugie ma gi nga pevien, “Sien va giet ta pevien, ‘A kovuni i kur simi rangit,’ eie ta virei, ‘Surie misa nga ta kap nga vodovodon tuktuk sien?’ ");
INSERT INTO tbf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma sien va giet ta pevien, ‘A kovuni simi kulou,’ mi kulou kokouk gi ta mekiro giet nge vout, surie gi telekiran va e Ioanes eie mi propet.” ");
INSERT INTO tbf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Io, gi nga kuil nama, “Gei kap telekiran ivie a nga kuvu en.” ");
INSERT INTO tbf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","E Iesu a nga pevien, “Eou buer o ta kap pengan senga ngan mi sana duis o tsana ine bu kepineits.” ");
INSERT INTO tbf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Io, e Iesu a nga vokokotie simi kulou ine mi nama puppuo, “Mi ka a nga tsuorkie mi tau vain. A nga oeng terie simi kulou tsuotstsuor ma a nga veis rakot i pek nge ra mon potaram te. ");
INSERT INTO tbf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Simi ra mi tau tate nga komois, a nga turan mi petspets rakot ian simi kulou tsuotstsuor va gi ta mang nga teir vunie ngan kavo vuovuo ian simi tau vain. Eiekesen mi kulou tsuotstsuor gi nga tsatsakie nge ture muerngan riem kapasen. ");
INSERT INTO tbf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ma a nga turan mi petspets mene eiekesen gi nga ra tsatsakie te buer nge vamangarie nge ture muer ngan riem kapasen. ");
INSERT INTO tbf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ma a nga turan mi petspets a tourngan, ma gi nga tsetseik vatsakatie nge tomeke vorotsoruo simi tau. ");
INSERT INTO tbf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Io, e taman mi tau vain a nga pevien, ‘Misa o tate tsana? O ta turan e natung tamat, mi ateung. Tavakier gi ta mang so mangaran.’ ");
INSERT INTO tbf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Eiekesen sien mi kulou tsuotstsuor gi ta nga dengarie e natuon, gi nga vakvakokoit surie mi sana gi ta nga lalaro tsana sien. ‘Ine arie e natuon ese ta so suvuon bu sinsuv se taman. Giet ta kenvamate, ma bu kepineits ian va ta so suvuon segiet mang.’ ");
INSERT INTO tbf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Io, gi nga raok tomeke vorotsoruo i muirmuir simi tau vain nge kenvamate. “Misa nieng e taman mi tau vain ta tsana segie? ");
INSERT INTO tbf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eie ta nemei ma ta me kenvamate ine mi kulou ma ta terie mi tau si kavo mei mene.” Sien mi kulou gi ta nga rongomie ine, gi nga pevien, “Kian va ine ta tsorubeit!” ");
INSERT INTO tbf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","E Iesu a nga dedeng duis rakot segie ma a nga virei, “Misa man vuevue ine simi Pakpak Leong ian gi ta nga vataro ven ne? ‘Mi vout mi kulou tsangtsang vonuo gi ta nga purusie, a me tsorubeit mi vout mogos.’ ");
INSERT INTO tbf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Eie ese ta kor i popon ian mi vout ta katokatoim vuolili, eiekesen eie ese ian mi vout va ta kor i popon, ta kaviekaviets.” ");
INSERT INTO tbf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bu vavvasengei sibu vinuor ma bu prist leong gi nga nesie ka rosar nia rakopie e Iesu ian ngas te, simi vunan gi nga telekiran va a nga vokokotie ine mi nama puppuo surie gie. Eiekesen gi nga motovan mi kulou. ");
INSERT INTO tbf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Io, gi nga tura gituo ba ka ese va gituo ta nga mala ka tuvuon mo nia dedeng puer ngan e Iesu. Gi nga vodon nia ra ruom tsang nama sien terengien va gi ta mang nga terie i riman ken ngeisngeis ma duis mi gavana. ");
INSERT INTO tbf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Io, ian bu ka gi nga vereie, “Vavvasengei, gei telekiran va e vokokotie nge vavasengei ngan ian ta duis. E kap ko vemusurie mi tinatakien ka mei mene eiekesen e vavasengei ngan mi saran e Raban ngan mi tuktuk. ");
INSERT INTO tbf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A duis segei va gei ta voir takis rakot se Kaesar o, kap?” ");
INSERT INTO tbf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","E Iesu a nga kielala ine kegi vinirei binit ma a nga oeng segie. ");
INSERT INTO tbf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nga vasangan seou ka silva lakep sibu Roma. Mi patsapatsan ma mi asan ese a mon sien ine?” ");
INSERT INTO tbf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gi nga kuil nama, “E Kaesar.” Ma a nga oeng segie, “Io, terie rakot se Kaesar ian se Kaesar, ma terie rakot se Raban ian se Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Io gi kap nga oit nia ruom tsang nama sien i matan mi lobaram. Ma gi nga kudier si ken nama kuilkuil, ma gi nga mogos bong. ");
INSERT INTO tbf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bu meinmenien bu Sadukaio, ese gi ta nga ko pevien va a kap ka tino mumuerengei, gi nga nemei se Iesu ngan mi vinirei. ");
INSERT INTO tbf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gi nga pevien, “Vavvasengei. E Moses a nga vavataor terie segei malan ne, ‘Sien va ka ka ta maet sorvekenan ken vevien ma a kap ka natuon, ka kasien tuir muir ta ngas reie ine mi vevien nge suvu nout ken e kasien.’ ");
INSERT INTO tbf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Io, mi napaririem potsu luo bu baser kasien gi nga mon. Mi muariem a nga reie mi vevien nge mesei ma a kap ka natuon. ");
INSERT INTO tbf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mi vemusurie a nga reie ine mi vevien, ");
INSERT INTO tbf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","a, mi mei ta tour ngan buer a nga reie, ma simi rosar kes mo ine mi napaririem potsu luo egie kokouk gi nga mesei, ma gi kap nga suvu nout. ");
INSERT INTO tbf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","I muir sien, ine mi vevien buer a nga mesei. ");
INSERT INTO tbf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ma ine, simi tino mumuerengei ese te ken vevien segie, sien mi napaririem potsu luo kokouk gi nga reie ine mi vevien?” ");
INSERT INTO tbf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","E Iesu a nga kuil nama, “Mi kuoluon ine bu ra, gi rei ma gi vavuo gie. ");
INSERT INTO tbf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Eiekesen egie ese e Raban ta pevien va gi kalei oit nian mi mangmagoso enaenamon vour ian va ta nemei ma ine simi tino mumuerengei, gi ta kap so rei o, gi ta kap so vavuo gie, ");
INSERT INTO tbf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ma gi ta kap ba buer so mesei, surie gi tate so tsorubeit malan bu angelo. Egie bu natuon e Raban, surie gi nga to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma e Moses buer a nga vara tuktuk ngan va bu mei mesei gi ta to muerengei. I aron mi pinopinouts simi ei ta nga ngang, a nga vuotongie mi Nguts va eie ‘man Raban e Abaraam, a, man Raban e Isak, ma man Raban e Iakop.’ ");
INSERT INTO tbf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kap va eie magi Raban bu mei maet, eiekesen magi Raban bu mei gi ta tino, simi vunan si ken baidendeng e Raban, egie kokouk gi tino.” ");
INSERT INTO tbf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bu meinmenien bu vavvasengei sibu vinuor gi nga pevien, “Mi banga nama kuilkuil, Vavvasengei!” ");
INSERT INTO tbf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma kap ka mei a ba nga vanvando vereie ngan ka vinirei te buer. ");
INSERT INTO tbf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Io, e Iesu a nga oeng segie, “Surie misa gi ta pevien va mi Messia eie e Natuon e Davit? ");
INSERT INTO tbf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","E Davit kesen a nga pevien ne sibu Pak. ‘Mi Nguts a nga pevien si mong Nguts, “Mogos si kong riem suv, ");
INSERT INTO tbf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tuir oit va o ta tsana ma sar matakorot va ken baipoppop ba kame.” ’ ");
INSERT INTO tbf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","E Davit a nga vuotongie mi Messia va ‘mi Nguts.’ Vasa ta oit ven va e Karisito e natuon te buer?” ");
INSERT INTO tbf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ma sien mi lobaram kokouk gi ta nga vor ve rorong, e Iesu a nga oeng si ken sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nga nenei kalei sibu vavvasengei sibu vinuor se Moses. Gi ko lalaro vakam nge veis tateie magi sar tsetstseik kuar matkalei. Ma gi ko lalaron beitsak va gi ta mangara gie sibu korot nia verikuil nge kepineits. Ma gi ko lalaron kegi mogomogos bu muomuo si kegi sar vona rengeir ma kegi mogomogos mi kulou asna sibu nginou. ");
INSERT INTO tbf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gi ko bit tsang kepineits sibu vevien naor gi tate nga mamaet labeit. Ma gi ko vuotongie bu no kuar nia vakam. Bu sua mei malan ine, gi ta so suvuon mi vinatoreis leong beitsak.” ");
INSERT INTO tbf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","E Iesu a nga dedeng veriris ma a nga dengarie mi kulou suvuram gi ta nga terie kegi sar tienebeir i aron mi korot teteir lakep simi Vona rengeir leong. ");
INSERT INTO tbf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A nga pare buer mi vevien sinaortsak tate nga mamaet labeit ta nga terie ken ba natunatu lakep luo i aron mi korot teteir lakep. ");
INSERT INTO tbf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma a nga pevien, “O oeng tuktuk senga. Ine mi vevien sinaortsak a terie ken tienebeir ian ta leong rio bu mei mene. ");
INSERT INTO tbf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ine mi kulou suvuram kokouk gi terie mo mi mememoruon kegi sar sinsuv, eiekesen ine mi vevien si ken mienagos ni sinaortsak, a terie vuruvan te ken sar sinsuv kokouk ian ta oit nia tino ngan.” ");
INSERT INTO tbf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bu madar tovtov mene gi nga vakokoit surie vasa mi kulou gi nga ko vosonie venengan mi Vona rengeir leong meie ngan bu banga vout matmatot ma bu tienebeir gi ta nga ko terie rakot se Raban. Eiekesen e Iesu a nga pevien, ");
INSERT INTO tbf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Egie kokouk ine bu vout nga ta pare gie, sien va mi ra ta beit, kap ka vout kes ta so muturungie ka turan vout. Egie kokouk gi ta vatsarerie vuturungie gie i keim.” ");
INSERT INTO tbf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gi nga vosuoreie, “Vavvasengei, venenges ine bu kepineits gi ta tsorubeit? Ma mi sana ta muna tsorubeit nia vasangan va mi ra a te nemei vatavatat?” ");
INSERT INTO tbf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","E Iesu a nga pevien, “Nga nenei kalei. Gi ta masi me bitie nga. Mi kulou palan gi ta nemei ngan mi asoung nge vakokoit ven ne, ‘Arie eou te ine,’ ma ‘Mi ra a te vatavatat.’ Eiekesen kian va nga ta vemusurie gie.” ");
INSERT INTO tbf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sien va nga ta rongomie bu vinevineken ma bu tseng, kian va nga ta motou. Ian bu kepineits gi ta ngas muna beit, eiekesen mi rangi kinitip ta kap ngas beit lalapus. ");
INSERT INTO tbf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma a nga pevien segie, “Bu vuna enamon mene gi ta matakorot meie bu vuna enamon mene, ma bu mangmagoso nguts gi ta matakorot meie bu mangmagoso nguts mene. ");
INSERT INTO tbf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma bu oen leong ta beit simi kaber, ma si kavo korot mene mi se leong ta tsorubeit ma mi mienarouk buer ta vevaka. Ma bu kepineits nia vamatuo nga ma kavo suasuada totourlekier, gi ta beit kuvu simi rangit. ");
INSERT INTO tbf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“I muan va ine bu kepineits gi ta beit, gi ta rakopie nga nge vikikinie nga ma gi ta vuortie nga i aron bu vona rengeir sibu Iuda ma gi ta terie nga sibu vona vinatoreis ma gi ta por terie nga i matan bu kovakova ka leong ma bu kovakova ka simi gavaman. Io, gi ta tsana ine bu kepineits simi vunan nga vodovodon tuktuk simi asoung. ");
INSERT INTO tbf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma ine ta tsitsi vara nga nia vavatei katsep ngan mi Banga Vinavatei. ");
INSERT INTO tbf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Io, nga ta ngas tsana kenga sar vienviendon va nga ta kap muna rorois ngan ka nama nia tuir kitipa nga, ");
INSERT INTO tbf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","simi vunan o ta terie bu nama ma mi banga vienviendon senga ian va manga sar matakorot gi ta kap oit nia rube nge suereren bu namaninga. ");
INSERT INTO tbf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Misasien bu kinanga, o, bu tamanga, o, bu kasinga, o, bu patsanga, o, bu palapalanga, gi ta roev nianga. Ma kavo mei senga, gi ta terie gie simi miensei. ");
INSERT INTO tbf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Egie kokouk gi ta karto nga surie mi asoung. ");
INSERT INTO tbf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Eiekesen kap ka ni vurvur kes sibu kovanga ta kapangan. ");
INSERT INTO tbf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nga tuir ngeisngeis ma nga ta mang suvuon kenga tino. ");
INSERT INTO tbf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sien va nga tate pare mi kulou ni minakiur gi ta viririsie i Ierusalem, nga ta telekiran va mi ra nia vatsarerie a te vatavatat. ");
INSERT INTO tbf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Io, egie gi ta mon i Iudea gi ta ngas vi ra kien sibu pout, ma egie gi ta mon sibu taon gi ta ngas vi rovotsour, ma egie gi ta mon sibu tau gi ta kap rubukien simi taon, ");
INSERT INTO tbf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","simi vunan, ian bu ra nia vavatoreis, arie bu ra bu kepineits kokouk gi ta nga vataro simi Pakpak Leong ta tsorubeit tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lavei! Mi masitinoiv leong segie mi langei gi ta tian ma mi langei vusus ian simi keipkepide ra, simi vunan mi putu leong beitsak ta betingie mi kaber ma ken aor rarap e Raban ta kor i popon ine mi kulou. ");
INSERT INTO tbf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Gi ta kenvamate gie nge sele, ma gi ta kir terie gie va gi ta tsatsang vinatoreis sibu vuna enamon kokouk. Ma bu Kibang gi ta popoporie i Ierusalem oit si kegi sar ra ta voto. ");
INSERT INTO tbf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kavo totourlekier ta tsorubeit simi matanias, simi vura ma sibu kaemkaem. Ma simi kaber, bu vuna enamon kokouk gi ta aor tsak nge motovan mi tienengen bu naov ma mi tinatakien mi barateis. ");
INSERT INTO tbf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mi kulou gi ta motou beitsak nge mesei oum surie bu sana va ta ra nemei ine simi mangmagoso enaenamon, surie man sar ngeisngeis mi mariu gi ta moruor. ");
INSERT INTO tbf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Samo gi ta pare e Natuon mi Ka va ta nemei i popon mi balbal meie mi ngeisngeis ma mi banga matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sien va ine bu kepineits gi tate tsorubeit, nga ta tsuok tamtuir nge tuir pidipidin, simi vunan mi ra va e Raban ta vatoa nga sien, a te vatavatat.” ");
INSERT INTO tbf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma e Iesu a nga vokokotie segie mi nama puppuo, “Nga pare, mi fik ma bu ei kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sien va nga ta pare bu ei va gi ta bira, nga telekiran va man vura mi parpar a te vatavatat. ");
INSERT INTO tbf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Io, sien va nga ta pare ine bu kepineits gi tate vor ve tsotsorubeit, nga ta telekiran va mi ra e Raban ta vuor a te vatavatat. ");
INSERT INTO tbf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“O oeng tuktuk senga, mi kuoluon ine bu ra gi ta kap voto ngas tuir oit ine bu kepineits kokouk ta tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mi rangit ma mi kaber ta so voto eiekesen kong sar nama ta kap so voto. ");
INSERT INTO tbf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nga nenei kalei, terengien va mi sinavei nia varese nga kesenga, ma mi da nia un nge be, ma mi vodovodon palan surie ine mi tino, ta kap vuputungie bu aronga. Ma ian mi ra ta masi beit lalapus nge vokudira nga malan mi riok ta mutur rorois. ");
INSERT INTO tbf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ian mi ra ta beit simi kulou kokouk gi ta tino i popon ine mi kaber kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nga nenei kalei nge no sibu ra kokouk surie nga ta mang suvu ngeisngeis nia evisie ian bu putu kokouk va gi ta so tsorubeit, ma nga ta mang so oit nia tuir i matan e Natuon mi Ka.” ");
INSERT INTO tbf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sibu ra, e Iesu a nga ko vavasengei i aron mi Vona rengeir leong, ma sibu roreivreiv a nga ko rovotsour nge kien simi pout i Oliv nge ra mon en sibu rokati. ");
INSERT INTO tbf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma mi kulou kokouk gi nga ko pan tsourvovo nge rakot sien simi Vona rengeir leong nia ra rorong. ");
INSERT INTO tbf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Io, mi Nginu Pasova ma nian mi Tsoik kap ka iis sien, a te nga vatavatat. ");
INSERT INTO tbf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma bu prist leong ma bu vavvasengei sibu vinuor se Moses gi nga vor ve nesienesie ka rosar nia kenvamate e Iesu, simi vunan gi nga motovan mi kulou. ");
INSERT INTO tbf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Samo e Satan a nga tsegerie e Iudas, mi asan mene e Iskariot, eie mi meinmenien mi sinangavur kes ma luo bu madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","E Iudas a nga rakot sibu prist leong ma sibu muomuo simi kulou nennei simi Vona rengeir leong ma a nga ra vakvakokoit meie gie vasa va ta nga roev terie venengan e Iesu segie. ");
INSERT INTO tbf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Gi nga res nge sunuir nia teir lakep sien. ");
INSERT INTO tbf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Io, e Iudas a nga aor kes meie gie ma a nga vakaek nge dedeng ngan ka kientsep va ta nga roev terie e Iesu segie sien va ta nga kapkap. ");
INSERT INTO tbf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Samo mi ra nian mi nginou simi Tsoik kap ka iis sien, a nga beit ian va gi ta keda sien ka natu sipsip va mi tienebeir ni varam simi Nginu Pasova. ");
INSERT INTO tbf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Io, e Iesu a nga oeng se Petro ma e Ioanes, “Ngado veis nge ra rorois ngan magiet Nginu Pasova va giet ta mang so nganie.” ");
INSERT INTO tbf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Guor nga vosuoreie, “Ivie e lalaron va gor ta ra rorois ngan en ine mi nginou?” ");
INSERT INTO tbf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A nga kuil nama, “Ngado rorong! Sien va ngado ta so beit simi taon, ngado ta so vesuei meie mi ka ta sorokie ken utut mi da a mon sien. Ngado ta vemusurie rakot simi vonuo va ta rubukien en. ");
INSERT INTO tbf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ma ngado ta vosuoreie e taman mi vonuo ven ne, ‘Mi vavvasengei a virei; Iva ngan mi roruom ken bu vasier va o ta nganie en mi Nginu Pasova meie kong sar madar tovtov?’ ");
INSERT INTO tbf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eie ta vasangan sengado mi roruom leong i kur, bu mogomogos ma mi tsur ngongou a mon en. Ngado ta tsang rorois ngan mi nginonginou ian en.” ");
INSERT INTO tbf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Io, guor nga veis nge vorotan bu kepineits malan mo e Iesu ta nga vokokotie seguor. Ma guor nga tsang rorois ngan mi Nginu Pasova en. ");
INSERT INTO tbf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sien mi keipkepide ra tate nga beit, e Iesu ma bu aposol gi nga mogos viririsie mi tsur ngongou. ");
INSERT INTO tbf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma a nga oeng segie, “O nga masoron va o ta nganie ine mi Nginu Pasova meie nga i muan va o ta suvuon mi vinekikin. ");
INSERT INTO tbf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","O oeng senga, o ta kap ba buer ngou ine simi Nginu Pasova tuir oit va man vuevue ta tsorubeit tuktuk i aron ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Samo e Iesu a nga poro mi koi unun nge vuot kalei se Raban ma a nga pevien, “Nga poro ine, nge veun ngan i kotubunga. ");
INSERT INTO tbf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","O oeng senga, o ta kap ba buer unumie mi dangi vuavua vain oit va mi ra va e Raban ta vuor va ta beit.” ");
INSERT INTO tbf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma a nga poro mi tsoik nge vuot kalei se Raban ma a nga potakie nge terie segie nge pevien, “Ine arie mi piripiriung o te terie surie nga. Nga nganie ine mi tsoik nia barabaramata iou.” ");
INSERT INTO tbf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Simi rosar kes mo, i murien gi tate nga ngou voto, a nga poro mi koi unun nge pevien, “Ine mi koi eie mi kinubuits vour simi daroung, ivie a tamasoei surie nga. ");
INSERT INTO tbf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Eiekesen, nga pare, mi ka ese va ta roev terie iou, a te mogos meie iou ine simi tsur. ");
INSERT INTO tbf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","E Natuon mi Ka ta mesei vemusurie ngas te ken lalaron e Raban, eiekesen mi tsienakor leong ian simi ka ese va ta roev terie iou simi matakorot.” ");
INSERT INTO tbf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Gi nga vakaek nge vevirei nge gie ngan ese segie va ta nga tsana ine. ");
INSERT INTO tbf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma buer gi nga vakaek nge vetei nge nama i kotubugie surie ese segie va ta leongleong. ");
INSERT INTO tbf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","E Iesu a nga oeng segie, “Bu kovakova ka leong sibu Kibang gi vuortie bu kulugie. Ma egie ese gi ta suvu duis nia vuortie gie, gi vuotongie gie kesegie va egie ‘Bu palapalan mi kulou.’ ");
INSERT INTO tbf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Eiekesen kenga mienagos ta kap malan ine. Mi leongleong i kotubunga ta ngas malan va eie mi lili, ma mi muomuo ta ngas malan mi mei ese ta petspets. ");
INSERT INTO tbf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ese a leongleong? Mi mei ese ta mogos i gegen mi tsur nia ngou o, mi mei ese ta petspets? A tuktuk, mi mei ese ta mogos i gegen mi tsur nia ngou arie eie a leongleong, va gerek? Eiekesen eou o mon i kotubunga mala petspets. ");
INSERT INTO tbf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Arie enga, nga nga tuir i babareung sien o ta nga suvu konokonon. ");
INSERT INTO tbf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma o terie senga mi duis nia vuor malan e Tamoung ta nga terie seou mi duis nia vuor, ");
INSERT INTO tbf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","terengien nga ta mang ngou nge un si kong tsur ngongou i aron kong mangmagoso Nguts ma nga ta so mogos sibu mogomogos nia vuor nge vuortie mi sinangavur kes ma luo bu matabu sibu Israel.” ");
INSERT INTO tbf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, rorong! E Satan a nga vereie e Raban nia sunurie va ta kono nga malan gi ta tsamaran mi kiev niu. ");
INSERT INTO tbf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Eiekesen o nongie e Raban va ta kulie no, Simon, va ke vodovodon tuktuk ta kap kor. Ma sien va e ta muer nemei seou, e ta ngas vakotsie bu kasi.” ");
INSERT INTO tbf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eiekesen a nga oeng ngeisngeis, “Mi Nguts, o rorois nia nomeie no rakot simi vona vinatoreis ma simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","E Iesu a nga oeng sien, “O oeng sevoi Petro. E ta so vamoie iou votour i muan va mi to ta kurkuku nevere.” ");
INSERT INTO tbf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ma e Iesu a nga vosuoreie gie, “Sien o ta nga ture tuvuon nge nga, kap ka vovvoi, ka lapa o, ka poppop, vasa, nga nga pinat si ka kepineits?” Gi nga kuil nama, “A kap.” ");
INSERT INTO tbf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A nga oeng segie, “Eiekesen ine, sien va nga suvu vovvoi, poro, ma buer ka lapa. Ma sien va nga kap suvu sele, verikuil ngan manga sar kuirkuir nge vorie ngan kenga kavo sele. ");
INSERT INTO tbf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mi Pakpak Leong a pevien, ‘Ma gi nga aes meie ngan mi kulou kenken.’ Ma o oeng senga, ine mi vinavataor arie surie iou ma ta ngas tsorubeit tuktuk si kong tino. Io, misa mi Pakpak Leong ta vokokotie surie iou, ta tsorubeit tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bu madar tovtov gi nga pevien, “Pare, mi Nguts. Ba sele luo ine.” E Iesu a nga kuil nama, “A te oit.” ");
INSERT INTO tbf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Io, e Iesu a nga rovotsour nge kien simi pout i Oliv malan ta nga ko rarakot en, ma ken sar madar tovtov gi nga nomeie. ");
INSERT INTO tbf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sien gi ta nga beit ian simi korot, a nga oeng segie, “Nga no, terengien nga ta kap mang kor simi konokonon.” ");
INSERT INTO tbf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A nga veis sorvekena gie rakot i pek malan ka mei va ta oit nia toem ngan ka vunavout ma a nga sege pukupukukaek en nge no. ");
INSERT INTO tbf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tama, sien va e ta sunuir, por tsana seou ine mi koi simi vinekikin, eiekesen, vemusurie ke lalaron ma a kap va kong lalaron.” ");
INSERT INTO tbf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mi angelo kovuni die i kur simi rangit a nga beit sien ma a nga vangasie. ");
INSERT INTO tbf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Meie ngan mi aor tsak leong, a nga no ngeisngeis ma mi bieneroik ta nga tsour i kurikurien peuk simi kaber a nga malan mi dar. ");
INSERT INTO tbf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sien tate nga no voto, a nga tamtuir nge muerengei rakot si ken sar madar tovtov. Ma a nga me vorota gie sien gi ta nga vor ve mumuang simi vunan mi aor tsak a nga vamare bu kurikurigie. ");
INSERT INTO tbf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E Iesu a nga oeng segie, “Surie misa nga ta vor ve mumuang? Nga pan nge no terengien nga ta kap mang kor simi konokonon.” ");
INSERT INTO tbf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sien ta ngas nga vor ve vakvakokoit, mi bineit gi nga nemei sien. Ma mi ka mi asan e Iudas, mi meinmenien mi sinangavur kes ma luo, a nga muonge gie. Ma a nga rakot se Iesu va ta nga ngungurie. ");
INSERT INTO tbf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Eiekesen e Iesu a nga vosuoreie, “Iudas, vasa, e ta roev terie e Natuon mi Ka ngan mi nginunguir?” ");
INSERT INTO tbf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sien ken sar madar tovtov e Iesu gi ta nga pare misa ta nga lalaro tsorubeit, gi nga pevien, “Mi Nguts, gei ta veveken ngan kegei sar sele?” ");
INSERT INTO tbf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma mi mei segie a nga tseir rivie mi tateringan suv ken petspets mi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eiekesen e Iesu a nga pevien, “Kian ba buer ine mi sinavei!” Ma a nga soburo mi tateringan mi ka ma a nga som. ");
INSERT INTO tbf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Samo e Iesu a nga pevien sibu prist leong, bu muomuo simi kulou nennei simi Vona rengeir leong, ma bu muomuo ese gi ta nga nemei, “Vasa, nga nemei meie bu sele ma bu bam malan nga ta tsana simi ka kenken? ");
INSERT INTO tbf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bu ra palan o nga mon meie nga simi Vona rengeir leong, ma nga kap nga rakopie iou. Eiekesen ine arie nangba kenga keipkepide ra ivie va mi ngesengesien mi ngingi ta vuortie nga sien.” ");
INSERT INTO tbf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Io, gi nga rakopie e Iesu, ma gi nga kerie rakot ngan si ken vonuo mi kovan bu prist. E Petro a nga vor vevemuir kinetagie. ");
INSERT INTO tbf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sien mi kulou gi tate nga tsinga mi leing i kotubuon mi korot nia vuor nge mogos viririsie, e Petro a nga me mogos meie gie buer. ");
INSERT INTO tbf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Samo mi vevien petspets a nga pare ta nga mogos simi rararan mi berber simi leing ma a nga aan vangvangasie nge pevien, “Ine mi ka, eie buer a nga ko mon meie e Iesu.” ");
INSERT INTO tbf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eiekesen a nga vamoie nge pevien, “Vevien, o kap telekiran ian mi ka.” ");
INSERT INTO tbf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","I muir lili mo, mi mei mene a nga pare nge pevien, “Evoi buer mi meinmenigie.” E Petro a nga pevien, “Madar, eou kap!” ");
INSERT INTO tbf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I murien mi aua kes ta nga rov riu, mi ka mene a nga tsue nge pevien, “A tuktuk ine mi ka a nga ko mon meie simi vunan eie mi kangi Galili buer.” ");
INSERT INTO tbf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","E Petro a nga kuil nama, “Madar, o kap telekiran misa e ta vokokotie!” Duis sien ta ngas nga vakokoit, mi to a nga kurkuku. ");
INSERT INTO tbf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mi Nguts a nga vuvuris nge dengarie e Petro. Samo e Petro a nga vodonomie ken nama mi Nguts ta nga vokokotie sien malan ne, “I muan va mi to ta kurkuku nevere, e ta so vamoie iou votour.” ");
INSERT INTO tbf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma a nga veis rovotsour nge ta beitsak. ");
INSERT INTO tbf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Io, mi kulou ese gi ta nga naneie e Iesu gi nga vavangiets ngan nge tutuo. ");
INSERT INTO tbf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma buer gi nga pokutsie ba matan ma gi nga vosuoreie, “Pengan! Ese a tutuo no?” ");
INSERT INTO tbf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma gi nga vokokotie palan bu namani oeng balapoik veie. ");
INSERT INTO tbf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sien tate nga vo ra, bu muomuo leong simi kulou meie bu prist leong ma bu vavvasengei sibu vinuor se Moses gi nga beit kouk ma gi nga kerie e Iesu rakot simi Sanedrin. ");
INSERT INTO tbf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma gi nga pevien, “Sien va evoi mi Messia, pengan segei.” Eiekesen a nga kuil nama, “Misasien va o ta pengan senga, nga ta kap vodovodon tuktuk seou. ");
INSERT INTO tbf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma sien va o ta vosuoreie nga, nga ta kap kuil nama seou. ");
INSERT INTO tbf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eiekesen vakaek ine ngas te, e Natuon mi Ka ta mogos simi bienengeiv suv se Raban ngeisngeis rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma egie kokouk gi nga pevien, “Arie evoi nieng e Natuon e Raban, nge?” A nga kuil nama, “Io, arie eou mo.” ");
INSERT INTO tbf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Samo gi nga pevien, “Surie misa giet tate buer nesie kavo nama mene nia patsal meie. Egiet kesegiet giet te rorong simi ngutsuon kesen.” ");
INSERT INTO tbf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Samo bu muomuo kokouk simi kulou gi nga tamtuir ma gi nga kir rakot ngan e Iesu se Pilato. ");
INSERT INTO tbf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma gi nga vakaek nge vepitsie ngan bu nama nge pevien, “Gei te vorotan va ine mi ka a nga oengoeng ka i aron mi kulou va gi ta kap vemusurie mi vinuor, ma a nga vangenge gie va gi ta kap voir takis rakot se Kaesar ma a nga pevien va eie mi Messia, mi kovakova ka leong.” ");
INSERT INTO tbf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Io, e Pilato a nga vosuoreie e Iesu, “Arie evoi mi kovakova ka leong sibu Iuda?” E Iesu a nga kuil nama, “A malan mo e tate vuotongie.” ");
INSERT INTO tbf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ma e Pilato a nga oeng sibu prist leong ma mi bineit, “O kap vorotan ken ka bienebeir ine mi ka.” ");
INSERT INTO tbf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eiekesen gi nga tsue nge pevien, “Eie a tsana mi tsongetsonge i kotubuon mi kulou ngan ken sar vinasengei simi enamon kokouk i Iudea. A nga vakaek i Galili ma a te me beit en ne buer.” ");
INSERT INTO tbf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sien e Pilato ta nga rongomie ine, a nga virei va ine mi ka eie mi kangi Galili. ");
INSERT INTO tbf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sien ta nga rongomie va eie a nga kovuni si ken mangmagoso nguts e Erot, a nga ture varakoto se Erot ese ta nga mon i Ierusalem ian simi ra. ");
INSERT INTO tbf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sien e Erot ta nga pare e Iesu, a nga res beitsak simi vunan a nga ko pilang te nia pare. A nga rongovan bu kepineits palan surie, io, a nga lalaron beitsak nia pare va ta nga tsana kavo kepineits ni vovokudier. ");
INSERT INTO tbf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A nga vosuoreie ngan bu vinirei palan, eiekesen e Iesu a kap nga kulie ken ka virevirei. ");
INSERT INTO tbf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bu prist leong ma bu vavvasengei simi vinuor gi nga tuir ian ma gi kap nga maes nia vepitsie nge nama. ");
INSERT INTO tbf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma i murien e Erot ma ken sar kulou ni minakiur gi tate nga purusie nge vavangiets ngan, gi nga vavatsekie ngan mi banga kuirkuir matkalei nge ture muerngan rakot se Pilato. ");
INSERT INTO tbf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ian simi ra nangba e Erot ma e Pilato guor nangba nga baser palapalan. I muo sien ine, guor nga ko matakorot. ");
INSERT INTO tbf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","E Pilato a nga kuk kakuon bu prist leong, bu muomuo ni vuor ma mi kulou. ");
INSERT INTO tbf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma a nga oeng segie, “Nga kerie ine mi ka nemei seou, nge kia va a nga oeng ka i aron mi kulou va gi ta rong tsak. O te me ververeie i matanga eiekesen o kap vorotan ka vunan bu nama nga ta vepitsie ngan. ");
INSERT INTO tbf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E Erot buer a kap vorotan ka vunan. Arie mi vunan a te ture muerngan nemei segiet. Pare! Eie a kap nga tsana ka kepineits ian ta oit nia masen. ");
INSERT INTO tbf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Io, o ta votorosie ma o ta ruom rivie.” ");
INSERT INTO tbf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sibu Nginu Pasova kokouk, e Pilato ta ngas nga ruom rivie ka ka tsatsang vinatoreis vunie gie. ");
INSERT INTO tbf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eiekesen mi bineit kokouk gi nga koupkoup, “Kenvamate! Ruom rivie e Barabas nemei segei!” ");
INSERT INTO tbf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Gi nga terie e Barabas simi vona vinatoreis surie ta nga tsuok vakake mi tseng i aron mi taon ma surie mi kiden.) ");
INSERT INTO tbf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","E Pilato a nga lalaro ruom rivie e Iesu, io, a nga vakokoit te buer simi bineit. ");
INSERT INTO tbf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Eiekesen gi nga koupkoup, “Vetekiuo simi koitskoits! Vetekiuo simi koitskoits!” ");
INSERT INTO tbf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mi keipkepide ra a tourngan a te buer nga vakokoit segie, “Surie misa? Mi sana tsienakor ine mi ka a nga tsana? O kap vorotan sien ka tsienakor ian ta otien mi miensei. Io, o ta votorosie ma samo o ta ruom rivie.” ");
INSERT INTO tbf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eiekesen gi nga tsue nge oeng ngeisngeis ngan mi kinokinoup leong va ta ngas nga vetekiuo simi koitskoits ma kegi kinokinoup a nga tseiptseiprio ken lalaron e Pilato. ");
INSERT INTO tbf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Io, e Pilato a nga sunuir vemusurie kegi lalaron. ");
INSERT INTO tbf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A nga ruom rivie mi ka gi tate nga terie simi vona vinatoreis surie mi tseng ta nga vakake ma surie mi kiden, ese gi ta nga nongie ngan. Eiekesen a nga terie e Iesu i naparimagie vemusurie kegi lalaron. ");
INSERT INTO tbf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sien gi tate nga vor ve vavvasie e Iesu, gi nga rakopie e Simon mi kangi Kurene ese ta nga kovuni si ken enamon nge visi rubukien simi taon. Ma gi nga tsuok terie mi koitskoits i karakaran nge votsuoke va ta nga sorokie mi koitskoits vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Io, mi bineit leong beitsak gi nga veis vemusurie, pats meie mi langei ese gi ta nga tengisie nge ta koupkoup surie. ");
INSERT INTO tbf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eiekesen e Iesu a nga vuvuris matan veie gie nge pevien, “Mi langi Ierusalem, kian va nga ta tengisie iou. Nga ta tengisie nga kesenga ma bu natunga, ");
INSERT INTO tbf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","simi vunan mi ra ta ba beit va nga ta pevien malan ine, ‘Mi nires leong simi langei gi ta kap nga suvu madar nge kakkav nge vusus!’ ");
INSERT INTO tbf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Samo ‘gi ta oeng sibu pout, “Kor i popogei!” ma gi ta oeng sibu kuitskuits, “Puonongie gei!” ’ ");
INSERT INTO tbf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sien va mi kulou gi tsana ine bu kepineits sien mi ei ta ngas to, misa ta tsorubeit sien va ta maraong?” ");
INSERT INTO tbf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ba ka luo mene, eguor ba ka kenken, gi nga vavasie guor buer nia ra vetekiuo guor meie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sien gi tate nga beit simi korot gi ta vuotongie ngan i Paptikov, gi nga vetekiuo e Iesu simi koitskoits meie ian ba ka kenken, mi mei kes si ken bieng suv ma mi mei mene si ken bieng kieir. ");
INSERT INTO tbf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma e Iesu a nga pevien, “Tama, vodon rivie kegi sar sinavei tsokor, surie gi kap telekiran misa gi ta tsana.” Samo gi nga por vepats ngan man sar tsetstseik sien gi tate nga paluo satu ngan. ");
INSERT INTO tbf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ma mi kulou gi nga tuir nge vor ve dedeng, ma bu muomuo ni vuor gi nga vavangiets nge pevien, “A nga vatoa bu mei mene. Maga, giet ta pare va ta vatoa eie kesen sien va eie ian mi Messia ese e Raban ta nga vile!” ");
INSERT INTO tbf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mi kulou ni minakiur gi nga vavangiets ngan buer ma gi nga me terie sien mi dangi vain monour. ");
INSERT INTO tbf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma gi nga pevien, “Sien va evoi mi kovakova ka leong sibu Iuda, vatoa no kese.” ");
INSERT INTO tbf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mi vinavataor a nga mon i kovan mi koitskoits ian ta nga pevien, “Ine magi Kovakova ka leong bu Iuda.” ");
INSERT INTO tbf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mi meinmenien ian ba ka kenken a nga oeng balapoik ngan buer, “Vasa, a kap va evoi mi Messia? Vatoa no kese ma egor!” ");
INSERT INTO tbf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Eiekesen mi mei ka ie a nga patsarie nge pevien, “E kap motovan e Raban? Evoi e mon i pakien mi suada vinatoreis kes mo. ");
INSERT INTO tbf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kenata vinatoreis a duis rovoriu, simi vunan nata suvuon misa mi sinavinatau ta nga vabatie. Eiekesen ine mi ka a kap nga tsana ka tsaka sinavei.” ");
INSERT INTO tbf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Samo a nga pevien, “Iesu, vodonomie iou simi ra e ta rubukien si ke mangmagoso Nguts.” ");
INSERT INTO tbf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","E Iesu a nga kuil nama, “O oeng tuktuk sevoi, nevere e ta so mon meie iou simi enamon ni resres.” ");
INSERT INTO tbf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A te nga sisiat potaram eiekesen mi matanias a kap nga rar te ma mi ngingi leong a nga kuva mi enamon kokouk tuir oit simi 3 kilok sireivreiv. ");
INSERT INTO tbf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma mi baba gi ta nga tsana ngan mi lavlav leong nge bangie kitipan mi Korot Tamat Rovoriu i aron mi Vona rengeir leong a nga kedeir napaluo. ");
INSERT INTO tbf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Io, e Iesu a nga koup leong nge pevien, “Tama, simi naparima, o terie mi morumoruong!” Ma sien ta nga koup ven ne a nga maes rivie ken tino. ");
INSERT INTO tbf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mi muomuo simi kulou ni minakiur ta nga pare misa ta nga tsorubeit, a nga puongan e Raban nge pevien, “A tuktuk te, ine mi ka a duis rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mi bineit gi ta nga beit nia orumie ine mi kepineits, sien gi ta nga pare ine bu kepineits ta nga tsorubeit, egie kokouk gi nga tamvie bu bongabongagie nia vasangan kegi ni mesirik, ma gi nga veis. ");
INSERT INTO tbf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Eiekesen egie kokouk ian gi ta nga telekiran e Iesu, meie mi langei gi ta nga ko vemusurie kovuni i Galili, gi nga tuir i pek lili nge pare ine bu kepineits. ");
INSERT INTO tbf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mi ka, mi asan e Iosep, eie mi meinmenien bu muomuo simi Sanedrin. Ma eie mi banga ka ma ken tino a nga duis. ");
INSERT INTO tbf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A kap nga aor kes meie kegi sinusunuir ma misa gi ta nga tsana. Eie a kovuni i Arimatea mi taon i Iudea ma a nga mon rorrois simi ra va e Raban ta vuor simi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A nga rakot se Pilato ma a nga vosuoreie ngan mi piripirien e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Samo a nga por terie i keim nge ovutie ngan man banga lavlav ma a nga ra vuturungie i aron mi monmon gi ta nga kole simi vunavout ivie gi kap ngas nga vuturungie ka tonuo en. ");
INSERT INTO tbf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ine mi ra nia rorois nian mi Rangi Minaes, ma mi Rangi Minaes puk lili tate nga vakaek. ");
INSERT INTO tbf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mi langei ese gi ta nga ko nomeie e Iesu kovuni i Galili, gi nga vemusurie ma gi nga ra pare ian mi monmon ma vasa e Iosep a nga vuturungie venengan mi piripirien e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Samo gi nga muerengei nge ra rorois ngan bu da saien sosong ma bu turou sosong. Ma gi nga ra maes simi Rangi Minaes vemusurie mi vuna vinuor. ");
INSERT INTO tbf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tsourvovo mokuopkuop simi ra vourvour simi wik, mi langei gi nga vo poro kegi sar da saien sosong gi ta nga rorois ngan ma gi nga veis rakot ian simi monmon. ");
INSERT INTO tbf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gi si nga so vorotan mi vout gi te nga vuvuil rivie i matan mi monmon. ");
INSERT INTO tbf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Io, gi nga rubukien, eiekesen gi kap nga vorotan mi piripirien mi Nguts e Iesu. ");
INSERT INTO tbf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma sien gi ta ngas nga vor ve tsotsorvo surie ine mi kepineits, puk kam lalapus, ba ka luo ian maguor sar tsetstseik ta nga ber malan mi kutsukutsuleip, guor nga tuir i bingagie. ");
INSERT INTO tbf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mi langei gi nga vous ngan mi mientou ma gi nga vagotuo bu kovagie nge matan i keim ma ba ka guor nga pevien segie, “Surie misa nga ta nesie mi ka ta tino i kinorotuon bu miensei? ");
INSERT INTO tbf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eie a kap mon en ne. A te to muerengei! Nga vodonomie misa ta nga pengan senga sien ta ngas nga mon meie nga i Galili. ");
INSERT INTO tbf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A nga pevien, ‘E Natuon mi Ka gi ta ngas terie i napariman mi kulou tsokor, ma gi ta vetekiuo simi koitskoits ma simi ra ta tour ngan ta to muerengei te buer.’” ");
INSERT INTO tbf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Samo gi nangba nga vodonomie ken sar nama. ");
INSERT INTO tbf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma gi nga sorvekenan mi monmon nge muerengei, ma gi nga me vavatei ngan ine bu kepineits kokouk simi sinangavur kes ma kes ma sibu mei ka ie buer. ");
INSERT INTO tbf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ine mi langei arie e Maria kovuni i Magadala, e Ioana, e Maria e kinan e Iakobo ma bu vevien mene buer ese gi ta nga nomeie gituo, gi nga vateie bu aposol. ");
INSERT INTO tbf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Eiekesen gi kap nga vodovodon tuktuk ine simi langei, simi vunan gi si nga vodon va mi nama sasavoir mo. ");
INSERT INTO tbf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Eiekesen e Petro a nga tamtuir nge soer rakot ian simi monmon. A nga so papangiot, ma a nga pare bu poko lavlav puneits gi tate nga mutur kesegie, ma a nga kudier tsak surie misa tate nga tsorubeit, ma a nga veis muerengei. ");
INSERT INTO tbf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ine simi ra, ba madar tovtov luo segie guor nga rakot simi enamon gi vuotongie va i Emaos, a malan va mi napaririem potsu luo bu kilomita kovuni i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma guor nga veis vakvakokoit surie bu kepineits kokouk ian tate nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sien guor ta nga vor ve vakvakokoit nge pedoran ine bu kepineits i kotubuguor, e Iesu kesen a nga veis beit nge nomeie guor, ");
INSERT INTO tbf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","eiekesen guor kap nga oit nia deng kielala. ");
INSERT INTO tbf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma a nga vereie guor, “Misa ngado veis vokovokokotie?” Guor nga tuir vedidir, ma bu mataguor a nga vuris. ");
INSERT INTO tbf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mi mei kes seguor, mi asan e Kleopas, a nga vereie, “E ba beit vour mo ine i Ierusalem ma e kap telekiran bu kepineits ta nga tsorubeit die siba ra?” ");
INSERT INTO tbf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A nga virei, “Bu sana kepineits?” Guor nga kuil nama, “Bu kepineits surie e Iesu kovuni i Nasaret. Eie mi propet, ma mi namanien ma mi tsinatsangan a nga suvu ngeisngeis i matan e Raban ma mi kulou kokouk, ");
INSERT INTO tbf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ma bu prist leong ma kegei muomuo ni vuor gi nga vuor terie va gi ta nga kenvamate nge vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eiekesen gei si nga vodovodon tuktuk va arie eie mi ka nia vara ketseketseng ngan i Israel. Io, ma buer, ine a te ra tour ngan ian mi kepineits ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","I popon ine, bu mei mene si kegei sar langei gi vo me vatolala gei. Gi vo rakot ian simi monmon ine tsourvovo, ");
INSERT INTO tbf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","eiekesen gi kap vo ra vorotan mi piripirien. Gi vo nemei nge me pengan va gi vo deng vakalaie te ba angelo, ese guor ta pevien va a te to muerengei. ");
INSERT INTO tbf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bu mei mene segei gi te vo rakot ian simi monmon nge ra vorotan malan mo mi langei gi ta pengan, eiekesen, e Iesu, gi kap pare.” ");
INSERT INTO tbf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma a nga oeng seguor, “Ngado be. Ma bu arongado a kap lalapus nia vodovodon tuktuk simi sana bu propet gi ta nga vokokotie! ");
INSERT INTO tbf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vasa, a kap duis va mi Messia ta ngas muna suvu vinekikin ma samo ta ba suvuon man matvinavaso?” ");
INSERT INTO tbf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Io, a nga teresan bu nama kokouk simi Pakpak Leong seguor surie eie kesen, vakaek se Moses ma bu propet kokouk. ");
INSERT INTO tbf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma sien gituo tate nga so beit simi enamon ivie guor ta nga lalaro rakot en, e Iesu a te nga visi veis rov riu. ");
INSERT INTO tbf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Eiekesen guor nga tsue sien, “Mon meie gor, simi vunan a te reivreiv seserigo ma a te vatavatat mi ngingi.” Io, a nga rubukien nge mon meie guor. ");
INSERT INTO tbf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sien tate nga so mogos meie guor i bingan mi tsur ngongou, a nga poro mi tsoik nge vatamase, ma a nga potakie nge terie seguor. ");
INSERT INTO tbf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Samo bu katsomataguor a nangba nga katsep ma guor nga kielala, eiekesen a nga kapangan i mataguor. ");
INSERT INTO tbf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Guor nga vevirei nge guor, “Bu aronatau a tamtuir sien ta vakokoit meie natau i sar ma ta vakatsepa mi Pakpak Leong senatau, va gerek?” ");
INSERT INTO tbf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Io, ian ngas te, guor nga tamtuir nge muerengei rakot i Ierusalem. Ian en, guor nga so vorotan mi sinangavur kes ma kes meie bu mei mene gi ta nga mon kouk, ");
INSERT INTO tbf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ma guor nga pengan segie, “A tuktuk! Mi Nguts a te to muerengei ma a te vasvas se Simon.” ");
INSERT INTO tbf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Samo guor nga vakaek nge vokokotie segie misa ta nga tsorubeit i sar, ma vasa guor ba nga kielala venengan e Iesu sien tate nga potakie mi tsoik. ");
INSERT INTO tbf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ma sien gi ta ngas nga vor ve vakvakokoit surie ine, e Iesu ngas te a nga me tuir i kotubugie nge oeng segie, “Mi molu ta mon meie nga.” ");
INSERT INTO tbf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gi nga kudier nge motou, ma gi nga vodon va gi te nga dengarie ka tonuo. ");
INSERT INTO tbf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eiekesen a nga oeng segie, “Surie misa nga ta aor tsak, ma surie misa kenga sar vienviendon ta basbaslieng? ");
INSERT INTO tbf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nga dengarie ba rimoung ma ba kameung. Arie eou be mo! Nga tobelie iou nge pare. Mi tonuo a kap suvu pineits ma tsir malan nga tate pare o ta suvuon.” ");
INSERT INTO tbf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I murien ta nga pevien ne, a nga vasangan segie ba riman ma ba kamen. ");
INSERT INTO tbf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eiekesen gi kap ngas nga oit nia vodovodon tuktuk simi vunan gi nga vous ngan mi nires ma mi nikudier tsak. Io, a nga vereie gie, “Nga suvuon ka puk nginonginou?” ");
INSERT INTO tbf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Gi nga terie sien mi kato ie tuttu. ");
INSERT INTO tbf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma a nga poro nge nganie i matagie. ");
INSERT INTO tbf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma a nga oeng segie, “Sien o ta ngas nga mon meie nga, o nga pengan senga va bu kepineits kokouk ian gi tate nga vataro surie iou i aron mi Vinuor se Moses, bu vinavataor sibu propet ma bu Pak, ta ngas tsorubeit tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Samo a nga tsitsingie bu vinavinadodogie, terengien va gi ta mang nga katsep simi Pakpak Leong. ");
INSERT INTO tbf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma a nga oeng segie, “Ine arie misa gi ta nga vataro simi Pakpak Leong, ‘Mi Messia ta suvu vinekikin ma ta so to muerengei simi ra ta tourngan. ");
INSERT INTO tbf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma simi asan, gi ta vateie ngan mi kuoluon bu vuna enamon kokouk terengien gi ta mang vodon vuris ma e Raban ta vodon rivie kegi sar sinavei tsokor. Ine ta tsuok vakaek i Ierusalem.’ ");
INSERT INTO tbf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Enga arie mi kulou nia vavatei katsep ngan ine bu kepineits. ");
INSERT INTO tbf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","O ta so ture nemei ngan senga misa e Tamoung tate nga kubutsie nia terie, eiekesen nga ta mon simi taon tuir oit nga ta vavaso ngan mi ngeisngeis kovuni die i kur.” ");
INSERT INTO tbf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Io, e Iesu a nga vavasie gie rovotsour rakot simi enamon i Betani, ma a nga tsuok terie i kur ba riman nge vatamase gie. ");
INSERT INTO tbf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sien eie ta ngas nga vatamase gie, a nga sorvekena gie ma e Raban a nga kir kien ngan i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Samo gi nga rangarie ma gi nga muer rakot i Ierusalem ngan mi nires leong. ");
INSERT INTO tbf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma gi nga ko mon sibu ra simi Vona rengeir leong nge puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Simi tsuoktsuok vakaek, mi Nama a te nga mon. Ma ine mi Nama a nga mon meie e Raban, ma mi Nama eie e Raban. ");
INSERT INTO tbf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mi Nama a nga mon meie e Raban simi tsuoktsuok vakaek. ");
INSERT INTO tbf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A nga tsana bu kepineits kokouk ngan mi Nama, io, a kap ka kepineits a nga tsorubeit va ine mi Nama a kap nga tsana. ");
INSERT INTO tbf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mi petsuon mi tino a nga mon seie, ma ine mi tino eie man Berber mi kulou. ");
INSERT INTO tbf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ine mi Berber a rar i aron mi ngingi, ma mi ngingi a kap nga oit nia tseiptseiprio. ");
INSERT INTO tbf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mi ka e Raban ta nga turan, a nga beit. Mi asan e Ioanes. ");
INSERT INTO tbf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Eie a nga nemei nia vavatei katsep ngan ine mi Berber, terengien va mi kulou kokouk gi ta mang vodovodon tuktuk simi Berber. ");
INSERT INTO tbf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A kap va eie ine mi Berber, eiekesen a nga nemei nia me vavatei katsep ngan ine mi Berber. ");
INSERT INTO tbf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ine mi Berber tuktuk a nga me teir tinaparang simi kulou kokouk sien ta nga nemei simi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mi Nama a nga mon simi mangmagoso enaenamon. Misasien ta nga vogosongie mi mangmagoso enaenamon, mi mangmagoso enaenamon a kap nga deng kielala. ");
INSERT INTO tbf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A nga nemei si ken enamon kesen, eiekesen ken kulou gi kap nga suguo. ");
INSERT INTO tbf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Eiekesen segie ese gi ta nga suguo nge vodovodon tuktuk sien, a nga terie segie mi duis nia tsorubeit bu natuon e Raban. ");
INSERT INTO tbf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kap va bu nout vemusurie mi saran mi matabu o, mi lalaron simi pirpir o, mi lalaron siba tamat rei, eiekesen mi kienakav si ken lalaron e Raban. ");
INSERT INTO tbf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ine mi Nama a nga me tsorubeit ka ma a nga mon i kinorutugiet. Gei te me dengarie man matvinavaso, ine man matvinavaso e Natuon mi Tam mi kav kes. Ma a nga vous ngan mi tentoiv ma mi tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","E Ioanes a nga vavatei katsep ngan eie. A nga koup pevien, “Ine arie eie ese o ta nga vakokoit surie. Eie ese ta ba nemei vemusurie iou a tsiroup rio iou simi vunan eie a nga muna tino seou.” ");
INSERT INTO tbf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Surie ken tentoiv ian ta pu, egiet kokouk giet munu suvuon bu vavatamaes. ");
INSERT INTO tbf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","E Raban a nga vuruvan bu vinuor se Moses va kegiet, eiekesen mi tentoiv ma mi tuktuk a nga me tsorubeit tuktuk se Iesu Karisito. ");
INSERT INTO tbf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","A kap ka mei rovoriu a nga pare e Raban, eiekesen e Natuon mi kavkes, mi aten mi Tam, a nga vutuir vasangan. ");
INSERT INTO tbf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ine arie ken vinavatei vavakatsep e Ioanes sien bu muomuo sibu Iuda kovuni i Ierusalem gi ta nga turan bu prist ma bu Levi nia ra vereie va eie ese. ");
INSERT INTO tbf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Eie a kap nga muningan ka kepineits ma a nga vakokoit katsep segie ven ne, “Eou kap va mi Messia.” ");
INSERT INTO tbf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gi nga vereie, “Vasa, arie evoi e Eliia?” Ma a nga kuil nama, “A kap, kap va eou.” Gi nga vosuoreie, “Arie evoi mi propet?” Ma a nga kuil nama, “A kap.” ");
INSERT INTO tbf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Samo gi nga vereie, “Evoi ese? Terie segei ka nama nia ra pengan segie ese gi ta tura gei. Vasa e ta pevien nge no kese?” ");
INSERT INTO tbf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","E Ioanes a nga kuil nama segie ngan bu nama ta mon si ken vinavataor e Isaia mi propet nge pevien, “Eou mi inan mi mei ta koupkoup pevien simi beir, ‘Tsang vodusie ken rosar mi Nguts.’” ");
INSERT INTO tbf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Io, egie ese bu Parisaio gi ta nga tura gie, ");
INSERT INTO tbf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","gi nga vereie e Ioanes, “Ma surie misa e ta tsana mi sinusuruiv sien va a kap va evoi mi Messia o, e Eliia o, mi propet?” ");
INSERT INTO tbf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","E Ioanes a nga kuil nama segie ven ne, “Eou, o tsana mi sinusuruiv ngan mi da, eiekesen mi ka ese nga ta kap telekiran a mon i kotubunga. ");
INSERT INTO tbf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Eie ta vemusurie iou, eiekesen eou o kap kalei oit nia ruobatie ba suo si man ba poppop.” ");
INSERT INTO tbf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ine mi kepineits a nga tsorubeit i Betani simi binangavien mene mi da i Ioridan ivie e Ioanes ta nga tsana mi sinusuruiv en. ");
INSERT INTO tbf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Simi ra vemusurie, e Ioanes a nga pare e Iesu ta nga veis nemei sien ma a nga pevien, “Nga pare, ian arie ken Natu Sipsip e Raban, ese ta tsang rivie ken sar sinavei tsokor mi mangmagoso enaenamon! ");
INSERT INTO tbf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ine arie eie o ta nga vakokoit surie, sien o ta nga pevien va, ‘Eie ese ta nemei vemusurie iou, a tsiroup seou simi vunan eie a te nga muna tino i muo seou.’ ");
INSERT INTO tbf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eou ngas te o kap nga deng kielala eie, eiekesen o nga me tsang sinusuruiv ngan mi da terengien va mi kulou i Israel gi ta mang katsep se Eie.” ");
INSERT INTO tbf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Io, e Ioanes a nga vavatei katsep ven ne, “O nga pare ian mi Moromoruo ta nga tsour peuk kovuni simi rangit malan mi buen nge mon sien. ");
INSERT INTO tbf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eou o kap nga deng kielala Eie, eiekesen e Raban ese ta nga tura iou nia tsana mi sinusuruiv ngan mi da, a nga oeng seou, ‘Mi ka va e ta pare va ian mi Moromoruo ta tsour peuk nge mon sien, arie eie ta tsana mi sinusuruiv ngan mi Moromoruo Tamat.’ ");
INSERT INTO tbf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Io, eou ngas te o te nga dengarie ma ine o vavatei vavakatsep va ine arie e Natuon e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Simi ra vemusurie, e Ioanes mi ka ni sinusuruiv a buer nga tuir meie ba mei luo si ken sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sien ta nga pare e Iesu ta nga me veis rio, a nga pevien, “Nga pare, ken Natu Sipsip e Raban!” ");
INSERT INTO tbf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ken ba madar tovtov guor nga rongomie ta nga pevien ne, ma guor nga vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","E Iesu a nga eor muer, ma a nga pare guor ta nga vemusurie ma a nga virei, “Misa ngado nesie?” Guor nga vereie, “Rabbi, ivie e ko mon en?” (‘Mi Rabbi’, man vuevue va ‘mi vavvasengei’.) ");
INSERT INTO tbf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","E Iesu a nga kuil nama, “Ngado nemei, ma ngado ta so pare.” Io, guor nga rakot nge dengarie ivie ta nga monmon en, ma guor nga mon meie ian simi ra simi vunan a te nga malan va mi 4 kilok sireivreiv. ");
INSERT INTO tbf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E Andre, e kasien e Simon Petro, eie mi meinmeniguor ine ba madar tovtov guor ta nga rongomie misa e Ioanes ta nga vokokotie ma guor nga vemusurie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mi kepineits vourvour e Andre ta nga tsana, a nga ra vorotan e Simon, e kasien, nge pevien sien, “Gor te vorotan mi Messia” (man vuevue va ‘mi Karisito’). ");
INSERT INTO tbf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma a nga kerie e Simon rakot se Iesu. E Iesu a nga dengarie nge pevien, “Evoi e Simon e natuon e Ioanes, o tate tour asan nge no va evoi e Kepas.” (simi namani Grik, ‘e Petro’, ma man vuevue va, ‘mi vunavout’.) ");
INSERT INTO tbf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Simi ra vemusurie, e Iesu a nga visi veis rakot i Galili. Ma a nga suoeie e Pilipo nge oeng sien, “Vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","E Pilipo eie kovuni i Betsaida, simi taon e Andre ma e Petro guor ta kovuni en. ");
INSERT INTO tbf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E Pilipo a nga ra vorotan e Natanael ma a nga pevien sien, “Gei te vorotan ian mi ka e Moses ta nga vavataor surie simi Vinuor, ma bu propet gi ta nga vavataor surie. Eie e Iesu kovuni i Nasaret, e natuon e Iosep.” ");
INSERT INTO tbf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","E Natanael a nga virei, “I Nasaret? A oit ka kepineits kalei ta kovuni en ian?” E Pilipo a nga oeng sien, “Nemei nge me pare.” ");
INSERT INTO tbf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sien e Iesu ta nga pare e Natanael tate nga veis beit, a nga vakokoit surie, “Arie eie mi kangi Israel tuktuk. Kap ka binit a mon sien.” ");
INSERT INTO tbf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","E Natanael a nga virei, “Vasa e telekira iou ven?” E Iesu a nga kuil nama, “O pare no sien e ta ngas mogos i pakien mi ei fik i muan e Pilipo ta ra kukuo no.” ");
INSERT INTO tbf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Io, e Natanael a nga kuil nama, “Vavvasengei, evoi e Natuon e Raban, evoi mi Kovakova ka leong sibu Israel.” ");
INSERT INTO tbf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma e Iesu a nga pevien, “Vasa, e te vodovodon tuktuk surie mo o ta pengan sevoi va o pare no sien e mon i pakien mi ei fik? E ta so dengarie kavo kepineits leong rio ine.” ");
INSERT INTO tbf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma a te buer nga pevien, “O oeng tuktuk sevoi, e ta so dengarie mi rangit ta katsep, ma ken sar angelo e Raban gi ta vaen kien ma gi ta tsour peuk i popon e Natuon mi Ka.” ");
INSERT INTO tbf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Simi ra a tourngan, mi nginou ni verei a nga mon i Kana simi enamon leong i Galili. E kinan e Iesu buer a nga me mon ian en. ");
INSERT INTO tbf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma e Iesu meie ken sar madar tovtov buer gi nga nongie gie nia beit ian simi nginou ni verei. ");
INSERT INTO tbf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sien mi dangi vain tate nga voto, e kinan e Iesu a nga pevien sien, “Magi dangi vain a te voto.” ");
INSERT INTO tbf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E Iesu a nga kuil nama, “Kina, kegi sana baitutuir meie natau? Kong keipkepide ra a kap ngas beit.” ");
INSERT INTO tbf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E kinan a nga oeng sibu petspets, “Nga tsana mo misa ta oeng ngan senga.” ");
INSERT INTO tbf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bu Iuda gi nga ko vavaon vemusurie kegi sinavei nia vara melemelen nge gie. Io, surie ine, bu utut vout mi napaririem potsu kes a nga mon ian en. Mi mene kes ta oit nia poro ba sinangavur luo o, tour bu galan da. ");
INSERT INTO tbf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E Iesu a nga oeng sibu petspets, “Nga utuvie nge da ine bu utut.” Io, gi nga utuvie gie oit sibu burigie. ");
INSERT INTO tbf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma a nga oeng segie, “Ma ine, nga ut tsana kavo koip nge ra terie simi muomuo ine simi nginou.” Ma gi nga tsana malan. ");
INSERT INTO tbf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma ine mi muomuo a nga un konon ine mi da ian tate nga tsorubeit mi dangi vain. Ma eie a kap nga telekiran ivie a nga kovuni en eiekesen bu petspets ese gi ta nga ut, gi nga telekiran. Io, mi muomuo a nga kukuo mi ka ta nga rei vour nemei i bingan, ");
INSERT INTO tbf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma a nga pevien, “Bu mei kokouk gi ko muna tabeir ngan mi banga dangi vain. Ma i muir sien va bu vasier gi tate un oit, gi ta nangba tabeir ngan mi dangi vain ta kap kalei. Eiekesen evoi e por vangvangasie mi banga dangi vain oit ine.” ");
INSERT INTO tbf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","E Iesu a nga tsana ine ken totourlekier ni vovokudier vourvour i Kana simi enamon leong i Galili. Io, a nga vutuir vasangan man matvinavaso. Ma ken sar madar tovtov gi nga vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","I murien ine, e Iesu a nga kien i Kapernaum meie e kinan ma bu kasien meie ken sar madar tovtov. Ma gi nga mon ian en ba ra. ");
INSERT INTO tbf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Io, sien tate nga vatvatta mi Nginu Pasova sibu Iuda, e Iesu a nga peuk i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","I aron mi mararan mi Vona rengeir leong a nga so vorotan mi kulou gi ta nga verikuil nge lakep ngan bu bulumakau, bu sipsip ma bu bour. Ma bu mei gi ta nga verieis nge lakep gi nga mogos i babaren kegi sar tsur vovvoturu. ");
INSERT INTO tbf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Io, a nga tsana mi belibelits, ma a nga kareir vorotsoruo gie kokouk i mararan mi Vona rengeir leong, meie bu sipsip ma bu bulumakau. Ma a nga tsouptsan kegi sar lakep bu mei ververieis nge lakep ma a nga vuir matan ngan i keim kegi sar tsur. ");
INSERT INTO tbf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Segie gi ta nga verikuil ngan bu bour, a nga pevien, “Nga por rivie gie en ne! Kian va nga ta vurisan ken vonuo e Tamoung va mi korot nia verikuil nge lakep!” ");
INSERT INTO tbf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma ken sar madar tovtov gi nga vodonomie mi nama simi Pakpak Leong ian ta pevien, “Kong tentoiv tuktuk rakot si ke vonuo a ngang i aroung.” ");
INSERT INTO tbf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma bu muomuo sibu Iuda gi nga oeng ngeisngeis sien, “Mi sana totourlekier ni vovokudier e oit nia vasangan segei nia vara tuktuk ngan ke duis nia tsana ine bu kepineits?” ");
INSERT INTO tbf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","E Iesu a nga kuil nama segie, “Nga ta vatsarerie ine mi Vona rengeir leong, ma o ta tsuok voturie siba ra tour.” ");
INSERT INTO tbf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bu Iuda gi nga kuil nama, “A nga oit bu avareit ba sinangavur voveit ma mi napaririem potsu kes (46) nia tsana ine mi Vona rengeir leong. Ma evoi vasa? E ta tsuok voturie mo siba ra tour, nge?” ");
INSERT INTO tbf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Eiekesen mi Vona rengeir leong eie ta nga vakokoit surie, ian mi piripirien ngas te. ");
INSERT INTO tbf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Io, i murien e Raban ta nga vatoa simi miensei, ken sar madar tovtov gi nga vodonomie misa ta nga vokokotie. Io, gi nga vodovodon tuktuk simi Pakpak Leong ma bu nama ian e Iesu tate nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Io, sien e Iesu ta nga mon i Ierusalem simi Nginu Pasova, palan mi kulou gi nga dengarie bu totourlekier ni vovokudier ta nga tsana ma gi nga vodovodon tuktuk simi asan. ");
INSERT INTO tbf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Eiekesen e Iesu a kap nga vodovodon tuktuk si ka mei segie, surie a nga telekiran bu arogie mi kulou kokouk. ");
INSERT INTO tbf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ma a kap nga pinat surie ka mei va ta nga vakatsepa surie mi sinavien mi ka, simi vunan a nga telekiran misa ta mon i aron mi ka. ");
INSERT INTO tbf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Io, mi Parisaio mi asan e Nikodemo, eie mi meinmenigie bu muomuo si kegi sar vinuor bu Iuda. ");
INSERT INTO tbf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Simi rokati mene, a nga nemei se Iesu nge me pevien, “Rabbi, gei telekiran va evoi mi vavvasengei kuvu se Raban. Simi vunan a kap ka mei a oit nia tsana ine bu totourlekier ni vovokudier e ta tsana sien va e Raban a kap mon meie.” ");
INSERT INTO tbf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","E Iesu a nga kuil nama, “O oeng tuktuk sevoi. Kap ka mei a oit nia rubukien si ken mangmagoso Nguts e Raban sien va ta kap muna suvuon mi kienakav vuluo ngan.” ");
INSERT INTO tbf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","E Nikodemo a nga virei, “Vasa, ka mei ta oit va gi ta kav vuluo ngan te buer sien va a te komois? Eie a kap oit va ta rubukien i aron man tou se kinan va ta kava te buer!” ");
INSERT INTO tbf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","E Iesu a nga kuil nama, “O oeng tuktuk sevoi. Kap ka mei a oit nia rubukien si ken mangmagoso Nguts e Raban sien va ta kap muna suvuon mi kienakav simi da ma simi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mi pirpir a kava mi pirpir, eiekesen mi Moromoruo Tamat a kava mi moromoruo. ");
INSERT INTO tbf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kian va e ta kudier simi sana o ta pengan, ‘E ta ngas suvuon mi kienakav vuluo ngan.’ ");
INSERT INTO tbf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mi mour a ko uiv vemusurie ken lalaron. E ko rongomie mi rororotuon, eiekesen e kap telekiran ivie a kovuni en o, ivie ta rakot en. Io, a malan mo segie ese gi ta suvuon mi kienakav simi Moromoruo Tamat.” ");
INSERT INTO tbf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","E Nikodemo a nga virei, “Vasa ine mi kepineits ta tsorubeit ven?” ");
INSERT INTO tbf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","E Iesu a nga pevien, “Evoi mi vuna vavvasengei i Israel ma e kap telekiran ine bu kepineits? ");
INSERT INTO tbf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","O oeng tuktuk sevoi. Gei vokokotie misa gei ta telekiran ma gei vavatei katsep ngan misa gei tate nga pare, eiekesen kap ka mei senga a vodovodon tuktuk si kegei vinakokoit katsep. ");
INSERT INTO tbf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","O nga vokokotie sevoi bu kepineits ine simi kaber ma e kap nga vodovodon tuktuk sien. Sien va a malan ian, vasa e ta vodovodon tuktuk ven, sien va o ta vokokotie bu kepineits kovuni simi rangit? ");
INSERT INTO tbf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kap ka mei a nga kien simi rangit eiekesen e Natuon mi Ka ese ta nga kovuni simi rangit. ");
INSERT INTO tbf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","E Moses a nga tsuok terie i kur mi tsotsoi baras si man ei simi beir, io, simi rosar kes mo, e Natuon mi Ka buer gi ta ngas tsuok terie i kur, ");
INSERT INTO tbf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","terengien eie ese ta vodovodon tuktuk sien, ta mang suvuon mi tino rovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“E Raban a nga tovie beitsak mi mangmagoso enaenamon. Io, a nga terie e Natuon mi kavkes, va eie ese ta vodovodon tuktuk sien, ta kap maet, eiekesen ta suvuon mi tino rovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","E Raban a kap nga turan e Natuon nemei simi mangmagoso enaenamon nia me vavatoreis, eiekesen a nga turan va mi mangmagoso enaenamon ta mang suvu vavato surie Eie. ");
INSERT INTO tbf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eie ese ta vodovodon tuktuk se Natuon e Raban, eie ta kap tuir simi vinuor, eiekesen eie ese ta kap vodovodon tuktuk, a te tuir simi vinuor simi vunan eie a kap nga vodovodon tuktuk simi asan e Natuon e Raban mi kavkes. ");
INSERT INTO tbf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ine arie vasa mi vinuor a tsatsang ven. Mi Berber a te nga beit simi mangmagoso enaenamon, eiekesen mi kulou gi nga lalaron beitsak mi ngingi, ma kap va mi Berber, simi vunan bu sinavigie a nga tsokor. ");
INSERT INTO tbf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Eie ese ta tsana mi tsienakor a karto mi Berber, ma eie ta kap nemei simi Berber surie a motou va bu sinavien ta masi tsorubeit vasvas. ");
INSERT INTO tbf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Eiekesen eie ese ta tsana mi tuktuk a ko nemei simi Berber, terengien va mi kulou gi ta mang pare va misa ta tsana a vemusurie ken lalaron e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","I murien ne, e Iesu ma ken sar madar tovtov gi nga veis rakot i Iudea. A nga mon en ian meie gie ma a nga tsana mi sinusuruiv simi kulou. ");
INSERT INTO tbf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Io, e Ioanes buer a nga tsana mi sinusuruiv i Aenon vatvatta i Salim, simi vunan mi da leong a nga mon en ma mi kulou gi nga nemei sien nia me por sinusuruiv. ");
INSERT INTO tbf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ine bu kepineits a nga tsorubeit i muan gi ta nga terie e Ioanes simi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mi nama vevengeis a nga tsorubeit i kotubuon ken sar madar tovtov e Ioanes, meie mi kangi Iudea, surie mi sinavei nia suruvie bu mei vemusurie mi vinuor. ");
INSERT INTO tbf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Gi nga nemei se Ioanes nge pevien, “Rabbi, ian mi ka ta nga mon meie no nikot simi binangavien mene mi da i Ioridan, ese e ta nga vavatei katsep ngan, eie a tsana mi sinusuruiv, ma bu mei kokouk gi vor ve rarakot seie.” ");
INSERT INTO tbf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","E Ioanes a nga kuil nama, “Mi ka a oit nia suvuon mo misa e Raban ta terie sien. ");
INSERT INTO tbf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Enga ngas te nga oit nia vara tuktuk ngan misa o ta nga pengan, ‘A kap va eou mi Karisito, eiekesen e Raban a nga tura iou nia muo seie.’ ");
INSERT INTO tbf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mi vevien va ta rei vour, arie eie ken vevien mi ka va ta rei vour. Eiekesen e palapalan ine mi ka ian ta tuir vatavatat, eie ta vous ngan mi nires sien ta rongomie mi inan ine mi ka. Ine arie vasa kong nires ta me tsorubeit pu ven. ");
INSERT INTO tbf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eie ta vor ve tsotsorubeit leong ma eou o ta vor ve tsotsorubeit lili. ");
INSERT INTO tbf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Mi ka ta kovuni die i kur, a tsiroup rovoriu. Eiekesen eie ese ta kovuni simi kaber, eie mi kangien mi kaber, ma a vakokoit malan mi mei kuvu simi kaber. Io, mi ka ta kovuni die i kur simi rangit, a tsiroup rovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ine mi ka a vavatei katsep ngan misa ta nga pare nge rongomie, eiekesen a kap ka mei a vodovodon tuktuk si ken vinavatei vavakatsep. ");
INSERT INTO tbf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Eie ese a vodovodon tuktuk si ken vinavatei vavakatsep, a vara tuktuk ngan va e Raban eie mi tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Io, mi Ka ese e Raban ta nga turan, a vokokotie bu namanien e Raban, simi vunan e Raban a vovovsuo vunie ngan mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mi Tam a tovie e Natuon ma a nga terie bu kepineits kokouk i riman. ");
INSERT INTO tbf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Eie ese ta vodovodon tuktuk se Natuon, a suvuon mi tino rovoriu, eiekesen eie ese ta rong tsak se Natuon, ta kap so pare mi tino, eiekesen ken aor rarap e Raban a mon i popon.” ");
INSERT INTO tbf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Bu Parisaio gi nga rongomie va e Iesu a nga tsana mi sinusuruiv nge kerie palan mi kulou rio e Ioanes. ");
INSERT INTO tbf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Si man tuktuk, e Iesu a kap nga tsana mi sinusuruiv, eiekesen ken sar madar tovtov.) ");
INSERT INTO tbf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sien mi Nguts tate nga vakierngie ine, a nga veis sorvekenan i Iudea ma a nga muerengei te buer rakot i Galili. ");
INSERT INTO tbf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma e Iesu ta ngas nga veis ka i Samaria. ");
INSERT INTO tbf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Io, i Samaria, a nga beit simi taon gi vuotongie va i Sukar vatvatta mi kato kaber e Iakop ta nga terie se Iosep, e natuon. ");
INSERT INTO tbf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mi matada se Iakop a nga mon en ian. E Iesu a nga maer sien ta nga vesingie mi rosar kuar. Io, a nga mogos i gegen mi matada. Ma a te nga sisiat potaram. ");
INSERT INTO tbf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mi vevine Samaria a nga nemei nia me ut ma e Iesu a nga vereie, “Vevien, a oit va e ta vuvunumie iou?” ");
INSERT INTO tbf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Eie a nga mon kesen ian simi keipkepide ra simi vunan ken sar madar tovtov gi nga veis rakot simi taon nia ra voir nginonginou. ");
INSERT INTO tbf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mi vevine Samaria a nga pevien sien, “Evoi mi Iuda ma eou mi vevine Samaria. Surie misa e ta nongie iou nge da?” (Simi vunan, bu Iuda gi kap ko baser palapalan meie bu Samaria.) ");
INSERT INTO tbf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","E Iesu a nga kuil nama, “Sien va e nga telekiran ken tienebeir e Raban ma sien va e nga telekiran eie ese ta vereie no nge da, va e vosuoreie ma eie ta terie sevoi mi da ni tino.” ");
INSERT INTO tbf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ine mi vevien a nga pevien, “Ka leong, kap ke ka utut nia ut ma mi matada a peuk beitsak i keim. Ivie e ta poro en ine mi da ni tino? ");
INSERT INTO tbf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","E tamagei e Iakop a nga terie segei ine mi matada. Eie ma bu natuon ma ken sar vinavinar kokouk gi nga ko me un sien. Vasa, evoi e as leong rio e Iakop?” ");
INSERT INTO tbf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","E Iesu a nga kuil nama, “Eie ese ta un ine simi matada ta moruo te buer, ");
INSERT INTO tbf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","eiekesen eie ese ta unumie mi da o ta terie sien, ta kap moruo te buer. Mi da va o ta terie sien, ta tsorubeit mi da kilikilivueit i aron nia terie mi tino rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mi vevien a nga pevien, “Ka leong, terie seou ian mi da, terengien va o ta kap mang moruo te buer, ma o ta kap mang muermuerengei nemei en te ine nia me ut.” ");
INSERT INTO tbf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","E Iesu a nga oeng sien, “Veis nge ra kerie ke labeit nemei ne.” ");
INSERT INTO tbf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mi vevien a nga kuil nama, “A kap kong ka labeit.” E Iesu a nga pevien sien, “A duis sien e ta pevien va, ‘A kap kong ka labeit.’ ");
INSERT INTO tbf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Si man tuktuk, e te nga reie ba ka napaririem ma mi ka ine ngado tate mon kouk, eie kap va ke labeit. Misa e ta pengan eie a tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mi vevien a nga pevien, “Ka leong, o kielala va evoi mi propet. ");
INSERT INTO tbf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bu tubugei bu Samaria gi nga ko rangarie e Raban ine simi pout, eiekesen enga bu Iuda nga ko pevien va i Ierusalem arie eie mi korot ivie mi kulou gi ta ngas rangarie en e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","E Iesu a nga oeng sien, “Vevien. Vodovodon tuktuk simi sa o ta vokokotie. Mi ra ta nemei va nga ta kap ba buer rangarie mi Tam ine simi pout o, i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Enga bu Samaria nga rangarie misa nga ta kap telekiran, eiekesen egei bu Iuda gei rangarie misa gei ta telekiran, simi vunan mi vavato a nga vunan sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Eiekesen mi ra ta nemei ma ine a te beit va mi kulou ese gi ta lalaro rengeir tuktuk, gi ta rangarie mi Tam ngan mi moromoruo ma mi tuktuk, simi vunan mi Tam a nesie mi suada kulou malan ine nia rangarie. ");
INSERT INTO tbf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","E Raban eie mi moromoruo, ma mi kulou gi ta rangarie, gi ta ngas rangarie ngan mi moromoruo ma mi tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mi vevien a nga pevien, “O telekiran va mi Messia ta ba beit (ian gi ta vuotongie ngan e Karisito). Simi ra va ta beit, Eie ta me palsie bu kepineits kokouk segei.” ");
INSERT INTO tbf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Samo e Iesu a nga pevien, “Eou ese o ta vakokoit sevoi, arie eou Eie.” ");
INSERT INTO tbf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ian simi keipkepide ra, ken sar madar tovtov gi nga muerengei beit ma gi nga kudier tsak nia vorotan e Iesu ta nga vakokoit meie mi vevien. Eiekesen a kap ka mei a nga vereie mi vevien, “Misa e lalaron?” o, nge vereie e Iesu, “Surie misa e ta vakokoit meie?” ");
INSERT INTO tbf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Samo ine mi vevien a nga sorvekenan ken utut da nge muerengei rakot simi taon ma a nga ra oeng simi kulou, ");
INSERT INTO tbf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nga nemei nge me pare mi ka ta pengan seou bu kepineits kokouk o ta nga ko tsana. Tavakier ine arie eie mi Messia?” ");
INSERT INTO tbf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Io, gi nga rovotsour simi taon ma gi nga veis rakot seie. ");
INSERT INTO tbf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sien ine mi vevien ta nga rakot simi taon, ken sar madar tovtov e Iesu gi nga no ngeisngeis se Iesu nge pevien, “Vavvasengei, be nganie ma ka puk nginonginou.” ");
INSERT INTO tbf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Eiekesen a nga oeng segie, “Mong nginonginou a mon, ian kap kenga ka bienengeiv sien.” ");
INSERT INTO tbf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma ken sar madar tovtov gi nga vakaek nge vakokoit i kotubugie, “Tavakier nieng, ka mei a te me tabarie?” ");
INSERT INTO tbf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","E Iesu a nga pevien, “Mong nginonginou eie nia tsang vemusurie ken lalaron ese ta nga tura iou, ma nia tsang vuruvan ken tsientsang. ");
INSERT INTO tbf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Vasa, nga kap ko pevien, ‘Ba vura voveit a ngas mon oit simi ra nia kakarie mi tau’? Eiekesen o oeng senga, dedeng kalei viririsie nga nge pare vasa a te komois ven bu tau nia por nginonginou sien! ");
INSERT INTO tbf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mi ka ni tsientsang nia por nginonginou a te poro ken voirvoir ma a vor ve tsatsang nia kerie bu mei rakot simi tino rovoriu, terengien mi ka tsuotstsuor ma mi ka popor nginonginou i tau eguor kokouk guor ta mang res. ");
INSERT INTO tbf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ine a vara tuktuk ngan ine mi vinavataor ian ta pevien, ‘Mi ka kes a tsutsuor, a, mi ka mene a por nginonginou.’ ");
INSERT INTO tbf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","O nga tura nga nia ra por nginonginou ivie nga ta kap nga tsutsuor en. Bu mei mene gi nga tsana mi tsientsang ngeisngeis ma enga nga te nga poro mi vuovuan mi tsinatsangagie.” ");
INSERT INTO tbf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Palan bu Samaria kovuni ian simi taon gi nga vodovodon tuktuk se Iesu simi vunan ine mi vevien a nga vavatei katsep malan ine, “Eie a nga vokokotie seou bu kepineits kokouk o ta nga tsana.” ");
INSERT INTO tbf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Io, sien bu Samaria gi ta nga nemei sien, gi nga no va ta be nga mon meie gie. Ma a nga mon ba ra luo en ian. ");
INSERT INTO tbf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma surie ken sar nama e Iesu, palan segie gi nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma gi nga pevien ian simi vevien, “Ine, gei te vodovodon tuktuk simi vunan egei kesegei gei te rongomie e Iesu, kap va surie mi sana e ta nga pengan segei. A tuktuk, eie man Ka ni vavato mi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","I murien ine ba ra luo, e Iesu a nga veis rakot simi enamon leong i Galili. ");
INSERT INTO tbf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(E Iesu a nga vavatei katsep ngan va mi propet a kap suvu minangarei si ken enamon kesen.) ");
INSERT INTO tbf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sien ta nga so beit i Galili, mi kulou ian en gi nga resmatan, simi vunan egie buer gi nga ra mon simi Nginu Pasova i Ierusalem ma gi nga pare bu kepineits ian ta nga tsana en. ");
INSERT INTO tbf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Io, e Iesu a te buer nga rakot i Kana simi enamon leong i Galili ivie ta nga muna vurisan en mi da rakot simi dangi vain. Ian en mi muomuo ese ta nga ko tsatsang meie mi kovakova ka leong a nga mon. E natuon tamat a nga morouk nge mon i Kapernaum. ");
INSERT INTO tbf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sien ine mi ka ta nga rongovan va e Iesu a nga beit i Galili kovuni i Iudea, a nga rakot sien ma a nga nongie va ta nga ra vatoa e natuon tate nga vatvatta mesei. ");
INSERT INTO tbf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","E Iesu a nga oeng sien, “Vasa, nga ta ba vodovodon tuktuk mo sien va nga ta pare ka totourlekier ma ka kepineits ni vovokudier?” ");
INSERT INTO tbf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ine mi muomuo a nga pevien, “Ka leong, nemei lalapus. E natung ta masi mesei.” ");
INSERT INTO tbf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","E Iesu a nga kuil nama, “Veis. E natu a te to.” Ine mi ka a nga vodovodon tuktuk simi namanien ma a nga veis. ");
INSERT INTO tbf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sien ta ngas nga vor ve veisveis i sar, ken ba petspets gituo nga samsuoeie nge pengan va e natuon a te nga to si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A nga vosuoreie gituo va simi sana keipkepide ra e natuon a nga vakaek nge kalei. Ma gituo nga pevien, “Simi 1 kilok sisiat nanor a te vio.” ");
INSERT INTO tbf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Samo e taman mi madar a nga vodonomie ian mi keipkepide ra sien e Iesu ta nga oeng sien, “E natu a te to.” Io, eie ma egie kokouk si ken vonuo gi nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ine arie eie mi totourlekier ni vovokudier a luongan ian e Iesu ta nga tsana i murien ta nga beit i Galili kovuni i Iudea. ");
INSERT INTO tbf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","I murien ine, e Iesu a nga rakot i Ierusalem simi nginou sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","I Ierusalem, vatvatta mi korot mi asan va Magi Rumrubukien bu Sipsip, mi koip a nga mon. Ine mi koip, simi namani Iburu, gi nga vuotongie ngan i Betsada. Ma man ba papael porpor mour a nga napaririem. ");
INSERT INTO tbf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma ian siba papael, palan bu tamat mienarouk gi nga mon en, bu kael, bu peong, ma bu muru. Gi nga ko rosie va mi da ta nga vovureis, ");
INSERT INTO tbf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","simi vunan ken angelo mi Nguts a nga ko tsour peuk sibu ra mene nge me gula mi koip. Ma eie ese va ta nga muna popop i aron ine mi koip i murien mi angelo ta nga me gula, ta nga ketseketseng si man mienarouk. ");
INSERT INTO tbf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mi ka ese ta nga morouk bu avareit ba sinangavur tour ma mi napaririem potsu tour, a nga mon. ");
INSERT INTO tbf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sien e Iesu ta nga dengarie ine mi tamat mienarouk ta nga mutur, a nga telekiran va ine mi ka a nga morouk kebeir te. Ma a nga vosuoreie, “E lalaron va e ta kalei?” ");
INSERT INTO tbf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mi tamat mienarouk a nga kuil nama, “Ka leong. Kap ka mei va ta kulie iou nia rubukien simi koip sien ta vovureis. Sien o ta konon nia rubukien i aron, mi mei mene a ko muo seou.” ");
INSERT INTO tbf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E Iesu a nga oeng sien, “Tsuok tamtuir! Poro ke tsur nge veis.” ");
INSERT INTO tbf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ian ngas te, ine mi ka a te nga ketseketseng, ma a nga poro ken tsur nge veis. Ine mi kepineits a nga tsorubeit simi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Io, bu muomuo sibu Iuda gi nga oeng simi ka tate nga kalei, “Ine mi ra, mi Rangi Minaes, ma a kap duis va e ta sorokie ke tsur sien.” ");
INSERT INTO tbf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eiekesen a nga kuil nama segie ven ne, “Mi ka ta vatoa iou a te oeng seou, ‘Tsuok sorokie ke tsur nge veis.’” ");
INSERT INTO tbf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gi nga vosuoreie, “Ese ian mi ka ta oeng sevoi nia tsana ine?” ");
INSERT INTO tbf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Eiekesen ine mi ka tate nga kalei, a kap nga telekiran va ese ian mi ka, simi vunan mi bineit a nga palan beitsak ma e Iesu a nga ku menen nge veis. ");
INSERT INTO tbf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","I muir sien, e Iesu a nga vorotan i aron mi Vona rengeir leong, ma e Iesu a nga oeng sien, “Rorong, ine e te kalei. Kian va e ta tsana mi sinavei tsokor te buer. Ka kepineits tsokor rio vourvour ta masi beit sevoi.” ");
INSERT INTO tbf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Io, ine mi ka a nga veis nge ra pengan sibu Iuda va arie eie e Iesu mo a nga vatoa. ");
INSERT INTO tbf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Io, surie e Iesu ta nga tsana ine bu kepineits simi Rangi Minaes, bu muomuo sibu Iuda gi nga vakaek nge vikikinie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","E Iesu a nga kuil nama segie, “E Tamoung a ko munu tsatsang oit vere, ma eou buer o ta ngas tsatsang.” ");
INSERT INTO tbf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ma surie ine, kegi sar vienviendon bu Iuda nia kenvamate a te nga tsorubeit ngeisngeis beitsak segie. Kap va surie mo ta nga pop vuturungie man vinuor simi Rangi Minaes, eiekesen buer surie a nga pevien va e Raban eie e Taman ma a nga tsana eie kesen ta kokouk meie e Raban. ");
INSERT INTO tbf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Io, e Iesu a nga kuil nama segie, “O oeng tuktuk senga. Mi Nout kesen a kap oit nia tsana ka kepineits. Eie ta tsana mo mi sana ta pare e Taman ta tsana. Ma mi sana mi Tam ta tsana, mi Nout buer ta tsana. ");
INSERT INTO tbf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Simi vunan mi Tam a ko tovie mi Nout ma a ko vasangan sien bu kepineits kokouk Eie ta ko tsana. Ma mi Tam ta vasangan sien bu tsientsang leong sorvekenan ine va ta tsana, terengien va nga ta mang kudier. ");
INSERT INTO tbf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mi Tam a ko vatoa bu tamat miensei nge terie mi tino segie. Malan be mo mi Nout a ko terie mi tino segie ese ta lalaron. ");
INSERT INTO tbf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kap va mi Tam ta vuortie ka mei simi vinuor. Eiekesen a te terie se Natuon bu ngeisngeis kokouk nia vuor, ");
INSERT INTO tbf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","terengien egie kokouk gi ta mang mangaran mi Nout malan mo gi ta ko mangaran mi Tam. Eie ese ta kap mangaran mi Nout, a kap mangaran mi Tam ese ta nga turan mi Nout. ");
INSERT INTO tbf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“O oeng tuktuk senga. Eie ese ta rongomie kong sar nama nge vodovodon tuktuk seie ese ta nga tura iou, eie ta suvuon mi tino rovoriu. Ma eie ta kap tuir simi vinuor, eiekesen a te evisie mi miensei nge rakot simi tino. ");
INSERT INTO tbf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","O oeng tuktuk senga. Mi ra ta beit ma ine a te beit va bu miensei gi ta rongomie mi inan e Natuon e Raban, ma egie ese gi ta rongomie gi ta tino. ");
INSERT INTO tbf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mi Tam eie mi petsuon mi tino, ma a nga sunuir va mi Nout buer ta tsorubeit mi petsuon mi tino. ");
INSERT INTO tbf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma a nga terie mi duis simi Nout nia vuor, simi vunan Eie e Natuon mi Ka. ");
INSERT INTO tbf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Kian va nga ta kudier tsak surie ine, simi vunan mi ra va ta beit sien egie kokouk gi ta mon sibu monmon gi ta rongomie mi inan. ");
INSERT INTO tbf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ma gi ta rovotsour. Egie ese gi ta nga tsana mi kienelei gi ta to muerengei nge mon simi tino. Ma egie ese gi ta nga tsana mi tsienakor gi ta to muerengei nge mon simi vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","O kap oit nia tsana ka kepineits eou keseung. O ko vuor vemusurie misa o ta rongomie simi Tam. Ma kong sinavei nia vuor a duis simi vunan o kap vemusurie kong lalaron, eiekesen ken lalaron ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sien va O ta vavatei katsep nge iou keseung, Kong vinavatei vavakatsep ta kap tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Eiekesen mi mei mene a vavatei katsep nge iou, io, o telekiran va ken vinavatei vavakatsep surie iou a tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Enga bu muomuo sibu Iuda, nga te nga turan kenga sar ka ni tinuturei rakot se Ioanes, ma a nga vavatei katsep ngan mi tuktuk surie Iou. ");
INSERT INTO tbf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","O kap pinat surie ka vinavatei vavakatsep surie iou kuvu simi ka. Eiekesen o oeng veteringa nga ngan ken vinavatei vavakatsep e Ioanes, terengien va nga ta mang suvuon mi vavato. ");
INSERT INTO tbf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","E Ioanes eie mi bember ian ta nga ngang nge rar, ma nga nga res nia mon i pakien ine ken berber ian ta nga mon potaram lili. ");
INSERT INTO tbf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Eiekesen mi vinavatei vavakatsep o ta suvuon a leong rio ken vinavatei vavakatsep e Ioanes, simi vunan ian bu tsientsang e Tamoung ta nga tura iou nia me tsang vuruvan, arie egie gi vavatei katsep nge Iou va e Tamoung a nga tura Iou. ");
INSERT INTO tbf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma e Tamoung ese ta nga tura Iou, arie Eie a nga vavatei katsep nge Iou. Nga kap nga rongomie mi inan nge pare mi matan. ");
INSERT INTO tbf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma nga kap suvuon ken sar nama sibu aronga simi vunan nga kap vodovodon tuktuk seie ian ta nga turan. ");
INSERT INTO tbf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nga ko menise vititirie mi Pakpak Leong simi vunan nga vodon va ian bu nama ta terie senga mi tino rovoriu. Ma arie ine mi Pakpak Leong a vavatei katsep nge Iou. ");
INSERT INTO tbf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Eiekesen nga ngas mereis nia nemei seou nia poro mi tino. ");
INSERT INTO tbf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“O kap lalaro suvuon mi tietienengei kuvu simi kulou. ");
INSERT INTO tbf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eiekesen o telekiran va enga nga kap suvuon rovoriu ka tentoiv rakot se Raban sibu aronga. ");
INSERT INTO tbf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","O te nga ra nemei ngan mi asan e Tamoung ma nga kap nga me resmata iou, eiekesen sien va ka mei va ta nemei ngan mi asan eie kesen, nga ta ba so resmatan. ");
INSERT INTO tbf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sien va nga ta suvuon mi tietienengei kuvu senga kesenga, ma nga kap nesie mi tietienengei ta kuvu se Raban eie mo a kes, vasa nga ta vodovodon tuktuk ven? ");
INSERT INTO tbf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Kian va nga ta vodon va o ta vepitsie nga i matan mi Tam. Eiekesen mi ka ese ta vepitsie nga, arie eie e Moses ese nga tate nga vodon va ta kulie nga. ");
INSERT INTO tbf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sien va nga te nga vodovodon tuktuk se Moses, va nga te nga vodovodon tuktuk seou, simi vunan a nga vavataor surie Iou. ");
INSERT INTO tbf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Eiekesen sien va nga kap vodovodon tuktuk si ken sar vinavataor, vasa nga ta mang vodovodon tuktuk ven si kong sar nama?” ");
INSERT INTO tbf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","I muir sien ne, e Iesu a nga tsourarak rakot simi bienengeiv ka nikot simi barateis i Galili (o, i Tiberias). ");
INSERT INTO tbf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mi bineit leong gi nga vemusurie simi vunan gi nga pare bu totourlekier ni vovokudier ta nga tsana sibu tamat mienarouk. ");
INSERT INTO tbf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Io, e Iesu a nga kien simi pout nge mogos i bingan meie ken sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma mi Nginu Pasova sibu Iuda a te nga vatavatat. ");
INSERT INTO tbf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","E Iesu a nga dedeng veriris ma a nga pare mi bineit leong gi nga nemei seie, io, a nga vosuoreie e Pilipo, “Ivie giet ta voir nginonginou en nian ine mi bineit va gi ta ngou?” ");
INSERT INTO tbf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A nga pevien ne nia konon e Pilipo, sien eie a te nga muna vodon vuturungie misa va ta nga tsana. ");
INSERT INTO tbf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","E Pilipo a nga kuil nama, “Sien va giet ta voir nginonginou ngan ba sinangavur luo koboit (200) bu lakep denari eie ta kap oit segie kokouk ine mi bineit va gi ta tsuokopie magi kavo puk lili!” ");
INSERT INTO tbf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Io, ken madar tovtov mene, e Andre e kasien e Simon Petro, a nga pevien, ");
INSERT INTO tbf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mi madar ine a suvuon bu tsoik bali mi napaririem ma ba ie meses luo. Eiekesen ta kap oit nieng nia vaotie ine mi kulou palan?” ");
INSERT INTO tbf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","E Iesu a nga pevien, “Nga oeng simi bineit va gi ta mogos.” Ian en mi potpotbor a nga palan. Io, gi nga mogos ma mi aesaes kokouk sibu ka mo segie a nga oit bu sinangavur mi napaririem soloba (5,000). ");
INSERT INTO tbf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma e Iesu a nga poro mi tsoik nge vuot kalei se Raban, ma a nga pot terie segie gi ta nga mogos. Ma buer a nga tsana malan mo siba ie meses. Ma egie kokouk gi nga ngou ti. ");
INSERT INTO tbf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sien gi tate nga ngou ti, a nga oeng si ken sar madar tovtov, “Nga por toungan bu kepide nginonginou, terengien va giet ta kap mang tomeke tuvuon nge gie.” ");
INSERT INTO tbf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Io, gi nga tsuok kakakuon ian bu kapekapien ine siba tsoik bali mi napaririem nge vuotie sibu leke mi sinangavur kes ma luo ian gi tate nga ti rivie. ");
INSERT INTO tbf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Io, sien mi kulou gi ta nga pare ine mi totourlekier ni vovokudier ta nga tsana, gi nga pevien, “A tuktuk rovoriu ine arie eie mi Propet ian va ta nemei ine simi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Io, e Iesu a nga telekiran va gi ta nga lalaro votsuoke va ta nga tsorubeit magi kovakova ka leong, io, a buer nga sorvekena gie nge kien simi pout eie kesen. ");
INSERT INTO tbf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma sireivreiv seserigo sien te, ken sar madar tovtov gi nga peuk i koen. ");
INSERT INTO tbf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Gi nga so kesie mi galeu nge tsourarak simi barateis rakot i Kapernaum. Mi ngingi a te nga tsibour eiekesen e Iesu a kap ngas nga vorota gie. ");
INSERT INTO tbf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Samo, mi mour ngeisngeis a nga tsour ma mi barateis a te nga vakaek nge sireir. ");
INSERT INTO tbf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sien gi ta nga vuruos ngan mi galeu rakot malan va mi napaririem o, mi napaririem pouts kes bu kilomita, gi nga pare e Iesu a nga veis i popon mi barateis nge beit vatavatat simi galeu, ma gi nga motou beitsak. ");
INSERT INTO tbf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Eiekesen a nga oeng segie, “Arie eou mo. Kian va nga ta motou.” ");
INSERT INTO tbf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma gi nga res nia kerie nemei i popon mi galeu, ma puk lalapus mi galeu a te nga tsaer simi korot gi ta nga lalaro rakot en. ");
INSERT INTO tbf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Simi ra vemusurie te, ian mi bineit gi ta nga mon simi bienengeiv ka nikot simi barateis ivie mi galeu ta nga tsuk en, gi nga vodonomie va mi galeu kes mo a nga mon en ian, ma gi nga vodonomie buer va e Iesu a kap nga ka meie ken sar madar tovtov, eiekesen ken sar madar tovtov mo gi nga tsuk. ");
INSERT INTO tbf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bu galeu mene kovuni i Tiberias gi nga me tsaer i babaren ian mi korot ivie gi ta nga nganie en mi tsoik i muir sien mi Nguts tate nga vuot kalei ngan. ");
INSERT INTO tbf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Io, sien mi bineit gi ta nga pare va e Iesu ma ken sar madar tovtov gi kap nga mon, gi nga ka ian sibu galeu nge rakot i Kapernaum nia nesie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Io, gi nga tsaer i Kapernaum. Ma sien gi tate nga vorotan e Iesu, gi nga pevien sien, “Vavvasengei, venenges e nemei en ne?” ");
INSERT INTO tbf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","E Iesu a nga kuil nama, “O oeng tuktuk senga. Nga lalaron nia vorota iou surie nga ta nga nganie bu tsoik nge ti, kap va surie nga ta nga pare bu totourlekier ni vovokudier. ");
INSERT INTO tbf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kian va nga ta tsatsang surie mi nginonginou ian ta tsak tuvuon, eiekesen surie mi nginonginou ian ta terie mi tino rovoriu. Ine mi nginonginou, e Natuon mi Ka ta terie senga, simi vunan e Raban mi Tam, a te nga tourtelekiran va eie ta tsana ine mi tsientsang.” ");
INSERT INTO tbf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Io, gi nga vosuoreie, “Misa gei ta ngas tsana va gei ta mang tsana bu tsientsang e Raban ta lalaron va gei ta tsana?” ");
INSERT INTO tbf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","E Iesu a nga kuil nama nge pevien, “Mi tsientsang e Raban ta lalaron va nga ta tsana arie ine. Nga ta vodovodon tuktuk mo seie ian tate nga turan.” ");
INSERT INTO tbf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Io, gi nga pevien, “Mi sana totourlekier ni vovokudier e ta tsana va gei ta mang pare nge vodovodon tuktuk sevoi? Misa e ta tsana? ");
INSERT INTO tbf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bu tubugiet gi nga nganie mi manna simi beir, malan mi Pakpak Leong ta pevien, ‘A nga terie mi tsoik kovuni simi rangit nia nganie.’” ");
INSERT INTO tbf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","E Iesu a nga pevien, “O oeng tuktuk senga. Kap va e Moses eie a nga terie senga mi tsoik kuvu simi rangit, eiekesen e Tamoung arie eie a terie senga mi tsoik tuktuk kuvu simi rangit. ");
INSERT INTO tbf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ian mi tsoik va e Raban ta terie, eie a kuvu simi rangit ma a terie mi tino simi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma gi nga pevien, “Mi Nguts, terie segei ian mi tsoik sibu ra kokouk.” ");
INSERT INTO tbf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Io, e Iesu a nga pevien segie, “Eou mi tsoik ni tino. Eie ese ta nemei seou ta kap ba buer vitor. Ma eie ese ta vodovodon tuktuk seou ta kap ba buer moruo. ");
INSERT INTO tbf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Eiekesen malan o tate nga oeng senga, nga te dengarie iou eiekesen nga kap vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Egie ese e Tamoung ta terie seou gi ta nemei seou. Ma eie ese ta nemei seou, o ta kap ba buer matokeran, ");
INSERT INTO tbf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","simi vunan O nga nemei kuvu simi rangit nia vemusurie ken lalaron Eie ese ta nga tura Iou, kap va nia vemusurie kong lalaron. ");
INSERT INTO tbf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma ine ken lalaron eie ese ta nga tura iou, va o ta kap rivie ka mei segie kokouk tate nga terie seou, eiekesen o ta ngas vatoa gie simi ra vekvekitip. ");
INSERT INTO tbf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mi lalaron se Tamoung a malan ne, eie ese ta dengarie mi Nout nge vodovodon tuktuk sien, ta suvuon mi tino rovoriu ma o ta vatoa simi ra vekvekitip.” ");
INSERT INTO tbf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Io, bu Iuda gi nga vakaek nge nama palan surie Eie, simi vunan a nga pevien, “Eou mi tsoik ian ta nga kuvu simi rangit.” ");
INSERT INTO tbf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma gi nga pevien, “Ine mi ka arie e Iesu e natuon e Iosep, va gerek? Giet telekiran e taman ma e kinan. Ma surie misa ta si pevien va a nga kuvu simi rangit?” ");
INSERT INTO tbf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","E Iesu a nga kuil nama, “Kian va nga ta nama palan i kotubunga kesenga. ");
INSERT INTO tbf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kap ka mei a oit nia nemei seou sien va mi Tam ese ta nga tura iou ta kap kir nemei ngan seou. Ma o ta vatoa simi ra vekvekitip. ");
INSERT INTO tbf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mi Pakpak Leong a pevien ne, ‘E Raban ta veseveie bu mei kokouk.’ Eie ese ta rongomie mi namanien e Tamoung nge por sinavei sien, ta nemei seou. ");
INSERT INTO tbf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kap ka mei a te nga pare mi Tam, eiekesen eie mo ese ta nga kuvu se Raban arie eie a nga pare mi Tam. ");
INSERT INTO tbf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","O oeng tuktuk senga. Eie ese ta vodovodon tuktuk tate suvuon mi tino rovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eou mi tsoik ni tino. ");
INSERT INTO tbf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bu tubunga gi nga nganie mi manna simi beir, eiekesen gi nga maet. ");
INSERT INTO tbf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eiekesen ine arie mi tsoik ta nga kuvu simi rangit. Ma eie ese ta nganie, ta kap maet. ");
INSERT INTO tbf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eou mi tsoik ta tino ian ta nga kuvu simi rangit. Sien va ka mei ta nganie ine mi tsoik, ta tino rovoriu. Ma ine mi tsoik eie mi pientsiung ian o ta terie va mi mangmagoso enaenamon ta mang suvu tino.” ");
INSERT INTO tbf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Io, bu Iuda gi te nga vevengeis nge nama i kotubugie kesegie. “Ine mi ka, vasa ta terie ven mi pientsien va giet ta nganie?” ");
INSERT INTO tbf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","E Iesu a nga kuil nama, “O oeng tuktuk senga. sien va nga ta kap nganie mi pientsien e Natuon mi Ka nge unumie mi daran, nga ta kap suvuon mi tino i aronga. ");
INSERT INTO tbf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Eie ese ta nganie mi Pientsiung nge unumie mi Daroung a suvuon mi tino rovoriu ma o ta vatoa simi ra vekvekitip. ");
INSERT INTO tbf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Surie mi Pientsiung eie mi nginonginou tuktuk, ma mi Daroung eie mi kepineits tuktuk nia un. ");
INSERT INTO tbf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Eie ese ta nganie mi Pientsiung nge unumie mi Daroung, a tino seou ma eou o tino seie. ");
INSERT INTO tbf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","E Tamoung ese ta tino, a nga tura iou. Ma O tino simi vunan mi Tam a terie mi tino seou. Io, eie ese ta nganie iou, ta tino buer simi vunan o terie mi tino seie. ");
INSERT INTO tbf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ine arie eie mi tsoik ta nga kuvu simi rangit, a kap nga malan mi manna ian bu tubunga gi ta nga nganie, eiekesen gi nga maet. Eie ese ta nganie ine mi tsoik, ta tino rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E Iesu a nga vuotongie ine mi nama sien ta nga vavasengei i aron mi vona rengeir sibu Iuda i Kapernaum. ");
INSERT INTO tbf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Palan ken sar madar tovtov gi nga rongomie ine nge pevien, “Ine mi vinasengei a ngeisngeis beitsak. Ese a oit nia katsep sien?” ");
INSERT INTO tbf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","E Iesu a te nga telekiran va gi te nga nama palan surie ine, ma a nga pevien segie, “Vasa, ine bu nama a me vokorongie kenga sar vienviendon? ");
INSERT INTO tbf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sien va nga ta pare e Natuon mi Ka ta kien simi korot ta nga kuvu en vourvour, vasa nga ta ven? ");
INSERT INTO tbf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mi Moromoruo Tamat a ko terie mi tino. Mi ngesengesien mi ka a tuvuon rovoriu. Ine bu nama o ta vokokotie senga, a kuvu simi Moromoruo ian ta terie mi tino. ");
INSERT INTO tbf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Eiekesen kavo mei senga gi kap vodovodon tuktuk.” E Iesu a nga vakokoit malan ine simi vunan a te nga muna telekiran ese segie gi kap nga vodovodon tuktuk, ma ese va ta nga roev terie. ");
INSERT INTO tbf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma a nga pevien, “Ine arie mi vunan, o nga pengan senga va kap ka mei ta oit nia nemei seou sien va mi Tam ta kap tor ngan.” ");
INSERT INTO tbf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Surie ine mi vunan, palan ken sar madar tovtov e Iesu gi nga muer sorvekenan ma gi kap nga nomeie ba buer. ");
INSERT INTO tbf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Io, e Iesu a nga vosuoreie mi sinangavur kes ma luo bu madar tovtov, “Ma enga buer nga te lalaro sorvekena iou?” ");
INSERT INTO tbf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","E Simon Petro a nga kuil nama sien, “Mi Nguts! Gei ta ba rakot se ese? Evoi e suvuon bu nama simi tino rovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gei vodovodon tuktuk nge telekiran va evoi ken Ka Tamat e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","E Iesu a nga kuil nama, “Vasa, o kap nga vile nga, mi sinangavur kes ma luo? Eiekesen mi mei kes senga eie mi moromoruo tsak!” ");
INSERT INTO tbf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(A nga vakokoit surie e Iudas e natuon e Simon Iskariot, surie eie mi meinmenien mi sinangavur kes ma luo bu madar tovtov, ma eie va ta ba nga roev terie e Iesu.) ");
INSERT INTO tbf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","I muir sien ne, e Iesu a nga veis veriris i Galili, ma a kap nga lalaro veis ka i Iudea simi vunan bu Iuda gi nga rorois nia kenvamate. ");
INSERT INTO tbf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Eiekesen sien mi Nginou nia barabaramatan bu Papael sibu Iuda tate nga beit vatavatat, ");
INSERT INTO tbf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","bu kasien gi nga oeng sien, “Veis sorvekenan ine mi korot nge rakot i Iudea, terengien ke sar madar tovtov gi ta mang pare bu kepineits ni vovokudier e ta tsana. ");
INSERT INTO tbf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kap ka mei a ko tsang muningan bu kepineits sien va ta lalaron va bu mei kokouk gi ta telekiran misa ta tsana. Sien va e ta oit nia tsana ine bu kepineits, vasanga no kese simi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Misasien egie bu kasien, gi kap nga vodovodon tuktuk sien buer. ");
INSERT INTO tbf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Io, e Iesu a nga oeng segie, “Kong keipkepide ra a kap ngas beit, eiekesen senga, bu suasua keipkepide ra a kalei mo. ");
INSERT INTO tbf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mi mangmagoso enaenamon a kap oit nia karto nga, eiekesen a karto iou simi vunan o vavatei katsep ngan va mi sana ta tsana a tsokor. ");
INSERT INTO tbf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nga ta rakot simi nginou. Eiekesen eou o kap ngas oit nia rakot simi nginou, simi vunan kong keipkepide ra a kap ngas beit oit.” ");
INSERT INTO tbf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A nga vokokotie ine bu nama, ma a nga mon i Galili. ");
INSERT INTO tbf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","I murien bu kasien gi tate nga rakot simi nginou, eie buer a nga veis, kap va i matan bu mei, eiekesen a nga veis mumuningei mo. ");
INSERT INTO tbf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Io, simi nginou, bu Iuda gi nga vor ve dendeng nge virevirei ngan, “Iva ngan ian mi ka?” ");
INSERT INTO tbf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","I kotubuon mi bineit gi nga vor ve virevirei menemenen surie. Bu mei mene gi nga pevien, “Eie mi banga ka.” Ma bu mei mene gi nga pevien, “A kap, a mono bitie mi kulou.” ");
INSERT INTO tbf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Eiekesen kap ka mei a nga vokokotie ka nama surie eie i matan mi lobaram simi vunan gi nga motovan bu muomuo sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Simi ra i kotubuon mi nginou, e Iesu a nangba nga rakot i mararan mi Vona rengeir leong ma a nga vakaek nge vavasengei. ");
INSERT INTO tbf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bu Iuda gi nga kudier nge virei, “Ine mi ka vasa a nga suvu venengan ine mi suada sinavei, sien a kap nga mon si ka vinasengei?” ");
INSERT INTO tbf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","E Iesu a nga kuil nama, “Kong vinasengei kap va seou keseung, eiekesen a kovuni seie ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sien va ka mei ta res nia tsang vemusurie ken lalaron e Raban, eie ta ba telekiran va kong vinasengei a kovuni se Raban o, a kovuni seou keseung. ");
INSERT INTO tbf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Egie ese gi ta vokokotie bu namanigie kesegie, gi tsana nia suvuon mi tietienengei segie kesegie. Eiekesen Eie ese ta tsatsang nia tienengan mi Mei ese ta nga turan, Eie mi tuktuk ma a kap ka binit a mon seie. ");
INSERT INTO tbf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","E Moses a nga terie senga mi vinuor, va gerek? Eiekesen kap ka mei senga a vemusurie. Surie misa nga ta lalaro kenvamate iou?” ");
INSERT INTO tbf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mi bineit gi nga kuil nama, “Mi tsaka moromoruo a tsegerie no. Ese a lalaro kenvamate no?” ");
INSERT INTO tbf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","E Iesu a nga kuil nama segie, “O nga tsana mi kepineits ni vovokudier kes, ma enga kokouk nga te kudier beitsak. ");
INSERT INTO tbf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","E Moses a nga terie mi vinuor senga va nga ta ngas vavaroup. (Si man tuktuk a kap nga kovuni se Moses, eiekesen simi tubunga.) Io, arie mi vunan nga ko varapuo bu natu madar simi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Io, misasien simi Rangi Minaes, nga ta ngas varapuo ka natu madar terengien va nga ta kap mang pop vuturungie mi Vinuor se Moses. Ma surie misa nga ta petseir veie iou va o vatoa vuruvan ine mi ka simi Rangi Minaes? ");
INSERT INTO tbf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kian va nga ta vuortie ka mei vemusurie ken baidendeng, eiekesen nga ta ngas vuortie vemusurie misa ta tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Io, bu mei mene kovuni i Ierusalem gituo nga virei, “Vasa, a kap va arie mi ka gi ta lalaro kenvamate? ");
INSERT INTO tbf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pare, a vakokoit i matan mi lobaram eiekesen gi kap vokokotie ka nama sien. Tavakier bu muomuo gi te katsep va eie mi Messia nieng? ");
INSERT INTO tbf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Eiekesen giet telekiran va ine mi ka a kovuni ivie. Eiekesen sien va mi Messia ta nemei, kap ka mei ta telekiran va eie a kovuni ivie.” ");
INSERT INTO tbf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","E Iesu a ngas nga vavasengei i mararan mi Vona rengeir leong, samo a nga koup pevien, “Io, nga telekira iou, ma nga telekiran va Eou kovuni ivie. O kap mon en ne surie kong lalaron. Eiekesen eie ese ta tura iou, eie a tuktuk. Nga kap telekiran, ");
INSERT INTO tbf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","eiekesen o telekiran simi vunan Eou o kovuni seie ma eie a nga tura Iou.” ");
INSERT INTO tbf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sien ta nga pevien ne, gi nga lalaro rakopie. Eiekesen kap ka mei a nga konon nia rakopie, simi vunan ken keipkepide ra a kap ngas nga beit. ");
INSERT INTO tbf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Eiekesen palan mi kulou simi bineit gi nga vodovodon tuktuk sien nge pevien, “Sien va mi Messia va ta beit, ta kap oit nia tsana kavo totourlekier ni vovokudier palan rio ine mi ka, nge?” ");
INSERT INTO tbf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bu Parisaio gi nga rongomie mi bineit gi ta nga vevemisir ngan ine bu kepineits surie e Iesu. Samo bu prist leong ma bu Parisaio gi nga turan mi kulou nennei simi Vona rengeir leong nia ra rakopie. ");
INSERT INTO tbf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","E Iesu a nga pevien, “O ta kap mon potaram meie nga ma samo o ta muerengei rakot se ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nga ta nesie iou eiekesen nga ta kap so vorota iou, ma ivie va o ta mon en, nga ta kap oit nia nemei en.” ");
INSERT INTO tbf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bu muomuo sibu Iuda gi nga veveoeng i kotubugie, “Ivie ine mi ka a vodon nia rakot en va giet ta kap oit nia vorotan? Tavakier nieng eie ta rakot sibu taon sibu Grik ivie kegiet sar kulou gi ta mon en nge ra vavasengei sibu Grik? ");
INSERT INTO tbf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A pevien, ‘Nga ta nesie iou eiekesen nga ta kap vorota iou, ma ivie o ta mon en, nga ta kap oit nia nemei en.’ Misa man vuevue ine ken nama?” ");
INSERT INTO tbf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Simi ra vekvekitip, eie mi ra leong ine simi nginou, e Iesu a nga tamtuir nge koup pevien, “Sien va ka mei a moruo eie ta ngas nemei seou. ");
INSERT INTO tbf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Io, eie ese va ta vodovodon tuktuk seou ta ngas me un simi vunan mi Pakpak Leong a pevien, ‘Bu kakada simi da nian mi tino ta so rovotsour kovuni i aron.’” ");
INSERT INTO tbf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E Iesu a nga vokokotie ine mi nama surie mi Moromoruo Tamat, ian egie ese gi ta nga vodovodon tuktuk sien va gi ta ba nga so suvuon. Tuir oit ian simi ra e Raban a kap ngas nga terie mi Moromoruo Tamat simi vunan e Iesu a kap ngas nga suvuon man matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sien mi kulou mene gi ta nga rongomie ine ken nama, gi nga pevien, “A tuktuk, ine mi ka eie mi Propet.” ");
INSERT INTO tbf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bu mei mene gi nga pevien, “Eie mi Messia.” Eiekesen bu mei mene ngas buer gi nga pevien, “Mi Messia ta kap oit nia kovuni i Galili, va gerek? ");
INSERT INTO tbf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Vasa, mi Pakpak Leong a kap pevien va mi Messia ta tubunien e Davit ma ta kuvu i Betilem simi taon ivie e Davit ta nga mon en?” ");
INSERT INTO tbf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Io, mi vinekopot a nga mon i kotubugie surie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bu mei mene gi nga lalaro rakopie, eiekesen kap ka mei a nga rakopie. ");
INSERT INTO tbf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sien mi kulou nennei simi Vona rengeir leong gi ta nga muerengei, bu prist leong ma bu Parisaio gi nga vosuoreie gie, “Surie misa nga ta kap kerie nemei ngan?” ");
INSERT INTO tbf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mi kulou nennei gi nga kuil nama, “Kap ngas ka mei a nga vakokoit malan ine mi ka ta vakokoit.” ");
INSERT INTO tbf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bu Parisaio gi nga oeng balapoik, “Vasa, a te bitie nga buer? ");
INSERT INTO tbf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Vasa, ka mei segei bu muomuo ni vuor o, bu Parisaio a vodovodon tuktuk sien, nge? ");
INSERT INTO tbf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ine mi bineit gi kap katsep si ka puk sibu vinuor se Moses, io, gi mon i pakien ken sinubirei e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","E Nikodemo, ese ta be nga muna rakot se Iesu ma eie mi meinmenigie bu Parisaio, a nga virei, ");
INSERT INTO tbf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kegiet vinuor a kap sunurie nia votorosie ka mei sien va giet ta kap ngas muna rongomie misa ta nga tsana, va gerek?” ");
INSERT INTO tbf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Gi nga kuil nama, “Arie evoi buer kovuni i Galili, nge? Menisan mi Pakpak Leong nge vorotan va kap ka propet ta kovuni i Galili.” ");
INSERT INTO tbf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ma gi nga muerengei rakot si kegi sar vonuo. ");
INSERT INTO tbf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Io, gi nga muerengei, eiekesen e Iesu a nga rakot simi Pout i Oliv. ");
INSERT INTO tbf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tsourvovo, a te buer nga vo beit simi Vona rengeir leong. Ma mi kulou kokouk gi nga me viririsie. Ma a nga mogos ma a nga tsuok vakaek nge vavasengei segie. ");
INSERT INTO tbf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma bu vavvasengei simi vinuor ma bu Parisaio gi nga kerie nemei ngan mi vevien ese gi ta nga rakopie sien ta nga tsana mi sinavei nia rei puer. Ma gi nga voturie i matan mi lobaram. ");
INSERT INTO tbf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma gi nga oeng se Iesu, “Vavvasengei, ine mi vevien gi te rakopie simi keipkepide ra ta nga tsana mi sinavei nia rei puer. ");
INSERT INTO tbf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Simi vinuor se Moses a nga oeng ngeisngeis va giet ta toem vamate bu suada vevien malan ine. Ma evoi, vasa ke vienviendon?” ");
INSERT INTO tbf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gi nga vakokoit ven ne nia ruom tsang nama se Iesu va gi ta mang vepitsie ngan ka kepineits. Eiekesen e Iesu a nga tsologout nge vavataor ngan mi pitsipitsiriman simi kaber. ");
INSERT INTO tbf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sien gi ta ngas nga tsue va ta nga kulie ka nama, a nga tsuok tamtuir ma a nga pevien segie, “Sien va ka mei senga a ketseketseng simi sinavei tsokor, eie ta muna tome ngan ka vout ine mi vevien.” ");
INSERT INTO tbf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ma a te buer nga tsologout nge vavataor simi kaber. ");
INSERT INTO tbf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sien gi ta nga rongomie ine, gi nga veis pats vo kes, vakaek sibu komois, tuir oit e Iesu kesen mo a te nga mon meie mi vevien ta ngas nga tuir ian en. ");
INSERT INTO tbf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","E Iesu a nga tsuok tamtuir nge vereie mi vevien, “Vevien, ivanga gie te? Ka mei segie a votorosie no?” ");
INSERT INTO tbf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ine mi vevien a nga kuil nama, “Ka leong, a kap ka mei.” Io, e Iesu a nga pevien, “Eou buer o ta kap votorosie no. Veis. Ma kian va e ta tsana te buer ka sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Io, e Iesu a nga vakokoit te buer sibu Parisaio, “Eou man Berber mi mangmagoso enaenamon. Eie ese ta vemusurie iou, ta kap veis simi ngingi eiekesen ta suvuon man Berber mi Tino.” ");
INSERT INTO tbf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bu Parisaio gi nga pevien sien, “E vavatei katsep ngan evoi kese. Ke vinavatei vavakatsep a kap tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","E Iesu a nga kuil nama, “Misasien o ta vavatei katsep ngan eou keseung, kong vinavatei vavakatsep a tuktuk simi vunan o telekiran ivie o nga kuvu en ma ivie o ta rakot en. Eiekesen enga nga kap telekiran ivie o nga kuvu en, ma ivie o ta rakot en. ");
INSERT INTO tbf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nga ko vuortie iou ngan mi sinavei simi kaber, eiekesen eou o kap vuortie ka mei. ");
INSERT INTO tbf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Eiekesen sien va o ta vuor, kong sinavei nia vuor a tuktuk simi vunan a kap va eou mo o vuor, eiekesen o vuor meie mi Tam ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Gi nga vataro si kenga vinuor buer va sien va ka ba mei luo guor ta vavatei katsep ngan mi nama kes, keguor vinavatei vavakatsep a tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eou o vavatei katsep ngan eou keseung, ma mi Tam ese ta nga tura iou a vavatei katsep nge iou.” ");
INSERT INTO tbf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Io, gi nga virei, “Iva ngan e tama?” E Iesu a nga kuil nama, “Nga kap telekira iou ma e Tamoung. Sien va nga nga telekira iou, va nga telekiran buer e Tamoung.” ");
INSERT INTO tbf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","E Iesu a nga vokokotie ine bu nama sien ta ngas nga vavasengei i babaren mi korot teteir lakep i aron mi Vona rengeir leong. Eiekesen kap ka mei a nga rakopie simi vunan ken keipkepide ra a kap ngas nga beit. ");
INSERT INTO tbf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma e Iesu a te buer nga pevien segie, “O ta veis sorvekena nga ma nga ta nesie iou ma nga ta maet meie ngan kenga sar sinavei tsokor. Ivie o ta rakot en, nga ta kap oit nia rakot en.” ");
INSERT INTO tbf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma bu Iuda gi nga pevien, “Vasa, eie ta kenvamate eie kesen? Arie mi vunan nieng a pevien va giet ta kap oit nia rakot ivie ta rakot en?” ");
INSERT INTO tbf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","E Iesu a nga pevien segie, “Enga nga kovuni i keim ma eou o kovuni die i kur. Enga mi kuoluon mi kaber, eiekesen eou kap. ");
INSERT INTO tbf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Arie mi vunan o ta pevien senga va nga ta maet meie ngan kenga sar sinavei tsokor. Simi vunan sien va nga ta kap vodovodon tuktuk va eou arie Eie, nga ta maet meie ngan kenga sar sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Io, gi nga vereie, “Evoi ese?” E Iesu a nga kuil nama, “Eou eie ese o ta nga pengan senga vakaek simi tsuoktsuok vakaek. ");
INSERT INTO tbf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","O suvuon palan bu kepineits nia vakokoit surie nga ma nia oeng subira nga. Eiekesen Eie ese ta nga tura iou a tuktuk ma misa o ta rongomie seie, o vokokotie simi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Gi kap nga telekiran va e Iesu a nga vokokotie mi Tam segie. ");
INSERT INTO tbf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Io, e Iesu a nga oeng segie, “Simi ra va nga tate tsuok terie i kur e Natuon mi Ka simi koitskoits, nga ta telekiran va eou arie Eie. Ma nga ta telekiran va o kap tsana ka kepineits vemusurie kong lalaron, eiekesen o vokokotie mo misa e Tamoung ta nga veseveie iou ngan. ");
INSERT INTO tbf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma eie ese ta nga tura iou, a mon meie iou. A kap nga tsupuk rivie iou, simi vunan o ko munu tsana misa ta varese Eie.” ");
INSERT INTO tbf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Palan bu mei gi ta nga rongomie ine bu kepineits, gi nga vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Io, e Iesu a nga oeng segie bu Iuda gi ta nga vodovodon tuktuk seie, “Sien va nga ta por vangvangasie mi namaniung, enga kong sar madar tovtov tuktuk, ");
INSERT INTO tbf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ma nga ta telekiran mi tuktuk, ma mi tuktuk ta vara ketseketseng nge nga.” ");
INSERT INTO tbf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gi nga kuil nama, “Egei bu tubuon e Abaraam ma gei kap ngas petspets si ka mei. Vasa e si pevien va gei ta ba ketseketseng?” ");
INSERT INTO tbf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","E Iesu a nga kuil nama segie, “O oeng tuktuk senga. Eie ese ta tsana mi sinavei tsokor, eie a petspets simi sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mi petspets a kap oit va ta ba tsorubeit mi meinmenien ken tietie man ka leong. Eiekesen mi nout ta mon mi meinmenien ken tietie sibu ra bu ra. ");
INSERT INTO tbf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Io, sien va mi Nout ta vara ketseketseng nge nga, nga ta ketseketseng tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","O telekiran va enga bu tubuon e Abaraam. Eiekesen nga lalaron nia kenvamate iou, simi vunan kap man ka korot mi namaniung sibu aronga. ");
INSERT INTO tbf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","O vokokotie misa e Tamoung ta nga vasangan seou. Eiekesen enga nga tsana misa nga ta nga rongomie se tamanga.” ");
INSERT INTO tbf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ma gi nga kuil nama sien, “E Abaraam eie e tamagei.” E Iesu a nga pevien segie, “Sien va enga bu natuon e Abaraam, nga ta tsana misa eie ta nga ko tsana. ");
INSERT INTO tbf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eiekesen ine, nga lalaro kenvamate iou, misasien o te vokokotie mi tuktuk ian o ta nga rongomie se Raban. E Abaraam a kap nga tsana ka sinavei malan ine. ");
INSERT INTO tbf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nga ko tsana misa e tamanga ta ko tsana.” Ma gi nga kuil nama, “A kap va egei bu natu tenei. E Raban ngas arie eie e tamagei.” ");
INSERT INTO tbf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","E Iesu a nga oeng segie, “Sien va e Raban eie e tamanga, va nga nga lalaro iou, simi vunan o nga nemei senga kovuni se Raban ma ine o mon ine. O kap nga nemei vemusurie kong lalaron keseung, eiekesen e Raban a nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Surie misa nga ta kap katsep simi sa o ta vokokotie? Simi vunan nga kap oit nia rongomie mi namaniung. ");
INSERT INTO tbf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Enga se tamanga, mi kovan bu moromoruo tsak, ma nga ko lalaro vemusurie ken lalaron e tamanga. Vakaek simi tsuoktsuok vakaek eie mi ka kenken ma a kap nga ko mon simi bienengeiv simi tuktuk, simi vunan kap ka tuktuk a mon seie. Sien ta vokokotie ka binit, a tsana ine vemusurie mi sinavien, simi vunan eie mi ka bitbit ma e taman bu binit kokouk. ");
INSERT INTO tbf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eiekesen, o vokokotie mi tuktuk. Arie mi vunan nga kap vodovodon tuktuk seou! ");
INSERT INTO tbf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ese senga a oit nia vara tuktuk nge iou va o suvu sinavei tsak? Sien va o vokokotie mi tuktuk, surie misa nga ta kap vodovodon tuktuk seou? ");
INSERT INTO tbf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Eie ese se Raban, a rorong si ken sar nama e Raban. Ma enga nga kap rorong sien, simi vunan enga a kap va enga se Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bu Iuda gi nga kuil nama nge oeng sien, “Vasa, a kap duis va gei ta pevien va evoi mi kangi Samaria ma mi tsaka moromoruo a te tsegerie no?” ");
INSERT INTO tbf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","E Iesu a nga kuil nama, “O kap suvuon ka tsaka moromoruo. Eiekesen o mangaran e Tamoung, ma enga nga mugumitsa iou. ");
INSERT INTO tbf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","O kap nesie ka kepineits nia tienenge iou keseung. Eiekesen mi Ka ese ta nesie ine mi tietienengei a mon. Ma eie ta vuor. ");
INSERT INTO tbf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","O oeng tuktuk senga. Eie ese ta vemusurie mi namaniung ta kap ba maet.” ");
INSERT INTO tbf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma bu Iuda gi nga oeng sien, “Ine gei te telekiran va e suvuon mi tsaka moromoruo! E Abaraam a te nga maet, ma bu propet buer. Eiekesen evoi e pevien va sien va ka mei ta vemusurie mi namani, eie ta kap ba maet. ");
INSERT INTO tbf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nge kia va evoi e tsiroup rio e Abaraam e tamagei ese ta nga maet? Ma bu propet buer gi te nga maet. Nge kia va evoi ese?” ");
INSERT INTO tbf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","E Iesu a nga kuil nama, “Sien va o ta tienenge iou keseung, mong matvinavaso eie mi kepineits tuvuon. E Tamoung ese nga ta ko pevien va manga Raban, a tienenge iou. ");
INSERT INTO tbf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nga kap ngas telekiran, eiekesen eou mo o telekiran. Sien va o ta pevien va o kap telekiran, o ta tsorubeit mi ka bitbit mala nga. Eiekesen o telekiran Eie nge vemusurie mi Namanien. ");
INSERT INTO tbf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","E tamanga e Abaraam a nga res sien ta nga vodon va ta nga dengarie kong rangi bineit. A nga dengarie ma a nga res.” ");
INSERT INTO tbf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Io, bu Iuda gi nga oeng sien, “A kap ngas sinangavur napaririem ke sar avareit ma e te nga pare e Abaraam?” ");
INSERT INTO tbf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","E Iesu a nga kuil nama, “O oeng tuktuk senga. I muan gi ta nga kava e Abaraam, Eou o mon!” ");
INSERT INTO tbf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Io, gi nga tsuok vout nia tomerie, eiekesen e Iesu a nga ku menen nge sorvekenan mi Vona rengeir leong. ");
INSERT INTO tbf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sien e Iesu tate nga vor ve veisveis, a nga pare mi ka ta nga kael ngas te sien gi ta nga kava. ");
INSERT INTO tbf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ken sar madar tovtov gi nga vereie, “Vavvasengei, se ese ken sinavei tsokor va ine mi ka ta nga kael ngas te si ken kienakav? Ken sinavei tsokor eie kesen o, keguor sinavei tsokor e kinan ma e taman?” ");
INSERT INTO tbf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","E Iesu a nga kuil nama, “A kap va a vunan simi sinavei tsokor se kinan o, se taman o, seie kesen. Eiekesen ine a nga tsorubeit, terengien va ken tsientsang e Raban ta mang so tsorubeit vasvas seie. ");
INSERT INTO tbf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Giet ta ngas tsana ken tsientsang eie ese ta nga tura iou sien ta ngas sisiat. Mi kati ta ra nemei va ka mei ta kap ba oit nia tsatsang. ");
INSERT INTO tbf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sien o ta ngas mon simi mangmagoso enaenamon, eou man Berber mi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","I muir sien ta nga vokokotie ine, e Iesu a nga kinouts simi pier ma a nga lakie mi kinouts meie ngan mi pier, ma a nga poro nge mirie ngan ba katsomatan ine mi kael. ");
INSERT INTO tbf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma a nga oeng sien, “Veis nge ra suruvie ba katsomata simi matada i Siloam (Man vuevue ine mi as, va ‘Turan’).” Io, ine mi kael a nga ra suruvie ba katsomatan ma a nga oit nia dedeng nge muerengei. ");
INSERT INTO tbf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bu palapalan ma mi kulou gi ta nga ko dengarie muomuo ta nga ko vor nono kepineits, gi nga virei, “Ine kap va arie eie mo mi ka ta nga ko mogos nge vor nono kepineits?” ");
INSERT INTO tbf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bu mei mene gi nga pevien, “Arie eie mo.” Eiekesen bu mei mene gi nga pevien, “A kap, kap va eie. A mat malan mo ian mi kael.” Eiekesen ine mi ka ta be nga kael a nga tsue nge pevien, “Arie eou be mo ian mi ka.” ");
INSERT INTO tbf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma gi nga vereie, “Vasa e ven ine, ma e nangba dedeng?” ");
INSERT INTO tbf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A nga kuil nama segie, “Mi ka mi asan e Iesu a nga lakie mi pier meie mi kientsuon nge mirie ngan ba katsomatoung ma a nga tura iou nia ra suruvie simi matada i Siloam. Io, o nga ra suruvie ma o nangba nga oit nia dedeng.” ");
INSERT INTO tbf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Gi nga vereie, “Ivangan eie?” Ma a nga kuil nama, “O kap telekiran.” ");
INSERT INTO tbf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ma gi nga kerie ine mi ka ta be nga kael muomuo rakot sibu Parisaio. ");
INSERT INTO tbf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mi ra e Iesu ta nga tsana ine mi pier nge vakalaie ine mi kael arie mi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma bu Parisaio gi nga vereie te buer vasa a nangba nga oit nia dedeng ven. Ma a nga oeng segie, “A nga poro bu pier nge terie siba katsomatoung ma o nga ra suruvie ma ine o nangba oit nia dedeng.” ");
INSERT INTO tbf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Io, bu mei mene segie bu Parisaio, gi nga pevien, “Mi ka ine, kap va eie kuvu se Raban simi vunan a kap mangaran man vinuor mi Rangi Minaes.” Eiekesen bu mei mene segie gi nga pevien, “Vasa ta ven va ka mei tsokor ta tsana bu suada totourlekier ni vovokudier malan ine?” Samo mi vinekopot a nga mon i kotubugie. ");
INSERT INTO tbf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma bu Parisaio gi te buer nga vereie ine mi kael, “Vasa e ta pevien ngan ine mi ka sien a tsang vakalaie ba katsomata?” Ma a nga kuil nama, “Eie mi propet.” ");
INSERT INTO tbf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bu muomuo sibu Iuda gi kap ngas nga vodovodon tuktuk va ine mi ka ta nga kael muomuo ma ine a te oit nia dedeng, tuir oit gi nga kukuo e kinan meie e taman, ");
INSERT INTO tbf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ma gi nga vereie guor, “Ine arie e natungado? Ngado pevien va a nga kael ngas te si ken kienakav. Ma vasa a ven ine a te dedeng?” ");
INSERT INTO tbf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Io, e taman meie e kinan guor nga kuil nama, “Gor telekiran va eie e natugor. Ma gor telekiran va e kinan ta nga kava a te nga kael. ");
INSERT INTO tbf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Eiekesen gor kap telekiran vasa a ven ma ine a te oit nia dedeng. Ma gor kap telekiran va ese a tsang vakalaie ine ba katsomatan. Nga ta vereie eie. A te leong oit, ma a oit nia kuil nama eie kesen!” ");
INSERT INTO tbf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","E kinan meie e taman guor nga pevien ne simi vunan guor nga motovan bu muomuo sibu Iuda. Gi te nga kubutsie mi nama nge sunurie va eie ese ta vakokoit katsep ngan va e Iesu eie mi Messia, gi ta matokeran si kegi vona rengeir. ");
INSERT INTO tbf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Arie mi vunan e taman meie e kinan guor nga vakokoit ven ne, “A te komois oit. Nga vereie.” ");
INSERT INTO tbf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mi keipkepide ra ta vuluo ngan gi nga kukuo ine mi ka ta be nga kael muomuo nge oeng sien, “Pengan mi tuktuk i matan e Raban. Gei telekiran va ine mi ka eie mi ka tsokor.” ");
INSERT INTO tbf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ine mi ka a nga kuil nama, “O kap telekiran va eie mi ka tsokor o, kap. Mi kepineits kes mo o telekiran, muomuo o nga kael, eiekesen ine o te dedeng!” ");
INSERT INTO tbf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Io, gi nga vereie, “Mi sana ven a te tsana sevoi? Vasa a tsang vakalaie venengan ba katsomata?” ");
INSERT INTO tbf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A nga kuil nama, “O te muna pengan senga. Ma nga kap rorong. Surie misa nga ta lalaro rongomie te buer? Tavakier enga buer nga lalaro tsorubeit ken sar madar tovtov, nge?” ");
INSERT INTO tbf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma gi nga oeng vatsakatie nge pevien, “Arie evoi ken madar tovtov! Eiekesen egei ken sar madar tovtov e Moses! ");
INSERT INTO tbf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gei telekiran va e Raban a nga vakokoit se Moses, eiekesen gei kap telekiran ivie ine mi ka a kuvu en!” ");
INSERT INTO tbf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma ine mi ka a nga kuil nama, “Ine mi kepineits a kekineits. Nga kap telekiran ivie a kuvu en, eiekesen a tsang vakalaie ba katsomatoung! ");
INSERT INTO tbf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Giet telekiran va e Raban a kap ko rorong si ka mei tsokor. A ko rorong mo sibu mei gi ta mangaran nge tsana misa ta lalaron va gi ta tsana. ");
INSERT INTO tbf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Vakaek si man tsuoktsuok vakaek ine mi mangmagoso enaenamon, kap ka mei giet nga rongomie va a nga tsang vakalaie ka kael ta nga kael ngas te sien gi ta nga kava. ");
INSERT INTO tbf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sien va e Raban a kap nga turan ine mi ka, va a kap oit nia tsana ka kepineits.” ");
INSERT INTO tbf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Gi nga kuil nama sien, “Gi nga kava no simi sinavei tsokor. Ma e lalaro vavasengei segei?” Io, gi nga matokeran simi vona rengeir. ");
INSERT INTO tbf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sien e Iesu ta nga rongomie va gi nga kareir vorotsoruo ine mi ka, a nga vorotan nge vereie, “E vodovodon tuktuk se Natuon mi Ka?” ");
INSERT INTO tbf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma ine mi ka a nga kuil nama, “Mi Nguts. Eie ese? Pengan seou, terengien o ta mang vodovodon tuktuk sien.” ");
INSERT INTO tbf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","E Iesu a nga oeng sien, “E te pare, ma arie eie ine, e te vakokoit meie.” ");
INSERT INTO tbf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma ine mi ka a nga pevien, “Mi Nguts, o vodovodon tuktuk!” Ma a nga rangarie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","E Iesu a nga pevien, “O nga nemei ine simi mangmagoso enaenamon nia vuor, terengien va egie ese gi ta kael, gi ta mang dedeng, ma egie ese gi ta dedeng, gi ta mang kael.” ");
INSERT INTO tbf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma bu Parisaio gi ta nga mon meie guor, gi nga rongomie ine ma gi nga vereie, “Vasa, egei buer gei kael?” ");
INSERT INTO tbf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","E Iesu a nga kuil nama, “Sien va nga nga kael, va nga kap suvu sinavei tsokor. Eiekesen sien nga pevien, ‘Gei oit nia dedeng,’ kenga sar sinavei tsokor a ngas mon meie nga.” ");
INSERT INTO tbf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","E Iesu a te buer nga pevien, “O oeng tuktuk senga, eie ese ta kap rubukien ka simi rumrubukien simi oiroir sibu sipsip eiekesen ta derak kitip nge rubukien, eie mi ka puerpuer ma mi ka kenken. ");
INSERT INTO tbf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Eiekesen eie ese ta rubukien ka simi rumrubukien, eie mi ka nennei sipsip. ");
INSERT INTO tbf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Io, mi ka nennei simi rumrubukien ta tsitsivaran mi ka nennei sipsip, ma bu sipsip gi rong kielala mi inan. Eie a ko vuotongie bu asagie bu sipsip keskes, ma a ko muonge gie rovotsour i marar. ");
INSERT INTO tbf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sien va ta kir terie ken sar sipsip kokouk i marar, ta veis muonge gie. Ma bu sipsip gi vemusurie simi vunan gi telekiran mi inan. ");
INSERT INTO tbf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Eiekesen gi ta kap vemusurie ka mat tso. Sien va ka mat tso va ta kukuo gie, bu sipsip gi ta vi ngan, simi vunan gi kap telekiran mi inan mi mat tso.” ");
INSERT INTO tbf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","E Iesu a nga vokokotie ine mi nama puppuo segie, eiekesen gi kap nga telekiran mi vunan ine mi nama ta nga vokokotie segie. ");
INSERT INTO tbf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Io, e Iesu a nga oeng te buer segie, “O oeng tuktuk senga, eou mi rumrubukien nian bu sipsip. ");
INSERT INTO tbf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Egie kokouk ese gi ta muo seou, egie bu ka puerpuer ma bu ka kenken. Eiekesen bu sipsip gi kap nga rongomie bu inagie. ");
INSERT INTO tbf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eou mi rumrubukien. Sien va ka mei ta rubukien ka en seou, eie ta suvuon mi vavato ma eie ta rubukien rovotsour ma ta vorotan mi minous. ");
INSERT INTO tbf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mi ka puerpuer a nemei mo nia me puer nge ken nge tsang vatsakatie gie. Eiekesen eou, o nemei, terengien va gi ta mang suvuon mi tino, io, gi ta suvuon mi tino ian ta vousvous. ");
INSERT INTO tbf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Eou mi banga ka nennei sipsip. Mi banga ka nennei sipsip a ko terie ken tino surie ken sar sipsip. ");
INSERT INTO tbf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Eie ese ta tsatsang suri lakep, a kap va eie mi ka nennei sipsip ian ta taman bu sipsip. Sien va eie ta pare ka kopuen tso va ta nemei, ta sorvekenan bu sipsip nge vi. Ma mi kopuen tso ta me keda bu sipsip nge kareir vonuvie gie. ");
INSERT INTO tbf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ine mi ka ta vi, simi vunan eie a tsatsang suri lakep mo, ma a kap vodon puputungie gie bu sipsip. ");
INSERT INTO tbf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Eou mi banga ka nennei sipsip. O telekiran kong sar sipsip, ma kong sar sipsip gi telekira iou, ");
INSERT INTO tbf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","malan mi Tam a telekira iou ma o telekiran mi Tam. Ma o terie kong tino surie bu sipsip. ");
INSERT INTO tbf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","O suvuon buer bu sipsip mene, ma egie a kap va egie kovuni ine simi oiroir. O ta ngas kir nemei nge gie buer. Ma gi ta rongomie mi inoung, ma mi gargar sipsip ta kes mo ma mi ka nennei ta kes mo. ");
INSERT INTO tbf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mi Tam a tovie iou, simi vunan eou o ta terie kong tino surie va o ta mang por muerngan te buer. ");
INSERT INTO tbf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","A kap ka mei ta por rivie kong tino, eiekesen o terie kong tino vemusurie kong lalaron. Ma o suvuon mi duis nia terie, ma o suvuon mi duis nia por muerngan te buer. Ine arie e Tamoung a nga pevien va o ta ngas tsana malan.” ");
INSERT INTO tbf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mi vinekopot a nga tsorubeit i kotubuon bu Iuda surie ine bu nama. ");
INSERT INTO tbf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Palan segie gi nga pevien, “Mi tsaka moromoruo a te tsegerie, ma eie a te be. Surie misa nga ta rorong sien?” ");
INSERT INTO tbf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bu mei mene gi nga pevien, “Ine kap va bu namanien mi ka ese ta suvu tsaka moromoruo. Mi tsaka moromoruo a kap oit nia vakalaie ka kael, va gerek?” ");
INSERT INTO tbf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Io, si man vura mi tinuong, mi Nginou nia barabaramatan mi Vatavatamse simi Vona rengeir leong i Ierusalem a te nga beit. ");
INSERT INTO tbf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","E Iesu a nga veis i mararan mi Vona rengeir leong si ken korot porpor mour e Solomon. ");
INSERT INTO tbf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma bu muomuo sibu Iuda gi nga me viririsie ma gi nga vereie, “Vasa ta be potaram ven te va gei ta mon ngan ine mi vienviendon basbaslieng? Sien va evoi mi Messia, penge vakatsepa segei.” ");
INSERT INTO tbf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma e Iesu a nga kuil nama segie, “O te pengan senga, ma nga kap vodovodon tuktuk. Bu tsientsang o ta tsana simi asan e Tamoung, ine a vavatei katsep ngan senga va eou ese. ");
INSERT INTO tbf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Eiekesen enga nga kap vodovodon tuktuk seou, simi vunan enga kap va kong sar sipsip. ");
INSERT INTO tbf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kong sar sipsip gi rongomie mi inoung, ma o telekira gie, ma gi vemusurie iou. ");
INSERT INTO tbf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma o terie mi tino rovoriu segie, ma gi ta kap ba tsereiv. Ma a kap ka mei ta rou tsana gie i rimoung. ");
INSERT INTO tbf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","E Tamoung ese ta nga terie gie seou, a tsiroup sibu mei kokouk. Io, a kap ka mei ta rou tsana gie i napariman e Tamoung. ");
INSERT INTO tbf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eou meie ngan e Tamoung, gor kes mo.” ");
INSERT INTO tbf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bu Iuda gi nga tsuokopie bu vunavout te buer nia tomerie. ");
INSERT INTO tbf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma e Iesu a nga oeng segie, “O te nga vasangan senga palan bu banga tsientsang kuvu se Tamoung. Ma surie mi sana kepineits, nga lalaro tomerie iou?” ");
INSERT INTO tbf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bu Iuda gi nga kuil nama sien, “Surie mi banga tsientsang, gei ta kap tomerie no. Eiekesen surie mo mi namani oeng balapoik rakot se Raban. Evoi mi ka tuvuon mo ma e pevien va evoi e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Io, e Iesu a nga kuil nama segie, “Mi vinavataor a mon simi Vinuor senga va e Raban a nga pevien, ‘Enga bu raban.’ ");
INSERT INTO tbf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","E Raban a nga vuotongie egie ese gi ta nga suvuon mi namanien e Raban va egie bu raban. Ma mi namanien mi Pakpak Leong a kap vuris. ");
INSERT INTO tbf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Io, mi Tam a nga vokunie iou nge tura iou nemei ine simi mangmagoso enaenamon. O nga pevien, ‘Eou e Natuon e Raban’? Ma surie misa nga ta pevien va o te oeng balapoik ngan e Raban? ");
INSERT INTO tbf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sien va o ta kap tsana ken tsientsang e Tamoung, kian va nga ta vodovodon tuktuk seou. ");
INSERT INTO tbf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Misasien enga nga ta kap vodovodon tuktuk seou, sien va o ta tsana bu tsientsang se Tamoung, nga ta ngas vodovodon tuktuk sibu tsientsang o ta tsana, terengien nga ta mang telekiran nge katsep va mi Tam a tino seou, ma eou o tino simi Tam.” ");
INSERT INTO tbf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Io, gi nga konon nia rakopie te buer, eiekesen a nga evisie gie nge veis. ");
INSERT INTO tbf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma e Iesu a te buer nga rakot nge ra tsourarak simi da i Ioridan. Ma a nga so beit ian simi enamon e Ioanes ta nga muna tsana mi sinusuruiv en ma a nga mon ian en. ");
INSERT INTO tbf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma palan mi kulou gi nga nemei sien nge pevien, “E Ioanes a kap nga tsana ka totourlekier ni vovokudier, eiekesen ken sar vinakokoit kokouk e Ioanes surie ine mi ka, a tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Io, palan bu mei gi nga vodovodon tuktuk sien ian en. ");
INSERT INTO tbf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi ka, mi asan e Lasaro, a nga morouk. Eie kuvu i Betani, mi enamon se Maria meie e Mata, eguor ba baser kasien vevien. ");
INSERT INTO tbf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ine e Maria eie e vevinen e Lasaro ian ta nga morouk. Arie eie mi vevien ese ta nga soan mi da sosong simi Nguts nge dou vopura ba kamen ngan mi vuruvuru kovan. ");
INSERT INTO tbf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Io, ine ba baser kasien vevien guor nga vuruve nama beit se Iesu nge pevien, “Mi Nguts, mi mei ese e ta ko tovie, eie a morouk.” ");
INSERT INTO tbf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sien e Iesu ta nga rongomie ine, a nga pevien, “Ine man mienarouk e Lasaro ta kap voto ngan mi miensei, eiekesen ine nian man matvinavaso e Raban, terengien man matvinavaso e Natuon e Raban ta mang tsorubeit vasvas surie ine.” ");
INSERT INTO tbf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","E Iesu a nga tovie beitsak e Mata meie e kasien vevien ma e Lasaro. ");
INSERT INTO tbf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Eiekesen sien ta nga rongomie va e Lasaro a nga morouk, a nga mon ba ra luo te buer ivie ta nga mon en. ");
INSERT INTO tbf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma i murien ne, a nga oeng si ken sar madar tovtov, “Giet ta buer muerengei rakot i Iudea.” ");
INSERT INTO tbf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bu madar tovtov gi nga pevien, “Vavvasengei, siba ra die mo bu Iuda gi nga lalaro tomerie no nge vout. Ma ine e lalaro muer rakot en te buer?” ");
INSERT INTO tbf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","E Iesu a nga kuil nama, “Vasa, a kap sinangavur kes ma luo bu aua nian mi taparang i aron mi ra? Eie ese ta veis simi taparang ta kap tsuobakan, simi vunan a dedeng ngan man berber ine mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Eiekesen eie ese ta veis simi ngingi ta tsuobakan, simi vunan eie a kap suvu berber.” ");
INSERT INTO tbf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","I murien ta nga pevien ne, a nga oeng segie, “E palapalagiet e Lasaro a te muang, eiekesen o ta rakot nge vapada.” ");
INSERT INTO tbf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Samo ken sar madar tovtov gi nga kuil nama, “Mi Nguts, sien va eie a muang mo, eie ta buer kalei.” ");
INSERT INTO tbf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","E Iesu a nga vakvakokoit surie ken miensei, eiekesen ken sar madar tovtov gi si nga vodon va a nga vakokoit surie mi minuang tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Io, a nga oeng katsep segie, “E Lasaro a te mesei. ");
INSERT INTO tbf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma surie nga, o res sien o kap nga mon i babaren, terengien va nga ta mang vodovodon tuktuk. Eiekesen giet ta ngas rakot sien.” ");
INSERT INTO tbf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Io, e Tomas (gi vuotongie ngan e Didimas) a nga oeng sibu madar tovtov ka ie, “Egiet buer giet ta ra, va giet ta mang ra mesei meie.” ");
INSERT INTO tbf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Si ken bineit e Iesu i Betani, a nga so vorotan va e Lasaro a te nga mon i aron mi monmon ba ra voveit. ");
INSERT INTO tbf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I Betani a kap pek vekenan i Ierusalem, a oit mo ba kilomita tour. ");
INSERT INTO tbf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma palan bu Iuda gi te nga nemei se Mata ma e Maria nia vamada guor surie ken miensei e vevineguor. ");
INSERT INTO tbf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sien e Mata tate nga rongovan va e Iesu a te nga nemei, a nga veis nia ra suoeie, eiekesen e Maria a nga mon simi vonuo. ");
INSERT INTO tbf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","E Mata a nga pevien se Iesu, “Mi Nguts, sien va e nga mon en ne, va e vevineung a kap nga mesei. ");
INSERT INTO tbf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Eiekesen o telekiran va misasien nevere, e Raban ta terie sevoi mi sana kepineits e ta nongie ngan.” ");
INSERT INTO tbf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","E Iesu a nga oeng sien, “E vevine ta to muerengei.” ");
INSERT INTO tbf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","E Mata a nga kuil nama, “O telekiran va eie ta to muerengei simi tino mumuerengei simi ra vekvekitip.” ");
INSERT INTO tbf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","E Iesu a nga oeng sien, “Eou mi tino mumuerengei ma mi tino. Eie ese ta vodovodon tuktuk seou, ta tino, misasien ta mesei. ");
INSERT INTO tbf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma eie ese ta tino ma a vodovodon tuktuk seou, ta kap ba mesei. Vasa, e vodovodon tuktuk sien ine?” ");
INSERT INTO tbf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","E Mata a nga oeng sien, “Io, mi Nguts. O vodovodon tuktuk va evoi mi Messia, e Natuon e Raban, ese gi ta nga pevien va ta nga nemei simi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma i murien e Mata ta nga pevien ne, a nga muer nge ra kukuo e Maria e kasien vevien nge vemisir sien nge pevien, “E Vavvasengei te ine, ma a virei nge no.” ");
INSERT INTO tbf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sien e Maria ta nga rongomie ine, a nga tamtuir lalapus ma a nga rakot se Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Io, e Iesu a kap ngas nga beit simi enamon, eiekesen a ngas nga mon simi korot ivie e Mata ta nga suoeie en. ");
INSERT INTO tbf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bu Iuda gi nga mon meie e Maria simi vonuo nia vamada, ma sien gi ta nga dengarie ta nga tamtuir lalapus nge veis, gi nga vemusurie, simi vunan gi si nga vodon va ta nga rakot simi monmon nia ra ta. ");
INSERT INTO tbf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sien e Maria ta nga so beit simi korot ivie e Iesu ta nga mon en nge dengarie, a nga tsibour mutur i matan ma a nga pevien, “Mi Nguts, sien va e te nga mon en ne, va e vevineung a kap nga mesei.” ");
INSERT INTO tbf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sien e Iesu ta nga pare e Maria ta nga ta, ma bu Iuda gi ta nga nemei meie buer gi ta nga ta, a nga kitip mi aron ma a nga aor tsak, ");
INSERT INTO tbf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ma a nga virei, “Ivie nga te vuturungie en?” Gi nga kuil nama, “Mi Nguts. Nemei nge me pare.” ");
INSERT INTO tbf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","E Iesu a nga ta. ");
INSERT INTO tbf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma bu Iuda gi nga pevien, “Pare! Ken tentoiv rakot se Lasaro a leong beitsak!” ");
INSERT INTO tbf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eiekesen bu mei segie gi nga pevien, “Eie a nga vakalaie mi kael. Surie misa a kap nga oit buer nia tuir karie ine mi ka simi miensei?” ");
INSERT INTO tbf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Io, e Iesu a ngas nga kitip mi aron ma a nga rakot simi monmon. Ine mi tetteir mi rie ma mi vunavout a nga bontie man rumrubukien. ");
INSERT INTO tbf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","A nga pevien, “Nga tsang rivie ine mi vunavout.” Eiekesen e Mata, e vevinen ine mi ka mesei, a nga pevien, “Mi Nguts, malan te ine, tate sien tsak simi vunan a te voveit ba ra karie ta nga mesei sien.” ");
INSERT INTO tbf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Samo e Iesu a nga oeng sien, “Vasa, o kap ngas pengan sevoi va sien va e ta vodovodon tuktuk, e ta dengarie man matvinavaso e Raban?” ");
INSERT INTO tbf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Io, gi nga vuvuil rivie mi vunavout. Samo e Iesu a nga dedeng kien i kur ma a nga pevien, “Tama, o vuot kalei sevoi va e te rongomie iou. ");
INSERT INTO tbf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","O telekiran va e ko munu rorong seou, eiekesen o pevien ne surie ine mi kulou gi ta tuir en ne, va gi ta mang vodovodon tuktuk va evoi e nga tura iou.” ");
INSERT INTO tbf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ma sien tate nga pevien ne, e Iesu a nga koup leong nge pevien, “Lasaro! Rovotsour!” ");
INSERT INTO tbf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma samo e Lasaro a nga rovotsour. Gi nga pipitsie nge kato lavlav puneits vakaek siba kamen oit siba riman, ma mi kato lavlav mene i matan. E Iesu a nga oeng segie, “Nga ruobatie bu kato lavlav sien ma nga tsupuk rivie va ta veis.” ");
INSERT INTO tbf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Io, palan bu Iuda ese gi ta nga me iro e Maria, ma gi tate nga pare misa e Iesu ta nga tsana, gi nga vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Eiekesen bu mei segie gi nga rakot sibu Parisaio ma gi nga ra potsukie segie misa e Iesu ta nga tsana. ");
INSERT INTO tbf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Io, bu prist leong ma bu Parisaio gi nga kukuo mi mienagos meie mi Sanedrin bu muomuo nia vuor. Ma gi nga pevien, “Misa ine giet tsana? Ine mi ka a te tsana palan bu totourlekier ni vovokudier. ");
INSERT INTO tbf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sien va giet ta vodon sasavoir ngan, bu mei kokouk gi tate vodovodon tuktuk sien, ma bu Roma gi ta nemei ma gi ta me por tsana kegiet Vona rengeir leong ma kegiet vuna enamon.” ");
INSERT INTO tbf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Samo mi meinmenigie, mi asan e Kaiapas ese ta nga kovan bu prist ian simi avareit, a nga pevien, “Nga kap telekiran ka kepineits tuktuk! ");
INSERT INTO tbf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nga kap katsep va a kalei beitsak va ka ka kes ta mesei surie mi kulou eiekesen a kap kalei va kegiet vuna enamon kokouk ta tsereiv.” ");
INSERT INTO tbf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eie a kap nga vokokotie ine si ken vienviendon eie kesen, eiekesen surie eie a nga kovan bu prist ian simi avareit, a nga peterie va e Iesu ta nga mesei surie kegi vuna enamon bu Iuda. ");
INSERT INTO tbf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ine mi nama peteteir a kap va surie mo kegi vuna enamon i Iudea eiekesen surie buer bu natuon e Raban gi ta mon sibu korot mene simi mangmagoso enaenamon, nia teie kakaku gie va gi ta kes. ");
INSERT INTO tbf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Io, vakaek ian simi ra gi nga vakaek nge roev nian e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Io, surie ine, e Iesu a kap ba buer nga veisveis i matan mi lobaram i kotubuon bu Iuda. Eiekesen a nga veis nge ra mon simi taon i Epraem vatvatta mi beir, ivie a nga mon en meie ken sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sien tate nga vatvatta mi Nginu Pasova sibu Iuda, palan mi kulou gi nga veis kien vekenan bu enamon gi ta nga ko mon en rakot i Ierusalem nia vara melemelen nge gie i muan mi Nginu Pasova. ");
INSERT INTO tbf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Io, gi nga vor ve nesienesie e Iesu, ma sien gi ta nga so tuir i mararan mi Vona rengeir leong gi nga vevirei nge gie, “Vasa nga vodon ven? Eie ta kap nemei ine simi Nginou?” ");
INSERT INTO tbf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Eiekesen bu prist leong meie bu Parisaio gi nga terie mi nama va sien va ka mei va ta nga vorotan ivie e Iesu ta mon en, eie ta ngas me vateie gie surie va gi ta mang nga ra rakopie. ");
INSERT INTO tbf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bu ra mi napaririem potsu kes a ngas nga mon i muan mi Nginu Pasova, io, e Iesu a nga beit i Betani ivie e Lasaro ta nga ko mon en, eie ian mi ka e Iesu ta nga vatoa simi miensei. ");
INSERT INTO tbf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A te nga reivreiv ma gi nga tutu nian e Iesu ian en. E Mata a nga tsitsik ma e Lasaro a nga mon meie gie gi ta nga mogos viririsie mi tsur ngongou meie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Samo e Maria a nga por nemei ngan mi koip da sosong ian gi ta nga tsana ngan mi dangien mi nat matan kesen. Man voirvoir a nga vaen beitsak. Io, a nga soan siba kamen e Iesu ma a nga dou vopura ngan mi vuruvuru kovan. Ma mi aron mi vonuo a nga vous ngan mi siesienan ian mi da sosong. ");
INSERT INTO tbf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Eiekesen e Iudas Iskariot, mi meinmenien ken sar madar tovtov e Iesu, ian i muir va ta nga so roev terie e Iesu, a nga pevien, ");
INSERT INTO tbf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Surie misa giet ta kap nga verikulie ine mi da sosong ngan mi lakep nge terie sibu sinaortsak? Ine man voirvoir a oit ba sinangavur tour koboit (300) bu lakep denari.” ");
INSERT INTO tbf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A nga pevien ne simi vunan eie mi ka puerpuer, a kap va eie a nga tovie bu sinaortsak. Eie man ka nennei mi puol lakep, ma a nga ko poro bu lakep mene ken eie kesen. ");
INSERT INTO tbf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","E Iesu a nga kuil nama, “Nga tsupuk rivie ine mi vevien. A te tsana ine nia rorrois ngan kong mintur simi monmon. ");
INSERT INTO tbf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bu sinaortsak gi ta mon meie nga sibu ra, eiekesen o ta kap mon meie nga sibu ra.” ");
INSERT INTO tbf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mi bineit leong sibu Iuda gi nga vakierngie va e Iesu a nga mon ian en. Ma gi nga nemei nia pare e Iesu ma buer e Lasaro ian e Iesu ta nga vatoa simi miensei. ");
INSERT INTO tbf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eiekesen bu prist leong gi nga roev nia kenvamate e Lasaro buer, ");
INSERT INTO tbf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","simi vunan palan bu Iuda gi nga murien veie gie ma gi nga vodovodon tuktuk se Iesu surie mi sana ta nga tsorubeit se Lasaro. ");
INSERT INTO tbf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Simi ra vemusurie, mi bineit leong ian gi ta nga nemei simi Nginu Pasova, gi nga rongovan e Iesu va ta nga veis nemei i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ma gi nga poro bu pakapaka bebei nge ra suoeie, ma gi nga vakaek nge koupkoup, “Osana! E Raban ta vatamase eie ese ta nemei ngan mi asan mi Nguts! E Raban ta vatamase mi kovakova ka leong sibu Israel!” ");
INSERT INTO tbf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","E Iesu a nga vorotan mi natu dongki ma a nga ka i popon, malan mo mi Pakpak Leong ta pevien, ");
INSERT INTO tbf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kian va e ta motou, e Natuon vevien i Sion! Dengarie, ma kovakova ka leong a nemei, a kesie mi natu dongki.” ");
INSERT INTO tbf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vourvour, ken sar madar tovtov gi kap nga katsep surie ine bu kepineits kokouk. Eiekesen i murien e Iesu ta nga suvuon man matvinavaso, gi nangba nga katsep va ine mi vinavataor simi Pakpak Leong a nga vakokoit surie e Iesu, ma buer va ine bu kepineits a nga tsorubeit tuktuk seie. ");
INSERT INTO tbf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Io, mi kulou ian gi ta nga mon meie eie sien ta nga kukuo e Lasaro simi monmon nge vatoa e Lasaro simi miensei, gi nga vor ve poutspouts ngan misa ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Palan mi kulou gi nga ra suoeie e Iesu, simi vunan gi te nga rongomie va a nga tsana ine mi totourlekier ni vovokudier. ");
INSERT INTO tbf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Io, bu Parisaio gi nga vevuor i kotubugie, “Pare, giet ta kap tsang vaotie te ka kepineits. Pare, mi mangmagoso enaenamon kokouk gi te vemusurie eie!” ");
INSERT INTO tbf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kavo mei segie bu Grik gi nga nomeie egie ese gi ta nga rakot i Ierusalem nia ra rengeir ine simi Nginu Pasova. ");
INSERT INTO tbf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","gi nga ra vorotan e Pilipo kovuni i Betsaida simi enamon leong i Galili, ma gi nga vereie, “Ka leong, gei lalaro pare e Iesu.” ");
INSERT INTO tbf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","E Pilipo a nga ra pengan se Andre. Io, e Andre meie e Pilipo guor nga ra pengan se Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","E Iesu a nga kuil nama, “Mi keipkepide ra a te beit va e Natuon mi Ka ta suvuon man matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","O oeng tuktuk senga, sien va ka pidepide wit ta kap kor simi kaber nge mesei, ta mon mi pei kes mo. Eiekesen sien va ta mesei, ta vua ngan palan bu vuovuo. ");
INSERT INTO tbf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Eie ese ta tovie ken tino, ta votsorovie, ma eie ese ta karto ken tino ine simi kaber, ta suvuon mi tino rovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Eie ese ta tsatsang seou ta ngas vemusurie iou, ma ivie o ta mon en, kong petspets buer ta mon meie iou en. Mi Tam ta tienengan mi mei ese ta tsatsang seou. ");
INSERT INTO tbf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ma ine mi aroung a moungmoung. Ma vasa o ta pevien? O ta pevien, ‘Tama, vatoa iou ian simi keipkepide ra’? A kap, ine arie mi vunan o nga nemei va nian ine mi keipkepide ra. ");
INSERT INTO tbf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tama, vutuir vasangan man matvinavaso mi asa!” Samo mi ien a nga pevien kovuni simi rangit, “O te nga vutuir vasangan man matvinavaso, ma o ta vutuir vasangan te buer.” ");
INSERT INTO tbf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mi bineit gi ta nga mon ian en nge rongomie ine, gi nga pevien va mi tengteng. Ma bu mei mene gi nga pevien va mi angelo a nga vakokoit sien. ");
INSERT INTO tbf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma e Iesu a nga pevien, “Ine mi ien a beit nian manga kalekalei, ma kap va nioung. ");
INSERT INTO tbf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mi keipkepide ra va e Raban ta viertan mi mangmagoso enaenamon a te beit, ma tate kareir rivie man ka leong ine mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eiekesen, simi ra va gi ta tsuok terie iou i kur simi koitskoits, o ta teie mi kulou kokouk nemei seou.” ");
INSERT INTO tbf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A nga pevien ne nia vasangan segie mi sana suada miensei va ta nga mesei ngan. ");
INSERT INTO tbf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mi bineit gi nga kuil nama, “Gei te nga rongomie simi Pakpak Leong va mi Messia ta tino rovoriu, ma vasa e si pevien, ‘E Natuon mi Ka gi ta ngas tsuok terie i kur simi koitskoits’? Ese ine e Natuon mi Ka?” ");
INSERT INTO tbf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Io, e Iesu a nga oeng segie, “Mi Berber ta kap mon potaram meie nga. Veis, sien mi Berber ta ngas mon meie nga, terengien va mi ngingi ta kap mang tseiptseiprio nga. Eie ese ta veis simi ngingi a kap telekiran va ivie a rakot en. ");
INSERT INTO tbf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nga vodovodon tuktuk ine simi Berber sien ta ngas mon, terengien va nga ta mang tsorubeit bu natuon mi Berber.” E Iesu a te nga vokokotie ine bu kepineits ma a nga sorvekena gie nge kokoiv. ");
INSERT INTO tbf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Misasien e Iesu tate nga tsana ine bu totourlekier ni vovokudier i matagie bu Iuda, gi kap ngas nga vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ine mi kepineits a nga tsorubeit tuktuk nia vara tuktuk ngan mi namanien e Isaia mi propet ian ta pevien, “Mi Nguts, ese a te nga vodovodon tuktuk si kegei sar nama ma se ese mi Nguts a te nga vasangan mi ngesengesien?” ");
INSERT INTO tbf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eiekesen gi kap nga oit nia vodovodon tuktuk, malan e Isaia ta nga vokokotie buer. ");
INSERT INTO tbf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“E Raban a te nga vakale bu katsomatagie ma a te nga vara papan ngan bu arogie, terengien gi ta kap mang oit nia dedeng ngan bu katsomatagie, ma gi ta kap mang oit nia katsep ngan bu arogie, nge vodon vuris, ma o ta kap mang vatoa gie.” ");
INSERT INTO tbf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","E Isaia a nga vokokotie ine surie e Iesu, simi vunan a te nga pare man matvinavaso mi Messia. ");
INSERT INTO tbf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Palan mi kulou meie bu muomuo sibu Iuda, gi nga vodovodon tuktuk se Iesu. Eiekesen gi kap nga vasangan kegi sar vodovodon tuktuk simi vunan gi nga motou va bu Parisaio gi ta masi nga matokera gie si kegi sar vona rengeir. ");
INSERT INTO tbf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Simi vunan gi nga lalaron beitsak mi tietienengei kuvu simi ka rio mi tietienengei kuvu se Raban. ");
INSERT INTO tbf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma e Iesu a nga koup pevien, “Eie ese ta vodovodon tuktuk seou, eie a kap vodovodon tuktuk seou mo, eiekesen simi Ka ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Eie ese ta dengarie iou, a pare mi Ka ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","O nga nemei ine simi mangmagoso enaenamon malan va mi Berber, terengien va mi kulou kokouk gi ta vodovodon tuktuk seou gi ta kap ba mon simi ngingi. ");
INSERT INTO tbf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Egie ese gi ta rongomie bu namaniung eiekesen gi kap vemusurie gie, o ta kap vuortie gie surie, simi vunan o kap nga nemei nia votorosie mi mangmagoso enaenamon eiekesen o nga nemei nia vatoa mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eiekesen mi mei a mon nia vuortie egie ese gi ta purusie iou ma bu namaniung. Mi nama o tate nga vokokotie, arie eie ta vuortie gie simi ra vekvekitip. ");
INSERT INTO tbf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Simi vunan o kap nga vakokoit ngan kong lalaron keseung, eiekesen mi Tam ese ta nga tura iou a nga oeng ngeisngeis seou ngan misa va o ta ngas vokokotie. ");
INSERT INTO tbf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","O telekiran va ken nama ngeisngeis arie mi petsuon mi tino rovoriu. Io, misa o ta vokokotie arie mo misa mi Tam tate nga pengan seou nia vokokotie.” ");
INSERT INTO tbf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mi ra i muan mi rangi Nginu Pasova a nga beit. E Iesu a nga telekiran va mi keipkepide ra a te nga beit va ta sorvekenan ine mi mangmagoso enaenamon nge rakot simi Tam. Ma a nga ko tovie ken kulou gi ta nga mon simi mangmagoso enaenamon, ma a nga tovie gie oit si ken ra vekvekitip. ");
INSERT INTO tbf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Sien e Iesu ma ken sar madar tovtov gi ta nga ngou kokouk, ma mi kovan bu tsaka moromoruo a te nga muna terie mi vienviendon i aron e Iudas Iskariot, e natuon e Simon, va ta nga roev terie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","E Iesu a nga telekiran va mi Tam a nga terie bu kepineits kokouk i riman. Ma buer a nga telekiran va a nga kuvu se Raban ma ta ba muer rakot se Raban. ");
INSERT INTO tbf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Io, a nga tamtuir sorvekenan mi korot nia ngou nge kaor rivie man tsetstseik ka i marar, ma a nga rorosan mi dondou i kinorotuon. ");
INSERT INTO tbf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Samo a nga soan mi da i aron mi utut, ma a nga vakaek nge suruvie bu kamegie bu madar tovtov nge vopura gie ngan mi dondou ta nga rorosan i kinorotuon. ");
INSERT INTO tbf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Io, a nga nemei se Simon Petro. Ma e Petro a nga oeng sien, “Mi Nguts, vasa, e ta suruvie ba kameung?” ");
INSERT INTO tbf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","E Iesu a nga kuil nama sien, “Ine, e kap telekiran misa o tsana, eiekesen e ta ba telekiran ba i muir.” ");
INSERT INTO tbf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","E Petro a nga pevien, “Kian va e ta suruvie ba kameung!” Ma e Iesu a nga pevien, “Sien va o ta kap suruvie ba kame, a kap ke ka baitutuir meie iou.” ");
INSERT INTO tbf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","E Simon Petro a nga kuil nama sien, “Mi Nguts, kap va ba kameung mo, eiekesen suruvie ba rimoung ma mi kovoung buer!” ");
INSERT INTO tbf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","E Iesu a nga pevien, “Eie ese tate nga sisi, a te tsorubeit melemelen te. Ma a pinat surie mo nia suruvie ba kamen. Enga nga te melemelen, eiekesen kap va enga kokouk.” ");
INSERT INTO tbf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E Iesu a te nga telekiran va ese ta nga roev terie eie. Arie mi vunan a nga pevien, “Kap va enga kokouk nga melemelen.” ");
INSERT INTO tbf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Io, sien e Iesu tate nga suruvie bu kamegie, a nga tseik muerngan man tsetstseik ma a nga muerengei rakot si ken mogomogos simi tsur. Ma a nga virei, “Nga telekiran misa o tate tsana senga? ");
INSERT INTO tbf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nga ko vuotongie iou va eou mi vavvasengei ma mi Nguts, ma a duis simi vunan arie eou. ");
INSERT INTO tbf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eou manga Nguts ma manga vavvasengei. O te suruvie bu kamenga. Enga buer nga ta ngas vesuruiv ngan bu kamenga. ");
INSERT INTO tbf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","O te vutuir vasangan mi puppuo senga surie va nga ta ngas tsana malan o te tsana senga. ");
INSERT INTO tbf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","O oeng tuktuk senga, a kap ka petspets a leong rio man ka leong ma a kap ka ka ni tinuturei a leong rio mi ka ta turan. ");
INSERT INTO tbf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Io, nga te telekiran ine, ma mi nires leong ta mon senga sien va nga ta tovtov ngan. ");
INSERT INTO tbf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“O kap vakokoit surie nga kokouk. O telekira gie egie ese o ta nga vile gie. Eiekesen mi nama simi Pakpak Leong a pevien ne, ‘Eie ese ta tsutsuok meie iou si mong nginonginou a te murien veie iou.’ Ma ine mi nama ta ngas tsorubeit tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“O pengan senga ine i muan va ta tsorubeit, terengien va nga ta mang vodovodon tuktuk va eou mi Messia sien va ine ta tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","O oeng tuktuk senga, eie ese ta suguo ka mei o ta turan, a suguo iou, ma eie ese ta suguo iou a suguo mi Ka ta nga tura iou.” ");
INSERT INTO tbf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sien e Iesu tate nga pevien ne, a nga aor tsak ma a nga vavatei katsep nge pevien, “O oeng tuktuk senga, mi mei kes senga ta roev terie iou simi matakorot.” ");
INSERT INTO tbf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bu madar tovtov gi nga vevededeng nge gie keskes, ma gi nga sesebetei va a nga oeng terie se ese ine mi nama. ");
INSERT INTO tbf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mi meinmenien bu madar tovtov eie ese mi aten e Iesu, a nga mogos i babaren. ");
INSERT INTO tbf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","E Simon Petro a nga teik mat rakot sien nge pengan, “Vereie, a pengan ese?” ");
INSERT INTO tbf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Samo a nga vevedikeir se Iesu nge vereie, “Mi Nguts, ese ian?” ");
INSERT INTO tbf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","E Iesu a nga kuil nama, “O ta tsonga mi poko tsoik i aron mi koi ngongou ma o ta terie sien, arie eie mi ka.” Samo a nga poro mi poko tsoik nge tsonga ma a nga terie se Iudas, e natuon e Simon Iskariot. ");
INSERT INTO tbf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ian ngas te, sien e Iudas ta nga poro mi tsoik, e Satan a nga rubukien sien. E Iesu a nga pevien sien, “Lalapus nge tsana mi sana e ta visi tsana!” ");
INSERT INTO tbf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Eiekesen kap ka mei segie gi ta nga mogos viririsie mi tsur ngongou a nga katsep simi sana mi vunan e Iesu ta nga vokokotie ine rakot sien. ");
INSERT INTO tbf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","E Iudas a nga ko naneie mi puol lakep. Ma surie ine, bu mei segie bu madar tovtov gi si nga vodon va e Iesu a nga oeng sien va ta nga rakot nge vorie misa gi ta nga pinat ngan simi nginou, o, va ta nga ra terie kavo kepineits sibu sinaortsak. ");
INSERT INTO tbf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","I muir sien e Iudas ta nga poro ine mi poko tsoik, a nga rovotsour ian ngas te. Ma a te nga kati. ");
INSERT INTO tbf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Io, sien e Iudas tate nga rovotsour, e Iesu a nga pevien, “Ine, man matvinavaso e Natuon mi Ka ta tsorubeit vasvas, ma man matvinavaso e Raban ta tsorubeit vasvas surie Eie. ");
INSERT INTO tbf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sien va man matvinavaso e Raban ta tsorubeit vasvas surie Eie, e Raban buer ta vutuir vasangan man matvinavaso e Natuon mi Ka ian ngas te. ");
INSERT INTO tbf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Bu natung, o ta kap mon potaram meie nga. Nga ta ba nesie iou. Ma ine o pengan senga buer misa o tate nga pengan sibu muomuo sibu Iuda; nga kap oit nia beit simi korot o ta rakot en. ");
INSERT INTO tbf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Io, mi vuna vinuor vour o ta terie senga va nga ta ngas totoiv ververkis. Nga ta ngas totoiv ververkis malan o ta nga tovie nga. ");
INSERT INTO tbf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sien va nga ta totoiv ververkis, io, mi kulou kokouk gi ta telekiran va enga kong sar madar tovtov.” ");
INSERT INTO tbf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","E Simon Petro a nga virei, “Ivie e ta rakot en, mi Nguts?” E Iesu a nga kuil nama, “Ine, e kap oit nia vemusurie iou ivie va o ta rakot en. Eiekesen i muir, e ta ba so vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","E Petro a nga virei, “Mi Nguts. Surie misa o ta kap oit nia vemusurie no ine? O rorois nia maet surie no!” ");
INSERT INTO tbf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","E Iesu a nga kuil nama, “Vasa, e rorois nia maet surie iou? O oeng tuktuk sevoi, i muan va mi to ta kurkuku, e ta so vamoie iou votour!” ");
INSERT INTO tbf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","E Iesu a nga oeng si ken sar madar tovtov, “Kian va nga ta aor tsak. Vodovodon tuktuk se Raban ma vodovodon tuktuk buer seou. ");
INSERT INTO tbf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","I aron ken vonuo e Tamoung a palan bu korot nia mon en. Sien va a kap, va o nga pengan senga. O ta ra tsang rorois ngan kavo korot nianga. ");
INSERT INTO tbf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","I murien va o ta ra tsang rorois ngan kenga korot, o ta ba muerengei nge kerie nga, terengien va nga ta mang ra mon ivie o ta mon en. ");
INSERT INTO tbf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nga telekiran mi rosar rakot ivie o ta rakot en.” ");
INSERT INTO tbf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","E Tomas a nga pevien sien, “Mi Nguts, gei kap telekiran ivie e ta rakot en. Vasa gei ta telekire venengan ine mi rosar?” ");
INSERT INTO tbf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","E Iesu a nga kuil nama sien, “Eou mi rosar, mi tuktuk, ma mi tino. Kap ka mei a oit nia beit se Tamoung si ka rosar mene eiekesen seou mo. ");
INSERT INTO tbf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sien va nga te telekira iou, va nga telekiran buer e Tamoung. Ma vakaek ine, nga telekiran ma nga te dengarie.” ");
INSERT INTO tbf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","E Pilipo a nga pevien sien, “Mi Nguts, vasangan segei mi Tam va ta mang vaotie gei.” ");
INSERT INTO tbf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","E Iesu a nga kuil nama, “A te nga potaram te o nga mon meie nga, ma e kap ngas telekira iou, Pilipo? Eie ese tate pare iou, a te pare mi Tam. Surie misa e ta pevien, ‘Vasangan segei mi Tam?’ ");
INSERT INTO tbf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Vasa, e kap vodovodon tuktuk va o tino simi Tam ma mi Tam a tino seou? Bu nama o ta vokokotie rakot sevoi, a kap vemusurie kong lalaron. Mi Tam ese ta tino seou, a tsana ken tsientsang. ");
INSERT INTO tbf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Vodovodon tuktuk va o tino se Tamoung ma e Tamoung a tino seou. Sien va ta kap, vodovodon tuktuk surie mi tsinatsangoung. ");
INSERT INTO tbf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","O oeng tuktuk senga, eie ese ta vodovodon tuktuk seou, ta tsana malan o ta tsana. Ma ta tsana buer bu kepineits leong rio misa o ta nga tsana, simi vunan o ta rakot se Tamoung. ");
INSERT INTO tbf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma o ta tsana bu sana nga ta no surie simi asoung, terengien va e Tamoung ta mang suvuon man matvinavaso surie e Natuon. ");
INSERT INTO tbf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sien va nga ta nongie iou ngan ka sana kepineits simi asoung, o ta tsang vaotie. ");
INSERT INTO tbf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Sien va nga ta tovie iou, nga ta vemusurie kong sar nama ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","O ta nongie mi Tam, ma eie ta terie senga mi Ka ni kuilkuil mene, va ta mang mon meie nga sibu ra bu ra. ");
INSERT INTO tbf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Eie mi Moromoruo Tamat ian ta vasangan mi tuktuk. Mi mangmagoso enaenamon a kap oit nia suvuon, simi vunan a kap pare ma a kap telekiran. Eiekesen enga nga telekiran, simi vunan a te mon meie nga ma ta tsegerie nga. ");
INSERT INTO tbf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","O ta sorvekena nga eiekesen o ta kap sunuir va nga ta mon malan bu natu tenei. O ta ba nemei senga. ");
INSERT INTO tbf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ta kap potaram mo, ma mi mangmagoso enaenamon ta kap ba pare iou, eiekesen enga nga ta ba pare iou, simi vunan o tino, ma enga buer nga ta tino. ");
INSERT INTO tbf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ian simi ra, nga ta telekiran va o tino se Tamoung, ma enga nga tino seou, ma o ta tino senga. ");
INSERT INTO tbf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Eie ese ta rong poro kong sar nama ngeisngeis nge vemusurie gie, arie eie ese a tovie iou. Ma e Tamoung ta tovie eie ese ta tovie iou. Eou buer o ta tovie ma o ta vasanga iou sien.” ");
INSERT INTO tbf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","E Iudas (kap va e Iudas Iskariot) a nga pevien sien, “Mi Nguts, ta mang sa va e ta vasanga no segei, eiekesen simi mangmagoso enaenamon kap?” ");
INSERT INTO tbf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","E Iesu a nga kuil nama sien, “Eie ese ta tovie iou, ta vemusurie kong nama. Ma e Tamoung ta tovie. Ma egor e Tamoung gor ta me tino seie. ");
INSERT INTO tbf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Eie ese ta kap tovie iou, a kap vemusurie kong sar nama, ma ine mi nama nga ta rongomie a kap va seou, eiekesen a kuvu se Tamoung ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“O te nga pengan senga ine sien o ta nga mon meie nga. ");
INSERT INTO tbf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Eiekesen mi Ka ni kuilkuil, mi Moromoruo Tamat, ese e Tamoung ta turan simi asoung, eie ta vasangan senga bu kepineits kokouk ma ta oeng veteringa nga ngan bu sana o tate nga pengan senga. ");
INSERT INTO tbf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi molu o ta sorvekene terie senga. Arie kong molu o terie. O kap terie senga malan mi mangmagoso enaenamon ta tabeir. Kian va nga ta aor tsak nge motou. ");
INSERT INTO tbf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nga te nga rongomie va o nga pengan senga malan ine, ‘O ta sorvekena nga, eiekesen o ta ra muerengei nemei senga.’ Sien va nga tovie iou, va nga res va o ta rakot se Tamoung, simi vunan eie a tsiroup seou. ");
INSERT INTO tbf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","O te muna peterie misa va ta tsorubeit, terengien va nga ta mang vodovodon tuktuk ine simi kepineits va ta tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","O ta kap vakokoit potaram meie nga, simi vunan man ka leong mi mangmagoso enaenamon ta nemei. Eie a kap oit ngeisngeis rio iou. ");
INSERT INTO tbf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Eiekesen mi mangmagoso enaenamon ta ngas telekiran va o tovie mi Tam. Arie mi vunan o tsana mi sana e Tamoung ta nga oeng ngeisngeis ngan seou. “Lalapus ma, giet tate veis. ");
INSERT INTO tbf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Eou mi vain tuktuk ma e Tamoung eie mi ka nennei tau vain. ");
INSERT INTO tbf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","A ko tar rivie bu rakrak seou gi ta kap ko vua. Io, bu rakaraka vain gi ta vua a ko tov putiputi gie surie va gi ta mang vua palan. ");
INSERT INTO tbf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Enga nga te melemelen surie mi nama o tate nga vokokotie senga. ");
INSERT INTO tbf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nga ta ngas tsok seou ma eou o ta ngas tsok senga. A kap ka rakaraka vain a ko vua sien va ta kap tsok simi vain. Enga buer nga ta kap oit nia vua ngan kavo vuovuo sien va nga ta kap tsok seou. ");
INSERT INTO tbf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Eou mi vain, enga bu rakarakan ine mi vain. Sien va ka mei ta tsok seou ma o ta tsok sien, eie ta vua ngan kavo vuovuo palan. Sien va nga ta kap tsok seou, nga ta kap oit nia tsang vaotie ka kepineits. ");
INSERT INTO tbf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sien va ka mei ta kap tsok seou, eie ta malan bu rakaraka ei gi ta tomekan nge mamarongo, ma gi ta sere tou nge gie ma gi ta tomeke terie simi leing nge tunie. ");
INSERT INTO tbf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sien va nga ta tsok seou ma kong nama a mon i aronga, nga ta nongie mi sana kepineits nga ta lalaron, ma nga ta suvuon ine mi kepineits. ");
INSERT INTO tbf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","E Tamoung ta suvuon mi matvinavaso sien va nga ta vua ngan bu vuovuo palan ma ta vasangan va enga kong sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Malan e Tamoung a ko tovie iou, eou buer o tovie nga. Nga ta ngas mon i aron kong tentoiv. ");
INSERT INTO tbf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sien va nga ta vemusurie kong sar nama ngeisngeis, nga ta mon i aron kong tentoiv, malan o ta vemusurie ken sar nama ngeisngeis e Tamoung ma o mon i aron ken tentoiv. ");
INSERT INTO tbf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","O te pengan senga ine mi kepineits, terengien va kong nires ta mang mon i aronga, ma va kenga sar nires ta mang me tsorubeit pu. ");
INSERT INTO tbf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kong nama ngeisngeis a malan ine, ‘Nga ta ngas totoiv ververkis nge nga malan o ta tovie nga.’ ");
INSERT INTO tbf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mi vuna tentoiv tuktuk a oit va ta tsourbeit vasvas sien va ka mei a tsupuk rivie ken tino nia kulie bu palapalan. ");
INSERT INTO tbf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Enga bu polopoloung sien va nga ta vemusurie kong sar nama ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","O ta kap vuotongie va enga bu petspets, simi vunan mi petspets a kap telekiran mi sana man ka leong ta tsana. Io, o te vuotongie nga va enga bu polopoloung, simi vunan bu kepineits o ta nga rongomie se Tamoung o te pengan senga. ");
INSERT INTO tbf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nga kap nga vile iou, eiekesen eou o nga vile nga nia ra tsatsang nge vua ngan kavo vuovuo ian ta mon rovoriu. Io, e Tamoung ta terie senga mi sana kepineits nga ta nongie simi asoung. ");
INSERT INTO tbf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ine arie kong nama ngeisngeis. Nga ta ngas totoiv ververkis. ");
INSERT INTO tbf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Sien va mi mangmagoso enaenamon ta karto nga, nga ta vodonomie va a nga muna karto iou. ");
INSERT INTO tbf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sien va enga mi kuoluon mi mangmagoso enaenamon, va a nga tovie nga. Eiekesen enga kap va mi kuoluon. Io, o te nga viel tsana nga kuvu simi mangmagoso enaenamon, ma arie mi vunan a ko karto nga. ");
INSERT INTO tbf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nga vodonomie mi nama o tate nga vokokotie senga ven ne, ‘A kap ka petspets a leong rio man ka leong.’ Sien va gi te vikikinie iou, gi ta vikikinie nga buer. Sien va gi te rorong si kong nama, gi ta rorong si kenga sar nama buer. ");
INSERT INTO tbf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Gi ta tsang malan ngan senga ine simi vunan enga kong sar madar tovtov, ma gi kap telekiran mi Ka ese ta nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Sien va o kap nga nemei nge me vakokoit segie, va gi kap oit nia maduo surie kegi sar sinavei tsokor. Eiekesen ine, kap man ka namani tuir bibirit si kegi sar sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Eie ese ta karto iou, a karto buer e Tamoung. ");
INSERT INTO tbf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sien va o kap nga tsana i kotubugie bu kepineits ni vovokudier ian kap ka mei mene a oit nia tsana, va gi kap oit nia maduo surie kegi sar sinavei tsokor. Eiekesen ine, gi te nga pare bu kepineits o ta nga tsana, ma gi karto iou ma e Tamoung buer. ");
INSERT INTO tbf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Eiekesen gi te nga tsana ine nia vara tuktuk ngan misa gi ta nga vataro simi Pakpak Leong malan ne, ‘Gi karto iou eiekesen kap ka vunan.’ ");
INSERT INTO tbf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“O ta turan mi Ka ni kuilkuil, mi Moromoruo Tamat ian ta vasangan mi tuktuk. Eie ta nemei kuvu se Tamoung, ma ta vavatei katsep nge iou. ");
INSERT INTO tbf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma enga buer nga ta vavatei katsep, simi vunan nga te nga mon meie iou vakaek simi tsuoktsuok vakaek. ");
INSERT INTO tbf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Bu kepineits kokouk o te pengan senga, terengien va nga ta kap mang veis bebeir. ");
INSERT INTO tbf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bu Iuda gi ta matokera nga si kegi sar vona rengeir, eiekesen mi keipkepide ra va ta beit va gi ta kenvamate nga nge vodon va gi tsatsang se Raban. ");
INSERT INTO tbf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gi ta tsana ine bu kepineits simi vunan gi kap ngas telekiran mi Tam ma eou. ");
INSERT INTO tbf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","O te pengan senga ine bu kepineits, terengien va nga ta mang vodonomie misa o te nga vakokoit surie gie, sien va ine bu kepineits va ta tsorubeit. O kap nga pengan senga vourvour simi vunan o nga mon meie nga. ");
INSERT INTO tbf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Eiekesen ine, o ta rakot seie ese ta nga tura iou, ma kap ka mei senga a vereie iou, ‘Ivie e ta rakot en?’ ");
INSERT INTO tbf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nga vous ngan mi aor tsak simi vunan o te vokokotie ine bu kepineits senga. ");
INSERT INTO tbf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Eiekesen o oeng tuktuk senga, surie manga kalekalei, o ta sorvekena nga. Sien va o ta kap sorvekena nga, mi Ka ni kuilkuil ta kap ra nemei senga. Eiekesen sien va o ta veis, o ta ra turan nemei senga. ");
INSERT INTO tbf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Eie ta ra nemei, ma ta me oeng matan mi kulou simi mangmagoso enaenamon surie kegi baitutuir simi sinavei tsokor, simi sinavei duis, ma simi sinavei nia viertan mi kulou. ");
INSERT INTO tbf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Eie ta me oeng matan surie kegi baitutuir simi sinavei tsokor, simi vunan gi kap vodovodon tuktuk seou. ");
INSERT INTO tbf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Eie ta me oeng matan surie kegi baitutuir simi sinavei duis, simi vunan o ta kien simi Tam, ma nga ta kap ba oit nia pare iou. ");
INSERT INTO tbf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Eie ta me oeng matan surie kegi baitutuir simi sinavei nia viertan mi kulou, simi vunan man ka leong mi mangmagoso enaenamon a te nga tuir simi vinuor. ");
INSERT INTO tbf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“O suvuon palan bu kepineits mene nia pengan senga, eiekesen nga kap oit nia telekire ruobata gie. ");
INSERT INTO tbf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Eiekesen, sien mi Moromoruo Tamat ian ta vasangan mi tuktuk va ta nemei, eie ta muonge nga rakot simi tuktuk. Eie ta kap vokokotie vemusurie ken lalaron kesen, eiekesen ta vokokotie mo misa ta rongomie ma ta vakatsepa senga misa va ta ba beit. ");
INSERT INTO tbf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eie ta vutuir vasangan mong matvinavaso, simi vunan ta vasangan senga misa ta poro seou. ");
INSERT INTO tbf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bu kepineits kokouk se Tamoung, arie seou. Arie mi vunan o te pevien va mi Moromoruo Tamat ta vasangan senga misa ta poro seou. ");
INSERT INTO tbf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ta kap potaram te va nga ta kap pare iou, ma ta kap potaram te buer, va nga ta ba pare iou.” ");
INSERT INTO tbf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bu mei mene si ken sar madar tovtov e Iesu gi nga vevirei nge gie kesegie, “Misa mi vunan ine mi nama ta pevien, ‘Ta kap potaram te va nga ta kap pare iou, ma ta kap potaram te buer, nga ta ba pare iou.’? Ma misa mi vunan ine mi nama ta pevien, ‘Simi vunan o ta kien se Tamoung.’?” ");
INSERT INTO tbf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Io, gi nga pevien, “Ma misa mi vunan ta pevien, ‘Ta kap potaram te?’ Giet kap telekiran misa a vakokoit surie.” ");
INSERT INTO tbf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","E Iesu a nga telekiran va gi nga lalaro vosuoreie ngan ine, io, a nga pevien segie, “Nga vevirei nge nga kesenga va misa mi vunan o ta pevien ne, ‘Ta kap potaram te va nga ta kap pare iou, ma buer ta kap potaram te va nga ta ba pare iou’? ");
INSERT INTO tbf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","O oeng tuktuk senga, nga ta aor tsak nge ta, eiekesen mi mangmagoso enaenamon ta res. Nga ta aor tsak, eiekesen kenga aor tsak ta vuris nge tsorubeit mi nires. ");
INSERT INTO tbf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mi vevien va ta pan ken madar ta rongmetsikien mi vinavasor, simi vunan ken keipkepide ra a te beit, eiekesen sien tate kava ken natu madar, ta vodon punan mi vinavasor, simi vunan a res va mi natu madar a te beit ine simi kaber. ");
INSERT INTO tbf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Io, ine, enga buer nga suvu aor tsak, eiekesen o ta ba buer pare nga ma nga ta res ma a kap ka mei ta por tsana kenga nires. ");
INSERT INTO tbf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ian simi ra, nga ta kap vosuoreie iou surie ka kepineits. O oeng tuktuk senga, mi Tam ta terie senga misa nga ta nongie simi asoung. ");
INSERT INTO tbf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Oit ine, nga kap ngas nongie iou ngan ka kepineits simi asoung. Nga ta no ma nga ta so suvuon, va kenga nires ta mang tsorubeit pu. ");
INSERT INTO tbf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“O nga vokokotie bu kepineits ngan bu nama puppuo, mi keipkepide ra ta beit va o ta kap ba vakokoit simi nama puppuo, eiekesen o ta vakokoit katsep ngan mi Tam. ");
INSERT INTO tbf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ian simi ra, nga ta no simi asoung. O kap pevien va o ta nongie mi Tam kenga, ");
INSERT INTO tbf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","simi vunan mi Tam kesen a tovie nga, surie nga te nga tovie iou ma nga te nga vodovodon tuktuk seou va o nga kuvu se Raban. ");
INSERT INTO tbf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","O nga kuvu simi Tam nge beit simi mangmagoso enaenamon. Ma o ta sorvekenan ine mi mangmagoso enaenamon nge muerengei rakot simi Tam.” ");
INSERT INTO tbf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Samo ken sar madar tovtov e Iesu gi nga pevien, “Pare, e nangba vakokoit katsep, ma e kap vakokoit ngan te bu nama puppuo. ");
INSERT INTO tbf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ine, gei nangba katsep va e telekiran bu kepineits kokouk, ma e kap pinat surie ka mei va ta vosuoreie no ngan kavo virevirei. Io, gei vodovodon tuktuk va e nga kuvu se Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","E Iesu a nga kuil nama, “Nga te vodovodon tuktuk nangba? ");
INSERT INTO tbf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nga rorong! Mi keipkepide ra ta beit, ma a te beit va nga ta mon vepitsitsei, mi mei keskes si ken enamon. Nga ta sorvekena iou, eiekesen o kap mon keseung, simi vunan mi Tam a mon meie iou. ");
INSERT INTO tbf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“O te pengan senga ine bu kepineits, terengien va nga ta mang suvuon mi molu surie iou. I aron mi mangmagoso enaenamon nga ta suvuon mi tsienakor leong, eiekesen bu aronga ta ngas ngeisngeis! Simi vunan o te tseiptseiprio mi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","I murien e Iesu tate nga vokokotie ine bu kepineits, a nga dedeng kien i kur simi rangit nge pevien, “Tama, mi keipkepide ra a te beit. Vutuir vasangan man matvinavaso e Natu, terengien va e Natu ta vutuir vasangan ma matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","E te nga terie sien mi duis va ta kovan mi kulou kokouk terengien va ta mang terie mi tino rovoriu segie ese e tate nga terie sien. ");
INSERT INTO tbf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ine arie mi tino rovoriu, va gi ta mang telekira no, evoi mi Raban tuktuk a kes mo, ma buer va gi ta telekiran e Iesu Karisito ese e ta nga ture nemei ngan. ");
INSERT INTO tbf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","O nga vutuir vasangan ma matvinavaso simi kaber surie o te tsang vaton ine mi tsientsang e ta nga terie seou nia tsana. ");
INSERT INTO tbf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ine, Tama, vutuir vasangan mong matvinavaso i mata ngan mi matvinavaso ian nata ta nga suvuon i muan mi vinagoso. ");
INSERT INTO tbf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ma o te nga vasanga no segie ese e ta nga terie seou kuvu simi mangmagoso enaenamon. Egie sevoi ma e nga terie gie seou ma gi nga vemusurie ke sar nama. ");
INSERT INTO tbf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ine, gi te telekiran va bu kepineits kokouk e ta nga terie seou, a kovuni sevoi. ");
INSERT INTO tbf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bu nama kokouk e ta nga terie seou, o te terie segie ma gi te suvuon. Ma gi katsep tuktuk va o nga kuvu sevoi, ma gi vodovodon tuktuk va e nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","O no kegie. O kap no ken mi mangmagoso enaenamon, eiekesen kegie ese e ta nga terie seou simi vunan egie sevoi. ");
INSERT INTO tbf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mi kulou kokouk ian va seou, arie sevoi, ma ian va sevoi, arie seou. Ma egie gi nga vutuir vasangan mong matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","O ta kap ba mon simi mangmagoso enaenamon, eiekesen egie gi ngas mon simi mangmagoso enaenamon. Ma o nemei sevoi. Tama melemelen, pernge gie ngan mi asa, mi as ian e tate nga terie seou, terengien va gi ta mang tsorubeit kes malan enatau nata ta kes. ");
INSERT INTO tbf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sien o ta nga mon meie gie, o nga pernge gie ngan mi asa ian e tate nga terie seou. Ma o nga pernge gie va kap ka mei segie ta nga tsereiv. Eiekesen mi mei mo ese tate nga mon ine simi rosar nia tsereiv terengien va mi Pakpak Leong ta mang tsorubeit tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ma ine, o nemei sevoi ma o nga vokokotie ine bu kepineits simi ra o ta ngas nga mon simi mangmagoso enaenamon terengien va gi ta mang suvuon kong nires ian va ta tsorubeit tuktuk si kegi tino. ");
INSERT INTO tbf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma ke nama o te nga terie segie eiekesen mi mangmagoso enaenamon a nga karto gie, simi vunan a kap va egie mi kuoluon mi mangmagoso enaenamon malan eou buer kap va mi kangien mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","O kap nongie no va e ta por tsana gie ine simi mangmagoso enaenamon, eiekesen va e ta pernge gie simi Tsaka Ka. ");
INSERT INTO tbf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A kap va egie mi kuoluon mi mangmagoso enaenamon malan eou buer kap va mi kangien mi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Vokunie gie ngan mi tuktuk. Ke nama eie mi tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Malan e ta nga tura iou nemei simi mangmagoso enaenamon, eou buer o te nga tura gie rakot simi mangmagoso enaenamon. ");
INSERT INTO tbf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","O nga teir putan kong tino sevoi nian magi kalekalei, terengien va egie buer gi ta mang teir putan tuktuk kegi sar tino sevoi. ");
INSERT INTO tbf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kong nono a kap va surie gie mo, eiekesen o no buer surie egie ese va gi ta so vodovodon tuktuk seou surie kegi sar nama vavakatsep kong sar madar tovtov. ");
INSERT INTO tbf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tama, malan enatau nata ta kes, egie buer gi ta tsorubeit kes nge tsok senatau, terengien va mi mangmagoso enaenamon ta mang vodovodon tuktuk va e te nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi matvinavaso e tate nga terie seou, o te terie segie terengien va gi ta mang tsorubeit kes malan enatau nata ta kes. ");
INSERT INTO tbf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Egei gei kes ma enatau nata kes. Surie ine, gi ta mang tsorubeit kes tuktuk terengien mi mangmagoso enaenamon ta telekiran va e nga tura iou, ma e nga tovie gie malan e ta nga tovie iou. ");
INSERT INTO tbf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tama, o lalaron va egie ese e ta nga terie seou, gi ta mon meie iou ivie o ta mon en, terengien va gi ta mang pare mong matvinavaso ian e tate nga terie seou surie e nga tovie iou i muan mi vinagoso. ");
INSERT INTO tbf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tama, e duis rovoriu. Mi mangmagoso enaenamon a kap telekira no, eiekesen eou o telekira no. Ma egie ine gi telekiran va e nga tura iou. ");
INSERT INTO tbf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma o te nga penge vakatsepa mi asa segie, ma o ta vavakatsep ngas segie, terengien mi tentoiv e ta nga tovie iou ngan ta mang mon i arogie ma eou buer o ta mang mon i arogie.” ");
INSERT INTO tbf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sien e Iesu tate nga no voto, a nga tsourarak meie ken sar madar tovtov simi malaev i Kidron. Ma ian en mi tau a nga mon. Ma e Iesu ma ken sar madar tovtov gi nga rubukien en. ");
INSERT INTO tbf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","E Iudas ese ta nga roev terie e Iesu, a nga telekiran ian mi korot, simi vunan palan bu ra e Iesu ma ken sar madar tovtov gi nga ko ra beit kouk en. ");
INSERT INTO tbf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Samo e Iudas a nga kerie mi kulou ni minakiur sibu Roma ma mi kulou nennei simi Vona rengeir leong rakot ian simi tau. Io, bu prist leong meie bu Parisaio gi nga tura gie ese gi ta nga sorokie bu bember, a, bu berber, ma bu kepineits nia veveken. ");
INSERT INTO tbf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","E Iesu a nga telekiran bu kepineits kokouk va ta nga tsorubeit sien, ma a nga veis rovotsour nge vereie gie, “Ese nga nesie?” ");
INSERT INTO tbf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gi nga kuil nama, “E Iesu kovuni i Nasaret.” E Iesu a nga pevien, “Arie eou mo ine.” E Iudas ese ta nga roev terie e Iesu a nga tuir meie gie. ");
INSERT INTO tbf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Io, sien e Iesu ta nga oeng segie, “Arie eou mo ine,” gi nga so muer nge kor mutur i keim. ");
INSERT INTO tbf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Samo e Iesu a te buer nga vereie gie, “Ese nga nesie?” Gi nga pevien, “E Iesu kovuni i Nasaret.” ");
INSERT INTO tbf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","E Iesu a nga kuil nama, “O te pengan senga va arie eou mo ine. Sien va nga ta nesie iou, nga tsupuk rivie gie ine.” ");
INSERT INTO tbf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A nga pevien ine nia vara tuktuk ngan mi nama ta nga vokokotie, “Tama o kap rivie ka mei kes segie ese e ta nga terie seou.” ");
INSERT INTO tbf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","E Simon Petro a nga suvuon ken kuor kenken, ma a nga teie vorotsoruo nge ravan ma a nga tseir rivie mi tateringan ken petspets mi kovan bu prist. Mi asan ine mi petspets e Malko. ");
INSERT INTO tbf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","E Iesu a nga oeng se Petro, “Teir muerngan ke kuor si man sovsov! Vasa, o ta kap un te ine simi koi e Tamoung ta nga terie seou?” ");
INSERT INTO tbf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Samo mi kulou ni minakiur sibu Roma meie magi muomuo ma bu ka nennei simi Vona rengeir leong, gi nga rakopie e Iesu nge visie. ");
INSERT INTO tbf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma gi nga muna kir terie se Annas, eie e taman ken vevien e Kaiapas ese ta nga kovan bu prist ian simi avareit. ");
INSERT INTO tbf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","E Kaiapas arie eie ese ta nga vanuo bu Iuda va ta kalei sien va ka ka kes ta maet surie mi kulou kokouk. ");
INSERT INTO tbf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","E Simon Petro ma mi madar tovtov mene guor nga vemusurie e Iesu. Mi kovan bu prist a nga telekiran ine mi madar tovtov, ma a nga nomeie e Iesu rakot i mararan ken vonuo mi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Eiekesen e Petro a nga mon i marar i babaren mi rumrubukien. Io, ine mi madar tovtov, ese mi kovan bu prist ta nga telekiran, a nga muerengei rovotsour nge ra oeng simi tetsikevien ta nga naneie mi rumrubukien nge kir vurukude e Petro. ");
INSERT INTO tbf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ine mi tetsikevien ta nga tuir simi rumrubukien a nga vereie e Petro, “Arie evoi buer mi meinmenigie ine bu madar tovtov ine simi ka, nge?” E Petro a nga kuil nama, “Eou kap.” ");
INSERT INTO tbf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mi tunga ra te, io, mi kulou nennei simi Vona rengeir leong ma bu petspets gi te nga tsinga mi leing ma gi nga tuir viririsie nge mariur sien. Ma e Petro a nga tuir meie gie nge mariur. ");
INSERT INTO tbf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mi kovan bu prist a nga vereie e Iesu surie ngan ken sar madar tovtov ma ken sar namani vinasengei. ");
INSERT INTO tbf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","E Iesu a nga kuil nama sien, “O nga ko vakokoit i matan bu mei kokouk ma o nga ko vavasengei i aron bu vona rengeir sibu Iuda ma mi Vona rengeir leong, ivie mi kulou gi ta ko beit kokouk en. Ma o kap nga vakokoit muningan kavo kepineits. ");
INSERT INTO tbf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Surie misa nga ta vosuoreie iou? Vosuoreie mi kulou gi ta nga ko rongomie iou. Gi telekiran misa o tate nga vokokotie.” ");
INSERT INTO tbf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sien e Iesu ta nga vakokoit ven ne, mi ka nennei ian ta nga tuir i babaren a nga pantsie nge pevien, “Ke sinavei nia kuil nama simi kovan bu prist, arie ta malan ian?” ");
INSERT INTO tbf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","E Iesu a nga kuil nama sien, “Sien va o vokokotie ka tsaka nama, e ta vakokoit vakatsepa misa a tsak. Eiekesen sien va o vokokotie mi nama duis, surie misa e ta pantsie iou?” ");
INSERT INTO tbf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ma gi kap ngas nga ruom rivie mi suo sien. Io, e Annas a nga turan rakot se Kaiapas, mi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","E Simon Petro a ngas nga tuir nge mariur, io, bu mei gi nga pevien sien, “Arie evoi buer ken madar tovtov ine mi ka, va gerek?” Eiekesen e Petro a nga vamoi nge pevien, “Eou kap.” ");
INSERT INTO tbf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma ken petspets mi kovan bu prist, eie e patsan ian mi ka e Petro ta nga tseir rivie mi tateringan, a nga pevien, “Vasa, o nga pare no sien e ta nga mon meie i tau?” ");
INSERT INTO tbf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Samo e Petro a te buer nga vamoi ma ian ngas te mi to a nga kurkuku. ");
INSERT INTO tbf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tsoruvovo mokuopkuop, gi nga vavasie e Iesu kuvu simi vonuo se Kaiapas rakot si ken vonuo mi gavana. Ma bu Iuda gi kap nga rubukien simi vonuo, simi vunan gi kap nga lalaro pop vuturungie kegi vinuor nge vara bita nge gie i matan kegi vinuor, terengien va gi ta mang nga nganie mi Nginu Pasova. ");
INSERT INTO tbf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Io, e Pilato mi gavana a nga rovotsour surie gie nge virei, “Surie misa nga lalaro voturie ine mi ka simi vinuor?” ");
INSERT INTO tbf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Gi nga kuil nama, “Sien va a kap va eie mi ka tsokor, va gei kap kir terie sevoi.” ");
INSERT INTO tbf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","E Pilato a nga oeng segie, “Enga ngas te, nga ta vuortie ngan kenga vinuor.” Gi nga kuil nama, “Gei kap suvuon mi duis nia terie ka mei simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gi nga vakokoit malan ine nia tsang vaotie mi nama e Iesu ta nga peterie surie mi sana suada miensei va ta nga maet sien. ");
INSERT INTO tbf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","E Pilato a nga muerengei rubukien i aron mi vonuo ma a nga vereie e Iesu, “Arie evoi mi kovakova ka leong sibu Iuda?” ");
INSERT INTO tbf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","E Iesu a nga kuil nama, “Ine mi virevirei a kuvu sevoi kese? O, bu mei gi pengan be mo sevoi surie iou?” ");
INSERT INTO tbf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","E Pilato a nga kuil nama, “Eou kap va mi kangi Iuda. Ke sar nama kes ma bu prist leong gi terie no seou. Misa e nga tsana?” ");
INSERT INTO tbf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","E Iesu a nga kuil nama, “Kong mangmagoso Nguts a kap mon ine simi mangmagoso enaenamon. Sien va kong mangmagoso Nguts a mon ine simi mangmagoso enaenamon, va kong sar petspets gi veveken karie iou terengien va bu muomuo sibu Iuda gi ta kap mang rakopie iou. Eiekesen kong mangmagoso nguts a kap mon en ne.” ");
INSERT INTO tbf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Io, e Pilato a nga vereie, “Arie evoi mi kovakova ka leong, nge?” E Iesu a nga kuil nama, “A duis e ta pevien va eou mi kovakova ka leong. Gi nga kava iou ma o nga nemei ine simi mangmagoso enaenamon nia vavatei katsep ngan mi tuktuk. Egie ese gi ta tino ngan mi tuktuk gi ta rorong seou.” ");
INSERT INTO tbf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","E Pilato a nga virei, “Ma misa ine mi tuktuk?” Samo a nga muerengei rovotsour i marar simi kulou nge pevien, “O kap vorotan ka kepineits nia voturie eie simi vinuor. ");
INSERT INTO tbf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Eiekesen simi sinavei sibu tubunga, o ta ngas vara ketseketseng ngan ka ka tsatsang vinatoreis simi Nginu Pasova. Nga lalaron va o ta vara ketseketseng ngan ine mi kovakova ka leong sibu Iuda?” ");
INSERT INTO tbf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Gi nga kuil nama sien nge koup, “A kap va eie, eiekesen e Barabas!” E Barabas eie mi ka kenken. ");
INSERT INTO tbf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Io, e Pilato a nga kerie e Iesu nge oeng va gi ta nga beilbeiltsie. ");
INSERT INTO tbf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma mi kulou ni minakiur gi nga ruonie man kovage ngan mi suo tsotso nge vavatsekie ngan mi kovan. Ma gi nga vavatsekie ngan mi lavlav dav. ");
INSERT INTO tbf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ma gi nga vakaek nge nemei sien nge pevien, “E ta tino kuar mi kovakova ka leong sibu Iuda!” Ma gi nga me pantsie mi matan. ");
INSERT INTO tbf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","E Pilato a te buer nga rovotsour i marar nge oeng segie bu Iuda, “Pare, o ta kir vorotsoruo nemei senga va nga ta mang pare va o kap vorotan ken ka tsienakor.” ");
INSERT INTO tbf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Io, e Iesu a nga rovotsour teie mi kovage suo tsotso i kovan ma mi lavlav dav i kurikurien. E Pilato a nga oeng segie, “Nga pare, ine arie mi ka!” ");
INSERT INTO tbf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sien bu prist leong ma bu ka nennei simi Vona rengeir leong gi ta nga dengarie, gi nga koup, “Vetekiuo simi koitskoits! Vetekiuo simi koitskoits!” Eiekesen e Pilato a nga oeng segie, “Nga ta kerie nge ra vetekiuo simi koitskoits. Eou o kap vorotan ken ka tsienakor ine mi ka.” ");
INSERT INTO tbf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bu Iuda gi nga kuil nama, “Gei suvuon mi vinuor. Ma vemusurie ine mi vinuor, eie ta ngas maet simi vunan a nga pevien va eie e Natuon e Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sien e Pilato ta nga rongomie ine, a nga motou beitsak. ");
INSERT INTO tbf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma a nga muerengei rubukien simi vonuo se gavana ma a nga vereie e Iesu, “Evoi kuvu ivie?” Eiekesen e Iesu a kap nga terie sien ka nama kuilkuil. ");
INSERT INTO tbf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","E Pilato a nga oeng sien, “E ta kap vokokotie ka nama seou, nge? Vasa, e kap telekiran va o suvuon mi ngeisngeis nia vara ketseketseng nge no, o, nia vetekiuo no simi koitskoits?” ");
INSERT INTO tbf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","E Iesu a nga kuil nama, “Sien va e Raban die i kur simi rangit a kap nga terie sevoi mi duis, va e kap suvu ngeisngeis nia vuortie iou. Io, mi kulou gi ta nga terie iou sevoi, gi suvuon mi sinavei tsokor a leong beitsak.” ");
INSERT INTO tbf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Io, e Pilato a nga vakaek nge nesie ka rosar nia ruom rivie e Iesu. Eiekesen bu Iuda gi nga koup, “Sien va e ta ruom rivie ine mi ka, a kap va evoi e palapalan e Kaesar. Eie ese ta pevien va eie mi kovakova ka leong, eie a matakorot meie e Kaesar.” ");
INSERT INTO tbf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sien e Pilato ta nga rongomie ine, a nga kir vorotsoruo e Iesu i marar, ma a nga mogos simi mogomogos nia vuor simi korot gi ko vuotongie ngan i Tsur Vunavout, simi namani Iburu gi vuotongie va i Kapata. ");
INSERT INTO tbf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma a te nga sisiat potaram simi ra i muan mi Nginu Pasova. E Pilato a nga pevien sibu Iuda, “Ine arie manga kovakova ka leong!” ");
INSERT INTO tbf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Samo gi nga koup, “Ken rivie! Ken rivie! Vetekiuo simi koitskoits!” E Pilato a nga vereie gie, “Nga lalaron va o ta vetekiuo manga kovakova ka leong?” Bu prist leong gi nga kuil nama, “Gei kap suvuon ka kovakova ka leong mene eiekesen e Kaesar mo.” ");
INSERT INTO tbf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Io, e Pilato a nangba nga terie e Iesu i naparimagie nia vetekiuo simi koitskoits. Io, mi kulou ni minakiur sibu Roma gi nga kir tsana e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma e Iesu a nga rovotsour nge sorokie man koitskoits, ma a nga beit simi korot gi vuotongie ngan i Paptikov, simi namani Iburu i Golgota. ");
INSERT INTO tbf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ian en, gi nga vetekiuo e Iesu simi koitskoits, ma gi nga vetekiuo buer ba ka luo mene. Mi mei kes si ken bieng suv ma mi mei mene si ken bieng kieir ma e Iesu i kotubuguor. ");
INSERT INTO tbf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","E Pilato a nga tuturei nia vataro mi vinavataor nge terie i kovan mi koitskoits. A nga aes malan ine; IESU KOVUNI I NASARET, MAGI KOVAKOVA KA LEONG BU IUDA. ");
INSERT INTO tbf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Palan mi kulou gi nga ase ine simi vunan mi korot gi ta nga vetekiuo e Iesu en, a nga vatavatat simi taon leong. Ma gi nga vataro simi namani Iburu, Latin ma Grik. ");
INSERT INTO tbf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Io, bu prist leong gi nga oeng se Pilato, “Kian va e ta vataro va ‘Magi kovakova ka leong bu Iuda’, eiekesen ‘Ine mi ka a nga pevien, eou magi kovakova ka leong bu Iuda.’” ");
INSERT INTO tbf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","E Pilato a nga kuil nama, “Misa o tate vataro, o te vataro.” ");
INSERT INTO tbf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I muir sien gi ta nga vetekiuo e Iesu simi koitskoits, ba ka ni minakiur gituo nga poro man sar tsetstseik ka i marar nge potakie i kotubugituo ba ka voveit. Ma gituo nga poro buer man tsetstseik ka i ruom gi ta nga tsana ngan mi lavlav kuar. ");
INSERT INTO tbf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma mi kulou ni minakiur gi nga pevien segie kesegie, “Kian va giet ta derikie. Giet ta paluo satu nge derie va ese ta mang poro.” Ine mi kepineits a nga tsorubeit ni vara tuktuk ngan mi nama simi Pakpak Leong ian ta pevien, “Gi nga potakie mong sar tsetstseik i kotubugie ma gi nga paluo satu surie mong tsetstseik.” Ma ine arie misa mi kulou ni minakiur gi ta nga tsana. ");
INSERT INTO tbf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","E kinan e Iesu, e kasien vevien, e Maria ken vevien e Klopas ma e Maria Magadala, gi nga tuir i babaren man koitskoits e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sien e Iesu ta nga pare e kinan ma mi madar tovtov ian mi aten guor ta nga tuir vatavatat, a nga pevien se kinan, “Vevien, pare, ine arie e natu.” ");
INSERT INTO tbf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Samo a nga pevien simi madar tovtov, “Pare, ine arie e kina.” Vakaek ian simi ra, ine mi madar tovtov a nga naneie e kinan e Iesu si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","I muir sien, e Iesu a nga telekiran va ine bu kepineits a te nga voto. Ma a nga pevien, “O moruo,” ine nia vaotie bu nama simi Pakpak Leong. ");
INSERT INTO tbf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mi gonggoi ta nga vous nge dangi vain monour a nga mon. Io, gi nga vosuvie mi poko dondou ine simi dangi vain monour ma gi nga ror terie simi rakaraka ei nge vutuirse terie i ngutsuon. ");
INSERT INTO tbf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","E Iesu a nga unumie ma a nga pevien, “A te voto.” Samo a nga vosogule mi kovan ma a nga tsupuk rivie mi morumoruan. ");
INSERT INTO tbf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Io, arie mi ra nia rorois nian mi Rangi Minaes ma mi Nginu Pasova. Bu Iuda gi kap nga lalaron va bu pirpir va gi ta nga mon simi koitskoits simi Rangi Minaes, surie ine mi Rangi Minaes eie a tamat rovoriu. Ma gi nga vereie e Pilato va ta nga tor va gi ta nga dokie bu legelegegituo ma gi ta nga poro ba piripirigituo peuk i keim. ");
INSERT INTO tbf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Io, mi kulou ni minakiur gi nga ra dokie ba legelegen mi ka vourvour gi ta nga vetekiuo simi koitskoits i bingan e Iesu ma samo simi ka vorosurie. ");
INSERT INTO tbf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Eiekesen sien gi ta nga nemei se Iesu, gi nga dengarie va a te nga maet. Ma gi kap nga dokie te ba legelegen. ");
INSERT INTO tbf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Eiekesen mi meinmenien mi kulou ni minakiur a nga tsoka mi baban e Iesu ngan ken biul, ma ian ngas te mi dar ma mi da guor nga so rovotsour. ");
INSERT INTO tbf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma ian mi ka ta nga derie misa ta nga tsorubeit, a nga vavatei katsep ngan ine bu kepineits terengien va enga buer nga ta mang vodovodon tuktuk. Ken vinavatei vavakatsep a tuktuk. Ma a nga telekiran va a vavatei ngan mi tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ine bu kepineits a nga tsorubeit, terengien va gi ta vaotie misa mi Pakpak Leong ta pevien, “Kap ka tsir kes sien ta so korot,” ");
INSERT INTO tbf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ma buer mi nama mene simi Pakpak Leong a pevien, “Mi kulou gi ta so dengarie eie ese gi ta nga tsoka.” ");
INSERT INTO tbf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","I muir sien, e Iosep kovuni i Arimatea a nga nongie e Pilato va ta tor va ta nga poro mi piripirien e Iesu. (E Iosep buer a nga ko vemusurie e Iesu, eiekesen a nga ko mumuningei simi vunan a nga motovan bu muomuo sibu Iuda.) E Pilato a nga sunuir va e Iosep ta nga suvuon mi piripirien e Iesu. Io, e Iosep a nga rakot nge por tsana. ");
INSERT INTO tbf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","E Nikodemo, ese ta be nga muna ra vorotan e Iesu sikati, a nga nomeie e Iosep. A nga sorokie ba sinangavur tour kilogram mi mira ian ta nga lakie meie ngan mi dangi alovera. ");
INSERT INTO tbf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ma guor nga poro mi piripirien e Iesu nge ra gulie ngan man lavlav kuar meie bu sien sosong vemusurie mi sinavien bu Iuda gi ta nga ko tsatsang rorois simi tienteir. ");
INSERT INTO tbf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ian simi korot gi ta nga vetekiuo en e Iesu simi koitskoits, mi tau a nga mon en, ma ian en buer mi monmon vour ivie gi kap ngas nga vuturungie ka tonuo en. ");
INSERT INTO tbf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Guor nga vuturungie mi piripirien e Iesu en simi vunan ian mi ra eie mi ra nia rorois nian mi Rangi Minaes ma sien ine mi korot a mang nga vatavatat. ");
INSERT INTO tbf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sivovo mokuopkuop simi ra vourvour simi wik, e Maria kovuni i Magadala a nga vo rakot ine simi monmon ma a si nga pare va mi vunavout gi te nga vuvuil rivie i matan mi monmon. ");
INSERT INTO tbf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Io, a nga soer rakot se Simon Petro ma mi madar tovtov mene ian mi aten e Iesu, ma a nga pevien seguor, “Gi te por tsana mi Nguts simi monmon, ma gei kap telekiran ivie gi te terie en!” ");
INSERT INTO tbf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ma e Petro meie ngan ian mi madar tovtov guor nga rakot ine simi monmon. ");
INSERT INTO tbf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Eguor kokouk guor nga soer, eiekesen ian mi madar tovtov a nga soer rio e Petro. Ma a nga muna so beit simi monmon. ");
INSERT INTO tbf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A nga tsologout nge dedeng i aron mi monmon ma a nga pare bu lavlav, eiekesen a kap nga rubukien. ");
INSERT INTO tbf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Samo e Simon Petro a nga so beit nge rubukien simi monmon. Eiekesen a si nga pare mo bu lavlav gi ta nga mutur. ");
INSERT INTO tbf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma mi kato lavlav gi ta nga ovutie ngan mi kovan e Iesu, a kap nga mutur meie ian bu lavlav, eiekesen a nga vil mutur kesen. ");
INSERT INTO tbf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Samo ian mi madar tovtov ta nga muna so beit simi monmon, a nangba nga rubukien nge dengarie ma a nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Eiekesen gi kap ngas nga katsep kalei simi Pakpak Leong ian ta pevien va eie ta to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Samo ba madar tovtov guor nga veis muerengei rakot i marar. ");
INSERT INTO tbf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","E Maria a nga tuir nge ta i marar simi monmon. Sien ta ngas nga vor ve tata, a nga tsologout nge dedeng rubukien simi monmon. ");
INSERT INTO tbf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma a nga pare ba angelo luo guor nga vavaso ngan bu tsetstseik puneits ma guor nga mogos simi korot mi piripirien e Iesu ta nga mutur en. Mi mene kes i koruongen ma mi mei mene i pakaken. ");
INSERT INTO tbf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ma guor nga vereie ine mi vevien, “Misa e tengisie?” Ma a nga kuil nama seguor, “Gi te me por tsana mong Nguts, ma o kap telekiran ivie gi te terie en.” ");
INSERT INTO tbf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sien tate nga pevien ne, a nga vuvuris nge pare e Iesu ta nga tuir i pek lili, eiekesen a kap nga telekiran va eie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","E Iesu a nga vereie, “Vevien, misa e tengisie? Ese e lalaro pare?” E Maria a si nga vodon va ine mi ka eie mi ka tsatsang simi tau. Ma a nga oeng sien, “Sien va evoi e poro nge terie si ka korot mene, ma pengan seou ivie e terie en. Ma o ta rakot nge ra poro.” ");
INSERT INTO tbf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","E Iesu a nga oeng sien, “Maria!” E Maria a nga vuvuris matan veie nge oeng sien ngan mi namani Iburu, “Raboni!” (Man vuevue va, ‘mi vavvasengei’.) ");
INSERT INTO tbf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma e Iesu a nga oeng sien, “Kian va e ta soburo iou simi vunan o kap ngas muerengei kien se Tamoung. Eiekesen rakot sibu kasiung nge pengan segie va o tate muerengei kien se Tamoung ma e Tamanga, eie mong Raban ma manga Raban.” ");
INSERT INTO tbf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Io, e Maria kovuni i Magadala a nga rakot nge ra vateie bu madar tovtov va a te nga pare mi Nguts. Ma a nga pengan segie misa e Iesu ta nga pengan sien. ");
INSERT INTO tbf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sireivreiv seserigo ian simi ra vourvour simi wik, bu madar tovtov gi te nga me oir kouk. (Ma gi te nga tsekitie mi matavanuo, simi vunan gi nga motovan bu muomuo sibu Iuda.) Samo e Iesu a nga nemei nge me tuir i kotubugie ma a nga pevien ne, “Mi molu ta mon meie nga!” ");
INSERT INTO tbf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I muir sien tate nga vakokoit segie, a nga vasangan segie ba riman ma mi baban. Ma bu madar tovtov gi nga res beitsak sien gi ta nga pare mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma e Iesu a nga oeng segie te buer, “Mi molu ta mon meie nga! Malan e Tamoung ta nga tura iou, io, eou buer o ta tura nga.” ");
INSERT INTO tbf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Samo a nga kuiv terie ken mour segie ma a nga pevien, “Nga suvuon mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sien va nga ta vodon rivie kegi sar sinavei tsokor bu mei mene, gi te ketseketseng. Sien va nga ta kap vodon rivie kegi sar sinavei tsokor, gi kap ketseketseng.” ");
INSERT INTO tbf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mi mei segie mi sinangavur kes ma luo bu madar tovtov, e Tomas (gi ko vuotongie va e Didimas) a kap nga mon meie gie sien e Iesu ta nga beit. ");
INSERT INTO tbf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Io, bu madar tovtov gi nga pengan sien, “Gei te pare mi Nguts!” E Tomas a nga oeng segie, “Sien va o ta kap pare bu nia nil siba riman nge tsure terie mi pitsipitsirimoung sibu nia nil nge tsure terie mi rimoung simi nia eon i baban, o kap oit nia vodovodon tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","I murien bu ra mi napaririem potsu tour, bu madar tovtov gi nga beit kouk te buer i aron mi vonuo ma e Tomas a nangba nga mon meie gie. Io, gi nga tsekitie bu matavanuo eiekesen e Iesu a nga beit nge me tuir i kotubugie nge pevien, “Mi molu ta mon meie nga!” ");
INSERT INTO tbf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma a nga pevien se Tomas, “Tsure terie mi pitsipitsirima en ne, nge pare ba rimoung. Ma tsuran mi rima ine i baboung. Kian va e ta basbaslieng si ke vodovodon tuktuk. E ta ngas vodovodon tuktuk.” ");
INSERT INTO tbf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","E Tomas a nga kuil nama sien, “Mong Nguts ma mong Raban!” ");
INSERT INTO tbf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","E Iesu a nga oeng sien, “E te vodovodon tuktuk nangba simi vunan e te pare iou? Mi nires leong segie ese gi ta vodovodon tuktuk misasien gi ta kap pare iou.” ");
INSERT INTO tbf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Io, i matan ken sar madar tovtov, e Iesu a nga tsana palan bu totourlekier ni vovokudier ian gi ta kap mon i aron ine mi pakapaka rorou. ");
INSERT INTO tbf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Eiekesen ine o nga vataro va nga ta ngas vodovodon tuktuk va e Iesu eie mi Messia e Natuon e Raban. Ma surie kenga vodovodon tuktuk simi asan, nga ta mang suvuon mi tino. ");
INSERT INTO tbf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","I murien ine, e Iesu a nga tsorubeit vasvas te buer si ken sar madar tovtov simi barateis i Tiberias. A nga tsorubeit vasvas segie ven ne. ");
INSERT INTO tbf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","E Simon Petro, e Tomas gi ta vuotongie va e Didimas, e Natanael kovuni i Kana simi enamon leong i Galili, a, ba natuon e Sebedi, ma ba madar tovtov luo mene, gi nga mon kokouk. ");
INSERT INTO tbf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","E Simon Petro a nga oeng segie, “O ta be ra vongon,” ma gi nga pevien, “Gei ta nomeie no.” Io, gi nga rovotsour nge ka simi galeu eiekesen ian simi kati gi kap nga sovie ka ie rovrovoriu. ");
INSERT INTO tbf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Simi sir tate nga kapot, e Iesu a nga tuir i koen. Eiekesen bu madar tovtov gi nga bangata e Iesu. ");
INSERT INTO tbf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Samo a nga vereie gie, “Bu natung, nga sovie kavo ie?” Gi nga kuil nama, “A kap.” ");
INSERT INTO tbf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma a nga oeng segie, “Nga ra vululusie kenga ben simi bienengeiv suv simi galeu, ma nga ta sovie kavo ie.” Io, gi nga vululusie kegi ben ma samo gi kap nga oit nia te vavane muerngan terie i aron mi galeu simi vunan gi nga sovie bu ie palan beitsak. ");
INSERT INTO tbf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma mi madar tovtov ian mi aten e Iesu, a nga oeng se Petro, “Arie eie mi Nguts!” Sien e Petro ta nga rongomie va eie mi Nguts, a nga tsekie man tsetstseik ka i marar (simi vunan a nga kaor rivie sien ta nga tsatsang) ma a nga tsibour i rou. ");
INSERT INTO tbf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bu madar tovtov mene gi ta nga ka simi galeu, gi nga vuruos tateie mi ben vatare i koen tate nga vous nge ie, simi vunan a kap nga pek kuvu i koen. A nga malan va bu sinangavur napaririem potsu voveit (90) bu mita mo. ");
INSERT INTO tbf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Sien gi ta nga me tsour vataer i koen, gi nga me pare mi leing ta nga ngang meie ba ie i popon ma ba tsoik. ");
INSERT INTO tbf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","E Iesu a nga oeng segie, “Nga por nemei ngan ine kavo ie ian nga ta sovie gie.” ");
INSERT INTO tbf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","E Simon Petro a nga peuk nge teie vatare mi ben i koen. Ine mi ben a nga vous ngan bu ie leong. A nga oit mi sinangavur kes koboit ma bu sinangavur mi napaririem ma a tour i popon (153) kokouk. Misasien ta nga palan bu ie, ine mi ben a kap nga kabem. ");
INSERT INTO tbf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","E Iesu a nga oeng segie, “Nga nemei nge me ngou.” Eiekesen a kap ka madar tovtov a nga aor ngeisngeis nia vereie va, “Evoi ese?” simi vunan gi nga kielala va eie mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Io, e Iesu a nga me poro mi tsoik nge terie segie, ma a nga tsang malan ngan buer simi ie. ");
INSERT INTO tbf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ine arie mi keipkepide ra a tourngan e Iesu a nga tsorubeit vasvas sibu madar tovtov i murien ta nga to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Io, sien gi tate nga ngou voto, e Iesu a nge pevien se Simon Petro, “Simon, natuon e Ioanes. E tovie iou beitsak rio bu mei ka ine gi ta tovie iou?” A nga kuil nama, “Io, mi Nguts. E telekiran va o tovie no.” E Iesu a nga oeng sien, “Tabarie kong sar natu sipsip.” ");
INSERT INTO tbf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mi keipkepide ra a luongan e Iesu a te buer nga pevien sien, “Simon, natuon e Ioanes. E tovie iou?” A nga kuil nama, “Io, mi Nguts, e telekiran va o tovie no.” E Iesu a nga oeng sien, “Naneie kong sar sipsip.” ");
INSERT INTO tbf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mi keipkepide ra a tourngan e Iesu a nga pevien sien, “Simon, natuon e Ioanes. E tovie iou?” E Petro a nga aor putu simi vunan e Iesu a te nga virei votourngan, “E tovie iou?”. Ma a nga oeng sien, “Mi Nguts, e telekiran bu kepineits kokouk, ma e telekiran va o tovie no.” E Iesu a nga oeng sien, “Tabarie kong sar sipsip.” ");
INSERT INTO tbf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“O oeng tuktuk sevoi. Sien e ta ngas nga ka vour, evoi kese e nga ko vevveleis rorois nge rakot sibu korot e ta lalaro rakot en, eiekesen sien va e ta so komois, e ta so kadosan ba rima ma ka mei ta so verengie no nge kir terie no simi korot e ta kap lalaro rakot en.” ");
INSERT INTO tbf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A nga pevien ne nia vasangan mi suada miensei e Petro va ta nga suvuon nia vutuir vasangan man matvinavaso e Raban. Samo e Iesu a nga oeng sien, “Vemusurie iou!” ");
INSERT INTO tbf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","E Petro a nga vuris nge pare ine mi madar tovtov ian mi aten e Iesu ta nga vemusurie gie. Ine arie ese ta nga vevedikeir se Iesu simi Nginu Pasova nge pevien, “Mi Nguts, ese ta so roev terie no?” ");
INSERT INTO tbf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Io, sien e Petro ta nga dengarie, a nga virei, “Mi Nguts, ma vasa ngan eie ine?” ");
INSERT INTO tbf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","E Iesu a nga kuil nama, “Sien va o lalaron va eie ta mon oit va o ta muerengei, evoi ke sana baitutuir sien? Evoi, vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Io, ine mi nama a nga soer i kotubugie mi kulou gi ta nga ko vemusurie e Iesu va ine mi madar tovtov va ta kap maet. Eiekesen e Iesu a kap nga pevien va ta kap maet. A nga pevien, “Sien va o lalaron va eie ta mon oit va o ta muerengei, evoi ke sana baitutuir sien?” ");
INSERT INTO tbf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ine arie mi madar tovtov ta nga vavatei katsep ngan ine bu kepineits nge vavataor vuturungie, ma gei telekiran va misa ta nga vavatei ngan a tuktuk. ");
INSERT INTO tbf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","E Iesu a nga tsana palan bu kepineits mene. Sien va ine bu kepineits kokouk o nga vavataor vuturungie, o vodon mi mangmagoso enaenamon kokouk a kap oit nia suvuon bu pakapaka rorou kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ka leong Tiopilus. Si kong vinavataor vourvour, o nga vavataor surie bu sana kepineits kokouk e Iesu ta nga tsana nge vavasengei ngan si man tsuoktsuok vakaek ken tsientsang, ");
INSERT INTO tbf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","oit simi ra e Raban ta nga kerie kien i kur simi rangit. I muan ta nga kien i kur, ngan mi ngesengesien mi Moromoruo Tamat, a nga oeng votuomara gie bu aposol ta nga viel tsana gie. ");
INSERT INTO tbf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I murien ta nga suvuon mi vinekikin, e Iesu kesen a nga tsorubeit vasvas sibu aposol meie ngan palan bu kepineits nia vara tuktuk ngan va eie a nga to muerengei. A nga tsorubeit vasvas segie i aron bu ra ba sinangavur voveit ma a nga vakokoit surie mi mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sien ta nga mon meie gie, a nga oeng ngeisngeis segie ven ne, “Kian va nga ta sorvekenan i Ierusalem, eiekesen nga ta rosie mi sana e Tamoung ta nga kubutsie nia terie senga malan o tate nga pengan senga. ");
INSERT INTO tbf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","E Ioanes a nga tsana mi sinusuruiv ngan mi da, eiekesen i murien ka ba ra, nga ta ba por sinusuruiv ngan mi Moromoruo Tamat.” ");
INSERT INTO tbf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Io, sien bu aposol gi ta nga beit kouk meie e Iesu, gi nga vosuoreie, “Mi Nguts, ine sibu ra, e ta tsang muerngan mi mangmagoso nguts sibu Israel?” ");
INSERT INTO tbf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","E Iesu a nga oeng segie, “A kap va kenga kepineits va nga ta telekiran mi keipkepide ra ma mi ra ian e Tamoung tate nga totok telekiran ngan ken duis. ");
INSERT INTO tbf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eiekesen nga ta suvu ngeisngeis sien va mi Moromoruo Tamat ta nemei nge tsegerie nga ma nga ta vavatei nge iou i Ierusalem, i Iudea ma i Samaria beit si man votovoto mi mangmagoso enaenamon.” ");
INSERT INTO tbf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Io, i murien ta nga vakokoit ngan ine, e Raban a nga kerie e Iesu kien i kur simi rangit i matagie, ma mi balbal a nga kitipan kegi baidendeng. ");
INSERT INTO tbf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Gi nga dedeng ngeisngeis e Iesu sien ta nga kien i kur simi mariu, samo ba ka luo maguor sar tsetstseik puneits guor si nga tuir i bingagie. ");
INSERT INTO tbf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma guor nga pevien, “Mi kulu Galili, surie misa nga ta ngas vor dendeng kien i kur simi mariu? Ine e Iesu e Raban ta kir tsana senga kien i kur simi rangit, ta buer muerengei malan mo ine nga tate dengarie ta kien i kur simi rangit.” ");
INSERT INTO tbf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Samo bu aposol gi nga muerengei rakot i Ierusalem kovuni simi pout i Oliv. Ine mi pout a mon vatavatat i Ierusalem. Kovuni simi pout i Oliv beit i Ierusalem a oit mi kilomita kes ian va ka mei ta oit nia veisngie vemusurie man vinuor mi Rangi Minaes. ");
INSERT INTO tbf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Sien gi tate nga beit, gi nga vaen kien simi roruom i kur simi vonuo ivie gi ta nga ko mon en. Egie ese gi ta nga beit ian en, arie e Petro, e Ioanes, e Iakobo, e Andre, e Pilipo, e Tomas, e Bartolomeu, e Mataio, e Iakobo e natuon e Alpeo, e Simon simi gargar sibu Silot, ma e Iudas e natuon e Iakobo. ");
INSERT INTO tbf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gi nga ko munu beit kouk nia rengeir, kokouk meie mi langei ma e Maria e kinan e Iesu, ma bu kasien. ");
INSERT INTO tbf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ian sibu ra, mi kulou vodovodon tuktuk gi nga oir kouk, mi sinangavur kes koboit ma ba sinangavur luo i popon (120) egie kokouk. Ma e Petro a nga tamtuir nge pevien, ");
INSERT INTO tbf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bu kasiung, mi nama i aron mi Pakpak Leong ta ngas tsorubeit tuktuk surie e Iudas ese ta nga muongan mi kulou nia rakopie e Iesu. Ine mi nama, mi Moromoruo Tamat a nga vorotsoruo i ngutsuon e Davit muomuo ngas te. ");
INSERT INTO tbf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","E Iudas eie e turagiet ka ni tsientsang.” ");
INSERT INTO tbf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ngan mi voirvoir e Iudas ta nga poro simi tsaka sinavei, a nga vorie ngan ken kato pier, ivie ta nga kor nge muongan en mi kovan, ma a nga puor kapot, ma mi tienen a nga soer rovotsour. ");
INSERT INTO tbf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Egie kokouk i Ierusalem gi nga rongovan ine mi kepineits. Io, gi nga vuotongie ngan ian mi kato pier i Akeldama, man vuevue va, ‘mi pier simi dar’.) ");
INSERT INTO tbf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“E Davit a nga vataro simi pakapaka rorou Bu Pak ven ne, “‘A kalei va ken vonuo ta mon ringringidin, kian va ka mei ta mon sien.’ Ma ‘A kalei va ka mei mene ta poro ken mogomogos simi tsientsang.’ ");
INSERT INTO tbf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Io, giet ta ngas vile ka mei mene va ta me tuir pats meie gei nia vavatei katsep ngan ken tino mumuerengei e Iesu. Eie ngas mi mei ese ta nga ko mon meie gei sibu ra mi Nguts e Iesu ta nga mon i kotubugei, vakaek simi ra e Ioanes ta nga tsana mi sinusuruiv se Iesu tuir oit simi ra e Raban ta nga kir tsana e Iesu segiet kien i kur simi rangit.” ");
INSERT INTO tbf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Io, gi nga voturie ba ka luo, e Iosep gi nga ko tutuo ngan e Barsabas (mi asan mene buer e Iusto) ma e Matias. ");
INSERT INTO tbf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Samo bu aposol gi nga no, “Mi Nguts, e telekiran bu arogei kokouk. Vasangan segei ese mei seguor e vile ");
INSERT INTO tbf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","va ta poro mi tsientsang aposol, ivie e Iudas tate nga sorvekenan nge rakot si ken kato pier.” ");
INSERT INTO tbf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Samo gi nga tsang vemusurie mi sinavigie nia vivviel. Ma mi vivviel a nga beit va e Matias va arie eie. Io, gi nga kir vurukude va ta nga mon meie bu aposol mi sinangavur kes ma kes. ");
INSERT INTO tbf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sien mi rangi Pentekost tate nga beit, bu aposol gi nga mon kokouk simi korot kes. ");
INSERT INTO tbf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Samo mi tienengen mi kepineits malan va mi mour leong, a si nga beit kovuni simi rangit nge vovosuo mi vonuo ivie gi ta nga mon en. ");
INSERT INTO tbf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Gi nga pare misa ta nga beit malan va bu karame leing ta nga kor mogos i popon mi kulou keskes. ");
INSERT INTO tbf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Egie kokouk gi nga vous ngan mi Moromoruo Tamat ma gi nga vakaek nge vakokoit ngan bu vuna nama mene ian mi Moromoruo Tamat ta nga tsana va gi ta nga oit nia vokokotie. ");
INSERT INTO tbf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ian simi ra, bu Iuda ese gi ta nga ko rengeir rakot se Raban kovuni sibu vuna enamon mene gi nga mon i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sien gi ta nga rongomie ine mi tienengi kepineits malan mi mour leong, mi bineit leong gi nga me oir kouk. Gi nga kudier simi vunan egie keskes gi nga rongomie bu ka vodovodon tuktuk gi ta nga vakokoit ngan kegi sar vuna nama. ");
INSERT INTO tbf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gi nga kudier tsak ma gi nga vevirei nge gie, “Ine mi kulou gi ta vakokoit malan ine, egie mi kulu Galili, nge? ");
INSERT INTO tbf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Eiekesen giet si rongomie gie gi vakokoit ngan bu namanien bu enamon gi ta nga kava giet en. ");
INSERT INTO tbf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Egiet giet kovuni i Partia, i Media ma i Elam, ma kovuni i Mesopotamia, i Iudea ma i Kapadokia, i Pontus ma i Asia, ");
INSERT INTO tbf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma kovuni i Prikia, i Pampilia, i Isip ma bu korot i Libia vatavatat i Kurene. Bu mei segiet giet kovuni i Roma, ");
INSERT INTO tbf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(bu Iuda ma bu Kibang gi ta vemusurie mi rengeir sibu Iuda.) Ma bu mei segiet giet kovuni i Krete ma i Arap. Ma giet si rongomie gie va gi vakokoit ngan kegiet sar vuna nama surie bu kepineits leong e Raban tate nga tsana!” ");
INSERT INTO tbf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gi nga kudier tsak nge basbaslieng ma gi nga vevirei nge gie kesegie, “Mi sana man vuevue ine?” ");
INSERT INTO tbf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eiekesen bu mei mene segie gi nga vavangiets nge gie ma gi nga pevien, “Ine mi kulou gi te un dangi vain beitsak te.” ");
INSERT INTO tbf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Samo e Petro a nga tsik tamtuir meie mi sinangavur kes ma kes bu madar tovtov ma ngan mi ien leong a nga vakaek nge vakokoit simi bineit, “Enga bu turoung Iuda, ma enga nga ta mon i Ierusalem! Nga rorong seou ma o ta palsie senga misa man vuevue ine. ");
INSERT INTO tbf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ine mi kulou gi kap un dangi vain malan nga ta pevien. Ine a ngas mi 9 kilok mo sivovo! ");
INSERT INTO tbf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Eiekesen ine arie misa e Ioel mi propet ta nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“E Raban a nga pevien, ‘Sibu ra vekvekitip, o ta poek soan mi Morumoruong simi kulou kokouk. Bu natunga tamat ma bu natunga vevien gi ta vavatei ngan mi sana nama o ta terie segie, kenga sar ka vour gi ta dengarie kavo baidendeng, kenga sar komois gi ta borea ngan kavo binorea. ");
INSERT INTO tbf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma buer si kong sar petspets, kokouk bu ka ma bu vevien, o ta puek soan mi Morumoruong ian sibu ra, io, gi ta vavatei ngan mi sana nama o ta terie segie. ");
INSERT INTO tbf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","O ta vasangan palan bu kepineits ni vovokudier die i kur simi rangit ma palan bu totourlekier ine i keim simi kaber. Mi dar ma mi leing ma mi kienkou leong ta beit, ");
INSERT INTO tbf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mi matanias ta ngingi, ma mi vura ta vuris nge mereik mala dar, i muan mi ra leong simi Nguts ian ta va ta beit ngan man matvinavaso. ");
INSERT INTO tbf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma mi kulou kokouk gi ta no simi asan mi Nguts, gi ta so suvuon mi vavato.’ ");
INSERT INTO tbf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mi kulu Israel, nga rorong. E Iesu kovuni i Nasaret, eie mi ka e Raban ta nga vara tuktuk ngan va a nga ture terie senga. E Raban a nga sunuir va e Iesu ta nga tsana bu kepineits ni vovokudier ma bu totourlekier i kotubunga malan nga ta telekiran. ");
INSERT INTO tbf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ine mi ka e Raban a nga ture terie senga vemusurie ken lalaron ian tate nga vodon vuturungie. Ma enga, meie ngan mi kuilkuil sibu ka tsokor, nga nga vetekiuo simi koitskoits nge terie simi miensei. ");
INSERT INTO tbf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Eiekesen e Raban a nga vatoa simi miensei ma a nga vara ketseketseng ngan sibu vinekikin simi miensei, simi vunan mi miensei a kap nga oit nia por vangvangasie. ");
INSERT INTO tbf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","E Davit a nga vakokoit surie e Iesu malan ine, “‘O dengarie mi Nguts i muoung sibu ra kokouk. Simi vunan a mon si kong riem suv, o ta kap oit nia dendeir. ");
INSERT INTO tbf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Io, mi aroung a vous ngan mi nires, ma kong sar nama a vasangan mi nires leong. Ma mi piripiriung ta tino ngan mi vodovodon rorrois, ");
INSERT INTO tbf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","simi vunan o telekiran va evoi mi Nguts e ta kap tsupuk rivie mi morumoruong i Ades, eou ke Ka Tamat, o telekiran buer va e ta kap sunuir va mi piripiriung ta kopop. ");
INSERT INTO tbf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","E te vasangan seou mi rosar rakot simi tino, ma e ta mon meie iou nge vovosuo iou ngan mi nires.’” ");
INSERT INTO tbf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Bu kasiung, o ta vakokoit vakatsepa va magiet kovakova ka leong e Davit a nga mesei ma gi te nga puonongie. Ma man monmon a mon ine meie giet ine simi ra. ");
INSERT INTO tbf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","E Davit eie mi propet, ma a nga telekiran misa e Raban ta nga kukubuits meie eie, va e Raban ta tsana ka tubuon va ta tsorubeit Kovakova ka leong malan eie. ");
INSERT INTO tbf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A nga deng mua mi sana va e Raban ta ba nga tsana, io, a nga vakokoit ngan ken tino mumuerengei simi miensei mi Messia ven ne, ‘E Raban a kap nga tsupuk rivie eie i Ades ma mi piripirien a kap nga kopop.’ ");
INSERT INTO tbf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","E Raban a nga vatoa ine e Iesu simi miensei, ma egei kokouk ine, gei vara tuktuk ngan surie ine. ");
INSERT INTO tbf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","E Raban a nga tsuok terie i kur e Iesu nge vogosongie si ken riem suv. Ma e Taman a nga terie seie mi Moromoruo Tamat ian ta nga kubutsie nia terie, ma a te poek soan ine mi Moromoruo Tamat segei malan ine nga tate dengarie nge rongomie. ");
INSERT INTO tbf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","E Davit a kap ngas nga kien i kur simi rangit, eiekesen a nga pevien, “Mi Nguts a nga pevien si mong Nguts, ‘Mogos si kong riem suv, ");
INSERT INTO tbf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tuir oit va o ta tsana ma sar matakorot man poppop ba kame.’ ");
INSERT INTO tbf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Io, enga bu Israel kokouk, nga ta ngas telekiran va e Raban a te nga tsana ine e Iesu va eie mi Nguts ma mi Messia. Eie ian mi ka nga ta nga vetekiuo simi koitskoits.” ");
INSERT INTO tbf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sien mi kulou gi ta nga rongomie ine, a nga tsoka bu arogie. Ma gi nga oeng se Petro ma sibu aposol, “Bu kasigei, mi sana gei ta ngas tsana?” ");
INSERT INTO tbf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","E Petro a nga kuil nama, “Enga kokouk nga ta ngas vodon vuris nge por sinusuruiv simi asan e Iesu Karisito, terengien va e Raban ta mang vodon rivie kenga sar sinavei tsokor, ma ta tabarie nga ngan mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ine mi kinubuits arie senga, sibu tubunga ma segie gi ta mon sibu enamon i pek. Mi Nguts magiet Raban ta terie mi Moromoruo Tamat simi kulou kokouk ese ta kukuo gie nemei seie.” ");
INSERT INTO tbf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Meie ngan bu nama palan mene, e Petro a nga vokokotie segie, ma a nga vanuo vangvangasie gie nge pevien, “Nga ta ngas pits peken mi kulou tsokor ine sibu ra. Nga ta masi suvuon mi vinatoreis meie gie!” ");
INSERT INTO tbf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Egie ese gi ta nga rong poro ken sar nama e Petro, gi nga por sinusuruiv. Io, ian simi ra, ba sinangavur tour soloba (3,000) mi kulou gi nga rubukien si kegi gargar mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Gi nga terie kegi tino kokouk si kegi vinasengei bu aposol, simi sinavei nia oir kouk, simi sinavei nia vepot ngan mi tsoik, ma simi sinavei nia no rakot se Raban. ");
INSERT INTO tbf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bu mei kokouk gi nga kudier tsak simi vunan bu aposol gi nga ko tsana palan bu kepineits ni vovokudier ma bu totourlekier. ");
INSERT INTO tbf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mi kulou vodovodon tuktuk kokouk gi nga ko oir kouk ma kegi sar kepineits kokouk a nga kes mo. ");
INSERT INTO tbf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Gi nga verikuil nge lakep ngan kegi sar kepineits ma gi nga terie segie ese gi ta nga mon pinat. ");
INSERT INTO tbf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sibu ra kokouk gi nga ko munu beit kokouk i mararan mi Vona rengeir leong. Gi nga ko ngou kokouk i aron kegi sar vonuo ngan mi nires ma mi banga aor. ");
INSERT INTO tbf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ma gi nga ko puongan e Raban ma gi nga mon nge res surie bu banga aor simi kulou kokouk. Ma sibu ra keskes mi Nguts a nga vor ve veleveleongtie mi aesaes si kegi gargar mi kulou ese e Raban ta nga vatoa gie. ");
INSERT INTO tbf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Simi ra mene, e Petro ma e Ioanes guor nga rakot simi Vona rengeir leong simi 3 kilok sireivreiv, mi keipkepide ra nia rengeir. ");
INSERT INTO tbf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mi ka a nga muru vakaek te si ken kienakav, gi nga sor rakot ngan simi rumrubukien simi Vona rengeir leong. Mi asan ine mi rumrubukien va ‘Matkalei’. Sibu ra kokouk gi nga ko vogosongie ine mi muru en va ta nga ve no lakep segie gi ta nga ko rubukien i mararan mi vona rengeir. ");
INSERT INTO tbf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sien ta nga pare e Petro ma e Ioanes guor tate nga visi rubukien, a nga nongie guor nge lakep. ");
INSERT INTO tbf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","E Petro ma e Ioanes guor nga deng vangvangasie. Samo e Petro a nga pevien, “Pare gor!” ");
INSERT INTO tbf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Io, ine mi muru a nga deng vangvangasie guor, ma a nga vodon va ta nga tserie ka kepineits kovuni seguor. ");
INSERT INTO tbf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Eiekesen e Petro a nga pevien, “Mi lakep silva ma gold o kap suvuon, eiekesen mi sana o ta suvuon o ta terie sevoi. Simi asan e Iesu Karisito kovuni i Nasaret, tamtuir nge veis.” ");
INSERT INTO tbf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Samo e Petro a nga popor ka si ken riem suv, ma a nga kulie nia tamtuir, ma ian ngas te ba kamen guor te nga tsorubeit ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Io, a nga rov tamtuir ma a nga vakaek nge veis. Samo a nga vemusurie guor rubukien i mararan mi vona rengeir. A nga veis nge kolkolueits ma a nga puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mi kulou kokouk gi nga pare ta nga veis nge puongan e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sien gi ta nga deng kielala va arie eie mo mi ka ta nga ko mogos nge vor nono kepineits simi rumrubukien ‘Matkalei’ simi vona rengeir, gi nga kudier tsak simi sana tate nga tsorubeit seie. ");
INSERT INTO tbf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sien ian mi ka ta nga popor vengeis se Petro ma e Ioanes, mi kulou kokouk gi nga kudier tsak ma gi nga soer nemei segituo, simi korot gi vuotongie ngan va ‘Ken Korot porpor mour e Solomon’. ");
INSERT INTO tbf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Sien e Petro tate nga pare ine, a nga oeng segie, “Kulou Israel, surie misa nga te kudier tsak surie ine mi kepineits? Kian va nga ta aan nge gor nge vodon va gor vatoa ine mi muru ngan mi ngisingisigor o, ngan kegor tentoiv. ");
INSERT INTO tbf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Man Raban e Abaraam, e Isak ma e Iakop, ma man Raban bu tubugiet, a me terie mi as leong se Iesu, ken petspets. Eiekesen nga nga terie simi kiden, ma nga nga matokeran i matan e Pilato, misasien e Pilato tate nga vodon nia ruom rivie. ");
INSERT INTO tbf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nga te nga matokeran ken ka e Raban ese ta tamat ma duis, ma nga te nga nongie va ta nga ruom rivie mi ka kenken nge terie senga. ");
INSERT INTO tbf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nga te nga kenvamate man Nguts mi tino, eiekesen e Raban a nga vatoa simi miensei. Egor gor me vara tuktuk ngan ine. ");
INSERT INTO tbf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ine mi ka nga ta pare ma nga ta telekiran, a te tsorubeit ngeisngeis ngan mi asan e Iesu. Arie mi asan e Iesu ma mi vodovodon tuktuk seie mo a vara ketseketseng rovoriu ngan te ine mi ka si man mienarouk i matanga kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Io, bu kasi, o telekiran va nga te nga tsana mi sinavei nia vodon sasavoir malan manga sar muomuo. ");
INSERT INTO tbf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Eiekesen e Raban a me tsang vaotie misa ta nga peterie i ngutsugie bu propet va ken Messia ta ngas suvu vinekikin. ");
INSERT INTO tbf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Io, nga ta ngas vodon vuris, ma nga ta ngas vuvuris rakot se Raban, terengien va ta mang beir rivie kenga sar sinavei tsokor, ma mi keipkepide ra nia vovoruo mi tino ta mang kovuni simi Nguts, ");
INSERT INTO tbf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma ta mang turan e Iesu. E Iesu eie mi Messia ese e Raban tate nga vile va kenga. ");
INSERT INTO tbf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","E Iesu ta ngas mon simi rangit oit simi ra va e Raban ta tsang vovoruo bu kepineits kokouk, malan ta nga vokokotie muomuo ngas te i ngutsugie ken sar propet e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","E Moses a nga pevien, ‘Mi Nguts manga Raban ta voturie manga ka propet mala iou, kovuni i kotubunga ngas te. Nga ta ngas rorong sibu kepineits kokouk va ta pengan senga. ");
INSERT INTO tbf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Eie ese va ta kap rorong sien, e Raban ta matokeran nge tsang rivie eie sorvekenan mi kuoluon.’ ");
INSERT INTO tbf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“A tuktuk, bu propet kokouk vakaek se Samuel ma egie i murien, palan segie gi ta nga vakokoit, gi te nga peterie misa va tate nga tsorubeit ine sibu ra. ");
INSERT INTO tbf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ma enga nga me suv sibu kinubuits e Raban ta nga tsana meie ngan bu propet ma bu tubunga. E Raban a nga pevien se Abaraam, ‘Se tubu, o ta vatamase mi kulou kokouk simi kaber.’ ");
INSERT INTO tbf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sien e Raban tate nga voturie ken ka ni tinuturei, a nga muna turan rakot senga nia vatamase nga ma a nga tsana va nga ta vurisan kenga sar tino sorvekenan bu sinavei tsokor.” ");
INSERT INTO tbf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bu prist ma mi muomuo simi kulou nennei simi Vona rengeir leong ma bu Sadukaio gi nga nemei se Petro ma e Ioanes sien guor ta nga vor ve vakvakokoit simi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gi nga aor putu beitsak simi vunan guor nga vavasengei simi kulou nge vavatei ngan mi asan e Iesu va mi tino mumuerengei simi miensei a tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Io, gi nga rakopie guor nge terie guor simi vona vinatoreis oit simi ra ka ie, simi vunan a te nga reivreiv seserigo. ");
INSERT INTO tbf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eiekesen palan egie ese gi ta nga rongomie keguor nama, gi nga vodovodon tuktuk ma mi aesaes kokouk simi kulou a nga beit oit malan bu sinangavur mi napaririem soloba (5,000). ");
INSERT INTO tbf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Simi ra vemusurie, bu muomuo ni vuor, bu muomuo simi kulou ma bu vavvasengei sibu vinuor se Moses, gi nga beit kouk i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","E Annas mi kovan bu prist a nga mon, meie e Kaiapas, e Ioanes, e Aleksandro ma bu ka simi tietie simi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gi nga voturie e Petro ma e Ioanes i matagie ma gi nga vakaek nge vosuovosuoreie guor, “Ngan mi sana ngeisngeis ma ngan mi asan ese ngado te tsana ine?” ");
INSERT INTO tbf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","E Petro a nga vous ngan mi Moromoruo Tamat nge oeng segie, “Enga bu muomuo ni vuor ma enga bu muomuo simi kulou! ");
INSERT INTO tbf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Sien va gor tuir simi vinuor nevere surie mi kienelei ta nga tsorubeit simi muru ma sien va nga lalaro telekiran vasa a te nga ketseketseng ven, ");
INSERT INTO tbf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","a kalei va enga kokouk meie mi kulu Israel nga ta ngas telekiran va ine mi ka ta tuir i matanga, a te ketseketseng simi asan e Iesu kovuni i Nasaret ese nga ta nga vetekiuo i popon mi koitskoits ma ese e Raban ta nga vatoa simi miensei. ");
INSERT INTO tbf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Eie e Iesu ian mi Pakpak Leong ta nga vakokoit surie malan ine, “mi vunavout, enga bu ka poitspoits vonuo, nga ta nga purusie, a me tsorubeit mi vunavout mogos. ");
INSERT INTO tbf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Eie kesen mo a oit nia vatoa giet, simi vunan a kap ka mei mene te buer e Raban a terie va ta oit nia vatoa giet simi sinavei tsokor i pakien mi rangit.” ");
INSERT INTO tbf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sien gi tate nga pare keguor aor ngeisngeis e Petro ma e Ioanes nge telekiran nangba va guor kap nga mon si ka vavvasengei ma eguor ba ka tuvuon mo, gi nga kudier ma gi nga vodonomie va eguor guor nga ko nomeie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eiekesen gi kap nga oit nia tsana ka kepineits veie guor simi vunan gi nga pare ine mi ka guor ta nga vatoa, a nga tuir meie guor. ");
INSERT INTO tbf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Io, gi nga oeng ngeisngeis va gituo ta nga rovotsour sorvekenan mi Sanedrin. Ma egie kesegie gi nga vakvakokoit ven ne, ");
INSERT INTO tbf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Misa giet ta tsana ine siba ka? Bu mei kokouk i Ierusalem gi telekiran va guor tsana mi kepineits ni vovokudier a kekineits rio bu kepineits ni vovokudier mene, ma egiet giet kap oit nia vamoie. ");
INSERT INTO tbf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Eiekesen, nia vaton ine mi kepineits va ta kap puorkan i kotubuon mi kulou, giet ta ngas vangenge guor va guor ta kap ba buer vakokoit si ka mei ngan mi asan e Iesu.” ");
INSERT INTO tbf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Samo gi te buer nga kuk vurukude guor ma gi nga vengeng vangvangasie guor va kian ba buer va guor ta nga vokokotie o, vavasengei ngan mi asan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Eiekesen e Petro ma e Ioanes guor nga kuil nama, “Enga ngas te, nga viertan mi sana a duis i matan e Raban. Nia rorong senga o, nia rorong se Raban? ");
INSERT INTO tbf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gor kap oit nia voto simi vokokotie misa egor kesegor gor te nga pare nge rongomie.” ");
INSERT INTO tbf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","I murien gi tate buer nga vengeng vangvangasie guor, gi nga ture rivie guor. Gi nga ture rivie guor simi vunan gi kap nga oit nia vorotan ka vunan nia votorosie guor, surie mi kulou kokouk gi nga puongan e Raban simi sa tate nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ine mi ka e Petro ma e Ioanes guor ta nga vatoa simi sinavei ni vovokudier, ken sar avareit a nga rio ba sinangavur voveit. ");
INSERT INTO tbf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","I murien gi tate nga ture rivie guor, guor nga muerengei rakot sibu meinmeniguor ma guor nga potsukie bu kepineits kokouk bu prist leong ma bu muomuo simi kulou gi tate nga vokokotie seguor. ");
INSERT INTO tbf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sien gi ta nga rongomie ine, egie kokouk gi nga rengeir rakot se Raban, ma gi nga pevien, “Mi Nguts, e nga tsana mi rangit, mi kaber, ma mi barateis ma bu kepineits kokouk gi ta tino segie. ");
INSERT INTO tbf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Simi ngesengesien mi Moromoruo Tamat e nga vorotsoruo mi nama i ngutsuon ke ka petspets e Davit, e tubugei, “Surie misa bu vuna enamon gi nga petseir beitsak? Surie misa mi kulou gi nga rove bu bas ian ta gov? ");
INSERT INTO tbf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bu kovakova ka leong simi kaber gi nga rorois nia veveken ma bu muomuo ni vuor gi nga tuir kouk nia matakorot meie mi Nguts ma nia matakorot meie ken Messia. ");
INSERT INTO tbf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A tuktuk e Erot ma e Pontio Pilato, guor nga beit kouk ine simi taon leong meie bu Kibang ma mi kulu Israel va gi ta nga rove man bas e Iesu Ke petspets tamat ese e ta nga vokunie. ");
INSERT INTO tbf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gi nga tsana ine bu kepineits vemusurie mi sana e te nga pete vuturungie va ta nga tsorubeit surie ke lalaron. ");
INSERT INTO tbf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma ine, mi Nguts, vodonomie vasa gi vamatuo gei ven, ma vangasie gei ke sar petspets nia vavatei ngan ke nama ngan mi aor ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Parasan mi rima nge vatoa mi kulou si magi sar mienarouk nge tsana bu totourlekier ni vovokudier ma bu kepineits ni vovokudier simi asan e Iesu Ke petspets ese ta tamat.” ");
INSERT INTO tbf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","I murien gi tate nga rengeir voto, mi korot ivie gi ta nga mon kouk en a nga oen. Ma egie kokouk gi nga vous ngan mi Moromoruo Tamat, ma gi nga vavatei ngan ken nama e Raban ngan mi aor ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mi kulou vodovodon tuktuk, egie kokouk gi nga aor kes ma kegi sar vienviendon a nga kes. Kap ka mei a nga pevien va ken sar sinsuv va seie kesen, eiekesen gi nga vevepot ngan kegi sar sinsuv kokouk i kotubugie. ");
INSERT INTO tbf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ngan mi ngeisngeis leong, bu aposol gi nga ko munu vavatei katsep ngan ken tino mumuerengei simi miensei mi Nguts e Iesu. Ma ken tentoiv leong e Raban a nga kuvagie kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kap ka mei i kotubugie a nga pinat surie ka kepineits. Egie ese gi ta nga suvu kaber o, vonuo gi nga verikuil nge lakep ngan kegi sar kaber ma vonuo. ");
INSERT INTO tbf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ma gi nga poro bu lakep nge ra terie i napariman bu aposol ma gi nga potakie ine bu lakep rakot segie nia vaotie kegi sar pinat vovokes. ");
INSERT INTO tbf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","E Iosep mi Levi kovuni i Kupro ese bu aposol gi ta nga tutuo ngan mi as Barnabas, (man vuevue va, ‘mi ka vokovokoits’) ");
INSERT INTO tbf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","a nga verikuil nge lakep ngan ken poko kaber, ma a nga poro bu lakep nge ra terie i napariman bu aposol. ");
INSERT INTO tbf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Simi ra mene mi ka mi asan e Ananias meie ken vevien mi asan e Sapira, guor nga verikuil nge lakep ngan mi poko kaber. ");
INSERT INTO tbf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Eiekesen e Ananias a nga por vangasie mi kapien sibu lakep va seie kesen, ma ken vevien a nga telekiran ine. Samo e Ananias a nga poro ian bu lakep ka ie nge ra vuturungie i kamen bu aposol. ");
INSERT INTO tbf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Eiekesen e Petro a nga pevien, “Ananias, surie misa e Satan ta tsegerie no va e ta bitie mi Moromoruo Tamat ma e te suvuon mi kapien sibu lakep e ta nga tserie nian mi poko kaber? ");
INSERT INTO tbf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Vasa, a kap va sevoi sien e ta kap ngas nga verikuil ngan? Ma vasa, i murien e tate verikuil ngan, ine mi lakep a kap mon si ke nennei? E kap bitie mi kulou, eiekesen e te bitie e Raban.” ");
INSERT INTO tbf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Sien e Ananias ta nga rongomie ine bu nama, a nga tsibour mutur ma a nga maet. Ma mi mientou leong a nga beit segie kokouk ese gi ta nga rongovan mi sana ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Samo ba ka vour gituo nga nemei ma gituo nga gulie mi piripirien nge sor rovotsour ngan ma gituo nga ra puonongie. ");
INSERT INTO tbf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ma i murien ba aua tour tate nga voto, ken vevien a si nga rubukien eiekesen a kap nga telekiran misa a te nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","E Petro a nga vosuoreie, “Pengan seou. Ine arie mi voirvoir kokouk evoi ma e Ananias ngado poro simi poko pier?” A nga kuil nama, “Io, ian arie mi voirvoir kokouk.” ");
INSERT INTO tbf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","E Petro a nga oeng seie, “Surie misa evoi ma ke labeit ngado sunurie va ngado ta konon mi Morumoruan mi Nguts? Pare! Ba ka ese gituo ta ra puonongie ke labeit egituo te die i matavanuo ma gituo ta sorokie no rovotsour buer.” ");
INSERT INTO tbf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ian ngas te, e Sapira a nga tsibour mutur i matan ma a nga maet. Samo ian ba ka vour gituo nga rubukien ma gituo nga vorotan va a te nga maet. Ma gituo nga sor vorotsoruo nge puonongie i babaren ken labeit. ");
INSERT INTO tbf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mi mientou leong a nga betingie mi kulou vodovodon tuktuk kokouk ma egie ese gi ta nga rongovan bu sana ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bu aposol gi nga tsana palan bu kepineits ni vovokudier ma bu totourlekier i kotubugie mi kulou. Ma mi kulou vodovodon tuktuk gi nga ko beit kouk simi korot gi vuotongie ngan ‘Ken Korot porpor mour e Solomon’. ");
INSERT INTO tbf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kap ka mei mene a ba nga aor ngeisngeis nia tsok pekouk meie gie, misasien gi ta nga suvu minangarei kuvu simi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eiekesen palan mi kulou ma mi langei gi nga vodovodon tuktuk simi Nguts ma mi aesaes segie a nga vor vaenvaen kien i kur. ");
INSERT INTO tbf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Surie mi tsientsang aposol gi ta nga tsana, mi kulou gi nga sorokie bu tamat mienarouk rakot sibu gege rosar ma gi nga vuturungie gie i popon bu tsur mutumutur terengien sien va e Petro ta nga veis rov rio gie, mi mommoruvien ta mang nga momoruvie gie. ");
INSERT INTO tbf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bu bineit buer kovuni sibu taon viririsie i Ierusalem, gi nga sor nemei ngan kegi sar tamat mienarouk ma egie bu tsaka moromoruo gi ta nga tsegerie gie, ma egie kokouk gi nga suvuon mi vavato. ");
INSERT INTO tbf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Samo mi kovan bu prist ma bu turan prist kokouk ese gi ta mon simi gargar sibu Sadukaio gi nga ngungutsuo gie bu aposol. ");
INSERT INTO tbf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gi nga rakopie bu aposol ma gi nga vurukude gie simi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Eiekesen i aron mi rokati ken angelo mi Nguts a nga tsitsingie mi matavanuo simi vona vinatoreis ma a nga kir vorotsoruo gie i marar. ");
INSERT INTO tbf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Mi angelo a nga pevien, “Nga rakot nge tuir i mararan mi Vona rengeir leong ma nga vateie mi kulou ngan man sar vinakokoit ine mi Tino.” ");
INSERT INTO tbf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sien ta nga vo ra, gi nga rubukien i mararan mi vona rengeir malan mi angelo ta nga oeng segie ma gi nga vakaek nge vavasengei simi kulou. Sien mi kovan bu prist ma bu turan prist gi ta nga beit, gi nga kuk kakuon mi Sanedrin meie bu muomuo kokouk sibu Israel. Ma gi nga tuturei nia ra kerie bu aposol nemei kuvu simi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eiekesen sien bu muomuo simi kulou nennei simi Vona rengeir leong gi ta nga so beit simi vona vinatoreis, gi kap nga so pare gie te. Io, gi nga muerengei ma gi nga ra pengan, ");
INSERT INTO tbf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Gei vorotan mi vona vinatoreis gi tsekitie, ma bu ka nennei gi tuir sibu matavanuo. Eiekesen sien gei tate tsitsingie, gei kap vorotan ka mei i ruom.” ");
INSERT INTO tbf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sien gi ta nga rongomie ine mi nama, mi muomuo simi kulou nennei simi Vona rengeir leong ma bu prist leong, a nga bakiet bu arogie ma gi nga vodovodon palan va misa ta tsorubeit surie ine. ");
INSERT INTO tbf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Samo mi ka mene a nga nemei ma a nga pevien, “Bu ka nga ta terie gie simi vona vinatoreis, gi si tuir i mararan mi Vona rengeir leong nge vavasengei simi kulou!” ");
INSERT INTO tbf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Io, mi muomuo simi kulou nennei simi Vona rengeir leong a nga veis meie ken sar gargar ma gi nga ra kerie bu aposol. Eiekesen gi kap nga votsuoke gie, simi vunan gi nga motou va mi kulou gi ta masi nga tome gie nge vout. ");
INSERT INTO tbf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","I muir gi tate nga ra kerie gie, gi nga me voturie gie i matan mi Sanedrin ma mi kovan bu prist a nga vosuovosuoreie gie. ");
INSERT INTO tbf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Gei vengeng vangvangasie nga va nga ta kap vavasengei simi asan e Iesu, eiekesen nga vavasengei simi kulou sibu korot kokouk i Ierusalem ngan kenga sar nama ma nga lalaro vepitsie gei va gei nga voguersan ken tino ine mi ka.” ");
INSERT INTO tbf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","E Petro ma bu aposol gi nga pevien, “Gei ta ngas rorong surie e Raban mo ma kap va mi kulou! ");
INSERT INTO tbf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Magi Raban bu tamagiet a nga vatoa e Iesu simi miensei i murien nga ta nga vetekiuo i popon mi koitskoits nge kenvamate. ");
INSERT INTO tbf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E Raban a nga tsuok terie i kur i bingan si ken riem suv nia vasangan va eie mi natu vavaku ma mi ka ni vavato. E Raban a nga tsana ine terengien va ta mang kulie giet bu Israel nia vodon vuris ma va ta mang vodon rivie bu sinavei tsokor. ");
INSERT INTO tbf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Gei tuir nia vara tuktuk ngan ine bu kepineits, ma buer mi Moromoruo Tamat ese e Raban ta nga terie segie ese gi ta rorong sien.” ");
INSERT INTO tbf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sien bu muomuo simi vinuor gi ta nga rongomie ine, gi nga aor rarap beitsak ma gi nga lalaro kenvamate gie. ");
INSERT INTO tbf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Eiekesen mi meinmenien ian bu muomuo, mi Parisaio mi asan e Gamaliel, eie mi vavasengei simi Vinuor, ma mi ka aiminangarei. A nga tuir i kotubuon mi Sanedrin ma a nga oeng ngeisngeis va mi kulou gi ta be nga ture vorotsoruo bu aposol nia ra rorois lili. ");
INSERT INTO tbf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Samo a nga oeng segie, “Enga mi kulou Israel, nga ta ngas meikmekikir simi sana nga ta lalaro tsana ine simi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A kap ngas potaram mo sorvekenan, e Teudas a nga beit nge pevien va eie mi ka asna, ma mi kulou a oit ba sinangavur voveit koboit (400) gi nga vemusurie. Eiekesen mi kulou ni minakiur sibu Roma gi nga kenvamate, ma mi kulou gi ta nga vemusurie gi nga vi vepitsitsei ma ian mi kepineits a nga ra sasavoir mo. ");
INSERT INTO tbf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","I murien e Teudas, e Iudas mi kangi Galili a nga beit. Ian sibu ra, mi kulou kokouk gi nga teir as simi gavaman. Ma a nga muongan mi kulou ni rong tsak sibu Roma. Eie buer a nga maet ma mi kulou gi ta nga vemusurie gi nga vi vepitsitsei. ");
INSERT INTO tbf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Io, surie ine bu ka, o vanuo nga va nga ta tsupuk rivie gie ine bu ka. Nga ta sanga gie! Sien va ine mi vienviendon a kuvu simi kulou mo, misa ine mi kulou gi ta lalaro tsana, ta voto sasavoir mo. ");
INSERT INTO tbf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Eiekesen sien va ine mi vienviendon a vunan se Raban, nga kap oit nia tuir biritie ine mi kulou. Nga ta masi vorotan va nga te veveken meie e Raban.” ");
INSERT INTO tbf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Io, bu muomuo simi vinuor gi nga rorong vemusurie mi namanien e Gamaliel. Gi nga kuk vurukude bu aposol ma gi nga dadakie gie. Samo gi nga vengeng vangvangasie gie va gi ta kap nga vavatei ngan mi asan e Iesu, ma gi nga ture rivie gie. ");
INSERT INTO tbf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bu aposol gi nga sorvekenan mi Sanedrin. Gi nga res simi vunan e Raban a nga pare gie va gi nga oit tuktuk nia suvu vinekikin surie mi asan e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma sibu ra kokouk, i mararan mi Vona rengeir leong ma si kegi sar vonuo keskes, gi kap nga maes nia vavasengei ma vavatei katsep ngan va e Iesu eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ian sibu ra, mi aesaes sibu madar tovtov a nga vor vaenvaen. Bu Iuda gi ta nga ko ogeoge Grik i kotubugie, gi nga nama palan veie bu Iuda gi ta nga ko ogeoge Iburu, simi vunan mi langei naor segie gi tate nga mamaet labeit gi kap nga poro kegi potpot sibu nginonginou nian bu ra keskes. ");
INSERT INTO tbf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Io, mi sinangavur kes ma luo bu aposol gi nga kuk kakuon bu madar tovtov kokouk ma gi nga pevien, “A kap duis va gei ta vodon sasavoir ngan mi tsientsang nia vavatei ngan mi namanien e Raban simi vunan gei voruruit nia pot teir nginonginou ma lakep vunie gie bu mei. ");
INSERT INTO tbf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bu kasiung, nga ta viel tsana mi napaririem potsu luo bu mei aiminangarei, ma egie ese gi ta vous ngan mi Moromoruo Tamat ma mi banga vienviendon. Gei ta terie ine mi tsientsang i naparima gie. ");
INSERT INTO tbf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma gei ta terie kegei tino simi tsientsang nia rengeir ma simi tsientsang nia vavatei ngan mi namanien e Raban.” ");
INSERT INTO tbf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ine mi vienviendon, egie kokouk gi nga resmatan ma gi nga viel tsana e Stepano, mi ka a vous ngan mi vodovodon tuktuk ma mi Moromoruo Tamat, ma buer e Pilipo, e Prokorus, e Nikanor, e Timon, e Parmenas, ma e Nikolaus mi Kibang kovuni i Antiok ese ta be nga muna vuvuris nge tsorubeit va eie mi Iuda. ");
INSERT INTO tbf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Gi nga vasanga gie ine mi kulou sibu aposol. Ma i murien gi ta nga no, gi nga teir riem i popogie nia tourtelekira gie simi tsientsang. ");
INSERT INTO tbf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Io, ken nama e Raban a nga puorkan. Mi aesaes sibu madar tovtov i Ierusalem a nga vaen lalapus ma buer palan bu prist gi nga me suvuon mi vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","E Stepano, mi ka a nga vous ngan mi tentoiv ma mi ngeisngeis se Raban, eie a nga tsana bu kepineits ni vovokudier ma bu totourlekier i kotubugie mi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eiekesen bu mei gi nga me nama vevengeis meie e Stepano. Egie mi gargar gi vuotongie ngan ‘mi Vona rengeir sibu Iuda simi Kulou Ketseketseng’. Ine mi kulou, egie bu Iuda kovuni i Kurene ma i Aleksandria ma siba korot leong i Kilikia ma i Asia. ");
INSERT INTO tbf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eiekesen gi kap nga oit nia kulie ken ka nama e Stepano simi vunan mi Moromoruo Tamat a nga kulie va ta nga vakokoit ngan mi banga vienviendon. ");
INSERT INTO tbf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Samo gi nga oeng ka i arogie mi kulou mene va gi ta nga pevien malan ine, “Gei rongomie e Stepano a oeng balapoik ngan e Moses ma e Raban.” ");
INSERT INTO tbf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Io, gi nga oeng ka i aron mi kulou ma bu muomuo ma bu vavasengei simi vinuor. Gi nga rakopie e Stepano ma gi nga ra voturie i matan mi Sanedrin. ");
INSERT INTO tbf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Samo gi nga kir vurukude mi kulou nia me vokokotie bu nama binit veie. “Ine mi ka a kap maer nia veke man nama mi vona rengeir tamat ma mi Vinuor se Moses. ");
INSERT INTO tbf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gei te nga rongomie a nga pevien va ine e Iesu kovuni i Nasaret ta vatsarerie ine mi Vona rengeir ma ta vurisan mi vinuor e Moses ta nga teir vunie nge giet.” ");
INSERT INTO tbf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Egie kokouk mi Sanedrin gi nga dedeng ngeisngeis rakot se Stepano, ma gi nga pare mi matan a nga mat malan mi matan mi angelo. ");
INSERT INTO tbf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ma mi kovan bu prist a nga vosuoreie e Stepano, “Bu kepineits ine mi kulou gi ta vokokotie surie no a tuktuk?” ");
INSERT INTO tbf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","E Stepano a nga kuil nama, “Bu kasiung ma Tamoung! Nga rorong seou! E Raban, si man matvinavaso, a nga tsorubeit vasvas se tubugiet e Abaraam sien ta nga mon i Mesopotamia, i muan sien ta nga veis nge ra mon i Aaran. ");
INSERT INTO tbf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma a nga oeng sien, ‘Sorvekenan bu patsa ma ke enamon nge rakot simi enamon o ta ba vasangan sevoi.’ ");
INSERT INTO tbf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Io, e Abaraam a nga sorvekenan mi enamon i Kaldea ma a nga ra mon i Aaran. I murien e taman tate nga maet, e Raban a nga ture vavasie rakot ine simi enamon ivie nga tate mon en nevere! ");
INSERT INTO tbf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E Raban a kap nga terie ka kato kaber se Abaraam simi enamon ine, misasien ka kato kaber a oit simi kamen. Eiekesen e Raban a nga kukubuits va ta nga terie mi kaber se Abaraam ma bu tubuon i murien eie, misasien e Abaraam a kap ngas nga suvu madar. ");
INSERT INTO tbf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ine arie mi sana e Raban ta nga vokokotie se Abaraam, ‘Bu tubu, gi ta mon kibang si ka enamon mene, ma gi ta tsatsang petspets en ma mi kulou en ne gi ta vikikinie gie sibu avareit ba sinangavur voveit koboit (400).’ ");
INSERT INTO tbf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","E Raban a buer nga pevien, ‘O ta teir vinatoreis simi vuna enamon ivie gi ta tsatsang petspets en. Ma i murien ine, bu tubu, gi ta tamtuir nge veis sorvekenan ian mi enamon. Ma gi ta me tsatsang seou ine simi enamon.’ ");
INSERT INTO tbf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Samo, e Raban a nga terie se Abaraam mi sinavei nia vavaroup va eie man totourkilal ken kinubuits meie eie. Io, e Abaraam a nga varapuo e Isak e natuon simi ra mi napaririem potsu tour ngan i murien ken kienakav. E Isak a nga varapuo e Iakop e natuon, ma e Iakop a nga varapuo mi sinangavur kes ma luo bu natuon ese bu tubugiet sibu matabu i Israel. ");
INSERT INTO tbf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ine bu natuon e Iakop gi nga ngungutsuo e Iosep e kasigie, ma gi nga verikuil ngan eie nge voirvoir simi kulou ese gi ta nga por terie i Isip nia tsatsang petspets. Eiekesen e Raban a nga mon meie ");
INSERT INTO tbf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nge kulie sibu putu ta nga tsorubeit sien. Simi ra e Iosep tate nga beit i matan e Parao, mi kovakova ka leong i Isip, e Raban a nga terie se Iosep mi banga vienviendon ma e Raban a nga tsana va e Parao ta nga resmatan. Io, e Parao a nga voturie e Iosep va ta nga gavana simi enamon i Isip kokouk ma si ken sar sinsuv. ");
INSERT INTO tbf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Samo mi se leong a nga beit sibu korot kokouk i Isip ma i Kanaan ian ta nga terie mi putu leong beitsak. Bu tubugiet gi kap nga oit nia vorote nginonginou. ");
INSERT INTO tbf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Io, simi ra e Iakop ta nga rongomie va mi nginonginou nia vovoir a nga mon i Isip, a nga turan bu natuon, bu tubugiet. Ine arie kegi vineis vourvour nia rakot i Isip. ");
INSERT INTO tbf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Simi vineis a nga luo ngan e Iosep a nangba nga oeng katsep sibu kasien va eie e Iosep, ma e Parao a te nga nangba vakierngie ken tietie e taman e Iosep. ");
INSERT INTO tbf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","I murien ine, e Iosep a nga vavariu surie e taman, e Iakop, va eie ma ken tietie kokouk va gi ta nga nemei i Isip. Egie kokouk gi nga oit bu sinangavur mi napaririem potsu luo ma mi napaririem (75). ");
INSERT INTO tbf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Io, e Iakop meie egie kokouk gi nga tamtuir nge veis rakot i Isip, ma eie ma bu tubugiet gi nga maet en. ");
INSERT INTO tbf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gi nga sor muer ngan bu tsirigie rakot i Sekem nge puonongie gie i aron mi monmon ivie e Abaraam ta nga voir tsana simi matabu se Aamor ngan bu lakep. ");
INSERT INTO tbf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Sien tate nga beit vatavatat mi ra va e Raban tate nga vara tuktuk ngan ken kinubuits se Abaraam, mi aesaes si kegiet kulou i Isip a te nga leong beitsak. ");
INSERT INTO tbf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Samo mi kovakova ka leong mene ta kap nga telekiran ka puk surie e Iosep, a nga vakaek nge vuortie i Isip. ");
INSERT INTO tbf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A nga bitie kegiet kulou nge terie mi putu leong sibu tubugiet ngan mi nama ngeisngeis nia teir rivie bu natunatu madar i pek, terengien va gi ta mang nga maet. ");
INSERT INTO tbf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ian sibu ra, gi nga kava sien e Moses. Eie mi banga natu madar rovoriu i matan e Raban. Si ba vura tour gi nga naneie i aron ken vonuo e taman. ");
INSERT INTO tbf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sien gi tate nga teir rivie, e natuon vevien e Parao a nga vorotan ma a nga suongore veleongtie malan va e natuon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","E Moses a nga tovtov ngan bu suada sinavei leong i Isip, ma a nga sievei beitsak simi sinavei nia vakokoit ma simi sinavei nia tsana bu suasuada tsientsang. ");
INSERT INTO tbf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Sien tate nga sinangavur voveit ken sar avareit e Moses, a nga vodon nia ra iro ken sar nama kes bu Israel. ");
INSERT INTO tbf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A nga pare mi kangi Isip ta nga keda mi mei kes sibu Israel, io, e Moses a nga rakot nge tuir kulie mi kangi Israel ma a nga kenvamate mi kangi Isip. ");
INSERT INTO tbf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E Moses a nga vodon va ken kulou kesen gi ta nga oit nia deng kielala va e Raban a nga tsatsang i aron ken tino nia vatoa gie, eiekesen gi kap nga deng kielala. ");
INSERT INTO tbf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Simi ra vemusurie, e Moses a nga pare ba kangi Israel luo guor ta nga veveken, ma a nga konon nia vamada guor. Ma a nga pevien, ‘Ngado rorong. Engado ba baser kasien. Surie misa ngado ta veken nge ngado?’ ");
INSERT INTO tbf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Eiekesen mi ka ese ta nga tsak ngan e palapalan, a nga duo subikan e Moses rakot i gege ma a nga pevien, ‘Ese a nga voturie no va e ta muomuo nge vuorvuor segei? ");
INSERT INTO tbf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vasa, e lalaro kenvamate iou malan e ta kenvamate mi kangi Isip nanor?’ ");
INSERT INTO tbf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Sien e Moses ta nga rongomie ine mi nama, a nga vi rakot i Midia ivie a nga ra mon vasier en ma a nga suvuon ba natuon luo en. ");
INSERT INTO tbf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“I murien bu avareit ba sinangavur voveit tate nga rovoriu, mi angelo a nga tsorubeit vasvas se Moses i aron mi berber simi leing ta nga ngang i aron mi ei tsotso simi beir vatavatat simi pout i Sinai. ");
INSERT INTO tbf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sien e Moses ta nga pare ine, a nga kudier tsak simi sana ta nga pare. Sien ta nga veis rakot vatavatat nia ra deng vititirie, a nga rongomie mi inan mi Nguts, ");
INSERT INTO tbf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Eou mi Raban sibu tubunga, mi Raban se Abaraam, Isak ma e Iakop.’ E Moses a nga motou nge dendeir ma a kap nga oit ba buer nia dedeng. ");
INSERT INTO tbf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Samo mi Nguts a nga oeng sien, ‘Kaor rivie ma ba poppop. Mi korot e ta tuir en, eie mi pier tamat. ");
INSERT INTO tbf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A tuktuk o te dengarie mi vinekikin ta monongie kong kulou i Isip. O te rongomie kegi tina ma o te tsorupeuk nia vatoa gie. Lapus, o ta ture muer nge no rakot i Isip.’ ");
INSERT INTO tbf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mi kulou Israel gi nga purusie e Moses ngan mi nama ven ne, ‘Ese a nga voturie no nia muomuo ma nia vuorvuor segei?’ Ine arie e Moses mo ese e Raban ta nga turan va eie magi muomuo ni vuor ma mi ka nia vatoa gie, meie mi kuilkuil simi angelo ese ta nga tsorubeit sien i aron mi ei tsotso. ");
INSERT INTO tbf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Moses a nga kir vorotsoruo gie kovuni i Isip, ma a nga tsana bu kepineits ni vovokudier ma bu totourlekier i Isip ma simi Barateis Mereik ma i aron mi beir sibu avareit ba sinangavur voveit. ");
INSERT INTO tbf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ine arie e Moses mo ese ta nga oeng sibu Israel ven ne, ‘E Raban ta voturie ka propet mala iou kovuni senga ngas te.’ ");
INSERT INTO tbf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Arie eie mo mi ka ese ta nga mon meie bu tubugiet gi ta nga oir kouk simi beir, meie mi angelo ese ta nga vakokoit sien i popon mi pout i Sinai, ma a nga poro ken namani tino e Raban nia vavasie nemei ngan segiet. ");
INSERT INTO tbf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Eiekesen bu tubugiet gi kap nga lalaro rorong se Moses. Gi nga mereis, ma sibu arogie gi nga vodon va a kalei gi ta nga muerengei rakot i Isip. ");
INSERT INTO tbf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Io, gi nga oeng se Aron, ‘Tsana kegei kavo patspats va gi ta tsorubeit kegei sar raban va gi ta mang muonge gei. Ine mi ka e Moses ese ta nga muonge giet sorvekenan i Isip, gei kap telekiran mi sana a te tsorubeit sien!’ ");
INSERT INTO tbf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Io, ian simi ra ngas te, gi nga tsana mi patsapatsan mi natu bulumakau. Ma gi nga vavadengeir ngan mi vinavinar rakot sien nge tsana mi nginou leong nia vasangan kegi nires surie mi sana gi ta nga tsang vabatie ngan bu rimagie. ");
INSERT INTO tbf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eiekesen e Raban a nga murien veie gie, ma a nga tsupuk rivie gie va gi ta nga tsatsang sibu kepineits gi ta mon die i kur simi rangit. Ine a kokouk meie mi sana bu propet gi ta nga vataro simi Pakpak Leong, “‘Enga bu Israel, nge kia va nga nga terie seou bu tienebeir ni varam i aron ba sinangavur voveit bu avareit simi beir? ");
INSERT INTO tbf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A kap. Enga nga sorokie man vona sel e Molek mi raban bitbit, ma ken kaemkaem e Repan manga raban bitbit. Ine arie bu patspats nga ta nga tsana nge rengeir rakot sien. Surie ine, o ta ture vavasie nga rakot i pek vekenan i Babilon nia tsatsang vinatoreis.’ ");
INSERT INTO tbf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bu tubugiet gi nga suvuon mi vona sel simi beir ian ta nga vara tuktuk ngan va e Raban a nga mon meie gie. Gi nga tsana malan e Raban ta nga vokokotie se Moses, vemusurie mi puppuo ta nga vasangan sien. ");
INSERT INTO tbf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ma i murien bu avareit, bu tubugiet ese gi tate nga suvuon mi vona sel, gi nga sorokie meie nge gie sien e Iosua ta nga muonge gie nge por tsana mi kaber sibu vuna enamon e Raban ta nga kareir vorotsoruo gie sien i muo sibu tubugiet. Ma ine mi vona sel a nga mon ian en oit sibu ra se Davit. ");
INSERT INTO tbf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","E Raban a nga resmatan e Davit ma e Davit a nga vereie nia tsana ka vonuo va mi kulu Israel gi ta nga rangarie e Raban en. ");
INSERT INTO tbf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Eiekesen e Solomon arie eie ese a nga tsana mi vona rengeir ken mi kulou nia rengeir en rakot se Raban. ");
INSERT INTO tbf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Eiekesen e Raban ese ta tsiroup a kap ko mon i aron bu vona rengeir ian mi kulou gi ta tsana ngan bu rimagie malan mi namanien mi propet ian ta nga pevien, ");
INSERT INTO tbf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Mi rangit eie kong mangmagoso Nguts nia vuor, ma mi kaber eie man poppop ba kameung. Mi sana suada vonuo nga ta tsana va seou? mi Nguts a pevien, Iva ngan kong enamon va o ta maes en? ");
INSERT INTO tbf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Vasa, a kap va eou keseung o nga tsana gie ine bu kepineits kokouk?’ ");
INSERT INTO tbf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Io, e Stepano a nga vasoma ken vinavinakokoit rakot sibu muomuo simi vinuor malan ine, “Enga mi kulou kov ngeisngeis! Bu aronga a mon i pek sorvekenan e Raban, ma bu tateringanga a te pi nia rongomie mi namanien! Nga malan mo bu tubunga. Nga ko munu rong tsak simi Moromoruo Tamat! ");
INSERT INTO tbf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ese propet bu tubunga gi kap nga vikikinie? Gi nga kenvamate buer bu propet gi ta nga vavatei katsep ngan ken bineit mi Ka Duis. Ma ine mi Ka, nga te nga roev terie i riman mi kulou kenken ma gi te nga kenvamate. ");
INSERT INTO tbf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Arie enga mo, nga ta nga suvuon ken vinuor e Raban, ian ta nga terie senga i riman bu angelo, eiekesen nga kap vemusurie.” ");
INSERT INTO tbf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sien bu muomuo simi vinuor gi tate nga rongomie ine, gi nga aor rarap veie ma gi nga kengeir nge nganapas veie. ");
INSERT INTO tbf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Eiekesen, e Stepano a nga vous ngan mi Moromoruo Tamat, ma a nga dedeng kien simi rangit nge pare man matvinavaso e Raban ma e Iesu ta nga tuir si ken riem suv e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Nga rorong!” e Stepano a nga oeng segie. “O pare mi rangit a katsep ma e Natuon mi Ka a tuir si ken riem suv e Raban!” ");
INSERT INTO tbf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sien bu muomuo simi vinuor gi ta nga rongomie ine mi nama, gi nga koup leong beitsak nge tsotsongie bu tateringagie ngan bu rimagie. Ma egie kokouk gi nga soererie nge rakopie. ");
INSERT INTO tbf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ma gi nga teie terie die i muirmuir simi taon nge tome nge vunavout. Mi kulou gi ta nga vepitsie nge nama e Stepano, gi nga kaor vuturungie magi sar kuirkuir i babaren ba kamen mi ka vour mi asan e Saulo. ");
INSERT INTO tbf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sien gi ta ngas nga vor ve tometome nge vunavout, e Stepano a nga no kien simi Nguts malan ine, “Mi Nguts e Iesu, e ta suvuon mi morumoruong.” ");
INSERT INTO tbf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma a nga sege pukupukukaek ma a nga koup leong, “Mi Nguts! Kian va e ta votorosie gie surie ine kegi sinavei tsokor gi ta tsana.” E Stepano a nga oeng malan ine ma a nga tsupuk rivie ken tino. ");
INSERT INTO tbf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma e Saulo a nga aor kes ngan mi kiden se Stepano. Ian simi ra, mi vinevinekikin leong a nga tsuok vakaek nge beit simi kulou vodovodon tuktuk i Ierusalem. Ma egie kokouk gi nga vi vepitsitsei rakot sibu korot mene simi provins i Iudea ma i Samaria, eiekesen bu aposol gi nga mon i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mi kulou gi ta nga ko mangaran e Raban gi nga puonongie e Stepano nge ta beitsak. ");
INSERT INTO tbf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Eiekesen e Saulo a nga vakaek nge voguersa gie mi kulou vodovodon tuktuk. A nga veisngie bu matavanuo nge teie tsana mi kulou ma mi langei vodovodon tuktuk nge vurukude gie simi vona vinatoreis. ");
INSERT INTO tbf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Io, egie ese gi ta nga vi vepitsitsei gi nga veis nge vavatei ngan mi Banga Vinavatei. ");
INSERT INTO tbf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","E Pilipo a nga rakot simi taon leong i Samaria ma a nga vavatei ngan man Banga Vinavatei mi Messia. ");
INSERT INTO tbf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sien mi bineit gi ta nga rongomie nge pare bu kepineits ni vovokudier e Pilipo ta nga tsana, gi nga rong poro mi sana ta nga pengan. ");
INSERT INTO tbf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bu tsaka moromoruo gi nga koup ram nge rovotsour vekenan bu mei palan, ma palan bu peong ma bu muru gi nga ketseketseng. ");
INSERT INTO tbf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Io, mi kulou simi taon gi nga res beitsak. ");
INSERT INTO tbf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mi tamatinuom a nga mon ine simi taon mi asan e Simon. A nga ko umuo bu kepineits sibu avareit palan ma bu Samaria gi nga kudier tsak sien. A nga ko vakam va eie mi ka asna. ");
INSERT INTO tbf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Misasien bu mei asna o, bu mei sasavoir, egie kokouk gi nga rong poro seie mi sana ta nga vokokotie. Gi nga ko pevien, “Ine mi ka arie eie ese gi ta vuotongie va ‘Mi ngesengesien leong e Raban’.” ");
INSERT INTO tbf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gi nga vemusurie simi vunan a nga ko umuo bu kepineits ma a nga vokudira gie sibu avareit palan. ");
INSERT INTO tbf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Eiekesen sien e Pilipo ta nga vavatei ngan mi Banga Vinavatei surie ken mangmagoso Nguts e Raban ma surie mi asan e Iesu Karisito, bu ka ma bu vevien gi nga vodovodon tuktuk sien nge por sinusuruiv. ");
INSERT INTO tbf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","E Simon buer a nga vodovodon tuktuk nge por sinusuruiv. Samo a nga vemusurie e Pilipo ma a nga kudier tsak sien ta nga pare bu kepineits leong ni vovokudier ma bu totourlekier ian ta nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bu aposol gi ta nga mon i Ierusalem gi nga rongovan va mi kulu Samaria gi nga suvuon mi namanien e Raban. Io, gi nga turan e Petro ma e Ioanes rakot segie. ");
INSERT INTO tbf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sien guor tate nga so beit, guor nga no surie mi kulou gi ta nga vodon vuris va gi ta mang nga suvuon mi Moromoruo Tamat, ");
INSERT INTO tbf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","simi vunan mi Moromoruo Tamat a kap ngas nga mon segie. Gi nga por sinusuruiv mo simi asan mi Nguts e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Samo e Petro ma e Ioanes guor nga teir riem i popogie, ma gi nga suvuon mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sien e Simon ta nga pare va mi kulou gi tate nga suvuon mi Moromoruo Tamat sien bu aposol gi ta nga teir riem i popogie, a nga lalaro voir tsana mi ngeisngeis se Petro meie e Ioanes. ");
INSERT INTO tbf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ma a nga pevien, “Ngado terie ine mi ngeisngeis seou buer, terengien va eie ese o ta teir riem i popon ta suvuon mi Moromoruo Tamat.” ");
INSERT INTO tbf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Eiekesen e Petro a nga oeng sien, “E Raban ta votsorovie ke lakep meie no, simi vunan e te vodon va e oit nia voirtsana ken tienebeir e Raban ngan mi lakep! ");
INSERT INTO tbf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","E kap suvu potpot o, sinsuv ine si kegei tsientsang, simi vunan mi aro a kap mon duis meie e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vodon vuris nge sorvekenan ke sar tsaka vienviendon nge no rakot simi Nguts va eie ta mang vodon rivie ke sar tsaka vienviendon. ");
INSERT INTO tbf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","O pare va e vous ngan mi tsaka vienviendon ma mi sinavei tsokor a visie no.” ");
INSERT INTO tbf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","E Simon a nga oeng se Petro ma e Ioanes, “Engado kokouk ngado no rakot simi Nguts surie iou terengien va mi sana ngado ta pengan seou, ta kap mang tsorubeit seou.” ");
INSERT INTO tbf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","I murien guor tate nga vakokoit vasangan nge vavatei katsep ngan man Banga Vinavatei mi Nguts, e Petro ma e Ioanes guor nga muerengei rakot i Ierusalem. Si keguor vineis muerengei, guor nga vavatei ngan mi Banga Vinavatei sibu enamon palan i Samaria. ");
INSERT INTO tbf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Io, ken angelo mi Nguts a nga vakokoit se Pilipo, “Tsuok tamtuir nge veis rakot simi rosar ian ta kovuni i Ierusalem rakot i Gasa.” (Ine mi rosar a mon simi beir.) ");
INSERT INTO tbf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Io, a nga tamtuir nge veis, ma si ken vineis a nga samsuoeie mi muomuo leong kovuni i Etiopia ese ta nga ko naneie bu lakep simi mangmagoso nguts simi kovakova vevien leong ta nga vuor i Etiopia. Eie a te nga ra rengeir i Ierusalem, ");
INSERT INTO tbf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma si ken vineis muerengei a nga mogos simi karis. Ma a nga ase mi Pakpak Leong e Isaia mi propet ta nga vataro. ");
INSERT INTO tbf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mi Moromoruo Tamat a nga oeng se Pilipo, “Veis rakot simi karis nge veis i babaren.” ");
INSERT INTO tbf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Io, e Pilipo a nga soer rakot simi karis nge rongomie ian mi ka ta nga aes simi Pakpak Leong se Isaia mi propet ma a nga vosuoreie, “E katsep simi sa e ta ase?” ");
INSERT INTO tbf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A nga kuil nama, “Vasa o ta katsep ven, sien va ka mei va ta kap palsie seou?” Io, a nga kuk vavane e Pilipo va ta nga mogos meie. ");
INSERT INTO tbf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mi korot ine mi muomuo leong ta nga ase simi Pakpak Leong a nga malan ine: “A nga malan mi sipsip gi ta kerie nia ra keda. Ma malan mi natu sipsip ta kap kieng sien va gi ta lutuo mi vuruvuruon, a kap nga vokokotie ka nama. ");
INSERT INTO tbf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gi nga mugumitsan ma a kap ka mei a nga tuir ken simi vinuor. Kap ka mei a oit nia teresan mi tubuon, simi vunan ken tino simi kaber a te me voto.” ");
INSERT INTO tbf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ine mi muomuo leong a nga vosuoreie e Pilipo, “Pengan seou, ese ine mi propet a vakokoit surie? Eie kesen o, ka mei mene?” ");
INSERT INTO tbf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Samo e Pilipo a nga vakaek nge vakokoit, ma a nga vakake ken nama ngan ian mi korot mi muomuo leong ta nga ase simi Pakpak Leong se Isaia mi propet ma a nga vateie ngan man Banga Vinavatei e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sien guor ta nga vor ve sosoer simi rosar, guor nga beit simi da ma mi muomuo leong a nga pevien, “Pare, mi da ine. Misa a tuir biritie iou va o ta kap por sinusuruiv?” ");
INSERT INTO tbf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ma e Pilipo a nga kuil nama, “Sien va evoi e vodovodon tuktuk ngan mi aro kokouk, e oit nia por sinusuruiv.” Ma mi muomuo leong a nga pevien, “O vodovodon tuktuk va e Iesu Karisito eie e Natuon e Raban.” ");
INSERT INTO tbf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma a nga oeng simi ka ta nga vasore mi karis va ta nga tuir. Samo e Pilipo ma mi muomuo guor nga tsour ma e Pilipo a nga tsana sien mi sinusuruiv ian simi da. ");
INSERT INTO tbf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sien guor ta nga vaen kien kovuni i da, puk lalapus mo, mi Morumoruan mi Nguts a nga kir rivie e Pilipo. Ma mi muomuo a kap ba nga pare. Ma a nga tsuok vakake ken vineis te buer ngan mi nires leong. ");
INSERT INTO tbf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Eiekesen e Pilipo a nga vorotan va eie a te nga mon i Atsoto ma a nga veis veriris sibu taon kokouk nge vavatei ngan mi Banga Vinavatei, tuir oit a nga beit i Kaesarea. ");
INSERT INTO tbf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Io, e Saulo a ngas nga vous ngan mi aor rarap nia kenvamate ken sar madar tovtov mi Nguts. Ma a nga rakot simi kovan bu prist. ");
INSERT INTO tbf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ma a nga ra vosuoreie ngan kavo pakapaka rorou nia rubukien sibu vona rengeir sibu Iuda i Damasko, terengien sien va ta vorotan ese ka o, vevien ta nga vemusurie mi saran mi Nguts, ta mang nga kerie gie nia ra tsatsang vinatoreis i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sien tate nga veis vatavatat i Damasko, mi berber leong kovuni simi rangit a si nga ber viririsie. ");
INSERT INTO tbf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A nga kor mutur i keim ma a nga rongomie mi ien ta nga pevien, “Saulo, Saulo, surie misa e ta vikikinie iou?” ");
INSERT INTO tbf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","E Saulo a nga virei, “Ka leong, evoi ese?” Mi ien a nga pevien, “Eou e Iesu ese e ta vikikinie. ");
INSERT INTO tbf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ine, tsuok tamtuir nge veis rakot simi taon. Ian en, gi ta pengan sevoi misa e ta tsana.” ");
INSERT INTO tbf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mi kulou gi ta nga nomeie e Saulo gi nga tuir menemenen. Gi kap nga vuotongie ka nama. Gi nga rongomie mi ien eiekesen gi kap nga dengarie ka mei. ");
INSERT INTO tbf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","E Saulo a nga tsuok tamtuir i keim nge vakakan, eiekesen a kap nga oit nia pare ka kepineits. Io, gi nga por ka i riman ma gi nga muongan rubukien i Damasko. ");
INSERT INTO tbf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Si ba ra tour a nga kael sien, ma a kap nga ngou nge un. ");
INSERT INTO tbf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","I Damasko mi madar tovtov a nga mon, mi asan e Ananias. I aron mi baidendeng, mi Nguts a nga oeng sien, “Ananias!” A nga kuil nama, “Io, mi Nguts.” ");
INSERT INTO tbf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mi Nguts a nga pevien, “Tamtuir nge veis rakot si ken vonuo e Iudas simi rosar gi vuotongie va mi Rosar Duis ma e ta so virei ngan mi ka kovuni i Tarsus, mi asan e Saulo. Ine a vor ve nono. ");
INSERT INTO tbf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Simi baidendeng, a te nga pare mi ka mi asan e Ananias a nga nemei nge teir riem i popon, terengien va ta mang dedeng te buer.” ");
INSERT INTO tbf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","E Ananias a nga kuil nama, “Mi Nguts, o nga rongomie bu nama surie ine mi ka sibu mei palan ma surie bu tsienakor ta nga tsana si ke kulou i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma ine a nemei ngan mi duis kovuni sibu prist leong nia rakopie gie ese gi ta vodovodon tuktuk simi asa.” ");
INSERT INTO tbf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Eiekesen mi Nguts a nga oeng sien, “Rakot! Ine mi ka o te vile nia vavatei ngan mi asoung i kotubugie bu Kibang ma bu kovakova ka leong ma i matan mi kulu Israel. ");
INSERT INTO tbf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","O ta vasangan sien vasa ta ngeisngeis ven mi vinekikin va ta suvuon surie mi asoung.” ");
INSERT INTO tbf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Io, e Ananias a nga veis rakot nge rubukien simi vonuo e Saulo ta nga mon en. Ma a nga teir riem i popon nge oeng sien, “Kasi, Saulo, mi Nguts e Iesu ese ta nga beit sevoi simi rosar sien e ta nga nemei ine, a tura iou terengien va e ta mang dedeng te buer ma e ta mang vous ngan mi Moromoruo Tamat.” ");
INSERT INTO tbf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ian ngas te, mi kepineits malan mi pipipiru ie a nga koro siba katsomatan e Saulo ma a nga oit nia dedeng te buer. Ma a nga tamtuir nge ra por sinusuruiv, ");
INSERT INTO tbf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ma i murien tate nga ngou voto, a nga muerengei beit ken ngeisngeis. E Saulo a nga mon ba ra mene meie mi kulou vodovodon tuktuk i Damasko. ");
INSERT INTO tbf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma a nga vakaek nge vavatei surie e Iesu sibu vona rengeir sibu Iuda va e Iesu eie e Natuon e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Egie ese gi ta nga rongomie mi namanien e Saulo, gi nga kudier tsak ma gi nga vereie, “Ine arie eie ese ta nga ko voguersa gie mi kulou i Ierusalem ese gi ta nga ko rangarie e Iesu, nge? Ma eie a te nemei nia rakopie nge kerie gie rakot sibu prist leong, nge?” ");
INSERT INTO tbf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eiekesen ken vinakokoit e Saulo a nga vor ve beitbeit ngeisngeis, ma a nga vasangan tuktuk va e Iesu eie mi Messia. Io, bu Iuda gi ta nga mon i Damasko gi nga rongomie mi namanien ma gi kap ba nga oit nia vokokotie ka nama. ");
INSERT INTO tbf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","I murien bu ra palan tate nga rovoriu, bu Iuda gi nga roev nia kenvamate e Saulo. ");
INSERT INTO tbf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Eiekesen e Saulo a te nga vakierngie kegi roevroev. Sibu rosisiat ma bu rokati, bu Iuda gi nga ko kok sibu mata rumrubukien simi taon nia kenvamate. ");
INSERT INTO tbf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Io, sikati ngas te ken sar madar tovtov gi nga vunurie e Saulo ngan mi leke teteir i muirmuir simi mat ian simi oiroir. ");
INSERT INTO tbf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sien e Saulo ta nga nemei i Ierusalem, a nga konon nia mon kouk meie bu madar tovtov, eiekesen gi nga motou, simi vunan gi kap nga vodon va eie mi madar tovtov tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Eiekesen e Barnabas a nga kerie ma a nga beit ngan sibu aposol. Io, a nga pengan segie vasa e Saulo a nga samsuoeie ven mi Nguts si ken vineis, ma vasa mi Nguts a nga vakokoit ven sien, ma i Damasko, vasa a nga vakokoit venengan mi asan e Iesu ngan mi aor ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Io, e Saulo a nga mon meie gie. Ma a nga veis veriris i Ierusalem nge vavatei ngan mi asan mi Nguts meie ngan mi aor ngeisngeis. ");
INSERT INTO tbf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A nga vakokoit nge nama vevengeis meie bu Iuda kovuni i Grik, eiekesen gi nga lalaro kenvamate e Saulo. ");
INSERT INTO tbf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sien mi kulou vodovodon tuktuk gi ta nga vakierngie ine, gi nga kerie e Saulo rakot i Kaesarea ma gi nga ture vavasie rakot i Tarsus. ");
INSERT INTO tbf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Io, i aron i Iudea, i Galili ma i Samaria, mi kulou vodovodon tuktuk gi nga tino ngan mi molu meie mi aor koits. Gi nga ko munu mon ngan mi minangarei rakot simi Nguts. Ma mi Moromoruo Tamat a nga vakotsie bu arogie ma mi aesaes segie a nga vor ve leongleong. ");
INSERT INTO tbf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Io, e Petro a nga vesingie bu korot kokouk, ma i aron ken vineis mene, a nga rakot i Lidda nia ra irogie mi kulou vodovodon tuktuk gi ta nga mon ian en. ");
INSERT INTO tbf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ian en, a nga vorotan mi ka, mi asan e Aeneas ese ta nga muru sibu avareit mi napaririem potsu tour ma a nga ko vor ve mutumutur mo simi tsur. ");
INSERT INTO tbf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","E Petro a nga oeng sien, “Aeneas, e Iesu Karisito a vatoa no. Tsuok tamtuir nge vil vakalaie ke mutumutur.” Ma ian ngas te e Aeneas a nga tsuok tamtuir. ");
INSERT INTO tbf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Egie kokouk gi ta nga mon i Lidda ma i Saron, gi nga pare ine ma gi nga vodon vuris rakot simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Io, i Ioppa mi vevien a nga mon en, ma a nga vodovodon tuktuk simi Nguts. Mi asan e Tabita. Simi namani Grik gi vuotongie ngan e Dokas, ma a nga ko tsana mi kienelei ma a nga ko kulie bu sinaortsak. ");
INSERT INTO tbf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ian simi ra, a nga morouk nge maet, ma mi piripirien gi nga suruvie nge sor terie simi roruom i kur. ");
INSERT INTO tbf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","I Lidda a mon vatavatat i Ioppa. Io, sien mi kulou vodovodon tuktuk gi ta nga rongomie va e Petro a nga mon i Lidda, gi nga turan ba ka luo rakot sien ngan mi nama ven ne, “Lalapus nemei segei!” ");
INSERT INTO tbf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Io, e Petro a nga tamtuir nge vemusurie guor. Sien tate nga so beit gi nga so kerie kien simi roruom i kur. Bu vevien naor kokouk gi tate nga mamaet labeit gi nga tuir i babaren e Petro ma gi nga ta nge vasangan bu kuirkuir ma bu lavlav meie bu tsetstseik mene buer e Dokas ta nga ko tsana gie sien ta ngas nga to. ");
INSERT INTO tbf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","E Petro a nga ture vorotsoruo gie kokouk, ma a nga sege pukupukukaek nge no. Samo a nga matan veie mi vevien maet, ma a nga pevien, “Tabita, tamtuir.” Ma mi vevien a nga vakakan, ma sien ta nga pare e Petro a nga tsuok tamtuir nge mogos. ");
INSERT INTO tbf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","E Petro a nga por ka i riman nge kulie nia tsuok tamtuir. Samo a nga kukuo mi kulou vodovodon tuktuk meie bu vevien naor ma a nga vasangan segie va ine mi vevien a te to. ");
INSERT INTO tbf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Man vinavatei misa e Petro ta nga tsana, a nga puorkan mi enamon kokouk i Ioppa, ma mi kulou palan gi nga vodovodon tuktuk simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","E Petro a nga mon i Ioppa bu ra palan meie mi ka mi asan e Simon eie mi ka tsangtsang piripiri bulumakau. ");
INSERT INTO tbf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Io, mi ka a nga mon i Kaesarea, mi asan e Konelius. Eie mi muomuo simi kulou ni minakiur sibu Roma, mi gargar gi ta vuotongie va bu Italia. ");
INSERT INTO tbf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Eie ma ken tietie kokouk gi nga ko mangaran e Raban. Ma a nga ko kulie buer bu Iuda gi ta nga mogos sinaortsak, ma a nga ko no rakot se Raban. ");
INSERT INTO tbf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Simi ra mene, a nga malan va simi 3 kilok sireivreiv, e Konelius a nga pare mi baidendeng a nga katsep beitsak. A nga pare mi angelo se Raban ta nga rubukien nge pevien, “Konelius!” ");
INSERT INTO tbf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","E Konelius a nga motou beitsak ma a nga deng vangvangasie nge pevien, “Mi Nguts, misa e lalaron?” Mi angelo a nga kuil nama, “E Raban a resmata no surie ke sar nono ma ke sar kuilkuil sibu sinaortsak. Ine bu kepineits e ta ko munu tsana a malan mi tienebeir rakot se Raban. ");
INSERT INTO tbf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nevere, turan kaba ka rakot i Ioppa nia kerie mi ka mi asan e Simon, mi asan mene e Petro. ");
INSERT INTO tbf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Eie a mon si ken vonuo e Simon, mi ka tsangtsang piripiri bulumakau. Ken vonuo a mon i koen.” ");
INSERT INTO tbf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mi angelo a nga pevien malan ine se Konelius ma a nga sorvekenan. Ma e Konelius a nga kukuo ken ba petspets luo ma mi ka simi minakiur. Ine mi ka simi minakiur a nga ko rengeir rakot se Raban, ma guor nga ko mon e Konelius. ");
INSERT INTO tbf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","I murien ta nga pengan segituo misa ta nga tsorubeit sien, a nga tura gituo rakot i Ioppa nia ra kerie e Petro. ");
INSERT INTO tbf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Simi ra vemusurie sien ian ba ka tour gituo ta nga vor ve veisveis rakot vatavatat simi taon i Ioppa, e Petro a te nga vaen i popon mi vonuo nia ra no. A nga malan va sisiat potaram. ");
INSERT INTO tbf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","E Petro a te nga vitor ma a nga lalaro ngou. Sien gi ta nga vor ve rorrois ngan mi nginonginou, a nga pare mi baidendeng. ");
INSERT INTO tbf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A nga pare mi rangit ta nga katsep ma a nga pare mi kepineits malan mi lavlav leong gi nga popor ka siba tangatson voveit nge vunurie peuk i keim. ");
INSERT INTO tbf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A nga vous ngan bu suasuada vinavinar kaek voveit, bu vinavinar gi ta dodoil simi kaber, ma bu ma simi mariu. ");
INSERT INTO tbf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Samo mi ien a nga oeng sien, “Petro! Tamtuir! Keda kavo mene nge nganie.” ");
INSERT INTO tbf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","E Petro a nga kuil nama, “O kap oit tuktuk, mi Nguts! O kap ngas nganie ka kepineits ivie mi vinuor sibu Iuda ta nga gol kitipan nia nganie ma gi vuotongie va a kap melemelen.” ");
INSERT INTO tbf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mi ien a nga oeng sien te buer, “Kian va e ta vuotongie ka kepineits va a kap melemelen ian e Raban tate nga vara melemelen ngan.” ");
INSERT INTO tbf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ine mi kepineits a nga beit votour. Ma ian ngas te gi nga por muerngan ine mi lavlav leong kien i kur simi rangit. ");
INSERT INTO tbf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Sien e Petro ta ngas nga vor ve vodovodon surie man vuevue ine ken baidendeng, ba ka e Konelius ta nga tura gituo, gituo te nga beit si ken vonuo e Simon ma gituo nga tuir simi rumrubukien. ");
INSERT INTO tbf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ma gituo nga virei va e Simon mi asan mene e Petro a mon ian o, kap. ");
INSERT INTO tbf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sien e Petro ta ngas nga vor ve vodovodon surie ine ken baidendeng, mi Morumoruan mi Nguts a nga oeng sien, “Petro, ba ka tour gituo nesie no. ");
INSERT INTO tbf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tsuok tamtuir nge rovotsour. Kian va e ta meikmekikir nia nomeie gituo simi vunan eou ngas te o tura gituo.” ");
INSERT INTO tbf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","E Petro a nga rovotsour nge pevien segituo, “Mi ka ngatuo ta nesie, arie eou mo. Ngatuo nesie iou surie misa?” ");
INSERT INTO tbf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gituo nga kuil nama, “E Konelius, mi muomuo simi kulou ni minakiur sibu Roma, a tura gatuo. Eie mi ka duis ma a ko mangaran e Raban, ma bu Iuda gi ko mangaran. Ken angelo e Raban a nga oeng sien va ta tuturei surie no va e ta nemei si ken vonuo, terengien va ta mang rongomie misa va e ta vokokotie.” ");
INSERT INTO tbf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Samo, e Petro a nga oeng segituo va gituo ta be nga mon meie mi kati kes. Simi ra vemusurie, e Petro ma ba ka gituo nga tsuok nge vineis meie mi kulou vodovodon tuktuk kovuni i Ioppa. ");
INSERT INTO tbf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Simi ra vemusurie, gi nga so beit i Kaesarea. E Konelius a nga rosie gie. A nga kuk kakuon bu patsan ma bu palapalan tuktuk nemei si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sien e Petro ta nga visi rubukien, e Konelius a nga suoeie e Petro, ma a nga sege pukupukukaek nge rengeir rakot seie. ");
INSERT INTO tbf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Eiekesen e Petro a nga tsuok voturie nge oeng sien, “Tsuok tamtuir. Eou buer mi ka mo.” ");
INSERT INTO tbf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","E Petro a nga vor ve patapatar se Konelius sien guor ta nga veis rubukien, ma a nga vorotan palan bu mei gi ta nga mon en. ");
INSERT INTO tbf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma a nga pevien, “Nga telekiran a kap duis si kegei vinuor va ka mei sibu Iuda va ta mon meie o, iro ka kibang. Eiekesen e Raban a te vasangan va eou o ta kap pevien ngan ka mei va a kap tamat, o, a kap melemelen. ");
INSERT INTO tbf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Io, sien nga ta tuturei surie iou, o nemei senga, ma o kap oeng ngan ka nama va o ta kap nemei. O ta vereie nga, surie misa nga ta tuturei surie iou?” ");
INSERT INTO tbf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","E Konelius a nga kuil nama, “Ba ra voveit a te rovoriu, o nga no rakot se Raban i aron kong vonuo simi 3 kilok sireivreiv. Samo o nga pare mi ka ta nga tuir i matoung, ma man sar tsetstseik gi nga kutsukutsuleip. ");
INSERT INTO tbf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ian mi ka a nga pevien seou, ‘Konelius! E Raban a te rongomie ke sar nono, ma a vodonomie ke tienebeir nia kulie bu sinaortsak. ");
INSERT INTO tbf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Turan kaba ka rakot i Ioppa nia ra kerie mi ka, mi asan e Simon, mi asan mene e Petro. Ine mi ka a mon simi vonuo se Simon, eie mi ka tsangtsang piripiri bulumakau. Ken vonuo a mon i koen.’ ");
INSERT INTO tbf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ma ian ngas te, o nga tuturei surie no, ma a kalei sien e beit vorota gei. I matan e Raban, gei rorois nia rongomie misa magiet Nguts a oeng ngeisngeis sevoi va e ta pengan segei.” ");
INSERT INTO tbf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Io, e Petro a nga tsuok vakaek nge vinakokoit, “Ine o nangba katsep va a tuktuk rovoriu va e Raban a kap ko puluo mo ka ba mei eiekesen a ko lalaron bu suasuada mei kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sibu vuna enamon kokouk, eie ese ta mangaran e Raban ngan mi mientou nge tsana mi sinavei duis, e Raban ta sunurie va seie. ");
INSERT INTO tbf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nga telekiran mi nama e Raban ta nga terie sibu Israel. Ine mi nama a vavatei ngan man banga vinavatei mi molu ian ta nga beit ngan e Iesu Karisito. Eie mi Nguts sibu mei kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nga telekiran mi sana kepineits tate nga tsorubeit simi enamon kokouk i Iudea vakaek i Galili, i murien e Ioanes ta nga vavatei ngan mi sinusuruiv. ");
INSERT INTO tbf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma nga telekiran surie e Iesu kovuni i Nasaret va e Raban a nga vokunie ngan mi Moromoruo Tamat ma mi ngeisngeis. E Raban a nga mon meie. Io, e Iesu a nga rakot sibu enamon kokouk nge tsana mi kienlei ma a nga vatoa bu mei kokouk gi ta nga mon i pakien mi ngesengesien mi tsaka moromoruo. ");
INSERT INTO tbf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Egei gei vara tuktuk ngan bu kepineits kokouk ta nga tsana gie simi enamon sibu Iuda ma i Ierusalem. Gi nga vetekiuo simi koitskoits. ");
INSERT INTO tbf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Eiekesen, simi ra a tourngan, e Raban a nga vatoa, ma a nga tsana va ta nga tsorubeit vasvas simi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A kap va simi kulou kokouk, eiekesen segei mo ese e Raban tate nga viel tsana va gei ta vara tuktuk ngan bu kepineits tate nga tsorubeit. Egei gei nga un nge ngou meie i murien e Iesu ta nga to muerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma e Iesu a nga tura gei va gei ta vavatei ngan mi nama rakot simi kulou kokouk ma a nga tura gei va gei ta vakokoit vasangan va eie mi Ka e Raban tate nga vile nia vuortie egie gi ta ngas to ma egie gi tate maet. ");
INSERT INTO tbf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bu propet kokouk gi nga vakokoit katsep ngan va mi kulou kokouk gi ta vodovodon tuktuk sien, kegi sar sinavei tsokor e Raban ta vodon rivie ngan mi ngesengesien mi asan.” ");
INSERT INTO tbf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sien e Petro ta ngas nga vor ve vakvakokoit, mi Moromoruo Tamat a nga peuk i popogie gi ta nga rongomie ine mi vinavatei. ");
INSERT INTO tbf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bu Iuda simi vodovodon tuktuk gi ta nga nomeie e Petro, gi nga kudier va e Raban a nga terie mi Moromoruo Tamat sibu Kibang buer. ");
INSERT INTO tbf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Simi vunan, gi nga rongomie gie va gi nga vakokoit ngan bu suada nama sibu enamon mene nge puongan e Raban. E Petro a nga pevien, ");
INSERT INTO tbf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ine mi kulou gi te suvuon mi Moromoruo Tamat malan mo egiet. Vasa, ka mei a oit nia tuir biritie gie va gi ta por sinusuruiv ngan mi da?” ");
INSERT INTO tbf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ma a nga oeng ngeisngeis segie va gi ta por sinusuruiv simi asan e Iesu Karisito. Ma gi nga vereie e Petro va ta nga mon meie gie si kaba ra. ");
INSERT INTO tbf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bu aposol ma mi kulou vodovodon tuktuk se Iesu simi enamon leong i Iudea gi nga rongomie va bu Kibang buer gi te nga vodovodon tuktuk si ken nama e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Io, sien e Petro tate nga beit i Ierusalem, egie bu Iuda simi vodovodon tuktuk, gi nga oeng matan ");
INSERT INTO tbf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nge pevien ne, “Surie misa e ta nga rakot simi korot sibu Kibang gi ta kap ko vavaroup ma e nga ra ngou meie gie?” ");
INSERT INTO tbf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Eiekesen e Petro a nga vakokoit vakatsepa segie mi sana kepineits ta nga tsorubeit seie. ");
INSERT INTO tbf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Sien o ta nga mon simi taon i Ioppa nge no, o nga pare mi baidendeng. O nga pare mi kepineits a nga malan mi lavlav leong gi ta nga popor ka siba tangatson voveit nge vunurie peuk i keim kuvu i kur simi rangit, ma a nga peuk duis seou. ");
INSERT INTO tbf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","O nga dedeng rakot i aron ma o nga pare bu suasuada vinavinar kaek voveit, bu vinavinar tso, bu vinavinar gi ta dodoil simi kaber, ma bu ma simi mariu. ");
INSERT INTO tbf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma o nga rongomie mi ien a nga pevien seou, ‘Tamtuir, Petro, keda kavo mene nge nganie!’ ");
INSERT INTO tbf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Eiekesen o nga pevien, ‘O kap oit, mi Nguts! O kap ngas nga nganie ka nginonginou ta kap melemelen ivie mi vinuor sibu Iuda ta nga gol kitipan nia nganie.’ ");
INSERT INTO tbf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ma mi ien a buer nga vakokoit kovuni simi rangit, ‘Mi kepineits e Raban tate nga vara melemelen ngan, e ta kap pevien va a kap melemelen.’ ");
INSERT INTO tbf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ine mi kepineits a nga tsorubeit votour seou, ma ine bu kepineits kokouk gi nga teie muerngan kien simi rangit. ");
INSERT INTO tbf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ian simi poko keipkepide ra ngas te, ba ka tour gituo te nga beit simi vonuo ivie o ta nga mon en. Mi ka a nga mon i Kaesarea a nga tura gituo nemei seou. ");
INSERT INTO tbf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma mi Moromoruo Tamat a nga oeng seou va o ta nga nomeie gituo, ma o ta kap nga vodovodon palan. Ma ine mi napaririem potsu kes mi kulou vodovodon tuktuk kovuni i Ioppa gi nga nomeie iou, ma gei nga ra beit si ken vonuo ian mi ka. ");
INSERT INTO tbf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma a nga pengan segei va a nga pare mi angelo a nga tsorubeit vasvas i aron ken vonuo. Ma mi angelo a nga pevien sien ven ne, ‘Tuturei surie e Simon gi vuotongie buer va eie e Petro ese ta mon i Ioppa. ");
INSERT INTO tbf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ma eie ta vokokotie bu nama sevoi, vasa e Raban ta vatoa no ven ma ke tietie simi sinavei tsokor.’ ");
INSERT INTO tbf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ma sien o ta nga vakaek nge vakokoit, mi Moromoruo Tamat a nga tsour peuk segie malan ta nga tsorubeit vourvour te segiet. ");
INSERT INTO tbf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma o nga vodonomie misa mi Nguts ta nga pengan, ‘E Ioanes a nga tsana mi sinusuruiv ngan mi da, eiekesen enga nga ta suvuon mi sinusuruiv ngan mi Moromoruo Tamat.’ ");
INSERT INTO tbf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","E Raban a nga terie buer sibu Kibang ine mi tienebeir ta kokouk mo meie mi tienebeir ian ta nga terie segiet sien giet ta nga vodovodon tuktuk simi Nguts e Iesu Karisito. Ma o kap oit nia vangenge mi tsinatsangan e Raban segie.” ");
INSERT INTO tbf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sien gi ta nga rongomie ine bu nama se Petro, gi kap ba buer nga nama palan veie ma gi nga puongan e Raban ma gi nga pevien, “Ine giet te telekiran va e Raban a te sunuir va bu Kibang buer gi ta vodon vuris terengien va gi ta mang suvuon mi tino rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sien gi tate nga kenvamate e Stepano gi nga vikikinie buer egie ese gi ta nga vodovodon tuktuk se Iesu. Io, mi kulou vodovodon tuktuk gi nga vi vepitsitsei rakot i Poinike, i Kupro, ma i Antiok. Ma gi nga ra vokokotie man Banga Vinavatei e Iesu sibu Iuda mo. ");
INSERT INTO tbf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eiekesen mi kulou vodovodon tuktuk mene kuvu i Kupro ma i Kurene, gi nga rakot i Antiok nge vokokotie man Banga Vinavatei mi Nguts e Iesu sibu Grik buer. ");
INSERT INTO tbf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ma mi ngesengesien mi Nguts a nga mon segie, ma palan beitsak bu mei gi nga vodovodon tuktuk nge vuvuris rakot simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ine mi vinavatei a te nga beit simi kulou vodovodon tuktuk i Ierusalem, ma gi nga turan e Barnabas rakot i Antiok. ");
INSERT INTO tbf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sien ta nga so beit nge pare mi sana e Raban tate nga tsana simi kulou surie ken tentoiv, a nga res ma a nga vakotsie gie va gi ta nga tsok tuktuk simi Nguts ngan bu arogie kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","E Barnabas eie mi banga ka, ma a nga vous ngan mi Moromoruo Tamat ma a nga vodovodon tuktuk rovoriu, io, palan beitsak mi kulou gi nga vurise tino rakot simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Samo e Barnabas a nga rakot i Tarsus va ta nga ra pare e Saulo. ");
INSERT INTO tbf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sien tate nga ra vorotan, a te nga kir rakot ngan i Antiok. Io, ian simi avareit kokouk, guor nga mon meie gie mi kulou vodovodon tuktuk, ma guor nga vavasengei simi kulou palan beitsak ngan mi namanien e Raban. Ma gi nangba nga vuotongie gie ngan va Ken kulou e Karisito vourvour i Antiok. ");
INSERT INTO tbf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ian simi ra, bu propet mene gi ta nga kuvu i Ierusalem gi nga peuk i Antiok. ");
INSERT INTO tbf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mi mei kes segie mi asan e Agabus, a nga tamtuir ma simi ngesengesien mi Moromoruo Tamat a nga peterie va mi se leong va ta nga beit simi kaber kokouk. Ma sien e Klaudio ta nga vuor i Roma, ine mi se a te nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Io, ine mi kulou vodovodon tuktuk i Antiok gi nga vodon vuturungie nia vavasie kegi sar lakep nia kulie bu kasigie i Iudea. Io, gi nga teteir oit si kegi sar sinsuv. ");
INSERT INTO tbf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ma gi nga turan e Barnabas meie e Saulo nia ra terie ian mi lakep sibu muomuo simi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ian sibu ra mi kovakova ka leong e Erot a nga rakopie mi kulou vodovodon tuktuk nia ra vikikinie gie. ");
INSERT INTO tbf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A nga oeng va gi tate nga kenvamate e Iakobo, e kasien e Ioanes, ngan mi sele. ");
INSERT INTO tbf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Sien e Erot ta nga telekiran ine mi kiden a nga varese gie bu Iuda, a nga tuturei nia rakopie buer e Petro. Ine bu kepineits a nga tsorubeit simi Nginou nian mi Tsoik kap ka iis sien. ");
INSERT INTO tbf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","I muir sien gi tate nga rakopie, a nga terie simi vona vinatoreis. A nga terie i riman ba gargar voveit simi kulou ni minakiur va gi ta nga naneie vititirie. E Erot a nga vodon nia vuortie e Petro i matan mi kulou i murien mi Nginu Pasova va tate nga voto. ");
INSERT INTO tbf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Io, e Petro a nga mon simi vona vinatoreis, eiekesen mi kulou vodovodon tuktuk gi nga no ngan bu arogie kokouk rakot se Raban surie e Petro. ");
INSERT INTO tbf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Simi rokati, va sivovo sien va e Erot ta nga vo vuortie, e Petro a nga muang i kotubuon ba ka luo ni minakiur. Gi nga vis kakuon bu rimagituo ngan ba tsen luo. Ma mi kulou nennei gi nga tuir nge nenei simi matavanuo. ");
INSERT INTO tbf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Puk lalapus, ken angelo mi Nguts a nga tsorubeit ma mi berber a nga rar i aron mi vona vinatoreis. Samo a nga pan vapada e Petro, ma a nga oeng sien, “Lalapus! Tamtuir!” Ian ngas te mi tsen a nga koro siba riman e Petro. ");
INSERT INTO tbf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Io, mi angelo a nga oeng sien, “Verengie no ngan ke verevere nge tsekie ma ba poppop.” Ma e Petro a nga tsang malan ngan. Ma mi angelo a nga oeng sien te buer, “Tsekie ma kuirkuir ka i marar nge vemusurie iou.” ");
INSERT INTO tbf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","E Petro a nga vemusurie rovotsour simi vona vinatoreis. Eiekesen a kap nga telekiran mi kepineits mi angelo ta nga tsana va a nga tuktuk. A si nga vodon va a nga pare mo mi baidendeng. ");
INSERT INTO tbf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Guor nga veis evisie mi ka ni minakiur vourvour ma mi mei vorosurie nge ra beit simi mata rumrubukien gi ta nga tsana ngan mi aen, ivie guor nga oit nia dedeng rakot simi taon leong. Ine mi mata rumrubukien, eie kesen a nga katsep ma guor nga rovotsour sien. Sien guor tate nga veis rakot simi rosar, puk lalapus, mi angelo a te nga sorvekenan e Petro. ");
INSERT INTO tbf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Io, ken vienviendon e Petro a nangba nga katsep ma a nga pevien, “Ine, o te telekiran va ine mi kepineits a tuktuk. Mi Nguts a turan ken angelo nemei nia me kir rivie iou si ken ngeisngeis e Erot ma simi sana kepineits bu Iuda gi ta nga vodon nia tsana seou.” ");
INSERT INTO tbf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ma ian ngas te, a nga rakot si ken vonuo e Maria, e kinan e Ioanes gi nga ko vuotongie buer ngan e Marko, ivie bu mei palan gi ta nga oir kouk nge no en. ");
INSERT INTO tbf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","E Petro a nga me pinpin i matavanuo ma mi vevien petspets mi asan e Roda a nga nemei nia me vavatora sien. ");
INSERT INTO tbf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sien ta nga rong kielala mi inan e Petro, a nga res beitsak, io, a si kap nga tsitsingie mi matavanuo eiekesen a nga soer muerengei. Ma a nga ra pengan va e Petro die a tuir i marar simi matavanuo. ");
INSERT INTO tbf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ma gi nga pevien ne, “E be goit!” Eiekesen a ngas nga vengeis va a nga tuktuk te. Io, gi nga pevien, “Ken angelo be mo ian.” ");
INSERT INTO tbf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eiekesen e Petro a ngas nga vor ve pinpin, ma sien gi ta nga tsitsi nge pare va eie, gi nga kudier ngan. ");
INSERT INTO tbf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ma e Petro a nga tam vosoponge gie. Ma a nga potsukie segie vasa mi Nguts a nga kir tsana venengan simi vona vinatoreis ma a nga oeng ven ne, “Nga vateie e Iakobo ma bu kasiung ngan ine mi kepineits.” Samo a te buer nga rovotsour sorvekena gie nge rakot simi korot mene. ");
INSERT INTO tbf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sien tate nga vo ra, bu ka ni minakiur gi nga kudier tsak nge motou simi sana ta nga tsorubeit se Petro. ");
INSERT INTO tbf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ma e Erot a nga terie mi nama nia nesie e Petro, eiekesen gi kap nga oit nia vorotan. Ma a nga virei telekira gie, ma a nga terie mi nama ngeisngeis nia kenvamate ine bu ka ni minakiur. Ma i muir sien, e Erot a te nga sorvekenan i Iudea nge ra mon i Kaesarea. ");
INSERT INTO tbf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","E Erot a nga petseir veie beitsak mi kulou kovuni i Turos ma i Sidon, io, mi kulou gi nga veis kokouk nia ra pare e Erot. Muna, gi nga ra vuduis nama meie e Blasto, mi ka ese ta nga vuortie ken vonuo mutumutur mi kovakova ka leong, va ta nga kulie gie. I muir, gi nga ra vereie e Erot surie ken aor molous, simi vunan gi nga ko por nginonginou simi enamon simi kovakova ka leong. ");
INSERT INTO tbf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Io, e Erot a nga terie mi ra, ma ian simi ra a nga vavaso ngan man sar matvinavaso mi kovakova ka leong, ma a nga mogos i popon mi mogomogos ni vuor ma a nga vakokoit rakot simi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ma mi kulou gi nga koup, “A malan va mi inan mi raban, kap va mi inan mi ka!” ");
INSERT INTO tbf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ma ian ngas te ken angelo mi Nguts a nga pantsie e Erot, simi vunan a kap nga puongan e Raban, ma bu kunkun gi te nga nganie mi kurikurien ma a te nga maet. ");
INSERT INTO tbf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Eiekesen, mi namanien e Raban a nga puorkan bu enamon palan nge to. ");
INSERT INTO tbf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sien e Barnabas meie e Saulo guor tate nga vaton keguor tsientsang, guor nga muerengei kovuni i Ierusalem, ma guor nga kerie e Ioanes mi asan mene e Marko. ");
INSERT INTO tbf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","I kotubuon mi kulou vodovodon tuktuk i Antiok, bu propet ma bu vavvasengei simi Pakpak Leong gi nga mon. Bu asagie e Barnabas, e Simeon mi asan mene e Niger, e Lusius kovuni i Kurene, ma e Manaen (ese ta nga leong kouk meie e Erot mi kovakova ka leong) ma e Saulo. ");
INSERT INTO tbf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sien gi ta nga rengeir rakot simi Nguts nge vorvor, mi Moromoruo Tamat a nga pevien, “Nga ta ngas totoka e Barnabas ma e Saulo nian mi tsientsang o ta nga vile guor nia tsana.” ");
INSERT INTO tbf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Io, i murien gi ta nga vorvor nge no, gi nga teir riem i popoguor nge vatamase guor ma gi nga ture vavasie guor. ");
INSERT INTO tbf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Io, guor nga veis vemusurie ken tinuturei mi Moromoruo Tamat. Guor nga veis peuk i Seleukia ma guor nga ka mon rakot i Kupro. ");
INSERT INTO tbf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sien guor ta nga beit i Salamis, guor nga vavatei ngan mi namanien e Raban sibu vona rengeir sibu Iuda. E Ioanes Marko a nga nomeie guor nia kulie guor si keguor tsientsang. ");
INSERT INTO tbf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Gituo nga veis viririsie bu enamon kokouk simi nuos oit gituo nga beit i Papo. Ian en gituo nga samsuoeie e Ba-Iesu, mi tamat inum. Eie mi Iuda ma buer mi propet bitbit. ");
INSERT INTO tbf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Eie a nga ko mon meie mi gavana e Segio Paulo, mi ka sievei. Mi gavana a nga tuturei surie e Barnabas ma e Saulo simi vunan a nga lalaron nia rongomie ken nama e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Eiekesen e Eluma mi tamat inum (arie man vuevue ine mi asan) a nga suerere gituo ma a nga konon nia vurisan ken vienviendon mi gavana va ta kap nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Samo e Saulo, ese gi vuotongie ngan e Paulo, a nga vous ngan mi Moromoruo Tamat, ma a nga deng vangvangasie e Eluma nge pevien, ");
INSERT INTO tbf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Evoi e natuon e Satan ma man matakorot bu kepineits kokouk ian ta dokei! E vous ngan bu suada sinavei nguts bitbit ma bu sinavei nia tsik pipius. Sisa e ta maes nia vurivurisan mi rosaran mi Nguts ian ta duis? ");
INSERT INTO tbf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pare, mi riman mi Nguts a mon i popo nia votorosie no. E ta so mat kael ma si kavo ra, e ta kap oit nia pare mi rararan mi matanias.” Ian ngas te, mi ou ma mi ngingi a nga kuva ba katsomatan ma a nga veis mat kael veririu nge nesie ka mei va ta nga por ka i riman nge muo ngan. ");
INSERT INTO tbf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Samo, mi gavana a nga kudier beitsak si man vinasengei mi Nguts ma a nga vodovodon tuktuk sien ta nga pare misa tate nga tsorubeit. ");
INSERT INTO tbf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kovuni i Papo, e Paulo ma ba palapalan, gituo nga ka mon rakot i Pega simi enamon leong i Pampilia. Ian en e Ioanes Marko a nga sorvekena guor nge rakot i Ierusalem. ");
INSERT INTO tbf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kovuni i Pega guor nga veis rakot i Antiok i aron i Pisidia. Ma simi Rangi Minaes guor nga rakot simi vona rengeir sibu Iuda nge mogos. ");
INSERT INTO tbf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","I murien gi ta nga ase bu nama simi Vinuor se Moses ma sibu vinavataor sibu propet, bu muomuo simi vona rengeir gi nga turan mi nama rakot seguor nge pevien, “Ba kasi, sien va ngado suvu nama nia vangasie mi kulou, ngado ta vakokoit.” ");
INSERT INTO tbf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","E Paulo a nga tuir ma a nga tsuok terie i kur ba riman nge pevien, “Enga kong kulou Israel ma enga bu Kibang nga vodovodon tuktuk se Raban, nga rorong seou! ");
INSERT INTO tbf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Magiet Raban ine mi kulou Israel a nga vile bu tubugiet ma a nga vara veleongtie gie si kegi minon i Isip. Ma ngan mi ngeisngeis leong, a nga muonge gie rovotsour ian simi enamon. ");
INSERT INTO tbf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","A kap nga mekitsan mi sinavigie i aron mi beir sibu avareit ta nga oit malan va ba sinangavur voveit. ");
INSERT INTO tbf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","E Raban a nga tsang rivie bu vuna enamon a nga napaririem potsu luo simi enamon leong i Kanaan ma a nga potakie mi kaber nge terie simi kuoluon. ");
INSERT INTO tbf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Bu kepineits kokouk ine ta nga tsorubeit a nga poro malan va bu avareit ba sinangavur voveit koboit ma bu sinangavur mi napaririem i popon (450). “I muir, a nga terie segie bu ka ma ba vevien nia vuortie gie, tuir oit sibu ra se Samuel mi propet. ");
INSERT INTO tbf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samo mi kulou gi nga virei ngan ka kovakova ka leong ma a nga terie segie e Saulo e natuon e Kis simi matabu Beniamin, ese ta nga vuor sibu avareit ba sinangavur voveit. ");
INSERT INTO tbf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","I murien e Raban ta nga tsang rivie e Saulo a nga tsana e Davit va eie magi kovakova ka leong. A nga vavatei katsep ngan surie e Davit malan ine, ‘O te vorotan e Davit e natuon e Iesse va eie mi ka ta lalaron beitsak nia vemusurie bu sinaviung. Eie ta tsana bu kepineits kokouk vemusurie kong lalaron.’ ");
INSERT INTO tbf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kovuni sibu tubuon e Davit, e Raban a nga terie sibu Israel mi ka ni vavato e Iesu, malan ken kinubuits. ");
INSERT INTO tbf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","I muan ken bineit e Iesu, e Ioanes a nga vavatei ngan mi sinavei nia vodon vuris ma mi sinusuruiv simi da rakot sibu Israel kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sien e Ioanes tate nga vor ve vavaton ken tsientsang, a nga pevien, ‘Nga vodon va eou ese? Kap va eou ian mi ka. Eiekesen eie ian ta vemusurie iou, o kap kalei oit nia ruobatie man ba poppop.’ ");
INSERT INTO tbf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Bu kasi, bu natuon e Abaraam, ma enga mi kulou vodovodon tuktuk, ine mi vinavatei surie mi vavato, e Raban a nga terie segiet. ");
INSERT INTO tbf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mi kulu Ierusalem ma magi sar muomuo ni vuor gi kap nga deng kielala e Iesu o, bu nama sibu propet gi ta nga ko ase sibu Rangi Minaes. Ma gi nga tsang vaotie ine bu nama sien gi ta nga tsang vatsakatie e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Misasien gi ta kap nga vorotan ka banga vunan nia masen, gi nga nongie e Pilato va ta nga tor nia kenvamate. ");
INSERT INTO tbf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sien gi tate nga tsang vaotie bu kepineits kokouk malan gi ta nga vataro simi Pakpak Leong surie, gi nga por terie i keim kovuni simi koitskoits ma gi nga vuturungie i aron mi monmon. ");
INSERT INTO tbf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eiekesen e Raban a nga vatoa simi miensei. ");
INSERT INTO tbf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ma sibu ra palan, a nga tsorubeit vasvas segie ese gi ta nga nomeie kovuni i Galili beit i Ierusalem. Arie egie ine, gi me vakokoit vasangan si kegiet kulou. ");
INSERT INTO tbf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Gor vateie nga ngan mi Banga Vinavatei ian e Raban ta nga kubutsie rakot sibu tubugiet. ");
INSERT INTO tbf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","A te me tsang vaotie niagiet, sien tate me vatoa e Iesu simi miensei, malan mi vinavataor ta mon sibu Pak, mi korot leong sien, a luo, “‘Evoi e natung, nevere o me tsorubeit e Tama.’ ");
INSERT INTO tbf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ine mi nama surie va e Raban ta nga vatoa simi miensei ma va ta kap oit nia kopop, a mon simi Pakpak Leong ven ne, “‘O ta terie sevoi bu vavatamaes tuktuk ian o ta nga kukubuits meie ngan e Davit.’ ");
INSERT INTO tbf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Io, mi nama mene i aron mi Pakpak Leong a pevien, “‘E ta kap so tsupuk rivie va ke Ka Tamat va ta oiv nge kopop i aron mi monmon.’ ");
INSERT INTO tbf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Sien e Davit tate nga vaotie ken lalaron e Raban sibu avareit ta nga tino sien, a nga maet ma gi nga puon meie ngan bu tubuon ma mi piripirien a nga oiv nge kopop. ");
INSERT INTO tbf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Eiekesen mi ka ese e Raban ta nga vatoa simi miensei a kap nga oiv. ");
INSERT INTO tbf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Io, bu kasi, o lalaron va nga ta telekiran va surie mi tsinatsangan e Iesu, man vinavatei mi vodon ririv sibu sinavei tsokor gei vateie nge nga. ");
INSERT INTO tbf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mi Vinuor se Moses a kap nga oit nia tsana va nga ta nga tsorubeit duis i matan e Raban, eiekesen e Iesu a tsana ese mune gi ta vodovodon tuktuk sien va gi ta tsorubeit duis. ");
INSERT INTO tbf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Io, nga nenei kalei va misana nama bu propet gi ta nga vokokotie ta kap mang tsorubeit senga. ");
INSERT INTO tbf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Pare! Enga mi kulou oengoeng balapoik, nga ta kudier tsak nge maet, simi vunan o ta tsana ka kepineits si kenga sar ra ian va nga ta kap oit rovrovoriu nia vodovodon tuktuk sien, misasien va ka mei ta palsie senga.’” ");
INSERT INTO tbf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sien e Paulo ma e Barnabas guor tate nga visi rovotsour simi vona rengeir, mi kulou gi nga nongie guor va guor ta nga buer me vakokoit surie ian bu kepineits simi Rangi Minaes ka ian i kur. ");
INSERT INTO tbf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sien mi rengeir tate nga voto, palan bu Iuda ma bu Kibang gi ta nga tuir pats meie bu Iuda nge rangarie e Raban, gi nga vemusurie e Paulo ma e Barnabas. Ma guor nga vakokoit meie gie nge vakotsie va gi ta tino si ken tentoiv e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Io, ian simi Rangi Minaes te, mi kulou kokouk ine simi taon gi nga nemei nia rongomie ken nama mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sien bu Iuda gi ta nga pare mi bineit, gi nga ngungutsuo nge oeng balapoik ngan misa e Paulo ta nga vokokotie. ");
INSERT INTO tbf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Samo e Paulo ma e Barnabas guor nga vakokoit ngeisngeis rakot segie, “Gor ta ngas muna vokokotie ken nama e Raban rakot senga. Eiekesen surie nga kap lalaron ine ma nga si vodon va nga kap kalei oit nia suvuon mi tino rovoriu, io, ine gor te vuris rakot sibu Kibang. ");
INSERT INTO tbf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Simi vunan mi Nguts a te nga terie mi nama ngeisngeis segor ven ne, “O te tsana ngado va engado man berber bu Kibang, terengien va ngado ta mang vavatei ngan mi rosaran mi vavato oit si man votovoto mi kaber.” ");
INSERT INTO tbf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sien bu Kibang gi ta nga rongomie ine, gi nga res nge puongan mi Nguts surie ken nama, ma egie kokouk ese e Raban ta nga vile gie nia suvuon mi tino rovoriu, gi nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ken nama mi Nguts a nga puorkan ian simi enamon kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Eiekesen bu Iuda gi nga oeng ka i aron mi langei asna gi ta nga ko rangarie e Raban ma bu muomuo simi taon. Io, gi nga vakaek nge vikikinie e Paulo ma e Barnabas. Ma gi nga kareir vavasie guor si kegi enamon. ");
INSERT INTO tbf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Io, guor nga titike riv puit siba kameguor veie gie ma guor nga veis rakot i Ikonium. ");
INSERT INTO tbf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma mi kulou vodovodon tuktuk gi nga vous ngan mi nires ma mi Moromoruo Tamat. ");
INSERT INTO tbf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","I Ikonium e Paulo ma e Barnabas guor nga rakot simi vona rengeir sibu Iuda malan guor ta nga ko tsana. Ian en guor nga vavatei ngeisngeis, io, palan beitsak bu Iuda ma bu Kibang gi te nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Eiekesen bu mei mene sibu Iuda gi ta nga ngengeir pupuris simi vodovodon tuktuk, gi nga oengoeng ka i arogie bu Kibang va gi ta mang nga matakorot meie mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Io, e Paulo ma e Barnabas guor nga mon potaram ian en nge vor ve vavavatei ngeisngeis meie ngan mi ngeisngeis kuvu simi Nguts. Mi Nguts a nga vaotie guor nia tsana bu kepineits ni vovokudier, terengien ta mang nga vara tuktuk ngan man nama ken tentoiv. ");
INSERT INTO tbf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mi kulou ian simi taon leong gi te nga vekapot rakot siba gargar, mi gargar mene gi te nga vemusurie bu Iuda ma mi gargar mene gi te nga vemusurie bu aposol. ");
INSERT INTO tbf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bu mei mene sibu Kibang ma bu Iuda, gi nga oir kouk meie magi sar muomuo, ma gi nga roev nia tsang vatsakatie guor ba aposol nge visi tome guor nge vout. ");
INSERT INTO tbf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Eiekesen sien guor ta nga vakierngie ne, guor nga vi rakot simi taon i Lustra ma i Derbe simi provins i Laikonia ma sibu enamon ta mon viririsie. ");
INSERT INTO tbf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ian en, guor nga vor ve vavavatei ngan mi Banga Vinavatei. ");
INSERT INTO tbf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Io, i Lustra, e Paulo ma e Barnabas guor nga pare mi peong ta nga mogos. A nga muru ba kamen vakaek ngas te si ken kienakav ma a kap nga ko oit nia veis. ");
INSERT INTO tbf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A nga mogos nge rongomie ken sar vinakokoit e Paulo. E Paulo a nga pare va a nga suvuon mi vodovodon tuktuk va ta nga oit nia suvuon mi vavato. Io, a nga tomeke mat duis rakot sien. ");
INSERT INTO tbf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ma e Paulo a nga oeng leong, “Tsuok tamtuir ngan ba kame!” Ian ngas te, mi ka a nga rov tamtuir ma a nga tsuok vakaek nge veis. ");
INSERT INTO tbf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Sien mi lobaram gi ta nga pare misa e Paulo ta nga tsana, gi nga koup ngan mi namani Laikonia, “Bu raban gi te peuk ine i keim segiet nge tsorubeit mala ka!” ");
INSERT INTO tbf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","E Barnabas gi nga vuotongie ngan e Tseus. Ma e Paulo gi nga vuotongie ngan e Erme simi vunan bu nama kokouk, eie a nga ko vokokotie. ");
INSERT INTO tbf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ken vona rengeir e Tseus a nga mon i marar simi taon leong. Ken prist e Tseus a nga poro bu bulumakau tamat ma bu purpur gi ta nga tio ma a nga rakot simi matavanuo rumrubukien, simi vunan eie meie mi bineit gi nga lalaro vavadengeir ngan rakot seguor. ");
INSERT INTO tbf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Eiekesen sien ba aposol, e Barnabas ma e Paulo guor ta nga rongomie misa gi ta nga lalaro tsana, guor nga derikie maguor sar kuirkuir nge soer rubukien i kotubuon mi bineit. ");
INSERT INTO tbf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ma guor nga kopuo gie, “Mi kulou, surie misa nga ta tsana ine? Egor buer mo ba ka mala nga. Gor nemei nia vateie nga ngan mi Banga Vinavatei, va nga ta ngas vuris sorvekenan ine bu kepineits sasavoir nge vuris rakot se Raban ta tino. Ine mi Raban eie ese ta nga tsana mi rangit, mi kaber, mi barateis ma bu kepineits gi ta tino i arogie. ");
INSERT INTO tbf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Muomuo, a nga sunurie bu vuna enamon kokouk va gi ta nga vemusurie kegi sar rosar. ");
INSERT INTO tbf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Eiekesen a kap nga muningan eie kesen simi kulou va gi ta kap mang telekiran. A nga kalei nge nga ngan bu banga kepineits nia vara tuktuk ngan va eie a tino. A teir vunie nge nga mi bat kovuni simi rangit ma bu suasuada tsientsuor nia ngou, duis si man sar ra. A vosuvu vunie nga nge nginonginou ma bu aronga a vovosuo ngan mi nires.” ");
INSERT INTO tbf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Misasien guor ta nga vokokotie ine bu nama, guor kap nga oit nia vangenge mi bineit va gi ta kap vavadengeir ngan ka tienebeir rakot seguor. ");
INSERT INTO tbf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Samo bu Iuda ese gi ta nga beit kovuni i Antiok ma i Ikonium, gi nga oeng ka i aron mi bineit ma gi nga tuir meie gie. Gi nga tome e Paulo nge vunavout ma gi nga teie rovotsour ngan i marar simi taon. Gi si nga vodon va e Paulo a te nga maet. ");
INSERT INTO tbf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Eiekesen i muir sien bu mei gi ta nga vodovodon tuktuk gi tate nga me tuir viriviririsie, e Paulo a nga tamtuir nge rubukien muerengei simi taon. Simi ra vemusurie, eguor e Barnabas guor nga rakot i Derbe. ");
INSERT INTO tbf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Guor nga vavatei ngan mi Banga Vinavatei ine simi taon ma guor nga teie kegi vienviendon mi kulou palan va gi ta vodovodon tuktuk se Iesu. Samo guor nga muerengei rakot i Listra, i Ikonium ma i muir i Antiok. ");
INSERT INTO tbf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Guor nga vakokoit vangasie nge vakotsie mi kulou vodovodon tuktuk va gi ta ngas nga tuir ngeisngeis si kegi vodovodon tuktuk. Guor nga pevien, “Giet ta ngas suvuon bu vinekikin palan nia rubukien si ken mangmagoso Nguts e Raban.” ");
INSERT INTO tbf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sibu vona rengeir keskes, guor nga vile kegi sar komosi ka ni tsientsang. Ma ngan mi vorvor meie bu nono, guor nga terie gie si ken nennei mi Nguts ese gi ta nga terie kegi vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","I murien guor tate nga veis ka i aron i Pisidia, guor nga beit i Pampilia. ");
INSERT INTO tbf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ma sien guor tate nga vavatei ngan mi Banga Vinavatei i Pega, guor nga peuk i Attalia. ");
INSERT INTO tbf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kovuni i Attalia, guor nga ka mon nge tsourarak muerengei rakot i Antiok, mi enamon ivie gi ta be nga terie guor en si ken tentoiv e Raban surie mi tsientsang ine guor tate nga me vaton. ");
INSERT INTO tbf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sien guor tate nga beit i Antiok, guor nga kir kakuon mi kulou vodovodon tuktuk, ma guor nga pengan bu kepineits kokouk e Raban ta nga tsana i aron keguor vineis ma vasa ta nga tsitsingie venengan mi rosar va bu Kibang gi ta nga vodovodon tuktuk simi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma guor nga mon potaram meie gie mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bu ka mene gi nga kuvu i Iudea rakot i Antiok gi nga vavasengei sibu mei mene va gi ta nga vodovodon tuktuk se Raban malan ine, “Sien va nga ta kap suvuon mi vinavaroup vemusurie mi vinuor se Moses, nga ta kap oit nia so suvuon mi vavato.” ");
INSERT INTO tbf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ine mi nama a nga teie terie e Paulo ma e Barnabas va guor ta nga vevengeis nge vevetei nge nama meie gie. Io, e Paulo ma e Barnabas gi nga vile guor meie bu ka mene gi ta nga vodovodon tuktuk se Raban va gi ta nga rakot i Ierusalem nia ra pare bu aposol ma bu muomuo surie ine bu nama. ");
INSERT INTO tbf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Io, bu muomuo simi vona rengeir gi nga ture vavasie gie. Ma sien gi ta nga veis ka i aron i Poinike ma i Samaria, gi nga potsukie vasa e Raban a nga vurise venengan kegi tino bu Kibang. Ine mi nama a nga terie mi nires leong simi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Io, sien gi tate nga beit i Ierusalem, bu mei kokouk i aron mi vona rengeir meie bu aposol ma bu muomuo gi nga marangata guor. Guor nga pengan segie mi sana e Raban tate nga tsang vaotie seguor. ");
INSERT INTO tbf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Eiekesen, mi kulou vodovodon tuktuk gi ta nga kovuni simi gargar sibu Parisaio, gi nga tamtuir nge pevien, “Bu Kibang gi ta ngas suvu vinavaroup nge vemusurie mi Vinuor se Moses.” ");
INSERT INTO tbf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bu aposol ma bu muomuo gi nga beit kokouk nia vakvakokoit surie ine mi nama. ");
INSERT INTO tbf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","I murien bu vinavinakokoit palan surie ine, e Petro a nga tsuok tamtuir ma a nga pevien, “Bu kasiung! Nga telekiran va muomuo ngas te, e Raban a nga viel tsana iou i kinorutunga, terengien va bu Kibang gi ta mang rongomie mi Banga Vinavatei simi ngutsuung nge vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","E Raban a telekiran bu arogie mi kulou kokouk, ma a nga vasangan va a suguo gie sien ta nga terie mi Moromoruo Tamat segie malan ta nga tsana segiet. ");
INSERT INTO tbf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","A kap potakie giet mei gie, simi vunan e Raban a nga vara melemelen ngan bu arogie ngan kegi vodovodon tuktuk sien. ");
INSERT INTO tbf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Io, surie misa nga ta lalaro konon e Raban? Nga terie mi putu simi vinavaroup i popon mi kulou vodovodon tuktuk. Ine mi putu bu tamagiet ma egiet buer, egiet kokouk giet kap oit nia sorokie.” ");
INSERT INTO tbf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A kap! Giet vodovodon tuktuk va, ngan ken tentoiv magiet Nguts e Iesu, giet te suvuon mi vavato, malan egie buer gi ta suvuon. ");
INSERT INTO tbf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bu mei kokouk gi ta nga mon ian en, gi nga mon menemenen nge rorong se Barnabas ma e Paulo guor ta nga pengan bu kepineits ni vovokudier e Raban ta nga vaotie guor ngan nia tsana i kotubuon bu Kibang. ");
INSERT INTO tbf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sien guor tate nga vakokoit voto, e Iakobo a nga pevien, “Bu kasi, nga ta rorong seou, ");
INSERT INTO tbf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","e Simon a te palsie segiet vasa e Raban a nga muna vasangan ven ken lalaron sien ta nga viel tsana mi kulou i kotubuon bu Kibang va egie seie.” ");
INSERT INTO tbf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kegi sar nama bu propet a kokouk meie ine, malan gi tate nga vataro. ");
INSERT INTO tbf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘I murien ine, o ta muerengei ma o ta tsang muerngan ken vonuo e Davit ian tate nga kor. Ma ian simi tsiri vonuo, o ta tsang muerngan malan si man matvinavaso vourvour. ");
INSERT INTO tbf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Terengien va mi kulou kokouk gi ta mang nesie mi Nguts, ma buer bu Kibang kokouk gi ta mang suvuon mi asoung.’ ");
INSERT INTO tbf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mi Nguts ese ta nga vasangan ine bu kepineits simi kulou muomuo te a vokokotie ine mi nama. ");
INSERT INTO tbf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kong vienviendon a malan ine. Giet ta kap terie mi tsuotsuobakei sibu Kibang gi ta vor ve vuvuvuris nemei se Raban. ");
INSERT INTO tbf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Eiekesen giet ta ngas vavataor rakot segie va gi ta kap nganie mi tintu gi tate nga vavadengeir ngan rakot sibu raban bitbit, ma gi ta kap tsana mi sinavei tetteririv, ma gi ta kap nganie mi dar ma mi pientsien mi vinavinar gi ta duorkie. ");
INSERT INTO tbf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Simi vunan ine bu vinuor se Moses gi te nga vokokotie potaram te i aron bu taon kokouk ma gi ko munu ase i aron bu vona rengeir sibu Iuda sibu Rangi Minaes kokouk.” ");
INSERT INTO tbf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Samo bu aposol ma bu muomuo meie mi kulou kokouk simi vona rengeir, gi te nga viel tsana ba mei segie nia vemusurie e Paulo ma e Barnabas rakot i Antiok. Gi nga viel tsana e Silas ma e Iudas ese gi ta ko vuotongie ngan va e Barsabas, eguor ba muomuo i kotubuon mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bu muomuo gi nga ture vavasie guor ngan ine mi pakapaka rorou ta nga pevien, “Egei bu aposol ma bu muomuo simi vona rengeir, ma egei bu kasinga. Gei turan kegei ni vuot kalei rakot sibu Kibang ese gi ta vodovodon tuktuk i Antiok, i Suria ma i Kilikia. ");
INSERT INTO tbf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gei nga rongomie va bu mei segei gi siger nga rakot senga nge ra tsola kenga sar vienviendon. ");
INSERT INTO tbf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Io, gei aor kes nia turan kaba ka rakot senga meie e Barnabas ma e Paulo, ");
INSERT INTO tbf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ese guor ta kap ruit ngan keguor tino surie mi asan magiet Nguts e Iesu Karisito. ");
INSERT INTO tbf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gei turan e Iudas ma e Silas nia so vara tuktuk ngan mi ngutsuguor misa gei ta vataro i aron ine mi pakapaka rorou. ");
INSERT INTO tbf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Vemusurie ken lalaron mi Moromoruo Tamat, gei sunuir va gei ta kap terie ka putu mene i poponga, eiekesen arie mo ine ba nama venengeng. ");
INSERT INTO tbf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kian va nga ta nganie bu kepineits gi tate vavadengeir ngan rakot sibu raban bitbit, a, mi dar, ma mi pientsien mi vinavinar gi ta duorkie. Ma kian va nga ta tsana mi sinavei tetteririv. Sien va nga ta kap tsana ine bu tsaka sinavei, kenga mienagos ta kalei. A kalei rovoriu.” ");
INSERT INTO tbf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Io, gi nga turan ba ka peuk i Antiok ivie gituo ta nga ra kuk kakuon en mi kulou sibu vona rengeir kokouk nge terie segie ine mi pakapaka rorou. ");
INSERT INTO tbf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mi kulou gi nga ase ma gi nga res, simi vunan ine mi nama vavakatsep a nga vakotsie gie. ");
INSERT INTO tbf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","E Iudas ma e Silas, eguor ngas te ba propet, guor nga vakotsie nge vangasie mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","I murien ba ra gituo ta nga mon ian en, mi kulou vodovodon tuktuk gi nga tukok tarave gituo va gituo tate nga muerengei rakot segie gi ta nga tura gituo. ");
INSERT INTO tbf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Eiekesen e Silas a nga vodon va ta be buer nga mon meie gie i Antiok. ");
INSERT INTO tbf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Eiekesen e Paulo ma e Barnabas guor ngas nga mon i Antiok, ivie eguor meie bu ka mene gi nga vavasengei en nge vavatei ngan ken nama mi Nguts. ");
INSERT INTO tbf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","I murien ba ra e Paulo a nga oeng se Barnabas, “Giet ta muerengei nge ra iro bu kasigiet sibu enamon ivie giet tate nga vavatei ngan en mi namanien mi Nguts ma giet ta ra pare vasa gi te to ven.” ");
INSERT INTO tbf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","E Barnabas a nga lalaro kerie e Ioanes Marko meie guor, ");
INSERT INTO tbf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","eiekesen e Paulo a nga tsue va guor ta kap nga kerie, simi vunan a te nga sorvekena guor i Pampilia ma a kap nga tsatsang meie guor te simi tsientsang. ");
INSERT INTO tbf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Guor nga vetei nge nama oit guor nga vekapot. E Barnabas a nga kerie e Marko ma guor nga ka mon rakot i Kupro. ");
INSERT INTO tbf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Eiekesen e Paulo a nga vile e Silas ma i murien mi kulou vodovodon tuktuk gi tate nga terie guor si ken tentoiv mi Nguts, guor nga veis. ");
INSERT INTO tbf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Guor nga veis ka i aron i Suria ma i Kilikia nge vangasie gie mi kulou sibu vona rengeir. ");
INSERT INTO tbf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","E Paulo ma e Silas guor te nga veis beit i Derbe ma i Lustra, ivie mi ka vodovodon tuktuk mi asan e Timote ta nga ko mon en. E kina, eie mi vevine Iuda ese ta nga vodovodon tuktuk. Eiekesen e taman, eie mi kangi Grik. ");
INSERT INTO tbf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mi kulou vodovodon tuktuk kovuni i Lustra ma i Ikonium gi nga pengan va e Timote eie mi banga ka. ");
INSERT INTO tbf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","E Paulo a nga lalaron va e Timote va ta nga nomeie, io, a nga varapuo simi vunan e taman e Timote eie mi kangi Grik ma bu Iuda gi ta nga mon ian en gi nga telekiran. ");
INSERT INTO tbf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sien gituo ta nga vesingie bu taon, gituo nga vokokotie ian bu nama bu aposol ma bu muomuo i Ierusalem gi ta nga aor kes ngan va bu mei gi ta vemusurie. ");
INSERT INTO tbf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Io, mi kulou sibu vona rengeir gi nga tsorubeit ngeisngeis simi vodovodon tuktuk ma mi aesaes a nga vor ve leongleong sibu ra kokouk. ");
INSERT INTO tbf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","E Paulo meie ba ka gituo te nga veis rakot simi enamon leong i Prugia ma i Galatia simi vunan mi Moromoruo Tamat a kap nga sunuir va gituo ta nga vavatei ngan mi namanien mi Nguts simi enamon leong i Asia. ");
INSERT INTO tbf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sien gituo tate nga beit simi tieng i Musia, gituo nga konon nia rubukien simi enamon leong i Bitunia, eiekesen mi Morumoruan e Iesu a kap nga sunurie gituo. ");
INSERT INTO tbf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Io, gituo nga veis evisie i Musia nge rakot i Troas. ");
INSERT INTO tbf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ian sikati e Paulo a nga pare mi baidendeng va mi ka kovuni i Makedonia a nga tuir nge no masitinoiv ven ne, “Nemei ine i Makedonia nge me kulie gei.” ");
INSERT INTO tbf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","I muir sien e Paulo tate nga deng vaton mi baidendeng, gei te nga seseing nia rakot i Makedonia, simi vunan gei te nga telekiran va e Raban a nga kukuo gei nia ra vavatei ngan mi Banga Vinavatei simi kulou ian en. ");
INSERT INTO tbf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Samo gei te nga ka mon kovuni i Troas ma gei te nga soer duis rakot i Samotrake, ma simi ra vemusurie gei nga soer rakot i Neapolis. ");
INSERT INTO tbf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kovuni ian en, gei nga soer rakot i Pilippoi, mi taon leong i Makedonia, ivie bu Roma gi ta nga vuor en. Ma gei nga ra mon ian en ba ra. ");
INSERT INTO tbf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Simi Rangi Minaes gei te nga veis rovotsour simi taon nge rakot i gegen mi da ivie va gei ta nga ra vorotan ka korot nia no en. Sien gei tate nga mogos, gei nga vakokoit simi langei ian gi ta nga beit kouk en. ");
INSERT INTO tbf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","I kotubugie ine mi langei mi vevien kovuni i Tuateira a nga mon. Mi asan e Ludia. Ma a nga ko tsatsang verikuil ngan ken sar lavlav dav nge lakep. Ma a nga ko rangarie e Raban. Mi Nguts a nga tsitsingie mi aron nia rong poro mi namanien e Paulo. ");
INSERT INTO tbf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","I muir sien eie ma egie kokouk ian si ken vonuo gi tate nga por sinusuruiv, a nga nongie gei nia rakot si ken vonuo ma a nga pevien, “Sien va nga ta vodovodon tuktuk va o vodovodon tuktuk simi Nguts, nga ta ra nemei si kong vonuo.” Ma a nga tsue te va gei ta nga rakot. ");
INSERT INTO tbf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Simi ra mene sien gei ta nga visi rakot simi korot nia no, gei nga so samsuoeie mi tetsikevien petspets mi tsaka moromoruo ta nga tsegerie ma ta nga ko peteteir. A nga ko por lakep palan ken man sar ka leong ngan ta nga ko vokokotie bu kepineits va ta ba nga beit i muir. ");
INSERT INTO tbf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ine mi tetsikevien a nga vemusurie e Paulo ma a nga vor ve koupkoup surie gei. “Ine ba ka egituo ken ba ka ni tsientsang e Raban ese ta tsiroup. Gituo ko vokokotie senga mi saran mi vavato.” ");
INSERT INTO tbf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ine mi tetsikevien a nga ko tsana ine sibu ra palan, tuir oit e Paulo a te nga maer sien ma a nga vuvuris nge oeng simi tsaka moromoruo, “Simi asan e Iesu Karisito, o oeng ngeisngeis sevoi. Rovotsour sorvekenan!” Ian ngas te mi tsaka moromoruo a nga rovotsour sorvekenan. ");
INSERT INTO tbf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sien man sar ka leong ian mi tetsikevien petspets gi tate nga telekiran va kegi rosar nia por lakep a te nga tsokor, gi nga rakopie e Paulo ma e Silas nge teie guor rakot sibu muomuo simi taon simi korot nia beit kouk. ");
INSERT INTO tbf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ma gi nga voturie guor i matan bu muomuo sibu ka ni vuor nama nge pevien, “Ine ba ka eguor ba kangi Iuda, ma guor me vakake bu tsienakor i aron kegiet taon. ");
INSERT INTO tbf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Guor vasangan simi kulou bu suada sinavei ivie ta kap duis va egei mi kulu Roma gei ta vemusurie o, pupua.” ");
INSERT INTO tbf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mi bineit buer gi nga tuir kouk meie gie nge suereren e Paulo ma e Silas, ma bu muomuo sibu ka ni vuor nama gi nga tuturei va gi ta nga deir rivie maguor sar tsetstseik nge tsatsakie guor. ");
INSERT INTO tbf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","I murien gi tate nga tsatsakie vatsakatie guor te, gi nga tomeka guor i aron mi vona vinatoreis ma gi nga terie mi nama ngeisngeis simi ka nennei simi vona vinatoreis va ta nga naneie vititirie guor. ");
INSERT INTO tbf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Sien ta nga rongomie ine mi nama ngeisngeis, a nga terie guor simi roruom i kutum te simi vona vinatoreis ma a nga pipits pataman bu kameguor siba mat i kotubuon ba poko ei luo. ");
INSERT INTO tbf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Malan va sikati potaram, e Paulo ma e Silas guor nga vor ve nono nge kavakavarie bu pak rakot se Raban, ma bu ka tsatsang vinatoreis ka ie gi nga rongomie guor. ");
INSERT INTO tbf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Puk lalapus, mi oen leong a nga beit nge vedederie mi mendien mi vona vinatoreis. Ian ngas te bu matavanuo kokouk simi vona vinatoreis gi nga katsep ma bu tsen gi ta nga rorotsie ngan mi kulou tsatsang vinatoreis gi nga koro kor. ");
INSERT INTO tbf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mi ka nennei simi vona vinatoreis a nga pan, ma sien ta nga pare bu matavanuo kokouk gi tate nga katsep, a nga tiki tsana ken kuor ma a nga visi kenvamate eie kesen, simi vunan a nga vodon va mi kulou tsatsang vinatoreis kokouk gi te nga vi. ");
INSERT INTO tbf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Eiekesen e Paulo a nga kopuo, “Kian va e ta kenvamate no kese! Egei kokouk ine gei mon!” ");
INSERT INTO tbf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mi ka nennei simi vona vinatoreis a nga tuturei surie ka berber ma a nga bubu rubukien. Samo a nga dedeir kor i matan e Paulo ma e Silas. ");
INSERT INTO tbf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ma a nga kir vorotsoruo guor nge virei, “Ba ka leong, misa o ta ngas tsana nia suvuon mi vavato?” ");
INSERT INTO tbf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Guor nga kuil nama, “Vodovodon tuktuk simi Nguts e Iesu, ma e Raban ta vatoa no, evoi ma ke tietie kokouk.” ");
INSERT INTO tbf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Samo guor nga vateie ngan ken nama mi Nguts ma egie kokouk gi ta nga mon si ken vonuo. ");
INSERT INTO tbf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ian ngas te sikati, ine mi ka nennei simi vona vinatoreis a nga kerie guor ma a nga vuie keguor sar kiem. Ma ian ngas buer te, eie ma ken tietie gi nga por sinusuruiv. ");
INSERT INTO tbf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mi ka nennei simi vona vinatoreis a nga kir rubukien nge guor si ken vonuo ma a nga tabarie guor. Eie ma ken tietie kokouk gi nga vous ngan mi nires, simi vunan gi te nga vodovodon tuktuk se Raban. ");
INSERT INTO tbf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sien tate nga vo ra, bu muomuo sibu ka ni vuor nama sibu Roma gi nga turan bu girigirir rakot simi ka nennei simi vona vinatoreis ngan ine mi nama, “Ruom rivie ian ba ka.” ");
INSERT INTO tbf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mi ka nennei simi vona vinatoreis a nga pengan se Paulo, “Bu muomuo sibu ka ni vuor nama sibu Roma gi te tuturei va o tate ruom rivie ngado. Io, ine ngado tate veis. Ngado veis ngan mi molu.” ");
INSERT INTO tbf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Eiekesen e Paulo a nga oeng ine sibu girigirir, “Gi kap nga vuor nama eiekesen gi siger nga tsatsakie gor i matan bu mei kokouk. Misasien egor ba kangi Roma, gi siger nga tomeke vurukude gor mo i aron mi vona vinatoreis. Ma ine gi lalaro ture menentagor? A kap! Egie ngas te gi ta ngas nemei nge me nomeie gor rovotsour.” ");
INSERT INTO tbf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bu girigirir gi nga muerengei rakot nge ra pengan ine bu nama sibu muomuo sibu ka ni vuor nama, ma sien gi ta nga rongomie va e Paulo ma e Silas ba kangi Roma, gi nga kudier nge motou. ");
INSERT INTO tbf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Io, gi nga rakot nge ra oeng vakalaie guor, ma gi nga kir vorotsoruo guor simi vona vinatoreis nge no masitinoiv seguor va guor tate nga sorvekenan mi taon. ");
INSERT INTO tbf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","I murien guor tate nga rovotsour simi vona vinatoreis, guor nga rakot si ken vonuo e Ludia. Ian en guor nga vorotan mi kulou vodovodon tuktuk ma guor nga vakotsie gie. Samo guor nga sorvekena gie. ");
INSERT INTO tbf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Io, sien gituo tate nga veis ka i aron i Ampipolis ma i Apolonia, gituo nga beit i Tesalonika ivie mi vona rengeir sibu Iuda a nga mon en. ");
INSERT INTO tbf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Malan mi sinavien e Paulo ta nga ko tsana, eie a nga rakot simi vona rengeir ma i aron ba Rangi Minaes tour a nga vevengeis surie bu nama simi Pakpak Leong meie gie, ");
INSERT INTO tbf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nge palsie nge vara tuktuk ngan va mi Messia ta ngas nga suvu vinekikin nge to muerengei simi miensei. E Paulo a nga pevien, “Ine e Iesu o ta vateie nge nga ngan, eie mi Messia.” ");
INSERT INTO tbf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ma bu mei mene segie gi nga vurisan kegi sar vodovodon surie mi sana e Paulo meie e Silas guor ta nga vokokotie, ma gi nga tuir kokouk meie guor, ma buer palan bu Grik gi ta nga ko rangarie e Raban ma palan bu vevien aiminangarei buer. ");
INSERT INTO tbf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Eiekesen bu Iuda gi nga ngungutsuo guor. Io, gi nga kir kakuon mi kulou veisveis sasavoir simi korot nia verikuil, nge tsuok voturie mi gargar nia tsana mi sinavei tsokor ma gi nga tsuok vakake mi tseng simi taon. Gi nga lalapus rakot si ken vonuo e Iason nge nesie e Paulo ma e Silas va gi ta nga kir vorotsoruo guor simi bineit. ");
INSERT INTO tbf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Eiekesen, sien gi ta kap nga vorota guor, gi nga teie vorotsoruo e Iason meie mi kulou vodovodon tuktuk mene i matan bu muomuo simi taon leong nge koupkoup ven ne, “Ine mi kulou gi te tsana mi tsienakor simi mangmagoso enaenamon kokouk. Ma gi te beit ine buer. ");
INSERT INTO tbf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma e Iason a nga kerie gie rakot si ken vonuo. Egie kokouk gi kap lalaro vemusurie ken vinuor e Kaesar nge vor ve vokovokokotie va mi kovakova ka leong mene mi asan e Iesu.” ");
INSERT INTO tbf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sien gi ta nga rongomie ine, mi bineit ma bu muomuo simi taon leong gi nga basbaslieng. ");
INSERT INTO tbf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bu muomuo gi nga tsana e Iason ma bu mei mene va gi ta nga vorie mi vinuor, ma gi nga ruom rivie gie. ");
INSERT INTO tbf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sien tate nga kati, mi kulou vodovodon tuktuk gi nga turan e Paulo ma e Silas rakot i Berea. Sien guor ta nga beit ian en, guor nga so rubukien simi vona rengeir sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Io, mi kulu Berea egie mi banga kulou, ma mi sinavigie a nga kalei rio mi kulu Tesalonika. Gi nga rong poro mi nama ma gi ngas nga masoron. Ma sibu ra kokouk gi nga ko tiorbeten mi Pakpak Leong nia telekiran ken nama e Paulo va a tuktuk o, a kap. ");
INSERT INTO tbf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Palan bu Iuda, meie palan bu vevien ma bu ka aiminangarei sibu Grik gi nga vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sien bu Iuda i Tesalonika gi ta nga vakierngie va e Paulo a nga vavatei ngan mi namanien e Raban i Berea, gi nga rakot buer en, ma gi nga vara tsogolivo ngan mi bineit nge tsuok voturie mi tseng. ");
INSERT INTO tbf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mi kulou vodovodon tuktuk ian en gi nga ture volopusuo e Paulo peuk i koen. Eiekesen e Silas meie e Timote guor nga mon i Berea. ");
INSERT INTO tbf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mi kulou gi nga veis naneie e Paulo beit i Aten. Ma gi nga muerengei sorvekenan ngan ken nama vavakatsep rakot se Silas meie e Timote va guor ta ngas nga nemei lalapus nge vorotan. ");
INSERT INTO tbf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","E Paulo a nga rosie e Silas meie e Timote i Aten, ma a nga pare mi taon a nga suvuon bu patspats sibu raban bitbit. Ine a nga puputungie mi aron e Paulo. ");
INSERT INTO tbf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Io, i aron kegi vona rengeir bu Iuda, a nga vetei nge nama meie bu Iuda ma bu Kibang ese gi tate nga ko rangarie e Raban. Ma sibu ra, a nga vakvakokoit meie mi kulou ese gi ta nga mon i aron mi korot nia verikuil. ");
INSERT INTO tbf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mi gargar simi kulou sievei sibu Epikurea ma bu Stoik gi nga nama vevengeis meie e Paulo. Bu pout mene gi nga vevirei, “Mi sana ine mi be a lalaro vokokotie?” Bu pout mene gi nga kuil nama, “A mat malan va eie a patara magi sar raban bu kibang.” Gi nga oeng malan ine simi vunan e Paulo a nga vavatei ngan man Banga Vinavatei e Iesu ma mi tino mumuerengei simi miensei. ");
INSERT INTO tbf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Gi nga kir terie e Paulo i matan bu Areopagus, ma gi nga vosuoreie, “Pengan segei mi sana vinasengei vour ian e ta vasangan. ");
INSERT INTO tbf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Evoi e me terie bu vienviendon kekineits si kegei bairorrong ma gei lalaro telekiran vasa gi vunan ven.” ");
INSERT INTO tbf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mi kulu Aten meie bu kibang ese gi ta nga me mon ian, gi kap nga tsana ka kepineits mene eiekesen gi nga ko vokokotie nge rongomie bu vienviendon vour ta nga beit. ");
INSERT INTO tbf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Samo e Paulo a nga tsiktamtuir i kotubugie bu Areopagus ma a nga pevien, “Mi kulou kuvu i Aten! Si kenga tino kokouk, o dengkelala sibu binangavinga va enga mi kulou ni rengeir. ");
INSERT INTO tbf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Sien o ta veis veriris ma deng vititirie kenga sar kepineits nia rengeir, o deng vorotan buer mi korot nia tu tienebeir meie ngan mi vinavataor i popon malan ine, ‘Rakot simi Raban gei kap telekiran.’ Nga ko rengeir rakot simi sa nga kap telekiran. Ma ine o ta vateie nga ngan. ");
INSERT INTO tbf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“E Raban ese ta nga tsana mi mangmagoso enaenamon ma bu kepineits i aron, eie mi Nguts die i kur simi rangit ma simi kaber ma a kap mon sibu vona rengeir mi kulou gi ta ko tsana ngan bu rimagie. ");
INSERT INTO tbf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma a kap pinat surie kegiet kuilkuil simi vunan a kap pinat surie ka kepineits. Eie mo kesen a terie simi kulou mi tino ma mi mour ma bu kepineits kokouk buer. ");
INSERT INTO tbf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Simi ka kes mo e Raban a nga vabatie bu matabu kokouk, va gi ta tino simi kaber kokouk. Ma a nga totok telekiran bu poko keipkepide ra segie ma kegi enamon ivie va gi ta mon en. ");
INSERT INTO tbf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","E Raban a nga tsana ine, terengien va mi kulou gi ta nesie nge nemei vatavatat nge vorotan. E Raban a kap mon i pek sorvekena giet keskes. ");
INSERT INTO tbf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Simi vunan seie mo giet suvu tino nge veisveis ma giet mon kalei, malan kenga ba ka putput pak guor ta nga pevien, ‘Egiet bu natuon buer.’ ");
INSERT INTO tbf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Io, giet te tsorubeit bu natuon e Raban. Giet ta kap vodon va e Raban a malan mi patspats gi ta tsana ngan mi gold, mi silva o, mi vunavout vemusurie kegi sar sinavei nia toik. ");
INSERT INTO tbf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Muomuo, e Raban a kap nga vakvakokoit palan segie mi kulou gi ta nga vodon sasavoir. Eiekesen nevere a vakokoit ngeisngeis simi kulou simi mangmagoso enaenamon kokouk, va gi ta ngas vodon vuris. ");
INSERT INTO tbf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","E Raban a te nga totoka mi ra sien va eie ese tate nga viel tsana va ta vuortie mi kaber ngan ken sinavei duis. E Raban a te nga vara tuktuk ngan ine simi kulou sien ta nga vatoa simi miensei.” ");
INSERT INTO tbf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sien gi ta nga rongomie e Paulo ta nga vakokoit surie mi tino mumuerengei simi miensei, bu mei mene segie gi nga vavangiets ngan e Paulo, eiekesen bu mei mene gi nga pevien “Gei lalaro rongomie va e ta vokokotie ian bu nama te buer.” ");
INSERT INTO tbf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ma samo e Paulo a nga sorvekena gie bu Areopagus. ");
INSERT INTO tbf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Eiekesen ba mei segie gi nga tsorubeit mi kulou vodovodon tuktuk. I kotubugie, e Dionisio, mi meinmenien bu Areopagus, ma buer mi vevien mi asan e Damaris ma ba mei mene. ");
INSERT INTO tbf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","I murien ine, e Paulo a nga sorvekenan i Aten ma a nga veis rakot i Korinto. ");
INSERT INTO tbf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ian en, a nga vorotan mi kangi Iuda mi asan e Akuila ese gi ta nga kava i Pontus. Eie a nangba nga beit kovuni i Italia meie ken vevien e Priskila, simi vunan e Klaudio a nga oeng ngeisngeis sibu Iuda nia sorvekenan i Roma. E Paulo a nga ra iro guor, ");
INSERT INTO tbf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ma a nga mon nge tsatsang meie guor simi vunan e Akuila eie buer mi ka tsangtsang sel nia por lakep malan mo e Paulo. ");
INSERT INTO tbf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sibu Rangi Minaes, e Paulo a nga ko vakvakokoit vakatsepa gie i aron kegi sar vona rengeir ma a nga konon nia vakokoit kerie kegi sar vienviendon bu Iuda ma bu Grik. ");
INSERT INTO tbf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sien e Silas ma e Timote guor tate nga beit kovuni i Makedonia, e Paulo a nga teir putan ken tino nia vavatei ngan mi namanien e Raban nge vakokoit vasangan sibu Iuda va e Iesu eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Eiekesen gi nga vakaek nge suereren ken sar nama e Paulo nge oeng vatsakatie. Ma a nga tsopure riv puit si ken lavlav ma a nga oeng segie, “Kenga miensei a kap vunan seou! Enga kesenga nga vunan! Vakaek ine ma i muir o ta rakot sibu Kibang.” ");
INSERT INTO tbf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Io, a nga sorvekenan mi vona rengeir ma a nga ra rubukien si ken vonuo e Tito Iusto ese a nga ko rangarie e Raban. Ken vonuo a nga mon i babaren mi vona rengeir sibu Iuda. ");
INSERT INTO tbf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mi muomuo simi vona rengeir sibu Iuda mi asan e Krispo, eie meie egie kokouk si ken vonuo gi nga vodovodon tuktuk simi Nguts. Ma mi kulou palan kovuni i Korinto gi ta nga rongomie mi namanien e Paulo, gi nga vodovodon tuktuk nge por sinusuruiv. ");
INSERT INTO tbf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Simi kati mene, mi Nguts a nga oeng se Paulo i aron mi baidendeng ven ne, “Kian va e ta motou. Kian va e ta maer nia vavatei ma kian va e ta bong, ");
INSERT INTO tbf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","simi vunan o mon meie no. A kap ka mei ta oit nia tsang vatsakatie no, simi vunan palan mi kulou i aron ine mi taon egie kong kulou.” ");
INSERT INTO tbf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Io, e Paulo a nga mon ian en mi avareit kes ma mi kapien, ma a nga vavasengei simi kulou ngan mi namanien e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Sien e Galio ta nga tsorubeit mi gavana i Akaia, bu Iuda gi nga beit kouk. Ma gi nga rakopie e Paulo nge kerie rubukien ngan simi korot nia vuor nama. ");
INSERT INTO tbf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Gi nga pevien, “Ine mi ka, a ko tsue va mi kulou gi ta rangarie e Raban simi rosar ian ta kap duis simi vinuor.” ");
INSERT INTO tbf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","E Paulo a te nga visi vakokoit eiekesen e Galio a nga pevien sibu Iuda, “Sien va ine bu nama a vemusurie ka tsaka sinavei o, ka tsienakor leong beitsak, a duis va o ta rorong senga. ");
INSERT INTO tbf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Eiekesen nga nama palan ngan bu nama ma bu as ma kenga sar vinuor. Enga kesenga nga ta vodusie. O ta kap vodusie ian bu kepineits.” ");
INSERT INTO tbf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ma a nga ture vorotsoruo gie simi korot nia vuor nama. ");
INSERT INTO tbf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Samo, gi nga rakopie e Sostenes, mi muomuo simi vona rengeir sibu Iuda, ma gi nga tsatsakie i matan mi korot nia vuor nama. Eiekesen e Galio a nga vodon sasavoir ngan mo. ");
INSERT INTO tbf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","E Paulo a nga mon bu ra palan i Korinto. Samo a nga sorvekena gie mi kulou vodovodon tuktuk ma a nga ka mon meie e Priskila ma e Akuila rakot i Suria. I muan ken vineis, e Paulo a nga varake mi kovan i Kenkrea simi vunan eie a nga vemusurie ken vakavakariem meie e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Gi nga beit i Epeso ma e Paulo a nga sorvekenan en e Priskila meie e Akuila. Samo, eie kesen mo a nga rubukien simi vona rengeir sibu Iuda ma a nga vevuor nge nama meie bu Iuda. ");
INSERT INTO tbf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mi kulou gi nga oeng rutie e Paulo va ta be nga mon meie gie, eiekesen a kap nga sunuir. ");
INSERT INTO tbf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ma a nga oeng segie sien ta nga sorvekena gie, “Sien va e Raban ta sunuir, o ta muerengei vorota nga.” Ma a nga ka mon nge sorvekenan i Epeso. ");
INSERT INTO tbf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sien e Paulo tate nga beit i Kaesarea, a nga veis rakot i Ierusalem ma a nga ra irogie mi kulou simi vona rengeir, ma a nga peuk i Antiok. ");
INSERT INTO tbf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ma i murien mi minon potaram a nga sorvekenan i Antiok. Ma a nga vesingie bu korot kokouk simi enamon leong i Galatia ma i Prugia nge vangasie mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ian sibu ra mi kangi Iuda mi asan e Apolo, ese gi ta nga kava simi enamon i Aleksandria, a nga nemei i Epeso. Eie mi ka sievei ma a nga telekire vititirie mi nama simi Pakpak Leong. ");
INSERT INTO tbf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Gi te nga vavasengei sien simi saran mi Nguts. Ma ken lalaron nia vavatei a nga leong beitsak ma ken sar namani vinasengei rakot simi kulou surie e Iesu a nga duis rovoriu. Eiekesen a nga telekiran mo mi sinusuruiv se Ioanes. ");
INSERT INTO tbf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ma a nga vakaek nge vakokoit ngan mi aor ngeisngeis segie i aron mi vona rengeir sibu Iuda. Sien e Priskila ma e Akuila guor ta nga rongomie, guor nga kerie rakot si keguor vonuo ma guor nga palsie vititirie sien mi saran e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Sien e Apolo tate nga lalaro veis rakot i Akaia, mi kulou vodovodon tuktuk gi nga vakotsie nge vavataor rakot simi kulou vodovodon tuktuk ian en nia so marangatan. Sien tate nga so beit, a nga terie mi kuilkuil leong segie gi ta nga vodovodon tuktuk se Raban surie ken tentoiv. ");
INSERT INTO tbf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","A nga ko munu tseiptseiprio bu Iuda sibu namani vevengeis i matan bu mei palan sien ta nga vara tuktuk ngan i aron bu nama simi Pakpak Leong va e Iesu eie mi Messia. ");
INSERT INTO tbf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sien e Apolo ta ngas nga mon i Korinto, e Paulo a nga veis ka i aron bu enamon nge beit i Epeso. Ian en a nga vorotan mi kulou vodovodon tuktuk. ");
INSERT INTO tbf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ma a nga vereie gie, “Nga te nga suvuon buer mi Moromoruo Tamat sien nga ta nga tsorubeit mi kulou vodovodon tuktuk?” Gi nga kuil nama, “A kap, gei kap ngas nga rongomie va ka Moromoruo Tamat buer ine a mon.” ");
INSERT INTO tbf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ma e Paulo a nga virei, “Mi sana suada sinusuruiv nga te nga suvuon?” Gi nga kuil nama, “Mi sinusuruiv se Ioanes.” ");
INSERT INTO tbf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","E Paulo a nga pevien, “Mi sinusuruiv se Ioanes eie mi sinusuruiv nia vodon vuris. Ma e Ioanes a nga oeng simi kulou va gi ta ngas nga vodovodon tuktuk se Iesu ese ta ba nga vemuir sien.” ");
INSERT INTO tbf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sien gi ta nga rongomie ine, gi nga por sinusuruiv simi asan mi Nguts e Iesu. ");
INSERT INTO tbf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ma sien e Paulo ta nga teir riem i popogie, mi Moromoruo Tamat a nga tsegerie gie ma gi nga vakokoit ngan bu namanien bu vuna enamon mene nge vakokoit ngan mi sana nama e Raban ta nga terie segie. ");
INSERT INTO tbf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Egie kokouk ine a nga oit mi sinangavur kes ma luo mi kulou. ");
INSERT INTO tbf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","I aron ba vura tour, e Paulo a nga ko rubukien i aron mi vona rengeir sibu Iuda nge vavatei ngan mi aor ngeisngeis ma a nga ko vetei nge nama ngeisngeis nia kerie kegi vodovodon surie mi mangmagoso Nguts e Raban. ");
INSERT INTO tbf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Eiekesen bu mei mene segie bu arogie a nga bakiet. Ma gi nga ngengeir pupuris nia vodovodon tuktuk. Ma gi nga oeng vatsakatie ine mi Saran mi Nguts i matan mi bineit. Io, e Paulo a nga sorvekena gie. Ma a nga kerie mi kulou vodovodon tuktuk meie, ma sibu ra a nga vakvakokoit meie gie i aron mi vona vavasengei gi vuotongie va mi Turanno. ");
INSERT INTO tbf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Io, a nga mon malan siba avareit luo, ma egie kokouk bu Iuda ma bu Grik gi ta nga monongie mi enamon leong i Asia, gi nga rongomie mi namanien mi Ngut