﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbc_vpl;
CREATE TABLE tbc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbc_vpl WRITE;
INSERT INTO tbc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yaŋak e irig ipalu den iŋ Jesus Kristus san tubun bagen a. Jesus iŋ Dawid lo ilasa ya, agod Dawid man iŋ Abraham lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","5","Abraham log ipalug Kiŋ Dawid lo man, tubun bagen san yaŋak igo iri a: Abraham, Aisak, Jakob, Juda iŋ tein muroun dida. Aria, Juda man Peres iŋ Serah da tamadi, agod uraru an tinadi Tamar. Aria, Peres, Hesron, Ram, Aminadab, Nason, Salmon, Boas (Boas tinan Rahab), Obed (iŋanen tinan Rut), agod Jesi. Aria, Jesi man Kiŋ Dawid taman. ");
INSERT INTO tbc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","11","Dawid log ipalug saen Babilon san kiŋ yu yabisag Jerusalem daoŋ ipani dugo, Juda adi ikudai go Babilon na subanek tamolpein igo woŋ diau go ante dumado na yan san saen lo man, tubun bagen sad yaŋak igo iri a: Dawid, Solomon (iŋ tinan man, pein nek a imug Uraya iŋane ya), Rehoboam, Abijah, Asa, Jehosafat, Jehoram, Usia, Jotam, Ahas, Hesekaya, Manasei, Amon, Josaya, agod Jehoyakin iŋ tein muroun dida. ");
INSERT INTO tbc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Aria, Juda adi Babilon na dumado yan san saen ibiseig ipalug, Jesus ilasa yan san saen lo man, tubun bagen sad yaŋak igo iri a: Jehoyakin, Sealtiel, Serubabel, Abiud, Eliakim, Asor, Sadok, Akim, Eliud, Eliasar, Matan, Jakob, agod Josef nek a Maria iŋane ama ya. Maria nek a Jesus igansi a, iŋ tamol nek a Kristus tabol dama ya. ");
INSERT INTO tbc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aria, Abraham log ipalug Dawid ilasa yan tubun 14 lo dar igile ya. Anteg, Dawid log ipalug Juda adi Babilon na dumado yan san saen lo, tubun 14 taida lo dar igile ya. Aria, anteg tubun 14 taida lo dar igile gug Kristus ilasag malan ipuk a. ");
INSERT INTO tbc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aria, Jesus Kristus dugo ilasa amaiak san dal man igo ya. Maria tinan taman iŋ Josef iŋane san ŋien dupani, ago yak man Josef pein an da gamugo dien dugo, Awan Urgun san dabai iganeg Maria luan anda yan tamolpein fidian dile duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Agog iŋ iwon Josef man tamol itaot ago yan lo iŋ pein an malak malak miai ipani man imoi, agog pasak nam pein an ibiseip isol yau o ilo sou ago igane ya. ");
INSERT INTO tbc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Saen iŋsan ilo sou ago igane man, yen dugo Tubun ak san eŋel ŋioŋamin lo san na ilasag irupeig ibol, “Josef, Dawid nanun, Maria oŋ iwo yak ŋiŋen o ilo ta gidigidad na wa, fun dugo, nanuk Maria tiŋaen lo man Awan Urgun san dabai lo ilasa la ya. ");
INSERT INTO tbc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iŋ nanuk tamol ak igansi wa, ago dop oŋ yaŋan Jesus ubol a, fun dugo, iŋ iŋsan tamolpein iŋaned aupasek san ai wadan an lo patud ipasi wa.” ");
INSERT INTO tbc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mel an fidian dilasa yan san fun man igo ya, wagam Anut ru fulalek profet ta awan lo ibol ilasa yan gamu nuŋon fo tusuda ya. ");
INSERT INTO tbc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Iŋ ibol, “Pein baras ta kitek tamol ta da dutor man tia yak, tiŋaen lo nanuk tamol ak ta ilasa wa. Ago dop yaŋan Imanuel dubol a.” (Yaŋak Imanuel fun man igo: “Anut id da tumado da.”) ");
INSERT INTO tbc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Agog saen Josef ŋioŋ lo imasa man Tubun ak san eŋel awan irig, Maria iwon oŋ iŋaneg san panu na diaug iwon oŋ ida dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ak man saen iŋaneg yau man kitek iwon oŋ ida dien man tia ya, agog yaug pein an nanuk tamol luan lo yan igansi a. Agog Josef nanuk an yaŋan Jesus ibol a. ");
INSERT INTO tbc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus Betlehem na ilasa, Betlehem man tan tubun Judea na yen da. Saen an lo Herod iŋ kiŋ imado se ya. Saen Jesus ilasa man maŋau tamol adi ad ilasa dak lo yak Jerusalem na dupalug gidigidad dusumiaeŋ se ya, ");
INSERT INTO tbc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nanuk a ilasa amaiak dugo mi ak i? Iŋ murnap Juda adi sad kiŋ imado wa. Ilasa yan maŋ maloŋ a, man dugo, iŋsan patui ad ilasa dak ate fun iganeg ided do mile ya, an lo maŋ ubou an mile wo mupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Saen kiŋ Herod iŋsad ŋiŋeŋ ago iloŋ man ilo sou ifini saian, ago dugo tamolpein Jerusalem na dam sisem ilo sou gidigidad diŋane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Agog Herod pris gurman adi, agod kubiaeŋ san girek maŋau adi dida itumanai go isumianaig ibol, “Aben dugo amaiak lo Kristus ilasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ago dugo dubol, “Iŋ aben Betlehem o Judea na amaiak ate ilasa wa. Man dugo, wagam ru fulalek san profet ta igireg ibol, ");
INSERT INTO tbc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betlehem, tan Judea na, oŋ Judea san gugoi gurman luluŋad lo panu kawan ak oŋ tia ya. Man dugo, mitep oŋ lo gurman ta ilasa wa. Gurman an ŋaisag tamolpein Isrel itirnai a.’” ");
INSERT INTO tbc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Murnag Herod pasak nam maŋau tamol adi igiaig dupalug isumianai, “Saen dugon lo patui fun iganeg ided ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Agog Betlehem na idinaig diau o dugo ago ibol, “Aup nanuk an niŋen o abaŋ ale wo uyanan a. Saen ale dop ru aŋanep apalup, abol ŋaloŋ dop, ŋai dam ŋaup ubou an ŋile wa.” ");
INSERT INTO tbc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Saen kiŋ san ŋiŋeŋ duloŋ go itout man fun diganeg Betlehem na diau a. Ago dugo patui a ad ilasa dak lo dile yan, afon ilasa dag dile ya. Saen patui an dile man ilod uyanan geig go uyad isusa ya. Agog patui an imug naod na yaug, nanuk ab a lo yen dak ate gug, ab fufo ago ided dugo yen se ya. ");
INSERT INTO tbc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Agog ab an ate dilasag diladug, nanuk tinan Maria da dumado dugo diliai man, ditakoksig ubou an dile ya. Ago gug melmel naod lak na lak na disini an, awad dupasi idug lou dupani a. Mel naon ibol gol, agod ubou san marasin ta yaŋan frankensens dubol dan, agod marasin ta yaŋan mirr dubol damaiak dupani a. ");
INSERT INTO tbc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Agog dumul man Herod san na ta diau na ya, man dugo, insad ŋioŋ lo Herod san na ta diau na wo Anut geg ipidinai a. Ago yan lo dal senamo diŋaneg sed naod na dumul diau a. ");
INSERT INTO tbc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aria, saen dumul man Tubun ak san eŋel ŋioŋamin lo Josef san na ilasag irupei, “Masa kisaek oŋ pe nanuk tinan da uŋal pe tan Egipta na ante asol pe au a. Aup ante amado dop saen isudap ŋai amul o ŋabol dop amul. Man dugo, Herod nek nanuk an daoŋ ipani wo abaŋ ile da.” ");
INSERT INTO tbc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Agog Josef imasa kisaek oŋ go nanuk tinan da tidom lo iŋal go, ab dibiseig fun diganeg Egipta na diau a. ");
INSERT INTO tbc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Diaug Egipta na dumado yau dugo Herod imat. Ago gug Egipta dibiseig Judea na dumul diau a. Ŋiŋeŋ nek e ru fulalek san profet wagam ibol ago mi nuŋon ilasa ya. Tubun en ibol, “Egipta ilon lo ŋaineg nanug ŋuwagiŋ go tan en ibiseig ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Saen Herod maŋau tamol dirawi ago iloŋ man, tiŋaen imumari geig a. Agog wagai tamol idinaig Betlehem na fidian mi lubanek diaup ante nanuk tamol anaŋar urarug isuda agog anaŋar urarug idu yan fidian dufu dumat o diau a. Man dugo, imug Herod maŋau tamol an isumianaig ibol, “Nal dugon lo patui an fun iganeg ided se yak i?” Ago dugo iŋ ru naon durupeig dubol, “Anaŋar uraru yau la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dal an lo uloŋ tamol yaŋan Jeremaia wagam ŋiŋeŋ a ibol ilasa yan nuŋon ilasa ya. Iŋ ibol, ");
INSERT INTO tbc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kilagun ta panu Ramah lo duloŋ a, tinaŋ igane dugo tubun mi isasai se ya. An man Rasel nanun muroun niŋedi wo tinaŋ yabi se ya. Ilon diŋane gug imoi, man dugo, iŋanen nanun muroun fidian dumat pasik a.” ");
INSERT INTO tbc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aria saen Herod imat man, Tubun ak san eŋel Egipta na yaug ŋioŋamin lo Josef san na ilasag irupeig ibol, ");
INSERT INTO tbc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Masap nanuk tinan da uŋal pe tan Isrel na ante au a. Man dugo, tamol iŋ dufuni imat o digane yan man gubak mi dumat la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Agog Josef imasag nanuk tinan da iŋal go tan Isrel na atna diau a. ");
INSERT INTO tbc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Saen dumul diau man, Akilaus taman Herod aben iŋaneg kiŋ imado se yan Josef ago iloŋ a. An niŋen o Josef irer an lo provins Judea ante imado wo man imoi a. Agog afon ŋion lo Anut ru kagin ipanig Jerusalem na ta yau na wo ibol a. Ago tag Jerusalem iriŋanig Galili na yau a. ");
INSERT INTO tbc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Agog yaug aben ta Nasaret dubol dak lo imado se ya. Ante afon ru ta wagam Anut san uloŋ tamol adi dubol an nuŋon ilasa da ya. Ŋiŋeŋ an igo ibol, “Tamolpein iŋ tamol an niŋen o Nasaret tamol dubol a.” ");
INSERT INTO tbc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saen malak malak lo Jesus gamugo ilasa man, Jon suguek tamol dubol dan ipalug, Judea na tan kawan ak lo ru ifulale se ya. ");
INSERT INTO tbc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Iŋ ru kuai te iganeg ibol, “Aŋ ilom ibileksa wa, man dugo, Anut san kagin panek an sumeik ipanad la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Profet Aisaia tamol an niŋen o wagam mi igo ibol a, “Tamol ta san kilagun tan kawan ak lo iwagiŋ go ibol, Tubun en iŋanen dal akubunep itaot yen a.” ");
INSERT INTO tbc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aria, Jon san biouŋ tinin fo idiri man kamel san fufulun nam igane ya. Agod san let luan na man makau san suŋulon nam igane, agod san anaŋ man sis tutubun agod nini sad dubei bulbal bulbal dineg ilasa damaiak mi ile dop yani da. ");
INSERT INTO tbc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Saen iŋsan urat fun iganep ru ifulale se man, tamolpein wei mi Jerusalem nag Judea ilon lo fidian, you Jordan yen dugo giraŋen na aben an fidian dupalug ru duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Agog saen iŋsan ru duloŋ man aupasek digane na yan walal te dubol ilasa dugo, Jon you Jordan lo isuguai idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ak gug saen iŋ tamol wei mi Farisi agod Sadyusi ago iŋ isuguai o naon na dupalug dilasa dugo yil a, agog ru dabai ipidinaig ibol, “Aŋ mot nanun moroun! Enti Anut san tiŋae saian mitep ilasa wan niŋen o ru kagin ipanaŋ dugo asol dak i? ");
INSERT INTO tbc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aŋ kagin mok a ilom ibilisa dak iri panig yen dan mi agane ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aŋ aŋsem ilom lo igo ta abol na wa, ‘Abraham man maŋ tamama, an maŋ o idaisuda ya.’ Man dugo, ŋai en ŋurupaiaŋ itaot da, Anut ilon ibol tap man, pat e dien den ka iŋiliaip ibilaip Abraham nanun muroun mok dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pilagis ai dabin lo yen la ya. Ai fidian a nuŋod uyan uyan ta ifu na dan, Anut itarep yai lo yabi yaup inanai yau a. ");
INSERT INTO tbc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ŋai you lo mi aŋ ŋusuguaŋ da, ago dop tamolpein naod na aŋ ilom ibilisa yan kuai isi wa. Ak man tamol a ŋai patug fo ipalu dan iŋsan dabai ŋaisag dabai iriŋani geig a. Ŋai man tamol gidad a, amaiak niŋen o iŋsan sendal ŋisini san o yaŋag tia ya. Gug tamol en man Awan Urgun lo isuguaŋ a, agod Urgun an san yai nam ifulanaŋ pe ikok alasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iŋ banin lo kon gilek lo idirai san biouŋ yabig imado da. Aben ate urat a igane wan ikubineg ante itur da. Uyan ak senamo idirai dop, metmet adi yabi yau o da. Ago dop kon anaŋ ab lo itumani wa. Ak man metmet adi man yai lo isuwari yau a. Agod tamol ta yai an igane imat san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aria saen ta Jesus Galili ibiseig you Jordan lo Jon isugui wo yau a. ");
INSERT INTO tbc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ak man Jon ipadau go ibol, “Oŋse amaiak ŋai suguag a. Ata wo oŋ ŋusuguo wo ubol go ŋaisag na palu i?” ");
INSERT INTO tbc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus ru naon irupeig ibol, “Gidad umoi dop ago ilasa wa. Id kagin itaot ak fidian tigane san an tigane itout o uyanan a.” Ago tag Jon awan mi iri a. ");
INSERT INTO tbc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Agog Jon Jesus isugui a. Nek saen a Jesus you ibiseig tan fo isuda man, kumaen panu san dalawan awan pasek go yen dugo, Anut san Ur muluk oŋ idug, iŋ kabuŋan fufo imasi dugo ile ya. ");
INSERT INTO tbc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Agog kumaen panu lo wagiŋ ta iŋiŋeŋ idug, igo ibol dugo iloŋ, “En man ŋaineg Nanug, ŋaineg bubeg mok, iŋ niŋen o ŋai ilog tubun mi uyanan da.” ");
INSERT INTO tbc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aria, Jon Jesus isugui itout man, Urgun iŋ Jesus iduduwig tan kawan ak lo yaup an lo Satan iŋ bitinaek lo igane wa. ");
INSERT INTO tbc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ante man Jesus sen anaŋ lo geg ipani a. Nal 40 ad tidom da anaŋ ta yani na ya, ak niŋen o nal wadan ante man imatigen saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ago dugo ilo ŋanek san ur saiak an iŋsan na ilasag irupeig ibol, “Oŋ Anut Nanun tap, ubol dop pat en bret oŋ ibili wa.” ");
INSERT INTO tbc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ak man iŋ ru naon irupeig ibol, “Girek ta buk lo igo ibol, tamol bret lo mi ta kumaen imado na da, tia, ru a fidian Anut awan lo ilasa dan lo mi iŋ ka kumaen imado wa.” ");
INSERT INTO tbc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","An itout go Satan iŋaneg Jerusalem na diaug, lak na tempel san ŋudun fufo igunig itur a. ");
INSERT INTO tbc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ago dugo irupei, “Oŋ Anut Nanun tap sokalik udu, man dugo, girek ta buk lo igo ibol, ‘Iŋ iŋanen eŋel irupidai dop kagin dupano wa. Banid nam disawo wa, kabelan pat oŋ ŋie ifini banau.’” ");
INSERT INTO tbc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ago dugo Jesus ibol, “Girek ta buk lo dam igo ibol, oŋ mel ta gane tap lo Tubun en oŋane Anut an bitinaek lo ta gane na wa.” ");
INSERT INTO tbc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Agog afon Satan Jesus iŋaneg did lak na geig ak kabuŋan fufo igunig itur dugo tan en san abaŋ fidian, agod iŋaned girager dam, ikubiai pani a. ");
INSERT INTO tbc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Agog irupeig ibol, “Oŋ takoksip ubou ag ule tap man, ŋai mel e ule den fidian ŋupano wa.” ");
INSERT INTO tbc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ak man Jesus ru naon irupeig ibol, “O Satan sen lasa wau! Man dugo, girek ta buk lo igo ibol, ‘Oŋ Tubun en oŋane Anut mi ubou an ule wa. Iŋsen mi niŋen o bigabeg urat gane wa.’” ");
INSERT INTO tbc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ago ibol dugo Satan ibiseig yau a. Agog eŋel dudug kagin dupani a. ");
INSERT INTO tbc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aria, Jon dusubanig subanek ab lo digane ya. Saen Jesus ŋiŋeŋ an iloŋ man aben an ibiseig Galili na yau a. ");
INSERT INTO tbc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Iŋsiŋanen panu Nasaret ibiseig, yaug Kaperniam na imado ya. Taun an you tilianek ta, you uyanan ak man, yaŋan You Galili dubol dan, siŋiren na yen da. Distrik an gugoi uraru a yaŋad Sebulun agod Naftali amaiak sad tan. ");
INSERT INTO tbc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dal amaiak lo awak aban ta profet Aisaia ibol an nuŋon ilasa ya. Iŋ ibol, ");
INSERT INTO tbc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tan Sebulun agod tan Naftali, you tilianek siŋiren na yan, you Jordan aen ate, tan Galili gob wei mi ante dumado dan, tan an niŋen o ŋabol da. ");
INSERT INTO tbc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abaŋ an san tamolpein a tidom tubun lo dumado dan, lilaman tubun ak dile ya. Agod ensauta a mateŋ san miriau lo dumado dan, ilalaŋ iŋsad na ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nek saen an lo Jesus fun iganeg ru ifulaleg ibol, “Ilom abilisa, man dugo, Anut san kagin panek man aŋsam na ipalu sumeik la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus You Galili gigin irig itor dugo tamol ta tein da yil a. Tamol an imug yaŋan Saimon, agod yaŋan ta dam Pita dubol da. Agod tein Andru. Uraru an iy ŋalaŋal, ago yan lo iŋaned dob you lo dubal idu dugo, Jesus ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Agog irupidai, “Ŋai ŋieg abag ari gup tamol aŋal san maŋau ŋipiteŋanaŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Agog dob dubal yen dugo ŋien aban diri kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesus you aen gigin irig isuda yau man afon tamol ta tein da yil a, Jems Sebedi nanun agod tein bakanan ak yaŋan Jon, uraru an wog fo tamad Sebedi da dob duwei se ya. An dam urarum igiai a. ");
INSERT INTO tbc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Agog urarum wog fo dudu kisaek oŋ go tamad dibiseig Jesus ŋien aban diri a. ");
INSERT INTO tbc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Aria Jesus aben Galili ilon lo fidian itiliani pasik go sad ubou ab ilon lo maŋau ipiteŋanai dugo, Anut iŋanen kagin panek an san bilaluŋ dam malak malak ifulale se ya. Saen an lo tamolpein ilod lo subam naon funfun fidian agod ŋied banid ikikai an ikubuniai idu se ya. ");
INSERT INTO tbc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ago tag ŋiŋeŋ iŋ niŋen o ifurak yaug tan Siria ilon lo iŋsan yaŋan tubun geig ilasa ya. Ago yan lo tamolpein fidian subam amad da yan diŋal go san na dupalu ya. Tamolpein madai gidigidad tinid lo, agod subam naon funfun, tamolpein ur saiak saiak ilod lo yen dan, a saen wei mi kurbarib ifu dan, agod tamolpein ŋied banidi imat ak an fidian dusu dupalu ya, agog iŋ ikubuniai idu pasik a. ");
INSERT INTO tbc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Agog tamolpein wei mi geig ŋien aban duri na ya. Galili na dipalug, provins a TenTaun dubol dan te, Jerusalem na, Judea na, agod aben you Jordan aen ate dam fidian iŋ dile wo dupalu se ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aria, saen Jesus tamolpein dubuluwi dugo ago ile man, yaug did giraŋen na isuda yau a. Agog saen imasi an, iŋsan megeloum awan duloŋ o san na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Agog awan isupanig fun iganeg ipiteŋanai a. Agog ibol, ");
INSERT INTO tbc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Talpein enti ŋutun lo binawek niŋen katukan, an bar iŋaneg imado da. Man dugo, Anut san kagin panek man iŋsan mok a. ");
INSERT INTO tbc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Talpein enti tan en lo tinaŋ yabi dan, bar iŋaneg imado da. Man dugo, Anut iŋ ilon iŋane dop ilon pasa ibol a. ");
INSERT INTO tbc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Talpein enti mos kagin mi iri pani dan, bar iŋaneg imado da. Man dugo, tan tilianek en san taman igo ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Talpein enti tamolpein fidian kagin itaot digane san niŋen o yaes isofutani dan, bar iŋaneg imado da. Man dugo, iŋsan mala nouk an idaisuda wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Talpein enti aenta ilod imuŋanai dan, bar iŋaneg imado da. Man dugo, Anut dam talpein an iŋanen ilo muŋanek ipani wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Talpein enti ilon lo ikokan imado dan, bar iŋaneg imado da. Man dugo, iŋ Anut ile wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Talpein enti maror ipidinaig itor dan, bar diŋaneg dumado da. Man dugo, iŋ man Anut san nanun muroun mok ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Talpein enti kagin itaot ak niŋen o muruan ile dan, bar iŋaneg imado da. Man dugo, Anut san kagin panek man iŋsan a. ");
INSERT INTO tbc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Tamolpein aŋ naom dufute wak, muruan dupanaŋ ak, agod aŋ niŋemi wo ru saiak saiak lo sewak digane wa. Man dugo, aŋ ŋaisag tamolpein ago yan niŋen o ago digane tap man, aŋ bar aŋaneg amado da. ");
INSERT INTO tbc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yousai lo amado dop ilom uyanan a, fun dugo, aŋanem naon kumaen panu lo yen den tubun geig a. Man dugo, nek muruan naon kisaek mi tamolpein profet adi imug dumado yan dupidinai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Tan en lo man aŋ nek ibol beig oŋ a. Ak gug beig san gigen itout tap, aria dugo woŋ tamol ta san gigen an iganep beig oŋ ilasa da wak i? Beig an urat aman tia ya, an niŋen o tamolpein tan fo diabi yau dop fufo diau dumul pe duparfufari wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Aŋ tan en lo ilalaŋ oŋ amado da. Panu ta did fufo yen dan tamolpein dimiani san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nek ago mi tamol ta lam ibanip sareg paen na ta igane na da. Tia, lam an ab ilon lo isuŋani dop ate ab ilon igane ilalaŋ da. ");
INSERT INTO tbc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nek dal kisaek an lo na agane dop tamolpein ilod lo aŋsam midiad an dile wa, an lo tamolpein aŋsam kagin uyan uyan an kuai tem dile wa. Ago dop iŋ aŋanem Tamam kumaen panu lo imado dan per dupani wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kabelan Moses san kubiaeŋ agod profet sad ru an ŋai ŋigane itout o ŋupalu abol banau. Ŋai mel uraru an ŋigane itout o ta ŋupalu na ya, tia, ŋai tinig lo iŋaned ru idaisuda wo ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Man dugo, ŋai rumok ŋurupaiaŋ da, gamu yaup tan keit da itout san saen idu dop, samun kitekan ta kubiaeŋ ilon lo yen dan dupasi yaup itout san tia geig a. Tia, mel fidian kubiaeŋ lo man nek ago yen yaup, nek ru fidian digire yan sad nuŋon ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aria, talpein enti a kubiaeŋ tusan ak ta ipilali dugo tamolpein aenta ago mi digane wo ipiteŋanai dan, talpein an kumaen panu lo yaŋan tia wa. Gug talpein enti a kubiaeŋ fidian iri ipani dugo tamolpein aenta kubiaeŋ an fidian diri wo ipiteŋanai dan, iŋ yaŋan kumaen panu na man tubun geig a. ");
INSERT INTO tbc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aloŋ uyan a, man dugo, ŋai itaot ŋurupaiaŋ da, aŋ gidad maeg aganep aŋanem kagin itaot an, kubiaeŋ girek maŋau adi, agod Fasidi adi dam, sad kagin itaot ak iriŋani wa. Tia tap, aŋ Anut san kagin panek lo aladu san man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ru kubiaeŋ a Anut aŋsam tubum bagem irupidai an aloŋ a. Ru an ibol, ‘Oŋ tamol ta funi imat na wa. Talpein ta tamol ifuni imat tap, isol yau san tia ya, tia, iŋ mok mitep Anut san sumiaek lo itur a.’ ");
INSERT INTO tbc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ak man ŋai ŋurupaiaŋ da, aŋ aŋanem turam niŋemi wo ilom wananan dan, kagin an dam saian geig a. Man dugo, talpein enti a tein lo tiŋae saiak igane dan, iŋ dam Anut san sumiaek lo itur a. Agod talpein ta tein pilapil ru saian ak ipani tap, Juda sad kot malan te yak lo itur a. Agod talpein ta tein ipeip ‘oŋ ŋiŋeo’ ibol tap, iŋ Ades san yai lo idu yau a. ");
INSERT INTO tbc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Fun an niŋen o, saen oŋ Anut ilo uyan pani wo mel ta alta san yai fo mari san niŋen o sini palu dop, tei mel ta niŋen oŋ lo ilon saian an ilo sou tap, ");
INSERT INTO tbc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","oŋane ilo uyan san mel an alta naon na wabi idu dop, umul waup tei da bubem kisaek gup, umul palup oŋane mel an sinip marip Anut ilo uyan pani wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Saen oŋ kot ab naon na wau dop, tamol a iŋiliog kot lo wau o dan, dabai ganep ida ŋiŋeŋ an dal te mi akubune kisaek oŋ gup aup alasa wa. Kabelan kot lo alasa dop, tamol an tulek tamol banin lo iginiop, iŋ oŋ ai katuk banid lo iganep, subanek ab lo dibilio waup, dusubano banau. ");
INSERT INTO tbc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ŋai rumok ŋurupaio da, oŋ nek ago mado yaup naon dugo dupano yan udad pasik a. ");
INSERT INTO tbc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Aŋ ru kubiaeŋ e dubol en aloŋ a, ‘Oŋ jeit kagin ta gane na wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ak man ŋai igo ŋurupaiaŋ da, tamol ta pein ta ilep niŋen o ilo masa lo malan isi tap, iŋ ilo sou lo da jeit kagin digane la ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Oŋ mala iganep kagin saiak lo udu tap, mala an fure ilasap biliau a. Gidad, an uyan a, an man oŋ tini san boi ta mi ideg yau a, kabelan oŋ tini fidian mi Ades lo idu banau. ");
INSERT INTO tbc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Agod saen oŋ bani won ak boi iganep aupasek lo udu tap, an dam tutep biliau a. Gidad, an man oŋ tini san boi kisaek o lian bisei a, kabelan an iganep oŋ tini fidian mi Ades lo yau banau. ");
INSERT INTO tbc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ru kubiaeŋ e dubol en dam aloŋ a, ‘Tamol ta iwon pein ak ikudi wo ilon ibol tap, nug banin diabi an itout san girek iwon pein ak an ipani wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ak man ŋai igo ŋurupaiaŋ da, tamol ta iŋsan pein ikudi san fun man kisaek o lian a, pein an jeit kagin igane la ya, nek an mi a. Saen pein an jeit kagin ta igane na yak gug iwon ikudi tap, iŋ iganeg pein an jeit san pein ago ilasa ya. Man dugo, iŋsan pein an tamol foun ak iŋane tap man, da jeit digane wa. Ago dop tamol sen ta pein a iwon ikudi an iŋane tap, iŋ dam pein an da jeit kagin digane ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Afon ru a Moses san kubiaeŋ tubud baged irupidai an aŋ aloŋ a, ‘Saen oŋsigane ŋiŋeŋ dabai pani wo dop, ŋiŋeŋ nuŋon aman tia yak lo dabai pani wo ago ta gane na wa. Tia, oŋane ŋiŋeŋ Anut malan lo uri uyanan an mi gane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ak man ŋai igo ŋurupaiaŋ da, oŋ mel ta san yaŋan lo oŋsa ru dabai pani wo ta gane na wa. Oŋ kumaen panu yaŋan patep lo oŋane ru dabai ta pani na wa, man dugo, aben ante Anut san badim yen da. ");
INSERT INTO tbc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Agod tan san yaŋan patep lo oŋane ru dabai ta pani na wa, man dugo, tan en man aben Anut san ŋien ate yaes ibal da. Jerusalem san yaŋan patep lo ago gane wan niŋen o umoi a, man dugo, aben an man Kiŋ tubun amaiak san panu malan te ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Taidam, oŋ kabuŋa dam san yaŋan patep lo oŋsa ru dabai ta pani na wa, man dugo, oŋ gumura roun ta ganep milkouk boi bilkas boi ilasa san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nek ‘awok’ ubol a, tia dop, ‘tia’ ubol a, an mi idaisuda ya. Oŋ mel ta suguan taida gane tap, kagin an san fun man, ilo sou saiak a ilo lo yen damaiak lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Aŋ mel e kubiaeŋ ibol en aloŋ a, ‘Malak ta iŋ oŋ mala san a, agod luok ta iŋ oŋ luo san a, agodo naon pani wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ak man ŋai igo ŋurupaiaŋ da, oŋ tamol a saian an ta wabiani na wa. Tia, saen talpein ta kudaŋa won ak igufte tap, ŋas ak dam bilisa dop dam igufte wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Agod saen muruan ta niŋen o talpein ta kot lo iŋilio waup ante tulek tamol irupaio, ‘oŋane siot pani.’ Ago tap, siot mi ta pani na wa, tia, mel suguan taidam pani wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Agod saen yu san tamol ta iŋanen biouŋ sinip kilomita kisaek wau wo isoduduno tap, sinip kilomita uraru wau pani wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Agod saen talpein ta mel an tia dop bunawi wo ibol tap, pani wa. Agod saen talpein ta oŋsa na gubun igane wo dop ta umoi na wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Aŋ mel e kubiaeŋ ibol en aloŋ a, ‘Oŋane tura murou ilo pidinai a, ak gug oŋane ager adi niŋedi wo man siai gane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ak man ŋai igo ŋurupaiaŋ da, aŋanem ager adi dam bubem apidinai a. Agod ensauta a muruan dupanaŋ dan niŋedi wo Anut san na agudani wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","An lo dop aŋ man Tamam kumaen panu lo imado dan iŋsan nanun muroun mok ago amado wa. Man dugo, iŋsen mi iŋanen ad igane ilasa dugo tamol uyan, agod tamol saian ak sisem ilalaŋ ipidinai da, agod ui iganep tamol sad kagin itaot, agod a sad kagin ta itaot na yan, sad na isi wa. ");
INSERT INTO tbc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ak dugo, tamolpein a oŋ niŋe wo ilod dupano dan mi ilo pidinai tap, Anut naon uyan ak ta ipano wak i? Tia geig a. Man dugo, moni takis ŋilaŋal tamol adi dam, kagin nek ago mi digane na ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Agod oŋ tura murou mi sad na adian ubol tap, oŋ kagin dugo uyan ak suguan taidam tamolpein aenta ta digane na yan gane di? Gob adi dam kagin nek ago mi digane na ya. ");
INSERT INTO tbc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amaiak niŋen o nek ibol oŋane Tama lak na yan itaotan igo woŋ, oŋ dam itaota lasap mado wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kagin gane wo uyan a, oŋane kagin uyan uyan man tamolpein naod na gane dop lo dilio wo ago ta gane na wa. Oŋ ago gane tap, Tama kumaen panu lo imado dan naon ta ipano na wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Fun an niŋen o, saen oŋ talpein enti mel aman tia yan mel ta pani wo ilo ibol tap, talpein ta imug mi dinip yaup dugo gane wo dan niŋen o tour ta iwi na wa. Tamol balek uraru san kagin diri dan man, ubou ab lo, agod dal te dam, tamolpein dil o kagin naok ago yak digane na ya. Ŋai rumok ŋurupaiaŋ da, tamol naok an iŋaned naon idaisuda mi diŋane la ya. ");
INSERT INTO tbc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ak man saen oŋ tamol filiad tia yak mel ta pidinai tap, oŋane bani ŋas an biabi a bani won ak nam gane dan iloŋ o ta ulefuni na wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","An lo dop mianuk lo mi oŋsa binawek pidinai a. Ago dop lo oŋane Tama kagin a mianuk lo mi gane yan ile dop, naon ipano wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Agod saen oŋ gudani wo dop, tamol balek uraru san kagin diri dan, igo woŋ ta gudani na wa. Iŋ ilod ibol dak ubou ab lo, agod dal titin gidigidad ate dam, dugudani wo dutur dop lo tamolpein diliai o digane da. Ŋai rumok geig ŋurupaiaŋ da, iŋ naon nek an mi diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ak man saen oŋ gudani wo dop oŋane galuŋ lo ladup, dalawan futani gup, mianuk lo mi Anut enti a sen imianig imado dan san na gudani wa. Ago dop Tama enti a mel ta mianuk lo yen ak gug, iŋ kuai te mi ile dan, naon ipano wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Agod saen aŋ agudani man, nek ibol gob adi igo ŋiŋeŋ kawan ak ta afuti na wa. Man dugo, iŋsad ŋiŋeŋ wei mi dubol dan lo mi Anut kududon igure wak ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nek ibol iŋ dugudani dak igo woŋ ago ta agane na wa. Man ata wo? Gamugo oŋane Tama sumiani dop mel a niŋen o umat pe sumiani wo dan iŋ iloŋ la ya. ");
INSERT INTO tbc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Fun an niŋen o aŋ igo agudani wa. O Bai, oŋ did lo mado da. Oŋane yaŋa gun migane da. ");
INSERT INTO tbc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Oŋane kagin panek idu ipalu wa. Oŋane awa mi muri mupani wa, tan na nek ibol did lo digane dak ago mi a. ");
INSERT INTO tbc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gamu nal en san anaŋ panama wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Maŋsama gubun oŋ lo migane yan pasi yau a, nek ibol aenta sad gubun maŋ lo diganeg mupasi dak ago mi a. ");
INSERT INTO tbc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Maŋ kubianek lo madu san an lo ta giniama na wa. Tia, Satan tuon lo patuma pasi wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Man dugo, aŋ tamol ta sad aupasek apare idu tap, Tamam lak na yak aŋsiganem aupasek dam ipare idu wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ak gug aenta sad aupasek ta apare idu na tap, Tamam aŋsam aupasek dam ta ipare idu na wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Saen oŋ gudanek san dabai ŋane wo anaŋ lo geg gane tap, nao san leil ta ganep saian na wa, nek ibol tamol balek uraru adi digane dak ago mi ta gane na wa. Iŋ naod diganep saian dop aenta dil dop dubol a, ‘iŋ anaŋ tia ditor da.’ Ŋai rumok ŋurupaiaŋ da, iŋaned naon idaisuda mi diŋane la ya. ");
INSERT INTO tbc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ak man saen oŋ gudani wo anaŋ lo geg gane tap, usug pe nao kubune wo uyan a. ");
INSERT INTO tbc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ago dop aenta oŋ anaŋ lo geg gane yan ta duloŋ na wa. Ago dop Tama mi ilio dop, iŋ mel mianuk lo ile dan, naon ipano wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Aŋ tan en lo filian tubun mok afuti wo urat maeg ta agane na wa. Fun dugo, ente man kadum diani wak, teirteir dam malad dusue wak, gumagam dam ab digilep diladup digam a. ");
INSERT INTO tbc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ak man kumaen panu lo mi filian afuti wa. Aben an ate kadum ta diani na wak, teirteir dam malad ta dusue na wak, agod gumagam dam ab digilep diladup ta digam na wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Man dugo, aben a oŋane filia ate yen dan, nek aben an mi lo oŋane ilo tini fidian dam antem yen a. ");
INSERT INTO tbc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Oŋane mala man tini san lilaman. Saen oŋane mala uyan tap, tini fidian mi igane ilalaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ak man saen oŋ mala saian tap, tini fidian geig an tidom tubun da awan isa wa. Aria, saen lilaman oŋ lo yan tidom tubun oŋ tap, tidom tubun an bilkas geig a. ");
INSERT INTO tbc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tamol ta gurman uraru mi nal kisaek lo mi awad yabi san tia ya. Iŋ ago igane wo igane tap, iŋ kisaek o lian niŋen o imat dop, turan ile sisaian a. Tia dop, kisaek o lian ilon ipani dop, turan patun ipani wa. Nek ago mi oŋ Anut moni da sisem uri san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nek an niŋen o ŋurupaiaŋ da, aŋsam madok niŋen o ilom ta muruan na wa. Mel ani wan niŋen o, mel aluk san agod biouŋ tinim san an niŋedi wo ilom ta muruan na wa. Ak dugo, anaŋ an mel tusan dugo ŋutumi an mel tubun ak i? Aria, taida mi, biouŋ tinim san an mel tusan dugo tinimi mok an mel tubun ak i? ");
INSERT INTO tbc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","An niŋen o kuseŋ eil, iŋ anaŋ ta dupae na da, iŋ anaŋ disinip anaŋ ab lo ta dutumani na da, ak man Tamami kumaen panu lo amaiak iŋaned anaŋ ipidinai da. Ak dugo, Anut malan lo kuseŋ mel tusan dugo aŋ mel tubun geig ak i? ");
INSERT INTO tbc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ak dugo, aŋ luluŋam lo talpein ta ilon weiwei dan lo nal taidam ka imado wak i? ");
INSERT INTO tbc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Agod aŋ ata wo biouŋ direk san niŋedi wo ilom muruan dak i? Garaŋ san kakak dugo woŋ disa dak ilom isou a. Kakak an urat ta digane na dak, agod iŋaned biouŋ dam ta diwei na da. ");
INSERT INTO tbc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ak man ŋai ŋurupaiaŋ da, gidad Solomon damag siŋaokan ak dupani bo man, iŋsan leil man kakak an san leil igo tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aria, Anut garaŋ san kakak san leil iganep siŋaokan ago dilasa dop, gidad gamu kumaedi dumado gup gabulop yai lo diabiau o tap, o aŋ tamol ilo rumok amam tusan a, ak dugo, aŋ dam biouŋ tinim fo ta idiri na wak i? ");
INSERT INTO tbc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amaiak niŋen o ilom muruan pe ‘ata tani wak i?’ tia, ‘ata taluk ak i?’ tia, ‘ata tinid san biouŋ oŋ tidiri wak i?’ ago ta abol na wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Man dugo, gob adi mel an fidian abaŋan diabi dutor da. Agod aŋanem Tamami lak na imado dan mel dugo niŋedi wo amat dan iŋ fidian iloŋ pasik a. ");
INSERT INTO tbc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Gug imug mi man, iŋsan kagin panek lo aladu san, agod iŋsan kagin itaot an dam aŋane san niŋen o maeg agane wa. Ago agane tap, mel an fidian dam aŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ak niŋen o gabulo san niŋen o ilom ta muruan na wa, man dugo, gabulo man iŋsen niŋen o mi ilon muruan a. Nal anen anen iŋaned muruan anen anen idaisuda la ya. ");
INSERT INTO tbc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Oŋ aenta biai dudu wo bitinaek lo ta dirai na wa. Oŋ ago ta gane na tap, Anut dam oŋ lo ago ta igane na wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Man dugo, dal kisaek nek a lo, aenta bitinaek lo dirai dan, ago mi Anut oŋ dam lo ago igane wa. Agod saen aenta sad madok bitinae ule man, tou dugo yan lo oŋ aenta pidinai dan, tou nek kisaek an mi lo Anut oŋane madok dam ibitinae ile wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dugo woŋ go metmet samun ta tei malan lo ule gug oŋsigane mala lo ai lapan yen an ta kubiani na yak i? ");
INSERT INTO tbc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","En dugo woŋ tei rupeip ubol, ‘Gane dop metmet samun a mala lo yan ŋupasi yau,’ dugo oŋsigane mala lo ai an nal fidian mi ago yen di? ");
INSERT INTO tbc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oŋ bale uraru ama ya, imug mi sigane mala lo ai lapan an pasi gup, lo abaŋ ka ule uyanan dop lo tei malan lo metmet samun an pasi yau a. ");
INSERT INTO tbc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mel gun ak goun ta pidinai na wa. Ago gane tap, goun an didaŋsap tini diburtiti kitiktik a. Nek ago mi oŋane koksai bor naod na ta ubal na wa. Ago gane tap, bor ŋied nam duparfufari wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Sumiaeŋ dop Anut ipano wa, abaŋ ule dop ule wa. Dalawan tuti dop ipasi pano wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Man dugo, talpein a isumiaeŋ dan iŋane wa, talpein a ibaŋ ile dan ile wa, agod talpein a iladu wo isumiaeŋ dan, Anut dalawan ipasi pani wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Enti aŋ luluŋam lo nanun bret o isumiaeŋ dop pat ipani wak i? ");
INSERT INTO tbc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tia dop, iy o isumiaeŋ dop mot wagai ak ipani wak i? ");
INSERT INTO tbc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Fun an niŋen o gidad oŋ tamol saia bo man, nanu murou mel uyan uyan ak pidinai o uloŋ a. An niŋen o mel uyan uyan ak sapita taida dop oŋ Tama kumaen panu lo yan tamolpein a dusumiani dan ipidinai ak i? ");
INSERT INTO tbc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ak niŋen o mel fidian lo kagin tamolpein aenta dukubiai pano wo ilo ibol dan, kagin nek an mi oŋ dam imug mi kubiai pidinai a. Ago agane tap, kagin naok naok nek a kubiaeŋ lo ibol an, agod profet sad ru kubiaeŋ durupaiaŋ an dam ibulumai a. ");
INSERT INTO tbc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Dalawan ipipiani aman an lo mi aladu wa. Man dugo, dalawan a pitiŋinek aben lo yau an man tubun geig a, agod san dal dam nek ago mi a, agod tamolpein a dalawan amaiak lo diladu dan man wei kasik a. ");
INSERT INTO tbc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ak man dal a kumaen aben lo yau dan man ta pasauman na ya, agod san dalawan ipipiani aman a. An niŋen o tamolpein kisaek kisaek mi dal amaiak dile da. ");
INSERT INTO tbc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Profet sewak an niŋedi wo kagin agane wa. Iŋ tinidi sipsip suŋulon nam dubuluwi dop lo mos nam aŋsam na dupalu wa, ak man tinidi ilon lo man iŋ nek ibol goun kasik yai ided geig ak igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Iŋsad urat nuŋon digane ilasa dan te gup sad bunud lo ale aloŋ ak iŋ tamol naok ago ya. Ak dugo, ka tamolpein ai dudurun anda yak lo aŋar nuŋon diŋane wak i? Tia, nom lo fud nuŋon diŋane wak i? Tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Fun an niŋen o saen ai ta uyan tap, san nuŋon ifu ilasa man dam uyan mi a. Ak man saen ai ta saian tap, san nuŋon dam saian a. ");
INSERT INTO tbc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ai uyan ak lo nuŋon saian ak ilasa san tia ya, agod ai saian ak lo nuŋon uyan ak ilasa san dam tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Saen ai ta nuŋon ta ifu uyan na tap, ai an ditare idup dubal yai fo isuda wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nek dal an lo mi sad naok naok dugo sad kagin lo igane ilasa dan te, iŋ tamol naok dugo yan aŋ ale aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tamolpein a ŋai durupaiag pe ‘O Tubun ak, O Tubun ak’ igo dubol dan luluŋad lo, aenta Anut san kagin panek lo diladu san tia ya. Tia, tamolpein nek a ŋaisag Tamag kumaen panu na imado dan san ilon dugo yen dugo durid amaiak mi diladu wa. ");
INSERT INTO tbc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nal an lo tamolpein wei mi durupaiag pe dubol a, ‘O Tubun en, O Tubun en, maŋ oŋ yaŋa lo profet ru mabol ilasa ya, oŋ yaŋa lo ur saiak saiak tamol ilod lo mukudai diau a, agod oŋ yaŋa lo dam urat dababai anda yan wei mi migane na yan ta uloŋ na i?’ ");
INSERT INTO tbc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ak gug ŋai ŋurupidaip ŋabol a, ‘Ŋai nal fidian aŋ ta ŋaloŋ na ya. Aŋ kulob saiak saiak san tamolpein, abisawag pe sen alasa!’ ");
INSERT INTO tbc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ak niŋen o talpein a ŋaisag ru iloŋ pe awag kagin ipani dan, iŋ nek ibol maŋau tamol ab yabi wo dugo bag san gib kuror mi yabig, pat nam bag fun isueg sakar ak igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Agog saen ui tubun ak isi dugo, lom dam idug tim ifureg ab an ifuni bo man, ab an ibili idu san tia ya. Man dugo, ab an pat nam yabi an lo itur sakar a. ");
INSERT INTO tbc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ak man talpein ru e ŋabol den iloŋ gug awag kagin ta ipani na dan, iŋ man nek ibol ŋiŋeo tamol igo ya, iŋanen ab yabi wo dugo gib ta yabi nag, lul fufo mi yabi ak igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Agod saen ui isig lom tubun ak idu dugo tim dam ifureg, ab an ibili idug iratitale yau a. Agod ab an san pitiŋinek man saian geig a.” ");
INSERT INTO tbc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Saen Jesus tamolpein sad na mel e fidian ibol se yen igane itout man, iŋsan dal dugo lo maŋau ipidinai man dileg maladi ifure idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Fun dugo, iŋ nek ibol iŋsad kubiaeŋ san girek maŋau adi igo woŋ maŋau ta ipidinai se na ya, tia, tamol tubun yaŋan anda yak oŋ ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Saen Jesus did an fo idu dugo tamolpein wei mi ŋien aban diri se ya. ");
INSERT INTO tbc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ago dugo tamol ta tinin lepra yafutani an ipalug Jesus naon na turun isaluwig irupei, “O Tubun ak, oŋ ilo ibol tap, ŋai kubuniag pe tinig ikok ilasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Agog Jesus banin iwateg isupurig ibol, “Ubol agom ŋai ilog ago yen da, ikok lasa.” Agog tamol an tinin ikok ilasa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ago dugo Jesus irupeig ibol, “Kagin gane, kulob ilasa yen niŋen o aenta ta rupidai na wa. Tia, itaot waup, tini Juda sad pris mi kubiaip ile dop, mudan a Moses san kubiaeŋ lo ibol dan ŋanep Anut yai gane pani. An lo dop tamolpein duloŋ ak oŋane subam itout a.” ");
INSERT INTO tbc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus Kaperniam na yaug saen iladu wo dugo Rom san yu gurman ta iŋsan na ipalug binawek ipani wo imosiai a. ");
INSERT INTO tbc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ago dugo irupeig ibol, “O Tubun en, ŋaisag urat tamol ta subam ifunig ab lo yen da. Ŋien banin imat dugo madai tubun kasik lo yen da.” ");
INSERT INTO tbc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Agog ru naon irupeig ibol, “Ŋai ŋupalup ŋukubune wa.” ");
INSERT INTO tbc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ak gug yu gurman an ru naon irupeig ibol, “O Tubun en, oŋ ŋaisag ab lo ladu san man ŋai yaŋag tia ya. Ru mi ubol dop lo ŋaisag urat tamol uyan isusa da wa. ");
INSERT INTO tbc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Man dugo, nek oŋse ago mi, ŋai dam tamol aenta waged lo urat ŋigane da, agod ŋaisag yu tamol adi paeg na dumado da. Saen ŋai yu tamol ta ‘wau’ ŋabol tap, iŋ yau a. Tia, ta ‘palu’ ŋabol dop iŋ ipalu wa. Tia, ŋaisag biabi ŋilaŋal ta ‘igo gane’ ŋabol dop, iŋ igane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus ru an iloŋ man, irut saian geig a. Agog idaŋsag tamolpein a ŋien aban diri se yan irupidai, “Rumok geig ŋurupaiaŋ da, tamol ta ilo rumok naok igo yak aman da Isrel ilon lo ŋile man tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ŋai ŋurupaiaŋ da, tamolpein wei mi ad ilasa dak ate, agod ad idiau dak ate dam dupalup Abraham, Aisak, agod Jakob dida dutumanip, Anut san kagin panek aben ante sisem dumasip, soubul san anaŋ diani wa. ");
INSERT INTO tbc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ak man Anut iŋsan kagin panek aben san tamolpein iŋal pe yabiaup patun fo dilasa dop tidom tubun lo mi dumado yau a. Aben ante man tamolpein tinaŋ digane dop madai lo luod dugurmi wa.” ");
INSERT INTO tbc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Agog Jesus yu gurman an irupei, “Waup, nek ibol oŋ ilo rumok ama da ago mi, ŋai dam nek ago mi ŋigane wa.” Saen Jesus ago ibol go itout man, biabi ŋilaŋal an uyan isusa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pita raon subam ifunig tinin dam wananan go, gadab fo iŋsiganen ab lo diganeg yen se ya. Saen Jesus ab an lo iladu man, pein an yen dugo ile tag ");
INSERT INTO tbc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","banin iwateg pein an banin yabi a. Agog pein an tinin ibubarum kisaek oŋ dugo subam an ibisei a. Agog imasa itur go anaŋ ikubuneg Jesus kagin ipani a. ");
INSERT INTO tbc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aria, saen gurai isi dugo, tamolpein a tinid ur saian saian amad da yan diŋal dupalu ya. Ago dugo Jesus ru ta dabai anda yak lo ur saian an fidian ikudai diau a, agog tamolpein subam amad da yan dam ikubuniaig uyan dilasa pasik a. ");
INSERT INTO tbc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesus kulob a igane yan lo awak aban ta profet Aisaia ibol an nuŋon ilasa ya, “Iŋ idsad muruan iŋal go iŋanen tinin nam idsad subam isini a.” ");
INSERT INTO tbc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Saen Jesus tamolpein wei mok dubuluwi dugo yil an, iŋanen megeloum adi wog nam you aen ate diau wo irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Agog kubiaeŋ san girek maŋau ta siŋiren na ipalug irupei, “O Girek Maŋau, oŋ dugon te wau o dan, ŋai dam ate tau a.” ");
INSERT INTO tbc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Gug Jesus ru naon irupeig ibol, “Goun kasik iŋ wur amad da ya, anakanak dam wur amad da ya, gug Tamol Nanun niŋen o man aben ta ate kabuŋan igansip ŋioŋ yabi san o man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Agog tamol ta iŋ ŋien aban iri an irupeig ibol, “O Tubun en, umoi dop ŋaup, tamag ŋisare gup.” ");
INSERT INTO tbc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ak man Jesus irupeig ibol, “Ŋieg aban uri wa. Tamolpein a ŋutudi imat la yan bisawai dop iŋsiganed tubabun ka disiriai a.” ");
INSERT INTO tbc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","You lo dupalug Jesus imug wog lo isuda gug iŋanen megeloum murna disudag diyawai diau a. ");
INSERT INTO tbc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Agog you titiŋaem dumado dugo tim tubun ak ifure ya. Ago dugo you tubun geig imasag wog ilon lo iladu bo man Jesus ŋioŋ yabi se ya. ");
INSERT INTO tbc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Agog diaug Jesus dufufunig dubol, “Tubun ak binawam, tadeg tau o sumeik da.” ");
INSERT INTO tbc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Agog irupidaig ibol, “O aŋ tamol ilo rumok amam nanunan, ata wo arer dak i?” Agog imasa itur go tim tamun da ipidai man, tim ifure na yan itout dugo you malin idu geig a. ");
INSERT INTO tbc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Saen iŋsan megeloum ago dile man malad ifure idu dugo sed nug dusumianig dubol, “En so tamol ta igo yak i? Gidad you tim da dumasa yak dubo man awan duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus wog nam you aen ate ipalu dugo abaŋ ta Gadarin tamolpein dumado dak ate disasau a. Aben ante tamol uraru tinid ur saian saian anda yak mutou aben lo dumado se ya. Uraru an yaided nuŋon a, an lo tamolpein niŋedi wo tubun mi direr dugo aben ante ta diau na da. Saen Jesus sumeik ipidinai man mutou dibiseig diaug naon na dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ago dugo tubun mi disasai dugo duwagiŋ go dubol, “O Anut Nanun, oŋ mel ta maŋ lo i? Dag iŋsan saen mok gamugo ilasa wo dugo, maŋ imug madai tubun ak panama wo palu i?” ");
INSERT INTO tbc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aria, iŋ dumado dak ate kitekan asau man, bor malan tubun geig ak dunuaeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Agog ur saian saian an Jesus san na dumosiaig dubol, “Gidad oŋ tamol uraru en ilod lo kudama tap, diramap maup bor malan tubun an tinid lo miladu wa.” ");
INSERT INTO tbc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Agog iŋ irupidaig ibol, “Au.” An lo man, ur saiak saiak dilasag diaug bor tinid ilon lo diladu ya. Ago yan lo bor fidian dumasag, dumaspalug diaug damab aen te dudug you duluk go dumat pasik a. ");
INSERT INTO tbc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tamol bor kagin dupidinai dan disol go dumaspalu oŋ panu lo diaug mel ilasa yan niŋen o tamolpein durupidaig duloŋ a. Agod tamol a ur saiak saiak ditirni na yan mel dugo iŋ lo ilasa yan dam niŋen o dubol go duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","An lo man, panu an san tamolpein fidian direr go Jesus dile wo dupalu ya. Saen dupalug dile man iŋaned aben ibisei wo dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus wog fo isudag you ituteg aen ate siganen taun lo yau a. ");
INSERT INTO tbc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ante tamol ta ŋien banin fidian ikikai aman ak kapal anda disinig Jesus san na dupalu ya. Agog saen Jesus iŋaned ilo rumok ile man, tamol an irupeig ibol, “O ŋai nanug, se ilo wabisa; ŋai oŋane aupasek fidian ŋusuas yau la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ago dugo kubiaeŋ san girek maŋau aenta iŋ awan duloŋ man ilod lo mi dubol se, “Tamol an Anut lo ru kukok igane da.” ");
INSERT INTO tbc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ak man Jesus iŋ kankan dugo digane se yan fidian iloŋ pasik an lo irupidaig ibol, “Aŋ ata wo ilo saiak saiak ilom lo agane dak i? ");
INSERT INTO tbc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ata mel pasauman ak i? Aria, ŋai igo ŋabol, ‘Oŋane aupasek ŋupasi yau wo?’ Tia, ‘Masap kapal wabisap utor o?’ ");
INSERT INTO tbc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gug kulob e ŋigane en lo, ŋai Tamol Nanun, tan en lo Anut wagen lo aupasek ka ŋupasi yau amaiak aloŋ o ...” saen ago ibol man, tamol a ŋien banin ikikai aman ak irupei, “Oŋ masa utur pe oŋane kapal ŋanep oŋsigane na wau.” ");
INSERT INTO tbc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Agog tamol an imasa itur go siganen ab lo yau a. ");
INSERT INTO tbc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aria, saen tamolpein a Jesus dubuluwi an kulob ago dile man, dirut saian go Anut yaŋan diabisa ya, man dugo, iŋsan dabai naok ago yan tamol ta ipanig, an lo tamol ŋien banin ikikai ak ikubune ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus kitekan taida yaug ab ta, ate moni ŋilaŋal tamolpein sad na takis diŋane dak ate ilasa ya. Ate man takis ŋilaŋal tamol ta imasig imado dugo ile ya. Tamol an yaŋan Matyu. Agog irupei, “Ŋieg aban uri.” Agog Matyu imasag ŋien aban iri a. ");
INSERT INTO tbc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Murnag saen Jesus Matyu san ab lo imasig imado dugo sisem anaŋ diani man, takis ŋilaŋal wei mok, agod tamolpein aenta wei mi a Farisi adi niŋedi wo “aupasek tamol” dubol dan dam, dupalug dumasig Jesus iŋanen megeloum dida sisem anaŋ diani a. ");
INSERT INTO tbc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Saen Farisi adi ago dile man Jesus san megeloum dusumianai, “En ata wo aŋsam girek maŋau takis ŋilaŋal, agod aupasek tamolpein dida sisem anaŋ diani dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ak man Jesus iŋsad sumiaeŋ ago iloŋ man irupidaig ibol, “Tamolpein a uyadi ak dokta san na ta diau na da, tia, tamolpein subam anda yak mi diau da. ");
INSERT INTO tbc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Alasa aup girek en ilom isou uyan dop san fun aloŋ mok a, ‘Aŋ ilo uyan apanag an niŋen yai agane panag o ilog ta ibol na ya, tia, aŋ aenta ilom imuŋanai o mi ŋamat da.’ Man dugo, ŋai tamolpein a itaot adi dubol dak ŋigiaip dupalu san niŋen o ta ŋupalu na ya, tia, aupasek tamol adi mi ŋigiai o ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Agog Jon san megeloum Jesus san na dupalug dusumiani, “Maŋ agod Farisi dida nal kadi anaŋ lo sema geg ipanama da, ago gug ata wo oŋsigane megeloum anaŋ lo geg ta digane na dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Agog Jesus irupidaig ibol, “Tamol ta iwon da sad nug ŋanek san saen an ilom isou a. Ak dugo, saen tamol an iŋanen turan muroun dida dumado dan, waliŋ diganep lo ilo muruan amad da dumado wo ago digane wak i? Tia geig. Gug nal ta ipalu dan te man, nug ŋanek san tamol an naon atna tia wa, nal an lo gup waliŋ digane dop ilo muruan lo ditata wa. ");
INSERT INTO tbc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tamol, yamel kilaken ta ikukuik na yan irasirep ate yamel wagam ak san mutunuk ta iwei na da. Man dugo, ago igane tap, yamel kilaken foun an yamel wagam an irae dop afon irasire dop daoŋ ipani wa. ");
INSERT INTO tbc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Agod tamol dam wain foun ak bilelek suŋulon wagam ak lo ta diwali na da. Man dugo, ago digane tap, wain foun an iganep bilelek suŋulon wagam an ikafut yaup ipuk dop, wain ikulmaek pe tan fo idu dop, bilelek suŋulon dam daoŋ ipani wa. Fun an niŋen o iŋ wain foun ak bilelek suŋulon foun ak lo mi diwali da, ago dop bilelek suŋulon an iŋ wain da sisem ka uyanan mi dien yau a.” ");
INSERT INTO tbc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Saen Jesus mel an sad na ibol ilasa dugo, gurman ta san na ipalug ŋien fun na turun isaluwig irupeig ibol, “Ŋaineg nanug pein gamu na geig imat a, ak man oŋ iŋsan na palup bani kabuŋan fufo gane tap man, kumaen ilasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ago tag Jesus imasag iŋanen megeloum dida ŋien aban dirig diau a. ");
INSERT INTO tbc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gug saen dal durig diau man, pein ta subam anda imado se yan ŋien aban irig yau se ya. Pein an anaŋar 12 siganen dar tinin ilon lo yak ilasa se ya. Aria, iŋ Jesus patun fo yaug sumeik man banin iwateg iŋsan kulos bitiŋen isupuri a. ");
INSERT INTO tbc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Man dugo, iŋ imug mi siganen ilo sou lo ago ibol, “Ŋai banig iŋanen kulos mi ŋusupuri tap, iŋanen dabai ikubuniag a.” ");
INSERT INTO tbc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Saen iŋanen kulos isupuri man, Jesus idaŋsag ileg irupei, “O nanug pein, ilo wabisa, oŋsigane ilo rumok ŋai lo yan ikubunio ya.” Ago ibol man pein an tinin nek saen ante mi uyan ilasa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Saen Jesus gurman an san ab ate ilasa man, ilon lo iladu ya. Ante man tamol suduk duwi dugo, tamolpein ditata wo dutumani an, liliŋan tubun mok diganeg dumado dugo yil a. ");
INSERT INTO tbc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Agog irupidaig ibol, “Alasa au, man dugo, pein baras an ta imat na ya. Tia, iŋ ŋioŋ yabi da.” Ago ibol man disel oŋ dugo kukok an digane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ak man Jesus imug tumanek malan an ikudaig kuai te dilasa, agog pein baras an san galuŋ lo iladug banin te yabi a. Saen yabi man pein baras an imasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Agog kulob e igane yen san ŋiŋeŋ an diŋaneg aben tubun an san titin fidian lo dubol itiliani a. ");
INSERT INTO tbc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus aben an ibiseig yau dugo tamol uraru malad itau an ŋien aban duri se ya. Iŋ tubun mok disasai dugo duwagiŋ se, “O Dawid Nanun, gidad ilo panama wo!” ");
INSERT INTO tbc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Saen Jesus ab ta lo iladu man, tamol uraru malad itau an ate san na dilasa ya. Ago tag irupidaig ibol, “Ak dugo, ŋai kulob e ŋigane san an ilom lo rumok ak i?” Go iŋ durupei, “Awo, O Tubun ak.” ");
INSERT INTO tbc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Agog Jesus uraru an maladi isupuri dugo ibol, “Aŋanem ilo rumok iri panim nek ago mi aŋ o ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Agog maladi uyan ilasag abaŋ dile uyan a. Ak gug Jesus ru dabai nam ru kagin igo irupidai, “Kagin agane wa, talpein ta kulob e ilasa yen duloŋ o ta arupidai na wa!” ");
INSERT INTO tbc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ak man dibiseig diaug ŋiŋeŋ an aben fidian distrik an ilon lo dubol ditiliani se ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Saen Jesus iŋanen megeloum dida ab an dibisei man, tamol awan itau ak ta diŋaneg san na dupalu ya, man dugo, tamol an ur saiak ilon lo imado na ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus tamol an ilon lo ur saiak an ikudi man, tamol an iŋiŋeŋ kisaek oŋ a. Agog tamolpein a dutumanig dumado dan kulob an dileg durut saian go dubol, “Mel tutubu naok ago yak imug mi Isrel na ta ilasa na ya.” ");
INSERT INTO tbc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ak man Farisi adi dubol, “Ur saiak sad gurman iŋanen tuon nam ur saiak tamol tinid ilon lo yak ikudai da.” ");
INSERT INTO tbc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus panu fidian agog taun fidian lo itilianig itor se ya. Iŋaned ubou ab fidian ilod lo ipiteŋanai go aben gidigidad lo Anut san kagin panek an san bilaluŋ uyanan ak niŋen o ibol ilasa se ya. Agod subam naok funfun an fidian dam ikubuniai na ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Saen tumanek ile man, ilon lo tubun mok imuŋanai a, man dugo, iŋanen malan lo goun kasik tamolpein an dirasisirai ak igo woŋ a, agod tan fufo dudug dabai amad tia yak dien dak igo woŋ a. Nek ibol sipsip sad muroun tia yak ago mi dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Agog Jesus iŋanen megeloum irupidaig ibol, “Anaŋ wei mi ibes pasik a, ak man sinek san tamol wei an tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Amaiak niŋen o aŋanem gadiŋ lo man, aŋ sinek urat san muroun asumiani dop iŋ ka sinek san tamol wei mok iŋal pe idinaip, anaŋ dutumani wo, iŋanen abi lo diau a.” ");
INSERT INTO tbc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus iŋanen megeloum 12 an igiaig siŋiren na dupalug dabai ipidinai a. Ago yan lo iŋ wagen lo ka ur saiak saiak tamolpein ilod lo dukudai diau a. Agod dam ka subam funfun dukubuniai idu wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel 12 an yaŋadi igo ya, imug an Saimon, tamol an yaŋan neinta Pita dubol dan, iŋ tein Andru da. Tinin te Jems iŋ Jon da Sebedi nanun muroun. ");
INSERT INTO tbc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartolomiu, Tomas, Matyu tamolpein sad na moni takis isi dan, Jems Alfeus nanun, agod Tadaeus. ");
INSERT INTO tbc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon neinta iŋ Rom san yu tamol sad ager, agod Judas Iskeriot tamol an murnag Jesus ager tamol banid lo igane yau a. ");
INSERT INTO tbc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus tamol 12 en idinaig ru dufulale wo diau a. Iŋ igo digane wo irupidai a, “Aŋ tamolpein Juda tia yak sad tan lo ta au na wak, agod taun dugon Samaria sadi dam lo ta au na wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tia, sipsip a dideg diau san dumado dan Isrel sad warou lo dilasa yan sad na mi au a. ");
INSERT INTO tbc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Atiliani ator dop igo abol ilasa wa, ‘Anut san kagin panek ipalug sumeik la ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Subam ifu an akubuniai, dumat la yan afufunaip dumasa wa. A tinid lepra amad da yan akubuniaip tinid afon uyan ilasa da wa. Agop ur saiak saiak tamolpein ilod lo yan akudai diau a. Aŋ ŋaisag dabai sen kawan aŋane amaiak niŋen o, tamolpein dam moni tia kawan akubuniai a. ");
INSERT INTO tbc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aŋ moni dam ta asini na wa. Pat naon ibol gol boi ta silva boi ta kopa ago woŋ aŋanem let lo iyuk dan ta asini na wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Au wo dop tureŋ san badam ta asini na wak, madid san kulos taidam ta asini na wak, sendal dam ta aŋane na wak, agod makud dam ta aŋane na wa. Man dugo, a sad na urat agane wo dan anaŋ lo dibinawaŋ san man uyan a. ");
INSERT INTO tbc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Agog saen panu ta boi, tia taun ta boi lo aladu wo dop asumianai a. Ago dop enti tamol uyan an dubol aloŋ gup, aup, tamol an da amado na gup, abisei dap, au a. ");
INSERT INTO tbc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","Agog saen san ab lo aladu wo dop, bar maror san an tamolpein ab an lo dumado dan niŋedi wo agudani gup, aladu wa. Saen tamolpein an ilo uyan lo digiaŋ tap, bar an iŋ da dumado wa. Ak man saen iŋ ta digiaŋ o uyan na tap, bar an apasi aŋane da wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ak gug saen tamolpein abaŋ an ate patud dupanaŋ boi, tia, aŋsam ŋiŋeŋ ta duloŋ na tap, ŋiem fo gufgaf afuni idu gup, ab boi, tia, aben boi, an abiseip au a. ");
INSERT INTO tbc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ŋai ru en rumok geig ŋurupaiaŋ da, saen nal a lo Anut tamolpein ibitinae san ilasa dop, aben an san tamolpein muruan tubun geig ak ipidinai a. Agod iŋaned wadan naon an taun Sodom iŋ Gomora da sad wadan naon an iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aloŋ siŋaokan, nek ibol sipsip iŋ goun kasik luluŋad lo dutor dak igo woŋ, ŋai aŋ ŋidinaŋ pe tan en san tamolpein naod na au o da. Ago yak niŋen o mot igo woŋ abaŋ ale wo uyanan a, gug aŋanem tureŋ lo nek muluk oŋ mos kagin lo mi ator a. ");
INSERT INTO tbc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Tamol niŋedi wo kagin agane wo uyanan a, man dugo, tamol an dusubanaŋ dop diŋiliaŋ pe iŋaned tumanek lo dibitiniaŋ o dugunaŋ a, agod Juda sad ubou ab lo rasau nam dufunaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tamolpein an ŋai niŋeg o dibiaŋ dop diriaŋ oŋ diŋiliaŋ pe tamol gurman iŋ kiŋ da naod na atur a. Ago yan lo iŋ naod na, agod gob fidian naod na dam, aŋanem ilo rumok ŋai o kuai tem ka abol ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aria, saen ager banid lo didiraŋ dop, ru dugo abol man niŋen o ilom ta muruan na wa, ru naok dugo yak arupidai an dam niŋen o ilom ta saian na wa. Man dugo, saen nek an lo ru a arupidai an Anut san Urgun ipanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man dugo, ru a ubol dan oŋsa mi tia ya. Tia, oŋane Bai Anut anen Ur, iŋsen mi oŋ awa lo iŋiŋeŋ da. ");
INSERT INTO tbc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tein ta iŋanen tein ager banid lo iganep dufuni imat a. Taman ta dam nanun muroun lo ago igane wa. Nanuk dam tinan taman patun ipidinaip ai katuk banid lo idiraip dufu dumat a. ");
INSERT INTO tbc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Agod tamolpein fidian ŋai niŋeg o aŋ lo siai digane wa. Ak gug enti a muruan en fidian lo itur sakar oŋ yaup iŋanen wadan idu dop, ŋai talpein an ŋiŋanep patun ŋupasi wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Saen panu ta ante muruan dupano tap, usol pe panu turan ate wau a. Ŋai rumok ŋurupaiaŋ da, aŋ panu fidian Isrel ilon lo yan ate gamugo au itout dop, ŋai, Tamol Nanun, ŋamul ŋupalu wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nanuk maŋau iŋane wo dan, iŋsan girek maŋau ta iriŋani na da. Agod urat tamol dam iŋanen tirnek ta iriŋani na da. ");
INSERT INTO tbc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nanuk a maŋau iŋane dan siganen girek maŋau igo woŋ ilasa tap, an idaisuda ya. Agod urat tamol siganen tirnek igo woŋ ilasa tap, an dam idaisuda ya. Ak dugo, ab muroun iŋ Satan dubol dak ago tap man, sapta taida dop ab muroun an san gugoi lo uf ru dupidinai ak i? ");
INSERT INTO tbc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Amaiak niŋen o aŋ tamolpein naok ago yak niŋedi wo ta arer na wa. Man dugo, mel fidian gamu dufutanig dien dan murnap walal te dilasa wa, agod mel fidian gamu mianuk lo didiraig dien dan dam, murnap Anut iganep id fidian taloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ru tidom tubun lo ŋurupaiaŋ dan, ad lo abol ilasa wa. Agod ru dugo kisikisik lo aloŋ dan, ab fuŋ fufo atur pe awam tubun mi abol ilasa dop fidian duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Agod tamolpein a oŋ tini dufuni imat gug, oŋ ŋutu dufuni imat san ta idaisuda na yan niŋedi wo ta urer na wa. Tia, gidad enti a oŋ tini ŋutu sisem Ades lo daoŋ ka ipidinai san dabai aman da yan niŋen o mi urer a. ");
INSERT INTO tbc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ak dugo, kuseŋ uraru didaeŋ san an sapita yak i? Nek toea kisaek o lian a. Ago bo man, oŋane Bai ilon ago ta yen na tap, kuseŋ an dumat pe tan na dudu san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nek gurma roun san sutek Anut iloŋ pasik a. ");
INSERT INTO tbc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Amaiak niŋen o urer umoi. Anut malan lo oŋane naon lak na geig a, naon an kuseŋ wei mi sad naod iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Talpein ta tamol naod na iŋ ŋaisag ago ibol tap, ŋai dam Tamag kumaen panu na yan naon na ŋatur pe ŋabol ak iŋ ŋaisag a. ");
INSERT INTO tbc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ak man talpein ta tamol naod na iŋ ŋaisag tia yak ago ibol tap, ŋai dam Tamag kumaen panu na yan naon na iŋ ŋaisag tia yak ago ŋabol a. ");
INSERT INTO tbc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kabelan ŋai maror tan en lo ŋigane ilasa san ŋupalu yak ago ilom isou banau. Tia, ŋai muruan ale yau o aŋ luluŋam lo ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Man dugo, ŋai ŋupalu san fun man igo ya, ‘nanuk dimasap tamadi lo siai digane wa, nek ago mi nanudi pein dimasap tinadi lo siai digane wa. Nek ago mi, nanuk pein dam dimasap iraodi lo siai digane wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamol san ager mok man, siganen gugoi ilon lo mi a.’ ");
INSERT INTO tbc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Talpein ta tinan taman niŋedi wo tubun geig imat gug, ŋai o tubun mi ta imat na tap, talpein naok ago man iŋ ŋaisag talpein ilasa san an ta idaisuda na ya. Agod talpein ta nanun muroun niŋedi wo tubun geig imat gug, ŋai o tubun mi ta imat na tap, talpein naok ago yan dam ŋaisag talpein ilasa wo ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Agod talpein siganen aigim fufo imat an isinip ŋieg aban ta iri na tap, iŋ dam ŋaisag talpein ilasa san ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Talpein a siganen madok yabituani dan, madok mok a kumaen panu lo yan banin lo ideg yau a. Ak man talpein ta ŋai niŋeg o siganen madok tan san an banin lo ibisei yau tap, madok yen yau san an iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Talpein enti uyan ipanaŋ tap, ŋai dam uyan ipanag da. Agod iŋ a uyan ipanag dan, a idinag go ŋupalu yan dam uyan ipani da. ");
INSERT INTO tbc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Talpein ta iŋ profet ta iloŋ gug profet an uyan ipani tap, iŋ profet sad urat naon iŋane wa. Nek ago mi, talpein ta iŋ tamol itaot ak ta iloŋ gug, tamol an uyan ipani tap, iŋ dam tamol itaot aman an san naon iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Agod talpein ta nanuk kititik luluŋad lo nanuk kisaek o lian, iŋ ŋaisag megeloum ago iloŋ go, talpein an you bubarum kitek an mi nanuk an ipani tap, ŋai rumok ŋurupaiaŋ da, kulob an san naon iriŋani san tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Saen Jesus iŋanen megeloum ru kagin irupidai itout man, iŋ aben an ibiseig yau a. Yaug aben an san taun gidigidad dien dan lo sad tamolpein ipiteŋanai dop Anut san ru ifulale wo itor se ya. ");
INSERT INTO tbc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aria, saen Jon subanek ab lo imado se man, Kristus urat naok naok igane dan iloŋ, iŋsiganen megeloum aenta idinaig ru disinig Jesus san na diau a. ");
INSERT INTO tbc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ru sinek tamol an Jesus san na dilasag Jon wagen lo ago dubol dusumiani, “Tamol a ipalu san niŋen o maŋ mala nouk mumado dan, oŋ tamol nek amaiak i? Tia, maŋ tamol sen ak ipalu san niŋen o mala nouk mumado wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus iloŋ go ru naon irupidai, “Amul aup mel dugo ale dugo, ru aloŋ na yan dam Jon arupeip iloŋ a: ");
INSERT INTO tbc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","malad itau ak afon abaŋ dile dugo, ŋied saian ak afon tureŋ diabi dugo, a tinid lepra amad da yan tinid siŋaokan dilasa ya. Kududod itau ak ŋiŋeŋ afon duloŋ dugo, a dumat ak kumaen dumasag dumado dugo, agod tamolpein mel amad tia yak bilaluŋ uyanan ak ŋufulale pidinai dugo duloŋ da. ");
INSERT INTO tbc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Agod talpein a ŋai o ilon ta saian na yan, iŋ Anut san bar iŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon san megeloum dumul diau dugo, Jesus Jon niŋen o tamolpein irupidai o fun iganeg igo ibol, “Saen aŋ aben kawan talpein tia yak ate au an, aŋ ata mel mok ale wo au ak i? Nag aŋ tim ifurep war iwi yau imul dop ale wo au boi ak i? ");
INSERT INTO tbc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tia tap, ata wo au ak i? Nag aŋ tamol ta tinin kulos naon lak na geig ak idiri amaiak ale wo au ak i? Tia, tamol a biouŋ naok ago yak didiri duman, iŋ kiŋ sad ab lo mi dumado da. ");
INSERT INTO tbc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ak niŋen o ata mel mok ale wo au ak i? Nag profet ale wo boi i? Awo, agod nek amaiak niŋen o ŋurupaiaŋ da, profet en man rumok iŋ profet a, ak gug urat subaŋan taidam da imado da, ");
INSERT INTO tbc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","tamol nek emaiak niŋen o girek e Anut san ru lo digire idug yen den, igo ibol, ‘Ule, ŋaisag ru sinek tamol ŋidinip, oŋ nao na imug mi yau a. An lo man oŋsa dal ikubune wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ŋai rumok ŋurupaiaŋ da, tamol a pein tiŋaed lo dilasa yan luluŋad lo tamol ta kisaek Jon Suguek san iriŋani man tia ya. Ago bo man, tamol ta Anut san kagin panek aben ilon lo yaŋan aman tia yan, fidian aenta paed na imado dan, iŋ Jon Suguek san an iriŋani a. ");
INSERT INTO tbc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Saen Jon Suguek San kuai te ilasag yaug saen gamu tumado den lo, Anut san kagin panek aben an sen wagai ikubiani na ya, agod tamol wagai san amaiak silei nam aben an diŋane da. ");
INSERT INTO tbc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Man dugo, profet adi agod Moses san Kubiaeŋ dam profet ru lo dubol ilasag yaug saen Jon ilasa yan lo iŋaned urat itout a. ");
INSERT INTO tbc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Agod ŋiŋeŋ e ŋurupaiaŋ en ilom lo rumok o ilom ago yen tap, profet Elaija Anut san buk lo iŋ ipalu wak ru ago ibol an man nek Jon ama ya. ");
INSERT INTO tbc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a. ");
INSERT INTO tbc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Saen en san tamolpein iŋ naok dugo woŋ ak i? Iŋ nek ibol nanuk kititik dadeŋ aben na dumasig dumado dugo nanuk aenta igo dubol digiai da, ");
INSERT INTO tbc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Maŋ aŋ atari wo dum muwi se ya, ak man aŋ ta atari na ya. Agod mateŋ san saen an san bar mabi se ya, gug aŋ ilom saian dugo atata man tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Man dugo, Jon ipalug anaŋ tubun ak ta yani na dugo, you sakar ak dam ta iluk na ya, an niŋen o ago dubol, ‘iŋ ur saiak aman da ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ago dugo Tamol Nanun dam ipalug anaŋ tubun mi yani dugo you sakar dam iluk da, an niŋen o ago dubol, ‘Ale wo, tamol en tuŋalek tamol, agod lukluk tamol, iŋ man takis ŋilaŋal agod aupasek adi dam sad turadi!’ Ak man, kankan a milaen mok amaiak, iŋanen kagin naok naok an lo mi tamolpein malad lo man itaot geig an ago ikubiai pidinai a.” ");
INSERT INTO tbc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Agog Jesus taun ante iŋsan kulob tutubu yak wei mi igane se yan ibubuŋanai o fun igane ya, man dugo, taun an sad tamolpein ilod ta dibili na ya. Agog iŋ igo ibol, ");
INSERT INTO tbc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“O Korasin san tamolpein, muruan tubun geig ale wa; O Betsaida san tamolpein, aŋ dam muruan tubun geig ale wa. Man dugo, kulob girager a ŋai aŋ luluŋam lo ŋigane se amaiak, wagam geig taun Tair agod Saidon dam ante ŋigane wo tap, taun uraru an sad tamolpein ilod ibilsag, muguŋ san kulos didirig, yai san utut fo dumasig dumado ya. ");
INSERT INTO tbc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amaiak niŋen o ŋai aŋ ŋurupaiaŋ da, saen Anut san bitinaek san nal ipalu wan lo, urat naon Anut aŋ ipanaŋ an naon senamo geig a, agod muruan an Tair iŋ Saidon da sad urat naon an iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Agod aŋ Kaperniam tamolpein, sem yaŋam abisap timtaen lo isuda wak i? Tia mok, Anut iŋsen iŋiliaŋ pe au adu dop tan ilon lo aben yaŋan Ades dubol dan lo idiraŋ pe amado wa. Man dugo, kulob girager a ŋai luluŋam lo ŋigane yan taun Sodom ante ago mi ŋigane yak man, gamu taun an yen dop na wa. ");
INSERT INTO tbc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amaiak niŋen o ŋai aŋ ŋurupaiaŋ da, saen Anut san bitinaek nal ipalu wan lo, muruan Anut aŋsam na igane ilasa wo duman, muruan a gubak mi Sodom san aben ante ilasa man iriŋani geig a.” ");
INSERT INTO tbc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saen an lo Jesus ago ibol, “O Bai, oŋ kumaen panu agod tan en dam sad Tubun ak, ŋai oŋ ilo uyan ŋupano wo da, en ata wo? Oŋ melmel en mianaig an lo tamolpein a maŋau amad da yan, agod tamol kankan milaen amad da yak dam melmel en duloŋ san tia geig a. Ak gug tamolpein iŋ nanuk kititik oŋ dumado dan melmel en kubiai pidinaig duloŋ o uyanan a. ");
INSERT INTO tbc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Awo, Bai, oŋane ilobol man nek ago ya, an niŋen o ilo uyan ak lo oŋ ago gane. ");
INSERT INTO tbc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Melmel fidian man ŋaineg Tamag iŋ ŋai tuog lo idiri a. Tamol ta iŋ Anut Nanun ta iloŋ na ya, nek Taman iŋsen mi a. Agod tamol ta iŋ ŋai Tamag ta iloŋ na ya, nek ŋaiseg mi, gug ŋai mi tia ya, tia, tamolpein a ŋaisag ilobol lo mi Tamag ŋukubiai pidinai o yan iŋ dam ka duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aŋ fidian urat dabai geig agane dugo ilom isali dan, agod muruan tubun mi asini dan, ŋaisag na apalu dop, ŋai aŋ tinim yaes ibal uyanan san ŋupanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ŋaisag urat aŋanep paen na sem ibiaŋ adu dop, ŋai lo maŋau aŋane wa. Man dugo, ŋaiseg mi mos kagin lo ŋumado dugo maror ŋumado da. Ago dop aŋ ŋutumi ŋai lo yaes ibal a.” ");
INSERT INTO tbc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Man dugo, ŋaisag urat man muruan an tia ya, agod muruan a ŋupanaŋ dan dam pasauman a. ");
INSERT INTO tbc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Murnag Sabat nal lo Jesus kon abi lo itor se ya. Ago dugo iŋsan megeloum dimatigen, amaiak niŋen o iŋ kon nuŋon aenta dufunig fun diganeg diani a. ");
INSERT INTO tbc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iŋ ago digane dugo Farisi adi dil a, ago tag Jesus durupeig ago dubol, “Ule, urat a Sabat nal lo tigane san niŋen o idsad kubiaeŋ ipadau amaiak, gamu oŋane megeloum adi urat an digane da.” ");
INSERT INTO tbc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ago man Jesus ru naon irupidaig igo ibol, “Nag mel e Dawid igane yen ta asuti na ak i? Iŋ iŋanen turan muroun dida kadag san saen lo anaŋ o dumat go, ");
INSERT INTO tbc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawid Anut san ab lo iladug, bret a Anut naon na didirig dien an isinig, iŋanen yu tamol adi dida diani a. Bret an tamolpein fidian lo geg a, nek Anut san pris mi diani wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nag aŋ ru a Moses san kubiaeŋ lo yen dan ta asuti na i? Sabat nal lo pris adi tempel lo urat diganep, saen an lo kubiaeŋ a Sabat nal niŋen o ibol dan dipilali bo man, muruan amad tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aria, ŋai ŋurupaiaŋ da, tamol ta aŋ luluŋam lo imado dan iŋ tempel iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anut san ru igo ibol, ‘Aŋ ilo uyan apanag san yai agane wan ilog ta ibol na da, tia, aŋ aenta ilom imuŋanai o mi ŋamat da.’ Aria, aŋ ru an san fun mok aloŋ uyan tap man, aŋ tamol e muruan amad tia yan ta abiai dudu na wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Man dugo, Tamol Nanun man iŋsen Sabat nal an san muroun.” ");
INSERT INTO tbc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus aben an ibiseig yaug, taun ta siŋiren na ilasag, iŋsad ubou ab lo iladu ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tamol ta tuon ikikirig ikurŋak yau ak ante imado ya. Ago dugo tamol aenta dal abaŋ dilep lo Jesus ru dupani san niŋen o dusumianig igo dubol, “Ak dugo, idsad kubiaeŋ an iliad funad dop subam tamol ta ka ubou nal lo tukubune wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ago tag Jesus irupidaig ibol, “En dugo, tamol ta aŋ luluŋam lo iŋ sipsip kisaek aman da ya, ak man sipsip an ubou nal lo gib lo idiau a, an niŋen o tamol an iŋanen sipsip ta irae isuda na wak i? Man tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ubou nal lo sipsip tibinawi wo uyanan tap, sapta taida dop id ka ubou nal lo tamol ta tibinawi wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Agog Jesus tamol a tuon ikurŋak an irupei, “Bani wate.” Ago man tamol an banin iwateg foun ikubune dag banin aenta igo mi uyan ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ak man Farisi adi dumasag ubou ab dibiseig Jesus palaŋ an dumari wo diaug dutumani a. Dal dugo man lo Jesus daoŋ dupani san niŋen o diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ak man Jesus kagin dugo digane wo dan iloŋ, an niŋen o aben an ibiseig yau. Ago dugo iŋ tamolpein wei kasik iraug dadi diau se ya, ago dugo a subam amad da yan fidian ikubuniai a. ");
INSERT INTO tbc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nal an lo dam iŋ ru kagin ipidinaig ibol, “Aŋ ŋai enti mok an niŋen o tamolpein ta arupidai na wa.” ");
INSERT INTO tbc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kagin nek amaiak lo, awak aban ta profet Aisaia ibol an nuŋon ilasa ya. Iŋ ago ibol, ");
INSERT INTO tbc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“En man ŋaisag urat tamol, ŋaiseg mi ŋupiliani a, ŋaineg bubeg mok, iŋ niŋen o ilog bulbal da. Ŋai ŋaisag Ur iŋ lo ŋigane wa, agod dop iŋ tamolpein aben fidian lo dumado dan sad na bitinaek Anut san nag ipalu dan niŋen o ibol ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iŋ maeg iganep lo ru ta ikubiai dop iwagiŋ na wa. Taun san dal lo iŋanen awan iwagiŋ den ta duloŋ na wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iŋ war roun dabai an tia yak daoŋ ta ipani na wa, agod luŋ ided oŋ dan ta igane imat na wa. Ago igane yau oŋ dop, nal wadan lo man, tan en san tamolpein kot ipidinai an lo, kagin itaot an imug pe malan te ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Agod tamolpein a tan titin fidian lo dumado dan iŋanen yaŋan niŋen o tini ganei digane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Saen an lo tamol ta iŋ tinin lo ur saiak aman da yan Jesus siŋiren na diŋane dupalu ya. Tamol an iŋ kududon agod malan dam itau a. Jesus ikubineg uyan isusa ya, agog tamol awan itau an ru ibol dugo, malan dam ka abaŋ ile ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","An niŋen o tamolpein fidian durut dugo ago dubol, “Dag tamol en man Dawid Nanun boi i?” ");
INSERT INTO tbc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ak man saen Farisi adi ŋiŋeŋ an duloŋ man ago dubol, “Tia, ur sisaiak sad gurman yaŋan Belsebul tabol damaiak, san dabai lo mi iŋ ur sisaiak ikudai diau da.” ");
INSERT INTO tbc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus iŋsad ilo sou iloŋ dugo irupidaig ibol, “Kiŋ ta san kagin panek aben ilon lo man, iŋsan tamolpein sed itarpaleg malan ururu dilasap nug dufuni tap, kiŋ an san ager iŋsan na yu diŋane dupalup aben an daoŋ dupani wo man pasauman geig a. Agod taun ta boi, tia, warou ta boi, san tamolpein tarpalek uraru dilasap nug dufuni tap, taun an, warou an dam, sed ipitiŋinai dop ririan sad kagin fidian itout yau a. ");
INSERT INTO tbc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Amaiak niŋen o Satan iŋsen mi sen ikudi yau tap, iŋsen lo yu yabisa da. Ago tap, en dugo woŋ pe iŋanen kagin panek aben an dabai yen yau ak i? ");
INSERT INTO tbc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taida mi, ŋai Belsebul tuon lo ur sisaiak ŋukudai diau dak an rumok tap, enti mok aŋ muroumi ibinawaig ur sisaiak dukudai diau dak i? Fun amaiak niŋen o aŋ muroumi iŋsed mi, kubianek tamol oŋ dilasap bitinaek lo didiraŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ak man ŋai Anut san Urgun lo ur sisaiak ŋukudai diau dak ago tap, aŋ gidad aloŋ uyan a, Anut san kagin panek an siŋirem na ipalu la ya. ");
INSERT INTO tbc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Agod fon, en dugo woŋ pe tamol ta tamol dababai geig ak san melmel isini wo san ab lo iladu wak i? Dal ta tia ya. Iŋ gidad imug mi tamol dababai an rasau nam isubani gup, iŋ ka tamol an san ab lo iladup melmel isinip yau a. ");
INSERT INTO tbc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Talpein enti iŋ ŋai ta iganurag na dan, iŋ ŋai patun ipanag da. Agod talpein a ŋai da sisem anaŋ mutumani san urat ta migane na dan, ŋaisag urat iratitale da. ");
INSERT INTO tbc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Amaiak niŋen o ŋurupaiaŋ da, aupasek fidian agod uf ru fidian dam a tamolpein digane dan, Anut aupasek an ka isuas yau pidinai a. Ak gug talpein iŋ Awan Urgun niŋen o uf ru igane tap, aupasek an Anut ta isuas yau na wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","An niŋen o talpein ta iŋ Tamol Nanun niŋen o ru saiak ibol dan, Anut aupasek an ka isuas yau a. Ak gug talpein ta iŋ Awan Urgun niŋen o ru saiak ibol dan, saen e gamu yen den lo, agod saen foun ak a murnap ilasa wan lo dam, Anut talpein an san muruan ta isuas yau na wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Talpein ai uyan ak ipae tap, ai an san nuŋon uyan ak iŋane wa. Gug talpein ai saian ak ipae tap, nuŋon dam saian a. Man dugo, ai nuŋon lo mi ule dop, ai naok dugo yan ka ule uloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aŋ mot wagai ak sad nanud muroudi! En dugo woŋ aŋ saian geig amado yan ru uyan ak ka abol ilasa wak i? Man tia geig a. Man ata wo? Kagin saian ak boi, uyan ak boi, tamol ilon iŋanefute yan iŋanep awan lo ibol ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamol uyan ak iŋ kagin uyan uyan ak tinin ilon lo itumanai an lo, kagin uyan uyan ak mi iŋal dop an idirai dilasa wa. Ak man tamol saian ak iŋ kagin saiak saiak tinin ilon lo itumanai an lo, kagin saian saian ak mi iŋal dop an idirai dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ŋai ŋurupaiaŋ da, Anut tamolpein fidian bitinaek lo idirai san nal lo, tamol Anut naon na itur dop, ru kitek a fidian iŋsinan awan kagin ta ipani na dugo lo gubak mi iŋiŋeŋ se yan, niŋen o iŋ Anut naon na ru an naon ipani wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Man dugo, oŋsigane ru lo mi Anut oŋ tamol uyan ak ibol a, agod oŋsigane ru lo mi oŋ tamol saian ak ibol a.” ");
INSERT INTO tbc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Agog kubiaeŋ san girek maŋau aenta, agod Farisi aenkadi dam Jesus durupei, “Girek maŋau, maŋ iloma igo ya, oŋ gidad kulob girager ta ganep an lo kob igo woŋ oŋ Anut san ak ago kubiai panama wa.” ");
INSERT INTO tbc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ago gug Jesus iŋ ru naon irupidaig ibol, “Nek ibol tamol ta tamol aenta iwodi niŋedi wo ilon imasa dak igo woŋ, tamolpein ensauta a kulob girager dile wo dusumianag dan man, anut sewak aenta niŋedi wo dumat dak igo woŋ, iŋ aupasek tinadi a. An lo kulob girager ta ŋigane panaŋ dop ale san ago ta ŋigane na wa, nek profet Jona san kulob girager amaiak mi a. ");
INSERT INTO tbc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona iŋ adian utol, tidom dam utol, iŋ iy tubun ak tiŋaen lo imado se ya, ago yak niŋen o, nek ago mi Tamol Nanun dam, adian utol tidom utol tan ilon lo imado wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive san tamolpein man aŋ gamu saen en san tamolpein dida Anut san bitinaek nal lo sisem amasap, kot lo atur a. Ago dop Ninive adi aŋ niŋemi wo ru dubol ilasa dop boum dupanaŋ a. Man ata wo? Ninive adi Jona san ru ibol ilasa yan duloŋ go an lo ilod ibilisa ya; ak man tamol ta iŋ Jona iriŋani geig an gamu imado da. ");
INSERT INTO tbc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwin a saut lo ilasa yan man, aŋ gamu saen en san tamolpein dida Anut san bitinaek nal lo sisem amasap, kot lo atur a. Ago dop kwin an aŋ niŋemi wo ru ibol ilasa dop boum ipanaŋ a. Man ata wo? Kwin an iŋ tan asau mok imado bo man, Solomon san kankan milaen amaiak ibol ilasa dop iloŋ o ipalu ya. Ago yak gug tamol ta dam iŋ ente imado da, tamol an man Solomon iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Saen ur saiak ta tamol tinin lo yak dukudip ilasa yau man, aben igosan ak ate gidigidad ila iso wa. Ante aben ta yaes ibal san ile wo abaŋ yabi wa, ak man aben an ta ile na wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ago dop ilon lo ibol, ‘Ŋai gidad ŋamul pe ab gubak mi ate ŋumado amaiak lo ŋau a.’ Iŋ imasap yau ak man, ab an kawan di ilon dam diriani dugo bala dupani la yan ile wa. ");
INSERT INTO tbc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Amaiak niŋen o iŋ imul yaup, ur saiadi geig ak 7 taidam iŋal a. Ur an kulob sisaiak digane san man iŋ diriŋani geig a. Iŋ sisem ab an lo diladup dumado wa. Gubak mi tamol an san madok saian a, ak man gamu gup san madok saian geig a. Kagin nek amaiak tamolpein saiadi a gamu saen en lo dumado dan ilasa pidinai a.” ");
INSERT INTO tbc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Saen Jesus ab lo imado dugo tamolpein dida diŋiŋeŋ se man, iŋsinan tinan iŋ muroun dida dupalug kuai te dutur se ya. Iŋ Jesus da dukubiai o ilod ago yen a. ");
INSERT INTO tbc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tamol ta irupei, “Uloŋ, oŋane tina, tei murou dida akubiai o kuai te dititiano da.” ");
INSERT INTO tbc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ak man Jesus tamol an ru naon irupeig igo ibol, “Enti mok ŋaisag tinag ak i? Agod enti mok ŋaisag teig ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Agog iŋanen megeloum banin nam ikubiaig ibol, “Ŋaisag tinag di teig muroug man nek en mi a. ");
INSERT INTO tbc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Man ata wo, tamolpein ensauta a iŋ ŋai Tamag kumaen panu lo yan ilon duri dupani dan, nek an mi ŋaisag teig, lug di tinag muroug a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nal kisaek an lo mi Jesus ab ibiseig you aen te yaug imasig imado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ak man tamolpein wei kasik dutumanig Jesus dubuluwi a. Ago tag Jesus wog lo isudag wog an kitek isuk ilasa ya. Agog Jesus imasig imado dugo, tamolpein dutumani an loŋ na dutur se ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ante man Jesus ru faŋan lo mel wei kasik niŋedi wo irupidai se ya. Ru ta ago irupidaig ibol, “Saen ta lo tamol ta ai patun isinig abi lo ipae wo yau. ");
INSERT INTO tbc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yaug siŋanen abi lo man ai patun banin igane inawaig tan fufo iratitaleg idu se ya. Saen iratitale man, ai patun aenta dal fufo dudu dugo, anakanak dupalug diani itout a. ");
INSERT INTO tbc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Agog ai patun aenta sagargar fufo dudu ya, tan ante man kuror an tia, ago man milaen tiag ai patun an balud isa ya, man dugo, tan mok an ta kuror na ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ak man saen ad isuda man ai baludi an dukurŋak diau a. Ai an dam dabidi tan lo ta idiau geig na, an lo dugos diau kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ai patun aenta ud saian an luluŋad lo dudu ya, agog sisem disag diau dugo, ud saian an ai uyan ak yafutani an lo nuŋon ta igane na ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ak man ai patun aenta tan uyan ak fufo dudu man nuŋodi digane ya, aenkadi patudi 100 dilasa, aenta 60, aenta 30. ");
INSERT INTO tbc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Agog murnag megeloum Jesus san na dupalug dusumiani, “Oŋ ata wo saen tamolpein maŋau piteŋanai o dop ru faŋan lo ŋiŋeŋ dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus ru naon irupidaig ibol, “Anut iŋsan kagin panek aben san melmel imianuk an san maŋau ipanaŋ a. Ak man iŋ maŋau an ta ipidinai na ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Man dugo, talpein a maŋau anda yak man Anut iŋ subaŋan taidam ipani dop an lo iŋ maŋau idaisuda geig a. Ak man talpein a maŋau aman tia yan, ata maŋau kitekan iŋ lo yen dan, Anut maŋau an iŋsan na ipasi iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ŋai iŋsad na ru faŋan lo ŋiŋiŋeŋ dan san fun man igo ya. ‘Iŋ leil digane bo man, ilod ta itarpasi na da. Kududod nam duloŋ bo man, fun mok ta diŋane na da.’ ");
INSERT INTO tbc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Rumok, iŋ lo profet ru en Aisaia wagam ibol an nuŋon ilasa ya: ‘Saen aŋ ru aloŋ man, ka aloŋ oŋ se ya, ak man san fun ta aŋane na ya, agod saen abaŋ ale man, malami ka yau oŋ se ya, ak man ilom ta itarpasi na ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Man dugo, tamolpein en sad bubedi dabai geig dilasa ya, iŋ kududodi ta duloŋ uyan na ya, agod maladi ikilakil pasi a. Tia tap, maladi nam iŋ ka abaŋ dile wak, kududodi nam ka duloŋ ak, agod ilodi nam maŋau ka diŋane wa. Ago dop an lo ilod ibilisa dop didaŋsap ŋaisag na dupalu dop ŋukubuniai a.’ ");
INSERT INTO tbc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ak man aŋ malami bar diŋane ya, man dugo, malami abaŋ ka ile da, agod aŋ kududomi dam bar diŋane ya, man dugo, kududomi ka iloŋ da. ");
INSERT INTO tbc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ŋai ru rumok ak ŋurupaiaŋ da, imug geig profet adi agod tamol itaot ak wei mi, mel e gamu aŋ ale den dile wo mok dumat se ya, ak man iŋ digane san tia ya. Agod ru e gamu aŋ aloŋ den duloŋ o mok dumat se ya, ak man ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kududom agurep tamol ai patun tan fufo iratitale yak, san ru faŋan san fun mok ŋisafulale wo da. ");
INSERT INTO tbc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ai patun dal te dudu man nek ibol tamolpein Anut san kagin panek aben san ru duloŋ dugo san fun ta diŋane na yak igo woŋ a. An lo Satan ipalup ru a Anut tamolpein ilod lo ipaeg yen dan iŋanep ipasi yau a. ");
INSERT INTO tbc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Agod ai patun sagargar fufo dudu man, nek ibol tamolpein ru duloŋ go ilod rumok kisaek oŋ go, niŋen o ilod uyanan a. ");
INSERT INTO tbc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ak man iŋ dabidi man ta idiaug kuror na ya, ago yan lo sad ilo rumok an ilod lo ta yen milaen na ya. Saen Anut san ru niŋen o muruan sad na ilasa boi, tia, kubianek ipalu tap, iŋaned ilo rumok dibisei kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aria, ai patun ud luluŋad lo dudu man, nek ibol tamolpein ru rumok an duloŋ pe ilod lo rumok kisaek oŋ dak igo ya. Ak man iŋ tan en san madok niŋen o ilo sou gidigidad mi digane da, agod iŋ melmel wei mi amad da wo dumat da, an lo kagin uraru an Anut san ru ilod lo yen dan yafutani da. Ak niŋen o ru amaiak nuŋon aman tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aria, ai patun tan uyanan fufo dudu man, nek ibol tamolpein ru rumok an duloŋ go san fun dam duloŋ siŋaokan ak igo ya. Talpein nek amaiak mi nuŋod ifu mok a, aenta nuŋod 100, aenkadi 60, aenta 30, nuŋodi ago ifu yau a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus afon ru faŋan taida naod na irupidaig igo ibol a, “Anut san kagin panek aben man igo ya. Tamol ta siganen abi lo yaug kon kubulan ipae ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Agod tidom lo saen iŋsan urat tamol dien dugo, san ager tamol ipalug kon ipae yan luluŋad lo ud marasin saiak anda yak dam ipae idug, isol go yau a. ");
INSERT INTO tbc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Agog kon isag nuŋon dam didilan te dilasa ya, ak man, ud an dam luluŋad lo dida disa kisaek a. ");
INSERT INTO tbc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Agog tamol an san urat tamol iŋsan na dilasag durupeig dubol, ‘Gurman, ai patun a oŋ pae yan uyan a. En dugo woŋ go ud dam dida disa kisaek ak i?’ ");
INSERT INTO tbc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iŋsad gurman an ru naon irupidaig ibol, ‘Ŋaisag ager tamol kulob an igane ya.’ Ago tag dusumiani, ‘Ak dugo, maup ud an mubilanai idu wo umat di?’ ");
INSERT INTO tbc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Gug iŋ ibol, ‘Man tia, kabelan aup kon dam abilanai banau. ");
INSERT INTO tbc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Amoi dop urarum ka disa diaup, nuŋod tiŋane san saen ante gup, ŋai urat tamol adi igo ŋurupidai a. Ud an tu kisaek kisaek atem imug mi atumanaip, yai fufo abibol dusudap dinani diau a. Ak gug kon man atumanaip ŋaisag anaŋ ab lo adiri wa.’” ");
INSERT INTO tbc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus ru faŋan taidam naod na igo irupidai, “Anut san kagin panek man igo ya. Tamol ta ai yaŋan mastet dubol dan patun iŋaneg siganen abi lo yaug ipae ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ai patun an sen kawan kititikan a, ak man saen isa yau dop ai tinan igo woŋ ilasa wa. Agop raen dam idirip ibalsarer dop kuseŋ ka ate wur dufuni wa.” ");
INSERT INTO tbc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iŋ ru faŋan taidam irupidaig ibol, “Anut san kagin panek man igo ya. Pein ta yis kabelan iŋaneg plawa tubun geig da itumanig ikubuli kisaek, agog yis an plawa ilon lo ifurak yaug iganeg plawa fidian mi ikafut isuda ya.” ");
INSERT INTO tbc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus melmel an fidian niŋedi wo ru faŋan lo tamolpein dutumani an irupidai a. Iŋ ru itaot ta irupidai se na ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iŋ ago igane yan lo awak aban ta profet ta ibol an nuŋon ilasa ya. “Ŋai awag isupani dop ru faŋan lo mi ŋiŋiŋeŋ a. Melmel mianuk lo dien se yan, tan ilasag ipalug gamu en nek ago mi dien dan, niŋedi wo ŋiŋiŋeŋ dop tamolpein duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Saen Jesus tamolpein dutumani an ibisawaig ab ilon lo iladu man, iŋsan megeloum san na dupalug ago dubol, “Ud a abi lo isa damaiak san fun ubol dop maloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Agog Jesus ru naon irupidaig igo ibol, “Tamol a iŋ ai patun uyan ipae yan, Tamol Nanun naon iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Abi man, tan en naon iŋane ya. Ai patun uyan man, tamolpein ensauta a Anut san kagin panek paen na dumado dan naod iŋane ya. Agod ud saian an man, tamolpein ensauta a Satan nanun muroun amaiak naod iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ager tamol enti ud ipae man Satan iŋsen, agod anaŋ tumanek san saen man, saen gamu lo tumadog ilag san wadan lo amaiak naon iŋane ya. Agod urat tamol enti anaŋ dutumani an man, eŋel adi naod iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nek ibol ud saiak dutumani idup yai fo digansa inani yau dak igo woŋ, saen gamu lo tumadog ilag san wadan lo nek ago mi ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tamol Nanun mitep iŋsan eŋel idiraip dudu wa. Agop iŋ mel fidian tamolpein idiri dop aupasek digane dan dibiai ak, agod tamolpein fidian a sad tureŋ saian an dam dibiaip, dutumanai kisaek pe iŋsan kagin panek aben patun fo diabibol dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Diabibol pe Ades san yai wananan geig an lo dudu wa. Aben ante man tamolpein tinaŋ digane dop madai lo luod dugurmi wa. ");
INSERT INTO tbc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Agog Anut san tamolpein, iŋsad Bai san kagin panek aben lo man, ad ided dak ago woŋ dided a. Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Anut san kagin panek man igo ya. Tamol ta gib yabig mel naod lak na geig ak tan lo imianaig dien na ya. Agog tamol sen ak ta yaug walal ipanig afon ituanai da. Agog yousai lo yaug iŋsan biouŋ fidian moni iŋane wo didaeŋ lo idiri yau a. Biouŋ an san moni iŋaneg tan an muroun san na yaug tan an idad a. ");
INSERT INTO tbc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Anut san kagin panek dam igo ya. Dadeŋ tamol ta koksai siŋaokan ak idad o abaŋ an ile se ya. ");
INSERT INTO tbc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nal ta, koksai siŋaokan geig ak ile, ago tag yaug iŋsan biouŋ fidian didaeŋ lo idirig an lo moni iŋaneg ate koksai an idad a. ");
INSERT INTO tbc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Afon Anut san kagin panek an dam ibol dob oŋ a. Iy ŋilaŋal dob ta beig lo dubal pe iy funfun diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Saen dob an iy lo inawai man, loŋ na dirae isuda wa. Agop iy naok naok atem sensen didiri wo dumasip dumado wa. Iy uyan ak senamo didiri dugo saian ak dam senamo didiri wa. Agop uyan ak iŋaned kulgou lo ditane idu dop, saian ak diabi yau a. ");
INSERT INTO tbc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Saen gamu tumado den san wadan ifutani dop nek ago mi ilasa wa. Eŋel adi dudup tamolpein saiadi ak, uyadi ak da, sensen didirai idu wa. Agop saiadi ak diabibol diau dop ");
INSERT INTO tbc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ades san yai wananan geig ak inanai a. Aben ante man tamolpein tinaŋ digane dop madai lo luod dugurmi wa.” ");
INSERT INTO tbc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Ak dugo, aŋ mel fidian en aloŋ uyanan ak i?” Agog durupei, “Awo, maloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Agog Jesus irupidaig ibol, “Amaiak niŋen o kubiaeŋ san girek maŋau ensauta a Anut san kagin panek niŋen o maŋau diŋane yan man nek igo ya. Ab muroun ta filian aman da yak, iŋ ka siganen biouŋ lo mel ta foun ak, agod wagam ak dam, iragursip tamolpein malad lo kuai te idiri wa.” ");
INSERT INTO tbc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Saen Jesus ru faŋan iŋiŋeŋ itout man aben an ibisei a. ");
INSERT INTO tbc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Agog iŋsiŋanen panu mok lo yaug ubou ab lo maŋau ipiteŋanai se ya. Ak man Nasaret tamolpein saen iŋsan ru duloŋ man durut saian a. Agog dubol, “Tamol en dugon te maŋau iŋane yak i? Agod kulob dababai a igane idu dan san dabai dam dugon te iŋane yak i? ");
INSERT INTO tbc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iŋ man nek kapenta kawan amaiak san nanun, tinan Maria, agod tein moroun Jems, Josef, Saimon agod Judas. ");
INSERT INTO tbc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Agod lun moroun e dida tumado da! Amaiak niŋen o tamol en dugon te mel a fidian igane dan san dabai iŋane yak i?” ");
INSERT INTO tbc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Fun an niŋen o naod ikafut go patud dupani a. Ago gug Jesus irupidaig ibol, “Panu fidian lo tamolpein profet ta yaŋan diabisa wa, nek iŋsiganen panu fun lo, agod iŋsiganen dar lo man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nek an niŋen o aben an lo kulob dabai anda wei mi ta igane na ya, man dugo, iŋ niŋen o ilodi ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saen an lo Herod, provins Galili agod Perea sad tirnek tamol imado se ya. Iŋ tamolpein sad ru Jesus niŋen o dubol dugo iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Agog iŋanen urat tamol irupidaig ibol, “Tamol en man Jon suguek san. Iŋ mateŋ aben lo yak imasa da ya, an lo man dabai tubun geig tinin ilon lo yen dugo lo urat igane da.” ");
INSERT INTO tbc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Imug Herod iŋ Herodias iwon igo iŋane ya, ak man pein an iŋsiganen tein Filip san iwon a. Ak niŋen o Jon suguek san an niŋen o Herod irupeig ibol, “Oŋ Herodias iwo igo woŋ ŋane amaiak niŋen o kubiaeŋ pilali a.” Fun an lo Herod iŋanen ai katuk irupidaig Jon diabig, dusubanig, subanek ab lo digane yau a. ");
INSERT INTO tbc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod ifuni imat o igane se ya, ak man doup adi niŋedi wo irer a. Man dugo, iŋsad ilo sou lo man Jon iŋ profet ago dubol se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ak man saen Herod tinan igansi ak san nal idu yan lo, Herodias nanun pein tamolpein ante yan naod na isaluwai ila iso se ya, an lo man Herod pein baras an niŋen o ilon uyanan a. ");
INSERT INTO tbc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","An lo iŋ ru dabai nam irupeig ata mel niŋen o isumiani dop man, rumok geig ak mel an ka ipani san mi a. ");
INSERT INTO tbc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ago tag yaug tinan, dal dugo ipani wak o isumiani a. Agog imul go Herod irupei, “Gamu geig Jon suguek san an kabuŋan daeg lo ganep sini palup panag a!” ");
INSERT INTO tbc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kiŋ Herod ilon muruan geig a, ak man ru dabai geig pein baras an Herod turan muroun naod na ipani an niŋen o, iŋanen yu tamol irupidaig nek pein an ibol ago mi digane ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ago tag iŋsan yu tamol diaug subanek ab lo Jon buron dutute ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Agog kabuŋan daeg lo disinig Herod san ab lo diaug pein baras an dupani a. Agog pein an afon iŋaneg isini yaug tinan ipani a. ");
INSERT INTO tbc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Agog Jon san megeloum dupalug tinin diŋane diaug disare ya. Agog diaug mel ilasa yan Jesus durupeig iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Saen Jesus Jon san mateŋ iloŋ man, wog fo isudag pasak nam aben ta yoitout yen dak ate yau a. Ak man saen aben a ate Jesus imug imado yak san tamolpein Jesus ibisawai an duloŋ man, iŋaned panu anen anen dibiseig, loŋ na diaug ŋied nam Jesus dirig diau se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Saen Jesus wog ibiseig idu man, tamolpein malan tubun geig ak dititianig dumado dugo yil a. Iŋ ilon ipidinai an lo talpein a subam amad da yak luluŋad lo yan ikubuniai idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ad idu yau dugo iŋsan megeloum dupalug durupeig dubol, “Aben en yoitout a, agod ad dam idu yau da, amaiak niŋen o oŋ tamolpein dinaip panu na diaup, anaŋ didad pe diani wa.” ");
INSERT INTO tbc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Agog Jesus ibol, “Gidad, aben en dibisei dumoi, aŋsem mi anaŋ ta apidinaip diani wa.” ");
INSERT INTO tbc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ago gug iŋ Jesus durupeig dubol, “Maŋ etna bret faiv o lian a, agod iy dam uraru o lian a!” ");
INSERT INTO tbc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Agog iŋ ibol, “Igo asini apalu wa.” ");
INSERT INTO tbc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Agog tamolpein dutumani an irupidai, “Ago gafurfur fo amasi.” Agog bret faiv iŋ iy uraru da yan isinig, malan keit lo isudag, bret iy da bar ipanig yafute idu se ya. Agog anaŋ an megeloum ipidinaig diaug tamolpein dupidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Fidian diani man luadi ipuk a. Diani itout man megeloum diaug samsamun disini wo ditiliani se ya. Samsamun disini an sareg 12 tutubu yak digane inawai a. ");
INSERT INTO tbc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tamol mi faiv tausen anaŋ an diani a, taida mi pein wei mi, nanud muroudi dida anaŋ an dam diani a. ");
INSERT INTO tbc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Saen anaŋ dianig itout man Jesus iŋanen megeloum wog fo dusudap aen ate imug diau wo irupidai a. Ago dugo iŋ kitekan ka imado dugo, tamolpein siganed ab lo dumul diau wo irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Saen tamolpein idinaig diau pasik man, iŋ sen mi did fo Taman san na igudani wo isuda ya. Agog saen ad idu yau man sen kisaek did fufo imado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Saen an lo wog man you titiŋaem yen se ya. Agog tim ifure dugo you dam imasa man wog ifuni ila iso se ya, man dugo tim naon na yen se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Salso idug abaŋ ipasti yau dugo, Jesus iŋanen megeloum sad na you fufo yau se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ak man saen iŋanen megeloum ago dile man direr dudug dubol, “An man tamol ŋutun a!” Agog disasai dugo disuruwor se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Agog Jesus irupidai kisaek oŋ go ibol, “Dabai aŋane! Ŋaiseg o, asuruwor amoi!” ");
INSERT INTO tbc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Agog Pita ru naon irupeig ibol, “O Tubun en, oŋse mok tap, ubol dop ŋai dam you fufo oŋsa na ŋupalu wa.” ");
INSERT INTO tbc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Agog Jesus ibol, “Palu!” An lo man Pita imasag wog lo yak ilasag fun iganeg you fufo mi yau se ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ak man malan yaug tim tubun ak ifure dugo ile man irer saian geig a. Agog fun iganeg you lo isarir idiau dugo iwagiŋ, “Tubun en, binawag!” ");
INSERT INTO tbc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesus banin iwate kisaek oŋ go yabi dugo isumiani, “Oŋ tamol ilo rumok ama kabelan, ata wo ilo weiwei ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Saen uraru an wog fo dusuda man, tim ifure yan itout kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Agog iŋsan megeloum turud disaluwig ubou an dile dugo dubol, “Rumok geig, oŋ Anut Nanun mok a!” ");
INSERT INTO tbc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Saen you dututeg tan yaŋan Genesaret dubol dak ate disasau man dusuda ya. ");
INSERT INTO tbc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tamolpein ante Jesus naon dile da man, ru diganeg panu tan ante yan fidian sad na yau dugo, tamolpein subam amad da yak Jesus san na diŋal dupalu wo dubol a. ");
INSERT INTO tbc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tamolpein subam ifu dan Jesus dusumiani dop iŋsan kulos bitiŋen an mi ka dusupuri wa. Ago dugo fidian a dusupuri an uyad isusa da ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Agog Farisi iŋ kubiaeŋ san girek maŋau da Jerusalem dibiseig Jesus san na diaug dusumianig igo dubol, ");
INSERT INTO tbc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“En ata wo oŋsa megeloum adi idsad tubud baged sad tamol kagin digansi an ta diri na dak i? Iŋ banidi ta dufulani na gup anaŋ diani da.” ");
INSERT INTO tbc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ago tag Jesus ru naon irupidaig igo ibol, “Ata wo aŋ siganem tamol kagin ari apani wo Anut san ru kubiaeŋ patum apani dak i? ");
INSERT INTO tbc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Man dugo, wagam mi Anut ru kubiaeŋ en igansi, ‘Oŋane tina tama awad paen na mado dop kagin pidinai o uyan a.’ Agod Anut ru kubiaeŋ en taidam ibol, ‘Ta iŋ awan nam tinan taman saian ipidinai tap man, mateŋ ile wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ak man aŋ abol, ‘Tamol ta taman boi, tinan boi, ka igo irupei, mel ta ate ŋai ka ŋibinawo san man, ŋai mel an Anut ŋupani san ŋien ŋupani la ya. O kabel, an niŋen o ŋai mel an ŋupanaŋ san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tamol an ago ibol tap, ru kubiaeŋ a iŋ tinan taman kagin ipidinai o ago ibol an man, nuŋon an tia ya.’ Ago man aŋanem tamol kagin ari apani dan lo Anut anen ru nuŋon tia agane ilasa da. ");
INSERT INTO tbc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aŋ balem rararu a! Profet ru a Aisaia gubak mi aŋ niŋemi wo ibol ilasa yan rumok geig a. Iŋ igo ibol, ");
INSERT INTO tbc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tamolpein en awadi nam yaŋag diabisa da, ak man bubedi man asau geig yen da. ");
INSERT INTO tbc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iŋ sen kawan ŋai ubou amag dile da, man dugo, piteŋanek a tamolpein durupidai dan man nek tamol siganed ilo sou mi a.’” ");
INSERT INTO tbc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Agog Jesus tamolpein iŋsan na dutumani wo igiai a. Dupalu dugo irupidaig ibol, “En aloŋ dop aŋane o uyanan a! ");
INSERT INTO tbc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Anaŋ a tamol awan ilon lo iladu dan, ilon ta nun igane na da. Tia, mel a tamol awan lo ilasad amaiak ilon nun ipani da.” ");
INSERT INTO tbc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Agog iŋanen megeloum adi siŋiren na dupalug durupei, “Ak dugo, saen Farisi adi ŋiŋeŋ an duloŋ man, oŋ niŋe wo ilod saian an uloŋ ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus Farisi adi niŋedi wo ru naon megeloum irupidaig igo ibol, “Ai fidian ŋai Tamag tan lo ta ipae na yan, ibilani yau a. ");
INSERT INTO tbc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Abisawai, iŋ man unbek malad itapul ak igo ya. Aria, tamol ta malan itapul aman ak, turan ta dam malan itapul ak, dal ikubiai pani wo banin te yabi tap man, tamol uraru an dog lo diau dudu wa.” ");
INSERT INTO tbc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ak man Pita irupeig ibol, “Ru mitilaen a rupidai an fun fulale dop maloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Agog Jesus ibol, “Aŋ dam nag maŋau lo katuk am mi ak i? ");
INSERT INTO tbc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aŋ ta aloŋ o uyan na yak i? Mel a tamol awan lo iladu dan anaŋ mi a, agop tiŋaen lo dam iladup dibei san dal lo yaup tinin patun fo yak ate ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ak man mel ta awan lo ilasa man senamo geig a, man dugo, an ŋutun lo ilasa da, agod mel amaiak mi tamol ilon nun ipani da. ");
INSERT INTO tbc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Man ata wo? Kagin naok naok igo yan tamolpein sad ŋutud lo ilasa da: ilo sou saian ak san kagin, tamol ifuni imat dak, turan iwon ida dien dak, jeit kagin, gumagam kagin, supalek ru agod uf ru dam mi a. ");
INSERT INTO tbc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mel naok amaiak tamol nun ipani wa. Ak man tamol banin ta ifulani na gup anaŋ yani dan, nun ta ipani na wa.” ");
INSERT INTO tbc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Agog Jesus aben an ibiseig gob adi sad tan ate yaug, Taia iŋ Saidon da sad distrik lo itilianig itor se ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aria, gob pein ta tan Kenan dubol dan ate imado dan isusag awan tubun ak lo iwagiŋ, “O Tubun ak, Dawid Nanun, ilo imuŋanag! Ur saian ta ŋai nanug pein itirni dugo muruan ipani geig da.” ");
INSERT INTO tbc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ak man Jesus ru naon ta irupei na ya. Agog iŋsan megeloum siŋiren na dupalug dubol, “Oŋ pein an peip sen ilasa, man dugo, iŋ maŋ irama dugo mibinawi wo igiama da.” ");
INSERT INTO tbc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iŋ ru naon irupidai, “Anut ŋai Isrel san sipsip dideg diaud amaiak mi ŋibinawai o idinag a.” ");
INSERT INTO tbc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ak man pein an siŋiren na ipalug turun isaluwig irupei, “O Tubun ak, binawag!” ");
INSERT INTO tbc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iŋ ru naon irupeig igo ibol, “Ŋai nanuk sad anaŋ ŋiŋanep goun diani wo ŋabi yau tap, an ta uyan na wa.” ");
INSERT INTO tbc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pein an ibol, “Awo, Tubun en ru rumok ubol da. Ak gug goun dam iŋaned muroudi sad awad aban tan na idu man ka diani wa.” ");
INSERT INTO tbc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Agog Jesus ru naon irupeig ibol, “O pein, oŋane ilo rumok an tubun geig a! Nek oŋ ilo yen dak ago mi oŋ lo ilasa wa.” Ago ibol dugo pein an nanun pein uyan isusa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Agog Jesus aben an ibiseig You Galili aen irig yau se ya. Agog yaug bubun ta fo isudag ante imasig imado ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ago dugo tumanek malan tubun ak iŋsan na dupalu se ya. Tamolpein ŋied ikael ak, a malad itapul ak, a banid ikael ak, a awad itau ak, agod aenta dam wei mi diŋal go dida dupalu se ya. Agog Jesus ŋien fun na didiraig tinid ikubune dugo uyad isusa da ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","An lo tamolpein dutumani an, saen tamolpein awad itau ak diŋiŋeŋ dugo, a ŋied ikael ak uyad isusa dugo, a ŋied ikikai ak ditiliani ditor dugo, agod a malad itapul ak afon abaŋ dile da dugo dil man, durut saian geig a. Ago dugo Isrel sad Anut yaŋan diabisa ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Agog Jesus iŋsan megeloum san na dupalu wo igiai a. Dupalug irupidaig ibol, “Ŋai tamolpein malan tubun en ilog imuŋanai da, man dugo, gamu nal utol yau la dugo iŋ ŋai dida mumado ya, ak gug anaŋ ta diani san etna tia ya. Ak man dimatigen dop ŋidinaip diau man, ilog ta ibol na da, kabelan dal na yaes ifu dop malad itiliani banau.” ");
INSERT INTO tbc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Agog iŋanen megeloum durupeig dubol, “Maŋ dugon te anaŋ mile dop miŋanep lo tumanek tubun geig en ka mufutuwai ak i? Aben en yoitout a.” ");
INSERT INTO tbc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus isumianai, “Aŋ bret sapita yak i?” Iŋ dubol, “Bret seven dien da, agod iy kititik kisaek kisaek a.” ");
INSERT INTO tbc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Agog iŋ tamolpein tan na dumasi wo irupidai dugo ");
INSERT INTO tbc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bret seven iŋ iy da iŋaneg, Anut ilo uyan ipani gug yafuteg iŋanen megeloum ipidinaig, diaug tamolpein duwae pidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Fidian anaŋ an dianig luad ipuk. Diani itout go megeloum dumasag anaŋ samsamun dutumanig sareg seven lo ditaneg awad isa ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tamolpein ensauta a anaŋ diani an sad sutek man tamol 4 tausen, agod pein nanuk man ta dusutai na ya. ");
INSERT INTO tbc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus tamolpein siganed panu anen anen atem diau wo irupidaig, wog lo megeloum dida dusudag, panu Magadan san tan tilianek lo diau a. ");
INSERT INTO tbc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi adi Sadyusi dida Jesus san na dupalug dusubani wo bitinaek lo digane ya. Iŋ Anut san dabai nam kulob girager ta kob igo woŋ igane dop dile wo dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iŋ ru naon irupidaig igo ibol, “Saen ad idu yau dop aŋ abol, ‘Gabulo dop malin ibalsi wa,’ man dugo, timtaen daran da. ");
INSERT INTO tbc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Agod tidom lo mi dop abol, ‘Gamu ui isi wa,’ man dugo, timtaen daran an bilkas ak ituani a. Aŋ ka keit san leil akubiani ale uyanan mok a, ak man aŋ kulob sensen a aŋsiganem saen lo dilasa la yan, sad fud mok akubiani ale san aŋ ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nek ibol tamol ta tamol aenta iwodi niŋedi wo ilon imasa dak igo woŋ, tamolpein ensauta a kulob girager dile wo dusumianag dan man, anut sewak aenta niŋedi wo dumat dak igo woŋ, iŋ aupasek tinadi a. An lo kulob girager ta ŋigane panaŋ dop ale san ago ta ŋigane na wa, nek Jona san kulob girager amaiak mi a.” ");
INSERT INTO tbc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","You tilianek dututeg you aen ate diaug disasau man, iŋanen megeloum bret ta disini na yan ilod isou a. ");
INSERT INTO tbc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Agog Jesus irupidai, “Kagin agane wa, Farisi iŋ Sadyusi da sad yis an niŋen o kagin agane wo uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Agog fun diganeg ilod lo mi diŋiŋeŋ yau imul se ya. “Ago ibol man fun dugo i? Nag id bret ta tisini na, amaiak niŋen o ago ibol boi.” ");
INSERT INTO tbc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus dugo dubol se man iloŋ, ago tag isumianai, “O aŋ tamol ilo rumok kabelan geig amam da ya, ata wo bret tia yan niŋen o aŋiŋeŋ dak i? ");
INSERT INTO tbc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aŋ an ta aloŋ uyan na di? Saen ŋai bret faiv ŋafuteg ate tamol faiv tausen ŋufutuwai an ilom iŋaoŋ ak i? Agod aŋ sareg sapta awad agane inawai an dam ilom ta isou na i? ");
INSERT INTO tbc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tia, bret seven nam tamol 4 tausen ŋufutuwai, agod sareg sapita awad agane inawai an dam ilom iŋaoŋ ak i? ");
INSERT INTO tbc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","En dugo woŋ go ŋai bret niŋen o ta ŋiŋiŋen na yan, ta aloŋ siŋaokan na yak i? Aria, afon kududom agurep kagin agane: Farisi iŋ Sadyusi da sad yis niŋen o sen alasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Agog iŋanen megeloum duloŋ ak iŋ yis bret ate digane dan niŋen o ru kagin ta ipidinai se na ya. Tia, piteŋanek a Farisi iŋ Sadyusi da tamolpein durupidaid amaiak niŋen o ru kagin ipidinai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Saen Jesus iŋanen megeloum dida distrik a taun Sisaria Filipai siŋiren na yen dan te dilasa man, igo isumianai, “Tamol Nanun en enti mok ak i? Tamolpein iŋ niŋen o ru dugo dubol dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Agog dubol, “Aenkadi oŋ Jon suguek san ago dubol dugo, aenta oŋ Elaija dubol dugo, aenta oŋ dag Jeremaia boi, tia, oŋ profet ta a wagam dumado na yan luluŋad lo fon lasa boi ago dubol da.” ");
INSERT INTO tbc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Agog Jesus isumianai, “Ak man aŋsem mi ŋai enti mok abol di?” ");
INSERT INTO tbc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Agog Saimon Pita iŋsan ru naon irupei, “Oŋ Kristus, oŋ Anut ipiliano ama ya, oŋ Anut a kumaen imado dan Nanun mok a.” ");
INSERT INTO tbc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus ru naon irupeig igo ibol, “Saimon, Jon nanun, oŋ bar ama da, man dugo maŋau an tamol ta, ta ifulale dugo uloŋ na ya, tia, maŋau an itaot ŋai Tamag kumaen panu lo yan san na ilasa dugo ubol ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Agod ŋai ŋurupaio da, oŋ Pita, yaŋa san fun man pat. Pat tubun en fufo ŋaisag midaeŋ ŋususe wa. Agod mateŋ san dabai an ŋaineg midaeŋ ibiai dudu san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ŋai Anut san kagin panek aben san ki ŋupano wa, agod ata mel tan en lo futani tap, kumaen panu na dam itau a, agod ata mel tan en lo pasi tap, kumaen panu na dam awan ipasi a.” ");
INSERT INTO tbc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Agog Jesus iŋanen megeloum adi ru kubiaeŋ dabai mok an ipidinai man, iŋsen mi Kristus, an ago ta dubol ilasa na wa. ");
INSERT INTO tbc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Saen an lo yau man Jesus iŋanen megeloum adi kuai tem irupidai se ya, iŋ Jerusalem na yaup ante dop Juda sad matu gurman adi, pris gurman adi, agod kubiaeŋ san girek maŋau adi saian dupani dop madai wei mi ile na gup dufuni imat a. Agop murnap nal utol lo Anut ifufunip kumaen imasa da wa. ");
INSERT INTO tbc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ago ibol go Pita Jesus yabig iŋaneg ida gigin na diaug san ru an niŋen o igo ibol, “Tubun en, tia geig a, kulob ago oŋ lo ta ilasa na wa!” ");
INSERT INTO tbc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Agog Jesus idaŋsag irupei, “Satan, ŋai patug fo sen lasa! Oŋ ŋai naog dal fou da, man dugo, ilo sou uri dan man Anut san tia ya, an man tamol san mi a.” ");
INSERT INTO tbc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Agog Jesus iŋanen megeloum irupidaig ibol, “Talpein ta ŋai ŋieg aban iri wo imat tap, gidad iŋsan mel an fidian ilon iŋaoŋ pe iŋsiganen aigim isinip ŋieg aban mi iri wa. ");
INSERT INTO tbc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Man ata wo? Talpein enti siganen madok kagin mi yabi sakar tap, iŋanen madok murna san an ibisei wa. Ak gug talpein enti ŋai niŋeg o siganen madok kagin ibisei tap, iŋsiganen madok mok an ile dop iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Talpein ta tan en san madok lo malan imug dop, an lo tan en san filian fidian an san muroun ilasa wak gug, ŋutun ideg yau tap, nuŋon uyan ak dugo woŋ igane ilasa wak i? Man tia geig a. Tia, mel dugo man, talpein ta Anut ipanip, an lo siganen ŋutun an idad iŋane dop daoŋ ta ile na wak i? ");
INSERT INTO tbc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Man dugo, Tamol Nanun mitep Taman san girager an lo ipalu dop, iŋanen eŋel adi dida dudu wa. Agop talpein fidian iŋaned urat dugo dugo digane na yan naon ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rumok ŋurupaiaŋ da, tamolpein aenta igo dutur dan gamugo dumat dop, Tamol Nanun amaiak Kiŋ igo woŋ ipalu dop dile gup, murnap dumat a.” ");
INSERT INTO tbc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nal siks itout go, Jesus iŋ Pita, Jems agod tein Jon da iŋal go imug did lak na geig ak fo disudag ate iŋsed mi dumado ya. ");
INSERT INTO tbc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Agog ante Jesus tinin ibilisa dugo dile ya. Iŋsan naon man ad oŋ ided se ya, agod san biouŋ tinin fo man ibilisag lilaman oŋ milkouk geig ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ago dugo Moses iŋ Elaija da megeloum naod na dilasag Jesus da diŋiŋeŋ dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Agog Pita imasa kisaek oŋ go Jesus irupeig ibol, “Tubun en, nek uyanan geig maŋ ente mumado da! Oŋ ilo ibol tap, lalai utol etna ŋabi wa, oŋsa kisaek, Mosen san kisaek, agod Elaijah san kisaek dam ŋususe wa.” ");
INSERT INTO tbc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Saen iŋiŋeŋ se man timtaen ta ided dak ipalug, ibuluwai dugo, ŋiŋeŋ ta timtaen an ilon lo yak ibol, “En man ŋaineg Nanug mok, ŋaineg bubeg mok, iŋ niŋen o ŋai ilog tubun mi uyanan da. Awan aloŋ!” ");
INSERT INTO tbc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Saen megeloum utol an ŋiŋeŋ an duloŋ man, tubun mok direr go naodi tan fo ditakok dudug dumunamig dien se ya. ");
INSERT INTO tbc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ak man Jesus sad na ipalug isupuraig ibol, “Amasa, arer amoi.” ");
INSERT INTO tbc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Saen dufotsa man, tamol ta dile man tia ya, nek Jesus sen kisaek mi dile ya. ");
INSERT INTO tbc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Saen did dibiseig dudu se man, Jesus ru dabai anda irupidaig ibol, “Mel gamu ale yan niŋen o aup tamolpein ta arupidai na wa, abol amoi dop Tamol Nanun mateŋ aben lo Taman ipasi iŋane gup abol a.” ");
INSERT INTO tbc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Agog iŋanen megeloum utol dusumianig dubol, “En ata wo kubiaeŋ san girek maŋau, Elaija imug ipalu dop Kristus murna ilasa wak ago dubol dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus ru naon irupidai, “Rumok, Elaija imug ipalu dop mel fidian ikubuniaip uyad dususa da wa. ");
INSERT INTO tbc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ak man ŋai ŋurupaiaŋ da, Elaija imug ipalu la ya. Iŋ bo ilasa gug tamolpein iŋ ta dile duloŋ na ya. Ago dugo iŋsiganed ilobol lo mi saian dupani se ya. Nek dal kisaek an lo mi iŋ Tamol Nanun dam saian dupani wa.” ");
INSERT INTO tbc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Agog iŋanen megeloum duloŋ ak Jesus Elaija mok niŋen ta ibol na ya, tia, Jon suguek san amaiak niŋen o ibol na ya. ");
INSERT INTO tbc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Saen dumul go tamolpein a dutumanig dumado se yan sad na dupalu man, tamol ta Jesus san na ipalug naon na turun isaluwig ibol, ");
INSERT INTO tbc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“O Tubun ak, ŋaineg nanug ilo imuŋani! Saen wei mok kurbarib ifunig an lo madai tubun geig ile da. Saen aenta ilon iŋaoŋ dop yai lo idu dak, saen aenta dam you lo idu da. ");
INSERT INTO tbc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ak niŋen o oŋane megeloum sad na ŋiŋane ŋupalu yak man dukubune wo digane yak gug tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus ru naon irupeig ibol, “Aŋ saen en san tamolpein man ilo rumok amam tia ya, agod ilom gidigidad aman a. Nal sapta ŋai aŋ da tumado wak i? Nal sapta muruan a apanag yau an ŋisini wak i? Nanuk an igo aŋane apalu.” ");
INSERT INTO tbc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Agog Jesus iŋ ur saian nanuk ilon lo yan ru dabai aman da nam ipei dugo, ur saian an nanuk ibiseig uyan isusa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Murna gug megeloum adi pasak nam Jesus san na dupalug dusumiani, “En ata wo maŋ ur saian an mukudi san tia yak i?” ");
INSERT INTO tbc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iŋ ru naon igo irupidai, “Man dugo, aŋ ilo rumok kabelan mok amam da ya. Ŋai ru rumok ŋurupaiaŋ da, gidad oŋane ilo rumok nek ibol ai patun tusan igo woŋ tap, did en rupeip ubol, usuk onte wau, ago ubol dop yau a. Mel fidian oŋ gane san tia yan ka gane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Saen Jesus iŋanen megeloum adi dida Galili na tureŋ diabi se man, irupidaig ibol, “Tamol Nanun iŋ ager tamol banid lo digane yau o da. ");
INSERT INTO tbc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Agop dufuni imat a. Murnap nal utol itout gup, Anut ifufunip kumaen imasa da wa.” Iŋanen megeloum ago duloŋ man, tubun mi ilod itau idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Saen Jesus iŋanen megeloum dida Kaperniam na dupalu man, tempel san takis ŋilaŋal dupalug Pita dusumiani, “Dugo, oŋane girek maŋau tempel san takis idad o dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ru naon igo irupidai, “Awo.” Murnag Pita ab ilon lo ipalu dugo Jesus imug iŋiŋeŋ, “Saimon, tan en sad kiŋ, enti sad na takis moni diŋane dak i? Iŋsiganed nanud muroudi sad na, tia, tamolpein gol ak sad na, aria, oŋsa ilo sou dugo yak i?” ");
INSERT INTO tbc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Agog Pita ibol, “Tamol gol ak sad na ya.” Ago ibol man Jesus irupei, “Ago tap nanud muroudi sad na takis moni ta digane na da. ");
INSERT INTO tbc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ak man gidad ilodi ta tigane saian na wa. Ago yak niŋen o you lo waup oul ubal idu. Iy malmalan wane dan rae isudap, awan pasi dop moni ate yen dan ŋane. Moni an nek idaisuda ya, oŋse niŋe wo, agod ŋai ŋutug dam, ate tempel san takis udad a.” ");
INSERT INTO tbc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Saen an lo megeloum adi Jesus san na dupalug dusumiani, “Enti Anut san kagin panek aben lo yaŋan malan te yak i?” ");
INSERT INTO tbc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Agog Jesus nanuk ta iwagig megeloum naod na igunig itur dugo ");
INSERT INTO tbc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","irupidaig ibol, “Ŋai rumok geig ŋurupaiaŋ da, aŋ gidad sem ibilaŋsap nanuk en igo woŋ alasa. Tia tap, Anut san kagin panek aben an lo aladu san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Amaiak niŋen o talpein enti sen yabi idup nanuk en igo woŋ ilasa dan, nek talpein amaiak Anut san kagin panek aben lo yaŋan malan te ya. ");
INSERT INTO tbc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Talpein enti ŋai yaŋag lo nanuk igo yan iŋane wo iyuŋani tap, ŋai dam iŋiliag o iyuŋanag da. ");
INSERT INTO tbc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ak man nanuk ta ŋai o ilon rumok dan, talpein ta iganep aupasek lo idu tap, talpein an gidad kagin igane wa. Man dugo, pat tinan buron lo disisi idup beig lo dibal pe isarir o man bo, uyan mok a. Man ata wo? An tia tap, ai wadan ŋupani san man iriŋani geig a! ");
INSERT INTO tbc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Tan en san tamolpein ensauta a mel ta lo ilo rumok adi aupasek lo dudu wo dududuwai dan, naon muruan tubun geig ak diŋane wa! Rumok, melmel ta tamolpein ilod diŋanep lo au dupas dan, dilasa san dal tufutani san tia ya. Ak man talpein enti ilo ŋanek an igane ilasa dan, naon saian geig ak iŋane wa! ");
INSERT INTO tbc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Amaiak niŋen o oŋ bani boi, tia, ŋie boi, iganep aupasek lo udu tap, tutep wabi yau! Gidad ŋie bani tia man ago madok yen yau san lo ladu man ta saian na ya, man dugo, kabelan ŋie bani ama da yak ago diŋilio dop yai pempem ided dan lo dubulo wau banau. ");
INSERT INTO tbc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Agod oŋ mala iganep au upas tap, mala an bilanip biliau a. Gidad mala kisaek o lian da ago madok yen yau san lo ka ladu wa. Kabelan mala uraru mi dop diŋiliop Ades san yai lo dubulo wau banau. ");
INSERT INTO tbc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Aŋ gidad nanuk kititik aŋanem leil lo yaŋad tia yak ago ilom ta isou na wa. Man dugo, ŋai ŋurupaiaŋ da, iŋaned eŋel kumaen panu lo yan maladi pempem yau dop ŋaineg Tamag kumaen panu lo imado dan naon dile da. ");
INSERT INTO tbc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Aŋanem ilo sou dugo yak i? Sipsip muroun iŋanen sipsip 100 dida ditiliani da, ak man kisaek man naon tia ya. Sipsip muroun an dugo igane wak i? Iŋ sipsip 99 an ibisawaip, did luan te gafurfur dianid dumado dop yaup kisaek an abaŋ an ile wa. ");
INSERT INTO tbc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sipsip naon tia yan ile tap, 99 a dumado dan niŋedi wo ilon ta tubun mi uyan na wa. Tia, kisaek a naon tiag fon iŋaneg imul da yan niŋen o man ilon tubun geig uyanan a. ");
INSERT INTO tbc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nek dal kisaek an lo mi, aŋanem Tamami kumaen panu na yan, nanuk kititik igo yan naod tiap dideg diau o ilon ago ta yen na da.” ");
INSERT INTO tbc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Saen Kris tei ta oŋ lo aupasek igane tap, san na waup iŋsan aupasek an kibiai ile. Ak man nuŋom uraru mi nug lo aŋiŋeŋ a. Aria, oŋ awa iloŋ tap man, oŋ oŋane tei da ilom kisaek da wa. ");
INSERT INTO tbc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ak man awa ta iloŋ na tap, tamol kisaek boi, uraru boi, uŋal pe dida aup oŋane tei da aŋiŋeŋ a. Dal an lo ru fidian a sisem abol dan, talpein nuŋod uraru an ka dibinawo wa. ");
INSERT INTO tbc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aria, iŋ oŋane tei uraru an awad ta iloŋ na tap, muruan an gidad Kris midaeŋ naod na abol ilasa wa. Aria, Kris midaeŋ dam sad ru ta iloŋ na tap, tamol an gob igo woŋ, tia, takis ŋilaŋal tamol igo woŋ, ago ale dop abiseip asau mi au. ");
INSERT INTO tbc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ŋai ru rumok ŋurupaiaŋ da, aŋ mel ta tan na yak afutani tap, kumaen panu na dam itau a, agod mel ta tan en lo apasi tap, kumaen panu na dam ipasi panaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Agod afon ŋurupaiaŋ da, saen aŋ nuŋom uraru mel ta niŋen o kabuŋam kisaek go agudani tap, ŋai Tamag kumaen panu na yan mel an igane panaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Man dugo, aben ta ate talpein uraru boi, utol boi, ŋai yaŋag lo dutumani dan, ŋai iŋ dida mumado da.” ");
INSERT INTO tbc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Agog Pita Jesus san na ipalug isumiani, “O Tubun ak, saen ŋai teig ta ŋaisag na mi aupasek igane tap, saen sapta mok iŋsan aupasek ŋupare idu pani wak i? Dag sutek yaug 7 boi i?” ");
INSERT INTO tbc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus irupei, “Saen 7 man tia ya, tia, ŋai ŋurupaio da, saen 70 an seven taida batep, nek ago yen yau a. ");
INSERT INTO tbc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Amaiak niŋen o Anut san kagin panek man igo ya. Kiŋ ta gubun funfun a iŋsan urat tamol tinidi lo dien dan ikubunep itout o ilon ibol se ya. ");
INSERT INTO tbc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Saen iŋsad pani naon iŋane san urat an fun igane dugo, urat tamol kisaek diŋaneg san na dupalu ya. Kiŋ san gubun tamol an tinin lo yen dan man ten milion kina ago ya. ");
INSERT INTO tbc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ak man urat tamol an iŋsan gubun an isopasi san ta idaisuda na ya. Ago tag kiŋ iŋanen urat tamol aenta irupidaig ibol, ‘urat tamol an bigabeg oŋ didaeŋ lo agane dop, tamol ta idad a. Iŋanen iwon, nanun muroun, agod sad melmel fidian dam nek ago mi agane wa. An lo dop san naon an ŋiŋanep ate iŋsan gubun ka ŋusopasi wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Urat tamol an kiŋ naon na turun isoluwi idug ibol, ‘O Tubun ak, gidad bube panag dop oŋane gubun an fidian ŋusopasi wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Agog kiŋ ilon imuŋanig san gubun an isopasig iganeg yau a. ");
INSERT INTO tbc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Agog urat tamol an ilasag yau man, tamol ta iŋsan urat kisaek gubak mi iŋsan na gubun igane yan ile ya. Tamol an san gubun man 10 kina. Ile go buron yabig iratitale dugo iŋsan gubun ipani wo irupei a. ");
INSERT INTO tbc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Urat tamol an iŋsan urat kisaek an naon na turun isoluwi idug irupei, ‘Gidad bube panag dop oŋane gubun ŋupano wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ak man tamol an imoi go subanek ab lo ibili iladu ya. Ago imado dop san gubun an ikubune itout gup ilasa wo ago igane ya. ");
INSERT INTO tbc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Saen iŋsan urat kisaek aenta ago dile man, ilod saian geig go kiŋ san na diaug mel fidian dile yan naon na dubol ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Agog kiŋ an urat tamol a kulob igane yan iwagig san na yau a. Yaug iladu man kiŋ ago irupei, ‘Oŋ tamol saia geig a, oŋsa gubun man niŋen o bubeg ŋupano ya, man dugo, oŋ ŋai sumianag a. ");
INSERT INTO tbc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Oŋ gidad oŋsa urat kisaek an bube pani wa, nek ŋai dam oŋ bubeg ŋupano ago mi a.’ ");
INSERT INTO tbc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kiŋ tiŋaen wananan geig a, ago yan lo urat tamol an dam subanek ab lo igane yau a. Ante man subanek ab san tirnek adi tinin malan dusue dop yaup, kiŋ san gubun isopasi gup ilasa da wa. ");
INSERT INTO tbc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Aria, oŋ bube fidian lo tei a oŋ lo aupasek igane dan iŋsan aupasek ta pare idu na tap, man ŋai Tamag kumaen panu na yan iŋ kagin nek ago mi oŋ lo igane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Saen Jesus ŋiŋeŋ en ibol itout man, distrik Galili ibiseig Judea na yau a. You Jordan ituteg Judea san aben titin ante iladug itilianig itor se ya. ");
INSERT INTO tbc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ago dugo tamolpein malan tubun ak ŋien aban diri dugo subam ad da yak ilod lo ikubuniai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Agog Farisi aenkadi san na dupalug diabi wo bitinaek diganeg dusumiani, “Idaned kubiaeŋ dugo ibol ak i? Mel ta niŋen o, tia, mel dugo dugo yak niŋen o, tamol ta iŋanen pein ka ibisei wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus ru naon irupidaig ibol, “Aŋ dag girek en ta asuti na ya, ‘Fun lo mok Mel Niganag Tamol man tamol iŋ pein da idirai a,’ ");
INSERT INTO tbc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","agog ibol, ‘Fun an niŋen o tamol iŋ tinan taman ibisawaip iwon iŋanep nug dupini dupini wa, an lo dop uraru an kisaek mi dilasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","An niŋen o iŋ uraru ago tia ya, iŋ kisaek a, man dugo, Anut iŋsen mi itumanai a. Ak niŋen o kabelan mel ta Anut itumanai an tamol itute banau.” ");
INSERT INTO tbc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ago ibol tag Farisi dusumiani, “Agog ata wo kubiaeŋ Moses igire yan igo ibol ak i? Tamol ta iwon ikudi wo ilon ago yen tap, aria, girek ta igirep, iwon ipani gup ikudip yau a. Girek an nug banin diabi amaiak itute san girek.” ");
INSERT INTO tbc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus ru naon igo irupidai, “Moses iwomi akudai san awok ipanaŋ a, man dugo, aŋ bubem dabai geig a. Ak man fun lo mok an san saen lo, kagin naok ago yak ta digane na ya. ");
INSERT INTO tbc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Agod ru taida ŋurupaiaŋ da, tamol ta mel ta niŋen o iwon ikudi yau dop, pein foun ak iŋane tap, tamol an jeit kagin igane ya. Aria, iwon imug ak a jeit kagin igane yan mi ka ikudip yau a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iŋanen megeloum duloŋ go durupei, “An ago pein tamol da lo ilasa tap, gidad nug diŋane dumoi.” ");
INSERT INTO tbc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus ru naon irupidai, “Tamol nug ŋanek lo dumoi dan san piteŋanek man, fidian ilo uyan lo diŋane san tia ya, ak man nek a Anut dabai ipidinai damaiak mi kagin an ka diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tamol pein ta dusu na duman, fun senamo senamo ya. Aenta man nabud patun amad tia, ago tinad tiŋaen lo dilasa ya. Aenta man tamol nabud dupasi da. Aria, aenta man, Anut san kagin panek aben dabai dupani san niŋen o pein ta dusu na da. Tamol ta piteŋanek en awok ka ipani tap, iŋane wan uyanan geig a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Agog tamolpein iŋsiganed nanuk diŋal go Jesus banin kabuŋad fo iganep gadiŋ lo bar ipidinai san niŋen o iŋsan na dupalu se ya. Ak man iŋanen megeloum adi tamolpein ru dabai nam dupudai a. ");
INSERT INTO tbc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ago gug Jesus ibol, “Nanuk ŋaisag na dupalu wo dop eilafu wak, abituanai amoi. Man dugo, Anut san kagin panek aben man nanuk igo yak sadi a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Agog banin kabuŋad fufo iganeg aben an ibiseig yau a. ");
INSERT INTO tbc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aria, pinein damag ta Jesus san na ipalug isumiani, “O girek maŋau, ata kulob uyan ak ŋigane dop lo madok pempem yen san an ka ŋiŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus ru naon igo irupei, “Ata wo mel ta uyan an niŋen o sumianag dak i? Nek Anut kisaek o lian an mi uyanan a. Madok uyan ak lo wau o ilo ibol tap, ru kubiaeŋ girek lo dien dan kagin pidinai a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Agog isumiaeŋ, “Ru kubiaeŋ dugomaiak i?” Jesus ru naon irupei, “Oŋ tamol ta funi imat na wak, jeit kagin ta gane na wak, ta ugam na wak, kot lo supalek ru ta ubol na wak, ");
INSERT INTO tbc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tina tama awad paen na mado dop kagin pidinai o uyan ak, agod oŋse niŋe wo umat dak ago mi aenta dam niŋedi wo umat a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pinein an irupeig ibol, “Ru kubiaeŋ an fidian ŋuri ŋupani se ya. Ata mel taida niŋen o katuk ag ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus irupei, “Oŋ itaot mok lasa wo ilo yen tap, waup oŋsa mel an fidian didaeŋ lo ganep moni ŋane wa. Aria, moni an ŋanep tamolpein mel ad tia yan pidinai a. Ago dop oŋ kumaen panu lo filiama da wa. Ago gane gup palup ŋieg aban uri wa.” ");
INSERT INTO tbc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Saen pinein an ru ago iloŋ man, ilon idug yau a, man dugo, iŋ tan en lo melmel wei kasik aman da ya. ");
INSERT INTO tbc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Agog Jesus iŋanen megeloum irupidaig ibol, “Ŋai rumok ŋabol da, tamol filian anda man Anut san kagin panek lo iladu san man muruan geig a. ");
INSERT INTO tbc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ŋai fon ŋurupaiaŋ da, tamol filian anda yak Anut san kagin panek aben lo ka iladu an, rumok tap, aria, kamel dam si guburan tusan ak lo yau san man pasauman geig a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Saen iŋanen megeloum ago duloŋ man, malad ifure saian geig go dusumiani, “Mago tap, enti mok patu pasek ka iŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus malan ti ibol go yil dugo irupidai, “Tamolpein kulob ago man iŋ lo ta idaisuda na ya, ak gug Anut lo mel fidian man pasauman a.” ");
INSERT INTO tbc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Agog Pita ru naon ibol, “Ule, mel fidian mibiseig ŋie aban muri se ya, an lo ata naon igo mok miŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus irupidai, “Ŋai rumok ŋurupaiaŋ da, Anut mel fidian afon foun idirai dilasa san saen lo man, Tamol Nanun iŋanen badim girager anda yak fufo imasi wa. Ago dop aŋ enti ŋieg aban ari apani na yan dam badim 12 ak fufo amasip Isrel san gugoi 12 an abitiniai a. ");
INSERT INTO tbc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Agod talpein enti ab ibiseig, tia tein boi, lun boi, taman boi, tinan boi, nanun moroun boi, siganen tan boi, an ŋai yaŋag yabisa wo ibisei dop man, mel a ibisawai an san naon sutek yaup 100 iriŋani wa. Taida mi, ŋai madok pempem yen san an dam ŋupani wa. ");
INSERT INTO tbc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ak man talpein wei mi gamu iŋ sed malan te idirai dan, saen an lo man iŋ yaŋad tia yak ago dilasa wa. Agod talpein wei mi iŋ gamu yaŋad tia dumado dan, saen an lo malan te dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Anut san kagin panek man igo ya. Salso idug abi san muroun imasag didaeŋ aben lo yaug urat tamol aenta ibiaip iŋanen wain abi ilon lo urat digane san. ");
INSERT INTO tbc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iŋ urat tamol an dida urat naon dugo ipidinai an niŋen o dukubiai se ya. Agog adian kiskisaek atem kina kiskisaek ipidinai o ago ibol a. Agog urat tamol an duloŋ go ŋiŋeŋ an awok dupanig idinaig iŋanen abi lo diau a. ");
INSERT INTO tbc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tidom lom, afon imasag didaeŋ aben ante yaug ilasag, tamol ta kawan dutur dugo yil a. ");
INSERT INTO tbc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ago dugo irupidaig ibol, ‘Aŋ dam ŋaisag wain abi lo aup urat agane. Ago dop murnap aŋanem urat naon dugo itaot atem ŋupanaŋ a.’ Ago tag diau a. ");
INSERT INTO tbc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Iŋ afon, adian lo agod guraian lo mi, nek ago igane ya. ");
INSERT INTO tbc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Guraian mok, auwa kisaek imug mi ad idiau an lo, afon imasag yaug tamol taidam urat ad tia kawan dutur dugo yil a. Agog tamol an irupidaig ibol, ‘Aŋ ata wo ad milaen kawan atur amado dugo urat ta agane na dak i?’ ");
INSERT INTO tbc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Iŋ abi muroun ru naon durupeig dubol, ‘Tamol ta maŋ ibiama man tia ya.’ Ago tag irupidai, ‘Aŋ dam gamu ŋaineg wain abi lo au a.’ ");
INSERT INTO tbc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aria, saen ad idiau dugo abi muroun iŋsan urat gurman irupeig ibol, ‘Urat tamol giai dop sad urat naon anen anen atem udad a. Tamol a murna geig ŋaŋal an ate fun ganep, ipalup, yaup, imug ak ate itout a.’ ");
INSERT INTO tbc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Saen urat tamol a murna geig ibiai an dupalu man, anen anen atem kina kiskisaek urat san gurman ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","An niŋen o saen urat tamol a imug mi ibiai an dupalu man, iŋ moni subuŋan taidam diŋane wak ago ilo sou digane se ya, ak man iŋ dam nek kina kiskisaek mi diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Iŋaned kina diŋane gug, abi muroun niŋen o fun diganeg duŋurŋur se ya. ");
INSERT INTO tbc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Iŋ dubol, ‘Tamol e murna geig biai an auwa kisaek o lian urat digane ya, ak man oŋ ago gane yan lo maŋ iŋ dida sisem mi milasa ya. Gug maŋ urat san muruan ad milaen maŋ mi misini se ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ak man abi muroun tamol ta luluŋad lo imado yan irupeig ibol, ‘Turag, ŋai oŋ ta ŋiginio saian na da. Dugo, oŋ kina kisaek o lian lo urat gane wo awok ta ubol na yak i? ");
INSERT INTO tbc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oŋane urat naon ŋanep wau. Tamol a murna geig ŋaŋal an, urat naon a ŋupano yan, nek ago mi iŋ dam ŋupidinai o ilog yen a. ");
INSERT INTO tbc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","En dugo, ŋai siganeg moni lo dugo ŋigane wo dan, ago ka ta ŋigane na wak i? Tia, ŋai siganeg mel ŋuwae dan niŋen o mala isi dak i?’ ");
INSERT INTO tbc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Nek ago mi, talpein murna yan mitep imug dop, imug an murna wa.” ");
INSERT INTO tbc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus iŋ Jerusalem na yau se ya, saen an lo iŋanen megeloum 12 an iŋal go dida gigin na diaug, irupidaig ago ibol, ");
INSERT INTO tbc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Aloŋ uyan a, id Jerusalem na tau da. Ante man Tamol Nanun diŋanep pris gurman agod kubiaeŋ san girek maŋau banid lo digane wa. Iŋ malak malak bitinaek lo digane gup imat a. ");
INSERT INTO tbc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ago dop Juda tia yak banid lo diganep lo kukok aman digane gup, rasau nam dufuni nap, aigim fo dubali wa. Ago digane wak man, nal utol itout gup, Anut ifufunip afon kumaen imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Agog Sebedi san nanun uraru amaiak tinadi da, Jesus naon na dupalu ya. Agog tinadi turun isaluwig mel ta ipani san niŋen o Jesus isumiani a. ");
INSERT INTO tbc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus pein an isumiani, “Ata mel niŋen o ilo ibol dak i?” Agog pein an naon irupei, “Ru ubol an lo ŋai nanug muroug e dumado den, murnap uŋal pe oŋane kagin panek aben lo, oŋane badim fo siŋire na dumasip dumado wa. Neinta bani won ak lo dop, neinta ŋas ak lo gane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Agog Jesus, Jems iŋ Jon da irupidaig ibol, “Mel dugo mok niŋen o asumianag dan ta aloŋ uyan na ya. Ak dugo, gab a ŋai lo ŋaluk san an, aŋ dam lo aluk anen idaisuda yak i?” Agog iŋ ru naon durupeig dubol, “Awo, maŋ idaisuda ya.” ");
INSERT INTO tbc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus irupidai, “Rumok, aŋ ŋaineg gab an lo aluk a. Ak man siŋireg na amasip amado, ta banig won ak lo, ta banig ŋas ak lo, aben a yaŋan anda amaiak ŋai ŋupanaŋ san ta idaisuda na ya. Tia, ŋaineg Tamag iŋsen mi tamol ta aben an ipidinai san ipilianai la ya, amaiak niŋen o aben uraru an iŋaned mi a.” ");
INSERT INTO tbc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Saen iŋanen megeloum 10 dumado yan ago duloŋ man, tamol uraru an niŋedi wo tiŋaed saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ak man Jesus igiaig san na dupalug igo irupidai, “Aŋ aloŋ ak, gob adi luluŋad lo iŋaned gurman sed idiraip lak na mok disuda dop tamolpein ditirnai o digane wa. Agod iŋaned tutubu yan tamolpein kawan ak didiraip tuod paed na dumado wa. ");
INSERT INTO tbc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ak gug aŋ luluŋam lo kagin ago yak ta mok ilasa na wa. Tia, talpein ta aŋ luluŋam lo yaŋak tubun ak iŋane wo ilon ibol tap, sen iganep aŋanem biabi ŋilaŋal oŋ ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Agod talpein ta aŋ luluŋam lo imug yau san ago ilon ibol tap, sen igane idup aŋ fidian mi wagem lo bigabeg igo woŋ ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nek ibol Tamol Nanun iŋsen igo woŋ, tamolpein aenta binawek urat dupani wo ta ipalu na ya, tia, aenta niŋedi wo binawek urat igane wo ipalu ya. Agod sen tinin fidian ibiseip an lo tamolpein wei mi siganen dar lo idad pe iŋal imul o dam ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Saen Jesus iŋanen megeloum dida Jeriko dibisei man, tamolpein malan tubun ak ŋien aban diri a. ");
INSERT INTO tbc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ante man tamol uraru maladi itau ak dal gigin na dumasig dumado ya. Saen Jesus iriŋanai o igane dugo duloŋ man diwagiŋ, “O Tubun ak, Dawid Nanun, ilo imuŋanama!” ");
INSERT INTO tbc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Agog tamolpein an dububuŋanaig durupidai, “Awam itaup atokabol pe amado!” Ago tag tamol uraru an nen maeg nam duwagiŋ dugo disasai, “O Tubun ak, Dawid Nanun, ilo imuŋanama!” ");
INSERT INTO tbc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus awad ago iloŋ man, ipartuanig igiaig irupidai, “Dugo ŋidiraŋ o ilom ibol di?” ");
INSERT INTO tbc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Agog iŋ durupeig dubol, “O Tubun ak, maŋ abaŋ mile wo iloma ibol da.” ");
INSERT INTO tbc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Agog Jesus tubun mok ilon imuŋanaig maladi isupuri dugo gamu nam uraru an abaŋ dile ya. Agog ŋien aban dirig dutor se ya. ");
INSERT INTO tbc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesus iŋanen megeloum dida Jerusalem sumeik dupani dugo, Did Oliv siŋiren na panu ta yaŋan Betfage dubol dan ate dilasa ya. Ago man Jesus megeloum uraru panu an ilon lo diau o idinai a. ");
INSERT INTO tbc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Iŋ ago irupidaig ibol, “Aŋ nuŋom urarum panu o tile dan ante au a. Aup doŋki ta dususeg itur dak ante ale wa, iŋ nanun da sisem dutur da. Urarum kam apasip aŋal pe ŋaisag na apalu. ");
INSERT INTO tbc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tamol ta ru aman da dop, aŋ igo arupei wa, ‘Tubun ak urat ipidinai a.’ Iŋ ago iloŋ dop, idinaip aŋal pe apalu salti wa.” ");
INSERT INTO tbc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dal an lo man, awan aban ta profet ta ibol an nuŋon ilasa ya. Ru an igo ibol, ");
INSERT INTO tbc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ru en Saion san Nanun Pein naod na ubol ilasa wa. Ale, aŋanem Kiŋ gamu aŋsam na ipalu da. Tamol mos aman ak igo woŋ ipalu da, doŋki ta fufo na imasig imado da. Doŋki an foun ak fo na imasig imado dugo ipalu da.” ");
INSERT INTO tbc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Agog megeloum uraru an diaug, Jesus ibol ak ago mi digane ya. ");
INSERT INTO tbc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Diaug, doŋki tinan iŋ nanun da diŋal go dupalu ya. Agog doŋki an patun fufo kulos duruwarig, Jesus fo isudag imasig imado dugo diau a. ");
INSERT INTO tbc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Agog tamolpein malan tubun geig an iŋsiganed kulos milmilae ak dupasi dugo dal te duruwari se ya. Ago dugo aenkadi ai raen dututeg dal damag dupani dugo didiri se ya. ");
INSERT INTO tbc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tamolpein aenkadi, Jesus dida inug mi diau dugo, tamolpein aenta murna dupalu ya. Iŋ fidian mi igo dubol duwagiŋ se ya, “Hosana, Dawid Nanun, per mupano da! Tamol Anut yaŋan lo ipalu den bar iŋane ya! Hosana lak na geig!” ");
INSERT INTO tbc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Saen Jesus Jerusalem na iladu man, tamolpein fidian ilod imasa dugo nug dusumiani se ya, “Tamol en enti ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ago dugo tamolpein a ida tureŋ diabi se yan ago dubol, “En Jesus, emaiak iŋ profet, distrik Galili ilon lo panu ta Nasaret san ak ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus tempel san ar ilon lo iladug, aben ante didaeŋ tamol, agod a melmel ta didad dan dam fidian ikudaig patun fo dilasa ya. Iŋsad tebol fufo na moni dubulisa se yan, iratitaleg yabibol idu dugo, tamol aenta muluk didaeŋ lo didirai se yan sad kalik dam yabibol yau a. ");
INSERT INTO tbc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iŋ igo ipidai, “Anut san buk lo ru en digire ya, ‘Ŋaineg ab man gudanek san ago dubol a,’ ak man aŋ agane ilasag ‘gumagam adi sad mianuk ab’ igo agane da.” ");
INSERT INTO tbc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesus tempel lo imado dugo, malad itau agod ŋied saian ak dam san na dupalu se ya, ago man iŋ ikubuniai dugo tinid siŋaokan dilasa se ya. ");
INSERT INTO tbc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ak man pris gurman adi agod kubiaeŋ san girek maŋau dam iŋ kulob girager igane se yan dile dugo, nanuk tempel san ar ilon lo yak igo duwagiŋ, “Hosana Dawid Nanun, per mupano da!” Saen gurman adi ago dile man ilod saian dugo tiŋaed wananan a. ");
INSERT INTO tbc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ago tag Jesus dusumianig dubol, “Ru e dubol den uloŋ dak i?” Agog Jesus ru naon irupidai, “Awo, ŋaloŋ da. Nag aŋ ru en ta asuti na yak i? ‘Oŋ nanuk kititik agod nanuk su ate dam pilianai dop, per panek awad lo ilasa wa.’” ");
INSERT INTO tbc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Agog iŋ ibisawaig Jerusalem patun fo ilasag yaug tidom an lo Betani na ŋioŋ yabi a. ");
INSERT INTO tbc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tidom lom mok Jesus imul go Jerusalem na yau, saen an lo dam iŋ anaŋ o imat. ");
INSERT INTO tbc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Malan yaug dal gigin na ai gurab ta itur dugo ile, ago man siŋiren na geig yau. Ak man nuŋon ta ile man tia ya. Roun kawan mi yen a. Ago tag iŋ ai gurab an ago irupei, “Oŋ afon nuŋo ta ufu na wa. Tia geig a.” An lo man gurab an ibun yau kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iŋanen megeloum ago dile man durut geig dugo dubol, “En dugo woŋ mok go gurab an ibun yau kisaek oŋ ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ago dugo Jesus ru naon igo irupidai, “Ŋai rumok mi ŋurupaiaŋ da, aŋ ilom lo rumok dop, agod ilom uraru dam tia tap, aŋ kulob e ŋai gurab lo ŋigane yak ago mi ka agane wa. An mi tia ya, tia, aŋ did en arupeip, oŋ masap sokalik beig lo udu, ago dop mel a arupei an awam yabi wa. ");
INSERT INTO tbc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Agod aŋ ilom rumok aman da yak lo gudanek agane tap, mel fidian a niŋedi wo gudanek agane dan ka aŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus tempel lo iladug tamolpein maŋau ipiteŋanai se ya. Ago dugo pris gurman adi agod Isrel san gurman adi dam dupalug naon na dilasag dusumiani, “Oŋ kob en agod dabai dam dugon te ŋaneg lo melmel en gane dak i? Enti mok dabai en ipanog ate urat en gane wo ibol ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Agog Jesus ru naon igo irupidai, “Ŋai dam mel ta niŋen o ŋusumianaŋ o da. Ago dop aŋ imug ŋaisag sumianek an itaot arupaiag tap, enti mok urat e ŋigane den san dabai ipanag ak ka ŋabol pe aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dugo ilom isou dak i? Jon san suguek man, dugon te kagin an iŋane yak i? An kumaen panu san mel, tia, tamol sad mi ak i?” Agog iŋsed nug lo igo diŋiŋeŋ se ya. “En kumaen panu san mel, ago tabol tap, iŋ igo ibol isumianad a, ‘En ata wo aŋ iŋ niŋen o ilom ta rumok na yak i?’ ");
INSERT INTO tbc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ak gug ‘En man tamol sad mel mi a,’ ago tabol tap, id o dugo ilasa wak i? Id tamolpein en niŋedi wo tarer da, man dugo, iŋsad ilo sou lo man Jon mi iŋ profet, ago dubol da.” ");
INSERT INTO tbc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ago yak niŋen o Jesus ru naon durupeig dubol, “Maŋ ta maloŋ na ya.” An lo man Jesus irupidai, “Ago yak niŋen o ŋai dam enti mok kob agod dabai ipanag an ta ŋurupaiaŋ na wa.” ");
INSERT INTO tbc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Aŋ mel emaiak niŋen o dugo woŋ ilo sou agane di? Tamol ta nanun uraru a. Iŋ nanun matu ak san na yaug igo irupei, ‘Nanug, oŋ gamu waup wain abi lo urat gane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Agog nanun ibol, ‘Ŋai ŋamoi.’ Ak man murna gug ilon ibileksag abi lo yau a. ");
INSERT INTO tbc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Agod taman an nanun bakan ak san na yaug, ru naon kisaek ago mi irupei a. Agog nanun an awan yabig ibol, ‘Awo Bai, ŋau o da.’ Ak gug iŋ ta yau na ya. ");
INSERT INTO tbc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dugo ilom isou dak i? Nanuk uraru en, enti mok taman san ilobol iri ak i?” Ago man iŋ dubol, “Nanuk matu ama ya.” Agog Jesus ago irupidai, “Ŋai rumok ŋurupaiaŋ da. Takis ŋilaŋal, agod dal san pein adi, iŋ aŋ diriŋanaŋ go Anut san kagin panek aben lo diladu da, ak man aŋ aladu wo amoi da. ");
INSERT INTO tbc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Man ata wo? Jon imug aŋ kagin itaot ak san dal ikubiaip ale wo, sam na ipalu ya. Ak man aŋ ilom ta rumok na ya. Ak gug takis ŋilaŋal tamol, agod dal san pein adi dam, iŋ ilod lo rumok a. Gidad aŋ ago ale bo man, ilom lo ta rumok na, agod ilom dam ta ibileksa na ya.” ");
INSERT INTO tbc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus tamol tutubu yak ago irupidai, “Kududom agure dop ru faŋan taidam ŋurupaiaŋ o da. Tamol ta iŋ wain san abi yabig ar ifou a. Abi an ilon lo wain patun dupartitale san gib yabi a. Agod ab a ate abi titianek dumado san dam abi ilon lo yabi a. Agog tamol ta abi an kagin dupani san urat digane wo ipilianaig, banid lo igane ya. Aria, saen abi taman iŋ urat an fidian igane itout man, imasag panu asau ak ate yau a. ");
INSERT INTO tbc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aria, ai wain nuŋod ifu san saen sumeik ipani dugo, iŋ iŋsan biabi ŋilaŋal idiraig iŋanen wain nuŋon disini wo diau a. ");
INSERT INTO tbc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ak man urat tamol a abi lo dumado dan dumasag, tamol a abi muroun idinaig diau an muruan dupidinai a. Ta dufunig, neinta dufuni imat dugo, kisaek pat nam dufuni imat a. ");
INSERT INTO tbc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Murnag abi taman an urat tamol sen ak idiraig sad na diau a. Iŋ nuŋod kitek wei a, a gubak mi idiraig diau an diriŋanai a. Tamol abi lo urat digane yan dumasag urat tamol a diau an lo kulob gubak mi digane yak ago mi digane pidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Murna geig abi taman nanun mok idinig yau dugo ilo sou lo igo ibol, ‘Urat tamol an ŋaineg nanug mok an awan diabi wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Tamol abi lo urat digane dan, malad yaug nanun ipalu dugo dile. Ago man iŋsed nug ru dupeig dubol, ‘Tamol en man taman san melmel fidian mi iŋane wo da. Ago yak niŋen o id tufunip imat dop, iŋanen abi id tiŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ago dubol go diabig ar patun fo dubal idug dufunig imat a. ");
INSERT INTO tbc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ago yak niŋen o aŋ dugo woŋ ilom isou dak i? Murnap, saen abi taman an ipalu wan lo, iŋ tamol a abi lo urat digane na yan niŋedi wo dugo mok igane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iŋ ru naon igo durupei, “Abi taman iŋ tamol saiadi an daoŋ saian geig ak ipidinai a. Ago dop wain san abi an tamol sen ta ipidinaip kagin dupani wa. Urat tamol foudi an, wain nuŋon ifu san saen lo, san nuŋon diŋanep dutumanip disini dop dupani wa.” ");
INSERT INTO tbc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ago tag Jesus ago ibol isumianai, “Nag aŋ ru e girek lo yen den ta asuti na i? ‘Pat nek a ab bek tamol adi dumoi dan, nek amaiak ab tinin fidian yabi sakar da. An Anut sen ago igane ya, agod id malad lo en man siŋaokan geig a.’ ");
INSERT INTO tbc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Amaiak niŋen o ŋai ŋurupaiaŋ da, Anut iŋsan kagin panek aben an, aŋ tuom lo ipasi yau a. An lo dop tamolpein sen ak ta, iŋ Anut san kagin panek aben an san nuŋon mok digane ilasa dan, kagin panek aben an iŋ ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Talpein ta iŋ pat en fo na yau idu dop man, sen ifuni ititale wa. Ak gug talpein ta pat en kabuŋan fufo idu dop, ifufari idu wa.” ");
INSERT INTO tbc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Saen pris tutubu agod Farisi adi, Jesus ru faŋan a ibol se yan duloŋ man, iŋ duloŋ uyanan ak Jesus iŋanen ru lo iŋ isiai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Amaiak niŋen o dal ta lo Jesus diabi wo maeg diganeg abaŋ dile se ya. Ak man tamolpein malan tubun ak niŋedi wo direr, man dugo, tamolpein an sad ilo sou lo man Jesus iŋ profet, an niŋen o iŋ ta diabi na ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Agod afon, Jesus tamolpein an ru faŋan lo irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anut san kagin panek man igo ya. Kiŋ ta iŋsinan nanun tamol ak o nug ŋanek san soubul yabi a. ");
INSERT INTO tbc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Iŋ imug mi tamol adi a iŋsan nug iwon san anaŋ diani wan nal dugon lo dupalu wo irupidai. Aria, anaŋ nal idu dugo iŋsinan urat tamol idiraig tamol an dil o diau a. Ago yak man iŋ dupalu wo dumoi a. ");
INSERT INTO tbc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Agod afon iŋ urat tamol sen ak idiraig diau wo dugo, igo irupidai, ‘Aŋ tamol a gubak mi ŋigiai an sad na aup, igo arupidai a. Aloŋ uyan, ŋai anaŋ ŋukubune la ya. Makau tubun ak agod makau nanud tinid bulbal ak dam mafu la ya, mel fidian mukubuneg dien da. Aŋ soubul en lo apalu wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Urat tamol diaug tamol an ru durupidai a, ak man ru an dumoi go kagin ta dupani na yan lo, dufurak go gidigidad diau a. Ta iŋsinan abi lo yau dugo, ta yaug iŋsinan bisnis urat igane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aenta dumasag kiŋ san urat tamol duburoug ru saian ak lo dububuŋanaig dufu dumat a. ");
INSERT INTO tbc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","An niŋen o kiŋ tiŋaen tubun mi saian tag, iŋsinan yu tamol adi idiraig diaug, tamol a iŋanen urat tamol dufu dumat, amaiak dufu dumat dugo sad panu dam dumarig inani yau a. ");
INSERT INTO tbc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“An itout go kiŋ an iŋsan urat tamol ago irupidai, ‘Nug iwon ŋilaŋal san anaŋ kubunek go yen da. Ak man tamol a ŋai imug ŋigiai an, dupalu san iŋ ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ago yak niŋen o amasap dal gigin fidian lo atur a, tamol fidian eil dop, agiaip nug ŋilaŋal san anaŋ lo dupalu wo ago arupidai a.’ ");
INSERT INTO tbc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iŋ ago ibol dugo, iŋanen urat tamol dumasag, dal gigin fidian atem dutur dugo, tamolpein uyadi agod saiadi ak dam dil dugo dutumanai se ya. Agog anaŋ tubun an lo dupalu ya. An lo man ab a ate soubul diani san an awan isa geig a. ");
INSERT INTO tbc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tamolpein dumasig dumado dugo kiŋ an yil o iladu ya. Iŋ iladug malan yau man, tamol ta nug ŋilaŋal san kulos ta igane na yan ile ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Agog naon na isusag isumiani, ‘Turag, en dugog oŋ nug ŋanek san kulos ta gane na gug ente sadu yak i?’ Agog tamol an ru ta ibol san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ago tag kiŋ urat tamol adi siŋiren na dutur dan irupidaig ibol, ‘Aŋ ŋien banin afoup, aŋanep abili patun fo ilasa dop, abaŋ tidom tubun ak lo imado wa. Aben ante man tamolpein tinaŋ digane dop madai lo luod dugurmi wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Man dugo, Anut iŋ bo tamolpein wei kasik igiai da, ak gug tamolpein kisaek kisaek mi diladu san kob ipidinai a.” ");
INSERT INTO tbc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Agog Farisi adi diaug, Jesus san ŋiŋeŋ lo dal dugo diabi san niŋen o dutumanig dukubiai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iŋ awad kisaek go, siganed megeloum aenkadi, Herod san tamol aenta dida didiraig, Jesus san na diau a. Tamol an Jesus durupeig dubol, “Girek maŋau, maŋ maloŋ ak oŋ ru rumok san tamol. Oŋ tamolpein Anut san dal an niŋen o itaot mi piteŋanai da. Oŋ tamol ta niŋen o urer san tia ya. Tia, oŋ ru kisaek an mi tamol fidian lo ubol yau da. Gidad yaŋad da yak, di yaŋad tia yak dam mi a. ");
INSERT INTO tbc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","An niŋen o oŋ ka mel en niŋen o rupaiama wa. Dugo, Kaisa takis moni tupani wan uyan ak i? Tia, saian ak i? Oŋ dugo ilo isou dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ago yak man Jesus iŋsad ilo sou saian an iloŋ dugo igo irupidaig ibol, “Aŋ balem rararu a, ata wo ŋai bitinaek lo aginiag o agane dak i? ");
INSERT INTO tbc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aŋ moni a lo takis adad o dan kisaek akubiai dop ŋile wa.” Ago tag iŋ moni ta disinig san na dupalug dupani a. ");
INSERT INTO tbc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus ibol isumianai, “Mitilaen agod yaŋak e fufo digire yan enti san ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Agog iŋ dubol, “Kaisa san.” An niŋen o irupidai, “Mel ta Kaisa san tap, Kaisa apani wa, agod mel ta Anut san tap, Anut apani wa.” ");
INSERT INTO tbc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Saen ru an duloŋ man durut saian geig a. Agog dibiseig diau a. ");
INSERT INTO tbc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nal kisaek an lo Sadyusi aenta Jesus san na dupalu ya. Tamol nek an pris gurman adi sad warou, iŋ tamol dumat pe murnap fon kumaen dumasa da wan niŋen o ilodi ta rumok na da. Agog Jesus igo dubol dusumiani, ");
INSERT INTO tbc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Girek maŋau, Moses gubak mi igo ibol a. ‘Tamol ta iŋ nanuk aman tiag imat tap, gidad tein imasap iwon ka iŋane dop, an lo tein imat la yak aben lo nanuk idiri ilasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aria, gubak mi man tein muroun nuŋod 7 maŋ lulaŋama lo dumado se ya. Matu ak pein iŋaneg imado nag imat, ak gug iŋ nanuk aman tia ya. Ago yak niŋen o tein bakan ak imasag matu imat an san pein iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tein bakan an dam tein san suos a iŋaneg, dumado yak man nanuk amad tiag tamol ak imat a. Tein muroun murna an dam nek ago mi, teidi sad suos an diŋane yak man, nanuk amad tia dumado nag, dumat a. ");
INSERT INTO tbc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tein an fidian mi nanuk amad tia dumat gug pein an dam imat a. ");
INSERT INTO tbc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","An niŋen o oŋ ubol rupaiama wa. Saen tamolpein dumat pasik an afon kumaen dumasa tap, tamol an fidian ilod lo man, pein an enti iwon ak i? Oŋ uloŋ ak iŋ fidian iwodi a.” ");
INSERT INTO tbc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ak gug Jesus ru naon irupidaig igo ibol, “Aŋ afurfi saian a. Man ata wo? Anut san ru girek lo yen dan, agod Anut san dabai dam aŋ ta aloŋ uyan na ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Saen tamol dumat pe dumasap kumaen panu na dutor dan, pein ta dusu na da, agod ante tamol ta pein ŋien ta dupani na da. Tia, iŋ kumaen panu san eŋel igo woŋ dumado da. ");
INSERT INTO tbc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Agod taida mi, tamol dumat ak fon kumaen dumasa da wan niŋen o kududom agure. Nag aŋ ru a Anut irupaiaŋ an ta asuti na yak i? Iŋ igo ibol, ");
INSERT INTO tbc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ŋai man Abraham san Anut, ŋai dam Aisak san Anut, agod ŋai dam Jakob san Anut.’ Anut man iŋ tamol a mateŋ lo dumado dan sad Anut tia ya. Tia, iŋ man tamol kumaed dumado dak sadi a.” ");
INSERT INTO tbc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Saen tamolpein a Jesus dubuluwi dan iŋsan piteŋanek emaiak duloŋ man, iŋ durut dugo ru an niŋen o nug lo diŋiŋeŋ ila iso se ya. ");
INSERT INTO tbc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saen Farisi, Jesus ru a ibol an lo Sadyusi awad yabituani an duloŋ man, naon na dutumani a. ");
INSERT INTO tbc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tamol ta iŋ luluŋad lo itur an, iŋ kubiaeŋ san uloŋ tamol, amaiak ru a Jesus ibol an ipipi wo igo isumiani a. ");
INSERT INTO tbc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Girek maŋau, kubiaeŋ dugomaiak iŋ malan te dugo, kubiaeŋ aenta iriŋanai geig ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","An niŋen o Jesus ago irupei, “Oŋ gidad Tubun en oŋane Anut niŋen o umat a, oŋ bube fidian lo, oŋ ŋutu fidian lo, agod oŋane ilo sou fidian lo ago gane wa. ");
INSERT INTO tbc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kubiaeŋ en tubun a, agod iŋ malan te geig a. ");
INSERT INTO tbc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kubiaeŋ turan en dam nek ago mi a. Nek oŋse niŋe wo umat dak ago mi, tamolpein aenta dam niŋedi wo umat a. ");
INSERT INTO tbc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kubiaeŋ uraru en malan te yen da, Moses san kubiaeŋ fidian, agod profet sad awak aban an dam, kubiaeŋ uraru en paed na diyuk dien da.” ");
INSERT INTO tbc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi adi dutumanig dumado dugo Jesus ibol go isumianai, ");
INSERT INTO tbc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Aŋ Kristus niŋen o dugo ilom isou di? Iŋ enti nanun ak i?” Ago man iŋ durupei, “En man Dawid nanun.” ");
INSERT INTO tbc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ago tag iŋ irupidai, “Aria, en dugo woŋ go, Kristus niŋen o, Dawid iŋsen mi Awan Urgun san dabai lo mi iŋiŋeŋ dugo tamol an yaŋan man, Tubun ak ibol ak i? Iŋ igo ibol, ");
INSERT INTO tbc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tubun en ŋaisag Tubun ak igo irupei, “Oŋ ŋai tuog won ak ate masip yaup, murna gup ŋai oŋsa ager adi ŋidiraip, oŋ ŋie pae na dumado dop ŋie nam partuanai a.” ’ ");
INSERT INTO tbc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Amaiak niŋen o Dawid iŋsen mi iŋ Tubun ak ago ibol tap, en dugo woŋ pe iŋ Dawid nanun ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nal an log yau man, Jesus sumiaeŋ subuŋan taidam dusumiani wan niŋen o direr se ya. ");
INSERT INTO tbc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nal an lo Jesus iŋanen megeloum, agod tamolpein a dubuluwi an dam irupidaig ibol, ");
INSERT INTO tbc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kubiaeŋ san girek maŋau iŋ Farisi dida Moses naon diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","An niŋen o ata mel agane wo durupaiaŋ dan an kagin apani dop itaot mi agane wa. Ak gug kagin naok naok a digane damaiak aŋ dam nek an ta ari apani na wa. Tia geig, man ata wo? Iŋ ru kagin wei mi dubol dak, gug iŋsed mi iŋsiganed ru ta duri dupani na da. ");
INSERT INTO tbc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iŋ tu muruan ak dufou dugo, tamol yarod fo didirai da, ago yak gug iŋsed banid kuruŋen nam kitek diabip tamol dubunawai dop disini wo man dumoi da. ");
INSERT INTO tbc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mel fidian iŋ digane duman, tamol dil o digane da. Awo, iŋ gudanek san ariy didiri dugo, bala milmilae ak dam kulos bitiŋen fo na digane da. ");
INSERT INTO tbc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iŋ soubul lo kalik malan te yak niŋen o dumat da, agod ubou ab lo dam nek ago mi a. ");
INSERT INTO tbc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iŋ panu titiŋae mi tamol ‘adian’ dupidinai o ilod yen da, agod tamol iŋ niŋedi wo ‘tamol tubun ak’ ago dubol an dam niŋen o dumat da. ");
INSERT INTO tbc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ak man, tamolpein aenta aŋ gurman adi dubol ak ago ta digane na wa. Tia, tamol kisaek o lian man aŋsam gurman, agod aŋ fidian man nug tein taon amado da. ");
INSERT INTO tbc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tan en lo talpein ta aŋ tamami ak ago ta abol na wa. Man dugo, Tamol kisaek o lian iŋ aŋ tamami, amaiak kumaen panu lo imado da. ");
INSERT INTO tbc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Agod tamolpein aenta iŋ aŋ girek maŋau adi ak ago ta dubol na wa, man dugo, aŋ girek maŋau kisaek o lian am da ya, iŋ Kristus. ");
INSERT INTO tbc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tia, aŋ luluŋam lo man, enti iŋ malan te yan, aŋ fidian sam urat tamol ago ilasap imado wa. ");
INSERT INTO tbc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tamol iŋ sen yaŋan yabisa dan, iŋsan yaŋan an yau idu wa. Tamol iŋ sen yabi idu dan, yaŋak tubun ak iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Aŋ tamolpein naod na Anut san kagin panek aben an san dalawan afutani da. Aŋsem ta aladu na da, ago dugo tamolpein a diladu wo dan, nek amaiak aŋ sad dal afou da. ");
INSERT INTO tbc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Aŋ pein suos sad ab agam da, agod gudanek milaen kasik, tamolpein diliaŋ o agane da. Amaiak niŋen o naon a aŋane wan nen tubun mi ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Aŋ weiŋ abi dak, agod tan na dam ator dak, tamol ta kisaek o lian abaŋ an ale dop, an lo aganep, Juda sad dal iri san tamol ago ilasa wa. Gug saen aŋ tamol naok ago yak ale dop, nek ibol aŋsem Ades lo aup amado wak igo, iŋ dam Ades lo yaup imado wan niŋen o tubun geig iriŋanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aŋ malam itapul amami a, muruan tubun geig ak aŋane wa. Aŋ tamol malad itapul an ak dal akubiai pidinai dak gug aŋsem mi malam itapul an a. Aŋ igo abol da, ‘Tamol ta iŋsinan ru dabai ipani wo, tempel san yaŋan lo lak na geig ibol tap, iŋsan promis Anut ipani an man kawan a. Ak gug iŋ tempel san gol ilon lo yen dan san yaŋan lo lak na geig ibol tap, gidad promis a ibol ak ago mi iri wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aŋ mala tapul buraurau! Ata mel malan te yak i? Ak dugo, gol malan te yak i? Tia, tempel an san gol gun igane damaiak malan te yak i? ");
INSERT INTO tbc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Taida mi aŋ igo abol da, ‘Tamol ta iŋsinan ru dabai ipani wo, alta san yaŋan lo lak na geig ibol tap, iŋsan promis Anut ipani an man kawan a. Ak gug iŋ lou panek a alta fufo yen dan san yaŋan lo lak na geig ibol tap, gidad promis a ibol ak ago mi iri wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aŋ malam itapul amami a! Ata mel malan te yak i? Ak dugo, lou panek an malan te yak i? Tia, alta a lou panek an gun igane damaiak malan te yak i? ");
INSERT INTO tbc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","An niŋen o tamol iŋsinan ru dabai ipani wo alta san yaŋan lo lak na geig ibol tap, melmel a alta fufo na dien dan lo dam sinan ru dabai ipani da. ");
INSERT INTO tbc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nek ago mi, tamol iŋ tempel san yaŋan lo lak na geig ibol tap, iŋ tempel agod Iŋ a ate imado dan sisem sad yaŋad lo dam lak na geig ibol da. ");
INSERT INTO tbc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Agod tamol a sinan ru dabai ipani wo kumaen panu san yaŋan lo lak na geig ibol dan, Anut san badim lo, agod Iŋ a badim an fufo imasi dan lo dam, lak na geig ibol da. ");
INSERT INTO tbc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Abi san pinapaŋ kititik wei mi abitig malan 10 dilasa ya, agog malan kisaek Anut apani a. Ak man aŋ kubiaeŋ san ru malan te yak, nek ibol kot lo atarpasai uyanan dak, aenta ilom imuŋanai dak, agod aŋsiganem ru aganuri dan, kagin naok naok ago yak ari san niŋen o kagin ta apani na da. Kagin malan te yak agane wa, agod kubiaeŋ san ru kagin kititik dam ta abisei na wa. ");
INSERT INTO tbc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aŋ gurman adi, aŋ malam itapul ami a! Aŋ tuor fufo na gubudai akudai da, gug ta aloŋ dugo kamel atuŋali da! ");
INSERT INTO tbc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Aŋ gab iŋ daeg da, tinid patud fo yak mi afulani da, ak man ilodi nun tinan a. Aŋ ilo sek san kagin, agod ilo masa san kagin abituani san ta idaisuda na ya, kagin sisaiak an aŋ ida isuda geig a. ");
INSERT INTO tbc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Oŋ Farisi, oŋ mala itapul an a! Oŋ imug gab ilon fulani uyan a, ago gup tinin patun fufo na yak dam ikok aman ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Aŋ bem milkouk ak nam mutou san ab diabi ak igo woŋ a. Kuai te man mutou an san leil siŋaokan mok a, ago gug ilon lo man tamol dumat ak sad tatumadi, iŋ melmel nun amad da yak wei mi dam dida awa nag dien da. ");
INSERT INTO tbc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aŋ dam nek ago mi amado da. Tamolpein malad lo aŋanem nao lalek man uyanan manoŋ a, ak gug ilomi man, balek rararu san kagin iŋ kubiaeŋ pilalek kagin da awa nag yen da. ");
INSERT INTO tbc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Aŋ kubiaeŋ san girek maŋau, Farisi dida man, muruan tubun geig ak ale wa. Aŋ tamol awam rararu amam mi a! Man ata wo? Aŋ profet sad mutou san ab abi da, nek ago mi tamol uyadi ak sad mutou dam bala apani da. ");
INSERT INTO tbc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Agod aŋ igo abol, ‘Maŋ tubum bagem sad saen lo mumado yak man, maŋ iŋ luad masap mibinawaip sisem profet ta mafu dumat na wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ru amaiak lo aŋ sem ibiaŋ adu da, man dugo, aŋ kuai tem tamolpein akubiai pidinai dak aŋsem man, tamol ensauta a profet adi dufu dumat na yan, amaiak sad nanud muroud mi a. ");
INSERT INTO tbc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Amaiak niŋen aup, kagin naok a tubum bagem digane se yan, ago mi aganep idaisuda wa. An lo dop kob a iŋ ante dilasa yan aŋ dam ante alasa wa! ");
INSERT INTO tbc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“O aŋ mot adi, mot wagai ak sad nanud muroudi! En dugo woŋ Anut aŋ Ades lo au o irupaiaŋ an abiseip asol au ak i? ");
INSERT INTO tbc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Fun amaiak niŋen o ŋai profet adi ŋidinai dugo, maŋau tamol adi, agod girek maŋau adi, dupalu dugo aŋsam na dilasa da. Ago bo man aŋ aenta afu dumat a, aenkadi aigim fo abalai a, aenkadi sinam ubou ab ilod lo asukutai a. Aenkadi akudaip taun an dibiseip taun sen ak lo diau a, kagin nek agom digane yau a. ");
INSERT INTO tbc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Fun an niŋen o, tamol uyadi fidian a tan en lo ager adi banid lo mateŋ dile yan, kagin amaiak san ai wadan Anut aŋsem mi ipanaŋ a. An man aŋsinam muruan mi a. An lo Abel imat ak san saen log ipalug kiŋ Joas san saen lo, Sakarias iŋ Berekaia nanun tempel san galuŋ gun ak, alta da titiŋae mi tubum bagemi dufunig imat a, kagin an san ai wadan man aŋsiganem muruan mi a. ");
INSERT INTO tbc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ŋai ru rumok ak ŋurupaiaŋ da, kagin sisaiak fidian en sad naon saian ak tamolpein gamu dumado den sad na ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem, oŋ profet ufu dumat na ya, oŋ tamol a Anut idinaig oŋsa na dupalu na yan ufu wo pat ubal na ya! Saen sapta, nek ibol kurek tinan subarin roun paen na nanun ituanai o dak ago mi, ŋai oŋsa nanu murou ŋutumanaip kagin ŋupidinai o, ilog tubun mi yen da. Ak gug aŋ amoi a. ");
INSERT INTO tbc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ale, Anut aŋanem tempel ibisei la ya, an lo aŋanem ubou ab man kawan yen da. ");
INSERT INTO tbc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Man dugo, ŋai igo ŋurupaiaŋ da, aŋ fon ŋai ta aliag na wa. Tia, saen aŋ abol, ‘Tamol e Tubun ak yaŋan lo ipalu den bar mupani da,’ an san saen lo mi afon ŋai aliag da wa.” ");
INSERT INTO tbc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus tempel ibiseig yau dugo, iŋanen megeloum tempel san ab funfun naodi dugo yak dukubiai ile wo san na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ak man iŋ ru naon ago irupidai, “Aŋ mel en fidian mi ale yak i? Ŋai ru rumok ak ŋurupaiaŋ da, ente man pat ta kisaek o lian pat sen ak tinin fufo na ta yen na wa. Tia, murnap tamol adi dupalup tempel en fidian daoŋ dupani wa, ago dop tempel san pat fidian dugufututep diabibol tan na dudu wa.” ");
INSERT INTO tbc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus Did Oliv fo imasi dugo iŋanen megeloum mianuk lo san na dupalug dubol, “Oŋ rupaiama wa, saen dugomaiak lo melmel en dilasa wak i? Mel dugomaiak imug ilasa dop, ate maŋ maloŋ ak, oŋ umul palu o di? Agod saen gamu e tumado den itout o di?” ");
INSERT INTO tbc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus ru naon igo irupidai a, “Aŋ kagin agane, kabelan tamol ta aŋ irawaŋ banau. ");
INSERT INTO tbc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tamol wei mi dupalup ŋai yaŋag dupatep dubol a, ‘Ŋaiseg Kristus.’ Ago dop tamolpein wei kasik dirawai a. ");
INSERT INTO tbc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aŋ yu ager aloŋ ak, agod ru tim yu ager sensen yau oŋ an dam aloŋ a. Aŋ kagin agane wa, kabelan amasa saian banau, man dugo, mel an ilasa wak, ak gug nal wadan san saen man gamugo da. ");
INSERT INTO tbc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tamol malan ta yu diabisa dop, tamol malan ta yu naon iŋsad na digane imul a. Ago dop kiŋ ta iŋsan tamolpein dida yu diabisap, kiŋ sen ak ta iŋanen tamolpein dida nug dufuni wa. Agod aben sensen lo man kadag tubun mi idu dop kanaurig tubun ak gidigidad dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nek ibol pein nanuk igansi wo dop madai ile dak igo woŋ, melmel en fidian man, madai a nal wadan ilasa san amaiak ilasa wo fun igane da. ");
INSERT INTO tbc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Saen an lo gup aŋ diŋiliaŋ pe aŋanem ager sad tuod lo didiraŋ dop madai tubun kasik dupanaŋ a, agod dam dufunaŋ amat a. Tamolpein tan titin fidian lo dumado dan aŋ lo siai digane wa. En ata wo? Ŋai yaŋag man aŋsam na yen la ya. ");
INSERT INTO tbc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nek saen an lo dop, tamolpein ilo rumok dubusei wa, ago dop teidi ager tuod lo didirai a. Nug lo ago digane dop siai dam digane wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ago dop profet sewak adi dumasap tamolpein wei mi dirawai a. ");
INSERT INTO tbc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ago dop kagin sisaiak tubun mi ilasap ilod iŋanefute wa, an lo dop tamolpein wei kasik sad ilo panek kagin an kute ibol yaup ibubarum geig a. ");
INSERT INTO tbc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ak man, talpein enti iŋsan ilo rumok yabi sakar dop, yaup iŋanen kumaen tan en san itout gup man, Anut talpein an patun ipasi wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Agod ŋaineg tamolpein bilaluŋ uyanan Anut anen kagin panek niŋen o dubol ilasap, tamolpein tan titin fidian lo yan duloŋ a. Ago dop ŋaineg ru rumok tamolpein fidian malad lo walal te ilasap yen a. Ante gup, nal wadan ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Saen ilasa dop, mel ta tempel san aben gun ak lo duguni dop ale wa. Mel an gubak mi profet Daniel niŋen o ibol a. Mel an Anut malan lo man iganan geig a, nek mel amaiak igane dop daoŋ panek ilasa wa. (Oŋ ru e suti den uloŋ uyan o ta pasauman na yak man, maeg gane tap ka uloŋ ak boi.) ");
INSERT INTO tbc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nal an lo dop, tamolpein a Judea na dumado dan, dusol diaup did luluŋad lo sed imianai a. ");
INSERT INTO tbc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Talpein ab fufo na imado dan, imul idup iŋanen biouŋ isini wo ta iladu na wa, tia, itaot mi isol yau a. ");
INSERT INTO tbc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Agod talpein abi lo imado dak dam, kulos madid san ak iŋane wo ta imul yau na wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","O kabel, nal en san pein luam anda yak, agod aŋ pein aŋanem nanuk su apidinai dan dam, ŋai ilog tubun mi imuŋanaŋ da! Nal en man saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aŋ gidad agudani wa, man dugo, kabelan aŋ madid san saen lo, tia, ubou nal lo asol au banau. ");
INSERT INTO tbc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Man ata wo? Saen an lo dop muruan tubun geig ak ilasa wa. Muruan naok ago yak gubak mi ta ilasa na ya, saen tan en ilasag ipalug gamu en lo, mel igo yak ilasa man tia geig a, agod murna gup afon ta ilasa da na wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anut saen en itutep katukan a, iŋ ago ta igane na tap man, tamolpein fidian mi dideg diau a. Ak man, saen an lo dop Anut tamolpein a ipilianai la yan niŋedi wo ilon isou wa. Amaiak niŋen o iŋ saen an itutep katukan a. ");
INSERT INTO tbc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Saen ante talpein ta irupaiaŋ a, ‘Ale, Kristus ebe ya!’ Tia, ta ibol, ‘Iŋ obo imado da!’ Ago dubol tap, aŋ ilom ta rumok na wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Man dugo, kristus sewak, iŋ profet sewak adi dida dilasa wa, ago dop iŋ kulob girager tubun ak, agod mel naon senamo geig ak tamolpein malad lo dukubiaip dile wa. An lo dop iŋ tamolpein a Anut ipilianai la yan dam dirawaip lo diau dudu wo ago maeg digane wa. Ago bo man dirawai san ta idaisuda na wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ale, mel en gamugo ilasa dugo ŋai imug an niŋen o kuai tem ŋurupaiaŋ la ya. ");
INSERT INTO tbc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Amaiak niŋen o talpein ta aŋ durupaiaŋ pe dubol, ‘Ale, iŋ onte aben kawan talpein tia yak ate imado da!’ Iŋ ago dubol tap, aŋ ante ta au na wa. Nag igo dubol, ‘Ale, ab on san galuŋ ilon lo mok imado da!’ Aŋ ilom ta rumok na wa. Tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Man ata wo? Saen keit irafule dan, san lilaman aben o ad ilasa dak atep, aben o ad idiau dak ate yau dop, tamolpein fidian leil dupani wa. Nek ago mi, saen Tamol Nanun ipalu dan, kulob an san leil man naon kisaek a. ");
INSERT INTO tbc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tamol sisanun dugon te yen dak ate bog dupalup dutumani wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Saen muruan tubun en itout dop, ad ta ided uyan na wa. Saen an lo ‘adian tidom oŋ ilasa wa, ago dop kalam dam ta ided na wa. Ante patui keit dibiseip dudu wa, agod Anut mel dabai a keit lo yan fidian imiriranai a.’ ");
INSERT INTO tbc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Saen an lo dop, Tamol Nanun san kob keit lo kuai isi wa, an lo dop tan en san tamolpein fidian tinaŋ aru digane wa. Ago dop iŋ fidian Tamol Nanun keit lo timtaen titiŋaem kuai te ilasa dop, dabai agod girager tubun geig ak da ipalu dan, dile wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ago dop eŋel ta tour iwip Tamol Nanun iŋanen eŋel adi idiraip dufurak diau a. Ante dop iŋanen tamolpein a ipilianai an dutumanai a. Iŋ tim sukurun iwoiwo, agod tan tilianek fidian dam ante diŋal dupalu wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Aŋ gurab niŋen o ilo sou agane wa, iŋ maŋau ka ipanaŋ a. Saen iŋsan raen you aman da dop, roun foun ak ilasa wa. An lo ale aloŋ ak madid itout agod ad ilasa san saen sumeikan ipanaŋ da. ");
INSERT INTO tbc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Amaiak niŋen o, aŋ murnap melmel fidian a dilasa dan ale dop, aŋ aloŋ ak Tamol Nanun ipalu wo dak, sumeik dalawan te itur da. ");
INSERT INTO tbc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ŋai rumok ŋurupaiaŋ da, warou gamu en san tamolpein gamugo itout yau dop melmel en fidian dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Rumok geig, keit iŋ tan da murnap itout a, ak gug ŋaisag ru man ta itout na wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ak gug talpein ta auwa dugo, agod nal dugon lo melmel en dilasa wan ta iloŋ na wa. Kumaen panu san eŋel adi agod Nanun dam ta duloŋ na ya. Bai sen mi iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kulob a Noa san saen lo digane yan, nek amaiak mi saen Tamol Nanun imul ipalu dop digane wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saen lom tubun ak ta ilasa na dugo, iŋ anaŋ diani dugo, you dam duluk dugo, nug diŋane dugo, pein ŋiedi dupidinai dugo, yaug saen Noa wog tubun ak lo iladu ya. ");
INSERT INTO tbc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iŋ ilo girek amad tia dumado dugo, lom tubun ak ilasa saltik oŋ go tamolpein an fidian irianai diaug dumat pasik a. Nek ago mi, saen Tamol Nanun ipalu dop, tamolpein ta duloŋ na dop kulob an iŋ lo ilasa saltik oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Gidad tamol uraru abi lo dumado wa. Ago dop Anut tamol kisaek iŋane dop, kisaek ibiseip imado wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pein uraru bret dukubune wo pat nam wit patun dibaltitale wa. Anut kisaek iŋane dop, turan ibiseip imado wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Amaiak niŋen o malam ipuk pe amado wa. Aŋ ta aloŋ na dak, nal dugomaiak lo aŋanem Tubun ak ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aŋ mel en niŋen ilo sou agane wa. Ab taman iŋ saen dugon lo gumagam tamol tidom lo ab igilep ilon lo iladu wan iloŋ tap, iŋ ŋioŋ ta yabi na wa. Tia, tawaŋ igane uyanan pe gumugam isadu san dal ifou wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ago yak niŋen o aŋ dam malam ipuk pe abaŋ ale wa. Man dugo, saen a Tamol Nanun ipalu san aŋ an ta akubiani na dop, saen nek an lo iŋ imul ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Amaiak niŋen o mel en niŋen o ilom isou wa. Ab taman ta iŋsan urat pinein a maŋau aman da yak, agod awan iri ipani dan, kob ipanig an lo iŋ iŋanen urat pinein aenta itirnai san, agod anaŋ diani san saen ante mi anaŋ ipidinai da. Ak dugo, aŋ luluŋam lo man, enti iŋ urat pinein naok ago yak i? ");
INSERT INTO tbc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Saen ab muroun ipalup urat pinein an iŋsan urat igane uyanan dan ile tap, iŋ lo uyan a. ");
INSERT INTO tbc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ŋai rumok ŋurupaiaŋ da. Tamol tubun en iŋanen urat pinein emaiak kob ipanip, an lo iŋanen biouŋ fidian kagin ad igane wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ak man urat pinein an tamol saian tap, ilon lo igo ibol, ‘Ŋaisag tamol tubun en ta ipalu kisaek oŋ na da.’ ");
INSERT INTO tbc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","An niŋen o fun iganep urat pinein aenta ifu isudap, lukluk tamol dida anaŋ diani dop, you sakar ak duluk o kagin naok ago igane wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Urat pinein an san gurman, nal dugon lo, agod auwa dam ta iloŋ na dop ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","An lo dop tamol tubun en ipalu saltik oŋ pe urat pinein an ibaltiti idu wa. Ago dop balek rararu san tamol luad te iganep dida dumado wa. Aben ante man tamolpein tinaŋ digane dop madai lo luod dugurmi wa. ");
INSERT INTO tbc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Saen an lo, Anut san kagin panek man igo ya. Nug ŋanek san saen lo, pein baras 10 iŋsad lam dusulanaig duburoug diaug, ab a ate tamolpein dutumani dan te dilasa ya. Ante man kuai te dumasig tamol a iŋsan iwon iŋane wo ipalu dan dititianig dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pein baras nuŋod 5 man kankan ad tia ya, ago dugo 5 aenta man kankan ad da ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Man dugo, pein baras kankan ad tia yak iŋsiganed lam disinig dupalu yak gug, iŋ gureŋ ided san subuŋan taidam ta diŋaneg dupalu na ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ago man pein a kankan ad da yan gureŋ ided san iŋsiganed butol lo dililig lam da disinig dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tamol a iwon iŋane dan, iŋ ta ipalu kisaek oŋ na ya, amaiak niŋen o pein fidian mi malad muruan dugo ŋioŋ diabi se ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ak man tidom luak talpein ta igo iwagiŋ dugo duloŋ a, ‘Ale, tamol, pein iŋane wo damaiak ipalu wo da! Amaiak niŋen o apalup tau, dal te tile dop tiŋanep ida tamul tupalu wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ago man pein baras an fidian dumasag iŋaned lam dukubine idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Agog pein kankan amad tia yan dumasag, pein kankan amad da yan igo durupidai, ‘Gidad aŋsam gureŋ kitek apanama. Maŋsama lam dumat o da.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ak gug pein kankan amad da yan ru naon durupidaig dubol, ‘Tia ya, gureŋ e mabi den, id sisem niŋed o ta idaisuda na ya. Gidad amul aup aŋsiganem gureŋ foun ak didaeŋ aben lo adad a.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“An niŋen o pein kankan ad tia yan gureŋ didad o dumul go diau a. Iŋ diau dugo tamol a iwon pein iŋane wan ipalu ya. Ante man pein a dititianig dumado se yan, dida nug ŋilaŋal san ab an lo diladu dugo, tamol ante yan dalawan dufutani a. ");
INSERT INTO tbc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Murnag pein baras aenta dupalug igo dubol, ‘O tamol tubun ak, palup maŋ dalawan pasi panama!’ ");
INSERT INTO tbc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ak man iŋ ru naon igo irupidai, ‘Ŋai rumok ŋurupaiaŋ da, ŋai aŋ ta ŋaloŋ na ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Amaiak niŋen o malam ipuk pe amado wa. Man dugo, nal dugo, agod auwa dugon lo Tamol Nanun imul ipalu wan ta aloŋ na da.” ");
INSERT INTO tbc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Agod fon, murna dop Anut san kagin panek nek igo wa. Gurman ta tureŋ yabi wo dak niŋen o iŋanen urat tamol igiaig dupalu ya. Agog naon na dilasa man iŋanen melmel an kagin dupani san tuod lo yabitig ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iŋanen urat tamol kisaek kisaek iŋsad kagin, agod dabai dam, niŋen o ilon isou dugo moni yabitig ipidinai a. Tamol ta 5,000 kina ipani dugo, ta 2,000 kina, ago dugo ta 1,000 kina ipani a. Iŋ ago igane itout go ibisawaig tureŋ yabig yau a. ");
INSERT INTO tbc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iŋ yau dugo, tamol 5,000 kina iŋane yan yau kisaek oŋ go, moni subuŋan taida an fufo igane wo didaeŋ urat igane se ya. Agog 5,000 kina subuŋan taidam iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tamol a iŋ 2,000 kina iŋane yan, iŋ dam nek ago mi iganeg 2,000 kina taidam iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ak gug tamol a 1,000 kina iŋane yan, yaug tan gib yabig ilon lo moni an imianig yen a. ");
INSERT INTO tbc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Saen milaen kasik yau la gug, gurman an imul ipalu ya. Saen ipalu man urat tamol an igiaig moni ipidinai amaiak niŋen o, dida ru dukubuneg diŋiŋeŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ago dugo tamol 5,000 kina iŋane yan, 5,000 kina subuŋan anda isinig ipalug igo ibol, ‘Ŋaineg gurman, 5,000 kina e panag en ule, ŋai didaeŋ urat ŋiganeg oŋane 5,000 kina subuŋan taidam ŋiŋane ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Iŋanen tubun ak igo irupei, ‘Oŋ urat tamol uyanan mok a, awag uri pani siŋaokan, oŋane urat dam kagin pani uyanan a. Oŋ melmel kititik e bani lo ŋigane emaiak kagin pidinai uyanan a, amaiak niŋen o melmel tubun geig ak wei mi tirnai san ŋupano wa. Palup, ŋai da uyasusai tigane.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tamol 2,000 kina iŋane yan dam ipalug ago ibol, ‘Ŋaineg gurman, oŋ 2,000 kina panag a. Ule, ŋai didaeŋ urat ŋiganeg oŋane 2,000 kina taidam ŋiŋane ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Iŋanen tubun ak igo irupei, ‘Oŋ urat tamol uyanan mok a, awag uri pani siŋaokan, oŋane urat dam kagin pani uyanan a. Oŋ melmel kititik e bani lo ŋigane emaiak kagin pidinai uyanan a, amaiak niŋen o melmel tubun geig ak wei mi tirnai san ŋupano wa. Palup, ŋai da uyasusai tigane.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ak man tamol iŋ 1,000 kina iŋane yan dam ipalug ago ibol, ‘Ŋaineg gurman, ŋai ŋaloŋ ak man oŋ tamol silei a. Oŋ abi san urat tamol sad silali naon ŋane da. ");
INSERT INTO tbc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Amaiak niŋen o ŋai ŋarer go, oŋane 1,000 kina ŋisini ŋaug tan ŋisareg ŋimiani a. Ule, oŋane moni ebe ya, ka ŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ak man iŋsan gurman ru naon igo irupei, ‘Oŋ urat tamol saia geig a. Oŋ yalis tina ya. Oŋ uloŋ ak, ŋai abi san urat tamol sad silali naon ŋiŋane da. ");
INSERT INTO tbc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Fun an niŋen o ŋaineg moni an moni ab san urat tamol pani ak man, iŋ ka urat ipani wa, an lo moni en san tim anda ŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Agog gurman an iŋsan urat gurman irupeig ibol, ‘Aria, tamol an san na 1,000 kina ŋanep, tamol a 10,000 kina aman da yan pani wa. ");
INSERT INTO tbc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ata wo? Talpein enti iŋ da yan, ŋai suguan taidam ŋupanip an lo iŋ idaisuda wa. Ak man, enti iŋ tinin lo tia agod, gidad iŋ kitek da bo man, iŋsan melmel an banin lo dupasi itout a. ");
INSERT INTO tbc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Urat tamol lou aman tia yan wabip ubal patun fo ilasap tidom tubun lo imado wa. Aben ante man tamolpein tinaŋ digane dop madai lo luod dugurmi wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Saen Tamol Nanun iŋanen girager aman da lo ipalu dop iŋanen eŋel adi fidian dida dupalu wa. Ante iŋanen kiŋ san badim fo na imasip imado wa. ");
INSERT INTO tbc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ago dop iŋ tan titin fidian sad tamolpein itumanai dop naon na dutur a. Ante dop iŋ itarpasaip malan uraru lo idirai a, nek ibol titianek tamol sipsip sen idirai dop bilelek sen idirai dak ago mi a. ");
INSERT INTO tbc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An lo dop iŋ sipsip tuon won ak ate idiri dop, bilelek tuon ŋas ak ate idiri wa. ");
INSERT INTO tbc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Agop Kiŋ tamolpein a tuon won ak ate dumado dan, igo irupidai, ‘Aŋ ŋaineg Bai san bar aŋane ya. Apalup kagin panek aben e Anut fun lo mok tan igane ilasa wo dugo ikubuneg yen den aŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Enta wo? Gubak mi ŋai kadag lo ŋumado dugo anaŋ apanag a. You o ŋamat dugo you dam apanag a. Ŋai tamol gol ak gug aŋ aŋiliag go aŋsam ab lo tau a. ");
INSERT INTO tbc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ŋai kulos amag tia yak gug, kulos apanag a. Ŋai subam amag da yak gug, kagin apanag se ya. Ŋai subanek lo ŋumado dugo, aŋ bubeg abisa wo apalug aliag a.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Agod tamolpein itaotan ak ru naon igo durupei, ‘O Tubun, saen dugon lo kadag ifuno dugo miliog, anaŋ mupano yak i? Tia, saen dugon te you o umat dugo you mupano yak i? ");
INSERT INTO tbc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Saen dugon te tamol gol ak oŋ milio dugo miŋilio ab lo tau ak i? Ago dugo saen dugon lo kulos ama tia dugo miliog kulos mupano yak i? ");
INSERT INTO tbc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Saen dugon lo subam ifuno dugo milio boi, tia, subanek lo mado dugo maug milio yak i?’ ");
INSERT INTO tbc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Agop Kiŋ ru naon igo irupidaip ibol, ‘Ŋai rumok ŋurupaiaŋ da, kulob dugo ŋai teig e yaŋan tia yen lo agane man, kulob ago agane yan, an ŋai lo dam ago agane ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Agop iŋ aenta tuon ŋas ak ate dumado dan igo irupidai, ‘Aŋ tamolpein Anut san misilanek am da ya, abisawag sen alasap, yai o ta imat na dan lo au a. Yai an man Satan iŋanen eŋel adi dida lo idiraip diau o Anut ikubune pidinai lag yen da. ");
INSERT INTO tbc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Man ata wo? Gubak mi kadag ŋai ifunag dugo anaŋ ta apanag na ya. Ŋai you o ŋamat dugo you ta apanag na ya. ");
INSERT INTO tbc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ŋai tamol gol ak gug, aŋ aŋiliag go aŋsam ab lo ta tau na ya. Ŋai kulos amag tia yak gug, aŋ kulos ta apanag na ya. Ŋai subam amag da subanek lo ŋumado dugo, aug ta aliag na ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Agop iŋ dam ru naon igo durupei, ‘O Tubun en, saen dugon lo kadag ifuno boi, tia, you o umat boi, tia, oŋ tamol gol ak oŋ boi, tia, oŋ kulos ama tia, subam ama dag, subanek lo mado dugo milio gug, maŋ kagin ta mupano na yak i?’ ");
INSERT INTO tbc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ante dop iŋ ru naon irupidaip ibol, ‘Ŋai rumok ŋurupaiaŋ da, kulob dugo ŋai teig e yaŋan tia yak lo ta agane na yan, nek kulob an ŋai lo dam ta agane na ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Agop tamolpein an dibiseip diaup ai wadan saian geig saen fidian yen dan lo diladup ante pempem mi dumado wa. Ak man tamolpein itaotan ak kumaen pempem san diŋanep dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus ru mitilaen en fidian ibol itout go iŋanen megeloum irupidaig ibol, ");
INSERT INTO tbc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Aŋ aloŋ ak, Pasova san ad nanek idu san man nal uraru mi yen da. An lo dop Tamol Nanun ager banid lo diganep aigim fo dubali wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Saen an lo pris tutubu, agod Isrel san tamol gurman adi, pris gurman yaŋan Kaiafas dubol dak san ab lo dutumani a. ");
INSERT INTO tbc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Iŋ Jesus pasak nam dirawi nap diabip dufuni imat o dukubiai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ak man iŋ dubol, “Id tumanek gun ak san nal lo kulob en ta tigane na wa, kabelan tamolpein luluŋad lo ager diabisa banau.” ");
INSERT INTO tbc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus iŋ Betani panu na imado dugo, tamol ta yaŋan Saimon tinin gubak mi lepra aman da yak iŋsan ab lo ida dumado ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ago dugo pein ta gureŋ, butol ta pat siŋaokan ak nam digane yak, isinig san na ipalu ya. Butol an ilon lo gureŋ naon lak na geig ak awana ya. Jesus tebol siŋiren na imasi dugo pein an ipalug gureŋ an kabuŋan fufo na iwali a. ");
INSERT INTO tbc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Saen iŋanen megeloum ago dile man, tiŋaed saian go igo dubol pein an dusumiani, “Enta wo gureŋ kawan bidani dak i? ");
INSERT INTO tbc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gidad tubuseip, didaeŋ lo tiganep moni naon tubun ak lo didad dop moni an tiŋanep tamol filiad tia yak ka tupidinai a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus iŋsad ŋiŋeŋ an iloŋ go igo ibol irupidai, “Enta wo pein en muruan apani dak i? Iŋ man ŋai niŋeg o kulob siŋaokan geig ak igane ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Saen fidian tamolpein filiad tia yak aŋ luluŋam lo dida amado wa, ak gug ŋai man saen milaen aŋ da ta tumado na wa. ");
INSERT INTO tbc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pein iŋ ŋai tinig fufo gureŋ iwali an, nek kagin an lo man iŋ ŋaisag sisanun mutou lo diginiag amaiak san dal ikubune da. ");
INSERT INTO tbc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ŋai ru rumok ŋurupaiaŋ da. Tan dugon te bilaluŋ uyanan en dubol ilasa wan, ante dam kulob a pein en igane yan niŋen o dubol ilasap, lo pein en niŋen o ilo sou digane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Saen an lo, nuŋod 12 amaiak luluŋad lo, tamol kisaek yaŋan Judas Iskeriot amaiak pris tutubu yak sad na yau a. ");
INSERT INTO tbc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ante iŋ igo ibol, “Aŋ ata mel ta ŋai apanag dop, ŋai Jesus tuom lo ŋigane wak i?” Ago man moni silva 30 an dupani a. ");
INSERT INTO tbc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Agog Judas imasag, Jesus tamol tutubu yak tuod lo igane wo, dal an abaŋ yabi se ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tumanek a yaŋan bret yis an tia yak san nal malan te yan lo, megeloum adi Jesus san na dupalug ago dubol, “Oŋsa ilo lo, maŋ dugon te melmel mukubinep oŋ ate tumanek an san anaŋ wani wo rupaiama dak i?” ");
INSERT INTO tbc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ago dugo iŋ ibol, “Aup Jerusalem na aladup tamol ta ŋai ŋaloŋ ak naon na alasap, igo arupei, ‘Girek maŋau igo ibol a. Ŋaisag saen ipalug sumeik la ya. Oŋsa ab lo ŋaineg megeloum dida tumanek anaŋ mani wo da.’” ");
INSERT INTO tbc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ago tag megeloum ru kagin Jesus irupidai an dirig, anaŋ dukubune ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gurai idu dugo Jesus tebol siŋiren na imasig, nuŋod 12 an dida dumado ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Iŋ anaŋ diani dugo igo ibol, “Ŋai rumok ŋurupaiaŋ da. Aŋ lulaŋam lo tamol kisaek, ŋai ager adi tuod lo iginiag ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","An lo na ilod muruan geig dugo, anen anen dusumianig dubol, “O Tubun ak, ŋai i?” ");
INSERT INTO tbc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ago dugo iŋ ru naon irupidaig ibol, “Tamol nek a daeg lo ŋai da sisem banima musomini dan, nek amaiak ŋai ibilag pe ager banid lo ŋilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tamol Nanun ru a iŋ niŋen o buk lo digire yan nek ago mi iŋ lo ilasa wa. Ak gug tamol enti a Tamol Nanun iganep iŋanen ager adi sad tuod lo ilasa wan, rumok iŋ muruan tubun kasik ak ile wa! Gidad tinan ta igansi na yak man, an uyan a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Agog Judas, tamol iŋsen Jesus ager tuod lo igane yan, igo ibol isumiani, “Girek maŋau, ak ŋai i?” Jesus irupeig ibol, “Awo, nek oŋse ubol la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aria, iŋ anaŋ diani dugo Jesus bret iŋaneg, Anut ilo uyan ru ipanig yafuteg, iŋanen megeloum adi ipidinai dugo ibol, “Aŋ aŋanep ani, en man ŋaineg tinig.” ");
INSERT INTO tbc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Agog iŋ gab wain anda yak iŋaneg, Anut ilo uyan ipanig, ipidinai dugo ibol, “Aŋ fidian gab en lo aluk a. ");
INSERT INTO tbc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","En man ŋaisag dar kontrak san, tamolpein wei mi iŋaned aupasek isasi san tinig lo yak ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ŋai ŋurupaiaŋ da, ŋai afon ai wain san nuŋon lo ta ŋaluk na wa, ago yaup nal ilasa dan te gup, afon Tamag san kagin panek aben lo fon aŋ da sisem taluk a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iŋ bar diabi itout gug kuai te dilasag Did Oliv ate diau a. ");
INSERT INTO tbc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Agog ante Jesus iŋ irupidaig ibol, “Gamu tidom nek en lo, aŋ fidian mi ŋai niŋeg o ilom idup yaup abisawag a. Man dugo, Anut san girek lo ru igo ibol, ‘Ŋai titianek tamol ŋufuni wa, ago dop iŋsan sipsip dusol pe gidigidad diau a.’ ");
INSERT INTO tbc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ak man Anut ŋai ifufunag pe fon ŋumasa gup, ŋai ŋiriŋanaŋ pe imug mi Galili na ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ru naon igo irupei, “Gidad tamol fidian oŋ niŋe wo ilod idup dibisawo bo man, ŋai man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus ru naon igo ibol irupei, “Ŋai rumok ŋurupaio da, gamu tidom nek en lo kurek ta ibob na dop, saen utol oŋ ŋai niŋeg o utot a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Agog Pita irupei, “Gidad, ŋai oŋ da tamat bo man, ŋai oŋ niŋe wo ta ŋatot na wa, tia geig a!” Ago dugo megeloum fidian dam nek ago mi dubol se ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ago man Jesus iŋ dida, aben ta yaŋan Getsemani dubol dan ate diau a. Ante Jesus megeloum irupidai, “Aŋ ente amasip amado dop, ŋai onte ŋaup ŋugudani wo da.” ");
INSERT INTO tbc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Agog iŋ Pita agod Sebedi nanun uraru dida iŋal go diau a. Saen an lo iŋ fun iganeg ilon ipapao dugo ilon dam muruan idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","An lo igo irupidai, “Ŋai ilog tubun mi muruan idu dugo ŋamat o sumeik da. Aŋ gidad igo amado dop ŋai da sisem malad ipuk pe tumado wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ago dugo iŋ kitek ipar yaug, turun isoluwig, kabuŋan idug tan itutig, igo ibol imosiai, “O ŋaineg Bai, idaisuda tap, gab en ŋai banig lo ka pasi yau a. Ak gug oŋ ŋai ilog ta uri na wa, tia, oŋsigane ilo mi uri wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Agog iŋ iŋanen megeloum adi sad na ipalug, ŋioŋ diabi dugo yil a. An lo iŋ Pita irupeig isumiani, “En dugo, aŋ auwa kisaek ŋai da malad kumaen tumado san ta idaisuda na yak i? ");
INSERT INTO tbc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Aŋ malam kumaen amado dop amosiai a, man dugo, kabelan bitinaek ta ipalup ilom iŋanep ari banau. Ŋutum lo man awag yabi wo ilom ibol da, gug tinimi man dabai an tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iŋ afon imul yaug imosiaig igo ibol, “O ŋaineg Bai, gab en ta iriŋanag na dop, gidad ŋaluk a. Oŋane ilo ŋai o an, ago ka ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Saen imul ipalu man ŋioŋ diabi dugo yil a, man dugo, maladi muruan geig a. ");
INSERT INTO tbc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","An lo afon ibisawaig imosiai o imul yau a. Gudanek naok gubak mi igane yan ago mi fon igane da ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Imosiai itout go megeloum adi sad na ipalug igo irupidai, “Aŋ ŋioŋ abi dugo yaes abal oŋ dak i? Ale, ŋaisag saen idu wo da, Tamol Nanun aupasek tamol tuod lo digane san saen idu la ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amasap, tau. Ale, tamol a palaŋ ag imari amaiak ipalu da!” ");
INSERT INTO tbc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Saen Jesus iŋiŋeŋ se man, Judas ipalu ya. Iŋ megeloum 12 ak luluŋad lo aben anda ya. Iŋ ipalu dugo tumanek malan tubun ak dida, sabiri agod tok dam duburoug naon na dilasa ya. Pris tutubu agod Isrel sad gurman adi didinaig dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Imug palaŋ niganag tamol a iŋ tuod lo igane san man, kob ta niŋen o irupidai, “Tamol a ŋai musuk ŋupani dop ale dan, nek an Jesus, aŋ tamol amaiak abi wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aria, iŋ Jesus san na ipalu kisaek oŋ go ibol, “O girek maŋau, tidom uyan.” Ago ibol go musuk ipani a. ");
INSERT INTO tbc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus ru naon igo irupei, “Turag, ilo yen dan ago gane.” Ago ibol go iŋ Jesus sumeik dupanig diabi a. ");
INSERT INTO tbc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ago dugo tamol ta Jesus da dumado yan, iŋsinan sabiri igursig pris gurman an san urat pinein kududon aen ta ituteg tan na idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ak gug Jesus irupei, “Oŋane sabiri gane imul a. Man dugo, tamol fidian a sabiri duburoup lo wagai digane dan, sabiri lo nam daoŋ diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aŋ dugo ilom isou di? Ak dugo, ŋai Tamag ŋusumiani dop, eŋel malan 12 agod suguan taidam wei kasik dida ipanag kisaek oŋ o imoi ak i? ");
INSERT INTO tbc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ak man ŋai ago ŋigane tap, en dugo woŋ ru a Anut san buk lo, kulob gamu e ilasa wo ibol en, nuŋon ilasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Saen amaiak lo Jesus ager tamol an igo irupidai, “Enta wo aŋ sabiri iŋ ai tok da asinig aliag pe abiag o apalu yak i? Ak dugo, ŋai wagai adi dida gabman mabi idu san gurman igo woŋ aŋ ago ilom isou di? Nal fidian ŋai tempel aben lo ŋumasi dugo tamolpein ŋupiteŋanai se ya, ak gug ŋai ta abiag na ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ak man melmel en fidian ilasa san fun man, ru gubak mi profet adi digire yan gamu en nuŋon ilasa ya.” Agog megeloum fidian mi Jesus dubuseig dusol go diau a. ");
INSERT INTO tbc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tamol a Jesus diabi an, diŋaneg pris gurman Kaiafas san ab lo diau a. Kubiaeŋ san girek maŋau, agod pris tutubu dida imug mi diaug ab ante dutumanig Jesus dititianig dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ak man Pita Jesus ŋien aban irig yau ak gug, iŋ kitek asau mi imado ya. Iŋ pris gurman san ar lo iladug ai katuk adi dida dumado ya. Iŋ ata mel ta Jesus niŋen o ilasa dop ile wo malan igane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris tutubu, agod kaunsil fidian mi, tamol aenta digiaig sewak ru dubol dop, Jesus kagin saiak ta igane yak, ate dufunip imat san dal ta dile wo dukubiai se ya. ");
INSERT INTO tbc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ak man tamol wei mi sewak ru amad da yan naod na dilasa bo man, dal ta dile na ya. Ak gug murnag tamol uraru dupalug naod na dilasa ya, ");
INSERT INTO tbc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","iŋ ago dubol, “Tamol en igo ibol a, ‘Ŋai dabai amag da yak lo Anut san tempel ŋurubep, nal utol lo mi foun ak ŋabisa wa.’” ");
INSERT INTO tbc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ago man pris gurman imasag Jesus igo isumiani, “Oŋ ru naon ta ubol na wak i? Ru e oŋ niŋe wo tamol emaiak dubol den dugo yak i?” ");
INSERT INTO tbc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ak man Jesus ru ta, ta ibol na ya, itokibol itur se ya. Ago dugo pris gurman irupei, “Ŋai Anut kumaen imado dan san yaŋan lo, oŋ ŋurupaio dak an niŋen o, itaot mi rupaiama wa. Oŋ Kristus, Anut Nanun i? Rupaiamap maloŋ.” ");
INSERT INTO tbc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ago man Jesus igo ibol irupei, “Awo, nek oŋse ubol la ya. Ak man ŋai aŋ ŋurupaiaŋ da, murna gup Tamol Nanun iŋ Anut a dabai tubun geig anda yan tuon won ak ate imasi dop ale wa. Agod Tamol Nanun keit lo timtaen titiŋaem kuai tem ipalu wa, mel amaiak dam ale wa.” ");
INSERT INTO tbc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Agog pris gurman, ru an niŋen o imasa saian go, iŋsan ilo muruan an kuai te ikubiai dile wo iŋanen kulos irasireg igo ibol, “Iŋ Anut yaŋan malan isue ya. Gidad, tamol taidam, tamol en san kagin niŋen o dubol ilasa san id ta tigiai na wa. Man dugo, gamu geig iŋanen ru lo Anut yaŋan malan isue yan aŋsemi aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aŋsam ilo sou lo, tamol en dugo tigane wak i?” Ago tag iŋ ru naon igo durupei, “Iŋ mel saian geig ak igane, ak niŋen o ka imat oŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ago man iŋ Jesus naon fo na dulusu dugo banid nam dufuni na ya, agod aenta iŋ kudaŋan dugufute dugo igo dubol, ");
INSERT INTO tbc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kristus, oŋ gamu profet ru ubol a, tamol e ifuno den enti ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aria, saen an lo Pita kot ab patun fo imasig imado dugo, urat pein ta siŋiren na ipalug igo ibol, “Oŋ dam Jesus Galili san tamol amaiak da amado ator se ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ak gug Pita tamol an fidian malad lo itot go igo ibol, “Ru oŋ ubol dan ŋai ta ŋaloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Murna gug yaug ar san dalawan te imado dugo, urat pein sen ak ta ileg, niŋen o tamolpein sumeik dumado yan fidian irupidai, “Tamol an iŋ Jesus Nasaret san amaiak ida dumado dutor se ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ago man fon Pita itot go ru sakar nam irupidai, “Rumok geig ŋai tamol an ta ŋaloŋ na ya!” ");
INSERT INTO tbc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kitekan taidag tamolpein a dutur na yan Pita san na diaug durupeig dubol, “Rumok geig, oŋ iŋsad kisaek a. Oŋane ŋiŋeŋ lo se kuai te ibulo lasa ya.” ");
INSERT INTO tbc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Agog fun iganeg sen imisilanig ibol, “Ŋai sewak ŋigane tap Anut ka imisilanag a! Ŋai tamol an ta ŋaloŋ na ya!” Saen ago ibol itout man, kurek ibob. ");
INSERT INTO tbc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ago dugo Pita iŋ Jesus ru ibol an ilon isou a, “Saen kurek gamugo ibob dop, saen utol ŋai niŋeg o utot a.” Ago man iŋ kuai te ilasag tinaŋ tubun mi igane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Salso idu dugo pris tutubu adi, agod Isrel tamolpein sad gurman adi, dal dugon lo Jesus dufunip imat o nug lo dukubiaig ilod kisaek dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Agog iŋ Jesus rasau nam dusubanig dida diaug Rom san gurman Pailat tuon lo digane ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tamol Judas, nek emaiak Jesus ager adi tuod lo igane ya. Iŋ leil igane dugo Jesus pilapil ru lo diabi idug muruan lo digane ya. An lo man iŋ ilon tubun mi geig imuŋani a, ago yan lo iŋanen aupasek niŋen sen ipasi wo moni patun silva 30 dupani an isinig imul yaug ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iŋ igo ibol, “Ŋai au ŋapas a. Ŋai tamol a tuom lo ŋigane yan, iŋ kulob saian ak ta igane man tia ya, ak gug aŋ afunip imat o da.” Ak man iŋ dubol, “En man maŋsama mel tia ya, oŋane ilo saian mi a.” ");
INSERT INTO tbc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","An lo man, Judas moni patun silva 30 dupani an, tempel san ar lo yabibol idu dugo, aben an ibiseig yaug sen buron isuseg imat a. ");
INSERT INTO tbc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pris tutubu adi moni an diŋaneg igo dubol, “Moni en man tamol dufuni imat ak san naon, an dar idad a. An lo id moni en tempel san moni da tutumani san niŋen o idsad kubiaeŋ ipadau a.” ");
INSERT INTO tbc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Amaiak niŋen o iŋ awad dutumanig moni an urat dupani wo ilo sou digane ya. Ago man tamol bod niganag, iŋsan tan titin ta didad a, an lo dop ante iŋ ka tamolpein gol ak sad sisanud disiriai a. ");
INSERT INTO tbc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ago yak niŋen o, tan titin nek an yaŋan man igo ya, “Dar san tan” ago dubol a. Gamu en dam tamolpein iŋ yaŋak nek an mi dubol da. ");
INSERT INTO tbc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Saen pris tutubu adi iŋ tan titin an yaŋak amaiak dupate man, ru ta profet Jeremaia ibol ilasa yan nuŋon ilasa ya. Iŋ igo ibol, “Iŋ moni patun 30 silva ak diŋane ya. An man iŋsan dadeŋ san naon. Isrel san tamol aenkadi, tamol an iŋ didad san naon amaiak digansi a. ");
INSERT INTO tbc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Moni an diŋaneg, lo tamol bod niganag san tan titin didad a, nek ibol Tubun en ru kagin ŋai ipanag ak nek ago mi digane ya.” ");
INSERT INTO tbc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus gabman gurman naon na dugunig itur dugo, ago isumiani, “Oŋ Juda sad kiŋ ak i?” Ago dugo Jesus ibol, “Awo, nek oŋse ubol la ya.” ");
INSERT INTO tbc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ak gug saen pris tutubu adi agod Juda sad gurman adi iŋ Jesus ru dupani man, iŋ ru naon ta ibol man tia ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ago yak niŋen o Pailat irupeig isumiani, “Oŋ ru fidian dupano den kududo lo ta uloŋ na yak i?” ");
INSERT INTO tbc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ak man Jesus ru naon ta Pailat irupei man tia ya, gidad ru wei mi dupani bo man ru naon ta irupidai na ya. An niŋen o Pailat irut go ilo sou wei mi igane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aria, anaŋar fidian, Pasova san saen lo, gabman gurman subanek tamol kisaek o lian yaŋan dupate dop, ipasip kawan imado wa. Kagin nek an san nal idu ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saen an lo man tamol ta yaŋan Barabas iŋ subanek lo imado ya. Tamol emaiak iŋ man saian geig an tamolpein fidian mi duloŋ fufei a. ");
INSERT INTO tbc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Amaiak niŋen o saen tamolpein dutumani itout man, Pailat igo ibol isumianai, “En dugo woŋ ilom isou di? Enti ŋubuseip aŋsam na imul o? Ŋai Barabas ŋubusei wo, tia, Jesus e Kristus dubol damaiak ŋubuseip imul o?” ");
INSERT INTO tbc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Man dugo, iŋ iloŋ uyan ak man, tamol an iŋ mala sek lo Jesus diŋaneg kot lo dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mel taida mi, saen Pailat iŋ tulek tamol san kalik fo imasig imado dugo, iŋsan pein san na ru igane ipalug igo ibol, “Oŋ mel ta tamol e itaot aman en niŋen o ta gane na wa. Man ata wo? Gamu na ŋai ŋioŋamin ta lo ŋile dugo iŋ niŋen o madai wei mi ifunag na ya.” ");
INSERT INTO tbc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ak gug pris tutubu agod Juda sad tamol gurman adi, tamolpein malan an ilod diŋane ya. Iŋ tamolpein an dududuwaig Pailat dusumianig Barabas ipasi pidinai dop, Jesus daoŋ ipani wo ago dubol se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","An niŋen o Pailat fon ibol isumianai, “Aŋ tamol uraru en luluŋad lo enti ŋupasi wo amat di?” Ago man duwagiŋ dugo igo dubol, “Nek Barabas mi a.” ");
INSERT INTO tbc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Agog Pailat ibol isumianai, “Aŋsam ilo sou lo, Jesus e Kristus dubol den niŋen o ŋai dugo ŋigane wak i?” Ago man fidian mi duwagiŋ dugo dubol, “Aigim fo bali wa!” ");
INSERT INTO tbc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gug iŋ ibol, “Ata mel o? Iŋ ata mel saian ak igane yak i?” Ago bo man iŋ awad tubun mi duwagiŋ go disasai, “Aigim fo bali wa!” ");
INSERT INTO tbc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat iŋ sen ikubiani man, iŋsan ru ta idaisuda na dugo, ager tubun ak ilasa wo da. Amaiak niŋen o iŋ you iŋaneg, tamolpein malad lo banin ifulani a. Ago dugo iŋ igo ibol, “Tamol en imat dop man ŋaisag muruan tia ya. An man aŋsiganem mel mi a.” ");
INSERT INTO tbc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Agog tamolpein fidian ru naon durupeig igo dubol, “Ai wadan en man maŋsigama, agod nanum murouma dida lo, ka yen a!” ");
INSERT INTO tbc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Agog saen ante man iŋ Barabas ibiseig sad na yau dugo, Jesus ipidinaig rasau nam dufuni a. Dufuni itout go Jesus aigim fo dibali wo yu tamol tuod lo igane yau a. ");
INSERT INTO tbc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Agog gabman gurman san yu tamol adi, Jesus diŋaneg gabman san ab lo diau a. Ante man iŋ Pailat san yu tamol fidian mi dupalu wo digiai a. Aria, dupalug naon na dutumani a. ");
INSERT INTO tbc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesus tinin fo kulos dupasi dugo, yamel daran ak ta nam kiŋ san kob igo woŋ tinin dubuluwi a. ");
INSERT INTO tbc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ago dugo iŋ kam dudurun aman da yak, kiŋ san kitikat igo woŋ ditiladeg, Jesus kabuŋan fo na digane ya. Makud ta diŋaneg tuon won ak ate diganeg kiŋ igo woŋ yabi a. Ago dugo naon na turud disoluwig, kukok an digane dugo igo dubol, “Per o, Juda sad Kiŋ!” ");
INSERT INTO tbc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Agog tinin fo dulusu se ya, ago dugo makud a banin lo yabi an diŋaneg ate kabuŋan te dufuni se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Saen kukok an digane itout man, yamel daran tinin fo yan dupasi dugo, iŋsiganen kulos digane pani a. Agog aigim fo dubali wo diŋaneg diau a. ");
INSERT INTO tbc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iŋ Jesus dida tureŋ diabig diau dugo, yu tamol adi dal te tan Sairini san tamol ta, yaŋan Saimon dubol dan dile ya. Agog Saimon an disodudunig Jesus san aigim isini a. ");
INSERT INTO tbc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Iŋ diaug aben ta, yaŋan Golgota dubol dak, ate dilasa ya. Yaŋak an san fun igo ya, “Kabuŋa tatu san aben.” ");
INSERT INTO tbc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aben ante dilasag, marasin gigen ta wain da dukubulig, Jesus iluk dop lo madai yabi idu wo dupani a, agog kitek iluk ak man ikubiani ile tag, ta iluk na ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Agog yu tamol adi Jesus aigim fo dubali la gug, iŋsed nug ilon lo iŋsan biouŋ diabititi san niŋen o satu lo dukok se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dukok itout man, dumasig dititianig dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ru ate kot dupani amaiak ai lapan fo digireg, aigim kabuŋan fufo na dubali a. Ru en san sutek lo man igo ya, “En Jesus, Juda sad Kiŋ.” ");
INSERT INTO tbc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesus giraŋen na man ager tamol gumagam digane na yak urarum aigim fo dubalai a. Ta tuon won ak ate dusuŋani dugo, ta tuon ŋas ak ate dusuŋani a. ");
INSERT INTO tbc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tamolpein diau dumul dop niŋen o ru kukok dubol dugo, kabuŋad dukupari pani se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ago dugo igo dubol se ya, “Oŋ tamol amaiak tempel subarip, nal utol lo mi foun wabisap guni wak ubol a, an niŋen o oŋ se ka patu pasi wa! Oŋ Anut Nanun mok tap, aigim biseip udu.” ");
INSERT INTO tbc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nek ago mi pris tutubun adi, kubiaeŋ san girek maŋau adi, agod Juda sad gurman adi dam, iŋ kukok an digane dugo igo dubol se ya, ");
INSERT INTO tbc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Iŋ tamol aenta patud ipasi na yak gug, iŋsen patun ipasi san man tia ya. Iŋ Isrel sad Kiŋ, an niŋen o iŋ aigim ibiseip idu dop, an lo na id ilod rumok a. ");
INSERT INTO tbc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iŋ Anut niŋen o ilon rumok da, aria, Anut tamol en niŋen o imat mok tap, gamu geig en Anut mi ka ibinawi wa. Ak gug Anut iŋ o imat mok di? Man dugo, iŋ ibol ak, ‘Ŋai man Anut Nanun a.’” ");
INSERT INTO tbc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dal kisaek mi lo gumagam tamol uraru Jesus giraŋen na aigim fo dusuŋanai an dam ru kukok wei mi tinin fo digane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ad mitilaen 12 kilok an lo, tidom tubun tan an fidian yafutani geig go yaug 3 kilok gurai isi a. ");
INSERT INTO tbc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Saen kitek 3 kilok sumeik ipani dugo, Jesus awan tubun mi iwagiŋ dugo ibol, “Eli, Eli, lama sabaktani?” Ru en fun igo ya, “Ŋaisag Anut, ŋaisag Anut, ata wo ŋai bisawag ak i?” ");
INSERT INTO tbc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tamol aenta sumeikan dutur man duloŋ go dubol, “Tamol en man Elaija iwagi da.” ");
INSERT INTO tbc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ago dugo yu tamol ta ririan mi imaspalug yaug, mel ta beig san titaliŋ igo woŋ ak iŋaneg, wain gigen an lo isominig, den luon ate isueg, Jesus iluk o awan te igane ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ak man aenta dubol, “Ale funi woŋ dop, Elaija ipalup ibinawi dop tile wa.” ");
INSERT INTO tbc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus afon awan tubun mi iwagiŋ dugo, iŋanen ur tinin lo yak ibiseig yau dugo imat a. ");
INSERT INTO tbc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Saen nek amaiak lo mi, yamel tubun tempel lo iyuk yen an, o lak na fun iganeg imasireig yaug tan na idug uraru dilasa ya. Saen an tan isuruwor dugo pat tutubu yak sed igile yau se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ago dugo mutou san aben dam awad ikasap dugo, tamolpein gun ak wei mi gubak mi dumat la yan sad sisanudi fon kumaen dumasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iŋ mutou dubusei a. Murnag saen Jesus imasa yan lo Jerusalem na diaug diladu dugo tamolpein wei mi dil a. ");
INSERT INTO tbc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yu gurman iŋanen yu tamol dida Jesus dititianig dumado na yan, tan isuruwor dugo melmel dilasa yan ago dil man, tubun mi direr se ya. An niŋen o yu gurman an ibol, “Rumok geig, en man Anut Nanun.” ");
INSERT INTO tbc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pein wei mi dumado na yan dam, asau mi dutur dugo leil digane se ya. Pein amaiak saen Jesus Galili ibiseig tureŋ yabi dugo dubunawi wo ŋien aban diri se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lulaŋad lo pein kisaek ta man taun Magdala san Maria, agod turan man Maria sen ta, Jems iŋ Joses da tinadi, agod ta man Sebedi nanun uraru amaiak tinadi. ");
INSERT INTO tbc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ad idiau o sumeik dugo, taun Arimatea san moni tamol ta yaŋan Josef ipalu ya. Iŋ dam Jesus san megeloum mi a. ");
INSERT INTO tbc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iŋ Pailat san na yaug Jesus san sisanun iŋane wo isumiani. Iŋanen yu tamol adi ru dabai anda yak ipidinaig diaug Jesus san sisanun diŋaneg Josef dupani a. ");
INSERT INTO tbc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef sisanun an isini yaug, yamel foun ikok aman geig ak nam ifou ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Agog iŋsinanen mutou foun ak lo igane ya. Mutou an man pat san gib, Josef iŋsen gubak mi tamol irupidai dugo diabi a. Agog Josef pat muruan tinan ak ta ibili ipalug mutou awan ate ibalfutani a. Agog aben an ibiseig yau a. ");
INSERT INTO tbc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Taun Magdala san Maria, iŋ Maria ta da mutou an fun na dumasig leil digane se ya. ");
INSERT INTO tbc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nal a Soubul Kubunek San dubol dan itout la gug, nal tinin te yak lo, pris tutubu adi agod Farisi adi diaug Pailat naon na dutumani a. ");
INSERT INTO tbc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Agog igo dubol durupei, “O tamol tubu, ru ta sewak tamol en kumaen imado dugo ibol an maŋ iloma isou da. Iŋ ibol, ‘Nal utol itout la gup, fon kumaen ŋumasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Amaiak niŋen o, oŋ gidad ubol dop yu tamol adi mutou fun na nal utol tawaŋ diganep dumado wa. Kabelan iŋanen megeloum adi sisanun gumagam aman diŋane dop, mutou lo imasa la yak ago dubol tamolpein durupidai banau. Ago dop man iŋsad ru sewak foun en, iŋsiganen ru sewak gubak mi ibol an iriŋani banau.” ");
INSERT INTO tbc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","An niŋen o Pailat irupidai, “Aŋ yu tamol aŋal dop, arupidaip mutou fun na tawaŋ digane wo uyanan a. Mutou kagin apani dop dugo agane wo ilom ibol tap ago ka agane wa.” ");
INSERT INTO tbc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ago man diaug mutou dufutani wo uyanan a. Agog iŋ gib awan san pat amaiak fo na kob ta digane ya. An lo tamol ta pat an ibili tap kob an malan isue wa. Ago dugo yu tamol didiraig mutou kagin dupanig dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aria, ubou san nal Sabat dubol dan itout go nal patun fo, ubou turan san nal malmalan, tidom lom geig Maria Magdala san pein, iŋ Maria turan da mutou dile wo diau a. ");
INSERT INTO tbc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ago dugo kanaurig tubun ak ilasa ya. Man dugo, Tubun ak san eŋel ta iŋ kumaen panu ibiseig idug, pat a mutou awan ifutani an ibilig fufo na imasig imado se ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eŋel an san leil man ibol weil irakilawi dak san leil ago mi a, agod iŋsan kulos milkouk kasik man ibol ais igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ago man yu tamol adi, iŋ niŋen o durut direr se yan lo dusuruwor go tan fufo na dudug tamol dumat ak igo woŋ dien se ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ago dugo eŋel pein uraru an igo irupidai, “Aŋ ta arer na wa. Ŋai ŋaloŋ ak aŋ uraru mi Jesus ale wo apalu ya, tamol nek a aigim fo dubali ama ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iŋ ete ta yen na da, iŋ imasa la ya, nek ibol imug irupaiaŋ ak ago mi a. Apalup yen ak aben ka ale wa. ");
INSERT INTO tbc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ago dop ririan aup iŋanen megeloum igo arupidai a. ‘Iŋ mutou ibiseig imasa la ya. Ago man iŋ imug mi Galili na yau dop aŋ ŋien aban ari wa, aŋ aben ante gup iŋ ale wa.’ Aria, bilaluŋ ŋupanaŋ o ŋupalu yan ŋurupaiaŋ itout a.” ");
INSERT INTO tbc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pein uraru an direr geig ak gug, iŋ uyasusai tubun mi digane ya. Ago man iŋ ririan mi mutou dubuseig dumaspalu oŋ iŋsan megeloum durupidai o diau se ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dal dirig diau dugo Jesus naod na ilasag ibol, “Tidom lom mi!” Agog pein an siŋiren na diaug ŋien diabig ubou an dile ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ago dugo Jesus uraru an igo irupidai, “Aŋ ta arer na wa, aŋ aup ŋai teig muroug arupidaip Galili na diau a. Iŋ aben ante gup ŋai diliag a.” ");
INSERT INTO tbc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pein uraru an tureŋ diabi dugo, yu tamol adi mutou kagin dupani se yan, taun ilon lo diaug diladug melmel ilasa yan, niŋen o pris tutubu yan durupidai a. ");
INSERT INTO tbc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Amaiak niŋen o pris tutubu yan iŋ Juda sad gurman adi dida dutumani dugo nug lo dukubiaig an lo ru dufuni a. Agog moni patun silva an idaisuda mi yu tamol an dupidinai a. An lo awad dufutani wo ago digane ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ago dugo iŋ igo dubol durupidai, “Aŋ tamolpein igo arupidai a. ‘Tidom lo maŋ maen oŋ dugo, iŋsan megeloum adi pasak nam dupalug sisanun an gumagam an digane ya.’ ");
INSERT INTO tbc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Agod gabman gurman ru en iloŋ tap, maŋ ida ru ka mukubune wa, ago dop aŋ muruan am tia wa.” ");
INSERT INTO tbc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ak niŋen o yu tamol adi, moni an diŋane dugo, gurman adi dubol ak ago mi digane ya. An niŋen o ru amaiak Juda adi luluŋad lo ifurak yau a, an lo Juda adi ru nek an mi dubol dugo ipalug gamu da mi a. ");
INSERT INTO tbc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aria, megeloum nuŋod 11 an, Galili na diau wo tureŋ diabig dutor nag, did ta gubak mi Jesus niŋen o ibol an siŋiren na dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ante saen iŋ dile man, ubou an dile yak gug, aenta Jesus niŋen o ilod uraru a. ");
INSERT INTO tbc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Agog Jesus iŋ sumeik mi ipalug igo irupidai, “Anut dabai fidian mi, kumaen panu san, agod tan en san dam, lo melmel fidian ŋitirnai o ipanag a. ");
INSERT INTO tbc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ago yak niŋen o, aŋ gidad aup an lo tamolpein a tan fidian lo dumado dan, ŋaisag megeloum adirai dilasa wa. Ago dop aŋ Bai yaŋan lo, Nanun yaŋan lo, Awan Urgun yaŋan lo afulanai a. ");
INSERT INTO tbc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ru kagin fidian ŋai aŋ ŋurupaiaŋ amaiak iŋ duri dupani uyanan o apiteŋanai a. Agod en ale, ŋai pempem mi aŋ da tumado da, ago mi yaup saen en itout a.” ");
INSERT INTO tbc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dal en bilaluŋ uyanan Jesus Kristus Anut Nanun niŋen o fun igane ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nek profet Aisaia wagam iŋanen buk lo igo igire, “Ale. Ŋaisag bilaluŋ tamol ŋidinip, oŋ nao na imug yau a. Tamol an oŋane dal ikubune pano wa.” ");
INSERT INTO tbc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Tamol ta san awan, tan kawan tamolpein an tia yak ate tubun mi iwagiŋ dugo igo ibol: ‘Aŋ gidad Tubun en san dal akubune wa, iŋanen dal tureŋ yabi san akubune dop itaot mok ilasa wa.’” ");
INSERT INTO tbc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Agog Jon ipalug, tan kawan tamolpein an tia yak ate tamolpein isuguai dugo ilod dibilisap suguek diŋane dop an lo iŋaned aupasek fidian Anut ipasi wan san ru man ifulale pidinai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aria, tamolpein a fidian Judea provins lo dumado dan, agod Jerusalem tamolpein wei mi dam Jon san ru duloŋ o diaug iŋsan na dilasa ya. Ante man iŋaned aupasek fidian mi walal te dubol ilasag, Jon dida you Jordan lo dudug isuguai idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Aria, Jon iŋsan yamel man kamel fufulun lo duwei ak igane ya. Let man makau suŋulon nam digane an luan te iyati a. Iŋanen anaŋ man sis, agod garaŋ san niniu mi yani se ya. Iŋ tamol kawan ak ago woŋ itor se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iŋanen bilaluŋ ru tamolpein naod na ibol ilasa man igo ya. “Murnap tamol ta ŋai patug fo ipalu wa, tamol an san dabai ŋaisag iriŋani geig a. Ŋai man iŋanen sendal ŋupasi san turug ŋusoluwip ŋitakoksi dop san kam ŋusupasi wo ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋai aŋ you lo mi ŋusuguaŋ a. Ak gug tamol en man Awan Urgun lo isuguaŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Saen an lo Jesus panu yaŋan Nasaret Galili distrik lo yan ibiseig, you Jordan ate Jon san na yau a. Atna Jon Jesus isugui a. ");
INSERT INTO tbc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nek saen a Jesus you ibiseig kuai te isuda man, kumaen panu san dalawan pasek go yen dugo, Anut san Ur muluk oŋ idug, iŋ kabuŋan fufo imasi dugo ile ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Agog kumaen panu lo wagiŋ ta idug igo ibol dugo iloŋ, “Oŋ man ŋaineg Nanug, ŋaineg bubeg mok, oŋ niŋe wo ilog tubun mi uyanan da.” ");
INSERT INTO tbc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Agog gamu nam Urgun iduduwig tan kawan ak lo yau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iŋ aben ante nal kitek milaen mi, ad 40 tidom 40 sen imado dugo Satan ipalug, bitinaek lo igane ya. Aben ante mel kasik ak dam dumado na ya. Aria, Satan san bitinaek fidian itout go eŋel adi dupalug Jesus kagin dupani a. ");
INSERT INTO tbc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aria, kiŋ Herod Jon yabig isubani dugug, Jesus yaug Galili distrik lo ilasag, ante Anut san bilaluŋ uyan ak walal te ibol ilasag tamolpein duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iŋ igo ibol, “Nal ilasa la ya, Anut san kagin panek an san saen sumeik a. Man niŋen o aŋ ilom ibilisa dop bilaluŋ uyan ŋurupaiaŋ dan ilom lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus You Galili san aen gigin fo itor dugo tamol ta tein da yil a. Tamol an imug yaŋan Saimon, iŋ tein Andru da. Uraru an iy ŋalaŋal, ago yan lo iŋaned dob you lo dubal idu dugo, Jesus ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Agog irupidai, “Ŋai ŋieg abag ari gup tamol aŋal san ŋipiteŋanaŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Agog dob dubal yen dugo ŋien aban diri kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Agog Jesus you aen gigin irig kitek isuda yau man, Jems Sebedi nanun an tein bakan ak Jon da yil a. Tamol uraru an wog fo iy dob duwei se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Agog Jesus uraru mi igiai kisaek oŋ go tamadi Sebedi wog fo tamol ibiai an dida dumado dugo dibisawaig Jesus ŋien aban dirig diau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Agog diaug, panu tubun yaŋan Kaperniam atna dilasa ya. Ubou nal, Sabat dubol dan lo, Jesus ubou ab ta lo iladug tamolpein ipiteŋanai o fun igane. ");
INSERT INTO tbc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ago dugo ru an duloŋ go durut saian. Man dugo, iŋ nek ibol iŋsiganed kubaieŋ san girek maŋau adi dupiteŋanai na yak oŋ ago ta ipiteŋanai na ya. Tia, iŋ tamol yaŋan tubun anda yak oŋ ago ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aria, Jesus ru ibol dugo, ubou ab an lo tamol ta ur saiak ta aman da yak dam ate imado ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iŋ awan tubun mi iwagiŋ go ibol, “Jesus, oŋ Nasaret tamol, oŋ maŋsama na ata mel gane wo palu yak i? Nag oŋ maŋ daoŋ panama wo palu i? Ŋai oŋ ŋaloŋ uyanan a, oŋ Anut san gun tamol.” ");
INSERT INTO tbc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ak man Jesus ru dabai nam igo irupei, “Oŋ awa itau. Tamol en biseip lasa wau!” ");
INSERT INTO tbc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Agog an lo ur saiak an tamol an yabig, ikirŋaŋ isuruwor go iŋ itarfuni a. Agog ur saiak an awan tubun mi isasai dugo ibiseig ilasa yau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Man niŋen o tamolpein an fidian durut saian mok a, an lo iŋsed nug lo diŋiŋeŋ se ya, agog igo dubol, “En so mel ta yak i? Nag piteŋanek foun ak boi? Iŋsan ru dabai tubun aman da ya. Iŋ ka ur sisaiak ru kagin ipidinai dop iŋ awan duloŋ pe dilasa diau a.” ");
INSERT INTO tbc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","An lo ŋiŋeŋ Jesus niŋen o yan ririan ifufurak go panu fidian Galili distrik ilon lo yak ate yau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iŋ ubou ab an dibiseig Jems Jon da diŋal go dida Saimon iŋ Andru da sad ab lo diau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pita raon subam ifunig tinin wananan go, gadab fo iŋsiganen ab lo diganeg yen a. Man niŋen o pein an niŋen o Jesus durupeig iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Agog Jesus yaug, pein an banin yabig itur o ibinawi a. Gamu nam subam an ibiseig pein an imasa kisaek oŋ go anaŋ ikubune pidinai a. ");
INSERT INTO tbc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gurai isig ad idiau dugo, tamolpein fidian subam amad da, agod a ur saian saian amad da yan dam, diŋal go dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Panu tubun an san tamolpein wei kasik ab san dalawan siŋiren na dutumanig dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ago man Jesus tamolpein wei mi subam funfun amad da yan ikubuniai dugo ur saiak wei mi dam tinid lo ikudai diau a. Ak man iŋ ur saiak adi niŋen o diŋiŋeŋ san niŋen o ipadau a, man ata wo, ur adi amaiak Jesus enti mok an duloŋ fufei a. ");
INSERT INTO tbc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tidom lom mok, saen ad gamugo ilasa dugo, Jesus imasag ab an ibiseig aben ta yoitout ak lo yau a. Ante man Anut niŋen o igudani se ya. ");
INSERT INTO tbc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ak gug Saimon iŋ turan dida dumado yan, Jesus abaŋan dile wo ŋien aban dirig diau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Saen iŋ dile man durupeig dubol, “Fidian mi oŋ dilio wo abaŋa diabi da.” ");
INSERT INTO tbc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ak man Jesus awad yabig ibol, “Id panu aenta siŋired na dien dan lo tau a. An lo ate dam ŋai ru ka ŋufulale pidinai a. Man ata wo, urat nek en ŋigane wo ŋilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","An lo man iŋ Galili distrik ilon lo tureŋ yabi se ya, sad ubou ab fidian lo ru ibol ilasa dugo ur sisaiak tamolpein tinidi lo yan dam ikudaig dilasa diau a. ");
INSERT INTO tbc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nal ta man tamol ta tinin lepra yafutani an ipalug isumiani wo turun isoluwig irupei, “Oŋ ilo ibol tap, ŋai kubuniag pe tinig uyan ilasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Agog Jesus ilon tubun mi imuŋani tag banin iwateg yabig ibol, “Ubol agom ŋai ilog ago yen da, uya lasa.” ");
INSERT INTO tbc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Agog lepra ibiseig yau dugo tamol an tinin uyan ilasa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Agog Jesus tamol an ru dabai nam ru kagin irupei. Iŋ ririan idinig yau o niŋen o igo ibol. ");
INSERT INTO tbc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kagin gane, kulob ilasa yen niŋen o aenta ta rupidai na wa. Tia, itaot waup, tini Juda sad pris mi kubiaip ile dop, mudan a Moses san kubiaeŋ lo ibol an ŋanep Anut yai gane pani. An lo dop tamolpein duloŋ ak oŋane subam itout a.” ");
INSERT INTO tbc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gug tamol an yaug, mel en Jesus igane an niŋen o ibol itilani se ya, an lo ru an panu panu lo yau a. Man niŋen o Jesus iŋ fon panu tutubu yak lo walal te iladu san tia ya. Amaiak niŋen o iŋ aben tamolpein tia yak ante mi imado dugo tamolpein baŋen fidian lo yan iŋsan na dupalu se ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nal wei tiag Jesus fon imul panu Kaperniam na ipalu ya. Agog tamolpein Jesus ante imado dan niŋen ru duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","An lo tamolpein wei mi iŋsinan ab lo dupalug dutumani a. Ab an ilon lo nug dusupini dugo patun fo dam ab dalawan siŋiren na aben tia ya. Ago dugo Jesus Anut san ru ifulaleg duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ago dugo tamol iwoiwo iŋ tamol ta ŋien banin fidian itubabun ak kapal anda Jesus giraŋen na disinig dupalu wo digane ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ak man tamolpein mi dal dufutani an lo iŋ diau san dal tia geig a. Ago tag ab patun fo tet fo disidag diaug, ab aten lak na katik nam gubak mi digane an fo digansi a. Ago yen dugug mutunuk ta fuŋ fufo diganeg diabigigeg gug mutunuk an lo tamol kapal anda yan duyuweg, Jesus imado dugo naon na digane idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Agog saen Jesus iŋaned ilo rumok ile man tamol an irupeig ibol, “Ŋaineg nanug, ŋai oŋane aupasek fidian ŋusuas yau la ya.” ");
INSERT INTO tbc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aria, ate man kubiaeŋ san girek maŋau aenta dumado ya. Iŋsan ru ibol en duloŋ go an lo ilod igo weiwei se ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“En ata wo ru naon ago ibol ak i? Iŋ Anut lo ru kukok igane da! Ak dugo, tamol ta iŋ ka aupasek isasi yau ak i? Tia geig, kulob an Anut san mi a.” ");
INSERT INTO tbc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Gamu nam Jesus ilon lo, tamol an kankan dugoma digane se yan iloŋ uyanan a. Ago tag iŋ igo irupidai, “Aŋ ata wo ilo wei igo agane dak i? ");
INSERT INTO tbc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dugomaiak pasauman ak i? Ŋai ŋabol, ‘Oŋane aupasek ŋupasi yau o?’ Tia, ŋabol, ‘Oŋ masap kapal ŋanep utor a?’ ");
INSERT INTO tbc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ak gug kulob e ŋiganep an lo ŋai, Tamol Nanun, tan en lo Anut wagen lo aupasek ka ŋupasi yau amaiak aloŋ o ...” ago ibol go tamol a ŋien banin tubabun aman irupei, ");
INSERT INTO tbc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Oŋ masa utur pe oŋane kapal ŋanep siŋane ab lo wau.” ");
INSERT INTO tbc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Agog tamolpein malad lo man, tamol an imasa kisaek oŋ go san kapal yabisag isinig kuai te ilasa ya. An lo man iŋ fidian durut saian mok dugo Anut yaŋan diabisa dugo dubol, “Maŋ kulob ta naok igo yak gubak mi mileu man tia geig a!” ");
INSERT INTO tbc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Murnag Jesus fon yaug you tilianek san loŋ na itor dugo tamolpein malan tubun mok dutumanig Jesus dubuluwig maŋau ipidinai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jesus you aen gigin irig isuda yaug ab ta, ate tamolpein sad na moni takis diŋane dak ate ilasa man, takis ŋilaŋal tamol ta imasig imado dugo ile ya. Tamol an yaŋan Livai, Alfeus nanun. Agog irupei, “Ŋieg aban uri.” Agog Livai imasa go ŋien aban iri a. ");
INSERT INTO tbc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Murnag saen Jesus Livai san ab lo imasig imado dugo sisem anaŋ diani man, takis ŋilaŋal wei mok agod “aupasek tamol” wei mi dam, dupalug dumasig Jesus iŋanen megeloum dida anaŋ diani a. Man dugo, tamolpein a ŋien aban diri se yan wei mok a. ");
INSERT INTO tbc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kubiaeŋ san girek maŋau adi luluŋad lo ensauta a iŋ dam Farisi adi amaiak mel en Jesus megeloum dida digane dan dile dugo iŋsan megeloum adi igo dusumianai, “En ata wo tamol en takis ŋilaŋal tamol adi agod aupasek tamolpein dida sisem anaŋ diani dak i?” ");
INSERT INTO tbc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ak man Jesus iŋsad sumianek iloŋ go irupidaig ibol, “Tamolpein a tinidi uyan an dokta san na ta diau na da, tia, tamolpein subam anda yak mi ago digane da. Ŋai tamolpein itaot adi ago dubol dak ŋigiaip dupalu san niŋen o ta ŋupalu na ya, tia, aupasek tamol anami ŋigiai o ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aria, nal ta lo suguek san Jon iŋsan megeloum adi agod Farisi adi dam iŋ anaŋ lo geg diganeg dumado se ya. Tamolpein ta Jesus san na dupalug dusumiaeŋ, “Jon san megeloum agod Farisi adi dida nal kadi anaŋ lo sed geg ipidinai da, ago gug ata wo oŋsiŋane megeloum anaŋ lo geg ta digane na dak i?” ");
INSERT INTO tbc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Agog Jesus awad yabig igo ibol, “Tamol ta iwon da sad nug ŋanek san saen an ilom isou a. Ak dugo, saen tamol an iŋanen turan muroun dida dumado dop, anaŋ lo geg digane wak i? Tia ya. Saen iŋ dida dumado dan waliŋ digane san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gug nal ta ipalu dan te gup, Anut iŋ nug ŋanek san tamol an ipasi yau pidinai a, nal an lo man waliŋ digane wa.” ");
INSERT INTO tbc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tamol ta yamel kilaken ta ikukuik na yan ta irasirep ate yamel wagam ak san mutunuk ta iwei na da. Man dugo, ago igane tap, yamel kilaken foun an yamel wagam an irae dop fon irasire dop daoŋ ipani wa. ");
INSERT INTO tbc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Agod tamol dam wain foun ak bilelek suŋulon wagam ak lo ta diwali na da. Man dugo, ago digane tap, wain foun an iganep bilelek suŋulon wagam an ikafut yaup ipuk dop, wain ikulmaek pe tan fo idu dop, bilelek suŋulon dam daoŋ ipani wa. Fun an niŋen o iŋ wain foun ak bilelek suŋulon foun ak lo mi diwali da.” ");
INSERT INTO tbc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ubou nal ta lo Jesus kon san abi ilon lo itor se ya. Ago dugo iŋsan megeloum iŋ kon aenta dufunig fun diganeg diani se ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Gug Farisi adi dil tag Jesus durupei, “Ule, en ata wo kagin a Sabat nal lo tigane san niŋen o idsad kubiaeŋ ipadau amaiak gamu oŋane megeloum adi digane dak i?” ");
INSERT INTO tbc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ago man Jesus iŋsad awa biek ru naon irupidaig ibol, “Nag mel e Dawid igane yen ta asuti na i? Dawid iŋ turan muroun dida kadag san saen lo dimatigen dugo anaŋ o katuk amadi a. ");
INSERT INTO tbc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mel en wagam mi saen Abiatar iŋ pris gurman imado dugo ilasa ya. Aria, Dawid Anut san ab lo iladug, bret a Anut naon na didirig dien an iŋaneg yani a. Ak man bret an iŋ lo geg a, nek Anut san pris iŋ mi ka diani wa. Ago bo man iŋ dam iŋanen yu tamol adi bret aenta iwae pidinaig diani a.” ");
INSERT INTO tbc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Agog Jesus fon irupidaig igo ibol, “Tamol iŋ ubou nal san mel, ago Anut ta igane na ya, tia geig. Ubou nal man tamol san mel, nek ago mi igane ya. ");
INSERT INTO tbc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Fun amaiak niŋen o, Tamol Nanun man ubou nal an dam iŋsan muroun a.” ");
INSERT INTO tbc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nal sen ta lo Jesus ubou ab lo iladu ya. Tamol ta tuon ikurŋak yau ak ante imado ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tamol aenta ate dumado dan iŋ Jesus tinin fo ru digane wo dal abaŋ dile se ya. An niŋen o iŋ maladi ti ibol dugo Jesus ata mel igane wo dak dile san tawaŋ an digane se ya. Iŋ tamol e banin ikurŋak yau en Sabat nal lo ikubune tap, an niŋen o boum dupani wa. ");
INSERT INTO tbc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aria, Jesus tamol e banin saian en irupei, “Oŋ masap, titiŋaem utur.” ");
INSERT INTO tbc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Agog Jesus tamol en isumianai, “Kubiaeŋ dugo ibol ak i? Ubou nal lo, id ka kagin uyan ak tigane wo? Tia, kagin saian ak tigane wak i? Patu pasek tupani wo? Tia, tufuni imat ak i?” Ago man iŋ fidian tok dubol go dumado ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus yil ilubanai dugo niŋedi wo tiŋaen wananan idu dugo ilon tubun geig ipapao se ya, man dugo, iŋ bubedi man dabai geig a. Agog Jesus tamol en irupeig ago ibol, “Oŋane bani itaot wate.” Agog iŋ banin iwateg, uyan ilasa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Agog Farisi adi kuai te dilasag silei nam iŋ kiŋ Herod san warou adi dida sisem fun diganeg palaŋ an dumari a. Iŋ dugo woŋ Jesus daoŋ dupani wak o nug lo dukubiai ila iso se ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Agog Jesus iŋanen megeloum dida dugursig you saltek san loŋ na dudu diau a. Ago dugo Galili tamolpein malan tubun Jesus ŋien aban fo diau a. Tamolpein tan titin wei mi kulob naok naok Jesus igane na yan niŋen o duloŋ an lo iŋsiganed panu panu dibiseig iŋsan na dupalu ya. Tan Judea adi wei mi dam dutumanig Jesus dirig diau a. Tamolpein malan tubun, Jerusalem na yak, Idumea provins lo yak, you Jordan aen ate yak, Taia iŋ Saidon da sad loŋ na yan dam dususag dutumani a. ");
INSERT INTO tbc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Agog Jesus iŋsan megeloum adi irupidaig, iŋ gidad wog ta diŋanep, sumeikan dususep yen dop fo isuda wo ibol. Man dugo, tumanek tubun mok iŋ dubuluwi se ya, kabelan iŋ tinin dupini saian banau. ");
INSERT INTO tbc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Man dugo, iŋ imug mi tamolpein wei mi ikubuniai a. An lo tamolpein a subam ad da yak fidian dususag dubuluwig Jesus tinin kitek diabi dile wo iŋ lo dututou se ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Agod saen ur saiak saiak talpein tinid lo yan Jesus dile man, talpein an Jesus naon na turud dusoluwig awad tubun mi diwagiŋ go dubol, “Oŋ Anut Nanun mok.” ");
INSERT INTO tbc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ak gug Jesus iŋ ru kagin dabai geig ipidinaig ago ibol, “Aŋ ŋai enti mok an niŋen o tamolpein ta arupidai na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus tan bubun ta ate isidag, tamol adi dugomaiak iŋsan dilasa wo ilon yen an igiaig dususag iŋsan na dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Agog iŋ tamol 12 ipilianaig, iŋ dida megeloum adi igo woŋ dumado dutor na ya. Murnap idiraip diau dop ru dufulale wa, agod iŋ dam ur sisaiak tamolpein tinidi lo yan dukudaip diau san dabai amad da ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Aria, megeloum 12 e itarpasai en yaŋadi igo ya. Ta Saimon, iŋ Jesus yaŋan foun ak Pita ipate. Ta Jems, iŋ tein Jon da, nuŋod urarum Sebedi nanun muroun, uraru en Jesus yaŋadi foun ak Boargenes ipate ya, (yaŋak an fun man weil fufu tamol.) Ta Andru, ta Filip, ta Bartolomiu, ta Matyu, ta Tomas, ta Jems iŋ Alfeus nanun, ta Tadeus, ta Saimon iŋ ru wagai san tamol, agod Judas iŋ man panu Keriot san tamol, emaiak murnag iŋ Jesus niŋen o palaŋ imarig ager tamol banid lo igane ya. ");
INSERT INTO tbc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aria, Jesus turan ta san ab lo iladu dugo tamolpein wei geig dupalug fon dutumani a. Iŋ iŋanen megeloum adi dida dusupinai se yan lo anaŋ diani san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Saen Jesus muroun muroun iŋ mel emaiak niŋen o duloŋ man, dumasa saian go sad panu dibiseig Jesus diabi wo dupalu ya. Man ata wo? Iŋ dubol, “Iŋ burau ifuni da.” ");
INSERT INTO tbc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Agod kubiaeŋ san girek maŋau ensauta a Jerusalem na dupalu yan iŋ dam igo ibol, “Tamol en tinin ilon lo man ur saiak Beelsebub anda ya. Iŋ ur sisaiak sad gurman iŋanen dabai nam ur saiak aenta tamolpein ilod lo yan ikudaig diau da.” ");
INSERT INTO tbc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ago tag Jesus igiaig iŋsan na dupalug ru mitilaen funfun nam irupidai duloŋ se ya. “En dugo woŋ pe Satan iŋ ka sen ikudip yau ak i? An ago igane san tia geig a! ");
INSERT INTO tbc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kiŋ san kagin panek aben lo, iŋsan tamolpein sed itarpalaip malan uraru dilasap nug dufuni tap, kiŋ an san kagin panek aben an dabai itur san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Agod warou kisaek san tamolpein iŋ tarpalek uraru dilasap nug dufuni tap man, warou an dam dabai itur san tia wa. ");
INSERT INTO tbc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Agod Satan iŋ sen yu iganep an lo iŋ muroun muroun sed itarpalai tap, aria, iŋ dabai itur san tia dop iŋanen dabai itout a. ");
INSERT INTO tbc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ak man tamol ta iŋ tamol dababai geig ak ta san melmel isini wo iŋanen ab lo iladu san tia ya. Tia geig a. Iŋ gidad imug mi tamol dababai an rasau nam isubani gup, iŋ ka tamol an san ab lo iladup melmel isinip yau a. ");
INSERT INTO tbc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ŋai rumok ŋurupaiaŋ da, aupasek fidian agod nao futek ru fidian dam tamolpein digane dan Anut ka isuas yau a. ");
INSERT INTO tbc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ak gug talpein ta iŋ Awan Urgun naon ifute tap, aupasek an Anut ta isuas yau na wa. Tia, iŋanen aupasek emaiak pempem mi yen yau a.” ");
INSERT INTO tbc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus ago irupidai a, man ata wo, tamol amaiak imug mi iŋ niŋen o, “Tamol en ur saiak aman da yak,” ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Saen nek an lo Jesus sinan tinan iŋ tein muroun dida dupalug kuai te dumado ya. Ago dugo tamol ta didinig ab ilon lo yaup Jesus kuai te ilasa wo irupei a. ");
INSERT INTO tbc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ago dugo tamolpein wei kasik Jesus siŋiren na dumasig dubuluwig dumado se ya. Ago dugo aenta iŋ durupeig dubol, “Uloŋ ak, oŋane tina tei murou dam kuai te dutur da, oŋ iŋsad na wau o digio da.” ");
INSERT INTO tbc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ak man Jesus awad yabig ibol, “Ensauta mok ŋaisag tinag muroug, teig muroug ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ago dugo malan yaug tamolpein giraŋen na dumado dan yil go ibol, “Ŋaisag tinag di teig muroug nek en mi a! ");
INSERT INTO tbc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tamolpein ensauta a ŋai Tamag kumaen panu lo yan ilon duri dupani dan, nek anami ŋaisag teig, lug di tinag muroug a.” ");
INSERT INTO tbc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Murnag Jesus Galili san you tilianek ate yaug loŋ na imado dugo afon fun iganeg tamolpein ipiteŋanai se ya. Agog tamolpein wei mi iŋsan na dususag dutumani itilani a. Saen an lo doup tubun mok. Ago tag Jesus wog lo isudag imasig imado dugo tamolpein fidian dutumani man loŋ na ditur se ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ante man Jesus ru faŋan lo mel wei mi niŋen o irupidai se ya. Ru ta ago irupidaig ibol, ");
INSERT INTO tbc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Aloŋ. Saen ta lo tamol ta ai patun isinig abi lo ipae wo yau. ");
INSERT INTO tbc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yaug siŋanen abi lo man ai patun banin igane inawaig tan fufo iratitale se ya. Saen ratitale man, ai patun aenta dal fufo dudu ya, agog anakanak dupalug diani itout a. ");
INSERT INTO tbc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ai patun aenta tan pat anda yak fufo dudu, tan ate man kuror an tia, agog milaen tiag ai patun an balud isa, man dugo, tan an kuror an tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ak man saen ad isuda man ai baludi an dukurŋak diau a. Ai an dam dabidi tan lo ta idiau geig na, an lo dukurŋak diau kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ai patun aenta ud saian an luluŋad lo dudu, agog sisem disag diau dugo ud saian an ai uyan ak yafutani an lo nuŋon ta igane na ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ak man ai patun aenta tan uyan ak fufo dudu man nuŋod digane, kadi patudi 30 dilasa, aenta 60, aenta 100.” ");
INSERT INTO tbc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Agog igo ibol, “Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saen Jesus sen kisaek imado dugo, iŋanen megeloum 12 agod tamolpein aenta dida diaug, Jesus ru faŋan ibol ilasa amaiak niŋen o dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Agog igo ibol irupidai, “Anut san kagin panek an san melmel imianuk an fidian ipanaŋ a. An lo aŋ mel en fidian ilom itarpasi san niŋen o aloŋ uyanan a. Ak man tamolpein patun fo dumado dan, iŋ bo ru faŋan duloŋ ak gug, ru an san fun mok ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","An lo man, ‘Iŋ bo malad pempem yau a, ak man ilod ta itarpasi na wa, agod kududod nam duloŋ bo man, fun mok ta duloŋ na wa. Tia dop, nag iŋ ilod ibilisa dop sed itilianaip Anut iŋsad aupasek isuas yau a.’” ");
INSERT INTO tbc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Agog Jesus irupidai, “Ak dugo, aŋ ru faŋan en niŋen o ilom ta itarpasi na yak i? Ago tap, en dugo woŋ pe aŋ ru faŋan aenta fidian dam aloŋ fufei wak i? ");
INSERT INTO tbc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tamol ai patun iratitale den, iŋ Anut san ru ipae da. ");
INSERT INTO tbc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tamolpein aenkadi man ai patun dal te yak ago ya. Ate Anut san ru dipae da. Saen ru an duloŋ ibol ak, Satan ipalup silei nam ru an ilod lo ipasi iŋane yau da. ");
INSERT INTO tbc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aenta man ibol ai patun tan sagar ak fo idu igo ya, nek anami ru duloŋ dop yousai amad da ilod lo rumok kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ak gug iŋ dabid tia yak niŋen o saen kitekan ka dutur gup, muruan ilasa boi, tia, dukudai dop madai diŋane boi, an lo dop ririan dibilanip dudu wa. Nek ago mi iŋsad ilo rumok itout yau a. ");
INSERT INTO tbc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aenta man ud luluŋad lo idu ya. Enami ru duloŋ pe ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ak gug tan en san ilo weiwei, agod filian san mala bulbal di mel aenta sad ilo masa dam, disaurip itilanip ru an ipapao da. Ago dop ru an nuŋon ta ilasa na wa. ");
INSERT INTO tbc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aria, ai patun tan uyanan fufo idu man, tamolpein ru rumok an duloŋ pe san fun dam duloŋ siŋaokan a. Talpein an iŋ mok nuŋod ifu wa, aenta nuŋod 30, aenkadi 60, aenta 100, nuŋod ago ifu wa.” ");
INSERT INTO tbc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Agog Jesus ru faŋan taidam igo ibol a. “Ak dugo, aŋ lam asulani dop, ab ilon lo daeg paen na boi, tia, sareg paen na boi, aguni itur dak i? Tia geig a. Aben lak na yak ate asuŋani wa. ");
INSERT INTO tbc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Man dugo Anut ilon igo ya, mel fidian gamu mianuk lo yen den, murnap walal te ilasa wa. Agod mel ta dutuani an, nal idu dop ad lo ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Agog Jesus fon irupidaig igo ibol a. “Aŋ gidad ru e aloŋ den niŋen o kankan aŋane wo uyanan a. Man ata wo? Tou sapita aŋ tamolpein aenta apidinai dan, tou nek ago yak nam Anut mel ipanaŋ a, agod mel taidam itumani panaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Talpein ta melmel aenta da yan, Anut taidam ipani wa. Ak gug talpein ta iŋ melmel tia, mel kititik a aman da yan, an dam Anut iŋ banin lo ipasi yau a.” ");
INSERT INTO tbc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus fon igo ibol, “Anut san kagin panek man igo ya. Tamol ta anaŋ patun tan lo iratitale ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tidom ad, gidad tamol an yen boi, tia, imasap itor boi, ai patun an balun isap tubun ilasa wa, ak man dal dugo woŋ mel en ka ilasa man iŋ ta iloŋ na wa. ");
INSERT INTO tbc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tan sen mi iganep balun isap, roun iganep yau dop boban ilasap, rugun iganep, nuŋon ifu wa. ");
INSERT INTO tbc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ak man tamol en saen anaŋ isulot idu yan ile man, bubarek iŋanep, yaup, anaŋ iŋane wa. Ata wo, anaŋ ŋanek san nal idu ya.” ");
INSERT INTO tbc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Fon igo ibol, “Anut san kagin panek niŋen o ata ru man ate tou ŋabip aloŋ ak i? Ata lo ŋututuŋanip ŋabol pe ilom itarpasi fufei wak i? ");
INSERT INTO tbc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tamol ta ai yaŋan mastet dubol dan patun iŋaneg siganen abi lo yaug ipae ya. Ai an san patun man kititik aman kawan, tan lo pae wa. ");
INSERT INTO tbc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ago bo man, saen paep isa den yaup ai tinan oŋ ilasa dop an lo ai aenta iriŋanai a, agop raen dam idirip ibalsarer dop kuseŋ ka ate wur dufuni wa.” ");
INSERT INTO tbc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus iŋ ru faŋan nek ago yak wei mi lo Anut san ru irupidaig duloŋ se ya. Ru sapita duloŋ go ilod itarpasi wo uyan an mi iri panim, nek ago ibol idu se ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iŋ pempem tamolpein malad lo mi ru faŋan funfun nam ibol ilasa na ya. Ak man saen iŋsan megeloum adi dida sed kisaek dumado dugo, ru faŋan an fidian sad fun mok iŋ kuai te ifulale idu dugo duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nal kisaek an lo gurai isi dugo, Jesus iŋanen megeloum adi irupidai, “Id wog nam you aen ate tau a.” ");
INSERT INTO tbc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Man niŋen o megeloum adi doup dibisawaig, wog lo disuda ya. Saen Jesus iŋ wog lo isuda man diŋaneg ida diyawaig diau a. Wog aenta dam sisem diau se ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Agog tim tubun ak ifure ya. Ago dugo you tubun geig imasag ibalsinig wog ilon lo iladu se yan lo wog isarir o igane ya. ");
INSERT INTO tbc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ago gug Jesus man iŋ wog taen te kalik iganeg yen padal a. Ago tag megeloum adi diaug dufufunig durupei, “Girek maŋau, id tumayau o tator da. Oŋ ata wo idsed o ilo ta isou na dak i!” ");
INSERT INTO tbc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Agog Jesus imasag, tim tamun da ipidaig igo ibol, “Itout! Tokabol!” Agog tim ifure na yan itout dugo you malin idu geig a. ");
INSERT INTO tbc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ago gug Jesus iŋsan megeloum adi irupidaig ibol, “Aŋ ata wo tubun mi arer dak i? Ak dugo, aŋ nen gamugo ilo rumok amam da i?” ");
INSERT INTO tbc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesus ago ibol dubo man iŋ dumasa saian dugo tubun kasik direr se ya. Ago dugo iŋsed nug dusumiani, “Tamol en enti mok i? Gidad tim tamun da dumasa yak dubo man awan duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aria, iŋ wog nam you aen ate diaug, Gerasin sad abaŋ lo disasau a. ");
INSERT INTO tbc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Saen Jesus wog an ibisei man, tamol ta mutou ibiseig ipalu ya. Tamol en ur saiak aman da ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iŋ mutou funfun lo imado na ya. Tamol aenta fon dusubani san, sein nam dam ta idaisuda geig na ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Saen wei mi banin ain didirig rasau sakar kasik ak nam ŋien banin dusubani a. Gug saen fidian iŋ rasau lubuŋ an ain dam ituteg isubari idu ya. Tamol an iŋsan dabai san fun man senamo geig a, tamol diabi anen tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nal fidian, tidom ad, mutou ilod lo, tan bubun fo dam isasai iwagiŋ dugo pat luon anda yak nam tinin ititale na ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aria, tamol en asau mi Jesus ile man, imaspalug yaug san na ilasag naon na turun isoluwi a. ");
INSERT INTO tbc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Agog awan tubun mi isasai dugo igo ibol, “Jesus, Anut lak na geig ak Nanun, oŋ mel ta ŋai lo i? Oŋ ru lak na geig ak nam Anut malan lo rupeip ubol, madai tubun geig ta panag na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Iŋ Jesus ago isumiani a, man dugo, Jesus iŋ imug mi ur an irupei la yak igo ya, “Oŋ ur saiak, tamol en biseip lasa wau!” ");
INSERT INTO tbc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aria, agog Jesus ur saiak an isumiani, “Oŋ yaŋa enti ak i?” Agog iŋ awan yabig igo ibol, “Ŋai yaŋag Legen, man dugo, maŋ wei kasik a.” ");
INSERT INTO tbc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Agog iŋ afon mi Jesus ilon iŋane oŋ se, agop Jesus ikudai dop idiraip aben an ta dibisei na wo isumiani se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aria, kitek asau tan bubun luan te man, bor malan tubun geig ak dunuaeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","An niŋen o ur sisaiak adi Jesus san na dumosiaig ago dubol, “Oŋ kudamap bor an luluŋad lo mau. Ulefunamap bor ilod lo ka miladu wa.” ");
INSERT INTO tbc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","An lo Jesus awok ibol tag, ur sisaiak adi dilasag diaug bor tinidi ilon lo diladu ya. Agog bor an fidian mi, sad sutek 2,000 igo yak, iŋ dumasag damab aen te dumaspalu dudug you duluk go dumat pasik a. ");
INSERT INTO tbc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tamol bor kagin dupidinai den disol go dumaspalu oŋ diaug, mel ilasa yan niŋen o tamolpein panu tubun ak lo yan, agod a gidigidad dumado dan, durupidaig duloŋ a. An lo man tamolpein iŋ mel dugo mok ilasa amaiak dile wo dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Saen Jesus san na dilasa man, tamol imug mi ur sisaiak anda yan dileg durut dugo direr saian geig a. Man ata wo, gamu tamol en idagom dugo kankan uyan uyan aman da, ago dugo yamel sen ipulaug imasig imado dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Agod tamolpein a iŋsiganed malad nam mel a ilasa dugo dile yan, iŋ tamolpein dupalu yan mel dugo mok ilasa yan durupidaig duloŋ a. Ago dugo mel dugo ilasa yan tamol lo agod bor lo dam, durupidaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Man niŋen o tamolpein an fidian awad dutumanig Jesus iŋaned aben ibiseip yau o ago dumosiai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Saen Jesus wog lo isuda dugo tamol e Jesus ikubune yan ida diau o maeg iganeg isumiani se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Gug Jesus awan ta yabi nag igo ibol irupei, “Oŋsigane murou sad na waup, Tubun en ilo muŋanek sapita ipano, agod sapita ibinawo dam ubol idu dop duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ago tag tamol an yaug, distrik a yaŋan TenTaun dubol dan ilon lo tureŋ yabi oŋ dugo, mel fidian Jesus iŋ lo igane an tamolpein naod na ibol idu se ya. Ago dugo a fidian iŋanen ru duloŋ an durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aria, saen Jesus iŋanen megeloum adi dida tan an dibiseig, wog nam you aen ate afon diau a. Saen loŋ na disasau man, tamolpein wei mi dupalug dutumani dugo doup tubun ak Jesus dubuluwi a. Jesus iŋ you siŋiren na imado se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ago dugo ubou ab ta san titianek tamol adi luluŋad lo tamol ta yaŋan Jairus iŋ Jesus san na yau a. Iŋ Jesus ile tag naon na turun isoluwi a. ");
INSERT INTO tbc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ilo muŋanek ru lo isumianig igo ibol, “Ŋaineg nanug pein imat o da. Oŋ palu, bani iŋ tinin fufo na ganep, afon uyan ilasa dop kumaen imado wa.” ");
INSERT INTO tbc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","An lo Jesus imasag iŋ da diau a. Diau oŋ dugo tamolpein malan tubun an Jesus ŋien aban diri dugo Jesus dusupini se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aria, aben ante man pein ta tinin ilon lo subam anda, nek nal milaen mi dar tinin lo ilasa se, anaŋar 12 ago imado se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iŋanen moni samun fidian dokta tinid fo ikukule yau pasik, gug subam an ta digane itout na ya. Tia, subam an yau tubun dugo madai tubun geig ifuni yau oŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Iŋ imug mi ru Jesus niŋen o iloŋ dugo ilon igo isou, “Ŋai banig nek Jesus san kulos milaen ak ŋusupuri ŋile gup, tinig fon uyan ilasa wa.” Ago tag iŋ tamolpein a Jesus diri an luad isag Jesus patun fo irig yaug san kulos bitiŋen te yabi ile ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ago dugo saen nek an lo mi iŋanen dar tinin ilon lo yan igos a. Ago dugo iŋ ilon lo sen ikubiani ak Jesus iŋanen subam igane itout a. ");
INSERT INTO tbc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ago dugo Jesus dam ilon lo sen ikubiani kisaek oŋ ak dabai iŋanen tinin lo yan kuai te ilasa ya. Ago tag doup luluŋad lo idaŋsag isumianaig ibol, “Enti ŋaisag kulos isupuri ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Saen iŋanen megeloum adi ru en duloŋ man, awan diabig igo dubol, “Oŋ ule yak, tamolpein wei mi oŋ dusupino futano da, ago bo man oŋ ka ubol ‘Enti ŋai ibiag ak i?’” ");
INSERT INTO tbc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ak man Jesus naon idaŋsa idaŋla dugo talpein enti mok ile wo malan yau se ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Agog pein an, mel e iŋ o ilasa yen iloŋ oŋ go Jesus san na ipalu ya. Iŋ irer dugo isuruwor se ya, ago dugo naon na turun isoluwig mel fidian ilasa yan kuai te irupei a. ");
INSERT INTO tbc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Agog Jesus igo ibol irupei, “Nanug pein, oŋsigane ilo rumok iginiog uyan lasa ya. Oŋ ka ilo maror lo wau a, agod oŋane subam itout yau geig a.” ");
INSERT INTO tbc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ago dugo Jesus ru an ibol yau oŋ di imado dugo, tamol ta Jairus san ab lo yak ru diganeg Jairus san na yaug ago dubol durupei, “Oŋane nanu pein imat la ya. Gidad, girek maŋau aen ta utog na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ak gug Jesus iŋsad ru an patun ipanig, Jairus irupei, “Oŋ urer umoi. Nek ilo lo rumok mi wa.” ");
INSERT INTO tbc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Agog Jesus tamolpein fidian ŋien aban diri wan o imoi a, nek Pita, Jems agod iŋ tein Jon, nuŋod utol anami iŋ dida diau a. ");
INSERT INTO tbc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Diaug, ubou ab gurman san ab ate dilasa dugo Jesus malan yaug tamolpein tinaŋ muguruŋ tubun kasik diganeg dumado dugo yil a. ");
INSERT INTO tbc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Saen ab ilon lo iladu man, irupidaig ibol, “Aŋ ata wo tinaŋ aru agane dugo liliŋan dam tubun geig agane dak i? Nanuk en ta imat na ya. Tia, iŋ ŋioŋ mi yabi da.” ");
INSERT INTO tbc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ago ibol man disel go kukok an digane ya. Gug Jesus tamolpein fidian ab ilon lo yan ikudaig, patun fo dilasa diau dugo, nanuk an tinan taman, agod megeloum a iŋ da dumado yan, iŋal go dida galuŋ a nanuk yen dan lo diladu ya. ");
INSERT INTO tbc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesus pein bakan an banin te yabig, Arameik ru lo igo ibol, “Talita koum!” Ru an fun man “Pein bakan ŋurupaio da, masa!” ");
INSERT INTO tbc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ago ibol dugo gamu nam nanuk pein an imasag itor. Iŋ pein bakan, iŋsan anaŋar 12 a. Aria, iŋ kulob an dile man durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Agog Jesus nanuk tinan taman an kudod yabig irupidai, “Ru mel en niŋen o tamolpein aenta ta arupidai na wa!” Agog nanuk an anaŋ dupanip yani wo irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aria, Jesus iŋ megeloum adi dida panu an dubuseig iŋsinan panu Nasaret na dumul diau a. ");
INSERT INTO tbc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ubou nal idu dugo Jesus siganed ubou ab lo iladug tamolpein naod na Anut san ru ifulale pidinai se ya. Tamolpein wei mi iŋsan ru duloŋ go durut saian a. Agog nug dusumiani ila iso dugo igo dubol se, “Aben dugon te mok tamol en mel en fidian iŋane yak i? Maŋau e iŋ lo yen den dugon te iŋane yak i? Ale, kulob e banin nam igane na yen man tubun geig a! ");
INSERT INTO tbc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ak man tamol en taloŋ uyanan a, en ab bek tamol amaiak i? En Maria san nanun a. Iŋanen tein muroun man Jems, Joses, Judas agod Saimon. Iŋanen lun muroun id luluŋad lo dumado da.” An lo iŋ Jesus saian dupani a. ");
INSERT INTO tbc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Gug Jesus igo ibol irupidai, “Profet ta tamolpein aenta sad malad lo yaŋan aman tia yak ago ta itor na da. Tia geig a. Ak gug nek iŋsinan panu lo, iŋsinan muroun muroun luluŋad lo, agod iŋsinan ab lo dam, atna mi iŋ yaŋan aman tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Man niŋen o Jesus ante kulob dabai anda yak ta igane san ta idaisuda na ya. Nek talpein kisaek kisaek subam amad da yak tinid fo banin iganeg ikubuniai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ago dugo iŋ tamolpein ilo rumok amad tia yan niŋen o irut saian geig a. Agog Jesus iŋsiganen panu ibiseig gidigidad yaug panu panu itor dugo tamolpein ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Agog Jesus iŋanen megeloum 12 iŋsan na dupalu wo igiai a. Dususag Jesus tamol adi emaiak iŋ wagen lo ur saiak adi tamolpein tinidi ilon lo yak dukudaip diau san dabai ipidinai a. Agog itarpasaig fun iganeg uraru uraru mi idinaig diau a. ");
INSERT INTO tbc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iŋ gamugo diau dugo kududod yabig irupidaig iŋ gidad tureŋ yabek san biouŋ ta disini na wa, nek makud mi a. Ak man latamad tia, badam tia, moni iŋsad let lo dam tia, ago tureŋ diabi wa. ");
INSERT INTO tbc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Iŋ ka sendal ŋied fo didiri wa, ak man yamel taidam titired lo didiri san geg ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Agog iŋ ibol irupidai, “Aŋ aben dugon te ab ta lo aladu wan, ate mi ab an san tamolpein dida amado yau nap panu an abisei wa. ");
INSERT INTO tbc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Agod panu ta ate ta diŋiliaŋ uyan dop aŋsam ru dam duloŋ o dumoi tap, saen abisawai o dop, ŋiemi apiltip san gufgaf panu an ate idu dop dile wa. An man kob ta murnap iŋaned ilo rumok tia yak san naon iŋ mok diŋane wak igo ya.” ");
INSERT INTO tbc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ru an ibol itout dugo megeloum adi nuŋod uraru urarum dufufurak go diau a. Iŋ panu panu ate tamolpein igo durupidai se ya. “Aŋ aŋanem saian an fidian patum apanip ilom ibilisa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Agod iŋ ur sisaiak tamolpein tinid lo yan wei mi dukudaig diau se ya. Ago dugo gureŋ kitek nam tamolpein wei mi subam amad da yan tinid fo dububunig lo dukubuniai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kiŋ Herod iŋ melmel e Jesus san megeloum adi digane se yan niŋen o iloŋ a. Man dugo, nal an lo man Jesus san yaŋak tamolpein malad lo tubun geig ilasa la ya. Ta dubol, “Suguek san Jon iŋ tamolpein dumat la yak luluŋad lo fon imasag kumaen imado da, nek fun amaiak niŋen o dabai funfun en tinin ilon lo urat digane da.” ");
INSERT INTO tbc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gug aenta dubol, “En man Elaija.” Agod aenkadi dubol, “Iŋ man profet ta mi a, nek ibol profet adi wagam san igo mi a.” ");
INSERT INTO tbc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ak man saen Herod iŋ Jesus ata kulob igane idu se yan san ru iloŋ man igo ibol, “Jon man bo buron ŋitartig imat la yak gug fon kumaen imasa da ya.” ");
INSERT INTO tbc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Iŋ ago ibol a, man dugo, imug mi iŋ yu tamol adi idinaig Jon diabi wo diau a. Ŋien banin dusubanig subanek ab lo digane ya. Man ata wo? Herod iŋanen tein Filip san iwon, yaŋan Herodias, ilo uyan ipani san niŋen o iŋ Jon subanek ab lo igane ya. Imug mi Herod pein en iŋsan tein banin na iŋaneg iŋ da nug diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Gug Jon iŋ Herod ru en irupei, “Oŋsigane tei san iwon da ator tap, oŋ kubiaeŋ ta uri pani na da.” ");
INSERT INTO tbc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Amaiak niŋen o Herodias tiŋaen saian go Jon lo siai iganeg imado na ya. Iŋ Jon ifuni imat o ilon tubun mi yen a, ak gug iŋsen mi ago igane san ida ta isuda na ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Man dugo, Herod Jon niŋen o tubun mi irer se ya. Iŋ iloŋ ak Jon iŋ tamol itaot di gun a, an niŋen o talpein ta Jon muruan ipani san niŋen o iparfutani fufei na ya. Nal wei mi iŋ Jon da diŋiŋeŋ go Herod ilo uyan lo iŋanen ru iloŋ se ya. Ak gug ilon weiwei dugo ru fun iloŋ uyan san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nal ta idu man dal ta Herodias idinaip Jon dufuni imat san an ilasa ya. Nal a Herod san tinan gubak mi igansi an san saen ilasa ya, an lo Herod soubul igane ya. Iŋ ru iganeg iŋanen gabman gurman adi, yu tamol unbiek adi, agod tamol adi malan te yak Galili distrik lo yan, fidian dupalup anaŋ diani wa. ");
INSERT INTO tbc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aria, anaŋ diani dugo Herodias nanun pein iladug naod na isuluwai se ya. Herod iŋanen turan dida dile dugo malad bulbal dugo ilod tubun mi uyan a. Man niŋen o kiŋ Herod nanuk pein an irupei, “Oŋ mel dugon niŋen o ilo ibol tap, oŋ ka sumianag dop ŋai ŋupano wa.” ");
INSERT INTO tbc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Agog ru lak na geig nam iŋanen ru dabai ipanig ibol, “Oŋ ata mel niŋen o sumianag, gidad ŋaisag kagin panek aben ŋibitip wadan ŋupano san sumianag a, ŋai ka ŋupano mok a.” ");
INSERT INTO tbc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Agog pein baras an yaug, tinan isumiani, “Ŋai ata mel ipanag o ŋusumiani wak i?” Agog tinan awan yabig ibol, “Suguek san Jon san kabuŋan.” ");
INSERT INTO tbc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Agog pein baras an ririan yaug kiŋ san na ilasag irupeig ibol, “Ŋai ilog man oŋ gamu nam ru ganep suguek san Jon iŋsan kabuŋan daeg fo diganep disini dupalup dupanag a.” ");
INSERT INTO tbc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herod ru an iloŋ go ilon muruan tubun mok a. Ak man ru lak na geig an gubak mi ibol ilasa la ya, agod iŋanen turan adi malad lo iŋsan awak aban ipani an niŋen o dam, awan ibilisa wo ilon ta yen na ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ago tag iŋ ririan yu tamol ta talpein ifuni imat san an idinig yaup suguek san Jon buron itartip isini ipalu wo ibol a. An lo yu tamol an yaug, subanek ab ilon lo Jon buron itartig, ");
INSERT INTO tbc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kabuŋan daeg lo iganeg isini ipalug pein baras an ipani a. Agog iŋ isini yaug tinan Herodias ipani a. ");
INSERT INTO tbc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Saen Jon san megeloum adi mel en duloŋ man, dupalug tubabun diŋaneg disini diaug mutou lo digane ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aria, saen Jesus san megeloum adi tureŋ diabig itout go dumul diaug Jesus dida dutumanig kulob funfun digane, agod piteŋanek a tamolpein durupidai an da, naon na dubol idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ago dugo nal an lo man tamolpein wei geig Jesus megeloum adi dida sad na diau dumul oŋ dugo iŋ dunuai anen tia ya. Man niŋen o Jesus iŋ megeloum adi irupidai, “Id tumasap, aben ta tamolpein an tia yak ate taup, idsed kisaek dop kitek yaes tabal a.” ");
INSERT INTO tbc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ago ibol tag wog lo disidag, aben ta yoitout tamolpein an tia yak ate yaes dubal o diau a. ");
INSERT INTO tbc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ak man tamolpein panu fidian lo yan malad yaug dil duloŋ, ago yan lo wei mi dumasag ŋied nam dumaspalu oŋ you dulubanig, dumug diau silatik oŋ go, loŋ a Jesus iŋanen megeloum adi dida disasau wo yan ate dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Saen Jesus wog ibiseig loŋ na idu man, doup malan tubun an afon yil a. Agog iŋ ilon imuŋanai a, man ata wo, tamolpein an nek ibol sipsip titianek tamol amad tia yak igo woŋ a. Ago tag imasig imado dugo mel wei mi ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ru duloŋ dugo yaug gurai isi dugo, iŋsan megeloum adi san na dupalug ago dubol, “Aben en yoitout a, ad dam idu yau la ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Man niŋen o tamolpein en dinaip dufurak pe gidigidad diaup aben siŋired na yan san panu te anaŋ didad pe diani.” ");
INSERT INTO tbc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ak man Jesus awad yabig igo ibol, “Aŋ mel ta apidinaip diani.” Agog iŋ dubol, “Maŋ tamolpein ago yak bret madad pe mufutai san ta idaisuda na ya. Maŋ fidian kalam 8 urat miganep moni idaisuda miŋane gup, bret idaisuda mi madad a.” ");
INSERT INTO tbc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Agog Jesus isumianai, “Aŋ bret sapita da yak i? Aup ale.” Agog diaug dileg dumul dupalug durupei, “Kafen, agod iy uraru a.” ");
INSERT INTO tbc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Agog Jesus tamolpein an irupidai, “Aŋ sem ibitaŋ pe warou wei mi alasap gafurfur fo amasip amado.” ");
INSERT INTO tbc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ago tag iŋ sed ibitaig doup kitek wei mi dilasa, aenta talpein 50, aenta 100, ago dumasig dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Agog Jesus bret kafen agod iy uraru an iŋaneg, kumaen panu baŋen lo malan yabisag, ilo uyan ru Anut ipanig bret an yafute idug megeloum adi ipidinai a. Agog iŋanen megeloum diŋaneg tamolpein duwae pidinai a. Nek ago mi iy uraru an igile kititik go megeloum ipidinaig diaug tamolpein dupidinai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ago dugo iŋ fidian mi bret an diani dugo fidian luad ipuk. ");
INSERT INTO tbc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aria, dunuai itout gug, megeloum adi dumasag, anaŋ wadan ta diani na yan dutumanig, sareg 12 anua. ");
INSERT INTO tbc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tamol a dunuai an dusutai man 5,000 a. ");
INSERT INTO tbc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aria, saen anaŋ dianig itout man, Jesus iŋanen megeloum adi gugurut ipidinaig, iŋ wog lo disidap you aen ate panu yaŋan Betsaida na dumug diau wo irupidai a. Ago dugo iŋsen man imadop, tamolpein an fidian idiraip dufurak iŋsiganed na dumul diau wo, ago irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Saen tamolpein idinaig diau pasik man, iŋ sen mi did fo Taman san na igudani wo isuda ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Saen tidom idu man, wog an mayau na iyawai se ya, ago dugo Jesus iŋ tan na sen kisaek imado ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iŋ malan yaug megeloum adi maeg diganeg dufulani dugo yaes ifu dugo yil a. Man dugo, tim tubun ifure dugo naod yabi se ya. Saen salso idu man, iŋ you aten fufo sad na yau a. Iŋ iriŋanai o ilon yen manoŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ak man saen iŋanen megeloum adi Jesus you aten fufo itor dugo dile man, iŋ tamol ŋutun ta dile ago dubol dugo disasai a. ");
INSERT INTO tbc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Man dugo, iŋ fidian Jesus ago dile an lo tubun mi direr dugo dusuruwor se ya. Ak man Jesus irupidaig ibol, “Dabai aŋane, en ŋaiseg, arer amoi!” ");
INSERT INTO tbc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Agog yaug wog fo isudag dida dumado dugo tim ifure yan itout a. Megeloum adi ago dileg durut saian dugo ilod weiwei geig a. ");
INSERT INTO tbc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ata wo? Jesus enti mok an duloŋ uyanan an niŋen o ilod itau a, iŋ bret lo kulob igane an dile yak gug kulob an kankan Jesus niŋen o ta ipidinai uyan na ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aria, saen Jesus megeloum adi dida you aen ate dupalu man, tan titin yaŋan Genesaret dubol dan ate loŋ na disasau a. ");
INSERT INTO tbc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iŋ wog lo dudu dugo aben an san tamolpein malad yaug ririan Jesus dile duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","An niŋen o dumasag dumaspalu oŋ gidigidad diau dugo ru duwae se ya. Agog tamolpein wei mi iŋ talpein subam amad da yak kapal fo dien dan dusug aben dugon te Jesus imado den ate diŋal diau se ya. ");
INSERT INTO tbc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ago dugo aben dugon te Jesus yaug ilasa yan, taun tubun ak boi, tia panu tubun ak boi, tia, kititik ak boi, ate iŋ subam adi kapal fo dusug didaeŋ aben lo didiraisig dien se ya. An lo Jesus sumeik isusa dop dusumianip iŋanen yamel bitiŋen mi ka diabi dile wa. Agog talpein a diabi dile yan fidian mi, Jesus ikubuniaig uyad isusa ya. ");
INSERT INTO tbc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aria, saen Farisi adi, kubiaeŋ san girek maŋau aenta dida Jerusalem na dupalu man, Jesus dulubanig, ");
INSERT INTO tbc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesus san megeloum aenta, banid nun anda yak dida anaŋ diani se yan dil a. Iŋaned tamol kagin igo ibol, iŋ banid dufulanip ikok ilasa gup anaŋ ka diani wa. ");
INSERT INTO tbc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Man dugo, iŋaned kagin igo ya. Farisi adi, agod Juda adi fidian mi dam, iŋ imug mi banid dufulani gup anaŋ diani wa. Iŋ ta dufulani na tap, iŋ dida anaŋ ta diani na wa. Dal an lo iŋ tubud baged sad tamol kagin diri dupani na yan ago mi iŋ dam duri da. ");
INSERT INTO tbc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Agod saen didaeŋ aben dibiseip siganed ab lo diau duman, iŋ anaŋ ta diani na wa, tia, iŋ dusug pe tinid ikok gup anaŋ diani wa. Tamol kagin aenta wei kasik dam iŋ kagin dupani da. Nek ibol gab fulanek, bod daeg fulanek, agod mel san kapen sensen bras nam digane yan, mel igo yan fidian niŋedi wo tamol kagin yen da.) ");
INSERT INTO tbc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aria, Farisi adi iŋ kubiaeŋ san girek maŋau adi dida awad dutumanig Jesus dusumiani, “En ata wo oŋane megeloum adi iŋ tubud baged sad tamol kagin iri panim ago ta dutor dumado na dak i? Iŋaned banid ikok tia yak ate anaŋ diani da.” ");
INSERT INTO tbc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ago tag Jesus irupidaig ibol, “Aisaia iŋ profet ru itaot mok aŋ balek uraru adi niŋemi wo ibol ilasa ya. Girek igire yan igo ya, ‘Tamolpein en awadi nam yaŋag diabisa da, ak man bubedi man asau geig ŋai lo yen da. ");
INSERT INTO tbc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iŋ sen kawan ŋai ubou ag dile da, man dugo, piteŋanek a tamolpein durupidai dan man nek tamol iŋsiganed ilo sou mi a.’ ");
INSERT INTO tbc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ru kubiaeŋ Anut gubak mi ipanaŋ an, absukali dugo tamol kagin an mi abi dabai da.” ");
INSERT INTO tbc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Agog iŋ fon irupidaig igo ibol, “Aŋ luluŋam lo kagin igo yak yen da. Aŋ ru kubiaeŋ Anut ibol an gigin na agansi, an lo aŋsiganem tamol kagin ari apani da. Agod aŋ ilom lo kagin en uyanan geig ago abol da! ");
INSERT INTO tbc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gubak mi Moses igo ibol, ‘Oŋane tina tama awad paen na mado dop kagin pidinai o uyanan a.’ Agod, ‘Ta iŋ awan nam tinan taman imisilanai tap man, dufuni imat a.’ ");
INSERT INTO tbc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ak man aŋ abol, ‘Tamol ta taman boi, tinan boi, igo irupei, mel ta ate ŋai ka ŋibinawo san niŋen o man Korban’ (ru an fun man, Anut mel an ŋien ŋupani la ya), ‘an niŋen o man, o kabel, ŋai mel an ŋupanaŋ san tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","An lo tamol an fon binawek ta tinan taman niŋedi wo igane pidinai san aŋ ta alefuni na wa. ");
INSERT INTO tbc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dal emaiak lo, aŋanem tamol kagin tamolpein duri dupani wo abol den lo mi, aŋ aganeg Anut san ru an nuŋon tia ya. Agod mel wei mi taidam naok nek ago yak agane da.” ");
INSERT INTO tbc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Agog Jesus iŋ fon tamolpein fidian siŋiren na dupalu wo igiai a. Dupalug, ru ago ibol irupidai, “Aŋ fidian kududom agurep, ru en ŋabol dop, aloŋ fufei wa. ");
INSERT INTO tbc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tamol ta mel kuai tep tiŋaen lo yau dan nun ta ipani na da. Tia, mel tiŋaen lop awan lo ilasa damaiak tamol ilon nun ipani da.” ");
INSERT INTO tbc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus tamolpein tumanek an ibisawaig ab lo iladu man, iŋanen megeloum adi ru faŋan en niŋen o dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Agog iŋ isumianaig ibol, “Ak dugo, aŋ dam an aloŋ san tia i? Aŋ ta ale na yak, mel ta tamol tinin kuai fo yak, tamol ilon yaup iganep nun ilasa san tia yan aloŋ ak i? ");
INSERT INTO tbc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Man dugo, mel an buben lo ta yau na ya, tia, tiŋaen lo yaug dubei san dal irig ilasag itout yau a.” (Jesus ru emaiak ibol an lo anaŋ fidian nuaeŋ san uyan ak ago ibol a.) ");
INSERT INTO tbc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Agog ibol oŋ, “Mel a tamol ilon lo yen dugo kuai te dilasad amaiak tamol ilon nun ipani da. ");
INSERT INTO tbc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Man ata wo? Mel naok naok emaiak tamol ilon lo dien den, iŋ buben mok ilon lo yak kuai te dilasa da, kankan saiak, jeit kagin, gumagam kagin, tamol ifuni imat dak, turan iwon ida dien dak, ");
INSERT INTO tbc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mala sek kagin, nun kagin, siai kagin, uf ru, se pitianoi kagin, agod burau kagin. ");
INSERT INTO tbc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mel saiadi emaiak fidian talpein ilon lo yak kuai te dilasa da, nek mel amaiak mi talpein an ilon nun ipani da.” ");
INSERT INTO tbc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ago gug Jesus imasag, aben an ibiseig, gob adi sad taun tubun ak uraru, Tair Saidon da sad lubanek lo yaug, ab ta lo isidag, ante kitekan yaes ibal a, ate tamolpein ta san tureŋ duloŋ man imoi a. Ago bo man iŋ mianuk lo imado san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pein ta iŋanen nanun pein ur saiak anda yak iŋ ru tim Jesus ante imado dan iloŋ a. Ririan imasag Jesus san na ipalug, naon na turun isoluwi a. ");
INSERT INTO tbc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pein en man Grik, agod distrik tubun ate imado dan Siria provins, agod titin ta dugon te tinan igansi an aben ta loŋ siŋiren na yaŋan Fonesia dubol da. Aria, Jesus naon na turun isoluwig, Jesus iŋ nanun pein tinin lo ur saiak ikudip yau wo ilo muŋanek ru lo isumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iŋ pein an irupei, “Umoi dop, nanuk ata diani wo dumat dan malmalan diani wa. Maŋ nanuk adi sad anaŋ miŋanep goun adi diani wo sad na mabal tap, an ta uyan na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ak man pein an awan yabig igo ibol, “Awo, tamol Tubun en ubol mok da. Gug goun dam badim paen na dumado dop, nanuk sad awad aban idu man ka diani wa.” ");
INSERT INTO tbc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ago tag Jesus ibol, “Ru en rupaiag ak niŋen o ka wau a. Ur saian an oŋane nanu pein tinin lo yak ibiseig yau la ya.” ");
INSERT INTO tbc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Agog iŋ sinan ab lo yaug nanun pein gadab fo yen dugo ile, agod ur saiak dam ibiseig yau a. ");
INSERT INTO tbc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aria, Jesus fon imasag, Tair lubanek ibiseig, isidag yaug, taun tubun ak yaŋan Saidon ante ilasa ya. Agog aben an ibiseig, imul idug yaug “TenTaun” lubanek lo ilasag, You Galili siŋiren na isusa ya. ");
INSERT INTO tbc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ante man tamol ta kududon ipakuk agod balen muruan ak diŋaneg Jesus san na dupalug, banin tamol an tinin fo igane wo dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Agog Jesus tamol an iŋaneg, ida tamolpein malan tubun an dibisawaig gigin na nuŋod uraru diau a. Ante gug Jesus iŋsen banin kikoun tamol an kududon anenaim lo isousoug sen banin fo ilusug, ate tamol an balen yabi ile ya. ");
INSERT INTO tbc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Agog Jesus naon yabisag malan lak na isida dugo yaes yabituani gug tamol an irupei, “Efata.” (Ru an fun man: upuk.) ");
INSERT INTO tbc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ago ibol go tamol an kududon uyan ilasag balen dam pasauman go ru iloŋ go iŋiŋeŋ uyanan se ya. ");
INSERT INTO tbc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus ru dabai anda nam mel a dile yan tamolpein aenta ta durupidai na wo ibol. Ak man urat wei kasik igane yan lo urat an san ru dam tubun mi diŋiŋeŋ ila iso se ya. ");
INSERT INTO tbc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ru an duloŋ go durut saian geig a. Iŋ igo dubol, “Tamol en mel fidian igane man uyanan geig ak mi a. Iŋ iganeg tamol ta kududon ipakuk an ru iloŋ ak, agod tamol ta awan itau an ru ibol a.” ");
INSERT INTO tbc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saen an lo tamolpein malan tubun mok fon Jesus san na dutumani a. Dumado dugo iŋaned anaŋ latamad diani pasik a. Ago tag, Jesus iŋanen megeloum adi dupalu wo igiai a. Agog dupalug dilasa dugo Jesus irupidai, ");
INSERT INTO tbc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ŋai tumanek tubun en ilog imuŋanai da, man dugo, gamu nal utol yau la dugo iŋ ŋai da mumado na ya, ak gug anaŋ ta diani san etna tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ŋai iŋ ŋidinaip dimatigen oŋ iŋsiganed na diau tap, dal na rei ifu dop malad itilani wa. Agod aenta dal asau geig dupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iŋanen megeloum adi awan diabig dubol, “Aben yoitout en lo tamol ta, ka dugot na bret idaisuda iŋanep lo tamolpein en ifutai ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Agog Jesus isumianai, “Aŋ anaŋ bret sapita yen di?” Agog dubol, “Bret seven mi a.” ");
INSERT INTO tbc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Agog Jesus tamolpein an tan na dumasi wo irupidai a. Agog iŋ bret seven an iŋaneg, Anut ilo uyan ru ipanig, yafututeg, megeloum adi tamolpein duwae pidinai o ipidinai a. Agog diaug bret duwae ya. ");
INSERT INTO tbc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iy kititik kadi iŋ dida dien a. An lo Jesus iy an iŋaneg, Anut ilo uyan ru ipanig, megeloum adi irupidaig iy en dam tamolpein duwae pidinai o diau a. ");
INSERT INTO tbc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aria, tamolpein anaŋ an dianig idaisuda geig a. Diani itout gug megeloum adi dumasag anaŋ samsamun dutumanig sareg seven lo ditaneg awad isa ya. ");
INSERT INTO tbc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iŋ tamol adi a dumado yan dusutai man 4,000 igo ya. Agog didinaig dumul diau a. ");
INSERT INTO tbc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Agog Jesus megeloum adi dida wog lo disidag, Dalmanuta distrik ante diau a. ");
INSERT INTO tbc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ante man Farisi adi dupalug Jesus dusumiani wo fun digane ya. Iŋ ilod man Jesus bitinaek lo digane wo ago yen se ya. Amaiak niŋen o iŋ kulob kumaen panu san ta kob igo woŋ igane dop dile wo dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus iŋsad ru an iloŋ go iŋsen ŋutun ilon lo yaes yabituanig igo ibol, “Ata wo aŋ tamolpein gamu e amado den kulob girager ta kob igo woŋ ŋigane dop ale wo ilom yen dak i? Ŋai ru rumok ŋurupaiaŋ da, kob naok igo yan ŋai ta ŋupanaŋ na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Agog iŋ ibisawaig, megeloum adi dida fon wog lo disidag, diaug, tan aen ate dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aria, megeloum adi ilod iŋaoŋ go bret ta disini na ya, wog lo man bret kisaek o lian yen a. ");
INSERT INTO tbc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus ru kagin ipidinaig ibol, “Kagin agane, Farisi sad yis, agod Herod san dam niŋen o kagin agane uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Megeloum adi ru an duloŋ go iŋsed mi ru an san fun mok kuai dupani wo nug lo diŋiŋeŋ ila iso se ya. Agog dubol, “Iŋ ago ibol man fun, maŋ bret amama tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus megeloum adi dugo dubol se man iloŋ, ago tag isumianai, “Ata wo aŋ bret amam tia yak niŋen o nug lo akubiai dak i? Ak dugo, aŋ nen ta ale aloŋ na yak i? Ak dugo, aŋ kankan amam tia i? ");
INSERT INTO tbc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Aŋ malam da ya, ak gug aŋ ta ale geig na da. Nek ago aŋ kududom da ya, ak gug aŋ ta aloŋ geig na da. Mel en ilom iŋaoŋ ak i? ");
INSERT INTO tbc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Saen ŋai bret kafenda ŋafututeg tamol 5,000 ŋufutuwai an, aŋ sareg sapita lo anaŋ samukan atane yak i?” Iŋ awan diabig dubol, “Sareg 12.” ");
INSERT INTO tbc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Agod saen ŋai bret seven ŋafututeg tamol 4,000 ŋufutuwai an, aŋ sareg sapita lo anaŋ samukan atane yak i?” Agog dubol, “Seven.” ");
INSERT INTO tbc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Agog iŋ ibol, “Aŋ gamugo aloŋ uyan dak i?” ");
INSERT INTO tbc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus iŋ megeloum adi dida panu yaŋan Betsaida ante diaug dilasa ya. Ante tamolpein ta iŋ tamol ta malan itau ak diŋaneg dida Jesus san na dupalu ya. Iŋ Jesus banin nam tamol an tinin yabi ile wo dugudani a. ");
INSERT INTO tbc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Agog Jesus iŋ tamol an banin te yabig, ida panu an dibisei a. Agog Jesus tamol an malan fo ilusug banin tamol an tinin fo iganeg isumiani, “Oŋ gamu abaŋ ka ule dak i?” ");
INSERT INTO tbc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Agog tamol an malan yabisag ibol, “Awo, ŋai tamol ŋeil da, ak man malag lo ai ditiliani dak igo mi a.” ");
INSERT INTO tbc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agog Jesus afon banin malan fo igane ya. An lo tamol an malan tubun mi ipuk go uyan isusag mel fidian ile fufei a. ");
INSERT INTO tbc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Agog Jesus tamol an sinan ab lo yau o idinig irupei, “Oŋ itaot sigane ab lo wau, panu lo ta ladu na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Agog Jesus iŋsan megeloum adi dida panu an dibiseig dal diŋaneg panu kititik taun Sisaria Filipai lubanek lo dien dan ate diau a. Dal te tureŋ diabi dugo iŋsan megeloum isumianai, “Tamol adi iŋ ŋai enti mok ago dubol di?” ");
INSERT INTO tbc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Agog iŋ durupei, “Aenkadi oŋ Suguek san Jon ago dubol dak, aenta oŋ Elaija dubol dak, aenta oŋ profet ta ago dubol da.” ");
INSERT INTO tbc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iŋ isumianai, “Ak man aŋsem ŋai enti mok ago abol di?” Pita awan yabig ibol, “Oŋ Kristus.” ");
INSERT INTO tbc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Agog Jesus ru kagin ipidinaig ibol, “Ŋai enti, aenta ta arupidaip duloŋ na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Saen an lo Jesus fun iganeg iŋanen megeloum adi ipiteŋanai man, Tamol Nanun iŋ madai wei mi ifuni wa, agod ubou san matu adi, pris gurman adi, agod kubiaeŋ san girek maŋau adi iŋ fidian Tamol Nanun patud dupani wa. Ago dop iŋ dufuni imat a. Ak gug nal utol gup iŋ fon imasap kumaen imado da wa. ");
INSERT INTO tbc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus ru an kuai te ibol irupidai a. Ago tag Pita iŋaneg ida gigin na diaug ru dabai nam Jesus ipei a. ");
INSERT INTO tbc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ak gug Jesus idaŋsag Pita patun ipani dugo naon megeloum aenta ipidinai dugo Pita ipeig ibol, “Satan, oŋ patug fo lasa wau! Man dugo, oŋ Anut san ilo girek ta uri pani na da, tia, oŋ tamol adi sad ilo girek an mi uri pani da.” ");
INSERT INTO tbc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Agog Jesus tamolpein igiaig, iŋsan megeloum adi dam kisaek mi dutumanig, igo ibol irupidai, “Talpein ta ŋai ŋieg aban iri wo ilon ibol duman, iŋ gidad sen yabi idup iŋsinan aigim isinip ŋieg aban iri wa. ");
INSERT INTO tbc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Man ata wo? Ta iŋsinan madok iganep uyan ilasa wo ilon ibol tap, iŋsinan madok mok an ideg yau a. Ak man ta iŋsinan madok ŋai niŋeg o, agod bilaluŋ uyanan ak niŋen o ibisei tap, iŋanen madok mok patun ipasi dop yen yau a. ");
INSERT INTO tbc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Man dugo, talpein ta tan en san filian fidian mi iŋane dop, iŋanen naon man iŋsinan madok mok malan isue tap, en dugo woŋ pe uyan ak i? ");
INSERT INTO tbc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ak dugo, iŋ ata mel tan en san, iŋanen madok nuŋon ak iŋane imul san ka ipani wak i? Mel ta igo yak yen man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tamolpein ensauta gamu dumado den aupasek agod kagin sisaiak san saen lo dumado da. Talpein ta saen en lo ŋaisag ru niŋen o miai ifuni tap, saen ŋaineg eŋel gun agod Tamag san girager da ŋupalu dop, ŋai nek ago mi talpein an niŋen o miai ifunag a.” ");
INSERT INTO tbc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Agog iŋ ru ibateg igo ibol irupidai, “Rumok ŋurupaiaŋ da, aenta ebo dutur den gamugo dumat dop, Anut san kagin panek an dabai aman da ipalu dop dile wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aria, nal 6 yau la gug Jesus iŋ megeloum utol, Pita, Jems iŋ tein Jon ago iŋal go dida did tubun ak ta ate disida diaug sed dumado se ya. Ante dumado dugo Jesus iŋ malad lo tinin ibilisag ilalaŋ idu dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ago dugo iŋanen yamel isapudadeg milkouk nuŋon geig ilasa ya. Milkouk an talpein ta tan en lo yamel marasin nam ifulanip ago ilasa san tia yak ago ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ago dugo malad lo dam Moses iŋ Elaija da dilasag, Jesus dida dutur go diŋiŋeŋ se yan megeloum dil a. ");
INSERT INTO tbc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Agog Pita Jesus irupeig ibol, “Girek maŋau, nek uyanan geig maŋ dam e mumado da! Oŋ ubol tap, lalai utol ente mabi wa, oŋane kisaek, Moses anen kisaek, agod Elaija anen kisaek dam mususe wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Iŋ fidian tubun mi direr dugo dusuruwor se yan lo, Pita ru dugo ibol an ta iloŋ uyan na ya.) ");
INSERT INTO tbc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Agog timtaen ta idug yafutanai dugo awak ta timtaen an ilon lo ilasag ago ibol, “En man ŋaineg Nanug, ŋai bubeg mok a. Awan aloŋ!” ");
INSERT INTO tbc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ago duloŋ dugo malad yau imul silatik oŋ dugo abaŋ dile itililani se yak gug tamol aenta ta dil na ya, nek Jesus mi sen kisaek siŋired na itur se ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Saen Jesus megeloum dida did an dibiseig dumul dudu dugo, Jesus ru dabai anda ipidinai a. “Aŋ aup mel e ale yan niŋen o tamolpein aenta ta arupidai na wa. Amoi dop Tamol Nanun imat pe mutou lo fon imasap kumaen imado dop, saen an lo mel e ale yen ka abol ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ago tag iŋ ru mel en niŋen o iŋanen ilo girek lo dutueg yen a, ak man iŋsed nug lo diŋiŋeŋ se ya. Iŋ nug lo dusumiaeŋ ila iso, “Ru e mutou lo fon imasa wo ibol en fun mok dugo yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Agog iŋ Jesus dusumianig igo dubol, “En ata wo kubiaeŋ san girek maŋau adi iŋ Elaija imug ipalu gup ak ago dubol di?” ");
INSERT INTO tbc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus awad yabig ibol, “En man ru rumok a, Elaija imug ipalup, mel fidian ikubuniaip imug dien ago mi dilasa wa. Ak man ata wo ru en digire yak i? Tamol Nanun tubun mi madai isini dop patud dupani wa. ");
INSERT INTO tbc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ak gug ŋai ŋurupaiaŋ da, Elaija ipalu la ya. Ago dugo iŋsiganed ilobol lo saian dupani se ya, nek ibol girek ta iŋ niŋen o ibol ak ago mi ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Saen Jesus iŋ megeloum utol an dida dumul go megeloum aenta sad na dilasa man, tamolpein malan tubun ak dutumanig dumado dugo dil a. Ago dugo kubiaeŋ san girek maŋau aenkadi megeloum adi dida ru lo nug diabi dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Agog tamolpein fidian saen Jesus dile man durut saian go ririan dumaspalu oŋ Jesus san na dupalug ilo uyan lo duyuŋani. ");
INSERT INTO tbc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Agog Jesus tamolpein isumianai a, “Aŋ kubiaek dugomaiak nug lo aŋiŋeŋ ila iso di?” ");
INSERT INTO tbc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Agog doup an luluŋad lo tamol ta awan yabig igo ibol, “Girek maŋau, ŋaineg nanug ur saiak anda yak oŋsa na ŋisini ŋupalu ya. Man dugo, ur saian en iganeg awan itau a. ");
INSERT INTO tbc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aben tata lo itor dop, ur ifunip ibili idu dop, awan lo subalbal ilasap, luon igurmip tinin ikikaip ti ibol yen da. Man niŋen o ŋai oŋsa megeloum adi ur saiak an dukudi wo ŋusumianai, ago bo man iŋ digane san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iŋ ru naon irupidaig igo ibol, “Aŋ ilo rumok amam tia, nal sapta ŋai aŋ da tumado wak i? Nal sapta muruan apanag dan ŋisinip yau ak i? Nanuk an igo aŋane apalu.” ");
INSERT INTO tbc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iŋ pinein an diŋane dupalu ya. Saen ur saian iŋ Jesus ile man, silei nam pinein an ifunig itarfunig ibili yau idug, tan na idududuruk dugo itububuluk yau imul dugo subalbal awan lo ilasa se ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus pinein an taman isumiani, “Nal sapita kagin an iŋ tinin lo ilasa yak i?” Taman awan yabig ibol, “Saen iŋ nanuk tusan lo mi kagin en iganeg ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nal wei mi ur saiak en ifunig daoŋ ipani dop yai lo, agod you lo ibili idup ifuni imat o igane se ya. Isop oŋ idaisudap mel ta iŋ lo gane tap, ilo imuŋanama dop binawama.” ");
INSERT INTO tbc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Agog Jesus taman irupei, “Ru e ‘Isop oŋ idaisudap mel ta iŋ lo gane tap’ ubol en ata wo ago ubol ak i? Talpein ilo rumok aman da man, iŋ o mel fidian mi ka ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ago dugo taman ririan iwagiŋ go ibol, “Ŋai ilog lo rumok. Ŋai binawag dop ŋaisag ilog yau imul dan ŋabi idu!” ");
INSERT INTO tbc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Saen Jesus tamolpein wei tinan dumaspalu oŋ dutumani se yan yil man, iŋ ur saiak an ru sakar nam ipeig igo ibol, “Oŋ ur saiak awa tau san agod kududo itau san, ŋai ru kubiaeŋ ŋupano da, biseip sen lasa, fon umul tinin ilon lo ta ladu na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Agog ur saiak an isasai saian dugo nanuk an tan fo itarfuni saian geig a, ago gug ibiseig yau a. Pinein an tan fo tubabun igo woŋ yen, ago tag tamolpein wei mi dubol, “Iŋ imat mok a.” ");
INSERT INTO tbc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gug Jesus banin yabig irae dugo, pinein an imasag itur a. ");
INSERT INTO tbc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Saen Jesus ab lo iladu man, megeloum adi dida sed kisaek dumado dugo Jesus dusumiani, “En ata wo maŋ ur saiak mukudi san ta idaisuda na yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iŋ ru naon irupidai, “Gudanek lo mi aŋ ur saiak naok igo yak ka akudi wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aria, Jesus iŋanen megeloum adi dida aben an dibiseig, tureŋ diabig diaug distrik Galili titiŋaem diau se. Saen ante diau man Jesus tamolpein aenta duloŋ o man imoi a. ");
INSERT INTO tbc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ata wo? Iŋanen megeloum adi ipiteŋanai se ya. Agog irupidai, “Tamol Nanun iŋanen ager adi sad banid lo digane wa. Iŋ dufuni imat, agop nal utol yau gup, afon imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ak man megeloum adi ru an san fun ta duloŋ uyan na ya. Taida mi, iŋ Jesus dusumiani wo direr se ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iŋ Kaperniam na dilasa ya. Saen iŋ ab ilon lo dumado dugo, Jesus isumianai, “Dal na aŋsem ata mel niŋen o nug lo akubiai yau imul se yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ak man iŋ dutokubol dumado se ya. Man ata wo? Iŋ dal na diau dugo iŋsed luluŋad lo enti iŋ tubun geig ak niŋen o dukubiai yau imul se ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ago tag Jesus imasi dugo, megeloum 12 an dupalu wo igiai a. Saen naon na dupalu man irupidai, “Talpein ta iŋ yaŋan tubun ilasa wo ilon ibol tap, iŋ gidad sen igane murna yau a, agod dam iŋ gidad tamolpein fidian sad biabi ŋilaŋal ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Agog iŋ nanuk nanun ta iŋaneg, megeloum adi luluŋad lo igunig itur a. Agog banin nam yabig ikubiaig igo irupidai, ");
INSERT INTO tbc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Talpein enti nanuk igo yak ta ŋai yaŋag lo iŋanep iyuŋani tap, ŋai dam iŋiliag go iyuŋanag da. Agod talpein enti ŋai iŋiliag duman, ŋai mi tia ya, tia, Enti ŋai idinag go ŋupalu yan dam iŋaneg iyuŋani da.” ");
INSERT INTO tbc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Jesus irupeig ibol, “Girek maŋau, tamol ta iŋ oŋ yaŋa ibol dugo ate ur sisaiak ikudai se dugo mile ya. Ago tag maŋ iŋ kulob ago igane yau o mupadau a, man dugo, iŋ id lo tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus irupei, “Aŋ iŋ abituani amoi. Man ata wo? Talpein enti ŋai yaŋag lo kulob dababai anda yak ta igane man, iŋ ririan ru saian ŋai niŋeg o ibol ilasa san tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Man dugo, talpein enti iŋ id o ager ta imado na dan man id turad a. ");
INSERT INTO tbc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","An lo ŋai ŋurupaiaŋ da, talpein enti iŋ, aŋ Kristus san ak niŋen o you kitek gab lo iganeg aluk o ipanaŋ dan, iŋanen naon ibisei san tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Agod talpein ta nanuk igo yak ŋai o ilon rumok dak ta iganep aupasek lo idu tap, talpein an gidad kagin igane wa. Man dugo, pat tinan buron lo disisi idup beig lo dibal pe isarir yau man bo uyan mok a. Man ata wo, an tia tap, ai wadan ŋai iŋ ŋupani wan iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Uloŋ. Oŋ bani turan aupasek lo udu san iginio tap, tutep ubal yau! Ago dop oŋ bani tia madok kumaen yen san lo ladu wo tap, an ta saian na ya. Man dugo, kabelan bani uraru mi diŋiliop Ades lo yai pempem ided dan lo dubulo wau banau. ");
INSERT INTO tbc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Agod oŋ ŋie turan aupasek lo udu san iginio tap, tutep ubal yau! Oŋ gidad ŋie tia madok kumaen yen san lo ladu wo tap, an ta saian na ya. Man dugo, kabelan ŋie uraru mi diŋiliop Ades lo dubulo wau banau. ");
INSERT INTO tbc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Agod oŋ mala turan iginiop au upas tap, mala an bilanip biliau a. Mala kisaek ama da madok kumaen yen san lo ka ladu wa. Kabelan mala uraru mi diŋiliop Ades san yai lo dubulo wau banau. ");
INSERT INTO tbc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aben ante man, ‘iŋsad kadum ta dumat na wa, agod yai imat san tia geig a.’ ");
INSERT INTO tbc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nek ibol saen Anut yai digane pani man beig dam alta fufo digane yak igo woŋ, Anut tamolpein fidian yai tinid fufo igane wa. ");
INSERT INTO tbc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Beig man biabi uyanan anda ya. Ak gug beig san gigen itout tap, aria dugo woŋ tamol ta san gigen an iganep beig oŋ ilasa da wak i? Amaiak niŋen o aŋ nugnug lo beig amam da ya, agod nug lo maror amam da amado wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Go Jesus imasag, panu Kaperniam ibiseig, you Jordan ituteg, titin ta Judea distrik a you an aen ate yen dan lo yau a. Ante tamolpein wei mi fon iŋsan na dutumani a. Agod Jesus iŋ fon iŋsinan kagin iri panim ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ago dugo Farisi aenta dususag dusubani wo igo dusumiani, “Idaned kubiaeŋ dugo ibol ak i? Mel ta niŋen o tamol ta iŋsan pein ka ibisei ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iŋ awad yabi, “Ru kubiaeŋ dugomaiak Moses ipanaŋ ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iŋ dubol, “Moses uyan ipani a, tamol ta iwon ikudi wo tap, nug banin diabi amaiak itute san girek ta igirep, iwon ipani gup ikudi yau a.” ");
INSERT INTO tbc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Agog Jesus ru naon igo irupidai, “Aŋ bubem pat oŋ an niŋen o Moses ru kubiaeŋ en igire panaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ak gug fun mok lo Anut man ‘tamol iŋ pein da idirai a. ");
INSERT INTO tbc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Fun an niŋen o tamol iŋ tinan taman ibisawaip iwon iŋanep nug dupini dupini wa, ");
INSERT INTO tbc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","an lo dop uraru an kisaek mi dilasa wa.’ Amaiak niŋen o iŋ uraru ago tia ya, iŋ man kisaek a, man dugo Anut iŋsen mi itumanai a. ");
INSERT INTO tbc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ak niŋen o kabelan melmel a Anut itumanai an tamol ta itute banau.” ");
INSERT INTO tbc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Saen megeloum adi Jesus dida ab ilon lo dumado man, ru en niŋen o Jesus dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iŋ ru naon igo irupidai a, “Tamol ta iwon ikudi yau dop pein sen ak iŋane tap, iwon imug ak malan lo man tamol en pein foun an da jeit digane da. ");
INSERT INTO tbc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Agod pein dam iwon tamol ikudi yau dop tamol sen ta iŋane tap, pein en dam iŋ jeit kagin igane da.” ");
INSERT INTO tbc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nal tag tamolpein iŋsiganed nanuk kititik diŋal go Jesus san na dupalug an lo banin nam ibiai ile wa. Ak man iŋanen megeloum adi dipidai se ya. ");
INSERT INTO tbc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Saen Jesus yil man tiŋaen saian go igo irupidai, “Nanuk adi ŋaisag na dupalu wo dop eilafu wa, akudai amoi. Man dugo, Anut san kagin panek aben man nanuk ago yak sadi a. ");
INSERT INTO tbc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ŋai rumok nuŋon ŋurupaiaŋ da. Talpein enti nanuk igo woŋ Anut san kagin panek iŋane tap, iŋ Anut san kagin panek aben ilon lo ka iladu wa. Ak gug iŋ nanuk oŋ ilasa wo imoi tap, iladu san tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Agog iŋ nanuk adi iŋal go ilataig, banin kabuŋad fo iganeg bar ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus tureŋ yabi wo dugo, pinein damag ta imaspalu oŋ iŋsan na ipalug naon na turun isoluwig isumiani, “Girek maŋau oŋ uya mok a, ata kubol ŋigane dop lo madok pempem yen yau san ka ŋiŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus ru naon ibol, “Oŋ ata wo ŋai uyag ak ubol di? Anut sen kisaek mi uyan aman a. ");
INSERT INTO tbc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Oŋ Anut san kubiaeŋ fidian uloŋ pasi a: oŋ ta funi imat umoi, jeit kagin umoi, ugam umoi, supalek ru ubol umoi, talpein ta rawip lo san melmel uŋal umoi, agod oŋ tina tama awad uri pani wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iŋ ibol, “Girek maŋau, ŋai nanuk log ipalug gamu en kubiaeŋ an fidian ŋiri ŋupani na ya.” ");
INSERT INTO tbc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus tamol an malan ti ibol ile dugo buben tubun mi ipani a. Ago dugo ru en irupei a, “Oŋ mel taida niŋen o mi katuka mado da. Umul waup, melmel a oŋ da yan udad pe moni ŋanep, tamolpein mel ad tia ak wae pidinai a. Ago dop kumaen panu lo filia senamo geig ilasap yen a. Ago gup palup ŋieg aban uri wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tamol an ru an iloŋ dugo ilon idug ilon ipapaog ibiseig yau a. Man dugo, iŋ tamol filian tubun anda ya. ");
INSERT INTO tbc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Agog Jesus idaŋsag malan yaug megeloum adi yil dugo irupidai, “Tamolpein ensauta a filian tubun amad da yan, Anut san kagin panek aben ilon lo diladu san muruan kasik a!” ");
INSERT INTO tbc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iŋanen megeloum adi ru an duloŋ go durut saian a. Ak gug Jesus fon ibol, “O nanug muroug, talpein Anut san kagin panek aben lo isadu san man muruan geig a! ");
INSERT INTO tbc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tamol filian anda yak Anut san kagin panek aben lo ka iladu wak, an rumok tap, aria kamel ta si gubaran lo yau san man pasauman geig a.” ");
INSERT INTO tbc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ru an duloŋ go nen durut saian a. Ago tag iŋsed nug ilon lo diŋiŋeŋ se ya, “Mago tap, enti mok patu pasek ka iŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus malan ti ibol go yil dugo irupidai, “Tamolpein mel en digane san ta idaisuda na ya, ak gug Anut lo mel ago man ta muruan na ya, ata wo, iŋ lo mel fidian man pasauman a.” ");
INSERT INTO tbc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Agog Pita ibol irupei, “Ule maŋ oŋ ŋie aban muri wo mel fidian mibisei a!” ");
INSERT INTO tbc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Agog Jesus igo ibol, “Ŋai ru rumok ŋurupaiaŋ da, talpein enti ab ibiseig, tia tein boi, tia lun boi, tia taman boi, tia tinan boi, tia nanun muroun boi, tia siganen tan boi, an ŋai yaŋag yabisa wo ibisei dop man, ");
INSERT INTO tbc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tan en lo Anut naon uyanan geig ipani wa. Gidad talpein an malan lo melmel a ibisawai an siŋaokan geig, iŋanen naon san melmel man nal 100 iriŋani wa. An lo naon ago yak iŋane wa. An man ab, tein taon, lun, tinan, taman, nanuk adi, abi dam fidian foun ak wei di wei mok iŋane wa. Ago gug dida madai di muruan funfun dam iŋane wa. Agod murnap mel fidian foun dilasa san saen lo man, iŋ kumaen pempem mi yen san an dam iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ak man talpein wei mi gamu iŋ malan te dan nal an lo man talpein kawan ak ago dilasa wa. Agod talpein wei mi iŋ tamol kawan igo dumado dan nal an lo malan te dilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aria, Jesus iŋanen megeloum adi dida Jerusalem dal diŋaneg, diau dugo Jesus imug yau se ya. Iŋ ilon Jerusalem na diau wo ago yen an niŋen o megeloum adi durut saian geig a, agod tamolpein a ŋien aban diri dan iŋ dida Jerusalem na diau san niŋen o tubun mi direr se ya. Saen an lo Jesus fon iŋanen megeloum adi iŋal go gigin na diaug iŋ mel dugo iŋ lo ilasa wan niŋen o irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iŋ ibol, “Aloŋ uyanan, id Jerusalem na tau da. Ante man Tamol Nanun diŋanep pris gurman adi agod kubiaeŋ san girek maŋau adi banid lo digane wa. Iŋ imat san ru ago duguni wa. Ago dop Juda tia yak sad banid lo digane dop lo ");
INSERT INTO tbc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","kukok aman diganep, dusulanip, lubum nam dufunip murna gup dufuni imat a. Ago digane wak man nal utol gup fon imasa dap kumaen imado da wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Agog Sebedi nanun uraru an, Jems iŋ Jon da, iŋ dususag Jesus dusumianig igo dubol, “Girek maŋau, maŋ iloma man, mel niŋen dugo musumiano wo dak ago ka gane panama wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ago tag Jesus isumianai, “Ata mel ŋai ŋigane panaŋ o ilom ibol di?” ");
INSERT INTO tbc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Agog iŋ durupei, “Ru gunip, oŋane girager san saen idu dop, maŋ oŋane badim fo oŋ siŋire na mumado wa, kisaek oŋ bani won ak lo dop, kisaek oŋ bani ŋas ak lo wa.” ");
INSERT INTO tbc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ak man Jesus awad yabig irupidai, “Ata mel niŋen o asumianag dan niŋen o aŋaoŋ da. Ak dugo, gab a lo ŋai ŋaluk amaiak lo aluk o aŋ idaisuda yak i? Tia, suguek a ŋai ituanag amaiak dam aŋ ituanaŋ dop man, aŋ idaisuda yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iŋ ru naon durupei, “Awo, maŋ idaisuda ya.” Agog Jesus irupidai, “Rumok, gab a lo ŋai ŋaluk amaiak lo aŋ aluk a, agod suguek a ŋai ituanag amaiak dam aŋ ituanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ak man aŋ ŋai siŋireg na amado wa, ta banig won ak lo dop, ta banig ŋas ak lo, aben uraru amaiak ŋaiseg mi ŋupanaŋ san ta idaisuda na ya. Tia, ŋaisag Tamag iŋsen mi tamol ta aben an ipidinai san niŋen o ipilianai la ya, amaiak niŋen o aben uraru an iŋsadi mi a.” ");
INSERT INTO tbc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Saen iŋanen megeloum 10 aenkadi mel an duloŋ man, Jems iŋ Jon da niŋedi wo tiŋaed saian a. ");
INSERT INTO tbc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ago tag Jesus megeloum igiaig iŋsan na dupalu ya. Dutumani dugo ibol, “Aŋ aloŋ ak gob adi luluŋad lo tamol a iŋsed gurman dubol dan, sad dabai tamolpein a paed na dumado dan dukubiai pidinai da. Ago dugo iŋ luluŋad lo tamol a yaŋad ad da yan diganep tamolpein kawan ak iŋaned tuod paen na dumado wa. ");
INSERT INTO tbc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ak gug aŋ luluŋam lo kagin ago yak ta ilasa na wa. Talpein ta aŋ luluŋam lo iŋ yaŋan tubun ak iŋane wo ilon ibol tap, sen iganep aŋanem biabi ŋilaŋal oŋ ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Agod talpein ta aŋ luluŋam lo iŋ imug yau wo ilon ibol tap, sen igane idup aŋ fidian aŋanem bigabeg urat igane panaŋ san ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nek dal kisaek an lo Tamol Nanun iŋsen mi, aenta iŋ o binawek urat dupani wo ta ipalu na ya, tia, aenta niŋedi wo binawek urat ipidinai o ipalu ya, agod dam sen ibiseip an lo tamolpein wei mi iŋal san niŋen o ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aria, Jesus iŋ megeloum adi dida tureŋ diabig Jeriko na dilasa. Saen iŋ tamolpein malan tubun ak dida taun an dibisei man, tamol ta yaŋan Bartimeus (an man Timeus san nanun) dal giraŋen na imasig moni dupani wo iwagiŋ se ya. Iŋ man tamol malan itau a. ");
INSERT INTO tbc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Saen iŋ Jesus Nasaret san tamol dal ante ipalu dan ago iloŋ man, awan tubun mi iwagiŋ go ibol, “Jesus, Dawid Nanun, ilo imuŋanag!” ");
INSERT INTO tbc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tamolpein wei mi dububuŋanig, dubol, “Awa itaup tokubol mado!” Ak man iŋ nen tubun mi isasai, “Dawid Nanun, ilo imuŋanag!” ");
INSERT INTO tbc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus yau oŋ dugo wagiŋ an iloŋ tag, itur dugo tamolpein dubuluwi an irupidai, “Aŋ awagi.” Ago tag iŋ tamol malan itau an duwagig dubol, “Ilo wabisap, masa, iŋ igio da.” ");
INSERT INTO tbc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Man niŋen o iŋ ririan san yamel madid san ak iragali ibal go imasag, Jesus san na ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus isumiani, “Oŋ ata mel ŋai oŋ o ŋigane wo ilo ibol di?” Agog mala itau tamol an ru naon irupei, “Tubun en, ŋai abaŋ ŋile wo ŋamat da.” ");
INSERT INTO tbc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Agog Jesus irupeig ibol, “Wau. Oŋane ilo rumok iginiog uya isusa ya.” Gamu nam malan uyan ilasag abaŋ ile kisaek oŋ a. Agog dal im Jesus ŋien aban irig yau a. ");
INSERT INTO tbc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesus iŋsan megeloum dida Jerusalem sumeik dupanig, Did Oliv siŋiren na panu uraru ta yaŋad Betfage iŋ Betani da dubol dan ate disusa ya. Ago man Jesus iŋanen megeloum uraru ta idinaig ");
INSERT INTO tbc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","irupidaig ibol, “Aŋ urarum panu o malad yaug tile dan ate au. Aup aladu dop doŋki foun ak ta dususeg imado dak ale wa. Doŋki an fufo talpein ta imasi man tia ya. Kam apasip aŋanep ŋaisag na apalu wa. ");
INSERT INTO tbc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tamol ta irupaiaŋ, ‘Aŋ ata wo ago agane dak i?’ ago ibol tap, aŋ igo arupei wa, ‘Doŋki en Tubun ak ibunawi san urat aman da ya. Milaen tiap iŋ ririan fon iganep imul ipalu wa.’” ");
INSERT INTO tbc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aria, megeloum uraru an diaug, doŋki foun ak ab san dalawan ate dususeg kuai te dal na itur dugo dile ya. Agog kam dusopasi a. ");
INSERT INTO tbc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ago dugo tamol aenta sumeik dutur an igo dusumianai, “Ata wo aŋ doŋki an kam apasi di?” ");
INSERT INTO tbc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Agog uraru an ru Jesus ibol ago mi durupidai a. Ago tag tamol an dilfu dugo doŋki diŋaneg dida diau a. ");
INSERT INTO tbc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Diaug, Jesus san na dilasag, iŋsad yamel milaen ak diragalig, doŋki patun fufo duruwari a. An itout go Jesus fufo imasig dida diau a. ");
INSERT INTO tbc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Agog tamolpein wei kasik iŋsiganed yamel milae milae yak diragali dugo dal te na duruwari se ya. Ago dugo aenkadi garaŋ lo ai raen dututeg dal te na bala didiri se ya. ");
INSERT INTO tbc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tamolpein aenkadi, Jesus dida imug mi diau dugo, tamolpein aenta murna dupalu se ya, iŋ fidian mi igo dubol duwagiŋ se na ya, “Hosana! Tamol e Tubun ak yaŋan lo ipalu den, Anut san bar iŋane ya! ");
INSERT INTO tbc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Maŋ tubuma bagema Dawid san kagin panek gamu ipalu dan, bar iŋane wa! Aben lak na geig an lo per dupano wa!” ");
INSERT INTO tbc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Agog Jesus Jerusalem na iladug yaug, tempel san sep lo iladu ya. Agog abaŋ ile itilanig mel ante dien dan fidian yil se ya. Gurai idu la yan niŋen o tempel lubanek ibiseig kuai te ilasag megeloum adi dida dumul go Betani na diau a. ");
INSERT INTO tbc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Dien go tidom lom saen Betani dibisei man, Jesus imatigen. ");
INSERT INTO tbc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Agog malan yaug, asau mi ai gurab ta ile ya. Gurab an roun mutunol tinan. Ago tag yaug sumeik go nuŋon abaŋ an ile, ak man nuŋon an tia, roun kawan mi a. Man dugo, nuŋon ifu san nal gamugo da. ");
INSERT INTO tbc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ago tag Jesus ai an ipeig ibol, “Talpein ta oŋ nuŋo fon ta yani na wa.” Jesus ago ibol dugo megeloum adi awan duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesus imul Jerusalem na yaug, tempel san sep ilon lo iladug, aben ante dadeŋ tamol adi, agod a melmel moni nam didad se yan dam fidian ikudaig kuai te dilasa ya. Iŋsad tebol fufo moni dubulsa se yan, iratitalaig yabibol idu dugo, tamol aenta muluk didad se yan sad kalik dam iratitale idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Agog tamolpein tempel san tom ilon lo melmel disini diau wo man niŋen o ipadau a. ");
INSERT INTO tbc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Agog ipiteŋanaig kududod yabig igo ibol, “Ru e Anut san buk lo digire man, ‘Ŋaisag ab en gudanek san ago dubol a, ante man tan fidian san tamolpein ka dugudani wa.’ Ak man aŋ agane ilasag ‘gumagam adi sad mianuk ab’ igo yen da.” ");
INSERT INTO tbc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pris gurman adi agod kubiaeŋ san girek maŋau adi ru an duloŋ a. Ago tag dal ta ate Jesus daoŋ dupani san niŋen o abaŋ diabi se ya. Iŋ itaot dufuni imat san tia ya, man dugo, iŋ niŋen o direr. Iŋ duloŋ ak tamolpein malan tubun iŋsan piteŋanek duloŋ dugo an niŋen o fidian durut saian a. ");
INSERT INTO tbc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aria, saen ad idu yau man Jesus iŋanen megeloum adi dida Jerusalem dibiseig diau a. ");
INSERT INTO tbc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Dien go tidom lom mi fon tureŋ diabi dugo ai gurab a nor Jesus ipei funi an dile ya. Ai an dabin ateg yaug ulun na man ibun idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ru a Jesus nor ibol an ilon isoug irupei, “Tubun en, ule. Ai gurab oŋ misilani an ibun idu ya!” ");
INSERT INTO tbc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus ru naon irupidaig igo ibol, “Aŋ Anut lo ilo rumok amam da amado wa. ");
INSERT INTO tbc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ŋai rumok ŋurupaiaŋ da, talpein ta iŋ ka did en igo irupei, ‘Oŋ masap, se ibulo beig lo waup udu.’ Ago dop ilon ta uraru na dop, ru a ibol an nuŋon ilasa wak ago ilon lo rumok nuŋon tap, ibol ago mi iŋsan na ka ago ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Amaiak niŋen o ŋai ŋurupaiaŋ da, oŋ gudanek lo mel ta wo Anut sumiani dop, iŋ mel an ipano la yak igo woŋ ago ilo lo rumok a. Ago gane tap, mel an oŋ da wa. ");
INSERT INTO tbc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Agod saen oŋ utur oŋ Anut gudani dan man, talpein ta ida ru ama da tap, malmalan ilo lo saian an sasi pani wa. Agop oŋane Tama kumaen panu lo yan iŋ dam oŋane saian an isasi pano wa.” ");
INSERT INTO tbc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Agog fon Jerusalem na dilasag, Jesus tempel san tom ilon lo yaug itor dugo, pris gurman, kubiaeŋ san girek maŋau adi, agod tamol tutubu yak adi iŋsan na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Agog dusumiani, “Oŋ kob en dabai da dugon te ŋaneg lo mel en gane dak i? Enti mok dabai en ipanog ate urat en gane wo ibol ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus awad yabig igo ibol, “Ŋai dam mel ta niŋen o aŋ ŋusumianaŋ o da. Ago dop aŋ imug ŋaisag sumianek an itaot arupaiag tap, enti mok iŋ urat e ŋigane den san dabai ipanag an ka ŋabol pe aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","En dugo ilom isou di? Jon san suguek man, kagin an dugon te iŋane yak i? An kumaen panu san mel, tia, an tamol sad mi ak i? Abol ŋaloŋ!” ");
INSERT INTO tbc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Agog iŋsed nugnug lo igo diŋiŋeŋ se ya. “En man kumaen panu san mel, ago tabol tap, iŋ igo ibol isumianad a, ‘En ata wo aŋ iŋ niŋen o ilom ta rumok na i?’ ");
INSERT INTO tbc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ak gug ‘En man tamol sad mel mi a,’ ago tabol tap, id o dugo ilasa wak i?” (Tamol tutubu emaiak tamolpein kawan ak niŋedi wo tarer na ya, ata wo, tamolpein kawan ak sad ilo sou lo man, Jon mi iŋ profet.) ");
INSERT INTO tbc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Man niŋen o iŋ igo dubol durupei, “Maŋ ta maloŋ na ya.” Ago tag Jesus ibol, “Ago yak niŋen o ŋai dam enti dabai en ipanag go ate urat e ŋigane den ta ŋurupaiaŋ na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kubiaek an itout gug, Jesus ru faŋan lo kubiaeŋ tamol adi naod na igo ibol ilasa, “Tamol ta iŋ ai wain san abi yabig ar ifou ya. Abi an ilon lo wain patun dupartitale dop dupipi san gib yabi a. Agod iŋ ab dam abi ilon lo yabi a. Agog iŋ tamol ta abi an kagin dupani san ipilianaig, abi an banid lo idiri a. Aria, saen abi taman iŋ urat an fidian igane itout man, imasag tan asau ak ate yau a. ");
INSERT INTO tbc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Saen ai wain nuŋon ifu san nal idu man, iŋ iŋanen biabi ŋilaŋal ta idinig iŋanen wain nuŋon aenta isini ipalu wo yau a. ");
INSERT INTO tbc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ak man urat tamol a abi lo dumado dan dumasag, tamol an diabig dufunig digane imul go banin kawan yau a. ");
INSERT INTO tbc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ago tag abi taman fon urat pinein sen ta idinig yau a. Ak man dumasag kabuŋan ate dufunig tinin malan dusue saian a. ");
INSERT INTO tbc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aria, urat pinein sen ta idinig yau a. Agog dufuni imat a. Nek ago mi, iŋ urat pinein aenkadi wei mi idinaig diau a. Gug abi kagin panek adi aenta dufu dugo aenkadi dufu dumat a. ");
INSERT INTO tbc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ago igane yaug tamol an talpein kisaek o lian idinip yau san imado. Agod talpein an iŋsiganen nanun mok niŋen o tubun mi imat da. Wadan lo nanun en idinig yau a, man dugo, abi taman ilo sou igane man, ‘Iŋ ŋaineg nanuk awan kagin dupani wa.’ ");
INSERT INTO tbc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ak man tamol abi lo urat digane dan, iŋsed nug lo igo dubol, ‘Tamol e ipalu yen man taman san melmel fidian mi iŋane wo da. Ago yak niŋen o id tufunip imat dop, iŋsan abi id tiŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ago dubol go dumasag diabig dufunig imat go tubabun dubal go ar patun fo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Aria, abi taman dugo igane wak i? Iŋ abi lo yaup abi kagin panek adi daoŋ ipidinaip abi an banid na ipasip urat tamol senamo yak banid lo igane wa. ");
INSERT INTO tbc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nag aŋ ru e girek lo yen den ta asuti na i? ‘Pat nek a ab bek tamol adi dumoi dan, nek amaiak ab tinin fidian yabi sakar da. ");
INSERT INTO tbc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anut sen ago igane ya, agod id malad lo en man siŋaokan geig a.’” ");
INSERT INTO tbc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Agog tamol tutubu yan an dal ta Jesus diabi san maeg diganeg abaŋ dile se ya. Man dugo, iŋ duloŋ ak Jesus iŋanen ru lo iŋ isiai se ya. Ak man ta dusubani na ya, ata wo, tamolpein malan tubun dutumani an niŋedi wo direr, ago yak niŋen o Jesus dibiseig diau a. ");
INSERT INTO tbc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Agog tamol tutubui adi iŋ Farisi aenta agod Herod san tamol aenta dam didinaig, Jesus san na diau a. Iŋ Jesus dibitinae dop siganen ru lo diabi wo ilod yen ak atem diau a. ");
INSERT INTO tbc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aria, iŋ Jesus san na dilasag durupei, “Girek maŋau, maŋ maloŋ ak oŋ ru rumok san tamol. Oŋ tamol senamo yak oŋ niŋe wo ilod isou dan niŋen o ta urer na da. Man dugo, gidad yaŋad amad da yak, tia yak dam, niŋedi wo oŋ ilo ta weiwei na da. Fun an lo oŋ tamolpein Anut san dal an niŋen o ru rumok nam itaot mi piteŋanai da. Id Kaisa takis moni tupani wan uyan ak i? Tia, saian ak i? Idsad kubiaeŋ mel en niŋen o dugo ibol dan ubol maloŋ. ");
INSERT INTO tbc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Id ka tadad ak i? Tia, tia yak i? Itaot rupaiama.” Ak man Jesus tamol adi an balek rararu san kagin lo dubol an iloŋ uyanan a. An niŋen o iŋ isumianaig ibol, “Aŋ ata wo bitinaek lo aginiag dak i? Aŋ moni ta asini apalup ŋile.” ");
INSERT INTO tbc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Agog moni ta disinig san na dupalug dupani a. Agog isumianai, “Mitilaen e fufo yaŋak digire yen enti san ak i?” Agog awan diabig dubol, “Kaisa san.” ");
INSERT INTO tbc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ago tag Jesus ibol irupidai, “An niŋen o aŋ mel ta Kaisa san tap, Kaisa apani wa, agod mel ta Anut san tap, Anut apani wa.” Ru an duloŋ go durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Agog Sadyusi adi mateŋ lo kumaen masa san tia ago ilod isou dan sumiaeŋ kisaek da Jesus san na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Girek maŋau, Moses gubak mi id o igo igire ya. Tamol ta iŋ nanuk aman tia yak imat go pein ak ibiseig imado tap, gidad tein imasap iwon ka iŋanep an lo tein imat la yan wagen lo nanuk idirai dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aria, gubak mi man tein muroun nuŋod 7 maŋ luluŋama lo dumado ya. Matu ak pein iŋaneg imado nag imat, ak gug iŋ nanuk aman tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ago yak niŋen o tein imasag matu imat an san pein iŋane ya. Tein bakan ak dam nanuk aman tia agog imat a, tein fon taidam iŋ dam nek ago mi, ");
INSERT INTO tbc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","nek ago mi yaug nuŋod 7 ante itout a. Tamol an fidian nanuk amad tia ya. Wadan lo man pein an dam imat a. ");
INSERT INTO tbc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Saen tamolpein dumat la yan fon kumaen dumasa tap, tamol an ilod lo pein an enti mok iwon ak i? Oŋ uloŋ ak iŋ fidian iwodi a.” ");
INSERT INTO tbc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Agog Jesus awad yabig ibol, “Aŋ afurfi saian geig a. Man ata wo? Anut san ru girek lo yen agod Anut san dabai dam aŋ ta aloŋ uyan na ya. ");
INSERT INTO tbc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Saen tamol dumat pe dumasap kumaen panu na diau dop, pein ta dusu na wa, agod ante tamol man pein ŋied ta dupani na da. Tia, iŋ kumaen panu san eŋel igo woŋ dumado wa. ");
INSERT INTO tbc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Agod taida mi, tamol dumat ak fon kumaen dumasa wan niŋen o aŋ kududom agure. Nag aŋ ru a Anut irupaiaŋ an ta asuti na yak i? Iŋ igo ibol, ‘Ŋai man Abraham san Anut, ŋai dam Aisak san Anut, agod ŋai dam Jakob san Anut.’ ");
INSERT INTO tbc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anut man iŋ tamol dumat ak sad Anut tia ya. Tia, iŋ man tamol kumaed dumado dak sadi a. Rumok nuŋon, aŋ afurfi saian geig a!” ");
INSERT INTO tbc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kubiaeŋ san girek maŋau ta ipalug Jesus Sadyusi dida ru lo nug diabi yau imul dugo iloŋ a. Ru naon siŋaokan Jesus irupidai an iloŋ tag, iŋ dam Jesus isumianig ibol, “Kubiaeŋ dugomaiak malan te yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus awan yabig igo ibol, “Kubiaeŋ malan te yak nek en: ‘O Isrel adi, kududom agure wa. Idsad Anut man Tubun en kisaek o lian a. ");
INSERT INTO tbc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tubun en oŋane Anut niŋen o umat a, oŋane bube fidian lo, oŋane ŋutu fidian lo, oŋane ilo sou fidian lo, agod oŋane dabai fidian lo ago gane wa.’ ");
INSERT INTO tbc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kubiaeŋ turan man igo ya. ‘Oŋ nek ibol oŋse niŋe wo umat dak ago mi tamolpein aenta dam niŋedi wo umat a.’ Kubiaeŋ ta iŋ kubiaeŋ uraru en iriŋanai man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Agog kubiaeŋ tamol an igo ibol, “Girek maŋau, oŋ ubol uyanan ak, Anut iŋ kisaek o lian, agod iŋ sen kisaek mi imado da, tubud taida man tia ya, ru an rumok nuŋon. ");
INSERT INTO tbc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Agod talpein ta iŋ buben fidian lo, iŋanen ilo sou fidian lo, iŋanen dabai fidian lo yak Anut niŋen o imat, agod iŋanen tamolpein aenta nek ibol iŋsen niŋen o imat dak oŋ, ago mi niŋedi wo imat a. Kagin naok ago yak, yai niganag mudan Anut ipani san fidian mi iriŋanai geig a.” ");
INSERT INTO tbc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Saen Jesus tamol an ru naon maŋau anda ipani an ile iloŋ man, iŋ tamol an irupei, “Oŋ Anut san kagin panek ate asau mi ta mado na da.” Ru an itout go Jesus san ager adi sumiaek taida dusumiani wo fidian direr a. ");
INSERT INTO tbc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus tempel san tumanek aben ilon lo tamolpein ipiteŋanai dugo sumianek ta ipidinai a. “En dugo woŋ go kubiaeŋ san girek maŋau adi, Kristus iŋ Dawid nanun an dubol na yak i? ");
INSERT INTO tbc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawid iŋsen mi, Awan Urgun iduduwi dugo igo ibol: ‘Tubun en ŋaisag Tubun ak igo irupei, “Oŋ ŋai tuog won ak ate masip mado, murna gup ŋai oŋsa ager adi ŋidiraip, oŋ ŋie pae na dumado dop ŋie nam partuanai a.” ’ ");
INSERT INTO tbc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Amaiak niŋen o Dawid iŋsen mi tamol an Tubun ak ibol tap, en dugo woŋ pe iŋ Dawid nanun ak i?” Tamolpein malan tubun ante dumado dan iŋsan ru duloŋ dugo ilod bulbal se ya. ");
INSERT INTO tbc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus piteŋanek ipidinai dugo irupidai, “Kubiaeŋ san girek maŋau adi niŋedi wo kagin agane wa. Iŋ kulos milae milae siŋaokan ak didirip diaup didaeŋ aben lo dutor dop aenkadi ilo uyan ru dupidinai o ago ilod yen da. ");
INSERT INTO tbc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Agod ubou ab lo kalik malan te tamol tutubu ate dumasi dan iŋ ate dumado da. Agod soubul lo dam nek ago mi digane dop, tamolpein iŋ kagin dupidinai o ago digane da. Iŋ se pitianoi kagin naok naok igo yan niŋen o tubun mi dumat da. ");
INSERT INTO tbc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iŋ pein suos sad ab digam da. Agod gudanek milae milae kasik digane da, ak man an sen kawan digane da, man dugo, tamolpein dil o ilod yen da. Tamol naok ago man Anut san bitinaek nal lo naon saian geig a diŋane wan tamolpein aenta sad naon iriŋani geig a.” ");
INSERT INTO tbc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Aria, tempel san tom ilon lo aben titin ta yen dugo ate moni san kunup yen a. Ate Jesus kunup an kitek siŋiren na imasig imado dugo tamolpein wei mi dupalu dop moni kunup lo dubal dugo yil se ya. A filiad amad da yan wei mi moni tubun mi dubal se ya. ");
INSERT INTO tbc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Agog pein suos filian aman tia yan iŋ dam ipalug pat bras uraru o lian an kunup lo ibal a. Naon man tusan a. ");
INSERT INTO tbc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus iŋanen megeloum igiaig san na dupalug irupidaig ibol, “Ŋai rumok ŋurupaiaŋ da. Moni e pein suos filian aman tia kunup lo ibal en, tamolpein fidian sad moni dubal an iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Man dugo, aenkadi iŋaned filiad tubun ak lo moni samun diŋaneg dubal a. Ak gug pein filian aman tia yan mel fidian lo katuk aman bo man, moni sapita iŋ da yan fidian mi ibal a. An lo sen aben ipitig itout a.” ");
INSERT INTO tbc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Saen Jesus tempel ibisei wo dugo megeloum ta igo ibol, “Girek maŋau, ule, tempel san pat tintinan nuŋon a, iŋsan naon man siŋaokan geig a!” ");
INSERT INTO tbc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ak man iŋ ru naon igo irupidai, “Aŋ ab tintinan en eil ak i? Ŋai ru rumok ŋurupaiaŋ da, ente man pat ta kisaek sen ta tinin fufo ta yen na wa. Tia, fidian mi tamol adi dugufututep diabibol tan na dudu wa.” ");
INSERT INTO tbc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus Did Oliv fo imasig imado se ya. Did a ate imado yan did tempel fufo itur dan san turan, titiŋaem tan ikilokan ak yen da. Agog Pita, Jems, Jon di Andru da ago mianuk lo san na dupalug dusumianig igo dubol. ");
INSERT INTO tbc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Oŋ rupaiama, saen dugomaiak lo melmel en dilasa wak i? Kob dugomaiak imug mi ilasa dop ate maŋ maloŋ ak, melmel en fidian dilasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Agog Jesus awa biek ru igo irupidai a. “Aŋ kagin agane wa, kabelan tamol ta aŋ irawaŋ banau. ");
INSERT INTO tbc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tamol wei mi dupalup ŋai yaŋag dupatep dubol a, ‘Ŋai nek emaiak Kristus.’ Ago dop tamolpein wei kasik dirawai a. ");
INSERT INTO tbc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aŋ yu ager aloŋ ak, agod san ru tim dam aloŋ a. Ago dop kagin agane wa, kabelan amasa saian banau, man dugo, mel en man ka ilasa wak, gug nal wadan san saen man gamugo da. ");
INSERT INTO tbc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tamol malan ta lo yu diabisap, tamol malan ta lo yu ager digane wa. Ago dop kiŋ ta iŋsan tamolpein dida yu diabisap, kiŋ sen ta iŋanen tamolpein dida nug dufuni wa. Agod aben sensen lo man kadag tubun mi idu dop kanaurig tubun ak gidigidad dilasa wa. Nek ibol pein nanuk igansi wo dop madai ile dak igo woŋ, melmel en fidian man, madai a nal wadan ilasa san amaiak ilasa wo fun igane da.” ");
INSERT INTO tbc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aŋ gidad tawaŋ aganep amado wa. Iŋ aŋ dibiaŋ pe aŋsiganem panu lo ager adi banid lo didiraŋ pe kot lo atur a. Juda adi sad ubou ab gidigidad dien dan lo aŋ tinimi dugufutute wa. Aŋ ŋai naog aŋanep kiŋ adi agod gabman gurman adi naod na atur a, an ŋai niŋeg o abol dop duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Agod ŋaineg bilaluŋ uyanan en imug tamolpein warou adi tan tilianek fidian lo dubol ilasa dop duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Saen iŋ aŋ dibiaŋ pe kot lo dida au dop, ru dugomaiak abol ak niŋen o ilom ta weiwei na wa. Tia, nek ru dugo Anut saen an lo ipano an mi arupidai a, man dugo, aŋsem ta abol na da, tia, Awan Urgun iŋ awam lo ibol ilasa da. ");
INSERT INTO tbc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Tein ta iŋ tein san ager adi banid lo iganep dufuni imat a. Taman ta dam nanun muroun sad ager banid lo idiraip daoŋ dupidinai a. Nanuk dumasap tinad tamad lo siai diganep ager banid lo didiraip dufu dumat a. ");
INSERT INTO tbc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tan en san tamolpein fidian aŋ lo siai digane wa, en ata wo, ŋai yaŋag man aŋsam na yen la ya. Ak man, talpein iŋanen ilo rumok yabi sakar yaup, saen iŋanen kumaen tan en lo itout ak ate dop, Anut talpein an patun ipasi wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Saen ilasa dop, mel ta tempel san aben gun ak lo dugunip, mel an ate itur san tia yak ate itur dop ale wa. Mel an gubak mi profet Daniel niŋen o ibol a. Mel an Anut malan lo man iganan geig a, nek mel amaiak igane dop daoŋ panek ilasa wa. (Oŋ ru e suti den uloŋ uyan o ta pasauman na yak man, maeg gane tap ka uloŋ ak boi.) Nal an lo dop, tamolpein a Judea na dumado dan, dusol diaup did luluŋad lo sed imianai a. ");
INSERT INTO tbc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Talpein ab fufo na imado dan, imul idup ab lo iŋanen biouŋ isini wo ta iladu na wa, tia, itaot mi isol yau a. ");
INSERT INTO tbc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Agod talpein abi lo imado dak dam, gidad imug mi yamel madid san ak iŋane wo ta imul yau na wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","O kabel, nal en san pein adi aŋ luam am da, agod aŋ pein aŋsam nanuk su apidinai dan dam, ŋai ilog tubun mi imuŋanaŋ da! Nal en man saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aŋ gidad agudani dop, mel en madid san saen lo ta ilasa na wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Man ata wo? Saen an lo dop muruan tubun geig ak ilasa wa. Muruan naok ago yak gubak mi ta ilasa na ya, saen tan en ilasag ipalug gamu en lo, mel igo yak ilasa man tia geig a, agod murnap fon ta ilasa da na wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Anut saen en itutep katukan a, iŋ ago ta igane na tap man, tamolpein fidian mi dideg diau a. Ak man, saen an lo dop Anut tamolpein a ipilianai la yan niŋedi wo ilon isou wa. Amaiak niŋen o iŋ saen an itutep katukan a. ");
INSERT INTO tbc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nal en lo talpein ta aŋ irupaiaŋ pe ibol, ‘Ale, Kristus ente imado da!’ tia, ‘Iŋ onte imado da!’ ago ibol dop, aŋ ilom ta rumok na wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Man dugo, kristus sewak ak iŋ profet sewak adi dida dilasa wa, ago dop iŋ kulob girager ak, agod mel naon senamo geig ak tamolpein malad lo dukubiaip dile wa. An lo dop idaisuda tap, iŋ tamolpein a Anut ipilianai la yan dirawaip lo diau dudu wo ago maeg digane wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amaiak niŋen o aŋ tawaŋ aganep amado wa. Mel en gamugo ilasa dugo ŋai imug mi mel emaiak niŋen o kuai tem ŋurupaiaŋ la ya.” ");
INSERT INTO tbc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Saen en san muruan tubun ak itout la gup, ‘ad ta ided uyan na wa, an lo dop adian tidom oŋ ilasa dop kalam ta ided na wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ante dop patui keit dibiseip dudu wa, agod Anut iŋ mel dababai keit lo yak imiriranai a.’” ");
INSERT INTO tbc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Saen an lo dop, tamolpein iŋ Tamol Nanun keit san timtaen fufo na itur dop dabai agod girager tubun geig aman da yak lo ipalu dak dile wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ago dop Tamol Nanun iŋanen eŋel adi idiraip dufufurak diau a. Ante dop iŋanen tamolpein kob ipidinai an dutumanai a. Iŋ tim sukurun iwoiwo an lo nap diŋal dupalu wa, ago mi yaup tan gigin itout ak ate wa.” ");
INSERT INTO tbc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Aŋ ai gurab lo ilo sou agane wa, iŋ maŋau ka ipanaŋ a. Saen iŋsan raen you aman da, agod roun foun ilasa dop, aŋ aloŋ ak madid itout go ad ilasa san saen sumeik ipani da. ");
INSERT INTO tbc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Amaiak niŋen o, aŋ murnap melmel fidian e dilasa den, ale dop, aŋ aloŋ ak Tamol Nanun iŋ ipalug sumeik, dalawan ante itur da. ");
INSERT INTO tbc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ŋai rumok ŋurupaiaŋ da. Warou gamu en san tamolpein gamugo itout yau dop melmel en fidian dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Keit iŋ tan da iŋ murnap itout a, ak gug ŋaisag ru man ta itout na wa.” ");
INSERT INTO tbc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ak gug talpein ta melmel an niŋedi wo nal dugo di auwa dugo dam dilasa san o ta iloŋ na ya. Kumaen panu san eŋel adi ta duloŋ na yak, agod Nanun sen dam ta iloŋ na ya. Bai iŋsen mi iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Amaiak niŋen o aŋ tawaŋ agane wa. Aŋ malam ipuk oŋ amado wa. Aŋ ta aloŋ na yak nal dugo lo aŋanem Tubun ak ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","En man igo ya. Tamol ta iŋ tan asau ak ate yau o dugo iŋanen urat biabi urat pinein banid lo iganep, anen anen iŋsiganed urat ipidinai a. Ago dop dalawan titianek tamol irupei, ‘Oŋ ŋai ŋamul ŋupalu san niŋen o tawaŋ ganep mado wa.’ ");
INSERT INTO tbc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Amaiak niŋen o aŋ tawaŋ aganep amado wa, man dugo, nal mok lo ab taman imul ipalu wak aŋ ta aloŋ na ya. Gurai lo boi, tidom tubun lo boi, kurek ibob san saen lo boi, tidom lom mi boi, aŋ aŋaoŋ da. ");
INSERT INTO tbc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Iŋ ririan imul ipalu dop, aŋ kabelan ŋioŋ abip amado dop iliaŋ banau. ");
INSERT INTO tbc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ru e ŋai ŋurupaiaŋ den, ru kisaek mi tamolpein fidian ŋurupidai da: ‘Tawaŋ aganep amado!’” ");
INSERT INTO tbc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tumanek tubun ak yaŋan Pasova dubol dan san saen idu san, nal uraru o lian yen da. An itout gup, tumanek aenta yaŋan Bret Yis Aman Tia ak San Soubul dubol dan ilasa wa. Pris gurman adi agod kubiaeŋ san girek maŋau adi iŋ dal ta pasak nam ate Jesus diabip dufuni imat san niŋen o abaŋ diabi se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Agog dubol, “Soubul nal tutubu e ilasa den lo ta tigane na wa, kabelan tamolpein dile dop dumasap ager diganep aben daoŋ dupani banau.” ");
INSERT INTO tbc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus iŋ Betani panu na imado dugo, tamol ta yaŋan Saimon tinin lepra aman da yak san ab lo ida dumado se ya. Iŋ tebol giraŋen na imasig imado dugo inuai se ya. Ago dugo pein ta iŋ gureŋ, pat butol alabasta nam digane yan siŋaokan ak, isinig san na ipalu ya. Butol an ilon lo gureŋ naon lak na geig ak, yaŋan nard dubol dan, awan isa. Aria, Jesus anaŋ yani dugo pein an ilasag, butol buron ibalsinig gureŋ an kabuŋan fufo na iwali idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Saen aenta ate dumado yan mel ago dile man, tiŋaed saian go nug lo dubol ila iso se, “En ata wo oŋ gureŋ kawan bidani dak i? ");
INSERT INTO tbc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gidad tubuseip, tamol didad pe moni tubun mi lo tiŋane wa. Tamol ta anaŋar kisaek urat igane dak san naon, moni nek ago yak ka tiŋane wa. Ago dop tamol filiad tia yak ka tupidinai a.” Agog ru dabai nam pein an dupei a. ");
INSERT INTO tbc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ak man Jesus ibol irupidai, “Aŋ pein en abisei! En ata wo muruan apani dak i? Iŋ man ŋai niŋeg o kulob siŋaokan geig ak igane ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Saen fidian tamolpein filiad tia yak dida amado da, agod aŋ ka aŋanem ilobol lo abinawai a, ak gug ŋai man saen milaen aŋ da ta tumado na wa. ");
INSERT INTO tbc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iŋ mel kabelan igane wo idaisuda yan ago igane ya. Iŋ ŋai tinig fufo gureŋ iwali an lo man, iŋ ŋaisag sisanug mutou lo digane wak san dal ikubune ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ŋai ru rumok ŋurupaiaŋ da. Tan dugon te bilaluŋ uyanan en dubol ilasa wan, ante dam kulob e pein emaiak igane yen niŋen o dubol ilasap, lo pein en niŋen o ilo sou digane wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Agog Jesus san megeloum 12 an ilon lo tamol kisaek, yaŋan Judas Iskeriot, imasag pris gurman adi sad na yaug, Jesus ager adi banid lo igane wo ilon ago ibol dan irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ru an duloŋ go ilod uyanan a, ago tag iŋ moni dupani wo ru dufuni a. Amaiak niŋen o nal an log ipalu, dal uyan ak ta ilep ate Jesus banid lo igane san niŋen o abaŋ yabi se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bret yis aman tia yak san soubul gun, iŋsan nal malmalan lo, megeloum adi Jesus san na dupalu ya. Nal an san saen lo man Isrel adi Pasova san sipsip nanun dufu dumat san a. Megeloum Jesus san na dilasag dusumianig dubol, “Oŋsa ilo lo, dugon te maup melmel mukubinep oŋ ate Pasova san anaŋ wani wo ubol dak i?” ");
INSERT INTO tbc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","An lo Jesus megeloum nuŋod uraru itarpasaig igo irupidai, “Aŋ aup taun tubun ak lo aladu wa. Ante man tamol ta you kapen anda isini ipalu dop iliaŋ a. Ago dop ŋien aban ari wa. ");
INSERT INTO tbc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ab dugon te iladu wan, aŋ dam ilon lo asudap, ab taman igo abol arupei, ‘Girek Maŋau igo isumiaeŋ a, galuŋ dugomaiak lo, ate ŋaineg megeloum dida Pasova anaŋ mani wak i?’ ");
INSERT INTO tbc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Agop galuŋ tubun a ab fufo yen dan, agod ilon lo mel fidian dukubune lag idaisuda yen dan ikubiai panaŋ a. Ante idsad anaŋ akubune wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Megeloum uraru an dal diabig taun tubun ak lo diau a. Ante mel fidian Jesus ibol ago mi dile ya, agog Pasova san anaŋ dukubune ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gurai idu dugo Jesus iŋanen megeloum 12 dida dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Saen iŋ sisem tebol giraŋen na dumasig anaŋ diani dugo, Jesus igo ibol, “Ŋai rumok ŋurupaiaŋ da, tamol ta ete ŋai da anaŋ tani tumado den, iŋ ŋai ager adi banid lo iginiag ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ru an duloŋ go ilod muruan idu ya. Agog iŋsed kisaek kisaek Jesus dusumianig dubol se, “Dugo ŋai tia i?” Ago ago dubol yau se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus ru naon ibol, “Tamol en man megeloum 12 luluŋam lo imado da. Tamol nek a bret iŋanep daeg san tuor lo ŋai da sisem banima idu dan, nek amaiak ŋai ibilag pe ager banid lo ŋau a. ");
INSERT INTO tbc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tamol Nanun iŋ nek ibol ru buk lo iŋ niŋen o digire an, nek ago mi yau da. Ak gug tamol enti a Tamol Nanun iganep iŋanen ager adi sad tuod lo yau an, rumok iŋ muruan tubun kasik ak ile wa! An lo gidad tamol an san tinan ta igansi na tap, an iŋ o uyanan mok a.” ");
INSERT INTO tbc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aria, iŋ anaŋ diani dugo Jesus bret iŋaneg, Anut ilo uyan ru ipanig yafuteg, iŋanen megeloum ipidinai dugo ibol, “Aŋ aŋane, en man ŋaisag tinig.” ");
INSERT INTO tbc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Agog wain gab iŋaneg, Anut ilo uyan ipanig, iwae pidinaig, iŋ fidian lo duluk a. ");
INSERT INTO tbc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Agog iŋ irupidaig ibol, “En man kontrak san dar, tamolpein wei mi sad aupasek isuas o ŋuwali idu wa. ");
INSERT INTO tbc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ŋai rumok ŋurupaiaŋ da, ŋai fon ai wain san nuŋon lo ta ŋaluk na wa, ago yaup nal amaiak ante ŋai fon aŋ da Anut san kagin panek aben lo taluk la gup ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Agog iŋ Isrel san bar ta diabig itout go galuŋ an dibiseig Did Oliv fo na disuda diau a. ");
INSERT INTO tbc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Diau dugo Jesus iŋanen megeloum adi ru igo irupidai, “Gamu tidom nek en lo, aŋ fidian mi ŋai niŋeg o ilom idu yaup abisawag a. Man dugo, Anut san girek lo ru igo ibol, ‘Ŋai titianek tamol ŋufuni wa, agop iŋsan sipsip adi dusol gidigidad diau a.’ ");
INSERT INTO tbc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ak man Anut ŋai ibiagsap fon ŋumasa la gup, ŋai aŋ naom na imug mi Galili na ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita irupeig ibol, “Tamol fidian iŋ bo oŋ niŋe wo ilod idup dubusawo wak gug, ŋai man tia wa!” ");
INSERT INTO tbc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus awan yabig ibol, “Ŋai rumok ŋurupaio da, gamu tidom nek en lo kurek saen uraru gamugo ibob dop, nal utol oŋ ŋai utot a.” ");
INSERT INTO tbc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ak man Pita ru dabai ak nam irupei, “Gidad, ŋai oŋ da tamat bo man, ŋai oŋ niŋe wo ta ŋatot na wa, tia geig a!” Ago dugo megeloum fidian mi nek ago mi dubol se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ago man Jesus iŋ dida, aben ta yaŋan Getsemani dubol dan ate diau a. Ante iŋ megeloum adi irupidai, “Aŋ ente amasip amado dop, ŋai titin onte ŋaup gudanek ŋigane wo da.” ");
INSERT INTO tbc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Agog iŋ Pita, Jems agod Jon dida iŋal go diau a. Saen an lo iŋ fun iganeg ilon ipapao dugo ilon dam muruan idu se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","An lo igo irupidai, “Ŋai ilog tubun mi muruan dugo ŋamat o sumeik da. Aŋ gidad ete ŋai da malad ipuk pe tumado wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ago dugo iŋ ipar kitek ilag, sen ibilig tan fo idug yen dugo Anut igudani man, isop Anut ilon tap, nal en san muruan ka ipasi pani wa. ");
INSERT INTO tbc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iŋ igo ibol, “Bai, ŋai Tamag, oŋ mel fidian ka gane wo idaisuda ya. Oŋ gab en ŋai banig lo ka pasi wa. Ak gug oŋ ŋaisag ilog ta uri na wa, tia, oŋ man oŋsina ilo mi uri wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Agog iŋ iŋanen megeloum adi sad na ipalug, malan yaug dien dugo yil a. An lo iŋ Pita irupeig isumiani, “Saimon, en dugo, oŋ ŋioŋ wabi di? Oŋ auwa kisaek ŋai da malad ipuk pe tumado san ta idaisuda na yak i? ");
INSERT INTO tbc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oŋ mala ipuk dop mosiai a, man dugo, kabelan mel ta ikubiano san ipalup ilio banau. Rumok, ilo ibol dak gug tini dabai ama tia ya.” ");
INSERT INTO tbc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iŋ saen uraru imul yaug ago mi imosiai a. ");
INSERT INTO tbc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Saen imul ipalu man ŋioŋ diabi dugo yil da ya, man dugo, malad muruan geig a. Iŋ ata ru durupei san ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Saen utol imosiai itout gug, megeloum adi fon sad na ipalug igo irupidai, “Aŋ ŋioŋ abi dugo yaes abal yau dak i? An nek a! Ale, ŋaisag saen idu wo da, Tamol Nanun aupasek tamol adi tuod lo digane san saen idu la ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amasap, tau o da. Ale, tamol enti a ŋai ager tuod lo isodudunag san man sumeik ipanad la ya!” ");
INSERT INTO tbc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus iŋiŋeŋ go imado dugo Judas ipalu ya. Iŋ megeloum nuŋod 12 ak luluŋad lo mi aben aman da ya. Iŋ ipalu dugo ida tumanek malan tubun ak iŋ sabiri agod tok dam duburoug naon na dilasa ya. Pris tutubu yak, kubiaeŋ san girek maŋau adi, agod Isrel adi sad tamol gurman didinaig dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Imug mi palaŋ niganag tamol a iŋ tuod lo igane san man, kob ta dam niŋen o igo irupidai, “Tamol a ŋai musuk ŋupani dop ale wan, nek an Jesus, aŋ tamol amaiak abip yu tamol adi dulubanip diŋanep dida diau a.” ");
INSERT INTO tbc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aria, iŋ Jesus san na ipalu kisaek oŋ go ibol, “O girek maŋau” Ago ibol go musuk ipani a. ");
INSERT INTO tbc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Agog iŋ Jesus duparsikawig diabig dusubani a. ");
INSERT INTO tbc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","An lo man tamol ta iŋ Jesus siŋiren na itur an, sinan sabiri igursi go pris gurman san urat pinein ifunig, kududon ituteg idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus iŋanen ager adi irupidaig ibol, “En ata wo aŋ sabiri iŋ ai tok da asinig aliag pe abiag o apalu yak i? Ak dugo, ŋai man wagai adi gabman mabi idu san gurman igo woŋ ago ilom isou di? Nal fidian ŋai tempel aben lo ŋumasi dugo ŋupiteŋanai se ya, ak gug aŋ ŋai ta abiag na ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ak man melmel en fidian ilasa san fun man, ru gubak mi Anut san buk lo digire yan gamu en nuŋon ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Agog megeloum adi fidian mi Jesus dubuseig dusol go diau a. ");
INSERT INTO tbc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pinein ta, tinin yamel ta itabug oŋ, Jesus ŋien aban iri se ya. Saen Jesus san ager adi pinein en dile man, diabi wo duparsikawi a. Iŋsan yamel diabi a, gug iŋ yamel iragalig, banid lo ikisaluk ilasag, ");
INSERT INTO tbc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yamel banid lo ibiseig taen kawan isol go yau a. ");
INSERT INTO tbc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tamol adi Jesus diabi an, diŋaneg pris gurman san ab lo diau a. Ante man kubiaeŋ san girek maŋau adi, pris tutubui adi agod Isrel san gurman adi dutumani lag malan digane se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ak man Pita iŋ Jesus ŋien aban irig diau ak gug, iŋ kitek asau mi imado ya. Iŋ pris gurman san ar lo iladug ai katuk adi dida dumado ya. Tidom an madid niŋen o yai lo tinid isue dugo dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pris tutubui adi, agod kaunsil fidian mi, tamol aenta digiaig sewak ru dubol dop, Jesus kagin saiak ta igane yak tap, ate dufunip imat san dal ta dile wo dukubiai na ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ak man tamol wei mi sewak ru amad da yan naod na dilasa bo man, dal ta dile man tia ya, man dugo, ru ta naon kisaek dubol ilasa man tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Agog tamol aenta dutur man Jesus tinin lo dusupaleg igo dubol, ");
INSERT INTO tbc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Maŋ ru igo ibol dugo maloŋ a. ‘Ŋai tempel e tamol banid nam dususe yen ŋurubep, nal utol lo mi foun ak ŋabisa wa, an man tamol banid nam ta dususe na ya.’” ");
INSERT INTO tbc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gug dal sensen lo dam ru an dubol se ya, ru naon kisaek tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ago dugo pris gurman iŋ naod na itur dugo igo ibol Jesus isumiani, “Oŋ ru naon ta ubol san tia yak i? Ru e oŋ niŋe wo tamol emaiak dubol den dugo yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ak man Jesus ru ta ibol man tia ya, itokubol itur se ya. Agog pris gurman fon Jesus isumiani, “Dugo, oŋ Kristus, Anut Nanun i?” ");
INSERT INTO tbc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ago man Jesus igo ibol irupei, “Awo, ŋai mi Kristus. Aŋ murna gup Tamol Nanun iŋ Dabai Tubun Geig ak san banin won ak ate imasi dop ale wa. Agod Tamol Nanun keit san timtaen fufo na imado dop ipalu wa, mel amaiak dam ale wa.” ");
INSERT INTO tbc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Agog pris gurman, ru an niŋen o imasa saian go iŋanen kulos irasireg igo ibol, “Gidad, tamol taidam, tamol en san kagin niŋen o dubol ilasa san id ta tigiai na wa. ");
INSERT INTO tbc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Man dugo, gamu geig iŋanen ru lo Anut yaŋan irube idu yan aŋsem aloŋ a. Aŋsam ilo sou lo, dugo woŋ id tamol en niŋen o tigane wak i?” Iŋ fidian dubol ak, tamol en mel saian geig ak igane, an niŋen o ka imat oŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ago man iŋ Jesus naon fo na dulusu se ya. Aenta Jesus yamel nam malan dufoug banid nam dufuni dugo naon dugufute oŋ dugo igo dubol se, “Profet ru ubol ilasa!” Ago dugo yu tamol adi tinin dusue ditare se ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aria, Pita iŋ ab patun fo ar ilon lo imado dugo, pris gurman san urat pein ta siŋiren na ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Saen Pita yai giraŋen na tinin isue dugo ile man, malan ti ibol go irupei, “Oŋ dam Nasaret tamol amaiak ida amado na ya.” ");
INSERT INTO tbc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ago dugo Pita ru a pein ibol an niŋen o itot go igo ibol, “Ru oŋ ubol dan ŋai ta ŋaloŋ na ya, ŋai mel en niŋen o ŋiŋaoŋ geig a.” Ago ibol go yaug ar san dalawan te imado. ");
INSERT INTO tbc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Murna gug dalawan te imado dugo, urat pein an fon ileg niŋen o tamolpein sumeik dumado yan fidian irupidai, “Tamol en iŋ luluŋad lo imado se ya.” ");
INSERT INTO tbc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita fon itot a. Saen kitekan go tamol adi sumeik dutur an Pita durupeig dubol, “Rumok geig, oŋ iŋ luluŋad lo mado da, man ata wo, oŋ Galili tamol.” ");
INSERT INTO tbc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Agog Pita iŋ Anut misilanek ru ka ipani wan niŋen o ru naok ago yan lo, fun iganeg sen imisilanig igo ibol, “Ŋai tamol en niŋen o abol den ta ŋaloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iŋ ru ibol itout dugo, kurek saen uraru ibob kisaek oŋ a. Ago dugo Pita iŋ Jesus ru ibol an ilon isou a, “Kurek gamugo saen uraru ibob dop, saen utol ŋai ta uloŋ na yak ubol a.” Ago man iŋ ilon ipapaog tinaŋ tubun mi igane se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Salso idu dugo pris tutubui adi, Isrel tamolpein sad gurman adi, kubiaeŋ san girek maŋau adi, agod iŋaned Sanhedrin kaunsil fidian mi mel dugomaiak digane wo awad kisaek a. Agog Jesus banin dusubanig, diŋaneg, diaug Pailat banin lo digane ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat Jesus isumiani, “Oŋ Juda sad kiŋ ak i?” Jesus ru naon irupei, “Awo, oŋse nek ubol a.” ");
INSERT INTO tbc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Agog pris gurman adi ru wei kasik Jesus tinin dusupaleg dubol se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Amaiak niŋen o Pailat irupeig isumiani, “Uloŋ, iŋ ru sapita wei mi dupano da. Ak dugo, oŋ ru naon ta ubol san tia yak i?” ");
INSERT INTO tbc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ak man Jesus ru naon ta Pailat irupei man tia ya, an niŋen o Pailat ilo sou wei mi igane se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aria, anaŋar fidian, tumanek gun an san saen lo mi, iŋaned tamol kagin igo ya. Gabman san tamol malan te yak, subanek tamol kisaek o lian amaiak tamolpein yaŋan dupate dop, ipasip kawan imado wa. ");
INSERT INTO tbc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Saen an lo man tamol ta yaŋan Barabas iŋ wagai tamol aenta dida subanek lo dumado ya. Wagai tamol emaiak Rom gabman malan dusue wo dumasag ager diganeg tamol aenta dufu dumat a. ");
INSERT INTO tbc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aria, tamolpein dutumanig dutur den Pailat san na duparsikawig dusumiani man, kagin a gubak mi iri na yan gamu en dam iri wa. ");
INSERT INTO tbc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Agog Pailat doup tubun adi isumianaig ibol, “Aŋ ilom dugo ibol di? Juda sad kiŋ ŋubuseip aŋsam na imul o?” ");
INSERT INTO tbc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iŋ iloŋ uyan ak man, tamol adi an iŋ turak susai lo mi Jesus diŋaneg kot lo dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ak gug pris tutubui adi tamolpein dududuwai dugo ilod diabisa dop, iŋ Pailat duwagiŋ pe Barabas ipasi wo dubol a. ");
INSERT INTO tbc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Agog Pailat ibol isumianai, “Ago yak niŋen o aŋsam ilo sou lo, Jesus e aŋ Kristus abol den niŋen o ŋai dugo ŋigane wak i?” ");
INSERT INTO tbc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Agog iŋ disasai, “Aigim fo bali wa!” ");
INSERT INTO tbc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat isumianai da, “An ata mel o? Iŋ ata mel saian ak igane yak i?” Ak man iŋ awad tubun mi geig disasai, “Aigim fo bali wa!” ");
INSERT INTO tbc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Man niŋen o Pailat doup tubun an ilo uyan ipidinai o ilon ago ibol ak niŋen o, iŋ Barabas iŋsad na ipasi a. Agog ru iganeg Jesus diabig rasau nam dufuni a. Dufunig itout go iŋanen yu tamol adi banid lo aigim fo dibali wo igane ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Agog gabman malan te yan san yu tamol adi, Jesus diŋaneg gabman san ab lo diau a. Ante man iŋ Pailat san yu sawar fidian mi dupalu wo digiai a. Dupalug Jesus san na dutumanig dubuluwi a. ");
INSERT INTO tbc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iŋ yamel daran ak ta tinin fo na ditabug pani a. Ago dugo iŋ kam dudurun aman da yak, kiŋ san kitikat igo woŋ ditiladeg, Jesus kabuŋan fo na disisi idu ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Agog iŋ kukok aman digane dugo igo dubol, “Per o, Juda sad Kiŋ!” ");
INSERT INTO tbc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Agog tinin fo dulusu se ya, ago dugo makud diŋaneg ate kabuŋan te dufuni idu se ya. Ago dugo naon na turud disoluwig, yaŋan diabisa dugo kukok aman digane se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Saen kukok aman digane itout man, yamel dupasig tinin fo iŋsiganen kulos digane pani a. Agog aigim fo dibali wo diŋaneg diau a. ");
INSERT INTO tbc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesus diŋaneg tureŋ diabig diau dugo, yu tamol adi dal na taun Sairini san tamol, yaŋan Saimon, dile ya. Iŋ man Aleksanda iŋ Rufus da sad tamad, abaŋ lubanek ibiseig dal Jerusalem na yau ante Jesus iriŋani wo itor dugo, yu tamol adi dile ya. Iŋ disodudunig Jesus san aigim isini a. ");
INSERT INTO tbc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iŋ diaug aben ta lo dilasa, yaŋan Golgota. Yaŋak an fun igo ya, “Kabuŋak tatu san aben.” ");
INSERT INTO tbc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aben ante dilasag, marasin yaŋan mirr dubol dan wain da dukubulig Jesus iluk o dupani a, ak gug iŋ ta iluk na ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Agog iŋ Jesus aigim fo dibali a. Iŋ dibali itout go iŋsed nug ilon lo iŋsan kulos dibititip anen anen kulos diŋane wo ate satu dukok se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ad mitilaen 9 kilok, saen an lo Jesus aigim fo dibali a. ");
INSERT INTO tbc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ru ate kot dupani an, aigim fufo na dubali a. Ru en san sutek man, En Juda sad Kiŋ. ");
INSERT INTO tbc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Agog Jesus giraŋen na man, gumagam tamol wagai amad da yak nuŋod uraru iŋ dam aigim fo dubalaig dusuŋanai a. Iŋsad aigim man turan tuon won ak ate dugo, turan tuon ŋas ak ate duguni a. ");
INSERT INTO tbc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iŋanen ager adi diau dumul dugo nao futek ru wei mi tinin fo dubal dugo, kabuŋad dukupari pani na ya. Iŋ dubol a, “Oŋ man tamol amaiak tempel ratitale idup, fon ad utol lo wabisa wo ubol a! ");
INSERT INTO tbc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aria, se patu ipaso wa, gamu en aigim biseip tan na udu wa!” ");
INSERT INTO tbc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nek ago mi pris tutubui adi, kubiaeŋ san girek maŋau adi dam, sed luluŋad lo kukok an digane se ya. Iŋ dubol se, “Iŋ tamol aenta patud ipasi na yak gug, sen patun ipasi san man tia ya! ");
INSERT INTO tbc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","En man Kristus, Isrel sad Kiŋ. An niŋen o iŋ aigim ibiseip idu dop, an lo id tile dop ka ilod lo rumok a.” Dal kisaek mi lo tamol uraru a Jesus dida aigim fo dusuŋanai an dam nao futek ru wei mi tinin fo dukulmaek se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ad mitilaen 12 kilok an lo, tidom tubun tan yafutani geig go yaug 3 kilok gurai isi a. ");
INSERT INTO tbc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saen kitek 3 kilok sumeik ipani dugo, Jesus awan tubun mi iwagiŋ dugo ibol, “Eli, Eli, lama sabaktani?” Ru en fun igo ya, “Ŋaisag Anut, ŋaisag Anut, en ata wo ŋai bisawag ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tamol aenta sumeikan dutur dan, ru en duloŋ go ago dubol, “Aloŋ, tamol en man Elaija iwagi da.” ");
INSERT INTO tbc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ago dugo yu tamol ta iŋ imaspalu yau silatik oŋ go, mel ta beig san titaliŋ igo woŋ ak iŋaneg, wain gigen an lo isominig, dumadum ate ifoug, Jesus awan te isou isudag iluk o iwate ya. Agog iŋ ibol, “Amoi dop id tile gup, nap Elaija ipalup aigim lo ipasip idu wo ipalu wak boi, nap tia boi.” ");
INSERT INTO tbc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Agog Jesus awan tubun mi iwagiŋ go yaes ibal itout go imat a. ");
INSERT INTO tbc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Saen nek amaiak lo mi, yamel tubun ak tempel lo iyuk yen an, o lak na fun iganeg imasireg yaug tan na idu ya, agog uraru dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Saen yu tamol sad gurman Jesus naon na itur an, Jesus wagiŋ dugo iloŋ, agod dal dugomaiak lo imat man, iŋ ibol, “Rumok geig, en man Anut Nanun!” ");
INSERT INTO tbc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pein adi aenta ate dumado se yan, asau mi dutur dugo leil digane ya. Luluŋad lo pein kisaek ta man taun Magdala san Maria, agod ta man Maria, Jems a bakan ak dubol dan iŋ Joses da tinadi, agod Salome. ");
INSERT INTO tbc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pein adi an saen Jesus Galili ilon lo tureŋ yabi dugo dubunawi wo ŋien aban diri na ya. Pein aenta wei mi dam iŋ Jesus dida Jerusalem na dupalu yan luad disa dugo leil digane se ya. ");
INSERT INTO tbc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nal amaiak man yaŋan Kubunek Nal dubol da. (Nal tinin te ubou san nal.) Amaiak niŋen o saen gurai idu dugo, ");
INSERT INTO tbc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josef Arimatea san tamol, iŋ man Juda sad Sanhedrin kaunsil luluŋad lo tamol kisaek a, agod iŋ dam Anut san kagin panek ilasa wo malan igane se ya. Iŋsen ilon yabisag Pailat san na yaug Jesus san tubabun ipani wo isumiani a. ");
INSERT INTO tbc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Saen Pailat Jesus imat la yan iloŋ man, irut saian. Yu tamol sad gurman ipalu wo iwagi a. Iŋ ilasa dugo Pailat isumiani, “Dugo, Jesus imat la yak i? Tia, gamugo di?” ");
INSERT INTO tbc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yu tamol gurman an Jesus imat la yan irupei a. Ago yak niŋen o Pailat Josef Jesus san tubabun ipani a. ");
INSERT INTO tbc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josef yaug yamel ikokan foun geig ak idad a, agog yaug Jesus san sisanun aigim fo ipasig, yamel an ate ibuluwig, isinig yau a. Agog mutou foun ak lo igane ya. Mutou an man pat san gib, gubak mi pat lo diabi a. Aria, Jesus san sisanun pat gib an ilon lo yen dugo, Josef pat muruan tinan ak ta ibili ipalug mutou awan ate ibalfutani a. ");
INSERT INTO tbc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ago dugo Maria, Magdala pein, agod Maria ta Joses tinan, nuŋod urarum Jesus dugon te digansig yen den leil dupani a. ");
INSERT INTO tbc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Aria, ubou nal Sabat dubol dan itout go nal murna, ubou turan san nal malmalan ak, san salso sumeik idu se ya. Saen an lo taun Magdala san Maria, Maria ta iŋ Jems tinan, agod Salome, iŋ marasin uyan ak ate sisanun tinid dububuni wan diŋane diaug ate Jesus san sisanun dububuni wo mutou fun na diau a. ");
INSERT INTO tbc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tureŋ diabi dugo iŋ nug dusumiani, “Enti mok pat tubun a mutou awan te yan ibilip yau panad ak i?” ");
INSERT INTO tbc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mutou fun na dilasag malad diabisa man, pat tubun an dubulig yaug, gigin na yen dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Saen pat gubaran ilon lo diladu man, malad yaug pinein ta yamel milkouk di milaen ak igane yan dile ya. Iŋ pat gubaran titin won ak lo imasig imado se ya. Dile man durut go direr saian geig a. ");
INSERT INTO tbc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Agog iŋ irupidai, “Aŋ arut arer amoi. Aŋ Jesus Nasaret san tamol aigim fo dibali amaiak abaŋan abi da. Iŋ kumaen imasa ya! Iŋ ete man tia ya. Apalup, aben e diganeg yen en ale. ");
INSERT INTO tbc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ago yak niŋen o amul aup, iŋanen megeloum adi, Pita dida, bilaluŋ en arupidai a, ‘Iŋ imug mi Galili na yau dop aŋ apalu wa. Onte gup ale wa, nek ibol iŋsen gubak mi irupidai ak ago ya.’” ");
INSERT INTO tbc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Agog pein utol an dusuruwor dugo ilod ibarkikaruk saian geig a. An niŋen o pat gubaran dibiseig kuai te dilasag dusol go diau a. Iŋ ru ta tamolpein aenta lo mel an niŋen o ta dubol ilasa na ya, man dugo, iŋ direr geig a. ");
INSERT INTO tbc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aria, Jesus imasa yak san nal man, ubou turan san nal malmalan ama ya. Saen an lo iŋ imug mi Magdala san pein Maria, naon na kuai isi dugo ile ya. Wagam mi Jesus ur sisaiak 7 pein an tinin lo ikudaig diau ak ama ya. ");
INSERT INTO tbc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pein an yaug, tamolpein a gubak mi Jesus dida tureŋ diabi na yan, ilod ipapao dugo ditata oŋ se yan iŋsad na ilasag mel dugo ilasa yan niŋen o irupidai a. ");
INSERT INTO tbc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ak gug saen Jesus kumaen imado dugo Maria ile man, ru ibol an niŋen o ilod rumok man tia ya. ");
INSERT INTO tbc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Murnag tamol uraru gubak mi Jesus ŋien aban diri na yan, Jerusalem lubanek ilon lo tureŋ diabi se ya. Dal im diau dugo, Jesus naod na ilasa man naon tinin sen geig, agog dida diau se ya. ");
INSERT INTO tbc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tamol uraru emaiak dumul diaug aenta durupidai a, ak gug iŋ tamol uraru an dam ilod lo ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Murna gug saen megeloum 11 anaŋ dunuai man, Jesus kuai isi dugo dile ya. Jesus ipidai a, man dugo, iŋ ilo rumok amad tia ya, agod ilod dabai geig ak oŋ iŋ tamolpein a Jesus kumaen imasa gug dile yan, iŋsad ru ilod lo rumok an niŋen o dumoi a. ");
INSERT INTO tbc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesus irupidai, “Aŋ amasap, tan fidian lo ator dop, tamolpein fidian mi ante dumado dan bilaluŋ uyanan en afulalep duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ensauta a ilod lo rumok pe suguek diŋane dan patu pasek diŋane wa. Ak gug ensauta a ilod ta rumok na yan kot lo diau dudup dideg diau a. ");
INSERT INTO tbc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Agod kulob naok igo yan man, tamolpein a ŋai o ilod rumok dan dida diau a. Iŋ ŋai yaŋag lo ur sisaiak adi dukudaip diau ak, iŋ muroun ru sensen ak diŋanep ate diŋiŋeŋ a. ");
INSERT INTO tbc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Iŋsed banid nam mot wagai ak duburou a. Iŋ marasin saiak ta tamol ifuni imat san ka duluk a, gug ta dumat na wa. Agod iŋaned banid subam adi tinid fo diganep uyadi da wa.” ");
INSERT INTO tbc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tubun ak Jesus ru an fidian irupidai itout man, Anut iŋ iŋaneg isuda yaug kumaen panu na ilasa ya. Ante man iŋ Anut san aben malan te banin won ak lo imasig imado da. ");
INSERT INTO tbc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Agog iŋanen megeloum adi dufurak go, gidigidad diaug iŋanen ru dubol ilasa na ya. Agod Tubun en iŋsen iŋ dida urat digane se ya, ago dugo kulob funfun kob aman da idiri dilasa yan lo tamolpein dile man, iŋanen ru man ru rumok a. ");
INSERT INTO tbc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O tamol tubun en Tiofilas, tamol wei mi melmel a maŋ luluŋama lo nuŋon dilasa yan niŋedi wo digire la ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Melmel nek an, tamolpein a sed malad lo dil an durupaiamag maloŋ a. Tamolpein en gubak mi ru en kagin dupani uyan se ya, agod ru dugo durupaiama na yan, ru nek an mi migire idu ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ŋaiseg mi melmel an fidian, fun lo dilasag ipalu yan ŋupupi ŋile ya. An niŋen o ŋaisag ilo sou lo mel en uyanan a, ŋai gamu mel en fidian tet mi ka ŋigire pano wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","An lo dop melmel a dipiteŋano yan sad fudi mok oŋ uloŋ siŋaokan a, agod mel amaiak fidian rumok an dam uloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saen Herod iŋ Judea provins sad kiŋ imado dugo, pris ta dam imado se ya, yaŋan Sakaraia. Iŋ pris biatitek luluŋad lo a yaŋan Abaija dubol dan san tamol ta. Iŋ Aron san gugoi lo ilasa ya, iwon Elisabet dam iŋ Aron san dar lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tamol an iwon da Anut malan lo itaot a, ago dugo iŋ Tubun ak san kubiaeŋ agod ru kagin an fidian duri dupani se ya, agod talpein ta iŋaned kagin an niŋen o ru ta ibol san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ak man iŋ nanuk amad tia ya. Man dugo, Elisabet iŋ pein niganig, taida mi, uraru an mel saiak digane la ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Biatitek a lo, saen tamol dumado se yan tempel lo urat disini dugo, Sakaraia dida urat digane se ya. Nal ta lo iŋ Anut naon na pris urat igane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aria, pris sad kagin lo, iŋanen urat kisaek adi dipiliani a. An lo iŋ Anut san tempel lo iladup, ante alta san yai fo yaikas mumalum iwen siŋaokan dan igane wo, kob dupani a. ");
INSERT INTO tbc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aria, yaikas an igane san saen ilasa dugo, tempel lo iladug ago igane se ya, ago dugo tempel patun fo tamolpein a ubou dile wo dutumani an gadiŋ digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Saen nek an lo Tubun en san eŋel Sakaraia naon na ilasag, yaikas mumalun iwen dak san alta giraŋen won ak lo itur a. ");
INSERT INTO tbc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Saen Sakaraia eŋel an ile man, irut saian geig go irer a. ");
INSERT INTO tbc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ak man eŋel an irupeig ibol, “Sakaraia, oŋ urer umoi. Anut oŋsa gudanek iloŋ la ya. Oŋ iwo Elisabet nanuk tamol ak ta igansi wa, ago dop yaŋan Jon ubol a. ");
INSERT INTO tbc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iŋ oŋ ilo bulbal ipano dop oŋ ilo uyanan geig a. Agod tamolpein wei kasik iŋ ilasa yan niŋen o yousai digane wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Man dugo, iŋ Tubun en malan lo tamol tubun ak imado wa. Iŋ wain, ayu naon sensen ak dam ta iluk na wa. Agod saen tinan igansi man, iŋ Awan Urgun iŋanep tinin iŋanefutep pempem ago imado wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iŋ Isrel luluŋad lo tamolpein wei kasik iŋiliaip, dida fon dumul pe iŋsad Tubun ak Anut san na diau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iŋ Tubun ak naon na imug pe dal ikubune wa. Elaija san ur lo, agod Elaija san dabai lo dam ago igane wa. Iŋ idiraip nanuk tamad dida ilod ibilisap, nug niŋen o dumat a, agod tamol silei ak ilod ibilisap, tamolpein itaot ak sad kankan milaen ak diŋane wa. An lo dop iŋsan urat an lo iŋ tamolpein ikubuniaip, Tubun ak ipalu wo malad diganep dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ago tag Sakaraia eŋel an isumiani, “Ŋai iwog da mel saiak migane ya. Dugo woŋ pe ru ubol an nuŋon ŋaloŋ ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Agog eŋel an ru naon irupeig ibol, “Ŋai Gebriel. Ŋai Anut naon na ŋatur da. Anut sen ŋai idinag go, ru uyanan en ŋurupaio wo ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ak man oŋ ŋaisag ru en ilo lo ta rumok na yak niŋen oŋ awa itaup mado wa. Ago mado yaup ru an nuŋon ilasa gup, awa ipuk pe, ŋiŋe wa. Ŋaineg ru iŋanen saen fo mi nuŋon ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ago dugo tamolpein a kuai te Sakaraia dititianig dumado dan, ilo sou wei kasik digane dugo dubol, “Ata mel mok igane dugo saen milaen kasik imado di?” ");
INSERT INTO tbc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Murnag tempel lo kuai te ilasa man, tamolpein ru irupidai san tia ya. Ago tag iŋ duloŋ ak, Sakaraia tempel lo malan ŋutun ile yan lo, iŋiŋeŋ san tia yak niŋen o, banin nam toutou igane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aria, iŋ urat isini san saen itout go iŋsiganen ab lo imul yau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Murnag iwon Elisabet luan anda ya. An niŋen o kalam 5 ab lo imianuk imado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ago dugo ibol, “Tubun en mel en igane panag a. Gamu iŋ ilon ipanag a, agod ŋaisag miai tamolpein naod na ipasi yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet luan andag kalam 6 yau dugo, Anut eŋel Gebriel idinig, Galili provins lo taun ta yaŋan Nasaret, atna yau. ");
INSERT INTO tbc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iŋ pein baras itaot ak ta san na yau a. Pein an yaŋan Maria. King Dawid malan kubulan ta yaŋan Josef dubol dan ŋien dupani a. ");
INSERT INTO tbc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebriel iŋsan na yaug ibol, “Ilo uyan dop mado. Anut ipitiano dak, iŋ ilon ipano dak, iŋ oŋ da amado da.” ");
INSERT INTO tbc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria ru an iloŋ go ilon weiwei dugo ilon lo ibol, “Ilo uyan ru naok ago yan fun dugo mok ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ago tag eŋel irupeig ibol, “Maria, oŋ urer umoi. Anut oŋ o ilon uyan da. ");
INSERT INTO tbc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oŋ lua ama dap, nanuk tamol ak gansip yaŋan Jesus ubol a. ");
INSERT INTO tbc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iŋ tamol tubun ak imado dop, Anut lak na geig an Nanun dubol a. Agop, Anut iganep iŋ kiŋ ilasap, tubun bagen Dawid imado yak ago mi imado wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iŋ Isrel tamolpein pempem mi itirnaip imado wa. Iŋsan kagin panek wadan an itout san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ago tag Maria eŋel isumianig ibol, “Ŋai tamol da gamugo mator da, an lo mel an dugo woŋ ilasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eŋel an ru naon irupei, “Awan Urgun oŋ lo idup, Anut lak na yan san dabai oŋ ituano wa. An niŋen o nanuk a mitep gansi wan gun a, agod tamolpein iŋ Anut Nanun dubol a. ");
INSERT INTO tbc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Uloŋ. Oŋ nibi Elisabet pein saiak bo man, iŋ dam luan anda ya. Imug iŋ niganig dubol na ya. Gug gamu iŋ luan andad kalam 6 ibisei la ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Man dugo, Anut iŋ lo man mel fidian pasauman a, ta muruan man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ago tag Maria ru naon irupei, “Ŋai Tubun en san urat pein mi a. Ago yak niŋen o ubol dan ago ŋai lo ka ilasa wa.” Agog eŋel an Maria ibiseig yau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Saen an lo, Maria biouŋ ikubuneg, Judea Provins lo panu ta tan bubun titiŋae ak ate ririan yau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yaug, Sakaraia san ab ilon lo iladug, Elisabet ilo uyan ru irupei a. ");
INSERT INTO tbc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Saen Elisabet Maria san ilo uyan ru iloŋ man, iŋanen nanuk tiŋaen lo isokalik a, ago dugo Urgun ilon iŋanefuteg, ");
INSERT INTO tbc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","awan tubun mi ibol, “Oŋ pein fidian luluŋad lo Anut san bar ŋaneg mado da. Nanuk a oŋ gansi wan iŋ dam Anut san bar iŋaneg imado da! ");
INSERT INTO tbc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ŋaineg Tamol Tubun ak tinan ilon ipanag go, ŋai iliag o ipalu ya. Ata wo bar an ipanag ak i? ");
INSERT INTO tbc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uloŋ, saen oŋ ŋai rupaiag man tiŋaeg lo nanuk youn anda isokalik a. ");
INSERT INTO tbc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Oŋ bar ama da mado da, man dugo, mel a Tubun en irupaio yan nuŋon ilasa wan ilo lo rumok go awan wabi a.” ");
INSERT INTO tbc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Agog Maria ibol: “Ŋai ŋutug Anut yaŋan yabisa da, ");
INSERT INTO tbc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","agod ŋaineg ur Anut enti patug ipasi wan lo youn isa da. ");
INSERT INTO tbc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Man dugo, ŋai pein kawan, yaŋag tia ya. Gug iŋ ŋai o ilon isou a. Gamu en, agod nal murnai san fidian, tamolpein fidian ŋai niŋeg o ago dubol a, ‘Pein en bar iŋaneg imado da.’ ");
INSERT INTO tbc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Man dugo, Enti a dabai fidian anda yan, mel tubun geig ak ŋai o igane ya. Rumok, iŋ yaŋan gun a. ");
INSERT INTO tbc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iŋanen ilo muŋanek, tamolpein ensauta a iŋ o direr dan ituanai da, tamolpein e gamu dumado den ituanai da, agod malad kubulan a murnap dilasa wan dam mi a. ");
INSERT INTO tbc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iŋ tuon nam kulob dabdabai ak idiri dugo teil a, Tamol sed bubed lo tutubu dubol dugo yaŋad diabisa dan irubai diau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiŋ dabdabai an ibiai dudu dugo, tamolpein a yaŋad tia yan ibiaisa ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A dumatigen dan melmel uyan uyan ak nam ifutuwaig iŋ luad ipuk a. Ago dugo a filiad anda yan idinaig sen dilasag banid kawan diau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Iŋanen urat tamol Isrel ibinawai a, iŋanen ilo muŋanek ikubiai pidinai an ilon ta iŋaoŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tia, ilo muŋanek an iŋ Abraham iŋanen malan kubulan dadi pempem ikubiaip dile dop na wa, nek ibol tubud baged wagam irupidai ak ago mi a.” ");
INSERT INTO tbc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aria, Maria Elisabet da kalam utol dumado gug, fon imul go sen naon na yau a. ");
INSERT INTO tbc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet nanuk igansi san nal idaisudag, nanuk tamol ak igansi a. ");
INSERT INTO tbc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tubun en Elisabet ilon imuŋani an muroun muroun duloŋ go iŋ dam youdi isa se ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nanuk igansig nal 8 yau dugo, nanuk tinin suŋulon dutute wo, taman waian diganep Sakaraia dubol o dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ak man tinan imoig ru igo ibol, “Tia, yaŋan Jon tabol a.” ");
INSERT INTO tbc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Agog iŋ durupeig dubol, “Ak man oŋ murou murou luluŋad lo yaŋak ta ago man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Agog iŋ banid nam Sakaraia toutou dupanig, nanuk yaŋan ipate wo dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ago tag Sakaraia banin nam toutou igane dugo tafel (slet) dupanig, fo nanuk yaŋan igire: “Iŋ yaŋan Jon.” Agog iŋ fidian durut saian a. ");
INSERT INTO tbc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gamu nam Sakaraia awan ipuk go fun iganeg iŋiŋeŋ dugo, Anut yaŋan yabisa ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Agog ab susumeik an abaŋ ago dileg, durut saian a. Ru an Judea ilon lo panu panu tamolpein fidian duloŋ go, kubol en niŋen o diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tamolpein a fidian ru a duloŋ an ilod weiweig nug dusumiani, “Ak dugo, nanuk an san madok murnap dugo wak i?” Iŋ kuai tem dile yak Anut anen tuon dabai nanuk an da ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Awan Urgun Jon taman Sakaraia ilon iŋanefuteg, iŋ profet ru en ibol a, ");
INSERT INTO tbc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Id Tubun en per tupani wa, iŋ mi Isrel san Anut. Iŋ ipalug iŋsan tamolpein yil go idad iŋal a. ");
INSERT INTO tbc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iŋ tamol dabai ak ta, id patud ipasi san igane ilasa ya. Tamol en man, iŋsan urat tamol Dawid san dar lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wagam na mok iŋsan profet gun adi awad lo ru en ibol: ");
INSERT INTO tbc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iŋ idsad ager banid lo ipasad iŋiliad a. Agod tamol a id lo siai digane dan tuod lo dam ipasad iŋiliad a. ");
INSERT INTO tbc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iŋ idsad tubud baged ilo muŋanek ikubiai pidinai a. Ago dugo iŋsan kontrak gun an niŋen o ilon isou a. ");
INSERT INTO tbc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iŋ idsad tubud baged Abraham ru promis en irupeig ibol: ");
INSERT INTO tbc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Id ager tuod lo ipasad pe id ilo urer tiap, iŋsan urat tigane wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Id saen fidian tan e lo tumado den lo, iŋ naon na kagin gun ak lo, agod kagin itaot ak lo dam ago tigane wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O ŋai nanug, oŋ Anut lak na geig ak san profet dubol a. Man dugo, oŋ umug pe Tubun en san dal kubune pani wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Iŋanen tamolpein patu pasek ka diŋane wan, oŋ maŋau en pidinai a, Anut iŋaned aupasek isuas pidinai dan lo patud ipasi san duloŋ fufei a. ");
INSERT INTO tbc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Idsad Anut iŋanen ilo muŋanek lo ago igane ya. Iŋsan ilo muŋanek lo, iŋ Nanun ad isuda dak igo woŋ kumaen panu nap idsad na ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Agop iŋanen lilaman tamolpein a tidom tubun lo dumado dan, agod mateŋ san mirau lo dumado dan dam, tinid isapudade wa. Agop maror san dal ikubiai panad pe fo tator a.” ");
INSERT INTO tbc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nanuk an italbusig iŋanen ŋutun lo dabai iŋaneg imado se ya. Aria, iŋ aben kawan ak lo imado yaug, iŋsan saen fog Isrel tamolpein malad lo kuai te ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Saen an lo Rom gabman gurman Kaisa Ogastas kubiaeŋ ta igane ya. Tamolpein a tan fidian lo Rom gabman paen na dumado dan, yaŋadi buk lo digire wo ibol. ");
INSERT INTO tbc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Yaŋa kubunek en malmalan a, saen Kwirinias iŋ Siria san gurman imado yan lo ilasa ya.) ");
INSERT INTO tbc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Agog tamolpein fidian iŋsiganed fun panu lo yaŋad dukubune wo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","An niŋen o Josef dam Galili distrik lo panu ta yaŋan Nasaret ibiseig, Judea na panu ta yaŋan Betlehem dubol dan te yau a. Aben an Kiŋ Dawid san panu fun. Josef iŋ Dawid malan kubulan, amaiak niŋen o iŋ ante yau a. ");
INSERT INTO tbc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josef iŋ Maria ŋien dupani ak niŋen o iŋaneg ida diau a. Saen an lo Maria iŋ luan anda la ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betlehem na mi dumado dugo, Maria nanuk igansi san saen idu ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Agog nanuk matu tamol ak igansig, yamel nam ibuluwig, makau ab lo makau sad anaŋ nuaeŋ san kunup lo iganeg yen a. Man dugo, lou ab lo dusumiai ak man aben fidian awan isa la ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tidom lo panu gigin te sipsip sad titianek tamol kuai te sipsip kagin dupidinai dugo, ");
INSERT INTO tbc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Anut san eŋel ta sad na ilasa ya. Anut san lilaman abaŋ isapudade yan dileg direr dugo dusuruwor saian geig a. ");
INSERT INTO tbc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ak gug eŋel an irupidaig ibol, “Arer amoi. Ŋai ru uyan ak ŋurupaiaŋ o ŋupalu ya. Tamolpein fidian mitep ilodi uyanan geig a. ");
INSERT INTO tbc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tidom nek en lo Dawid san panu lo aŋsam patu pasek tamol ilasa ya. Iŋ man Kristus, aŋanem Tubun a. ");
INSERT INTO tbc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iŋ ale san kob igo ya, au gup nanuk an yamel nam dubuluwig, makau sad anaŋ nuaeŋ kunup lo yen dop ale wa.” ");
INSERT INTO tbc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ago ibol man, gamu nam Anut san yu doup eŋel adi malan wei mi kuai disig, eŋel malan te yan ida Anut per dupani se ya. Ago dugo igo dubol, ");
INSERT INTO tbc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Aben lak na geig ak lo, Anut girager anda yaŋan mabisa da. Ago dugo tan na, tamolpein ensauta a Anut ilon ipidinai dan, iŋanen maror ipidinai a.” ");
INSERT INTO tbc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Saen eŋel fidian mi dumul go kumaen panu na diau man, sipsip sad titianek tamol an sed nug durupei, “Betlehem na taup, mel e niŋen o Tubun en irupaiad en tile wa.” ");
INSERT INTO tbc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Agog ririan diaug, Josef iŋ Maria da dil dugo, nanuk an dam makau sad anaŋ nuaeŋ kunup lo yen dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iŋ nanuk dile la gug, ru a nanuk an niŋen o eŋel irupidai an diŋaneg panu susumeik an lo tamolpein durupidai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ago dugo fidian a ru an duloŋ man, durut saian go ilod weiwei se ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gug Maria ru an fidian ilon lo igane ya, ago gug saen wei mi mel an fidian ilon isoug kankan igane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Agog sipsip titianek tamol an dumul go sipsip sad na diau se yan, Anut yaŋan diabisa dugo per dupani a. Man dugo, nek eŋel irupidai ak ago, mel a fidian ilasa yan, agod ru a fidian duloŋ an dam, itaot ilasa dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nanuk ilasag nal 8 yau dugo, nanuk tinin suŋulon dututeg, yaŋan Jesus dubol. Maria gamugo luan anda dugo yaŋak an eŋel ipalug Maria irupei ak fom dupate ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses san kubiaeŋ ago ibol, pein enti nanuk igansip nal 40 yau dop iŋ fon ikok ilasa da wa. Aria, Maria malan iganeg nal 40 yau itout go, Josef Maria da Jesus diŋaneg Jerusalem na diau a. Ante iŋ Jesus diŋanep Tubun en dupani wo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Man dugo, Tubun en san kubiaeŋ lo ru igo digire ya, “Nanuk matu ak fidian man iŋaned tinad tamad diŋal diaup Tubun en dupani wa, an lo dop saen fidian Tubun en wagen lo gun dutor a.” ");
INSERT INTO tbc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kubiaeŋ an ibol, “muluk uraru, tia tap, anakanak nanun uraru muluk oŋ ak Anut yai gane pani wa.” Aria, Josef iŋ Maria da kubiaeŋ an dirig yai niganag naok an digane ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aria, tamol ta Jerusalem na imado yan yaŋan Simion. Iŋ tamol itaot, agod Anut awan paen na imado ya. Anut Isrel tamolpein ibinawai san saen ilasa wo, malan iganeg imado se ya. Iŋ lo dam Urgun imado ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gubak mi Awan Urgun irupeig iloŋ ak, iŋ gamugo imat dop Anut anen Kristus ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aria, gamu Awan Urgun iduduwig an lo tempel san ar lo iladu ya. Saen an lo Josef, Maria da Jesus diabig ru kagin a kubiaeŋ irupidai an duri dupani wo dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Agog Simion Jesus ileg siŋiren na yaug ilatig Anut per ipanig igo ibol, ");
INSERT INTO tbc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tubun en, oŋane promis ru gubak mi ubol paiag an gamu nuŋon gane ya. Ago yak niŋen o rupaiag pe ŋai oŋane urat tamol tan en ŋibiseip, maror lo mi ŋau a. ");
INSERT INTO tbc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Man dugo, ŋaiseg malag nam oŋane patun pasek tamol ŋile ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tamolpein fidian malad lo oŋ tamol en gane ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iŋ sul oŋ ilasap imado dop gob adi ru iŋ niŋen o duloŋ pe ilod ilalaŋ a, agod iŋ lo oŋane Isrel tamolpein yaŋak tubun ak diŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nanuk an tinan taman ru e Simion ibol en duloŋ go durut saian a. ");
INSERT INTO tbc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Agog Simion bar ipidinaig Maria irupeig ibol, “Anut gubak mi ilon igo yen a, nanuk en Isrel tamolpein luluŋad lo, wei mi dudu diau dop, aenta wei mi dam ibiaisa wa. Agod tamolpein wei mi nanuk an dile saian dop iŋ niŋen o ru saian ak amad da wa. ");
INSERT INTO tbc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Iŋ tamolpein sad kankan imianuk an kuai te iganep fidian dile wa. Agod sabiri ta luon ak oŋane ŋutu isue wa.” ");
INSERT INTO tbc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aria, profet pein ta, yaŋan Ana, iŋ dam tempel lo imado ya. Iŋ Fanuel nanun pein, Asa san gugoi lo ilasa ya. Iŋ mel saiak geig a. Anaŋar 7 tamol ida dumado yau gug tamol imat a. ");
INSERT INTO tbc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Agog pein suos imado yaug san anaŋar 84. Iŋ tempel san tumanek aben ta ibisei na da. Tidom ad Anut yaŋan yabisa dugo igudani da. Saen aenta anaŋ geg iganep gudanek mi igane da. ");
INSERT INTO tbc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aria, Simion pein tamol an ru irupidai dugo, saen nek an lo Ana ipalug, iŋ dam Anut yaŋan yabisag, nanuk an niŋen o Jerusalem tamolpein ensauta a Anut ibinawai o malad diganeg dumado se yan irupidai a. ");
INSERT INTO tbc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jesus tinan taman mel fidian Anut san kubiaeŋ ibol ago mi digane itout go fon dumul, Galili provins lo iŋsiganed panu Nasaret na diau a. ");
INSERT INTO tbc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Agog nanuk italbusig tubun go, tinin dam dabai dugo kankan milaen ak iŋ lo awan isa geig a. Ago dugo Anut ilon tubun mi ipani na ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesus tinan taman iŋ anaŋar fidian, saen Pasova san ad nanek ilasa dan lo, Jerusalem na tumanek tubun an lo diau na ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aria, Jesus san anaŋar 12 dugo diŋaneg Jerusalem na diaug iŋaned kagin yen ago mi duri a. ");
INSERT INTO tbc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Murnag Pasova ad nanek itout go fon dumul iŋsiganed na diau se ya. Jesus iŋ Jerusalem na imado yan, iŋanen tinan taman ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iŋ ilod lo Jesus tamolpein aenta luluŋad lo dadi diau dak dubol. An niŋen o adian kisaek dutor se ya. Agog gurai idu yan, turad muroud luluŋad lo Jesus abaŋan diabi a. ");
INSERT INTO tbc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gug kitek dile man tia tag Jerusalem na abaŋ diabi wo dumul a. ");
INSERT INTO tbc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nal utol abaŋan diabi ak gug, iŋ ta dile na ya. Ago gug tempel lo diladug dile ya. Iŋ Juda sad girek maŋau luluŋad lo imasig, ru a dubol na yan iloŋ dugo, isumianai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ago dugo fidian iŋsan ŋiŋeŋ, maŋau, agod ru naon a irupidai an duloŋ go, durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tinan taman abaŋ ago dile man dam durut saian go tinan irupeig ibol, “Bai, oŋ ata wo maŋ igo giniama yak i? Ŋai oŋ tama da iloma muruan kasik dugo, oŋ abaŋa mabi se ya.” ");
INSERT INTO tbc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ago tag Jesus ibol go isumianai, “Aŋ ata wo ŋai abaŋag abi se yak i? Ŋai tamag san ab lo ŋumado dak, an aŋ ta aloŋ na yak i?” ");
INSERT INTO tbc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ak man ru e irupidai den fun mok ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Agog Jesus tinan taman dida dumul Nasaret na diaug, pempem awad paen na mi imado se ya. Ak man tinan melmel fidian a ilasa na yan, ilon lo iganeg yen go kankan igane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Agog Jesus iŋanen tinin, agod iŋanen kankan iloŋ san dam italbusig tubun a. Anut, agod tamolpein dam iŋ dipitiani na ya. ");
INSERT INTO tbc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibirias Kaisa anaŋar 15 Rom gabman kagin ipani dugo, Pontias Pailat Judea kagin ipani se ya. Ago dugo Herod Galili san tamol tubun geig, iŋ tein Filip dam nek ago mi Iturea iŋ Trakonaitis ida kagin ipidinai dugo, Laisenias provins Abilene kagin ipani se ya. ");
INSERT INTO tbc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ago dugo Anas, Kaiafas da man pris gurman malan te ya. Saen an lo Anut anen ru Sakaraia nanun Jon, aben kawan tamol tia yak lo imado dugo san na yaug ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Agog Jon you Jordan giraŋen na aben fidian san tamolpein Anut san ru irupidai dugo itor se ya. Iŋsan ru malan te man igo ibol, “Tamolpein aŋanem aupasek patum apanip, ilom abileksap, apalup suguek aŋane wa. Ago tap Anut aŋanem aupasek isuas panaŋ a. Suguek man aŋanem ilom abilisa yan san kob.” ");
INSERT INTO tbc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nek imug profet Aisaia san buk lo girek ibol ago mi gamu ilasa ya. Girek ago ibol, “Tan kawan ak ate wagiŋ ta ilasag ibol, ‘Tubun en iŋanen dal akubunep itaot yen a. ");
INSERT INTO tbc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tan ilokan an fidian atutumip awan isa wa. Did tutubun an, agod bubun fidian agilep tan na idu wa. Dal ikael ak aganep itaot a. Dal gubog ak atutumip uyan da wa. ");
INSERT INTO tbc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ago dop tamolpein fidian iŋ patu pasek tamol a Anut idinip ipalu wan dile wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Agog tamolpein wei kasik Jon san na suguek diŋane wo dupalu dugo Jon naod ifuteg ipidai, “Aŋ mot nanun moroun! Enti Anut san tiŋae saian mitep ilasa wan niŋen o ru kagin ipanaŋ dugo asol dak i? ");
INSERT INTO tbc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aŋ ilom ibilisa dak iri panim, kagin an san nuŋon mok agane ilasa wa. Aŋ siŋanem ilom lo igo ta abol na wa, ‘Abraham man maŋ tamama ya, an maŋ o idaisuda ya.’ Man dugo, ŋai en ŋurupaiaŋ itaot da, Anut ilon ibol tap man, pat e dien den ka iŋal pe ibilisap Abraham nanun muroun mok oŋ dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pilagis ai dabin lo yen la ya. Ai fidian a nuŋod uyan uyan ta ifu na dan, Anut itarep yabi yaup inanai yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tamolpein ru an duloŋ tag dusumiani, “Maŋ dugo migane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Agog ru naon irupidaig ibol, “Ta iŋ kulos uraru tap, neinta kulos aman tia yan ipani wa. Nek ago mi, ta iŋ anaŋ anda tap, iŋ dam ago mi igane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Agog takis ŋilaŋal tamol dam suguek diŋane wo dupalug Jon dusumiani, “Girek maŋau, maŋ dam dugo migane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Agog Jon irupidaig ibol, “Aŋ tamolpein arawai dop sad moni subuŋan kawan ak da ta aŋane na wa. Gabman sen ibol ago mi itaot aŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ago dugo yu tamol aenta dam dusumiani, “Maŋ dam, en dugo migane wak i?” Agog ru naon irupidaig ibol, “Aŋ tamolpein afu dan lo banid na moni ta aŋane na wa. Aŋ ru sewak lo dam iŋsad moni ta aŋane na wa. Aŋanem urat naon dupanaŋ dan mi aŋ o idaisuda wak niŋen ilom maror anda amado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tamolpein fidian mala nouk lo Kristus dititiani se ya, an niŋen o bubed ilon lo Jon iŋ Kristus mok ago dubol dugo ilod weiwei se ya. ");
INSERT INTO tbc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ago tag Jon irupidai, “Ŋai you lo mi aŋ ŋusuguaŋ da. Ak man tamol a ŋai patug fo ipalu dan iŋsan dabai ŋaisag dabai iriŋani geig a. Ŋai man tamol kawan a, amaiak niŋen o iŋsan sendal san kam ŋupasi san o yaŋag tia ya. Gug tamol en man Awan Urgun lo isuguaŋ a, agod Urgun an san yai nam ifulanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iŋ banin lo kon gilek lo idirai san biouŋ yabig imado da. Aben ante urat a igane wan ikubineg ante itur da. Uyan ak senamo idirai dop, metmet adi yabi yau o da. Ago dop kon anaŋ ab lo itumani wa. Ak man metmet adi man yai lo yabi yau a. Agod tamol ta yai an igane imat san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dal wei kasik lo Jon tamolpein bubed yabisa san ru ibol dop lo Anut anen ru uyan ak ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gug Jon gabman gurman Herod san naok naok saian an ifulale yaug, tein san pein iŋane an lo isuda tag, Herod tiŋaen saian go Jon subanek lo igane ya. ");
INSERT INTO tbc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ago igane an lo iŋsiganen muruan a imug igane se yan muruan taidam ibate ya. ");
INSERT INTO tbc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aria, Jon subanek lo gamugo digane dugo mel en ilasa ya. Nal ta tamolpein fidian suguek diŋane dugo Jesus dam ipalug suguek iŋane ya. Suguek iŋaneg itout go Anut igudani se ya. Saen nek an lo kumaen panu san dalawan ipasig yen dugo, ");
INSERT INTO tbc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Anut san Ur muluk oŋ idug, iŋ kabuŋan fufo imasi a. Agog kumaen panu lo wagiŋ ta idug, igo ibol “Oŋ ŋaineg Nanug, ŋaineg bubeg mok, oŋ niŋe wo ŋai ilog tubun mi uyanan da.” ");
INSERT INTO tbc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus san anaŋar 30 dugo, urat fun igane ya. Tamolpein ilod lo iŋ Josef nanun ago dubol se ya. Aria, yaŋak e irig ipalu den iŋ Josef san tubun bagen a. ");
INSERT INTO tbc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Eli, Matat, Livai, Melki, Janai, Josef, Matatias, Amos, Nahum, Esli, Nagai, Maat, Matatias, Semein, Josek, Joda, Joanan, Resa, Serababel, Sialtiel, Neri, Melki, Adi, Kosam, Elmadam, Er, Josua, Eliesa, Jorim, Matat, Livai, Simion, Juda, Josef, Jonam, Eliakim, Melea, Mena, Matata, Natan, Dawid, Jese, Obed, Boas, Sala, Nason, Aminadab, Admin, Arni, Esron, Peres, Juda, Jakob, Aisak, Abraham, Tera, Nahor, Serug, Reu, Peleg, Eber, Sela, Kainan, Arfaksad, Sem, Noa, Lamek, Metusela, Enok, Jared, Mahalelel, Kainan, Enos, Set. Set man Adam nanun, agod Adam iŋ Anut nanun. ");
INSERT INTO tbc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus Urgun buben iŋanefuteg, you Jordan ibisei a. Agog Urgun iduduwig, tan kawan ak ate yau a. ");
INSERT INTO tbc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nal 40 anaŋ tia imado dugo Satan Jesus naon ikubiani se ya. Saen an lo iŋ anaŋ ta yani na ya, an niŋen o saen an itout man imatigen saian. ");
INSERT INTO tbc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan igo irupeig ibol, “Oŋ Anut Nanun tap, ubol dop pat en bret oŋ ibilisa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus ru naon irupei, “Girek e buk lo yen den igo ibol, tamol bret lo mi ta kumaen imado na da.” ");
INSERT INTO tbc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Agog afon Satan Jesus iŋaneg did lak na yak kabuŋan fufo igunig itur dugo tan en san abaŋ fidian ikubiai pani kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Agog irupeig ibol, “Iŋaned dabai a ule dan, agod mel a girager anda yak fidian ule dan dam ŋaisag. Ak niŋen o tamol enti ŋupani wo ilog ibol tap, ka ŋupani wa. ");
INSERT INTO tbc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","An niŋen o oŋ turu soluwip, ubou ag ule tap, ŋai dabai ŋupanop, mel fidian ule dan oŋ kagin pani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ak man Jesus ru naon irupeig ibol, “Girek ta buk lo igo ibol, ‘Oŋ Tubun en oŋane Anut mi ubou an ule wa. Iŋsen mi niŋen o bigabeg urat gane wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Agog fon Satan iŋaneg Jerusalem na diaug, lak na tempel san ŋudun fufo igunig itur go irupei, “Oŋ Anut nanun tap, sokalik pe, tan na udu. ");
INSERT INTO tbc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Man dugo, girek ta buk lo igo ibol, ‘Iŋ iŋanen eŋel irupidai dop kagin dupano wa. ");
INSERT INTO tbc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Banid nam disawo wa, kabelan pat oŋ ŋie ifini banau.’” ");
INSERT INTO tbc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ago tag Jesus ibol, “Girek ta buk lo dam igo ibol, oŋ mel ta gane tap lo Tubun en oŋane Anut an bitinaek lo ta gane na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan Jesus kubianek funfun lo igane tia tag ibiseig yau. Nal ta dop fon ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Agog Jesus Urgun san dabai lo fon imul go Galili na yau. Agog yaŋan panu panu fidian lo yau se ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iŋ panu panu sad ubou ab lo ipiteŋanai dugo tamolpein fidian yaŋan diabisa se ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Agog Jesus Nasaret na yau a. Wagam nanuk lo aben ante italbusi a. Iŋsiganen kagin iri panig, Juda sad ubou leil nal Sabat dubol dan lo yaug Nasaret adi sad ubou ab lo iladu ya. Agog Anut san ru isuti wo imasa yan, profet Aisaia san buk dupani a. Buk roun ifulaleg, ru en ileg isuti: ");
INSERT INTO tbc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tubun en san Ur ŋai lo imado da. Man dugo, ŋai tamolpein kawan filiad tia yan, ru uyanan ak ŋurupidaip duloŋ o ipilianag a. Iŋ ŋai idinag go ŋupalu man, tamolpein ru igo ŋurupidai a: a Satan isubanai an ŋai ka ŋupasaip kuai te dilasa wa, a malad itapul idu yan fon abaŋ ka dile wa, a tamolpein sen ak banid lo muruan dile dan, ŋai iŋsad muruan ŋigane itout a. ");
INSERT INTO tbc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Agod ŋai malak malak igo ŋurupidaip duloŋ ak, anaŋar nek en Tubun ak iŋanen ilo panek ikubiai pidinai o da.” ");
INSERT INTO tbc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Agog Jesus buk ifutanig, biabi ŋilaŋal tamol ipani gug imasi a. Tamolpein fidian ubou ab lo dumado dan malad ti ibol go Jesus dile se ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Agog fun iganeg irupidai, “Ru nek e kududom iloŋ en gamu geig nuŋon ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Agog iŋ fidian dupitiani se ya, iŋsan ru duloŋ go iŋ ŋiŋeŋ lo tamol ikawil an ak ago dubol go, durut saian dugo nug dusumiani se ya, “Dugo, an Josef nanun i?” ");
INSERT INTO tbc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Agog Jesus irupidai, “Ŋai mel en niŋen o ilo uraru amag tia ya, aŋ ru faŋan en ŋai arupaiag o da, ‘Dokta, oŋse ikubinio gup! Kulob girager funfun a oŋ Kaperniam na gane yan san ru maloŋ a, gamu kulob naon kisaek oŋsigane fun panu lo dam gane wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Agog fon ru igo irupidai, “Ŋai rumok ŋurupaiaŋ da, profet man iŋsiganen fun panu lo tamolpein iŋ dumoi da. ");
INSERT INTO tbc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mel en rumok a, profet Elaija san nal lo Isrel pein wei mi suos dumado ya. Saen an lo man daded tubun a. Anaŋar utol kalam 6 ui tia ya. Ago dugo kadag tubun aben fidian yabig yen se ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ak man Anut Elaija idinig Isrel pein suos ta san na yau man tia ya. Tia, iŋ idinig gob adi sad taun Saidon lubanek lo, panu Sarefat san pein suos ta san na yau a. ");
INSERT INTO tbc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Agod profet Elaija san saen lo dam Isrel tamolpein wei kasik lepra amad da ya. Gug kisaek ta igane uyan man tia ya. Tia, gob adi a tan Siria lo dumado dan luluŋad lo tamol kisaek yaŋan Neman, Elaija nek an mi ikubuneg uyan a.” ");
INSERT INTO tbc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tamolpein fidian ubou ab an lo ru en duloŋ go tiŋaed tubun mi saian a. ");
INSERT INTO tbc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ago tag dumasag, Jesus diŋaneg, aen damon fo dibilip idu wo tan bubun fo disuda diau a. ");
INSERT INTO tbc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gug banid lo ikisaluk ilasag, tumanek malan an titiŋae mi imul go ilon ibol ak lo yau a. ");
INSERT INTO tbc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesus Galili Provins lo panu Kaperniam na yau a. Atna Sabat nal lo yaug tamolpein iŋsad ubou ab lo maŋau ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iŋanen ru duloŋ man, tamol tubun yaŋan anda yak oŋ ipiteŋanai se yan niŋen o durut saian a. ");
INSERT INTO tbc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aria, ubou ab an lo tamol ta ur saian anda yak awan tubun mi iwagiŋ go ibol, ");
INSERT INTO tbc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oŋ Jesus Nasaret tamol, maŋ dugo giniama wo palu yak i? Nag oŋ maŋ daoŋ panama wo palu boi a? Ŋai oŋ ŋaloŋ a. Oŋ Anut san tamol gun a!” ");
INSERT INTO tbc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ak man Jesus ur saian an ipeig ibol, “Awa itaup, tamol an biseip lasa.” Agog ur saian tamol an tamolpein malad lo ibili idug, tamol an ibiseig ilasa ya. Gug ur saian tamol an tinin malan ta isue na ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Agog tamolpein fidian durut saian go, iŋsed diŋiŋeŋ dugo dubol, “Enso ru ta dabai anda ibol dugo ur saian saian awan duloŋ dugo dilasa diau di?” ");
INSERT INTO tbc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","An lo Jesus san yaŋan ifurak go panu panu yau. ");
INSERT INTO tbc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus ubou ab an ibiseig, Saimon san ab lo yau a. Saimon raon subam ifinig, tinin wananan tubun kasik ak niŋen o, Jesus ibinawi wo dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ago tag giraŋen na yaug, iyep go ru dabai nam subam an ikudi a. Gamu nam subam an ibiseig, pein an imasa kisaek oŋ go anaŋ ikubune pidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gurai idu yan, tamolpein iŋsad panu lo subam amad da yak diŋal go, Jesus san na dupalu se ya. Agog iŋ banin tinid fo iganeg, fidian uyadi isusa ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ur saian saian dam tamolpein wei kasik dibisawai dugo duwagiŋ, “Oŋ Anut Nanun.” Ago tag Jesus nao futek ru nam ipidai dugo awad lo diŋiŋeŋ san ipadau a, man dugo, iŋ Kristus duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tidom lom mok Jesus panu an ibiseig, aben ta yoitout ak lo yau a. Ak man tamolpein Jesus niŋen o abaŋ dile se ya. Saen iŋ dile man, kabelan ibisawaip yau banau dupurani wo digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ak man iŋ irupidai, “Ŋai ru uyanan e Anut san kagin panek niŋen o yan, panu aenta lo dam ŋufulale wa. Urat nek an niŋen Anut idinag go ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Agog Judea ilon lo panu panu yaug iŋaned ubou ab lo Anut ru ifulale na ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nal ta Jesus Genesaret san you saltek aen te itur dugo tamolpein wei kasik Anut san ru duloŋ o dususag, nug tinin fo dutur se ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Agog iŋ malan yau nag, wog urarum loŋ ate dien dugo yil a. Wog muroudi man loŋ na dob dufulanai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Agog Jesus idug, wog ta lo isuda ya. An Saimon san wog. Agog Jesus Saimon irupei, “Wog kitek usoup tilasa.” Jesus wog fo imasig imado dugo tamolpein Anut san ru ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ipiteŋanaig itout man Saimon irupei, “Wog ŋanep lasa waup, bet ak lo gup tura murou dadi dob arae.” ");
INSERT INTO tbc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ago tag Saimon ru naon irupei, “Tubun en, tidom milaen maŋ urat wagai mok migane se ya, ak gug iy ta kisaek miŋane man tia ya. Ak man gamu oŋ ubol ak niŋen o awa mabip dob ka mirae wa.” ");
INSERT INTO tbc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Agog dob diraeg, iy wei kasik mok dob lo dusuda ya. Agog dob itout o igane tag, turad muroud wog neinta lo yan dibinawai o banid nam toutou diganeg dupalu ya. Agog wog urarum iy didiri awad isag disarir o dutoŋ. ");
INSERT INTO tbc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita abaŋ ago ile tag Jesus naon na turun isaluwig ibol, “O Tubun en, ŋai tamol saiag. Oŋ ŋai bisawag pe wau.” ");
INSERT INTO tbc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iy wei mok diŋane an Pita turan dida dileg, durut saian ak niŋen o Pita ru an ibol a. ");
INSERT INTO tbc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon turan muroun, Sebedi nanun urarum, Jems iŋ Jon da dam durut saian a. Agog Jesus Saimon irupei, “Urer umoi. Oŋ gamu agod nal murnai san fidian oŋ tamolpein dideg diau dan ago mok uŋal a.” ");
INSERT INTO tbc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Agog wog urarum durau isudag melmel fidian diabi idug yen dugo Jesus ŋien aban duri diau na ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus panu tubun ak ta lo imado dugo, tamol ta tinin lepra yafutani an ipalu ya. Iŋ Jesus ileg ŋien fo turun isaluwi idug, imosiaig ibol, “O Tubun en, oŋ ilo ibol tap, ŋai binawag pe fon tinig uyan ilasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus ru an iloŋ go banin iwateg isupuri dugo irupei, “Ubol agom ŋai ilog ago yen da, oŋ uya lasa.” Agog tamol an tinin uyan ilasa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ago dugo Jesus ru dabai nam irupeig ibol, “Kulob ilasa yen niŋen o aenta ta rupidai na wa. Tia, itaot waup, tini Juda sad pris mi kubiaip ile dop, mudan a Moses san kubiaeŋ lo ibol dan ŋanep Anut yai gane pani. An lo dop tamolpein duloŋ ak oŋane subam itout a.” ");
INSERT INTO tbc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesus kulob igane yan san ru panu panu yaug, tamol wei kasik iŋsan ru duloŋ o dususa se ya. Subam amad da yak ikubuniai o dam dupalu se ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ak man Jesus saen wei mi ibisawaig, aben yoitout ak ate yaug igudani se ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jesus nal ta tamolpein ipiteŋanai dugo, Farisi iŋ kubiaeŋ san girek maŋau Judea provins lo, Galili Provins lo panu kititik an fidian, agod Jerusalem na yan dam dida dumado ya. Anut san dabai Jesus san kubunek urat igane yan lo yen a. ");
INSERT INTO tbc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Agog tamol ta ŋien banin fidian tubabun ak kapal anda Jesus san na disinig dupalu ya. Ab lo diladu wo digane ak man tamolpein wei kasik, an lo man diladu san ta isuda na ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ago tag ab aten lak na yak fo disida ya. Agog ab aten an diabigigeg dugo kapal an duyuweg, Jesus tamolpein luluŋad lo imado dugo naon na idu ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus iŋsad ilo rumok ile tag tamol an irupei, “O turag, ŋai oŋane aupasek fidian ŋupasi yau la ya.” ");
INSERT INTO tbc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ago tag kubiaeŋ san girek maŋau, iŋ Farisi dadi kankan diŋaneg ilod lo mi igo dusumiaeŋ, “Tamol en so tamol ta yak i? Ru a ibol dan man Anut kukokan igane da. Tamol ta muruan pasek san dabai anda man tia ya, Anut mi iŋ dabai anda ya.” ");
INSERT INTO tbc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Gug Jesus iŋsad ilo girek fidian iloŋ pasi ak niŋen o ru naon igo ibol irupidai, “Aŋ ata wo kankan ago agane dak i? ");
INSERT INTO tbc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ata mel pasauman ak i? Aria, ŋai igo ŋabol, ‘Oŋane aupasek ŋupasi yau wo?’ Tia, ‘Masap kapal wabisap utor o?’ ");
INSERT INTO tbc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gug kulob e ŋigane en lo ŋai, Tamol Nanun, tan en lo Anut wagen lo aupasek ka ŋupasi yau amaiak aloŋ o ...” saen ago ibol man, tamol a ŋien banin itubabun an irupei, “Oŋ masa utur pe oŋane kapal ŋanep oŋsigane na wau.” ");
INSERT INTO tbc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Agog tamol an naod na imasa itur go, iŋsan kapal isinig, Anut yaŋan yabisa dugo, siganen ab lo yau a. ");
INSERT INTO tbc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tamolpein fidian durut saian geig go Anut yaŋan diabisa ya. Ilod irut dugo tinid iŋanefuteg igo dubol, “Gamu maŋ kulob senamo geig mok mile ya.” ");
INSERT INTO tbc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ago gug Jesus ab an ibiseig yaug, takis ŋilaŋal tamol, yaŋan Livai, urat ab lo imado dugo ile ya. Agog Jesus irupei, “Ŋieg aban uri.” ");
INSERT INTO tbc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ago tag Livai mel fidian yabidug dien dugo, Jesus ŋien aban iri a. ");
INSERT INTO tbc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livai Jesus niŋen o soubul tubun ak iŋsan ab lo igane ya. Doup luluŋad lo takis ŋilaŋal tamol wei kasik agod tamol aenta dam dususag, dida anaŋ diani se ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","An niŋen o Farisi, iŋ Farisi sad kubiaeŋ san girek maŋau dida Jesus san megeloum naod na duŋurŋur go dusumianai, “En ata wo aŋsam girek maŋau takis ŋilaŋal, agod aupasek tamolpein dida sisem anaŋ diani dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ago tag Jesus ru naon irupidaig ibol, “Tamolpein a uyadi ak dokta san na ta diau na wa, tia, tamolpein subam anda yak mi diau a. ");
INSERT INTO tbc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Man dugo, ŋai tamolpein a itaot adi dubol dak ŋigiaip dupalu san niŋen o ta ŋupalu na ya, tia, aupasek tamol adi mi ŋigiai o ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tamolpein aenta Jesus igo dubol durupei, “Jon san urat pinein nal kadi anaŋ geg diganep, gudanek mi digane da. Farisi sad megeloum dam ago digane da. Gug oŋsa megeloum man diani duluk oŋ da.” ");
INSERT INTO tbc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ago tag Jesus ru faŋan en irupidai, “Ak dugo, tamol ta pein iŋane dop, turan muroun aenta dupalup, dida dumado dop anaŋ o waliŋ igane wak i? Tia geig a. Iŋ youd isap, dida ilo uyan lo mi dumado wa. ");
INSERT INTO tbc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gug murnap saen idu gup, tamol an dupasi wa. Nal an lo, iŋ anaŋ waliŋ digane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Agog Jesus ru faŋan taidam irupidaig ibol, “Tamol ta iŋ yamel kilaken foun ak ta irasirep ate kulos wagam ak san mutunuk ta iwei na da. Tamol ago igane tap, iŋ yamel kilaken foun an daoŋ ipani wa. Taida mi, yamel kilaken foun an iŋ kulos wagam an ida naod kisaek tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Agod tamol ta iŋ wain foun ak iŋanep, bilelek suŋulon wagam ak lo ta iwali na da. Iŋ ago igane tap, wain foun an bilelek suŋulon wagam an ikafut yaup ipuk pe, ikulmaek, tan na idup, bilelek suŋulon dam daoŋ ipani wa. ");
INSERT INTO tbc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wain foun ak tap, bilelek suŋulon foun ak lo iwali wa. ");
INSERT INTO tbc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Agod tamol wain wagam ak iluk dan wain foun ak imoi da. Ago dop ibol a, ‘Wagam en mi uyan a.’” ");
INSERT INTO tbc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ubou nal ta lo Jesus kon san abi ilon lo itor se ya. Ago dugo iŋsan megeloum dimatigen, an niŋen o iŋ kon nuŋon aenta dufunig banid nam dufufari yau dugo nuŋon diani se ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ak man Farisi aenta dubol, “Enta wo aŋ urat a Sabat nal lo tigane san niŋen o idsad kubiaeŋ ipadau amaiak agane dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ago man Jesus ru naon irupidaig igo ibol, “Nag mel e Dawid igane yen ta asuti na ak i? Iŋ iŋanen turan muroun dida kadag san saen lo anaŋ o dumat go, ");
INSERT INTO tbc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawid Anut san ab lo iladug, bret a Anut naon na didirig dien an isinig, iŋanen yu tamol adi dida diani a. Bret an tamolpein fidian lo geg a, nek Anut san pris mi diani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Agog irupidai, “Tamol Nanun man iŋsen Sabat nal an muroun.” ");
INSERT INTO tbc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Juda sad nal gun Sabat nal taidam lo Jesus ubou ab ta lo iladug, tamolpein Anut san ru ipiteŋanai se ya. Tamol ta banin saian ak dam saen an lo imado ya. Banin won ak ikurŋak a. ");
INSERT INTO tbc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kubiaeŋ san girek maŋau iŋ Farisi dida malad ti ibol dugo, Jesus leil dupani se ya. Jesus Sabat nal lo tamol ta ikubune dop dile wo malad digane da, man dugo, dal abaŋ dilep lo Jesus ru dupani wo ilod ibol se ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gug Jesus iŋsad ilodi an iloŋ tag, tamol banin saian an irupei, “Oŋ masap, titiŋae mi utur.” Ago tag imasag yaug titiŋae mi malad lo itur se ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Agog Jesus girek maŋau iŋ Farisi dida isumianai, “Idsad kubiaeŋ dugo ibol i? Id ubou nal lo kagin uyan ak tigane wo? Tia, kagin saian ak tigane wak i? Tamol ta tibinawi wo? Tia, ta daoŋ tupani wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Agog Jesus tamol an fidian yil ilubanai ak gug ru naon tia tag, tamol an irupei, “Bani wate.” Tamol an ago iganeg, banin gamu nam uyan ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ak man iŋ tiŋaed tubun mi saian go, enso muruan ta Jesus dupani san niŋen nug lo diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Murnag nal ta lo Jesus igudani wo did fo yau a. Tidom milaen igudani dugo yaug salso idu. ");
INSERT INTO tbc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tidom lom iŋanen megeloum igiaig dupalu ya, agog 12 ipilianaig yaŋad aposel ibol a. ");
INSERT INTO tbc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iŋ yaŋadi igo iri a: Saimon yaŋan neinta Pita ibol, iŋ tein Andru, Jems iŋ Jon da, Filip iŋ Batolomiu da, ");
INSERT INTO tbc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu iŋ Tomas da, Jems, Alfias nanun, Saimon, yaŋan neinta “Rom sad ager tamol” dubol da, ");
INSERT INTO tbc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, Jems nanun, agod Judas Iskeriot. Mitep tamol an Jesus ager banid lo igane wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Murnag Jesus iŋsan megeloum dida dudug, tan aten fo dutur se ya. Tamolpein wei mi dususag Jesus fun na dutur dulubani a. Agog tamolpein malan tubun, Judea provins lo, Jerusalem na, gob sad taun uraru Taia iŋ Saidon da sad loŋ na yan dam dususag dutumani a. ");
INSERT INTO tbc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesus san ru duloŋ dop, subam ad da yak dam ikubuniai o dupalu ya. Tamolpein ur saian ad da yan ikubuniai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dabai iŋsan na ipalug tamolpein ikubuniaig uyadi an lo, tamolpein wei kasik tinin dusupurip uyad dilasa wo siŋiren na dupalu se ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus iŋanen megeloum lo leil igane dugo ibol, “Aŋ a mel amam tiag amado dan, bar aŋaneg amado da. Man dugo, Anut san kagin panek man aŋanem mok a. ");
INSERT INTO tbc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aŋ a gamu amatigen dan, bar aŋaneg amado da. Man dugo, murnap aŋ luam ipuk a. Aŋ a gamu tinaŋ abi dan, bar aŋaneg amado da. Man dugo, murnap aŋ asel a. ");
INSERT INTO tbc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Saen Tamol Nanun niŋen o diliaŋ saian dop, dukudaŋ dop, kukok am digane dop, aŋanem yaŋam saian ago dubol dan niŋen o diabianaŋ dan, aŋ bar aŋaneg amado da.” ");
INSERT INTO tbc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Saen an lo yousai lo asokalik dop ilo uyan am da amado, man dugo, aŋanem naon a Anut ikubune lag kumaen panu na yen dan man tubun geig a. Nek muruan naon kisaek mi iŋaned tubud baged profet adi a imug dumado yan dupidinai se ya.” ");
INSERT INTO tbc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Gug aŋ filiam am da yan kagin agane wa. Man dugo, tan en lo mi madok uyan ak aŋane ya, murnai san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aŋ gamu luam ipuk dan kagin agane wa. Man dugo, aŋ murnap amatigen geig a. Aŋ gamu asel dan kagin agane wa. Man dugo, murnap aŋ ilom ipapao dop tinaŋ aru agane wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aŋ a tamolpein yaŋam diabisa dan kagin agane wa. Man dugo, iŋ tubud baged wagam profet sewak adi niŋedi wo ago mok digane na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Aŋ a ŋaisag ru aloŋ dan ŋai igo ŋurupaiaŋ da. Aŋanem ager niŋedi wo amat a. Ta iliaŋ saian tap, aŋ iŋ ale uyan dop kagin uyan ak mi iŋ o agane wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ta imisilanaŋ tap, bar uyan ak mi apani wa. Ta naom ifute tap, iŋ niŋen o Anut agudani wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta kudaŋam igufute tap, abilisap aenta dam ka igufute wa. Ta aŋsam madid san kulos milaen ak iŋane tap, alefuni dop siot dam ka iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ta aŋsam mel ta wo igod tap, apani. Go ta aŋsam mel iŋane tap, mel an ipanaŋ imul o ta agudani na wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kagin uyan ak aŋ lo digane wo amat dan, ago mi iŋ lo agane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ak dugo, tamolpein a oŋ niŋe wo ilod dupano dan mi ilo pidinai tap, Anut naon uyan ak ta ipano wak i? Tia geig a. Man dugo, aupasek tamol adi dam kagin nek ago mi digane na ya. ");
INSERT INTO tbc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tia dugo, tamolpein a oŋ dibinawo dak mi binawai tap, an lo dugo woŋ naon ule wak i? Tamol saiadi ak dam ago digane da. ");
INSERT INTO tbc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tia dugo, oŋ tamolpein a mel naon dupano wak aloŋ dan mi mel pidinai tap, an lo dugo woŋ naon ule wak i? Tamol saiadi ak dam nug mel dupani dop, naon dam ago mi diŋane da. ");
INSERT INTO tbc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Gidad. Aŋanem ager ilom ipidinaip, kagin uyan ak mi iŋ lo agane wa. Ta mel apani tap, naon ipanaŋ o ta abol na wa. Ago agane tap, murnap naon tubun ak aŋane dop, Anut lak na yan nanun mok amado wa. Man dugo, Anut sen tamolpein a ilo uyan ru ta dupani na dan, agod a iŋsed mi wo ilo sou digane dan dam, ilon ipidinai da. ");
INSERT INTO tbc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ago yak niŋen o nek ibol Bai Anut aŋ ilon imuŋanaŋ dak ago mi, aŋ dam tamolpein aenta ilom imuŋanai a.” ");
INSERT INTO tbc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Oŋ tamolpein aenta bitinaek lo ta giniai na wa, an lo dop Anut dam oŋ bitinaek lo ta iginio na wa. Oŋ muruan niŋen o tamolpein aenta biai dudu umoi, an lo dop Anut dam ta ibio udu na wa. Tia, iŋsad aupasek ilo iŋaoŋ a, an lo dop Anut dam oŋane aupasek ilon iŋaoŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tamolpein mel pidinai tap, Anut dam nek ago mi ipano wa. Tubun mi pidinai tap, Anut dam tubun mi ipanop, awan isa wa. Tou sapta a pidinai dan, tou naon kisaek mi ŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Agog Jesus ru faŋan en ibol, “Tamol ta malan tia yak, mala tia neinta ka dal ikubiai pani wak i? Tia geig. Urarum gubog lo diau dudu wa. ");
INSERT INTO tbc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Talpein a maŋau iŋane dan, iŋsan girek maŋau ta iriŋani na da. Ak man saen maŋau iŋane itout dop maŋau iŋ lo awan isa man, iŋsan girek maŋau igo ilasap imado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Dugo woŋ go metmet samun ta tei malan lo ule gug oŋsigane mala lo ai lapan yen an ta kubiani na yak i? ");
INSERT INTO tbc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","En dugo woŋ tei rupeip ubol, ‘Gane dop metmet samun an mala lo yak ŋupasi yau,’ dugo oŋsigane mala lo ai an nal fidian mi ago yen di? Oŋ bale uraru ama, imug mi sigane mala lo ai lapan an pasi gup, lo abaŋ ka ule uyanan dop, lo tei malan lo metmet samun an pasi yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ai uyan ak iŋ nuŋon ta ifu saian na da. Nek ago mi ai saian ak dam nuŋon ta ifu uyan na da. ");
INSERT INTO tbc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ai fidian nuŋod lo mi taloŋ da. An ai uyan dugo an ai saian ak tabol da. Tamolpein ai gurab nuŋon yuk dudurun anda yak fo ta diŋane na da. Wain nuŋon dam ai saian dudurun anda yak fo ta diŋane na da. ");
INSERT INTO tbc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tamol uyan ak iŋ mel uyan uyan ak tinin ilon lo itumanai an lo kagin uyan uyan ak mi iŋal dop an idirai dilasa wa. Ak man tamol saian ak iŋ mel saiak saiak tinin ilon lo itumanai an lo kagin saian saian ak mi iŋal dop an idirai dilasa wa. Man dugo, kagin saian ak boi, uyan ak boi, tamol ilon iŋanefute yan iŋanep awan lo ibol ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Aŋ ata wo ŋai niŋeg o ‘O Tubun en, O Tubun en’ abol dugug ŋai awag ta abi na di? ");
INSERT INTO tbc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tamol enti ŋaisag na ipalug awag iloŋ go awag kagin ipani dan iŋ fun igo: ");
INSERT INTO tbc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","iŋ nek ibol maŋau tamol ab yabi wo dugo bag san gib kuror mi yabig, pat nam bag fun isue sakar ak igo woŋ a. Agog saen ui tubun ak isi dugo, lom dam idug tim ifureg ab an ifuni bo man, ab an ibili idu san tia ya. Man dugo, ab an pat nam yabi an lo itur sakar a. ");
INSERT INTO tbc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ak man talpein ru e ŋabol den iloŋ gug awag kagin ta ipani na dan, iŋ man nek ibol ŋiŋeo tamol igo ya, iŋanen ab yabi wo dugo gib ta yabi nag, lul fufo mi yabi ak igo woŋ a. Agod saen ui isig lom tubun ak idu dugo tim dam ifureg, ab an ibili idug iratitale yau a. Agod ab an san pitiŋinek man saian geig a.” ");
INSERT INTO tbc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus ru en tamolpein irupidai itout go, imasag, Kaperniam na yau a. ");
INSERT INTO tbc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Atna Rom san yu gurman ta san urat pinein subam saiak ta iŋaneg imat o sumeik a. Urat pinein an niŋen o tubun mi imat da. ");
INSERT INTO tbc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Agog Rom san yu gurman Jesus imado dan iloŋ tag, iŋ Juda matu gurman aenta idinaig diau a. Jesus durupeip ipalup, iŋanen urat pinein ikubunep uyan o ibol. ");
INSERT INTO tbc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ago tag iŋ Jesus san na diaug, maeg nam dumosiaig durupei, “Oŋ mel en gane pani san iŋ idaisuda ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Man dugo, iŋ idsad Juda dar niŋedi wo imat da, agod maŋsama ubou ab dam isuse panama ya.” ");
INSERT INTO tbc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ago tag Jesus awad yabig dida diau a. Diaug ab fun na sumeik dugo Rom yu gurman an turan idinaig, dupalug, iŋ awan aban Jesus durupei, “O Tubun en, tureŋ ifuno umoi. Ŋaisag ab lo ladu san ŋai ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Agod oŋsa na ŋupalu san o dam yaŋag tia ya. Ru mi ubol dop lo ŋaisag urat pinein uyan isusa da wa. ");
INSERT INTO tbc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Man dugo, nek oŋse oŋ ŋai dam tamol aenta waged lo urat ŋigane da, agod ŋaisag yu tamol adi paeg na dumado da. Saen ŋai yu tamol ta ‘wau’ ŋabol tap, iŋ yau a. Tia, tamol ta ‘palu’ ŋabol dop, iŋ ipalu wa. Tia, ŋaisag biabi ŋilaŋal ŋurupeip ‘en gane’ ŋabol dop, iŋ igane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus ru an iloŋ man, irut saian geig a. Agog idaŋsag tamolpein a ŋien aban diri se yan irupidai, “Rumok geig ŋurupaiaŋ da, tamol ilo rumok naok igo yak ta Isrel ilon lo ŋile man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Agog yu gurman iŋanen turan dumul go ab lo diau man, urat pinein an uyan isusag imado dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Murnag Jesus panu ta yaŋan Nein dubol dan te yau a. Iŋsan megeloum, agod tamolpein wei mi mok dam dadi diau a. ");
INSERT INTO tbc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Panu an san dalawan sumeik dupani dugo, tubabun ta disinig dupalu se ya. Tamol imat an iŋ pein suos ta nanun, nek ago kisaek o lian a. Panu an san tamolpein wei mi dam pein suos an dida dupalu se ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Saen Tubun en pein an ile man, ilon tubun mi imuŋani tag irupei, “Tata umoi.” ");
INSERT INTO tbc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ago dugo Jesus yaug, kapal tubabun anda yan yabi man, tamol kapal disini an dupartuanig dutur. Agog Jesus tubabun an irupei, “Pinein en, ŋai ŋurupaio da, oŋ masa!” ");
INSERT INTO tbc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Agog tamol imat an fon kumaen imasag fun iganeg iŋiŋeŋ se ya. Jesus pinein an iŋaneg tinan ipani a. ");
INSERT INTO tbc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Agog tamolpein fidian tubun mi durut go, Anut yaŋan diabisag, dubol, “Profet tubun ak ta id luluŋad lo ilasa ya.” Iŋ dubol, “Anut iŋanen tamolpein yil o ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kulob e Jesus igane yen san ru Judea ilon lo ifurak go, aben an sad panu panu lo yaug fidian duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon san megeloum kulob fidian Jesus igane se yan dile tag, Jon san na diaug durupeig iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ago man Jon megeloum nuŋod urarum igiaig irupidai, “Aup, Tubun en igo asumiani wa. Tamol a ipalu san niŋen o maŋ malama migane dan, oŋ tamol nek amaiak i? Tia, maŋ tamol sen ta ipalu san niŋen o mala nouk mumado wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ru sinek tamol an Jesus san na dilasag Jon wagen lo ago dubol dusumiani, “Tamol a ipalu san niŋen o maŋ mala nouk mumado dan, oŋ tamol nek amaiak i? Tia, maŋ tamol sen ak ipalu san niŋen o mala nouk mumado wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Saen nek an lo, Jesus subam adi wei mi ikubuniai dugo, a ur saian ad da yak ur saian ikudai diau dugo, a malad itapul ak idiraig fon abaŋ dile se ya. Ago dugo ru sinek tamol adi kulob an fidian dile se ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Agog Jesus ru naon irupidai, “Amul aup mel dugo ale dugo, ru aloŋ na yan dam Jon arupeip iloŋ a: malad itau ak afon abaŋ dile dugo, ŋied saian ak afon tureŋ diabi dugo, a tinid lepra amad da yan tinid siŋaokan dilasa ya. Kududod itau ak afon ru duloŋ dugo, a dumat ak kumaen dumasag dumado dugo, agod tamolpein mel amad tia yak bilaluŋ uyanan ak ŋufulale pidinai dugo duloŋ da. ");
INSERT INTO tbc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Agod talpein a ŋai o ilon ta saian na yan, iŋ Anut san bar iŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon san megeloum dumul diau dugug, Jesus Jon niŋen o tamolpein irupidai o fun iganeg igo ibol, “Saen aŋ aben kawan talpein tia yak ate au an, aŋ ata mel mok ale wo au ak i? Nag aŋ tim ifurep war iwi yau imul dop ale wo au boi ak i? ");
INSERT INTO tbc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tia tap, ata wo au ak i? Nag aŋ tamol ta tinin kulos naon lak na geig ak idiri amaiak ale wo au ak i? Tia, tamol a biouŋ naok ago yak didiri duman, iŋ kiŋ sad ab lo mi dumado da. ");
INSERT INTO tbc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ak niŋen o ata mel mok ale wo au ak i? Nag profet ale wo boi i? Awo, ŋai nek amaiak niŋen o ŋurupaiaŋ da, profet en man rumok iŋ profet a, ak gug iŋ urat subaŋan taidam da imado da, ");
INSERT INTO tbc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","tamol nek emaiak niŋen o girek e Anut san ru lo digire idug yen den, igo ibol, ‘Ule, ŋaisag ru sinek tamol ŋidinip, oŋ nao na imug pe yau a. An lo oŋsa dal ikubune wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ŋai rumok ŋurupaiaŋ da, tamol a pein tiŋaed lo dilasa yan luluŋad lo tamol ta kisaek Jon Suguek san iriŋani man tia ya. Ago bo man, tamol ta Anut san kagin panek aben ilon lo yaŋan tiag, aenta fidian paed na imado dan, iŋ Jon Suguek san iriŋani geig a.” ");
INSERT INTO tbc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Saen tamolpein kawan ak fidian, agod takis ŋilaŋal tamol dam, ru a Jesus ibol an duloŋ man, Anut san dal an mi dal rumok ak niŋen o awok dupani a. Man dugo, tamolpein nek an Jon san suguek diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gug Farisi iŋ kubiaeŋ san girek maŋau dadi, dal uyan a Anut ikubiai pidinai an diabiani a. An niŋen o suguek an ta diŋane na ya.) ");
INSERT INTO tbc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Agog Jesus fon ibol, “Saen en san tamolpein iŋ naok dugo woŋ ak i? ");
INSERT INTO tbc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iŋ nek ibol nanuk kititik dadeŋ aben na dumasig dumado dugo nanuk aenta igo dubol digiai da, ‘Maŋ aŋ atari wo dum muwi se ya, ak man aŋ ta atari na ya. Agod mateŋ saen an san bar mabi se ya, gug aŋ ilom saian dugo atata man amoi a.’ ");
INSERT INTO tbc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Man dugo, Jon ipalug anaŋ tubun ak ta yani na dugo, you sakar ak dam ta iluk na ya, an niŋen o ago dubol, ‘iŋ ur saiak aman da ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ago dugo Tamol Nanun dam ipalug anaŋ tubun ak yani dugo you sakar ak dam iluk da, an niŋen o ago dubol, ‘Ale wo, tamol en tuŋalek tamol, agod lukluk san tamol. Ago dugo iŋ mi takis ŋilaŋal, agod aupasek adi dam sad turadi!’ ");
INSERT INTO tbc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ak man, kankan a milaen mok amaiak, iŋanen kagin naok naok an lo mi tamolpein malad lo man itaot geig an ikubiai pidinai a.” ");
INSERT INTO tbc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi ta yaŋan Saimon dubol dan Jesus ida anaŋ diani wo iwagi tag iŋsan ab lo yaug, anaŋ diani wo dumasi a. ");
INSERT INTO tbc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Panu an san aupasek pein ta Jesus Farisi dida dumado dan iloŋ tag gureŋ, butol ta pat siŋaokan ak nam digane yak, isinig san na ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pein an ab lo iladug, Jesus patun fo itur go itata dugo, malan turon Jesus ŋien fo idu se yan, gurman roun nam ŋien isasi se ya. Ŋien dam musuk ipanig, gureŋ fo ikulmaek a. ");
INSERT INTO tbc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Agog Farisi tamol an ile dugo, ilon lo mi ibol, “Tamol en profet ak tap man pein en fun iloŋ a. Pein en aupasek tinan.” ");
INSERT INTO tbc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ago dugo Jesus Farisi an irupeig ibol, “Saimon, ŋai ru ta ŋurupaio wo da.” Ago tag Saimon awan yabig ibol, “Girek maŋau, ubol pe.” ");
INSERT INTO tbc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Agog Jesus ibol, “Tamol uraru moni tamol ta san na gubun digane ya. Ta san gubun tinin lo yen dan man 100 kina. Ago dugo ta san gubun 10 kina. ");
INSERT INTO tbc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Murnag moni tamol an iŋsad gubun dupani wo irupidai a, gug uraru an sad gubun dusupasi san ta idaisuda na ya. An niŋen o ilon imuŋanaig sad gubun an ikubuneg itout a. Oŋ dugo ilo isou di? Tamol dugon, moni tamol an niŋen o, nen tubun mi imat ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ru naon irupei, “Ŋai ŋabol, enti a iŋsan muruan nen tubun an, nek ama ya.” Agog Jesus irupei, “Oŋane kubianek an itaot a.” ");
INSERT INTO tbc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Agog Jesus idaŋsag, naon pein an ipanig Saimon irupei, “Dugo, oŋ kulob e pein en igane yen ule yak i? Ŋai oŋsa ab lo ŋiladu gug oŋ you ta panag go lo ŋieg ŋufulani man tia ya. Gug iŋ malan turon nam ŋieg ifulani dugo, gurman roun nam isasi panag a. ");
INSERT INTO tbc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Oŋ musuk ta panag man tia ya, ak gug pein en saen ŋai ŋiladu yan fun iganeg ipalug ŋieg musuk ipani se ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oŋ ŋai gurmag fo gureŋ ta kulmaek na ya. Gug pein en ŋai ŋieg fo gureŋ mumalun uyanan ak ikulmaek idu ya. ");
INSERT INTO tbc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ago yan niŋen o ŋai ŋurupaio da. Pein en san aupasek wei mi bo man, ŋai aupasek an fidian ŋusuas pani la ya, man dugo, ŋai niŋeg o tubun mi imat da. Ak man tamol ta iŋsan aupasek wei an tia ŋusuas pani tap, iŋsan ilo uyan man ŋai o dam tusan mi a.” ");
INSERT INTO tbc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Agog Jesus pein en irupei, “Oŋane aupasek fidian ŋusuas pano ya.” ");
INSERT INTO tbc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tamol aenta anaŋ diani wo dumasi an iŋsed nug durupeig dubol, “En dugo, tamol en iŋ mi ibol go, sen ilon nam aupasek ka ipare idu wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gug Jesus pein an irupei, “Oŋane ilo rumok patu ipasi a. Oŋ maror lo mi wau.” ");
INSERT INTO tbc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Murnag Jesus panu panu lo, agod taun tubun ak lo Anut san kagin panek san ru ibol ilasa dugo itor se ya. Iŋsan megeloum 12 an dam dida tureŋ diabi se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ago dugo pein aenta, inug subam ad da yak, ur saian tinid lo ipasi an dam ŋien fo dida diau se ya. Luluŋad lo Magdala pein ta yaŋan Maria. (Inug tinin lo Jesus ur saian 7 ikudai a.) ");
INSERT INTO tbc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ta man Joana, Kusa iwon. Kusa man King Herod san ab titianek tamol. Ta man Susana. Iŋ pein aenta wei mi dam Jesus, iŋsan megeloum dida iŋsiganed melmel lo dibinawai dugo dutor se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Panu panu tamolpein Jesus san na dupalug, dutumani dugo Jesus ru faŋan en irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Saen ta lo tamol ta ai patun isinig abi lo ipae o yau a. Iŋ yaug siŋanen abi lo man ai patun banin igane anuag tan fufo iratitaleg idu se ya. Saen iratitale man, ai patun aenta dal fufo dudug tamolpein dupalug dupartitale dugo, anakanak dam dupalug diani itout a. ");
INSERT INTO tbc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Agog ai patun aenta tan sagargar anda yak fufo idu ya. Saen ai patun an balud isa yak man, ririan dubun a, man dugo, tan an you an tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ai patun aenta ud saiak luluŋad lo dudu ya, agog sisem disa diau dugo ud saian an ai uyan ak yafutanai an lo dumat a. ");
INSERT INTO tbc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gug ai patun aenta tan uyan ak lo dudu yan disa uyan go tet mi nuŋod ifu uyan a, sad sutek 100 igo ya.” Agog Jesus ru an ibol itout man, iwagiŋ go igo ibol, “Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Saen Jesus san megeloum ru en fun niŋen o dusumiani man, ");
INSERT INTO tbc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","igo ibol irupidai, “Anut iŋsan kagin panek aben san melmel imianuk an san maŋau ipanaŋ a. Ak man tamolpein aenta ru faŋan fun tia yak mi duloŋ da. An lo man, ‘Iŋ leil digane bo man, ilod ta itarpasi na da. Agod kududod nam duloŋ bo man, fun mok ta diŋane na da.’” ");
INSERT INTO tbc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ru faŋan en san fun igo ya: anaŋ kubulan man Anut san ru. ");
INSERT INTO tbc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Anaŋ kubulan dal te idu yan man nek ibol tamol ru duloŋ gug Satan ru bubed lo ipasi dak igo woŋ a. Ago dop ŋai o ilod lo ta rumok na dop lo Anut patud ipasi san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Anaŋ kubulan tan sagargar anda yak fo idu yan man nek ibol tamol ru duloŋ dugo yousai lo ru an diŋaneg ilod lo rumok a. Ak man tamol amaiak nek ibol ai dabid dabai an tia yak igo woŋ, saen katukan mi ilod lo rumok a. Man dugo, kubianek ipalu san saen lo iŋaned ilo rumok dibisei kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Anaŋ kubulan ud saian ak ilon lo dudu yan man nek ibol tamolpein ru rumok an duloŋ pe ilod lo rumok kisaek oŋ dak igo ya. Ak man iŋ tan en san madok niŋen o ilo sou gidigidad mi digane da, agod iŋ melmel wei mi amad da wo dumat da, an lo iŋsad kagin uraru an Anut san ru iŋ lo yan ituani da. Amaiak niŋen o nuŋod ta ifu na da. ");
INSERT INTO tbc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Agod anaŋ kubulan tan uyan ak lo idu yan man nek ibol tamol ru duloŋ dugo, iŋ tamol mok san kagin lo ru an diabi dabaig, kagin dupani yaug, gidad saen muruan dile bo man sad kagin an nuŋon ifu da.” ");
INSERT INTO tbc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Tamol ta iŋ lam isulanip, bod boi, tia, sareg boi paen na ta igane na da. Tia, iŋ pempem lak na isuŋanip, tamolpein a diladu dan ka dile wa. ");
INSERT INTO tbc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nek ago mi en ata mel imianuk yen dan murnap kuai isi wa. Agod mel a tamolpein naod na dimianig yen dan, kuai te ilasap id fidian tile wa. ");
INSERT INTO tbc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ago yak niŋen o ru e aŋ aloŋ den kagin apani wa. Ata wo? Talpein enti iŋ mel ta da yan, Anut subuŋan taidam ipani wa. Ak man, enti iŋ tinin lo mel ta tia ya, ak gug gidad iŋ mel anda yak ibol da, ago bo man Anut iŋsan melmel an fidian banin lo ipasi yaup itout a.” ");
INSERT INTO tbc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus tein muroun iŋ tinad da dile wo diau a. Ak man tamolpein wei kasik go dile san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ago dugo tamol ta ipalug Jesus irupei, “Oŋ tina iŋ tei murou dida dilio wo dupalu yak ab patun fo dutur da.” ");
INSERT INTO tbc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Agog Jesus awan yabig ibol, “Tamolpein a Anut san ru duloŋ go kagin dupani dan, iŋ ŋai tinag di ŋai teig a.” ");
INSERT INTO tbc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nal ta Jesus iŋsan megeloum dida you saltek ak lo wog fo disida wo dugo irupidai, “Id gamu you aen ate tau a.” Agog wog dusoug diau a. ");
INSERT INTO tbc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Agog diyawai dugo dal na Jesus malan iyof go yen a. Agog tim tubun nuŋon ifureg, wog ilon lo you idug, isarir idu wo sumeik dugo, ");
INSERT INTO tbc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","megeloum Jesus san na diaug dufufunig durupei, “Tubun en, id tadeg tau o sumeik da.” Agog Jesus imasag, tim tamun da ipidai, “Atokabol.” Agog gamu nam malin ibalsi a. ");
INSERT INTO tbc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ago dugo Jesus megeloum ipidai, “Aŋanem ilo rumok dugo i?” Iŋ direr dugo durut saian man sed nug durupei, “Enso tamol ta, tim tamun da awan duloŋ go dutokubol ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Murnag diyawai go you awan aen ate Gerasin sad tan lo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus wog ibiseig idu yan, tamol ta panu an san ipalu ya, iŋ ur saian anda ya. Saen milaen mok tamol an kulos ta idiri na ya. Agog panu na dam ta imado se na ya. Tia, iŋ tamol disiriai ak sad mutou fom imado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Saen iŋ Jesus ile yan awan tubun mi isasaig Jesus ŋien fun na yau idug ibol, “Jesus, Anut lak na yak nanun, oŋ mel ta ŋai lo i? Ŋai oŋ o ŋamosiai da, madai tubun ak panag umoi!” ");
INSERT INTO tbc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesus gubak mi ur saiak tinin lo ilasa wo ru dabai nam irupei a, an niŋen o ur saiak an ago ibol a. (Saen wei kasik ur saian an yabig tinin itirni se ya. An lo sein nam, agod kam dabai geig nam ŋien banin dusubanig imado dugo, titianek tamol dam tawaŋ dutur se ya. Ak man saen fidian sein kam dam iburti idug isol go ur saiak ilon ibol dak lo tan yoitout ate yau na ya.) ");
INSERT INTO tbc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aria, Jesus tamol an isumiani, “Oŋ yaŋa enti?” Agog irupei, “Ŋai yaŋag Wei Kasik” Man dugo, gubak mi ur saiak wei mi tinin ilon lo diladug dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Agog ur saian adi saen wei mi Jesus dugudanig dubol, “Oŋ diramap gib kuror fun tia ak lo madu wo ago rupaiama umoi.” ");
INSERT INTO tbc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aria, ante man bor malan tubun ak wei mi bubun an giraŋen na dupaŋ di dutor se ya. Ago dugo ur saian adi an bor tinid lo diladu wo Jesus dugudani se ya. Ago man Jesus awok ibol go diau a. ");
INSERT INTO tbc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Agog ur saian adi tamol an dibiseig, bor tinid lo diladu ya. Agog bor malan tubun an fidian mi ilod imasa saian go dumaspalu dudug, damab aen te dusokalik man, you awad lo yaug dumat a. ");
INSERT INTO tbc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bor an sad titianek tamol abaŋ ago dile tag disol go diaug panu tubun ak lo, panu kitiktik lo tamolpein an fidian durupidai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tamolpein ru duloŋ go, iŋ dam abaŋ dile wo diau a. Dupalug, Jesus ŋien fun na tamol imug ur saian anda yan imasig, kulos idirig imado dugo dile ya. Iŋ itokubol go, kankan fidian uyan ak lo mi imado dugo dileg, durut saian a. ");
INSERT INTO tbc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aenta malad nam abaŋ dile yan, tamolpein naod na Jesus tamol an dugo woŋ ikubune yan dubol se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Agog Gerasin tamolpein tubun mi direr tag Jesus imul yau wo dusumiani a. Ago tag Jesus wog lo isudag imul yau o da. ");
INSERT INTO tbc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tamol a tinin lo ur saian ikudai an, Jesus ida diau o dabai igane yak man Jesus geg iganeg ibol, ");
INSERT INTO tbc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Umul waup, oŋsigane panu na, Anut ikubunio an niŋen o ru ubol dop duloŋ a.” Agog tamol an imul yaug, panu ilon lo Jesus iŋ ikubune yak san ru ibol dugo duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Saen Jesus imul man, tamolpein malan tubun you aen ate malan digane yan duyuŋani a. ");
INSERT INTO tbc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ago dugo tamol ta yaŋan Jairas ipalu ya. Iŋ ubou ab san gurman ta. Iŋ nanun pein kisaek o lian, san anaŋar 12 an imat o sumeik ak niŋen o, iŋ Jesus ŋien fun na yau idug, ida iŋsan ab lo diau wo isumiani a. ");
INSERT INTO tbc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jesus yau dugo tamolpein dupalug dubuluwi nuŋon. ");
INSERT INTO tbc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Luluŋad lo pein ta anaŋar 12 siganen dar tinin ilon lo yak ilasa se ya. Iŋsan moni samukan fidian dokta tinid lo ibisei gug ta kisaek pein en ikubuneg uyan man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Doup luluŋad lo mi Jesus patun fo ipalug san kulos bitiŋen te isupuri a. Agog gamu nam dar an igos a. ");
INSERT INTO tbc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ago tag Jesus isumianaig ibol, “Enti ŋai isupurag ak i?” Fidian tia dubol go Pita ibol, “Tubun en, tamolpein wei kasik dubuluwo dugo tinid nam oŋ dupuno da!” ");
INSERT INTO tbc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ak man Jesus ibol, “Talpein ta isupurag a, man dugo, ŋaineg dabai aenta ibisawag dugo ŋai tinig lo ŋukubiani a.” ");
INSERT INTO tbc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pein an kuai tem iloŋ go, imunamuk pe imado san tia ya. Agog tubun mi isuruwor dugo, ipalug Jesus ŋien fun na isaluwi idug, tamolpein malad lo fun dugog Jesus isupurig, iŋsan subam an itout an ibol a. ");
INSERT INTO tbc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Agog Jesus irupei, “O nanug pein, oŋsigane ilo rumok ŋai lo yan ikubunio ya. Maror lo wau.” ");
INSERT INTO tbc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus ago ibol dugo, tamol ta Jairas san ab lo yak ipalug, Jairas igo irupei, “Oŋ nanu pein imat la ya. Gidad oŋ girek maŋau muruan taidam ta pani na wa. Ak niŋen o ulefuni dop yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus ago iloŋ tag Jairas irupei, “Urut umoi. Ilo lo rumok dop, nanu pein fon kumaen ilasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Saen ab lo ilasa yan Jesus tamolpein aenta ab lo diladu man imoi. Iŋ Pita, Jon, Jems agod nanuk tinan taman mi dida diladu ya. ");
INSERT INTO tbc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tamolpein fidian ab lo yan nanuk niŋen o ilod saian dugo tinaŋ aru digane se ya. Agog Jesus irupidai, “Atata amoi. Nanuk en ta imat pasi na ya. Iŋ ŋioŋ yabi da.” ");
INSERT INTO tbc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ago ibol dugo disel go awan kukokan digane se ya. Man dugo, iŋ duloŋ, nanuk an imat mok a. ");
INSERT INTO tbc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gug Jesus nanuk banin te yabig ibol, “O nanug, masa!” ");
INSERT INTO tbc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Agog nanuk anen kumaen san ur imul ipalug fon kumaen imasa kisaek oŋ a. Agog Jesus ibol dugo anaŋ dupani a. ");
INSERT INTO tbc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nanuk tinan taman kulob ago dileg, durut saian geig a. Ak man Jesus kudod yabig ibol, “Kulob ale yan tamolpein aenta naod na ta mok abol na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus iŋsan megeloum 12 an itumanaig, ur saian dukudai dop subam dukubiniai san dabai ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Agog idinaig diaup, Anut san kagin panek niŋen o dubol ilasa dop subam adi dukubiniai o ibol a. ");
INSERT INTO tbc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ago dugo Jesus irupidai, “Aŋ tureŋ an lo, makud, badam, ŋioŋ san biouŋ, anaŋ, agod moni ta mok asini na wa. Siot subuŋan dam ta asini na wa. ");
INSERT INTO tbc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ab dugon lo digiaŋ tap, nek ante mi amado nap panu an abisei a. ");
INSERT INTO tbc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Panu ta lo tamolpein aŋ o ta dumat na tap, panu an abisei wo dop, ŋiem san gufgaf apilti pidinai a. Agop lo duloŋ ak, iŋ Anut san kagin panek dumoi a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Agog megeloum diaug, panu panu bilaluŋ uyan ak dubol ilasa dugo, subam adi dam dukubiniai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod Galili provins san gurman tubun an melmel fidian ilasa na yan iloŋ go ilon weiwei geig a. Man dugo, tamolpein aenta dubol, “Jon suguek san iŋ fon kumaen imasa da ya.” ");
INSERT INTO tbc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aenta dubol, “Elaija boi, tia, profet wagam san ta fon kumaen imasa boi.” ");
INSERT INTO tbc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ago gug Herod ibol, “Ŋai Jon buron ŋitarti a. Ak gug tamol e melmel emaiak iganeg ru an ŋaloŋ den, iŋ enti?” Ago dugo iŋ Jesus ile wo yaes tubun mi ifuni se ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iŋanen megeloum dumul dupalug Jesus naon na melmel fidian digane yan dubol idu ya. Agog megeloum an iŋal go pasak nam panu ta yaŋan Betsaida dubol dan ate diau a. ");
INSERT INTO tbc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ak man tamolpein malan tubun mi Jesus dugo yau wo igane dan duloŋ tag, ŋien aban duri se ya. Ago tag igiaig dupalug, Anut san kagin panek ru ifulale pidinai dugo, aenta subam ad da yan ikubuniai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gurai idu dugo megeloum 12 Jesus san na diaug, durupei, “Oŋ tamolpein dinaip, panu susumeik an lo, gidigidad diaup, sed niŋedi wo anaŋ o, ŋioŋ aben o abaŋ dile wa. Man dugo, aben en yoitout a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ak man Jesus ru naon irupidai, “Aŋsem ka afutuwai a.” Ago tag durupei, “Maŋ anaŋ tia ya. En iy uraru, agod bret kafen mi dien da. Dugo, maŋ maup, doup tubun en niŋedi wo anaŋ taida madad o?” ");
INSERT INTO tbc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Doup tubun dumado yan tamol kitek faiv tausen igo woŋ a.) Agog Jesus megeloum irupidai, “Tamolpein arupidaip, nuŋod fifti malan kisaek kisaek lo mi dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Agog megeloum adi Jesus ibol ago diganeg, tamolpein durupidai dugo dumasi a. ");
INSERT INTO tbc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Agog Jesus iy uraru, bret kafen an iŋaneg, malan lak na isudag, Anut ilo uyan ipani gug bret yafuteg, megeloum ipidinaig duwae se ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tamolpein fidian bret iy da dianig, luad ipuk go megeloum anaŋ wadan dutumanig sareg 12 digane anuai a. ");
INSERT INTO tbc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nal ta Jesus sen kisaek igudanig imado dugo, iŋanen megeloum dam susumeik dumado dugo isumianai, “Tamolpein ŋai o enti dubol dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Agog ru naon durupeig dubol, “Aenta oŋ suguek tamol Jon dubol da. Aenta dubol, oŋ Elaija boi, tia, profet aenta wagam mi dumat na yan ta fon kumaen imasa ago dubol da.” ");
INSERT INTO tbc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ago dugo megeloum isumianai, “Gug aŋsem mi ŋai enti mok abol di?” Agog Pita ru naon igo irupei, “Oŋ Anut anen Kristus.” ");
INSERT INTO tbc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Agog Jesus megeloum kududod yabig, ru dabai nam irupidaig ibol, “Tamolpein gidigidad naod na ru an ta abol na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ru awan ibateg ibol, “Tamol Nanun muruan tubun ak wei mi ile wa. Pris gurman adi, Isrel matu gurman dida, agod kubiaeŋ san girek maŋau dam patud dupanip dile saian a. Agop dufuni imat a. Nal utol gib lo yen gup, fon kumaen imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Agog fidian irupidai, “Ta iŋ ŋai iganurag o tap, iŋsiganen ilo ibol patun ipanip, dal fidian lo siganen aigim isinip, ŋieg aban iri wa. ");
INSERT INTO tbc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta iŋsinan tinin mi kagin ipani dan, ideg yau a. Gug ta ŋai niŋeg o siganen madok tan en lo yan ibisei dan, patu pasek iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Talpein ta tan en san madok lo malan imug dop, an lo tan en san filian fidian an san muroun ilasa wak gug, ŋutun ideg yau, tia, daoŋ iŋane tap, an dugo woŋ, sen niŋen o nuŋon uyan ak igane ilasa wak i? Man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tamol Nanun iŋsan lilaman lo, Bai san lilaman lo, eŋel gun adi sad lilaman lo ipalu wa. Ta iŋ ŋaisag ru yaŋag da o miai ifuni tap, saen Tamol Nanun imul dop, iŋ dam tamol an niŋen o miai ifuni wa. ");
INSERT INTO tbc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ŋai rumok ŋurupaiaŋ da. Gamu aŋ aenta e atur den gamugo amat dop, Anut san kagin panek ale wa.” ");
INSERT INTO tbc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesus ru an ibol go nal 8 yau dugo Pita, Jon, Jems ago iŋal go did fo igudani wo dusuda ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesus igudani dugo naon ibilisag, iŋsan kulos dam ibilisag milkouk kasik. ");
INSERT INTO tbc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ago dugo tamol uraru girager amad da dilasa ya. Tamol uraru an man Moses iŋ Elaija da ya. Jesus mitep mateŋ a Anut ilon yen dan lo Jerusalem na ile wan niŋen o, Moses iŋ Elaija da Jesus dida diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita turan muroun dida malad muruan se ya, ak gug malad ipuk go dumado dugo Jesus girager anda dile ya. Agod tamol uraru dam dutur dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses iŋ Elaija da fun diganeg diau dugo, Pita kankan an tia igo ibol, “Tubun en, uyanan geig a. Maŋ lalai utol mabi wa. Oŋane kisaek. Elaija an kisaek. Agod Moses an kisaek.” ");
INSERT INTO tbc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ago ibol dugo timtaen ipalug, yafutanai dugo megeloum utol an direr saian mok a. ");
INSERT INTO tbc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Agog awan ta timtaen lo iwagiŋ go ibol, “En ŋaineg nanug, ŋaineg Pilianek Tamol. Awan aloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Saen awan itau man Jesus sen kisaek itur dugo dile ya. Saen an megeloum abaŋ ago dile yan tamolpein naod na ta dubol na ya. Tia, iŋsed ilod lo mi dutueg yen a. ");
INSERT INTO tbc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Murnag did dibiseig dudu dugo, tamolpein malan tubun ak ante dumado yan Jesus dile dugo san na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Doup an luluŋad lo tamol ta iwagiŋ go ibol, “Girek maŋau, ŋaineg nanug e ule den niŋen o ilo isou. Ŋai nanug en igo kisaek o lian a. ");
INSERT INTO tbc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ur saian ta pempem yabi dop isasai da. Iganep bururau ifuni dop subulbal awan lo ilasa da. Nek ago mi pempem madai ipani dugo, daoŋ dam ipani da. ");
INSERT INTO tbc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Oŋsa megeloum ur saian an dukudi wo ŋusumianai gug iŋ digane san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus ru naon irupeig ibol, “O aŋ saen en san tamolpein, aŋ ilo rumok amam tia ya, agod aŋ ilom gidigidad amado da. Nal sapta ŋai aŋ da tumado wak i? Nal sapta muruan a apanag oŋ dan ŋisini wak i? Nanuk an igo aŋane apalu.” ");
INSERT INTO tbc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nanuk ipalu dugo ur saian an nanuk itarfuni ibili idug, idududuruk dugo yen se ya. Gug Jesus ur saian an naon ifute ipeig pinein an ikubune ya. Agog pinein an iŋaneg taman ipani a. ");
INSERT INTO tbc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tamolpein fidian Anut san dabai an dileg, durut saian a. Saen tamolpein an Jesus kulob fidian e igane yen niŋen o ilod weiwei man, Jesus iŋsan megeloum igo irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ru en aloŋ dop ilom isou uyanan. Tamol Nanun ager adi banid lo digane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ak man megeloum ru an fun ta duloŋ na ya. Anut ru an fun mok imiani a, agod duloŋ san tia ya. Taida mi, megeloum adi Jesus ŋiŋeŋ en isafulale pidinai o dusumiani san man direr a. ");
INSERT INTO tbc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Megeloum iŋsed mi nug dupeig dubol, “Id luluŋad lo enti malan te yak i?” ");
INSERT INTO tbc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus iŋsad kankan iloŋ go nanuk nanun ta iŋaneg giraŋen na igunig ");
INSERT INTO tbc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","megeloum irupidai, “Talpein enti ŋai yaŋag lo nanuk igo yan iŋane wo iyuŋani tap, ŋai dam iŋiliag o iyuŋanag da. Agod talpein a ŋai iŋiliag dan, Enti a ŋai idinag go ŋupalu yan dam iŋane da. Man dugo, talpein a aŋ luluŋam lo sen yabi idup murna geig an, iŋ mi malan te ya.” ");
INSERT INTO tbc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Jesus irupei, “Tubun en, maŋ tamol ta oŋ yaŋa lo ur saian ikudai dugo mile ya. Tamol an maŋsama tia ya, an niŋen o imoi o murupei a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Agog Jesus irupei, “Ago igane dop apadau amoi. Man dugo, ta aŋsam ager tia yan iŋ idsad urat kisaek a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus Anut san panu lo yau san saen sumeik dugo, iŋ naon Jerusalem na ipanig tureŋ yabi se ya. Iŋ ru sinek tamol aenta idinaig dumug go ");
INSERT INTO tbc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sameria na panu ta lo dumado san aben dukubune dop ipalu wo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Panu ta lo diladu yak gug, tamolpein panu an san diŋiliai o dumoi. Man dugo, tamolpein duloŋ ak, Jesus Jerusalem na yau da. ");
INSERT INTO tbc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Saen Jems iŋ Jon da abaŋ ago dile tag Jesus durupei, “Tubun en, ubol tap, mabol dop keit lo yai idup, panu en imarip inani yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ak man Jesus idaŋsag ru dabai nam ipidai a. ");
INSERT INTO tbc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ago tag panu sen ta lo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dal na diau dugo, tamol ta Jesus irupei, “Oŋ dugo wau dan ŋai dam ante tau a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ago tag Jesus ru naon irupei, “Goun kasik iŋ gib ad da ya. Anakanak iŋ wur ad da ya. Gug Tamol Nanun man, iŋ kabuŋan igansip yaes ibal san aben tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Agog Jesus tamol sen ak ta irupei, “Ŋieg aban uri.” Gug tamol an ibol, “Tubun en, umoi dop ŋaup, tamag ŋisare gup.” ");
INSERT INTO tbc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ago tag Jesus ru naon irupeig ibol, “Tamolpein a iŋsed ŋutudi lo dumat la yan bisawai dop, iŋsiganed tubabun an ka disiriai idu wa. Oŋ waup, Anut san kagin panek niŋen tamolpein naod na ubol ilasa dop duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Agog tamol taidam irupei, “Tubun en, ŋai dam ŋie aban ŋiri wa. Ak man umoi dop, ŋaup, tinag tamag teig taog banid ŋabi gup.” ");
INSERT INTO tbc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ago tag Jesus tamol an irupei, “Tamol ta urat igane dugo pempem patun na idaŋsa idaŋla woŋ dan, iŋ Anut san kagin panek san urat igane san ta idaisuda na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Murnag Jesus urat tamol 72, panu panu lo diau o nuŋod uraru uraru ipilianaig, dumug diau se ya. ");
INSERT INTO tbc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iŋ gamugo tureŋ diabi dugo, ru kagin igo ibol irupidai, “Anaŋ nuŋon tubun mok ifu a. Gug urat tamol wei an tia ya. Ak niŋen o abi taman aguduani dop urat tamol taidam idinaip aŋ da aup, anaŋ nuŋon atumani wa. ");
INSERT INTO tbc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ago yak niŋen o au. Gamu ŋidinaŋ den man nek ibol sipsip nanudi goun kasik ak luluŋad lo diau dak igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Moni, badam, sendal ta asini na wa. Saen dal ari dan lo, enti ta naom na ilasa dop aŋ pasak ta agane na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ab ta ilon lo aladu wo dop, abol, ‘Maror am da amado.’ ");
INSERT INTO tbc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamol maror san ak imado tap, aŋanem maror iŋ lo yen a. Tia tap, aŋanem maror imul pe muroum sam na ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ab dugon lo aladu dan, nek ante mi amado wa. Anaŋ you dupanaŋ dop ani aluk a. Man ata wo, urat tamol man iŋaned naon diŋane san idaisuda ya. Ab sensen lo ta au na wa. ");
INSERT INTO tbc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Agod panu ta ilo uyan lo mi diŋiliaŋ tap, anaŋ digane panaŋ dan ani wa. ");
INSERT INTO tbc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Iŋsad subam adi akubuniai dop, panu an san tamolpein dam arupidai, ‘Anut san kagin panek sumeik ipanaŋ la ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gug panu ta ate alasap, iŋ aŋ lo uyan tia tap, panu titiŋaem mi alasap, abol, ");
INSERT INTO tbc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Aŋanem panu san gufgaf ŋiema fo isuda yen, gamu muroum sam na mipitili idu da. Aloŋ ak, Anut san kagin panek sumeik ipanaŋ la yak man aŋ amoi da.’ ");
INSERT INTO tbc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ŋai ŋurupaiaŋ da, murnap nal wadan lo dop, rumok, Sodom adi fon mi muruan tubun mi dile wa. Gug muruan a panu an san tamolpein murnap dile wan, Sodom sad muruan an iriŋani geig a.” ");
INSERT INTO tbc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O Korasin san tamolpein, muruan tubun geig ale wa; O Betsaida san tamolpein, aŋ dam muruan tubun geig ale wa. Man dugo, kulob girager a ŋai aŋ luluŋam lo ŋigane dan, wagam Tair iŋ Saidon da luluŋad lo ŋigane tap, taun an san tamolpein wagam mi ilod ibilisa wa. Ago dop muguŋ san kulos didirip, yai san utut fo dumasip dumado wa. ");
INSERT INTO tbc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ago man saen Anut san bitinaek san nal ipalu wan lo, aŋsam aupasek naon Anut ipanaŋ an senamo geig a. Muruan an Tair iŋ Saidon da sad muruan an iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Agod aŋ Kaperniam tamolpein, sem yaŋam abisap keit lo isuda wak i? Tia mok, Anut iŋsen iŋiliaŋ pe au adup tan ilon lo aben yaŋan Ades dubol dan lo idiraŋ pe amado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Agog Jesus iŋsan urat tamol 72 fon irupidai, “Ta aŋ awam iloŋ dan, ŋai dam awag iloŋ da. Go ta aŋ imoi dan, ŋai dam imoi a. Go ta ŋai imoi dan, Enti a ŋai idinag go ŋupalu yan dam imoi a.” Agog diau a. ");
INSERT INTO tbc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Murnag tamol 72 an Jesus san na dumul dupalug, uyad isusag dubol, “Tubun en. Nek ur saiak saiak oŋ yaŋa mupate dan lo awama paen na dumado dugo awama diabi da!” ");
INSERT INTO tbc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Agog Jesus ru naon irupidai, “Ŋai gubak mi Satan ŋile dugo, nek ibol lak na weil irafule yak igo woŋ, keit ibiseig idu ya. ");
INSERT INTO tbc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aloŋ, ŋai aŋ dabai ŋupanaŋ la ya. Ak niŋen o aŋ mot, lualiu da ka aparfufarai a. Aŋanem ager Satan san dabai fidian aŋ ka abi idu wa, agod mel ta malam isue san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gug aŋ ur saian saian awam diabi dan niŋen o ta uyam isusa na wa. Tia. Anut aŋanem yaŋam kumaen panu na igireg yen dan mi niŋen o uyam isusa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saen an lo Jesus Urgun lo ilon imasag yousai tubun geig ak lo Anut irupei, “O Bai, tan keit da sad Tubun a, ŋai ilo uyan ru ŋupano da. Man dugo, mel en fidian tamolpein a kankan ad milaen an, agod a duloŋ dubol dan dam, minami pidinai a. Ak man oŋ mel an fidian tamol a yaŋad tia yan kubiai pidinai a. O Bai, awo, ago gane san an oŋane ilo, an niŋen o ŋai youg isa dugo ilo uyan ŋupano da.” ");
INSERT INTO tbc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ŋai Tamag iginiag go mel fidian sad tamad ŋilasag ŋumado da. Tamol ta iŋ Anut Nanun ta iloŋ na ya, nek Taman iŋsen mi a. Agod tamol ta iŋ ŋai Tamag ta iloŋ na ya, nek ŋaiseg mi, agod tamol nek amaiak Nanun iŋsinan ilobol lo mi Taman ikubiai pani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Agog Jesus idaŋsag, megeloum pasak nam irupidaig ibol, “Mel gamu ale dan niŋen o ilom uyan. ");
INSERT INTO tbc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Man dugo, profet adi agod kiŋ adi wei kasik, mel e gamu aŋ ale den dile wo mok dumat se ya, ak man iŋ ta dile na ya. Agod ru e gamu aŋ aloŋ den duloŋ o mok dumat se ya, ak man ta duloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kubiaeŋ san girek maŋau ta imasag Jesus ibitinae wo isumiani, “Girek maŋau, ŋai dugo ŋiganep kumaen ŋiŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ago tag Jesus isumianig ibol, “Moses san kubiaeŋ lo dugo digire yak i? Ata ru suti ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iŋ ru naon igo irupei, “Oŋ gidad Tubun en oŋane Anut niŋen o umat a, oŋ bube fidian lo, ŋutu fidian lo, oŋane ilo sou fidian lo, agod oŋane dabai fidian lo ago gane wa. Agod, nek oŋse niŋe wo umat dak ago mi tamolpein aenta dam niŋedi wo umat a.” ");
INSERT INTO tbc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Agog Jesus tamol an irupei, “Oŋane ru naon itaot a. Nek ago mi gane tap, kumaen pempem san ŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ak man kubiaeŋ san girek maŋau an, tamolpein aenta malad lo iŋanen nao lalek an uyanan ilasa wo ilon ibol a. Ago yan niŋen o iŋ Jesus igo isumiani, “Tamol niŋen ubol an enti mok i?” ");
INSERT INTO tbc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ago tag Jesus ru naon igo irupeig ibol, “Tamol ta iŋ Jerusalem ibiseig Jeriko na yau dugo dal na gumagam tamol adi diabi a. Agog biouŋ tinin fo yan dirasireg digam go, dufunig imat go tubabun yen dugo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Saen nek an lo pris ta dal an mi irig ipalu ya. Saen ipalu man tamol an imat go tubabun dal te yen dugo ile tag, dal gigin irig iriŋanig yau a. ");
INSERT INTO tbc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Livai san gugoi lo tamol taidam ipalug tamol an dal na yen dugo ile man, iŋ dam dal senamo iŋaneg yau a. ");
INSERT INTO tbc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Agog Sameria tamol ta dal an iŋaneg yau nag tamol an ile, ago man ilon tubun mi imuŋani a. ");
INSERT INTO tbc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ago tag wain iŋ gureŋ da marasin oŋ iŋaneg nam tinin baob ifulanig ifou. Agog tamol an iŋsiganen doŋki fo igane isudag, iŋaneg lou ab ta lo diaug kaginan igane ya. ");
INSERT INTO tbc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tidom lom mig kina uraru ab an san titianek tamol ipani dugo irupei, ‘Kaginan gane. Murnap ŋamul dop, melmel sapita iŋ tinin lo bisei an naon ŋai oŋ ŋupano wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Oŋ dugo ubol di? Tamol utol an luluŋad lo enti iŋanen turan o imat ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ago tag kubiaeŋ san girek maŋau an ibol, “Tamol a ilon imuŋani ama ya.” Ago dugo Jesus irupeig ibol, “Oŋ dam waup, nek ago mi gane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus iŋanen megeloum dida diaug panu ta ate dilasa ya. Atna pein ta yaŋan Marta dubol dan Jesus iwagig iŋsan ab lo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta tein ta yaŋan Maria, iŋ Tubun en ŋien fun na imasig imado dugo, iŋsan ru ibol dugo iloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ago dugo Marta mi sen kisaek anaŋ biabi an iganeg yaug, ilon saian tag ipalug Jesus irupeig ibol, “Tubun en. Ŋai teig en ibisawag go seg mi urat en fidian ŋigane dan niŋen dugo kankan gane dak i? Peip, ibunawag.” ");
INSERT INTO tbc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ago man Tubun en ru naon irupei, “O Marta! Oŋ mel wei mi niŋedi wo ilo weiwei dugo ilo muruan da. ");
INSERT INTO tbc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gug oŋ mel kisaek malan te yak niŋen o kankan ta gane na da. Maria mel an ipilianig iŋane ya. Talpein ta mel an banin lo ipasi san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Saen ta Jesus aben ta lo iguduanig itout an megeloum ta ipalug isumiani, “Tubun en, Jon iŋsan megeloum gudanek ipiteŋanai ak ago mi maŋ dam piteŋanama.” ");
INSERT INTO tbc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ago tag Jesus irupidaig ibol, “Aŋ agudani wo tap, igo agod a: ‘Maŋanema Bai, oŋane yaŋa gun. Oŋane kagin panek ipalu. ");
INSERT INTO tbc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nal anek anek san anaŋ panama. ");
INSERT INTO tbc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Maŋanema aupasek ilo iŋaoŋ. Man dugo, aupasek a aenta maŋ lo digane dan iloma iŋaoŋ da. Bitinaek lo naoma ta urae na wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Agog Jesus gudanek ipiteŋanai yaug, ru mitilaen en irupidai, “Gamu tura ta san ab lo waup, tidom lak dalawan tutip, anaŋ ta ipano wo gudanip ubol. ");
INSERT INTO tbc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Turag ta gamu nam ŋaisag na ipalu yak man ŋai anaŋ amag tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ago dop tura ab ilon lo ru naon irupaio, ‘Ŋioŋ saen go maen dak niŋen o leiŋ panama umoi. Dalawan itau a, pein nanuk fidian dien la ya. Ŋai ŋumasap mel ta ŋupano san tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gug ŋai ŋurupaiaŋ da, gidad, oŋsa tura bo man anaŋ ta ipano na wa. Gug oŋ gidad miai ifuno bo man maeg ganep sumiani oŋ tap, melmel fidian niŋen o ilo ibol dan ipano wa.” ");
INSERT INTO tbc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ago yak niŋen ŋai ŋurupaiaŋ da: Agudani dop, ipanaŋ a. Abaŋ abi dop, ale wa. Dalawan atuti dop, ipasi panaŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Fidian dugudani dan diŋane wa. Ta abaŋ yabi dan ile wa. Ta dalawan ituti dan Anut ipasi pani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Dugo, aŋ nanuk tamadi, nanum ta iy o igod dop, aben lo mot apani di? ");
INSERT INTO tbc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tia. Kurek patun o ibol dop lualiu apani di? An dam tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aŋ bo saiami a, ak gug nanum melmel niŋedi wo dugod tap, mel uyan ak apidinai da. Nek ago mi Bai Anut dam tamol enti Urgun iŋane wo igod tap ipani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nal ta Jesus tamol ta, ur saiak igane awan itau ak tinin lo ikudi a. Agog tamol an awan ipuk go iŋiŋeŋ a. Ago man tamolpein wei mi ate dutur dan fidian durut saian a. ");
INSERT INTO tbc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ak man aenta dubol, “Ur sisaiak sad gurman yaŋan Belsebul tabol damaiak san dabai lo mi iŋ ur sisaiak ikudai diau da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ago dugo aenta Jesus naon dukubiani wo kulob girager ta igane dop, dile wo dusumiani. An lo dop duloŋ ak, Anut sen idinig ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gug Jesus iŋsad ilod iloŋ la yak niŋen o irupidai, “Panu ta nug ditarpalep malan uraru dilasap, iŋsed ilod lo mi nug dufuni tap, iŋ saen milaen ta dumado na wa. Gugoi ta ditarpalep sensen dutur o digane tap, iŋsad gugoi an yau idu wa. ");
INSERT INTO tbc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ago yak niŋen o Satan iŋsen lo tarpalek igane dop, dugo woŋ pe iŋsan kagin panek aben an dabai yen yau ak i? Ŋai an ŋabol dan man fun, ŋai Belsebul dabai ipanag ak lo ur sisaiak ŋukudai diau dak abol da. ");
INSERT INTO tbc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Gug an rumok tap, aŋsiganem megeloum adi, enti san dabai nam ur saiak dukudai diau dak i? Fun amaiak niŋen o aŋsiganem megeloum iŋsed mi, saen Anut san bitinaek nal ilasa dop, kubianek tamol oŋ dilasap bitinaek lo didiraŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ak man ŋai Anut banin nam ur sisaiak ŋukudai diau dak ago tap, aŋ gidad aloŋ uyanan a, Anut san kagin panek an siŋirem na ipalu la ya.” ");
INSERT INTO tbc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tamol ta dabai ak ager san biouŋ tinin fo idirip ate iŋanen ab melmel da kagin ipidinai tap, iŋanen melmel an fidian itaot mi dien a. ");
INSERT INTO tbc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Gug tamol ta nen dabai ak ipalup, yu iŋ lo iganep itout tap, iŋsan ager san biouŋ biouŋ a ate iŋanen tini ganei igane se yan fidian igam pe isini yau a, agop iŋsan furan fidian dam iŋanep iwae yau a. ");
INSERT INTO tbc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Talpein enti iŋ ŋai ta iganurag na dan, iŋ patun ipanag da. Agod talpein a ŋai da sisem anaŋ mutumani san urat ta migane na dan, ŋaisag urat iratitale da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Saen ur saiak ta tamol tinin lo yak dukudip yau tap, aben igosan ak ate gidigidad ila iso wa. Ante aben ta yaes ibal san ile wo abaŋ yabi wa, ak man aben an ta ile na wa. Ago dop ilon lo ibol, ‘Ŋai gidad ŋamul pe ab gubak mi ate ŋumado amaiak lo ŋau a.’ ");
INSERT INTO tbc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iŋ imasap yau ak man, ab an kawan di ilon dam diriani dugo mel fidian dukubuneg itaot dien dan ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Amaiak niŋen o iŋ imul yaup, ur saiadi geig ak 7 taidam iŋal a. Ur an kulob sisaiak digane san man iŋ diriŋani geig a. Iŋ sisem ab an lo diladup dumado wa. Gubak mi tamol an san madok saian a, ak man gamu gup san madok saian geig a.” ");
INSERT INTO tbc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus ru ago ibol dugo, pein ta tamolpein luluŋad lo imasag iwagiŋ go ibol, “Pein a iginiosig su ipano yan bar iŋaneg imado da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gug Jesus awan yabig ibol, “Tia. Enti Anut san ru iloŋ dugo kagin ipani dan mi bar iŋaneg imado da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tamolpein wei mi dususa se ya, ago dugo Jesus irupidai, “Saen gamu en san tamolpein man saiadi geig. Iŋ kulob girager ta kob igo woŋ dile wo dusumianag da. Ak man Anut kulob girager ta tamolpein an ta ipidinai na wa, nek kob kisaek an mi ka dile wa, kob an man profet Jona san a. ");
INSERT INTO tbc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Man dugo, nek ibol Ninive adi malad lo Jona kob oŋ ilasag imado yak igo woŋ, ŋaiseg tamolpein saen en san iŋanen malan lo kob naon nek ago ŋilasap ŋumado wa. ");
INSERT INTO tbc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kwin a saut lo ilasa yan man, aŋ gamu saen en san tamolpein dida Anut san bitinaek nal lo sisem amasap, kot lo atur a. Ago dop kwin an aŋ niŋemi wo ru ibol ilasa dop boum ipanaŋ a. Man ata wo? Kwin an iŋ tan asau mok imado bo man, Solomon san kankan milaen amaiak ibol ilasa dop iloŋ o ipalu ya. Ago yak gug tamol ta dam iŋ ente imado da, tamol an man Solomon iriŋani geig a. ");
INSERT INTO tbc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive san tamolpein man aŋ gamu saen en san tamolpein dida Anut san bitinaek nal lo sisem amasap, kot lo atur a. Ago dop Ninive adi aŋ niŋemi wo ru dubol ilasa dop boum dupanaŋ a. Man ata wo? Ninive adi Jona san ru ibol ilasa yan duloŋ go an lo ilod ibilisa ya; ak man tamol ta iŋ Jona iriŋani geig an gamu imado da. ");
INSERT INTO tbc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tamol ta iŋ lam ibanip ta imianip yen na da. Agod sareg paen na ta iganep yen na da. Tia, iŋ kuai te isuŋanip iyuk yen da. Ago dop tamolpein a ab lo diladu dan lilaman dile wa. ");
INSERT INTO tbc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oŋane mala man tini san lilaman. Saen oŋane mala uyan tap, tini fidian geig an ilalaŋ da awan isa wa. Ak man saen oŋ mala saian tap, tini fidian geig an tidom tubun da awan isa wa. ");
INSERT INTO tbc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ago yak niŋen o kagin agane. Kabelan lilaman a oŋ lo yan tidom tubun oŋ banau. ");
INSERT INTO tbc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amaiak niŋen o aŋanem tinim fidian an ilalaŋ dugo gigin ta lo tidom tubun ta yen na tap, aria, lilaman a aŋ lo yen dan awan isa wa, nek ibol lam ided dan oŋ tini fidian ilalaŋ da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saen Jesus iŋiŋeŋ go itout an Farisi ta iwagig iŋsan ab lo anaŋ diani wo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesus Juda kagin iriŋanig, banin ta ifulani na dugo anaŋ diani wo dumasi a. Farisi an Jesus ago ileg, irut saian. ");
INSERT INTO tbc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ago tag Tubun en Farisi an irupei, “Aŋ Farisi man gab daeg da tinid patud fo yak mi afulanai da. Gug ilom lo man mala sek, agod kagin saiak saiak mi awan isa ya. ");
INSERT INTO tbc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Aŋ Farisi ŋiŋeo tinami. Anut tinim igane dugo ilom dam igane ya. An lo ata wo ilom ta akubune na dak i? ");
INSERT INTO tbc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Melmel a aŋsam gab daeg lo yan bigabeg adi apidinaip lo sed ibunawai tap, aŋ tinim fidian Anut malan lo ikokan imado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O Farisi, muruan tubun geig ak ale wa! Man dugo, aŋanem abi san anaŋ melmel kitiktik an fidian atumanip, malan 10 ilasa gup malan kisaek atarpalep Anut apani da. Gug aŋ Anut san kubiaeŋ malan te yak ariŋani da. Aŋ tamolpein kot lo ta atarpasai uyanan na dak, agod Anut niŋen o dam ta amat na da. Kagin malan te yak agane wa, agod kubiaeŋ san ru kagin kititik dam ta abisei na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O Farisi, muruan tubun geig ak ale wa! Man dugo, aŋ ubou ab lo tamolpein malad lo kapal malan te yak fo amado wo agane da. Agod aŋ tamolpein malak malak yaŋam diabisa wo agane da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Aŋ kagin agane! Aŋ man ibol tubabun gib lo imianuk yen dugo tamolpein ta duloŋ na dugo fufo diau dumul dugo sed nun ipidinai dak igo woŋ a, ago man iŋ aŋ siŋirem na dupalu yan lo Anut malan lo nun anda dilasag dumado da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Agog kubiaeŋ san girek maŋau ta Jesus irupei, “Girek maŋau, oŋ ago ubol dan maŋ dam paiama da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Agog Jesus ru naon irupei, “O kubiaeŋ san girek maŋau, aŋ dam muruan tubun geig ak ale wa! Man dugo, aŋ tamolpein kubiaeŋ fidian kagin dupani wo abol da. An lo tamolpein muruan tubun kasik apidinai da. Gug iŋsad muruan lo aŋ banim ilap kitek ta abinawai na da.” ");
INSERT INTO tbc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Rumok aŋ muruan tubun geig ak aŋane wa! Aŋ profet adi dumat la yan sad mutou damag siŋaokan apani da, ak gug profet nek an aŋanem tubum bagem dufu dumat a. ");
INSERT INTO tbc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kagin e agane den lo aŋsem kot ipanaŋ da, man dugo, kagin a gubak mi digane na yan niŋen o awok apidinai da. Iŋ profet adi dufu dumat se ya, agod aŋ sad mutou akubune da. ");
INSERT INTO tbc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Amaiak niŋen o Iŋ a tinin ilon lo Anut anen kankan milaen ak yen dan, igo ibol go irupaiaŋ, ŋai profet adi agod aposel adi ŋidinaip dupalu dop aŋsam na dilasa wa. Ago bo man aŋ aenta afu dumat a, aenkadi muruan funfun dupidinai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Fun an niŋen o, profet fidian ager adi banid lo mateŋ dile yan, kagin amaiak san ai wadan Anut aŋsem mi ipanaŋ a. An man aŋsiganem muruan mi a. ");
INSERT INTO tbc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","An lo Abel imat ak san saen log ipalug kiŋ Joas san saen lo, Sakaraia iŋ Berekaia nanun tempel san galuŋ gun ak, alta da titiŋae mi tubum bagemi dufunig imat a, kagin an san ai wadan an tamolpein gamu dumado den sad na ilasap disini wa.” ");
INSERT INTO tbc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O kubiaeŋ san girek maŋau, muruan tubun geig ale wa! Aŋ tamolpein maŋau diŋane san ki an banid lo apasi yau a. Aŋ tamolpein a maŋau san ab lo diladu wo ilod ibol dan sad dal afutani da, agod aŋsem ta aladu na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus aben an ibisei dugo Farisi iŋ kubiaeŋ san girek maŋau dida tiŋaed tubun mi saian se ya. Ago man Jesus yau dugo Farisi adi sumiaek funfun lo dusue se ya, ago dugo aten dusue dop melmel wei mi niŋedi wo iŋiŋeŋ dop duloŋ o digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jesus ifurfi dop lo ru dupani wo malad digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tamolpein wei kasik dutumanig, aben tia dugo nug tinin fo dutur se ya. Ago dugo Jesus imug megeloum ru kagin igo irupidai, “Farisi sad kagin sewak an niŋen kagin agane wa. Iŋ bale uraru tinadi, awad ru ibol dugup nuŋon ta digane na da. ");
INSERT INTO tbc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kagin fidian imianuk yen dan kuai isi wa. Kisaek ta imianuk yen san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ago yak niŋen o ru ta tidom tubun lo aŋ aŋiŋeŋ dan ad lo tamolpein duloŋ a. Ru dugon nug kududon lo kisikisik ab san galuŋ imianuk an lo abol dan, malak malak lo dam duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Turag muroug, ru ŋurupaiaŋ da. Aŋ tamolpein tinim dufuni imat an niŋen o arut amoi. Tinim mi ka dufuni imat a, ago gup nen dufuni san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ŋai tamol niŋen o arer san ŋurupaiaŋ da. Anut mi niŋen o arer a. Iŋ tamol tinin ifuni imat pe ŋutun dam ka ibal yai lo yau a. Awo, rumok ŋurupaiaŋ da, iŋ mi niŋen o arer a!” ");
INSERT INTO tbc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Toea uraru nam kuseŋ 5 didad da. Gug Anut kuseŋ an kisaek ta ilon iŋaoŋ san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ago yak niŋen o arer amoi. Man dugo, Anut aŋ o ilon isou da. Anut malan lo talpein san naon lak na geig, an kuseŋ wei kasik sad dadeŋ naon iriŋani geig a. Rumok, nek aŋanem gurmam roun sapita yan isutig iloŋ da.” ");
INSERT INTO tbc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ŋai aŋ ŋurupaiaŋ da. Talpein ta tamol naod na iŋ ŋaisag ago ibol tap, ŋai dam Anut san eŋel naod na ŋatur pe ŋabol ak iŋ ŋaisag a. ");
INSERT INTO tbc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ak man talpein ta tamol naod na iŋ ŋaisag tia yak ago ibol tap, ŋai dam Anut san eŋel naod na iŋ ŋaisag tia yak ago ŋabol a. ");
INSERT INTO tbc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Agod talpein ta iŋ Tamol Nanun niŋen o ru saiak ibol dan, Anut aupasek an ka isuas yau a. Ak gug talpein ta iŋ Awan Urgun niŋen o ru saiak ibol dan, Anut talpein an san muruan ta isuas yau na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Saen diŋiliaŋ pe Juda sad tumanek ab lo tamol tutubun naod na atur o, tia gabman gurman naod na atur dop, dugo woŋ sem ibalgiranaŋ pe aŋiŋeŋ an niŋen ilom ta weiwei na wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Saen nek an lo man Urgun iŋ ru abol ilasa san an ikubiai panaŋ a.” ");
INSERT INTO tbc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tamol ta tamolpein luluŋad lo Jesus irupeig ibol, “Girek maŋau, ŋai teig matu an rupeip, bai san filian an yabitip, anen anen atem misini wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ago tag Jesus ru naon irupeig ibol, “O turag, enti ŋai aŋ filiam ŋitarpale wo ipilianag i?” ");
INSERT INTO tbc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Agog Jesus irupidai, “Kagin agane. Aŋ tamol sen ak san filian niŋen o malam ta isi na wa, kagin naok ago yan fidian niŋen o sen alasa wa. Man dugo, tamol san madok uyan man tan san filian lo ta yen na da.” ");
INSERT INTO tbc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ago tag Jesus ru mitilaen en irupidaig ibol, “Filian tamol ta iŋ tan munan uyanan ak lo anaŋ ipaeg isa uyan a. ");
INSERT INTO tbc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Agog iŋsen kankan ago igane, ‘Ŋai darem fidian lo anaŋ ŋidiri san ta idaisuda na ya. Ak niŋen o dugo ŋigane wak i?’ ");
INSERT INTO tbc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Agog ibol, ‘Ŋai darem ŋusubaraip, foun tutubun ak ŋususe idu wa. Ante anaŋ, melmel aenta ŋidiri wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Agop ŋai melmel uyan ak wei mi amag da wa. Anaŋar wei mi yen da, an yaes ŋabal san idaisuda ya. Ago yak niŋen o ŋani ŋaluk dop, seg malag ŋupare woŋ dop ŋumado wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Gug Anut ibol, ‘Oŋ ŋiŋeo! Gamu tidom dop oŋ umat a. Ago dop enti oŋsa filia an iŋane wak i?’” ");
INSERT INTO tbc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Tamolpein ensauta a tan en lo iŋaned filian bageu san tubun mi dutumani wo dumat da, ago gug Anut malan lo man iŋ filiad tia ya, kagin nek ago mi iŋ lo ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Agog Jesus megeloum irupidai, “Ak niŋen o aŋsam madok niŋen o ilom ta muruan na wa. Mel ani wan niŋen o, mel aluk san agod biouŋ tinim san an niŋedi wo ilom ta muruan na wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Man dugo, anaŋ an mel tusan dugo ŋutumi an mel tubun a. Taida mi, biouŋ tinim san an mel tusan dugo tinimi mok an mel tubun a. ");
INSERT INTO tbc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Anakanak niŋen kankan agane, iŋ anaŋ ta dupae na da, iŋ anaŋ disinip anaŋ ab lo ta dutumani na da, ak man Anut iŋaned anaŋ ipidinai da. Ak dugo, Anut malan lo anakanak mel tusan dugo aŋ mel tubun geig ak i? ");
INSERT INTO tbc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Agod enti ta aŋ luluŋam lo, ilo wei lo iganep iŋsan tan san madok san saen kitek an isupasi wak i? ");
INSERT INTO tbc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ago yak niŋen o mel nanun an agane san tia tap, ata wo melmel an aenta fidian niŋedi wo ilom weiwei dak i? ");
INSERT INTO tbc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Garaŋ san kakak dugo woŋ disa dak ilom isou a. Kakak an urat ta digane na dak, agod iŋaned biouŋ dam ta diwei na da. Ak man ŋai ŋurupaiaŋ da, gidad Solomon damag siŋaokan ak dupani bo man, iŋsan leil man kakak an san leil igo tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aria, Anut garaŋ san kakak san leil iganep siŋaokan ago dilasa dop, gidad gamu kumaedi dumado gup gabulop yai lo diabiau o tap, o aŋ tamol ilo rumok amam tusan a, ak dugo, aŋ dam biouŋ tinim fo ta idiri na wak i? ");
INSERT INTO tbc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amaiak niŋen o ilom muruan pe ‘ata tani wak i?’ tia, ‘ata taluk ak i?’ ago ta abol na wa. Ilom weiwei amoi. ");
INSERT INTO tbc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Man dugo, tan en san tamolpein fidian mel an fidian abaŋan diabi dutor da. Agod aŋanem Tamami mel fidian a niŋen o aŋ katukami dan iloŋ fufei da. ");
INSERT INTO tbc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gug imug mi man, Anut san kagin panek an aŋanem madok lo malan te mok agane tap, melmel en fidian dam aŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“O ŋaisag sipsip malan wei tia yan, arer amoi. Aŋanem Tamam iŋanen ilo uyan lo iŋanen kagin panek ipanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ago yak niŋen o aŋanem filiami an adad yaup, moni aŋanep, tamolpein a melmel ad tia yan abinawai. Dal an lo Anut urat naon iŋsiganen panu lo idirip, pempem yen a. Darir, gumagam tamol adi dida dusubari san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aben dugon lo aŋsam urat naon yen dan aŋsam ilo girek fidian dam nek atna mi yen a.” ");
INSERT INTO tbc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Malam kumaen amado wa. Tinim akubunep, lam asulanip ided dop, tawaŋ aganep amado wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Urat pinein iŋaned tirnek tamol soubul lo yau ak imul o malan digane wa. Ago tap, iŋaned tirnek tamol imul ipalup, dalawan ititi dop ka dupasi kisaek oŋ a. Tamol nek ago alasap amado wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pinein malad kumaen dumado dan iŋ o ru tia ya. Pinein an irupidaip, dumasi dop, iŋsen anaŋ ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gidad, tidom lak boi, tia, salso idu wo sumeik dugo ipalu tap, pinein malad kumaen dumado dan uyad isusa wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gug aŋ mel en niŋen o ilo sou agane. Ab taman iŋ saen dugon lo gumagam tamol tidom lo ab igilep ilon lo iladu wan iloŋ tap, iŋ ta yen na wa. Tia, tawaŋ igane uyanan pe gumagam isadu san dal ifou wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ago yak niŋen o aŋ dam malam ipuk pe abaŋ ale wa. Man dugo, saen aŋ Tamol Nanun ipalu san an ta akubiani na dop, saen nek en lo iŋ imul ipalu wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesus ru ibol itout an Pita isumiani, “Tubun en. Oŋ ru en maŋ mi rupaiama di? Tia, tamolpein fidian rupidai di?” ");
INSERT INTO tbc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ago tag Tubun en ru naon igo irupei, “Ab taman ta iŋsan urat pinein a maŋau amad da, agod awan diri dupani dan, kob ipidinaig an lo iŋ iŋanen urat pinein aenta itirnai a, agod anaŋ diani san saen ante mi anaŋ ipidinai da. Ak dugo, aŋ luluŋam lo, enti iŋ urat pinein naok igo yak i? ");
INSERT INTO tbc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Saen ab muroun ipalup urat pinein an iŋsan urat igane uyanan dan ile tap, iŋ lo uyan a. ");
INSERT INTO tbc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ŋai rumok ŋurupaiaŋ da. Tamol tubun en iŋanen urat pinein emaiak kob ipanip, an lo iŋanen biouŋ fidian kaginad igane wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ak man urat pinein an tamol saian tap, ilon lo igo ibol, ‘Ŋaisag tamol tubun en ta ipalu kisaek oŋ na da.’ An niŋen o fun iganep urat pinein aenta, tamol iŋ pein da, ifu isusap, lukluk tamol dida anaŋ diani dop, you sakar ak duluk o kagin naok ago igane wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Urat pinein an san gurman nal agod auwa dam ta iloŋ na dop ipalu wa. An lo dop tamol tubun en ipalu saltik oŋ pe urat pinein an ibaltiti idu wa. Ago dop awa parsisalek tamol adi luluŋad lo iganep dida dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Urat pinein iŋanen tubun ak ilon iloŋ gug ta iri ipani na tap, muruan tubun mi ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gug ta iŋanen tubun ak ilon ta iloŋ na dugo igane saian tap, tamol an bu kabelan mi iŋane wa. Enti a Anut maŋau tubun mi ipani dan, Anut isumiani dak, iŋanen urat lo nuŋon tubun mi dam igane wa. Agod enti a Anut binawek nen tubun mi ipani dan, nuŋon dam nen tubun mi igane wo tinin igane pani da.” ");
INSERT INTO tbc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Agog Jesus ibol, “Ŋai tan na yai ŋigane wo ŋupalu ya. An niŋen o ŋaisag ilog man yai an gubak mi ided la yak man uyanan a. ");
INSERT INTO tbc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gug muruan tubun ŋisini wak naog na yen da. An niŋen o ŋaisag ilo muruan an yen dop yaup, muruan an itout a. ");
INSERT INTO tbc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ak dugo, ŋai maror tan en lo ŋigane ilasa san ŋupalu yak ago ilom isou dak i? Tia geig a, ŋai ŋurupaiaŋ da, maror tia, tia, biatitek mi a. ");
INSERT INTO tbc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Saen gamu en go yau dan, ŋai o ab aenta lo tarpalek yen a. Nuŋod kafenda tap, utol ŋai aneg dudu wa, ago dop uraru ŋai o ru sen dubol a. ");
INSERT INTO tbc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nanuk tamadi dumasap, nanud lo siai digane wa. Nanuk dam tamadi lo siai digane wa. Tinadi dumasap, nanud pein lo siai digane wa. Nanud pein dam tinadi lo siai digane wa. Nanuk iwod dumasap, nanuk tinad dida siai digane wa. Ago dop nanuk tinad dam raod lo siai digane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Agog Jesus tamolpein malan tubun an fon irupidai, “Saen ad idu yau dak ate timtaen bilkas ale dop abol da, ‘Ui idu wa.’ Ago dop ui idu da. ");
INSERT INTO tbc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Saen tim tubun mi ifure dop, aŋ aloŋ, ad idu wa. Agop ad idu da. ");
INSERT INTO tbc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aŋ sewak tamol. Aŋ abaŋ lak na yak ale dop fun aloŋ da. Tan na dam abaŋ ale dop, fun aloŋ da. Ak man ata wo melmel gamu ilasa dan fun ta aloŋ na dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aŋ ata wo kagin itaot agane san dal ta akubiani fufei na di? ");
INSERT INTO tbc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tamol ta iŋ oŋ iŋilio kot lo au dop dal na oŋ iŋ da ririan ru akubune wa. Kabelan iŋiliop, bitinaek tamol naon na alasap ai katuk banid lo iginiop dusubano banau. ");
INSERT INTO tbc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ŋai ŋurupaio da. Dusubano dan lasa san tia geig. Mado nap oŋane muruan naon an niŋen o, moni samukan fidian udad itout gup, lasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Saen an lo tamolpein dupalug Jesus durupei, “Juda tamolpein aenta Galili na dumado dan Jerusalem na tempel lo dupalug, Anut yai digane pani dugo gabman gurman, Pailat, tamolpein an ifu dumat dugo, iŋsad dar tinid lo ilasa se yan mudan a yai digane dan da ikubuli a.” ");
INSERT INTO tbc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ago tag Jesus isumianai, “Ak dugo, iŋ dal an lo dumat an niŋen o aŋ ilom lo abol, iŋsad kagin saiak Galili tamolpein aenta sad kagin saiak iriŋani ak ago abol di? ");
INSERT INTO tbc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tia geig. Gug ŋai ŋurupaiaŋ da. Aŋanem saian an fidian patum ta apani na wak an rumok tap, aŋ dam nek ago mi adeg au a. ");
INSERT INTO tbc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Dugo, tamolpein 18 Siloam na ab lak na geig an yau idug ifu dumat an, ilom lo iŋsad kagin saiak an Jerusalem tamolpein aenta sad kagin saiak an iriŋani abol di? ");
INSERT INTO tbc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tia geig a. Gug ŋai ŋurupaiaŋ da. Aŋanem kagin saiak patum apani. Tia tap, aŋ ago mi adeg au a.” ");
INSERT INTO tbc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Agog Jesus ru faŋan en irupidai, “Tamol ta iŋsan abi lo ai gurab ta ipae ya. Nal ta yaug, gurab patun abaŋ ile tia tag, ");
INSERT INTO tbc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","iŋsan abi titianek tamol irupei, ‘Ŋai anaŋar utol gurab an patun ta ŋile man tia ya. Ak niŋen o tare. Etna itur dop, tan bulbal iŋanep itout banau.’ ");
INSERT INTO tbc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ak man abi titianek tamol irupei, ‘Tubun en. Gidad, umoi dop, anaŋar kisaek taida itur dop tile gup. Ŋai dabin tan ŋupanip afon tile wa. ");
INSERT INTO tbc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Agop, anaŋar naod na yan nuŋon ifu uyan tap, itur a. Gug tia tap, titare wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat nal ta Jesus Juda ubou ab ta lo ru ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Saen an lo pein ta itaror oŋ itor dak an dam imado ya. Iŋ gubak mi ur saian tinin lo iladug yen dugo subam an iŋaneg anaŋar 18 yau la ya. Saen fidian ifotsa san ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus pein an ile tag iwagig, ipalug irupei, “Oŋane subam gamu ŋigane itout a.” ");
INSERT INTO tbc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ago dugo banin tinin fo iganeg, gamu nam ifotsag, Anut yaŋan yabisa ya. ");
INSERT INTO tbc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesus Sabat nal lo pein an iganeg uyan ak niŋen o, ubou ab an san titianek tamol tiŋaen saian. Ago tag iŋ tamolpein ipidaig ibol, “Nal 6 an urat san. Ago yak niŋen oŋ enti saia tap nal 6 an ilon lo palup, ikubunio. Gug Sabat nal lo man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ago tag Tubun en tamolpein fidian ubou ab an lo yan ru naon igo irupidaig ibol, “Aŋ balem uraru tinami a! Aŋ Sabat nal lo, aŋanem makau boi, tia, doŋki kam burod lo yan apasip, aŋal pe da aup you ta apidinai da. An ta rumok na i? ");
INSERT INTO tbc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nek ago mi, gamu pein en, Abraham malan kubulan, iŋ anaŋar 18 Satan banin lo imado se ya. Dugo, nal gun en lo Satan banin lo tupasi tap, dugo ilom isou di? An saian ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iŋsan ru naon an iganeg, tamol a fidian sumianek dupani an miai ifu ya. Gug tamolpein aenta man Jesus kulob funfun igane na yan niŋen o ilod tubun mi uyan se ya. ");
INSERT INTO tbc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Agog Jesus fon irupidai, “Anut san kagin panek man dugo woŋ ak i? Ŋai ata mel lo tou ŋigane wak i? ");
INSERT INTO tbc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iŋ ibol ai patun kitiktikan yaŋan masted dubol dak oŋ a. An tamol ta iŋanep, iŋanen abi lo ipaep, ipuk pe, isap, ai tubun ak oŋ ilasa wa. Ago dop anakanak raen fo wur dufuni wa.” ");
INSERT INTO tbc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Agog Jesus afon isumianai, “En ata mel ŋai Anut san kagin panek da tou ŋigane wak i? ");
INSERT INTO tbc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Iŋ ibol yis oŋ. Pein ta yis iŋanep, plaua daeg tubun ak lo yan ida ikubulip, yen dop plaua ikafut yaup tubun a.” ");
INSERT INTO tbc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus Jerusalem na yau dugo, dal na panu tutubun ak, agod kitiktik ak dam lo, Anut san ru ipiteŋanai dugo yau se ya. ");
INSERT INTO tbc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ago dugo tamol ta Jesus isumianig ibol, “Tubun en, dugo, Anut tamol wei an tia patud ipasi wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ago tag Jesus irupidaig ibol, “Dalawan man ipipiani an. Aŋ dalawan ipipiani an lo aladu wo maeg agane wa. Man ata wo? Ŋai ŋurupaiaŋ da, tamolpein wei mok Anut san kagin panek aben lo diladu wo ilod ibol da, ago bo man diladu san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Man dugo, ab taman dalawan ifutanip, an lo aenta asupakuk dop, patun fo atur a. Dalawan atitip, awagiŋ a, ‘Tubun en, oŋ dalawan pasi panama.’ “Gup iŋ ru naon igo irupaiaŋ a, ‘Aŋ dugon te alasa yan ŋai ta ŋaloŋ na ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ago dop arupeip abol a, ‘Oŋ maŋ da sisem tani taluk na ya. Maŋsama panu lo dam piteŋanama na ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ago gup irupaiaŋ, ‘Ŋai fon ŋurupaiaŋ da, aŋ dugon te alasa yan ŋai ta ŋaloŋ na ya. Aŋ aupasek tinami, sen alasa.’ ");
INSERT INTO tbc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Aben an ate aŋ atata dop luomi agurmi wa, man dugo, Abraham, Aisak, Jekop, profet adi fidian dam Anut san kagin panek aben lo dumado dop eil a, ak man diabianaŋ pe patun fo alasap amado wa. ");
INSERT INTO tbc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tamolpein wei kasik ad isuda dak lo, ad idiau dak lo, not lo, saut lo dam an fidian dususap, Anut san kagin panek aben lo diladup anaŋ diani wo dumasip dumado wa. ");
INSERT INTO tbc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aloŋ uyan, aenta gamu murna yan murnap dumug a, ago dop aenta gamu malan te yan murnap murna geig dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saen an lo mi Farisi aenta dupalug, Jesus durupei, “Oŋ gidad, gamu aben en biseip sen lasa. Man dugo, Herod oŋ ifuno umat o ilon yen da.” ");
INSERT INTO tbc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ago tag Jesus ru naon irupidai, “Aup, goun kasik an arupei, ‘Ŋai saen gamu, gabulo an man ur saiak saiak ŋukudai diau dop, tamolpein subam ad da yan ŋukubuniai a. Salsop ŋaisag urat wadan ŋufutani wa. ");
INSERT INTO tbc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ago yak niŋen ŋai gamu, gabulo, salso man tureŋ mi ŋabi wa. Man dugo, aben a ate profet ta dufuni imat an man Jerusalem mi a, an niŋen o panu sen ta lo dufuni imat banau.’” ");
INSERT INTO tbc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem. Oŋ profet adi ufu dumat na ya. Anut tamol oŋsa na iginiai dupalu dan dam pat nam ufu da. Nal wei kasik ibol kurek ta nanun subarin paen na kagin ipidinai dak ago mi ŋai kagin ŋupanaŋ o ŋigane gug aŋ ŋai amoi a! ");
INSERT INTO tbc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ago yak niŋen o Anut aŋsam tempel ibiseig kawan yen da. Agod ŋai ŋurupaiaŋ da, aŋ ŋai fon ta aliag na dop yaup aŋ saen igo abol, ‘Tamol e Anut yaŋan lo ipalu den Anut anen bar tinin lo yen da.’” ");
INSERT INTO tbc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat nal ta lo Jesus Farisi gurman ta san ab lo anaŋ yani wo yau a. Iŋ fidian Jesus kulob dugo igane dop dile wo malad ti ibol go leil dupanig lo ru dupani san ago digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Agog tamol ta ŋien banin ikafut ak Jesus siŋiren na ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus tamol an ile tag kubiaeŋ san girek maŋau, iŋ Farisi dida isumianai, “Idsad kubiaeŋ dugo ibol ak i? Sabat nal lo subam adi ka tukubuniai ak i? Tia yak i?” ");
INSERT INTO tbc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ak man iŋ fidian ru ta dubol man tia ya. Ago tag Jesus tamol an iŋaneg ikubuneg itout go idinig yau a. ");
INSERT INTO tbc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Agog Jesus fon isumianai, “Aŋ luluŋam lo tamol ta nanun boi, tia, iŋsan makau boi, you san gib lo idu yau tap, mel en Sabat nal lo ilasa yan niŋen o, ririan yaup irae isudap iŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ak man ta kisaek ru naon ipei man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus Farisi an san ab lo imado dugo, tamolpein dupalug kapal malan te yak atem dumasi wo digane dugo yil. Ago tag ru faŋan en ibol, ");
INSERT INTO tbc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tamol ta nug ŋanek san soubul lo igiop wau tap, imug mi kapal malan te yak fo masi umoi. Kabelan tamol ta oŋ iriŋano yak dam iwagip ipalu banau. ");
INSERT INTO tbc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Agop soubul taman an ipalup irupaio, ‘Oŋ gidad masa dop, iŋ aben en lo imasi wa.’ Agop oŋ miai tubun mi ifuno dop, masap waup, kapal wadan na yan fo masi wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tia. Saen tamol ta soubul lo igio tap, waup, imug mi gidad kapal wadan na yan fo masi wa. Ago dop soubul taman oŋsa na ipalup, irupaiop igo ibol, ‘Turag, oŋ masap palup aben uyan en lo masi wa.’ Ago tap oŋ tamolpein dumado dan malad lo oŋ yaŋa ama da wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Man dugo, tamol ta iŋsen yabisa dan, Anut iŋ yabi idup tamol yaŋan tia yak imado wa. Agod ta iŋsen yabi idu dan Anut iŋ yabisap yaŋan anda imado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Agog Jesus soubul taman irupei, “Saen soubul gane tap, oŋane tura, murou, ab susumeik, filiad anda yak mi giai umoi. Man dugo, iŋ murna dop soubul naon digane panop, an lo iŋaned gubun dupano wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tia, saen oŋ anaŋ ta wabi wo tap, bigabeg adi, dutor san tia yan, a ŋiedi tubabunan, agod malad tia an dam, gidad soubul lo giaip dupalu wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ago tap oŋ bar uyan ama da wa. Man dugo, iŋ naon fon oŋ dupano san tia ya. Gug mitep saen tamol itaot adi kumaen dumasa dop, Anut kulob a gane yan naon ipano wa.” ");
INSERT INTO tbc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Agog tamol ta iŋ dam ante anaŋ diani ak ru an iloŋ tag Jesus irupeig ibol, “Talpein iŋ mitep Anut san kagin panek aben lo soubul tubun an lo dumado yan bar iŋaneg imado da.” ");
INSERT INTO tbc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ago tag Jesus tamol an irupeig ibol, “Tamol ta iŋ soubul tubun ak iganeg, tamolpein wei mok dupalu wo igiai a. ");
INSERT INTO tbc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Murnag biabi fidian itout dugo iŋanen urat pinein idinig yaug, tamolpein igiai an irupidai, ‘Apalu, biabi fidian itout la ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Agog anen anen fun diganeg soubul lo ta diau na wan niŋen o urat pinein an durupei a. Tamol malan malan an ibol, ‘Ŋai tan kilaken ta ŋadad ak ŋaup ŋile wa. An niŋen o gidad, ŋai ilo isou umoi.’ ");
INSERT INTO tbc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tinin te yan ibol, ‘Ŋai urat san makau 10 ŋadad a. An lo ŋaup ŋibitiniai o da. Uloŋ de? Gidad, ŋai ilo isou umoi.’ ");
INSERT INTO tbc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ago dugo neinta dam ibol, ‘Ŋai nor na geig pein ŋiŋane ya. Ago yan lo ŋai gamu ŋau san tia ya.’” ");
INSERT INTO tbc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ago tag urat pinein an fon imul yaug ru fidian iŋanen tubun an naon na ibol. Iŋsan tubun en ru an iloŋ go tiŋaen saian tag, urat tamol an fon idini dugo igo irupeig ibol, ‘Ririan waup, panu ilon lo saiak saiak adi, bigabeg adi, ŋied banid imat, malad tia yak, an uŋal pe dadi apalu.’” ");
INSERT INTO tbc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Agog urat pinein an imul ipalug ibol, ‘Oŋane ru ubol an ago mi ŋigane ya. Tamol ŋaŋal ak gug aben aenta wei mi kawan dien da.’” ");
INSERT INTO tbc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ago tag tamol tubun an urat pinein afon idini dugo irupeig ibol, ‘Waup, dal garaŋ lo, abi dal lo tamolpein man sodudunaip uŋal pe dida apalu wa. Agop ŋaisag ab awan isa wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ŋai ŋurupaio da, tamol a malmalan ŋigiai ak gug iŋ dumoi an, ŋaisag anaŋ en awad kitek isue ile san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tamolpein wei kasik Jesus ŋien fo diau dugo idaŋsag irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Talpein ta ŋai iganurag o da, ak gug iŋ tinan, taman, iwon nanun, tein muroun, lun muroun fidian ta patun ipidinai na dop, iŋsen o kankan igane tap, talpein naok an ŋaisag megeloum ilasa san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta iŋsinanen aigim isinip, ŋieg aban ta iri na tap, iŋ ŋaisag megeloum oŋ ilasa san ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tamol ta iŋ ab lak na nuŋon yabi wo imat tap, iŋ imasip, ilon igire wa. Bor sapita isue wak, agod moni sapita ibiseip ab an yabi itout an ilon isou uyan gup, ab an yabi wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Gug ago ta igane na tap, ab tubun an fun mi igane gup ta yabi itout na wa. Ago dop aenta ab an dile dop, kukok an diganep ");
INSERT INTO tbc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","dubol a, ‘Tamol en urat fun igane gug igane itout san ta idaisuda na ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nek ago mi kiŋ ta yaup, tan sen ak ta san kiŋ da nug dufuni wo tap, iŋ imasap ilon igire uyanan a, man dugo, iŋsan yu tamol 10 tausen mi, gug neinta san man 20 tausen. Ak dugo, iŋsan 10 tausen neinta san 20 tausen diriŋanai san idaisuda yak i? Ilon ago igire wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aria, iŋ ta idaisuda na tap, tamol idinaip diaup, kiŋ neinta an dal na mi ida ru dukubunep, ilod kisaek, agop nug ta dufuni na wa. ");
INSERT INTO tbc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nek ago mi, talpein ta iŋ ŋai iganurag o imat tap, tan en san filian fidian patun ipani gup, iŋ ŋai iganurag a. Tia tap, ŋaisag megeloum ilasa san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Beig man mel uyan a. Gug saen iŋsan bulbal an itout dan dal ta lo fon tiganep, bulbal san tia ya. Iŋsan urat dam fidian itout a. ");
INSERT INTO tbc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ago dop tibiliau da. Tamol oŋ kududo ama da tap, ru an uloŋ uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nal ta takis ŋilaŋal adi iŋ aupasek tamol adi dida Jesus san ru duloŋ o dususa ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Agog Farisi adi, iŋ kubiaeŋ san girek maŋau dida Jesus patun fo disidag dubol, “Tamol an aupasek adi dida nug turan diganeg dida anaŋ kisaek mi diani da.” ");
INSERT INTO tbc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ago tag Jesus ru faŋan en ibol irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tamol ta iŋsan sipsip 100 gug luluŋad lo kisaek ideg yau tap, an niŋen o dugo igane wak i? Iŋ sipsip 99 an itumanaip dumado dop yaup, kisaek an abaŋan yabip itor nap ile mok a. ");
INSERT INTO tbc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Saen sipsip an ile dan ilon uyanan pe, iŋanep paon fo ibili isudap, isinip, panu na yau a. ");
INSERT INTO tbc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Agop iŋanen turan muroun, ab susumeik an igiaip dupalup, agop irupidai, ‘Ŋai ilog tubun mi uyan da. Man dugo, ŋaisag sipsip kisaek ideg yau gug fon ŋile ya. Ak niŋen o apalup yousai tigane.’ ");
INSERT INTO tbc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nek ago mi lak na Anut san eŋel adi dam tamol ta Anut san kagin imoi ak fon ibileksa dop, iŋ o ilod tubun mi uyan da. Ak man 99 a itaot la yak dubol go dumado dan iŋ o eŋel adi uyasusai ta digane na da. ");
INSERT INTO tbc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nek ago mi pein ta iŋ moni patun 10 gug kisaek ideg yau dop niŋen o dugo igane wak i? Iŋ lam ibanip, ab ilon irianip, abaŋ yabip yau na gup ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Saen ile dan turan muroun, agod ab susumeik an igiaip, dutumanip, irupidai, ‘Moni patun a ideg yau an fon ŋile ak niŋen o ilog tubun mi uyanan a. Ago yak niŋen aŋ ŋai da sisem ilod uyanan a.’ ");
INSERT INTO tbc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ŋai aŋ ŋurupaiaŋ da, nek ago mi Bai Anut san eŋel adi aupasek tamol ta kisaek ilon ibilisa tap, an niŋen o ago mi uyad tubun mi isusa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus ru awan ibateg ibol, “Tamol ta nanun uraru a. ");
INSERT INTO tbc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nanun bakan an taman irupeig ibol, ‘Bai, oŋane filia ŋai teig da wabitip ŋaineg ŋutug gamu en panag.’ Ago tag taman iŋanen filian an yabitig nanun uraru mi anen anen ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Murnag nanuk bakan ak iŋanen filian an idad yaug, san moni an isinig panu ta asau ak lo yau. Atna uyasusai kagin lo moni isini an isuwari yau. ");
INSERT INTO tbc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Iŋ melmel fidian isini an igane itout a, ago gug kadag tubun ak tan an lo idu ya. Ak man tinin lo melmel an fidian itout go muruan tubun mi isini se ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ago tag yaug, panu an san tamol ta san na urat igane wo isumiani. Tamol an yabig idinig yaug bor sad ar lo iŋanen bor kaginad igane dugo imado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ago dop bor sad anaŋ samsamun ta yani wo yaes isofutani gug talpein ta mel yani san ta ipani man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Saen tinin imadan man, ilon ipastig ilon lo igo ibol, ‘Ŋai tamag san urat pinein bo iŋ anaŋ idaisuda mi diani dugo dumado da. Ak man ŋai ente kadag ibiag dugo mateŋ ŋile wo sumeik da! ");
INSERT INTO tbc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ŋai ŋumasap bai san na ŋaup ŋabol a: O bai, ŋai oŋ Anut da naom na ŋigane saian a. ");
INSERT INTO tbc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ago yan lo ŋai oŋ nanu ubol san niŋen o ŋai ta idaisuda na ya. An niŋen o ŋai oŋsa urat pinein luluŋad lo oŋsa urat pinein kisaek ago giniag pe ŋilasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Agog imasag, imul go taman san na yau a. “Asau mi ipalu dugo taman malan yaug ile ya. Agog iŋanen nanun ilon imuŋani saian geig tag, imaspalug yaug, nanun yabig musuk ipanig ida ditata se ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Agog nanun irupeig ibol, ‘O bai, ŋai oŋ Anut da naom na ŋigane saian a. Ago yan lo ŋai oŋ nanu ubol san niŋen o ta idaisuda na ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Gug iŋanen taman urat pinein idinaig ibol, ‘Ririan aup, kulos milaen siŋaokan an aŋanep asini apalup, agane pani. Ariy dam tuon lo agane. Sendal dam adiri pani. ");
INSERT INTO tbc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Agod aup, makau nanun tinin italbusi uyan an afuni. Agop id anaŋ tabip tani dop, ilod uyan dop muguruŋ tigane wa. ");
INSERT INTO tbc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Man dugo, ŋai nanug en imat ŋabol ak gug gamu afon kumaen imado da. Gubak mi ideg yau ŋabol ak gug gamu afon ŋileg ŋiŋane ya.’ Agog muguruŋ tubun ak fun digane ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Agog nanuk matu an abi lo itor nag imul ipalug, ab sumeik ipani dugo iŋ sad uyasusai an liliŋan iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ago tag urat pinein ta iwagig isumiani, ‘An ata digane dak i?’ ");
INSERT INTO tbc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Agog urat pinein an ru naon irupei, ‘Oŋ tei itor ak gamu ipalu ya. Muruan ta ile man tia yak niŋen o aŋ tamam makau nanun tinin italbusi uyan an ifuni a.’ ");
INSERT INTO tbc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nanuk matu an ago iloŋ go tiŋaen saian tag ab ilon lo iladu san imoi a. Ago tag taman ilasag iŋanen nanun matu ak ab lo iladu wo ilon iŋane wo igane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ak man nanun an taman irupei, ‘Anaŋar wei kasik ŋai oŋsa urat pinein igo woŋ urat ŋigane na ya. Agod ŋai oŋ awa kitek ŋiparsisali man tia ya. Ak gug oŋ sipsip nanun ta, ŋaineg turag muroug dida uyama isusa wo panag man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gug oŋ nanu an oŋsa filia pani an jeit pein adi tinid lo ibidani dugo itor nag, gamu imul an, oŋ makau nanun tinin italbusig uyan an iŋ niŋen o funi a.’ ");
INSERT INTO tbc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ago tag taman ibol, ‘Nanug, oŋ ŋai da nal pempem tumado da. Agod ŋaisag mel fidian man oŋsa. ");
INSERT INTO tbc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ak man gidad gamu ilod uyan dop muguruŋ tigane wa. Man dugo, oŋ tei en imat ŋabol gug, gamu fon imado da. Iŋ ideg yau gug fon imul ipalu ya.’” ");
INSERT INTO tbc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus iŋanen megeloum irupidai, “Filian tamol ta iŋ urat titianek tamol aman da ya. Agog tamol aenta dupalug, filian tamol an durupei, ‘Oŋsa titianek tamol an oŋane filia ibidani da.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ago tag iwagig isumiani, ‘Ŋai oŋ niŋe wo ru tim ŋaloŋ a. Oŋ dugo gane dak i? Oŋ masip, urat gane yan girep panag dop urat bisei. Oŋ afon urat titianek tamol mado san tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Agog titianek tamol ilon igireg ibol, ‘Ŋaisag tubun en gamu ŋaisag urat lo ikudag o da. Dugo ŋigane wak i? Ŋai tan ŋitare san dabai amag tia. Agod ŋai ŋagod o dam miai ifunag da. ");
INSERT INTO tbc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ak man dugo ŋigane wan gamu ŋaloŋ a. Ago tap mitep urat lo ikudag dop, turag muroug wei mi duyuŋanag dop iŋsad ab lo digiag pe ŋau a.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ago tag iŋ tamolpein fidian a iŋsan gurman san na gubun digane yan kisaek kisaek mi igiai a. Tamol malmalan an isumiani, ‘Oŋ ŋaisag gurman an tinin lo gubun sapita gane yak i?’ ");
INSERT INTO tbc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Agog ru naon irupei, ‘Wan handet dram oliv gureŋ.’ “Ago tag titianek tamol an ibol, ‘Ririan masip, wan handet suas pe fifti mi gire.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Agog neinta isumiani, ‘Oŋ gubun sapita gane yak i?’ “Agog ibol, ‘Wan tausen bek wit.’ “Ago ibol tag irupei, ‘Masip, girek an suas pe 8 handet gire.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Aria, iŋsan gurman kulob a igane yan san ru iloŋ go ipitiani a, man dugo, urat titianek tamol an kankan anda ya. Tan en san tamolpein siganed madok an kagin dupani uyanan san niŋen o kankan ad da ya, agod iŋsad kankan an, tamolpein a ilalaŋ san an sad kankan iriŋani da. ");
INSERT INTO tbc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ŋai ŋurupaiaŋ da. Aŋsam moni nam tamolpein abinawai. Agop an lo iŋ aŋ turam dilasa wa. An lo dop saen aŋsam moni biabi aman tia man, kumaen panu lo aladup ante tamolpein an duyuŋanaŋ pe malam dupare wa. ");
INSERT INTO tbc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Talpein enti mel nanun ak lo kagin uyan an mi igane dan, mel tubun ak lo dam ago mi igane wa. Nek ago mi, talpein enti mel kititik lo iraek tap, mel tutubun ak lo dam ago mi igane wa. ");
INSERT INTO tbc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ago yak niŋen o, oŋ tan en san filian o raek kagin gane yak ago tap, saen kumaen panu san filian mok a diwae dan, oŋ niŋe wo ilod isou wak i? Tia geig, oŋ bani kawan mado wa. ");
INSERT INTO tbc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Agod tan en lo oŋ tamol sen ak san filian kagin pani wo bani lo digane yak gug, oŋ kaginan ta gane uyan na yak ago tap, oŋane filia kumaen panu lo yan bani lo diganep kagin pani wak i? Tia geig a. ");
INSERT INTO tbc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tamol ta iŋ gurman uraru an mi nal kisaek lo mi awad yabi san tia ya. Iŋ ago igane wo igane tap, iŋ kisaek o lian niŋen o imat dop, turan ile saian a. Tia dop, kisaek o lian ilon ipani dop, turan patun ipani wa. Nek ago mi oŋ Anut moni da sisem uri san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi adi ru an fidian duloŋ go Jesus kukok an digane dugo nao futek ru tinin lo digane se ya. Man dugo, moni niŋen o tubun mi dumat a. ");
INSERT INTO tbc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Agog Jesus irupidaig ibol, “Aŋ tamolpein malad lo sem itulaŋ da, ak gug Anut aŋanem ilom iloŋ uyanan da. Mel a tamol malad lo naon lak na geig ak anda yan, nek mel an Anut malan lo iganan geig ak ibol da.” ");
INSERT INTO tbc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses san kubiaeŋ iŋ profet adi sad ru da yen go ipalug Jon san lo ya. Saen an log ipalug gamu saen en lo man, Anut san kagin panek aben san ru dufulale da. Ago dugo tamolpein wei kasik Anut san kagin panek aben ilon lo diladu wo wagai digane da. ");
INSERT INTO tbc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Keit tan da ditout diau san man pasauman geig a, ak gug girek kitekan san boi ta Moses san kubiaeŋ lo yan ideg yau san ta pasauman na ya. Rumok, ideg yau san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Tamol ta iŋ iwon ikudip pein foun ak iŋane tap, jeit igane da. Ago dop tamol sen ta pein a iwon ikudi an iŋane tap, iŋ dam jeit igane da. ");
INSERT INTO tbc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tamol ta iŋ filian anda yak pempem biouŋ sisiŋaok ak mi idirip imado se ya. Anaŋ dam uyan uyan ak mi yani se ya Iŋ mel ta lo katukan man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ago dugo bigabeg tamol ta yaŋan Lasarus dam imado. Iŋ tinin baob yafutani a. ");
INSERT INTO tbc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pempem disini diaug, filian tamol an san ab naon na dibilisig, imado dugo anaŋ samsamuk filian tamol san badim fo yan idu dan yani wo ilon tubun mi ibol se ya. Ago dugo goun dupalug, iŋsan baob an dipile se ya. ");
INSERT INTO tbc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tamol uraru an ago digane yau nag, bigabeg tamol an imat go, Anut san eŋel diŋaneg diaug, Abraham giraŋen na digane ya. Agog filian tamol an dam imat go disare ya. ");
INSERT INTO tbc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iŋ Ades lo imado dugo, madai tubun mok ifuni se ya. Agog malan isudag, asau mi Lasarus Abraham giraŋen na imado dugo ile ya. ");
INSERT INTO tbc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ago tag filian tamol Abraham iwagig go ibol, ‘Bai Abraham, ilo imuŋanag. Lasarus dinip, banin kikoun you lo isaminip, isini ipalup baleg fo iganep ibubarum. Man dugo, ŋai yai en lo madai tubun mi ŋisini dugo ŋisagai da.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ago tag Abraham ru naon irupei, ‘Nanug, ilo isou. Saen oŋ tan na kumae mado dugo, oŋ oŋsa mel uyan uyan ak ŋane na ya, ago dugo Lasarus mel saian saian ak mi iŋane na ya. Gug gamu iŋ ilon pasa ibol dugo oŋ madai tubun geig ak sini da. ");
INSERT INTO tbc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","An mi tia, Anut oŋ ŋai da titiŋaem dog kuror ak iganeg yen da. An lo tamolpein etna dumado dan dog an dupilalip oŋsa na diau san tia ya, nek ago mi tamolpein a oŋ dida amado dan dog an dupilalip ŋaisag na dupalu san dam tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ago tag filian tamol an ru naon irupeig ibol, ‘Mago tap, Lasarus dinip, ŋai tamag san ab lo yaup, ");
INSERT INTO tbc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","teig 5 ante dumado dan ru kagin irupidai a. Kabelan iŋ dam aben ente tamolpein madai tubun geig dile wan ate dupalu banau.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ak man Abraham ru naon irupeig igo ibol, ‘Tia. Oŋ tei murou man iŋ Moses san kubiaeŋ, agod profet adi sad ru ka dusuti wa, an iŋ o idaisuda ya. Ru an ka duloŋ dop kagin digane wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Agog filian tamol an ibol, ‘Tia. Bai Abraham, an man ta idaisuda na ya. Uloŋ, tamol ta imat ak fon kumaen imasap yaup, ŋai teig muroug an irupidai tap, an lo ilod ibilisa wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ak man Abraham irupeig ibol, ‘Iŋ Moses profet dida sad awad ta diabi na yak tap, gidad tamol ta mateŋ lo yak fon imasa dap, ilod iŋanep ilod ibilisa wo ru kagin irupidai bo man, iŋ awan ta diabi na wa.’” ");
INSERT INTO tbc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Agog Jesus iŋanen megeloum irupidaig ibol, “Kubianek funfun ilasa wa, dilasa san dal tufutani san tia ya. Gug tamol enti iŋ turan ta naon iraep, kagin saian lo idu tap, iŋ muruan tubun mi ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gidad, iŋ pat tinan ta buron lo disisi idup, beig lo dibili idup isarir o man uyanan mok a. An tia tap, muruan nen tubun geig ak ile wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ago yak niŋen o kagin agane, sem tinim atirni uyanan a! “Oŋ tei ta oŋ lo aupasek igane tap, kududon wabi. Agop ibileksa tap, iŋanen aupasek an pare idu pani. ");
INSERT INTO tbc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Gidad, ad kisaek ilon lo saen 7 oŋ lo igane saian gug saen anen anen lo mi imul go, nao na ilon ibileksa yak ibol da, an ago tap, saen nek an lo mi iŋanen muruan an pare idu wa.” ");
INSERT INTO tbc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Agog aposel adi Tubun en durupei, “Maŋsama ilo rumok an ganep dabai.” ");
INSERT INTO tbc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ago tag ru naon irupidaig ibol, “Masted patun man kitiktik an gug isap ai tubun ak ilasa da. Ago yak niŋen o aŋsam ilo rumok masted patun igo woŋ tap, gidad ai e leil apani den tubun a, ago bo man ka arupei, ‘Oŋ se ibilanop, waup, beig lo udup utur,’ ago dop awam yabi wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Aŋ luluŋam lo tamol ta kisaek san urat pinein abi lo itor boi, tia, sipsip ititianai boi, ab lo imul ipalu dop, iŋ imug o mi anaŋ yani wo ta irupei na wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tia, iŋanen tubun ak san anaŋ imug ikubunep ipanip, yani gup, murna dop iŋsinanen anaŋ yani wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Urat pinein ago igane dop, iŋsan tubun an ilo uyan ru ta irupei na wa. Tia. Man dugo, urat pinein an iŋanen tubun ak idini ak fom igane da. ");
INSERT INTO tbc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aŋ dam nek ago mi a. Saen aŋ urat fidian ŋai aŋ ŋupanaŋ an aganep itout dop abol, ‘Maŋ urat pinein kawan a. Maŋanema tamol tubun ak mi awan mabi da, mel ta per panek miŋane san ta migane na da.’” ");
INSERT INTO tbc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus Jerusalem na yau dugo dal a iri dan Sameria iŋ Galili da dien dugo titiŋaem yau a. ");
INSERT INTO tbc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Panu ta ate iladu dugo, tamol 10 lepra amad da yak dal na dile ya. Iŋ kitek asau mi dutur dugo, ");
INSERT INTO tbc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","duwagiŋ, “Jesus, Tubun ak, ilo imuŋanama.” ");
INSERT INTO tbc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus yil tag irupidai, “Aup, tinim Juda sad pris adi akubiaip dile.” Agog dal na diau dugo tinidi afon ilasa uyanan da ya. ");
INSERT INTO tbc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iŋ luluŋad lo tamol ta kisaek iŋ tinin ago ile tag, idaŋsag imul Jesus san na yau dugo, awan tubun mi Anut yaŋan yabisa se ya. ");
INSERT INTO tbc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Agog yaug Jesus naon na turun isaluwig, ilo uyan ipani a. Tamol an Sameria tamol. ");
INSERT INTO tbc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus ago ile tag ibol, “Tamol 10 ŋukubuniaig uyadi an, kisaek imul a, ago dugo, 9 an dugon te diau ak i? ");
INSERT INTO tbc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ata wo tamol ŋukubuniaig uyad isusa yan, Anut per dupani wo ta dumul dupalu na dugo, nek tamol gol en mi imul ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Agog Jesus tamol an irupei, “Masap wau. Oŋane ilo rumok ikubunio ya.” ");
INSERT INTO tbc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi aenta Jesus dusumiani, “Saŋeptap Anut san kagin panek ipalu wak i?” Ago tag Jesus ru naon irupidai, “Anut san kagin panek ipalu dan, an talpein ta ile iloŋ na wa, man dugo, kob ta iŋsan kagin panek sumeik ipalu dan san an imug ta ilasap ale na wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Talpein ta imasap igo ta ibol na wa, ‘Anut san kagin panek ente ya.’ Tia, ‘Anut san kagin panek onte ya.’ Man dugo, Anut san kagin panek aŋ luluŋam lo yen da.” ");
INSERT INTO tbc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Agog Jesus megeloum irupidai, “Murnap aŋ Tamol Nanun kitek ale wo ilom ibol ak gup ale san tia wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aenta durupaiaŋ, ‘Tamol Nanun obo ya.’ Tia, ‘Iŋ ebe ya.’ Gug iŋsad ru an ilom lo rumok pe abaŋan abi amoi. ");
INSERT INTO tbc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Saen Tamol Nanun imul dan, iŋsan leil man nek ibol weil irakulawi dan, san lilaman aben o ad ilasa dak atep, aben o ad idiau dak ate yau dak igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gug malmalan muruan wei mi isinip saen e lo tumado den san tamolpein patud dupani gup. ");
INSERT INTO tbc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kagin a Noa san saen lo tamolpein digane se yan, kagin nek amaiak mi Tamol Nanun imul san saen lo dam digane yau a. ");
INSERT INTO tbc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saen lom tubun ak ta ilasa na dugo, iŋ anaŋ diani dugo, you dam duluk dugo, nug diŋane dugo, pein ŋiedi dupidinai dugo, yaug saen Noa wog tubun ak lo iladu ya. Agog lom tubun ak ilasag tamolpein an fidian daoŋ ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot san saen lo dam ago mi digane se ya. Tamolpein diani duluk oŋ dugo, didad diŋane oŋ, ab diabi oŋ, anaŋ dupae oŋ dugo dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ak gug nal nek a lo Lot Sodom ibisei an, keit lo yak yai pat salfa ided dak da idug Sodom adi fidian ifu dumat a. ");
INSERT INTO tbc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tamol Nanun kuai isi wo dop nek ago mi digane wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Saen an lo dop tamol ta ab patun fo itor ak imul ab ilon lo iladup, iŋanen biouŋ isini wo ta igane na wa. Nek ago mi, tamol ta abi lo yak fon imul pe, ab lo yaup mel ta iŋane wo ta igane na wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot iwon igane yak ilom isou. ");
INSERT INTO tbc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Talpein ta iŋsen tinin o mi ilon isou tap, ideg yau a. Gug talpein ta siganen madok tan en lo ibisei dan, ta ideg yau na wa, tia, kumaen imado wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ŋai ŋurupaiaŋ da. Nal an lo, tidom pe talpein uraru galuŋ kisaek lo dien a, gug kisaek Tubun en iŋane dop, kisaek yen a. ");
INSERT INTO tbc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nek ago mi pein uraru sisem urat digane wa. Gamu nam kisaek iŋane dop, kisaek imado wa. ");
INSERT INTO tbc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nek ago mi tamol uraru abi lo dutor a. Kisaek iŋane dop, kisaek imado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ru an duloŋ go Jesus san megeloum dusumiani, “Tubun en. Kulob en dugot na ilasa wak i?” Agog Jesus ru naon irupidai, “Aben ate tubabun yen dan, antem bog dutumani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus megeloum dugudani oŋ dop dumado wa, ago dop ilod ta isali na wo ru faŋan ta irupidai a. ");
INSERT INTO tbc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iŋ ibol, “Panu ta lo tulek tamol ta imado dugo Anut niŋen o ta irer na da. Tamol dam niŋedi wo ta irut na da. ");
INSERT INTO tbc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aria, pein suos ak ta panu an lo imado ya. Iŋ pempem tulek tamol an san na yaup, iŋ ibinawip, iŋanen ager kot lo digane wo iduduwig, ibol: ‘Tamol ta ŋai iginiag saian. Agog kot lo ŋigane wo dak niŋen o oŋ ŋai binawag.’ ");
INSERT INTO tbc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Gug tulek tamol an saen kitek milaen mi pein suos an awan yabi an imoi. Agog yau na gug ilon lo ibol, ‘Rumok, ŋai Anut, iŋ tamolpein dam niŋedi wo ta ŋarut na da. ");
INSERT INTO tbc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Gug suos en ŋai aeg itog oŋ dak niŋen o gidad iŋanen kot lo ŋubinawi wa. Tia tap, igo igane oŋ dop, ŋai tuog imad a.’” ");
INSERT INTO tbc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Agog Jesus ru awan ibateg ibol, “Ru a tulek tamol saian ak ibol an aloŋ pe apupi ale wa. ");
INSERT INTO tbc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aŋ ilom dugo isou dak i? Ak dugo, Anut san pilianek tamolpein a tidom ad duwagiŋ dugo ibinawai o dusumiani dan, ibinawai o saen milaen imoi ak i? ");
INSERT INTO tbc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ŋai ŋurupaiaŋ da. Iŋ ririan ibinawaip iŋaned muruan ikubune wa. An lo iŋ talpein a muruan an ipidinai an naon ipani wa. Ak man dugo, saen Tamol Nanun imul dop, tan en lo ilo rumok adi wei mi yil ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus afon ru faŋan ta, tamolpein ensauta a iŋsed mi itaot dubol, sed yaŋad diabisa dugo tamolpein aenta metmet warou dubol dan igo ibol go irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamol uraru dugudani wo Juda sad ubou ab tubun ak lo diau a. Kisaek man Farisi. Neinta man takis ŋilaŋal tamol. ");
INSERT INTO tbc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi an imasag iŋsen niŋen o mi ilon lo igo igudani se ya, ‘O Anut, ilog uyan da. Man dugo, ŋai tamol aenta digane saian dan ago tia ya. Ŋai takis ŋilaŋal tamol igo tia ya. Ŋai ilosek ag tia. Ŋai ta ŋiraek na da. Ŋai jeit ta ŋabi na da. Ŋai tamol nuŋog mi a. ");
INSERT INTO tbc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ubou kisaek ilon lo nal uraru anaŋ geg ŋiganep ŋugudani da. Filiag an fidian ŋutumanip, malan 10 gup, malan kisaek ŋupano da.’” ");
INSERT INTO tbc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Gug takis ŋilaŋal tamol man, sen iparyanig, itakok go naon yabisag lak na abaŋ ile man irer. Iŋanen aupasek niŋen o ilon muruan go sen titiren ifunig ibol, ‘O Anut, ŋai aupasek tamol. Ak niŋen o ilo imuŋanag.’” ");
INSERT INTO tbc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ŋai ŋurupaiaŋ da. Anut malan lo man takis ŋilaŋal tamol en mi tamol itaot an. Ak gug Farisi man Anut malan lo ta itaot na ya. Man dugo, tamol ta iŋsen yaŋan yabisa tap, Anut iŋ yabi idu wa. Gug talpein a iŋsen yabi idu dan, Anut iŋ yabisa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tamolpein aenta nanuk kitiktik diŋal go Jesus banin lo didirai o dupalu se ya. Agog megeloum adi dil tag ru dabai nam dupudai a. ");
INSERT INTO tbc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ak man Jesus nanuk kitiktik igiaig, iŋsan na dupalug ibol, “Nanuk kitiktik akudai amoi. Abisawaip, ŋaisag na dupalu. Man dugo, Anut san kagin panek man tamolpein ilod nanuk igo yak sadi a. ");
INSERT INTO tbc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ŋai rumok ŋurupaiaŋ da. Talpein gidad Anut san kagin panek nanuk nanun igo woŋ iŋane wa. Tia dop, iŋsan kagin panek lo iladu san tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda tamol gurman ta Jesus isumiani, “Girek maŋau uyanan en. Ŋai dugo ŋiganep kumaen pempem san ŋiŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ago tag Jesus ru naon irupeig igo isumiani, “Ata wo ŋai uyag ubol dak i? Talpein ta uyan man tia ya, nek Anut mi iŋsen kisaek uyan a. ");
INSERT INTO tbc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oŋ kubiaeŋ fidian uloŋ: tamol sen ak iwon ugam pe ida jeit ta agane na wak, tamol ta funi imat na wak, gumagam ta gane na wak, kot lo supalek ru ta ubol na wak, tina tama awad paen na mado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Agog tamol an ibol, “Ŋai nanuk log ipalug gamu en, kubiaeŋ an fidian ŋuri ŋupani na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus ru an iloŋ tag irupei, “Oŋ mel kisaek lo mi katuk ama ya. Oŋsa filia fidian udad yau dop, moni an ŋanep, bigabeg adi pidinai a. Ago tap oŋ Anut san kumaen panu lo filia ama da wa. Ago gane gup, ŋai ŋieg abag uri wa.” ");
INSERT INTO tbc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tamol ru an iloŋ man ilon tubun mi muruan. Man dugo, iŋ filian tamol tubun geig a. ");
INSERT INTO tbc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus tamol an leil ipani dugo ibol, “Tamol filian anda man Anut san kagin panek lo iladu san man muruan geig a. ");
INSERT INTO tbc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aloŋ ak, tamol filian anda yak Anut san kagin panek aben lo ka iladu wan, rumok tap, aria, kamel dam si gubaran lo yau san man pasauman geig a.” ");
INSERT INTO tbc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tamolpein a Jesus ru ibol dugo duloŋ dan dusumiani, “Mago tap, ensauta mok mi Anut patud ipasip, kumaen pempem yen dan diŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ago tag Jesus ibol, “Mel a tamol digane san tia yan, Anut igane san iloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Agog Pita ibol, “Maŋ oŋ ŋie aban muri wo maŋanema ab, panu agod mel fidian mubusei a.” ");
INSERT INTO tbc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ago tag Jesus igo ibol go irupidai, “Ŋai rumok ŋurupaiaŋ da. Talpein ta Anut san kagin panek niŋen o iŋanen ab, iwon nanun, tein taon, agod tinan taman ibisawai tap, ");
INSERT INTO tbc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","saen e gamu yen dan lo Anut naon uyan a ipani wan tubun kasik a. Agod saen foun ak a murnap ilasa wan lo kumaen pempem yen dan iŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus megeloum 12 an iŋal go gigin na diaug, ago ibol irupidai, “Jerusalem na tau da. Ru fidian a profet adi gubak mi Tamol Nanun niŋen o digire yan nuŋon ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iŋ gob adi banid lo digane wa. Agop kukok an diganep, naon dufute dupei dop, tinin fo dulusu isudap, rasau nam dufuni nap, aigim fo dubalip imat a. ");
INSERT INTO tbc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ago digane wak man, nal utol itout gup, Anut ifufunip afon kumaen imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gug iŋanen megeloum ru a ibol an fun ta duloŋ na ya. Ru an fun mok mianuk lo yen. Ago dugo Jesus ata niŋen o ibol an fun mok diŋaoŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus Jeriko sumeik ipani dugo, tamol ta malan itau ak dal gigin te igod dugo imado. ");
INSERT INTO tbc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Saen tamolpein diriŋani dugo sad liliŋan iloŋ man, isumianai, “An ata mel ilasa dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ago dugo durupei, “Jesus, Nasaret tamol, amaiak yau da.” ");
INSERT INTO tbc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ago tag tamol an iwagiŋ, “O Jesus, Dawid Nanun, ilo imuŋanag!” ");
INSERT INTO tbc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Agog tamolpein a Jesus naon na imug diau dan dububuŋanig durupei, “Awa itaup tokubol pe mado!” Ago tag tamol an nen maeg nam iwagiŋ dugo isasai, “O Dawid Nanun, ilo imuŋanag!” ");
INSERT INTO tbc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ago tag Jesus ipartuanig mala itau an diŋane dupalu wo irupidai. Saen tamol an siŋiren na ipalu man, Jesus isumiani, ");
INSERT INTO tbc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Dugo ŋiginio wo ilo ibol di?” “O Tubun en, ŋai abaŋ ŋile wo ilog ibol da.” ");
INSERT INTO tbc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ago tag Jesus ibol, “Abaŋ ule. Oŋane ilo rumok ikubunio ya.” ");
INSERT INTO tbc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ago ibol dugo tamol an abaŋ ile kisaek oŋ a. Agog Jesus ŋien aban iri dugo Anut yaŋan yabisag yau a. Saen tamolpein an fidian ago dile man, iŋ dam Anut yaŋan diabisa ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus Jeriko taun ilon lo iladug yau dugo, ");
INSERT INTO tbc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","takis ŋilaŋal tamol gurman ta filian anda yak ante imado. Iŋ yaŋan Sakias. ");
INSERT INTO tbc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tamol an Jesus naon tinin ile wo yaes tubun mi ifuni. Iŋ tamol katukan, agod tamolpein wei kasik an lo iŋ Jesus ile san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ago tag imaspalug, inug yaug ai gurab ta yaŋan sikamor dubol dan isag, Jesus ile wo malan idu dugo imado, man dugo, Jesus dal an irig ipalu se ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Saen Jesus ai an fun na ilasa man, malan isudag Sakias ile tag irupei, “Sakias, ririan udu. Ŋai gamu oŋ da oŋsa ab lo tumado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ago tag Sakias ririan idug ilon uyan isag Jesus malan ipareg, iŋaneg iŋsan ab lo diau. ");
INSERT INTO tbc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tamolpein ago dile yan fidian ilod saian go fun diganeg duŋurŋur go dubol, “Iŋ aupasek tamol san ab lo ida diau a.” ");
INSERT INTO tbc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ak man ab log Sakias imasag Tubun en irupei, “Tubun en, uloŋ. Ŋaisag filiag ŋitarpalep, wadan tamolpein mel ad tia yak ŋupidinai a. Taida mi, tamol ŋirawai dugo sad na ŋagam na yan, iŋaned melmel ŋagam na yan naon ago mi ŋutumanip, malan iwoiwo ŋupidinai a.” ");
INSERT INTO tbc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ago tag Jesus ibol, “Gamu ab en san muroun Anut san patu pasek iŋane ya. Man dugo, tamol en dam Abraham malan kubulan ta. ");
INSERT INTO tbc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tamol Nanun tamolpein dideg diau la yan abaŋad ilep patud ipasip iŋal o ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesus Jerusalem sumeik ipani dugo, tamolpein ilod lo Anut san kagin panek kuai isi wo sumeik ago dubol. Jesus iŋsad kiŋ ilasa wo dak ilod isou se ya, ak man iŋ kiŋ ilasa wak san saen gamugo an niŋen o ru faŋan en ibol irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Tamol ta yaŋan anda yak kiŋ ilasa wo panu asau ak lo yau. Onte iŋ kiŋ digane gup fon imul pe sen naon na ipalu wa. ");
INSERT INTO tbc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yau o dugo iŋanen urat pinein 10 igiaig dupalug, 20 kina anen anen ipidinai dugo irupidai, ‘Moni en aŋanep urat apani yau dop ŋai ŋamul a.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Gug tamolpein a murnap iŋsan kagin panek paen na dumado wan, iŋ dile saian go dumado ya. Ago yak niŋen o tamol an yau dugo patun fo ru digane yaug dubol, ‘Maŋ tamol en maŋsama kiŋ ilasa wo man mamoi a.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ago bo man tamol an kiŋ ilasa ya, agog fon imul iŋsinanen na yau. Gamu nam urat pinein a moni ipidinai an igiaig naon na dupalu ya. Moni subuŋan taidam sapita diŋane yan iloŋ o isumianai. ");
INSERT INTO tbc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Urat pinein a malmalan ipalu yan ibol, ‘Tubun en, oŋ ŋai 20 kina panag an lo didaeŋ urat ŋiganeg, oŋane 200 kina subuŋan taidam ŋiŋane ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Kiŋ an irupeig ibol, ‘Oŋ urat tamol uyanan mok a, oŋane urat kagin pani uyanan a. Oŋ biabi kitik e bani lo ŋigane emaiak kagin pani uyanan a, amaiak niŋen o taun 10 bani lo ŋidiri da, gamu iŋsad tirnek tamol lasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Agog urat pinein neinta ipalug ibol, ‘Tubun en, oŋ ŋai 20 kina panag an lo didaeŋ urat ŋiganeg, oŋane 100 kina subuŋan taidam ŋiŋane ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Agog iŋanen tamol tubun en pinein an irupeig ibol, ‘Oŋ taun 5 bani lo ŋidiri da, gamu iŋsad tirnek tamol lasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Agog pinein tinin te ipalug ibol, ‘Tubun en, oŋane 20 kina ebo ya. Ŋai yamel kilaken lo ŋuminamig yen a. ");
INSERT INTO tbc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ŋai oŋ o ŋarer. Man dugo, oŋ tamol silei a. Oŋ abi san urat tamol sad silali naon ŋane da.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ago tag ru naon irupeig ibol, ‘Oŋ urat pinein saia geig a. Ŋai oŋsigane ru ubol an nam ŋukubianop ŋile wa. Oŋ uloŋ ak, ŋai abi san urat tamol sad silali naon ŋiŋane da. ");
INSERT INTO tbc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Fun an niŋen o ŋaineg moni an moni ab san urat tamol pani ak man, iŋ ka urat ipani wa, an lo saen ŋai ŋamul dop moni an san tim an da ŋiŋane wa. Ata wo oŋ ago ta gane na yak i?’ ");
INSERT INTO tbc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Agog kiŋ an idaŋsag tamol a siŋiren na dutur dan irupidai, ‘Tamol en san na 20 kina aŋanep urat pinein a 200 kina aman da yan apani.’ ");
INSERT INTO tbc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Agog tamol a ru an duloŋ an durupei, ‘Tubun en, tamol an moni idaisuda mi yabi da, 200 kina aman da la ya!’ ");
INSERT INTO tbc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ak gug kiŋ an ru naon igo ibol go irupidai, ‘Talpein enti iŋ da yan, ŋai suguan taidam ŋupanip an lo iŋ idaisuda wa. Ak man, enti iŋ tinin lo tia agod, gidad iŋ kitek da bo man, iŋsan melmel an banin lo dupasi itout a. ");
INSERT INTO tbc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aria, ŋaisag ager adi ensauta a ŋai iŋsad kiŋ ŋilasa san o dumoi an, aŋal dida apalup, ŋai naog na afup dumat a.’” ");
INSERT INTO tbc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus ru an ibol itout go imug Jerusalem na yau. ");
INSERT INTO tbc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Did Oliv fo itor go panu uraru yaŋadi Betfage iŋ Betani da sumeik dugo, iŋanen megeloum nuŋod urarum idinaig naon na dumug diau a. Ago dugo ru kagin igo irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Aŋ nuŋom urarum panu o tile dan ante au a. Aup doŋki nanun ta dususeg itur dak ante ale wa, talpein ta gubak mi fufo imasi man tia ya. Doŋki nanun an kam apasip aŋanep ŋaisag na apalu. ");
INSERT INTO tbc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tamol ta ru aman da dop, aŋ igo arupei, ‘Tubun ak urat ipani wo da.’” ");
INSERT INTO tbc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Agog diaug melmel fidian Jesus ibol ago mi dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Saen doŋki nanun an san kam dusupasi dugo, muroun ipalug isumianai, “Ata wo doŋki nanun en apasi dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ago dugo ru naon durupei, “Tubun ak urat ipani wo da.” ");
INSERT INTO tbc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Agog doŋki nanun an diŋaneg, Jesus san na dupalu ya. Agog doŋki nanun an patun fufo kulos duruwarig, Jesus dubunawig fo isudag imasig diau a. ");
INSERT INTO tbc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesus dal na yau dugo tamolpein malan tubun geig an iŋsiganed kulos milae milae ak dupasi dugo dal te duruwari se ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Saen Jesus Jerusalem sumeik ipani dugo Did Oliv fo dal nok idu an lo iŋanen megeloum malan tubun, fun diganeg yousai lo Anut yaŋan diabisa dugo muguruŋ dupani se ya. Man dugo, iŋ kulob girager wei kasik a Jesus gubak mi igane se yan dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iŋ igo dubol, “Kiŋ e Anut yaŋan lo ipalu den bar iŋane ya! Kumaen panu na maror yen. O Anut per lak na geig ak per mupano da!” ");
INSERT INTO tbc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Agog tamolpein an luluŋad lo Farisi aenta dutor dan ru an duloŋ dugo dumasa saian go Jesus dupei, “Girek maŋau, oŋsa megeloum pidaip awad itau!” ");
INSERT INTO tbc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Gug Jesus ru naon igo irupidai, “Ŋai ŋurupaiaŋ da. Iŋ dutokubol san tia ya. Iŋ awad itau tap, pat e dien dan naod diŋanep per dupanag a!” ");
INSERT INTO tbc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Saen Jesus Jerusalem sumeik ipanig ile man, ilon tubun mi muruan go malan turon idug, ");
INSERT INTO tbc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","igo ibol, “Oŋ saen en lo mi maror san dal uloŋ ak man, muruan a oŋsa na ipalu dan ta ilasa na wa. Ak man gamu dal an imianuk go oŋ ule san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Oŋsa saen ipalu wa. Ager adi dubuluwop oŋ giraŋe ananae mi lo dupalup, tan dufutip oŋsa sep giraŋen na dutumanip lo diladu san dal digane wa. Gigin fidian lo dupalup dubuluwop dupino wa. ");
INSERT INTO tbc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Iŋ dufunop daoŋ dupano wa, agod tamolpein a oŋsa sep ilon lo dumado dan dufu yaup fidian dumat a. Oŋsa pat ta kisaek o lian pat sen ak tinin fufo na ta yen na wa, tia, oŋsa pat fidian dugufututep diabibol tan na dudu wa. Fun dugo, oŋ saen a ate Anut ŋai tinig lo oŋsa na ipalu yan ta ule uloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus tempel san ar ilon lo iladug, aben ante didaeŋ tamol fidian ikudaig patun fo dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iŋ igo ipidai, “Anut san buk lo ru en digire ya, ‘Ŋaineg ab man gudanek san ago dubol a,’ ak man aŋ agane ilasag ‘gumagam adi sad mianuk ab’ igo agane da.” ");
INSERT INTO tbc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nal fidian Jesus tempel san ar lo iladug tamolpein maŋau ipiteŋanai se ya. Ago dugo pris gurman adi, kubiaeŋ san girek maŋau, agod tamolpein sad gurman dufuni imat o dal abaŋ diabi wo digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ak man iŋ dufuni imat san dal ta dile man tia ya. Man dugo, tamolpein fidian iŋsan ru duloŋ o tubun mi dumat. Iŋsan ru samukan ta iriŋanai san man dumoi. ");
INSERT INTO tbc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nal ta Jesus tempel lo tamolpein naod na Anut san ru ifulale dugo maŋau ipiteŋanai se ya. Agog pris gurman adi, kubiaeŋ san girek maŋau, agod matu gurman aenta dida dupalug Jesus dusumianig dubol, ");
INSERT INTO tbc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Oŋ rupaiama. Oŋ enti san dabai lo melmel en gane dak i? Enti mok dabai en ipanog ate urat en gane dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iŋ ru naon igo irupidai, “Ŋai dam mel ta niŋen o ŋusumianaŋ o da. Arupaiag, ");
INSERT INTO tbc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon san suguek man, dugon te kagin an iŋane yak i? An kumaen panu san mel, tia, tamol sad mi ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Agog iŋsed nug lo igo diŋiŋeŋ se ya. “En kumaen panu san mel, ago tabol tap, iŋ igo ibol isumianad a, ‘En ata wo aŋ iŋ niŋen o ilom ta rumok na yak i?’ ");
INSERT INTO tbc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ak gug ‘En man tamol sad mel mi a,’ ago tabol tap, tamolpein malan tubun en pat nam dufunad a. Man dugo, iŋsad ilo sou lo man Jon mi iŋ profet, ago dubol da.” ");
INSERT INTO tbc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ago yak niŋen o Jesus ru naon durupeig dubol, “Enti mok dabai an ipani an maŋ ta maloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ago tag Jesus ibol, “Ago yak niŋen o ŋai dam enti mok dabai en ipanag go ate melmel e ŋigane den, ta ŋurupaiaŋ na wa.” ");
INSERT INTO tbc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Agog Jesus awan ibateg tamolpein ru faŋan en irupidai, “Tamol ta abi yabig lo ai wain patun ipae. Agog tamol an iŋsan fun panu ibiseig asau mi yau o tag, abi an tamol sen ak ta banid lo kagin dupani wo igane ya. Agog panu ibiseig yaug saen milaen mok itor na ya. ");
INSERT INTO tbc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Agog saen wain nuŋon disini wo dugo, abi taman iŋsan urat pinein ta iŋsinanen panu fun lo idinig yaug, iŋanen ŋutun dupanip isini ipalu wo ibol. Ak man abi titianek adi iŋsan urat pinein dufunig banin kawan didinig imul yau. ");
INSERT INTO tbc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ago tag urat pinein sen ta idinig yau. Agog urat pinein an dam dufunig isudag miai dupani nag banin kawan didinig imul yau. ");
INSERT INTO tbc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ago tag afon urat pinein ta idinig yau, gug urat pinein an dam madai dupanig dubal abi patun fo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ago tag abi taman igo ibol, ‘Dugo ŋigane wak i? Gidad ŋaisiganeg nanug mok niŋen o tubun mi ŋamat dan ŋidinip yau a. Nap iŋ awan diabi ak boi.’ ");
INSERT INTO tbc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ak man saen abi titianek adi iŋanen nanun dile tag dubol, ‘An abi taman amaiak nanun ak niŋen tufuni imat dop, iŋsan furan id tiŋane wa!’ ");
INSERT INTO tbc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ago tag diabig, ar patun fo dubal ilasag, dufunig imat a. “Ago yan lo abi taman an, titianek tamol adi an dugo mok iginiai ak i? ");
INSERT INTO tbc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Abi taman sen yaup tamol an ifu dumat dop, abi an tamol sen ak banid lo iganep kagin dupani wa.” Tamolpein a ru an duloŋ an dubol, “Ago tia!” ");
INSERT INTO tbc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Agog Jesus malan ti ibol go tamolpein an leil ipidinai dugo isumianai, “Ru e Anut san buk lo digire en fun dugo woŋ ak i? ‘Pat nek a ab bek tamol adi dumoi dan, nek amaiak ab tinin fidian yabi sakar da.’ ");
INSERT INTO tbc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Talpein ta iŋ pat en fo na yau idu dop man, sen ifuni ititale wa. Ak gug talpein ta pat en kabuŋan fufo idu tap, ifufari idu wa.” ");
INSERT INTO tbc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Saen pris tutubu agod Farisi adi, Jesus ru faŋan a ibol se yan duloŋ man, Jesus ririan diabi wo maeg diganeg dal abaŋ dile se ya. Man dugo, iŋ duloŋ uyanan ak Jesus iŋanen ru lo iŋ isiai se ya. Ak man tamolpein malan tubun ak niŋedi wo direr a, an lo ta diabi na ya. ");
INSERT INTO tbc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ago tag iŋ nal fidian Jesus leil dupani uyanan se ya. Iŋ leil tamol ta didinaig Jesus san na dupalu. Iŋ tamol nuŋon manoŋ, ak gug Jesus san ru lo diabi wo malad digane se ya. Iŋ ŋudun dusuep sumianek dupanip, ru ta ibol saian dop gabman banin lo digane wo dal an digane. ");
INSERT INTO tbc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Agog leil tamol an Jesus dusumiani, “Girek maŋau, maŋ maloŋ, oŋsa ru ubol dugo piteŋanama dan fidian rumok a. Oŋ tamol yaŋad anda yak niŋedi wo ta urut na da. Tia, oŋ Anut san dal mi tamolpein fidian maŋau piteŋanai da. Gidad yaŋad da yak, agod yaŋad tia yak dam mi a. ");
INSERT INTO tbc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ak dugo, Kaisa takis moni tupani wan uyan ak i? Tia, saian ak i? Oŋ dugo ilo isou dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Gug Jesus iŋ dirawi wo digane dan iloŋ tag irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni patun ta akubiaip ŋile gup. Mitilaen agod yaŋak e fufo digire yan enti san ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Agog iŋ dubol, “Kaisa san.” An niŋen o irupidai, “Mago tap, mel a Kaisa san an Kaisa apani. Agod mel a Anut san an Anut apani.” ");
INSERT INTO tbc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iŋ malak malak mel ta lo dirawi dop diabi san tia ya. Iŋsan ru naon ago duloŋ go durut saian tag awad itau. ");
INSERT INTO tbc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi aenta Jesus san na dupalu. (Iŋsad ilo rumok lo ago dubol da: Tamolpein dumat dop, fon ŋutud kumaen dumasa san tia ya.) ");
INSERT INTO tbc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Iŋ Jesus ago dusumiani, “Girek maŋau, Moses wagam mi kubiaeŋ igo igire panad a, ‘Tamol ta iŋ iwon da gug nanuk ad tia dumado yau nap, tamol ak imat. Ago tap tamol an tein bakan ak fon pein an iŋanep, tein matu an iŋsan nanuk idirsi wa.’ ");
INSERT INTO tbc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aria, id luluŋad lo tamol ta iŋ nanun 7. Matu ak pein iŋane gug nanuk ad tia dumado dugo tamol an imat. ");
INSERT INTO tbc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ago tag tein bakan an fon tein san pein an iŋane gug tamol an dam imat. ");
INSERT INTO tbc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tein a tinin te yan dam nek ago mi a. Agog tamol 7 an tet mi nanuk tiag, dumat pasik. ");
INSERT INTO tbc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Murnag pein an dam imat. Tamol 7 an ago mi tet mi pein kisaek an mi diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ak niŋen o, dugo, mitep saen tamolpein fidian dumat an kumaed dumasa dop, pein an tamol dugon mi ida dumado wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ago tag Jesus ru naon irupidai, “Pein tamol saen en san nug diŋane da, agod tamol adi ŋiedi dupidinai da. ");
INSERT INTO tbc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ak gug tamolpein ensauta a Anut malan lo saen murna san ak lo diladu san, agod mateŋ lo fon kumaen dumasa san, iŋ idaisuda yan, aben ante nug ta diŋane na wa, ago dop tamol adi pein ŋiedi ta dupidinai na wa. ");
INSERT INTO tbc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iŋ ibol eŋel adi oŋ, an lo fon dumat san tia ya. Iŋ Anut nanun muroun. Man dugo, iŋ mateŋ log fon kumaen dumasag dumado da. ");
INSERT INTO tbc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses dam kuai tem ikubiai panaŋ, tamolpein a dumat an fon kumaen dumasa da wa. Man ata wo? Ai nanunan yai inani an san sai lo, Moses Anut niŋen o igo ibol, ‘Abraham, Aisak, Jakob sad Anut.’ ");
INSERT INTO tbc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anut man iŋ tamol a mateŋ lo dumado dan sad Anut tia ya. Tia, iŋ man tamol kumaed dumado dak sadi a. Man ata wo? Iŋ malan lo tamolpein fidian kumaed dumado da.” ");
INSERT INTO tbc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ago dugo kubiaeŋ san girek maŋau aenta Jesus ibol ago duloŋ go durupeig dubol, “Ru naon uyanan mok, girek maŋau!” ");
INSERT INTO tbc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","An lo gug Jesus sumiaeŋ subuŋan taidam dusumiani wan niŋen o direr se ya. ");
INSERT INTO tbc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Agog Jesus isumianai, “En dugo woŋ go tamolpein Kristus iŋ Dawid nanun dubol dak i? ");
INSERT INTO tbc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawid iŋsen Isrel bar san buk lo igo ibol, ‘Tubun en ŋaisag Tubun ak igo irupei, “Oŋ ŋai tuog won ak ate masip yaup, ");
INSERT INTO tbc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","murna gup ŋai oŋsa ager adi ŋidiraip, oŋ ŋie pae na dumado dop ŋie nam partuanai a.” ’ ");
INSERT INTO tbc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawid iŋsen mi iŋ Tubun ak ago ibol tap, en dugo woŋ pe iŋ Dawid nanun ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tamolpein fidian duloŋ dugo, Jesus iŋsan megeloum ru kagin igo irupidaig ibol, ");
INSERT INTO tbc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kubiaeŋ san girek maŋau niŋedi wo kagin agane. Iŋ kulos milmilae ak didiri duman, tamol dil o digane da. Didaeŋ aben lo tamolpein ‘adian’ dupidinai ak niŋen o tubun mi dumat da. Iŋ ubou ab lo kalik malan te yak niŋen o dumat da, agod soubul lo dam nek ago mi a. ");
INSERT INTO tbc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iŋ pein suos sad ab digam da, agod gudanek milaen kasik, tamolpein diliai o digane da. Amaiak niŋen o tamol naok ago yan naon a diŋane wan nen tubun mi ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus tempel lo imado dugo malan yaug, tamol filiad anda yak tempel ilon lo kolekta san kunup lo moni digane dugo yil a. ");
INSERT INTO tbc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Agog pein suos biouŋ tia yak iŋ dam ipalug pat bras uraru mi kunup lo ibal a. Moni an naon man tusan mok. ");
INSERT INTO tbc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ago tag Jesus ibol, “Ŋai rumok ŋurupaiaŋ da. Pein suos an moni kolekta igane yan kolekta a tamol filiad anda yak digane yan fidian iriŋanai a. ");
INSERT INTO tbc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Man dugo, fidian iŋ filiad anda yak gug kabelan mi kolekta digane dugo iŋaned fidian mi yen da. Gug pein suos an sen aben ipitig fidian kolekta lo igane ya.” ");
INSERT INTO tbc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iŋanen megeloum aenta tempel san pat uyan uyan ak, agod melmel Anut lou dupani na yan nam damag dupani an niŋen o diŋiŋeŋ tag Jesus ibol, ");
INSERT INTO tbc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mel fidian ale dan man, saen ipalu dop, lo pat ta pat sen ta tinin fufo ta yen na wa. Tempel san pat fidian dugufututep diabibol tan na dudu wa.” ");
INSERT INTO tbc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ago tag dusumiani, “Girek maŋau, saen dugon lo dop mel an ilasa wak i? Mitep ata kob mile dop ate maloŋ ak saen an ipalu wo sumeik di?” ");
INSERT INTO tbc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iŋ ru naon irupidaig ibol, “Aŋ kagin agane. Iŋ aŋ dirawaŋ banau. Man dugo, mitep tamol wei mok ŋai yaŋag lo dupalup dubol, ‘Ŋai tamol nek ama ya,’ ago dop dam dubol, ‘Saen a ate ipalu wan sumeik ipanad da.’ Ago dop iŋsad sewak an ta ari na wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aŋ yu ager aloŋ ak, agod ru tim yu ager sensen yau oŋ an dam aloŋ a. Aŋ arer amoi. Man dugo, mel naok an imug ilasa wa, ak gug nal wadan san saen man gamugo da.” ");
INSERT INTO tbc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Go iŋ afon ru ibateg ibol, “Tamol malan ta yu diabisa dop, tamol malan ta yu naon iŋsad na digane imul a. Ago dop kiŋ ta iŋsan tamolpein dida yu diabisap, kiŋ sen ak ta iŋanen tamolpein dida nug dufuni wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aben sensen lo man, kanaurig tutubu yak wei mi ilasa dop, kadag tubun mi idu wa. Subam tubun mi aben sensen lo ilasa wa. Ago dop kulob arer san wei mi dilasap, keit lo kob tutubu yak dilasa dop diganep arer a. ");
INSERT INTO tbc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ak man melmel an fidian gamugo ilasa dop, ŋai niŋeg o aŋ dibiaŋ pe, madai iŋ muruan da dupanaŋ a. Ŋai yaŋag o Juda sad ubou ab lo Juda gurman adi naod na diŋiliaŋ aup, kot dupanaŋ dop subanek ab lo diginiaŋ a. Kiŋ iŋ gabman gurman aenta naod na dam kot lo atur a. ");
INSERT INTO tbc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Saen an lo dop iŋaned naod na aŋanem ilo rumok ŋai lo abol ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Saen gamugo naod na alasa dop, ata ru arupidaip an lo sem ipiranaŋ san niŋen o ilom ta weiwei na wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Man dugo, ŋai aŋ ru abol san kankan milaen ak ŋupanaŋ a. An lo dop aŋsam ager adi iŋ ru abol an iŋ naon dubol san tia wa, ago dop iŋ dam aŋ awam lo dupirgini san tia wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tinam tamam, teim taom, aŋanem dar, agod turam muroum dam ager adi banid lo diginiaŋ pe, aŋ aenta dufunaŋ amat a. ");
INSERT INTO tbc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamolpein fidian ŋai yaŋag o aŋ diliaŋ saian dop aŋ lo siai digane wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ak gug gurmam roun ta kisaek ideg yau san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tia, aŋ atur dabai dop muruan fidian asini dan lo mi, kumaen pempem yen yau san aŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mitep yu tamol adi dutumanip Jerusalem ditiliani dop eil a. Ago ale dop aloŋ ak, Jerusalem daoŋ dupani san saen sumeik da. ");
INSERT INTO tbc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Saen an lo dop, tamolpein Judea na dumado dan disol pe, diaup, did luluŋad lo sed imianai a. Ago dop, tamolpein a Jerusalem ilon lo dumado dan ririan patun fo dilasap dusol diau a, agod a Jerusalem patun fo dumado dan iŋ afon ilon lo ta mok diladu na wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Man dugo, nal nek an lo, Anut Jerusalem tamolpein sad aupasek naon ipidinai a. An lo dop ai wadan a Anut san buk lo digire yan fidian nuŋon ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","O kabel, nal en san pein luam anda yak, agod aŋ pein aŋanem nanuk su apidinai dan dam, ŋai ilog tubun mi imuŋanaŋ da! Muruan tubun geig tan en lo ilasa dop, tamolpein ente dumado den Anut san tiŋae mumarek dile wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aenta ager adi sabiri nam dufu dumat a. Aenta iŋsad ager adi diŋal pe, subanek tamol dilasap tan asau mi sensen lo diaup ante dumado wa. Agop gob adi Jerusalem diŋanep dipartitale dop yaup nal a lo gob adi sad saen itout san nal an idaisuda wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Saen wadan sumeik dop, ad, kalam, patui lo kob funfun ilasa wa. Tan na tamolpein fidian tubun kasik direr dop ilod weiwei a. Man dugo, beig ibalsini dop tamun dam san liliŋan tubun kasik a. ");
INSERT INTO tbc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tamolpein fidian ata mel mok tan en lo ilasa wo sumeik dan niŋen o yaes tubun mi ifu dop, tinid irer dop, rirek lo malad itilianip dudu wa. Man dugo, Anut mel fidian keit lo yak imiriranai a. ");
INSERT INTO tbc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Saen an lo dop, iŋ fidian Tamol Nanun keit lo timtaen titiŋaem kuai te ilasa dop, dabai agod girager tubun geig ak da ipalu dan, dile wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Saen melmel an ago fun diganep dilasa dop, amasap mala nouk lo malam lak na isuda wa. Man dugo, Anut iŋiliaŋ san saen sumeik mok ipalu da.” ");
INSERT INTO tbc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Agog Jesus ru faŋan en irupidai, ");
INSERT INTO tbc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Ai gurab iŋ ai aenta dam ilom isou. Saen ai roud wagam ak idu dop, foun ak ifurŋani dan ale dop, aloŋ ak, ui san saen sumeik a. ");
INSERT INTO tbc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nek ago mi melmel an dilasap eil dop aloŋ ak, Anut san kagin panek ipalu o da. ");
INSERT INTO tbc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ŋai rumok ŋurupaiaŋ da, warou gamu en san tamolpein gamugo itout yau dop melmel en fidian dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Rumok geig, keit iŋ tan da murnap itout a, ak gug ŋaisag ru man ta itout na wa. ");
INSERT INTO tbc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ago yak niŋen o kagin agane! Tamol Nanun ipalu wak san nal ta aloŋ na ya. Ak niŋen o soubul san kankan tubun mi agane amoi. You sakar ak tubun mi aluk amoi. Agod tan en san mala bulbal lo mi amado amoi. Kabelan aŋaoŋ dop nal an idu kisaek oŋ banau. ");
INSERT INTO tbc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nal an tamolpein a fidian tan tilianek aten fo dumado dan lo ilasa wa, iŋ diŋaoŋ dop nal an idu wa, ago dop nal an san muruan niŋen o disol diau san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ago yak niŋen o aŋ pempem nal an atitiani dop abaŋ ale wo uyanan a. Ago dop aŋ pempem Anut agudani dop lo, muruan a fidian dilasa wan niŋen o ka asol aup, Tamol Nanun naon na atur a.” ");
INSERT INTO tbc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nal anen anen atem Jesus tempel san ar ilon lo tamolpein maŋau ipiteŋanai se ya, agog gurai idug bubun a Did Oliv dubol dan fo yaug ante ŋioŋ yabi se ya. ");
INSERT INTO tbc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tamolpein fidian tidom lom mok iŋsan ru duloŋ o tempel lo diau na ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret yis an tia yak san soubul, yaŋan Pasova, san saen sumeik. ");
INSERT INTO tbc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Saen an lo pris gurman adi iŋ kubiaeŋ san girek maŋau dida tamolpein niŋedi wo direr ak niŋen o pasak nam Jesus dufunip imat o palaŋ an dumari a. ");
INSERT INTO tbc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Agog Judas yaŋan neinta Iskeriot dubol dan, Satan ilon lo idu ya. Iŋ dam Jesus san megeloum 12 amaiak sad kisaek ta. ");
INSERT INTO tbc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Agog Judas yaug, pris gurman adi iŋ tempel san titianek tamol sad gurman adi dida diŋiŋeŋ go dal dugon lo Jesus banid lo igane wan ibol duloŋ. ");
INSERT INTO tbc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Agog pris gurman adi ilod tubun mi uyan go Judas moni dupani wak dubol. ");
INSERT INTO tbc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas awad yabi tag tamolpein malad patun fo Jesus ager banid lo igane san dal abaŋ yabi se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bret yis an tia yak diani san saen idu dugo, sipsip nanun Pasova san saen lo diani san dufu idu. ");
INSERT INTO tbc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Agog Jesus Pita iŋ Jon da idinaig, ru kagin en irupidai, “Aup, idsad Pasova san anaŋ akubune.” ");
INSERT INTO tbc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ago tag dusumiani, “Dugot na mok anaŋ mukubune wo ubol di?” ");
INSERT INTO tbc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Agog iŋ irupidai, “Saen aŋ Jerusalem ilon lo aladu dop, tamol ta you isiri ak isini yau dan ale wa. Ŋien aban arip, ab dugon lo isuda tap, ");
INSERT INTO tbc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ab an taman asumianip arupei: ‘Girek maŋau igo ibol, galuŋ dugon lo ŋaineg megeloum dida maŋsama Pasova anaŋ an mani wak i?’ ");
INSERT INTO tbc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ago dop galuŋ tubun ak ta lak na yak ikubiai panaŋ a. Aŋ atna melmel fidian akubune.” ");
INSERT INTO tbc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tamol uraru an diaug, mel fidian Jesus ibol ago mi dile ya. Ago tag galuŋ ante Pasova san anaŋ dukubune se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Anaŋ diani san saen idu dugo Jesus tebol siŋiren na iŋanen megeloum dida dumasi. ");
INSERT INTO tbc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Agog irupidai, “Ŋai gamugo muruan ŋisini dop aŋ da Pasova san anaŋ en tani wo ilog tubun mi yen da. ");
INSERT INTO tbc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Man dugo, ŋai ŋurupaiaŋ da, ŋai fon aŋ da Pasova ta tani na dop yaup, Anut san kagin panek aben lo, mel a Pasova naon iŋane wan san nuŋon ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Agog Jesus gab wain anda yan iŋaneg, Anut ilo uyan ipanig ibol, “En aŋanep aŋsem nug lo awae. ");
INSERT INTO tbc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Man dugo ŋai ŋurupaiaŋ da, ŋai fon ai wain nuŋon san you man ta ŋaluk na dop yaup, Anut san kagin panek ipalu gup, fon ŋaluk da wa.” ");
INSERT INTO tbc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ago ibol itout go bret iŋaneg, Anut ilo uyan ipanig yafuteg, ipidinai dugo ibol, “Bret en ŋaineg tinig, ŋai aŋ niŋemi wo ŋiganeg idu ya. Aŋ ago agane dop ŋai ilom isou.” ");
INSERT INTO tbc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nek ago mi anaŋ diani itout go, gab iŋane yabig igo ibol, “Gab en man kontrak foun ŋaisag dar lo ya. Dar en aŋ niŋemi wo ŋaineg tinig lo yak ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Gug aloŋ. Aŋ luluŋam lo tamol ta ŋai ager banid lo iginiag an banin, ŋai banig da tebol en fo dien da. ");
INSERT INTO tbc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tamol Nanun imat a, nek ibol Anut mi iŋ niŋen o ibol ak ago mi iŋ lo ilasa wa. Ak gug tamol enti a Tamol Nanun iganep iŋanen ager adi sad tuod lo ilasa wan, rumok iŋ muruan tubun kasik ak ile wa!” ");
INSERT INTO tbc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Agog iŋsed nug dusumiani, “Enti mok ago Jesus lo igane wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Agog megeloum iŋsed iŋsed mi enti mitep iŋ yaŋan malan te yen ak niŋen o nug diabi didiri se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus ago iloŋ tag irupidai, “Gob adi luluŋad lo iŋaned kiŋ adi sed idiraip lak na mok disuda dop tamolpein ditirnai o digane wa. Agod tamolpein sad tamol tutubu yan, iŋsed tamolpein sad binawek tamol ago dubol da. ");
INSERT INTO tbc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gug aŋ man dal ago tia ya. Ŋai ŋurupaiaŋ da, luluŋam lo ta iŋ tubun imado wak tap, sen irae imul pe murna imado wa. Ago dugo ta iŋ gurman imado tap, iŋ ibol urat pinein oŋ ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ago yak niŋen o enti iŋ tubun ak i? Tamol a tebol siŋiren na imasig anaŋ yani dan, agod biabi ŋilaŋal tamol enti tamol an anaŋ ipani dan, luluŋad lo enti malan te imado di? Aŋ aloŋ ak, tamol a tebol siŋiren na imasig anaŋ yani dan malan te ya. Aria, ŋai aŋ luluŋam lo ŋupalug biabi ŋilaŋal tamol igo woŋ ŋilasag ŋumado da. Ŋai mi aŋanem tutuŋanek tamol ŋumado da. ");
INSERT INTO tbc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aŋ ŋai ta abisawag na ya, tia, muruan a fidian ŋisini se yan lo aŋ ŋai da sisem tatur kisaek a. ");
INSERT INTO tbc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ago tag nek ibol ŋaineg Tamag iŋsan tamolpein ŋitirnai san dabai ipanag ak igo, ŋai dam dabai ŋupanaŋ a, an lo dop ŋaisag tamolpein atirnai a. ");
INSERT INTO tbc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ago dop ŋaineg kagin panek aben lo, aŋ ŋai da ŋaineg badim fo tumasip tani taluk a. Ago dop aŋ anen anen tulek tamol alasap, kiŋ san kalik fo amasip, Isrel sad gugoi 12 an akubianaip eil a.” ");
INSERT INTO tbc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Agog Jesus Pita irupei, “O Saimon, Satan aŋ fidian ikibianaŋ ile wo Anut isumiani la ya, agod Anut awok ipani a. Satan ilon man nek ibol wit dufufarig lo dukubiani uyanan dak igo aŋ fidian naom ikubiani ile wo ibol. ");
INSERT INTO tbc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gug Saimon, ŋaisag gadiŋ lo oŋane ilo rumok ta idu geig na wak ago Bai ŋusumiani a. Saen ŋaisag na umul dop, oŋane tei iŋaned ilo rumok an dabai pani wa.” ");
INSERT INTO tbc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Agog Pita ibol, “Tubun en, ŋai ta ŋasuk ŋamul na wa, tia, ŋai oŋ da sisem subanek ab lo taup, sisem tamat a.” ");
INSERT INTO tbc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ago tag Jesus ru naon igo irupei, “O Pita, ŋai rumok ŋurupaio da, gamu tidom nek en lo kurek ta ibob na dop, saen utol oŋ ŋai ta uloŋ na yak ubol a.” ");
INSERT INTO tbc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Agog Jesus isumianai, “Saen ŋai ŋidinaŋ go, moni san badam, kitouk, sendal tia au dugo, mel ta lo katuk ami ak i?” Iŋ ru naon durupei, “Man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Agog Jesus irupidaig ibol, “Ak gug gamu man, aŋ moni san badam am da tap, asini wa. Kitouk dam nek ago mi. Agod aŋ sabiri am tia tap, aŋanem kulos didaeŋ lo adirip moni aŋanep ate sabiri adad a. ");
INSERT INTO tbc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Man dugo, ru e profet ta ŋai niŋeg o ago igire yen nuŋon ilasa wa, ‘Tamolpein tamol an diŋaneg tamol a digane saian dan luluŋad lo digane ya. Nek ago mi tile ya.’ Rumok nuŋon, ru a ŋai niŋeg o profet adi digire yan fidian gamu nuŋon ilasa wo da.” ");
INSERT INTO tbc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Agog megeloum durupeig dubol, “Ule, Tubun en, sabiri uraru ebo ya.” Iŋ ru naon irupidai, “An nek idaisuda mi a.” ");
INSERT INTO tbc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Agog Jesus Jerusalem ibiseig, Did Oliv fo yau na yak ago mi fon yau dugo iŋanen megeloum ŋien fo diau a. ");
INSERT INTO tbc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Saen aben ante dilasa man, Jesus megeloum irupidai, “Aŋ Anut agudani dop, kubianek lo ta adu na wak o asumiani.” ");
INSERT INTO tbc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Agog Jesus ibisawaig kitek asau mi yau gug turun isaluwig igudani, ");
INSERT INTO tbc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O ŋaineg Bai, ilo ibol tap, gab en ŋai banig lo pasi wa. Ak gug oŋ ŋai ilog ta uri na wa, tia, oŋsigane ilo mi uri wa.” ");
INSERT INTO tbc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Agog eŋel ta lak na idug Jesus dabai ipani. ");
INSERT INTO tbc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ilon muruan an lo tubun mok igudani dugo iŋsan silali an dar oŋ naon tinin fo ilasag tan na idu se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Igudanig itout man imasag, imul yaug iŋsan megeloum dien dugo yil. Megeloum an ilod tubun kasik muruan an lo tinid tuon tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ago tag irupidaig isumianai, “Aŋ ata wo aen di? Amasap, agudani dop, kubianek lo ta adu na wak niŋen o Anut asumiani.” ");
INSERT INTO tbc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus ago ibol se man, tamol malan tubun ak dupalug naon na dilasa. Megeloum 12 an luluŋad lo ta yaŋan Judas, iŋ malan an imug go ipalu ya. Iŋ ilon yen dak Jesus musuk ipani wa. Ago tag yaug, ");
INSERT INTO tbc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesus san na ilasa yak gug Jesus irupei, “Judas, oŋ musuk lo Tamol Nanun ager banid lo gane wo di?” ");
INSERT INTO tbc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Agog megeloum a Jesus dida diau an, kagin dugo ilasa wo ago dile tag Jesus dusumiani, “Tubun en, ilo dugo ibol da, maŋsama sabiri nam mafu wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Agog luluŋad lo tamol kisaek sabiri ifug pris gurman san biabi ŋilaŋal pinein kududon won ak isubari. ");
INSERT INTO tbc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ak man Jesus ibol, “Kagin an fon ta gane na wa.” Agog iŋ tamol an kududon isupurig, kududon uyan isusa da ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Agog Jesus pris gurman adi, tempel san titianek tamol sad gurman, agod matu gurman aenta dida Jesus diabi wo dupalu yan isumianai, “Enta wo aŋ sabiri iŋ ai tok da asinig aliag pe abiag o apalu yak i? Ak dugo, ŋai wagai adi dida gabman mabi idu san gurman igo woŋ aŋ ago ilom isou di? ");
INSERT INTO tbc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nal fidian ŋai tempel aben lo ŋumasi dugo tamolpein ŋipiteŋanai se ya, ak gug ŋai ta abiag na ya. Gug gamu en tidom tubun ak lo man aŋsam saen a, man dugo, tidom tubun san tuon man Satan.” ");
INSERT INTO tbc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Agog Jesus diabig, pris malan te yak san ab lo diŋane diau dugo Pita ŋied fo ipare murna dugo yau. ");
INSERT INTO tbc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yai ab naon na dutunig, tamol tinid isue dugo Pita dam yaug dida dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ago dugo urat pein ta ipalug, malan ti ibol go, Pita yai san lilaman lo imasig imado dan ile dugo ibol, “Tamol an dam Jesus da dutor na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Agog Pita itot go ibol, “O pein, ŋai iŋ ta ŋaloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kitek taidag tamol ta Pita ile tag ibol, “Oŋ dam iŋsad kisaek a.” Gug Pita irupeig ibol, “O tamol, ŋai man tia mok a!” ");
INSERT INTO tbc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Murnag auwa kisaek igo dumado gug tamol taidam imasag ibol, “Rumok, tamol en iŋ da dutor na ya. Iŋ dam Galili tamol a.” ");
INSERT INTO tbc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ago dugo Pita ru naon irupei, “O tamol, ŋai oŋ ata niŋen o ubol dan ta ŋaloŋ na ya!” Ago ibol dugo awan fo kurek ibob. ");
INSERT INTO tbc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesus idaŋsag, malan ti ibol go Pita ile. Agog Pita gamu nam Jesus san ru imug ibol an ilon isou, “Gamu kurek gamugo ibob dop, oŋ saen utol ŋai niŋeg o utot a.” ");
INSERT INTO tbc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Agog Pita ilon itaug, kuai te ilasag tinaŋ tubun mi igane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tamol a Jesus diabi an kukok an digane dugo dufuni se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Malan yamel nam dufoug, dufuni dugo dusumiani, “Oŋ gamu profet ru ubol a, tamol e ifuno den enti ak i?” ");
INSERT INTO tbc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ago dugo nao futek ru aenta wei mi nam dupei se ya. ");
INSERT INTO tbc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Salso idug Juda sad gurman adi, kubiaeŋ san girek maŋau adi, agod pris gurman adi dida dutumanig Jesus dititianig dumado se ya. Agog Jesus diŋaneg kaunsil an naod na dugunig itur a. ");
INSERT INTO tbc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ago dugo durupeig dubol, “Ubol! Oŋ Kristus i? Rupaiamap maloŋ a.” Jesus ru naon irupidai, “Ŋai ŋurupaiaŋ tap, aŋ ilom lo ta rumok na wa. ");
INSERT INTO tbc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Agod sumianek ŋupanaŋ tap, aŋ ru naon ta arupaiag na wa. ");
INSERT INTO tbc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gug saen gamu yau den, Tamol Nanun Anut a dabai fidian anda yan banin won ak lo imado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ago tag dusumiani, “Ak dugo, oŋ Anut nanun ak ubol di?” Iŋ ru naon irupidaig ibol, “Awo, nek aŋsem abol la ya.” ");
INSERT INTO tbc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Agog dubol, “Gidad, tamol taidam, tamol en san kagin niŋen o dubol ilasa san id ta tigiai na wa. Iŋsen awan lo iŋsan muruan ibol go taloŋ la ya.” ");
INSERT INTO tbc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Agog kaunsil an fidian dumasag, Jesus diŋaneg, gabman gurman Pailat dubol dan san na diau a. ");
INSERT INTO tbc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pailat naon na dilasag kot diganeg, ru dusue ti ibol go dubol, “Maŋ tamol en Isrel tamolpein ikubulai tag mabi a. Kaisa san takis ta didad na wak ibol. Iŋ man Juda sad Kristus ibol, an niŋen o iŋ mi kiŋ ibol da.” ");
INSERT INTO tbc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ago tag Pailat Jesus isumiani, “Oŋ Juda sad kiŋ ak i?” Agog Jesus ibol, “Awo, nek oŋse ubol la ya.” ");
INSERT INTO tbc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ago tag Pailat pris gurman adi, tamolpein malan tubun ak dida irupidai, “Ŋai tamol en san muruan ta lo naon ŋupani san ŋile man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ago bo man tamolpein ru dabai kasik dubol, “Iŋ tamolpein ipiteŋanai dugo bubed yabisap gabman da ager dumado wo igane da. Galili na fun iganeg, ipalug gamu etna ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat ru an iloŋ tag isumianai, “En iŋ Galili tamol i?” ");
INSERT INTO tbc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jesus Galili tamol an iloŋ tag, idinai dugo diŋaneg kiŋ Herod san na diau. Man dugo, Herod iŋ Galili kagin ipani da, an lo Jesus Herod paen na imado. Herod saen nek an lo Jerusalem na imado se ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Saen Herod Jesus ile man ilon tubun mi uyanan a. Man dugo, saen milaen iŋ Jesus ile san niŋen o ilon yen. Iŋ ilon man Jesus kulob girager ta igane dop ile wo ibol. ");
INSERT INTO tbc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aria, Herod sumianek funfun ipani se ya, ak gug Jesus ru naon irupei man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Go pris gurman iŋ kubiaeŋ san girek maŋau dida Herod naon na iŋsad ru sewak an dusue ti ibol go Jesus maeg nam kot dupani se ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Agog Herod agod iŋsan yu tamol dida Jesus kukokan digane se ya. Kiŋ dututuŋanig yamel ta kiŋ sadi oŋ ak tinin fo diganeg Pailat san na fon diŋane diau a. ");
INSERT INTO tbc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Imug Pailat iŋ Herod da siai lo dumado na ya. Ak man nal nek an lo iŋ nug turan dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat pris gurman, agod Juda tamolpein sad gurman adi dida igiaig dutumanig ");
INSERT INTO tbc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","igo ibol irupidai, “Aŋ tamol en aŋane apalug abol, iŋ tamolpein bubed yabisap gabman ida ager dumado wo igane da. Aŋ naom na tamol en ŋibitinaeg ŋile ak gug, muruan a niŋen o abol dan fun ta ŋile man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod dam nek ago mi ibitinae ile tag, fon iganeg idsad na ipalu ya. Tamol en mel ta igane saian pe lo mateŋ ile san tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ago yak niŋen o bu mi iŋane gup ŋibiseip yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Agog iŋ fidian awad kisaek lo mi disasaig dubol, “Tamol an funi imat. Barabas pasi panamap maŋsama na imul!” ");
INSERT INTO tbc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas man iŋ gabman san ager. Iŋ Jerusalem ilon lo ager yabisag an lo tamol ta ifuni imat a. An niŋen o diabig subanek ab lo diganeg imado.) ");
INSERT INTO tbc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat san ilon man, Jesus ibiseip yau o ibol da, ago tag tamolpein malan tubun an fon isumianai a. ");
INSERT INTO tbc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ak man iŋ fon duwagiŋ imul go dubol, “Aigim fo bali wa! Aigim fo bali wa!” ");
INSERT INTO tbc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ago tag Pailat afon ibol, “Iŋ ata muruan ta igane yak niŋen imat o abol di? Ŋai iŋsan muruan ta ŋile man tia ya. Ago yak niŋen o ŋabol dop bu mi iŋanep ŋibiseip yau a.” ");
INSERT INTO tbc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ago bo man iŋ tubun mi disasaig, Jesus aigim fo ibali wak dubol. Agog iŋsad siseiŋ an Pailat san ru yabi idu. ");
INSERT INTO tbc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ago tag Pailat iŋaned ru dubol an awad yabig awok ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iŋaned ilod ibol ago mi tamol iŋ gabman lo ager imadog tamol ta ifuni imat an subanek lo ipasi a. Agog ilod ibol dan ago mi digane wo Jesus banid lo igane ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Agog Jesus diŋane diau dugo dal na Sairini tamol ta yaŋan Saimon iŋ Jerusalem na iladu wo dugo diabig Jesus san aigim an dupanig isinig ŋien fo yau. ");
INSERT INTO tbc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tamolpein wei nuŋon Jesus ŋien aban diri dugo, luluŋad lo pein aenta Jesus niŋen o tubun mi ditata dugo tinaŋ aru digane se ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ago tag Jesus idaŋsag irupidai, “Aŋ Jerusalem pein, ŋai niŋeg o atata amoi. Tia, aŋsem niŋemi wo mi tinaŋ aru agane wa, agod aŋanem nanuk niŋedi wo dam mi a. ");
INSERT INTO tbc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Man dugo, mitep muruan tubun mok ipalu dop tamolpein dubol a, ‘Pein niganig, pein nanuk ad tia yan, agod pein a imug nanuk su ta dupidinai na yan dam gamu ilod uyanan a.’ ");
INSERT INTO tbc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Saen an lo tamolpein dubol a, ‘Did adup, afunama mamat. Bubun adup, atuanama!’ ");
INSERT INTO tbc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tamol gamu ai kumaen ak lo igo digane da. Ago tap, saen ai ikurŋak geig ak lo, ata mel ilasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Tamol saiadi ak uraru dam Jesus ida diŋal go diaug aben ta, yaŋan Kabuŋa Tatu san aben dubol dak, ate dilasa ya. Aben ante Jesus tamol uraru an dida aigim fo dubalai a. Neinta tuon won ak lo dugo, neinta tuon ŋas ak lo ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Agog Jesus ibol, “Bai, iŋsad aupasek en pare idu, man dugo, mel e digane den diŋaoŋ ak lo digane da.” Agog iŋsan kulos duburoug, sed nug lo duwaeg lo satu dukok a. ");
INSERT INTO tbc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tamolpein leil digane dugo dutur a, ago dugo Juda sad gurman adi Jesus kukokan digane dugo dubol, “Iŋ aenta patud ipasi na ya. Ago yak niŋen o, iŋ tamol a Anut ipiliani an, Anut san Kristus, an rumok tap, ka sen patun ipasi dop tile.” ");
INSERT INTO tbc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yu tamol a dititiani dan siŋiren na dupalug kukokan digane se ya. Iŋ wain gigen geig ak wain uyan ak da dukubulig diabisag dubol, “Uluk. ");
INSERT INTO tbc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Oŋ rumok Juda sad kiŋ tap, se ibinawo!” ");
INSERT INTO tbc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ru ta ai lapan fo digireg aigim kabuŋan fufo na dubali a. Ru en san sutek lo man igo ya, “En Juda sad Kiŋ.” ");
INSERT INTO tbc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Agog tamol saiadi an kisaek imasag Jesus naon ifute ipeig ibol, “Oŋ Kristus. Ago tap, oŋse ibinawo dop, maŋ dam binawama!” ");
INSERT INTO tbc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ak man turan imasag irupei, “Dugo, oŋ Anut niŋen o ta urer na di? Id utol muruan naon kisaek mi tisini da. ");
INSERT INTO tbc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Id man bo tisini wak fom tisini da. Man dugo, idsad kagin naok naok fom ai wadan en dupanad a. Gug tamol en man kulob ta igane saian man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Agog tamol an Jesus irupei, “Jesus, saen oŋ kiŋ lasa dop, ŋai ilo isou.” ");
INSERT INTO tbc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus ru naon irupei, “Ŋai rumok ŋurupaio da, gamu en oŋ ŋai da Paradais lo sisem tumado wa.” ");
INSERT INTO tbc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Saen an ad isudag 12 klok igo woŋ dugo, abaŋ tidom tubun go tan fidian yafutanig yen dugo yaug 3 klok gurai isi a. ");
INSERT INTO tbc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Man dugo, saen an lo ad ta ided na ya. Agog yamel tubun tempel lo iyuk yen an, imasireig uraru dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Agog Jesus awan tubun mi iwagiŋ go ibol, “Bai, ŋaineg ŋutug oŋ bani lo ŋigane da.” Ago ibol go imat. ");
INSERT INTO tbc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Agog Rom yu tamol sad gurman iŋ abaŋ ago ileg, Anut yaŋan yabisag ibol, “Rumok geig. Tamol en man muruan ta tinin lo tia ya. Iŋ itaot a.” ");
INSERT INTO tbc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Saen tamolpein a gubak mi abaŋ dile wo dutumani an Jesus imat dugo dile man, ilo muruan lo sed titired dufunig aben an dibiseig diau a. ");
INSERT INTO tbc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gug tamolpein fidian a Jesus duloŋ an, pein a Galili nag ŋien fo dupalu yan dam, duparianig asau mi dutur a. Dugo dugo ilasa yan dile wo malad digane ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tamol ta yaŋan Josef, iŋ Juda panu ta Arimatia dubol dan san tamol. Iŋ tamol uyan, agod itaot. Iŋ Anut san kagin panek ipalu wo malan igane se ya. Iŋ Juda sad kaunsil lo imado gug kaunsil dida Jesus san mateŋ o ilod ta kisaek na ya, agod awok ta ipidinai na ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tamol an Pailat san na yaug, Jesus san sisanun iŋanep mutou lo igane wo isumiani. ");
INSERT INTO tbc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pailat awok ipani tag Jesus san tinin tubabun aigim fo yak ipasig, yamel milkouk ak nam ifoug, gib ta pat tubun ak ilon dupasi an lo igane ya. Gib an imug tamol ta ate disare man tia ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nal an Soubul Kubunek San dubol a. Sabat nal fun igane wo da. ");
INSERT INTO tbc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pein Galili nag Jesus ŋien fo dupalu yan Josef dida diaug, gib a lo Jesus san sisanun dugo dugo woŋ iganeg yen an dam dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Agog dumul, iŋsiganed na diaug, gureŋ mumalun uyan ak Jesus tinin diabi wo dukubune idu. Sabat nal ilasa tag kubiaeŋ ibol ak fom diganeg, yaes dubal. ");
INSERT INTO tbc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aria, ubou san nal Sabat dubol dan itout go nal patun fo, ubou turan san nal malmalan, tidom lom geig, pein gureŋ mumalun uyan uyan ak fidian dukubune yan disinig, mutou fun na diau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mutou fun na dilasag, pat tubun a ate mutou awan dufutani an awan dubuli yau la yan dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ago tag gib ilon lo diladu yak gug Jesus san sisanun ta dile na ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Agog kankan ifu dugo dutur ibol ak, tamol ta urarum, iŋsad kulos weil irafule dan san lilaman igo woŋ ak, giraŋed na dilasag dutur dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pein an tubun kasik direr go naod itakok tan na idu ya. Agog tamol uraru an durupidai, “Aŋ ata wo tamol dumat ak luluŋad lo tamol kumaen ak abaŋan abi dak i?” ");
INSERT INTO tbc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iŋ etna tia. Iŋ kumaen imasa ya. Ilo sou agane, gubak mi saen aŋ iŋ da Galili na amado yan igo irupaiaŋ go ibol, ");
INSERT INTO tbc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Tamol Nanun aupasek tamol banid lo diganep, aigim fo dubali wa. Agop nal utol yen gup, fon kumaen imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ago dubol dugo pein an Jesus san ru ilod isou. ");
INSERT INTO tbc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ago tag mutou dibiseig dumul diaug, megeloum 11, agod tamolpein aenta dida dumado dan dam durupidai a. ");
INSERT INTO tbc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pein a diau an: panu Magdala san Maria, Joana, agod Jems tinan Maria. Iŋ pein aenta dam dida diau ak ru an aposel adi naod na dubol. ");
INSERT INTO tbc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ak man aposel adi sad ilo sou lo man, ru a pein an durupidai an ŋiŋeo mi a, an niŋen o ilod lo ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Gug Pita imasag, imaspalug, mutou fun na yaug, iyep pat gubaran ilon lo yau ya. Ak man yamel a ate Jesus san sisanun dufou an mi yen dugo ile tag, kankan gidigidad iŋane dugo fon imul ab lo yau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nal kisaek an lo mi luluŋad lo tamol uraru iŋ panu ta Emeas dubol dak lo diau se ya. (Jerusalem biseip, 11 kilomita wau gup, Emeas na lasa wa.) ");
INSERT INTO tbc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dal na melmel a fidian ilasa na yan nug lo dukubiai dugo diau se ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iŋsed diŋiŋeŋ di diau dugo Jesus iŋsen ilasag, luad isag, dida sisem diau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tamol uraru an Jesus dile bo man, Anut malad yafutani an lo iŋ tamol sen ak ta dubol a. ");
INSERT INTO tbc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Agog Jesus isumianai, “Aŋ so ru ta abol dugo au di?” Ru an duloŋ go dupartuanig ilo muruan ad da dutur a. ");
INSERT INTO tbc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tamol ta yaŋan Kleopas imasag isumiani, “Nag oŋse kisaek Jerusalem na nor warim kulob ilasa na yan ta uloŋ na boi i?” ");
INSERT INTO tbc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ago dugo Jesus isumianai, “So mel ta?” Iŋ ru naon durupei, “Muruan nek a Nasaret tamol yaŋan Jesus dubol dan lo ilasa amaiak niŋen o mabol da. Tamol an iŋ profet. Iŋsan ŋiŋeŋ, urat dam dabai anda igane se ya. Anut, iŋ tamolpein dida dupitiani na ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Maŋsama pris gurman adi agod idsad gurman fidian dida dubol dugo, Rom san gabman gurman banin lo digane ya. Agog tamol an kot ipanig aigim fo dubalig imat a. ");
INSERT INTO tbc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Maŋ iloma lo, Anut tamol an Isrel adi patud ipasi wo ipiliani a. Ago igane wo maŋ tinim migane pani na ya, gug gamu tia ya. Taida mi, gamu muruan an ilasa gug nal utol yau la ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","An mi tia, maŋsama pein luluŋad lo aenta tidom lom mutou fun na diau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mutou fun na dilasag tubabun gib lo ta dile na ya. Ago tag maŋsama na dumul go igo durupaiama, malad ŋutun dile dugo eŋel uraru dil go eŋel an durupidaig dubol, ‘Jesus kumaen imasa la ya.’ ");
INSERT INTO tbc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ago tag maŋ luluŋam lo tamol aenta mutou fo diaug pein adi durupaiama yak ago mi dile ya. Ak man tubabun ta dile na ya.” ");
INSERT INTO tbc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Agog Jesus irupidai, “Aŋ ilom tia. Ata wo profet adi ru dubol na yan ilom lo ta rumok na yak i? ");
INSERT INTO tbc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Profet adi kuai tem dubol, Kristus mitep muruan isini gup, iŋanen girager agod yaŋan tubun ak iŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Agog iŋsen niŋen o girek lo Moses iŋ profet adi dida niŋen o dubol na yan fun ifulale ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Agog dupalug, Emeas sumeik dugo, Jesus itaot yau wo igane tag ");
INSERT INTO tbc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","diabituanig durupei, “Ad idu la yak niŋen o umoip, taen.” Ago tag dida ab lo disida ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Anaŋ diani wo dumasi dugo Jesus bret iŋaneg, Anut ilo uyan ipanig, yafuteg, ipidinai dugo malad ipuk go ");
INSERT INTO tbc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","iŋ duloŋ man, tamol en nek Jesus sen a. Agog Jesus gamu nam malad lo tia yau. ");
INSERT INTO tbc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Agog tamol uraru an nug ru durupeig dubol, “Oŋ ilo isou, gubak mi saen Jesus id da dal na tureŋ tabi dugo ru fidian girek lo yan fun ifulale panad se yan, iŋsan ru bubed lo nek ibol yai inani dak igo woŋ a.” ");
INSERT INTO tbc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Agog dumasag fon Jerusalem na ririan dumul go diau. Jerusalem na megeloum 11 an iŋ turad aenta dida dutumanig dumado dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Agog iŋ tamol uraru an durupidai, “Rumok geig. Tubun en fon kumaen imasa ya! Saimon Pita sen malan lo mok ile ya.” ");
INSERT INTO tbc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ago tag tamol uraru an dam dal na abaŋ dugo dile yan dubol, “Maŋ dam dal na mile yak man iŋ ta maloŋ na ya. Gug saen bret yafuteg ipanama ante dugo iŋ maloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tamol uraru an ago diŋiŋeŋ dugo Jesus luluŋad lo ilasag ibol, “Aŋ maror amado.” ");
INSERT INTO tbc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Agog durut go direr saian. Iŋ ilod lo tamol ŋutun ta naod na ilasa dubol a. ");
INSERT INTO tbc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Agog isumianai, “Aŋ ata wo arer dak i? Aŋ ata niŋen o ilom weiwei di? ");
INSERT INTO tbc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Malam ipalup, ŋieg banig ale. En man ŋaiseg. Abiag pe aliag! Tamol ŋutun man tinid tatu an tia ya. Gug ŋai man tinig tatu amag da ya.” ");
INSERT INTO tbc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ago ibol go ŋien banin ikibiai dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iŋ ilod uyan ak man ilod lo kitek ta rumok na ya. Man dugo, durut saian dugo iŋ ilod weiwei, an lo ilod lo rumok san ta pasauman na ya. Ago tag isumianai, “Aŋ etna mel nuaeŋ san ta yen di?” ");
INSERT INTO tbc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Agog iy gisek ak dupanig, ");
INSERT INTO tbc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","naod nam iŋaneg yani dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Agog irupidai, “Imug ŋurupaiaŋ ak ilom isou. Wagam Moses san kubiaeŋ lo, profet adi sad girek lo, agod Isrel sad kanam buk lo dam, melmel fidian ŋai o digire na yan nuŋon ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Agog iŋsad kankan isofulaleg, an lo Anut san ru girek lo yen dan fun mok duloŋ fufei a. ");
INSERT INTO tbc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Agog irupidai, “Ru a buk lo digire yan igo ibol: Kristus mitep muruan isinip, imat pe, nal utol gib lo yen gup, fon kumaen imasa da wa. ");
INSERT INTO tbc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iŋ yaŋan lo Anut tamolpein ilod ibilisa dop, iŋaned muruan ipasi pidinai an san ru, Jerusalem na fun igane gup, panu panu lo yau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aŋ melmel ilasa dugo ale na yan abol dop, duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bai mel ipanaŋ o ibol an ŋau gup, ŋidinip ipalu wa. Ago yak niŋen o Jerusalem na malam aganep amado dop yaup, dabai a lak na yak ipalu wan idup aŋ tinim iŋanefute wa.” ");
INSERT INTO tbc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Agog Jesus iŋal go diaug, Betani na dilasa ya. Atnag banin yabisag, bar ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Agog ibisawaig, Taman iŋaneg siŋiren na yau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tamol a leil digane dan Jesus ubou an dile gug yousai tubun geig ak lo mi dumul go Jerusalem na diau a. ");
INSERT INTO tbc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ante saen wei mi tempel lo Anut per dupani dugo dumado na ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fun lo mok Anut mel fidian ta idiri na dugo, Ru iŋ yen la ya. Iŋ Anut da dumado ya, agod Ru mi iŋsen Anut. ");
INSERT INTO tbc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","3","Iŋ Anut ida dumadog, iŋ lo mel fidian dilasag dien da. Ta iŋ dal sen ta lo ilasa man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iŋ lo kumaen yen da, an lo mel fidian kumaen diŋane ya, agod kumaen an tamolpein lo lilaman igane ilasa da. ");
INSERT INTO tbc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lilaman an tidom tubun lo ided da, agod tidom tubun an lilaman ituani san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Aria, Anut tamol ta iganeg imug ilasa ya. Iŋ yaŋan Jon dubol da. Iŋ ipalug, lilaman san ru fun an tamolpein fidian ikubiai ipidinaip, duloŋ pe, ilod lo rumok san. ");
INSERT INTO tbc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ak man Jon iŋsen lilaman amaiak tia ya. Iŋ lilaman an niŋen ru an ibol ilasa dop duloŋ o ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lilaman a lilaman mok an, tan na idup tamolpein fidian lilaman ipidinai o ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iŋ lo mel fidian dilasa ya, agod iŋ tan en lo kuai isig imado la yak bo man, tamolpein diŋaoŋ geig a. ");
INSERT INTO tbc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Iŋsinanen tan lo ipalu ya, ago gug muroun muroun an iŋ diŋane man dumoi. ");
INSERT INTO tbc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ak man tamolpein a iŋ diŋane yan, agod iŋ yaŋan tubun ak ilod lo rumok an fidian, Anut nanun dilasa san dabai iŋ ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iŋ tinad tamad sad dar lo, tia, tan san kagin lo, tia, tinid san kagin lo, Anut nanun muroun dilasa man tia ya. Tia, Anut sen iginiaig, iŋanen nanun muroun dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ru an tamol nuŋon ilasag kuai isi a. Agog iŋ maŋ luluŋama lo ida mumado na ya. Rumok, Bai Anut iŋanen Nanun kisaek o lian idinig ipalu ya, ago dugo Nanun an san girager tubun ak mile ya. Ilo panek iŋ ru rumok da iŋ tinin iŋanefute ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aria, Jon malak malak iŋ niŋen o igo ibol iwagiŋ, “Tamol emaiak niŋen o ŋai ŋurupaiaŋ go aloŋ na ya. Tamol a ŋai patug fo ipalu dan, ŋai iriŋanag dugo ŋaisag malan te yak imado da. Man ata wo, wagam mi ŋai ta ŋilasa na yan iŋ imado la ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iŋsan ilo muŋanek tubun mok iŋ lo awan isa ya, an lo binawek wei mi an iŋanen banin dibiseig id fidian tiŋane na ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Man dugo, Anut id Moses banin lo kubiaeŋ ipanad a, gug ilo panek iŋ ru rumok da man, Jesus Kristus lo mi ipanad a. ");
INSERT INTO tbc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tamol ta Anut kitek ile man tia geig a. Gug Anut a kisaek o lian an, Taman giraŋen na imado na ya, iŋ tan na ipalug Taman ikubiai panad go taloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon ru e Jesus niŋen o ibol ilasa yen man igo ya. Saen Juda gurman adi a Jerusalem na dumado dan pris aenta, Liwai adi da didinaig Jerusalem dubuseig diaug, Jon fun duloŋ o dusumianig dubol, “Oŋ enti i?” ");
INSERT INTO tbc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Agog Jon ru kuai tem irupidaig duloŋ a, iŋ enti mok an ta itot na ya. Iŋ igo ibol, “Ŋai man Kristus tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ago tag iŋ dusumianig dubol, “Ak oŋ enti i? Oŋ dag profet Elaija wagam na yak fon palu boi?” Ak man iŋ ibol, “Man tia.” An niŋen o iŋ fon dusumiani, “Oŋ dag profet a Anut niŋen o ibol amaiak boi?” Gug iŋ ibol, “Tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","An niŋen o iŋ dusumiani, “Ago tap, ubol pe maloŋ, oŋ enti mok i? Maŋ tamol didinamag mupalu yan ata ru ta murupidaip duloŋ ak i? Oŋ oŋse niŋe wo dugo ubol dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ago gug Jon profet Aisaia awan aban iŋaneg igo ibol, “Ŋai man tamol ta aben kawan ak ate iwagiŋ emaiak san awan ŋisiaig ŋuwagiŋ da, ‘Tubun en iŋanen dal akubune apani!’” ");
INSERT INTO tbc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisi adi luluŋad lo tamol aenta imug didinaig dupalu dugo, tamolpein dida dutur a. ");
INSERT INTO tbc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Iŋ dam Jon dusumianig dubol, “Oŋ Kristus, tia, Elaija, tia, Profet mititiani den dam tia yak ubol dan, ago tap, ata wo tamolpein suguek pidinai dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon awad yabig igo ibol, “Ŋai tamolpein you lo mi ŋusuguai da. Gug tamol ta aŋ luluŋam lo itor dak aŋ ta aloŋ na da. ");
INSERT INTO tbc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tamol an iŋ ŋai patug fo ipalu da, gug iŋ ŋai iriŋanag a. Ŋai seg iliag dak man, ŋai iŋsan sendal ŋupasi san ta idaisuda na ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Saen an lo Jon panu Betani na imado dugo, you Jordan aen ate iŋanen suguek urat igane se ya. Panu ante kulob an fidian ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Agog dien dumasag nal tinin te yan, Jesus imasag Jon san na ipalu dugo, Jon malan yaug ile, agog ibol, “Ale dak, an Anut san sipsip nanun ipalu da. Iŋ ipalu dan lo, tan en san tamolpein sad kagin saiak fidian iragali pidinai a. ");
INSERT INTO tbc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ŋai gubak mi tamol nek amaiak niŋen o ŋabol a. ‘Tamol ta iŋ ŋai patug fo ipalu dan iŋ ŋai iriŋanag go ŋaisag tamol malan te yak imado da. Man ata wo, wagam mi ŋai ta ŋilasa na yan iŋ imado la ya.’ ");
INSERT INTO tbc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ŋaiseg man gubak mi iŋ tamol dugo yan ta ŋaloŋ na ya. Ago yak man ŋai ŋupalug, tamol amaiak Isrel tamolpein ŋukubiai pidinaip dile duloŋ o, you nam ŋusuguai se ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Agog Jon mel a ile yan niŋen igo ibol, “Ŋai Urgun kumaen panu ibiseig idu dugo ŋile ya. Iŋsan leil man nek ibol muluk oŋ idug Jesus gumuran fo imado dugo ŋile ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ŋaiseg man imug iŋ tamol dugo yan ta ŋaloŋ na ya. Gug Anut enti tamolpein you nam ŋusuguai o idinag go ŋupalu yan, iŋsen irupaiag go ibol, ‘Oŋ Urgun ule dop idup, tamol ta tinin fo imado wa. Tamol nek an iŋ tamolpein Urgun lo isuguai a.’ ");
INSERT INTO tbc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ŋai ŋile ŋaloŋ la ya, an lo ŋai iŋ niŋen o ru ŋabol ilasa da, tamol en iŋ Anut Nanun mok a.” ");
INSERT INTO tbc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Nal tinin te yan lo, Jon san megeloum uraru iŋ dida dutur dugo malad yaug, Jesus yau dugo dile. Jon Jesus ile tag megeloum irupudai, “Ale dak, on Anut san sipsip nanun, tamolpein ibinawai o ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Megeloum uraru an ru ago duloŋ tag, diaug, Jesus ŋien aban diri se ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Agog Jesus idaŋsag, uraru an yil tag irupudai, “Aŋ ata mel o abaŋ abi di?” Agog uraru an awan diabig dubol, “Rabbi (en fun man girek maŋau) oŋ ab dugon te mado di?” ");
INSERT INTO tbc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Agog Jesus awad yabig ibol, “Aŋ apalup ale.” Ago tag iŋ dida diaug, ab a ate imado dan dile ya. Nal an gurai idu ya, ago tag iŋ dida atna dumado yaug tidom idu ya. ");
INSERT INTO tbc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Megeloum uraru Jon awan duloŋ go Jesus da diau an, neinta yaŋan Andru, Saimon tein. ");
INSERT INTO tbc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Iŋ Jesus ibiseig ririan yaug tein Saimon abaŋan yabig, ileg irupei, “Maŋ Mesias mile la ya.” (Yaŋak Mesias fun man Kristus.) ");
INSERT INTO tbc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Agog tein Saimon iŋaneg, ida dumul Jesus san na dupalu. Jesus malan ti ibol Saimon ileg irupei, “Oŋ Saimon, Jon nanun. Gamu ŋai oŋ yaŋa sen ta Sifas ŋupate da.” (Grik ru lo Sifas fun man Pita dubol da, an “pat” igo woŋ a.) ");
INSERT INTO tbc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dien dumasag, Jesus distrik Galili na yau o ilo sou igane ya. Iŋ Filip ileg irupei, “Oŋ ŋai da tau a.” ");
INSERT INTO tbc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip iŋ panu Betsaida dubol dan san tamol, an iŋ Andru Pita da sad panu kisaek a. ");
INSERT INTO tbc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip Nataniel abaŋan yabig ileg irupei, “Maŋ tamol a Moses iŋ profet dida niŋen o dubol dugo, girek lo digire emaiak mile la ya. Iŋ Nasaret tamol, yaŋan Jesus, Josef nanun.” ");
INSERT INTO tbc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Agog Nataniel ibol, “Mel uyan ak ta Nasaret na ka ilasa wak i?” Gug Filip ibol, “Oŋse palup ule.” ");
INSERT INTO tbc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Agog diau dugo, Jesus Nataniel iŋsan na ipalu dugo ile tag, iŋ niŋen o igo ibol, “Ale, an Isrel tamol mok. Iŋ ilon lo kagin sewak ak ta yen man tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ago tag Nataniel isumianig ibol, “Oŋ dugudo woŋ ŋai fug uloŋ i?” Agog Jesus awan yabig igo ibol, “Filip oŋ gamugo igio dugo, oŋse gurab dabin fo mado dugo ŋilio ya.” ");
INSERT INTO tbc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ago tag Nataniel irupei, “Girek Maŋau, oŋ Anut Nanun mok a, oŋ Isrel sad Kiŋ.” ");
INSERT INTO tbc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Agog Jesus ibol, “Ŋai oŋ gurab dabin fo mado dugo, ŋilio ŋabol an niŋen o oŋ ilo lo rumok i? Uloŋ ak, murnap oŋ mel tubun geig ak mel en iriŋani an ule uloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesus fon irupudai, “Ŋai rumok nuŋon mi ŋurupaiaŋ da. Murna dop Anut kumaen panu awan ipasip, aŋ malam yaup, Anut san eŋel adi Tamol Nanun san na dusuda dudu dop eil a.” ");
INSERT INTO tbc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Nal uraru yau gug, panu Kana Galili distrik lo ante nug ŋanek san soubul digane. Jesus tinan ab an lo imado dugo, Jesus san megeloum dadi digiaig dupalug, nug ŋanek san soubul an lo dumado ya. ");
INSERT INTO tbc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nug ŋanek san soubul an diani diluk yaug you wain itout. Ago tag Jesus tinan imasag nanun irupeig ibol, “Iŋsad you wain itout a.” ");
INSERT INTO tbc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ago tag Jesus tinan irupeig ibol, “Nei, ata wo oŋsa tini ganei ŋai lo gane dak i? Ŋaisag saen gamugo da.” ");
INSERT INTO tbc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aria, tinan yaug urat pinein irupudai, “Urat biabi fidian irupaiaŋ dop, awan ari apani.” ");
INSERT INTO tbc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ab an lo bod tubun tubun ak 6 dutur dan ate you disirip, Juda sad kagin lo mi ŋied banid dufulani da. Bod kisaek kisaek an ate you 90 lita boi, tia, 140 lita boi, ago lo you disiraip dien da. ");
INSERT INTO tbc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aria, Jesus urat pinein sad na yaug irupudai, “Bod an ate you asiri idup awad isa wa.” Ago tag iŋ ibol ak atem ago digane ya. ");
INSERT INTO tbc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Agog Jesus irupudaig ibol, “You an ta awalip asini aup, soubul san gurman apani.” Ago tag iŋ you an disinig diaug dupani a. ");
INSERT INTO tbc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Agog soubul gurman an you a ibileksag wain mok ilasa yan iluk ile ya. Ak man kulob an fun ta iloŋ na ya. Urat pinein a you disiri an iŋ duloŋ ak man ta durupei iloŋ na ya. An niŋen tamol an nug ŋanek san pinein an iwagig ipalug irupei, “Idsad tamol kagin man igodo ya. Wain uyanan mok ak imug doup tupidinaip duluk itout gup, murna wain kitek saian an tupidinai diluk da. Dugodog oŋ ago ta gane na i? Oŋ wain uyan ak ilo isig yen gug gamu sini palu ya.” ");
INSERT INTO tbc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kulob girager en Jesus san urat malan malan Galili distrik lo Kana panu na igane ilasa ya. An lo iŋsan yaŋak tubun ak san dabai iŋ lo yen dan kuai isig, iŋsan megeloum dileg, iŋ o ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Soubul an itout gug Jesus imasag, tinan, tein muroun, iŋsan megeloum isug, dida panu Kaperniam na dudug, ante kitek dida dumado ya. ");
INSERT INTO tbc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aria, Juda sad tumanek tubun ak, Pasova dubol dan san saen sumeik tag, Jesus imasag Jerusalem na yau a. ");
INSERT INTO tbc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iŋ yaug tempel san tumanek aben ilon lo iladug, makau, sipsip, anakanak a didaeŋ lo digane yau imul se yan yil a. Aenta badim fo moni patun dibileksa dibilekla dugo yil a. ");
INSERT INTO tbc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ago tag Jesus rasau ipideg sen nam tamolpein fidian ifu ikudai dugo, makau, sipsip dam ikudai kuai te dilasa ya. Agog tebol an moni aman da ikulmaek idug, moni iratitaleg ifurak yau a. ");
INSERT INTO tbc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ago gug tamol anakanak didad se yan irupudai, “Aŋanem mel en fidian asup alasa. Aŋ ŋaineg Bai san ab en aŋanep dadeŋ aben igo ta agane na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","An niŋen o iŋanen megeloum ru ta Anut san buk lo digireg yen dak ilod isou. Ru an igo ibol, “Ŋai oŋane ab ilog ŋupani mok da, an niŋen o ŋai ilog saian dugo bubeg wananan geig da, an lo kankan an ŋai ilog yabi sakar dugo iduduwag da.” ");
INSERT INTO tbc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesus ago igane dugo Juda gurman dileg, dumoi go dubol, “Oŋ ata kulob girager ta ganep maŋ milep maloŋ ak, oŋ en so dabai ta lo igo gane dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ago tag Jesus awad yabig igo ibol, “Ŋai ubou ab en ŋititale gup, nal utol lo mi fon ŋususe da wa.” ");
INSERT INTO tbc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Agog Juda adi Jesus durupei, “Ab en anaŋar 46 lo diabig itout a. Gug gamu oŋ en nal utol lo mi wabisa da wo ubol dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ak man Jesus ubou ab niŋen ibol an, fun man iŋsen tinin niŋen o ibol a. ");
INSERT INTO tbc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ago yak niŋen o saen Anut Jesus mateŋ lo ifufunig fon kumaen imasa yan lo, iŋanen megeloum dileg ru a wagam mi Jesus iŋsen ibol an ilod isou. Agog ru girek a Anut san buk lo yen dan, agod ru a Jesus ibol an dam, ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus tumanek tubun Pasova dubol dan san saen lo, Jerusalem na imado dugo, doup tubun an iŋanen kulob girager igane yan dile tag, iŋ o ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ak man Jesus iŋsen iŋanen tini ganei tamolpein an lo ta igane na ya, man dugo, iŋ tamolpein an fidian ilod iloŋ fufei a. ");
INSERT INTO tbc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tamol ta kankan naok dugo yak a tamolpein bubed lo yen dan niŋen, Jesus iloŋ o kuai te ibol ilasa san urat aman tia ya. Man dugo, Jesus sen, kankan a fidian tamolpein ilod lo dien dan iloŋ pasik a. ");
INSERT INTO tbc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisi sad tamol tubun ak ta yaŋan Nikodemus. Iŋ Juda adi sad gurman ta, agod Juda sad kaunsil malan te yak lo yaŋan yen da. ");
INSERT INTO tbc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tamol an tidom ta lo Jesus san na yaug, irupei, “Girek Maŋau, maŋ maloŋ ak Anut oŋ idinog maŋsama na girek maŋau igo palu ya. Man dugo, tamol enti a Anut ida dumado dan mi, kulob tubun tubun a oŋ gane dan iŋ ka igane wa. Iŋ Anut san tia dop man, urat a gane dan igane san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus awan yabig igo ibol, “Ŋai rumok nuŋon mi ŋurupaio da. Isop tamol ta foun ta ilasa na tap, Anut san kagin panek aben ile san tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ago tag Nikodemus awan yabig ibol, “Dugo woŋ pe tamol iŋ tinin tamol igane la yak afon foun ilasa da wak i? Nag fon tinan tiŋaen lo ka iladup, nanuk igo woŋ tinan igansi wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus ru naon irupeig ibol, “Ŋai rumok ŋurupaio da. Isop tamol ta you iŋ Urgun da lo kumaen foun ak ta iŋane na tap, Anut san kumaen panu ilon lo ta iladu na wa. ");
INSERT INTO tbc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mel tinik lo ilasa man tinik san mel mi a, nek ago mi, mel a Urgun igane ilasa dan iŋ ur san mel a. ");
INSERT INTO tbc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gug oŋ foun lasa wo ŋabol dan niŋen o oŋ masa saian umoi. ");
INSERT INTO tbc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tim man iŋsen iŋanen ilon ibol ak lo yau imul da. Ago dop tim an liliŋan mi uloŋ da. Gug iŋ dugon te ipalug dugon te yau dan, oŋ ta uloŋ na ya. Tamol a Urgun iganep, foun ilasa dan nek ago mi a.” ");
INSERT INTO tbc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus isumianig ibol, “En dugo woŋ mok ilasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Agog Jesus awan yabig ibol, “Oŋ man Isrel luluŋad lo iŋsad girek maŋau mado ya, ago gug, ata wo mel an fun ta uloŋ na ubol di? ");
INSERT INTO tbc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rumok nuŋon mi ŋurupaio da. Maŋ mel a maloŋ an niŋen o mi ru mabol da, agod maŋ mel a maŋsema malama nam mile yan mi tamolpein naod na mabol ilasa da, ago bo man aŋ tamolpein maŋanema ru aŋane wan amoi da. ");
INSERT INTO tbc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ŋai tan san kagin niŋen o imug mi ŋurupaiaŋ a, ak gug aŋ ilom lo ta rumok na ya. An niŋen o, dugo, ŋai fon kumaen panu san melmel an niŋedi wo ŋurupaiaŋ dop man, an dugo woŋ pe aŋ ilom lo rumok ak i? Man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tan en san tamol ta kumaen panu lo iladu man tia ya. Tamol Nanun iŋ mi aben an lo iladu ya. Man dugo, iŋanen fun panu man tan en san tia ya, tia, gubak mi iŋ Anut da dumado gug, kumaen panu ibiseig idug tan na ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Wagam Moses Isrel adi dida aben kawan ak ate dumado dugo mot dilasag, tamolpein diratai se ya. Ago yak niŋen o Moses ai igunig, mot mitilaen ta yabisag isuŋani a. Talpein mot mitilaen ile dan, imat san tia ya, tia, kumaen imado ya. Nek ago mi Tamol Nanun diabisap dusuŋani wa. An niŋen o tamolpein a fidian ŋai o ilod lo rumok dan, iŋ kumaen pempem san diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Anut iŋ tan en san tamolpein niŋedi wo imat, an niŋen o iŋanen Nanun kisaek o lian an ipanad a. An lo tamolpein iŋ o ilod lo rumok tap, ta dideg diau na wa. Tia, iŋ kumaen pempem yen san diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Man dugo, Anut iŋanen Nanun tan na iganeg ipalu yan, iŋ tamolpein bitinaek lo idiraip naon muruan ipidinai wo ta ipalu na ya. Man tia. Iŋ ipalu yan lo tamolpein patud ipasi dop, pitiŋinek aben lo ta diau na wa. ");
INSERT INTO tbc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Enti iŋ o ilon lo rumok dop man, Bitinaek Tamol iŋ muruan ta ipani na wa. Gug enti iŋ o ilon lo rumok tia yan iŋ ideg yau san dal lo imado la ya. Man ata wo, iŋ Anut Nanun kisaek o lian an niŋen o ilon lo ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bitinaek Tamol yil saian man fun igo ya. Lilaman tan na idu la ya, ago gug tamolpein lilaman an patud dupani dugo, tidom tubun lo dumado wo dumat da. Man dugo, iŋ kagin saiak saiak mi digane wo dumat da. ");
INSERT INTO tbc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tamolpein kagin saiak digane dan iŋ lilaman dumoi go san ager dumado da. Iŋ lilaman lo dupalu san dumoi, man dugo, kabelan iŋaned kirem saian an kuai te ilasa banau. ");
INSERT INTO tbc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gug talpein a iŋ kagin rumok ak igane dan iŋ lilaman lo ipalu dop lo iŋsan urat uyan ak walal te ilasa wa. Ago dop tamolpein a talpein an leil dupani dan, iŋ dile duloŋ ak, talpein an Anut san dabai lo iŋsan urat fidian igane da.” ");
INSERT INTO tbc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aria, murnag Jesus megeloum dida dumasag, Jerusalem dubuseig, Judea aen ate diaug, ante dida kitek dumado dugo tamolpein suguek ipidinai. ");
INSERT INTO tbc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ago dugo Jon dam sasau Ainon dubol dak ate, aben Salim sumeik an, ante imado dugo tamolpein iŋsan na dupalug you lo isuguai se ya. Man dugo, you kuror ak aben ante dien da. ");
INSERT INTO tbc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Saen an lo man gurman Herod iŋ Jon subanek lo gamugo igane ya. ");
INSERT INTO tbc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aria, Juda tamol ta ipalug, Jon san megeloum dida Juda sad you sugsug kagin niŋen o fun diganeg nug dupei. ");
INSERT INTO tbc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ago tag Jon san megeloum diaug durupeig dubol, “Girek maŋau ule, tamol a gubak mi oŋ iŋ da you Jordan aen ate amado dugo, iŋ niŋen o ru fulale amaiak, iŋ tamolpein suguek ipidinai dugo fidian iŋsan na mi diau da.” ");
INSERT INTO tbc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Agog Jon ru naon igo irupidai, “Uyan, talpein ta iŋsinan dabai lo mel ta iŋane san tia ya. Tia, iŋ binawek Anut kumaen panu lo iganeg idu an mi ka iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aŋsem gubak mi ŋai ru kuai te ŋabol ilasa dugo aloŋ la ya. Ŋai Kristus tia ya. Ago yak man ŋai Anut sen idinag go Kristus naon na ŋanug ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tamol ta iŋ pein da nug diŋane tap, pein an tamol an san. Go tamol sen ak turan an patun fo sumeik itur dan iŋsan turan an awan iloŋ, an niŋen o ilon uyanan geig a. Ŋai man Kristus san turan, tamolpein iŋsan na diau dan ŋeil dop, ilog uyanan geig da. ");
INSERT INTO tbc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ago yak niŋen o iŋ yaŋan tubun mi imasap yau dop, ŋai yaŋag ka idu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tamol iŋ lak nag idu yan iŋ yaŋan tubun geig a, mel fidian iŋ paen na dumado da. Tan en san tamol man iŋ tan en san ru mi ka ibol ilasa wa. Gug tamol a kumaen panu log idu yan man fidian iriŋanai a. ");
INSERT INTO tbc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iŋ mel a fidian yil an, agod mel a fidian kududon iloŋ an dam, tamolpein naod na ibol ilasa da. Ak gug iŋsan ru tamolpein an fidian iriŋanai yau oŋ dugo, duloŋ o dumoi. ");
INSERT INTO tbc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Gug talpein enti ru an iŋaneg yabi sakar dan, kulob an lo ikubiai tile yak iŋsan ilo rumok igo ya, “Anut san ru an ru rumok.” ");
INSERT INTO tbc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Man dugo, Tamol a Anut idinig idu yan, iŋ awan Anut san awan aban mi iŋiŋeŋ da. Ata wo? Anut iŋ Ur kabelan ka Tamol an ta ipani na da, tia, iŋsan Ur tubun mi iŋ lo awan isa wa. ");
INSERT INTO tbc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bai iŋanen Nanun o tubun mi imat go, mel fidian iŋ banin lo idiri a. ");
INSERT INTO tbc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ta iŋ Anut nanun ilon lo rumok tap, iŋ kumaen pempem yen san iŋane la ya. Gug iŋ a Anut Nanun patun ipani dan, iŋ kumaen pempem yen san ta ile na wa. Man ata wo? Anut san tiŋae saiak iŋ lo yen da. ");
INSERT INTO tbc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Jesus tamolpein wei mi iŋsan na dupalug iŋanen megeloum dilasa gug isuguai a. Tamolpein a Jesus isuguai se yan san sutek man Jon san iriŋani a. (Jesus iŋsen tamolpein ta isuguai na ya. Tia, iŋanen megeloum mi urat an digane ya.) Farisi adi Jesus dugo igane yan duloŋ, an niŋen o ta iŋ Jesus irupei iloŋ. Ago tag iŋ Judea ibiseig fon imul Galili na yau o tureŋ yabi a. ");
INSERT INTO tbc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dal an Sameria dumado dak titiŋaem idug yau a. ");
INSERT INTO tbc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iŋ yaug Sameria sad panu ta, yaŋan Sikar dubol dan ate ilasa ya. Abaŋ an tubud baged Jakob nanun Josef tan ipani an siŋiren na sumeikan a. ");
INSERT INTO tbc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Aria, Jesus tureŋ yabig yau do nad ad titiŋae mi an iŋ urei ifuni gug, you gib an fun na ilasa ya. Gib an Jakob san you gib dubol da. Iŋ yaes ibal o imasig imado ya. Gug iŋanen megeloum man iŋ anaŋ didad o panu na diau la ya, agod Jesus mi iŋsen kisaek imado. Agog Sameria pein ta you gib an isiri wo idu nad Jesus ile ya. Jesus iŋ you o imat saian tag, pein an irupei, “You kitek sirip panag ŋaluk.” ");
INSERT INTO tbc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Juda iŋ Sameria da man nug lo siai dumado da, agod iŋ nug san anaŋ ta diani na da. An niŋen o pein an imasa saian go irupei, “Oŋ ata wo ŋai oŋ you ŋupanop, uluk o ubol di? Oŋ Juda, agod ŋai man Sameria.” ");
INSERT INTO tbc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus pein an ru naon irupeig ibol, “Oŋ talpein e, ‘you panag ŋaluk’ ago ibol an, agod Anut san lou panek an dam uloŋ uyan ak man, oŋ iŋ sumiani dop, you kumaen san an ipanop uluk a.” ");
INSERT INTO tbc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ago tag pein an Jesus irupei, “Tamol tubun en, oŋ you kapen ama tia ya. Agod you gib en kuror kasik a. Ago yak niŋen o you a kumaen san an oŋ dugon te ŋane wak i? ");
INSERT INTO tbc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Idsad tubud baged Jakob iŋ you gib en yabig maŋ ipanama ya. Iŋsen you en iluk na ya, iŋanen nanun muroun dam, makau, sipsip dam you en diluk na ya. Ak nag oŋ iŋ riŋani ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ago tag Jesus pein en awan yabig ibol, “Ta iŋ you en iluk tap, iŋ fon you o imat da wa. ");
INSERT INTO tbc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gug ta iŋ you a ŋai ŋupani wan iluk tap, iŋ afon you o ta imat na wa. Rumok, you a ŋai ŋupani wan, iŋ ilon lo pempem ibanai ilasa dop, kumaen pempem yen san ipani wa.” ");
INSERT INTO tbc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ago tag pein an ibol, “Tubun en, oŋ you an ŋai panag. Agop ŋai fon you o ŋamat dop, you ŋisiri wo ta ŋupalu na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus awan yabig irupei, “Oŋ waup, oŋane iwo ŋane gup, fon ente ida apalu.” ");
INSERT INTO tbc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Agog pein an ru naon irupeig ibol, “Ŋai iwog tia ya.” Ak man Jesus ibol, “Oŋ iwo tia ubol dan rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Oŋ wagam tamol faiv uŋal la ya. Gug gamu tamol a iŋ oŋ ida amado dan man iŋ oŋsa iwo tia ya, an niŋen oŋsa ru ubol an ru rumok geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pein an ago iloŋ man, imasa saian go Jesus irupei, “O tamol tubun en, ŋai ilog isafulale ya. Oŋ Anut san profet. ");
INSERT INTO tbc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dugudo, maŋ tubum murouma iŋ did en fo dutumanig, Anut ubou an dile na ya. Gug aŋ Juda man Jerusalem na mi aup, ante Anut ubou an ale wo asue ti abol da.” ");
INSERT INTO tbc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ago tag Jesus irupei, “O pein, ru e ŋurupaio den ilo lo rumok pe wabi. Nal ta idu dop, ate Bai Anut san ubou leil an did en fo, agod Jerusalem lo dam, ta agane na wa. ");
INSERT INTO tbc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aŋ Sameria adi Anut a niŋen o ubou ale dan ta aloŋ uyan na ya. Gug maŋ Juda man iŋ maloŋ uyanan a. Man ata wo? Anut tamolpein iŋal pe patu pasek ipidinai san dal man Juda sad dar lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gug nal ta idu wo yan gamu nek e ilasa la ya, ante man tamolpein ensauta a kagin nuŋon ak lo mi Anut san ubou an dile dan, Urgun lo, agod ru rumok ak da, iŋ niŋen o ubou dile wa. Man dugo, Anut ensauta a ubou naok ago digane dan mi yil o abaŋad yabi da. ");
INSERT INTO tbc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anut man iŋ Ur a. Fun an niŋen o, tamolpein ensauta a iŋ kagin nuŋon ak lo mi ubou an dile dan man, iŋ Urgun lo, agod ru rumok da, iŋsan ubou an dile wa.” ");
INSERT INTO tbc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ago tag pein an Jesus irupei, “Ŋai ŋaloŋ ak, Mesias ipalu da. Iŋ id ibinawad san Anut ipiliani a. Iŋ ipalu gup, mel fidian kuai te igane ilasa dop tile taloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Agog Jesus pein an irupei, “An bo ŋaiseg, nek e oŋ da tiŋiŋeŋ da.” ");
INSERT INTO tbc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesus pein ida diŋiŋeŋ di dumado dugo iŋanen megeloum dupalug dilasa ya. Ago dile man iŋ durut saian geig a. Gug iŋ luluŋad lo tamol ta kisaek Jesus isumianig, “Oŋ ata ipano wo ida aŋiŋeŋ i?” tia, “Oŋ ata wo ida aŋiŋeŋ i?” ago dubol man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Agog pein an you kapen igansig you fun na yen dugo, imul panu na yaug tamolpein irupudai, ");
INSERT INTO tbc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Apalup, tamol ta iŋ ŋai kulob ŋigane na yan fug fidian ifulale idu pasik an ale. Dag iŋ Kristus boi?” ");
INSERT INTO tbc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ago tag fidian panu dubuseig, Jesus dile wo you fu na diau. ");
INSERT INTO tbc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Agog Jesus san megeloum iŋ durupei, “Tubun ak, oŋ gidad nuai a.” ");
INSERT INTO tbc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gug iŋ awad yabig ibol, “Ŋai anaŋ sen ta amag da yak, an ŋani san an aŋ ta aloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","An niŋen o iŋanen megeloum nug durupeig dubol, “Dag tamol ta anaŋ isini ipalug ipanig yani la boi?” ");
INSERT INTO tbc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Gug Jesus irupidaig ibol, “Ŋaisag anaŋ man igo ya, ŋai Bai idinag go ŋupalu yan iŋanen awan ŋuri ŋupanip, iŋanen urat ŋiganep itout pasik a, an mi ŋaisag mel tubun a. ");
INSERT INTO tbc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aŋ igo abol, ‘Kalam iwoiwo yau gup man anaŋ ibes idu wa.’ Gug ŋai rumok ŋurupaiaŋ da, malam yaup abaŋ ale, aŋ gidad anaŋ ale alubani. Nuŋon tales san saen idaisudag yen da. ");
INSERT INTO tbc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tamol iŋ anaŋ nuŋon urat an igane dan, iŋ naon uyanan iŋane wa. Iŋ tamolpein itumanaip, kumaen pempem yen san diŋane wa. Urat an fun igane la ya. Ago dop tamol anaŋ piapae san, nuŋon iles san an ida sisem sed iyuŋanai a. ");
INSERT INTO tbc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Fun an lo, ru a tamolpein diŋiŋeŋ na yan nuŋon ilasa ya, ‘Tamol ta kisaek anaŋ ipae da, ak gug tamol sen ak anaŋ iles da.’ ");
INSERT INTO tbc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ŋai aŋ abi a ante anaŋ ta apae na yan lo, anaŋ ales san urat agane wo ŋidinaŋ go au a. Tamolpein aenta abi an lo urat tubun mi digane la ya. Aŋ iŋsad silali naon aŋane ya.” ");
INSERT INTO tbc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sameria panu an san tamolpein wei mi iŋ pein an san ru duloŋ go, Jesus lo ilod rumok a. Man dugo, pein an ibol, “Ŋai gubak mi kagin dugo ŋigane na yan fidian irupaiag a.” ");
INSERT INTO tbc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","An lo saen Sameria adi Jesus san na dupalu dugo, iŋ kitek dida dumado wo dusumiani a. Ago tag nal uraru ante dida dumado ya. ");
INSERT INTO tbc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gug gamu tamolpein nen wei geig iŋ Jesus sen awan lo ru duloŋ ak niŋen o ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iŋ fidian mi pein an durupei, “Gamu en maŋ oŋsa ru mi maloŋ ak o iloma lo ta rumok na ya. Tia, maŋsema Jesus sen awan lo ru maloŋ ak o iloma lo rumok geig a. Agod maŋ maloŋ ak, nek tamol emaiak, rumok nuŋon mi, iŋ tan en san tamolpein fidian sad patu pasek tamol.” ");
INSERT INTO tbc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nal uraru an itout go, Jesus Sameria adi ibisawaig imul Galili na yau. ");
INSERT INTO tbc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Gubak mi Jesus iŋsen igo ibol ilasag ibol, “Anut san profet iŋsinan panu fun lo man yaŋan tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aria, saen iŋ Galili na ilasa dugo, tamolpein dileg duyuŋani a. Man fun dugo, iŋ dam Jerusalem na nal tubun an lo, kulob kulob a ante igane yan dile yak niŋen o, ago malan dupare ya. ");
INSERT INTO tbc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Agog Jesus fon Kana panu na ilasa ya. Panu ante imug you ibilisag wain ilasa ya. Ante imado dugo, kiŋ san urat tamol gurman ta nanun Kaperniam na imado yan, subam ifuni saian. Iŋ Jesus Galili distrik lo imado yan iloŋ tag, imasag ririan Jesus san na yau. Iŋ yaug, iŋanen nanun imat o itor dan, Jesus ikubunep uyan ilasa wo imosiai a. ");
INSERT INTO tbc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Agog Jesus irupei, “Aŋ tamolpein pempem kulob ta girager aman da yak, agod kulob a urer san dam ale wo ilom ibol da. Tia dop, aŋ ilom lo ta rumok na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","50","Ago dugo kiŋ san urat gurman an fon iŋ igudanig ibol, “O Tubun ak, oŋ palu kisaek oŋ. Kabelan ŋaineg nanuk imat banau.” Jesus awan yabig ibol, “Oŋ wau, oŋane nanu uyan imado wa.” Aria, tamol gurman an Jesus san ru ilon lo rumok go yau. ");
INSERT INTO tbc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iŋ yau oŋ dugo, iŋanen urat pinein dal na naon ditareg durupei, “Oŋane nanu uyan ilasag imado da.” ");
INSERT INTO tbc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ago dubol tag, iŋ isumianai, “Ad mitilaen dugo woŋ dugo tinin kitek uyan i?” Iŋ awan diabig dubol, “Nor ad isakek o itor dugo, tinin ibubarum a.” ");
INSERT INTO tbc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ago tag taman fon ilon isoug, nor nek ad ago Jesus irupeig, iŋanen nanuk uyan imado dak ibol a. Agog iŋ Jesus niŋen o ilon lo rumok dugo, iŋanen muroun muroun dam fidian ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus iŋ Judea ibiseig Galili na ipalu gug, kulob girager en igane ya. Kulob en Jesus san urat girager tinin te yak Galili distrik lo igane ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Murnag Juda adi sad tumanek nal tubun ak ta ilasa wo dugo, Jesus dam Jerusalem na yau. ");
INSERT INTO tbc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem man pat nam ar dufou dulubani a. Ar san dalawan wei mi dien da. Dalawan ta “sipsip sad dalawan” dubol dan te you saltek ta yen da, Hibru ru lo yaŋan Betesda dubol da. You an aen te lalai miriau faiv ate dien da. ");
INSERT INTO tbc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Lalai miriau an ate man tamolpein subam funfun amad da yak ate dumado da. Aenta malad tia yak, aenta ŋied saian ak, aenta ŋied banid tubabun ak, ante eŋel ta ipalup, you lo idup you ila iso dop, dile wo mala nouk dumado da. Gug enti iŋ imug you lo idu dan iŋanen subam itout a. ");
INSERT INTO tbc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aria, tamol ta iŋ miriau ante anaŋar 38 subam iŋaneg imado ya, iŋ itor san tia, ago yen oŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus tamol an ile dugo, iŋ saen milaen mok subam anda yen na yan durupei a. Ago tag Jesus isumianig ibol, “Dugo, oŋ tini uyan o ilo ibol di?” ");
INSERT INTO tbc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ago dugo subam tamol an Jesus awan yabig ibol, “Awo. Tamol tubun en, uloŋ, saen you ila iso dop, ŋai tamol ta ibinawag pe, you lo ibilag ŋadu san tia ya. Ŋaiseg ŋibitinae ŋadu wak, gug aenta mi iŋ ŋai diriŋanag pe dunug dudu da.” ");
INSERT INTO tbc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ago tag Jesus irupei, “Masa utur pe, oŋane gadab an wabisa sinip wau.” ");
INSERT INTO tbc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesus ago ibol an ririan tamol an tinin uyan ilasa, agog imasa itur go iŋanen gadab an yabisa isinig yau. Kulob an man Juda sad ubou nal lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ago yak niŋen o Juda adi tamol a tinin uyan an dupeig dubol, “Gamu man yaes bilabal san nal, oŋsigane gadab sinip utor san man geg mok a.” ");
INSERT INTO tbc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ago tag iŋ ru naon igo ibol irupudai, “Tamol a ŋai ikubuniag an iŋsen ŋai irupaiag go ŋaisag gadab ŋiŋaneg ŋau da.” ");
INSERT INTO tbc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ago tag fon dusumiani, “Tamol enti oŋ ago gane wo irupaio i?” ");
INSERT INTO tbc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ak man tamol uyan ilasa an iŋ tamol a iŋ ikubune yan ta iloŋ na ya. Man dugo, tamolpein doup tubun mok an lo Jesus luluŋad lo yau imianuk a. ");
INSERT INTO tbc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Murnag Jesus tamol an tempel ilon lo ile tag irupeig ibol, “Uloŋ, gamu oŋ uya la ya. Oŋ fon kagin saian ak ta gane na wa. Kabelan muruan nen tubun geig ak ta oŋ lo ilasa banau.” ");
INSERT INTO tbc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Agog tamol an yaug, Juda gurman adi irupudai duloŋ, “Tamol a ŋai ikubuniag go uyag an man yaŋan Jesus.” ");
INSERT INTO tbc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","An niŋen o Juda adi Jesus yaes bilabal nal lo urat igane an niŋen o tiŋaed saian go fun diganeg muruan dupani se ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ago tag Jesus irupudai, “Ŋaisag Tamag iŋ nal fidian urat igane yau da, an niŋen o ŋai dam nek ago ŋigane da.” ");
INSERT INTO tbc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ru an niŋen o Juda adi tiŋaed saian go, Jesus dufuni imat o maeg tubun mi digane na ya. An sabat nal ipilali ak niŋen o mi iŋ ago ta digane na ya, tia, Anut iŋ taman mok ibol ak, ru naok an lo iŋsen Anut da tou kisaek mi ibol da, an lo tiŋaed tubun mi saian a. ");
INSERT INTO tbc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus irupidaig ibol, “Ŋai rumok nuŋon mi ŋurupaiaŋ da, Nanuk man iŋ sen ilon nam mel ta igane san tia ya. Tia, iŋ Bai san banin leil ipani dugo, kagin naok dugo yak igane dan ago mi iŋ dam igane wa. Man dugo, urat dugo Bai igane dan mi Nanun dam igane da. ");
INSERT INTO tbc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taman iŋ Nanun o imat go, urat fidian igane dan ikubiai panig ile iloŋ a. Awo, aŋ amasa saian san urat tutubun geig ak taida ŋigane wo ikubiai panag a. An urat e gamu igane den iriŋani geig dop arut saian a. ");
INSERT INTO tbc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ata wo? Taman iŋ tamol dumat ak fon iburousap kumaen ipidinai san iloŋ a. Nek ago mi Nanun dam iŋ sen ilon ibol ak atem, enti kumaen ipani wan ago igane wa. ");
INSERT INTO tbc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taida mi, Taman iŋ tamolpein ta bitinaek lo ta idirai na da. Tia, urat an man Nanun mi banin lo igane pasi a. ");
INSERT INTO tbc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taman ilon man, nek ibol tamolpein Taman yaŋan disini dak igo woŋ, iŋ fidian Nanun dam yaŋan disini wa. Talpein enti a Nanun yaŋan ta isini na dan man, Taman a Nanun iganeg ipalu yan dam yaŋan ta isini na da. ");
INSERT INTO tbc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ŋai rumok nuŋon mi ŋurupaiaŋ da. Talpein enti iŋ ŋaisag ru iloŋ dugo, Anut ŋai idinag go ŋupalu yan ilon lo rumok dan, Anut ru ibol pe talpein an ideg yau ak ta mok igane na wa. Tia, talpein an kumaen pempem san iŋane la ya, iŋ mateŋ san dal ibisei lag, gamu kumaen san dal lo itor da. ");
INSERT INTO tbc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ŋai rumok nuŋon mi ŋurupaiaŋ da, nal ta idu wo igo yan gamu nek e ilasa la ya. Nal an lo tamolpein gamu mateŋ san dal lo dutor dan Anut Nanun awan duloŋ a, ago dop a iŋ awan duloŋ dan, kumaen pempem san diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bai iŋ kumaen san taman imado dak ago mi Nanun dam iŋ kumaen an ipani a, an niŋen o iŋ dam kumaen san fun imado da. ");
INSERT INTO tbc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Agod iŋ Nanun tamolpein bitinaek lo idirai san dabai ipani a, man dugo, iŋ Tamol Nanun a. ");
INSERT INTO tbc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Aŋ mel an niŋen o arut saian amoi, man dugo, nal idu dan te dop, tamolpein a fidian sad mutou lo dien dan iŋsan awan duloŋ a, ");
INSERT INTO tbc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","agop iŋsinad mutou awan dibiseip dilasa wa. Tamolpein ensauta a kagin uyan ak digane na yan dumasap kumaen pempem san diŋane wa, ago dop a iŋ kagin saiak saiak digane na yan dumasap Anut ibitiniai gup dideg diau a. ");
INSERT INTO tbc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ŋai seg ilog nam mel ta ŋigane san man dabai amag tia ya. Ŋai bitinaek ŋigane den man Bai sen irupaiag ago mi ŋiŋane da, an niŋen o ŋaisag bitinaek man uyan a. Man ata wo, ŋaiseg ilog ŋurig, urat ta ŋigane na da, tia, a iŋ ŋai idinag go ŋupalu amaiak ilon mi ŋiri wo yaes isofutanag da. ");
INSERT INTO tbc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ŋaiseg niŋeg o mi ru ŋabol dop man, idsad kubiaeŋ ibol ago tamol kisaek san ru an dabai aman tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ak man talpein sen ak ŋaisag ru dabai ipani da, agod ŋai ŋaloŋ ak iŋ ŋai niŋeg ru ibol dan iŋsan ru man rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aŋ gubak mi tamol adinaig suguek san Jon san na diaug, ŋai niŋeg o mi ru rumok ak kuai tem ibol dugo duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gug tamol ta ŋaisag ru en dabai ipani wo ru ta ŋabol na da, tia, aŋ ŋai o ilom lo rumok pe, Anut patum ipasi wo ru en ŋabol da. ");
INSERT INTO tbc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon man iŋ sul igo woŋ ided dugo tamolpein lilaman ipidinai a. Iŋ imado an lo saen katukan mi aŋ ilo uyan am da iŋsan lilaman lo amado ator na ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ak man mel ta ibalsiŋanag go ŋai niŋeg ibol ilasa dan, Jon san ru iriŋani a. Urat e ŋigane den, urat nek emaiak ŋigane itout o Bai banig lo iganeg ŋigane da. Urat nek en ŋai niŋeg o ikubiai panaŋ dak, Bai iŋsen ŋai idinag go ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Agod Bai a ŋai idinag go ŋupalu yan iŋsen, ru rumok ŋai niŋeg o ibol a. Ago gug aŋ kududom iŋ awan kitek duloŋ man tia, agod tinin san leil an dam ale man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iŋanen ru dam aŋ lo tia ya. Man dugo, Bai ŋai idinag go ŋupalu ya, ago gug ŋai o ilom lo ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aŋ ru a Anut san buk lo yen dan lo abaŋ tubun mi ale da, man dugo, aŋ ilom igo isou da, ru an lo kumaen pempem san aŋane wak abol da. Ak man ru nek emaiak ŋai niŋeg o mi ibol na ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ago bo man, aŋ ŋaisag na apalup, kumaen an aŋane wo man amoi da. ");
INSERT INTO tbc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Gidad tamolpein ŋai yaŋag diabisa wo digane bo man, iŋsad per panek ta ŋiŋane na wa. ");
INSERT INTO tbc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ak man ŋai aŋ ŋaloŋ fufei, aŋsam kagin man sen a. Agod ŋai ŋaloŋ ak, aŋ ilom lo man Anut o ta amat na da. ");
INSERT INTO tbc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ŋai Tamag san yaŋan lo ŋupalu ya. Ago gug aŋ ŋai ta aŋiliag na ya. Gug tamol sen ak iŋsen yaŋan lo ipalu dop man, aŋ iŋ ayuŋani wa. ");
INSERT INTO tbc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aŋ Anut mi sen kisaek san na yaŋak tubun aŋane san amoi da, ago gug aŋsem nug teim taom lo mi yaŋak tubun ak aŋane wo agane da. Aŋ ago agane tap, dugo woŋ ŋai niŋeg o ilom lo rumok ak i? ");
INSERT INTO tbc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ago yan niŋen o kabelan aŋ ilom lo ŋai Bai naon na aŋ ru lo ŋidiraŋ ak abol banau. Tia, tamol enti a aŋ ru lo idiraŋ amaiak Moses mi a. Aŋ ilom lo iŋ murnap ibinawaŋ o abol, agod iŋ lo mi aŋanem tini gane agane da. Ago bo man, iŋ ru lo idiraŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aŋ Moses san ru ilom lo ta rumok na ya. Aŋ ru an ilom lo rumok nuŋon ak man, aŋ gamu aŋanem ilo rumok ŋai lo agane wa. Man dugo, Moses ŋai niŋeg o ru igire ya. ");
INSERT INTO tbc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gug aŋ iŋsan ru igire yan ilom lo ta rumok na ya, an niŋen o, en dugo woŋ pe aŋ ŋaisag ru ilom lo rumok ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Murnag Jesus anen megeloum dida dumasag wog diŋaneg, you Galili awan aen ate diau. You an yaŋan neinta Taiberias dubol da. ");
INSERT INTO tbc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tamolpein wei mi Jesus ŋien aban fo diau, man dugo, iŋ tamolpein subam amadi da yak ibinawaig uyadi dugo kulob girager dile amaiak niŋen o iŋ ŋien fo diau na ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus iŋanen megeloum dida diaug tan bubun fo disida diaug, ante dumasig dumado. ");
INSERT INTO tbc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nal an man Juda sad nal tubun, tumanek tubun san nal Pasova dubol dan san saen sumeikan a. ");
INSERT INTO tbc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Agog Jesus malan ila iso ak man tamolpein wei mi iŋsan na dupalu dugo yil a. Ago tag iŋ Filip irupei, “Id dugon te anaŋ ta tadad pe, tamolpein en diani wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iŋ ilon lo, mel dugo igane wo man yen la ya, ago gug Filip ikubiani wo ago isumiani a. ");
INSERT INTO tbc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aria, Filip imasa saian go ru naon igo ibol, “Id gidad pat tubun mi lo anaŋ tadad bo man, tamolpein en kitek kitek dianip ta idaisuda na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Agog megeloum ta Andru, Saimon Pita tein, amaiak Jesus irupei, ");
INSERT INTO tbc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pinein nanun ta ente imado da, iŋ bret bali faiv, agod iy uraru aman da ya. Ago yak man, dugo woŋ pe ate tamolpein warou tubun en tufutaip idaisuda wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gafurfur uyanan ante yen da, an niŋen o Jesus megeloum irupidaig ibol, “Tamolpein arupidaip ante dumasi.” Ago ibol go iŋ gafurfur fo dumasi a. Tamol mi sad sutek man faiv tausen igo ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Agog Jesus bret iŋaneg, Anut ilo uyan ru ipani gug, an fidian iwae pidinaig diani a. Iy dam nek ago mi iganeg, iŋaned ilod ibol ak ate mi diani a. ");
INSERT INTO tbc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Diani itout an iŋanen megeloum irupidai, “Aŋ anaŋ samsamun yen dan atumani. Kabelan anaŋ samun ta kawan tibidani banau.” ");
INSERT INTO tbc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ago tag anaŋ samsamun dutumanig, sareg 12 tutubu yak ditane idug, awad isa ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","An niŋen o tamolpein kulob girager dabai an dileg, agog nug lo diŋiŋeŋ go dubol, “Rumok nuŋon, aŋ ilom dugo isou dak i? En man tag Profet a Anut gubak mi ibol amaiak tan na ipalu wo tamol nek ema ya.” ");
INSERT INTO tbc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gug Jesus iloŋ ak, iŋ dupalup, dabai nam diabip, diŋane diaup iŋsad kiŋ digane ilasa wo da. An niŋen o iŋ tamolpein an ilod lo sen ipasig did giraŋen na yaug imado se ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gurai idu dugo, Jesus san megeloum you tilianek Galili lo na dudu ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Iŋ loŋ na diau a, ak man Jesus iŋsad na ta ilasa na ya. Ago tag iŋ wog lo dusudag, Kaperniam na dumul diau wo loŋ dibiseig, you titiŋaem dututeg diyawai a. Saen diyawai dugo tidom idu yak man, Jesus nen gamugo loŋ na ta idu na ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Saen an lo tim tubun ak ifure dugo, tamun dam tubun mok imasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","An lo iŋ wog lo dufulanig diaug kitekan asau mi, 5 kilomita ago dugo, Jesus you aten fufo na wog naon ipanig ipalu dugo dile ya. An niŋen o direr saian geig a. ");
INSERT INTO tbc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ago dugo iŋ irupidai, “Aŋ arer amoi, ŋaiseg ŋupalu da.” ");
INSERT INTO tbc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Agog sad rurek itout go ilod pasai ibol an lo iŋ wog lo isuda wo ilod uyan a. Agog milaen tiag wog an panu diau dan ate yaug isasau a. ");
INSERT INTO tbc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Salso idug tamolpein you awan aen ate dumado yan ilod igireg igo ilod isou: Nor na man wog taida man tia ya. Wog kisaek an lo Jesus ta isuda na ya, tia, iŋsan megeloum mi dusudag diau a. ");
INSERT INTO tbc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iŋ ilod ago isou dugo, wog aenta taun yaŋan Taiberias dubol dan ateg dupalu dugo dil a. Wog an aben a ate Tubun ak bret iŋ iy da Anut ilo uyan ru ipanig diani an, siŋiren na disasau a. ");
INSERT INTO tbc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tamolpein Jesus iŋanen megeloum dida aben ante abaŋad diabi se yak man, naod ta dile na ya. Saen ago duloŋ man, wog an lo dusudag Kaperniam na Jesus dile wo abaŋan diabig diau a. ");
INSERT INTO tbc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Iŋ diaug you awan aen ate Jesus dile gug dusumianig dubol, “Girek maŋau, oŋ nal saŋepta ente palu yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus awad yabig irupudai, “Ŋai rumok nuŋon mi ŋurupaiaŋ da, aŋ kulob girager ale yan niŋen o ŋai ta abaŋag abig apalu na ya. Tia. Aŋ anaŋ anig luam ipuk amaiak niŋen o mi ŋai abaŋag abig apalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aŋ anaŋ a saen katukan lo mi saian dan aŋane san urat an ta agane na wa. Tia. Aŋ anaŋ a kumaen ipanaŋ pe pempem yau san an mi aŋane wo urat wagai agane. Anaŋ an Tamol Nanun ipanaŋ a. Anut tamol emaiak ilon ipani dugo, kob igo tinin lo iganeg yen da.” ");
INSERT INTO tbc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Agog iŋ dusumianig dubol, “Ak maŋ en dugo miganep Anut san urat migane wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ago tag Jesus awad yabig ibol, “Anut san ilo sou lo urat agane man igo ya, tamol emaiak iŋ iganeg ipalu yan mi aŋ iŋ o ilom lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ago tag iŋ dusumiani, “Oŋ enso kulob girager ta ganep, an lo maŋ mile dop iloma lo rumok ak i? Oŋ dugo gane wak i? ");
INSERT INTO tbc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wagam id tubud baged tan kawan ak ate anaŋ mana diani na ya. An niŋen o ru ta Anut san buk lo igo ibol, ‘Iŋ kumaen panu san anaŋ ipidinaig diani a.’” ");
INSERT INTO tbc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus irupudaig ibol, “Ŋai rumok nuŋon mi ŋurupaiaŋ da. Anaŋ a Moses ipanaŋ an man kumaen panu san anaŋ tia ya. Tia. Anaŋ e gamu ŋaineg Tamag aŋ ipanaŋ den, nek an kumaen panu san anaŋ mok a. ");
INSERT INTO tbc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Man dugo, Anut san anaŋ mok man, nek anaŋ a kumaen panu ibiseig idug, tan en san tamolpein kumaen mok ipidinai dan nek ama ya.” ");
INSERT INTO tbc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ago tag iŋ Jesus durupei, “Tubun ak, oŋ gidad nal pempem anaŋ an maŋ panama dop mani wa.” ");
INSERT INTO tbc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Agog Jesus irupudaig ibol, “Ŋaiseg mi anaŋ kumaen san. Ta iŋ ŋaisag na ipalu tap, iŋ fon imatigen san tia ya. Ta iŋ ŋai o ilon lo rumok tap, iŋ you o ilon igos san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ago yak man ŋai aŋ ŋurupaiaŋ la ya, aŋ ŋai aliag la yak gug, aŋ ŋai o ilom lo ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tamolpein fidian ensauta a Bai ipanag dan, iŋ ŋaisag na dupalu wa. Ago dop ensauta a ŋaisag na dupalup dida mumado wan, ŋai iŋ ŋukudai diau san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Man dugo, ŋai kumaen panu ŋubuseig ŋadu yen seg ilog nam kulob ŋigane wo ta ŋadu na ya. Tia. Bai a ŋai idinag go ŋupalu yan mi, iŋanen ilobol ŋuri ŋupani wo ŋadu ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Agod Bai a ŋai idinag go ŋupalu yan iŋsan ilon man, tamolpein e ŋai ipanag en luluŋad lo talpein kisaek ideg yau o man imoi a. Tia, an fidian nal wadan lo dop, ŋufufunaip kumaen dumasa wak ilon ago yen da. ");
INSERT INTO tbc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ŋai Tamag san ilon man igo ya. Ta Anut Nanun ilep, iŋ o ilon lo rumok an, iŋ kumaen pempem yen yau san an iŋane wa. Agod ŋai nal wadan lo ŋuburousap, fon kumaedi dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Saen Jesus, iŋsen anaŋ lak na yak ibiseig idu yen ago ibol dugo, Juda adi iŋ tiŋaed saian go iŋ niŋen o duŋurŋur se ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ago dugo iŋ dubol, “En dugudo i? Tamol an man Jesus, Josef nanun, id iŋsan tinan taman dam taloŋ a. Ago gug en dugog iŋ kumaen panu ibiseig tan na idu ibol di?” ");
INSERT INTO tbc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ago tag Jesus ru naon irupudaig ibol, “Aŋ aŋsem nug ilon lo mi aŋurŋur amoi. ");
INSERT INTO tbc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Talpein ta iŋsen ilon nam ŋaisag na ipalu san tia ya, tia, Bai sen ŋai idinag go ŋupalu yan mi talpein an iduduwi dop ŋaisag na ipalu wa. Agop nal wadan idu dan lo dop, ŋai iŋ ŋufufunip kumaen imasa da wa. ");
INSERT INTO tbc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profet adi sad ru girek lo igo digire ya, ‘Anut sen tamolpein fidian maŋau ipiteŋanai a.’ Tamol a Bai san ru duloŋ go iŋ awan lo maŋau diŋane dan fidian, ŋaisag na dupalu wa. ");
INSERT INTO tbc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Talpein ta Bai ile man tia ya. Tia, enti iŋ Anut san nag ipalu yan mi malan nam Bai ile ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rumok nuŋon mi ŋai ŋurupaiaŋ da, talpein iŋ ŋai o ilon lo rumok an, iŋ kumaen pempem san iŋane la ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ŋai mi anaŋ kumaen pempem san. ");
INSERT INTO tbc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wagam mok aŋ tubum bagem tan kawan ak ate dutor dugo, anaŋ mana diani na ya, ago bo man iŋ fidian mateŋ dile ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gug ente anaŋ a kumaen panu ibiseig idu yan yen da, ago dugo talpein enti a anaŋ an yani dan mateŋ ta ile na wa. ");
INSERT INTO tbc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ŋaiseg mi, ŋai anaŋ kumaen anda yak a kumaen panu ibiseig tan na idu ya. Talpein ta anaŋ emaiak yani dop man, iŋ mateŋ ta ile na wa, tia, iŋ pempem mi kumaen imado wa. Anaŋ en ŋaiseg tinig, tan en san tamolpein kumaen pempem san diŋane wo ŋipidinai a.” ");
INSERT INTO tbc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ago tag Juda adi iŋsed nug dupei dugo dubol, “En dugo woŋ pe tamol en iŋsen tinin ipanad pe tani wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ago dugo Jesus irupudaig ibol, “Rumok nuŋon mi ŋai ŋurupaiaŋ da. Aŋ Tamol Nanun san tinin, iŋanen dar ani aluk a. Tia tap, Anut san kumaen aŋ lo ta yen na wa. ");
INSERT INTO tbc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Talpein iŋ ŋaisag tinig yani dugo, dar ag iluk dan, iŋ kumaen pempem san iŋane la ya, ago dop nal wadan lo dop, ŋai iŋ ŋufufunip ŋabisa wa. ");
INSERT INTO tbc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Man dugo, ŋaisag tinig man anaŋ mok, agod ŋaisag dar man you mok a. ");
INSERT INTO tbc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Talpein iŋ ŋai tinig yani dugo, dar ag dam iluk dan, iŋ ŋai lo imado dugo, ŋai iŋ lo ŋumado da. ");
INSERT INTO tbc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bai kumaen imado dan iŋ ŋai idinag go ŋupalu ya, agod ŋai Bai san wagen lo kumaen ŋumado da. Nek ago mi, talpein iŋ ŋai iniag dan, ŋaisag wageg lo kumaen iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Anaŋ a kumaen panu log idu yan nek ama ya. Aŋ tubum bagem mana diani nag murna iŋ dumat a. Ak gug talpein enti a, anaŋ e niŋen o ŋabol den yani dan man, iŋ kumaen pempem imado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ru an, saen Jesus Kaperniam na ubou ab ilon lo imado dugo, ipiteŋanai a. ");
INSERT INTO tbc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ganurek tamol adi wei mi ru an duloŋ go igo dubol, “Ru en muruan kasik a, enti ru an ka iŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gug Jesus iŋ iloŋ ak, iŋsan ganurek tamol adi ru an niŋen o duŋurŋur se ya. Ago tag irupudaig ibol, “Ru an ilom muruan ipani ak i? ");
INSERT INTO tbc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ak dugo, mitep aŋ Tamol Nanun ale dop, lak na aben gubak mi imado ante isuda yau dop, an niŋen o dugo abol ak i? ");
INSERT INTO tbc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Urgun mi iŋ tamol kumaen ipani da, tinid man iŋ kitek ibinawad san tia ya. Ru e ŋai ŋurupaiaŋ den, iŋ ur agod iŋ kumaen a. ");
INSERT INTO tbc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ago gug aŋ luluŋam lo tamolpein aenta iŋ ilod lo ta rumok na ya.” Ago ibol san fun man, iŋ imug mi talpein dugon ilod lo ta rumok na dop, tamol enti iŋ ager banid lo igane man, iŋ iloŋ uyanan a. ");
INSERT INTO tbc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iŋ ru ibateg ibol, “Nek fun amaiak niŋen o, ŋai imug mi aŋ igo ŋurupaiaŋ; Talpein sen ilon nam ŋaisag na ipalu san tia ya, tia, ŋaineg Bai tamol an idaisuda mi igane ilasa gup ka ipalu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesus ru en ifulale itout go, iŋsan ganurek tamol adi wei mi iŋ dibiseig dumul diaug, iŋ afon ŋien aban ta diri na ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ago tag Jesus iŋanen megeloum 12 an isumianai, “Tag aŋ dam ŋai abisawag pe au wo ilom yen di?” ");
INSERT INTO tbc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita awan yabig ibol, “O Tubun ak, maŋ enti san na mau wo ubol di? Oŋane ru mi iŋ kumaen pempem san aman da ya. ");
INSERT INTO tbc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Maŋ maloŋ uyan go iloma lo rumok ak, oŋ mi Anut anen Tamol Gun a.” ");
INSERT INTO tbc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus ru naon irupidaig ibol, “Ŋai aŋ 12 ŋitarpasaŋ a, ago gug aŋ luluŋam lo ta kisaek man iŋ Satan san.” ");
INSERT INTO tbc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iŋsan ru lo, Judas, Saimon Iskeriot nanun an isue ya. Tamol an Jesus san megeloum 12 an luluŋad lo yak gug, mitep iŋ Jesus ager banid lo igane wa. ");
INSERT INTO tbc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Murnag Jesus iŋsen ilon dugo yen dak irig, Galili distrik lo mi itor se ya. Man dugo, Juda adi iŋ dufuni imat o digane se ya, an lo iŋ Judea distrik lo yau man imoi a. ");
INSERT INTO tbc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Agog Juda sad Lalai san tumanek tubun ak san nal ilasa san saen sumeik a. (Soubul saen an ubou kisaek yen a.) ");
INSERT INTO tbc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ago tag Jesus tein muroun bube suek ru durupeig dubol, “Oŋ gidad e utor den umoip, masap distrik Judea na wau. Ago tap man oŋsa megeloum aenta oŋsa urat dabai tutubun gane dan dile wa. ");
INSERT INTO tbc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Talpein ta iŋ malak malak yaŋak tubun ak iŋane wo tap, iŋ mianuk lo urat dabai tutubun ak igane san tia ya. Oŋ kulob igo yak gane wo tap, waup, tamolpein fidian malad lo gane wa.” ");
INSERT INTO tbc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iŋanen tein muroun mok dam iŋ o ilod ta rumok na ya, fun an lo ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","An niŋen o Jesus irupudaig ibol, “Ŋaisag nal gamugo da, gug saen fidian aŋ ilom ibol ago mi agane wa. ");
INSERT INTO tbc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Man dugo, tan en san tamolpein fidian man aŋsam ager tia ya, tia, iŋ ŋaisag ager mi a. Man ata wo? Ŋai iŋaned saian kuai tem ŋabol ilasad amaiak naon ŋisini da. ");
INSERT INTO tbc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Aŋ tumanek nal tubun an lo aladu au, gug ŋai man tia wa. Man dugo, ŋaisag nal mok gamugo ilasa da.” ");
INSERT INTO tbc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iŋ ago ibol irupudaig Galili na mi imado se ya. ");
INSERT INTO tbc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aria, Jesus tein muroun imug dusuda diau dugug, iŋsen murna imianuk oŋ yaug abaŋ ile dugo itor se ya. ");
INSERT INTO tbc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aria, tumanek tubun an ilon lo, Juda gurman adi Jesus abaŋan diabi dugo, niŋen o dusumiaig dubol, “Tamol an dugon te imado dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tamolpein an luluŋad lo Jesus niŋen o gidigidad diŋiŋeŋ ila iso se ya. Aenta dubol, “Iŋ tamol uyan a.” Gug aenta dubol, “Tia, iŋ tamolpein fidian irawai da.” ");
INSERT INTO tbc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ak man talpein ta iŋ niŋen o ru kuai tem ibol ilasa man tia ya. Man dugo, iŋ Juda gurman adi niŋedi wo direr a. ");
INSERT INTO tbc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aria, dumado yaug tumanek san saen titiŋae gug, Jesus iŋ tempel ilon lo iladug tamolpein maŋau ipiteŋanai a. ");
INSERT INTO tbc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","An niŋen o Juda adi durut saian go dubol, “Tamol en maŋau ta dipiteŋani na ya. Ago gug en dugon te maŋau igo yan iŋane yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ago tag Jesus iŋ ru naon igo ibol irupudai, “Ŋai ru e ŋabol ŋurupaiaŋ den man ŋaisag ru tia ya. Tia, en Anut ŋai idinag go ŋupalu yen iŋsan ru ŋabol aloŋ da. ");
INSERT INTO tbc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ak talpein ta iŋ Anut ilon yen dan ago iganuri wo imat tap, ŋaisag piteŋanek en Bai san ilon boi, tia, ŋaisag ilog boi, an ka walal te ile iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Talpein iŋsinanen ilo sou lo iŋiŋeŋ dan man, iŋsen yaŋan mi yabisa wo urat igane da. Gug talpein iŋ tamol sen ak idinig ipalu yan mi yaŋan yabisa wo urat igane tap, talpein an san ru an rumok mi a. Ru sewak ta iŋ lo yen man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wagam mi Moses aŋ kubiaeŋ ipanaŋ a. Ago gug aŋ luluŋam lo talpein ta kubiaeŋ en iri ipani man tia ya. Ak en ata wo ŋai afunag ŋamat o agane di?” ");
INSERT INTO tbc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","An niŋen o tumanek san doup adi ru naon igo dubol, “Oŋse ur saiak ama da ya. Enti oŋ ifuno umat o igane dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus awad yabig ibol, “Ŋai gubak mi kulob girager kisaek ŋigane yak gug, aŋ an niŋen o ilom weiwei da. ");
INSERT INTO tbc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Aria, ilom isou o uyanan. Moses san kubiaeŋ lo ru en yen da, (gug Moses aŋ kulob en ta ipanaŋ na ya, tia, aŋ tubum bagem dupanaŋ a.) Ru an igo ya, saen pein ta nanuk igansip nal 8 yau gup, nanuk an tinin suŋulon atute wa. Aŋ kubiaeŋ an ari wo nanuk suŋulon atute san nal an sabat nal dop man, kubiaeŋ an apilali san tia ya. Ak man, nal an lo dam tini suŋulon tutek san urat agane da. ");
INSERT INTO tbc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Aria, aŋ sabat nal lo tini suŋulon tutek san urat agane tap, en ata wo ŋai tamol tinin fidian mi sabat nal lo ŋukubune yan niŋen o ilom ŋai o saian dak i? ");
INSERT INTO tbc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aŋ kankan tia yak lo bitinaek ta agane na wa, tia, aŋ ilom igire na gup, kankan itaot an lo bitinaek agane.” ");
INSERT INTO tbc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem tamolpein aenkadi iŋ ago igane dugo dile yan niŋen o sed nug dusumianig dubol, “Ak dugo, tamol a idsad gurman adi dufuni imat o digane dan nek on i? ");
INSERT INTO tbc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ak ale, iŋ malak malak ru kuai tem ibol ilasa da. Gug gurman ta awan ipuk go ru ta ipani na da. Dag iŋ ilod lo duloŋ uyan ak iŋsen Kristus i? ");
INSERT INTO tbc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ak man id tamol en san fun panu taloŋ a, gug saen Kristus ipalu man, iŋ dugon te ipalu yan id taloŋ san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Agog Jesus nek ate tempel ilon lo mi imado se man, tamolpein maŋau ipiteŋanai dugo, iwagiŋ go ibol, “Awo, aŋ ŋai aloŋ a, agod ŋai dugon teg ŋupalu yan dam aloŋ abol da. Ago gug aŋ ŋai aŋaoŋ geig a. Ŋaiseg ilog nam ente ta ŋupalu na ya. Tia, Enti a ŋai idinag go ŋupalu yan mi ŋaisag fug mok a, ak man aŋ iŋ ta aloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gug ŋai mi iŋ ŋaloŋ a, man dugo, ŋai iŋsan na ŋilasa ya, agod iŋ ŋai idinag go ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ru an duloŋ tag iŋ Jesus dusubani wo dal abaŋ dile se ya. Gug tamol ta iŋ tinin ta diabi na ya, man dugo, iŋsan saen gamugo da. ");
INSERT INTO tbc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tamolpein wei mi iŋ niŋen o ilod lo rumok go ago dubol, “Tamol en tag Kristus e. Ata wo? Tamol sen ak san kulob dabai tutubun igane dan tamol en san urat iriŋani wak i? Tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tamolpein kisik kisik nam Jesus niŋen o diŋiŋeŋ dugo, Farisi adi ago duloŋ tag, pris gurman adi iŋ Farisi an dida tempel san titianek adi didinaig, Jesus dusubani wo diau. ");
INSERT INTO tbc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ago dugo Jesus ibol, “Ŋai saen katukan mi aŋ da tumado wa, ago gup Enti a idinag go ŋupalu yan san na ŋau a. ");
INSERT INTO tbc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aŋ ŋai abaŋag abi wa, ak man ta aliag na wa. Agod aben a ŋai ate ŋau dan aŋ ate au san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ago tag Juda adi iŋsed mi diŋiŋeŋ go dubol, “Tamol en dugon te yau dop, id abaŋan tile tia wak niŋen o ibol di? Dugo, iŋ dap idsad sawar aenta Grik luluŋad lo dumadod, amaiak sad na yaup ipiteŋanai dop, abaŋan tile tia wak niŋen o ibol di? ");
INSERT INTO tbc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ago dugo iŋsan awan aban igo ya, ‘aŋ ŋai abaŋag abi wa, ak man ta aliag na wa, agod aben ŋai ate ŋau dan aŋ ate au san tia ya.’ Ru en fun dugo yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tumanek digane yan san wadan futanek nal tubun ak lo, Jesus imasa itur go awan tubun mi iwagiŋ go ibol, “Talpein ta iŋ you wo imat tap, iŋ ŋaisag na ipalup you ka iluk a. ");
INSERT INTO tbc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anut san ru girek lo igo ibol, talpein ŋai o ilon rumok tap, ‘you kumaen san amaiak talpein an buben ilon lo ibanai ilasa yau dop yen a.’” ");
INSERT INTO tbc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus Awan Urgun niŋen o tou an yabig ru ibol a. Talpein ensauta a Jesus o ilod lo rumok an murnap Awan Urgun diŋane wa. Nal an lo man Jesus lak na yaŋak tubun ak iŋane wo gamugo isuda yau da, ago yan lo Awan Urgun dam gamugo idu da. ");
INSERT INTO tbc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tamolpein aenta ru an duloŋ go igo dubol, “Rumok, tamol nek en profet tubun a Anut igane ipalu wo ibol ama ya.” ");
INSERT INTO tbc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ago dugo aenta igo dubol, “En mi Kristus.” Gug aenta dubol, “En dugo woŋ pe Kristus iŋ Galili na ilasa wak i? Tia geig a! ");
INSERT INTO tbc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Man dugo, ru ta Anut san buk lo igo ibol, Kristus iŋ Kiŋ Dawid malan kubulan. Agod iŋ panu Betlehem na, Dawid san fun panu lo ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesus niŋen o tamolpein sed itarpaleg malan wei mi dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aenta Jesus dusubani wo digane, ago gug tinin ta kitek diabi man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Agog tempel titianek adi dumul pris gurman iŋ Farisi adi dida sad na diau, agog gurman iŋ dusumianaig dubol. “Aŋ dugog tamol an abig, aŋaneg ta apalu na yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gug tempel titianek igo dubol, “Gubak mi tamol ta ru ago ibol ilasa dop taloŋ man tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ago tag Farisi adi igo dupidai, “Dugudo? Aŋ dam irawaŋ go iŋ niŋen o ilom rumok di? ");
INSERT INTO tbc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dugo, maŋ gurman luluŋama lo, tia, Farisi adi luluŋad lo ta kisaek tamol en niŋen o ilon rumok ak ale i? Man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tamolpein kawan kawan, idsad kubiaeŋ ta duloŋ uyan na den mi, tamol an niŋen o ilod rumok da. Fun amaiak niŋen o iŋ fidian Anut san misilanek paen na dumado da.” ");
INSERT INTO tbc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ago dugo Farisi sad gurman ta yaŋan Nikodemus, iŋ gubak mi Jesus san na yau amaiak imasag igo ibol, ");
INSERT INTO tbc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Idsad kubiaeŋ, dugo ibol i? Id sen kawan tamol ta ru lo ka tigane wak i? Id iŋ awan taloŋ dop, dugo dugo igane yan kuai tupani gup, tibitinae a.” ");
INSERT INTO tbc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Iŋ awan diabig igo dubol dupei, “Nag oŋ dam Galili tamol i? Oŋ ru Anut san buk lo yan sutip ule gup uloŋ a, profet ta Galili na ilasa san man tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ago gug iŋ dufurak go ab anen anen ate diau a. ");
INSERT INTO tbc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Agog Jesus imasag, Did Oliv fo isida yau a. ");
INSERT INTO tbc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tidom lom mok iŋ imul fon tempel lo yau dugo, doup tubun ante dumado yan dupalug dulubani a. Ago tag iŋ imasig Anut san ru ipiteŋanai a. ");
INSERT INTO tbc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ago dugo kubiaeŋ tamol iŋ Farisi adi dida, pein ta jeit kagin igane dugo dile tag diabig, diŋane dupalu ya. Agog malak malak titiŋaem dugunig ago itur dugo, Jesus dusumianig dubol, ");
INSERT INTO tbc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Girek maŋau, pein en iwon anda ak gug, tamol sen ak da jeit diabi dugo meil a. ");
INSERT INTO tbc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aria uloŋ, Moses san kubiaeŋ lo, ru kagin dabai ak igo irupaiad a, pein ta kagin ago igane tap pat nam afuni imat a. Oŋ an niŋen o dugo ubol ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gug an man sen kawan iŋ dukubianip, ru sukurun ta ibol saian dop, ate dusubani wo ago digane ya. Gug Jesus itakoksig, banin kikoun nam tan aten fufo igire ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Iŋ afon mi dusumiani oŋ tag, ifotsag igo ibol irupudai, “Aŋ luluŋam lo enti aupasek aman tia yan, iŋ malan imug pe pat iŋanep, pein en tinin fufo ibal a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ago ibol itout an fon itakoksig, tan aten fufo igire se ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aria, talpein ru an duloŋ man kankan diŋaneg kisaek kisaek mi ditapas diau se ya. Busumadi ak imug gug, aenta dam ago mi digane yau nad, Jesus mi iŋ pein an da nuŋod uraru mi dumado ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Agog Jesus ifotsag imasa itur gug pein an isumiani, “O pein, en dugon te diau ak i? Dugo, tamol ta kisaek ru lo ta ibio udu na yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ago dugo pein an ibol, “O Tubun ak, tamol ta ru lo ibiag ŋadu man tia ya.” Ago tag Jesus irupei, “Ŋai dam ŋibio udu san tia ya. Waup, afon aupasek ta gane na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tamolpein fon Jesus san na dupalu tag, iŋ irupidaig ibol, “Ŋai tan en san lilaman. Tamol enti a ŋai ŋieg aban iri dan, iŋ tidom tubun lo ta itor na wa. Tia, iŋ kumaen san lilaman anda itor a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ago tag Farisi adi iŋ Jesus durupei, “Oŋ oŋse niŋe wo mi ru ubol da, fun an niŋen o idsad kubiaeŋ ibol man oŋane ru an dabai an tia ya. Oŋ ru kawan ubol da.” ");
INSERT INTO tbc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus awad yabig igo ibol, “Rumok, gidad ŋaiseg niŋeg o mi ŋabol ak gug, ŋaisag ru en ru rumok. Man dugo, ŋai dugot nag ŋupalu yan ŋaloŋ a, agod fon dugon te ŋau an dam ŋaloŋ a. Gug aŋ man ŋai dugot nag ŋupalu yan ta aloŋ na ya, ago dugo ŋai dugon te ŋau o dan, an dam aŋ ta aloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aŋ tan en san kagin lo mi tamolpein kubianek lo adirai da, gug ŋai talpein kisaek kubianek lo ta ŋigane na da. ");
INSERT INTO tbc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ak gug, ŋai bitinaek ŋigane tap, man ŋaisag bitinaek itaot mok a. Man dugo, ŋai seg kisaek bitinaek ta ŋigane na da, tia, Bai iŋ ŋai idinag go ŋupalu yan, iŋ ilon ŋiganurig iŋ ŋai da sisem iloma kisaek gup, bitinaek ŋigane da. ");
INSERT INTO tbc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aŋsam kubiaeŋ lo igo digire ya, tamol uraru ru kisaek mi dubol tap, iŋsad ru an rumok di dabai geig a. ");
INSERT INTO tbc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ŋai ŋaiseg niŋeg o ŋabol da, agod Bai dam ŋai idinag go ŋupalu yan, iŋ ŋaisag ru dabai ipani da.” ");
INSERT INTO tbc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ago tag iŋ dusumiani, “Oŋane tama dugon te imado di?” Agog Jesus awad yabig ibol, “Aŋ ŋai ta aloŋ na ya, ŋaineg Tamag dam ta aloŋ na ya. Aŋ ŋai aloŋ ak man, ŋaineg Tamag dam aloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Saen a ru ibol an man, tempel ilon lo moni san kunup yen dak giraŋen na imado dugo, tamolpein maŋau ipiteŋanai se ya. Gug talpein ta yabip isubani wo igane man tia ya. Man dugo, iŋsan imat san nal gamugo da. ");
INSERT INTO tbc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus fon irupidai, “Ŋai ŋubisawaŋ pe ŋau dop aŋ abaŋag abi wa, ago gup ta aliag na wa. Aŋ aŋanem aupasek Anut ta isuas na dop, aŋsam aupasek ilom lo yen dan ida amat a. Aben ate ŋai ŋau dan aŋ ate au san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ago dugo Juda adi igo dubol, “Iŋ ibol ak, iŋ ate yau dan id ate tau san tia ya. Dugo, dag iŋsen ifuni imat o ago ibol di?” ");
INSERT INTO tbc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Gug Jesus ru awan ibateg igo irupudai, “Aŋ man aben a paen na amaiak san apalu ya, gug ŋai man lak na amaiak san ŋupalu ya. Aŋ tan en san, gug ŋai tan en san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","An niŋen o ŋai ŋurupaiaŋ la ya, aŋsam aupasek ilom lo yen dan ida amat a. Man dugo, rumok nuŋon, ‘Ŋaiseg Ŋai Ŋumado Dan’ an gidad ilom lo rumok a. Tia dop, aŋsam aupasek ilom lo yen dan ida amat pe an lo adeg au a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iŋ dusumianig dubol, “Oŋ enti mok i?” Ago tag Jesus awad yabig ibol, “Ŋai nek en, seg niŋeg o gubak mi ŋurupaiaŋ go aloŋ la ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Saen ŋai aŋ kot lo ŋidiraŋ dop, ru wei mi ŋupanaŋ a. Ak man ŋai seg ilog nam ago ŋigane san tia ya. Tia, Enti a ŋai idinag go ŋupalu yan, iŋsan kagin rumok geig a, iŋ ŋaisag ru dabai ipani wa. Ŋai tan en lo ŋumado dugo, ru a iŋ ibol dugo ŋaloŋ ak ago mi tan en san tamolpein ŋurupidaip duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iŋ Taman niŋen o irupudai dan ta duloŋ uyan na ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ago tag Jesus ibol, “Murnap aŋ Tamol Nanun abisa dop, an lo gup aŋ ilom isafulale wak, ‘Ŋaiseg, Ŋai Ŋumado Dan’ nek ema ya. Ŋai mel ta seg ilog nam ŋigane san tia ya, tia, ŋai ru ŋabol den man Bai mi ŋai ikubiai panag a, ru nek an mi ŋurupaiaŋ go aloŋ da. ");
INSERT INTO tbc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Enti a ŋai idinag go ŋupalu yan iŋsen mi ŋai ida mumado da, agod iŋ ŋai ibisawag go seg ta ŋumado na da. Man dugo, iŋ ilon yen dan ago mi ŋuri ŋupani da.” ");
INSERT INTO tbc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iŋ ago ibol dugo, tamolpein wei mi iŋaned ilo rumok iŋ lo digane ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aria, Jesus Juda tamolpein a iŋ o ilod lo rumok an irupudaig ibol, “Aŋ ŋaineg ru abi sakar tap, aŋ ŋaineg megeloum mok a. ");
INSERT INTO tbc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Agop aŋ ru rumok an aloŋ a. An lo ru rumok san dabai lo aŋ urat bigabeg igo woŋ amado san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ago tag iŋ ru naon igo durupei, “Maŋ Abraham malan kubulan mok a, maŋ urat bigabeg adi igo woŋ talpein ta paen na ta mumado na ya. Man ata wo maŋ talpein an paen na ta mumado na wak, ago ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus awad yabig igo ibol, “Rumok nuŋon mi ŋurupaiaŋ da. Tamolpein a aupasek digane dan iŋ aupasek san urat bigabeg dumado da. ");
INSERT INTO tbc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Urat bigabeg adi man iŋ tamad san warou lo aben amad tia ya. Gug nanuk man iŋ taman da pempem dumado da, man dugo, taman san dar lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ago yak niŋen o Nanuk iŋ aupasek san dabai aŋ ibiaŋ adu dan tuon lo ipasaŋ tap, aŋ bigabeg adi igo woŋ ta amado na wa, tia, nanuk mok igo woŋ ator a. ");
INSERT INTO tbc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋai ŋaloŋ ak, aŋ Abraham malan kubulan. Ago bo man aŋ ŋai afunag ŋamat san dal ale wo malam agane da. Man dugo, aŋ ilom lo ŋaisag ru en aben ta ate ka yen san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ŋai mel a fidian Bai naon na ŋumado dugo ŋile yan mi ŋurupidai aloŋ da. Gug aŋ ru dugo aŋanem tamam irupaiaŋ go aloŋ ak, nek an mi ari da.” ");
INSERT INTO tbc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iŋ Jesus awan diabig dubol, “Abraham mi maŋsama tamama.” Gug Jesus igo ibol, “Aŋ Abraham nanun muroun mok ak man, kagin naok a Abraham igane na yan aŋ atutuŋani wa. ");
INSERT INTO tbc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ŋai ru rumok Anut san na ŋiŋane an mi ŋurupaiaŋ aloŋ da. Ago bo man aŋ ŋai afunag ŋamat o agane da. Abraham kagin naok ago yan ta igane na ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tia, aŋ kagin a gamu agane dan man, aŋanem taman mok san kagin mi atutuŋani da.” Agog iŋ dumasa saian geig go durupei, “Maŋ jeit kagin lo ta milasa na ya. Tia, maŋ tamama man Anut mi sen kisaek a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus awad yabig ibol, “Isop Anut iŋ aŋanem Tamami an rumok tap, aŋ ŋai niŋeg o amat a. Man ata wo? Ŋai Anut san nag ŋupalu ya. Ŋai ŋaisag ilo sou lo mi ta ŋupalu na ya. Tia, Bai ŋai idinag go ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ata wo aŋ ru e ŋabol den niŋen o ilom itarpasi san ta idaisuda na yak i? Fun igo ya, aŋ ŋaisag ru ŋabol den aloŋ san kududom itau aman a. ");
INSERT INTO tbc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aŋanem tamam Satan, aŋ iŋanen nanun muroun mok a. An lo aŋ ilom man, iŋanen ilobol mi aganuri wa. Fun mok lo ipalug gamu en, iŋanen kulob mok man, iŋ tamol ifu dumat na ya. Iŋ tinin lo ru rumok ta yen na ya, ago tag ru rumok ak ta yabig iri na da. Saen iŋ ru sewak ibol dan, iŋanen muroun ru ibol da. Man dugo, iŋ sewak tinan, agod iŋ sewak fidian an sad tamad mok imado da. ");
INSERT INTO tbc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gug ŋai ru rumok ak mi ŋurupaiaŋ da, fun an niŋen o aŋ ŋai niŋeg o ilom ta rumok na ya! ");
INSERT INTO tbc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aŋ luluŋam lo tamol ta kisaek, ŋai aupasek ŋigane yak niŋen o ilog isue san idaisuda yak i? Man tia geig a. Ago tag, ŋai ru rumok ŋurupaiaŋ aloŋ da. Ak dugo, en ata wo ru e ŋabol den ilom lo ta rumok na dak i? ");
INSERT INTO tbc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ta iŋ Anut san tap, Anut awan iloŋ dop iri wa. Aŋ Anut awan ta aloŋ na dan fun man, aŋ Anut san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda adi tiŋaed saian dugo awan diabig igo dubol, “Oŋ Sameria tamol, agod oŋ ur saiak ama da ya! Ago mabol an ta rumok na yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus ibol, “Ŋai ur saian amag tia ya. Ŋai ŋaineg Tamag yaŋan mi ŋabisa da, ago dugo aŋ ŋai yaŋag abi idu da. ");
INSERT INTO tbc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ŋai seg yaŋag ŋabisa wo urat ta ŋigane na da. Tia, Tamol sen ak ŋai yaŋag yabisa wo urat igane da, agod iŋsen mi iŋ Bitinaek Tamol a. ");
INSERT INTO tbc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ŋai ru rumok ŋurupaiaŋ da, talpein enti a ŋai awag iri ipani dan, iŋ mateŋ ta ile na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda adi ago duloŋ go awad ipuk go dubol, “Maŋ gamu maloŋ uyan ak, oŋ ur saian ama da ya. Abraham imat la yak, profet adi dam wagam mi dumat la ya. Ago bo man oŋ talpein oŋane awa iri ipani dan mateŋ ile san tia ubol da. ");
INSERT INTO tbc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Dag oŋ idsad tubud baged Abraham riŋani ak ubol di? Iŋ mateŋ ile ya. Agod profet adi dam mateŋ dile ya. Ak dugo, oŋane ilo sou lo, oŋ enso tamol i?” ");
INSERT INTO tbc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus ru naon igo ibol, “Ŋaiseg yaŋag ŋabisa dop man, ŋai yaŋag an kawan a. Gug ŋaisag Bai, iŋ aŋanem Anut abol dan, iŋ ŋai yaŋag yabisa da. ");
INSERT INTO tbc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Aŋ iŋ ta aloŋ na yak bo man ŋai iŋ ŋaloŋ a. Ak ŋai iŋ ta ŋaloŋ na yak ŋabol ak man, ŋai sewak tamol, nek aŋ igo mi a. Gug rumok, ŋai iŋ ŋaloŋ a, ago dugo iŋ awan kagin ŋupani da. ");
INSERT INTO tbc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aŋanem tubum bagem Abraham ŋaisag dal ile wo ilo sou igane dugo youn isusa ya. Aria, iŋ ŋaisag nal ile man ilon uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ago tag Juda adi durupeig dubol, “Ak dugo, oŋsa anaŋar gamugo 50 yabi bo man oŋ Abraham ule ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus ru naon irupidaig ibol, “Ŋai rumok nuŋon mi ŋurupaiaŋ da. Saen Abraham gamugo ilasa dugo Ŋaiseg, Ŋai Ŋumado Ya.” ");
INSERT INTO tbc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iŋ ago ibol an pat duburoug sen nam dufuni wo digane ya, ak man Jesus mianuk lo luluŋad lo itapas go sen tinin imianig tempel patun fo yau a. ");
INSERT INTO tbc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus tureŋ yabig yau dugo, tamol ta malan itau ak ile ya. Iŋ tinan tiŋaen lo mi mala tia igansi a. ");
INSERT INTO tbc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesus sinanen megeloum dusumianig dubol, “Girek maŋau, enti san ai wadan niŋen o nanuk an malan itau aman tinan igansi ak i? Iŋsinanen ai wadan i? Tia, tinan taman sadi ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ago gug Jesus awad yabig ibol, “Tamol en san ai wadan tia ya, tinan taman dam sad ai wadan tia ya. Kulob en igo ilasa yan, ate murnap Anut iŋanen urat san dabai tamol en tinin lo tamolpein ikubiaip dile wa. ");
INSERT INTO tbc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gamu ad aman tumado den lo, id Enti a ŋai idinag go ŋupalu yan iŋsan urat tigane wa. Mitep tidom idu dop man, talpein ta urat igane san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","An niŋen o saen ŋai tan ente ŋumado den lo, ŋai tan en san tamolpein lilaman ŋupidinai da.” ");
INSERT INTO tbc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iŋ ago ibol go, ilusu tan fo idug, tan da ikubulig iŋaneg, tamol malan ate ibubuni a. ");
INSERT INTO tbc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Agog irupei, “Oŋ waup, you saltek Siloam lo mala fulani wa.” (Siloam yaŋan fun man: iŋ idinig yau a.) Ago tag yaug malan ifulanig, malan uyan go abaŋ ile gug sinan ab lo yau a. ");
INSERT INTO tbc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aria, muroun susumeik an, agod tamolpein a iŋ wagam mi dile duloŋ na yan durut saian go nug dusumianig igo dubol, “Dugo, tamol en wagam mi malan itau imado dugo moni o igod se ama i?” ");
INSERT INTO tbc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ago dugo aenta igo dubol, “Nek tamol ama ya.” Ak man aenkadi dubol, “Man tia ya, tamol en naon nek ago mi a, gug en man tamol sen ta ya.” Ago dugo tamol an igo ibol, “Tia, en ŋaiseg.” ");
INSERT INTO tbc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ago tag dusumiani, “Oŋ dugo ganeg mala uyan ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Iŋ awad yabig ibol, “Tamol a Jesus dubol damaiak gigeo iŋaneg malag ibubunig ago ibol irupaiag, ‘Oŋ waup, you saltek Siloam lo mala fulani.’ Ago tag ŋai ŋaug malag ŋufulani man, ŋai abaŋ ŋile ya.” ");
INSERT INTO tbc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Agog iŋ dusumiani, “Tamol an dugo mi ak i?” Ago dugo iŋ ibol, “Ŋai ta ŋaloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Agog tamol a wagam malan itau an diŋaneg, dida Farisi adi sad na diau a. ");
INSERT INTO tbc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gug nal a lo Jesus tamol malan iganeg uyan an man Sabat nal lo ya. ");
INSERT INTO tbc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","An niŋen o Farisi adi iŋ dugo iganeg lo abaŋ iled amaiak niŋen o dusumiani a. Ago tag iŋ ibol, “Tamol an gigeo iŋaneg malag ate ibubuni a, ago gug idinag go ŋaug you malag ŋufulani an lo ŋai malag ipuk go abaŋ ŋile da.” ");
INSERT INTO tbc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ago tag Farisi aenta igo dubol, “Tamol an iŋ Anut san nag ta ipalu na ya, man dugo, iŋ Sabat nal san kubiaeŋ ta iri na da.” Gug aenta dubol, “En dugo woŋ pe tamol aupasek anda yak kulob girager igo yak ka igane wak i?” Nek an log nug ditarpaleg malan uraru dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Agog fon tamol an dusumiani dag dubol, “Tamol a oŋ mala ikubuneg uyan an niŋen o dugo ilo isou di?” Agog tamol an awad yabig ibol, “Iŋ profet a.” ");
INSERT INTO tbc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juda adi tamol a imug malan itau an niŋen o nen ilod ta rumok geig na ya. Ago tag iŋsan tinan taman digiaig dupalug dusumianai, ");
INSERT INTO tbc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Dugo, en aŋanem nanum mi ak i? Dugo, iŋ malan itau man tinan igansi ak i? Agog gamu en dugo iganeg abaŋ ka ile di?” ");
INSERT INTO tbc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Agog tinan taman ru naon durupidaig dubol, “Maŋ maloŋ ak en maŋanema nanuk a. Saen tinan igansi man malan tia imado ya, an dam maloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ak gug iŋ dugo iganeg lo abaŋ ka ile yan man maŋ ta maloŋ na ya. Iŋ tamol igane la ya, an niŋen o iŋsen asumiani dop, sen fun ibol aloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tinan taman iŋ Juda adi niŋedi wo direr, an niŋen o iŋ ru ago dubol a. Man ata wo? Juda gurman adi imug dutumanig ru igo dufuni a, talpein ta Jesus niŋen o Kristus ibol dop man, iŋ dukudip, midaeŋ patun fo ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kagin nek an niŋen o tinan taman iŋ ago dubol, “Iŋ tamol igane la ya, an niŋen o iŋsen asumiani.” ");
INSERT INTO tbc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ago tag tamol imug malan itau an afon mi duwagig durupei, “Oŋ Anut yaŋan mi wabisa. Man dugo, maŋ maloŋ ak, Jesus man aupasek tamol a.” ");
INSERT INTO tbc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tamol imug malan tia an awad yabig ibol, “Iŋ aupasek tamol boi, tia, tamol uyan boi, an ŋai ta ŋaloŋ na ya. Mel kisaek ŋai ŋaloŋ ak man, wagam ŋai malag itau gug, gamu ŋai abaŋ ka ŋile da!” ");
INSERT INTO tbc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Agog iŋ dusumianig dubol, “Iŋ oŋ lo dugo igane yak i? En dugo woŋ mala igane ipuk ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iŋ ibol, “Ŋai gubak mi ŋurupaiaŋ la ya, gug aŋ aloŋ an amoi. Aŋ ata wo aloŋ da wo asumianag di? Dag aŋ dam iŋsan megeloum alasa wo abol duboi i?” ");
INSERT INTO tbc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ago tag iŋ naon dufute dupeig dubol, “Oŋse mi iŋsan megeloum, maŋ man Moses san megeloum a! ");
INSERT INTO tbc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Maŋ maloŋ ak Anut sen iŋ Moses da diŋiŋeŋ a. Gug tamol a Jesus dubol dan iŋ dugon teg ipalu yan fun ta maloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tamol an awad yabig ibol, “Aŋ ru naon senamo geig aŋiŋeŋ da! En dugo woŋ go aŋ iŋ dugon teg ipalu yan fun ta aloŋ na yak i? Tamol an ŋai malag ikubuneg gamu abaŋ ŋile da. ");
INSERT INTO tbc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Id taloŋ ak, Anut tamol aupasek amad da yak awad ta iloŋ na da. Iŋ talpein a iŋ awan iri dugo, ubou an ile dan mi awan iloŋ da. ");
INSERT INTO tbc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Talpein ta ago malan itau man tinan igansip, tamol sen ak malan ikubune yak, id kududod kulob naok ago yan imug ilasa dop taloŋ man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tamol en Anut san nag ta ipalu na yak man, iŋ urat naok igo yak igane san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ru an niŋen o Juda gurman adi tiŋaed saian go dupei, “Oŋane tina iginiosi dugo, aupasek oŋ tini iŋanefute la ya! Ago tag, ata wo oŋ maŋ piteŋanama wo gane di?” Ago dubol go kuai te dubal ilasa yau a. ");
INSERT INTO tbc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus tamol an kuai te dubal ilasa yan san ru iloŋ a. An lo abaŋ an yabi yaug ile tag irupei, “Oŋ Tamol Nanun en ilo lo rumok i?” ");
INSERT INTO tbc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Agog tamol an ibol, “O Tubun en, Tamol Nanun en enti i? Ubol ŋaloŋ pe, ŋai iŋ o ilog lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus ibol, “Oŋ iŋ ule la ya. Nek gamu oŋ iŋ da aŋiŋeŋ da.” ");
INSERT INTO tbc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ago dugo tamol an naon na turun isaluwig igo ibol, “O Tubun en, ŋai ilog lo rumok a.” Agog ubou an ile ya. ");
INSERT INTO tbc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus ibol, “Ŋai tan ente tamolpein ŋitarpalaip malan uraru dilasa wo ŋupalu ya. An niŋen o mala itau adi abaŋ dile wa, ago dop talpein abaŋ diled dubol dan man, malad itau dilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi adi aenta iŋ da dumado yan, ru an duloŋ go igo dubol, “Maŋ dam malama itau ak ago ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus ibol, “Aŋ malam tia yak man, aupasek amam tia wa. Ak man aŋ malam ipuk ak abol dan lo aŋsam aupasek yen da.” ");
INSERT INTO tbc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus ago ibol, “Ŋai rumok nuŋon mi ŋurupaiaŋ da. Tamol enti iŋ sipsip sad ar san dalawan lo iladu an imoi, ago gug yaug ar awan sen ak fo isudag, ilon lo iladu dan man, iŋ gumagam tamol mala suek igane wo ipalu da. ");
INSERT INTO tbc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gug tamol a iŋ dalawan lo mok iladu dan, iŋ sipsip sad titianek tamol mok. ");
INSERT INTO tbc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Dalawan san titianek tamol iŋ tamol en dalawan ipasi pani da. Ago dugo sipsip dam iŋaned tamad awan duloŋ da. Agop saen iŋ yaŋad atem ipatep, igiai tap, iŋ awan duloŋ pe, ŋien aban fo kuai te dilasa wa. ");
INSERT INTO tbc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aria, saen iŋ kuai te dilasa itout dop, iŋ tamad imug yau dop, ŋien aban fo diau a, man dugo, iŋ tamad awan duloŋ uyanan a. ");
INSERT INTO tbc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Iŋ tamol sen ak ta diganurip diau san man tia geig a. Iŋ awan ta duloŋ uyan na yak niŋen o direr pe dusol diau a.” ");
INSERT INTO tbc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus ru faŋan an ago ibol irupudai a, ago gug iŋsan ru an fun ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","An niŋen o Jesus fon igo ibol, “Ŋai ru rumok ŋurupaiaŋ da. Ŋaiseg mi, ŋai sipsip sad ar san dalawan. ");
INSERT INTO tbc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tamol fidian a ŋai gamugo ŋupalu dugo, iŋ imug dupalu na yan, iŋ gumagam tamol. An niŋen o sipsip iŋ awad ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ŋai mi dalawan. Ta iŋ ŋai lo iladu dan, iŋ patu pasek iŋanep imado uyan a. Iŋ ŋai lo iladu ilasa dop, anaŋ yani uyan a. ");
INSERT INTO tbc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gumagam tamol man iŋ igam o, sipsip ifu dumat o, mala suek kagin mi igane wo ipalu da. Gug ŋai man ŋaineg sipsip kumaen ŋupidinaip, kumaen an ago iŋ lo awan isap, yen san niŋen o ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ŋai sipsip sad titianek uyanan mok a. Titianek tamol uyanan mok man, iŋsinan tinin iŋanen sipsip niŋedi wo igane idug imat a. ");
INSERT INTO tbc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tamol iŋ urat naon iŋane wo mi, urat igane dan man, iŋ titianek tamol mok tia ya. Iŋ sipsip sad tamadi dam tia ya. Ago yak niŋen o goun kasik ipalu dop, iŋ irer pe sipsip ibisawai yau a. Ago dop goun kasik an sipsip ifu iratitalaip, dufurak diau a. ");
INSERT INTO tbc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Fun dugo isol yau ak i? Iŋ nek tamol ta moni nam diabi dan mi a, tamol naok ago yak sipsip o ta ilon isou na da. ");
INSERT INTO tbc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ŋai sipsip sad titianek tamol uyan a. Ŋaineg sipsip ŋaloŋ do, iŋ ŋai duloŋ a, ");
INSERT INTO tbc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nek ibol Bai ŋai iloŋ dugo, ŋai iŋ ŋaloŋ ago mi a. Ŋaiseg tinig en sipsip niŋedi wo ŋubusei idu wa. ");
INSERT INTO tbc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ŋai sipsip malan taida mi sad tamad, iŋ ar en san tia ya. Sipsip an dam ŋaŋal ŋupalup ar en lo diladu wa. Iŋ dam ŋai awag duloŋ a, ago dop man sipsip malan kisaek ak, agod iŋaned titianek tamol dam kisaek a. ");
INSERT INTO tbc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bai ŋai niŋeg o imat mok dan san fun man, ŋaiseg tinig ŋibisei wak gup, fon ŋiŋane da wa. ");
INSERT INTO tbc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tamol ta iŋ ŋai iginiag ŋamat san man tia ya. Tia, ŋaineg ilog ibol ak atem ŋaiseg tinig ŋibisei pidinai a, ago gup fon ŋiŋane da wan san dabai ŋai tuog lo yen da. Bai sen ŋai ago ŋigane wo ibol a.” ");
INSERT INTO tbc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juda adi ru an duloŋ go fon ditarpaleg malan uraru dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tamolpein wei mi igo dubol, “Ur saiak iŋ lo imado dugo, burau ifunig ru ŋiŋeo ibol da. Ata wo iŋsan ru taloŋ dak i?” ");
INSERT INTO tbc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gug aenta igo dubol, “Ru naok ago yan, tamol enti iŋ lo ur saiak yen dan awan lo ta ilasa na da. Ak dugo, ur saiak ta tamol malad itau ak ikubuniaip fon abaŋ dile san idaisuda yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tempel ab awan pasek san ilo isou nal tubun ak Jerusalem na ilasa ya. Nal an madid san saen lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nal an lo Jesus tempel san tumanek aben lo, Solomon san Madok Aben dubol dan te itor a. ");
INSERT INTO tbc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ago dugo Juda adi dufutani dulubanig igo dubol, “Nal saŋeptap oŋ enti mok an kuai tem ubol dop maloŋ ak i? Oŋ Kristus dop man, kuai tem ubol dop maloŋ.” ");
INSERT INTO tbc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus awad yabig igo ibol, “Ŋai aŋ ŋurupaiaŋ la ya, ago gug aŋ ilom lo ta rumok na ya. Ŋai urat girager a fidian Bai yaŋan lo ŋigane se yan, amaiak ŋai fug mok kuai te igane ilasa dugo ale ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gug aŋ aŋanem ilo rumok ŋai lo ta agane na yan san fun man, aŋ ŋaisag sipsip tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ŋaisag sipsip ŋai awag duloŋ dak, ŋai iŋ ŋaloŋ a, agod iŋ ŋai ŋieg aban diri da. ");
INSERT INTO tbc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ŋai kumaen pempem san ŋupidinai a, an niŋen o iŋ pempem ta dideg diau na wa. Tamol ta ŋaisag sipsip ŋai banig lo ipasaip diau san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ŋai Tamag enti a sipsip an ipanag dan iŋsen mel aenta fidian iriŋanai geig a. An lo tamol ta ŋaineg sipsip ŋai Tamag banin lo ipasaip diau san dam tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ŋai Tamag da fuma kisaek a.” ");
INSERT INTO tbc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ago tag Juda adi fon pat duburoug, dufuni imat o da. ");
INSERT INTO tbc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ak man Jesus irupudaig ibol, “Ŋai Tamag wagen lo kulob girager tubun geig ak wei mi ŋukubiaig ale ya. Kulob girager an luluŋad lo kulob dugo yak niŋen o amoi dop, an lo pat nam ŋai afunag o abol di?” ");
INSERT INTO tbc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juda adi ru naon igo dubol durupei, “Maŋ oŋ kulob girager ak gane yan ta niŋen o mufuno wo iloma ago ta yen na da. Tia, fun man oŋ tamol kawan gug oŋ oŋse Anut ubol da! An niŋen oŋ Anut yaŋan wabi idu da.” ");
INSERT INTO tbc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus ru naon irupudaig ibol, “Aloŋ, aŋsam kubiaeŋ yen dan lo Anut san ru ta igo ibol, ‘Ŋai igo ŋabol, aŋsem tubud a.’ ");
INSERT INTO tbc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aloŋ, Anut iŋsan ru girek an lo, tamolpein a iŋsan kubiaeŋ diŋane yan, irupudaig igo ibol, ‘aŋsem kisaek kisaek tubud a.’ Gug tamolpein an dam tamol kawan mi a. Aria, Anut san ru a ru girek lo yen dan nuŋon an tia kawan yen san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ago yak niŋen o, ‘Ŋai Anut Nanun’ ago ŋabol tap, en ata wo ŋai Anut yaŋan ŋabi idu dak ago abol di? Aŋsam ilo saiak fun tia ya. Ata wo ŋai tamol kawan ak ago ilom isou di? Anut sen ŋai ipilianag go tan na iginiag ŋadu yan aŋ ta aloŋ na yak i? ");
INSERT INTO tbc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Urat a ŋaineg Bai igane dan ŋai dam urat kisaek mi ŋigane da. Isop an rumok tia tap, aŋ ŋaisag ru an ilom lo ta rumok na wa. ");
INSERT INTO tbc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ak man rumok, ŋai iŋanen urat ŋigane da. An niŋen o gidad, aŋ ŋaisag ru ilom lo ta rumok na yak abol bo man, kulob girager ŋigane dugo, ale yan fidian an niŋen o, aŋ ŋai o ilom rumok a. An lo dop aŋ ilo girek aganep, aloŋ uyan ak igo, Bai ŋai lo imado dak, ŋai Bai lo ŋumado da.” ");
INSERT INTO tbc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iŋ ago ibol tag Juda adi fon diabi wo digane, ak man iŋ banid lo ikisaluk ilasag yau a. ");
INSERT INTO tbc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus fon you Jordan lo yaug, ituteg, aen ate aben a wagam Jon tamolpein isuguai na yan ante ilasag imado se ya. ");
INSERT INTO tbc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ante tamolpein wei mi iŋsan na diaug igo dubol, “Rumok, Jon iŋ kulob girager ta kisaek igane man tia ya. Ago gug Jon tamol en niŋen ru fidian ibol na yan man ru rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","An niŋen o saen Jesus aben ante imado yan, tamolpein wei mi iŋ niŋen o ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tamol ta yaŋan Lasarus, iŋ subam aman da ya. Iŋsan lun man Maria iŋ Marta da, iŋ man panu Betani san tamol. ");
INSERT INTO tbc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria nek amaiak murnap Jesus ŋien gureŋ yamisip, gumuran roun sen nam isasi wa. ");
INSERT INTO tbc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Man niŋen o lun uraru an Jesus san na ru digane yau a. Agog ago dubol durupei, “Tubun en, tamol e oŋ niŋen o umat den iŋ subam ifuni a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus an iloŋ go ibol, “Subam an man tamol an igane imat mok san tia ya. Tia, an man Anut san girager tubun ak tamolpein ikubiai dilep ate yaŋan diabisa san. Nek kulob an lo Anut Nanun dam yaŋan tubun ak iŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus man Marta, tein Maria, lud Lasarus da niŋedi wo tubun mi imat da. ");
INSERT INTO tbc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aria, iŋ Lasarus subam ifuni dak san ru an iloŋ ak man, panu ante nal uraru taida imado ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Murnag megeloum adi ago irupudai, “Id Judea distrik lo fon tamul tau a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Megeloum durupeig dubol, “Girek maŋau, nor wari na geig Juda adi oŋ lo pat dubal o digane ya. Gug oŋ fon ante umul wau o ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus awad yabig, ru tuanek igo ibol irupidai, “Ilalaŋ san saen an yaup gurai isi dop, an nal kisaek igo ya. Tidom idu san gamugo da. Ta iŋ ad lo itor dan, iŋ tan en san ilalaŋ an ile dop, iŋ ŋien isuep, yau idu san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ago gug ta iŋ tidom lo itor dan, iŋ lo ilalaŋ tia yak niŋen o ŋien isuep, yau idu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesus fon mi igo ibol irupudai, “Idsad turad Lasarus yen padal a. Gug ŋai ŋaup, ŋufufunip imasa wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ru an duloŋ tag megeloum durupeig dubol, “Tubun en, iŋ yen dan ubol man, fon ka imasa dap uyan a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus Lasarus imat la yak niŋen o ibol da. Gug megeloum adi Lasarus yen padal dak niŋen o Jesus ibol ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ago yak niŋen o Jesus kuai te ibol irupudai, “Lasarus imat la ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Gug ŋai ante ta ŋumado na yan niŋen o ilog uyan. Man dugo, en aŋ ibinawaŋ dop ŋai niŋeg o ilom lo rumok a. An niŋen o iŋsan na taup tile wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Agog Tomas, iŋ yaŋan neinta Didimas dubol dan, iŋ megeloum aenta irupudai, “Gidad taup, id Jesus da sisem tamat a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus yaug ilasa dugo, iŋ Lasarus nal iwoiwo gib lo yen an san ru iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Panu Betani man kitek Jerusalem sumeikan a, kilomita utol igo woŋ yen da. ");
INSERT INTO tbc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juda tamolpein wei mi Marta Maria da ludi imat ak niŋen o dabai dupidinai o dususa ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Saen Jesus ipalu dan Marta ago iloŋ tag, imasag dal na ile wo yau dugo, Maria iŋ ab lo imado se ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesus irupei, “O Tubun ak, oŋ ente mado yak man, ŋaineg lug en imat san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ago bo man ŋai ŋaloŋ ak, oŋ mel ta niŋen o Anut gudani dop man, en fidian ka ipano wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus Marta irupeig ibol, “Oŋane lu fon kumaen imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta awan yabig ibol, “Rumok, ŋai ŋaloŋ la ya, nal wadan lo gup Anut tamolpein fidian ifufunaip dumasa wa. An niŋen o nal an lo dop ŋai lug dam fon imasa da wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Agog Jesus igo ibol irupei, “Ŋai mi, ŋai tamol fon imasa da wan san taman, ŋai mi kumaen san taman. Gidad talpein enti a ŋai o ilon lo rumok dan imat bo man, iŋ kumaen imasap imado wa. ");
INSERT INTO tbc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Agod dam, talpein enti a gamugo imat dugo ŋai o ilon lo rumok dan, iŋ pempem mateŋ ta ile na wa. Oŋ an o ilo rumok ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta irupei, “Awo, Tubun en. Ŋaisag ilo rumok nek igo, oŋ Kristus, oŋ Anut Nanun. Oŋ tamol nek emaiak tan ente palu wo Anut ibol a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta ago ibol go yaug, tein Maria yabig irae ipalug, kisik kisik nam kududon lo iŋiŋeŋ go ibol, “Girek maŋau ipalug, imado da. Iŋ oŋ ilio wo ibol a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ru an iloŋ tag, ririan imasag, Jesus san na yau a. ");
INSERT INTO tbc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus panu ante gamugo ilasa ya, tia, aben a imug mi Marta da dutumani ante mi imado ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tamolpein a Maria da ab lo ditatad dumado se yan, Maria imasa kisaek oŋ go kuai te ilasa dugo dile tag, fidian dumasag patun fo dilasa ya. Agog dubol mutou fo itata wo yau dak ago ilod isou a. ");
INSERT INTO tbc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria Jesus aben a ate imado se yan ate yaug ile man, ŋien fun na yau idug irupei, “Tubun en, oŋ ente mado yak man, ŋaineg lug en ta imat na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tamolpein dupalu yan Maria dida ditata dugo Jesus yil a. An niŋen o ilon itau idug mateŋ niŋen o ilon idu geig go ilon tubun mi muruan a. ");
INSERT INTO tbc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ago dugo isumianai, “Aŋ Lasarus dugon te aganeg yen dak i?” Agog durupei, “Tubun en, palup ule.” ");
INSERT INTO tbc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Agog Jesus tinaŋ ifunig malan turon idu ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ago dugo tamolpein dubol, “Ale, Jesus tamol an niŋen o tubun mi imat a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ago gug aenta igo dubol, “Tamol nek en tamol malan itau ak ikubuneg malan fon ipuk a. Gug ata wo iŋ tamol en san mateŋ an yabituani san ta idaisuda na yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aria, Jesus fon ilon itau idug mutou fun na yau. Mutou an iŋ pat gubaran tubun ak ilon lo diganeg, pat sen ak nam awan dibaltuani a. ");
INSERT INTO tbc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus ibol, “Pat en apasi.” Marta, tamol a imat amaiak lun, igo ibol Jesus irupei, “Tubun en, iŋ imat go nal iwoiwo yau la ya. Ago yak niŋen o mumalun iwen saian da.” ");
INSERT INTO tbc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ak man Jesus irupei, “Imug mi ŋai oŋ ŋurupaio la ya, oŋ ilo lo rumok dop man, oŋ Anut san dabai girager anda yan ule wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ago tag pat dupasig Jesus malan lak na yabisag, abaŋ ile dugo ibol, “Bai, oŋ ŋaisag gudanek uloŋ la yak niŋen o per ŋupano da. ");
INSERT INTO tbc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ŋai ŋaloŋ ak, oŋ nal fidian ŋaisag gudanek uloŋ da. Gug ŋai ru en fon ŋabol pe, tamolpein e ditur den duloŋ dop, oŋse ŋai dinag go ŋupalu yen ilod lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ru ago ibol go awan tubun mi iwagiŋ, “O Lasarus, masap, kuai te lasa!” ");
INSERT INTO tbc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ago tag tamol a imat la yan imasag, ŋien banin naon da yamel nam dubuluwi an ago tinin fo yen dugo, isinig kuai te ilasa ya. Ago dugo Jesus irupidaig ibol, “Yamel agali idu dop yau.” ");
INSERT INTO tbc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","An niŋen o Juda wei mi Maria dile wo dupalu yan, Jesus kulob girager igane yan dileg, an lo Jesus niŋen o ilod rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ago gug aenta man Farisi adi sad na diaug, Jesus kulob igane yan naod na dubol ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ago tag pris gurman adi, Farisi adi dida kaunsil digiaig dutumanig igo dubol, “Id dugo tigane wak i? Tamol an kulob girager wei mi igane da. ");
INSERT INTO tbc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Id iŋ tilefuni dop man, iŋ ago mi igane yaup tamolpein fidian iŋ niŋen o ilod rumok a. Agop Rom adi dupalup, idsad tempel dipitiŋini wa. Agop id diabituanad dop iŋsed mi sed ipilianaip Juda sad tamol gurman igo dumado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ak man iŋ luluŋad lo anaŋar en san pris malan te yak ta imado ya, iŋ yaŋan Kaiafas amaiak igo ibol, “Aŋ ilo girek amam tia geig a! ");
INSERT INTO tbc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gidad, tamol kisaek an mi imat dop, tamolpein fidian muruan diŋane san tia ya, an uyanan a. Kabelan id fidian tadeg tau banau.” ");
INSERT INTO tbc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gug Kaiafas iŋsinanen ilo sou lo mi ago ta ibol na ya. Tia, iŋ anaŋar en san pris malan te ya, an lo iŋ profet ru igo woŋ Jesus imat pe Juda tamolpein fidian abed iŋane wan niŋen o ibol a. ");
INSERT INTO tbc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Gug iŋ Juda adi mi wo ta ibol na ya, tia, iŋ Anut san tamolpein aben gidigidad dumado dan niŋedi wo dam ibol a. Jesus itumanaip Anut san nanun muroun igo kisaek mi dumado wa, fun naok ago yan Kaiafas san ru ilon lo yen da. ");
INSERT INTO tbc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aria, nal a ipalu dan lo, Jesus palaŋ an dumarig dufunip imat o dal abaŋ dile se ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Fun an niŋen o Jesus afon malak malak Judea distrik ilon lo ta itor ila iso na ya. Tia, iŋ ibisawaig yaug, tan kawan ak giraŋen na panu nanun ta yaŋan Efraim dubol dan te iŋanen megeloum dida dumado na ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aria, Juda sad nal tubun ak Pasova tumanek dubol dan sumeik a. An niŋen o panu sensen an san doup wei mi dupalug Jerusalem na dutumani a. Man dugo, iŋsed ikubuniaip Anut malan lo iŋ ikok dilasa san niŋen o ago digane ya. ");
INSERT INTO tbc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iŋ Jesus abaŋan diabig tempel lo dutur dugo, nug dusumiani se ya, “Aŋ ilom dugo isou da, iŋ ipalup, tumanek tubun en ile wak i? Tia, tia yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ago dugo gurman adi Farisi dida awad kisaek mi dutumanig, tamolpein fidian ru kagin durupidai. Ta iŋ Jesus dugon te imado dan ile iloŋ tap, gidad, kuai te ibol ilasa dop, diaup diabip, diŋane dupalu wa. ");
INSERT INTO tbc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nal 6 itout dop, tumanek ta tubun Pasova dubol dan san nal idu wa. Gug nal an gamugo dugo Jesus Betani panu na yau a. An Lasarus tamol a mutou lo ifufunig imasa yak san panu. ");
INSERT INTO tbc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iŋ panu ante anaŋ diabig, Jesus dida diani a. Ago dugo Marta man iŋ anaŋ isire idug iwae ipidinai a. Lasarus man tamol dida dumasig, Jesus dida anaŋ diani se ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ago dugo Maria iŋ gureŋ uyanan geig, naon lak na geig ak iŋaneg, ate Jesus ŋien yamisig, iŋsinanen gumuran roun nam isasi a. Ago dugo gureŋ an san mumalun ab an iŋanefute ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Megeloum ta, Judas Iskeriot tamol a murnap iŋ Jesus ager banid lo igane wan, ago ile tag igo ibol, ");
INSERT INTO tbc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dugo, id gureŋ an didaeŋ tamol tupidinaip, naon pat tubun mok ak tiŋanep bigabeg adi ka tupidinai a. Ata wo id ago ta tigane na yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ago man iŋ ru a ibol an bigabeg adi niŋedi wo ilon ta isou dugo ibol na ya. Tia, iŋ gumagam tamol, ago tag iŋ Jesus megeloum dida sad moni badam ititiani pidinai dugo, ante moni aenta iŋsen niŋen o igam na ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Man niŋen o Jesus ibol, “Amoi dop, gidad, pein en ka alefuni oŋ a, man dugo, iŋ ŋai disiriag san nal niŋen o ago igane da. ");
INSERT INTO tbc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bigabeg adi aŋ dida pempem amado da, gug ŋai man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesus panu ante imado dugo, Juda doup tubun an duloŋ tag, iŋsan na dupalu ya. Gug iŋ Jesus mi dile wo ta dupalu na ya. Tia, Jesus Lasarus mutou lo ifufunig imasa amaiak ida dil o dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ago tag Juda sad pris gurman adi iŋ Lasarus dam dufunip imat san palaŋ an dumari se ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ata wo? Lasarus niŋen o, Juda wei kasik pris awad diparsisali dugo dibisawaig, Jesus diganuri wo diau dugo, iŋ niŋen o ilod rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nal tinin te dugo tamolpein doup tubun a dilasag tumanek nal tubun ak dile wo Jerusalem na dutumani an, iŋ Jesus Betani ibiseig Jerusalem na ipalu dan duloŋ. ");
INSERT INTO tbc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","An niŋen o diaug, pator raen dulusunig, dal na dile wo diau. Agog iŋ duyuŋani dugo igo dubol duwagiŋ, “Hosana, per mupano da! Tamol Anut yaŋan lo ipalu den bar iŋane ya! O Isrel sad Kiŋ, oŋ bar ŋane ya!” ");
INSERT INTO tbc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus imug doŋki nanun ta ileg, fufo isudag imadog ipalu ya. An niŋen o ru a profet ta igire yan nuŋon ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Saion san tamolpein, aŋ arer man amoi. Ale, aŋanem Kiŋ gamu aŋsam na ipalu da. Doŋki foun ak fufo na imasig imado dugo ipalu da.” ");
INSERT INTO tbc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Imug mi megeloum adi girek an fun ta duloŋ na ya. Murnag, Jesus lak na yaug yaŋak tubun ak iŋane dugug, ru Anut san buk lo, mel en agod muruan dugo dugo Jesus dupani an niŋen o, dusutig kankan ipidinai a. Saen ru an dusuti an lo, duloŋ uyan ak, ru kulob a fidian gubak mi dile yan niŋen Anut san buk lo yen la ya, ago dugo nuŋon ilasa yan iŋsed malan nam dile ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nal an tamolpein doup wei mi Jesus dida dumado dugo, iŋ Lasarus mutou lo ifufunig fon kumaen imasa yan dile ya. Gamu tamolpein an Jesus kulob igane yan niŋen o ru duwaeg yaug fidian duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tamolpein Jesus kulob a igane yan san ru duloŋ tag, diaug dal na dile ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Man niŋen o Farisi adi iŋsed mi diŋiŋeŋ go dubol, “Ale. Idsad palaŋ marek san urat an nuŋon tia ya. Tan tilianek sad tamolpein fidian iŋ diganuri wo diau da!” ");
INSERT INTO tbc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tamolpein Jerusalem na nal tubun an dile wo dupalu dugo, Grik aenta iŋ dida diau a. ");
INSERT INTO tbc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik adi an iŋ Filip san na diau. Filip man Betsaida tamol, Galili distrik lo yan, iŋ dusumiani, “Tubun en, maŋ Jesus mile wo mupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Man niŋen o yaug, Andru irupei go iŋ Filip da diaug Jesus durupei a. ");
INSERT INTO tbc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus uraru an sad ru naon igo ibol, “Tamol Nanun iŋ yaŋak tubun iŋane san saen sumeik a. ");
INSERT INTO tbc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rumok geig ŋai aŋ ŋurupaiaŋ da, anaŋ patun ab lo ka yen dop, tan na ta idup imat na tap, man iŋsen kisaek mi yen a. Ak man, tan na idup imat tap, iŋ nuŋon wei mi ifu wa. ");
INSERT INTO tbc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Talpein iŋsen tinin mi tan na kumaen imado wo imat dop man, iŋanen kumaen mok an ibisei a. Gug tamol ta iŋanen kumaen tan en lo yabi idu dop man, murnap iŋanen kumaen mok iŋanep, pempem mi ago yen yau a. ");
INSERT INTO tbc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Talpein enti iŋ ŋaisag urat igane wo ilon yen dop man, ŋai ŋieg aban iri wa. Ago dop urat aben a ante ŋai ŋumado dan, ante mi ŋaisag urat tamol dam ŋai da mumado wa. Agod talpein enti ŋaisag urat yabi dan, Bai Anut yaŋak tubun ak iŋ ipani wa.” ");
INSERT INTO tbc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesus fon mi igo ibol, “Gamu ŋai ilog tubun mi muruan da. Man niŋen o, ŋai dugo ŋabol ak i? Bai, muruan e gamu ŋai lo ilasa wo den oŋ ka wabituani wak i? Tia geig a, ŋai muruan emaiak ŋisini wo ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bai, gidad oŋsa bunu uyan uyan ak kubiai dile!” Jesus ago ibol dugo, Anut awan lak na idug igo ibol, “Ŋai yaŋag ŋiganeg tubun la ya. Gug fon ŋiganep, tubun geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tamolpein sumeikan dutur an, ru an duloŋ, agog aenta “weil ifu dak” dubol, ago dugo aenta man “eŋel ta Jesus irupei dak” ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus ibol, “Ru e ibol ipalu den ŋai ibinawag san tia, aŋ ibinawaŋ o ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gamu Anut tan en san tamolpein kot ipidinai dop, iŋ tan en san gurman Satan an ikudip kuai te ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Gug ŋai man, murna gup dibiagsap dusuŋanag a. Nal an lo man ŋai tamolpein fidian ŋiraup, ŋaisag na dupalu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ru amaiak ibol an lo, iŋsen dugo woŋ imat o dak kuai te ibol ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ago dugo tamolpein awan diabig dubol, “Maŋ kubiaeŋ ilon lo girek igo musuti a, Kristus man iŋ pempem imado wa. An lo, ata wo oŋ Tamol Nanun diabisap dusuŋani wak ubol di? Tamol Nanun emaiak enti mok i?” ");
INSERT INTO tbc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Agog Jesus igo irupidai, “Saen katukan mi aŋ ilalaŋ da amado wa. Ago yak niŋen o aŋ ilalaŋ en lo mi ator a. Kabelan tidom tubun ituanaŋ banau. Tamol tidom lo itor dak man, iŋ aben dugon te yau dak iŋaoŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gamu man aŋ ilalaŋ am da ya. Ago yak niŋen o, ilalaŋ en aŋ da amado dugo, aŋanem tini ganei iŋ lo agane. Agop aŋ ilalaŋ san nanun muroun mi alasa wa.” Jesus ru ago irupidaig itout go ibisawaig, malad lo imianuk go yau a. ");
INSERT INTO tbc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus kulob girager an fidian Juda adi naod na igane dugo dile ya, ak gug iŋ niŋen o ilod ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","An niŋen o profet Aisaia san ru nuŋon ilasa ya. Aisaia iŋ gubak mi geig igo ibol, “Tubun en, ensauta idsad ru ilod lo rumok ak i? Tubun en, ensauta oŋ tuo kubiai pidinai dugo dile yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iŋ Jesus niŋen o ilod rumok o dumoi, an san fun igo ya. Aisaia ru ta igo igire, ");
INSERT INTO tbc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anut idiraig malad itau an dilasa ya, iŋaned ilod dam iganeg dabai geig a. An lo iŋ maladi nam abaŋ dile san tia ya, ago dugo ilodi nam maŋau diŋane san dam tia ya, taida mi, iŋ didaŋsa san tia ya, tia dop, iŋ ilod ibilisa tap didaŋsa dop ŋai ŋukubuniai a.” ");
INSERT INTO tbc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia ago ibol an san fun igo ya. Iŋ Kristus san girager tubun geig ak ile dugo, iŋ niŋen o ibol ilasa na ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ak man gurman aenkadi iŋ o ilod rumok a. Ak gug Farisi niŋedi wo direr go iŋaned ilo rumok dimiani dugo, kuai te ta digane ilasa na ya. Juda adi dukudaip iŋsad ubou ab patun fo dilasa wak niŋen o direr a. ");
INSERT INTO tbc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Man dugo, iŋ tamol dipitianai o dumat geig da, gug Anut ipitianai o man dumoi da. ");
INSERT INTO tbc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Agog Jesus isasai go awan tubun mi iwagiŋ, “Tamol ta ŋai o ilon rumok dan, ŋai niŋeg o mi ilon ta rumok na da. Tia, Bai a ŋai idinag go ŋupalu yan dam niŋen o ilon rumok da. ");
INSERT INTO tbc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nek ago mi, ta ŋai iliag dan, iŋ ŋai mi ta iliag na da. Tia, iŋ Bai a ŋai idinag go ŋupalu yan dam ile da. ");
INSERT INTO tbc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ŋai tan ente sul igo woŋ ŋupalu ya. Man niŋen o tamolpein ensauta ŋai o ilod rumok an, tidom tubun lo ta dumado na wa. ");
INSERT INTO tbc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ak man, ta ŋaisag ru iloŋ gug ta iri ipani na man, ŋai tamol an bitinaek lo ta ŋigane na wa. Man dugo, ŋai ago ŋigane wo ta ŋupalu na ya. Tia, ŋai tan en san tamolpein patud ŋupasi wo ŋupalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ta iŋ ŋai imoi dugo ŋaineg ru ta iŋane na dan, ru e ŋabol den man iŋsan bitinaek tamol oŋ imado wa. Man dugo, ru e ŋabol en, saen wadan lo gup, ru an mi iŋ ibitinae dop yabi idu wa. ");
INSERT INTO tbc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Man dugo, ŋaiseg ilog nam ru ta ŋabol na da. Tia, Bai ŋai idinag go ŋupalu yan iŋsen ru kagin igo ipanag a, ata ru ŋabol ilasa wak, agod dal dugon lo tamolpein naod na ŋiŋiŋeŋ an dam irupaiag go ŋaloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ŋai ŋaloŋ ak, talpein enti Bai san ru kagin iloŋ dop iri dan, kumaen pempem yen san iŋane wa. Amaiak niŋen o, ru dugo dugo ŋabol ilasa dan, ru nek en Bai imug mi ago ŋabol o ru kagin ipanag a.” ");
INSERT INTO tbc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova ad nanek tumanek gamugo ilasa dugo, Jesus tan en ibiseip Taman san na yau san saen sumeik an iloŋ a. Iŋanen tamolpein tan en lo dumado den ilon ipidinai a. An niŋen o gamu iŋsan ilo panek tubun a iŋ niŋedi wo yan ikubiaip dile san ago ilon yen da. ");
INSERT INTO tbc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus megeloum dida anaŋ diani wo dumasig dumado ya. Ago dugo Satan imug mi Judas, Saimon Iskeriot nanun amaiak, Jesus iŋsan ager banid lo igane wo ilon ibali a. ");
INSERT INTO tbc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aria, Jesus iloŋ ak, Taman mel fidian iŋ tuon lo idiri a, agod Anut sen idinig ipalu gug, fon imul Anut san na yau o an dam iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ago tag, iŋ anaŋ gigin na igane dugo, imasag madid san kulos itabug go, yamel ta iŋaneg luan ate ipulau a. ");
INSERT INTO tbc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Agog you daeg lo ikulmaek go fun iganeg megeloum ŋiedi ifulani a. Agog yamel ipulau an ate ŋiedi isasi a. ");
INSERT INTO tbc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aria, iŋ Saimon Pita san na ipalu dugo, Pita ilon weiwei dugo isumiani, “Tubun en, oŋ ŋai ŋieg fulani wo di?” ");
INSERT INTO tbc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus awan yabig ibol, “Ŋai mel gamu ŋigane den oŋ fun ta uloŋ na ya, ak gug murna gup oŋ uloŋ fufei wa.” ");
INSERT INTO tbc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Gug Pita ibol, “Tia, oŋ ŋai ŋieg fulani san man ŋamoi geig a.” Jesus ru naon irupei, “Gidad ŋai ŋufulano wa, tia dop, oŋ ŋai muroug luluŋad lo mado san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ago tag Pita irupei, “Tubun en, mago tap, ŋai ŋeig mi ta fulani na wa, tia, banig gumurag da sisem fulanai.” ");
INSERT INTO tbc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus ru naon irupei, “Tamol enti sen tinin fidian isug la yan man, tinin ikok a. An niŋen o ŋien mi ifulani wa. Aŋ ilom tinim fidian ŋai lo ikok alasa la ya. Gug aŋ luluŋam lo tamol kisaek imado duman ta ikokan na ya.” ");
INSERT INTO tbc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus tamol enti ager banid lo igane wan iloŋ la ya. Fun an niŋen o, “aŋ luluŋam lo tamol kisaek imado duman ta ikokan na yan” ago ibol a. ");
INSERT INTO tbc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aria, Jesus ŋiedi ifulanig itout go, iŋanen kulos fon iganeg imasig, isumianai, “Kulob a aŋ lo ŋigane yan fun aloŋ i? ");
INSERT INTO tbc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Aŋ ŋai Girek Maŋau, agod Tamol Tubun ak abol da. Man aŋ abol mok da, man dugo, ŋai tamol naok nek ama ya. ");
INSERT INTO tbc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aria, ŋai nek aŋanem Tubun ak, Girek Maŋau igo dam ŋumado bo man, ŋai aŋ ŋiem ŋufulani a. An niŋen o aŋ dam aŋsem nugnug lo ŋiem afulani wa. ");
INSERT INTO tbc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ŋai man aŋsam mitilaen igo woŋ, ŋai ŋigane ago mi aŋsem nugnug lo ago agane wa. ");
INSERT INTO tbc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ŋai rumok ŋurupaiaŋ da, urat pinein ta iŋanen tamol tubun ak ta iriŋani na wa. Nek ago mi tamol enti urat lo yau dan, iŋsan tamol tubun ak a idinig yau an ta iriŋani na wa. ");
INSERT INTO tbc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aria, aŋ gamu mel an fidian aloŋ a. Aŋ kagin naok ago yan ari dop man, Anut san bar aŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ak man, ru an aŋ fidian mi niŋemi wo ta ŋabol na da. Tia, ŋai tamol ensauta a ŋupilianai an ŋaloŋ a. Ŋai ru ago ŋabol, an lo Anut san ru iŋanen buk lo yen dan nuŋon ilasa dop ale wa. Ru an ibol, ‘Tamol ta iŋ ŋai da sisem munuai dan, iŋ ŋai iparfunag o ŋien gumin yabisa ya.’ ");
INSERT INTO tbc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gamu, saen kulob an gamugo ilasa dugo, ŋai aŋ kulob an murnap ilasa wan ŋurupaiaŋ da. Man ata wo? Saen kubol an ilasa dop, Ŋaiseg, Ŋai Ŋumado Dan aŋ ilom lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ŋai ru rumok ŋurupaiaŋ da, ŋai urat tamol adi ŋidiraig diau a. Talpein enti a ŋaisag urat tamol iŋane dan, ŋai iŋiliag da. Ago dugo talpein enti ŋai iŋiliag dan, iŋ Bai enti a ŋai idinag go ŋupalu yan dam iŋane da.” ");
INSERT INTO tbc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus ru ago ibol itout dugo, ilon tubun kasik muruan idug, ru kuai te igo ibol, “Rumok nuŋon mi ŋurupaiaŋ da. Aŋ luluŋam lo ta kisaek man iŋ ŋai ager tamol banid lo iginiag ŋiladu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iŋ ago ibol dugo, iŋanen megeloum Jesus ru an lo enti isue dan diŋaoŋ geig a, an niŋen o sed nug dile yau imul dugo awad itau dumado ya. ");
INSERT INTO tbc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Megeloum a Jesus niŋen o tubun mi imat dan, iŋ giraŋen na ida sisem dumado, ago dugo ");
INSERT INTO tbc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita naon itad panig igo irupei, “Jesus sumiani dop enti niŋen o ibol dan, ibol pe taloŋ.” ");
INSERT INTO tbc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Agog megeloum an tinin Jesus titiren fo isapek go isumiani, “Tubun en, enti niŋen o ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus ru naon irupei, “Ŋai bret tuor lo ŋisominip, ŋupani dop, aŋ aloŋ ak, nek tamol ama ya.” Jesus ago iganeg Judas, Saimon Iskeriot nanun, bret an ipani a. ");
INSERT INTO tbc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bret an iŋane dugo, Satan ilon lo iladu kisaek oŋ a. Jesus irupeig ibol, “Mel a gane wo ilo ibol dan gane kisaek oŋ.” ");
INSERT INTO tbc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gug megeloum aenta dida anaŋ diani dan, ru a ibol an san fun mok ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas man iŋ moni san badam kagin ipani na yan niŋen o, Jesus irupeip soubul tubun an san melmel ta idad o boi, tia, bigabeg adi ibinawai o boi, ago ilod isou a. ");
INSERT INTO tbc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aria, Judas anaŋ an iŋaneg imasag, ririan kuai fo ilasag yau a. Saen an tidom idu la ya. ");
INSERT INTO tbc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas yau la gug, Jesus igo ibol, “Gamu en Tamol Nanun iŋ yaŋak tubun ak iŋane san nal idu ya. An lo dop, Anut dam ŋai lo yaŋak tubun ak iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aria, Anut ŋai lo yaŋak tubun mi iŋane dop man, ŋai iŋsen lo yaŋak tubun ak ŋiŋane wa. Kulob an iŋ ago igane saltik oŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O nanug muroug, ŋai aŋ da saen katukan mi tumado wa. Ago gup aŋ ŋai abaŋag abi wak gug ta aliag na wa. Nek ibol ŋai Juda adi gubak mi ŋurupidai ak igo woŋ, ŋai gamu aŋ dam ŋurupaiaŋ da, aben ŋai ŋau dan ante aŋ au san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ŋai gamu kubiaeŋ foun ak ŋupanaŋ da. Kubiaeŋ foun ak igo ya: aŋ nug niŋen o amat mok a. Nek ibol ŋai aŋ o ŋamat dak ago mi aŋsem nug niŋen o amat mok a. ");
INSERT INTO tbc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aŋ aŋsem nug niŋemi wo amat dop man, an lo aŋ ŋaisag megeloum mok amado dan tamolpein fidian duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita Jesus isumiani, “Tubun en, oŋ dugon te wau wo ubol di?” Jesus ru naon irupeig ibol, “Gamu aben dugon te ŋai ŋau dan, ante oŋ palu san tia ya, gug murna dop man, oŋ ka palu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita fon isumiani, “Tubun en, ata wo ŋai oŋ da sisem tau san tia ubol di? Gidad, ŋaineg kumaen oŋ niŋe wo ka ŋubiseip, ŋubinawo wa.” ");
INSERT INTO tbc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ago tag Jesus igo irupei, “O Pita, oŋane kumaen ŋai o bisei wo ubol dan, an rumok i? Ŋai rumok ŋurupaio da, oŋ ŋai uloŋ an utot saen utol dop, kurek ibob a.” ");
INSERT INTO tbc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Aŋ ilom muruan dop kankan wei mi ta agane na wa. Aŋ aŋanem tini ganei Anut lo agane ago mi ŋai dam lo ago agane wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Ŋaineg Bai san ab lo man, galuŋ wei mi dien da. Ŋai ŋaup aŋanem abem ŋukubune wa. Agod saen ŋai aŋanem abem ŋukubune itout dop, ŋai ŋamul ŋupalup ŋiŋiliaŋ pe taup ŋai da sisem tumado wa. An niŋen o aben dugon te ŋai ŋumado dan, aŋ dam ante amado wa. Ak mel an ago tia dop, ŋai kuai tem ka ŋurupaiaŋ aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aben ŋai ŋau dan san dal an aloŋ la ya.” ");
INSERT INTO tbc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Agog Tomas irupei, “Tubun en, oŋ aben dugon te wau den maŋ ta maloŋ na ya. An niŋen o dal an dugo man maloŋ ak i? Tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus awan yabig ibol, “Ŋai mi dal, ŋai mi ru rumok san fun, agod ŋai mi kumaen san fun. Dal sen ta lo Bai san na au san tia ya. Nek ŋai lo mi a. ");
INSERT INTO tbc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Aŋ ŋai aloŋ dop man, ŋaisag Bai dam aloŋ a. Nek gamu tumado yau den lo, aŋ ŋai Tamag o aŋaoŋ dan ago ilom isou man amoi, man dugo, iŋ aloŋ agod ale la ya.” ");
INSERT INTO tbc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip irupei, “Tubun en, oŋ Bai kubiai panama. An mi maŋ o idaisuda ya.” ");
INSERT INTO tbc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus ru naon irupei, “Filip, nal milaen mi ŋai aŋ da tumado ya. Ak dugo, en dugo woŋ go ŋai enti mok an ta uloŋ na i? Ta iŋ ŋai iliag an iŋ Bai dam ile ya. An lo, enta wo ŋai Bai ŋukubiai panaŋ o ubol di? ");
INSERT INTO tbc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nag ŋai Bai lo ŋumado den, ago mi Bai iŋ ŋai lo imado da, an ilo lo ta rumok na di? Ru e ŋai ŋurupaiaŋ den ŋaiseg ilog nam ta ŋabol na da. Tia, Bai iŋ ŋai lo imado den iŋanen urat ŋai lo igane ilasa da. An niŋen o iŋ ŋai lo urat igane dugo, iŋsan ru ŋai ŋabol ilasa da. ");
INSERT INTO tbc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aŋ gidad, ŋai Bai lo ŋumado dugo, Bai ŋai lo imado den, an ilom lo rumok a. Tia dop, ŋai kulob girager a fidian ŋigane na yan aleg kankan ipanaŋ gup, an mi aŋanem ilo rumok ka igane ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ŋai rumok ŋurupaiaŋ da, ta ŋai o ilon lo rumok dop man, iŋ urat fidian ŋai ŋigane yan iŋ dam nek ago mi ka igane wa. Agod kulob naok iŋ iganed an man melmel e ŋai ŋigane den iriŋani wa. Man dugo, ŋai Bai san na ŋau da. ");
INSERT INTO tbc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aŋ mel ta niŋen o ŋai yaŋag lo agudani tap, ŋai mel an ŋigane panaŋ a. An niŋen o Nanun urat dugo dugo igane dan lo, tamolpein Bai yaŋan tubun mi diabisa wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ata mel aŋane wo ilom ibol dan, ŋai yaŋag lo ka asumiaeŋ a, ago dop ŋai ŋigane panaŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Aŋ ŋai niŋeg o amat mok tap, aŋ ŋaineg ru kagin ari apani uyanan a. ");
INSERT INTO tbc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Agod ŋai Bai ŋugudani dop, iŋ Binawek sen ta ipanaŋ pe, aŋ da pempem amado wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iŋ Awan Urgun, iŋ ru rumok ak san mi a. Tan en san tamolpein iŋ diŋane san tia ya. Man ata wo? Iŋ dile san tia ya, ago dugo iŋ niŋen o diŋaoŋ. Ak man, aŋ iŋ aloŋ la ya, man dugo, iŋ gamu aŋ da amado dak, murnap aŋ bubem ilon lo ilasap ante pempem imado wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ŋai aŋ ŋubisawaŋ pe, tinam tamam tia yak igo woŋ ta amado na wa. Tia ya, ŋai aŋsam na ŋupalup tumado wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Saen kitekan mip, tan en san tamolpein fon ŋai ta diliag na wa. Gug aŋ ŋai aliag a. Ŋai kumaen ŋumado dak niŋen o, aŋ dam kumaen amado wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nal an lo gup, ŋai Bai lo ŋumado dan, aŋ ŋai lo amado dan, ŋai aŋ lo ŋumado dan aloŋ uyanan a. ");
INSERT INTO tbc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Talpein enti a ŋai awag iloŋ dugo iri dan, nek amaiak mi ŋai o imat mok da. Ta iŋ ŋai o imat dan man, Bai dam iŋ o imat da. Ago dop ŋai dam iŋ o ŋamat dop, ŋai seg ŋukubiaip ile wa.” ");
INSERT INTO tbc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Agog Judas en turanein, Iskeriot tia yan, iŋ Jesus irupei, “Tubun en, oŋ ata wo maŋ lo mi kuai te lasa dop, tan en san tamolpein lo tia wo ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus ru naon irupei, “Talpein a ŋai niŋeg o imat dan, ŋaisag piteŋanek fidian iri dop paed na imado wa. Ago dop Bai iŋ o imat pe, ŋai Bai da sisem iŋ giraŋen na mupalup, iŋ da nal fidian mi mumado wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Gug ta ŋai o ta imat na dop, iŋ ŋaisag ru dam iri dop paen na ta imado na wa. Ru e aŋ kududom aloŋ den man ŋaisag tia ya. Tia, Bai iŋ ŋai idinag go ŋupalu yan iŋsan ru ŋabol da. ");
INSERT INTO tbc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Gamu ŋai aŋ da tumado dan lo, ru an fidian ŋabol ilasa dugo aloŋ da. ");
INSERT INTO tbc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gug Urgun, iŋ aŋsam binawek mok a, Bai iŋ ŋai yaŋag lo idinip ipalu wa. Iŋ mel fidian niŋedi wo maŋau ipiteŋanaŋ a, ago dop iginiaŋ pe ru fidian imug ŋabol go aloŋ na yan ilom isou a. ");
INSERT INTO tbc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ŋai aŋ ŋubusawaŋ o dak niŋen o, ŋaisag ilo maror ŋupanaŋ pe ida amado wa. Ilo maror a ŋupanaŋ dan man, tan en san tamolpein ka dupanaŋ ak igo tia ya, tan en san ilo maror man ririan itout yau a, gug ŋaisag man yen yau san mi a. Man niŋen o, aŋ ta ilom weiwei dop arer na wa. ");
INSERT INTO tbc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ŋai ru ŋabol en aloŋ la ya: ‘gamu ŋubusawaŋ pe ŋau gup, aŋsam na fon ŋamul ŋupalu wa.’ Aŋ ŋai o amat ak man, ŋai Bai san na ŋau dak niŋen o uyam isusa wa. Man dugo, Bai san yaŋan ŋaisag yaŋag iriŋani a. ");
INSERT INTO tbc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aloŋ ak, ŋai Bai san na ŋau san saen gamugo dugo, aŋ ŋurupaiaŋ la ya. Ŋai ago ŋigane yan san fun igo: murnap mel an ilasa dop, aŋ ŋai o ilom rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ŋai ru taida milaen mi ŋurupaiaŋ san tia ya, man dugo, tan en san gurman Satan ipalu wo itoŋ da. Iŋ ŋai ibiag ŋadu san man dabai aman tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ŋai ilog man igo ya. Ŋai tan en san tamolpein fidian ŋukubiaip dile dop duloŋ uyanan ak igo, ŋai Bai o ŋamat a, ago dugo ata ru Bai irupaiag an mi ŋiri uyanan da. Aria, amasap tau.” ");
INSERT INTO tbc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus irupudaig ibol, “Ŋai man ai wain mok. Ŋaineg Bai man abi wain san muroun. ");
INSERT INTO tbc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ŋai raeg aenta nuŋod tia tap, abi muroun itartitip yabi yau a. Raen nuŋon anda yan ikubunep, didilan itute yau dop, iluŋanip, ate nuŋon wei mi ifu dop yen a. ");
INSERT INTO tbc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ago gug ru ŋai ŋurupaiaŋ la yan lo aŋ ipargalaŋ go aŋ ikok alasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ŋai lo amado wa. Ŋai dam aŋ lo ŋumado wa. Ai raen a luan te ta isatuani na yak man, nuŋon ifu san tia ya. Nek ago mi, aŋ dam ŋai lo amado wa, tia dop man, nuŋom ifu san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ŋai man ai wain. Aŋ man ai wain raen. Ta ŋai lo imado tap, ŋai iŋ lo ŋumado dop, ate nuŋon ifu fufei wa. Aŋ ŋai lo tia yak man, aŋsem mel ta agane ilasa san dam tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Talpein ta iŋ ŋai lo ta imado na dan, iŋ ai raen ibun ak igo ya. Ai raen ago man ditartitip, yai lo diabi yaup inani fufari yau a. ");
INSERT INTO tbc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Gug aŋ ŋai lo amado dop, ŋaisag ru aŋ lo yen dop man, aŋanem ilom ibol ak ago mi mel niŋen o asumianag dop, ŋai ŋupanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aria, aŋ nuŋom wei mi afu yak man, aŋsem ibilaŋ kuai tem alasag ŋaisag megeloum mok amado da, nek an lo Bai yaŋan tubun geig ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Bai iŋ ŋai ilon ipanag dak, ago mi ŋai aŋ ilog ŋupanaŋ da. Aŋ ŋaisag ilo panek lo mi amado wo ilog yen da. ");
INSERT INTO tbc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ŋai Bai san ru kagin ŋuri ŋupani ak niŋen o, iŋsan ilo panek lo ŋumado da. Nek ago mi aŋ ŋaisag ru kagin an ari apani dop man, aŋ ŋaisag ilo panek lo mi amado wa. ");
INSERT INTO tbc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ru ago ŋurupaiaŋ dan aŋ aloŋ dop, ŋaisag uyasusai aŋ ilom lo yen o ŋabol da. Agop aŋsam uyasusai an ilom lo anuap ida amado wa. ");
INSERT INTO tbc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ŋaisag ru kubiaeŋ man igo ya, ŋai ilog ŋupanaŋ ak ago mi aŋ nug ilon apani wa. ");
INSERT INTO tbc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Talpein enti a iŋ turan niŋen o iŋsan kumaen imoi ibiseig imat tap, iŋ kagin fidian nug niŋen o tamat san iriŋani a. Kagin an ilo panek san nuŋon mok a. ");
INSERT INTO tbc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aria, aŋ ŋai ru kagin ŋurupaiaŋ an ari apani dop man, aŋ ŋaisag turag muroug mok a. ");
INSERT INTO tbc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Urat pinein man iŋ iŋanen tamol tubun ak mel igane dan man iŋ ta iloŋ na da. Ago yak niŋen o ŋai fon aŋ urat pinein igo ŋabol san tia ya. Man ata wo? Ŋai ru fidian Bai awan lo ŋaloŋ en aŋ ŋabol aloŋ pasik la ya, an lo aŋ ŋai fug fidian aloŋ a. Ago yak niŋen o aŋ ŋai turag muroug ŋabol da. ");
INSERT INTO tbc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aŋ imug ŋai ta apilianag na ya. Man tia. Ŋai aŋ ŋipilianaŋ go ŋaisag ak ŋabol la ya. Ago yan lo aup urat nuŋon agane ilasa san ago kob ŋupanaŋ a. Ago dop aŋanem urat an nuŋon yen yau a. An lo mel ta wo ŋai yaŋag lo Bai asumiani dop man, iŋ ka ipanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ŋaisag kubiaeŋ ŋurupaiaŋ duman nek en, aŋ nug niŋen o amat mok a. ");
INSERT INTO tbc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tan san tamolpein aŋ o ager dumado dop man, ŋai o ilom isou. Ŋai niŋeg o imug mi ago digane ya. ");
INSERT INTO tbc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Aŋ tan en san tamolpein sad muroudi dop man, aŋ niŋemi wo dumat pe, aŋ iŋsadi ak dubol a. Ak man aŋ tan en san tamolpein mok tia ya, tia, ŋai aŋ ŋipilianaŋ go aŋ ŋaisag a. Fun amaiak niŋen o tan en san tamolpein aŋ lo siai digane wa. ");
INSERT INTO tbc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aŋ gidad ŋaisag ru imug ŋurupaiaŋ en ilom isou, urat pinein ta iŋanen tamol tubun ak ta iriŋani na wa. Iŋ ŋai diginiag saian tap, nek ago mi aŋ lo dam ago digane wa. Ak dugo, iŋ ŋaisag piteŋanek diri ak i? Tia geig a. Nek ago mi, piteŋanek a aŋ apidinai an dam ta diri na wa. ");
INSERT INTO tbc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ŋai niŋeg o aŋ diliaŋ saian pe kagin naok ago yak aŋ lo digane wa. Man ata wo? Bai ŋai idinag go ŋupalu yan, iŋ ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ŋai ŋupalug, ŋurupidaig, iŋsad aupasek kuai ŋupani dugo dile ya. Ŋai ta ŋupalu na yak man, iŋ aupasek amad da yan duloŋ san tia ya. Gug ŋai ŋupalug, iŋaned saian kuai te ŋurupidaig duloŋ ak niŋen o, gamu sad aupasek an dimiani san tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ta iŋ ŋai lo siai igane dan man, iŋ Bai lo dam siai igane da. ");
INSERT INTO tbc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iŋ luluŋad lo ŋai kulob girager tubun geig ak ŋigane na ya. Tamol sen ta gubak mi ilasag kulob naok ago yan ta igane man tia ya. Ŋai ago ta ŋigane na yak man, Anut malan lo iŋ aupasek amad tia wa. Ak gug, gamu iŋ kulob girager an fidian dile la gug, ŋai lo, agod ŋai Tamag lo dam, siai digane dugo sama ager dumado da. ");
INSERT INTO tbc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Iŋsad kagin, ru ta iŋsad kubiaeŋ lo digireg yen an iganeg nuŋon ilasa ya. Ru an igo ya, ‘Iŋ sen kawan mok ŋai lo siai digane ya.’ ");
INSERT INTO tbc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Gug ŋai Binawek Tamol ŋiganep idu wa. Iŋ Awan Urgun, ago dugo iŋ dam ru rumok ak san fun. Iŋ Bai san na ilasap, aŋsam na ipalu wa. Agop iŋ ŋai fug kuai te ibol dop aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gug aŋ dam ŋai fug tamolpein naod na afulalep duloŋ a. Man dugo, saen ŋai urat fun ŋiganeg ipalug gamu en, aŋ ŋai da sisem tumado na ya. ");
INSERT INTO tbc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Muruan ipalu dop, aŋanem ilo rumok an abisei banau o ru en ŋurupaiaŋ da. ");
INSERT INTO tbc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Murnap Juda adi sad midaeŋ lo au dop, aŋ dukudaŋ a. Rumok, nal idu dop, aŋ dufunaŋ amat a, nek dal an lo iŋ Anut san urat dibinawi mok dak ago dubol a. ");
INSERT INTO tbc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gug iŋ man ŋai Bai da ta duloŋ na yak niŋen o ago digane wa. ");
INSERT INTO tbc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ŋai ager niŋedi wo ru kagin en ŋurupaiaŋ aloŋ a, an niŋen o murnap aŋ lo dugo digane dop, ru en ilom isou wa. Inug man ŋai ru en ta ŋabol go aloŋ na ya, man dugo, ŋai aŋ da tumado na ya. ");
INSERT INTO tbc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ak man gamu gup ŋai ŋubisawaŋ pe, Bai idinag go ŋupalu yan san na ŋamul ŋau a. Gug aŋsam ta kisaek ŋai dugo te ŋau o dan niŋen o ta isumianag na da. ");
INSERT INTO tbc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gug gamu ‘ŋai ŋubisawaŋ pe ŋau o’ ŋurupaiaŋ den niŋen o aŋ ilom isasau idu da. ");
INSERT INTO tbc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ŋai rumok ŋurupaiaŋ da, ŋai aŋ ŋubisawaŋ pe ŋau o dan, aŋ o uyanan a. Ŋai gidad ŋau a. Ta ŋau na tap, aŋ Ur Binawek San an ta aŋane na wa. Ak man ŋai ŋau dop man, Ur Binawek San an ŋiganep, aŋsam na ipalup, ida amado wa. ");
INSERT INTO tbc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Urgun ipalu dop, tamolpein ilod isafulalep, kagin saiak san fun, agod kagin itaot ak san fun dam dumuŋani fufei wa. Agod murnap Anut naon na ditur pe bitinaek lo idirai an san fun dam iŋsed ilod lo dukubiani wa. ");
INSERT INTO tbc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iŋaned kagin saiak san fun man iŋ ŋai lo ilod ta rumok na ya. ");
INSERT INTO tbc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ŋai Bai san na ŋau dop, afon ŋai ta aliag na wa. An lo tan en san tamolpein duloŋ ak ŋai Bai san geig a. Dal an lo Urgun iŋ ŋaisag kagin itaot an fidian ikubiai pidinaip, duloŋ uyanan a. ");
INSERT INTO tbc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tan en san tamolpein sad ilo sou lo dubol, Anut ŋai bitinaek lo iginiag pe ifunag ŋamat ak ago dubol da. Ak man an ta rumok na yan Urgun ikubiai dile wa. Anut ŋai bitinaek lo ta iginiag na wa, tia, ŋaisag mateŋ lo, Anut tan en san gurman Satan bitinaek lo iganeg yabi idu geig a. An Anut san bitinaek san fun. ");
INSERT INTO tbc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ŋai ru wei mi amag da ya, ak man aŋ ilom itau dak niŋen o, gamu ŋurupaiaŋ pe aloŋ san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gug murnap Urgun ru rumok ak san ipalu dop man, kagin rumok ak mi fidian ikubiai panaŋ a. Iŋ sen ilon nam ru ta ibol na wa. Tia, Anut ibol go iloŋ an mi irupaiaŋ pe aloŋ a. Mel murnap ilasa san dam ibol ilasa dop aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iŋ ŋai yaŋag yabisa wa, man dugo, iŋ ŋaisag mel iŋane dan aŋsam na ibol ilasa dop aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bai san mel fidian an dam ŋaisag a. Man niŋen o ŋai imug ŋurupaiaŋ, Urgun mi ŋaisag mel an iŋanep ibol dop aloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Saen katukan aŋ ŋai ta aliag na wa. Agop fon saen katukan mi gup, ŋai aliag da wa.” ");
INSERT INTO tbc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iŋsan megeloum aenta iŋsed mi diŋiŋeŋ go igo dubol, “Ru e ‘saen katukan aŋ ŋai ta aliag na wa, agop fon saen katukan mi gup, ŋai aliag da wan’ fun dugo yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Iŋsed nug dusumiani oŋ go igo dubol, “‘saen katukan’, ru en fun taloŋ uyan san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus iloŋ ak, iŋ ru an niŋen o dusumiani wo ilod ibol dan, niŋen o irupudaig ibol, “Aŋ nag ŋai ru a ŋabol an niŋen o ilom weiwei di? ");
INSERT INTO tbc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rumok geig, aŋ ŋurupaiaŋ da, mitep aŋ tinaŋ aru agane wa. Gup tamolpein tan en san man iŋ uya susai digane wa. Rumok, aŋ ilo muruan tubun kasik da amado da, ak man aŋsam ilo muruan an ibilisap ilo uyan ipanaŋ dop, uyam isusa wa. ");
INSERT INTO tbc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pein iŋ nanuk igansi wo tinin lo ikubiani dop, iŋ ilon muruan tubun kasik aman da imado da. Agop nanuk igansip uyan dop, iŋsan madai an niŋen o ilon ta isou na wa. Man dugo, nanuk tan en lo ilasa yak niŋen o ilon isou dop, uyan isusa geig a. ");
INSERT INTO tbc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nek ago mi, gamu aŋ ilom muruan da. Gug ŋai fon ŋamul ŋupalup aliag dop, afon ilom uyan da wa. Ta aŋsam uyasusai an ipasip isini yau san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nal an lo dop, aŋ fon ŋai mel ta wo asumianag san man tia wa. Ŋai rumok ŋurupaiaŋ da, aŋ mel ta niŋen o ŋai yaŋag lo Bai asumiani dop, man iŋ ka ipanaŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Gug aŋ gubak mi ipalug gamu en dam aŋ mel ta wo ŋai yaŋag lo Bai asumiani man tia ya. Gamu gup aŋ ŋai yaŋag lo asumiani wa. Ago agane dop man, iŋ mel an ka ipanaŋ a. An lo aŋ ilom uyanan pe, uyasusai lo mi amado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ŋai ru faŋan mi ŋabol dugo aloŋ na ya. Gug murna dop man, fon ta ŋimianip ŋurupaiaŋ na wa. Tia, ŋai Bai niŋen o kuai te ŋabol dop aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ago dop nal an lo, ŋai yaŋag lo Bai asumiani wa. Aŋanem awam aban an aŋ niŋemi wo Bai ŋusumiani wa, ago ŋai ta ŋurupaiaŋ na da. ");
INSERT INTO tbc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tia, Bai iŋsen aŋ niŋemi wo imat da. Amaiak niŋen o iŋsen aŋ awam iloŋ a. Man dugo, aŋ ŋai o amat go Bai san na ŋumadog ŋupalu yan, ilom lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gubak mi ŋai Bai da sisem mumado ya. Gug ŋai iŋ ŋubuseig, tan na ŋadu ya. Gamu fon tan en ŋubuseip, Bai san na ŋamul ŋusuda ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Agog iŋanen megeloum igo dubol, “Gamu en oŋ ru faŋan ta ubol na da, tia, kuai te mi ubol ilasa da. ");
INSERT INTO tbc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gamu en maŋ maloŋ fufei ak, oŋ mel fidian uloŋ pasik a. An niŋen o ta iŋ oŋ isumiano wo mala igane san tia ya. An lo oŋ Anut san nag palu yan maŋ iloma lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus awad yabig ibol, “Gamu en aŋ ilom rumok geig ak abol di? ");
INSERT INTO tbc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aloŋ ak, nal ta sumeik la ya, nal an lo aŋ fidian abisawag pe, aŋsiganem na afufurak au dop ŋaiseg kisaek ŋumado wa. Gug ŋaiseg kisaek tia ya, tia, Bai iŋ ŋai da mumado da. ");
INSERT INTO tbc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aŋ ŋai lo amado dop, ŋaisag ilo maror aŋ da amado san niŋen o ru an ŋurupaiaŋ a. Tan en san tamolpein aŋ muruan dupanaŋ ak gug, aŋ ta arut arer na wa. Tia, aŋ ilom abisa, man dugo, ŋai yu ŋigane itout go, an lo tan en san tamolpein fidian sad dabai ŋabi idu la ya.” ");
INSERT INTO tbc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus ru an ibol itout dugo malan lak na isidag, ibol, “Bai, ŋaisag nal idu la ya. Oŋ nanu yaŋak tubun ak panip, iŋanen bunun kuai te gane ilasa wa, an lo Nanu dam oŋ yaŋak tubun ak ipanop, oŋane bunu kuai te igane ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Man dugo, ŋai dabai panag la yen ate tamolpein fidian ŋai tuog paen na dumado wa. Tamolpein a oŋ ŋai panag an, iŋ kumaen pempem yen yau san ŋupidinai a. ");
INSERT INTO tbc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kumaen pempem yen yau san man nek en. Iŋ oŋ Anut kisaek o lian duloŋ a, agod iŋ ŋai Jesus Kristus oŋ dinag go ŋupalu yan dam duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ŋai urat fidian oŋ panag go ŋigane wo ubol en ŋigane itout a. An lo oŋ yaŋa tan en lo ŋabisa ya. ");
INSERT INTO tbc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Bai, wagam oŋ tan ta gane na dugo, oŋ ŋai da girager ilalaŋ aman an lo tumado ya. Ŋai oŋsa na ŋamul ŋupalu gup, girager an fon panag da wa. ");
INSERT INTO tbc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ŋai oŋsa fu mok, tamolpein a tan en lo sikatai go ŋai panag en ŋukubiaig dile ya. Iŋ oŋsa la ya, an niŋen o ŋai panag a. Agog oŋsa ru an dam kagin dupani da. ");
INSERT INTO tbc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gamu iŋ duloŋ uyanan ak, mel fidian oŋ ŋai panag an oŋsa na ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ru fidian ŋai panag an iŋ ŋupidinaig, diŋane ya. An lo iŋ duloŋ fufei mok, ŋai oŋsa nag ŋupalu ya, ago dugo oŋ ŋai dinag go ŋupalu yan dam ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Tamolpein nek an niŋedi wo gadiŋ ŋigane da. Tan en san tamolpein fidian niŋedi wo ta ŋusumiano na da. Tia, tamolpein ensauta a oŋ ŋai panag an mi niŋedi wo ŋumosiai da. Man dugo, iŋ oŋane mok a. ");
INSERT INTO tbc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tamolpein a fidian ŋaisag man oŋsa ya, agod oŋsa man ŋaisag a. Iŋ lo ŋai yaŋak tubun ak ŋiŋane ya. ");
INSERT INTO tbc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ŋai tan en ŋibiseip, oŋsa na ŋupalu wo da. Gug iŋ ete tan na dumado wa. O Bai, oŋ gun ak, oŋane yaŋa dabai, nek ŋai panag en, an lo idaned tamolpein kaginad gane dop, iŋ kisaek mi dumado wa, nek ŋai oŋ da tumado dak ago mi a. ");
INSERT INTO tbc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Saen ŋai dida mumado se man, oŋsa dabai panag an lo mi kaginad ŋigane na ya. Dumui igo woŋ ŋai iŋ ŋibalgiranai na yan lo, ta kisaek ideg yau man tia ya. Gug tamol a pitiŋinek san iŋ mi ideg yau a. Iŋ ru ta oŋane buk lo yen dan nuŋon ilasa wo ideg yau a. ");
INSERT INTO tbc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gamu ŋai oŋsa na ŋupalu wo da. Ŋai tan na ŋumado dugo, ru en fidian ŋabol duloŋ dop, ŋaisag uyasusai iŋ ilod anuai a. ");
INSERT INTO tbc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ŋai oŋane ru ŋupidinaig diŋane ya. Ago dugo tan en san tamolpein iŋ lo siai digane da. Man dugo, iŋ tan en san tia ya, nek ibol ŋai dam tan en san tia ago mi a. ");
INSERT INTO tbc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ŋai iŋ tan en lo pasai diau o ta ŋusumiano na da. Tia, ago dumado wa. Gug ŋai igo ŋugudano da, saen iŋ ente dumado dop oŋ bargiranai a. An lo Satan ipalu dop man, daoŋ ipidinai san tia wa. ");
INSERT INTO tbc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ŋai tan en san tia ya, nek ago mi, iŋ dam tan en san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Oŋsa ru mi ru rumok. Oŋsa ru lo diraip gun dilasa. ");
INSERT INTO tbc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nek ibol oŋ ŋai dinag go tan en lo ŋilasa yan ago mi, ŋai dam iŋ ŋidiraig tan en san tamolpein luluŋad lo diau a. ");
INSERT INTO tbc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ŋai iŋ ŋibinawai o seg tinig ŋipiranig, an lo gun ŋumado dop oŋane ilobol mi ŋiri wa. Agop iŋ dam gun dilasap, sed tinid dipirani dop oŋane ilobol diri mok a. ");
INSERT INTO tbc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ŋai megeloum en niŋedi wo mi ta ŋugudano na da. Tia, mitep ŋidinaip, ŋaisag ru dufulalep tamolpein aenta duloŋ pe, ilod lo ŋai o rumok a. Tamolpein an niŋedi wo dam ŋugudano da. ");
INSERT INTO tbc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ŋai ilog man, iŋ fidian ilod kisaek mi dumado wa. Oŋ ŋai lo mado dak, agod ŋai dam oŋ lo ŋumado da, nek ago mi iŋ dam id da sisem tumado wo ŋugudano da. Ago tap, tamolpein tan en san oŋ ŋai dinag go ŋupalu yan ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Oŋsa yaŋa dabai da ŋai panag an iŋ ŋupidinai la ya. Agop iŋ ilod kisaek dumado wak, nek ibol oŋ ŋai da tumado dak ago mi iŋ dam dumado wa. ");
INSERT INTO tbc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ŋai iŋ lo ŋumado dop, oŋ ŋai lo mado wa. An lo nek ibol id ilod kisaek mi ak igo woŋ, iŋ dam ilod kisaek mok o ŋamat da. Agop tamolpein tan en san oŋ ŋai dinag go ŋupalu yan duloŋ a. Ago dop oŋ ŋaisag tamolpein niŋedi wo umat dan, ŋai o umat dak ago mi gane yan, an dam tan en san tamolpein duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Bai, ŋai ilog man igo ya, aben a ante ŋai ŋumado wan, ante dam tamolpein a oŋ murnap panag an ŋai dida mumado wa. Ago dop ante iŋ ŋaineg girager dam dile wo ŋusumiano da. Tan en tia lo oŋ ŋai o umat go girager en panag a. Girager an iŋ fidian dile wo ilog tubun mi ibol da. ");
INSERT INTO tbc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O Bai, oŋ itaota mok, gidad tan en san tamolpein oŋ duloŋ man tia ya, ago gug ŋai oŋ ŋaloŋ a. Ago dugo ŋaisag adi oŋ ŋai dinag go ŋupalu yan duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ŋai oŋane fu kuai te iŋ lo ŋigane ilasa la yan, nek ago mi ŋigane yau oŋ a. An lo dop oŋsa ilo panek ŋai panag an iŋ bubed lo dirip yen a, agod ŋai dam iŋ lo ŋumado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus igudani itout go megeloum dida diaug, dog Kidron dututeg, aen ate abi oliv lo sasau ate dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aria, Judas, palaŋ niganag tamol an, iŋ sasau ante dumado se yan iloŋ a. Man dugo, Jesus iŋanen megeloum dida pempem sasau an ate dutumani da. ");
INSERT INTO tbc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas imug mi pris gurman adi agod Farisi adi sad na yaug, tempel titianek aenkadi agod yu tamol adi dam iŋal o yau a. Agog iŋ malan imug dugo fidian ŋien aban dirig yu, dumui, agod sul ago duburoug dida diau a. Agog aben a ate Jesus iŋanen megeloum dida dumado dan te dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus mel fidian iŋ lo ilasa wo dan iloŋ an lo, naod na isuk siŋired na ilag irupudai, “Aŋ enti abaŋan abi di?” ");
INSERT INTO tbc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Iŋ dubol, “Maŋ Jesus, Nasaret tamol amaiak abaŋan mabi da.” Agog Jesus ibol, “Ŋai nek ebe.” Judas iŋ ager adi Jesus ikubiai pidinai an dida ditur a. ");
INSERT INTO tbc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Saen Jesus “ŋai nek ebe” ago ibol an, iŋ dusuk dumul go tan na diau dudu ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Agog Jesus fon isumianai, “Aŋ enti abaŋan abi dak i?” Iŋ ru naon durupei, “Jesus, Nasaret tamol ama ya.” ");
INSERT INTO tbc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Agog Jesus irupudai, “Ŋai ŋurupaiaŋ la ya, ŋai nek ebo. Ŋai abaŋag abi wo tap, ŋaineg megeloum en abisawaip diau.” ");
INSERT INTO tbc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ru gubak mi ago ibol, “Tamolpein a oŋ ŋai panag an luluŋad lo talpein kisaek ideg yau man tia ya.” Aria, gamu ru an nuŋon kuai te ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Agog Saimon Pita abaŋ ago ileg, tiŋaen saian go sabiri igursig, pris malan te yan san urat pinein ifunig, kududon won ak isubari idu ya. Pinein an yaŋan Malkus. ");
INSERT INTO tbc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Gug Jesus ru dabai nam Pita irupei, “Oŋane sabiri aben lo usoudu. Ak dugo, ŋai gab lo ŋaluk o Bai ipanag en lo ŋaluk san tia ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Agog yu tamol adi, iŋsad gurman, tempel san titianek dida Jesus diabig, rasau nam dusubanig, ");
INSERT INTO tbc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","dida Anas san na diau a. Anas man Kaiafas niteŋ. Kaiafas iŋ anaŋar en san pris malan te yak imado ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas iŋsen iŋ Juda adi ago ibol irupudai la ya, “Gidad, tamol kisaek an mi imat dop, an lo tamolpein fidian muruan diŋane san tia ya, ago man uyanan a.” ");
INSERT INTO tbc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesus diŋaneg diau dugo Saimon Pita iŋ Jesus san megeloum taida Jesus patun fo diau a. Pris malan te yan megeloum an nug duloŋ ak niŋen o megeloum an Jesus ida sisem ar ilon lo diladu ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Gug Pita iŋ kitek asau mi ar awan te itur dugo malan igane se ya. Ago dugo megeloum a pris gurman iloŋ uyan an imul go ar awan te yaug, ar awan titianek pein an irupeip Saimon Pita iŋane iladu wo ago isumiani a. Ago tag pein an yaug Pita idinig, ar ilon lo iladu ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ago gug pein an Pita irupei, “Oŋ man dag tamol emaiak san megeloum ta i?” Ago dugo Pita ibol, “Ŋai man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Abaŋ madid tubun tinan ak niŋen o pris malan te yak san urat pinein adi iŋ tempel titianek adi dida, yai dutuni ak san midiger an tinid isue dugo, Pita dam yai an fun na tinin isue dugo dida dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ago dugo pris malan te yan Jesus san megeloum niŋedi wo isumiani dugo, ru piteŋanek tamolpein ipidinai na yan dam niŋen o isumiani se ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Agog Jesus ru naon igo ibol, “Ŋai ru fidian tamolpein kuai te mi ŋurupidaig duloŋ na ya. Nal wei mi Juda sad tumanek aben lo, tempel lo dam, ante maŋau ŋupiteŋanai se ya. Ru ta mianuk lo ŋabol man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Fun an niŋen o ata wo ŋai sumianag dak i? Tamolpein ensauta a ŋai awag duloŋ an sumianai gup, ŋai awag aban dubol dugup uloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus ago ibol dugo, tempel titianek ta giraŋen na itur an Jesus kudaŋan igufuteg ipei, “Dugo, oŋ pris gurman malan te yan ru naon ago rupei an uyan ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus awan yabig ibol, “Dugo, ŋai ru saian ŋabol ak i? Ago tap, tamolpein en fidian rupidaip duloŋ. Gug ŋai ru rumok ak mi ŋurupei ak man, ata wo oŋ ŋai funag ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Agog Jesus banin dusubanig, diŋaneg pris malan te yak neinta, Kaiafas dubol dan san na diau a. ");
INSERT INTO tbc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita yai tinin isued itur dugo, talpein ta dusumiani, “Oŋ dam tamol emaiak san megeloum ta boi i?” Pita itot go igo ibol, “Ŋai man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pris malan te yak san urat pinein ta iŋanen turan Pita kududon isubari an imasag, Pita irupei, “Dugo, oŋ nek emaiak iŋ da ai oliv abi lo amado dugo ŋiliaŋ ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Agog Pita fon itot an, kurek ibob kisaek oŋ. ");
INSERT INTO tbc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tidom lom mikinik anda Jesus diŋaneg Kaiafas san ab dubuseig, dida gabman gurman malan te yak, yaŋan Pailat dubol dan, iŋsan gabman san ab lo diau a. Pailat man iŋ Juda tia, iŋ Rom tamol. An niŋen o Juda adi ago dubol, “Kabelan iŋsan ab lo tisidap mel ta tabi dop, Anut malan lo sed nun ipanad pe, an lo idsad tumanek Pasova en lo anaŋ tani san tia banau.” ");
INSERT INTO tbc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ago tag iŋ ab patun fo dutur dugo, Pailat kuai fo ilasag, isumianai, “Aŋ ata wo tamol an ru lo agane di?” ");
INSERT INTO tbc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Agog iŋ ru naon igo dubol, “Tamol en kulob saian ak ta, ta igane na yak man, maŋ oŋsa na miŋane mupalu san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Agog Pailat irupudaig ibol, “Aŋ aŋane aup, aŋsiganem kubiaeŋ lo asumianip ale.” Gug Juda adi iŋ durupei, “Aŋsam kubiaeŋ lo man, maŋ tamol mafu dumat san niŋen o geg apanama da.” ");
INSERT INTO tbc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mel e ilasa yen, wagam Jesus iŋsen dal dugo woŋ lo imat ak niŋen o ibol an, gamu nuŋon kuai te ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aria, Pailat fon iŋsan ab lo iladug, Jesus iwagig isumiani, “Ak dugo, oŋ Juda sad kiŋ ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Agog Jesus ru naon irupeig ibol, “An dag oŋsigane ilo sou lo ubol di? Tia, tamol ta ibol uloŋ go ate ubol di?” ");
INSERT INTO tbc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat awan yabig ibol, “Oŋ ŋai Juda ubol di? Oŋsigane warou adi iŋ pris gurman adi dida dibiog, ŋai banig lo diginio ya. Oŋ muruan naon dugo gane yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus ru naon irupei, “Rumok, ŋai kiŋ ŋumado da, ago gug ŋai tan en san tia ya. Ŋai tan en san kiŋ dop man, gamu ŋaisag turag muroug dumasap, ager diganep, Juda adi ŋai dibiag san tia wa.” ");
INSERT INTO tbc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ago tag Pailat irupei, “Dugo, oŋse oŋ kiŋ ta ago ubol di?” Jesus ru naon irupei, “Oŋse nek a ubol da. Ŋai kiŋ ta, ŋai tan en lo ru rumok ak ŋabol ilasa wo ŋupalu ya. An lo ta iŋ ru rumok san man, iŋ ŋaisag ru iloŋ dop ru an iganuri wa.” ");
INSERT INTO tbc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat awan yabig isumiani, “Ru rumok en ata mel ak i?” Agog fon ab patun fo ilasag, Juda adi naod na itur dugo irupidai, “Ŋai iŋ lo saian ta ŋile man tia ya, an lo aŋ ru apani san man fun an tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gug Pasova tumanek san nal lo, aŋsiganem kagin anaŋar kisaek lo agane dan, tamol kisaek subanek lo ŋupasip ŋupanaŋ a. Ago yak niŋen o aŋ Juda sam kiŋ en ŋupasip ŋupanaŋ o abol di?” ");
INSERT INTO tbc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iŋ fon disasaig igo duwagiŋ, “Iŋ tia ya, gidad Barabas mi pasi panama!” Barabas iŋ ager san tamol, imug Juda adi aenta Rom gabman diabi idu wo yu diabisa ya, ago dugo iŋ luluŋad lo Barabas imado ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ago man Pailat ibol dugo, iŋsan yu tamol adi Jesus diŋaneg lubum nam dufuni a. ");
INSERT INTO tbc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yu tamol adi mel bukorkor igo dudurun anda yak ditiladeg, kabuŋan fo disisi idu dugo, yamel daran ak nam tinin dubuluwi a. ");
INSERT INTO tbc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Agog Jesus siŋiren na diau dumul dugo, kukokan diganeg naon dufuteg dupeig dubol, “Per o, Juda sad kiŋ!” Iŋ ago dubol dugo iŋ naon dufuni se ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ago gug Pailat fon naod na kuai te ilasag, ibol irupudai, “Ale, ŋai iŋsan saian ta lo muruan isini san ŋile man tia geig a. An niŋen o naom na kuai te ŋigane ilasa da.” ");
INSERT INTO tbc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesus gumuran fo kam dudurun anda gubak mi ditilade yan disisi idug, yamel daran ak tinin fufo yen dugo, kuai te ilasa ya. Agog Pailat ibol, “Ale, tamol en nek ebo ya!” ");
INSERT INTO tbc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ago gug pris gurman adi iŋ tempel san titianek adi da Jesus dileg duwagiŋ go dubol, “Aigim fo abali mok abali!” Gug Pailat ru naon irupidai, “Ŋai iŋ lo saian ta ŋile man tia geig a. Ago yak niŋen o aŋsem aŋane aup, aigim fo abali.” ");
INSERT INTO tbc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ago tag Juda adi igo dubol, “Maŋsama kubiaeŋ ta yen dan lo man, iŋ imat mok a. Man dugo, iŋ Anut Nanun mok ago ibol a.” ");
INSERT INTO tbc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat ru ago iloŋ go, ilon tubun mi irer se ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ago tag Pailat iŋ fon Jesus ida ab lo diladug isumiani, “Oŋ sauta mok a? Oŋse fu ubol pe ŋaloŋ.” Gug Jesus ru naon ta irupei man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Agog Pailat ibol, “Oŋ ata wo ŋai awag ta wabi na dak i? Uloŋ, ŋai dabai ag da ya. Ŋupaso wo ŋabol tap, ŋupaso wa. Tia, aigim fo ŋie bani ŋubali wo ŋabol tap, ŋubali wa. Oŋ ŋaisag fug ta uloŋ na yak i?” ");
INSERT INTO tbc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus ru naon igo ibol, “Anut dabai ipanog lo oŋ ka ŋai bilag ŋadu san. Tia dop, oŋ mel ta saian ak giniag san dabai ama tia ya. Fun amaiak niŋen o, tamol a ŋai oŋ tuo lo iginiag an, iŋsan aupasek oŋsa aupasek en iriŋani a.” ");
INSERT INTO tbc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat ru an ago iloŋ tag, irut irer saian geig go, Jesus ipasi wo dal an abaŋ yabi se ya. Gug Juda adi disasai duwagiŋ dugo dubol, “Oŋ tamol en pasip yau tap man, oŋ Kaisa turan tia geig a. Tamol ta iŋsen kiŋ ak ibol dan man, Kaisa naon dal ifou da.” ");
INSERT INTO tbc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat siseiŋ tubun mi ago iloŋ tag, iladug, Jesus kuai te iganeg ilasa. Iŋ ru tulek tamol san badim fo imasi a. Aben an yaŋan Pat Aten dubol da, Hibru ru lo Gabata dubol da. ");
INSERT INTO tbc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Gamu man tumanek tubun san anaŋ kubunek nal idu wo da. Ad titiŋaem mi dugo Pailat Juda adi igo ibol irupidai, “Ale, aŋanem kiŋ nek ebo ya!” ");
INSERT INTO tbc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gug Juda adi igo dubol duwagiŋ, “Ganep ideg yau! Ganep ideg yau! Aigim fo bali!” Ago tag Pailat isumianai, “Aŋ ŋai aŋanem kiŋ aigim fo ŋibali wo abol di?” Agog pris gurman adi ru naon igo dubol, “Maŋ kiŋ taida man tia geig a. Kaisa sen kisaek o lian mi a!” ");
INSERT INTO tbc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pailat ru ago iloŋ tag, Jesus aigim fo dubali wo ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Agog Pailat san yu gurman adi Jesus diŋaneg, iŋsinanen aigim isinig, dida Jerusalem dibiseig diaug, aen ate tan biŋaboŋ ta, yaŋan “kabuŋan kapen san aben” dubol dan ate dilasa. Hibru ru lo yaŋan Golgota dubol da. ");
INSERT INTO tbc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aben ante Jesus aigim fo dubali a. Nal an lo tamol uraru an dam iŋ Jesus ida sisem dubalai a. Uraru an giraŋen ananaem dubalai idu dugo, Jesus iŋ titiŋae mi dubali a. ");
INSERT INTO tbc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aria, Pailat ai lapan fo girek ta ago ibol igire, “Jesus Nasaret tamol, iŋ Juda sad kiŋ.” Girek an aigim gumuran fo dubali a. ");
INSERT INTO tbc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iŋ Hibru, Latin, Grik ru lo igire ya. Aben a Jesus ate dubali an man Jerusalem giraŋen na ya, an niŋen o Juda wei mi girek an dusuti se ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Man niŋen o Juda sad pris gurmadi Pailat igo durupei, “Oŋ Juda sad kiŋ ago ubol gire umoi. Tia, ‘tamol en iŋsen ŋai Juda sad kiŋ ibol’ ago mi gire.” ");
INSERT INTO tbc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Gug Pailat ru naon igo ibol, “Mel ŋai ŋigire yan ŋai ŋigire ya. Nek ago mi yen a.” ");
INSERT INTO tbc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yu tamol Jesus aigim fo dubali la gug, tinin fufo iŋanen yamel kulos an digalai idug, anen anen duburoug malan iwoiwo didiri a. Kulos ta fidian mi, awan ta duwei na ya, ");
INSERT INTO tbc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","an niŋen o ago dubol, “Id en ta tisire na wa. Tia, en yen dop, id ate satu takok dop, ta iŋ isiŋani tap iŋane wa.” Yu tamol kulob a digane yan gubak mi ru girek lo yen amaiak nuŋon digane ilasa ya. Girek ago ibol, “Iŋ ŋaisag kulos duwaeg disini gug, kulos ta awan fidian man ate satu dukok a.” An lo yu tamol adi ago digane ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus tinan, iŋanen tein, Maria Klopas iwon, Maria Magdala san pein, pein iwoiwo yan iŋ Jesus san aigim fun na sumeik mi dutur a. ");
INSERT INTO tbc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aria, Jesus tinan ile, megeloum a iŋ o imat dan tinan da sisem dutur dugo yil tag, tinan irupei, “Nei, oŋane nanuk ule!” ");
INSERT INTO tbc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Agog fon megeloum an irupei, “Ule, an oŋane tina.” Ago tag nek nal antem megeloum an tinan Maria iŋaneg ida sen nuab lo diaug, kaginan igane se ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Aria, Jesus iŋsan urat fidian iganeg itout an iloŋ go, Anut anen ru girek ta wagam yen an nuŋon ilasa wo igo ibol, “Ŋai you o ŋamat da.” ");
INSERT INTO tbc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","You kapen ta wain gigen aman da yak lo yen a. Ago tag mel ta beig san titaliŋ ago yak diŋaneg, wain gigen an lo disominig, ai ate dufoug, duwate isidag, Jesus awan lo diganeg, isupupi. ");
INSERT INTO tbc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iŋ an ituŋali gug igo ibol, “Itout a.” Ago ibol go gumuran imagor paon fo idu dugo ŋutun ibiseig ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nal a Jesus imat o man, soubul dukubune san melmel digane se ya. Sabat nal idu wo sumeik dan iŋ nal tubun mok a. Ago tag Juda adi tamol utol an susanudi aigim fo dien san dumoi. Man niŋen o diaug, Pailat igo dusumiani, “Oŋ ubol pe yu tamol aenta dinaip, ŋied dubalsisinip, ririan dumat dop, susanudi ka dupasai idu wa.” ");
INSERT INTO tbc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Iŋ awok ibol tag, diaug, tamol uraru Jesus giraŋen na dubalai an mi ŋied dubalsisinig dumat a. ");
INSERT INTO tbc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ago gug Jesus dile yak man, iŋ imat la yan niŋen o dumoig, ŋien ta dubalsisini na ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gug yu tamol kisaek yu iŋaneg, yaug, isou isidag, Jesus giraŋen isowae dugo, you dar da sisem dudu kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Talpein enti, iŋsan leil lo melmel e ilasa yen fidian niŋedi wo kuai te ibol ilasa yen, iŋsan ru an rumok geig a. Iŋ ru rumok mi iŋiŋeŋ da, ago dugo iŋ ru rumok ak mi iŋiŋeŋ dan iloŋ da. Ru e igire den, aŋ Jesus o ilom lo rumok san niŋen o igire da. ");
INSERT INTO tbc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mel e gamu ilasa den man wagam Anut girek lo ibol ak ago mi nuŋon igane ya. Ru an igo ya, “Iŋsan tatu ta kisaek dubalsini man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Agod ru taidam igo ya, “Tamol a yu nam disowae an leil dupani wa.” ");
INSERT INTO tbc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gurai idu dugo Josef, Arimatea panu san tamol an Pailat san na yaug, Jesus san sisanun iŋane wo isumiani. Josef dam iŋ Jesus ilon lo rumok a. Ak man Juda niŋedi wo irer an niŋen o ilon lo mi imianuk oŋ itor se ya. Pailat awok ibol tag, Josef imul yaug sisanun an iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, iŋ wagam tidom ta lo Jesus san na yau amaiak, gamu gureŋ mumalun uyanan ak isinig ipalu ya. An san muruan kitek 30 kilogrem igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Juda sad kagin lo Jesus tinin gureŋ nam diamisig, yamel dam gureŋ diabig, ate sisanun dubuluwig, dufoug, disare wo disini diau a. ");
INSERT INTO tbc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aben a Jesus aigim fo dubali an, giraŋen na sasau aben ta sumeik yen da. An ate pat gubaran dukubuneg yen da, pat gubaran an gamugo tamol ta ate disare ya. ");
INSERT INTO tbc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nal an Juda adi sad tumanek tubun ak melmel dukubune san nal sumeik a. An niŋen o tamol uraru an Jesus sisanun aben ante digane ya, man dugo, mutou an sumeikan yen a. ");
INSERT INTO tbc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sabat nal itout go urat nal malan te an lo Maria, Magdala pein an abaŋ mikinik anda mutou fun na yau. Iŋ yaug pat gib awan ate dubalfutani an, itubuluk gigin na yaug yen dugo ile ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ago tag iŋ imaspalug, megeloum uraru, ta Saimon Pita, ta a Jesus niŋen o imat an, sad na yaug irupudai, “Idsad Tubun en diŋaneg diau a. Dugon te digane man maŋ ta maloŋ na ya, mutou an kawan yen da.” ");
INSERT INTO tbc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ago tag Pita iŋ megeloum an da aben an dubuseig, dumaspalug, mutou fun na diau a. ");
INSERT INTO tbc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Uraru an sisem dumaspalug, diau ak gug, megeloum an iŋ Pita naon yabi iriŋanig, iŋ inug mutou fun na ilasag, ");
INSERT INTO tbc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","gib lo iyep ak man yamel kilaken linen nam diwei an mi yen dugo ile ya. Gug iŋ mutou ilon lo ta iladu na ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita murna ipalu ilasag, pat gubaran ilon lo iladug, yamel kilaken a linen nam diweig ate Jesus dubuluwi an mi ile ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ago dugo yamel milaen ate kabuŋan dutuani an dam kitek asau mi yen dugo ile ya. Yamel an dulumi ak sen kisaek yen dugo, linen kilaken man kitek asau mi yen dugo ile ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Agog megeloum a imug yaug ilasa yan, iŋ dam pat gubaran ilon lo iladug, abaŋ nek ago mi ileg, ilon lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nal an lo man iŋsinan megeloum Jesus mateŋ lo imasa san ru Anut san buk lo yen an gamugo duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Agog megeloum uraru an dumul go aben dumado dan ante diau a. ");
INSERT INTO tbc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria fon imul go mutou awan te itatad itur gug, itakoksig gib lo iyep go, ");
INSERT INTO tbc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","eŋel uraru kulos milkouk geig ak amad da sisanun yen ak aben na dumado dugo yil. Neinta ŋien na imado dugo, neinta gumuran na imado dugo ile. ");
INSERT INTO tbc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Uraru en Maria durupei, “Nei, oŋ ata wo tata di?” Iŋ irupidaig ibol, “Ŋaisag Tubun en digam go dugon te digane yak man ŋai ta ŋaloŋ na ya.” ");
INSERT INTO tbc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iŋ ago ibol go idaŋsa man, Jesus itur dugo ile. Gug iŋ Jesus sen itur dan ta iloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus irupei, “Nei, oŋ ata wo tata di? Enti abaŋan wabi di?” Maria ilon lo tamol en sasau an san titianek tamol ta ibol go isumiani, “Tubun en, oŋ ŋaneg dugon te sini wau an, rupaiag pe, ŋaup ŋiŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus awan yabig ibol, “Maria.” Maria idaŋsag, Hibru ru lo iwagiŋ go ibol, “Rabboni!” (Ru an fun man: girek maŋau.) ");
INSERT INTO tbc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Maria Jesus yabi wo igane dugo iŋ imoig ibol, “Oŋ ŋai biag umoi, man dugo, ŋai Bai san na gamugo ŋau da. Ak man oŋ waup, teig taog ŋai ago ŋabol ak ubol rupudai, ‘Ŋai lak na Bai san na ŋamul ŋau o da. Ŋaineg Tamag en aŋsam Tamami, ŋaineg Anut en, aŋ dam sam Anut, amaiak san na ŋamul ŋau o da.’” ");
INSERT INTO tbc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Man niŋen o Maria Magdala pein an yaug, megeloum irupudai, “Tubun en ŋile la ya!” Agog Jesus san awan aban an dam irupudaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nal nek a ubou guraian megeloum iŋ Juda niŋedi wo direr go, ab lo dumado dan dalawan fidian dufutanai idug, ilon lo mi dumado dugo, Jesus luluŋad lo ilasag, itur dugo igo ibol irupudai, “Aŋ maror am da amado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iŋ ago ibol dugo, banin giraŋen dam ikubiai pidinai a. Agog megeloum iŋaned Tubun en dile yak niŋen o uyasusai tubun mi digane ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus fon irupudai, “Aŋ maror am da amado! Bai ŋai idinag go tan na ŋupalu ya, nek ago mi ŋai aŋ ŋidiraŋ pe, urat lo au a.” ");
INSERT INTO tbc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iŋ ago ibol dugo, ur iwi pidinaig, igo ibol, “Ŋai Urgun ŋupanaŋ da. ");
INSERT INTO tbc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aŋ tamolpein iŋaned aupasek apare idu dop man, Anut dam aupasek an ipare idu wa. Ak gug aŋ iŋaned aupasek ta apare idu na dop man, Anut dam ta ipare idu na wa.” ");
INSERT INTO tbc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aria, nal a Jesus megeloum sad na ipalu yan Tomas, iŋ yaŋan neinta Didimas, iŋ dida ta dumado na ya. ");
INSERT INTO tbc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Murna gug Tomas ipalu dugo megeloum aenta durupei, “Maŋ Tubun en mile la ya.” Gug Tomas igo ibol irupudai, “Ŋai ilog lo ta rumok na ya. Ŋaiseg banin bitaten ŋilep, banig yaup, giraŋen dam yu aben ŋusuep ŋile gup man, ŋai ilog lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Murnag nal 8 yau gug, megeloum Tomas dida sisem ab lo dumado yan, dalawan dufutanai pasi ak gug Jesus fon ipalug, luluŋad lo itur go ibol, “Aŋ maror am da amado wa.” ");
INSERT INTO tbc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Agog iŋ Tomas irupei, “Oŋane bani wate ipalup, banig aten wabi ule. Ago dop bani wate ipalup giraŋeg dam suep ule. Oŋ ilo uraru mado umoi. Ilo kisaek ŋai o mi ilo lo rumok a.” ");
INSERT INTO tbc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ago man Tomas ru naon igo ibol, “Oŋ ŋaineg Tubun en, ŋaineg Anut mok a!” ");
INSERT INTO tbc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Agog Jesus irupei, “Oŋ ŋai liag an niŋen o ilo lo rumok a. Gug ta iŋ ŋai ta diliag na gug, ŋai o ilod lo rumok an, bar iŋaneg imado da.” ");
INSERT INTO tbc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus iŋ kulob girager aenta wei mi megeloum naod na igane idu se yan, girek en lo ta yen na da. ");
INSERT INTO tbc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ago gug girek e yen la yen aŋ ale dop, an lo Jesus iŋ Kristus, Anut Nanun, an mi aŋ ilom lo rumok o ŋigire ya. Agop aŋ iŋ o ilom rumok an lo, iŋ yaŋan lo kumaen pempem yen san aŋane wa. ");
INSERT INTO tbc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kitek murnag Jesus fon iŋanen megeloum adi aenta naod na kuai isi dugo dile ya. Mel an igo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jesus san megeloum aenta, sed naod na Galili distrik lo dumul diau a. Iŋ yaŋadi en: Saimon Pita, Tomas, yaŋan neinta Didimas, Nataniel iŋ distrik Galili san panu Kana tamol, Sebedi nanun uraru, megeloum uraru taida mi sisem you saltek Tiberias san loŋ ante dumado ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Loŋ na dumado dugo Pita irupidai, “Ŋai iy o ŋau wo da.” Ago tag aenta durupei, “Id sisem tau a.” Iŋ diaug, wog lo dusuda gug, tidom an lo iy ta kisaek diŋane man tia geig a. ");
INSERT INTO tbc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Salso idug ad isida wo itor dugo, megeloum adi wog lo urat digane se yan, tamol ta loŋ na itur dugo dile. Ago gug tamol an Jesus boi, an ta ilod isou na ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Agog Jesus igiai, “O turag muroug, aŋ iy amam da i?” Iŋ awan diabig dubol, “Maŋ iy tia ya.” ");
INSERT INTO tbc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iŋ fon igiaig ibol, “Aŋ iy dob an wog giraŋen won ak lo abili idup, iy aŋane wa.” Ago tag iŋ ibol ak atem ago digane ya. Agog dob an iy awan isag, muruan kasik, diraep isuda san tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Agog megeloum kisaek a Jesus niŋen o imat dan, iŋ Pita irupei, “An idsad Tubun ak iŋsen.” Ago dugo Pita ru a “idsad Tubun ak” ago iloŋ tag, urat kulos igali idug yen an fon kulos uyan ak idirig, you lo isokalik idug, Jesus san na yau. ");
INSERT INTO tbc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gug megeloum aenta iŋ wog lo dumado yan dufulanig, dob iy aman da yan diraeg loŋ na dupalu se ya. Iŋ loŋ na asau mi dumado man tia ya, tia, iŋ kitek 100 mita igo ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Iŋ dupalug, loŋ na dusuda man, iŋ iy anaŋ bret da yai fo dien dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Agog Jesus irupudaig ibol, “Iy gamu aŋane yen ta igo asini apalu.” ");
INSERT INTO tbc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ago tag Saimon Pita wog lo isudag, iy dob iraeg ibili loŋ na isuda ya. Iy tutubu yak wei mok dob lo disudag anuai an, sad sutek lo 153 igo ya, ago gug dob kitek imasirei man tia ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Agog Jesus irupudai, “Apalup anaŋ ani.” Megeloum ta “oŋ enti?” ago ibol isumiani wak man niŋen o direr a. Man dugo, iŋ fidian tamol an Jesus iŋsen an duloŋ uyan a. ");
INSERT INTO tbc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Agog Jesus ipalug, anaŋ bret iŋaneg, iwaeg ipidinai dugo iy dam ago mi igane ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aria, Jesus mutou lo imasag iŋanen megeloum dile man saen uraru ya, ago mi gamu en saen taidam fon loŋ na dile ya. ");
INSERT INTO tbc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Dunuai itout gug Jesus Saimon Pita irupei, “Saimon, Jon nanun, oŋ ŋai niŋeg o umat den, melmel aenta e niŋedi wo umat den iriŋanai geig i?” Agog Pita ibol, “Tubun en, oŋ uloŋ ak, ŋai oŋ o ŋamat mok a.” Agog Jesus ibol, “Oŋ ŋaineg sipsip nanudi futuwai panag.” ");
INSERT INTO tbc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Agog Jesus fon ibol, “Saimon, Jon nanun, oŋ ŋai niŋeg o umat mok di?” Pita ibol, “Tubun en, oŋ uloŋ ak, ŋai oŋ o ŋamat da.” Agog Jesus fon ibol, “Oŋ ŋaineg sipsip kaginad gane.” ");
INSERT INTO tbc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Agog Jesus fon irupeig ibol, “Saimon, Jon nanun, oŋ ŋai niŋeg o umat di?” Pita Jesus isumiani utol ak niŋen o ilon tubun mi muruan go igo irupei, “Tubun en, oŋ mel fidian uloŋ pasi a, an lo oŋ uloŋ uyan ak, ŋai oŋ o ŋamat da.” Agog Jesus irupei, “Oŋ ŋaineg sipsip futuwai. ");
INSERT INTO tbc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ŋai ru rumok ŋurupaio da. Imug oŋ utor na man, let oŋse lua te fou ya. Agop dugon te wau o ilo ibol an ante mi wau da. Ak man murnap oŋ tamol saiak gane gup, bani wate dop, tamol sen ak ta oŋ lua te let ifou panop, aben oŋ ate wau o ilo imoi an, ante diŋilio wau a.” ");
INSERT INTO tbc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus ru a Pita irupei an man, murnap Pita dal dugo woŋ lo imat pe Anut yaŋan yabisa san, ikubiai pani amaiak niŋen o ibol a. Ru ibol itout go fon irupei, “Oŋ palup, ŋieg aban uri wa!” ");
INSERT INTO tbc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Agog Pita idaŋsag, megeloum a Jesus niŋen o imat dan, patun fo ipalu dugo ile. Megeloum nek emaiak gubak mi Pasova tumanek san anaŋ diani san nal lo, Jesus ida sisem dunuai dan, iŋ Jesus titiren fo isapek go isumianig ibol, “Tubun en, enti mok oŋ ager banid lo ibilo lasa wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ile dugo Jesus irupei, “Tubun en, tamol en niŋen o dugudo wak i?” ");
INSERT INTO tbc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus awan yabig irupei, “Isop iŋ imado yaup saen ŋai fon ŋupalu wak ago ilog yen tap, an oŋsa mel ak i? Oŋ masap ŋai ganurag a!” ");
INSERT INTO tbc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ago tag ru an ifurak go megeloum fidian lo yaug, duloŋ gug Jesus ru ibol an awan dusupaleg, “Megeloum an ta imat na wak ago Jesus ibol an,” ago dubol a. Ak gug Jesus ago ibol man tia ya. Iŋ nek igo ibol, “Isop iŋ imado yaup saen ŋai fon ŋupalu wak ago ilog yen tap, an oŋsa mel ak i?” ");
INSERT INTO tbc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Megeloum nek emaiak mel an fidian ile iloŋ go, gamu ru en igire da. Agod id taloŋ uyan ak ru e igireg ifulale yen ru rumok a. ");
INSERT INTO tbc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Aria, Jesus kulob aenta wei mi igane idu ya, ago gug fidian girek en lo tia ya. Man dugo, ŋaisag ilo sou igo ya, ru an fidian digire wo tap man, girek a digire yan fidian tan en lo didirip aben mi tia wak ago ilog isou da. ");
INSERT INTO tbc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiofilas, ŋaisag buk malmalan ŋigire man, melmel fidian Jesus fun igane dugo tamolpein ipiteŋanai na yan niŋen o ŋigireg yaug, ");
INSERT INTO tbc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","saen ibisawamag Anut giraŋen na yau an san ŋiŋeŋ itout a. Gamugo imat dugo Urgun san dabai lo aposel ipilianai an ru kagin irupidaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Agog iŋsen mateŋ lo idug, fon kumaen imasag nal 40 ilon lo saen wei mi tamol amaiak naod na ilasa se ya. Saen an lo iŋ kumaen imado amaiak dal wei mi lo kuai te ikubiai dile ya, an lo iŋ ilod lo rumok a. Ago dugo Anut san kagin panek niŋen o dam irupidaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nal ta iŋ iŋanen megeloum dida dutumanig anaŋ diani dugo, ru kagin en irupidai, “Jerusalem ta abisei na wa, tia, lou panek a ŋaineg Bai aŋ aŋane wan iŋsan promis ipanaŋ an ilasa wo malam agane gup aŋane wa. Aŋ gubak mi ru promis an niŋen o ŋai ŋabol ilasa se yan aloŋ la ya. ");
INSERT INTO tbc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon you nam fulanek ipidinai se ya. Gug nal wei tia dop, aŋ Awan Urgun nam fulanek aŋane wa. Agop Urgun san dabai aŋ da wa.” ");
INSERT INTO tbc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nal ta saen iŋ Jesus dida dutumani man, aposel adi dusumianig dubol, “Tubun en, dugo, oŋ gamu en maŋ Isrel tamolpein fon tumanama wak i? Ago dop maŋsiganema kiŋ kagin ipanama wak boi, nek ibol wagam Dawid san saen lo igane yak igo woŋ a.” ");
INSERT INTO tbc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ago tag awad yabig ibol, “Mel ilasa wak san saen, agod ata nal mok ate mel an ilasa wan Bai iŋsen ilon nam igansi la ya, ak gug aŋsem mel an san saen aloŋ san niŋen o ilon ta yen na da. ");
INSERT INTO tbc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gug saen Urgun aŋ tinim fo idu dan, aŋ dabai aŋane dop Jerusalem, Judea, Sameria na, agod tan titin wadan fidian lo dam aŋanem maŋau ŋai niŋeg o an tamolpein naod na abol ilasa wa.” ");
INSERT INTO tbc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ago ibol go itout an aposel malad lo mi tan ibiseig, isidag, timtaen lo imianuk dugo dile san tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesus ibisawai dugo malad ti ibol go isudag keit lo abaŋ dile man, tamol uraru biouŋ milkouk didiri ak dilasa kisaek oŋ go, giraŋed na dutur dugo dil a. ");
INSERT INTO tbc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Agog dubol, “Aŋ Galili tamol, ata wo ente atur dugo malam keit lo isida dak i? Aŋ Jesus ibisawaŋ go kumaen panu na yau an ale ya. Jesus nek emaiak yau ago mi dal nek kisaek an mitep afon lo imul ipalu dop ale wa.” ");
INSERT INTO tbc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Agog aposel adi Did Oliv dibiseig, dumul Jerusalem na diau. Dal an kilomita kisaek igo woŋ. ");
INSERT INTO tbc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem na dilasag, ab a lo dumado dan san galuŋ ta lak na yak lo disida ya. Tamol saen an lo ante dumado se yak yaŋadi: Pita, Jon, Jems iŋ Andru da, Filip iŋ Tomas da, Bartolomiu iŋ Matyu da, Jems Alfeus nanun, Saimon, tamol a Rom gabman paen na imado wo imoi dan, agod Judas Jems nanun. ");
INSERT INTO tbc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tamol an pempem dugudani wo dutumani se ya. Jesus tinan Maria, iŋ pein aenkadi, agod Jesus tein muroun dam dida dutumani a. ");
INSERT INTO tbc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nal ta saen an lo ilo rumok adi dutumanig, nuŋod 120 igo woŋ dugo, Pita imasag ");
INSERT INTO tbc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ibol, “Teig muroug, ru en aloŋ, wagam Urgun Dawid awan lo Judas niŋen o ibol ak nuŋon ilasa ya. Judas Jesus san ager iŋal go, dal ikubiai dileg dida diaug Jesus diabi a. ");
INSERT INTO tbc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas dam iŋ aposel urat igane wo Jesus ipiliani a, iŋ dam nek id igo mi a.” ");
INSERT INTO tbc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Iŋsiganen sewak naon moni dupani an nam tan kilaken ta idad iŋane ya. Atna yau idug, luan ipuk go tiŋaen igulani idu ya. ");
INSERT INTO tbc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Agog ru en Jerusalem ilon lo tamolpein fidian duloŋ tag, iŋ tan an muroud ru lo Akeldama dubol da. Yaŋak an fun: dar san tan.) ");
INSERT INTO tbc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Isrel sad bar san buk lo ru igo digireg yen da, ‘Iŋsan ab an tubabun a. Talpein ta ifun san tia ya.’ Bar neinta buk an lo yen dan dam igo ibol: ‘Tamol sen ta aben iŋanep, iŋsan urat awan igane wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ago yak niŋen o tamol ta tipilianip Judas aben iŋane wa. Tamol a saen fidian id Jesus da tator dugo iŋ dam dida tator na yan mi titarpasaip luluŋad lo tamol kisaek tipiliani wa. ");
INSERT INTO tbc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Agop id tamol dugon fun lo Jon fulanek igane dugo ida tator go ipalug saen Jesus ibisawad an mi ka tipiliani wa. An lo saen id Jesus fon kumaen imasa dugo tile yan san ru tamolpein turupidai dan, tamol a tupiliani dan luad isap, urat an id sisem tigane wa.” ");
INSERT INTO tbc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Agog tamolpein a dutumanig dumado dan iŋ tamol uraru yaŋad dupate ya. Ta Josef, tamol an Barsabas dubol da. Ago dugo yaŋan neinta Jastas. Agod ta man yaŋan Mataias. ");
INSERT INTO tbc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Uraru an niŋedi wo gadiŋ lo Jesus igo dusumiani, “Tubun en, oŋ tamolpein fidian ilod uloŋ. Ago yak niŋen o tamol uraru en dugon Judas aben iŋanep aposel urat igane wo pilianip kubiai panama. Man dugo, Judas aben a iŋsan mok an lo yau wo iŋsan aposel urat ibisei a, agog gamu iŋsan urat an awan kawan yen da.” ");
INSERT INTO tbc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dugudani itout, agog pat kititik fo Mataias Josef da yaŋadi digire ya. Pat an disinig gab lo didiri. Ago gug gab an dukudumsig, pat fo Mataias yaŋan yen an inug idu ya. Ago tag Mataias aposel 11 an luad te diganeg, dida urat digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos nal idu, agog ilo rumok adi fidian dupalug, kisaek mi dutumanig dumado dugo, ");
INSERT INTO tbc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","liliŋan ta nek ibol tim tubun geig ifure dak igo woŋ ab lo dumado dan ilon lo isaldug ilon igane itau. ");
INSERT INTO tbc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Agog mel ta yai balen wei mi igo woŋ dufurak diaug tamol a dumado yan gurmad fo ided ided yau dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tamolpein fidian Urgun ilod iŋanefuteg an lo Urgun dabai ipidinai an fom iŋ anen anen tamolpein sen ak sad muroud ru funfun lo diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aria, saen an lo Juda tamolpein gob sad tan fidian lo dumado dugo, ante Anut ubou an dile na yan tan an fidian dibiseig Pasova tumanek san anaŋ diani wo Jerusalem na diaug dilasag dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Saen liliŋan an duloŋ man, Juda tamolpein wei mi dususag dutumani a. Fidian dupalu yan anen anen iŋsiganed muroud ru lo aposel adi diŋiŋeŋ dugo duloŋ se ya, ago man iŋ fidian durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Ago dugo dumasa saian go sed nug dusumiani, “Tamol diŋiŋeŋ dan fidian Galili tamol ak gug, en dugo woŋ dugo id fidian idsad muroud ru anen anen taloŋ dak i? ");
INSERT INTO tbc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Id fidian tan asau ak sensen lo tupalu ya. Gug Anut mel tutubun igane yak id anen anen idsiganed muroud ru lo dubol dugo taloŋ da. Id aenkadi Patia, Media, Ilam na, agod aenkadi Mesopotemia, Judea, Kapadosia na tupalu ya. Aenkadi Pontas, Esia na, agod aenkadi Frisia, Pamfilia na dupalu ya. Aenkadi Igipta na, agod Libia san tan kilaken aenta Sairini giraŋen na, agod aenkadi Rom na dupalu ya. Aenkadi Juda mok, go aenkadi man Juda tia gug Juda sad ubou lo diau da. Agod aenkadi Krit na, aenkadi Arebia na dupalu ya. Id a fidian tupalu yan idsed awad anen anen taloŋ da.” ");
INSERT INTO tbc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iŋ fidian dumasa saian go ilod weiwei geig se ya, ago dugo sed nug dusumiani, “Kulob en san fun mok dugo mok ak i?” ");
INSERT INTO tbc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gug aenkadi aposel adi kukok ad diganeg dubol, “Tamol en nag wain tubun mi duluk boi.” ");
INSERT INTO tbc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ago dugo Pita aposel 11 dida dumado yak imasag, awan tubun mi awad yabig ibol, “Aŋ Juda tamolpein, agod aŋ fidian Jerusalem na amado dan, kudom agure uyanan pe, mel en fun ŋufulale dop aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tamol emaiak wain duluk abol den ta duluk na ya. Tia, gamu man 9 klok tidom lo mi a. ");
INSERT INTO tbc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ak niŋen o kankan agane. Abaŋ e ale den wagam profet Joel igo ibol: ");
INSERT INTO tbc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Anut ibol, ‘Saen wadan ipalu wo sumeik dop, ŋai ŋaineg Urgun tamolpein fidian sad tinid fo ŋuwali idup diŋane wa. Nanuk tamol ak, iŋ nanuk pein ak dam profet ru dubol ilasa wa. Aŋanem pinein foudi ak malad ŋutun dile wa. Aŋanem tamol busumadi ak ŋioŋ lo ŋioŋamin diŋane wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Saen an lo dop ŋaisag urat pein, urat tamol dam, tinid fo ŋaineg Ur ŋuwali idup diŋane wa. An lo dop iŋ dam profet ru dubol ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ŋai keit lo kulob girager naon sensen ŋigane wan ŋukubiai ale wa. Ago dop tan na dam kulob tutubun sensen ak kob igo woŋ ŋigane dop ale wa. An man dar, yai, agod yaikas malan bilkas nuŋon ak ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ad iŋsan naon ibilisap tidom oŋ ilasa dop, kalam dam malan ibilisap, daran pe dar oŋ ilasa dugup, Tubun en san nal tubun ak girager anda idu wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ago dop tamolpein ensauta a gadiŋ lo Tubun en ibinawai o duwagiŋ dan, iŋ tamolpein an fidian patud ipasi wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“O Isrel tamolpein, kudom agure! Anut aŋ naom na ikubiaig ale yak, iŋ Nasaret tamol Jesus an uyan ipani a. An dugo woŋ i? Anut sen kulob girager agod urat dababai funfun kob igo woŋ tamol an lo idiri dugo ale na ya. Melmel an aŋ luluŋam lo tamol an tuon lo dilasa dugo aŋ an fidian aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wagam mok Anut iloŋ uyanan ak, Jesus aŋ banim lo yau a. Aŋsem tamol saiadi ak dida atumanaig aŋ iŋsad binawek da Jesus aigim fo abali a. An aŋ mitep ago agane wo yan Anut wagam mi iloŋ uyanan a, man dugo, iŋ ilon nek ago yen a. ");
INSERT INTO tbc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Gug mateŋ Jesus yabituani san tia tag Anut iŋ ifufunig, fon kumaen imasag mateŋ san madai tuon lo ipasi a. ");
INSERT INTO tbc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wagam mi Dawid sen dam Jesus niŋen o igo ibol, ‘Tubun ak pempem mi ŋai naog na itur da, an ŋai ŋile da. Iŋ ŋai siŋireg na imado dugo dabai ipanag dan lo, tamolpein ŋai dimiriranag san tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ak niŋen o ŋai ilog tubun mi uyan dugo ŋai awag, ru ilo uyan san ibol ilasa da. Ŋai tinig dam oŋ binawag an mala nouk lo mi ititiano imado da. ");
INSERT INTO tbc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Man dugo, oŋ ŋaisag ŋutug Ades lo biseip ante ta yen na wa. Oŋ oŋane Tamol Gun ak ulefuni dop ta igan na wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oŋ ŋai kumaen san dal kubiai panag a. Oŋ ŋai da tumado wak lo ŋai uyasusai dam panag pe tinig iŋanefute wa.’” ");
INSERT INTO tbc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“O teig muroug, aŋ aloŋ ak ru e ŋurupaiaŋ den ru rumok, id tubud baged Dawid imat go disare ya. Agod iŋsan mutou yen dan pempem tile da. ");
INSERT INTO tbc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Gug Dawid man profet ta. An niŋen o iŋ iloŋ ak, Anut ru lak na geig nam promis ipani an lo, mitep iŋsan malan kubulan ta kiŋ iganep, iŋsan aben iŋane wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Anut mitep dugo igane wan Dawid iloŋ tag, Kristus mitep fon kumaen imasa wak niŋen o ibol. Fun an lo dam ibol, Anut Kristus Ades lo ibiseig ta imado na ya, ago dugo tinin dam ta igan na ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Anut Tubun ak Jesus nek amaiak mateŋ lo ifufunig, kumaen imasa da ya. Agod mel an maŋ fidian sema malama lo mile ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anut Jesus iŋaneg yaŋan tubun geig anda giraŋen won ak lo imado da. Anut gubak mi iŋanen Awan Urgun Jesus ipani wo promis ru ipani a. Aria, gamu promis an nuŋon ilasag Urgun iŋane ya. Ago dugo Jesus sen Urgun an maŋ tinima fo iwali idu ya, ago dugo aŋ mel en ale dugo kududom iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aŋ aloŋ ak Dawid iŋsen kumaen panu na ta isuda na ya. Ago bo man iŋ igo ibol, ‘Tubud ŋaisag Tubun en irupei: giraŋeg won ak lo masip, mado dugup, ");
INSERT INTO tbc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","oŋsa ager adi oŋ ŋie paen na ŋidirai a.’” ");
INSERT INTO tbc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ago yak niŋen o tamolpein fidian Isrel ilon lo yak kuai tem ŋurupaiaŋ da, ru rumok e ŋurupaiaŋ den aŋ ilom lo rumok o yan amoi san fun man tia ya. Jesus nek a afunig aigim fo abali an, Anut ipilianig iŋ Kristus agod Tubun ak dam igane ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Saen tamolpein ago duloŋ dugo, ru an bubed isue saian geig a, ago tag Pita aposel aenkadi dida dusumianaig dubol, “O teim taoma, maŋ dugo mok migane wak i?” ");
INSERT INTO tbc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Agog Pita awad yabig ibol, “Fidian aŋanem aupasek anen anen patum apanip, apalup Jesus Kristus yaŋan lo suguek aŋane wa. Ago tap Anut aŋanem aupasek fidian ipare idup Awan Urgun ipanaŋ a. Urgun man iŋsan lou panek, an kawan naon an tia aŋane wa. ");
INSERT INTO tbc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Promis e Urgun niŋen o yan man aŋsami, aŋanem malam kubulam sadi, agod tamolpein asau asau fidian iŋsad dam mi a. Awo, tamolpein a fidian idsad Tubud Anut igiai an promis an san nuŋon diŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ru tubun mok ibol go ru kagin wei mi irupidai se ya. Iŋ ilod dibilisa wo dabai geig iganeg ibol, “Aŋ sem patum apasi. Kabelan tamol saiadi Jesus dufuni ak sad naon panek ipalu dan aŋ dam aŋane banau.” ");
INSERT INTO tbc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Agog tamolpein wei mi Pita san ru ilod lo rumok go suguek diŋane se ya. Nal an lo tamolpein 3 tausen igo woŋ ilo rumok adi luad disa ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kris foudi an aposel adi sad ru duloŋ o diau se ya. Jesus ilod isou san niŋen o kisaek mi dutumanig, dumado dugo, anaŋ dam kisaek mi diani dop dugudani se ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposel adi Anut san dabai lo kulob girager funfun digane se ya. Ago dugo tamolpein fidian durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ilo rumok adi fidian sad kankan kisaek mi a. Ta mel dugon tia dugo ta aman da man, turan mel lo katuk an ibinawi se ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aenta iŋaned tan kilaken, melmel aenta dam didaeŋ lo didirig, san moni diŋaneg, tamolpein melmel lo katuk adi an dipidinaig sed ibinawai a. ");
INSERT INTO tbc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iŋ fidian ilod kisaek mi nal fidian gudanek digane wo tempel lo dutumani se ya. Iŋsiganed ab ate tet mi dutumanig yousai lo agod ilod kisaek lo dam anaŋ diani se ya. ");
INSERT INTO tbc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Anut yaŋan diabisa dugo tamolpein ilo rumok adi sad kagin dileg yaŋad diabisa se ya. Agog Tubun en nal pempem tamolpein a patu pasek ipidinai dan ilo rumok adi luad te idirai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nal ta Pita Jon da 3 klok guraian gudanek san saen niŋen o tempel lo diau a. ");
INSERT INTO tbc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tempel sumeik dupani dugo tamol ta tinan tiŋaen lo mi ŋien saian ak disini diaug, tempel dalawan yaŋan “Dalawan Siŋaokan” dubol dan, ate digansig imado dugo dile ya. Tamol an pempem ago disini diaup imado dop, tamolpein tempel lo diau dumul dan moni o igudanai da. ");
INSERT INTO tbc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tamol an Pita iŋ Jon da diladu wo dugo yil tag moni ta amad da tap dupani wo igudanai a. ");
INSERT INTO tbc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ago tag urarum malad ti ibol go dile dugo Pita irupei, “Mala ipalup, liama!” ");
INSERT INTO tbc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Agog tamol an ilon lo Pita Jon da mel ta dupani wo digane dak ago ibol tag, malan yaug yil a. ");
INSERT INTO tbc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Agog Pita ibol, “Ŋai pat silva gol da amag tia ya. Gug mel a ŋai amag da yan gamu ŋupano wa. Jesus Kristus Nasaret tamol an yaŋan lo masap wau.” ");
INSERT INTO tbc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Agog Pita tamol an banin won ak lo yabig, imasa itur o ibinawi a. Saen iŋ ago igane yan tamol an ŋien aten, ŋien ŋudun an fidian dabai kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Agog tamol an isokalik go, fun iganeg itor ila iso se ya. Agog itor dugo isokalik oŋ go, Anut yaŋan yabisag Pita Jon da dida tempel ilon lo diladu ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Agog tamolpein fidian tempel lo dumado yan iŋ itor dugo Anut yaŋan yabisa dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iŋ dile duloŋ ak, tamol an imug tempel san dalawan siŋaokan ante imado na yan nek ama ya. Iŋ itor uyanan an niŋen o dirut saian a. ");
INSERT INTO tbc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tempel ilon lo aben ta Solomon san Madok Aben dubol dan ate tamol an Pita Jon da ibiaig, dida ditor se ya. Tamolpein fidian mel a tamol an lo ilasa yan niŋen o dumasa saian go iŋsad na dumaspalug diau a. ");
INSERT INTO tbc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Saen Pita ago yil tag irupidaig ibol, “O Isrel tamol adi, aŋ ata wo kulob en aleg amasa saian i? Ata wo ago aliama dak i? Nag aŋ ilom lo maŋsiganema dabai lo, tia, maŋsiganema Anut kagin lo tamol en ŋien mukubune abol dak i? ");
INSERT INTO tbc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tia, Abraham, Aisak, Jakob iŋsad Anut, id baged muroud sad Anut, iŋanen urat tamol Jesus yaŋak tubun geig ak ipani a. Gug aŋ tamol an gurman adi banid lo dufuni imat o agane ya. Pailat ipasi wo ibol gug aŋ amoig Pailat naon na patum apani a. ");
INSERT INTO tbc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iŋ bo tamol gun agod itaot ak gug aŋ iŋ amoi a. Aŋ tamol ta talpein ifuni imat ak Pailat ipasip ipanaŋ o asumiani a. ");
INSERT INTO tbc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Aŋ tamol a id kumaed tumado san fun amaiak afunig imat a. Ak gug Anut mateŋ an lo ifufunig, afon kumaen imasa da ya. Agog kulob an maŋ malama nam mile ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ilo rumok Jesus yaŋan lo yan mi tamol e aloŋ uyanan dugo leil apani den ŋien dabai ilasa ya. Jesus yaŋan lo, agod ilo rumok a iŋ id ilod lo igane ilasa dan lo dam, kubunek en iŋane ya, ago dugo ŋien gamu dabai pasik an aŋ fidian ale a.” ");
INSERT INTO tbc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O teig muroug ŋai ŋaloŋ ak, kulob a aŋ aŋsam gurman adi dida Jesus lo agane yan, aŋ fidian aŋaoŋ an lo ago agane ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Anut profet adi awad lo wagam ibol, iŋanen Kristus muruan isini wo ibol. Ak niŋen o dal an lo iŋanen ru ibol ak nuŋon ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ago yak niŋen o aŋanem kagin saiak saiak patum apanip, ilom ibileksap, Anut naom apani. Ago tap aŋanem aupasek fidian ipare idu wa, an lo dop ilo maror agod yaes bilabal san saen Tubun en iganep aŋ o ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","An mi tia ya, Anut Kristus e aŋ o ipiliani en idinip ipalu wa, nek Jesus ema ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iŋ kumaen panu na imado dop yaup, Anut mel fidian ibilisap foun ak dilasa san saen ilasa wa. Anut ago igane wo wagam mok iŋanen profet gun adi awad lo ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Man dugo, Moses igo ibol, ‘Anut aŋanem Tubun en, nek ŋai idinag go ŋupalu yak ago mi profet ta aŋsiganem dar lo yak igane ilasap idinip ipalu wa. Ru fidian irupaiaŋ dan kagin apani wa. ");
INSERT INTO tbc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Talpein ta iŋ profet an awan iloŋ o imoi dan, Anut talpein an iŋsan tamolpein lo ikudip pitiŋinek saian geig ak ipani wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Rumok, Samuel sen dam agod profet aenkadi ŋien aban duri an fidian ru gamu saen en san dubol ilasa na ya. ");
INSERT INTO tbc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aŋ man profet adi an sad malad kubuladi, an lo promis a Anut profet an sad awad lo ibol an, agod kontrak a aŋanem tubum bagem ipidinai an san nuŋon dam aŋanemi a. Anut ru en wagam Abraham irupeig ibol, ‘Oŋane mala kubulan lo tan en san tamolpein fidian bar diŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Saen Anut iŋanen urat tamol tan en lo igane ilasa man, imug mi aŋsam na igane ipalu ya. Iŋ bar ipanaŋ o ipalu ya, ago dugo bar an igo ya, iŋ idiraŋ pe aŋ anen anen sem adaŋsap aŋanem kagin saiak saiak patum apani wa.” ");
INSERT INTO tbc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Saen Pita iŋ Jon da tempel lo tamolpein ru durupidai dugo, pris adi, tempel titianek tamol sad gurman, iŋ pris warou a Sadyusi dubol dan aenta dida sad na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iŋ tiŋaed saian geig a. Man dugo, Pita Jon da Jesus imat gug fon kumaen imasa yak san ru tamolpein naod na durupidai duloŋ se ya. Iŋ maŋau ago dupiteŋanai dan lo tamolpein duloŋ ak, Jesus lo tamol dumat dak, fon ka dumasa wa. ");
INSERT INTO tbc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ago tag duburou gug abaŋ tidom idu la yak niŋen o subanek ab lo didirai a. Iŋ ilod lo man aposel adi ante dien pe tidom lom mi gup kot dupidinai a. ");
INSERT INTO tbc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gug tamolpein a iŋsad ru duloŋ an luluŋad lo wei mi ilod lo rumok a. Tamolpein an ilo rumok adi luad disag, tamol itumanaig sad sutek faiv tausen igo woŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tidomig Juda sad tirnek tamol adi, matu gurman adi, agod kubiaeŋ san girek maŋau adi dam Jerusalem na dutumani a. ");
INSERT INTO tbc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pris gurman Anas, agod Kaiafas, Jon, Aleksandra, agod tamol aenta pris gurman san gugoi lo yan dam dida dutumani a. ");
INSERT INTO tbc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Agog aposel adi digiaig dupalug, naod na dutur dugug dusumianai, “Aŋ dabai dugomaiak lo, tia, yaŋak dugomaiak lo aŋaneg, tamol en akubuneg uyan ak i?” ");
INSERT INTO tbc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ago dugo Urgun Pita ilon iŋanefuteg awad yabi, ");
INSERT INTO tbc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Aŋ gurman, aŋ ilo muŋanek san kulob ta lo tamol ŋien itubabun ak uyan ilasa yan niŋen sumiaek lo adirama tap, agod en dugo woŋ dugo kubunek iŋane yan dam maŋ asumianama tap, ");
INSERT INTO tbc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","aria, ru en aloŋ uyanan. Kulob en Nasaret tamol Jesus Kristus iŋanen yaŋan san dabai lo ilasa ya. Tamol amaiak aŋ aigim fo abalig afuni imat ak gug, Anut mateŋ lo ifufunig fon kumaen imasa da ya. Iŋ lo mi tamol e aŋ naom na itur den kubunek iŋane dugo kulob an san nuŋon ale ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus nek amaiak niŋen o Anut ru igo ibol, ‘Pat nek a ab bek tamol adi dumoi dan, nek amaiak ab tinin fidian yabi sakar da.’ ");
INSERT INTO tbc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iŋ mi lo patu pasek ale wa. Man dugo, tan en fidian lo man Anut yaŋak sen ak ta lo id tamolpein fidian patu pasek ka tiŋane wan ta ipanad na ya, tia, nek Jesus yaŋan lo mi a.” ");
INSERT INTO tbc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kaunsil adi dile yak, Pita Jon da malak malak ru dabai anda nam durupidai a, uraru an tamol kawan, iŋ skul ta digane na ya. An ago dile man durut saian geig a. Agog an kankan ipidinai ak, tamol uraru an gubak mi Jesus da dumado dutor an dile duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ak man ru ta dubol san tia ya. Man dugo, Pita Jon da tamol dukubune yan siŋired na mi itur dugo leil dupani da. ");
INSERT INTO tbc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ago tag kaunsil adi tamol utol an didinaig, tumanek aben dubiseig patun fo dilasa gug iŋsed mi pasak nam diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Iŋsed mi nug dusumiani, “Id tamol uraru en dugo tiginiai ak i? Id kubol ilasa yan sewak tabol san tia ya, man dugo, tamolpein fidian Jerusalem na dumado dan kulob girager e tamol uraru en digane yen duloŋ la ya. Id tatot san tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Id mel en tabituani wa, kabelan ru en yaup tubun banau. Ago yak niŋen o tamol uraru en kudod tabi uyanan a. Iŋ afon talpein ta naon na Jesus yaŋan ta dupate na wak niŋen o ru kagin turupidai a.” ");
INSERT INTO tbc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Agog Pita Jon da digiaig, diladug ru dabai nam durupidai, “Aŋ afon Jesus yaŋan lo tamolpein ru ta arupidai na wak, agod yaŋan an lo dam maŋau ta mok apiteŋanai na wa.” ");
INSERT INTO tbc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Gug Pita Jon da awad diabig dubol, “Aŋsem mi mel en abitinaep ale wa. Dugon Anut malan lo uyan ak i? Dugo, aŋanem awam kagin mupani wak i? Tia, Anut awan kagin mupani wak i? ");
INSERT INTO tbc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Man dugo, maŋ mel sema malama lo mile yak kudoma lo maloŋ ak niŋen o awama itau san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Tamol ŋien imat gug Pita Jon da dukubune yan iŋsan anaŋar 40 iriŋani tag tamolpein fidian melmel ilasa yan niŋen Anut yaŋan diabisa se ya. An lo Juda sad kaunsil dal ta dilep lo bu dupidinai san tia ya. Ago tag ru kagin dabai geig mi dupidinaig, dubusawaig diau a. ");
INSERT INTO tbc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Saen dubusawaig dilasa yan Pita Jon da dumul turad muroud sad na diau a. Agog pris gurman, iŋ gurman aenta, ru dubol an awad aban durupidaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ru an duloŋ tag fidian Anut igo dugudani, “Tubun en, oŋ mi tan, you, beig, keit, agod mel mel fidian lo dien dan san Taman. ");
INSERT INTO tbc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Urgun lo oŋse maŋ tubum bagem Dawid oŋane urat pinein awan lo ubol dugo gamu nuŋon mile da. ‘Ata wo tan fidian sad tamolpein tiŋaed saian di? Ata wo tamolpein an palaŋ dumari gug nuŋon tia yak i? ");
INSERT INTO tbc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tan en san kiŋ fidian yu digane wo tawaŋ dumado da, ago dugo tirnek tamol fidian dutumanig, Tubun en iŋanen Pilianek Tamol da ager digane wo digane da.’ ");
INSERT INTO tbc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Rumok, ru amaiak ente Jerusalem na nuŋon ilasa ya. Herod iŋ Pontius Pailat da, tamolpein Juda tia yan agod Juda tamolpein aben ente dumado dan dida dutumanig, oŋane urat tamol gun ak Jesus oŋse piliani an, palaŋ an dumari se ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tamol adi an oŋse wagam mi oŋane ilobol iŋ dabai da lo ilasa wo ubol an, ago mi digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aria, Tubun en, gamu ru saiak tinid dumisilani san dupaiama an oŋane kududo iloŋ la ya. An ilo sou gane dop oŋane urat tamol adi dabai panamap maŋ rurek tia yan lo oŋane ru mabol ilasa wa. ");
INSERT INTO tbc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Oŋ oŋane tuo watep oŋane urat tamol gun ak Jesus yaŋan lo, tamolpein subam ad da yak kubuniaip, kulob girager dirip dilasap, kulob dababai tamolpein dil pe durut saian an dam gane wa.” ");
INSERT INTO tbc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Gudanek itout go ab a lo dutumani an ibuk ila iso ya. Ago dugo Urgun fidian bubed ilon awan isag, Anut san ru tamolpein naod na dubol ilasa wo tinid ta irer na ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ilo rumok adi fidian iŋsad kankan agod iŋsad ilod dam kisaek mi a. Ta iŋsan biouŋ biouŋ an iŋsiganen mi ago ibol man tia ya. Tia, fidian melmel nug duwae dupani se ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ago dugo ru dabai tubun anda yak lo, aposel adi Tubun ak Jesus kumaen imasa yak san bilaluŋ dubal ilasa se ya. Agod Anut san ilo panek tubun mi an iŋ fidian tinid fo iwali idu ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Iŋ luluŋad lo talpein ta mel ta lo katukan ta imado na ya. Man ata wo? Nal kadi lo, talpein ensauta a ab ad da boi, tia, tan kilaken ad da yak ta, an didaeŋ lo diganeg san moni diŋaneg, disini dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Agog moni an aposel adi ŋied fun na didirsi a, ago dugo aposel adi ditarpaleg talpein enti mel ta lo katuk adi an dubinawai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Saen an lo iŋ luluŋad lo tamol ta yaŋan Josef imado da. Iŋ Livai san gugoi lo ilasa ya, gug iŋanen tinan man nui yaŋan Saiprus dubol dan ante igansi a. Aposel adi yaŋan neinta dupanig Barnabas dubol da. (Yaŋan an fun man, Ilo Yabisa San Tamol.) ");
INSERT INTO tbc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aria, iŋsan tan kilaken idad go moni an iŋaneg isini yaug aposel adi ŋied fun na igansi a. ");
INSERT INTO tbc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Tamol ta yaŋan Ananaias, iwon yaŋan Safaira. Iŋ tan kilaken idad yau dugo san moni aenta iŋsen yabi a. Pein iŋ tamol da awad kisaek. Agog aposel adi ŋied fun na moni aenta idirsi dugo irawaig igo ibol, “Moni fidian nek ebo ya.” ");
INSERT INTO tbc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ago tag Pita Ananaias irupeig ibol, “Ananaias, ata wo Satan ulefuni dugo ilo iduduwig, sewak ganeg Urgun naon kubiani ak i? Tan a udad yau an san moni wadan wabi da. ");
INSERT INTO tbc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Saen tan gamugo udad yau man oŋ muroun mado ya. San moni ŋane yan man oŋse ilo nam gane wo ago ka gane wa, an ta rumok na i? An lo mel dugon kankan ipano yan lo kagin saian igo gane yak i? Oŋ tamol adi ta rawai na ya. Tia, oŋ Anut rawi wo gane ya.” ");
INSERT INTO tbc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Saen Ananaias ru an iloŋ man gamu nam yau idug imat a. Tamolpein fidian ru an duloŋ go tubun mi durut direr a. ");
INSERT INTO tbc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Agog pinein dupalug, iŋsan sisanun yamel nam dubuluwig diŋaneg kuai te dilasag diaug disare ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Murnag, ad mitilaen kitek 3 auwa igo yan, iwon pein ak ipalug iladu ya. Muruan ilasa man ta iloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Agog Pita isumianig ibol, “Ak dugo, oŋ oŋane iwo da tan adad yau ak naon emaiak aŋane yak i?” Ago dugo awan yabig ibol, “Awo, moni miŋane yak nek ago mi ipanaŋ a.” ");
INSERT INTO tbc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita imasag Safaira irupei, “Oŋ iwo da ilom kisaek go Tubun en san Ur naon akubianig ale wo agane ya. Dugo, aŋ ilom isou ak ago ka aganep muruan ta ale na wak abol i? Uloŋ, pinein a oŋ iwo disare yak sad ŋied awan dalawan te ilasa da, gamu oŋ dam diŋiliop kuai te alasap au a.” ");
INSERT INTO tbc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Agog gamu nam pein an dam Pita naon na yau idug imat a. Ago dugo pinein diladug iŋsan sisanun dile tag diŋane diaug iwon tamol ak giraŋen na disare ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ilo rumok adi fidian, tamolpein aenkadi dam, ru an duloŋ go tubun kasik direr a. ");
INSERT INTO tbc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel adi kulob girager wei kasik tamolpein luluŋad lo digane se ya. Ago dugo ilo rumok adi Solomon san Madok Aben ilon lo dutumani na ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tamolpein patun fo yak ilo rumok adi yaŋadi diabisa yak gug, diaup dida dutumanai san niŋen o fidian direr pasik a. ");
INSERT INTO tbc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ago bo man tamolpein wei mi ilod dibilisag, Tubun en ilod lo rumok go ilo rumok adi luad disa se ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposel adi kulob girager dabai anda digane se yan lo, tamolpein muroud muroud subam ad da yan dal gigin te diŋal dususap dien se ya. Aenkadi kapal fo, aenkadi gadab fo dien se ya. Agop saen Pita ipalup iriŋanai dop san tirarou ituanai dop lo uyadi wo dubol. ");
INSERT INTO tbc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem gigin na panu dien dan san tamolpein wei kasik dilasa ya. Iŋaned samun subam adi da yan, ur saian amad da yan diŋal dupalug, an fidian uyadi. ");
INSERT INTO tbc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Juda sad pris malan te ak, Sadyusi a giraŋen na dumado dan dida, an fidian aposel adi sad urat dile tag, turak susai tiŋaed iŋanefute ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","An lo iŋ aposel adi duburoug, subanek ab lo didirai a. ");
INSERT INTO tbc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ak man tidom lo Tubun en san eŋel ipalug subanek ab san dalawan ipasig, aposel adi iŋal go patun fo dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Agog irupidaig ibol, “Aup, tempel san tumanek aben lo atur dop, kagin foun emaiak san ru fidian tamolpein arupidaip duloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Agog aposel adi eŋel awan durig, salsog iŋ tempel lo diladug fun diganeg tamolpein ru durupidai duloŋ se ya. Nek nal an lo mi pris malan te yak, turadi dida Juda gurman fidian adi digiaig, Juda sad Kaunsil tumanek tubun ak diabi a. Agog subanek ab lo aposel adi diŋal pe dupalu wo tempel san titianek tamol didinaig diau a. ");
INSERT INTO tbc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Gug saen subanek ab lo dilasa man, aposel adi naod tia tag dumul diaug, kaunsil adi durupidai, ");
INSERT INTO tbc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Saen subanek ab lo milasa man dalawan fidian itau. Titianek tamol tawaŋ dutur ak gug, saen dalawan mupasi man tamol an ta meil na ya.” ");
INSERT INTO tbc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pris gurman adi, iŋ tempel titianek tamol adi sad gurman dida ru an duloŋ go dumasa saian. Mel an kankan ipidinaig ilod weiwei se ya, so muruan ilasa wo dak niŋen o ilod isou se ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Agog tamol ta ipalug irupidai, “Aŋ tamol a subanek ab lo adirai an tempel san tumanek aben lo dutur dugo tamolpein maŋau dipiteŋanai da.” ");
INSERT INTO tbc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ago tag tempel titianek tamol sad gurman iŋanen tempel san aikatuk adi dida diaug, aposel adi diŋal go Juda sad Kaunsil sad na diau a. Saen aposel adi diŋal man pasak nam diŋal a. Kabelan silei nam mi dop, tamolpein tiŋaed saian pe pat nam dufu banau. ");
INSERT INTO tbc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aposel adi diŋal go dupalug kaunsil naod na dugunaig dutur a. Ago dugug pris malan te yak sumianek ipidinai, ");
INSERT INTO tbc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Maŋ geg sakar geig mupanaŋ a. Aŋ afon tamol an yaŋan lo ru ta abol ilasa na wo mabol a. Gug gamu aŋ Jerusalem ilon lo aŋsam piteŋanek an mi abisa aguni da. Agop tamol a imat an iŋanen mateŋ san ai wadan maŋ buroma fo agane wo agane da.” ");
INSERT INTO tbc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ago tag Pita aposel aenkadi dida pris malan te yan awan diabig dubol, “Maŋ tamol awad kagin mupani san tia ya, tia, Anut awan mi muri mupani wa. ");
INSERT INTO tbc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aŋ Jesus aigim fo abalig afuni imat ak gug, id tubud baged sad Anut mateŋ lo ifufunig kumaen imasa da ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Anut iŋaneg giraŋen won ak lo imado da. Agod dabai ipanig, idsad gurman, idsad patun pasek tamol dam imado da. Anut saen ipanad dan lo, id Isrel tamolpein naod Jesus tupanip ilod ibileksap, an lo idaned aupasek ipare idu panad a. ");
INSERT INTO tbc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Maŋ iŋsan mateŋ, imasa yan malama lo mile ya. Ago yak niŋen ru an tamolpein naod na mabol da. Urgun dam iŋanen urat lo melmel en fidian niŋen o ibol da. Ago dugo Anut Urgun nek an tamolpein a fidian iŋsan awan kagin dupani dan ipidinai a.” ");
INSERT INTO tbc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Juda Kaunsil adi ru an duloŋ go tiŋaed tubun mi saian tag, aposel adi dufu dumat o ilod tubun mi ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gug Farisi ta yaŋan Gameliel, iŋ kubiaeŋ san girek maŋau ta, agod tamolpein fidian iŋ yaŋan diabisa yan, iŋ imasag itur dugo aposel adi tumanek dibiseip patun fo dilasa wo ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Agog kaunsil irupidaig igo ibol, “O Isrel tamol, aŋ tamol en afu dumat o agane dan kagin agane. ");
INSERT INTO tbc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wari na geig tamol ta Teudas iŋsen tubun o igane. Agog sawar kitek 4 handet igo woŋ ŋien fo dutor. Gug dufuni imat dugo iŋsan sawar an dititalaig dufurak diau dugo, ager yabisa yan nuŋon tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","An tinin te, yaŋa kubunek san saen lo, Galili tamol ta yaŋan Judas, tamol aenkadi iŋal go urat pinein oŋ ŋien fo dutor. Gug iŋ dam dufuni imat. Agog iŋsan sawar an dititalaig dufurak diau a. ");
INSERT INTO tbc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ago yak niŋen o ŋurupaiaŋ da, tamol en abusawaip ka diau a. Kubol a digane dan tamol sad kankan lo tap man, milaen tiap itout a. ");
INSERT INTO tbc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ak gug an Anut san man, aŋ tamol emaiak abituanai san ta idaisuda na wa. An lo dop abituanai o agane tap, aŋ Anut da nug abi dak ago sem iliaŋ a!” ");
INSERT INTO tbc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaunsil adi iŋsan ru duloŋ go ilod iŋane ya. Ago tag aposel adi digiaig diladug bu mi dupidinai a. Agog Jesus yaŋan fon ta dupate na wo geg sakar geig digane ya. Ago gug dubusawaig diau a. ");
INSERT INTO tbc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel adi ilod uyan dugo kaunsil sad tumanek ab dibiseig dilasa ya. Ata wo, iŋ Jesus yaŋan o tamolpein naod na muruan disini wo Anut ipilianai a. ");
INSERT INTO tbc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nal pempem tempel san tumanek aben lo, ab ab lo dam, bilaluŋ uyan ak tamolpein dupiteŋanai se ya. Bilaluŋ uyan ak lo Jesus mi iŋ Kristus an tamolpein durupidaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Murnag ilo rumok adi wei mi dilasa se yan, luluŋad lo tamolpein malan uraru dumado ya. Saen an lo, Juda tamolpein a Grik ru dubol dan, iŋ Juda tamolpein a Hibru ru dubol dan dida nug lo muruan ilasa ya. Man dugo, Juda Grik ru diŋiŋeŋ dan igo dubol, nal anek anek lo aposel adi anaŋ ditarpaleg duwae dak gug iŋsiganed pein suos ilod ta isou na da. ");
INSERT INTO tbc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ago tag aposel 12 an ilo rumok adi fidian digiaig dutumanaig durupidai, “Maŋ anaŋ waek san urat migane dop lo Anut san ru mufulale wan mibisei dop, an uyan tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ago yak niŋen o teid taod, tamol 7 luluŋam lo Urgun amad da yak, kankan milaen ak, agod yaŋad uyan ak mi apilianaip urat an banid lo tigane wa. ");
INSERT INTO tbc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gug maŋ gudanek mi, agod ru fulalek san urat dam mi leil mupani wa.” ");
INSERT INTO tbc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tamolpein fidian ru an duloŋ go aposel sad kankan niŋen o ilod uyanan a. An lo tamol ta yaŋan Stiven dipiliani a. Iŋ ilon rumok dabai, agod Awan Urgun ilon iŋanefute ya. Ta yaŋan Filip, ta Prokoras, ta Naikena, ta Taimon, ta Parmenas, agod Antiok tamol ta yaŋan Nikolas, iŋ Juda tia yak gug Juda ubou lo yau da. ");
INSERT INTO tbc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ilo rumok adi tamol 7 an aposel naod na didirai ilasa ya. Agog aposel adi iŋ o Anut dugudanig banid gurmad fo digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Agog Anut san ru ifurak go, tamolpein wei mi duloŋ a. Jerusalem na ilo rumok adi dilasag wei kasik a. Agog pris adi wei mi dam ilod lo rumok go, ilo rumok san dal duri dupani a. ");
INSERT INTO tbc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aria, Stiven man Anut san ilo panek, iŋsan dabai dam iŋ lo yen a. An lo iŋ tamolpein luluŋad lo kulob girager funfun agod mel tutubun durut saian san dam wei mi igane ilasa se ya. ");
INSERT INTO tbc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Gug Juda tamol aenkadi Stiven lo siai digane. Tamol an ubou ab yaŋan “Tamol kawan dumado dak” dubol dan sad tamol. Tamol an iŋsad panu Sairini, iŋ Aleksandria da. Agod Silisia iŋ Esia da provins uraru an sad tamol dam Stiven lo ager diabisa ya. Tamol amaiak fun diganeg Stiven lo ru nam yu digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gug Stiven san kankan milaen geig dugo Urgun san dabai lo dam iŋiŋeŋ a, an lo iŋanen ru niŋen o iŋ dutur dabai san ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ago tag tamol aenkadi pasak nam diŋal go, ru sewak igo dubol ilasa wo durupidai a. “Stiven iŋ Moses Anut da lo misilanek ru ibol dugo maŋ awan maloŋ a,” ago dubol o durupidai a. ");
INSERT INTO tbc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Agog tamol an diaug ru sewak an lo tamolpein, matu gurman adi, agod kubiaeŋ san girek maŋau dam ilod dusueg an lo tiŋaed saian geig a. Agog tamolpein an dupalug Stiven diabig, Kaunsil sad na diŋane diau a. ");
INSERT INTO tbc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kaunsil malad lo itur dugo, tamol Stiven tinin lo dusupale san digiaig, diladug ru sewak igo dubol, “Tamol en idsad tempel gun an, Moses san kubiaeŋ da niŋedi wo ru saian pempem ibol da. ");
INSERT INTO tbc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Maŋ maloŋ dugo ibol, Nasaret tamol a Jesus dubol dan tempel iratitale dop, Moses san kubiaeŋ id ipanad an dam ibileksa dop idirad pe tamol kagin senamo ak turi wa.” ");
INSERT INTO tbc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ru an dubol dugo Kaunsil dumado yan malad ti ibol go Stiven leil dupani dugo, iŋanen naon eŋel ta naon igo woŋ dile ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Juda Kaunsil ru an fidian duloŋ go itout gug pris malan te an Stiven isumiani, “Dugo, ru a dupano dan fidian rumok ak i?” ");
INSERT INTO tbc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ago tag Stiven ru naon irupidaig igo ibol, “Teig taog, tamag muroug, kududom agure! Id tubud baged Abraham wagam geig Mesopotemia na imado dugo, saen an lo iŋ gamugo Haran na yau dugo, Anut lilaman anda yan naon na ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Agog irupei, ‘Tan en biseip, oŋane murou murou dam busawaip tan ŋukubiai pano wan lo wau.’ ");
INSERT INTO tbc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Agog Kaldia tan ibiseig yaug taun a Haran dubol dan te imasi a. Murnag Abraham taman imat dugo Anut idinig tan e lo amado den ente ipalug, imasi a. ");
INSERT INTO tbc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Saen an lo Anut tan en samun kabelan ta Abraham sen tinin o ipani man tia ya. Gug Anut mitep tan en Abraham iŋ malan kubulan dida ipidinaip sed niŋedi wo ibol a. Gug Abraham saen an lo nanuk tia imado dugo Anut promis an ipani a. ");
INSERT INTO tbc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anut igo ibol, ‘Oŋ mala kubulan mitep tan sen ak lo tamolpein gol ak igo woŋ ante dumado wa. Ante dam iŋ urat bigabeg adi dilasa wa. Agop anaŋar 4 handet lo tan an san tamolpein saian dupidinaip muruan wei mi disini wa. ");
INSERT INTO tbc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gug ŋai tamolpein a muruan ago dupidinai dan naon muruan geig ak ŋupidinai a. Ago dugup oŋane mala kubulan tan an dibiseip, tan en lo ŋai ubou ag dile wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Agog Anut Abraham kontrak ipani a, kontrak an san kob man, nanuk tamol ak tinid suŋulon dutute wa. Murnag Abraham iwon iŋ Aisak igansig ubou kisaek yau dugo Abraham tinin suŋulon itute ya. Murnag, Aisak san nanun Jakob ilasa ya. Ago mi Jakob san nanuk 12 dilasa ya. Iŋ idsad tubud baged.” ");
INSERT INTO tbc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Josef tein muroun Josef niŋen o turak dususa ya. Iŋ dile saian an lo Igipta na urat bigabeg imado wo diŋaneg didaeŋ lo digane yau a. Ak man Anut Josef da dumado na ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iŋsan muruan fidian lo ibinawig patun ipasi a. Anut Josef kankan milaen mi ipani an lo Farou Igipta sad kiŋ Josef ipitianig ilon ipani a. Agog Farou Josef tamol tubun iganeg Igipta tan, iŋsan ab lo melmel fidian dam kagin ipani na ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Murnag Igipta tan yaug Kenan na geg an kadag tubun ak idug, tamolpein fidian muruan disini se ya. Id baged muroud anaŋ dile wo abaŋ diabi se ak gug anaŋ tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Gug saen Jakob Igipta na anaŋ yen dan san ru tim iloŋ man, nanun muroun, id baged muroud, idinaig malmalan geig iŋ atna diau a. ");
INSERT INTO tbc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Murna anaŋ itout go fon dumul Igipta na diau gug, Josef tein muroun naod na sen fun ifulaleg, Farou dam saen an lo Josef tinan taman, tein muroun niŋedi wo ru iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Agog Josef taman san na ru igane yaug, iŋanen samun fidian iŋal pe dupalup Igipta na dumado wo ibol. Fidian dupalu yak sad sutek 75. ");
INSERT INTO tbc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Agog Jakob imasag Igipta na yau a. Atna mi dumado dugo Jakob id baged muroud 12 an dam dumat a. ");
INSERT INTO tbc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iŋsad sisanun disini diaug Sekem na tan kilaken ta wagam Abraham Hamor sad gugoi banid lo idad iŋane yan lo disiriai a. ");
INSERT INTO tbc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Anut Abraham promis a gubak mi ipani an nuŋon ilasa wo sumeik dugo, idsad tamolpein Igipta na dumado yan igileg wei kasik a. ");
INSERT INTO tbc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Saen an lo kiŋ foun ta ilasag imado dugo Igipta kagin ipani na ya. Ak gug kiŋ an Josef niŋen iŋaoŋ geig a. ");
INSERT INTO tbc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Idsad tubud baged irawai ifu dugo, muruan tubun mi ipidinai se ya. Iŋ isodudunaig an lo iŋaned nanuk foudi ak kuai tem didiraig, dumat a. ");
INSERT INTO tbc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Saen an lo Moses ilasa ya. Anut malan lo nanuk an siŋaokan mok a. Kalam utol tinan taman dida dumado dugo kagin dupani a. ");
INSERT INTO tbc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Gug saen kuai te digane man, Farou nanun pein ŋilaŋal an iŋaneg, iŋsinan nanuk oŋ kagin ipani na ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses Igipta sad maŋau fidian mi iŋaneg, tamol tubun ak ilasa ya. Iŋsan ru bilabol dabai dugo, urat dugon igane yan dam dabai anda ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses san anaŋar 40 dugo, nal ta ilon man tein taon Isrel tamolpein yil o ibol go yau. ");
INSERT INTO tbc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yau dugo naon fo na Igipta tamol ta Isrel tamol ta tinin ifini saian dugo ile ya. Ago tag Isrel tamol an ibinawig, naon ifulig Igipta tamol an ifuni imat a. ");
INSERT INTO tbc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Iŋsan ilon man, Isrel tamolpein Anut iŋ ibinawai o idinig ipalu yan duloŋ ak ibol, ak gug tamolpein an ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nal tinin te man, Isrel tamol uraru nug dufuni dugo yil tag, maror igansi wo yaug irupidai, ‘Aloŋ, aŋ nug tein taon, en ata wo nug tinin malan asue wo agane dak i?’ ");
INSERT INTO tbc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Gug neinta wagai fun igane yan, Moses isopasig gigin na yaug ipei, ‘Enti oŋ maŋ kagin panama dop ru tulek tamol mado wo ibol i? ");
INSERT INTO tbc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ak dugo, nor Igipta tamol funi imat ago mi ŋai dam funag ŋamat o gane dak i?’ ");
INSERT INTO tbc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses ru an iloŋ tag isol go yaug Midian tan lo tamol gol ak oŋ imado na ya. Atna imado dugo nanuk tamol ak uraru dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Afon anaŋar 40 yaug itout gug, Anut san eŋel Moses naon na ilasa ya. Did Sinai giraŋen na tan kawan ak lo ai nanunan ta yai ided go inani dak oŋ ile ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses abaŋ ago ileg imasa saian tag, yaup sumeikan pe ile uyan o ibol go yau a. Saen yaug sumeik ipani man, Anut awan iloŋ, ");
INSERT INTO tbc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ŋai oŋ bage murou Abraham, Aisak, Jakob sad Anut.’ Moses ru an iloŋ man irer dugo tubun mi isuruwor se ya. Irut irer an niŋen o abaŋ ile man imoig, malan ikilakil a. ");
INSERT INTO tbc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Agog Anut ibol, ‘Oŋsa sendal pasi. Man dugo, tan fo utur dan gun a. ");
INSERT INTO tbc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ŋai abaŋ ŋile yak ŋaisag tamolpein Igipta na muruan saian geig ak disini da. Iŋsad ilo tinaŋ dam ŋaloŋ go ŋubunawai o ŋupalu ya. Ak niŋen o ŋai oŋ ŋidinop afon Igipta na umul wau da wa.’” ");
INSERT INTO tbc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stiven iŋiŋeŋ dag ibol, “Moses nek amaiak Isrel tamolpein gubak mi niŋen o dumoi go dubol, ‘Enti oŋ maŋsam gurman iginio yak i? Enti oŋ maŋsama tulek tamol iginio yak i?’ Anut sen mok Moses iŋsad gurman, agod iŋsad patu pasek tamol dam idinig yau a. Anut eŋel yai balen lo yan awan lo ago igane ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses nek an tamolpein iŋal go Igipta dibisei a. Igipta na, agod Beig Daran lo, Anut san dabai lo kulob girager funfun naod na igane se ya. Anaŋar 40 tan kawan ak lo dam ago igane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses iŋsen geig Isrel tamolpein irupidai, ‘Anut ŋai idinag go ŋupalu yak ago mi profet ta idinip ipalu wa. Tamol an mitep aŋsiganem dar lo ilasa wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Saen Isrel tamolpein tan kawan ak lo dutumani an, Moses dam dida dutumani a. Iŋ idsad tubud baged dida dumado ya. Agog Moses did Sinai fo isidag, eŋel da diŋiŋeŋ a. Agog Anut ru kumaen san an ipani a, agog Moses afon ru an id ipanad a. ");
INSERT INTO tbc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Gug idsad baged muroud Moses awan dumoig, iŋ Igipta na dumul diau wo ilod tubun mi ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ago tag Aron durupei, ‘Oŋ maŋ tubud diri panamap, dumug dop muraep mau a. Tamol Moses dubol dan iŋiliad go Igipta tibiseig tupalu yan, ata iŋane dugo ta ipalu na da, an ta taloŋ na ya.’ ");
INSERT INTO tbc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iŋ atna makau mitilaen diganeg yai digane pani dugo, mel a sed banid nam digane yak niŋen muguruŋ tubun ak digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ago tag Anut patun ipidinaig, an lo iŋaned ilod ibol ago patui keit lo yan yaŋad diabisa se ya. Kulob digane an profet sad girek lo wagam profet ta ru naon kisaek igire a: ‘O Isrel tamolpein, dugo, anaŋar 40 tan kawan ak lo, aŋsam lou panek apanag, agod makau afup ŋai yai agane panag se yak i? Tia geig a. ");
INSERT INTO tbc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ab sel asini ator se yan aŋsam tubud Molok san asini se ya. Ago dugo aŋsam tubud Refan san mitilaen patui an asini ator se ya. Mitilaen an yaŋad lo ubou ale wo asuwi idu ya. Ago yak niŋen o ŋai ŋukudaŋ pe aup, asau mi Babilon aen ate geig amado wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Id baged muroud Anut san ab sel a iŋ dida dumado yan ikubiai pidinai an diabi dugo, tan kawan ak ate da disini dutor na ya. Ab sel an nek Anut Moses ikubiaig ile yak ago mi dususe ya, Moses dugon ile yan fom ab sel an diabi a. ");
INSERT INTO tbc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Murnag ab sel an id baged muroud iŋ tamad banid lo diŋaneg, Josua dida diaug yu diabisag tamolpein sen ak sad tan lo dukudaig diau a. Agog iŋsad tan banid na diŋane ya. Ab sel an ago yen dugo yaug Dawid san saen idu ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawid iganeg Anut iŋ o ilon uyan geig a. Agog Dawid igudanig, Jakob san Anut ab ta ilon lo imado san yabi pani wo isumiani a. ");
INSERT INTO tbc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gug Dawid ab an ta yabi na ya. Solomon iŋ ab an yabi a. ");
INSERT INTO tbc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Gug Anut a lak na geig an, iŋ ab a tamol banid nam diabi ak lo ta imado na da. Wagam mi profet adi sad girek lo ta igo ibol, ");
INSERT INTO tbc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tubun en ibol, keit man ŋaisag kalik kiŋ san a, agod tan man ŋai ŋieg aten yen san aben. Enso ab abi panag ak i? Aben dugon lo yaes ŋabal ak i? ");
INSERT INTO tbc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ak dugo, mel an fidian ŋai banig nam ŋigane ya, an ta rumok na i?’” ");
INSERT INTO tbc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Agog Stiven Juda Kaunsil ipidai, “Aŋ gurmam sakar geig. Ilom gob. Anut san ru ibol dan kududom itau geig a. Aŋ nek ibol aŋanem tubum bagem igo woŋ a, man dugo, iŋ dam Awan Urgun pempem diabiani na ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Arupaiag, dugo, gubak mi profet ta imado dugo aŋanem tubum bagem profet an tinin ta dumisilani na yak i? Iŋ profet adi ensauta a malad milaedi go Tamol Itaotan iŋsan palu yan niŋen profet ru dubol ilasa yan dufu dumat a. Agod aŋ gamu tamol amaiak iŋ bo aŋanem turam mok ak gug ager banid lo aganeg sisem afuni imat a. ");
INSERT INTO tbc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Aŋ nek en, Anut san kubiaeŋ eŋel sad banid lo aŋane yak gug kagin ta apani na ya.” ");
INSERT INTO tbc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Saen kaunsil adi ru an duloŋ man, tiŋaed tubun mi imumari dugo Stiven gamad dirati pani se ya. ");
INSERT INTO tbc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Gug Stiven tinin Urgun iŋanefuteg malan keit lo isidag, Anut san girager ile ya. Ago dugo Jesus Anut giraŋen won ak lo itur dugo ileg ibol, ");
INSERT INTO tbc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Ale. Ŋai keit awan ipasig Tamol Nanun Anut giraŋen won ak lo itur dugo ŋile da.” ");
INSERT INTO tbc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Fidian disasaitout go kududod diafutani a. Agog fidian mi dumaspalug, ");
INSERT INTO tbc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Stiven diabig Jerusalem gigin na dirae dilasag, fun diganeg pat nam dufuni a. Tamol pat dubal san iŋ biouŋ dupasig pinein ta Sol dubol dak kagin ipidinai o ŋien fun na didirsi a. ");
INSERT INTO tbc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pat nam dufuni dugo, Stiven Tubun en igudani, “O Tubun en Jesus, ŋaineg ŋutug ŋane!” ");
INSERT INTO tbc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Agog yau idug fon igudanig igo iwagiŋ, “Tubun en, iŋaned aupasek en san pani naon aŋ lo fuli san man umoi.” Ago ibol go imat a. ");
INSERT INTO tbc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol ante imado dugo Stiven san mateŋ ileg, ilon uyan. Ilo rumok tamol aenkadi Stiven disareg, ilod tubun mi saian go awad tubun mi ditata se ya. Nek saen an lo mi Jerusalem na ilo rumok adi fun diganeg, Jesus yaŋan o muruan tubun mi disini se ya. Agog dufufurak go aenkadi Juda na aenkadi Sameria na diaug dumado ya. Ak man aposel adi Jerusalem na dumado ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Gug Sol man midaeŋ ititale wo yaes ifuni a. Ab ab idu isida dugo Kris tamolpein iŋal go iraug subanek ab lo idirai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ilo rumok adi a dufufurak go gidigidad diau na yan, aben dugo ate diau an Anut san ru dufulale se ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip Sameria na yaug, taun tubun ak ta ilon lo iladug ante sad naod na ru Kristus niŋen o ibol ilasa se ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Saen tamolpein doup tubun iŋsan ru duloŋ dugo, kulob girager igane yan dile man, iŋsan ru fidian duloŋ uyan o kududod dugure ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ur saian awad tubun mi disasai dugo, tamol tinid lo yak dubiseig dilasa ya. Tamolpein ŋied itubabun, agod a dutor saian saian dan wei mi uyad isusa ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ago man taun an ilon lo yousai yen go tubun kasik. ");
INSERT INTO tbc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aria, taun an lo kiai tamol ta yaŋan Saimon imado ya. Iŋsan sewak an lo nal kitek milaen mi Sameria tamolpein iginiaig dumasa saian. Iŋsen mi iŋ tamol tubun ak se pitianoi san ru ago ibol. ");
INSERT INTO tbc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Agod taun an sad tamolpein fidian, a yaŋad ad da yan, agod a yaŋad tia yan dam, kududod dugure ya. Ago dugo dubol, “Tamol en man, tubud san dabai a yaŋan Dabai Tubun Ak dubol dan, tamol emaiak iŋsen.” ");
INSERT INTO tbc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nal milaen mok iŋsan nawir an lo irawaig, tamolpein fidian iŋ awan paen na dumado dugo durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Gug saen pein, tamol dam Filip awan lo bilaluŋ uyan ak san ru Anut san kagin panek niŋen o, agod Jesus Kristus yaŋan niŋen o dam duloŋ man, iŋ ilod lo rumok a. Agog suguek diŋane ya, tamol iŋ pein da mi a. ");
INSERT INTO tbc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon sen dam ilon lo rumok go suguek iŋane ya. Agog Filip ŋien fo itor dugo kulob girager funfun Filip igane dugo ileg niŋen o irut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Saen aposel adi Jerusalem na dumado yan Sameria tamolpein Anut san ru diŋane yak duloŋ tag, Pita Jon da didinaig, iŋsad na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Sameria na dilasag, tamolpein Urgun diŋane san niŋen Anut dugudani a. ");
INSERT INTO tbc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Man dugo, Urgun fufod na gamugo idu ya, tia, Tubun en Jesus yaŋan lo suguek diŋane yan mi a. ");
INSERT INTO tbc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Agog Pita Jon da tamolpein gurmad fo banid digane dugug, Urgun diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Agog Saimon tamolpein Urgun aposel adi banid lo diŋane dugo ile tag, moni iŋaneg, Pita Jon da sad na yaug ibol, ");
INSERT INTO tbc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Dabai an ŋai dam apanag. Agop tamol dugon banig gurman fo ŋigane dan Urgun iŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ak man Pita ru naon igo ibol go irupei, “Oŋane moni an ŋanep, ida udeg wau. Ata wo? Oŋ ilo lo man lou panek e Anut ipanad den moni nam udad ŋane wak ubol da. ");
INSERT INTO tbc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Oŋ maŋsama urat boi en lo oŋ yaŋa tia ya. Man dugo, oŋ ilo man Anut malan lo ta itaot na ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ago yak niŋen oŋsa kankan saian an umoi kisaek oŋ. Ago dop Tubun en oŋsa kankan saian gane yan ipasi wo gudani wa. Nap ilo sou naok ago bube ilon lo gane dan an bo subam an ipare idu pano wak boi. ");
INSERT INTO tbc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Man dugo, ŋai ŋilio dak, mala sek agod turak susai dam mi oŋ tini iŋanefute dugo, aupasek san subanek tamol mado da.” ");
INSERT INTO tbc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","An lo Saimon iŋ Pita Jon da ru naon igo irupidai, “Gidad, aŋ ŋai niŋeg o Tubun en agudani. Agop an lo muruan abol dan ŋai fo na ta ilasa na wa.” ");
INSERT INTO tbc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aria, Pita Jon da Tubun en dugo woŋ ibinawai an tamolpein durupidai duloŋ go iŋsan ru dam dubol ilasa se ya. Saen urat an digane itout man, dumul go Jerusalem na diau a. Diau dumul dugo dal dal na, Sameria panu wei mi lo dam Anut san ru dufulale se ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tubun en san eŋel ta Filip irupei, “Masap dal Jerusalem nag Gasa na idu yau an ŋanep wau.” (Dal an tan kawan ak lo yen da.) ");
INSERT INTO tbc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ago tag Filip eŋel ibol ago mi igane. Dal na yau dugo Itiopia sad tamol gurman ta ile, tamol an iŋanen nabun dusukali a. Tamol an Itiopia Kwin yaŋan Kandesi san moni kagin ipani da. Iŋ Jerusalem na ubou ile wo yau ak ");
INSERT INTO tbc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","fon imul sen fun panu lo yau da. Karis fo profet Aisaia san ru isuti dugo yau. ");
INSERT INTO tbc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Agog Urgun Filip irupei, “Waup karis an sumeik ida au.” ");
INSERT INTO tbc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ago tag Filip imaspalu oŋ yaug sumeik dugo, profet Aisaia san ru isuti dugo iloŋ tag isumiani, “Dugo, ru suti dan fun kitek uloŋ di?” ");
INSERT INTO tbc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Iŋ ibol, “En dugop ŋai ru en fun ŋaloŋ ak i? Rumok talpein ta fun ifulale ak man nap ka ŋaloŋ a.” Agog Filip iwagig isidag siŋiren na imasi a. ");
INSERT INTO tbc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ru girek boi emaiak isuti, “Iŋ man sipsip dufuni wo diŋane diau dak igo woŋ. Iŋ nek ibol sipsip nanun fufulun dutute dop awan itau itur dak igo woŋ. An lo awan kitek ipuk man tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Iŋ miai tubun mok dupanig, iŋ o ru itaot dubol man tia ya. Kot aen kisaek mi digane. Enti tamol an san malan kubulan niŋedi wo ru ta ka iŋiŋeŋ ak i? Talpein ta kisaek tia ya. Man dugo, iŋsan madok tan en lo digane itout go lak na yau a.” ");
INSERT INTO tbc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Itiopia tamol gurman an Filip isumiani, “Profet iŋ enti niŋen o ibol dan, gidad ubol pe ŋaloŋ. Iŋsen niŋen o ibol, tia, talpein sen ta niŋen o ibol i?” ");
INSERT INTO tbc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ago dugug Filip girek nek en lo fun iganeg bilaluŋ uyan ak Jesus niŋen o yan ibol idug iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ru ifulale dugo dupalug you ta fun na dilasag, tamol gurman Filip irupei, “You ebe ya. Dugo, mel ta isubanag pe suguek ŋiŋane wan tia i?” ");
INSERT INTO tbc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ago man gurman an ibol dugo iŋsan urat pinein karis yabituani a. Agog iŋ Filip da you lo dudug Filip tamol an isugui a. ");
INSERT INTO tbc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Saen you dibiseig dilasa yan Tubun en san Ur Filip iŋane yau. Tamol gurman an Filip ta ile na gug ilon youn isag iŋsiganen na yau a. ");
INSERT INTO tbc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Agog Filip Asdod na kuai isi a. Agog tureŋ yabig panu panu lo Jesus san bilaluŋ uyan ak ibol ilasa dugo itor nag Sisaria na ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Saen an lo Sol iŋ Tubun en san tamolpein ifu dumat o urer ipidinai dugo ibol itor se ya. Agog pris malan te ak san na yaug, girek ta igire pani wo isumiani a. Girek an Juda ubou ab sad gurman adi Damaskus na yan ikubiai pidinai dop, tamol ta boi, tia pein ta boi, ilo rumok kagin a “Dal En” dubol dugo diri dan abaŋad ile tap, ibiap isubanaip, dida Jerusalem na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damaskus na yau wo dal iŋaneg yaug sumeik dugo gamu nam keit lo lilaman ta irakilawig, abaŋ isapudadeg Sol ibuluwi a. ");
INSERT INTO tbc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Agog yau idug tan na yen dugo awan ta iwagiŋ dugo iloŋ, “O Sol! Sol! Ata wo ŋai malag sue dak i?” ");
INSERT INTO tbc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ago tag Sol isumiani, “Tubun en oŋ enti?” Ago dugo awan an ibol, “Ŋai Jesus nek a malag sued ama ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Aria, masap waup Damaskus na ladu. Ago gup dugo gane wan dubol uloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tamol adi a Sol dida tureŋ diabi dan dupartuanig ru ta dubol san tia ya. Awan iŋiŋeŋ se yan bo duloŋ gug talpein nuŋon dile man tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol imasag malan ipuk gug abaŋ ile san tia ya. Ago tag banin diabig diŋaneg Damaskus na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nal utol abaŋ ile san tia ya. Agog anaŋ dam, you dam tia imado ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ilo rumok tamol ta yaŋan Ananaias Damaskus na imado se yan, malan ŋutun lo Tubun ak irupei, “Ananaias.” Agog Ananaias ibol, “Tubun en, ŋai ebo ya.” ");
INSERT INTO tbc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Agog Tubun en irupei, “Masap, waup, ‘Dal itaot’ dubol dan ate Judas san ab lo Tarsus tamol ta yaŋan Sol dubol dak niŋen o sumiai. Iŋ man igudani dugo malan ŋutun lo mel ta igo ile ya, tamol ta yaŋan Ananaias ipalug gurman fo banin igane dugo abaŋ fon ile da yak ago ŋioŋ lo ile ya.” ");
INSERT INTO tbc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias ru naon irupei, “O Tubun en, tamolpein wei mi tamol an niŋen o dubol dugo ŋaloŋ a. Kagin saiak saiak funfun oŋane tamolpein Jerusalem na yan lo igane yak san ru durupaiag dugo ŋaloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Gamu pris gurman adi awok dubol go ete Damaskus na ipalug, talpein enti oŋ yaŋa lo ubou dile dan ibiap iŋal diau o ipalu ya.” ");
INSERT INTO tbc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gug Tubun en Ananaias irupei, “Wau! Man dugo, ŋai tamol an urat ag igane wo ŋipiliani a. Iŋ tinin lo tamolpein Juda tia yan, iŋaned kiŋ dida, Isrel tamolpein dam naod na ŋai yaŋag kuai te irupidaip ru ŋai niŋeg o duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Agod iŋ ŋai yaŋag o muruan tubun mi isini wan ŋai ŋukubiai pani wa.” ");
INSERT INTO tbc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Agog Ananaias yaug ab lo iladug, Sol gurman fo banin iganeg ibol, “O teig Sol, Tubun ak sen idinag go ŋupalu ya. Jesus sen nek ete Damaskus na palu dugo dal na naon na ilasa amaiak, oŋ afon abaŋ ule dop Urgun oŋ tini iŋanefute wo idinag go ŋupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ago ibol ak gamu nam mel ta nek ibol iy tubulan igo woŋ Sol malan lo yak ditapas tan na dudu ya. Agog malan ipuk go abaŋ fon ile ya. Ago man imasa itur go suguek iŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Agog anaŋ yanig tinin fon dabai da ya. Sol nal aenta Kris tamolpein dida Damaskus na dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Agog imasag itaot Juda sad ubou ab fidian lo yaug, Jesus san ru ifulale dugo ibol, “Jesus iŋ Anut Nanun.” ");
INSERT INTO tbc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tamolpein fidian a iŋ awan duloŋ se yan durut saian geig go sed nug dusumiani dugo igo dubol se, “Dugo, tamol an iŋsen Jerusalem na tamolpein Jesus yaŋan dupate dugo ifu dumat na yak nek emaiak i? Go iŋ e ipalu yan tamolpein iburoup, iŋal pris gurman adi sad na diau wo ipalu yak i?” ");
INSERT INTO tbc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Gug Sol san ru fulalek dabai geig ak niŋen o, Jesus iŋ Kristus an tamolpein fidian kuai te ikubiai pidinai a. An lo Juda tamolpein Damaskus na dumado dan durut saian dugo awan diabi san muruadi. ");
INSERT INTO tbc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Murnag saen kitek milaen mi yau dugo, Juda adi Damaskus na yan Sol dufuni wo dutumanig palaŋ an dumari. ");
INSERT INTO tbc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ak man tamol ta pasak nam irupei iloŋ a. Tidom ad panu san dalawan te ager adi tawaŋ digane se ya. Sol ipalu dop diabip dufuni imat san mi a. ");
INSERT INTO tbc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Gug nal ta tidom lo Sol san megeloum adi diŋaneg, diaug sep fog udou lo duyuweg, patun fo idu ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem na yaug ilo rumok adi luad isa wo igane yak gug, iŋ Sol gamu Tubun en san megeloum mok an ilod ta rumok na yan lo ilod weiwei a. Iŋ fidian iŋ niŋen o tubun mi direr a. ");
INSERT INTO tbc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ak man Barnabas Sol iŋaneg aposel adi sad na diau a. Agog Sol Tubun en Damaskus dal na ile yan, Tubun en ru irupei an dam irupidai duloŋ a. Agog Damaskus na Anut ru ifulale wo ta isuksuk na yan dam ibol idug duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Atnag Sol aposel adi dida dumado dugo, Jerusalem ilon lo Tubun en san ru ifulale dugo itor se ya. Ilon fidian an ru ifulale dugo tinin ta irer na ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol iŋ Juda tamolpein Grik ru dubol dan dida diŋiŋeŋ dugo nug aen ditog na ya. An niŋen o dufuni imat o dal abaŋ dile se ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Agog saen ilo rumok adi ru an duloŋ tag, Sol diŋaneg Sisaria na diaug Tarsus na didinig yau a. ");
INSERT INTO tbc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Saen an lo Kris midaeŋ Judea na, Sameria na, agod Galili na yan an fidian maror lo mi dumado na ya. Awan Urgun midaeŋ dabai ipidinai dugo ilod yabisa se ya. Iŋsan dabai lo midaeŋ ilasag, tubun kasik. Agod Tubun en niŋen direr dugo iŋsan ilobol lo mi dumado dutor se ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita panu panu itor nag, nal ta Lida na Tubun en san tamolpein ate dumado dan yil o yau. ");
INSERT INTO tbc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aben an ate yau nag tamol ta ŋien banin dumat ak ile ya. Tamol an yaŋan Ainias. Iŋ anaŋar 8 ŋioŋ aben ta ibisei na ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita tamol an irupei, “Ainias, Jesus Kristus oŋ ikubunio wo da. Masap, oŋane ŋioŋ aben kubune.” Ainias ru an iloŋ go gamu nam imasag itur a. ");
INSERT INTO tbc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Saen tamolpein Lida na, Saron na dumado dan Ainias dileg Tubun en niŋen o ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa na pein ta yaŋan Tabita, iŋ Kris pein ta. (Grik ru lo yaŋan Dorkas). Iŋsan saen tubun mi man binawek urat mi igane da. Agod tamolpein filiad tia yak ibinawai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Saen an lo subam iŋaneg imat, agog tinin dufulanig galuŋ lak na yak lo diganeg yen. ");
INSERT INTO tbc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa nap Lida na wau man asau tia ya. Ago yak niŋen o saen ilo rumok adi Jopa na yan Pita Lida na imado dak duloŋ tag, tamol uraru ru en disinig Pita san na diaug ilon diŋane dugo durupei, “Gidad maŋsama na ririan palu.” ");
INSERT INTO tbc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ago tag Pita tamol uraru an dida diau a. Saen dilasa yan Pita diŋaneg galuŋ lak na yan lo diau a. Ante man pein suos Pita dutur dulubanig ditata dugo, Tabita gamugo imat dugo biouŋ iwei na yan dukubiai pani a. ");
INSERT INTO tbc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Agog Pita fidian idinaig patun fo dilasa dugug turun isaluwig igudani gug, idaŋsag naon Dorkas san sisanun ipani dugo irupei, “Tabita, masa!” Ago ibol dugo Tabita malan ipuk go Pita ileg imasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita banin iwate dugo yabig imasa itur a. Agog Kris tamolpein iŋ Kris suos dida igiaig, Tabita kumaen imado yan ikubiai dugo dile ya. ");
INSERT INTO tbc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ru an Jopa na ifurak go, tamolpein wei kasik Tubun en niŋen o ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Agog Pita Jopa na saen milaen mi tamol ta yaŋan Saimon ida dumado se ya. Tamol an makau suŋulon, melmel funfun suŋulod ikubune dop igane igos da. ");
INSERT INTO tbc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria na tamol ta yaŋan Konilias, iŋ Rom sad yu gurman tubun a. Iŋsan doup ititianai dan yaŋad “Italian Sawar”. ");
INSERT INTO tbc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iŋ, iŋanen samun fidian dida Anut yaŋan lo ubou dile da. Juda tamolpein filiad tia yan ibunawai siŋaokan dop, pempem Anut igudani se ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nal ta 3 klok guraian gudanek san saen lo malan ŋutun ta ile ya. Malan ŋutun an lo Anut san eŋel ta ipalug irupei, “Konilias!” ");
INSERT INTO tbc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias irer an lo malan ti ibol go eŋel an leil ipani dugo isumiani, “Tubun en. En dugo ya?” Agog eŋel awan yabig ibol, “Anut oŋane gudanek iloŋ a. Agod oŋane binawek urat gane dan ileg, oŋ o ilon isou da. ");
INSERT INTO tbc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ago yak niŋen o tamol ta dinaip Jopa na diaup, tamol ta yaŋan Saimon Pita diŋanep dida dupalu wa. ");
INSERT INTO tbc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iŋ tamol ta yaŋan Saimon ida loŋ aen te dumado da. Tamol an melmel funfun suŋulod ikubune dop igane igos da.” ");
INSERT INTO tbc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Eŋel Konilias ibisei yau dugo, Konilias yu tamol kisaek, agod iŋsan ab san urat pinein uraru dida igiaig dupalu ya. Yu tamol an dam Anut yaŋan isini san tamol, agod iŋ Konilias san biabi ŋilaŋal. ");
INSERT INTO tbc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Agog melmel ilasa yan naod na ibol idug, idinaig Jopa na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Salsog dal na diau dugo, ad titiŋaem itur an Pita igudani wo ab san fuŋ ilabakan an fo isida ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Imatigen saian go anaŋ yani wo ilon tinin fidian ibol. Anaŋ dineid dumado dugo Pita malan ŋutun ta ile ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Malan isidag keit awan ipasig mel ta yamel oŋ ak gigin iwoiwo atem diabi dugo duyuweg tan na idu dugo ile ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yamel an fo bor, anakanak, mot, mudan naon funfun yil a. ");
INSERT INTO tbc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Agog awan ta iwagiŋ go ibol, “Pita, masap mel an ufu idup wani.” ");
INSERT INTO tbc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ak man Pita ibol, “Tubun en, tia geig. Juda kagin lo mel ta nun dubol dan ŋai gubak mi ŋani man tia geig a.” ");
INSERT INTO tbc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ago tag awan an fon ibol, “Mel dugon Anut ikokan ibol ak, oŋ waliŋ ganep, nun ta ubol na wa.” ");
INSERT INTO tbc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mel naon kisaek an mi ilasa utol gug, fon melmel an yamel anda imul keit lo yau a. ");
INSERT INTO tbc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita malan ŋutun ile amaiak san fun kankan an igane dugo, Konilias tamol idinaig diau an Pita ab lo imado dan duloŋ tag dupalug ab awan te dutur a. ");
INSERT INTO tbc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ab muroun duwagiŋ go dubol, “Tamol ta etna yaŋan Saimon Pita imado di?” ");
INSERT INTO tbc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita malan ŋutun amaiak kankan an iganed imado dugo Urgun irupei, “Uloŋ, tamol utol oŋ abaŋa diabi da. ");
INSERT INTO tbc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","An lo udup, dida au. Ilo weiwei umoi. Man dugo, ŋaiseg ŋidinaig, oŋsa na dupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ago tag Pita idug irupidai, “Tamol abaŋale dan ŋai nek en. Aŋ ata wo apalu yak i?” ");
INSERT INTO tbc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ago tag ru naon durupei, “Yu gurman tubun ak Konilias idinamag mupalu ya. Iŋ tamol itaot mok, Anut yaŋan lo ubou ile da. Juda tamolpein dam tamol an yaŋan disini da. Anut san eŋel gun ak ta ipalug oŋ igiop iŋsan ab lo waup ŋiŋe dop iloŋ o ago eŋel an irupei a.” ");
INSERT INTO tbc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ago tag Pita tamol utol an igiaig diladug atna dida dien a. Tidom lom mi, Jopa na ilo rumok adi aenta Pita luan disag, tamol utol an dida diau a. ");
INSERT INTO tbc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tidom kisaek dal na dien gug Sisaria na dilasa ya. Konilias iŋanen samun, turan muroun dam igiaig dupalu yan fidian Pita malan diganed dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ab lo iladu wo dugo Konilias yaug Pita naon na tubud igo woŋ turun isaluwi pani a. ");
INSERT INTO tbc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Gug Pita banin idug yabisag irupei, “Masa, ŋai man tamol nek oŋ igo ya.” ");
INSERT INTO tbc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita Konilias ru irupei dugo ida ab lo diladug, tamolpein wei mi dumado dugo yil a. ");
INSERT INTO tbc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Agog Pita irupidai, “Aŋ aloŋ ak. Juda sad kubiaeŋ ibol ak, Juda tamolpein diaup tamolpein Juda tia yan dida ta mok dutumani na wa. Ak man Anut igo ikubiai panag, ŋai tamol ta nun ak ta ŋabol na wa. Ikok tia yak dam ta ŋabol na wa. ");
INSERT INTO tbc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ago yak niŋen o saen ŋai niŋeg o ru gane man ta ŋamoi na ya. Ata wo mok ŋai niŋeg o ru gane yak i?” ");
INSERT INTO tbc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ago dugo Konilias ibol, “Nal utol yau la ya. Gamu saen nek igo 3 klok guraian ŋaisiganeg ab lo ŋugudani dugo, gamu nam tamol kulos malan milkouk geig ak idirig naog na itur a. ");
INSERT INTO tbc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Agog irupaiag, ‘Konilias, Anut oŋane gudanek iloŋ a. Agod binawek urat gane dan ile dugo oŋ ilon isou da. ");
INSERT INTO tbc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Talpein ta dinaip Jopa na diaup, tamol ta yaŋan Saimon Pita niŋen o dusumiai. Iŋ Saimon sen ak san ab lo imado da. Saimon an melmel suŋulod ikubunep igane igos da. Iŋ loŋ aen te imado da.’ ");
INSERT INTO tbc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ago yak niŋen o gamu nam oŋ palu wo ru ŋigane ya. Agog oŋ gane fufeig palu ya. Gamu maŋ fidian Anut malan lo mumado da. Ak niŋen o Tubun en ru dugon rupaiama maloŋ o ibol man, ubol dop maloŋ o tinima migane da.” ");
INSERT INTO tbc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Agog Pita iŋsan ŋiŋeŋ fun iganeg ibol, “Gamu gug ŋaloŋ la ya. Rumok, Anut san kagin panek tamol fidian lo man naon kisaek mi a. ");
INSERT INTO tbc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Enti a Anut niŋen o imat dugo, iŋsan ilobol fom imado itor dak, gidad naon tinin sen ak an fidian iŋal a. ");
INSERT INTO tbc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bilaluŋ uyan ak Anut maŋ Isrel tamolpein ipanama yan aloŋ la ya. Bilaluŋ an man iŋ Jesus Kristus ipilianig, tinin log id Anut da maror tumado da. Ago dugo Jesus iŋ tamolpein fidian sad Tubun a. ");
INSERT INTO tbc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aŋ kulob Isrel tan lo ilasa yan aloŋ a. Jon suguek iganeg itout go, Galili na mel an fun ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jesus Nasaret tamol Anut ipilianig, iŋ fo Urgun dabai da iganeg idu yan aŋ aloŋ a. Iŋ panu panu itor dugo binawek igane dugo, talpein enti ta ur saian sad gurman paen na dumado dan ikubuniai se ya. Man dugo, Anut iŋ da dumado na ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Iŋ binawek urat Juda sad tan lo, agod Jerusalem na dam igane se yan maŋ malama lo mile ya. Agog aigim fo dibalig dufuni imat a. ");
INSERT INTO tbc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gug nal utol itout an, Anut mateŋ lo ifufunig kumaen imasag, maŋ malama lo ilasag mile ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tamolpein fidian ta dile na ya. Anut maŋ mitep fun mufulale san ipilianama yan mi mile ya. Maŋ nek kumaen imasa yan iŋ da mani maluk na ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Agog Jesus sen ru dabai nam irupaiamag iŋsan ru tamolpein naod na mufulale wa, ago gug idinamag mau a. Maŋ tamolpein murupidaip, iŋsen man tamol a tamolpein dumat la yan, agod a dumado dan dam, iŋsad bitinaek tamol imado dak ago murupidaip duloŋ an ru kagin irupaiama ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Profet fidian iŋ niŋen o igo dubol ilasa, ‘Tamolpein a fidian iŋ o ilod rumok dan, iŋanen yaŋan lo Anut iŋsad aupasek ipare idu pidinai a.’” ");
INSERT INTO tbc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Saen Pita iŋiŋeŋ dugo, awan fom tamolpein a ru duloŋ dan Anut iŋanen Urgun iwali idug fidian diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ilo rumok adi a tini suŋulon tutek san muluŋ lo dudu yan Jopa na Pita luan disag dupalu yan, durut saian geig a. Man dugo, ilo panek kawan ak oŋ Anut iŋanen Awan Urgun tamolpein Juda tia yan dam ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ata wo? Muroun ru funfun lo Anut yaŋan diabisa dugo duloŋ se ya. Ago dugug Pita imasag ibol, ");
INSERT INTO tbc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tamolpein en id Urgun tiŋane ago mi iŋ dam diŋane ya. An niŋen o, dugo, suguek diŋane an niŋen o talpein ta yabituanai san niŋen ka ru ibol ak i?” ");
INSERT INTO tbc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Agog Pita tamolpein an Jesus Kristus yaŋan lo suguek diŋane wo ru dabai nam irupidai a. Agog nal aenta iŋ dida dumado wo dusumiani tag atna dida dumado ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tamolpein Juda tia yan Anut san ru diŋane yan san ru, aposel adi iŋ ilo rumok adi Judea na dumado yan dam irupidai duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ago yak niŋen o saen Pita Jerusalem na ipalu man, Juda ilo rumok adi tinid suŋulon dutute an Pita ai dupanig ");
INSERT INTO tbc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","dupei, “Oŋ tamolpein tinid suŋulon ta dutute na yan dida atumanig, anaŋ dam ani a.” ");
INSERT INTO tbc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ago tag Pita malan ŋutun ile yak san ru ibol idu, ");
INSERT INTO tbc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nal ta Jopa na ŋugudani dugo, malag ŋutun en ŋile ya. Keit lo mel ta yamel oŋ gigin iwoiwo ate mi diabi dugug, duyuweg, naog na mok idu ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Yamel an fo man mudan naon funfun. Bor, mot, agod anakanak naon funfun dien a. ");
INSERT INTO tbc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Agog awan ta irupaiag go ibol, ‘Pita, masap, melmel an ufu idup wani.’” ");
INSERT INTO tbc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ago tag ŋai ŋabol, ‘Tubun en, tia geig. Mel dugon Juda sad kagin lo nun man ŋai gubak mi ta mok ŋani na ya.’” ");
INSERT INTO tbc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ago dugo awan keit lo yan fon ibol, ‘Mel dugon Anut ikok ibol dak, oŋ waliŋ ganep, nun ta ubol na wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mel naon kisaek an mi ilasa utol gug, fidian mi imul keit lo isida yau a.” ");
INSERT INTO tbc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ago ibol gug tamol utol Sisaria nag Konilias ŋaisag na idinaig dupalu yan ab ŋai lo ŋumado yan san awan te dutur a. ");
INSERT INTO tbc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Urgun ŋai ilog weiwei ŋamoip, ririan iŋ dida mau wo ibol a. Ago tag Jopa na ilo rumok tamol 6 luag disag dida Sisaria na mau a. Agog fidian Konilias san ab lo miladu ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Agog Konilias irupaiamag Anut san eŋel iŋsiganen ab lo ilasag iŋ da durupei an san ru ibol dugo maloŋ a. Eŋel an irupeig igo ibol, ‘Talpein ta dinaip Jopa na diaup, tamol yaŋan Saimon Pita niŋen o dusumiai. ");
INSERT INTO tbc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tamol a bilaluŋ irupaio wan lo oŋ agod oŋane samun fidian dam patu pasek diŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ŋai fun ŋiganeg ru ŋurupidai man, nek ibol fun mok lo Awan Urgun id tinid fo idug tiŋane yak igo woŋ, ago mi iŋ tinid fo dam idug diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ago dugug Tubun en ru ibol ak ilog isou, ‘Jon you nam suguek ipanaŋ a, gug aŋ Urgun nam suguek aŋane wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Agod an kuai tem taloŋ, Anut id Jesus Kristus ilod lo rumok go Urgun ipanad, ago mi tamolpein Juda tia yan ipidinai a. Ŋai tamol naok dugo yak pe, Anut ata ilon ibol an ŋutute wak i?” ");
INSERT INTO tbc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Saen ru an duloŋ man, iŋ ru taidam ad tia ya, tia, Anut yaŋan diabisa dugo dubol, “An rumok tap, Anut ilon yen man tamolpein Juda tia yan ilod ibileksap, kumaen pempem yen san diŋane wan san dal iŋ o dam ikasap yen da.” ");
INSERT INTO tbc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Saen Stiven imat an mala suek tubun kasik ilasag, ilo rumok adi dufufurak go aenkadi Saipras na, aenkadi Fonisia na, aenkadi Antiok na, diau dugo iŋ Juda tamolpein mi Jesus san ru durupidai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ak man Saipras iŋ Sairini da sad ilo rumok tamol aenkadi diaug, Antiok na tamolpein Juda tia yan Jesus Tubun en san ru dufulale dugo duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tubun en san dabai iŋ lo yen ak niŋen o tamolpein wei kasik ilod dibilisag, Tubun en ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ru an yaug Jerusalem na midaeŋ duloŋ tag Barnabas didinig, Antiok na yau a. ");
INSERT INTO tbc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Saen Antiok na ilasag Anut san ilo panek kulob funfun midaeŋ an lo igane dan ileg, ilon tubun mi uyanan a. Ago tag tan suek ru irupidai, “Pempem Tubun en awan kagin apani dop, ta mok abisei na wa. Gidad, muruan saian ak gup ilom tinim fidian iŋ apani wa.” ");
INSERT INTO tbc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas iŋ tamol uyanan mok. Iŋ ilon Urgun agod ilo rumok iŋanefuteg an lo iŋsan urat lo tamolpein wei mi ilod ibileksag Tubun en san na diaug iŋanen tamolpein dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Agog Barnabas Tarsus na Sol abaŋan yabi wo yau a. ");
INSERT INTO tbc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Saen iŋ Sol ile man, iŋaneg ida Antiok na dumul a. Anaŋar kisaek midaeŋ an lo tamolpein doup tubun dida dutumani dugo maŋau dipiteŋanai se ya. Antiok na ilo rumok adi yaŋak Kris an malmalan mok diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Saen an lo Tubun en san profet aenkadi Jerusalem dibiseig Antiok na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Profet ta yaŋan Agabas luluŋad lo imasag, mitep tan fidian lo kadag tubun idu wak niŋen Urgun ikubiai pani dugo ibol a. (Murnag Klodias Rom sad Kaisa imado dugo Agabas awan aban an nuŋon ilasa ya.) ");
INSERT INTO tbc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","An lo man ilo rumok adi iŋaned turad Judea na yan dubunawai o dubol a. ");
INSERT INTO tbc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Agog iŋaned filiad iri panim moni diganeg Barnabas Sol da moni dupidinaig disini diaug Jerusalem na ubou san gurman banid lo digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Saen nek an lo mi Herod fun iganeg midaeŋ ilon lo tamolpein malad isue. ");
INSERT INTO tbc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iŋ ibol dugo Jon tein Jems sabiri nam dufuni imat a. ");
INSERT INTO tbc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Saen ago igane dugo Juda tamolpein ilod uyanan ago ile tag, afon ibol dugo Pita diabi a. (Juda sad soubul gun bret yis an tia ak diani san saen lo Pita diabi.) ");
INSERT INTO tbc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pita diabig, subanek ab lo diganeg, yu tamol adi tawaŋ an dumado se ya. Yu tamol malan iwoiwo, go malan kisaek kisaek san tamol dam iwoiwo. Malan ta tawaŋ an dumado nap, diau dop, fon malan ta dupalu se ya. Herod iŋ Juda sad nal gun tubun ak Pasova dubol dan saen an itout gup, Herod Pita malak malak lo kot ipani wo ilon ago isou a. ");
INSERT INTO tbc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita subanek ab lo imado dugo, Kris midaeŋ Anut Pita ibinawi wo gadiŋ dabai kasik digane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tidom a san salso lo Herod Pita kot ipani san saen ilasa ya. Pita banin neinta lo sein dususeg diaug, yu tamol banin aenta ida dususe kisaek a. Banin aenta man diŋaneg sein nam yu tamol neinta dususe ago mi digane ya. Ago dugo iŋsen man titiŋaem yen. Yu tamol aenkadi man subanek ab san dalawan te tawaŋ dutur go dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Aria tidom lak geig Tubun en san eŋel ante itur dugo, san lilaman subanek ab an ilon igane ilalaŋ a. Agog eŋel Pita giraŋen ifunig malan ipuk gug irupei, “Masa kisaek oŋ!” Eŋel ago ibol dugo, Pita banin ŋudun te sein dien an sed ditapas dudu ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ago dugo eŋel Pita irupei, “Oŋsa kulos sendal dam diri.” Pita nek ago mi igane dugo eŋel ibol, “Oŋane madid san kulos ŋanep se ibuluwo gup, ŋieg aban uri.” ");
INSERT INTO tbc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Agog Pita eŋel an ŋien aban irig subanek ab san galuŋ dibiseig kuai te dilasa ya. Mel e ilasa den Pita san ilo sou lo man mel nuŋon tia ya, iŋ malan ŋutun mi ile dak ago ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ago dugo Pita eŋel da dupalug, yu gurman tawaŋ aben malan te itur dan diriŋani a. Agog tinin te itur an san aben dam diriŋani a. Wadan geig subanek ab san dalawan tubun ain nam digane yan fun na dilasa ya. Dalawan sen ilon nam itapas, agog patun fo dilasa ya. Agog taun an san dal an dirig kitek taida dilag asau gug eŋel Pita ibisei a. ");
INSERT INTO tbc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ago dugo Pita ilon ipasti gug kankan iŋaneg ibol. “Gamu gug ŋaloŋ ak, mel ŋai lo ilasa man rumok a. Tubun en iŋsan eŋel idinig, ipalug ŋai ibinawag go Herod tuon lo, agod Juda sad daoŋ panek ilod isou dan lo ipasag a.” ");
INSERT INTO tbc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mel ilasa yan kankan an kitek igane gug, Jon yaŋan neinta Mak dubol dan tinan Maria san ab lo yau a. Ab an lo Kris tamolpein wei kasik dususag dugudani dugo dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita dalawan ititi dugo, urat pein ta yaŋan Roda, talpein dalawan ititi dak naon ile wo ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Saen Pita kulagun iloŋ go ilon tubun mok uyanan. Agog dalawan ipasi san ilon iŋaoŋ. Pein an imaspalu yaug, tamolpein dugudanid dumado dan naod na Pita ab patun fo itur dan niŋen o ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ak man iŋ ilod lo ta rumok na tag dupei, “Oŋ nag ŋiŋeo ifuno boi.” Ago bo man pein an kawan iŋiŋeŋ oŋ tag dubol, “An man Pita san mitilaen boi.” ");
INSERT INTO tbc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Saen diŋiŋeŋ se yan Pita dalawan nek ago mi ititi se ya. Ago yau na gug dalawan dupasi. Agog saen Pita dile man durut saian geig a. ");
INSERT INTO tbc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Agog leiŋ tubun mi digane tag, awad itau wo banin nam toutou igane ya. Awad itau dugug, Tubun en iŋ subanek ab lo iŋaneg ilasa yan fun ifulale dugo duloŋ a. Agog irupidai, “Ru en Jems iŋ ilo rumok adi dida arupidai duloŋ.” Ago ibol go itout an ibisawaig, aben sen ta lo yau a. ");
INSERT INTO tbc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Salso idug yu gurman a tawaŋ dutur an luluŋad lo leiŋ tubun geig ak ilasa ya. Pita dugo yau an ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod ibol dugo abaŋan diabi ak gug tinin kitek dileti man tia geig a. Ago tag iŋ yu tamol adi tawaŋ dutur se yan isumianai uyanan. Ak man tia tag, ibol dugo yu tamol an dufu dumat a. Agog Herod Judea ibiseig, Sisaria na yaug, atna kitek imado ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod Taia Saidon da sad tamolpein niŋedi wo tiŋaen saian. Ago tag Taia Saidon da sad tamolpein dutumanig Herod dilep dusumiani wo diau a. Malan malan mok iŋ Blastus, Herod san ab san titianek, ilon diŋane wo diau a. Agop iŋ naod iŋanep Herod isumiani san a. Ago diganeg, iŋ dida ilod kisaek. An lo diaug, Herod iŋ dida maror dumado wo dusumiani a. Man dugo, iŋ Herod san tan lo anaŋ diŋane yan lo iŋsan binawek o tinid digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Blastas Herod san na yaug, nal igane wak niŋen isumiani. Agog Herod nal igane yak fom iŋsiganen kiŋ kulos iganeg, kiŋ san kalik fufo imasig, tamolpein ru irupidai a. ");
INSERT INTO tbc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tamolpein iŋsan ru duloŋ dugo disasaig dubol, “En tamol san kulagun tia ya. Tia, en tubud ta iŋiŋeŋ da.” ");
INSERT INTO tbc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Agog gamu nam Tubun en san eŋel ta Herod ifunig ibili idu ya. Man dugo, iŋ tamol mi ibol ak imoi. Tia, awan itaug Anut yaŋan yabisa san imoi a. Agog kulilid iŋsan tiŋaen dianig imat a. ");
INSERT INTO tbc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Gug Anut san ru italbisig, ifurak go aben fidian lo yau a. ");
INSERT INTO tbc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas Sol da Jerusalem na ubou san gurman banid lo moni digane yan san urat digane itout gug, dumul go Antiok na diau a. Saen dumul an Jon yaŋan neinta Mak dubol dan diŋaneg dida diau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok na midaeŋ ilon lo profet adi, agod girek maŋau adi dumado dan yaŋadi igo ya: Barnabas, Simion a yaŋan neinta Niger dubol da. Lusias iŋ Sairini tamol. Manain man iŋ Herod da dilasag ditalbusi kisaek. Agod Sol sen dam mi a. ");
INSERT INTO tbc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Saen Tubun en yaŋan lo anaŋ geg diganeg dugudani dugo Urgun irupidai, “Ŋai urat ta amag da yak niŋen Sol Barnabas da apilianai apanag.” ");
INSERT INTO tbc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anaŋ geg diganeg dugudani na yan itout gug Barnabas iŋ Sol da gurmad fo banid diganeg bilaluŋ urat banid lo digane gug didinaig diau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas iŋ Sol da Urgun idinaig Selusia na diaug wog diŋaneg Saipras nui lo diau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Atna taun ta yaŋan Salamis dubol dak lo Juda sad ubou ab fidian lo Anut san ru dufulale se ya. Jon yaŋan neinta Mak, iŋsad urat an lo ibinawai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nui an lo panu panu atem ru dufulale dugo diau nag taun Pefos na dilasa ya. Atna Juda tamol ta yaŋan Bar-Jisas, iŋ yaŋan neinta Grik lo Elimas dubol dan, imado se ya. Iŋ kiai tamol, agod profet sewak dam mi a. ");
INSERT INTO tbc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tamol an iŋ nui an san kiap da nug turan. Kiap an yaŋan Segius Polas, iŋ tamol kankan anda ya. Tamol gurman an Barnabas iŋ Sol da Anut san ru dufulale pani dop iloŋ o imat tag igiaig iŋsan na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ak man kiai tamol Elimas iŋ an imoi. (Iŋ yaŋan fun man: kiai tamol.) Iŋ tamol gurman Barnabas iŋ Sol da sad ru iloŋ san imoi o igane dugo, Jesus o ilon ta rumok na yan ilon iŋane wo maeg igane ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Agog Sol yaŋan neinta Pol, Urgun buben iŋanefuteg malan ti ibol go Elimas ileg, irupei, ");
INSERT INTO tbc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Oŋ Satan san nanun, agod melmel dugon uyanan ak sad ager! Oŋ tini man ru sewak agod sewak kagin naon fidian iŋanefute ya. Oŋ pempem Tubun en san ru rumok an bilisap sewak oŋ gane da. ");
INSERT INTO tbc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gamu Tubun en san tuon oŋ tini fo iganep ule wa. Oŋ mala itaup ad san lilaman ta ule na wa. Agop oŋ ago mado dop saen ipano yak fo gup abaŋ fon ule wa.” Gamu na mi Elimas kakao malan yafutanig, malan tidom tubun go tamol ta ile nag banin te yabi wo idab idab itor se ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tamol gurman mel ilasa yan ileg, Tubun en ilon lo rumok. Man dugo, Tubun en san ru iloŋ go buben imasag irut saian a. ");
INSERT INTO tbc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol turan dida Pafos nag diyawaig, Pamfilia distrik na taun ta yaŋan Pega ante dilasa ya. Nek ate gug Jon Mak ibisawaig imul Jerusalem na yau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pega dubuseig Pisidia na taun ta yaŋan Antiok na diau a. Agog saen Sabat nal idug Juda sad ubou ab ta lo diladu ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ante talpein ta malmalan ru kitek Moses san kubiaeŋ isutig tinin te profet adi sad girek ta dusuti a. An itout gug ubou gurman adi Pol iŋ Barnabas da sad na ru digane yaug dubol, “Aŋ teik adi, aŋ ru amam da dop man, tamolpein tan suek ru kitek arupidai o iloma ibol da.” ");
INSERT INTO tbc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ago tag Pol imasag, tamolpein malad lo banin yabisag, ru fun iganeg irupidai, “Isrel tamolpein, agod aŋ aenkadi da Anut yaŋan abisa dan, kududom apanag! ");
INSERT INTO tbc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isrel tamolpein sad Anut, id tubud baged ipilianai go, saen Igipta na subanek lo dumado dugo, iganeg malad kubulad wei mok igileg dilasa ya, ago dugo filiad tubun mi diŋane ya. Anut iŋsiganen dabai tutubun ak lo iŋal go Igipta dibiseig dilasag diau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Agog anaŋar 40 tan kawan ak lo diau dugo, iŋsad kagin sisaiak ile yak bo man sen yabituani dugo bu ta ipidinai na ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kenan tan lo tamolpein malan 7 dumado yan iratitalaig tan an iŋaneg iŋanen tamolpein ipidinaig an taman dumado ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Agog anaŋar 450 itout dugo tamol tulek gurman ipidinai a. Tulek tamol adi an paed na mi dumado dugo, yaug, profet Samuel san saen lo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Agog Samuel iŋ kiŋ ta ipilianip ipidinai o dusumiani a. Ago tag Anut Samuel lo tamol ta Benjamin san gugoi lo Kis nanun yaŋan Sol dubol dan, ipidinai a. Agog anaŋar 40 iŋaned kiŋ imado ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Agog Anut Sol ipasi yau dugo iŋanen aben lo Dawid kiŋ igane ya. Anut Dawid niŋen o igo ibol, ‘Ŋai Dawid, Jesi nanun iŋanen nao lalek ŋukubiani uyanan a, iŋanen buben nek ibol ŋaisag oŋ, an lo ŋai ilog ibol dak ago mi igane wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Wagam mi mok Anut idsad tubud baged promis ipidinai ak iŋaned malad kubuladi lo patu pasek tamol ta ilasa wa. An lo gamu iŋanen promis ru an nuŋon ilasa ya, Anut Jesus idinig Isrel sad patu pasek tamol ilasa wo ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesus urat gamugo fun igane dugo, Jon Isrel tamolpein naod na ru igo irupidaig ibol, ‘Aŋanem aupasek patum apanip, ilom abileksap, apalup suguek aŋane.’ ");
INSERT INTO tbc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Saen Jon iŋanen urat wadan ifutani wo sumeik dugo isumianai, ‘Aŋ ŋai enti abol dak i? Ŋai man tamol a malan agane dan tia ya. Tia, tamol an ŋai ŋieg aban fo ipalu da. Ŋai iŋsan sendal san kam ŋupasi san ta idaisuda na ya.’ ");
INSERT INTO tbc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“O teig muroug, Abraham malan kubulan, agod aŋ tamolpein aenta Anut yaŋan abisa dan kudom agure. Patu pasek san ru man Anut idsad na iganeg ipalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tamolpein Jerusalem na dumado dan, iŋaned gurman dida Jesus iŋ patu pasek tamol an ta dile duloŋ na ya. An bo saen Jesus daoŋ dupani wo dubol man, iŋ profet sad awad aban Sabat nal fidian lo dusuti dan nuŋon diganeg ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iŋ bo san muruan ta dile nag lo dufuni imat san tia yak gug, Pailat Jesus ifuni imat o dusumiani a. ");
INSERT INTO tbc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Agog saen ru Anut san buk lo melmel a iŋ niŋen o ibol an fidian digane itout man, aigim fo yak dupasig gib lo digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ak gug Anut Jesus mateŋ lo ifufunig afon kumaen imasa da ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Agog nal wei kasik Jesus tamolpein Galili nag ŋien fo Jerusalem na dupalu yan naod na ilasa dugo dile ya. Tamolpein an gamu Isrel tamolpein naod na Jesus rumok dile yan niŋen dubol ilasa dugo iŋsan ru durupidai duloŋ da. ");
INSERT INTO tbc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Promis a Anut idsad tubud baged ipidinai an nuŋon ilasa ya, an niŋen o maŋ gamu bilaluŋ an misini mupalug murupaiaŋ dugo aloŋ da. ");
INSERT INTO tbc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Promis an san nuŋon ta dile na ya, tia, Anut iganeg Jesus mateŋ lo imasag kumaen imado dan lo mi, id iŋaned malad kubuladi an niŋed o mi promis ru an nuŋon ilasa dugo tile ya. Ru ta Isrel sad bar yabek namba uraru lo yan igo ibol, ‘Oŋ ŋaineg Nanug mok; Gamu saen en ŋai oŋ Tama ŋumado wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Agog Anut mateŋ lo ifufunip, fon kumaen imasap, fon imat pe igan san tia yak niŋen ru en ibol, ‘Ŋai aŋ bar gun ak ŋupanaŋ a. Nek imug ŋai Dawid promis ru ŋupani ak ago mi ŋupano mok a.’ ");
INSERT INTO tbc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ago man bar yabek sen ak san boi ta lo dam igo ibol, ‘Oŋ oŋane Tamol Gun ak ulefuni dop gib lo igan san tia ya.’ ");
INSERT INTO tbc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawid iŋsan saen san tamolpein luluŋad lo Anut ilon yen ak fom urat igane se ya, agog saen iŋsan urat igane itout man, imat a. Agog iŋanen bagen muroun siŋired na disareg, iŋsan sisanun igan a. ");
INSERT INTO tbc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ak gug tamol a Anut mateŋ lo ifufunig kumaen imasa yan, tan ilon lo igan man tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Teig taog, ŋai ilog ibol dak aŋ fidian mel en aloŋ uyanan a. Jesus nek emaiak lo Anut ka aŋanem aupasek fidian ipare idu wa, ru amaiak gamu murupaiaŋ dugo aloŋ da. ");
INSERT INTO tbc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Aŋ Moses san kubiaeŋ lo itaot alasa san tia ya. Gug Jesus lo man, talpein iŋ o ilon lo rumok dan Anut malan lo itaot ilasa wa. Melmel a kubiaeŋ mi igane san ta idaisuda na yan, an fidian Jesus mi ka igane wa. ");
INSERT INTO tbc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ago yak niŋen o kagin agane. Profet adi ru dubol an aŋ lo ilasa banau. Iŋ igo dubol, ");
INSERT INTO tbc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Aŋ ru kukok agane dan, ale. Ilom weiwei dop arut pe adeg au. Ata wo? Ŋai kulob ta aŋsam saen lo ŋigane wan niŋen, gidad enti ta mel an niŋen durupaiaŋ an bo man, aŋ pempem ilom lo ta rumok na wa.’” ");
INSERT INTO tbc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Saen Pol Barnabas da Juda sad ubou ab an dubusei dugo, tamolpein Sabat nal naod na yan lop fon dupalup ru naon ago mi ak dubol dop duloŋ o dusumianai a. ");
INSERT INTO tbc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Agog gurman adi tamolpein tumanek dibiseip diau o dubol dugo, Juda tamolpein, iŋ a ta Juda na yak gug Juda sad ubou lo diau dan dam, Pol iŋ Barnabas da ŋied fo diau a. Ago dugo uraru an tamolpein tan suek ru durupidaig dubol, “Aŋ Anut san ilo muŋanek ipanaŋ dan lo atutou yau oŋ a.” ");
INSERT INTO tbc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ubou kisaek yaug Sabat nal idu yan lo tamolpein kitek wei mi geig taun an lo dumado dan, Tubun en san ru duloŋ o dususag dutumani an malan tubun geig a. ");
INSERT INTO tbc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Agog saen Juda adi abaŋ ago dile man, turak tubun mi dususag ru saian geig ak nam ru dugon Pol ibol ilasa dan lo dipirgini se ya. ");
INSERT INTO tbc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ago man Pol iŋ Barnabas da ta dusuksuk nag ru naon igo durupidai, “Anut iŋsan ru malmalan aŋ murupaiaŋ aloŋ o ru kagin irupaiama ya, gug aŋsam leil lo man aŋ ibol tamolpein kumaen pempem yen dan diŋane san ta idaisuda na yak igo woŋ a. Aŋ Anut san ru amoi an niŋen o, maŋ gamu miriŋanaŋ pe Juda tia yak sad na mau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Man dugo, Tubun en sen ru kagin irupaiamag ru en ipanama, ‘Ŋai ŋiginiog oŋ Juda tia yan sad sul mado wa. An lo dop ŋaisag patu pasek sini waup, tamolpein a tan titin wadan fidian lo dumado dan diŋane wa.’” ");
INSERT INTO tbc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Saen tamolpein Juda tia yan ru an duloŋ man, ilod tubun mi uyanan go, iŋ bubed lo Anut san ru lak na geig disini a. Agod tamolpein a Anut gubak mi kumaen pempem san diŋane wo ipilianai amaiak fidian ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tubun en san ru taun an san panu susumeik an lo ifufurak go yau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ak man Juda tamolpein dumasag, taun an san tamol gurman ated dusue ya. Iŋ pein yaŋad anda yak Anut ubou an dile dan dam ated dusue ya. An lo Pol iŋ Barnabas da muruan iŋ madai da dupidinaig dukudaig, aben an dibisei a. ");
INSERT INTO tbc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tamolpein an Anut san kagin panek ru duloŋ o dumoi an niŋen o, aposel adi ŋied fo gufgaf an dipilti idug, Aikoniam na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antiok na ilo rumok adi yousai agod Urgun da tinid iŋanefuteg dumado ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kagin naon kisaek an ago mi Aikoniam na ilasa ya. Pol iŋ Barnabas da Juda ubou ab lo ru dufulale uyanan mok an lo Juda adi agod Juda tia yan dam wei mi ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Gug Juda aenta Anut san ru duloŋ o dumoi, agog tamolpein Juda tia yan ated dusueg, iŋsad kankan dukubulig an lo Pol iŋ Barnabas da dil saiadi. ");
INSERT INTO tbc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Gug Pol iŋ Barnabas da atna saen kitek milaen mi dumado ya. Iŋ ta direr na ya, tia, Tubun en san ru iŋanen ilo panek san an dubol ilasa dugo, Tubun en iŋsen dabai a ipidinai an lo tamolpein ikubiai dileg iŋanen ru an rumok a. Man dugo, aposel uraru an iŋsan dabai nek amaiak lo kulob girager funfun digane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Taun an san tamolpein ditarpaleg malan uraru. Aenkadi Juda dida dutur, go aenkadi man Pol iŋ Barnabas dida dutur a. ");
INSERT INTO tbc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tamolpein Juda tia an iŋaned gurman dida, agod a Juda yan iŋaned gurman dam dida Pol iŋ Barnabas da daoŋ dipidinaip pat nam dufup dumat o palaŋ ad dumari se ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Saen aposel ru an duloŋ tag, dusol go distrik Likonia na taun uraru Listra iŋ Derbe da, agod panu susumeik an lo dam diau a. ");
INSERT INTO tbc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ante Jesus san bilaluŋ uyan an san fun dufulale se ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra na tamol ta imado. Iŋ tinan tiŋaen lo mi ŋien imat, agod itor san tia ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Saen Pol ru ifulale dan iŋ dam doup luluŋad lo imado dugo kududon igure se ya. Pol tamol an malan ti ibol go, ilon lo rumok ile yak niŋen o iloŋ ak, Anut tamol an ka ibinawi wa. ");
INSERT INTO tbc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ago tag Pol awan tubun mi irupei, “Masap! Itaot utur!” Agog tamol an gamu nam imasag itur go itor ila iso se ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Saen tamolpein Pol ago igane yan dile man, iŋsiganed Likonia muroun ru lo duwagiŋ go dubol, “Tubud adi dibilisag, tamol oŋ go idsad na dupalu ya.” ");
INSERT INTO tbc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas man Seus dubol go Pol man Hemis dubol. Ata wo? Pol man ru bilabal san tamol malan te ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Seus san tempel taun an san ar patun fo yen da. Seus san pris makau tamol ak iŋal go mor dam isinig, tan san dalawan iŋ tamolpein dida aposel yai digane pidinai o ante dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Saen Pol iŋ Barnabas da tamolpein kulob dugdugo digane dan duloŋ ak man, iŋ kagin an dumoi tag iŋsed tinid fo biouŋ an dirasisire idug, dumaspalug, doup luluŋad lo diladug disasaig dubol, ");
INSERT INTO tbc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Aŋ ata wo igo agane dak i? Maŋ dam tamol nek aŋ igo mi a. Maŋ bilaluŋ uyan ak ta Jesus niŋen o misini mupalu da. Maŋsama ru an aloŋ dop kagin sewak agane dan patum apanip, Anut kumaen imado dan mi ubou an ale wa. Iŋ keit, tan, beig igane ya. Agod melmel fidian tan fo na, agod beig ilon lo yan fidian idiri a. ");
INSERT INTO tbc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Imug mi man iŋ tamolpein yilfu dugo iŋaned ilobol mi digane na ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Gug iŋ pempem mel sisiŋaok igane ilasa na yan lo iŋsen fun ikubiai ale se ya. Iŋ ui iganep, keit lop idu da. Nal fom anaŋ iganep ilasa da. Anaŋ ipanaŋ dugo ilo uyan dam ipanaŋ da.” ");
INSERT INTO tbc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pol iŋ Barnabas da ru ago dubol gug tamolpein man yai digane mok o yaes ifu da, an niŋen o diabituanai o muruan geig a. ");
INSERT INTO tbc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Agog Juda aenkadi Antiok Pisidia provins atna yan, Aikoniam na yan dam dupalug, doup ilod diŋaneg, Pol pat nam dufuni a. Agog diraeg, taun san ar patun fo dilasag, dibal yau a, agog diau a. Ilod lo man imat ak dubol a. ");
INSERT INTO tbc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Gug saen ilo rumok adi dupalug fun na dutur dulubani dugo, Pol imasag fon imul taun ilon lo iladu ya. Dien dumasag, tidom lom mi iŋ Barnabas da Listra dibiseig Derbe na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol iŋ Barnabas da Derbe na Jesus san bilaluŋ uyan ak dubol ilasag, tamolpein wei mi ilod dibilisag, Jesus san megeloum dilasa ya. Agog uraru an dumul go, Listra nag, Aikoniam nag, Antiok o Pisidia na yan lo dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Atna ilo rumok adi iŋaned ilo rumok diabi sakar o tan suek ru durupidai, agog ru en dam durupidai, “Id muruan tubun mi tisini gup, Anut san kagin panek lo tiladu wa.” ");
INSERT INTO tbc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Midaeŋ kisaek kisaek lo, tamol a Tubun en niŋen o ilodi rumok dan luluŋad lo Pol iŋ Barnabas da matu aenkadi dipilianai pidinai a. Agog niŋed dugudani wo anaŋ geg diganeg, dugudanig, Tubun en banin lo didirai diau a. ");
INSERT INTO tbc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Agog dibisawaig Pisidia provins na ditilianig itout go Pamfilia provins na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Taun Perga na Anut san ru dufulale itout go loŋ na diaug taun Atalia na dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Murnag wog diŋaneg Antiok a provins Siria lo yan ante dumul diau a. Aben ante gubak mi Anut san urat banid lo digane dugo iŋsan ilo panek paen na urat digane wo idiraig dutor nag, gamu wadan dufutani a. ");
INSERT INTO tbc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiok na dilasag ilo rumok adi dutumanaig, Anut urat iŋ lo igane na yan san ru durupidaig duloŋ a. Agog Anut tamolpein Juda tia yan ilod lo rumok san dal ipasi an dam dubol duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Agog saen milaen mi ante ilo rumok adi dida dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tamol aenkadi Judea na yak Antiok na diaug, fun diganeg ilo rumok adi dipiteŋanai dugo dubol, “Aŋ Moses san kubiaeŋ ibol dak fo mi tinim suŋulon atute wa. Tia dop, Anut aŋ patum ta ipasi na wa.” ");
INSERT INTO tbc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol iŋ Barnabas da ru an niŋen o dida tubun mi nug diabi se ya. Ago tag ilo rumok adi Antiok na yan ru kagin igo durupidaig dubol, “Pol Barnabas da, aenta dam dida diaup, Jerusalem na aposel iŋ matu gurman adi dida muruan an niŋen o dukubiai a.” ");
INSERT INTO tbc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Agog midaeŋ didinaig, Jerusalem na diau. Fonisia iŋ Sameria da sad dal im tureŋ diabi dugo, tamolpein Juda tia yan ilod lo rumok go ilod dibilisa yan san sae dusue se ya. Ilo rumok adi fidian ru duloŋ an ilod tubun mi uyanan a. ");
INSERT INTO tbc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Saen Jerusalem na dilasa yan aposel adi, matu adi, agod midaeŋ fidian dupalug duyuŋanai se ya. Agog Anut iŋ lo dugo igane na yan naod na dubol ilasa dugo duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Gug ilo rumok aenta iŋ dida ilod ta kisaek na ya. Tamol an imug man iŋ Farisi a. Iŋ ilo rumok adi luluŋad lo malan kisaek dumado na ya. Tamol emaiak dumasag igo dubol, “Arupidai duloŋ pe, tinid suŋulon dutute dop Moses san kubiaeŋ ibol dan ago mi duri dupani. Kagin an ta diriŋani na wa.” ");
INSERT INTO tbc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ago tag aposel adi iŋ matu dida dutumanig muruan an niŋen o diŋiŋeŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ŋiŋeŋ diganeg yaug milaen dugo Pita imasag ibol, “Teig muroug, aŋ aloŋ a. Malan malan mok Anut aŋ luluŋam lo ŋai ipilianag a. Agop tamolpein Juda tia yan ŋai awag lo Jesus san bilaluŋ uyanan an duloŋ pe, ilod dibilisap, ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ago dugo Anut a idsad bubed iloŋ dan iŋsan rumok Juda tia yak lo dal igo ikubiai dugo mile ya, id gubak mi Urgun ipanad ago mi tamolpein Juda tia yan dam ipidinai a. ");
INSERT INTO tbc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Id Juda, agod a Juda tia yan iŋ malan lo id sensen man tia ya. Iŋ o ilod rumok an lo bubed ifulanaig ikok dilasag nek id ago mi a. ");
INSERT INTO tbc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ago yak niŋen o aŋ ata wo dal en lo Anut naon akubiani wo agane dak i? Aŋ gamu ilo rumok adi Moses san kubiaeŋ burod fo agane isuda wo agane da. Gug wagam id baged muroud, agod gamu idsed dam muruan an tisini san ta idaisuda na ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ak man id igo ilod lo rumok, nek ibol Tubun en san ilo panek an lo patud ipasi wak igo woŋ, iŋ dam ago mi patu pasek diŋane wa.” ");
INSERT INTO tbc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Doup tumanek lo yan fidian awad itaug dumado dugo Pol iŋ Barnabas da tamolpein Juda tia yan luluŋad lo Anut iŋ lo kulob girager dugo igane na yan niŋen durupidaig duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iŋaned ru dubol itout man Jems imasag ibol, “Teig taog, kududom agure! ");
INSERT INTO tbc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Anut imug mi Juda tia yan sad na ilasag luluŋad lo tamolpein aenta iŋal pe iŋanen yaŋan disini wo sad na yau a, an san ru Saimon irupaiad la ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Agod ru a Saimon ibol an profet adi sad awad aban da awad dutumani kisaek a. Iŋsad ru igo ya, ");
INSERT INTO tbc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Tubun en ibol, mel en itout gup ŋai ŋamul da wa. Agop Dawid san ab yau idu yan fon ŋabisa da wa. Ab saian an ŋabisap, afon ŋususep uyan ilasa da wa. ");
INSERT INTO tbc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ago yak niŋen o tamolpein aenta fidian Tubun en abaŋan diabi wa. Agod Juda tia yan fidian a ŋai yaŋag tinid fo yen dan dam ago digane wa.’ ");
INSERT INTO tbc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tubun en mel an fidian, fun log ipalug gamu kuai tem tamolpein duloŋ san ak idirig, ago ibol ilasa ya.” ");
INSERT INTO tbc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Agog Jems fon ibol, “Ŋaisiganeg kankan lo yak ŋabol da. Id tamolpein Juda tia yan dibilisap naod Anut dupani dop muruan ta tupidinai na wa. ");
INSERT INTO tbc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tia, girek ta tigirep ru igo turupidai a. Iŋ mel dugon tubud sewak yai digane pani dan diani dop lo sed ilod nun dupani wo dumoi a. Jeit kagin ta digane na wa. Mel a buron dususe gug tinin ilon lo san dar yen dan mudan ta diani na wa. Agod san dar dam ta diani na wa. ");
INSERT INTO tbc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Id ru kagin taida turupidai san urat tia ya. Man dugo, wagam id baged sad saen log ipalug gamu, Moses san kubiaeŋ Sabat nal anen anen Juda sad ubou ab fidian lo dusuti da. Ago dugo iŋsan ru panu fidian lo dufulale da.” ");
INSERT INTO tbc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Agog aposel, agod matu adi dida midaeŋ fidian dutumanaig, awad kisaek gug tamol ta dipilianaip Pol iŋ Barnabas da dida Antiok na diau wo dubol a. Agog Sailas, iŋ Judas yaŋan neinta Basabas dubol dan dipilianai a. Tamol uraru an ilo rumok adi luluŋad lo yaŋad ad da ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Girek a digireg disini diau o dupidinai an san ru igo ibol: “Aŋ ilo rumok Juda tia yan, Antiok na Siria na agod Silisia na amado dan, maŋ aŋanem teim taom, aposel agod matu adi dam maŋanema ilo uyan aŋsam na migane ipalu da. ");
INSERT INTO tbc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Maŋ maloŋ ak maŋsama tamol aenkadi aŋsam na diaug ru dubol an lo aŋ ilo wei dupanaŋ dugo aŋanem kankan dukubuli a. Maŋ iŋ ago digane wo ru kagin ta murupidai na ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ago tag maŋ fidian mutumanig iloma kisaek go tamol aenkadi mipilianaig midinaig aŋsam na dupalu da. Idaned turad mok Barnabas iŋ Pol da dida dupalu da. ");
INSERT INTO tbc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Tamol uraru an idsad Tubun ak Jesus Kristus yaŋan disini wo saen wei mi sed tinid dibisei se ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aria, maŋ Judas iŋ Sailas da mipilianaig dida dupalu wa. Tamol uraru en ru a migire yan sed awad nam durupaiaŋ dop aloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Maŋsama ilo sou lo, agod Urgun san ilo sou lo dam, mel en mi uyanan a. Maŋ iŋ da sisem murupaiaŋ dak, aŋ muruan ta fon kubiaeŋ en subuŋan tinim fo ta migane isuda na wa. Kagin nek en mi agane wa. ");
INSERT INTO tbc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Anaŋ tubud sewak dupani ak ta ani na wa. Dar ani amoi. Mel ta buron dususeg san dar tinin ilon lo yen dan ta ani na wa. Jeit ta agane na wa. Kagin naok ago yan lo tinim apirani tap, nek an agane uyanan a. Nek a.” ");
INSERT INTO tbc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Midaeŋ girek an banid lo diganeg didinaig Antiok na diau a. Antiok na dilasa gug ilo rumok adi fidian dutumanai gug girek an dupidinai a. ");
INSERT INTO tbc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Agog an san ru dusuti a. Dusuti man, san tan suek ru duloŋ dugo yousai tubun mi digane ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas iŋ Sailas da sisem sad teid taodi ru wei mi nam tan suek ru dupidinaig dabai dupidinai a. Man dugo, tamol uraru en dam Anut san profet mi a. ");
INSERT INTO tbc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Antiok na kitek dumado gug ilo rumok adi maror lo mi didinaig dumul go, siganed na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ak man Pol iŋ Barnabas da Antiok na dumado dugo, ante tamol aenkadi wei mi dida Tubun en san ru dufulale dugo tamolpein maŋau dipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Murnag Pol Barnabas irupei, “Id taup, teid taod Kris a panu panu imug taug Tubun en san ru turupidai se yan ate tau a. Iŋ dugo dumado dan teil a.” ");
INSERT INTO tbc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas awok ibol ak gug Jon a yaŋan neinta Mak dubol dan dida diau o ilon ibol a. ");
INSERT INTO tbc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ak man Pol Jon diŋanep ida diau san an ta uyan na yak ago ilo sou igane ya. Man dugo, gubak mi iŋ Pamfilia na urat digane dugo, Jon dida urat digane yau o imoig ibisawaig imul yau a. ");
INSERT INTO tbc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ago man ilod ta kisaek na yan lo ru dabai nam nug aen dutog se ya. An lo sensen diau a. Barnabas Jon yaŋan neinta Mak iŋaneg ida wog diŋaneg Saipras nui na diau a. ");
INSERT INTO tbc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Gug Pol Sailas iŋaneg, ilo rumok adi dutumanig Tubun en san ilo panek lo kagin ipidinai o dugudani gug, urarum didinaig diau a. ");
INSERT INTO tbc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Agog iŋ Siria nag Silisia na midaeŋ fidian dabai dupidinai dugo diau se ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol tureŋ ibateg Derbi na agod Listra na yau a. Atna ilo rumok pinein ta yaŋan Timoti imado se ya. Iŋ tinan Juda. Agod iŋ dam ilo rumok pein ta. Gug taman man iŋ Grik tamol. ");
INSERT INTO tbc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra iŋ Aikoniam da sad ilo rumok adi fidian Timoti dupitiani da. ");
INSERT INTO tbc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol iŋ Timoti iŋanep ida diau o ilon yen tag ibol dugo Timoti tinin suŋulon dutute ya. Man dugo, Juda panu fidian lo dumado dan duloŋ, Timoti taman man iŋ Grik tamol. ");
INSERT INTO tbc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Saen panu fidian lo diau se yan kubiaeŋ aposel adi iŋ matu dida Jerusalem na digane yan ilo rumok adi dupidinaig, kubiaeŋ an mi duri dupani wo dubol a. ");
INSERT INTO tbc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ago yan lo midaeŋ iŋaned ilo rumok dabai dupanig, midaeŋ fidian nal ate mi tubun ilasa se ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Urgun iŋ Esia san tan fidian lo Anut san ru dubol ilasa wo man geg ipidinai a. Ago tag iŋ Frisia na, agod Galesia na mi tureŋ diabi na ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Saen Misia provins san tom fo dilasag Bitinia provins lo diladu wo digane gug Jesus san Ur awok ta ipidinai na ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ago tag Misia na diau oŋ go, Troas na dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Atna tidom lo Pol malan ŋutun lo Masedonia tamol ta itur dugo iwagi dan ileg igo irupei, “Ete Masedonia na palup maŋ binawama.” ");
INSERT INTO tbc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Saen Pol mitilaen an ago ile man, gamu nam maŋ ru kagin irupaiamag Masedonia na mau san abaŋ mukubune ya. Man dugo, mitilaen an maŋ kankan ipanama yak, Anut maŋ atna maup bilaluŋ uyanan an tamolpein sad na mufulale wo igiama ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas na wog miŋaneg tim idudunamag itaot geig Samotres na mau a. Agog maen, mumasag, Niapolis na mau. ");
INSERT INTO tbc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Atnag ŋiema nam maug, Filipai na milasa ya. Masedonia distrik lo Filipai iŋ taun malan te ya. Taun an Rom gabman iŋane ya. Maŋ atna kitek dam mumado ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabat nal lo taun mubiseig, you ta aen te mau. Iloma lo Juda sad gudanek aben ta ate mile wak mabol. Agog mumasig, pein ante dutumani ak Anut san ru murupidai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pein a ru duloŋ na yan luluŋad lo kisaek ta yaŋan Lidia. Iŋ Taiataira pein. Iŋ yamel daran naon lak na geig ak iŋsan na didad da. Pein an iŋ Juda tia yak gug iŋ Anut o ubou ile da. Saen Pol ru ibol dugo Tubun en iganeg buben isofulale dugo iŋanen ru iŋane uyanan go ilon lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Agog Lidia iŋanen ab samun dida fidian suguek diŋane gug isumianama, “Aŋanem ilom lo ŋai akubianag ak Tubun en san ru ŋiganuri dan ilom ago isou tap, apalup ŋaisag ab lo tumado wa.” Ago dugo Lidia dabai igane oŋ tag ida mau a. ");
INSERT INTO tbc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nal ta maŋ gudanek aben lo mau dugo, dal na urat bigabeg pein ta ipalug iliama ya. Iŋ ur ta kiai panek san aman da ya. Ur saian an mel murnap ilasa wan pein an awan lo ibol ilasa da. Dal an lo pein an moni tubun mi iŋanen tirnek tamol adi iŋane pidinai da. ");
INSERT INTO tbc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pein an maŋ Pol da ŋiema aban irig isasai dugo, igo ibol se, “Tamol en iŋ Anut lak na geig ak san urat tamol. Iŋ dal dugo lo patu pasek aŋane san ak dubol ilasa da.” ");
INSERT INTO tbc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nal wei kasik ago iginiamag, Pol tiŋaen saian tag nal ta idaŋsag, ur saian an ipei, “Ŋai oŋ ŋurupaio da, Jesus Kristus yaŋan lo pein an biseip lasa wau.” Ago dugo gamu nam ur saiak pein an ibiseig ilasa kisaek oŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Urat bigabeg pein an san tirnek tamol adi moni diŋane san dal itau an dile tag, Pol iŋ Sailas da duburoug, diriaig didaeŋ aben lo kot dupidinai o diau a. Ante gurman adi naod na dugunai a. ");
INSERT INTO tbc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Agog iŋ Rom san tulek tamol an naod na ru dupidinaig dubol, “Tamol en Juda tamol. Iŋ idsad taun lo muruan digane da. ");
INSERT INTO tbc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iŋ kagin idsad kubiaeŋ lo geg an tamolpein dipiteŋanai da. Id Rom tamolpein iŋsad kagin dubol dan tiŋane dop tiri san tia ya.” ");
INSERT INTO tbc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Agog doup tubun an dumasag, Pol iŋ Sailas da dufu wo fun digane. Tulek tamol an Pol iŋ Sailas da tinid fo kulos disire idug, bu dupidinai o dubol. ");
INSERT INTO tbc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","24","Agog dufu saian go subanek ab lo didirai a. Tamol a subanek ab ititiani dan isubanai sakar o durupei tag, ibilai galuŋ ilon lo geig ak lo diladug, ai lapan uraru muruadi ak nam ŋiedi ipini a. ");
INSERT INTO tbc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tidom luak igo woŋ Pol iŋ Sailas da Anut dugudani dugo bar diabi se ya. Ago dugo subanek tamol fidian awad duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Agog gamu nam kanaurig tubun ak ilasag subanek ab san fun an iguri dugo, dalawan fidian awad itapas a. Agog ŋied banid lo sein a ate dusubanai an sed itapas diau a. ");
INSERT INTO tbc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Subanek ab san titianek yen nag imasa yan, dalawan awad itapas ak ileg, subanek tamol fidian dusol diau ibol go, iŋsiganen sabiri igursig, nam sen ifuni imat o sumeik a. ");
INSERT INTO tbc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ago dugo Pol awan tubun mi iwagiŋ go ibol, “Se ifuno umoi. Maŋ tet mi mumado da.” ");
INSERT INTO tbc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Subanek ab san titianek lam disini dupalu wo iwagiŋ. Agog isuruwor oŋ imaspalug iladug, Pol Sailas da ŋied fun na turun isaluwig idu ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Agog iŋal go patun fo dilasag isumianai, “Ŋai dugo ŋiganep lo patu pasek ŋiŋane wak i?” ");
INSERT INTO tbc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Agog ru naon durupei, “Oŋ Tubun en Jesus niŋen o ilo rumok tap patu ipasi wa. Oŋane ab samun dam patud ipasi wa.” ");
INSERT INTO tbc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Agog Tubun en san ru iŋanen ab samun dida naod na dufulale ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tidom an lo mi subanek ab san titianek Pol iŋ Sailas da dufunai na yan sad baob ifulanig ifou pidinai. Iŋanen samun fidian dida ilod lo rumok go suguek diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Agog Pol iŋ Sailas da iŋal go ab lo disidag anaŋ ipidinaig diani. Titianek an iŋanen samun dida ilod tubun mi uyan a. Man dugo, iŋ gamu Anut ilod lo rumok. ");
INSERT INTO tbc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tidom lom mi tulek tamol adi iŋsad aikatuk adi didinaig diaug subanek ab san titianek igo durupei, “Tamol uraru an pasaip diau a.” ");
INSERT INTO tbc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ago tag titianek tamol an Pol irupei, “Gurman adi oŋ Sailas da ŋubusawaŋ pe alasa wo uyan dubol a. Ago yak niŋen o aŋ maror lo mi au a.” ");
INSERT INTO tbc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Gug Pol aikatuk an irupidai, “Maŋ mel ta migane saian man tia ya. Agod mel an fun niŋen o ta dusumianama na ya. Maŋ bo dam Rom tamol gug kawan geig malak malak bu nam dufunama ya. Agog subanek ab lo diginiama gug, gamu fon pasak nam didinamap mau o digane dak i? Maŋ ta mok mau na wa! Gurman adi iŋsed mok dupalup, dupasamap milasa gup mau a.” ");
INSERT INTO tbc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ago tag aikatuk adi diaug, gurman adi naod na Pol awan aban dubol ilasa ya. Saen gurman adi Pol Sailas da iŋ Rom tamol an duloŋ man direr saian geig a. Man dugo, kabelan iŋ dam naon diŋane banau. ");
INSERT INTO tbc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ago tag diaug, Pol iŋ Sailas da naod na iŋ digane saian ak niŋen o iŋaned muruan ilod iŋaoŋ o dugudani a. Agog diŋal go subanek aben dubuseig dilasag, panu dubuseip diau o dusumianai da. ");
INSERT INTO tbc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ago tag Pol iŋ Sailas da Lidia san ab lo diau a. Atna ilo rumok adi dumado dugo, tan suek ru durupidaig dubusawaig diau a. ");
INSERT INTO tbc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol iŋsan urat kisaek ak dida tureŋ diabig diaug, Amfipolis nag, Apolonia nag, Tesalonaika na dilasa ya. Atna Juda sad ubou ab ta yen da. ");
INSERT INTO tbc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol iŋsan kagin mi irig ubou ab an lo iladug Sabat nal utol tet mi tamolpein dida ru Kristus niŋen o Anut san buk lo yen dan niŋen o ru dabai lo dida diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Iŋ mel en ifulale pidinai a, Kristus muruan madai da isinip imat gup fon kumaen imasa da wan an urat anda ya, ago dugo ru ta Anut san buk lo yen dan lo Kristus mel an yabi-riŋani san tia geig ak niŋen o kuai te ikubiai pidinai o maeg igane se ya. Ago dugo igo irupidai, “Jesus nek e niŋen o ŋabol ilasa den iŋsen mi Kristus.” ");
INSERT INTO tbc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Juda aenkadi ru a Pol ibol ilasa se yan rumok dupanig Pol iŋ Sailas da luad disa ya. Ago dugo Grik tamol aenkadi Anut o ubou dile dan, agod pein yaŋad anda yak aenkadi dam nek ago mi digane na ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ak man Juda aenkadi Pol san urat dileg, turak dususa se ya. Ago tag tamol saiadi a taun san tumanek aben lo kawan dumado dan diŋal go dutumanai a. Agog iŋ tamolpein taun a lo dumado dan fidian bubed diabisag, Jeson san ab digileg, Pol iŋ Sailas da abaŋad diabi se ya. Iŋsad ilo sou lo man diliaip duburoup, tamolpein malan tubun an sad na diŋal diau o digane. ");
INSERT INTO tbc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ak man ta dil na tag Jeson iŋ ilo rumok aenkadi dida diŋal go taun an san gurman adi sad na diau. Agog duwagiŋ go dubol, “Tamol en kubulek tubun kasik digane dugo dutor nag, gamu idsad taun lo dam dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Agog Jeson tamol an iŋal go iŋsan ab lo dida dumado da. Iŋ fidian Kaisa san kubiaeŋ igane yan dipilali dugo, kiŋ neinta imado dak ago dubol a. Kiŋ an yaŋan Jesus dubol da.” ");
INSERT INTO tbc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Saen ru an dubol man tamolpein malan tubun an, iŋ taun san gurman dam fidian tiŋaed saian dugo ta dumado wo uyan se na ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ago tag gurman adi moni sapita Jeson ipidinai dop diŋane wo ida ru dufuni a. Aria, ru a dufuni an ilon lo, Jeson afon tamolpein muruan ipidinai tap, moni an ta iŋane da na wa. Agog Jeson moni an iŋaneg ipidinai gug, ka diau ak ago dubol tag, Jeson tein taon Kris an iŋal go dida diau a. ");
INSERT INTO tbc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Saen tidom idu dugo, ilo rumok adi Pol iŋ Sailas da didinaig, Beria na diau. Diaug dilasa man Juda sad ubou ab ta lo diladu ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Juda adi ete dumado den a Tesalonaika na dumado dan ago tia ya, tia, iŋ kankan uyanan ad da ya. Ago yan lo Pol san ru diŋane wo yaes ifu se ya. Agod nal pempem ru a Anut san buk lo yan dusuti dugo Pol san ru ifulale se yan ida dibitinae dile se ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Amaiak niŋen o Juda wei kasik ilod lo rumok a. Grik pein kitek wei mi yaŋad ad da yak, iŋ Grik tamol dida ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Saen Juda adi Tesalonaika na yan Pol Beria na Anut san ru ifulale dan duloŋ tag dupalug, tamolpein ated dusue dugo tiŋaed saian se ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ago tag gamu nam ilo rumok adi Pol didinig, loŋ na yau a. Gug Sailas iŋ Timoti da man Beria na dumado se ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tamol a Pol diŋaneg ida diau man diaug, Atens na geg gug tamol an afon idinaig Sailas iŋ Timoti da ririan iŋ luan disa wo ru iganeg sad na yau a. Agog saen ru diŋane man Beria dibisei kisaek oŋ go iŋsan na dupalu ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Saen Pol Atens na Sailas iŋ Timoti da malad igane dugo, taun an ilon lo tubud sewak an mitilaedi wei mi yil dugo, ilon imasag ilon muruan geig a. ");
INSERT INTO tbc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ago tag ubou ab lo Juda tamolpein, agod tamolpein Juda tia gug Anut ubou an dile dan Anut san ru irupidai dugo, dida tubun mi diŋiŋeŋ ila iso se ya. Nal pempem ensauta dadeŋ aben lo dumado tap, tamolpein an dam ru irupidai dop dida diŋiŋeŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ago dugo maŋau tamol malan uraru dida diŋiŋeŋ dugo nug aen ditog. Malan ta yaŋad Epikurian, malan neinta yaŋad Stoik. Malan uraru an luluŋad lo aenkadi igo dubol, “Ak dugo, awa you maŋau an tia amaiak dugo ibol o maeg igane dak i?” Ago dugo aenta dubol, “Iŋ tag tubud gol ak niŋedi wo ru ifulale dak boi a.” Iŋ ago dubol dan fun man, Pol iŋ Jesus agod iŋsan mateŋ lo kumaen imasa amaiak san ru ifulale se ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Aria, Atens ilon lo bubun ta yaŋan Ariopagus dubol da. Aben ante taun an sad kaunsil dutumani da. Agog diŋaneg Ariopagus tumanek aben ate diŋaneg diaug durupei, “Oŋsa piteŋanek foun an naoma na ubol ilasa dop ka maloŋ ak i? ");
INSERT INTO tbc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Oŋsa piteŋanek senamo geig ak kududoma lo ililaŋan da. Ago yak niŋen o melmel an sad fun maloŋ mok o iloma yen da.” ");
INSERT INTO tbc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atens tamolpein, agod gol tamolpein aenkadi dupalug dumado dan iŋ melmel foun ilasa dan niŋen o mi nug naon na dubol dop duloŋ o dumat da. Iŋaned saen tubun mi ago digane da. ");
INSERT INTO tbc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ariopagas gurman a dutumani an naod na Pol imasa itur go ibol, “Aŋ Atens tamol kududom agure. Ŋaisag leil lo man, aŋanem kagin fidian lo tubud adi ubou ad ale wo yaes isofutanaŋ da. ");
INSERT INTO tbc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Man dugo, saen ŋai aŋsam taun ilon lo ŋitiliani ŋator se man, malag yaug melmel a lo ubou amad ale dan ŋeil a. Ago dugo alta ta fufo girek ta igo digire yak ŋile ya. Girek an igo ya, ‘Alta en tubud enti id ta taloŋ na yak san a.’ Aria, gamu tubud a ta aloŋ nag ubou an ale dan, gamu aŋsam na ŋabol ilasa wo da. ");
INSERT INTO tbc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anut a tan iŋ keit da iganeg mel fidian ilon lo dam idiri an, iŋsen keit agod tan da sad Tubun ak imado da. Agod iŋ tempel tamolpein banid nam dufou yak lo ta imado na da. ");
INSERT INTO tbc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Agod iŋ mel o katukan dop tamol banid nam ta dibinawi na da. Man dugo, iŋsen amaiak tamolpein fidian kumaen di ur, agod mel fidian dam ipidinai da. ");
INSERT INTO tbc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tamol kisaek mi igane gug lo tamol naok funfun ilasag, tan fidian lo dumado da. Gamugo iginiai dugo, iŋsen mi tamolpein warou anen anen saen dumado wak ibalsi pidinai a. Agog tan geg ak anen anen ate mi itarpale pidinai a. ");
INSERT INTO tbc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Iŋ ago igane yan lo, tamolpein fidian Anut abaŋan diabi wa. Iŋ tag mala nouk lo didabdab gup dile wak boi ago digane wo idirai a. Ago bo man Anut man id anen anen sad na asau mi ta imado na da. ");
INSERT INTO tbc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Man dugo, talpein ta igo ibol, ‘Iŋ lo man, id kumaen tumado dugo tala taso da, agod iŋ lo dam idsad madok san fun yen da.’ Taida mi, aŋanem profet aenkadi dam igo dubol, ‘Rumok, id man iŋanen malan kubulan.’ ");
INSERT INTO tbc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Id Anut malan kubulan, ago yak niŋen o Tubud a rumok an nek ibol mel ta silva, gol pat da nam tamol digane yak oŋ ago ta ilod isou na wa. Mitilaedi an fidian man tamol banid kulob an lo siganed maŋau lo mel an banid nam didirai ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Id fidian tiŋaoŋ dugo kagin ago tigane na yan san saen lo Anut iliad funad se ya. Gug gamu man Anut ru dabai nam tamolpein fidian irupidai dop, ilod ibileksap iŋaned kagin saiak an patud dupani wa. ");
INSERT INTO tbc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Man ata wo? Nal ta lo iŋ kagin itaot ak lo mi tamolpein tan tilianek lo dumado dan bitinaek lo idirai an ibalsi la ya. Tamol a iŋ wagen lo bitinaek urat an igane wan ipiliani la ya. Iŋ ru e rumok an tamolpein fidian kuai te ikubiaig dile yan san dal man nek igo ya, tamol a mateŋ lo ifufunig afon kumaen imasa da ama ya.” ");
INSERT INTO tbc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Saen tamol adi a Ariopagus na yan Pol tamol ta mateŋ lo kumaen imasa da yak san ru ibol dugo duloŋ man, aenkadi kukok an digane se ya, ak man aenkadi dubol, “Maŋ ru e mel an niŋen o ubol den afon nal tap maloŋ a.” ");
INSERT INTO tbc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Agog Pol tumanek an ibiseig yau a. ");
INSERT INTO tbc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Gug tamol aenkadi iŋanen ru ilod lo rumok an lo luan disa ya. Luluŋad lo tamol ta yaŋan Daionisias iŋ Ariopagus kaunsil ta. Agod pein ta yaŋan Damaris, ago dugo tamolpein aenta dida ilod lo rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol Atens ibiseig Korint na yau a. ");
INSERT INTO tbc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Atna Juda tamol ta yaŋan Akwila ile ya. Tamol an Pontas tamol. Iŋ iwon Prisila da wari na geig Itali dibiseig Korint na dupalu ya. Man dugo, Kaisa a yaŋan Klodias dubol dan, Juda fidian a Rom na dumado dan Rom dibisei wo ru dabai nam ru kagin ago irupidai a. Ago tag Pol Akwila iwon da yil o sad na yau a. ");
INSERT INTO tbc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol man ab sel ak san niganag tamol. Akwila iwon Prisila dam iŋ da urat kisaek a. Fun an lo Pol iŋ dida dumado dugo sisem ab sel diweig didaeŋ lo didiri dugo moni diŋane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ago dugo Pol iŋ Sabat nal anen anen ate mi Juda sad ubou ab lo tamolpein a ate dumado dan dida diŋiŋeŋ dugo nug aen ditog se ya. An lo Juda aenkadi agod Grik tamolpein dam ilod iŋaneg Jesus o ilod rumok a. ");
INSERT INTO tbc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Saen Sailas iŋ Timoti da Masedonia na dupalug Korint na dilasa man, Pol iŋsan ab sel iwei se yan ibiseig saen tubun mi Tubun en san ru ifulale se ya. Iŋ Juda tamolpein mi naod na Kristus man iŋsen Jesus an irupidai duloŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Gug saen iŋ Pol san naon diabi dugo nao futek ru dupani se man, ilon imoi ak niŋen o iŋsan kulos fo gufgaf dien an igigiani idu ya. Agog patun ipidinai ak san ru en igo irupidai, “Aŋ adeg au tap, an aŋanem mel mi a, ŋaisag wadan tia ya. Ak niŋen o gamu saen e yau den, ŋai tamolpein Juda tia yan sad na ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Agog ibisawaig, tamol ta yaŋan Titius Jastus san ab lo yaug ida dumado na ya. Iŋ Juda tia gug Anut ubou an ile da. Iŋsan ab Juda sad ubou ab giraŋen na itur da. ");
INSERT INTO tbc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Aria, ubou ab an san gurman yaŋan Krispas dubol dan Tubun en niŋen o ilon rumok a, agod iŋanen samun fidian dam ilod lo rumok a. Korint tamolpein wei mi Pol awan duloŋ go ilod lo rumok gug suguek diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nal ta tidom lo Pol malan ŋutun ile dugo Tubun en irupei, “Oŋ ta urer na wa. Tia, ubol ilasa dop awa ta mok itau na wa. ");
INSERT INTO tbc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Man dugo, ŋai oŋ da tumado da. Talpein ta oŋ ifunop saian ipano san tia ya. Ete mado, man dugo, tamolpein wei mi taun en lo dumado dan ŋaisag tamolpein.” ");
INSERT INTO tbc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ago tag Pol atna anaŋar kisaek wadan da imado dugo, taun an san tamolpein ilod lo Anut san ru ipiteŋanai se ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ak man saen Rom gurman ta yaŋan Galio dubol dan, Akaia provins san tirnek tamol ilasa man, Juda adi dutumanig kankan kisaek ad da yak lo, Pol kot dupani wo diabig, diŋane diaug gabman san kot naon na dugunig ");
INSERT INTO tbc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","dubol, “Tamol en kubiaeŋ iriŋani da. Ata wo? Iŋ tamolpein dal senamo yak lo Anut niŋen o ubou digane wo ilod iŋane wo maeg igane da. Gug dal an kubiaeŋ ta iri na da.” ");
INSERT INTO tbc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol awan ipuk go iŋiŋeŋ o igane ibol ak Galio imasag Juda adi irupidai, “Muruan gamu en kagin saiak san, tia, mala suek saian geig ak san ago tap, aŋ Juda awam ŋaloŋ san an dal ag da wa. ");
INSERT INTO tbc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ak man gamu aŋ asumianag dak, ŋai ru ta, yaŋak, agod aŋanem kubiaeŋ dam mel naok an mi ŋibitinae wo abol da. Ŋai ru naok ago yak ta ŋibitinaep ŋukubune na wa. Ago yak niŋen o aŋsem muroum mi ale gup akubune wa.” ");
INSERT INTO tbc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ago ibol dugo ikudaig kot aben dubiseig, patun fo dilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Juda tamolpein an fidian iŋ ubou ab san gurman ta yaŋan Sostenis dubol dan diabig, kot malan lo malak malak dufuni se ya. Ak man Galio ka yilfu oŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol nal wei mi ilo rumok adi dida Korint na dumado gug wog iŋaneg Akwila iwon Prisila da dida Siria na diau a. Wog gamugo iŋane dugo Senkria na gurman roun ibol dugo dutute ya. Man dugo, inug mi Anut malan lo promis ru ibol an nuŋon igane yak niŋen o iŋsan promis an igane itout a. ");
INSERT INTO tbc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Diaug, Efesus na dilasag, atna Pol Akwila iŋ Prisila da ibisawaig, ubou ab lo iladug, Juda dida Kristus niŋen o ru lo nug aen ditog se ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Atna saen milaen mi dida dumado wo dusumiani ak man iŋ imoi. ");
INSERT INTO tbc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Gug saen yau o dugo irupidai, “Anut ŋamul o ibol tap, ŋai aŋsam na ŋamul da wa.” Agog Efesus ibiseig iyawai a. ");
INSERT INTO tbc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Agog Sisaria na ilasag, Jerusalem na isida yau. Atna midaeŋ ilo uyan ru irupidai gug Antiok na yau. ");
INSERT INTO tbc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antiok na kitek imado gug yaug Galesia ilon lo iladug, Frisia na dam ilo rumok adi fidian dabai ipidinai dugo yau oŋ se ya. ");
INSERT INTO tbc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Saen Pol yau imul dugo Juda tamol ta yaŋan Apolos, tinan Aleksandria na igansi ak iŋ Efesus na ipalu ya. Iŋ ru bilabal nimaŋau man uyanan geig. Agod Anut san ru girek lo yen dan iloŋ siŋaokan. ");
INSERT INTO tbc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Iŋ Tubun en san ru dupiteŋani siŋaokan. Agog buben imasag, Jesus san ru itaot mi ifulale dugo tamolpein ipiteŋanai. Gug iŋ Jon san suguek an mi iloŋ. ");
INSERT INTO tbc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Aria, saen Efesus na ilasa man, Juda sad ubou ab lo ru dabai anda ifulale dugo Akwila iŋ Prisila da duloŋ a. Ago tag diŋaneg, iŋsiganed ab lo diaug, Anut san dal taidam itaot dukubiai panig iloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Agog Apolos Akaia provins na yau o ibol tag, Efesus na ilo rumok adi ilon dabai dupanig dubunawig, girek ta digireg Kris tamolpein ate yak durupidai, “Tamol en aŋsam na ipalu tap, ayuŋani wa.” Saen Akaia na ilasa man, tamolpein a Anut san ilo muŋanek log Jesus o ilod rumok an ibinawai siŋaokan a. ");
INSERT INTO tbc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Man dugo, iŋsan ru dabai anda ibol se yan lo malak malak ru lo nug aen ditog dugo iŋ Juda ibiai dudu ya. Ago dugo ru Anut san buk lo yen dan isuti se yan lo ikubiai pidinai ak, Jesus man iŋsen Kristus. ");
INSERT INTO tbc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Saen Apolos Korint na imado dugo, dal ta did fufo mi yau ak Pol irig Efesus na yau. Atna ilo rumok aenkadi dumado dugo yil tag ");
INSERT INTO tbc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","isumianai, “Saen aŋ ilom lo rumok an Urgun aŋane yak i?” Ago dugo iŋ dubol, “Maŋ ru ta Urgun niŋen o kitek maloŋ man tia ya.” ");
INSERT INTO tbc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Agog fon isumianai, “Ak dugo, aŋ suguek naon dugo yak aŋane yak i?” Agog awan diabig, dubol “Maŋ Jon san suguek miŋane ya.” ");
INSERT INTO tbc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ago tag Pol irupidai, “Jon san suguek man tamolpein iŋaned aupasek patud dupani ak san a. Iŋ Isrel tamolpein irupidai, ‘Tamol a ŋai ŋieg aban fo ipalu dan ilom lo rumok a. Tamol an Jesus.’” ");
INSERT INTO tbc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ru an duloŋ go Tubun en Jesus yaŋan lo suguek diŋane ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Agog saen Pol banin gurmad fo igane man, Urgun iŋ tinid fufo idu ya, ago dugo muroun ru sensen ak lo diŋiŋeŋ dugo, profet ru dam dubol ilasa se ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tamol an nuŋod 12 igo woŋ. ");
INSERT INTO tbc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kalam utol Pol Juda sad ubou ab lo yau imul dugo Juda tamolpein Anut san ru dabai anda irupidai se ya. Agog ru lo dam dida nug aen ditog dugo Anut san kagin panek san fun ifulale ilasa se ya. Ago dop duloŋ pe ilod lo rumok o ago igane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ak man aenkadi kabuŋad sakar kasik an lo ru an ilod lo ta rumok na ya. Taida mi iŋ midaeŋ malad lo Kris adi sad ilo rumok yaŋan “Dal En” dubol dan niŋen o ru saian dubol ilasa da. Ago tag Pol megeloum foun ak iŋal go, nal pempem Tiranas san galuŋ tubun ak lo dutumani dugo, a Juda tia yan dam dida Jesus niŋen o diŋiŋeŋ ila iso se ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Anaŋar uraru nek ago mi igane dugo, Esia distrik lo Juda tamolpein, agod a Juda tia yan dam fidian Tubun en san ru duloŋ a. ");
INSERT INTO tbc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anut kulob girager funfun Pol banin lo iganeg ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Iŋsan silali isuas san yamel boi, urat san yamel an tamolpein subam amad da yan sad na diŋane diaup tinid fo digane dop subam ibisawai se ya. Ur sisaiak amad da yan dam nek ago mi digane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Juda aenkadi a ur saiak dukudai diau dugo dutor dan, Jesus yaŋan lo ur sisaiak an dibitinaep dukudai o ilo sou ago digane. Agog ur saiak tamol tinid lo dumado dan igo dupidai, “Jesus yaŋan a Pol ifulale dan lo alasap au kisaek oŋ o maŋ murupaiaŋ da.” ");
INSERT INTO tbc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juda pris gurman ta yaŋan Skeva iŋ nanun 7 kubol an digane dugo dutor a. ");
INSERT INTO tbc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Gug saen ta tamol ta ur saian anda yak durupei dugo, ur saian awad yabig ibol, “Ŋai Jesus ŋaloŋ. Agod Pol dam ŋaloŋ. Gug aŋ en sauta yak i?” ");
INSERT INTO tbc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ago ibol ak tamol ur saian aman da yan imasag, maeg iganeg ifu saian. Tinid daoŋ ipanig sad kulos irasisare idu ya. Agog Skeva nanun 7 an dar ad da nuŋod kawan ab lo dilasag dumaspalu oŋ go dusol diau a. ");
INSERT INTO tbc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Agog Efesus na Juda tamolpein, agod Juda tia yan fidian ru an duloŋ go tubun kasik direr. Agog Jesus Tubun en yaŋan man lak na geig diabisa. ");
INSERT INTO tbc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ilo rumok adi wei kasik dupalug, malak malak mel digane saian man kuai tem dufulale se ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wei tinan buk lo nawir san maŋau diŋane yan iŋsad buk disini dupalug dutumanig, tamolpein fidian malad lo dumari inani yau a. Buk an fidian san naod dutumanig, fifti tausen kina (K50,000) igo ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kulob funfun dabai anda dilasa yan lo, Tubun en san ru nek ago mi ilasag yaug tubun geig dugo, ifufurak go aben fidian lo yau a. ");
INSERT INTO tbc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Murnag mel fidian ilasag itout an, Pol yaup Masedonia nap Akaia na gup Jerusalem na yau o Urgun kankan ipanig ibol, “Aben an fidian ate ŋau itout gup, Rom na dam ŋau a.” ");
INSERT INTO tbc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ago tag iŋsan binawek uraru Timoti iŋ Irastas da idinaig, Masedonia na diau. Agog iŋsen man saen kitek milaen mi Esia provins lo imado ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Saen nek an lo mi muruan tubun ak “Dal En” niŋen o Efesus na ilasa ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tamol ta, yaŋan Demitrias, iŋ silva nam melmel igane da. Iŋ silva nam tubud pein ta yaŋan Atemis san tempel mitilaen wei mi igane idu ya. Agod iŋsan bisnis an lo moni tubun mi irae dugo, iŋanen urat tamol dam urat an lo moni tim an tubun mi diŋane da. ");
INSERT INTO tbc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ago tag iŋanen urat pinein agod aenkadi iŋsad urat naon kisaek an dam igiaig itumanaig irupidai, “Aŋ tamol gamu atumani an aloŋ ak, idsad moni man urat nek en lo tile da. ");
INSERT INTO tbc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Agod gamu tamol a Pol dubol dan kulob igane dak aŋsem dam ale aloŋ a. Iŋ ibol, tubud a tamol banid nam digane yan tubud tia ya. Ru an lo Pol tamolpein wei kasik naod yabitig ilod ibilisa ya. Tamolpein fidian Efesus na, agod wei mi Esia provins ilon lo dam, ru an duloŋ la ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Agod muruan tubun ak yen da. Idsad bisnis yen yaŋak saian ak iŋane wa. Muruan an mi tia. Taidam tubud pein Atemis san tempel mel kawan dubol dop iŋsan yaŋan tubun an fon diabi idu wa. Tubud pein an Esia provins lo, agod tan titin fidian en lo tamolpein ago mi ubou an dile da.” ");
INSERT INTO tbc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Doup tubun ru an duloŋ man tiŋaed tubun mi saian tag disasai dugo dubol, “Efesus san Atemis iŋ tubun a.” ");
INSERT INTO tbc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Siseiŋ an taun ilon iŋane. Ago dugo doup a taun lo yan Masedonia tamol uraru Pol dida diau an duburoug, tamolpein fidian sad tumanek aben lo diau a. Tamol uraru an Gaias iŋ Aristakus da. ");
INSERT INTO tbc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol iŋsen ilo rumok tamolpein an ibisawaip, doup tubun an malad lo yaup, ru irupidai o igane yak man, ilo rumok adi diabituani a. ");
INSERT INTO tbc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Provins san tamol gurman aenta, iŋ Pol turan muroun, an dam ru kagin diganeg Pol san na yau. Kabelan tumanek aben lo doup malad lo ilasa banau o dumoi a. ");
INSERT INTO tbc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Agog saen an tumanek lo doup leiŋ tubun kasik digane se ya. Ago dugo tamolpein ŋiŋeo lo ru naon sensen disasai ilasa se ya. Man dugo, tamolpein wei kasik tumanek an fun ta duloŋ na ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juda adi tamol ta yaŋan Aleksanda dubol dan doup malad lo dusoduduni ilasa ya. Agog tamolpein aenta doup ilon lo tamol an dududuwig targiranek ru ibol ilasa wo durupei se ya. Agog iŋ targiranek ru tamolpein irupidai o banin nam touad touad igane se ya. ");
INSERT INTO tbc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ak man saen iŋ Juda tamol ago dile tag, 2 auwa igo woŋ ru naon kisaek an mi disasai dugo dubol se, “Efesus san Atemis iŋ tubun a!” ");
INSERT INTO tbc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ago digane yau nag panu san pepa kubunek tamol ta tamolpein sad siseiŋ yabi idug irupidai, “Efesus tamolpein aloŋ! Tamolpein fidian duloŋ ak, aŋ tubud e Artemis dubol den san tempel, agod pat a gun ak keit log idu yan da