﻿USE sofia;
DROP TABLE IF EXISTS sofia.taw_vpl;
CREATE TABLE taw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES taw_vpl WRITE;
INSERT INTO taw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Jisas Klays nap nɨsed yes ne okok tɨkel, amɨl apɨl gek nop tɨkɨlak tek agɨnɨgebin. Eblaham ne tɨkek tɨk dad amɨl, bɨnonɨm Depid nop tɨkɨlak. Nop tɨkelak, Depid ne tɨkek tɨk dad amɨl nɨm, Jisas Klays nop tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pen kɨli anɨgɨl tɨkɨlak. Eblaham ne Aysak nop tɨkak. Aysak ne Jekop nop tɨkak. Jekop ne Juda nop tɨkɨl, nɨmam ne okok tɨkɨl gak. ");
INSERT INTO taw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ne Peles ayɨp Chela ayɨp kɨlop tɨkak. Peles ayɨp Chela ayɨp nonɨm kɨli ak Tamal. Peles ne Heslon nop tɨkak. Heslon ne Lam nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lam ne Aminadap nop tɨkak. Aminadap ne Nason nop tɨkak. Nason ne Salmon nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ne Bowas nop tɨkak. Bowas nonɨm ne ak Layap. Bowas ne Obed nop tɨkak. Obed nonɨm ne ak Lud. Obed ne Jesi nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ne bɨnonɨm Depid nop tɨkak. Depid ne Solomon nop tɨkak. Solomon nonɨm ne ak ned bɨ Uliya nop dɨl, kɨdek Depid nop dɨl, Solomon nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ne Leyobowam nop tɨkak. Leyobowam ne Abiya nop tɨkak. Abiya ne Asa nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ne Jeyosapad nop tɨkak. Jeyosapad ne Jeyolam nop tɨkak. Jeyolam ne Usiya nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya ne Jotam nop tɨkak. Jotam ne Ayas nop tɨkak. Ayas ne Hesekiya nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya ne Manase nop tɨkak. Manase ne Emon nop tɨkak. Emon ne Josaya nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya ne Jehoyakin nop tɨkɨl, nɨmam ogɨnap tɨkɨl gak. Ñɨn anɨb ak, Babilon bɨ kɨli apɨl, Yislel binɨb kɨlop nag lɨl, dad man Babilon amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nag lɨl dad amelak, Jehoyakin anɨb okok mɨdɨl, ne Seyaltiyel nop tɨkak. Seyaltiyel ne Selubabel nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabel ne Abiyud nop tɨkak. Abiyud ne Eliyakim nop tɨkak. Eliyakim ne Asol nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asol ne Sadok nop tɨkak. Sadok ne Akim nop tɨkak. Akim ne Eliyud nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud ne Eleyasal nop tɨkak. Eleyasal ne Matan nop tɨkak. Matan ne Jekop nop tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ne Josep nop tɨkak. Josep nɨm, bin Maliya nɨgɨmɨl ne yek. Maliya ne Jisas nop tɨkak. Kɨli Jisas nop yɨb Klays apal ak, ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod mɨdeb. ");
INSERT INTO taw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Anɨb ak, based Eblaham ne tɨkek tɨk dad amɨl apɨl gɨl nɨm, bɨnonɨm Depid nop wajɨlem pɨs ak tɨkɨlak. Tɨkel, Depid ne pen tɨkek tɨk dad amɨl apɨl gɨl nɨm, Babilon bɨ okok apɨl kɨlop nag lɨl dad man kɨli ak amnɨlak ñɨn ak, abe wajɨlem pɨs ak tɨkɨlak. Pen nag lɨl dad amelak, kɨdek pen tepayaŋ tɨkek tɨk dad amɨl apɨl gɨl nɨm, Klays nop wajɨlem pɨs ak tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Klays nop tɨkɨlak kesɨm ak anɨgɨl gak. Nonɨm ne Maliya, kɨli Josep nop aglɨlak. Aglelak, ayɨp ma kɨnɨlek ñɨn ak pen nɨgɨlak, Maliya ñapay kogmeg yek. God Kawnan ne ak ke gek, ñapay kogmeg anɨb ak yek. ");
INSERT INTO taw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pen Josep ne bɨ teplep yɨbɨl ak nɨm, takaw awl ma agak. Ñapay kogmeg mɨdeb anɨb ak, binɨb okok agñenɨgab, Maliya nop nebeŋ gɨnɨgab. Anɨb ak nop kɨmɨgel agyokin agɨl gos nɨgak. ");
INSERT INTO taw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pen anɨgɨl gos nɨgɨlɨg, ñɨn olap wɨsɨn nɨgak, Bɨawl ensel ne olap apɨl nop agak, Josep, nad Depid nɨsed ne agak. Maliya ñapay kogmeg ne mɨdeb ak, God Kawnan ne ak ke gek, ñapay kogmeg anɨb ak mɨdeb agak. Anɨb ak bin ak taynen dɨnɨm agɨl gos ak ma nɨgɨnɨmɨn, nop dɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne ñɨ olap tɨkek awl gɨl, binɨb ne okok gach kɨlop ak tɨg walɨg gɨyokɨl, kɨlop tɨg asɨk dɨnɨgab agak. Anɨb ak yɨb nop Jisas agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tap anɨb okok gak ak, bɨ God gos ñek agñeb olap, ne bɨlel gɨnɨgab agɨl agak tek nep gak. Ne anɨb agak, ");
INSERT INTO taw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nɨgɨm. Bin pɨlaj bɨ ayɨp ma kɨnɨgab olap, ne ñapay kogmeg mɨdɨl, ñɨ olap tɨkɨnɨgab agak. Tɨkek, yɨb nop Emanuwel agɨnɨgabal agak. Yɨb Emanuwel takaw jɨj ak anɨgɨl mɨdeb, God chɨn ayɨp mɨdeb. ");
INSERT INTO taw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pen Josep ne tɨkjakɨl, Bɨawl ensel ne takaw agak ak dɨl, bin Maliya nop dak. ");
INSERT INTO taw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ne pen Maliya ayɨp ma kɨnɨlek, mɨd dad amɨl Maliya ñɨ anɨb won ak tɨkak. Pen Maliya ñɨ ak tɨkek, Josep ñɨ anɨb ak yɨb Jisas agak. ");
INSERT INTO taw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pen Helod ne gapman bɨnonɨm yek ñɨn ak, Maliya ne Jisas nop tɨkak, man sɨkol Betlehem, Judiya plopens nab okok. Tɨkek, bɨ gos nɨgep ogɨnap, kɨli sub lɨm gup tam okok nɨb apɨl, Jelusalem apjakɨl ");
INSERT INTO taw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","agɨlak, Bin olap, ne Juda binɨb bɨnonɨm kɨli ak nop tɨkup agɨlak. Mɨñɨl dɨlel mɨdeb akal agɨlak? Man chɨn okok mɨdɨl nopun, gap ne ak aplan jakak nɨŋɨd nɨm, nop kɨgom yɨmɨl agnɨgɨnɨg apobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Anɨb agelak, gapman bɨnonɨm Helod takaw anɨb ak nɨŋɨd, judɨl gos pal lak. Pen Jelusalem binɨb abe anɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pen gapman bɨnonɨm Helod, ne bɨ God nop sɨbogep bɨawl okok kɨlop suk agak. Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok, kɨlop abe suk agak. Yislel bɨawl anɨb okok mɨdupsek kɨlop suk agek, apelak agak, Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab agak. Bɨ anɨb ak, nop tɨkɨnɨgabal man akal agak? ");
INSERT INTO taw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Agek agɨlak, Nop tɨkɨnɨgabal man sɨkol Betlehem, Judiya plopens nab okok agɨlak. Bɨ God gos ñek agñeb ak, ne takaw agɨl tɨkak tek, chɨn nɨŋɨd anɨb ak nopun agɨlak. Bɨ God gos ñek agñeb ak, ne anɨgɨl tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judiya plopens nab okok, man keke kuŋay mɨdeb agɨl tɨkak agɨlak. Man sɨkol Betlehem nɨgel sɨkol tek lup ak pen, Bɨawl yɨbɨl olap man anɨb ak nɨb ownɨgab agɨl tɨkak agɨlak. Ne apɨl, God binɨb ne Yislel kay kɨlop kod yenɨgab agɨl tɨkak agɨlak. Anɨgɨnɨgab tek man sɨkol Betlehem yɨb awl yenɨgab agɨl tɨkak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Anɨb agelak, gapman bɨnonɨm Helod nɨŋɨd, amɨl bɨ gos nɨgep okok kɨlop suk agek apelak kɨmɨgel agak, Ñɨn akal tek gap anɨb ak aplan jakak agak? Agek, nop takaw anɨb ak agñelak, ");
INSERT INTO taw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","kɨlop Betlehem agyokɨnɨg agak, Nɨbi am ñɨ anɨb ak pɨyow nɨgtep gɨnɨmɨb agak. Ñɨn akal nop nɨŋɨd, yɨp apɨl agem, yad abe amɨl, nop kɨgom yɨmɨl yɨb nop dad aplanɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Helod anɨb agek nɨŋɨd, nop kelɨgɨl saŋɨdɨlaknɨŋ, gap ned aplan jakek nɨgɨlak ak tepayaŋ nɨŋɨd, kɨli kɨdek gɨlak. Gap ak am am, ñɨ ak kal yek nab sɨŋak nep alad gak. ");
INSERT INTO taw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Anɨgek nɨŋɨd, kɨlop tep yɨbɨl gek mɨñmɨñ tɨmel yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pen kal mɨgan ayaŋ amɨl nɨgɨlak, ñɨ ak nonɨm Maliya ayɨp yelek. Nɨŋɨd, apyap kɨgom yɨmɨl yɨb nop dad aplanɨlak. Yɨb nop dad aplanɨl, wad kɨli okok aŋɨlɨl, tap teplep yɨbɨl okok nop ñɨlak. Gol ogɨnap sek, wel kuy tep owep ogɨnap sek, mab mok kuy tep owep ogɨnap sek nop ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pen kɨdek kɨnɨl wɨsɨn nɨgɨlak, God agak, Adɨkɨd Helod yɨl ma amnɨmɨb agak. Anɨb agek nɨŋɨd, tɨkjakɨl kanɨb pal olap ke amɨl, man kɨli amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pen bɨ gos nɨgep okok man kɨli adɨkɨd amel, Josep wɨsɨn nɨgak, Bɨawl ensel ne olap apɨl nop agak, Helod ñɨ ak paklin agɨl, pɨyow nɨgɨnɨgeb agak. Anɨb ak tɨkjakɨl, ñɨ amɨlmɨŋal ak kasek poŋɨd, pɨlɨk man Yijip amɨl yenɨmɨn agak. Pen ownɨmɨn agen, tepayaŋ adɨkɨd ownɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Agek, Josep maynab ayaŋ tɨkjakɨl, ñɨ amɨlmɨŋal ak poŋɨd man Yijip amnak. ");
INSERT INTO taw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pen Josep amɨl man Yijip mɨdel mɨdel, Helod kumak ñɨn ak. Tap anɨb okok, bɨ God gos ñek agñeb ak gɨnɨgab agɨl tɨkak tek nep gak. Takaw anɨb ak tɨkɨl agak, God ne agup, Ñɨ yad ak man Yijip mɨdeb ak, nop suk agen adɨkɨd ownɨmuŋ agup agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pen Helod ne nɨgak, bɨ gos nɨgep okok kɨlop agak tek ma gɨl yepɨs gelak, nop mɨlɨk tɨmel yɨbɨl yowak. Yapek, gos olap nɨŋɨd anɨb agak, Ñɨŋaŋ anɨb ak kɨdek tɨkɨlak ñɨn ak, gap ak aplan jakek, yɨp agtep gɨl amnɨlak agak. Anɨb ak yad nepin, Betlehem ñɨŋaŋ tɨkel, sub omɨŋal yɨnub okok sek, ñɨŋaŋ kɨdek tɨkebal okok sek paklɨl nɨm, ñɨ anɨb ak sek paklɨnɨgabun agak. Anɨb agɨl, bɨne ogɨnap agyokek amɨl, ñɨŋaŋ Betlehem wulep yelak okok mɨdupsek pak lɨdɨlak. ");
INSERT INTO taw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Betlehem ñɨŋaŋ pak jel tɨk lɨlak anɨb ak, bɨ God gos ñek agñeb Jelemaya gɨnɨgab agɨl tɨkak tek nep gɨlak. Jelemaya takaw anɨb ak tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Man sɨkol Lama kɨli chɨb gek takaw pug awl yɨbɨl agɨl, chaŋ awl lebal agɨl tɨkak. Bin Lechel binɨb ne okok, ñɨŋaŋ ma mɨdebal agɨl tɨkak. Anɨb ak chɨb gek chaŋ lebal, binɨb ogɨnap kɨlop agdep tek ma leb agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pen kɨdek gapman bɨnonɨm Helod kumek, Josep man Yijip kɨnɨl wɨsɨn nɨgak, Bɨawl ensel ne olap apɨl nop agak, ");
INSERT INTO taw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Bɨ ñɨ ak paklɨnɨg gɨlak okok kubal agak. Anɨb ak tɨkjakɨl, ñɨ amɨlmɨŋal ak poŋɨd, adɨkɨd man Yislel amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Agek, Josep ne tɨkjakɨl, ñɨ amɨlmɨŋal ak poŋɨd adɨkɨd man Yislel amnak. ");
INSERT INTO taw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Pen amjakek, takaw olap agɨlak, Helod kumek, ñɨne Akelaws tep ne ak dɨl gapman bɨnonɨm mɨdɨl, Judiya binɨb kɨlop kod mɨdeb agɨlak. Agelak nɨŋɨd, Josep ne Akelaws mɨdeb ak taydɨl man anɨb ak amnɨm agɨl pɨlɨkak ak pen, kɨnɨl wɨsɨn nɨgak, God nop agak, Judiya plopens ma adɨkɨd amnɨmɨn, Galili plopens amnɨmɨn agak. Agek, Josep kɨlop poŋɨd amɨl taun Nasalet, Galili plopens am yolɨgup. Am yolɨgup anɨb ak, bɨ God gos ñek agñeb okok gɨnɨgab agɨlak tek nep gak. Kɨli takaw anɨb ak tɨkɨl agɨlak, Nop bɨ Nasalet nɨb agɨnɨgabal agɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ñɨn nab anɨb ak, Jon Bɨ Ñɨg Pakñeb ak ne apɨl, Judiya plopens man nep binɨb ma yelak nab okok mɨdɨlɨg, binɨb okok apel kɨlop takaw agñɨlɨg agolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Anɨb agolɨgup, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak, wulep mɨdeb agolɨgup. Anɨb ak tap si tap tɨmel gɨpɨm ak taynen anɨgɨpun agɨl kelɨgɨnɨmɨb agolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bɨ God gos ñek agñeb Aysaya, ne bɨlel bɨ Jon anɨb ak nop gos nɨŋɨd anɨb agɨl tɨkak. Aysaya takaw anɨb ak tɨkɨl agak, Bɨ olap man nep binɨb ma mɨdebal nab okok suk awl agɨl agɨnɨgab, Bɨawl ak kanɨb nop pɨdɨl kod yenɨmɨb agɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pen chag kamel wɨj dɨl chech gɨlak ak, Jon ne dɨl tol gɨl, sɨbnag olap pogɨlolɨgup. Joŋ ak sek sɨbɨnɨm ñɨg ak sek ñɨbɨlɨg yolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pen Jelusalem binɨb okok sek, Judiya plopens nab okok binɨb mɨdupsek, binɨb ñɨg Jodan wulep okok yelak mɨdupsek, kɨli Jon yek ak amelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Amɨl, tap si tap tɨmel gɨlak okok agyɨkɨlaknɨŋ, kɨlop ñɨg Jodan nab ak ñɨg pakñolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pen Pelisi bɨ okok sek, Sajusi bɨ okok sek, kɨli kuŋay Jon yek ak apɨl, chɨnop ñɨg pakñaŋ agɨl apelak, kɨlop ag gɨl agak, Yoy salaw ñapay ne okol agak. God ne nɨbop tɨmel nɨŋɨd ag gɨnɨgab ak, an nɨbop agek, nɨbi anɨb awl pɨlɨk opɨm agak? Ñɨg pakon, God binɨb ogɨnap kɨlop ag gɨnɨgab ñɨn ak, chɨnop ma ag gɨnɨgab agɨl pɨlɨk opɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tap si tap tɨmel okok kelɨgɨl nɨm, nɨbi tap teplep adek anep gɨnɨmɨb agak. Anɨgem, binɨb okok nɨbi gɨtep gɨpɨm anɨb ak nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pen nɨbi ke gos olap nɨŋɨd, Eblaham bɨ based chɨn nɨm anɨb ak, God ne chɨnop gɨ tɨmel ma gɨnɨgab agɨl nepɨm agak. Pen Eblaham nop nep gos ak ma nɨgɨnɨmɨb agak. Nɨbi nɨgɨm agak. God ne kab ogɨnap dɨl, Eblaham binɨb ne ogɨnap gɨnɨmuŋ tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pen nɨgtep gɨnɨmɨb agak. God mab mɨdup ma pulup okok, tɨb dagɨlɨnɨg, tu ak mab gɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nɨbi tap si tap tɨmel gɨpɨm ak taynen anɨgɨpun agɨl kelɨgem nɨm, nɨbop ñɨg pakñebin agak. Bɨ olap pen kɨdek ownɨgab ak bɨawl yɨbɨl, yad bɨ yokɨp agak. Nop nɨgen yɨp nebeŋ gup, wog ne gɨnɨg tob tɨlup nop dad amnɨm tek ma lup agak. Ne apɨl, God Kawnan ne ak sek mab mɨŋɨlaŋ sek nɨbop pakñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pen ne wit mɨdup ne cheg dɨyokek, wit mɨdup ñɨŋeb okok anɨgɨl yenɨgab agak. Wit mɨdup ñɨŋeb okok ke lɨl, wit cheg okok ke lɨl gɨnɨgab agak. Anɨgɨl, wit mɨdup ñɨŋeb okok dad tap pɨpag dap lep kal ne dap lɨnɨgab, cheg okok dam mab ke yɨneb ayaŋ yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ñɨn anɨb ak, Jisas Jon yɨp ñɨg pakñaŋ agɨl, Galili plopens kelɨgɨl, ñɨg Jodan yek ak amnak. ");
INSERT INTO taw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amek, Jon pen Jisas takaw nop tɨpagɨlɨnɨg agak, Nad nep nɨm, yɨp ñɨg pakñɨbɨnap agak. Pen yad nep taydɨl ñɨg pakñɨnɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Agek Jisas pen nop agak, Nad ageban ak kelɨgɨl, yad apin tek gɨnɨmɨn agak. Anɨgonɨgul nɨm, God agup tek mɨdupsek gɨnɨgul agak. Agek, Jon takaw nop ak kɨdek gak. ");
INSERT INTO taw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon Jisas nop ñɨg pakñek, won anɨb ak Jisas ñɨg gol sɨŋak apɨl nɨgak, God man ne alaŋ mɨgan yɨkɨl yek, God Kawnan ne ak yawl gɨpkay tek wɨŋɨd apɨl nop lak. ");
INSERT INTO taw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lek, takaw olap God man ne alaŋ nɨb apɨl agak, Ñɨ anɨb ak, ñɨ mapen yad yɨbɨl agak. Nop nɨgen yɨp tep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ñɨn anɨb ak God Kawnan ne ak, Jisas nop poŋɨd man nep binɨb ma yelak nab okok amnak. Ne kɨcheki bɨawl ak ne Jisas nop gos ñen tap tɨmel gɨnɨmuŋ akaŋ agɨl poŋɨd amnak. ");
INSERT INTO taw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Poŋɨd amek, tap ñɨbɨl mel, yokɨp yɨbɨl yek ñɨn anep 40 amnak. Anɨgɨl yokɨp yɨbɨl yek, nop yuwan awl yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Anɨgek, bɨ tay yepɨs gep kɨcheki bɨawl ak, ne apɨl nop agak, Nad God Ñɨne mɨdɨl yɨl, kab awl okok age bilet tek tɨkɨlaŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Agek Jisas pen agak, Buk Baybol ak tɨkɨl agɨlak, Binɨb okok, kɨli tap mɨdup anep ñɨbɨl, kɨles ma dɨl nɨm, pel ma yenɨgabal agɨl tɨkɨlak agak. Pen God takaw agup ak mɨdupsek nɨŋɨd kɨdek gɨl nɨm, pel yenɨgabal agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Anɨb agek, kɨcheki bɨawl ak ne Jisas nop dad Jelusalem amɨl, dam God agnɨgep kal awl adek awl oklaŋ gɨlak amɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Buk Baybol ak tɨkɨl agɨlak, God ne agek, ensel ne okok nep kod mɨdtep gɨnɨgabal agɨl tɨkɨlak agak. Apyap pakɨnɨg ge, ñɨn kɨli ak nep dɨ yenɨgabal nɨm, kab tob nep puŋɨlɨnɨmuŋ tek ma lɨnɨgab agɨl tɨkɨlak agak. Anɨb ak, nad God Ñɨne mɨdɨl yɨl, pɨdeg lum ayaŋ lan agak. ");
INSERT INTO taw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Agek Jisas agak, Buk Baybol ak takaw ogɨnap sek tɨkɨl agɨlak, Chɨn Bɨawl God kɨles ne anɨgep tek ma mɨdeb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Agek, kɨcheki bɨawl ak ne Jisas nop tepayaŋ dɨl, dad dum awl alaŋ olap amɨl, lum awl ak man okok mɨdupsek yomɨl, tap teplep yɨbɨl kɨli okok yomak. ");
INSERT INTO taw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yomɨl nop agak, Nad kɨgom yɨmɨl yɨp agnɨgenɨgaban, yad tap anɨb okok mɨdupsek nep ñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Agek Jisas agak, Satan, nad ke okok amnoŋ agak. Buk Baybol ak tɨkɨl agɨlak, Bɨawl God nad ak nop nep kɨgom yɨmɨl agnɨŋɨd, wog nop anep gɨnɨmɨn agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Agek, kɨcheki bɨawl ak ne Jisas nop kelɨgɨl amek, ensel okok apɨl Jisas nop kod yelak. ");
INSERT INTO taw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pen Jisas takaw anɨb ak nɨgak, Jon Bɨ Ñɨg Pakñeb ak nop nag lɨlak. Nɨŋɨd, adɨkɨd Galili plopens amnak. ");
INSERT INTO taw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amɨl, taun Nasalet ma am yek, kelɨgɨl am yek taun Kapeneyam, Galili ñɨg cheb gol okok yek. Taun anɨb ak, Sebulun binɨb man kɨli ayɨp, Naptali binɨb man kɨli ayɨp nab okok yek. ");
INSERT INTO taw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas ne anɨgɨl am yek ak, bɨ God gos ñek agñeb Aysaya gɨnɨgab agɨl tɨkak tek nep gak. Ne tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun binɨb man kɨli ayɨp Naptali binɨb man kɨli ayɨp, man anɨb okok ñɨg cheb kanɨb ak wulep mɨdeb, ñɨg Jodan kɨd adaŋ mɨdeb agɨl tɨkak. Man anɨb okok, Galili plopens mɨgan okok mɨdeb, binɨb Juda mel okok kuŋay mɨdebal agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Binɨb man anɨb okok mɨdɨl, kɨsɨlɨm nab okok mɨdelak okok, mɨlek awl yɨbɨl ak nɨgɨlak agɨl tɨkak. Pen kɨsɨlɨm okok mɨdɨl kumnɨgel tek lak ak, mɨlek ak kɨlop apjakak agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas ñɨn anɨb ak jɨj gɨl, binɨb okok kɨlop takaw agñɨlɨg agak, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak, wulep mɨdeb agak. Anɨb ak tap si tap tɨmel gɨpɨm ak taynen anɨgɨpun agɨl kelɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pen Jisas Galili ñɨg cheb gol ak apɨl nɨgak, bɨ kubsal dep madɨlmal ak, kubsal dep asas ak dɨl, ñɨg nab okyaŋ yokɨl yelek. Bɨ madɨlmal anɨb ak, olap yɨb ne Saymon, yɨb nop Pita agelɨgɨpal. Pen olap nɨmam ne yɨb ak Edlu. ");
INSERT INTO taw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas kɨlopmɨŋal nɨŋɨd anɨb agak, Yɨp kɨdek gel nɨm, ñɨlop agñɨtep gen, binɨb dep omɨŋal ak yenɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Agek, won anɨb ak kubsal dep asas okok kelɨgɨl, Jisas nop kɨdek gɨlek. ");
INSERT INTO taw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pen won olap tapɨn amɨl nɨgak, bɨ madɨlmal ak, olap yɨb ne Jemis, olap nɨmam ne yɨb ak Jon ayɨp, nap kɨli Sepedi ayɨp bot mɨgan ak apɨlɨgon mɨdɨlɨg, kubsal dep asas okok pugɨlɨkak ak kopɨs kopɨs gɨl yelak. Jisas nɨŋɨd kɨlopmɨŋal suk agek, ");
INSERT INTO taw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","won anɨb ak bot ak sek nap kɨli ak sek kelɨgɨl, Jisas nop kɨdek gɨlek. ");
INSERT INTO taw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas Galili plopens nab okok ajɨl, Juda apnan gɨpal kal mɨgan okok amnak. Amɨl takaw agñɨlɨg, God binɨb dɨl kɨlop kod yenɨgab takaw teplep ak agñɨlɨg, binɨb tap gak okok sek, mɨñak gak okok sek gek suŋ laknɨŋ ajolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Anɨgek, Siliya plopens binɨb okok mɨdupsek takaw anɨb ak nɨŋɨd, binɨb kuŋay yɨbɨl tap keke gak okok dad apel, ne gek suŋ lak. Binɨb anɨb okok, ogɨnap mɨñak gak, ogɨnap tap gak, ogɨnap yul awl gak, ogɨnap wɨdɨn mayn apek apyap pakɨl jep dak, ogɨnap ñɨn tob kumak. Ne kɨlop mɨdupsek gek suŋ lak. Pen ogɨnap kɨcheki mulɨk sɨkak okok, agyokek mɨdtep gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pen binɨb kuŋay yɨbɨl, Galili plopens binɨb okok sek, Dekapolis plopens binɨb okok sek, Jelusalem binɨb okok sek, Judiya plopens binɨb okok sek, ñɨg Jodan kɨd adaŋ binɨb yelak okok sek, Jisas amnaknɨŋ kɨli kɨdek amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas ne binɨb kuŋay yɨbɨl anɨb okok nɨŋɨd, am dum alaŋ amɨl besɨgak. Besɨgek, bɨne okok nop yɨl apɨl, ");
INSERT INTO taw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kɨlop agñɨlɨg agak, ");
INSERT INTO taw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Binɨb kɨli ke gos nepal, God wɨdɨn mɨdup adek ak, tap tep ne ogɨnap ma mɨdebal okok, God kɨlop dɨl kod mɨdeb agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Binɨb chɨb gek chaŋ lɨpal okok, God kɨlop agdɨnɨgab agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Binɨb sayn kɨmɨgel mɨdebal okok, God ne lum awl mɨdupsek kɨlop ñɨnɨgab agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Binɨb ogɨnap yuwan awl mɨdɨl tap nen gek, ñɨg nen gek mɨdebal okok agak. Anɨb ak tek ak, binɨb God agak tek kɨles gɨl gos nepal okok, God kɨlop gek kɨli ne agak tek kɨdek gɨnɨgel tek lup agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Binɨb mapen nɨŋɨd dɨtep gɨpal okok, God kɨlop pen mapen nɨŋɨd dɨtep gɨnɨgab agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Binɨb chɨbol nab kɨli ayaŋ mɨdtep gɨpal okok, kɨli God nop wɨdɨn nɨgɨnɨgabal agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Binɨb jɨmñɨl yonɨgun agɨl nepal okok, God kɨlop ñapay yad agɨnɨgab agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Binɨb God agak tek kɨdek gel kɨlop gɨ tɨmel gɨpal okok, God kɨlop dɨl kod mɨdeb agak. Anɨb ak kɨlop tep yɨbɨl gek mɨñmɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nɨbi yɨp chɨgɨl mɨdem, binɨb okok kɨli nɨbop agjuwɨl, gɨ tɨmel gɨl, takaw tɨmel keke yepɨs agenɨgel, nɨbop tep yɨbɨl gek mɨñmɨñ gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bɨ God gos ñek agñeb bɨlel okok kɨlop, gɨ tɨmel anɨb ak nep gɨlak agak. Anɨb ak nɨbop abe gɨlaknɨŋ, tep yɨbɨl gek mɨñmɨñ awl yɨbɨl gɨnɨmɨb agak. God ne nɨbop pen dɨtep yɨbɨl gɨnɨgab, man ne alaŋ agak. Anɨb ak tep yɨbɨl gek mɨñmɨñ awl yɨbɨl gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas takaw olap agak, Nɨbi binɨb lum awl dek yɨdek kɨli tek mɨdebɨm agak. Pen dek ak yɨdek ne ak amenɨgab, taydɨl gel tepayaŋ yɨdek gɨnɨgab agak? Dek anɨb ak yokɨp mɨdeb, wog ma mɨdeb agak. Binɨb okok kɨli dɨyokel, taw dad amɨl apɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nɨbi binɨb lum awl mɨlek kɨli tek mɨdebɨm agak. Taun olap dum alaŋ mɨdɨl, we gɨnɨgel tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pen lam ak dagɨl tin muk okok ma lɨnɨgabal agak. Adek sɨŋak lel mɨlek gek, binɨb okok kal mɨgan anɨb ak mɨlek sek yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anɨb ak tek, nɨbi mɨlek tek gem, binɨb okok mɨlek anɨb ak nɨgɨnɨgel agak. Nɨŋɨd nɨm, tap tep gɨpɨm okok nɨŋɨd, Nap man ne alaŋ mɨdeb anop yɨb ak dad aplanɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas takaw olap agak, Takaw Mosis ñu kɨl tɨkak ak sek, bɨ God gos ñek agñeb kɨl tɨkɨlak okok sek dɨyokɨnɨg ma ownek agak. Gos anɨb ak ma nɨgɨnɨmɨb agak. Ak pen, yad ownek ak, takaw ñu kɨl tɨkɨlak okok gɨnɨgab agɨl agɨlak tek, mɨdupsek gɨnɨmuŋ agɨl ownek agak. ");
INSERT INTO taw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yad nɨbop nɨŋɨd agebin, Takaw Mosis ñu kɨl tɨkak ak ma kul gɨnɨgab, mɨd dad amɨl, wɨsɨp adekab alaŋ sek, lum awl sek pɨsnep kul gɨnɨgab ñɨn ak agak. Ñu kɨl awl okok abe sɨkol okok abe, ma kul gɨnɨgab agak. Takaw anɨb ak anɨgɨl yenɨgab, mɨd dad amɨl, tap gɨnɨgab anɨb okok mɨdupsek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Anɨb ak binɨb an God takaw adek ne won ak nɨŋɨd, takaw sɨkol won olap agɨl tɨbɨlɨkɨl, binɨb okok kɨlop tɨtɨmel agñek tɨbɨlɨkɨnɨgabal ak, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak, yɨb nop apyownɨgab agak. Pen binɨb an God takaw adek ne won ak nɨŋɨd, kɨdek gɨl, binɨb okok kɨlop agñɨ tep gek kɨdek gɨnɨgabal ak, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak, yɨb nop ak aplanɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anɨb ak tek nɨbop agebin, nɨbi bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek gɨpal tek genɨmɨb, God nɨbop dɨl kod ma yenɨgab agak. Kɨli gɨpal tek ma gɨnɨmɨb agak. Nɨbi pen gɨtep yɨbɨl gɨnɨmɨb ak nɨm, God nɨbop dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas takaw olap agak, Bɨlel God takaw ak olap agek, napɨs nased yes okok kɨli takaw anɨb ak nɨgɨlak ak, nɨbi nepɨm agak. Anɨb agolɨgup, Binɨb ma ñag lɨnɨmɨb agolɨgup agak. Binɨb olap, binɨb olap nop ñag lɨnɨgab ak, kot nɨgɨnɨgab agolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yad pen nɨbop agebin, Binɨb olap nɨmam ne nop mɨlɨk nɨgɨnɨgab ak, kot nɨgɨnɨgab agak. Pen binɨb an nɨmam ne nop agjuwenɨgab, bɨ Juda bɨawl takaw tɨg asɨkep okok apnan gɨl, nop agɨnɨgabal agak. Pen binɨb an nɨmam ne nop agɨnɨgab, Nad bɨ sawl sek yɨbɨl agɨnɨgab ak, mab ke yɨneb mɨgan ak amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Anɨb ak nad tap dam God nop sɨbogep abañ adek ak sɨbog ñɨnɨg, mam yad ayɨp penpen agɨlok tek takaw mɨdeb agɨl, ");
INSERT INTO taw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tap God nop sɨbog ñɨnɨgaban ak kelɨgɨnɨmɨn, abañ adek ak jɨj sɨŋak agak. Kelɨgɨl, ned am mam nad ayɨp takaw ag jɨmñɨl lɨl yenɨmil agak. Anɨgɨnɨmɨn ak pen, adɨkɨd apɨl tap anɨb ak God nop sɨbog ñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bɨ olap nep kot dad amebin agenɨgab, kot awl ak taynen amobun agɨl kanɨb nab okok amɨlɨg, kasek ne ayɨp takaw ag tɨg asɨk lɨtep gɨnɨmɨn agak. Pen mel ak, nep dam bɨawl takaw tɨg asɨkep ak nop ñek, ne pen nep dɨl bɨ nag lep ak nop ñek, nep dam nag lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yad nep nɨŋɨd agebin, nag lel yenɨgaban agak. Tap day nad okok pɨsnep day pag dɨl tek, seŋ amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas takaw olap agak, God takaw olap agak ak, nɨbi nepɨm agak. Anɨb agolɨgup, Binbɨ nɨbi dɨpɨm ak, bin si bɨ si ma gɨnɨmɨn agolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yad pen nɨbop agebin, bɨ olap bin olap nop nɨŋɨd, nop dɨpɨnep agɨl gos nɨgup ak, bɨ anɨb ak gos ne nab ayaŋ, tap si gup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pen wɨdɨn yɨpɨd pɨs nad ak nɨŋɨd, tap si tap tɨmel gep tek lonɨmuŋ, wɨdɨn pɨs kɨd anɨb ak tɨgju yokɨnɨmɨn agak. Wɨdɨn olap dɨyokenɨmɨn, tap tɨmel ma gɨnɨgaban ak, tap teplep yɨbɨl agak. Ma dɨyokɨnɨgaban ak, God ne nep mɨdupsek dad mab ke yɨneb ak amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pen ñɨn yɨpɨd kɨd nad ak, tap si tap tɨmel gep tek lonɨmuŋ, ñɨn yɨpɨd kɨd anɨb ak tɨbɨlɨk yokɨnɨmɨn agak. Ñɨn olap dɨyokenɨmɨn, tap tɨmel ma gɨnɨgaban ak, tap teplep yɨbɨl agak. Ma dɨyokɨnɨgaban ak, nad mɨdupsek mab ke yɨneb ak amnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas takaw olap agak, God takaw ak olap anɨb agolɨgup, Bɨ olap bin ne nop agyokɨnɨg, bin awl pɨsnep agyokebin agɨl, ñu kɨl bad olap tɨkɨl bin anɨb anop ñɨl nɨm, pɨsnep agyokɨnɨmuŋ agolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yad pen nɨbop agebin, bɨ olap bin ne ak bɨ si ma dup, pen nop yokɨp yɨbɨl agyokup ak, bɨ anɨb ak bin ne nop gek, ne amɨl bɨ olap dɨnɨgab agak. Pen ne bɨ olap nop dɨnɨgab ak, God ne nɨgek bin anɨb ak ne bɨ si dɨnɨgab agak. Pen bɨ tɨkjakɨl, bin agyokup anɨb ak nop dɨnɨgab ak, abe God ne nɨgek bɨ anɨb ak ne bin si dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas takaw olap tepayaŋ agak, Bɨlel God takaw ak olap agek, napɨs nased yes okok kɨli takaw anɨb ak nɨgɨlak ak, nɨbi nepɨm agak. Anɨb agolɨgup, God nop tap olap gɨnɨgayn agɨl, agɨnɨmɨb tek nep gɨnɨmɨb agolɨgup agak. Nop takaw nep ma agɨnɨmɨb agolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yad pen nɨbop agebin, nɨbi ñɨn dad aplanɨl takaw olap agɨnɨg, yad yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨl, takaw anɨgɨl ma agɨnɨmɨb agak. Pen nɨbi ñɨn dad aplanɨl God man ne alaŋ ak yomɨl, yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨl, takaw anɨgɨl ma agɨnɨmɨb agak. Ak God bɨawl besɨgep ne yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pen nɨbi ñɨn dad aplanɨl lum awl ak yomɨl, yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨl, takaw anɨgɨl ma agɨnɨmɨb agak. Ak God tob ne lep ak mɨdeb agak. Pen nɨbi ñɨn dad aplanɨl Jelusalem ak yomɨl, yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨl, takaw anɨgɨl ma agɨnɨmɨb agak. Ak Bɨawl kɨles tɨmel ak man awl ne yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pen nɨbi ñɨn dad aplanɨl kɨmɨg cheg ak yomɨl, yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨl, takaw anɨgɨl ma agɨnɨmɨb agak. Taynen? Nɨbi ke gem, kɨmɨg wɨj nɨbi ak sum akaŋ mosɨb jakɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nɨbi gɨnɨgayn agɨl, yaw nep agɨnɨmɨb agak. Pen ma gɨnɨgayn agɨl, mel nep agɨnɨmɨb agak. Pen ñɨn dad aplanɨl agɨnɨgabɨm, yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgabɨm ak, Satan nɨbop gos ñek anɨb agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas takaw olap agak, God takaw olap agak ak, nɨbi nepɨm agak. Anɨb agolɨgup, Bɨ olap ne bɨ olap ke wɨdɨn nop puŋɨl juwonɨmuŋ, nop pen abe puŋɨl junɨmɨb agolɨgup agak. Pen meg pak pagonɨmuŋ, nop pen abe pak pagɨnɨmɨb agolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yad pen nɨbop agebin, Bɨ olap nep gɨ tɨmel gonɨmuŋ, nop pen gɨ tɨmel ma gɨnɨmɨn agak. Bɨ olap mɨkem yɨpɨd pɨs nep ak pak sɨl gonɨmuŋ, adɨke pɨs kɨd ak abe pakɨnɨmuŋ tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pen bɨ olap nep kot gɨl, siglis nak ak yɨp saj gan agonɨmuŋ, siglis nep ma ñɨnɨmɨn agak. Kolsiyot ak sek ñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pen bɨawl olap nep kɨles gɨl agɨnɨmuŋ, Nad tap yad ak dɨl, poŋɨd man wulep sɨŋadaŋ dad amnɨmɨn agonɨmuŋ, man wulep sɨŋadaŋ nep dad ma amnɨmɨn agak. Nop gɨtep gin agɨl, poŋɨd man pal awl dad amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bɨ olap nep agɨnɨmuŋ, Yɨp tap ogɨnap ñan agonɨmuŋ, nop ñɨnɨmɨn agak. Pen bɨ olap nep agɨnɨmuŋ, Tap ogɨnap yokɨp ñan, kɨdek nep pen ñɨnɨgayn agonɨmuŋ, ma kelɨgɨnɨmɨn, nop ñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas takaw olap agak, God takaw olap agak ak, nɨbi nepɨm agak. Anɨb agolɨgup, Bogɨlak nɨbi okok kɨlop mapen lɨnɨmɨb agolɨgup agak. Pen binɨb nɨb ayɨp penpen ñagep okok, kɨlop mɨlɨk nɨgɨnɨmɨb agolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yad pen nɨbop agebin, binɨb nɨb ayɨp penpen ñagep okok kɨlop mapen lɨnɨmɨb agak. Pen binɨb nɨbop gɨ tɨmel gɨpal okok, nɨbi God nop agnɨgem kɨlop gɨtep gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Anɨgɨnɨgabɨm ak, Nap man ne alaŋ mɨdeb ak ñapay ne yɨbɨl yenɨgabɨm agak. Ne gek, sub ak tɨkjakɨl, binɨb gɨ tɨmel gɨpal okok sek, binɨb gɨtep gɨpal okok sek kɨlop pak tep gup agak. Pen ne gek, wɨsɨp apek, binɨb teplep yɨbɨl mɨdebal okok sek, binɨb tɨmel yɨbɨl mɨdebal okok sek kɨlop, man pak tep gup agak. Anɨb ak nɨbi binɨb okok kɨlop gɨtep genɨmɨb, Nap ñapay ne yɨbɨl yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bɨ takis dep okok, kɨli binɨb kɨlop mapen lɨpal okok nep pen mapen lɨpal agak. Nɨbi pen kɨli anɨgɨpal tek ma gɨnɨmɨb agak. Nɨbi binɨb nɨbop mapen lɨpal okok nep kɨlop pen mapen lenɨmɨb, God nɨbop tap teplep ñɨnɨgab akaŋ agak? Mel yɨbɨl, ma ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pen bogɨlak nɨbi okok nep kɨlop ag dɨdeg lenɨmɨb, tap teplep yɨbɨl ma gɨpɨm agak. Binɨb God takaw ak ma nepal okok, kɨli abe bɨ kɨli okok nep kɨlop ag dɨdeg lɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Anɨb ak Nap man ne alaŋ mɨdeb ak, ne bɨ teplep yɨbɨl mɨdeb tek, nɨbi abe binɨb teplep yɨbɨl yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas takaw olap agak, Pen nɨgɨm agak. Binɨb ogɨnap kɨli God agak tek kɨdek gon, binɨb ogɨnap sek chɨnop nɨgɨnɨgel chɨn yɨb awl dɨnɨgun agɨl gos nepal agak. Nɨbi pen anɨgɨl ma gɨnɨmɨb agak. Anɨgenɨgabɨm, Nap man ne alaŋ mɨdeb ak ne nɨbop tap teplep ma ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Anɨb ak, bɨ God nop gos nopun apal ak pen yepɨs yɨbɨl gɨpal okok, gɨpal tek ma gɨnɨmɨn agak. Kɨli ñɨn akal binɨb yɨmgeptek okok kɨlop tap ñɨnɨg, bɨ olap nop ned agyokel, amɨl wog kɨli gɨtep gɨnɨgebal okok ned agyɨkup agak. Agyɨkek, kɨli Juda apnan gɨpal kal binɨb kuŋay mɨdebal nab ak sek, kanɨb awl okok nep sek amɨl mani tap okok ñɨbal agak. Yɨb awl dun agɨl gɨpal anɨb ak, nad anɨb ak tek ma gɨnɨmɨn agak. Yad nɨbop nɨŋɨd agebin, yɨb kɨli dad aplanɨbal ak pen, kɨdek God kɨlop tap olap ma ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nad pen binɨb yɨmgeptek okok kɨlop tap ñɨnɨg, mɨseŋ ma ñɨnɨmɨn agak. Bɨ ak tap olap nop ñɨnɨg, ñɨn yɨpɨd kɨd ak ñɨnɨmuŋ, ñɨn aŋɨd kɨd ak ma nɨgɨnɨmuŋ agak. Akaŋ ñɨn aŋɨd kɨd ak ñɨnɨmuŋ, ñɨn yɨpɨd kɨd ak ma nɨgɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kɨmɨgel we gɨl ñɨnɨmɨn agak. Pen tap kɨmɨgel we gɨl gɨpan okok, Nap ne ke nɨgup ak nɨm, gɨpan anɨb ak nɨŋɨd nep pen ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas takaw olap agak, Pen ñɨn akal nɨbi God nop agɨnɨg, bɨ yepɨs yɨbɨl gɨpal okok, gɨpal tek ma gɨnɨmɨb agak. Kɨli binɨb ogɨnap chɨnop nɨgɨnɨgel yɨb awl dɨnɨgun agɨl, God nop apal agak. Juda apnan gɨpal kal binɨb kuŋay mɨdebal nab ak sek, kanɨbtam okok sek amɨl, mɨñmɨñ gɨlɨg jak mɨdɨl, God nop apal agak. Yad nɨbop nɨŋɨd agebin, yɨb kɨli dad aplanɨbal ak pen, kɨdek God kɨlop tap olap ma ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nad pen ñɨn akal God nop agɨnɨg, kal ñɨluk mɨgan nad ak amɨl, kanɨbtub gɨñɨl, kɨmɨgel we gɨl Nap nop agɨnɨmɨn agak. Pen kɨmɨgel we gɨl gɨpan ak, Nap ne ke nɨgup ak nɨm, takaw anɨb ak nɨŋɨd, nep pen ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pen nɨbi God nop agɨnɨg, binɨb God takaw ak ma nepal okok, gɨpal tek ma gɨnɨmɨb agak. Kɨli God nop agɨnɨg, takaw yokɨp monmon agɨl amub, palawl yɨbɨl apal agak. Gos kɨli ak takaw palawl agon, chɨnop nɨgɨnɨgab apal agak. ");
INSERT INTO taw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Anɨb ak, kɨli anɨgɨpal tek ma gɨnɨmɨb agak. Tap anɨb ak tay nɨbop tek dek Nap nop agnɨgɨnɨg gɨpɨm okok, ne ned gos nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Anɨb ak nop anɨgɨl agɨnɨmɨb, Bapi man nad alaŋ mɨdeban ak, bɨawl tep yɨbɨl mɨdeban ak, yɨb nad dad aplanɨmuŋ agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nad nep bɨnonɨm chɨn mɨdɨl, chɨnop dɨl kod yenɨmɨn agɨnɨmɨb agak. Man nad alaŋ age kɨli nɨŋɨd kɨdek gɨpal tek ak, lum awl ak abe age chɨn nɨŋɨd kɨdek gɨnɨgun agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tap mɨdup okok mɨñɨl ñɨbun tek ak chɨnop ñɨnɨmɨn agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pen binɨb ogɨnap chɨnop gɨ tɨmel gel nɨŋɨd kelɨgɨpun tek, nad tap si tap tɨmel chɨn gɨpun okok tɨg walɨg gɨyokɨnɨmɨn agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Chɨnop kod mɨde, gos olap apek chɨn gɨ tɨmel ma gɨnɨgun agɨnɨmɨb agak. Bɨ kɨcheki bɨawl ak apek, nad pen chɨnop ge chɨn ma apyap pakɨnɨgun agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nɨŋɨd apin agak. Binɨb okok nɨbop gɨ tɨmel gel nɨŋɨd kelɨgenɨmɨb, Bapi nɨbi man ne alaŋ mɨdeb ak, ne tap si tap tɨmel nɨbi gɨnɨgabɨm okok tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nɨbi pen binɨb okok nɨbop gɨ tɨmel gel nɨŋɨd ma kelɨgenɨmɨb, Bapi nɨbi ak pen tap si tap tɨmel nɨbi gɨnɨgabɨm okok ma tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas takaw olap agak, Ñɨn akal nɨbi tap ñɨŋeb kelɨgɨnɨg, bɨ yepɨs yɨbɨl okok gɨpal tek ma gɨnɨmɨb agak. Kɨli apal, mulɨk asɨlum sek mɨdon, binɨb chɨnop nɨgɨnɨgel apal agak. Chɨnop nɨŋɨd, anɨb agɨnɨgabal, Kɨli God nop gos nep nɨŋɨd, tap ñɨŋeb kelɨgɨl nɨm, mulɨk asɨlum sek lɨl mɨdebal agɨnɨgabal apal agak. Yad nɨbop nɨŋɨd agebin, yɨb kɨli dad aplanɨbal ak pen, kɨdek God kɨlop tap olap ma ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nɨbi pen tap ñɨŋeb okok kelɨgɨnɨg gɨnɨmɨb ak, mulɨk asɨlum sek lɨl ma yenɨmɨb agak. Jomulɨk ak ñɨg pak tep gɨñɨl, wel lɨñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Anɨgenɨgabɨm, binɨb ogɨnap nɨbop tap mɨdup bɨl gɨpal agɨl ma nɨgɨnɨgel agak. Nap nɨbi nep we gɨl mɨdeb ak nɨgɨnɨmuŋ agak. Pen kɨmɨgel we gɨl gɨpan ak, Nap ne ke nɨgup ak nɨm, gɨpan anɨb ak nɨŋɨd nep pen ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisas takaw olap agak, Lum awl tap teplep okok dɨl nan ma gɨnɨmɨb agak. Lum awl anɨb ak, kɨchɨl gɨlobɨd tap teplep okok pel su tɨkup, tu tap okok mok ñɨŋub agak. Pen bɨ si dep okok apɨl, kal ak paklakɨl si dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nɨbi pen tap teplep okok God man ne alaŋ nan gɨnɨmɨb agak. God man ne alaŋ anɨb ak, kɨchɨl gɨlobɨd tap teplep okok ma su tɨkup, tu tap okok mok ma ñɨŋub agak. Pen bɨ si dep okok apɨl, kal ak paklakɨl si ma dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tap teplep nad okok lum awl dɨ nan ge, gos nep ak yenɨgab lum awl agak. Pen man adek alaŋ dɨ nan ge, gos nep ak yenɨgab anɨb alaŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jisas takaw olap agak, Wɨdɨn ak sup tek mɨdeb ak nɨm, wɨdɨn nad mɨdtep gek, mubwak nad ak mɨdupsek mɨlek tep gɨl mɨdtep yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pen wɨdɨn nad mɨdtep ma gek, mubwak nad ak mɨdupsek kɨsɨlɨm owup tek ak yenɨgab agak. Anɨb ak nab nak pi okok kɨsɨlɨm bad ak mɨdeban tek lup, kɨsɨlɨm anɨb ak tap awl yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisas takaw olap agak, Bɨ nokom olap, ne bɨawl omɨŋal kɨlop wog gɨñɨnɨmuŋ tek ma mɨdeb agak. Taynen? Ne bɨawl olap nop dɨnɨgab, bɨawl olap nop kelɨgɨnɨgab agak. Akaŋ bɨawl olap nop nɨgek tep gɨnɨgab, bɨawl olap nop nɨŋɨd kud ñɨnɨgab agak. Anɨb ak tek, nɨbi God nop gos sek, tap lum ayaŋ yɨl gos sek, tap omɨŋal gɨl kɨlop wog gɨñɨnɨmuŋ tek ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisas takaw olap agak, Anɨb ak tek nɨbop agebin, tap akal nɨb dɨl tap mɨdup ñɨbɨl ñɨg ñɨbɨl yonɨgun, chech akal nɨb dɨl yɨmɨl yonɨgun agɨl, gos awl ak ma nɨgɨnɨmɨb agak. Nɨŋɨd apin, pel mɨdep nɨbi ak tap awl yɨbɨl agak. God nɨbop gɨlak ak, tap ñɨŋeb nep pɨyow nɨgɨnɨgel, chech nep pɨyow nɨgɨnɨgel agɨl ma gɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nɨb nepɨm, yawl okok tap yɨŋ ma yɨbal, tap ñɨŋeb okok ma tɨk dap nan gɨpal agak. Bapi nɨbi man ne alaŋ ak pen kɨlop tap ñɨl kod mɨdeb tap ñɨbal agak. Ne yawl tap yokɨp ak anɨgɨl gup, nɨbi pen binɨb yɨbɨl ak, taynen chɨnop ma kod yenɨgab agɨl gos kuŋay nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gos kuŋay nɨŋɨd, kumnɨg gɨnɨgab ñɨn ak kelɨgɨnɨgabɨm akaŋ agak? Nak tap lum awl yɨl ak gos kuŋay nɨgenɨgaban, ñɨn olap tapɨn yenɨgaban akaŋ agak? Mel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pen taynen chech tap okok gos kuŋay nepɨm agak? Nag mɨdup pulɨnɨg sum gup okok nɨŋɨd, gos nɨgtep gɨnɨmɨb agak. Chech tap okok wog kɨles gɨnɨgel tek ma lup ak pen, ");
INSERT INTO taw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","nag sum teplep yɨbɨl okok mɨdeb agak. Yad nɨbop agebin, bɨnonɨm Solomon tap kuŋay mɨdɨl chech teplep yɨbɨl yek ak pen, nag mɨdup mokayaŋ gɨñub anɨb ak tek, Solomon ne ma yek agak. ");
INSERT INTO taw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tap be okok jakup anɨb okok tap yokɨp, pel ma yenɨgab agak. Pel mɨdɨl mel, mɨñɨl tek mɨdɨl, tol tek tɨpagɨlɨl dagɨlɨnɨgabal agak. Pen God tap yokɨp anɨb okok gɨlɨl mokayaŋ gɨñub ak, taynen God chɨnop mokayaŋ ma gɨñɨnɨgab agɨl gos kuŋay nepɨm agak? Nɨbi God nop gos nepɨm ak sɨkol gup agak. ");
INSERT INTO taw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Anɨb ak tap akal nɨb ñɨŋɨnɨgun, ñɨg akal nɨb ñɨŋɨnɨgun, chech akal nɨb lɨnɨgun agɨl, gos awl ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Binɨb God takaw ak ma nepal okok, tap anɨb okok mɨdupsek dun agɨl gos awl anɨb ak tek nepal agak. Pen Bapi nɨbi man ne alaŋ mɨdeb ak, ne tap tɨtay nɨbop tek dup ak nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pen tap ned adek ak anɨgɨl mɨdeb, nɨbi God binɨb dɨl kɨlop kod yenɨgab ak gos kɨles gɨl, God agak tek kɨles gɨl kɨdek gɨnɨmɨb agak. Anɨgenɨgabɨm, tap okok mɨdupsek abe nɨbop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Anɨb ak tol taydɨl yonɨgun agɨl gos awl ak ma nɨgɨnɨmɨb agak. Tap tol gɨnɨgab, ak tol agak. Mɨŋel mɨñɨl ownɨgab ak, ñɨn mɨñɨl nep agak. ");
INSERT INTO taw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisas takaw olap agak, Nɨbi binɨb kɨlop takaw tɨmel ma agɨnɨmɨb agak. Chɨn binɨb tep agɨl, binɨb ogɨnap kɨlop gos tɨmel nɨgenɨgabɨm, takaw anɨb ak adɨkɨd nɨbop yɨl ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anɨb ak nɨm, nɨbi binɨb ogɨnap kɨlop gos tɨmel nɨgenɨgabɨm, God nɨbop pen anɨgɨl gos tɨmel nɨgɨnɨgab agak. Pen nɨbi binɨb okok kɨli gɨpal ak tɨg asɨkɨnɨgabɨm tek, God nɨbop pen anɨb ak tek tɨg asɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Taynen mab bog wɨdɨn nep pak yu gɨl mɨdeb ak nɨŋɨd agɨl mel, namam tap achɨp wɨdɨn nop mɨdeb anop nɨŋɨd apan agak? ");
INSERT INTO taw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Tɨtay dɨl anɨb apan, Tap achɨp wɨdɨn alaŋ mɨdeb, yad dɨyokin apan agak? Nad bɨ tay yepɨs apan agak. Nɨgan, mab bog wɨdɨn nep pak yu gɨl mɨdeb agak. Nad ned mab bog ak wɨdɨn nak alaŋ mɨdeb anɨb ak dɨyoke, wɨdɨn nep suŋ lek nɨgtep gɨl tek, kɨdek namam tap achɨp mɨdeb ak dɨyokɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God tap suŋtep ne okok, chen okok kɨlop ma ñɨnɨmɨb agak. Pen kubap mɨlep okok, chag yenɨgel wulep sɨŋak ma dɨyokɨnɨmɨb agak. Anɨgɨl genɨgabɨm, kɨli taw pag pakel amek, adɨkɨd apɨl nɨbop sunɨgabal agak. Takaw paladaŋ lɨl agak ak, jɨj ne anɨgɨl mɨdeb, Binɨb God takaw ma nɨgtep gɨpal okok, takaw teplep anɨb ak kɨlop ma agñeb. ");
INSERT INTO taw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisas takaw olap agak, Tap tay tek donɨmuŋ, God nop agnɨgem nɨbop ñɨnɨgab agak. Pen tap tay pɨyownɨmɨb ak abe dɨnɨgabɨm agak. Chɨnop kanɨb ak yɨkaŋ agɨl, pak gigu gem, yɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Taynen? Binɨb an God nop agnepal okok, apal tek gup agak. Tap pɨyowpal ak dɨpal agak. Pen kanɨb ak yɨkaŋ agɨl, pak gigu gel yɨkup agak. ");
INSERT INTO taw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nɨbi bɨ ñapay sek okok, ñapay olap bilet nen agek, bɨ an kab olap dɨl ñɨbɨkop akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Akaŋ pen, kubsal nen agek, yoy tɨmel olap ñɨbɨkop akaŋ agak? Ak anɨb ma gɨpɨkop agak. ");
INSERT INTO taw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nɨbi bɨ tep mel ak pen, ñapay nɨbi okok kɨlop tap tep nep ñɨbɨm agak. Anɨb ak tek nɨgtep gɨpɨm, Bapi nɨbi ne man ne alaŋ mɨdeb ak bɨ tep yɨbɨl ak, binɨb nop agnɨgel, kɨlop tap tep nep ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Anɨb ak tek, binɨb okok chɨnop gɨtep gɨnɨgel agɨl gos nepɨm tek nep, kɨlop anɨb anep gɨnɨmɨb agak. Takaw Mosis ñu kɨl tɨkak ak sek, bɨ God gos ñek agñeb okok ñu kɨl tɨkɨlak ak sek, jɨj nɨm anɨb ak agak. ");
INSERT INTO taw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jisas takaw olap agak, Kanɨbtub awl ak, kɨli mɨgan ayaŋ amɨl pɨsnep kul gɨnɨgabal ak, binɨb kuŋay yɨbɨl mɨseŋ nɨŋɨd, kanɨb awl anɨb ak teplep agɨl, mɨdupsek mɨgan ayaŋ abal agak. Anɨb ak nɨbi nɨgtep gɨl, pel mɨdep kanɨbtub sɨkol ak dɨl mɨgan ayaŋ amnɨmɨb agak. Kanɨb sɨkol ak koslam ajɨpal agak. Binɨb nokom nokom nep, kanɨb sɨkol pal anɨb ak pɨyow nɨŋɨd abal agak. ");
INSERT INTO taw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas takaw olap agak, Bɨ ogɨnap kɨli apal, Chɨn bɨ God gos ñek agñeb mɨdobun apal ak pen, yepɨs apal agak. Nɨbi pen gos nɨgtep gɨnɨmɨb, bɨ anɨb okok takaw kɨlop ma nɨgɨnɨmɨb agak. Chen ladek tek mɨdebal agak. Kɨli chag sipsip sayn tep tek sɨlok lɨl opal ak pen, chen ladek su lup tek ak nɨbop gɨnɨg opal agak. ");
INSERT INTO taw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tap tay gɨnɨgabal ak nɨŋɨd, kɨli bɨ tay tek mɨdebal ak nɨgtep gɨnɨgabɨm agak. Nɨb nepɨm, nag mɨgɨñem ñu tek okok, nag tep wayn mɨdup tek ma pulɨnɨgab agak. Mab ñuñu sek kubagas tek okok, mab tep pik tek ma pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Anɨb ak tek, mab teplep ak mɨdup tep okok pulɨnɨgab, mab tɨmel ak mɨdup tɨmel okok pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pen mab teplep ak mɨdup tɨmel okok pulɨnɨmuŋ tek ma lɨnɨgab, mab tɨmel ak mɨdup tep okok pulɨnɨmuŋ tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mab ak mɨdup tep ma pulɨnɨgab okok, tɨb dam mab yɨneb ak yokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Anɨb ak, bɨ kɨli tap tay gɨnɨgabal ak nɨŋɨd, kɨli bɨ tay tek mɨdebal ak nɨgtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Binɨb kɨli yɨp apal, Bɨawl chɨn nɨm nad nokom apal okok, God kɨlop mɨdupsek ma dɨl kod yenɨgab agak. Binɨb pen Bapi man ne alaŋ mɨdeb ak gos ne nɨgup tek kɨdek gɨpal okok, kɨlop nep dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ñɨn kɨdek ak apek, binɨb kuŋay yɨbɨl yɨp agɨnɨgabal, Bɨawl chɨn nɨm nad nokom, chɨnop gos ñe agñɨnok agɨnɨgabal agak. Pen chɨnop age, kɨcheki binɨb abaŋ lak okok agyokɨnok agɨnɨgabal agak. Pen chɨnop ge, tap mageptek kuŋay yɨbɨl okok gɨnok agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Agel, yad kɨlop pen agyɨkɨl agɨnɨgayn, Nɨbop pɨsnep ma nepin agɨnɨgayn agak. Nɨbi binɨb pel gɨ tɨmel yɨbɨl gɨpɨm okok, yɨp kelɨgɨl ke okok amnɨmɨb agɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas takaw olap agak, Bɨ olap takaw yad ak nɨŋɨd kɨdek gup ak, ne bɨ gos nɨgep yɨbɨl olap tek, kal ne ak man kɨles kab tek adek ak gak agak. ");
INSERT INTO taw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kɨdek man awl pakɨl, ñɨg wɨlɨk apɨl, yɨgen awl dɨl, tap anɨb okok kal anɨb ak pakak ak pen, kal ma pak juwak agak. Kal ne man kɨles kab tek adek ak gak anɨb ak nɨm, kal ma pak juwak agak. ");
INSERT INTO taw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pen bɨ olap takaw yad ak nɨŋɨd kɨdek ma gup ak, ne bɨ gos ma nɨgep yɨbɨl olap tek, kal ne ak kab kɨlup adek ak gak agak. ");
INSERT INTO taw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kɨdek man awl pakɨl, ñɨg wɨlɨk apɨl, yɨgen awl dɨl, tap anɨb okok kal anɨb ak pakak ak nɨm, kal ak pak juwak agak. Pɨsnep apyap pakɨl tɨmel gak agak. ");
INSERT INTO taw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas takaw anɨb okok agjuwek, binɨb kuŋay yɨbɨl ap yelak okok takaw agñub ak nɨŋɨd wal agɨl ");
INSERT INTO taw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","agɨlak, Ne bɨ yɨb sek, takaw nɨgtep yɨbɨl gɨl agup agɨlak. Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep chɨn okok apal tek ne ma agup agɨlak. Anɨb agɨlɨg gos pal awl lɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas dum alaŋ yek ak kelɨgɨl, gu ayaŋ apyowaknɨŋ, binɨb kuŋay yɨbɨl kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pen bɨ soy ladek lak olap, Jisas yek wulep sɨŋak apɨl, kɨgom yɨmɨl jel kuyan gɨl agak, Bɨawl, nad yɨp yɨmug nɨŋɨd, ge soy yad ak suŋ lɨnɨmuŋ, binɨb mɨdebal nab okok amnin agak. ");
INSERT INTO taw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Anɨb agek Jisas nop dɨnɨgɨlɨg agak, Nep gen suŋ lɨnɨgab agak. Agek, won anɨb ak nep soy ladek anɨb ak suŋ lek, mɨdtep gak. ");
INSERT INTO taw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Anɨgek, Jisas bɨ anɨb anop agak, Yɨp dɨnɨgek suŋ lup agɨl, bɨ olap ma agɨnɨmɨn agak. Bɨ Mosis bɨlel God takaw ak ñu kɨl tɨkak tek, nad anɨgɨnɨmɨn agak. Nad amɨl, bɨ God nop sɨbogep ak nop wak nad yoman agak. Yomɨl, soy ladek yad ak suŋ lup agɨl, tap olap God nop ñɨnɨmɨn agak. Ñe, bɨ okok kɨli soy ladek nad ak suŋ lup agɨl nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pen Jisas taun Kapeneyam amjakaknɨŋ, Lom bɨ chɨm kadɨŋ gep bɨawl olap apɨl, Jisas nop kɨles gɨl agnɨŋɨd agak, ");
INSERT INTO taw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bɨawl, bɨ wog gɨñeb yad anop tap awl gɨl, yul nebneb gup agak. Ñɨn tob kumɨl kaskas ma gɨl, kal ak kum mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Agek Jisas agak, Yad amɨl nop gen, suŋ lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Agek Lom bɨ chɨm kadɨŋ gep bɨawl anɨb ak agak, Bɨawl, yad bɨ tep mel, kal yad ak ownɨmɨn tek ma lup agak. Pen yad nepin, bɨawl yad ak, ne yɨb awl mɨdeb, yad nop muk okok mɨdebin agak. Yad pen, yɨb awl mɨdebin, bɨ chɨm kadɨŋ gep okok kɨli yɨp muk okok mɨdebal agak. Olap nop Amnoŋ agen, ne amub agak. Olap nop Owan agen, ne owup agak. Bɨ wog gɨñeb yad anop Anɨb ak gɨnɨmɨn agen, ne anɨb ak gup agak. Anɨb ak, suŋ laŋ agɨl takaw anep agenɨmɨn, bɨ wog gɨñeb yad tap gup anop suŋ lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Anɨb agek, Jisas nɨŋɨd gos pal yɨbɨl lɨl, binɨb nop kɨdek gɨl apelak okok kɨlop agak, Bɨ anɨb awl man olap nɨb ak pen, yɨp gos lɨnɨg mɨdɨl chɨg tep yɨbɨl gup agak. Binɨb Yislel nɨb okok pen, ne yɨp gos lɨnɨgup ak anɨb ak tek gos ma nepal agak. Yad nepin, mɨdupsek yɨp gos anɨb ak ma nepal agak. ");
INSERT INTO taw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pen yad nɨbop agebin, binɨb pal okok nɨb okok, ogɨnap sub lɨm gup okok ken apɨl, ogɨnap sub saŋɨd amub okok ken apɨl, kɨli ownɨgabal agak. Apɨl, God binɨb dɨl kɨlop kod yenɨgab nab ak mɨdɨl, mɨñmɨñ gɨlɨg tap ñɨbɨlɨg yenɨgabal agak. Kɨli Eblaham ayɨp, Aysak ayɨp, Jekop ayɨp mɨñmɨñ gɨlɨg tap ñɨbɨlɨg yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pen binɨb God kɨlop ned aglɨl, kɨlop dɨl kod yenɨgayn agɨl anɨgak okok, kɨlop agyokɨnɨgab agak. Seŋ kɨsɨlɨm owup adek ayaŋ agyokɨnɨgab agak. Tep anɨb ak, chaŋ tɨmel lɨl meg sulɨlɨg yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisas anɨb agɨl, Lom bɨ chɨm kadɨŋ gep bɨawl anɨb anop agak, Nad amnoŋ. Gos nepan anɨb ak tek nep gɨnɨgab agak. Anɨb agek, bɨ wog gɨñeb ne tap gak ak, won anɨb ak nep suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pen Jisas Pita kal mɨgan ayaŋ amɨl nɨgak, Pita bin nɨmak ne ak nop tap gɨl, wak okok mab tek yɨnek kum yek. ");
INSERT INTO taw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nɨŋɨd, amɨl ñɨn nop dɨnɨgek, suŋ lek tɨkjakɨl, Jisas nop tap mɨdup gɨlɨtep gak. ");
INSERT INTO taw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pen sub saŋɨd amnak won ak, kɨli binɨb kɨcheki abaŋ lak okok kɨlop kuŋay dad Jisas yek ak apelak, ne kɨcheki okok ag seŋ yokɨl, binɨb tap gak okok mɨdupsek kɨlop gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ne gak anɨb ak, bɨ God gos ñek agñeb Aysaya, ne ned gɨnɨgab agɨl tɨkak tek nep gak. Ne tɨkɨl agak, Tap tɨtay chɨnop tɨmel gup okok sek, tap chɨnop gup okok sek, mɨdupsek ne gek suŋ lup agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pen Jisas binɨb kuŋay apɨl nop puŋɨl kuskus gelak nɨŋɨd, bɨne okok kɨlop agak, Ñɨg cheb kɨd adaŋ amnun agak. ");
INSERT INTO taw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Anɨb agaknɨŋ, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep olap apɨl nop agak, Tisa, nad man akal akal amnɨgaban okok, yad ayɨp nep ajonɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Agek Jisas agak, Yad ayɨp koslam ajenɨgaban agak. Chen ladek okok kal kɨli kɨneb ak, lum mɨgan okok mɨdeb agak. Yawl okok kal kɨli ak ke mɨdeb agak. Pen Bɨ Olap Ñɨne kal kɨneb ne ak ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pen bɨne olap Jisas nop agak, Bɨawl, yɨp yaw age, yad ned bapi kumek nop kamɨl, nad ayɨp ajonɨgul agak. ");
INSERT INTO taw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Agek Jisas pen nop agak, Binɨb pel ma mɨdebal okok, chɨp kumeb anɨb okok kamnɨgel agak. Nad ape yad ayɨp ajonɨgul agak. ");
INSERT INTO taw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas bot dɨl amnɨg gek, bɨne okok ayɨp saŋɨdɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ñɨg nab sɨŋak amnɨlaknɨŋ, day yɨgen awl yɨbɨl ak dɨl, ñɨg pag apɨl, bot ak tɨg adɨkɨnɨg tek gak. Jisas pen ne kɨnek, ");
INSERT INTO taw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","bɨne okok ap nop kaskas gel tɨkjakek, agɨlak, Bɨawl, chɨn kumnɨgun tek lup, age kelɨgaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Agelak kɨlop agak, Taynen pɨlɨkebɨm? God nop gos nepɨm ak sɨkol gup agak. Anɨb agɨl tɨkjakɨl, kɨles gɨl agek, yɨgen awl dek ak sek, ñɨg pag apek ak sek kelɨgɨl, ned yek tek yek. ");
INSERT INTO taw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Anɨgek, kɨli gos pal awl yɨbɨl lɨl agɨlak, Bɨ anɨb awl bɨ tay tek mɨdeb agɨlak? Taydɨl agosup yɨgen awl dek ak sek, ñɨg pag apek ak sek agup tek kelɨgup agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pen Jisas ñɨg cheb tɨkɨl, man Gadala pɨs adaŋ amjakaknɨŋ, bɨ kɨcheki abaŋ lak omɨŋal ak, chɨp kamelɨgɨpal kab mɨgan okok nɨb apjakɨlek. Bɨ omɨŋal anɨb ak kɨlop kɨcheki abaŋ lak tek, bɨ kɨles yɨbɨl kabɨyam tɨmel yelɨgɨpil anɨb ak tek, binɨb olap yelɨgɨpil kanɨbtam anɨb ak ma amelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pen kɨli omɨŋal apjakɨl, Jisas nop suk agɨl agɨlek, God Ñɨne, chɨlop tay gɨnɨg opan agɨlek? Chɨnop gɨ tɨmel gɨnɨgabal ñɨn ak ma owup, chɨnop mɨñɨl gɨ tɨmel gɨnɨg opan akaŋ agɨlek? ");
INSERT INTO taw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pen chag kuŋay yɨbɨl amɨl ñɨbelak, ke yɨbɨl sɨŋalaŋ ak nɨm, ");
INSERT INTO taw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kɨcheki bɨ omɨŋal anɨb ak kɨlop abaŋ lak okok, Jisas nop nebneb gɨlɨg agɨlak, Chɨnop dɨyokɨnɨg genɨmɨn ak, agyoke am chag mɨdebal kɨlop nab ayaŋ mulɨk sɨkɨl amnun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Agelak, kɨlop agak, Amnɨm agek, bɨ omɨŋal anɨb ak kɨlop kelɨgɨl, am chag anɨb okok kɨlop mulɨk sɨkɨlak. Sɨkelak, chag okok pɨgju mɨduŋ ayaŋ amɨl, gɨdam ñɨg cheb nab ayaŋ pakɨl, ñɨg ñɨbɨl mɨdupsek kumɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pen bɨ chag mukep okok gak anɨb ak nɨŋɨd, pɨlɨkɨl kasek taun ak amɨl, bɨ kɨcheki abaŋ lak kɨlopmɨŋal gak takaw ak, tɨtay gak takaw ak mɨdupsek binɨb okok kɨlop agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Agñelak, binɨb taun anɨb ak kɨli mɨdupsek Jisas nop nɨgun agɨl, apɨl nop nɨŋɨd nebneb gɨlɨg agɨlak, Man chɨnop awl kelɨgɨl, ke okok amnoŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pen Jisas bot dɨl, ñɨg cheb tɨkɨl man ne kɨd adaŋ amjakak. ");
INSERT INTO taw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pen bɨ ogɨnap, bɨ ñɨn tob kumak olap Jisas gek suŋ lɨnɨgab agɨl, yɨl adek lɨl dad yek ak owlak. Pen Jisas gos kɨli ak nɨŋɨd, bɨ ñɨn tob kumak anɨb ak nop agak, Ñɨ yad, gos sek yenɨmɨn agak. Tap si tap tɨmel gɨpan okok tɨg walɨg gɨyokebin agak. ");
INSERT INTO taw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Anɨb agek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap nɨŋɨd, nab kɨli okok nep agɨlak, Bɨ nɨm awl God nop agjulɨg agosup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pen Jisas gos nɨgɨlak anɨb ak ne ke nɨŋɨd, anɨb agak, Nɨbi taynen yɨp gos tɨmel nɨgebɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yad tɨtay agen nɨbop tep gɨnɨgab agak? Bɨ anɨb ak nop tap si tap tɨmel gɨpan ak tɨg walɨg gɨyokebin agen nɨbop tep gɨnɨgab akaŋ, tɨkjakɨl amnoŋ agen nɨbop tep gɨnɨgab agak? Tay takaw nop agen nɨbop tep gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pen nɨgtep yɨbɨl gɨnɨmɨb agak. Takaw nop apin anɨb ak jɨj mɨdeb agak. Bɨ Olap Ñɨne God kɨles ak dɨl lum awl apɨl, tap si tap tɨmel gɨpal ak tɨg walɨg gɨyokeb agak. Anɨb agɨl, bɨ ñɨn tob kumak anop agak, Tɨkjakɨl, mɨj nak ak wɨnɨg dad kal nad amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Agek, tɨkjakɨl mɨj wɨnɨg dad kal ne amnak. ");
INSERT INTO taw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Amek binɨb kuŋay yelak okok nɨŋɨd, pɨlɨkɨl God yɨb nop dad aplanɨlak. Aplanɨlɨg agɨlak, God ne agek, bɨ okok kɨles ne ak dɨl yɨb awl dɨpal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pen Jisas wakay anɨb ak kelɨgɨl, amɨl nɨgak, bɨ takis dep ak, takis delɨgɨpal kal mɨgan besɨg yek. Yɨb ne ak Matyu. Jisas nop nɨŋɨd anɨb agak, Ape, yad ayɨp amnul agak. Agek, tɨkjakɨl ne ayɨp amnɨlek. ");
INSERT INTO taw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pen Jisas amɨl kal mɨgan ak besɨgɨl tap ñɨŋaknɨŋ, bɨ takis dep okok sek, bɨ tap si tap tɨmel gɨlak okok sek kuŋay apelak, Jisas ayɨp bɨne okok ayɨp jɨmñɨl besɨgɨl tap ñɨŋɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ñɨŋɨlaknɨŋ, bɨ Pelisi okok nɨŋɨd, Jisas bɨne okok kɨlop agɨlak, Tisa nɨbi ak, taynen bɨ takis dep mani si dɨpal okok sek, bɨ tap si tap tɨmel gɨpal okok sek ayɨp jɨmñɨl tap ñɨbebal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Agelak, Jisas takaw anɨb ak nɨŋɨd anɨb agak, Binɨb suŋ mɨdobun apal okok, dokta nop ma suk apal agak. Binɨb tap gup okok nep chɨnop gel suŋ laŋ agɨl, dokta okok kɨlop suk agel opal agak. ");
INSERT INTO taw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pen God takaw ñu kɨl tɨkɨlak olap, nɨbi am takaw jɨj ak nɨgtep gɨl nɨgɨlɨg yenɨmɨb agak. God ne anɨb agup, Yɨp tap sɨbog ñɨnɨmɨb agɨl gos ma nepin agup agak. Binɨb okok kɨlop mapen nɨgɨnɨmɨb agɨl gos nepin agup agak. Binɨb gɨtep gɨlɨg mɨdebal okok kɨlop suk agɨnɨg ma opin agak. Binɨb tap si tap tɨmel gɨpal okok kɨlop suk agɨnɨg opin agak. ");
INSERT INTO taw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ñɨn anɨb ak, Jon Bɨ Ñɨg Pakñeb ak bɨne okok, kɨli Jisas yek ak apɨl agɨlak, Chɨn ayɨp bɨ Pelisi okok ayɨp, ñɨn ogɨnap God gos anep nɨŋɨd tap ma ñɨbun ak pen, bɨ nad okok taynen anɨb ma gɨpal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Agelak, Jisas kɨlop agak, Juda binɨb gɨpun adek ak, bɨ bin dɨnɨg gɨnɨgab olap, ne apɨl nonɨm nap okok ayɨp mɨdɨl, chaŋ lɨlɨg tap ñɨŋeb kelɨgɨnɨgabal tek akaŋ agak? Mel yɨbɨl agak. Pen kɨdek ñɨn olap bɨ anɨb ak, bɨ ogɨnap nop dad amel, binɨb ne okok kɨli tap ma ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pen chech ned nɨb ak talɨkek, chech kɨdeyɨl nɨb olap tɨg talɨkɨl dap ñag ma dɨpal agak. Anɨgɨpal, keke yɨbɨl lɨl, chech ak tapɨn nep pugɨlɨkek amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pen ñɨg wayn ak abe agak. Ñɨg wayn koŋɨm ak dɨl, chag meme wak mɨlep mɨgan ak ma sopal agak. Taynen? Sogɨl kɨmjen ñenɨgabal, ak tan aplanel, bɨŋ tɨmel yɨbɨl agɨl puglɨkɨl sogɨnɨgab agak. Sogek, chag meme wak ak tɨmel gɨnɨgab agak. Anɨb ak nɨŋɨd, ñɨg wayn koŋɨm ak dɨl, chag meme wak koŋɨm mɨgan ak nep sog lep agak. ");
INSERT INTO taw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas takaw anɨb ak agaknɨŋ, Juda bɨawl olap yek sɨŋak apɨl kɨgom yɨmɨl agak, Pay yad ak pɨsnep kumosup ak pen, nad am nop dɨnɨge, tepayaŋ tɨkjakɨl amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Agek, Jisas tɨkjakɨl, bɨne ayɨp bɨ anɨb ak kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pen bin olap, bin kanɨb padɨkaknɨŋ yek, sap yeb anep umɨgan amnak. Anɨgek, gos ne anep nɨŋɨd, Jisas chech palawl lak ak nep dɨnɨgen yɨp suŋ lɨnɨgab agɨl, Jisas amnaknɨŋ kud okok yɨl apɨl, chech nop bad day okok dɨnɨgak. ");
INSERT INTO taw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dɨnɨŋɨd kelɨgek, Jisas tɨg adɨkɨl bin anɨb ak nop nɨŋɨd anɨb agak, Pay yad, nad gos sek yenɨmɨn agak. Yɨp gos gos lɨnepan tek, nep gek suŋ lup agak. Agek, tap nop golɨgup ak won anɨb ak nep suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pen Jisas am am, bɨawl kal ak amjakɨl nɨgak, akɨl pugɨlɨg, kɨli kuŋay chag lɨlɨg takaw pug kuŋay yɨbɨl agelak. ");
INSERT INTO taw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Anɨb ak nɨŋɨd kɨlop agak, Ke okok amnɨm agak. Pay anɨb awl ma kumub, yokɨp wɨsɨn kɨneb agak. Anɨb agek, nop yɨmel agelak ak pen, ");
INSERT INTO taw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kɨlop ag seŋ yokɨl, kal ñɨluk mɨgan ayaŋ amnak. Amɨl, pay kumak anop ñɨn kɨd ak dek, tepayaŋ tɨkjakak. ");
INSERT INTO taw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pen Jisas anɨgek, takaw anɨb ak yɨg dad man okok mɨdupsek amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pen Jisas wakay anɨb ak kelɨgɨl amnaknɨŋ, bɨ wɨdɨn koy omɨŋal ak nop kɨdek gɨlɨg suk agɨlɨg agɨlek, Depid Ñɨne, chɨlop mapen nɨŋɨd dɨtep gɨnɨmɨn agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anɨb agelek, Jisas ne kal mɨgan ak amek, bɨ omɨŋal anɨb ak Jisas yek ak apel, kɨlopmɨŋal agak, Ñɨli bɨ omɨŋal, chɨlop gek suŋ laŋ agɨl gos nepil akaŋ agak? Agek agɨlek, Yaw. Chɨl nopul, nad chɨlop genɨgaban suŋ lɨnɨgab agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Agelek, Jisas wɨdɨn kɨlopmɨŋal ak dɨnɨŋɨd agak, Yɨp gos lɨnepil ak, apil tek gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Agek, wɨdɨn kɨlopmɨŋal ak suŋ lek nɨgelek, kɨlopmɨŋal kɨles gɨl agak, Anɨgek chɨlop suŋ lup agɨl, binɨb okok takaw anɨb ak ma yɨbɨl agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anɨb agak ak pen, kɨli omɨŋal amɨl binɨb man nab anɨb ak mɨdupsek agñɨlek. ");
INSERT INTO taw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pen kɨli Jisas nop kelɨgɨleknɨŋ, binɨb ogɨnap kɨli bɨ kɨcheki abaŋ lek takaw agep tek ma lak olap, dad Jisas yek ak owlak. ");
INSERT INTO taw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Apelak, kɨcheki nop abaŋ lak anɨb ak agyokek, takaw agak. Anɨgek, binɨb kuŋay anɨb okok gos pal lɨl wal agɨl agɨlak, Man Yislel awl, tap anɨb ak tek ned ma yɨbɨl anɨgak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pen bɨ Pelisi okok agɨlak, Ne kɨcheki walɨjpal tap okok bɨawl kɨli kɨles ak dɨl nɨm, kɨcheki okok agyokeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pen Jisas ne taun okok sek, man sɨkol okok sek mɨdupsek gɨ ajɨlɨg, Juda apnan gɨpal kal mɨgan okok amɨl takaw agñak. Agɨlɨg, God binɨb dɨl kɨlop kod yenɨgab takaw teplep ak agñɨlɨg, binɨb tap gak okok sek, mɨñak gak okok sek mɨdupsek gek suŋ laknɨŋ ajolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pen binɨb kuŋay anɨb okok kɨlop nɨgak, kɨli chag sipsip okok bɨ mukep kɨli olap ma mɨdeb tek ak yelak. Gos kuŋay nɨŋɨd koslam yelak, anɨb ak kɨlop chɨb nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","bɨne okok kɨlop agak, Tap wog ak kuŋay yɨbɨl nep mɨdeb ak pen, binɨb tap pɨpag dad owep okok nep kuŋay ma mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Anɨb ak bɨ wog day nap nɨb anop agnɨgem, binɨb tap pɨpag dad owep ogɨnap agyokek, am pɨpag dad ownɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas bɨne anep umɨgan ak suk agek apel agak, Yad ke nɨbop agen, kɨcheki okok agyokɨl, binɨb tap tɨtay gak okok sek, mɨñak gak okok sek kɨlop gem, suŋ lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pen bɨ Jisas takaw nop dad ameb anep umɨgan anɨb ak, yɨb kɨli nɨm. Olap ned Saymon, yɨb nop Pita agelɨgɨpal. Olap Edlu, ne Pita nɨmam ne ak. Olap Jemis, ne Sepedi ñɨne. Olap Jon, ne Jemis nɨmam ne ak. ");
INSERT INTO taw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Olap Pilip. Olap Batolomyu. Olap Tomas. Olap Matyu, ne bɨ takis dep ak. Olap Jemis, ne Alpiyus ñɨne. Olap Tadiyus. ");
INSERT INTO taw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Olap Saymon, bɨ Selot agelɨgɨpal okok bɨ kɨli olap. Olap Judas Yiskaliyot, ne nɨm kɨdek Jisas nop mɨmug nɨgak. ");
INSERT INTO taw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas bɨne anep umɨgan anɨb ak kɨlop takaw anɨb agak, Nɨbi binɨb Juda mel nab okok ma amnɨmɨb agak. Pen Samaliya binɨb taun kɨli okok mɨgan ayaŋ ma amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nɨbi pen am binɨb Yislel jɨj ak kɨlop amnɨmɨb agak. Kɨli chag sipsip kul gep tek mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Amnaknɨŋ, agñɨlɨg agɨnɨmɨb, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak, wulep mɨdeb agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Binɨb tap gup okok gem suŋ lɨl, binɨb pɨsnep kumub okok agem tepayaŋ tɨkjakɨl, binɨb soy ladek lup okok gem suŋ lɨl, binɨb kɨcheki abaŋ lup okok agyokem amnɨgel agak. Yad nɨbop kɨles pel yokɨp ñɨbin tek, nɨbi binɨb anɨb okok kɨlop yokɨp wog gɨñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gol, silpa, mani tap okok dɨl dad ma amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kanɨb amnɨgabɨm ñɨn ak, wad, chech omɨŋal, tob tɨlup, yɨl kodɨm tap okok, dad ma amnɨmɨb agak. Taynen? Bɨ wog gɨñɨbal okok, binɨb okok kɨlop pen tap ñel ñɨŋɨnɨgel agak. Anɨb ak tek, pen nɨbop abe tap ñel ñɨŋɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pen taun akaŋ, man sɨkol olap amjakɨl, bɨ nɨbop agdɨnɨmuŋ tek olap pɨyow nɨŋɨd, ne ayɨp nep mɨdɨl, taun olap ke amnɨg nep nop kelɨgɨl amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kal anɨb ak mɨgan ayaŋ amɨl, anɨb agɨnɨmɨb, God nɨbop kod yonɨmuŋ agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Binɨb kal anɨb ak nɨbop dɨl gɨtep genɨgel, nɨbi God nop agnɨgem, binɨb kal anɨb ak kɨlop kod mɨdtep gɨnɨmuŋ agak. Kɨli pen nɨbop ma dɨl gɨtep ma genɨgel, nɨbi God nop agnɨgem, kɨlop ma gɨtep gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pen bɨ an nɨbop ma agdɨl, takaw nɨbop ma nɨŋɨd dɨnɨmuŋ, nɨbi kal anɨb ak akaŋ taun anɨb ak kelɨg amnɨg, sɨlkul dayday tob nɨbop dup ak wik yokɨl amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yad nɨbop nɨŋɨd agebin, God kot awl gep ñɨn ak, taun Sodom taun Gomola binɨb tɨmel okok, kɨli mɨŋel dɨnɨgabal agak. Pen binɨb taun nɨbop ma dɨnɨgabal anɨb okok, mɨŋel awl yɨbɨl ak dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas takaw olap agak, Nɨgɨm. Yad nɨbop chag sipsip tek ak agyokebin, binɨb chen ladek tek mɨdebal nab okok agak. Anɨb ak gos nɨgtep gɨlɨg, kɨmɨgel gɨtep gɨl yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pen bɨ tɨmel ogɨnap nɨbop chɨchɨk dɨl, dam Juda bɨawl kɨli yelak okok kot gɨl, Juda apnan gɨpal kal ak dad amɨl nag dɨl nɨbop pakɨnɨgabal agak. Anɨb ak nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pen yɨp yɨl mɨdebɨm tek, lɨpɨg gapman bɨawl okok sek, gapman bɨnonɨm okok sek yenɨgabal okok nɨbop dad amnɨgabal agak. Amel, takaw tep yad ak, bɨawl anɨb okok sek, bɨ Juda mel okok sek kɨlop agñɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Pen nɨbop kot gɨnɨgabal anɨb ak, gos kuŋay ma nɨgɨnɨmɨb agak. Won anɨb ak owaknɨŋ, God ne nɨbop gos ñek takaw anɨb ak agɨnɨmɨb agak. Anɨb apin, Nap Kawnan ne ak nɨbop gos ñek, takaw anɨb ak nɨbi ke ma agɨnɨgabɨm, Nap Kawnan ne ak agɨnɨgab agak. Anɨb ak takaw tɨtay agɨnɨgun akaŋ, kɨlop pen takaw tay ak dɨl agɨnɨgun agɨl, gos ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pen nɨmam ogɨnap tɨkjakɨl, nɨmam ogɨnap kɨlop ñag lɨnɨgel agɨl, dam bɨawl okok kɨlop ñɨnɨgabal agak. Nap okok tɨkjakɨl, ñapay kɨli ke okok kɨlop ñag lɨnɨgel agɨl, dam bɨawl okok kɨlop ñɨnɨgabal agak. Ñapay okok tɨkjakɨl, nonɨm nap sɨkop kɨlop mɨlɨk nɨŋɨd, ñagɨnɨgel agɨl dam ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yad yɨl yenɨgabɨm tek nɨŋɨd, nɨbop mɨlɨk nɨgɨnɨgabal ak pen, binɨb an kɨles gɨl yad yɨl yenɨgab, mɨd dad amɨl ñɨn kɨdek ownɨgab ak, God nop tɨg asɨk dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pen taun olap amem, nɨbop gɨ tɨmel genɨgel, taun olap pen pɨlɨk amnɨmɨb agak. Yad nɨbop nɨŋɨd agebin, Yislel binɨb kɨlop sayn yɨbɨl agñem amnaknɨŋ, Bɨ Olap Ñɨne ak ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sikul binɨb olap am sikul agup won ak, tisa ne ak nop ma taw dap yap lup agak. Pen bɨ wog gɨñeb ak, ne bɨawl ne ak nop ma taw dap yap lup agak. ");
INSERT INTO taw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Anɨb ak tek, bɨ sikul okok kɨli bɨ tisa kɨli ak tek yenɨgabal, anɨb ak tep yɨbɨl agak. Pen bɨ wog gɨñeb okok kɨli bɨawl kɨli ak tek yenɨgabal, anɨb ak tep yɨbɨl agak. Bɨ kal nap nɨb yɨb nop Belsebul apal ak tek, binɨb ne okok kɨlop yɨb tɨmel yɨbɨl ak lɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas takaw olap agak, Pen takaw tay mɨñɨl yu gɨl mɨdeb ak, kɨdek mɨseŋ yenɨgab agak. Tap tay kɨmɨgel we gɨpal okok, kɨdek nɨgtep gɨnɨgabal agak. Anɨb ak binɨb anɨb okok kɨlop nɨŋɨd ma pɨlɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Takaw nɨbop maynab ayaŋ apin okok, nɨbi subnab ak agɨnɨmɨb agak. Takaw kɨmɨgel kal mɨgan nepɨm okok, kal adek alaŋ amɨl, binɨb okok kɨlop agyɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nɨbi binɨb sɨj tɨmel pakɨpal okok kɨlop nɨŋɨd ma pɨlɨkɨnɨmɨb agak. Kɨli yokɨp mubwak anep paklɨnɨgabal, kawnan ak sek gɨ tɨmel gɨnɨgel tek ma lup agak. Pɨlɨkɨnɨg nɨm, Bɨawl ak ne binɨb kawnan ak sek, mubwak ak sek gɨ tɨmel gɨl, mab ke yɨneb dɨyokɨnɨgab ak nop pɨlɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Chɨn nopun, yawl sɨkol okok, mani sɨkol sɨkol nep tawɨl won omɨŋal nep dɨpal agak. Yawl anɨb okok kɨli tap yokɨp ak pen, Bapi kɨlop nɨg mɨdeb ak, yokɨp ma yap pakɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pen kɨmɨg wɨj nɨbop abe, God ne mɨdupsek ñɨn pagup anɨb ak, gos sek yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Anɨb ak ma pɨlɨkɨnɨmɨb agak. Nɨbi binɨb okok, binɨb yɨbɨl agak. Yawl sɨkol okok tek ma mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas takaw olap agak, Anɨb ak binɨb an Jisas yɨl mɨdebin agɨl, binɨb mɨdebal nab ak takaw anɨb ak agyɨkɨnɨgab ak, nop pen yɨp yɨl mɨdeb agɨl, Bapi man ne alaŋ mɨdeb ak nop takaw anɨb ak agyɨkɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pen binɨb an Jisas yɨl ma mɨdebin agɨl, binɨb mɨdebal nab ak anɨb agɨnɨgab ak, nop pen yɨp yɨl ma mɨdeb agɨl, Bapi man ne alaŋ mɨdeb ak nop anɨb agɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas takaw olap agak, Yad lum awl opin ak, binɨb kɨmɨgel mɨdtep gɨl dɨ jɨmñɨnɨg owup agɨl, gos ak ma nɨgɨnɨmɨb agak. Gos anɨb ak nɨgɨlɨg ma opin agak. Yad opin ak, binɨb okok gos adek keke nɨŋɨd penpen gɨnɨgel agɨl opin agak. ");
INSERT INTO taw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Anɨgɨpin tek, ñɨ ak tɨkjakɨl nap ne asɨk keke lɨl penpen gɨnɨgayl agak. Pen pay ak tɨkjakɨl nonɨm ne asɨk keke lɨl penpen gɨnɨgayl agak. Pen bin ak tɨkjakɨl, bɨne nonɨm ak asɨk keke lɨl penpen gɨnɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anɨgɨnɨgabal anɨb ak, binbɨ ñapay kɨli ke yenɨgabal anɨb ak penpen pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Binɨb an nonɨm akaŋ nap akaŋ nop mapen awl lɨl, yɨp pen mapen sɨkol lɨl gup ak, binɨb yad tek ma lup agak. Binɨb an ñɨ akaŋ pay akaŋ nop mapen awl lɨl, yɨp pen mapen sɨkol lɨl gup ak, binɨb yad tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Binɨb an mab bak kumak chɨn ak dad ajɨl, yɨp kɨdek ma gup ak, binɨb yad tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Binɨb an ne ke mɨdɨl, mɨdtep gɨnɨgayn agɨnɨgab ak, kɨdek mɨd tɨmel gɨnɨgab agak. Pen binɨb yɨp dɨl, yɨp tap tay gɨnɨgab takaw ma mɨdeb agɨnɨgab ak, kɨdek mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas takaw olap agak, Binɨb an nɨbop dup ak, nɨbop ke mel agak. Yɨp sek dup agak. Pen yɨp dup ak, yɨp nokom mel, bɨ yɨp agyokek ownek anop sek dup agak. ");
INSERT INTO taw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Binɨb olap ne bɨ God gos ñek agñeb olap nop nɨŋɨd, dɨl dɨtep gɨnɨgab ak, God ne binɨb anɨb ak nop dɨtep gɨnɨgab agak. God ne bɨ God gos ñek agñeb okok kɨlop tap teplep ñub tek, binɨb anɨb ak nop abe ñɨnɨgab agak. Binɨb olap ne bɨ teplep yɨbɨl olap nop nɨŋɨd, dɨl dɨtep gɨnɨgab ak, God ne binɨb anɨb ak nop dɨtep gɨnɨgab agak. God ne bɨ teplep yɨbɨl okok kɨlop tap teplep ñub tek, binɨb anɨb ak nop abe ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pen yad nɨbop nɨŋɨd agebin, binɨb an bɨyad yɨb ma mɨdeb olap nop nɨŋɨd, Jisas bɨne mɨdeb agɨl ñɨg takɨl nop ñub ak, God nɨgek tep gek, tap teplep pen ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas bɨne anep umɨgan ak kɨlop, anɨgɨl gɨnɨmɨb agɨl agñɨtep gak. Agjuwɨl, ne man anɨb ak kelɨgɨl, taun kɨli okok ajɨlɨg, binɨb okok kɨlop takaw agñak. ");
INSERT INTO taw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pen Jon Bɨ Ñɨg Pakñeb ak ne nag lɨ mɨdɨl, Klays tɨtay gak takaw ak nɨŋɨd, bɨne ogɨnap agyokak. Agyokek, Jisas yek ak amɨl, ");
INSERT INTO taw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nop agnɨŋɨd agɨlak, Nad Bɨ God nop aglup ak opan akaŋ, bɨ anɨb ak ke kod yonɨgun agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Agelak Jisas kɨlop agak, Nɨbi adɨkɨd amɨl Jon nop agɨnɨmɨb, Chɨn amɨl nopun, ");
INSERT INTO taw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bɨ anɨb ak binɨb wɨdɨn koy gup okok gek wɨdɨn yɨbɨl lup agɨnɨmɨb agak. Binɨb tɨmud sawl lup okok gek takaw nepal agɨnɨmɨb agak. Binɨb tob tɨmel gup okok gek kanɨb aj tep gɨpal agɨnɨmɨb agak. Binɨb soy ladek lup okok gek mɨlep gup agɨnɨmɨb agak. Binɨb kubal okok gek tepayaŋ tɨkjakɨpal agɨnɨmɨb agak. Binɨb yɨmgeptek okok abe God takaw teplep ak agek nepal agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pen takaw olap agɨnɨmɨb, Binɨb yɨp nep gos lɨnɨŋɨd, chɨgɨl mɨdebal okok, kɨlop tep gek mɨñmɨñ gɨnɨgel agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Anɨb agek, Jon bɨne okok amnɨlak. Amnɨlaknɨŋ, Jisas binɨb ap yelak okok kɨlop, Jon anɨgak ak agñak. Anɨb agak, Nɨbi ned man nep binɨb ma yelak nab okok abek ñɨn ak, tay gɨnɨg abek agak? Sɨd pal nokom olap yɨgen dad amɨl apɨl gup ak nɨgɨnɨg abek agak? ");
INSERT INTO taw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Akaŋ taynen abek agak? Bɨ chech teplep lup olap nɨgɨnɨg abek agak? Mel ak agak. Chɨn nopun, bɨ chech teplep lɨpal okok, gapman bɨnonɨm kal kɨles tɨmel okok kɨnɨbal agak. ");
INSERT INTO taw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pen tap tay ak nɨgɨnɨg abek agak? Yokɨp ma abek, bɨ God gos ñek agñeb ak nɨgɨnɨg abek agak. Bɨ God gos ñek agñeb anɨb ak, bɨ yokɨp mel agak. Bɨ God gos ñek agñeb okok anɨb nep yelak ak pen, Jon ne bɨ anɨb okok kɨlop sɨlawak agak. God wog awl gɨnɨg owak agak. ");
INSERT INTO taw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bɨ anɨb anop Jon, bɨlel buk Baybol ayaŋ ñu kɨl tɨkɨl agɨlak, God ne Ñɨne nop agup, Nɨgan, bɨ takaw dad ameb yad ak agyoken, ned amɨl kanɨb pɨdɨl kod yek, kɨdek nep agen amnɨgaban agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yad nɨbop nɨŋɨd agebin, binɨb ned lum awl yelɨgɨpal okok ayɨp, mɨñɨl mɨdebal okok ayɨp, Jon ne kɨlop mɨdupsek sɨlawɨl, yɨb mɨdeb agak. Ak pen, binɨb yokɨp God ne kɨlop dɨl kod mɨdeb okok, kɨli Jon nop sɨlawɨl, yɨb awl mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon Bɨ Ñɨg Pakñeb apɨl takaw tep agñak ñɨn ak tɨkɨl, mɨd dad amɨl, bɨ sɨj tɨmel pakɨpal okok, kɨli God binɨb ne okok kɨlop dɨnɨgabun agɨl gos nepal agak. Bɨ anɨb okok kɨlop pakɨl, mɨŋel kuŋay yɨbɨl ñɨbal agak. ");
INSERT INTO taw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Takaw Mosis ñu kɨl tɨkak ak sek, bɨ God gos ñek agñeb okok ñu kɨl tɨkɨlak ak sek, kɨli God takaw ak agñolɨgup agak. Takaw anɨb ak ag dad apel apel nɨm, Jon owak agak. ");
INSERT INTO taw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pen takaw agɨnɨgebin ak dɨnɨgabɨm akaŋ ma nepin agak. Buk Baybol tɨkɨl agɨlak, Bɨ God gos ñek agñeb Yilayja ownɨgab agɨl tɨkɨlak ak, takaw anɨb ak Jon ownɨgab agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɨbi binɨb tɨmud sek okok, takaw anɨb ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Yad nepin, binɨb mɨñɨl ñɨn awl mɨdebal okok, ñapay sɨkol ogɨnap tek mɨdebal agak. Ñapay sɨkol okok, kɨli sɨlpɨŋ ñɨlɨg ogɨnap apal, Dachɨŋ pakon, taynen kɨgom ma papɨm apal agak. Pen kɨmep chɨb gek tek agon, taynen chaŋ ma lɨpɨm apal agak? Gɨpal tek ak binɨb mɨñɨl mɨdebal okok kɨli gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon apɨl tap ma ñɨbɨl ñɨg wayn ma ñɨbɨl gek, nop apal, Bɨ kɨcheki walɨjpal mulɨk sɨkek mɨdeb ak apal agak. ");
INSERT INTO taw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pen Bɨ Olap Ñɨne apɨl, tap ñɨbɨl ñɨg wayn ñɨbɨl gek, nop apal, Nɨgɨm, tap kuŋay ñɨbɨl ñɨg wayn kuŋay ñɨbɨl gup apal agak. Ne bɨ takis dep okok sek, binɨb tap si tap tɨmel gɨpal okok sek, bɨ kɨli apal agak. Pen binɨb God takaw gos nɨgtep gek ak, kɨlop yomek nepal, God gos ne ak nag pal tek mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas taun ogɨnap ned ajɨl, tap mageptek kuŋay pel gek nɨgɨlak ak pen, tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl ma kelɨgɨlak. Anɨgelak nɨm, ñɨn anɨb ak Jisas kɨlop ag gɨl, takaw awl yɨbɨl agɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Taun Kolasin binɨb okok sek, taun Betsayda binɨb okok sek, yad tap ogɨnap gen, nɨŋɨd kelɨgɨpɨm tek, nɨbi yul awl yɨbɨl dɨnɨgabɨm agak. Pen taun Taya binɨb okok sek taun Saydon binɨb okok sek, tap mageptek anɨb okok ned tek gek nepɨlap ak, tap tɨmel kelɨgɨpɨlap agak. Kelɨgɨl, chech talɨk yowak ogɨnap yɨmɨl, mab tun sɨŋak besɨgɨl, tun dɨlɨg dɨlɨg mɨdebɨlap agak. ");
INSERT INTO taw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anɨb ak tek yad nɨbop agebin, God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, Taya binɨb sek Saydon binɨb sek okok kɨli yul sɨkol olap tek dɨnɨgabal agak. Pen nɨbi Kolasin binɨb sek Betsayda binɨb sek okok yul awl yɨbɨl ak dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pen nɨbi taun Kapeneyam binɨb okok abe, God man ne alaŋ ma amnɨgabɨm, God nɨbop pɨsnep mab ke yɨneb kaw mɨgan ayaŋ dɨyokɨnɨgab agak. Pen taun Sodom binɨb okok sek, tap mageptek anɨb okok ned tek gek nepɨlap ak, taun Sodom ak mɨñɨl nep yobɨkop agak. ");
INSERT INTO taw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Anɨb ak tek yad nɨbop agebin, God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, Sodom binɨb okok kɨli yul sɨkol olap tek dɨnɨgabal agak. Pen nɨbi Kapeneyam binɨb okok yul awl yɨbɨl ak dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Won anɨb ak Jisas agak, Bapi, nad Bɨawl man nad alaŋ sek lum awl sek kod mɨdeban ak, gos nad ak ke nɨge tep gup adek ak gɨpan agak. Binɨb chɨn binɨb awl gos tɨpagɨl nopun apal okok kɨlop nɨŋɨd, gos tep nad ak dɨ we gɨpan agak. Binɨb chɨn gos tep ma mɨdobun, ñapay sɨkol tek mɨdobun apal okok kɨlop dɨl, gos tep ñɨban ak, nep tep agebin agak. ");
INSERT INTO taw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bapi tap ne ak mɨdupsek yɨp ñub agak. Binɨb okok Ñɨ ak ma nepal, Bapi ne nokom nop nɨgup agak. Pen Bapi nop abe binɨb okok ma nepal, Ñɨ anɨb ak ne nop nɨgup agak. Pen Ñɨ ak ne binɨb gos tep ñin agɨl nɨgup okok gos tep ñɨnɨmuŋ, Bapi nop nepal agak. ");
INSERT INTO taw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Anɨb agɨl agak, Nɨbi binɨb wog kɨles gɨl koslam mɨdebɨm okok mɨdupsek, yɨp yɨl apem, gen kɨmɨgel mɨdɨl añɨŋ lɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yad bɨ sayn tep kɨmɨgel mɨdebin tek, yad ayɨp nep ajɨl yad gɨtep gɨpin ak nɨgtep gɨl nɨm, yad gen kɨmɨgel mɨdtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pen wog yad ak nɨbop ñɨl gɨnɨmɨb apin ak, koslam ma gɨnɨgabɨm tek agak. Gem nɨbop tep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kɨdek Juda añɨŋ lep ñɨn awl olap, Jisas bɨne okok ayɨp, wit wog nab ak amnɨlak. Amɨlɨg, bɨne okok yuwan gek, wit mɨdup anɨb okok ogɨnap tɨk dɨl, ñɨbɨlɨg ñɨbɨlɨg amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Anɨgelak, bɨ Pelisi okok nɨŋɨd, Jisas nop agɨlak, Nɨgan, bɨnak okok kɨli ñɨn awl wog ma gep ñɨn ak, wit mɨdup tɨkebal agɨlak. Anɨb ak chɨn gɨnɨgun tek ma lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Agelak kɨlop pen agak, Depid ne bɨlel bɨne okok ayɨp yuwan gek, God kal ak amjakɨlak agak. Amjakɨl, Depid God kal ak mɨgan amɨl bilet dɨl, dad bɨne okok ayɨp ñɨŋɨlak agak. Bilet anɨb ak God wɨdɨn mɨdup adek ak lɨpal ak, bɨ yokɨp ma ñɨbal, bɨ God nop sɨbogep okok nep ñɨbal agak. Depid nop yuwan gek bilet dɨl ñɨŋak kesɨm anɨb ak, buk Baybol kɨl tɨkɨlak ak, nɨbi ma nepɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pen nɨbi takaw Mosis ñu kɨl tɨkak ak ogɨnap sek abe ma nepɨm tek lup akaŋ agak? Ne tɨkɨl agak, Ñɨn awl wog ma gep ñɨn ak, bɨ God nop sɨbogep okok, kɨli God agnɨgep kal awl ak mɨdɨl wog gɨpal agɨl tɨkak agak. Kɨli wog ma gep ñɨn ak wog gɨpal ak pen, God kɨlop nɨŋɨd anɨb agup, Kɨli bɨ gɨ tɨmel ma gɨpal okok agup agak. ");
INSERT INTO taw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pen yad nɨbop agebin, God agnɨgep kal awl anɨb ak tap yokɨp, bɨ olap pen apɨl mɨdeb ak, bɨawl yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pen takaw olap buk Baybol kɨl tɨkɨlak ak, nɨgtep ma gɨpɨm tek lup agak. Takaw anɨb ak tɨkɨl agɨlak, God ne agup, Yɨp tap sɨbog ñɨnɨmɨb agɨl gos ma nepin agup agɨl tɨkɨlak agak. Binɨb okok kɨlop mapen nɨgɨnɨmɨb agɨl gos nepin agup agɨl tɨkɨlak agak. Takaw anɨb ak nɨgtep gɨpɨkep ak, bɨ gɨtep gɨpal okok kɨlop gos tɨmel nɨŋɨd ma ag gɨpɨkep agak. ");
INSERT INTO taw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nɨgɨm. Juda añɨŋ lep ñɨn awl apɨm ak, Bɨ Olap Ñɨne ne ke gos nɨŋɨd agek, binɨb okok kɨli gɨnɨgabal tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas wakay anɨb ak kelɨgɨl amɨl, Juda apnan gɨpal kal ak olap mɨgan ayaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pen kal mɨgan anɨb ak, bɨ ñɨn tɨmel gak olap ap yek. Bɨ ap yelak okok, kɨli Jisas takaw ogɨnap agek nop ag gun agɨl, nop agnɨŋɨd agɨlak, Binɨb tap gup okok, añɨŋ lep ñɨn awl chɨn ak gon suŋ lɨnɨmuŋ akaŋ mel agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Agelak Jisas kɨlop agak, Añɨŋ lep ñɨn awl chɨn ak chag sipsip nɨbi olap, kaw mɨgan ayaŋ pakenɨgab, dɨl lɨpɨg dɨyokɨnɨgabɨm akaŋ mel agak? Dɨl lɨpɨg dɨyokɨnɨgabɨm tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pen chag sipsip ak tap yokɨp, binɨb ak tap yɨbɨl agak. Anɨb ak tek, añɨŋ lep ñɨn awl chɨn ak binɨb okok kɨlop gɨtep gɨnɨgabun ak, takaw ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jisas anɨb agɨl, bɨ ñɨn tɨmel gak ak nop agak, Ñɨn ak almɨl lan agak. Agek, ñɨn almɨl lek pɨsnep suŋ lak, ñɨn pɨskɨd ak yek tek yek. ");
INSERT INTO taw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anɨgek nɨŋɨd, bɨ Pelisi okok am nan gɨl agɨlak, Nop anɨgɨl paklɨnɨgun agɨl, takaw kɨmɨgel aglɨtep gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bɨ Pelisi okok anɨb agelak nɨŋɨd, Jisas ne wakay anɨb ak kelɨgɨl, amnɨg saŋɨdaknɨŋ, binɨb kuŋay yɨbɨl kɨdek gɨlak. Anɨgelak, ne binɨb tap gak okok gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Suŋ laknɨŋ, kɨlop agak, Bɨ ak anɨb anɨb gup agɨl, ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisas gak anɨb ak, bɨ God gos ñek agñeb Aysaya gɨnɨgab agak tek nep gak. Ne tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nɨgɨm, bɨyad pɨsnep aglɨpin awl, wog yad gɨñeb ak mɨdeb agɨl tɨkak. Bɨ anɨb ak nɨgen yɨp tep yɨbɨl gup agɨl tɨkak. Kawnan yad ak nop bak lek, yad binɨb okok kɨlop bɨlok nɨŋɨd tɨg asɨk dɨnɨgayn takaw ak, ne takaw anɨb ak binɨb man keke mɨdupsek kɨlop agñɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ne penpen agɨlɨg takaw awl yɨbɨl ma agɨnɨgab agɨl tɨkak. Meg mɨgan dad aplanɨl ma agek, binɨb kanɨb amnɨgabal okok nop ma nɨgɨnɨgabal agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne bɨ kɨmɨgel yenɨgab agɨl tɨkak. Anɨb ak, sɨd olap kɨles mel ak pen pagɨnɨg, bɨ anɨb ak ne ma tɨpagɨnɨgab agɨl tɨkak. Lam mɨŋɨlaŋ gɨtep ma gɨnɨgab ak pen, bɨ anɨb ak ne ma tɨg sugɨnɨgab agɨl tɨkak. Anɨb ak nep, binɨb kɨles ma yenɨgabal okok, kɨlop kɨmɨgel gɨtep gɨnɨgab agɨl tɨkak. Ne anɨgɨl gɨ dad amɨl, gɨtep gɨlak kɨd ak aplanek, tap si tap tɨmel gep kɨd ak pɨsnep apyownɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Binɨb man okok nɨb okok abe, bɨ anɨb ak nop gos sek kod yenɨgabal agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bɨ kɨcheki abaŋ lek, wɨdɨn koy gɨl takaw ma agolɨgup olap dad apelak, Jisas kɨcheki ak ag seŋ yokek, wɨdɨn yɨbɨl nɨŋɨd takaw agɨl gak. ");
INSERT INTO taw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Binɨb yelak okok, gak anɨb ak nɨŋɨd, gos pal lɨl wal agɨl agɨlak, Bɨ anɨb awl Depid Ñɨne pel kod mɨdobun akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pen bɨ Pelisi okok takaw anɨb ak nɨŋɨd agɨlak, Bɨ anɨb ak ne kɨcheki bɨawl ak Belsebul kɨles ak dɨl, kɨcheki okok agyokeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pen gos nɨgɨlak anɨb ak Jisas ne ke nɨŋɨd, kɨlop agak, Binɨb man awl nokom olap, kɨli asɨk keke lɨl penpen gɨnɨgabal ak, tɨmel gɨl apyap pakɨnɨgabal agak. Taun olap akaŋ bɨ yɨb jɨj nokom olap, asɨk keke lɨl penpen gɨnɨgabal ak, apyap pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pen Satan ne kɨcheki ne okok kɨlop dɨyokɨl, kɨli ke asɨk keke lɨl penpen genɨgabal, tɨtay dɨl kɨles gɨl yenɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Pen yad Belsebul kɨles ak dɨl, kɨcheki okok seŋ agyokɨpɨnep, tɨtay dɨl binɨb nɨbi okok kɨcheki seŋ agyokɨpɨlap agak? Kɨli ke nɨbop agɨnɨgabal ak, tap anɨb gep tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pen nɨgɨm agak. God Kawnan ne ak yɨp kɨles ñek kɨcheki tap anɨb okok agyokɨpin tek, God binɨb dɨl kɨlop kod yenɨgab ak pɨsnep owup agak. Pen apek nɨbi nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pen bɨ kabɨyam tɨmel olap mɨdaknɨŋ, tɨtay dɨl bɨ olap tap nop okok si dɨnɨgab agak? Nag dɨl nop tunɨg lɨl nɨm, am tap nop okok si dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Binɨb yad yɨl ma mɨdebal okok, Satan yɨl mɨdɨl, yɨp ma dɨpal agak. Pen binɨb yad ayɨp wog ma gɨpal okok, kanɨb day ak ag tɨkɨl, binɨb yɨp yɨl ownɨg gɨpal okok kɨlop yuk dam yokɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Anɨb ak yad nɨbop agebin agak. Binɨb okok tap si tap tɨmel genɨgabal akaŋ, God nop takaw agjuwenɨgabal, God nɨŋɨd gach kɨlop mɨdupsek tɨg walɨg gɨyokɨnɨgab agak. Ak pen, God Kawnan nop ak takaw agjuwenɨgabal, ne nɨŋɨd gach kɨlop ma tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Binɨb an Bɨ Olap Ñɨne ak nop takaw tɨmel agenɨgab, God nɨŋɨd gach nop tɨg walɨg gɨyokɨnɨgab agak. Ak pen, God Kawnan nop ak takaw tɨmel agenɨgab, ñɨn awl ak abe ñɨn kɨdek ak abe God nɨŋɨd gach nop ma tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas takaw olap agak, Mab teplep mɨdeb ak, mɨdup teplep ak pulɨnɨgab agak. Mab tɨmel mɨdeb ak, mɨdup tɨmel ak pulɨnɨgab agak. Anɨb ak mab okok pulek nɨŋɨd, mab ak tep, mab ak tɨmel agɨl nepal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nɨbi yoy salaw ñapay okol agak. Nɨbi binɨb tɨmel anɨb ak tek, tɨtay dɨl takaw tep agɨnɨgabɨm agak? Binɨb tɨtay dɨl mɨdebal ak, takaw agel nɨŋɨd, binɨb okok tep, binɨb okok tɨmel agɨl nɨgɨnɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Binɨb mɨdtep gɨpal okok, nab kɨlop ayaŋ tep mɨdeb tek, kɨli gɨtep gɨpal agak. Binɨb mɨdtep ma gɨpal okok, nab kɨlop ayaŋ mɨdtep ma gup tek, kɨli gɨ tɨmel gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yad pen nɨbop agebin, kɨdek kot awl ñɨn ak, God binɨb okok mɨdupsek kɨlop agnɨgɨnɨgab agak. Takaw monmon agɨl akaŋ, tɨmel agɨl gɨlak tek, taynen takaw anɨb apek agɨl, kɨlop agnɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anɨb ak takaw agɨnɨgabɨm tek nɨŋɨd, binɨb okok suŋtep, binɨb okok yul dep agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pen bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek kɨli apɨl, Jisas nop agɨlak, Tisa, tap mageptek olap ge, chɨn nɨŋɨd nɨm, nep God nokom agyokek owup agɨl nɨgɨnɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Agelak agak, Binɨb mɨñɨl mɨdebal ñɨn nab awl, tap si tap tɨmel gɨl, God nop kɨdek ma gɨpal agak. Anɨb apal, Tap olap ke ge nɨŋɨd anɨb agɨnɨgabun, Nak God wog ak geban agɨnɨgabun apal agak. Pen tap olap ke gen ma nɨgɨnɨgabal agak. Nɨgɨnɨg, bɨ God gos ñek agñeb Jona ne bɨlel gak, yad abe gen nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bɨlel kubsal awl ak meg agɨl yek, Jona kogmeg nab ayaŋ amɨl ñɨn omɨŋal nokom mɨdek agak. Anɨb ak tek nep, Bɨ Olap Ñɨne abe ñɨn omɨŋal nokom lum nab okyaŋ yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pen Jona ne amɨl, taun Ninipa binɨb okok bɨlel kɨlop agñek nɨŋɨd, tap si tap tɨmel gɨpal ak taynen anɨgɨpun agɨl kelɨgɨlak agak. Jona bɨ yokɨp ak agek nɨg dɨlak ak pen, nɨbi mɨñɨl mɨdeb awl, bɨawl yɨbɨl takaw agup ak ma dɨpɨm agak. Anɨb ak God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, taun Ninipa binɨb okok kɨli tɨkjakɨnɨgabal agak. Tɨkjakɨl, binbɨ mɨñɨl mɨdeb tap si tap tɨmel gɨpal anɨb okok kɨlop agyɨkɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Binawl olap bɨlel binɨb man Sipa pal okok nɨb kɨlop kod yolɨgup agak. Pen ne man palawl anɨb ak kelɨgɨl owak agak. Ne bɨnonɨm Solomon nop nɨgɨnɨg apɨl, gos tep yɨbɨl nop ak nɨgin agɨl owak agak. Ne Solomon bɨ yokɨp ak nop anɨgak ak pen, nɨbi mɨñɨl mɨdeb awl, bɨawl yɨbɨl gos nɨgtep yɨbɨl gup ak nop nɨgɨnɨg ma opɨm agak. Anɨb ak God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, binawl anɨb ak tɨkjakɨnɨgab agak. Tɨkjakɨl, binbɨ mɨñɨl mɨdeb tap si tap tɨmel gɨpal anɨb okok kɨlop agyɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas takaw olap agak, Kɨcheki olap bɨ mulɨk sɨkɨl, seŋ amɨl tep olap nɨŋɨd mɨden agɨl, am man mɨlep okok aj aj mel nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","anɨb agɨnɨgab, Kal mɨgan ned mɨdɨl opin ak amnin agɨnɨgab agak. Agɨl, amɨl nɨgɨnɨgab, kal anɨb ak pɨd tep yɨbɨl gel tep anep yokɨp mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ne nɨŋɨd, okok amɨl kɨcheki tɨmel ne tek mel, kɨcheki tɨmel yɨbɨl anep kugul ak poŋɨd apɨl, mɨgan anɨb ak yenɨgabal agak. Anɨgek, bɨ anɨb ak nop mulɨk sɨkel, ned tep yolɨgup tek mel, pɨsnep mɨd tɨmel yɨbɨl gɨnɨgab agak. Anɨb ak tek nɨm, binɨb mɨñɨl nab awl mɨdɨl tap tɨtɨmel gɨpal okok, kɨli abe pɨsnep mɨd tɨmel yɨbɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas binɨb kuŋay okok kɨlop takaw agaknɨŋ, nonɨm nɨmam ne yɨbɨl okok seŋayaŋ apɨl agɨlak, Chɨn Jisas nop takaw agɨnɨg apobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Agelak, bɨ olap kal mɨgan amɨl, nop agak, Nɨgan, nanɨm namam nak okok, nep takaw agɨnɨg ap mɨdebal seŋayaŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Agek nop pen agak, Binɨb anɨb an ami mam yad agak? ");
INSERT INTO taw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bɨne okok kɨlop ñɨn yom kuskus gɨlɨg agak, Nɨgɨm, binɨb nɨm awl ami yad, mam yad okok nep mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Binɨb Bapi man ne alaŋ mɨdeb ak gos ne nɨgup tek nɨŋɨd kɨdek gɨpal okok, ami, mam, ay yad okok mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ñɨn anɨb ak nep, Jisas kal anɨb ak kelɨgɨl, am Galili cheb gol ak besɨgak. ");
INSERT INTO taw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Besɨgɨl takaw agñɨnɨg gaknɨŋ, binɨb kuŋay yɨbɨl apɨl nop puŋɨl kuskus gɨlak. Gelak, ne amɨl bot adek ak besɨgek, binɨb kuŋay anɨb okok ñɨg cheb gol ak jak yelak. ");
INSERT INTO taw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jak yelaknɨŋ, kɨlop agñɨlɨg agɨl, takaw anɨb okok paladaŋ lɨl adek keke yɨbɨl agñak. Anɨb agak, Nɨgɨm. Bɨ olap wit jakaŋ agɨl, wit mɨdup ak dam wog day okok yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yokenɨgab, ogɨnap kanɨb nab ak yapek, yawl okok pen ap nɨŋɨd mɨdupsek ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ogɨnap kab adek lum sɨkol sɨkol lɨnɨgab okok yapɨl, kasek jakɨnɨgab ak pen, ");
INSERT INTO taw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kɨdɨl palawl ma amnɨgab tek, sub nɨŋɨd mɨlep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ogɨnap nag ñuñu nab okok yapɨl jakɨnɨgab ak pen, nag anɨb ak pak yuwɨg gɨl pak ñɨbek, jak tep ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pen ogɨnap lum teplep adek okok yapɨl, jak tep gɨl, mɨdup kuŋay yɨbɨl nep pulɨnɨgab agak. Ogɨnap mɨdup 30 tek pulɨnɨgab, ogɨnap mɨdup 60 tek pulɨnɨgab, ogɨnap mɨdup 100 tek pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nɨbi binɨb tɨmud sek okok, takaw anɨb ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas anɨb agek, bɨne okok apɨl, nop agnɨŋɨd agɨlak, Binɨb okok kɨlop, taynen takaw paladaŋ lɨl nep apan agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Agelak agak, God binɨb dɨl kɨlop kod yenɨgab takaw ak, takaw we gɨl yolɨgup agak. Takaw anɨb ak, nɨbop gos ñek nepɨm ak pen, binɨb yokɨp okok gos anɨb ak ma ñek, ma nepal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Binɨb takaw nɨŋɨd nɨg dɨnɨgabal okok, God kɨlop gek takaw tep ogɨnap sek nɨŋɨd, gos nɨgtep yɨbɨl gɨnɨgabal agak. Pen binɨb takaw nɨŋɨd ma nɨg dɨnɨgabal okok, kɨli sɨkol sɨkol nepal ak sek, God kɨlop gek pɨsnep kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kɨli wɨdɨn nepal ak pen, wɨdɨn yɨbɨl ma nepal agak. Takaw nepal ak pen, nɨŋɨd gos nɨgtep ma nepal agak. Anɨb ak yad kɨlop takaw paladaŋ lɨl nep agñɨbin agak. ");
INSERT INTO taw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gɨpal anɨb ak, bɨ God gos ñek agñeb Aysaya ne ned gɨnɨgab agɨl tɨkak tek nep gɨpal agak. Takaw anɨb ak tɨkɨl agak, Takaw pel agek nɨgɨnɨgabɨm ak pen, takaw agup ak agɨl ma nɨgɨnɨgabɨm agɨl tɨkak agak. Pel wɨdɨn nɨgɨnɨgabɨm ak pen, tap olap ma nɨgɨnɨgabɨm agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Binɨb okol takaw yad apin ak kɨlop yɨlɨk gek, ma yɨbɨl nepal agɨl tɨkak agak. Tep adɨkɨd God nop gos nɨŋɨd ownɨgun, chɨnop gɨtep gek binɨb ne yonɨgun tek lup agɨl, gos anɨb ak ma nepal agɨl tɨkak agak. Anɨb ak tɨmud pɨl gɨl, wɨdɨn jukɨl nep mɨdebal agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Yad nɨbop nɨŋɨd agebin, bɨ God gos ñek agñeb okok sek, bɨ teplep God agup tek kɨdek gɨpal okok sek, bɨlel yɨp gos nɨŋɨd yelɨgɨpal agak. Kɨli kuŋay, ne tap tay gɨnɨgab ak nɨgun agɨl kod yelak ak pen ma nɨgɨlak agak. Takaw tay ne agɨnɨgab ak nɨgun agɨl kod yelak ak pen ma nɨgɨlak agak. Mɨñɨl pen nɨbi yad gɨpin ak nɨŋɨd, takaw yad apin ak nɨŋɨd gebɨm agak. God nɨbop nɨm, dɨtep yɨbɨl gek nɨgebɨm anɨb ak tek, mɨñmɨñ gebɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pen Jisas takaw anɨb ak agak, Wit mɨdup yokɨnɨgab takaw paladaŋ lɨl apin jɨj ak, nɨbop agen nɨgɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wit mɨdup ogɨnap kanɨb nab ak yownɨgab apin ak, ak binɨb okok kɨli God binɨb dɨl kɨlop kod yenɨgab takaw ak nɨgɨnɨgabal ak pen, gos nɨgtep ma gɨnɨgabal agak. Anɨgel, Satan apɨl takaw anɨb ak dɨ we gek, sawl gɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Mɨdup ogɨnap kab adek lum sɨkol sɨkol lɨnɨgab okok yapɨl jakɨnɨgab ak pen, kɨdɨl am wos ma gek, sub nɨŋɨd mɨlep gɨnɨgab apin ak, binɨb okok God takaw ak kɨdek won ak nɨgel tep gaknɨŋ dɨnɨgabal agɨl apin agak. Tep gaknɨŋ dɨnɨgabal ak pen, yokɨp sɨkol won olap mɨdɨl, binɨb ogɨnap takaw agel nɨŋɨd akaŋ, mɨŋel ogɨnap apek, takaw nop ak kelɨgɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mɨdup ogɨnap yownɨgab nag ñuñu nab okok apin ak, binɨb okok God takaw ne nɨgɨnɨgabal ak pen, wog wali, kal mɨj kɨneb, mani tap okok nep gos nɨgenɨgabal, God takaw ne ak pak ñɨbek tap mɨdup ne ma pulɨnɨgab agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pen mɨdup ogɨnap lum tep adek ak yapɨl jak tep gɨl, mɨdup 30 tek pulɨnɨgab akaŋ, mɨdup 60 tek pulɨnɨgab akaŋ, mɨdup 100 tek pulɨnɨgab apin ak, binɨb okok kɨli God takaw ak nɨŋɨd, dɨ wos yɨbɨl gɨl nɨgtep yɨbɨl gɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas kɨlop takaw olap sek paladaŋ lɨl agak, God binɨb dɨl kɨlop kod yenɨgab ak kesɨm debin awl tek gɨnɨgab agak. Bɨ olap wit mɨdup okok jakaŋ agɨl, wit mɨdup tep okok dam wog day ne okok yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pen maynab ayaŋ kɨn amnɨgabal won ak, bɨ tɨmel nop mɨlɨk nɨgup olap, ne tap wɨj tɨmel ogɨnap dad apɨl, wit wog nab anɨb okok yokɨl amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pen wit mɨdup tep okok jakaknɨŋ, tap wɨj tɨmel okok sek jakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Anɨgek, bɨ wog gɨñeb ne okok apɨl agɨnɨgabal, Bɨawl, tap mɨdup tep okok yɨbɨl dam wog day ak yokɨpan, tap wɨj tɨmel okok taydɨl nab anɨb okok sek jakeb agɨnɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Agel kɨlop agɨnɨgab, Bɨ yɨp mɨlɨk nɨgup olap dap yokup agɨnɨgab agak. Agek agɨnɨgabal, Chɨn am tap wɨj tɨmel jakup anɨb okok tɨgju yokɨnɨgun akaŋ agɨnɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Agel bɨ wog day nap nɨb ak agɨnɨgab, Mel. Ñɨn awl, tap wɨj tɨmel anɨb okok tɨgjuwɨm agenɨm, am tap mɨdup tep ogɨnap sek tɨgjunɨmɨb tek lup agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kelɨgem, omɨŋal gɨl jakɨnɨmuŋ agɨnɨgab agak. Pen jakɨl mɨdup pulɨl, dep ñɨn ak apek yɨl, bɨyad okok agen, tap wɨj tɨmel okok ned tɨgjuwɨl, dam mab dagɨlel yɨn sɨbok amnɨmuŋ agɨnɨgab agak. Amek, wit mɨdup yɨbɨl okok dɨ nan gɨl, dam kal mɨgan yad ak dɨlɨnɨgabal agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas kɨlop takaw olap pen paladaŋ lɨl agak, God binɨb dɨl kɨlop kod yenɨgab ak kesɨm debin awl tek gɨnɨgab agak. Bɨ olap mab mastet mɨdup ak dam wog day ne ak yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mab mɨdup ogɨnap awl mɨdeb, mastet mɨdup anɨb ak mɨdup sɨkol yɨbɨl ak pen, jak awl gɨnɨgab agak. Jak awl gɨl, wog nab jakɨnɨgab agak. Tap okok abe awl jakɨnɨgab ak pen, mab mastet tap awl yɨbɨl jakɨnɨgab agak. Jakɨl, lek tep ak pakek, yawl okok ap mab lek keke kal gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas kɨlop takaw olap pen paladaŋ lɨl agak, God binɨb dɨl kɨlop kod yenɨgab ak kesɨm debin awl tek gɨnɨgab agak. Bin olap tap yis ak sɨkol bad olap dɨl, palaw tin awl ak sek tɨg adɨk madɨk gek, mɨdɨlɨg awl yɨbɨl tanub tek ak gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas binɨb okok kɨlop takaw paladaŋ lɨl nep agñolɨgup. Takaw anɨb okok agñɨnɨg mɨseŋ ma agolɨgup, paladaŋ lɨl yɨbɨl kɨlop agñolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gak anɨb ak, bɨ God gos ñek agñeb olap ned gɨnɨgab agɨl tɨkak tek nep gak. Ne takaw anɨb ak tɨkɨl agak, Bɨawl agup, Yad takaw paladaŋ lɨl nep agñɨnɨgayn agup agɨl tɨkak. Man alwol gɨlak ñɨn ak tɨkɨl, mɨd dad apɨl mɨñɨl mɨdobun ñɨn awl, tap okok we gɨl ma nɨgɨlak ak, kɨlop paladaŋ lɨl agñɨnɨgayn agup agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas binɨb kuŋay anɨb okok kɨlop kelɨgɨl, kal mɨgan amek, bɨne okok apɨl nop agɨlak, Tap wɨj tɨmel wog day nab okok jakup agɨl paladaŋ lɨl apan ak, takaw jɨj anɨb won ak chɨnop agyɨke nɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Agelak agak, Bɨ tap wit mɨdup tep wog day okok yokɨnɨgab apin ak, Bɨ Olap Ñɨne ak agak. ");
INSERT INTO taw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Wogday apin ak, lum awl ak agak. Tap wit mɨdup tep apin okok, binɨb okok God kɨlop dɨl kod yenɨgab ak agak. Bɨ tap wɨj tɨmel dap yokɨnɨgab apin ak, bɨ yɨp mɨlɨk nɨgup Satan ak agak. Tap wɨj tɨmel apin okok, Satan binɨb ne agak. Pen wit mɨdup pok gɨnɨgab ñɨn apin ak, ñɨn kɨdek ak agak. Bɨ tɨk dad ownɨgabal apin ak, ensel okok agak. ");
INSERT INTO taw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tap wɨj tɨmel jakup okok tɨgju dɨ mab yɨneb yokɨnɨgabal apin ak, anɨb ak tek ak ñɨn kɨdek ownɨgab ñɨn ak lum awl anɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bɨ Olap Ñɨne ensel ne okok kɨlop agyokek, am binɨb tɨmel kɨli God binɨb ne okok ayɨp jɨmñɨl yenɨgabal okok, binɨb tɨmel anɨb okok kɨlop, tɨg asɨk lɨl dɨyokɨnɨgabal agak. Binɨb anɨb okok, kɨli tap tɨmel gɨl, binɨb ogɨnap God nop gos nepal okok kɨlop gel apyownɨgabal agak. Binɨb tɨmel anɨb okok anɨgɨpal ak, ensel okok kɨlop tɨg asɨk lɨl dɨyokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tɨg asɨk lɨl, mab awl yɨneb ayaŋ ak dɨyokel, meg sulɨlɨg chaŋ awl lɨlɨg yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ñɨn anɨb ak Nap binɨb suŋtep ne okok kɨlop dɨl kod yenɨgab agak. Kɨli mɨdtep gɨl, sub mɨlek ak tek yenɨgabal agak. Nɨbi binɨb tɨmud sek okok, takaw anɨb ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas takaw olap agak, God binɨb dɨl kɨlop kod yenɨgab ak, kesɨm debin awl tek gɨnɨgab agak. Tap teplep olap mani awl yɨbɨl ak tawɨl, dam wog nab okok dɨ we gɨnɨgabal agak. Bɨ olap tap teplep anɨb ak nɨŋɨd, tap ogɨnap dɨl pal tɨbɨk tep gɨl amnɨgab agak. Amɨl, mɨñmɨñ gɨlɨg tap ne okok mɨdupsek dam binɨb okok kɨlop ñɨl mani dɨnɨgab agak. Dɨl, mani anɨb ak dad amɨl wog day anɨb ak tawɨl, am tap teplep we gup anɨb ak dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas takaw olap agak, God binɨb dɨl kɨlop kod yenɨgab ak, kesɨm debin awl tek gɨnɨgab agak. Bɨ sɨkim gep olap kubap mɨlep ogɨnap pɨyow nɨg ajenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pen kubap mɨlep teplep olap nɨgɨnɨgab ak, ne amɨl, tap ne okok mɨdupsek dam binɨb okok kɨlop ñɨl mani dɨl, mani dad amɨl kubap anɨb ak tawnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas takaw olap agak, God binɨb dɨl kɨlop kod yenɨgab ak, olap nɨm kesɨm debin awl tek gɨnɨgab agak. Binɨb ogɨnap kubsal asas dep dad amɨl, ñɨg cheb ak yokel, kubsal keke apɨl mɨgan anɨb ak am yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Anɨgel, kubsal asas dep ak keb aplan jakek, lɨpɨg dad gol okok amnɨgabal agak. Amɨl besɨgɨl, kubsal teplep okok dɨl wad olap yɨgɨlɨl, kubsal tɨmel okok dɨyokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ñɨn kɨdek ak anɨb ak tek gɨnɨgab agak. God ensel ne okok agyokek apɨl, binɨb tap si tap tɨmel gɨpal okok tɨg asɨk dɨ ke lel, binɨb suŋtep okok kɨli ke lɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Binɨb tɨmel anɨb okok kɨlop tɨg asɨk dɨ ke lɨl, mab awl yɨneb ayaŋ ak dɨyokel, meg sulɨlɨg chaŋ awl lɨlɨg yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Anɨb agɨl agak, Takaw apin okok mɨdupsek nɨgtep gɨpɨm akaŋ agak? Agek, bɨne okok kɨli agɨlak, Yaw agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Agelak agak, Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok, kɨli ogɨnap God binɨb dɨl kɨlop kod yenɨgab takaw ak, nɨgtep gɨpal agak. Bɨ anɨb okok, kɨli bɨ kal nap nɨb olap tek agak. Ne kal mɨgan ne amɨl tap nedil ak dɨl, tap koŋɨm ak dɨl, tap teplep anɨb okok mɨdupsek dɨl dad seŋ ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pen Jisas takaw paladaŋ lɨl agak anɨb okok agjuwɨl, man anɨb ak kelɨgɨl, ");
INSERT INTO taw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","man ne amnak. Amɨl, Juda apnan gɨpal kal ak mɨgan amɨl, binɨb okok kɨlop takaw agñek nɨŋɨd, wal yɨbɨl agɨl agɨlak, Bɨ anɨb awl gos anɨb ak akal nɨb nɨŋɨd anɨb agup agɨlak? Taydɨl tap mageptek okok gup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","Nap ne ak bɨ kapeda olap yolɨgup agɨlak. Nonɨm, nɨmam, nɨnay ne okok, chɨn ayɨp mɨdebal agɨlak. Nonɨm Maliya, nɨmam ne okok Jemis ak, Josep ak, Saymon ak, Judas ak agɨlak. Anɨb ak ne taydɨl apɨl tap anɨb gosup agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Anɨb agɨl, nop mɨlɨk nɨgɨlak. Pen Jisas kɨlop agak, Bɨ God gos ñek agñeb olap, ne binɨb man pal okok amɨl agek, nɨŋɨd agup agɨl nepal agak. Ak pen, kal man ne ke ak agek, yɨb ma mɨdeb takaw nop ak ma dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jisas nop gos ma nɨgɨlak anɨb ak tek, taun anɨb ak tap mageptek ogɨnap sek ma gak. ");
INSERT INTO taw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pen ñɨn anɨb ak gapman bɨawl Galili plopens kod mɨdep ak Helod, ne Jisas tɨtay gak takaw ak nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","bɨ wog gɨñeb ne okok kɨlop agak, Bɨ tap mageptek anɨgup ak, ne bɨ olap ke mel agak. Ne Jon Bɨ Ñɨg Pakñeb anep agak. Nop paklɨnek ak pen, tepayaŋ tɨkjakɨl apɨl mɨdeb tek, nɨŋɨd tap mageptek anɨb okok geb agak. ");
INSERT INTO taw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Pen Jon nop ned nag lɨl, paklɨlak takaw ak, anɨgɨl mɨdeb. Helod ne tɨkjakɨl, nɨmam Pilip bin ne Helodiyas nop ak pɨlɨg dak. Pɨlɨg dek nɨm, Jon agak, Nad bin ak dɨpan, ak teplep ma mɨdeb agak. Anɨb agek, Helod ne agek, bɨne okok kɨli Jon nop dɨl nag tun gɨl, dam nag lɨlak. Helod ne Jon nop pɨsnep paklen kumaŋ agɨl gos nɨgak ak pen, binɨb okok Jon nop bɨ God gos ñek agñeb chɨn agɨlak tek, Helod ne pɨlɨkɨl Jon nop ma paklak. ");
INSERT INTO taw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pen kɨdek Helod nop nonɨm tɨkak ñɨn ak apek, binɨb ogɨnap apnan gɨl tap ñɨbelak, bin Helodiyas payne ak, apɨl nab anɨb ak kɨgom pagek, Helod nɨgek tep yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Anɨgek, ne pay anɨb anop takaw aglɨl agak, Yad nɨŋɨd agebin, nak tap olap agnɨgenɨgaban, monmon ñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Agek, pay anɨb ak, nonɨm agak tek nɨŋɨd anɨb agak, Jon Bɨ Ñɨg Pakñeb kɨmɨg won ak kɨnag adek lɨl, dap ñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Anɨb agek, gapman bɨnonɨm Helod Jon nop nɨgek chɨb gak ak pen, pay anop tap tay yɨp agnɨge ñɨnɨgayn agak tek gos nɨgak. Nɨŋɨd, takaw anɨb ak binɨb okok nɨg yelaknɨŋ agak ak anɨb ak, yɨp nebeŋ ma gɨnɨmuŋ agɨl takaw ne pay nop agak ak kɨdek gak. Bɨ olap agyokek, ");
INSERT INTO taw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jon nag lɨ yek ak amɨl, kɨmɨg won nop ak tɨbɨlɨkak. ");
INSERT INTO taw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tɨbɨlɨkɨl, dɨl kɨnag adek ak lɨl, dapɨl pay anɨb ak nop ñelak, ne pen dad amɨl, nonɨm nop ñak. ");
INSERT INTO taw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pen Jon nop anɨgɨl kuŋam tɨbɨlɨkelak, bɨne okok apɨl, nop dam kamɨl, am Jisas nop agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas ne Jon nop paklɨlak takaw ak nɨŋɨd, am man wakay olap ke mɨden agɨl bot dɨl, man anɨb ak kelɨgɨl saŋɨdak. Pen binɨb okok, Jisas amnaknɨŋ kɨdek amnun agɨl, taun kɨli okok kelɨgɨlak. Kelɨgɨl, lum adek amɨl, Jisas amnɨg gek okok amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas ñɨg gol okok amjakɨl bot ak kelɨgɨl nɨgak, binɨb kuŋay yɨbɨl yelak. Ne kɨlop nɨgek chɨb gak. Pen binɨb kɨli tap gak okok kɨlop gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pen sub saŋɨd amnɨg gaknɨŋ won ak, bɨne okok yek ak apɨl nop agɨlak, Kɨlup apeb, okol man nep nab ak agɨlak. Binɨb kuŋay yɨbɨl okol kɨlop age, man sɨkol okol amɨl, tap mɨdup kɨli ogɨnap tawɨl ñɨŋɨlaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Anɨb agelak kɨlop agak, Taynen amnɨgel agak? Nɨbi ke kɨlop tap mɨdup ñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Agek agɨlak, Chɨn tap mɨdup kuŋay ma mɨdeb, yokɨp bilet anep mamɨd ak, kubsal omɨŋal sek mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Agelak Jisas agak, Tap anɨb okok dad owɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Anɨb agɨl, binɨb okok kɨlop agek, tap wɨjwɨj adek okok besɨgɨlak. Besɨgel, bilet anep mamɨd ak dɨl, kubsal omɨŋal ak dɨl, kɨlan gɨl nɨŋɨd, God nop tep agɨl, bilet ak tɨpagɨl bɨne okok kɨlop ñaknɨŋ, kɨli dɨlɨg binɨb okok kɨlop bɨlok ñɨlak. Kubsal ak abe gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Anɨgɨl bɨlok ñelak, ñɨb gel gel kogmeg gek, dayday kelɨgɨlak okok, bɨne okok wad anep umɨgan ak dɨ yɨgel pɨsnep aplan jakak. ");
INSERT INTO taw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Binɨb anɨb okok mɨdupsek tap ñɨŋɨlak ak pen, bin okok sek, ñapay sɨkol okok sek mel, bɨ okok nep nɨm, 5,000 tek amnak. ");
INSERT INTO taw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Won anɨb ak, Jisas bɨne okok kɨlop ned pɨs adaŋ amnɨlaŋ agɨl, agek bot dɨl saŋɨdɨlak. Saŋɨdɨlaknɨŋ, binɨb okok kɨlop agek nop kelɨgɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Amelak, ne ke God nop agɨnɨg, dum alaŋ amnak. Kɨsɨlɨm bad sek owaknɨŋ, ne dum anɨb ak awsek yek. ");
INSERT INTO taw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pen bɨne okok bot dad ñɨg nab awl sɨŋak amnɨlaknɨŋ, yɨgen apek okdaŋ bot amnak anɨb okok. Yɨgen awl yɨbɨl ak apɨl, ñɨg pag apɨl bot ak tɨg adɨkɨnɨg tek gak. ");
INSERT INTO taw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pen man tɨkɨnɨg gak won ak, Jisas ñɨg wɨj adek ak tawɨd apɨl, yelak wulep sɨŋak apek nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ñɨg wɨj adek ak tawɨd owak ak nɨŋɨd, ak chɨp kawnan olap apeb agɨl, jel pɨlɨkɨl wal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Won anɨb ak Jisas pen kɨlop agak, Gos sek yenɨmɨb agak. Yad nep apebin, ma pɨlɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Agek Pita agak, Bɨawl, nad nep apɨl yɨl, yɨp age, ñɨg wɨj adek ak tawɨd pi ak amnin agak. ");
INSERT INTO taw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Agek Jisas agak, Nad owan agak. Agek, Pita bot adek ak kelɨgɨl, ñɨg wɨj adek ak tawɨd Jisas yek sɨŋak amnak. ");
INSERT INTO taw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pen amɨl nɨgak, yɨgen awl yɨbɨl ak apek pɨlɨkek, ñɨg nop dad pi okok amnɨg nep gek agak, Bɨawl, yɨp dan agak. ");
INSERT INTO taw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Anɨb agek, Jisas kasek nop chɨchɨk dɨl agak, Yɨp gos nepan ak pen, taynen gos omɨŋal nepan agak? ");
INSERT INTO taw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Anɨb agɨl, bot mɨgan ak amnɨleknɨŋ, yɨgen awl dek ak kelɨgak. ");
INSERT INTO taw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Anɨgek nɨŋɨd, bɨne bot mɨgan ayaŋ yelak okok, Jisas yɨb nop dad aplanɨlɨg agɨlak, Nad God Ñɨne yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pen Jisas ayɨp bɨne ayɨp kɨli ñɨg cheb tɨkɨl man Genesaled pɨs adaŋ amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Amjakelak, binɨb anɨb okok Jisas nokom owup agɨl, binɨb wulep anɨb okok mɨdupsek suk agel, binɨb tap gak okok dad owlak. ");
INSERT INTO taw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dad apɨl, Jisas nop nebneb gɨlɨg agɨlak, Chɨnop yaw age yɨl, binɨb tap gup okol, chech nep day okok nep dɨnɨgel suŋ laŋ agɨlak. Agelak yaw agek, binɨb nop dɨnɨgɨlak okok kɨlop mɨdupsek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pen ñɨn anɨb ak, bɨ Pelisi ogɨnap, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap, kɨli Jelusalem nɨb apɨl, Jisas nop agɨlak, ");
INSERT INTO taw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Bɨ nad okol, taynen bapi based sɨkop takaw pel ak kelɨgɨl, ñɨn kɨli ñɨg lɨ yokɨl mel, yokɨp nep tap ñɨbal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Agelak Jisas pen kɨlop agak, Nɨbi taynen God takaw agup ak kelɨgɨl, nap nased takaw nɨbi ke anep nɨŋɨd kɨdek gɨpɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God agup, Nanɨm nap takaw agɨnɨmil tek nɨŋɨd, kɨlop dɨtep gɨnɨmɨb agup agak. Pen ñapay ogɨnap nonɨm nap kɨlop takaw tɨmel agenɨgel, paklem kumnɨgel agup agak. ");
INSERT INTO taw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Nɨbi pen God takaw ne ak kelɨgɨl, nap nased takaw nɨbi ke anep nɨŋɨd kɨdek gɨpɨm agak. Nɨbi anɨgɨl apɨm, Bɨ olap nonɨm nap tap kɨlop ñɨbɨkop tek ak, kɨlop pen agup, Tap anɨb ak God nop ñin agɨl aglɨpin agup, bɨ anɨb ak ne nonɨm nap tap ma gɨñonɨmuŋ apɨm agak. Takaw anɨb apɨm ak, takaw tɨmel gup apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bɨ God gos ñek agñeb Aysaya, ne nɨbi bɨ takaw yepɨs apɨm okok nɨŋɨd yɨbɨl agɨl, buk Baybol ak kɨl tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God agup, Binɨb ogɨnap God Bɨawl chɨn, God Bɨawl chɨn apal ak pen, kɨli yokɨp takaw anep apal agup agɨl tɨkak agak. Yip gos ma yɨbɨl nepal agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kɨli yɨb yɨp dad aplanɨbal agup agɨl tɨkak agak. Kɨli pen, nap nɨsed takaw nep agelɨgɨpal ak nɨŋɨd, agñɨl apal, Nɨm ak God takaw ne apal agup agɨl tɨkak agak. Anɨb ak, yɨb yɨp yepɨs dad aplanɨbal agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas anɨb agɨl, binɨb yelak okok agek wulep sɨŋak apelak agak, Takaw agɨnɨgebin ak nɨŋɨd nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Binɨb tap ñɨbel nab ayaŋ amnɨgab ak, God nɨgek gach ma yenɨgab agak. Pen nab ayaŋ nɨb meg mɨgan seŋ ownɨgab anep nɨm, God nɨgek gach yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pen Jisas bɨne okok apɨl nop agɨlak, Bɨ Pelisi okok, takaw apan ak nɨgel kɨlop mɨlɨk yowup ak nepan akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Agelak kɨlop pen agak, Bapi ne man ne alaŋ mɨdeb ak, tap yɨŋ ne ma yɨmub okok jɨj sek puŋɨl ju dɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bɨ Pelisi anɨb okok kɨlop gos pal ma nɨgɨnɨmɨb agak. Kɨli bɨ wɨdɨn koy tek mɨdebal, kɨli bɨ ogɨnap kɨlop kanɨb yomnɨg apal agak. Pen bɨ wɨdɨn koy olap, bɨ wɨdɨn koy olap nop poŋɨd dad amɨl nɨm, omɨŋal gɨl kaw mɨgan ak apyap pakɨnɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jisas anɨb agek, Pita pen agak, Takaw anɨgɨl paladaŋ lɨl apan jɨj ak, chɨnop agñe nɨgun agak. ");
INSERT INTO taw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Agek agak, Kɨli ma nepal tek, nɨbi abe ma nɨgtep gɨpɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tap ñɨŋeb mɨdupsek okok, monmon ñɨbel kogmeg nab ayaŋ amek, chɨb sek kɨl yokɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pen gos nab kɨli ayaŋ nɨb meg mɨgan seŋ apek nɨm, tɨmel gel God nɨgek gach mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Binɨb okok nab kɨli ayaŋ gos owaknɨŋ, gos tɨmel nɨŋɨd, chɨp ñagɨl, bin si bɨ si dɨl, tap si dɨl, yepɨs agɨl, binɨb agjuwɨl gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gɨpal anɨb ak nɨm, God nɨgek gach mɨdebal agak. Pen tap ñɨŋɨnɨg, ñɨn ñɨg ma lɨ yokɨl monmon ñɨbal ak, God nɨgek gach ma mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas man Genesaled anɨb ak kelɨgɨl, taun Taya sek, taun Saydon sek wulep anɨb sɨŋak amnak. ");
INSERT INTO taw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Am anɨb okok yek, bin Kenan nɨb olap man anɨb ak mɨdɨl, Jisas nop apɨl agak, Bɨawl, Depid Ñɨne, yɨp mapen nɨgɨnɨmɨn agak. Pay yɨp ak kɨcheki abaŋ lek, mɨdtep ma yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Agek, Jisas pen ma yɨbɨl agak. Pen bɨne okok apɨl nop agɨlak, Bin anɨb awl chɨnop kɨdek gɨlɨg, takaw pug nep agup ak, nop agyokan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Agelak agak, God yɨp agyokek opin, binɨb Yislel jɨj ak agak. Kɨli chag sipsip kul gep tek mɨdelak okok, kɨlop nep dɨnɨg ownek agak. ");
INSERT INTO taw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Anɨb agek, bin anɨb ak apɨl Jisas yek jɨj sɨŋak kɨgom yɨmɨl agak, Bɨawl, yɨp gɨtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Agek agak, Tap mɨdup ñapay chɨn ñɨnɨgun ak, taynen dɨl chen ñɨluk okok mukɨnɨgun agak? ");
INSERT INTO taw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Agek bin anɨb ak agak, Bɨawl, nɨŋɨd apan ak pen, chen ñɨluk okok nap kɨli apɨlɨg tap ñɨŋɨlaknɨŋ, dayday bog muk okok yowup okok nep ñɨbal agak. ");
INSERT INTO taw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Agek Jisas agak, God nop gos kɨles lɨnɨŋɨd apan ak, apan tek gɨnɨgab agak. Anɨb agaknɨŋ, kɨcheki ak won anɨb anep payne nop kelɨgɨl seŋ amnak. ");
INSERT INTO taw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas man anɨb ak kelɨgɨl, Galili cheb gol adek ak amɨl, kɨlan gɨl amɨl dum alaŋ besɨgak. ");
INSERT INTO taw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Besɨg mɨdaknɨŋ, binɨb kuŋay yɨbɨl okok kɨli binɨb tob tɨmel gak okok, wɨdɨn koy gak okok, ñɨn tob tɨd mad gak okok, takaw ma agelɨgɨpal okok, tap tɨtay gak okok mɨdupsek dad apɨl, Jisas yek tob agen sɨŋak lɨlaknɨŋ, kɨlop gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Anɨgek, binɨb anɨb okok nɨŋɨd wal agɨlɨg agɨlak, Chɨn Yislel binɨb God chɨn ak tep yɨbɨl agɨlak. Binɨb takaw ma apal okok gek takaw agebal, binɨb ñɨn tob tɨmel gak okok gek mɨdtep gebal, binɨb tob tɨmel gak okok gek aj tep gebal, binɨb wɨdɨn koy okok gek nɨgebal agɨlak. Anɨb agɨlɨg, yɨb nop dad aplanɨlak. ");
INSERT INTO taw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas bɨne okok kɨlop agek apelak agak, Binɨb okol kɨlop chɨb nɨgebin agak. Ñɨn omɨŋal nokom yad ayɨp mɨdel, kɨlop tap ñen ñɨŋɨnɨgel ak mɨñɨl ma mɨdeb agak. Kɨlop yokɨp agen amel, kanɨb nab okok wɨdɨn mayn apek, apyap pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Agek bɨne okok agɨlak, Man nep nab anɨb okol, tap mɨdup akal nɨb pɨyow nɨŋɨd dapɨl, binɨb kuŋay yɨbɨl anɨb okol ñon ñɨŋɨnɨgabal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Agelak Jisas agak, Bilet nɨbi tɨtay mɨdeb agak? Agek agɨlak, Bilet anep kugul ak mɨdɨl, kubsal sɨkol ogɨnap sek mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Agelak, Jisas binɨb okok kɨlop agek, lum adek anɨb sɨŋak besɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Besɨgel, bilet anep kugul ak dɨl, kubsal okok dɨl, God nop tep agɨl, tɨpagɨl bɨne okok kɨlop ñek, kɨli dɨl binɨb okok kɨlop bɨlok ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ñelak, ñɨb gel gel kogmeg gek, dayday kelɨgɨlak okok, bɨne okok wad anep kugul ak dɨl, yɨgel pɨsnep aplan jakak. ");
INSERT INTO taw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Binɨb anɨb okok mɨdupsek tap ñɨŋɨlak ak pen, bin okok sek ñapay sɨkol okok sek mel, bɨ okok nep nɨm, 4,000 tek amnak. ");
INSERT INTO taw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pen anɨgɨl tap ñɨbɨl, Jisas binɨb kuŋay okok kɨlop agyokek amnelak, ne bot dɨl, man Magadan ke sɨŋadaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bɨ Pelisi ogɨnap, bɨ Sajusi ogɨnap, kɨli Jisas nop nebneb gon tay tek agonɨmuŋ ak nop ag gɨnɨgun agɨl gos nɨgɨlak. Anɨb ak nɨŋɨd, apɨl nop agɨlak, Nad God wog ne anɨgebin apan ak, tap mageptek olap genɨmɨn, nɨŋɨd apan agɨl nɨgɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Agelak kɨlop agak, Sub saŋɨd amɨl, nɨkɨm pakaknɨŋ nɨbi apɨm, Man tɨk tep gɨnɨgab apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Man tɨkaknɨŋ, wɨsɨp alaŋ gach gaknɨŋ nɨbi apɨm, Ak mɨñɨl man pakɨnɨgeb apɨm agak. Anɨgɨl nɨgtep gɨpɨm ak pen, God ne mɨñɨl gup ak sek, kɨdek gɨnɨgeb ak sek nɨŋɨd, gos nɨgtep ma gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Binɨb mɨñɨl mɨdebal ñɨn nab awl, tap si tap tɨmel gɨl, God nop kɨdek ma gɨpal agak. Tap olap ke ge nɨgun apal ak, yad gen ma nɨgɨnɨgabal agak. Nɨgɨnɨg, bɨ Jona bɨlel gak, yad abe gen nɨgɨnɨgabal agak. Jisas anɨb agɨl, kɨlop kelɨgɨl wakay olap amnak. ");
INSERT INTO taw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas bɨne okok ayɨp bot dɨl, pɨs adaŋ amɨl bɨne okok nɨgɨlak, bilet okok sawl gɨl dad ma amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pen Jisas kɨlop agak, Nɨgtep gɨnɨmɨb agak. Bɨ Pelisi okok sek, bɨ Sajusi okok sek yis kɨlop ak asɨk tep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Agek, kɨli ke agnɨg agnɨg gɨl agɨlak, Chɨn bilet ak dad ma opun ak nɨm, anɨb agosup akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pen Jisas agɨlak anɨb ak ke nɨŋɨd anɨb agak, Nɨbi yɨp gos nepɨm ak sɨkol gup agak. Taynen bilet ma dad opun agɨl ag amɨl apɨl gebɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yad tɨtay gɨnɨg gɨnɨgayn ak nɨgtep ma gɨpɨm akaŋ agak? Bɨ 5,000 tek yelak ñɨn ak, bilet anep mamɨd ak dɨl, tɨpag ñenek, ñɨb dad amɨl apɨl gelak, wad tɨtay yɨgem aplan jakak, nɨbi anɨb ak sawl gɨpɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pen kɨdek bɨ 4,000 tek yelak ñɨn ak, bilet anep kugul ak ñenek, ñɨb dad amɨl apɨl gelak, wad awl tɨtay yɨgem aplan jakak, nɨbi anɨb ak sawl gɨpɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nɨbi tɨtay dɨl gos anɨb ak nɨgtep ma gɨl, yɨp bilet nen agup apɨm agak? Bilet nen ma agebin agak. Pen bɨ Pelisi okok sek, bɨ Sajusi okok sek yis kɨlop ak asɨk tep gɨnɨmɨb agɨl agebin agak. ");
INSERT INTO taw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Anɨb agek nɨgɨlak, tap yis bilet sek lɨpal ak asɨk tep gɨnɨmɨb agɨl ma agak. Bɨ Pelisi okok sek, bɨ Sajusi okok sek takaw agñɨbal okok asɨk tep gɨnɨmɨb agɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kɨdek Jisas bɨne okok ayɨp taun Sisaliya Pilipay amɨl, man nab anɨb ak ajɨlɨg, kɨlop agak, Binɨb okok kɨli, Bɨ Olap Ñɨne nɨm, ne bɨ an apal agak? ");
INSERT INTO taw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Agek bɨne okok agɨlak, Ogɨnap ne Jon Bɨ Ñɨg Pakñeb ak apal, ogɨnap ne Yilayja apal, ogɨnap ne Jelemaya akaŋ, bɨ God gos ñek agñeb olap apal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Agelak Jisas kɨlop agak, Nɨbi ke pen, yɨp an agɨl nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Agek Saymon Pita agak, Nad Bɨ God nop aglup ak, chɨnop dɨl kod yenɨgab ak, God ne pel mɨdep ak Ñɨne agak. ");
INSERT INTO taw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Agek Jisas agak, Saymon Jon ñɨne, nad gos nepan anɨb ak, ke okok nɨb ma owup agak. Bapi man ne alaŋ mɨdeb ak, ne nokom nep gos tep ñek nepan agak. Anɨb ak nad mɨñmɨñ gɨl mɨdtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pen yad nep anɨb apin, nad Pita, kab kɨles tek nɨŋɨd apan agak. Binɨb yad yɨl yenɨgabal okok, yad kɨlop gen, kɨli kal tek yenɨgabal, kab kɨles tɨmel adek anɨb ak agak. Kumeb kɨles ak binɨb anɨb okok kɨlop apɨl gɨ tɨmel gek apyap pakɨnɨgel tek ma yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","God binɨb dɨl kɨlop kod yenɨgab anɨb ak, ki wul ak nep ñɨnɨgayn agak. Nep ñen, tap tɨtay gup lum awl ak nɨge, yɨpɨd ma gek mel agɨnɨgaban ak, God man ne alaŋ mɨdeb ak ne abe mel agɨnɨgab agak. Pen tap tɨtay gup lum awl ak nɨge, yɨpɨd gek yaw agɨnɨgaban ak, God man ne alaŋ mɨdeb ak ne abe yaw agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jisas anɨb agɨl, bɨne okok kɨlop kɨles gɨl agak, Binɨb okok kɨlop, ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab nɨm anɨb ak agɨl, ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ñɨn nab anɨb sɨŋak Jisas bɨne okok kɨlop mɨseŋ agɨl agak, Yad Jelusalem amen, Juda bɨawl okok sek, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, kɨli yɨp yul ñɨl paklɨnɨgabal agak. Yɨp yul ñɨl paklɨnɨgabal ak pen, ñɨn omɨŋal nokom mɨdɨl tepayaŋ tɨkjakɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Anɨb agek, Pita ne Jisas nop dad gol sɨŋak amɨl, takaw kɨles tek agɨl agak, Bɨawl, takaw anɨb ak tep ma apan agak. God nep kod yek, anɨb ma gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Agek, Jisas pen Pita nop agak, Satan, yɨp kelɨgɨl amnoŋ agak. Yɨp taynen mel agɨl ageban agak? God gos nɨgup tek ma nepan, binɨb gos nepal tek nep nɨŋɨd anɨb ageban agak. ");
INSERT INTO taw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Anɨb agɨl bɨne okok kɨlop agak, Binɨb an yɨp kɨdek gonɨmuŋ, gos ne ak kelɨgɨl, mab bak kumak chɨn ak dad ajɨl, yɨp chɨgɨl kɨdek gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bɨne ke mɨdɨl, mɨdtep gin agɨnɨgab ak, kɨdek mɨd tɨmel gɨnɨgab agak. Pen bɨ yɨp dɨl, yɨp tap tay gɨnɨgab takaw ma mɨdeb agɨnɨgab ak, kɨdek mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pen bɨ tap lum awl yɨl mɨdupsek dɨnɨgab ak, kɨdek ne tɨtay dɨl yenɨgab agak? Akaŋ, tap tay tek bɨ olap ne God nop ñek, God pen nop gek pelpel yenɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nɨgɨm. Bɨ Olap Ñɨne ne Bapi mɨlek awl dɨl kɨles awl dɨl, ensel okok ayɨp ownɨgab agak. Anɨb ñɨn ak, binɨb gɨtep gɨpal okok kɨlop pen gɨtep gɨnɨgab, binɨb tap tɨmel gɨpal okok pen gɨ tɨmel gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yad nɨbop nɨŋɨd agebin, binɨb mɨñɨl mɨdebɨm okok ogɨnap ma kumnɨgabɨm, mɨd mɨd Bɨ Olap Ñɨne, ne bɨnonɨm awl yɨbɨl ak mɨdɨl apek nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisas takaw anɨb ak agɨl, ñɨn anep kagol ak mɨdɨl, Pita ayɨp, Jemis ayɨp, Jemis nɨmam ne Jon ak ayɨp, kɨlop poŋɨd, dum awl alaŋ olap amɨl kɨli ke nep yelak. ");
INSERT INTO taw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yelaknɨŋ, Jisas wak nop ak ke yɨbɨl lɨl, jomulɨk ak sub tek nɨŋɨd, chech ne ak ñɨñakol yɨbɨl gɨlɨg yek. ");
INSERT INTO taw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Anɨgaknɨŋ nɨgɨlak, Mosis ayɨp Yilayja ayɨp, bɨ omɨŋal apɨl Jisas ayɨp takaw ag yelek. ");
INSERT INTO taw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita anɨb ak nɨŋɨd, ne Jisas nop agak, Bɨawl, chɨn awl mɨdobun ak, tep yɨbɨl mɨdobun agak. Nad yaw age yɨl, kal bad ak omɨŋal nokom gɨnɨgun agak. Nep olap, Mosis nop olap, Yilayja nop olap agak. ");
INSERT INTO taw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Anɨb agaknɨŋ, wɨsɨp kayɨg yɨbɨl ak apɨl, kɨlop mɨdupsek yu gak. Yuwɨg daknɨŋ, takaw olap wɨsɨp nab anɨb ak nɨb agak, Ñɨ mapen yad yɨbɨl nɨm awl agak. Nop nɨgen yɨp tep yɨbɨl gup agak. Takaw tɨtay agɨnɨmuŋ ak, nɨg dɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Takaw anɨb ak anɨgɨl agek nɨŋɨd, Jisas bɨne okok gos kuŋay nɨŋɨd pɨlɨkɨl, apyap kɨgom yɨmɨl, jomulɨk kɨli ak lum ayaŋ yɨl lɨl yelak. ");
INSERT INTO taw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pen Jisas apɨl kɨlop dɨnɨŋɨd agak, Ma pɨlɨkɨnɨmɨb, tɨkjakɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Agek, kɨlan gɨl nɨgɨlak, ne nokom yek. ");
INSERT INTO taw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pen dum ak kuyan gɨlɨg, Jisas kɨlop agak, Mɨñɨl tɨtay gosup nepɨm anɨb ak, binɨb okok kɨlop ma agñɨnɨmɨb agak. Kɨdek Bɨ Olap Ñɨne kumɨl tɨkjakek nɨm, binɨb okok kɨlop agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Agek nop agɨlak, Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok, kɨli taynen apal, Yilayja ned apenɨgab, kɨdek Bɨ God nop aglup ak lum awl ownɨgab apal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Agelak agak, Nɨŋɨd apal, takaw anɨb ak mɨdeb agak. Yilayja ned apɨl kɨlop agtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pen nɨbop agebin, Yilayja owak ak pen, apek nop ma nɨgɨlak agak. Gos kɨli ke nɨgɨlak tek nop gɨ tɨmel gɨlak agak. Pen Bɨ Olap Ñɨne ak nop abe anɨb ak tek gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Anɨb agek, bɨne okok nɨgɨlak, Jisas Yilayja nop agak anɨb ak, Jon Bɨ Ñɨg Pakñeb ak nop nokom agak. ");
INSERT INTO taw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pen Jisas ayɨp bɨne omɨŋal nokom ayɨp, kɨli gu ayaŋ amjakɨl nɨgɨlak, binɨb kuŋay yɨbɨl yelak. Bɨ olap binɨb yelak nab anɨb ak apɨl, Jisas yek sɨŋak kɨgom yɨmɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Bɨawl, ñɨ yad ak mapen nɨgɨnɨmɨn agak. Nop sawl lek mɨdtep ma gup agak. Pel am mab yɨneb nab okok sek, ñɨg nab okok sek gɨ dam pakup agak. ");
INSERT INTO taw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nop dad bɨnak okok yesɨpal ak amen, nop gɨ mel nɨŋɨd kelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Agek Jisas agak, Nɨbi binɨb mɨñɨl lum awl mɨdebɨm okok, God nop gos ma nɨŋɨd nab nɨbi ayaŋ gɨ tɨmel gɨpɨm agak. Anɨgɨpɨm teplep mel agak. Ma yɨbɨl gos nepɨm anɨb ak, yad ñɨn tɨtay nɨb ayɨp mɨdɨl, mɨŋel nɨbop ak dad ajenɨm agak? Ñɨ anɨb ak dad sɨŋawl yɨp yɨl owɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Anɨb agek dad apelak, kɨcheki nop abaŋ lak ak agyokek, won anɨb ak nep suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anɨgek, bɨne okok Jisas yek ak apɨl, kɨli nep mɨdɨlɨg nop agnɨŋɨd agɨlak, Tay gek kɨcheki abaŋ lak anɨb ak, agyok mel nɨŋɨd kelɨgɨpun agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Agelak agak, God gek seŋ amnɨgab agɨl, gos kɨles gɨl ma nepɨm ak nɨm anɨgup agak. Pen yad nɨbop nɨŋɨd agebin agak. Gos nɨbi ak mab mastet mɨdup sɨkol mɨdeb tek nɨgenɨgabɨm, dum awl lɨg sɨŋadaŋ amnoŋ agem, God gek amnɨgab agak. Pen nɨg wos gɨnɨgabɨm ak, tap tay okok mɨdupsek agem, agɨnɨgabɨm tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas bɨne okok ayɨp, Galili plopens apnan gelak, kɨlop agak, Wulep mɨdeb, Bɨ Olap Ñɨne nop mɨmug nɨŋɨd, binɨb ogɨnap kɨlop ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ñel, nop pɨsnep paklel kumnɨgab ak pen, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agak. Anɨb agek, bɨne okok nop chɨb nɨŋɨd, gos kuŋay yɨbɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pen kɨdek Jisas bɨne okok ayɨp taun Kapeneyam amelak, bɨ God agnɨgep kal awl takis dep okok apɨl, Pita nop agɨlak, Tisa nɨbi ak, takis gup sek akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Agelak agak, Yaw, ne takis gup sek agak. Pen anɨb agɨl kal mɨgan amek, won anɨb ak Jisas Pita nop agnɨŋɨd agak, Gos nad tay nepan agak? Gapman bɨnonɨm okok, takis akal nɨb dɨpal agak? Binɨb man kɨli ke okok nɨb dɨpal akaŋ, binɨb pal okok nɨb dɨpal agak? ");
INSERT INTO taw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Anɨb agek Pita agak, Binɨb pal okok nɨb dɨpal agak. Agek Jisas agak, Yaw, binɨb kɨli ke okok takis ma gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Chɨn pen takis ma ñonɨgabun, kɨlop mɨlɨk yownɨgab tek lup agak. Anɨb ak nad ñu dam ñɨg ayaŋ yokɨl, kubsal ned dɨnɨgaban ak, meg mɨgan ak tɨg lakɨl nɨgɨnɨgaban, mani mɨdup won olap yenɨgab agak. Dɨl, dam takis chɨlmɨŋal ak ñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ñɨn anɨb ak Jisas bɨne okok apɨl nop agɨlak, God binɨb dɨl kɨlop kod yenɨgab ak, bɨ an bɨawl yɨbɨl tek mɨdeb agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Agelak, Jisas ñɨsɨkol olap suk agek apek, bɨne yelak nab sɨŋak dɨl jak ñɨl ");
INSERT INTO taw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","agak, Yad nɨbop nɨŋɨd agebin, gos nɨbi ke nepɨm ak kelɨgɨl, ñɨsɨkol paysɨkol mɨdebal tek yenɨmɨb agak. Mel ak, God nɨbop dɨl kod ma yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Anɨb ak binɨb an ne ke kɨmɨgel mɨdɨl, ñɨsɨkol nɨm awl tek yenɨgab ak, God binɨb dɨl kɨlop kod yenɨgab nab ak bɨawl yɨbɨl tek yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pen binɨb yɨp gos nɨŋɨd, ñɨsɨkol nɨm awl tek olap dɨtep gɨnɨgab ak, nop nep mel, yɨp dɨtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisas takaw olap agak, Pen binɨb ogɨnap, kɨli ñɨsɨkol paysɨkol olap yɨp gos lɨnɨgup ak nop gel apyap pakɨnɨgab ak, tɨmel yɨbɨl gɨnɨgabal agak. Kɨlop kab awl yɨbɨl okok kuŋam ak nag lɨ tɨbɨkɨl, dam ñɨg solwala ak yokel ñɨg ñɨbɨl kubɨkep ak, kɨlop gɨtep gɨpɨlap agak. Taynen? Binɨb ogɨnap koŋɨm mɨdɨl ñɨsɨkol paysɨkol olap nop gɨ tɨmel gɨnɨgabal ak, kɨdek yul awl yɨbɨl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tap ogɨnap apɨl binɨb okok gek, tap si tap tɨmel gɨnɨgabal ak nɨm, kɨdek tɨtay dɨnɨgabal agak. Tap anɨb okok ownɨmuŋ ak pen, bɨ an gek tap tɨmel anɨb ak ownɨgab ak, bɨ anɨb ak kɨdek tɨtay dɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ñɨn kɨd akaŋ, tob kɨd nad olap tap si tap tɨmel gɨnɨg gonɨmuŋ, pɨs kɨd anɨb ak tɨbɨlɨkɨl dɨyokɨnɨmɨn agak. Nak ñɨn kɨd nokom olap akaŋ, tob kɨd nokom olap yenɨgab ak, pel mɨdep ak dɨnɨgaban, teplep yɨbɨl agak. Pen ñɨn nak kɨd omɨŋal akaŋ, tob kɨd omɨŋal yenɨgab ak, mab ke yɨneb amnɨgaban, tɨmel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pen wɨdɨn mɨdup olap tap si tap tɨmel gɨnɨg gonɨmuŋ, wɨdɨn pɨs kɨd anɨb ak tɨgju yokɨnɨmɨn agak. Nak wɨdɨn kɨd nokom olap yenɨgab ak, pel mɨdep ak dɨnɨgaban, teplep yɨbɨl agak. Pen wɨdɨn nak kɨd omɨŋal yenɨgab ak, mab ke yɨneb amnɨgaban, tɨmel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Nɨbi nɨgtep gɨnɨmɨb agak. Ñɨsɨkol paysɨkol olap tap yokɨp agɨl gos ak ma nɨgɨnɨmɨb agak. Yad nɨbop agebin, ensel ñapay sɨkol anɨb okok kɨlop kod mɨdebal okok, kɨli Bapi ne man ne alaŋ mɨdeb ak pelpel wulep sɨŋak mɨdebal agak. Mɨdɨl, ñapay sɨkol anɨgɨl mɨdebal takaw anɨb ak, Bapi nop agñɨbal agak. ");
INSERT INTO taw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jisas takaw olap agak, Nɨbi gos tay nepɨm agak? Bɨ olap chag sipsip 100 tek muk yenɨgab agak. Pen nokom olap am kul genɨgab, ne tɨtay dɨnɨgab agak? Chag sipsip 99 tek kɨlop dum alaŋ kelɨgɨl, nokom am kul gɨnɨgab anop pɨyow nɨgɨnɨg amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yad nɨbop nɨŋɨd agebin, am pɨyow aj aj dɨl nɨm, mɨñmɨñ yɨbɨl gɨnɨgab agak. Chag sipsip 99 tek ne nɨgek tep gup tek ma gɨnɨgab, chag ne am kul gek pɨyow nɨgɨnɨgab anop nɨgek tep anɨb ak ke yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anɨb ak tek, Bapi nɨbi man ne alaŋ mɨdeb ak, ne ñɨsɨkol paysɨkol olap ma kul gɨnɨmuŋ agɨl nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas takaw olap agak, God binɨb ne olap ne nep gɨ tɨmel gonɨmuŋ, am nod ayɨp ke mɨdɨl, tap gɨnɨmuŋ anɨb ak mɨseŋ agɨnɨmɨn agak. Anɨgɨl age nɨg dek nɨm, namam nanay nad tek yɨbɨl yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pen ma nɨg dek, am binɨb nokom akaŋ omɨŋal tek poŋɨd, amɨl nɨg yeleknɨŋ, takaw agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pen anɨgem ma yɨbɨl nɨg donɨmuŋ, binɨb God yɨl mɨdebal okok mɨdupsek nɨg yelaknɨŋ agɨnɨmɨn agak. Pen ma nɨg donɨmuŋ, binɨb God nop gos ma nepal okok sek, bɨ takis dep okok sek, kɨlop gɨpan tek ak nop gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yad nɨbop nɨŋɨd agebin, tap tay gup lum awl ak nɨgem, yɨpɨd ma gek mel agɨnɨgabɨm ak, God man ne alaŋ mɨdeb ak ne abe mel agɨnɨgab agak. Pen tap tay gup lum awl ak nɨgem, yɨpɨd gek yaw agɨnɨgabɨm ak, God man ne alaŋ mɨdeb ak ne abe yaw agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Binɨb omɨŋal akaŋ, omɨŋal nokom tek, gos yɨp nɨŋɨd apnan genɨgabal, yad nab kɨlop okok dɨ wɨlɨk malɨkɨl yenɨgayn agak. Anɨb ak yad tepayaŋ nɨbop nɨŋɨd agebin, binɨb omɨŋal lum awl mɨdɨl, takaw ag adek nokom lɨl, Bapi nop agnɨgenɨgayl, Bapi man ne alaŋ mɨdeb ak ne agɨnɨgayl tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita ne Jisas yek wulep sɨŋak apɨl agak, Bɨawl, God binɨb ne olap yɨp ñɨn tɨtay tek gɨ tɨmel gek, nop nɨŋɨd kelɨgɨnɨm agak? Yɨp ned gɨ tɨmel genɨgab, nop nɨŋɨd kelɨgɨnɨm akaŋ agak? Pen kɨdek yɨp gɨ tɨmel genɨgab, nop nɨŋɨd kelɨgɨnɨm akaŋ agak? Pen yɨp gɨ tɨmel gɨnɨgab ak, gɨ dam dam ñɨn anep kugul oŋɨd amjakek, nop nɨŋɨd kelɨgɨnɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Agek Jisas agak, Yad nep agebin, ñɨn anep kugul tek nɨŋɨd kelɨgɨnɨmɨn agak. Pen nep gɨ tɨmel ogɨnap sek gek, nop nɨŋɨd kelɨgɨnɨmɨn agak. Pelpel nop nɨŋɨd kelɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anɨb ak nɨgɨm agak. God binɨb dɨl kɨlop kod yenɨgab ak, kesɨm debin awl tek gɨnɨgab agak. Bɨawl olap mani ne ogɨnap dɨl, bɨ wog gɨñeb ne ogɨnap kɨlop ñɨl agɨnɨgab, Kɨdek yɨp pen tep ak ñɨnɨmɨb agɨnɨgab agak. Kɨdek pen, bɨ wog gɨñeb ne okok kɨlop agɨnɨgab, Yɨp tep ak ñɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bɨawl ak, bɨ nop wog gɨñeb okok, tap day yɨp okok pen ñɨm agek, bɨ tap day ne mani yɨl 10 milion kina, ñɨn juwɨl kuŋay yɨbɨl nep yek olap nop dad ownɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bɨ anɨb ak tap day awl yɨbɨl yek, pen ñɨnɨmuŋ tek ma lɨnɨgab agak. Anɨgek bɨawl ak nɨŋɨd, bɨne ogɨnap kɨlop agɨnɨgab, Gup anɨb ak nop dɨl, bin ñapay, tap ne tɨtay mɨdeb okok mɨdupsek dɨl, dam lem tawnɨgel, mani anɨb ak dap yɨp ñɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Anɨb agek bɨ anɨb ak pen, kɨgom yɨmɨl, jel kuyan gɨl, bɨawl anop agɨnɨgab, Nad yɨp chɨb nɨŋɨd ñɨn ogɨnap kod mɨdenɨmɨn, tap day nak anɨb ak mɨdupsek day pagɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Agek, bɨawl ak nop chɨb nɨŋɨd, tap day ne anɨb ak nɨŋɨd kelɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Anɨgɨl kelɨgek, bɨ wog gɨñeb anɨb ak ne pen amɨl nɨgak, bɨne ayɨp wog gɨnɨgayl olap yek. Bɨne ayɨp wog gɨnɨgayl anɨb ak, tap day ne mani yɨl nokom sɨkol yɨbɨl nep yenɨgab agak. Nɨŋɨd, nop kuŋam chɨchɨk dɨl agɨnɨgab, Nep mani yɨl nokom ñɨnek ak, yɨp pen ñan agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Agek, bɨne ayɨp wog gɨnɨgayl anɨb ak kɨgom yɨmɨl, jel kuyan gɨl agɨnɨgab, Yɨp chɨb nɨŋɨd ñɨn ogɨnap kod mɨdenɨmɨn, tap day nak anɨb ak mɨdupsek day pagɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Agek, bɨ anɨb ak pen takaw nop ak ma nɨŋɨd anɨb agɨnɨgab, Nep dam nag lenɨgayn, tap day anɨb ak day pagɨl nep nɨm, seŋ amnɨgaban agɨl, nop dam nag lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Anɨgek, bɨne ayɨp wog gɨnɨgabal okok kɨlop chɨbol tɨmel gek, amɨl bɨawl kɨli anop takaw anɨb ak mɨdupsek agñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Agñel, bɨawl ak bɨne anɨb anop suk agek apek agɨnɨgab, Nad bɨ tɨmel yɨbɨl agɨnɨgab agak. Yɨp chaŋ lɨpan, nep chɨb nɨŋɨd tap day yad nep mɨdeb ak kelɨgɨpin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pen taynen, bɨ ayɨp wog gɨpil anop mapen nɨŋɨd tap day ma kelɨgɨpan agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bɨawl ak mɨlɨk tɨmel nɨŋɨd, bɨ anɨb ak nop dam nag lɨl, bɨ nag lep kod mɨdeb kɨlop agɨnɨgab, Nop nag lel, yul gaknɨŋ mɨdɨl, tap day yɨp ak day pagɨl nep, seŋ amnɨgab agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Anɨb ak God binɨb ne okok nɨbop gɨ tɨmel gel kɨlop nɨŋɨd ma kelɨgenɨgabɨm, Bapi man ne alaŋ mɨdeb ak, ne nɨbop abe anɨb ak tek gɨnɨgab agak. Anɨb ak kɨlop chɨb nɨŋɨd, nɨbop tɨmel gɨpal ak nɨŋɨd kelɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas takaw anɨb ak agjuwɨl, Galili plopens kelɨgɨl, Judiya plopens ñɨg Jodan kɨd adaŋ ken amnak. ");
INSERT INTO taw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Amek, binɨb kuŋay yɨbɨl nop kɨdek gelak, binɨb tap gak okok kɨlop gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pen bɨ Pelisi ogɨnap Jisas yek ak apɨl, tay tek agɨnɨgab ak nop ag gɨnɨgun agɨl, agnɨŋɨd agɨlak, God takaw ne tay agup agɨlak? Bɨ olap bin dɨl, pen gos ne ke nɨŋɨd agyokɨnɨgab akaŋ mel, tay gos nepan agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Agelak Jisas pen agak, Buk Baybol tɨkɨlak ak nɨbi ma nepɨm akaŋ agak? Bɨlel bɨlel God ne man alwol gɨlak ñɨn ak, bɨ gɨlɨl bin gɨlɨl gak agak. ");
INSERT INTO taw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pen ne agak, Adek anɨb ak nɨm, bɨ okok nonɨm nap sɨkop ayɨp mɨdɨl, bin dɨlɨg kɨlop kelɨgɨl, kɨli bel jɨmñɨl kɨnel wak nokom yɨbɨl lup agak. ");
INSERT INTO taw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","God agek kɨli omɨŋal mɨdebil tek ma mɨdebil, wak nokom yɨbɨl lup agak. God agek kɨli wak nokom yɨbɨl lup anɨb ak, bɨ ogɨnap kɨlop ag tɨg asɨk keke ma lɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jisas anɨb agek, bɨ Pelisi okok nop agɨlak, Pen taynen Mosis takaw olap tɨkɨl agak, Bin agyokɨnɨg, nop ñu kɨl bad olap tɨk ñɨl agyokɨnɨmuŋ agɨl tɨkak agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Agelak Jisas agak, God ne takaw tep bɨlel agak ak nɨbop yɨlɨk gak ma dɨpɨm tek, Mosis takaw anɨb ak nɨbop ñek bin okok agyokɨpɨm agak. Pen bɨlel God binɨb gɨlak ñɨn ak, anɨb ma gelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pen yad nɨbop agebin, bɨ olap bin ne ak bɨ si ma dup, pen nop yokɨp yɨbɨl agyokɨl, bin kɨdek dɨnɨgab ak, bin si dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Agek, bɨne okok nop agɨlak, Bɨ okok bin dɨl yokɨp agyokɨnɨgel tek ma lup ak nɨm, bin ma dɨnɨgel anɨb ak tep yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Agelak Jisas agak, Bɨ ogɨnap yokɨp yenɨgel tek ma lup agak. God bɨ yokɨp yenɨgel agɨl aglak okok nep, yokɨp yenɨgel tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nɨgɨm. Bɨ ogɨnap kɨli bin ma dɨpal okok, anɨgɨl mɨdeb agak. Ogɨnap nonɨm tɨkup ñɨn ak, mubwak kɨli kɨles ma mɨdeb ak ñapay ma tɨkɨnɨgabal tek lup ak nɨm, bin ma dɨpal agak. Ogɨnap bɨ okok wak kɨlop tɨbɨlɨkek, bɨ anɨb okok kɨli ñapay ma tɨkɨnɨgabal tek lup ak nɨm, bin ma dɨpal agak. Pen ogɨnap God binɨb dɨl kɨlop kod yenɨgab wog ak gun agɨl, bin ma dɨpal agak. Pen bɨ takaw anɨb ak nɨgɨnɨg gɨnɨgel tek lup okok, nɨg dɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pen binɨb okok, kɨli Jisas ñɨpay chɨnop okok ñɨn adek dɨnɨŋɨd God nop agnɨgaŋ agɨl, dad apel, bɨne okok pen binɨb anɨb okok kɨlop nɨg chɨkɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Anɨgelak, bɨne okok kɨlop agak, Ñɨsɨkol paysɨkol okok kelɨgem, yɨp yɨl owlaŋ agak. God binɨb dɨl kɨlop kod yenɨgab anɨb ak nɨm, ñɨsɨkol paysɨkol anɨb okok tek agak. ");
INSERT INTO taw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anɨb agɨl, kɨlop ñɨn dɨ mɨdɨlɨg God nop agnɨŋɨd, tɨkjakɨl man wakay olap amnak. ");
INSERT INTO taw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pen bɨ olap Jisas yek ak apɨl agak, Tisa, yad tap tay tep ak gen, God yɨp dek pel pelnep yenɨgayn agak? ");
INSERT INTO taw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Agek Jisas agak, Taynen yɨp tap tay tep tap tay tɨmel agɨl agnepan agak? God nokom nɨm bɨ tep mɨdeb agak. Pen pel pelnep yenɨm agɨl, God takaw adek ak dɨl kɨdek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Agek agak, God takaw adek akal tek ageban agak? Agek Jisas agak, Chɨp ma ñagɨnɨmɨb agak. Bin si bɨ si ma gɨnɨmɨb agak. Tap si ma dɨnɨmɨb agak. Yepɨs ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nanɨm nap takaw agɨnɨgel tek nɨŋɨd kɨdek gɨnɨmɨb agak. Binɨb ogɨnap kɨlop, nɨbi ke mapen lɨpɨm tek gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Anɨb agek, bɨ pɨlaj anɨb ak agak, God takaw anɨb okok mɨdupsek nɨg dɨpin agak. Pen tap tay olap ke wulep yowup ak, yad abe gɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Agek Jisas agak, Yad bɨ teplep yɨbɨl yenɨm agɨl, amɨl tap nak okok mɨdupsek dam le tawnɨgel mani dɨl, binɨb yɨmgeptek okok kɨlop ñɨl nɨm, tap teplep nad ak yenɨgaban, God man ne alaŋ agak. Pen apin tek gɨl apɨl, yad ayɨp ajonɨgul agak. ");
INSERT INTO taw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Agek, tap ne kuŋay yek tek, takaw anɨb ak nɨgak ak, chɨb nɨgɨlɨg gos kuŋay nɨgɨlɨg amnak. ");
INSERT INTO taw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pen ne anɨgɨl amek, Jisas bɨne okok kɨlop agak, Yad nɨbop nɨŋɨd agebin, binɨb mani tap kɨli kuŋay yenɨgab okok, kɨli koslam yɨbɨl binɨb ne mɨdel, kɨlop dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yad nɨbop tepayaŋ agebin, chag kamel okok ñu alɨguñ yokep mɨgan ak amnɨg kasek amnɨgel tek lup agak. Binɨb pen mani tap kɨli kuŋay mɨdeb okok, kɨli God binɨb ne mɨdɨnɨg, koslam yɨbɨl binɨb ne mɨdel, kɨlop dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jisas bɨne okok takaw anɨb ak nɨŋɨd, gos awl nɨŋɨd wal awl agɨl agɨlak, Takaw agup anɨb ak, binɨb okok God yɨl pel pelnep yonɨgun tek ma lup agɨlak. Akaŋ tay agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Agel Jisas kɨlop nɨgɨlɨg agak, Binɨb okok kɨli ke gɨnɨgel tek ma lɨnɨgab ak pen, God ne nɨm tɨtay gɨnɨg, mɨdupsek gɨnɨmuŋ tek nep lup agak. ");
INSERT INTO taw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas anɨb agek, Pita agak, Nɨgan, tap chɨn okok mɨdupsek kelɨgɨl, nad ayɨp nep chɨgɨl kɨdek gɨpun agak. Chɨn pen tap tay dɨnɨgabun agak? ");
INSERT INTO taw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Agek Jisas agak, Yad nɨbop nɨŋɨd agebin, tap okok mɨdupsek koŋɨm nɨb sɨlok lɨnɨgab ñɨn ak, Bɨ Olap Ñɨne yɨb awl yɨbɨl ak dɨl, bɨnonɨm besɨg mɨdep adek alaŋ ne besɨgɨl yenɨgab agak. Ñɨn anɨb ak nɨm, nɨbi yɨp kɨdek gɨpɨm okok nɨbop agen, nɨbi abe bɨnonɨm besɨg mɨdep anep umɨgan okok adek alaŋ besɨgɨl yenɨgabɨm agak. Besɨgɨl mɨdɨl, Yislel binɨb jɨj anep umɨgan ak kɨlop kod yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Binɨb yɨp gos nɨŋɨd, nɨmam nɨnay akaŋ, nonɨm nap akaŋ, ñɨpay akaŋ, kal wog day akaŋ, tap tɨtay okok kelɨgɨnɨgabal okok, God binɨb anɨb okok kɨlop tap teplep kuŋay yɨbɨl pen ñɨnɨgab agak. Pen God ne abe gek, pel pelnep yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Binbɨ kuŋay okok kasek amnun agɨl ned abal, kɨli kɨdek amnɨgabal agak. Pen binbɨ kɨdek abal okok, kɨlop tawsak lɨl ned amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas takaw olap agak, God binɨb dɨl kɨlop kod yenɨgab ak, kesɨm debin awl tek gɨnɨgab agak. Bɨ wayn wog nap olap, bɨ ogɨnap am dad apen wog yad ak gɨlaŋ agɨl, man tɨkaknɨŋ tɨkjakɨl bɨ ogɨnap dɨnɨg amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Amɨl binɨb sɨkim jɨmñɨl gɨpal okok apjakɨl, bɨ ogɨnap pɨyow nɨŋɨd, nɨbop mani anɨgɨl tawnɨgayn agɨl, kɨli ayɨp takaw ag adek nokom lɨl, agyokek am wayn wog nop ak gɨ yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pen sub ak yep nab sɨŋak aplanɨgab won ak, binɨb sɨkim jɨmñɨl gɨpal okok jɨ tep amɨl nɨgɨnɨgab, bɨ ogɨnap sek yokɨp yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kɨlop nɨŋɨd anɨb agɨnɨgab, Nɨbi abe am wog yɨp ak gem, wog gɨnɨgabɨm tek, mani anɨb ak nɨbop ñɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Agek, am wog nop ak gɨ yenɨgabal agak. Pen subnab awl alaŋ won ak sek, sub kuyan gɨnɨgab won ak sek, ne binɨb sɨkim jɨmñɨl gɨpal okok jɨ tep amɨl, takaw anɨb ak nep agɨl, bɨ ogɨnap sek dek, wog nop ak gɨ yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pen sub saŋɨd amnɨgeb won ak, binɨb sɨkim jɨmñɨl gɨpal okok tepayaŋ amɨl nɨgɨnɨgab, bɨ ogɨnap sek ap yenɨgabal ak nɨm, kɨlop agɨnɨgab, Nɨbi taynen ñɨn awl wog ma gɨl, yokɨp yɨbɨl mɨdebɨm agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Agek nop agɨnɨgabal, Bɨ olap chɨnop wog olap ma ñub agɨnɨgabal agak. Agel agɨnɨgab, Nɨbi abe am wayn wog yɨp ak gɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pen dugep won ak, bɨawl ne bɨ wog kod mɨdep ne anop agɨnɨgab, Am bɨ wog yɨp gebal okok kɨlop age apel, bɨ kɨdek opal okok mani kɨli ak ned ñɨl, bɨ ned opal okok kɨli ak kɨdek ñɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Agek, bɨ wog kod mɨdep ak, ne bɨ anɨb okok kɨlop suk agek apel, bɨ sub saŋɨd amnaknɨŋ ap wog gɨnɨgabal okok, ap mani kɨli ak ned dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pen kɨli anɨgɨl dɨlaknɨŋ, bɨ ned agek ap wog gɨnɨgabal okok, mani awl ak dɨnɨgabun agɨnɨgabal ak pen, kɨdek dɨlɨg nɨgɨnɨgabal, mani nab anɨb anep dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dɨl, day bɨ wayn wog nap nɨb ak ayɨp penpen agɨl agɨnɨgabal, ");
INSERT INTO taw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chɨn taynen bɨ kɨdek opal okok mani dɨpal tek nep dɨpun agɨnɨgabal agak? Man tɨkup won ak tɨkjakɨl, sub sɨj tɨmel nɨgaknɨŋ, wog gon gon yɨlɨk gup ak pen, bɨ apɨl sɨkol won olap wog gesɨpal okok, kɨlop mani ñɨban tek nep chɨnop ñɨban agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Agel, bɨ wog day nap nɨb ak nɨŋɨd, bɨ kɨli olap nop agɨnɨgab, Bogɨlak, nep gɨ tɨmel ma gɨpin agɨnɨgab agak. Takaw ag adek nokom lɨl, apul tek ñɨbin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Bɨ kɨdek opal okok, bɨ ned opal okok ayɨp adɨp adɨp ñɨnɨg ñɨnɨgayn, ak tap yad agɨnɨgab agak. Anɨb ak bɨ ogɨnap taydɨl mel agɨnɨgabal agɨnɨgab agak. Kɨlop monmon ñɨbin ak taynen nep mɨlɨk yowup agɨnɨgab agak. Mani ñɨbin ak dad kal nad amnoŋ agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas kesɨm anɨb ak agjuwɨl agak, Binbɨ kasek amnun agɨl ned abal, kɨli kɨdek amnɨgabal agak. Pen binbɨ kɨdek abal okok, kɨlop tawsak lɨl ned amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jelusalem amɨlɨg, kanɨb nab okok bɨne anep umɨgan ak kɨlop dad gol okok amɨl, ke yelaknɨŋ kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nɨgɨm. Chɨn Jelusalem amon, Bɨ Olap Ñɨne nop mɨmug gɨl, dɨl bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek kɨlop ñɨnɨgab agak. Ñek, kɨli takaw aglɨl agɨnɨgabal, Bɨ anɨb awl nop paklep agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Anɨb agɨl, bɨ Juda mel okok kɨlop ñɨnɨgabal agɨlak. Ñel, nop agjuwɨl, nag dɨl pakɨl, dam mab bak alaŋ chɨpɨl pak tɨbɨk lel kumnɨgab ak pen, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pen bɨ Sepedi ñɨne omɨŋal ak kɨlop, nonɨm poŋɨd Jisas yek ak apɨl, kɨgom yɨmɨl agak, Yad takaw olap mɨdek apebin agak. ");
INSERT INTO taw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Agek Jisas agak, Takaw anɨb ak tay agak. Agek agak, Yɨp tep gɨnɨgab ak, nad age, kɨdek nad bɨnonɨm mɨdɨl binɨb kod yenɨgaban ñɨn ak, ñɨ yad omɨŋal ak bak nep sɨŋak pɨspɨs besɨgɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Anɨb agek Jisas pen kɨlop agak, Nɨbi gos nɨgtep gɨl yɨp ma agnɨgebɨm agak. Ñɨli omɨŋal ñɨg sɨlek yad ñɨŋɨnɨgayn ak abe ñɨŋɨnɨgayl akaŋ agak? Agek, Yaw, ñɨŋɨnɨgul tek lɨnɨgab agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Agelek agak, Nɨŋɨd apil, ñɨg sɨlek ñɨŋɨnɨgayn ak ñɨŋɨnɨgayl agak. Ak pen an ñɨn yɨpɨd kɨd ak besɨgɨnɨgab, an ñɨn aŋɨd kɨd ak besɨgɨnɨgab ak, yad ke ma aglɨnɨgayn agak. Ak God tap ne, ne ke kɨlop nɨgup tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pen Jisas bɨne anep wajɨlem okok, kɨli bɨ madɨlmal agnɨgep anɨb ak nɨŋɨd, kɨlop ag gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ag gelak, Jisas kɨlop agek mɨdupsek apel agak, Nɨbi nepɨm, man keke binɨb Juda mel okok, bɨawl yɨbɨl kɨli okok kɨlop kodɨpal agak. Pen bɨawl kɨli okok, kɨli takaw kɨles gɨl agɨl apal, Takaw chɨnop kɨdek gem apal agak. ");
INSERT INTO taw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nɨbi pen anɨb ak tek ma gɨnɨmɨb agak. Bɨ nɨbi olap bɨawl mɨdɨnɨg gonɨmuŋ ak, ne wog gɨñeb nɨbi yonɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pen bɨawl yɨbɨl mɨdɨnɨg gonɨmuŋ ak, binɨb okok mɨdupsek kɨlop monmon yɨbɨl wog gɨñeb yonɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bɨ Olap Ñɨne abe anɨb ak nep tek agak. Yad bɨawl mɨden yɨp wog gɨñɨnɨgel agɨl lum awl ma owak agak. Ne kɨlop gɨñɨnɨg owak agak. Kɨlop kuŋay tawnɨm agɨl gos nɨŋɨd kumak agak. ");
INSERT INTO taw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pen Jisas bɨne okok ayɨp taun Jeliko kelɨg amnɨlaknɨŋ, binɨb kuŋay yɨbɨl nop kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pen bɨ wɨdɨn koy omɨŋal ak, kanɨb gol sɨŋak besɨg mɨdɨleknɨŋ, Jisas padɨkeb agel nɨŋɨd, meg mɨgan dad aplanɨl agɨlek, Depid Ñɨne, chɨlop mapen nɨŋɨd dɨtep gɨnɨmɨn agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Agelek, binɨb okok kɨlop omɨŋal nɨŋɨjsek lɨl ag gɨl agɨlak, Takaw pug ma agɨnɨmil agɨlak. Anɨb agelak pen, takaw kɨlop ak ma dɨl, meg mɨgan awl dad aplanɨl agɨlek, Depid Ñɨne, chɨlop mapen nɨŋɨd dɨtep gɨnɨmɨn agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Anɨb agel, Jisas ap yelek sɨŋak alad gɨl, kɨlop omɨŋal suk agɨl agak, Ñɨlop taydɨnɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Agek agɨlek, Bɨawl, chɨlop ge wɨdɨn nɨgul agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Agelek, Jisas kɨlop omɨŋal yɨmug nɨŋɨd, wɨdɨn kɨlop ak dɨnɨgek, won anɨb anep wɨdɨn nɨgɨlek, ne amnaknɨŋ kɨdek gɨlek. ");
INSERT INTO taw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas bɨne okok ayɨp am am Jelusalem wulep wulep gɨlɨg, man sɨkol Betpage amjakɨlak. Man sɨkol anɨb ak dum Olip nokom yek. Pen amjakɨl, Jisas bɨne omɨŋal ned agyokɨl ");
INSERT INTO taw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kɨlop agak, Man sɨkol wakay adaŋ amɨl kasek nɨgɨnɨgayl, chag donki olap ñɨluk ne ayɨp tunɨg lel yenɨgabal agak. Nag ak wɨsɨbɨl poŋɨd ownɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pen bɨ olap apɨl, taynen anɨgebil agonɨmuŋ, nop agɨnɨmil, Bɨawl ak chag donki omɨŋal ak dɨl wog olap gɨnɨgab agɨnɨmil agak. Anɨb agɨnɨmil, kasek yaw agek dad ownɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tap gak anɨb ak, bɨ God gos ñek agñeb olap gɨnɨgab agɨl tɨkak tek nep gak. Ne tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Taun Sayon binɨb okok kɨlop takaw anɨb ak agɨnɨmɨb, Nɨgɨm, bɨnonɨm nɨbi ak chag donki adek besɨgɨl nɨbop yɨl apeb agɨnɨmɨb agɨl tɨkak. Ne bɨ sayn tep yɨbɨl olap, chag donki ñɨluk adek ak besɨgɨl apeb agɨnɨmɨb agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pen Jisas bɨne agyokek amnɨlek omɨŋal anɨb ak, agak tek gɨlek. ");
INSERT INTO taw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chag donki nonɨm ak sek ñɨluk ak sek poŋɨd apɨl, chech palsek tɨg asɨkɨl, chag donki adek ak lelek, Jisas adek anɨb ak besɨgak. ");
INSERT INTO taw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pen binɨb okok, ogɨnap chech palsek kɨli okok tɨg asɨk kanɨb adek ak lɨlɨg, ogɨnap mab wɨj okok tɨpag dap kanɨb adek ak lɨlɨg gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Binɨb ogɨnap ned gɨl, ogɨnap kɨdek gɨl, suk awl agɨlɨg agɨlak, Hosana, Depid Ñɨne nop tep yɨbɨl agɨnɨgun agɨlak. Bɨ anɨb ak Bɨawl ne agyokek owup ak, Bɨawl ne nop gɨtep gɨnɨmuŋ agɨlak. God man ne alaŋ mɨdeb ak, nop tep yɨbɨl agɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jelusalem amjakaknɨŋ, binɨb okok ju dɨl gos pal awl yɨbɨl lɨl agɨlak, Bɨ anɨb ak an agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Agelak, binɨb Jisas ayɨp owlak okok agɨlak, Bɨ nɨm anɨb awl Jisas, bɨ God gos ñek agñeb ak agɨlak. Ne taun Nasalet Galili plopens nɨb ak owup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amɨl, binɨb tap tawlɨg yelak okok, kɨlop mɨdupsek yuk yokak. Yuk yokɨl, bog bad ak mani penpen ñɨlɨg delak okok tɨg adɨkɨl, bɨ yawl dap lɨl tawlɨg bog bad ak besɨg yelak okok abe tɨg adɨkɨl gak. ");
INSERT INTO taw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Anɨgɨlɨg, kɨlop ag gɨl agak, Buk Baybol ñu kɨl tɨkɨl agɨlak, God ne agup, Kal yad ak, yɨp agnɨgep kal ak mɨdeb agup agɨl tɨkɨlak agak. Pen nɨbi anɨgem, bɨ tap si dɨl weyɨg mɨdebal kal olap tek lup agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pen Jisas God agnɨgep kal awl kab wali kus gɨl yek ak, wali mɨgan mɨdaknɨŋ, binɨb wɨdɨn koy gɨl, tob tɨmel gɨl gak ogɨnap apelak, kɨlop gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne tap mageptek anɨb okok gek, ñapay sɨkol okok suk agɨlɨg agɨlak, Hosana, Depid Ñɨne nop tep yɨbɨl agɨnɨgun agɨlak. Pen kɨli anɨb agelak, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek kɨli anɨb okok mɨdupsek nɨgel, mɨlɨk yɨbɨl yapek agɨlak, ");
INSERT INTO taw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nep agebal ak nɨgeban akaŋ agɨlak? Agelak Jisas agak, Yaw, agebal ak nɨgebin ak pen, buk Baybol ñu kɨl tɨkak anɨb ak ma nepɨm akaŋ agak? Anɨgɨl tɨkɨl agak, Ñapay ŋaŋ okok kɨlop gos tep ñe, yɨb nep dad aplanɨgabal agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Anɨb agɨl, kɨlop kelɨgɨl, am man sɨkol Betani kɨnak. ");
INSERT INTO taw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mɨnek man kɨdeyɨl tɨkak won ak, Jisas adɨkɨd Jelusalem ownɨg, kanɨb nab okok apek yuwan gak. ");
INSERT INTO taw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yuwan gek, kanɨb nab gol sɨŋak mab pik kɨlem olap nɨŋɨd jɨj sɨŋak amɨl nɨgak, mɨdup ma pulak, wɨj okok nep yek. Anɨgek mab anɨb ak nop agak, Kɨdek mɨdup ma yɨbɨl pulɨnɨgaban agak. Anɨb agaknɨŋ, day mab pik kɨlem anɨb ak mɨlep gak. ");
INSERT INTO taw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bɨne okok nɨŋɨd, gos pal lɨl wal agɨl agɨlak, Taydɨl mab anɨb awl kasek mɨlep geb agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Agelak Jisas kɨlop agak, Yad nɨbop nɨŋɨd agebin agak. Chɨn agon abe gɨnɨmuŋ agɨl, gos okok ma nɨgenɨmɨb, God ne gɨnɨgab agɨl, gos nokom nɨgem gɨnɨgab agak. Pen anɨb anep mel, dum awl lɨg amnaŋ ñɨg solwala nab sɨŋak agem, gek amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pen God nop gos lɨnɨŋɨd agnɨgem, agɨnɨgabɨm tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas God agnɨgep kal awl kab wali kus gɨl yek ak, wali mɨgan ayaŋ amɨl, binɨb okok kɨlop takaw agñak. Agñaknɨŋ, bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek kɨli apɨl, nop agɨlak, Nad kɨles akal nɨb dɨl, tap anɨb ak gɨ ajɨpan agɨlak? Nep an anɨgɨnɨmɨn agek, gɨ ajɨpan agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Agelak Jisas pen agak, Nɨbop takaw olap abe agnɨgen, yɨp agñem, pen an agek gɨ ajɨpin ak, nɨbop agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon binɨb okok kɨlop ñɨg pakñak ak, God agek pakñak akaŋ, bɨ gos ne ke nɨŋɨd pakñak agak? Anɨb agek, kɨli ke agnɨg agnɨg gɨl agɨlak, Chɨn agɨnɨgabun, God agek binɨb okok kɨlop ñɨg pakñak agon, ne taynen Jon takaw nop ak ma dɨpɨm agɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pen binɨb okol, kɨli Jon bɨ God gos ñek agñeb yolɨgup ak agɨl gos nepal agɨlak. Anɨb ak tek, chɨn agɨnɨgabun, Jon gos ne ke nɨŋɨd gak agon, chɨnop kab sɨlok paklɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gos anɨb ak nɨŋɨd anɨb agɨlak, Chɨn ma nopun agɨlak. Anɨb agelak, Jisas kɨlop agak, Nɨbi yɨp ma agñɨbɨm tek, yɨp an agek tap anɨb okok gɨpin ak nɨbop pen ma agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas takaw olap agak, Pen nɨbi tay gos nepɨm agak? Bɨ olap, ñɨne omɨŋal yenɨgab agak. Nap ne ñɨne ned ak nop yenɨgab ak apɨl agɨnɨgab, Ñɨ, nad mɨñɨl wayn wog ak am gɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Agek, ñɨne pen agɨnɨgab, Mel, yad ma gɨnɨgayn agɨnɨgab agak. Anɨb agɨl, kɨdek pen gos nɨŋɨd, am wayn wog ak genɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nap pen am ñɨ kɨdek anop abe agɨnɨgab agak. Agek, Yaw bapi, yad gɨnɨgayn agɨnɨgab ak pen, ma am gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pen ñɨ omɨŋal anɨb ak, an nap agɨnɨgab tek nɨg dɨnɨgab agak? Agek, bɨ anɨb okok agɨlak, Ñɨne ned ak agɨlak. Agelak Jisas agak, Yad nɨbop nɨŋɨd agebin, nɨbi yokɨp mɨdɨpeknɨŋ, bɨ takis dep okok sek, kanɨbtam bin okok sek, kɨli nɨbop tawsak lel, God kɨlop ned dɨl kod mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon Bɨ Ñɨg Pakñeb ak apɨl, nɨbop suŋtep yenɨgabɨm takaw ak agñolɨgup ak pen, kɨdek ma gɨpek agak. Bɨ takis dep okok sek, kanɨbtam bin okok sek kɨli pen takaw anɨb ak nɨŋɨd kɨdek gɨlak agak. Kɨli gɨlak anɨb ak nepek ak pen, nɨbi gos kɨdeyɨl olap nɨŋɨd, Jon takaw ne ak ma dɨpek agak. ");
INSERT INTO taw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas takaw olap agak, Takaw paladaŋ lɨl olap sek agen nɨgɨnɨmɨb agak. Bɨawl olap wayn wog ak gɨ yɨmɨl wali gɨl, kab kɨwok mɨgan ak olap gɨlɨnɨgab agak. Kab kɨwok anɨb ak, kɨli wayn mɨdup dɨl taw chɨb jakɨnɨgab agak. Pen wayn mɨdup ak ap si ñɨŋɨnɨgel tek lup ak nɨg yonɨgun agɨl, kal palawl adek alaŋ olap gɨnɨgab agak. Pen bɨ ogɨnap kɨlop agɨnɨgab, Wayn wog yad ak kod yenɨmɨb, kɨdek pulɨl pok gek, yad ogɨnap dɨnɨm nɨbi ogɨnap dɨnɨmɨb agɨnɨgab agak. Anɨb agɨl, ne man palawl okok amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wayn mɨdup ak pok gaknɨŋ, bɨ wog gɨñeb ne okok kɨlop agɨnɨgab, Yɨp ogɨnap am dad owɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Agek, kɨli amjakel, bɨ wayn wog kod yenɨgabal okok tɨkjakɨl, bɨ wog gɨñeb olap nop pakɨnɨgabal, olap nop kab ju pakɨnɨgabal, olap nop pɨsnep paklel kumnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Anɨgel, bɨawl wayn wog nap nɨb anɨb ak, bɨ tapɨn kab olap pen agyokɨnɨgab agak. Agyokek amenɨgabal, bɨ wayn wog kod yenɨgabal okok kɨli, kɨlop anɨb ak tek gɨ tɨmel gɨl pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anɨgel, bɨawl wayn wog nap nɨb ak agɨnɨgab, Ñɨ yad ak agyoken nɨm, takaw nop ak nɨgɨnɨgabal agɨl, agyokek amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amjakek, bɨ wayn wog kod yenɨgabal okok nop nɨŋɨd, kɨli ke agɨnɨgabal, Bɨ wog nap nɨb ñɨne ak apeb awl agɨnɨgabal agak. Nap tep ak dɨnɨgeb tek, nop paklon kumek, kɨdek tap wog okol mɨdupsek dɨnɨgabun agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Anɨb agɨl, nop dɨl dad wog day seŋ kɨd okdaŋ ken amɨl, pɨsnep paklɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Anɨgenɨgabal, kɨdek bɨawl wayn wog nap nɨb ak apɨl, kɨlop tɨtay gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Agek binɨb okok kɨli agɨlak, Ne bɨ tɨmel gɨpal anɨb okok kɨlop gek, yul awl yɨbɨl dɨl kumnɨgabal agɨlak. Kɨdek pen bɨ ogɨnap sek dɨl, kɨlop agek wayn wog ne ak dɨl kod mɨdtep gɨnɨgabal agɨlak. Wayn mɨdup pok gɨnɨgab ñɨn ak, nop tek ak tɨk dam ñɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Agelak Jisas kɨlop agak, Buk Baybol takaw kɨl tɨkɨlak ak nepɨm tek lup akaŋ agak? Tɨkɨl agɨlak, Bɨ kal gep okok kab olap ma dɨnɨgun agɨl kelɨgɨlak ak, kab anɨb ak mɨñɨl kal meg nab ayaŋ tek ak mɨdeb agɨl tɨkɨlak agak. Bɨawl chɨn anɨgak ak, chɨn tap anɨb ak tap awl gos nɨŋɨd, teplep yɨbɨl mɨdeb gak agɨl gos nopun agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Anɨb ak tek yad nɨbop agebin, God nɨbop ned dɨl kod mɨdeb ak pen, nɨbop kelɨgɨnɨgab agak. Nɨbop kelɨgɨl, binɨb ogɨnap ke okok nɨb kɨlop dɨl kod yenɨgab agak. Kɨlop kod yek, God muk okok mɨdɨl, gɨtep gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Binɨb kab anɨb ak adek apyap pakɨnɨgabal okok kɨlop tapɨn yɨbɨl pakɨnɨgab agak. Kab anɨb ak pen, binɨb kɨlop pɨgju apyapɨl lɨ bɨlɨkɨnɨgab okok, pɨsnep pak jɨsɨpuk gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bɨ God nop sɨbogep bɨawl okok sek, bɨ Pelisi okok sek kɨli Jisas takaw paladaŋ lak anɨb ak nɨŋɨd, chɨnop nep agup ak ");
INSERT INTO taw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nop nag lun agɨl gos nɨgɨlak. Anɨgɨl gos nɨgɨlak ak pen, binɨb okok kɨli Jisas ne bɨ God gos ñek agñeb olap nɨgɨlak. Anɨb ak bɨawl okok kɨli binɨb chɨnop kab sɨlok paklɨnɨgabal agɨl, kɨlop pɨlɨkɨl Jisas nop kelɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas tepayaŋ takaw paladaŋ lɨl agɨl kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","God binɨb dɨl kɨlop kod yenɨgab ak, kesɨm debin awl tek gɨnɨgab agak. Gapman bɨnonɨm olap ñɨne ak bin dɨnɨg gek, tap awl ñɨŋɨnɨg, tap mɨdup dap nan gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dap nan gɨl, bɨ wog gɨñeb ne ogɨnap agyokɨl agɨnɨgab, Binɨb aglɨnek okok am agem apel, tap awl ak ñɨŋun agɨnɨgab agak. Agek, amɨl binɨb anɨb okok kɨlop agɨnɨgabal ak pen, kɨli kelɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Anɨgel, bɨ wog gɨñeb ne ogɨnap sek agyokɨnɨgab agak. Agyokɨl agɨnɨgab, Nɨbi amɨl binɨb anɨb okok kɨlop agɨnɨmɨb, Bɨnonɨm ak agup, Chag bulmakaw awl ogɨnap, malep ogɨnap paklɨl, tap okok mɨdupsek dap nan gek, tap awl ñɨŋɨnɨg ownɨmɨb agup agɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Anɨb agek, kɨli am agɨnɨgabal ak pen, takaw kɨlop ak dɨyokɨnɨgabal agak. Ogɨnap tap wog kɨli okok amnɨgabal, ogɨnap mani wog kɨli ak gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pen ogɨnap, gapman bɨnonɨm bɨ wog gɨñeb nop okok dɨl gɨ tɨmel gɨl, paklel kumnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Anɨgel, bɨnonɨm nɨgek chɨbol nop ak tɨmel yɨbɨl gek, bɨ chɨm kadɨŋ gep ne okok agyokɨnɨgab agak. Agyokek, am binɨb tɨmel gɨnɨgabal anɨb okok kɨlop paklɨjuwɨl, kal kɨlop okok dagɨl ju pakel amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pen bɨ wog gɨñeb ne okok kɨlop agɨnɨgab, Tap mɨdup tap okok dagɨl nan gɨpun ak pen, binɨb ned suk agɨnek okok, kɨli binɨb tɨmel gup okok anɨb ak tek ma ownɨgel agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Anɨb ak nɨbi amɨl, kanɨbtam okok mɨdɨl, binɨb nɨgɨnɨmɨb okok kɨlop suk agɨl monmon apem tap awl ñɨŋɨnɨgun agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Anɨb agek, bɨ wog gɨñeb ne okok amɨl, kanɨbtam okok mɨdɨl, binɨb tep gɨnɨgabal okok, binɨb tɨmel gɨnɨgabal okok monmon poŋɨd ownɨgabal agak. Apel, bin dɨnɨg tap awl ñɨŋɨnɨgabal kal mɨgan anɨb ak tɨbɨk dɨl yɨbɨl yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pen bɨnonɨm ak, binɨb opal anɨb okok nɨgin agɨl, kal mɨgan ayaŋ amɨl nɨgɨnɨgab, bɨ olap bin dɨnɨg ñɨn ak chech teplep yɨbɨl lɨpal ak tek ma lɨl ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Anɨgek nop agɨnɨgab, Bogɨlak, taynen bin dɨnɨg tap ñɨŋɨnɨg chech lɨpal ak lɨl mel, yokɨp yɨbɨl apɨl mɨdeban agɨnɨgab agak? Agek bɨ anɨb ak pen takaw olap ma agek, ");
INSERT INTO taw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","bɨnonɨm ak bɨ wog gɨñeb ne okok kɨlop agɨnɨgab, Bɨ nɨm awl ñɨn tob nop okok tunɨg tɨbɨkɨl, dam kɨsɨlɨm owup nab seŋayaŋ dɨyokɨnɨmɨb agɨnɨgab agak. Dɨyokem, binɨb mɨdebal anɨb okok ayɨp meg sulɨlɨg, chaŋ lɨlɨg yenɨgel agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas takaw paladaŋ lak anɨb ak agjuwɨl kɨlop agak, God binɨb kuŋay yɨbɨl suk agup ak pen, mɨdupsek ma dɨnɨgab agak. Binɨb ogɨnap nep dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pen bɨ Pelisi okok kɨli amɨl, Jisas nop takaw tay ak agon, pen monmon agek nɨŋɨd, nop dam nag lɨnɨgun agɨl, takaw agnɨg agnɨg gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Agjuwɨl, bɨ kɨli ke ogɨnap ayɨp, Helod bɨne ogɨnap ayɨp kɨlop agyokel, Jisas yek ak amɨl agɨlak, Tisa, chɨn nopun, nad bɨ nɨŋɨd yɨbɨl nep apan agɨlak. God agup tek nep nɨŋɨd, binɨb okok kɨlop yɨpɨd gɨl yɨbɨl agñɨban agɨlak. Bɨawl yɨb okok sek, binɨb yokɨp okok sek kɨlop nɨŋɨd ma pɨlɨkɨpan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Anɨb ak nad gos tay nepan agɨlak? Chɨnop agñan, chɨn tay gɨnɨgun agɨlak? Lom gapman bɨnonɨm nop takis ñɨnɨgun akaŋ mel agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Agelak, Jisas ne gos tɨmel nɨgɨlak anɨb ak nɨŋɨd agak, Nɨbi yɨp taynen takaw yepɨs anɨb ak agnepɨm agak? Bɨ tay yepɨs agep okok mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mani takis ñɨbal anɨb ak, olap yɨp dɨñem nɨgin agak. Agek, dap ñel nɨŋɨd ");
INSERT INTO taw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","kɨlop agak, Mani bak ak, an jomulɨk ak sek, yɨb ak sek mɨdeb agak? ");
INSERT INTO taw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Agek agɨlak, Lom gapman bɨnonɨm mɨdeb agɨlak. Agel kɨlop agak, Anɨb ak Lom gapman bɨnonɨm ak ne tap yɨp ñɨnɨmɨb agup anep ñɨnɨmɨb agak. God tap yɨp ñɨnɨmɨb agup anep ñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Anɨb agek nɨŋɨd, kɨli gos palawl lɨl, nop kelɨgɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ñɨn anɨb anep, Sajusi bɨ okok, kɨli binɨb kumɨl tepayaŋ ma tɨkjakɨpal agɨl nɨgelɨgɨpal tek, ogɨnap Jisas yek ak apɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tisa, Mosis takaw olap chɨnop agak agɨlak. Anɨb agak, Bɨ olap bin dɨl, ñapay tɨkɨl mel, yokɨp kumenɨgab, nɨmam ne olap pen bin kaŋɨl anɨb ak dɨl, nɨmam kumak ak ñapay nop agɨl tɨkɨnɨgab agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Anɨb ak, bɨ wagen sek anep kugul ak yelak agɨlak. Nɨmam ned ak bin dɨl, ñapay tɨkɨl mel yokɨp kumak agɨlak. Anɨgek, nɨmam nab ak pen, bin anɨb anep dɨl, ");
INSERT INTO taw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ñapay tɨkɨl mel, yokɨp kumak agɨlak. Anɨgek, nɨmam ak pen dak agɨlak. Ak abe ñapay tɨkɨl mel, yokɨp kumak agɨlak. Anɨb anep gɨ dam dam nɨmam anep kugul ak, mɨdupsek ñapay tɨkɨl mel, yokɨp kumdɨlak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pen kɨdek bin ak abe kumak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Anɨb ak, binɨb kubal okok tepayaŋ tɨkjakɨnɨgabal ñɨn ak, bin nokom bɨne dɨl anep kugul lak anɨb ak, ne nɨmam an bin ne yenɨgab agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Agelak Jisas kɨlop pen agak, Nɨbi buk Baybol takaw tɨkɨlak ak sek, God kɨles ne ak sek ma nepɨm agak. Anɨb ak tek sawl sek lɨl takaw monmon apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Binɨb kubal okok tepayaŋ tɨkjakɨnɨgabal ñɨn anɨb ak, God ensel ne okok mɨdebal tek mɨdɨl, bin okok bɨ ma del, bɨ okok abe bin ma dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pen binɨb tepayaŋ ma tɨkjakɨnɨgabal apɨm ak, God nɨbop agup ak, nɨbi ma nepɨm akaŋ agak? Takaw anɨb ak agup, ");
INSERT INTO taw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Eblaham, Aysak, Jekop God kɨli nɨm, yad mɨdebin agup agak. Pen nɨbi apɨm tek, binɨb okok pɨsnep kubɨlap ak, God kɨli mɨdebin agɨl ma apɨkop agak. God ne binɨb kubal okok tek ma mɨdeb agak. God ne binɨb koŋɨm mɨdebal ak tek mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisas anɨb agñek, binɨb kuŋay yelak okok nɨŋɨd gos palawl lak. ");
INSERT INTO taw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas takaw anɨb ak agtep gek, bɨ Sajusi okok takaw olap pen agɨnɨgel tek ma lak. Pen bɨ Pelisi okok kɨli anɨb ak nɨŋɨd, Jisas yek ak apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Apnan gɨl, bɨ kɨli God takaw nɨgtep yɨbɨl gak olap, ne Jisas tɨtay tek agɨnɨmuŋ agɨl, agnɨŋɨd agak, ");
INSERT INTO taw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisa, God takaw Mosis ñu kɨl tɨkak ak, takaw ned nɨm akal tap awl yɨbɨl agak? ");
INSERT INTO taw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Agek Jisas agak, God Bɨawl nad anop mapen yɨbɨl lɨnɨmɨn agak. Mapen nad ak, kawnan nad ak, gos tɨmud nad ak, mɨdupsek nop yɨl amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","God takaw ned nɨm awl yɨbɨl ak, takaw awl yɨbɨl nɨm anɨb ak agak. ");
INSERT INTO taw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pen takaw awl olap nɨm, anɨgɨl mɨdeb agak. Binɨb ogɨnap kɨlop, nad ke mapen lɨpan tek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Takaw kɨles omɨŋal apin anɨb ak nep, God takaw ned jɨj yɨbɨl nɨm omɨŋal ak agak. Takaw Mosis ñu kɨl tɨkak ak sek, bɨ God gos ñek agñeb okok ñu kɨl tɨkɨlak ak sek mɨdupsek, takaw apin anɨb ak nep takaw ned jɨj yɨbɨl nɨm ak agak. ");
INSERT INTO taw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bɨ Pelisi okok apnan gɨl yelaknɨŋ, Jisas kɨlop agnɨŋɨd agak, ");
INSERT INTO taw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Bɨ God nop aglup ak, nop tay gos nepɨm agak? Nop an ñɨne agɨl nepɨm agak? Agek agɨlak, Depid ñɨne agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Agel Jisas kɨlop agak, Nɨŋɨd apɨm ak pen, tɨtay dɨl God Kawnan ak ne Depid nop gos ñek, Depid ne bɨ anɨb ak Bɨawl yad agup agak? Depid ne tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","God ne Bɨawl yad anop agup, Nad ñɨn yɨpɨd kɨd yad okok besɨg yenɨmɨn agup agɨl tɨkak agak. Besɨg mɨdɨl, mɨd dad amɨl, binɨb nad ayɨp penpen gep okok kɨlop tob muk nak okok len, taw tɨbɨkɨnɨgaban agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depid ne ke agak, Bɨ anɨb ak Bɨawl yad agak. Anɨb ak, tɨtay dɨl Depid ñɨsed ak mɨdeb agak? ");
INSERT INTO taw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas takaw ne ak agtep gek, kɨli nop pen agɨnɨgel tek ma lak. Agɨnɨgel tek ma lek nɨm, mɨñɨl tɨkɨl mɨd dad amɨl, takaw ogɨnap nop ma agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kɨdek Jisas bɨne okok sek, binɨb kuŋay okok sek kɨlop takaw agɨl ");
INSERT INTO taw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","agak, Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek kɨli takaw Mosis ñu kɨl tɨkak ak dɨl, nɨbop agñɨbal agak. ");
INSERT INTO taw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pen takaw kuŋay apal ak, kɨli kɨdek ma gɨpal agak. Anɨb ak, takaw okok mɨdupsek nɨbop agñɨbal okok, nɨbi kɨdek gɨl gɨtep gɨnɨmɨb agak. Pen tap gɨpal okok, nɨbi kɨdek ma gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Takaw kɨles tɨmel apal ak wad mɨŋel awl okok tek, binɨb okok kɨlop gam ñɨbal ak pen, kɨlop mapen nɨŋɨd day ma dad abal agak. ");
INSERT INTO taw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tap okok mɨdupsek kɨli gɨpal ak, binɨb okok chɨnop nɨgɨlaŋ agɨl gɨpal agak. Kɨli binɨb okok chɨnop nɨgɨlaŋ agɨl, God takaw ak mɨj kɨl tɨkɨl tap mɨgan lɨl, ogɨnap ñɨn ajɨp kopen sek lɨl, ogɨnap kɨmɨg cheg alaŋ lɨl gɨpal agak. Pen kɨli chɨnop nɨgɨlaŋ agɨl, chech palawl nag day wul sek tep okok lɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tap awl ñɨbal nab ak amɨl mɨdebal akaŋ, Juda apnan gɨpal kal ak amɨl mɨdebal ak, bɨawl besɨgep okok adek ak nep besɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Binɨb kuŋay apnan gɨl mɨdebal nab anɨb okok amon, Tisa apeban ey agel, chɨnop tep gaŋ agɨl gos nepal agak. ");
INSERT INTO taw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pen nɨbi mam wagen nokom olap mɨdebɨm, Tisa nɨbi ak, nokom olap nep mɨdeb agak. Anɨb ak tek, nɨbop Tisa ma agɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pen Nap nɨbi nokom yɨbɨl ak mɨdeb, man ne alaŋ agak. Anɨb ak tek, lum awl ak bɨ ogɨnap kɨlop Bapi ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bɨawl nɨbi ak nɨm, Bɨ God nop aglup ak nep agak. Anɨb ak tek, nɨbop Bɨawl ma agɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bɨawl yɨbɨl nɨbi mɨdeb ak, bɨ wog gɨñeb nɨbi ak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Binɨb yɨb kɨli ke dad aplanɨgabal okok, yɨb kɨlop yownɨgab ak pen, binɨb yɨb ma dad aplanɨgabal okok, yɨb awl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jisas takaw olap agak, Bɨ nɨbi Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek nɨbi tɨtay dɨnɨgabɨm agak. Nɨbi bɨ yepɨs yɨbɨl gep agak. God binɨb dɨl kɨlop kod yenɨgab ak, kanɨb anɨb ak gɨñem, binɨb okok kɨli seŋayaŋ mɨdebal agak. Nɨbi ke mɨgan ma amɨl, kelɨgɨpɨm agak. Pen binɨb mɨgan amnɨg gɨpal okok kɨlop pel kanɨb day ak agtɨkɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nɨbi bɨ Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek tɨtay dɨnɨgabɨm agak. Nɨbi bɨ yepɨs yɨbɨl gep agak. Nɨbi binɨb okok kɨlop takaw agñon chɨnop ak nɨŋɨd kɨdek gɨlaŋ agɨl, ñɨg solwala okok sek man okok sek mɨdupsek pɨyow ajɨpɨm agak. Ajɨl, olap nɨŋɨd nop agñem nɨbop nɨŋɨd dup agak. Nɨbop nɨŋɨd dup ak, nɨbi mab ke yɨneb ak amnɨgabɨm tek ne abe amnɨgab agak. Pen nɨbi tek mel, bɨ tɨmel awl yɨbɨl yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nɨbi binɨb okok kɨlop kanɨb adek ak yom tep gɨnɨgun apɨm ak pen, bɨ wɨdɨn koy mɨdebɨm agak. Nɨbi tɨtay dɨnɨgabɨm agak. Binɨb okok kɨlop takaw agñɨbɨm agak. Pen anɨb apɨm, Bɨ olap ñɨn dad aplanɨl God agnɨgep kal awl ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab ak, takaw anɨb ak takaw yokɨp, kɨdek agup tek ma gɨnɨmuŋ tek lup apɨm agak. Pen bɨ olap ñɨn dad aplanɨl, tap gol okok God agnɨgep kal awl mɨgan mɨdeb ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab ak, kɨdek agup tek nep gɨnɨmuŋ apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nɨbi bɨ sawl sek, wɨdɨn koy yɨbɨl mɨdebɨm agak. Tap anɨb ak tay, tap awl yɨbɨl mɨdeb agak? Tap gol tap awl yɨbɨl akaŋ, God agnɨgep kal awl ak tap awl yɨbɨl agak? Nɨbi nepɨm, God agnɨgep kal awl ak tap awl yɨbɨl mɨdeb agak. Tap gol pen mɨdeb ak, God agnɨgep kal awl mɨgan anɨb ak tek, tap gol anɨb ak abe God tap teplep ne agak. ");
INSERT INTO taw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Takaw olap abe kɨlop agñɨbɨm agak. Anɨb apɨm, Bɨ olap ñɨn dad aplanɨl God nop sɨbogep abañ adek ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab ak, takaw anɨb ak takaw yokɨp, kɨdek agup tek ma gɨnɨmuŋ tek lup apɨm agak. Pen bɨ olap ñɨn dad aplanɨl, tap God nop dagɨlep ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab, kɨdek agup tek nep gɨnɨmuŋ apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nɨbi bɨ wɨdɨn koy yɨbɨl mɨdebɨm agak. Tap anɨb ak tay, tap awl yɨbɨl mɨdeb agak? Tap God nop dagɨlɨnɨgab ak akaŋ, God nop sɨbogep abañ adek ak tap awl yɨbɨl agak? Nɨbi nepɨm, God nop sɨbogep abañ adek ak tap awl yɨbɨl mɨdeb agak. Tap God nop pen dagɨlɨnɨgab ak, God nop sɨbogep abañ adek ak mɨdeb anɨb ak tek, tap dagɨlep anɨb ak abe God tap teplep ne agak. ");
INSERT INTO taw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anɨb ak, bɨ olap ne ñɨn dad aplanɨl God nop sɨbogep abañ adek ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab ak, God nop sɨbogep abañ adek ak sek tap God nop dagɨlup ak sek omɨŋal gɨl gos nɨŋɨd agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pen bɨ olap ne ñɨn dad aplanɨl God agnɨgep kal awl ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab ak, God agnɨgep kal awl ak sek Bɨawl God ne kal anɨb ak mɨgan mɨdeb ak nop sek omɨŋal gɨl gos nɨŋɨd agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pen bɨ olap ne ñɨn dad aplanɨl God man ne alaŋ ak yomɨl agɨnɨgab, Yepɨs ma apin, nɨŋɨd yɨbɨl agebin agɨnɨgab ak, God bɨnonɨm besɨgep ne ak sek, Bapi God nop sek omɨŋal gɨl gos nɨŋɨd agɨnɨgab agak. Takaw kɨles anɨb ak tek agɨl, kɨdek kelɨgep tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nɨbi bɨ Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek tɨtay dɨnɨgabɨm agak. Nɨbi bɨ yepɨs yɨbɨl gep agak. Sɨbɨn tap monmon okok nɨgem, tap awl tek lek, ñɨn pag nɨŋɨd dad amɨl wajɨlem ak amub agak. Amek, God nop nokom olap ñun agɨl pel ñɨbɨm agak. Ak tep gɨpɨm, takaw ma mɨdeb agak. Tap sɨkol okok pel anɨgɨl gɨpɨm ak pen, taynen God takaw ne awl yɨbɨl ak abe ma gɨpɨm agak? Takaw awl olap anɨb agup, God ne binɨb okok kɨlop nɨŋɨd pel takaw tɨg asɨk tep gup agup ak pen, nɨbi takaw tɨg asɨk tep mel agak. Pen takaw awl olap anɨb agup, Binɨb okok kɨlop mapen nɨgup agup ak pen, nɨbi kelɨgɨpɨm agak. Pen takaw awl olap abe agup, God nop nokom gos lɨnɨgep pal ak agup ak pen, nɨbi kelɨgɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nɨbi binɨb okok kɨlop kanɨb adek ak yom tep gɨnɨgun apɨm ak pen, bɨ wɨdɨn koy mɨdebɨm agak. Bɨ ogɨnap mumɨkɨl tap sɨkol ak ñɨg mɨgan ayaŋ mɨdeb ak nɨŋɨd dɨyokɨpal tek, nɨbi mɨdebɨm agak. Kɨli pen chag kamel tap awl ak ñɨg mɨgan ayaŋ mɨdeb ma nɨŋɨd, chag kamel sek ñɨg sek mɨdupsek ñɨbjupal agak. Nɨbi anɨb ak tek nep gɨpɨm agak. Tap sɨkol okok pel gos nepɨm ak pen, God tap ne awl okok gos ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nɨbi bɨ Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek tɨtay dɨnɨgabɨm agak. Nɨbi bɨ yepɨs yɨbɨl gep agak. Kɨnag nɨbi okok tek seŋ okok ken ñɨg lɨ yok tep gɨpɨm ak pen, tap mɨdup nɨbi dɨl kɨnag mɨgan dɨpɨm okok, tap si dɨl gos nɨbi ke ak nɨŋɨd dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nɨbi Pelisi bɨ wɨdɨn koy mɨdebɨm agak. Kɨnag nɨbi okok mɨgan ayaŋ ned ñɨg lɨ yok tep gɨnɨmɨb agak. Anɨgem, seŋ okok ken abe mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nɨbi bɨ Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek tɨtay dɨnɨgabɨm agak. Nɨbi bɨ yepɨs yɨbɨl gep agak. Binɨb okok kɨli chɨp kaw mɨgan okok kamɨl kanɨb gɨñɨl, chɨp kaw mɨgan anɨb okok adek ak lum ñɨl sɨŋak wikel, kawtub adek ak teplep yɨbɨl mɨdeb agak. Pen nɨbi chɨp kaw mɨgan anɨb ak tek mɨdebɨm agak. Binɨb kɨli chɨp kaw seŋ anɨb okok nɨŋɨd, tap teplep mɨdeb agɨl gos nepal ak pen, mɨgan ayaŋ chɨp tɨŋɨl sek tap gach sek kuy tɨmel apɨlɨg mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nɨbi abe anɨb ak tek nep mɨdebɨm agak. Binɨb okok kɨli nɨbop mubwak nɨŋɨd apal, Nɨbi bɨ suŋtep mɨdebɨm apal agak. Pen nab nɨbi pi okok, takaw yepɨs apɨm ak sek, God takaw tɨbɨlɨkɨpɨm ak sek, nab nɨbi pi okok kuŋay yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nɨbi bɨ Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek nɨbi tɨtay dɨnɨgabɨm agak. Nɨbi bɨ yepɨs yɨbɨl gep agak. Bɨ God gos ñek agñeb kawtub adek kɨli okok, nɨbi gɨtep gɨpɨm agak. Bɨ suŋtep kawtub adek kɨli okok, nɨbi tap teplep lɨl gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nɨbi anɨgɨl, pen anɨb apɨm, Based sɨkop bɨlel yelɨgɨpal ñɨn ak, kɨli bɨ God gos ñek agñeb okok kɨlop ñagɨlak apɨm agak. Chɨn pen ñɨn anɨb ak tek yolɨgɨpun, bɨ God gos ñek agñeb anɨb okok kɨlop ma ñapɨnop apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pen apɨm anɨb ak, bɨ God gos ñek agñeb okok kɨlop ñagelɨgɨpal kɨd ak mɨdobun agɨl apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ak pen, nased sɨkop nɨbi bɨlel gɨ tɨmel gelɨgɨpal ak, nɨbi tap tɨmel anɨb okok gɨ dad ameb nonɨm ken amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nɨbi yoy okok, yoy sɨlaw jɨj okok mɨdebɨm agak. God nɨbop kot gɨl, mab ke yɨneb dɨyokɨnɨgab ak nɨm, tɨtay dɨl pɨlɨk ke okok amnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Anɨb ak tek ak nɨgɨm agak. Yad bɨ God gos ñek agñeb okok sek, bɨ nɨgtep gɨpal okok sek, bɨ God takaw nɨŋɨd agñeb okok sek, kɨlop agyoken nɨbop yɨl ownɨgabal agak. Apel, ogɨnap paklɨnɨgabɨm, ogɨnap mab bak alaŋ chɨpɨl pak tɨbɨk lɨnɨgabɨm, ogɨnap Juda apnan gɨpal kal mɨgan nɨbi ak nag dɨl pakɨnɨgabɨm agak. Pen nɨbi kɨlop ogɨnap gem pɨlɨk amnɨlaknɨŋ, taun okok okok yuk yokɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kɨlop anɨgɨnɨgabɨm ak nɨm, nɨbi mɨŋel dɨnɨgabɨm agak. Bɨlel ñɨn ak tɨkɨl, bɨ suŋtep okok kɨlop pel paklel mɨd dad apɨl, mɨñɨl nɨbi anɨb ak tek gebɨm anɨb ak, God gek mɨŋel anɨb okok mɨdupsek dɨnɨgabɨm agak. Mɨŋel anɨb ak nɨm, bɨ suŋtep Ebel nop ned jɨj gɨl paklɨl, ñag dad apɨl, ñag dad apɨl, kɨdek Belekiya ñɨne Sekalaya nop paklɨlak agak. God agnɨgep kal awl ak adaŋ, God nop sɨbogep abañ adek tep ak adaŋ, nop nab sɨŋak paklɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yad nɨbop nɨŋɨd agebin, nɨbi gɨ tɨmel gebɨm anɨb ak nɨŋɨd, God gek nɨbi binɨb mɨñɨl mɨdebɨm okok tap mɨŋel anɨb okok mɨdupsek dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas takaw olap agak, Jelusalem binɨb agak. Bɨ God gos ñek agñeb okok sek, God ne bɨ nɨbop yɨl agyokek opal okok sek, taynen pel kab dɨl kɨlop paklɨpɨm agak? Pen yad pel binɨb nɨbop okok yawl kakaluk ñɨluk tek pɨl muk okok lɨnɨm agen, yɨp yɨlɨk nɨŋɨd ma dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Anɨb ak nɨgɨm agak. Kal nɨbi ak yokɨp yɨbɨl yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yad nɨbop agebin, yɨp kasek ma nɨgɨnɨgabɨm agak. Kɨdek agɨnɨgabɨm, Bɨ Bɨawl ne agyokek owup ak, Bɨawl ne bɨ anɨb ak nop gɨtep gɨnɨmuŋ agɨnɨgabɨm agak. Ñɨn anɨb ak nep yɨp nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ne God agnɨgep kal awl kab wali kus gɨl yek ak kelɨgɨl seŋ amnaknɨŋ, bɨne okok nop apɨl agɨlak, God agnɨgep kal awl kab wali kus gɨl yek ak, kal anɨb okok wali mɨgan ayaŋ mɨdeb ak nɨgan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Agelak kɨlop pen agak, Nɨbi kal anɨb okok mɨdupsek nepɨm akaŋ agak? Yad nɨbop nɨŋɨd agebin, Kɨdek bɨ ogɨnap apɨl, kal anɨb okok gɨ tɨmel gel, kab olap kab olap adek ak ma yenɨgab, pɨsnep pɨpag pakɨl dɨyokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas anɨb agɨl, amɨl dum Olip besɨgɨl mɨdaknɨŋ, bɨne okok kɨli nep apjakɨl nop agnɨŋɨd agɨlak, Chɨnop agñan, tap agesɨpan ak, ñɨn akal tek gɨnɨgab agɨlak? Pen tap tay gek chɨn nɨŋɨd anɨb agɨnɨgabun, Ñɨn kɨdek ak apɨl, nad wulep ownɨgeban agɨnɨgabun agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Agelak Jisas kɨlop agak, Nɨgtep gɨnɨmɨb agak. Bɨ kuŋay yɨbɨl yepɨs agɨl, yɨb yɨp ak dɨlɨg agɨnɨgabal, Yad nep Bɨ God nop aglup ak apebin agɨnɨgabal agak. Anɨb agel, binɨb kuŋay yɨbɨl takaw yepɨs anɨb ak nɨgɨnɨgabal ak pen, nɨbi ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Man okok penpen gɨnɨgabal agak. Pen binɨb agɨnɨgabal, Man okok penpen gebal agɨnɨgabal agak. Anɨgɨnɨgab ak pen, gos nɨgtep gɨl gos kuŋay ma nɨgɨnɨmɨb agak. Tap anɨb okok gonɨmuŋ tek lup ak pen, ñɨn kɨdek ak ownɨgeb agɨl gos ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Man ogɨnap tɨkjakɨl, man ogɨnap ayɨp penpen ñagɨnɨgabal agak. Binɨb wakay ogɨnap tɨkjakɨl, binɨb wakay ogɨnap ayɨp penpen ñagɨnɨgabal agak. Pen man keke okok yuwan awl gɨl, monmon awl dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tap gɨnɨgab mɨdupsek anɨb okok, bin ñapay ñɨbosup, wulep mɨdeb agɨl nepal tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pen yɨp yɨl mɨdebɨm tek nɨbop mɨmug gɨl, gɨ tɨmel gɨl pɨsnep paklɨnɨgabal agak. Binɨb man okok mɨdupsek nɨbop mɨlɨk nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ñɨn anɨb ak, binɨb kuŋay God nop gos ak kelɨgɨl, kɨli ke okok mɨlɨk nɨŋɨd, mɨmug gɨl bɨ ñagep okok ñɨn adek ak lɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pen bɨ kuŋay God takaw agobun agɨl yepɨs apal okok, binɨb okok kɨlop yepɨs gel kuŋay nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kɨli gɨ tɨmel gep adek ak nep gel amnɨgab agak. Anɨb ak, binɨb kuŋay kɨli binɨb okok kɨlop mapen lep ak sawl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pen binɨb an kɨles gɨl yɨp yɨl yenɨgab ak, mɨd dad amɨl ñɨn kɨdek ownɨgab ak, God nop tɨg asɨk dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pen God binɨb dɨl kɨlop kod yenɨgab takaw teplep ak, lum awl ak mɨdupsek agñɨnɨgabal agak. Agñel, binɨb man okok mɨdupsek nɨgɨnɨgabal ak nɨm, ñɨn kɨdek ak ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas takaw olap agak, Tap tɨmel asɨkep yɨbɨl olap, bɨ God gos ñek agñeb Danyel ne bɨlel tap anɨb ak nop takaw ogɨnap tɨkɨl agak. Pen tap anɨb ak, God agnɨgep kal awl mɨgan ak lel yenɨgab ak nɨgɨnɨgabɨm agak. Takaw tɨkebin anɨb awl, nɨgtep gɨnɨmɨb. ");
INSERT INTO taw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pen agak, Tap tɨmel asɨkep yɨbɨl nɨgenɨgabɨm ñɨn anɨb ak, binɨb Judiya plopens yenɨgel okok, pɨlɨk dum oklaŋ okok amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Binɨb kal adek alaŋ yenɨgel okok, tap dɨnɨg adɨkɨd kal mɨgan ma amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Binɨb wog day okok ajenɨgel okok, chech tap okok dɨnɨg adɨkɨd kal ma amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ñɨn anɨb ak, bin ñapay kogmeg yenɨgabal okok sek, ñapay tul ñɨnɨgabal okok sek, koslam pɨlɨk amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Tap gɨnɨgab anɨb okok, tap tɨmel awl yɨbɨl gɨnɨgab agak. God alwol gɨlak ñɨn ak tɨkɨl, mɨd dad apɨl mɨdobun ñɨn awl, tɨmel awl yɨbɨl anɨb ak tek ma gak, kɨdek abe anɨb ak tek ma gɨnɨgab agak. Anɨb ak tek, God nop agnɨgem, yobup lɨnɨmuŋ ñɨn ak sek, Juda añɨŋ lep ñɨn awl ak sek ma gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tap tɨmel awl yɨbɨl anɨb okok gɨ nep yobɨkop, binɨb mɨdupsek kum dɨpɨlap agak. God pen binɨb ne dɨnɨg aglak okok kɨlop gos nɨŋɨd, tap tɨmel anɨb okok yep won olap nep gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pen ñɨn anɨb ak, binɨb ogɨnap nɨbop agɨnɨgabal, Nɨgɨm, Bɨ God nop aglup ak mɨdeb awl akaŋ, Ne mɨdeb adaŋ agenɨgel, nɨŋɨd apal agɨl ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bɨ ogɨnap apjakɨl agɨnɨgabal, Yad nɨm Bɨ God nop aglup ak akaŋ, Yad nɨm bɨ God gos ñek agñeb olap agɨl, yepɨs yepɨs agɨlɨg, tap mageptek awl yɨbɨl ogɨnap gɨnɨgabal agak. Bɨ anɨb okok, kɨli binɨb okok kɨlop yepɨs agon takaw chɨnop nɨgɨnɨgabal agɨl gos nepal agak. Pen kɨli God binɨb ne aglak okok kɨlop abe yepɨs agun agɨl, tap anɨb okok anɨgɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nɨgɨm, tap tɨtay kɨdek gɨnɨgab ak, nɨbop agen nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Anɨb ak binɨb ogɨnap agɨnɨgel, Nɨgɨm, ne man nep binɨb ma yelak nab okok mɨdeb agenɨgel, nɨgɨnɨg ma amnɨmɨb agak. Pen agɨnɨgel, Nɨgɨm, ne kal mɨgan ayaŋ mɨdeb agenɨgel, nɨŋɨd apal agɨl ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nɨgɨm. Añɨñak bol ak dup tek, sub apjakup ayɨm nɨb ak saŋɨd amub oŋɨd gaknɨŋ binɨb okok kɨli nepal agak. Anɨb ak tek ak, Bɨ Olap Ñɨne ownɨgab ñɨn ak, ne anɨgɨl owaknɨŋ, binɨb okok mɨdupsek nop nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tap ogɨnap wog bɨg yɨnɨg lɨnɨgab ak, man anɨb ak yawl apnan gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas takaw olap agak, Pen mɨŋel awl anɨb okok gɨ tek dak, won anɨb ak sub ak gach gɨl, takan ak mɨlek ma gɨnɨgab agak. Gap okok wɨsɨp alaŋ nɨb pugju apyapɨl, tap adekab alaŋ okok, okok nɨb okok nɨb gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Anɨgenɨgab, Bɨ Olap Ñɨne ownɨg gaknɨŋ, adekab alaŋ ke lek, binɨb man okok keke mɨdebal tek, nɨŋɨd chaŋ lɨnɨgabal agak. Bɨ Olap Ñɨne, kɨles awl sek mɨlek awl sek dɨl, wɨsɨp bad sek owaknɨŋ, binɨb okok mɨdupsek nop nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pen akɨl awl agaknɨŋ, ensel ne okok agyokenɨgab, man ak mɨdupsek am kus gɨl, adekab sek lum awl sek puŋɨlek amnak ak, binɨb God kɨlop aglak okok mɨdupsek dɨ yɨpɨlɨg dap nan gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas takaw olap agak, Mab sɨlup lup ak nɨŋɨd gos nɨgɨnɨmɨb agak. Mab okok sɨlup lɨl wos gaknɨŋ, mɨñɨl sub lɨnɨgeb agɨl nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Anɨb ak tek, tap anɨb okok agebin ak gaknɨŋ nɨgɨnɨgabɨm, Bɨ Olap Ñɨne ownɨg gɨnɨgab ñɨn ak wulep mɨdeb, kanɨbtub wulep sɨŋak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yad nɨbop nɨŋɨd agebin agak. Binɨb jɨj mɨñɨl mɨdebal adek awl ogɨnap yelaknɨŋ, tap anɨb okok mɨdupsek gek nɨŋɨd kɨdek kumnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adekab sek, lum awl sek kul gɨnɨgab ak pen, takaw yad ak ma kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pen Jisas takaw olap agak, Ñɨn akal akaŋ, won akal tap anɨb okok gɨnɨgab ak, binɨb okok ma nepal, ensel God man ne alaŋ mɨdebal okok ma nepal, Ñɨ abe ma nɨgup agak. Nap ne nokom nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bɨ Olap Ñɨne ownɨgab ñɨn anɨb ak, binɨb bɨlel Nowa yek ñɨn ak gak tek gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa yek ñɨn anɨb ak, ñɨg ak binɨb okok kɨlop ma yu gak won ak, binɨb okok tap ñɨbɨlɨg, ñɨg ñɨbɨlɨg, bin penpen ñɨlɨg gɨ yelaknɨŋ, Nowa sip mɨgan ayaŋ amnak ñɨn ak agak. ");
INSERT INTO taw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pen kɨli tap olap gɨnɨgab agɨl gos ma nɨgɨlak agak. Anɨgɨl gos ma nɨgel, man awl yɨbɨl ak pakɨl, ñɨg wɨlɨk apɨl, binɨb anɨb okok kɨlop mɨdupsek dad amnak agak. Bɨ Olap Ñɨne ownɨgab ñɨn ak, anɨb ak tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ñɨn anɨb ak, bɨ omɨŋal wog day yenɨgayl ak, God bɨ olap nop dɨl olap nop kelɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pen bin omɨŋal bilet jɨmñɨl gɨ yenɨgayl ak, olap nop dɨl olap nop kelɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Anɨb ak, Bɨawl nɨbi ownɨgab ñɨn ak ma nepɨm tek, nɨgtep gɨl yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pen anɨb ak gos nɨgɨnɨmɨb agak. Bɨ kal nap nɨb ak, ne bɨ tap si dep ak won akal apeb agɨl nɨŋɨd nɨm, wɨsɨn ma kɨnɨl nɨg yek, bɨ tap si dep ak kal bog tɨkɨl kal mɨgan ma ownɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Anɨb ak tek nɨbi abe nɨgtep gɨl yenɨmɨb agak. Mel ak, Bɨ Olap Ñɨne ma apeb agɨl, sawl gɨl yenɨgabɨm ñɨn ak ne ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas takaw olap agak, Bɨ wog gɨñeb ak an gos tep yek, wog gɨtep yɨbɨl gɨnɨgab ak, bɨawl ne ak amnɨg gɨl nop agɨnɨgab, Binɨb wog gɨñeb yad okok kɨlop kod yenɨmɨn agɨnɨgab agak. Tap ñɨŋeb kɨlop okok bɨlok ñɨlɨg gɨ yenɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kɨdek bɨawl ne adɨkɨd apɨl nɨgɨnɨgab, bɨ wog gɨñeb anɨb ak agɨnɨgab tek gek, nop dɨtep yɨbɨl gek mɨñmɨñ gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yad nɨbop nɨŋɨd agebin, bɨawl ne nop agek tap anɨb okok mɨdupsek kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pen bɨ wog gɨñeb anɨb ak, ne bɨ tɨmel mɨdeb tek, gos ne ke nɨŋɨd agɨnɨgab, Bɨawl yad ak kasek ma ownɨgab agɨl, ");
INSERT INTO taw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","binɨb wog gɨñeb okok ayɨp wog gɨpal okok, kɨlop tapɨn pakɨnɨgab agak. Pakɨl, tap ñɨbɨl, ñɨg kɨles ñɨbɨl, bɨ ogɨnap ñɨg kɨles ñɨbɨl sawl lek mɨdebal okok ayɨp yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pen bɨawl ne ak kasek ma ownɨgab agɨl gos nɨgɨnɨgab ñɨn ak apɨl, ");
INSERT INTO taw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nop tɨmel yɨbɨl gɨl, binɨb God nop gos nopun agɨl yepɨs yɨbɨl gɨpal okok, kɨli mɨdebal nab okok nop aglɨnɨgab agak. Pen binɨb mɨdebal anɨb okok ayɨp meg sulɨlɨg, chaŋ lɨlɨg yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas takaw olap agak, God binɨb dɨl kɨlop kod yenɨgab ñɨn anɨb ak, kesɨm debin awl tek gɨnɨgab agak. Bɨ olap bin dɨnɨg gek, bin pɨlaj anep wajɨlem ak lam keke dɨl, dad kanɨb nab ak nɨgun agɨl amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bin pɨlaj anɨb okok, anep mamɨd ak gos nɨgtep ma gɨnɨgabal, anep mamɨd ak gos nɨgtep gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɨgtep ma gɨnɨgabal anɨb okok, lam dagɨlep wel ogɨnap sek dad ma amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pen bin pɨlaj gos nɨgtep gɨnɨgabal okok, lam dɨl, lam dagɨlep wel ogɨnap botol mɨgan ak pagɨl, dad amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pen bin pɨlaj anɨb okok kɨli mɨdupsek amjakɨl, kod mɨdel mɨdel, bɨ bin dɨnɨg gɨnɨgab ak kasek ma apek nɨm, wɨsɨn apek kɨn amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pen maynab awl ayaŋ, binɨb ogɨnap suk agɨl agɨnɨgabal, Nɨgɨm, bɨ bin dɨnɨgeb ak apeb agɨnɨgabal agak. Nop am kanɨb nab ak nɨŋɨd, poŋɨd owɨm agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Anɨb agel, bin tun anep wajɨlem anɨb ak mɨdupsek tɨkjakɨl, lam wik kɨli okok gɨtep gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anɨgɨl, bin gos nɨgtep ma gɨnɨgabal tun ak, kɨli bin gos nɨgtep gɨnɨgabal tun ak kɨlop agɨnɨgabal, Lam chɨn okok sugɨnɨgeb ak, wel nɨbi okok chɨnop ogɨnap ñɨm agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Agel, bin gos nɨgtep gɨnɨgabal tun ak agɨnɨgabal, Mel, wel anɨb okok nɨbop ogɨnap ñɨl, chɨn ogɨnap dɨnɨgun tek ma lup agɨnɨgabal agak. Nɨbi ke amɨl tawɨm agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Anɨb agenɨgabal, wel tawnɨg amnɨgabal won ak, bɨ bin dɨnɨg gɨnɨgab ak apjakɨnɨgab agak. Bin gos nɨgtep gɨl kod yenɨgabal tun ak, bɨ anɨb ak ayɨp kal mɨgan amel, bɨ ogɨnap kanɨb gɨñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kɨdek pen bin pɨlaj gos nɨgtep ma gɨnɨgabal tun ak apjakɨl agɨnɨgabal, Bɨawl, bɨawl, chɨnop kanɨb ak yɨkan agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Agel, bɨ anɨb ak ne pen agɨnɨgab, Yad nɨbop nɨŋɨd agebin, nɨbop ma nepin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pen Jisas agak, Bɨ Olap Ñɨne ñɨn akal akaŋ, won akal ownɨgab ak nɨbi ma nepɨm agak. Anɨb ak nɨgtep gɨl kod yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas takaw olap agak, God binɨb dɨl kɨlop kod yenɨgab ñɨn anɨb ak, kesɨm debin awl tek gɨnɨgab agak. Bɨawl olap man palawl okok amnɨg, bɨ wog gɨñeb ne okok kɨlop suk agek apel, tap yad okok kod yelaŋ agɨl, kɨlop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Bɨ wog gɨñeb ne anɨb okok, wog keke tɨtay gɨnɨgabal tek nɨŋɨd, mani bɨlokɨnɨgab agak. Bɨ olap nop 5,000 kina ñɨnɨgab, olap nop 2,000 kina ñɨnɨgab, olap nop 1,000 kina ñɨnɨgab agak. Ñɨl, ne man palawl okok amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Amek, bɨ 5,000 kina dɨnɨgab ak mani anɨb ak dɨl, wog gɨl, gɨ dad amɨl apɨl gɨl, pen yɨl mani sinɨŋ ogɨnap sek 5,000 kina dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bɨ 2,000 kina dɨnɨgab ak abe, anɨb ak tek mani sinɨŋ ogɨnap sek 2,000 kina dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pen bɨ 1,000 kina dɨnɨgab ak, mani anɨb ak dad amɨl, kaw dɨl, bɨawl mani ne anɨb ak dɨ we gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pen kɨdek mɨd dad amɨl, bɨ wog gɨñeb okok bɨawl kɨli ak adɨkɨd apɨl, mani ñɨbin anɨb ak tɨtay gɨpal agɨl, kɨlop agnɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Agnɨgek, bɨ 5,000 kina dɨnɨgab ak, 5,000 kina ogɨnap sek ayɨp dad apɨl agɨnɨgab, Bɨawl, yɨp 5,000 kina ñɨnak ak pen, yad mani anɨb ak dɨl, wog gɨl, gɨ dad amɨl apɨl gɨl, pen yɨl mani sinɨŋ ogɨnap sek 5,000 kina dɨpin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Agek, bɨawl ne ak nop agɨnɨgab, Nad bɨ wog gɨñeb tep ak mɨdeban, yad agɨnek tek nɨŋɨd, wog gɨtep yɨbɨl gɨpan agɨnɨgab agak. Tap sɨkol okok kod mɨdtep gɨpan ak, nep agen tap awl okok kod yenɨgaban agɨnɨgab agak. Nad apɨl, yad ayɨp mɨñmɨñ yɨbɨl gɨlɨg yonɨgul agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pen bɨ 2,000 kina dɨnɨgab ak, ne abe apɨl agɨnɨgab, Bɨawl, yɨp 2,000 kina ñɨnak ak pen, yad mani anɨb ak dɨl, wog gɨl, gɨ dad amɨl apɨl gɨl, pen yɨl mani sinɨŋ ogɨnap sek 2,000 kina dɨpin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Agek, bɨawl ne ak nop agɨnɨgab, Nad bɨ wog gɨñeb tep ak mɨdeban, yad agɨnek tek nɨŋɨd, wog gɨtep yɨbɨl gɨpan agɨnɨgab agak. Tap sɨkol okok kod mɨdtep gɨpan ak, nep agen tap awl okok kod yenɨgaban agak. Nad apɨl, yad ayɨp mɨñmɨñ yɨbɨl gɨlɨg yonɨgul agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pen bɨ 1,000 kina dɨnɨgab ak, ne abe apɨl agɨnɨgab, Bɨawl, yad nep nepin agɨnɨgab agak. Nad bɨ kabɨyam tɨmel yɨbɨl agɨnɨgab agak. Binɨb tap wog yɨbal okok, nad kɨles gɨl nep taw pɨlɨg ñɨban agɨnɨgab agak. Binɨb wog day kɨli okok tap yɨŋ yokɨnɨgabal, tap anɨb ak jakek nad ke dɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nad anɨgɨpan tek, yad pɨlɨkɨl, 1,000 kina yɨp ñɨnak ak dad amɨl, kaw dɨl mani nad anɨb ak dɨ we gɨpin agak. Nɨgan agɨnɨgab agak. Tap nak mɨñɨl dad apebin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Agek, bɨawl ne ak nop pen agɨnɨgab, Nad bɨ wog gɨñeb tɨmel ak mɨdeban, bɨ yɨlɨk gep olap agɨnɨgab agak. Yad binɨb tap wog yɨbal okok, kɨles gɨl nep taw pɨlɨg ñɨbin agɨnɨgab agak. Binɨb wog day kɨli okok tap yɨŋ yokɨnɨgabal, tap anɨb ak jakek yad ke dɨpin agak. Anɨb okok nad nepan agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Anɨb ak, mani yad ak dɨl, dam le, wog gek adɨkɨd dape yokɨp ogɨnap sek dɨpɨnep agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Anɨb ak, 1,000 kina ak pɨlɨg dɨl, bɨ 10,000 kina mɨdeb ak nop ñɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nɨgɨm. Binɨb tap kɨli mɨdeb okok, yad kɨlop ogɨnap sek ñen, kɨli tap kuŋay yɨbɨl yenɨgab agɨnɨgab agak. Pen binɨb tap kɨli ma mɨdeb okok, tap sɨkol olap dɨ yenɨgabal ak, tap anɨb ak pɨlɨg dɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pen bɨ wog gɨñeb anɨb awl, wog gɨtep ma yɨbɨl gup ak, nop seŋayaŋ dɨyokɨnɨmɨb, kɨsɨlɨm awl owup mɨgan ayaŋ agɨnɨgab agak. Mɨgan anɨb ak, binɨb okok meg mɨdup sulɨlɨg, chaŋ lɨlɨg yenɨgabal agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas takaw olap agak, Bɨ Olap Ñɨne, ne bɨnonɨm awl tek mɨdɨl ownɨgab ñɨn ak, ensel okok ayɨp mɨdupsek apɨl, ne bɨnonɨm besɨgep ne adek ak besɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Besɨgek, binɨb man okok keke mɨdebal tek, wɨdɨn mɨdup nop sɨŋak apnan gel, kɨlop bɨlok pɨs ak ke, pɨs ak ke lɨnɨgab agak. Bɨ chag sipsip chag meme mukep okok, chag sipsip okok wakay olap tɨg asɨk lɨl, chag meme okok wakay olap ke tɨg asɨk lɨl gɨpal agak. Kɨli gɨpal tek ne abe gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Binɨb chag sipsip tek mɨdebal okok nɨŋɨd, ñɨn yɨpɨd kɨd ak lɨnɨgab, binɨb meme tek mɨdebal okok nɨŋɨd, ñɨn aŋɨd kɨd ak lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bɨnonɨm ak nɨm, binɨb ñɨn yɨpɨd kɨd okok kɨlop agɨnɨgab, Bapi nɨbop gɨtep gup agɨnɨgab agak. Bɨlel ne man alwol gɨlak ñɨn ak, tep nɨbop gɨlak ak nɨm, apɨl teplep anɨb ak dɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Taynen? Yɨp yuwan gek, tap mɨdup ñɨbɨm agɨnɨgab agak. Ñɨg nen gek, ñɨg ñɨbɨm agɨnɨgab agak. Man pal okok nɨb apen, yɨp agdɨl dam kal nɨbi ak lɨpɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Chech ma yek, yɨp chech ak ñɨbɨm agɨnɨgab agak. Yɨp tap gek, dɨtep gɨpɨm agɨnɨgab agak. Yɨp nag lel mɨden, yɨp apɨl nepɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Anɨb agenɨgab, binɨb suŋtep okok nop pen agɨnɨgabal, Bɨawl, ñɨn akal nep yuwan gek tap mɨdup ñɨbun agɨnɨgabal agak? Ñɨn akal ñɨg nen gek, nep ñɨg ñɨbun agɨnɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ñɨn akal pal okok nɨb ape, nep agdɨl dam kal chɨn ak lɨpun agɨnɨgabal agak? Ñɨn akal chech ak ma yek, nep chech ñɨbun agɨnɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ñɨn akal tap gek akaŋ, nep nag lel mɨde, nep amɨl nopun agɨnɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Agel, bɨnonɨm ak kɨlop pen agɨnɨgab, Yad nɨbop nɨŋɨd agebin, mam yad yokɨp okok kɨlop dɨtep gɨpɨm ak nɨm, yɨp dɨtep gɨpɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kɨlop anɨb agɨl, binɨb ñɨn aŋɨd kɨd okok kɨlop agɨnɨgab, God ne Satan nop sek, Satan ensel ne okok sek kɨlop yul gaknɨŋ yelaŋ agɨl, tep mab ke yɨneb olap gɨlak agɨnɨgab agak. Nɨbi pen, binɨb tɨmel yul awl dɨnɨgabɨm okok, yɨp kelɨgɨl, mab ke yɨneb anɨb ak amnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Taynen? Yɨp yuwan gek, tap mɨdup ma ñɨbɨm agɨnɨgab agak. Ñɨg nen gek, ñɨg ma ñɨbɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pal okok nɨb apen, yɨp ma agdɨpɨm agɨnɨgab agak. Chech ma yek, yɨp ma ñɨbɨm agɨnɨgab agak. Yɨp tap gak ñɨn ak akaŋ, nag lel mɨdenek ñɨn ak, yɨp ma apɨl nɨŋɨd dɨtep gɨpɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Agek, kɨli abe nop pen agɨnɨgabal, Bɨawl, ñɨn akal nep yuwan gek tap mɨdup ma ñɨbun agɨnɨgabal agak? Ñɨn akal ñɨg nen gek nep ñɨg ma ñɨbun agɨnɨgabal agak? Ñɨn akal pal okok nɨb ape, nep ma agdɨpun agɨnɨgabal agak? Ñɨn akal chech ma yek, nep ma ñɨbun agɨnɨgabal agak? Ñɨn akal tap gek akaŋ, nep nag lel mɨdenak, nep ma amɨl nɨŋɨd dɨtep gɨpun agɨnɨgabal agak? ");
INSERT INTO taw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Anɨb agel, bɨnonɨm ak kɨlop pen agɨnɨgab, Yad nɨbop nɨŋɨd agebin, mam yad yokɨp okok kɨlop dɨtep ma gɨpɨm ak nɨm, yɨp abe dɨtep ma gɨpɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Anɨb agɨl kɨlop agyokek, pel pelnep yul gaknɨŋ yenɨgabal tep ak amnɨgabal agak. Binɨb suŋtep ne okok pen kɨlop agek, pel pelnep yenɨgabal tep ak amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas takaw anɨb ak agjuwɨl, bɨne okok kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nɨbi nepɨm, ñɨn omɨŋal mɨdɨl, Pasopa ñɨn awl ak mɨñɨl agɨl, apnan gɨl yenɨgabal agak. Pen kɨli anɨgɨl apnan gɨl, Bɨ Olap Ñɨne nop dɨl bɨawl okok kɨlop ñɨl agɨnɨgabal, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pen bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek, kɨli apɨl bɨ God nop sɨbogep bɨawl yɨbɨl Kayapas kal ak nan gɨl, ");
INSERT INTO taw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jisas nop tɨtay dɨl kɨmɨgel chɨchɨk dɨl, ñag lɨnɨgun agɨl, takaw aglɨl gelak. ");
INSERT INTO taw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pen agɨlak, Pasopa ñɨn awl anɨgon, binɨb kuŋay yɨbɨl ap mɨdebal okok penpen gɨnɨgel tek lup agɨlak. Anɨb ak mɨñɨl kelɨgɨl, ñɨn olap nop paklɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jisas man sɨkol Betani mɨdɨl, Saymon bɨlel bɨ soy ladek lak ak, kal ne ak am tap ñɨbelak. Ñɨŋɨlaknɨŋ, bin olap wel kuy tep owep, mani awl tawpal ak, botol sek dad apɨl, Jisas nop kɨmɨg cheg ak sogak. ");
INSERT INTO taw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Sogek, Jisas bɨne okok chɨbol kɨlop ak tɨmel gek agɨlak, Wel anɨb ak dad amɨl mani awl dɨl, binɨb yɨmgeptek okok mani anɨb ak kɨlop ñeb tek ak pen, taynen yokɨp sogup agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Takaw anɨb ak agelak Jisas nɨŋɨd kɨlop agak, Ne yɨp gɨtep yɨbɨl gup, taynen anɨb agebɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Binɨb yɨmgeptek okok ayɨp pel yenɨgabɨm, pen yad ayɨp pel ma yonɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Binɨb kamnɨg, wel lɨñɨl dam kabal tek ak yɨp lɨñeb agak. ");
INSERT INTO taw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yad nɨbop nɨŋɨd agebin, kɨdek man okok mɨdupsek, takaw yɨp ak agñɨlɨg, bin ak Jisas nop wel lɨñak agɨl nop kesɨm dɨlɨg, gak anɨb ak nɨg nep yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pen Jisas bɨne anep umɨgan olap Judas Yiskaliyot, ne bɨ God nop sɨbogep bɨawl okok kɨlop nɨgɨnɨg amnak. ");
INSERT INTO taw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Amɨl agak, Jisas nop chen gɨ dad apɨl nɨbop ñenɨgayn, yɨp tap tay ñɨnɨgabɨm agak? Agek nop mani silpa 30 tek ak ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ñelak, Judas pen tɨtay gɨl kɨlop agen, Jisas nop ap dad amnɨgel agɨl gos ak nɨgak. ");
INSERT INTO taw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pen bilet ma yɨnɨg tanub ñɨbal ñɨn awl anɨb ak owak. Ñɨn ned owak ñɨn ak, bɨne okok Jisas yek ak apɨl agɨlak, Ñɨn Pasopa chag sipsip ñɨluk pak ñɨŋɨnɨgabun ak wulep mɨdeb agɨlak. Anɨb ak chɨn kal akal amɨl, tap ñɨŋɨnɨgabun okok gɨlɨtep gɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Agelak kɨlop agak, Nɨbi taun awl ak amɨl, bɨ olap nop agɨnɨmɨb, Tisa agup, Ñɨn God ne yɨp aglak ak wulep mɨdeb ak nɨm, bɨyad okok ayɨp Pasopa chag sipsip ñɨluk pak dagɨl ñɨŋɨnɨgabun, kal nad ak agup agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisas anɨb agek, bɨne okok agak tek nɨŋɨd, amɨl Pasopa chag sipsip ak pakɨl, kal mɨgan anɨb ak dagɨl gɨlɨtep gelak. ");
INSERT INTO taw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dugep won ak bɨne anep umɨgan ak ayɨp besɨgɨl, ");
INSERT INTO taw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","tap ñɨbɨlɨg agak, Yad nɨbop nɨŋɨd agebin, bɨ nɨbi olap yɨp chen gɨ dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Agek bɨne okok chɨb nɨŋɨd gos kuŋay nɨŋɨd, nokom nokom nop agnɨgɨlɨg agɨlak, Bɨawl, yɨp apan tek agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Agelak agak, Bɨ yad ayɨp kɨnag nokom ñɨbobul ak, yɨp chen gɨ dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Buk Baybol ak bɨlel agɨl tɨkɨlak tek, Bɨ Olap Ñɨne chen gɨ dad amɨl, paklek kumnɨgab agak. Bɨ anɨb ak pen, ne Bɨ Olap Ñɨne nop chen gɨ dad amnɨgab ak, ne tɨtay dɨnɨgab agak. Nonɨm nop ma tɨkɨpɨkop ak, tep yɨbɨl agak. Pen nop tɨkek, yul awl yɨbɨl ak dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Agek, bɨne Judas nop chen gɨnɨg gak ak agak, Tisa, yɨp apan tek agak? Agek agak, Nɨm apan ak agak. ");
INSERT INTO taw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tap ñɨb mɨdɨlɨg Jisas bilet ak dɨl, God nop tep agɨl, tɨpagɨl bɨne okok kɨlop ñɨlɨg agak, Dɨl ñɨŋɨm agak. Ak mubwak yad agak. ");
INSERT INTO taw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Anɨb agɨl, ñɨg wayn kɨnag ak abe dɨl, God nop tep agɨl, kɨlop ñɨlɨg agak, Nɨbi mɨdupsek ñɨŋɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ñɨg awl nɨm, nɨkɨm yad binɨb kuŋay yɨbɨl kɨlop nen sogɨnɨgab ak nɨbop ñebin agak. Nɨkɨm yad sogɨnɨgab anɨb ak nɨm, God tap si tap tɨmel gɨpal okok tɨg walɨg gɨyokɨnɨgayn agak takaw ak am wos gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anɨb agɨl agak, Yad nɨbop agebin, mɨñɨl ñɨn awl tɨkɨl ñɨg wayn ma ñɨŋɨnɨgayn agak. Yokɨp yɨbɨl mɨden mɨden, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak ownɨgab agak. Anɨb ñɨn ak, ñɨg wayn koŋɨm ñɨŋɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Anɨb agɨl, bɨne okok ayɨp kɨmep olap agɨl, man Olip dum amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas kɨlop agak, Buk Baybol ak tɨkɨl agɨlak, God agup, Yad bɨ chag sipsip mukep ak nop paklen, chag sipsip okok mɨdupsek pɨlɨk amnɨgabal agup agɨl tɨkɨlak agak. Agɨlak anɨb ak nɨm, mɨñɨl maynab ayaŋ nɨbi mɨdupsek tap yɨp tɨtay dɨl gɨnɨgab ak nɨŋɨd, gos yɨp ak kelɨgɨl, pɨlɨk amnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pen yad kumɨl tɨkjakɨl, Galili plopens ned amnɨgayn, nɨbi kɨdek amnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Agek Pita agak, Bɨ mɨdupsek tap nep tɨtay dɨl gɨnɨgab ak nɨŋɨd, nep kelɨgɨnɨgabal tek lup, yad pen mel yɨbɨl, nep ma kelɨgɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Agek Jisas agak, Yad nep nɨŋɨd agebin, mɨñɨl maynab ayaŋ yawl kakaluk suk ma agɨnɨgab won ak, nad agɨnɨgaban, Bɨ anɨb anop ma nepin agɨnɨgaban agak. Takaw anɨb ak won omɨŋal nokom agɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Agek Pita kɨles tɨmel gɨl agak, Yɨp paklɨnɨg paklɨnɨgabal ak pen, Jisas bɨyad mel agɨl ma agɨnɨgayn agak. Jisas bɨne mɨdupsek abe Pita agak tek nep agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas bɨne okok ayɨp, kɨli man olap yɨb Getsemani apal ak amɨl, kɨlop agak, Nɨbi awl besɨg yenɨmɨb agak. Yad sɨŋadaŋ amɨl, Bapi nop agɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Anɨb agɨl, Pita nop poŋɨd, Sepedi ñɨne kɨlop omɨŋal poŋɨd saŋɨdak. Amɨlɨg, Jisas chɨbol yul awl yɨbɨl nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kɨlop yakam agak, Mɨdupmɨdup yɨp puŋɨl ñeb ak, kumnɨm tek lup agak. Nɨbi awl mɨdɨl, yɨp kod mɨdɨl nɨgtep gɨl yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Anɨb agɨl, kɨlop anɨb sɨŋak aglɨl, ne yep wulep anɨb sɨŋak amɨl, jel kuyan gɨl, jomulɨk ak dɨ lum ayaŋ lɨl, God nop agnɨŋɨd agak, Bapi, tap yɨp gɨnɨgeb anɨb ak mel agɨl yɨl, mel agɨnɨmɨn agak. Pen yad gos nepin adek ak ma gɨnɨmɨn, gos nad ke nepan tek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Anɨb agɨl adɨkɨd apɨl nɨgak, bɨne okok kɨnelak. Pen Pita nop agak, Won olap taynen yad ayɨp nɨg mɨdɨl ma kɨnebɨm agak? ");
INSERT INTO taw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chɨn tap tɨmel ma gɨnɨgun agɨl, God nop agɨlɨg yenɨmɨb agak. Gos nɨbi ak gɨnɨmɨb tek lup ak pen, mubwak anep kɨles ma gup agak. ");
INSERT INTO taw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas anɨb agɨl, tepayaŋ amɨl Nap nop agɨl agak, Bapi, tap yɨp gɨnɨgeb ak, kelɨgep tek ma mɨdeb monmon gaŋ, gos nak agak. ");
INSERT INTO taw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Anɨb agɨl, tepayaŋ adɨkɨd apɨl nɨgak, wɨsɨn apek pɨsnep kɨn amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pen ne kɨlop kelɨgɨl adɨkɨd amɨl, Nap nop ned agak tek nep tepayaŋ agnɨgak. ");
INSERT INTO taw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Agnɨŋɨd, adɨkɨd apɨl, bɨne okok kɨlop agak, Nɨbop kɨles ma gek kɨn mɨdebɨm akaŋ agak? Tɨkjakem amnun agak. Nɨgɨm. Won anɨb ak Bɨ Olap Ñɨne nop chen mɨmug gɨ dad amnɨgeb agak. Bɨ yɨp mɨmug nɨgup ak, bɨ tap si tap tɨmel gɨpal okok yɨp ñɨn adek kɨli ak ñɨnɨg, kɨlop poŋɨd apeb awl agak. ");
INSERT INTO taw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas takaw agaknɨŋ, bɨne anep umɨgan ak, kɨli olap Judas ne Jisas yek ak apjakak. Pen bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek kɨli agɨlak tek, Judas ne bɨ kuŋay yɨbɨl kɨlop poŋɨd apjakak. Bɨ poŋɨd owak anɨb okok, kɨli baynat ogɨnap, kul ogɨnap dɨl dad sek owlak. ");
INSERT INTO taw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas kɨlop aglɨl agak, Yad bɨ olap nop am dɨl, kaykol gɨneknɨŋ agɨnɨmɨb, Jisas nɨm ak agɨl, nop chɨchɨk dɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Agak tek Jisas yek ak apjakɨl agak, Tisa mɨdeban agɨl, nop kaykol gak. ");
INSERT INTO taw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Anɨgek Jisas agak, Bogɨlak, gɨnɨgeban anɨb ak kasek gan agak. Agek, bɨ Judas ayɨp owlak okok kɨli apɨl Jisas nop chɨchɨk dɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pen nop anɨgɨl dɨlaknɨŋ, Jisas bɨne olap baynat ne ak lɨpɨg dɨl, bɨ God nop sɨbogep bɨawl yɨbɨl ak bɨ wog gɨñeb ne olap nop, tɨmud pɨskɨd ak pɨsnep tɨbɨlɨk yokak. ");
INSERT INTO taw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Anɨgek Jisas nop agak, Baynat ak dɨpan okok tep ak lɨge amnaŋ agak. Binɨb baynat dɨl penpen gɨpal okok, adek anɨb ak nep kumnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nɨbi gos ma nepɨm akaŋ agak? Yad Bapi suk apɨnep, ne ensel kuŋay yɨbɨl agyokek apɨl, yɨp kod yebɨlap agak. ");
INSERT INTO taw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pen bɨlel buk Baybol ak yɨp tɨkɨl, nop anɨb anɨb gɨnɨgel agɨlak ak nɨm, anɨgɨnɨmuŋ agak. Anɨb ak yad adek olap ke genɨgayn, yɨpɨd ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pen bɨ nop dɨnɨg owlak anɨb okok kɨlop agak, Yad mɨnek mɨnek amɨl, God agnɨgep kal awl kab wali kus gɨl yek ak, wali mɨgan ak besɨgɨl, binɨb okok kɨlop takaw agñɨbin agak. Agñɨbin ak pen, yɨp dɨ nag ma lɨpɨm agak. Mɨñɨl pen baynat sek, kul sek dad apɨl, bɨ tap si dep tek ak yɨp dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pen gɨpɨm anɨb ak, bɨ God gos ñek agñeb okok gɨnɨgab agɨl tɨkɨlak tek nep gɨpɨm agak. Pen won anɨb ak Jisas bɨne okok mɨdupsek nop kelɨgɨl, pɨlɨk amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pen bɨ Jisas nop chɨchɨk dɨlak okok, kɨli nop dad, Kayapas ne bɨ God nop sɨbogep bɨawl yɨbɨl kal ak amnɨlak. Won anɨb ak, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Juda bɨawl okok sek kɨli apnan gɨ yelak, kal anɨb ak. ");
INSERT INTO taw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pen Pita kɨdek kɨdek amɨl, kal seŋ adek ak amjakɨl, wali mɨgan ayaŋ amɨl, bɨ kal anɨb ak kod mɨdeb okok ayɨp besɨgɨl, tay tek gɨnɨgabal agɨl nɨg yek. ");
INSERT INTO taw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Bɨ God nop sɨbogep bɨawl okok sek, bɨ Juda bɨawl takaw tɨg asɨkep okok mɨdupsek kɨli agɨlak, Chɨn bɨ takaw yepɨs agɨnɨgel ogɨnap kɨlop agnɨgon, kɨli apɨl takaw olap agel, chɨn nɨŋɨd, nɨŋɨd apɨm agɨl, Jisas nop paklɨnɨgun agɨlak. Anɨb agɨlak ak pen, takaw anɨb ak keke amek jɨj nɨŋɨd nop paklɨnɨgel tek olap ma yek. Kɨdek pen bɨ omɨŋal apɨl ");
INSERT INTO taw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","agɨlek, Bɨ anɨb awl ne agak, God agnɨgep kal awl ak tɨbɨlɨk yokɨl, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ gɨnɨgayn agak agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Anɨb agelek, bɨ God nop sɨbogep bɨawl yɨbɨl ak, ne tɨkjakɨl Jisas nop agnɨŋɨd agak, Takaw nep apal ak, pen ma agɨnɨgaban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Agek, Jisas pen takaw olap ma yɨbɨl agak. Anɨgek, bɨ God nop sɨbogep bɨawl yɨbɨl ak agak, Mɨñɨl kot mɨdobun awl, yepɨs ma agɨnɨmɨn agak. God Bɨawl pel mɨdep ak abe nɨg mɨdeb agak. Anɨb ak chɨnop yɨpɨd gɨl agɨnɨmɨn agak. Nad Bɨ God nop aglup ak, God Ñɨne yɨbɨl mɨdeban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Agek Jisas agak, Nɨm apan ak agak. Pen nɨbi nɨgɨm agak. Yad nɨbop agebin, kɨdek Bɨ Olap Ñɨne, ne God bɨ kɨles tɨmel mɨdeb ak ñɨn yɨpɨd kɨd okok ken besɨg mɨdɨl, wɨsɨp adek alaŋ nɨb lum awl apek nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas anɨb agek, bɨ God nop sɨbogep bɨawl yɨbɨl ak, taynen anɨb agup agɨl, chech ne okok ke tɨg talɨkɨlɨg agak, Ne God nop agjulɨg agosup agak. Taynen binɨb ogɨnap sek agnɨgɨnɨgun agak. God nop agjuwep takaw ak mɨseŋ agup nɨbi nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Akaŋ nɨbi gos tay nepɨm agak? Agek agɨlak, Nɨm agup ak nen, kumnɨmuŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Anɨb agɨl, jomulɨk nop kɨñuk gɨñɨlɨg, pakɨlɨg gɨlak. Ogɨnap we gɨl, mɨkem nop okok pak gɨlɨg ");
INSERT INTO taw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","agɨlak, Nad bɨ God gos ñek agñeb olap anɨb ak agan, nep an pakeb agɨlak. Nad Bɨ God nop aglup ak, chɨnop age nɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pen Pita ne besɨgɨl kal seŋ sɨŋak wali mɨgan ayaŋ mɨdaknɨŋ, bin kal anɨb ak wog gɨñeb olap apɨl, nop agak, Nad Jisas bɨ Galili nɨb ak ayɨp yesɨpil agak. ");
INSERT INTO taw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Agek, Pita binɨb okok mɨdupsek nɨg yelaknɨŋ kɨlop agak, Takaw nad ageban ak yad ma nepin agak. ");
INSERT INTO taw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Anɨb agɨl, tɨkjakɨl am kanɨbtub sɨŋak mɨdaknɨŋ, bin kal anɨb ak wog gɨñeb olap sek apɨl nop nɨŋɨd, bɨ yelak okok kɨlop agak, Bɨ anɨb ak ne Jisas Nasalet nɨb ak ayɨp mɨdel nepin agak. ");
INSERT INTO taw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Agek, Pita ag sɨlokɨl agak, Yad nɨŋɨd yɨbɨl apin agak. Bɨ apɨm anɨb ak yad ma yɨbɨl nepin agak. ");
INSERT INTO taw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sɨkol won olap mɨdɨl, bɨ Pita ayɨp jak yelak okok nop agɨlak, Nɨŋɨd yɨbɨl apun, nad bɨ kɨli olap agɨlak. Meg mɨgan kɨli apal tek apan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Agelak, Pita takaw tɨmel agɨl kɨles gɨl agɨl agak, Yad nɨbop nɨŋɨd yɨbɨl apin, bɨ nɨbi apɨm anɨb ak yad ma yɨbɨl nepin agak. Pen anɨb agaknɨŋ, yawl kakaluk ak suk agak. ");
INSERT INTO taw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Agek, Pita gos ak nɨgak, Jisas ned agak, Kakaluk suk ma agɨnɨgab won ak agɨnɨgaban, Jisas nop ma nepin agɨnɨgaban agak. Takaw anɨb ak won omɨŋal nokom agɨnɨgaban agak. Takaw anɨb ak gos nɨŋɨd, seŋ amɨl chaŋ awl yɨbɨl lak. ");
INSERT INTO taw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Man tɨkaknɨŋ, bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek kɨli takaw agnɨg agnɨg gɨl, Jisas nop paklun agɨl, ");
INSERT INTO taw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","nop nag lɨl dad amɨl, gapman bɨawl Paylat nop ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pen Jisas nop kot gɨl, paklɨnɨg gelak nɨŋɨd, Judas ne taynen Jisas nop mɨmug nepin agɨl, mani silpa 30 tek dak ak, bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek kɨlop ju dam ñɨnɨg amnak. Amɨl, mani anɨb ak kɨlop ñɨlɨg agak, ");
INSERT INTO taw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yad tap tɨmel gɨpin agak. Jisas tɨmel ma gup ak pen, nop mɨmug nepin tek kumnɨgab agak. Agek kɨli agɨlak, Ak tap chɨn mel agɨlak. Nak ke nep anɨgɨpan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Agelak, mani ñɨlak ak God agnɨgep kal awl mɨgan ak dɨyokɨl, am nag ñɨŋak. ");
INSERT INTO taw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɨ God nop sɨbogep bɨawl okok mani anɨb ak dɨl agɨlak, Mani anɨb awl, bɨ paklun agɨl mɨmug gɨlak ak nɨm, mani God agnɨgep kal awl ñɨbal ak ayɨp omɨŋal gɨl lɨnɨgun tek ma lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Anɨb agɨl, takaw agnɨg agnɨg gɨl aglɨlak. Aglɨl, mani awl lum olap tawnɨgun agɨl, am man wakay olap tawɨlak. Man anɨb ak, binɨb okok kɨli lum yɨgɨl sɨge cheg gelɨgɨpal. Pen man anɨb ak tawɨl agɨlak, Bɨ pal okok nɨb apɨl awl kumel, man wakay anɨb ak dam kɨlop kamnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Agɨl, man wakay anɨb awl, mɨmug nɨŋɨd puŋɨl ñɨbal mani ak dɨl tawɨlak. Anɨgɨl tawel, binɨb okok kɨli yɨb anɨb ak agɨlak, Nɨkɨm Yowak Lum ak agɨlak. Mɨñɨl abe man wakay anɨb ak, yɨb Nɨkɨm Yowak Lum ak apal. ");
INSERT INTO taw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pen kɨli anɨgɨlak anɨb ak, bɨ God gos ñek agñeb Jelemaya ned agɨl tɨkak tek nep gɨlak. Ne tɨkɨl agak, Kɨli mani silpa 30 tek ak dɨpal agɨl tɨkak. Mani anɨb ak, Yislel binɨb kɨli bɨ anɨb anop mɨmug puŋɨl ñɨlak mani aglɨlak ak agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pen dɨl, dad amɨl, lum yɨgɨl sɨge cheg gelɨgɨpal man wakay ak tawpal agɨl tɨkak. Bɨawl ak yɨp agak tek nep gɨlak agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas nop dad gapman bɨawl Paylat yek ak amel, Paylat ne Jisas nop agnɨŋɨd agak, Nak Juda bɨnonɨm kɨli ak akaŋ agak? Agek Jisas agak, Nɨm nak ke apan ak agak. ");
INSERT INTO taw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pen bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek kɨli nop takaw ogɨnap agelak, ne pen takaw olap ma yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Anɨgek, gapman bɨawl Paylat agak, Takaw keke agɨl nep agebal ak ma nepan akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Agek, Jisas nop takaw olap ma agek, Paylat gos kuŋay yɨbɨl nɨgak. ");
INSERT INTO taw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pen Lom gapman bɨawl ak pel sub ak sub ak Pasopa ñɨn awl anɨb ak, ne bɨ nag lep olap nop wɨsɨb agyokolɨgup. Binɨb kɨli bɨ nag lep olap yɨb nop agelɨgɨpal ak, bɨawl ak ne bɨ anɨb ak nop wɨsɨb agyokolɨgup. ");
INSERT INTO taw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pen ñɨn anɨb ak, bɨ tap tɨmel golɨgup olap, kɨli nop nɨgtep gɨpal ak dap nag lel yek, yɨb ne ak Balabas. ");
INSERT INTO taw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Paylat ne nɨgak, Juda bɨawl okol Jisas nop yokɨp mɨlɨk nɨŋɨd dad owlak. Anɨb ak binɨb kuŋay apnan gɨlak ak, Paylat kɨlop agak, Bɨ nɨbop akal wɨsɨb agyokɨnɨm agak? Balabas nop akaŋ, Jisas Bɨ God nop aglup ak apal ak nop agak? ");
INSERT INTO taw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pen Paylat bɨawl besɨgep adek ak besɨg mɨdaknɨŋ, bin ne takaw olap agek bɨ olap apek agak, Bin nad anɨb agup, Yad maynab ayaŋ wɨsɨn nepin, bɨ kot gebɨm ak bɨ tep agup agak. Nop takaw kɨles ma agɨnɨmɨn agup agak. Yad wɨsɨn nepin anɨb ak, yɨp jel tɨmel gup agup agak. ");
INSERT INTO taw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek kɨli pen, binɨb okok kɨlop agɨlak, Gapman bɨawl Paylat nop agɨnɨmɨb, Balabas nop wɨsɨb agyokɨl, Jisas nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨnɨmɨb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Anɨb ak gapman bɨawl ak kɨlop agak, Bɨ omɨŋal awl, an nop tek nɨbop wɨsɨb agyokɨnɨm agak? Agek agɨlak, Balabas nop wɨsɨb agyokɨnɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Agelak Paylat agak, Anɨb apɨm ak, Jisas Bɨ God nop aglup ak apal ak nop tay gɨnɨm agak? Agek, kɨli mɨdupsek agɨlak, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Agelak Paylat agak, Taynen? Ne tap tay tɨmel gup agak? Pen takaw agak ak ma nɨŋɨd, takaw dad aplanɨl agɨlak, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Agelak takaw ogɨnap sek agen penpen gɨnɨgel tek lup agɨl, Paylat ñɨg dɨl ñɨn lɨ yokɨlɨg kɨlop agak, Bɨ anɨb ak nop paklɨnɨg gebɨm ak, takaw anɨb ak yɨp ma ownɨgab, nɨbop ke adɨkɨd ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Agek agɨlak, Ak chɨp kɨmɨg chɨn ke agɨlak. Takaw anɨb ak, chɨn sek, ñapay chɨn okok sek nɨgɨnɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anɨb agelak, Paylat kɨlop Balabas nop wɨsɨb agyokak. Agyokɨl, bɨ chɨm kadɨŋ gep ne okok kɨlop agek, Jisas nop nag dɨl pakɨlak. Pakel, Paylat Jisas nop mab bak alaŋ chɨpɨl pak tɨbɨk lel kumaŋ agɨl, bɨ chɨm kadɨŋ gep ne ogɨnap sek kɨlop ñak. ");
INSERT INTO taw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gapman bɨawl bɨ chɨm kadɨŋ gep ne okok kɨli Jisas nop dɨl, dad gapman kal awl ak amɨl, bɨ chɨm kadɨŋ gep okok kɨlop mɨdupsek suk agel, apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Apnan gɨl, chech nop ak tɨgjuwɨl, chech nɨkɨm bɨawl yɨbal tek olap dad apɨl nop lɨñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Lɨñɨl, nag ñuñu sek okok dad apɨl, bɨnonɨm kay lɨpal kɨmɨg cheg adek bad tek olap gɨl, kɨmɨg cheg nop lɨñɨlak. Lɨñɨl, bɨnonɨm okok kul abe dɨpal agɨl, gamɨl pal olap dɨl Jisas nop ñɨn yɨpɨd kɨd ak ñɨl, apɨl nop kɨgom yɨmɨl, agjulɨg agɨlak, Juda bɨnonɨm kɨli awl pel yenɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Anɨb agɨl, nop kɨñuk gɨl, gamɨl kul anɨb ak ju dɨl, nop kɨmɨg dum alaŋ pak pakɨlɨg gɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nop anɨgɨl agjuwɨl, chech palawl nop lɨñɨlak ak tɨg asɨk dɨl, chech ne ke ak lɨñɨlak. Lɨñɨl, mab bak alaŋ chɨpɨl pak tɨbɨk lɨnɨg poŋɨd amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kanɨb nab okok dad amɨlɨg nɨgɨlak, bɨ olap taun Saylini nɨb apek. Yɨb ne ak Saymon. Nop kanɨb nebeŋ pakɨl, kɨles gɨl agɨlak, Jisas nop chɨpɨl pak tɨbɨk lɨnɨgabun mab bak awl ak dad amnoŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Agel dɨl, anɨgɨl amɨl, man Chɨp Kɨmɨg Cheg Won apal ak, yɨb Golgota ak amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pen man anɨb ak amjakɨl, bɨ chɨm kadɨŋ gep okok kɨli malasin sɨlek ak sek, ñɨg wayn ak sek, tɨg adɨk madɨk gɨl, Jisas nop ñelak, ne ñɨb nɨŋɨd kelɨgak. ");
INSERT INTO taw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pen nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨl, chech nop okok bɨlok keke dɨnɨg, sadu tek gɨl dɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dɨl nɨm, nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak jɨj sɨŋak besɨgɨl nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pen mab bog bad olap, Jisas nop chɨpɨl pak tɨbɨk lɨl, mab bak alaŋ yɨb tɨk lɨl agɨlak, Bɨ anɨb ak Jisas, ne Juda bɨnonɨm kɨli ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pen Jisas nop chɨpɨl pak tɨbɨk lɨlak ak, bɨ tap si dep omɨŋal ak, olap ñɨn yɨpɨd pɨs ak, olap ñɨn aŋɨd pɨs ak chɨpɨl pak tɨbɨk lɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Binɨb kanɨb aplan apyan gelak okok, kɨmɨg golmal gɨl nop agjulɨg ");
INSERT INTO taw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","agɨlak, Ey. Yad God agnɨgep kal awl ak tɨbɨlɨkɨl, ñɨn omɨŋal nokom tepayaŋ gɨnɨgayn apan ak, mɨñɨl nad ke gɨl koŋɨm amnoŋ agɨlak. Nad God Ñɨne tek, mab bak alaŋ kelɨgɨl lum ayaŋ owan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Juda bɨawl okok sek, kɨli abe nop agjuwɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Binɨb ogɨnap kɨlop gek koŋɨm abal ak pen, ne ke anɨgɨnɨmuŋ tek ma lup agɨlak. Ne Yislel binɨb bɨnonɨm kɨli ak, mab bak alaŋ mɨñɨl kelɨgɨl lum awl ape, nɨŋɨd agup agɨl nop gos lɨnɨgɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ne God nop gos nɨŋɨd, yad God Ñɨne agup ak agɨlak. Anɨb ak, God nop mapen yɨbɨl lɨl nɨm, mɨñɨl apɨl nop mapen nɨŋɨd daŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɨ tap si dep Jisas ayɨp chɨpɨl pak tɨbɨk lɨlak omɨŋal ak abe, nop takaw tɨmel anɨb ak tek nep agɨlek. ");
INSERT INTO taw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ñɨn anɨb ak subnab won ak, man anɨb ak kɨsɨlɨm apɨl, mɨd dad amɨl sub kɨyum gak won ak tepayaŋ mɨlek gak. ");
INSERT INTO taw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Won anɨb ak Jisas suk awl agɨl agak, Eli, Eli, lema sabaktani agak. Agak anɨb ak, God yad ak, God yad ak, yɨp taynen kelɨgɨpan agɨl agak. ");
INSERT INTO taw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne anɨgɨl suk awl agek, binɨb ogɨnap wulep anɨb sɨŋak jak yelak okok nɨŋɨd anɨb agɨlak, Bɨ anɨb awl bɨ God gos ñek agñeb Yilayja nop suk agosup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Anɨb agɨl, bɨ olap am tap ñɨg dak tap ak olap dɨl dad apɨl, ñɨg wayn sɨlek ak mɨgan ayaŋ tawɨl, gamɨl kul pal ak dɨl, kabes ñagɨl, ñen ñɨŋaŋ agɨl ñak. ");
INSERT INTO taw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Anɨgɨl ñek, bɨ ogɨnap agɨlak, Kɨmɨgel nɨg mɨdon agɨlak. Bɨ Yilayja apɨl, nop dɨyokɨnɨgab akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Agɨl, nɨg yelaknɨŋ, Jisas suk awl agɨl, añɨŋ bad yek ak kul gak. ");
INSERT INTO taw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Won anɨb anep, God agnɨgep kal awl ñɨluk mɨgan ayaŋ chech palawl kanɨbtub pɨl gɨlak ak, day alaŋ nɨb lak dam day ayaŋ yokɨl, talɨkɨl pɨspɨs amnak. Anɨgaknɨŋ, monmon dɨl, kab okok abe pagak. ");
INSERT INTO taw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Anɨgek, chɨp kamɨlak kab mɨgan pɨl gɨlak okok mɨgan yɨkak. Mɨgan yɨkel, God binɨb ne ned kumel kamɨlak okok kuŋay yɨbɨl gek, tepayaŋ tɨkjakɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tɨkjakɨl, kawtub ak kelɨgɨl kod yelak, Jisas kɨdek tɨkjakak nɨŋɨd, kɨli God taun ne Jelusalem ak amelak, binɨb kuŋay kɨlop nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pen bɨ chɨm kadɨŋ gep bɨawl ak sek, bɨne okok sek, kɨli Jisas nop kod yelak. Anɨgɨl yelak, monmon dɨl, tɨtay gak okok mɨdupsek nɨŋɨd, kɨli pɨlɨkɨl agɨlak, Yawe, bɨ anɨb ak God Ñɨne yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pen bin kuŋay yɨbɨl apɨl, keke sɨŋadaŋ mɨdɨl nɨg yelak. Bin anɨb okok, Jisas nop kɨdek gɨl Galili plopens nɨb apɨl, nop gɨtep gɨl kod yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bin yelak anɨb okok, olap Maliya taun Makdala nɨb ak, olap Jemis ayɨp Josep ayɨp nonɨm Maliya, olap bɨ Sepedi ñɨne omɨŋal nonɨm ak. ");
INSERT INTO taw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bɨ tap kuŋay yek man sɨkol Alimateya nɨb, yɨb ne ak Josep, ne Jisas bɨne olap. Ne Jisas kumek nɨŋɨd, dugep won ak apɨl, ");
INSERT INTO taw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","gapman bɨawl Paylat nop Jisas chɨp ak dɨnɨm akaŋ agek, Paylat yaw agɨl, bɨne okok kɨlop agek, nop ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kɨli Josep nop Jisas chɨp ak ñelak, ne dad amɨl chech kayɨg tep ak dɨl, nop mɨdupsek kam sɨlokak. ");
INSERT INTO taw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kam sɨlokɨl, kab mɨgan kɨdeyɨl nep, ne ke kaw koŋɨm dɨlak mɨgan ak dam kab mɨgan tɨdamɨgɨl dɨlak ak kamak. Kamɨl, kab awl olap tɨg mɨmlokek amek, kawtub ak pɨl gɨl amnak. ");
INSERT INTO taw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pen bin Maliya taun Makdala nɨb ayɨp, bin Maliya olap ayɨp, omɨŋal gɨl ap nɨg yɨleknɨŋ, anɨgɨl kamak. ");
INSERT INTO taw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas kumek kamɨlak ñɨn anɨb ak, tap dap nan gep ñɨn ak. Mɨnek pen, Juda añɨŋ lep ñɨn awl ak, bɨ God nop sɨbogep bɨawl okok sek, bɨ Pelisi okok sek kɨli gapman bɨawl Paylat yek ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Amɨl agɨlak, Bɨawl. Chɨn nopun, bɨ yepɨs agep anɨb ak agak, Yad kumɨl, ñɨn omɨŋal nokom mɨdɨl tɨkjakɨnɨgayn agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anɨb ak bɨ ogɨnap age, ñɨn omɨŋal nokom kawtub ak kod yenɨgel agɨlak. Mel ak, bɨne okok apɨl chɨp ak si dad amɨl, binɨb okok kɨlop yepɨs agɨl agɨnɨgabal, Ne tepayaŋ tɨkjakup agɨnɨgabal agɨlak. Anɨgelak, takaw yepɨs agolɨgup ak sɨkol tek lɨnɨgab ak, kɨdek agɨnɨgabal ak awl yɨbɨl gɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Agelak Paylat kɨlop agak, Nɨbi bɨ chɨm kadɨŋ gep kab olap agtep gem, kɨli am kawtub ak nɨgtep gɨl kod yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Agek, kɨli amɨl kanɨb pɨl gɨlak kab awl ak wɨlen tek gɨl, bɨ chɨm kadɨŋ gep kab olap kɨlop agelak, am anɨb sɨŋak nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pen Juda añɨŋ lep ñɨn awl ak gɨjuwɨl, mɨnek Sande ñɨn ak man tɨkak won ak, bin Maliya taun Makdala nɨb ak ayɨp, Maliya olap ke ayɨp, kɨli omɨŋal gɨl chɨp kaw tub nɨgɨnɨg owlek. ");
INSERT INTO taw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Won anɨb ak ensel olap God man ne alaŋ nɨb apek, monmon awl yɨbɨl ak owak. Ensel anɨb ak apɨl, kab kolɨm awl chɨp kaw tub mɨgan ak pɨl gɨlak ak, mɨmlokɨd amek, adek anɨb ak besɨgak. ");
INSERT INTO taw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ensel kab adek besɨg yek anɨb ak, jomulɨk ne ak ñɨñakol gɨlɨg yek, chech ne ak kayɨg tep yɨbɨl lak. ");
INSERT INTO taw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pen bɨ chɨm kadɨŋ gep nɨg yelak okok, nop nɨŋɨd jel pɨlɨkɨl, kɨn abun tɨkɨl yelak. ");
INSERT INTO taw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pen ensel ak bin omɨŋal ak kɨlop agak, Ma pɨlɨkɨnɨmil agak. Yad nepin, ñɨli omɨŋal Jisas bɨ mab bak alaŋ chɨpɨl pak tɨbɨk lel kumak ak nop nɨgɨnɨg apebil agak. ");
INSERT INTO taw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ne awl ma mɨdeb, ned agak tek mɨneyɨl tɨkjakup agak. Apɨl, nop dɨlɨlak adek ak nɨgɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɨŋɨd, kasek amɨl, Jisas bɨne okok kɨlop takaw anɨb ak agñɨnɨmil agak. Anɨb agɨnɨmil, Ne kumɨl tepayaŋ tɨkjakup agɨnɨmil agak. Nɨgɨm, ne ned tɨkjakɨl Galili plopens am yenɨgab, nɨbi kɨdek amɨl nop nɨgɨnɨgabɨm agɨnɨmil agak. Takaw anɨb ak ñɨlop agñɨnɨg apebin agak. ");
INSERT INTO taw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Anɨb agek nɨŋɨd, bin omɨŋal ak kasek amɨl pɨlɨkɨlek ak pen, mɨñmɨñ gɨlɨg, bɨne okok kɨlop takaw anɨb ak agɨnɨg kasek amnɨlek. ");
INSERT INTO taw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kanɨb nab okok amnɨleknɨŋ, Jisas kɨlopmɨŋal nebeŋ pakɨl agak, Ñɨli apebil agak. Agek, kɨli omɨŋal apɨl kɨgom yɨmɨl, tob nop dɨnɨŋɨd yɨb nop dad aplanilek. ");
INSERT INTO taw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Anɨgelek, Jisas kɨlopmɨŋal agak, Ma pɨlɨkɨnɨmil agak. Ñɨli amɨl, mam yad okok kɨlop agñɨnɨmil, Nɨbi Galili plopens amnɨmɨb agɨnɨmil agak. Kɨli man anɨb ak amɨl, yɨp nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bin omɨŋal ak kanɨb nab okok amnɨleknɨŋ, bɨ chɨm kadɨŋ gep nɨg yelak ogɨnap, kɨli tɨkjakɨl Jelusalem amɨl, bɨ God nop sɨbogep bɨawl okok kɨlop, tap anɨb okok gup takaw ak agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Agñelak, bɨ God nop sɨbogep bɨawl okok amɨl, Juda bɨawl okok ayɨp takaw ag adek nokom lɨlak. Aglɨl, apɨl bɨ chɨm kadɨŋ gep anɨb okok kɨlop mani awl ñɨl ");
INSERT INTO taw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","agɨlak, Nɨbi anɨb agɨnɨmɨb, Chɨn kɨnɨbun maynab ayaŋ won ak, bɨne okok apɨl, nop si dad abal agɨnɨmɨb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pen gapman bɨawl ak takaw anɨb ak nɨgenɨgab, chɨn ne ayɨp agɨnɨgabun agɨlak. Agon, ne nɨbop mɨŋel ogɨnap ma ñɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Anɨb agel, bɨ chɨm kadɨŋ gep okok mani anɨb ak dɨl, amɨl bɨawl anɨb okok agɨlak tek nep agɨlak. Kɨli anɨb agel, takaw anɨb ak Juda binɨb man kɨli okok mɨdupsek amɨl, mɨd dad apɨl mɨñɨl Juda binɨb okok takaw anɨb ak agɨlɨg mɨdebal. ");
INSERT INTO taw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pen Jisas bɨne anep agɨp ak Galili plopens amɨl, kɨlop ned agak dum ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amɨl Jisas nop nɨŋɨd, yɨb nop dad aplanɨlak. Ogɨnap pen gos omɨŋal gɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pen Jisas wulep sɨŋak apɨl, kɨlop agak, God ne yɨp agek, man ne alaŋ kod mɨdɨl, lum awl kod mɨdɨl gɨpin agak. ");
INSERT INTO taw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Anɨb ak, nɨbi man okok mɨdupsek amɨl, binɨb okok kɨlop gem binɨb yad okok yenɨgel agak. Bapi yɨl mɨdebal, Ñɨne yɨl mɨdebal, Kawnan ne ak yɨl mɨdebal agɨl, kɨlop ñɨg pakñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ñɨg pakñɨl, yad takaw nɨbop agñɨbin ak mɨdupsek, kɨlop agñɨtep gem nɨŋɨd kɨdek gɨnɨgel agak. Pen nɨgɨm, yad nɨbi ayɨp nep mɨdɨl, mɨd dad amɨl, ñɨn kɨdek ak ownɨgab ñɨn ak, lum awl kul gɨnɨgab agak.");
INSERT INTO taw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Klays God Ñɨne takaw teplep ak mɨj tɨkɨnɨgebin. ");
INSERT INTO taw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bɨ God gos ñek agñeb Aysaya, ne bɨlel tɨkɨl agak, God ne Ñɨne nop agup, Nɨgan, bɨ takaw dad ameb yad ak agyoken, ned amɨl kanɨb pɨdɨl kod yek, kɨdek nep agen amnɨgaban agup agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bɨ anɨb ak man nep binɨb ma mɨdebal nab okok suk awl agɨl agɨnɨgab, Bɨawl ak kanɨb nop pɨdɨl kod yenɨmɨb agɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon Bɨ Ñɨg Pakñeb ak pen tɨkjakɨl, man nep binɨb ma yelak nab okok yolɨgup. Mɨdɨlɨg, binɨb okok apel kɨlop takaw agñɨlɨg agolɨgup, Tap si tap tɨmel gɨpɨm ak taynen anɨgɨpun agɨl kelɨgem, nɨbop ñɨg pakñen nɨm, God tap tɨmel okok tɨg walɨg gɨyokɨnɨgab agolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne anɨb agaknɨŋ, binɨb Judiya plopens sek man awl Jelusalem sek okok kɨli kuŋay yɨbɨl takaw nop ak nɨgɨnɨg amelɨgɨpal. Amɨl, tap si tap tɨmel gɨlak okok agyɨkɨlaknɨŋ, kɨlop ñɨg Jodan nab ak ñɨg pakñolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pen chag kamel wɨj dɨl chech gɨlak ak, Jon ne dɨl tol gɨl, sɨbnag olap pogɨlolɨgup. Joŋ ak sek sɨbɨnɨm ñɨg ak sek ñɨbɨlɨg yolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Binɨb okok kɨlop anɨb agolɨgup, Bɨ olap kɨdek ownɨgab ak bɨawl yɨbɨl, yad bɨ yokɨp agolɨgup. Nop nɨgen yɨp nebeŋ gup, tob tɨlup nop ak nag wɨsɨkɨnɨm tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yad nɨbop ñɨg pakñebin agolɨgup. Bɨawl ne apɨl, God Kawnan ak nɨbop pakñɨnɨgab agolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jisas taun Nasalet Galili plopens yolɨgup. Pen ñɨn olap man anɨb ak kelɨgɨl, Jon yek ak apek, nop ñɨg Jodan nab ak ñɨg pakñak. ");
INSERT INTO taw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nop anɨgɨl ñɨg pakñek, Jisas tɨkjakaknɨŋ, God man ne alaŋ mɨgan yɨkɨl yek, God Kawnan ne ak yawl gɨpkay tek wɨŋɨd apɨl nop lak. ");
INSERT INTO taw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lek, takaw olap wɨsɨp nab alaŋ nɨb apɨl agak, Nad ñɨ mapen yad yɨbɨl agak. Nep nɨgen yɨp tep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pen won anɨb anep, God Kawnan ne ak Jisas nop gek, man binɨb ma yelak nab okok amɨl, ");
INSERT INTO taw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ñɨn anep 40 yolɨgup. Mɨdɨl, kɨcheki bɨawl ak Satan, ne Jisas yad yɨl owaŋ agɨl, ap nop agnɨgolɨgup. Man wakay anɨb ak, sab chag ladek be okok kuŋay yɨbɨl ayɨp yelɨgɨpal. Pen ensel okok ap Jisas nop bak lɨl kod yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pen gapman bɨnonɨm Helod ne Jon nop nag lak ñɨn anɨb ak, Jisas ne Galili plopens amɨl, God takaw teplep ak binɨb okok kɨlop agñak. ");
INSERT INTO taw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Agñɨlɨg agak, God binɨb dɨl kɨlop kod yenɨgab ak, ñɨn anɨb ak pel kod yelɨgɨpɨm ak, wulep mɨdeb agak. Tap si tap tɨmel gɨpɨm ak taynen anɨgɨpun agɨl kelɨgɨl, God takaw teplep ne ak gos nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pen Jisas ne Galili ñɨg cheb gol ak apɨl nɨgak, bɨ kubsal dep madɨlmal ak, kubsal dep asas ak dɨl, ñɨg nab okyaŋ yokɨl yelek. Bɨ madɨlmal anɨb ak yɨb kɨli omɨŋal ak, Saymon ayɨp Edlu ayɨp. ");
INSERT INTO taw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas kɨlopmɨŋal nɨŋɨd anɨb agak, Yɨp kɨdek gel nɨm, ñɨlop agñɨtep gen, bɨ binɨb dep omɨŋal ak yenɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Agek, won anɨb ak kubsal dep asas okok kelɨgɨl, Jisas nop kɨdek gɨlek. ");
INSERT INTO taw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pen Jisas sɨkol won olap amɨl nɨgak, Sepedi ñɨne Jemis ayɨp Jon ayɨp bot mɨgan ak mɨdɨlɨg, kubsal dep asas ak pugɨlɨkak ak kopɨs kopɨs gɨl yelek. ");
INSERT INTO taw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kɨlopmɨŋal nɨŋɨd anɨb agak, Ñɨli owil agak. Agek kɨlimɨŋal nɨŋɨd, nap nop bɨ wog gɨñeb ne ogɨnap ayɨp bot adek ak kelɨgɨl, Jisas nop kɨdek gɨlek. ");
INSERT INTO taw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pen kɨli taun Kapeneyam amɨl, Juda añɨŋ lep ñɨn awl ak apek, Jisas ne Juda apnan gɨpal kal ak mɨgan ayaŋ amɨl, tɨkjakɨl God takaw ak kɨlop agñak. ");
INSERT INTO taw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","God takaw ak agek, binɨb kɨli ap yelak okok takaw agñub ak nɨŋɨd wal agɨl agɨlak, Ne bɨ yɨb sek, takaw nɨgtep yɨbɨl gɨl agup agɨlak. Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep chɨn okok apal tek ne ma agup agɨlak. Anɨb agɨlɨg gos pal awl lɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pen won anɨb ak bɨ kɨcheki mulɨk sɨkɨl yek olap, Juda apnan gɨpal kal nab anɨb ak yek ak suk awl agɨl agak, ");
INSERT INTO taw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jisas bɨ Nasalet nɨb. Nad tay gɨnɨg opan? Chɨnop gɨ tɨmel gɨnɨg opan tek lup agak? Yad nep nepin, God bɨ suŋtep yɨbɨl ne ak opan agak. ");
INSERT INTO taw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Agek, Jisas kɨcheki anop takaw kɨles agak, Takaw ma agɨnɨmɨn. Bɨ anop kelɨgɨl seŋayaŋ amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Agek, kɨcheki ne bɨ anop gek, jep dɨl suk awl agaknɨŋ, kɨcheki seŋayaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Anɨgek, binɨb mɨdupsek nɨg yelak okok kɨli judɨl, nep agnɨg agnɨg gɨl agɨlak, Bɨ anɨb ak takaw kɨdeyɨl adek olap dad owup tek lup agɨlak. Bɨ kabɨyam tɨmel anɨb awl, takaw anɨb ak agek, kɨcheki okok pɨlɨk abal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pen Jisas gak takaw anɨb ak, Galili plopens okok mɨdupsek kasek dad amɨl agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pen Jisas bɨne okok ayɨp Juda apnan gɨpal kal ak kelɨgɨl, seŋayaŋ amɨl, Saymon ayɨp nɨmam Edlu ayɨp kal ak amnɨg saŋɨdɨlak. Jemis ayɨp Jon ayɨp amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kal amjakɨl mɨgan ayaŋ amɨl, Jisas nop agɨlak, Saymon nɨmak ne, wak nop mab tek yɨnek, kɨn yek agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Agelak, Jisas am ñɨn nop dɨ jakñaknɨŋ, wak mab tek yɨnek ak suŋ lak. Suŋ lek, bin anɨb ak tap mɨdup kɨlop gɨlɨtep gak. ");
INSERT INTO taw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pen sub saŋɨd amnak won ak, binɨb tap gak okok ayɨp kɨcheki mulɨk sɨkak okok ayɨp Jisas gek suŋ laŋ agɨl, yek ak dad owlak. ");
INSERT INTO taw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Binɨb man awl anɨb ak yɨl mɨdupsek, kɨli ap kanɨbtub seŋ okyaŋ ken nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nɨg yelaknɨŋ, binɨb tap gak okok gek suŋ lɨl, kɨcheki walɨjpal mulɨk sɨkak okok agɨl seŋ agyokak. Pen kɨcheki anɨb okok Jisas nop nɨgtep gɨlak tek, God Ñɨne ap mɨdeb awl agɨl mɨseŋ agɨnɨg gelak, kɨlop takaw ma agɨnɨmɨb agɨl seŋ agyokak. ");
INSERT INTO taw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mɨnek, Jisas maynab yɨbɨl tɨkjakɨl, man awl anɨb ak kelɨgɨl, wakay olap ke amɨl, nap nop agɨlɨg yek. ");
INSERT INTO taw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pen bɨne Saymon, bɨne ogɨnap ayɨp Jisas akal agɨl, pɨyow dad amɨl, ");
INSERT INTO taw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","nop nɨŋɨd anɨb agɨlak, Binɨb mɨdupsek nep akal agɨl pɨyowebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Anɨb agelak Jisas agak, Man wakay olap nep agñin agɨl ma ownek agak. Man ogɨnap abe agñin agɨl ownek tek nem amnun agak. ");
INSERT INTO taw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Anɨb agɨl, Galili plopens nab okok ajɨlɨg, am Juda apnan gɨpal kal okok mɨgan ayaŋ amnak. Amɨl God takaw agñɨlɨg, binɨb kɨcheki walɨjpal mulɨk sɨkak okok, Jisas kɨcheki okok agek seŋayaŋ amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pen bɨ soy ladek lak olap Jisas yek wulep sɨŋak apɨl, kɨgom yɨmɨl agak, Nad yɨp yɨmug nɨŋɨd, ge soy yad ak suŋ lɨnɨmuŋ, binɨb mɨdebal nab okok amnin agak. ");
INSERT INTO taw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Anɨb agek Jisas nop mapen nɨŋɨd, dɨnɨgɨlɨg agak, Nep gen suŋ lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Agek, won anɨb ak nep soy ladek anɨb ak suŋ lek, mɨdtep gak. ");
INSERT INTO taw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Anɨgek, Jisas bɨ anɨb anop kasek agyokɨlɨg takaw kɨles tɨmel agak, ");
INSERT INTO taw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Yɨp dɨnɨgek suŋ lup agɨl, bɨ olap ma agɨnɨmɨn agak. Bɨ Mosis bɨlel God takaw ak ñu kɨl tɨkak tek, nad anɨgɨnɨmɨn agak. Nad amɨl, bɨ God nop sɨbogep ak nop wak nad yoman agak. Yomɨl, soy ladek yad ak suŋ lup agɨl, chag sipsip olap God nop pak ñɨnɨmɨn agak. Pak ñe, bɨ okok kɨli nɨgɨnɨgabal, soy ladek nad ak suŋ lup agak. ");
INSERT INTO taw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Anɨb agek ak pen, bɨ anɨb ak ne amɨl, binɨb okok monmon agñak. Agñek nɨm, Jisas man okok mɨseŋ ajonɨmuŋ tek ma lek, man awl ne ma amnak, ne binɨb ma yelak okok yek. Mɨdaknɨŋ, binɨb man keke nop nɨgɨnɨg apelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kɨdek pen Jisas tepayaŋ taun Kapeneyam apek, ap mɨdeb kal ak agel nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nɨŋɨd, binɨb kuŋay yɨbɨl ap gel gel, kal mɨgan kanɨbtub seŋayaŋ tɨbɨk dɨl yek. Jisas kal mɨgan ayaŋ nep mɨdɨlɨg, kɨlop God takaw ak agñak. ");
INSERT INTO taw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Agñaknɨŋ, bɨ anep tɨgawup ak, bɨ ñɨn tob kumak ak olap yɨl lɨl dapɨl nɨgɨlak, ");
INSERT INTO taw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","tep ak tɨbɨk dak. Nɨŋɨd, bɨ ñɨn tob kumak anop dad kal adek alaŋ amɨl, kal ak tɨg talɨkɨl, nag tun gɨl, Jisas yek nab okyaŋ saynsayn yokel apyowak. ");
INSERT INTO taw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gos kɨli ak Jisas nop yɨl nep amnak tek, Jisas anɨb nɨŋɨd, bɨ ñɨn tob kumak anop agak, Ñɨ yad. Tap si tap tɨmel gɨpan okok tɨg walɨg gɨyokebin agak. ");
INSERT INTO taw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Anɨb agek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap besɨg mɨdebal okok, gos nab kɨli okok nep ke agɨl gos nɨgɨlak, ");
INSERT INTO taw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Taynen bɨ anɨb ak takaw anɨb ak agup agɨl gos nɨgɨlak. God nop agjulɨg yepɨs gup agɨl gos nɨgɨlak. God ne nokom tap si tap tɨmel gɨpal okok tɨg walɨg gɨyokup agɨl gos nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pen won anɨb ak Jisas gos nɨgɨlak anɨb ak ke nɨŋɨd anɨb agak, Nɨbi taynen yɨp gos tɨmel nɨŋɨd gos anɨb ak nɨgebɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bɨ ñɨn tob kumak anop tɨtay agen tep gɨnɨgab agak? Tap si tap tɨmel gɨpan ak tɨg walɨg gɨyokebin agen tep gɨnɨgab akaŋ, tɨkjakɨl mɨj nak ak wɨnɨg dad amnoŋ agen tep gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pen nɨgtep yɨbɨl gɨnɨmɨb agak. Takaw nop apin anɨb ak jɨj mɨdeb agak. Bɨ Olap Ñɨne God kɨles ne ak dɨl lum awl apɨl, tap si tap tɨmel gɨpal ak tɨg walɨg gɨyokɨnɨgab agak. Anɨb agɨl, bɨ ñɨn tob kumak anop agak, ");
INSERT INTO taw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tɨkjakɨl, mɨj nak ak wɨnɨg dad kal nad amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Anɨb agek, binɨb okok nɨg yelak nɨŋɨd, won anɨb anep tɨkjakɨl mɨj wɨnɨg dad amnak. Anɨgek nɨŋɨd, kɨli judɨl, God yɨb nop ak dad aplanɨlɨg agɨlak, Ned tap anɨb ak tek olap gel, ma nɨgɨnok agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pen Jisas tepayaŋ adɨkɨd ñɨg Galili cheb gol okok amek, binɨb kuŋay yɨbɨl nop nɨŋɨd apnan gelak, kɨlop God takaw teplep ak agñolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anɨgɨl agñɨdɨl, kanɨb nab okok amɨlɨg nɨgak, Alpiyus ñɨne Lipay, ne bɨ takis dep ak, takis delɨgɨpal kal mɨgan besɨg yek. Nop nɨŋɨd anɨb agak, Ape yad ayɨp amnul agak. Agek, Lipay tɨkjakɨl ne ayɨp amnɨlek. ");
INSERT INTO taw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pen Jisas, bɨne okok ayɨp amel, bɨ takis dep okok sek bɨ tap si tap tɨmel gɨlak okok sek kuŋay Jisas nop kɨdek gɨlak. Kɨdek gɨl Lipay kal ak amjakɨl, kɨli Jisas ayɨp bɨne okok ayɨp jɨmñɨl tap ñɨŋɨlak. ");
INSERT INTO taw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ñɨŋɨlaknɨŋ, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep bɨ Pelisi kay yelɨgɨpal ogɨnap, kɨli nɨŋɨd Jisas bɨne okok kɨlop agɨlak, Ne taynen bɨ takis dep mani si dɨpal okok ayɨp, bɨ tap si tap tɨmel gɨpal okok ayɨp jɨmñɨl tap ñɨbebal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Anɨb agel, Jisas takaw anɨb ak nɨŋɨd kɨlop agak, Binɨb suŋ mɨdobun apal okok, dokta nop ma suk apal agak. Binɨb tap gup okok nep chɨnop gel suŋ laŋ agɨl, dokta okok kɨlop suk agel opal agak. Anɨb ak tek, yad binɨb teplep mɨdebal okok kɨlop suk agɨnɨg ma opin agak. Binɨb tap si tap tɨmel gɨpal okok kɨlop suk agɨnɨg opin agak. ");
INSERT INTO taw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon Bɨ Ñɨg Pakñeb ak bɨne okok sek, bɨ Pelisi okok sek, kɨli ñɨn olap God nop agɨlɨg yonɨgun agɨl, tap ma ñɨbelɨgɨpal. Ak nɨm, binɨb ogɨnap apɨl Jisas nop agnɨŋɨd agɨlak, Jon bɨne okok sek bɨ Pelisi kay okok sek, ñɨn nokom nokom tap ma ñɨbal ak pen, bɨnak taynen anɨb ma gɨpal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Agelak, Jisas kɨlop anɨgɨl agak, Juda binɨb gɨpun adek ak, bɨ bin dɨnɨg gɨnɨgab olap, nap nɨmam okok ayɨp mɨdɨl, tap ñɨŋeb kelɨgɨnɨgabal tek akaŋ agak? Mel yɨbɨl. Bɨ anɨb ak ayɨp mɨdɨl, tep gaknɨŋ yenɨgabal ak nɨm, tap mɨdup ma kelɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pen kɨdek ñɨn olap bɨ anɨb ak, bɨ ogɨnap nop dad amel, binɨb ne okok kɨli tap ma ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pen chech ned nɨb ak talɨkek, chech kɨdeyɨl nɨb olap tɨg talɨkɨl dap ñag ma dɨpal agak. Anɨgɨpal, keke yɨbɨl lɨl, chech ak tapɨn nep pugɨlɨkek amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pen ñɨg wayn ak abe agak. Ñɨg wayn koŋɨm ak dɨl, chag meme wak mɨlep mɨgan ak ma sopal agak. Taynen? Sogɨl kɨmjen ñenɨgabal, ak tan aplanek, bɨŋ tɨmel yɨbɨl agɨl puglɨkɨl sogɨnɨgab agak. Sogek, chag meme wak ak tɨmel gɨnɨgab agak. Anɨb ak nɨŋɨd, ñɨg wayn koŋɨm ak dɨl, chag meme wak koŋɨm mɨgan ak nep sog lep agak. ");
INSERT INTO taw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kɨdek Juda añɨŋ lep ñɨn awl olap, Jisas bɨne okok ayɨp tap wit wog nab ak amnɨlak. Amɨlɨg, bɨne okok wit mɨdup anɨb okok ogɨnap tɨkak. ");
INSERT INTO taw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tɨkelak, bɨ Pelisi ogɨnap nɨŋɨd nop agɨlak, Bɨnak kɨli taynen ñɨn awl wog ma gep ñɨn ak, wit mɨdup tɨkebal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Agelak, Jisas kɨlop agak, Bɨlel bɨnak Abiyatal ne bɨ God nop sɨbogep bɨawl ak yolɨgup agak. Anɨb ñɨn ak, Depid ne bɨne okok ayɨp yuwan gek, God kal ak amjakɨlak agak. Amjakɨl, Depid God kal ak mɨgan amɨl bilet dɨl ñɨbɨl, bɨne okok kɨlop ñek ñɨŋɨlak agak. Bilet anɨb ak God wɨdɨn mɨdup adek ak lelɨgɨpal, bɨ yokɨp ma ñɨbal, bɨ God nop sɨbogep okok nep ñɨbal agak. Depid nop yuwan gek bilet dɨl ñɨŋak kesɨm anɨb ak, buk Baybol kɨl tɨkɨlak ak, nɨb ma nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Anɨb agɨl agak, God ne Juda añɨŋ lep ñɨn awl ak gɨl, chɨnop taw jɨsɨpuk gin agɨl ma gak agak. Kɨlop gɨlɨl añɨŋ lɨl mɨdtep gɨlaŋ agɨl, ñɨn awl olap yokɨp yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Anɨb ak Juda añɨŋ lep ñɨn awl apɨm ak, Bɨ Olap Ñɨne nep kod mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ñɨn olap pen, Jisas Juda apnan gɨpal kal ak amɨl yek. Kal mɨgan anɨb ak, bɨ ñɨn kumak olap ap yek. ");
INSERT INTO taw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bɨ ogɨnap Jisas nop nɨgɨlak tek, Jisas añɨŋ lep ñɨn awl chɨn anɨb ak nop gek suŋ lɨnɨgab akaŋ? Tay gek, nop ag gun agɨl nɨŋɨjsek lɨl yelak. ");
INSERT INTO taw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pen Jisas bɨ ñɨn kumak anop agak, Nad jakɨl nab sɨŋawl owan agak. ");
INSERT INTO taw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Anɨb agɨl kɨlop agnɨŋɨd agak, Añɨŋ lep ñɨn awl tek, God chɨnop tay agek anɨb ak gɨnɨgun tek lup agak. Binɨb okok kɨlop dɨtep gɨnɨgabun akaŋ, kɨlop gɨ tɨmel gɨnɨgabun agak? Akaŋ pen, kɨlop gon ma jak amnɨgel akaŋ, pakon kumnɨgel agak? Agek, nop pen takaw olap ma agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bɨ anɨb okok kɨlop nɨgek nop mapen akak. Pen gos tep ma nepal agɨl, chɨbol yul nɨgak. Anɨb ak kɨlop nɨg dad padɨkɨl, bɨ ñɨn kumak anop agak, Ñɨn ak almɨl lan agak. Agek, almɨl lek day suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Anɨgek nɨŋɨd, bɨ Pelisi okok am Helod bɨne yelak ak amɨl, takaw agnɨg agnɨg gɨl, Jisas nop anɨgɨl paklɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas pen kɨlop kelɨgɨl, bɨne okok dɨl am ñɨg Galili cheb gol sɨŋak yelak, binɨb kuŋay nep kɨdek amnɨlak. Galili plopens binɨb ogɨnap, Judiya plopens binɨb ogɨnap, ");
INSERT INTO taw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jelusalem binɨb ogɨnap, Yidumeya plopens binɨb ogɨnap, taun Taya ayɨp Saydon ayɨp binɨb ogɨnap, ñɨg Jodan pɨs kɨd adaŋ binɨb ogɨnap, ne golɨgup adek ak agel nɨgɨlak ak nɨm, nop nɨgɨnɨg owlak. ");
INSERT INTO taw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ned Jisas binɨb kuŋay nep gek suŋ lek, anɨb ak binɨb mɨñak gak okok, chɨn ap nop dɨnun suŋ laŋ agɨl owlak. Apɨl, pak pag yokɨl Jisas yɨl owlak. Pen nop dɨnɨgon chɨnop suŋ lɨnɨgab agɨl, ap tɨbɨk dɨl apelak, bɨne okok kɨlop agak, Bot olap dɨlɨtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pen binɨb kɨcheki walɨjpal abaŋ lak okok abe apel, kɨcheki walɨjpal anɨb okok Jisas nop nɨŋɨd, ap yek wulep sɨŋak apyap pakɨl, takaw awl agɨl agɨlak, Nad God Ñɨne agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisas pen kɨcheki walɨjpal okok kɨlop takaw kɨles agɨl agak, God Ñɨne agɨl ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pen Jisas dum alaŋ amɨl, bɨne dɨnɨg gak okok agek apelak, ");
INSERT INTO taw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","bɨne anep umɨgan ak kɨlop tɨg asɨk ke lɨl agak, Nɨbi bɨ takaw yɨp dad ameb okok yenɨgabɨm agak. Yad ayɨp ajɨl, agyoken am binɨb okok kɨlop agñɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nɨbop agebin ak nɨm, kɨcheki walɨjpal tap okok agyokɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jisas bɨne anep umɨgan dak anɨb okok, yɨb kɨli ak nɨm, olap Saymon, Jisas yɨb nop olap Pita agak. ");
INSERT INTO taw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Olap Jemis, nɨmam olap Jon, nap kɨli yɨb ak Sepedi. Jisas yɨb kɨlopmɨŋal Bowanelges agak. Yɨb apal anɨb ak, bɨ tɨmuk tek agelɨgɨpil. ");
INSERT INTO taw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bɨne olap Edlu. Olap Pilip. Olap Batolomyu. Olap Matyu. Olap Tomas. Olap Jemis nap ne yɨb ak Alpiyus. Olap Tadiyus. Olap Saymon, bɨ Selot agelɨgɨpal okok bɨ kɨli olap. ");
INSERT INTO taw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Olap Judas Yiskaliyot, ne nep nɨm kɨdek Jisas nop pakɨlaŋ agɨl mɨmug gak. ");
INSERT INTO taw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pen Jisas kal amek, tepayaŋ binɨb kuŋay yɨbɨl apnan gɨl yelaknɨŋ, bɨne okok ayɨp tap ñɨŋɨnɨgel tek ma lak. ");
INSERT INTO taw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Anɨgek, nɨmam ne ogɨnap takaw anɨb ak nɨŋɨd, Jisas sawl lup agɨl, nop poŋɨdɨnɨg owlak. ");
INSERT INTO taw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pen bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep Jelusalem alaŋ nɨb owlak okok agɨlak, Belsebul, kɨcheki bɨawl kɨli ak, ne bɨ anɨb ak nop mulɨk sɨkak agɨlak. Bɨ anɨb ak ne kɨcheki bɨawl ak Belsebul kɨles ak dɨl kɨcheki nop agyokeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Agelak, ne bɨ anɨb okok kɨlop agek apelak, takaw paladaŋ lɨl kɨlop agak, Satan tɨtay dɨl Satan nop agyokɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Binɨb man awl nokom olap tɨg asɨk keke lɨl penpen genɨgabal, apyap pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bɨ yɨb jɨj nokom olap tɨg asɨk keke lɨl penpen genɨgabal, apyap pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anɨb ak tek, Satan binɨb ne ak sek, kɨcheki tap ne anɨb okok sek tɨg asɨk keke lɨl penpen genɨgabal, apyap pakɨnɨgabal agak. Kɨles ne ma yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bɨ kabɨyam tɨmel olap mɨdaknɨŋ, bɨ olap kal mɨgan ne amɨl tap nop okok ma dɨnɨgab agak. Pen nag dɨl tunɨg lɨl nɨm, tap nop okok dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pen nɨbop nɨŋɨd agebin, bɨ ogɨnap Bɨawl nop agjuwenɨgabal, God nɨŋɨd gach kɨlop tɨg walɨg gɨyokɨnɨgab agak. Tap si tap tɨmel genɨgabal, God gach kɨlop tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pen God Kawnan nop ak agjuwenɨgabal, ne nɨŋɨd gach kɨlop ma tɨg walɨg gɨyokɨnɨgab agak. Mɨñɨl abe kɨdek abe, pel pelnep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Taynen? Kɨcheki ne Jisas nop mulɨk sɨkak agesɨpal ak nɨm, anɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pen Jisas nonɨm nɨmam ne yɨbɨl okok ap seŋayaŋ mɨdɨlɨg, takaw agyokɨl nop agɨlak, Nad owan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Agelak, binɨb kal mɨgan ayaŋ nop besɨg kus gɨl yelak okok agɨlak, Nanɨm namam nak okok ap seŋayaŋ mɨdɨl, Nep owan agebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Anɨb agelak Jisas kɨlop agak, Binɨb anɨb an ami mam yad agak? ");
INSERT INTO taw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anɨb agɨl, binɨb yelak okok nɨg dad padɨkɨl agak, Nɨgɨm, binɨb nɨm awl ami yad, mam yad okok nep mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Binɨb God gos ne nɨgup tek nɨŋɨd kɨdek gɨpal okok, ami, mam, ay yad okok mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas ne Galili cheb gol ak amɨl, binɨb okok kɨlop tepayaŋ takaw agñɨnɨg gaknɨŋ, binɨb kuŋay yɨbɨl apnan gɨlak. Anɨgelak, Jisas bot adek ak besɨgɨl, am ñɨg nab sɨŋak mɨdɨlɨg, kɨli ñɨg gol sɨŋak yelak okok kɨlop takaw agñak. ");
INSERT INTO taw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Takaw anɨb okok paladaŋ lɨl, adek keke yɨbɨl agñak. ");
INSERT INTO taw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Adek olap paladaŋ lɨl agak, Takaw agɨnɨgebin ak nɨgɨm agak. Bɨ olap wit jakaŋ agɨl, wit mɨdup ak nab wog day okok yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yokenɨgab, ogɨnap kanɨb nab ak yapenɨgab, yawl okok pen ap nɨŋɨd mɨdupsek ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ogɨnap kab adek lum sɨkol sɨkol lɨnɨgab okok yapɨl kasek jakɨnɨgab ak pen, ");
INSERT INTO taw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kɨdɨl palawl ma amnak tek, sub nɨŋɨd mɨlep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ogɨnap kɨkasɨk tap ñuñu adek yenɨgab nab okok yapɨl jakɨnɨgab ak pen, kɨkasɨk tap ñuñu okok pak ñɨbek mɨdup ma pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pen ogɨnap lum tep adek ak yapɨl, jak tep gɨl, mɨdup pɨl tep yɨbɨl gɨnɨgab agak. Ogɨnap mɨdup 30 tek pulɨnɨgab, ogɨnap mɨdup 60 tek pulɨnɨgab, ogɨnap 100 tek pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas takaw anɨb ak agjulɨg agak, Nɨbi binɨb tɨmud sek okok, takaw anɨb ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Binɨb Jisas takaw agaknɨŋ, ap nɨg yelak anɨb okok, keke amnɨlak. Amnɨlaknɨŋ, bɨne anep umɨgan ak sek, binɨb ogɨnap sek nop agɨlak, Takaw paladaŋ lɨl apan jɨj ak tay agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Agelak agak, God binɨb dɨl kɨlop kod yenɨgab ak, takaw we gɨl mɨdolɨgup ak nɨbop gos ñek nɨgɨnɨgabɨm agak. Binɨb yokɨp okok pen, kɨli takaw paladaŋ lɨl agak ak nɨgɨnɨgabal ak pen, takaw jɨj ak ma nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anɨb ak tek, Wɨdɨn pel nepal ak pen, tap ogɨnap ma nepal agak. Takaw pel nepal ak pen, takaw jɨj agup anɨb agɨl ma nepal agak. Nɨgtep gɨpɨlap tek, God nop agnɨgebɨlap, tap si tap tɨmel gɨpal ak tɨg walɨg gɨyokɨpɨkop agak. ");
INSERT INTO taw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas anɨb agɨl kɨlop agak, Takaw paladaŋ lɨl agen ma nepɨm anɨb ak, taydɨl kɨdek takaw paladaŋ lɨl agenɨgayn nɨgɨnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bɨ anɨb ak tap yɨŋ yɨmnɨgab ak, God takaw ne ak yɨmnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mɨdup ogɨnap kanɨb adek ak yapek, yawl okok ap ñɨŋɨnɨgabal apin ak, binɨb okok God takaw nepal ak pen, won ak Satan ap gek, sawl gɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Pen ogɨnap kab adek lum sɨkol sɨkol lɨnɨgab okok yapɨl jakɨnɨgab ak pen, kɨdɨl am wos ma gek, sub nɨŋɨd mɨlep gɨnɨgab apin ak, binɨb okok God takaw ak kɨdek won ak nɨgel tep gaknɨŋ dɨnɨgabal apin agak. Tep gaknɨŋ dɨnɨgabal ak pen, yokɨp sɨkol won olap mɨdɨl, binɨb ogɨnap takaw agel nɨŋɨd akaŋ, mɨŋel ogɨnap apek, takaw nop ak kelɨgɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pen kɨkasɨk tap ñuñu nab ak yapɨl jakɨl mɨdup ma pulɨnɨgab apin ak, binɨb okok God takaw ne nɨgɨnɨgabal ak pen, ");
INSERT INTO taw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wog wali, kal mɨj kɨneb, tu mɨnan, mani, tap okok gos kuŋay nɨŋɨd, kuŋay dun agɨl gos nɨgɨnɨgabal agɨl apin agak. Nɨgenɨgabal, God takaw ne ak pak ñɨbek tap mɨdup ne ma pulɨnɨgab agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pen wit mɨdup lum tep adek ak yapɨl jak tep gɨl, mɨdup 30 tek pulɨnɨgab akaŋ, mɨdup 60 tek pulɨnɨgab akaŋ, mɨdup 100 tek pulɨnɨgab apin ak, binɨb okok God takaw nɨŋɨd nop pɨsnep chɨgɨnɨgabal okok apin agak. Kɨli takaw ne dɨtep gɨl, mɨdup ne pulɨnɨgab apin agak. ");
INSERT INTO taw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas pen tepayaŋ takaw olap paladaŋ lɨl agak, Sup ak dagɨl, abañ muk okok akaŋ, tin muk okok ma lɨpal agak. Mɨlek gɨnɨmuŋ agɨl, adek sɨŋak tɨk lɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anɨb ak tek, tap okok mɨdupsek we gɨl mɨdeb, sayn mɨseŋ lɨnɨgab agak. Bɨ tap okok mɨdupsek we gel mɨdeb, sayn mɨseŋ lek, binɨb nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nɨbi binɨb gos tɨmud sek yenɨmɨb okok, takaw agebin awl nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pen kɨlop takaw olap agak, Takaw nɨgebɨm ak nɨŋɨd, nɨgtep gɨnɨmɨb agak. Takaw anɨb ak nɨgenɨgabɨm ak, nɨgtep gɨnɨgabɨm agak. Pen God nɨbop gos teplep yɨbɨl ñenɨgab, nɨgtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Binɨb takaw nɨŋɨd nɨg dɨnɨgabal okok, takaw tep ogɨnap sek nɨgɨnɨgabal agak. Pen binɨb takaw nɨŋɨd ma nɨg dɨnɨgabal okok, kɨli sɨkol sɨkol nepal ak sek pɨsnep kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas takaw olap pen agak, God binɨb dɨl kɨlop kod yenɨgab ak, bɨ wog nap ak wit mɨdup jakaŋ agɨl, dam wog day ne okok yokek jakɨnɨgab tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wit mɨdup wog day okok yokɨl, maynab kɨnenɨgab, subnab ajenɨgab nɨŋɨd, gup gɨl jakɨnɨgab ak pen, taydɨl jakup agɨl ma nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lum ne ke gek jakɨl, mɨdup pulɨnɨgab agak. Ned gup jakɨl, nonɨm gup kɨdek mɨdup pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pen tap mɨdup ne ñɨŋeb ñɨn ak jakek, bɨ anɨb ak ne mɨdup ñɨŋeb tek mɨdeb ak tɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas anɨb agɨl agak, God binɨb dɨl kɨlop kod yenɨgab ak, tay takaw paladaŋ lɨl agɨnɨgayn nɨbi nɨgɨnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nɨm, mab mastet yɨŋ tek ak agɨnɨm agak. Tap yɨŋ ogɨnap awl yɨbal okok jakup, pen mastet yɨŋ ak sɨkol yɨbɨl yɨbal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yɨmel, jak awl gɨl, wog nab jakup ak pen, ne tap awl yɨbɨl jakup agak. Jakɨl, lek pakek, yawl okok ap mab lek adek okok lɨ mɨdɨl, sɨsi okok we gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas binɨb okok kɨlop takaw paladaŋ lɨl anɨb okok tek kuŋay yɨbɨl agñolɨgup, gos kɨli nɨgɨnɨgel won ak tek agolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Takaw mɨseŋ agñen ma nɨgɨnɨgabal agɨl, paladaŋ lɨl nep agñolɨgup ak pen, bɨne okok ayɨp ke mɨdɨlɨg ñɨn ak, takaw jɨj okok agñɨtep golɨgup. ");
INSERT INTO taw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ñɨn anɨb anep dugep won ak, Jisas bɨne okok kɨlop agak, Kɨd adaŋ amnun agak. ");
INSERT INTO taw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Anɨb agɨl, bɨne okok ayɨp binɨb kuŋay yɨbɨl ap yelak okok kɨlop kelɨgɨl, bot Jisas yek mɨgan ak amɨl, kɨli saŋɨdɨlak. Pen bot ogɨnap abe yelak. ");
INSERT INTO taw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nab amnɨlaknɨŋ, day yɨgen awl tɨmel yɨbɨl apɨl, ñɨg cheb awl ak pagɨl bot mɨgan ak amnak. ");
INSERT INTO taw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ne pen bot mɨgan day ayɨm yɨl, kɨmɨg mab lɨl kɨnek, bɨne okok nop am kaskas gɨl agɨlak, Tisa, chɨn mɨdupsek kumnɨgobun gos ak ma nepan agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Agelak, Jisas tɨkjakɨl, yɨgen awl dek ak sek, ñɨg cheb awl ak pag apek ak sek takaw kɨles gɨl agak, Tep, kelɨgan agak. Agek kelɨgak. ");
INSERT INTO taw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pen bɨne okok kɨlop agak, Taynen pɨlɨkɨpɨm agak? God nop gos ma lɨnepɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Agek, kɨli pɨlɨkɨl, pen kɨli ke agnɨg agnɨg agɨlak, Bɨ anɨb awl an agɨlak? Taydɨl agosup yɨgen awl dek ak sek, ñɨg pag apek ak sek agup tek kelɨgup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas bɨne okok ayɨp bot mɨdɨlɨg, Galili cheb tɨkɨl, man Gelasa binɨb yelak kɨd adaŋ yɨl amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Amjakɨlaknɨŋ, Jisas bot kelɨgɨl, won anɨb ak bɨ kɨcheki mulɨk sɨkɨl olap Jisas yek ak owak, chɨp kaw dɨlak okok nɨb owak. ");
INSERT INTO taw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Bɨ anɨb ak chɨp kamelɨgɨpal kab mɨgan okok nep kɨn ajolɨgup. Nop pel nag kɨles tɨmel dɨl, ñɨn tob okok lɨ bɨlɨkelɨgɨpal ak pen, nag kɨles tɨmel anɨb okok gek pugɨlɨkek amolɨgup. Golɨgup anɨb ak, chɨn bɨ anɨb ak nop tɨtay gɨnɨgun agɨl gos nɨgɨlak. Ne kɨles tɨmel gak ak, bɨ olap nop dɨnɨmuŋ tek ma yek. ");
INSERT INTO taw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Subnab maynab ayaŋ, chɨp kaw delɨgɨpal okok sek, dum okok sek suk ag ajɨlɨg, kab dɨl wak ne okok ke tɨbolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pen ñɨn anɨb ak ne Jisas nop pal chɨm nɨŋɨd, kasek yek sɨŋak apɨl kɨgom yɨmak. ");
INSERT INTO taw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yɨmek, Jisas kɨcheki mulɨk sɨkak anop agak, Bɨ anɨb anop kelɨgɨl seŋ amnoŋ agak. Agek kɨcheki suk awl agɨl agak, Jisas. God bɨawl adek alaŋ Ñɨne agak. Yɨp tay gɨnɨg opan agak? Nep kɨles gɨl agnɨgebin, yɨp gɨ tɨmel ma gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Anɨb agek, Jisas nop agak, Yɨb nad tay agak? Agek agak, Kɨcheki kuŋay yɨbɨl mulɨk sɨkɨl tek ak, yɨb yad Kuŋay Yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pen ne Jisas nop agak, Kɨcheki okok kɨlop palawl okok ma agyokɨnɨmɨn agak. Anɨb agɨl, agnɨgɨlɨg yɨbɨl yek. ");
INSERT INTO taw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pen won anɨb ak, chag kuŋay yɨbɨl amɨl ñɨbelak pɨl sɨŋak ak nɨm, ");
INSERT INTO taw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kɨcheki okok Jisas nop agnɨgɨlɨg yɨbɨl agɨlak, Chɨnop age, am chag oklaŋ kɨlop mulɨk sɨkun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Anɨb agel, kɨcheki okok agyokek, bɨ anɨb mulɨk sɨkak ak nop kelɨgɨlak. Kelɨgɨl, am chag okok kɨlop mulɨk sɨkel, pɨgju mɨduŋ ayaŋ amɨl, gɨ dam ñɨg ayaŋ pakɨl, ñɨg ñɨbɨl mɨdupsek kum dɨlak. Chag anɨb okok, 2,000 tek yelak. ");
INSERT INTO taw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pen bɨ chag mukep okok, am taun okok, man yokɨp okok takaw anɨb ak agñelak, binɨb okok am nɨgun agɨl owlak. ");
INSERT INTO taw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jisas yek ak apɨl nɨgɨlak, bɨ kɨcheki kuŋay yɨbɨl mulɨk sɨkɨl yolɨgup anɨb ak, chech yɨmɨl gos nop pag yɨkɨl besɨgek, kɨlop jel gak. ");
INSERT INTO taw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bɨ chag mukep okok ned yelak okok, kɨli binɨb kɨdek owlak okok kɨlop Jisas tɨtay gak ak agñɨlak. Tap nɨm akal tek bɨ anɨb mulɨk sɨkak ak nop gak, chag okok kɨlop tɨtay gak ak abe agñelak nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jisas nop agnɨgɨlɨg yɨbɨl agɨlak, Man chɨnop awl kelɨgɨl amnoŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Agelak, Jisas bot dɨl amnɨg gaknɨŋ, bɨ gek suŋ lak ak kɨles gɨl agnɨgɨlɨg agak, Yad ayɨp amnɨgul akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Agek agak, Mel. Kal nak amɨl, binɨb nak okok kɨlop, God nep chɨb nɨŋɨd tɨtay gup takaw ak, agñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Agek, bɨ anɨb ak man Dekapolis gɨ ajɨlɨg, Jisas nop tɨtay gak ak, binɨb okok kɨlop agñek nɨŋɨd, mɨdupsek gos pal lɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas pen bot dɨl, tepayaŋ adɨkɨd Galili cheb pɨs gol adaŋ yɨl am mɨdaknɨŋ, binɨb kuŋay yɨbɨl apnan gɨlak. Pen Jisas ñɨg gol sɨŋak yek. ");
INSERT INTO taw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Anɨgɨl yek, bɨ olap owak, yɨb ne Jaylus. Ne Juda apnan gɨpal kal ak bɨawl kod yolɨgup. Apɨl Jisas nop nɨŋɨd, ap yek sɨŋak kɨgom yɨmɨl, ");
INSERT INTO taw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kɨles tɨmel gɨl agnɨŋɨd agak, Pay sɨkol yad ak kumnɨgeb agak. Nad ap nop dɨnɨge, jak amnaŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Agek, Jisas tɨkjakɨl Jaylus ayɨp amnɨleknɨŋ, binɨb kuŋay yɨbɨl amɨl Jisas nop chɨchɨlok ñɨlɨg amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pen bin olap, bin kanɨb padɨkaknɨŋ yek, sap yeb anep umɨgan amnak. ");
INSERT INTO taw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bin anɨb ak dokta okok kɨlop, yɨp gel suŋ laŋ agɨl, mani tawolɨgup ak pen, nop gel suŋ ma lek, nop tap awl yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Pen ne Jisas golɨgup takaw ak agel nɨgak tek, am chech bad nop ak nep dɨnɨgen suŋ lɨnɨgab agɨl nɨgak. Nɨgek, binɨb kuŋay yelak nab ak, yek kud okok yɨl apɨl, chech nop ak dɨnɨgek, ");
INSERT INTO taw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","won anɨb ak nop suŋ lak. Nab ne ayaŋ ke nɨgak nop suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pen Jisas kɨles ne ogɨnap amnak nɨŋɨd, tɨg adɨkɨl binɨb okok kɨlop agak, Chech yɨp ak an dɨnɨgup agak? ");
INSERT INTO taw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Agek, bɨne okok agɨlak, Binɨb kuŋay yɨbɨl nep chɨchɨlok ñɨbal ak, taynen yɨp an dɨnɨgup agɨl ageban agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Anɨb agel, Jisas takaw kɨlop agɨlak ak ma dɨl, an dɨnɨgup agɨl pɨyow nɨg yek. ");
INSERT INTO taw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pen bin anɨb ak, nop tɨtay dak ak nɨŋɨd, pɨlɨkɨl jep dɨl, ap Jisas yek sɨŋak kɨgom yɨmɨl, nop suŋ lak takaw ak mɨseŋ agñak. ");
INSERT INTO taw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas pen agak, Pay yad, nad gos sek yenɨmɨn agak. Yɨp gos gos lɨnepan tek, nep gek suŋ lup nen, amɨl mɨdtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas takaw anɨb ak agaknɨŋ, Juda apnan gɨpal kal bɨawl ak Jaylus, bɨne ogɨnap kal ne nɨb apɨl agɨlak, Pay nak pɨsnep kumub agɨlak. Tisa nop age tob yul ma ownɨmuŋ agɨlak. Age adɨkɨd amnɨmuŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Anɨb agɨlak ak pen, Jisas takaw kɨlop ak ma dɨl, Jaylus nop agak, Ma pɨlɨkɨnɨmɨn, yɨp gos lɨnɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pen binɨb okok kɨlop, anɨb okok aglɨl, Pita ak, Jemis ak, Jemis nɨmam Jon ak kɨlop nep poŋɨd amnak. ");
INSERT INTO taw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Juda apnan gɨpal kal bɨawl ak Jaylus, kal nop ak amjakɨl Jisas ne nɨgak, binɨb takaw pug agɨlɨg chaŋ awl lɨlɨg gɨ yelak. ");
INSERT INTO taw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nɨŋɨd, kal mɨgan ayaŋ amɨl agak, Taynen takaw pug agɨlɨg chaŋ lɨlɨg gebɨm agak? Pay ak ma kumub, yokɨp wɨsɨn kɨneb agak. ");
INSERT INTO taw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Anɨb agek, nop yɨmel agelak, kɨlop ag seŋ yokɨl, pay nonɨm nap bel ak dɨl, bɨne omɨŋal nokom ak dɨl, poŋɨd pay ak kal ñɨluk mɨgan dɨlel yek ayaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amɨl, ñɨn kɨd nop ak dɨl agak, Talida kowum agak. Takaw agak jɨj anɨb ak nɨm, Pay sɨkol. Nep agebin, tɨkjakan agak. ");
INSERT INTO taw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Agek, pay kasek tɨkjakɨl aplan apyan gaknɨŋ, kɨli nɨŋɨd ju dɨl wal awl yɨbɨl agɨlak. Pay anɨb ak, sub ne anep umɨgan amnak. ");
INSERT INTO taw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pen kɨli anɨgelak, Jisas takaw kɨles agɨl agak, Gɨpin anɨb ak binɨb okok kɨlop mɨseŋ ma agñɨnɨmɨb agak. Anɨb agɨl agak, Pay anop tap mɨdup ogɨnap ñem ñɨŋaŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas bɨne okok poŋɨd man anɨb ak kelɨgɨl, man ne Nasalet amnak. ");
INSERT INTO taw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Am mɨdɨl Juda añɨŋ lep ñɨn awl ak apek, Juda apnan gɨpal kal ak amɨl, binɨb kuŋay ap yelak okok kɨlop takaw agñak. Agñaknɨŋ, nɨŋɨd ju dɨl wal agɨl agɨlak, Takaw anɨb ak akal nɨb nɨŋɨd anɨb agup agɨlak? Gos teplep akal nɨb nɨgup, tɨtay gɨl dup agɨlak? Tap mageptek taydɨl gup agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bɨ anɨb awl kapeda man awl nɨb nep, Maliya ñɨne olap agɨlak. Nɨmam ne Jemis, Josep, Judas, Saymon sek, nɨnay ne okok sek ayɨp mɨdobun awl agɨlak. Anɨb agɨl, nop gos tɨmel nɨŋɨd ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pen Jisas kɨlop agak, Bɨ God gos ñek agñeb ak, man wakay ogɨnap gɨ ajek, bɨawl chɨn agɨl dɨpal ak pen, man ne ke ak, kal ne ke ak, nɨmam ne ogɨnap mɨdel, yɨb ma yek takaw nop ak ma dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nop gos ma nɨgɨlak anɨb ak, tap mageptek ogɨnap gɨnɨmuŋ tek ma lak. Binɨb tap gak ogɨnap nep pen dɨnɨgek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pen Nasalet binɨb nop, God Ñɨne yɨbɨl agɨl gos ak ma nɨgelak, ne gos pal yɨbɨl lak. Jisas pen kal man anɨb okok ajɨlɨg, binɨb okok kɨlop God takaw ak agñak. ");
INSERT INTO taw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pen ñɨn olap bɨne anep umɨgan ak suk agek apel agak, Bɨ omɨŋal ak ke, bɨ omɨŋal ak ke man okok keke amnɨmɨb agak. Yad nɨbop agyoken, kɨles yad ak dɨl kɨcheki walɨjpal tap okok ag seŋ yokɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Takaw olap pen agak, Amnɨg, tap ñɨŋeb, mani, wad sɨkol, tap okok dad ma amnɨmɨb agak. Yɨl kodɨm anep dad amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tob tɨlup lɨl amnɨmɨb ak pen, chech nokom olap nep lɨl amnɨmɨb, ogɨnap sek dad ma amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kal olap amem nɨbop ag denɨgel, kal anɨb anep mɨdɨl, amnɨg gɨnɨmɨb ñɨn anep amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pen man olap amjakem nɨbop ma ag dɨl, takaw nɨbop ak ma nɨgenɨgel, man anɨb ak kelɨg amnɨg kɨlop agɨnɨmɨb, Takaw tep ak dad opun ma dɨpɨm tek, man nɨbop awl apon sɨlkul dayday tob chɨnop dup ak wik yokɨl amobun agɨnɨmɨb agak. Anɨb agɨl, wik yokɨl amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas anɨb agek, kɨli man sɨkol keke amɨl, binɨb okok kɨlop takaw agñɨlɨg agɨlak, Tap si tap tɨmel gɨpɨm okok, God nop taynen anɨgɨpun agɨl, kelɨgɨnɨmɨb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Anɨb agɨl, binɨb kɨcheki walɨjpal mulɨk sɨkɨl yek okok, kɨcheki walɨjpal ag seŋ yokɨl, binɨb tap gak okok wel ñɨg lɨñel jak amelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pen Jisas gak tek, takaw ak man okok kɨd kɨd amek, gapman bɨnonɨm Helod abe nɨgak. Binɨb okok, takaw anɨb ak ag amɨl apɨl gɨlɨg, ogɨnap agɨlak, Jon Bɨ Ñɨg Pakñeb kumek kamɨlak ak, tep tɨkjakɨl nɨm, ap tap mageptek anɨb okok geb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ogɨnap pen agɨlak, Bɨ anɨb ak bɨnak Yilayja agɨlak. Ogɨnap agɨlak, Bɨ God gos ñek agñeb bɨlel yelɨgɨpal tek olap ap mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pen gapman bɨnonɨm Helod ne nɨŋɨd anɨb agak, Ak Jon Bɨ Ñɨg Pakñeb ned kuŋam tɨbɨlɨkɨnek anep tɨkjakɨl, ap anɨgeb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Taynen anɨb agak? Ned Helod nɨmam Pilip bin ne Helodiyas nop si dak. Dek, Jon ne Helod nop agak, Nad namam olap bin ak dɨpan, ak teplep ma mɨdeb agak. Agek, bin Helodiyas Jon nop mɨlɨk nɨŋɨd agek, Helod bɨne ogɨnap agyokek, am Jon nop dad apɨl, nag lɨlak. Bin Helodiyas, Jon nop paklin agɨl gos nɨgak ak pen, ñagɨlɨnɨmuŋ tek ma yek. ");
INSERT INTO taw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jon bɨ teplep yɨbɨl mɨdɨl, suŋtep yɨbɨl yolɨgup. Anɨgek, Helod ne Jon nop nɨŋɨd pɨlɨkak. Anɨb ak tek, Helod ne Jon nop kod mɨdtep gɨl, bin Helodiyas nop yaw agɨnɨmuŋ tek ma lak. Jon takaw ne tɨtay agek Helod nɨŋɨd, gos pal awl yɨbɨl lɨl, gos mɨŋel lak. Pen yad takaw nop ak nɨgin agak. ");
INSERT INTO taw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bin Helodiyas pen Jon nop taydɨl paklɨnɨm agɨl, pel gos anɨb ak nɨg yolɨgup. Mɨd mɨd mɨnek olap, Helod nonɨm nop tɨkak ñɨn ak apek, tap awl ñɨŋɨnɨg, gapman bɨawl okok, bɨ chɨm kadɨŋ gep bɨawl okok, bɨawl Galili plopens nɨb okok suk agek, tap awl ñɨŋɨnɨg owlak. ");
INSERT INTO taw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ap tap ñɨŋɨlaknɨŋ, Helodiyas payne ap kɨgom pagɨl mɨñmɨñ gek, bɨawl ap yelak okok sek, Helod sek nɨgel kɨlop tep gak. Gek, Helod pay anɨb anop agak, Gɨpan anɨb ak tap tay agnɨge nep ñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pen takaw kɨles tɨmel yaw agɨl agak, Nɨŋɨd yɨbɨl agebin, tap nɨm akal gos nɨŋɨd yɨp agnɨge, nep ñɨnɨgayn agak. Man awl kod mɨdebin ak gos nepan yɨp agenɨmɨn, nɨm ak nab awl tɨbɨlɨkɨl nep wakay olap agen, day ak nad dɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Anɨb agek, pay ak am nonɨm Helodiyas nop tap tay ak agnɨgɨnɨm agek agak, Jon Bɨ Ñɨg Pakñeb kɨmɨg won nop ak agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Agek, payne kasek gapman bɨnonɨm Helod yek ak amɨl agak, Yep won awl nep, Jon Bɨ Ñɨg Pakñeb kuŋam ak tɨbɨlɨkɨl, kɨmɨg won nop ak dɨl kɨnag mɨgan lɨl, dap yɨp ñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Anɨb agek, gapman bɨnonɨm Helod Jon nop nɨgek chɨb tɨmel gak ak pen, ne bɨawl okok nɨg yelaknɨŋ, pay anop tap tay yɨp agnɨge ñɨnɨgayn agak tek nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","won anɨb ak nep bɨ chɨm kadɨŋ gep ne olap agyokak. Agyokek, am Jon nag lɨlak mɨgan yek ak nop kɨmɨg won ak tɨbɨlɨkak. ");
INSERT INTO taw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tɨbɨlɨkɨl, dɨl kɨnag mɨgan lɨl dad owak. Apɨl, pay anɨb anop ñek, ne dad amɨl, nonɨm nop ñak. ");
INSERT INTO taw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pen Jon bɨne okok, nop kuŋam tɨbɨlɨkɨpal ak agel nɨŋɨd, am chɨp dad apɨl, kaw mɨgan ak kaw dɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pen Jisas bɨ takaw nop dad ameb okok adɨkɨd apnan gɨl, binɨb okok kɨlop takaw agñɨlɨg tɨtay gɨlak okok, Jisas nop agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pen binɨb kuŋay yɨbɨl nep amɨl apɨl gelak, Jisas bɨne anɨb okok ayɨp tap ñɨŋɨnɨgel tek ma lek, kɨlop agak, Chɨn binɨb ma mɨdebal nab okok amɨl, añɨŋ lɨl yokɨp yonɨgun agak. ");
INSERT INTO taw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Anɨb agɨl, bɨne okok ayɨp bot dɨl amnɨlak, man binɨb ma yelak nab okok. ");
INSERT INTO taw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amnɨlaknɨŋ, binɨb man awl anɨb okok Jisas ameb agɨl, ñɨg gol adek kanɨb pal ak kasek ned amɨl, Jisas bɨne okok ayɨp amnɨg gelak okok, ned am yelak. ");
INSERT INTO taw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas amjakɨl bot ak kelɨgɨl nɨgak, binɨb okok kuŋay yɨbɨl yelak. Kɨli chag sipsip okok bɨ mukep kɨli olap ma mɨdeb tek ak yelak. Anɨb ak nɨgek chɨb gek, kɨlop takaw ogɨnap tapɨn agñɨ yek. ");
INSERT INTO taw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sub saŋɨd amnaknɨŋ, bɨne okok apɨl nop agɨlak, Sub saŋɨd amnɨgeb agɨlak. Okol man nep nab okok nen, ");
INSERT INTO taw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","binɨb okok agyoke, man kal yep wulep okol sek, man awl okol sek amɨl, tap mɨdup kɨli ogɨnap taw ñɨŋɨlaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Agelak agak, Nɨbi ke kɨlop tap mɨdup ñɨnɨmɨb agak. Agek agɨlak, Anɨb apan ak, chɨn kab mɨdup 200 dad amɨl, tap mɨdup taw dad apɨl kɨlop ñɨnɨgun akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Agel, Jisas agak, Bilet nɨbi tɨtay mɨdeb am nɨgɨm agak? Agek am nɨŋɨd apɨl agɨlak, Bilet anep mamɨd ak, kubsal omɨŋal sek mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Anɨb agelak agak, Binɨb okok agem, asɨk keke apnan gɨl, asɨŋap wɨj adek okok besɨg yelaŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Agek, kɨlop agelak, ogɨnap 50 tek apnan gɨl, ogɨnap 100 tek apnan gɨl besɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pen Jisas bilet anep mamɨd ak sek, kubsal omɨŋal ak sek dɨl, kɨlan gɨl nɨŋɨd, God nop tep agɨl, bilet ak tɨpag bɨne okok kɨlop ñek, kɨli binɨb okok kɨlop bɨlok ñɨlak. Kubsal omɨŋal ak abe ñek, binɨb okok kɨlop bɨlok ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ñelak, ñɨb gel gel kogmeg gak. ");
INSERT INTO taw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tap dayday kelɨgɨlak okok, Jisas bɨne okok wad dɨl yɨg gel gel, wad anep umɨgan ak aplan jakak. ");
INSERT INTO taw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tap ñɨŋɨlak ñɨn anɨb ak, bɨ okok nep nɨm 5,000 amnak. ");
INSERT INTO taw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Won anɨb ak, Jisas bɨne okok kɨlop ned taun Betsayda kɨd adaŋ amnɨlaŋ agɨl, kasek agek bot dɨl saŋɨdɨlak. Saŋɨdɨlaknɨŋ, binɨb okok kɨlop agek nop kelɨgɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Agyokɨl, ne dum olap amɨl, God nop agɨnɨg amnak. ");
INSERT INTO taw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kɨsɨlɨm ownɨg gak won ak, Jisas ne nokom ñɨg gol am yek, bɨne okok bot dɨl ñɨg cheb nab sɨŋadaŋ yelak. ");
INSERT INTO taw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pen Jisas nɨgak, yɨgen ak amelak okok yɨl apek, koslam ñɨg wɨj pal lɨglɨg amnɨlak. Man tɨkɨnɨg gak won ak, ne ñɨg wɨj adek ak amɨl, kɨlop tawsak lɨl am nɨgak ak pen, ");
INSERT INTO taw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nop nɨgɨlak, Eŋ chɨp kawnan agɨl, suk awl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kɨli mɨdupsek nɨŋɨd anɨgɨl gos pal lɨl pɨlɨkelak, won anɨb ak Jisas kɨlop agak, Gos sek yenɨmɨb agak. Yad nep apebin, ma pɨlɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Agɨl, bot mɨgan amɨl kɨli ayɨp yek, yɨgen dek ak kelɨgak. Anɨgek, taydɨl anɨgup agɨl, gos kuŋay yɨbɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bilet dɨl binɨb kuŋay yɨbɨl bɨlok ñak ak nɨgɨlak ak pen, chɨbol kɨlop ak ma asɨkup tek, gos kɨlop pak ñɨŋak. ");
INSERT INTO taw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pen ñɨg nab ak am am man Genesaled amjakɨl, bot ak tunɨg lɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bot ak kelɨg amnɨlaknɨŋ, binɨb anɨb okok Jisas owup agel nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kasek man kɨd kɨd amɨl, binɨb tap gak okok kɨlop yɨl lɨl Jisas am yek okok dad amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ñɨn anɨb okok Jisas man sɨkol okok akaŋ, taun okok akaŋ, man yokɨp okok amjakek, binɨb tap gak okok kɨlop dap binbɨ apnan gɨpal nab ak lɨlak. Lɨl, kɨles agɨl agɨlak, Nad mɨde binɨb tap gup okok, chech day nep okok dɨnɨgɨlaŋ agɨlak. Anɨb agelak, ne takaw kɨlop ak dɨl nɨg yeknɨŋ, binɨb nop dɨnɨgɨlak okok suŋ lak. ");
INSERT INTO taw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bɨ Pelisi ogɨnap, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap, kɨli Jelusalem nɨb Jisas yɨl apɨl ");
INSERT INTO taw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","nɨgɨlak, Jisas bɨne ogɨnap tap ñɨŋɨnɨg ñɨn kɨli ma ñɨg lɨlak ak nɨm, nupɨs nɨsed sɨkop asɨk tep gɨl, tap ñɨbelɨgɨpal tek ma gɨlak. ");
INSERT INTO taw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pelisi binɨb okok dɨl, Juda binɨb okok mɨdupsek, nap nɨsed sɨkop agelɨgɨpal tek nɨŋɨd, monmon ma gɨl, ñɨn ñɨg lɨ yok lɨl tap ñɨbal. ");
INSERT INTO taw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kɨli maket amɨl nab sɨŋak mɨdɨl adɨkɨd amɨl, abe ñɨn ñɨg lɨ yok lɨl tap ñɨbal. Gos kɨli pal ogɨnap nupɨs nɨsed gos nɨgelɨpal pal abe nepal anɨb ak tek, tin, kɨnag, kap tap okok abe ñɨg lɨ yokɨl lɨpal. ");
INSERT INTO taw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anɨb ak Jisas bɨne okok yokɨp ñɨŋɨlak anɨb ak nɨŋɨd, bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek nop agɨlak, Bɨ nad okok taynen bapi based sɨkop agɨlak tek ma gɨpal agɨlak? Ñɨn kɨli ñɨg ma lɨl tap ñɨbebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Agelak, Jisas agak, Bɨ God gos ñek agñeb Aysaya, ne nɨbi bɨ takaw yepɨs apɨm okok nɨŋɨd yɨbɨl agɨl, buk Baybol ak kɨl tɨkɨl agak, God agup, Binɨb ogɨnap God Bɨawl chɨn, God Bɨawl chɨn apal ak pen, kɨli yokɨp takaw anep apal agup agɨl tɨkak agak. Yɨp gos ma yɨbɨl nepal agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kɨli yɨb yɨp dad aplanɨbal ak pen, bɨ takaw anep agñɨbal ak, agñɨl apal, Nɨm ak God takaw ne apal agup agɨl tɨkak agak. Anɨb ak, yɨb yɨp yepɨs dad aplanɨbal agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nɨbi God takaw ne ak kelɨgɨl, binɨb takaw apal ak dun agɨl, nap nased sɨkop agelɨgɨpal adek ak kɨdek gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisas kɨlop tepayaŋ agɨl agak, Nɨbi takaw nɨbi ke anep nɨŋɨd apɨm anɨb ak, God takaw agup ak kelɨgɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosis takaw olap kɨl tɨkɨl agak, Nanɨm nap takaw agɨnɨmil tek nɨŋɨd, kɨlop dɨtep gɨnɨmɨb agak. Pen ñɨpay ogɨnap nonɨm nap kɨlop takaw tɨmel agenɨgel, paklem kumnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nɨbi pen taynen takaw anɨb ak tek ma agñɨbɨm agak. Nɨbi anɨgɨl apɨm, Bɨ olap nonɨm nap tap kɨlop ñɨbɨkop tek ak, kɨlop pen agup, Tap anɨb ak God nop ñin agɨl aglɨpin agup, ");
INSERT INTO taw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bɨ anɨb ak ne nonɨm nap tap ma gɨñonɨmuŋ apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gɨpɨm anɨb ak, God takaw ne ak kelɨgɨl, nap nased sɨkop gelɨgɨpal adek ak nep gem amub agak. Nɨbi tap anɨb ak kuŋay nep gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas anɨb agɨl, binɨb okok kɨlop agek yek jɨj sɨŋak apel agak, Takaw agɨnɨgebin ak nɨbi nɨŋɨd, nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tap ñɨbel nab ayaŋ amnɨgab ak gach ma yenɨgab agak. Nab ayaŋ nɨb seŋ ownɨgab anep nɨm, gach yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas anɨb agɨl, binɨb okok kɨlop kelɨgɨl kal mɨgan amek, bɨne okok nop agɨlak, Takaw paladaŋ lɨl apan anɨb ak, jɨj ne ak tay agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Agel agak, Kɨli ma nepal tek, nɨbi abe ma nepɨm akaŋ agak? Tap ñɨŋeb mɨdupsek okok, monmon ñɨbel kogmeg nab ayaŋ amek, God nɨgek gach ma yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Taynen? Tap ñɨbal anɨb okok, gos kɨli nab ayaŋ ma amnɨgab agak. Kogmeg nab ayaŋ yɨbɨl amek, chɨb sek kɨl yokɨnɨgabal agak. Jisas takaw agak anɨb ak, tap okok mɨdupsek ñɨŋeb nep, asɨkep ogɨnap ma mɨdeb. ");
INSERT INTO taw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pen Jisas agak, Gos tɨmel nab kɨlop ayaŋ nɨb apek nɨm, tɨmel gel God nɨgek gach yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Binɨb okok nab kɨlop ayaŋ gos tɨmel owaknɨŋ, gɨ tɨmel gɨl, tap si dɨl, chɨp ñagɨl, bin si bɨ si gɨl, ");
INSERT INTO taw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tap chɨn ke kuŋay yɨbɨl dun agɨl gos nɨŋɨd, gɨ tɨmel yɨbɨl gɨl, takaw yepɨs agɨl, gos kɨli ke nɨŋɨd, tap okok yɨp tek yobɨkop agɨl, mɨlɨk nɨŋɨd binɨb agjuwɨl, monmon gɨl, yɨb ke dad aplanɨl tɨmel gep gos nokom nɨŋɨd gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tap tɨmel gɨpal anɨb okok, ke okok nɨb ma owup, gos tɨmel ak nab kɨli ayaŋ nɨb apek gɨ tɨmel gɨpal nɨm, God nɨgek gach mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas Galili plopens kelɨgɨl, am taun Taya wulep okok amnak. Amɨl, binɨb okok ayɨp mɨñɨl ma nɨgɨnɨgel agɨl, kal mɨgan olap am we gɨl yek ak pen, we gɨl yonɨmuŋ tek ma lak. ");
INSERT INTO taw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bin olap pen, payne nop kɨcheki abaŋ lak ak nɨm, Jisas owup agel nɨŋɨd, kasek am yek sɨŋak apyap pakɨl, ");
INSERT INTO taw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","takaw kɨles tɨmel agɨl agak, Pay yɨp kɨcheki abaŋ lup ak, ge seŋ amnaŋ agak. Bin anɨb ak ne Juda mel olap. Nop tɨkɨlak Siliya plopens, taun ne nɨm Ponisiya. ");
INSERT INTO taw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pen anɨb agek, Jisas nop agak, Chɨn ned tap mɨdup ñapay kɨlop ñɨnɨgun agak. Tap mɨdup ñapay chɨn okok ñeb ak dɨl chen mukon, tɨmel gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Agek, bin ak pen agak, Bɨawl. Ak tep apan ak pen, ñapay okok tap ñɨbel, dayday okok nep abañ muk okok yapek, chen okok ñɨbal sek agak. ");
INSERT INTO taw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Agek, Jisas takaw anɨb ak nɨŋɨd agak, Nad anɨb apan ak, pay nad kɨcheki mulɨk sɨkɨl mɨdeb ak, gesɨpin seŋ amub nen amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Agek, adɨkɨd amɨl nɨgak, kɨcheki kelɨg seŋ amek, payne mɨj adek ak kɨmɨgel kɨn yek. ");
INSERT INTO taw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas taun Taya anɨb ak kelɨgɨl, am taun Saydon amɨl, man Dekapolis nab okok amɨl, Galili cheb amnak. ");
INSERT INTO taw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Am jakaknɨŋ, binɨb okok bɨ tɨmud pɨl gɨl takaw agtep ma golɨgup olap dad apɨl, Jisas nop agɨlak, Bɨ anɨb awl nop dɨnɨge suŋ laŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Agelak, Jisas bɨ anɨb anop poŋɨd keke sɨŋak amɨl, ñɨn mɨdup pal ak tɨmud mɨgan nop omɨŋal ak yokɨl, ñɨn mɨdup kɨñuk gɨl yalɨb nop ak dɨnɨgɨlɨg, ");
INSERT INTO taw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kɨlan gɨl God man ne alaŋ nɨŋɨd, mɨŋel gek añɨŋ pogɨl agak, Epata agak. Epata agak takaw jɨj anɨb ak Pag yɨkan agak. ");
INSERT INTO taw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Anɨb agaknɨŋ, bɨ anɨb ak tɨmud mɨgan ak pag yɨkɨl, yalɨb nop gek suŋ laknɨŋ, takaw teplep yɨpɨd gɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Anɨgek, Jisas kɨlop takaw anɨb ak binɨb okok ma agñɨnɨmɨb agak ak pen, kɨli amɨl binɨb kuŋay yɨbɨl agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Takaw anɨb ak agñel nɨŋɨd, gos pal awl lɨl agɨlak, Jisas tap okok mɨdupsek gup okok, tap teplep ak nep agɨlak. Binɨb tɨmud pɨl gup okok gek nɨgtep gɨpal, binɨb yalɨb mɨŋel gup okok gek, takaw agtep gɨpal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ñɨn nab anɨb sɨŋak nep binɨb kuŋay yɨbɨl ap mɨdel, tap mɨdup ma yek, Jisas bɨne okok suk agek apel agak, ");
INSERT INTO taw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yad binɨb okol kɨlop chɨb nɨgebin agak. Ñɨn omɨŋal nokom yad ayɨp mɨdɨl, mɨñɨl yokɨp mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kɨlop yuwan gek agyoken, ogɨnap palawl okok nɨb opal tek, kanɨb nab okok amɨl, wɨdɨn mayn apek apyap pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Agek, bɨne okok agɨlak, Man nep nab okol, bɨ olap tap mɨdup akal nɨb dɨl kɨlop ñɨnɨmuŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Agel, Jisas agak, Bilet nɨbi tɨtay mɨdeb agak? Agek agɨlak, Anep kugul ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Anɨb agel, Jisas binɨb okok kɨlop agek besɨgɨlak. Besɨgel, bilet anep kugul anɨb ak dɨl, God nop tep agɨl, tɨpagɨl bɨne okok kɨlop ñek, kɨli dɨlɨg binɨb okok kɨlop bɨlok ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kubsal sɨkol ogɨnap sek yek ak ñel, God nop tep agɨl kɨlop agek, kɨli bɨlok ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ñel, ñɨbel ñɨbel kɨlop pug agak. Ñɨbdɨl, Jisas bɨne okok kɨli dayday yek okok yɨgel yɨgel aplan jakek, wad anep kugul ak yɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Binɨb anɨb okok mɨdupsek tap ñɨŋɨlak ak pen, bin okok sek ñapay sɨkol okok sek mel, bɨ okok nep nɨm, 4,000 tek amnak. Pen Jisas binɨb anɨb okok kɨlop agyokɨl, ");
INSERT INTO taw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bɨne okok ayɨp bot dɨl, man Dalmanuda amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bɨ Pelisi ogɨnap Jisas nop nebneb gon ne tay gɨnɨgab agɨl, ap ne ayɨp takaw ag am ap gɨl agɨlak, Tap mageptek olap God man ne alaŋ nɨb ge, chɨn nɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Anɨb agel, Jisas mɨŋel gek añɨŋ pogɨl agak, Binɨb mɨñɨl mɨdebal ñɨn awl, taynen apal, Tap olap ke ge nɨgun apal agak? Yad nɨbop nɨŋɨd yɨbɨl agebin, Tap olap ke gen ma nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anɨb agɨl, kɨlop kelɨgɨl, ñɨg tɨkɨl kɨd adaŋ amnɨg, bot dɨl saŋɨdak. ");
INSERT INTO taw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pen bɨne okok sawl gɨl, bilet kuŋay mel. Nokom olap bot mɨgan dad amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nab okok amɨlɨg, Jisas kɨlop agak, Nɨbi nɨgtep gɨnɨmɨb agak. Pelisi yis kɨli ak sek, Helod yis ne ak sek ma dɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Anɨb agek, bɨne okok kɨli ke agnɨg agnɨg gɨl agɨlak, Bilet ogɨnap sek ma dopun tek agosup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas pen, kɨli agɨlak anɨb ak ke nɨŋɨd agak, Taynen bilet dad ma opun agɨl agebɨm agak? Nɨbop gos tep ma lak ak nɨm, nɨgtep ma gɨpɨm akaŋ agak? Chɨbol nɨbop ak ma asɨkup akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wɨdɨn lak ak ma nepɨm? Pen tɨmud lak ak ma nepɨm? Akaŋ nɨŋɨd sawl gɨpɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bɨ 5,000 yelak ñɨn ak, bilet anep mamɨd ak dɨ tɨpag ñenek, ñɨbɨl dayday kelɨgɨlak okok, wad tɨtay yɨgɨpek agak. Agek agɨlak, Wad anep umɨgan ak yɨgɨnok agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Anɨb agelak agak, Pen bɨ 4,000 yelak ñɨn ak, bilet anep kugul ak dɨ tɨpag ñenek, ñɨbɨl dayday kelɨgɨlak okok, wad tɨtay yɨgɨpek agak? Agek agɨlak, Wad anep kugul ak yɨgɨnok agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Agel agak, Pen nɨbi gos anɨb ak nɨgtep ma gɨpɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pen kɨli taun Betsayda amjakel, binɨb ogɨnap bɨ wɨdɨn koy gak olap dad apɨl, Jisas nop takaw kɨles gɨl agnɨŋɨd agɨlak, Nop dɨnɨgan agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Agelak, Jisas bɨ wɨdɨn koy anɨb anop ñɨn kɨd ak dɨl, poŋɨd gol okok amɨl, wɨdɨn nop ak kɨñuk gɨñɨl, nop dɨnɨŋɨd agak, Tap ogɨnap nɨgeban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Agek alad gɨl nɨŋɨd anɨb agak, Yaw. Binɨb okok nɨgebin ak pen, mab tek okok mɨdɨl, gɨ ajebal agak. ");
INSERT INTO taw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agek, Jisas tepayaŋ wɨdɨn mɨdup nop ak dɨnɨgek, wɨdɨn nop yɨkek, day tap okok mɨdupsek nɨg kɨd agak. ");
INSERT INTO taw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pen Jisas bɨ anɨb anop agak, Tep ak adɨkɨd binɨb mɨdebal adaŋ ma amnɨmɨn agak. Kal nak yɨpɨd gɨl amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas bɨne okok ayɨp taun Sisaliya Pilipay gol okok amnɨg saŋɨdɨlak. Kanɨb nab okok amɨlɨg kɨlop agak, Binɨb okok, yɨp an agɨl nepal agak? ");
INSERT INTO taw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Agek agɨlak, Binɨb ogɨnap nep Jon Bɨ Ñɨg Pakñeb ak apal agɨlak. Ogɨnap Yilayja apal, ogɨnap bɨ God gos ñek agñeb olap apal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Agelak, Jisas bɨne okok kɨlop agak, Nɨbi pen yɨp an agɨl nepɨm agak? Agek, Pita agak, Nad nep nɨm, Bɨ God nop aglup ak, chɨnop dɨl kod yenɨgaban ak agak. ");
INSERT INTO taw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Agek, Jisas takaw kɨles gɨl agak, Binɨb okok kɨlop takaw anɨb ak ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas pen, bɨne okok kɨlop takaw agñɨlɨg agak, Bɨ Olap Ñɨne yul awl yɨbɨl dɨnɨgab agak. Bɨ Juda bɨawl takaw tɨg asɨkep okok sek, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek kɨli nop ma dɨnɨgabal agak. Ma dɨl, mɨlɨk nɨŋɨd ñaglɨnɨgabal ak pen, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas takaw anɨb ak mɨseŋ agek, Pita Jisas nop dad gol okok amɨl, ag gɨlɨg agak. ");
INSERT INTO taw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisas pen tɨg adɨkɨl bɨne okok kɨlop nɨŋɨd, Pita nop ag gɨlɨg agak, Satan, yɨp kelɨgɨl amnoŋ agak. God gos nɨgup tek ma nepan, binɨb gos nepal tek nep nɨŋɨd anɨb ageban agak. ");
INSERT INTO taw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Anɨb agɨl, bɨne okok sek, binɨb kuŋay yɨbɨl ap yelak okok sek kɨlop suk agek, jɨj sɨŋak apelak agak, Binɨb an yɨp kɨdek gonɨmuŋ, gos ne ak kelɨgɨl, mab bak kumak chɨn ak dad ajɨl, yɨp chɨgɨl kɨdek gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Binɨb an ne ke mɨdɨl, mɨdtep gin agɨnɨgab ak, kɨdek mɨd tɨmel gɨnɨgab agak. Pen binɨb yɨp dɨl God takaw teplep nop ak dɨl, yɨp tap tay gɨnɨgab takaw ma mɨdeb agɨnɨgab ak, mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pen bɨ tap lum awl yɨl mɨdupsek dɨnɨgab ak, kɨdek ne tɨtay dɨl yenɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Akaŋ, tap tay tek bɨ olap ne God nop ñek, God pen nop gek pelpel yenɨgab agak? ");
INSERT INTO taw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Binbɨ anɨb ñɨn ak, kɨli God nop kud ñɨl kelɨgɨl, tap nɨgep ma nɨgep tap tɨmel gup ogɨnap gɨpal agak. Bɨ an yɨp nebeŋ gɨnɨmuŋ tek lek nɨŋɨd, Jisas nop ma nepin, takaw ne ak ma nepin agɨnɨgab ak, kɨdek Bɨ Olap Ñɨne ne bɨ anɨb nop nɨgek nebeŋ gɨnɨgab agak. Ne Bapi mɨlek awl dɨl, ensel okok ayɨp ownɨgab ñɨn ak, bɨ anɨb ak nop pen abe ne Bapi nop agɨnɨgab, Nop ma nepin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pen Jisas anɨb agɨl, takaw olap agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb mɨñɨl mɨdebɨm okok ogɨnap ma kumnɨgabɨm, mɨdɨl God binɨb dɨl kɨlop kod yenɨgab ñɨn anɨb ak kɨles ne sek apek nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pen kɨdek ñɨn anep kagol ak mɨdɨl, Jisas ne Pita ak, Jemis ak, Jon ak kɨlop poŋɨd, man dum adek awl alaŋ olap amnɨlak. Amɨl, kɨli nep yelak, Jisas nop nɨgel wak ne ak ke lak. ");
INSERT INTO taw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Chech ne ak kayɨg tɨmel yɨbɨl gɨl, ñɨñakol yɨbɨl gak. Pen binɨb lum awl olap chech ogɨnap ñɨg lɨ yokel, kayɨg anɨb ak tek, lɨnɨmuŋ tek ma lup. ");
INSERT INTO taw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pen won anɨb ak nɨgɨlak, Mosis ayɨp Yilayja ayɨp apɨl, Jisas ayɨp takaw agelak. ");
INSERT INTO taw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kɨli nɨŋɨd, Pita Jisas nop agak, Tisa. Chɨn tep yɨbɨl apɨl awl mɨdobun agak. Anɨb ak chɨn kal bad ak omɨŋal nokom gɨnɨgun, nep olap, Mosis nop olap, Yilayja nop olap agak. ");
INSERT INTO taw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kɨli yakam pɨlɨkɨlak tek, Pita agɨnɨm anɨb agɨl nɨgtep gɨl mel, monmon anɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pen wɨsɨp ak apɨl kɨlop yu gek, takaw olap wɨsɨp nab anɨb ak agak, Ak ñɨ mapen yad yɨbɨl agak. Takaw agɨnɨmuŋ tek nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Anɨb agaknɨŋ, kɨli nɨg kuskus gɨl nɨgɨlak, bɨ omɨŋal anɨb ak ma yelek, Jisas nokom yek. ");
INSERT INTO taw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pen dum alaŋ kelɨgɨl, apyapɨlɨg, Jisas agak, Dum awl tap gosup nepɨm ak, mɨñɨl binɨb ogɨnap kɨlop ma agñɨnɨmɨb agak. Kɨdek Bɨ Olap Ñɨne kumɨl tɨkjakek, mɨseŋ agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Agek, kɨli takaw anɨb ak nɨŋɨd agup agɨl, binɨb ogɨnap kɨlop ma agñɨlak. Kɨli ke agnɨg agnɨg gɨl agɨlak, Kumɨl tɨkjakɨnɨgayn agup takaw jɨj ak tay agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Anɨb agɨl, Jisas nop agnɨŋɨd agɨlak, Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok taynen apal, Yilayja ned ownɨgab apal agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Agelak, Jisas agak, Nɨŋɨd apal agak. Buk Baybol ak ñu kɨl tɨkɨl agɨlak, Bɨ Yilayja ned apɨl, tap okok mɨdupsek gɨlɨtep gek, Bɨ Olap Ñɨne ak kɨdek ownɨgab agɨlak agak. Pen binɨb okok Bɨ Olap Ñɨne nop ma dɨl, yul awl ñɨnɨgabal ñu kɨl tɨkɨl agɨlak takaw ak, taynen anɨgɨl ñu kɨl tɨkɨl agɨlak agak? ");
INSERT INTO taw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pen bɨ Yilayja agɨlak anɨb ak, ne kɨdek ownɨgab agɨl gos ak ma nɨgɨnɨmɨb agak. Nop tɨkel awl gɨl, takaw agñaknɨŋ nop gɨ tɨmel yɨbɨl gɨlak agak. Anɨb ak buk Baybol ak ñu kɨl tɨkɨl, gɨnɨgabal agɨlak tek nep gak agak. ");
INSERT INTO taw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pen kɨli ayaŋ amɨl nɨgɨlak, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap, Jisas bɨne okok ayɨp penpen ag yelaknɨŋ, binɨb kuŋay yɨbɨl ap kɨlop puŋɨl kuskus gɨ yelak. ");
INSERT INTO taw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Anɨgɨl nɨg yelaknɨŋ, Jisas apjakek ju dɨl, kasek am nop ag dɨdeg lɨl ag dɨlak. ");
INSERT INTO taw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pen Jisas bɨne okok kɨlop agnɨŋɨd agak, Taynen pen agek pen agek gebɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Anɨb agek, bɨ olap binɨb yelak nab anɨb ak nɨb agak, Tisa. Ñɨ yad ak kɨcheki abaŋ lek, takaw ma agup agak. Ñɨn ogɨnap nop tapɨn gek, apyap pakɨl, meg sɨp yɨmɨl, kosɨb asɨb apɨl, ñɨn tob yɨd gup agak. Pel anɨb gek gek nɨm, dad nep yɨl opin ak pen, mɨñɨl bɨnak okok kɨlop agen, kɨcheki ak agyok menɨŋ mel nɨg kelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Anɨb agek, Jisas kɨlop agak, Nɨbi binɨb mɨñɨl mɨdebɨm lum awl, God nop gos ma nepɨm agak. Ñɨn akal nop gos lɨnɨgɨnɨgabɨm agak? Ma yɨbɨl nepɨm anɨb ak, yad ñɨn tɨtay nɨb ayɨp mɨdɨl, mɨŋel nɨbop ak dad ajenɨm agak? Ñɨ anɨb ak dad mɨdebin awl owɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Agek, dad yek jɨj sɨŋak apel, kɨcheki ñɨ anɨb anop abaŋ lak ak Jisas nop nɨŋɨd, ñɨ anop gek apyap pakɨl, adɨk madɨk gaknɨŋ, kosɨb asɨb apɨl amnak. ");
INSERT INTO taw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Anɨgek, Jisas ñɨ anɨb ak nap nop agnɨŋɨd agak, Tap anɨb ak, ñɨn akal tek gak agak? Agek agak, Bɨlel ñɨsɨkol mug tɨkɨl gak agak. ");
INSERT INTO taw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kɨcheki anɨb ak, nop pel paklin agɨl, mab yɨnub nab okok sek, ñɨg nab okok sek dɨyokup agak. Anɨb ak chɨlopapɨl chɨb nɨŋɨd, tap anɨb ak agyokep tek lek, agyokan agak. ");
INSERT INTO taw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Agek, Jisas agak, Taynen agyokep tek lek, agyokan ageban agak. Nad God nop gos lɨnɨge, tap okok mɨdupsek gɨnɨmɨn tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Agek, kasek ñɨ anɨb ak nap ne suk agak, God nop gos lɨnepin agak. Pen gos omɨŋal nɨgɨnɨm tek lup ak, yɨp gos tep yɨbɨl gɨñɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pen binɨb kuŋay yɨbɨl kasek apnan gɨlaknɨŋ, Jisas kɨcheki anop ag gɨl agak, Nad bɨ binɨb ge tɨmud pɨl gɨl, takaw ma apal ak, nep agebin, ñɨ anop pɨsnep kelɨg amnɨmɨn agak. Tepayaŋ ma adɨkɨd ownɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Agek, kɨcheki anɨb ak wal agɨl, ñɨ anop gek apyap pakɨl, jep dɨ dɨ wos gek kɨcheki ne seŋ amnak. Amek, ñɨ ak ne kumɨl tek yek, binɨb kuŋay kɨli agɨlak, Ne kumub agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Anɨb agɨlak ak pen, Jisas ñɨn nop dɨ jak ñak. ");
INSERT INTO taw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kɨdek pen Jisas kal mɨgan amɨl, bɨne okok ayɨp, kɨli nep mɨdɨlɨg nop agɨlak, Taynen chɨn kɨcheki anɨb anop agyok mel nopun agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Agelak agak, Kɨcheki anɨb ak tek yokɨp ma agyokɨpal agak. God nop agnɨgel nɨm, ag seŋ yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jisas bɨne okok poŋɨd man anɨb ak kelɨgɨl, Galili plopens nab okok ajolɨgup. Ajɨlɨg, bɨne okok kɨlop takaw agñɨ tep gɨnɨm agɨl, kɨmɨgel weyɨg mɨdɨlɨg, kɨlop agñolɨgup. Agñɨl agolɨgup, Bɨ Olap Ñɨne nop mɨmug nɨŋɨd, binɨb ogɨnap kɨlop ñɨnɨgabal agolɨgup. Ñel, paklel kumɨl, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne agaknɨŋ, takaw jɨj anɨb ak tay agup agɨl, nop agnɨgɨnɨgel ak pen, jel gek ma agnɨgelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Pen kanɨb nab okok amɨlɨg bɨne okok, nɨbi mel yad nokom bɨawl mɨdebin agɨlɨg, penpen agel amnak. Am taun Kapeneyam amjakɨl, kal mɨgan ak amɨl, Jisas kɨlop agnɨŋɨd agak, Nɨbi kanɨb nab okok apɨlɨg, takaw tay agem opɨm agak? Agek, takaw anɨb ak agel owak ak nɨŋɨd, pen ma agñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma agñelak, Jisas am besɨgɨl bɨne anep umɨgan kɨlop agek apelak agak, Bɨ ned bɨnonɨm awl yɨbɨl mɨden agɨl nɨŋɨd nɨm, okyaŋ apɨl, bɨ yokɨp wog gɨñub tek ak mɨdɨl, bɨ ogɨnap kɨlop wog gɨñɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Anɨb agɨl, ñɨsɨkol olap dap yelak nab sɨŋak jak ñɨl, dɨ kay gɨlɨg kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Binɨb yɨp gos nɨŋɨd, ñapay sɨkol dɨpin awl tek kɨlop dɨnɨgabal okok, kɨlop nep mel, yɨp abe dɨnɨgabal agak. Pen yɨp dɨnɨgabal okok, yɨp nokom mel, Bapi yɨp agyokek ownek ak nop abe dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pen Jon ne Jisas nop agak, Tisa. Chɨn nɨgɨnok, bɨ olap yɨb nep ak agɨl, kɨcheki walɨjpal ag seŋ yokak agak. Yokek, nɨŋɨd anɨb agɨnok, Nad bɨ chɨn ayɨp jɨmñɨl ma ajɨpun ak, anɨb ma gɨnɨmɨn agɨnok agak. ");
INSERT INTO taw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Agek, Jisas Jon nop agak, Nop taynen mel apɨm agak? Bɨ yɨp gos nɨŋɨd, tap mageptek teplep ogɨnap gɨnɨgab okok, kɨdek adɨkɨd yɨp takaw tɨmel ma agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Binɨb chɨnop mɨlɨk ma nepal okok, kɨli bogɨlak chɨn mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pen nɨbop nɨŋɨd agebin agak. Bɨ olap, ne nɨbop Klays bɨne agɨl, ñɨg mal ñek ñɨŋɨnɨgabɨm okok, God ne bɨ anɨb anop dɨtep yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Pen Jisas takaw anɨgɨl agak, Binɨb ogɨnap, kɨli ñɨsɨkol paysɨkol olap yɨp gos lɨnɨgup ak nop gel apyap pakɨnɨgab ak, tɨmel yɨbɨl gɨnɨgabal agak. Kɨlop ned tunɨg dam ñɨg solwala yokɨpɨlap ak gɨtep gɨpɨlap agak. Taynen? Binɨb ogɨnap koŋɨm mɨdɨl ñɨsɨkol paysɨkol olap nop gɨ tɨmel gɨnɨgabal ak, kɨdek yul awl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Anɨb agɨl agak, Ñɨn mɨdup wul olap tap si tap tɨmel gɨnɨg gonɨmuŋ, pɨs kɨd anɨb ak tɨbɨlɨk yoke, pɨs kɨd anep yonɨmuŋ agak. Nak ñɨn kɨd nokom olap yenɨgab ak, pelpel yenɨgaban, tap teplep yɨbɨl agak. Pen ñɨn nak kɨd omɨŋal yenɨgab ak, mab ke yɨneb amnɨgaban, tap tɨmel yɨbɨl agak. Mab ke yɨneb anɨb ak, ma sɨŋ gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Tob kɨd olap tap si tap tɨmel gɨnɨg gonɨmuŋ, pɨs kɨd anɨb ak tɨbɨlɨk yoke, pɨs kɨd anep yonɨmuŋ agak. Nak tob kɨd nokom olap yenɨgab ak, pelpel yenɨgaban, tap teplep yɨbɨl agak. Pen tob nak kɨd omɨŋal yenɨgab ak, mab ke yɨneb amnɨgaban, tap tɨmel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pen wɨdɨn mɨdup olap tap si tap tɨmel gɨnɨg gonɨmuŋ, wɨdɨn pɨs kɨd anɨb ak tɨg juyokem, pɨs kɨd nokom olap nep yonɨmuŋ agak. Nak wɨdɨn kɨd nokom olap yenɨgab ak, God binɨb dɨl kɨlop kod yenɨgab ak amɨl pelpel yenɨgaban, tap teplep yɨbɨl agak. Pen wɨdɨn nak kɨd omɨŋal yenɨgab ak, mab ke yɨneb amnɨgaban, tap tɨmel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mab ke yɨneb man anɨb ak, kɨlop kɨsoy pelnep lɨl mɨdɨlɨg, mab ma sɨŋ gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kɨli mɨnek mɨnek God nop tap sɨbogep ñɨnɨg, dek lɨl ñɨbal agak. Dek anɨb ak lɨl ñel, God wɨdɨn mɨdup adek sɨŋak suŋtep gup agak. Anɨb ak tek, mɨŋel ogɨnap binɨb okok kɨlop ownɨgab. Apɨl kɨlop gek, kɨli God wɨdɨn mɨdup adek sɨŋak suŋtep yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dek tap yɨdek tep yɨbɨl ak pen, yɨdek ne ak amek, taydɨl gem tepayaŋ yɨdek gɨnɨgab agak? Anɨb ak tek, nɨbi dek yɨdek tek ak mɨdɨl, mam ay ogɨnap ayɨp kɨmɨgel yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas man anɨb ak kelɨgɨl, Judiya plopens man nab okok amɨl, am ñɨg Jodan tɨkɨl, kɨd adaŋ amnak. Amek, binɨb kuŋay yɨbɨl nɨŋɨd apnan gelak, ne pel golɨgup tek kɨlop takaw agñak. ");
INSERT INTO taw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɨ Pelisi ogɨnap Jisas tay tek agɨnɨgab agɨl, yek ak apɨl, agnɨŋɨd agɨlak, God takaw ne tay agup agɨlak. Bin dɨl agyokɨnɨgab akaŋ mel, tay gos nepan agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Agelak, Jisas agak, Mosis takaw tay agɨl tɨkak agak? ");
INSERT INTO taw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Agek agɨlak, Mosis agak, Bin agyokɨnɨg, nop ñu kɨl bad olap tɨkñɨl agyokɨnɨmuŋ agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Agelak, Jisas agak, Takaw teplep ak nɨbop yɨlɨk gak ma dɨpɨm tek, Mosis takaw anɨb ak tɨkɨl nɨbop ñak agak. ");
INSERT INTO taw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pen God bɨlel lum awl gɨlak ñɨn ak, bɨ gɨlɨl bin gɨlɨl gak agak. ");
INSERT INTO taw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adek anɨb ak nɨm, bɨ okok nonɨm nap sɨkop ayɨp mɨdɨl, bin dɨlɨg kɨlop kelɨgɨl, ");
INSERT INTO taw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kɨli bel jɨmñɨl kɨnel wak nokom lup agak. God agek kɨli omɨŋal mɨdebil tek ma mɨdebil, wak nokom yɨbɨl lup agak. ");
INSERT INTO taw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God agek kɨli wak nokom yɨbɨl lup anɨb ak, bɨ ogɨnap tɨkjakɨl, kɨlop ag tɨg asɨk keke ma lɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anɨb agɨl, bɨne okok ayɨp tepayaŋ kal mɨgan ayaŋ amɨl, nop takaw anɨb ak agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Agnɨgelak agak, Bɨ okok bin dɨl agyokɨl, bin kɨdeyɨl dɨnɨgabal ak, bin si dɨl tap tɨmel gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pen bin okok abe bɨ dɨl kelɨgɨl, bɨ kɨdeyɨl dɨnɨgabal ak, bɨ si dɨl tap tɨmel gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Binɨb okok, kɨli Jisas ñɨpay chɨnop okok dɨnɨgaŋ agɨl, dad apel, bɨne okok pen binɨb anɨb okok kɨlop nɨg chɨkɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ag gelak, Jisas kɨlop pen ag gɨl agak, Ñɨsɨkol paysɨkol okok kelɨgem yad yɨl owlaŋ agak. God binɨb dɨl kɨlop kod yenɨgab anɨb ak nɨm, ñɨsɨkol paysɨkol anɨb okok tek agak. ");
INSERT INTO taw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anɨb ak nɨbop nɨŋɨd agebin, binɨb kɨli ñɨsɨkol paysɨkol kɨli God nop muk okok mɨdebal tek ma yenɨgabal ak, kɨli God binɨb dɨl kɨlop kod yenɨgab mɨgan ak ma amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Anɨb agɨl, ñɨsɨkol paysɨkol okok kɨlop kay gɨl, ñɨn dɨ mɨdɨlɨg agak, God nɨbop kod yonɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pen Jisas amnaknɨŋ, bɨ olap kasek amɨl Jisas am yek tob agen sɨŋak kɨgom yɨmɨl agak, Tisa tep yɨbɨl, yad tap tay gen, God gek pel pelnep yenɨgayn agak? ");
INSERT INTO taw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Agek Jisas agak, Yɨp taynen bɨ tep yɨbɨl apan agak? Binɨb olap tep yɨbɨl ma mɨdebal, God nokom nɨm bɨ tep yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pen Mosis takaw ñu kɨl tɨkak ak nad nepan, anɨb agup, Chɨp ma ñagɨnɨmɨb, bin si bɨ si ma gɨnɨmɨb, tap si ma dɨnɨmɨb, yepɨs ma agɨnɨmɨb, yepɨs yepɨs agɨlɨg binɨb ogɨnap tap okok ma taw pɨlɨg dɨnɨmɨb, nanɨm nap takaw agɨnɨgel tek nɨŋɨd kɨdek gɨnɨmɨb agup agak. ");
INSERT INTO taw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Anɨb agek, bɨ anɨb ak Jisas nop agak, Tisa. Yad ñɨsɨkol mug tɨkɨl, Mosis takaw ñu kɨl tɨkak anɨb okok mɨdupsek nɨgɨlɨg kɨdek gɨpin agak. ");
INSERT INTO taw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Agek, Jisas nop mapen lɨl agak, Tap nokom olap nep ma gɨpan agak. Amɨl, tap nad tɨtay mɨdeb okok mɨdupsek yokɨl mani dɨl, binɨb tap ma mɨdeb okok kɨlop ñɨnɨmɨn agak. Anɨgɨl nɨm, nad tap teplep yenɨgab, God man ne alaŋ agak. Apin tek gɨl apɨl, yad ayɨp ajonɨgul agak. ");
INSERT INTO taw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Anɨb agek, bɨ anɨb ak tap ne kuŋay yek tek, mɨlɨk yapɨl chɨb gek gos pal yɨbɨl lɨlɨg amnak. ");
INSERT INTO taw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Amek, Jisas bɨne okok kɨlop nɨg kuskus gɨl agak, Binɨb tap kuŋay mɨdeb okok, kɨli koslam yɨbɨl sɨlɨgɨl ameb tek mɨdeb, God binɨb dɨl kɨlop kod yenɨgab ak agak. ");
INSERT INTO taw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Anɨb agek, gos kuŋay yɨbɨl nɨgelak, kɨlop tepayaŋ agak, Ñapay yad okol. Binɨb kɨli koslam yɨbɨl sɨlɨgɨl ameb tek mɨdeb, God binɨb dɨl kɨlop kod yenɨgab ak agak. ");
INSERT INTO taw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chag kamel okok ñu alɨguñ yokep mɨgan tek ak amnɨg kasek amnɨgel tek lup agak. Binɨb pen mani tap kɨli kuŋay mɨdeb okok, kɨli God binɨb ne mɨdɨnɨg, koslam yɨbɨl binɨb ne mɨdel, kɨlop dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Anɨb agek, bɨne okok gos pal awl yɨbɨl lɨl, pen agnɨgek pen agnɨgek gɨl agɨlak, Takaw agup anɨb ak, binɨb okok God yɨl pel pelnep yonɨgun tek ma lup agɨlak. Akaŋ tay agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Agelak, Jisas kɨlop nɨgɨlɨg agak, Binɨb okok ke gɨnɨgel tek ma lup agak. God nokom nɨm tɨtay gɨnɨg, gɨnɨmuŋ tek nep mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pen Pita Jisas nop agak, Nɨgan, tap chɨn okok mɨdupsek kelɨgɨl, nad ayɨp nep chɨgɨl kɨdek gɨpun agak. ");
INSERT INTO taw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Agek agak, Yad nɨbop nɨŋɨd agebin agak. Binɨb yɨp gos nɨŋɨd, takaw teplep wog ak gɨnɨg, kal man kɨli kelɨgɨl akaŋ, nɨmam nɨnay kɨli kelɨgɨl akaŋ, nonɨm nap kɨli kelɨgɨl akaŋ, ñapay kɨli okok kelɨgɨl akaŋ, tap wog kɨli okok kelɨgɨl, takaw teplep wog ak genɨgabal ak, ");
INSERT INTO taw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","God kɨlop dɨtep yɨbɨl gɨnɨgab agak. Kɨlop kod yek lum awl yenɨgabal ñɨn ak, nap, nonɨm, nɨmam, nɨnay, ñapay, kal, wog okok kuŋay yɨbɨl ñɨnɨgab agak. Pen binɨb yokɨp okok kɨli, binɨb God wog ak gɨpal okok kɨlop gɨ tɨmel yɨbɨl gɨnɨgabal agak. Ñɨn kɨdek ak pen apek, binɨb God wog ak gɨpal okok kɨli pel pelnep yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Binbɨ kuŋay okok kasek amnun agɨl ned abal, kɨli kɨdek amnɨgabal agak. Pen binbɨ kɨdek abal okok, kɨlop tawsak lɨl ned amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pen kɨli Jelusalem amɨlɨg, Jisas ned gak. Bɨne okok kɨdek gɨl gos pal lɨlɨg amnɨlaknɨŋ, binɨb kɨdek gɨl apelak okok nɨŋɨd pɨlɨkɨlak. Jisas pen, bɨne anep umɨgan ak kɨlop poŋɨd gol sɨŋak amɨl, tap nop tay gɨnɨgab ak kɨlop agñak. ");
INSERT INTO taw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Agñɨlɨg agak, Nɨgɨm. Chɨn Jelusalem amon, Bɨ Olap Ñɨne nop mɨmug gɨl, dɨl bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek kɨlop ñɨnɨgab agak. Ñek, kɨli takaw aglɨl agɨnɨgabal, Bɨ anɨb awl nop paklep agɨnɨgabal agak. Anɨb agɨl, bɨ Juda mel okok kɨlop ñɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ñel, nop agjuwɨl, kɨñuk gɨl, nag dɨl pakɨl, dam pɨsnep paklel kumnɨgab ak pen, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepedi ñɨne Jemis ayɨp Jon ayɨp apɨl Jisas nop agɨlek, Tisa, chɨlmɨŋal nep takaw olap agnɨgɨnɨgobul, chɨlop yaw agɨnɨmɨn agɨlek. ");
INSERT INTO taw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Anɨb agelek, Jisas agak, Yɨp agnɨgɨnɨgebil anɨb ak, ñɨlop tay gɨnɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Agek agɨlek, Kɨdek nad Bɨawl yɨbɨl mɨdɨl, man mɨdupsek kod yenɨgaban ñɨn ak, chɨlop ge bɨ kod mɨdep mɨdɨl, olap ñɨn yɨpɨd kɨd okok ken, olap ñɨn aŋɨd kɨd okok ken besɨg yonɨgul agɨlek. ");
INSERT INTO taw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Anɨb agel, Jisas kɨlop agak, Ñɨli omɨŋal nɨgtep gɨl yɨp ma agnɨgebil agak. Ñɨg sɨlek yad ñɨŋɨnɨgayn ak ñɨli omɨŋal abe ñɨŋɨnɨgayl akaŋ agak? Mɨŋel awl yɨbɨl yad dɨnɨgayn ak abe dɨnɨgayl akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Agek, Yaw agɨlek. Agelek, Jisas agak, Nɨŋɨd apil agak. Ñɨg sɨlek yad ñɨŋɨnɨgayn ak ñɨli omɨŋal abe ñɨŋɨnɨgayl agak. Mɨŋel awl yɨbɨl yad dɨnɨgayn ak abe dɨnɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pen ñɨn yɨpɨd kɨd ak an yenɨgab, ñɨn aŋɨd kɨd ak an yenɨgab ak yad ke ma aglɨnɨgayn agak. Ak God tap ne, ne ke kɨlop nɨgup tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pen Jisas bɨne anep wajɨlem ak takaw anɨb ak nɨŋɨd, Jemis ayɨp, Jon ayɨp kɨlop ag gɨlak. ");
INSERT INTO taw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ag gelak, Jisas kɨlop agek apel agak, Nɨbi nepɨm, man keke binɨb Juda mel okok, bɨawl yɨbɨl kɨli okok kɨlop kodɨpal agak. Pen bɨawl kɨli okok, kɨli takaw kɨles gɨl agɨl apal, Takaw chɨnop kɨdek gɨlaŋ apal agak. ");
INSERT INTO taw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nɨbi pen anɨb ak tek ma gɨnɨmɨb agak. Bɨ nɨbi olap bɨawl mɨdɨnɨg gonɨmuŋ ak, wog gɨñeb nɨbi yonɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pen bɨawl yɨbɨl mɨdɨnɨg gonɨmuŋ ak, binɨb okok mɨdupsek kɨlop monmon yɨbɨl wog gɨñeb yonɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bɨ Olap Ñɨne abe anɨb ak nep tek agak. Yad bɨawl mɨden yɨp wog gɨñɨnɨgel agɨl lum awl ma owak agak. Ne kɨlop gɨñɨnɨg owak agak. Kɨlop kuŋay tawnɨm agɨl gos nɨŋɨd kumak agak. ");
INSERT INTO taw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas bɨne okok ayɨp taun Jeliko apjakɨlak. Kɨli mɨdɨl amnɨg gelak, binɨb kuŋay yɨbɨl ayɨp amnɨlak. Amnɨlaknɨŋ, bɨ Timeyus ñɨne Batimeyus wɨdɨn koy gek, kanɨb gol sɨŋak besɨg mɨdɨlɨg, mani tap okok nen asɨb agɨlɨg yek. ");
INSERT INTO taw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Agɨlɨg mɨdaknɨŋ, Jisas bɨ Nasalet nɨb apal agel nɨŋɨd, ne suk agɨl agak, Jisas, Depid Ñɨne, yɨp mapen nɨŋɨd dɨtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Agek, binɨb kuŋay okok nop ag gɨl agɨlak, Ma agan, kɨmɨgel mɨde agɨlak. Anɨb agɨlak ak pen, ne kɨmɨgel ma yek, suk awl agɨl agak, Depid Ñɨne, yɨp chɨb nɨŋɨd dɨtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Agek, Jisas apek nab sɨŋak alad gɨl agak, Nop agem owaŋ agak. Agek, binɨb okok bɨ wɨdɨn koy anop agɨlak, Jisas nep ageb nen, tɨkjakɨl gos sek ownɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Agelak, chech palsek ne ak tɨg asɨk yokɨl kasek jakɨl yek, Jisas yek ak amnak. ");
INSERT INTO taw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Amek, Jisas nop agak, Yɨp tay gaŋ agɨl apeban agak? Agek agak, Tisa, wɨdɨn ak nɨgin agɨl apebin agak. ");
INSERT INTO taw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Agek, Jisas agak, Tep. Yɨp gek suŋ lɨnɨgab agɨl gos nepan tek, suŋ lup nen amnoŋ agak. Anɨb agaknɨŋ, day wɨdɨn yɨbɨl nɨŋɨd, Jisas ayɨp kanɨbtam amnɨlek. ");
INSERT INTO taw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas bɨne okok ayɨp am am Jelusalem wulep wulep gɨlɨg, man sɨkol Betpage sek, Betani sek amjakɨlak. Man omɨŋal dum Olip nokom yelak. Pen amjakɨl, Jisas bɨne omɨŋal ned agyokɨl agak, ");
INSERT INTO taw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Man sɨkol wakay adaŋ amɨl kasek nɨgɨnɨgayl, chag donki malep binɨb ma dad ajɨpal olap, tunɨg lel yenɨgab agak. Nɨŋɨd, wɨsɨb dad ownɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Binɨb ogɨnap ñɨlop taynen anɨgebil agenɨgel agɨnɨmil, Bɨawl ak wog olap gɨl, tepayaŋ yokek ownɨgab agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Anɨb agek, amɨl nɨgɨlek, donki malep ak, kal kanɨbtub gol sɨŋak tunɨg lel yek. Wɨsɨb gɨleknɨŋ, ");
INSERT INTO taw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","binɨb yep wulep anɨb okok jak yelak okok agɨlak, Tay gɨnɨg, donki malep anɨb ak wɨsɨbebil agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Agelak, Jisas agak tek agelek, yaw agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yaw agel, donki malep anɨb ak dad Jisas yek ak owlek. Apɨl, chech palawl kɨli adek alaŋ lɨlek okok tɨg asɨkɨl, dɨl donki adek lelek, Jisas adek anɨb ak besɨgak. ");
INSERT INTO taw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pen binɨb okok, ogɨnap chech palsek kɨli okok tɨg asɨk kanɨbtam adek ak lɨlɨg, ogɨnap tap wɨj okok tɨpag dap lɨlɨg, nop dɨ nab lɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Binɨb ogɨnap ned gɨl, ogɨnap kɨdek gɨl, suk awl agɨlɨg agɨlak, Hosana, God nop tep yɨbɨl agɨnɨgun agɨlak. Bɨ anɨb ak Bɨawl ne agyokek owup ak, Bɨawl nop gɨtep gɨnɨmuŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bɨnonɨm nɨm ak ownɨgab ak, ne based Depid bɨnonɨm mɨdɨl binɨb kod yolɨgup tek ak yenɨgab agɨlak. God ne bɨnonɨm anɨb anop gɨtep gɨnɨmuŋ agɨlak. God man ne alaŋ mɨdeb ak, nop tep yɨbɨl agɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas anɨgɨl Jelusalem amɨl, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amɨl, tap okok nɨg ajaknɨŋ, sub saŋɨd amek nɨŋɨd, bɨne anep umɨgan ak ayɨp adɨkɨd man sɨkol Betani amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mɨnek pen, man sɨkol Betani nɨb adɨkɨd kanɨb nab okok amnɨlaknɨŋ, Jisas nop yuwan gek, ");
INSERT INTO taw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","pal chɨm nɨgak, mab pik bɨd olap wɨj ne kuŋay yek. Mɨdup ogɨnap pulɨl mɨdeb akaŋ agɨl amɨl nɨgak, ma pulak, wɨj nep yek. Taynen? Mɨdup ne pulep ñɨn ak ma owak. ");
INSERT INTO taw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Anɨgek, Jisas agak, Mab bɨd anɨgup ak, kɨdek ma pulek ñɨŋɨnɨgabal agak. Anɨb agek, bɨne okok mɨdupsek nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas bɨne okok poŋɨd Jelusalem amɨl, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amɨl, binɨb sɨkim gɨ yelak okok, kɨlop agyokɨnɨg gak. Penpen kamɨl dɨlɨg, yawl dap lel tawlɨg gɨ yelak bog adek okok tɨg adɨkɨl, binɨb sɨkim gɨlɨg tap tawlɨg gɨ yelak okok mɨdupsek yuk seŋ yokak. ");
INSERT INTO taw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yuk yokɨl agak, Binɨb olap tap sɨkim gep ogɨnap, dad God agnɨgep kal awl kab wali kus gɨl yek nab awl ma padɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Anɨb agɨlɨg agak, Buk Baybol ñu kɨl tɨkɨl agɨlak, God ne agup, Kal yad ak, binɨb man okok mɨdupsek apɨl yɨp agnɨgɨnɨgabal agup agɨl tɨkɨlak agak. Pen nɨbi anɨgem, bɨ tap si dɨl weyɨg mɨdebal kal olap tek lup agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Anɨb agek, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek takaw anɨb ak nɨgɨlak. Nɨŋɨd, nop paklun agɨl gos nɨgɨlak ak pen, binɨb yokɨp okok mɨdupsek takaw nop nɨŋɨd gos pal awl yɨbɨl lɨlak tek, kɨli nop nɨŋɨd pɨlɨkɨlak. Anɨgɨl nop taydɨl paklɨnɨgun agɨl gos ogɨnap nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pen dugep won ak, Jisas bɨne okok ayɨp Jelusalem kelɨgɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mɨnek Jisas bɨne okok ayɨp, kɨli adɨkɨd kanɨb nab okok apɨl nɨgɨlak, mab pik anɨb ak mɨlep gak. Kɨdɨl ne ak sek wɨj ne ak sek pɨsnep mɨlep gak. ");
INSERT INTO taw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nɨŋɨd Pita ne agak, Tisa, nɨgan. Mab pik bɨd kɨdek ma pulek ñɨŋɨnɨgabal agɨnak awl, pɨsnep mɨlep gɨ yowup agak. ");
INSERT INTO taw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Agek pen Jisas agak, Nɨbi God nop gos lɨnɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yad nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb dum awl nop agɨnɨgel, Dum ak, nad tɨkjakɨl, ñɨg solwala ayaŋ pɨdeg lan agenɨgel, kɨli God ne gek ñɨg ayaŋ amnɨgab agɨl, agɨnɨgabal tek gɨnɨgab agak. Pen gɨnɨgab akaŋ ma gɨnɨgab agɨl gos nɨgɨnɨgabal ak, ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Anɨb ak tek nɨbop agebin agak. Nɨbi God nop agnɨgem, tap nɨm akal gos anɨb ak dɨnɨgun agɨl nepɨm ak, agɨnɨgabɨm tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Pen jakɨl God nop agnɨgenɨmɨb, binɨb tap tɨmel ogɨnap nɨbop gɨpal okok kɨlop nɨŋɨd kelɨgem. Nɨŋɨd kelɨgem nɨm, Bapi nɨbi man ne alaŋ mɨdeb ak, tap si tap tɨmel nɨbi gɨpɨm okok, pen abe tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pen Jisas bɨne okok ayɨp Jelusalem apjakɨl, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ ajek. Ajaknɨŋ, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Juda bɨawl okok sek kɨli Jisas yek ak apɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nad kɨles akal nɨb dɨl, tap anɨb ak gɨ ajɨpan agɨlak? Nep an anɨgɨnɨmɨn agek, gɨ ajɨpan agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Agelak agak, Yad nɨbop takaw olap agnɨgen, yɨp pen agñenɨgabɨm nɨm, yɨp an agek gɨ ajɨpin ak agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon binɨb okok kɨlop ñɨg pakñak ak, God agek pakñak akaŋ, bɨ gos ne ke nɨŋɨd pakñak agak? Yɨp agñem nɨgin agak. ");
INSERT INTO taw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Anɨb agek, kɨli ke agnɨg agnɨg gɨl agɨlak, Chɨn agɨnɨgabun, God agek binɨb okok kɨlop ñɨg pakñak agon, ne taynen Jon takaw nop ak ma dɨpɨm agɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pen binɨb okol, kɨli Jon bɨ God gos ñek agñeb yolɨgup ak agɨl gos nepal agɨlak. Anɨb ak tek, chɨn agɨnɨgabun, Jon gos ne ke nɨŋɨd gak agon, chɨnop kab sɨlok paklɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gos anɨb ak nɨŋɨd anɨb agɨlak, Chɨn ma nopun agɨlak. Anɨb agelak, Jisas kɨlop agak, Nɨbi yɨp ma agñɨbɨm tek, yɨp an agek tap anɨb okok gɨpin ak nɨbop pen ma agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pen Jisas kɨlop takaw paladaŋ lɨl agak, Bɨ olap wayn wog ak gɨ yɨmɨl wali gɨl, wayn mɨdup taw chɨb jakɨnɨg gup kab kɨwok mɨgan olap gɨlɨtep gɨnɨgab agak. Binɨb apɨl nag mɨdup si dɨnɨgabal ak nɨg yonɨgun agɨl, kal kɨlan gɨl palawl olap gɨnɨgab agak. Tap anɨb okok mɨdupsek gɨjuwɨl, bɨ wog nop gɨnɨgabal ogɨnap kɨlop aglɨl, man palawl okok amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pen wayn mɨdup pok gɨnɨgab ñɨn ak, bɨ wog gɨñeb ne olap agyokɨl agɨnɨgab, Am age, wayn mɨdup yɨp ogɨnap ñel, dad ownɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Agek amjakek, bɨ wayn wog gɨ yenɨgabal okok, nop dɨl pak pak lɨl, yokɨp agyokel, adɨkɨd ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Anɨgel, bɨ wayn wog nap nɨb ak, bɨ olap pen agyokɨnɨgab agak. Amjakek, nop kɨmɨg alaŋ pakɨl, gɨ tɨmel yɨbɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Anɨgel, bɨ wayn wog nap nɨb ak, bɨ olap pen agyokek amek, nop pɨsnep paklɨnɨgabal agak. Wog nap nɨb ak anɨb anep gɨlɨg, ogɨnap pak pak yokɨnɨgabal, ogɨnap pɨsnep paklɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Anɨgel gel, bɨ wog nap nɨb ak bɨ wog gɨñeb ne olap ma yenɨgab agak. Pen ñɨ mapen ne nokom yenɨgab ak, kɨli ñɨ anɨb ak takaw nop ak dɨnɨgabal agɨl agyokek amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pen amjakaknɨŋ, bɨ wayn wog gɨ yenɨgabal okok nɨŋɨd anɨb agɨnɨgabal, Ñɨ owup awl, bɨ wayn wog nap nɨb ak ñɨne owup agɨnɨgabal agak. Nop paklɨl nɨm, tap ne dɨnɨmuŋ tek okok chɨn dɨnɨgabun agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Anɨb agɨl, nop dɨl pɨsnep paklɨl, dam seŋ okok dɨyokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Anɨgenɨgabal, bɨ wayn wog nap nɨb ak apɨl tay gɨnɨgab agak? Ne apɨl, bɨ wayn wog gɨnɨgabal anɨb okok kɨlop paklɨl, bɨ ogɨnap kɨlop agek, wayn wog anɨb ak kod yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anɨb agɨl, kɨlop agak, Buk Baybol takaw olap tɨkɨl agɨlak ak, nɨbi ma nepɨm akaŋ agak? Takaw anɨb ak tɨkɨl anɨb agɨlak, Bɨ kal gep okok kab olap ma dɨnɨgun agɨl kelɨgɨlak ak, kab anɨb ak mɨñɨl kal meg nab ayaŋ tek ak mɨdeb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bɨawl chɨn anɨgak ak, chɨn tap anɨb ak tap awl gos nɨŋɨd, teplep yɨbɨl mɨdeb gak agɨl gos nopun agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas anɨb agek, bɨ Juda takaw nɨgtep gep okok sek, bɨ God nop sɨbogep bɨawl okok sek, kɨli chɨnop nep agosup agɨl, nop chɨchɨk dun agɨlak ak pen, binɨb okok kɨlop pɨlɨkɨl, kelɨgɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pen kɨdek Juda bɨawl okok, kɨli bɨ Pelisi ogɨnap ayɨp, Helod bɨne ogɨnap ayɨp kɨlop agɨlak, Nɨbi Jisas mɨdeb amɨl, nop takaw ogɨnap agnɨgem, ne tay agek, nop dam kot gɨnɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Anɨb agelak, Jisas yek ak amɨl agɨlak, Tisa, chɨn nopun, nad bɨ nɨŋɨd yɨbɨl nep apan agɨlak. Bɨawl yɨb okok sek, binɨb yokɨp okok sek kɨlop nɨŋɨd ma pɨlɨkɨpan agɨlak. God agup tek nep nɨŋɨd, binɨb okok kɨlop yɨpɨd gɨl yɨbɨl agñɨban agɨlak. Anɨb ak chɨnop agñan. Chɨn tay gɨnɨgun agɨlak? Lom gapman bɨnonɨm nop takis ñɨnɨgun akaŋ, mel agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Agelak, Jisas kɨli nop tay tek agɨnɨgab agɨl agnɨgɨlak ak nɨŋɨd, anɨb agak, Yɨp taynen takaw yepɨs anɨb ak agnepɨm agak? Mani mɨdup takis ñɨbɨm olap dapem yad nɨgin agak. ");
INSERT INTO taw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Agek, dap ñel nɨŋɨd anɨb agak, Mani bak ak, an jomulɨk ak sek, yɨb ak sek mɨdeb agak? Agek agɨlak, Lom gapman bɨnonɨm mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Agel kɨlop agak, Lom gapman bɨnonɨm ak ne tap yɨp ñɨnɨmɨb agup anep ñɨnɨmɨb agak. God tap yɨp ñɨnɨmɨb agup anep ñɨnɨmɨb agak. Agek nɨŋɨd, takaw yepɨs agɨlak anɨb ak sɨlɨpuŋ ñɨlak tek, wal yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sajusi bɨ okok, kɨli binɨb kumɨl tepayaŋ ma tɨkjakɨpal agɨl nɨgelɨgɨpal tek, ogɨnap Jisas yek ak apɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisa, Mosis takaw olap chɨnop kɨli tɨkɨl agak agɨlak. Anɨb agak, Bɨ olap bin dɨl, ñapay tɨkɨl mel, yokɨp kumenɨgab, nɨmam ne olap pen bin kaŋɨl anɨb ak dɨl, mam kumak ak ñapay nop agɨl tɨkɨnɨgab agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Anɨb ak bɨ wagen sek anep kugul ak yenɨgabal agɨlak. Nɨmam ned bin dɨl, ñapay tɨkɨl mel, yokɨp kumek, ");
INSERT INTO taw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","nɨmam nab pen bin anɨb ak dɨl, abe ñapay tɨkɨl mel, yokɨp kumnɨgab agɨlak. Anɨgek, nɨmam ak pen dɨnɨgab agɨlak. Ak abe ñapay tɨkɨl mel, yokɨp kumnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Anɨgɨ dam dam nɨmam anep kugul ak ñapay tɨkɨl mel, mɨdupsek yokɨp kumel, kɨdek bin ak abe kumnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pen binɨb kumɨl tep tɨkjakɨnɨgabal apan ak, bin nokom bɨne dɨl anep kugul lak anɨb ak, kɨdek nɨmam akal ayɨp yenɨgab agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Agelak, Jisas agak, Nɨbi buk Baybol takaw tɨkɨlak ak sek, God kɨles ne ak sek ma nepɨm agak. Anɨb ak tek sawl sek lɨl takaw monmon apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Binɨb kubal okok tep tɨkjakɨnɨgabal ñɨn anɨb ak, God ensel ne okok mɨdebal tek mɨdɨl, bin okok bɨ ma del, bɨ okok abe bin ma dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pen binɨb tepayaŋ ma tɨkjakɨnɨgabal apɨm ak, Mosis mab sɨkol bɨd yɨbɨl yek kesɨm tɨkak ak, nɨbi ma nepɨm akaŋ agak? Takaw anɨb ak tɨkɨl anɨb agak, God mab yɨn gek nab ak mɨdɨl, Mosis nop agak, Eblaham, Aysak, Jekop God kɨli nɨm, yad mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pen nɨbi apɨm tek, binɨb okok pɨsnep kubɨlap ak, God kɨli mɨdebin agɨl ma apɨkop agak. God ne binɨb kubal ak tek mel agak. God bɨ koŋɨm mɨdebal ak tek agak. Anɨb ak tek nɨbi sawl sek lɨl takaw monmon yɨbɨl apɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pen bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep olap apɨl nɨgak, Jisas ayɨp bɨ Sajusi okok ayɨp pen agnɨgek pen agnɨgek yelak. Pen bɨ nɨgtep gep anɨb ak, Jisas kɨlop agtep gak ak nɨŋɨd, ap nop agnɨŋɨd agak, God takaw ned adek akal awl yɨbɨl agak? ");
INSERT INTO taw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Agek Jisas agak, God takaw ned adek awl yɨbɨl ak, buk Baybol ak tɨkɨl agɨlak, Yislel binɨb nɨgɨm agɨl tɨkɨlak agak. Bɨawl chɨn God nokom, Bɨawl yɨbɨl mɨdeb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","God Bɨawl nad anop mapen yɨbɨl lɨnɨmɨn agɨl tɨkɨlak agak. Mapen nad ak, kawnan nad ak, gos tɨmud nad ak, kɨles nad ak, mɨdupsek nop yɨl amnɨmuŋ agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","God takaw awl yɨbɨl olap nɨm, binɨb ogɨnap kɨlop, nad ke mapen lɨpan tek gɨnɨmɨn agɨl tɨkɨlak agak. Takaw okok mɨdupsek, takaw ned adek awl yɨbɨl nɨm omɨŋal anɨb ak agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Agek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ak agak, Tisa, nad nɨŋɨd yɨbɨl apan agak. God nokom nɨm, Bɨawl yɨbɨl mɨdeb agak. Ne tek ogɨnap ma mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chɨn God nop tap dam ñɨnɨgabun akaŋ, sɨbog ñɨnɨgabun ak tap yokɨp ak pen, mapen chɨn ak, gos tɨmud chɨn ak, kɨles chɨn ak, mɨdupsek nop yɨl amek nop mapen yɨbɨl lɨl, binɨb ogɨnap kɨlop chɨn ke mapen lɨpun tek gɨnɨgabun ak, tap awl yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Anɨb agek, Jisas ne bɨ ak nɨgtep yɨbɨl gɨl agup agɨl, nop agak, God binɨb okok kɨlop dɨl kod yenɨgab ak, nep wulep sɨŋak mɨdeb tek lup agak. Pen Jisas takaw nɨŋɨd yɨbɨl okok nep agek nɨŋɨd, nop nebneb gɨl agelɨgɨpal tek ma agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pen Jisas God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ mɨdɨl, binɨb okok kɨlop agñɨlɨg takaw olap agak. Anɨb agak, Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok apal, Depid tɨkek tɨk dad amɨl, Bɨ God nop aglup ak nop tɨkɨnɨgabal apal agak. Taynen anɨb apal agak? ");
INSERT INTO taw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pen God Kawnan ne ak Depid nop gos ñek, Depid ne ke ñu kɨl tɨkɨl agak, God ne Bɨawl yad anop agup, Nad ñɨn yɨpɨd kɨd yad okok besɨg yenɨmɨn agup agɨl tɨkak agak. Besɨg mɨdɨl, mɨd dad amɨl, binɨb nad ayɨp penpen gep okok kɨlop tob muk nak okok len, taw tɨbɨkɨnɨgaban agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depid ne ke agak, Bɨ anɨb ak Bɨawl yad agak. Anɨb ak, tɨtay dɨl Depid ñɨsed ak mɨdeb agak? Takaw anɨb agek, binɨb kuŋay yɨbɨl okok takaw nop ak mɨñmɨñ yɨbɨl gɨlɨg nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pen Jisas binɨb okok kɨlop takaw agñɨlɨg agak, Nɨgtep gɨnɨmɨb agak. Bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok, kɨli chech teplep palawl okok lɨl, binɨb apnan gɨpal tep ak amon, binɨb okok chɨnop apebɨm ey agɨnɨgel agɨl nepal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Juda apnan gɨpal kal ak amɨl besɨgep teplep ak besɨgon, yɨb chɨnop adek awl alaŋ mɨdeŋ agɨl nepal agak. Tap awl ñɨbal ñɨn ak abe, binɨb wɨdɨn mɨdup adek ak besɨgon, chɨnop nɨgel, yɨb chɨnop adek awl alaŋ mɨdeŋ agɨl nepal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pen bin kaŋɨl kal tap kɨlop okok si dɨpal agak. Gos kɨli ak yepɨs agɨl, binɨb wɨdɨn mɨdup adek ak mɨdɨl palawl yɨbɨl God nop agnepal agak. Gɨpal anɨb ak, kɨlop gɨ tɨmel yɨbɨl gek yul awl yɨbɨl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pen Jisas God agnɨgep kal awl ak, God nop mani ñelɨgɨpal wulep sɨŋak besɨg mɨdɨl nɨgak, binɨb kuŋay yɨbɨl mani dap ñɨlak. Binɨb mani kuŋay yek okok abe, mani kuŋay yɨbɨl dap ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pen bin kaŋɨl mani ma yek olap, mani nɨkɨm sek sɨkol omɨŋal dap ñak. ");
INSERT INTO taw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jisas anɨb ak nɨŋɨd, bɨne okok kɨlop agek apelak agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb mani kuŋay mɨdeb okok, mani kɨli ogɨnap sek dap God nop ñɨbal agak. Pen bin kaŋɨl awl, mani ne won omɨŋal mɨdeb anep dap ñub agak. Ne tap taw ñɨŋɨnɨmuŋ olap ma mɨdeb agak. Anɨb ak God nɨgek, binɨb ogɨnap sɨkol ñɨbal, bin kaŋɨl ak awl yɨbɨl ñub agak. ");
INSERT INTO taw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas God agnɨgep kal awl kab wali kus gɨl yek ak kelɨgɨl seŋ amnaknɨŋ, bɨne olap nop agak, Tisa, kab tap awl teplep okok dɨl, kal anɨb okok kɨl tep gɨlak awl nɨgan agak. ");
INSERT INTO taw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Agek Jisas agak, Nad kab kal awl anɨb okok nɨge tep gek ageban agak? Kɨdek kal anɨb okok gɨ tɨmel gel, kab olap kab olap adek ak ma yenɨgab, pɨsnep pɨpag pakɨl dɨyokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas anɨb agɨl, amɨl dum Olip besɨgɨl, God agnɨgep kal awl ak mɨdek okdaŋ nɨg mɨdaknɨŋ, Pita, Jon, Jemis, Edlu kɨli nep apjakɨl nop agnɨŋɨd agɨlak, ");
INSERT INTO taw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Chɨnop agñan agɨlak. Tap agesɨpan okok, ñɨn akal tek gɨnɨgab agɨlak? Pen tay gek nɨŋɨd anɨb agɨnɨgabun, Bɨawl agak ñɨn ak mɨñɨl gɨnɨgeb agɨl nɨgɨnɨgabun agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Agel Jisas kɨlop agak, Nɨgtep gɨnɨmɨb agak. Bɨ kuŋay yɨbɨl yepɨs yepɨs agɨl, yɨb yɨp ak dɨlɨg agɨnɨgabal, Yad nep apebin agɨnɨgabal agak. Anɨb agel, binɨb kuŋay yɨbɨl takaw yepɨs anɨb ak nɨgɨnɨgabal ak pen, nɨbi ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Man okok penpen gebal, man okok penpen gebal agenɨgel, gos kuŋay ma nɨgɨnɨmɨb agak. Tap anɨb okok tek gɨnɨgab ak pen, ñɨn kɨdek ak ownɨgeb agɨl gos ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Man awl ogɨnap tɨkjakɨl, man awl ogɨnap ayɨp penpen ñagɨnɨgabal agak. Binɨb wakay ogɨnap tɨkjakɨl, binɨb wakay ogɨnap ayɨp penpen ñagɨnɨgabal agak. Pen man okok mɨdupsek monmon dɨl, yuwan awl gɨnɨgab agak. Tap gɨnɨgab anɨb okok, bin ñapay ñɨbosup, wulep mɨdeb agɨl nepal tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pen nɨgtep gɨl yenɨmɨb agak. Ñɨn ogɨnap nɨbop dad Juda kaunsol yenɨgabal ak amel, kot gɨnɨgabal agak. Ñɨn ogɨnap nɨbop Juda apnan gɨpal kal okok dad amɨl, kul dɨl pakɨnɨgabal agak. Ñɨn ogɨnap nɨbop Jisas bɨne agɨl, dad gapman bɨawl yenɨgabal ak amel, kot gɨnɨgabal agak. Pen dad amnɨgabal tek, takaw tep yad ak gapman bɨawl okok kɨlop agñɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pen takaw teplep yad ak agñel, man okok mɨdupsek ned amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pen nɨbop kot gɨnɨg dad amenɨgel, takaw taydɨl agɨnɨgun agɨl, ned gos kuŋay ma nɨgɨnɨmɨb agak. Agɨnɨg gɨpeknɨŋ, God nɨbop gos tep ñek agɨnɨgabɨm agak. Takaw anɨb ak nɨbi ke ma agɨnɨgabɨm, God Kawnan ne ak agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pen nɨmam ogɨnap tɨkjakɨl, nɨmam ogɨnap kɨlop ñag lɨlaŋ agɨl, dam bɨawl okok kɨlop ñɨnɨgabal agak. Nap okok tɨkjakɨl, ñapay kɨli ke okok kɨlop ñag lɨlaŋ agɨl, dam bɨawl okok kɨlop ñɨnɨgabal agak. Ñapay okok tɨkjakɨl, nonɨm nap sɨkop kɨlop mɨlɨk nɨŋɨd, ñagɨnɨgel agɨl dam ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yɨp yɨl yenɨgabɨm tek nɨŋɨd, nɨbop mɨlɨk nɨgɨnɨgabal ak pen, binɨb an kɨles gɨl yad yɨl yenɨgab, mɨd dad amɨl ñɨn kɨdek ownɨgab ak, God nop tɨg asɨk dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pen Jisas takaw olap agak, Tap tɨmel asɨkep yɨbɨl olap, God agnɨgep kal awl mɨgan ak lel yenɨgab ak nɨgɨnɨgabɨm agak. Nɨgenɨgabɨm ñɨn anɨb ak, binɨb Judiya plopens yenɨgel okok, pɨlɨk dum oklaŋ okok amnɨgel agak. Takaw tɨkebin anɨb awl, nɨgtep gɨnɨmɨb. ");
INSERT INTO taw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pen agak, Binɨb kal adek alaŋ yenɨgel okok, tap dɨnɨg adɨkɨd kal mɨgan ma amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Binɨb wog day okok ajenɨgel okok, chech tap okok dɨnɨg, adɨkɨd kal ma amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ñɨn anɨb ak, bin ñapay kogmeg yenɨgabal okok sek, ñapay tul ñɨnɨgabal okok sek, koslam pɨlɨk amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Tap gɨnɨgab anɨb okok, tap tɨmel awl yɨbɨl gɨnɨgab agak. God alwol gɨlak ñɨn ak tɨkɨl, mɨd dad apɨl mɨdobun ñɨn awl, tɨmel awl yɨbɨl anɨb ak tek ma gak, kɨdek abe anɨb ak tek ma gɨnɨgab agak. Anɨb ak tek, God nop agnɨgem, yobup lɨnɨmuŋ ñɨn ak ma gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tap tɨmel awl yɨbɨl anɨb okok gɨ nep yek, binɨb mɨdupsek kum dɨpɨlap agak. Bɨawl pen binɨb ne dɨnɨg aglak okok kɨlop gos nɨŋɨd, tap tɨmel anɨb okok yep won olap nep gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pen ñɨn anɨb ak, binɨb ogɨnap nɨbop agɨnɨgabal, Nɨgɨm, Bɨ God nop aglup ak mɨdeb awl akaŋ, Ne mɨdeb adaŋ agenɨgel, nɨŋɨd apal agɨl ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bɨ ogɨnap apjakɨl agɨnɨgabal, Yad nɨm Bɨ God nop aglup ak akaŋ, Yad nɨm bɨ God gos ñek agñeb olap agɨlɨg, yepɨs yepɨs agɨlɨg, tap mageptek ogɨnap gɨnɨgabal agak. Bɨ anɨb okok, kɨli God binɨb ne aglak okok kɨlop yepɨs agun agɨl, tap anɨb okok anɨgɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Anɨb ak pen, tap tɨtay kɨdek gɨnɨgab ak, nɨbop agen nepɨm ak, nɨgtep gɨlɨg yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pen Jisas takaw olap agak, Pen mɨŋel awl anɨb okok gɨ tek daknɨŋ, sub ak gach gɨl, takan ak mɨlek ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gap okok wɨsɨp alaŋ nɨb pɨgju yapɨl, tap adekab alaŋ okok, okok nɨb okok nɨb gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Anɨgek, Bɨ Olap Ñɨne, kɨles awl sek mɨlek awl sek dɨl, wɨsɨp bad sek owaknɨŋ, binɨb okok mɨdupsek nop nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pen ensel ne okok agyokek, man ak mɨdupsek am kus gɨl, adekab sek lum awl sek puŋɨlek amnak ak, binɨb God nop aglak okok mɨdupsek dɨ yɨpɨlɨg dap nan gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Pen Jisas takaw olap agak, Mab sɨlup lup ak nɨŋɨd nɨgɨnɨmɨb agak. Mab okok sɨlup lɨl wos gaknɨŋ, mɨñɨl sub lɨnɨgeb agɨl nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Anɨb ak tek, tap anɨb okok agebin ak gaknɨŋ nɨgɨnɨgabɨm, Bɨ Olap Ñɨne ownɨg gɨnɨgab ñɨn ak wulep mɨdeb, kanɨbtub wulep sɨŋak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yad nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb mɨñɨl mɨdebal adek awl ogɨnap yelaknɨŋ, tap anɨb okok mɨdupsek gek nɨŋɨd kɨdek kumnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adekab sek, lum awl sek kul gɨnɨgab ak pen, takaw yad ak ma kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pen Jisas takaw olap agak, Ñɨn akal akaŋ, won akal tap anɨb okok gɨnɨgab ak, binɨb okok ma nepal, ensel God man ne alaŋ mɨdebal okok ma nepal, Ñɨ abe ma nɨgup agak. Nap ne nokom nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Anɨb ak nɨm, ñɨn akal tap anɨb okok gɨnɨgab ak ma nepɨm tek, nɨgtep gɨlɨg yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tap anɨb okok ñɨn anɨb ak gɨnɨgab ak, bɨawl olap kal ne ak kelɨgɨl wakay olap amnɨgab tek gɨnɨgab agak. Amnɨg, bɨ wog gɨñeb ne okok kɨlop wog adek keke aglɨl, bɨne kanɨbtub kod yenɨgab anop agɨnɨgab, Nɨg yenɨmɨn agɨnɨgab agak. Anɨgek, kal ne kelɨgɨl amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nɨbop anɨb ak tek gɨnɨgab agak. Won akal bɨ kal nap nɨb ak ownɨgab agɨl ma nepɨm tek, nɨgtep gɨl yenɨmɨb agak. Dugep won ak akaŋ, maynab awl ayaŋ akaŋ, yawl takaw agaknɨŋ ownɨgab ak akaŋ, man tɨkɨnɨgeb ak ownɨgab agɨl ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nɨgtep gɨl ma yenɨmɨb, kɨn amnɨgabɨm won ak ownɨmuŋ tek lup agak. ");
INSERT INTO taw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pen nɨbop nep ma agebin agak. Binɨb okok kɨlop mɨdupsek agebin, nɨgtep yɨbɨl gɨl yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pen Juda ñɨn awl kɨli Pasopa apal ak, bilet ma yɨnɨg tanub ñɨbal ñɨn ak wulep owak. Ñɨn omɨŋal nep mɨdaknɨŋ, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek kɨli Jisas nop taydɨl kɨmɨgel chɨchɨk dɨl, dam ñaglun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pen gos olap nɨŋɨd agɨlak, Pasopa ñɨn awl anɨgon, binɨb kuŋay yɨbɨl okok nɨŋɨd, chɨnop gɨ tɨmel gɨnɨgabal agɨl kelɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pen Jisas man sɨkol Betani amɨl, bɨ Saymon kal ak am besɨgɨl tap ñɨŋɨlak. Bɨ anɨb ak, ned soy ladek okok lek, gek suŋ lak. Pen tap ñɨŋɨlaknɨŋ, bin olap wel kuy tep owep mani awl tawpal ak, botol sek dad apɨl, nab ak pɨpagɨl, Jisas nop kɨmɨg alaŋ sogak. ");
INSERT INTO taw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Sogek, bɨ yelak anɨb okok, ogɨnap nɨgel chɨbol kɨlop ak tɨmel gek, kɨli ke agɨlak, Wel anɨb ak tawel, kab mɨdup 300 tek dɨpɨnop, binɨb tap ma mɨdeb okok kɨlop ñeb ak pen, taynen anɨgɨl yokɨp sogup agɨlak? Anɨb agɨl, nop ag gɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Anɨb agelak, Jisas kɨlop agak, Nop kelɨgɨm. Taynen mɨŋel ñebɨm agak. Yɨp gup anɨb ak, gɨtep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Binɨb tap ma mɨdeb okok, kɨli nɨb ayɨp pel yenɨgabɨm tek, tap okok ñɨnɨg ñɨnɨmɨb agak. Yad ayɨp pen, pel ma yonɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bin anɨb awl tap ne gep tek ak gup agak. Yad kumen gɨnɨgab tek gup agak. Yɨp ned wel kuy tep owep ak sogek, kɨdek yɨp kamnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yad nɨbop nɨŋɨd yɨbɨl agebin agak. Takaw teplep ak man okok agñel amnaknɨŋ, bin anɨb ak yɨp gup anɨb ak sek agɨlɨg, nop gos sawl ma gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pen Jisas bɨne anep umɨgan olap Judas Yiskaliyot, ne bɨ God nop sɨbogep bɨawl okok kɨlop, Jisas nop chen mɨmug gɨ dad apɨl nɨbop yokɨnɨgayn agɨnɨg amnak. ");
INSERT INTO taw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bɨ God nop sɨbogep bɨawl anɨb okok, chen mɨmug anɨb ak nɨŋɨd, tep gek agɨlak, Nep mani ogɨnap ñɨnɨgun agɨlak. Agelak nɨm, Judas ne won akal tek Jisas nop chen gɨ dad amɨl, bɨawl okok kɨlop ñɨnɨgayn agɨl kod yek. ");
INSERT INTO taw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pen bilet ma yɨnɨg tanub ñɨbal ñɨn awl anɨb ak owak. Ñɨn ned owak ñɨn ak, chag sipsip ñɨluk olap God nop tep agɨl pakɨnɨgun agɨl, Jisas bɨne okok nop agɨlak, Pasopa tap nad ayɨp ñɨŋɨnɨgabun okok, wakay akal gɨlɨtep gɨnɨgun agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Agelak, bɨne omɨŋal agyokɨl agak, Ñɨli taun ak amɨl nɨgɨnɨgayl, bɨ olap ñɨg mal dad amenɨgab agak. Nop nebeŋ pakɨl, kɨdek amnɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Am kal mɨgan akal amnɨgab ak, bɨ kal nap nɨb anop agnɨŋɨd agɨnɨmil, Tisa agup, Bɨyad okok ayɨp Pasopa tap ñɨŋɨnɨgabun mɨgan akal agup agɨnɨmil agak? ");
INSERT INTO taw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Agel, ñɨlop dam kal adek alaŋ mɨgan awl olap mɨdɨl, abañ tap okok mɨdupsek mɨdeb mɨgan ak yomnɨgab agak. Yomek, tap ñɨŋɨnɨgabun okok tep anɨb ak gɨlɨtep genɨmil agak. ");
INSERT INTO taw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Anɨgɨl agyokek, taun ak amɨl Jisas agak tek nep yek nɨm, Pasopa tap ñɨŋɨnɨg gɨlak ak, gɨlɨtep gɨlek. ");
INSERT INTO taw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pen dugep won ak, Jisas bɨne anep umɨgan ayɨp amjakɨl, ");
INSERT INTO taw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","besɨgɨl tap ñɨbɨlɨg agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Bɨ chɨn ayɨp tap jɨmñɨl ñɨbobun awl, nokom olap yɨp chen mɨmug gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Anɨb agek, bɨne okok chɨb gek gos pal lɨlɨg, kɨli nokom nokom anop ageb agɨl agɨlak, Yɨp apan akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Agnɨgelak agak, Nɨbi bɨyad anep umɨgan ak, olap anɨgɨnɨgab agak. Bɨ anɨb ak nɨm, tap yad ayɨp dɨ kɨnag mɨgan lɨl ñɨbobul agak. ");
INSERT INTO taw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Buk Baybol ak bɨlel agɨl tɨkɨlak tek, Bɨ Olap Ñɨne chen gɨ dad amɨl, paklek kumnɨgab agak. Bɨ anɨb ak pen, ne Bɨ Olap Ñɨne nop chen gɨ dad amnɨgab ak, ne tɨtay dɨnɨgab agak. Nonɨm nop ma tɨkɨpɨkop ak, tep yɨbɨl agak. Pen nop tɨkek, yul awl yɨbɨl ak dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tap ñɨbɨlɨg Jisas tap mɨdup dɨl, God nop tep agɨl, tɨpagɨl bɨne okok kɨlop ñɨlɨg agak, Dɨl ñɨŋɨm agak. Ak mubwak yad agak. ");
INSERT INTO taw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pen ñɨg wayn kɨnag ak abe dɨl, God nop tep agɨl, bɨne okok kɨlop ñek kɨli mɨdupsek ñɨŋɨlaknɨŋ agak, ");
INSERT INTO taw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ñɨg wayn awl nɨm, nɨkɨm yad binɨb kuŋay yɨbɨl, kɨlop nen sogeb tek agak. Nɨkɨm yad sogeb anɨb ak nɨm, binɨb dɨnɨgayn agak takaw ak am wos gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anɨb agɨl agak, Yad nɨbop nɨŋɨd yɨbɨl agebin agak. Mɨñɨl ñɨn awl tɨkɨl ñɨg wayn ma ñɨŋɨnɨgayn agak. Yokɨp yɨbɨl mɨden mɨden, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak ownɨgab agak. Anɨb ñɨn ak, ñɨg wayn koŋɨm ñɨŋɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Anɨb agɨl, bɨne okok ayɨp kɨmep olap agɨl, man Olip dum amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pen Jisas agak, Buk Baybol ak tɨkɨl agɨlak, Yad bɨ chag sipsip mukep anop paklen, chag sipsip okok pɨlɨk keke amnɨgabal agɨl tɨkɨlak agak. Anɨb ak, nɨbi mɨdupsek gos yɨp nepɨm ak kelɨgɨl, pɨlɨk amnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pen yad kumɨl tɨkjakɨl, Galili plopens ned amnɨgayn, nɨbi kɨdek nɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Agek, Pita pen agak, Bɨ kuŋay yɨbɨl nep kelɨgɨnɨgel tek lup ak pen, yad nep ma kelɨgɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Agek, Jisas agak, Yad nep nɨŋɨd agebin, maynab ayaŋ kakaluk suk omɨŋal ma agɨnɨgab won ak agɨnɨgaban, Jisas nop ma nepin agɨl, won omɨŋal nokom agɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Agek, Pita kɨles yɨbɨl gɨl agak, Mel, yad nad ayɨp kumnɨgul ak pen, yad nep ma nepin ma agɨnɨgayn agak. Jisas bɨne mɨdupsek, Pita agak tek nep agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pen Jisas bɨne okok ayɨp man olap amjakɨlak, yɨb Getsemani apal. Amjakɨl kɨlop agak, Nɨbi sɨŋawl besɨg mɨdem, yad am Bapi nop agin agak. ");
INSERT INTO taw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Anɨb agɨl, Pita, Jemis, Jon kɨlop poŋɨd amɨl, won anɨb anep chɨbol yul awl yɨbɨl nɨgak. ");
INSERT INTO taw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Pen kɨlop agak, Mɨdupmɨdup yɨp puŋɨl ñeb ak, kumnɨm tek lup agak. Nɨbi awl mɨdɨl, yɨp kod mɨdɨl nɨgtep gɨl yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Anɨb agɨl, ne yep wulep anɨb sɨŋak amɨl, apyap kɨnɨl jomulɨk ak lum ayaŋ lɨl, God nop agnɨŋɨd agak, Bapi, kanɨb olap yownɨmuŋ ak, tap yɨp gɨnɨgeb ak ma gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Apa, Bapi, nad Bɨawl mɨdeban tek, tɨtay gɨnɨg, gɨnɨgaban agak. Tap yɨp gɨnɨgeb ak ma gɨnɨmuŋ agak. Pen gos yad nepin tek ma gɨnɨmɨn, gos nak ke nepan adek ak gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anɨb agɨl, adɨkɨd apɨl nɨgak, bɨne okok pɨsnep kɨnelak. Pen Pita nop agak, Saymon, taynen kɨneban agak? Tapɨn won olap nɨg yenɨmɨn tek ma lup agak? ");
INSERT INTO taw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chɨn tap tɨmel ma gɨnɨgun agɨl, God nop agɨlɨg yenɨmɨb agak. Gos nɨbi ak gɨnɨmɨb tek lup ak pen, mubwak anep kɨles ma gup agak. ");
INSERT INTO taw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Anɨb agɨl, adɨkɨd amɨl, Nap nop ned agak tek, tep ak agak. ");
INSERT INTO taw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pen adɨkɨd apɨl nɨgak, wɨsɨn apek pɨsnep kɨn amnɨlak. Nɨŋɨd, kɨlop agak, Nɨbi kɨnebɨm agak? Agek, sɨskol dɨl, pen agɨnɨgel tek ma lak. ");
INSERT INTO taw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Pen kɨdek amɨl adɨkɨd apɨl, bɨne okok kɨlop agak, Nɨbop kɨles ma gek kɨn mɨdebɨm akaŋ agak? Tɨkjakem amnun agak. Mɨñɨl tep agak. Won anɨb ak Bɨ Olap Ñɨne nop chen mɨmug gɨ dad amnɨgeb agak. Bɨ yɨp mɨmug nɨgup ak, bɨ tap si tap tɨmel gɨpal okok yɨp ñɨn adek kɨli ak ñɨnɨg, kɨlop poŋɨd apeb awl agak. ");
INSERT INTO taw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas anɨb agaknɨŋ, bɨne anep umɨgan olap Judas apjakak. Pen bɨ God nop sɨbogep bɨawl okok, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok, Juda bɨawl okok kɨli agɨlak tek, bɨ ogɨnap kɨlop poŋɨd apjakak. Bɨ kuŋay yɨbɨl poŋɨd owak anɨb okok, baynat ogɨnap, kul awl ogɨnap sek dɨl, ne ayɨp owlak. ");
INSERT INTO taw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pen wulep wulep gɨlɨg, Judas bɨ chen mɨmug gep ak, ne bɨ anɨb okok kɨlop agak, Bɨ an kaykol gɨnɨgayn anop, chɨchɨk dɨl dad nag lɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pen Jisas yek sɨŋak amjakɨl, won anɨb ak agak, Tisa agak. Anɨb agɨl, nop kaykol gak. ");
INSERT INTO taw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Anɨgek, bɨ ogɨnap apɨl Jisas nop chɨchɨk dɨl nag lɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Anɨgɨlaknɨŋ, bɨ olap Jisas yek wulep sɨŋak jakɨl yek, baynat ne ak lɨpɨg dɨl, bɨ God nop sɨbogep bɨawl yɨbɨl ak wog gɨñeb ne olap anop, tɨmud pɨskɨd ak pɨsnep tɨbɨlɨk yokak. ");
INSERT INTO taw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pen Jisas nop anɨgɨl chɨchɨk delak agak, Yad bɨ tap si dɨl mɨden tek, baynat, kul awl okok sek anɨgɨl dapɨl yɨp chɨchɨk debɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pel God agnɨgep kal awl kab wali kus gɨl yek ak amɨl, nɨb ayɨp mɨdɨl, binɨb takaw agñɨbin ak pen, yɨp ma dɨpɨm agak. Pen mɨñɨl gɨnɨgab agɨl, buk Baybol tɨkɨlak tek gebɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pen Jisas nop anɨgɨl dɨlaknɨŋ, bɨne okok nop kelɨgɨl, mɨdupsek pɨlɨk amdɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bɨ pɨlaj olap, mɨneyɨl chech pal yɨbɨl yɨmɨl Jisas nop kɨdek gɨl, Jisas nop dad amelak ak kɨdek amek, nop abe chɨchɨk dɨlak ak pen, ");
INSERT INTO taw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","chech pal ne ak kelɨgɨl, day nep pɨlɨk amnak. ");
INSERT INTO taw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pen kɨli Jisas nop dad bɨ God nop sɨbogep bɨawl yɨbɨl kal ne ak amnɨlak. Dad amelak, bɨ God nop sɨbogep bɨawl okok dɨl, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok dɨl, Juda bɨawl okok dɨl, kal anɨb ak apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pen Pita loslos lɨ dad amɨl, bɨ God nop sɨbogep bɨawl yɨbɨl kal ne ak amjakɨl, wali mɨgan ayaŋ amɨl, bɨ kal anɨb ak kod mɨdeb okok ayɨp besɨgɨl, mab mɨŋɨl lɨlɨg yelak. ");
INSERT INTO taw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pen bɨ God nop sɨbogep bɨawl okok sek, bɨ Juda bɨawl takaw tɨg asɨkep okok sek, kɨli Jisas gɨ ajolɨgup takaw jɨj olap dɨl nop ñaglun agɨlak ak pen, pɨyow mel nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bɨ ogɨnap dad apel, kuŋay yɨbɨl yepɨs agɨlak ak pen, takaw anɨb okok, okok nɨb okok nɨb agel, nop chɨgɨnɨmuŋ tek ma lak. ");
INSERT INTO taw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pen ogɨnap tɨkjakɨl yepɨs agɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Chɨn nɨg mɨdon ne agak, God agnɨgep kal awl ak ñɨn mɨdup dɨl gɨlak awl, tɨbɨlɨk yokɨl, ñɨn omɨŋal nokom mɨdɨl, tep ak gɨnɨgayn agak agɨlak. Ñɨn mɨdup dɨl gɨpal tek ak ma gɨnɨgayn agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pen takaw agɨlak anɨb ak abe, okok nɨb okok nɨb agel, nop chɨgɨnɨmuŋ tek ma lak. ");
INSERT INTO taw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bɨ God nop sɨbogep bɨawl yɨbɨl ak, ne bɨ nɨg mɨdelak wɨdɨn mɨdup adek sɨŋak tɨkjakɨl, Jisas nop agnɨŋɨd agak, Takaw nep apal ak, pen ma agɨnɨgaban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Agek, Jisas takaw olap pen ma yɨbɨl agek, tep ak agnɨŋɨd agak, Nad Bɨ God nop aglup ak, Bɨawl teplep Ñɨne yɨbɨl mɨdeban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Agek, Jisas agak, Yaw, nɨm yad nep agak. Pen Bɨ Olap Ñɨne, ne God bɨ kɨles tɨmel mɨdeb ak ñɨn yɨpɨd kɨd okok ken besɨg mɨdɨl, wɨsɨp adek alaŋ nɨb lum awl apek nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Anɨb agek, bɨ God nop sɨbogep bɨawl yɨbɨl anɨb ak, taynen God nop agjulɨg anɨb agosup agɨl, chech ne ke tɨb talɨkɨl agak, Taynen bɨ ogɨnap sek kɨlop agon apɨl tap ne gup okok agɨnɨgabal. Mel agak. ");
INSERT INTO taw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ne God nop agjuwek nɨbi nepɨm, tay gos nɨgebɨm agak? Agek, bɨawl takaw tɨg asɨkep okok mɨdupsek kɨli agɨlak, Anɨgɨl agup tek, nop paklep agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Agɨl, bɨ ogɨnap Jisas nop kɨñuk gɨl, chech bad olap dɨ wɨdɨn nop ak pak yu gɨl, pakɨlɨg agɨlak, Agan, nep an pakeb agɨlak. Anɨb agelak, bɨ kal anɨb ak kod mɨdeb okok kɨli nop dɨl tapɨn nep pakɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pen bin pɨñ, bɨ God nop sɨbogep bɨawl yɨbɨl anop wog gɨñeb olap yek. Pita ne besɨgɨl seŋ sɨŋak mab muŋɨl mɨdaknɨŋ, bin anɨb ak ne apjakɨl, Pita nop nɨŋɨd, nɨŋɨjsek lɨl agak, Nad abe Jisas bɨ Nasalet nɨb ak ayɨp yesɨpan agak. ");
INSERT INTO taw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Agek, Pita agak, Nak tay ageban. Takaw ageban ak ma nepin agak. Anɨb agɨl, wali mɨgan ak seŋayaŋ amɨl, kanɨbtub bak okok yek, kakaluk suk agak. ");
INSERT INTO taw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bin anɨb anep, Pita nop tepayaŋ nɨŋɨd, bɨ jakɨl yelak okok kɨlop agak, Bɨ nɨm awl abe Jisas bɨne olap agak. ");
INSERT INTO taw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Agek agak, Yad mel agak. Tapɨn won olap mɨdɨl, bɨ jakɨl yelak anɨb okok Pita nop tepayaŋ agɨlak, Nɨŋɨd apun, nak abe Galili plopens nɨb ak, bɨ kɨli olap agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Agelak Pita kɨles gɨl agak, God nɨg mɨdeb, yepɨs agen yɨp paklɨnɨmuŋ agak. Nɨŋɨd yɨbɨl apin, bɨ anɨb apɨm ak yad ma nepin agak. ");
INSERT INTO taw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Anɨb agaknɨŋ, kakaluk ak tepayaŋ suk agak. Agek, Pita gos ak nɨgak, Jisas ned agak, Kakaluk omɨŋal suk ma agɨnɨgab won ak agɨnɨgaban, Jisas nop ma nepin agɨl takaw won omɨŋal nokom agɨnɨgaban agak. Takaw ak gos nɨgek, chɨb gek chag awl lak. ");
INSERT INTO taw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Man tɨkaknɨŋ, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Juda bɨawl okok sek, bɨ Juda bɨawl takaw tɨg asɨkep okok mɨdupsek, kɨli apnan gɨl yelak. Yelaknɨŋ, takaw ag adek nokom lɨl, Jisas nop nag lɨl, dad gapman bɨawl Paylat yek ak amɨl, Paylat nop ñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ñel, Paylat Jisas nop agnɨgak, Nak Juda bɨnonɨm kɨli ak akaŋ agak? Agek, Jisas agak, Nɨm nak apan ak agak. ");
INSERT INTO taw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pen bɨ God nop sɨbogep bɨawl okok, kɨli Jisas nop ag gɨl takaw kuŋay agelak, ");
INSERT INTO taw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Paylat Jisas nop tepayaŋ agnɨgak, Nep takaw kuŋay agebal ak, pen takaw olap ma agɨnɨgaban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Agek, Jisas takaw ma yɨbɨl agek, Paylat gos pal lak. ");
INSERT INTO taw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pen Juda binɨb ñɨn awl kɨli ak apek nɨŋɨd, bɨ dɨ nag lelɨgɨpal okok, nokom olap nop bɨawl Paylat sap yeb nokom nokom agyokolɨgup. Binbɨ kɨli ke bɨ nag lel yolɨgup ak yɨb nop agel, Paylat nop agyokek amolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pen ñɨn anɨb ak, bɨ olap yɨb ne Balabas, binɨb ogɨnap dɨl, Lom gapman ayɨp penpen gɨl chɨp ñagɨlak tek, kɨlop dɨ nag lel yelak. ");
INSERT INTO taw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Binɨb okok apnan gɨl, Paylat nop bɨ dɨ nag lep olap pel agnɨgelɨgɨpal tek agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Agnɨgel pen agak, Juda bɨnonɨm anɨb ak, nɨbop wɨsɨb yokɨnɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ne ke nɨgak, bɨ God nop sɨbogep bɨawl okok, kɨli Jisas nop yokɨp mɨlɨk nɨgɨlak tek dap Paylat nop ñɨlak ak tek ak, anɨgɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pen bɨ God nop sɨbogep bɨawl okok, kɨli binɨb okok kɨlop agɨlak, Paylat nop agem, Balabas nop wɨsɨb yokɨl, Jisas nop age yonɨmuŋ agem agɨlak. Agelak, binɨb anɨb okok chɨbol kɨlop ak tɨmel gek, Paylat nop agɨlak, Balabas nop chɨnop wɨsɨb yokɨnɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Anɨb agelak, Paylat kɨlop pen agɨl agak, Bɨ anɨb ak, Juda bɨnonɨm apɨm ak, nop tay gɨnɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Agek, kɨli meg mɨgan dad aplanɨl agɨlak, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Agelak, Paylat agak, Ne tap tay tɨmel gek, anɨgɨnɨm agak? Agek, kɨli meg mɨgan dad aplanɨl suk awl agɨl agɨlak, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Agɨlak anɨb ak, binɨb okok kɨlop tep gɨnɨmuŋ agɨl, Paylat Balabas nop wɨsɨb yokak. Pen bɨ chɨm kadɨŋ gep ne ogɨnap kɨlop agek, Jisas nop nag kɨles tɨmel dɨl tapɨn nep pakɨl, dam mab bak alaŋ chɨpɨl pak tɨbɨk lɨnɨg amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anɨgek, bɨ chɨm kadɨŋ gep okok Jisas nop dad Lom gapman bɨawl kal ne ak wali mɨgan ak amɨl, bɨ chɨm kadɨŋ gep okok mɨdupsek kɨlop suk agel owlak. ");
INSERT INTO taw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Apel, chech nɨkɨm palawl gapman bɨawl okok lɨpal tek ak dad apɨl, Jisas nop lɨñɨlak. Lɨñɨl, nag ñuñu sek ogɨnap tɨk dad apɨl, bɨnonɨm poj lɨpal tek olap gɨl, kɨmɨg alaŋ lɨñɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lɨñɨl, anɨb agɨlak, Nad nɨm bɨawl yɨbɨl, Juda bɨnonɨm kɨli ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Anɨb agɨl, nop kul dɨl kɨmɨg alaŋ kuŋay yɨbɨl pakɨlɨg, kɨñuk gɨñɨlɨg yelak. Yek jɨj sɨŋak kɨgom yɨmɨl, kɨmɨg kuyan gɨl, yepɨs agɨl yɨb nop dad aplanɨlɨg yelak. ");
INSERT INTO taw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nop anɨgɨl agjuwɨl, chech nɨkɨm palawl nop lɨñɨlak ak tɨg asɨk dɨl, chech ne ke ak lɨñɨlak. Lɨñɨl, mab bak alaŋ chɨpɨl pak tɨbɨk lɨnɨg poŋɨd amnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kɨli nab okok amɨlɨg, bɨ olap Saymon, taun Saylini nɨb ak, okok ajɨl apɨl Jelusalem amnɨg gek, nop nebeŋ pakɨl takaw kɨles agɨl agɨlak, Mab Jisas dad apek ak, nad dad amnoŋ agɨlak. Bɨ Saymon anɨb ak, ñɨne omɨŋal ak, Aleksada ayɨp Lupus ayɨp. ");
INSERT INTO taw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pen anɨgɨl amɨl, Jisas nop dad man chɨp kɨmɨg cheg won apal ak, yɨb Golgota ak amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Amjakɨl, ñɨg wayn ak sek, mab Mul apal mok ak sek dɨl nop ñɨlak ak pen, ma ñɨŋak. ");
INSERT INTO taw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Pen subnab sɨŋ apel owak won ak, nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak. Tɨbɨk lɨl, chech nop okok tɨg asɨk dɨl dayday lɨpɨgɨl agɨlak, Mel, sadu tek gɨl dun agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pen mab bog bad olap, Jisas nop chɨpɨl pak tɨbɨk lɨl ak mab bak alaŋ yɨb gɨlɨl agɨlak, Juda bɨnonɨm kɨli ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Bɨ tap si dep omɨŋal ak abe mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak. Bɨ omɨŋal ak, olap ñɨn yɨpɨd pɨs ak, olap ñɨn aŋɨd pɨs ak chɨpɨl pak tɨbɨk lɨl, Jisas nop nab ayaŋ pak tɨbɨk lɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Binɨb okok kɨli aplan apyan gɨlɨg, Jisas nop nɨŋɨd kɨmɨg golmal gɨl, nop agjulɨg agɨlak, Ey. Yad God agnɨgep kal awl ak tɨbɨlɨkɨl, ñɨn omɨŋal nokom tepayaŋ gɨnɨgayn apan ak, ");
INSERT INTO taw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mab bak alaŋ kelɨgɨl lum ayaŋ owan agɨlak. Mɨñɨl nad ke gɨl koŋɨm amnoŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, kɨli ke agɨlɨg, abe Jisas nop agjuwɨl agɨlak, Binɨb ogɨnap kɨlop gek koŋɨm abal ak pen, ne ke anɨgɨnɨmuŋ tek ma lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pel ne agup, Yad Bɨ God nop aglup ak, Yislel binɨb bɨnonɨm kɨli mɨdebin agup tek, mɨñɨl nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨpal ak, ke gɨl koŋɨm amek yɨl, chɨn nɨŋɨd nop gos lɨnɨgɨnɨgun agɨlak. Pen bɨ Jisas ayɨp mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak omɨŋal ak, nop abe agjulek. ");
INSERT INTO taw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Subnab awl alaŋ won ak kɨsɨlɨm apɨl, mɨd dad amɨl, sub yɨpɨd gak won ak tepayaŋ pen mɨlek gak. ");
INSERT INTO taw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pen sub yɨpɨd gak won ak, Jisas suk awl agɨl agak, Eloy, Eloy, lema sabaktani agak. Takaw agak anɨb ak, jɨj ne ak agak, God yad ak, God yad ak, yɨp taynen kelɨgɨpan agak. ");
INSERT INTO taw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Agek, binɨb wulep anɨb sɨŋak jakɨl yelak okok nɨŋɨd anɨb agɨlak, Nɨgɨm, Yilayja nop suk ageb agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pen bɨ olap kasek amɨl, tap olap ñɨg dak tap ak olap dɨl, ñɨg wayn sɨlek ak mɨgan ayaŋ tawak. Tawek amek, Jisas nop yɨmug nɨŋɨd ñen ñɨŋaŋ agɨl, sɨd pal ak dɨl kabes ñagɨl, yek alaŋ ñɨlɨg agak, Chɨn nɨg mɨdon, Yilayja apɨl, nop tɨg asɨk dam lum ayaŋ lɨnɨgab akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Anɨb agɨl nɨg yelaknɨŋ, Jisas suk awl agɨl kumak. ");
INSERT INTO taw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Won anɨb anep, God agnɨgep kal awl ñɨluk mɨgan ayaŋ chech kanɨbtub pɨl gɨlak ak, day alaŋ nɨb lak dam day ayaŋ yokɨl, talɨkɨl pɨspɨs amnak. ");
INSERT INTO taw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lom bɨ chɨm kadɨŋ gep bɨawl kɨli olap, mab bak nab okok yɨl sɨŋak jak mɨdɨl nɨgak, Jisas anɨgɨl kumak. Anɨgɨl kumek nɨŋɨd, anɨb agak, Nɨŋɨd apal, bɨ anɨb ak God Ñɨne yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Pen bin Jisas ayɨp Jelusalem owlak ogɨnap apɨl, gol sɨŋak yelak. Nab kɨli okok, omɨŋal nokom Jisas nop kɨdek gɨlɨg wog ogɨnap gɨñelɨgɨpal, Galili plopens. Maliya omɨŋal. Bin yɨb alog omɨŋal anɨb ak, olap taun Makdala nɨb, olap bɨ Jemis nɨmam kɨdek ayɨp, bɨ Joses ayɨp nonɨm kɨli ak. Bin olap yɨb ne Salome. Bin anɨb okok mɨdupsek nɨg yelaknɨŋ, Jisas kumak. ");
INSERT INTO taw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jisas kumak ñɨn ak, tap dap nan gep ñɨn ak, Juda ñɨn awl ak ownɨg gak. Dugep won ak gɨnɨg gaknɨŋ, bɨ olap ne Jisas nop dam kamnɨg, ma pɨlɨkɨl Paylat yek ak amɨl agnɨgak. Bɨ anɨb ak, man sɨkol Alimateya nɨb owak, yɨb ne ak Josep. Ne Juda bɨawl takaw tɨg asɨkep olap mɨdɨl, bɨ teplep ak yɨb teplep yɨbɨl yolɨgup. Pen God binɨb dɨl kɨlop kod yenɨgab ñɨn ak kod yolɨgup. ");
INSERT INTO taw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Josep ne Paylat nop agnɨgek, Paylat Jisas won akal kumub agɨl judɨl, Lom bɨ chɨm kadɨŋ gep bɨawl anop agek apek agnɨgak. ");
INSERT INTO taw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Agnɨgek agak, Mɨneyɨl kumub agak. Anɨb agek, Paylat Josep nop agak, Dam kamnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Agek, Josep chech kayɨg palawl olap tawɨl, Jisas nop tɨg asɨk dad apyapɨl, chech ak dɨ kam sɨlokɨl, dam kab mɨgan tɨdamɨgɨl kɨdeyɨl dɨlak ak kamak. Kamɨl, kab awl olap tɨg mɨmlokek apek, kaw tub ak pɨl gak. ");
INSERT INTO taw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pen Maliya taun Makdala nɨb ak ayɨp, Maliya Joses nonɨm ayɨp nɨg yɨleknɨŋ nop kamak. ");
INSERT INTO taw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juda añɨŋ lep ñɨn awl ak apɨl padɨkek, Maliya taun Makdala nɨb ak, Maliya Jemis nonɨm ak, bin Salome ak, kɨli Jisas wak nop ak wel lɨñɨnɨgun agɨl, am wel kuy tep owep ak taw dap lɨl kɨnɨlak. ");
INSERT INTO taw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mɨnek Sande ñɨn ak man tɨkak won ak tɨkjakɨl, Jisas nop kamak adaŋ amnɨg saŋɨdɨlak. Nab okok amɨlɨg, sub aplan jakɨnɨg gak won ak, ");
INSERT INTO taw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kɨli nep agnɨg agnɨg gɨl agɨlak, An chɨnop kab awl kaw tub pɨl gup ak, tɨg mɨmlokel dam gol okok lɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Anɨb agɨl amjakɨl nɨgɨlak, kab awl yɨbɨl kaw tub pɨl gak anɨb ak, lɨgam gol okok yek. ");
INSERT INTO taw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nɨŋɨd, mɨgan ayaŋ amɨl nɨgɨlak, bɨ pɨlaj chech kayɨg palawl yɨmak olap, ñɨn yɨpɨd kɨd okok ken besɨg yek. Nop nɨŋɨd ju dɨlak ak pen, ");
INSERT INTO taw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","kɨlop agak, Ma ju dɨnɨmɨb agak. Jisas bɨ Nasalet nɨb, mab bak alaŋ chɨpɨl pak tɨbɨk lel kumak anop nɨgɨnɨg apebɨm agak. Pen nɨgɨm agak. Tep adek nop kamak awl, ne ma mɨdeb. Mɨneyɨl tɨkjakɨl amub agak. ");
INSERT INTO taw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pen Pita sek, Jisas bɨne ogɨnap sek kɨlop takaw anɨb ak agñɨnɨmɨb agak. Anɨb agɨnɨmɨb, Jisas ne ned tɨkjakɨl Galili plopens am yenɨgab, nɨbi kɨdek amɨl nop nɨgɨnɨgabɨm, bɨlel nɨbop agak tek agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Anɨb agek, seŋ amɨl, jel gek pɨlɨkɨl amnɨlak. Pɨlɨk amɨl, binɨb ogɨnap kɨlop takaw olap ma agɨlak. ");
INSERT INTO taw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas kumɨl, Sande mɨnek won ak tɨkjakɨl, ned yɨbɨl Maliya taun Makdala nɨb ak, yek sɨŋak mɨseŋ gek nɨgak. Pen bin anɨb anop, ned kɨcheki anep kugul ak abaŋ lek, Jisas ag seŋ yokak. ");
INSERT INTO taw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Ne Jisas nop nɨŋɨd, am bɨne okok chɨb gek chaŋ lɨlɨg yelak nab ak, amjakɨl agak, Jisas koŋɨm mɨdeb nop nepin agak. Agek pen, takaw nop ak ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mɨnek olap pen, Jisas bɨne omɨŋal man wakay olap gɨ ajel, Jisas bɨ ak ke tek lɨl apɨl, kanɨb nab ak tepayaŋ mɨseŋ gek nop nɨgɨlek. ");
INSERT INTO taw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nɨŋɨd, am bɨne ogɨnap kɨlop agñel, abe nɨŋɨd agebil agɨl ma nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pen mɨnek olap, Jisas bɨne anep agɨp ak tap ñɨŋɨlaknɨŋ nab sɨŋak tepayaŋ mɨseŋ lɨl, kɨlop ag gɨlɨg agak, Nɨbi yɨp ma gos lɨnepɨm agak. Chɨbol nɨbop ak ma asɨkup agak. Tɨkjakɨpin binɨb ogɨnap mɨseŋ nɨŋɨd agel, taynen bɨ anop nɨŋɨd tɨkjakup agɨl gos ak ma nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Anɨb agɨl kɨlop agak, Takaw teplep yad ak dad man okok mɨdupsek amɨl, binɨb okok mɨdupsek agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Agñem, binɨb an yɨp gos lɨnɨŋɨd, ñɨg pakñenɨgab ak, God nop tɨg asɨk dɨnɨgab agak. Pen binɨb an yɨp gos ma lɨnɨgenɨgab ak, God nop ag gɨl, yul awl ak ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Binɨb yɨp gos lɨnɨgɨnɨgabal okok, tap mageptek ogɨnap gɨnɨgabal agak. Yad ayɨp mɨdɨl, binɨb kɨcheki abaŋ lɨnɨgab okok kɨlop, ag seŋ yokɨnɨgabal agak. Takaw yɨbɨl kɨli ak mɨdaknɨŋ, takaw kɨdeyɨl olap ke yɨbɨl agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yoy salaw tap binɨb suwup okok dɨnɨgel, kɨlop gɨ tɨmel ma gɨnɨgab agak. Tap tɨmel ñɨbɨl kubal tek, ñɨbɨl ak ma kumnɨgabal agak. Pen binɨb tap gɨnɨgab okok kɨlop, ñɨn mɨdup dɨnɨgel suŋ lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pen Bɨawl Jisas takaw anɨb ak kɨlop agjuwaknɨŋ, God nop dad man ne alaŋ amnak. Dad amek, ñɨn yɨpɨd kɨd ak besɨgɨl mɨdeb. ");
INSERT INTO taw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pen bɨne okok takaw teplep ak man okok kɨd kɨd agñel amnak. Amnaknɨŋ, Bɨawl ak ne takaw anɨb ak binɨb okok nɨŋɨd agebal agɨl, bɨne okok kɨlop kod mɨdaknɨŋ, tap mageptek okok gelɨgɨpal.");
INSERT INTO taw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2"," Bɨawl Tiyopilus. Nab chɨnop awl God ne tap okok keke gak tek, bɨ ogɨnap wɨdɨn nɨŋɨd, takaw anɨb ak dad okok okok am agñɨlak. Agñelak bɨ kuŋay nɨŋɨd, kesɨm nokom anɨb ak keke ñu kɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Yad gos nepin, nad takaw nep agñɨbal ak nepan. Yad pen tap okok ned gak tek, pelpel takaw jɨj anɨb ak pɨyow nɨŋɨd nepin ak nɨm, abe ñu kɨl tɨkɨnɨgebin. Takaw jɨj nɨŋɨd yɨbɨl ak nɨgɨnɨmɨn agɨl, nep ñu kɨl tɨkɨnɨgebin. ");
INSERT INTO taw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ned gapman bɨnonɨm Helod Judiya plopens kod yolɨgup ñɨn ak, bɨ God nop sɨbogep wog ak gɨ mɨdolɨgup, yɨb ne Sekalaya. Bɨne ayɨp wog jɨmñɨl gep mɨdelɨgɨpal ak kɨlop, Abayja bɨne agelɨgɨpal. Sekalaya bin ne Elisabet. Nop abe bɨ God nop sɨbogep Elon jɨj ak tɨk dad amɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kɨli bel God takaw adek ak mɨdupsek nɨŋɨd kɨdek gɨl mɨdel, God nɨgek takaw olap ma yek. ");
INSERT INTO taw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pen Sekalaya bin ne Elisabet ñapay wom. Kɨli bel ñapay olap ma tɨkɨlek, pɨsnep yɨbɨl mɨlep lɨlek. ");
INSERT INTO taw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ñɨn akal Sekalaya bɨne ayɨp wog jɨmñɨl gelɨgɨpal okok, God nop sɨbogep wog gɨnɨg gelɨgɨpal, kɨli tɨkjakɨl mɨdelak. Bɨ an yɨb aplanɨmuŋ, God agnɨgep kal awl mɨgan bɨ sɨbogep nop, ameb kal mɨgan amɨl tap kuy tep owep ak dagɨlɨnɨmuŋ agɨl kɨli jakɨl nɨg mɨdelak. Abayja bɨne okok God nop sɨbogep ñɨn ak apek nɨŋɨd, kɨli gelɨgɨpal anɨb okok jak nɨg mɨdelak, Sekalaya yɨb ak aplanak. ");
INSERT INTO taw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Binbɨ kuŋay yɨbɨl God agnɨgep kal awl seŋayaŋ mɨdɨl God nop agɨlɨg mɨdelak nɨŋɨd, ne amɨl tap kuy tep owep dagɨlɨnɨg kal mɨgan amnak. ");
INSERT INTO taw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pen God ensel ne olap apɨl tap kuy tep owep dagɨl lep abañ adek anɨb ak, ñɨn yɨpɨd kɨd okok ken yek. ");
INSERT INTO taw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekalaya nɨŋɨd, ju dɨl pɨlɨkek ");
INSERT INTO taw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ensel ak nop agak, Ma pɨlɨkɨnɨmɨn agak. God nop apan ak, nep nɨgup. Bin nak Elisabet ñɨ olap tɨkɨnɨgab agak. Tɨkek, yɨb nop Jon agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nep ke tep gek, mɨñmɨñ awl yɨbɨl gɨnɨgaban agak. Ne ownɨgab ak, binɨb kuŋay yɨbɨl mɨñmɨñ gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ne bɨawl yɨbɨl ak God wɨdɨn mɨdup adek sɨŋak yenɨgab agak. Ñɨg wayn ogɨnap sek, ñɨg kɨles ogɨnap sek ma ñɨŋɨnɨmuŋ agak. Bin nad ne ñapay kogmeg mɨdek, God Kawnan ne ak ñapay nab ayaŋ amɨl ayɨp yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yislel binɨb God nop kelɨgɨpal okok, kɨlop agtep gek tep ak adɨkɨd God Bɨawl kɨli yɨl ownɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pen ne ned amek, Bɨawl kɨdek amnɨgab agak. Bɨ God gos ñek agñeb Yilayja bɨlel God kɨles ñek golɨgup tek ak gɨnɨgab agak. Nap sɨkop kɨlop dɨl, ñapay sɨkop kɨlop dɨl, dɨ jɨmñɨl lɨnɨgab agak. Binɨb God nop aleb aleb ñɨbal okok agtep gek, binɨb teplep yɨbɨl ne okok gos nepal tek nɨŋɨd, mɨdtep gɨl, bɨawl ownɨgab agɨl kod yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ensel ak anɨb agek, Sekalaya agak, Chɨl mɨlep yɨbɨl lɨpul. Anɨb ak nad tɨtay de yad nɨŋɨd anɨb agɨnɨm, Nad nɨŋɨd apan agɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Agek, ensel ak nop agak, Yad Gabliel. Yad God ayɨp pelnep mɨdobul agak. Ne yɨp agyokek apɨl, takaw teplep anɨb ak nep agñɨnɨg dad opin agak. ");
INSERT INTO taw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nad takaw yad ma nepan tek, yalɨb nep ak mɨŋel gek takaw agɨlɨg ma yenɨgaban agak. Yokɨp nep mɨd mɨd, ñɨ ak tɨkɨl dapɨl, tepayaŋ takaw agɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pen Sekalaya ne God agnɨgep kal awl mɨgan ak am pelnep yek, binɨb seŋayaŋ yelak ak gos kuŋay yɨbɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kɨdek seŋayaŋ apɨl, takaw olap ma agak. Yɨp anɨgɨl anɨgɨl gup agɨl, ñɨn anep yomek, kɨli nɨŋɨd anɨb agɨlak, Ne kal mɨgan ayaŋ am mɨdɨl, tap olap ke nɨŋɨd owup agɨlak. Ne takaw ma agak, yokɨp nep yek. ");
INSERT INTO taw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pen kɨdek wog gep ñɨn ak gɨjuwɨl, kal ne amnak. ");
INSERT INTO taw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Kɨdek mɨd dad amɨl, bin ne Elisabet ñapay kogmeg yek agak, Ned bin ñapay wom yelɨgɨpin, yɨp nebeŋ gup agak. Mɨñɨl pen Bɨawl ak yɨp mapen nɨŋɨd kod mɨdek, ñapay kogmeg mɨden yɨp tep gup, nebeŋ ma gup agak. Anɨb agɨl takan anep mamɨd ak we gɨl yolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet takan anep kagol ayaŋ ñapay kogmeg mɨdɨl, God ensel Gabliel nop agyokek taun Nasalet, Galili plopens amnak. ");
INSERT INTO taw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Taun Nasalet anɨb ak, bin pɨlaj olap yolɨgup, yɨb ne Maliya. Bin pɨlaj anɨb ak bɨ olap ayɨp ma kɨnelɨgɨpil. Pen bin anɨb ak Josep nop lɨlak. Bɨ anɨb nop, bɨnonɨm Depid tɨkɨl tɨk dad amɨl tɨkɨlak. God ensel Gabliel nop agyokek bin pɨlaj anɨb ak yek ak amnak. ");
INSERT INTO taw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amɨl agak, Maliya mɨdeban? God nep dɨtep gup agak. Ne ayɨp mɨdebil agak. ");
INSERT INTO taw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anɨb agek, Maliya takaw anɨb ak nɨŋɨd, yɨp taynen anɨb agup agɨl gos kuŋay nep nɨgak. ");
INSERT INTO taw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nɨgek ensel ak nop agak, Maliya. Ma pɨlɨkɨnɨmɨn. God nep dɨtep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nad ñapay kogmeg yenɨgaban, ñɨ olap tɨkɨnɨgaban agak. Tɨkɨl, yɨb nop Jisas agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pen ne bɨawl yɨbɨl yenɨgab agak. God adek alaŋ mɨdeb ne agɨnɨgab, Ñɨ yad agɨnɨgab agak. God gek, ne nɨsed yes Depid, bɨnonɨm yolɨgup tek ak mɨdenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nɨbop Jekop tɨkɨl tɨk dad amɨl tɨkɨpal mɨdebɨm okok, mɨdupsek pelnep yɨbɨl kod yenɨgab ma kelɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Anɨb agek Maliya agak, Yad bɨ olap ayɨp ma mɨdobul ak, tɨtay dɨl ñapay anɨb ak tɨkɨnɨgayn agak? ");
INSERT INTO taw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Agek ensel ak nop agak, God Kawnan ak nep apɨl, God adek alaŋ mɨdɨl kɨles ne ak nep yu gɨñɨnɨgab agak. Ñapay suŋtep yɨbɨl ak tɨkɨnɨgaban ak, God ne agɨnɨgab, Ñɨ yad agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nɨgan. Namud Elisabet ne bin mɨlep yɨbɨl lup, kɨli ne bin ñapay wom agelɨgɨpal ak pen, mɨñɨl ne ñapay kogmeg mɨdeb takan anep kagol ayaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God tap mageptek olap ma mɨdeb. Tap okok mɨdupsek gɨnɨgab anep mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Anɨb agek Maliya agak, Tep. Yad God nop wog gɨñeb bin ak, ageban tek yɨp gɨnɨgab ak, tep yɨbɨl agak. Anɨb agak nɨŋɨd, ensel ak nop kelɨgɨl adɨkɨd amnak. ");
INSERT INTO taw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Won olap mɨdɨl Maliya amnin agɨl, tap ne okok dɨl tɨkjakɨl kasek Judiya plopens man dum okok kanɨb pal ak am am, ");
INSERT INTO taw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekalaya kal ak amjakak. Amjakɨl kal mɨgan ayaŋ amɨl nɨmud Elisabet nop agak, Nad mɨdeban agak? ");
INSERT INTO taw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Agek nɨŋɨd, nɨmud Elisabet ñapay nab ayaŋ yek ak kaskas gak. Pen God Kawnan ak ap Elisabet nop bak lek, ");
INSERT INTO taw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet takaw awl agɨl, Maliya nop agak, God bin ogɨnap kɨlop kod mɨdeb ak pen, nep gɨtep gup ke tep mɨdeban agak. Ñapay kogmeg nab ayaŋ mɨdeb ak abe kod mɨdeb nop gɨtep gup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yad taydɨl tek mɨden, Bɨawl chɨn ak nonɨm ak yad yɨl apek nɨgebin agak? ");
INSERT INTO taw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nad apɨl, yɨp Mɨdeban age, won anɨb ak ñapay kogmeg yad ak mɨñmɨñ gɨl kaskas gup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pen God nep agup tek gɨnɨgab agɨl nepan ak, tep yɨbɨl agɨl mɨñmɨñ gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Elisabet anɨb agek Maliya agak, God nop gos nepin, yɨp tep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kawnan yad abe God nop mɨñmɨñ gup, ne bɨ kasɨn gep yad agak. ");
INSERT INTO taw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yad bin yokɨp wog gɨñeb ne ak pen, yɨp sawl ma gup, yɨp nɨŋɨd dup agak. Anɨgup ak, mɨñɨl tɨkɨl kɨdek binɨb okok mɨdupsek yɨp agɨnɨgabal, God bin anɨb ak nop dɨtep yɨbɨl gup agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God bɨawl tap okok mɨdupsek gup ak, yɨp dɨtep yɨbɨl gup agak. Ne bɨ suŋtep yɨbɨl, anɨb ak ke yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Binɨb takaw nop nɨŋɨd, ñawl dɨl kɨdek gɨnɨgabal okok, kɨlop mapen nɨŋɨd dɨnɨgab agak. Ñapay kɨli tɨkel tɨkel amnɨgab okok takaw nɨŋɨd kɨdek gɨnɨgabal okok, kɨlop abe dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ne bɨ ñɨn palawl yɨbɨl agak. Binɨb kɨli chɨn ke binɨb awl mɨdobun apal okok, kɨlop yuk yokup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anɨb ak, binɨb yɨb mɨdeb okok keke amnɨlak agak. Binɨb yɨb ma mɨdeb okok kɨli tep ak dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pen binɨb tap ma mɨdebal okok kɨlop tap kuŋay nep ñub agak. Binɨb tap kuŋay mɨdeb okok yokɨp agyokek abal agak. ");
INSERT INTO taw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","God ne based yes sɨkop kɨlop takaw bɨlel agak ak sawl ma gak agak. Chɨn Yislel binɨb wog gɨñeb ne okok, chɨnop pelnep mapen nɨŋɨd kod yolɨgup agak. Based Eblaham sek, based chɨn ogɨnap sek, ñapay tɨkel tɨkel amnɨgab okok, kɨlop kod yenɨgayn agɨl agak tek chɨnop gup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya takaw anɨb ak agɨl, nɨmud Elisabet ayɨp takan omɨŋal nokom mɨdɨl, kɨdek adɨkɨd kal ne amnak. ");
INSERT INTO taw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ñapay tɨkep ñɨn ak owak nɨŋɨd, ñɨne won ak tɨkak. ");
INSERT INTO taw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","God nop mapen nɨŋɨd kod yek, bin mɨlep yɨbɨl lɨl ñapay tɨkak anɨb ak, binɨb ne okok nɨŋɨd ne ayɨp mɨñmɨñ awl yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pen ñɨ ak tɨkɨl ñɨn anep kugul ak mɨdɨl, ñɨn jel ak kɨli apɨl wak nope tɨbɨlɨkɨnɨg agɨlak, Ñɨ anɨb awl nap Sekalaya yɨb ak tɨŋɨl yɨj gɨl, yɨb nop ak lep agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Agel nonɨm agak, Mel. Yɨb nop Jon agep agak. ");
INSERT INTO taw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Agek binɨb ne okok agɨlak, Bɨne okok, Jon yɨb olap ma mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Anɨb agɨl, nap Sekalaya nop ñɨn anep yomɨl agnɨgɨlak, Nad yɨb nɨm akal nop lɨnɨgaban agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Agnɨgel, nap ñɨn anep yomɨl agak, Yɨp mab bog bad olap dɨl, tap ñu kɨl gep olap sek dowɨm agak. Agek dad apel, adek anɨb ak yɨb tɨkɨl, Yɨb nop ak Jon agak. Anɨgɨl tɨkek nɨŋɨd, kɨli gos kuŋay yɨbɨl nep nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pen won anɨb ak, Sekalaya yalɨb mɨŋel gak ak kelɨgɨl, ned takaw agolɨgup tek agɨlɨg, God yɨb nop ak dad aplanak. ");
INSERT INTO taw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Binɨb yelak okok, gak anɨb ak nɨŋɨd kɨli pɨlɨkɨlak. Takaw anɨb ak yɨg dad Judiya plopens dum okok mɨdupsek yɨbɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Binɨb okok takaw anɨb ak nɨŋɨd gos pal awl yɨbɨl lɨlɨg agnɨg agnɨg gɨl agɨlak, God gek ñapay anɨgɨl tɨkup ak, kɨdek taydɨl tek yenɨgab agɨlak. Kɨli nɨgɨlak, Bɨawl ak ne ayɨp yek. ");
INSERT INTO taw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon nap Sekalaya, God Kawnan ne ak gos ñek, God nop takaw teplep ogɨnap nɨŋɨd kɨlop agñak, ");
INSERT INTO taw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","God Bɨawl chɨn Yislel nɨb mɨdeb agak. Ne apɨl binɨb ne ak gɨñub, anɨgɨl chɨnop dup agak. Anɨb ak yɨb nop ak dad aplanɨgun agak. ");
INSERT INTO taw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Anɨgak ak, bɨ God gos ñek agñeb okok bɨlel agɨlak tek agak. Based Depid, God nop wog gɨñeb bɨ ak, ñapay tɨkek, kɨli pen tɨk dad amɨl apɨl gɨl, nop tɨkɨnɨgebal agak. Bɨawl bɨ kɨles tɨmel olap agyokek tɨkɨnɨgebal agak. Bɨ anɨb ak, bɨ chɨnop kasɨn gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bɨ penpen ñagep okok sek, bɨ gos tɨmel nepal okok sek, chɨnop gɨ tɨmel gɨnɨgab ak pen, bɨawl chɨnop dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ne kɨlop mapen nɨŋɨd dɨtep gup anɨb ak, based sɨkop kɨlop sawl ma gup, gɨnɨgayn agɨl agak tek nep gup agak. ");
INSERT INTO taw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ne based Eblaham nop takaw aglɨl agak. ");
INSERT INTO taw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Anɨb agak, Yad nɨbop kasɨn gen binɨb penpen ñagep okok, nɨbop ma ñagɨnɨgabal agak. Ma pɨlɨkɨnɨgabɨm agak. Gos yɨp ak nɨŋɨd, wog yɨp ak gɨl, binɨb teplep yad okok nep mɨdɨl, mɨnek mɨnek mɨdtep gɨnɨgabɨm agak. Binɨb suŋtep yɨbɨl mɨdɨl, wɨdɨn mɨdup yad adek ak, mɨdtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pen ñɨ yad agak. God Bɨawl yɨbɨl ak ne nep agɨnɨgab, Bɨ God gos ñek agñeb yad agɨnɨgab agak. Taynen? Nad ned amɨl, binɨb okok kɨlop agtep ge, kɨli Bɨawl anop kod mɨdaknɨŋ, kɨdek ne ownɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nad kɨlop agtep ge, kɨli nɨgɨnɨgabal, ne tap si tap tɨmel gɨpal okok tɨg walɨg gɨyokɨl, kɨlop kasɨn gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","God Bɨawl tep binɨb mapen nɨgup ak, mɨlek tep wɨsɨp alaŋ nɨb ak chɨnop yokɨnɨgab agak. Maynab okok ajɨl, gɨdam pakɨl, kumnɨgabun tek lup ak kelɨgɨl, mɨñɨl kanɨb tep gup adek ak ajonɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pen Sekalaya ñɨne Jon, ne awl gɨl gos ne abe kɨles tɨmel gɨl gak. Am man nep binɨb ma yelak nab okok mɨd mɨd, Yislel binɨb yelak wɨdɨn adek sɨŋak owak. ");
INSERT INTO taw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pen Jon nop tɨkɨlak ñɨn nab anɨb ak, Lom gapman bɨnonɨm Ogastas takaw agɨl agak, Binɨb mɨdupsek yɨb kɨlop dɨnɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ned yɨb dɨlak ñɨn anɨb ak, gapman bɨawl Kuliniyus, Siliya plopens binɨb kɨlop kod yek. ");
INSERT INTO taw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pen kɨli anɨgɨl yɨb dɨlaknɨŋ, binɨb man palawl okok nɨb ap yelak okok yɨb dɨnɨg, adɨkɨd kal kɨli keke amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Anɨgel nɨŋɨd, Josep nop Depid jɨj ak tɨk dad amɨl tɨkɨlak tek, ne Maliya nop poŋɨd Galili plopens taun Nasalet kelɨgɨl, Judiya plopens amɨl, bɨnonɨm Depid mɨdolɨgup man sɨkol Betlehem amnak. Pen bin nop takaw aglɨlak anɨb ak, ñapay kogmeg sek mɨdaknɨŋ, poŋɨd yɨb dɨnɨg amnak. ");
INSERT INTO taw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Amjakɨl nɨgak, bɨ okok nɨb okok nɨb kɨnebal kal okok pɨsnep tɨbɨk dak. Anɨgek nɨŋɨd, bulmakaw tap ñɨbelɨgɨpal kal mɨgan ak mɨdɨlek. Mɨdɨleknɨŋ ñapay ñɨŋak, Maliya ñɨ ne ned tɨkak. Tɨkɨl chech day bad ak kab ñɨl, dɨl bulmakaw tap ñɨbelɨgɨpal paws mɨgan ak lak. ");
INSERT INTO taw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pen Maliya Jisas nop tɨkak ñɨn anɨb ak, bɨ chag sipsip mukep okok, ogɨnap maynab ayaŋ kod yelak, Betlehem gol okok. ");
INSERT INTO taw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bɨawl ne ensel olap agyokek owak. Mɨlek awl sek apɨl kɨlop pakñek jel tɨmel gek pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pɨlɨkelak, ensel ak kɨlop agak, Nɨbi ma pɨlɨkɨnɨmɨb agak. Yad nɨbop binɨb okok mɨdupsek takaw tep mɨñmɨñ gep ak dad opin agak. ");
INSERT INTO taw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɨñɨl bin olap ñapay tɨkup, Depid yolɨgup man ak agak. Bɨ kasɨn gep nɨbi ak nop tɨkup agak. Klays bɨ anɨb ak ne bɨawl mɨdep agak. ");
INSERT INTO taw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nop am pɨyow nɨŋɨd nɨgɨnɨgabɨm, nonɨm nop chech day bad ak kab ñɨl, dɨl bulmakaw tap ñɨbelɨgɨpal paws mɨgan ak lek kɨnek agak. Nɨbi nɨŋɨd anɨb agɨnɨgabɨm, Yawe, nɨŋɨd agup agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anɨb agaknɨŋ, ensel kuŋay yɨbɨl nep God man ne alaŋ nɨb kasek apɨl, God nop tep agɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","God ne adek alaŋ mɨdeb ak, yɨb nop ak dad aplanɨgun agɨlak. Binɨb an tek lum awl God kɨlop tep agɨnɨgab, mɨdtep gɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel okok adɨkɨd God man ne alaŋ amnɨlaknɨŋ, bɨ chag sipsip mukep okok takaw agnɨg agnɨg gɨl agɨlak, God agek, chɨnop takaw anɨgɨl apal ak, kasek Betlehem amɨl nɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Agɨl, kasek amɨl pɨyow nɨgɨlak, Maliya ayɨp Josep ayɨp, ñapay agɨlak anɨb ak, bulmakaw tap ñɨbelɨgɨpal paws mɨgan ak lel kɨnek. ");
INSERT INTO taw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nɨŋɨd, ensel ne ñapay anɨb ak takaw agñek nɨgɨlak ak, binɨb okok kɨlop amɨl agñɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Agñelak, binɨb okok nɨŋɨd, gos pal yɨbɨl lɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pen Maliya ne tap gak anɨb okok mɨdupsek dɨl, gos ne ayaŋ lɨl nɨgɨlɨg yolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɨ chag sipsip mukep okok, ensel ne agak agak tek gek wɨdɨn kɨli ke nɨgɨlak tek, God yɨb nop ak dad aplanɨlɨg nop tep agɨlɨg adɨkɨd amnɨlak, chag sipsip okok yelak. ");
INSERT INTO taw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maliya ñɨ ak tɨkɨl ñɨn anep kugul ak mɨdɨl, mɨnek jel ak wak nope tɨbɨlɨkɨl yɨb lɨlak. Ned ensel ak Maliya ñapay ma yek ñɨn ak nop yɨb ak anɨgɨl lɨnɨmɨn agak tek, yɨb nop ak Jisas agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Pen bɨlel God takaw kɨles anɨb ak Mosis nɨŋɨd ñu kɨl tɨkak. Tɨkɨl agak, Ñɨ ned tɨkɨnɨgabal okok, God nop ñɨnɨgabal agak. Ak nɨm Maliya ñapay ak tɨkɨl, Juda binɨb gelɨgɨpal tek asɨkɨl, kal ke okok nep yek mɨdtep gɨl, Josep ayɨp God ñapay nop ak ñɨnɨg dad Jelusalem amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pen God takaw kɨles olap agek Mosis ñu kɨl tɨkak. Tɨkɨl agak, Bin ñapay tɨkɨnɨgabal okok mɨdtep gek, yawl malɨg akaŋ, peleb omɨŋal God agnɨgep kal awl ak dad amnɨgabal agak. Damɨl kɨlop ñel, God nop sɨbog ñɨnɨgabal agak. Gos anɨb ak abe nɨŋɨd, yawl omɨŋal sek dad amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Anɨb ñɨn ak bɨ suŋtep yɨbɨl gɨl, God nop nɨŋɨd kɨdek golɨgup olap yek. Yɨb ne ak Simiyon, ne Jelusalem yolɨgup. Bɨ olap Yislel binɨb kɨlop gɨtep gɨnɨgab ak nop kod yolɨgup. God Kawnan ak ayɨp mɨdolɨgup ak nɨm, nop ned agak, Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak apek nɨŋɨd, kɨdek kumnɨgaban agak. Agek nɨŋɨd, nɨg yolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pen ñɨn anɨb ak God Kawnan ak Simiyon nop gos ñek, God agnɨgep kal awl kab wali kus gɨl yek ak amɨl nɨgak, nonɨm nap Jisas nop dad apɨl, Mosis agak tek gɨnɨg owlek. ");
INSERT INTO taw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kɨlop nɨŋɨd, Jisas nop dɨ kay gɨl, God yɨb nop ak dad aplanɨlɨg agak, ");
INSERT INTO taw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Bɨawl, yad wog nep gɨñelɨgɨpin agak. Mɨñɨl yɨp tep gup, mɨdtep gɨpin agak. Anɨb ak yɨp agɨnak tek, mɨñɨl yɨp kelɨge yad kumnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ñɨ anɨb ak bɨ kasɨn gep chɨn yenɨgab ak, tep agyoke mɨseŋ apek wɨdɨn yad ke nɨgebin agak. ");
INSERT INTO taw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","Ñɨ anɨb awl binɨb nad Yislel binɨb kɨlop nep daŋ agɨl ma agyokɨpan, binɨb yokɨp okok kɨlop abe daŋ agɨl agyokɨpan agak. Ne mɨlek nad ak kɨli nɨgel tep gek, chɨnop Yislel binɨb yɨb ak dad aplanɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Takaw anɨb ak agaknɨŋ, nonɨm nap gos pal yɨbɨl lɨlek. ");
INSERT INTO taw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pen ne God nad ge mɨdtep gɨlaŋ agɨl, ñɨ nonɨm Maliya nop agak, Ñɨ nad anɨb ak mɨdaknɨŋ, Yislel binɨb kuŋay nep nab ak pal jakɨl, ogɨnap apyap pakɨnɨgabal, ogɨnap adek alaŋ amnɨgabal agak. God ne Bɨ God nop aglup ak nɨgɨlaŋ agɨl nop agyokak ak pen, nop ma dɨl takaw tɨmel agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Anɨgɨl, binɨb kuŋay gos tɨmel nab ayaŋ mɨdeb ak, bɨawl ne ownɨgab ñɨn ak, gos kɨli mɨseŋ lɨl yenɨgab agak. Pen mapen nep ak kumnɨgab, baynat tek tɨbɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Pen ñɨn anɨb ak bin God gos ñek agñeb olap abe ap yek. Yɨb ne ak Ana. Nap yɨb ak Panuwel. Binɨb Asel agelɨgɨpal jɨj ak tɨk dad apɨl nɨm, Ana nop tɨkɨlak. Pen Ana bin mɨlep yɨbɨl yolɨgup, sub ne ak 84 yɨnak. Ned bɨ dɨl, nɨgɨmɨl ayɨp mɨdel sub anep kugul ak pen, nɨgɨmɨl kumak. God nop gos anep lek, ñɨn kuŋay nep tap ñɨbɨl mel, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ am mɨdɨl, subnab abe maynab abe God ayɨp agɨlɨg yolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pen ne Jisas nop dɨ mɨdelak wulep sɨŋak owak. Apɨl, God nop tep agɨl, binɨb kɨli God chɨnop Jelusalem binɨb gɨñub anɨgɨl dɨnɨgab agɨl nɨgɨlak okok kɨlop agɨlɨg agak, Ñɨ anɨb ak chɨnop dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","God agak tek Josep bel tap okok mɨdupsek gɨl, tep adɨkɨd Galili plopens amɨl, taun kɨli Nasalet Jisas nop poŋɨd amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Am mɨdɨl, ñɨ anɨb ak pen awl gɨl, kɨles tɨmel yɨbɨl mɨdɨl, gos tep yɨbɨl nɨŋɨd, God nop kod mɨdaknɨŋ mɨdtep yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nonɨm nap ayɨp binɨb okok mɨdupsek sub ak sub ak ñɨn awl Pasopa apal ak, Jelusalem am nan gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Anɨgɨl nɨm, Jisas sub anep umɨgan ak lek, nonɨm nap ayɨp Jelusalem am mɨdel, ");
INSERT INTO taw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","ñɨn awl kɨli anɨb ak apɨl padɨkak nɨŋɨd, ñɨn nokom olap adɨkɨd amnɨlek. Kanɨb nab ak amɨl nɨgɨlek, Jisas ayɨp ma apelak. Ne Jelusalem nep yek ak pen, kɨli ma nɨgɨlek. Pen kanɨb nab ak kɨnɨl, numi nɨmam sɨkop ayɨp mɨdeb akaŋ agɨl, pɨyowɨl, ");
INSERT INTO taw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","nop ma nep nɨŋɨd, pɨyow adɨkɨd Jelusalem amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ñɨn omɨŋal nokom pɨyowɨl nɨgɨlek, ne God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ mɨdek. Mɨdɨl, bɨawl takaw kɨl nɨgep okok ayɨp nab okok besɨgɨl takaw ag yelak. Mɨdɨlɨg, takaw agɨlak anɨb okok nɨŋɨd kɨlop agnɨgak. ");
INSERT INTO taw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Binɨb ap nɨg yelak okok, Jisas agak tek nɨŋɨd, ñɨ gos kɨd agɨl nɨŋɨd, takaw agtep yɨbɨl gup ak agɨl, wal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pen nonɨm nap kɨli abe nop nɨŋɨd judɨlek. Nonɨm pen nop agak, Ñɨ. Nap chɨlop taynen anɨge, gos awl yɨbɨl nɨŋɨd pɨyowpul agak. ");
INSERT INTO taw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Agek agak, Taynen yɨp pɨyow nɨgɨnɨg opil agak? Bapi yad kal ne yenɨgayn ak ñɨli ma nepil agak? ");
INSERT INTO taw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Anɨb agak ak pen, takaw agup ak agɨl ma tɨk nɨgɨlek. ");
INSERT INTO taw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pen ñɨn anɨb ak, nop poŋɨd adɨkɨd taun kɨli Nasalet amelek, ne anɨb okok mɨdɨlɨg, nonɨm nap agelɨgɨpil tek nep nɨŋɨd kɨdek golɨgup. Pen nonɨm ne tap gak anɨb okok mɨdupsek dɨl, gos ne ayaŋ lɨl nɨgolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas ne awl gɨl, gos nɨgtep yɨbɨl gek, God abe binɨb okok abe nop nɨgɨlak kɨlop tep yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lom gapman bɨnonɨm Taybeliyas, man okok kod yek, sub anep ajɨp pɨskɨd ak. Pen ne palawl okok mɨdɨl, bɨ kod mɨdep muk ne yelak okok, ogɨnap agek, man keke am kod yelak. Bɨ Podiyus Paylat, Judiya binɨb okok kɨlop kod yek. Bɨ Helod, Galili binɨb okok kɨlop kod yek. Helod nɨmam ne Pilip, Yituliya binɨb okok sek Tlakonitis binɨb okok sek kod yek. Lisaniyas, Abilene binɨb okok kɨlop kod yek. ");
INSERT INTO taw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bɨ Anas ayɨp, Kayapas ayɨp, bɨ God nop sɨbogep bɨawl yɨbɨl omɨŋal ak Jelusalem yelek. Pen ñɨn anɨb ak, Sekalaya ñɨne Jon, man nep binɨb ma yelak nab okok mɨdaknɨŋ, God takaw ne ak Jon nop agñak. ");
INSERT INTO taw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ñɨg Jodan gol okok amɨl, binɨb okok kɨlop takaw agñɨlɨg agolɨgup, Tap si tap tɨmel gɨpɨm ak taynen anɨgɨpun agɨl kelɨgem, nɨbop ñɨg pakñen nɨm, God tap tɨmel okok tɨg walɨg gɨyokɨnɨgab agolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon kɨlop God takaw agñak anɨb ak, bɨ God gos ñek agñeb Aysaya, ne bɨlel agɨl tɨkak tek nep gak. Aysaya ne tɨkɨl agak, Bɨ olap man nep binɨb ma mɨdebal nab okok suk awl agɨl agɨnɨgab, Bɨawl ak kanɨb nop pɨdɨl kod yenɨmɨb agɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anɨb ak, gu yowup okok lum ñɨ tep gɨl, dum okok bɨg sak tep gɨl, kanɨb tɨd mad gup pɨd yɨpɨd gɨl, kanɨb tɨmel tɨmel gup kab okok dɨyok tep gɨl gɨnɨgab agɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anɨgɨl nɨm, binɨb okok mɨdupsek God binɨb ne kɨlop dɨnɨgab ak, nop nɨgtep gɨnɨgabal agɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aysaya ne takaw agɨl tɨkak tek, Jon ne nep gak. Binɨb kuŋay nep ne yek ak apɨl agɨlak, Chɨnop ñɨg pakñan agel, kɨlop ag gɨl agak, Yoy salaw ñapay ne okol agak. God ne nɨbop tɨmel nɨŋɨd ag gɨnɨgab ak, an nɨbop agek, nɨbi anɨb awl pɨlɨk opɨm agak? Ñɨg pakon, God binɨb ogɨnap kɨlop ag gɨnɨgab ñɨn ak, chɨnop ma ag gɨnɨgab agɨl pɨlɨk opɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tap si tap tɨmel okok kelɨgɨl, tap teplep adek anep gɨnɨmɨb agak. Anɨgem, binɨb okok nɨbi gɨtep gɨpɨm anɨb ak nɨgɨnɨgabal agak. Pen nɨbi ke gos olap nɨŋɨd, Eblaham bɨ based chɨn nɨm anɨb ak, God ne chɨnop gɨ tɨmel ma gɨnɨgab agɨl nepɨm agak. Pen Eblaham nop nep gos ak ma nɨgɨnɨmɨb agak. Nɨbi nɨgɨm agak. God ne kab ogɨnap dɨl, Eblaham binɨb ne ogɨnap gɨnɨmuŋ tek lup agak. ");
INSERT INTO taw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pen nɨgtep gɨnɨmɨb agak. God mab mɨdup ma pulup okok, tɨb dagɨlɨnɨg, tu ak mab gɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon takaw anɨb ak tek agak nɨŋɨd, nop pen agnɨŋɨd agelɨgɨpal, Chɨnop tay gɨlaŋ agɨl apan agelɨgɨpal? ");
INSERT INTO taw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Agel kɨlop agolɨgup, Binɨb chech omɨŋal yonɨmuŋ okok, olap binɨb chech ma yonɨmuŋ okok kɨlop ñɨnɨmɨb agolɨgup. Pen binɨb tap mɨdup yonɨmuŋ okok, ogɨnap binɨb tap ma yonɨmuŋ okok kɨlop ñɨnɨmɨb agolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pen bɨ takis dep okok, Jon chɨnop ñɨg pakñaŋ agɨl ap nop agnɨŋɨd agelɨgɨpal, Bɨawl. Chɨn tɨtay dɨnɨgun agelɨgɨpal? ");
INSERT INTO taw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Agel kɨlop agolɨgup, Takis ak dɨnɨg, gapman kay apal tek nep dɨnɨmɨb agolɨgup. Yepɨs ogɨnap ma dɨnɨmɨb agolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pen Lom bɨ chɨm kadɨŋ gep okok, kɨli Jon nop takaw anɨb ak tek nep agnɨŋɨd agelɨgɨpal, Chɨn tɨtay dɨnɨgun agelɨgɨpal? Agel kɨlop agolɨgup, Nɨbi binbɨ ogɨnap kɨlop gɨ tɨmel ma gɨnɨmɨb, tap kɨlop si ma dɨnɨmɨb agolɨgup. Takaw yepɨs agɨl tap kɨlop si ma dɨnɨmɨb agolɨgup. Wog nɨbi ke gɨpɨm, mani nɨbi ke anɨb anep dɨnɨmɨb agolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pen anɨgɨl mɨd dad amɨl, binbɨ okok takaw anɨb ak nɨgelak, mɨdupmɨdup kɨlop tɨkjakek, gos kuŋay yɨbɨl nɨŋɨd nɨg yelak. Anɨb agɨlak, Bɨ nɨm awl, Bɨ God nop aglup ak, bɨ binɨb okok kɨlop dɨl kod yenɨgab ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Agel, ne takaw anɨb ak nɨŋɨd kɨlop pen agak, Takaw anɨb ak ma agɨnɨmɨb agak. Bɨawl yɨbɨl ak kɨdek ownɨgab agak. Ne bɨawl yɨbɨl, yad bɨ yokɨp agak. Nop nɨgen yɨp nebeŋ gup, tob tɨlup nop ak nag wɨsɨkɨnɨm tek ma lup agak. Yad nɨbop ñɨg pakñebin agak. Ne apɨl, God Kawnan ne ak sek mab mɨŋɨlaŋ sek nɨbop pakñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pen ne wit cheg okok dɨyokɨl, mɨdup ñɨŋeb okok anɨgɨl yenɨgab agak. Wit mɨdup ñɨŋeb okok ke lɨl, wit cheg okok ke lɨl gɨnɨgab agak. Anɨgɨl, wit mɨdup ñɨŋeb okok dad kal ne amnɨgab, cheg okok dam mab ke yɨneb ayaŋ dɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ne binɨb okok kɨlop God takaw tep ak won ogɨnap sek agen nɨgtep gɨlaŋ agɨl, takaw teplep anɨb ak takaw awl yɨbɨl agɨl agñolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pen gapman bɨnonɨm Helod, tap si tap tɨmel okok gɨ dad amɨl, nɨmam bin ne Helodiyas nop abe dak. Anɨgek Jon pen agak, Anɨgup ak tɨmel gup agak. ");
INSERT INTO taw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Agek Helod nɨŋɨd, tap tɨmel gup olap sek gɨl, Jon nop dam nag lak. ");
INSERT INTO taw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pen gapman bɨnonɨm Helod ne Jon nop nag ma lak won ak, Jon ne binɨb okok kɨlop ñɨg pakñolɨgup. Jisas nop abe ñɨg pakñek, ne God nop agɨlɨg mɨdaknɨŋ, God man ne alaŋ mɨgan yɨkɨl yek, ");
INSERT INTO taw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","God Kawnan ne ak yawl gɨpkay tek wɨŋɨd apɨl nop lak. Lek, takaw olap God man ne alaŋ nɨb apɨl agak, Nad ñɨ mapen yad yɨbɨl agak. Nep nɨgen yɨp tep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pen Jisas sub ne ak 30 tek amnak, tɨkjakɨl God wog nop ak gak. Binɨb okok agɨl nɨgɨlak, Nap ne ak Josep ey agɨl nɨgɨlak. Josep nap ak Eli. ");
INSERT INTO taw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli nap ak Matat. Matat nap ak Lipay. Lipay nap ak Melki. Melki nap ak Janay. Janay nap ak Josep. ");
INSERT INTO taw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nap ak Matatiyas. Matatiyas nap ak Emos. Emos nap ak Nahum. Nahum nap ak Esli. Esli nap ak Nagay. ");
INSERT INTO taw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay nap ak Mat. Mat nap ak Matatiyas. Matatiyas nap ak Semen. Semen nap ak Josek. Josek nap ak Joda. ");
INSERT INTO taw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nap ak Jowanan. Jowanan nap ak Lesa. Lesa nap ak Selubabel. Selubabel nap ak Seyaltiyel. Seyaltiyel nap ak Neli. ");
INSERT INTO taw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli nap ak Melki. Melki nap ak Adi. Adi nap ak Kosam. Kosam nap ak Elmadam. Elmadam nap ak El. ");
INSERT INTO taw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El nap ak Josuwa. Josuwa nap ak Eliyesel. Eliyesel nap ak Jolim. Jolim nap ak Matat. Matat nap ak Lipay. ");
INSERT INTO taw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipay nap ak Simiyon. Simiyon nap ak Juda. Juda nap ak Josep. Josep nap ak Jonam. Jonam nap ak Eliyakim. ");
INSERT INTO taw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim nap ak Meleya. Meleya nap ak Mena. Mena nap ak Matata. Matata nap ak Natan. Natan nap ak bɨnonɨm Depid. ");
INSERT INTO taw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Bɨnonɨm Depid nap ak Jesi. Jesi nap ak Obed. Obed nap ak Bowas. Bowas nap ak Salmon. Salmon nap ak Nason. ");
INSERT INTO taw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nap ak Aminadap. Aminadap nap ak Admin. Admin nap ak Alni. Alni nap ak Heslon. Heslon nap ak Peles. Peles nap ak Juda. ");
INSERT INTO taw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nap ak Jekop. Jekop nap ak Aysak. Aysak nap ak Eblaham. Eblaham nap ak Tela. Tela nap ak Nahol. ");
INSERT INTO taw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahol nap ak Seluk. Seluk nap ak Leyu. Leyu nap ak Pelek. Pelek nap ak Ebel. Ebel nap ak Sela. ");
INSERT INTO taw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nap ak Kenan. Kenan nap ak Alpaksad. Alpaksad nap ak Siyem. Siyem nap ak Nowa. Nowa nap ak Lamek. ");
INSERT INTO taw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nap ak Metusela. Metusela nap ak Yinok. Yinok nap ak Jaled. Jaled nap ak Mahalalel. Mahalalel nap ak Kenan. ");
INSERT INTO taw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nap ak Enos. Enos nap ak Set. Set nap ak Adam. Adam nap ak God. ");
INSERT INTO taw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pen Jisas ñɨg Jodan pakɨl adɨkɨd owaknɨŋ, God Kawnan ne ak Jisas nop nab ayaŋ mɨdupsek amnak ak, ne Jisas nop man nep binɨb ma yelak nab okok poŋɨd amnak. ");
INSERT INTO taw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ñɨn anep 40 juwak nɨŋɨd, kɨcheki bɨawl ak ne Jisas yad yɨl owaŋ agɨl, ap nop agnɨgolɨgup. Jisas tap ak ma ñɨbek, anɨb ñɨn ak juwek nop yuwan gak. ");
INSERT INTO taw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kɨcheki bɨawl ak ne nop agak, Nad God Ñɨne mɨdɨl nɨm, kab anɨb awl age bilet tek tɨkɨlaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Agek Jisas nop pen agak, Buk Baybol ak tɨkɨl agɨlak, Binɨb okok, kɨli tap mɨdup anep ñɨbebal ak, kɨles ma dɨl pelpel yenɨgel tek ma lup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Agek kɨcheki Jisas nop dad dum awl alaŋ olap amɨl, kasek man okok mɨdupsek yomɨl ");
INSERT INTO taw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","agak, Man teplep okol nɨgan agak. Bɨawl keke kod mɨdebal agak. Yad pen, man anɨb okok mɨdupsek kodɨpin agak. Bɨ olap nop agɨnɨg agɨnɨgayn agak. Anɨb ak nad kɨgom yɨmɨl yɨp agnɨŋɨd kɨdek genɨgaban, man anɨb okol mɨdupsek nep agen, yɨb yenɨgab ak kodɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Agek Jisas pen agak, Buk Baybol ak tɨkɨl agɨlak, Bɨawl God nad ak nop nep kɨgom yɨmɨl agnɨŋɨd, wog nop anep gɨnɨmɨn agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Anɨb agek, kɨcheki bɨawl ak ne Jisas nop dad Jelusalem amɨl, dam God agnɨgep kal awl adek awl oklaŋ amɨl agak, Buk Baybol ak tɨkɨl agɨlak, God ne agek, ensel ne okok nep kod mɨdtep gɨnɨgabal agɨl tɨkɨlak agak. Apyap pakɨnɨg ge, ñɨn kɨli ak nep dɨ yenɨgabal ak nɨm, kab tob nep puŋɨlɨnɨmuŋ tek ma lɨnɨgab agɨl tɨkɨlak agak. Anɨb ak, nad God Ñɨne mɨdɨl nɨm, pɨdeg lum ayaŋ lan agak. ");
INSERT INTO taw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kɨcheki anɨb agek Jisas agak, Buk Baybol ak tɨkɨl agɨlak, Chɨn Bɨawl God kɨles ne anɨgep tek ma mɨdeb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɨcheki bɨawl ak ne Jisas nop takaw tay yepɨs okok mɨdupsek ag mel nɨŋɨd, kelɨg amnɨg gɨl, gos ne anep nɨŋɨd agak, Kɨdek ñɨn ogɨnap yad apɨl, takaw yepɨs ogɨnap sek agnɨgɨnɨm agɨl, amnak. ");
INSERT INTO taw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pen God Kawnan ne ak Jisas nop kɨles ñak nɨŋɨd, adɨkɨd am Galili plopens mɨdɨl, tap ogɨnap gek nɨŋɨd, binɨb okok takaw anɨb ak yɨg dad, Galili plopens nab okok mɨdupsek amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne Juda apnan gɨpal kal okok amɨl takaw agtep gek, bɨ tep yɨbɨl agɨl mɨñmɨñ yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pen Jisas ne Galili plopens nab okok aj aj taun Nasalet, man ne awl gak ak am yek. Juda añɨŋ lep ñɨn awl ak apek, ne pel golɨgup tek, Juda apnan gɨpal kal ak amɨl tɨkjakak. ");
INSERT INTO taw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tɨkjakek, nop bɨ God gos ñek agñeb Aysaya ñu kɨl tɨkak buk bad ak dap ñel, dɨ malakɨl, buk nɨm pi ak agɨnɨg gak day ak nɨŋɨd, kɨlop agñak. Takaw anɨb ak agak, ");
INSERT INTO taw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","God Bɨawl ak, yɨp wog ne ogɨnap aglɨl, Kawnan ne ak yokek yad yɨl apyapɨl yad ayɨp mɨdeb agak. Anɨb ak binɨb yɨmgeptek okok, yad takaw teplep agtep gen nɨgɨnɨgabal agak. Binɨb nag lup mɨdebal okok, wɨsɨb yoken amnɨgabal agak. Binɨb wɨdɨn koy mɨdebal okok, kɨlop gen nɨgɨnɨgabal agak. Binɨb ogɨnap kɨlop gɨ tɨmel gɨpal okok, gɨtep gɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bɨawl binɨb ne okok mɨdupsek gɨtep gɨnɨgab ñɨn anɨb ak apek, binɨb okok kɨlop agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas buk pi ak anɨb ak nɨgɨlɨg agñɨjuwɨl, buk bad ak dɨ yu gɨl, bɨ buk kod mɨdolɨgup anop tepayaŋ ñɨl besɨgek, binɨb yelak okok mɨdupsek wɨdɨn ak juwɨl nop nep nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Anɨgɨl nɨgelak Jisas kɨlop agak, God takaw anɨb won ak nepɨm ak, mɨñɨl nɨŋɨd yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Anɨb agek nɨŋɨd, Takaw tep yɨbɨl ak nep chɨnop agup agɨl, yɨb nop ak dad aplanɨlɨg gos kuŋay nep nɨgɨlak. Pen gos olap nɨŋɨd agɨlak, Bɨ anɨb awl Josep ñɨne nep agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Anɨb agel Jisas kɨlop agak, Yad nepin agak. Yɨp agɨnɨgabɨm, Dokta, nak ke mɨñak nep gup ak ge suŋ lɨnɨmuŋ agɨnɨgabɨm agak. Taun Kapeneyam mɨdɨl, tap mageptek ge, yɨd apek nopun tek ak, nab sɨŋawl abe ge nɨgun agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pen nɨbop nɨŋɨd agebin agak. Bɨ God gos ñek agñeb ak kal ne mɨdɨl agek, kɨli ma nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pen nɨgɨm. Bɨ God gos ñek agñeb Yilayja yek ñɨn ak, sub omɨŋal nokom takan anep kagol ak, man ma yɨbɨl pakɨl, tap ma jakɨl, yuwan awl yɨbɨl gak agak. Yislel bin kaŋɨl yuwan gak okok kuŋay nep yelɨgɨpal ak pen, ");
INSERT INTO taw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","God Yilayja nop agyokek, taun Saydon palawl amɨl, man sɨkol Salepat amnak agak. Amɨl bin kaŋɨl olap nop nɨŋɨd tap ñak agak. ");
INSERT INTO taw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pen anɨb ak tek, kɨdek bɨ God gos ñek agñeb Yilaysa yek ñɨn ak, Yislel binɨb soy ladek lak okok kuŋay yɨbɨl yelak ak pen, binɨb ogɨnap gek suŋ ma lak agak. Bɨ Neman man Siliya palawl nɨb ak, nop nep gek suŋ lak agak. ");
INSERT INTO taw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas anɨb agek, binɨb Juda apnan gɨpal kal ak yelak okok nɨgel kɨlop mɨlɨk tɨmel yɨbɨl yowak. ");
INSERT INTO taw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kal kɨli ak dum kabsoy anɨb oklaŋ yek, anɨb ak tek kɨli tɨkjakɨl, Jisas nop lɨpɨg seŋ ken dad kab mɨduŋ soy oklaŋ damɨl, nop lɨpɨg mɨduŋ ayaŋ yokun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pen dɨyokun agel, ne nab anɨb okok tɨkjakɨl amnak. ");
INSERT INTO taw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas tɨkjakɨl amɨl, ne Galili plopens taun Kapeneyam ayaŋ amnak. Juda añɨŋ lep ñɨn awl ak apek, apnan gɨpal kal ak amɨl, tɨkjakɨl kɨlop takaw agñak. ");
INSERT INTO taw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Agñek agɨlak, Ne bɨ yɨb sek, takaw nɨgtep yɨbɨl gɨl agup agɨlak. Anɨb agɨlɨg gos pal awl lɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pen Juda apnan gɨpal kal ak nab anɨb ak, bɨ kɨcheki mulɨk sɨkɨl yek olap yek. Ne suk awl agɨl agak, ");
INSERT INTO taw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ay, Jisas bɨ Nasalet nɨb agak. Nad tay gɨnɨg opan agak? Chɨnop gɨ tɨmel gɨnɨg opan tek lup agak? Yad nep nepin, God bɨ suŋtep yɨbɨl ne ak opan agak. ");
INSERT INTO taw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pen Jisas kɨcheki mulɨk sɨkɨl yek anop ag gɨl agak, Takaw ma agan agak. Kelɨgɨl amnoŋ agak. Agek, kɨcheki seŋ amɨlɨg bɨ anop dɨl binɨb yelak nab sɨŋak yokɨl amnak. Pen nop ma pakak. ");
INSERT INTO taw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Anɨgek, binɨb mɨdupsek nɨg yelak okok kɨli judɨl, agnɨg agnɨg gɨl agɨlak, Bɨ kabɨyam tɨmel anɨb awl, takaw anɨb ak akal nɨb dad apɨl agek, kɨcheki okok pɨlɨk abal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pen Jisas gak takaw anɨb ak man anɨb okok mɨdupsek dad amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pen Jisas Juda apnan gɨpal kal ak kelɨgɨl, Saymon kal ak amnak. Saymon nɨmak ne ak tap awl gɨl, wak okok mɨdupsek mab tek yɨnak ak nɨm, binɨb okok apɨl Jisas nop agɨlak, Nad am ge, mɨñak anɨb ak suŋ laŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Agel, ne bin tap gup anɨb ak wulep sɨŋak apɨl, tap gak anɨb ak ag gɨl agak, Tap gup awl suŋ laŋ agak. Anɨb agak nɨŋɨd, won anep suŋ lek, bin anɨb ak tɨkjakɨl tap mɨdup kɨlop gɨlɨtep gak. ");
INSERT INTO taw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pen sub saŋɨd amnak won ak, binɨb kɨli tap gak okok, mɨdupsek dad Jisas yek ak apelak, kɨlop nokom nokom dɨnɨgak nɨŋɨd suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pen binɨb kuŋay kɨcheki tap okok mulɨk sɨkɨl yek okok, agyokek seŋ jakɨl, amɨlɨg suk awl agɨl agɨlak, Nad God Ñɨne agɨlak. Anɨb agel kɨlop ag gɨl agak, Nɨbi anɨb ma agɨnɨmɨb agak. Taynen? Kɨli nepal, Jisas ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab. ");
INSERT INTO taw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mɨnek man kɨdeyɨl tɨkak won ak, Jisas man anɨb ak kelɨgɨl, man nep binɨb ma yelak nab okok amnak. Amek binɨb okok kɨdek amɨl, nop pɨyow nɨŋɨd agɨlak, Okok ma amnɨmɨn, chɨn ayɨp mɨdon agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Anɨb agel Jisas agak, God yɨp agyokek opin tek, am binɨb wakay ogɨnap kɨlop abe agñɨnɨgayn agak. God binɨb dɨl kɨlop kod yenɨgab takaw teplep ak kɨlop agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Anɨb agɨl, Juda apnan gɨpal kal okok amɨl, takaw tep anɨb ak kɨlop agñolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisas ñɨn olap am ñɨg Genesaled cheb gol sɨŋak mɨdɨl, God takaw tep ak agñak nɨŋɨd, binɨb kuŋay yɨbɨl nep takaw tep anɨb ak nɨgun agɨl, tɨbɨk dɨl apɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Anɨgɨl owlak nɨŋɨd, Jisas nɨgak, bɨ kubsal dep okok, bot omɨŋal dap ñɨg cheb gol sɨŋak lɨl, kubsal dep asas okok ñɨg pakñelak. ");
INSERT INTO taw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas Saymon bot mɨgan ayaŋ pɨdeg lɨl besɨgɨl agak, Yɨp dɨ nebneb ge, ñɨg nab sɨŋadaŋ amnaŋ agak. Agek, Saymon bot ak dɨ nebneb gek, ñɨg nab sɨŋak amek, Jisas kɨlop takaw agñak. ");
INSERT INTO taw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Takaw agjuwɨl, Saymon nop agak, Bot anɨb awl dad ñɨg nab awl sɨŋadaŋ amɨl, asas ak yokɨl kubsal dɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Agek, Saymon agak, Bɨawl. Mɨñɨl maynab ayaŋ kubsal nen ajon ajon, man tɨkup ak pen, kubsal olap ma dɨpun agak. Nad pen anɨb apan ak, asas ak monmon yokɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Anɨb agɨl, asas ñɨg yokɨlak nɨŋɨd, kubsal kuŋay nep apɨl asas mɨgan anɨb ak amɨl, asas ak tɨbɨk dɨl pugɨlɨkɨnɨg tek gak. ");
INSERT INTO taw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Anɨgek nɨŋɨd, bɨ kɨli bot adek olap yelak okok kɨlop ñɨnan gek apelak, kubsal anɨb okok dɨlak. Dɨl, bot omɨŋal mɨgan ayaŋ lel, pɨsnep aplan jakel, bot pogek yownɨg tek gak. ");
INSERT INTO taw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Anɨgek nɨŋɨd, Saymon Pita bɨne ayɨp bot mɨgan yelak okok, kɨli gos kuŋay yɨbɨl nɨgɨlak. Pen Sepedi ñɨne Jemis ayɨp, Jon ayɨp, bot olap dɨl Saymon ayɨp wog jɨmñɨl gelɨgɨpal bɨ omɨŋal ak, abe gos kuŋay nɨgɨlek. Pen Saymon Jisas yek sɨŋak apyap pakɨl agak, Bɨawl. Yad bɨ tap si tap tɨmel gɨpin ak, nad ke sɨŋak amnoŋ agak. Agek Jisas agak, Ma pɨlɨkɨnɨmɨn agak. Mɨñɨl ñɨn awl tɨkɨl, bɨ kubsal dep ak kelɨgɨl, bɨ binɨb dɨl dad God yɨl owep ak yenɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Anɨb agek, bot omɨŋal ak dam ñɨg gol okok lɨl, kubsal tap okok mɨdupsek kelɨgɨl, tap kɨli okok mɨdupsek kelɨgɨl, Jisas nop kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pen kɨdek Jisas am taun olap yek, bɨ soy ladek lak olap, ap yek wulep sɨŋak kɨgom yɨmɨl jel kuyan gɨl agak, Bɨawl. Nad yɨp yɨmug nɨŋɨd, ge soy yad ak suŋ lek, binɨb mɨdebal nab okok amnin agak. ");
INSERT INTO taw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Agek Jisas nop dɨnɨgɨlɨg agak, Nep gen suŋ lɨnɨmuŋ agak. Agek, won anɨb ak nep soy ladek anɨb ak suŋ lek, mɨdtep gak. ");
INSERT INTO taw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Anɨgek, Jisas bɨ anɨb anop takaw kɨles tɨmel gɨl agak, Yɨp dɨnɨgek suŋ lup agɨl, bɨ olap ma agɨnɨmɨn agak. Bɨ Mosis bɨlel God takaw ak ñu kɨl tɨkak tek, nad anɨgɨnɨmɨn agak. Nad amɨl, bɨ God nop sɨbogep ak nop wak nad yomnɨmɨn agak. Yomɨl, soy ladek yad ak suŋ lup agɨl, chag sipsip olap God nop pak ñɨnɨmɨn agak. Pak ñe, bɨ okok kɨli nɨgɨnɨgabal, soy ladek nad ak suŋ lup agak. ");
INSERT INTO taw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pen Jisas gak takaw ak man okok kɨd kɨd amek, binɨb kuŋay yɨbɨl nop nɨgun agɨl apelɨgɨpal. Binɨb anɨb okok, ogɨnap takaw tep nop ak nɨgɨnɨg apelɨgɨpal, ogɨnap chɨnop gek suŋ laŋ agɨl apelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pen ñɨn ogɨnap ne am man nep binɨb ma yelak nab okok mɨdɨl, God ayɨp agɨlɨg yolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ñɨn olap Jisas binɨb okok kɨlop takaw agñɨlɨg yek. Pen nab anɨb ak, bɨ Pelisi ogɨnap, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap, kɨli kuŋay yɨbɨl ap besɨg yelak. Bɨ anɨb okok, ogɨnap Galili plopens nɨb, ogɨnap Judiya plopens nɨb, ogɨnap Jelusalem nɨb owlak. Pen God kɨles ne ak Jisas nop ñek, binbɨ mɨñak gak okok gek suŋ lɨnɨg gak. ");
INSERT INTO taw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Pen bɨ ogɨnap, bɨ ñɨn tob kumak olap nop yɨl pakɨl dad amnɨlak, Jisas yek kal mɨgan ak. Jisas gek suŋ laŋ agɨl, kal mɨgan ayaŋ dad amnun agɨl nɨgɨlak, binɨb okok kal mɨgan anɨb ak pɨsnep tɨbɨk dak. Anɨgek, bɨ yɨl pakɨl dad owlak anɨb ak, dad kal adek alaŋ amnɨlak. Kal ak tɨg talɨkɨl, nag tun gɨl, Jisas yek nab okyaŋ saynsayn yokel ap yowak. ");
INSERT INTO taw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kɨli Jisas nop kɨles gɨl gos nepal tek, Jisas gos anɨb ak nɨŋɨd, bɨ ñɨn tob kumak anop agak, Mam. Tap si tap tɨmel gɨpan okok tɨg walɨg gɨyokebin agak. ");
INSERT INTO taw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anɨb agek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek, gos nab kɨli okok nep ke nɨŋɨd agɨlak, Bɨ anɨb awl an agɨlak? Ne God nop agjulɨg agup agɨlak. God ne nokom tap si tap tɨmel gɨpal okok tɨg walɨg gɨyokup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pen gos nɨgɨlak anɨb ak Jisas ne ke nɨŋɨd, anɨb agak, Nɨbi taynen yɨp gos tɨmel nɨŋɨd anɨb agebɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yad tɨtay agen nɨbop tep gɨnɨgab agak? Bɨ anɨb ak nop tap si tap tɨmel gɨpan ak tɨg walɨg gɨyokebin agen nɨbop tep gɨnɨgab akaŋ, tɨkjakɨl amnoŋ agen nɨbop tep gɨnɨgab agak? Tay takaw nop agen nɨbop tep gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pen nɨgtep yɨbɨl gɨnɨmɨb agak. Takaw nop apin anɨb ak jɨj mɨdeb agak. Bɨ Olap Ñɨne, God kɨles ne ak dɨl lum awl apɨl, tap si tap tɨmel gɨpal ak tɨg walɨg gɨyokɨnɨmuŋ tek lup agak. Anɨb agɨl, bɨ ñɨn tob kumak anop agak, Tɨkjakɨl, mɨj nak ak wɨnɨg dad kal nad amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Anɨb agek, binɨb okok nɨg yelaknɨŋ, won anɨb anep tɨkjakɨl, mɨñmɨñ gɨlɨg God yɨb nop ak dad aplanɨlɨg mɨj wɨnɨg dad kal ne amnak. ");
INSERT INTO taw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Anɨgek nɨŋɨd kɨli judɨl, God yɨb nop ak dad aplanɨlɨg agɨlak, Mɨñɨl tap anɨb ke gek nɨgobun agɨl, wal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pen kɨdek Jisas amɨl nɨgak, bɨ takis dep ak, takis delɨgɨpal kal mɨgan besɨg yek. Yɨb ne ak Lipay. Jisas nop nɨŋɨd anɨb agak, Ape, yad ayɨp amnul agak. ");
INSERT INTO taw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Agek, bɨ takis dep anɨb ak, ne wog golɨgup tap anɨb okok mɨdupsek kelɨgɨl, Jisas ayɨp amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pen Lipay, Jisas nop tap awl ak kal ne ak dagɨl lak. Dagɨl lɨl, bɨ takis dep ogɨnap, binɨb yokɨp ogɨnap, kuŋay nep suk agek apelak, kɨl ayɨp besɨgɨl tap ñɨŋɨlak. ");
INSERT INTO taw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ñɨŋɨlaknɨŋ, bɨ Pelisi ogɨnap, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap, kɨli Jisas bɨne okok kɨlop takaw tɨmel yɨbɨl agɨl agɨlak, Nɨbi taynen bɨ takis dep mani si dɨpal okok ayɨp, bɨ tap si tap tɨmel gɨpal okok ayɨp jɨmñɨl tap ñɨbebɨm agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Anɨb agel, Jisas takaw anɨb ak nɨŋɨd kɨlop agak, Binɨb suŋ mɨdobun apal okok, dokta nop ma suk apal agak. Binɨb tap gup okok nep chɨnop gel suŋ laŋ agɨl, dokta okok kɨlop suk agel opal agak. ");
INSERT INTO taw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anɨb ak tek, yad binɨb teplep mɨdebal okok kɨlop suk agɨnɨg ma opin agak. Binɨb tap si tap tɨmel gɨpal okok kɨlop suk agɨnɨg opin agak. Kɨlop suk agen, chɨn tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgɨnɨgel. ");
INSERT INTO taw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kɨli Jisas nop agɨlak, Jon bɨne okok ayɨp, Pelisi bɨ kɨli okok ayɨp, ñɨn ogɨnap tap ñɨbɨl mel, yuwan nep mɨdɨl God ayɨp apal agɨlak. Pen bɨnak okok, taynen tap ñɨbɨlɨg ñɨg ñɨbɨlɨg nep mɨdebal agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Anɨb agelak Jisas kɨlop agak, Juda binɨb gɨpun adek ak, bɨ olap bin dɨnɨg gek, bɨne ogɨnap tap awl ñɨŋɨnɨg genɨgabal, binɨb ogɨnap pen tɨkjakɨl, Taynen anɨgebɨm agɨl, ma agɨnɨgabal. Mel agak. ");
INSERT INTO taw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pen kɨdek ñɨn olap bɨ anɨb ak, bɨ ogɨnap nop dad amel, binɨb ne okok kɨli tap ma ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pen Jisas kɨlop takaw ogɨnap paladaŋ lɨl agak, Chech ned nɨb ak talɨkek, chech kɨdeyɨl nɨb olap tɨg talɨkɨl dap ñag del, adɨp adɨp ma yenɨgab agak. Keke yɨbɨl lɨl, omɨŋal gɨl tɨmel yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pen ñɨg wayn ak abe agak. Ñɨg wayn kɨm ak dɨl, chag meme wak mɨlep mɨgan ak ma sopal agak. Taynen? Sogɨl kɨmjen ñenɨgabal, ak tan aplanel, bɨŋ tɨmel yɨbɨl agɨl pugɨlɨkɨl sogek, chag meme wak ak tɨmel gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anɨb ak nɨŋɨd, ñɨg wayn kɨm ak dɨl, chag meme wak kɨm mɨgan ak nep sog lep agak. ");
INSERT INTO taw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pen binɨb ñɨg wayn ned nɨb ñɨbal okok apal, Ñɨg wayn ned nɨb ak tep yɨbɨl agɨl, ñɨg wayn kɨm kɨdeyɨl nɨb ak nɨgel kɨlop tep ma gup agak. ");
INSERT INTO taw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kɨdek Juda añɨŋ lep ñɨn awl olap, Jisas bɨne okok ayɨp, tap wit wog nab ak amnɨlak. Amɨlɨg, bɨne okok wit mɨdup anɨb okok ogɨnap tɨk ñɨn beŋ kɨli ak lɨl, wik dad am ap gɨl, wak pak yokɨl, ñɨbɨlɨg ñɨbɨlɨg amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Anɨgelak, bɨ Pelisi ogɨnap nɨŋɨd anɨb agɨlak, Nɨbi taynen ñɨn awl wog ma gep ñɨn ak, wit mɨdup cheg pak yokebɨm agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Agelak, Jisas kɨlop agak, Depid ne bɨlel bɨne okok ayɨp yuwan gek, God kal ak amjakɨlak agak. Amjakɨl, Depid God kal ak mɨgan amɨl bilet dɨl ñɨbɨl, bɨne okok kɨlop ñek ñɨŋɨlak agak. Bilet anɨb ak God wɨdɨn mɨdup adek ak lɨpal, bɨ yokɨp ma ñɨbal, bɨ God nop sɨbogep okok nep ñɨbal agak. Depid nop yuwan gek bilet dɨl ñɨŋak kesɨm anɨb ak, buk Baybol kɨl tɨkɨlak ak, nɨb ma nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Anɨb agɨl, takaw olap agak, Juda añɨŋ lep ñɨn awl apɨm ak, Bɨ Olap Ñɨne nep kod mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pen Juda añɨŋ lep ñɨn awl kɨdek olap, Jisas Juda apnan gɨpal kal ak amɨl, God takaw ak agñɨlɨg yek. Kal mɨgan anɨb ak, bɨ ñɨn yɨpɨd kɨd tɨmel gak olap ap yek. ");
INSERT INTO taw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ anɨb ak nop nɨgɨlak tek, Jisas añɨŋ lep ñɨn awl chɨn anɨb ak gek suŋ lɨnɨgab akaŋ. Taynen? Nop ag gun agɨl nɨŋɨjsek lɨl yelak. ");
INSERT INTO taw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pen gos nɨgɨlak anɨb ak, Jisas ne ke gos kɨlop nɨŋɨd, bɨ ñɨn tɨmel gak anop agak, Nad jakɨl nab sɨŋawl owan agak. Agek jakɨl owaknɨŋ, ");
INSERT INTO taw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ne bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek kɨlop agak, Añɨŋ lep ñɨn awl tek, binɨb okok kɨlop dɨtep gɨnɨgabun akaŋ, kɨlop gɨ tɨmel gɨnɨgabun agak? Akaŋ pen, kɨlop gon koŋɨm amnɨgel akaŋ, pakon kumnɨgel agak? ");
INSERT INTO taw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Anɨb agɨl, kɨlop nɨg kuskus gɨl, bɨ ñɨn tɨmel gak anop agak, Ñɨn ak almɨl lan agak. Agek, almɨl lek day suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jisas bɨ anɨb anop anɨgɨl gek suŋ lek nɨŋɨd, bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, kɨlop mɨlɨk yɨbɨl yapek, takaw agnɨg agnɨg gɨl agɨlak, Chɨn Jisas nop taydun agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pen ñɨn nab anɨb sɨŋak, ñɨn olap, Jisas nap nop agin agɨl, dum alaŋ amɨl, nap nop ag mɨde mɨde, man tɨkak. ");
INSERT INTO taw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mɨnek sub owaknɨŋ, binɨb ne okok mɨdupsek agek apelak, bɨne anep umɨgan ak kɨlop tɨg asɨk ke lɨl agak, Nɨbi bɨ takaw yɨp dad ameb okok yenɨgabɨm agɨl, kɨlop aglak. ");
INSERT INTO taw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bɨne aglak anɨb okok yɨb kɨli nɨm ak. Olap Saymon, Jisas yɨb nop lɨl Pita agak. Olap Edlu, Saymon nɨmam ne ak. Olap Jemis. Olap Jon. Olap Pilip. Olap Batolomyu. ");
INSERT INTO taw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Olap Matyu. Olap Tomas. Olap Jemis nap ak Alpiyus. Olap Saymon, bɨ Selot agelɨgɨpal okok bɨ kɨli olap. ");
INSERT INTO taw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Olap Judas nap ak Jemis. Olap Judas Yiskaliyot nɨb. Ne nep nɨm, kɨdek Jisas nop pakɨlaŋ agɨl mɨmug nɨgak. ");
INSERT INTO taw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pen Jisas bɨne anɨb okok ayɨp dum alaŋ kelɨgɨl, am gu ayaŋ yelak. Binɨb ne kuŋay okok ayɨp binɨb yokɨp kuŋay yɨbɨl okok ayɨp, nop nɨgun agɨl apnan gɨlak. Binɨb anɨb okok ogɨnap Judiya plopens nab okok nɨb, ogɨnap Jelusalem nɨb, ogɨnap taun ñɨg solwala tɨb okok Taya ayɨp Saydon ayɨp nɨb. ");
INSERT INTO taw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pen binɨb owlak anɨb okok, ogɨnap Jisas takaw nop ak nɨgɨnɨg owlak, ogɨnap tap gak okok chɨnop gek suŋ laŋ agɨl owlak. Pen binɨb kɨcheki abaŋ lɨl yek mɨdtep ma gɨlak okok, chɨnop gek suŋ laŋ agɨl, abe owlak. ");
INSERT INTO taw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kɨli anɨgɨl apɨl, chɨn Jisas nop dɨnɨgun agɨl gos nɨgɨlak. Taynen? God kɨles ne ak yek, kɨli ap dɨnɨgɨlaknɨŋ kɨlop suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas bɨne okok kɨlop nɨgɨlɨg agak, Nɨbi binɨb yɨmgeptek mɨdebɨm okok, nɨbop tep yɨbɨl gek mɨñmɨñ gɨnɨmɨb agak. God nɨbop dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nɨbop mɨñɨl yuwan awl gup okok, nɨbop tep yɨbɨl gek mɨñmɨñ gɨnɨmɨb agak. Kɨdek yuwan ma gɨnɨgab agak. Nɨbop chɨb gek chaŋ lɨ mɨdebɨm okok, nɨbop tep yɨbɨl gek mɨñmɨñ gɨnɨmɨb agak. Kɨdek nɨbi yɨmel agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bɨ Olap Ñɨne nop chɨgɨl mɨdem, nɨbop yɨlɨk nɨŋɨd, kud ñɨl, yɨb nɨbop yɨb tɨmel adek ak lɨl, agjuwenɨgel, nɨbop tep yɨbɨl gek mɨñmɨñ gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bɨlel nɨsed yes kɨli okok, kɨli bɨ God gos ñek agñeb okok kɨlop gelɨgɨpal tek nep nɨbop gɨnɨgabal agak. Anɨb ak nɨŋɨd, God chɨnop man ne alaŋ dad amɨl dɨtep yɨbɨl gɨnɨgab agɨl, tep gaknɨŋ ñɨn pakɨlɨg, nɨbop tep yɨbɨl gek mɨñmɨñ gɨlɨg yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pen nɨbi binɨb mani tap okok kuŋay mɨdeb okok, tɨtay dɨnɨgab agak? Tap nɨbi dep tek ak lum awl ak pɨsnep dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pen nɨbi mɨñɨl tap ñɨbem kogmeg gup ak, tɨtay dɨnɨgab agak? Kɨdek yuwan gɨnɨgab agak. Pen mɨñɨl yɨmel agɨlɨg mɨdebɨm ak, tɨtay dɨnɨgab agak? Kɨdek chɨb gek chaŋ lɨlɨg yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pen yɨb nɨbop dad aplanɨlɨg nep yenɨgabal ak, nɨbi tɨtay dɨnɨgab agak? Nɨsed yes kɨli okok, kɨli bɨ God takaw nɨŋɨd yɨbɨl ma apal yepɨs agelɨgɨpal bɨ okok kɨlop anɨb ak tek gelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pen nɨbi takaw yad agen nɨgebɨm okol, nɨbop anɨb agebin agak. Binɨb nɨb ayɨp penpen ñagep okok kɨlop mapen lɨnɨmɨb agak. Binɨb nɨbop mɨlɨk nepal okok kɨlop gɨtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Binɨb ogɨnap nɨbop kuj ladek genɨgel, God nop agnɨgem, kɨlop gɨtep gɨnɨmuŋ agak. Binɨb ogɨnap nɨbop agjuwɨl gɨ tɨmel genɨgel, God nop agnɨgem, kɨlop mapen nɨgɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pen bɨ olap mɨkem pɨs kɨd nep ak pak sɨl gonɨmuŋ, adɨke pɨs kɨd ak abe pakɨnɨmuŋ tek lup agak. Pen bɨ olap siglis nep ak donɨmuŋ, ne kolsiyot yad ak abe dɨnɨmuŋ agɨl, ne nɨŋɨd dɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Binɨb ogɨnap tap nen asɨb agenɨgel, ñɨnɨmɨb agak. Pen tap nɨbop olap nɨŋɨd denɨgel, chɨnop ju ñɨm agɨl ma agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nɨbi binɨb okok kɨli chɨnop gɨtep gɨnɨgel agɨl gos nepɨm tek nep, kɨlop anɨb anep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Binɨb nɨbop mapen lɨpal okok nep mapen lɨnɨgabɨm ak, nɨbi tay agɨl nepɨm, Chɨn binɨb teplep mɨdobun agak. Binɨb tap si tap tɨmel gɨpal okok, kɨli abe penpen mapen lɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pen binɨb nɨbop dɨpal okok nep dɨnɨgabɨm ak, tɨtay dɨl chɨn binɨb teplep mɨdobun agɨl nepɨm agak. Binɨb tap si tap tɨmel gɨpal okok anɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tap ñon pen ñɨnɨgabal agɨl, gos anep nɨŋɨd tap ñɨnɨgabɨm ak, tɨtay dɨl chɨn binɨb teplep mɨdobun agɨl nepɨm agak. Binɨb tap si tap tɨmel gɨpal okok abe anɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anɨb ak binɨb nɨb ayɨp penpen ñagep okok, kɨlop mapen lɨl, dɨtep gɨl, tap monmon ñɨnɨmɨb agak. Chɨnop pen ñɨnɨgabal agɨl, gos ak ma nɨgɨnɨmɨb agak. Nɨbi anɨgɨnɨgabɨm, tap teplep dɨl God adek alaŋ ñapay ne yenɨgabɨm agak. Ne binɨb tap si tap tɨmel gɨpal okok sek, binɨb nop tep ma apal okok sek, kɨlop abe kod mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bapi ne binɨb mapen nɨŋɨd dup tek, nɨbi abe gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Pen nɨbi binɨb kɨlop takaw tɨmel ma agɨnɨmɨb agak. Chɨn binɨb tep agɨl, binɨb ogɨnap kɨlop gos tɨmel nɨgenɨgabɨm, takaw anɨb ak adɨkɨd nɨbop yɨl ownɨgab agak. Binɨb ogɨnap nɨbop gɨ tɨmel gɨpal okok nɨŋɨd kelɨgenɨgabɨm, God tap si tap tɨmel gɨpɨm okok abe tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tap nɨbi okok mapen kab ma gɨl, binɨb okok kɨlop monmon ñenɨgabɨm, God nɨbop pen abe ñɨnɨgab agak. Ne wad nɨbop yɨgek yɨgek keb ak gek, dek pi okok amek jɨtep ak yɨgɨnɨgab agak. Tap kuŋay yɨbɨl nɨbop ñɨnɨmuŋ agak. Tap nɨbi bɨ ogɨnap kɨlop ñɨnɨgabɨm tek, God nɨbop abe ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pen Jisas takaw olap paladaŋ lɨl agak, Bɨ wɨdɨn koy olap, bɨ wɨdɨn koy olap nop kanɨb ak mɨdeb agɨl ma yomnɨgab agak. Taynen? Ne anɨgɨl, omɨŋal gɨl apyap kaw mɨgan ak pakɨnɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sikul binɨb olap am sikul agup won ak, tisa ne ak nop ma sɨlawup agak. Pen kɨdek sikul ak agtep gɨl nɨm, tisa ne ak ayɨp adɨp adɨp yenɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Taynen mab bog wɨdɨn nep pak yu gɨl mɨdeb ak nɨŋɨd agɨl mel, namam tap achɨp wɨdɨn nop mɨdeb anop nɨŋɨd apan agak? Tɨtay dɨl anɨb apan, Tap achɨp wɨdɨn alaŋ mɨdeb, yad dɨyokin apan agak? Nad bɨ tay yepɨs apan agak. Nɨgan. Mab bog wɨdɨn nep pak yu gɨl mɨdeb agak. Nad ned mab bog ak wɨdɨn nak alaŋ mɨdeb anɨb ak dɨyoke, wɨdɨn nep suŋ lek nɨgtep gɨl tek, kɨdek namam tap achɨp mɨdeb ak dɨyokɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Pen mab teplep ak mɨdup tɨmel ma pulup agak. Mab tɨmel ak mɨdup tep ma pulup agak. ");
INSERT INTO taw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Anɨb ak mab okok pulek nɨŋɨd, mab ak tep, mab ak tɨmel agɨl nepal agak. Mab keke mɨdeb tek, mɨdup pulek nɨgtep gɨpal agak. Mab ñuñu sek kubagas tek okok, mab tep pik tek ma pulup agak. Nag mɨgɨñem ñu tek okok, nag tep wayn mɨdup tek ma pulup agak. ");
INSERT INTO taw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Binɨb mɨdtep gɨpal okok, nab kɨlop ayaŋ tep mɨdeb tek, kɨli gɨtep gɨpal agak. Binɨb mɨdtep ma gɨpal okok, nab kɨlop ayaŋ mɨdtep ma gup tek, kɨli gɨ tɨmel gɨpal agak. Pen binɨb tɨtay dɨl mɨdebal ak, takaw age nɨŋɨd, binɨb okok tep, binɨb okok tɨmel agɨl nɨgɨnɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Taynen yɨp apɨm, Bɨawl chɨn apɨm ak pen, takaw apin ak kɨdek ma gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bɨ olap yad yɨl apɨl, takaw yɨp ak nɨŋɨd kɨdek gɨnɨgab ak, bɨ anɨb ak tek yad nɨbop agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bɨ anɨb ak kal ne man kɨles adek ak gɨnɨgab agak. Gek, ñɨg wɨlɨk awl apɨl kal ne ak ma dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pen bɨ olap takaw yɨp nɨŋɨd, kɨdek ma gɨnɨgab ak, bɨ anɨb ak tek yad nɨbop agñɨnɨgayn agak. Bɨ anɨb ak kal ne man sayn adek sɨŋak gɨnɨgab agak. Gek, ñɨg wɨlɨk awl apɨl, kasek pɨsnep tɨg jɨsɨpuk gɨl dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas binɨb anɨb okok kɨlop takaw agñɨjuwɨl, taun Kapeneyam amnak. ");
INSERT INTO taw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Pen man anɨb ak, Lom bɨ chɨm kadɨŋ gep bɨawl ak olap yek, bɨ chɨm kadɨŋ gep kuŋay yɨbɨl kod mɨdolɨgup. Ne takaw olap nɨgak, Jisas ap Kapeneyam yek. Anɨb ak nɨŋɨd, Juda bɨawl ogɨnap agyokɨl agak, Bɨ tep, wog yɨp gɨñeb ak, tap gɨl kumnɨgeb nen, nɨbi am Jisas nop poŋɨd apem, gek suŋ laŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Agek, Jisas yek ak apɨl, takaw kɨles gɨl agɨlak, Bɨ chɨm kadɨŋ gep bɨawl ak, bɨ tep yɨbɨl agɨlak. Chɨnop Juda binɨb okok pel kod mɨdtep gɨl, apnan gɨpun kal ak chɨnop olap gak agɨlak. Anɨb ak nad am bɨ anɨb ak, bɨ wog gɨñeb ne ak nop ge suŋ lɨnɨmuŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Agel, Jisas bɨ anɨb okok ayɨp am am kal wulep wulep gɨlaknɨŋ, bɨ chɨm kadɨŋ gep bɨawl anɨb ak takaw olap pen agɨl, bɨne ogɨnap kɨlop agyokek, am Jisas nop nebeŋ pakɨlak. Nop nebeŋ pakɨl agɨlak, Bɨawl chɨn ak nep agup, Bɨawl. Yad bɨ tep mel, kal yad ak tob yul ma ownɨmɨn agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Yad bɨ tep tek, nad yɨl nɨnɨm agup agɨlak. Pen yad nepin, bɨawl yad ak, ne yɨb awl mɨdeb, yad nop muk okok mɨdebin agup agɨlak. Yad pen, yɨb awl mɨdebin, bɨ chɨm kadɨŋ gep okok kɨli yɨp muk okok mɨdebal agup agɨlak. Olap nop Amnoŋ agen, ne amub agup agɨlak. Olap nop Owan agen, ne owup agup agɨlak. Bɨ wog gɨñeb yad anop Anɨb ak gɨnɨmɨn agen, ne anɨb ak gup agup agɨlak. Anɨb ak, suŋ laŋ agɨl takaw anep agenɨmɨn, bɨ wog gɨñeb yad tap gup anop suŋ lɨnɨgab agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Anɨb agelak, Jisas bɨ anɨb ak gos ne ke nɨŋɨd agup agɨl, ju dɨl gos pal yɨbɨl lɨl, adɨkɨd binɨb nop kɨdek gɨl apelak okok kɨlop agak, Bɨ anɨb awl man olap nɨb ak pen, yɨp gos lɨnɨgɨlɨg mɨdɨl chɨg tep yɨbɨl gup agak. Binɨb Yislel nɨb okok pen, ne yɨp gos lɨnɨgup ak anɨb ak tek gos ma lɨnepal agak. Yad nepin, mɨdupsek yɨp gos anɨb ak ma lɨnepal agak. ");
INSERT INTO taw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pen bɨ chɨm kadɨŋ gep bɨawl ak, bɨne okok adɨkɨd amɨl nɨgɨlak, bɨ tap gak anɨb ak pɨsnep suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Won olap mɨdɨl, Jisas taun Nayn amnaknɨŋ, bɨne okok sek, binɨb yokɨp okok sek, kuŋay yɨbɨl nop kɨdek gɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Am am taun Nayn anɨb ak, kanɨb day ak amjakɨlaknɨŋ, bin kaŋɨl olap ñɨ nokom tɨkak ak owak. Ñɨ anɨb ak kumek, binɨb kuŋay nep yɨl lɨl dad owlak. ");
INSERT INTO taw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas bin kaŋɨl anɨb anop nɨgek chɨb gek agak, Chaŋ ma lan agak. ");
INSERT INTO taw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Anɨb agɨl, chɨp yɨl lɨl dad apelak ak am daknɨŋ, kɨli jakɨl nɨg yelak. Jisas bɨ pɨlaj kumek dad owlak anɨb anop agak, Ñɨ, nep agebin, tɨkjakan agak. ");
INSERT INTO taw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Agek, tɨkjakɨl besɨgɨl takaw agaknɨŋ, nonɨm nop agak, Ñɨ nak awl agak. ");
INSERT INTO taw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pen binɨb nɨg yelak okok gos kuŋay nɨŋɨd, God yɨb nop ak dad aplanɨlɨg agɨlak, God ne bɨ God gos ñek agñeb awl ak agyokek, chɨnop yɨl owup agɨlak. God chɨnop gɨñɨnɨg owup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pen Jisas gak anɨb ak nɨŋɨd, kesɨm del, Judiya plopens amɨl man yokɨp okok abe amnak. ");
INSERT INTO taw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon bɨne okok, Jisas tap gak anɨb okok mɨdupsek nɨŋɨd, am Jon nop agñɨlak. Agñelak, Jon bɨne omɨŋal agek apelek ");
INSERT INTO taw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","agak, Ñɨli bɨ omɨŋal am nop agnɨŋɨd agɨnɨmil, Nad Bɨ God nop aglup ak opan akaŋ, bɨ anɨb ak ke kod yonɨgun agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Agek Jisas yek ak amɨl agɨlek, Jon Bɨ Ñɨg Pakñeb ak nep agup, Nad Bɨ God nop aglup ak opan akaŋ, bɨ anɨb ak ke kod yonɨgun agup agɨlek? Agɨl chɨlop agyokek, nep agnɨgɨnɨg apobul agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pen anɨb agɨl nɨg mɨdɨlek nɨŋɨd, Jisas binɨb mɨñak adek keke gak okok gek suŋ lak. Binɨb tap gak okok gek suŋ lɨl, binɨb wɨdɨn koy gak okok gek wɨdɨn yɨbɨl lɨl, binɨb kɨcheki walɨjpal mulɨk sɨkɨl yek okok gek binɨb yɨbɨl lak. ");
INSERT INTO taw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas anɨgɨl, bɨ omɨŋal anɨb ak kɨlop agak, Ñɨli bɨ omɨŋal adɨkɨd amɨl Jon nop agɨnɨmil, Chɨl amɨl nopul, bɨ anɨb ak binɨb wɨdɨn koy gup okok gek wɨdɨn yɨbɨl lup agɨnɨmil agak. Binɨb tɨmud sawl lup okok gek takaw nepal agɨnɨmil agak. Binɨb tob tɨmel gup okok gek kanɨb aj tep gɨpal agɨnɨmil agak. Binɨb soy ladek lup okok gek mɨlep gup agɨnɨmil agak. Binɨb kubal okok gek tepayaŋ tɨkjakɨpal agɨnɨmil agak. Binɨb yɨmgeptek okok abe God takaw teplep ak agek nepal agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pen takaw olap agɨnɨmil, Binɨb yɨp nep gos lɨnɨŋɨd, chɨgɨl mɨdebal okok, kɨlop tep gek mɨñmɨñ gɨnɨgel agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Anɨb agek, bɨ Jon nop takaw dad owlek omɨŋal ak adɨkɨd amnɨlek. Amel, Jisas binɨb ap yelak okok kɨlop, Jon anɨgak ak agñak. Anɨb agak, Nɨbi ned man nep binɨb ma yelak nab okok abek ñɨn ak, tay gɨnɨg abek agak? Sɨd pal nokom olap yɨgen dad amɨl apɨl gup ak nɨgɨnɨg abek agak? ");
INSERT INTO taw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Akaŋ taynen abek agak? Bɨ chech teplep lup olap nɨgɨnɨg abek agak? Mel ak agak. Chɨn nopun, bɨ chech teplep lɨl, tap teplep dɨpal okok, bɨnonɨm kal kɨles tɨmel okok kɨnɨbal agak. ");
INSERT INTO taw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pen tap tay nɨgɨnɨg abek agak? Yokɨp ma abek. Bɨ God gos ñek agñeb ak nɨgɨnɨg abek agak. Bɨ God gos ñek agñeb anɨb ak, bɨ yokɨp mel agak. Bɨ God gos ñek agñeb okok anɨb nep yelak ak pen, Jon ne bɨ anɨb okok kɨlop sɨlawup agak. God wog awl gɨnɨg owak agak. ");
INSERT INTO taw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bɨ anɨb anop Jon, bɨlel buk Baybol ayaŋ ñu kɨl tɨkɨl agɨlak, God ne Ñɨne nop agup, Nɨgan, bɨ takaw dad ameb yad ak agyoken, ned amɨl kanɨb pɨdɨl kod yek, kɨdek nep agen amnɨgaban agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yad nɨbop nɨŋɨd agebin, binɨb ned lum awl yelɨgɨpal okok ayɨp, mɨñɨl mɨdebal okok ayɨp, Jon ne kɨlop mɨdupsek sɨlawɨl, yɨb mɨdeb agak. Ak pen, binɨb yokɨp God ne kɨlop dɨl kod mɨdeb okok, kɨli Jon nop sɨlawɨl, yɨb awl mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jisas takaw agak anɨb ak, binɨb yokɨp okok sek, bɨ takis dep okok sek, nɨgtep gɨl agɨlak, God ne nɨm gɨtep gup ak agɨlak. Kɨli ned apel Jon kɨlop ñɨg pakñak, anɨb ak tek kɨli anɨb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pen bɨ Pelisi okok sek, bɨ Juda takaw nɨgtep gep okok sek, kɨli ned ñɨg ma pakɨlak anɨb ak tek, aleb aleb ñɨl, God takaw tep ak ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Jisas anɨb agɨl kɨlop agak, Yad nepin, binɨb mɨñɨl ñɨn awl mɨdebal okok, ñapay sɨkol ogɨnap tek mɨdebal agak. Ñapay sɨkol okok, kɨli sɨlpɨŋ ñɨlɨg ogɨnap apal, Dachɨŋ pakon, taynen kɨgom ma papɨm apal agak? Pen kɨmep chɨb gek tek agon, taynen chaŋ ma lɨpɨm apal agak? Gɨpal tek ak binɨb mɨñɨl mɨdebal okok kɨli gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon Bɨ Ñɨg Pakñeb ak, apɨl tap ma ñɨbɨl ñɨg wayn ma ñɨbɨl gek, nop apɨm, Bɨ kɨcheki walɨjpal mulɨk sɨkek mɨdeb ak apɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pen mɨñɨl Bɨ Olap Ñɨne apɨl, tap ñɨbɨl ñɨg wayn ñɨbɨl gek, nop apɨm, Tap kuŋay ñɨbɨl ñɨg kuŋay ñɨbɨl gup apɨm agak. Ne binɨb tap si tap tɨmel gɨpal okok sek, bɨ takis dep okok sek, bɨ kɨli apɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pen binɨb God takaw gos nɨgtep gɨpal ak, nɨbop yomek nepɨm, God gos ne ak nag pal tek mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bɨ Pelisi olap, yɨb ne Saymon, ne Jisas nop agak, Ape kal yad ak am tap ñɨŋɨnɨgul agak. Agek, Jisas Pelisi kal ne ak amɨl tap ñɨŋɨlek. ");
INSERT INTO taw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Anɨb won ak, kanɨbtam bin olap man anɨb ak nɨb ak takaw olap nɨgak, Jisas ap bɨ Pelisi ak ayɨp tap ñɨbelek. Anɨb ak nɨŋɨd, wel ñɨg kuy tep owep ak, kab botol dɨl palɨl dad owak. ");
INSERT INTO taw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisas yek kud okok ken apɨl, tob agen ak besɨgɨl chaŋ lak. Anɨgɨl chaŋ lek, chaŋ wɨdɨn ñɨg ak tɨk Jisas tob adek ak yowak. Yapɨl, bin kɨmɨg wɨj ne ak wik yokɨlɨg bom sɨlokɨl, tob kɨd nop ak ñɨg kuy tep owep ak lɨñak. ");
INSERT INTO taw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Anɨgek, bɨ Pelisi ak gos ne anep nɨŋɨd agak, Bɨ anɨb awl, bɨ God gos ñek agñeb yɨpɨd gɨl mɨdobɨkop tek, kanɨbtam bin ap nop dɨ nɨgeb ak tɨk nopɨkop agak. ");
INSERT INTO taw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas bɨ Pelisi gos nɨgak anɨb ak nɨŋɨd nop agak, Saymon. Takaw yad nokom olap nep agɨnɨgebin agak. Agek, Saymon agak, Tisa. Takaw anɨb ak agan agak. ");
INSERT INTO taw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","42","Agek, Jisas agak, Bɨ olap tɨkjakɨl, bɨ omɨŋal kɨlop mani ogɨnap ñɨnɨgab agak. Olap nop 500 kina ñɨl, olap nop 50 kina ñɨl gɨnɨgab agak. Pen kɨdek bɨ omɨŋal anɨb ak, pen ñeb tek ma yek agak. Bɨ mani ñɨnɨgab anɨb ak, kɨlop agɨnɨgab, Mani ñɨlop ñɨbin ak, pen ñɨnɨgul agɨl gos ak ma nɨgɨnɨmil agɨnɨgab agak. Anɨb agek, bɨ an bɨ anɨb ak nop mɨñmɨñ yɨbɨl gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Agek, Saymon agak, Gos yad nepin ak, bɨ mani awl nop ñub ak kelɨgup agak. Agek Jisas agak, Nɨŋɨd yɨbɨl apan agak. ");
INSERT INTO taw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Anɨb agɨl, Jisas adɨkɨl bin anop nɨgɨlɨg Saymon nop agak, Bin nɨm awl nop nɨgan agak. Yad kal mɨgan nep ak apen, ñɨg yɨp ma ñesɨpan, tob yad lɨped gɨyokɨpin agak. Bin anɨb awl pen wɨdɨn ñɨg ne ak tob yɨp adek ak tɨk yapek, kɨmɨg wɨj ne ak dɨl wikek mɨlep gup agak. ");
INSERT INTO taw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yɨp ma bom sɨlokɨpan agak. Bin anɨb awl pen apɨl tob kɨd yɨp ak bom sɨlokɨlɨg mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kɨmɨg yɨp wel ñɨg ak ma lɨñɨban agak. Bin anɨb awl pen tob kɨd yɨp ak wel ñɨg kuy tep awl owup ak lɨñub agak. ");
INSERT INTO taw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Anɨb ak nep agebin, Bin anɨb awl tap si tap tɨmel kuŋay nep gup ak tɨg walɨg gɨyoken, yɨp pen mapen yɨbɨl lup agak. Pen binɨb tap si tap tɨmel sɨkol gɨpal okok tɨg walɨg gɨyoken, yɨp pen mapen sɨkol olap lup agak. ");
INSERT INTO taw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Anɨb agɨl bin anɨb ak nop agak, Tap si tap tɨmel gɨpan okok tɨg walɨg gɨyokebin agak. ");
INSERT INTO taw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Anɨb agek, bɨ ayɨp tap ñɨbelak okok, kɨli ke agnɨg agnɨg gɨl agɨlak, Bɨ anɨb awl taynen, Tap si tap tɨmel okok tɨg walɨg gɨyokebin agup agɨlak? God ne nɨm anɨgɨl gup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Anɨb agɨlak ak pen, Jisas bin anɨb anop agak, Gos nad ke nɨŋɨd apan, Tap si tap tɨmel gɨpin tek, Jisas tɨg walɨg gɨyokaŋ agɨl opan agak. Ape, tɨg walɨg gɨyokebin nen, adɨkɨd amɨl mɨdtep gɨl God ñɨn beŋ adek ak yenɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pen ñɨn kɨdek anɨb ak, Jisas bɨ takaw nop dad ameb anep umɨgan ak ayɨp, taun okok man sɨkol okok amɨl, God binɨb dɨl kɨlop kod yenɨgab takaw teplep ak, binɨb okok kɨlop agñak. ");
INSERT INTO taw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pen ñɨn anɨb ak, bin tap gak Jisas gek suŋ lak ogɨnap, kɨcheki walɨjpal sek mɨdel ne gek bin yɨbɨl lak ogɨnap, ayɨp ajelɨgɨpal. Bin anɨb okok yɨb kɨli nɨm ak, olap Maliya taun Makdala nɨb apal. Nop kɨcheki anep kugul ak yek, Jisas agek pɨlɨk amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bin olap Jowana. Nɨgɨmɨl yɨb ak Kusa, ne gapman bɨnonɨm Helod kal tap nop okok kod mɨdolɨgup. Bin olap Susana. Kɨli bin yokɨp ogɨnap ayɨp mani kɨli okok ke dam tap taw dad apɨl, Jisas bɨne okok ayɨp tap jɨmñɨl ñɨbɨlɨg gɨ ajelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Binɨb man keke, tun okok tun okok Jisas nop nɨgɨnɨg kɨdek owlak okok, binɨb ned owlak okok, kɨlop takaw olap paladaŋ lɨl agak, ");
INSERT INTO taw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Bɨ olap wit jakaŋ agɨl, wit mɨdup ak dam wog day okok yokɨnɨgab agak. Yokek, ogɨnap kanɨb nab ak yapek, binɨb okok taw amɨl apɨl gel, yawl okok pen ap nɨŋɨd mɨdupsek ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ogɨnap kab adek lum sɨkol yenɨgab okok yapɨl jakɨnɨgab ak pen, lum mɨlep gaknɨŋ pɨsnep mɨlep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pen ogɨnap nag ñuñu nab okok yapek, nag anɨb okok pak yuwɨg gek, jak tep ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pen ogɨnap lum teplep okok yapɨl jak tep yɨbɨl gɨl, mɨdup kuŋay yɨbɨl nep pulɨnɨgab agak. Jisas kɨlop anɨb agɨl agak, Nɨbi binɨb tɨmud sek okok, takaw anɨb ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anɨb agek, bɨne okok nop agnɨŋɨd agɨlak, Takaw paladaŋ lɨl apan anɨb ak, takaw jɨj ne taydɨl mɨdeb agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Agel Jisas kɨlop agak, God binɨb dɨl kɨlop kod yenɨgab ak, takaw we gɨl mɨdolɨgup ak nɨbop gos ñek nɨgɨnɨgabɨm agak. Pen binɨb yokɨp okok, kɨli nɨgɨnɨgabal ak pen, anɨb agup agɨl ma nɨgɨnɨgabal agak. Kɨli takaw paladaŋ lup ak nɨgɨnɨgabal ak pen, takaw jɨj ak ma nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pen takaw paladaŋ lɨl tap mɨdup tek apin ak, God takaw ak apin agak. ");
INSERT INTO taw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mɨdup ogɨnap yownɨgab kanɨb nab ak apin ak, binɨb okok God takaw ak nɨgɨnɨg gɨlak agɨl apin agak. Gel, Satan apɨl takaw anɨb ak dɨ we gek, kɨli God nop gos ma lɨnɨgel, God kɨlop ma dɨnɨgab agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pen mɨdup ogɨnap yownɨgab kab adek lum sɨkol yek okok apin ak, God takaw ak nɨŋɨd, tep gaknɨŋ nop gos lɨnɨgɨnɨgabal ak pen, kɨdɨl am wos ma gɨnɨgab tek gos kɨles yɨbɨl gɨl ma nɨgɨnɨgabal agɨl apin agak. Kɨdek mɨŋel ogɨnap apek nop kelɨgɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pen mɨdup ogɨnap yownɨgab nag ñuñu nab okok apin ak, binɨb okok God takaw ak nɨgɨnɨgabal ak pen, kɨdek takaw mɨŋel akaŋ, kubap mani tap okok akaŋ, mɨñmɨñ gep adek ak nep gos nɨŋɨd, God nop gos kɨles gɨl ma nɨgɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pen mɨdup ogɨnap lum teplep yɨbɨl sɨŋak yapɨl, jak tep gɨl mɨdup kuŋay yɨbɨl nep pulɨnɨgab apin ak, binɨb okok God takaw ak nɨŋɨd dɨ wos yɨbɨl gɨl, mɨdtep yɨbɨl gɨl gɨtep gel binɨb yad kuŋay yɨbɨl tɨkjakɨnɨgabal agɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pen binɨb okok sup dagɨlɨl, tin mɨgan okok akaŋ, bog adek kɨnɨbal muk okok ma lɨpal agak. Mɨlek gek binɨb nɨgɨlaŋ agɨl, abañ adek sɨŋalaŋ nep lel nɨm, binɨb okok kal mɨgan apɨlɨg mɨlek anɨb ak nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tap okok mɨdupsek we gɨl mɨdeb, sayn mɨseŋ lɨnɨgab agak. Bɨ tap okok mɨdupsek we gel mɨdeb, sayn mɨseŋ lek, binɨb nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Anɨb ak takaw apin okok nɨgtep yɨbɨl gɨnɨmɨb agak. Binɨb takaw nɨŋɨd, nɨg dɨnɨgabal okok, takaw tep ogɨnap sek nɨgɨnɨgabal agak. Pen binɨb takaw nɨŋɨd ma nɨg dɨnɨgabal okok, sɨkol nɨgobun agɨl nepal ak sek pɨsnep kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pen ñɨn anɨb ak, Jisas nonɨm nɨmam ne yɨbɨl okok kɨli Jisas nop nɨgɨnɨg apɨl nɨgɨlak, kal mɨgan anɨb ak tɨbɨk dɨl yek, kɨli seŋayaŋ yelak. ");
INSERT INTO taw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Binɨb ap yelak okok Jisas nop agɨlak, Nanɨm namam okok, nep nɨgɨnɨg ap mɨdebal seŋayaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Agel Jisas kɨlop agak, Binɨb God takaw ne ak nɨŋɨd kɨdek gɨpal okok, ami yad, mam yad okok mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pen ñɨn olap Jisas bɨne okok kɨlop agak, Ñɨg cheb tɨkɨl kɨd adaŋ amnun agak. Agɨl, bot ak dɨl amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nab okok amɨlɨg, Jisas ne wɨsɨn kɨn amnak won ak, yɨgen awl apɨl ñɨg nab anɨb ak dɨl, ñɨg pag bot mɨgan ak amek, kumnɨgel tek nep lak. ");
INSERT INTO taw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Anɨgek, bɨne okok ap Jisas nop kaskas gel tɨkjakek, agɨlak, Bɨawl. Chɨn mɨdupsek kumnɨgobun agɨlak. Agel, Jisas tɨkjakɨl agek, yɨgen awl sek ñɨg sek apek ak kelɨgɨl, ned yek tek yek. ");
INSERT INTO taw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pen ne bɨne okok kɨlop agak, God nop gos lɨnepɨm tek, taynen nop agnɨgem tap gek anɨb ak ma kelɨgup agak? Agek, kɨli pɨlɨkɨl gos pal awl yɨbɨl lɨl, agnɨg agnɨg gɨl agɨlak, Bɨ anɨb awl an agɨlak? Ne agek, yɨgen awl sek ñɨg awl sek apek ak kelɨgɨl, ned yek tek mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pen kɨli bot awl anɨb ak dɨl, ñɨg Galili cheb nab ak am am, man Gelasa binɨb yelak kɨd adaŋ amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amjakɨl, Jisas ne bot pɨdeg lum ayaŋ lɨl amnaknɨŋ, bɨ kɨcheki walɨjpal kuŋay yɨbɨl yek olap apjakak. Bɨ anɨb ak chɨb mɨgan mɨdup nep yolɨgup, kal yɨbɨl mɨgan ak ma kɨnolɨgup. Chɨp kamelɨgɨpal kab mɨgan okok nep kɨn ajolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bɨ nop kod mɨdep okok, nag kɨles tɨmel lɨl, ñɨn tob nop okok tunɨg wos gelɨgɨpal ak pen, kɨcheki tap okok kɨles gek nag lelɨgɨpal anɨb okok gek pugɨlɨkek, man nep binɨb ma yelak nab okok mɨnek mɨnek amolɨgup. Pen bɨ anɨb ak, Jisas nop nɨŋɨd wal agɨl, apɨl Jisas yek tob agen sɨŋak apyap pakak. Jisas tap nop mulɨk sɨkak anɨb okok kɨlop agak, Bɨ anɨb awl nop kelɨgɨl seŋ amnɨm agak. Anɨb agaknɨŋ, tap nop mulɨk sɨkak anɨb okok, nebneb gel, takaw awl agɨl agak, Jisas. Nad God bɨawl adek alaŋ Ñɨne ak, yɨp tap gɨnɨgeban ak ma gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Agek Jisas agak, Yɨb nad tay agak. Agek agak, Yɨb yad ak Kuŋay Yɨbɨl agak. Kɨcheki walɨjpal okok kuŋay yɨbɨl mulɨk sɨkɨl yelak tek nɨm, anɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pen kɨcheki okok, Jisas nop takaw awl agɨl agɨlak, Chɨnop mab ke yɨneb kaw mɨgan kɨluŋ ma tɨkup ak ma agyokɨnɨmɨn agɨlak. Mel agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Anɨb agɨl nɨgɨlak, chag kuŋay yɨbɨl amɨl gelak yep pɨl anɨb sɨŋak. Jisas nop agɨlak, Chɨnop age, am chag mɨdebal okdaŋ kɨlop mulɨk sɨkun agɨlak. Anɨb agel Jisas yaw agek, ");
INSERT INTO taw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","bɨ yɨbɨl anop kelɨgɨl, am chag anɨb okok kɨlop mulɨk sɨkɨlak. Mulɨk sɨkel, chag okok pɨgju mɨduŋ ayaŋ amɨl, gɨdam ñɨg cheb nab ayaŋ pakɨl, ñɨg ñɨbɨl mɨdupsek kumɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pen bɨ chag mukep okok, Jisas gak anɨb ak nɨŋɨd, kasek amɨl binɨb taun yelak kɨlop agñɨl, am man yokɨp okok yelak okok kɨlop agñɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Anɨgɨl agñelak, tap anɨb ak tay gek nɨŋɨd agebal agɨl, apɨl nɨgɨlak, bɨ kɨcheki mulɨk sɨkɨl yolɨgup ak bɨ yɨbɨl lɨl, chech yɨmɨl, gos nop ak pag yɨkek, Jisas tob agen sɨŋak besɨg yek, nɨŋɨd pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pen binɨb nɨg mɨdel Jisas kɨcheki ag seŋ yokak okok, binɨb kɨdek owlak okok kɨlop ne anɨb anɨb gup agɨl agñɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pen Gelasa binɨb mɨdupsek kɨlop jel gek pɨlɨkɨl, Jisas nop agɨlak, Nad adɨkɨd amnoŋ agɨlak. Agel, bot dɨl amnɨg gaknɨŋ, bɨ kɨcheki ");
INSERT INTO taw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","mulɨk sɨkɨl yek Jisas gek bɨ yɨbɨl lak ak, ne Jisas nop takaw kɨles tɨmel agɨl agak, Yad nad ayɨp amobul agak. Anɨb agak ak pen Jisas nop agak, Mel. ");
INSERT INTO taw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","God nep tɨtay gup tek, am binɨb nad okok kɨlop agñɨnɨmɨn agak. Agek, ne adɨkɨd amɨl, binɨb okok mɨdupsek kɨlop Jisas yɨp anɨb anɨb gup agɨl agñak. ");
INSERT INTO taw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pen binɨb Jisas apeb agɨl kod yelak okok, Jisas bot dɨl amjakek nɨŋɨd agɨlak, Tep apeban agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pen bɨ olap owak, yɨb ne Jaylus. Ne Juda apnan gɨpal kal ak bɨawl kod yolɨgup olap. Ne Jisas yek sɨŋak apɨl, kɨgom yɨmɨl agak, Kal yad amnul agak. ");
INSERT INTO taw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pay yad nokom ak kumnɨgeb agak. Pay anɨb ak sub ne yɨn lak umɨgan ak agak. Agek Jisas takaw anɨb ak nɨŋɨd, nɨgɨnɨg amnaknɨŋ, binɨb kuŋay yɨbɨl nep ap nop pɨspɨs chɨchɨlok ñɨlɨg amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Pen bin olap, bin kanɨb padɨkaknɨŋ yek, sap yeb anep umɨgan amnak. Bin anɨb ak nop gel suŋ lɨnɨmuŋ tek ma lak. Ne Jisas amek kud okok apɨl, chech palawl lak ak bad gol okok dɨnɨgaknɨŋ, nop suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pen Jisas kɨlop agak, An yɨp dɨnɨgup agak? Agek, binɨb okok agɨlak, Chɨn ma dɨpun agɨlak. Pen Pita agak, Bɨawl. Binɨb kuŋay nep opal okok nep chɨlok ñel, gos nɨŋɨd ageban tek lup agak. ");
INSERT INTO taw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Agek Jisas agak, Binɨb nokom olap yɨp dɨnɨgek, kɨles yad ak amek, nɨŋɨd agebin agak. ");
INSERT INTO taw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pen bin Jisas nop dɨnɨgak anɨb ak nɨgak, we gɨnɨmuŋ tek ma yek. Jep dɨlɨg, Jisas yek wulep sɨŋak apɨl kɨgom yɨmɨl, binɨb okok nɨg yelaknɨŋ agak, Nɨkɨm yɨp mɨnek mɨnek yowup ak, nep dɨnɨgen kasek pɨsnep yɨbɨl suŋ lup agak. ");
INSERT INTO taw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Agek Jisas agak, Pay yad, nad gos sek yenɨmɨn agak. Yɨp gos lɨnepan tek, nep gek suŋ lup nen, amɨl mɨdtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Anɨb agaknɨŋ, Jaylus bɨne olap kal ne nɨb apɨl nop agak, Pay nak pɨsnep kumub agak. Tisa nop age, tob yul ma ownɨmuŋ agak. Age adɨkɨd amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Agek, Jisas takaw anɨb ak nɨŋɨd, Jaylus nop agak, Pay yad ak kumeb agɨl gos ak ma nɨgɨnɨmɨn agak. Yɨp gos lɨnɨge, tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Anɨb agɨl kal ak amjakɨl, binɨb okok kɨlop mɨdupsek ag seŋayaŋ mɨdɨl, pay nonɨm nap omɨŋal ak, Pita ak, Jon ak, Jemis ak, kɨlop poŋɨd pay anɨb ak nɨgɨnɨg kal mɨgan ayaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pen pay ak kumeb agɨl binɨb chaŋ lɨ yelak okok, Jisas kɨlop agak, Chaŋ ma lɨnɨmɨb agak. Pay anɨb awl ma kumub, yokɨp wɨsɨn kɨneb agak. ");
INSERT INTO taw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Anɨb agek, nop yɨmel agɨl agɨlak, Pay pɨsnep kumub ak, taynen anɨb agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pen Jisas pay kumak anɨb ak, ñɨn kɨd nop ak dɨl agak, Pay, tɨkjakan agak. ");
INSERT INTO taw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anɨb agaknɨŋ, kawnan ne ak tep ap tol gek tɨkjakak. Tɨkjakek, Jisas nonɨm nap kɨlop agak, Tap ogɨnap ñel ñɨŋaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tap anɨb ak nɨŋɨd, nonɨm nap kɨli judɨlek. Judɨl, Jisas kɨlop bel takaw kɨles gɨl agak, Binɨb okok kɨlop takaw anɨb ak ma yɨbɨl agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jisas bɨne anep umɨgan ak suk agek apel agak, Nɨbop kɨles awl ñɨl agen, nɨbi kɨles yad ak dɨl amnɨmɨb agak. Dad amɨl, kɨcheki walɨjpal binɨb mulɨk sɨkek mɨdebal okok agem, pɨlɨk amnɨgel agak. Binɨb tap gup okok gem suŋ lɨnɨmuŋ agak. God binɨb dɨl kɨlop kod yenɨgab takaw ak kɨlop agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pen amnɨg, yɨl kodɨm, mani, wad, chech, tap ñɨŋeb tap okok sek dad ma amnɨmɨb agak. Yokɨp amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kal olap amjakem nɨbop agdenɨgel, kɨli ayɨp kɨn tep gɨl, amnɨg gɨnɨmɨb ñɨn ak nep amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pen man wakay ogɨnap amem nɨbop ma agdenɨgel, man anɨb ak kelɨg amnɨg kɨlop agɨnɨmɨb, Takaw tep ak dad opun ma dɨpɨm tek, man nɨbop awl apon sɨlkul dayday tob chɨnop dup ak wik yokɨl amobun agɨnɨmɨb agak. Wik yokɨl amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Anɨb agaknɨŋ, kɨli man sɨkol okok amɨl, takaw teplep ak agñɨlɨg binɨb tap gak okok gel suŋ lolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pen binɨb okok, Jisas tɨtay gak takaw anɨb ak ag amɨl apɨl gɨlaknɨŋ, gapman bɨnonɨm Helod nɨŋɨd gos kuŋay yɨbɨl nɨgak. Binɨb ogɨnap agɨlak, Jon Bɨ Ñɨg Pakñeb tepayaŋ tɨkjakup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ogɨnap agɨlak, Bɨ God gos ñek agñeb ned nɨb Yilayja mɨseŋ owup agɨlak. Ogɨnap agɨlak, Bɨ God gos ñek agñeb bɨlel olap tepayaŋ tɨkjakup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Anɨb agel, gapman bɨnonɨm Helod agak, Jon nop kuŋam tɨken kumub anɨb ak tek, bɨ anɨb an apɨl mɨdaknɨŋ agebal ak agak. Pen yad nop nɨgɨnɨm agɨl gos ak nɨgak. ");
INSERT INTO taw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pen Jisas bɨ takaw nop dad ameb okok, kɨli adɨkɨd apɨl, tap tɨtay gɨlak tek takaw ak, nop agñɨlak. Agñel Jisas man wakay olap am ke mɨdon agɨl, kɨlop poŋɨd taun Betsayda amnɨg saŋɨdɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kanɨb nab okok amnɨlaknɨŋ, binɨb kuŋay nep kɨdek gɨlak. Kɨdek gɨl apjakel, kɨlop Tep opɨm agɨl, God binɨb dɨl kɨlop kod yenɨgab takaw ak kɨlop agñak. Agñɨlɨg, binɨb tap gak okok gek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pen dugep sub saŋɨd amnak won ak, bɨ takaw nop dad ameb anep umɨgan ak apɨl Jisas nop agɨlak, Okol man nep nab okok mɨdobun nen, binɨb okol agyokɨnɨmɨn agɨlak. Agyoke, kal okok keke amɨl, tap mɨdup kɨli okok pɨyow nɨgɨlɨg, kɨnɨgel mɨgan ak pɨyow nɨgɨlɨg gɨlaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Anɨb agelak Jisas agak, Nɨbi ke kɨlop tap mɨdup ñɨnɨmɨb agak. Agek agɨlak, Chɨn tap ñɨŋeb kuŋay ma mɨdeb agɨlak. Yokɨp bilet anep mamɨd ak mɨdɨl, kubsal omɨŋal mɨdɨl gup agɨlak. Nad tay gos nepan agɨlak? Binɨb awl kuŋay mɨdebal ak, chɨn am tap ñɨŋeb kɨlop ogɨnap taw dad ownɨgun agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ñɨn anɨb ak, binɨb apnan gɨlak okok, bin okok sek ñapay okok sek mel, bɨ okok nep nɨm 5,000 tek yelak. Pen Jisas bɨne okok kɨlop agak, Binɨb kuŋay ap mɨdebal awl agem, tun keke besɨgɨlaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Agek agak tek gel, ");
INSERT INTO taw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ne bilet anep mamɨd ak, kubsal omɨŋal ak sek dɨl, kɨlan gɨl nɨŋɨd, God nop tep agɨl, tɨpag bɨne okok kɨlop ñek, kɨli pen dɨlɨg, binɨb okok kɨlop bɨlok ñɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ñelak ñɨb dad amɨl, ñɨbdɨnɨgel tek ma yek. Ñɨb dad amɨl apɨl gel, kɨdek Jisas bɨne okok wad anep umɨgan ak yɨgel aplan jakak. ");
INSERT INTO taw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pen ñɨn olap Jisas ne God ayɨp agɨlɨg mɨdɨl, bɨne okok kɨlop agnɨŋɨd agak, Binɨb yokɨp okok yɨp an agɨl nepal agak? ");
INSERT INTO taw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Agek agɨlak, Binɨb ogɨnap nep Jon Bɨ Ñɨg Pakñeb ak agɨl nepal agɨlak. Ogɨnap, bɨ God gos ñek agñeb ned nɨb Yilayja agɨl nepal agɨlak. Ogɨnap, bɨ God gos ñek agñeb bɨlel olap tepayaŋ tɨkjakup agɨl nepal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Agelak, kɨlop pen agak, Nɨbi ke yɨp bɨ an agɨl nepɨm agak? Agek Pita agak, Nad Bɨ God nop aglup ak, chɨnop dɨl kod yenɨgaban ak agak. ");
INSERT INTO taw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Anɨb agek, Jisas kɨlop agak, Takaw anɨb ak, binɨb ogɨnap kɨlop ma agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Anɨb agɨl takaw olap pen agak, Bɨ Olap Ñɨne nop yul awl yɨbɨl ñɨnɨgabal agak. Bɨ Juda bɨawl takaw tɨg asɨkep okok, bɨ God nop sɨbogep bɨawl okok, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok, kɨli nop ma dɨnɨgabal agak. Mɨlɨk nɨŋɨd, ñaglɨnɨgabal ak pen, ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pen Jisas, ne bɨne okok sek, binɨb yelak okok sek, kɨlop agak, Binɨb an yɨp kɨdek gonɨmuŋ, gos ne ak kelɨgɨl, mab bak kumak chɨn ak mɨnek mɨnek dad ajɨl, yɨp chɨgɨl kɨdek gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Binɨb an ne ke mɨdɨl, mɨdtep gin agɨnɨgab ak, kɨdek mɨd tɨmel gɨnɨgab agak. Pen binɨb an yɨp dɨl, yɨp tap tay gɨnɨgab takaw ma mɨdeb agɨnɨgab ak, mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pen bɨ tap lum awl yɨl mɨdupsek dɨnɨgab ak, kɨdek ne tɨtay dɨl yenɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bɨ an yɨp nebeŋ gɨnɨmuŋ tek lek nɨŋɨd, Jisas nop ma nepin agɨnɨgab ak, kɨdek Bɨ Olap Ñɨne, ne Bapi mɨlek awl ñɨlapɨl dɨl, ensel okok mɨlek awl dɨl ownɨgab ñɨn ak, nop pen abe Bapi nop agɨnɨgab, Nop ma nepin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pen nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb mɨñɨl mɨdebɨm okok ogɨnap ma kumnɨgabɨm won ak, God binɨb dɨl kɨlop kod yenɨgab ñɨn anɨb ak nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas anɨb agɨl, ñɨn anep jel ak tek mɨdɨl, Pita, Jon, Jemis kɨlop poŋɨd, God ayɨp agɨnɨg dum olap amnak. ");
INSERT INTO taw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Amɨl, God ayɨp ag mɨdɨlaknɨŋ, jomulɨk nop ak ke yɨbɨl lɨl, chech nop ak kayɨg gɨl ñɨñakol gɨlɨg yek. ");
INSERT INTO taw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Anɨgaknɨŋ, bɨ bɨlel yelɨgɨpil, Mosis ayɨp Yilayja ayɨp, ");
INSERT INTO taw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","God mɨlek awl ak dɨl apɨl, Jisas kɨdek am Jelusalem yek nop mab bak alaŋ chɨpɨl pak tɨbɨk lel kumnɨgab takaw ak ag yelak. ");
INSERT INTO taw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ag yelaknɨŋ, Pita, Jon, Jemis kɨlop wɨsɨn apek kɨn yelak ak pen tɨkjakɨl nɨgɨlak, Jisas mɨlek awl ak, Mosis ayɨp Yilayja ayɨp jakɨl yelak. ");
INSERT INTO taw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bɨ omɨŋal ayɨp amnɨg gɨleknɨŋ, Pita gos nɨgtep gɨl mel, Jisas nop agak, Bɨawl. Chɨn awl mɨdon tep yɨbɨl gup agak. Nad yaw age, kal sɨkol bad omɨŋal nokom gun agak. Nep olap, Mosis nop olap, Yilayja nop olap agak. ");
INSERT INTO taw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Anɨb agaknɨŋ, won anɨb anep wɨsɨp awl ak kɨlop apɨl mɨdupsek yu gaknɨŋ, pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pen takaw olap wɨsɨp nab anɨb ak nɨb apɨl agak, Ñɨ yad, yad nop aglɨpin agak. Takaw agɨnɨmuŋ tek nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Takaw agjuwek nɨgɨlak, bɨ omɨŋal ma yelek. Jisas ne nep yek. Pen dum alaŋ mɨdel tap gek nɨgɨlak anɨb ak, ñɨn anɨb ak binɨb ogɨnap kɨlop ma agñɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pen mɨnek, Jisas ayɨp bɨne okok ayɨp dum alaŋ kelɨgɨl, kanɨb nab okok apyapɨlɨg nɨgɨlak, binɨb kuŋay yɨbɨl Jisas nop pɨyowel apek. ");
INSERT INTO taw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bɨ olap binɨb kuŋay nep nab anɨb ak suk awl agɨl agak, Tisa. Ñɨ yad nokom awl nɨgan agak. ");
INSERT INTO taw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kɨcheki ak pelnep abaŋ lɨ mɨdɨl, nop gek suk awl agɨl, gɨdam pakɨl, kosɨb asɨb apɨl, kum dam nab lɨlɨg owup agak. Nop anɨgɨl pel pelnep gek gek nɨm, mɨdtep ma gup agak. ");
INSERT INTO taw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bɨnak okok kɨlop takaw kɨles gɨl apin, Kɨcheki mɨdeb ak agyokɨm agɨl apin ak pen, kɨli agyok mel nɨŋɨd kelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Anɨb agek Jisas agak, Binɨb lum awl mɨdebɨm okok, nɨbi anɨgɨpɨm teplep mel agak. Ñɨn akal gos lɨnɨgɨnɨgabɨm agak? Ma yɨbɨl nepɨm anɨb ak, yad ñɨn tɨtay nɨb ayɨp mɨdɨl, mɨŋel nɨbop ak dad ajenɨm agak? Anɨb agɨl, bɨ anɨb anop agak, Ñɨ nad anɨb ak dad sɨŋawl owan agak. ");
INSERT INTO taw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Agek dad owaknɨŋ, kɨcheki ak ñɨ anɨb anop kɨles gɨl pɨpag yokek gɨdam pakak. Jisas pen kɨcheki anop ag gek, ke amnaknɨŋ, ñɨ anɨb ak ñɨ yɨbɨl lek, dɨ nap nop ñak. ");
INSERT INTO taw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Binɨb ap yelak okok, God kɨles anɨb ak nɨŋɨd judɨlak. Binɨb kɨli gos pal awl anɨb ak nɨg yelak nɨŋɨd, Jisas bɨne okok kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Takaw agebin awl tɨmud pakɨl, nɨgtep yɨbɨl gɨnɨmɨb agak. Wulep mɨdeb, Bɨ Olap Ñɨne nop mɨmug nɨŋɨd bɨ ogɨnap kɨlop ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Takaw agak anɨb ak, kɨli tɨk nɨgep tek ma lek pɨlɨkɨl, Jisas nop ma agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bɨne okok kɨli ke ag amɨl apɨl gɨl agɨlak, Yad bɨawl mɨden, Yad bɨawl mɨden agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas bɨne okok gos tɨmel nɨgɨlak anɨb ak ke nɨŋɨd, ñɨsɨkol yɨbɨl olap dap ne yek bak sɨŋak lɨl ");
INSERT INTO taw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","agak, Binɨb yɨp gos nɨŋɨd, ñɨsɨkol kɨlop anɨb ak tek dɨnɨgabal okok, kɨlop nep mel, yɨp abe dɨnɨgabal agak. Pen yɨp dɨnɨgabal okok, yɨp nokom mel, Bapi yɨp agyokek ownek ak nop abe dɨnɨgabal agak. Bɨ olap nab nɨbi pi okok yɨb ma mɨdeb ak, ne yɨb mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Anɨb agek Jon agak, Bɨawl. Chɨn nopun, bɨ olap yɨb nep ak agɨl kɨcheki walɨjpal tap okok agyokup agak. Pen chɨn ayɨp ma ajɨpun tek, nop anɨb ak ma gɨnɨmɨn apun agak. ");
INSERT INTO taw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Agek Jisas agak, Taynen nop anɨb apɨm agak? Binɨb nɨbop mɨlɨk ma nepal okok bogɨlak nɨbi agak. ");
INSERT INTO taw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pen God Jisas nop dad man ne alaŋ amnɨg gak ñɨn ak wulep mɨdaknɨŋ, Jisas Jelusalem amnin agɨl gos kɨles gɨl nɨgak. ");
INSERT INTO taw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ak nɨm, bɨ ogɨnap kɨlop ned agyokɨl agak, Nɨbi ned amɨl, kɨneb tep yɨp ak nɨgenɨmɨb agak. Agek, kɨli am Samaliya binɨb kal olap amjakɨl agɨlak, Jisas kɨneb tep nop olap ag dam lɨm agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Agel, binɨb man anɨb okok nɨgɨlak, Jisas Jelusalem amnɨg gek nɨm, kɨlop tep ma gek nop ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma delak nɨŋɨd, bɨne Jemis ayɨp Jon ayɨp, Jisas nop agɨlek, Bɨawl. Chɨn mab mɨŋɨlaŋ wɨsɨp alaŋ nɨb ak agon apɨl, binɨb anɨgɨpal okok kɨlop yɨn gɨnɨmuŋ akaŋ agɨlek? ");
INSERT INTO taw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Anɨb agel, Jisas adɨkɨl kɨlop bɨ omɨŋal ag gak. ");
INSERT INTO taw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Anɨb agɨl, man anɨb ak kelɨgɨl man olap ke amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pen kanɨb nab okok amnɨlaknɨŋ, bɨ olap apɨl Jisas nop agak, Man akal akal amnɨgaban okok, yad ayɨp nep ajonɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Anɨb agek, Jisas nop agak, Yad ayɨp koslam ajenɨgaban agak. Chen ladek okok kal kɨli kɨneb ak, lum mɨgan okok mɨdeb agak. Yawl okok kal kɨli ak ke mɨdeb agak. Pen Bɨ Olap Ñɨne kal kɨneb ne ak ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pen Jisas bɨ olap nop agak, Yɨp kode, yad ayɨp ajol agak. Agek, bɨ anɨb ak pen agak, Yɨp yaw age, yad ned bapi kumek nop kamɨl, nad ayɨp ajonɨgul agak. ");
INSERT INTO taw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Agek, Jisas nop agak, Binɨb pel ma mɨdebal okok, chɨp kumeb anɨb okok kamnɨgel agak. Nad pen am God binɨb dɨl kɨlop kod yenɨgab takaw ak kɨlop agñe amnaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bɨ olap pen agak, Yad nad ayɨp nep ajonɨgabul ak pen, yɨp Yaw age, am ami bapi, mam ay yad okok kɨlop ñɨn pak sakɨl, agñɨl ownɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Agek, Jisas nop agak, Bɨ olap God nop wog ak gɨñin agɨl apɨl, gos tɨmud awl ne ak, adɨkɨd tap ne binɨb ne okok amek, taydɨl God binɨb dɨl kɨlop kod yenɨgab ñɨn ak mɨdɨl, nop wog gɨñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kɨdek Jisas 72 bɨ okok dɨl, kɨlop bɨlokɨl omɨŋal nep, man okok keke agyokɨl agak, Nɨbi ned amɨl takaw yɨp ak agñem, kɨdek yad nɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pen kɨlop takaw paladaŋ lɨl olap agak, Tap wog ak kuŋay yɨbɨl nep mɨdeb ak pen, binɨb tap pɨpag dad owep okok nep kuŋay ma mɨdebal agak. Anɨb ak bɨ wog day nap nɨb anop agnɨgem, binɨb tap pɨpag dad owep ogɨnap agyokek, am pɨpag dad ownɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɨbi pen amnɨmɨb agak. Yad nɨbop chag sipsip tek agyokebin, binɨb chen ladek tek mɨdebal nab okok agak. ");
INSERT INTO taw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nɨbi mani, wad, tob tɨlup okok sek dad ma amnɨmɨb agak. Pen God takaw ak kasek amnaŋ agɨl, binɨb ogɨnap ayɨp kanɨb nab okok takaw pel ma ag yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pen kal olap amjakɨl, kal mɨgan amɨl kɨlop takaw tep won ak agɨl ned agɨnɨmɨb, Mɨdtep gɨnɨmɨb agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Agem, bɨ sayn tep God nop dep tek olap yenɨgab ak, takaw teplep nɨbi anɨb ak dɨnɨgab agak. Pen bɨ anɨb tek ma yenɨgab, takaw teplep adɨkɨd nɨbop ke ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pen kal anɨb anep mɨdɨl, tap mɨdup dap ñel, ñɨbɨlɨg yenɨmɨb agak. Chɨnop tap mɨnek mɨnek ñel ñɨbun ak nebeŋ gup agɨl, kal ak kal ak ma gɨnɨmɨb agak. Bɨ wog gɨpal okok mani dɨpal agak. Anɨb ak tek, kɨlop takaw tep agem nɨgɨnɨgabal tek, nɨbop pen tap mɨdup ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pen man olap amem, nɨbop ag dɨl tap mɨdup ñɨnɨgel, anɨb okok ñɨŋɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Man anɨb ak binɨb tap gɨnɨmuŋ okok gem suŋ lɨnɨmuŋ agak. Binɨb okok mɨdupsek kɨlop agtep gɨl agɨnɨmɨb, God nɨbop dɨl kod yenɨgab ak, wulep mɨdeb agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pen man olap amem nɨbop ma ag del, kanɨb nab sɨŋak amɨl agɨnɨmɨb, Man nɨbi awl apon, sɨlkul dayday dup okok wik nɨbop yɨl yokɨl amobun agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Pen nɨgɨm, God binɨb dɨl kɨlop kod yenɨgab ak, wulep mɨdeb agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yad nɨbop agebin, God kot awl gep ñɨn ak, taun Sodom binɨb tɨmel okok, kɨli mɨŋel dɨnɨgabal agak. Pen binɨb taun nɨbop ma dɨnɨgabal anɨb okok, mɨŋel awl yɨbɨl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Taun Kolasin binɨb okok sek, taun Betsayda binɨb okok sek, yad tap ogɨnap gen, nɨŋɨd kelɨgɨpɨm tek, nɨbi yul awl yɨbɨl dɨnɨgabɨm agak. Pen taun Taya binɨb okok sek taun Saydon binɨb okok sek, tap mageptek anɨb okok ned tek gek nepɨlap ak, tap tɨmel kelɨgɨpɨlap agak. Kelɨgɨl, chech talɨk yowak ogɨnap yɨmɨl, mab tun sɨŋak besɨgɨl, tun dɨlɨg dɨlɨg mɨdebɨlap agak. ");
INSERT INTO taw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, Taya binɨb sek Saydon binɨb sek okok kɨli yul sɨkol olap tek dɨnɨgabal agak. Pen nɨbi Kolasin binɨb sek Betsayda binɨb sek okok yul awl yɨbɨl ak dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pen nɨbi taun Kapeneyam binɨb okok abe, God man ne alaŋ ma amnɨgabɨm agak. God nɨbop pɨsnep mab ke yɨneb kaw mɨgan ayaŋ dɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas bɨne okok kɨlop agak, Binɨb takaw nɨbop dɨpal okok, takaw nɨbop mel, takaw yɨp ak dɨpal agak. Nɨbop ma dɨpal okok, nɨbop mel, yɨp ma dɨpal agak. Pen yɨp ma dɨpal ak, yɨp mel, bɨawl yɨp agyokek ownek ak nop ma dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pen kɨdek bɨne 72 okok, man okok ajɨl adɨkɨd owlak. Apɨlɨg mɨñmɨñ gɨl, Jisas nop agɨlak, Bɨawl. Kɨcheki walɨjpal abe binɨb mulɨk sɨkup okok, yɨb nep ak agɨl, Amnɨm agon, apun tek nɨŋɨd abal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Anɨb agelak kɨlop agak, Yad nɨg yeneknɨŋ, kɨcheki bɨawl kɨli Satan ne God man ne alaŋ kelɨgɨl, añɨñak tek dɨl apyap pakup agak. ");
INSERT INTO taw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nɨgɨm agak. Yoy sɨlaw, godal, Satan tap ne okok mɨdupsek nɨbop gɨ tɨmel gɨnɨgel tek ma lup agak. Nɨbop ñɨnen agebin tek, yuk yokem amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pen kɨcheki okok apun tek nɨŋɨd abal agɨl, mɨñmɨñ ma gɨnɨmɨb agak. God yɨb chɨnop dɨ lup man ne alaŋ agɨl, mɨñmɨñ gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Won anɨb ak Jisas agak, Bapi, nad Bɨawl man nad alaŋ sek lum awl sek kod mɨdeban ak, gos nad ak ke nɨge tep gup adek ak gɨpan agak. Binɨb chɨn binɨb awl gos tɨpagɨl nopun apal okok kɨlop nɨŋɨd, gos tep nad ak dɨ we gɨpan agak. Binɨb chɨn gos tep ma mɨdobun, ñapay sɨkol tek mɨdobun apal okok kɨlop dɨl, gos tep ñɨban ak, nep tep agebin agak. ");
INSERT INTO taw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bapi tap ne ak mɨdupsek yɨp ñub agak. Binɨb okok Ñɨ ak ma nepal, Bapi ne nokom nop nɨgup agak. Pen Bapi nop abe binɨb okok ma nepal, Ñɨ anɨb ak ne nop nɨgup agak. Pen Ñɨ ak ne binɨb gos tep ñin agɨl nɨgup, kɨlop gos tep ñek, Bapi nop nepal agak. ");
INSERT INTO taw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Anɨb agɨl, adɨkɨl bɨne okok nep kɨlop agak, Bɨnonɨm okok sek, bɨ God gos ñek agñeb okok sek, kuŋay yɨbɨl tek yad gɨpin ak takaw apin ak nɨgun agɨl kod yelɨgɨpal ak pen, ma nɨgɨlak agak. God nɨbop nɨm, dɨtep yɨbɨl gek nɨgebɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bɨ God takaw nɨgtep gep olap, Jisas tay tek agɨnɨmuŋ agɨl, apɨl nop agak, Tisa. Yad tɨtay gɨl, pelnep mɨdep ak dɨnɨgayn agak? ");
INSERT INTO taw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Agek nop agak, Mosis God takaw ñu kɨl tɨkak ak, tay agɨl tɨkak agak? ");
INSERT INTO taw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Agek, bɨ Juda takaw nɨgtep gep anɨb ak agak, Buk Baybol pi ak nɨgɨlɨg nepin ak, tɨkɨl agɨlak, Mapen nad ak, kawnan nad ak, kɨles nad ak, gos tɨmud nad ak, mɨdupsek nop yɨl amnɨmuŋ agɨl tɨkɨlak agak. Binɨb ogɨnap kɨlop nad ke mapen lɨpan tek gɨnɨmɨn agɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Anɨb agek Jisas nop agak, Nɨm yɨpɨd gɨl apan ak agak. Anɨb ak kɨdek gɨl, pelnep mɨdep ak dɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Agek, bɨ Juda takaw nɨgtep gep anɨb ak, yɨb yɨp ak sɨkol gɨnɨmuŋ agɨl, ne Jisas nop agnɨŋɨd agak, Buk Baybol kɨl tɨkɨlak ak, nad ke mapen lɨpan tek binɨb ogɨnap kɨlop abe gɨnɨmɨn agɨl tɨkɨlak agak. Anɨb ak binɨb wakay akal kɨlop anɨgobun agɨl tɨkɨlak agak? ");
INSERT INTO taw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Agek, Jisas bɨ Juda takaw nɨgtep gep ak nop kesɨm dɨl agak, Bɨ olap Jelusalem kelɨgɨl, taun Jeliko amnin agɨl, kanɨb nab ak amnak agak. Amɨl, bɨ tap si dep ogɨnap apɨl, nop tapɨn nep pakɨl, chech tap nop okok pɨlɨg dad amnɨlak agak. Gel, ne kanɨb nab sɨŋak kumnɨg kumnɨg gɨ yek agak. ");
INSERT INTO taw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bɨ God nop sɨbogep olap, kanɨb anɨb ak amɨl nɨgak, bɨ anɨb ak kumnɨg gɨ yek agak. Nɨŋɨd, pɨs kɨd amnak agak. ");
INSERT INTO taw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pen bɨ Lipay jɨj ak bɨ olap, ne kanɨb anɨb anep amɨl nɨgak, bɨ anɨb ak kumnɨg gɨ yek agak. Nɨŋɨd, pɨs kɨd amnak agak. ");
INSERT INTO taw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pen bɨ Juda mel, Samaliya plopens nɨb olap abe kanɨb pal nokom anɨb ak nep amɨl nɨgak, bɨ anɨb ak kumnɨg gɨ yek agak. Nɨŋɨd, nop chɨb nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","yek wulep sɨŋak amɨl, soy nop okok wel ñɨg ogɨnap lɨl, ñɨg wayn ogɨnap lɨl tun gak agak. Tun gɨl, dɨ chag donki adek ne ak lɨl, dad amɨl kal mani tawɨl kɨnelɨgɨpal ak dam lɨl, kod mɨdtep yɨbɨl gak agak. ");
INSERT INTO taw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mɨnek amnɨg gɨlɨg, bɨ kal kod yolɨgup anɨb anop mani kɨd nokom olap ñɨl agak, Nad bɨ anɨb awl nop gɨtep gɨnɨmɨn agak. Pen mani tɨtay agɨnɨgaban ak, yad adɨkɨd apɨl, nep ñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas kesɨm anɨb ak agjuwɨl, bɨ Juda takaw nɨgtep gep ak nop agak, Bɨ kanɨb nab paklak ak, bɨ omɨŋal nokom nop nɨŋɨd, bɨ an ne ke nop mapen nɨŋɨd nop gɨtep gak agak? ");
INSERT INTO taw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Agek, bɨ anɨb ak agak, Bɨ nop mapen nɨŋɨd gɨtep gak ak agak. Agek Jisas nop agak, Nɨŋɨd apan. Amɨl nɨm anɨb anep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas bɨne okok ayɨp man olap amjakelak, bin man anɨb ak yek olap kɨlop poŋɨd kal ne ak amnak. Bin anɨb ak yɨb ne Mata. ");
INSERT INTO taw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kal ne ak nɨnay ne olap yek. Yɨb ne Maliya. Bin Maliya anɨb ak Jisas yek wulep sɨŋak ap besɨgɨl, Jisas takaw agaknɨŋ nɨg yek. ");
INSERT INTO taw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata ne ke nep tap mɨdup dagɨl gɨ gɨ, gos kuŋay nɨŋɨd apɨl Jisas nop agak, Bɨawl. Maliya ne yɨp kelɨgek, yad awsek tap chɨn okok dagɨlɨpin agak. Nɨm ak tɨmel gup agak. Nop age apek, omɨŋal gɨl tap dagɨlul agak. ");
INSERT INTO taw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Agek, Jisas agak, Mata. Nep tap anɨb okok nep gos lup agak. ");
INSERT INTO taw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ak tap yokɨp agak. Maliya takaw tep ak din agɨl gos ak nɨŋɨd, ap nɨg mɨdeb agak. Anɨb ak, yad nop kelɨg amnoŋ agɨnɨm tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ñɨn olap Jisas man wakay olap mɨdɨl, God ayɨp agɨl takaw agjuwak. Takaw agjuwɨl, bɨne olap apɨl nop agak, God nop tɨtay dɨl tek apun agak? Jon bɨne okok kɨlop agñek nɨgɨlak tek, chɨnop abe agñe nɨgun agak. ");
INSERT INTO taw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Agek, Jisas kɨlop agak, God nop agɨnɨg, anɨgɨl agɨnɨmɨb agak. Bapi, nad bɨawl tep yɨbɨl mɨdeban ak, yɨb nad dad aplanɨmuŋ agɨnɨmɨb agak. Nad nep bɨnonɨm chɨn mɨdɨl, chɨnop dɨl kod yenɨmɨn agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tap mɨdup okok mɨnek mɨnek ñɨbun tek ak chɨnop ñɨnɨmɨn agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pen binɨb ogɨnap chɨnop gɨ tɨmel gel nɨŋɨd kelɨgɨpun tek, nad tap si tap tɨmel chɨn gɨpun okok tɨg walɨg gɨyokɨnɨmɨn agɨnɨmɨb agak. Chɨnop kod mɨde, gos olap apek chɨn gɨ tɨmel ma gɨnɨgun agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Anɨb agɨl bɨne okok kɨlop agak, Nɨbi olap bogɨlak sek mɨdɨl, kɨsɨlɨm nab awl ayaŋ kal nop ak amɨl agɨnɨgab, Bogɨlak. Bɨyad nɨgep tek olap pal okok nɨb apɨl amnin agɨl, kal yɨp ak apjakek, tap nop ñen ñɨŋɨnɨmuŋ ak ma mɨdeb agɨnɨgab agak. Ma yek nɨm, nep yɨl apebin agɨnɨgab agak. Yɨp bilet omɨŋal nokom ñan agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Agek, bogɨlak nɨbi anɨb ak takaw olap agɨnɨgab, Yɨp anɨgɨl ma ap agɨnɨmɨn agɨnɨgab agak. Yad ñapay yad okok ayɨp kanɨb gɨñɨl kɨnobun agɨnɨgab agak. Anɨb ak taydɨl tɨkjakɨl nep tap ageban ak dɨñɨnɨm agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pen nɨbop agebin, bɨ kal nap nɨb ak, bogɨlak yad agɨl kasek ma dɨñenɨgab agak. Bogɨlak ne ak pen nop ap tepayaŋ agɨl tepayaŋ agɨl gɨnɨgab tek, tap mɨdupsek dɨñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Anɨb ak nɨbop agebin, tap tay tek donɨmuŋ, God nop agnɨgem nɨbop ñɨnɨgab agak. Pen tap tay pɨyownɨmɨb ak abe dɨnɨgabɨm agak. Chɨnop kanɨb ak yɨkaŋ agɨl, pak gigu gem, yɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Taynen? Binɨb an God nop agnepal okok, apal tek gup agak. Tap pɨyowpal ak dɨpal agak. Pen kanɨb ak yɨkaŋ agɨl, pak gigu gel yɨkup agak. ");
INSERT INTO taw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nɨbi bɨ ñapay nap okok, ñapay nɨbi olap kubsal nen agek, yoy tɨmel olap ñɨbɨkep akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Akaŋ pen, yawl mɨdup nen agek, godal olap ñɨbɨkep akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nɨbi bɨ tep mel ak pen, ñapay nɨbi okok kɨlop tap tep nep ñɨbɨm agak. Anɨb ak tek nɨgtep gɨpɨm agak. Bapi nɨbi man ne alaŋ mɨdeb ak, ne bɨ tep yɨbɨl ak, binɨb nop agnɨgel, ne Kawnan ne ak kɨlop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pen bɨ olap kɨcheki mulɨk sɨkek, takaw agɨl mel, yokɨp nep yek. Jisas kɨcheki mulɨk sɨkɨl yek anɨb ak agyokek, bɨ anɨb ak takaw agaknɨŋ binɨb ap nɨg yelak okok, gos pal lɨl wal agɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pen binɨb anɨb okok ogɨnap agɨlak, Jisas ne kɨcheki bɨawl ak Belsebul kɨles ak dɨl kɨcheki nop agyokeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pen binɨb ogɨnap, Jisas tay gɨnɨgab agɨl agɨlak, Tap olap ke ge nɨŋɨd nɨm agɨnɨgabun, Ak God nep agyokek ownak agɨnɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pen kɨli gos yepɨs nɨgɨlak anɨb ak, Jisas nɨŋɨd anɨb agak, Binɨb man awl nokom olap, kɨli asɨk keke lɨl penpen gɨnɨgabal ak, tɨmel gɨl apyap pakɨnɨgabal agak. Taun olap akaŋ bɨ yɨb jɨj nokom olap, asɨk keke lɨl penpen gɨnɨgabal ak, apyap pakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anɨb ak tek, Satan binɨb ne ak asɨk keke lɨl, taydɨl mɨdtep gɨnɨgabal agak? Pen yɨp apɨm, Belsebul kɨles ak dɨl, kɨcheki walɨjpal ag seŋ yokeb apɨm ak, yepɨs apɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pen yad Belsebul kɨles ak dɨl, kɨcheki okok seŋ agyokɨpɨnep, tɨtay dɨl binɨb nɨbi okok kɨcheki seŋ agyokɨpɨlap agak? Kɨli ke nɨbop agɨnɨgabal ak, tap anɨb gep tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pen nɨgɨm agak. Yad God kɨles ak dɨl kɨcheki tap anɨb okok agyokɨpin tek, God binɨb dɨl kɨlop kod yenɨgab ak pɨsnep owup agak. Pen apek nɨbi nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pen bɨ kabɨyam tɨmel olap mɨdɨl, chɨm yakam ne lɨ tep gɨl, kal ne ak yek, tap ne si dɨnɨgab okok mɨdtep yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pen bɨ kabɨyam tɨmel yɨbɨl olap ke apɨl, chɨm nop ak pɨlɨg dɨl, tap si dɨnɨgab okok dɨl, binɨb ogɨnap kɨlop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Binɨb yad yɨl ma mɨdebal okok, Satan yɨl mɨdɨl, yɨp ma dɨpal agak. Pen binɨb yad ayɨp wog ma gɨpal okok, kanɨb day ak ag tɨkel, binɨb yɨp yɨl ownɨg gɨpal okok ma opal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas takaw olap agak, Kɨcheki olap bɨ mulɨk sɨkɨl, seŋ amɨl tep olap nɨŋɨd mɨden agɨl, am man mɨlep okok aj aj mel nɨŋɨd, anɨb agɨnɨgab, Kal mɨgan ned mɨdɨl opin ak amnin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Agɨl, amɨl nɨgɨnɨgab, kal anɨb ak pɨd tep yɨbɨl gel, tep anep yokɨp yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ne nɨŋɨd, okok amɨl kɨcheki tɨmel ne tek mel, kɨcheki tɨmel yɨbɨl anep kugul ak poŋɨd apɨl, mɨgan anɨb ak yenɨgabal agak. Anɨgek, bɨ anɨb ak nop mulɨk sɨkel, ned mɨd tɨmel golɨgup tek mel, pɨsnep mɨd tɨmel yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas anɨb agek nɨŋɨd, bin olap nab anɨb ak tɨkjakɨl suk agɨl agak, Nanɨm nep tɨkɨl tul ñak ak, mɨñmɨñ gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Agek, Jisas pen agak, Mel. Binɨb an God takaw ne ak nɨŋɨd kɨdek gɨnɨgabal okok, mɨñmɨñ gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pen binɨb kuŋay yɨbɨl apnan nan gɨlaknɨŋ Jisas agak, Binɨb mɨñɨl mɨdebal ñɨn nab awl, tap si tap tɨmel gɨpal agak. Anɨb apal, Tap olap ke ge nɨŋɨd anɨb agɨnɨgabun, Nak God wog ak geban agɨnɨgabun apal agak. Pen tap olap ke gen ma nɨgɨnɨgabal agak. Nɨgɨnɨg, Jona bɨlel gak, yad abe gen nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona ne God takaw agñak tek, taun Ninipa binɨb nɨŋɨd God nop gos nɨgɨlak agak. Anɨb tek ak, Bɨ Olap Ñɨne anɨb nep gek, binɨb mɨñɨl mɨdebɨm nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Binawl olap bɨlel binɨb man Sipa pal okok nɨb kɨlop kod yolɨgup agak. Pen ne man palawl anɨb ak kelɨgɨl owak agak. Ne bɨnonɨm Solomon nop nɨgɨnɨg apɨl, gos tep yɨbɨl nop ak nɨgin agɨl owak agak. Ne Solomon bɨ yokɨp ak nop anɨgak ak pen, nɨbi mɨñɨl mɨdebɨm awl, bɨawl yɨbɨl gos nɨgtep yɨbɨl gup ak nop nɨgɨnɨg ma opɨm agak. Anɨb ak God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, binawl anɨb ak tɨkjakɨnɨgab agak. Tɨkjakɨl, binbɨ mɨñɨl mɨdɨl tap si tap tɨmel gɨpɨm anɨb okok agyɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pen Jona ne amɨl, taun Ninipa binɨb okok bɨlel kɨlop agñek nɨŋɨd, tap si tap tɨmel gɨpal ak taynen anɨgɨpun agɨl kelɨgɨlak agak. Jona bɨ yokɨp ak agek nɨg dɨlak ak pen, nɨbi mɨñɨl mɨdebɨm awl, bɨawl yɨbɨl takaw agup ak ma dɨpɨm agak. Anɨb ak God ne aglup ñɨn ak, binɨb ogɨnap kɨlop ag gɨnɨgab ak, taun Ninipa binɨb okok kɨli tɨkjakɨnɨgabal agak. Tɨkjakɨl, binbɨ mɨñɨl mɨdɨl tap si tap tɨmel gɨpɨm anɨb okok agyɨkɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jisas agak, Binɨb okok kɨli sup dagɨl tin mɨgan okok akaŋ, lum mɨgan okok ma lɨpal agak. Adek sɨŋak lel mɨlek gek, binɨb okok kal mɨgan anɨb ak apɨl mɨseŋ nepal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pen wɨdɨn ak sup tek mɨdeb ak nɨm, wɨdɨn nad mɨdtep gek, mubwak nad ak mɨdupsek mɨlek tep gɨl mɨdtep yɨbɨl gɨnɨgab agak. Pen mɨdtep ma gek, kɨsɨlɨm owup tek ak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nab chɨnop ak mɨlek mɨdeb agɨl nɨgɨnɨgabɨm ak pen, kɨsɨlɨm owup tek lup ak, nɨgtep yɨbɨl gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mubwak nɨbop ak mɨdupsek mɨlek yɨbɨl gɨl yenɨgab ak, wakay olap kɨsɨlɨm ma yenɨgab agak. Sup mɨlek gup tek ak, gɨlɨg yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pen Jisas takaw agjuwek, bɨ Pelisi olap nop agak, Ape, kal yad ak amɨl tap ñɨŋul agak. Agek Jisas am kal nop ak besɨgɨl, ");
INSERT INTO taw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","tap ñɨŋak nɨŋɨd, bɨ Pelisi anɨb ak gos pal lɨl, gos ne nab okok nep nɨŋɨd agak, Taynen bɨ anɨb awl, chɨn Juda kay pel gɨpun tek, ñɨn ne ak ñɨg pakup mel agak. Yokɨp nep tap ñɨbeb agɨl, gos ak nɨgak. ");
INSERT INTO taw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gos anɨb ak anɨgɨl nɨgek, Jisas nop agak, Nɨbi Pelisi kay, pilet kap okok seŋ okok ken ñɨg pak tep gɨpal tek ak gɨpɨm ak pen, nab nɨbi ayaŋ tap si tap tɨmel gɨpɨm gach ak aplan jakɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nɨbi sawl sek yɨbɨl mɨdebɨm agak. God nɨbop wak nep ma gɨlak, nab ayaŋ abe gɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Anɨb ak, tap pilet kap mɨgan ayaŋ mɨdeb ak, binɨb yɨmgeptek okok kɨlop ñɨnɨmɨb agak. Anɨgɨl mɨdtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pen Pelisi kay nɨbi tɨtay dɨnɨgabɨm agak. Sɨbɨn tap monmon okok nɨgem, tap awl tek lek, ñɨn pag nɨŋɨd dad amɨl wajɨlem ak amub agak. Amek, God nop nokom olap ñun agɨl pel ñɨbɨm agak. Ak tep gɨpɨm, takaw ma mɨdeb agak. Tap sɨkol okok pel anɨgɨl gɨpɨm ak pen, taynen takaw jɨj yɨbɨl ak abe ma gɨpɨm agak. Nɨbi God ne gos teplep nɨgup pal ak kelɨgɨpɨm agak. God nop nokom gos lɨnɨgep pal ak abe kelɨgɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nɨbi Pelisi kay tɨtay dɨnɨgabɨm agak. Gos nɨbi nepɨm ak, chɨn Juda apnan gɨpun kal nab ak besɨgun akaŋ, takaw apal nab ak amon, apebɨm ey agel, yɨb chɨnop anep dad aplanɨlaŋ agɨl gos ak nokom nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nɨbi tɨtay dɨnɨgabɨm agak. Binɨb ogɨnap nɨŋɨd nɨbop bɨ tep yɨbɨl apal ak pen, chɨp kaw mɨgan ayaŋ mɨdeb tek ak mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Anɨb agek, bɨ Juda takaw nɨgtep gep olap Jisas nop agak, Tisa. Takaw kɨles tɨmel yɨbɨl apan anɨb ak, chɨnop abe apan agak. ");
INSERT INTO taw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Agek Jisas agak, Nɨbi bɨ Juda takaw nɨgtep gep okok tɨtay dɨnɨgabɨm agak. Binɨb okok kɨlop tap mɨŋel ñem koslam yɨbɨl dɨlak, kɨlop chɨb nɨŋɨd ma tɨg sak dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Anɨb ak tɨtay dɨnɨgabɨm agak. Nased yes nɨbi okok bɨlel, kɨli bɨ God gos ñek agñeb okok kɨlop pakelɨgɨpal agak. Paklɨl kamelɨgɨpal tep ak, mɨñɨl nɨbi kɨpel gɨtep gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gɨpɨm anɨb ak kubɨkayu gɨl gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","God gos ke nɨgup tek agak, Bɨ God gos ñek agñeb ogɨnap, bɨ takaw yɨp dad ameb ogɨnap, kɨlop agyokɨnɨgayn ak pen, kɨlop yɨlɨk nɨŋɨd, ogɨnap gɨ tɨmel gɨnɨgabal, ogɨnap pɨsnep paklɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pen bɨlel man alwol gɨlak ñɨn ak tɨkɨl, bɨ God gos ñek agñeb okok kɨlop pel pakel owup tek, binɨb mɨñɨl mɨdebal okok takaw mɨŋel anɨb ak mɨdupsek dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mɨŋel anɨb ak nɨm, bɨ Ebel nop ned jɨj gɨl paklɨl, ñag dad apɨl, ñag dad apɨl, kɨdek Sekalaya nop paklɨlak agak. God nop agnɨgep kal awl ak adaŋ, God nop tap ñeb tep ak adaŋ, nab sɨŋak nop ñaglɨlak agak. Nɨbop nɨŋɨd yɨbɨl apin agak. Takaw mɨŋel anɨb ak mɨdupsek binɨb mɨñɨl mɨdebal okok dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pen nɨbi bɨ Juda takaw nɨgtep gep okok tɨtay dɨnɨgabɨm agak. Ki dɨl kanɨb ak yɨkɨl, kal mɨgan amɨl nɨgtep gep ki ak, yɨlɨk gek kelɨgɨpɨm agak. Kelɨgɨl, binɨb kal mɨgan amnɨg gɨpal okok kɨlop pel kanɨb day ak ag tɨkɨpɨm agak. Anɨb ak nɨgtep yɨbɨl gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisas kɨlop anɨb agɨl, seŋ amnak. Bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, nop yɨlɨk nɨŋɨd agɨlak, Takaw tay ak agon, pen agek nɨŋɨd nop dam ag gɨl amnun agɨlak. Anɨb ak Jisas nop takaw yepɨs yepɨs adek okok agnɨgelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pen won anɨb ak, binɨb kuŋay yɨbɨl apnan gɨl tɨbɨk dɨlaknɨŋ, Jisas bɨne okok kɨlop ned agak, Pelisi kay kɨli pel tɨmel gɨpal ak we gɨl, mɨdtep gɨpun apal agak. Nɨbi abe anɨgɨl gɨnɨmɨb tek lup anɨb ak tek, nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Takaw tay mɨñɨl yu gɨl mɨdeb ak, kɨdek mɨseŋ yenɨgab agak. Tap tay kɨmɨgel we gɨpal okok, kɨdek nɨgtep gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pen takaw kɨsɨlɨm ken apɨm ak, mɨlek sek nɨgɨnɨgabal agak. Takaw kɨmɨgel kal mɨgan okok apɨm ak, kal adek alaŋ agel, yɨg dad man okok amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jisas takaw olap agak, Binɨb yad okol agak. Nɨbop agebin, chɨnop ñagɨnɨgabal agɨl ma pɨlɨkɨnɨmɨb agak. Ak yokɨp mubwak adek anep ñagel, kuy gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anɨb ak nɨbop agebin, pɨlɨkɨnɨg, God nɨbop paklɨl, mab ke yɨneb dɨyokɨnɨgab ak nop pɨlɨkɨnɨmɨb agak. Anɨb ak nɨbop nɨŋɨd yɨbɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nɨb nepɨm, yawl sɨkol anep mamɨd ak yokɨl, mani pɨñ sɨkol won omɨŋal nep dɨpal agak. Yawl sɨkol anɨb okok, God ma nɨgɨnɨmuŋ tek olap ma mɨdeb, mɨdupsek nɨgup ak nep mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anɨb ak nɨŋɨd kɨmɨg wɨj nɨbop ak mɨdupsek ñɨn pagup, gos sek yenɨmɨb agak. Ma pɨlɨkɨnɨmɨb agak. Nɨbi binɨb okok, binɨb yɨbɨl agak. Yawl okok tek ma mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jisas takaw olap agak, Nɨbop agebin, binɨb an Jisas yɨl mɨdobun agɨl, binɨb mɨdebal nab ak takaw anɨb ak agyɨkel, kɨlop pen yɨp yɨl mɨdebal agɨl, ensel mɨdebal nab ak takaw anɨb ak agyɨkɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pen binɨb an Jisas yɨl ma mɨdobun agɨl, binɨb mɨdebal nab ak takaw anɨb ak agel, kɨlop pen yɨp yɨl ma mɨdebal agɨl, ensel mɨdebal nab ak agɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bɨ Olap Ñɨne nop agjuwenɨgabal, God nɨŋɨd gach kɨlop tɨg walɨg gɨyokɨnɨgab agak. Pen God Kawnan nop ak agjuwenɨgabal, ne nɨŋɨd gach ma tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pen nɨbop ag gɨnɨg, dad Juda apnan gɨpal kal ak nab ak amel akaŋ, bɨawl nab ak amel akaŋ, gapman bɨawl mɨdebal nab ak dad amnɨgabal agak. Dad amel, takaw tɨtay pen agɨnɨgun akaŋ, kɨlop pen takaw tay ak dɨl agɨnɨgun agɨl gos ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Apek nɨŋɨd, God Kawnan ak nɨbop gos ñek agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Binɨb kuŋay yelak nab anɨb ak, bɨ olap Jisas nop agak, Tisa. Mam yad ak nop age, bapi tap ne dɨlɨl kumak okok, bɨlok yɨp pɨs ak ke ñaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Agek Jisas pen nop agak, Bɨ an yɨp agup, Nad bɨ tap pak asɨk ñeb ak mɨdenɨmɨn agek, tap nɨbop okok pak asɨk ñɨnɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Agɨl, kɨlop mɨdupsek agak, Tap chɨn ke kuŋay yɨbɨl dun agɨl gos ak ma nɨgɨnɨmɨb agak. Tap dun agɨl nepɨm anɨb okok, nɨbop gek mɨdtep gɨnɨmɨb tek ma lup agak. Anɨb ak nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pen Jisas takaw olap kɨlop paladaŋ lɨl agak, Bɨ mani kuŋay yenɨgab olap, wog day ne ak tap mɨdup kuŋay yɨbɨl jakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gos ne okok nep gos kuŋay nɨŋɨd agɨnɨgab, Tay dɨnɨgayn agɨnɨgab agak? Tap ñɨŋeb yad kuŋay mɨdeb ak, kal mɨgan akal dap lɨnɨm agɨl nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pen gos olap nɨŋɨd agɨnɨgab, Kal sɨkol okok tɨbɨlɨk yokɨl, kal awl okok nep gɨl, tap mɨdup ak sek, tap yad okok mɨdupsek dɨ kal mɨgan anɨb okok lɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lɨl, kɨdek wog ak kelɨgɨl, sub kuŋay yɨbɨl tap yad anɨb okok nep ñɨbɨlɨg, ñɨg ñɨbɨlɨg, mɨñmɨñ gɨlɨg gɨ yenɨgayn agɨl nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pen anɨgɨl nɨgek, God nop agɨnɨgab, Nad bɨ sawl sek yɨbɨl agɨnɨgab agak. Mɨñɨl kɨsɨlɨm nab ayaŋ nep kume, tap nad kuŋay nep mɨdeb anɨb okok an tek dɨnɨgab agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Anɨb ak tek nɨm, binɨb tap kɨli okok nep mapen tɨkjakek, God kɨlop nɨŋɨd binɨb yokɨp agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas anɨb agɨl, bɨne okok kɨlop agak, Anɨb ak tek nɨbop agebin, tap akal nɨb dɨl tap mɨdup ñɨbɨl yonɨgun, chech akal nɨb dɨl yɨmɨl yonɨgun agɨl, gos awl ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nɨŋɨd apin, pel mɨdep nɨbi ak tap awl yɨbɨl agak. God nɨbop gɨlak ak, tap ñɨŋeb nep pɨyow nɨgɨnɨgel, chech nep pɨyow nɨgɨnɨgel agɨl ma gɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nɨb nepɨm, yawl okok tap yɨŋ ma yɨbal, tap ñɨŋeb okok ma tɨk dap nan gɨpal agak. Tap mɨdup pɨpag dap nan gɨnɨgel kal kɨli ogɨnap ma mɨdeb agak. God nep nɨm, kɨlop tap ñɨl kod mɨdek, tap ñɨbal agak. Ne yawl tap yokɨp ak anɨgɨl gup, nɨbi pen binɨb yɨbɨl ak, taynen chɨnop ma kod yenɨgab agɨl gos kuŋay nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gos kuŋay nɨŋɨd, kumnɨg gɨnɨgabɨm ñɨn ak kelɨgɨnɨgabɨm akaŋ agak? Nak tap lum awl yɨl ak gos kuŋay nɨgenɨgaban, ñɨn olap tapɨn yenɨgaban akaŋ agak? Mel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gos nepɨm anɨb ak, God gɨnɨg gɨpɨkop, ak tap sɨkol agak. Pen nɨbi ke tap sɨkol anɨb ak gep tek ma lek, taynen tap okok gos kuŋay nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nag be okok jakɨl, mɨdup pulɨnɨg sum gup okok nɨŋɨd, gos nɨgtep gɨnɨmɨb agak. Chech tap okok wog kɨles gɨnɨgel tek ma lup ak pen, nag sum teplep yɨbɨl okok mɨdeb agak. Yad nɨbop agebin, bɨnonɨm Solomon tap kuŋay mɨdɨl chech teplep yɨbɨl yek ak pen, nag mɨdup mokayaŋ gɨñub anɨb ak tek, Solomon ne ma yek agak. ");
INSERT INTO taw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tap be okok jakup anɨb okok tap yokɨp, pel ma yenɨgab agak. Pel mɨdɨl mel, mɨñɨl tek mɨdɨl, tol tek tɨpagɨlɨl dagɨlɨnɨgabal agak. Pen God tap yokɨp anɨb okok gɨlɨl mokayaŋ gɨñub ak, taynen God chɨnop mokayaŋ ma gɨñɨnɨgab agɨl gos kuŋay nepɨm agak? Nɨbi God nop gos lɨnepɨm ak sɨkol gup agak. ");
INSERT INTO taw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pen chɨn tap mɨdup, ñɨg, tap okok akal nɨb dɨl ñɨŋɨnɨgun agɨl gos ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Binɨb God takaw ak ma nepal okok, tap anɨb okok mɨdupsek dun agɨl gos awl anɨb ak tek nepal agak. Pen Bapi nɨbi man ne alaŋ mɨdeb ak, ne tap tɨtay nɨbop tek dup ak nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pen tap ned adek ak anɨgɨl mɨdeb, nɨbi God binɨb dɨl kɨlop kod yenɨgab ak gos kɨles gɨl, kɨdek gɨnɨmɨb agak. Anɨgenɨgabɨm, tap okok mɨdupsek abe nɨbop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jisas takaw olap agak, Chag sipsip ñɨluk tun awl agak. Nap nɨbi ak, binɨb dɨl kɨlop kod yenɨgab ak, tap anɨb ak dɨl nɨbop ñɨnɨgab agak. Anɨb ak ma pɨlɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tap nɨbi mɨdeb okok tawɨl mani dɨl, binɨb tap ma mɨdeb okok kɨlop ñɨnɨmɨb agak. Anɨgɨnɨgabɨm, mani tap teplep tek yenɨgab, God man ne alaŋ agak. Ma kul gɨnɨgab agak. Bɨ si dep ogɨnap ma si dɨnɨgabal agak. Kɨchɨl gɨlobɨd ma ñɨŋɨnɨgab agak. Mel yɨbɨl, pelnep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tap teplep nɨbi okok lum awl dɨ nan gem, gos nɨbop ak yenɨgab lum awl agak. Pen man adek alaŋ dɨ nan gem, gos nɨbop ak yenɨgab anɨb alaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisas takaw olap agak, Anɨb ak chech nɨbi ak dem apek, wulep wulep pagɨl, sɨbnag pak tɨbɨkɨl, sup ak dagɨl lɨl, kod yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bɨ wog gɨñeb okok agɨnɨgabal, Bɨawl chɨn ak, bin dɨlɨg tap awl ñɨbebal nab ak amub ak, sayn adɨkɨd ownɨgab agɨnɨgabal agak. Agɨl, nɨg nep yenɨgabal agak. Bɨawl kɨli ak gɨ ajɨl ap kanɨb ak pak gigu gek, kasek yɨkɨnɨgabal agak. Nɨbi anɨb ak tek gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pen ne adɨkɨd apɨl nɨgɨnɨgab, kɨli nɨg yenɨgabal ak, kɨlop dɨtep yɨbɨl gɨnɨgab agak. Nɨŋɨd yɨbɨl agebin, bɨawl anɨb ak ne ke, chech ne ak lɨpɨgek apek wulep wulep pagɨl, sɨbnag pak tɨbɨkɨnɨgab agak. Tɨbɨkɨl kɨlop agek, am tap lɨñɨbal tep ak am besɨg kuskus gel, ne ke kɨlop tap ñɨŋeb ak dam ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pen bɨawl ak kɨsɨlɨm nab ayaŋ akaŋ, kakaluk agaknɨŋ apɨl nɨgɨnɨgab, bɨne okok wɨsɨn ma kɨnenɨgabal, kɨlop dɨtep yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anɨb ak nɨgɨm. Bɨ kal nap nɨb ak, ne bɨ tap si dep ak won akal apeb agɨl nɨŋɨd nɨm, wɨsɨn ma kɨnɨl nɨg yek, bɨ tap si dep ak kal bog tɨkɨl kal mɨgan ma ownɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anɨb ak tek nɨbi abe nɨgtep gɨl yenɨmɨb agak. Mel ak, Bɨ Olap Ñɨne ma apeb agɨl, sawl gɨl yenɨgabɨm ñɨn ak ne ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas anɨb agek Pita agak, Bɨawl. Takaw paladaŋ lɨl apan anɨb ak, chɨnop nep apan akaŋ, binɨb mɨdupsek apan agak? ");
INSERT INTO taw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Agek Jisas agak, Bɨ an gos tep yek, wog gɨtep yɨbɨl gɨnɨgab ak, bɨawl ne ak amnɨg gɨl nop agɨnɨgab, Binɨb wog yɨp gɨñɨbal okok kɨlop kod yenɨmɨn agɨnɨgab agak. Tap ñɨŋeb kɨlop okok bɨlok ñɨlɨg gɨ yenɨmɨn agɨnɨgab agak. Agɨl amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kɨdek adɨkɨd apɨl, bɨ wog gɨñeb ne ak agɨnɨgab tek gɨnɨgab ak, Bɨawl ne nop dɨtep yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nɨŋɨd yɨbɨl apin, nop agek tap anɨb okok mɨdupsek kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pen bɨ wog gɨñeb ne ak wog nop gɨnɨgab ak, bɨawl yad ak kasek ma ownɨgab agɨl, binɨb wog gɨñɨbal okok kɨlop tapɨn pakɨnɨgab agak. Pakɨl, tap ñɨbɨl, ñɨg kɨles ñɨbɨl sawl lɨl gɨ yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pen bɨawl ak kasek ma ownɨgab agɨl nɨgɨnɨgab ak, ñɨn ak apɨl, nop tɨmel yɨbɨl gɨl, binɨb takaw tɨpagɨlɨpal nab okok nop agyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bɨawl ak apɨl, takaw ne agak ak nɨgtep gɨl pen ma kɨdek genɨgabal, binɨb okok kɨlop tapɨn pakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Takaw ne agak ak pen ma nepal tɨmel gɨnɨgabal okok, ne kɨlop sɨkol pakɨnɨgab agak. Pen anɨb ak tek, God kɨlop tap awl ñɨl, pen anɨb ak tek ñɨlaŋ agɨnɨgab agak. Pen tap kuŋay nep dɨ ñɨn adek kɨlop ak lek, pen abe tap kuŋay yɨbɨl yɨp ñɨlaŋ agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas takaw olap agak, Yad opin ak, lum awl sup pug agɨlɨnɨg opin agak. Kasek yɨnɨpɨkop ak tep agak. ");
INSERT INTO taw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yad yul awl dɨnɨgayn ak, yɨp mɨŋel yɨbɨl geb agak. Anɨb ak pɨsnep den nɨm, yɨp tep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɨbi yɨp agɨnɨgabɨm, Binɨb dɨ jɨmñɨnɨg opan agɨnɨgabɨm agak. Pen ak mel agak. Yad opin tek, gos adek keke nɨŋɨd asɨk keke lɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mɨñɨl ñɨn awl tɨkɨl, amɨlɨgon apɨlɨgon anep mamɨd tek yenɨgabal ak agak. Omɨŋal nokom yɨp dɨl, omɨŋal yɨp ma dɨl, asɨk keke lɨnɨgabal agak. Pen mel ak, omɨŋal yɨp dɨl, omɨŋal nokom yɨp ma dɨl, asɨk keke lɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bɨ apɨlmɨŋal ak, ñɨne akaŋ nap, yɨp ma dek nɨm asɨk keke lɨnɨgayl agak. Bin amɨlmɨŋal ak, pay ne akaŋ nonɨm, yɨp ma dek nɨm asɨk keke lɨnɨgayl agak. Nonɨm ayɨp, ñɨne bin ak ayɨp abe, nonɨm akaŋ ñɨne bin ak, yɨp ma dek nɨm asɨk keke lɨnɨgayl agak. ");
INSERT INTO taw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pen Jisas takaw olap sek kɨlop agak, Sub saŋɨd amub okok ken wɨsɨp lek nɨŋɨd apɨm, Mɨñɨl man pakɨnɨgeb agem, apɨm tek nep man pakup agak. ");
INSERT INTO taw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɨgen awl ak ayɨm ken apek nɨŋɨd apɨm, Mɨñɨl sub awl gɨnɨgeb agem, apɨm tek nep sub awl ak gup agak. ");
INSERT INTO taw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tap wɨsɨp adek alaŋ nɨgtep gɨl, lum awl nɨgtep gɨl gɨpɨm ak pen, taynen ñɨn anɨb awl tap anɨb okok anɨgup agɨl ma nepɨm agak? Nɨbi bɨ takaw yepɨs apɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Pen taynen God kanɨb tep adek pɨyow nɨŋɨd dɨnɨmɨb ak mɨdaknɨŋ, tap yepɨs okok apun tek gup agɨl nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bɨ olap nep kot dad amebin agek, kot awl anɨb ak taynen amebin agɨl kanɨb nab okok amɨlɨg, nod ayɨp takaw ag tɨg asɨk lɨtep gɨnɨmɨn agak. Pen mel ak, nep dam bɨawl takaw tɨg asɨkep ak nop ñek, ne pen nep dɨl bɨ nag lep ak nop ñek, nep dam nag lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yad nep agebin, nag lel yenɨgaban agak. Tap day nad okok pɨsnep day pag dɨl tek, seŋ amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Won anɨb ak nep, binɨb ogɨnap apɨl Jisas nop kesɨm dɨl agɨlak, Galili plopens binɨb ogɨnap, kɨli apɨl God agnɨgep kal awl ak tap sɨbog ñɨlak agɨlak. Ñɨlaknɨŋ, gapman bɨawl Paylat kɨlop pɨsnep paklek, nɨkɨm kɨlop yowak agɨlak. Chag sipsip paklel nɨkɨm yowak nab sɨŋak agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Agelak Jisas kɨlop agak, Nɨbi agɨnɨgabɨm, Galili binɨb ogɨnap tap si tap tɨmel sɨkol gɨlak tek, kɨli pen tap si tap tɨmel awl yɨbɨl ak gel yul dɨlak agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ak mel agak. Pen nɨŋɨd yɨbɨl agebin, tap si tap tɨmel gɨpɨm okok kelɨgɨnɨmɨb agak. Mel ak, nɨbop abe gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pen kal palawl olap pagak, ñɨg cheb Silowam gol okok agak. Pagɨl, binɨb anep kagol pɨs ak kɨlop paklak, ak nepɨm agak. Pen nɨbi agɨnɨgabɨm, Jelusalem binɨb ogɨnap tap si tap tɨmel sɨkol gɨlak tek, kɨli pen tap si tap tɨmel awl yɨbɨl ak gel God gek kal anɨb ak pagɨl kɨlop paklak agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pen ak abe mel agak. Nɨŋɨd yɨbɨl agebin, tap si tap tɨmel gɨpɨm okok kelɨgɨnɨmɨb agak. Mel ak, nɨbop abe gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pen Jisas takaw olap paladaŋ lɨl agak, Bɨ olap mab pik mɨdup ak pulaŋ agɨl, yɨŋ ak ju dad apɨl, nag wayn wog nab ne ak yɨmnɨgab agak. Kɨdek adɨkɨd apɨl nɨgɨnɨgab, mɨdup ma nep pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nɨŋɨd, bɨ wog gɨñeb ne ak nop agɨnɨgab, Sub omɨŋal nokom yɨnak pel apɨl nepin, mab pik yɨmnek ak mɨdup ñɨŋeb ak ma nep pulup agɨnɨgab agak. Anɨb ak wog day nab yɨp ak mɨdek tep ma gup agɨnɨgab agak. Tɨb yokɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Agek, bɨ wog gɨñeb ne ak agɨnɨgab, Bɨawl. Mab pik anɨb ak mɨñɨl ma tɨb yokep agɨnɨgab agak. Yad mab pik jɨj anɨb ak kɨpel gɨtep gɨl, tap dayday ogɨnap dap lɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anɨgen, sub kɨdek ak mɨdup pulek, kelɨgɨnɨmɨn agɨnɨgab agak. Pen ma pulek, ak tɨb yokɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pen Juda añɨŋ lep ñɨn awl olap, Jisas ne Juda apnan gɨpal kal mɨgan ak amɨl, kɨlop takaw agñɨ yek. ");
INSERT INTO taw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kal mɨgan anɨb ak, bin olap ap yek. Bin anɨb ak, kɨcheki gek kud ak ñɨk gɨl nep ajek ajek, sub yɨn kagol pɨskɨd lak ak. ");
INSERT INTO taw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas bin anɨb anop agek apek agak, Tap nep gup ak suŋ lup agak. ");
INSERT INTO taw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Anɨb agɨl nop dɨnɨgaknɨŋ, kud ak yɨpɨd gek, God yɨb nop ak dad aplanak. ");
INSERT INTO taw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pen Juda añɨŋ lep ñɨn awl ak gek suŋ lek nɨŋɨd, Juda apnan gɨpal kal ak bɨawl ak nop mɨlɨk yowak. Yapek, binɨb ap yelak okok kɨlop agak, Nɨbi binɨb tap gup okok, wog ñɨn anep kagol ak mɨdeb, apem gek suŋ lɨnɨmuŋ agak. Ñɨn awl wog ma gep ñɨn ak pen, ma gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Anɨb agek Jisas agak, Chag bulmakaw chag donki nɨbi okok kal tunɨg lem yenɨgab ak, añɨŋ lep ñɨn awl chɨn ak ñɨg nen gek, nag wɨsɨbɨl poŋɨd dad amem ñɨg ñɨbal agak. Ak tep gɨpɨm agak. Pen based yes chɨn Eblaham tɨkek, tɨk dad amɨl tɨkɨpal bin anɨb awl, Satan nop bɨlel tun gɨlek sub yɨn kagol pɨskɨd lup ak, nop chɨb ma nepɨm agak? Mɨñɨl añɨŋ lep ñɨn awl chɨn, nag nop ak tɨg asɨken takaw awl agebɨm agak? Anɨb ak tay yepɨs yɨbɨl apɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas anɨb agek, bɨ kɨli nop mɨlɨk nɨgɨlak okok, kɨlop nebeŋ yɨbɨl gak. Pen binɨb yokɨp okok kɨli Jisas tap teplep yɨbɨl pel gup okok nɨŋɨd, mɨñmɨñ yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas takaw olap sek agɨl agak, God binɨb dɨl kɨlop kod yenɨgab takaw agɨnɨgebin ak, taydɨl tek agen nɨgtep gɨnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nɨm takaw adek agɨnɨgebin awl tek mɨdeb agak. Bɨ olap mab mastet mɨdup sɨkol olap dɨl, wog day ne ak yɨmek, jak awl gɨl, lek tep ak pakek yawl okok ap lɨ yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Takaw olap pen tep ak agak, God binɨb dɨl kɨlop kod yenɨgab takaw ak, taydɨl tek agen nɨgtep gɨnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nɨm takaw adek agɨnɨgebin awl tek mɨdeb agak. Bin olap yis ak sɨkol bad olap dɨl, palaw tin awl ak sek tɨg adɨk madɨk gek, mɨdɨlɨg awl yɨbɨl tanub tek ak gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pen Jisas Jelusalem amnɨg, yɨpɨd gɨl ma amnak. Ne taun okok sek, man sɨkol okok sek, nab nab kɨnɨlɨg takaw agñek amnak. ");
INSERT INTO taw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Binɨb anɨb yelak okok, olap Jisas nop agak, God binɨb nɨnokom ogɨnap nep dɨnɨgab agak? Agek, Jisas kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Binɨb kuŋay yɨbɨl nep, kanɨbtub sɨkol tam anɨb ak amnun agɨl, am tɨwalɨk gɨ mel nɨgɨnɨgabal agak. Anɨb ak nɨbop agebin, Nɨbi kɨles gɨl nep kanɨbtub sɨkol tam ak amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kɨdek bɨ kal nap nɨb ak tɨkjakɨl kanɨb ak gɨñek, nɨbi seŋ okok mɨdɨl, pak gigu gɨl agɨnɨgabɨm, Bɨawl. Kanɨb ak yɨkan agɨnɨgabɨm agak. Agem, ne agɨnɨgab, Yad nɨbop ma nepin. Nɨbi akal nɨb agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Agek, nɨbi pen agɨnɨgabɨm, Nad ned man chɨnop ak apɨl takaw agñolɨgɨpan, nad ayɨp tap ñɨbolɨgɨpun agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Agem nɨbop agɨnɨgab, Yad nɨbop ma nepin agɨnɨgab agak. Nɨbi akal nɨb agɨnɨgab agak? Nɨbi binɨb pel gɨ tɨmel yɨbɨl gɨpɨm okok, yɨp kelɨgɨl ke okok amnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kɨdek nɨgɨnɨgabɨm, Eblaham, Aysak, Jekop, bɨ God gos ñek agñeb okok, God kɨlop dɨl kod yenɨgab ak pen, nɨbop ag seŋ yokek, chaŋ tɨmel lɨl meg sulɨlɨg yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pen binɨb Juda mel okok, ogɨnap sub lɨm gup okok ken apɨl, ogɨnap saŋɨd amub okok ken apɨl, ogɨnap adaŋ nɨb apɨl, ogɨnap adaŋ nɨb apɨl, God kɨlop dɨl kod mɨdek, tap ñɨbɨlɨg yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Anɨb ak, binbɨ kasek amnun agɨl ned abal, kɨli kɨdek amnɨgabal agak. Pen binbɨ kɨdek abal okok, kɨlop tawsak lɨl ned amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Won anɨb sɨŋak nep bɨ Pelisi ogɨnap apɨl, Jisas nop agɨlak, Gapman bɨnonɨm Helod nep paklɨnɨgeb agɨlak. Man awl kelɨgɨl, man olap ke amnɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Agelak Jisas agak, Nɨbi am chen ladek anɨb ak nop agɨnɨmɨb, Nɨg mɨdenɨmɨn agɨnɨmɨb agak. Mɨñɨl sek, tol sek, binɨb tap gup okok gen suŋ lɨl, binɨb kɨcheki walɨjpal mulɨk sɨkup okok gen binɨb yɨbɨl lɨl gɨnɨgab agɨnɨmɨb agak. Mɨyad nɨm, wog yad ak gɨdɨnɨgayn agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pen mɨñɨl ñɨn kab ak, yad amnin agak. Jelusalem amen yɨp paklɨnɨgel agak. Bɨ God gos ñek agñeb okok kɨlop man pal okok ma paklɨpal, pel Jelusalem nep paklɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jisas takaw olap agak, Jelusalem binɨb agak. Bɨ God gos ñek agñeb okok sek, God ne bɨ nɨbop yɨl agyokek opal okok sek, taynen pel kab dɨl kɨlop paklɨpɨm agak? Pen yad pel binɨb nɨbop okok yawl kakaluk ñɨluk tek pɨl muk okok lɨnɨm agen, yɨp yɨlɨk nɨŋɨd ma dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Anɨb ak nɨgɨm agak. Kal nɨbi ak yokɨp yɨbɨl yenɨgab agak. Yad nɨbop agebin, yɨp kasek ma nɨgɨnɨgabɨm agak. Kɨdek agɨnɨgabɨm, Bɨ Bɨawl ne agyokek owup ak, Bɨawl ne bɨ anɨb ak nop gɨtep gɨnɨmuŋ agɨnɨgabɨm agak. Ñɨn anɨb ak nep yɨp nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juda añɨŋ lep ñɨn awl olap, Jisas amɨl, Pelisi bɨawl olap kal nop ak tap ñɨŋɨnɨg amnak. Amek, Jisas nop tay tek gɨnɨmuŋ agɨl nɨŋɨjsek lɨl yelak. ");
INSERT INTO taw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pen ñɨn anɨb ak, bɨ ñɨn tob su gak olap apɨl, Jisas tob agen wulep sɨŋak yek. ");
INSERT INTO taw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas bɨ anɨb anop nɨŋɨd, bɨ Pelisi okok sek, bɨ Juda takaw nɨgtep gep okok sek kɨlop agak, Bɨ tap gup okok, añɨŋ lep ñɨn awl chɨn ak kɨlop gon suŋ lɨnɨmuŋ akaŋ mel agak? ");
INSERT INTO taw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Agek, takaw olap pen ma yɨbɨl agelak, ne bɨ ñɨn tob su gak anop dɨnɨgek, suŋ lek, nop agyokek tɨkjakɨl amnak. ");
INSERT INTO taw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Amek, Jisas bɨ anɨb okok kɨlop agak, Añɨŋ lep ñɨn awl chɨn ak ñɨ nɨbi olap akaŋ, chag bulmakaw nɨbi olap, ñɨg malɨpɨm kaw mɨgan ayaŋ pakek, kasek dem ownɨgab akaŋ mel agak? ");
INSERT INTO taw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Agek pen takaw olap ma yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pen bɨ anɨb okok tap ñɨŋɨnɨg, besɨgep adek teplep okok nep besɨgel amnaknɨŋ, Jisas nɨŋɨd takaw olap paladaŋ lɨl agak, ");
INSERT INTO taw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Bɨ olap bin dɨnɨg gɨl, tap awl ñɨŋɨnɨg nɨbop suk agek amɨl, besɨgep teplep lɨnɨmuŋ adek ak ma besɨgɨnɨmɨb agak. Bɨ anɨb ak ne, bɨawl yɨbɨl olap apɨl besɨgaŋ agɨl, lɨnɨmuŋ tek lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anɨb ak nɨbi adek anɨb ak besɨgenɨgabɨm, bɨ nɨbop suk agɨnɨgab ak apɨl agɨnɨgab, Nɨbi ke sɨŋak amem, bɨawl yɨbɨl ak awl besɨgaŋ agɨnɨgab agak. Anɨb age, nɨbop nebeŋ gaknɨŋ am gol okok besɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pen nɨbop tap ñɨŋɨm agɨl suk agonɨmuŋ, amɨl gol okok besɨg yenɨmɨb agak. Anɨgem, bɨ anɨb ak apɨl agɨnɨmuŋ, Bogɨlak sɨkop, nɨbi apɨl besɨgep tep adek awl besɨgɨm agɨnɨmuŋ agak. Agek, binɨb tap ñɨŋɨnɨg ap yenɨgabal okok nɨbop nɨŋɨd anɨb agɨnɨgabal, Bɨawl mɨdebal agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anɨb ak tek, binɨb chɨn yɨb awl mɨdeb agɨl nepal okok, God gek yɨb kɨlop apyownɨgab agak. Pen binɨb chɨn yɨb ma mɨdeb agɨl nepal okok, God gek yɨb kɨlop yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas takaw anɨb ak agɨl, bɨ Pelisi anɨb ak tap ñɨŋɨnɨg binɨb suk agak ak nop agak, Nad tap awl ñɨŋɨnɨg, namam nak okok, bogɨlak nak okok, binɨb man nak jɨmñɨl okok, bɨ mani kuŋay yenɨgab okok, kɨlop suk ma agɨnɨmɨn agak. Ak nep pen abe ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tap awl ñɨŋɨnɨg, binɨb yɨmgeptek okok, binɨb ñɨn tob pag pakek amdɨp okok, binɨb wɨdɨn koy gup okok, binɨb tob tɨmel gup okok, kɨlop suk age apɨl tap ñɨŋɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Binɨb yɨmgeptek anɨb okok, pen ñɨnɨgel tek ma lɨnɨgab ak nɨm, God binɨb teplep ne okok gek tɨkjakɨnɨgabal ñɨn ak, tap teplep yɨbɨl nep pen ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pen takaw anɨb ak nɨŋɨd, bɨ kɨli ayɨp tap ñɨbek olap, ne Jisas nop agak, God binɨb dɨl kɨlop kod yenɨgab ak, ne ayɨp jɨmñɨl tap awl ñɨŋɨnɨgabal tek, mɨñmɨñ gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Agek Jisas agak, Bɨ olap tap awl ñɨŋɨnɨg, binɨb kuŋay yɨbɨl suk agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pen tap awl ñɨŋeb ñɨn anɨb ak apenɨgab, bɨ wog gɨñeb ne anop agyokɨl agɨnɨgab, Mɨñɨl am binɨb ned aglɨpin okok kɨlop am poŋɨd owan agɨnɨgab agak. Agek amɨl agɨnɨgab, Tap mɨdupsek dap nan gup nen, apem amnun agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Agek, bɨ kɨli mɨdupsek agɨnɨgabal, Chɨn ma amnɨgabun. Mel agɨnɨgabal agak. Bɨ anɨb okok olap agɨnɨgab, Yad amnɨm ak pen, lum awl olap tawpin ak, nɨgɨnɨg amebin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Olap agɨnɨgab, Amnɨm ak pen, wog gɨlaŋ agɨl, chag bulmakaw anep wajɨlem tawpin ak, wog gɨtep gɨnɨgel akaŋ agɨl, tunɨg dɨnɨgɨnɨg amebin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Olap agɨnɨgab, Bin yad ak kɨdeyɨl dɨpin, yad ma amnɨgayn. Mel agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Anɨb agel, bɨ anɨb ak adɨkɨd amɨl bɨawl ne anop agɨnɨgab, Bɨawl. Binɨb apan okok am agen, kɨli anɨb anɨb apal agɨnɨgab agak. Agek, bɨawl ak chɨbol nop ak tɨmel gek, bɨne anɨb anop man awl anɨb ak agyokɨl agɨnɨgab, Nad kasek kanɨbtam awl okok amɨl, kanɨbtam sɨkol okok amnoŋ agɨnɨgab agak. Binɨb yɨmgeptek okok dɨl, binɨb ñɨn tob pag pakek amdɨp okok dɨl, binɨb wɨdɨn koy gup okok dɨl, binɨb tob tɨmel gup okok dɨl, dad yɨp yɨl ownɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Agek, agɨnɨgab tek gɨl, kɨdek bɨ wog gɨñeb anɨb ak agɨnɨgab, Bɨawl. Apan tek kɨdek gɨpin ak pen, tep anep wakay ogɨnap mɨdeb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Agek, bɨawl ak wakay yokɨp okok agyokɨl agɨnɨgab, Nad kanɨbtam awl okok amɨl, kanɨbtam sɨkol okok amɨl, binɨb kuŋay yɨbɨl dad ape, kal mɨgan yɨp ak pɨsnep tɨbɨk dɨnɨmuŋ agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pen binɨb ned suk agen ma opal okok, tap yɨp sɨkol ogɨnap ma ñɨŋɨnɨgabal. Mel yɨbɨl agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Binɨb kuŋay yɨbɨl Jisas nop kɨdek gɨlak. Gelaknɨŋ, ne adɨkɨl kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Bɨ olap yɨp yɨl ownɨgab ak pen, gos awl ne ak nap, nonɨm, nɨnay, nɨmam, bin, ñapay, mubwak ne ke okok amenɨgab, yad nɨgɨnɨgayn, yepɨs nep ownɨgab agak. Yepɨs nep ownɨgab ak nɨm, nop bɨyad agɨl ma dɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Binɨb an mab bak kumak chɨn ak dad ajɨl yɨp kɨdek ma gup ak, binɨb yad tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pen bɨ nɨbi olap, kal awl olap gɨnɨg, mani, kal meg, kujan, tap okok tɨtay dɨl gɨnɨm agɨl, kal anɨb ak gɨjunɨgab akaŋ mel agak. Gos ak nɨgtep gɨl gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pen gin gin agɨl, kal meg ak ned nep gɨnɨgab ak pen, kal pal anɨb ak sɨsak gek, binɨb okok nop agjuwɨl agɨnɨgabal, ");
INSERT INTO taw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bɨ pal ak kal gɨnɨg tek gɨ dad amɨl, day sek kelɨgup agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pen anɨb ak tek, bɨnonɨm olap bɨnonɨm olap ayɨp penpen gɨnɨg, gos nɨgtep gɨl amnɨmuŋ agak. Pen ne gos olap nɨŋɨd agɨnɨgab, Bɨ chɨm kadɨŋ gep yad ak 10,000 mɨdeb, bɨawl anɨb ak bɨ chɨm kadɨŋ gep ne ak 20,000 mɨdeb agɨnɨgab agak. Anɨb ak penpen gɨl, ");
INSERT INTO taw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yɨp ñagɨnɨmuŋ tek lup agɨl, pal okok kɨdek owaknɨŋ takaw ak agyokɨl agɨnɨgab, Takaw ag jɨmñɨnɨgul agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Anɨb ak nɨgtep gɨnɨmɨb agak. Tap nɨbi okok nep mapen lɨnɨgabɨm ak, nɨbop binɨb yad agɨl ma dɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Dek tap yɨdek tep yɨbɨl ak pen, yɨdek ne ak amek, taydɨl gel tepayaŋ yɨdek gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dek anɨb ak tek dɨl, wog day ak lel tɨmel gɨnɨgab agak. Anɨb ak wog ne olap ma mɨdeb, dɨyokep tek nep lup agak. Nɨbi binɨb tɨmud sek okok, takaw anɨb ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bɨ takis dep okok sek, binɨb tap si tap tɨmel gɨlak okok sek, Jisas takaw agup ak nɨgun agɨl, ap nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pen bɨ Pelisi okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Jisas nop takaw ladek agɨlak, Bɨ anɨb ak, taynen bɨ tap si tap tɨmel gɨlak okok ayɨp pel mɨdɨl tap jɨmñɨl ñɨŋub agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Anɨb agel Jisas nɨŋɨd, takaw olap kɨlop paladaŋ lɨl agak, ");
INSERT INTO taw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Bɨ nɨbi olap chag sipsip 100 tek muk yenɨgab agak. Pen nokom olap kul gek, ogɨnap dam wakay olap lek tap wɨjwɨj ñɨŋɨlaknɨŋ, chag sipsip ne kul gɨnɨgab ak pɨyow amnɨgab agak. Am pɨyow pɨyow nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","nop tep yɨbɨl gek, dɨ wajɨlem adek ak lɨl ");
INSERT INTO taw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","dad kal ownɨgab agak. Apɨl, bogɨlak ne okok kɨlop ayɨp, binɨb man ne ayɨp jɨmñɨl okok ayɨp kɨlop suk agek, apnan gel agɨnɨgab, Chag yad kul gup ak pɨyow nɨŋɨd dɨpin nen, nɨbi ayɨp mɨñmɨñ gun agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Anɨb ak tek God chɨnop gup agak. Bɨ olap tap si tap tɨmel gup okok kelɨgɨl God nop gos nɨgɨnɨgab ak, God man ne alaŋ mɨñmɨñ awl yɨbɨl gɨnɨgabal agak. Binɨb kuŋay teplep yɨbɨl mɨdeb okok, God ne kɨlop nɨŋɨd mɨñmɨñ gɨnɨgab ak pen, bɨ olap tap si tap tɨmel gup okok kelɨgɨnɨgab ak, mɨñmɨñ awl yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pen bin olap mani mɨdup ne anep wajɨlem yenɨgab ak, won olap kal mɨgan okok kɨmɨgel yownɨgab agak. Yapek, sup dagɨl, tap dayday lɨg lɨg, mani ne won anɨb ak nɨŋɨd dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dek, bogɨlak ne okok ayɨp, binɨb man ne ayɨp jɨmñɨl okok ayɨp kɨlop suk agek, apnan gel agɨnɨgab, Mani yad yowup won nokom ak pɨyow nepin nen, nɨbi ayɨp mɨñmɨñ gun agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Anɨb ak tek, bɨ olap tap si tap tɨmel gup okok kelɨgɨl God nop gos nɨgɨnɨgab ak, God ensel ne mɨñmɨñ awl yɨbɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas anɨb agɨl agak, Bɨ olap ñɨ omɨŋal tɨkɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ñɨne kɨdek ak, apɨl nap nop agɨnɨgab, Bapi. Tap chɨlopmɨŋal apan okok pak asɨk, yɨp okok ke ñan agɨnɨgab agak. Agek, nap tap kɨlopmɨŋal okok pak asɨk keke ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ñek, ñɨne kɨdek ak pel mɨdɨl mel, nap tap pak asɨk ñɨnɨgab okok yokɨnɨgab ak dɨl, dad man palawl okok amnɨgab agak. Am anɨb okok mɨdɨl, binɨb tap si tap tɨmel okok gɨlɨg, mani dad amnɨgab okok mɨdupsek gɨ ñɨbdɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Anɨgɨl gɨ ñɨbdek, yuwan awl yɨbɨl ak man anɨb ak ownɨgab agak. Apek, mani dɨl tap taw ñɨŋɨnɨmuŋ tek olap ma yɨbɨl nep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anɨgek, ne amɨl bɨ man nap nɨb anɨb ak nɨb olap agnɨgek, nop chag wog ak aglɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pen nop yuwan awl yɨbɨl gek, chag ñɨŋɨnɨgabal tap dayday okok ogɨnap ñɨŋɨnɨmuŋ tek lɨnɨgab agak. Pen binɨb ogɨnap nop tap mɨdup ma nep ñɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pen kɨdek gos ne ak asɨk lek agɨnɨgab, Bapi bɨ wog gɨñeb okok tap mɨdup kuŋay mɨdeb agɨnɨgab agak. Yad awl mɨden, yuwan awl yɨbɨl yɨp gup agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Anɨb ak yad man awl kelɨgɨl, bapi mɨdeb tep ak adɨkɨd amɨl, bapi nop agɨnɨgayn, God wɨdɨn mɨdup nop adek ak gɨ tɨmel gɨl, wɨdɨn mɨdup nep adek ak gɨ tɨmel gɨl gɨpin agɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gɨ tɨmel gɨpin tek, yɨp ñɨ yad ma agɨnɨmɨn agɨnɨgayn agɨnɨgab agak. Yokɨp bɨ wog gɨñeb nad tek olap agle mɨdenɨm agɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Anɨb agɨl saŋɨdɨnɨgab agak. Am am nap yenɨgab sɨŋak wulep wulep gaknɨŋ, nap ñɨne nop palchɨm nɨgɨnɨgab. Nɨgek, chɨb tɨmel yɨbɨl gek, kasek am nop dɨ kaykol gaknɨŋ ");
INSERT INTO taw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ñɨne agɨnɨgab, Bapi. God wɨdɨn mɨdup nop adek ak gɨ tɨmel gɨl, wɨdɨn mɨdup nep adek ak gɨ tɨmel gɨl gɨpin tek, yɨp ñɨ yad ma agɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Nap pen bɨ wog gɨñeb ne okok kɨlop agɨnɨgab, Ñɨ yad ak pɨsnep kul gɨl kumak tek lak ak pen, mɨñɨl koŋɨm mɨdeb nɨgebin agɨnɨgab agak. Nɨbi chech palawl yɨp ak am dad apɨl nop lɨñɨl, ñɨn mɨdup nop ak liŋ lɨñɨl, tob tɨlup ak lɨñɨl gɨnɨmɨb agɨnɨgab agak. Anɨgɨl am chag bulmakaw ñɨluk tep yɨbɨl olap pak dad apem, dagɨl ñɨbɨlɨg mɨñmɨñ gɨnɨgun agɨnɨgab agak. Agek, agɨnɨgab tek gɨl, tap mɨdup dagɨl ñɨbɨlɨg mɨñmɨñ gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pen ñɨne ned ak, wog day okok gɨ ajɨl, adɨkɨd kal yep wulep sɨŋak apɨl nɨgɨnɨgab, dachɨŋ pakɨl mɨñmɨñ gɨlɨg genɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Anɨgel nɨŋɨd, nap bɨ wog gɨñeb ne olap nop agnɨŋɨd agɨnɨgab, Tay gebal agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Agek agɨnɨgab, Namam kɨdek kumub agɨl gos nopun ak pen, mɨñɨl adɨkɨd owup mɨdtep gup agɨnɨgab agak. Apek, nap chag bulmakaw ñɨluk tep yɨbɨl olap pakɨl dagɨl ñɨbɨlɨg, mɨñmɨñ gebal agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Agek, nop mɨlɨk tɨmel yɨbɨl yapek, kal mɨgan ma yɨbɨl amnɨgab, seŋayaŋ nep yenɨgab agak. Nap pen seŋ apɨl, kal mɨgan owan agɨl nop takaw saynsayn gɨl agek, ");
INSERT INTO taw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ñɨne agɨnɨgab, Yad takaw apan tek kɨdek gɨl, bɨ wog gɨñeb tek ak mɨdɨl, wog nep ak pel gen gen, sub kuŋay yɨbɨl nep yɨnub agɨnɨgab agak. Pen yɨp chag meme ñɨluk olap ñe, bogɨlak yad okok ayɨp pak dagɨl ñɨbɨlɨg ma mɨñmɨñ gɨpun agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ñɨnak kɨdek ak, tap bɨlok ñɨnak okok dam, bin si tap okok gɨl, ñɨbdɨl apek, nop chɨb nɨŋɨd chag bulmakaw ñɨluk tep yɨbɨl ak pakɨpan agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Agek, nap ñɨne nop agɨnɨgab, Chɨlapɨl pel mɨdobul tek, tap yad okok tap nade, mɨdupsek dɨnɨgaban agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Namam kɨdek kul gɨl kumak tek lak ak pen, mɨñɨl adɨkɨd koŋɨm mɨdeb nɨŋɨd, mɨñmɨñ gɨnɨgun agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas bɨne okok kɨlop agak, Bɨawl tap ne kuŋay yenɨgab olap, bɨ kod mɨdep ne olap aglek, tap nop okok kod yenɨgab agak. Pen bɨawl ak, takaw olap nɨgɨnɨgab, bɨ tap nop kod yenɨgab ak, tap nop okok kod mɨdtep ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Anɨb ak nɨŋɨd, nop suk agek apek agɨnɨgab, Tap yɨp kod mɨdtep ma gɨpan ak, yɨp agñel nepin agɨnɨgab agak. Anɨb ak nad am tap yad tɨtay mɨdeb okok ñɨn pag nɨgtep gɨl, binɨb okok kɨlop tap day yad tɨtay mɨdeb okok ñɨn pag nɨgtep gɨl, ap yɨp agñɨnɨmɨn agɨnɨgab agak. Pen wog yɨp ak kɨdek ma gɨnɨgaban agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Agek, bɨ tap nop kod mɨdep anɨb ak, ne ke nep gos kuŋay nɨŋɨd agɨnɨgab, Bɨawl ak yɨp agyokeb tek, tay gɨnɨm agɨnɨgab agak? Yad bɨ kɨles ma mɨdebin ak, lum puŋɨl pagɨnɨm tek ma lup agɨnɨgab agak. Binɨb ogɨnap tap kɨlop ak asɨb agñɨben, yɨp nebeŋ gɨnɨgab agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pen gos nɨgtep gɨl agɨnɨgab, Tɨtay dɨl gɨnɨm agɨl mɨñɨl nɨgebin agɨnɨgab agak. Anɨgɨl gen, bɨawl ak yɨp agyokɨnɨgab won ak, binɨb ogɨnap yɨp del, kal kɨli ak yenɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Anɨb agɨl, bɨ ogɨnap kɨlop suk agek ownɨgabal agak. Kɨli bɨawl tap day yenɨgab agak. Bɨ ned ownɨgab anop agɨnɨgab, Bɨawl yad ak, tap day ne nep tɨtay mɨdeb agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Agek agɨnɨgab, Wel tap mab agɨl ñɨŋeb, 100 dlam ak agɨnɨgab agak. Agek agɨnɨgab, Mɨj tap day anɨb ak ñu kɨl tɨkɨlak ak, dɨnɨmɨn agɨnɨgab agak. Dɨl, kasek 50 anep tɨkɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kɨdek bɨ olap apek agɨnɨgab, Bɨawl yad ak, tap day ne nep tɨtay mɨdeb agɨnɨgab agak? Agek agɨnɨgab, 1,000 lays wad agɨnɨgab agak. Agek agɨnɨgab, Mɨj tap day anɨb ak tɨkɨlak ak, dɨnɨmɨn agɨnɨgab agak. Dɨl, 800 tɨkɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Anɨgek, bɨawl ne ak nɨŋɨd anɨb agɨnɨgab, Bɨ tap yɨp kod mɨdep tɨmel ak, binɨb gos tɨpagɨl nɨŋɨd gɨpal tek ak gup agɨnɨgab agak. Anɨb ak nɨgɨm, binɨb lum awl yɨl okok apal, Mɨñɨl tɨtay dɨl kɨdek mɨdtep gɨnɨgabun agɨl, gos ak nɨgɨlɨg gel amub agak. Pen God binɨb ne mɨlek adek sɨŋak mɨdebal okok, kɨli gos anɨb ak nɨŋɨd ma gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mani tap lum awl mɨdeb okok, binɨb okok kɨlop ñem kɨli pen nɨbop gos nɨgɨnɨgabal agak. Nɨbop gos nɨgel, kɨdek tap anɨb okok pɨsnep kul gɨnɨgab ñɨn ak, nɨbi amɨl pelnep yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tap sɨkol olap binɨb ogɨnap bɨ olap nop ñɨn adek ak lel gɨtep gɨnɨgab ak, tap awl okok ñel abe gɨ tep gɨnɨgab agak. Pen tap sɨkol olap dɨ ñɨn adek nop lel gɨtep ma gɨnɨgab ak, tap awl olap ñel abe gɨtep ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pen nɨbi tap tep lum awl yɨl dɨlɨg, gɨtep ma genɨgabɨm, kɨdek an nɨbop tap teplep yɨbɨl anɨb ak ñɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bɨ olap tap ne pen ñɨn adek nɨbop lek, gɨtep ma genɨgabɨm, kɨdek an pen tap nɨbi ke nɨbop ñɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Jisas takaw olap agak, Bɨ nokom olap, ne bɨawl omɨŋal kɨlop wog gɨñɨnɨmuŋ tek ma mɨdeb agak. Taynen? Ne bɨawl olap nop dɨnɨgab, bɨawl olap nop kelɨgɨnɨgab agak. Akaŋ bɨawl olap nop nɨgek tep gɨnɨgab, bɨawl olap nop nɨŋɨd kud ñɨnɨgab agak. Anɨb ak tek, nɨbi God nop gos sek, tap lum ayaŋ yɨl gos sek, tap omɨŋal gɨl gos nɨŋɨd kɨlop wog gɨñɨnɨmuŋ tek ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bɨ Pelisi okok, gos awl kɨli mani adek ak nep nɨgɨlak ak nɨm, Jisas takaw agak anɨb ak nɨŋɨd agjulak. ");
INSERT INTO taw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Agjuwelak kɨlop agak, Tap binɨb nɨgel tep gup okok, God nɨgek tap tɨmel gup tek lup agak. Nɨbi binɨb wɨdɨn mɨdup adek ak, chɨn binɨb tep mɨdobun apɨm ak pen, God nab nɨbop ayaŋ nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Pen ned Jon Bɨ Ñɨg Pakñeb ak ma yek ñɨn ak, binɨb okok kɨli takaw Mosis ñu kɨl tɨkak ak sek, bɨ God gos ñek agñeb okok takaw tɨkɨlak ak sek nɨŋɨd, adek anɨb ak gel amolɨgup agak. Pen Jon owak ñɨn ak, God binɨb dɨl kɨlop kod yenɨgab ak takaw teplep anɨb ak agelak binɨb mɨdupsek nɨŋɨd, kɨles tɨmel gɨl mɨgan anɨb ak amnun agɨl gel ameb agak. ");
INSERT INTO taw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Adekab sek lum awl sek kul gɨnɨmuŋ tek lup ak pen, takaw Mosis ñu kɨl tɨkak ak, sɨkol bad olap kul gɨnɨmuŋ tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nɨgɨm. Bɨ bin dɨl agyokɨl, am bin kɨdeyɨl nɨb olap dup ak, bin si dup agak. Pen bɨ an tɨkjakɨl, bin bɨ dɨl agyokak ak olap nop dup ak, abe bin si dup agak. ");
INSERT INTO taw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas takaw olap agak, Bɨ olap mani tap ne kuŋay yɨbɨl yolɨgup agak. Ne chech teplep yɨbɨl okok nep yɨmɨl, mɨnek mɨnek tap ñɨŋeb teplep okok nep ñɨbolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pen kal kanɨbtub gol ne sɨŋak, bɨ soy sek tap ma yek olap, dap lel yolɨgup agak. Yɨb ne Lasalus agak. ");
INSERT INTO taw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gos ne ak nɨŋɨd anɨb agolɨgup, Bɨ tap kuŋay mɨdeb awl, tap ñɨbek dayday abañ muk okok yownɨgab okok, yad dɨl ñɨŋɨnɨm agolɨgup agak. Ñɨbɨl nɨm, yɨp yuwan ma gɨnɨgab agolɨgup agak. Pen chen okok apɨl soy nop okok bɨleg ñɨbelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kɨdek bɨ tap ne ma yek anɨb ak kumek, ensel okok apɨl, nop dad amɨl Eblaham ayɨp lɨlak agak. Bɨ mani tap ne kuŋay yɨbɨl yolɨgup ak abe kumek, kamɨlaknɨŋ, ");
INSERT INTO taw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","am mab ke yɨneb ak yɨpɨl tɨmel yɨbɨl gaknɨŋ yolɨgup agak. Pen mɨdɨl kɨlan gɨl nɨgak, Eblaham ayɨp Lasalus ayɨp keke sɨŋalaŋ yelek agak. ");
INSERT INTO taw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nɨŋɨd suk agɨl agak, Bapi Eblaham. Yɨp mapen nɨgan agak. Lasalus nop age, ñɨn mɨdup pal ne olap ñɨg ak tawɨl, dap yalɨb yɨp ak dɨnɨgek yɨp sayn gaŋ agak. Mab ak yɨnɨl, yɨp yɨpɨl tɨmel yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Agek, Eblaham agak, Ñɨ nɨgan agak. Lum ayaŋ yenak ñɨn ak, nak tap tep okok nep dɨnak, Lasalus tap tɨmel okok nep dak agak. Pen mɨñɨl man awl, ne mɨdtep yɨbɨl gup, nep yɨpɨl tɨmel yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tap olap sek nad nɨgɨnɨmɨn agak. God mol awl yɨbɨl ak nab awl gɨlak ak nɨm, chɨn binɨb pɨs awl yɨl ak, telakɨl pi ak ma amnɨgabun agak. Pen nɨbi pɨs pi ak yɨl ak telakɨl, awl ma ownɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Agek, bɨ anɨb ak agak, Bapi, anɨb apan ak, yad nep agnɨgebin agak. Lasalus nop agyoke, ne kal binɨb yad mɨdebal okok amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Amɨl, mam yad anep mamɨd ak kɨlop takaw kɨles yɨbɨl ak agonɨmuŋ, man yɨpɨl tɨmel yɨbɨl gup awl ma ownɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Anɨb agek Eblaham agak, God Mosis nop gos ñek buk Baybol takaw tɨkak ak sek, bɨ God gos ñek agñeb ogɨnap kɨlop gos ñek buk Baybol takaw tɨkɨlak ak sek mɨdeb agak. Nɨgɨnɨg anɨb okok nɨgɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Agek agak, Bapi. Ak tep ma apan agak. Binɨb olap kumɨl tɨkjakɨl am agenɨgab, nɨŋɨd agup agɨl, tap si tap tɨmel gɨpal adek ak kelɨgɨl, God nop gos nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Agek agak, Kɨli Mosis takaw tɨkak ak ma nɨŋɨd, bɨ God gos ñek agñeb ogɨnap takaw tɨkɨlak ak ma nɨŋɨd nɨm, bɨ olap kumɨl tɨkjakɨl am agɨnɨgab ak, abe ma nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas bɨne okok kɨlop agak, Tap ogɨnap apɨl binɨb okok gek, tap si tap tɨmel gɨl apyap pakɨnɨgabal agak. Pen bɨ an gek, tap tɨmel anɨb ak ownɨgab, bɨ anɨb ak kɨdek tɨtay dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ne ñɨsɨkol paysɨkol kɨli yɨp gos lɨnepal okok kɨlop gek apyap pakɨnɨgabal ak, tɨmel yɨbɨl gɨnɨgab agak. Nop ned tunɨg dam ñɨg solwala yokɨpɨlap ak gɨtep gɨpɨlap agak. Taynen? Bɨ koŋɨm mɨdɨl ñɨsɨkol paysɨkol kɨlop gɨ tɨmel gɨnɨgab ak, kɨdek yul awl dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anɨb ak nɨbi asɨk tep gɨnɨmɨb agak. Pen mam olap tap si tap tɨmel gonɨmuŋ, taynen tap tɨmel gɨpan, kelɨgɨnɨmɨn agɨnɨmɨb agak. Agem, tap si tap tɨmel kelɨgonɨmuŋ, nop nɨŋɨd kelɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ne nep gɨ tɨmel gɨl, adɨkɨd apɨl agɨnɨgab, Tap si tap tɨmel gɨpin ak kelɨgen, yɨp nɨŋɨd kelɨgɨnɨmɨn agɨnɨgab ak, nop nɨŋɨd kelɨgɨnɨmɨn agak. Nep ned gɨ tɨmel genɨgab, nop nɨŋɨd kelɨgɨnɨmɨn agak. Pen kɨdek nep gɨ tɨmel genɨgab, nop nɨŋɨd kelɨgɨnɨmɨn agak. Pen ñɨn nokom olap, nep gɨ tɨmel gɨnɨgab ak, gɨ dam dam ñɨn anep kugul oŋɨd amjakek, nop nɨŋɨd kelɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas anɨb agek, bɨ takaw nop dad ameb okok agɨlak, Nad ge, chɨn God nop nokom gos lɨnɨgɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Agel kɨlop agak, God nop gos lɨnepɨm ak, sɨkol olap awl mel, mab mastet mɨdup tek yek, nɨbi agɨnɨgabɨm, Mab awl jɨj sek tɨgjuwɨl, ñɨg solwala nab sɨŋadaŋ jak mɨde agem, agɨnɨgabɨm tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pen bɨ nɨbi olap, ne bɨ wog gɨñeb ne olap dɨl agek, am lum puŋɨl pagɨl akaŋ, chag sipsip okok muk ajɨl, adɨkɨd kal apek, bɨ nɨbi ak bɨ wog gɨñeb ne ak nop tay agɨnɨgab agak? Kasek ap besɨgɨl tap ñɨŋan agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mel. Anɨb ma agɨnɨgab agak. Ne agɨnɨgab, Chech ak page apek, sɨbnag pak tɨbɨkɨl, ñɨg tap yɨp okok dape ñɨben, kɨdek ñɨg tap nad okok ñɨŋan agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pen bɨ wog gɨñeb ne ak agɨnɨgab tek gek, nop takaw tep ogɨnap ma agɨnɨgab agak. Bɨ wog gɨñeb yad ak nɨm, apin tek gup agɨl nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anɨb ak tek nɨm nɨbi agak. God nɨbop agɨnɨgab tek gɨl, kɨdek agɨnɨgabɨm, Chɨn binɨb tep yɨbɨl mel agɨnɨgabɨm agak. Wog chɨn gɨpun ak tek, nɨm gɨpun agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jelusalem amnin agɨl, Samaliya plopens Galili plopens adaŋ nab ak am am ");
INSERT INTO taw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","man olap amjakaknɨŋ, bɨ soy ladek lak anep wajɨlem ak nop nebeŋ pakɨlak. Nebeŋ pakɨl, keke sɨŋadaŋ jak mɨdɨl ");
INSERT INTO taw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","suk agɨlak, Bɨawl Jisas. Chɨnop mapen nɨgan agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Agelak kɨlop nɨŋɨd anɨb agak, Nɨbop suŋ lup nen, am bɨ God nop sɨbogep okok mubwak nɨbi ak kɨlop yomnɨmɨb agak. Anɨb agek, kanɨb nab okok amnɨlak nɨŋɨd, kɨlop mɨdupsek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Suŋ lek, bɨ olap nop suŋ lak ak nɨŋɨd, takaw awl agɨlɨg, God yɨb nop ak dad aplanak. Aplanɨlɨg, adɨkɨd ap ");
INSERT INTO taw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jisas yek lum sɨŋak apyap pakɨl nop tep agak. Bɨ anɨb ak Samaliya nɨb ak. ");
INSERT INTO taw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Anɨgek nɨŋɨd Jisas agak, Yad agnepin, bɨ anep wajɨlem ak suŋ lup agɨl nepin ak pen, bɨ anep ajɨp ak akal agak? ");
INSERT INTO taw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bɨ ogɨnap taynen ma opal agak? Bɨ pal okok nɨb ak nep adɨkɨd apɨl, God nop tep agup agak? ");
INSERT INTO taw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Anɨb agɨl bɨ anɨb anop agak, Jisas yɨp gek suŋ lɨnɨgab agɨl gos ak nepan tek, nep gen suŋ lup, anɨb ak tek tɨkjakɨl amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pen bɨ Pelisi okok Jisas nop agɨlak, Ñɨn akal tek God binɨb dɨl kɨlop kod yenɨgab ak ownɨgab agɨlak? Agel, Jisas agak, God binɨb dɨl kɨlop kod yenɨgab apɨm anɨb ak, mɨseŋ apek binɨb wɨdɨn ma nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mɨdeb awl akaŋ, adaŋ mɨdeb tek ma agɨnɨgabal agak. Taynen? God binɨb dɨl kɨlop kod yenɨgab ak, apɨl nab nɨbi pi okok mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Anɨb agɨl, bɨne okok kɨlop agak, Kɨdek ñɨn olap Bɨ Olap Ñɨne nop nɨgun agɨl, mapen nɨbop ak puŋɨl ñɨnɨgab ak pen, nop ma nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Binɨb ogɨnap nɨbop agɨnɨgabal, Mɨdeb adaŋ, mɨdeb awl agel, takaw anɨb ak nɨŋɨd apal agɨl, ma am pɨyow nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Taynen? Bɨ Olap Ñɨne ownɨgab ñɨn ak, añɨñak dɨl, mɨlek palsek gup tek ak gaknɨŋ ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ne pen yul awl yɨbɨl dek, binɨb mɨñɨl mɨdebal okok, nop yɨlɨk nɨŋɨd ma dɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bɨ Olap Ñɨne ownɨgab ñɨn anɨb ak, binɨb bɨlel Nowa yek ñɨn ak gak tek gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Binɨb okok tap ñɨbɨlɨg, ñɨg ñɨbɨlɨg, bin penpen ñɨlɨg gɨ yelaknɨŋ, Nowa sip mɨgan ayaŋ amnak agak. Amek, man awl yɨbɨl ak pakɨl, ñɨg wɨlɨk apɨl, binɨb anɨb okok kɨlop mɨdupsek yuwɨg dek kumɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pen bɨ Lot yek ñɨn ak taun Sodom taun Gomola binɨb okok abe tap ñɨbɨlɨg, ñɨg ñɨbɨlɨg, tap pen ñe pen ñe gɨlɨg, tap wog gɨlɨg, kal gɨlɨg gɨ yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Anɨgɨl yelaknɨŋ, Lot taun anɨb okok kelɨgɨl, man wakay olap ke amnaknɨŋ, mab mɨŋɨlaŋ awl sek kab ke yɨneb sek wɨsɨp alaŋ nɨb apɨl, taun Sodom taun Gomola binɨb kɨlop mɨdupsek yɨn sɨbog amek kumɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bɨ Olap Ñɨne mɨseŋ ownɨgab ñɨn ak, Nowa yolɨgup ñɨn ak sek, Lot yolɨgup ñɨn ak sek, gɨ yelɨgɨpal tek gɨ yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ñɨn anɨb ak, Binɨb kal adek alaŋ yenɨgel okok, tap dɨnɨg adɨkɨd kal mɨgan ma amnɨgel agak. Binɨb wog day okok ajenɨgel okok, chech tap okok dɨnɨg adɨkɨd kal ma amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot bin ne nop, tap gak adek ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Binɨb ne ke mɨdɨl, mɨdtep gin agɨnɨgab ak, kɨdek mɨd tɨmel gɨnɨgab agak. Pen binɨb yɨp tap tay gɨnɨgab takaw ma mɨdeb agɨnɨgab ak, kɨdek mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nɨbop agebin, ñɨn anɨb ak bɨ omɨŋal mɨj adek nokom olap kɨnenɨgayl ak, God bɨ olap nop dɨl, olap nop kelɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Pen bin omɨŋal bilet jɨmñɨl gɨ yenɨgayl ak, olap nop dɨl olap nop kelɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Anɨb agek agɨlak, Bɨawl. Takaw ageban anɨb ak, akal gɨnɨgab agɨlak? Agel Jisas agak, Tap ogɨnap wog bɨg yɨnɨg lɨnɨgab ak, man anɨb ak yawl apnan gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas ne bɨne okok, kɨli yɨlɨk ma nɨgɨnɨgel God nop agɨlɨg nep yenɨgel agɨl, kɨlop takaw olap paladaŋ lɨl agak, ");
INSERT INTO taw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Man olap bɨawl takaw tɨg asɨkep olap yenɨgab agak. Pen bɨ anɨb ak, God nop ma pɨlɨkɨnɨgab, binɨb okok kɨlop chɨb ma nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bin kaŋɨl man anɨb ak nɨb olap, ne pelpel apɨl nop agɨnɨgab, Bɨ ñagep yad ak, takaw chɨlop ak nɨgɨnɨmɨn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Anɨb agɨnɨgab ak pen, bɨawl takaw tɨg asɨkep anɨb ak takaw nop ak ma dɨnɨgab agak. Ma dek, nop ap mɨnek mɨnek agnɨg gek gek, kɨdek bɨawl anɨb ak agɨnɨgab, Yad God nop ma pɨlɨkɨpin, binɨb okok kɨlop chɨb ma nepin ak pen, ");
INSERT INTO taw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bin kaŋɨl awl mɨnek mɨnek ap agek agek, yɨp yɨlɨk gɨnɨgab nen, takaw ne anɨb ak nɨgin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisas takaw olap sek anɨgɨl agak, Bɨ takaw tɨg asɨkep tɨmel anɨb ak, takaw ne ak nɨgɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","God ne ke binɨb kɨlop aglup okok, kɨli mɨnek mɨnek nop agnɨgɨlɨg, subnab abe maynab abe, God kɨlop ma gɨñɨnɨgab akaŋ agak? Kod mɨd mɨd, kasek ma gɨñɨnɨgab akaŋ agak? Mel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yad nɨbop agebin, ne kasek kɨlop gɨñɨnɨgab agak. Bɨ Olap Ñɨne pen ne ownɨgab ñɨn ak, binɨb lum awl okok nop gos lɨnɨgɨlɨg yenɨgabal akaŋ mel agak? ");
INSERT INTO taw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pen binɨb ogɨnap kɨli chɨn mɨdtep gɨpun, binɨb ogɨnap mɨdtep ma gɨpal agɨl nɨgɨlak okok, Jisas kɨlop takaw olap paladaŋ lɨl agak. ");
INSERT INTO taw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Anɨb agak, Bɨ Pelisi olap, bɨ takis dep olap, kɨli God nop agɨnɨg, God agnɨgep kal awl ak amnɨlek agak. ");
INSERT INTO taw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bɨ Pelisi ak gos nab ne okok nep God nop agɨl agak, Nep tep yɨbɨl agebin agak. Yad bɨ ogɨnap gɨpal tek, tap si, bin si, tap tɨmel okok ma gɨpin agak. Yad bɨ takis dep awl tek mel agak. ");
INSERT INTO taw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wik mɨnek mɨnek pel ñɨn omɨŋal tap ma ñɨbin agak. Pel tap yad mɨdupsek anep wajɨlem ak dɨlɨg, nep nokom olap ñɨl, yad anep ajɨp ak nep dɨpin agak. ");
INSERT INTO taw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pen bɨ takis dep ak keke sɨŋadaŋ mɨdɨl, God man ne alaŋ ma nɨŋɨd, pabɨl pakɨlɨg gos kuŋay nɨgɨlɨg agak, God. Yad bɨ tap si tap tɨmel gɨpin ak, yɨp mapen nɨŋɨd dɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nɨbop agebin, God bɨ takis dep ak anɨb agek nɨŋɨd, nop nɨgek bɨ teplep yɨbɨl mɨdeb agak. Pen bɨ Pelisi nop ma dup agak. Taynen? Binɨb chɨn yɨb awl mɨdeb agɨl nepal okok, God gek yɨb kɨlop apyownɨgab agak. Pen binɨb chɨn yɨb ma mɨdeb agɨl nepal okok, God gek yɨb kɨlop yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Binɨb okok, kɨli Jisas ñɨpay chɨnop okok dɨnɨgaŋ agɨl, dad apel, bɨne okok pen binɨb anɨb okok kɨlop nɨg chɨkɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Anɨgelak, Jisas ñɨsɨkol paysɨkol okok kɨlop suk agɨl bɨne okok kɨlop agak, Ñɨsɨkol paysɨkol okok kelɨgem, yɨp yɨl owlaŋ agak. God binɨb dɨl kɨlop kod yenɨgab anɨb ak nɨm, ñɨsɨkol paysɨkol anɨb okok tek agak. ");
INSERT INTO taw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anɨb ak nɨbop nɨŋɨd agebin, binɨb kɨli ñɨsɨkol paysɨkol kɨli God nop muk okok mɨdebal tek ma yenɨgabal ak, kɨli God binɨb dɨl kɨlop kod yenɨgab mɨgan ak ma amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda bɨawl olap Jisas yek ak apɨl agak, Tisa, nad bɨ tep yɨbɨl agak. Yad tap tay gen, God gek pel pelnep yenɨgayn agak? ");
INSERT INTO taw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Agek Jisas agak, Yɨp taynen bɨ tep yɨbɨl apan agak? Binɨb olap tep yɨbɨl ma mɨdebal, God nokom nɨm bɨ tep yɨbɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pen Mosis takaw ñu kɨl tɨkak ak nad nepan, anɨb agup, Chɨp ma ñagɨnɨmɨb, bin si bɨ si ma gɨnɨmɨb, tap si ma dɨnɨmɨb, yepɨs ma agɨnɨmɨb, nanɨm nap takaw agɨnɨgel tek nɨŋɨd kɨdek gɨnɨmɨb agup agak. ");
INSERT INTO taw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Agek, bɨ anɨb ak agak, Yad ñɨsɨkol mug tɨkɨl, takaw anɨb ak kɨdek gɨ dap dap, mɨñɨl ñɨn awl abe kɨdek gɨ nep mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas takaw anɨb ak nɨŋɨd agak, Tap nokom olap nep ma gɨpan agak. Tap nak okok mɨdupsek yokɨl mani dɨl, binɨb yɨmgeptek okok kɨlop ñɨl nɨm, kɨdek tap teplep nad ak yenɨgab, God man ne alaŋ agak. Anɨb ak apin tek gɨl apɨl, yɨp kɨdek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Agek ne takaw anɨb ak nɨŋɨd, gos palawl yɨbɨl nɨgak. Taynen? Tap ne kuŋay yɨbɨl yek. ");
INSERT INTO taw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gos palawl yɨbɨl nɨgek, Jisas nɨŋɨd anɨb agak, Binɨb tap kuŋay mɨdeb okok, tɨtay dɨl God nop gos nɨgel, kɨlop dɨl kod yenɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Chag kamel okok ñu alɨguñ yokep mɨgan tek ak amnɨg kasek amnɨgel tek lup agak. Binɨb pen mani tap kɨli kuŋay mɨdeb okok, kɨli God binɨb ne mɨdɨnɨg, koslam yɨbɨl binɨb ne mɨdel, kɨlop dɨl kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Anɨb agek, binɨb yelak okok nɨŋɨd anɨb agɨlak, Takaw agup anɨb ak, binɨb okok God yɨl pel pelnep yonɨgun tek ma lup agɨlak. Akaŋ tay agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Agel Jisas agak, Tap ogɨnap binɨb gɨnɨgel tek ma lup ak pen, God ne gɨnɨg, gɨnɨmuŋ tek nep lup agak. ");
INSERT INTO taw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Anɨb agek Pita agak, Nɨgan, tap chɨn okok mɨdupsek kelɨgɨl, nad ayɨp nep chɨgɨl kɨdek gɨpun agak. ");
INSERT INTO taw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Agek Jisas kɨlop agak, Nɨbop nɨŋɨd agebin agak. Bɨ mɨdupsek God binɨb dɨl kɨlop kod yenɨgab agɨl, kal, bin, nɨmam, nonɨm, nap, ñapay kɨli okok kɨlop kelɨgel, ");
INSERT INTO taw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mɨñɨl lum awl mɨdobun ñɨn ak God kɨlop kod mɨdtep gɨl, tap kuŋay nep ñɨnɨgab agak. Pen ñɨn kɨdek ak apek, kɨli pel pelnep yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas bɨ takaw nop dad ameb anep umɨgan ak kɨlop dad gol okok amɨl agak, Nɨgɨm. Mɨñɨl Jelusalem amon, Bɨ Olap Ñɨne nop bɨlel buk Baybol ak tɨkɨl agɨlak tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nop dɨl, bɨ Juda mel ñɨn adek okok lel, nop agjulɨg, ñɨñɨloŋ lɨlɨg, kɨñuk gɨlɨg, ");
INSERT INTO taw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nag dɨl pakɨlɨg, pɨsnep paklel kumnɨgab agak. Pen ñɨn omɨŋal nokom mɨdɨl, tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pen anɨb agek, bɨne okok gos nɨgɨnɨgel tek ma lek, takaw anɨb agup agɨl gos ma nɨgɨlak. Takaw jɨj anɨb won ak, kɨlop we gak. ");
INSERT INTO taw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas amɨl taun Jeliko amjakɨlak nɨŋɨd, bɨ wɨdɨn koy mani tap okok nen asɨb agolɨgup olap, kanɨb awl gol sɨŋak besɨg yek. ");
INSERT INTO taw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Binɨb kuŋay nep takaw agɨlɨg padɨkɨlak nɨŋɨd, ne binɨb ogɨnap kɨlop agnɨŋɨd agak, Tay gebal agak? ");
INSERT INTO taw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Agek agɨlak, Jisas bɨ Nasalet nɨb ak apɨl padɨkeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Anɨb agelak ne suk awl agɨl agak, Jisas, Depid Ñɨne. Yɨp mapen nɨŋɨd dɨtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Agek binɨb ned owlak okok nop ag gɨl agɨlak, Taynen anɨb ageban? Kɨmɨgel mɨde agɨlak. Anɨb agɨlak ak pen, ne kɨmɨgel ma yek, suk awl agɨlɨg agak, Jisas, Depid ñɨne. Yɨp mapen nɨŋɨd dɨtep gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Agek, Jisas nɨŋɨd ap alad gɨl, binɨb okok kɨlop agak, Nop poŋɨd yep wulep sɨŋawl owɨm agak. Agek, poŋɨd apelak agak, ");
INSERT INTO taw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nep tay gɨnɨm agak? Agek agak, Bɨawl. Yɨp ge wɨdɨn yɨbɨl nɨgin agak. ");
INSERT INTO taw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Agek Jisas nop agak, Yɨp gek wɨdɨn yɨbɨl nɨgɨnɨgayn agɨl gos nepan ak tek, wɨdɨn nɨgan agak. ");
INSERT INTO taw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Agek, won anɨb anep wɨdɨn nɨŋɨd, God yɨb nop ak dad aplanɨlɨg, Jisas amnaknɨŋ kɨdek gak. Binɨb mɨdupsek Jisas tap gak anɨb ak nɨŋɨd, God yɨb nop dad aplanɨlak. ");
INSERT INTO taw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas taun Jeliko amɨl, man anɨb ak kelɨgɨl amnɨg gek. ");
INSERT INTO taw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pen Jeliko nab anɨb ak bɨ olap yolɨgup, mani tap ne kuŋay yek. Yɨb ne ak Sakiyas. Ne bɨ takis dep okok kɨlop kod yolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Binɨb kuŋay yɨbɨl ap Jisas nop nɨgɨnɨg gelak, Sakiyas bɨ wulep won ak, Jisas bɨ tay tek ak nɨgin agɨl gak. ");
INSERT INTO taw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ne ned amɨl, mab kɨd olap tan aplanɨl, Jisas apek tam oŋɨd nɨg yek. ");
INSERT INTO taw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas pen ap mab tan yek jɨj sɨŋak apɨl, kɨlan gɨl nɨŋɨd Sakiyas nop agak, Sakiyas, kasek lug apyowan agak. Mɨñɨl kal nad ak am yenɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Agek, Sakiyas lug apyapɨl, mɨñmɨñ gɨlɨg, Jisas nop poŋɨd kal ne amnak. ");
INSERT INTO taw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Binɨb okok gak anɨb ak nɨŋɨd, mɨlɨk yapek agɨlak, Bɨ anɨb ak am bɨ tap si tap tɨmel gup kal ak kɨnɨg ameb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pen kɨdek am Sakiyas kal ak takaw ag mɨdɨlɨg, Sakiyas tɨkjakɨl, Jisas nop agak, Bɨawl, nad nɨgan agak. Mɨñɨl tap yad okok bɨlok pɨs ak lɨl, pɨs ak binɨb yɨmgeptek okok kɨlop ñɨnɨgayn agak. Yad ned tay yepɨs agɨl, binɨb ogɨnap tap kɨlop si dɨnek tek lup okok, pen ñɨnɨg tap nokom olap dɨnek tek, pen omɨŋal omɨŋal ñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Agek Jisas nop agak, Bɨ nɨm awl nɨsed Eblaham God nop gos nɨgak tek nɨgup agak. Ak nɨm, God mɨñɨl nop abe dɨl, binɨb ne ayɨp kal jɨmñɨl kɨnɨbal okok kɨlop dɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bɨ Olap Ñɨne owak ak, binɨb God nop kelɨgɨpal okok kɨlop pɨyow nɨŋɨd dɨnɨg owak agak. ");
INSERT INTO taw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pen Jisas Jelusalem wulep mɨdeb sɨŋak amek, binɨb anɨb okok takaw ne ak nɨŋɨd, gos kɨli anep nɨgɨlak, God binɨb dɨl kɨlop kod yenɨgab ak, mɨseŋ sɨŋak apeb agɨl nɨgɨlak. Jisas gos nɨgɨlak anɨb ak ke nɨŋɨd, takaw olap sek paladaŋ lɨl ");
INSERT INTO taw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","agak, Bɨawl olap gos ne anɨgɨl yenɨgab agak. Yad gapman bɨnonɨm yad mɨdeb ak amen, yɨp gapman bɨawl yɨbɨl aglek, adɨkɨd apɨl, binɨb man yad okol kɨlop kodɨnɨgayn agɨl, man palawl okok amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pen amnɨg, bɨ wog gɨñeb ne anep wajɨlem okok kɨlop suk agek apel, mani yɨl omɨŋal bɨ nokom nokom bɨlok ñɨl agɨnɨgab, Mani ñebin awl dɨl, wog gɨnɨmɨb agɨnɨgab agak. Kɨdek yad tepayaŋ ownɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Anɨb agɨl amnɨgab ak pen, binɨb man ne ayɨp jɨmñɨl okok nop mɨlɨk nɨŋɨd, bɨ ogɨnap agyokel, kɨdek amɨl, gapman bɨnonɨm anop agɨnɨgabal, Bɨ anɨb ak ne bɨawl chɨn mɨdeŋ agɨl gos ma nopun agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pen gapman bɨnonɨm ne bɨawl nop gapman bɨawl yɨbɨl aglek, tepayaŋ adɨkɨd apɨl, bɨ wog gɨñeb ne okok kɨlop suk agek apel agɨnɨgab, Mani ñɨnek okok wog gɨl, pen tɨtay dɨpɨm agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Agek, bɨ ned apɨl agɨnɨgab, Bɨawl. Mani yɨl yɨp ñɨnak omɨŋal ak, wog gɨl, pen yɨl ñɨn juwɨl ak dɨpin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Agek bɨawl ak agɨnɨgab, Nad bɨ wog gɨñeb teplep ak, gɨtep gɨpan agɨnɨgab agak. Tap sɨkol ak ñenek wog gɨtep gɨnak tek, mɨñɨl taun anep wajɨlem ak agen kod yenɨgaban agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bɨ nab ak apɨl agɨnɨgab, Bɨawl. Mani yɨl yɨp ñɨnak omɨŋal ak, wog gɨl, pen yɨl anep wajɨlem ak dɨpin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Agek, bɨawl ak agɨnɨgab, Gɨpan anɨb ak tek, mɨñɨl taun anep mamɨd ak agen kod yenɨgaban agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pen bɨ olap apɨl agɨnɨgab, Bɨawl. Yad nep nepin agɨnɨgab agak. Nad bɨ kabɨyam tɨmel yɨbɨl agɨnɨgab agak. Binɨb tap kɨlop okok, nad sɨkim gɨtep gɨl mel, pɨl gɨl tek dɨpan agɨnɨgab agak. Tap wog koslam gɨl yɨbal okok, nad kɨles gɨl nep taw pɨlɨg ñɨban agɨnɨgab agak. Anɨb ak yad nep pɨlɨkɨl, mani yɨl yɨp ñɨnak omɨŋal ak, yokɨp dam tunɨg len mɨdek, mɨñɨl dad opin agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Agek bɨawl ak agɨnɨgab, Nad bɨ wog gɨñeb tɨmel yɨbɨl ak agɨnɨgab agak. Takaw nak apan ak, ne ke tɨg adɨkɨl nɨgɨnɨgayn agɨnɨgab agak. Yɨp apan, Bɨ kabɨyam tɨmel yɨbɨl, binɨb tap kɨlop okok sɨkim gɨtep gɨl mel, pɨl gɨl tek dɨpan, tap wog koslam gɨl yɨbal okok nad kɨles gɨl nep taw pɨlɨg ñɨban apan agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Anɨb ak, taynen mani yɨp ak dɨl, dam le, wog gek adɨkɨd dape yokɨp ogɨnap sek ma dɨpin agɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anɨb agɨl, bɨ yep wulep sɨŋak yenɨgabal okok kɨlop agɨnɨgab, Mani yɨl omɨŋal ak pɨlɨg dɨl, bɨ mani yɨl ñɨn juwɨl ak nop ñɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Agek agɨnɨgabal, Bɨawl. Ne mani yɨl ñɨn juwɨl ak dɨ mɨdeb agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Agel agɨnɨgab, Nɨbop agebin, binɨb tap kɨli mɨdeb okok, kɨlop ogɨnap sek ñɨnɨgayn agɨnɨgab agak. Pen binɨb tap kɨli ma mɨdeb okok, tap sɨkol olap dɨ yenɨgabal ak, yad dɨl dɨyokɨnɨgayn agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pen binɨb yɨp apal, Gapman bɨawl yɨbɨl anɨb ak chɨn gos ma nopun agɨl mɨlɨk nepal okok, kɨlop am dad apɨl, wɨdɨn mɨdup adek yɨp sɨŋawl ñaglɨnɨmɨb agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas kɨlop takaw anɨb ak agɨl, Jelusalem amnin agɨl, ne jɨtep ak tɨkjakɨl Jelusalem alaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Am am, dum Olip pɨl man sɨkol Betpage ayɨp Betani ayɨp gol sɨŋak amjakɨl, bɨne omɨŋal kɨlop agyokɨl agak, ");
INSERT INTO taw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Man sɨkol wakay adaŋ amɨl nɨgɨnɨgayl, chag donki malep binɨb ma dad ajup olap, tunɨg lel yenɨgab agak. Wɨsɨbɨl dad ownɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pen binɨb ogɨnap apɨl agɨnɨgel, Taynen chag donki chɨnop ak wɨsɨbebil agenɨgel, agɨnɨmil, Bɨawl ak wog mɨdek chɨlop agyokek dɨnɨg opul agɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Anɨb agek, amɨl nɨgɨlek, agak tek nep yek. ");
INSERT INTO taw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am nag ak wɨsɨb gɨlek nɨŋɨd, bɨ chag donki nap nɨb okok apɨl agɨlak, Chag donki malep chɨnop ak taynen nag wɨsɨbebil agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Agel agɨlek, Bɨawl ak wog mɨdek chɨlop agyokek dɨnɨg opul agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Anɨb agɨl chag donki malep anɨb ak nag wɨsɨbɨl, poŋɨd dad Jisas yek ak amjakɨl, chech kɨli bad ogɨnap tɨg juwɨl, dɨ chag donki adek ak lɨl, Jisas nop dɨl anɨb alaŋ lel besɨgak. ");
INSERT INTO taw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Besɨgɨl, kanɨb adek ak amnaknɨŋ, binɨb okok chech tap okok dap kanɨb adek anɨb ak laknɨŋ, tob tawlɨg tawlɨg amnak. ");
INSERT INTO taw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am am Jelusalem wulep wulep gaknɨŋ, dum Olip kanɨb kuyan gup tep ak, binɨb ne okok kuŋay yɨbɨl nop mɨñmɨñ yɨbɨl gɨlak. Mɨñmɨñ yɨbɨl gɨlɨg, tap tɨtay gak okok gos nɨŋɨd, suk awl agɨlɨg, God nop tep agɨlɨg ");
INSERT INTO taw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","agɨlak, God ne bɨnonɨm awl chɨnop yɨl agyokek owup awl, God gek mɨdtep gɨnɨgab agɨlak. God man ne alaŋ mɨdtep gɨnɨgabal agɨlak. God ne adek alaŋ mɨdeb, yɨb nop ak dad aplanɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Anɨb agɨlak nɨŋɨd, bɨ Pelisi ogɨnap nab anɨb ak yelak okok, kɨli Jisas nop agɨlak, Tisa. Binɨb nak okok kɨlop ag ge, anɨb ma agɨlaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Agelak Jisas agak, Nɨbop agebin, kɨli takaw anɨb ak ma agenɨgabal, God pen kab okok gek, kab okok suk agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jelusalem wulep wulep gɨlɨg, anɨb ak nɨŋɨd chaŋ lɨlɨg ");
INSERT INTO taw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","agak, Man Jelusalem awl. Mɨñɨl ñɨn awl tap okok gek mɨdtep gɨnɨgab ak, nopɨkop tek tep yɨbɨl gɨpɨkop agak. Pen mɨñɨl nɨbi wɨdɨn koy tek mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kɨdek bɨ tɨmel ogɨnap apɨl taun nɨbop awl ñɨluk lɨl kuskus gɨ mɨdɨl, ");
INSERT INTO taw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","nep gɨ tɨmel gɨl, binɨb nak okok kɨlop abe gɨ tɨmel gɨnɨgabal agak. Gɨ tɨmel gel, kab olap kab olap adek ak ma yenɨgab, mɨdupsek pɨpag pakɨl dɨyokɨnɨgabal agak. Taynen? God nɨbop yɨl apek ma dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas anɨb agɨl, God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak amɨl, binɨb tap tawelak okok kɨlop dɨl, okok okok dɨyokak. Dɨyokɨlɨg agak, ");
INSERT INTO taw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Buk Baybol ñu kɨl tɨkɨl agɨlak, God ne agup, Kal yad ak, yɨp agnɨgep kal ak mɨdeb agup agɨl tɨkɨlak agak. Pen nɨbi anɨgem, bɨ tap si dɨl weyɨg mɨdebal kal olap tek lup agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pen ne mɨnek mɨnek ap God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ apɨl, binɨb okok kɨlop takaw agñolɨgup. Bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Juda bɨawl okok sek, kɨli nop paklun agɨl gos nokom nɨgɨlak. Anɨgɨl nɨgɨlak ak pen, ");
INSERT INTO taw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","binɨb mɨdupsek takaw tep nop ak nɨgun agɨl, kɨles tɨmel yɨbɨl gelak, bɨawl olap kɨli dep tek ma mɨdeb. ");
INSERT INTO taw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pen ñɨn nab anɨb sɨŋak, Jisas God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak amɨl, ne binɨb okok kɨlop takaw teplep ak agñak. Agñaknɨŋ, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, Juda bɨawl okok sek owlak. ");
INSERT INTO taw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Apɨl nop agɨlak, Nad kɨles akal nɨb dɨl, tap anɨb ak gɨ ajɨpan agɨlak? Nep an anɨgɨnɨmɨn agek, gɨ ajɨpan agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Agel agak, Yad nɨbop pen takaw olap ned agnɨgɨnɨgebin agak. Nɨbi yɨp agñɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon binɨb okok kɨlop ñɨg pakñak ak, God agek pakñak akaŋ, bɨ gos ne ke nɨŋɨd pakñak agak? ");
INSERT INTO taw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Agek kɨli ke agnɨg agnɨg gɨl agɨlak, Chɨn agɨnɨgabun, God agek binɨb okok kɨlop ñɨg pakñak agon, ne taynen Jon takaw nop ak ma dɨpɨm agɨnɨgab agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pen binɨb okol, kɨli Jon bɨ God gos ñek agñeb yolɨgup ak agɨl gos nepal agɨlak. Anɨb ak tek, chɨn agɨnɨgabun, Jon gos ne ke nɨŋɨd gak agon, chɨnop kab sɨlok paklɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gos anɨb ak nɨŋɨd anɨb agɨlak, Chɨn ma nopun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Anɨb agelak, Jisas kɨlop agak, Nɨbi yɨp ma agñɨbɨm tek, yɨp an agek tap anɨb okok gɨpin ak nɨbop pen ma agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pen Jisas binɨb yelak okok kɨlop takaw paladaŋ lɨl agak, Bɨ olap wayn wog olap gɨ yɨmɨl, bɨ wog nop gɨnɨgabal ogɨnap kɨlop aglɨl, ne am man palawl yɨbɨl okok pelpel yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pen wayn mɨdup pok gɨnɨgab ñɨn ak, bɨ wog gɨñeb ne olap agyokɨl agɨnɨgab, Am age, wayn mɨdup yɨp ogɨnap ñel, dad ownɨmɨn agɨnɨgab agak. Agek amjakek, bɨ wayn wog gɨ yenɨgabal okok, nop pak lɨl, yokɨp agyokel, adɨkɨd ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Anɨgel, bɨ wayn wog nap nɨb ak, bɨ wog gɨñeb ne olap pen agyokek amnɨgab agak. Pen nop abe pak lɨl, gɨ tɨmel yɨbɨl gɨl, yokɨp agyokel, adɨkɨd ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Anɨgel, bɨ wog gɨñeb ne kɨdeyɨl nɨb olap agyokek amjakek, nop tapɨn yɨbɨl pakɨl, lɨpɨg dam seŋayaŋ yokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Anɨgel, bɨ wog day nap nɨb ak agɨnɨgab, Tɨtay dɨnɨm agɨnɨgab agak? Ñɨ mapen yad ak agyoken, takaw agenɨgab tek nɨgɨnɨgabal agɨl agyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Agyokek amjakek, bɨ wayn wog gɨ yenɨgabal anɨb okok nop nɨŋɨd, agnɨg agnɨg gɨl agɨnɨgabal, Ñɨ owup awl, nap wayn wog ak ne dɨnɨmuŋ tek lup agɨnɨgabal agak. Nop pɨsnep paklɨl, chɨn dun agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Anɨb agɨl, nop lɨpɨg dam seŋ okok amɨl, pɨsnep paklel kumnɨgab agak. Agɨl, binɨb yelak okok kɨlop agnɨŋɨd agak, Pen anɨb genɨgabal, bɨ wog day nap nɨb ak kɨlop tay gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne apɨl, bɨ anɨb okok kɨlop paklɨl, wog day anɨb ak bɨ ogɨnap kɨlop pen agek kod yenɨgabal agak. Jisas anɨb agek, binɨb nɨg yelak okok agɨlak, Mel. Ne anɨgɨl ma gɨnɨmuŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Agelak, kɨlop nɨg kuskus gɨl agak, Buk Baybol ak, takaw anɨb ak tek tɨkɨl agɨlak, Bɨ kal gep okok kab olap ma dɨnɨgun agɨl kelɨgɨlak ak, kab anɨb ak mɨñɨl kal meg nab ayaŋ tek ak mɨdeb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Binɨb kab anɨb ak adek apyap pakɨnɨgabal okok kɨlop tapɨn yɨbɨl pakɨnɨgab agak. Kab anɨb ak pen, binɨb kɨlop pɨgju apyapɨl lɨ bɨlɨkɨnɨgab okok, pɨsnep pak jɨsɨpuk gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas wayn wog takaw paladaŋ lɨl anɨb agek, chɨnop nep tɨmel agup agɨl, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ God nop sɨbogep bɨawl okok sek, anɨb ñɨn ak nep nop nag lun agɨl nɨgɨlak. Anɨgɨl nɨgɨlak ak pen, binɨb kuŋay nep nɨg yelak nɨŋɨd, pɨlɨkɨl kelɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pen Jisas takaw agak okok nɨŋɨd, nop tɨtay dɨl dad nag lɨnɨg amnɨgun agɨl, am binɨb ogɨnap kɨlop mɨmug gɨl agɨlak, Nɨbi binɨb teplep tek sɨlok lɨl, am takaw yepɨs agɨl nop takaw ogɨnap agɨnɨmɨb agɨlak. Agem, pen tay agonɨmuŋ nɨŋɨd, nop dad amɨl gapman ñɨn adek ak lɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Anɨb agel, nop am agnɨŋɨd agɨlak, Tisa, chɨn nopun, takaw nad ak nɨŋɨd yɨbɨl mɨdeb, takaw nɨŋɨd yɨbɨl won ak binɨb kɨlop agñɨban agɨlak. God agup tek nep nɨŋɨd, binɨb okok kɨlop yɨpɨd gɨl yɨbɨl agñɨban agɨlak. Bɨ yɨb mɨdeb akaŋ ma mɨdeb, anɨgɨl gos ma nepan agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Anɨb ak tay gɨnɨgun agɨlak? Lom gapman bɨnonɨm nop takis ñɨnɨgun akaŋ mel agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kɨli yepɨs agɨlak anɨb ak Jisas ne ke nɨŋɨd, kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mani takis ñɨbal anɨb ak, olap yɨp dɨñem nɨgin agak. Agek dɨñel nɨŋɨd, anɨb agak, Mani bak ak, an jomulɨk ak sek, yɨb ak sek mɨdeb agak? Agek agɨlak, Lom gapman bɨnonɨm mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Agel kɨlop agak, Anɨb ak Lom gapman bɨnonɨm ak ne tap yɨp ñɨnɨmɨb agup anep ñɨnɨmɨb agak. God tap yɨp ñɨnɨmɨb agup anep ñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne binɨb anɨb okok ayɨp mɨdɨl takaw agak anɨb ak, kɨli nɨgel mɨŋel nop olap dɨnɨmuŋ tek ma lek, wal agɨl, takaw ma agɨl yelak. ");
INSERT INTO taw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bɨ ogɨnap, binɨb kumɨl tepayaŋ ma tɨkjakɨpal agɨl, gos ak nɨgelɨgɨpal. Bɨ anɨb okok kɨlop bɨ Sajusi agelɨgɨpal. Bɨ kɨli ogɨnap, apɨl Jisas nop ");
INSERT INTO taw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","agɨlak, Tisa. Mosis takaw olap chɨnop tɨkɨl agak, Bɨ olap bin dɨl, ñapay tɨkɨl mel yokɨp kumenɨgab, nɨmam ne olap pen bin anɨb ak dɨl, ñapay nop ak agɨl tɨkɨnɨgab agɨl tɨkak agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Anɨb ak bɨ wagen sek anep kugul yenɨgabal ak, nɨmam ned ak bin dɨl, ñapay tɨkɨl mel yokɨp kumnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kumek, nɨmam nab bin anɨb ak dɨl, abe ñapay tɨkɨl mel yokɨp kumnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Anɨgek nɨmam nab ak pen dɨnɨgab agɨlak. Ak abe ñapay tɨkɨl mel yokɨp kumnɨgab agɨlak. Anɨgɨ dam dam nɨmam anep kugul ak mɨdupsek ñapay tɨkɨl mel yokɨp kumnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kɨdek bin anɨb ak abe kumnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pen kumɨl tɨkjakɨnɨgabal apan ak, bin nokom bɨne dɨl anep kugul ak lɨnɨgab anɨb ak, kɨdek an yɨl yenɨgab agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Agel Jisas kɨlop agak, Mɨñɨl mɨdobun ñɨn awl, bin okok bɨ dɨpal, bɨ okok bin dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pen God binɨb kɨlop agek tepayaŋ tɨkjakɨl pel pelnep yenɨgabal ak, bin okok bɨ ma del, bɨ okok bin ma dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","God pen gek tepayaŋ ma kumnɨgabal won ak, God ñɨpay ne okok mɨdɨl, ensel ne okok pel mɨdebal tek yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Binɨb kumɨl tɨkjakɨpal takaw ak, Mosis abe agɨl tɨkak ak nopun agak. God mab sɨkol mɨŋɨlaŋ gek nab yek ak, Mosis kesɨm anɨb ak tɨkɨl, based ned kumɨlak okok yɨb kɨlop tɨkɨl agak, Eblaham ayɨp, Aysak ayɨp, Jekop ayɨp, God kɨli mɨdeb agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Binɨb ned kumɨlak okok, God kɨli mɨdebin agak, anɨb ak tek chɨn nopun, binɨb kɨm mɨdebal akaŋ kubal okok, God nɨgek mɨdupsek kɨm mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisas anɨb agek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap agɨlak, Tisa. Takaw yɨpɨd gɨl nep ageban agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Takaw agtep gak anɨb ak pɨlɨkɨl, kɨdek takaw ogɨnap nop ma agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pen Jisas kɨlop agak, Bɨ God nop aglup ak, taynen binɨb okok nop Depid tɨk dad amɨl apɨl gek tɨkɨpal ñɨ ak nep apal agak? ");
INSERT INTO taw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Depid ne ke, Bɨ God nop aglup anop takaw agɨl, Buk Kɨmep apal ak tɨkɨl agak, God ne Bɨawl yad anop agup, Nad ñɨn yɨpɨd kɨd yad okok besɨg yenɨmɨn agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Besɨg mɨdɨl, mɨd dad amɨl, binɨb nad ayɨp penpen gep okok kɨlop tob muk nak okok len, taw tɨbɨkɨnɨgaban agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Depid ne ke agak, Bɨ anɨb ak Bɨawl yad agak. Anɨb ak, tɨtay dɨl Depid ñɨsed ak mɨdeb agak? ");
INSERT INTO taw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pen binɨb okok nɨg yelak nɨŋɨd, Jisas bɨne okok kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Nɨbi bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok gɨpal tek gɨnɨmɨb tek lup, anɨb ak tek nɨgtep gɨl kɨli gɨpal tek ma gɨnɨmɨb agak. Kɨli anɨgɨl gɨpal agak. Chɨn ajon yɨb chɨnop ak nep agɨlaŋ agɨl, chech teplep okok yɨbal agak. Anɨgɨl, Juda apnan gɨpal kal okok amɨl bɨawl besɨgep adek ak besɨgɨpal agak. Tap awl ñɨbal ñɨn ak, bɨawl mɨdebal mɨj adek besɨgɨl tap ñɨbal agak. ");
INSERT INTO taw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pen bin kaŋɨl kal tap kɨlop okok, chɨnop yɨl tɨkaŋ agɨl, lɨplɨp gɨpal agak. God ayɨp agobun agɨl, takaw palawl yepɨs yepɨs adek okok apal agak. Anɨgɨpal ak kɨdek yul awl ke yɨbɨl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas mɨdɨl nɨgak, binɨb mani tap kuŋay yɨbɨl mɨdeb okok, mani ogɨnap dap opa gelɨgɨpal mɨgan ak gelak. ");
INSERT INTO taw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pen bin kaŋɨl yɨmgeptek olap, mani nɨkɨm sek sɨkol omɨŋal ak dap ñak. ");
INSERT INTO taw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ñek Jisas nɨŋɨd anɨb agak, Nɨbop nɨŋɨd agebin. Binɨb ogɨnap mani sɨkol ñɨbal, bin kaŋɨl yɨmgeptek awl, mani ne awl yɨbɨl ak ñub agak. ");
INSERT INTO taw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nɨgɨm. Binɨb ogɨnap mani kɨli kuŋay nep mɨdaknɨŋ opa gɨpal ak pen, bin kaŋɨl yɨmgeptek awl, mani ne mɨdeb tek mɨdupsek ñub agak. Tap taw ñɨŋɨnɨmuŋ olap ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pen bɨ ogɨnap agɨlak, Kɨli kab teplep okok, tap teplep okok dad apɨl, God nop ñɨl God agnɨgep kal awl ak gɨlak agɨlak. Kal anɨb ak tep yɨbɨl mɨdeb agɨlak. Anɨb agel, Jisas kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Anɨb apɨm ak pen, kɨdek tap tep nɨgebɨm anɨb okok ma yenɨgab agak. Bɨ penpen ñagep okok apɨl, kal anɨb okok gɨ tɨmel gel, kab olap kab olap adek ak ma yenɨgab, pɨsnep pɨpag pakɨl dɨyokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jisas anɨb agek, nop agnɨŋɨd agɨlak, Tisa. Tap agesɨpan okok, ñɨn akal tek gɨnɨgab agɨlak? Pen tay gek nɨŋɨd anɨb agɨnɨgabun, Bɨawl agak ñɨn ak mɨñɨl gɨnɨgeb agɨl nɨgɨnɨgabun agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Agel, kɨlop agak, Nɨgtep gɨnɨmɨb agak. Bɨ kuŋay yɨbɨl yepɨs yepɨs agɨl, yɨb yɨp ak dɨlɨg agɨnɨgabal, Yad nep apebin agɨnɨgabal agak. Ñɨn awl ak owup agɨnɨgabal agak. Anɨb agɨnɨgabal ak pen, nɨŋɨd apal agɨl ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pen man wakay ogɨnap tɨkjakɨl, man wakay ogɨnap ayɨp penpen gɨnɨgabal agak. Man wakay ogɨnap kɨli ke nep penpen gɨnɨgabal agak. Anɨgɨnɨgab ak pen, gos nɨgtep gɨl gos kuŋay ma nɨgɨnɨmɨb agak. Tap anɨb okok gonɨmuŋ tek lup ak pen, ñɨn kɨdek ak ownɨgeb agɨl gos ak ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Anɨb agɨl kɨlop agak, Bɨ wakay ogɨnap tɨkjakɨl, bɨ wakay ogɨnap ayɨp penpen gɨnɨgabal agak. Gapman bɨnonɨm ogɨnap bɨne okok tɨkjakɨl, gapman bɨnonɨm ogɨnap bɨne okok ayɨp penpen gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Man okok monmon awl yɨbɨl dɨl, yuwan awl gɨl, mɨñak awl gɨl gɨnɨgab agak. Tap wɨsɨp adek alaŋ okok ke kɨdek nɨb lek, pɨlɨkep tek lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pen tap anɨb okok kɨdek anɨgɨnɨgab agak. Ned yɨp yɨl mɨdebɨm tek, nɨbop dɨl tɨmel gɨnɨgabal agak. Nɨbop kot gɨnɨg, dad Juda apnan gɨpal kal ak amɨl kot gɨl, nag lɨl dam gapman bɨnonɨm kot ak amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nɨbop gɨnɨgabal anɨb ak, takaw tep yad ak mɨseŋ agñɨnɨmɨb tek lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pen takaw tay tek agɨnɨgun agɨl ned ma pɨyow nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yad ke nɨbop gos tep ñen, agñɨnɨmɨb nɨŋɨd, bɨ tɨmel gɨpal anɨb okok kɨli takaw nɨbi dɨyokep tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pen nanɨm nap, namam, bogɨlak nɨbi, binɨb nɨbi ke okok, chen mɨmug dapel, nɨbop ogɨnap pɨsnep paklɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yɨp yɨl yenɨgabɨm tek nɨŋɨd, nɨbop mɨlɨk nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pen mɨdtep gɨnɨgabɨm, kɨmɨg wɨj nɨbop olap ma kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nɨbi kɨles gɨl yɨp yɨl yenɨgabɨm ak, mɨd dad amɨl ñɨn kɨdek ownɨgab ak, pelpel yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pen bɨ chɨm kadɨŋ gep okok kɨli ap Jelusalem kuskus gɨlaknɨŋ agɨnɨmɨb, Mɨñɨl Jelusalem gɨ tɨmel gɨnɨgebal agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Binɨb Judiya plopens yenɨgel okok, pɨlɨk dum oklaŋ okok amnɨgel agak. Binɨb Jelusalem yenɨgel okok pɨlɨk seŋ amnɨgel agak. Pen binɨb seŋ okok yenɨgel okok, Jelusalem mɨgan ayaŋ ma amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Taynen? God pen gɨ tɨmel gɨnɨgab ñɨn ak, ñɨn anɨb ak buk Baybol tɨkɨl agɨlak tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ñɨn anɨb ak, bin ñapay kogmeg yenɨgabal okok sek, ñapay tul ñɨnɨgabal okok sek, koslam pɨlɨk amnɨgabal agak. God Yislel binɨb okok kɨlop gɨ tɨmel gaknɨŋ, man awl abe gɨ tɨmel yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Binɨb ogɨnap kɨlop baynat dɨl puŋɨl lɨnɨgabal, binɨb ogɨnap kɨlop nag lɨl dad man okok amnɨgabal agak. Pen binɨb yokɨp okok, kɨli Jelusalem gɨ tɨmel gɨ mɨdel mɨdel, God kɨlop ñɨn aglak ak padɨkek nep, kelɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Pen sub ak ke yɨbɨl lɨl, takan ak ke yɨbɨl lɨl, gap okok ke yɨbɨl lɨl gɨnɨgab agak. Ñɨg solwala pag apɨl gu awl agek, binɨb man kɨd kɨd mɨdupsek gos pal lɨlɨg, gos kuŋay nep nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tap adekab alaŋ mɨdeb okok, pɨg juwɨl okok nɨb okok nɨb gek, lum awl tay gɨnɨgeb agɨl, jel pɨlɨkɨl, gos tɨkek apek, kumeb tek lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Anɨgek, Bɨ Olap Ñɨne, kɨles awl sek mɨlek awl sek dɨl, wɨsɨp bad sek owaknɨŋ, binɨb okok mɨdupsek nop nɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tap agebin awl kɨdek gaknɨŋ, bɨawl chɨnop dɨnɨgab ak wulep mɨdeb ownɨgab agɨl, nɨg yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas anɨb agɨl, takaw paladaŋ lɨl agak, Mab pik ak sek, mab yokɨp ogɨnap sek nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sɨlup lek nɨŋɨd, mɨñɨl sub lɨnɨgeb agɨl nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Anɨb ak tek, tap anɨb okok agebin ak gaknɨŋ nɨgɨnɨgabɨm, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak wulep apeb agak. ");
INSERT INTO taw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yad nɨbop nɨŋɨd agebin agak. Binɨb jɨj mɨñɨl mɨdebal adek awl ogɨnap yelaknɨŋ, tap anɨb okok mɨdupsek gek nɨŋɨd kɨdek kumnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adekab sek, lum awl sek kul gɨnɨgab ak pen, takaw yad ak ma kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pen nɨgtep gɨnɨmɨb agak. Ñɨg kɨles tap okok kuŋay ñɨbɨl, sɨkim, sɨme yɨg chedbɨl, tap lum awl nep gos nɨg yenɨgabɨm, ñɨn anɨb ak kasek yɨbɨl apɨl, nɨbop sab chag tap okok gon lel dup tek ak dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Okol nep ma gɨnɨgab, binɨb lum wagen awl mɨdebal tek mɨdupsek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anɨb ak nɨgtep gɨnɨmɨb agak. God ayɨp agɨlɨg nep mɨdem nɨm, tap anɨb okok gaknɨŋ, nɨbop kɨles ne ak ñek nɨbi koŋɨm amnɨgabɨm agak. Bɨ Olap Ñɨne wɨdɨn mɨdup adek ak amɨl jak yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Anɨb ñɨn bad ak, Jisas am God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak mɨdɨl, binɨb okok kɨlop takaw agñolɨgup. Kɨli mɨdupsek takaw nop nɨgun agɨl, maynab yɨbɨl tɨkjakɨl, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amelɨgɨpal. Pen kɨsɨlɨm owaknɨŋ, Jisas ne amɨl, man Olip dum kɨnolɨgup. ");
INSERT INTO taw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Juda kɨli bilet ma yɨnɨg tanub ñɨbal ñɨn awl ak wulep owak. Ñɨn awl anɨb ak Pasopa agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pasopa ñɨn awl anɨb ak wulep gak nɨŋɨd, bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, kɨli Jisas nop pakun agɨlak ak pen, binɨb okok kɨlop pɨlɨkɨl taydɨl pakɨnɨgun agɨl nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Agɨl nɨg mɨdɨlaknɨŋ, Satan ne Judas nop nab ayaŋ amnak. Judas ne Jisas bɨ takaw nop dad ameb anep umɨgan bɨ olap mɨdeb. Yɨb ne olap Yiskaliyot. ");
INSERT INTO taw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan ne Judas nop nab ayaŋ amek, Judas ne am bɨ God nop sɨbogep bɨawl okok sek, bɨ God agnɨgep kal awl polis bɨawl okok sek yelak ak amɨl, Jisas nop tɨtay dɨl chen gɨ dad apɨl nɨbop yokɨnɨgayn agɨl kɨlop agñak. ");
INSERT INTO taw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Agek, kɨlop tep gek, nop agɨlak, Nep mani ñɨnɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Agelak, Judas takaw kɨlop yaw agak. Ne won akal tek Jisas binɨb okok ayɨp ma yelak nɨŋɨd, nop chen gɨ dad amɨl bɨawl okok kɨlop ñɨnɨgayn agɨl kod yek. ");
INSERT INTO taw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pen bilet ma yɨnɨg tanub ñɨbal ñɨn anɨb ak apek, chag sipsip ñɨluk olap God nop pak ñɨnɨgun agɨl gos nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Anɨgɨl, Jisas ne Pita ayɨp Jon ayɨp kɨlop agyokɨl agak, Ñɨli am Pasopa tap mɨdup chɨn ñɨŋeb okok gɨlɨtep gɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Agek agɨlek, Nad nepan, chɨl am gɨlɨnɨgul akal agɨlek? ");
INSERT INTO taw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Agel agak, Ñɨli taun ak amɨl nɨgɨnɨgayl, bɨ olap ñɨg mal dad apenɨgab agak. Nop nebeŋ pakɨl kal mɨgan amnɨmuŋ ak kɨdek amɨl, ");
INSERT INTO taw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bɨ kal nap nɨb ak nop agɨnɨmil, Tisa ne nep agup, Kal mɨgan akal, bɨyad ayɨp Pasopa tap ñɨŋɨnɨgun agup agɨnɨmil agak? ");
INSERT INTO taw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Agel bɨ anɨb ak ne kal mɨgan anɨb ak adek alaŋ abañ ñɨluk tap okok sek mɨdeb ñɨlop dam yomek, tap mɨdup okok kal mɨgan anɨb ak gɨlɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Agek amɨl nɨgɨlek, agak agak tek nep gek, Pasopa tap ñɨŋɨnɨg gɨlak okok gɨlɨtep gɨlek. ");
INSERT INTO taw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pen ñɨn anɨb ak owaknɨŋ, Jisas chɨn tap ñɨŋɨnɨgun agɨl, bɨ takaw nop dad ameb okok ayɨp besɨg kus gɨl ");
INSERT INTO taw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kɨlop agak, Gos yad awl yɨbɨl ak, nɨb ayɨp tap Pasopa ñɨŋɨnɨgabun, kɨdek yad yɨpɨl mab ak dɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pen yad nɨbop agebin, mɨñɨl ñɨn awl tɨkɨl, tap anɨb ak tepayaŋ ma ñɨbɨl, yokɨp nep mɨden mɨden, tap jɨj ak nɨm mɨseŋ laknɨŋ, God binɨb dɨl kɨlop kod yenɨgab ñɨn ak ownɨgab agak. Kɨdek pen ñɨŋɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisas anɨb agɨl, ñɨg wayn kɨnag dɨl God nop tep agɨl agak, Nɨbi ke ñɨg wayn kɨnag anɨb ak dɨl yɨg lɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pen nɨbop agebin, mɨñɨl ñɨn awl tɨkɨl ñɨg wayn ak ma ñɨbɨl, yokɨp nep mɨden mɨden God binɨb dɨl kɨlop kod yenɨgab ñɨn ak ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Anɨb agɨl, tap mɨdup dɨl, God nop tep agɨl, tɨpagɨl kɨlop ñɨlɨg agak, Mubwak yad ak ñen, nɨbop gek mɨdtep gɨnɨgabɨm agak. Nɨbi dɨl gos yɨp nɨgɨlɨg ñɨŋɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pen tap ñɨbdɨl, ñɨg wayn kɨnag anɨb nep gɨl agak, Nɨkɨm yɨp sogek kumen nɨm, God nɨbop binɨb yad agɨl dɨnɨgayn agak takaw koŋɨm anɨb ak, am wos gɨnɨgab agak. Ak nɨm, nɨbop ñɨg wayn awl ñebin agak. ");
INSERT INTO taw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nɨbi nɨgɨm. Bɨ yɨp chen gɨ dad amnɨgab ak, yad ayɨp besɨg tap ñɨb mɨdobul agak. ");
INSERT INTO taw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Buk Baybol ak bɨlel agɨl tɨkɨlak tek, Bɨ Olap Ñɨne chen gɨ dad amɨl, paklek kumnɨgab agak. Bɨ anɨb ak pen, ne Bɨ Olap Ñɨne nop chen gɨ dad amnɨgab ak, ne tɨtay dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jisas anɨb agek, bɨne okok kɨli ke nep Yad gɨnɨgayn akaŋ bɨ an anɨgɨnɨgab agɨl, pen agek pen agek gɨlɨg mɨdelak. ");
INSERT INTO taw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Won anɨb ak Jisas bɨne okok kɨli ke penpen agɨlɨg yelak. Keke agɨlak, Nad mel, yad bɨawl mɨdebin agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pen Jisas kɨlop agak, Binɨb Juda mel okok gapman bɨnonɨm kɨli, binɨb okok kɨlop kɨles gɨl kodɨpal ak pen kɨli apal, Binɨb kɨlop gɨtep yɨbɨl gɨpun apal agak. ");
INSERT INTO taw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pen nɨbi anɨb ak tek ma gɨnɨmɨb agak. Bɨawl nɨbi okok kɨli ñɨsɨkol tek wog gɨnɨgel agak. Bɨawl yɨbɨl okok kɨli bɨ wog gɨñeb tek wog gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nɨbi gos nɨgtep gɨnɨmɨb agak. Lum awl kodɨpal bɨ ak, tap mɨdup anɨgɨl ñɨbal agak. Bɨawl okok ap besɨgel, bɨ wog gɨñeb okok tap mɨdup kɨlop okok dopal agak. Yad pen nɨbop yokɨp bɨ wog gɨñeb tek ak gɨpin agak. Nɨbi anɨb ak tek gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yɨp mɨŋel yɨbɨl gup ñɨn ak nɨbi ma kelɨgɨpɨm agak. Kod nep yesɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Anɨgɨpɨm ak, God yɨp agak, Binɨb dɨl kod yenɨgaban agak anɨb ak tek, yad mɨñɨl nɨbop agebin, Binɨb dɨl kod yenɨgabɨm agebin agak. ");
INSERT INTO taw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Anɨb ak nɨm, yad binɨb dɨl kɨlop kod yenɨgayn ñɨn anɨb ak, nɨbi abañ yad ak besɨgɨl tap mɨdup ñɨbɨl ñɨg ñɨbɨl bɨawl besɨgep adek okok besɨgɨnɨgabɨm agak. Besɨgɨl, Yislel wagen anep umɨgan ak kɨlop kod yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas Pita nop agak, Saymon, nad nɨgan agak. Satan ne God nop agnɨgak agak. Agnɨŋɨd, wit mɨdup sogel sogel mɨdup yɨbɨl ak ke lɨl, cheg ak keke dɨyokɨpal tek ak nɨbop gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pen God nop agnepin tek, yɨp pɨsnep ma kelɨgɨnɨgaban agak. Nad tepayaŋ adɨkɨd yɨp yɨl ownɨgaban ak, namam nad kɨlop agtep ge kɨli abe mɨdtep gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jisas anɨb agek Pita agak, Bɨawl. Yad nep ma kelɨgɨnɨgayn agak. Chɨl omɨŋal gɨl nep ajol, nep nag lɨl yɨp abe nag lɨnɨgabal agak. Pen nep paklɨl yɨp abe paklɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Agek Jisas agak, Pita. Yad nep agebin. Mɨñɨl sɨbmɨg ayaŋ yawl kakaluk suk ma agɨnɨgab won ak agɨnɨgaban, Jisas nop ma nepin agɨl, takaw won omɨŋal nokom agɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Anɨb agɨl kɨlop agak, Ned nɨbop agyokɨl agɨnek, Mani, wad, tob tɨlup okok dad ma amnɨmɨb agɨnek agak. Yokɨp amnɨmɨb agɨnek agak. Agen abek ñɨn anɨb ak, tap nɨbi ogɨnap yek akaŋ ma yek agak? Agek agɨlak, Mel, yek agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Agelak Jisas agak, Mɨñɨl pen nɨbi mani, wad mɨdeb ak dad amnɨmɨb agak. Bɨ an tu palkep ma mɨdonɨmuŋ ak, walɨj ne olap bɨ ogɨnap kɨlop ñɨl mani dɨl, tu palkep ak tawnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pen nɨbop agebin agak. Ned God takaw anɨb ak kɨl tɨkɨlak ak, yɨp anɨgɨnɨmuŋ agak. Tɨkɨl agɨlak, Ne bɨ tap si tap tɨmel gɨpal okok tek yenɨgab agɨl gos nɨgɨnɨgabal agɨl tɨkɨlak. Takaw agɨl tɨkɨlak anɨb ak, mɨñɨl yɨp anɨgɨnɨgeb agak. ");
INSERT INTO taw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Anɨb agek agɨlak, Bɨawl. Tu palkep chɨn omɨŋal mɨdeb agɨlak. Agel agak, Mɨñɨl tep agak. ");
INSERT INTO taw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Anɨb agɨl seŋ amɨl, mɨnek mɨnek amolɨgup man Olip dum amnak nɨŋɨd, bɨne okok kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dum anɨb ak amjakɨl kɨlop agak, Gos tɨmel apek tɨmel gɨnɨmɨb tek lup, anɨb ak tek God nop agɨlɨg mɨdenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Anɨb agɨl kɨlop kelɨgɨl, keke sɨŋadaŋ amɨl, kɨgom yɨmɨl, God nop agnɨŋɨd ");
INSERT INTO taw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","agak, Bapi, tap yɨp gɨnɨgeb anɨb ak mel agɨl yɨl, mel agɨnɨmɨn agak. Pen yad gos nepin adek ak ma gɨnɨmɨn, gos nad ke nepan tek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Anɨb agek, ensel olap God man ne alaŋ nɨb apɨl, ke nɨb mɨseŋ lɨl nop kɨles ñak. ");
INSERT INTO taw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Anɨgek, nop mɨŋel yɨbɨl gek kɨles tɨmel yɨbɨl gɨl God nop agnɨgaknɨŋ, wɨsɨb ak nɨkɨm tek jakɨl lum ayaŋ yowak. ");
INSERT INTO taw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ne God ayɨp agɨl, tɨkjakɨl bɨne yelak ak amɨl nɨgak, kɨli gos palawl yɨbɨl nɨŋɨd kɨnelak. ");
INSERT INTO taw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nɨŋɨd kɨlop agak, Taynen wɨsɨn kɨnebɨm? Tɨkjakɨm agak. Gos tɨmel apek tɨmel gɨnɨmɨb tek lup, anɨb ak tek God nop agɨlɨg mɨdenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas takaw anɨb ak agɨlɨg mɨdaknɨŋ, Judas ne bɨ kuŋay yɨbɨl kɨlop poŋɨd owak. Apɨl wulep sɨŋak apjakɨl, Jisas nop kaykol gɨnɨg apek ");
INSERT INTO taw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisas agak, Judas, Bɨ Olap Ñɨne nop dɨnɨmɨb agɨl, yɨp kaykol gɨnɨgeban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Anɨb agak nɨŋɨd, bɨne okok tap gɨnɨg gek anɨb ak nɨŋɨd anɨb agɨlak, Bɨawl, chɨn tu palkep dɨl kɨlop pak yuk yokun akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Anɨb agelak, bɨne olap tu palkep ak dɨl bɨ olap ke nop tɨmud yɨpɨd kɨd ak tɨbɨlɨk yokak. Bɨ anɨb ak nop, bɨ God nop sɨbogep bɨawl yɨbɨl ak bɨ wog gɨñeb ne ak. ");
INSERT INTO taw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jisas anɨb ak nɨŋɨd anɨb agak, Anɨb ma gɨnɨmɨb agak. Anɨb agɨl, bɨ anɨb nop tɨmud kɨd dɨnɨgek tepayaŋ suŋ lak. ");
INSERT INTO taw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pen bɨ God nop sɨbogep bɨawl ogɨnap, bɨ God agnɨgep kal awl polis bɨawl ogɨnap, Juda bɨawl ogɨnap, kɨli nop ap dɨnɨg gel kɨlop agak, Nɨbi tu palkep dɨl kul dɨl dad opɨm ak, yɨp bɨ penpen ñagep tek ak nɨŋɨd dɨnɨg opɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yad nɨbi ayɨp mɨnek mɨnek God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ mɨden, yɨp ma dɨpek agak. Pen mɨñɨl kɨsɨlɨm owup ñɨn nɨbi ak, bɨ kɨcheki yɨl mɨdebɨm ak nɨm yɨp anɨgebɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas anɨb agek kɨli nop dɨl, dad bɨ God nop sɨbogep bɨawl yɨbɨl kal ne ak amnɨlak. Pita pen kɨdek adaŋ saynsayn amɨl, ");
INSERT INTO taw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","mab dagɨl yelak kal tam ak wali mɨgan ayaŋ amɨl, binɨb ogɨnap ayɨp besɨg kus gɨ yelak. ");
INSERT INTO taw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mab mɨŋɨlaŋ gɨlɨg, bin kal anɨb ak wog gɨñeb olap Pita nop nɨg dad aplan apyaŋ gɨlɨg agak, Bɨ ak abe Jisas ayɨp mɨdebil agak. ");
INSERT INTO taw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Agek Pita agak, Mel. Bɨ anɨb ak yad ma nepin agak. ");
INSERT INTO taw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Anɨb agek, yokɨp sɨkol won ak mɨdaknɨŋ, bɨ olap ap nop nɨŋɨd anɨb agak, Nad abe bɨne olap mɨdeban agak. Agek Pita agak, Yad mel agak. ");
INSERT INTO taw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pen kɨdek won olap tapɨn mɨdɨl, bɨ olap pen takaw kɨles tɨmel yɨbɨl gɨl agak, Nɨŋɨd apin, bɨ ak Jisas ayɨp yek, ne abe Galili plopens nɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Agek Pita agak, Takaw apan ak yad ma nepin agak. Anɨb ag mɨdaknɨŋ, yawl kakaluk abe suk agak. ");
INSERT INTO taw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Agek, Jisas adɨkɨl Pita nop nɨŋɨjsek lak. Lek, Pita gos ak nɨgak, Jisas ned agak, Mɨñɨl sɨbmɨg ayaŋ yawl kakaluk suk ma agɨnɨgab won ak agɨnɨgaban, Jisas nop ma nepin agɨl takaw won omɨŋal nokom agɨnɨgaban agak. Takaw ak gos nɨgek, ");
INSERT INTO taw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","kuŋam mɨlep gek, seŋayaŋ amɨl chaŋ awl yɨbɨl lak. ");
INSERT INTO taw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Bɨ Jisas nop dɨ mɨdelak okok, chech bad ak dɨl wɨdɨn nop kab ñɨl, nop agjulɨg pakɨlɨg agɨlak, Nad bɨ ke nepan ak, nep an pakeb agɨlak? Chɨnop agñan agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Anɨgɨl, nop takaw tɨmel gak anɨb ak kuŋay yɨbɨl nep agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sub kɨdeyɨl lɨm gak won ak, bɨ Juda bɨawl takaw tɨg asɨkep okok mɨdupsek, bɨ God nop sɨbogep bɨawl okok ayɨp, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok ayɨp, kɨli takaw agɨnɨg apnan gɨlak. Apnan gɨl Jisas nop dad apɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nad Bɨ God nop aglup ak akaŋ agɨlak? Agel kɨlop pen agak, Yad nɨbop agenɨgayn, takaw yad ak ma dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pen yad nɨbop agnɨgenɨgayn, nɨbi yɨp pen ma agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pen mɨñɨl ñɨn awl tɨkɨl mɨd dad amɨl, Bɨ Olap Ñɨne am God bɨ kɨles tɨmel mɨdeb ak ñɨn yɨpɨd kɨd okok ken besɨg yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Anɨb agek bɨ okok mɨdupsek nop agɨlak, Nak ke God Ñɨne agɨlak? Agel agak, Nɨm nɨbi ke apɨm ak agak. ");
INSERT INTO taw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Agek agɨlak, Taynen am agnɨŋɨd ap agnɨŋɨd gɨpun agɨlak. Mɨñɨl ne ke agup chɨn nopun agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Juda bɨawl kɨli anɨb agɨl, mɨdupsek tɨkjakɨl Jisas nop dɨl dad amnɨlak, gapman bɨawl Paylat yek ak. ");
INSERT INTO taw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dad amɨl, takaw okok nɨb okok nɨb dad apɨl agɨlak, Chɨn ke pɨyowɨl nɨŋɨd nopun, bɨ anɨb ak binɨb chɨnop okok takaw yepɨs agup agɨlak. Agup, Gapman bɨnonɨm nop takis ma ñɨnɨmɨb agup agɨlak. Pen takaw olap agup agɨlak. Agup, Yad ke Juda bɨnonɨm ak mɨdɨl, God yɨp aglup agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Agelak, Paylat Jisas nop agnɨgak, Nak Juda bɨnonɨm kɨli ak akaŋ agak? Agek agak, Nɨm nak ke apan ak agak. ");
INSERT INTO taw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Agek, Paylat bɨ God nop sɨbogep bɨawl okok sek, binɨb yelak okok sek, kɨlop agak, Yad nepin, bɨ anɨb awl nop agep takaw jɨj ak ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Anɨb agek, kɨli pen takaw kɨles tɨmel gɨl agɨlak. Anɨb agɨlak, Ne agup, Nɨbi bɨ gapman takaw agup ak tɨbɨlɨkɨl agɨnɨmɨb agup agɨlak. Judiya binɨb mɨdupsek kɨlop anɨb agñub agɨlak. Galili plopens tɨkɨl agñɨ dap dap mɨñɨl awl owup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Agelak, Paylat nɨŋɨd kɨlop agnɨgak, Bɨ anɨb awl Galili nɨb agak? ");
INSERT INTO taw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Agek, Yaw agel, nɨŋɨd anɨb agak, Gapman bɨnonɨm Helod ne Galili plopens kod mɨdeb ak, ap Jelusalem awl mɨdeb tek, nop yɨl yokɨnɨm agak. Kɨlop agek, dad Helod yek ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helod ne Jisas tap golɨgup ak pel takaw anɨb ak nep nɨgolɨgup. Ñɨn akal tek tap olap ke gek nɨgɨnɨgayn agɨl gos ak nɨgɨlɨg mɨdolɨgup. Ñɨn anɨb ak Jisas nop dad apjakɨlak nɨŋɨd, ne mɨñmɨñ tɨmel yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pen Helod Jisas nop takaw kuŋay yɨbɨl agnɨgek, Jisas pen takaw olap ma agak. ");
INSERT INTO taw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pen bɨ God nop sɨbogep bɨawl okok sek, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, kɨli takaw awl yɨbɨl ak nɨŋɨjsek lɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pen Helod ayɨp bɨ chɨm kadɨŋ gep ne okok ayɨp Jisas nop gɨ tɨmel gɨlɨg, agjulɨg, chech tep yɨbɨl pal ak sɨj gɨñɨlak. Gɨñelak, bɨne okok kɨlop agek, dad tepayaŋ Paylat yek ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ned Helod ayɨp Paylat ayɨp keke yelɨgɨpil ak pen, anɨb ñɨn ak takaw nɨŋɨd bɨ omɨŋal jɨmñelek. ");
INSERT INTO taw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pen Paylat ne bɨ God nop sɨbogep bɨawl okok sek, bɨ lum nap nɨb okok sek, binɨb yokɨp okok sek, kɨlop agek apnan gel ");
INSERT INTO taw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","agak, Nɨbi bɨ anɨb ak dad apɨl yɨp apɨm, Bɨ nɨm ak binɨb okok kɨlop takaw yepɨs agup apɨm agak. Agup, Gapman nop kɨdek ma gɨnɨmɨb agup apɨm. Pen mɨñɨl wɨdɨn mɨdup adek nɨbop ke dapɨl agebin ak agak. Tap tɨmel ogɨnap gek takaw awl yɨbɨl ak nɨŋɨjsek lɨl apɨm ak, jɨj anɨb ak ma pɨyow nepin agak. ");
INSERT INTO taw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helod abe takaw jɨj anɨb ak ma pɨyow nɨŋɨd, jɨtep agyokek chɨnop ken dad opal agak. Bɨ anɨb awl tap tɨmel olap gek tek takaw nɨbop ak nɨŋɨd nop paklɨnɨgun agak. ");
INSERT INTO taw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Anɨb ak bɨyad okok nop yokɨp pakɨl agyokel amnaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Won anɨb ak kɨli mɨdupsek suk awl agɨl agɨlak, Bɨ anɨb ak paklɨl, Balabas nop agyokem chɨnop yɨl owaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bɨ Balabas anɨb ak, ned man awl nab ak binɨb ogɨnap dɨl, bɨ man awl kod yelɨgɨpal okok ayɨp penpen gɨl, bɨ olap nop pɨsnep paklak tek nop nag lɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pen Paylat gos ne ak Jisas amnaŋ agɨl nɨŋɨd, binɨb okok kɨlop tepayaŋ agak, Jisas nop yokɨp agyoken amnaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Agek, kɨli suk awl agɨl agɨlak, Mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ. Mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Agelak, Paylat tepayaŋ kɨlop agak, Taynen? Bɨ anɨb awl tap tay tɨmel gup agak? Yad nop nepin, tap ogɨnap gɨ tɨmel gek pakɨnɨgun tek ma lup agak. Anɨb ak, bɨyad okok nop yokɨp pakɨl agyokel amnaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Agek, kɨli takaw kɨles tɨmel yɨbɨl agɨlak, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨl, agel agel Paylat takaw nop tɨg jɨsɨpuk gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gelak, Paylat takaw kɨlop ak dɨl, ");
INSERT INTO taw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","bɨ tɨmel ned binɨb kuŋay dɨl penpen gɨl bɨ olap nop paklak ak nop kelɨgek amnaknɨŋ, anɨb agak, Tap Jisas nop gɨnɨg ak, nɨbi gɨm agak. ");
INSERT INTO taw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jisas nop paklɨnɨg dad amnɨlaknɨŋ, bɨ olap yɨb ne Saymon, taun Saylini nɨb ne Jelusalem owak. Nop nɨŋɨd dɨl, mab Jisas dad apek ak nop wajɨlem lɨñɨl agɨlak, Jisas ameb kɨdek amnoŋ agel, dad kɨdek amnak. ");
INSERT INTO taw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pen binɨb kuŋay yɨbɨl kɨdek gelak nab anɨb ak, bin ogɨnap Jisas nop mapen nɨŋɨd chaŋ awl ak lɨlɨg kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas adɨkɨl kɨlop agak, Nɨbi Jelusalem bin agak. Yɨp gɨnɨgeb ak chaŋ ma lɨnɨmɨb agak. Nɨbop gɨ tɨmel gɨl, ñɨpay nɨbop okok abe gɨ tɨmel gɨl gɨnɨgab ak chaŋ lɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kɨdek mɨŋel awl ak apek agɨnɨgabal, Bin ñapay wom ogɨnap sek, bin ñapay ma tɨkɨpal ogɨnap sek, bin ñapay tul ma ñɨbal ogɨnap sek, tep agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ñɨn anɨb ak taynen mɨdɨl kumnɨgun agɨl agɨnɨgabal, Nek dum alaŋ pagɨl apɨl chɨnop pak tɨbɨkɨpɨkop akaŋ, kojɨ dɨl chɨnop yu gɨpɨkop ak, tep agɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mab koŋɨm mɨdeb ak gɨ tɨmel ma gɨnɨgel tek ak pen, gɨ tɨmel gebal agak. Anɨb ak tek mab mɨlep wɨŋɨd amɨl mɨdeb ak tɨtay tek gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pen bɨ chɨm kadɨŋ gep okok, kɨli bɨ tap pedped gep omɨŋal ak kɨlop abe paklɨnɨg dad amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dad amɨl, man chɨp kɨmɨg cheg won apal ak, bɨ tap pedped gep omɨŋal ak, olap ñɨn yɨpɨd pɨs ak, olap ñɨn aŋɨd pɨs ak chɨpɨl pak tɨbɨk lɨl, Jisas nop nab ayaŋ pak tɨbɨk lɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas nop anɨgɨl pak tɨbɨk lel, ne God nop agɨl agak, Bapi. Yɨp tap anɨb gebal ak nɨgtep gɨl ma gebal agak. Anɨb ak tap si tap tɨmel gebal ak tɨg walɨg gɨyokɨnɨmɨn agak. Pen kɨli Jisas nop mab bak alaŋ pak tɨbɨk lɨl, chech nop tɨg asɨk dɨl, sadu tek gɨl keke dɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Binɨb kuŋay nep nɨg mɨdɨlaknɨŋ, Juda bɨawl okok Jisas nop paj agɨlak, Ne binɨb ogɨnap kɨlop dek mɨdtep gɨpal ak pen, ne Bɨ God nop aglup ak, binɨb okok kɨlop kod yenɨgab ak mɨdɨl nɨm, ne ke gɨl koŋɨm tɨkjakɨl amnaŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pen bɨ chɨm kadɨŋ gep okok abe nop agjulɨg wulep sɨŋak apɨl, ñɨg sɨlek ak ñɨlɨg ");
INSERT INTO taw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","agɨlak, Nad Juda bɨnonɨm kɨli mɨdɨl nɨm, nad ke gɨl koŋɨm amnoŋ agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pen mab bog bad olap, Jisas nop chɨpɨl pak tɨbɨk lɨlak ak mab bak alaŋ yɨb gɨlɨl agɨlak, Juda bɨnonɨm kɨli ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bɨ tap pedped gep omɨŋal ak, ñɨlop mab bak alaŋ pɨspɨs lɨlak ak, olap Jisas nop agjulɨg agak, Nad Bɨ God nop aglup ak akaŋ agak? Nad bɨawl mɨdɨl nɨm, nad ke gɨl koŋɨm tɨkjakɨl amɨl, chɨlop abe ge tɨkjakɨl amnul agak. ");
INSERT INTO taw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Agek, bɨ tap pedped gep olap pen nop ag gɨl agak, Ne yɨpɨl dɨl kumnɨgab tek, nad abe kumnɨgaban agak. Nad God nop ma pɨlɨkɨpan agak? ");
INSERT INTO taw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Chɨl tap pedped gɨpul tek, yɨpɨl dɨpul agak. Ne pen tap olap ma gup yokɨp nep yɨpɨl dup agak. ");
INSERT INTO taw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Anɨb agɨl Jisas nop agak, Jisas, kɨdek nad bɨawl yɨbɨl mɨdɨl, binɨb nad kɨlop dɨnɨgaban ñɨn ak, yɨp gos nɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Anɨb agek Jisas agak, Yad nep nɨŋɨd yɨbɨl agebin agak. Mɨñɨl ñɨn awl, yad ayɨp am God man ne alaŋ yonɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ñɨn anɨb ak subnab won ak sub kɨlup apɨl, mɨd dad amɨl sub yɨpɨd gak won ak tep ak pen mɨlek gak. Pen God agnɨgep kal awl ñɨluk mɨgan ayaŋ chech kanɨbtub pɨl gɨlak ak, nab ak talɨkɨl pɨspɨs amnak. ");
INSERT INTO taw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pen Jisas suk agɨl agak, Bapi. Kawnan yad ak mɨñɨl nep lɨñebin agak. Anɨb agɨl kumak. ");
INSERT INTO taw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Anɨgek, bɨ chɨm kadɨŋ gep bɨawl ak, ne Jisas agɨl kumak anɨb ak nɨŋɨd, God yɨb nop ak dad aplanɨlɨg agak, Nɨŋɨd apal, bɨ teplep yɨbɨl ak agak. ");
INSERT INTO taw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Binɨb nɨgɨnɨg ap yelak okok tap anɨb ak gak nɨŋɨd, kɨlop mapen yɨbɨl gaknɨŋ pabɨl pakɨlɨg adɨkɨd kal kɨli amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pen Jisas bɨne okok sek, bin Galili nɨb Jisas ne owaknɨŋ kɨdek owlak okok sek, kɨli keke sɨŋadaŋ mɨdɨl, tap anɨb ak gaknɨŋ nɨg mɨdelak. ");
INSERT INTO taw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pen bɨ olap man sɨkol Alimateya nɨb owak, yɨb ne ak Josep. Ne Juda bɨawl takaw tɨg asɨkep olap, God takaw dɨtep yɨbɨl golɨgup. Ne Juda bɨawl takaw tɨg asɨkep ogɨnap Jisas nop paklun agɨl gos nɨgɨlak tek ma nɨgak. God binɨb dɨl kɨlop kod yenɨgab ñɨn ak kod yek. ");
INSERT INTO taw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ne Jisas nop dam kamnɨg Paylat yek ak am agnɨgak. Paylat Yaw agek, ");
INSERT INTO taw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","am Jisas nop tɨg asɨk, dad apɨl chech bad ak dɨ kam sɨlokɨl, dam chɨp kaw ak kab mɨgan tɨdamɨgɨl kɨdeyɨl dɨlɨl chɨp ma kamɨlak mɨgan ak kamak. ");
INSERT INTO taw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Anɨb ñɨn ak tap dap nan gep ñɨn ak. Juda añɨŋ lep ñɨn awl ak ownɨg gak. ");
INSERT INTO taw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pen bin tun Jisas ayɨp Galili nɨb owlak okok, kɨli Josep amnaknɨŋ kɨdek amɨl, Jisas nop kamak tep ak nɨgtep gɨl, ");
INSERT INTO taw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","adɨkɨd kal kɨli amnɨlak. Amɨl, ñɨg kuy tep owep ogɨnap Jisas mubwak nop ak wikɨnɨgun agɨl, gɨlɨtep gɨlak. Mɨnek anɨb anep dad abɨlap ak pen Juda añɨŋ lep ñɨn awl ak, ñɨn kɨli ak God bɨlel anɨb agak, Yokɨp mɨdep ñɨn ak agak. Nɨŋɨd nɨm, yokɨp mɨd mɨd kɨnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mɨnek Sande man tɨkak won ak, bin tun Jisas ayɨp Galili nɨb owlak okok, kɨli ñɨg kuy tep owep ak gɨlɨtep gɨlak ak dɨl, dad Jisas nop kamɨlak ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amɨl nɨgɨlak, kab kolɨm awl chɨp kaw tub mɨgan ak pɨl gɨlak ak, mɨmlokɨd am ke okok yek. ");
INSERT INTO taw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pen kɨli mɨgan anɨb ak amɨl nɨgɨlak, Bɨawl Jisas nop dɨ kamɨlak kaw mɨgan ayaŋ ma yek. ");
INSERT INTO taw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tɨtay dup agɨl, gos pal yɨbɨl lɨlɨg nɨg yelaknɨŋ, bɨ omɨŋal chech kayɨg ñɨñakol gak ak yɨmɨlek okok, kɨli gol sɨŋak jakɨl mɨdelek. ");
INSERT INTO taw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kɨli nɨŋɨd, jel ag pɨlɨkɨl kɨgom yɨmɨl wɨdɨn kɨli lum okyaŋ nɨgɨlaknɨŋ, bɨ omɨŋal anɨb ak agɨlek, Taynen bɨ koŋɨm mɨdeb ak nop chɨp kabal nab anɨb okok pɨyow nɨgebɨm agɨlek? ");
INSERT INTO taw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ne awl ma mɨdeb. Mɨneyɨl tɨkjakup agɨlek. Pen Galili plopens mɨdɨl nɨbop takaw agak ak gos nɨgɨnɨmɨb agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nɨbop agak, Kɨli Bɨ Olap Ñɨne nop chen mɨmug gɨ dapɨl, binɨb tap si tap tɨmel gɨpal ak kɨlop yokel, nop mab bak alaŋ chɨpɨl pak tɨbɨk lel kumnɨmuŋ agak agɨlek. Ñɨn omɨŋal nokom mɨdɨl, tɨkjakɨnɨgab agak agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Anɨb agɨlek nɨŋɨd, gos kɨlop ak pag yɨkek, Jisas ned Galili mɨdɨl takaw agak anɨb ak nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Nɨŋɨd, tep adɨkɨd apɨl, tap gek nɨgɨlak anɨb ak, Jisas bɨ takaw nop dad ameb anep agɨp ak sek, binɨb ne yokɨp ogɨnap sek, kɨlop agñɨlak. Bin tun takaw agñɨlak anɨb ak, Maliya taun Makdala nɨb abe, Jowana abe, Jemis nonɨm ne Maliya abe, bin yokɨp ogɨnap sek. ");
INSERT INTO taw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pen kɨli anɨgɨl agñelak nɨŋɨd, takaw kɨlop ak ma nɨgɨlak. Kɨli tay yepɨs agebal agɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pita pen takaw anɨb ak nɨŋɨd, kasek yɨbɨl adaŋ amɨl kamɨlak kab mɨgan ak sɨpsɨp nɨgak, chech nop kam sɨlokɨlak bad okok nep yek. Nɨŋɨd, tɨtay dup agɨl gos pal yɨbɨl lɨlɨg nɨŋɨd, tep adɨkɨd amnak. ");
INSERT INTO taw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ñɨn anɨb ak bɨ omɨŋal Jelusalem kelɨgɨl, man sɨkol Emeyus wulep sɨŋak yek amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amɨlɨg, tap tɨtay dak okok takaw ak kɨmɨgel agɨlɨg amnɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Agɨlɨg amnɨlek nɨŋɨd, Jisas kud okok apɨl kɨli ayɨp amnak. ");
INSERT INTO taw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bɨ omɨŋal ak Jisas nop nepɨlep ak pen, God gos kɨlop ak gek Jisas nop nɨgel bɨ ak ke tek lak. ");
INSERT INTO taw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne kɨlop agnɨŋɨd agak, Ñɨli tɨtay agɨlɨg amebil agak? Anɨb agek kɨlop mapen gek jakɨl yelek, ");
INSERT INTO taw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","bɨ olap yɨb ne Kliyopas ne agak, Nad nokom ma nepan akaŋ agak? Mɨñɨl ñɨn awl Jelusalem tap geb ak, nad ma nepan akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Agek agak, Tap anɨb ak tay agak? Agek agɨlek, Bɨ God gos ñek agñeb Jisas Nasalet nɨb ak, takaw agtep gɨlɨg gos tep tɨpagɨl nɨŋɨd, tap koŋɨm nɨb ogɨnap gɨlɨg gek agɨlek. God nop tep gɨl, binɨb okok kɨlop tep gɨl gak agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Anɨgek, gos chɨn nɨŋɨd agɨnok, ne apɨl chɨnop Yislel binɨb dɨl kod mɨdtep gɨnɨgab agɨl nɨgɨnok ak pen, bɨ God nop sɨbogep bɨawl okok sek, bɨnonɨm okok sek, kɨli takaw ag nan gɨlak. Takaw ag nan gɨl nop dɨñel, bɨ kɨli ogɨnap dam mab bak alaŋ chɨpɨl pak tɨbɨk lel kumak agɨlek. Tap anɨb ak mɨyadil gak agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mɨñɨl pen tawn won ak, bin chɨn ogɨnap nop kamɨlak kaw tub ak nɨgɨnɨg amɨl, apɨl chɨnop tap tɨtay gup ak agñel nɨŋɨd ju dɨpun agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kɨli apal, Chɨp ak ma yek apal agɨlek. Ensel omɨŋal ak apɨl anɨb apil, Ne tɨkjakɨl koŋɨm mɨdeb apil apal agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Anɨb agel, bɨ chɨn ogɨnap kaw tub amɨl nepal, bin okok apal tek nep yek agɨlek. Pen Jisas nop ma nepal agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Anɨb agel Jisas agak, Ñɨli gos tep ma nepil agak. Bɨ God gos ñek agñeb okok, kɨli bɨlel agɨl tɨkɨlak ak, taynen nɨŋɨd agɨlak agɨl kasek ma nepil agak? ");
INSERT INTO taw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","God takaw ak agak tek, Bɨ God nop aglup ak, ne ned yɨpɨl awl dɨl kumnɨmuŋ nɨm, kɨdek bɨawl teplep yɨbɨl kɨles tɨmel ak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Anɨb agɨl, kɨlop bɨ omɨŋal takaw nop mɨdupsek agñɨ tep gak. Mosis ne takaw nop tɨkak ak sek, bɨ God gos ñek agñeb okok mɨdupsek takaw nop tɨkɨlak ak sek, takaw mɨdupsek agñɨ tep gak. ");
INSERT INTO taw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pen bɨ omɨŋal anɨb ak man wulep amelek anɨb sɨŋak amjakɨl, Jisas kɨlop kelɨgɨl ne ned amnɨg tek gek, ");
INSERT INTO taw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","kɨli nop takaw kɨles gɨl agɨlek, Dugep day won ak apobun agɨlek. Sɨb gɨnɨgeb nen, ape chɨl ayɨp mɨdon agɨlek. Agel, kɨli bɨ omɨŋal ayɨp amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kal am mɨdɨl, tap ñɨŋɨnɨg besɨgel, ne tap mɨdup ak dɨl, God nop tep agɨl, tɨpagɨl, kɨlop bɨ omɨŋal ñak. ");
INSERT INTO taw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ñak nɨŋɨd, gos kɨlop ak pag yɨkek, ak Jisas nep agɨl nɨgɨlek nɨŋɨd, kɨmɨgel kul gak. ");
INSERT INTO taw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Anɨgek nɨŋɨd anɨb agɨlek, Kanɨb nab okok apɨlɨg, takaw ogɨnap agñɨlɨg, God takaw tɨkɨlak takaw jɨj ak abe agñɨlɨg gek, mapen chɨl ak tɨkjakup agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Anɨb agɨl, won anɨb ak nep tep adɨkɨd Jelusalem amɨl nɨgɨlek, bɨ Jisas takaw nop dad ameb anep agɨp ak sek, binɨb kɨli ogɨnap sek apnan gɨl mɨdelak. ");
INSERT INTO taw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Amjakɨlek nɨŋɨd, kɨlop bɨ omɨŋal agɨlak, Nɨŋɨd apun agɨlak. Bɨawl ak kumub ak pen, jɨtep ak tɨkjakɨl, Saymon yek sɨŋak apek nɨgup agɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Agel kɨli pen agɨlek, Chɨl abe kanɨb nab okok amol, ne chɨlop nebeŋ pakek kal chɨl ak ayɨp amnɨnok agɨlek. Tap ñɨŋɨnɨg gɨl, ne tap mɨdup ak dɨl God nop tep agek, ak Jisas nep agɨl nopul agɨlek. ");
INSERT INTO taw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Takaw anɨb ak agɨlek nɨŋɨd, Jisas nab anɨb sɨŋak mɨseŋ lɨl agak, Nɨbi mɨdtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Agek, kɨli chɨp kawnan agɨl pɨlɨkelak ");
INSERT INTO taw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","kɨlop agak, Taynen yɨp Jisas agɨl ma nɨŋɨd, gos kuŋay nɨgebɨm agak? ");
INSERT INTO taw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Anɨb ak ñɨn tob yɨp okok nɨgɨm agak. Yad ke mɨdebin agak. Chɨp kawnan agɨl nepɨm ak yɨp dɨnɨgɨm agak. Yad yɨpɨl tɨŋɨl sek mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Anɨb agɨlɨg, ñɨn tob ne okok kɨlop yomek nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","kɨli mɨñmɨñ gɨlɨg gos pal lɨlɨg, Jisas nep agɨl gos tam sek nɨgelak kɨlop agak, Nɨbi tap mɨdup ogɨnap mɨdeb akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Agek nop kubsal dap agɨl lak pɨs kɨd ak ñɨl, ");
INSERT INTO taw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nɨg mɨdɨlak nɨŋɨd ñɨŋak. ");
INSERT INTO taw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pen ne kɨlop agak, Ned nɨb ayɨp mɨdɨl, nɨbop agñelɨgɨpin, Bɨlel tap okok mɨdupsek yɨp kɨl tɨkɨlak ak, yɨp anɨgɨnɨmuŋ agɨl agñelɨgɨpin agak. Takaw Mosis ñu kɨl tɨkak ak, bɨ God gos ñek agñeb takaw kɨli ak abe, Buk Kɨmep takaw ak abe, tap okok mɨdupsek yɨp anɨgɨnɨmuŋ agɨl agñelɨgɨpin agak. ");
INSERT INTO taw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Anɨb agɨl, yad gen kɨli God takaw bɨlel ak nɨgtep gɨlaŋ agɨl, gos teplep yɨbɨl ak ñɨlɨg ");
INSERT INTO taw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","kɨlop anɨb agak, Takaw anɨb ak bɨlel kɨl tɨkɨl agɨlak, Bɨ God nop aglup ak, yɨpɨl awl dɨl kumɨl ñɨn omɨŋal nokom mɨdɨl tepayaŋ tɨkjakɨnɨgab agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tɨkjakek, bɨne yɨb ne ak dɨl, kɨli Jelusalem jɨj gɨl, takaw agñɨl ag dad amɨl, takaw anɨb ak binɨb okok mɨdupsek kɨlop agñɨnɨgel agɨlak. Anɨb agñɨnɨgel, Nɨbi tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgem, God tap tɨmel nɨbop tɨg walɨg gɨyokɨnɨgab agñɨnɨgel agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nɨbi ke tap gak anɨb okok nepɨm, takaw ak mɨdupsek agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pen Bapi ned aglak tek, yad tap anɨb ak agyoken nɨbop ownɨgab agak. Jelusalem awl nep mɨdɨl kod mɨdem, God kɨles ne ak alaŋ nɨb apɨl, nɨbop goŋ lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Anɨb agɨl, kɨlop poŋɨd man sɨkol Betani amɨl, ñɨn dad aplanɨlɨg agak, Bapi, nad ge mɨdtep gɨlaŋ agak. ");
INSERT INTO taw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","God nop anɨgɨl agnɨgaknɨŋ, God nop dad man ne alaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kɨli nɨŋɨd, kɨgom yɨm gɨlɨg yɨb nop ak dad aplanɨl, mɨñmɨñ tɨmel yɨbɨl gɨlɨg adɨkɨd Jelusalem amnɨlak. ");
INSERT INTO taw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amɨl, mɨnek mɨnek God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ am mɨdɨl, God nop tep agelɨgɨpal.");
INSERT INTO taw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1"," Bɨlel bɨlel, man ma alwol gɨlak ñɨn ak, Takaw ak yolɨgup. Takaw anɨb ak ne God ayɨp yolɨgup, pen ne ke God yek. ");
INSERT INTO taw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bɨlel bɨlel Takaw ak ne God ayɨp yolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God gek, Takaw ak ne nokom tap okok mɨdupsek gɨlak. Tap olap ke ma yek, Takaw ak ne ke gɨlak okok nep yek. ");
INSERT INTO taw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Takaw anɨb ak ne kɨm mɨdep jɨj ak nɨm, kɨm mɨdep ne ak, binɨb okok kɨlop mɨlek ñub. ");
INSERT INTO taw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mɨlek ne anɨb ak, kɨsɨlɨm owup nab okok apek, tɨg sug mel nɨŋɨd kelɨgup. ");
INSERT INTO taw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pen God bɨ olap nop agyokek owak. Yɨb ne Jon, ne Bɨ Ñɨg Pakñeb ak. ");
INSERT INTO taw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bɨ anɨb ak takaw agñɨnɨg owak. Ne mɨlek takaw ak agñek, binɨb okok mɨdupsek takaw nop nɨŋɨd gos lɨnɨgɨnɨgel. ");
INSERT INTO taw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon ne ke mɨlek anɨb ak mel. Ne pen mɨlek takaw ak agñɨnɨg owak. ");
INSERT INTO taw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɨlek anɨb ak nɨm, mɨlek nɨŋɨd yɨbɨl mɨdeb. Ne lum awl apek, mɨlek ne ak binɨb okok mɨdupsek kɨlop amub. ");
INSERT INTO taw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ne lum awl ak yolɨgup. Bɨlel God gek, ne lum awl gɨlak ak pen, binɨb lum awl okok kɨli nop bɨ tay tek agɨl ma nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Man ne ke ak owak ak pen, binɨb ne ak, kɨli nop ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pen binɨb nop dɨl, nop nokom gos lɨnɨgɨlak okok nep, kɨlop gek God ñapay ne yelak. ");
INSERT INTO taw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Binɨb kɨli ke ñapay tɨkel, God ñapay ne tek ma yelak. Bɨ bel okok dɨ gɨl ñapay tɨkel, God ñapay ne tek ma yelak. Pen binɨb ogɨnap wak tɨkjakek, dɨ gɨl ñapay tɨkel, God ñapay ne tek ma yelak. God ne ke gek ñapay ne yelak. ");
INSERT INTO taw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pen Takaw anɨb ak, bɨ sɨlokɨl apɨl, chɨn ayɨp yolɨgup. Anɨb ak nop nɨgɨnok, ne kɨles mɨdɨl Bɨawl teplep yɨbɨl yek tek ak yek. Ne God Ñɨne nokom yɨbɨl ak nɨm, Bapi God gek ne ke kɨles mɨdɨl bɨawl teplep yɨbɨl yek ak owak. Pen ne bɨ yɨmug nɨŋɨd gɨtep gep yek, bɨ takaw nɨŋɨd yɨbɨl agep yek. ");
INSERT INTO taw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pen bɨ anɨb ak takaw ak, Jon binɨb okok kɨlop agñak. Kɨles gɨl agñɨl agak, Bɨ anɨb nep nɨm, nɨbop ned agɨnek agak. Anɨgɨl agɨnek, Yad opin bɨ kɨdek ownɨgab ak, bɨlel yɨbɨl yolɨgup ak kɨdek ami yɨp tɨkak agɨnek agak. Anɨb ak ne bɨawl yɨbɨl mɨdeb, yad bɨ yokɨp agɨnek agak. ");
INSERT INTO taw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bɨ anɨb ak yɨmug nɨŋɨd gɨtep yɨbɨl gep tek. Chɨnop mɨdupsek yɨmug nɨŋɨd gɨtep gup anɨb ak nɨm, pelpel keke ñub. ");
INSERT INTO taw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nɨŋɨd yɨbɨl agup. Takaw Mosis ñu kɨl tɨkak ak, God ne Mosis nop ñek chɨnop agñak ak pen, Jisas Klays ne apɨl chɨnop yomek, God chɨnop yɨmug nɨŋɨd gɨtep gɨl, takaw nɨŋɨd yɨbɨl agɨl gak ak, mɨseŋ nɨgɨnok. ");
INSERT INTO taw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Binɨb olap God nop ma nɨgak. Pen God Ñɨne nokom yɨbɨl ak nɨm, ne ke God yek, Nap wulep sɨŋak yek. Wulep sɨŋak mɨdɨl, ne ke gek, God bɨ tay tek mɨdeb agɨl nɨgɨnok. ");
INSERT INTO taw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda bɨawl okok, kɨli bɨ God nop sɨbogep ogɨnap, bɨ Lipay jɨj ak ogɨnap kɨlop agyokɨlak. Anɨgɨl agyokel, Jelusalem kelɨgɨl Jon yek ak amjakɨl, nop agnɨŋɨd agɨlak, Nad bɨ an agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Anɨgɨl agnɨgelak, ne pen ag we gɨl mel, kɨlop mɨseŋ agɨl agak, Yad Klays, Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak mel agak. ");
INSERT INTO taw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Anɨb agek agɨlak, Anɨb apan ak, nad an agɨlak? Nad Yilayja akaŋ agɨlak? Agel agak, Yad mel agak. Anɨb agek agɨlak, Nad bɨ God gos ñek agñeb pel kod mɨdobun ak akaŋ agɨlak? Agel ne pen agak, Mel agak. ");
INSERT INTO taw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Anɨb agek, bɨ anɨb okok nop agɨlak, Anɨb ak nad an agɨlak? Pen yad bɨ tay agɨl agenɨmɨn, chɨn am bɨawl chɨnop agyokɨpal okok kɨlop agñɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Agel, Jon kɨlop agak, Bɨ God gos ñek agñeb Aysaya, ne bɨlel tɨkɨl agak, Bɨ olap man nep binɨb ma mɨdebal nab okok suk awl agɨl agɨnɨgab, Bɨawl ak kanɨb nop pɨd yɨpɨd gɨnɨmɨb agɨnɨgab agɨl tɨkak agak. Bɨ anɨb ak, yad nokom agak. ");
INSERT INTO taw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pen bɨ owlak anɨb okok, ogɨnap bɨ Pelisi kay yelak. ");
INSERT INTO taw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kɨli Jon nop apɨl agɨlak, Nad apan, Yad Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak mel, Yilayja mel, bɨ God gos ñek agñeb pel kod mɨdobun ak mel apan agɨlak. Anɨb ak pen, taynen binɨb okok kɨlop ñɨg pakñeban agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Agelak pen agak, Yad kɨlop ñɨg pakñebin agak. Pen bɨ olap nab nɨbop awl mɨdeb, nop bɨ tay tek agɨl ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yad opin bɨ kɨdek ownɨgab ak, bɨ anɨb ak agebin agak. Nop nɨgen yɨp nebeŋ gup, tob tɨlup nop ak nag wɨsɨkɨnɨm tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tap anɨb ak, Jon man sɨkol Betani, ñɨg Jodan gol pɨs kɨd adaŋ yɨl ak gak. Man awl yɨl ak, Jon binɨb okok kɨlop ñɨg pakñolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mɨnek Jisas Jon yɨl owaknɨŋ, nop nɨŋɨd anɨb agak, Nɨgɨm, God Chag Sipsip Ñɨluk ne ak nɨm awl agak. Ne nɨm, binɨb lum awl mɨdupsek tap si tap tɨmel gɨpal okok tɨg walɨg gɨyokɨnɨg owup agak. ");
INSERT INTO taw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Bɨ anɨb awl nɨm, ned anɨgɨl agɨnek, Yad opin bɨ kɨdek ownɨgab ak, bɨlel yɨbɨl yolɨgup ak kɨdek ami yɨp tɨkak agɨnek agak. Anɨb ak ne bɨawl yɨbɨl mɨdeb, yad bɨ yokɨp agɨnek agak. ");
INSERT INTO taw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ne bɨ an mɨdeb agɨl ma nɨgɨnek agak. Yad pen Yislel binɨb kɨli nop mɨseŋ nɨgɨnɨgel agɨl, apɨl binɨb okok kɨlop ñɨg pakñɨbin agak. ");
INSERT INTO taw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pen Jon takaw adek ak agñɨl agak, God Kawnan ne ak man ne alaŋ kelɨgɨl, yawl gɨpkay tek apɨl bɨ anɨb anop lup agak. ");
INSERT INTO taw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne bɨ an mɨdeb agɨl ma nepɨnep agak. God pen yɨp agyokek binɨb ñɨg pakñɨnɨg ownek ak, ne yɨp agup, Nad nɨgɨnɨgaban, Kawnan yad ak ayaŋ apɨl bɨ olap nop lɨnɨgab agup agak. Bɨ anɨb ak, ne Kawnan yad ak kɨlop pakñɨnɨgab agup agak. ");
INSERT INTO taw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tap anɨb okok wɨdɨn nɨŋɨd, nɨgtep gɨl anɨgɨl agñebin, Bɨ anɨb nep God Ñɨne mɨdeb agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mɨnek pen, Jon tepayaŋ jak mɨdɨl, bɨne omɨŋal ak ayɨp yelak. ");
INSERT INTO taw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jak yelaknɨŋ, Jisas apɨl padɨkek Jon nɨŋɨd anɨb agak, Nɨgil, God Chag Sipsip Ñɨluk ne ak nɨm awl agak. ");
INSERT INTO taw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anɨb agek, Jon bɨne omɨŋal ak takaw anɨb ak nɨŋɨd, Jon nop kelɨgɨl, Jisas nop kɨdek amnɨlek. ");
INSERT INTO taw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pen Jisas adɨkɨl kɨlopmɨŋal nɨŋɨd anɨb agak, Taynen apebil agak? Agek agɨlek, Lapay, nad kɨnɨban akal agɨlek? Yɨb Lapay nɨm ak, chɨn Tisa apun. ");
INSERT INTO taw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pen anɨgɨl agnɨgel, Jisas agak, Anɨb ak yad ayɨp amɨl nɨgɨnɨgayl agak. Agek, ñɨn anɨb ak dugep won ak amɨl, kal kɨnub anɨb ak nɨŋɨd ne ayɨp yelak. ");
INSERT INTO taw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon bɨne omɨŋal anɨb ak, takaw nop nɨŋɨd Jisas nop kɨdek gɨlek ak, bɨ olap yɨb ne Edlu. Edlu nɨmam ne nɨm, Saymon Pita. ");
INSERT INTO taw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Edlu ne Jisas nop kelɨgɨl, won anɨb anep am nɨmam Saymon nop pɨyow nɨŋɨd agak, Mesaya nop mɨñɨl nopun agak. Yɨb Mesaya nɨm ak, jɨj anɨgɨl mɨdeb, Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak. ");
INSERT INTO taw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Edlu anɨb agɨl, nɨmam Saymon nop poŋɨd Jisas yek ak amnak. Amek, Jisas Saymon nop nɨŋɨd anɨb agak, Nad Saymon, Jon ñɨne agak. Yɨb nep Sipas agɨnɨgabal agak. Yɨb Sipas agak anɨb ak, Pita yɨb ak alog mɨdeb. Yɨb anɨb omɨŋal jɨj ak, kab. ");
INSERT INTO taw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mɨnek Jisas Galili plopens amnɨg, am Pilip nop pɨyow nɨŋɨd agak, Nad yɨp kɨdek gan agak. ");
INSERT INTO taw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pen Pilip taun Betsayda nɨb, Edlu ayɨp Pita ayɨp man kɨli nɨm ak. ");
INSERT INTO taw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pen Pilip am Nataniyel nop pɨyow nɨŋɨd agak, Chɨn bɨ sɨŋak, takaw Mosis ñu kɨl tɨkak ak sek, bɨ God gos ñek agñeb okok agɨl tɨkak sek anop, mɨñɨl nopun agak. Jisas Josep ñɨne, man awl Nasalet nɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pilip anɨb agek, Nataniyel agak, Tap tep olap taun Nasalet nɨb owup tek lup akaŋ agak? Mel yɨbɨl agak. Agek Pilip agak, Apɨl nɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Anɨb agɨl, wulep wulep gɨleknɨŋ, Jisas Nataniyel nop nɨŋɨd anɨb agak, Nɨgɨm, bɨ anɨb ak, bɨ Yislel yɨpɨd gɨl mɨdeb agak. Ne takaw yepɨs ma agup, takaw yɨpɨd gɨl adek ak nep gup agak. ");
INSERT INTO taw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Anɨb agek Nataniyel agak, Yɨp taydɨl nepan agak? Agek Jisas pen agak, Pilip nep suk ma agak won ak nep nepin, besɨg yesɨpan mab pik jɨj sɨŋak agak. ");
INSERT INTO taw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Anɨb agek Nataniyel agak, Tisa, nad God Ñɨne, Yislel binɨb bɨnonɨm mɨdeban agak. ");
INSERT INTO taw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Anɨb agek Jisas pen agak, Nep mab pik jɨj sɨŋak nepin agen, yokɨp takaw won ak apin ak nɨŋɨd yɨp gos lɨnepan agak. Kɨdek tap awl yɨbɨl ogɨnap gen nɨgɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nɨbop nɨŋɨd yɨbɨl agebin agak. God man ne alaŋ mɨgan yɨkɨnɨgab ak nɨgɨnɨgabɨm agak. Yɨkɨl, God ensel ne okok Bɨ Olap Ñɨne nop nɨgɨnɨg aplan apyap gɨnɨgabal ak nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ñɨn omɨŋal mɨdɨl, bɨ bel olap dɨnɨg gel, binɨb suk agel amɨl tap ñɨŋɨlak, taun Kena Galili plopens nab okok. Ñɨn anɨb ak, Jisas nonɨm amɨl kal anɨb ak yek. ");
INSERT INTO taw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pen Jisas sek, bɨne okok sek kɨlop abe suk agelak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pen ñɨg wayn ak ñɨbdelak, nonɨm ne Jisas nop agak, Ñɨg wayn ak ñɨbdɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Anɨb agek agak, Ami, tap anɨb ak tap nad ak, tap yad mel agak. Ñɨn yad ak ma owup agak. ");
INSERT INTO taw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Agek, nonɨm ne bɨ wog gɨñeb ogɨnap kɨlop agak, Takaw olap agonɨmuŋ, agɨnɨmuŋ tek nep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pen binɨb kab dɨl, ñɨg kab julɨkɨlak awl yɨbɨl anep kagol ak dɨlel yek. Kab anɨb ak nokom nokom 100 lita tek yolɨgup. Juda binɨb okok kɨli chɨn gɨtep gɨl, God nɨgek suŋtep mɨdon agɨl, ñɨg anɨb ak dɨl, ñɨn mɨdup lelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas pen, bɨ wog gɨñeb okok kɨlop agak, Kab anɨb okok ñɨg mal dad apɨl sogɨnɨmɨb agak. Agek, agak tek gel aplan jakɨl yek. ");
INSERT INTO taw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Anɨgelak agak, Mɨñɨl ñɨg mal dap lɨpɨm ak ogɨnap pag dad amɨl, bɨ tap ñɨbobun awl kod mɨdeb anop ñɨnɨmɨb agak. Agek, ñɨg anɨb ak pag dam bɨawl anop ñɨlak. ");
INSERT INTO taw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ñelak, ne ñɨbɨl nɨgak, ñɨg wayn ak yek. Ne ñɨg wayn anɨb ak akal nɨb agɨl ma nɨgak ak pen, bɨ wog gɨñeb ñɨg mal dad opal okok kɨli nep nɨgɨlak, Jisas ne ñɨg gek ñɨg wayn ak yek. Pen bɨ tap ñɨbebal awl kod mɨdeb ak, ne ma nɨgak tek nɨm, bɨ bin dɨnɨg gek anɨb anop suk agek apek ");
INSERT INTO taw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nop agak, Bɨ okok mɨdupsek, pelpel ñɨg wayn tep ak kuŋay yɨbɨl ned dap ñɨbal agak. Ñel ñɨbdel nɨm, ñɨg wayn tep ma gup ak kɨdek ñel ñɨbal agak. Nad pen, ñɨg wayn tep ak dɨle mɨdɨl, mɨñɨl nep dap ñeban agak. ");
INSERT INTO taw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Pen Jisas tap mageptek anɨb ak jɨj gɨl gak, taun Kena, Galili plopens gak. Anɨgek, ne bɨawl yɨbɨl kɨles yɨbɨl yek ak mɨseŋ nɨgep tek lek, bɨne okok nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pen Jisas tap anɨb ak gɨjuwɨl, man ak kelɨgɨl, taun Kapeneyam ayaŋ amnak. Nonɨm ayɨp, nɨmam ayɨp, bɨne okok ayɨp amnɨlak. Amɨl, yep ñɨn kab olap anɨb ak yelak. ");
INSERT INTO taw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda ñɨn awl kɨli Pasopa apal ak wulep owaknɨŋ, Jisas Jelusalem alaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Amɨl nɨgak, binɨb okok God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ mɨdɨl, kɨli ogɨnap chag bulmakaw, chag sipsip, yawl tap okok dap mani dɨlɨg, ogɨnap besɨgɨl mani penpen ñɨlɨg delak. ");
INSERT INTO taw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisas nɨŋɨd, nag kɨles olap dɨl, binɨb okok ayɨp chag bulmakaw chag sipsip okok ayɨp, kɨlop God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak pak yuk seŋayaŋ yokak. Yuk yokɨl, mani dap penpen ñɨlɨg delak bog bad okok mani sek tɨg adɨkak. ");
INSERT INTO taw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tɨg adɨkɨl, binɨb yawl dap mani delak okok kɨlop agak, Tap anɨb okok dad seŋayaŋ amnɨmɨb agak. Bapi kal nop ak gem, mani dep kal tek ma lɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ne anɨgek, bɨne okok gos kɨli amnak, buk Baybol takaw tɨkɨlak adek ak. Takaw anɨb ak tɨkɨl agak, Kal nad ak gos nokom nepin tek, kal anɨb ak gen mɨdtep gaŋ agɨl nep gɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pen Juda bɨawl ogɨnap Jisas nop agnɨŋɨd agɨlak, Nep an agek ap anɨgɨpan agɨlak? Tap mageptek olap ge nɨŋɨd, nɨŋɨd gɨpan agɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Anɨb agel Jisas kɨlop pen agak, God agnɨgep kal awl ak tɨbɨlɨkem, ñɨn omɨŋal nokom mɨdɨl tepayaŋ gɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Anɨb agek agɨlak, Ake. God agnɨgep kal awl anɨb ak, sub anep 46 gɨ dɨlak. Ak pen, nad ñɨn omɨŋal nokom nep gɨnɨmɨn tek mɨdeb akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas pen God agnɨgep kal awl takaw agak anɨb ak, mubwak ne ke agak. ");
INSERT INTO taw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Anɨb ak nɨm, kɨdek ne kumɨl tɨkjakek, bɨne okok gos kɨli amnak, takaw anɨb ak ne ned agak. Gos anɨb nɨŋɨd, buk Baybol takaw nop agɨl tɨkɨlak ak sek, Jisas ne takaw agak anɨb ak sek gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas ne Juda ñɨn awl kɨli Pasopa apal anɨb ak, Jelusalem mɨdɨl, tap mageptek ogɨnap gak. Anɨgek, binɨb okok nɨŋɨd, kuŋay nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jisas pen binɨb mɨdupsek gos nab kɨlop ayaŋ ke nɨgtep gup tek, kɨlop ma gos nɨŋɨd, binɨb yad yɨpɨd gɨl agɨl ma nɨgak. ");
INSERT INTO taw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Binɨb anɨb okok gos kɨli adek akal amnak ak, nɨgtep gak ak nɨm, bɨ olap Jisas nop agñɨnɨmuŋ tek ma lup. ");
INSERT INTO taw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bɨ olap mɨdolɨgup, yɨb ne Nikodemus. Ne bɨ Pelisi olap, Juda bɨawl takaw tɨg asɨkep okok olap yek. ");
INSERT INTO taw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ne maynab ayaŋ amɨl, Jisas nop nɨŋɨd anɨb agak, Tisa, chɨn nopun, tap mageptek gɨpan okok nak ke ma gɨpɨnap agak. God nokom nep agyokek apɨl nɨm, tap mageptek anɨb okok gɨlɨg, chɨnop takaw agñɨlɨg gɨpan agak. ");
INSERT INTO taw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Agek Jisas pen agak, Yad nep nɨŋɨd yɨbɨl agebin, binɨb an ke kɨdeyɨl ma lenɨgab, God binɨb dɨl kɨlop kod yenɨgab mɨgan ak ma amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Anɨb agek Nikodemus agak, Tɨtay dɨl binɨb tɨk lel awl gɨpal okok, tepayaŋ binɨb ke kɨdeyɨl lɨnɨgabal agak. Nonɨm kogmeg nab okok tepayaŋ amel, tepayaŋ tɨkɨnɨgel akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Agek Jisas pen agak, Nep nɨŋɨd yɨbɨl agebin, binɨb an ñɨg ak sek God Kawnan ak sek nop gek ke kɨdeyɨl ma lenɨgab, God binɨb dɨl kɨlop kod yenɨgab mɨgan ak ma amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Binɨb ñapay tɨkɨpal tek tɨkel mɨdebal ak pen, God Kawnan ne ak gek, binɨb kawnan kɨli okok ke kɨdeyɨl mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anɨb ak takaw nep apin, Nɨbi ke kɨdeyɨl lɨnɨmɨb apin ak, nɨŋɨd gos pal yɨbɨl ma lɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yɨgen ak ne ke apɨl okok okok amub agak. Amɨl, dek pugak nep nepɨm ak pen, owup okok sek amub okok sek ma nepɨm agak. Anɨb ak tek nɨm, God Kawnan ne ak bɨ anop gek, ke kɨdeyɨl lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Anɨb agek Nikodemus pen agak, Nad ageban anɨb ak, taydɨl gɨnɨmuŋ tek lɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Agek Jisas pen agak, Tɨtay dɨnɨgab agak? Nad Yislel binɨb tisa awl kɨli olap pen, tap anɨb okok ma nepan agak? ");
INSERT INTO taw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nep nɨŋɨd yɨbɨl agebin agak. Chɨn tap tay nɨgtep gɨpun ak apun agak. Pen tap tay wɨdɨn ke nopun ak agñɨbun agak. Nɨbi pen takaw chɨn agñɨbun ak ma dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yad nɨbop tap lum awl yɨl gup tek agen gos ma nepɨm ak, God man ne alaŋ gup tek agen taydɨl gos nɨgɨnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pen binɨb olap God man ne alaŋ ma aj nepal agak. Bɨ Olap Ñɨne, ne nokom God man ne alaŋ nɨb mɨdɨl lum awl owak agak. ");
INSERT INTO taw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pen bɨlel Mosis man nep binɨb ma yelak nab okok mɨdɨl, ne tap yoy tek olap dap alaŋ lak agak. Lek, binɨb tap yoy tek anɨb ak nɨgɨlak okok, kɨlop suŋ lak agak. Anɨb ak tek nep, Bɨ Olap Ñɨne nop dap alaŋ lɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Anɨgɨl dɨlel, binɨb mɨdupsek nop gos lɨnɨgɨnɨgabal okok, pel pelnep yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God binɨb lum awl mɨdupsek kɨlop mapen lak anɨb ak tek, Ñɨne nokom ak kɨlop nen agɨl ñak agak. Ak nɨm, binɨb mɨdupsek nop gos lɨnɨgɨnɨgabal okok, pɨsnep ma kul gɨnɨgel, pel pelnep yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anɨb ak nɨm, God Ñɨne nop agyokak anɨb ak, binɨb lum awl okok kɨlop tɨg asɨkɨl bɨlokɨnɨmuŋ agɨl ma yokak agak. Kɨlop tɨg asɨk dɨnɨmuŋ agɨl yokak agak. ");
INSERT INTO taw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Binɨb an Ñɨne nop gos lɨnɨgup ak, nop ma tɨg asɨk bɨlokeb agak. Pen binɨb an nop gos ma lɨnɨgup ak, nop tɨg asɨk bɨlokup agak. God Ñɨne nokom nop gos ma lɨnɨgup anɨb ak tek, nop tɨg asɨk bɨlokup agak. ");
INSERT INTO taw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Takaw awl yɨbɨl dɨpal jɨj anɨb ak, anɨgɨl mɨdeb agak. God mɨlek ne ak lum awl owup ak pen, binɨb okok mɨlek anɨb ak nɨgel kɨlop tep ma gup agak. Kɨli gɨ tɨmel gɨl mɨdebal tek, kɨsɨlɨm owup okok nep nɨgel tep gup agak. ");
INSERT INTO taw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Binɨb gɨ tɨmel gɨl mɨdebal okok, kɨli mɨlek ak nɨgel tep ma gup agak. Gɨ tɨmel gɨpun ak mɨseŋ lenɨgab agɨl, mɨlek ak yɨl ma opal agak. ");
INSERT INTO taw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pen binɨb an takaw nɨŋɨd yɨbɨl ak kɨdek gɨpal ak, mɨlek ak yɨl opal agak. God kɨles ñek wog gobun ak, mɨseŋ nɨgep tek laŋ agɨl, mɨlek ak yɨl opal agak. ");
INSERT INTO taw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tap anɨb okok kɨdek won ak, Jisas bɨne okok ayɨp amnɨlak, Judiya plopens nab okok. Am mɨdɨl, binɨb okok kɨlop ñɨg pakñolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pen Jon abe binɨb okok kɨlop ñɨg pakñolɨgup. Ne man sɨkol Aynon yep man sɨkol Salim ñɨg kuŋay yek sɨŋak mɨdɨl, binɨb okok apelak kɨlop ñɨg pakñolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ñɨn nab anɨb sɨŋak Jon anɨgolɨgup. Kɨdek nɨm Helod Jon nop dɨl nag lak. ");
INSERT INTO taw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pen bɨ Juda olap apɨl, Jon bɨne ogɨnap ayɨp penpen agɨlak. Juda binɨb okok kɨli chɨn ñɨg lɨ yokɨl, God nɨgek suŋtep yonɨgun agɨl, takaw anɨb ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Penpen agɨl, Jon bɨne okok apɨl nop agɨlak, Tisa, ned bɨ ak nad ayɨp ñɨg Jodan gol kɨd adaŋ yek, takaw nop ak agñenak ak, mɨñɨl ne apɨl ñɨg pakñaknɨŋ, binɨb mɨdupsek nop yɨl apebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Agelak Jon pen agak, God ne man ne alaŋ mɨdeb ak, ne tap tay bɨ olap nop ma ñenɨgab ak, bɨ anɨb ak tap ak ma dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nɨbi ke takaw yad ak nepɨm agak. Ned nɨbop agɨnek, Yad Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak mel agɨnek agak. God yɨp agyokek yad ned opin agɨnek agak. ");
INSERT INTO taw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bɨ olap bin olap dup ak, bin anɨb ak bin ne mɨdeb agak. Pen bɨ anɨb ak bogɨlak ne ak, jak mɨdɨl takaw nop nɨŋɨd, bin ne ak pɨsnep dup agɨl mɨñmɨñ yɨbɨl gup agak. Yad nɨm anɨb ak tek, mɨñmɨñ yɨbɨl gɨl, yɨp tep gup agak. ");
INSERT INTO taw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yɨb nop awl gɨl adek amnɨmuŋ, yɨb yɨp sɨkol gɨl ayaŋ amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Bɨ adek alaŋ nɨb owup ak, tap okok mɨdupsek muk ne okok mɨdeb agak. Bɨ lum awl nɨb ak, binɨb lum awl gɨpal tek ne abe gup, binɨb takaw kɨli ak apal tek ne abe agup agak. Pen bɨ God man ne alaŋ nɨb owup ak, tap okok mɨdupsek muk ne okok mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ne tap tay wɨdɨn nɨŋɨd, takaw ak nɨŋɨd dup ak, anɨb ak agñub agak. Ak agñub pen, takaw nop ak ma dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pen binɨb an takaw nop dup ak, dup anɨb ak tek binɨb okok kɨlop yomub, God ne takaw nɨŋɨd yɨbɨl agup agak. ");
INSERT INTO taw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God bɨ anɨb ak nop agyokek owak ak, God ne Kawnan ne ak yokek apɨl ayɨp nep mɨdeb agak. Ak nɨm takaw agñub ak, God takaw nep ak agñub agak. ");
INSERT INTO taw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nap Ñɨne nop mapen lɨl, tap okok mɨdupsek kod yonɨmuŋ agɨl, dɨ ñɨn adek nop ak lup agak. ");
INSERT INTO taw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Binɨb an Ñɨne nop gos lɨnɨgup ak, pel pelnep yenɨgab ak pen, binɨb an Ñɨne nop ma dɨl kelɨgɨnɨgab ak, pel pelnep ma yenɨgab agak. God nop tɨmel nɨŋɨd yul awl ñek mɨŋel dɨlɨg nep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pen bɨ Pelisi kay kɨli nɨgɨlak, binɨb kuŋay yɨbɨl apel, Jisas kɨlop ñɨg pakñek binɨb ne okok yelak. Pen Jon yɨl, binɨb sɨkol ogɨnap nep apel, kɨlop ñɨg pakñek binɨb ne okok yelak. ");
INSERT INTO taw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jisas pen ne ke kɨlop ñɨg ma pakñak. Bɨne okok nep binɨb okok kɨlop ñɨg pakñɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pen bɨ Pelisi kay kɨli Jisas anɨgɨl gak takaw ak nɨŋɨd agelak, Jisas takaw anɨb ak nɨŋɨd, Judiya plopens ak kelɨgɨl, adɨkɨd Galili plopens amnɨg, ");
INSERT INTO taw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaliya plopens nab ak kanɨb pal ak amnak. ");
INSERT INTO taw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Amɨl, Samaliya plopens nab ak taun Sikal amjakak. Sikal wulep anɨb sɨŋak nɨm, Jekop bɨlel ñɨne Josep nop man olap ñak. ");
INSERT INTO taw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pen Jekop ñɨg kaw dak ak yek ak nɨm, Jisas apek apek, subnab won ak yɨlɨk gek, am ñɨg kaw tub gol anɨb ak besɨgak. ");
INSERT INTO taw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Pen bɨne okok, tap mɨdup tawnɨg taun Sikal wulep anɨb ak amnɨlaknɨŋ, ne nokom besɨg yek. Anɨgɨl besɨg mɨdaknɨŋ, bin Samaliya nɨb olap ñɨg malɨnɨg apek, Jisas agak, Yɨp ñɨg mal ñe ñɨŋin agak. ");
INSERT INTO taw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Agek bin anɨb ak agak, Nad bɨ Juda olap, yad bin Samaliya ak pen, taynen yɨp ñɨg mal ñe ñɨŋin agɨl ageban agak? Bin ak ne nɨgak, Juda binɨb okok, kɨli Samaliya binɨb nɨŋɨd asɨk tep gɨpal anɨb ak tek, ne takaw anɨb ak Jisas nop agak. ");
INSERT INTO taw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Anɨb agek, Jisas pen nop agak, Tap teplep God binɨb okok kɨlop ñɨnɨmuŋ ak, nad ma nepan agak. Pen yad nep ñɨg mal ñe ñɨŋin agebin ak, yɨp abe ma nepan agak. Anɨb okok nepan tek, yɨp pen agnɨgebɨnap, ñɨg ñɨbɨl pelpel yenɨgabal ak nep ñɨbɨnep agak. ");
INSERT INTO taw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Agek agak, Bɨawl, ñɨg malep akɨl nad olap ma mɨdeb, ñɨg kaw ak abe yi ayaŋ mɨdeb agak. Anɨb ak, ñɨg ñɨbɨl pelpel yenɨgabal anɨb ak, akal nɨb dɨnɨgaban agak? ");
INSERT INTO taw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Based yes chɨn Jekop, ñɨg kaw anɨb ak dak. Dek, ne ak sek binɨb ne okok sek chag bulmakaw sipsip meme ne okok sek ñɨbelɨgɨpal ak pen mɨñɨl chɨn ñɨbun agak. Pen ageban anɨb ak, yad bɨawl Jekop bɨ sɨkol agɨl ageban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Agek Jisas pen nop agak, Binɨb an ñɨg awl ñɨŋɨnɨgab ak, tepayaŋ ñɨg nen gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pen binɨb an ñɨg yad ñen ñɨŋɨnɨmuŋ ak, tepayaŋ ñɨg nen ma yɨbɨl gɨnɨgab agak. Pen ñɨg yad ñen ñɨb nab ne ayaŋ lɨnɨgab anɨb ak, ñɨg kɨlam tek julɨg, nop gek pel pelnep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Anɨb agek, bin anɨb ak agak, Bɨawl, yɨp ñɨg anɨb ak ñɨmɨmin agak. Ñe ñɨben, kɨdek yɨp ñɨg nen ma gɨnɨmuŋ agak. Pen ap ñɨg awl ma malɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Agek Jisas agak, Am nɨgɨmɨl nop poŋɨd owan agak. ");
INSERT INTO taw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Agek pen agak, Yad bɨ sek mel agak. Agek Jisas agak, Takaw anɨb apan, Yad bɨ sek mel apan ak, nɨŋɨd apan agak. ");
INSERT INTO taw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bɨ anep mamɨd ak dɨnak ak pen, bɨ mɨñɨl ayɨp mɨdebil ak, nɨgɨmɨl mel agak. Anɨb ak nɨŋɨd yɨbɨl apan agak. ");
INSERT INTO taw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Anɨb agek bin ak agak, Bɨawl, mɨñɨl yad nepin, nad bɨ God gos ñek agñeb olap agak. ");
INSERT INTO taw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Based yes chɨn bɨlel okok, dum awl kɨgom yɨmɨl God nop agnɨgelɨgɨpal agak. Pen nɨbi Juda kay, binɨb okok kɨli Jelusalem nep amɨl kɨgom yɨmɨl God nop agnɨgɨnɨgel apɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Agek agak, Bin, takaw yɨp gos nɨgɨnɨmɨn agak. Ñɨn anɨb ak ownɨgeb ak, dum anɨb awl akaŋ Jelusalem nep, kɨgom yɨmɨl Bapi nop ma agnɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nɨbi Samaliya binɨb, bɨ kɨgom yɨmɨl agnepɨm ak nop ma nepɨm agak. Chɨn Juda binɨb, bɨ kɨgom yɨmɨl agnopun ak nop nopun agak. Chɨn nopun, bɨ binɨb tɨg asɨk dep anɨb ak, ne Juda nɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ñɨn anɨb ak ownɨgab ak pen mɨñɨl owup agak. Binɨb kɨgom yɨmɨl, nɨŋɨd yɨbɨl agɨl Bapi nop agnepal okok, Kawnan ne ak kɨlop gos ñaknɨŋ, kɨli kɨgom yɨmɨl nɨŋɨd yɨbɨl agɨl nop agnɨgɨnɨgabal agak. Anɨgenɨgabal ak, Bapi ne kɨlop nɨgek tep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God ne kawnan mɨdeb agak. Ak nɨm, binɨb kɨgom yɨmɨl nop agnepal okok, Kawnan ne ak kɨlop gos ñaknɨŋ, kɨli kɨgom yɨmɨl nɨŋɨd yɨbɨl agɨl agnɨgɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Anɨb agek, bin ak Jisas nop agak, Yad nepin, Mesaya nɨm ak, ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak apal ak, ne ownɨgeb agak. Ñɨn anɨb ownɨgab ak, chɨnop tap okok mɨdupsek agñɨtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Agek Jisas agak, Bɨ anɨb ak nɨm yad, nad ayɨp takaw agobul awl agak. ");
INSERT INTO taw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Anɨb agaknɨŋ, bɨne okok kɨli apjakɨl, Jisas bin ak ayɨp takaw ag yelek nɨŋɨd gos palawl lɨlak. Pen kɨli olap tɨkjakɨl, bin anop tap tay dɨnɨg opan agɨl ma agnɨgɨlak. Jisas nop abe, taynen bin anɨb awl ayɨp takaw agebil agɨl ma agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pen bin anɨb ak, ñɨg akɨl ak kelɨgɨl, tepayaŋ adɨkɨd man ne amɨl, binɨb yelak anɨb okok kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Tap okok mɨdupsek gɨpin tek agñub bɨ ak, nɨbi apɨl nɨgɨm agak. Ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak nep tek lup akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Anɨb agek, binɨb anɨb okok Jisas nop nɨgɨnɨg man ak kelɨgɨl, saŋɨdɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma owlak won ak, Jisas bɨne okok nop nebneb gɨl agɨlak, Tisa, tap ñɨŋan agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Agel ne pen agak, Tap mɨdup yad mɨdeb ak, nɨb ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Anɨb agek, bɨne okok kɨli ke nep agnɨg agnɨg gɨl agɨlak, Binɨb ogɨnap nop tap mɨdup dap ñesɨpal akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pen Jisas kɨlop agak, Tap mɨdup yad ak anɨb nep agak. God yɨp agyokek apɨl, gos ne nɨgup anep kɨdek gɨl, wog agup anɨb ak gɨ junɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Takaw olap apɨm, Tap yɨŋ yɨbun ak takan omɨŋal omɨŋal mɨdɨl, tap mɨdup ñɨŋeb tek mɨdeb yɨg dad ownɨgabun apɨm agak. Pen yad nɨbop agebin agak. Wɨdɨn nɨbi ak nɨg dad padɨkɨl nɨgɨm agak. Wog okok tap mɨdup ñɨŋeb tek mɨdɨl, tɨk dad owep tek mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Binɨb an tɨk dad owup ak, wog gup anɨb ak nop mɨñɨl taweb agak. Pen tap mɨdup dap lup anɨb ak, koŋɨm pel pelnep yenɨgabal agak. Anɨb ak nɨm binɨb olap lum yɨg puŋɨl pagɨl tap yɨŋ yɨmub ak sek, olap tɨk dad owup ak sek, omɨŋal gɨl mɨñmɨñ gɨpil agak. ");
INSERT INTO taw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Anɨb ak takaw olap apal, Bɨ olap tap yɨŋ yɨmnɨgab, bɨ olap tap ñɨŋeb yɨg dad ownɨgab apal ak, takaw nɨŋɨd apal agak. ");
INSERT INTO taw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɨbop agyoken, am tap mɨdup tɨk dad opɨm agak. Pen wog day anɨb ak tap yɨŋ nɨbi ma yɨbek agak. Bɨ ogɨnap kɨles kɨli ak gel jakek, nɨbi am tɨk dad opɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bin Samaliya nɨb ak, ne ned am binɨb ne okok kɨlop agak, Bɨ anɨb ak tap tɨtay gɨpin okok mɨdupsek yɨp agñub agak. Anɨb agek, binɨb man anɨb ak yɨl ak, kɨli kuŋay nep Jisas nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pen Samaliya binɨb anɨb okok Jisas yek ak apɨl, nop agnɨŋɨd agɨlak, Ñɨn ogɨnap chɨn ayɨp yonɨgun agɨlak. Agelak, amɨl ñɨn omɨŋal kɨli ayɨp yelak. ");
INSERT INTO taw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mɨdɨlɨg takaw agñek, binɨb tapɨn nep ogɨnap sek nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pen bin anɨb anop agɨlak, Mɨñɨl takaw nak anep age nop gos ma lɨnopun agɨlak. Takaw ne ke agek nopun, ne nokom nɨm bɨ kasɨn gep mɨdɨl, chɨnop binɨb man keke okok tɨg asɨk dɨnɨgab agɨlak. Nɨŋɨd yɨbɨl agobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas ñɨn omɨŋal binɨb Samaliya nɨb ak ayɨp mɨdɨl, mɨnek ak kɨlop kelɨgɨl, Galili plopens amnak. ");
INSERT INTO taw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pen ne ke takaw olap agñɨl agak, Bɨ God gos ñek agñeb ak, man ne ke ak mɨdɨlɨg, yɨb ne ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pen ned Pasopa ñɨn awl ak, Galili binɨb ogɨnap am Jelusalem yelak, Jisas tap mageptek okok gek nɨgɨlak. Ak nɨm Galili plopens apjakek nɨŋɨd, nop mɨñmɨñ gɨl dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pen Jisas Galili mɨdɨl, taun Kena tepayaŋ amnak. Man anɨb ak nɨm, ned ñɨg yɨbɨl ak gek ñɨg wayn lak. Pen gapman bɨawl taun Kapeneyam nɨb olap, ñɨne nop tap gek, ");
INSERT INTO taw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","takaw olap nɨgak, Jisas Judiya plopens kelɨgɨl, ap Galili plopens yek. Anɨb ak nɨŋɨd nɨm, yek ak apɨl, nebneb gɨlɨg agak, Ñɨ yad ak tap gɨl kumnɨgeb agak. Nad kal yad ayaŋ amɨl, nop ge suŋ laŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Anɨb agek Jisas nop agak, Tap mageptek ogɨnap wɨdɨn nɨbi ma nɨgep tek lup ak, yɨp gos ma lɨnɨgɨnɨgabɨm. Mel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pen gapman bɨawl anɨb ak agak, Bɨawl, ape amnul agak. Mel ak, ñɨ yad ak kumnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Agek Jisas agak, Amnoŋ, ñɨ nak mɨdeb agak. Anɨb agek, nɨŋɨd agup agɨl saŋɨdak. ");
INSERT INTO taw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kanɨb nab okok amnaknɨŋ, bɨ wog gɨñeb ne ogɨnap apɨl, nop nebeŋ pakɨl agɨlak, Ñɨ nak ak ma kumub, mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anɨb agel, won akal tek suŋ lup agɨl, kɨlop agnɨgek agɨlak, Tolil sub kɨyum gak won ak, wak mab tek yɨnek ak suŋ lak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Anɨb agel nap nɨgak, Jisas ñɨ nak mɨdeb agak won anep suŋ lak ak nɨm, ne Jisas nop gos lɨnɨŋɨd, binɨb ne okok mɨdupsek Jisas nop gos lɨnɨŋɨd gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pen Jisas ned Galili plopens mɨdɨl, tap mageptek ned olap gak ak, kɨdek pen am Judiya plopens mɨdɨl, kelɨgɨl Galili plopens adɨkɨd apɨl, tap mageptek kɨdek olap gak. ");
INSERT INTO taw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kɨdek pen, Juda ñɨn awl kɨli olap apek, Jisas Jelusalem amnak. ");
INSERT INTO taw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pen Jelusalem wali kuskus gɨlak ak kanɨbtub olap, Chag Sipsip Kanɨbtub agelɨgɨpal. Kanɨbtub anɨb ak gol sɨŋak, ñɨg cheb won olap yek. Ñɨg cheb won anɨb ak, Hiblu takaw agɨl Betesda agelɨgɨpal. Pen ñɨg gol anɨb sɨŋak, kal bad ak, bad anep mamɨd ak yek. ");
INSERT INTO taw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Pen binɨb tap gak kuŋay yɨbɨl, wɨdɨn koy gak ogɨnap, tob tɨmel gak ogɨnap, ñɨn tob kumak ogɨnap, kɨli kal bad ak, bad anɨb okok yelak. ");
INSERT INTO taw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pen bɨ tob tɨmel gak olap yek, tap anɨb ak gek pelnep kɨn yek, sub yɨn 38 ak amnak. ");
INSERT INTO taw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas bɨ kɨn yek anop nɨŋɨd nɨgak, pel anɨgɨl yolɨgup. Anɨb ak nɨŋɨd, nop agnɨŋɨd agak, Nep suŋ lɨnɨmuŋ agɨl nepan agak? ");
INSERT INTO taw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Agek, bɨ tap gak anɨb ak pen agak, Bɨawl, ñɨg ak kaskas gaknɨŋ, binɨb yɨp dɨl, ñɨg cheb nab ayaŋ lɨnɨgel olap ma mɨdeb agak. Ñɨg nab ayaŋ ned amen ñɨg ak yɨp gek suŋ lɨnɨmuŋ agɨl nepin ak pen, binɨb ogɨnap kasek ned yɨbɨl abal agak. ");
INSERT INTO taw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Anɨb agek Jisas agak, Tɨkjakɨl, mɨj nak ak wɨnɨg dad amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Agek, won anɨb anep nop suŋ lek, mɨj ne ak dɨl dad amnak. Pen Jisas bɨ gek suŋ lak ñɨn anɨb ak, Juda añɨŋ lep ñɨn awl ak. ");
INSERT INTO taw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Anɨb ak nɨm, Juda bɨawl okok kɨli bɨ anɨb ak nop agɨlak, Mɨñɨl añɨŋ lep ñɨn awl chɨn ak agɨlak. Taynen ñɨn awl wog ma gep ñɨn ak, mɨj nak ak dad ajeban agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Agel kɨlop pen agak, Bɨ yɨp gek suŋ lup ak, ne yɨp agup, Mɨj nak ak dɨl dad amnoŋ agup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Agek nop agnɨŋɨd agɨlak, Bɨ an nep agup, Mɨj dɨl dad amnoŋ agup agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jisas pen binɨb kuŋay yelak nab anɨb okok kɨmɨgel amnak tek, bɨ yɨp gek suŋ lup nɨm awl agɨl, agɨnɨmuŋ tek ma lak. ");
INSERT INTO taw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kɨdek pen, Jisas God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak ajɨl, bɨ anɨb anop nɨŋɨd anɨb agak, Nɨgan, nep suŋ lup agak. Tap si tap tɨmel gɨpan ak kelɨgɨnɨmɨn agak. Mel ak, nep tap awl yɨbɨl gɨnɨmuŋ tek lup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pen bɨ anɨb ak, ne adɨkɨd amɨl Juda bɨawl okok kɨlop agak, Jisas ne nokom yɨp gek suŋ lup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Anɨb agek nɨŋɨd, kɨli Jisas tap anɨb okok añɨŋ lep ñɨn awl chɨn ak pelnep golɨgup agɨl, nop mɨlɨk nɨŋɨd gɨ tɨmel gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas pen kɨlop agak, Bapi yad ak wog ne bɨlel pel gɨ dad apɨl mɨñɨl owup agak. Pen yad abe anɨgɨpin agak. ");
INSERT INTO taw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Anɨb agek, Juda bɨawl okok nɨŋɨd kɨli nɨgɨlak, Juda añɨŋ lep ñɨn awl tɨbɨlɨkup ak pen, tap olap sek gek, nop mɨlɨk tɨmel nɨgɨlak. Ne abe agak, God Bapi yad agak. Ak God mɨdeb tek mɨdebin agup agɨl nɨgɨlak. Anɨb ak tek, nop ned ñagɨnɨgun agɨl gos nɨgɨlak ak, kɨles yɨbɨl gɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Juda bɨawl okok anɨgelak, Jisas kɨlop pen agak, Nɨbop nɨŋɨd yɨbɨl agebin, Ñɨ ak ne ke tap olap gɨnɨmuŋ tek ma lup, Nap tap gup okok nep nɨŋɨd gup agak. Anɨb ak Nap tap okok gup tek, Ñɨne abe anɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nap Ñɨne nop mapen lɨl, tap ne gup okok mɨdupsek yomub agak. Pen nɨbi ju dɨl gos pal awl lɨnɨmɨb agɨl, ogɨnap Ñɨne nop yomek nɨm, tap awl ke yɨbɨl ogɨnap sek nop yomnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pen Nap binɨb kubal okok gek tɨkjakɨpal tek, Ñɨ abe binɨb okok gen tɨkjakɨlaŋ agɨl, gek tɨkjakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Binɨb tɨtay gɨpal, gos tɨtay nepal ak, Nap ke kɨlop ma bɨlokup agak. Ñɨne nop agek bɨlokup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nap ne anɨgɨl gos nɨgup, Nap yɨb nop ak dad aplanɨbal nep tek, Ñɨ yɨb nop ak dad aplanɨnɨgel agak. Pen binɨb Ñɨ yɨb nop ma dad aplanɨbal okok, Nap yokek owak anop yɨb ak abe ma dad aplanɨbal agak. ");
INSERT INTO taw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb olap takaw yad ak nɨŋɨd, bɨ yɨp agyokek ownek ak nop gos lɨnɨgup ak, pel pelnep mɨdeb, yad nop ma bɨlok nepin agak. Kumeb kɨd ak kelɨgɨl, pel mɨdep kɨd ak mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nɨbop nɨŋɨd yɨbɨl agebin agak. Ñɨn anɨb ak ownɨgab ak pen mɨñɨl owup agak. Binɨb kubal tek mɨdebal okok, God Ñɨne takaw ak nɨgɨnɨgabal agak. Takaw ne nɨŋɨd, kɨm mɨdɨl pel yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nap ne ke kɨm mɨdep jɨj ak tek, ne gek, Ñɨne abe ne ke kɨm mɨdep jɨj ak mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne Bɨ Olap Ñɨne mɨdeb, anɨb ak tek Nap agek, binɨb okok kɨlop tɨg asɨkɨl bɨlokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Takaw agebin anɨb ak, nɨŋɨd gos pal awl ma lɨnɨmɨb agak. Ñɨn ownɨgeb ak, binɨb kumel kamɨlak okok kɨli mɨdupsek Ñɨ meg mɨgan agɨnɨgab ak nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tɨkjakɨl seŋayaŋ ownɨgabal agak. Binɨb gɨtep gɨpal okok, tɨkjakɨl pel yenɨgabal agak. Binɨb pen gɨ tɨmel gɨpal okok, tɨkjakel kɨlop bɨlokɨl agenɨgab, mɨŋel awl dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Pen Jisas takaw olap anɨb agak, Yad tap tɨtay gebin anɨb awl, gos yad ke ma gebin agak. Bapi yɨp agek nɨŋɨd, binɨb okok kɨlop bɨlokebin agak. Anɨb ak binɨb bɨlokebin ak, ke gos nɨŋɨd ma gebin agak. Bapi gos nɨgup tek nɨŋɨd, yɨpɨd gɨl yɨbɨl bɨlokebin agak. Ak pen Bapi yɨp agek ownek ak, gos ne ñub tek nɨŋɨd gebin agak. ");
INSERT INTO taw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yad ke bɨ tay tek mɨdebin agɨl agñɨbin ak, yɨpɨd ma gup agak. Takaw yad ak nep anɨgɨl agenɨm, ak nɨgep tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bɨ olap pen, yad bɨ tay tek mɨdebin ak ne abe agñub agak. Pen yad nepin, Bɨ nɨm ak ne agñub anɨb ak, nɨŋɨd yɨbɨl agup agak. ");
INSERT INTO taw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nɨbi bɨ ogɨnap kɨlop agyokem, Jon yɨl amnɨlak agak. Amɨl Jon nop, yɨp bɨ tay tek agɨl agnɨgelak, takaw nɨŋɨd yɨbɨl ak agñak agak. ");
INSERT INTO taw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yad gos anɨgɨl nepin, binɨb olap takaw ne agak ak, takaw yad ak kɨles ma ñɨnɨgab agak. Yad pen God nɨbop tɨg asɨk dɨnɨmuŋ agɨl gos nepin agak. Anɨb ak Jon yɨp bɨ tay tek takaw agak ak, nɨbop agñebin agak. ");
INSERT INTO taw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ne sup yɨn mɨlek gup tek ak agak. Nɨbi won sɨkol ak mɨlek anɨb ak nɨŋɨd, mɨñmɨñ gɨpek agak. ");
INSERT INTO taw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon nɨbop agtep gup ak pen, ak takaw yokɨp tek agak. Takaw olap pen, yad wog anɨgɨl gɨpin takaw ak, takaw awl yɨbɨl agak. Bapi wog gɨnɨmɨn agak tek, wog yad ke yɨbɨl okok gɨ juwnɨg opin agak. Wog gɨpin anɨb ak nɨm, mɨseŋ yɨbɨl lek binɨb okok anɨgɨl nepal, Bapi yɨp agyokek opin agak. ");
INSERT INTO taw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Pen Bapi yɨp agyokek apen, yad bɨ tay tek mɨdebin ak ne ke binɨb okok kɨlop agñub agak. Nɨbi pen bɨ anɨb ak Bapi agyokek owak ak, takaw nop ak ma nepɨm agak. Anɨb ak Bapi takaw ne ma nepɨm, jomulɨk nop ma nepɨm, takaw ne ak nɨb ayɨp ma mɨdeb agak. Mel yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Buk Baybol ak kɨl tɨkɨlak okok, nɨbi takaw anɨb ak nɨgtep gon, chɨnop gek pelnep yonɨgun agɨl, pel gos nepɨm agak. Pen takaw anɨb ak, yad bɨ tay tek mɨdebin ak kɨl tɨkɨl agñɨlak agak. ");
INSERT INTO taw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Agñelak pen, yɨp yɨl apem pel mɨdep ak dɨnɨgun agɨl gos ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Binɨb okok yɨb yɨp dad aplanɨlaŋ agɨl ma agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pen yad nɨbop nepin agak. Nɨbi God nop mapen ma lɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bapi yɨp agek takaw ne dad opin ak pen, yɨp ma dɨpɨm agak. Pen bɨ olap gos ne ke nɨŋɨd apenɨgab, nop dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɨbi binɨb chɨn okok, chɨnop nɨŋɨd yɨb awl lɨnɨgel agɨl gos nepɨm agak. God nokom ak pen, chɨnop nɨŋɨd yɨb awl lɨnɨmuŋ agɨl gos ak ma nepɨm agak. Anɨb ak tɨtay dɨl yɨp gos lɨnɨgɨnɨmɨb agak? ");
INSERT INTO taw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yad pen Bapi yɨl amɨl, nɨbop ag gɨl nɨŋɨjsek ma lɨnɨgayn agak. Gos anɨb ak ma nɨgɨnɨmɨb agak. Bɨ Mosis ak pen, ne chɨnop gɨtep gɨnɨgab agɨl nepɨm ak, ne nokom nɨbop ag gɨl nɨŋɨjsek lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosis yɨp gos nɨŋɨd takaw kɨl tɨkɨl agñak agak. Anɨb ak, takaw Mosis kɨl tɨkak ak nepɨkep ak, takaw yad ak abe nepɨkep agak. ");
INSERT INTO taw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Takaw ne kɨl tɨkak ak nɨŋɨd agɨl ma nɨŋɨd nɨm, tɨtay dɨl takaw yad ak nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pen kɨdek won anɨb ak, Jisas ñɨg cheb Galili pɨs adaŋ amnak. Ñɨg cheb Galili anɨb ak, yɨb olap Taybeliyas agelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pen ne binɨb mɨñak gup okok, kɨlop gek suŋ lolɨgup. Suŋ lek tap mageptek anɨb okok nɨgɨlak tek, binɨb kuŋay yɨbɨl nop kɨdek gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Anɨgelak, Jisas bɨne okok ayɨp am dum olap besɨg yelak. ");
INSERT INTO taw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pen ñɨn nab anɨb ak, Juda ñɨn awl Pasopa apal ak wulep wulep gak. ");
INSERT INTO taw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Besɨg mɨdɨlɨg nɨgak, binɨb kuŋay yɨbɨl nop nɨgɨnɨg apelak. Nɨŋɨd, tɨtay gɨnɨgab ak ke nɨgak ak pen, bɨne Pilip tɨtay agɨnɨgab agɨl, nop agak, Chɨn tap mɨdup akal nɨb tawɨl, binɨb okok kɨlop ñon ñɨŋɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Agek Pilip pen agak, Chɨn kab mɨdup 200 dad amɨl, tap mɨdup taw dad apɨl tɨpag sɨkol sɨkol gɨl, mɨdupsek ñon ñɨŋɨnɨgel tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Anɨb agek, Jisas bɨne olap yɨb ne Edlu, Saymon Pita nɨmam ne ak, ne agak, ");
INSERT INTO taw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ñɨsɨkol olap, bali dɨl gɨpal bilet anep mamɨd ak, kubsal omɨŋal sek dɨ mɨdeb awl ak pen, binɨb kuŋay yɨbɨl mɨdebal, ak tap awl mel agak. ");
INSERT INTO taw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Agek Jisas agak, Binɨb okok agem, besɨgɨlaŋ agak. Anɨb agek, bɨne okok binɨb okok kɨlop agelak, tap wɨjwɨj kuŋay yek ak adek anɨb okok besɨgɨlak. Binɨb kuŋay yɨbɨl anɨb okok, bɨ okok nep, 5,000 tek amnak. ");
INSERT INTO taw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kɨli anɨgɨl besɨgɨlaknɨŋ, Jisas bilet ak dɨl, God nop tep agɨl, kɨlop bɨlok ñak. Kubsal ak abe gak. Kɨlop anɨgɨl bɨlok ñek, ñɨb gel gel yɨlɨk gek day kelɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Anɨgel, bɨne okok kɨlop agak, Tap ñɨbɨl kelɨgɨpal okok, dad am ap ma gep agak. ");
INSERT INTO taw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Agek, bɨne okok bilet dayday yepɨlɨg wad yɨgel yɨgel, wad anep umɨgan ak aplan jakak. Bilet anep mamɨd anɨb ak, binɨb ñɨbɨl kelɨgɨlak ak yɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Binɨb okok tap mageptek gak anɨb ak nɨŋɨd anɨb agɨlak, Nɨŋɨd apun, bɨ nɨm awl, bɨ God gos ñek agñeb ak, God ned agak, Nop agyoken lum awl ownɨgab agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Anɨb agɨlak, Jisas takaw kɨli ak nɨŋɨd gos nɨgak, binɨb okok nop ap kɨles gɨl don, gapman bɨnonɨm chɨn mɨdeŋ agɨnɨgel. Anɨb ak nɨŋɨd, ne tep alaŋ amɨl, dum okok ke awsek yek. ");
INSERT INTO taw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pen dugep won ak, Jisas bɨne okok kɨli ñɨg cheb ayaŋ amɨl, ");
INSERT INTO taw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bot dɨl taun Kapeneyam amnɨg saŋɨdɨlak. Amel amel kɨsɨlɨm apek, kɨli mɨdelak ak Jisas ne ma owak. ");
INSERT INTO taw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kɨli amnɨlaknɨŋ, yɨgen awl dɨl, ñɨg ak pagak. ");
INSERT INTO taw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pen man pal awl nab ak amjakɨlak ak, tapɨn nep gɨ dad ñɨg nab sɨŋak amɨlɨg nɨgɨlak, Jisas ñɨg wɨj adek ak tawɨd wulep sɨŋak apjakek, nɨŋɨd pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pɨlɨkelak kɨlop agak, Ma pɨlɨkɨnɨmɨb. Ak yad nep agak. ");
INSERT INTO taw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Anɨb agek, ma pɨlɨkɨl nop bot mɨgan agel amnaknɨŋ, man wakay amnɨg gelak ak won anɨb ak nep amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mɨnek binɨb ñɨg cheb pɨs adaŋ yelak okok, kɨli mɨdɨl nɨgɨlak, tolil bot nokom dɨl owlak ak, bɨne okok nep dɨl amel, Jisas ayɨp ma amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pen bot ogɨnap sek taun Taybeliyas nɨb apɨl, Bɨawl ne God nop tep agɨl tap ñek ñɨŋɨlak tep ak wulep owlak. ");
INSERT INTO taw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Apel, binɨb kɨli nɨŋɨd anɨgɨl nɨgɨlak, Jisas ayɨp bɨne ayɨp ma yelak. Anɨb ak tek, nop nɨgun agɨl, bot anɨb okok dɨl taun Kapeneyam amɨl nop pɨyowɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Binɨb anɨb okok, kɨli ñɨg cheb pɨs awl ak apɨl Jisas yɨl amjakɨl, nop nɨŋɨd anɨb agɨlak, Tisa, nad won akal awl opan agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Agel Jisas pen agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Tap mageptek gɨpin anep nɨŋɨd yɨp ma pɨyow ajebɨkep agak. Tap mɨdup ñen ñɨbɨl nab ayaŋ lɨpɨm anɨb ak nɨŋɨd, yɨp pɨyow ajebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tap mɨdup kuy gɨnɨgab ak, pɨyow ajebɨm ak ma gɨnɨmɨb agak. Tap mɨdup pel mɨdep ak pen, tap anɨb ak gek binɨb pel pelnep yenɨgabal ak, pɨyow ajebɨm ak gɨnɨmɨb agak. Tap mɨdup anɨb ak, Bɨ Olap Ñɨne nɨbop ñɨnɨgab agak. Bapi God ne bɨ anɨb anop, bɨyad yɨbɨl agɨl ayɨp yek ak nɨm, tap anɨgɨl ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Anɨb agek nop agnɨŋɨd agɨlak, God wog ne okok gɨtep gɨnɨgun agɨl, taydɨl gɨnɨgun agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Agelak Jisas pen agak, God wog ne gɨnɨgab anɨb ak nɨm, God bɨ agyokek owak ak, nop nokom gos lɨnɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Anɨb agek agɨlak, Nad chɨnop tap mageptek olap ge nɨŋɨd, nep nokom gos lɨnɨgɨnɨgun agɨlak. Anɨb ak chɨnop tap tay tek gɨnɨgaban agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Apɨs based sɨkop bɨlel, man nep binɨb ma yelak nab okok mɨdɨl, tap ñɨŋeb olap, bilet Mana apal ak ñɨbelɨgɨpal agɨlak. Anɨgɨlak takaw anɨb ak, buk Baybol ak ñu kɨl tɨkɨl agak, Ne kɨlop tap mɨdup God man ne alaŋ nɨb ak ñek ñɨbelɨgɨpal agɨl tɨkak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Anɨb agelak, Jisas kɨlop agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Tap mɨdup God man ne alaŋ nɨb ak, bɨ Mosis nɨbop ma ñak agak. Mel agak. Bapi yad pen, ne tap mɨdup God man ne alaŋ nɨb tap mɨdup nɨŋɨd yɨbɨl ak, nɨbop ñub agak. ");
INSERT INTO taw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tap mɨdup ñub agebin anɨb ak, God man ne alaŋ nɨb owup agak. God man ne alaŋ kelɨgɨl lum ayaŋ apɨl, binɨb lum awl okok kɨlop gek pelpel mɨdtep gebal agak. ");
INSERT INTO taw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Agek nop agɨlak, Bɨawl, tap mɨdup anɨb ak chɨnop pelnep ñɨlɨg yenɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Agelak kɨlop agak, Yad nokom nɨm, tap mɨdup ñɨbɨl pel yenɨgabal ak agak. Binɨb yɨp yɨl ownɨgab ak, tepayaŋ yuwan ma gɨnɨgab agak. Pen yɨp gos lɨnɨgɨnɨgab ak, ñɨg nen tepayaŋ ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pen nɨbop apin tek, yɨp wɨdɨn nepɨm ak pen, gos ma lɨnɨgebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bapi binɨb yɨp agɨnɨgab okok, yɨp yɨl ownɨgabal agak. Pen binɨb an yɨp yɨl ownɨgab ak, nop ma yɨbɨl dɨyokɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yad God man ne alaŋ nɨb ownek ak, ke nepin tek gin agɨl ma ownek agak. Bɨ yɨp agyokek ownek ak, gos ne ke nɨgup tek gin agɨl ownek agak. ");
INSERT INTO taw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pen bɨ yɨp agyokak ak, gos ne nɨgup anɨb ak nep nɨm, binɨb yɨp agup okok nɨg mɨden, olap ma kul gɨnɨmuŋ agak. Ñɨn kɨdek ak pen apek, mɨdupsek gen tepayaŋ tɨkjakɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bapi ne anɨgɨl gos nɨgup, binɨb Ñɨne nop nɨŋɨd gos lɨnɨgɨnɨgabal okok, kɨli pel pelnep yenɨgel agak. Anɨb ak ñɨn kɨdek ak apek, kɨlop gen tepayaŋ tɨkjakɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pen Jisas takaw anɨb agak, Yad nokom nɨm, tap mɨdup God man ne alaŋ nɨb owup ak agek, Juda bɨawl okok kɨli pomɨl agɨlɨg agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pen anɨb agɨlak, Bɨ nɨm awl Josep ñɨne Jisas nep tek agɨlak? Nonɨm nap ne ak chɨn nopun agɨlak. Anɨb ak taydɨl pen, God man ne alaŋ nɨb opin agup ak agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Anɨb agelak, ne pen agak, Pomɨl agebɨm ak kelɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Binɨb olap ne ke gos agɨl nɨŋɨd, yɨp yɨl ma owep tek lup agak. Bapi yɨp agyokak ak pen, gos tep ñek nep nɨm, yɨp yɨl apek, ñɨn kɨdek ak nop gen tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bɨ God gos ñek agñeb okok, kɨli takaw anɨb ak ñu kɨl tɨkɨl agɨlak, God ne binɨb okok mɨdupsek kɨlop agñɨnɨgab agɨl tɨkɨlak agak. Anɨb ak, binɨb Bapi takaw ne ak nɨŋɨd, gos ne ñub tek nepal okok mɨdupsek, kɨli yɨp yɨl apebal agak. ");
INSERT INTO taw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Binɨb olap Bapi nop wɨdɨn ma nɨgup agak. Bɨne God ayɨp mɨdɨl owup ak nep, ne nokom Bapi nop wɨdɨn nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nɨbop nɨŋɨd yɨbɨl agebin, binɨb olap yɨp gos lɨnɨgɨnɨgab ak, pel pelnep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yad nokom nɨm, yɨp tap mɨdup tek ñɨbɨl pel yenɨgabal ak agak. ");
INSERT INTO taw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Napɨs nased sɨkop bɨlel, man nep binɨb ma yelak nab okok mɨdɨl, tap ñɨŋeb olap, bilet Mana apal ak ñɨŋɨlak okok, kɨli mɨñɨl ma mɨdebal, pɨsnep kumɨlak agak. ");
INSERT INTO taw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pen tap mɨdup God man ne alaŋ nɨb owak anɨb ak, binɨb ñɨbɨl ma kumnɨgel tek lup agak. ");
INSERT INTO taw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yad ke tap mɨdup God man ne alaŋ nɨb apɨl, binɨb okok kɨlop gen pelpel mɨdtep gebal agak. Binɨb olap tap mɨdup anɨb ak ñɨbonɨmuŋ, pel pelnep yenɨgab agak. Pen tap mɨdup nop ñɨnɨgayn ak, mubwak yad ak nep agak. Mubwak yad ak ñenɨm, binɨb man okok mɨdupsek pel mɨdtep gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisas anɨb agek, Juda bɨawl okok kɨli takaw anɨb ak nɨŋɨd, ke nep penpen agɨl agɨlak, Bɨ nɨm awl chɨnop tɨtay dɨl mubwak ne ak ñek ñɨŋɨnɨgabun agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Agelak Jisas kɨlop agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Nɨbi Bɨ Olap Ñɨne mubwak nop ak ñɨbɨl, nɨkɨm nop ak ñɨbɨl genɨmɨb agak. Mel ak, kɨm mɨdɨl pel mɨdtep ma gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Mubwak yad ak, tap mɨdup nɨŋɨd yɨbɨl mɨdeb agak. Nɨkɨm yad ak, tap ñɨŋeb nɨŋɨd yɨbɨl mɨdeb agak. Anɨb ak tek, binɨb olap mubwak yɨp ñɨbɨl nɨkɨm yɨp ñɨbɨl gɨnɨgab ak, pel pelnep yenɨgab agak. Pen ñɨn kɨdek ak apek, nop gen tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mubwak yɨp ñɨbɨl nɨkɨm yɨp ñɨbɨl gɨnɨgab ak, ne yad ayɨp chɨgɨl, yad pen ne ayɨp chɨgɨl, jɨmñɨl yonɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bapi pel mɨdep ak yɨp agyokek ownek ak, yɨp gek pel mɨdtep gɨl mɨdebin agak. Anɨb ak tek, binɨb olap yɨp ñɨŋɨnɨgab ak, nop gen pel mɨdtep gɨl yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tap mɨdup anɨb ak nɨm, God man ne alaŋ nɨb owup agak. Pen tap mɨdup anɨb ak, apɨs based sɨkop tap ñɨŋeb olap, bilet Mana apal ak ñɨbɨl, mɨd dad amɨl kumɨlak anɨb ak tek mel agak. Binɨb olap tap mɨdup yad apin ak ñɨŋɨnɨgab ak, pel pelnep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas taun Kapeneyam, Juda apnan gɨpal kal ak mɨdɨl, binɨb okok kɨlop agñɨlɨg takaw anɨb ak agak. ");
INSERT INTO taw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisas takaw anɨb ak agek, bɨne okok nɨŋɨd kuŋay agɨlak, Takaw anɨb ak mɨŋel gup agɨlak. An tek nɨgɨnɨgab agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bɨne agɨlak anɨb ak, Jisas ne ke nɨŋɨd, pomɨl agɨlak okok kɨlop agak, Takaw apin anɨb ak, nɨbop gek gos ak nepɨm ak kelɨgɨl apyap pakɨpɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pen Bɨ Olap Ñɨne ned yek alaŋ ak, tep alaŋ adɨkɨd amenɨgab nɨŋɨd, gos tay nɨgɨnɨgabɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God Kawnan ne ke gek, binɨb okok pel mɨdtep gebal agak. Mubwak ak tap yokɨp, nɨbop kɨles ñɨnɨmuŋ tek ma lup agak. Takaw yad nɨbop apin ak, God Kawnan takaw ne ak anɨb agek, nɨbop gek pel mɨdtep gebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nɨbi ogɨnap pen, yɨp gos ma lɨnepɨm agak. Pen Jisas ne ke ned mɨd dad amɨl nɨgak, binɨb an nop gos ma lɨnɨgɨnɨgabal okok, bɨ an nop chen mɨmug gɨ dad amnɨgab ak. ");
INSERT INTO taw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pen takaw ogɨnap sek agɨl agak, Kɨli yɨp gos ma nepal, adek anɨb ak nep nɨbop anɨb apin, Binɨb olap gos ne ke nep nɨŋɨd, yɨp yɨl ownɨmuŋ tek ma lup apin agak. Bapi nokom nɨm nop gos ñek, yɨp yɨl ownɨmuŋ tek lup apin agak. ");
INSERT INTO taw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas takaw anɨb ak agjuwek, bɨne ayɨp ajelɨgɨpal okok, kuŋay nop kelɨgɨl keke amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nop kelɨg amelak, bɨne anep umɨgan ak kɨlop agnɨŋɨd agak, Nɨbi abe yɨp kelɨg amebɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Agek, Saymon Pita pen agak, Bɨawl, an yɨl amnɨgun agak? Takaw nad ak nep chɨnop gek, pel pelnep yonɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Chɨn nep gos lɨnɨŋɨd, nɨgtep gɨl nopun, nad God bɨ suŋtep yɨbɨl ne ak mɨdeban agak. ");
INSERT INTO taw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Anɨb agek, Jisas pen agak, Nɨbop anep umɨgan ak tɨg asɨk ke lɨl dɨpin ak pen, nɨbi olap bɨ kɨcheki mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Agak anɨb ak, Judas, Saymon Yiskaliyot ñɨne ak nop agak. Judas ne bɨ anep umɨgan olap pen, kɨdek Jisas nop chen mɨmug gɨ dad amnɨgab. ");
INSERT INTO taw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kɨdek pen Juda bɨawl okok, Jisas nop ñagɨnɨg gel nɨŋɨd, Judiya plopens ma ajolɨgup. Galili plopens nep ajolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pen Juda ñɨn awl kɨli, kal bad olap gɨl apnan gɨl mɨñmɨñ gelɨgɨpal ak, wulep wulep gak. ");
INSERT INTO taw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Gaknɨŋ, Jisas nɨmam sɨkop, kɨli nop abe gos ma lɨnɨgɨlak tek, apɨl agɨlak, Nad man awl kelɨgɨl Judiya amnoŋ agɨlak. Amɨl, bɨ nad tap mageptek gɨpan tek ge nɨgɨnɨgabal agɨlak. Bɨ olap ne bɨawl mɨdɨnɨg gɨnɨgab ak, tap ne okok we gɨl ma gɨnɨgab agɨlak. Mɨseŋ yɨbɨl gɨnɨgab agɨlak. Anɨb ak nad tap mageptek ogɨnap gɨnɨgayn agɨl, mɨseŋ sɨŋak gɨnɨmɨn binɨb mɨdupsek nɨgɨnɨgel agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Anɨb agel, Jisas kɨlop agak, Yɨp aglup ñɨn ak ma owup agak. Pen ñɨn yokɨp okok, ñɨn nɨbi ak nɨm, amnɨg amnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Binɨb lum awl okok, nɨbop nɨŋɨd mɨlɨk nɨgɨnɨgel tek ma mɨdeb agak. Pen yad tap si tap tɨmel gɨpal okok agen nɨŋɨd, yɨp mɨlɨk nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Juda ñɨn awl ak, nɨbi Jelusalem amnɨmɨb agak. Pen ñɨn yad ak mɨñɨl ma owup tek, yad ma amebin agak. ");
INSERT INTO taw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Anɨb agɨl, ne Galili plopens yolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pen anɨb agek, nɨmam sɨkop ned amnɨlak. Kɨdek ne amnɨg, mɨseŋ ma amnak, we we gɨlɨg amnak. ");
INSERT INTO taw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pen Juda bɨawl okok, Jisas akal agɨl, binɨb Juda ñɨn awl ak ap yelak okok kɨlop agnɨŋɨd agɨlak, Bɨ anɨb ak akal mɨdeb agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pen binɨb okok, takaw kɨmɨgel agɨlɨg agɨlak. Ogɨnap agɨlak, Ne bɨ tep mɨdeb agɨlak. Ogɨnap pen agɨlak, Mel, ne binɨb okok kɨlop yepɨs agup tek agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pen binɨb anɨb agɨlak okok, kɨli Juda bɨawl okok kɨlop pɨlɨkɨlak anɨb ak tek, nop tay gup takaw ak mɨseŋ ma agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ñɨn awl kɨli anɨb ak, apnan gɨl gelɨgɨpal ñɨn nab sɨŋak nep mɨdaknɨŋ, Jisas apjakɨl, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amɨl, kɨlop takaw agñolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Agñek nɨŋɨd, Juda bɨawl okok gos pal awl lɨl agɨlak, Bɨ nɨm awl sikul ma agak ak pen, taydɨl takaw okok mɨdupsek nɨŋɨd agñub agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Anɨb agelak, Jisas pen agak, Takaw agñɨbin okok, yad ke nɨŋɨd ma apin agak. Bɨ yɨp agyokek ownek ak nep gos ñek apin agak. ");
INSERT INTO taw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Binɨb olap God agup tek gin agɨl gɨ dad amnɨgab ak, takaw apin jɨj ak nɨgtep gɨnɨgab agak. Takaw anɨb ak God nɨb akaŋ, yad ke apin ak nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bɨ takaw ne ke agup ak, yɨb ne dad aplanɨmuŋ agɨl gos nɨgup agak. Pen bɨ olap nop agyokek, yɨb nop dad aplanɨnɨg owup ak, bɨ takaw yɨpɨd gɨl yɨbɨl agɨl, yepɨs agɨnɨmuŋ tek ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosis takaw ñu kɨl tɨkak ak nɨbop ñak ak pen, nɨbi olap takaw adek anɨb okok kɨdek ma gɨpɨm agak. Pen taynen yɨp ñag lɨnɨgebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jisas agek, binɨb okok kɨli agɨlak, Nep an ñag lɨnɨgeb agɨlak? Nad bɨ kɨcheki mulɨk sɨkek mɨdeban ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Agel Jisas pen agak, Yad tap mageptek nokom olap genek, nɨbi mɨdupsek gos pal awl lɨpek agak. ");
INSERT INTO taw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nɨbi Mosis agak tek, ñɨ okok tɨkɨl mɨdɨl, wak tɨbɨlɨkɨpɨm agak. Pen nɨgɨm, gɨpɨm anɨb ak Mosis ne ned mel, nased yes sɨkop ned jɨj gɨl gel nɨm anɨgɨpɨm agak. Pen wak tɨbɨlɨkɨpɨm anɨb ak, ñɨn ogɨnap Juda añɨŋ lep ñɨn awl ak apek, ma kelɨgɨpɨm, monmon wak tɨbɨlɨkɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosis agak tek gɨpɨm anɨb ak tek, añɨŋ lep ñɨn awl chɨn ak bɨ olap nop gen pɨsnep suŋ lak ak, yɨp taynen mɨlɨk nepɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Anɨb ak tap seŋ okok wɨdɨn mɨdup nɨŋɨd ma bɨlokɨnɨmɨb agak. Nɨgtep gɨl, takaw yɨpɨd gɨl pal ak nɨŋɨd agɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pen Jelusalem binɨb ogɨnap, kɨli takaw anɨb ak nɨŋɨd anɨb agɨlak, Bɨawl chɨn okok, bɨ ñag lun agɨl nepal ak, nɨm awl tek lup agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pen nɨgɨm. Bɨ anɨb ak ne binɨb nab awl takaw agup ak pen, kɨli takaw olap ma agebal agɨlak. Anɨb ak bɨawl chɨn okok kɨli ke, ne Bɨ God nop aglup ak tek agɨl gos nepal akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pen bɨ nɨm awl, akal nɨb owup ak chɨn nopun agɨlak. Bɨ God nop aglup ak wakay olap opɨkop ak, akal nɨb owup ak chɨn ma nopɨnop agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pen Jisas God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ mɨdɨl, binɨb okok kɨlop takaw agñɨ mɨdɨlɨg, meg mɨgan dad aplanɨl agak, Nɨbi yɨp nɨgtep gɨl, akal nɨb ownek ak nepɨm akaŋ agak? Pen yad ke gos nɨŋɨd ma ownek agak. Bɨ nɨŋɨd yɨbɨl ak nep, yɨp agyokek ownek agak. Pen nɨbi nop ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yad ke nop nepin agak. Yad ne ayɨp mɨdɨl, yɨp agyokek ownek agak. ");
INSERT INTO taw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Anɨb agek, nop dɨl dad amɨl nag lun agɨl nɨgɨlak ak pen, nop anɨgup ñɨn ak ma owak tek, binɨb olap nop ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pen binɨb kuŋay yɨbɨl kɨli agɨlak, Bɨ anɨb awl ne tap mageptek kuŋay gup agɨlak. Pen ne Bɨ God nop aglup ak, chɨn tay agɨnɨgun agɨlak. Bɨ God nop aglup ak ne kɨdek ownɨgab ñɨn ak, bɨ anɨb awl ne gup tek ma gɨnɨgab agɨlak. Anɨb ak binɨb kuŋay yɨbɨl kɨli Jisas ne ke Bɨ God nop aglup ak agɨl, nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pen bɨ Pelisi okok nɨgɨlak, binɨb okok kɨli Jisas tɨtay gup ak takaw anɨb ak kɨmɨgel agelak. Anɨb ak nɨŋɨd, bɨ Pelisi okok sek, bɨ God nop sɨbogep bɨawl okok sek, kɨli Juda polis okok kɨlop agyokel Jisas nop nag lɨnɨg owlak. ");
INSERT INTO taw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Apel Jisas agak, Yad sɨkol won olap nɨb ayɨp mɨdɨl, bɨ yɨp agyokak ownek ak yɨl tep adɨkɨd amnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yɨp akal amub agɨl pɨyownɨgabɨm ak pen, ma nɨgɨnɨgabɨm agak. Yad akal yenɨgayn ak, nɨbi kɨdek amnɨmɨb tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Anɨb agek, Juda bɨawl okok kɨli ke agnɨg agnɨg gɨl agɨlak, Ne akal amek, nop pɨyow ma nɨgɨnɨgabun agɨlak? Ne amɨl, binɨb chɨn kɨli Glik man okok ju am mɨdebal okok mɨdɨl, binɨb man anɨb okok kɨlop takaw agñɨlɨg yenɨgab akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ne agup, Yɨp akal amub agɨl pɨyownɨgabɨm ak pen, ma nɨgɨnɨgabɨm agup agɨlak. Yad akal yenɨgayn ak, nɨbi kɨdek amnɨmɨb tek ma lup agup agɨlak. Takaw anɨb ak taynen agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juda ñɨn awl kɨli gɨjunɨg gɨpal ñɨn ak, kɨdek apjakak. Ñɨn anɨb ak ñɨn awl yɨbɨl apjakak. Ñɨn nɨm ak apek, Jisas tɨkjakɨl, meg mɨgan dad aplanɨl agak, Binɨb an kuŋam mɨlep gek, yɨp yɨl apɨl ñɨg ñɨŋɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","God takaw ñu kɨl tɨkɨl agɨl anɨb agak, Binɨb an yɨp gos lɨnɨgɨnɨgab ak, ñɨg ñɨbɨl pelpel yenɨgabal ak nab nop ayaŋ kɨlam juwɨl ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ñɨg kɨlam juwɨl ownɨgab takaw agak anɨb ak, Jisas nop gos lɨnɨgel God Kawnan ne ak kɨlop yokɨnɨgab tek agak. Ñɨn anɨb ak pen, Jisas yɨb awl ma dak ak nɨm, God Kawnan ne ak binɨb okok kɨlop ma yokak. ");
INSERT INTO taw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas anɨb agek, binɨb kuŋay yɨbɨl anɨb okok, ogɨnap takaw agak anɨb ak nɨŋɨd agɨlak, Nɨŋɨd apun. Bɨ nɨm awl, bɨ God gos ñek agñeb pel kod mɨdobun ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ogɨnap agɨlak, Ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak agɨlak. Ogɨnap pen agɨlak, Mel yɨbɨl. Bɨ God nop aglup ak Galili plopens nɨb ma ownɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God takaw ñu kɨl tɨkɨl agɨl anɨb agak, Bɨ God nop aglup ak, Depid tɨkek tɨk dad amɨl apɨl gɨl, tɨkɨnɨgabal Depid man ne Betlehem agak agɨlak. Pen bɨ anɨb awl, ne Galili plopens nɨb owup ak nɨm, ne Bɨ God nop aglup ak mel agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jisas nop nen agɨl, binɨb kuŋay yelak anɨb okok, tɨg asɨk pɨs ak ke, pɨs ak ke lɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ogɨnap nop dɨl dad amɨl nag lun agɨl nɨgɨlak ak pen, binɨb olap nop ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pen Juda polis okok adɨkɨd amel, bɨ Pelisi okok sek, bɨ God nop sɨbogep bɨawl okok sek kɨli agɨlak, Bɨ anɨb anop taynen ma dad opɨm agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Agel, bɨ polis okok pen agɨlak, Bɨ olap, bɨ anɨb ak takaw tep yɨbɨl agup tek ma apal agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Anɨb agel, bɨ Pelisi okok pen agɨlak, Nɨbi bɨ yepɨs gup anɨb ak nɨŋɨd agup agɨl nepɨm akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bɨ chɨn Juda bɨawl olap akaŋ, bɨ Pelisi olap nop gos ma lɨnepal. Mel yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Binɨb pen nop gos nepal okok, kɨli Mosis takaw ñu kɨl tɨkak ak ma nepal agɨlak. Anɨb ak God ne gek yul awl dɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pen bɨ kɨli olap Nikodemus, ne ned Jisas nop nɨgɨnɨg amnak ak, kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Mosis takaw ñu kɨl tɨkak adek ak anɨb agup, Bɨ olap nop gɨ tɨmel gɨnɨgun agɨl, yokɨp ma ag gɨnɨgun agup agak. Anɨb ak chɨn ned takaw nop nɨŋɨd tɨg asɨkɨl, jɨj olap nɨŋɨd yɨbɨl nɨm, anɨgɨnɨgun agak. ");
INSERT INTO taw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Agek, kɨli pen agɨl agɨlak, Nak abe Galili nɨb tek agɨlak? Buk Baybol ak nɨgtep gɨl nɨg dad amɨl nɨgɨnɨgaban, bɨ God gos ñek agñeb olap Galili nɨb ma ownɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bɨawl okok takaw ag juwɨl, kɨli mɨdupsek kal kɨli keke amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pen Jisas ne dum Olip amnak. ");
INSERT INTO taw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mɨnek man tɨkak won ak, tepayaŋ adɨkɨd God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amnak. Apek, binɨb kuŋay nop nɨgɨnɨg apel, ne besɨg mɨdɨlɨg takaw agñɨlɨg yek. ");
INSERT INTO taw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Agñɨl mɨdaknɨŋ, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok sek, bɨ Pelisi okok sek kɨli bin bɨ sek olap, bɨ olap ayɨp dɨ gelek, dap binɨb yelak nab sɨŋak jak lɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jak lɨl, Jisas nop agɨlak, Tisa. Bin nɨm ak bɨ sek ak pen, bɨ olap ayɨp dɨ gesɨpil nɨŋɨd, dad apobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Takaw Mosis ñu kɨl tɨkak ak kɨles gɨl agak, Bin anɨb ak tek kab ju paklɨnɨmɨb agak agɨlak. Anɨb ak nad tay gos nepan agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pen kɨli takaw anɨb ak yepɨs anɨb agon, ne tay agek, nop ag gun agɨl agɨlak. Ak nɨm, ne jel kuyan gɨl, ñɨn pɨñɨg ne ak lum adek ak kɨl tɨk yek. ");
INSERT INTO taw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pen nop agnɨgɨlɨg nep yelak, ne tɨkjakɨl kɨlop agak, Bɨ tap si tap tɨmel ma gup olap yonɨmuŋ ak, kab olap dɨl, bin anɨb ak yonɨmuŋ sɨŋak ne ned dɨyokɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Anɨb agɨl, tepayaŋ jel kuyan gɨl, lum adek kɨl tɨk yek. ");
INSERT INTO taw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Anɨgaknɨŋ, bɨ anɨb okok, takaw agak anɨb ak nɨŋɨd, bɨawl okok nokom nokom ned kelɨg amel, bɨ yelak okok mɨdupsek kelɨgɨl keke amdɨlak. Pen Jisas jel kuyan gɨl yek, bin ak anɨb sɨŋak jakɨl nep yek. ");
INSERT INTO taw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pen Jisas tɨkjakɨl, bin anop agak, Bin, bɨ okok akal abal agak? Bɨ nep ag gɨnɨmuŋ olap ma mɨdeb tek agak? ");
INSERT INTO taw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Agek bin ak agak, Bɨawl, olap ma mɨdeb agak. Agek Jisas agak, Yad abe nep ma ag gɨnɨgayn, mel agak. Amnoŋ agak. Pen tap si tap tɨmel ak tepayaŋ ma gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas binɨb okok kɨlop tepayaŋ agɨl agak, Binɨb lum awl okok mɨlek kɨli ak mɨdebin agak. Binɨb an yɨp chɨgɨl ajenɨgab ak, kɨsɨlɨm nab okok ma ajenɨgab agak. Pel mɨdep mɨlek tep ak dɨl ajenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Anɨb agek, bɨ Pelisi okok nop agɨlak, Takaw nak ke nep apan ak, yɨpɨd ma gup agɨlak. Anɨb agñe, takaw nak ak nɨgep tek ma lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Anɨb agel, Jisas pen agak, Nɨŋɨd yɨbɨl, takaw anɨb ak yad ke agebin ak pen, nɨŋɨd agebin agak. Yad opin okok nɨŋɨd, amnɨgayn okok nɨŋɨd gɨpin anɨb ak tek, takaw anɨb ak nɨŋɨd agebin agak. Pen nɨbi, opin okok amnɨgayn okok ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nɨbi takaw tɨg asɨkɨlɨg apɨm ak, binɨb lum awl okok gos nɨŋɨd apal tek nep apɨm agak. Yad takaw tɨg asɨkɨlɨg ma apin agak. ");
INSERT INTO taw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yad nokom mɨdɨl ma gɨpin agak. Bapi yɨp agyokek ownek ak, jɨmñɨl mɨdɨl gɨpul agak. Anɨb ak tek, yad takaw tɨg asɨkɨlɨg agenɨm ak, nɨŋɨd yɨbɨl agɨl tɨg asɨkɨpin agak. ");
INSERT INTO taw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Takaw Mosis ñu kɨl tɨkak ak, takaw adek nɨbi ak anɨb agup, Bɨ omɨŋal takaw adek nokom anɨb anep agenɨgayl ak, takaw anɨb ak nɨŋɨd yɨbɨl yenɨgab agup agak. ");
INSERT INTO taw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yad ke bɨ tay tek mɨdebin agɨl pel agñɨbin agak. Pen Bapi yɨp agyokek apen, yad bɨ tay tek mɨdebin ak ne abe agñub agak. ");
INSERT INTO taw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Anɨb agek nop agɨlak, Nap akal agɨlak? Agel Jisas pen agak, Nɨbi yɨp ma nepɨm tek, Bapi nop abe ma nepɨm agak. Yɨp nɨŋɨd tek, Bapi nop abe nepɨkep agak. ");
INSERT INTO taw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas ne God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak mɨdɨl, mani dap yokɨpal mɨgan ak wulep sɨŋak yek, takaw anɨb ak agñak. Ak pen, nop anɨgup ñɨn ak ma owak tek, binɨb olap nop dad amɨl nag lun agɨl ma dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ne binɨb okok kɨlop tepayaŋ agak, Yad amen, yɨp pɨyownɨgabɨm ak pen, nɨbi tap si tap tɨmel gɨ nep mɨdɨl kumnɨgabɨm agak. Yad amebin tep ak nɨbi amnɨmɨb tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Anɨb agek, Juda bɨawl okok kɨli ke agnɨg agnɨg gɨl anɨgɨl agɨlak, Ne agup, Yad amebin tep ak nɨbi amnɨmɨb tek ma lup agup agɨlak. Ak taynen anɨb agup agɨlak? Ne ke paklɨnɨg anɨb agup agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Anɨb agelak, Jisas kɨlop agak, Nɨbi lum awl nɨb, yad adek alaŋ nɨb ownek agak. Nɨbi lum awl yɨl, yad pen lum awl yɨl ma mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Anɨb ak nɨŋɨd nɨm, nɨb tap si tap tɨmel gɨ mɨdɨl kumnɨgabɨm apin agak. Pen yɨp nɨm bɨ anɨb ak nep agɨl, gos ma lɨnɨgɨnɨgabɨm ak, tap si tap tɨmel gɨ mɨdɨl kumnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Anɨb agek agɨlak, Nad an agɨlak? Agel Jisas agak, Yad ke takaw anɨb ak nɨbop agñɨjupin agak. ");
INSERT INTO taw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nɨbop takaw ag gɨnɨm adek ak, kuŋay yɨbɨl mɨdeb agak. Nɨbop bɨlokɨnɨm tek lup agak. Bɨ yɨp agyokek ownek ak pen, ne nɨŋɨd yɨbɨl agɨl nɨgtep gɨl agup agak. Takaw agup ak yad nɨŋɨd, binɨb lum okok mɨdupsek kɨlop agñɨbin agak. ");
INSERT INTO taw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas Nap nop takaw agak anɨb ak ma nɨgɨlak tek, ");
INSERT INTO taw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","kɨlop agak, Bɨ Olap Ñɨne nop alaŋ dɨlɨnɨgabɨm ñɨn ak, gɨnɨgab tek nɨgɨnɨgabɨm agak. Pen nɨŋɨd anɨb agɨnɨgabɨm, Ak Bɨ anɨb ak nep agɨnɨgabɨm agak. Ne tap olap ke nɨŋɨd ma golɨgup, Nap takaw agñolɨgup tek nep nɨŋɨd golɨgup agɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bɨ yɨp agyokek ownek ak, nop tep gup adek anep gɨpin ak nɨm, yɨp ma kelɨgup agak. Ne ayɨp nep mɨdobul agak. ");
INSERT INTO taw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas takaw anɨb ak agaknɨŋ, binɨb kuŋay yɨbɨl nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pen Jisas ne Juda binɨb nop gos lɨnɨgɨlak anɨb okok kɨlop agak, Nɨbi takaw yad ak kɨles gɨl denɨmɨb, binɨb yad yɨbɨl mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Binɨb yad yenɨgabɨm tek, takaw nɨŋɨd yɨbɨl nɨgem, takaw nɨŋɨd ak nɨbop gek, nag lup ak wɨsɨbɨl mɨdtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Anɨb agek nop pen agɨlak, Takaw apan anɨb ak tɨtay apan agɨlak? Chɨn based Eblaham ñapay ne mɨdobun ak, chɨn binɨb ogɨnap kɨlop nag lel wog gɨpal tek pel ma gɨpun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Anɨb agelak, kɨlop pen agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Binɨb tap si tap tɨmel gɨpal okok, kɨli mɨdupsek nag lɨl wog gɨpal tek gɨ mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Bɨ wog gɨñeb olap, ne ap sɨkol won olap mɨdɨlɨg wog golɨgup, kɨdek ne amnɨgab agak. Binɨb anɨb okok ayɨp pel ma yenɨgab agak. Ñɨ olap pen binɨb ne ayɨp pel yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anɨb ak tek, God Ñɨne nɨbop binɨb nag lep mɨdebɨm okok wɨsɨb yokenɨgab, nag lup ak kelɨgɨl mɨdtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɨbop Eblaham tɨkek tɨk dad apɨl tɨkelak mɨdebɨm ak yad nepin agak. Takaw apin ak pen ma dɨpɨm anɨb ak tek, yɨp ñagɨnɨg gebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yad Bapi ayɨp mɨdɨl nɨgɨnek tek agñɨbin agak. Pen nɨbi, nap nɨbi ak takaw agup okok nep gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Agek pen agɨlak, Based chɨn nɨm Eblaham agɨlak. Agel Jisas agak, Nɨbi Eblaham ñapay ne mɨdebɨkep tek, ne golɨgup tek gɨpɨkep agak. ");
INSERT INTO taw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yad God takaw agup ak nɨŋɨd, takaw nɨŋɨd yɨbɨl ak nɨbop agñɨbin ak pen, yɨp ñagɨnɨg gebɨm agak. Eblaham ne, nɨbi gɨnɨg gebɨm anɨb ak tek ma golɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nap nɨbi yɨbɨl ak gup tek gebɨm agak. Anɨb agek agɨlak, Chɨnop bɨ si dɨl ma tɨkɨpal agɨlak. God nokom nɨm, bapi chɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Anɨb agel, Jisas kɨlop agak, Gos yad ke nɨŋɨd ma ownek, God nokom yɨp agyokek ownek agak. Yad ne ayɨp mɨdɨl ownek agak. Anɨb ak God bapi nɨbi mɨdobɨkop tek, yɨp mapen lɨpɨkep agak. ");
INSERT INTO taw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pen takaw yad ak taynen nɨgtep ma gɨpɨm agak? Gɨpɨm anɨb ak, takaw nop ak ma nɨgun agɨl gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nɨbi nap nɨbi Satan ñapay mɨdebɨm ak nɨm, ne gos nɨgup adek anep gun agɨl nɨŋɨd kɨles gɨpɨm agak. Ne pel binɨb okok kɨlop ñag pak lolɨgup agak. Takaw nɨŋɨd yɨbɨl agep tek ma lup anɨb ak tek, gos nɨŋɨd yɨbɨl ogɨnap nɨŋɨd mɨdtep ma gup agak. Takaw yepɨs yɨbɨl agek agek nɨm, takaw anɨb ak takaw ne yɨbɨl lup agak. Ne bɨ yepɨs agep mɨdeb, takaw yepɨs agep mɨdupsek jɨj ak agak. ");
INSERT INTO taw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yad nɨbop takaw nɨŋɨd apin anɨb ak tek, takaw yad ak ma dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yad tap tɨmel gup ak gɨpin akaŋ agak? Nɨbi gos anɨgɨl nɨŋɨd, tap yad gɨpin anɨb ak agyɨkɨnɨmɨb agak. Yad pen takaw nɨŋɨd yɨbɨl ak agen, taynen takaw anɨb ak ma dɨpɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Binɨb God yɨl mɨdebal okok, takaw nop ak nɨŋɨd dɨpal agak. Nɨbi pen nop yɨl ma mɨdebɨm tek, takaw nop ak ma dɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda bɨ okok Jisas nop pen agɨlak, Nad bɨ Samaliya nɨb, nep kɨcheki mulɨk sɨkɨl yek apun ak, nɨŋɨd apun tek agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Agel pen agak, Yɨp kɨcheki ma mulɨk sɨkɨl yek agak. Bapi yɨb nop ak dad aplanɨbin ak pen, nɨbi yɨb yɨp ak dad apyopɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pen yɨb yad ak ke dad aplanin agɨl ma nepin agak. Bɨawl ne binɨb tɨtay gɨpal okok nɨgtep gup ak, ne nokom yɨb yɨp ak aplanaŋ agɨl nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nɨbop nɨŋɨd yɨbɨl agebin, binɨb an takaw yad ak dɨl kɨdek gɨnɨgab ak, pel mɨdɨl ma kumnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Anɨb agek, Juda bɨ okok nop agɨlak, Mɨñɨl chɨn nopun, nɨŋɨd nep kɨcheki mulɨk sɨkɨl mɨdeb agɨlak. Eblaham kumek, bɨ God gos ñek agñeb okok abe kumɨlak ak, taydɨl nad pen apan, Binɨb an takaw yad ak dɨl kɨdek gɨnɨgab ak, pel mɨdɨl ma kumnɨgab apan agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Based chɨn Eblaham kumak ak, ne bɨ sɨkol nad bɨawl akaŋ agɨlak? Bɨ God gos ñek agñeb okok abe kumɨlak agɨlak. Nad ke nepan bɨ nad an agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Agel Jisas pen agak, Yɨb yad ke dad aplanɨm ak, tap yokɨp yonɨmuŋ agak. Bɨ nokom yɨb yad dad aplanub ak, Bapi yad agak. Nɨbi nop God chɨn apɨm ak pen, ");
INSERT INTO taw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","nop ma nepɨm agak. Yad pen nɨm nop nepin agak. Nop ma nepin agenɨm ak, nɨbi yepɨs gɨpɨm tek gɨnɨgayn agak. Yad pen nop nɨgjuwɨl, takaw nop ak dɨl kɨdek gɨpin agak. ");
INSERT INTO taw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pen based nɨbi Eblaham, ne lum awl yek, kɨdek bɨ anɨb ak ownɨgab ñɨn ak agɨl mɨñmɨñ gak agak. Ak nɨm yad apen, yɨp nɨŋɨd mɨñmɨñ awl gak agak. ");
INSERT INTO taw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Anɨb agek, Juda bɨ okok nop agɨlak, Sap yeb nak 50 tek ma mɨdeban ak pen, taydɨl Eblaham nop nepan agɨl ageban agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Agelak, Jisas kɨlop agak, Nɨbop nɨŋɨd yɨbɨl agebin agak. Eblaham nop kɨdek tɨkɨlak ñɨn ak, yad bɨ anɨb ak nep abe yenek agak. ");
INSERT INTO taw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Anɨb agek, nop kab tɨgju paklɨnɨg gelak ak pen, God agnɨgep kal awl kab wali kus gɨl yek ak, mɨgan ayaŋ yek ak kɨmɨgel sɨlɨgɨl seŋ amnak. ");
INSERT INTO taw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pen Jisas bɨne okok ayɨp amɨlɨg, bɨ wɨdɨn koy sek tɨkɨlak olap yek nɨgɨlak. Bɨ anɨb ak nɨŋɨd, ");
INSERT INTO taw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","bɨne okok Jisas nop agnɨŋɨd agɨlak, Tisa. Tap si tap tɨmel an gek, bɨ anɨb awl wɨdɨn koy sek tɨkɨlak agɨlak? Ne ke akaŋ, nonɨm nap gel gak agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Agelak Jisas agak, Wɨdɨn koy sek tɨkɨlak ak, ne ke akaŋ, nonɨm nap tap si tap tɨmel gel ma gak agak. Tap anɨb ak bɨ anɨb ak nop gup ak, binɨb okok nɨŋɨd nɨgɨnɨgel, God wog kɨles ne mɨseŋ mɨdeb agak. Anɨb ak nɨm, wɨdɨn koy sek tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mɨñɨl mɨlek mɨdeb tek, bɨ yɨp agyokek ownek ak, wog nop ak gɨnɨgun agak. Kɨlup apek, wog gep tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yad lum awl mɨdebin ñɨn ak, binɨb lum awl okok mɨlek kɨli ak mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas takaw anɨb ak agɨl, lum ayaŋ kɨñuk gɨl, gek makjak lek dɨl, bɨ wɨdɨn koy gak anop wɨdɨn ak wikɨl, ");
INSERT INTO taw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","nop agak, Ñɨg Silowam cheb amɨl, ñɨg lɨ yokɨnɨmɨn agak. Yɨb Silowam, jɨj ne anɨgɨl mɨdeb, Nop agem amnɨmuŋ. Pen Jisas bɨ anɨb ak nop anɨgɨl agyokek, am ñɨg lɨ yokɨl, adɨkɨd apɨlɨg wɨdɨn ak nɨgak. ");
INSERT INTO taw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pen bogɨlak ne okok sek, binɨb okok kɨlop tap nen asɨb agolɨgup okok sek, agnɨg agnɨg gɨl agɨlak, Bɨ nɨm awl, bɨ besɨg mɨdɨlɨg tap nen asɨb agolɨgup ak tek lup agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Agel, ogɨnap agɨlak, Yaw. Nɨm bɨ anɨb anep agɨlak. Ogɨnap pen agɨlak, Mel. Bɨ anɨb ak tek lup ak pen, bɨ ak ke akaŋ agɨlak. Anɨb agel, bɨ anɨb ak ne ke agak, Yad ke bɨ anɨb ak nɨm mɨdebin ak agak. ");
INSERT INTO taw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Agek nop agɨlak, Wɨdɨn nep ak taydɨl suŋ lup agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Agel agak, Bɨ Jisas apal ak, lum ayaŋ kɨñuk gɨl, gek makjak lek dɨl, wɨdɨn yɨp ak wikɨl agup, Nad ñɨg cheb Silowam amɨl, ñɨg lɨ yokɨnɨmɨn agup agak. Am ñɨg lɨ yokɨl, day wɨdɨn yɨbɨl nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Agek agɨlak, Bɨ anɨb ak mɨñɨl akal agɨlak? Agel agak, Yad ma nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pen bɨ wɨdɨn koy sek tɨkɨlak ak, bɨ ogɨnap bɨ anɨb anop dad Pelisi kay yelak ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pen Jisas lum gek makjak lek, bɨ anop wɨdɨn gek nɨgak anɨb ak, Juda añɨŋ lep ñɨn awl ak. ");
INSERT INTO taw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Anɨb ak tek, bɨ Pelisi okok kɨli abe nop agnɨŋɨd agɨlak, Taydɨl wɨdɨn nepan agɨlak? Agel agak, Ne makjak ak dɨl, wɨdɨn yad ak wikek, am ñɨg lɨ yokɨl, day wɨdɨn yɨbɨl nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Anɨb agek, bɨ Pelisi ogɨnap agɨlak, Añɨŋ lep ñɨn awl chɨn ak anɨgup tek, God ne bɨ anop agyokek ma owup agɨlak. Agelak, bɨ kɨli ogɨnap pen agɨlak, Bɨ tap si tap tɨmel gep olap yobɨkop ak, taydɨl tap mageptek anɨb ak gɨpɨkop agɨlak. Anɨb agɨl kɨli ke nep, asɨk keke lak. ");
INSERT INTO taw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pen bɨ Pelisi okok, bɨ anɨb anop tepayaŋ agnɨŋɨd agɨlak, Bɨ wɨdɨn nep gek nepan anɨb ak, nop bɨ tay agɨl nepan agɨlak? Agel agak, Ne bɨ God gos ñek agñeb olap agak. ");
INSERT INTO taw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nɨŋɨd yɨbɨl, bɨ anɨb ak ned wɨdɨn koy yolɨgup ak mɨñɨl pen, wɨdɨn ne yɨkup. Pen Juda bɨawl okok, kɨli tap anɨb ak nɨŋɨd yɨbɨl agɨl gos ak ma nɨgɨlak. Ma nɨŋɨd, nonɨm nap kɨlop suk agel owlak. ");
INSERT INTO taw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Apelek agnɨŋɨd agɨlak, Ñɨ awl ñɨ ñɨli agɨlak? Nop wɨdɨn koy sek tɨkɨlek, anɨb apil akaŋ agɨlak? Anɨb ak, taydɨl wɨdɨn yɨbɨl nɨgup agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Anɨb agel, nonɨm nap pen agɨlek, Yaw, chɨl nopul, bɨ nɨm ak ñɨ chɨl agɨlek. Pen nop wɨdɨn koy sek tɨkɨlok agɨlek. ");
INSERT INTO taw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mɨñɨl pen, taydɨl wɨdɨn yɨbɨl nɨgup ak ma nopul agɨlek. Pen bɨ an gek wɨdɨn nop suŋ lup ak ma nopul agɨlek. Ne ñɨsɨkol mel ak, nop agnɨgem, ne ke agñɨnɨgab agɨlek. ");
INSERT INTO taw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pen kɨli bel nɨgɨlek, Juda bɨawl anɨb okok, ned takaw kɨles adek olap agɨlak. Anɨb agɨlak, Binɨb kɨli Jisas Bɨ God nop aglup ak agɨl nɨgɨnɨgabal okok, Juda apnan gɨpal kal ak ma ownɨgel agɨlak. Anɨb ak kɨli bel pɨlɨkɨl, ");
INSERT INTO taw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","anɨgɨl agɨlek, Ne ñɨsɨkol mel ak, nop ke agnɨgɨm agɨlek. ");
INSERT INTO taw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Anɨb agelek, bɨawl okok kɨli bɨ wɨdɨn koy sek tɨkɨlak anop tepayaŋ suk agel apek agɨlak, God yɨb nop anep dad aplanɨl, takaw nɨŋɨd yɨbɨl ak nokom agɨnɨmɨn agɨlak. Chɨn nopun, bɨ anɨb ak, bɨ tap si tap tɨmel gep agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Anɨb agel, kɨlop pen agak, Ne bɨ tap si tap tɨmel gep olap akaŋ ma nepin agak. Pen tap olap, ned wɨdɨn koy yenek mɨñɨl nɨgtep gɨpin ak, yad nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Agek agɨlak, Nep tɨtay gup? Pen taydɨl gek wɨdɨn yɨbɨl nepan agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Agel kɨlop pen agak, Nɨbop mɨneyɨl agñen pen ma nepɨm agak. Taynen tepayaŋ nɨgun agɨl agebɨm agak? Nɨbi abe bɨne yenɨg gos nepɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Anɨb agek, nop agjuwɨl agɨlak, Nad bɨ anɨb ak bɨne ak pen, chɨn Mosis bɨne agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God ne Mosis nop takaw agñak ak nopun ak pen, bɨ nɨm awl akal nɨb owup ak ma nopun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Agelak kɨlop pen agak, Yawe, nɨŋɨd gos pal awl lebin agak. Ne wɨdɨn yɨp ak gek suŋ lup ak pen, akal nɨb agɨl ma nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pen chɨn nopun, binɨb tap si tap tɨmel gɨpal okok, kɨli God nop agnɨgɨnɨgabal tek ma gɨnɨgab agak. Binɨb pen God nop gos anep lɨl kɨdek gɨl, yɨb nop dad aplanɨbal okok, kɨli God nop agnɨgɨnɨgabal tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Man alwol gɨlak ñɨn ak tɨkɨl, mɨd dad apɨl mɨdobun ñɨn awl, bɨ wɨdɨn koy sek tɨkɨlak ak bɨ olap nop gek suŋ lak ak, tap anɨb ak ned ma gak agak. Kesɨm nɨm anɨb ak ma nopun agak. ");
INSERT INTO taw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bɨ anɨb ak God agyokek ma opɨkop ak, tap olap ma gɨpɨkop agak. ");
INSERT INTO taw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Anɨb agek nop pen agɨlak, Nanɨm nep tɨkak ñɨn ak, mɨd dad apɨl mɨñɨl abe bɨ tap si tap tɨmel gep ak mɨdeban agɨlak. Ak pen tɨtay dɨl chɨnop takaw agñɨnɨg geban agɨlak? Anɨb agɨl, Juda apnan gɨpal kal ak ma ownɨgaban agɨl, nop agyokɨlak. ");
INSERT INTO taw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pen Jisas ne bɨ anɨb anop agyokɨlak takaw ak nɨŋɨd, amɨl nop pɨyow nɨŋɨd agak, Nad Bɨ Olap Ñɨne ak nop gos lɨnepan agak? ");
INSERT INTO taw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Agek pen agak, Bɨawl, bɨ anɨb ak bɨ an agak? Yɨp nɨm ak age, nop gos lɨnɨgɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Anɨb agek Jisas agak, Bɨ anɨb ak nɨm nepan ak agak. Nɨm ak mɨñɨl nad ayɨp takaw agebil agak. ");
INSERT INTO taw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Anɨb agek agak, Bɨawl, yad nep gos lɨnepin agak. Agɨl, Jisas yek sɨŋak kɨgom yɨmɨlɨg yɨb nop dad aplanak. ");
INSERT INTO taw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Pen Jisas agak, Yad tɨg asɨk bɨlokɨnɨg opin tek, binɨb lum awl tɨtay dɨl tek mɨdebal ak nɨgɨnɨgabal agak. Binɨb wɨdɨn koy mɨdebal okok, wɨdɨn yɨbɨl nɨgɨnɨgabal, binɨb wɨdɨn yɨbɨl nɨgebal okok, wɨdɨn koy yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Anɨb agek, bɨ Pelisi wulep sɨŋak yelak ogɨnap, kɨli takaw anɨb ak nɨŋɨd anɨb agɨlak, Anɨb apan ak, chɨn abe wɨdɨn koy akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Agel Jisas kɨlop agak, Nɨbi wɨdɨn koy mɨdebɨkep tek, tap si tap tɨmel gɨpɨm ak gach sek ma mɨdebɨkep agak. Pen wɨdɨn nopun agɨl apɨm tek, gach sek mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas takaw olap agak, Nɨbop nɨŋɨd yɨbɨl agebin, bɨ chag sipsip wali ak kanɨbtub yɨpɨd gɨl mɨgan ak mɨdaknɨŋ, tam yepɨs olap talakɨl amnɨgab ak, bɨ kabɨyam tɨmel tap si dup ak nɨm anɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bɨ wali kanɨbtub yɨpɨd gɨl mɨgan anep amnɨgab ak pen, ne bɨ chag sipsip mukep ak mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pen bɨ anɨb ak amjakek, bɨ kanɨbtub kod mɨdep ak nop nɨŋɨd kanɨb yɨkɨnɨgab agak. Chag sipsip okok, bɨ anɨb ak meg mɨgan nop ak nɨgɨnɨgabal tek, kɨlop yɨb nokom nokom agɨlɨg, poŋɨd seŋayaŋ amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chag sipsip ne mɨdupsek poŋɨd seŋayaŋ amɨl, ne ned gaknɨŋ, kɨli meg mɨgan nop ak nɨgɨnɨgabal anɨb ak tek, kɨdek gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pen bɨ olap nop ma nepal ak kɨdek ma gɨnɨgabal agak. Bɨ anɨb ak apɨl agek, meg mɨgan nop ak ma nɨgɨnɨgabal tek, pɨlɨk amnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas anɨgɨl takaw paladaŋ lɨl agak ak pen, takaw agup adek ak agɨl ma tɨk nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ma nɨgelak, Jisas tepayaŋ agak, Nɨbop nɨŋɨd yɨbɨl agebin, yad nɨm chag sipsip kanɨbtub ak mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pen bɨ yɨp ned owlak okok, mɨdupsek bɨ tap si dɨpal ak nɨm, chag sipsip okok takaw kɨlop ak ma nɨgɨlak agak. ");
INSERT INTO taw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yad nɨm kanɨbtub ak mɨdebin agak. Binɨb olap yɨp yɨl apɨl kanɨbtub mɨgan ak amek, God nop tɨg asɨk dɨnɨgab agak. Kanɨb anɨb ak mɨgan amɨlɨg seŋ apɨlɨg tap ñɨŋɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bɨ tap si dep ak, ne chag sipsip okok kɨlop si dɨnɨg, paklɨnɨg, gɨ tɨmel gɨnɨg nep owup agak. Tap olap ke gɨnɨg ma owup agak. Yad pen ownek ak, kɨm mɨdɨl mɨdtep yɨbɨl gɨnɨgel agɨl ownek agak. ");
INSERT INTO taw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yad bɨ chag sipsip mukep tep yɨbɨl ak mɨdebin agak. Bɨ chag sipsip mukep tep yɨbɨl anɨb ak, chag sipsip okok kɨlop gɨñɨnɨg monmon kumnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bɨ wog mani nep gɨlɨg chag sipsip kod yenɨgab ak, bɨ chag sipsip mukep yɨpɨd gɨl mel agak. Chag sipsip nap nɨb mel ak nɨm, ne chen ladek olap nɨŋɨd, chag sipsip okok kɨlop kelɨgɨl pɨlɨk amnɨgab agak. Amenɨgab nɨm, chen ladek ne chag sipsip okok kɨlop yuk dam kɨd keke yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bɨ anɨb ak wog mani nep dɨnɨg gɨnɨgab anɨb ak tek, anɨgɨl pɨlɨk amnɨgab agak. Chag sipsip okok kɨlop gos ma nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yad bɨ chag sipsip mukep tep yɨbɨl ak mɨdebin agak. Bapi chɨlapɨl penpen nɨgtep gɨpul tek, yad chag sipsip okok ayɨp penpen nɨgtep gɨpun agak. Anɨb ak chag sipsip okok kɨlop gɨñɨnɨg monmon kumnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chag sipsip yad ogɨnap sek ak pen, kɨli wali mɨgan anɨb awl yɨl mel agak. Chag sipsip anɨb okok abe poŋɨd ownɨm agak. Pen kɨli takaw yad ak nɨgɨnɨgabal agak. Chag sipsip yɨp yɨl mel ak pen, apɨl jɨmñɨl mɨdɨl, bɨ mukep kɨli nokom olap nep mɨdɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yad tepayaŋ tɨkjakɨnɨg, kumin agɨl gos nepin agak. Anɨgen, Bapi yɨp mapen yɨbɨl lup agak. ");
INSERT INTO taw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Binɨb olap gos ne nɨŋɨd gek ma kumnɨgayn agak. Yad ke kumin agɨl kumnɨgayn agak. Yad ke kumnɨm tek lup ak, yad ke tepayaŋ tɨkjakɨnɨm tek lup ak agak. Takaw kɨles anɨb ak tek Bapi yɨp agup agak. ");
INSERT INTO taw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisas takaw anɨb ak agek, Juda kay nɨŋɨd tepayaŋ asɨk pɨs ak ke, pɨs ak ke lɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pɨs ak keke lɨl, kuŋay agɨlak, Nop kɨcheki mulɨk sɨkek, sawl sek lek ageb agɨlak. Taynen takaw nop nɨgebɨm agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pen ogɨnap agɨlak, Nop kɨcheki mulɨk sɨkɨpɨkop, anɨgɨl ma apɨkop agɨlak. Pen kɨcheki mulɨk sɨkek, taydɨl binɨb wɨdɨn koy okok gek, tepayaŋ nepɨlap agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pen kɨdek Juda ñɨn awl olap apek, Juda binɨb Jelusalem apnan gɨlak. Kɨli ñɨn anɨb ak bɨlel God kal ne ak aglɨl agɨlak, God agnɨgep kal awl ak yenɨgab agɨlak. Anɨb ñɨn ak, yobup gɨl yɨgen gup ñɨn ak. ");
INSERT INTO taw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pen Jisas ne God agnɨgep kal awl kab wali kus gɨl yek ak, Solomon kal bad ak agelɨgɨpal, mɨgan ak ajek. ");
INSERT INTO taw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ajaknɨŋ, Juda kay okok kɨli Jisas yek sɨŋak apɨl, bɨnɨg kuskus gɨl agɨlak, Ñɨn akal chɨnop takaw yɨpɨd gɨl agɨnɨgaban agɨlak? Nad Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak yenɨmɨn, mɨseŋ age nɨgɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Agel Jisas pen agak, Nɨbop agñɨbin ak pen, yɨp gos ma lɨnepɨm agak. Tap wog gɨpin ak, Bapi ne nokom agek gɨpin agak. Anɨb ak tek, wog anɨb ak ne ke nɨbop yomub, yad an yad nɨm mɨdebin ak agak. ");
INSERT INTO taw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pen chag sipsip yad ak ma mɨdebɨm tek, yɨp gos ma lɨnepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chag sipsip yad okok kɨlop nepin agak. Kɨli meg mɨgan yad ak nɨŋɨd, yɨp kɨdek gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yad kɨlop gen pel pelnep yenɨgabal agak. Pɨsnep kul ma gɨnɨgel agak. Ñɨn adek yad mɨdebal ak, binɨb olap apɨl kɨlop tɨg asɨk dad amnɨmuŋ tek ma yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bapi ne kɨlop dɨl yɨp ñub agak. Pen ne bɨ kɨles tɨmel yɨbɨl ak, bɨ olap kɨles ne mɨdeb tek ma mɨdeb. Mel yɨbɨl agak. Anɨb ak tek, ñɨn adek ne mɨdebal ak, binɨb olap apɨl kɨlop tɨg asɨk dad amnɨmuŋ tek ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bapi ke yad ke mel, chɨlapɨl bɨ nokom yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jisas anɨb agek, Juda kay nop tepayaŋ kab tɨgju paklɨnɨg gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Gelak, Jisas pen agak, Bapi agek, wog teplep kuŋay gɨpin ak nepɨm agak. Pen gɨpin anɨb ak, adek akal taydɨl gen nɨŋɨd, yɨp kab tɨgju paklɨnɨg gebɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Agek Juda kay pen agɨlak, Tap wog teplep olap gɨpan anɨb ak nɨŋɨd, nep kab tɨgju paklɨnɨg ma gobun agɨlak. God nop agjupan ak nɨm, nep kab tɨgju paklɨnɨg gobun agɨlak. Nad bɨ yokɨp mɨdeban ak pen, yad ke God mɨdebin agɨl gos nepan agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Anɨb agelak, Jisas pen agak, Takaw Mosis ñu kɨl tɨkak pel nepɨm ak, God takaw olap tɨkɨl agak, Yad apin, Nɨbi god mɨdebɨm apin agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Buk Baybol takaw olap kul ma gɨnɨgab ak nɨm, binɨb God takaw ne agñak okok kɨlop, nɨbi god mɨdebɨm agɨl tɨkak ak, nɨŋɨd agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yad pen, Bapi yɨp aglɨl wog gɨnɨmɨn agɨl agyokek, lum awl ownek agak. Anɨb ak yad apin, God Ñɨne mɨdebin ak nep agen, nɨbi taynen God nop agjup agɨl apɨm ak agak. ");
INSERT INTO taw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bapi wog ne ak ma genɨgayn, takaw yad ak gos ma nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pen genɨm, takaw yad apin ak gos ma nɨgenɨgabɨm, tap wog gɨpin ak nɨŋɨd gos nɨgɨnɨmɨb agak. Anɨgenɨgabɨm, yad Bapi ayɨp mɨdebin, Bapi ne yad ayɨp mɨdeb ak, nɨgtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Anɨb agek, tepayaŋ nop dɨnɨg gelak ak, ne kɨmɨgel sɨlɨgɨl amnak. ");
INSERT INTO taw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pen Jisas adɨkɨd amɨl, ñɨg Jodan tɨkɨl kɨd adaŋ amnak. Amɨl, Jon ned mɨdɨl binɨb kɨlop ñɨg pakñolɨgup man ak yolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pen binɨb kuŋay yɨbɨl ne yek ak apɨl agɨlak, Nɨŋɨd apun, Jon tap mageptek olap ma gak ak pen, bɨ nɨm awl nop agɨl takaw tɨtay agak ak, mɨdupsek nɨŋɨd yɨbɨl agolɨgup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pen Jisas man anɨb ak yek, binɨb kuŋay yɨbɨl nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Bɨ olap nop tap gak, man sɨkol Betani. Yɨb ne ak Lasalus. Bɨ anɨb ak, nɨnay ne omɨŋal yelɨgɨpil, olap Maliya, olap Mata. Maliya nɨm, bin Jisas nop tob kɨd ak wel ñɨg kuy tep owep ak sog ñɨl, kɨmɨg wɨj ne dɨl wik yokak ak. ");
INSERT INTO taw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasalus nop anɨgɨl tap gek, nɨnay omɨŋal Jisas nop takaw agyokɨl agɨlek, Bɨawl. Bɨ nak anop mapen lɨpan ak tap gup agɨlek. ");
INSERT INTO taw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pen Jisas takaw agyokɨlek anɨb ak nɨŋɨd anɨb agak, Nop tap gup anɨb ak pɨsnep ma kumnɨgab agak. Anɨb ak binɨb kɨlop gek, God kɨles ne ak nɨŋɨd yɨb nop ak dad aplanɨgel agak. Pen binɨb okok kɨlop abe gek, God Ñɨne yɨb nop ak dad aplanɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ne Mata, Maliya, Lasalus kɨlop mapen lolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pen Lasalus nop tap gup takaw ak nɨŋɨd, kasek ma amnak. Man yolɨgup anɨb ak mɨnek omɨŋal sek yek. ");
INSERT INTO taw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mɨdɨl, kɨdek bɨne okok kɨlop agak, Chɨn adɨkɨd Judiya amnɨgun agak. ");
INSERT INTO taw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Anɨb agek, bɨne okok nop agɨlak, Tisa. Mɨyadil nab sɨŋawl, Juda kay okok nep kab tɨgju paklɨnɨg gelak ak pen, tepayaŋ man anɨb ak amnɨgeban agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Agelak Jisas pen agak, Nɨbi nepɨm, mɨnek nokom olap, tapɨn mɨdɨl kɨsɨlɨm owup agak. Anɨb ak bɨ mɨlek sek gɨ ajenɨgab ak, mɨlek ak nɨgɨlɨg ajenɨgab tek, tap ogɨnap aldek apyap ma pakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pen maynab ayaŋ gɨ ajɨl, mɨlek ma nɨgɨnɨgab tek, tap ogɨnap aldek apyap pakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas anɨb agɨl, takaw olap pen agak, Bogɨlak chɨn Lasalus wɨsɨn kɨneb agak. Yad pen amɨl, nop agen tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Agek, bɨne okok nop agɨlak, Bɨawl. Ne kɨneb apan ak, suŋ lɨl jakɨl amnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas ne Lasalus kumub agɨl agak ak pen, bɨne kɨli agnɨgɨlak eŋ, yokɨp wɨsɨn kɨnek anɨb agosup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bɨne okok anɨgɨl ma nɨgel anɨb ak, kɨlop mɨseŋ agɨl agak, Lasalus pɨsnep kumub agak. ");
INSERT INTO taw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pen nɨbop nen agɨl nepin, tap nop gup ak nɨbi nɨŋɨd, yɨp gos lɨnɨgɨnɨmɨb agak. Anɨb ak tek, ne ayɨp ma mɨden kumak anɨb ak, mɨñmɨñ gebin agak. Mɨñɨl pen nod yɨl amnun agak. ");
INSERT INTO taw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Agek, Tomas yɨb ne olap Didimus, ne Jisas bɨne ayɨp yelak okok kɨlop agak, Chɨn abe ne ayɨp amɨl, mɨdupsek kumnɨgun agak. ");
INSERT INTO taw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pen kɨli man sɨkol Betani amjakɨl, Jisas nɨgak, Lasalus kumek kamɨlak ak, ñɨn omɨŋal omɨŋal padɨkak. ");
INSERT INTO taw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Man sɨkol Betani anɨb ak, Jelusalem ke pal sɨŋadaŋ yek. ");
INSERT INTO taw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Anɨb ak nɨm, nɨmam kumek, Juda binɨb kuŋay yɨbɨl apɨl, Mata ayɨp Maliya ayɨp kɨlop chɨb nɨŋɨd agñɨtep gɨl yelak. ");
INSERT INTO taw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pen Mata ne Jisas apeb agel nɨŋɨd, Maliya nop kal ak kelɨgɨl, Jisas nop kanɨb nab am nɨgak. ");
INSERT INTO taw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ne Jisas nop am nɨŋɨd anɨb agak, Bɨawl, nad awl yebɨnap tek, mam yad ak ma kubɨkop agak. ");
INSERT INTO taw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yad pen nepin, mɨñɨl God nop agnɨgenɨmɨn, tɨtay agɨnɨgaban tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Agek, Jisas agak, Namam tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Agek, Mata agak, Yad nepin, ñɨn kɨdek ak, binɨb okok tepayaŋ tɨkjakɨnɨgabal ñɨn ak, ne abe tepayaŋ tɨkjakɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Agek, Jisas ne Mata nop agak, Kumɨl tepayaŋ tɨkjakɨpal ak sek, pelpel mɨdebal ak sek jɨj ak nɨm yad ke mɨdebin agak. Binɨb yɨp gos lɨnepal okok kumnɨgabal ak pen, pɨsnep ma kumnɨgabal, pelpel yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Binɨb kɨm mɨdɨl yɨp gos lɨnɨgɨnɨgabal tek, ma kumnɨgel agak. Pel pelnep yenɨgabal agak. Takaw anɨb ak gos nepan akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Agek Mata agak, Bɨawl, yaw agak. Yad nepin, nad nɨm Bɨ God nop aglup ak, chɨnop dɨl kod yenɨgab ak mɨdeban agak. God Ñɨne yɨbɨl lum awl ownɨgab agelɨgɨpal anep nɨm nad agak. ");
INSERT INTO taw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata anɨb agɨl, adɨkɨd nɨnay Maliya nop suk agek apek, nop tɨmud sɨb wikɨl agak, Tisa awl apjakɨl, nep akal agɨl agnɨgeb agak. ");
INSERT INTO taw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Agek, Maliya takaw anɨb ak nɨŋɨd, kasek tɨkjakɨl nop nɨgɨnɨg amnak. ");
INSERT INTO taw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas pen kal ma owak. Mata nɨgak tep sɨŋak nep yek. ");
INSERT INTO taw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pen Juda binɨb Maliya ayɨp kal mɨgan mɨdɨl, nop chɨb nɨŋɨd agñɨtep gɨlak okok, Maliya kasek tɨkjakɨl amek nɨŋɨd agnɨgɨlak eŋ, chɨp kaw tub adek ak chaŋ lɨnɨg ameb agɨl, kɨdek amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pen Maliya am Jisas yek ak apjakɨl, nop nɨŋɨd, tob agen kɨgom yɨmɨl agak, Bɨawl, nad awl yebɨnap tek, mam yad ak ma kubɨkop agak. ");
INSERT INTO taw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pen Maliya sek, Juda binɨb ne ayɨp owlak okok sek chɨb gek chaŋ lɨ yelak nɨŋɨd, Jisas ne yɨmug yɨbɨl gek nop mɨŋel yɨbɨl gek ");
INSERT INTO taw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","agak, Nop kabɨm akal agak? Agek agɨlak, Bɨawl, nad ape am nɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pen Jisas chaŋ lak. ");
INSERT INTO taw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chaŋ lek, Juda binɨb okok nɨŋɨd anɨb agɨlak, Nɨgɨm, bɨ anɨb anop mapen yɨbɨl lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ogɨnap pen agɨlak, Ne bɨ wɨdɨn koy gup okok gek wɨdɨn yɨbɨl nepal tek, taynen tap nop gak anɨb ak gek ma suŋ lak agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pen Jisas nop tepayaŋ mɨŋel yɨbɨl gek, Lasalus nop kamɨlak adaŋ amnak. Chɨp kaw kab mɨgan tɨdamɨgɨl kamɨl, kab kolɨm awl kaw tub mɨgan ak pɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pen Jisas apɨl agak, Kab kolɨm awl ak dɨyokɨm agak. Agek, bɨ Lasalus kumak anɨb ak nɨnay Mata agak, Bɨawl, chɨp ak kumek kamonok, ñɨn omɨŋal omɨŋal padɨkak ak, kuy tɨmel yɨbɨl ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Agek, Jisas agak, Nep tay agesɨpin agak? Yɨp gos nɨg mɨdɨl nɨm, God kɨles ne ak ke nɨgɨnɨgaban apin agak. ");
INSERT INTO taw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Anɨb agek, bɨ ogɨnap kab ak dɨyokel, Jisas kɨlan gɨl nɨŋɨd agak, Bapi, nep agnepin yɨp nepan anɨb ak tek, nep tep yɨbɨl apin agak. ");
INSERT INTO taw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yad nepin, yɨp pel nepan ak pen, mɨñɨl agnɨgebin ak, binɨb awl jak mɨdebal okol nad nokom yɨp agyokɨpan ak, nɨgtep gɨnɨgel agɨl agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Anɨb agɨl, meg mɨgan dad aplanɨl agak, Lasalus, seŋ owan agak. ");
INSERT INTO taw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Agek, chech nop kam sɨlokɨl dam kaw dɨlak okok, anɨgɨl mɨdaknɨŋ Lasalus seŋ owak. Chech nop kɨmɨg alaŋ kam sɨlokɨlak ak sek, ñɨn tob okok kam sɨlokɨlak okok sek yek. Anɨgɨl apek, Jisas agak, Wɨsɨb yokem amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda binɨb Maliya nop nɨgɨnɨg owlak anɨb okok, kuŋay yɨbɨl Jisas anɨgak okok nɨŋɨd, nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ogɨnap pen bɨ Pelisi okok yelak ak amɨl, Jisas gak anɨb okok agñɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agñel nɨŋɨd, bɨ Pelisi okok sek, bɨ God nop sɨbogep bɨawl okok sek, kɨli bɨ Juda bɨawl takaw tɨg asɨkep okok mɨdupsek kɨlop suk agel, apnan gɨl agɨlak, Bɨ anɨb ak tap mageptek kuŋay yɨbɨl geb, anɨb ak chɨn tay gɨnɨgun agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nɨŋɨd kelɨgon, ne anɨb anep gek amek, binɨb okok mɨdupsek nop gos lɨnɨgɨnɨgabal agɨlak. Anɨgelak, Lom bɨ okok apɨl, God agnɨgep kal awl chɨn ak gɨ tɨmel gɨl, binɨb chɨnop gɨ tɨmel gɨl gɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pen bɨ kɨli olap, yɨb ne Kayapas, ne sub nokom anɨb ak bɨ God nop sɨbogep bɨawl yɨbɨl ak yek. Ne kɨlop anɨb agak, Nɨbi gos teplep ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nɨbi ma nepɨm, tap olap nɨbop gɨñɨnɨgab akaŋ agak? Bɨ nokom olap chɨnop nen agɨl kumenɨgab, binɨb chɨn mɨdupsek kul gɨnɨgel tek ma lɨnɨgab ak, tep yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pen agak anɨb ak, ne ke gos nɨŋɨd ma agak. Sap yeb anɨb ak ne bɨ God nop sɨbogep bɨawl yɨbɨl yek ak nɨm, God nop gos ñek agñɨl agak, Jisas ne Juda binɨb okok kɨlop nen kumnɨgeb agak. ");
INSERT INTO taw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pen Juda nep mel agak. Ne God ñapay ne man okok mɨdupsek dɨ jɨmñɨl lɨl, jɨj nokom yɨbɨl yenɨgel tek lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pen Kayapas ayɨp Juda bɨawl anɨb okok ayɨp, ñɨn anɨb ak tɨkɨl Jisas nop tɨtay gɨl ñag paklɨnɨgun agɨl, ag amɨl apɨl gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nop ñag paklɨnɨg gel nɨm, Jisas Judiya plopens mɨdɨl mɨseŋ ma ajolɨgup. Amɨl man awl Eplaym, man nep binɨb ma yelak nab okok gol sɨŋak amɨl, man anɨb ak bɨne okok ayɨp yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pen Juda ñɨn awl kɨli Pasopa apal ak wulep owak. Owaknɨŋ, binɨb okok kɨli God chɨnop nɨgek suŋtep yonɨgun agɨl, kuŋay yɨbɨl man sɨkol sɨkol kɨli okok nɨb Jelusalem apnan gɨl yelak. ");
INSERT INTO taw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pen apɨl, Jisas nop pɨyowɨl nɨgɨlɨg, God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak jak mɨdɨlɨg, pen agnɨgek pen agnɨgek gɨl agɨlak, Nɨbi gos tay nepɨm? Ne Pasopa ñɨn awl ownɨgab akaŋ mel agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pen bɨ God nop sɨbogep bɨawl okok sek, bɨ Pelisi okok sek kɨli takaw kɨles olap agɨl agɨlak, Binɨb olap Jisas nop akal mɨdonɨmuŋ ak nɨŋɨd, ap chɨnop agonɨmuŋ, nop am nag lɨnɨg dad ownɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pen Juda ñɨn awl kɨli Pasopa apal ak, ñɨn anep kagol anep mɨdaknɨŋ, Jisas man sɨkol Betani amnak. Man anɨb ak, Jisas ned Lasalus nop gek tepayaŋ tɨkjakak. ");
INSERT INTO taw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pen amek, yɨb nop dad aplanɨgun agɨl, tap awl agɨlɨlak. Agɨlelak, Lasalus ak, Jisas ak, bɨ ogɨnap sek besɨg yelaknɨŋ, Mata tap mɨdup okok bɨlok ñek ñɨŋɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pen Maliya wel kuy tep owep teplep ak mani awl yɨbɨl tawpal ak, botol awl sek dad owak. Dad apɨl, Jisas tob adek ak sog ñɨl, kɨmɨg wɨj ne ak dɨl wikak. Anɨgek, wel kuy tep anɨb ak, kal mɨgan anɨb ak mɨdupsek tawek amnak. ");
INSERT INTO taw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pen Judas Yiskaliyot, Jisas bɨne olap, nop kɨdek chen mɨmug gɨ dad amnɨgab ak, ne agak, ");
INSERT INTO taw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Mani awl yɨbɨl tawpal wel anɨb awl tek dap lon tawel, mani dɨl, binɨb yɨmgeptek mɨdebal okok kɨlop ñobɨnop ak tep agak. Wel anɨb ak tawpɨlap ak, kab mɨdup ñɨn juwɨl omɨŋal nokom dɨpɨnop agak. ");
INSERT INTO taw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ne anɨb agak ak pen, binɨb yɨmgeptek mɨdebal okok kɨlop ñɨnɨg ma agak. Mel. Ne bɨ si dep mɨdeb. Pen Jisas bɨne okok, ne mani wad kɨli ak kod mɨdɨl, ogɨnap kɨmɨgel si dolɨgup tek, anɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pen Judas anɨb agek Jisas agak, Bin anop ma ag gan agak. Wel anɨb ak yɨp kamnɨgabal ñɨn ak lɨñɨnɨg dak ak nɨm, mɨñɨl dap lɨ ñub agak. ");
INSERT INTO taw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pen binɨb yɨmgeptek okok nɨbi ayɨp pel yenɨgabɨm agak. Yad pen, nɨbi ayɨp pel ma yenɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisas apɨl, mɨdeb man Betani agel nɨŋɨd, Juda binɨb kuŋay yɨbɨl nɨgɨnɨg owlak. Pen nop nokom nɨgɨnɨg ma owlak. Lasalus bɨ Jisas gek tɨkjakak anop abe nɨgɨnɨg owlak. ");
INSERT INTO taw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pen Lasalus nop gek tɨkjakak tek, Juda binɨb kuŋay kɨli Jisas nop gos lɨnɨŋɨd, bɨ God nop sɨbogep bɨawl okok kɨlop kelɨgɨlak. Kelɨgelak nɨŋɨd, Lasalus nop abe tɨtay dɨl ñag paklɨnɨgun agɨl, ag amɨl apɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mɨnek, binɨb kuŋay yɨbɨl Juda ñɨn awl Pasopa tap ñɨŋɨnɨg owlak okok, kɨli Jisas Jelusalem apeb takaw anɨb ak nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Anɨb ak nɨŋɨd, albad wɨj tɨk dad apɨl, nop kanɨb nebeŋ pakɨlɨg suk awl agɨlɨg agɨlak, Hosana, God nop tep yɨbɨl agɨnɨgun agɨlak. God Bɨawl ne bɨ anɨb anop agyokek owup ak, nop gɨtep ge mɨdtep gɨnɨmuŋ agɨlak. Ne Yislel bɨnonɨm mɨdɨl, chɨnop kod yenɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Pen Jisas chag donki malep ak dɨl, adek besɨgɨl amnak ak, buk Baybol ak ned tɨkɨl agɨlak tek nep gak. Takaw anɨb ak tɨkɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Taun Sayon binɨb, nɨbi ma pɨlɨkɨnɨmɨb agɨl tɨkɨlak. Nɨgɨm, bɨnonɨm nɨbi ak chag donki malep adek ak besɨgɨl apeb agɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Anɨgak ñɨn anɨb ak, bɨne okok takaw jɨj anɨb ak gos nɨgɨnɨgel tek ma lak. Pen kɨdek God gek Jisas tɨkjakɨl yɨb awl dek ak nɨm, buk Baybol ak tɨkɨl agɨlak ak gos nɨgtep gɨl nɨgɨlak, takaw anɨb ak Jisas nop nokom tɨkɨl agɨlak. Pen binɨb okok Jisas nop gɨtep gɨlak anɨb ak, abe gos nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pen binɨb kuŋay yɨbɨl, kɨli ned Jisas Lasalus nop gek tɨkjakek nɨgɨlak okok, takaw anɨb ak ag amɨl apɨl gɨ yelak ak nɨm, ");
INSERT INTO taw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","binɨb kuŋay tap mageptek gak ak takaw anɨb ak nɨŋɨd, nop kanɨb nab ak nɨgɨnɨg amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Anɨgelak, bɨ Pelisi okok nɨŋɨd, kɨli nep agnɨg agnɨg agɨlak, Nɨgɨm, gɨ mel nɨŋɨd kelɨgɨpun agɨlak. Binɨb lum awl mɨdupsek nop kɨdek gebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ñɨn anɨb ak, binɨb Juda ñɨn awl Pasopa ñɨn ak apeb agɨl, God nop gos anep lɨl agnɨgɨnɨg Jelusalem owlak. Pen Glik binɨb ogɨnap ayɨp owlak. ");
INSERT INTO taw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pen bɨ Pilip, ne taun Betsayda, Galili plopens nɨb ak. Anɨb ak nɨm, binɨb anɨb okok kɨli apɨl, Pilip nop agnɨŋɨd agɨlak, Bɨawl, chɨn Jisas nop nɨgɨnɨg apobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Anɨb agel, Pilip amɨl Edlu nop takaw anɨb ak agñɨl, omɨŋal gɨl amɨl Jisas nop agñɨlek. ");
INSERT INTO taw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Agñel, Jisas pen kɨlop agak, Bɨ Olap Ñɨne yɨb awl dɨnɨgab ñɨn ak owup agak. ");
INSERT INTO taw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɨbop nɨŋɨd yɨbɨl agebin agak. Wit mɨdup ak lum ayaŋ ma yapɨl kumenɨgab, nokom nep yenɨgab agak. Pen lum ayaŋ yapɨl kumenɨgab, jakɨl mɨdup kuŋay yɨbɨl pulɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Binɨb olap mɨdtep yɨbɨl gɨnɨm agɨl gos ne ke nɨŋɨd gek amnɨgab ak, kɨdek mɨd tɨmel gɨnɨgab agak. Pen binɨb olap lum awl gos ne ke ma nɨŋɨd kɨmɨgel mɨdenɨgab ak, kɨdek pel pelnep mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pen binɨb olap wog yɨp gɨñɨnɨg, yɨp kɨdek gɨnɨmuŋ agak. Yad akal yenɨgayn ak, wog gɨñeb yad ak ayɨp nep yenɨgab agak. Pen Bapi binɨb wog yɨp gɨñɨnɨgab ak yɨb nop awl ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Pen Jisas anɨb agɨl agak, Mɨñɨl yɨp mɨŋel gup ak pen, tay agɨnɨm agak? Bapi, tap tɨmel yɨp gɨnɨgeb ak, nad ge kelɨgaŋ agɨnɨm agak? Mel, anɨb ma agɨnɨm agak. Mɨŋel anɨb ak ownɨgeb ak, dɨnɨg ownek agak. ");
INSERT INTO taw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bapi, nad nep ge, yɨb nep ak dad aplanɨmuŋ agak. Anɨb agek, takaw olap God man ne alaŋ nɨb agak, Yad genek yɨb yad dad aplanak ak pen, tepayaŋ gɨnɨgayn dad aplanɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Agek, binɨb jak yelak okok takaw anɨb ak nɨŋɨd, ogɨnap agɨlak, Tɨmuk agosup agɨlak. Pen ogɨnap agɨlak, Ensel olap Jisas nop takaw agosup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Anɨb agelak, Jisas pen agak, Takaw anɨb ak yɨp nɨgaŋ agɨl ma agup, nɨbop nɨgɨm agɨl agup agak. ");
INSERT INTO taw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mɨñɨl God, ne binɨb lum awl okok kɨlop tɨg asɨk bɨlokɨnɨgab agak. Mɨñɨl pen God, ne bɨawl binɨb lum awl okok kɨlop kod mɨdeb ak, nop dɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yad mɨñɨl lum awl mɨdebin ak pen, yɨp dɨl dad aplanenɨgel, binɨb okok mɨdupsek kɨlop gen yɨp yɨl ownɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pen Jisas anɨb agak, Yɨp dɨl dad aplanenɨgel agak ak, yad anɨgɨl kumnɨgebin agak. ");
INSERT INTO taw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pen binɨb kuŋay ap yelak anɨb okok, nop pen agɨlak, Takaw Mosis ñu kɨl tɨkak ak chɨnop anɨgɨl agɨl agup, Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak, ne pel pelnep yenɨgab agup agɨlak. Anɨb ak taydɨl apan, Bɨ Olap Ñɨne nop dɨl dad aplanenɨgel apan agɨlak? Bɨ Olap Ñɨne anɨb ak, bɨ an agɨlak? ");
INSERT INTO taw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Agel Jisas kɨlop agak, Mɨlek ak, nɨbi ayɨp yep sɨkol won olap nep yenɨgab agak. Mɨdeb won awl nɨm, mɨlek nɨb ayɨp mɨdɨl, mɨlek sek nɨgtep gɨ ajenɨmɨb agak. Mel ak, kɨsɨlɨm apɨl nɨbop yuwɨg dɨnɨgab agak. Bɨ kɨsɨlɨm owup ak ajɨlɨg, akal ameb agɨl nɨgtep ma gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pen won awl ak mɨlek nɨb ayɨp mɨdeb anɨb ak, nɨbi mɨlek anop gos nɨgɨnɨmɨb agak. Anɨgenɨmɨb, binɨb mɨlek sek okok yenɨmɨb agak. Jisas takaw anɨb ak agɨl, kɨlop kelɨgɨl am wakay olap ke we gɨ yek. ");
INSERT INTO taw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tap mageptek kuŋay okok wɨdɨn mɨdup adek kɨlop ak gek nɨgelɨgɨpal ak pen, nop gos ma lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Gɨlak anɨb ak, bɨ God gos ñek agñeb Aysaya takaw ak tɨkɨl agak tek nep gɨlak. Takaw anɨb ak tɨkɨl agak, Bɨawl, bɨ olap takaw kɨlop apun ak gos nɨŋɨd dup akaŋ agɨl tɨkak? Pen bɨ olap Bɨawl kɨles gup adek ak nɨgup akaŋ agɨl tɨkak? ");
INSERT INTO taw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pen nop gos lɨnɨgɨnɨgel tek ma lup ak, Aysaya takaw adek olap tɨkak tek gɨlak. Tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","God anɨb agup, Kɨli wɨdɨn ma nɨgɨnɨgel, gos tɨmud teplep ak ma nɨgɨnɨgel, yɨp yɨl adɨkɨd ma ownɨgel agɨl gos nepin agup agɨl tɨkak. Anɨgenɨgel, yad gen kɨlop suŋ lɨnɨgab ak pen mel agebin agup agɨl tɨkak. Anɨb ak tek God wɨdɨn kɨlop gek wɨdɨn koy mɨdebal, gos kɨlop gek chɨbol kɨlop ak ma asɨkep agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aysaya ne Jisas kɨles ne ak sek yɨb awl ne ak sek nɨŋɨd, takaw nop anɨb ak tɨkɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ak pen, Juda bɨawl kuŋay abe kɨli Jisas nop gos lɨnɨgɨlak. Pen bɨ Pelisi okok kɨli chɨnop pɨsnep agyokel, kɨdek apnan gɨpal kal ak ma amnɨgabun agɨl, Jisas nop gos lɨnɨgɨlak anɨb ak mɨseŋ ma agñɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gɨlak anɨb ak, binɨb okok yɨb chɨnop dad aplanɨgel agɨl gɨlak. Pen God yɨb chɨnop dad aplanɨmuŋ agɨl ma nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pen Jisas meg mɨgan dad aplanɨl agak, Binɨb an yɨp gos lɨnɨgup ak, yɨp nokom mel agak. Bɨ yɨp agyokek ownek ak nop abe gos lɨnɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Pen yɨp wɨdɨn nɨŋɨd nɨm, bɨ yɨp agyokek ownek ak nop abe wɨdɨn nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yad binɨb lum awl mɨlek kɨli tek opin agak. Apen, binɨb yɨp gos lɨnepal okok, kɨsɨlɨm okok ma yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Binɨb takaw yad ak nɨŋɨd kɨdek ma gɨnɨmuŋ ak, yad ke nop tɨg asɨk lɨl ma bɨlokɨnɨgayn agak. Yad ownek ak, binɨb okok kɨlop tɨg asɨk lɨl bɨlokɨnɨg ma ownek, kɨlop tɨg asɨk dɨnɨg ownek. ");
INSERT INTO taw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pen binɨb yɨp kelɨgɨl, takaw yad ma dɨpal okok, tap olap kɨlop tɨg asɨk lɨl bɨlokɨnɨgab agak. Ñɨn awl kɨdek ak apek, takaw apin ak ke kɨlop tɨg asɨk lɨl bɨlokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Takaw apin okok, yad ke nɨŋɨd ma apin agak. Bapi yɨp agyokek ownek ak, ne ke takaw adek ak yɨp agek, takaw nop ak dɨl agɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pen yad nepin, Bapi takaw ne adek ak binɨb okok kɨlop gek, pel pelnep yenɨgabal agak. Anɨb ak tek, takaw yad apin okok, Bapi yɨp takaw agup tek nep apin agak. ");
INSERT INTO taw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Juda ñɨn awl Pasopa ak tol tek mɨdaknɨŋ, Jisas nɨgak, lum awl aglak ñɨn ak padɨkek, adɨkɨd Bapi yɨl ameb ñɨn ak owak. Pen binɨb ne lum awl kɨlop mapen yɨbɨl lolɨgup okok, kɨlop mapen lɨlɨg nep mɨd mɨd kɨdek kumak. ");
INSERT INTO taw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Dugep won ak tap ñɨbɨlɨg yelak. Ned pen Satan, ne Saymon Yiskaliyot ñɨne Judas nop gos ñek, Jisas nop tɨtay dɨl chen mɨmug gɨ dad amnin agɨl, gos ak nep nɨgak. ");
INSERT INTO taw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pen Jisas nɨgak, Bapi ne tap tɨtay okok mɨdupsek dɨl, Ñɨne nop ñɨn adek ak lak. Pen abe anɨb nɨgak, God ne nop agyokek apɨl, adɨkɨd God yɨl amnɨg gek. ");
INSERT INTO taw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Anɨgɨl nɨŋɨd, tɨkjakɨl chech palawl ne ak tɨg asɨkɨl, tawul ak sɨbnag tek pog lɨl, ");
INSERT INTO taw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ñɨg ak kɨnag mɨgan ak pagɨl, bɨne okok kɨlop tob ñɨg lɨ yokɨlɨg, tawul pagak anɨb ak wikɨlɨg gak. ");
INSERT INTO taw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Anɨgɨl dap dap, Saymon Pita tob nop ak ñɨg lɨ yokɨnɨg apek agak, Bɨawl, nad tob yɨp ak ñɨg lɨ yokɨnɨgeban akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Agek, Jisas nop pen agak, Yad mɨñɨl gebin ak ma nepan ak pen, kɨdek nɨgtep gɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Agek, Pita agak, Bɨawl, tob yɨp ak ma ñɨg lɨ yokɨnɨmɨn, mel yɨbɨl agak. Agek Jisas pen agak, Tob nep ma ñɨg lɨ yokenɨgayn, nad yad ayɨp jɨmñɨl ma yonɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Agek, Saymon Pita agak, Bɨawl, tob yɨp anep ma ñɨg lɨ yokɨnɨmɨn. Ñɨn kɨd okok sek, kɨmɨg ak sek abe ñɨg lɨ yokɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Anɨb agek, Jisas nop agak, Bɨ olap ñɨg lɨ yokek, wak okok mɨdupsek gach ma mɨdeb ak nɨm, tepayaŋ ñɨg ma lɨ yokɨnɨmuŋ agak. Pen tob kɨd anep ñɨg lɨ yokonɨmuŋ, wak okok mɨdupsek tepayaŋ gach ma mɨdeb agak. Nɨbi gach sek ma mɨdebɨm ak pen, nokom olap nep gach sek mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pen Jisas bɨ nop chen mɨmug gɨ dad amnɨg gak ak nɨgak ak nɨm agak, Nɨbi gach sek ma mɨdebɨm, nokom olap nep gach sek mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pen tob kɨlop ak ñɨg lɨ yokjuwɨl, chech palawl tɨg asɨk lak ak lɨl, am besɨgɨl kɨlop agak, Nɨbop anɨgesɨpin jɨj ak nepɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nɨbi yɨp Tisa agɨl, Bɨawl agɨl gɨpɨm ak, nɨŋɨd apɨm agak. Takaw anɨb apɨm tep yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yad Bɨawl ak Tisa ak mɨdɨl, tob nɨbop ñɨg lɨ yokɨpin ak nɨm, tob nɨbi okok penpen ñɨg lɨ yokɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Anɨb anɨb gɨpin ak nɨbop yomen, nɨbop anɨgɨpin tek ak abe gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nɨbop nɨŋɨd yɨbɨl agebin, bɨ wog gɨñeb ak, ne bɨawl ne tek ma yenɨgab. Ne yokɨp bɨ wog gɨñeb yenɨgab agak. Bɨ takaw dad ameb ak, ne bɨawl takaw agyokak tek mel. Ne yokɨp bɨ takaw dad ameb ak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tap gɨnek anɨb ak agñɨbin nepɨm ak, adek anɨb ak gem amek mɨñmɨñ gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pen nɨbop mɨdupsek agɨl ma agebin agak. Bɨ aglɨpin ak nep dɨpin okok, nɨgtep gɨpin ak nɨm, buk Baybol ak tɨkɨl agɨlak tek gɨnɨgab agak. Takaw anɨb ak tɨkɨl agɨlak, Bɨyad ayɨp tap jɨmñɨl ñɨbul ak, yɨp taw tɨbɨk mɨdɨlɨg gup agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tap anɨb ak mɨñɨl ma gup ak pen, nɨbop ned anɨgɨl agebin agak. Ak nɨm kɨdek tap anɨb ak gɨnɨgab ak, nɨbi yad nɨm bɨ anɨb ak nep ak agɨl gos lɨnɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nɨbop nɨŋɨd yɨbɨl agebin, binɨb bɨyad ak agyoken amek, nop dɨpal okok, nop nokom mel agak. Yɨp sek dɨpal agak. Pen yɨp dɨpal okok, yɨp nokom mel, bɨ yɨp agyokek ownek anop sek dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas takaw anɨb ak agek, nop mɨŋel yɨbɨl gek agñɨl agak, Nɨbop nɨŋɨd yɨbɨl agebin, nɨbi olap yɨp chen mɨmug gɨ dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Anɨb agek, bɨne okok an nop agup agɨl, gos pal lɨlɨg penpen nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pen Jisas bɨne mapen yɨbɨl lolɨgup ak, jɨj sɨŋak besɨg yek. ");
INSERT INTO taw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Anɨb ak pen, Saymon Pita bɨ anɨb anop ñɨn anep yomɨl agak, An nop agup ak agnɨgan agak. ");
INSERT INTO taw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Agek, Jisas yek sɨŋak bɨbeŋɨd amɨl agak, Bɨawl, bɨ anɨb ak an nop apan agak? ");
INSERT INTO taw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Agek pen agak, Yad tap mɨdup ak dɨl, ñɨg yɨneb ayaŋ tawɨl bɨ olap nop ñɨnɨgayn agak. Bɨ anɨb anep apin agak. Anɨb agɨl tap mɨdup ak dɨl, ñɨg yɨneb ayaŋ tawɨl, Saymon Yiskaliyot ñɨne Judas nop ñak. ");
INSERT INTO taw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tap mɨdup ñek dak won anɨb anep, Satan apɨl Judas nop mulɨk sɨkak. Anɨgek, Jisas Judas nop agak, Gɨnɨgeban ak, kasek gan agak. ");
INSERT INTO taw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pen bɨne besɨg yek okok, kɨli Judas nop taynen anɨb agosup nɨgtep ma gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kɨli agnɨgɨlak eŋ, Judas mani wad kod mɨdeb tek, Pasopa tap ñɨŋɨnɨgabun okok tawaŋ agɨl akaŋ, binɨb yɨmgeptek tap ma mɨdeb okok kɨlop, mani ogɨnap ñaŋ agɨl agosup agɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pen Judas tap mɨdup dɨl, won anɨb ak seŋayaŋ amnaknɨŋ, day kɨsɨlɨm owak. ");
INSERT INTO taw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas anɨgɨl seŋ amnak won ak, Jisas agak, Mɨñɨl Bɨ Olap Ñɨne yɨb awl dɨnɨgab agak. Pen Bɨ Olap Ñɨne God agup tek genɨgab nɨm, God ne yɨb awl dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bɨ Olap Ñɨne God agup tek gek, God ne yɨb awl dɨnɨgab agak. Denɨgab, God ne gek, Bɨ Olap Ñɨne yɨb awl dɨnɨgab agak. Pen anɨb ak mɨñɨl ñɨn awl gɨnɨgeb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ñapay yad okol, sɨkol won olap nɨb ayɨp yenɨgayn agak. Amen, yɨp pɨyow mel nɨgɨnɨgabɨm agak. Juda kay kɨlop apin tek, mɨñɨl nɨbop abe agebin agak. Yad akal amnɨgayn ak, nɨbi kɨdek amnɨmɨb tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pen mɨñɨl nɨbop takaw adek kɨdeyɨl ak olap agñebin agak. Takaw kɨdeyɨl anɨb ak nɨm, nɨbi ke penpen mapen lɨnɨmɨb agak. Yad nɨbop mapen lɨpin tek, nɨbi abe penpen mapen lɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nɨbi ke anɨgɨl penpen mapen lenɨgabɨm, binɨb okok mɨdupsek nɨgtep gɨl nɨgɨnɨgabal, nɨbi bɨyad mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Anɨb agek, Saymon Pita ne Jisas nop agak, Bɨawl, nad akal ameban agak? Agek, Jisas pen agak, Yad amebin okok mɨñɨl yɨp kɨdek gɨnɨmɨn tek ma lup agak. Pen kɨdek nɨm, yɨp kɨdek gɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Agek, Pita agak, Bɨawl, taynen nep mɨñɨl kɨdek gɨnɨm tek ma lup agak? Nep koden yɨp paklɨnɨgabal ak, takaw ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Agek, Jisas pen agak, Nad yɨp gos nɨŋɨd kumin agɨl gos nepan akaŋ agak? Nep nɨŋɨd yɨbɨl agebin, yawl kakaluk suk ma agɨnɨgab won ak agɨnɨgaban, Nop ma nepin agɨl, takaw won omɨŋal nokom agɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pen Jisas bɨne okok kɨlop agak, Gos awl ma nɨgɨnɨmɨb agak. God nop gos lɨnɨŋɨd, yɨp abe gos lɨnɨŋɨd gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bapi kal ne ak, tep kuŋay yɨbɨl mɨdeb agak. Yad amɨl, tep nɨbop wakay ogɨnap gɨlɨtep gɨnɨgayn agak. Pen tep anɨb okok ma yobɨkop ak, nɨbop ma apɨnep agak. ");
INSERT INTO taw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pen yad amɨl tep nɨbop ak gɨlɨtep gɨl nɨm, apɨl nɨbop dɨl poŋɨd amnɨgayn agak. Anɨgen, man yad mɨdebin anɨb ak, nɨbi abe ayɨp yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Man akal amnɨgebin kanɨb anɨb ak, nɨbi nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jisas anɨb agek, Tomas agak, Bɨawl, akal ameban chɨn ma nopun agak. Anɨb ak taydɨl kanɨb amnɨgaban anɨb ak nɨŋɨd amnɨgabun agak? ");
INSERT INTO taw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Agek Jisas agak, Yad nokom nɨm kanɨbtam ak, yad nokom nɨm takaw nɨŋɨd yɨbɨl ak, yad nokom nɨm gen binɨb pel mɨdtep gebal agak. Bɨ olap kanɨb anɨb ak ke amɨl, Bapi yɨl ak amnɨmuŋ tek ma lup agak. Mel yɨbɨl agak. Yad nokom nɨm kanɨbtam Bapi yɨl ameb ak agak. ");
INSERT INTO taw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yɨp nɨgtep gɨl nɨm, Bapi nop abe nɨgtep gɨnɨgabɨm agak. Pen mɨñɨl ñɨn awl nɨg dad amɨl nop wɨdɨn nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Anɨb agek, Pilip agak, Bɨawl, Nap nop chɨnop yomnɨmɨn ak, tep agak. ");
INSERT INTO taw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Agek Jisas agak, Pilip, nɨb ayɨp pel yesɨpin ak pen, yɨp ma nepan akaŋ agak? Bɨ olap yɨp wɨdɨn nɨgup ak, Nap nop wɨdɨn nɨgup agak. Anɨb ak taydɨl ageban, Nap nop chɨnop yome nɨgɨnɨgun ageban agak? ");
INSERT INTO taw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yad Bapi ayɨp mɨdebin, ne yad ayɨp mɨdeb agak. Gos anɨb ak ma nepan akaŋ agak? Takaw nɨbop apin okok, yad ke nɨŋɨd ma apin agak. Bapi pen yad ayɨp mɨdeb ak, wog ne ke geb agak. ");
INSERT INTO taw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yad Bapi ayɨp mɨdebin, ne yad ayɨp mɨdeb takaw ak, nɨŋɨd agɨl nɨgɨnɨmɨb agak. Pen gos anɨb ak nɨgep tek ma lonɨmuŋ, wog tɨtay gɨpin okok nɨŋɨd, anɨgup agɨl gos ak nɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nɨbop nɨŋɨd yɨbɨl agebin, bɨ yɨp gos lɨnɨgɨnɨgab ak, yad wog okok gɨpin tek gɨnɨgab agak. Pen Bapi yɨl amnɨgebin anɨb ak tek, bɨ anɨb ak wog awl yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yad Ñɨne mɨdebin ak, Bapi yɨb awl dɨnɨmuŋ agɨl gos nepin agak. Anɨb ak tek, yɨb yɨp ak dɨl agnɨgem, agɨnɨgabɨm tek gɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yɨb yɨp ak dɨl tap tay gos nɨŋɨd agnɨgem, agɨnɨgabɨm tek gɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Pen Jisas anɨb agak, Yɨp mapen lɨl nɨm, takaw yad ak nɨŋɨd kɨdek gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yad Bapi nop agnɨgen, ne nɨbop Bɨ Gɨtep Gep olap sek ñek ownɨgab agak. Apɨl, nɨb ayɨp pel pelnep yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bɨ Gɨtep Gep anɨb ak nɨm, God Kawnan ne ak takaw nɨŋɨd yɨbɨl agup ak nep agak. Binɨb lum awl okok, nop gos ma nepal, wɨdɨn abe ma nepal, anɨb ak nop dɨnɨgel tek ma lup agak. Pen ne nɨb ayɨp mɨdɨl, kɨdek pɨsnep bak lɨl yenɨgab anɨb ak, nop nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nɨbop pɨsnep kelɨg amen, nɨbi ñapay amon ñɨlɨk tek ma yenɨgabɨm agak. Nɨbop tepayaŋ ownɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Binɨb lum awl okok, yɨp mɨñɨl sɨkol won olap nɨgebal, kɨdek yɨp ma nɨgɨnɨgabal agak. Nɨbi pen yɨp nɨgɨnɨgabɨm agak. Yad bɨ kɨm mɨdep ak, kɨm yenɨgayn tek, nɨbi abe kɨm yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ñɨn anɨb ak, yad Bapi ayɨp mɨdebin ak gos nɨgtep gɨnɨgabɨm agak. Nɨbi yad ayɨp mɨdebɨm, yad nɨb ayɨp mɨdebin ak abe gos nɨgtep gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bɨ takaw yad ak nɨŋɨd dɨl kɨdek gup ak, bɨ anɨb ak yɨp mapen lup agak. Pen yɨp mapen lup ak, Bapi bɨ anɨb anop mapen lɨnɨgab agak. Yad abe nop mapen lɨl, yad ke nop yomnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Anɨb agek, Judas Yiskaliyot mel, Judas olap ne Jisas nop agak, Bɨawl, taynen nad ke chɨnop yomnɨgaban ak pen, binɨb lum awl okok nad ke kɨlop ma yomnɨgaban agak? ");
INSERT INTO taw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Agek, Jisas pen nop agak, Bɨ yɨp mapen lonɨmuŋ, takaw yad ak nɨŋɨd dɨnɨgab agak. Anɨgɨl nɨŋɨd dek nɨm, Bapi bɨ anɨb anop mapen lɨl, chɨlapɨl abe apɨl ne ayɨp mɨdɨl, pel yonɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bɨ yɨp mapen ma lup ak, takaw yad ak nɨŋɨd ma dup agak. Takaw nɨgebɨm anɨb ak, takaw yad mel agak. Bapi yɨp agyokek ownek ak, takaw ne ak nɨgebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nɨb ayɨp mɨdebin ñɨn awl, takaw anɨb awl agñɨbin agak. ");
INSERT INTO taw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bɨ Gɨtep Gep ak pen, God Kawnan ne ak mɨdeb agak. Bapi ne yɨb yɨp ak dɨl, nop agyokek ownɨgab agak. Ne apɨl nɨbop tap okok mɨdupsek agñɨl, nɨbop gek takaw apin mɨdupsek okok gos nɨgɨlɨg mɨdɨl, nɨgtep yɨbɨl gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yad amebin tek, nɨbop gen mɨdtep gɨnɨgabɨm agak. Yad mɨdtep gɨpin tek, nɨbop gen mɨdtep gɨnɨgabɨm agak. Pen nɨbop gen mɨdtep gɨnɨgabɨm anɨb ak, binɨb lum awl okok nɨbop gel mɨdtep gɨnɨgabɨm tek ma lup agak. Anɨb ak tek, gos awl ma nɨgɨnɨmɨb, ma pɨlɨkɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yad amɨl adɨkɨd nɨbop ownɨgayn apin ak nepɨm agak. Bapi ne bɨawl yɨbɨl mɨdeb, kɨles ne ak tap awl yɨbɨl, kɨles yad ak sɨkol gup agak. Anɨb okok nɨŋɨd, yɨp mapen lɨpɨm tek, Nap yɨl ameb agɨl, mɨñmɨñ gɨlɨg yebɨkep agak. ");
INSERT INTO taw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tap anɨb okok mɨñɨl ma gup ak pen, nɨbop ned anɨgɨl agebin agak. Ak nɨm kɨdek anɨgenɨgab ñɨn anɨb ak, nɨŋɨd yɨp gos lɨnɨgɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Bɨawl binɨb lum awl okok kɨlop kodup ak, yɨp kodup tek ma lup agak. Pen mɨñɨl apeb ak nɨm, takaw kuŋay ma agɨnɨgebin agak. ");
INSERT INTO taw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pen binɨb lum awl okok nɨgenɨgel, yad Bapi nop mapen lɨl, Bapi agup tek gɨtep gɨl gɨpin ak agak. Tep, apem amnun agak. ");
INSERT INTO taw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas ne anɨb agak, Yad nɨm nag wayn bɨd ak tek, jɨj nɨm ak nɨŋɨd yɨbɨl mɨdebin agak. Bapi nɨm bɨ wayn wog nap nɨb ak agak. ");
INSERT INTO taw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nag lek yad ak mɨdup ma pulɨnɨgab okok, Bapi ne tɨb sak dɨyokɨnɨgab agak. Pen lek pul tep gɨnɨgab okok, mɨdtep yɨbɨl mɨdɨl kuŋay yɨbɨl pulɨnɨmuŋ agɨl, tɨbɨlɨk gɨtep gɨnɨgab agak. Tɨbɨlɨk gɨtep gek, suŋtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nɨbi suŋtep gɨpɨm agak. Takaw nɨbop agñɨnek ak, nɨbop gek suŋtep mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nɨbi yad ayɨp jɨmñɨl yenɨmɨb, yad nɨb ayɨp jɨmñɨl yenɨgayn agak. Pen nag lek okok, jɨj ak sek jɨmñɨl ma yenɨgab ak, mɨdup pulep tek ma yenɨgab agak. Anɨb ak yad ayɨp jɨmñɨl ma yenɨmɨb ak, mɨdup pulep tek ma yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yad nɨm nag wayn bɨd ak tek, nɨbi nɨm nag wayn lek okok tek agak. Bɨ yad ayɨp jɨmñɨl yenɨgab, yad ne ayɨp jɨmñɨl yenɨgayn ak, ne mɨdup kuŋay yɨbɨl pel pulɨnɨgab agak. Pen yad ayɨp jɨmñɨl ma yenɨgabɨm ak, tap olap gɨnɨmɨb tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pen bɨ yad ayɨp jɨmñɨl ma yonɨmuŋ ak, nag lek tɨb sak dɨyokel mɨlep gɨ yapek, dɨl mab dagɨlɨpal tek ak yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nɨbi yad ayɨp jɨmñɨl yenɨgabɨm, takaw yad ak nɨb ayɨp jɨmñɨl yenɨgab ak, takaw tɨtay gos nɨgɨnɨgabɨm ak agnɨgenɨmɨb, agɨnɨgabɨm tek gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɨbi nag lek tek mɨdup kuŋay yɨbɨl pulɨnɨmɨb tek, binɨb okok kɨli nɨbop bɨyad yenɨmɨb ak nɨŋɨd, Bapi yɨb nop ak dad aplanɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Bapi ne yɨp mapen yɨbɨl lup tek, nɨbop pen mapen yɨbɨl lɨpin agak. Nɨbi yad ayɨp yenɨmɨb, nɨbop mapen yɨbɨl lɨnɨgayn, mɨd dad amɨl yonɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yad Bapi takaw ne ak kɨdek gen, yɨp mapen yɨbɨl lɨl mɨdeb agak. Anɨb ak takaw yad ak kɨdek gem, nɨbop mapen yɨbɨl lɨl yenɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Pen yɨp tep gup tek, nɨbop abe tep gɨnɨgab agɨl gos nepin agak. Anɨgenɨgab, nɨbi mɨñmɨñ tɨmel yɨbɨl gɨl yenɨmɨb agak. Anɨb ak nɨŋɨd, takaw anɨb ak nɨbop apin agak. ");
INSERT INTO taw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Takaw adek yad ak anɨgɨl mɨdeb, nɨbop mapen lɨpin nep tek, nɨbi penpen mapen lɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bɨ olap bogɨlak ne okok kɨlop mapen yɨbɨl lɨlɨg, gɨñɨnɨg monmon kumnɨgab tek, bɨ anɨb ak nop mapen lep anɨb ak, tap awl yɨbɨl nɨŋɨd kumnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pen apin adek ak genɨmɨb, bogɨlak yad okok mɨdebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bɨ wog gɨñeb okok, kɨli bɨawl kod mɨdep kɨli ak, geb ak gɨnɨgab ak agɨl, ma nepal agak. Yad pen anɨgɨl ma gebin agak. Bapi takaw tɨtay mɨdupsek yɨp agñub okok, nɨbop agñɨbin agak. Ak nɨm mɨñɨl tɨkɨl, nɨbop bɨ wog gɨñeb yad mɨdebɨm ma agebin, bogɨlak tep yad mɨdebɨm agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nɨbi yɨp dun agɨl ma dɨpek, yad nɨbop aglɨl din agɨl dɨnek agak. Mɨdup pulɨl pelpel yenɨgab ak pulɨnɨgel agɨl, nɨbop tɨg asɨk ke lɨl, wog anɨb ak agyokɨnek agak. Anɨb ak nɨbi Jisas binɨb ne mɨdobun agɨl, Bapi nop tap tɨtay agnɨgenɨgabɨm, agɨnɨgabɨm tek nɨbop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Takaw adek yad ak nɨbop agebin, penpen mapen lɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Pen Jisas ne anɨb agak, Binɨb lum awl okok kɨli nɨbop mɨlɨk nɨgenɨgabal, gos anɨb ak sawl ma gɨl nɨgɨnɨmɨb, yɨp ned mɨlɨk nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pen binɨb lum awl pel gɨpal ak gɨpɨkep, binɨb chɨn agɨl, dɨl mapen lɨpɨlap agak. Nɨbi pen bɨ lum awl okok ma mɨdebɨm agak. Yad nɨbop ke nɨŋɨd aglɨl denek, lum awl adek anɨb ak kelɨgɨpek agak. Anɨgepek, binɨb lum awl okok nɨbop mɨlɨk nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pen takaw nɨbop apin ak, gos nɨgtep gɨnɨmɨb agak. Nɨbop anɨb apin, Bɨ wog gɨñeb ak, ne bɨawl ne tek ma yenɨgab apin agak. Ne yokɨp bɨ wog gɨñeb yenɨgab apin agak. Anɨb ak, yɨp gɨ tɨmel gelak, nɨbop abe gɨ tɨmel gɨnɨgabal agak. Pen takaw yad ak delak, takaw nɨbi ak abe dɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kɨli bɨ yɨp agyokek ownek ak, nop ma nepal anɨb ak tek, nɨbop gɨ tɨmel gɨnɨgabal agak. Anɨb ak, binɨb yad yɨl mɨdebɨm tek nɨbop anɨgɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Pen yad apɨl kɨlop takaw ma agñebɨnep, tap si tap tɨmel gɨpal ak, takaw awl yɨbɨl ma dɨpɨlap agak. Kɨli apal, Chɨn tap tɨmel gɨpun agɨl ma nopun apal agak. Yad pen mɨñɨl apɨl kɨlop agñɨtep gen, kɨli takaw anɨb ak agɨnɨgel tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bɨ yɨp mɨlɨk nɨgup ak, yɨp nokom mel, Bapi nop abe mɨlɨk nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yad apɨl kɨlop nab okok tap mageptek okok gɨnek, tap anɨb okok bɨ olap ned ma yɨbɨl gak agak. Anɨb ma gepɨnep, tap si tap tɨmel gɨpal ak, takaw awl yɨbɨl ma dɨpɨlap agak. Mɨñɨl pen tap mageptek okok gen nɨŋɨd, yɨp mɨlɨk nepal Bapi nop abe mɨlɨk nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gɨpal anɨb ak, God takaw ak tɨkɨl agak tek gɨpal agak. Juda kay takaw adek, buk Baybol kɨli ak tɨkɨl agak, Takaw jɨj ma mɨdeb, yɨp yokɨp yɨbɨl mɨlɨk nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bɨ Gɨtep Gep ak nop agyoken, Bapi yɨl apɨl nɨbop ownɨgab agak. Ne Kawnan takaw nɨŋɨd yɨbɨl agup ak mɨdeb agak. Bapi yɨl apɨl, yɨp bɨ tay tek ak nɨbop agtep gɨl agñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pen nɨbi yad ayɨp wog jɨj gɨl gɨ dad amɨl mɨdobun anɨb ak tek, nɨbi abe yɨp bɨ tay tek ak binɨb okok kɨlop agtep gɨl agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nɨbi gos nepɨm ak kelɨgɨl ma apyap pakɨnɨmɨb agɨl, nɨbop takaw anɨgɨl apin ak agak. ");
INSERT INTO taw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","3","Nɨbop Juda apnan gɨpal kal okok ag seŋ yokɨl, tepayaŋ ma ownɨmɨb agɨnɨgabal agak. Pen anɨb anep mel agak. Kɨdek ñɨn ak Bapi chɨlopapɨl ma nepal tek, anɨgon God nop tep gɨnɨmuŋ agɨl, nɨbop paklɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pen nɨbop takaw anɨgɨl apin ak nɨm, kɨdek ñɨn ak tay gek nɨŋɨd, agɨnek tek geb agɨl nɨgtep gɨnɨgabɨm agak. Pen Jisas ne anɨb agak, Nɨb ayɨp nep yelɨgɨpin tek, takaw anɨb ak ma agɨnek agak. ");
INSERT INTO taw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mɨñɨl pen bɨ yɨp agyokek ownek ak yɨl adɨkɨd amebin tek, nɨbop agebin agak. Pen nɨbi olap, akal ameban agɨl, yɨp ma agnepɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Takaw anɨb ak agen nɨgem, mɨdupmɨdup nɨbop ak puŋɨl ñak agak. ");
INSERT INTO taw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pen yad nɨbop takaw nɨŋɨd apin, nɨbop kelɨgɨl amebin ak, tep yɨbɨl amebin agak. Yad ma amenɨgayn, Bɨ Gɨtep Gep ak nɨbop kod yenɨgab ak ma ownɨgab agak. Pen yad amnɨgayn ak, nop agyoken nɨbop ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne apɨl binɨb lum awl okok kɨlop gek, tap si tap tɨmel gep jɨj ak nɨgtep gɨl, suŋtep mɨdep jɨj ak nɨgtep gɨl, God binɨb okok bɨlokep jɨj ak nɨgtep gɨl gɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tap si tap tɨmel gep jɨj ak anɨgɨl mɨdeb, yɨp gos ma lɨnepal agak. ");
INSERT INTO taw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Suŋtep mɨdep jɨj ak anɨgɨl mɨdeb, yad am Bapi ayɨp yenɨgayn ak, yɨp pel ma nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","God binɨb okok bɨlokep jɨj ak anɨgɨl mɨdeb, bɨawl binɨb lum awl yɨl ak kɨlop kodup ak, God bɨ anɨb anop bɨlokɨl ag gɨl agup, Yul awl yɨbɨl dɨnɨmɨn agup agak. ");
INSERT INTO taw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Takaw yad kuŋay yɨbɨl mɨdeb ak pen, takaw anɨb okok mɨñɨl agen, nɨg dɨnɨmɨb tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pen God Kawnan nɨŋɨd yɨbɨl agup ak apɨl, nɨbop gos ñek takaw nɨŋɨd yɨbɨl mɨdupsek nɨgɨnɨgabɨm agak. Takaw ne ke dɨl ma agɨnɨgab, God takaw agɨnɨgab ak nɨŋɨd agɨnɨgab agak. Pen kɨdek gɨnɨgab takaw ak nɨbop agñɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ne takaw yad ak dɨl nɨbop agñɨnɨgab agak. Agñɨnɨgab ak nɨm, yɨb yɨp dad aplanɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bapi tap ne okok, mɨdupsek tap yad mɨdeb, anɨb ak tek yad apin, God Kawnan ne ak takaw yad ak dɨl nɨbop agñɨnɨgab apin agak. ");
INSERT INTO taw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Pen Jisas ne anɨb agak, Sɨkol won olap mɨdɨl, yɨp ma yɨbɨl nɨgɨnɨgebɨm agak. Pen kɨdek sɨkol won olap mɨdɨl, yɨp tepayaŋ nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisas anɨb agek, bɨne ogɨnap kɨli ke nep agɨlak, Takaw chɨnop agup ak jɨj anɨb ak tay agɨlak? Ne agup, Sɨkol won olap mɨdɨl, yɨp ma yɨbɨl nɨgɨnɨgebɨm pen, kɨdek sɨkol won olap mɨdɨl, yɨp tepayaŋ nɨgɨnɨgabɨm agup agɨlak. Pen abe anɨb agup, Jɨj anɨb ak anɨgɨl mɨdeb, yad Bapi yɨl amebin agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anɨb ak agɨlɨg agɨlak, Sɨkol won olap mɨdɨl agup ak, tap anɨb ak tay agɨlak? Takaw agup anɨb ak, jɨj ak ma nopun agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Anɨb agɨl, Jisas nop agnɨgɨnɨg gelak, ne ke nɨŋɨd kɨlop agak, Sɨkol won olap mɨdɨl, yɨp ma yɨbɨl nɨgɨnɨgebɨm ak pen, kɨdek sɨkol won olap mɨdɨl, yɨp tepayaŋ nɨgɨnɨgabɨm apin ak nɨŋɨd nɨm, penpen agnɨgebɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nɨbop nɨŋɨd yɨbɨl agebin, nɨbop chɨb gek, chaŋ lɨl yenɨgabɨm ak pen, binɨb lum awl okok mɨñmɨñ gɨnɨgabal agak. Gos awl nɨŋɨd chaŋ lɨnɨgabɨm ak pen, chaŋ kelɨgɨl mɨñmɨñ gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bin olap ñapay ñɨŋaknɨŋ, gos awl nɨgup ak pen, ñapay won ak tɨkɨl, gos awl ma nɨgup agak. Tɨkek, ñapay ne lum awl owup ak nɨm, nop tep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Anɨb ak, nɨbi mɨñɨl gos awl nɨgebɨm agak. Yad pen nɨbop tepayaŋ nɨgem, nɨbop tep yɨbɨl gɨnɨgab agak. Anɨgek, mɨñmɨñ nɨbi anɨb ak bɨ olap tɨbɨlɨkɨnɨmuŋ tek ma lɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pen ñɨn anɨb ak, yɨp ma agnɨgɨnɨgabɨm agak. Nɨbop nɨŋɨd yɨbɨl agebin, nɨbi Jisas binɨb ne mɨdobun agɨl, Bapi nop tap tɨtay agnɨgenɨgabɨm, agɨnɨgabɨm tek nɨbop ñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ned Jisas binɨb ne mɨdobun agɨl, God nop ma agnepek agak. Mɨñɨl pen God nop agnɨgem, agnɨgɨnɨgabɨm tek dɨnɨgabɨm ak nɨm, nɨbop tep tɨmel yɨbɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Pen Jisas ne anɨb agak, Takaw nɨbop apin anɨb okok, pel takaw paladaŋ lɨl apin ak pen, kɨdek takaw anɨb ak tek ma agɨnɨgayn agak. Bapi jɨj ne anɨgɨl mɨdeb ak agɨnɨg, mɨseŋ yɨbɨl agñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ñɨn anɨb ak apek, Jisas binɨb ne mɨdobun agɨl, Bapi nop agnɨgɨnɨgabɨm agak. Pen yɨp agnɨgem, yad pen Bapi nop agnɨgɨnɨgayn agɨl, ma agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bapi ne ke nɨbop mapen lup agak. Nɨbi yɨp mapen lɨl, yad God yɨl ownek ak gos nepɨm agak. Anɨb ak, nɨbop mapen lup tek, agnɨgem nɨbop nɨgɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ned Bapi yɨl apɨl, lum awl ownek agak. Mɨñɨl lum awl kelɨgɨl, Bapi yɨl adɨkɨd amebin agak. ");
INSERT INTO taw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Anɨb agek, bɨne okok agɨlak, Ey, mɨñɨl takaw paladaŋ lɨl ma ageban, mɨseŋ yɨbɨl ageban agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ak nɨm chɨn nopun, nad tap okok mɨdupsek nepan agɨlak. Bɨ olap takaw won olap mɨdeb nep agnɨgɨnɨgab ak, nep ma agnɨgup won ak, nad ke nɨŋɨd nop agñɨban agɨlak. Gɨpan anɨb ak chɨn gos nopun, nad God yɨl ownak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Anɨb agelak, Jisas kɨlop pen agak, Mɨñɨl yɨp gos lɨnɨgebɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nɨgɨm. Ñɨn ak wulep wulep apeb ak pen apjakup, nɨbop yuk yokel, yɨp kelɨgɨl man nɨbi keke amem, yad ke awsek yenɨgayn agak. Pen Bapi ayɨp yonɨgabul anɨb ak tek, ke awsek ma yenɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nɨbi yad ayɨp jɨmñɨl mɨdɨl mɨdtep gɨnɨmɨb agɨl, takaw anɨb okok nɨbop agñɨbin agak. Lum awl mɨdɨl, nɨbop mɨŋel gɨnɨgab ak pen, gos sek yenɨmɨb agak. Tap lum awl yɨl ak mɨdupsek taw jɨsɨpuk gɨpin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas takaw anɨb ak agjuwɨl, kɨlan gɨl nɨŋɨd agak, Bapi, ñɨn aglɨnak ak mɨñɨl owup agak. Nad Ñɨnak nop ge yɨb awl dɨnɨmuŋ agak. Anɨge, Ñɨnak ak nep gek yɨb awl dɨnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pen nop agle, binɨb okok mɨdupsek kɨlop kod yek agak. Binɨb nop ñɨnak okok, kɨlop gek pel pelnep yenɨgel agak. Anɨb ak nɨm, nop agle, binɨb okok mɨdupsek kɨlop kod yek agak. ");
INSERT INTO taw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pen pel pelnep mɨdebal anɨgɨl mɨdeb agak. Bɨ pel mɨdep dɨpal okok, kɨli nad nokom God nɨŋɨd yɨbɨl mɨdeban ak nɨŋɨd, Jisas Klays nop agyokɨnak ak nɨŋɨd gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yad nep gen yɨb awl dɨnɨmɨn agɨl, yɨp wog agɨnak ak, gɨ dad amɨl gɨjupin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mɨñɨl ge yɨb awl denɨm, man ma alwol gɨlɨlok ñɨn ak, omɨŋal gɨl Bɨawl yɨb yɨlok tek yonɨgul agak. ");
INSERT INTO taw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Bɨ lum awl mɨdebal yɨp agɨnak okok, mɨñɨl bɨyad mɨdebal ak, nad bɨ tay tek mɨseŋ nɨgɨnɨgel agɨl, kɨlop agñɨtep gɨnek agak. Nak yɨl yelak ak pen, yɨp agɨnak nɨm, bɨyad mɨdɨl, takaw nad ak dɨl kɨdek gɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pen mɨñɨl nepal, tap tɨtay yɨp ñɨban ak, ke nep ma dɨpin agak. Yɨp ñɨban adek ak nep dɨpin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Takaw yɨp agñɨnak okok, bɨyad okok kɨlop agñen dɨlak agak. Agñen dɨl nɨgɨlak ak nɨm, nad yɨp agyoke nad ayɨp mɨdɨl ownek ak, nɨgtep yɨbɨl gɨlak agak. ");
INSERT INTO taw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Bɨ yɨp agɨnak anɨb okok, bɨ nad mɨdebal tek, kɨlop kod yenɨmɨn agɨl, nep agnɨgebin agak. Binɨb lum awl okok kɨlop kod yenɨmɨn agɨl, nep ma agnɨgebin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bɨyad okok, bɨ nad mɨdebal agak. Pen bɨ nad okok, bɨyad mɨdebal agak. Pen binɨb yokɨp okok kɨli bɨ chɨlapɨl okok kɨlop nɨgel, yɨb awl dɨpin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nad mɨdeban ak nɨnɨgebin agak. Yad lum awl pel ma yenɨgayn, bɨyad pen kɨli lum awl yenɨgabal agak. Bapi, nad bɨ suŋtep yɨbɨl mɨdeban agak. Nad bɨawl yɨb awl mɨdeban tek, yɨp age abe mɨdebin agak. Nad yɨb awl mɨdeban anɨb ak, kɨlop kod yenɨmɨn, chɨlapɨl bɨ nokom tek lup ak tek, kɨli abe jɨj nokom jɨmñɨl yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nad bɨawl yɨb awl mɨdeban tek, yɨp age abe mɨdebin agak. Anɨb ak tek, ñɨn ak yad kɨli ayɨp nep mɨdɨl, kɨlop kod mɨdtep yesɨpin agak. Kod mɨdtep gen, olap ma kul gup agak. Bɨ ne kul gep tek anep, buk Baybol gɨnɨgab agɨl tɨkɨlak tek nep kul gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pen mɨdeban ak nɨnɨgebin tek, mɨñɨl bɨyad okok kɨli nɨg yelaknɨŋ, nep takaw anɨb awl agebin agak. Lum awl mɨdɨl agebin anɨb ak nɨgel, yɨp tep yɨbɨl geb tek, kɨlop abe tep yɨbɨl gɨnɨmuŋ agɨl agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yad takaw nad ak bɨyad okok kɨlop agñɨbin tek, binɨb lum awl okok kɨli, kɨlop mɨlɨk nepal agak. Yad bɨ lum awl olap ma mɨdebin tek, bɨyad okok kɨli abe mɨdebal anɨb ak tek, kɨlop mɨlɨk nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pen kɨlop dad ame, lum awl kelɨgɨl amnɨlaŋ agɨl ma agebin agak. Kɨlop lum awl kod yenɨmɨn, bɨ tɨmel ak kɨlop gɨ tɨmel ma gɨnɨmuŋ agɨl agebin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yad bɨ lum awl olap ma mɨdebin tek, bɨyad okok kɨli abe mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Takaw nad ak nɨŋɨd yɨbɨl mɨdeb agak. Anɨb ak takaw nad ak age, kɨlop gek bɨ nad mɨdɨl, nep malɨk mɨñ gɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yɨp agyoke binɨb lum awl yɨl ownek tek, bɨyad okok kɨlop agyoken binɨb lum awl yɨl abal agak. ");
INSERT INTO taw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yad bɨ malɨk nad yɨbɨl mɨdebin tek, kɨlop gos nɨŋɨd gen, kɨli abe bɨ malɨk nad yɨbɨl okok pɨsnep yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pen bɨyad anɨb okok kɨlop nep ma agnɨgebin agak. Kɨli takaw agñel, binɨb nɨŋɨd yɨp gos lɨnɨgɨnɨgabal okok kɨlop abe agnɨgebin agak. ");
INSERT INTO taw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chɨlapɨl keke mel, bɨ nokom yɨbɨl mɨdobul tek, binɨb yɨp gos lɨnepal okok, mɨdupsek jɨmñɨl anɨb ak tek yenɨgel agak. Anɨb ak tek kɨli chɨl ayɨp jɨmñɨl mɨdel, binɨb yokɨp okok nɨŋɨd, nad nokom yɨp agyoke ownek ak nɨgɨnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yɨb awl yɨp ñɨban ak, yad pen kɨlop ñɨbin anɨb ak tek, chɨl jɨmñɨl mɨdobul tek kɨli anɨb ak nep yenɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yad kɨli ayɨp nep mɨdebin, nad yad ayɨp nep mɨdeban anɨb ak tek, kɨli jɨmñɨl mɨdtep gɨnɨgel agak. Jɨmñɨl mɨdelaknɨŋ, binɨb lum awl yɨl nɨgɨnɨgel, nad yɨp agyoke ownek agak. Pen abe nɨgɨnɨgel, yɨp mapen lɨpan nep tek, binɨb yad okok kɨlop mapen lɨpan agak. ");
INSERT INTO taw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bapi, binɨb yɨp agɨnak okok, yad akal mɨdebin ak kɨli ayɨp nep yonɨgun agɨl nɨgebin agak. Ayɨp mɨdon, bɨawl yɨbɨl yɨb awl yonɨmuŋ agɨl yɨp ñɨnak tek yeneknɨŋ, yɨp nɨgɨnɨgel agak. Man ma alwol gɨlak ñɨn ak, yɨp mapen lɨnak anɨb ak tek, bɨawl yɨbɨl yɨb awl yonɨmuŋ agɨl yɨp ñɨnak agak. ");
INSERT INTO taw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bapi, nad nɨm bɨ tep yɨbɨl gep agak. Binɨb lum awl yɨl okok nep ma nepal, yad pen nep nepin agak. Pen binɨb yad okol, nad yɨp agyoke ownek ak nepal agak. ");
INSERT INTO taw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nad yɨp mapen lɨpan tek nɨgtep gɨnɨgel, binɨb okok kɨlop anɨgɨnɨgel agɨl gos nepin agak. Pen yad abe kɨli ayɨp yenɨm agak. Anɨb ak nɨm, nep bɨ tay tek ak kɨlop yobin agak. Pen anɨgɨl pel yomnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas Nap nop takaw agnɨg juwɨl, bɨne okok ayɨp amɨl ñɨg jɨluŋ olap tɨkɨlak. Ñɨg jɨluŋ anɨb ak, yɨb Kidlon apal ak. Pɨs kɨd adaŋ amɨl, wog day yek mɨgan amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pen wog anɨb ak, Jisas ayɨp bɨne okok ayɨp pel apnan gelɨgɨpal anɨb ak tek, Judas bɨ Jisas nop chen mɨmug gak ak, tep anɨb ak nɨgtep gak. ");
INSERT INTO taw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ne apɨl, bɨ chɨm kadɨŋ gep ogɨnap dad owak. Pen bɨ God nop sɨbogep bɨawl okok sek, bɨ Pelisi okok sek, kɨli polis kɨli ogɨnap kɨlop agyokel, Judas ne apɨl polis anɨb okok abe dad owak. Kɨlop dɨl poŋɨd, kɨli sup ogɨnap, lam ogɨnap, tap chɨm kadɨŋ gep okok ogɨnap dɨl, wog day anɨb ak dad apjakɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pen Jisas nop tap tɨtay gɨnɨg gɨlak ak ne ke nɨgak ak nɨm, apelak sɨŋak amɨl agak, An nop pɨyow ajebɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Agek pen agɨlak, Jisas bɨ Nasalet nɨb agɨlak. Agel agak, Nɨm yad agak. Agak anɨb won ak nep, Judas ne bɨ Jisas nop chen mɨmug gak ak, kɨli ayɨp anɨb wagen sɨŋak jakɨl yek. ");
INSERT INTO taw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pen Jisas agak, Nɨm yad agek, kɨli pɨlɨk keke sɨŋadaŋ amɨl, apyap pakɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pen kɨlop tepayaŋ agnɨŋɨd agak, An nop pɨyow ajebɨm agak? Agek agɨlak, Jisas bɨ Nasalet nɨb agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Agel pen agak, Nɨbop mɨneyɨl apin, Nɨm yad apin agak. Yɨp pɨyow ajɨlɨg yɨl nɨm, bɨ okol kɨlop kelɨgem amnɨgel agak. ");
INSERT INTO taw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tap gak anɨb ak, Jisas ned Nap nop agak tek nep gak. Ne ned agak, Bɨ yɨp agɨnak okok, olap ma kul gup mɨdebal agak. ");
INSERT INTO taw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pen Saymon Pita baynat dad owak ak lɨpɨg dɨl, bɨ olap nop tɨmud yɨpɨd kɨd ak pɨsnep tɨbɨlɨk yokak. Bɨ anɨb ak, ne bɨ God nop sɨbogep bɨawl yɨbɨl ak wog gɨñeb ne olap, yɨb ne Malkus. ");
INSERT INTO taw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pita anɨgek, Jisas agak, Baynat dɨpan ak tepayaŋ lan agak. Ñɨg sɨlek kɨnag Bapi yɨp ñub ak, ma ñɨŋɨnɨmuŋ agɨl nepan agak? ");
INSERT INTO taw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jisas anɨb agaknɨŋ, bɨ chɨm kadɨŋ gep okok sek, bɨawl yɨbɨl kɨli ak sek, Juda bɨ polis okok sek, kɨli Jisas nop chɨchɨk dɨl, tun gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tun gɨl, nop dad Anas yek ak ned amnɨlak. Bɨ Anas anɨb ak, Kayapas nɨmak ne. Kayapas nɨm, bɨ God nop sɨbogep bɨawl yɨbɨl ak, sub nokom anɨb ak aglelak wog gɨ yek. ");
INSERT INTO taw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Pen Kayapas ne nokom nɨm, ned Juda bɨawl okok kɨlop anɨb agak, Bɨ nokom olap chɨnop nen agɨl kumenɨgab, tep yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pen Jisas nop anɨgɨl dad Anas yek ak amnɨlaknɨŋ, Saymon Pita ayɨp, Jisas bɨne olap ayɨp, kɨdek kɨdek amnɨlek. Bɨ God nop sɨbogep bɨawl yɨbɨl ak, ne Jisas bɨne anɨb anop nɨgtep gak. Anɨb ak tek, ne Jisas nop kɨdek gɨl, bɨ God nop sɨbogep bɨawl yɨbɨl kal ne ak wali mɨgan ayaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita pen seŋayaŋ kanɨbtub sɨŋak jak yek, anɨb ak Jisas bɨne anɨb ak adɨkɨd apɨl, bin kanɨbtub kod yek anop agɨl, Pita nop poŋɨd wali mɨgan ayaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pen bin kanɨbtub kod yek ak, ne Pita nop agak, Nad abe bɨne olap tek lup agak? Agek agak, Yad mel agak. ");
INSERT INTO taw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pen bɨ wog gɨñeb okok sek, Juda polis okok sek kɨlop takɨl gek, mab olap nab anɨb sɨŋak dagɨl, jakɨl nep mɨŋɨl yelak. Pita nop abe takɨl gek, ap kɨli ayɨp jakɨl nep mɨŋɨl yek. ");
INSERT INTO taw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pen bɨ God nop sɨbogep bɨawl yɨbɨl ak ne Jisas nop agnɨgak. Bɨne tɨtay dɨl wog gelɨgɨpal ak sek, takaw ne tɨtay agñolɨgup ak sek nop agnɨgak. ");
INSERT INTO taw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Anɨgɨl agnɨgek Jisas pen nop agak, Yad takaw ogɨnap we gɨl ma agñɨnek agak. Bɨ Juda okok kɨli mɨdupsek pel apnan gɨl nɨg yelaknɨŋ, Juda apnan gɨpal kal okok sek, God agnɨgep kal awl ak sek, pel mɨseŋ agñɨbin agak. ");
INSERT INTO taw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Anɨb ak taynen yɨp agnɨgeban agak? Binɨb yɨp nɨgɨlak okol, takaw agɨnek ak nepal tek lup ak, kɨlop agnɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas anɨb agek, Juda polis olap jak mɨdɨlɨg, nop mɨkem kɨd sɨŋak pakɨl agak, Taynen nad bɨ God nop sɨbogep bɨawl yɨbɨl anop takaw anɨb ak tek ageban agak? ");
INSERT INTO taw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Agek pen agak, Takaw tɨmel olap agen, takaw tɨmel apin anɨb ak binɨb okol kɨlop agtep agñan agak. Pen takaw nɨŋɨd yɨbɨl ak agen, taynen yɨp pakɨpan agak? ");
INSERT INTO taw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pen Anas ne Jisas nop tun gɨlak tek mɨdaknɨŋ agek, dad Kayapas bɨ God nop sɨbogep bɨawl yɨbɨl yek ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pen Saymon Pita ne anɨgɨl nep jakɨl mab mɨŋɨl mɨdaknɨŋ, bɨ ogɨnap nop agɨlak, Nad abe bɨne olap tek lup agɨlak? Agel, ag sɨlokɨl agak, Yad mel agak. ");
INSERT INTO taw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pen bɨ God nop sɨbogep bɨawl yɨbɨl ak, bɨ wog gɨñeb ne olap yek. Bɨ wog gɨñeb ne anɨb ak, Pita bɨ tɨmud tɨbɨlɨkak ak, bɨne jɨmñɨl adek nokom anep tɨk damɨl tɨkɨpal olap yek. Pen ne Pita nop agak, Yad nep nepin, nak bɨ anɨb ak ayɨp wog day ak yesɨpil tek lup agak. ");
INSERT INTO taw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Agek, Pita tepayaŋ ag sɨlokɨl agak, Mel agak. Anɨb agaknɨŋ, anɨb won ak nep yawl kakaluk abe suk agak. ");
INSERT INTO taw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Man tɨkaknɨŋ, Juda bɨawl okok kɨli Jisas nop dɨl, Kayapas kal ak nɨb, dad Lom gapman bɨawl yek kal ak amnɨlak. Juda binɨb Pasopa tap ñɨŋɨnɨg gɨlak tek, Lom gapman bɨawl kal mɨgan amonɨgabun, chɨnop asɨŋ wɨlɨkɨnɨgab agɨl, seŋayaŋ yelak. ");
INSERT INTO taw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Anɨgɨl nep yelaknɨŋ, Paylat seŋ amɨl kɨlop agak, Bɨ nɨm awl nop tay takaw nɨŋɨd dad opɨm agak? ");
INSERT INTO taw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Agek pen agɨlak, Ne tap tɨmel olap ma gɨpɨkop, nop anɨgɨl ma dad opɨnop agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Agel Paylat kɨlop agak, Nɨbi nop damɨl takaw nɨbi kɨdek gɨpɨm pal ak nɨŋɨd, takaw nop tɨg asɨkɨm agak. Agek Juda bɨawl okok nop agɨlak, Chɨn bɨ olap nop ñaglon kumnɨgel agɨl olap ma mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Agɨlak anɨb ak, Jisas yɨp anɨgɨl paklɨnɨgabal agɨl, ned agak tek nep gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pen Juda bɨawl okok anɨb agelak, Paylat tepayaŋ adɨkɨd kal mɨgan ayaŋ amɨl, Jisas nop suk agek apek agak, Nak Juda bɨnonɨm kɨli ak akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Agek Jisas pen agak, Takaw yɨp agnɨgeban ak, gos nak ke nɨŋɨd ageban akaŋ, bɨ ogɨnap nep agñɨlak ak dɨl ageban agak? ");
INSERT INTO taw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Agek Paylat pen agak, Taydɨl? Yad bɨ Juda kay olap akaŋ agak? Pen binɨb nak okok sek, bɨ God nop sɨbogep bɨawl okok sek, kɨli nep dad apɨl yɨp opal agak. Nak tɨtay dɨpan agak? ");
INSERT INTO taw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Agek Jisas pen agak, Yad binɨb dɨl kod mɨdebin ak, bɨnonɨm lum awl mɨdebal tek ma mɨdebin agak. Yad lum awl bɨnonɨm mɨdebɨnep tek, Juda bɨawl okok yɨp nag lun agel, binɨb yad okok tɨkjakɨl, kɨli ayɨp penpen ñapɨlap agak. Pen yad binɨb dɨl kod mɨdebin ak anɨb ak ke mɨdeb, bɨnonɨm lum awl mɨdebal tek mel agak. ");
INSERT INTO taw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Agek Paylat agak, Anɨb ak nad bɨnonɨm olap akaŋ agak? Agek Jisas pen agak, Nɨm nak ke apan ak agak. Pen ami yɨp tɨkek, yad takaw nɨŋɨd yɨbɨl ak agñɨnɨg lum awl ownek agak. Binɨb takaw nɨŋɨd yɨbɨl ak dɨnɨgun agɨl nepal okok, takaw yad ak nɨŋɨd dɨpal agak. ");
INSERT INTO taw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Anɨb agek Paylat agak, Pen tɨtay dɨl takaw nɨŋɨd yɨbɨl ak nɨgɨnɨgun agak? Paylat takaw anɨb ak agɨl, tepayaŋ adɨkɨd seŋ amɨl, Juda kay kɨlop agak, Ne tap tɨmel olap gup ma pɨyow nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pen yad sub ak sub ak, Pasopa ñɨn awl ak owup, nag lep bɨ nɨbi olap yokɨp wɨsɨb yokɨpin agak. Anɨb ak, Juda bɨnonɨm anɨb ak, nop yokɨp wɨsɨb yoken nɨbop amnɨmuŋ akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Agek, kɨli meg mɨgan dad aplanɨl agɨlak, Nop mel. Chɨnop Balabas nop wɨsɨb yokɨnɨmɨn agɨlak. Bɨ Balabas anɨb ak, bɨ tap si dep penpen ñagep olap. ");
INSERT INTO taw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Juda binɨb okok anɨb agelak, Paylat bɨ chɨm kadɨŋ gep ne okok kɨlop agek, Jisas nop dad nag ñuñu dɨl tapɨn yɨbɨl pakɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Anɨgɨl pakɨl, nag ñuñu sek ogɨnap dɨlɨg dɨ kos bol gɨl kɨmɨg nop alaŋ tol gɨñɨlak. Bɨnonɨm nag lelɨgɨpal tek, Jisas nop abe gɨñɨlak. Gɨñɨl, chech nɨkɨm palsek olap lɨñɨl, ");
INSERT INTO taw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","nop yek sɨŋak am ap gɨlɨg agɨlak, Juda bɨnonɨm kɨli ak, pelnep yenɨmɨn agɨlak. Anɨb agɨlɨg, mɨkem nop pakɨlɨg pakɨlɨg gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pen Paylat tepayaŋ seŋ amɨl, Juda binɨb okok kɨlop agak, Nɨgɨm. Nop dɨl, dad seŋ awl nɨbop apen nɨgɨnɨmɨb, ne tap tɨmel olap gup ak ma pɨyow nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Anɨb agek, Jisas kɨmɨg nop nag ñuñu sek ak gɨñɨl, chech nɨkɨm palsek ak lɨñel, seŋ owaknɨŋ Paylat kɨlop agak, Nɨgɨm, bɨ anɨb ak nɨm ak agak. ");
INSERT INTO taw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pen bɨ God nop sɨbogep bɨawl okok sek, Juda polis okok sek kɨli nop nɨŋɨd, suk awl agɨl agɨlak, Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ. Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. Agelak Paylat kɨlop agak, Nɨbi ke nop dad amɨl, mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agak. Yad tap tɨmel olap gup ak ma pɨyow nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Agek, Juda kay pen agɨlak, Ne ke agup, God Ñɨne mɨdebin agup agɨlak. Pen takaw adek chɨn Mosis ñu kɨl tɨkak olap mɨdeb, takaw anɨb ak agak, Bɨ olap agup anɨb ak, kumnɨmuŋ agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Anɨb agelak nɨŋɨd, Paylat jel awl yɨbɨl gek pɨlɨkɨl, ");
INSERT INTO taw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","adɨkɨd kal mɨgan ayaŋ amɨl, Jisas nop agnɨŋɨd agak, Nad man akal nɨb agak? Agek, takaw olap pen ma yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Anɨgek, Paylat agak, Tɨtay dɨl yɨp takaw ma ageban agak? Yad nokom nep kod mɨdebin, ak nad ma nepan akaŋ agak? Wɨsɨk yokɨnɨg wɨsɨk yokɨnɨgayn, pen mab bak alaŋ chɨpɨl pak tɨbɨk lɨnɨmɨb agen, chɨpɨl pak tɨbɨk lel kumnɨgaban agak. ");
INSERT INTO taw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Agek Jisas pen agak, Pen yɨp kod mɨdeban ak nad ke mel, God nokom adek alaŋ mɨdeb ak agek kod mɨdeban agak. Anɨb ak tap tɨmel yɨp geban ak, nak mɨŋel sɨkol olap dɨnɨgaban agak. Bɨ pen yɨp dad apɨl nep ñɨl, yɨp gɨ tɨmel yɨbɨl gup ak, mɨŋel awl yɨbɨl ak dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Anɨb agek, Paylat Jisas nop yokɨp agyokin agɨl gos nɨgak ak pen, Juda kay meg mɨgan dad aplanɨl agɨlak, Bɨ anɨb anop yokɨp agyokenɨgaban, Lom gapman bɨnonɨm ak bogɨlak ne ma mɨdeban agɨlak. Bɨ olap ne ke bɨnonɨm mɨdebin agup ak, Lom gapman bɨnonɨm ayɨp penpen ñagul agɨl nɨgup agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Anɨb agelak nɨŋɨd, Paylat Jisas nop poŋɨd seŋ apɨl, am bɨawl mɨj adek ak besɨgak. Tep adek besɨgak anɨb ak, Kab Simen Adek apal. Pen Hiblu takaw ak, Gabada apal. ");
INSERT INTO taw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pen ñɨn anɨb ak, Juda binɨb Pasopa tap kɨli nan gep ñɨn ak. Subnab won ak, Paylat Juda kay kɨlop agak, Nɨgɨm, bɨnonɨm nɨbi ak agak. ");
INSERT INTO taw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Agek, meg mɨgan dad aplanɨl agɨlak, Nop agyokan. Nop agyokan agɨlak. Nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agɨlak. Agel, Paylat kɨlop agak, Bɨnonɨm nɨbi ak, nop mab bak alaŋ chɨpɨl pak tɨbɨk len kumaŋ akaŋ agak? Agek, bɨ God nop sɨbogep bɨawl okok pen agɨlak, Bɨnonɨm chɨn olap ma mɨdeb, Lom gapman bɨnonɨm chɨn nokom mɨdeb agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pen anɨgɨl ag dad amɨl, Paylat takaw kɨlop ak dɨl, bɨ chɨm kadɨŋ gep ne okok kɨlop agak, Nop dam mab bak alaŋ chɨpɨl pak tɨbɨk lem kumaŋ agak. Paylat anɨb agek, Jisas nop dad amnɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pen Jisas ne ke mab nop chɨpɨl pak tɨbɨk lɨlak ak dɨl, man awl ak kelɨgɨl, dad amɨl man Chɨp Kɨmɨg Cheg Won apal ak amnak. Pen Hiblu takaw ak, Golgota apal. ");
INSERT INTO taw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Man anɨb ak amek, nop nab ayaŋ mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak. Pen bɨ omɨŋal ayɨp, olap pɨs olap pɨs mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pen Paylat abe agek, Jisas nop chɨpɨl pak tɨbɨk lɨlak mab bak alaŋ, yɨb tɨk lɨl agɨlak, Jisas bɨ Nasalet nɨb ak, Juda bɨnonɨm kɨli ak agɨl ñu kɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Takaw adek nokom anɨb anep, Hiblu takaw kɨl tɨkɨl, Lom takaw kɨl tɨkɨl, Glik takaw kɨl tɨkɨl gelak nɨm, man awl ak wulep anɨb sɨŋak yek tek, Juda binɨb kuŋay yɨbɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pen bɨ God nop sɨbogep bɨawl okok, kɨli amɨl Paylat nop agɨlak, Takaw anɨb ak Juda bɨnonɨm kɨli ak ma kɨl tɨkɨnɨmɨn agɨlak. Bɨ anɨb ak pen ne agup, Yad Juda bɨnonɨm kɨli ak agup takaw anɨb ak kɨl tɨkɨnɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Anɨb agelak, Paylat pen agak, Takaw tɨtay agɨl kɨl tɨkɨpin ak, anɨgɨl nep yonɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pen bɨ chɨm kadɨŋ gep okok, kɨli Jisas nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak won ak, chech tap ne yɨmak okok tɨg asɨk keke lel, tɨgawup oŋɨd amek keke dɨlak. Pen chech palsek ma ñag dɨlak ak, yɨmɨl yek abe tɨg asɨk dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pen ma ñag dɨlak ak nɨŋɨd, kɨli ke agɨlak, Ma tɨg talɨkɨnɨgun agɨlak. Yokɨp sadu tek gɨl, bɨ an kɨles gɨl dɨnɨmuŋ ak ne dɨnɨmuŋ agɨlak. Anɨb agɨl, sadu tek gɨl bɨ olap ne dak. Gɨlak anɨb ak, buk Baybol tɨkak adek ak nep gɨlak. Takaw anɨb ak kɨl tɨkɨl agak, Chech yad ak bɨlok keke dɨl, chech palsek yad ak dun agɨl, sadu tek gɨl bɨ olap ne dɨnɨmuŋ agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pen Jisas nonɨm ak, numkay ak, Maliya bɨ Klopas bin ne ak, Maliya taun Makdala nɨb ak, kɨli Jisas nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨlak ak gol sɨŋak jakɨl nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas nonɨm anɨgɨl yek nɨŋɨd, bɨne mapen yɨbɨl lolɨgup ak abe wulep anɨb sɨŋak jak yek ak nɨm, Jisas ne ami nop agak, Bin, ñɨ nad nɨm pi ak agak. ");
INSERT INTO taw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Anɨb agɨl, bɨne anɨb ak nop agak, Nanɨm nad nɨm pi ak agak. Anɨb agek, kɨdek won ak bɨne anɨb ak nonɨm nop poŋɨd kal ne amɨl, kod yolɨgup. ");
INSERT INTO taw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pen Jisas nɨgak, wog ne ak mɨdupsek gɨjup ak nɨm, buk Baybol takaw tɨkɨlak ak nɨŋɨd yɨbɨl lɨnɨmuŋ agɨl agak, Yɨp kuŋam mɨlep gup agak. ");
INSERT INTO taw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pen ñɨg wayn sɨlek kɨnag olap sɨŋak yek ak nɨm, kɨli nop yɨmug nɨŋɨd, tap sayn bad olap dɨl, ñɨg wayn sɨlek anɨb ak tawɨl, dɨl mab lek ak olap kabes ñagɨl, dad aplanɨl Jisas joŋɨb adek nop alaŋ ak lɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lelak, Jisas ñɨg wayn sɨlek ak ñɨbɨl agak, Nɨm tep agak. Agɨl jel kuyan gɨl, kawnan ne ak nop kelɨgɨl amnak. ");
INSERT INTO taw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pen ñɨn anɨb ak, Juda binɨb tap kɨli nan gep ñɨn ak. Tol Juda añɨŋ lep ñɨn awl anɨb ak, ñɨn awl yɨbɨl kɨli ownɨgab anɨb ak nɨm, chɨp okok mab bak alaŋ ma yonɨmuŋ agɨl nɨgɨlak. Anɨgɨl nɨŋɨd, am Paylat nop agnɨŋɨd agɨlak, Bɨ mab bak alaŋ chɨpɨl pak tɨbɨk lɨpal okok, tob kɨlop okok pak pagel kasek kumel, dɨ lum ayaŋ lɨnɨgel agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Agelak, Paylat bɨ chɨm kadɨŋ gep ne okok kɨlop agek, am bɨ Jisas ayɨp mab bak alaŋ chɨpɨl pak tɨbɨk lɨpal omɨŋal ak, tob kɨlop pak pagɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pen Jisas nop amɨl nɨgɨlak, ne kumak. Anɨb ak tob nop ak ma pak pagɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bɨ chɨm kadɨŋ gep olap pen, kusal ak dɨl, Jisas nop tɨgɨlem ajɨŋ sɨŋak puŋɨlek, won anɨb anep nɨkɨm sek ñɨg sek yowak. ");
INSERT INTO taw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Pen bɨ Jisas nop gɨlak anɨb ak wɨdɨn ne ke nɨŋɨd, binɨb okok kɨlop agñub. Takaw agñub anɨb ak, takaw nɨŋɨd yɨbɨl ak. Pen ne nɨgup, takaw ne nɨŋɨd agup anɨb ak, nop gos lɨnɨgɨnɨmɨb. ");
INSERT INTO taw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pen gak anɨb ak, buk Baybol ak agɨl kɨl tɨkɨlak tek nep gak. Tɨkɨl agɨlak, Tɨŋɨl nop ak, olap ma pak pagɨnɨgabal agɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pen takaw olap tɨkɨl agɨlak, Bɨ puŋɨlak anop nɨgɨnɨgabal agɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pen bɨ man sɨkol Alimateya nɨb olap yek. Ne Jisas bɨne olap pen, Juda bɨawl okok kɨlop nɨŋɨd pɨlɨkɨl, mɨseŋ ma agolɨgup. Bɨ anɨb ak yɨb ne Josep. Jisas nop gɨlak ak gɨjuwɨlak, Josep ne Jisas nop dad amnin agɨl, am Paylat nop agnɨgek, yaw agek, am dɨnɨg amnak. ");
INSERT INTO taw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Amek, bɨ Nikodemus ned am Jisas nop maynab ayaŋ nɨgak ak, tap kuy tep owep ak kuŋay yɨbɨl dad, Josep ayɨp amnɨlek. Tap kuy tep owep anɨb ak, mab Mul apal mok ak sek, mab Alos apal mok ak sek dɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kɨli bɨ omɨŋal amɨl Jisas nop kamnɨg, Juda binɨb gelɨgɨpal tek gɨlek. Mab mok kuy tep owep ak dad amnɨlek okok, wak nop okok wikɨl, chech tep bad okok dɨl kam sɨlokɨlek. ");
INSERT INTO taw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas nop mab bak alaŋ chɨpɨl pak tɨbɨk lɨpal wulep anɨb sɨŋak, wog day olap yek. Pen wog day nab anɨb ak, chɨp kaw koŋɨm kab mɨgan tɨdamɨgɨl dɨlak ak olap yɨg pag lɨl, chɨp olap ma kamɨlak. ");
INSERT INTO taw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pen ñɨn anɨb ak Juda binɨb tap kɨli nan gep ñɨn ak, tol ñɨn awl ak ownɨgeb tek, kasek kamnɨgun agɨl, kab mɨgan wulep anɨb sɨŋak kamɨlak. ");
INSERT INTO taw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande ñɨn ak man kɨdeyɨl tɨkɨnɨg gak won ak, Maliya taun Makdala nɨb ak, ne chɨp kamɨlak kawtub oŋɨd amɨl nɨgak, kab awl chɨp kawtub pɨl gɨlak ak ma yek. ");
INSERT INTO taw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ne nɨŋɨd kasek wu agɨl amɨl, Saymon Pita ayɨp, Jisas bɨne olap nop mapen yɨbɨl lolɨgup ak ayɨp yelek ak amnak. Amɨl, kɨlop agak, Bɨawl anop chɨp kamɨlak kawtub ak tɨg walɨg dad amɨl, akal dɨlɨpal ak ma nopun agak. ");
INSERT INTO taw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Anɨb agek, Pita ayɨp Jisas bɨne olap ayɨp tɨkjakɨl, chɨp kamɨlak kawtub ak amnɨlek. ");
INSERT INTO taw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kasek wu agɨl ayɨp amɨlɨg, Pita ne saynsayn gaknɨŋ, bɨ olap ne ned amjakɨl, ");
INSERT INTO taw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","seŋayaŋ nep mɨdɨl, ñɨk gɨl kab mɨgan oŋɨd sɨpsɨp nɨgak, chech teplep bad okok nep yek. ");
INSERT INTO taw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pen Saymon Pita ne kɨdek apɨl, kab mɨgan oŋɨd sɨkɨd amɨl nɨgak, chech teplep bad okok nep yek. ");
INSERT INTO taw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pen chech olap nɨgak, chech Jisas kɨmɨg cheg nop ak kam sɨlokɨlak ak abe yek. Chech nɨm ak, chech teplep bad okok ayɨp ma yek, pag tep gɨl ke sɨŋ oŋɨd lɨlak tek yek. ");
INSERT INTO taw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jisas bɨne olap pen, ne ned kab mɨgan owup ak, abe kab mɨgan oŋɨd sɨkɨd amnak. Amɨl, tap anɨb okok nɨŋɨd, gos nɨŋɨd, nɨŋɨd yɨbɨl ey agak. ");
INSERT INTO taw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pen won anɨb ak, buk Baybol kɨl tɨkɨl, ne kumɨl tepayaŋ tɨkjakɨnɨmuŋ agɨlak takaw ak, jɨj ak nɨgtep ma gɨlek. ");
INSERT INTO taw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pen bɨne omɨŋal anɨb ak ap nɨŋɨd, adɨkɨd kal amnɨlek. ");
INSERT INTO taw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliya pen chɨp kamɨlak kawtub anɨb ak seŋayaŋ jakɨl mɨdɨlɨg chaŋ lak. Chaŋ lɨlɨg, kab mɨgan oŋɨd nɨgɨnɨg ñɨk gak. ");
INSERT INTO taw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ñɨk gɨl nɨgak, ensel chech kayɨg lɨlek omɨŋal ak yelek. Kɨli besɨg yelek, Jisas nop kamɨlak abañ adek sɨŋak. Olap kɨmɨg day oŋɨd, olap tob kɨd day ayɨm besɨg yelek. ");
INSERT INTO taw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pen kɨli omɨŋal Maliya nop agɨlek, Bin, taynen chaŋ leban agɨlek. Agel kɨlop agak, Bɨawl yad anop tɨg walɨg dad amɨl, akal dam lɨpal ak ma nepin agak. ");
INSERT INTO taw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Anɨb agɨl, tɨg adɨkɨl nɨgak, Jisas apjakɨl yek. Pen Jisas nep agɨl ma nɨgak. ");
INSERT INTO taw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Pen Jisas nop agak, Bin, taynen chaŋ leban agak? Anop pɨyoweban agak? Agek, Maliya agak, Ey, bɨ wog nap nɨb anep agɨl, nop agak, Bɨawl, chɨp ak dad abin agɨl yɨl, akal dam lɨpan ak yɨp age, am dad amnin agak. ");
INSERT INTO taw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Agek agak, Maliya agak. Agek, Maliya tɨg adɨkɨl Hiblu takaw agɨl nop agak, Labonay agak. Takaw jɨj anɨb ak anɨgɨl mɨdeb, Tisa agak. ");
INSERT INTO taw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Agek Jisas agak, Bapi yɨl adek alaŋ adɨkɨd ma abin tek, yɨp ma dɨnɨgɨnɨmɨn agak. Pen nad mam yad okok kɨlop am agɨnɨmɨn, Jisas agup, Adek alaŋ adɨkɨd amebin, Bapi yad yɨl amebin alaŋ, Nap nɨbi abe agup agɨnɨmɨn agak. Ne God yad mɨdɨl, God nɨbi abe mɨdɨl gup agup agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jisas anɨb agek, Maliya taun Makdala nɨb ak amɨl, Jisas bɨne okok kɨlop agak, Bɨawl anop nepin agak. Anɨb agɨl, Jisas takaw agak okok kɨlop agñak. ");
INSERT INTO taw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pen Sande ñɨn ak, sɨb gɨnɨg gak won ak, Jisas bɨne okok kɨli bɨ Juda okok kɨlop pɨlɨkɨl, kal mɨgan mɨdɨl kanɨb ak gɨñɨl, kɨmɨgel yelak. Anɨgɨl yelaknɨŋ, Jisas apɨl nab anɨb ak sɨŋak jak mɨdɨl kɨlop agak, Nɨbi mɨdtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Anɨb agɨl, ñɨn wul ne okok sek, tɨgɨlem pɨs puŋɨlak ak sek kɨlop yomak. Anɨgek, bɨne kɨli Bɨawl nop nɨŋɨd, mɨñmɨñ tɨmel gɨlak. ");
INSERT INTO taw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pen Jisas kɨlop tepayaŋ agak, Nɨbi mɨdtep gɨnɨmɨb agak. Bapi yɨp agyokek opin tek, nɨbop agyoken amebɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Anɨb agɨl, añɨŋ bad ne ak kɨlop pug yokɨl agak, God Kawnan ne ak dɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nɨbi binɨb tap si tap tɨmel gɨpal okok nɨŋɨd kelɨgem, tap tɨmel anɨb okok God ne tɨg walɨg gɨyokɨnɨgab agak. Pen nɨŋɨd ma kelɨgem, God ne ma tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pen Jisas bɨne anep umɨgan ak ñɨn kɨlop owak anɨb ñɨn ak, bɨ kɨli olap ayɨp ma yelak. Yɨb ne Tomas. Pen ñapay tam sek tɨkel, Tomas yɨb ne olap Didimus agɨlak ");
INSERT INTO taw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Anɨb ak Jisas bɨne okok kɨli Tomas nop agɨlak, Bɨawl ak nop nopun agɨlak. Agelak, ne pen kɨlop agak, Yad ñɨn kɨd nop chɨpɨl pakɨpal ak, ñɨn yad ak ke nop chɨpɨl pakɨpal ak ñɨn lɨnɨŋɨd, tɨgɨlem kɨd nop ñapal ak abe, ñɨn lɨnɨŋɨd, nɨŋɨd yɨbɨl ey agɨl nɨgɨnɨgayn agak. Yad ke tap anɨb okok ma nɨgɨnɨgayn ak, takaw nɨbi agebɨm ak ma nɨgɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pen wik nokom olap mɨdɨl, Jisas bɨne okok Tomas ayɨp, tepayaŋ kal mɨgan ak kanɨb gɨñɨl yelak. Anɨgɨl yelaknɨŋ, Jisas apɨl nab anɨb ak sɨŋak jak mɨdɨl agak, Nɨbi mɨdtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Anɨb agɨl, Tomas nop agak, Nad apɨl, ñɨn nad ke yɨp ñapal mɨgan anɨb okok nɨŋɨd, ñɨn lɨnɨgan agak. Ñɨn nad ke tɨgɨlem kɨd yɨp ñapal ak ñɨn lɨnɨgan agak. Gos kuŋay ma nɨgɨnɨmɨn, yɨp nokom gos lɨnɨgɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Agek Tomas pen agak, Bɨawl yad ak, God yad ak mɨdeban agak. ");
INSERT INTO taw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Agek Jisas agak, Yɨp nɨŋɨd nɨm, yɨp nokom gos lɨnepan ak pen, binɨb yɨp ma nɨŋɨd, yɨp nokom gos lɨnepal okok, kɨlop tep yɨbɨl gup agak. ");
INSERT INTO taw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas bɨne okok nɨg yelaknɨŋ, tap mageptek keke kuŋay yɨbɨl golɨgup. Pen mɨj tɨkɨpin awl, tap mageptek mɨdupsek ma tɨkɨpin. ");
INSERT INTO taw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pen takaw tɨkɨpin awl, Jisas nop nokom gos lɨnɨgɨnɨmɨb agɨl tɨkɨpin. Ne Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak mɨdɨl, God Ñɨne yɨbɨl mɨdeb. Pen nop nokom gos lɨnɨŋɨd nɨm, pelnep yenɨgabɨm. Nɨbi tap gup anɨb okok gos nɨgɨm agɨl, mɨj awl tɨkɨpin. ");
INSERT INTO taw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pen kɨdek ñɨn olap, Jisas ñɨg cheb Taybeliyas gol okok tepayaŋ mɨseŋ apek, bɨne okok nop nɨgɨlak. Anɨgɨl mɨseŋ sɨŋak apjakek nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saymon Pita ak, Tomas yɨb olap Didimus apal ak, Nataniyel man ne Kena, Galili plopens nɨb ak, Sepedi ñɨne omɨŋal ak, Jisas bɨne omɨŋal sek ayɨp jɨmñɨl yelak. ");
INSERT INTO taw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Anɨgɨl yelak, Saymon Pita kɨlop agak, Yad kubsal nen amebin agak. Agek kɨli agɨlak, Chɨn ayɨp abe amnɨgabun agɨlak. Agɨl, am ne ayɨp bot dɨl, ajel ajel man tɨkak ak pen, kubsal ogɨnap ma yɨbɨl dɨlak. ");
INSERT INTO taw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pen sub lɨm gaknɨŋ, Jisas apɨl ñɨg cheb gol sɨŋak yek. Bɨne okok nop nɨgɨlak ak pen, ak Jisas agɨl ma nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pen Jisas kɨlop agak, Ñɨ okol, nɨbi kubsal nen aj mel nepɨm agak? Agek pen agɨlak, Yaw agɨlak. ");
INSERT INTO taw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Anɨb agel kɨlop agak, Kubsal dep asas ak dɨl, bot ñɨn yɨpɨd pɨs okok ken yokem nɨm, kubsal ogɨnap dɨnɨgabɨm agak. Agek, kubsal dep asas ak dɨl ñɨg nab ayaŋ yokɨl, kubsal kuŋay yɨbɨl nep dɨl, lɨpɨgel ownɨmuŋ tek ma lak. ");
INSERT INTO taw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anɨgek, Jisas bɨne olap nop mapen yɨbɨl lolɨgup ak, ne Pita nop agak, Bɨ anɨb ak Bɨawl ak agak. Ned Pita chech pal ne ak tɨg asɨk lɨl kubsal dak. Pen takaw anɨb ak nɨŋɨd, chech pal ne ak dɨl sɨj gɨl, pɨdeg ñɨg nab ayaŋ lɨl, ñɨg wɨj adek sɨŋadaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bɨne okok pen bot mɨgan ayaŋ mɨdɨl lɨpɨgɨl dad owlak. Ñɨg nab gol sɨŋak mɨdɨl, kubsal dep asas ak kubsal sek aplan jakɨl yek ak lɨpɨgel owak. ");
INSERT INTO taw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Apɨl bot ak kelɨgɨl nɨgɨlak, mab bɨj yɨnɨg log amɨl yek adek ak, kubsal ogɨnap yɨnɨg yek, bilet ogɨnap abe gol sɨŋak yek. ");
INSERT INTO taw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pen Jisas kɨlop agak, Kubsal mɨñɨl dɨpɨm okok, ogɨnap dowɨm agak. ");
INSERT INTO taw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Agek, Saymon Pita bot mɨgan ayaŋ amɨl, kubsal dep asas ak kubsal kuŋay yɨbɨl aplan jakɨl yek anɨb ak, lɨpɨg dad kab kɨlup adek ak owak. Asas kubsal kuŋay yek, kubsal anep 153 yek ak pen, asas ak ma pugɨlɨkak. ");
INSERT INTO taw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Anɨgek, Jisas kɨlop agak, Apɨl tap ñɨŋɨm agak. Pen bɨne okok kɨli nɨgɨlak, ak Bɨawl anep agɨl nɨgɨlak ak pen, kɨli mɨdupsek pɨlɨkɨl, olap bɨ nad an agɨl nop ma agnɨgak. ");
INSERT INTO taw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pen Jisas am bilet ak dɨl bɨlok ñɨl, kubsal ak anɨgɨl bɨlok ñɨl gak. ");
INSERT INTO taw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pen Jisas kumɨl tɨkjakɨl, mɨseŋ lek bɨne okok nop mɨnek omɨŋal nokom nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pen anɨgɨl tap ñɨbel, Jisas ne Saymon Pita nop agnɨŋɨd agak, Saymon Jon ñɨne, bɨ ogɨnap mɨdebal awl yɨp mapen lɨpal agak. Nad pen yɨp mapen awl lɨpan akaŋ mel agak? Agek agak, Yaw. Bɨawl, nep mapen lɨpin ak nad nepan agak. Agek agak, Chag sipsip ñɨluk yad okok kod yenɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Anɨb agɨl, tepayaŋ agnɨŋɨd agak, Saymon Jon ñɨne, yɨp mapen awl yɨbɨl lɨpan akaŋ agak? Agek agak, Yaw. Bɨawl, nep mapen lɨpin ak nad nepan agak. Agek agak, Chag sipsip yad okok kod yenɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Anɨb agɨl, tepayaŋ agnɨŋɨd agak, Saymon Jon ñɨne, yɨp mapen lɨpan akaŋ agak? Won omɨŋal nokom nop agnɨgek, Pita gos mɨŋel lɨlɨg agak, Bɨawl, nad tap okok mɨdupsek nepan agak. Nep mapen lɨpin ak nad nepan agak. Agek agak, Chag sipsip yad okok kod yenɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nep nɨŋɨd yɨbɨl agebin, nad bɨlel bɨ pɨlaj mɨdɨl, sɨbnag nad ak pog lɨl, gos nad ke nepan tek ajelɨgɨpan agak. Pen kɨdek bɨ mɨlep yenɨgaban ñɨn ak, chech nak ma lep tek, ñɨn nak dad aplanɨgaban, bɨ olap ne chech nep lɨ ñɨl, sɨbnag nep ak pog lɨl ñɨl, ma amnɨg gɨnɨgaban okok dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas takaw jɨj agak anɨb ak, Pita tɨtay dɨl kumɨl, God nop yɨb awl ñɨnɨgab ak yomɨl agak. Pen anɨb agɨl, Jisas Pita nop takaw olap agak, Yɨp kɨdek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisas takaw anɨb ak agaknɨŋ, Pita tɨg adɨkɨl nɨgak, Jisas bɨne nop mapen yɨbɨl lolɨgup ak kɨdek owak. Bɨ anɨb ak nɨm, ned tap ñɨbelak ñɨn ak, ne Jisas yek jɨj sɨŋak besɨg mɨdɨl agak, An nep chen mɨmug gɨ dad amnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita bɨ anɨb anop nɨŋɨd, Jisas nop agak, Bɨawl, bɨ nɨm awl nop tap tay gɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Agek Jisas agak, Ak gos yad agak. Nop gen anɨgɨl nep mɨdaknɨŋ, adɨkɨd ownɨgayn ak, takaw nak mel agak. Yɨp kɨdek gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Takaw anɨb ak tek agek, takaw aj aj binɨb ne okok gos anɨb nɨŋɨd agelɨgɨpal, Bɨne anɨb ak ma kumnɨgab agelɨgɨpal. Jisas pen bɨ anɨb ak ma kumnɨgab agɨl ma agak. Mel. Ne agak, Ak gos yad agak. Nop gen anɨgɨl nep mɨdaknɨŋ, adɨkɨd ownɨgayn ak, takaw nak mel agak. ");
INSERT INTO taw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Bɨne anɨb ak bɨ nɨm awl, mɨñɨl tɨtay gak okok nɨŋɨd agñɨl, takaw anɨb ak kɨl tɨkup. Pen chɨn nopun, takaw agñub anɨb ak, takaw nɨŋɨd yɨbɨl mɨdeb. ");
INSERT INTO taw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas tap kuŋay yɨbɨl gak. Pen gak anɨb okok keke mɨdupsek kɨl tɨkɨl mɨj ayaŋ lebɨlap, lum awl sɨkol gek, dɨlep tep ak ma yobɨkop.");
INSERT INTO taw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2"," Mam Tiyopilus. Yad nep mɨj ned tɨkɨnek ak, Jisas tɨkjakɨl wog gɨl mɨd dad amɨl, wog tɨtay gak, takaw tɨtay binɨb okok kɨlop agñak ak, nep agɨnek. Ne God man ne alaŋ amnɨg, God Kawnan ne ak gos ñaknɨŋ, bɨne takaw nop dad ameb okok kɨlop agñɨ tep gak. Agñɨ tep gek, God nop dad man ne alaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pen ned yɨpɨl awl dɨl kumɨl tɨkjakɨl, kɨdek bɨne takaw nop dad ameb okok yelaknɨŋ, ñɨn kuŋay yɨbɨl mɨseŋ lak. Mɨseŋ lɨl, kɨlop God binɨb dɨl kɨlop kod yenɨgab takaw ak agñolɨgup. Pen ne tɨtay gak ak nɨŋɨd, ak Jisas ne nokom kumɨl tɨkjakup agɨl, nɨgtep gɨlak. Pen kumɨl tɨkjakɨl, ñɨn anep 40 lum awl mɨdɨl, aplan jakɨl wɨsɨp alaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pen kumɨl tɨkjakɨl, lum awl yolɨgup ñɨn anɨb okok, ñɨn olap apɨl bɨne takaw nop dad ameb okok ayɨp mɨdɨl agak, Nɨbop ned agɨnek tek, bapi nɨbop tap olap ñɨnɨgayn agɨl aglak ak nɨm, man Jelusalem awl kod yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ne kɨlop ñɨg pakñak ak pen, bapi nɨbop Kawnan ne ak pakñɨnɨgab agak. Ñɨn anɨb ak wulep mɨdeb, kod yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pen ñɨn olap, Jisas bɨne takaw nop dad ameb okok yelak sɨŋak mɨseŋ lek, nop agnɨgɨlak, Bɨawl. Nad mɨñɨl ge, chɨn Yislel binɨb man chɨn ke kod yonɨgabun akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Agelak kɨlop agak, Bapi ne ke aglek, anɨb ñɨn ak tap anɨb ak gɨnɨgab agak. Anɨb ak tap nɨbi mel, nɨbi ma nɨgɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pen nɨgɨm. God Kawnan ne ak apɨl nɨbop kod mɨdaknɨŋ, kɨles ak dɨnɨgabɨm agak. Dɨl, nɨbi am Jelusalem binɨb okok, Judiya plopens binɨb okok, Samaliya plopens binɨb okok, binɨb man okok mɨdupsek, yad tɨtay gɨpin ak kɨlop agñɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Anɨb agek, God nop dad man ne alaŋ amnak. Bɨne takaw nop dad ameb okok nɨg yelaknɨŋ, wɨsɨp bad ak ap nop yu gak. ");
INSERT INTO taw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pen anɨgɨl kɨlan gɨl nɨg yelaknɨŋ, bɨ chech kayɨg tep yɨbɨl yɨmɨlek omɨŋal kasek apɨl, yelak wulep sɨŋak mɨseŋ lɨl ");
INSERT INTO taw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","agɨlek, Galili bɨ okok. Taynen wɨsɨp alaŋ nɨg mɨdebɨm agɨlek? Jisas adɨkɨd ownɨgab ñɨn ak, mɨñɨl anɨgɨl God man ne alaŋ ameb tek ownɨgab agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bɨ ensel omɨŋal anɨb ak, anɨb agɨl amnɨleknɨŋ, bɨ Jisas takaw nop dad ameb okok kɨli man Olip dum yelak ak kelɨgɨl, Jelusalem amnɨlak. Man Olip dum anɨb ak, wulep sɨŋak mɨdeb. ");
INSERT INTO taw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Am mɨdɨl, kal abañ adek nab alaŋ mɨgan ak yelak. Bɨ anɨb okok nɨm ak, Pita, Jon, Jemis, Edlu, Pilip, Tomas, Batolomyu, Matyu, Jemis nap ak Alpiyus, Saymon ne bɨ Selot agelɨgɨpal okok bɨ kɨli olap ak, Judas nap ak Jemis. ");
INSERT INTO taw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kɨli mɨnek mɨnek apnan gɨl, God nop agelɨgɨpal. Bin ogɨnap sek, Jisas nonɨm Maliya ak sek, Jisas nɨmam sɨkop ak sek, kɨli ayɨp God nop agelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pen ñɨn anɨb sɨŋak, binɨb anep 120 tek apnan gɨlaknɨŋ, Pita tɨkjakɨl kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Mam sɨkop, nɨgɨm agak. God Kawnan ak bɨlel Depid nop gos ñek nɨŋɨd, takaw anɨb ak buk Baybol kɨl tɨkak agak. Judas bɨ okok kɨlop poŋɨd amnɨgab, Jisas nop dun agɨl amnɨgabal tek agɨl tɨkek, mɨñɨl agak agak tek gup agak. ");
INSERT INTO taw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jisas bɨ Judas anɨb ak dek chɨn ayɨp mɨdɨl, God wog ak jɨmñɨl golɨgɨpun agak. ");
INSERT INTO taw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Bɨ anɨb ak Judas, ne Jisas nop mɨmug nɨŋɨd, mani dak ak dad amɨl, lum wakay olap tawak. Ñɨn olap apyap pakek, kogmeg nop ak pak jakɨl, chɨbol okok lɨmɨg seŋ amek kumak. ");
INSERT INTO taw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Anɨgɨl kumek, Jelusalem binɨb mɨdupsek nɨŋɨd, lum tawɨl kumak anɨb ak, yɨb Akeldama agɨlak. Akeldama agɨlak takaw jɨj ak, nɨkɨm yowak lum agɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pen Pita agak, Kɨli bɨlel Buk Kɨmep ak tɨkɨl agɨlak, Binɨb ogɨnap man ne anɨb ak, ma am yenɨgel agɨl tɨkɨlak agak. Man nep anɨb ak binɨb ma yenɨgel agɨl tɨkɨlak agak. Takaw olap pen agɨlak, Wog ne golɨgup ak, bɨ olap pen dɨnɨmuŋ agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Anɨgɨl agɨlak, anɨb ak tek chɨn bɨ olap nɨŋɨd dɨnɨgun agak. Bɨ anɨb ak bɨ yokɨp olap mel, bɨ chɨn ayɨp pel ajɨl, Jon Jisas nop ñɨg pakñak ak nɨŋɨd, mɨd dad amɨl, Jisas kumɨl tɨkjakek God nop dad man ne alaŋ amek nɨgak bɨ olap nɨŋɨd dɨnɨgun agak. Bɨ anɨb ak tek don nɨm, chɨn ayɨp mɨdɨl, bɨawl Jisas kumɨl tɨkjakak takaw ak agñɨnɨgabun agak. ");
INSERT INTO taw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita anɨb agek, bɨ Matiyas ayɨp, Josep ayɨp kɨlop aglɨlak. Pen Josep yɨb ne olap Basabas. Pen binɨb ogɨnap Jastus agelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Bɨ omɨŋal anɨb ak, anɨgɨl aglɨl God nop agɨlak, Bɨawl. Judas ne bɨ Jisas takaw nop dad ameb olap yek ak pen wog anɨb ak kelɨgak agɨlak. Kelɨgɨl, man tɨmel ne ke ak amnak agɨlak. Amɨl, tep nop ak an dɨnɨmuŋ agɨl, bɨ omɨŋal awl aglɨpun agɨlak. Anɨb ak nad binɨb mɨdupsek gos nɨŋɨd gɨpal tek nepan ak nɨm, nep agnɨgobun agɨlak. Nad ke bɨ an aglɨpan ak age, nɨŋɨd dɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Anɨb agel, bɨ omɨŋal gɨl jakɨlek, Matiyas yɨb ne aplanak. Aplanɨl, bɨ Jisas takaw nop dad ameb anep agɨp okok ayɨp jɨmñɨl yelak. ");
INSERT INTO taw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juda ñɨn awl Pedikos owaknɨŋ, kɨli kal mɨgan nokom olap yelak. ");
INSERT INTO taw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Anɨgɨl yelaknɨŋ, gu awl ak wɨsɨp adek alaŋ agɨl, yɨgen awl tek dɨl, gu awl kal mɨgan yelak anɨb ak mɨdupsek kus gak. ");
INSERT INTO taw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pen won anɨb anep mab mɨŋɨlaŋ tun tek ak apɨl, kɨlop keke amnaknɨŋ, ");
INSERT INTO taw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","God Kawnan ne ak kɨlop bak lɨl gek, takaw yɨbɨl keke agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ñɨn anɨb ak, Juda binɨb wakay keke apɨl Jelusalem nan gɨ yelak. Kɨli God nop agnɨŋɨd kɨdek gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pen gu awl anɨb ak agek nɨŋɨd, binɨb kuŋay apnan gɨlak. Apnan gɨl, kɨli nokom nokom nɨgɨlak, takaw yɨbɨl kɨli ak keke yɨpɨd gɨl nep agelak. ");
INSERT INTO taw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Kɨli nɨŋɨd, gos pal awl lɨl wal agɨl agɨlak, Bɨ okol mɨdupsek Galili nɨb ak pen, tɨtay dɨl takaw yɨbɨl chɨn keke apun tek yɨpɨd gɨl agebal nɨgobun agɨlak? ");
INSERT INTO taw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chɨn ogɨnap Patiya nɨb, ogɨnap Midiya nɨb, ogɨnap Elam nɨb, ogɨnap Mesopodemiya nɨb, ogɨnap Judiya nɨb, ogɨnap Kapadosiya nɨb, ogɨnap Podus nɨb, ogɨnap Esiya nɨb, ");
INSERT INTO taw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ogɨnap Piligiya nɨb, ogɨnap Pampiliya nɨb, ogɨnap Yijip nɨb, ogɨnap Libiya, Saylini gol okok nɨb, ogɨnap Lom nɨb, ");
INSERT INTO taw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ogɨnap Klit nɨb, ogɨnap Alebiya nɨb agɨlak. Chɨn ogɨnap Juda yɨpɨd gɨl yɨbɨl, ogɨnap Juda mel man okok nɨb okok nɨb ownok ak pen Juda binɨb gɨpal tek ak gɨpun agɨlak. Pen takaw yɨbɨl chɨn keke mɨdeb tek ak agel chɨn mɨdupsek nɨgobun agɨlak. God kɨles tɨmel gɨl, tap teplep okok mɨdupsek gak ak agebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anɨb agɨl, gos kuŋay nɨgɨlɨg ju dɨl, pen agnɨgek pen agnɨgek gɨl agɨlak, Ke yɨbɨl geb anɨb ak tay gɨnɨg geb agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pen binɨb ogɨnap agjulɨg agɨlak, Ak ñɨg wayn kuŋay ñɨbɨl sawl gɨl agebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Anɨb agelak, Pita ayɨp bɨ Jisas takaw nop dad ameb wog jɨmñɨl gep okok ayɨp tɨkjakɨl, takaw awl agɨl agak, Nɨb Juda binɨb okok, binɨb mɨdupsek Jelusalem mɨdebɨm okok, takaw agebin ak nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bɨ anɨb okok takaw yɨbɨl keke agebal ak, ñɨg wayn ñɨbɨl ma agebal agak. Binɨb kɨli ñɨg wayn ak sub kɨdek owup won ak ma ñɨbal, dugep won anep ñɨbal agak. Mɨñɨl mɨnek won ak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pen takaw yɨbɨl keke agebal nɨgebɨm anɨb awl, bɨ God gos ñek agñeb ak Jowel, bɨlel agɨl tɨkak tek nep gup agak. Ne takaw anɨb ak tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God agup, Ñɨn kɨdek ak binɨb okok mɨdupsek kɨlop Kawnan yad ak yokɨnɨgayn agup agɨl tɨkak agak. Ñɨpay nɨb okok kɨlop gos ñek agñɨnɨgabal agup agɨl tɨkak agak. Bɨ pɨlaj okok day nɨgɨnɨgabal agup agɨl tɨkak agak. Bɨawl okok wɨsɨn nɨgɨnɨgabal agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ñɨn anɨb ak, binbɨ yɨp wog gɨñɨbal okok kɨlop Kawnan yad ak yoken gos ñek, binɨb okok kɨlop agñɨnɨgabal agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pen adekab alaŋ tap ke yɨbɨl ogɨnap gɨl, lum awl ak tap mageptek ogɨnap gɨnɨgayn agup agɨl tɨkak agak. Pen nɨkɨm sek gɨl, mab yɨnɨl, sɨkom awl gɨl gɨnɨgab agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sub ak mɨlek ma gɨl, takan ak nɨkɨm sek lɨnɨgab agup agɨl tɨkak agak. Anɨgek, kɨdek nɨm Bɨawl ñɨn awl ne ak ownɨgab agup agɨl tɨkak agak. Ñɨn awl anɨb ak apek, Bɨawl kɨles ne ak sek mɨlek ne ak sek yomnɨgab agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pen binɨb bɨawl nop agnɨgɨnɨgabal okok, kɨlop tɨg asɨk dɨnɨgab agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita ne Jowel ñu kɨl tɨkak takaw anɨb ak agjuwɨl agak, Nɨbi Yislel binɨb. Takaw agɨnɨgebin awl nɨgɨnɨmɨb agak. Jisas bɨ Nasalet nɨb ak, bɨ yokɨp mel agak. God ne nokom nop aglɨl agyokek owak agak. Nop agyoken tap mageptek gek nɨŋɨd, God bɨne agɨnɨgabal agɨl agyokak agak. Agyokek apɨl, tap mageptek okok gek nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God ne nɨbi gɨnɨgabɨm tek nɨŋɨd, Jisas nop dɨ ñɨn adek nɨbop ak lek, dam binɨb God nop ma nepal okok kɨlop ñɨbek, mab bak alaŋ chɨpɨl pak tɨbɨk lel kumak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yul awl dɨl kumak ak pen, kumeb bad ak nop chɨchɨk dɨnɨmuŋ tek ma lak agak. God gek tepayaŋ tɨkjakak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pen Yislel bɨnonɨm Depid, ne bɨlel Jisas nop takaw ak ñu kɨl tɨkɨl agak, Yad nepin, Bɨawl ak ne yɨp pel wulep sɨŋawl mɨdeb agɨl tɨkak agak. Wulep sɨŋawl mɨdeb, yɨp kɨles ñek, yad tap olap ma pɨlɨkɨnɨgayn agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Anɨgek yɨp tep gek, mɨñmɨñ yɨbɨl gɨpin agɨl tɨkak agak. Kumnɨg abe ma pɨlɨkɨpin agɨl tɨkak agak. Yad nop gos nɨŋɨd, tap teplep abe kod mɨdebin agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yɨp agup, Nad bɨ suŋtep yɨbɨl yad ak, binɨb kubal okok ayɨp mɨdɨl ma kuy gɨ yownɨgaban agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pel mɨdep kanɨb ak yɨp yomnak tek, nad ayɨp pelpel mɨdɨl, mɨñmɨñ gɨnɨgayn agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita ne Depid ñu kɨl tɨkak takaw anɨb ak agjuwɨl agak, Mam sɨkop. Depid takaw agak anɨb ak, ne ke dɨl ma agak. Based yes chɨn Depid ne kumek, kamɨlak kaw mɨgan ak mɨñɨl abe nopun agak. ");
INSERT INTO taw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pen ne bɨ God gos ñek agñeb ak nɨm, ne nɨgak, God nop nɨŋɨd yɨbɨl agɨl agak, Ñɨ nad tɨke, tɨkel amɨl apɨl gɨnɨgab okok, kɨdek ñɨ olap nad bɨnonɨm mɨdeban tek mɨdɨl, binɨb kɨlop kod yenɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God agak anɨb ak nɨm, Depid nɨgak, kɨdek Klays kumɨl pɨsnep kuy gɨ yownɨmuŋ tek ma lak agak. God gek tepayaŋ tɨkjakɨnɨgab tek nɨŋɨd, takaw anɨb ak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","God gek, Jisas tepayaŋ tɨkjakek, wɨdɨn chɨn ke nɨŋɨd agobun agak. ");
INSERT INTO taw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God Jisas nop man ne alaŋ dad amɨl, ñɨn yɨpɨd kɨd okok ken lek, ne ayɨp mɨdeb agak. Nap ned agak tek, Kawnan ne ak Jisas nop ñak agak. Ñek, chɨnop yokek nɨm, apek takaw keke apun awl nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Depid ne Jisas amnak tek ma amnak, God man ne alaŋ agak. Pen ne takaw ogɨnap tɨkɨl agak, God ne Bɨawl yad anop agup, Nad ñɨn yɨpɨd kɨd yad okok besɨg yenɨmɨn agup agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Besɨg mɨdɨl, mɨd dad amɨl, binɨb nad ayɨp penpen gep okok kɨlop tob muk nak okok len, taw tɨbɨkɨnɨgaban agup agɨl tɨkak agak. Pen Depid takaw agak anɨb ak, ne ke dɨl ma agak. ");
INSERT INTO taw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Anɨb ak Depid takaw agak anɨb ak, nɨbi Yislel binɨb nɨgtep gɨnɨmɨb agak. Jisas bɨ mab bak alaŋ chɨpɨl pak tɨbɨk lel kumak ak nop, God gek Bɨawl yɨbɨl mɨdeb agak. Ne nokom Bɨ God nop aglup ak agak. ");
INSERT INTO taw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita takaw anɨb ak agek, binɨb yelak okok nɨgel chɨbol gos kɨlop aj lakak. Aj lakek, kɨli Pita ayɨp bɨ Jisas takaw nop dad ameb wog jɨmñɨl gep okok ayɨp kɨlop agɨlak, Mam sɨkop, chɨn mɨñɨl tay gɨnɨgun agɨlak? ");
INSERT INTO taw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Agelak Pita agak, Nɨbi nokom nokom tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgɨl, Jisas Klays nop gos nɨŋɨd ñɨg pakɨnɨmɨb agak. Anɨgenɨgabɨm, God tap si tap tɨmel gɨpɨm ak tɨg walɨg gɨyokɨl, Kawnan ne ak nɨbop yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God bɨlel aglɨl agak, Kawnan yad ak nɨbop yokɨl, ñapay nɨbi tɨkɨnɨgabɨm okok yokɨl, binɨb man pal okok kɨlop yokɨl gɨnɨgayn agak. God Bɨawl chɨn ak, binɨb ne dɨnɨg gup okok kɨlop mɨdupsek, Kawnan ne ak yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ne kɨles gɨl agɨl, takaw kuŋay agɨl kɨlop agak, Nɨbi nɨgtep gɨnɨmɨb agak. Nɨbi binɨb okok tɨtɨmel gɨpal tek kelɨgɨl, mɨdtep gɨnɨmɨb agak. Mel ak, yul awl dɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita ñɨn anɨb ak anɨgɨl agek, binɨb kuŋay yɨbɨl, anep 3,000 tek, takaw nop dɨl ñɨg pakɨlak. Pakɨl, kɨli apɨl bɨawl binɨb ne ned nɨb okok ayɨp jɨmñɨl yelak. ");
INSERT INTO taw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bɨ Jisas takaw nop dad ameb okok takaw agñelɨgɨpal ak, binɨb okok kɨli nɨgtep gɨlɨg, nɨmam kɨlop gos nɨŋɨd gɨñɨlɨg, tap mɨdup tɨpag jɨmñɨl ñɨbɨlɨg, God nop agɨlɨg yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God bɨ Jisas takaw nop dad ameb okok kɨlop kod mɨdaknɨŋ, tap mageptek kuŋay yɨbɨl gelak, binɨb mɨdupsek jel gek pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Binɨb Jisas nop gos lɨnɨgɨlak okok jɨmñɨl yelak ak nɨm, binɨb an tap yek okok, binɨb tap ma yek okok kɨlop monmon ñɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Lum awl, tap okok abe bɨ ogɨnap tawelak mani dɨl, binɨb tap ma yek okok kɨlop bɨlok ñɨlak. ");
INSERT INTO taw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mɨnek mɨnek God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ apnan gelɨgɨpal. Pen kal kɨli okok abe nan gɨl, bilet tɨpagɨl mɨñmɨñ gɨlɨg tap jɨmñɨl ñɨbelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Anɨgɨlɨg, God nop tep agelɨgɨpal nɨŋɨd, binɨb yokɨp okok kɨlop nɨgel tep gak. Bɨawl mɨnek mɨnek binɨb ogɨnap sek opal ak kɨlop dek, ap binɨb ne ned nɨb okok ayɨp jɨmñɨl yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","3","Bɨ olap nonɨm tɨkak ñɨn anep tob tɨmel gak. Nop mɨnek mɨnek dad apɨl, God agnɨgep kal awl kab wali kanɨbtub gol sɨŋak lel, besɨg yolɨgup. Kanɨbtub anɨb ak, kanɨbtub teplep yɨbɨl agɨlak. Mɨdɨlɨg, binɨb God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak apɨl amelɨgɨpal okok, kɨlop mani nen asɨb agolɨgup. Pen mɨnek olap Pita ayɨp Jon ayɨp, sub yɨpɨd gak won ak God nop pel agnɨgelɨgɨpal, kal mɨgan ak agnɨgɨnɨg amnɨlek. Amɨl, bɨ tob tɨmel gak anɨb ak kɨlop nɨŋɨd agak, Yɨp tap ogɨnap ñel agak. ");
INSERT INTO taw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Agek, kɨli nop nɨŋɨjsek lɨl mɨdɨlɨg Pita agak, Chɨlop nɨgan agak. ");
INSERT INTO taw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Agek, yɨp tap ñɨnɨgayl agɨl nɨg yek, ");
INSERT INTO taw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita agak, Mani yad ma mɨdeb, pen tap yad mɨdeb ak nep ñɨnɨgayn agak. Jisas Klays Nasalet nɨb ak, kɨles ne ak nep gek, tɨkjakɨl amnoŋ agak. ");
INSERT INTO taw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Anɨb agɨl, ñɨn yɨpɨd kɨd nop ak dɨl, dɨ jakñaknɨŋ, won anɨb anep tob nop okok suŋ lɨl wos gak. ");
INSERT INTO taw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Suŋ lek jakɨl am ap gɨl, kɨli ayɨp God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amnɨlak. Amɨlɨg, tɨlak tɨlak gɨlɨg, God nop tep yɨbɨl agɨlɨg amnak. ");
INSERT INTO taw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Anɨgek, binɨb yelak okok kɨli nɨgɨlak, bɨ tob tɨmel pel apɨl kanɨbtub awl teplep gɨlak gol sɨŋak mɨdɨlɨg, mani tap okok nen asɨb agolɨgup ak, ne tob yɨbɨl tawlɨg God nop tep yɨbɨl agek. Nɨŋɨd ju dɨl, gos kuŋay nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Won anɨb ak, bɨ anɨb ak ne Pita ayɨp Jon ayɨp kɨlop nab nab daknɨŋ, binɨb kuŋay yɨbɨl kasek ap nɨŋɨd gos kuŋay nɨgɨlak. Kɨli God agnɨgep kal awl kab wali kus gɨl yek ak, Solomon kal bad ak agelɨgɨpal yelak. ");
INSERT INTO taw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Anɨgelak, Pita nɨŋɨd anɨb agak, Yislel binɨb. Chɨlop taynen nɨŋɨjsek lɨl gos pal awl lebɨm agak? Kɨli bɨ teplep yɨbɨl mɨdɨl akaŋ, kɨles tɨmel yɨbɨl mɨdebil ak nɨm, gel bɨ anɨb awl kanɨb ajeb agɨl gos ak nɨgebɨm agak? Ak mel agak. ");
INSERT INTO taw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God ne Eblaham ayɨp, Aysak ayɨp, Jekop ayɨp, based chɨn okok God kɨli agak. God anɨb ak, ne bɨ wog gɨñeb ne Jisas yɨb nop ak dad aplanak agak. Nɨbi pen, bɨ anɨb ak nop ma dɨpek agak. Nop bɨ gapman God nop ma nepal ñɨn adek ak lɨpek agak. Lɨl, gapman bɨawl Paylat wɨsɨb yokin agek, nɨbi pen Jisas nop kud ñɨbek agak. ");
INSERT INTO taw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bɨ suŋtep yɨbɨl anɨb ak yɨpɨd gɨl mɨdeb ak, nop kud ñɨl Paylat nop apek, Bɨ binɨb paklup ak, nop kelɨge amnaŋ apek agak. ");
INSERT INTO taw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bɨ binɨb gek pelpel mɨdebal ak nop pɨsnep paklɨpek agak. Anɨgɨpek ak pen, God gek tepayaŋ tɨkjakɨl koŋɨm mɨdeb agak. Pen chɨl nɨŋɨd anɨb agobul agak. ");
INSERT INTO taw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bɨ tob tɨmel pel nepɨm awl, mɨñɨl suŋ lup nepɨm agak. Chɨl bɨ Jisas anɨb ak nop gos lɨnɨgol, chɨlop gos ñek, ne bɨ anɨb anop gek suŋ lɨnɨgab agɨl dɨ jakñɨbul agak. Dɨ jakñol, nop gek suŋ lup agak. ");
INSERT INTO taw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pen mam sɨkop agak. Nɨbi bɨawl nɨbi okok ayɨp, gos nɨgtep ma gɨpek ak nɨm, Jisas nop anɨgɨpek agak. ");
INSERT INTO taw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pen God, bɨne gos ñek agñeb okok mɨdupsek kɨlop bɨlel gos ñek agɨlak, Kɨdek Bɨ God nop aglup ak yul awl yɨbɨl dɨl kumnɨgab agɨlak ak nɨm, agɨlak tek nep gɨpek agak. ");
INSERT INTO taw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Anɨb ak tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgɨl, God nop adɨkɨd ownɨmɨb agak. Anɨgenɨgabɨm, tap si tap tɨmel gɨpɨm gach ak wik yokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Anɨgɨl nɨm, Bɨawl kɨles ne nɨbop ñɨnɨgab agak. God ne Klays nɨbop nen agyoken nɨbop kod yenɨgab agɨl agyokɨnɨgab agak. Bɨ God nop aglup ak, Jisas ne nokom agak. ");
INSERT INTO taw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pen bɨ God gos ñek agñeb okok bɨlel agɨlak tek, Jisas, Bɨ God nop aglup ak, ne God man ne alaŋ mɨdeb tek mɨdɨl, kɨdek tap lum awl ayaŋ mɨdeb okok tepayaŋ gɨtep gɨnɨg ownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bɨlel bɨ Mosis agak, God Bɨawl ne kɨdek bɨne gos ñek agñeb ak, yad tek olap agyokek, bɨ nɨb ayɨp mɨdebɨm ak tek olap agak. Takaw agɨnɨgab ak mɨdupsek nɨgtep gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Binɨb takaw nop ma nɨgɨnɨgabal okok, binɨb ne yɨbɨl okok ayɨp jɨmñɨl ma yenɨgabal agak. God ne kɨlop agyokɨl gɨ tɨmel gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bɨ God gos ñek agñeb Samwel sek, bɨ God gos ñek agñeb kɨdek owlak okok sek, kɨli mɨdupsek takaw agɨlak okok, mɨñɨl mɨdobun ñɨn nab awl agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bɨ God gos ñek agñeb anɨb okok, ñapay tɨkel, tɨk dad amɨl tɨk dad amɨl tɨkel nɨm, nɨbi mɨdebɨm agak. Anɨb ak takaw nɨbop olap, God based Eblaham nop gɨnɨgayn agɨl takaw aglak agak. Nop takaw aglɨl agak, Ñapay nad tɨke, tɨk dad amɨl apɨl gɨl tɨkɨnɨgabal okok, olap yek nɨŋɨd, binɨb okok mɨdupsek kod mɨdtep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pen God bɨ wog gɨñeb ne ak nop tɨkjakɨl nɨbop ñɨnɨg agak, Nɨbop ned agyoken bɨ anɨb ak nɨbop kod mɨdtep gek, nɨbi mɨdupsek tap si tap tɨmel gɨpɨm ak kelɨgɨnɨmɨb agak. Anɨb agɨl, agyokek owak agak. ");
INSERT INTO taw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pita ayɨp Jon ayɨp Jisas kumɨl tɨkjakak takaw ak binɨb kɨlop agñɨleknɨŋ, bɨ God nop sɨbogep okok sek, bɨ God agnɨgep kal awl polis bɨawl okok sek, bɨ Sajusi okok sek, kɨli takaw agɨlek anɨb ak nɨgɨlak. Nɨŋɨd, binɨb ogɨnap kumɨl ma tɨkjakɨpal anɨb ak taynen takaw anɨb ak agñebil agɨl mɨlɨk nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mɨlɨk nɨŋɨd, dɨ nag lɨl, mɨñɨl dugep won awl mel, tol takaw agɨl dɨ nag lep agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pen takaw agɨlek ñɨn anɨb ak, binɨb kuŋay yɨbɨl Jisas nop gos lɨnɨgɨlak. Bɨ anɨb okok apnan gɨlak nɨm anep 5,000 tek amnak. ");
INSERT INTO taw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pen mɨnek bɨawl takaw tɨg asɨkep ogɨnap, Juda bɨawl ogɨnap, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep ogɨnap, Jelusalem apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pen Anas, ne bɨ God nop sɨbogep bɨawl yɨbɨl ak, Kayapas ak, Jon ak, Aleksada ak, Anas bɨne ogɨnap sek, kɨli ayɨp apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Anɨgɨl nɨg mɨdɨlaknɨŋ, Pita ayɨp, Jon ayɨp kɨlop dap nab sɨŋak lɨl agɨlak, Bɨ tob tɨmel gak ak taydɨl gel suŋ lup agɨlak? Kɨles akal dɨl, wog anɨb ak anɨgɨl gɨpil agɨlak? ");
INSERT INTO taw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Agelak, Pita God Kawnan ayɨp yek ak nɨm agak, Nɨbi bɨawl takaw tɨg asɨkep okok sek, Juda bɨawl okok sek agak. ");
INSERT INTO taw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Chɨl tap teplep yɨbɨl gobul agak. Pen chɨlop bɨ tob tɨmel gak anop taydɨl gel suŋ lup agɨl, agnɨgebɨm agak? ");
INSERT INTO taw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nɨbi okok, Yislel binɨb mɨdupsek okok, takaw agebin ak nɨgtep gɨnɨmɨb agak. Jisas Klays bɨ Nasalet nɨb ak nop, mab bak alaŋ chɨpɨl pak tɨbɨk lem kumak ak pen, God gek tepayaŋ tɨkjakak agak. Bɨ anɨb ak nop ne nokom agnɨgol, bɨ tob tɨmel gak anɨb awl nop gek pɨsnep suŋ lek, aj tep gup agak. ");
INSERT INTO taw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bɨ Jisas anɨb anop nɨm, buk Baybol kɨl tɨkɨl, takaw pal adaŋ lɨl agɨlak, Nɨbi bɨ kal gep okok, nɨgem kab meg olap tep ma gek kelɨgɨpek ak pen, mɨñɨl kal meg nab awl ayaŋ tek puŋɨl ñɨl mɨdeb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God ne bɨ anɨb ak nep chɨnop agak ak nɨm, nop don, ne gek God binɨb ne yonɨgabun agak. Ne nokom bɨ kasɨn gep ak, chɨnop tɨg asɨk dɨnɨmuŋ agak. Pen binɨb ogɨnap kɨlop don, kɨli gel God binɨb ne yonɨgun tek ma mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita anɨgɨl agek, bɨawl anɨb okok nɨŋɨd gos pal awl lɨl agɨlak, Bɨ omɨŋal awl sikul ma agɨlek ak pen, takaw anɨb awl ma pɨlɨkɨl monmon agebil agɨlak. Jisas ayɨp ajelɨgɨpal ak nɨm, anɨgebil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kɨlop takaw kɨles tɨmel agɨnɨgel ak pen, bɨ tob tɨmel suŋ lak ak, bɨ omɨŋal ayɨp jak mɨdaknɨŋ, kɨlop ag gɨnɨgel tek ma lak. ");
INSERT INTO taw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Anɨb ak kɨli agɨlak, Ñɨli chɨnop bɨ Juda bɨawl takaw tɨg asɨkep okok kelɨgɨl, seŋayaŋ amnɨmil agɨlak. Anɨb agel, seŋ amelek, kɨli ke agnɨg agnɨg gɨl ");
INSERT INTO taw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","agɨlak, Chɨn bɨ anɨb omɨŋal ak kɨlop tɨtay dɨnɨgun agɨlak? Tap mageptek ak gel, Jelusalem binɨb mɨdupsek nepal agɨlak. Anɨb ak kɨlop yepɨs gɨpil agɨl, agɨnɨgun tek ma lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pen Jisas tɨtay gak takaw anɨb ak, binɨb ogɨnap kɨlop abe agel nɨgɨnɨgel tek lup ak, kɨlop mel agɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Anɨb agɨl, kɨlop agel apel agɨlak, Jisas yɨb nop ak kɨdek ma yɨbɨl agɨnɨmil agɨlak. Binɨb okok kɨlop kɨdek ma yɨbɨl agñɨnɨmil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Anɨb agel pen agɨlek, Chɨl God takaw nop ak kelɨgɨl, takaw nɨbop ak nɨgol, God nop tep gɨnɨgab akaŋ agɨlek? Nɨbi ke nɨgɨm agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pen Jisas tɨtay gak, takaw tɨtay agak ak kelɨgɨnɨgul tek ma lup agɨlek. Tap anɨb ak nɨŋɨd, binɨb okok kɨlop agñɨnɨgabul agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Anɨb agelek, bɨawl okok kɨli gos ke nɨŋɨd, bɨ anɨb ak sub anep 40 mɨdɨl kɨdek suŋ lup ak, binɨb okok nɨŋɨd God yɨb nop dad aplanebal. Bɨ omɨŋal anɨb awl kɨlop tap olap gonɨgabun, binɨb okok kabɨyam junɨgabal agɨl, kɨlop yokɨp takaw awl agɨl, ag seŋ yokɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita ayɨp, Jon ayɨp kɨlop anɨgɨl ag seŋ yokɨlak. Yokel, bɨ omɨŋal amɨl, Jisas binɨb ne okok kɨlop nɨŋɨd agñɨlek. Bɨ God nop sɨbogep bɨawl okok sek, Juda bɨawl okok sek, kɨli takaw tɨtɨmel agɨlak anɨb okok mɨdupsek agñɨlek. ");
INSERT INTO taw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Agelek nɨŋɨd, mɨdupsek God nop agɨlak, Nad bɨawl yɨbɨl, tap okok mɨdupsek kod mɨdeban agɨlak. Adekab alaŋ gɨlɨl, lum awl gɨlɨl, ñɨg solwala gɨlɨl, tap tɨtay mɨdeb okok mɨdupsek gɨlɨnak agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bɨlel Kawnan nad ak based chɨn Depid nop gos ñek, takaw nad ak tɨkɨl agak, Taynen binɨb Juda mel okok mɨdupsek kabɨyam jupal agɨl tɨkak agɨlak. Binɨb okok taynen takaw aglɨl, tap tɨmel gup anɨb okok gun apal agɨl tɨkak agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bɨnonɨm man okok nɨb okok nɨb sek, bɨawl okok sek takaw ag jɨmñɨl, God ayɨp penpen gɨnɨgun agɨl, taw jɨsɨpuk gɨl mɨdebal agɨl tɨkak agɨlak. Bɨ God nop aglup ak abe ayɨp penpen gɨnɨgun agɨl mɨdebal agɨl tɨkak agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Based Depid, takaw agɨl tɨkak anɨb ak, nɨŋɨd yɨbɨl agɨl tɨkak agɨlak. Gapman bɨnonɨm Helod ayɨp Podiyus Paylat ayɨp, binɨb Juda mel ogɨnap, Yislel nɨb ogɨnap apɨl takaw ag adek nokom lɨlak agɨlak. Aglɨl, bɨ wog gɨñeb nad Jisas ak nop gɨ tɨmel gɨlak, man awl anɨb ak agɨlak. Jisas bɨ suŋtep yɨbɨl, Bɨ nad nop aglup ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pen ned Jisas nop anɨgɨnɨgabal agɨnak ak nɨm, yaw age gɨlak, yokɨp ak anɨb ma gɨpɨlap agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bɨawl, mɨñɨl chɨnop takaw kɨles tɨmel yɨbɨl agebal agɨlak. Pen chɨn binɨb wog gɨñeb nad agɨlak. Chɨnop kod mɨde, chɨn ma pɨlɨkɨl, takaw nad ak binɨb okok kɨlop monmon kɨles gɨl agñɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nad kɨles ge, bɨ wog gɨñeb nad Jisas, ne bɨ suŋtep yɨbɨl ak, chɨn ayɨp kod mɨdonɨmuŋ agɨlak. Mɨdɨl, binɨb tap gup okok gon suŋ lɨl, tap mageptek ogɨnap sek gɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pen anɨgɨl takaw agjuwelak, kal yelak ak monmon tek dak. Dɨl, God Kawnan ak apɨl kɨlop bak lek, ma pɨlɨkɨl, God takaw ak monmon kɨles gɨl agñɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pen binɨb Jisas nop gos lɨnɨgɨlak anɨb okok, takaw adek nokom agɨl, gos adek nokom nɨŋɨd gɨlak. Tap kɨli tɨtay yek okok, mɨdupsek tap chɨn ke agɨl ma nɨgɨlak, tap chɨn jɨmñɨl agɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bɨ Jisas takaw nop dad ameb okok, takaw kɨli ak, takaw awl kɨles gɨl agelɨgɨpal, Bɨawl Jisas nop ñag lel kumɨl tɨkjakek, nop nɨgɨnok agelɨgɨpal. Pen God kɨlop mɨdupsek dɨtep yɨbɨl gɨl, gɨtep gak. ");
INSERT INTO taw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kɨli olap tap ogɨnap tek dek ma yelak, mɨdupsek tap yek. Bɨ olap lum abe kal abe yek okok, kɨlop agek mani dap tawelɨgɨpal. Tawel, mani dɨl dad apɨl, ");
INSERT INTO taw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bɨ Jisas takaw nop dad ameb okok kɨlop ñelɨgɨpal. Kɨli pen dɨl, binɨb tap ma yek okok kɨlop bɨlok ñelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pen bɨ Lipay jɨj tɨk dad amɨl tɨkɨlak bɨ olap, yɨb ne Josep. Man ne Sayplus nɨb. Bɨ anɨb ak ne bɨ takaw sayn agɨl kɨlop agñɨtep golɨgup tek, bɨ Jisas takaw nop dad ameb okok, kɨli nop Banabas agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Banabas lum ne wakay olap agek tawɨlak. Tawel, mani anɨb ak dap bɨ Jisas takaw nop dad ameb okok kɨlop ñak. ");
INSERT INTO taw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pen bɨ bel olap yelek. Nɨgɨmɨl yɨb ak Ananayas, bin ne yɨb ak Sapayla. Kɨli bel lum awl olap agelek kɨli tawɨlaknɨŋ mani dɨlek. ");
INSERT INTO taw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dɨl, mani anɨb ak pɨs kɨd ak we gɨl, pɨs kɨd ak nɨgɨmɨl dad amɨl, bɨ Jisas takaw nop dad ameb okok kɨlop ñak. ");
INSERT INTO taw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pen mani ak anɨgɨl dap ñek, Pita agak, Ananayas. Taynen Satan ayɨp mɨdɨl yepɨs agɨl apan, Mani mɨdupsek dad opin apan agak? Yepɨs apan anɨb ak, yɨp ma apan, God Kawnan ne ak nop apan agak. Mani nep lum awl tawpal anɨb ak, pɨs kɨd ak we gɨl opan agak. ");
INSERT INTO taw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lum awl anɨb ak, lum awl nak agak. Agɨnɨg apɨnap, mel ak kelɨgɨnɨg kelɨgɨpɨnap agak. Pen age mani tawebɨlap, mɨdupsek dad ownɨg dad opɨnap agak. Pɨs kɨd ak kal kelɨg ownɨg, kelɨg opɨnap agak. Taynen gos tɨmel anɨb won ak nepan agak. Nak yepɨs apan ak, binɨb kɨlop ma apan, God nop apan agak. ");
INSERT INTO taw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pita anɨb agek, Ananayas nɨŋɨd won anɨb ak nep pɨsnep kumɨl, apyap lum ayaŋ pakak. Pakek, bɨ pɨlaj okok apɨl, nop chech kam sɨlokɨl, dam kamɨlak. Pen binɨb okok gak anɨb ak nɨŋɨd, jel gek pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bin ne, nɨgɨmɨl nop kumek dam kamɨlak anɨb ak ma nɨgak. Ne yokɨp won olap tapɨn mɨdɨl apjakak. ");
INSERT INTO taw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Apjakek, Pita nop agnɨŋɨd agak, Lum awl ñɨli bel ak agel, tɨtay tawɨlak agak? Agek agak, Nɨm bɨ ak dad owup tek tawɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Anɨb agek, Pita nop agak, Ñɨli bel taynen takaw ag lɨnɨg lɨnɨg gɨl, yepɨs apil agak? God Kawnan ak takaw anɨb ak ma nɨgɨnɨgab agɨl anɨb apil agak? Nɨgan. Nagɨmɨl kumek, dam kabal bɨ okok mɨdebal kanɨbtub awl agak. Nep abe dad amnɨgebal agak. ");
INSERT INTO taw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Anɨb agek, won anɨb ak nep pɨsnep kumɨl, Pita tob agen sɨŋak apyap pakak. Bɨ pɨlaj tun nɨgɨmɨl nop dam kamɨlak anɨb ak apɨl nɨgɨlak, bin ne abe pɨsnep kumek. Nop dad amɨl nɨgɨmɨl nop kamɨlak gol sɨŋak kamɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Klays binɨb ne okok sek, binɨb yokɨp okok sek tap gak anɨb ak nɨŋɨd pɨlɨkelak, kɨlop jel tɨmel yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bɨ Jisas takaw nop dad ameb okok, tap mageptek kuŋay binɨb nab okok gɨlɨg yelak. Binɨb Jisas nop gos lɨnɨgɨlak okok, mɨdupsek pel apnan gelɨgɨpal. God agnɨgep kal awl kab wali kus gɨl yek ak, Solomon kal bad ak mɨgan ak apnan gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Binɨb yokɨp okok, kɨlop nɨgel tep gak ak pen, pɨlɨkɨl kɨli ayɨp ma apnan gelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pen mɨnek mɨnek binɨb ogɨnap sek Jisas nop gos lɨnɨŋɨd, binɨb ned nɨb okok ayɨp ap jɨmñɨl yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jelusalem binɨb okok kɨli bɨ Jisas takaw nop dad ameb okok tap mageptek gɨlak tek nɨŋɨd, binɨb tap gak okok dad kanɨb awl gol ak owlak. Apɨl, mɨj dam mɨgan mɨgan pal lɨl agɨlak, Pita padɨkek, sub kawnan ne ak kɨlop pakñek suŋ lɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Binɨb man wulep anɨb yelak okok abe, kɨli kuŋay binɨb tap gak okok dɨl, kɨcheki abaŋ lɨl yelak okok sek dɨl, dad owlak. Dad apelak, bɨ Jisas takaw nop dad ameb okok gel kɨlop mɨdupsek suŋ lak. ");
INSERT INTO taw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pen bɨ Jisas takaw nop dad ameb okok anɨgelak, binɨb kɨli yɨb kɨlop dad aplanɨlak. Aplanel nɨŋɨd, bɨ God nop sɨbogep bɨawl yɨbɨl ak sek, bogɨlak ne Sajusi okok sek kɨlop mɨlɨk nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mɨlɨk nɨŋɨd, tɨkjakɨl kɨlop dɨl, dam nag lɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kɨlop anɨgɨl dam nag lɨlak ak pen, ñɨn anɨb anep kɨsɨlɨm ayaŋ God agek, ensel olap owak. Apɨl, kanɨb ak yɨkɨl, kɨlop poŋɨd amek seŋ amnɨlak. Amel agak, ");
INSERT INTO taw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Nɨbi God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amɨl, binɨb okok kɨlop, tɨtay del God gek koŋɨm mɨdɨl pelnep yenɨgabal takaw ak, mɨdupsek agñɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Agek, man tɨkaknɨŋ, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amnɨlak. Amɨl, ensel agak tek, binɨb okok kɨlop takaw agñɨlak. Anɨgɨl agñɨlaknɨŋ, bɨ God nop sɨbogep bɨawl yɨbɨl ak sek, bɨne okok sek, kɨli bɨ Juda bɨawl takaw tɨg asɨkep okok mɨdupsek kɨlop suk agel, takaw agɨnɨg apnan gɨlak. Apnan gɨl, Juda polis okok kɨlop agɨlak, Bɨ Jisas takaw nop dad ameb okok nag lɨpun ak, mɨñɨl am poŋɨd owɨm agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Agelak, bɨ Juda polis anɨb okok amɨl nɨgɨlak, bɨ Jisas takaw nop dad ameb anɨb okok ma yelak. Anɨgek adɨkɨd apɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Chɨn amɨl nopun, kanɨb ak gɨñɨlak tek mɨdeb, bɨ polis okok abe kanɨbtub ak nɨg mɨdebal ak pen, kanɨb yɨkɨl, kal mɨgan ayaŋ amɨl nopun, bɨ olap ma mɨdebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anɨb agelak, bɨ God agnɨgep kal awl polis bɨawl ak sek, bɨ God nop sɨbogep bɨawl okok sek takaw anɨb ak nɨŋɨd, tɨtay dup agɨl, gos kuŋay yɨbɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Anɨgɨl nɨg mɨdɨlaknɨŋ, bɨ olap apɨl kɨlop agak, Bɨ nag lɨpek okok, kɨli am God agnɨgep kal awl kab wali kus gɨl yek mɨgan ak mɨdɨlɨg, binɨb okok kɨlop takaw agñebal agak. ");
INSERT INTO taw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Anɨb agek, bɨ God agnɨgep kal awl polis bɨawl ak, ne polis ogɨnap poŋɨd, bɨ Jisas takaw nop dad ameb anɨb okok kɨlop dɨnɨg amnɨlak. Amɨl, binɨb chɨnop kab ju pakɨnɨgabal agɨl, kɨlop ma ag gɨlak. Kɨmɨgel poŋɨd owlak. ");
INSERT INTO taw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bɨ Juda bɨawl takaw tɨg asɨkep okok apnan gɨ yelak okok poŋɨd owlak. Poŋɨd apelak, bɨ God nop sɨbogep bɨawl yɨbɨl ak kɨlop agak, ");
INSERT INTO taw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nɨbop Jisas takaw agak ak ma agɨnɨmɨb agɨl, kɨles gɨl apun ak pen, ag mel nɨŋɨd kelɨgɨpun agak. Nɨbi Jelusalem binɨb kɨlop mɨdupsek Jisas takaw ak agñɨbɨm agak. Chɨnop pen apɨm, Kɨli Jisas nop paklel kumak apɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Anɨb agek, Pita ayɨp bɨ Jisas takaw nop dad ameb wog jɨmñɨl gep okok ayɨp agɨlak, Binɨb takaw apal ak dɨl kɨdek ma gɨnɨgun, God takaw ak dɨl kɨdek gɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jisas nop mab bak alaŋ chɨpɨl pak tɨbɨk lem kumak ak pen, God gek tepayaŋ tɨkjakak agɨlak. Based sɨkop kɨli God nop nep agnɨgelɨgɨpal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God gek tɨkjakek, nop man ne alaŋ dad amɨl, ñɨn yɨpɨd kɨd okok ken lak agɨlak. Anɨb ak nopun, ne nokom nɨm Bɨawl chɨn, bɨ kasɨn gep agɨlak. Ne chɨnop Yislel binɨb mapen nɨgup ak nɨm, tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgon, gach chɨnop tɨg walɨg gɨyokɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","God gup anɨb ak nɨgtep gɨpun tek, binɨb okok agñɨbun agɨlak. God Kawnan ak abe nɨgtep gɨl, takaw anɨb ak tek agup agɨlak. Binɨb God takaw ne ak kɨdek gɨpal ak, God ne Kawnan ne ak kɨlop ñub agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Anɨb agelak, bɨ Juda bɨawl takaw tɨg asɨkep anɨb okok, kɨli kabɨyam juwɨl agɨlak, Kɨlop pɨsnep paklɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Anɨb agɨlak ak pen, nab anɨb ak bɨawl olap yek, yɨb ne ak Gamaliyel. Ne bɨ Pelisi God takaw nɨgtep gep kɨli olap. Juda binɨb mɨdupsek nop nɨgel kɨlop tep golɨgup. Bɨ Gamaliyel ne tɨkjakɨl agak, Bɨ tun awl kɨlop dam, seŋayaŋ sɨkol won olap lem yelaŋ agak. Anɨb agek seŋ amnɨlaknɨŋ, ");
INSERT INTO taw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","kɨlop agak, Yislel bɨ okol agak. Kɨlop tɨtay gɨnɨgebɨm ak, gos nɨgtep gɨl gɨnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nɨb nepɨm, ned bɨ Tewdas yad bɨawl agɨl agek nɨm, takaw ne agolɨgup ak bɨ kuŋay yɨbɨl anep 400 tek nɨgelɨgɨpal agak. Pen gapman bɨ okok nop pɨsnep paklelak, bɨ takaw nop nɨgɨlak okok, keke amel wog ne pɨsnep yowak agak. ");
INSERT INTO taw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pen kɨdek, yɨb dɨlak ñɨn ak abe, bɨ Judas Galili nɨb ak agak, Yad bɨawl yɨbɨl mɨdebin agak. Takaw apin tek nep gɨnɨgab agak. Chɨn gapman okok ayɨp penpen gɨl, kɨlop agyokɨnɨgabun agaknɨŋ, bɨ kuŋay yɨbɨl takaw nop kɨdek gɨlak agak. Anɨgelak pen, mɨd dad amɨl, bɨ anɨb ak nop paklelak kumak agak. Kumek, bɨ takaw ne agek nɨgɨlak okok, keke amnɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Anɨb ak nɨm, nɨbop agebin agak. Bɨ mɨdebal awl okok, kɨlop gɨ tɨmel ma gɨnɨmɨb agak. Takaw kɨli ke apal ak, awl gɨnɨg tek gɨl apyownɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pen God ne nokom agek gɨpal ak, kɨlop tap olap gɨnɨmɨb tek ma lɨnɨgab agak. Kɨlop tɨmel gɨnɨg, kɨli ayɨp ma penpen gɨnɨgabɨm, God ayɨp penpen gɨnɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliyel anɨb agek, agak tek nɨgɨlak. Nɨŋɨd, bɨ Jisas takaw nop dad ameb okok kɨlop agel apel, yokɨp paklɨlak. Paklɨl, Jisas takaw ak kɨdek ma yɨbɨl agɨnɨmɨb agɨl, kɨlop agyokelak amɨl, ");
INSERT INTO taw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","bɨ Juda bɨawl takaw tɨg asɨkep okok kɨlop kelɨgɨlak. Pen chɨnop taynen anɨgɨpal agɨl ma nɨgɨlak. God chɨnop Jisas bɨne yɨpɨd gɨl agɨl gek nɨm, chɨnop anɨgebal agɨl, tep gaknɨŋ amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amɨl, mɨnek mɨnek kal okok amɨl, God agnɨgep kal awl kab wali kus gɨl yek ak mɨgan ayaŋ amɨl, takaw teplep ak agñɨlak. Agñɨlɨg, Jisas ne nokom nɨm, Bɨ God nop aglup ak agelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pen ñɨn nab anɨb ak, binɨb Jisas yɨl yelak okok kuŋay yɨbɨl amnak. Amek, Juda binɨb Glik takaw ak nɨgɨlak okok, kɨli Juda takaw yɨpɨd gɨl nɨgɨlak okok kɨlop ag gɨl agɨlak, Mɨnek mɨnek bin kaŋɨl nɨbi okok kɨlop mani tap mɨdup tap okok yɨgɨlɨl ñɨtep gɨpɨm ak pen, taynen bin kaŋɨl chɨnop okok kɨlop anɨb ma gɨpɨm agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anɨb agelak, bɨ Jisas takaw nop dad ameb okok anep umɨgan ak, kɨli binɨb Jisas yɨl yelak okok mɨdupsek suk agel apel agɨlak, Mam sɨkop. Chɨn God takaw agñɨbun ak kelɨgɨl, binɨb okok kɨlop tap yɨgɨlɨl ñɨnɨgabun ak, tep ma gɨnɨgab agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Anɨb ak, nɨbi bɨ anep kugul ak nɨŋɨd dem, kɨlop wog anɨb ak aglɨnɨgun agɨlak. Bɨ yokɨp ogɨnap ma dɨnɨmɨb agɨlak. Bɨ God Kawnan ne ayɨp mɨdɨl, gos nɨgtep gɨl, binɨb nɨgel tep gup okok dɨnɨmɨb agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Anɨgɨl dem nɨm, kɨlop tap yɨgɨlep wog adek anɨb ak aglɨl, chɨn pen God nop agɨlɨg binɨb okok kɨlop takaw tep ak agñɨlɨg gɨ yonɨgabun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Anɨb agelak, mɨdupsek nɨgel kɨlop tep gek, bɨ anep kugul ak aglɨlak. Bɨ anɨb okok nɨm, Stipen bɨ Jisas nop gos lɨnɨŋɨd God Kawnan ne ayɨp nep yek ak, Pilip ak, Plokolus ak, Nikanol ak, Timon ak, Palmenas ak, Nikolas ak. Bɨ Nikolas anɨb ak, ne taun Adiyok nɨb ak bɨ Juda mel ak pen, Juda binɨb gɨpal tek adek ak kɨdek gak. ");
INSERT INTO taw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kɨlop aglɨl, dad bɨ Jisas takaw nop dad ameb okok yelak ak apel, kɨlop ñɨn dɨ mɨdɨlɨg God nop agnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pen God takaw ak agñel amnaknɨŋ, Jelusalem binɨb kuŋay yɨbɨl Jisas binɨb ne yɨl owlak. Bɨ God nop sɨbogep okok abe, kuŋay yɨbɨl Jisas nop gos lɨnɨŋɨd, bɨne yɨl owlak. ");
INSERT INTO taw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God ne Stipen ayɨp mɨdɨl kɨles ne ak nop ñek, tap mageptek okok kuŋay yɨbɨl binɨb yelɨgɨpal nab okok golɨgup. ");
INSERT INTO taw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pen Juda bɨ man keke okok nɨb ogɨnap apnan gɨl, takaw adek nokom agel nɨŋɨd, kɨlop Pliman agelɨgɨpal. Bɨ anɨb okok, ogɨnap taun Saylini nɨb, ogɨnap taun Aleksadliya nɨb, ogɨnap Silisiya plopens nɨb, ogɨnap Esiya plopens nɨb. Kɨli Stipen gak tek nɨŋɨd, ne ayɨp penpen agɨlak. Nop takaw kɨles yɨbɨl gɨl agɨlak ak pen, ");
INSERT INTO taw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","God Kawnan ak nop gos tep yɨbɨl ñaknɨŋ, takaw tay agɨlak ak, gos nɨgtep gɨl pen abe agek, nop pen agɨnɨgel tek ma lak. ");
INSERT INTO taw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pen kɨli Stipen nop ag mel nɨŋɨd, am bɨ ogɨnap kɨlop kɨmɨgel agtep gel, kɨli apɨl yepɨs agɨl agɨlak, Chɨn nopun, bɨ anɨb awl, ne Mosis takaw tɨkak ak agjuwɨl, God nop agjuwɨl gup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Anɨb agɨl, Juda bɨawl okok dɨl, bɨ kɨli Mosis takaw ñu kɨl tɨkak ak nɨgtep gep okok dɨl, binɨb yokɨp okok dɨl, chɨbol kɨlop ak tɨmel gek, ap Stipen nop dɨl, dad bɨ Juda bɨawl takaw tɨg asɨkep yelak okok amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dad amɨl, bɨ yepɨs agep ogɨnap sek dad apel, kɨli agɨlak, Chɨn nopun, bɨ anɨb awl, ne pel God agnɨgep kal awl ak takaw tɨmel agɨl, takaw Mosis ñu kɨl tɨkak ak takaw tɨmel agɨl gup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pen ne takaw olap agek nopun ak, anɨb agup, Jisas bɨ Nasalet nɨb ak, ne God agnɨgep kal awl ak gɨ tɨmel yɨbɨl gɨnɨgab agup agɨlak. Pen ne Mosis takaw agek gɨpal ak agek, kelɨgɨl gɨnɨgabal agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pen bɨ anɨb okok, bɨ Juda bɨawl takaw tɨg asɨkep okok ayɨp besɨgɨl, Stipen nop nɨŋɨjsek lɨl yelaknɨŋ, jomulɨk nop ak ensel jomulɨk tek lak. ");
INSERT INTO taw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pen bɨ God nop sɨbogep bɨawl yɨbɨl ak, ne Stipen nop agak, Takaw nep apal anɨb ak, nɨŋɨd apal akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Agek Stipen agak, Bapi mam sɨkop, nɨgɨm agak. Based yes chɨn Eblaham, bɨlel taun Halan ma amnak, man Mesopodemiya nep yolɨgup agak. Mɨdaknɨŋ, God Bɨawl tep yɨbɨl chɨn ak nop ap nɨgak agak. Ap nɨŋɨd, God ne nop agak, ");
INSERT INTO taw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Man nak awl kelɨgɨl, binɨb nak okok kelɨgɨl, man yad nep agñɨnɨgayn ak amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Agek, Eblaham ne Kaldiya binɨb man kɨli yolɨgup ak kelɨgɨl, taun Halan am yolɨgup agak. Kɨdek nap ne kumek, God agek, ap yolɨgup man nɨbi nɨm awl agak. ");
INSERT INTO taw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ñɨn anɨb ak, God Eblaham nop man awl wakay olap ma agak, yokɨp ap yolɨgup agak. Ñapay olap ma tɨkak, ñɨn anɨb ak yokɨp yek agak. God pen Eblaham nop agak, Kɨdek man awl anɨb ak, nad dɨnɨgaban agak. Ñapay nad tɨke, tɨkel tɨk dad amɨl tɨkɨnɨgabal okok, man awl anɨb ak abe dɨl yenɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pen God takaw olap agak, Ñapay nad tɨke, tɨkel tɨk dad amɨl tɨkɨnɨgabal okok, am binɨb ogɨnap man kɨli ak yenɨgabal agak. Mɨdel, binɨb anɨb okok binɨb nak okok kɨlop mɨdupsek nag lɨl, gɨ tɨmel yɨbɨl gɨl, nag wog tek aglel gɨnɨgabal, sub anep 400 yɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Binɨb okok kɨlop anɨgɨnɨgabal ak, yad kɨlop gɨ tɨmel gɨnɨgayn agak. Pen kɨdek binɨb nak okok man anɨb ak kelɨgɨl, ap yɨp kɨgom yɨmɨl agnɨgɨnɨgabal, man nɨm awl agak. ");
INSERT INTO taw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pen God Eblaham nop takaw ag adek nokom lɨl agak, Ñapay nad tɨke, tɨkel tɨk dad amɨl tɨkɨnɨgabal okok, nɨbop mɨdupsek kod yenɨgayn ak nɨm, wak tɨbɨlɨkɨnɨmɨb agak. Agek, kɨdek Eblaham ñɨne Aysak nop tɨkɨl, ñɨn anep kugul ak mɨdɨl, ñɨn jel ak wak nop ak tɨbɨlɨkak agak. Aysak pen Jekop nop tɨkak agak. Jekop ne pen, ñɨ anep umɨgan ak kɨlop tɨkek nɨm, chɨn Juda binɨb jɨj keke mɨdobun agak. ");
INSERT INTO taw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Based anɨb okok, nɨmam Josep nop nɨgel yɨlɨk gek, nop dɨl bɨ ogɨnap kɨlop ñelak, tawɨl dad man Yijip amnɨlak agak. Amel, bɨ yokɨp wog gɨñeb ak yolɨgup agak. Anɨgɨl mɨdɨl, Josep mɨdtep ma gak ak pen, God ne Josep nop sawl ma gak agak. Ne ayɨp mɨdɨl, mɨŋel ne okok mɨdupsek gɨjuwɨl, Yijip bɨnonɨm nop gos ñak agak. Ñek bɨnonɨm agak, Bɨ Josep anɨb ak, ne nɨgtep yɨbɨl gup agak. Anɨb agɨl, nop agek, kal tap nop okok sek, man Yijip sek kod yolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kɨdek ñɨn olap yuwan awl yɨbɨl ak, man Yijip sek, man Kenan sek owak agak. Apek, based chɨn tap mɨdup pɨyow nɨŋɨd, ñɨŋɨnɨgel tek olap ma yek, gos pal yɨbɨl lak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekop takaw olap nɨgak, tap mɨdup yek man Yijip agak. Ak nɨm based chɨn sɨkop kɨlop ned agyokek, tap mɨdup dɨnɨg amnɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Am dɨdad apɨl, ñɨbjuwɨl, tepayaŋ pen dɨnɨg amnɨlak agak. Amjakel, nɨmam Josep kɨlop agak, Mam sɨkop, yad namam nɨbi Josep nep agak. Agek, Yijip bɨnonɨm ak, takaw anɨb ak nɨŋɨd anɨb agak, Ak Josep nɨmam sɨkop ey agak. ");
INSERT INTO taw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep pen, bapi Jekop, binɨb ne okok yɨp kasek ownɨgel agɨl, takaw agyokek, bapi Jekop binɨb ne anep 75 dɨl, ayɨp owlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekop apɨl man Yijip mɨdɨl ne kumak agak. Mɨd dad amɨl, based sɨkop anɨb okok mɨdupsek kumdɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kɨlop kamnɨg, dad adɨkɨd taun Sekem amɨl, kamɨlak agak. Taun Sekem anɨb ak, bɨlel based yes Eblaham, ne bɨ Hamol ñɨne sɨkop kɨlop tawɨl, chɨp kameb lum wakay anɨb ak tawak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pen God Eblaham nop ned gɨnɨgayn agɨl aglak tek gɨnɨg gaknɨŋ, binɨb chɨn okok, kɨli tɨkel amɨl apɨl gɨl, kuŋay yɨbɨl man Yijip yelak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ñɨn anɨb ak Yijip binɨb bɨnonɨm kɨli kɨdeyɨl olap dɨlak agak. Bɨnonɨm anɨb ak pen, based Josep nop ma nɨgak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ak nɨm, binɨb chɨnop okok kɨlop yepɨs agɨl, gɨ tɨmel yɨbɨl gak agak. Gɨ tɨmel yɨbɨl gɨl, takaw kɨles agek, ñapay kɨli okok tɨkɨl, seŋ okok yokel, ke mɨdɨl kumelɨgɨpal agak. ");
INSERT INTO taw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Anɨgɨlak ak pen, ñɨn anɨb ak, bɨ bel olap ñɨ tep yɨbɨl olap tɨkɨl, yɨb nop Mosis agɨlek agak. Ñɨ anɨb ak nop takan omɨŋal nokom kal mɨgan okok we gel yolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kɨdek dam seŋayaŋ lelek, Yijip bɨnonɨm payne ak ap nop nɨŋɨd, dad amɨl, ñapay yad agɨl yɨmag lolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nop anɨgɨl yɨmag lek awl gek, Yijip binɨb kɨli tɨtay gelɨgɨpal ak, nop agñɨtep gɨlak agak. Ne bɨ takaw kɨles gɨl agɨl, wog kɨles gɨl golɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Pen Mosis sub anep 40 tek yɨn gak ñɨn ak mɨdɨl, ne agak, Binɨb yad Yislel kɨlop am nɨŋɨd owin agak. ");
INSERT INTO taw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pen ñɨn anɨb ak nɨgak, Yijip bɨ olap, ne bɨ Yislel olap nop gɨ tɨmel gak agak. Mosis nɨŋɨd, Yijip bɨ anop pɨsnep yɨbɨl paklek kumak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pen Mosis gos ne nɨgak, binɨb yad Yislel binɨb okok, kɨli God Mosis nop gos ñek ap chɨnop kod yenɨgab agak. Chɨnop kod mɨdɨl, kɨdek mɨdtep gɨnɨgabun agɨl gos nɨgɨnɨgabal, ne anɨgɨl gos nɨgak agak. Ak pen mel agak. Gos anɨb ak tek kɨli ma nɨgɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mɨnek Mosis ap nɨgak, Yislel bɨ omɨŋal penpen gelek agak. Nɨŋɨd anɨb agak, Mam omɨŋal. Ñɨli penpen gebil ak kelɨgɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Agek, bɨne olap tap jɨj gak ak, ne Mosis nop dɨyokɨl agak, Nep an agek, bɨawl mɨdɨl, chɨnop kod mɨdeban agak? ");
INSERT INTO taw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tolil Yijip bɨ olap paklɨnak ak, mɨñɨl pen yɨp paklɨnɨg apɨl ageban agak? ");
INSERT INTO taw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Anɨb agek, bɨ paklɨpin anɨb ak nepal agɨl, Mosis pɨlɨk man Midiyan amnak agak. Amɨl, bɨ yokɨp olap tek yek agak. Ne bin dɨl, ñɨ omɨŋal tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Sub anep 40 tek yɨnak ak, Mosis man Midiyan yolɨgup agak. Kɨdek mɨnek olap, am man nep binɨb ma yelak nab okok, Saynay dum wulep okok agak. Pen mɨdɨl nɨgak, ensel olap ap mab bɨd ak mɨdɨl, mab mɨdupsek mɨŋɨlaŋ tek gak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Anɨgek Mosis nɨŋɨd, tap anɨb ak tay gup agɨl, wulep sɨŋak apɨl nɨgaknɨŋ, Bɨawl ne Mosis nop agak. ");
INSERT INTO taw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Anɨb agak, Eblaham ayɨp, Aysak ayɨp, Jekop ayɨp, based yes okok ayɨp, God kɨli yad nokom agak. Anɨb agek, ak God nokom agup agɨl, pɨlɨkɨl nop nɨŋɨd kuyan gak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pen Bɨawl ne Mosis nop agak, Man anɨb ak yad ke, man suŋtep yɨbɨl mɨdeb, anɨb ak tek tob tɨlup tɨgjuwan agak. ");
INSERT INTO taw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yad nepin, Yijip binɨb okok, kɨli binɨb yad Yislel kay kɨlop gɨ tɨmel yɨbɨl gel, chɨb gek chaŋ lɨpal agak. Anɨb ak nɨŋɨd, kɨlop ap dɨnɨgebin agak. Nad tɨkjakan agak. Yad nep agyoken Yijip amnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yislel binɨb kɨli Mosis nop ned agɨlak, An agek chɨnop kod yenɨgaban agɨlak agak. God pen ensel olap nop agyokek, mab mɨŋɨlaŋ tek gɨlɨg agek, Mosis ne Yislel bɨawl kɨli mɨdɨl, kɨlop dɨnɨg adɨkɨd man Yijip amnak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yijip amɨl, tap mageptek okok kuŋay yɨbɨl gɨl, Yislel binɨb kɨlop dad ñɨg solwala Nɨkɨm apal ak tɨkɨlak agak. Tɨkɨl kɨd adaŋ amelak, tap mageptek okok gɨ yolɨgup agak. Man nep binɨb ma yelak nab okok mɨdɨl anɨgak, sub anep 40 tek yɨnak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosis ne nokom nɨm, Yislel binɨb kɨlop takaw olap agak, God ne kɨdek bɨne gos ñek agñeb ak, yad tek olap agyokek, bɨ nɨb ayɨp mɨdebɨm ak tek olap agak. ");
INSERT INTO taw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Based sɨkop chɨn kɨli man nep binɨb ma yelak nab okok yelɨgɨpal, Mosis ne ayɨp yolɨgup agak. Dum Saynay amek, ensel nop takaw agñak agak. Takaw pel mɨdep ak nop agñak agak. Takaw anɨb ak dɨl, chɨnop agñub agak. ");
INSERT INTO taw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mosis ne God takaw tep ak agñak ak pen, based chɨn okok takaw agak ak ma nɨgɨlak agak. Kɨli Mosis nop kelɨgɨl, adɨkɨd Yijip amnun agɨl gos ak nɨgɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nɨŋɨd, kɨli Mosis nɨmam Elon nop agɨlak, Namam nad, ne chɨnop Yijip nɨb dad owak ak, akal amub ak ma nopun agɨlak agak. Anɨb ak nad tap chɨn koŋɨm yɨmɨl agnɨgɨnɨgun ogɨnap gɨle, tap anɨb okok ned amek chɨn kɨdek gɨnɨgabun agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Anɨb agɨl, tap yepɨs agnɨgep olap, chag bulmakaw ñɨluk tek kɨli ke gɨlak agak. Gɨlel, kɨlop tep gaknɨŋ, tap ñɨŋeb pak dap sɨbog ñɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Anɨgelak, God kɨlop kelɨgɨl agak, Anɨgɨpal ak, sub, takan, gap okok kɨgom yɨmɨl agnɨgɨlaŋ agak. Ñɨn anɨb ak kɨli tap anɨb okok agnɨgɨlak ak nɨm, bɨ God gos ñek agñeb olap, God agak tek, mɨj ak kɨl tɨkɨl agak, Yislel binɨb agɨl tɨkak agak. Nɨbi ned sub anep 40 tek yɨnak ak, man nep binɨb ma yelak nab okok ajelɨgɨpɨm ñɨn ak, chag bulmakaw chag sipsip tap okok pakɨl yɨp sɨbogɨpek akaŋ agɨl tɨkak agak? Ak yɨp ma sɨbogɨpek agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nɨbi pen tap yepɨs omɨŋal ke gɨlɨpek ak agnɨgelɨgɨpɨm agɨl tɨkak agak. Tap anɨb ak, olap Molek agelɨgɨpɨm agɨl tɨkak agak. Olap gap tek gɨlɨl, Lepan agelɨgɨpɨm agɨl tɨkak agak. Tap yepɨs omɨŋal anɨb ak nep, mɨj kal gɨ dad ajɨlɨg, agnɨg gɨ yelɨgɨpɨm agɨl tɨkak agak. Gɨpek anɨb ak, yad nɨbop dɨyoken, am man pal yenɨgabɨm, man Babilon bak okok agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stipen anɨb agɨl, takaw olap pen agak, Bɨlel based sɨkop man nep binɨb ma yelak nab okok yelɨgɨpal ñɨn ak, Mosis amek, God nop takaw ogɨnap agɨl agak, Sel kal yɨp agnɨgɨnɨgel olap anɨb anɨb gɨl gɨnɨgel agak. Agek, Mosis apɨl kɨlop agek, kal agak anɨb ak tek gɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kɨdek, ñapay kɨli okok sel kal anɨb ak dɨl, Josuwa ayɨp sel kal anɨb ak dad owlak agak. Binɨb man anɨb awl yelak okok, God kɨlop pɨsnep yuk yokek, based chɨn man anɨb ak dɨlak agak. Sel kal anɨb ak mɨdɨl, mɨd dad amɨl, kɨdek bɨnonɨm Depid yolɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God Depid nop nɨgek tep gak, Depid ne God nop agnɨŋɨd agak, Yad kal tep olap gen, chɨn Jekop ñapay ne okok apɨl, kal anɨb ak mɨgan ayaŋ nep gos nɨŋɨd agnɨgɨnɨgun akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Anɨb agek ak pen, kɨdek ñɨne Solomon God agnɨgep kal awl agak anɨb ak gak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pen God Bɨawl yɨbɨl adek alaŋ mɨdeb ak, binɨb ñɨn mɨdup dɨl kal gɨnɨgabal ak, ne kal anɨb ak mɨgan ayaŋ ma yenɨgab agak. Bɨ God gos ñek agñeb olap takaw anɨb ak tɨkɨl agak, ");
INSERT INTO taw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Adekab alaŋ gɨlɨnek ak, besɨg mɨdep yad agɨl tɨkak agak. Lum awl gɨlɨnek ak, tob yad lɨpin agɨl tɨkak agak. Yɨp kal tay tek ak gɨlem, yad añɨŋ lɨl yenɨgayn agɨl tɨkak agak? ");
INSERT INTO taw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tap anɨb okok mɨdupsek yad ke gɨlɨnek agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stipen takaw anɨgɨl agɨl anɨb agak, Nɨbi takaw ma nɨŋɨd, tɨmel yɨbɨl gɨpɨm agak. Chɨbol nɨbop ak ma asɨkup agak. Tap lum ayaŋ yɨl gos nepɨm agak. God Kawnan ak nɨbop gos tep ñek nepɨkep ak pen, pel mel apɨm agak. Nased sɨkop gelɨgɨpal tek nep gɨpɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nased sɨkop kɨli bɨ God gos ñek agñeb okok kɨlop mɨdupsek gɨ tɨmel gɨlak agak. Bɨ ogɨnap kɨli God bɨ teplep mɨdeb ne ak ownɨgab agɨlak okok, nased sɨkop kɨli bɨ anɨb okok kɨlop mɨdupsek paklɨlak agak. Nɨbi pen, bɨ teplep anɨb ak apek, mɨmug nɨŋɨd ñapek agak. ");
INSERT INTO taw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pen takaw Mosis ñu kɨl tɨkak ak, God ensel okok kɨlop agek dad apɨl nɨbop ñɨlak ak, takaw anɨb ak nɨŋɨd ma dɨpek agak. ");
INSERT INTO taw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stipen takaw anɨb ak agaknɨŋ, kɨlop mɨlɨk tɨmel yɨbɨl yapek, meg sulɨlɨg kabɨyam julak. ");
INSERT INTO taw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pen God Kawnan ak Stipen ayɨp yek ak nɨm, God man ne alaŋ nɨŋɨd nɨgak, God mɨlek tep sek mɨdɨl, Jisas ñɨn yɨpɨd kɨd sɨŋak yek. ");
INSERT INTO taw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nɨŋɨd anɨb agak, Nɨgɨm. Yad nɨgebin, God man ne alaŋ mɨgan yɨkɨl mɨdeb agak. Bɨ Olap Ñɨne, God ñɨn yɨpɨd kɨd okok ken jakɨl mɨdeb agak. ");
INSERT INTO taw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Stipen anɨb agek, tɨmud kɨli ak pɨl gɨl, nop takaw awl yɨbɨl agɨl, mɨdupsek tɨkjakɨl ap nop chɨchɨk dɨl, ");
INSERT INTO taw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kal nab kelɨgɨl dad seŋayaŋ ken amnɨlak. Dad amɨl, bɨ nop ag gɨl takaw kɨles agɨlak okok, kabɨyam juwɨl, tiglis kɨli okok tɨg asɨk, bɨ pɨlaj Sol yek wulep sɨŋak lɨlak. Lel, ne kod mɨdaknɨŋ, kɨli Stipen nop kab ju pakɨlak. ");
INSERT INTO taw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nop anɨgɨl pakɨlaknɨŋ ne agak, Bɨawl Jisas. Kawnan yɨp ak dan agak. ");
INSERT INTO taw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Anɨb agɨl kɨgom yɨmɨl, suk awl yɨbɨl agak, Bɨawl. Yɨp paklebal awl, tap si tap tɨmel gebal ak nɨŋɨd kelɨgɨnɨmɨn agak. Anɨb agɨl kumak. ");
INSERT INTO taw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Stipen nop pakel kumak anɨb ak, bɨ Sol tep kumub agak. Stipen kumek, bɨ God nop nɨŋɨd kɨdek golɨgup ogɨnap, chɨb gek chaŋ lɨlɨg dam kamɨlak. Ñɨn anɨb ak, Juda kay kɨli binɨb Jisas nop gos lɨnɨŋɨd Jelusalem yelɨgɨpal okok, kɨlop gɨ tɨmel gɨnɨg gɨlak. Sol ne kal mɨgan kɨli amɨlɨg, binɨb okok kɨlop monmon pak lɨpɨg dam nag lolɨgup. Anɨgek, ogɨnap pɨlɨk, Samaliya plopens amɨl, ogɨnap pɨlɨk Judiya plopens tɨgoŋ okok amnɨlak. Bɨ Jisas takaw nop dad ameb anep umɨgan ak, kɨli pen Jelusalem yelak. ");
INSERT INTO taw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Binɨb Jisas nop gos lɨnɨgɨlak okok, pɨlɨk am wakay okok yelak. Mɨdɨl, binɨb anɨb okok kɨlop Jisas takaw tep ak agñɨlak. ");
INSERT INTO taw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Bɨ Pilip pen, am Samaliya plopens yek. Mɨdɨl, binɨb okok kɨlop agak, Bɨ God nop aglup ak, ne owup agak. ");
INSERT INTO taw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Agñɨlɨg, tap mageptek okok gak. Takaw ne tɨtay agak ak, tɨmud pak nɨgtep yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Binɨb kuŋay kɨcheki sek yelak okok, tap anɨb okok agek, wal agɨlɨg seŋ amnɨlak. Binɨb ñɨn tob kumak okok sek, binɨb ñɨn tob tɨmel gak okok sek gek, suŋ lak. ");
INSERT INTO taw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Anɨgek, binɨb mɨdupsek mɨñmɨñ yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pen man awl anɨb ak, bɨ olap yolɨgup, yɨb ne Saymon. Ne kuj gɨl, yepɨs agɨl agolɨgup, Yad bɨawl agolɨgup. Samaliya binɨb kɨli nɨŋɨd gos kuŋay yɨbɨl nɨgelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Binɨb yɨb yek okok, binɨb yɨb ma yek okok, kɨli mɨdupsek Saymon takaw agolɨgup tek nep nɨgolɨgup. Nɨŋɨd anɨb agolɨgup, Bɨ kɨles tɨmel anɨb awl, bɨ olap ke mel, nɨm bɨawl anep agolɨgup. ");
INSERT INTO taw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Saymon ne kuj gɨl, tap mageptek okok pel gaknɨŋ, binɨb okok gos kuŋay nɨŋɨd, takaw agak tek nep nɨgelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kɨdek pen Pilip apɨl, ne God binɨb dɨl kɨlop kod yenɨgab takaw tep ak kɨlop agñɨlɨg, Jisas nɨm, ne Bɨawl ke yɨbɨl pel kod mɨdobun ak agak. Anɨb agek, binbɨ Jisas nop gos lɨnɨŋɨd ñɨg pakɨlak. ");
INSERT INTO taw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saymon abe, Jisas nop gos lɨnɨŋɨd ñɨg pakak. Pakɨl, Pilip nop nep kɨdek golɨgup. Kɨdek gek, ne tap mageptek okok kuŋay yɨbɨl gek nɨŋɨd, Saymon gos pal yɨbɨl lolɨgup. ");
INSERT INTO taw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bɨ Jisas takaw nop dad ameb anep umɨgan ak, Jelusalem mɨdel, kɨlop takaw olap agɨlak, Samaliya binɨb God takaw nepal agɨlak. Anɨb agelak nɨŋɨd, Pita ayɨp, Jon ayɨp kɨlop agyokel, Samaliya amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Amɨl nɨgɨlek, binɨb Jisas nop gos lɨnɨŋɨd ñɨg pakɨlak ak pen, God Kawnan ne ak ma dɨlak. Nɨŋɨd, God nop agnɨŋɨd agɨlek, Binɨb okol Kawnan nad ak kɨlop ñan agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Anɨb agɨl kɨlop dɨ mɨdel, God Kawnan ne ak kɨlop keke yokak. ");
INSERT INTO taw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kɨlimɨŋal anɨgɨl kɨlop dɨ mɨdel, God Kawnan ne ak binɨb okok kɨlop yokak ak, Saymon nɨŋɨd, yad abe gɨnɨm agɨl, kɨlopmɨŋal mani yomɨlɨg agak, ");
INSERT INTO taw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","God ñɨlop kod mɨdaknɨŋ, binɨb okok yokɨp dɨ mɨdel, Kawnan ne kɨlop yɨl amub agak. Anɨb ak ñɨlop tawɨl yad abe gɨnɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Anɨb agek, Pita agak, God Kawnan ne ak ñub anɨb ak, taynen tawnɨg geban agak? Mani anɨb ak nak ayɨp kuy gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wog chɨl gɨpul ak nak ayɨp mel agak. Gos nad nepan ak, God nɨgek tep ma gup agak. ");
INSERT INTO taw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Yad nepin, gos tɨmel nepan anɨb ak, nep nag lɨl wos gup agak. Nad tap si tap tɨmel gɨpin ak taynen anɨgɨpin agɨl kelɨgɨnɨmɨn agak. Mɨlɨk nepan ak kelɨgɨl, God nop nokom gos nɨŋɨd agnɨgenɨgaban, tɨmel yɨbɨl gɨpan anɨb okok tɨg walɨg gɨyokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Agek Saymon agak, Ñɨli Bɨawl anop agnɨgel, tap yɨp gɨnɨmuŋ agɨl agebil anɨb ak ma gɨnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pen Pita ayɨp, Jon ayɨp binɨb okok kɨlop, Jisas chɨlop tɨtay gak takaw ak agñɨlek. Agñɨl, adɨkɨd Jelusalem amnɨg, kanɨb nab okok amɨlɨg, Samaliya binɨb wakay ogɨnap kɨlop, Jisas takaw teplep ak agñɨlɨg amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pen Bɨawl ensel ne olap apɨl, Pilip nop agak, Tɨkjakɨl, Jelusalem nɨb taun Gasa abal kanɨb pal ak amnɨmɨn agak. Kanɨb anɨb ak, man nep binɨb ma yelak nab okok yek. ");
INSERT INTO taw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Agek, Pilip kanɨb agak pal anɨb ak amɨl nɨgak, bɨ Yitiyopiya nɨb olap amek. Bɨ anɨb ak ne bɨawl olap, binawl man Yitiyopiya kod mɨdep ak nop wog gɨlɨg, mani nop kod yolɨgup. Pen ne Jelusalem amɨl, God nop agnɨg mɨdɨl, ");
INSERT INTO taw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","adɨkɨd man Yitiyopiya amnak. Amnɨg, chag hos lɨpɨg dad ajup tap bad adek ak besɨgɨl, buk Baybol Aysaya kɨl tɨkak ak dɨl, nɨgɨlɨg amnak. ");
INSERT INTO taw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pen God Kawnan ak Pilip nop agak, Chag hos tap bad lɨpɨg dad ameb ak bak sɨŋak amɨl, ayɨp amnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Agek, kasek Pilip agak tek amɨl nɨgak, bɨawl Yitiyopiya nɨb anɨb ak, bɨ God gos ñek agñeb Aysaya mɨj kɨl tɨkak ak, nɨgɨlɨg amek. Pilip nɨŋɨd anɨb agak, Mɨj nɨgɨlɨg ameban ak, takaw jɨj ak nɨgeban akaŋ mel agak? ");
INSERT INTO taw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Agek agak, Binɨb ogɨnap yɨp takaw anɨb ak agñel nɨŋɨd tek, nɨgɨnɨm agak. Anɨb agɨl, Pilip nop agak, Ap adek awl besɨge amnul agak. Agek, am adek anɨb ak besɨgak. ");
INSERT INTO taw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pen buk Baybol Aysaya kɨl tɨkak anɨb ak agak, Chag sipsip pakɨnɨg, yokɨp poŋɨd amɨl pakɨpal agɨl tɨkak. Pen chag sipsip ñɨluk wɨj kɨlop okok tɨkɨlaknɨŋ, wal ma apal agɨl tɨkak. Anɨb ak tek, bɨ anɨb anop abe gel, takaw pen ma agɨnɨgab agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nop agjuwɨl, kot nɨŋɨd yɨbɨl ma agɨlak agɨl tɨkak. Tap tɨmel olap ma yɨbɨl gɨnɨgab ak pen, nop yepɨs agɨl, kɨdek bɨ an tek mɨdɨl anɨb anɨb golɨgup agɨnɨgab agɨl tɨkak? Ne ñɨpay ogɨnap tɨk lek, binɨb okok anɨb apɨlap agɨl tɨkak. Pen nop pɨsnep paklɨlak, lum awl ma mɨdeb agɨl tɨkak. ");
INSERT INTO taw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Aysaya takaw agɨl tɨkak anɨb ak nɨŋɨd, bɨawl Yitiyopiya nɨb ak ne Pilip nop agak, Bɨ God gos ñek agñeb ak, ne anop agak? Ne ke akaŋ, bɨ olap nop agak? ");
INSERT INTO taw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Agek, Pilip ne bɨ anɨb anop, Aysaya takaw tɨkak jɨj anɨb ak ned agɨl, ag ag Jisas nop takaw teplep ak agñɨtep gak. ");
INSERT INTO taw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Pen anɨgɨl takaw ag dad amɨlɨg nɨgɨlek, ñɨg olap yek. Bɨ anɨb ak Pilip nop agnɨŋɨd agak, Ñɨg mɨdeb awl, yɨp ñɨg pakñɨnɨgaban agak? ");
INSERT INTO taw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Agɨl, bɨ anɨb ak bɨ chag hos dad ameb nop agek nɨŋɨd, chag hos ak yek. Pen ñɨli ñɨg ayaŋ amɨl, Pilip bɨ anɨb anop ñɨg pakñak. ");
INSERT INTO taw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ñɨg pakñɨl owleknɨŋ, God Kawnan ak Pilip nop dad wakay olap amek, bɨ anɨb ak ne Pilip nop ma nɨgak. Ne pen mɨñmɨñ gɨlɨg man Yitiyopiya amnak. ");
INSERT INTO taw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pen God Kawnan ak Pilip nop dam taun Asdod lek, Pilip binɨb man anɨb okok yelak okok kɨlop Jisas takaw teplep ak agñɨlɨg, gɨ dam dam taun Sisaliya amjakak. ");
INSERT INTO taw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pen Sol binɨb Jisas yɨl yelak okok kɨlop paklin agɨl, pel kɨles yɨbɨl golɨgup. Mɨnek olap am bɨ God nop sɨbogep bɨawl yɨbɨl anop agak, ");
INSERT INTO taw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yɨp mɨj ogɨnap kɨl tɨkñenɨmɨn, dad Juda apnan gɨpal kal keke mɨdeb taun Damaskus amnɨgayn agak. Amɨl, kɨlop ñɨnɨgayn agak. Mɨj anɨb ak tɨkɨl agɨnɨmɨn, Nɨbi Juda apnan gɨpal kal man Damaskus nɨb opɨm okok, binɨb Bɨawl kanɨb tep ne ameb apal ogɨnap yenɨgel, Sol nop agɨnɨmɨb agɨl tɨkɨnɨmɨn agak. Agem, nag lɨl, dad Jelusalem ownɨmuŋ agɨl tɨkɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Anɨb agek, mɨj tɨkñaknɨŋ, dad taun Damaskus amnak. Wulep wulep gaknɨŋ, mɨlek awl ak wɨsɨp alaŋ nɨb nop nɨgak. ");
INSERT INTO taw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nɨgek, Sol apyap man ayaŋ pakaknɨŋ, takaw olap agak, Sol. Sol. Yɨp taynen pel pakɨnɨg gɨpan agak? ");
INSERT INTO taw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Agek agak, Bɨawl. Nad an agak? Agek agak, Yad Jisas, yɨp pel paklɨnɨg gɨpan ak nep agebin agak. ");
INSERT INTO taw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Anɨb agɨl agak, Nad tɨkjakɨl, taun Damaskus amɨl, bɨ olap ap nep takaw agɨnɨmuŋ tek nɨŋɨd gɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pen bɨ Sol ayɨp owlak okok, ne apyap pakaknɨŋ, takaw mɨdup anep nɨŋɨd, bɨ nonɨm ak ma nɨŋɨd, gos pal lɨl takaw ogɨnap ma yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ne anɨgɨl apyap pakɨl, tɨkjakɨl nɨgak, wɨdɨn nop ak pɨsnep koy gak. Anɨgek, bɨne ayɨp owlak okok, ñɨn kɨd nop ak dɨl, poŋɨd Damaskus amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nop anɨgɨl wɨdɨn koy gek, ñɨg, tap mɨdup tap okok ma ñɨbɨl, ñɨn omɨŋal nokom yokɨp nep yek. ");
INSERT INTO taw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pen bɨ Jisas yɨl yek ak olap, ne Damaskus anɨb ak yek. Yɨb ne ak Ananayas. Ne day nɨgak, Bɨawl nop agak, Ananayas agak. Agek, Ananayas ne agak, Bɨawl. Yad mɨdebin agak. ");
INSERT INTO taw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Agek, Bɨawl ne agak, Sol bɨ man Tasus nɨb ak, ne day nɨgup agak. Day nɨgup ak, nop am dɨnɨgaban, wɨdɨn koy gak ak suŋ lɨnɨgab agak. Ne mɨñɨl yɨp agnɨgɨlɨg mɨdeb, Judas kal ak agak. Anɨb ak nad kanɨb Yɨpɨd apal ak amɨl, Judas kal amjakɨl kɨlop agɨnɨmɨn, Sol nop nɨgɨnɨg apebin agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Bɨawl anɨb agek, Ananayas agak, Bɨawl. Yad nepin, binɨb kuŋay yɨbɨl apal, Bɨ Sol anɨb ak binɨb nep yɨl mɨdebal okok, kɨlop pel gɨ tɨmel yɨbɨl gup man Jelusalem apal agak. ");
INSERT INTO taw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne mɨñɨl owup awl, yokɨp ma owup agak. Bɨ God nop sɨbogep bɨawl okok, takaw kɨlop ak nɨŋɨd, chɨn binɨb nep agnɨŋɨd yɨb nep apun okok, chɨnop nag lin agɨl owup agak. ");
INSERT INTO taw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananayas anɨb agek, Bɨawl agak, Amnoŋ agak. Bɨ anɨb anop wog ogɨnap pɨsnep aglɨpin agak. Ne takaw tep yɨp ak, binɨb Juda mel okol kɨlop agñɨl, gapman bɨnonɨm okol kɨlop agñɨl, Yislel binɨb okol kɨlop agñɨl gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pen ne yul awl dɨl mɨŋel awl dɨlɨg, wog yad anɨb ak gɨnɨgab agak. Anɨb okok nop gɨnɨgab ak, nop yomnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pen Ananayas anɨgɨl day nɨŋɨd, Judas kal ak amɨl nɨgak, Sol yek. Nop dɨlɨg agak, Mam Sol agak. Bɨawl Jisas kanɨb nab mɨseŋ gek nɨgɨnak ak, yɨp agyokek apebin agak. Wɨdɨn tep ak nɨŋɨd, God Kawnan ak abe dɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Anɨb agaknɨŋ, tap bad tek wɨdɨn nop yu gɨl yek ak, wanɨg yowaknɨŋ, day wɨdɨn nɨgak. Won anɨb anep tɨkjakek, Ananayas Sol nop ñɨg pakñak. ");
INSERT INTO taw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ñɨg pakñek, Sol tap ñɨbek nop kɨles ñak. Pen ñɨn ogɨnap, Sol ne binɨb Jisas yɨl yelak okok ayɨp taun Damaskus yolɨgup. ");
INSERT INTO taw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mɨdɨl, Juda apnan gɨpal kal okok amel, Jisas takaw ak binɨb okok kɨlop agñɨl agak, Jisas, ne God Ñɨne yɨpɨd gɨl yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Anɨgɨl agñek, binɨb mɨdupsek nɨŋɨd ju dɨlɨg agɨlak, Bɨ anɨb awl, binɨb Jisas nop agnɨŋɨd yɨb nop apal okok, kɨlop gɨ tɨmel golɨgup, man Jelusalem agɨlak? Chɨn nɨŋɨd apun akaŋ agɨlak? Mɨñɨl ogɨnap sek nag lɨl, dam Jelusalem bɨ God nop sɨbogep bɨawl okok kɨlop ñin agɨl owup tek lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol ne Jisas takaw ag dad amɨl agak, Bɨ God nop aglup ak nɨm, Jisas nokom agak. Takaw anɨb ak kɨles gɨl yɨpɨd gɨl yɨbɨl agak. Agek, bɨ Juda Damaskus yelak okok, takaw olap pen agnɨgel tek ma lak. ");
INSERT INTO taw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pen kɨdek mɨd dad amɨl, Juda kay apnan gɨl, takaw ag adek nokom lɨl agɨlak, Sol nop paklɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Takaw agɨlak anɨb ak Sol nɨgak. Man awl anɨb ak, kab wali awl yɨbɨl gɨ kuskus gɨlak ak nɨm, kanɨb tam ajelɨgɨpal okok, Sol nop ñagun agɨl, subnab maynab ñɨluk lɨ yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Anɨgelak mɨnek olap, maynab ayaŋ bɨ takaw nop nɨgelɨgɨpal okok, kɨli nop wad mɨgan awl ak yɨgɨlak. Yɨgɨl, nag tun gɨl, lɨpɨg alaŋ nɨb ayaŋ dɨyokelak amnak. ");
INSERT INTO taw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pen Sol Jelusalem amɨl, binɨb Jisas yɨl yelak okok ayɨp jɨmñɨl yonɨgun agɨl nɨgak. Kɨli pen nop nɨŋɨd, bɨ anɨb awl Jisas yɨl ma yek, chɨnop paklɨnɨg nep owup agɨl, pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pɨlɨkelak, Banabas, ne Sol nop dad, bɨ Jisas takaw nop dad ameb okok yelak ak amɨl, kɨlop agak, Bɨ anɨb awl mɨnek olap taun Damaskus amnɨg, kanɨb nab ak amek, Jisas mɨseŋ gɨl nop takaw ogɨnap agek nɨgak agak. Kɨdek Damaskus binɨb kɨlop ma pɨlɨkɨl, Jisas takaw tep ak monmon yɨbɨl agñak agak. ");
INSERT INTO taw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas anɨb agek, Sol nop delak, kɨli ayɨp Jelusalem mɨdɨl, Bɨawl takaw tep ak ma pɨlɨkɨl, monmon yɨbɨl agñak. ");
INSERT INTO taw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pen bɨ Juda ogɨnap, Glik takaw agɨlak okok, ne ayɨp penpen ag amɨl apɨl gɨl, pɨsnep paklun agɨl gos ak nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pen bɨ Jisas nop gos lɨnɨgɨlak ogɨnap, takaw anɨb ak nɨŋɨd, nop poŋɨd dam taun Sisaliya amɨl, agyokel taun Tasus amnak. ");
INSERT INTO taw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ñɨn anɨb ak, Klays binɨb ne Judiya plopens, Galili plopens, Samaliya plopens pelpel apnan gɨpal okok, kɨli mɨdtep gɨlak. God Kawnan ak kɨlop kod mɨdaknɨŋ, God takaw ma kelɨgɨl, dɨtep yɨbɨl gɨnɨgun agɨl agɨlak. Anɨgɨl gos sek mɨdɨl kɨles gɨl jak tep gɨl mɨdɨl, binɨb kuŋay yɨbɨl Jisas nop dɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ne man keke nɨg ajolɨgup. Anɨgɨl nɨg ajɨl, mɨnek olap binɨb Klays yɨl mɨdebal okok kɨlop nɨgin agɨl, taun Lida amnak. ");
INSERT INTO taw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Man anɨb ak, bɨ ñɨn tob kumek olap, mɨj adek nep kɨn yek, sap yeb anep jel ak yek. Yɨb ne Ayniyas. ");
INSERT INTO taw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita bɨ anɨb anop agak, Ayniyas. Tap nep gup ak, Jisas Klays gek suŋ lɨnɨgab agak. Jakɨl, mɨj ak pal tep gan agak. Anɨb agaknɨŋ, nop suŋ lɨl tɨkjakak. ");
INSERT INTO taw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Suŋ lek gɨ ajek, taun Lida binɨb okok sek, taun Salon binɨb okok sek nop nɨgɨlak tek, tap tɨmel gɨpal okok kelɨgɨl, Bɨawl nop nokom gos nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bin Jisas yɨl yek olap taun Jopa yek. Bin anɨb ak yɨb ne Tabita. Pen Glik takaw agɨl, nop Dokas agɨlak. Ne binɨb okok kɨlop kod mɨdtep gɨl, binɨb yɨmgeptek okok kɨlop wog gɨñolɨgup. ");
INSERT INTO taw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pen Pita taun Lida mɨdaknɨŋ, bin anɨb ak mɨñak dɨl kumak. Kumek, chɨp ñɨg pakñɨl dam lɨlak, kal mɨgan adek alaŋ. ");
INSERT INTO taw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Binɨb Jisas yɨl yelak okok, takaw olap nɨgɨlak, Pita ap yek man Lida. Taun Lida anɨb ak, taun Jopa bak sɨŋak yek. Kɨli nɨŋɨd, bɨ omɨŋal yokel, amɨl agɨlek, Nad chɨl ayɨp kasek ape amnun agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Agel Pita tɨkjakɨl, kɨlimɨŋal ayɨp Jopa amnak. Amɨl, nop poŋɨd, Tabita kumak ak dam lɨlak kal mɨgan adek alaŋ amnɨlak. Pen bin kaŋɨl ap yelak okok, bin kumak anɨb ak ned kɨm mɨdɨlɨg chech tap kɨlop yokɨp gɨñolɨgup okok, kɨli Pita nop yomɨlɨg chaŋ lɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ne pen binɨb ap yelak okok kɨlop ag seŋayaŋ yokak. Yokɨl, kɨgom yɨmɨl, God nop agɨl, tɨg adɨkɨl chɨp nɨgɨlɨg agak, Tabita. Tɨkjakan agak. Agek, bin anɨb ak Pita nop nɨŋɨd, tɨkjakɨl besɨgak. ");
INSERT INTO taw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ñɨn kɨd nop ak dɨl, dɨ jakñɨl, am binɨb Klays yɨl yelak okok sek, bin kaŋɨl okok sek, kɨlop agek apel agak, Tabita awl agak. ");
INSERT INTO taw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pen Pita anɨgek, takaw anɨb ak taun Jopa binɨb mɨdupsek nɨgɨlak. Nɨŋɨd, binɨb kuŋay yɨbɨl kɨli Bɨawl nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pen Pita ne taun Jopa anɨb ak, bɨ chag bulmakaw wak wog golɨgup olap ayɨp ñɨli pel yelɨgɨpil. Bɨ anɨb ak yɨb ne Saymon. ");
INSERT INTO taw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pen Lom bɨ chɨm kadɨŋ gep bɨawl olap, taun Sisaliya yolɨgup. Yɨb ne ak Koniliyus. Ne bɨ chɨm kadɨŋ gep kod yolɨgup okok, kɨlop Yitali bɨ chɨm kadɨŋ gep okok agelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bɨawl Koniliyus anɨb ak, binɨb kal nop ap yelɨgɨpal okok ayɨp, God nop gos nɨŋɨd kɨdek gelɨgɨpal. Ne Juda binɨb yɨmgeptek okok, kɨlop mani tap okok monmon ñolɨgup. Pen ne God nop mɨnek mɨnek agolɨgup. ");
INSERT INTO taw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mɨnek olap sub kɨyum gak won ak, day nɨgak, God ensel olap agyokek apɨl agak, Koniliyus agak. ");
INSERT INTO taw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Agek, nop nɨŋɨjsek lɨg pɨlɨkɨlɨg agak, Bɨawl. Yɨp taynen agak? Agek, ensel ak nop agak, Nad God nop agɨlɨg, binɨb yɨmgeptek okok kɨlop tap monmon ñɨlɨg gɨpan ak, nep sawl ma gup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nad bɨ ogɨnap age, am taun Jopa amɨl, bɨ Saymon Pita apal ak nop am agel ownɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ne bɨ olap ayɨp mɨdebil, ñɨg solwala gol ak agak. Bɨ olap anɨb ak, yɨb ne abe Saymon, bɨ chag bulmakaw wak wog golɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pen ensel ak takaw anɨb ak agɨl amnaknɨŋ, Koniliyus ne bɨ wog gɨñeb ne omɨŋal ak sek, bɨ chɨm kadɨŋ gep God nop gos nɨgak olap sek agek owlak. Bɨ chɨm kadɨŋ gep anɨb ak, ne Koniliyus ayɨp mɨdɨl, nop wog gɨñɨtep golɨgup. ");
INSERT INTO taw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Apelak, ensel ak takaw tɨtay agak ak kɨlop agñɨ tep gɨl, agyokek taun Jopa amnɨg saŋɨdɨlak. ");
INSERT INTO taw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Am am kanɨb nab ak kɨnɨlak. Mɨnek am am, subnab awl alaŋ won ak, taun Jopa wulep wulep gɨlak. Won anɨb ak Pita, God nop agɨnɨg amnak, kal adek alaŋ. ");
INSERT INTO taw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Amɨl, God nop ag mɨdaknɨŋ, nop yuwan gak. Pen binɨb ne okok, tap dagɨl gɨlaknɨŋ, ne day nɨgak. ");
INSERT INTO taw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Day nɨŋɨd nɨgak, wɨsɨp alaŋ mɨgan yɨkɨl, tap olap wad awl tek ak alaŋ nɨb lum ayaŋ owak. ");
INSERT INTO taw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wad mɨgan anɨb ak sab chag, yawl, yoy okok keke kuŋay yɨbɨl yek. ");
INSERT INTO taw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Takaw olap pen agak, Pita. Tɨkjakɨl tap ñɨŋeb anɨb pi okok pak ñɨŋan agak. ");
INSERT INTO taw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Agek pen agak, Bɨawl, mel agak. Chɨn Juda binɨb tap asɨŋ anɨb okok yad ma ñɨbin agak. Tap olap ñɨben, wɨdɨn mɨdup nak adek sɨŋak tep ma gup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Agek, takaw anɨb ak tepayaŋ agak, God tap tɨtay gek suŋ mɨdeb okok, tap asɨkep agɨl ma agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Day nɨgak anɨb ak, tepayaŋ nɨŋɨd tepayaŋ nɨŋɨd tepayaŋ nɨŋɨd gak. Won anɨb anep tap wad awl anɨb ak, adɨkɨd wɨsɨp alaŋ amnak. ");
INSERT INTO taw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Anɨgek, Pita day nepin anɨb ak tay gɨnɨgab agɨl, gos kuŋay nɨgak. Nɨg mɨdaknɨŋ, bɨ Koniliyus agyokek nop agnɨg owlak bɨ kab ak, kanɨbtub ak amjakɨlak. ");
INSERT INTO taw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Amjakɨl agɨlak, Bɨ Saymon, yɨb ne olap Pita apal ak, awl mɨdeb akaŋ agɨlak? ");
INSERT INTO taw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pen Pita ne day anɨb ak nɨg yek, God Kawnan ak Pita nop agak, Bɨ omɨŋal nokom apɨl nep pɨyowebal agak. ");
INSERT INTO taw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yad ke agen nep pɨyowebal anɨb ak, kɨlop gos kuŋay ma nɨgɨnɨmɨn agak. Tɨkjakɨl, ayaŋ amɨl, kɨli ayɨp amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Agek, ayaŋ amɨl kɨlop nɨŋɨd anɨb agak, Bɨ pɨyow nɨgebɨm ak nɨm, yad nokom agak. Yɨp takaw olap agɨnɨg opɨm akaŋ agak? ");
INSERT INTO taw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Agek agɨlak, Bɨawl Koniliyus, Lom bɨ chɨm kadɨŋ gep bɨawl olap, ne chɨnop agyokek opun agɨlak. Ne bɨ teplep yɨbɨl, God nop gos nɨŋɨd kɨdek gek, Juda kay nop nɨgel tep gup agɨlak. God ensel ne olap apɨl nop agak, Nad bɨ ogɨnap agyoke, am Saymon Pita nop poŋɨd apel, takaw agɨnɨmuŋ ak nɨgɨnɨmɨb agak agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Anɨb agel, Pita kɨlop agek kal mɨgan amɨl kɨnɨlak. Mɨnek Pita ayɨp, bɨ Jopa nɨb Jisas nop gos lɨnɨgɨlak ogɨnap ayɨp, Koniliyus agyokak bɨ tun ak ayɨp amnɨlak. Am am kanɨb nab ak kɨnɨlak. Mɨnek nɨm, taun Sisaliya amjakɨl, Koniliyus kal ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pen Koniliyus ne Pita apeb agɨl, binɨb ne okok sek, numi nɨmam ne okok sek kɨlop suk agek apnan gɨl yelak. ");
INSERT INTO taw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita amɨl, kal mɨgan amnɨg gaknɨŋ, Koniliyus nop tep gak. Anɨgek, Koniliyus am tob agen amɨl, kɨgom yɨm gɨlɨg, Pita yɨb nop ak dad aplanak. ");
INSERT INTO taw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Anɨgek, Pita nop dɨ jakñɨl agak, Jakan. Yad God mel, yad bɨ yokɨp nen agak. ");
INSERT INTO taw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Agek jakaknɨŋ, takaw agɨlɨg kal mɨgan ayaŋ amnɨlek. Amɨl, Pita nɨgak, binɨb kuŋay yɨbɨl apnan gɨl yelak. ");
INSERT INTO taw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nɨŋɨd, kɨlop agak, Nɨbi ke nepɨm, chɨn Juda okok, binɨb Juda mel ogɨnap ayɨp yonɨgun tek ma lup agak. Kal kɨli binɨb Juda mel okok wɨlɨkɨl ayɨp ma yonɨgun tek lup agak. Pen God yɨp takaw olap agak ak nɨm, binɨb ogɨnap asɨŋ mɨdebal agɨl, kɨlop asɨkɨnɨm tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Anɨb ak nɨŋɨd nɨm, Koniliyus takaw agup ak nɨŋɨd ma kelɨgɨpin, agup tek nɨŋɨd opin agak. Anɨb ak yɨp tay gɨnɨg agem opin agak? ");
INSERT INTO taw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pita anɨb agek, Koniliyus agak, Yad bɨ anɨb okok nep agyokɨpin ñɨn anɨb ak, nab sɨŋawl sub kɨyum gak won awl tek, kal mɨgan ayaŋ God nop ag mɨdɨlɨg nɨgɨnek, bɨ chech kayɨg yɨbɨl yɨmak olap, apɨl yenek sɨŋak mɨseŋ lak agak. ");
INSERT INTO taw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Gɨl agak, Koniliyus. Nad God nop agɨlɨg, mani tap okok binɨb yɨmgeptek okok kɨlop monmon ñɨban ak, God nɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Anɨb ak nɨm, bɨ ogɨnap agyoke, taun Jopa amɨl, bɨ Saymon yɨb nop olap Pita apal ak, poŋɨd ownɨgel agak. Ne bɨ olap ayɨp mɨdebil, ñɨg solwala gol ak agak. Bɨ olap anɨb ak, yɨb ne abe Saymon, bɨ chag bulmakaw wak wog golɨgup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ensel ak yɨp anɨb agek, yad kasek bɨyad ogɨnap agen, nep am poŋɨd apel nɨm, yɨp tep gup agak. Kal awl God ayɨp mɨdobun tek, takaw mɨdupsek kɨlop agɨnɨmɨn agɨl nep agup ak, chɨnop age nɨgun agak. ");
INSERT INTO taw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Koniliyus anɨb agek, Pita agak, Yad mɨñɨl nepin. God chɨnop Juda binɨb nep din agɨl gos ak ma nɨgup agak. Binɨb man okok mɨdupsek dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Man okok mɨdupsek, binɨb nop gos nɨŋɨd muk ne okok apɨl gɨtep yɨbɨl gɨnɨgabal okok, kɨlop dɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pen God chɨnop Yislel binɨb dɨnɨg, takaw teplep agak ak nepɨm agak. Takaw anɨb ak anɨgɨl agñɨlak, God ne chɨn ayɨp kɨmɨgel mɨdon agɨl, Jisas Klays nop agyokek owak agɨlak agak. Jisas ne Bɨawl ak, chɨnop mɨdupsek kod mɨdeb agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Tap anɨb anɨb gak ak man Yislel, bɨ ogɨnap agel nepɨm agak. Ned Jon Bɨ Ñɨg Pakñeb ak ñɨg pakñɨlɨg, takaw tep agñak agak. Kɨdek, tap anɨb okok jɨj gɨl gak, Galili plopens agak. Bɨ Jisas taun Nasalet nɨb, God ayɨp mɨdɨl nop aglup ak, God ne Kawnan ne ak Jisas nop yokek kod yek agak. Ne man okok ajɨl, binɨb yokɨp okok dɨtep gɨlɨg, binɨb kɨcheki bɨawl ak gek koslam yelak okok kɨlop gek, suŋ lak agak. Anɨgek, takaw anɨb ak ag dad amɨl, ag dad amɨl, binɨb Judiya mɨdebal okok mɨdupsek nɨgɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Pen Jisas, ne chɨn Juda binɨb man okok gɨ ajɨl, taun Jelusalem gɨ ajɨl gak gak tek, chɨn ke nɨgɨnok tek agebin agak. Nop mab bak alaŋ chɨpɨl pak tɨbɨk lel kumak ak pen, ");
INSERT INTO taw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ñɨn omɨŋal nokom mɨdɨl, God gek tepayaŋ tɨkjakɨl, apɨl mɨseŋ lek nɨgɨnok agak. ");
INSERT INTO taw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Binɨb mɨdupsek nop ma nɨgɨlak agak. God chɨnop binɨb ne aglup okok nep, nop yomek mɨseŋ nɨgɨnok agak. Chɨn nɨm ne kumɨl tɨkjakɨl, ayɨp jɨmñɨl tap ñɨŋɨnok agak. ");
INSERT INTO taw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Chɨnop agak, Takaw tep yad ak binɨb okok kɨlop agñɨtep gɨlɨg agɨnɨmɨb agak. Kɨdek God agek, bɨ aglup nokom nɨm ak, binɨb kumɨlak okok sek, binɨb kɨm yenɨgabal okok sek, kɨlop mɨdupsek tɨg asɨk bɨlokɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pen adek anɨb ak, bɨ God gos ñek agñeb okok mɨdupsek agɨlak, Klays ne apɨl gɨnɨgab tek, binɨb nop gos lɨnɨgɨnɨgabal okok, God kɨlop mɨdupsek tap si tap tɨmel gɨpal ak tɨg walɨg gɨyokɨnɨgab agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pen Pita anɨgɨl takaw ag mɨdaknɨŋ, binɨb mɨdupsek takaw anɨb ak nɨgɨlak okok, God Kawnan ak kɨlop bak lak. ");
INSERT INTO taw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Bak lek, takaw yɨbɨl keke agɨlɨg, God yɨb nop ak dad aplanɨlak. Anɨgelak, bɨ Juda Jisas nop gos lɨnɨŋɨd, Pita ayɨp owlak okok, kɨli judɨl nɨŋɨd anɨb agɨlak, God ne Kawnan ne ak, binɨb Juda mel okol kɨlop monmon yokek apɨl bak lup agɨlak. Pita pen agak, ");
INSERT INTO taw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","God Kawnan ne ak chɨnop yokak tek, mɨñɨl binɨb okol kɨlop abe yokup agak. Anɨb ak ñɨg pakɨnɨg agel, binɨb ogɨnap kɨlop mel agɨnɨgel tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Anɨb agɨl, bɨne ogɨnap agek, Jisas yɨl mɨdebal agɨl, kɨlop ñɨg pakñɨlak. Pakñelak agɨlak, Pita. Ñɨn kab olap chɨn ayɨp yenɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pen Pita binɨb Juda mel okok kɨlop God takaw ak agñek dɨlak anɨb ak, bɨ Jisas takaw nop dad ameb okok sek, binɨb Jisas yɨl yelak Judiya nɨb okok sek nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Anɨb ak kɨdek Pita Jelusalem amek, Juda bɨ wak tɨbɨlɨkɨnɨgun agelɨgɨpal okok, nop takaw kuŋay agɨl ");
INSERT INTO taw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","agɨlak, Nad taynen amɨl, binɨb wak ma tɨbɨlɨkɨpal okok ayɨp tap jɨmñɨl ñɨban agɨlak? ");
INSERT INTO taw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Anɨb agelak, Pita pen tap okok mɨdupsek gak agɨl kɨlop agñɨlɨg agak, ");
INSERT INTO taw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Yad taun Jopa mɨdɨl, God nop ag mɨdɨlɨg day nɨgɨnek, wad awl olap tek wɨsɨp alaŋ nɨb yɨp yɨl owak agak. ");
INSERT INTO taw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Apek, yad wad anɨb ak yek wulep sɨŋak amɨl nɨgɨnek, sab chag, yawl, yoy okok keke kuŋay yɨbɨl yek agak. ");
INSERT INTO taw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Takaw olap pen yɨp agak, Pita. Tɨkjakɨl tap ñɨŋeb anɨb pi okok pak ñɨŋan agak. ");
INSERT INTO taw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Agek pen agɨnek, Bɨawl, mel agɨnek agak. Chɨn Juda binɨb tap asɨŋ anɨb okok yad ma ñɨbin agɨnek agak. Tap olap ñɨben, wɨdɨn mɨdup nak adek sɨŋak tep ma gup agɨnek agak. ");
INSERT INTO taw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Agen, takaw anɨb ak wɨsɨp adek alaŋ nɨb apɨl tepayaŋ agak, God tap tɨtay gek suŋ mɨdeb okok, tap asɨkep agɨl ma agɨnɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Day nɨgɨnek anɨb anep, tepayaŋ nɨŋɨd, tepayaŋ nɨŋɨd, tepayaŋ nɨŋɨd gɨnek agak. Pen won anɨb anep tap wad awl anɨb ak, adɨkɨd wɨsɨp alaŋ amnak agak. ");
INSERT INTO taw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Won anɨb ak, bɨ omɨŋal nokom kal chɨn mɨdonok ak apjakɨlak agak. Bɨ anɨb okok bɨawl Koniliyus, taun Sisaliya nɨb ak agyokek, yɨp poŋɨdɨnɨg owlak agak. ");
INSERT INTO taw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","God Kawnan ak yɨp agak, Gos kuŋay ma nɨgɨnɨmɨn, kɨli ayɨp monmon amnɨmɨn agak. Anɨb agek, yad mam Jisas nop gos lɨnepal anep kagol nɨm okol ayɨp Koniliyus kal ak amnɨnok agak. ");
INSERT INTO taw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Amjakon, Koniliyus agak, Ensel olap kal mɨgan yad apɨl yɨp agak, Bɨ ogɨnap agenɨmɨn, taun Jopa amɨl, bɨ Saymon Pita apal ak nop poŋɨd ownɨgel agak. ");
INSERT INTO taw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Apel, nep Jisas takaw tep ak agñɨnɨgab agak. Agñek, takaw anɨb ak dem, God ne binɨb kal nad ayɨp mɨdebɨm okok mɨdupsek tɨg asɨk dek, binɨb ne yenɨgabɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Koniliyus yɨp anɨb agek, yad jɨj gɨl takaw agɨneknɨŋ, God Kawnan ne ak chɨnop ned yokak tek, binɨb anɨb okok kɨlop abe yokak agak. ");
INSERT INTO taw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yokek, Jisas chɨnop agak takaw ak gos nɨgɨnek agak. Ne agak, Jon binɨb kɨlop ñɨg pakñak, God ne pen Kawnan ne ak nɨbop pakñɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pen chɨn Bɨawl Jisas Klays nop gos lɨnɨgɨnok ñɨn ak, God Kawnan ne ak chɨnop yokɨp yokak tek, kɨlop abe yokak agak. Anɨb ak taydɨl God nop mel agɨnɨm agak? ");
INSERT INTO taw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita anɨb agek, bɨ nop takaw kuŋay agɨlak okok takaw anɨb ak nɨŋɨd, anɨb agɨlak, Gos nad ke nɨŋɨd, binɨb Juda mel okok kɨlop yɨl ma amnɨnak agɨlak. God kɨlop dɨnɨg, nep agek amnɨnak ak, takaw ma mɨdeb agɨlak. Anɨb agɨl, God nop tep agɨlɨg agɨlak, Chɨnop nep mel, binɨb Juda mel okok abe, tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgel, God kɨlop gek pelpel yenɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pen Stipen nop paklak ñɨn ak, binɨb Jisas nop gos lɨnɨgɨlak okok, kɨlop abe gɨ tɨmel gel, pɨlɨk keke amnɨlak. Ogɨnap pɨlɨk man Ponisiya amnɨlak, ogɨnap man olap Sayplus amnɨlak, ogɨnap taun Adiyok amnɨlak. Amɨl, Jisas takaw teplep ak binɨb Juda mel okok kɨlop ma agñɨlak, Juda binɨb okok kɨlop nep agñɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pen bɨ ogɨnap man Sayplus nɨb, ogɨnap taun Saylini nɨb pɨlɨk taun Adiyok amɨl, Bɨawl Jisas takaw teplep ak, Juda binɨb sek, Juda mel okok sek kɨlop agñɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","God kɨles ne ayɨp mɨdaknɨŋ, takaw agñel, binɨb kuŋay yɨbɨl Bɨawl nop gos lɨnɨŋɨd, tap gɨ tɨmel gɨpal okok kelɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pen Klays binɨb ne Jelusalem pelpel apnan gɨpal okok, kɨli takaw anɨb ak nɨŋɨd, bɨ Banabas nop agel taun Adiyok amnak. ");
INSERT INTO taw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Ne bɨ tep, God Kawnan nop bak lek, Jisas nop kɨles gɨl gos lɨnɨgak. Ak nɨm, man Adiyok amjakɨl, God binɨb okok ayɨp nep yek nɨŋɨd, nop tep gak. Kɨlop takaw ogɨnap sek agñɨtep gɨlɨg agak, God nop dɨpɨm ak, ma kelɨgɨnɨmɨb agak. Nop chɨgɨl nep yenɨmɨb agak. Wog anɨb ak gaknɨŋ, binɨb kuŋay yɨbɨl Jisas nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas pen, Sol nop am dad owin agɨl, taun Tasus amɨl pɨyowak. ");
INSERT INTO taw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pɨyow nɨŋɨd, poŋɨd adɨkɨd taun Adiyok owlek. Apɨl, sub nokom anɨb ak, Klays binɨb ne pelpel apnan gɨpal okok kɨlop God takaw tep ak agñɨlɨg yelek. Adiyok binɨb yokɨp okok, kɨli binɨb Jisas yɨl yelak okok kɨlop nɨŋɨd ned agɨlak, Kɨli Klisten binɨb mɨdebal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ñɨn anɨb ak, bɨ God gos ñek agñeb Jelusalem nɨb ogɨnap, Adiyok owlak. ");
INSERT INTO taw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Apel, God Kawnan ak bɨ kɨli Agabus nop gos ñek, ne tɨkjakɨl agak, Yuwan awl yɨbɨl ak, man awl mɨdupsek gɨnɨgeb agak. Agek, agak tek yuwan awl yɨbɨl ak, kɨdek Lom gapman bɨnonɨm Klodiyus kod yolɨgup ñɨn ak owak. ");
INSERT INTO taw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Adiyok binɨb Jisas yɨl yelak okok, kɨli takaw anɨb ak nɨŋɨd anɨb agɨlak, Binɨb Jisas nop gos nɨgɨlak Judiya plopens mɨdebal okok, yuwan mɨdebal tek, chɨn nokom nokom kɨlop mani ogɨnap ñɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Anɨb agɨl, mani lɨ nan gɨl, Banabas ayɨp Sol ayɨp kɨlop ñɨl agɨlak, Dad amɨl, bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok kɨlop ñɨnɨmil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ñɨn nab anɨb ak, gapman bɨnonɨm Helod, ne binɨb Klays yɨl yelak ogɨnap dɨl, kɨlop gɨ tɨmel yɨbɨl gɨnɨm agɨl nag lak. ");
INSERT INTO taw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bɨne okok kɨlop agek, kɨli baynat dɨl Jemis nop pɨsnep puŋɨl lel kumak. Jemis, ne Jon nɨmam ne ak. ");
INSERT INTO taw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Helod agek anɨgelak, Juda binɨb okok tep agɨl nɨgɨlak. Pen anɨgɨl nɨgɨlak tek, Helod Pita nop abe agek, dɨ nag lɨlak. Gɨlak anɨb ak, Juda ñɨn awl kɨli Pasopa bilet ñɨbal ñɨn nab sɨŋak gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Helod ne Pita nop anɨgɨl dam nag lɨl, bɨ chɨm kadɨŋ gep anep jel pɨs kɨd ak kɨlop bɨlok tɨgawup tɨgawup lɨl, subnab maynab kod nep yenɨmɨb agak. Helod gos ne nɨgak ak, Pasopa ñɨn awl ak apɨl padɨkek yɨl, kɨdek nop dad binɨb yenɨgabal nab ak amɨl, kot gɨnɨgabun agɨl nɨgak. ");
INSERT INTO taw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pen Pita anɨgɨl nag lɨl mɨdaknɨŋ, binɨb Jisas nop gos lɨnɨgɨlak okok, nop nen agɨl, God nop kɨles gɨl agnɨg yelak. ");
INSERT INTO taw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pen gapman bɨnonɨm Helod ne Pita nop kot gɨnɨm agɨl nɨgak ñɨn ak, maynab ayaŋ nop nag kɨles tɨmel omɨŋal tun gɨlak. Tun gɨl, bɨ chɨm kadɨŋ gep omɨŋal adaŋ adaŋ nɨg yɨleknɨŋ, Pita nab ayaŋ kɨnek. Bɨ chɨm kadɨŋ gep ogɨnap seŋayaŋ mɨdɨl, kanɨbtub ak nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Won anɨb ak, God ensel ne olap apɨl, kal mɨgan anɨb ak mɨlek pakñak. Pakñek, Pita tɨgɨlem nop pakɨl agak, Kasek tɨkjakan agak. Agek, nag kɨles tɨmel ñɨn nop tun gɨlak ak asɨkak. ");
INSERT INTO taw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ensel ak nop agak, Sɨbnag nad ak pog lɨl, tob tɨlup ak lan agak. Agek, agak tek gek, ensel ak agak, Chech palawl ak le amnul agak. ");
INSERT INTO taw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Agek, chech palawl ne ak lɨl, kal mɨgan yek ak kelɨgɨl, ensel ak ayɨp saŋɨdɨlek. Ensel gak anɨb ak, Pita ne agnɨgak eŋ, ak day nɨgebin agɨl nɨgak. ");
INSERT INTO taw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pen bɨ chɨm kadɨŋ gep nɨg yelak kanɨbtub omɨŋal ak sɨl gɨl, kanɨb kɨles tɨmel seŋayaŋ ak ke yɨkaknɨŋ, seŋayaŋ amnɨlek. Amɨl, kanɨb nab okok amɨlɨg, won anɨb anep ensel ak Pita nop kelɨgɨl amnak. ");
INSERT INTO taw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Anɨgek, nɨŋɨd anɨb agak, Mɨñɨl nɨgtep gebin agak. Ak Bɨawl nep, ensel ne ak agyokek, apɨl gapman bɨnonɨm Helod yɨp nag kɨles lup ak wɨsɨkup agak. Gapman bɨnonɨm Helod sek, Juda binɨb okok sek tap yɨp gɨnɨg gɨpal ak, gɨnɨgel tek ma lup agak. ");
INSERT INTO taw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Anɨb agɨl, gos anɨb ak nɨgtep gɨl, bɨ Jon Mak nonɨm Maliya kal ak amnak. Kal anɨb ak binɨb kuŋay yɨbɨl apɨl, God nop agnɨg yelak. ");
INSERT INTO taw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita apɨl, kanɨb ak pak gigu gek, pay Loda, ne kal anɨb ak bin wog gɨñeb ak, kanɨb ak yɨkɨnɨg owak. ");
INSERT INTO taw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Apɨl, Pita meg mɨgan anep agek nɨgak. Nɨŋɨd, mɨñmɨñ yɨbɨl gɨlɨg kanɨb ak sawl gɨl ma yɨkak, am binɨb okok kɨlop agak, Pita apɨl mɨdeb seŋayaŋ agak. ");
INSERT INTO taw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Agek agɨlak, Nep sawl lup ageban agɨlak. Anɨb agelak, kɨles yɨbɨl gɨl agak, Yepɨs ma apin. Nɨŋɨd yɨbɨl apin agak. Pita mɨdeb seŋayaŋ agak. Agek agɨlak, Ak ensel ne ak tek lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pen Pita kanɨb ak tepayaŋ pak gigu gek, am kanɨb ak yɨkɨl nɨgɨlak, Pita ne ke ap yek nɨŋɨd, wal yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wal agɨlaknɨŋ, kɨlop ñɨn tɨg mɨlɨch gɨl agak, Ma yɨbɨl agɨnɨmɨb agak. Anɨb agɨl, kalabus kal yeknɨŋ, God ensel olap yokek apɨl, nop tɨtay gɨl dad owak takaw ak, kɨlop agñak. Agñɨl agak, Nɨbi Jemis nop agñɨl, bɨ Jisas yɨl mɨdebal okol kɨlop agñɨl gɨnɨmɨb agak. Agɨl, kɨlop kelɨgɨl, wakay olap ke amnak. ");
INSERT INTO taw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mɨnek man tɨkaknɨŋ, bɨ chɨm kadɨŋ gep okok Pita ma yek nɨŋɨd, tay gup agɨl ag aplan apyan gɨ yelak. ");
INSERT INTO taw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gapman bɨnonɨm Helod ne anɨb ak nɨŋɨd, Pita nop kasek pɨyow nɨŋɨd dad owɨm agek, pɨyow mel nɨgelak, bɨ chɨm kadɨŋ gep okok kɨlop kot gɨl agek, bɨ anɨb okok kɨlop pɨsnep paklɨlak. Kɨdek Helod ne Judiya plopens kelɨgɨl, am taun Sisaliya yolɨgup. ");
INSERT INTO taw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ñɨn anɨb ak gapman bɨnonɨm Helod, ne taun Taya binɨb okok sek, taun Saydon binɨb okok sek nɨgek, nop mɨlɨk yowak. Pen kɨli tap mɨdup delɨgɨpal, man Helod ne kodolɨgup ak. Anɨb ak Taya Saydon binɨb jɨmñɨl apɨl nop nɨgɨlak. Pen kɨli ned bɨ Blastus nop ap agnɨgelak, ne yaw agak. Bɨ anɨb ak, Helod kal nop kod yolɨgup. Agek, Helod nop am nɨŋɨd anɨb agɨlak, Chɨnop mɨlɨk ma nɨgɨnɨmɨn, kɨmɨgel jɨmñɨl yonɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Helod takaw anɨb ak nɨŋɨd, ñɨn olap takaw agɨnɨgayn agɨl aglak. Ñɨn anɨb ak apek, bɨnonɨm kay lɨpal chech teplep yɨbɨl okok lɨl, bɨnonɨm besɨgep adek ak besɨgɨl, binɨb okok kɨlop takaw agñak. ");
INSERT INTO taw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Agñek agɨlak, Ak bɨ tek ma agup, God tek olap agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pen God nop kelɨgɨl, yɨb ne ak ke dad aplanak tek, won anɨb ak God ensel olap agyokek, ap nop pakek tap awl gɨl, gogajɨŋ lek kumak. ");
INSERT INTO taw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pen God takaw ak agñel amnaknɨŋ, man okok kɨd kɨd amnak. ");
INSERT INTO taw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ayɨp Sol ayɨp Jelusalem mɨdɨl, gɨnɨg owlek ak gɨjɨpul agɨl, Jon Mak nop poŋɨd adɨkɨd taun Adiyok amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Taun Adiyok anɨb ak, Klays binɨb ne ogɨnap pelpel apnan gelɨgɨpal. Bɨ God gos ñek agñeb ogɨnap, bɨ God takaw agñɨtep gep ogɨnap yelak. Bɨ anɨb okok nɨm, olap Banabas, olap Simiyon. Bɨ Simiyon yɨb ne olap Nayjel agelɨgɨpal. Olap nɨm, Lusiyus. Ne taun Saylini nɨb. Olap Manayn, ne nɨm gapman bɨnonɨm Helod bogɨlak ne ak. Olap Sol. ");
INSERT INTO taw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pen bɨ anɨb okok, tap ma ñɨbɨl, God nop nokom gos nɨŋɨd agnɨg mɨdɨlaknɨŋ, God Kawnan ak kɨlop agak, Nɨbi Banabas ayɨp, Sol ayɨp kɨlop agenɨmɨb, wog kɨlop agɨnek ak gel amnɨmuŋ agak. ");
INSERT INTO taw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anɨb agek, tap ma ñɨbɨl, God nop agɨlɨg yelak. Mɨdɨl, Banabas ayɨp, Sol ayɨp kɨlop ñɨn dɨ mɨdɨlɨg, God ñɨli ayɨp yenɨgab agɨl agyokɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","God Kawnan ak Banabas ayɨp Sol ayɨp kɨlop kod mɨdaknɨŋ, bɨ Jon Mak nop wog chɨnop ogɨnap gɨnɨmuŋ agɨl, poŋɨd amnɨlak. Taun Selusiya ayaŋ amɨl, sip dɨl, man ñɨg tɨb kus gak Sayplus amnɨlak. Amɨl, taun Salamis amɨl, Banabas ayɨp, Sol ayɨp Juda apnan gɨpal kal okok amɨl, binɨb okok kɨlop God takaw agñɨlek. ");
INSERT INTO taw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Pen binɨb man anɨb okok, God takaw agñɨ dam dam, taun Papos amjakɨlak. Man Papos anɨb ak, gapman bɨawl kɨli ak yek, yɨb ne Segiyus Polus. Bɨ anɨb ak ne bɨ gos kɨd yɨbɨl agɨl nɨgolɨgup. Ne Banabas ayɨp, Sol ayɨp kɨlop, yɨp God takaw tep ak agel nɨgin agɨl, agek apɨl, takaw tep ak agñɨlek. Agñel nɨŋɨd, bɨawl ne Juda nɨb olap, kuj tap okok nep gɨlɨg, yad bɨ God gos ñek agñeb agolɨgup ak yek. Ne pen anɨb agak, Bɨ omɨŋal anɨb ak, takaw agebil ak ma dɨnɨmɨn agak. Bɨ anɨb ak ne kuj gubay golɨgup ak, yɨb ne Baljisas. Pen Glik takaw agɨl, Elimas agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol yɨb nop olap nɨm, Pol agelɨgɨpal. Pen God Kawnan ak Pol nop gos tep ñaknɨŋ, ne Elimas nop nɨŋɨjsek lɨl mɨdɨl agak, ");
INSERT INTO taw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nep kɨcheki bɨawl ak tɨkak, pel gɨ tɨmel yɨbɨl gɨpan agak. God takaw tep apal ak ma yɨbɨl nepan agak. Tap tɨtay tep mɨdeb ak kelɨgɨl, binɨb okok kɨlop yepɨs yɨbɨl gɨpan agak. Ñɨn akal tek nɨgɨnɨgaban agak? ");
INSERT INTO taw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Anɨgɨpan ak God nep gos tɨmel nɨŋɨd gek, ñɨn kuŋay wɨdɨn koy gɨl nep yenɨgaban agak. Pol takaw anɨb ak agaknɨŋ, Elimas nɨgak, wɨsɨp gach tek bad olap, ap wɨdɨn nop ak yu gak. Anɨgek, bɨ olap ayɨp kanɨb yomaŋ agɨl, tɨg tɨtɨkol gak. ");
INSERT INTO taw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gaknɨŋ, gapman bɨawl Segiyus Polus nɨŋɨd Jisas nop gos lɨnɨgak. Wal yɨbɨl agɨl, God takaw anɨb ak gos kɨles gɨl nɨgak. ");
INSERT INTO taw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pen Pol bɨne okok ayɨp sip dɨl, taun Papos kelɨgɨl, Pampiliya plopens taun Pega nab ak amnɨlak. Am mɨdɨl, Jon Mak ne kɨlopmɨŋal kelɨgɨl, adɨkɨd Jelusalem amnak. ");
INSERT INTO taw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kɨli pen taun Pega kelɨgɨl, Pisidiya plopens taun Adiyok nab ak amnɨlek. Am mɨdɨl, Juda añɨŋ lep ñɨn awl ak apek, Juda apnan gɨpal kal ak amɨl besɨg yɨlek. ");
INSERT INTO taw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bɨ Juda apnan gɨpal kal ak kod yelɨgɨpal okok, kɨli tɨkjakɨl, Mosis takaw tɨkak ogɨnap, bɨ God gos ñek agñeb tɨkɨlak ogɨnap agñɨlak. Agñɨl, bɨ olap nop agyokel, apɨl Pol ayɨp, Banabas ayɨp kɨlop agak, Mam omɨŋal agak. Binɨb okol nɨg dɨnɨgel tek takaw tep ogɨnap yonɨmuŋ, kɨlop agñɨnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Agelak, Pol tɨkjakɨl takaw agɨnɨg, ñɨn dad aplanɨl agak, Nɨbi Juda bɨ okok sek, nɨbi binɨb Juda mel God nop muk okok mɨdɨl pel agnepɨm okok sek, takaw agɨnɨgebin awl tɨmud pak nɨg yenɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chɨn Yislel binɨb mɨñɨl mɨdobun awl, bɨlel based yes chɨnop okok, God kɨlop aglɨl agak, Nɨbi binɨb yad yɨbɨl mɨdebɨm agak. Anɨb agɨl kɨlop dak ak nɨm, kɨdek kɨli man Yijip am yelaknɨŋ, kɨlop kod mɨdtep gek, ñɨpay gɨlɨl kuŋay yɨbɨl yelak agak. Pen kɨdek ñɨn ak, God tap mageptek okok gɨl, man Yijip kelɨgɨl kɨlop poŋɨd owak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kɨli man nep binɨb ma yelak nab okok mɨdɨl, yɨlɨk malɨk agelɨgɨpal ak pen, kɨlop kod mɨdtep gek, sub anep 40 yɨnak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pen kɨdek, Yislel binɨb kɨlop dap man Kenan, binɨb kuŋay yɨbɨl, man anep kugul ak ned yelak okok, kɨlop ogɨnap paklɨl, ogɨnap yuk yokak agak. Yuk yokek, man anɨb ak Yislel binɨb kɨlop ñek dɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kɨli Yijip mɨdel sub yɨnak ak ñɨn pagɨl, man nep binɨb ma yelak nab okok mɨdel sub yɨnak ak ñɨn pagɨl, binɨb yuk yokɨl, man anɨb ak dɨlak sub yɨnak ak abe ñɨn pagɨl gel nɨm, sub anep 450 tek yɨnak agak. Pen God kɨlop dap man anɨb okok lɨl, bɨawl takaw tɨg asɨkep ogɨnap aglek, kɨlop kod yelɨgɨpal agak. Kɨdek bɨ God gos ñek agñeb Samwel yek ñɨn ak, ");
INSERT INTO taw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","bɨ Yislel okok kɨli agɨlak, Chɨn bɨnonɨm man chɨnop mɨdupsek kod yenɨgab olap dɨnɨgun agɨlak agak. Agelak, God ne Sol nop aglek, bɨnonɨm kɨli yolɨgup agak. Sol bapi ne ak Kis agak. Nop Bejamin jɨj ak tɨk dad amɨl tɨkɨlak agak. Ne kɨlop kod yolɨgup, sub anep 40 yɨnak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pen kɨdek God Sol nop yokɨl, Depid nop aglek, ne bɨnonɨm mɨdɨl kɨlop kod yolɨgup agak. Anɨgɨl kod mɨdaknɨŋ, God agak, Jesi ñɨne Depid, ne bɨ tep yɨbɨl mɨdɨl yɨp tep gup, apin tek nep gɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Anɨb agɨl kɨdek agak, Yad gen, Depid tɨkek tɨk dad amɨl tɨkɨnɨgabal bɨ olap, ne Yislel binɨb bɨ kasɨn gep kɨli mɨdɨl, kɨlop dɨl God ayɨp jɨmñɨl lɨnɨgab agak. Agek nɨm, Jisas nop tɨkelak, agak tek nep gak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pen Jisas tɨkjakɨl wog ma gak ñɨn ak, Jon apɨl Yislel binɨb kɨlop mɨdupsek agak, Chɨn tap si tap tɨmel gɨpun ak taynen anɨgɨpun agɨl kelɨgem, nɨbop ñɨg pakñɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pen Jon binɨb okok kɨlop God takaw agñɨ dad amɨl, kɨdek ñɨn olap agnɨŋɨd agak, Nɨbi yɨp an agɨl gos nepɨm agak? Bɨawl pel kod mɨdobun ak nɨm, owup agɨl nepɨm agak? Yad bɨawl yɨbɨl anɨb ak mel, ne kɨdek ownɨgab agak. Nop nɨgen yɨp nebeŋ gup, tob tɨlup nop nag ma wɨsɨkɨnɨgayn agak. ");
INSERT INTO taw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pen nɨbi Eblaham jɨj ak sek, nɨbi binɨb Juda mel God nop muk okok mɨdɨl pel agnepɨm okok sek, nɨgɨm agak. God takaw ne binɨb kɨlop tɨg asɨk dɨnɨgab ak, takaw chɨn yɨbɨl agak. ");
INSERT INTO taw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jelusalem binɨb okok sek, bɨawl kɨli okok sek, kɨli Juda apnan gɨpal kal ak amɨl, Juda añɨŋ lep ñɨn awl mɨdupsek kɨli bɨ God gos ñek agñeb okok takaw kɨl tɨkɨlak ak nepal agak. Pen Klays kɨdek ownɨgab agɨl tɨkɨlak takaw anɨb ak, nɨgtep ma gɨlak agak. Jisas apek nop kelɨgɨlak agak. Ned bɨ God gos ñek agñeb okok, kɨli tɨkɨl agɨlak, Nop pɨsnep paklɨnɨgabal agɨl tɨkɨlak ak, agɨlak tek nep gɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ne tap tɨmel olap gup akaŋ agɨl, pɨyow mel nɨgɨlak ak pen, gapman bɨawl Paylat nop agɨlak, Nop paklɨnɨmɨn agɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Agel, nop bɨ God gos ñek agñeb okok gɨnɨgab agɨl agɨlak tek nep gɨlak agak. Pen anɨgɨl gelak, binɨb ne okok apɨl nop tɨg asɨk dam kab mɨgan ak kamɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kamel, God gek tepayaŋ tɨkjakak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tɨkjakek, binɨb ne ayɨp Galili plopens kelɨgɨl Jelusalem owlak okok, nop mɨnek kuŋay yɨbɨl nɨgɨlak tek, Yislel binɨb okok kɨlop agñel nɨgebal agak. ");
INSERT INTO taw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Mɨñɨl mɨdobun nab awl, God ne Jisas nop gek tepayaŋ tɨkjakak takaw teplep ak, nɨbop agobul agak. Pen takaw anɨb ak kɨdeyɨl mel, God bɨlel based yes sɨkop kɨlop agek, kod yelɨgɨpal takaw anep agobul agak. Buk Baybol day olap, Buk Kɨmep ñɨn kɨd peŋ palak apal ak, takaw anɨb ak tɨkɨl agak, Nad Ñɨ yad agɨl tɨkak agak. Yad mɨñɨl nap nad mɨdebin agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God agak anɨb ak, ñɨne kumek, gek tepayaŋ tɨkjakak ak nɨm, kɨdek kumɨl kuyɨg yownɨmuŋ tek ma lup agak. God Ñɨne Jisas nop gek pɨsnep tɨkjakɨnɨgab takaw ak agɨnɨg, tɨkɨl agak, Yad Depid nop dɨtep gɨnɨgayn agɨl takaw aglɨnek tek, nɨbop gɨnɨgayn agɨl tɨkak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Adek anɨb ak nep nɨm, buk Baybol takaw ogɨnap tɨkɨl agɨlak, Ñɨ suŋtep nad, nep wog gɨñeb ak, ma kuyɨg yownɨgab agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pen Depid God nop gos nɨŋɨd agak tek kɨdek gɨl, binɨb ne okok kɨlop wog gɨñɨ dad amɨl kumak agak. Kumek, nap nɨsed sɨkop kɨlop kumelɨgɨpal okok dam kamel, kuyɨg yowak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bɨ agɨlak anɨb ak pen kumek, God gek tɨkjakak ak nɨm, ma kuyɨg yowak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bɨ anɨb ak Jisas nop nokom agɨlak agak. Anɨb ak nɨm, God tap si tap tɨmel gɨpɨm ak tɨg walɨg gɨyokɨnɨgab agɨl, nɨbop anɨb agobul agak. ");
INSERT INTO taw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chɨn takaw Mosis ñu kɨl tɨkak anep nɨŋɨd gonɨgabun, God tap si tap tɨmel gɨpun ak nɨg nep yenɨgab agak. Pen Jisas nop gos lɨnɨgonɨgabun, tap si tap tɨmel gɨpun ak tɨg walɨg gɨyokɨl, binɨb suŋtep yad okok agɨnɨgab agak. ");
INSERT INTO taw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pen nɨbi bɨ God gos ñek agñeb okok, bɨlel agɨlak tek gɨnɨmɨb tek lup ak, gos nɨgtep gɨnɨmɨb agak. Kɨli tɨkɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Binɨb nɨŋɨd yɨmel yɨbɨl apɨm okok nɨgtep gɨnɨmɨb agɨl tɨkɨlak agak. Nɨbi mɨdebɨm won awl, tap awl olap gɨnɨgayn ak nɨbop ned agñebɨlap, yepɨs apal apɨkep tek lup agɨl tɨkɨlak agak. Anɨb ak gos kuŋay nɨgɨlɨg kumnɨmɨb agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol ayɨp, Banabas ayɨp takaw anɨb ak agɨl, Juda apnan gɨpal kal ak seŋ amnɨleknɨŋ, binɨb okok agɨlak, Wik ped ak añɨŋ lep ñɨn awl chɨn ak jɨtep apɨl, chɨnop takaw anɨb ak ogɨnap sek agñɨnɨmil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pen kal ak kelɨgɨl, keke amnɨlaknɨŋ, Juda binɨb kuŋay okok, binɨb Juda mel pen Juda binɨb gɨpal tek adek ak kɨdek gɨl God nop agnɨgɨlak kuŋay okok, kɨli Pol ayɨp, Banabas ayɨp kɨlop kɨdek gɨl amnɨlak. Kanɨb nab ak amɨlɨg, kɨlop agtep gɨl agɨlek, God chɨnop yɨmug nɨŋɨd gɨtep gup agɨl, gos ak nɨgɨlɨg nep yenɨmɨb agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Juda añɨŋ lep ñɨn awl kɨdek ak, binɨb taun anɨb ak yelak okok mɨdupsek tek, God takaw nɨgɨnɨg apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Anɨgelak, bɨ Juda ogɨnap kɨli Pol ayɨp, Banabas ayɨp kɨlop nɨgel, mɨlɨk tɨmel yɨbɨl yowak. Yapek, binɨb okok kɨlop takaw tɨtay agɨlek ak agjuwɨl, kɨlop omɨŋal agjuwɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Anɨgɨl agjuwelak, Pol ayɨp, Banabas ayɨp kɨlop monmon kɨles gɨl agɨlek, Takaw anɨb ak, nɨbop Juda binɨb ned agep tek ak apul ak pen, nɨbi takaw anɨb ak tɨbɨlɨkɨpɨm agɨlek. Tɨbɨlɨkɨl, pelnep mɨdep ak ma dɨnɨgabun apɨm ak, mɨñɨl binɨb Juda mel okok kɨlop agñɨnɨgabul agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Taynen? Bɨawl chɨlop anɨgɨl agak agɨlek. Ne agak, Yad apin ak nɨm, nad binɨb Juda mel okok mɨlek kɨli ak mɨdeban agak agɨlek. Takaw yad ak man okok mɨdupsek agñe nɨm, binɨb takaw yad ak nɨŋɨd dɨnɨgabal okok kɨlop adɨkɨd tɨg asɨk dɨnɨgayn agak agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Binɨb Juda mel okok takaw anɨb ak nɨgelak, kɨlop tep yɨbɨl gek, God takaw ne ak tep yɨbɨl agɨlak. Anɨb ak binɨb God pel pelnep yenɨgel agɨl aglup okok mɨdupsek, nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pen Bɨawl takaw ak, man anɨb okok mɨdupsek palsek amnak. ");
INSERT INTO taw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pen Juda binɨb okok, kɨlop mɨlɨk yapek, amɨl man anɨb ak bɨawl okok ayɨp, binawl Juda mel pen Juda binɨb gɨpal tek adek ak kɨdek gɨl God nop agnɨgɨlak okok ayɨp, kɨlop agel, gos tɨmel nɨgɨlak. Nɨgelak, kɨli am binɨb kuŋay yɨbɨl dad apɨl, Pol ayɨp, Banabas ayɨp kɨlop gɨ tɨmel gɨl agyokɨlak. ");
INSERT INTO taw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Agyokelak, taun Adiyok anɨb ak kelɨg amnɨg, binbɨ okol takaw ak dad apol ma nepal agɨl, tob sɨlkul okok pakel yapek, taun Aykoniyam amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pen Adiyok binɨb Jisas nop gos lɨnɨgɨlak okok, God Kawnan ak kɨlop kod mɨdaknɨŋ, mɨñmɨñ yɨbɨl gɨlɨg yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol ayɨp, Banabas ayɨp am taun Aykoniyam yɨlek. Ned kɨli taun Adiyok mɨdɨl wog gɨlek day ak, gos kɨli nokom nɨŋɨd gɨlek. Juda apnan gɨpal kal ak amɨl, takaw agtep yɨbɨl gɨlek. Juda binɨb dɨl, binɨb Juda mel okok dɨl, kuŋay yɨbɨl Jisas nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pen Juda binɨb ogɨnap agɨlak, Takaw kɨli omɨŋal apil ak ma dɨnɨgabun agɨlak. Kɨli anɨb agɨl, am binɨb Juda mel okok kɨlop agɨlak. Agel, binɨb Juda mel okok, kɨli binɨb Jisas nop gos lɨnɨgɨlak okok kɨlop mɨlɨk nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pen Pol ayɨp, Banabas ayɨp takaw anɨb ak nɨŋɨd, man anɨb ak ma kelɨg amnɨlek. Mɨdɨlɨg, Bɨawl chɨnop yɨmug nɨŋɨd gɨtep gup agɨl, takaw teplep anɨb ak kɨles gɨl monmon agñelɨgɨpil. Pen God kɨlop omɨŋal kod mɨdaknɨŋ, tap mageptek okok gelek, binɨb okok nɨŋɨd, takaw agebil anɨb awl, nɨŋɨd yɨbɨl agebil agɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pen taun Aykoniyam binɨb anɨb okok, asɨk keke lɨlak. Pɨs olap bɨ Jisas takaw nop dad ameb omɨŋal ak takaw agɨlek tek nɨgɨlak, pɨs olap Juda binɨb agɨlak tek nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pen Juda binɨb okok ayɨp, binɨb Juda mel ogɨnap ayɨp, bɨawl kɨli okok ayɨp, kɨli Banabas ayɨp, Pol ayɨp kɨlop gɨ tɨmel gɨl, kab ju paklun agɨl gos ak nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kɨli omɨŋal pen takaw anɨb ak nɨŋɨd, pɨlɨk taun Listla ayɨp Debi ayɨp, Likoniya plopens nab okok amɨl, anɨb okok ajɨlɨg, ");
INSERT INTO taw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","God takaw teplep ak agñɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pen taun Listla anɨb ak, bɨ olap nonɨm nop tɨkak ñɨn ak nep tob tɨmel gak ak yek. Bɨ anɨb ak ne besɨg mɨdɨlɨg, ");
INSERT INTO taw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pol takaw agaknɨŋ nɨg yek. Pol bɨ anɨb ak nop nɨŋɨd, bɨ anɨb awl yɨp gek suŋ lɨnɨgab agɨl nɨg mɨdeb tek lup agɨl, Pol ne nop nɨŋɨjsek lɨl, ");
INSERT INTO taw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","takaw awl agɨl agak, Jakan agak. Agek, kasek tɨkjakɨl amnak. ");
INSERT INTO taw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pol anɨgek, binɨb nɨg yelak okok takaw yɨbɨl kɨli Likoniya takaw ak agɨl agɨlak, Bɨ wɨsɨp alaŋ nɨb okok, bɨ yɨbɨl tek lɨl, apɨl agebil awl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Anɨb agɨl, Banabas nop agɨlak, Ak bɨ Sus, pel agnopun ak agɨlak. Pen Pol nop agɨlak, Ak bɨ takaw agep Hemes, pel agnopun ak agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tap Sus agɨl agnɨgelɨgɨpal anɨb ak, kal nop agnɨgep gɨlak ak, taun kab wali gol anɨb ak yek. Ak nɨm, bɨ Sus nop sɨbogep bɨawl ak, ne bɨ Sus pel agnopun ak mɨñɨl owup awl agɨl, chag bulmakaw aŋlam ogɨnap dɨl, mab sum teplep ogɨnap dɨl dad owak, kab wali kanɨbtub ak. Bɨawl anɨb ak ayɨp, binɨb kuŋay yɨbɨl ayɨp apɨl, chag bulmakaw ogɨnap Banabas ayɨp Pol ayɨp kɨlop pak sɨbog ñɨnɨg gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pen bɨ Jisas takaw nop dad ameb omɨŋal ak, Pol ayɨp Banabas ayɨp, binɨb kɨli gɨnɨg gɨlak anɨb ak nɨŋɨd, chɨlop taynen God tek anɨgebal agɨl, chech kɨli omɨŋal okok tɨg talɨkɨl, binɨb kuŋay yelak nab anɨb ak amɨl suk agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Anɨb agɨlek, Bɨ okok, taynen anɨb won ak gebɨm agɨlek? Chɨl God mel, bɨ yɨbɨl yɨpɨd gɨl agɨlek. Pen God bɨawl yɨbɨl tap okok mɨdupsek gɨlak ak, takaw teplep nop ak dad apobul agɨlek. Ne adekab alaŋ gɨlɨl, lum awl gɨlɨl, ñɨg solwala ak gɨlɨl, tap okok mɨdupsek gɨlɨl gak agɨlek. Chɨl takaw teplep nop ak agol, tap yokɨp agnepɨm okok kelɨgɨl, God pel mɨdep ak nop agnɨg yenɨmɨb agɨl nɨbop agobul agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bɨlel tɨkɨl, binɨb man keke okok tɨtay gɨlak ak, God ne takaw ma agak agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","God pen we gɨl ma yolɨgup, mɨseŋ yolɨgup agɨlek. Mɨnek mɨnek nɨbop dɨtep gɨlɨg, gek man pakɨl, tap mɨdup kuŋay jak mɨdaknɨŋ, mɨñmɨñ gɨpɨm agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Anɨb agɨlek ak pen, binɨb anɨb okok bɨ omɨŋal wɨsɨp alaŋ nɨb opil agɨl, chag bulmakaw aŋlam ogɨnap pak sɨbog ñɨnɨg gelak, koslam ag ag tɨpagɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pen Juda binɨb ogɨnap taun Adiyok sek, taun Aykoniyam sek, kɨli apɨl, binɨb kuŋay anɨb okok kɨlop yepɨs agɨl agɨlak, Bɨ omɨŋal yepɨs agebil agɨlak. Anɨb agelak, binɨb anɨb okok nɨŋɨd, Pol nop kab ju paklɨl, pɨsnep kumeb agɨl, lɨpɨg dam kab wali gɨlak ak beŋ okyaŋ yokɨlak. ");
INSERT INTO taw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yokelak, binɨb Jisas nop gos lɨnɨgɨlak okok, ap puŋɨl kuskus gelak, Pol tɨkjakɨl, adɨkɨd taun Listla mɨgan ayaŋ amnak. Mɨnek, ne ayɨp, Banabas ayɨp taun anɨb ak kelɨgɨl, taun Debi amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol ayɨp Banabas ayɨp, taun Debi amɨl, Jisas takaw teplep ak binɨb okok kɨlop agñelek, binɨb kuŋay yɨbɨl Jisas nop gos lɨnɨgɨlak. Pen kɨli omɨŋal ned opul anep amnɨgul agɨl, adɨkɨd taun Listla, taun Aykoniyam, Pisidiya plopens taun Adiyok man anɨb okok amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Amɨlɨg, binɨb ned Jisas takaw agel nɨgɨlak okok, kɨlop tepayaŋ ak agñɨtep gɨlɨg agɨlek, Jisas takaw ak ma kelɨgɨnɨmɨb, nop gos lɨnepɨm tek nep nɨgɨnɨmɨb agɨlek. Anɨgem, nɨbop mɨŋel ñɨnɨgabal ak pen, tap anɨb ak gos ak ma nɨgɨnɨmɨb agɨlek. God chɨnop dɨl kod mɨdɨl man ne alaŋ dad amnɨgab agɨl, kɨles gɨl gem amnɨmuŋ agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Anɨb agɨlɨg, man keke Klays binɨb ne pelpel apnan gɨpal ak, bɨ Klays binɨb ne okok kɨlop kod mɨdebal ogɨnap aglɨlek. Aglɨl, tap ma ñɨbɨl, Bɨawl nop agnɨgɨlɨg agɨlek, Bɨ okol, nep gos lɨnepal tek, kɨlop kod yenɨmɨn agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Man Pisidiya okok anɨgɨl ajɨl, Pampiliya plopens okok amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Taun Pega amjakɨl, God takaw ak binɨb anɨb okok kɨlop agñɨl, taun Ataliya ayaŋ amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Amɨl, sip dɨl, Siliya plopens taun Adiyok ned mɨdɨl owlek ak adɨkɨd amnɨlek. Kɨli ned amnɨg gelek, Adiyok binɨb Jisas nop gos lɨnɨgɨlak okok, God nop agnɨŋɨd agɨlak, Takaw tep nad ak binɨb okok kɨlop agñɨnɨg amebil tek, kɨlopmɨŋal kod mɨdtep gɨnɨmɨn agɨlak. Agɨl, kɨlopmɨŋal agyokel, am takaw anɨb ak mɨdupsek agñɨ ajelɨgɨpil. ");
INSERT INTO taw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anɨb ak adɨkɨd Adiyok apɨl, binɨb Jisas nop gos lɨnɨgɨlak okok kɨlop suk agɨlek. Agel apelak agɨlek, Nɨbi chɨlop God nop agnɨg yɨbeknɨŋ, God chɨlop kod mɨdtep gak agɨlek. Jisas takaw tep ak agñɨ ajol, binɨb Juda mel okok, God kɨlop kanɨb yɨkak, kɨli kuŋay yɨbɨl Jisas nop gos lɨnepal agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kɨlop anɨgɨl agñɨl, kɨli ayɨp pel yelɨgɨpil. ");
INSERT INTO taw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pen bɨ ogɨnap Judiya plopens nɨb apɨl, binɨb Jisas nop gos lɨnɨgɨlak taun Adiyok yelak okok kɨlop agɨlak, Mosis chɨnop Juda binɨb okok agak, God bɨne mɨdɨnɨg, wak tɨbɨlɨkɨnɨmɨb agak agɨlak. Anɨb ak nɨbi anɨb ma genɨgabɨm, God nɨbop tɨg asɨk dɨnɨmuŋ tek ma lup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol ayɨp Banabas ayɨp pen nɨgɨlek, bɨ Juda takaw agɨlak ak yɨpɨd gɨl ma yek. Yɨpɨd ma gup agɨl, kɨli ayɨp penpen yɨbɨl ag amnɨlak. Anɨgelak, Adiyok binɨb Jisas nop gos lɨnɨgɨlak okok agɨlak, Bɨ ogɨnap agyokon, Pol ayɨp, Banabas ayɨp Jelusalem amnɨgel agɨlak. Amɨl, bɨ Jisas takaw nop dad ameb okok sek, bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok sek takaw ag dap yep lɨnɨgel agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Anɨb agɨl, kɨlop agyokɨlak. Am am Ponisiya plopens nab ak amɨlɨg, binɨb Jisas nop gos nɨgɨlak okok kɨlop agɨlak, Man okok binɨb Juda mel okok abe, kɨli tap tɨmel kelɨgɨl Jisas nop gos lɨnɨgebal agɨlak. Anɨb agelak, kɨlop tep gak. Ponisiya plopens anɨb ak kelɨgɨl, Samaliya plopens amɨl, kɨlop takaw anɨb ak tek nep agelak, kɨli abe nɨgel tep gak. ");
INSERT INTO taw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pen Samaliya plopens kelɨgɨl, Jelusalem amjakel, bɨ Jisas takaw nop dad ameb okok sek, bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok sek, binɨb Jisas nop gos nɨgɨlak yokɨp okok sek kɨlop nɨŋɨd ag dɨdeg lɨlak. Anɨgelak, Banabas ayɨp, Pol ayɨp pen agɨlek, God chɨn ayɨp ajɨl nɨm, takaw tep agñon, binɨb man okok kuŋay yɨbɨl Jisas nop gos lɨnɨgebal agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Anɨb agelek, bɨ Pelisi Jisas nop gos lɨnɨgɨlak ogɨnap, kɨli tɨkjakɨl agɨlak, Binɨb Juda mel okok, Jisas nop gos lɨnɨgebal ak, kɨli wak tɨbɨlɨkɨl, Mosis agak agak tek mɨdupsek kɨdek gɨnɨgel agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Anɨb agelak, bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok mɨdupsek, kɨli takaw anɨb ak agtep gun agɨl apnan gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Apnan gɨl, takaw ag dam nab pakaknɨŋ, Pita tɨkjakɨl agak, Mam sɨkop, nɨb nepɨm agak. God chɨnop wog keke agup tek, bɨlel binɨb Juda mel okok agem yɨp gos lɨnɨgɨnɨgel agɨl, yɨp agek, am kɨlop takaw teplep ne ak agñɨnek agak. ");
INSERT INTO taw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God gos chɨnop mɨdupsek nɨgup ak, binɨb Juda mel okok kɨlop nɨgek nop tep gek, dɨnɨgayn agɨl gos nɨgak agak. Nɨŋɨd, Kawnan ne chɨnop yokak tek, kɨlop abe yokak agak. ");
INSERT INTO taw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Chɨnop takaw olap ke agɨl, kɨlop takaw olap ke agɨl ma gup agak. Chɨnop mɨdupsek takaw adek nokom agak ak nɨm, nop gos lɨnɨgon, tap si tap tɨmel gɨpun ak wik yokup tek, kɨlop abe gup agak. ");
INSERT INTO taw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","God kɨlop pɨsnep dup anɨb ak, nɨbi taynen God chɨnop tay gɨnɨmuŋ agɨl nebneb gɨlɨg apɨm agak? Nɨbi apɨm, Mosis takaw sɨkol agak agak tek ma gɨnɨgabal ak, God kɨlop ma dɨnɨgab apɨm agak. Asɨk mosɨk gɨtep gɨnɨgel apɨm anɨb ak, apɨs based sɨkop gɨ mel nɨgɨlak agak. Chɨn abe gɨ mel nopun ak pen, nɨbi tepayaŋ apɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bɨawl Jisas ne chɨnop yɨmug nɨŋɨd gɨtep gak ak nɨm, God ne chɨnop tɨg asɨk dɨl, binɨb Juda mel okok kɨlop abe tɨg asɨk dup agak. ");
INSERT INTO taw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pen binɨb ap yelak okok, takaw olap agɨl mel, kɨmɨgel yelak. Yelaknɨŋ, Banabas ayɨp, Pol ayɨp agɨlek, Chɨl binɨb Juda mel okok kɨlop takaw tep ak agñɨ ajɨlɨg, God tap mageptek okok anɨb anɨb gɨl gak agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pen takaw kɨlimɨŋal ak agjulek, Jemis anɨb agak, Mam sɨkop. Takaw yad agɨnɨgebin awl nɨgɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","God binɨb Juda mel okok kɨlop ogɨnap ned dɨl, gek binɨb ne ke okok yelak takaw ak, Saymon mɨneyɨl nɨbop agup agak. ");
INSERT INTO taw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Binɨb Juda mel okok kɨlop dak anɨb ak, bɨ God gos ñek agñeb okok bɨlel agɨl tɨkɨlak tek nep gak agak. Takaw anɨb ak tɨkɨl agɨlak, ");
INSERT INTO taw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bɨawl ak agup, Depid binɨb ne, kɨli kal tek wakaj sakup agup agɨl tɨkɨlak agak. Kɨdek yad apɨl, jɨtep ak gɨnɨgayn agup agɨl tɨkɨlak agak. Kal anɨb ak tap tɨmel gup okok, dɨtep gɨl, kal jɨtep ak gen yenɨgab agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Anɨgek, kɨdek binɨb man okok mɨdupsek dɨnɨg gɨpin okok, kɨli yɨp pɨyownɨgabal agup agɨl tɨkɨlak agak. Ak binɨb Juda mel, kɨli binɨb yad ke yenɨgabal agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tap tɨtay kɨdek gɨnɨgab ak nepin ak nɨm, bɨlel aglɨnek agup agɨl tɨkɨlak agak. ");
INSERT INTO taw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jemis takaw anɨb ak agɨl agak, Takaw anɨb ak nɨŋɨd, gos yad anɨgɨl mɨdeb agak. Binɨb Juda mel okok, tap tɨmel kelɨgɨl God nop gos lɨnɨgebal ak, kɨlop tap asɨk mosɨk gep okok kuŋay mɨdeb agɨl ma agɨnɨgun agak. ");
INSERT INTO taw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kɨlop yokɨp mɨj kɨl tɨk yokɨl agɨnɨgun, Binɨb kɨli tap yepɨs ogɨnap sɨbogɨnɨg, sab chag tap okok pakenɨgel, ma ñɨŋɨnɨmɨb agɨnɨgun agak. Kuŋam tɨg wukel kumek, nɨkɨm sek yenɨgab tek ma ñɨŋɨnɨmɨb agɨnɨgun agak. Kuŋam tɨkem, nɨkɨm amdek nep ñɨŋɨnɨmɨb agɨnɨgun agak. Sab chag tap okok nɨkɨm ak ma ñɨŋɨnɨmɨb agɨnɨgun agak. Bin si bɨ si ma gɨnɨmɨb agɨnɨgun agak. ");
INSERT INTO taw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Taynen? Takaw Mosis agɨl tɨkak ak, bɨlel agelak binɨb anɨb okok kɨli nepal agak. Mɨñɨl abe man okok mɨdupsek, Juda añɨŋ lep ñɨn awl ak apɨl Juda apnan gɨpal kal ak nan gɨl, takaw Mosis agɨl tɨkak ak agel nepal agak. ");
INSERT INTO taw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jemis anɨb agek, bɨ Jisas takaw nop dad ameb okok dɨl, bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok dɨl, binɨb yokɨp Jisas nop gos lɨnɨgɨlak okok dɨl, mɨdupsek agɨlak, Bɨ chɨn omɨŋal ak, Judas ayɨp Saylas ayɨp aglon, Pol ayɨp, Banabas ayɨp taun Adiyok amnɨlaŋ agɨlak. Bɨ Judas anɨb ak yɨb olap Basabas agelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pen kɨli anɨb agɨl, mɨj kɨl tɨk yokɨl agɨlak, Chɨn nɨmam nɨbi Jisas takaw dad ameb okok sek, bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok sek, nɨbop binɨb Juda mel Jisas nop gos lɨnepɨm okok mɨj kɨl tɨk yokobun agɨlak. Nɨbi ogɨnap taun Adiyok nɨb, ogɨnap Siliya plopens nɨb, ogɨnap Silisiya plopens nɨb, nɨbop mɨj tɨkobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Taynen? Takaw olap owup ak, binɨb okol chɨn ogɨnap, chɨnop agnɨŋɨd mel, gos kɨli anep nɨŋɨd, nɨbop amɨl takaw awl apal agɨlak. Agel, nɨbi judɨl gos pal lɨpɨm agɨlak ");
INSERT INTO taw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nɨŋɨd nɨm, bɨ chɨn sek aglɨl agyokon, Pol ayɨp, Banabas ayɨp kab sek nɨnɨgabal agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pen Pol ayɨp, Banabas ayɨp bɨ tep yɨbɨl omɨŋal ak, chɨlop ñag paklɨnɨgabal agɨl gos ak ma nepil agɨlak. Bɨawl Jisas Klays takaw tep ak, monmon agñɨtep gɨlɨg ajɨpil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bɨ chɨn omɨŋal yɨb kɨli ak, Judas ayɨp, Saylas ayɨp agɨlak. Bɨ omɨŋal agyokɨnɨgabun anɨb ak, mɨj kɨl tɨkɨpun takaw adek anep nɨbop agñɨnɨgayl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","God Kawnan ak chɨnop gos tep ñek, takaw anɨb awl kɨl tɨkobun agɨlak. Chɨn Juda gɨpun gɨpun tek gɨnɨmɨb agonɨgabun, koslam gɨnɨgabɨm ak nɨm, nɨbi takaw wulep won anɨb ak kɨdek gɨnɨmɨb agobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Binɨb ogɨnap, sab chag tap yepɨs ogɨnap sɨbogɨnɨg pakenɨgel, ma ñɨŋɨnɨmɨb agɨlak. Kuŋam tɨg wukel kumek, nɨkɨm sek yenɨgab tek ma ñɨŋɨnɨmɨb agɨlak. Kuŋam tɨkem, nɨkɨm amdek nep ñɨŋɨnɨmɨb agɨlak. Sab chag tap okok nɨkɨm ak ma ñɨŋɨnɨmɨb agɨlak. Bin si bɨ si ma gɨnɨmɨb agɨlak. Tap apun anɨb okok asɨk tep gɨnɨgabɨm ak, tep yɨbɨl agɨlak. Takaw anɨb ak agjupun. Tep agɨl tɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pen kɨli takaw anɨb ak tɨkɨl, Judas ayɨp Saylas ayɨp kɨlop ñel, Banabas ayɨp Pol ayɨp taun Adiyok dad amnɨlak. Dad amjakel, binɨb Jisas nop gos lɨnɨgɨlak okok apnan gɨl, mɨj kɨl tɨk yokɨlak anɨb ak dɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kɨli mɨj pi ak nɨgɨlɨg agñɨl, takaw anɨb ak takaw teplep nɨgel, kɨlop tep yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","34","Judas ayɨp, Saylas ayɨp bɨ God gos ñek agñeb omɨŋal ak nɨm, ñɨn kuŋay yɨbɨl Adiyok mɨdɨl, mɨdtep gɨlaŋ agɨl, takaw tep ogɨnap kuŋay yɨbɨl agñɨlek. Anɨgɨl agñɨjuwɨl amnɨleknɨŋ, mam ay anɨb okok agɨlak, Tep. Adɨkɨd kal ñɨli tep amnil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol ayɨp, Banabas ayɨp Adiyok mɨdɨl, bɨ anɨb okok ogɨnap ayɨp, Bɨawl takaw tep ak agɨl, agñɨtep gɨlɨg yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pen mɨd dad amɨl, Pol ne Banabas nop agak, Chɨl ned ajɨl Bɨawl takaw tep agol amnak man okok, binɨb Jisas nop gos lɨnɨgɨlak ak kɨli mɨdebal akaŋ agɨl, am nɨgɨnɨgul agak. ");
INSERT INTO taw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Agek, Banabas agak, Jon Mak nop poŋɨd amnɨgul agak. ");
INSERT INTO taw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Agek Pol pen agak, Bɨ anɨb ak ned poŋɨd amol, wog gɨjuwɨl ma owak agak. Ne Pampiliya plopens nep amɨl kelɨg owak agak. Anɨb ak mɨñɨl nop poŋɨd ma amnɨgabul agak. ");
INSERT INTO taw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pol anɨb agek, kɨli omɨŋal ke nep penpen agɨl, wog jɨmñɨl ma gɨlek. Banabas ne Jon Mak ayɨp sip dɨl, man Sayplus amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol ne pen, bɨ Saylas nop dak. Binɨb Jisas nop gos nɨgɨlak okok, Pol ayɨp Saylas ayɨp kɨlop agɨlak, God ñɨlop kod mɨdaknɨŋ, ajɨl ownɨmil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Agelak, bɨ omɨŋal am Siliya plopens okok, Silisiya plopens okok ajɨlek. Pol ne binɨb Jisas nop gos lɨnɨgɨlak okok, kɨlop takaw ogɨnap sek agtep gak. ");
INSERT INTO taw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ne am am, taun Debi amɨl, taun Listla amjakak. Man anɨb ak, bɨ Jisas nop gos lɨnɨgak olap yek, yɨb ne Timoti. Bɨ anɨb ak, nonɨm ne Juda nɨb Jisas nop gos lɨnɨgak, nap ne ak Glik nɨb. ");
INSERT INTO taw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Binɨb Jisas nop gos lɨnɨgɨlak taun Listla sek, taun Aykoniyam sek, Timoti ne bɨ tep yɨbɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pen Pol, ne Timoti nop nɨgek tep gak. Nod ayɨp ajol agɨl nɨgak ak pen, nap Glik nɨb ak ñɨne wak ma tɨbɨlɨkak. Ma tɨbɨlɨkak tek, Juda binɨb man anɨb okok takaw nop ma nɨgɨnɨgun agɨnɨgel tek lɨnɨgab agɨl nɨgak. Nɨŋɨd, Timoti nop dad amɨl wak tɨbɨlɨkak. ");
INSERT INTO taw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tɨkɨl, kɨdek kɨli taun okok ajɨlɨg, binɨb Jisas nop gos lɨnɨgɨlak okok kɨlop agɨlak, Bɨ Jisas takaw nop dad ameb okok sek, Jelusalem bɨ Klays binɨb ne okok kɨlop kod mɨdebal okok sek, kɨli apnan gɨl apal, Takaw Mosis ñu kɨl tɨkak ak mɨdupsek mel, kab olap nep dɨnɨmɨb apal agɨlak. Anɨb agɨl kɨlop agtep gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Agtep gelak nɨm, binɨb Jisas yɨl yelak okok, nop gos kɨles lɨnɨŋɨd mɨdtep gɨlak. Anɨgel, mɨnek mɨnek binɨb ogɨnap sek tap tɨmel kelɨgɨl Jisas nop gos lɨnɨŋɨd kɨdek gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol ayɨp bɨne okok ayɨp, God Kawnan ak kɨlop agak, Esiya plopens takaw tep ak kɨlop ma agñɨnɨmɨb agak. Anɨb agek, Piligiya plopens nab okok ajɨl, Galesiya plopens nab okok ajelak. ");
INSERT INTO taw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Apɨl Misiya plopens wulep wulep gɨlɨg, Bitiniya plopens amnun agɨlak. Agelak, Jisas Kawnan ak kɨlop agak, Ma amnɨmɨb agak. ");
INSERT INTO taw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Anɨb agek, Bitiniya plopens ma amnɨlak, Misiya plopens kelɨgɨl, taun Tlowas ayaŋ amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Amɨl, maynab ayaŋ Pol wɨsɨn nɨgak, bɨ Masedoniya plopens nɨb olap tɨkjakɨl, nop suk agɨlɨg agak, Chɨnop chɨb nɨŋɨd, ñɨg solwala tɨkɨl, pɨs awl Masedoniya ownɨmɨn agak. ");
INSERT INTO taw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol anɨgɨl wɨsɨn nɨgek, ak God nokom, Masedoniya binɨb kɨlop takaw teplep ak agñɨnɨmɨb agup agɨl, chɨn kasek sip dɨnɨg amnɨnok. ");
INSERT INTO taw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Chɨn taun Tlowas mɨdɨl, sip dɨl amnɨnok. Am am, man ñɨg tɨb kus gak Samotiles amjakɨnok. Mɨnek pen, taun Neyapolis amjakɨl, ");
INSERT INTO taw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","sip ak kelɨgɨl, Masedoniya binɨb taun kɨli Pilipay amjakɨnok. Taun Pilipay anɨb ak, Lom binɨb kuŋay yɨbɨl ap mɨdɨl kod yelɨgɨpal. Ñɨn kab olap man anɨb okok yolɨgɨpun. ");
INSERT INTO taw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mɨdɨl, Juda añɨŋ lep ñɨn awl ak apek, taun ak ñɨg gol ayɨm, God nop agnɨgep tep olap mɨdeb agɨl, taun anɨb ak kelɨgɨnok. Amɨl nɨgɨnok, bin ogɨnap ap yelak. Nɨŋɨd, anɨb sɨŋak besɨgɨl, kɨlop takaw agɨnok. ");
INSERT INTO taw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Bin yelak anɨb okok, olap yɨb ne Lidiya. Ne chech muk okok gɨlek tawelɨgɨpal. Ne taun Tayatayla nɨb. God nop nokom kɨdek gɨl agnɨgolɨgup. Bin anɨb anop, Bɨawl gos tep ñek, Pol takaw agak ak nɨŋɨd agup agɨl dak. ");
INSERT INTO taw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nop ñɨg pakñɨl, binɨb ne ayɨp kɨnɨlak okok kɨlop ñɨg pakñɨl gɨnok. Ñɨg pakɨl, bin Lidiya agak, Nɨbi yɨp nɨgem, Jisas nop gos lɨnepin tek lup ak, apɨl kal yad awl yenɨmɨb agak. Chɨnop anɨb agek, nɨŋɨd agup agɨl, am kal nop ak kɨnɨnok. ");
INSERT INTO taw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pen chɨn mɨnek olap, God nop agnɨgep tep ak amɨl, pay wog gɨñeb olap nop nebeŋ pakɨnok. Pay anɨb anop kɨcheki abaŋ lek nɨm, tap tɨtay kɨdek gɨnɨgab ak, binɨb okok kɨlop agñek nop mani tawelɨgɨpal. Anɨgek, bɨ nop taw dad apel, wog kɨlop gɨñolɨgup okok, mani awl delɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chɨn amnɨnoknɨŋ, pay anɨb ak chɨnop kɨdek gɨlɨg agak, Bɨ okol, God Bɨawl yɨbɨl adek alaŋ mɨdeb ak, wog nop gɨñelɨgɨpal agak. Nɨbi tay gem God nɨbop dɨnɨgab takaw ak agñebal agak. ");
INSERT INTO taw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pen takaw anɨb ak tek, mɨnek mɨnek agek, mɨnek olap Pol nop yɨlɨk gek, adɨkɨl pay anɨb ak kɨcheki abaŋ lak anop agak, Jisas Klays yɨp gɨnɨmɨn agup tek, nep agebin, pay anop kelɨgɨl amnoŋ agak. Anɨb agaknɨŋ, kɨcheki nop abaŋ lak ak kelɨgɨl amnak. ");
INSERT INTO taw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pen pay anɨb anop kod yelɨgɨpal bɨ okok, Pol kɨcheki agyokak takaw ak nɨgɨlak. Nɨŋɨd, mani awl dɨpun ak, kɨdek ma dɨnɨgabun agɨl, Pol ayɨp Saylas ayɨp kɨlop lɨpɨg dad amɨl, bɨawl apnan gɨ yelak ak amnɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Amɨl, bɨawl kɨlop agɨlak, Juda nɨb bɨ omɨŋal awl, apɨl man chɨnop awl monmon gebil ak, yepɨs agebil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Chɨn Lom binɨb, takaw nedil adek ak ke mɨdeb ak pen, kɨli tay gɨnɨg, takaw kɨdeyɨl ak nɨgɨlaŋ agɨl aglebil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Binɨb kuŋay yelak okok abe, takaw adek anɨb anep agelak, bɨawl okok tɨkjakɨl, Pol ayɨp Saylas ayɨp chech kɨlop okok kasek tɨg asɨkɨl agɨlak, Kul dɨl pakɨm agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Agelak, kul dɨl pak adɨk madɨk gɨl, dam kalabus mɨgan ak yokɨl, bɨ kalabus kod yek anop agɨlak, Kɨlop omɨŋal nɨg yenɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Agelak, bɨ kalabus kod yek ak, kɨlopmɨŋal poŋɨd dam kal mɨgan yɨbɨl ayaŋ lɨl, tob kɨd kɨlop omɨŋal ak dɨl mab awl mɨgan ak agek lɨgel amnak. ");
INSERT INTO taw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pen maynab awl ayaŋ, Pol ayɨp Saylas ayɨp God nop agɨlɨg kɨmep ogɨnap agɨleknɨŋ, bɨ ned nag lɨlak okok nɨg yelak. ");
INSERT INTO taw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Anɨgɨl nɨg yelaknɨŋ, day monmon awl dɨl, kalabus kal ak dad awl adaŋ gɨl, kanɨb okok mɨdupsek yɨkɨlɨg, kalabus kay kɨlop tun gɨlak nag kɨles tɨmel okok mɨdupsek asɨkak. ");
INSERT INTO taw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Anɨgek, bɨ kalabus kod yek ak tɨkjakɨl nɨgak, kanɨb okok mɨdupsek yɨkɨl yek. Ne nɨŋɨd, kalabus kay kanɨb yɨkɨl pɨlɨk amdɨpal agɨl gos nɨŋɨd, baynat ak lɨpɨg dɨl, ne ke puŋɨl lɨnɨg gak. ");
INSERT INTO taw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol pen suk awl agak, Nak ke ma tɨbɨnɨmɨn agak. Chɨn ma pɨlɨk abun. Mɨdupsek mɨdobun agak. ");
INSERT INTO taw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Agek, bɨ kalabus kod yek ak suk agak, Sup ak kasek dowɨm agak. Agek, sup dad apelak, kasek dad kal mɨgan amɨl, jel gek jepjep dɨlɨg am Pol ayɨp Saylas ayɨp yelek tob agen sɨŋak kɨgom yɨmak. ");
INSERT INTO taw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pen anɨgɨl kɨgom yɨmɨl tɨkjakɨl, kɨlop omɨŋal poŋɨd seŋayaŋ amɨl agak, Bɨawl omɨŋal. Yad tay gen, God yɨp tɨg asɨk dɨnɨgab agak? ");
INSERT INTO taw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Agek nop agɨlek, Bɨawl Jisas nop gos lɨnɨge, God nep tɨg asɨk dɨl, binɨb nad ayɨp kɨnɨban okok abe agɨlek. ");
INSERT INTO taw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Anɨb agɨl, bɨ anɨb ak sek, binɨb ne ayɨp kɨnɨlak okok sek, kɨlop Bɨawl takaw ak agñɨlek. ");
INSERT INTO taw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kɨlopmɨŋal maynab ayaŋ nep dad amɨl, pakɨlak okok ñɨg lɨ yokak. Anɨgek, ne ayɨp binɨb ne ayɨp kɨlop mɨdupsek ñɨg pakñɨlek. ");
INSERT INTO taw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ñɨg pakñelek, bɨ kalabus kod yek anɨb ak, bɨ omɨŋal poŋɨd kal ne amɨl, tap mɨdup ñek ñɨŋɨlek. Bɨ anɨb ayɨp, binɨb ne okok ayɨp, mɨñɨl God nop gos lɨnopun agɨl, mɨñmɨñ awl yɨbɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mɨnek pen bɨawl okok, bɨ polis okok kɨlop agyokel, bɨ kalabus kod yek ak nop agɨlak, Bɨ kalabus mɨdebil omɨŋal ak kɨlop wɨsɨb yoke amnɨmil agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Agelak, bɨ kalabus kod yek ak, takaw anɨb ak dad amɨl, Pol nop agak, Bɨawl okok kɨli apal, Bɨ omɨŋal kɨlop wɨsɨb yoke amnɨmil apal agak. Anɨb ak gos sek mɨdɨl mɨdtep gɨl amnɨmil agak. ");
INSERT INTO taw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Agek Pol agak, Chɨl abe bɨ Lom nɨb, anɨb ak tek taynen kot gɨpal won ak, takaw chɨlop tɨk asɨkɨl nɨgtep ma gɨpal agak? Binɨb nab ak mɨdol kɨli chɨlop kul dɨl pakɨl, dam nag lɨpal ak, tep ma gup agak. Anɨb ak chɨlop kɨmɨgel we gɨl agyokun agɨl agebal akaŋ agak? Mel yɨbɨl. Kɨli ke apɨl, chɨlop wɨsɨb yokɨnɨgabal agak. ");
INSERT INTO taw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pol anɨgɨl agek, polis okok takaw anɨb ak nɨŋɨd, adɨkɨd am bɨawl okok kɨlop takaw anɨb ak agñɨlak. Agel, kɨli omɨŋal abe Lom nɨb agɨl, pɨlɨkɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Amɨl, Pol ayɨp Saylas ayɨp kɨlop takaw saynsayn agɨl agɨlak, Chɨn ñɨlop taynen gɨ tɨmel gɨpun agɨlak. Agɨl, kɨlop dad seŋayaŋ amɨl agɨlak, Ñɨli man awl anɨb ak kelɨg amnɨmil agɨl gos nopun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Agelak, Pol ayɨp Saylas ayɨp kalabus kal ak kelɨgɨl, bin Lidiya kal ak am mɨdɨl, binɨb Jisas nop gos lɨnɨgɨlak okok kɨlop takaw agtep gɨl, amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bɨ omɨŋal taun Pilipay kelɨgɨl, am am taun Abipolis amjakɨlek. Abipolis nɨb am am, taun Apoloniya amjakɨlek. Pen Apoloniya nɨb am am taun Tesalonayka amjakɨl nɨgɨlek, Juda apnan gɨpal kal olap yek. ");
INSERT INTO taw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nɨŋɨd, Pol pel golɨgup ak, binɨb okok ayɨp apnan gɨpal kal mɨgan ak amnak. Kal anɨb ak, Juda añɨŋ lep ñɨn awl omɨŋal nokom amɨl, God takaw ned agɨl tɨkɨlak ak gos nɨŋɨd, ag amɨl apɨl gɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Anɨgɨl ag amɨl apɨl gɨlɨg, kɨlop God takaw tep ak agñɨtep gɨlɨg agak, Bɨ God nop aglup ak ne apɨl, chɨnop nen agɨl yul dak agak. God takaw ned agɨl tɨkɨlak ak, nop agɨl tɨkɨlak tek, kumɨl tepayaŋ tɨkjakak agak. Bɨ God nop aglup ak, binɨb okok kɨlop dɨl kod yenɨgab ak nɨm, bɨ Jisas nɨbop kesɨm debin ak nep agak. ");
INSERT INTO taw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Anɨb agek, kɨli ogɨnap nɨŋɨd agup agɨl, Pol ayɨp Saylas ayɨp kɨd bak okok amnɨlak. Glik binɨb God nop agnɨgelɨgɨpal ogɨnap, bin yɨb sek ogɨnap abe, kɨli kuŋay Pol ayɨp Saylas ayɨp agɨlek takaw ak dɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Delak, Juda bɨ okok nɨgel mɨlɨk yowak. Kɨli bɨ tɨmel yokɨp yelak ogɨnap del, kɨli pen am binɨb kuŋay yɨbɨl dad apel, takaw pug awl agɨlak. Pen Pol ayɨp Saylas ayɨp kɨlop pɨyow nɨŋɨd, binɨb okol kɨlop ñon paklɨlaŋ agɨl, amɨl Jeson kal ak puŋɨl kuskus gɨl, pɨyow mel nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pɨyow mel nɨŋɨd, Jeson nop dɨl, binɨb Jisas nop gos nɨgɨlak ogɨnap sek dɨl, dad gapman bɨawl yelak ak amɨl agɨlak, Bɨ man okok mɨdupsek ajɨl takaw agñɨlaknɨŋ, takaw pug awl apal okok, mɨñɨl ap mɨdebal man chɨn awl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kɨli Lom gapman bɨnonɨm chɨnop takaw nop kelɨgɨl, bɨnonɨm kɨli Jisas nop nokom dɨpal agɨlak. Pen bɨ Jeson nɨm awl, bɨ anɨb okok kɨlop dam kal ne ak lup ak nɨm, nop dad apobun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Anɨb agelak, binɨb kuŋay ap yelak okok sek, gapman bɨawl okok sek nɨŋɨd, gos kuŋay nɨŋɨd suk awl agɨl agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Gos kuŋay nɨŋɨd, bɨawl okok kɨli Jeson nop mani ogɨnap dɨl, binɨb ne dad owlak okok mani ogɨnap dɨl agɨlak, Kɨdek takaw anɨb ak tepayaŋ agñenɨgabɨm, mani nɨbop anɨb awl pɨsnep dɨnɨgabun agɨlak. Anɨb agɨl, kɨlop ag seŋ yokɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Man sɨbgup ak, binɨb Jisas nop gos nɨgɨlak Tesalonayka nɨb okok, kɨli Pol ayɨp Saylas ayɨp kɨlop agyokel, taun Beliya amnɨlek. Amɨl, Juda apnan gɨpal kal mɨgan ak amnɨlek. ");
INSERT INTO taw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Juda binɨb anɨb okok, Juda binɨb Tesalonayka yelak okok tek mel, kɨli mɨdtep gɨlak. Ak nɨm, Pol takaw nop ak nɨgel tep gaknɨŋ, nɨŋɨd agup akaŋ agɨl, buk Baybol ak mɨnek mɨnek pɨyowɨl nɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kɨli kuŋay yɨbɨl Jisas nop gos lɨnɨgɨlak. Glik bin yɨb yek okok, Glik bɨ ogɨnap abe, kuŋay yɨbɨl Jisas nop gos lɨnɨgɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pen Juda binɨb Tesalonayka yelak okok, kɨli Pol amɨl taun Beliya binɨb kɨlop God takaw ak agñub ak nɨgelak, mɨlɨk yowak. Mɨlɨk yapek, kɨli apɨl Beliya binɨb kɨlop nebneb gel, kabɨyam junɨg gelak. ");
INSERT INTO taw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Anɨb ak nɨŋɨd, binɨb Jisas nop gos lɨnɨgɨlak okok, kɨli ogɨnap Pol nop kasek dam man ñɨg solwala gol okok agyokɨlak. Pen Saylas ayɨp Timoti ayɨp, taun Beliya anɨb ak yɨlek. ");
INSERT INTO taw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pen bɨ ogɨnap Pol nop dam taun Atens amjakɨlak. Adɨkɨd amnɨlaknɨŋ, Pol kɨlop agak, Saylas ayɨp Timoti ayɨp, kɨlop agyokem, kasek ownɨmil agak. ");
INSERT INTO taw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol anɨb agɨl, Saylas ayɨp Timoti ayɨp kɨlop kod yek, taun Atens anɨb ak. Mɨdɨlɨg nɨgak, binɨb anɨb okok, tap yepɨs kɨli agnɨgelɨgɨpal okok, kuŋay yɨbɨl yek. Nɨgek, gos nop ak tɨmel yɨbɨl gak. ");
INSERT INTO taw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Anɨb ak tek Juda apnan gɨpal kal ak amɨl, bɨ Juda nɨb ogɨnap ayɨp, bɨ Juda mel pen God nop kɨdek gɨl agnɨgɨlak ogɨnap ayɨp, takaw ag amɨl apɨl gelɨgɨpal. Pen ñɨn kuŋay abe, binɨb apnan gelɨgɨpal tep ak apnan gɨl, kɨli ayɨp takaw ag amɨl apɨl gɨ yelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ñɨn anɨb ak, Epikuliyan bɨ gos nɨgep ogɨnap, Stowik bɨ gos nɨgep ogɨnap, kɨli Pol ayɨp takaw ag amɨl apɨl gɨlak. Anɨgel, Pol ne Jisas kumɨl tɨkjakak takaw teplep ak agek, kɨli nɨŋɨd ogɨnap agɨlak, Bɨ takaw monmon agup awl, takaw anɨb ak tay agup agɨlak? Pen ogɨnap agɨlak, Binɨb pal okok kɨli tap anɨb okok agnɨgelɨgɨpal takaw ak agup agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pen Pol nop dad kaunsol kay Aleyopagus yelak ak amɨl agɨlak, Nad takaw kɨdeyɨl binɨb okok kɨlop apan ak, mɨñɨl chɨnop agñɨnɨmɨn agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Takaw nad ak chɨn nopun, takaw anɨb ak ke tek lup agɨlak. Takaw jɨj anɨb ak nɨgtep gɨnɨgun agɨlak. ");
INSERT INTO taw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Binɨb man Atens nɨb okok sek, binɨb okok nɨb apɨl Atens yelak okok sek, kɨli takaw kɨdeyɨl ogɨnap nɨŋɨd, ag yonɨgun agɨl gos anep nɨgelɨgɨpal. ");
INSERT INTO taw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pen Pol kaunsol kay Aleyopagus yelak nab ak tɨkjakɨl agak, Nɨbi Atens bɨ okok agak. Yad nepin, nɨbi kɨles yɨbɨl gɨl, tap ogɨnap agnɨgun agɨl gos ak nepɨm agak. ");
INSERT INTO taw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Yad man anɨb ak ajɨlɨg, nɨbi kab keke gɨl tap keke agnepɨm tek, yɨb ak adek anɨb ak kɨl tɨkɨpek ak nepin agak. Pen kab olap gɨlɨpek ak, yɨb ak tɨkɨl apɨm, Tap olap chɨni ma nopun ak, kab nop nɨm awl apɨm agak. Tap ma nɨŋɨd yokɨp agnepɨm anɨb ak, jɨj ak nɨbop mɨñɨl agɨnɨgebin agak. ");
INSERT INTO taw_vpl