﻿USE sofia;
DROP TABLE IF EXISTS sofia.tav_vpl;
CREATE TABLE tav_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tav_vpl WRITE;
INSERT INTO tav_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ocõo bairo Jesucristo cʉ ñicʉa wame ã. Ʉpaʉ David ãnacʉ pãramina cãñupʉ Jesucristo. Abraham pãramipʉna cãñupʉ David. ");
INSERT INTO tav_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham macʉ cãñupʉ Isaá. Isaá macʉ Jacobo cãñupʉ. Jacobo punaa cãñuparã Judá cʉ yarã mena. ");
INSERT INTO tav_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá maca Tamá cawamecʉcore nʉmocʉtiri Fares, Sara capunaa cʉjupʉ. Fares macʉ Esrom cãñupʉ. Esrom macʉ Aram cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram macʉ Aminadá cãñupʉ. Aminadá macʉ Naasón cãñupʉ. Naasón macʉ Salmón cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón canʉmo cʉjupʉ Rahabo cawamecʉcore. Na macʉ Booz cãñupʉ. Booz canʉmo cʉjupʉ Rut. Na macʉ Obé cãñupʉ. Obé macʉ Isaí cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí macʉ David cãñupʉ. Uría nʉmo cãnibatacore canʉmo cʉjupʉ David. Na macʉ Salomón cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón macʉ Roboam cãñupʉ. Roboam macʉ Abías cãñupʉ. Abías macʉ Asa cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa macʉ Josafá cãñupʉ. Josafá macʉ Joram cãñupʉ. Joram macʉ Usías cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usías macʉ Jotam cãñupʉ. Jotam macʉ Acás cãñupʉ. Acás macʉ Esequías cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esequías macʉ Manasé cãñupʉ. Manasé macʉ Amón cãñupʉ. Amón macʉ Josía cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josía punaa Jeconía cʉ bairã mena cãñuparã Babilonia maja Israel majare na ya macapʉre na cajee aáti yʉteapʉre. ");
INSERT INTO tav_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","To bairi Jeconía Babiloniapʉre Israel maja menare cʉ na cane aátacʉ Saratié pacʉ cãñupʉ. Cabero Saratié Sorobabére camacʉ cʉjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabé macʉ Abiú cãñupʉ. Abiú macʉ Eliaquim cãñupʉ. Eliaquim macʉ Asor cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor macʉ Sadó cãñupʉ. Sadó macʉ Aquim cãñupʉ. Aquim macʉ Eliú cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliú macʉ Eleasar cãñupʉ. Eleasar macʉ Matán cãñupʉ. Matán macʉ Jacobo cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobo macʉ José cãñupʉ. José maca María manapʉ cãñupʉ. María Jesu paco cãñupo. Dio cʉ cajooricʉ, Cristo paco cãñupo yua. ");
INSERT INTO tav_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","To bairi Abraham berore catorce poari bero macacʉ cãñupʉ David. David bero aperã catorce poari bero cãñuparã tunu Babiloniapʉre Israel majare na na cajee aáti paʉre. Ti paʉ macacʉ berore aperã catorce poari bero cãñupʉ Cristo yua. ");
INSERT INTO tav_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ocõo bairo cãñupe Jesucristo cʉ cabuiarique. Cʉ paco María José nʉmo cãnipao cãñupo cõa. José mena co cãniparo jʉgoyepʉna mere ʉta cãñupo Dio Espíritu Santo cʉ carotiro menare. ");
INSERT INTO tav_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Co manapʉ cãnipaʉ José cañuʉ cãñupʉ. To bairi ʉta co cãniere majiri José co canegaquetibajupʉ. To bairi, “Mʉ yʉ nequetigʉ yua,” co caĩgabajupʉ. Aperã bobooro co tʉgooñari, caroo majuu ãmo ĩrema ĩi yajioropʉ co caĩgabajupʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","To bairo cʉ caĩ tʉgooñari paʉna cʉ caquẽguerijepʉre Dio tʉ macacʉ jĩcaʉ ángel cʉ tʉpʉ buia ejari ocõo bairo cʉ caĩñupʉ Josére David tirʉmʉpʉ macacʉ pãramire: —José, cʉ caĩñupʉ. —Maríare mʉ nʉmo cãnipaore co tee tʉgooñaquẽja ʉta co cãnibato quenare. Dio cʉ Espíritu Santo cʉ carotiro mena ʉta ãmo. ");
INSERT INTO tav_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Caʉmʉ Macʉ cʉtigomo. Cʉ yarã caroorije na cátiere na camajiriobojapaʉ anigʉmi cʉ̃a. To bairi JESU cʉ mʉ wameyegʉ. ");
INSERT INTO tav_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","To bairona Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ cʉ caĩ ucaricarore bairona cabaiyupe. Ocõo bairo caucayupi buio jʉgoyeyei: ");
INSERT INTO tav_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jĩcao cãromio caʉmʉ mena cãniquẽco anibaco quena ʉta anigomo. To bairi caʉmʉ Macʉ cʉtigomo. EMANUEL cʉ wameyegarãma, caĩ ucayupi Dio ye quetire buiori majocʉ cãniñaricʉ. Ti wame EMANUEL ĩgaro ĩ, “Dio mani mena ãmi,” ĩgaro ĩ. ");
INSERT INTO tav_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","To bairi José yopi, Dio tʉ macacʉ cʉ carotirore bairona cájupʉ. Cʉ tʉpʉ co caneajupʉ cʉ nʉmore yua. ");
INSERT INTO tav_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","To bairo átibacʉ quena co mena cãniquẽjupʉ co Macʉ cʉ cabuiaparo jʉgoye. Co Macʉ cʉ cabuiaro JESU cʉ cawameyeyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu cabuiayupʉ Belén na caĩri macapʉre, Judea yepapʉ, ti yepa Herode ʉpaʉ cʉ cãni yʉtea cãnopʉ. Cʉ cabuiaro bero muipu cʉ capiya atí nʉgoa cãnopʉ macá yepa macana Jerusalẽpʉre caejayuparã. Ñocoa tʉjʉri catʉgooña maji weorã cãñuparã. ");
INSERT INTO tav_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalẽpʉre eja: —¿Noopʉ cʉ ãti mere cabuiaricʉ judío maja ʉpaʉ cãnipaʉ? to macanare na caĩ jeniñañuparã. —Muipu cʉ capiya atí nʉgoa macá mácapʉ jã catʉjʉwʉ ñocore. Cʉ̃ ñocore tʉjʉrã, “Mere buiaricʉmi,” jã caĩ tʉjʉ majiwʉ. To bairi cʉ̃re áti nʉcʉbʉgorã anaa jã baiwʉ, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ʉpaʉ Herode to bairo na caĩ jeniñaro apii seeto catʉgooñañupʉ. Jerusalén macana quena to bairona seeto catʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","To bairo tʉgooñari Herode capi neoñupʉ sacerdote maja ʉparãre, judío majare cabuerã menare. Na pi neo, na cajeniñañupʉ: —¿Noopʉ majuu Cristo mʉja caĩi Dio cʉ cajoopaʉ cʉ buiacʉti? na caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","To bairo na cʉ caĩ jeniñaro: —Belén na caĩri macapʉ, Judea yepapʉ. To bairona caĩ ucayupi Dio ye quetire buiori majocʉ cãniñaricʉ atiere ucaʉ: ");
INSERT INTO tav_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea yepapʉ ã Belén na caĩri maca. Cãni majuuri maca ã. Ti macapʉ buiagʉmi jĩcaʉ Ʉpaʉ, Israel majare carotipaʉ. Caroaro na cajʉgo ãcʉ anigʉmi Dio yarãre, caĩ ucayupi Dio ye quetire cabuioricʉ tirʉmʉpʉ macacʉ, cʉ caĩñuparã Herodere. ");
INSERT INTO tav_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","To bairo cʉ na caĩro bero aperã na catʉjʉquẽtopʉ ti macapʉ caejaricarãre yajioro na pijori: —¿Diwatipʉ cʉ cabuia jʉgóri cʉ̃ ñoco? na caĩ jeniñañupʉ Herode. To bairo na cʉ caĩ jeniñaro: —To cõopʉ cabuia jʉgówĩ, cʉ caĩ buioyuparã Herodere. ");
INSERT INTO tav_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","To bairo cʉ na caĩ buioro: —Belẽpʉ aánaja. “¿Noopʉ cʉ ãti caʉpaʉ cãnipaʉ mere cabuiaricʉ?” caroaro jeniña macaña to macanare. To bairi jeniña bʉga, cʉ cabairije nipetiro maji peti, yʉ mʉja buiora apá tunu. Yʉ quena cʉ yʉ áti nʉcʉbʉgoʉ aágʉ cʉ̃acãre, ñocore catʉjʉricarãre na caĩtoyupʉ Herode. ");
INSERT INTO tav_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","To bairo na cʉ caĩro apirã, cáaácoajuparã. Nemoopʉre ñoco muipu cʉ capiya atí nʉgoa macá yepapʉ na catʉjʉricʉ na cajʉgo aájupʉ. Na jʉgo aá, cadaquei cʉ cãni paʉ bui majuu caejayupʉ. ");
INSERT INTO tav_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","To bairo ñoco jõpʉ na catʉjʉricʉ na cʉ cajʉgo aáto tʉjʉrã seeto cawariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","To bairi cadaquei cʉ cãni wiipʉ caejayuparã. Eja, jãa, cadaqueire cʉ catʉjʉyuparã cʉ paco mena. Cʉ tʉjʉ, rʉpopatua tuatu ejacumuri cʉ cáti nʉcʉbʉgoyuparã. Cʉ áti nʉcʉbʉgorã na apeye patarire pã, na cacʉgorijere cʉ cajooyuparã. Caajiyarijere, caroa cajʉti ñuurijere, ape wame caroa cajʉti ñuurije cawapa pacarije quenare cʉ cajooyuparã. ");
INSERT INTO tav_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cabero Dio na caquẽguerijepʉre ocõo bairo na caĩ jooyupʉ: —Herode tʉ tunu aáqueticõaña, cadaqueire cʉ majiri cʉ jĩaremi ĩrã, na caĩñupʉ ñocore catʉjʉricarãre. To bairo na cʉ caĩro na ya yepapʉre tunu aána ape wãpʉ catunucoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na catunu aáto bero Dio tʉ macacʉ Josére cabuia ejayupʉ cʉ caquẽguerijepʉre. Buia ejari cʉ caĩñupʉ Josére yua: —¡Yopiya! cʉ caĩñupʉ. —Cadaqueire cʉ paco menare na jʉgo ruti aácʉja Ejiptopʉre. Herode cʉ macari cʉ jĩaremi. Topʉ anicõaña. Mʉ yʉ cabuioropʉ to cõo mʉ tunu atígʉ, cʉ caĩñupʉ Dio tʉ macacʉ Josére. ");
INSERT INTO tav_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","To bairo cʉ̃re cʉ caĩro api, cayopiyupʉ José. Yopi, cadaqueire, cʉ pacore na cajʉgo aácoajupʉ ñamina, Ejiptopʉre na jʉgo ruti aácʉ. ");
INSERT INTO tav_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Topʉ eja, cãñupʉ Herode ʉpaʉ cʉ cacatiri yʉtea cõo. To bairi tirʉmʉpʉ Dio ye quetire buiori majocʉ cʉ caĩ ucaricarore bairona cabaiyupe ati wame cabairique: “ ‘Ejiptopʉ cãcʉre yʉ Macʉre cʉ yʉ pijogʉ,’ ĩmi Dio,” caĩ ucayupi Dio ye quetire buiori majocʉ cãniñaricʉ. ");
INSERT INTO tav_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","To bairi Herode ñocoare tʉjʉri tʉgooña maji jʉgoyeyeri maja ape wãpʉ cʉ na caneto tunu aátiere majiri seeto capunijiniñupʉ. Punijini, cʉ yarã polisía majare caʉmʉa cawimarãacãre na cajĩa rotiyupʉ Belén cãnare, Belén tʉacã cãna quenare. “Judío maja ʉpaʉ anigʉmi cadaquei,” na caĩro na cajĩa rotiyupʉ. Pʉga cʉma cacʉgorã, caẽorobʉjana cãna quenare cajĩa re rotiyupʉ, ñocoa tʉjʉri maja, “Mere pʉga cʉma netocoapa cʉ̃ ñoco cʉ cabuiaricaro bero,” cʉ na caĩ buioricaro tʉgooñari. ");
INSERT INTO tav_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cajʉgoyepʉna to bairo Herode cʉ cátipere caĩ ucayupi Dio ye quetire buiori majocʉ cãniñaricʉ Jeremía cawamecʉcʉ. Ocõo bairo caucayupi: ");
INSERT INTO tav_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá na caĩri macapʉ seeto tʉgooñarique paibana, seeto otigarãma. Raquel co pãramerãpʉ seeto tʉgooñarique paigarãma. Aperã dope bairo na tʉgooña tutuarique joo majiquetigarãma, na punaare aperã nare na cajĩa rebojaro, caĩ ucayupi Jeremía tirʉmʉpʉ macacʉ Herode cʉ cajĩa rotipere. ");
INSERT INTO tav_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","José, María, Jesuacã Ejiptopʉ na cãno Herode cabai yajiyupʉ yua. Herode cʉ cabai yajiro bero Ejiptopʉre Josére cʉ caquẽguerijepʉ Dio tʉ macacʉ cʉ tʉpʉ cabuia ejayupʉ tunu. Cʉ buia ejari, Josére cʉ caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—¡Yopiya! Cawimaʉre cʉ paco menare Israel yepapʉ cʉ jʉ́go tunu aácʉja. Mere cʉ̃re cajĩagabatana cabai yaji peticoama, cʉ caĩñupʉ Dio tʉ macacʉ ángel. ");
INSERT INTO tav_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","To bairo cʉ caĩro api, nemoo cawimaʉre cʉ paco menare na cajʉgo tunu aájupʉ José Israel yepapʉre yua. ");
INSERT INTO tav_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aá, Arquelau cawamecʉcʉ cʉ pacʉ Herode bero Judeapʉre ʉpaʉ cʉ cãniere caqueti apiyupʉ. To bairi topʉ cáaá uwiyupʉ José. Cabero, “Judeapʉre aáquẽja,” cʉ caquẽguerijepʉre Dio tʉ macacʉ cʉ̃re cʉ caĩro, Galilea na caĩri yepapʉ cáaájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Topʉ aá, Nasaré na caĩri macapʉ cãñupʉ yua. To bairona cʉ cabaipere cajʉgoyepʉna caĩ ucayupa Dio ye quetire buiori maja ãnana: “ ‘Nasaré macacʉ ãmi,’ cʉ ĩgarãma,” caĩ ucayupa Jesu cʉ cabaipere. ");
INSERT INTO tav_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti rʉmʉrina Jesu Nasarépʉ cʉ cãnitoye Juan bautisari majocʉ Judea yepapʉ camaja mani paʉpʉ Dio ye quetire cabuionucuñupʉ cʉ tʉpʉ caejarãre. ");
INSERT INTO tav_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Topʉ ãcʉ ocõo bairo Dio ye quetire cabuionucuñupʉ Juan: —Mʉjaa caroorije mʉja cátiere seeto tʉgooñarique pairi, Dio yucʉacãna ati yepapʉ carotipaʉ majuure joogʉmi ĩrã mʉja yeri wajoaya. ");
INSERT INTO tav_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan cãñupʉ, “Apeĩ anigʉmi,” Isaía ãnacʉ Dio ye quetire buiori majocʉ cʉ caĩricʉ. Ocõo bairo caĩ ucayupi Isaía ãnacʉ Juan cʉ cabaipere: Jĩcaʉ camaja na camanopʉ awajari ocõo bairo ĩ buiogʉmi cʉ tʉpʉ caejarãre: “Caroaro quenoo yuuya mʉja yerire, cariape tʉgooñari mani Ʉpaʉ cʉ cáatíparo jʉgoye. Caroa macare ája,” ĩ buiogʉmi, caĩ ucayupi Isaía tirʉmʉpʉ macacʉ. ");
INSERT INTO tav_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jutii cajañanucuñupʉ Juan cameyo na caĩrã caballore bairã na poa mena juarica wʉre. Waibʉcʉ ajerona cawẽanucuñupʉ. To bairi ñimiare caʉgaricarã cʉtinucuñupʉ. Nare ʉga, beroa oco quenare caetinucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dio Wadarique cʉ cabuiori paʉpʉ cʉ tʉpʉ caejayuparã Jerusalén maca macana, Judea yepa macana, Jordán na caĩri ya tʉ macana quena. ");
INSERT INTO tav_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cʉ tʉpʉ eja, “Caroorije cácʉ yʉ ã,” Diore ĩri Juãre, “Jã bautisaya,” cʉ caĩñuparã, Jordán na caĩri yapʉ. ");
INSERT INTO tav_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseo maja, saduceo maja mena cʉ na cabautisa rotirã ejaro tʉjʉʉ ocõo bairo na caĩñupʉ Juan: —Caroorije pairã mʉja ã. Yʉre mʉja bautisa rotirã ejabapa. Mʉja popiyeyegʉmi Dio mʉja cayeri wajoaquẽpata. ");
INSERT INTO tav_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","To bairi mʉjaare Dio cʉ capopiyeyepere Diore netoo rotiri caroa macare ája mʉjaa. Caroare mʉja cáto tʉjʉʉ, “Na yeri wajoama,” mʉja ĩ tʉjʉ majigʉmi Dio yua, na caĩñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","—“Abraham pãramerãpʉ cãna mani ã. To bairi Dio yarã mani ã,” ĩ tʉgooñaqueticõaña. Dio atie ʉ̃ta rupaarena áti jeñoo majimi aperã Abraham pãramerãre nare cʉ caboonemoata. Mʉja yeri cawajoape macare boomi Dio cʉ yarã cãninemoparãre. ");
INSERT INTO tav_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Caroa macare mʉja cátiquẽpata yucʉacã mʉja regʉmi Dio. Yucʉ carica maniire quetí joe rocaricarore bairona mʉja átigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mʉjaare yʉ bautisa oco mena, “Caroorije jã cátie jʉtiritiri jã yeri wajoagarã,” mʉja caĩro. Yʉ bero anigʉmi yʉ netoro cãcʉ. Cʉ mena cawatoa cãcʉ majuu yʉ ã yʉa. Cʉ maca Dio Espíritu Santore mʉja joogʉmi mʉja yeripʉ caroorije mʉja cátiere majiriori. ");
INSERT INTO tav_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Caroorãre na beje regʉmi, cʉ yarã jetore na jeegʉ. Arusu caroorije caajeri beje papu joe rericarore bairona caroorãre na regʉmi. Caroare cũrica paʉpʉ cũricarore bairona na átigʉmi cʉ yarã jetore. Aperã macare pero capetiqueti peropʉ na regʉmi, na caĩ buioyupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","To bairi Jesu Galilea na caĩri yepa cãnacʉ caejayupʉ Jordán na caĩri yapʉre. Caejayupʉ Juan tʉpʉre, cʉ bautisa rotii ejaʉ. ");
INSERT INTO tav_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nemoopʉre Juan cʉ cabautisagaquetibajupʉ Jesure. —¿Nope ĩi yʉ macare yʉ mʉ bautisa rotiti? Mʉ maca yʉre cabautisapaʉ mʉ anibapa, Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","To bairo cʉ caĩro: —To bairona Dio cʉ caboori wame nipetiro mani cátipe ã. To bairi yʉ bautisaya, Juãre cʉ caĩñupʉ Jesu. To bairo Jesu cʉ caĩro Juan cabautisayupʉ Jesure yua. ");
INSERT INTO tav_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cʉ̃re cʉ cabautisa yaparoro Jesu riapʉ cañujãricʉ camaa nʉcañupʉ. Cʉ camaa nʉcari paʉna ʉmʉrecoo capãñupe. Capãro Dio Espíritu Santo buare baii cʉ bui cʉ carui ejaro catʉjʉyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","To bairo cabairi paʉna Dio ʉmʉrecoopʉ ocõo bairo caĩ wadayupʉ: —Ani yʉ Macʉ, yʉ camaii ãmi. Cʉ mena yʉ wariñuu, caĩ wadayupʉ Dio. ");
INSERT INTO tav_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Atie bero Dio Espíritu Santo camaja na camanopʉ, cayucʉ manopʉ Jesure cʉ cajʉgo aájupʉ. Topʉ Jesu cʉ caejaro Sataná, ¿Diore cʉ bai netoobocʉti? ĩi caroorijere cʉ cáti rotibajupʉ. ");
INSERT INTO tav_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Topʉ ãcʉ cuarenta rʉmʉri majuu caʉgaquẽjupʉ Jesu. To bairi seeto cañigo riabʉjayupʉ. ");
INSERT INTO tav_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","To bairo cʉ cabairo Sataná, “Caroorije ája,” cʉ ĩ wadajãgʉ cʉ tʉpʉ caejayupʉ. Cʉ tʉpʉ eja, ocõo bairo cʉ caĩñupʉ yua Jesure: —Dio Macʉ mʉ cãmata mʉ camajirije mena atie ʉ̃ta rupaare ʉgarique jeñooña, cʉ caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","To bairo cʉ caĩro: —Dio Wadarique ocõo bairo ĩ, cʉ caĩñupʉ Jesu. —“Camaja ʉgarique ʉgabana quena caroaro mani ani majiquẽe. To bairi mani caʉgape jetore catʉgooñaquetipe ã. Dio Wadarique macare apiʉjari caroaro mani anicõa maji. To bairi tiere catʉgooñape ã,” ĩ Dio Wadarique, Satanáre cʉ caboca ĩñupʉ Jesu maca. ");
INSERT INTO tav_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Cabero Jerusalẽpʉ Jesure cʉ cajʉ́go aájupʉ Sataná. Topʉ cʉ jʉ́go aá, Dio wii buipʉ cʉ catʉjʉnucu rotiyupʉ Jesure Sataná maca. ");
INSERT INTO tav_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Dio wii bui cʉ tʉjʉnucu rotiri ocõo bairo cʉ caĩñupʉ: —Dio Macʉ mʉ cãmata bapa ña aácʉja. Mʉ yajiquẽcʉ. Dio Wadarique ocõo bairo ĩ: “Dio cʉ tʉ macanare mʉ cote rotigʉmi. Mʉ boca ñegarãma, ʉ̃tapʉre mʉ caroca peaquetiparore bairo ĩrã,” ĩ Dio Wadarique, cʉ caĩñupʉ Sataná Jesure. ");
INSERT INTO tav_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","To bairo cʉ caĩro: —Ape wame quena ocõo bairo ĩ Dio Wadarique: “Mʉ Ʉpaʉ Diore nʉcʉbʉgorique manona apeye uniere cʉ áti rotiqueticõaña,” Satanáre cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Cabero tunu Sataná cʉ cajʉ́go aájupʉ ʉ̃taʉ buipʉ. Cʉ jʉgo aá, ati yepa nipetiri macari, ati yepa macaje nipetiro caroare cʉ caiñooñupʉ Sataná Jesure. ");
INSERT INTO tav_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tiere cʉ iñoori ocõo bairo cʉ caĩñupʉ: —Atie tʉjʉya, caroa ati yepa macaje. Nipetirore mʉ yʉ joogʉ yʉ tʉpʉ ejacumuri yʉre mʉ cajeni nʉcʉbʉgoata, cʉ caĩñupʉ Sataná. ");
INSERT INTO tav_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","To bairo cʉ caĩro ocõo bairo cʉ caĩñupʉ Jesu: —Aácʉja, Sataná. Dio Wadarique ocõo bairo ĩ: “Dio jĩcaʉna ãmi Caʉpaʉ cáti nʉcʉbʉgopaʉ. Cʉ jeto cʉ carotirijere ája,” ĩ Dio Wadarique, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","To bairo cʉ caĩro cʉ ĩ janari cáaácoajupʉ Sataná yua. Cabero Dio tʉ macana atí, Jesure cʉ cátinemoñuparã. ");
INSERT INTO tav_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ti rʉmʉrina Juan bautisari majocʉre cʉ capreso jooyuparã ʉparã. To bairo cʉ na cátajere apii Jesu cʉ cabʉtirica macapʉ, Nasarépʉ catunucoajupʉ, Galilea na caĩri yepapʉ. ");
INSERT INTO tav_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Topʉ eja, yoaro mee ani, canetocoajupʉ. Neto aá, Capernaum na caĩri macapʉ cãñupʉ. Sabulón, Neptalí na caĩri paʉri tʉacã cãñupe Capernaum. ");
INSERT INTO tav_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","To bairona cʉ cabaipere cajʉgoyepʉna caĩ ucayupi Dio ye quetire buiori majocʉ Isaía tirʉmʉpʉ macacʉ: ");
INSERT INTO tav_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sabulón na caĩri paʉ, Neptalí na caĩri paʉ, Galilea na caĩri ra tʉ, Jordán na caĩri ya jʉgoye, Galileapʉ ti yepari macana ãma aperã, judío maja cãniquẽna. ");
INSERT INTO tav_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","To macana Dio yere majiquetibana quena cʉ ye quetire api majigarãma. Cayajiboricarã anibana quena to cãnacã rʉmʉ na yeri Dio tʉpʉ catirique bʉgagarãma. Canaitĩaropʉ cãnibatana cabujuropʉ catʉjʉrãre bairo tʉgooña majigarãma, wariñuurique mena Dio yere api majiri, caĩ ucayupi Isaía cajʉgoyepʉna. ");
INSERT INTO tav_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti paʉna Jesu cabuio jʉgóyupʉ Dio ye quetire. —Dio jootʉgami mere Ʉpaʉ ati yepapʉ carotipaʉ majuure. To bairi caroorije mʉja cátie jʉtiritiri mʉja yeri wajoaya, caĩ buio jʉgóyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesu Galilea na caĩri ra tʉjaro canʉgo aájupʉ. Nʉgo aá, Simón — ape wame quena Pedro cawamecʉcʉre, cʉ bai André menare na catʉjʉyupʉ. Na maca wai jĩari cajoo wapatari maja cãñuparã. To bairi wai wajarã cájuparã. ");
INSERT INTO tav_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","To bairo na cáto Jesu na tʉjʉ: —Adʉja yʉ mena. Caroaro mʉja wai waja maji. Yucʉra yʉ mena aána camajare Dio ye quetire mʉja buio majigarã. To bairo mʉja caĩ buiorijere apirã na quena Diore caapiʉjarã anigarãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","To bairo cʉ caĩro apirã nemoona na bapi yucʉre cáaá weocoajuparã, Jesu mena aána. ");
INSERT INTO tav_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","To bairi Jesu petoacã aánemobacʉna tunu aperã pʉgarãre catʉjʉyupʉ Sebedeo punaare. Jacobo, cʉ bai Juan cawame cʉjuparã. Na pacʉ Sebedeo mena cumuapʉ na bapi yucʉ cawooriquere cajia quenoo jañañuparã. To bairo na cáto tʉjʉ, na quenare na capiyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na cʉ capirijere apirã to cõona na cumua, na pacʉre cáaá weocoajuparã, Jesu mena aána yua. ");
INSERT INTO tav_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilea yepa nipetiropʉ caroa quetire Ʉpaʉ Dio cʉ cãniere cabuio teñañupʉ Jesu judío maja na caneñapo buenucuri wiiripʉ. Camaja cariarã quenare na cacatioyupʉ to cãnacã wame cariaye cʉnare. ");
INSERT INTO tav_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","To bairo cʉ cátiere caqueti apiyuparã Siria na caĩri yepa macana nipetirã. Queti apirã na quena nipetirã na yarã cariaye cʉnare cʉ tʉpʉ na cajee ajuparã. To cãnacã wame cariayecʉna, cawijiorã, capuni ecoorã, cawãtiacʉna, cañama riayecʉna, cáaá majiquẽnare cʉ tʉpʉ na cajee ejayuparã. To bairo na cáto nipetirãre na canetooñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","To bairi camaja capãarã cʉ caʉja teñañuparã. Galilea yepa macana, Decápoli na caĩri paʉ macana, Jerusalén maca macana, Judea yepa macana, Jordán na caĩri ya ape nʉgoa macana capãarã cʉ caʉja teñañuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Camaja capãarã cʉ na caʉja teñaro tʉjʉʉ ʉ̃taʉpʉ cáaácoajupʉ Jesu. Aá, topʉ caruiyupʉ. To bairo cʉ caruiro cʉ buerã cʉ tʉpʉ caneñapoyuparã. ");
INSERT INTO tav_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","To bairo na cabairo ocõo bairo na caĩ buioyupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—“Dio yere yʉ yeripʉ yʉ camajipe pairo majuu yʉ rʉja,” caĩ tʉgooñarãre Ʉpaʉ Dio cʉ cãnie wariñuuriquere na joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Catʉgooñarique pairã wariñuugarãma. Tʉgooña tutuariquere na joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’ “Carotii mee yʉ ã,” caĩ tʉgooñarã wariñuugarãma, ati yepa macajere carotiparã aniri. ");
INSERT INTO tav_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’ “Caroare Dio cʉ caboori wame seeto yʉ átigacʉpʉ,” caĩrãre wariñuuriquere na joogʉmi Dio. Na átinemogʉmi Dio. Cʉ caboori wame na cáti majiparore bairo na átinemogʉmi Dio maca. ");
INSERT INTO tav_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Aperãre na cabopaca tʉjʉrãre wariñuuriquere na joogʉmi Dio, na quenare na bopaca tʉjʉri. ");
INSERT INTO tav_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Na yeripʉ caroa macajere Dio cʉ caboorijere catʉgooñanucurã wariñuugarãma, Diore catʉjʉparã aniri. ");
INSERT INTO tav_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Aperã mena caame tutirãre caroaro na caame jʉgo ãno caĩrã wariñuugarãma, Dio, “Yʉ punaa ãma,” cʉ caĩrã aniri. ");
INSERT INTO tav_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dio cʉ caboorijere cána caroare na cátibato quena aperã nare na capopiyeyero wariñuugarãma, Ʉpaʉ Dio cʉ cãnie wariñuurique cʉ cajooparã aniri. ");
INSERT INTO tav_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Aperã mʉjaare pejucʉti tuti popiyeyegarãma yʉre caapiʉjarã mʉja cãno maca. Capee wame rooro mʉja ĩtogarãma naa. To bairo mʉjaare na cátie to cãnibato quena wariñuurique mʉja bʉgagarã. ");
INSERT INTO tav_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","To bairona Dio ye quetire buiori maja mʉja jʉgoye macana ãnana quenare na capopiyeyenucuñuparã. To bairi caroaro wariñuuña, Dio tʉpʉ caroare wariñuurique cʉ cajooparã aniri, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ocõo bairo caĩnemoñupʉ Jesu: —Camaja moa jãma ʉgariquepʉre, caroaro to ʉjeato ĩrã. To bairona mʉja quena caroaro Dio mena cãna ati yepa macana watoapʉ mʉja ã. To bairi caroaro Dio mena mʉja cãno tʉjʉrã aperã quena, “Nare bairona caroaro cãnipe ã mani quenare,” ĩgarãma. To bairi moa caocaaquẽpata ñuuquetiboro. Dope bairo átiri ocaa tunuo majiña maa. Camaja na cáaáti paʉpʉ maca yepapʉ reborãma cañuuquẽto tʉjʉri. To bairona mʉja quena, “Dio yarã jã ã,” caĩrã anibana quena mʉja majuuna cañuuquẽna mʉja cãmata aperãre, “Caroaro ája,” jocarãna na mʉja ĩborã. ");
INSERT INTO tav_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Camaja jĩa bujuma, canaitĩaropʉ na catʉjʉ majiparore bairo ĩrã. To bairo na cajĩa bujurore bairona mʉja cũmi Dio cʉ̃re caapiʉjarãre ati yepapʉre aperã quena na caapiʉja nutuaparore bairo ĩi. To bairi Dio yere mʉja camajiri wame cõona aperãre camajioparã mʉja ã. Camaja na ya maca buuro bui to cãmata jõpʉ tʉjʉjoricaro bau. Jõpʉ tʉjʉjoricarore bairona caroaro tʉjʉgarãma aperã cañuurijere Dio cʉ caboorije mʉja cátinucurijere. Caroaro mʉja cátinucurijere tʉjʉrã na quena, “Nare bairona Dio cʉ caboorijere mani átigarã mani quena,” ĩgarãma aperã. ");
INSERT INTO tav_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jĩa bujuricaro jotʉ muu cũricaro ẽoropʉ camaja jĩa bujuquẽnama. Jõ bui maca peoma jĩa bujuricarore, wii cãnare caroaro to ʉ̃ bujubojaato ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","To bairona mʉjaa, Dio yere mʉja camajiri wame cõo yajioquẽnana aperãre na majioña. Dio cʉ caboori wame cañuurije mʉja cáto tʉjʉrã na quena mani Pacʉ ʉmʉrecoo macacʉre cáti nʉcʉbʉgorã anigarãma aperã, caroaro mʉja cátinucurijere tʉjʉri yua. ");
INSERT INTO tav_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’ “Moisé tirʉmʉpʉ macacʉ cʉ carotirique, aperã quena Dio ye quetire buiori maja ãnana na caucarique regʉmi Jesu,” yʉ ĩ tʉgooñaqueticõaña. Tiere rei acʉ́ mee yʉ bai. Tierena átii acʉ́ yʉ cabaiwʉ, na caĩrica wamere bairona cabaii aniri. ");
INSERT INTO tav_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jocʉ mee ocõo bairo mʉjaare yʉ ĩ: Ati ʉmʉrecoo, ati yepa capetiparo jʉgoye Dio Wadarique jĩca wameacã maca requetigʉmi. “To bairona anigaro,” cʉ Wadarique cʉ caĩricarore bairona baigaro. Dio cʉ caĩrica wame cõona baigaro yua. ");
INSERT INTO tav_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","To bairi Dio cʉ carotirique jĩca wameacãna cabai botioʉ ũcʉ, aperã quenare, “Tiere bai botioya,” na caĩi ũcʉ Ʉpaʉ Dio cʉ cãnopʉ aperã to cãna ẽoro majuu anigʉmi. Apeĩ Dio cʉ carotiriquere cácʉ maca, aperã quenare cariapena tiere na ĩ buio, Ʉpaʉ Dio cʉ cãnopʉ cãni majuʉ anigʉmi cʉ̃a. ");
INSERT INTO tav_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Cariape mʉjaare yʉ ĩ: Judío majare cabuerã, fariseo maja quena caroare átitoma naa. To bairi mʉja maca caroare na cátitorijere bairo mee, cariapena caroare Dio cʉ caboori wame majuu ája. To bairo cariape maca mʉja cátiquẽpata Dio tʉpʉ mʉja aáquetigarã. ");
INSERT INTO tav_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Mʉja jʉgoye macanare Moisé cʉ carotiriquere caapiricarã mʉja ã. “Jĩaqueticõaña,” na caĩnucuñupi. “Mʉja cajĩaata ʉparã mʉja popiyeyegarãma,” na caĩñupi Moisé. ");
INSERT INTO tav_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉa ocõo bairo maca mʉjaare yʉ ĩ: Jĩcaʉ apeĩre capunijinii ũcʉ macare popiye tamʉorique cʉ anigaro. To bairo apeĩre rooro caĩ tutii ũcʉ quenare cʉ popiyeyegarãma ʉparã. “Catʉgooña majiquẽcʉ mʉ ã,” cʉ̃re cʉ caĩ tutiata caroorã ya paʉpʉ peropʉ cʉ rocaboʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’To bairi Dio wiipʉ aána Diore áti nʉcʉbʉgorã joe buje mʉgorica tutu bui apeye unie cʉ joogarã, “Apeĩre rooro cʉ yʉ cátie wapa yʉ tutibʉjaʉmi,” mʉja catʉgooña bʉgaata, Diore mʉja cajoobopere topʉna cũña mai. Tiere cũri mʉjaare catutii mena ame quenooña. Ame quenoo yaparo to cõona Dio wiipʉ cʉ mʉja cajoogarijere cʉ jooya Dio macare yua. ");
INSERT INTO tav_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Apeĩ, “Rooro yʉ mʉ ájupa, to bairi yʉ mʉ wapamo,” mʉjaare ĩ tutiri ʉparã tʉpʉ mʉjaare cʉ cañe aágata diwatina cʉ mena ame quenooña. Cʉ mena mʉja caame quenooquẽpata jues tʉpʉ mʉja jooboʉmi. To bairo mʉja cʉ cápata polisíare presopʉ mʉja joo rotiboʉmi jues. ");
INSERT INTO tav_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","To bairi presopʉ mʉja na cajooro nipetiro mʉja cawapamorijere mʉja cawapaye peoquẽpata mʉja buuquetiborãma. ");
INSERT INTO tav_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Tirʉmʉpʉre mʉja jʉgoye macanare, “Epericarã cʉtiqueticõaña,” Moisé cʉ cãni yʉteapʉre Dio na cʉ carotirica wame mʉja maji. ");
INSERT INTO tav_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yʉa ati wame maca mʉjaare yʉ ĩ: Ni ũcʉ cãromiore tʉjʉʉ, “Cõre yʉ áti epegabapa,” ĩ tʉgooñari, mere caroorije áami, cʉ yeripʉ co mena áti epe tʉgooñari. ");
INSERT INTO tav_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’To bairi caroorije átiga tʉjʉri ti wame caroorije mʉja cáto cacapea tʉjʉquẽna mʉja cãmata ñuuboricaro. Catʉjʉ majirã ñuubana quena caroorã ya paʉpʉ peropʉ mʉja cáaáto ñuuquẽe. Catʉjʉ majiquẽnana Dio tʉpʉ mʉja cáaáto maca ñuuboro. ");
INSERT INTO tav_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","To bairona mʉja wamori mena cariape nʉgoa mena caroorije mʉja cáto cariape nʉgoa cawamo mana mʉja cãmata ñuuboro. Cawamoricʉna anibana quena peropʉ mʉja cáaáto ñuuquẽe. Rupaʉ carooye tuaricarã jĩca wamo mana anibana quena Dio tʉpʉ mʉja cáaápata ñuubʉjaboro. ");
INSERT INTO tav_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Tirʉmʉpʉ mʉja jʉgoye macanare, “Jĩcaʉ cʉ nʉmore rocagʉ papera pũuro, ‘Ocõo bairo mʉ cabairije wapa mʉ yʉ rocagʉ,’ ĩrica pũuro cõre cʉ joato,” ĩ rotirica wame cãñupa. ");
INSERT INTO tav_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉa ocõo bairo maca mʉjaare yʉ ĩ: Jĩcaʉ cʉ nʉmo aperã mena co cáti epequetibato quena co rocaʉ caroorije co cáto ácʉmi. Co macare áti eperico co cãniparore bairo ácʉmi. Apeĩ cʉ carocaricore canʉmocʉcʉ cʉ quena rooro cáti eperico cʉcʉre bairona áami. ");
INSERT INTO tav_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ape wame tunu mʉja jʉgoye macanare rotirica wamere mʉja maji: “Jocʉ mee yʉ átigʉ. Dio cʉ catʉjʉrona mʉ yʉ ĩ cũ,” ĩrã to bairo mʉja caĩ cũricarore bairona ája mʉjaa. ");
INSERT INTO tav_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yʉa ati wame maca mʉjaare yʉ ĩ: “Jaʉ, yʉ átigʉ,” ĩri cariapena ti wamere áticõaña. Ape wame: “Yʉ átiquetigʉ,” o “Yʉ átiquẽpʉ,” ĩri jocaquẽnana ĩña mʉjaa. “Dio mena yʉ ĩ,” ĩquẽnana to bairona mʉja caĩri wamere bairona ája. “Ʉmʉrecoo mena yʉ ĩ,” ĩquẽja, ʉmʉrecoo Dio ya paʉ to cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Ati yepa mena yʉ ĩ,” ĩquẽja, cʉ ya yepa to cãno ĩrã. “Jerusalén maca mena yʉ ĩ,” ti wame quenare ĩquẽja, mani Ʉpaʉ Dio cʉ camairi maca to cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yʉ rʉpoa mena yʉ ĩ,” tie quenare ĩquẽja mʉja caĩri wame ĩ cũrã. Mʉja poa wẽrire mʉja wajoa majiquẽe, ti wẽriacã mʉja ñio majiquẽe, o mʉja botio majiquẽe. To bairi, “Yʉ rʉpoa mena yʉ ĩ, jocʉna yʉ caĩata yʉ rʉpoare na pa ta rocacõato,” ĩqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cawatoana, “Jaʉ,” o “Baiquẽe,” mʉja caĩri wame ĩ cũrã to bairona ĩña. “Ape wame tie mena yʉ ĩ,” ĩrã caroorije ʉpaʉ Sataná cʉ ĩnemorãre bairo mʉja ĩborã. ");
INSERT INTO tav_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ape wame quenare tirʉmʉpʉ macá wame mʉja majirã ocõo bairi wame: “Jĩcaʉ apeĩre cʉ quẽ, cʉ capere cʉ capa rooye tuata aperã cʉ capere na quẽ rooye tuato tunu to bairo cʉ cáti jʉgórique wapa. Apeĩ apeĩre cʉ quẽ, cʉ opire cʉ capa waro aperã cʉ opire na pa waato tunu, to bairo cʉ cáti jʉgórique wapa,” ĩrica wame cãñupa. ");
INSERT INTO tav_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yʉa ati wame macare mʉjaare yʉ ĩ: Apeĩ rooro mʉjaare cʉ cátibato quena rooro cʉ ame átiqueticõaña. Jĩcaʉ cariape nʉgoa mʉja riya cʉ caparo ape nʉgoa quenare cʉ pa rotiya tunu. ");
INSERT INTO tav_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jĩcaʉ, “Yʉ mʉ wapamo,” ĩri mʉja camisare cʉ caemaata cabui macato jutiiro quenare cʉ jooya. ");
INSERT INTO tav_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jĩcaʉ, “Yʉ átibojaya,” mʉja cʉ caĩro mʉja cʉ cáti rotirije netobʉjaro cʉ átibojaya. ");
INSERT INTO tav_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jĩcaʉ mʉjaare cʉ cajeniata cʉ jooya. Apeĩ, “Mʉ yere yʉ wajoya,” caĩire, “Mʉ yʉ jooquẽe,” cʉ ĩquẽja. ");
INSERT INTO tav_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ape wame quena ĩrica wamere mʉja majirã: “Mʉja yarãre na maiña. Mʉjaare catʉjʉ tutirã macare na teeya,” aperã na caĩri wamere mʉja majirã. ");
INSERT INTO tav_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yʉa ati wame macare mʉjaare yʉ ĩ: Mʉja catʉjʉ tutirã quenare na maiña. Rooro mʉjaare na cátibato quena Diore na jenibojaya. ");
INSERT INTO tav_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","To bairo ána mʉja Pacʉ ʉmʉrecoo macacʉ cʉ punaa, cʉ̃re bairo cãna mʉja anigarã. Dio quena caroorã cʉ̃re cabooquẽna na cãnibato quena caroare na joomi cañuurãre cʉ cajoori wamere bairona. Dio muipure aji rotimi caroarã quenare, caroorã quenare. Joomi oco quenare caroarã, caroorã quenare. To bairi mʉja quena Diore bairo na ája caroorã na cãnibato quena. Caroaro ame ája rooro mʉjaare cána na cãnibato quena. ");
INSERT INTO tav_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉjaare camairã jetore na mʉja camaiata, “Caroaro camairã ãma,” mʉja ĩ tʉjʉquẽcʉmi Dio. Camaja yere niyeru gobierno ye cãnipere jeebojari maja caroorã anibana quena to bairona mairãma nare camairãre. ");
INSERT INTO tav_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉja yarã jetore mʉja cañuu rotiro aperã netoro cañuuri wame mʉja átiquẽe aperã nipetirãre mʉja cañuu rotiquẽpata. To bairona na yarãre na ñuu rotima aperã, Diore camajiquẽna anibana quena. ");
INSERT INTO tav_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mʉja Pacʉ ʉmʉrecoo macacʉ cañuu netoʉ ãmi. To bairi mʉja quena cañuu netorã anicõaña, caĩñupʉ Jesu topʉ cʉ̃re caapirãre. ");
INSERT INTO tav_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ocõo bairo caĩ buionemoñupʉ Jesu tunu: —Caroare ána, “Aperã caroa wame yʉ cáto yʉ na tʉjʉato,” ĩ tʉgooñaqueticõaña. To bairo mʉja caĩ tʉgooñaata mani Pacʉ ʉmʉrecoo macacʉ, “Caroaro mʉja áa,” mʉja ĩquetigʉmi. Caroare mʉja wapa jooquetigʉmi. ");
INSERT INTO tav_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","To bairi cabopacoorãre na joorã, “Caroa majuu na yʉ átibojawʉ,” aperãre na ĩ buioqueticõaña. To bairona ĩnucuma aperã maca átitorã cabopacoorãre na joorã. “Caroarã jã ã,” jocarã ĩma. Neñapo buerica wiiripʉ, macari recomaca quena, noo camaja na cãnopʉ aána, “Cabopacoorãre na jã cajooro aperã jãre, ‘Caroarã ãma,’ jã na ĩ nʉcʉbʉgoato,” ĩ tʉgooñama. To bairo aperã, “Caroarã ãma,” nare na caĩ tʉjʉ nʉcʉbʉgobato quena to bairo na ĩ tʉjʉquẽemi Dio to bairo caĩ tʉgooñarãre. Cabopacoorãre na cátinemobatie wapa caroare na jooquetigʉmi Dio. Nare bairo jocarãna caroare cátitorã aniqueticõaña mʉjaa. ");
INSERT INTO tav_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mʉja maca cabopacoorãre na joorã aperãre na ĩ buioqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aperã mʉja yarã na catʉjʉquetibato quena cabopacoorãre na jooya. To bairo mʉja cáto mani Pacʉ jeto tʉjʉgʉmi na mʉja cajooro. To bairi caroa wamere mʉja cáto tʉjʉ, wariñuuriquere mʉja joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Diore jeni nʉcʉbʉgorã, “Aperã, ‘Diore caroaro cáti nʉcʉbʉgorã ãnama,’ jãre na tʉjʉ tʉgooñaato,” ĩ tʉgooñaqueticõaña mʉjaa. To bairi wame tʉgooñama aperã, “Caroarã jã ã,” caĩ jocarã. Neñapo buerica wiiripʉ, o maca recomacapʉ noo camaja na cãnopʉ tʉjʉnucuri Diore jenitoma, aperã jãre na tʉjʉ nʉcʉbʉgoato ĩrã. To bairo átitori na caĩ tʉgooñaro caroare na jooquetigʉmi Dio. Nare bairo tʉgooñaqueticõaña, Diore jeni nʉcʉbʉgorã. ");
INSERT INTO tav_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉja maca jĩcaʉna aperã na catʉjʉquẽtopʉ, noo mʉja ya arʉapʉ jãa, jope turicaro biperi mani Pacʉ Diore cʉ jeni nʉcʉbʉgoya. To bairo jĩcaʉna mʉja cajeni nʉcʉbʉgoro tʉjʉʉ mani Pacʉ jeto mʉja tʉjʉri wariñuuriquere mʉja joogʉmi yua. ");
INSERT INTO tav_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Aperã Diore camajiquẽna caroaro catʉgooñaquẽtie jeto yoaro wadama. “To bairo yoaro yʉ cawadaro yʉ apigʉmi Dio,” ĩ tʉgooñabapa. To bairi catʉgooñaquẽtiere yoaro na cawadarore bairo ĩquẽja mʉjaa, Diore jeni nʉcʉbʉgorã. ");
INSERT INTO tav_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nare bairo baiquẽja mʉjaa. Mani Pacʉ mere majitʉgami mʉja cajenipere mʉja cajeniparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","To bairi Diore jeni nʉcʉbʉgorã, ocõo bairo cʉ ĩña: Jã Pacʉ ʉmʉrecoo macacʉ, jĩcaʉna mʉ ã caroaʉ majuu, cáti nʉcʉbʉgopaʉ. ");
INSERT INTO tav_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ati yepapʉ Caʉpaʉ majuu ãña. Ʉmʉrecoo macana caroaro mʉ caboorije átinucuma. To bairo na cátore bairona ati yepa macana quena to bairona mʉ caboorijere na áparo. ");
INSERT INTO tav_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉgarique ati rʉmʉ jã caʉgapere jã jooya. ");
INSERT INTO tav_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Caroorije jã cátaje majirioya. Jã quena rooro jãre cátanare na caroorijere jã majiriogarã. To bairi nare jã camajiriobojarore bairona mʉ quena jãre majiriobojaya caroorije jã cátajere. ");
INSERT INTO tav_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sataná jãre cʉ cawadajãro caroorije jã cátibopere jã matabojaya. Mʉ jeto carotii mʉ ã. Mʉ jeto catutuaʉ mʉ ã. Mʉ jeto camaja na cáti nʉcʉbʉgopaʉ mʉ ã to cãnacã rʉmʉ anicõa aninucuri. To bairona camaja mʉre na áti nʉcʉbʉgo anicõato. Amén. ");
INSERT INTO tav_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’To bairi Diore jeni nʉcʉbʉgorã aperã rooro mʉja cátanare, “Rooro jãre mʉja cátajere mʉjaare jã majiriogarã,” na ĩña. To bairo aperã rooro mʉjaare na cátajere na mʉja camajirioro mani Pacʉ ʉmʉrecoo macacʉ mʉja quenare caroorije mʉja cátajere majiriogʉmi. ");
INSERT INTO tav_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Caroorije aperã mʉja na cátajere mʉja camajirioquẽpata mʉja majirioquetigʉmi mani Pacʉ rooro mʉja cátaje quenare. ");
INSERT INTO tav_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Diore áti nʉcʉbʉgorã ʉgaqueti mʉja cabairi paʉ catʉgooñarique pairãre bairo baiqueticõaña. To bairona bautoma aperã, “Caroarã jã ã,” caĩtorã maca. Na maca ʉgaqueti bairã ujaquẽnana, wʉgaquẽnana tʉgooñarique pairãre bairo baitoma, “Caroaro Diore áti nʉcʉbʉgorã ánama,” aperã jãre na ĩato ĩrã. To bairo na cabaitoro caroare na jooquetigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Mʉja maca Diore áti nʉcʉbʉgorã ʉgaquetiri mʉja cabairi paʉ caroaro uja, wʉga, mʉja cátinucurore bairona ája, aperã, “Ʉgaquetiri Diore áti nʉcʉbʉgorã ánama,” na caĩ majiquetiparore bairo ĩrã. To bairo mʉja cáto Dio jĩcaʉna mʉja tʉjʉri caroare mʉja joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ati yepa macaje apeye uniere pairo jee cũ cʉgo netoquẽja. Tiere ʉga rooye tuurãma caroorãacã. Ʉtabuti boacoapa. Cajee ruti pairã quena yajioropʉ pãri jee rutima. To bairi ati yepa macajere pairo jee cũ cʉgo netoquẽja. ");
INSERT INTO tav_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jõ bui macaje Dio ye caroa wariñuurique mʉja cacʉgope macare tʉgooñari Dio cʉ caboorije macare ája. Cʉ caboorije macare mʉja cáto pairo mʉja cʉgogarã jõ buipʉ. Dio tʉpʉ mani cacʉgoro macare ʉga rooye tuu majiquẽema caroorãacã. Ʉtabuti boaquẽe. Cajee ruti pairã quena pãri jee ruti majiquẽema Dio tʉpʉ. ");
INSERT INTO tav_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mʉja ye mʉja camairije cãnopʉ tie jetore mʉja tʉgooñacõa anigarã. To bairi ati yepa macaje apeye uniere mairã tie jetore mʉja yeri tʉgooñacõa anigarã. Dio ye macare mairã mʉja yeri wariñuugarã cʉ yere cáti anicõarã aniri. ");
INSERT INTO tav_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mʉja capea mena caroaro catʉjʉ majirã mʉja cãmata caroaro mʉja áti ani maji. To bairona mʉja yeri quena Dio mena caroaro cayericʉna mʉja cãmata caroaro mʉja ani maji. ");
INSERT INTO tav_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mʉja cacapea rooye tuaricarã maca mʉja cãmata apeye uniere caroaro mʉja áti majiquetiborã. To bairona mʉja yeri quena Dio mena mʉja cañuuquẽpata caroaro cʉ mena mʉja ani majiquẽe. To bairi Dio yere majibana quena cʉ caboorije mʉja cátiquẽpata Diore camajiquẽna majuu mʉja anicõagarã. ");
INSERT INTO tav_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Jĩcaʉ paabojari majocʉ jĩcanina cʉ ʉparã pʉgarãpʉrena na paaboja majiquẽcʉmi. Jĩcaʉ macare maiquetiboʉmi apeĩ macare maii. Jĩcaʉre caroaro cʉ átibojaboʉmi apeĩ macare cʉ paabojagatei. To bairona jĩcaro menare Diore apeye unie quenare mʉja mai majiquẽe. Diore mʉja camaiata ati yepa macaje apeye uniere mʉja mai tʉgooñaquetigarã. ");
INSERT INTO tav_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’To bairi ati wame mʉjaare yʉ ĩ buio: Ati yepa macajere seeto tʉgooñaqueticõaña. Mʉja caʉgapere, mʉja caetipere, mʉja cajañapere tʉgooñarique paiqueticõaña. Dio manire cátacʉ aniri mani caʉgapere mani caetipe quenare mani joo majimi. ");
INSERT INTO tav_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Miniare na tʉgooñaña. Caoterã me ãma. “Mani caoterique caricacʉto tiere mani ʉgagarã,” caĩ tʉgooñarã me ãma. Na caʉgape jee jõo cũrica wiiri cʉgoquẽema. To bairo na cabaibato quena mani Pacʉ ʉmʉrecoo macacʉ na joomi na caʉgapere. To bairi mʉja quenare mʉja cotegʉmi, minia netoro cʉ cámáirã mʉja cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Yoaro yʉ catigʉ,” pairo ĩ tʉgooñabana quena jĩca rʉmʉacã netobʉjaro mʉja catí majiquẽna. ");
INSERT INTO tav_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Nope ĩrã jutiire mʉja cajañapere mʉja tʉgooñarique paiti? Caoóre tʉgooñaña cabʉcʉaro. Paaqueti. Jutii to cajañape quenare equẽto. ");
INSERT INTO tav_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","To bairo to capaaquetibato quena caroaro tʉjʉricaro ñuurijere joomi Dio caoóre. Caʉpaʉ mani ñicʉ Salomón tirʉmʉpʉ macacʉ caapeye unie paii, caroa jetore cajañaricʉ cʉ ye jutii ãnaje netoro caroaro tʉjooricaro joomi Dio caoóre. ");
INSERT INTO tav_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","To bairo caroaro tʉjʉricaro ñuurijere joomi Dio tare yoaro mee cajinirije to cãnibato quena. Jĩca rʉmʉna owa, ape rʉmʉna jini, joe rerique ã. To bairo cabairije cãnibato quena caroaro cotemi Dio tare. Tiere cʉ cacotero netoro caroaro mʉja cotegʉmi Dio. To bairi mʉja cacʉgopere tʉgooñarique paiquetiri mʉjaare cʉ cacotepere caroaro tʉgooñari cʉ nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","To bairi Dio caroaro mʉjaare cʉ cacotero majirã apeye uniere mʉja cacʉgopere tʉgooñarique paiquẽja. “Yʉ caʉgape, yʉ caetipe, yʉ cajañapere yʉ boobapa,” caĩ tʉgooñarique pairã aniqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aperã ati yepa macana Diore canʉcʉbʉgoquẽna tiere seeto tʉgooñama. Mani Pacʉ ʉmʉrecoo macacʉ mʉja macare apeye unie mʉja cacʉgoquẽtiere majitʉgami mere. ");
INSERT INTO tav_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","To bairi ape wame netoro Ʉpaʉ Dio cʉ cãniere tʉgooñaña cʉ ye caroare cʉ caboorijere. To bairo mʉja catʉgooñaro Dio joogʉmi ati yepa macaje mʉja cacʉgopere. ");
INSERT INTO tav_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","To bairi bujiyʉ mʉja cabaipere tʉgooñarique paiquẽja. Bujiyʉ cãnipa rʉmʉ macajere mʉja tʉgooña majigarã to cabairopʉ. Yucʉ mʉja cabairije jetore mʉja tʉgooña maji. ");
INSERT INTO tav_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Aperãre, “Rooro áama, na capopiyeyepe ã,” na ĩ batequeticõaña. To bairi mʉja quenare, “Rooro áama, na capopiyeyepe ã,” mʉja ĩquetigʉmi Dio to bairo aperãre rooro na cátajere mʉja cabuio batequẽpata. ");
INSERT INTO tav_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aperãre rooro na cátajere mʉja cabuio baterore bairona caroorije mʉja cátajere ĩ buio bategarãma aperã tunu. Aperãre na mʉja cátore bairona mʉja quenare mʉja átigarãma tunu. ");
INSERT INTO tav_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Mʉja majuuna caroorije pairo átibana quena aperãre, “Rooro mʉja áa,” na ĩquẽja. Mʉja majuuna caroorije áti janaña to bairo aperãre na ĩgarã jʉgoye. To bairi apeĩre, “Mʉ capepʉ jitaacã cajañarijeacãre yʉ ne rocapa,” caĩrãre bairo mʉja ĩ, mʉja majuuna pairi pocaro mʉja cápeepʉ cajañabato quena. To bairo mʉja caĩata jocarã majuu mʉja ĩborã. Mʉja majuuna cápeepʉ cajañari pocarore ne rocaya mai. Cabero caroaro tʉjʉ majiri apeĩ cʉ capeapʉ jitaacã cajañari pocaroacãre mʉja ne rocaboja tʉjʉ majigarã. To bairona apeĩre, “Ati wame caroorije áti janacõaña,” cʉ ĩgarã jʉgoye mʉja majuuna cʉ netoro caroorije mʉja cátiere áti janacõaña. ");
INSERT INTO tav_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Dio yere caroa áti nʉcʉbʉgorica wamerire na jooquẽja Diore cateerãre. Na mʉja cajoata yaiare na mʉja cajoorore bairona mʉja átiborã. Yaia maca caroa macajere nare mʉja cajoorije cãnibato quena mʉjaare baqueborãma. To bairo quena caroa áti nʉcʉbʉgorica wamerire Diore cateerãre na mʉja cajoata yejeare pairo majuu cawapa pacarijere bʉjariquere na mʉja cajoorore bairona mʉja átiborã. Yejea maca tiere cʉta rooye tuu bateborãma. ");
INSERT INTO tav_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Diore cʉ jeniya mʉjaa. Cʉ̃re mʉja cajeniro mʉja joogʉmi. Cʉ jeniri mʉja cajeniri wame macaña. Macarã mʉja bʉgagarã. Apeĩ ya wii mʉja cajeniñaro cʉ capãbojarore bairona mʉja yʉgʉmi Dio cʉ mʉja cajeniro. ");
INSERT INTO tav_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Noo Diore cajenirãre na joogʉmi. Macarã, na cajenirijere bʉgagarãma. Diore na cajenicõa ãnore na yʉgʉmi jope tʉpʉ cajeniñarãre camajocʉ cʉ cayʉborore bairona. ");
INSERT INTO tav_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Mʉja punaa naorore na cajeniro ʉ̃taa macare na mʉja jooquẽna. ");
INSERT INTO tav_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","To bairona waire na cajeniro aña macare na mʉja jooquetiborã. ");
INSERT INTO tav_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","To bairona caroare mʉja punaare na mʉja joo maji, caroaro cáti majiquẽna anibana quena. To bairi caroare na mʉja cajooro netoro caroare mʉja joogʉmi mani Pacʉ ʉmʉrecoo macacʉ cʉ̃re cajenirãre. ");
INSERT INTO tav_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Aperã caroaro mʉjaare na cátipe boorã mʉja quena caroaro na ája. To bairi wame ĩrique ã Moisépʉre Dio cʉ caroti cũrique. Dio ye quetire buiori maja ãnana na caucarique quena to bairi wamena ĩrique anicõa. ");
INSERT INTO tav_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Dio tʉpʉ aátaje caéjaqueti jope jãariquere bairona ã, camaja jĩcaarãacã tore na cajãarore bairona. To bairona caéjaqueti wãre bairona ã Dio tʉpʉ aátaje, camaja jĩcaarãacã tore na cáaáto. Pairi jope maca, caéjari wãre bairo maca ã cayajiparã na cáaátopʉ, camaja capãarã topʉ na cáaáto. To bairi caéjaqueti jope maca cajãarãre bairo mʉja bai Diore api nʉcʉbʉgori. To bairi Dio tʉpʉ cáaáparã mena anigarã Diore api nʉcʉbʉgoya, Dio tʉpʉ aágarã. ");
INSERT INTO tav_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’ “Dio ye quetire buiorã jã áa,” jocarã caĩrãre na tʉjʉ majiri na apiʉjaqueticõaña. Diore caapiʉjarãre bairona baitori camajare seeto catʉgooña mawijiorã ãma. To bairi yaia macanʉcʉ macana oveja nuricarã caroarã na ajeri macare jañatori jĩa ʉgagarãre bairona baima camajare na ĩto rooye tuu tʉgooña mawijiogarã. ");
INSERT INTO tav_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na cátie tʉjʉrã na cãniere mʉja ĩ tʉjʉ majigarã, yucʉ caricare tʉjʉri cawame mʉja caĩ tʉjʉ majirore bairona. Yucʉ capota cʉtii ʉjere rica cʉtiquẽto. Caroorije pota miji wẽri quena caroa macaje rica cʉtiquẽto. ");
INSERT INTO tav_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yucʉ caroaʉ caroa ricacʉto. Yucʉ carooricʉ maca caroorije jeto ricacʉto. ");
INSERT INTO tav_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","To bairona yucʉ caroaʉ apeye caroorije ricacʉti majiquẽe. Carooricʉ quena caroa macaje ricacʉti majiquẽto. ");
INSERT INTO tav_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nipetirije yucʉ carica cʉtiquẽtiere quetí joe rema camaja. ");
INSERT INTO tav_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","To bairona camaja cariape caĩrã, caĩtorã quenare na mʉja tʉjʉ majigarã caroare o caroorije na cátore tʉjʉri. ");
INSERT INTO tav_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’capãarã majuu ãma, “Jesu yʉ Ʉpaʉ ãmi,” yʉre caĩrã. To bairo caĩrã anibana quena ʉmʉrecoopʉ yʉ carotiri paʉpʉ capãarã cajãaquetiparã ãma. Yʉ Pacʉ ʉmʉrecoo macacʉ cʉ caboorije cána jeto anigarãma yʉ carotiri paʉpʉre. ");
INSERT INTO tav_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Camaja caroorãre, cañuurã quenare Dio na cʉ cabejeri rʉmʉ cãnopʉ capãarã ocõo bairo yʉ ĩgarãma: “ ‘Jã Ʉpaʉ Jesu jã buio rotimi,’ ĩri Dio ye quetire jã caĩ buiowʉ. ‘Jesu jã rotimi,’ ĩri wãtiare jã cabuu joowʉ. ‘Jesu cʉ camajirije mena jã áa,’ ĩri áti iñoorica wamerire capee jã cápʉ́. To bairi mʉ tʉpʉ jã apʉ́,” yʉ ĩgarãma capãarã. ");
INSERT INTO tav_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","To bairo yʉ na caĩro: “Mʉjaare yʉ majiquẽe. Aperopʉ aánaja,” na yʉ ĩgʉ. “Caroorije cána mʉja ã,” na yʉ ĩgʉ. ");
INSERT INTO tav_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’To bairi yʉ cabuiorijere caapirã cabero caroaro yʉ cabuiorijere caapiʉjarã ʉ̃taʉ buipʉ cʉ wiire canʉcoʉre bairona ãma caroaro catʉgooña majirã aniri. Caroaro catʉgooña majirã to bairona wiire nʉcoborãma. ");
INSERT INTO tav_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","To bairi ʉ̃taʉ buipʉ jĩcaʉ cʉ ya wii cʉ canʉcoro pua ñaquẽto wino capapuro quena. Seeto oco caocaro ria capaicoato ʉ̃taʉ bui cʉ canʉcorica wii aniri pua ñaquẽto. ");
INSERT INTO tav_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aperã maca yʉ cabuiorijere apibana quena yʉ caĩrijere cátiquẽna paputiropʉ cawii nʉcoʉre bairona ãma naa, catʉgooña majiquẽna aniri. ");
INSERT INTO tav_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","To bairo paputiropʉ cʉ cawii nʉcoro bero oco caocaro, ria capaicoato, wino capapuro ti wii nemoo pua ñacoaboro. To bairona ti wiire canʉcoricʉre bairona ãma catʉgooña majiquẽna yʉ cabuiorijere apibana quena cátiquẽna, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","To bairo cʉ cabuio yaparoro na camaja paarãacã cʉ̃re caapiricarã cawariñuu api acʉacoajuparã, caroaro camaji netoʉre bairo na cʉ cabuioro maca. Nare cabuenucurãre bairo na cabuioquẽjupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cabero ʉ̃taʉ bui cãnacʉ carui aájupʉ Jesu. To bairo cʉ carui aáto camaja capãarã cʉ caʉjayuparã. ");
INSERT INTO tav_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","To bairo na caʉja aáto jĩcaʉ caajeri boaʉ cʉ tʉpʉ caejayupʉ. Eja, rʉpopatua tuatu cumu eja, Jesure cʉ cajeni nʉcʉbʉgoyupʉ: —Ʉpaʉ, mʉ cabooata yʉ caboarijere mʉ yaá majii, cʉ caĩ jeniñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","To bairo cʉ caĩro Jesu cʉ wamore ñiga peori cʉ capañañupʉ. Cʉ paña: —Mʉ yʉ yaágʉ. Mʉ caboarije yatigaro. To bairo cʉ caĩ pañarona nemoo cʉ caboarije cayati peticoajupe yua. ");
INSERT INTO tav_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","To bairo cʉ cañuuro: —Aperãre mʉ caboarije cayatiro na buioquẽja mai. Dio wii macacʉ sacerdote tʉpʉ aácʉja. Aá, mʉ canetoejere cʉ iñoʉja. Cʉ iñoo, topʉ Moisé ãnacʉ cʉ cajoo rotiriquere apeye uniere Diore cʉ jooya. To bairo mʉ cáto to cõona camaja mʉ canetoejere tʉjʉ majigarãma, cʉ caĩñupʉ Jesu caajeri boabatacʉre. ");
INSERT INTO tav_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cabero Capernaum na caĩri macapʉ caejayupʉ Jesu. Capernaupʉ cʉ caejaro romano majocʉ polisía maja ʉpaʉ Jesu tʉpʉ caejayupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Cʉ tʉpʉ eja: —Ʉpaʉ, yʉ paabojari majocʉ yʉ ya wiipʉ yojami. Seeto tamʉobacʉ aá majiquẽemi, cʉ caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","To bairo cʉ caĩro: —Cʉ riayere cʉ yʉ netooʉ aágʉ, cʉ caĩñupʉ Jesu romano majocʉre. ");
INSERT INTO tav_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","To bairo cʉ caĩro ocõo bairo maca cʉ caĩñupʉ polisía maja ʉpaʉ: —Ʉpaʉ, yʉ ya wiipʉ mʉ yʉ jãa roti majiquẽe, caroti majuʉ mʉ cãno maca. To bairi atopʉ ãcʉna mʉ carotirije mena cʉ riaye netooña, yʉ tʉpʉ aáquẽcʉna. To bairo mʉ caĩ wadaro netogaro cʉ cariaye cʉtie yʉ paa coteri majocʉre, cʉ caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Yʉa apeĩ ʉpaʉ ẽoro macacʉ yʉ ã, aperã polisía majare nare carotii anibacʉ quena. To bairi jĩcaʉ polisía yʉ ẽoro macacʉre, “Aácʉja,” cʉ yʉ caĩro aáboʉmi. Apeĩre, “Adʉja,” cʉ yʉ caĩro, atíboʉmi. Yʉ paabojari majocʉre apeye uniere cʉ yʉ cáti rotiro yʉ átibojami. To bairi mʉ maca caroti maji majuʉ aniri cʉ cariaye cʉtiere netoo rotiya yʉ tʉpʉ aáquẽcʉna, Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","To bairo cʉ caĩro: —¡Abʉma! caĩñupʉ Jesu cʉ̃re caʉjarãre. —Ani polisía maja ʉpaʉ romano yaʉ seeto yʉre catʉgooña nʉcʉbʉgoʉ ãmi. Cʉ̃re bairo seeto yʉre catʉgooña nʉcʉbʉgorã maama Israel macana, caĩñupʉ Jesu cʉ̃re caʉjarãre. ");
INSERT INTO tav_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—To bairi aperã capãarã judío maja cãniquẽna ani polisía maja ʉpaʉre bairo yʉre caapiʉjarã anigarãma. Na quena nipetiro macana judío maja aniquetibana quena Dio tʉpʉ Ʉpaʉ cʉ cãnopʉ anigarãma. Topʉ ãnaa mani judío maja menana caʉga ruirã anigarãma. To bairi na quena mani judío maja mani ñicʉ Abraham tirʉmʉpʉ macacʉ mena, cʉ macʉ Isaá mena, cʉ pãrami Jacobo mena ʉga ruigarãma, judío maja aniquetibana quena. ");
INSERT INTO tav_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aperã maca judío maja cãna anibana quena Dio tʉpʉ Ʉpaʉ cʉ cãnopʉ cáaáboparã aáquetigarãma, yʉre api nʉcʉbʉgoquetibana. To bairi nare Dio tʉpʉ cáaáquẽnare apero maca na regʉmi Dio canaitĩaropʉ, Dio na cʉ capopiyeyeri paʉpʉ. Topʉ seeto majuu tʉgooñarique pai otigarãma seeto majuu tamʉobana, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","To bairo cʉ̃re caʉjarãre ti wamere na ĩ yaparo: —Tunu aácʉja, cʉ caĩñupʉ polisía maja ʉpaʉre. —“Catigʉmi yʉ paa coteri majocʉ Jesu cʉ cariaye cʉtiere cʉ caneto rotirona,” yʉ mʉ ĩ tʉgooña nʉcʉbʉgowʉ, cʉ caĩñupʉ Jesu. —To bairi yʉ mʉ caĩ tʉgooña nʉcʉbʉgori wamere bairona to baiato, cʉ caĩñupʉ Jesu. To bairo cʉ caĩri paʉna polisía maja ʉpaʉre paa coteri majocʉ cañuucoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesu cáaájupʉ Pedro ya wiipʉre. Eja, Pedro mañicore co catʉjʉyupʉ bʉgoye mena caria yojaore. ");
INSERT INTO tav_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","To bairo co caria yojaro tʉjʉʉ Jesu co wamore capañañupʉ. Cõre cʉ capañarona nemoo canetocoajupe bʉgoye. To bairi cañuopʉ wamʉnʉca, ʉgariquere cʉ capeobojayupo yua. ");
INSERT INTO tav_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Canaiori paʉ cãni aáto cʉ tʉpʉ cajee ajuparã capãarã cawãtia cʉnare. Cʉ tʉpʉ nare na cajee ató Jesu wãtiare na cʉ cáaá rotirona cabuticoajuparã. Nipetirã cariayecʉna quenare na cacatioyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","To bairo átiri Dio ye quetire buiori majocʉ cãniñaricʉ ocõo bairo Isaía cʉ caĩ ucañarica wamere bairona cájupi Jesu: “Catutuaquẽnare mani átinemomi. Cariayecʉna quenare mani catiomi cʉ majuuna,” caĩ ucayupi Isaía cãniñaricʉ Jesu cʉ cátipere buio jʉgoyeyei. ");
INSERT INTO tav_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Camaja capãarã majuu Jesu tʉ catʉjʉnucu amojoreyuparã. To bairo capãarã majuu na cãno tʉjʉʉ cʉ buerãre: —Ʉtabʉcʉra i nʉgoapʉ mani peña aáparo, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","To bairo cʉ cáaágari paʉna judío majare cabuei jĩcaʉ Jesu tʉpʉ ejari cʉ caĩñupʉ: —Ʉpaʉ, yʉ quena yʉ aágʉ nipetiro mʉ cáaátopʉ, mʉ mena macacʉ anigʉ, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","To bairo cʉ caĩro: —Waibʉcʉrã quena na cãni operi cʉgoma. Minia quena cʉgoma na ria batiri na cãni paʉrire. Yʉ maca camaja tʉpʉ Dio cʉ cajooricʉ anibacʉ quena yʉ yojarica paʉ maa, cʉ caĩñupʉ Jesu. To bairo Jesu cʉ caĩro apii cáaágaquẽjupʉ, Jesure bairo yʉ cãni paʉ maniboro ĩi. ");
INSERT INTO tav_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Apeĩ Jesure caʉjaʉ jĩcaʉ Jesure cʉ caĩñupʉ: —Ʉpaʉ, mʉ mena macacʉ yʉ anigʉ. Mʉ mena cãnipaʉ anibacʉ quena yʉ pacʉre cʉ cotegʉ cʉ tʉpʉ yʉ anigʉ mai. Cʉ cabai yajiro bero mʉ mena yʉ aágʉ yua, cʉ caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","To bairo cʉ caĩro: —Nemoona yʉ mena atícoa ajá. Diore caapiʉjagaquẽna cabai yajirãre bairona ãma, Dio tʉpʉ cãniquetiparã aniri. To bairi Diore caapiʉjaquẽna maca na yarã nare bairona Diore cabooquẽnare na coteato, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Cumuapʉ caeja jãañupʉ Jesu cʉ buerã jãa. Eja jãa, capeña aájuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na capeña aáto ti ra recomaca na caejaro wino seeto capapu ájupe. Wino seeto capapurije mena cumuare cajabe jãa ruugayupe. To bairo to cabaibato quena Jesu canii cájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Cʉ buerã cumua caruagaro tʉjʉ acʉari Jesu cacani jañaʉre cʉ cayopioyuparã. —¡Yopiya, jã Ʉpaʉ! ¡Jã netooña! ¡Rua yajigarã mani bai! cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","To bairo na caĩro apii: —Yʉ mena aábana quena ¿Ñeere ĩrã to cõo mʉja uwiti? Catʉgooña uwiquetiparã mʉja anibajupa. Õcoacã majuu yʉre mʉja tʉgooña nʉcʉbʉgo, na caĩñupʉ Jesu cʉ buerãre. To bairo na ĩ, wamʉnʉca, winore, cajaberijere cajana rotiyupʉ. Tiere cʉ cajana rotirona nemoo cajana peticoajupe caroaro. ");
INSERT INTO tav_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cajanaro tʉjʉrã cʉ buerã catʉjʉ acʉacoajuparã. —¡Abʉma! Seeto majuu camajii ãcʉmi. Wino, cajaberije quena cʉ carotiro caroaro apicõa, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ʉtabʉcʉra i nʉgoa caejayuparã yua, Gadara maja na ya paʉpʉ. Jesu cʉ caroca tu ejarona cʉ̃re cabocayuparã cawãtiacʉna pʉgarã, ʉ̃ta tʉa pʉto camaja cariarãre yaarã na cawerica totiripʉ cãnana. Naa cawãtiacʉna seeto cauwarã ãma ĩrã camaja ti paʉre cáaá neto majiquẽjuparã, na uwibana. ");
INSERT INTO tav_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","To bairi Jesure cʉ boca tʉjʉ: —¿Nope ĩi jã mʉ patowãcoʉati mʉa? Dio Macʉna mʉ ã. ¿Dio jãre cʉ capopiyeyepa paʉpʉ nemoona jãre rei ejaʉ mʉ baiti? cʉ caĩ awajayuparã. ");
INSERT INTO tav_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jõpʉ na jʉgoye yejea capãarã caʉga ãñuparã. ");
INSERT INTO tav_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","To bairi: —Jãre camaja mena cãnare mʉ cabuuata i maja yejeapʉre jã jãa rotiya, Jesure cʉ caĩñuparã wãtia. ");
INSERT INTO tav_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","To bairo cʉ na caĩro apii: —Aánaja to roque, na caĩñupʉ Jesu. To bairo cʉ caĩrona wãtia camajapʉre cãnana buti aá, yejeapʉre cajãañuparã. Na cajãarona yejea nipetirã buuro bui camaca ʉga anibatana atʉ mecʉ ro aá, care ñua yaji peticoajuparã ʉtabʉcʉrapʉ. ");
INSERT INTO tav_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yejeare cacotebatana to bairo na cabairo tʉjʉ acʉari macapʉ caatʉ ruti aájuparã. Macapʉ atʉ ruti aá, nipetiro cabairique, cawãtia cʉtibatana na cabairique quenare cabuio peocõañuparã. ");
INSERT INTO tav_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","To bairo na caĩ buioro apirã ti maca macana nipetirã cabuti aájuparã, Jesure cʉ boca tʉjʉgarã. Cʉ boca tʉjʉri: —Aperopʉ aácʉja. Jã ya yepapʉ aniqueticõaña, cʉ caĩñuparã Jesure yua. ");
INSERT INTO tav_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu cumuapʉ eja jãa, ti ra i nʉgoa cãnacʉ capeñacoajupʉ, cʉ cãninucuri macapʉ tunu aácʉ. ");
INSERT INTO tav_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Cʉ catunu ejaro jĩcaʉ cáaá majiquẽcʉre yojarica ajeropʉ cʉ tʉpʉ cayo neajuparã aperã. “Mani yaʉre netoo majiimi Jesu,” caĩ tʉgooñañuparã. To bairo Jesu cʉ̃re na catʉgooña nʉcʉbʉgoro catʉjʉ majiñupʉ. To bairo tʉjʉ majiri: —Yʉ yaʉ, tʉgooña tutuaya. Caroorije mʉ cátajere majirioʉ yʉ áa, cáaá majiquẽcʉre cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","To bairo cáaá majiquẽcʉre cʉ caĩro judío majare cabuerã jĩcaarã to cãna, “Ani Jesu rooro Dio cʉ catʉjooquẽtie ĩmi,” na majuuna caĩ tʉgooñañuparã. Dio jĩcaʉna ãmi caroorije camaja na cátiere camajirio majii ĩrã caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","To bairo na caĩ tʉgooñarijere camajiñupʉ Jesu. Na caĩ tʉgooñarijere majiri: —¿Nope ĩrã mʉja yeripʉre rooro yʉre mʉja tʉgooñati mʉjaa? ");
INSERT INTO tav_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Apeĩ, “Caroorije mʉ cátajere majirioʉ yʉ áa,” jocʉna ĩ majiboʉmi apeĩre caroorije cʉ cátajere re majiquetibacʉ quena. Cáaá majiquẽcʉre, “Wamʉnʉca aácʉja,” ti wame macare cʉ̃re cʉ caĩata cʉ canetoo majiquẽtiere iñooboʉmi. ");
INSERT INTO tav_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","To bairi yʉ ati yepapʉ Dio cʉ cajooricʉna yʉ cãniere, camaja caroorije na cátiere na yʉ camajirio majirijere mʉjaare yʉ iñoogʉ, na caĩñupʉ Jesu. To bairo na ĩ, cáaá majiquẽcʉre ocõo bairo cʉ caĩñupʉ: —Wamʉnʉcaña. Mʉ yojaricarore ne, mʉ ya wiipʉre aácʉja, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","To bairo cʉ caĩrona cáaá majiquetibatacʉ wamʉnʉca, cʉ ya wiipʉ cáaácoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","To bairo cʉ cáaáto to cãna paarãacã catʉjʉ acʉacoajuparã. Tʉjʉ acʉari Diore, “Ñuu majuucõa,” caĩ wariñuuñuparã. Jesu camajocʉ cʉ cãnibato quenare Dio cʉ cáti majirijere cʉ̃re cʉ cajooro tʉjʉrã caroaro Diore caĩ wariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cabero topʉ cãnacʉ cáaácoajupʉ Jesu. Aá, yʉre Mateore yʉ catʉjʉwĩ. Gobierno ye cãnipere camaja ye niyerure yʉ cajeeri arʉapʉ yʉ caruiro yʉ catʉjʉwĩ. To bairi yʉre tʉjʉ: —Yʉ mena ajá, yʉ caĩwĩ. To bairo yʉ cʉ caĩrona wamʉnʉca, Jesu mena yʉ cáaácoapʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cabero wiipʉ Jesu cʉ caʉga ruiro yʉre bairona capaariquecʉna gobierno ye cãnipere camaja ye niyerure cajeerã, aperã capãarã, “Caroorã ãma,” camaja na caĩ tʉjʉrã Jesu mena, cʉ buerã jã mena caʉga ruiwã. ");
INSERT INTO tav_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","To bairi fariseo maja Jesu mena na caʉga ruiro tʉjʉrã: —¿Nope ĩi mʉja ʉpaʉ gobierno ye cãnipere camaja ye niyerure cajeerã mena, aperã caroorã mena cʉ bapacʉti ʉganucuti? cʉ buerãre jãre caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","To bairo jãre na caĩ jeniñarijere caapiwĩ Jesu. To bairo na caĩro apiri ocõo bairo na caĩwĩ: —Cariaquẽnare na ʉcoyequẽcʉmi ʉcoyeri majocʉ. Cariarã jetore na ʉcoyeimi. ");
INSERT INTO tav_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dio Wadariquepʉ ocõo bairo tirʉmʉpʉ macana na caĩ ucarica wamere tʉgooña majirã aánaja: “Aperãre bopaca tʉjʉrique macare yʉ boo. Waibʉcʉrãre joe buje mʉgo jooriquere yʉ booquẽe,” caĩ ucayupa tirʉmʉpʉ macana. To bairi, “Cañuurã jã ã,” jocarãna caĩ tʉgooñarãre na pi acʉ́ mee yʉ cabaiwʉ. “Caroorije cána jã ã,” caĩrã macare na pi acʉ́ yʉ cabaiwʉ ati yepapʉre, na tʉgooñarique na wajoaato ĩi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Cabero Juan bautisari majocʉ cʉ cabuerã Jesure cʉ cajeniñarã ejawã: —¿Nope ĩrã mʉ buerã Diore jeni nʉcʉbʉgorã ʉgaqueti na baiquetinucuti? Jã maca jã bainucu. Fariseo maja quena to bairona Diore jeni nʉcʉbʉgorã ʉgaqueti bainucuma. Mʉ buerã maca baiquẽema. ");
INSERT INTO tav_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","To bairo cʉ na caĩ jeniñaro ocõo bairo na caĩwĩ Jesu: —Jĩcaʉ cʉ cawamo jiari boje rʉmʉ cãno cʉ mena macana tʉgooñarique pairi ʉgaqueti bai majiquẽnama na mena cʉ cãno. Ape rʉmʉ aperã cʉ ñeri aperopʉ cʉ̃re na cane aápata to cõona cʉ tʉgooñarique paibana ʉgaqueti baiborãma, na caĩwĩ Jesu. Jã cʉ buerã mena cʉ cãnona Diore nʉcʉbʉgori jã caʉgaqueti tʉgooñarique pai majiquẽtiere na ĩ buioʉ, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ape wame na caĩwĩ Jesu, cʉ ye buiorique cabʉcʉ wamere Moisé cãniñaricʉ cʉ caucarique fariseo maja jãa jocarãna na cabuerije mena catʉgooña ajuquetipe ã, na ĩ buioʉ: —Jutiiro cabʉcʉ yeje caboari opere tʉjʉrã cawama rʉca ta ne, mʉja e tuquẽna. Cawama rʉcare mʉja cae tuata ti rʉca rʉgaboro mʉja cacojero. To bairo rʉgari netobʉjaro wooboro. ");
INSERT INTO tav_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","To bairona vino etirique cawama macare cabʉcʉ poapʉ waibʉcʉ ajero jãa erica poapʉ mʉja pio jãquẽna, woocoaboro ĩrã. To bairo to cawooro pio recoaboro mʉja capio jãbataje. To bairi cawama macajere cawama poa macare mʉja pio jãborã. To bairo mʉja cáto etirique, waibʉcʉ ajero jãa erica poa quena caroaro anicõa, na caĩwĩ Jesu. To bairona tʉgooña ajuquẽja fariseo maja ye jãa, yʉ ye yʉ cabuiorije mena ĩi, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","To bairije Jesu na cʉ caĩri paʉ jĩcaʉ neñapo buerica wii ʉpaʉ cʉ tʉpʉ caejawĩ. Eja, rʉpopatua tuatu cumu eja, ocõo bairo Jesure cʉ cajeni nʉcʉbʉgowĩ: —Yʉ maco yucʉacãna ria yajiwõ. Caria yajirico co cãnibato quena cõre mʉ cañupeoro tunu catigomo. To bairi yʉ tʉpʉ mʉ apá, cʉ caĩwĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","To bairo cʉ caĩro apii, Jesu wamʉnʉca, cʉ mena cáaámi, cʉ buerã jãa. ");
INSERT INTO tav_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Jã cáaáto jĩcao ámo janaquetajere cariayecʉco Jesu bero caejawõ. Doce cʉmari to bairona cariaye cʉticõa aninucuo cãñupo. To bairi Jesu bero eja, cʉ jutiiro yapare capañawõ, “Cʉ jutiire pañari yʉ ñuucoago,” ĩ tʉgooñari. ");
INSERT INTO tav_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","To bairo cʉ jutii co capañaro Jesu cõre amojore tʉjʉ: —Yʉ yao, tʉgooña tutuaya. Yʉre tʉgooña nʉcʉbʉgori mere mʉ ñuucoapa, co caĩwĩ Jesu. To bairo co cʉ caĩrona nemoo cañuucoamo. ");
INSERT INTO tav_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cabero neñapo buerica wii ʉpaʉ ya wiipʉ caejawĩ Jesu. Eja, to cãna paarãacã tʉgooñarique pairã seeto caoti awajarãre na catʉjʉwĩ Jesu. Aperã tʉgooñarique pairique jãa bajarã cámá tõroari jãa. ");
INSERT INTO tav_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","To bairo na cabairo ocõo bairo na caĩwĩ Jesu: —Buti aánaja. Atio cawimao bai yajiquẽemo. Canio áamo, caĩwĩ Jesu. Mere cabai yajirico co cãnibato quena na caĩwĩ, tunu catigomo cani yopiricarore bairo ĩi. To bairo na cʉ caĩro cʉ caĩ epe tutiwã, mere yajicoamo ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","To bairo cʉ na caapi nʉcʉbʉgoquẽtie cãnibato quena Jesu na buti roti, cawimao cabai yajirico ãnaco co capejari arʉapʉ cajãami. Jãa, co wamopʉ cañeñupʉ. To bairo co cʉ cátona nemoo tunu catiri cawamʉ nʉcacoajupo. ");
INSERT INTO tav_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","To bairo co cabairiquere nipetiropʉ cabuio bate peocõañuparã to macana. ");
INSERT INTO tav_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu ti wii cãnacʉ caneto aámi. Cʉ cáaáto pʉgarã caʉmʉa catʉjʉ majiquẽna cʉ caʉjawã ocõo bairo cʉ ĩ jeni awajari: —¡Jesu, David pãrami! Dio cʉ cajooricʉ mʉ ã. ¡Jã bopacoo tʉjʉya! ");
INSERT INTO tav_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","To bairi Jesu ti wiipʉ cʉ cajãa aáto catʉjʉ majiquẽna cʉ tʉpʉ caejawã. To bairi cʉ tʉ na caejaro na caĩwĩ yua: —Tʉjʉriquere manire joo majimi, ¿yʉre mʉja ĩ tʉgooña nʉcʉbʉgoti? To bairo na cʉ caĩro apirã ocõo bairo cʉ caĩwã: —Ʉ̃ʉjʉ, mʉre jã tʉgooña nʉcʉbʉgo, jã Ʉpaʉ, Jesure cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","To bairo na caĩro Jesu na capere na capañawĩ. Pañaʉna, caĩwĩ: —Yʉre mʉja caĩ tʉgooña nʉcʉbʉgori wamere bairona to baiato, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","To bairo na cʉ caĩrona to cõona catʉjʉ majicoama naa yua. —Aperãre yucʉacã mʉja cabairijere na ĩ buioqueticõaña, na caĩbami Jesu seeto. ");
INSERT INTO tav_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","To bairo seeto na cʉ caĩ buiorije to cãnibato quena buti aánana cabuio bate peocõawã. To bairi ti yepa macana caapi peticoajupa na cabairiquere. ");
INSERT INTO tav_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","To bairi catʉjʉ majiquetibatana mere cañuurãpʉ ti wiipʉ cãnana na cabutiri paʉna apeĩre cawada majiquẽcʉre, cawãticʉcʉre Jesu tʉpʉ cʉ caneamá aperã. ");
INSERT INTO tav_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","To bairi wãtire cʉ mena cãcʉre cʉ cabuuwĩ Jesu. Cʉ̃re cʉ cabuurona nemoo cawada majicoami. To bairo cʉ cawada majiro tʉjʉrã to cãna paarãacã catʉjʉ acʉacoama. Tʉjʉ acʉari ocõo bairo caĩwã: —Ati wame cʉ cáti iñoorijere bairo jã catʉjʉquetinucuwʉ ato Israel yepapʉre, caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo maja maca: —Ani wãtiare na buumi wãtia ʉpaʉ cʉ carotiro menana, cʉ caĩwã Jesure, cʉ tʉgooña nʉcʉbʉgoquẽnana. ");
INSERT INTO tav_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Caroa quetire, Ʉpaʉ Dio cʉ cãniere cabuio teñawĩ Jesu yua. Macaa cãno cõo, ape macariacã camaja na cãnopʉ neñapo buerica wiiripʉ cabuio teñawĩ. To cãnacã wame cariaye cʉnare, cawijiorãre na cacatio teñawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","To bairi camajare capãarã majuu na tʉjʉ, na cabopacoo tʉjʉwĩ, catʉgooñarique pairã, dope bairo cáti majiquẽna na cãno maca. Oveja nuricarã nare cacotei manare bairo na cabairo na cabopacoo tʉjʉwĩ. ");
INSERT INTO tav_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","To bairo na bopacoo tʉjʉ, cʉ buerãre ocõo bairo na caĩwĩ: —Camaja capãarã majuu cátinemoparã ãma Diore caapiʉjaparã. Nare cátinemoparã, nare cabuioparã maca jĩcaarãacã ãma. To bairi Diore cʉ jeniya, aperã nare cátinemoparã nare cabuioparã na cãninemoparore bairo ĩrã. To bairona trigo weje caape cajũari paʉ nemoona tiere cajeeparã capãarã majuu paari majare boo, pairi weje cãno, wẽ yajire ĩrã. To bairi weje ʉpaʉre capãarã cajeenemoparãre cajenipe aniboro. To bairona cajenipe ã Diore. Cʉ jeniya camajare cabuioparã, nare cátinemoparã na aninemoato ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu cʉ buerã doce cãnacãʉ jãre pi neori wãtiare jã cabuu majipere cajoowĩ. To cãnacã wame cariaye cʉnare na jã cacatio majipe quenare jã cajoowĩ. ");
INSERT INTO tav_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cʉ buerã cãniparã ato cãnacãʉna jã cãmʉ: Cãni jʉgóʉ Simón Pedro cawamecʉcʉ cãmi. Apeĩ cʉ bai André cãmi, aperã Jacobo, cʉ bai Juan — Sebedeo punaa cãma. ");
INSERT INTO tav_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Apeĩ Felipe, apeĩ Bartolomé, apeĩ Tomás cãma. Yʉ Mateo na mena macacʉ yʉ cãmʉ, gobierno ye cãnipe camaja yere niyeru cajei cãnibatacʉ. Apeĩ Jacobo (Alfeo macʉ) cãmi. Apeĩ Lebeo, Tadeo quena cawamecʉcʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Apeĩ Simón, cananista na caĩri poa macacʉ cãmi. Apeĩ Judas Iscariote cãnibami Jesure cajĩaparãre cawadajãpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","To bairi doce cãnacãʉ jãre pi neo, jã cáti teñapere ocõo bairo jã caĩ buiowĩ: —Judío maja cãniquẽna tʉpʉ aáquẽja. Samaria macana ya macaripʉ quenare aáquẽja. ");
INSERT INTO tav_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Oveja nuricarã cayajiricarãre bairo cabairã ãma Israel maja, Diore majiritibana. To bairi na tʉ jetore buio teñarã aája. ");
INSERT INTO tav_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nare buiorã, “Yucʉacãna Dio joogʉmi Ʉpaʉ ati yepapʉ carotipaʉ majuure,” na ĩ buioya Israel macanare. ");
INSERT INTO tav_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cariarãre na cariaye cʉtiere netooña. Cabai yajiricarãre na tunu catioya. Caajeri boarije mena cariarãre na camiire yatiobojaya. Wãtiare na buuya. Wapa manona camajare na mʉja canetoobojapere mʉjaare yʉ joo. To bairi wapa manona camajare na cariaye tamʉorijere na netoobojaya. ");
INSERT INTO tav_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Niyerure jee aáquẽja. ");
INSERT INTO tav_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Umarica poari apeye uniere mʉja cajee aáteñapa poari quenare jee aáquẽja. Camisa jĩcarori jeto jee aánaja. Rʉpo jutii caroa macaje, tuericʉ yucʉ quenare jee aáquẽja. Yʉre cátinemorãre bairo mʉja átigarã mʉja ye mʉja caʉgape, mʉja ye mʉja cajañape bʉgari. Mʉja átinemogʉmi Diona mʉja cacʉgopere. ");
INSERT INTO tav_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Noo caboori maca o macaacã camaja na cãnopʉ ejarã noo jĩcaʉ caroaʉ mʉjaare cʉ tʉpʉ mʉjaare cʉ cãni rotipaʉre macaña. To bairo cabaiire bʉgarã cʉ ya wiipʉ tuaya ti macapʉ mʉja cãni rʉmʉri cõona. ");
INSERT INTO tav_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","To bairi ti wiipʉ ejarã caroaro na ñuu rotiya ti wii macanare. ");
INSERT INTO tav_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ti wii macana na tʉpʉ caroaro mʉjaare na cãni rotiro Diore na mʉja cajenibojari wamere bairona na átinemogʉmi Dio nare. Na tʉpʉ mʉjaare cãni rotiquẽna macare Diore nare, “Wariñuuriquere na jooya,” nare mʉja jenibojaquetigarã. ");
INSERT INTO tav_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Noo mʉjaare na ya paʉpʉre cãni rotiquẽna, mʉja cabuiorijere caapigaquẽna na ya wiire o na ya macare mʉja buti aáweogarã. Buti aána, mʉja rʉporipʉre jita catujarijere we bate reya. Na majuuna caroa quetire mʉja cabuioro cabooquẽnare na quenare booquẽemi Dio, na iñoorã to bairo mʉja átigarã. ");
INSERT INTO tav_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cariapena mʉjaare yʉ ĩ. Dio cʉ̃re caapiʉjaquẽnare na cʉ capopiyeyeri paʉ cãnopʉ seeto na popiyeyegʉmi Dio. Tirʉmʉpʉ macana Sodoma, Gomora na caĩri macari macanare Dio nare cʉ capopiyeyericaro netoro mʉja cabuiorijere cabooquẽnare na popiyeyegʉmi Dio, jã caĩwĩ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesu jã caĩ buiowĩ tunu: —Mʉjaare yʉ joo caroorã tʉpʉ, mʉjaare cateerã tʉpʉre. Oveja caroarã yaia cauwiorã na ya paʉpʉre cajoʉre bairona mʉjaare yʉ joo mʉjaare cabooquẽna tʉpʉre. To bairi caroaro tʉgooña majiña na tʉpʉ mʉja cátipere. Rooro mʉjaare na cátigarije to cãnibato quena caroaro na ája. ");
INSERT INTO tav_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Judío maja ʉparã tʉpʉ na neñapo buerica wiiripʉ mʉjaare ñe átiri mʉja bapegarãma. To bairo caroorã mʉjaare na cátigarijere caroaro tʉgooña jʉgoyeyeri ãña. ");
INSERT INTO tav_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aperã maca ʉparã tʉpʉ mʉja ñe aágarãma, Jesure caapiʉjarã ãma ĩrã. To bairo ʉparã tʉpʉ mʉjaare na cañe aáto maca ʉparã quenare yʉ ye quetire na mʉja buiogarã. Judío maja cãniquẽna quenare yʉ ye quetire na mʉja buiogarã mʉjaare na cañe aáto. Mʉjaare ñeri ʉparãre na mʉja wadajãgarãma, na popiyeyeya ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","To bairo na cáto ʉparãre mʉjaare na cajeniñarijere na mʉja caĩ yʉpere tʉgooñarique paiquẽja. Na mʉja caĩ yʉpere mʉja majiogʉmi Dio mʉjaare na cajeniña tutiri paʉna. ");
INSERT INTO tav_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","To bairi mʉja majuuna mʉja caĩpe me anigaro. Mani Pacʉ Dio cʉ Espíritu Santo mʉjaare cʉ caĩ majiorije macare mʉja ĩ yʉgarã. ");
INSERT INTO tav_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ti paʉ cãno jĩcaʉ apeĩre yʉre caapiʉjaʉ cʉ cãno tʉjʉʉ cʉ preso joori, cʉ na jĩacõato ĩi cʉ átigʉmi cʉ baina cʉ cãnibato quena. Aperã aperãre na punaana na cãnibato quena ʉparã tʉpʉ na ñe aágarãma, Jesure na caapiʉjarije wapa na jĩa recõaña ĩrã. Aperã na pacʉarena to bairona ʉparãre na jĩa rotigarãma. ");
INSERT INTO tav_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Camaja nipetirã mʉja tʉjʉteegarãma, Jesure caapiʉjarã ãma ĩrã. To bairo rooro mʉjaare na cátibato quena yʉre apiʉja janaquẽja. Noo mʉja cacatiri rʉmʉ cõona yʉre apiʉja janaquẽna to cãnacã rʉmʉ Dio tʉpʉ cãnicõa aninucupere mʉja bʉgagarã. ");
INSERT INTO tav_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jĩca maca macana mʉjaare tutiri mʉjaare na capopiyeyero ape macapʉ ruti aácoanája mʉjaa. Israel yepa macaje nipetirije macaripʉ mai caroa quetire mʉja cabuio teña peoparo jʉgoye yʉ tunu atígʉ ati yepapʉre tunu. ");
INSERT INTO tav_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Noa nare cabueire caroaro ani neto majiquẽnama. To bairona paari maja na ʉpaʉre caroaro ani neto majiquẽnama. ");
INSERT INTO tav_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Camaja nare cabuei cʉ cabairore bairona baigarãma. To bairona paari maja na ʉpaʉre bairona baigarãma. To bairi yʉre mʉja Ʉpaʉre, “Wãtia ʉpaʉ cʉ carotiro mena ácʉmi Jesu,” yʉre na caĩata mʉja quenare yʉ yarãre to bairona, “Wãtia ʉpaʉ cʉ carotiro mena ánama,” mʉja ĩgarãma mʉja quenare. To bairi rooro yʉre ĩrã, mʉja quenare rooro mʉja ĩgarãma. ");
INSERT INTO tav_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","27","’To bairi mʉjaare cabooquẽnare na uwiquẽja. Aperã na caapiquẽtopʉ mʉjaare yʉ caĩrije nipetiro camaja nipetirãre na mʉja queti buio teñagarã. Cajʉgoye na camajiquẽtiere nare camajiope ã. ");
INSERT INTO tav_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","To bairi mʉjaare cajĩagarãre na uwiquẽja. Mʉja rupaʉrire na cajĩagarije to cãnibato quena mʉja yerire re majiquẽema. Dio jĩcaʉna ãmi camaja na yerire caroorã na capopiye tamʉori paʉpʉ care majii peropʉ. To bairi cʉ jetore cʉ api nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","’Miniacã wapa maama. Cawapa mana na cãnibato quena na quenare na cotemi Dio. Jĩcaʉ miniacã yajiquetigʉmi Dio cʉ carotiquẽpata. Mʉja macare minia netoro mʉja mai tʉjʉ ʉjami Dio. To bairi camaja rooro mʉjaare na cátigarijere tʉgooñarique pai uwiquẽja. Mʉja poa wẽriacã quenare tʉjʉ cõoña majimi Dio. To bairo caroaro mʉja cabairijere catʉjʉ majii aniri caroaro mʉja tʉjʉ ʉja majimi Dio. ");
INSERT INTO tav_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’ “Jesu yʉ Ʉpaʉ ãmi. Caroaʉ ãmi. To bairi cʉ caboorijere yʉ átigʉ,” aperãre na ĩ buioya, boboquẽnana. Noa to bairona aperãre cabuiorãre yʉ quena yʉ Pacʉ ʉmʉrecoo macacʉre, “Yʉ yarã ãma,” cʉ yʉ ĩ buiogʉ nare. ");
INSERT INTO tav_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aperã maca, “Yʉ Ʉpaʉ ãmi Jesu. To bairi cʉ caboorijere yʉ átigʉ,” ĩgaquẽema, bobobana. Bobobana yʉ catʉjooquẽtie macare áama. To bairi yʉ Pacʉ ʉmʉrecoo macacʉre, “Yʉ yarã me ãma,” cʉ yʉ ĩgʉ nare tunu. ");
INSERT INTO tav_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’ “Camaja nipetirã Jesure tʉgooña nʉcʉbʉgogarãma,” ĩ tʉgooñaquẽja. “Nipetirã jĩcaro cõo Jesure tʉgooñagarãma, to bairi ati yepapʉ caroaro ãnaje anigaro,” ĩ tʉgooñaquẽja. Yʉ caejaro camaja ricati yʉ cãniere tʉgooñabana ame tuti, ame quẽgarãma. Jĩcaarã yʉre boorã, aperã maca yʉre booquẽna ame tutigarãma. ");
INSERT INTO tav_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","To bairi yʉ cãniere ricati tʉgooñari jĩcaʉ cʉ pacʉrena cʉ tutigʉmi. Jĩcao co pacorena tutigomo. Apeo co mañicorena co tutigomo. ");
INSERT INTO tav_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","To bairi jĩcaʉ cʉ ya wii macanana cʉ̃re catʉjʉ tutirã anigarãma yʉre camaii cʉ cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Mʉja pacʉare, mʉja punaare yʉ netoro mʉja camaiata yʉ mena macana mʉja ani majiquetigarã. ");
INSERT INTO tav_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yʉre na cajĩagarore bairo mʉja quenare na cajĩagarije to cãnibato quena yʉre áti ʉjanucucõaña. To bairi noa, “Jesu cʉ cátatore bairo yʉ átiquetigʉ, yʉ quenare yʉ popiyeyerema ĩi,” caĩrã una yʉ mena macana ani majiquetigarãma. ");
INSERT INTO tav_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noa, “Yʉ jĩarema,” ĩrã yʉre caapiʉjagaquẽna Dio tʉpʉ to cãnacã rʉmʉ aniquetigarãma. Aperã maca yʉre na caapiʉjarije wapa aperã nare na cajĩabato quena caroaro aninucucõagarãma, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Yʉ ye quetire yʉ carotiro mena mʉja cabuioro mʉjaare caapi nʉcʉbʉgorã yʉpʉre api nʉcʉbʉgorã átigarãma. Yʉre api nʉcʉbʉgorã yʉ Pacʉ yʉre cajooricʉpʉre api nʉcʉbʉgorã átigarãma. ");
INSERT INTO tav_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jĩcaʉ Dio ye quetire buiori majocʉre, “Dio cʉ carotiro mena ĩimi,” ĩri cʉ̃re caapi nʉcʉbʉgoʉ ũcʉre caroare cʉ joogʉmi Dio. Dio ye quetire buiori majocʉre caroare cʉ cajooro cõo caroare cʉ joogʉmi Dio, to bairo caroaro cʉ̃re cʉ caapi nʉcʉbʉgoro. To bairona caroaʉre, “Caroaʉ ãcʉmi,” ĩri canʉcʉbʉgorãre caroaro wariñuuriquere na joogʉmi Dio. Caroaʉre wariñuurique Dio cʉ cajooro cõona na joogʉmi Dio cʉ canʉcʉbʉgorã quenare. ");
INSERT INTO tav_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Noa yʉ cabuerãre ocore catĩarã quenare caroare na joogʉmi Dio, na quena yʉ yarãre petoacã cátinemorã ãma ĩi, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Doce cãnacãʉ cʉ buerãre jã cáti teñapere buio yaparo cáaácoami Jesu ti yepa macá macaripʉ, caroa quetire to macanare buio teñaʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","To bairi Juan bautisari majocʉ preso ãcʉpʉ Cristo cʉ cáti teñarijere caqueti apiyupʉ. To bairi cʉ buerãre Jesure ocõo bairo na caĩ jeniña roti jooyupʉ. To bairi: ");
INSERT INTO tav_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—“Dio joogʉmi jĩcaʉ camajare na cátinemopaʉre,” na caĩricʉ ¿mʉna mʉ ãti? ¿Apeĩ maca mani cayuupaʉ cʉ ãti? Cristore caĩ jeniñawã Juan yarã cʉ cajeniña roti jooricarã. ");
INSERT INTO tav_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","To bairo cʉ na caĩ jeniñaro: —Juan tʉpʉ tunu aánaja. Aá, yʉ cáto mʉja catʉjʉrijere, yʉ cabuioro mʉja caapirijere Juãre cʉ buiorãja, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—Ocõo bairo Juãre mʉja buiogarã: Cajʉgoye catʉjʉ majiquetana mere tʉjʉ majima. Cáaá majiquetana mere aá majima. Caajeri boatana yaticoapa. Caapi majiquetana quena api majicoapa. Aperã cabai yajiricarã anibana quena catí tunucoapa. Bopacooro cabairã caroa quetire apima yʉ cabuioro. ");
INSERT INTO tav_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","To bairi caroaro wariñuurã anigarãma yʉre caapiʉjarã, “Jocʉna ĩmi,” yʉre caĩ tʉgooñaquẽna. To bairona Juãre cʉ buiorã aája, na caĩwĩ Jesu Juan cʉ cajeniña roti jooricarãre. ");
INSERT INTO tav_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na catunu aáto bero to cãna camaja paarãacã nipetirãre ocõo bairo na caĩwĩ Jesu Juan cʉ cabairijere: —“Jõ camaja mani paʉpʉ, Juãre mani tʉjʉ aáparo,” ĩrã, ¿ñamʉ ũcʉ camajocʉre cʉ̃re mani tʉjʉgarã, mʉja caĩ tʉgooñari? Catʉgooña ocabʉtiquẽcʉ, yeru cʉ̃ oóre wino capapu wãreoro cawãre tʉjʉnucuʉre bairo cãcʉre mʉja tʉjʉra aáquetana. Catʉgooña ocabʉtii majuu ãmi Juan. ");
INSERT INTO tav_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Caroa jutii cajañaʉre topʉ camaja mani paʉpʉ mʉja tʉjʉra aáquetana. Caroa jutii cajañarã ʉparã tʉpʉ ãnama. ");
INSERT INTO tav_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To bairi, “Camaja mani paʉpʉ jĩcaʉ Dio ye quetire cabuioʉre mani tʉjʉra aágarã,” mʉja ĩ tʉgooñaricarã. Juãre tʉjʉrã aperã Dio ye quetire buiori maja ãnana na netoro cãni majuʉre Juãre mʉja catʉjʉyupa. ");
INSERT INTO tav_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tirʉmʉpʉ macana Dio ye quetire buiori maja ãnana ocõo bairo caĩ ucayupa Juan cʉ cabaipere: “Camajare na canetoo catiopaʉ jʉgoye yʉ joogʉ jĩcaʉ yʉ ye quetire cabuio jʉgoyeyepaʉre. Camajare na yerire caroaro tʉgooña quenoo yuu rotigʉmi,” caĩ ucayupa Juan cʉ cabaipere. ");
INSERT INTO tav_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cariapena mʉjaare yʉ ĩ: Aperã camaja nipetirã na netoro cãcʉ ãmi Juan. To bairo Juan cãni majuʉ cʉ cãnibato quena aperã Ʉpaʉ Dio cʉ cãnopʉ cawatoa cãna quena Juan netoro cãna anigarãma. Cʉ netoro cãna anigarãma yʉre caapirã maca ĩi, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan Dio ye quetire cʉ cabuio jʉgori paʉpʉna caapigayupa camaja Ʉpaʉ Dio cʉ cãnie quetire. Yucʉ quenare tie quetire yʉ cabuioro to bairona seeto apigama. To bairi caroorã seeto quẽrã áama, yʉre caapiʉjarãre na matagabana. ");
INSERT INTO tav_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dio ye quetire cabuioricarã tirʉmʉpʉ macana na caucarique, Moisé cʉ carotirique quenare Ʉpaʉ Dio cʉ cãnipere caĩ ucayupa Juan cʉ cãniparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","To bairi atiere mʉja caapi nʉcʉbʉgogaata ocõo bairo mʉjaare yʉ ĩ buiopa: Tirʉmʉpʉ macacʉ Dio ye quetire buiori majocʉ Elías cawamecʉcʉ tirʉmʉpʉ macacʉre bairona cãcʉ ãmi Juan. To bairi Juan cʉ cãniparo jʉgoye, “Jĩcaʉ Elías tirʉmʉpʉ macacʉre bairona cãcʉ anigʉmi,” caĩ ucayupa, Juãre cʉ ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Noa yʉre caapirã yʉ caĩ buiorijere caroaro apiʉjaya. ");
INSERT INTO tav_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Ati yʉtea macana caroa quetire apigaquẽna ocõo bairo cabairã ãma: Cawimarã macá recomaca caruirã na mena macana mena epegabana na pi awajarãma: ");
INSERT INTO tav_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Jã mena bajaya,’ ĩbana wewo jã caputi epero mʉja bajagaquẽpʉ. Tʉgooñarique pairique tõroari jã cabaja epero quena mʉja oti epegaquẽpʉ, mʉja ya wamere jã epegaquẽe ĩrã.” To bairona cawimarã, “Jã caĩri wamere jã mena epeya,” caame ĩbanare bairona baima ati yʉtea macana. Caroa quetire apigaquẽna na majuuna na caĩ tʉgooñari wamere ame ĩ netooma. ");
INSERT INTO tav_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan bautisari majocʉ caroa ʉgarique caʉgaquetinucuwĩ, ʉje oco quenare caetiquetinucuwĩ. To bairo cʉ cabairo tʉjʉrã, “Cawãticʉcʉ, catʉgooña majiquẽcʉ ãcʉmi,” cʉ caĩ epenucuwã. ");
INSERT INTO tav_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cʉ bero yʉ maca caroa macaje ʉgariquere caʉgaʉ, ʉje oco caetii yʉ ã. To bairo yʉ cabairo tʉjʉrã, “Caʉga pacaʉ, ʉje oco caeti pacaʉ ãmi Jesu,” yʉre ĩma. “Cʉ mena macana caroorã, gobierno ye cãnipere camaja yere niyeru cajeerã ãma,” yʉre ĩma. To bairo na caĩrije to cãnibato quena Dio cʉ carotiro mena yʉ caĩ buioro majigarãma camaja, caroa macajere yʉ cáto tʉjʉrã, na caĩwĩ Jesu to cãna paarãacãre. ");
INSERT INTO tav_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ape macari macana capee Jesu cʉ cáti iñoorijere tʉjʉbana quena cʉ̃re caapi nʉcʉbʉgoquẽjupa. Caroorije na cátinucurijere cajʉtiriti regaquẽjupa. To bairi ti macari macanare ocõo bairo na caĩwĩ Jesu nare yua: ");
INSERT INTO tav_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Rooro mʉja baigaro Corasín macanare, Betsaida macana quenare. Cáti iñoori wamerire Tiro macana, Sidón macana tirʉmʉpʉ macanare mʉjaare yʉ caiñooricarore bairije na yʉ cáti iñoata nemoopʉre caroorije na cátiere jʉtiritiri áti janaboricarãma. Mʉja maca caroorije mʉja cátiere mʉja áti janagaquẽe, na caĩwĩ Jesu Corasín macanare, Betsaida macanare. ");
INSERT INTO tav_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—To bairi Diore caapiʉjaquẽnare na cʉ capopiyeyeri paʉ cãnopʉ Tiro macana, Sidón macana na netoro mʉja popiyeyegʉmi Dio, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum macana quenare ocõo bairo na caĩwĩ Jesu: —“Ʉmʉrecoopʉ Dio tʉpʉ jã aágarã,” ĩ tʉgooñaquẽja. Mʉjaare regʉmi Dio maca caroorã na catamʉori paʉpʉ. Mʉjaare yʉ cáti iñoobata wamerire bairo Sodoma macana tirʉmʉpʉ macanare na yʉ cáti iñoata caroorije na cátiere áti janaboricarãma na maca. To bairi na ya macare na requetiboricʉmi Dio. Mʉja maca caroorije mʉja cátiere mʉja áti janagaquẽe. ");
INSERT INTO tav_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","To bairi cʉ̃re caapiʉjaquẽnare Dio na cʉ capopiyeyeri paʉ cãnopʉ na netoro mʉja popiyeyegʉmi Dio, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","To bairo na ĩri bero ocõo bairo caĩ wadawĩ Jesu cʉ Pacʉ Diore: —Caacʉ, mʉna mʉ ã ʉmʉrecoo Ʉpaʉ, ati yepa quenare. “Camajirã jã ã,” caĩ tʉgooñarãre yʉ cabuiorijere na caapi majiquẽto mʉ áa. Aperã macare, “Cawatoa macana jã ã, caroaro jã majiquẽe Dio yere,” caĩrã macare na caapi majiro mʉ áa na macare. To bairo na majiato ĩi na mʉ cátibojarijere tʉgooñaʉ caroaro wariñuuriquere mʉ yʉ joo, Caacʉ. ");
INSERT INTO tav_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","To bairo mʉ caboorore bairona na mʉ ájupa, caĩwĩ Jesu cʉ Pacʉ Diore. ");
INSERT INTO tav_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cabero ocõo bairo caĩwĩ Jesu camajare tunu: —Yʉ Pacʉ nipetirijere yʉ cajoowĩ yʉ cáti majipere. Yʉ cãniere majiquẽema camaja. Jĩcaʉna ãmi Dio yʉ cãniere camajii. Yʉ Pacʉ cʉ cãnie quenare majiquẽema camaja. Jĩcaʉna yʉ ã cʉ cãniere camajii. Noa cʉ cãniere na yʉ camajioata na quena majigarãma yʉ Pacʉ cʉ cãniere, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Paari maja o canʉcʉrijere caumarã quena seeto na capopiye tamʉorore bairona mʉja bai, mʉja yeripʉre tʉgooñarique paibana. To bairi mʉja nipetirã cayeri tʉgooñarique pairã yʉ tʉpʉ atí, yʉ cabuiorijere apiri apiʉjaya. To bairo mʉja cáto tʉgooña tutuariquere mʉjaare yʉ joogʉ. ");
INSERT INTO tav_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉ ya wame, yʉ caboorijere ája. “Seeto carotii yʉ ã,” caĩi mee yʉ ã. Camajare cabopaca tʉjʉʉ aniri tutuaro yʉ rotiquẽe. To bairi yʉ ya wamere mʉja cáti ʉjaro yerijã tʉgooña wariñuuriquere mʉjaare yʉ joogʉ. ");
INSERT INTO tav_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Popiye me ã yʉ ya wame. To bairi yʉ yere mʉja cáti ʉjaro tʉgooñarique paiquẽnana caroaro mʉja anigarã. Apeye canʉcʉquẽtiere caumarãre bairo mʉja anigarã, yʉre apiʉjarã, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ti rʉmʉri cãno jã judío maja yerijãrica rʉmʉ cãno trigo wejeri recomacapʉ Jesu cʉ buerã mena jã caneto aápʉ. Wejeri recomacapʉ neto aána caapere jã cajee ʉga nutuapʉ, ñigo riabana. ");
INSERT INTO tav_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","To bairo jã cajee ʉga neto aáto tʉjʉrã fariseo maja Jesure ocõo bairo cʉ caĩwã: —Mʉ buerã mani judío majare cáti rotiquetajere áama. Yerijãrica rʉmʉ sábado to cãnibato quena weje macajere jeema. ");
INSERT INTO tav_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","To bairo cʉ na caĩro ocõo bairo na caĩwĩ Jesu: —Ʉpaʉ David tirʉmʉpʉ macacʉ cʉ mena macana mena jĩca rʉmʉ ñigo riabana na cátajere mere mʉja bue tʉgaricarã. ");
INSERT INTO tav_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dio wiipʉ jãari ʉgarica rupaa, “Dio ye ã,” na caĩriquerena topʉ capejarijere ʉga, cʉ mena macana quenare na canuñupʉ sacerdote maja jeto na caʉganucurije cãnibato quenare. Aperãre David jãare na caʉga rotiquetaje cãnibajupe. ");
INSERT INTO tav_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ape wame quenare mani carotiriquepʉ ocõo bairo Moisé cʉ caĩ ucariquere mʉja bue tʉgaricarã mere: Sacerdote majare yerijãrica rʉmʉ cãno Dio wii macaje paa rotirique ã. To bairi yerijãrica rʉmʉ cãno yerijãquẽnama, Dio wii macajere paabana. To bairo yerijãrica rʉmʉ na capaabato quena caroorije me ã narã. ");
INSERT INTO tav_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","To bairi yucʉacã Dio wii macaje netoro cátipe ã ape wame macare. Yʉ jʉgori cʉ cáti rotiri wame macare cátipe ã. ");
INSERT INTO tav_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ocõo bairi wame Dio Wadariquepʉ na caĩ ucarica wame quenare tʉgooñañajate: “Aperãre mʉja cabopaca tʉjʉro yʉ boo. Waibʉcʉrãre mʉja cajoe buje mʉgo jooro macare yʉ booquẽe,” ĩ ucarica wame ã. Tiere mʉja catʉgooña majiata, yʉ buerã weje macaje oteacãre caʉgarãre, “Caroorije áama,” na mʉja ĩquetiborã. ");
INSERT INTO tav_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉa camaja tʉpʉ Dio cʉ cajooricʉ aniri yerijãrica rʉmʉ cãno cátipere carotii yʉ ã, na caĩwĩ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cabero na neñapo buerica wiipʉ cáaámi Jesu. ");
INSERT INTO tav_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti wiipʉ eja, jĩcaʉ cawamo rooye tuaricʉre catʉjʉwĩ. To bairi to cãna, “Caroorije áami Jesu, cʉ̃re capopiyeyepe ã,” ĩ wadajãgarã ocõo bairo cʉ caĩ jeniñawã: —¿Mani judío majare yerijãrica rʉmʉ cãno cariarãre netoo catio rotirique to ãti? ");
INSERT INTO tav_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","To bairo cʉ na caĩ jeniñaro: —Noa mʉja oveja nuricarã cacʉgorã jĩcaʉ opepʉ cʉ caña roca jã aápata cʉ mʉja ne buuborã yerijãrica rʉmʉ to cãnibato quena. ");
INSERT INTO tav_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","To bairi oveja netoro cátinemope ã camajocʉ macare. To bairi yerijãrica rʉmʉ to cãnibato quena camajocʉre caroa wame cʉ cátinemope ã, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","To bairo na ĩ, cawamo rooye tuaricʉre: —Mʉ wamore ñupoya, cʉ caĩwĩ. To bairo Jesu cʉ̃re cʉ caĩrona cʉ wamore cañupowĩ. Cʉ cañuporona cañuucoapʉ caroa wamo ape nʉgoare bairona yua. ");
INSERT INTO tav_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","To bairo cabairijere tʉjʉrã fariseo maja buti aá, dope bairo Jesure na cajĩapere caame wadapeniñuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","To bairo fariseo maja cʉ̃re na cajĩagarijere camajiwĩ Jesu. To bairi topʉ cãnacʉ aperopʉ cáaácoami. Camaja capãarã cʉ̃re caʉjawã. Na nipetirã cariaye cʉnare na cacatiowĩ. ");
INSERT INTO tav_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na catioʉ, “Aperãre, ‘Dio cʉ cajooricʉ ãmi,’ na ĩ buioqueticõaña yʉre,” na caĩwĩ Jesu camajare. ");
INSERT INTO tav_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","To bairo ĩri Dio ye quetire buiori majocʉ Isaía tirʉmʉpʉ macacʉ ocõo bairo cʉ caĩ ucarica wamere bairo cámí Jesu: ");
INSERT INTO tav_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Cʉ̃re yʉ cũwʉ yʉ yere cátibojapaʉre. Yʉ camaii ãmi. Cʉ mena yʉ wariñuu. Yʉ Espíriture cʉ yʉ joogʉ. To bairi ape poari, ape yepari macanare na queti buiogʉmi. “Mʉja cátajere cariape tʉjʉ bejegʉmi Dio,” ĩ buiogʉmi. ");
INSERT INTO tav_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aperãre caawaja tutiquẽcʉ anigʉmi. Caroaro camajare cabuioʉ aniri aperãre awaja tutiquetigʉmi. ");
INSERT INTO tav_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Catʉgooña tutuaquẽnare tutiquetigʉmi. Tʉgooña tutuarique macare na joogʉmi. Dio cʉ caboorijere jĩabʉjana cáti ocabʉtirãre caroaro na átinemogʉmi. Cabero caroorãre cʉ canetoro bero cariape cʉ carotirije anigaro. ");
INSERT INTO tav_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","To bairi ape poari to cãnacã yepa macana na quena ati yepapʉ cʉ carotipere tʉgooña yuuri, cʉ apiʉjagarãma. To bairije caucayupi Isaía tirʉmʉpʉ macacʉ Jesu cʉ cabaipere buio jʉgoyeyei. ");
INSERT INTO tav_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Cabero aperã Jesu tʉpʉ cʉ caneamá jĩcaʉ cawãti cʉcʉre. Catʉjʉ majiquẽcʉ, cawada majiquẽcʉ cãmi. To bairo cʉ tʉpʉ na caneató tʉjʉʉ Jesu cʉ canetoowĩ. To bairo Jesu cʉ canetoorona mere cawada majiwĩ, catʉjʉ majiwĩ yua. ");
INSERT INTO tav_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","To bairo cawãti cʉtacʉ cʉ cañuuro tʉjʉrã to cãna paarãacã tʉjʉ acʉari: —¿Ani David pãramipʉ cãcʉ jĩcaʉ joogʉmi Dio na caĩricʉna cʉ anicʉti? caame ĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","To bairo Jesure camaja na caame ĩ jeniñarijere apirã fariseo maja maca: —Wãtiare na buunucuʉmi Jesu wãtia ʉpaʉ Sataná, Beelsebú na caĩi cʉ carotiro mena, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","To bairo cʉ̃re na catʉgooña nʉcʉbʉgoquẽtiere camajiwĩ Jesu. Tiere majiri ocõo bairo na caĩwĩ: —Jĩca majana ame quẽrã na majuuna ame reborãma. To bairona jĩca maca macana, o jĩca wii macana na majuuna ame tuti, ame quẽ bairã ani majiquẽnama. ");
INSERT INTO tav_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","To bairona Sataná cʉ majuuna cʉ yarãre wãtiare cʉ caquẽ acu buu reata cʉ wapanare bairona tʉjʉboʉmi Sataná cʉ yarãre. To bairi cʉ carotirã aniquetiborãma. ");
INSERT INTO tav_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","To bairi jocarã majuu yʉre mʉja ĩ tʉgooña, Sataná cʉ carotiro mena wãtiare na buu remi yʉ ĩrã. Mʉja ya wamere cabuerã jĩcaarã na quena wãtiare na buu rema. “Dio cʉ carotiro mena buu rema,” mʉja ĩnucurã. To bairi mʉja yarã quena, “Jocarãna ĩma,” mʉja ĩgarãma, “Sataná cʉ carotiro mena wãtiare na buu remi Jesu,” yʉre mʉja caĩro. ");
INSERT INTO tav_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","To bairi Dio Espíritu Santo cʉ carotiro mena wãtiare na yʉ buu renucu. To bairo na yʉ cabuu rero, “Dio yere carotii ãcʉmi,” yʉre caĩparã mʉja anibajupa. To bairi mani Ʉpaʉ Dio popiyeyegʉmi mʉjaare, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ape wame buio majiorica wame quenare ocõo bairo na caĩ buiowĩ Jesu, Sataná netoro catutuaʉ cʉ cãniere na ĩ buioʉ: —Jĩcaʉ seeto catutuaʉ caquẽ ocabʉti majii ya wiire aperã cʉ yere emagarã cʉ ya wiipʉre jãa majiquẽema, cʉ uwibana. Cʉ quẽ netogarã, cʉ yere emagarã jʉgoye cʉ̃re jia tu cũborãma, na caĩwĩ Jesu, Satanáre canetoo majii yʉ ã, na ĩ buioʉ. ");
INSERT INTO tav_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ocõo bairo na caĩnemowĩ Jesu: —Yʉ mena cãnigaquẽna yʉre catʉjʉ tutirã ãnama. Yʉre caapiʉjaquẽna yʉ cabuiorijere camatarã ãnama. ");
INSERT INTO tav_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","’To bairi cariape ocõo bairo mʉjaare yʉ ĩ: Caroorije to cãnacã wame camaja na cátaje, caroorije na caĩrije quenare majiriorique ã. Yʉ quenare camaja tʉpʉ Dio cʉ cajooricʉre caroorije camaja yʉre na caĩrije quenare majiriorique ã. Dio Espíritu Santo macare caroorije na caĩro majirioquetigʉmi Dio. Ati yʉtea cãno quena, ati yepare cʉ cawajoaro bero cãnipa yʉtea quenare majirioquetigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Jĩcaʉ yucʉ rica tʉjʉrã tii ã mani ĩ wameye maji yucʉre. Yucʉ caroaʉ caroa ricacʉto. Yucʉ carooricʉ maca caroorije jeto ricacʉto. ");
INSERT INTO tav_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","To bairona mʉja quena yucʉ carooricʉre bairona mʉja bai. Caroare mʉja ĩ buio majiquẽna, caĩto pairã, caroorã aniri. Camaja na yeripʉre na catʉgooñari wame cõona wadanucuma. ");
INSERT INTO tav_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","To bairi caroaʉ maca cʉ yeripʉ caroare tʉgooñari caroa macajere wadagʉmi. Apeĩ carooʉ maca cʉ yeripʉ caroorije tʉgooñari caroorije wadagʉmi. ");
INSERT INTO tav_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","To bairi cariape mʉjaare yʉ ĩ buio. Caroorãre Dio na cʉ capopiyeyeri rʉmʉ cãnopʉ to cãnacã wame caroorije na caĩriquere na jeniñagʉmi Dio. “¿Ñeere ĩrã mʉja caĩri?” na ĩ jeniñagʉmi. ");
INSERT INTO tav_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","To bairi cañuurijere mʉja caĩ wadaro, “Cañuurã mʉja ã,” mʉja ĩgʉmi Dio. Caroorije macare mʉja caĩata, “Caroorã mʉja ã,” mʉja ĩri, mʉja popiyeyegʉmi Dio, na caĩwĩ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cabero jĩcaarã judío majare cabuerã, fariseo maja mena ocõo bairo Jesure cʉ caĩ jeniñawã: —Ʉpaʉ, áti iñoorica wame ája, “Dio cʉ cajooricʉ ãcʉmi,” mʉre jã caĩ majiparore bairo, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","To bairo cʉ na caĩro: —Ati yʉtea macana caroorã ãma, “Áti iñoorica wamere jã iñooña,” ĩrã. Nare yʉ áti iñooquẽe. Jĩca wamerena na yʉ iñoogʉ, Jonás cawamecʉcʉ Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ cʉ cabairiquere mʉjaare ĩ buioʉ. ");
INSERT INTO tav_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pairi ya macacʉ wai capaii Jonáre cʉ caʉga rocaro cʉ paro pupeapʉ cãñupʉ Jonás itia rʉmʉ, itia ñami. To bairona yʉ baigʉ. Yʉ, camaja tʉpʉ Dio cʉ cajooricʉ yepa pupeapʉ yaa rocaricʉpʉ yʉ anigʉ. ");
INSERT INTO tav_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonás tirʉmʉpʉ macacʉ Dio ye quetire Nínive macana cãniñaricarãre na cʉ cabuioro caroorije na cátiere jʉtiriticõari cajanañañuparã yua. Yʉ maca Jonás netoro cãcʉ yʉ cãnibato quena yʉ cabuiorijere mʉja apiʉjaquẽe. Caroorijere mʉja cátiere mʉja tʉgooñaquẽe, mʉja janagaquẽe. To bairi caroorãre Dio na cʉ capopiyeyeri paʉ cãnopʉ Nínive macana tirʉmʉpʉ macana, “Rooro mʉja caapiʉjaquẽjupa,” mʉja ĩgarãma ati yʉtea macanare. ");
INSERT INTO tav_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","To bairona caroorãre Dio na cʉ capopiyeyeri paʉ cãnopʉ Saba cawamecʉti yepa ʉpao tirʉmʉpʉ macaco ati yʉtea macanare, “Rooro majuu mʉja caapiʉjaquẽjupa,” mʉja ĩgomo. Cayoaropʉ macaco cáajupó Salomón, Israel macana ʉpaʉ cʉ cabuio majirijere apigo. Yʉ maca Ʉpaʉ Salomón tirʉmʉpʉ macacʉ netoro camajii yʉ cãnibato quena yʉre mʉja apigatee, na caĩwĩ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ocõo bairo na caĩnemowĩ Jesu fariseo majare: —Jĩcaʉ wãti camajocʉpʉre cabuti weoricʉ ñee mano, ria manopʉ aáteñaʉ aácoaʉmi cʉ cãniparore macaʉ aácʉ. Bʉgaquetibacʉ ocõo bairo ĩ tʉgooñaʉmi: ");
INSERT INTO tav_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Yʉ cabuti aáweoepaʉ tʉpʉna yʉ tunu aágʉ tunu,” ĩ tʉgooñaʉmi. To bairi cʉ yeripʉ caroaro owaricaro, quenoo cũricarore bairo, caʉpaʉ mácʉpʉre cʉ bʉga ejaʉmi. ");
INSERT INTO tav_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","To bairo cʉ cabairo tʉjʉʉ aperã wãtia siete cãnacãʉ cʉ netoro caroorã quenare na pijo átiri na menapʉna, cʉ cabuti aáweoricʉre jãa, anicõaʉmi. To bairo caroorã majuu wãtia capãarã cʉ mena na cãno cajʉgoye cʉ cãnibatato netoro rooro bai nutuami. To bairona rooro ani nutuagarãma ati yʉtea macana, yʉre booquetibana, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","To cãna paarãacãre cʉ cabuio yaparoquẽtona mai cʉ paco, cʉ bairã eja, macapʉ catuanʉcawã, cʉ mena wadapenigarã. ");
INSERT INTO tav_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","To bairi apeĩ: —Mʉ paco, mʉ bairã mʉ mena wadapenigarã macapʉ tʉjʉnucuma, cʉ caĩwĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","To bairo cʉ caĩro: —¿Dico yʉ paco, di maja yʉ bairã yʉ catʉgooña tʉjʉrã na ãti? na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","To bairi jãre cʉ buerãre ñu puari: —Ati maja ãma yʉ paco, yʉ bairã majuu yʉ catʉgooña tʉjʉrã. ");
INSERT INTO tav_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Noa yʉ Pacʉ ʉmʉrecoo macacʉ cʉ caboorijere cána yʉ bairã, yʉ bairã romiri, yʉ pacore bairona yʉ catʉgooña tʉjʉrã ãma, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti rʉmʉna ti wii cãnacʉ cabutiwĩ Jesu. Buti, ʉtabʉcʉra tʉna aá, topʉ caruiwĩ. ");
INSERT INTO tav_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Topʉ cʉ caruiro camaja capãarã cʉ tʉpʉ caneñapowã. To bairi capãarã majuu cʉ tʉna na cãno tʉjʉʉ, yʉ tu ne rocarema ĩi cumua petapʉ turorica capajaricare eja jãa, caruiwĩ. To bairi camaja petapʉ catʉjʉnucurãre na caĩ buiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Topʉ na ĩ buio, capee wame na caĩ buiowĩ buio majiorica wameri mena. Ocõo bairo na caĩ buiowĩ Jesu petapʉ catʉjʉnucurãre: —Jĩcaʉ camajocʉ cʉ ya wejepʉ caote aácoajupʉ. Topʉ eja, cʉ oterique trigo apeariacãre cayaye bate oteyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","To bairi cʉ cayaye bate oterique jĩca rupaa ma tʉpʉ caroca cumuñupe. To bairi minia ti rupaare tʉjʉ rui atí, caʉga recõañuparã. ");
INSERT INTO tav_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Ape rupaa ʉ̃ta yepapʉ care cumuñupe cajita manibʉjaropʉ. To bairi jita põreroacã cãno nʉcoo joo majiqueti, caputibataje muipu cʉ caajiro cajini recoajupe. ");
INSERT INTO tav_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ape rupaa cʉ cayaye bate oterique pota yucʉ watoapʉ care cumuñupe. To bairi ti apeari caputibatajere pota yucʉ maca cabʉcʉa netocoajupe. To bairi cʉ caoterique maca caroaro cabʉcʉaquẽjupe. To bairi carica mañupe. ");
INSERT INTO tav_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ape rupaa care cumuñupe tunu caroa yepapʉ. To bairi tie caroaro puti, bʉcʉa, caroaro carica cʉticoajupe. To bairi jĩca rupaa cajooyupe cien rupaa. Ape rupaa rʉgabʉjaroacã sesenta rupaacãre cajooyupe. Apeye tunu treinta rupaacã carica cʉjupe. ");
INSERT INTO tav_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Noa yʉre caapirã yʉ caĩrijere caroaro na apiʉjaato, na caĩ buiowĩ Jesu cumuapʉ ruiri petapʉ catʉjʉnucurã paarãacãre yua. ");
INSERT INTO tav_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Cabero Jesu buerã cʉ tʉpʉ aá, cʉ̃re jã caĩ jeniñawʉ: —¿Nope ĩi buio majiorica wameri mena na mʉ buioti camajare? ");
INSERT INTO tav_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","To bairo cʉ̃re jã caĩ jeniñaro ocõo bairo jã caĩwĩ Jesu: —Ʉpaʉ cʉ cãnie quetire majioʉ áami Dio mʉjaare cajʉgoyepʉ camajare na cʉ camajioquetajere. Aperã maca api majirique maama. Na majioquẽemi Dio. ");
INSERT INTO tav_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","To bairi noa yʉ cabuiorijere caapiʉjarãre capee api majiriquere mʉja joogʉmi Dio. Aperã maca yʉ cabuiorijere caapiʉjagaquẽna yʉ yere na caapi majibatajeacã quenare na catʉgooña mawijiaro na átigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","To bairi na maca yʉ cátiere tʉjʉ, yʉ cabuiorijere api, baibana quena api puoquẽema. To bairi buio majiorica wameri mena na yʉ buionucu. ");
INSERT INTO tav_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","To bairi ocõo bairo Isaía tirʉmʉpʉ macacʉ Dio ye quetire cʉ cabuioñarica wamere bairona baima: Apibana quena yʉ cabuiorijere api majiquetigarãma. Yʉ cátie tʉjʉbana quena yʉ yere caapi puoquẽna aninucucõagarãma. ");
INSERT INTO tav_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na majuuna yʉ yere tʉgooñagaquẽema. To bairi api puoquẽema. Yʉ ye quetire api, yʉ cátiere tʉjʉ, na cabairije to cãnibato quena caapi majiquẽna, catʉjʉ majiquẽnare bairona baima. To bairi na yeripʉ caapi majiquẽna aniri, “Caroorije jã cátie jã janagarã, caroaro catiriquere jã jooya,” yʉ ĩ jeniquẽema, caĩ ucayupi Isaía ati yʉtea macanare na ĩ buio jʉgoyeyei, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Mʉja maca cawariñuurã mʉja anigarã, yʉre caapiʉjarã aniri. Yʉ cátiere tʉjʉrã yʉ cãniere mʉja maji. Yʉ cabuiorijere apirã yʉ caĩrijere mʉja api puo. ");
INSERT INTO tav_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cariape mʉjaare yʉ ĩ: Dio ye quetire buiori maja, aperã caroarã tirʉmʉpʉ macana yucʉacã mʉjaare yʉ caiñoorijere catʉjʉgabajuparã. Mʉjaare yʉ cabuiorije quenare caapigabajuparã. Na cabaigabato quena na camajioquẽjupi Dio maca. ");
INSERT INTO tav_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Wejepʉ trigo apearire caotericʉ cʉ cabairique mʉjaare yʉ buio majiopa, jãre caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","—Jĩcaarã Ʉpaʉ Dio cʉ cãniere apibana quena api majiquẽema. Sataná na yeripʉ atí, na caapibatajere ema jee aá rericarore bairo nare áami, na majiritiato ĩi. Ma tʉ cañarique minia na caʉga reriquere bairona cãna ãma camaja to bairo cabairã. ");
INSERT INTO tav_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aperã ʉ̃ta yepa jita põreroacã cãni yepapʉ care cumuriquere bairona cabairã ocõo bairo ãma Dio Wadariquere jĩacã caapirã: Caroa quetire nemoona caroaro api wariñuuma mai. ");
INSERT INTO tav_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Api wariñuubana quena jita põreroacã cãno canʉcori maniere bairona na majuuna yoaro apiʉjaquẽema yʉ cabuiorijere. To bairi aperã yʉ ye quetire na caapibataje wapa nare na capopiyeyero yoaro mee janama. ");
INSERT INTO tav_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ape rupaa oterique pota yucʉ watoapʉ care cumuriquere bairo cabairã ocõo bairo cãna ãma: Yʉ ye quetire apibana quena, ati yepa macaje macare seeto tʉgooñama. To bairi apeye pairo majuu na cacʉgope tʉgooñarã, “Tiere cʉgorã jã wariñuu anigarã,” jocarãna tʉgooñabama. To bairo ati yepa macaje na cátie apeye uniere na caboo netorije tʉgooñabana yʉ ye queti macare majiritima. To bairi pota yucʉ watoapʉ cañarique carica manore bairona yʉ caboorijere átiquẽema. ");
INSERT INTO tav_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aperã caroa yepapʉ cañariquere bairona baima. Yʉ yere api, tiere apiʉjari caroaro api majima. Jĩcaarã treinta rupaa carica cʉtajere bairona cabairã ãma yʉ caboorijere cána aniri. Aperã tunu netobʉjaro caroaro yʉ yere cána sesenta rupaa carica cʉtajere bairona ãma. Aperã tunu na netoro caroaro majuuna yʉ yere ána cien rupaa carica cʉtajere bairona baima, jã caĩ buiowĩ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ape wame queti buio majiorica wame caĩ buiowĩ Jesu tunu: —Ʉpaʉ Dio camajare cʉ cabejepe ocõo bairo ã: Jĩcaʉ cʉ wejepʉ caroa jetore trigo caoteyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cabero cʉ ʉmʉa na cacanitoye apeĩ cʉ̃re catʉjʉ tutii atí, caroorije trigore bairo cabaurije cayajioropʉ caoteyupʉ trigo watoapʉna. Cayajioropʉ ote yaparo cáaácoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cabero trigo maca puti, bʉcʉa, carica cʉtigari paʉ cʉ paari maja caroorije trigo watoapʉ cabʉcʉarije quenare catʉjʉyuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Caroorijere tʉjʉrã, weje ʉpaʉ tʉpʉ aá, cʉ caĩñuparã: “Jãre carotii, caroa aperi jetore mʉ otericʉ. ¿Nope ĩro caroorije trigo watoapʉna to putiyupari?” cʉ caĩñuparã nare carotiire. ");
INSERT INTO tav_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","To bairo cʉ na caĩro apii, “Jĩcaʉ yʉre catʉjʉtei majuu tie caroorijere otericʉmi,” na caĩñupʉ weje ʉpaʉ. To bairo na cʉ caĩro: “¿Caroorijere jã wʉgue rerãati?” cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Wʉgue requẽja. Mʉja cawʉgue reata trigo jĩca turori quenare mʉja wʉgue reborã caroorije menana. ");
INSERT INTO tav_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trigo caroorije menana to bʉcʉato mai. Cabero trigo jeerica paʉ cãno jeeri majare ocõo bairo na yʉ ĩgʉ: ‘Trigore jeegarã jʉgoye caroorijere jeeya. Caroorijere jee, carupa rotori jiari, joe recõaña. Joe re yaparo trigo macare jee, ʉgarique cũrica wiipʉ cũña,’ na yʉ ĩgʉ cajeeri majare,” caĩñupʉ weje ʉpaʉ cʉ ʉmʉare. To bairona ã mani Ʉpaʉ Dio camajare cʉ cabejepe, caĩwĩ Jesu. Jocarãna, “Diore caapiʉjarã jã ã,” caĩrãre Dio na cʉ carepe, cariapena cʉ̃re caapiʉjarã macare cʉ tʉpʉ cʉ cajee aápere ĩ buioʉ, to bairo caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ape wame queti buio majiorica wame na caĩ buiowĩ Jesu tunu: —Ʉpaʉ Dio cʉ cãnie queti ocõo bairo ã: Jĩcaʉ mostasa na caĩrije caapeacãre caoteyupʉ cʉ ya wejepʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tie ape maca õqueacã majuu ã. Õqueacã majuu anibato quena bʉcʉatopʉ apeye wejeri macaje netoro caʉmʉari yucʉ aápá. To bairi minia atí, tii rʉpʉripʉ na batirire peoma. To bairona ã Ʉpaʉ Dio cʉ cãnie queti ape wame netoro, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Cabero ape wame queti buio majiorica wamere caĩ buiowĩ Jesu: —Ʉpaʉ Dio cʉ cãnie queti ocõo bairo ã: Jĩcao pan átigo trigo pocare itia bapa cõoñari tiepʉre levadura na caĩrijere caajuyupo, to wauato ĩo. To bairo co caajuro pan cãnipe ti bʉrʉa nipetiro cawauayupe. To bairona tie cawauorije ti bʉrʉare átatore bairona Ʉpaʉ Dio cʉ cãnie queti jejagaro ati yepa nipetiropʉ. To bairi Diore caapiʉjarã ani nutuapa ti bʉrʉa cawauarore bairona, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","To bairi camaja paarãacãre na ĩ buioʉ, queti buio majiorica wameri mena jeto na caĩ buiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","To bairo jeto na ĩ buiori tirʉmʉpʉ macacʉ Dio ye quetire buiori majocʉ ocõo bairo cʉ caĩ ucañarica wamere bairona cájupi Jesu: Camajare buioʉ, queti buio majiorica wameri mena na yʉ buiogʉ. Nemoopʉre Dio ati ʉmʉrecoore áti jʉgóʉpʉ camajare na camajioquẽjupi mai. Yucʉra camajare na yʉ buiogʉ, caĩ ucayupi Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ, Jesu cʉ cabaipere buio jʉgoyeyei. ");
INSERT INTO tav_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cabero Jesu camaja paarãacãre na aáweori, wiipʉ cajãa ejawĩ. Cʉ cajãa ejaro tʉjʉrã cʉ buerã cʉ tʉpʉ atí, ocõo bairo cʉ jã caĩwʉ: —Caroorije trigo watoapʉ oterique mepʉ mʉ cabuioe wame ¿dope ĩgaro to ĩti? Jãre buioya, jã caĩwʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","To bairo cʉ jã caĩro ocõo bairo jã caĩ buiowĩ Jesu: —Caroa macajere caotericʉ yʉna yʉ ã, camaja tʉpʉ Dio cʉ cajooricʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Weje ati yepa nipetiro ĩgaro ĩ. Oterique caroa maca trigo ĩgaro ĩ Ʉpaʉ Dio cʉ cãni paʉ cãniparã. Caroorije caputirique Sataná yarã ãma ĩgaro ĩ. ");
INSERT INTO tav_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nare cacũricʉ yʉre catʉjʉ tutii ãmi Sataná, caroorije caputiriquere caotericʉre bairona. Trigo jeerica yʉtea ĩgaro ĩ ati ʉmʉrecoo capetiri paʉ majuu. Trigo jeeri majare yʉ caĩata Dio tʉ macanare ángel majare na yʉ ĩ. ");
INSERT INTO tav_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","To bairi caroorije na cajee joe reriquere bairona na átigʉmi Dio caroorãre ati ʉmʉrecoo capetiri paʉ cãnopʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","To bairi yʉ, camaja tʉpʉ Dio cʉ cajooricʉ aniri Dio tʉ macanare ángel majare na yʉ joogʉ yʉ carotiri paʉ nipetiropʉ. “Dio cʉ carotirijere cátiquẽnare, aperãre caroorijere cáti wadajã pairã quenare na jee peocõaña,” na yʉ ĩ joogʉ ángel majare. ");
INSERT INTO tav_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ángel maja nare na cajee yaparoro peropʉ na yʉ regʉ. Topʉ na yʉ carero seeto majuu tamʉobana tʉgooñarique pai otigarãma. ");
INSERT INTO tav_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","To bairo cabairi paʉ cariape cána caroarã maca mani Ʉpaʉ Dio cʉ carotiri paʉpʉ anicõagarãma. Muipu cʉ caaji baterore bairona caaji baterã anigarãma na quena. Noa yʉ yere caapirã caroaro na apiʉjaato, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ocõo bairo caĩnemowĩ Jesu tunu: —Ʉpaʉ Dio cʉ cãnie pairo cawapacʉtie niyeru cuirire yepapʉ yaa cũ yajioriquere bairona bai. Jĩcaʉ tiere bʉga, tona yaa cũcõaʉmi tunu. Wariñuurique mena aá, cʉ apeyere nipetirije aperãre na nuni, niyerure jee átiri, ti cuirire pairo cawapacʉtie niyeru cuiri cacuñari yepare wapayeimi yua tie niyeru cʉ cayaa cũrique macare cʉgogʉ. Tiere bairona pairo majuu cawapacʉtie ã Ʉpaʉ Dio cʉ cãnie. ");
INSERT INTO tav_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ape wame Jesu ocõo bairo caĩwĩ tunu, Ʉpaʉ Dio tʉpʉ mani cãnipere pairo cawapacʉtie ã, ĩ buioʉ: —Jĩcaʉ apeye wapayeri majocʉ perla na caĩrije caroa caajiyari rupaarire camaca teñaʉ aájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Maca teñaʉ jĩca caroa majuu pairo cawapa cʉtiare catʉjʉyupʉ aperã tʉpʉ. To bairi tiare boʉ nipetiro cʉ apeyere aperãre na nuni, niyerure jee, tiare cawapayeyupʉ, caĩwĩ Jesu, Dio ye macaje pairo cawapacʉtie ã ĩ buioʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ape wame caĩwĩ Jesu tunu: —Dio camajare na cʉ cabejepe ocõo bairo ã: Aperã capairi yapʉ wai wajarã na bapire caroca ñua jooyuparã. To bairo na cáto wai capãarã to cãnacã wame cajãañuparã. ");
INSERT INTO tav_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","capãarã na cajãaro tʉjʉrã cawemoñuparã paputiropʉ. Wemo yaparo cabeje ruiyuparã yua. Caroarã jetore cajee jãañuparã ape piipʉ. Caroorã maca carecõañuparã. ");
INSERT INTO tav_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","To bairona átigarãma Dio tʉ macana ángel maja ati ʉmʉrecoo capetiri paʉ cãnopʉre. To cãnacã poa macana tʉpʉ aáti, caroarã watoapʉ cãna caroorãre na bejegarãma. ");
INSERT INTO tav_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Caroorãre na beje, peropʉ na regarãma. Topʉ nare na carero seeto majuu tamʉobana tʉgooñarique pai otigarãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","To bairije buio yaparo: —¿Tiere mʉja api puoti? jã caĩ jeniñawĩ Jesu. —Ʉ̃ʉjʉ, jã api puo, jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","To bairo jã caĩro: —Jĩcaarã judío majare cabuerã Dio yere yʉ cabuiorijere na caapiʉjaata pʉga wame aperãre na buio majigarãma: Tirʉmʉpʉre Dio ye quetire caĩ buiorã na caĩ ucarique quenare, yucʉacã Dio ye quetire yʉ cabuiorije quenare aperãre na buio majiogarãma, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Atie queti buio majiorica wamerire buio yaparo cáaácoami Jesu cʉ cabʉcʉarica macapʉ. ");
INSERT INTO tav_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cʉ cabʉcʉarica macapʉ aá, topʉ eja, na ya wii neñapo buerica wiipʉ Dio Wadariquere na cabuiowĩ. To bairo na cʉ cabuiorijere apirã catʉgooña acʉawã to macana: —Camajocʉ manire bairona cabaii anibacʉ quena seeto majuu majimi. ¿Noopʉ atie caroaro cʉ cabuio majirijere cʉ camajiñupari? ¿Dope bairo majuu bairi áti iñooriquere cʉ cáti majiñupari? caame ĩwã. ");
INSERT INTO tav_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—Cʉ yarãre, cʉ cabairiquere mani maji peticõa. Yucʉ pãiri mena apeye uniere cátacʉ José ãnacʉ Macʉ ãmi. Cʉ paco María cawamecʉco ãmo. Cʉ bairã Jacobo, José, Simón, Juda cawamecʉna ãma. ");
INSERT INTO tav_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Cʉ yarã romiri quena mani ya macapʉ ãma. To bairi camajocʉ manire bairona anibacʉ quena ¿dope bairo tiere cʉ majibaupari? caame ĩwã Jesu cʉ cabʉcʉarica maca macana. ");
INSERT INTO tav_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","To bairo ame ĩrã cʉ caapi nʉcʉbʉgoquẽma. To bairo cʉ na caapi nʉcʉbʉgoquẽto tʉjʉʉ ocõo bairo na caĩwĩ Jesu: —Dio ye quetire buiori majocʉ aperopʉ cʉ cabuio teñaro to macana cʉ api nʉcʉbʉgorãma. Cʉ ya maca macana macare na cʉ cabuioro cʉ api nʉcʉbʉgoquẽnama, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","To bairi cʉ cabʉcʉarica macapʉ capee áti iñoorica wamerire cátiquẽmi cʉ̃re na caapi nʉcʉbʉgoquẽto maca. ");
INSERT INTO tav_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti paʉ cãno Jesu cʉ cabairijere cʉ caĩ buioyuparã aperã Herode Galilea yepa ʉpaʉre. ");
INSERT INTO tav_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","To bairo cʉ na caĩ buiorijere api, cʉ yere cacotebojari majare ocõo bairo na caĩñupʉ: —Juan bautisari majocʉ ãnacʉ ãcʉmi Jesu. Mani cajĩa rocaepaʉ anibacʉ quena cacati tunuricʉ ãcʉmi. To bairi cacati tunuricʉ aniri áti iñoorica wamerire áti majiimi, na caĩñupʉ Herode Jesu cʉ cabairijere apiri. ");
INSERT INTO tav_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Cajʉgoyepʉna Juãre cʉ cañe rotiyupʉ Herode cʉ polisía majare. Cʉ ñe roti, presopʉ come wẽri mena na cajiaricʉpʉ cʉ cajooyupʉ, Juan cʉ̃re cʉ cabuionucurijere apigatei. Cajʉgoye cʉ bai Felipe nʉmo cãnibatacore Herodía cawamecʉcore caneñupʉ Herode maca. ");
INSERT INTO tav_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","To bairo cʉ bai nʉmore cʉ canero tʉjʉri ocõo bairo cʉ caĩ buionucubajupʉ Juan: “Ñuuquẽe mʉ bai nʉmore mʉ canero. Cõre canequetipaʉ mʉ anibajupa.” To bairo Juan cʉ caĩnucurije wapa to cõona Herode polisíare cañe rotiyupʉ Juãre. ");
INSERT INTO tav_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nemoona polisíare cʉ cajĩa rotigabajupʉ. Camaja, “Dio ye quetire buiori majocʉ ãcʉmi Juan,” cʉ̃re caĩ tʉgooñawã. To bairi, “Cʉ̃re yʉ cajĩa rotiata camaja yʉre punijini tʉjʉborãma,” ĩ tʉgooñari camajare na cauwiyupʉ Herode. ");
INSERT INTO tav_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cabero Herode cʉ cabuiarica rʉmʉ cãno boje rʉmʉ cájupʉ. Ti boje rʉmʉ cãno Felipe nʉmo cãnibataco Herodía maco cabajao wiajupo, Herode cʉ capiricarã jãa yʉre na tʉjʉato ĩo. Co cabajarijere Herode seeto catʉjʉ wariñuuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","To bairo co cabajarijere seeto tʉjʉ wariñuuri: —Noo yʉ mʉ cajenigari wamere mʉ yʉ joogʉ, jocʉ mee yʉ ĩ, co caĩñupʉ Herode. ");
INSERT INTO tav_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","To bairo cõre cʉ caĩro co pacore co cajeniñañupo. Jeniña yaparo Ʉpaʉ Herodere ocõo bairo cʉ caĩñupo: —Juan bautisari majocʉ rʉpoare na pa ta rotiya. Na pa ta rotiri jotʉ bapapʉ peori yʉ jooya, cʉ caĩñupo Herodía maco, co paco co cajeni rotiro mena. ");
INSERT INTO tav_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","To bairo co caĩro apii seeto catʉgooñarique paiyupʉ Herode, Juãre cʉ jĩagaquetibacʉ. To bairo tʉgooñabacʉ quena, “Yʉ ya boje rʉmʉ cãno yʉ capiena yʉ ĩ eperema cõre yʉ caĩ cũri wamere yʉ cátiquẽpata,” ĩ tʉgooñari co cajeniri wamere cáti rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","To bairo cʉ carotirona aperã Juãre cʉ rʉpoa cʉ capa ta jĩa rocacõañuparã presopʉ cãcʉre. ");
INSERT INTO tav_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pa ta jĩa, cʉ rʉpoare jotʉ bapapʉ peo, Herodía macore cajooyuparã. Cõre na cajooro co pacore cajoo netojoñupo tunu. ");
INSERT INTO tav_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cabero Juan ãnacʉ cʉ cabuericarã atí, cʉ rupaʉ ãnatore ne aá, cʉ cayaa rocayuparã. Cʉ yaa roca yaparo Jesure cʉ cabuiora aájuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","To bairo Juãre na cajĩa rocariquere queti apii cumua mena cáaácoami Jesu aperopʉ camaja mani paʉpʉ. Cʉ cáaáto queti apirã camaja capãarã macaa macana cõo cʉ caʉja aáma mapʉ. ");
INSERT INTO tav_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","To bairi Jesu topʉ roca tu, ma eja, na paarãacãre na catʉjʉwĩ. Na tʉjʉri, na cabopaca tʉjʉwĩ. Na mena cãna cariarãre na cacatiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","To bairi ñamicaa muipu cʉ cãni aáti paʉ cãno cʉ buerã cʉ tʉpʉ aá, cʉ jã caĩwʉ: —Mere ñamicaapʉ ã. Maca maa atora. To bairi camajare na aá rotiya. Macaapʉ na wapaye ʉgara aáparo, jã caĩbapʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","To bairo cʉ jã caĩro: —Na aáqueticõato. Mʉja majuuna na nuña, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Pan rupaare jĩca wamo cõo nare jã canubopere, wai pʉgarã jetore jã cʉgo camaja capãarã majuure na jã canuboparãacãre, jã caĩwʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","To bairo cʉ jã caĩro: —Atopʉ jee ajá, jã caĩwĩ Jesu. To bairo jã cʉ caĩro cʉ tʉpʉ jã cajee apʉ́. Jee atí, Jesure jã cajoowʉ tie ʉgariqueacãre. ");
INSERT INTO tav_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","To bairi Jesure cʉ jã cajooro bero ta caroa yepapʉ camajare na carui rotiwĩ Jesu. Na rui roti, jĩca wamo cõo cãnacã ʉgarica rupaare, wai pʉgarãre jee átiri ʉmʉrecoopʉre tʉjʉ mʉgo, Diore jeni nʉcʉbʉgo, ʉgariquere pe, jãre cabate joowĩ cʉ buerãre. Jã maca camajare jã cabate joowʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","To bairo camajare jã cabate jooro caʉga yapi peticoama. Na caʉga yapicoato bero Jesu buerã jã cajee jãwʉ piiripʉ na caʉga rʉgarijere doce wʉri majuu jirari wʉri. ");
INSERT INTO tav_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","To bairi tiere caʉgaricarã cãma jĩca wamo cãnacã mil caʉmʉa jeto. Cãromia, cawimarã quenare na cacõoñaquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tie bero cʉ buerãre cumuapʉ jã caeja jãa rotiwĩ Jesu. “Camajare na yʉ catʉjʉ tʉja jootoye yʉ jʉgoye i nʉgoa peña aá yuuya,” jã caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","To bairi camaja paarãacãre na tʉjʉ tʉja joo yaparo cawamʉ aájupi ʉ̃taʉpʉ, Diore jeni nʉcʉbʉgoʉ aácʉ. Canaiori paʉ topʉna cãnicõañupi mai jĩcaʉna. ");
INSERT INTO tav_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Cʉ cabuerã maca ti ñami cumuapʉ cáaána cayoaropʉ ti ra recomaca jã capeña aáto seeto oco cajabewʉ, wino seeto uwioro capapu rocaturo maca. ");
INSERT INTO tav_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cabujuparo jʉgoyeacã Jesu oco bui cáatí nutuami, jã tʉpʉ acʉ́. ");
INSERT INTO tav_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","To bairo oco bui cʉ cáató tʉjʉrã seeto jã catʉjʉ acʉacoapʉ. —¡Jĩcaʉ camajocʉ ãnacʉ wãti ãcʉmi! jã caĩ awaja acʉacoapʉ. To bairo jã caĩ awajaro: ");
INSERT INTO tav_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","—Uwiqueticõaña. Yʉna yʉ ã mʉja ʉpaʉna. Tʉgooña uwi acʉaquẽja, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","To bairo jã cʉ caĩro ocõo bairo cʉ caĩwĩ Pedro: —Mʉna mʉ cãmata mʉ tʉpʉ oco bui yʉ aá rotiya. ");
INSERT INTO tav_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","To bairo Jesure cʉ caĩro: —Baiyupa adʉja, Pedrore cʉ caĩwĩ Jesu. To bairo cʉ caĩro Pedro cumuapʉ cajañaricʉ rui, oco bui cáaábami, Jesu tʉpʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","To bairo aábacʉna wino seeto capapurijere tʉjʉ acʉa, cauwiwĩ. To bairo uwi, caruacoa rui nutuami. Ruacoacʉ yʉ áa ĩi: —¡Ʉpaʉ, yʉre ñei ajá, rua yajii yʉ bai! caĩ awajawĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","To bairo Pedro cʉ caĩ awajaro Jesu cʉ cañewĩ. Cʉ̃re ñe: —Jĩacã majuu yʉre mʉ tʉgooña nʉcʉbʉgo. ¿Nope ĩi, “Yajicoa aácʉ yʉ áa,” mʉ ĩ tʉgooñari? caĩwĩ Jesu Pedrore. ");
INSERT INTO tav_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","To bairi cumuapʉ na caeja jãaro wino capapu janacoapʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jã maca cumuapʉ cãna Jesure nʉcʉbʉgori rʉpopatua mena tuatu ejacumu eja: —Cariapena Dio Macʉna mʉ ã, cʉ̃re jã caĩ nʉcʉbʉgowʉ. ");
INSERT INTO tav_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jã capeña aápʉ yua. Peña aá, ape nʉgoapʉ eja, Genesaret na caĩri yepapʉ jã cama ejawʉ. ");
INSERT INTO tav_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","To bairo ti paʉpʉ jã cama ejaro tʉjʉrã, “Jãaa, mere Jesu ejami,” caame ĩ buiowã to macana camaja. To bairi Jesu cʉ caejarijere queti apirã ti yepa macanare cabuio batecõa joowã, mani yarã cariarãre Jesu tʉpʉ na jee aparo ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","To bairi cariarãre cʉ tʉpʉre cajee ejawã. To bairi cariarã maca ocõo bairo cʉ caĩwã Jesure: —Mʉ jutiiro yapa jetore jã pañagarã. To bairo pañarã jã netogarã, caĩ jeniwã Jesure. To bairi nipetirã cariarã cʉ jutiiro yapa catʉjarore capañarã canetoowã yua. ");
INSERT INTO tav_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cabero jĩcaarã fariseo maja, aperã judío majare cabuerã Jerusalẽpʉ cãnana atí, Jesu tʉpʉ eja, ocõo bairo cʉ caĩ jeniñawã: ");
INSERT INTO tav_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nope ĩrã mʉ buerã mani ñicʉa na cáti rotiriquere na átiquẽeti? Wamo cojequẽema ʉgagarã jʉgoye, cʉ caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","To bairo cʉ na caĩro ocõo bairo na caĩwĩ Jesu: —Mʉja roque mʉja cátinucurije ána Dio cʉ carotirica wamere mʉja átiquẽe. ");
INSERT INTO tav_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dio ocõo bairo carotiyupi: “Mʉja pacʉare na nʉcʉbʉgoya. Noa una na pacʉare rooro na caĩrãre na cajĩa repe ã.” ");
INSERT INTO tav_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mʉja maca ti wamere mʉja bai netoonucu, ocõo bairo mʉja pacʉare caĩrã aniri: “Atie niyerure mʉjaare yʉ joo majiquẽe. Dio ye cãnipe ã, cʉ̃re yʉ cajoope. To bairi mʉjaare yʉ átinemo majiquẽe,” mʉja pacʉare jocarãna na mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mʉja majuuna mʉja ye niyerure maibana, to bairo na mʉja ĩtonucu. To bairi nare átinemogaquetiri nare canʉcʉbʉgoquẽna mʉja ã. To bairo ĩ tʉgooñabana Dio cʉ carotirica wamere mʉja bai netoonucu. “Mʉja pacʉare na nʉcʉbʉgoya,” Dio cʉ carotirica wamere mʉja bai netoonucu, na átinemoquẽnana. ");
INSERT INTO tav_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Caroare cána jã ã,” jocarã mʉja ĩ. Tirʉmʉpʉ Dio ye quetire buiori majocʉ ãnacʉ cariape mʉja cabaipere ocõo bairo caĩ ucañañupi: ");
INSERT INTO tav_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ati maja, “Diore camairã jã ã,” ĩbana quena na yeripʉ yʉ tʉgooña nʉcʉbʉgoquẽema. ");
INSERT INTO tav_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","To bairi jocarãna, “Diore cáti nʉcʉbʉgorã jã ã,” ĩma naa. Na majuuna na catʉgooñari wamerena, “Atie Dio cʉ carotirique ã,” ĩbana na ya wame macare áti nʉcʉbʉgoma. Ti wame Isaía ãnacʉ cʉ caĩ ucariquere bairona mʉja bai, caĩwĩ Jesu fariseo majare, judío majare cabuerã quenare Jerusalẽpʉ cãnana Jesu tʉpʉ caejaricarãre. ");
INSERT INTO tav_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","To bairo na ĩ yaparo camajare na pi neopo, ocõo bairo na caĩ buiowĩ Jesu: —Caroaro yʉ apiya, yʉ yere majigarã. ");
INSERT INTO tav_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Camaja na majuuna roorije na yeripʉ na catʉgooñarije jʉgori caroorã ãma. Na ʉgarique macaje jʉgori mee caroorã ãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","To bairo cʉ caĩro bero cʉ buerã jã cáaápʉ cʉ tʉbʉjaacã. Cʉ tʉpʉ aá, ocõo bairo cʉ jã caĩwʉ: —To bairo mʉ caĩro fariseo maja mʉ api tutima, Jesure jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","To bairo jã caĩro ocõo bairo queti buio majiorica wame jã caĩ buiowĩ Jesu: —Jĩcaʉ weje ʉpaʉ caroorije cawatoana to majuuna caputirije cʉ caotequẽtiere wʉgue reimi. To bairona na áti regʉmi yʉ Pacʉ ʉmʉrecoo macacʉ ape wame cãni jocari wame macare cabuerãre. ");
INSERT INTO tav_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","To bairi na tʉgooñaquẽja fariseo majare. To bairona na anicõato. “Aperãre cabue majirã jã ã,” jocarã majuu ĩma. Catʉjʉ majiquẽna aperã catʉjʉ majiquẽnare catʉ̃ga jʉ́go aánare bairona baima. Jĩcaʉ catʉjʉ majiquẽcʉ apeĩ catʉjʉ majiquẽcʉre cʉ catʉ̃ga jʉ́go aápata opepʉ re jãacoaborãma na pʉgarãpʉna, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","To bairi Pedro ocõo bairo cʉ caĩwĩ Jesure: —Mʉ cabuioe wame ¿dope bairo ĩgaro to ĩti? cʉ caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","To bairo cʉ caĩro ocõo bairo jã caĩ buiowĩ Jesu: —¿Mʉja quena caapi majiquẽna mʉja anicõati? ");
INSERT INTO tav_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nipetirije camaja na caʉgari wame cõo paropʉ eja, to cõona yajicoa. ");
INSERT INTO tav_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ape wame maca camaja na yeripʉ caroorije tʉgooña, tiere wada, bairã caroorã ani nutuapa yua. ");
INSERT INTO tav_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Camaja na yeripʉ na catʉgooñari wame cõo caroorije áama. Aperãre jĩama. Áti epericarã cʉgoma. Aperã yere jee rutima. Ĩto paima. Aperãre caroorije wada paima. ");
INSERT INTO tav_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","To bairije áama camaja, to bairona na yeripʉ caroorije catʉgooñarã aniri. To bairi caroorã ani nutuapa. Ʉgagarã jʉgoye wamore cojequetaje maca camaja caroorã na cãno átiquẽe. ");
INSERT INTO tav_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Cabero ti yepa Genesarépʉ cãnacʉ cáaácoami Jesu tunu ape yepapʉ Tiro, Sidón cawamecʉti macaa cãni yepapʉ. ");
INSERT INTO tav_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Topʉ cʉ caejaro to macaco cananea yao Jesu tʉpʉ atí, baujaro Jesure cʉ caĩ jeniwõ: —¡Ʉpaʉ! ¡Yʉ bopaca tʉjʉya! “David tirʉmʉpʉ macacʉ pãramipʉre jĩcaʉre cʉ joogʉmi Dio,” na caĩricʉna mʉ ã. Yʉ maco wãti cʉtibaco seeto tamʉomo, cʉ caĩ jeniwõ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","To bairo baujaro majuu co caĩ jenirije to cãnibato quena co cayʉquẽmi Jesu. To bairi jã cʉ buerã cʉ tʉpʉ atí: —Co aá rotiya. Seeto baujaro jeni patowãcoomo, cʉ jã caĩcõawʉ Jesure yua. ");
INSERT INTO tav_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","To bairi cajeniore co caĩwĩ Jesu: —Dio yʉ cajoowĩ Israel maja jetore oveja nuricarã cayajiricarãre bairo cabairã tʉpʉ, Diore camajiritiricarã tʉpʉ, co caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","To bairo cõre cʉ caĩbato quena cʉ tʉpʉ atí, mubia cumu nʉcʉbʉgo: —Ʉpaʉ, yʉ átinemoña, cʉ caĩwõ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","To bairo co caĩro: —Aperã Israel maja cãniquẽnare yʉ cátinemoro cawimarã ye ʉgariquere na emari yaiare nare nuʉre bairo yʉ átiboʉ, co caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","To bairo co cʉ caĩro: —Ʉpaʉ, cariape mʉ ĩ mʉa. To bairo yaiare cawimarã ye ʉgariquere cajooquetipe to cãnibato quena na ʉparã na caʉga ruiri cajawa ẽoro caña rerijere ʉgama yaia. To bairo ĩo, yʉ quena apeo yʉ cãnibato quena Israel majare na átinemo yaparoʉ petoacã yʉ quenare yʉ átinemoña ĩo, caĩwõ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","To bairo co caĩro ocõo bairo co caĩwĩ Jesu: —Mʉa caroaro majuu, “Yʉ átinemogʉmi,” yʉre mʉ caĩ tʉgooña nʉcʉbʉgowʉ. To bairi mʉ caboori wamere bairona to baiato, co caĩwĩ Jesu. To bairo co cʉ caĩri paʉna cañuucoajupo co maco yua. ");
INSERT INTO tav_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Topʉ cãnacʉ Jesu cáaámi Galilea na caĩri ra tʉpʉ. Eja, ʉ̃taʉ buipʉ aá, topʉ caruiwĩ. ");
INSERT INTO tav_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Topʉ cʉ cáaáto camaja capãarã cʉ tʉpʉ caejawã. To bairi na yarãre cʉ tʉpʉ cajee ejoowã cariaye cʉnare, cáaá majiquẽnare, cawamori ñuuquẽnare, catʉjʉ majiquẽnare, cawada majiquẽnare, aperã capãarã cariarãre Jesu tʉpʉ cajee ejoowã. To bairo Jesu cʉ tʉpʉ na cajee ejoorãre na cacatiowĩ. ");
INSERT INTO tav_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","To bairi cawada majiquẽnare na cawada majiro cámí. Cawamori ñuuquẽnare na caquenoowĩ. Cáaá majiquẽna quenare na cáaá majiro cámí. Catʉjʉ majiquẽna quenare na catʉjʉ majiro cámí. To bairona Jesu na cʉ canetoo catioro camaja cʉ tʉpʉ caejarã catʉjʉ acʉacoama. Tʉjʉ acʉari, “Dio Israel maja na cáti nʉcʉbʉgoʉ caroaro majuu áami,” Diore caĩ wariñuuwã. ");
INSERT INTO tav_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","To bairi cʉ buerãre cʉ tʉ maca jã capi neowĩ Jesu. Jã pi neo, ocõo bairo jã caĩwĩ: —Ati maja paarãacãre na yʉ bopaca tʉjʉ. Yʉ mena itia rʉmʉpʉ ãma. Na ʉgarique peticoapa mere. To bairi caʉgaquẽnare na yʉ aá rotigaquẽe, ñigo riabana mapʉ mecʉ ñarema ĩi. ");
INSERT INTO tav_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","To bairo jã cʉ caĩro: —Ati paʉ cañee mani paʉ ã. To cõo camaja capãarã na cãno majuure na mani canupe máni majuucõa, jã caĩwʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","To bairo cʉ jã caĩro: —Ʉgarica rupaa, ¿noo cãnacã majuu to ãti? jã caĩ jeniñawĩ Jesu. —Siete rupaa majuu ã, wai jĩcaarãacã ãma, jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","To bairi Jesu camajare yepapʉre na carui rotiwĩ. ");
INSERT INTO tav_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na rui roti, Diore cʉ jeni nʉcʉbʉgo, ʉgariquere pe, jã cabate joowĩ jãre cʉ buerãre. Jã maca camajare jã cabate joowʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","To bairi to cãna nipetirã caʉga yapicoama. Ʉga yapiri bero na caʉga rʉgarijere cajee jã jiroowã siete wʉri majuu. ");
INSERT INTO tav_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","To bairi tiere caʉgaricarã caʉmʉa jetore cacõoñawã bapari cãnacã mil majuu, cãromia, cawimarã na cõoñaquẽnana. ");
INSERT INTO tav_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","To bairi camajare tʉjʉ tʉja joo, cumuapʉ eja jãa, Magdala na caĩri yepapʉ cáaámi Jesu yua. ");
INSERT INTO tav_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Magdala na caĩri yepapʉ cʉ cãno Jesure catʉjʉra ejawã fariseo maja, saduceo maja tunu. ¿Cariape cãniqueti wame Jesu cʉ ĩbocʉti? ĩrã, ocõo bairo caĩwã Jesure: —Dio ʉmʉrecoo macacʉ cʉ cáti iñoo majiri wamere bairona jã áti iñooña, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","To bairo cʉ na caĩro: —Ʉmʉrecoo cajũa roca jã aáto tʉjʉrã: “Bujiyʉ caroa rʉmʉ anigaro,” mʉja ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cabujuri paʉ cãno tunu, “Oco ñiibʉja. To bairi oco rʉmʉ anigaro,” mʉja ĩrã. Caroaro mʉja tʉjʉ majirã caocape quenare, caajipe quenare ʉmʉrecoopʉre tʉjʉri. To bairo majibana quena ati rʉmʉrire Dio cʉ cátiere mʉja tʉjʉ majiquẽe. ");
INSERT INTO tav_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ati yʉtea macana rooro áama, “Áti iñoorica wamere jã iñooña,” ĩrã. Na yʉ áti iñooquẽe. Jĩca wamerena na yʉ iñoogʉ Jonás cawamecʉcʉ tirʉmʉpʉ macacʉ cʉ cabairiquere buioʉ, na caĩwĩ Jesu. To bairo na ĩ, cáaácoami Jesu. ");
INSERT INTO tav_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cabero Jesu, cʉ buerã ʉtabʉcʉra ape nʉgoapʉ jã cáaápʉ tunu. Jã caʉgape jã cajee aáquẽpʉ, majiritibana. ");
INSERT INTO tav_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","To bairo jã camajiritiriquere jã cawadapeniro apiri ocõo bairo jã caĩwĩ Jesu: —Caroaro tʉgooña majiña. Fariseo maja, saduceo maja na ya wame pan to wauato ĩrã levadura na caĩrije tiepʉ na caajurijere caroaro tʉjʉ majiri tiere átiquẽja, jãre caĩbami. ");
INSERT INTO tav_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To bairo cʉ caĩrijere api majiquetibana: —Pan mani caʉgape mani cajee atíquẽto ĩi to bairona manire ĩimi, jã caame ĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","To bairo jã caame ĩrijere majiri, ocõo bairo jã caĩwĩ Jesu: —¿Nope ĩrã, “Pan mani caʉgapere mani cajee atíquẽto ĩi to bairona manire ĩimi,” yʉre mʉja ame ĩti? Caroaro yʉre mʉja tʉgooña nʉcʉbʉgoquẽe, mʉja caʉgapere tʉgooñarique paibana. ");
INSERT INTO tav_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mʉjaare yʉ cátinemoro mʉja majiriticoati? Jĩca wamo cãnacã mil caʉmʉa, na nʉmoa romiri, na punaa mena cãma jĩca wamo cãnacã pan rupaa mena na yʉ canuricarã. ¿To bairona yʉ cátiepere mʉja tʉgooñaquẽeti? ¿Noo cõo cãnacã wʉ mʉja cajee jã jiroori na caʉga rʉgariquere? jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—Ape paʉ to bairona bapari cãnacã mil na nʉmoa romiri, na punaa mena cãma siete rupaa pan rupaa mena na yʉ canuricarã. ¿Ti wame yʉ cátaje quenare mʉja majiquẽeti? ¿Noo cõo cãnacã wʉ mʉja cajee jã jiroori na caʉga rʉgariquere? ");
INSERT INTO tav_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ti paʉri yʉ cátajere tʉgooñarã, “Jã caʉgape ĩri mee,” ĩimi mʉja caĩ tʉgooña majipe nibapa. To bairi fariseo maja, saduceo maja na ya wame pan cawauorijere átiquẽja, yʉ caĩrijere api majiña, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","To bairije jã cʉ caĩ buioro to cõona, “Pan macajere ĩri mee jã ĩ buiomi,” jã caĩ majicoapʉ. “Fariseo maja, saduceo maja jocarãna camajare na cabuerijere, caroaro tʉgooña majiri na ya wame átiquetiri tiere apiʉjaqueticõaña,” ĩi, jã caĩwĩ. Na ya wamere jã caapiʉjaata pan cawauorije pan cãnipa bʉrʉare to cátore bairo jã quena cariape cãniqueti wamere catʉgooñarã jã aniborã. ");
INSERT INTO tav_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cabero Césarea Filipo na caĩropʉ cáaámi Jesu. Topʉ eja, cʉ buerãre ocõo bairo jã caĩ jeniñawĩ: —¿Camaja yʉ cabairijere wadapenirã ñamʉ majuu cʉ̃ ãcʉmi, camaja yʉre na ĩnucuti? jã caĩ jeniñawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","To bairo jãre cʉ caĩ jeniñaro: —Jĩcaarã, “Juan camajare cabautisaricʉ cajĩa ecooricʉ yucʉacã cacati tunuricʉ ãcʉmi,” mʉre ĩma. Aperã, “Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ Elías cawamecʉcʉ catunu ejaricʉ maca ãcʉmi,” mʉre ĩma. Aperã tunu, “Jeremía cawamecʉcʉ o apeĩ Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ cacati tunuricʉ ãcʉmi,” mʉre ĩma, cʉ jã caĩwʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","To bairo cʉ jã caĩro: —Mʉjaate ¿ñamʉ ãcʉmi yʉre mʉja ĩti? jã caĩ jeniñawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","To bairo jãre cʉ caĩ jeniñaro: —Tirʉmʉpʉ macana, “Camaja tʉpʉ joogʉmi Dio jĩcaʉ cãni majuʉre,” na caĩricʉna mʉ ã. Dio to cãnacã rʉmʉ cãnicõa aninucuʉ Macʉna mʉ ã, cʉ caĩwĩ Pedro Jesure. ");
INSERT INTO tav_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","To bairo Pedro cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Simón, Jonás macʉ, to bairo yʉ mʉ caĩrije yʉ cabairije aperã camaja mʉre majioquetanama. Yʉ Pacʉ ʉmʉrecoo macacʉna mʉ majioñupi. To bairi wariñuurique majuu mʉ joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ocõo bairi wame cariape mʉ yʉ ĩ: Pedro mʉ ã. Mʉ wame “ʉ̃taa” ĩgaro ĩ. To bairi yʉ mʉ caĩri wame ʉ̃taa capairica cayaji majiquẽtore bairona yajiquetigaro. To bairona yʉ anicõa yʉ mʉ caĩrore bairona. To bairi ʉ̃taʉ cayajiquẽtore bairona yʉre caapiʉjarã, yʉ ya poa macana yʉ cacũparã to cãnacã rʉmʉ anicõa aninucugarãma. To bairi Sataná yarã yʉ ya poa macanare nare na caregarije to cãnibato quena nare netoquetigarãma. Yʉ ya poa macana riacoabana quena to cãnacã rʉmʉ anicõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","To bairi mʉ yʉ cũgʉ Ʉpaʉ Dio cʉ cãnopʉ jope pãrique ʉpaʉre bairo cãnipaʉ. To bairo cãcʉ ati yepa ãcʉna, “Atie Dio ʉmʉrecoo macacʉ cʉ carotiquẽtie ã.” Ape wame macare, “Atie Dio cʉ carotirije ã,” Diore caĩbojaʉ mʉ anigʉ, caĩwĩ Jesu Pedrore. ");
INSERT INTO tav_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","To bairo Pedrore cʉ ĩ, cʉ buerã nipetirã ocõo bairo jã caĩwĩ Jesu: —Aperãre, “Tirʉmʉpʉ macana Dio joogʉmi jĩcaʉ Cristo na caĩpaʉre na caĩricʉna ãmi Jesu,” aperãre na ĩ buioqueticõaña yʉre, jã caĩwĩ cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti paʉ cãno ape wame ocõo bairo cʉ buerãre jã caĩ buio jʉgó nutuami Jesu: —Jerusalẽpʉ cáaápaʉ yʉ ã. Topʉ capee wameri yʉ tamʉogʉ cabʉcʉrã camajare carotirã, sacerdote maja ʉparã quena, judío majare cabuerã quena yʉre na capopiyeyero. Yʉre jĩa rocacõagarãma. To bairo yʉ na cátibato quena itia rʉmʉ bero yʉ tunu catiogʉmi Dio, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","To bairo jã cʉ caĩ buioro Pedro aperobʉjaacã cʉ cane aámi. Aperobʉjaacã cʉ ne aá, ocõo bairo cʉ caĩ buioyupʉ: —¡Ʉpaʉ, to bairo mʉ caĩeje to baiqueticõato! To bairo mʉ átiqueti majuucõagarãma, cʉ caĩ buiobajupʉ Pedro maca Jesure. ");
INSERT INTO tav_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","To bairo cʉ caĩro Jesu Pedrore cʉ amojore tʉjʉ: —¡Sataná, yʉre aáweoya! caĩñupʉ. Pedro Sataná cʉ caĩgari wame cʉ caĩro ĩi to bairo caĩwĩ Jesu. To bairi: —Dio yʉre cʉ cáti rotiri wame yʉ cátiere camata paii mʉ ã, caĩwĩ Pedrore. —Dio cʉ caboorijere mʉ tʉgooñaquẽe. Camaja na caboorije macare mʉ tʉgooña mʉa, caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","To bairo Pedrore cʉ ĩ, ocõo bairo jã caĩwĩ cʉ buerã nipetirãre: —Noa yʉ mena macana anigarã na majuuna na caboorijere na tʉgooñaqueticõato. Dio cʉ caboorije macare na áparo. Aperã yucʉ tẽorica pãipʉ nare na cajĩagarije to cãnibato quena Dio cʉ caboorijere na áparo. ");
INSERT INTO tav_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","To bairi noa, “Yʉ majuuna yʉ caboorije yʉ átigʉ,” caĩrã Dio tʉpʉ to cãnacã rʉmʉ catirique bʉgaquetigarãma. Aperã maca na majuuna na caboorije átiquetiri yʉ caboorije macare cána caroa ãnaje bʉgagarãma. ");
INSERT INTO tav_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","To bairi jĩcaʉ ati yepa macaje nipetiri wame cõo caroare cʉgo, cʉ yeri maca Sataná tʉpʉ aá, cʉ cabaiata ñuuquetiboro. Cʉ yeri Sataná tʉpʉ cáaáquetipere wapaye majiquetiboʉmi, ati yepa macaje nipetiro cʉ cacʉgorije to cãnibato quena. ");
INSERT INTO tav_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","To bairi yʉ camaja tʉpʉ Dio cʉ cajooricʉ aniri yʉ tunu atígʉ. Yʉ Pacʉ cʉ caaji baterije mena, cʉ tʉ macana mena yʉ tunu atígʉ. Ti paʉ cãno camaja to cãnacãʉre ati yepa ãnapʉ na cátaje cõona cõoñari na yʉ joogʉ na cátaje wapa. Yʉre caapiʉjaquetana macare na yʉ popiyeyegʉ. ");
INSERT INTO tav_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cariape mʉjaare yʉ ĩ. Bai yajigarã jʉgoye Ʉpaʉ yʉ cãniere mʉja tʉjʉgarã atona cãna jĩcaarã. ");
INSERT INTO tav_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis cãnacã rʉmʉri bero jĩcaʉ ʉ̃taʉ caʉmʉaricʉpʉ cáaámi Jesu. Pedro, Jacobo, cʉ bai Juan na jetore na cajee aámi cʉ mena. ");
INSERT INTO tav_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tiipʉ ãnaa cʉ̃re na catʉjʉrona cʉ cabaurije cawajoayupe. Cʉ riya muipu caajiire bairona caaji bateyupe. Cʉ jutii quena seeto cabotirije cajĩa bujuyupe. ");
INSERT INTO tav_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","To bairo cʉ cabairi paʉna nemoo Jesu mena wadapenirã cabuia nʉcañuparã Elías, Moisé jãa tirʉmʉpʉ macana. ");
INSERT INTO tav_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","To bairo cabairije tʉjʉʉ ocõo bairo Jesure cʉ caĩñupʉ Pedro: —Ʉpaʉ, atopʉ mani cãno ñuu majuucõa. To bairi itia wiiacãre yʉ nʉcogʉ mʉ cabooata. Mʉ ya wii cãnipa wii, Moisé cʉ cãnipa wii, Elías ya wii yʉ nʉcogʉ, cʉ caĩbajupʉ Pedro Jesu macare. ");
INSERT INTO tav_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","To bairije Pedro cʉ cawada ãnona bujeri bʉrʉa caajiya bateri bʉrʉa rui atí, na cajĩa buju bate biacoajupe. Tie bujeri bʉrʉapʉ ocõo bairo caĩ wadarijere caapiyuparã: —Ani yʉ Macʉ, yʉ camaii ãmi. Seeto cʉ mena yʉ wariñuu. Cʉ cabuiorijere caroaro apiʉjaya, caĩ wadarijere caapiyuparã. ");
INSERT INTO tav_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","To bairo caĩ wadarijere apirã yepapʉ camubia cumucoajuparã. Seeto cauwiyuparã cʉ buerã. ");
INSERT INTO tav_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","To bairo na cabairo Jesu atí, na paña: —Wamʉnʉcaña. Uwiquẽja, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","To bairo cʉ caĩro apirã catʉjʉyuparã. Na catʉjʉro Jesu jeto cãñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","To bairi ʉ̃taʉpʉ cãnana carui aájuparã. Na carui aáto ocõo bairo na caĩñupʉ Jesu: —Aperãre mʉja catʉjʉejere na ĩ buioquẽja. Yʉ, camaja tʉpʉ Dio cʉ cajooricʉ yʉ cãnibato quena yʉre jĩa rocagarãma. To bairi cabai yajiricʉ cãnacʉ yʉ catunu catiro bero aperãre na mʉja ĩ buiogarã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","To bairo na cʉ caĩro: —¿Nope ĩrã judío majare cabuerã, “Dio cʉ cajoopaʉ majuu jʉgoye Elías ãnacʉ tunu atígʉmi,” na ĩti? cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","To bairo na caĩ jeniñaro: —Cariape ĩma. Elías cʉ cáatípena cãñupa Dio yʉre cʉ cajooparo jʉgoye. Camajare na cayeri quenoo jʉgoyeyepaʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ocõo bairo maca mʉjaare yʉ ĩ: Elías ãnacʉ caejatʉgawĩ mere. Cʉ caejabato quena camaja tirʉmʉpʉ macana, “Elías atígʉmi,” na caĩricʉ Juãre, “Cʉna ãmi,” cʉ caĩ tʉjʉ majiquẽma. Na caboorije maca cʉ cájuparã, cʉ jĩarã. To bairona yʉ quenare yʉ popiyeyegarãma, caĩñupʉ Jesu cʉ buerãre ʉ̃taʉ buipʉ carui aánare. ");
INSERT INTO tav_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","To bairo cʉ caĩro to cõona, “Elías tirʉmʉpʉ macacʉ ĩi, Juan camajare bautisari majocʉ ãnacʉrena ĩmi,” caĩ majiñuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","To bairi camaja capãarã na cãnopʉ carui ejawã. Na caejaro jĩcaʉ Jesu tʉpʉ atí, ejacumu eja, ocõo bairo cʉ caĩwĩ: ");
INSERT INTO tav_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ʉpaʉ, yʉ macʉre cʉ bopaca tʉjʉya. Ria mecʉ baimi ñama riaye mena. To bairo ria mecʉbacʉ nairoacã peropʉ roca joe aánucumi. Ape paʉri ocopʉ roca ñua mecʉnucumi. Seeto majuu tamʉomi. ");
INSERT INTO tav_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉ cabuerã tʉpʉ cʉ yʉ ne aábapʉ. Cʉ netoo catio majiquẽma. ");
INSERT INTO tav_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","To bairo cʉ caĩro ocõo bairo jã caĩwĩ Jesu cʉ buerãre: —Caroaro yʉre mʉja api nʉcʉbʉgoquẽe. Cariape mʉja tʉgooñaquẽe. Yoaro mʉjaare yʉ caĩ buiobato quena mʉja api majiquẽe. Ani cʉ macʉre yʉ tʉpʉ cʉ neajá, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","To bairi cʉ̃re jã caneapʉ́. Cʉ̃re jã caneató tʉjʉʉ wãti cʉ mena cãcʉre cʉ cabuti aá rotiwĩ Jesu. To bairo cʉ caĩrona nemoo wãti camajocʉ macʉ mena cãnacʉ cabuticoami yua. ");
INSERT INTO tav_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cabero Jesu buerã aperobʉjaacã aperã na caapiquẽtopʉ cʉ tʉpʉ aá: —¿Dope ĩrã wãti cʉ mena cãcʉre jã buu majiquẽjupari? cʉ jã caĩ jeniñawʉ. ");
INSERT INTO tav_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","To bairo cʉ jã caĩ jeniñaro: —Dio mʉjaare cʉ cátinemopere tʉgooña nʉcʉbʉgoquetibana wãtire cʉ̃re mʉja buu majiquẽjupa. Cariape mʉjaare yʉ ĩ: Õcoacã maca Dio cʉ cátiboja majirijere mʉja catʉgooña nʉcʉbʉgoro quena noo cátipa wameri cõo mʉja áti majigarã. Icʉ ʉ̃taʉre, “Ato cãnacʉ jõ maca aátoja,” mʉja caĩata quenare aáboro. ");
INSERT INTO tav_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ati wame wãtia macare buti rotigarã Diore seeto cajenipe ã. Ʉgaquẽnana Diore cajeni nʉcʉbʉgope ã. To bairo mʉja cabaiquẽpata butiquetigarãma ati wame una wãtia yua. ");
INSERT INTO tav_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ape rʉmʉ Galilea yepapʉ Jesu mena jã cáaáteñaro ocõo bairo jã caĩwĩ: —Aperã yʉre ñecõari yʉ joogarãma yʉre cajĩaparãre. To bairi yʉre na cajĩa rocarije to cãnibato quena itia rʉmʉ bero yʉ tunu catigʉ. ");
INSERT INTO tav_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","To bairo cʉ buerãre jã cʉ caĩro apirã jã catʉgooñarique paiwʉ. ");
INSERT INTO tav_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaupʉ Jesu mena jã cáaápʉ yua. Topʉ jã caejaro Pedro tʉpʉ caejawã Dio wii macaje cãnipe camaja yere niyerure cajeerã. Eja: —¿Mʉjaare cabuei Dio wii macaje cãnipere cʉ wapa jooquẽeti? Pedrore cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Ʉ̃ʉjʉ, wapayeimi, na caĩwĩ Pedro. Cabero Pedro wiipʉ jãa, Jesure niyerure cʉ cajeniñagabami Dio wii macaje nare cʉ cajoopere. Cʉ cajeniñaquẽtopʉna ocõo bairo cʉ caĩwĩ Jesu: —¿Dope bairo mʉ tʉgooñati, Simón? Maca ʉparã niyerure jenirã ¿ni majare na jeniti? ¿Na punaare o aperã macare na jeniti? cʉ caĩ jeniñawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","To bairo cʉ caĩ jeniñaro: —Aperã macare jeninucurãma, cʉ caĩwĩ Pedro. —Cariape mʉ ĩ, cʉ caĩwĩ Jesu. —To bairi ʉparã punaa niyerure cajeniquetipe ã. To bairona yʉ quena Dio Macʉ yʉ cãno Dio ya wii macajere cajeniquetipe nibapa yʉre. ");
INSERT INTO tav_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","To bairo to cãnibato quena mani wapayegarã, rooro manire na tʉgooñaqueticõato ĩrã. To bairi ʉtabʉcʉrapʉ wai weija. Mʉ cajĩa jʉgoʉre cʉ rijerore tʉ̃ga pã, niyeru cuire mʉ bʉgagʉ cʉ rijeropʉ. Ti cui mena mʉ wapayegʉ mani pʉgarãre na cajeniro, cʉ caĩwĩ Pedrore Jesu. ");
INSERT INTO tav_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti paʉ cãno Jesu buerã cʉ tʉpʉ atí: —¿Ni maca mʉ cabuei Ʉpaʉ Dio cʉ cãnopʉ cãni majuʉ, carotii cʉ ãcʉati? cʉ̃re jã caĩ jeniñawʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","To bairo cʉ jã caĩ jeniñaro jĩcaʉ cawimaʉre cʉ capijowĩ Jesu. Cʉ pijo, cʉ caejanumu rotiwĩ jã watoapʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","To bairo átiri, ocõo bairo jã caĩwĩ Jesu cʉ buerãre: —Cariape mʉjaare yʉ ĩ. “Cãni majuʉ yʉ ã,” mʉja caĩ tʉgooñarijere tʉgooña janacõaña. Cawimarã na cãnore bairo maca tʉgooñaña. “Seeto caroti majii yʉ ã,” ĩ tʉgooñaquẽema cawimarã maca. To bairo mʉja catʉgooña wajoaquẽpata Ʉpaʉ Dio cʉ cãnopʉ mʉja ejaquetigarã. ");
INSERT INTO tav_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","To bairi Ʉpaʉ Dio cʉ cãnopʉ aperã netoro cãni majuurã anigarãma noa ani cawimaʉre bairona, “Cawatoa cãcʉ yʉ ã,” ati yepapʉ ãnapʉ caĩ tʉgooñarã. ");
INSERT INTO tav_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","To bairi ani cawimaʉre bairo cawatoa cãna yʉ carotiro mena nare cátinemorã yʉpʉre cátinemorã ãma. ");
INSERT INTO tav_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Aperã maca anire bairo cãnare caroorijere na cátiparore bairo na caĩ wadajãata seeto na popiyeyegʉmi Dio. To bairi anire bairo cãna yʉre caapiʉjarãre caroorije na cátiparore caĩ wadajãrã ʉ̃ta cui pairi cui na wamʉare jia yo, caʉ̃cʉari yapʉ care ñuacõa jooata ñuuboro. ");
INSERT INTO tav_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ati yepapʉ capãarã ãma aperãre caroorije na cátiparore caĩ wadajãrã. To bairona caĩ wadajãrã anicõa anigarãma. To bairo caroorije na cátiparore caĩ wadajãrãre seeto na popiyeyegʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’To bairi mʉja wamo mena o mʉja rʉpo mena caroorije mʉja cátigaro pa ta rocaricarore bairo áti janaña. Jĩca wamo mana o jĩca rʉpo mana anibana quena Dio tʉpʉ to cãnacã rʉmʉ mʉja cãno maca ñuubʉja. Cawamoricʉna o carʉporicʉna anibana quena pero cayatiqueti pero caʉ̃ropʉ mʉja cáaáto maca ñuuquetiboro. ");
INSERT INTO tav_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","To bairona mʉja capeari jʉgori ape wame tʉjʉri caroorijere mʉja cátigaro mʉja capearire pĩa reriquere bairo tʉjʉ janacõaña. Cacape mana anibana quena Dio tʉpʉ mʉja cáaáto ñuubʉja. Cacapecʉna anibana quena peropʉ mʉja cáaápata ñuuquetiboro. ");
INSERT INTO tav_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ani cawimaʉre bairo cãnare na tʉjʉ requẽja. Cariape mʉjaare yʉ ĩ. Dio tʉ macana ángel maja nare catʉjʉ ʉja coterã yʉ Pacʉ mena anicõa aninucuma. ");
INSERT INTO tav_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Diore catʉgooñaquẽna oveja na ʉpaʉre cáaáweo yajiricarãre bairona baima camaja quena. To bairo cabairãre na macaʉ acʉ́ yʉ cáapʉ́ ati yepapʉ. Na bʉgari nare yʉ netoo, rooro na cabairijere. ");
INSERT INTO tav_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Ati wamere tʉgooñaña mʉjaa. Oveja nuricarã cien nare cacʉgoʉ, jĩcaʉ cʉ̃re cʉ cáaáweo yajiata aperã noventa y nueve carʉjarãre caroa ta cãni buuropʉ na cũcõari cayajiricʉre cʉ macaʉ aácoaboʉmi. ");
INSERT INTO tav_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","To bairi cayajiricʉre cʉ bʉgaʉ caroaro wariñuuboʉmi. Aperã cayajiquetanare nare cʉ catʉjʉ wariñuuro netoro cʉ wariñuuboʉmi cayajiricʉre cʉ cabʉgaro. ");
INSERT INTO tav_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","To bairona cãcʉ ãmi mani Pacʉ Dio ʉmʉrecoo macacʉ. To bairi ani cawimaʉre bairo cãna yʉre caapiʉjarã jĩcaʉ maca cʉ catʉgooña mawijiaro, cʉ̃re cʉ cáaáweoro booquẽemi Dio. ");
INSERT INTO tav_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Jĩcaʉ mʉja yaʉ rooro mʉjaare cʉ cápata aperã na caapiquẽtopʉ cʉ cátajere cʉ buioya. Mʉjaare cʉ caapigaata caroaro cʉ mena mʉja anigarã tunu. ");
INSERT INTO tav_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mʉjaare cʉ caapigateero maca apeĩ mʉja yaʉ jĩcaʉ o pʉgarã na pi, na menare cʉ tʉpʉ aá, na caapirona rooro mʉjaare cátacʉre cʉ buioya. To bairo mʉja cáto na quena mʉjaare cʉ cátajere majigarãma. ");
INSERT INTO tav_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","To bairi na quenare cʉ caapigateero Diore caapiʉjarã na caneñaporopʉ na buioya. Na quena cʉ na cabuiorijere cʉ caapigateero, “Diore caapi nʉcʉbʉgoquẽnare bairona carooʉ ãcʉmi,” cʉ̃re mʉja ĩ tʉjʉgarã. “Gobierno ye cãnipe niyeru camaja yere cajeerãre bairona carooʉ majuu ãcʉmi,” cʉ mʉja ĩ tʉjʉgarã yua. ");
INSERT INTO tav_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Cariape mʉjaare yʉ ĩ. Ati yepapʉ yʉ yarã aniri, “Atie Dio ʉmʉrecoo macacʉ cʉ carotiquẽtie ã,” o ape wame, “Atie Dio cʉ carotirije ã,” Diore cʉ caĩbojarã mʉja anigarã camajare. ");
INSERT INTO tav_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ape wame quenare ocõo bairo mʉjaare yʉ ĩ: Ati yepapʉ cãna yʉ yarã pʉgarã, “Ati wame Diore mani jenirã,” mʉja caĩata Diore mʉja cajeniri wamere mʉja átibojagʉmi yʉ Pacʉ ʉmʉrecoopʉ cãcʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉgarã o itiarã yʉ yarã yʉre áti nʉcʉbʉgogarã na caneñaporo na watoapʉ yʉ anigʉ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Cabero Jesu tʉ atí, ocõo bairo cʉ caĩ jeniñawĩ Pedro: —Ʉpaʉ, ¿noo cãnacã ni yʉ yaʉ rooro yʉre cʉ cáto cʉ yʉ majirioʉati? ¿Siete cãnacã nina rooro yʉre cʉ cátiere yʉ camajirioro to ñuubʉjati? cʉ caĩ jeniñawĩ Pedro. ");
INSERT INTO tav_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","To bairo cʉ caĩ jeniñaro: —Baiquẽe. Nipetirije caroorije cʉ cátie cãno cõo cʉ majirioya, caĩwĩ Jesu Pedrore. ");
INSERT INTO tav_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ape wame caĩ buiowĩ Jesu tunu, Ʉpaʉ Dio ʉmʉrecoopʉ cãcʉ aniri camajare cʉ cátipere buio majioʉ. Ocõo bairo caĩ buiowĩ: —Jĩcaʉ maca ʉpaʉ cʉ ʉmʉa cʉ̃re na cawapaye quenoope cabooyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","To bairi cʉ yere cacõoñabojarã jĩcaʉ cʉ ʉmʉre capee majuu millón peso niyerure cawapamoʉre cʉ̃re na ʉpaʉ tʉpʉ cʉ caneajuparã. ");
INSERT INTO tav_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cʉ ʉpaʉre cʉ cawapayepere cacʉgoquẽjupʉ. To bairo cʉ cacʉgoquẽto tʉjʉʉ ocõo bairo caĩñupʉ cʉ ʉpaʉ cʉ yere cacooñabojarãre: “Cʉ ñeña. Cʉ ñe, cʉ̃re, cʉ nʉmore, cʉ punaare, cʉ cacʉgorije quenare aperãre na jooya, na paabojari maja na anicõato ĩrã. To bairo na joo átiri niyerure mʉja jeegarã,” na caĩñupʉ. “Tie yʉre cʉ cawapamorije wapa anigaro,” caĩñupʉ cʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","To bairo cʉ caĩro apii cʉ ʉmʉ yepapʉ rʉpopatua mena tuatu cumu eja seeto otirique mena cʉ caĩ jeniñupʉ: “Ʉpaʉ, mʉ yʉ cawapamorijere patowãcaquẽja. Yoaro mee yʉ wapaye peogʉ,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","To bairo cʉ caĩro apii cʉ bopaca tʉjʉ, cʉ̃re cʉ cawapamorijere, “To anicõato,” ĩ, cʉ̃re cʉ cawapamobatajere cʉ camajirioyupʉ. To bairo cʉ ĩ majirio, to cõona cʉ catunu aá rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","To bairi pairo majuu cʉ ʉpaʉre cʉ cawapamobatajere cʉ camajirioricʉpʉ cabutiyupʉ. Buti, cʉ yaʉ petoacã cien peso cõo cʉ̃re cawapamoʉre cʉ bʉga, cʉ cañeñupʉ cʉ wamʉ tutupʉre: “¡Yʉ mʉ cawapamorijere yʉ wapayeya!” cʉ caĩ tutiyupʉ cʉ̃re. ");
INSERT INTO tav_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","To bairo cʉ caĩ tutiro cʉ yaʉ cʉ̃re cawapamoʉ yepapʉ ejacumuri, otirique mena ocõo bairo cʉ caĩ jeniñupʉ yua: “Mʉ yʉ cawapamorijere patowãcaquẽja. Yoaro mee mʉ yʉ wapaye peogʉ,” cʉ caĩ jeniñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","To bairo cʉ caĩ jenirije to cãnibato quena caberopʉ cʉ cawapayepe cayuugaquẽjupʉ. To bairi cʉ tuti, presopʉ cʉ cajooyupʉ, nemoona yʉre cʉ wapayecõato ĩi. ");
INSERT INTO tav_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","To bairo cʉ cáto aperã cʉ̃re bairo paa coteri maja catʉjʉyuparã. To bairo cʉ cátajere rooro tʉgooñari na ʉpaʉre cʉ cabuiora aájuparã. ");
INSERT INTO tav_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","To bairo na cʉ caĩ buioro apii pairo majuu cawapamobatacʉre cʉ pijo, ocõo bairo cʉ caĩñupʉ: “Mʉ ñuuqueti majuucõa mʉa. Yʉre mʉ cajeniro yʉre mʉ cawapamobatajere mʉre yʉ camajiriowʉ,” cʉ caĩñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","“To bairo mʉre yʉ cabopaca tʉjʉrore bairona mʉ quena mʉ yaʉre mʉ cabopaca tʉjʉata ñuuboyupa,” cʉ caĩ tutiyupʉ macá ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","To bairo cʉ ĩ tuti, presopʉ cãnare capopiyeyerãre na cajooyupʉ, cʉ popiyeyeya na ĩi. “Yʉre cʉ cawapamobataje cʉ cawapaye peoropʉ cʉ̃re mʉja buugarã,” na caĩñupʉ, caĩ buiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’To bairi mʉja quena mʉja yarã rooro mʉjaare na cáto nare mʉja camajirioquẽpata mʉja popiyeyegʉmi mani Pacʉ ʉmʉrecoo macacʉ mʉja quenare, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu tiere cʉ caĩ buio yaparoro, Galilea yepapʉ cãnana jã cáaácoapʉ Jesu mena Judea yepapʉ. To bairi Jordán na caĩri ya i nʉgoapʉ cʉ mena jã cãmʉ. ");
INSERT INTO tav_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","To bairi noo cʉ cáaátopʉ camaja capãarã cʉ caʉjawã Jesure. To bairi na mena macana cariaye cʉnare na canetoo catiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Topʉ jã cãno fariseo maja jĩcaarã Jesu tʉpʉ atí, tʉgooña mawijiari wame cʉ ĩ bui cʉparo ĩrã ocõo bairo cʉ caĩ jeniñawã: —¿Mani judío majare jĩcaʉ cʉ nʉmore cʉ carocagaata roca rotirique to ãti? cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","To bairo cʉ na caĩ jeniñaro: —¿Dio Wadariquere cabuerã anibana quena mʉja majiquẽeti? Nemoopʉ camajare áti jʉgoʉ, caʉmʉ, cãromio na cájupi Dio. ");
INSERT INTO tav_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na áti yaparo ocõo bairo na caĩ cũñupi: “Ni ũcʉ cãromiore ne, cʉ pacʉare tʉgooña janari cʉ nʉmo ye macare catʉgooñapaʉ ãmi. To bairi co mena aniri pʉgarã anibana quena cʉ nʉmo mena jĩcaʉre bairona ãma cʉ nʉmo jãa,” caĩ cũñupi Dio. ");
INSERT INTO tav_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","To bairi camajocʉ jĩcaʉ cʉ nʉmo mena jĩcaʉre bairona aniri Dio cʉ cacũricarã ãma jĩca bapa. To bairona Dio cʉ cacũricarã aniri caame rocaquetiparã ãma, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","To bairo na cʉ caĩro: —Baiyupa cariape mʉ ĩquẽcʉ. Mani ñicʉ Moisé ãnacʉ ocõo bairo caucayupi: “Jĩcaʉ cʉ nʉmore rocagʉ papera pũuro, ‘Ocõo bairo mʉ cabairije wapa mʉ yʉ rocagʉ,’ ĩrica pũuro cõre cʉ joato,” caĩ ucayupi Moisé, Jesure cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","To bairo na caĩro: —Mʉja yeripʉ Dio cʉ caboorijere mʉja cabai netoogaro jĩcaʉ cʉ nʉmore carocagaʉre camataquẽjupi Moisé. To bairo to cãnibato quena nemoopʉre carotiquetibajupi Dio. ");
INSERT INTO tav_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yʉ maca ocõo bairo mʉjaare yʉ ĩ: Jĩcaʉ cʉ nʉmo apeĩ mena co cáti epequetibato quena co rocaʉ apeore nei, rooro ácʉ áami. Apeĩ cʉ carocaricore canʉmocʉcʉ rooro ácʉ áami cʉ quena. ");
INSERT INTO tav_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","To bairo fariseo majare cʉ caĩro ocõo bairo cʉ buerã cʉ jã caĩwʉ: —Baiyupa to roque to bairo cabaiata cãromiore nequetaje ñuuboro, jã caĩwʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","To bairo cʉ jã caĩro: —Canʉmo mana Dio cʉ cabooro to bairona cãromiore canequẽna anigarãma. To bairi cãromiore canequẽna Dio cʉ cacũricarã canʉmo mana ani majigarãma. ");
INSERT INTO tav_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jĩcaarã nemoopʉ carooye tuaricarã buiabana nʉmocʉti majiquẽnama. Aperã aperã to bairo nare na cãni rotirona canʉmo mana ãma. Aperã na majuuna Dio yere átigarã cãromiore negaquẽema. To bairo Dio yere átigarã canʉmo mana cãni ocabʉtirã to bairona cãna na anicõato, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Cabero aperã Jesu tʉpʉ cajee ejawã na punaare, na ñiga peori Diore na jenibojaya jã punaare ĩrã. Jesu buerã maca nare matagabana, “Cʉ patowãcooqueticõaña,” na jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","To bairo na jã caĩro: —Cawimarã yʉ tʉpʉ na aparo. Na mataqueticõaña. Ʉpaʉ Dio cʉ cãnopʉ cáaáparã ãma ati maja cawimarãre bairona caroaro yʉre canʉcʉbʉgorã, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","To bairo ĩ, cawimarãre na ñiga peori Diore na jeniboja, cáaácoami Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cabero apeĩ cawamaʉ caapeye paii atí, ocõo bairo Jesure cʉ caĩ jeniñawĩ: —Ʉpaʉ, caroaʉ mʉ ã. To bairo caroaʉ mʉ cãno jĩca wame mʉ yʉ jeniñapa. ¿Ñee caroare yʉ ácʉati Dio tʉpʉ anicõa aninucugʉ? caĩ jeniñawĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","To bairo cʉ caĩro: —¿Nope ĩi caroaʉ yʉre mʉ ĩti? Dio jĩcaʉna ãmi caroaʉ. Dio tʉpʉ anicõa aninucugʉ Dio cʉ carotiriquere apiʉjaya, caĩwĩ Jesu cawamaʉ caapeye unie paiire. ");
INSERT INTO tav_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","To bairo cʉ caĩro: —¿Di wame cʉ carotiriquere yʉ ácʉati? caĩ jeniñawĩ. To bairo cʉ caĩ jeniñaro: —Jĩaquẽja. Áti epericarã cʉtiquẽja. Aperã yere jee rutiquẽja. Aperãre ĩtoquẽja. ");
INSERT INTO tav_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ pacʉare na nʉcʉbʉgoya. Aperãre na maiña mʉ majuuna mʉ camairore bairona, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","To bairo cʉ caĩro: —Atie nipetirijere yʉ cátinucuwʉ to cãnacã rʉmʉ cawimaʉ ãcʉpʉna rʉjaricaro mano. ¿Ñee to rʉjati yʉ cátipe? caĩ jeniñawĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","To bairo cʉ caĩ jeniñaro ocõo bairo cʉ caĩwĩ Jesu: —Caroaʉ majuu anigʉ mʉ cacʉgorije nipetiro aperãre joo peocõari, niyerure jee átiri cabopacoorãre na jooya. To bairo ácʉ caroare mʉ cʉgogʉ Dio tʉpʉ, jõ buipʉre. To bairo cabopacoorãre niyeru nipetiro joo peocõari yʉ mena ajá, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","To bairo Jesu cʉ̃re cʉ caĩro apii tʉgooñarique pai, cáaácoami, pairo majuu apeye cʉ cacʉgorijere maibacʉ. ");
INSERT INTO tav_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","To bairo tʉgooñarique pairique mena cʉ cáaáto tʉjʉʉ ocõo bairo jã caĩwĩ Jesu cʉ buerãre: —Cariape mʉjaare yʉ ĩ: Caapeye pairãre seeto majiriobʉja Dio tʉpʉ aágabapata. ");
INSERT INTO tav_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cameyo na caĩi waibʉcʉ capaii quenare apopotare yʉta wẽ pĩorica opeacãre cʉ caame butigaata majiriobʉja. To bairona majiriobʉja caapeye unie pairã quenare Dio tʉpʉ na caejape. ");
INSERT INTO tav_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","To bairo cʉ caĩro jã caapi acʉacoapʉ. —Baiyupa to bairo Dio tʉpʉ aátaje camajirioata noa Dio tʉpʉ aáquẽnama, cʉ jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","To bairo cʉ jã caĩro Jesu jãre tʉjʉ: —Camaja na majuuna Dio tʉpʉ aá majiquẽema. Dio maca nipetiri wame cáti majii aniri jĩcaʉna ãmi camajare to cãnacã rʉmʉ cʉ tʉpʉ na cãnicõa aninucupere cajoʉ, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","To bairi Pedro ocõo bairo cʉ caĩwĩ Jesure: —Nipetirije jã yere jã cáaáweowʉ, mʉ mena macana anigarã. To bairo jã cátie wapa ¿ñeere jãre cʉ joʉati Dio? ");
INSERT INTO tav_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","To bairo Pedro cʉ caĩ jeniñaro: —Dio ati ʉmʉrecoo macaje nipetiro cawama jeto wajoagʉmi. Cʉ cawajoari paʉ Caʉpaʉ yʉ cãnopʉ mʉja quena yʉ ẽoro carotinemorã mʉja anigarã. Yʉre caapiʉjaricarã aniri Israel maja doce cãnacã poarire carotirã mʉja anigarã. ");
INSERT INTO tav_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jĩcaʉ yʉ caboorijere átigʉ cʉ yere cʉ cáaáweobataje netoro majuu cʉ joogʉmi Dio cañuurijere. Cʉ wiiri, cʉ yarã, cʉ yarã romiri, cʉ pacʉa, cʉ punaa, cʉ wejeri nipetiro aáweoʉ yʉ yere átigʉ cʉ cacʉgobataje netoro caroa majuu bʉgagʉmi. Anicõa aninucugʉmi Dio tʉpʉ. ");
INSERT INTO tav_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","To bairo to cãnibato quena noa, “Cãni majuurã jã ã,” caĩ tʉgooñarã maca cawatoana cãna majuu na cũgʉmi Dio. “Aperã bero macana jã anigarã,” caĩrã macare cajʉgo aniparã na cũgʉmi Dio na macare, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ape wame caĩ buiowĩ Jesu, Ʉpaʉ Dio cʉ cãniere jãre buio majioʉ: —Jĩcaʉ pairo oterique cacʉgoʉ cãñupʉ. Jĩca rʉmʉ cabujuri paʉ cãno ʉje miji wẽri cãni wejepʉ cʉ̃re capaabojaparãre camacaʉ aájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","To bairi jĩcaarã cʉ̃re capaabojagarã, “Jaʉ, jĩca rʉmʉ jã paabojagarã jĩca cui caajiyari cui wapa,” na caĩro na capaa rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cabujuri paʉ bero yucʉ bui muipu cʉ cãno macá recomacapʉ aá, aperã to bairona cãnicõarã capaaquẽnare na catʉjʉyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na tʉjʉ, “Mʉja quena yʉ ʉje wejepʉ paabojarã aája. Cariape mʉjaare yʉ wapayegʉ,” na caĩñupʉ. To bairo cʉ caĩro, “Jaʉ,” ĩri cʉ capaabojarã aájuparã. ");
INSERT INTO tav_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cabero paaribota cãno aperãre to bairona na capiyupʉ tunu. Cabero muipu cʉ caame pua rui atí paʉ capiyupʉ aperã quenare. ");
INSERT INTO tav_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","To bairi yucʉ buiacã muipu cʉ cãno majuu macá recomaca aá tunu, aperã cawatoa cãnicõarãre na catʉjʉ bʉgayupʉ tunu. Na tʉjʉ bʉga, “¿Nope ĩrã to bairona mʉja tʉjʉnucu naiocoapari paari mee?” na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","To bairo na cʉ caĩro: “To bairona jã ani naiocoapʉ. Ñamʉ, ‘Mani paato,’ jãre ĩquẽmi,” cʉ caĩñuparã. To bairo cʉ na caĩro: “Mʉja quena yʉ ʉje wejepʉre paabojarã aája,” na caĩñupʉ. To bairo na cʉ caĩro na quena capaabojara aájuparã. ");
INSERT INTO tav_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Canaiori paʉ caejaro yua weje ʉpaʉ cʉ yere carotibojaʉre ocõo bairo cʉ caĩñupʉ: “To cõona, paari maja na pijori na wapayeya. Caberopʉ capaara ejaricarãre na wapaye jʉgóya. Na bero na wapayeya na jʉgoyeacã capaara ejaricarãre. To bairo na áti nutua, capaara eja jʉgoricarã macare na wapaye ʉja jooya,” caĩñupʉ weje ʉpaʉ cʉ yere carotibojaʉre. ");
INSERT INTO tav_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","To bairi yucʉ buiacã muipu cʉ cãno capaabojarã ejaricarã cawapa jeerã ejayuparã. Na cawapa jeerã ejaro rotibojari majocʉ na cajooyupʉ to cãnacãʉna jĩca cuiri caajiyari cuiri jeto. ");
INSERT INTO tav_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wapaye nutua, caeja jʉgoricarãpʉ cawapaye ejooyupʉ. To bairi capaara eja jʉgoricarã maca, “Aperã netoro jã wapayegʉmi,” caĩ tʉgooñabajuparã. Na caĩ tʉgooñarije to cãnibato quena to bairona na cajooyupʉ to cãnacãʉna caajiyari cuiri jĩca cuiri jeto. ");
INSERT INTO tav_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","To bairo aperã cõona na cʉ cawapayero tʉjʉrã weje ʉpaʉre ocõo bairo cʉ caĩ tutiyuparã: ");
INSERT INTO tav_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ati maja capaara eja tʉjaena jĩca horana na capaabato quena jãre mʉ cawapayero cõona nare mʉ wapayewʉ. Jã maca yoaro seeto caajiro quenare jã paabapʉ. Ñuuquẽto majuu mʉ áa,” caĩ tutiyuparã capaara eja jʉgoricarã. ");
INSERT INTO tav_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","To bairo cʉ na caĩ tutiro ocõo bairo caĩñupʉ ʉpaʉ to bairo caĩ jʉ́goʉre: “Baiquẽe. ‘Caajiyari cui jĩca cui mʉ yʉ joogʉ jĩca rʉmʉ paarique wapa,’ yʉ caĩro, ‘Jaʉ,’ yʉre mʉ ĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Yʉ ye niyeru to cãno maca yʉ majuuna yʉ cabooro cawapayepaʉ yʉ ã. To bairona boʉ caeja tʉjarã quenare mʉ yʉ cawapayero cõona na yʉ wapayewʉ. Caroaro na tʉgooñari pairo na yʉ cajooro capunijiniquetipaʉ mʉ anibapa. To bairi mʉ ye wapa ne aácoacʉja,” caĩñupʉ paarique ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","To bairona, “Cãni majuʉ yʉ anigʉ,” caĩ tʉgooñarã Ʉpaʉ Dio cʉ cãnopʉ cawatoa cãna anigarãma. Aperã maca, “Aperã bero macacʉ yʉ ã,” caĩ tʉgooñarã cãni jʉgorã anigarãma Ʉpaʉ Dio cʉ cãnopʉ. ");
INSERT INTO tav_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cabero Jesu Jerusalẽpʉ aágʉ cabaiwĩ. To bairi aperã na caapiquẽtopʉ aperobʉjaacã jãre pijo, ocõo bairo jã caĩ buiowĩ: ");
INSERT INTO tav_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Yucʉacã Jerusalẽpʉ mani aágarã. Topʉ yʉ cãno aperã yʉre joogarãma sacerdote maja ʉparãre, judío majare cabuerãre. To bairi yʉre joogarãma tunu aperãre judío maja cãniquẽnare, cʉ jĩa rocacõaña ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","To bairo na cajĩa rotiro yʉ ĩ epe, yʉ bape, yucʉ tẽorica pãipʉ yʉ papua tu jĩa rocacõagarãma yua. To bairo yʉre na cajĩa rocarije to cãnibato quena itia rʉmʉ bero yʉre tunu catiogʉmi Dio, jãre caĩ buiowĩ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cabero Sebedeo nʉmo, cʉ punaa paco, Jacobo, Juan mena, Jesure cajenirã ejawã cʉ tʉpʉ. To bairi na paco Jesure nʉcʉbʉgori rʉpopatua tuatu cumu ejari Jesure jenigo cabaiwõ. ");
INSERT INTO tav_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","To bairo co cáto: —¿Ñeere mʉ yʉ cátibojape mʉ booti? co caĩwĩ Jesu. —Mʉ carotiri paʉ cãnopʉ ati maja yʉ punaare mʉ mena carotiparãre na mʉ cũwã. To bairo átiri jĩcaʉ cariape nʉgoa, apeĩ cacõ nʉgoapʉ caroti ruiparãre na mʉ cũwã, caĩ jeniwõ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","To bairo co punaare co caĩ jenibojaro ocõo bairo na caĩwĩ Jesu nare: —Mʉja cajeniri wamere mʉja tʉgooña majiquẽe. Aperã seeto yʉ popiyeyegarãma. ¿Yʉre na capopiyeyepere bairona mʉja quena mʉja capopiye tamʉoata mʉja nʉca majicʉti? caĩ jeniñawĩ Jesu. —Ʉ̃ʉjʉ, jã nʉca majirã, caĩwã Jacobo, Juan Jesure. ");
INSERT INTO tav_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","To bairo Jesure na caĩro, ocõo bairo na caĩ buiowĩ Jesu: —Yʉre na capopiyeyerore bairona mʉja quenare popiyeyegarãma. Yʉre bairona catamʉoparã mʉja cãnibato quena yʉ mena carotiparãre mʉjaare yʉ cũ majiquẽe. Yʉ riape nʉgoa, yʉ cacõ nʉgoapʉ yʉ mena caroti ruiparãre carotipaʉ mee yʉ ã. Yʉ Pacʉ maca to bairo cãnare na cũgʉmi, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","To bairo Jesure cʉ na caĩ jenibatajere apirã aperã Jesu buerã diez cãnacãʉ nare jã catʉgooña punijiniwʉ Jacobore, Juãre. ");
INSERT INTO tav_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","To bairo nare jã catʉgooña punijinirijere tʉjʉ maji, jã nipetirãre cʉ buerãre pi neojo, ocõo bairo jã caĩ buiowĩ Jesu: —Ape macari macana na ʉparã tutuaro rotima. Na ẽoro carotirã quena na majare rotima tunu. ");
INSERT INTO tav_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉja maca atiere cabaiquetiparã mʉja ã. Nii mʉja yaʉ cãni majuʉ anigʉ capaa cotei cʉ anicõato. ");
INSERT INTO tav_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cajʉgo ãcʉ anigʉ cʉ quena aperãre capaabojaʉ cʉ anicõato. ");
INSERT INTO tav_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","To bairona yʉ ã camaja tʉpʉ Dio cʉ cajooricʉ anibacʉ quena. Aperãre, “Yʉre capaa coteri maja ãña,” caĩi mee yʉ ã. Yʉ majuuna aperãre átinemoʉ acʉ́ yʉ cáapʉ́. To bairi camaja capãarã majuu caroorije na cátajere bai yaji wapayebojaʉ acʉ́ yʉ cáapʉ́ ati yepapʉ, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cabero Jesu mena Jericó na caĩri macapʉ cãnana jã cabuti aápʉ. Jã cáaáto camaja capãarã majuu Jesure caʉjawã. ");
INSERT INTO tav_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jã cáaáti wã tʉna caruiwã pʉgarã catʉjʉ majiquẽna. “Jesu ato neto aápí,” aperã na caĩ buioro apirã ocõo bairo awajarique mena cʉ caĩ jeniwã: —¡Jã Ʉpaʉ Jesu, Ʉpaʉ David cãniñaricʉ pãrami Dio cʉ cajooricʉ mʉ ã! ¡Jã bopaca tʉjʉya! cʉ caĩ jeniwã. ");
INSERT INTO tav_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","To bairo awajari na caĩ jeniro apirã to cáaána paarãacã, “¡Janaña!” na caĩ tutiwã. To bairo camaja na cajana rotibato quena netobʉjaro awajari cʉ caĩ jeniwã Jesure: —¡Jã Ʉpaʉ, David cãniñaricʉ pãrami! ¡Jã bopaca tʉjʉya! caĩ jeniwã. ");
INSERT INTO tav_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","To bairo baujaro majuu na caĩ jeniro apii Jesu catua nʉcacõawĩ. Tuanʉca, ocõo bairo na caĩ piwĩ: —¿Ñeere mʉjaare yʉ cátibojapere mʉja booti? na caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","To bairo na cʉ caĩ jeniñaro: —Jã Ʉpaʉ, jã catʉjʉ majiro jãre ája, Jesure cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","To bairi Jesu na bopaca tʉjʉ, na cápeere capañawĩ. Cʉ capañarona nemoo catʉjʉcoama. To bairo cʉ cáti yaparoro cʉ mena cáaáma naa yua. ");
INSERT INTO tav_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cabero Jerusalẽpʉ Jesu mena aána jã caejawʉ Betfagé na caĩri macaacã Jerusalén tʉ, Ʉ̃taʉ Olivo cawamecʉtii pʉtopʉ cãni maca. ");
INSERT INTO tav_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ti maca tʉjaro majuu jã caejaro ocõo bairo caĩwĩ Jesu cʉ buerã pʉgarãre: —Aánaja ati macaacãpʉ. Ejarã mʉja tʉjʉ bʉgagarã jĩcao burra co macʉ mena jia nʉcoricore. Na tʉjʉ bʉga, na popiori, yʉ tʉpʉ nare mʉja jee apá. ");
INSERT INTO tav_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Apeĩ, “¿Nope ĩrã nare mʉja jee aápari?” mʉja cʉ caĩata, “Jã Ʉpaʉ na boomi, yoaro mee na tunuo joogʉmi,” cʉ̃re mʉja ĩgarã. ");
INSERT INTO tav_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","To bairije cabaiwʉ tirʉmʉpʉ macacʉ Jesu cʉ cabaipere ocõo bairo cʉ caĩ ucaricarore bairona: ");
INSERT INTO tav_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén macanare na ĩ buioya: Mʉja Ʉpaʉ cʉ caejaro cʉ tʉjʉya. Carotiire bairo mee atími. Burra macʉ bui peja nutua atími, caĩ ucayupi tirʉmʉpʉ macacʉ Jesu cʉ cabaipere. ");
INSERT INTO tav_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","To bairi na pʉgarã Jesu buerã cʉ caĩrore bairona cámá. ");
INSERT INTO tav_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Cajee amá burrare, co macʉ mena. Na jutii bui macajere tu weri na bui capeowã. To bairo na cáto na jutii bui pejari cáaámi Jesu yua. ");
INSERT INTO tav_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Camaja to cãna paarãacã Jesure nʉcʉbʉgori na jutii cabui macajere tu weri cʉ jʉgoye mapʉ cacũ nutuama. Aperã carupa ño pũurire pajure jeeri tie quenare Jesu cʉ cáatí wãpʉ cacũ jʉgoyeye nutuama. ");
INSERT INTO tav_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aperã capãarã cʉ jʉgoye cáaána, aperã capãarã cʉ bero caʉjarã quena, ocõo bairo cʉ caĩ wariñuu awaja nutuama: —¡Caroaro wariñuuriquere mani joorã mani ñicʉ David cãniñaricʉ pãramire, Dio cʉ cajooricʉre! Dio cʉ caroti jooro mena ejami. ¡Caroaro wariñuurique cʉ̃re to ãmaro! ¡Dio jõ bui cãcʉ caroaro cʉ̃re mani áti nʉcʉbʉgoto! caĩ wariñuu awaja nutuama. ");
INSERT INTO tav_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","To bairi Jerusalẽpʉ cʉ caejaro ti maca macana nipetirã catʉgooña mawijiawã: —¿Ñamʉ cʉ anicʉti? caame ĩwã. ");
INSERT INTO tav_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aperã camaja capãarã: —Jesu ãmi cʉ̃a. Dio ye quetire cabuioʉ ãmi. Nasaré na caĩri maca Galilea yepa macacʉ caejaecʉ ãmi, caĩwã. ");
INSERT INTO tav_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","To bairi Jesu cajãacoami Dio wiipʉ. Topʉ jãa, catʉjʉwĩ cawapayerãre, caapeye joorã quenare. Na tʉjʉ, Dio wiipʉ to bairo na cáto booquẽcʉ nare cabuuwĩ. Aperã niyeru wajoari maja ya cajawari catupu cũ recõawĩ. Aperã cajĩa joe buje mʉgo jooparã buaare joori cawapa jeerã quenare na ruiriquere catupu cũ recõawĩ. ");
INSERT INTO tav_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","To bairo átiri ocõo bairo na caĩ tutiwĩ Jesu: —Dio Wadariquepʉ, “Yʉ ya wii yʉre jeni nʉcʉbʉgorica wii ã,” ĩ ucarique ã. Mʉja maca to bairo Dio wiipʉna wapa jeerã cajee ruti pairã na cãni paʉre bairona mʉja áa, caĩwĩ Jesu, nare buʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesu Dio wiipʉ cʉ cãno cʉ tʉpʉ caejawã catʉjʉ majiquẽna, cáaá majiquẽna. Cʉ tʉpʉ na caejaro na canetoo catiowĩ. ");
INSERT INTO tav_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdote maja ʉparã, judío majare cabuerã to bairo cʉ cáti iñooriquere catʉjʉwã. Cawimarã, “Caroaro wariñuuriquere mani joorã mani ñicʉ David cãniñaricʉ pãramire, Dio cʉ cajooricʉre,” na caĩ wariñuu awajarije quenare caapiwã. To bairi capunijini tʉgooñawã. ");
INSERT INTO tav_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","To bairo punijini tʉgooñari ocõo bairo caĩwã Jesure: —Ñuuquẽe to bairije ati maja cawimarã na caĩro, caĩwã. To bairo na caĩro: —To bairona na ĩ wariñuato, na caĩwĩ Jesu. —Ocõo bairo ĩ ucarique ã Dio Wadariquepʉ: “Cawimarã, caũpurãacã quena mʉre na caĩ wariñuupere mʉ rotiwʉ.” Ti wame ĩ ucariquere mʉja bue tʉgaricarã, na caĩwĩ Jesu to bairo cʉ̃re capunijini tʉgooñarãre. ");
INSERT INTO tav_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","To bairo na ĩ, na cabuti aáweowĩ Jesu Jerusalẽpʉ cãnacʉ. Cʉ cabuti aáto jã cáaápʉ cʉ mena Betania na caĩri macaacãpʉ. Topʉ jã cacaniwʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cabujuri paʉ cãno Jerusalén macapʉ jã catunu aápʉ. Macapʉ jã catunu aáto cañigo riawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","To bairi jĩcʉ yucʉ higuera cawamecʉtii ti wã tʉacãna cãniire catʉjʉwĩ. Tiire tʉjʉ bʉga, caricare camacabami. Capũ jeto cãmʉ. Carica mamʉ. To bairi carica mano tʉjʉʉ ocõo bairo caĩwĩ Jesu tiire: —Yucʉra carica manii to anicõato to roque, caĩwĩ. To bairo cʉ caĩrona cajinicoapʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","To bairo cabairo cʉ buerã jã catʉjʉ acʉacoapʉ. —¿Nope ĩro yoaro mee to jinicoapari? jã caĩ jeniñawʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","To bairo cʉ jã caĩ jeniñaro ocõo bairo jã caĩwĩ Jesu: —Cariape mʉjaare yʉ ĩ. Yʉre tʉgooña nʉcʉbʉgori, “Diore yʉ cajenibato quena baiquetigaro,” ĩ tʉgooñaquẽnana Diore jeni nʉcʉbʉgoya. To bairo mʉja cáto mʉja quenare mʉja átibojagʉmi Dio. Atii cabairore bairona mʉja átibojagʉmi Dio. Icʉ ʉ̃taʉ quenare, “Ato cãnacʉ pairi yapʉ roca ñua yaji aátoja,” mʉja caĩrore bairona baigaro. ");
INSERT INTO tav_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","To bairi, “Yʉ joogʉmi Dio,” cʉ mʉja caĩ tʉgooña nʉcʉbʉgoro nipetiro mʉja cajenirijere mʉja joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cabero macapʉ eja, Dio wiipʉ jã cajãacoapʉ Jesu mena. Topʉ camajare cabuiowĩ Jesu cʉ ye quetire. Nare cʉ cabuioro caejawã sacerdote maja ʉparã, aperã cabʉcʉrã carotirã. Eja: —¿Ñamʉ atiere mʉ cʉ áti rotiti? ¿Ñamʉ, “To bairona buioya,” mʉ cʉ ĩti? cʉ caĩ jeniñawã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","To bairo cʉ̃re na caĩ jeniñaro ocõo bairo na caĩ yʉwĩ Jesu: —Yʉ quena jĩca wamere mʉjaare yʉ jeniñagʉ. Cariapena yʉ mʉja cayʉata mʉja quenare, “Cʉ̃ yʉ áti rotimi,” mʉjaare yʉ ĩ buiogʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ñamʉ Juãre cʉ cabautisa rotiyupari? ¿Diona cʉ carotiyupari? o ¿camaja na majuuna cʉ na carotiyupari? na caĩ jeniñawĩ Jesu. To bairo na cʉ caĩ jeniñaro na majuuna ocõo bairo caame wadapeniwã: “ ‘Diona cʉ rotiricʉmi,’ mani caĩata, ‘¿Nope ĩrã Dio cʉ carotiricʉrena cʉ mʉja caapiʉjaqueti?’ mani ĩboʉmi Jesu. ");
INSERT INTO tav_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Camaja na majuuna Juãre cʉ rotiricarãma,’ mani caĩata, camaja manire tutirema ĩrã na mani uwiborã. ‘Dio ye quetire cabuioʉ, Dio cʉ cajooricʉna ãnacʉmi Juan,’ ĩ tʉgooñama camaja nipetirã,” caame ĩ wadapeniwã na majuu. ");
INSERT INTO tav_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","To bairi: —Ũba, noa cʉ rotiricarãma jã ĩ majiquẽe, caĩwã Jesure. To bairo cʉ na caĩro: —Yʉ quena cʉ̃ atiere yʉre cʉ cáti rotiro yʉ áa mʉjaare yʉ ĩ buioquẽe, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ape wame ocõo bairo queti buio majiorica wame na caĩ buiowĩ Jesu tunu: —Ati wame tʉgooñañajate. Jĩcaʉ pʉgarã caʉmʉa capunaacʉcʉ cãñupʉ. Jĩcaʉre: “Yucʉra ʉje cãni wejepʉ paʉja, macʉ,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Yʉ paʉ aágaqueti majuucõa,” caĩñupʉ. Cabero cʉ pacʉre cʉ caĩ netoo nʉcariquere jʉtiriti, capaʉ aájupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","To bairi na pacʉ apeĩ cʉ macʉre to bairona, “Yucʉra ʉje cãni wejepʉ paʉja,” cʉ caĩñupʉ cʉ quenare. “Jaʉ, yʉ paʉ aágʉ,” caĩñupʉ cʉ pacʉre. To bairo ĩbacʉ quena capaʉ aáquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","To bairo na cabairijere tʉgooñaña mʉjaa. Na pacʉ cʉ caboorijere cátacʉ ¿ni maca cʉ cãñupari? na caĩ jeniñawĩ Jesu. To bairo cʉ na caĩ jeniñaro: —Na pacʉ cʉ cáaá roti jʉgoricʉ maca ãnacʉmi, cʉ caĩwã Jesure. To bairo na caĩro ocõo bairo na caĩ buiowĩ Jesu: —Cariape mʉjaare yʉ ĩ. Caroorã, niyeru gobierno ye cãnipe camaja yere cajeerã, caroorã romiri quena Juan cʉ cabuioriquere caapiʉjawã. Noa, “Caroa macare ája,” Juan cʉ caĩriquere caapiʉjaricarã aágarãma Dio tʉpʉ. Mʉja maca cʉ cabuioriquere caapiʉjaquetana aniri Dio tʉpʉ mʉja aáquetigarã. Caroorije mʉja cátiere janagaquetiri Juan bautisari majocʉre mʉja caapiʉjaquẽjupa. ");
INSERT INTO tav_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Ape wame queti buio majiorica wame mʉjaare yʉ ĩ buiopa. Apiya: Pairo oterique ʉpaʉ cãñupʉ. Jĩca weje caoteyupʉ ʉje miji wẽri cãni weje. Ote, cajani jãcõañupʉ ti wejere. To bairo átiri jĩca paʉ ʉ̃taa capairicapʉre ʉje ocore cʉ caripe jãpa corore caquenooñupʉ. Áti yaparo caʉmʉari wii cájupʉ jee rutiri majare cʉ catʉjʉpa wiire, jee rutirema ĩi. Cabero aperopʉ aáteñaʉ aágʉ ocõo bairo caĩ cũñupʉ aperãre: “Yʉ ʉje wejere yʉ cotebojaya. Yʉre mʉja cacotebojaro mʉjaare yʉ joogʉ carecomaca caricare.” To bairo na ĩ yaparo aperopʉ cáaáteñaʉ aájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ʉje caricacʉti yʉtea caejaro weje ʉpaʉ cʉ ʉje wejere cotebojari maja tʉpʉ cajooyupʉ aperã cʉ paabojari majare, “Yʉ ye ʉje ricare jenirã aája,” na ĩi. To bairo na cʉ caĩro cajenirã aábajuparã. ");
INSERT INTO tav_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na cajenirã ejaro tʉjʉrã ʉje wejere cʉ cacoteboja rotibatana na cañeñuparã. Caricare cajenirã ejabatanare na ñe, jĩcaʉre cʉ quẽ camiye, apeĩre cʉ jĩa roca, apeĩre ʉ̃ta rupaa mena cʉ re camiye, cájuparã. ");
INSERT INTO tav_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","To bairo rooro nare na cáto queti apii, weje ʉpaʉ aperã na cajoonemoñupʉ tunu. Cʉ cajoo jʉgoricarã netoro capãarã na cajeni roti jooyupʉ. Na cajenirã ejaro tʉjʉrã to bairona na quenare rooro cáticõañuparã tiere cʉ cacoteboja rotiricarã tunu. ");
INSERT INTO tav_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Cabero weje ʉpaʉ cʉ macʉrena cʉ cajeni roti jooyupʉ, yʉ macʉ cʉ cãno cʉ tʉjʉ nʉcʉbʉgogarãma ĩi. ");
INSERT INTO tav_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","To bairo cʉ macʉrena cʉ cajoobato quena cʉ wejere cʉ cacote rotibatana cʉ tʉjʉrã ocõo bairo caame ĩñuparã: “Ani cajeni ejaʉ atie ʉpaʉ macʉ ãmi, cʉ pacʉ cʉ cabai yajiro bero atiere cacʉgo ʉjapaʉ. Cʉ mani jĩa rocacõato. To bairi mani majuuna mani cʉgogarã cʉ ye cãnibope ati weje, atie oterique nipetiro,” caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","To bairo ame ĩ, cʉ ñe, ne aá, weje tʉjaropʉ cʉ cajĩa rocacõañuparã, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’To bairona cʉ cacoteboja rotibatana rooro na cáto, tunu ejaʉpʉ, ¿dope bairo nare átacʉmi weje ʉpaʉ, mʉja ĩ tʉgooñati? na caĩ jeniñawĩ Jesu sacerdote maja ʉparãre, cabʉcʉrã carotirãre. ");
INSERT INTO tav_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","To bairo na cʉ caĩ jeniñaro ocõo bairo cʉ caĩwã: —To bairo rooro majuu cátanare na bopaca tʉjʉquẽcʉna na jĩa rericʉmi. Na jĩa re, aperã macare caroaro cacoteparãre carica cʉtopʉ cariape cʉ yere cajooparã macare na coteboja rotiricʉmi, cʉ caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","To bairo na caĩro ocõo bairo na caĩwĩ Jesu cʉ̃re na cabooquẽtiere na ĩ buio majioʉ: —Dio Wadariquepʉ ati wame ĩ ucariquere mʉja bue tʉgaricarã. Tiere tʉgooñaña: Ʉ̃ta wiire cawerã jĩca ʉ̃taa tʉjʉri, “Tia ñuuquẽe,” ĩrã carocacõañuparã. Tia na carocaricarena caneñuparã aperã, “Ñuu majuucõa,” ĩrã. To bairi wii pucua cãniparore ape rupaa jʉgoye cawe peoyuparã, tia mani cacõoñarica anigaro ĩrã. Mani Ʉpaʉ Dio cʉ cátaje ã. Tiare cʉ cane we peoro caroaro jã tʉjʉ wariñuu. ’To bairona ĩ ucarique ã yʉ cabaipere buio jʉgoyeyerique, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—To bairi ocõo bairi wame cariape mʉjaare yʉ ĩ: Dio ye, Ʉpaʉ cʉ cãnie quetire mʉjaare cʉ cacũbatajere mʉja emari, aperã macare na joogʉmi caroaro cʉ caboorijere cátiparã macare. Na maca weje macaje caricacʉto cʉ yere cajooparãre bairo caroaro átigarãma. ");
INSERT INTO tav_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ʉ̃taa, mʉjaare yʉ caĩetopʉre noa capʉga tu roca cumurãre na õwa pecoaboro. Tia na bui to caroca pearo na roca mʉto recõagaro, na caĩwĩ Jesu, cʉ̃re catʉjʉ rocarã na majuuna na capopiye tamʉopere na ĩ buioʉ jʉgoyeyei. ");
INSERT INTO tav_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdote maja ʉparã, fariseo maja to bairo cʉ caĩ queti buio majiori wamerire apirã, “Manirena ĩimi,” caame ĩwã. ");
INSERT INTO tav_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","To bairi Jesure cañegabama. Ñegabana quena ocõo bairo caame ĩwã: —Camaja, “Dio cʉ cajooricʉ ãcʉmi, Dio ye quetire cabuioʉ ãcʉmi,” cʉ ĩ tʉgooñama camaja. To bairi Jesure mani cañeata rooro mani átiborãma, caame ĩwã. To bairi camajare uwibana cʉ cañequẽma mai. ");
INSERT INTO tav_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu na caĩ buionemowĩ, queti buio majiorica wamerire. Ocõo bairo na caĩ buionemowĩ: ");
INSERT INTO tav_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ʉpaʉ Dio cʉ cãnie jĩcaʉ macá ʉpaʉ cʉ cabairore bairona ã. Cʉ macʉ cʉ cawamo jiaro boje rʉmʉ cájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","To bairi quenoo jʉgoyeye yaparo ocõo bairo caĩñupʉ cʉ paa coteri majare: “Boje rʉmʉ yʉ capiena mere na aparo. Na pirãja.” To bairo cʉ caĩ jooricarã nare na cabuiobato quena cáatígaquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","To bairo na cáatígaquẽto apii aperã cʉ paa coteri majare na caĩñupʉ tunu: “Yʉ capienare na buiorãja, ‘Mere ʉgariquere yʉ quenoo yaparowʉ. Wecʉa yʉ canuena caroaro caricʉnare jĩari yʉ quenoo yaparowʉ. Ʉgarique nipetiro yʉ quenoo yaparowʉ. Yʉ macʉ cʉ cawamo jiari boje rʉmʉ mere na tʉjʉra aparo,’ na ĩ buiorãja,” na caĩñupʉ cʉ paa coteri majare. ");
INSERT INTO tav_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","To bairo cʉ caĩro cʉ capiricarãre na cabuiora aábajuparã tunu. Na capirije to cãnibato quena cáatígaquẽjuparã. Noo na cabooro maca cáaájuparã. Jĩcaʉ cʉ wejepʉ cáaájupʉ. Apeĩ cʉ apeye joorica wiipʉ cáaájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aperã ʉpaʉ cʉ capi rotibatana paa coteri majare na ñe, rooro na quẽ, na cajĩa recõañuparã. ");
INSERT INTO tav_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","To bairo nare na cáto caʉpaʉ na punijini, tuti maca, cʉ polisía majare na joo, cʉ paa cotebojari majare cajĩaricarãre nare re roti, na ya maca macaje, na ye wiirire na cajoe rotiyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","To bairo átiri aperã cʉ paa coteri majare ocõo bairo na caĩñupʉ tunu: “Yʉ macʉ cʉ cawamo jiari boje rʉmʉ macaje yʉ caquenoo yaparorije to cãnibato quena yʉ capibaena na majuuna atígaquẽjupa. To bairi ñuuquẽema. Na atíqueticõato yua. ");
INSERT INTO tav_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","To bairi na pirãja maca recomaca cãni wãri noa cáaáteñarã mʉja catʉjʉ bʉgarãre,” na caĩñupʉ na ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","To bairo na cʉ caĩro maca recomaca cãni wãripʉ aá, noa na catʉjʉ bʉgarãre na capiyuparã. Caroorã, caroarã quena nipetirã noa na catʉjʉ bʉgarãre na capiyuparã. To bairo na cáto na ʉpaʉ ya wii boje rʉmʉ cʉ cáti wii cajirayupe. ");
INSERT INTO tav_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’To bairi ʉpaʉ cajãa ejayupʉ, boje rʉmʉ cánare na tʉjʉ ejaʉ. Na tʉjʉ, wamo jiarica boje rʉmʉ macaje jutii cabero cabopacarã cʉ capiricarãre cʉ cawapaye bojabatajere jĩcaʉ cajañaquẽcʉre na watoapʉ catʉjʉyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Cʉ tʉjʉ, ocõo bairo cʉ caĩñupʉ: “¿Nope ĩi wamo jiarica boje rʉmʉ macaje jutii yʉ cawapaye bojabatajere jañaquẽcʉna mʉ atí?” cʉ caĩñupʉ ti maca ʉpaʉ. To bairo cʉ caĩro dope bairo caĩ yʉ́ majiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","To bairi boje rʉmʉ ʉpaʉ cʉ paa coteri majare ocõo bairo na caĩñupʉ: “Cʉ ñeña. Cʉ wamori, cʉ rʉpori jiari jõ macapʉ canaitĩaropʉ cʉ rocacõaña. Topʉ seeto majuu tʉgooñarique pai otigʉmi popiye tamʉobacʉ,” caĩñupʉ maca ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’To bairona ã Ʉpaʉ Dio cʉ cãnie. capãarã ãma Dio cʉ capibatana. To bairo capãarã na cãnibato quena jĩcaarãacã ãma cʉ mena cãniparã cʉ cabejerã, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cabero fariseo maja wadapenirã caneñapoyuparã. “Camajiriorijere cʉ mani cajeniñaro manire yʉ́ majiquẽcʉmi Jesu. To bairo cariape manire cʉ cayʉ majiquẽto, ‘Carooʉ ãmi, cabai buicʉcʉ ãmi Jesu,’ ʉparãre cʉ mani ĩ wadajãgarã.” To bairo dope bairo cʉ̃re na cajeniñape caame wadapeniñuparã. ");
INSERT INTO tav_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To bairi wadapeni yaparo na buerãre cajoowã, maca ʉpaʉ Herode — Roma macana na cacũricʉ ya poa macana mena, Jesure na cajeniña rotiyuparã. To bairi na cajeniña rotiricarã ocõo bairo cʉ caĩ jeniñawã Jesure: —Ʉpaʉ, cariape mʉ buionucu. Dio yere cariapena camajare cabuioʉ mʉ ã. “To bairona na yʉ caĩ buioro yʉ tutiborãma,” mʉ ĩ tʉgooñaquẽe. Camaja jĩcarore bairo na mʉ tʉjʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To bairi mʉ jeniñarã anaa jã baiwʉ. Roma macana ʉparã jãre carotirã niyeru jãre na cajenirijere nare jã cawapayepe ¿Dio cʉ rotibocʉti? cʉ caĩ jeniñawã fariseo maja, Herodere camairã na cajeniña roti jooricarã. ");
INSERT INTO tav_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesu maca rooro cʉ na cátigarijere tʉjʉ majicõari ocõo bairo na caĩwĩ: —¿Nope ĩrã, roorije Jesu cʉ ĩ bui cʉparo ĩrã yʉre mʉja jeniñati? Caĩto pairã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Caajiyari cui ʉparã ye cãnipe na cawapayepa cui uno yʉ iñooña, na caĩwĩ Jesu. To bairo cʉ caĩro caajiyari cuire ne, cʉ caiñoowã. ");
INSERT INTO tav_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ti cui cʉ̃re na caiñooro: —¿Ñamʉ cʉ cabaurije to bauti? ¿Ñamʉ wame to tujati ati cuire? na caĩ jeniñawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Ʉpaʉ majuu Roma macacʉ cʉ cabaurije ã. Cʉ wame tuja, cʉ caĩwã. To bairo cʉ na caĩro: —Gobierno macacʉ ʉpaʉ cʉ ye cãnipere cʉ jooya. Dio ye mʉja cʉ cajenirije quenare cʉ cajoope ã, na caboca ĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","To bairo na cʉ caboca ĩ yʉrijere caapi acʉawã. Api acʉari cʉ cabuti weocoama yua. ");
INSERT INTO tav_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti rʉmʉ cãnona saduceo maja Jesure cajeniñarã ejawã. Camaja bai yajiri bero tunu catíquẽnama, caĩ tʉgooñarã ãma saduceo maja. To bairi Jesu tʉpʉ atí, ocõo bairo cʉ cajeniñawã: ");
INSERT INTO tav_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ʉpaʉ, Moisé tirʉmʉpʉ macacʉ ocõo bairi wame cʉ caĩ cũrica wamere mʉre jã jeniñapa: “Jĩcaʉ nʉmocʉti, punaa mácʉna cʉ cabai yajiro cʉ bai maca cʉ nʉmo cʉparo cʉ jʉgocʉ nʉmo cãnibatacore. Cõre cʉ canʉmocʉto bero na camacʉcʉto, ‘Cabai yajiricʉ ãnacʉ macʉ ãmi,’ cʉ ĩ tʉjʉgarãma,” caĩ cũñupi Moisé. ");
INSERT INTO tav_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To bairi jã mena macana jĩcaʉ punaa siete cãnacãʉ cãma. To bairi cajʉgocʉ canʉmocʉmi. Punaa mácʉna cabai yajiwĩ. ");
INSERT INTO tav_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Punaa mácʉna cʉ cabai yajiro bero cʉ bai cawapearicore canʉmocʉmi. Cʉ quena punaa mácʉna cabai yajiwĩ. Cabero na bairã quena to bairo jetona cõre nʉmo cʉtiba, punaa manana cabai yaji peticoama. ");
INSERT INTO tav_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na cabai yaji petiro bero to cõona na nʉmo cãnibataco co quena cabai yajiwõ yua. ");
INSERT INTO tav_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na nipetirã siete cãnacãʉpʉna cõre canʉmo cʉtibama. To bairo cabai yajiricarã catí tunurãpʉ ¿ni maca cõre co cʉ nʉmo cʉtibocʉti? Jesure cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","To bairo cʉ na caĩ jeniñaro ocõo bairo na caĩ buiowĩ Jesu: —Baiquẽe. Dio Wadariquere mʉja api majiquẽe. Dio cʉ cáti majirije quenare mʉja majiquẽe. ");
INSERT INTO tav_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cabai yajirã catí tunurãpʉ canʉmoa cʉtiquẽna, camanapʉa cʉtiquẽna anigarãma. Dio tʉ macana ángel majare bairona cabairã anigarãma. ");
INSERT INTO tav_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apeye mʉjaare yʉ buiopa Dio yarã na cʉ catunu catiopere. Dio Moisépʉre cʉ caĩrica wame mʉja bue tʉgaricarã. ");
INSERT INTO tav_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ocõo bairo caĩñupi Dio Moisére: “Yʉa Diona yʉ ã, mʉ ñicʉ jãa na Ʉpaʉ yʉ ã. Abraham Ʉpaʉ yʉ ã. Cʉ macʉ Isaá Ʉpaʉ yʉ ã. Cʉ pãrami Jacobo quena to bairona cʉ Ʉpaʉ yʉ ã.” Na yeri cʉ tʉpʉ aniri cʉ̃re canʉcʉbʉgorã na cãno to bairona cacatirãre bairo, “Na Ʉpaʉ yʉ ã,” na ĩricʉmi Dio cabai yajiricarã na cãnibato quena. Cacatirã jeto Diore canʉcʉbʉgorã ãma. Caria yajiricarã cayeri mana cʉ nʉcʉbʉgo majiquẽnama. To bairi na ãnana cabai yajiricarã anibana quena catirãma Dio tʉpʉ, na caĩwĩ Jesu saduceo majare. ");
INSERT INTO tav_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","To bairo caroaro majirique mena Jesu na cʉ caĩ buioro camaja caapi acʉacoama. ");
INSERT INTO tav_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceo majare Jesu caroaro majirique mena cʉ caboca ĩro dope bairo cʉ caĩ yʉ́ majiquẽma yua. To bairo saduceo maja Jesure na caĩ yʉ́ majiquẽto apirã fariseo maja maca caneñapowã tunu, ape wame cʉ na caĩ jeniñapa wame wadapenirã. ");
INSERT INTO tav_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","To bairi jĩcaʉ na yaʉ caroaro Moisé cʉ carotiriquere camajii, roorije Jesu cʉ ĩ bui cʉparo ĩi, ocõo bairo cʉ caĩ jeniñawĩ: ");
INSERT INTO tav_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ʉpaʉ, Dio cʉ carotirique ¿di wame ape wame netoro cátipa wame to ãti? cʉ caĩ jeniñawĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","To bairo cʉ caĩ jeniñaro: —“Mʉja Ʉpaʉ Diore cʉ maiña. Mʉja tʉgooñariquepʉ, mʉja yeripʉ, Diore cʉ mʉja camai tʉgooña majiro cõona Diore cʉ maiña.” ");
INSERT INTO tav_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ti wame ã Dio cʉ carotirique cãni majuuri wame. Ape wame Dio cʉ carotirica wame netoro ti wame cátipe ã, “Diore cʉ maiña,” ĩrique. ");
INSERT INTO tav_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Cabero macá wame to bairona cátipe ã: “Aperãre na maiña. Mʉja majuuna mʉja camairore bairona na maiña.” ");
INSERT INTO tav_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ti wameri Dio cʉ carotirique cãni majuuri wameri ã. Apeye Dio rotirique Moisé ãnacʉ cʉ caĩ cũrique, Dio ye quetire caĩ buioricarã quena na caĩ ucarique nipetiro ti wameri átaje jetore buio majiorique ã. Apeye nipetiro Dio cʉ carotiriquere mʉja átiborã, Diore mʉja camaiata, aperã quenare na mʉja camaiata, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","To bairi fariseo maja topʉ cãnare ocõo bairo na caĩ jeniñawĩ Jesu: ");
INSERT INTO tav_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Dope bairo mʉja tʉgooñati Dio cʉ cajoʉ Cristo Dio ye quetire cabuioricarã tirʉmʉpʉ macana na caĩricʉre? ¿Ñamʉ pãrami ãcʉmi mʉja tʉgooñati? na caĩwĩ Jesu. To bairo na cʉ caĩ jeniñaro: —Ʉpaʉ David tirʉmʉpʉ macacʉ pãrami ãcʉmi, caĩwã fariseo maja. ");
INSERT INTO tav_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","To bairo cʉ na caĩro ocõo bairo na caĩwĩ Jesu: —Ʉpaʉ David ãnacʉ, “Yʉ Ʉpaʉ ãmi,” cʉ caĩñupi Cristore, Dio cʉ cajoopaʉre ĩ buio jʉgoyeyei. ¿Nope ĩi cʉ pãrami cʉ cãnibato quena, “yʉ Ʉpaʉ,” cʉ̃re cʉ caĩñupari? Ocõo bairo caĩ ucayupi David ãnacʉ Espíritu Santo cʉ caĩ rotiro mena: ");
INSERT INTO tav_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ato yʉ mena ruiya yʉ tʉ maca, yʉ mena carotii anigʉ. Yʉ mena ruiri mʉ carotiro mʉre catʉjʉ tutirãre na yʉ regʉ,” caĩñupʉ Dio yʉ Ʉpaʉre, caĩ ucayupi David tirʉmʉpʉ macacʉ. ");
INSERT INTO tav_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ti wame ĩi, “Ʉpaʉ,” caĩ ucayupi David, Dio cʉ cajoopaʉ Cristore. To bairo, “Ʉpaʉ,” David cʉ caĩata ¿dope bairo cʉ pãramipʉ cãcʉ maca Cristo cʉ anibocʉti? na caĩwĩ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","To bairo cʉ caĩro dope bairo Jesure cʉ caboca ĩ majiquẽma. Atie bero camaja nipetirã to bairi wame cʉ caĩ jeniña uwiwã yua. To bairi cʉ caĩ jeniña janacõawã. ");
INSERT INTO tav_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cabero cʉ buerãre, aperã to cãna paarãacãre ocõo bairo jã caĩ buiowĩ Jesu: ");
INSERT INTO tav_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Judío majare cabuerã, fariseo maja quena, “Moisé cʉ carotiriquere aperãre cabuiorã jã ã,” ĩ tʉgooñama na majuuna. ");
INSERT INTO tav_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","To bairi na cabuiorijere cátiparã mʉja ã. To bairona na cátore bairo átiquẽja paro. Rotibana quena na majuuna átiquẽema na cáti rotibatiere. To bairi nare bairo aniqueticõaña mʉjaa. ");
INSERT INTO tav_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Apeye áti rotima camajiriori wame. To bairi na cáti rotirijere átibana quepe netocoapa camaja. Na quena fariseo maja quena, judío majare cabuerã quena na majuuna átigaquẽema na majuuna na cáti rotirijerena. ");
INSERT INTO tav_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Apeye quena áti nʉcʉbʉgorica wame jã cáto camaja jãre na tʉjʉato ĩrã baitoma. To bairi Dio Wadarique caucarique cʉtiere jiama na riya bui, na wamoripʉ, camaja, “Caroaro Diore canʉcʉbʉgorã ãnama,” jãre na ĩ tʉjʉato ĩrã. Caroa wẽri quenare enucuma na jutii yeparipʉ, camaja caroa jutii jã cajañarijere na tʉjʉato ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Boje rʉmʉ cãno neñapo ʉgarica wiipʉ aána, ʉparã ye cumu pãiripʉ jeto ruigama. Neñapo buerica wiiripʉ aána quena to bairona baicoama. ");
INSERT INTO tav_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Maca recomacapʉ aána quena camaja nipetirã caroaro na cañuu roti nʉcʉbʉgoro booma. “Cabuerã,” aperã nare na caĩ nʉcʉbʉgoro quenare booma. ");
INSERT INTO tav_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Mʉja maca, “Cabuerã,” aperã mʉjaare na ĩ nʉcʉbʉgo rotiquẽja. Jĩcaʉna ãmi Dio mʉjaare cabuei majuu. Mʉjaa jĩcaʉ punaa jĩcarore bairona cabairã mʉja ã cʉ̃re caapi nʉcʉbʉgorã. ");
INSERT INTO tav_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aperãre na ñuu rotirã, “Jã Pacʉ,” caĩ nʉcʉbʉgoquetiparã mʉja ã. Jĩcaʉna ãmi mani Pacʉ ʉmʉrecoo macacʉ, “Jã Pacʉ,” mani caĩ nʉcʉbʉgopaʉ. ");
INSERT INTO tav_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","To bairona, “Ʉparã,” aperã mʉjaare na ĩ nʉcʉbʉgo rotiquẽja. Jĩcaʉna yʉ ã mʉja Ʉpaʉ, Dio cʉ cajooricʉ. ");
INSERT INTO tav_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nii mʉja mena macacʉ cãni majuʉ anigʉ paari majocʉ cʉ ãmaro. ");
INSERT INTO tav_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jĩcaʉ, “Cãni majuʉ yʉ ã, caʉpaʉ, cãni jʉgoʉ yʉ anigʉ,” caĩ tʉgooñaʉ ũcʉ macare cawatoa cãcʉre bairona cʉ cũgʉmi Dio. “Cawatoa cãcʉ yʉ ã. Caʉpaʉ yʉ aniquetigʉ,” caĩ tʉgooñaʉ ũcʉ macare ʉpaʉre bairona cabaii cʉ cũgʉmi Dio, caĩwĩ Jesu jãre cʉ buerãre, aperã camaja paarãacã to cãna quenare. ");
INSERT INTO tav_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Cabero ocõo bairo caĩwĩ Jesu judío majare cabuerãre, fariseo maja quenare: —Rooro mʉjaare baigaro. Caĩto pairã mʉja ã. Camajare na ĩtorã Dio yarã majuu na cãniquẽto mʉja áa. To bairi Dio tʉpʉ jãarica jope turicarore biarãre bairona mʉja áa. Aperã quenare Dio tʉpʉre na cáaáquẽto mʉja áa. Mʉja quena mʉja aáquetigarã. Cariape Dio yere átiquẽna cʉ tʉpʉ mʉja aáquetigarã. Jocarãna ĩtori aperãre na ĩ buiorã na quena Dio tʉpʉ cáaáboparãre camatarã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Cawapearicarã romiri cabopacoorã romirire apeye uniere na joorã pairo majuu mʉja wapa jeninucu. To bairo na yere na cacʉgorijere cajee pairã anibana quena Dio wiipʉre jãa aána yoaro Diore mʉja jeni nʉcʉbʉgoto, baitorique bairã camaja na catʉjʉro. Seeto mʉja popiyeyegʉmi Dio jocarãna to bairona mʉja cabai nʉcʉbʉgotorije wapa, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ocõo bairo na caĩnemowĩ Jesu judío majare cabuerãre, fariseo maja quenare: —Caĩto pairã mʉja ã. Cayoaropʉ aperopʉ cãni macaripʉre mʉja aánucu, mʉja ya wamere buio teñarã aána. Aperã jã cabuiorijere na api nʉcʉbʉgoato ĩrã, mʉja buio teñanucu. To bairo mʉja cabuiorijere caapiʉjarã mʉja netoro caĩtorijere caapiʉjarã ãnama. To bairo mʉja caĩ jocarijere caapiʉjarã aniri rooro popiye tamʉogarãma caroorã ya paʉpʉre. ");
INSERT INTO tav_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’ “Aperãre cabue majirã jã ã,” jocarãna mʉja ĩ. Dio yere caapi majiquẽna maca mʉja ã. To bairi catʉjʉ majiquẽna aperã catʉjʉ majiquẽnare catʉ̃ga jʉ́go aánare bairona mʉja bai. Ocõo bairo mʉja ĩ: “Jĩca wame, ‘Jocʉ mee yʉ átigʉ,’ ĩ cũʉ, ‘Dio wii mena yʉ ĩ,’ jĩcaʉ cʉ caĩbato quena caroorije me ã cʉ caĩbata wamere cʉ cátiquẽpata. Apeĩ maca, ‘Jocʉ mee, yʉ átigʉ,’ ĩ cũʉ, ‘Dio wii cãnie caajiyarije mena yʉ ĩ,’ cʉ caĩ cũata cʉ caĩ cũri wamere bairona cátipaʉ ãmi,” mʉja ĩnucu. ");
INSERT INTO tav_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Cariape mee mʉja ĩ. Camajiquẽna mʉja ã. Dio wii macaje caajiyarije cátiya manie ã. Dio wii maca cãni majuuri wii ã. Ti wiipʉ cãnie caajiyarije netoro cãni majuuri wii ã. ");
INSERT INTO tav_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ape wame quena ocõo bairo mʉja ĩ: “Jĩca wame, ‘Jocʉ mee yʉ átigʉ,’ ĩ cũʉ, ‘Waibʉcʉ joe buje mʉgo joorica tutu mena yʉ ĩ,’ cʉ caĩ cũbato quena caroorije me ã cʉ caĩ cũbata wamere cʉ cátiquẽpata. Apeĩ maca, ‘Joe buje mʉgo joorica tutu bui Diore cajoopaʉ waibʉcʉ mena yʉ ĩ,’ cʉ caĩ cũata cʉ caĩ cũrica wamere bairona cátipaʉ ãmi,” mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Camajiquẽna majuu mʉja anicõa. Cariape mʉja ĩquẽe. Ti tutu cãni majuurije ã tia bui waibʉcʉ peoricʉ netoro. ");
INSERT INTO tav_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","To bairi, “Dio wiipʉ cãni tutu mena jocʉ mee yʉ ĩ,” ĩrã tia bui waibʉcʉ joe buje mʉgo jooricʉ menare mʉja ĩborã. ");
INSERT INTO tav_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","To bairona, “Jocʉ mee, Dio wii mena yʉ ĩ,” ĩ cũrã, “Dio mena yʉ ĩ,” caĩ cũrãre bairona mʉja ĩ, ti wii macacʉ Dio cʉ cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","“Ʉmʉrecoo mena yʉ ĩ,” ĩ cũrã, “Dio cʉ ya paʉ mena yʉ ĩ,” caĩ cũrãre bairona mʉja ĩ. Topʉ macacʉ Dio quenare, “Dio mena yʉ ĩ,” caĩrãre bairona mʉja ĩborã, ʉmʉrecoo macacʉ cʉ cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’To bairi rooro majuu mʉjaare baigaro judío majare cabuerã, fariseo maja quenare. Cabaitorã mʉja ã. Nipetiri wame mʉja caoterique pʉga wamo cãnacã carica cʉtiere jĩca mʉja joonucu Diore. To bairona mʉja átinucu mʉja cacʉgorijeacã quenare. Menta na caĩrijeacã, anís na caĩrijeacã, comino na caĩrijeacã quenare cawapa maniere caroaro cõoñari mʉja joonucu Diore. Cawapa maniere cõoñari Diore joobana quena Dio cʉ carotirique majuure mʉja apiʉjaquẽe. Aperãre cariape átaje, aperãre bopaca tʉjʉrique, Diore api nʉcʉbʉgorique macare mʉja tʉgooñaquẽe. Tie maca Dio cʉ carotirique majuure caroaro tʉgooñari mʉjaare cátipe nibapa, apeye unie Diore joo janaquẽnana. ");
INSERT INTO tav_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Catʉjʉ majiquẽna aperã catʉjʉ majiquẽnare catʉ̃ga jʉ́go aánare bairona mʉja bai, aperãre Dio yere na buiogabana. Mʉja majuuna Dio yere caapi majiquẽna mʉja ã. To cãnacã wameacãre mʉja cátipere tʉgooñabana quena Dio cʉ caboorije majuu mʉja tʉgooñaquẽe. To bairona bairã, mʉja ʉgarica bapapʉre becoacã cʉ cajañaro ʉgagarã jʉgoye cane rocarãre bairona mʉja bai. Baibana quena carooʉ capaii majuu cʉ cajañaro cʉ tʉjʉquẽnana cʉ menana caʉga rocacõarãre bairona mʉja áa. ");
INSERT INTO tav_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Cabaitorã majuu mʉja ã. “Caroarã ãma,” jãre na ĩato ĩrã mʉja átitonucu, mʉja yeri macaje caroorijere áti janagaquẽnana. To bairo ána jotʉ cabuire caroaro cojerica jotʉre bairona mʉja ã. Baibana quena pupea macare jotʉ cacojeya mani rʉre bairona mʉja bai. Mʉja yeri macare caroorije pairã mʉja ã. Aperã yere mʉja emanucu, mʉja majuuna cʉgo wariñuugarã. To bairi rooro majuu baigaro mʉjaare judío majare cabuerã, fariseo maja quenare. ");
INSERT INTO tav_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉja tʉgooña majiquẽe. Mʉja yeri macaje macare caroare cátiparã mʉja anibapa. To bairo mʉja cápata aperã, “Caroarã ãma,” mʉja ĩ tʉjʉborãma. ");
INSERT INTO tav_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’To bairi rooro mʉjaare baigaro judío majare cabuerã, fariseo maja quenare. Caĩto pairã mʉja ã. Camaja yaa rocarica paʉrire bairona mʉja bai. Cabui maca ʉ̃ta nʉcorique, cabotirije mena caroaro warerique to cãnibato quena pupea maca caboaricarã õwa ãnaje, caʉnirije jeto ãnore bairona mʉja bai, mʉja yeripʉ caroorã aniri. ");
INSERT INTO tav_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","To bairi aperã caroare mʉja cátitorijere tʉjʉrã, “Caroarã ãnama,” mʉja ĩ tʉjʉrãma. Caroarã mʉja na caĩ tʉjʉrije to cãnibato quena mʉja yeripʉre caĩto pairã, caroorije pairã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’To bairi rooro mʉjaare baigaro judío majare cabuerãre, fariseo maja quenare. Caĩto pairã mʉja ã. Tirʉmʉpʉ macana Dio ye quetire buiori maja ãnana, aperã Diore caapi ʉjaricarã ãnana na cayaa rerica paʉrire caroaro quenoo átiri, ocõo bairo mʉja ĩ: ");
INSERT INTO tav_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Mani ñicʉa Dio ye quetire buiori majare cajĩaricarã cãñupa. Mani ñicʉa na cãni yʉtea macana mani cãmata na mani jĩa renemoqueti boricarã,” mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","To bairo ĩrã, “Nare cajĩaricarã pãramerã jã ã,” mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To bairi na cajĩaricarore bairona mʉja jĩanemogarã. ");
INSERT INTO tav_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Caroorã majuu mʉja ã. To bairi mʉjaare Dio cʉ capopiyeyepere mʉja ruti majiquetigarã. ");
INSERT INTO tav_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","To bairi mʉja tʉpʉ yʉ joonemogʉ Dio ye quetire cabuioparãre, aperã Dio yere caroaro camajirãre, aperã mʉjaare cabueparãre. Yʉ cajoorã na cãnibato quena na mʉja nʉcʉbʉgoquetigarã. Yucʉ tẽorica pãipʉ na mʉja papua jĩa regarã jĩcaarãre. Aperãre na mʉja bapegarã wecʉa ajeri wẽri mena mʉja neñapo buerica wiiripʉre. Aperãre na mʉja popiyeyegarã to cãnacã maca noo na mʉja cabʉgaropʉ. ");
INSERT INTO tav_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mʉja ñicʉ jãa quena caroarãrena na cajĩañupa. Cajĩa jʉgoyupa Abel cawamecʉcʉre. Cʉ jĩari bero aperãre na jĩa, aperãre na jĩa, Sacaríare cajĩa tʉjayupa yua. Cʉ cajĩañupa Dio wiipʉ na cajoe buje mʉgorica tutu tʉacãpʉ. Mʉja quena nare bairona cána mʉja ã. To bairi mʉja quena caroarã na cajĩarique mʉja bai buiyebʉja. ");
INSERT INTO tav_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cariape mʉjaare yʉ buio. Mʉja cabuicʉtie wapa popiye tamʉorique mʉja anigaro ati yʉtea macanare. ");
INSERT INTO tav_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mʉjaa Jerusalén macana, Dio ye quetire cabuiorãre cajĩa rerã mʉja ã. Aperãre mʉja tʉpʉ Dio cʉ cabuio roti joobanare ʉ̃ta rupaa mena care jĩarã mʉja ã. Mʉjaare maii seeto yʉ tʉpʉ mʉjaare yʉ pi neogabapʉ. Ãboco co punaacãre maio, co querʉpʉri mena co cañu matarore bairona mʉjaare yʉ átigabapa. Mʉja booquẽe. ");
INSERT INTO tav_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yucʉra mʉja ya macare rocacõagarãma aperã. ");
INSERT INTO tav_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cariape mʉjaare yʉ ĩ: To cõona yʉre mʉja tʉjʉ tʉja. Yʉre mʉja tʉjʉnemoquetigarã ati yepapʉ yʉ catunu atíparo jʉgoye. Ti paʉ cãno tunu yʉre tʉjʉnemorã ocõo bairo yʉre mʉja ĩgarã: “Cajʉgoyepʉ Dio, ‘Cʉ yʉ joogʉ,’ cʉ caĩricʉna ãmi Jesu. Caroaʉ majuu ãmi,” yʉre mʉja ĩgarã, na caĩwĩ Jesu Jerusalén macanare. ");
INSERT INTO tav_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Cabero Dio wii cãnacʉ cabutiwĩ Jesu. Cʉ cáaágari paʉna cʉ buerã cʉ tʉpʉ atí, Dio wii macá arʉri: —Atie caroa macaje majuu, tʉjʉya, cʉ̃re jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","To bairo cʉ jã caĩro ocõo bairo jã caĩwĩ Jesu: —Cariape mʉjaare yʉ ĩ. Atie mʉja catʉjʉrije aperã re peocõagarãma. Jĩca ʉ̃taa maca apea bui pejanucu baiquetigaro, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cabero Jesu mena jã cáaápʉ Olivo na caĩricʉ, macá tʉjaro cãnii ʉ̃taʉpʉ. Topʉ aperã jã mena na cãniquẽtopʉ cʉ buerã jã jeto cʉ mena jã cãmʉ. To bairi topʉ cʉ caruiropʉ cʉ tʉpʉ atí, Jesure jã caĩ jeniñawʉ: —Jãre buioya. ¿Noo cõopʉ mʉ caĩeje to bairoati? ¿Dope bairo jã majirãati ati yepapʉ mʉ catunu atíparo jʉgoye, ati ʉmʉrecoo capetiparo jʉgoye? cʉ̃re jã caĩ jeniñawʉ. ");
INSERT INTO tav_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","To bairo jã caĩro ocõo bairo jã caĩ buiowĩ Jesu: —Aperã mʉjaare na caĩtorijere mani apiʉjare ĩrã caroaro tʉgooña majiña. ");
INSERT INTO tav_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","capãarã ĩtori, “Dio cʉ carotiro mena yʉ áa, Dio cʉ cajooricʉ majuu, Cristo yʉ ã,” caĩtorã anigarãma. Na caĩtorijere apiʉjagarãma camaja capaarã. ");
INSERT INTO tav_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Camaja ame quẽri ame jĩagarãma. Ape paʉri, ape paʉri to bairo jeto ame quẽrique to bairo na cátiere mʉja queti apigarã. To bairo cabairije apirã uwi tʉgooñaquẽja. To bairo jeto anigaro ati yʉtea capetiparo jʉgoye. Petoacã rʉjagaro mai. ");
INSERT INTO tav_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jĩca maja ape maja mena ame quẽgarãma. Jĩcaʉ ʉpaʉ cʉ yarã jãa apeĩ ʉpaʉ cʉ yarã mena ame quẽgarãma. Ati yepa nipetiro to bairo jeto átigarãma. Ape paʉripʉ ʉgarique camano ñigo boagarãma. Ape paʉri yepa nanaagaro. ");
INSERT INTO tav_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","To bairo camaja seeto na catamʉori wameri to cãnibato quena capee majuu na catamʉope rʉjagaro mai. ");
INSERT INTO tav_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ti paʉ cãno yʉ ye quetire caapiteerã mʉja ñe aágarãma ʉparã tʉpʉre, na popiyeyeya ĩrã. Mʉja jĩagarãma. Yʉre caapiʉjarã mʉja cãno maca to cãnacã maca macana mʉja teegarãma. ");
INSERT INTO tav_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti paʉ cãno capaarã, “Cristore caapiʉjaʉ yʉ ã,” caĩbatana janagarãma, apiʉjaquetibana. To bairo baibana cajʉgoye na caame bapa cʉtibatanarena ʉparãre na wadajãgarãma. To bairi ame tʉjʉ tutigarãma. ");
INSERT INTO tav_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aperã capaarã, “Dio ye quetire cabuioʉ yʉ ã,” jocarãna ape wame macare caĩ buiorã anigarãma. To bairo na caĩtorije to cãnibato quena camaja capaarã na apiʉjagarãma. ");
INSERT INTO tav_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Caroorije átaje seeto majuu aninemo nutuagaro. To bairo cabai nutuato camaja capaarã Dio ye quetire caapibatana cʉ̃re nʉcʉbʉgo janagarãma. Na majuu quena to bairona ame nʉcʉbʉgo janagarãma. ");
INSERT INTO tav_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","To bairo capaarã cajanarã na cãnibato quena noa tʉgooña tutuari yʉ ye quetire caapi nʉcʉbʉgo janaquẽna macare na netoogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","To bairi ati ʉmʉrecoo capetiparo jʉgoye yʉ ye quetire ati yepa macanare to cãnacã poa macanare na cabuiope anigaro. To cãnacã poa macana na caqueti api petiro bero to cõo ati ʉmʉrecoo petigaro yua, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ocõo bairo Jesu jãre cʉ caĩnemorije yʉ Mateo atiere yʉ caucariquere cabuerã caroaro na api majiato: —Dio ye quetire buiori majocʉ Daniel cawamecʉcʉ tirʉmʉpʉ macacʉ cabuio jʉgoyeyeyupi jĩcaʉ carooʉ majuu ati ʉmʉrecoo capetiparo jʉgoyeacã macacʉ. Dio wiipʉ anigʉmi. Topʉna caroorije átiri Dio wii macajere epe regʉmi. ");
INSERT INTO tav_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","To bairo cabairi paʉ Judea yepapʉ cãna ʉ̃ta yucʉpʉ na ruti aáparo. ");
INSERT INTO tav_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Noa wii bui cãni arʉapʉ cãna uwaro atʉ rutiri na apeye quenoo jee aáqueticõato. ");
INSERT INTO tav_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aperã noo wejeripʉ paari maja quena na wiiripʉ na apeyere jeerã tunu aáquẽnana uwaro na ruti aáparo ʉ̃ta yucʉpʉ. ");
INSERT INTO tav_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Popiye tamʉogarãma ʉta pacoa romiri, aperã caũpurãacãre capʉjarã quena, atʉrique mena ruti aá majiquetibana. ");
INSERT INTO tav_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mʉja carutiri paʉ camajirioqueti rʉmʉ to cãniparore bairo Diore cʉ jeniya. Cajoori rʉmʉ o judío maja na capaa rotiqueti rʉmʉ to aniqueticõato ĩrã Diore cʉ jeniya. ");
INSERT INTO tav_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ti paʉ cãno rooro majuu popiye tamʉogarãma camaja. Ati yepapʉ nemoacãpʉre to cõo popiye tamʉorique camañupa. Ti paʉ beropʉ quenare to cõo popiye tamʉorique manigaro tunu. ");
INSERT INTO tav_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","To bairi rooro majuu cabairijere Dio cʉ cajanaoquẽpata camaja nipetirã yaji peticoaborãma. Jĩcaʉ maca catiquetiboʉmi. To bairi Dio yarã cãniparãre cʉ cacũrã na cacatiparore bairo ĩi to cõo ti rʉmʉri popiye tamʉorica rʉmʉrire jana rotigʉmi Dio yua. ");
INSERT INTO tav_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ti paʉ cãno ĩgarãma aperã: “Jĩpʉ ãmi Cristo, Dio cʉ cajooricʉ,” o, “Jõ ãñupʉ Cristo Dio cʉ cajooricʉ,” ĩ queti buiotogarãma. To bairo mʉjaare na caĩata na api nʉcʉbʉgoqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Caĩto pairã anigarãma capaarã. “Yʉa Dio cʉ cajooricʉ yʉ ã.” Aperã, “Dio ye quetire cabuioʉ yʉ ã,” caĩtorã anigarãma. Capee áti iñooriquere átigarãma camajiri maja cúmúa na cáti anie mena, Dio yarãre cʉ cacũricarã Diore na apiʉja janaato ĩrã, jã macare na apiʉjaato ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mere caroaro mʉjaare yʉ buiowʉ na cabaipere. ");
INSERT INTO tav_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","To bairi, “Jõ camaja mani paʉpʉ ãñupʉ Cristo, Dio cʉ cajooricʉ,” na caĩata tʉjʉra aáqueticõaña. Aperã, “Wii pupea macá arʉapʉ cayajioro ãñupʉ Dio cʉ cajooricʉ,” na caĩata quena na api nʉcʉbʉgoquẽja. ");
INSERT INTO tav_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bʉpo cʉ cayaberije muipu cʉ cawamʉ ató maca yabe roca jooro, muipu cʉ caroca jãri jopepʉ cayabe rocaturore bairona yʉ catunu ató baugaro. To bairo cabairo mʉja tʉjʉ majigarã yʉ catunu atópʉ. ");
INSERT INTO tav_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yucaa na cawʉ amojorero tʉjʉrã, “Caboa cuñaʉ ãcʉmi,” mʉja ĩ maji. To bairona yʉ catunu atópʉ caroaro mʉja majigarã. “Mere caroorã, Jesure caapi nʉcʉbʉgoquẽnare na cʉ capopiyeyeri paʉ ejatʉga,” mʉja ĩ majigarã yua, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ocõo bairo jã caĩnemowĩ Jesu: —Camaja seeto na catamʉori yʉtea capetiro muipu naitĩacoagʉmi. Ñami macacʉ quena bujuquetigʉmi. Ñocoa quena wẽgarãma. Ʉmʉrecoo macana nipetirã wãregarãma. ");
INSERT INTO tav_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","To cõopʉ yʉ, camaja tʉpʉ Dio cʉ cajooricʉ ʉmʉrecoopʉ cãnacʉ yʉ rui atígʉ. To bairo yʉ carui ató tʉjʉrã to cãnacã poa macana caroorije na cátaje tʉgooñarique pairi otigarãma. To bairi oco bujeri watoapʉ, yʉ catutua netorije mena Dio ye caaji baterije mena yʉ caruiro yʉ tʉjʉ mʉgojogarãma to cãnacã poa macana, camaja nipetirã. ");
INSERT INTO tav_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ti paʉ cãno na yʉ joogʉ Dio tʉ macana ángel majare. Seeto majuu putiricaro cabʉjʉrije mena putigarãma. Yʉ cabejericarã jetore ati yepa nipetiropʉ cãnare yʉ tʉpʉ na jee neoña na ĩi, na yʉ joogʉ Dio tʉ macanare. ");
INSERT INTO tav_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Higuera cawamecʉtii, yucʉ caricacʉtii cabairijere tʉgooña majiña. Carʉpʉri bʉcʉanemo, cawama pũu wajoa, to bairo tii cabairo, “Yucʉacãna cʉma anigaro bai,” mʉja ĩ maji. ");
INSERT INTO tav_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","To bairona mʉjaare yʉ cabuiori wameri cabairo tʉjʉrã, “Yucʉacã tunu atígʉmi Jesu,” mʉja ĩ tʉjʉ majigarã. ");
INSERT INTO tav_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","35","Cariape mʉjaare yʉ ĩ. Nipetirije mʉjaare yʉ caĩri wamere bairona baigaro. Ʉmʉrecoo, yepa quena wajoagaro. Yʉ caĩ buiorije maca wajoaquetigaro. Mʉjaare yʉ caĩ buiorore bairona baigaro. Ati yʉtea Dio cʉ cawajoaparo jʉgoye macana na cayajiparo jʉgoye nipetiro mʉjaare yʉ caĩri wamere bairona baigaro. ");
INSERT INTO tav_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ati yʉtea capetiri paʉ, “Di rʉmʉ, di paʉ majuu petigaro,” jĩcaʉ maca ĩ majiquẽemi. Dio tʉ macana quena majiquẽema. Yʉ quena Dio Macʉ anibacʉ quena yʉ majiquẽe. Mani Pacʉ Dio jĩcaʉna ãmi tiere camajii. ");
INSERT INTO tav_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noé tirʉmʉpʉ macacʉ cʉ cãni rʉmʉri cabairiquere bairona baigaro yʉ catunu atíparo jʉgoyeacã. ");
INSERT INTO tav_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ti rʉmʉ cãno Dio ati yepa cʉ caruuparo jʉgoye camaja ʉga, eti, nʉmocʉti, cãromia quena manapʉacʉti cabaiyuparã, ñeere cabaipere tʉgooñarique paiquẽnana. To bairona cáticõa aninucuñuparã Noé cumua pairica cʉ cajãaparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oco pairo majuu caocaparo jʉgoye, rua yajigarã jʉgoye, “Mani rua regarã,” caĩ majiquẽjuparã. To bairona na cátatore bairona áticõa anigarãma camaja yʉ cáatíparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yʉ cáatí paʉna caʉmʉa pʉgarã wejepʉ paarã átigarãma. Jĩcaʉre cʉ yʉ ne aágʉ. Apeĩ macare cʉ yʉ ne aáquetigʉ, yʉre caapiʉjaquẽcʉ cʉ cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pʉgarã cãromia anigarãma caorica wãiarã. Jĩcaore co yʉ ne aágʉ. Apeo macare co yʉ ne aáquetigʉ, yʉre caapiʉjaquẽco co cãno maca. ");
INSERT INTO tav_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’ “Di rʉmʉ majuu mani Ʉpaʉ tunu atígʉmi,” mʉja ĩ majiquẽe. To bairi caroaro tʉgooñari to cãnacã rʉmʉ yʉ caboorore bairo áticõa aninucuña. ");
INSERT INTO tav_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ati wame tʉgooñaña: Jĩcaʉ, “Ati ñami to capaʉ majuu atígʉmi jee rutiri majocʉ,” ĩ majiquẽcʉmi wii ʉpaʉ quena. Cʉ caĩ majiata caroaro bipe, caniquẽcʉna coteboʉmi, jee rutiri majocʉ jãaremi ĩi. ");
INSERT INTO tav_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","To bairona mʉja quena, “To capaʉ majuu tunu atígʉmi Cristo, Dio cʉ cajoʉ,” mʉja ĩ majiquẽe. To bairi caroaro yʉ catunu atípere tʉgooñari caroaro yʉ caboorijere áti anicõaña, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ocõo bairo ape wame queti buiorica wame jã caĩ buiowĩ Jesu, yʉ yarã yʉ catunu atípere na tʉgooña anicõa aninucuato ĩi: —Jĩcaʉ ʉpaʉ aperopʉ aágʉ jʉgoye cʉ paabojari majocʉ jĩcaʉre ocõo bairo cʉ ĩimi: “Yʉ paa coteri majare na capaapere na rotiya. Na caʉgapere to cãnacã rʉmʉ na jooya.” ");
INSERT INTO tav_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","To bairo cʉ ĩri, aperopʉ aáteña, cʉ catunu ejaropʉ cʉ yere carotibojaʉ cʉ caĩ rotirore bairona caroaro cʉ cáto tʉjʉ, seeto cʉ wariñuu tʉjʉʉmi. ");
INSERT INTO tav_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Nipetiro yʉ yere yʉ ẽoro macacʉ carotii mʉ anigʉ,” cʉ ĩimi yua. ");
INSERT INTO tav_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Cʉ carotibojaʉ rooro maca cʉ yere cʉ cápata, “Yoaro bauquetigʉmi yʉ ʉpaʉ,” ĩri, aperã paari majare na quẽ, jibioriquere caeti pairã mena eti cumu, ʉga paca, cʉ cabaiata rooro cʉ baiboro. ");
INSERT INTO tav_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cʉ ʉpaʉ cʉ catunu atípere cʉ catʉgooñaquẽtopʉ, “Di rʉmʉ majuu tunu atígʉmi yʉ ʉpaʉ,” cʉ caĩ majiqueti rʉmʉ tunu atíboʉmi cʉ ʉpaʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","To bairo tunu atí, caroaro cʉ cacotequẽto tʉjʉ, seeto cʉ popiyeye, aperã caroorã, caĩto pairã mena cʉ rocaboʉmi caroorã na cãnopʉre. Topʉ cʉ carerã seeto tʉgooñarique pai otigarãma, seeto majuu tamʉobana, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ape wame queti buio majiorica wame jã caĩ buiowĩ Jesu tunu: —Dio cʉ yarã cʉ carotiropʉ nare cʉ cajee neorije ocõo bairo ã: Cãromia pʉga wamo cãnacãona cãñuparã cawamarã, caʉmʉa mena mai cãniquẽna. Na yao tʉpʉ cáaájuparã co mena cawamo jiapaʉ cʉ caejaparore yuura aána. Na mena boje rʉmʉ cátinemoparã romiri cãñuparã. Jĩa bujurica rupaa cajee aájuparã to cãnacãona. ");
INSERT INTO tav_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jĩca wamo cãnacão boje rʉmʉ na cajĩa bujupere caroaro catʉgooña jʉgoyeyequẽna cãñuparã. Aperã jĩca wamo cãnacão caroaro catʉgooña jʉgoyeye majirã cãñuparã. ");
INSERT INTO tav_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","To bairi caroaro catʉgooñarã romiri maca ʉje na ye jĩa bujurica rupaa na capio jãnemopere cajeeyuparã. Aperã maca caroaro catʉgooñaquẽna ʉje na ye jĩa bujurica rupaa na capio jãnemopere cajee aáquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","To bairi na yao mena cawamo jiapaʉ yoaro caejaquẽjupʉ. To bairi wʉgo ejabana cacanicoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ñami recomacapʉ aperã capi awajayuparã: “¡Cawamo jiapaʉ ejami! ¡Cʉ mani boca tʉjʉra aáparo!” ");
INSERT INTO tav_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","To bairo na capi awajarijere apirã na romiri yopi, na jĩa bujurica rupaare caquenooñuparã. ");
INSERT INTO tav_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","To bairi caroaro catʉgooñaquetana romiri ocõo bairo caĩñuparã: “Jã jĩa bujurica rupaa ʉje petiro bai. To bairi mʉja ye ʉje õcoacã jã jooya,” na caĩñuparã paibʉjaro caʉje jee aátana romiri macare. ");
INSERT INTO tav_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","To bairo na caĩro: “Jã joo majiquẽe. Mʉjaare jã cajoata jã quenare bʉquetiboro. Caʉje joorãre na wapayerã aája mʉja majuuna mʉja cajĩa bujupere,” na caĩñuparã na maca. ");
INSERT INTO tav_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","To bairo na caĩro apirã cawapayera aájuparã. To bairo na cawapayera aátoye cawamo jiapaʉ caejayupʉ yua. Cʉ caejaro caroaro catʉgooña jʉ́goyeyericarã paibʉjaro caʉje jee aátana romiri boje rʉmʉ na cáti wiipʉ cajãa aájuparã. Na cajãaro bero jope turicarore cabipecõañuparã ti wii macana yua. ");
INSERT INTO tav_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na cabipero beroacã caʉje wapayera aátana romiri atí, jope tʉpʉ eja, “¡Ʉpaʉ! ¡Ʉpaʉ, jope pãña!” caĩ pibajuparã na romiri. ");
INSERT INTO tav_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na capirijere apii, “Mʉjaare yʉ majiquẽe, jocʉ mee yʉ ĩ. Yʉ capiquetana mʉja ãnaa,” na caĩñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’To bairona yʉ, mʉja Ʉpaʉre, “Ti rʉmʉ cãno majuu ti paʉ majuu tunu atígʉmi mani Ʉpaʉ,” mʉja ĩ majiquẽe. To bairi to cãnacã rʉmʉ yʉ catunu atípere tʉgooñari caroaro yʉ caboorije jetore áticõa aninucuña, jã caĩ buiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ape wame queti buio majiorica wame ocõo bairo jã caĩ buiowĩ Jesu: —Jĩcaʉ ʉpaʉ aperopʉ aáteñaʉ aágʉ cabaiyupʉ. To bairi cʉ paa coteri majare na pijo, cʉ yere na tʉpʉre cacũñupʉ, caroaro tiere yʉre cote yuubojaya na ĩi. ");
INSERT INTO tav_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","To bairi to cãnacãʉna na capaarique wapata majiro cõo, “Apeye unie paarique cʉtibojaya,” na ĩ, jĩcaʉre jĩca wamo cãnacã mil cuiri pairo cawapacʉti cuirire cʉ cacũñupʉ. Apeĩre pʉga mil cuiri cʉ cacũñupʉ. Apeĩre jĩca mil cʉ cacũñupʉ. Tiere na ricawo yaparo aperopʉ cáaáteñaʉ aácoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","To bairo cʉ cáaáto bero jĩca wamo cãnacã mil cuiri cʉ cajooricʉ ame wapayeri yoaro mee apeye jĩca wamo cãnacã mil cuiri cawapatayupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","To bairona pʉga mil cuiri cʉ cajooricʉ apeye unie paarique cʉtiri apeye pʉga mil cuiri cawapata nemoñupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jĩca mil cuiri cʉ cajooricʉ maca aá, yepapʉre ope yejea átiri cayaa cũcõañupʉ cʉ ʉpaʉ niyeru cʉ capaarique cʉti rotibatajere. ");
INSERT INTO tav_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Cayoato bero na ʉpaʉ catunu ejayupʉ. Tunu eja, nare cʉ cajooriquere caquenoogabajupʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","To bairi nare capijoyupʉ nare cʉ cacoteboja rotiricarãre. To bairo cʉ capiro jĩca wamo cãnacã mil cuiri cʉ cajooricʉ atí, apeye jĩca wamo cãnacã mil cuirire cʉ cawapata nemoriquere jee atí, ocõo bairo cʉ ʉpaʉre cʉ caĩñupʉ: “Ʉpaʉ, jĩca wamo cãnacã mil cuiri yʉre mʉ cacũwʉ. Jĩca wamo cãnacã mil cuiri yʉ cawapata nemowʉ tunu. To bairi atie ã mʉ niyeru yʉre mʉ cacũepe mena yʉ cawapata nemorique,” cʉ caĩñupʉ cʉ ʉpaʉre. ");
INSERT INTO tav_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","To bairo cʉ caĩro: “Caroaro mʉ ájupa. Mʉ ñuubʉja. Mʉ yʉ cáti rotirore bairona cácʉ mʉ ã. Petoacã mʉ yʉ carotiepere caroaro yʉ mʉ átibojayupa. To bairo caroaro cátacʉ mʉ cãno maca yucʉra pairo majuu yʉre mʉ cacotebojapere mʉ yʉ cũgʉ. Yʉ mena macacʉ mʉ ani wariñuugʉ,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Cʉ bero pʉga mil cãnacã cuiri cʉ cajooricʉ atí, apeye pʉga mil cuirire cʉ cawapata nemoriquere jee atí, ocõo bairo cʉ ʉpaʉre cʉ caĩñupʉ: “Ʉpaʉ, pʉga mil cãnacã cuiri yʉre mʉ cacũwʉ. Pʉga mil cãnacã cuiri yʉ cawapatanemowʉ tunu.” ");
INSERT INTO tav_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","To bairo cʉ caĩro: “Caroaro mʉ ájupa. Mʉ ñuubʉja. Mʉ yʉ cáti rotirore bairona cácʉ mʉ ã. Petoacã mʉ yʉ cáti rotiepere caroaro yʉre mʉ átibojayupa. To bairo caroaro cátacʉ mʉ cãno yucʉra pairo majuu yʉre mʉ cacotebojapere mʉ yʉ cũgʉ. Yʉ mena macacʉ mʉ ani wariñuugʉ,” cʉ caĩñupʉ cʉ ʉpaʉ cʉ quenare. ");
INSERT INTO tav_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Cʉ bero jĩca mil cãnacã cuiri cʉ cajooricʉ atí, cʉ ʉpaʉre ocõo bairo jocʉna cʉ caĩñupʉ: “Ʉpaʉ, tutuaro carotii mʉ ã. Aperã maca na capaa wapatarijere cajei mʉ ã. ");
INSERT INTO tav_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","To bairi, ‘Yʉ cawapatabato quena yʉ wapa jooquẽcʉmi,’ yʉ caĩ tʉgooña uwiwʉ. To bairo mʉ cátiere tʉgooñari mʉ niyerure yepa pupeapʉ yʉ cayajiobojawʉ. Ʉ̃jʉ, mʉ niyerure yʉ cacũ yajio bojariquere jeeya,” cʉ caĩñupʉ cʉ ʉpaʉre. ");
INSERT INTO tav_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","To bairo cʉ caĩro ocõo bairo cʉ caĩñupʉ cʉ ʉpaʉ: “Mʉ yʉ cacũbatajere rooro mʉ ájupa. Mʉ ñuuquẽe mʉa. Cateeye paii mʉ ã. Jocʉna, ‘Aperã yere na cawapatarijere cajei ãmi yʉ ʉpaʉ. To bairi yʉ cawapata bojabato quenare yʉ wapa jooquẽcʉmi,’ mʉ ĩ tʉgooñabacʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","To bairo tʉgooñabacʉ quena niyeru caquenoo cũrica paʉpʉ to macanare na caquenoo cũ rotipaʉ mʉ anibajupa, to bʉato ĩi. To bairi niyeru bʉboricaro topʉ mʉ caquenoo cũata. Tie cabʉrique menare na mʉ cawajorique wapa yʉ jeeboricʉ,” cʉ caĩñupʉ cʉ ʉpaʉ caniyeru cũ yajioricʉre. ");
INSERT INTO tav_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","To bairo cʉ ĩi, aperã paa coteri maja topʉ catʉjʉnucurãre ocõo bairo na caĩñupʉ: “Cʉ yʉ cajoobataje mil cuirire cʉ emari, pʉga wamo cãnacã mil cuirire cawapata nemoricʉre cʉ jooya. ");
INSERT INTO tav_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","To bairi ni ũcʉ cʉ cacʉgorije mena caroaro cátacʉre netobʉjaro cʉ yʉ joogʉ. To bairi pairo cʉgogʉmi. Apeĩ maca caroaro cátiquetacʉ aniri cʉ cacʉgobatajere rooro cáti rericʉ maca cʉgoquetigʉmi. To bairi cʉ cacʉgorijeacã quenare ema átiri aperã macare na yʉ joogʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","To bairi yʉre capaabojari majocʉ cãnibatacʉ cañuuquẽcʉre cʉ ñeri macapʉ canaitĩaropʉ cʉ rocacõaña. Topʉ tʉgooñarique pai otigʉmi seeto majuu tamʉobacʉ, jãre caĩ buiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","32","Ocõo bairo jã caĩ buiowĩ Jesu tunu: —Camaja tʉpʉ Dio cʉ cajooricʉ aniri ati yepapʉ yʉ tunu atígʉ, camaja nipetirãre na rotigʉ. Dio tʉ macana mena, yʉ caaji baterije mena yʉ tunu atígʉ. To bairi camaja Ʉpaʉ majuu aniri yʉ tʉpʉ yʉ caruiri paʉpʉ yʉ jee neogʉ camaja nipetirãre, to cãnacã poa macanare. Na jee neo, yʉ riape na catʉjʉnucuro yʉ yarãre na yʉ bejegʉ, yʉre caapiʉjaquẽnare na cũri. Nuricarã cacʉgoʉ ovejare cariape nʉgoa na beje cũ, cabra na caĩrãre cacõ nʉgoa maca na cʉ cabeje cũrore bairona na yʉ beje cũgʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","34","To bairona yʉ yarãre na beje cũ átiri, Ʉpaʉ aniri cariape nʉgoa cãnare ocõo bairo na yʉ ĩgʉ: “Adʉja. Yʉ Pacʉ caroaro wariñuurique mʉjaare joogʉmi. Tirʉmʉpʉ ati ʉmʉrecoo nemoopʉ cʉ cáti jʉgori paʉpʉna cʉ tʉpʉ cãni wariñuuparãre cacũñupi mʉjaare. ");
INSERT INTO tav_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ cañigo riaro ʉgariquere yʉ mʉja cajoowʉ. Yʉ caoco etigaro yʉ mʉja catĩawʉ. Apero macacʉ yʉ cãnibato quena mʉja ya maca yʉ caejaro, ‘Jã tʉ ãña,’ yʉ mʉja caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yʉ cajutii cʉgoquẽto yʉ mʉja cajoowʉ. Yʉ cariaro yʉ mʉja catʉjʉra ejawʉ. Aperã presopʉ yʉ na cajooro yʉ mʉja cátinemorã ejawʉ,” na yʉ ĩgʉ yʉ riape nʉgoa cãnare. ");
INSERT INTO tav_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","To bairo na yʉ caĩro ocõo bairo yʉ ĩgarãma ti nʉgoa cãna caroarã Dio nare cʉ caĩ tʉjʉrã: “Ʉpaʉ, ¿di paʉ uno mʉ cañigo riaro mʉre jã canuñupari? ¿Di paʉ uno mʉ caoco etigaro mʉre jã catĩañupari? ");
INSERT INTO tav_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Di paʉ uno aperopʉ cãnacʉ jã ya macapʉ mʉ caejaro, ‘Jã tʉpʉ ãña,’ mʉre jã caĩñupari? ¿Di paʉ uno cajutii cʉgoquẽcʉ mʉ cãno mʉre jã cajooyupari? ");
INSERT INTO tav_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Di paʉ uno mʉ cariaro mʉre jã catʉjʉra ejayupari? ¿Di paʉ uno presopʉ mʉre na cajooro mʉre jã cátinemorã ejayupari?” yʉre ĩ jeniñagarãma. ");
INSERT INTO tav_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","To bairo yʉre na caĩ jeniñaro ocõo bairo na yʉ ĩgʉ: “Cariape mʉjaare yʉ ĩ. Yʉ yarã cawatoa cãna quenare caroare na átinemori yʉpʉre átinemorã mʉja cápʉ́,” na yʉ ĩgʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Na ĩ yaparori bero ocõo bairo na yʉ ĩgʉ cacõ nʉgoa cãna macare: “Dio cʉ capopiyeyeparã mʉja ã. To bairi aánaja peropʉ cayatiqueti peropʉ. Sataná cʉ yarã wãtia menare na yʉ carepa peropʉ aánaja. ");
INSERT INTO tav_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ cañigo riaro yʉre mʉja canuquẽpʉ. Yʉ caoco etigaro yʉre mʉja catĩaquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aperopʉ cãnacʉ mʉja ya macapʉ yʉ caejaro, ‘Jã tʉpʉ ãña,’ yʉre mʉja caĩquẽpʉ. Yʉ cajutii cʉgoquẽto yʉre mʉja cajooquẽpʉ. Yʉ cariaro yʉre mʉja catʉjʉra ejaquẽpʉ. Presopʉ yʉre na cajooro yʉre mʉja cátinemorã ejaquẽpʉ,” na yʉ ĩgʉ cacõ nʉgoa cãnare. ");
INSERT INTO tav_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","To bairo na yʉ caĩro ocõo bairo yʉre ĩgarãma: “Ʉpaʉ, ¿di paʉ uno ñigo ria, oco etiga, aperopʉ cãnacʉ jã ya macapʉ eja, jutii cʉgoqueti, ria, presopʉ ani, mʉ cabairo mʉre jã cátinemoqueti?” yʉ ĩgarãma. ");
INSERT INTO tav_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","To bairo yʉ na caĩro ocõo bairo na yʉ ĩgʉ: “Cariape mʉjaare yʉ ĩ. Jĩcaʉ yʉ yaʉ cawatoa cãcʉ quenare caroare cʉ átinemoquetiri yʉpʉre átinemoquẽna mʉja cápʉ́,” na yʉ ĩgʉ. ");
INSERT INTO tav_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","To bairi to cãnacã rʉmʉ popiye na catamʉori paʉpʉ aágarãma. Yʉ yarã, caroarã Dio cʉ caĩ tʉjʉrã maca cʉ tʉpʉ to cãnacã rʉmʉ wariñuu anicõagarãma, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tiere jã ĩ buio yaparo cʉ buerãre ocõo bairo jã caĩ buiowĩ Jesu: ");
INSERT INTO tav_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pʉga rʉmʉ bero pascua na caĩri boje rʉmʉ anigaro, mere mʉja maji, mani ñicʉ jãare Ejiptopʉ capopiye tamʉorãre Dio na cʉ canetoo bojariquere mani catʉgooñapa rʉmʉ. Ti boje rʉmʉ cãno yʉre ñegarãma. Yucʉ tẽorica pãipʉ cʉ papua jĩaña ĩrã yʉre ñegarãma, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti paʉ cãno majuu sacerdote maja ʉparã, aperã cabʉcʉrã judío majare carotirã caneñapoyuparã. Sacerdote maja ʉpaʉ majuu Caifá cawamecʉcʉ ya wiipʉ caneñapoyuparã. ");
INSERT INTO tav_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Caifá ya wiipʉ neñapo, yajioropʉ Jesure ñeri cʉ na cajĩapere caame wadapeniñuparã. ");
INSERT INTO tav_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Cʉ ñebana quena boje rʉmʉ cãno cʉ̃re mani ñequẽna. Camaja capaarã catʉjʉra ejarã cʉ mairã mani awaja tutiborãma,” caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania na caĩri macapʉ Simón cawamecʉcʉ ya wiipʉ cãmi Jesu yua. Simón caajeri boaʉ cãnacʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","To bairi Simón ya wiipʉ Jesu cʉ caʉga ruiro jĩcao cãromio cʉ tʉpʉ caejawõ. Caneamó carupa rʉ alabastro cawamecʉti rʉ werica rʉ caroaro cajʉti ñuurije, pairo cawapacʉtie cajañari rʉ. Tiere neatí, Jesu rʉpoare capio peówõ. ");
INSERT INTO tav_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","To bairo co cáto tʉjʉrã Jesu buerã jã capunijini tʉgooñawʉ cõre: —¿Nope ĩo to bairo pairo majuu cawapa pacarije to cãnibato quena cawatoana co pio recõati? ");
INSERT INTO tav_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aperãre co cajoata pairo majuu wapa jooboricarãma. Niyeru na cawapayeboriquere cabopacarãre na cajoope pairo aniboricaro, jã caame ĩwʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","To bairo jã caame ĩrijere majiri, ocõo bairo jã caĩwĩ Jesu: —¿Nope ĩrã cõre mʉja ĩ patowãcooti? Caroaro yʉre áamo. ");
INSERT INTO tav_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cabopacarã mʉja tʉpʉ anicõa aninucugarãma mʉja caboori paʉ na mʉja cátinemoparã. Yʉ maca mʉja mena yoaro yʉ aniquetigʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","To bairi atie caroa cajʉti ñuurijere yʉre pio peómo, yʉ cabai yajiro bero yʉ rupaʉ na cayaaparo jʉgoye na cátipere iñoo. ");
INSERT INTO tav_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cariape mʉjaare yʉ ĩ: Ati yepa nipetiropʉ yʉ ye quetire cabuio teñarã yʉre co cátaje quenare buiogarãma. Yʉre co cátajere majiritiquetigarãma. Cabero macana quena caroaro yʉre co cátajere ame buiogarãma, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Cabero Judas Iscariote cawamecʉcʉ Jesu buerã mena macacʉ jĩcaʉ sacerdote maja ʉparã tʉpʉ cáaájupʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na tʉpʉ aá: —¿Noo cõo yʉ mʉja wapayebocʉti, Jesure na ñeato ĩi mʉjaare yʉ cabuioata? na caĩ jeniñañupʉ Judas. To bairo na cʉ caĩ jeniñaro treinta cuiri caajiyari cuiri cõoña, cʉ cajooyuparã, bapari cãnacã muipu camajocʉ cʉ capaa wapatarije cõo majuu. ");
INSERT INTO tav_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cʉ na cajooro bero, Jesure na ñeato ĩi nare cʉ cabuioparore cacoteyupʉ Judas. ");
INSERT INTO tav_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Cabero pascua boje rʉmʉ pan cawauorije caajuya manie judío maja na caʉga jʉgori rʉmʉ cãmʉ yua. To bairi Jesu buerã cʉ tʉpʉ atí, cʉ jã caĩ jeniñawʉ: —¿Noopʉ pascua macaje mʉ caʉgapere jã caquenoo jʉgoyeyepe mʉ booti? cʉ̃re jã caĩ jeniñawʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","To bairo cʉ jã caĩ jeniñaro: —Macapʉ aánaja jĩcaʉ mʉjaare yʉ caĩi ya wiipʉ. Cʉ ya wiipʉ ejarã, ocõo bairo cʉ̃re mʉja ĩgarã: “Manire cabuei mʉre ĩ joomi. ‘Dio rooro yʉ catamʉopere yʉre cʉ cacũrica paʉ ejatʉga mere. Yʉ buerã mena mʉ ya wiipʉ pascua macajere caʉgaparã jã ã,’ mʉ ĩ joomi manire cabuei,” cʉ ĩña. ");
INSERT INTO tav_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","To bairi aá, cʉ caĩrore bairona jã cápʉ́. Topʉ pascua jã caʉgapere jã caquenoowʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Canaiori paʉ cãno cʉ buerã jã mena caʉga ruiwĩ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jã caʉga ruiri paʉna ocõo bairo jã caĩwĩ Jesu: —Jĩcaʉ mʉja mena macacʉ yʉre catʉjʉ teerãre yʉre wadajãgʉmi, yʉre na ñeato ĩi. Cariape mʉjaare yʉ ĩ buio. ");
INSERT INTO tav_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","To bairo jãre cʉ caĩro seeto jã catʉgooñarique paiwʉ. To bairo tʉgooñarique pairã: —¿Yʉna yʉ baiquetibacʉati? To cãnacãʉna cʉ̃re jã caĩ jeniña peticoapʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","To bairo cʉ jã caĩ jeniñaro: —Yʉ mena jotʉ bapa cayoje ʉgaʉ ãmi yʉre catʉjʉ teerãre cawadajãpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yʉ cabaipe tirʉmʉpʉ Dio ye quetire cabuioricarã na caĩricarore bairona cabaipaʉ yʉ ã. To bairo cabaipaʉ yʉ cãnibato quena rooro majuu baigaro cʉ̃re yʉ catʉjʉ tutirãre yʉre cʉ cawadajãrije wapa. Cʉ cabuiaquẽpata ñuucõaboricaro cʉ̃re. ");
INSERT INTO tav_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","To bairi Judas, Jesure catʉjʉ teerãre cawadajãpaʉ cʉ quena Jesure ocõo bairo caĩ jeniñawĩ: —¿Yʉna yʉ baiquetibacʉati? To bairo cʉ caĩ jeniñaro: —Mʉna mʉ ã, cʉ caĩwĩ Jesu Judare. ");
INSERT INTO tav_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jã caʉgari paʉna Jesu jĩca pãre ne, Diore cʉ cajeni nʉcʉbʉgowĩ. Jeni nʉcʉbʉgo, pan pe bate, jãre cajoowĩ cʉ buerãre. —Atiere ne ʉgaya. Yʉ rupaʉ ã, jã caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cabero etirica bapare ne, Diore cajeni nʉcʉbʉgowĩ Jesu tunu. Jeni nʉcʉbʉgo, jãre joo: —Mʉja nipetirã etiya mʉjaa. ");
INSERT INTO tav_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Atie yʉ rií ã. Yʉ rií re yajigʉ, camaja capaarã caroorije na cátiere na wapayebojaʉ. To bairo yʉ carií re yaji wapayebojaro camaja caroorije na cátajere majiriogʉmi Dio cʉ̃re cajeni nʉcʉbʉgorãre. To bairo mʉjaare yʉ caĩ cũri wamere tʉgooñari etiya. ");
INSERT INTO tav_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cariape mʉjaare yʉ ĩ. Atie ʉje miji wẽ rica ocore yʉ etinemoquetigʉ yʉ Pacʉ Ʉpaʉ yʉre cʉ cajõoparo jʉgoye. Mʉja mena yʉ etinemogʉ ti rʉmʉ Ʉpaʉ yʉ cãnopʉ, jã caĩ buiowĩ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cabero Diore jã cawariñuu bajawʉ. Baja yaparo Olivo na caĩricʉpʉ jã cáaápʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jã cáaáto ocõo bairo jã caĩwĩ Jesu: —Uwibana ati ñamire yʉre mʉja ruti aáweo peticoagarã. To bairona cabaipere caĩ ucayupi tirʉmʉpʉ macacʉ Dio wadarica tutipʉ: “Oveja Ʉpaʉre cʉ jĩagarãma. Cʉ na cajĩaro oveja aá bategarãma,” caĩ ucayupi. To bairo na cáaá baterore bairona mʉja quena rutiri mʉja aá bategarã yʉre na cajĩaro, uwibana. ");
INSERT INTO tav_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cariacoatacʉ anibacʉ quena yʉ catí tunucoagʉ. Catí tunu, mʉja jʉgoye yʉ aágʉ Galilea yepapʉ, mʉjaare yuʉ aácʉ, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","To bairo jã cʉ caĩro ocõo bairo cʉ caĩwĩ Pedro: —Aperã nipetirã uwibana mʉre na caruti aáweorije to cãnibato quena yʉ ruti aáweoquetigʉ yʉa, cʉ caĩwĩ Pedro. ");
INSERT INTO tav_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","To bairo cʉ caĩro: —Cariape mʉ yʉ ĩ. Ati ñamina cabujuri paʉ jʉgoye ãbocʉ cʉ cawadaparo jʉgoye itiani, “Cʉ yaʉ mee yʉ ã, cʉ yʉ majiquẽe,” mʉ ĩtogʉ, cʉ caĩwĩ Jesu Pedrore. ");
INSERT INTO tav_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","To bairo cʉ caĩro: —Mʉ mena yʉre na cajĩa rocarije to cãnibato quena, “Jesure yʉ majiquẽe,” yʉ ĩqueti majuucõagʉ, cʉ caĩwĩ Pedro. Aperã cʉ buerã nipetirã to bairo jeto jã caĩwʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","To bairi Jesu mena jã caejawʉ Getsemaní na caĩri paʉpʉ oterica paʉ. Jã caejaro cʉ buerãre ocõo bairo jã caĩwĩ Jesu: —Atona rui coteya i paʉpʉ Diore yʉ cajeni nʉcʉbʉgoʉ aátoye, jã caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","To bairo ĩ, na capi aámi cʉ mena Pedrore, Sebedeo punaa na pʉgarã quenare. Topʉ aá, seeto majuu tʉgooñarique pai cayapapua jʉgóyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","To bairo tʉgooñarique pairi ocõo bairo na caĩñupʉ: —Yʉ bai yajicoabo seeto tʉgooñarique pai netobacʉ. Atona yʉ coteya caniquẽnana, na caĩbami Jesu. ");
INSERT INTO tav_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","To bairo na ĩ, na jʉgoyeacã aá, yepapʉ mubia cumu eja, ocõo bairo caĩ jeniñupʉ Diore: —Caacʉ, yʉ capopiye tamʉope mʉ cabooata to cabaiquẽto ája. Mʉ jeto mʉ maji. Yʉ maca yʉ capopiye tamʉope yʉ cabooquẽtie to cãnibato quena mʉ caboorije maca to baiato, caĩ jeniñupʉ Diore. ");
INSERT INTO tav_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Diore jeni yaparo tunu aá, cʉ buerãre catʉjʉyupʉ cacani cuñarãre. Cacani cuñarãre na tʉjʉ, ocõo bairo cʉ caĩñupʉ Pedrore: —¿Jĩca hora yoaroacã meena caniquẽnana mʉja cote majiquẽeti? ");
INSERT INTO tav_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Caniquẽnana cotecõaña. Diore cʉ jeniya, Sataná cʉ caboorije macare jã áti wadajãremi ĩrã. Mʉja yeripʉre yʉ mʉja cáaá weogaquẽtie to cãnibato quena mʉja rupaʉri macare mʉja ocabʉtiquẽe, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","To bairo na ĩ, cʉ caĩricarore bairona Diore cajeni nʉcʉbʉgoʉ aájupʉ tunu: —Caacʉ, atie yʉ capopiye tamʉope yʉre mʉ canetoo bojagaquẽpata mʉ caboorije maca to baiato, caĩ jeniñupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Diore cʉ cajenitoye Pedro jãa cacanicoajuparã tunu, wʉgoa to caejaro maca. To bairi Jesu Diore ĩ jeni yaparo catunucoajupʉ Pedro jãa tʉpʉ. Tunu eja, na cacani cuñaro na catʉjʉyupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","To bairona nare aáweocõari tunu, na jʉgoyeacã to bairona Diore cajeni nʉcʉbʉgoyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ĩ jeni yaparo catunucoajupʉ Pedro jãa tʉpʉ. Na tʉpʉ eja, ocõo bairo na caĩñupʉ: —To cõona caniña. Dio rooro yʉ catamʉopere yʉre cʉ cacũrica paʉ majuu ejatʉga mere. Caroorãre yʉ jooma, cʉ ñeña ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yopiya. Jitá. Mere ejatʉgami yʉre cañe rotii, yʉ mena macacʉ cãnibatacʉna, na caĩñupʉ Jesu na itiarãre Pedro jãare. ");
INSERT INTO tav_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","To bairo Jesu cʉ caĩ ãnona caejawĩ Judas yua, jã mena macacʉ cãnibatacʉ. Na cajʉgo ejawĩ Judas aperã camaja capãarãre jarerica pãiri, yucʉrire cacʉgorã, caroaro wamooricarã mena. Sacerdote maja ʉparã, aperã cabʉcʉrã judío majare carotirã Jesure cʉ na cañe rotiricarã cãma. ");
INSERT INTO tav_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na caejaparo jʉgoye Judas na caĩ buio jʉgoyeyeyupʉ cʉ cajʉgo aánare, Jesure na catʉjʉ majiparore bairo ĩi: —Jesu cʉ cãni paʉpʉ ejaʉ cʉ yʉ pabario jeniñagʉ. To bairo cʉ yʉ cáto tʉjʉrã cʉ mʉja ñegarã, na caĩ buio jʉgoyeyeyupʉ Judas. ");
INSERT INTO tav_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","To bairo Judas na cʉ caĩ buio jʉgoye yericarore bairona cámí. To bairi Jesu tʉpʉ atí: —¡Mʉ anibapari, Ʉpaʉ! cʉ jeniñari cʉ capabariowĩ Judas. ");
INSERT INTO tav_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","To bairo cʉ cáto: —¿Ñeere átii acʉ́ mʉ atí, Judas? cʉ caĩ jeniñawĩ Jesu Judare. Jesure cʉ catʉjʉ teerã na cajooricarã Judas cʉ capabarioro tʉjʉrã cʉ cañewã Jesure yua. ");
INSERT INTO tav_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","To bairo cʉ na cañeri paʉna Jesu mena macacʉ jĩcaʉ jarerica pãire tʉ̃ga we roca joo átiri sacerdote maja ʉpaʉ capaabojari majocʉre, cʉ amoorore capa ta ñoocõa joowĩ. ");
INSERT INTO tav_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","To bairo cʉ cáto ocõo bairo cʉ caĩwĩ Jesu: —Mʉ jarerica pãi quenoo cũña. Noa jarerica pãi mena caame quẽrãre na jĩagarãma aperã tunu jarerica pãi menana. ");
INSERT INTO tav_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Dio yʉre cʉ cátinemo majirijere mʉ tʉgooñaquẽeti? Yʉ Pacʉre cʉ yʉ cajeniata ángel maja capãarã majuu yʉre camotaboja rotii, na jooboʉmi. ¿Tiere mʉ majiquẽeti? ");
INSERT INTO tav_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","To bairo to cãnibato quena cʉ yʉ jeniquẽe. Yʉre ñerã Dio ye quetire buiori maja tirʉmʉpʉ macana na caĩ ucaricarore bairona yʉre átigarãma. Dio cʉ caĩ cũrica wamere bairona yʉre átigarãma ati maja. To bairona caĩwĩ Jesu sacerdote maja ʉpaʉ capaabojari majocʉre cʉ amoorore Pedro cʉ capa ta ñooro tʉjʉri. ");
INSERT INTO tav_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","To bairo cʉ ĩ, camaja paarãacã cʉ̃re cañerã ejaricarãre ocõo bairo na caĩwĩ Jesu: —¿Nope ĩrã jarerica pãiri mena, yucʉ rʉcari mena caroaro wamooricarã jee rutiri majocʉre ánare bairona yʉre mʉja ñerã ejati? To cãnacã rʉmʉ Dio wiipʉ camajare yʉ cabuiorije to cãnibato quena yʉre mʉja cañequetinucuwʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dio ye quetire cabuioricarã tirʉmʉpʉ macana na caĩ ucariquere bairona yʉre mʉja áa. “Na caĩ buio jʉgoye yeriquere bairona jã áa,” ĩ majiquetibana quena to bairona yʉre mʉja áa, caĩwĩ Jesu. Ti paʉna cʉ buerã Jesure cʉ jã caruti weo peticoapʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","To bairi Jesure cʉ ñe aána cane ejayuparã sacerdote maja ʉpaʉ majuu ya wiipʉ, Caifá cawamecʉcʉ tʉpʉ. Topʉ caneñapoyuparã judío majare cabuerã, aperã cabʉcʉrã carotirã mena. ");
INSERT INTO tav_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro maca cayoaropʉ catʉjʉ ʉja aájupʉ. Sacerdote maja ʉpaʉ ya wii macá yepapʉ eja, caruiyupʉ Pedro ti wiire cacoterã mena, ¿dope bairo to bairoati? ĩ tʉjʉgʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","To bairo cʉ cabairo sacerdote maja ʉparã, aperã carotirã topʉ caneñaporã, ¿di wame caroorije cʉ cájupari? caĩ wadapeni macabajuparã. ¿Dope bairo cʉ cátaje wapa cʉ mani jĩarãati? ĩrã caame jeniñabajuparã. ");
INSERT INTO tav_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","To bairi capãarã Jesure caĩ wadajãrã cãñuparã. To bairo na ĩ buiobana quena cariape jĩcaro mena caĩrã camañuparã. Aperã ricati, aperã ricati to bairo jeto caĩtoyuparã naa. Cabero aperã pʉgarã ocõo bairo caĩ wadajãñuparã Jesure: ");
INSERT INTO tav_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Ani cʉ caĩriquere jã caapiwʉ. “Dio ya wiire yʉ we rocagʉ. We rocabacʉ quena itia rʉmʉ bero yʉ wajoa nʉcogʉ ape wiire yʉ camajirije mena tunu,” caĩwĩ Jesu, caĩñuparã na pʉgarã. ");
INSERT INTO tav_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","To bairo na caĩrijere apii sacerdote maja ʉpaʉ Caifá cawamecʉcʉ wamʉnʉca, ocõo bairo caĩñupʉ Jesure: —¿Nare mʉ yʉgaquẽeti? ¿Dope bairo ĩrã na ĩti mʉre? Jesure cʉ caĩ jeniñabajupʉ Caifá. ");
INSERT INTO tav_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesu maca cʉ caĩ yʉquẽjupʉ. To bairi Caifá cʉ caĩnemoñupʉ tunu: —Dio to cãnacã rʉmʉ cãnicõa aninucuʉ cʉ carotiro mena mʉ yʉ buio roti jãre. Cariapena jãre ĩ buiocõaña. Tirʉmʉpʉ macana Dio ye quetire cabuio jʉgoyeyericarã, “Atígʉmi jĩcaʉ Cristo na caĩi Dio cʉ cajoʉ,” caĩ ucayupa. To bairo Dio cʉ cajoʉ na caĩricʉna, ¿Dio Macʉna mʉ ãti? Jesure cʉ caĩ jeniñañupʉ Caifá. ");
INSERT INTO tav_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","To bairo cʉ caĩ jeniñaro: —Cʉna yʉ ã mʉ caĩrore bairona. Cariape mʉjaare yʉ ĩ. Dio cʉ cajooricʉ aniri ape rʉmʉripʉ cʉ tʉna ruiri cʉ mena carotii yʉ anigʉ. Ati yepapʉ yʉ rui atígʉ bujeri bʉrʉri watoapʉ. To bairo cáacʉ́re yʉre mʉja tʉjʉ mʉgojogarã, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","To bairo Jesu cʉ caĩro apii cʉ majuuna cʉ jutii cabui macajere catʉ̃ga wooyupʉ Caifá, cʉ caapi punijinirijere iñoʉ: —Nope ĩrã caroorije cʉ cáti buicʉtiere aperã cabuioboparãre na mani jeniñanemoquẽna. Rooro Diore cʉ caĩrijere mʉja apiwʉ mere, “Dio Macʉna yʉ ã,” cʉ caĩtorijere. ");
INSERT INTO tav_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Dope bairo cʉ̃re mʉja tʉgooñati? caĩñupʉ Caifá sacerdote maja ʉpaʉ cʉ ya wiipʉ caneñaporãre. To bairo cʉ caĩro: —Cʉ cajĩa rocacõape ã, to bairije Diore rooro cʉ caĩeje wapa, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","To bairo ĩrã, jĩcaarã to catʉjʉnucurã cʉ riyare caʉco eo bate tuyuparã Jesure yua. Aperã na wamori mena cʉ cañojeñuparã. Aperã juti ajero mena cʉ riyare biperi, cʉ bape, ocõo bairo cʉ caĩñuparã: ");
INSERT INTO tav_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—¿Ni maca mʉre cʉ baperi? Dio cʉ cajooricʉna mʉ cãmata jã ĩ bʉgaya, camajii mʉ cãmata, cʉ caĩ epeyuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","To bairo rooro Jesure na caĩ ani paʉna Pedro macá yepapʉ caruiyupʉ. Topʉ cʉ caruiro jĩcao ti wiipʉ paa coteri majoco cʉ tʉpʉ atí, ocõo bairo cʉ caĩñupo Pedrore: —Mʉ quena Jesu Galilea yepa macacʉ mena mʉ cãninucuwʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","To bairo co caĩro apii: —Yʉ aniquẽe. Mʉ caĩri wamere yʉ majiquẽe, caĩñupʉ Pedro to cãna nipetirã na caapijoropʉ. ");
INSERT INTO tav_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","To bairo ĩ yaparo wii na cajanijã amojorerica janiro jopepʉ cáaájupʉ. Topʉ catʉjʉnucuñupʉ. Topʉ cʉ catʉjʉnucuro apeo cʉ tʉjʉri ocõo bairo caĩñupo to cãnare: Jĩ quena Jesu Nasaré macacʉ menana cãninucuwĩ. ");
INSERT INTO tav_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","To bairo co caĩro apii caĩtoyupʉ Pedro tunu: —Dio mena yʉ ĩ, jĩire cʉ yʉ majiquẽe, caĩtoyupʉ Pedro tunu. ");
INSERT INTO tav_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Petoacã bero aperã to catʉjʉnucurã Pedro tʉpʉ atí, ocõo bairo cʉ caĩñuparã aperã to catʉjʉnucurã: —Mʉ quena Jesu mena macacʉ mʉ ãnacʉ, jocarã mee jã ĩ. Mʉ cawadarijepʉre jã api maji, Pedrore cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","To bairo cʉ na caĩro roorije na ĩri ocõo bairo na caĩñupʉ: —Cʉ yʉ majiqueti majuucõa jĩire, Dio mena mʉjaare yʉ ĩ, caĩtoyupʉ Pedro. To bairo cʉ caĩrona ãbocʉ cawadacoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","To bairo ãbocʉ cʉ cawadarijere apiri Pedro catʉgooña bʉgayupʉ. “Ãbocʉ cʉ cawadaparo jʉgoye itiani, ‘Jesure cʉ yʉ majiquẽe,’ na mʉ ĩtogʉ,” Jesu cʉ caĩriquere catʉgooña bʉgayupʉ. Tʉgooña bʉga, buti, seeto caotiyupʉ Pedro tʉgooñarique pairique mena. ");
INSERT INTO tav_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cabero cabujuri paʉ caejaro sacerdote maja ʉparã nipetirã aperã cabʉcʉrã judío majare carotirã mena caneñapoyuparã. Neñapo, jĩcaro mena tʉgooñari romano maja ʉparãre Jesure nare na cajĩa rotipere cawadapeniñuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wadapeni yaparo Jesu wamorire jia tu, cʉ cañe aájuparã Pilato cawamecʉcʉ tʉpʉ. Roma macacʉ gobiernore carotibojaʉ cãñupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesure catʉjʉ tutirã cʉ̃re na ñeato ĩi na cawadajãricʉ Jesure na cajĩagaro tʉjʉʉ, “Rooro cʉ yʉ wadajãrajawʉ,” caĩ tʉgooñarique paiyupʉ. To bairo rooro tʉgooñarique pai, niyeru treinta cuiri caajiyari cuiri cʉ̃re na cawapayebatajere catunuo joogabajupʉ. To bairi sacerdote maja ʉparã, aperã cabʉcʉrã judío majare carotirã tʉpʉ aá: ");
INSERT INTO tav_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Rooro yʉ wadajãrajawʉ. Caroorije cátiquẽcʉrena mʉjaare yʉ joowʉ mʉja cajĩapaʉre, na caĩbajupʉ Judas. To bairo na cʉ caĩro: —Jãrã ñe wapa maa. Mʉ majuuna bai tʉgooñaña ti wamere, cʉ caĩñuparã Judare. ");
INSERT INTO tav_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","To bairo cʉ na caĩro apii Dio wiipʉ aá, care bate cũcõañupʉ cʉ̃re na cajoobatajere caajiyari cuirire. Re bate cũ, cáaácoajupʉ. Aá, cʉ wamʉa jia tu bio, yucʉpʉ wamʉ aá, cayapa carʉpʉpʉre jia tu, bapa roca yo aá átiri cʉ majuuna cajĩa yajicoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","To bairi cʉ̃re na cawapayebatajere Judas cʉ care bate cũro tʉjʉri cajeeyuparã sacerdote maja ʉparã ti cuirire. Tiere jee, ocõo bairo caame ĩñuparã: —Atie niyeru camajocʉ cʉ̃re na cajĩarique wapa ã, cʉ rií wapa. To bairi Dio wii macaje niyeru cajañari patapʉ cajã rotiquetipe ã. ¿Dope bairo mani ánaati atie niyerure to roque? caame ĩ wadapeniñuparã yua. ");
INSERT INTO tav_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","To bairo ame ĩ wadapeni, jĩca yepa na cawapayepe caame wadapeni quenooñuparã, apero macana na cabai yajiro na cayaa repa yepa. To bairi jĩca paʉ carupa tucũrore ríi jotʉrire cawei ríire cʉ cajeeri tucũro cawapayeyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","To bairi yucʉ quena ti paʉ camajocʉre cajĩarique cawapacʉti tucũro aniri camajocʉ rií tucũro cawamecʉti paʉ ã ti paʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","To bairo cabairije Dio ye quetire buiori majocʉ Jeremía tirʉmʉpʉ macacʉ ocõo bairo cʉ caĩ buio jʉgoyeyericarore bairona cabaiyupa: Niyeru cuiri treinta cuiri caajiyarijere Israel maja, “To cõo jã wapayegarã,” na caĩ cũrique cõo wapayegarãma. ");
INSERT INTO tav_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ríi jotʉri weri majocʉ cʉ caríi jeeri tucũrore to cõo wapayegarãma, Dio yʉ cʉ caĩ buio jʉgoyeyericarore bairona átigarãma, caĩ ucayupi Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","To bairi Jesure Roma macacʉ gobiernore carotibojaʉ Pilato tʉpʉ cʉ cañe aájuparã. To bairi Pilato Jesure cʉ tʉjʉʉ ocõo bairo cʉ caĩ jeniñañupʉ: —¿Judío maja ʉpaʉna mʉ ãti mʉa? cʉ caĩ jeniñañupʉ Pilato. To bairo cʉ caĩ jeniñaro: —Mʉ caĩrore bairona yʉ ã, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","To bairi sacerdote maja ʉparã, cabʉcʉrã carotirã seeto cʉ cawadajãñuparã Pilatore. Seeto na cawadajãrije to cãnibato quena Jesu na cayʉquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","To bairo Jesure, “Rooro átinucumi,” cʉ na caĩ wadajãrijere apii ocõo bairo cʉ caĩñupʉ Pilato Jesure: —¿Nope ĩi capee roorije mʉre na caĩrijere mʉ yʉgaquẽeti? cʉ caĩñupʉ Pilato Jesure. ");
INSERT INTO tav_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","To bairo Pilato cʉ caĩro apibacʉ quena, “Jocarã yʉ ĩma,” cʉ caĩ yʉquẽjupʉ Jesu. To bairo cʉ cayʉquẽto Pilato caacʉa tʉjʉyupʉ. Dope bairo caĩ tʉgooña majiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","To cãnacã cʉma ti boje rʉmʉ cãno nii camaja na caboʉre preso cãcʉre cabuunucuñupʉ Pilato, Roma macacʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","To bairi ti paʉ cãno preso na cajooricʉ cãñupʉ jĩcaʉ Barrabá cawamecʉcʉ, camaja nipetirã caroorije cʉ cátajere na camajii. ");
INSERT INTO tav_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","To bairi Pilato cʉ tʉpʉ caneñaporãre ocõo bairo na caĩ jeniñañupʉ: —¿Ni macare cʉ yʉ cabuuro mʉja booti? ¿Barrabá macare o Jesu, Cristo na caĩire? na caĩ jeniñañupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","To bairona na caĩ jeniñañupʉ, Jesure cʉ tutibana cʉ̃re yʉ jĩa rotima ĩi. ");
INSERT INTO tav_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato camajare cʉ cabejeri arʉapʉ caruii cãñupʉ. Topʉ cʉ caruiri paʉna cʉ nʉmo ocõo bairo cʉ caĩ jooyupo: “Jĩ caroorije cátiquetacʉre rooro cʉ átiqueticõaña. Mepʉ macá ñamire rooro yʉ quẽguewʉ cʉ cabairijere. Rooro yʉ tamʉo tʉgooñawʉ, cʉ cabairijere quẽguebaco,” cʉ caĩ jooyupo co manapʉ Pilatore. ");
INSERT INTO tav_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pilato ¿dope bairo yʉ ácʉati Jesure? cʉ caĩ tʉgooñari paʉna sacerdote maja ʉparã, aperã cabʉcʉrã to cãna paarãacãre ocõo bairo Pilatore cʉ caĩ rotiyuparã: —“Cʉ buuya Barrabáre. Jesu macare cʉ jĩa rotiya,” cʉ ĩña Pilatore, na caĩñuparã to cãnare. ");
INSERT INTO tav_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","To bairi Pilato ocõo bairo na caĩñupʉ: —¿Ni macare yʉ cabuu jooro mʉja booti? na caĩ jeniñañupʉ Pilato tunu. —Barrabáre cʉ buuya, caĩñuparã to cãna camaja paarãacã. ");
INSERT INTO tav_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","To bairo cʉ na caĩro: —¿To roque dope bairo yʉ ácʉati Jesure, Cristo na caĩire? na caĩñupʉ Pilato. —Yucʉ tẽorica pãipʉ Jesure na papua jĩa roticõaña polisíare, cʉ caĩñuparã nipetirã to cãna paarãacã. ");
INSERT INTO tav_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","To bairo cʉ na caĩro: —Ñee unie caroorije cátiquetacʉ ãcʉmi, na caĩbajupʉ Pilato tunu. To bairo Pilato na cʉ caĩbato quena seetobʉja: —¡Yucʉ tẽorica pãipʉ Jesure na papua jĩa roticõaña polisía majare! cʉ caĩ awajanemoñuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","To bairo na caĩ awajaro Pilato, “Dope bairo na yʉ buio majiquẽe. Yʉ awaja tutirema,” caĩ tʉgooñañupʉ. To bairi ocore waa roti, cʉ wamorire cacojeyupʉ na catʉjʉrona, caroorije cátiquẽcʉ cʉ cãnibato quenare na yʉ cajĩa rotirije yʉ ye wapa me ã, na iñoʉ. To bairo na coje iñoori ocõo bairo na caĩñupʉ: —Cʉ̃re jĩarique yʉ ye wapa me anigaro. Mʉja majuuna mʉja bai bui cʉtigarã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","To bairo cʉ caĩro: —Cʉ mʉ cajĩa rotirique wapa jã maca jã bui cʉtigarã. Jã punaa, jã pãramerã quena to bairona baigarãma, caĩñuparã Pilatore. ");
INSERT INTO tav_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","To bairo na caĩro apii na caboorijere bairona cáti rotiyupʉ Pilato. Barrabáre cʉ cabuuyupʉ. To bairi Jesu macare wecʉa ajeri wẽri mena polisíare cʉ bape roti, cʉ na papuaato ĩi Jesure na cane aá rotiyupʉ polisía majare yua. ");
INSERT INTO tav_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","To bairi Pilato yarã polisía maja ʉparã ya wii maca yepapʉ cʉ cane aájuparã Jesure. Cʉ ne aá, na yarã polisía maja nipetirã na capi neoñuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na yarã polisía nipetirãre na pi neo, Jesu ye jutiire tu we, cʉ cajã epeyuparã ʉpaʉ cʉ cajañarije cajũarije jutii uniere. ");
INSERT INTO tav_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tiere cʉ jã, ʉpaʉ cʉ capejari beto uno pejaya ĩrã, pota mena juarica beto cʉ rʉpoapʉ capeo epeyuparã. Ʉpaʉ cʉ cacʉgoricʉ uno cʉgoya ĩrã, yucʉ cʉ wamo cariape nʉgoapʉ cʉ cane rotiyuparã. To bairo átiri cʉ tʉpʉ rʉpopatua tuatu cumu eja, “Judío maja Ʉpaʉ mʉ ã,” cʉ caĩ epeyuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cabero cʉ caʉco eo re bate tuyuparã. Yucʉ, “Ʉpaʉ cʉ cacʉgoricʉ cʉgoya,” cʉ na caĩbata yucʉ ñeri cʉ rʉpoapʉre cabapeyuparã tii mena. ");
INSERT INTO tav_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","To bairo rooro cʉ ĩ epe yaparo cʉ̃re na cajãrique cajũarije jutiire catu weyuparã tunu. Tiere tu we, cʉ yere cʉ jã, yucʉ tẽorica pãipʉ cʉ papuagarã cʉ cane aájuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Maca yepapʉ cãnana Jesure ne buti aána caboca tʉjʉyuparã jĩcaʉ Simón cawamecʉcʉ Sirene macacʉre. Cʉ boca, cʉ ñe, yucʉ tẽorica pãire Jesure na capapuapa pãire cʉ capʉjaboja rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","To bairo aá, caejayuparã Gólgota na caĩri buuropʉ. Ti wame “rʉpoa õwa coro” ĩgaro ã. ");
INSERT INTO tav_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Topʉ ejarã cʉ catĩagayuparã ʉje oco capiyarije oco mena ajuriquere. Tiere caetiñañupʉ Jesu. Etiñari caetigaquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","To bairi cʉ̃re cajĩarã cʉ papua nʉcori bero cʉ jutii ãnajere cajee bateyuparã. ¿Ni maca cajeepaʉ cʉ ãti? ĩ majigarã ʉ̃ta rupaacã na wameri ucari, ñoo joo, tʉjʉri, to bairona ĩ bʉga eperi cajee bateyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jee bateri bero polisía maja cʉ catʉjʉ rui coteyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cʉ rʉpoa bui cʉ ye wapa caĩri wamere ocõo bairo cauca tuyuparã: ANI JESU ÃMI, JUDÍO MAJA ɄPAɄ MAJUU ĩrica wame. ");
INSERT INTO tav_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aperã pʉgarã cajee rutiricarãre na quenare yucʉ tẽorica pãiripʉ capapuayuparã Jesu mena cariape nʉgoa jĩcaʉ, cacõ nʉgoa maca apeĩ. ");
INSERT INTO tav_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Topʉ caneto aánucurã na capapuaricʉre tʉjʉrã cʉ cañu pua epenucuñuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Jocʉna caĩricʉ mʉ ã. “Dio ya wiire yʉ rocagʉ. Rocabacʉ quena itia rʉmʉ bero yʉ wajoagʉ ape wii yʉ camajirije mena.” Jocʉ majuuna mʉ ĩñupa. Mʉ majuuna netooña. Mʉ camajirije mena yucʉ tẽorica pãipʉ na capapuaricʉ cãnacʉ rui ajá, Dio Macʉ mʉ cãmata, cʉ caĩ epeyuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sacerdote maja ʉparã, judío majare cabuerã, aperã cabʉcʉrã ocõo bairo cʉ caĩ epeyuparã na quena: ");
INSERT INTO tav_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Aperãre canetooʉ anibacʉ quena cʉ majuuna netoo majiquẽemi. Israel maja Ʉpaʉ, Dio cʉ cajooricʉ cʉ cãmata yucʉ tẽorica pãipʉ na capapuaricʉ cãnacʉ cʉ majuuna cʉ rui aparo. Cʉ majuuna cʉ carui apata cʉ̃re mani api nʉcʉbʉgoborã. ");
INSERT INTO tav_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Diore caapi nʉcʉbʉgoʉ yʉ ã,” caĩnucubami. Dio cʉ̃re cʉ catʉjoata cʉ átinemori cʉ̃re cʉ netooato. “Dio Macʉ yʉ ã,” caĩbami. To bairi cʉ̃re cʉ átinemoato Dio cʉ̃re cʉ catʉjoata, cʉ caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Cajee rutiricarã cʉ mena na capapuaricarã quena to bairi wamena Jesure cʉ caĩ tutiyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Paaribota caejaro to cõo canaitĩacoajupe. Itia hora majuu muipu cabujuquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","To bairi yucʉ bui cʉ cãnibopa paʉ majuu las tres cãno Jesu seeto ocõo bairo capi awajayupʉ Diore: —Elí, Elí, ¿Rama sabactani? Ati wame ocõo bairo ĩgaro caĩñupe: Dio, Dio, ¿nope ĩi yʉre mʉ aáweori? caĩ pi awajayupʉ Jesu Diore. ");
INSERT INTO tav_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","To bairo cʉ caĩ awajaro apirã jĩcaarã topʉ catʉjʉnucurã ocõo bairo caĩbajuparã: —¡Jã! ¡Apiñaja! Elías cãniñaricʉre cʉ piimi, Dio ye quetire buiori majocʉ cãniñaricʉre, caĩñuparã jĩcaarã camaja to catʉjʉnucurã. ");
INSERT INTO tav_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","To bairi jĩcaʉ to catʉjʉnucuʉ atʉ aá, bujare bairo cãni bʉrʉare ʉje ocopʉ weyoo, yucʉpʉ tupua átiri cʉ cañu mʉgo jooyupʉ, cʉ etiato ĩi. ");
INSERT INTO tav_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aperã cʉ mena macana: —Mai mani yuuto. Elías tirʉmʉpʉ macacʉ Dio tʉpʉ cãnacʉ rui atíri mani capapuaricʉre cʉ átinemori cʉ ne ruioboʉmi, caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","To bairi Jesu cʉ caĩtʉjari wame tutuaro ĩ awajatʉja, cariacoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesu cʉ cabai yajiri paʉ majuu Dio wii pupeapʉ macá arʉare na cayo matarica ajero juti ajero cawoocoa atʉ aájupe carecomaca mena to majuuna. Cabui woo atʉ rui atí, cayapapʉ cawoo ejooyupe. Yepa quena cananaañupe. Ʉ̃ta rupaa quena cawaticoajupe tie majuuna. ");
INSERT INTO tav_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aperã cabai yajiricarã na cayaa rerica maja operi tie majuuna capãcoajupe. To bairo cabairo Diore caapiʉjaricarã ãnana jĩcaarã cacati tunucoajuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","To bairi Jesu cʉ cacati tunuro bero na ãnana maja operipʉ cãnibatana Jerusalén macapʉ caejayuparã Dio cʉ camairi macapʉ. To bairo cacati tunuricarãre na catʉjʉyuparã camaja capãarã. ");
INSERT INTO tav_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","To bairi polisía maja ʉpaʉ, aperã polisía maja cʉ mena macana Jesure catʉjʉ coterã yepa cananaarije, apeye cauwiorije cabairo tʉjʉrã seeto cauwiyuparã. —Cariapena yʉ ĩ. Ani Dio Macʉ majuuna ãñupi, caĩñupʉ na ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cãromia jĩcaarã yoabʉjaroacãpʉ catʉjʉjo tʉjʉnucuñuparã. Galilea yepa macana Jesure cátinemo nucuricarã romiri cãñuparã. ");
INSERT INTO tav_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jĩcao María Magdalena cãñupo. Apeo María (Jacobo, José jãa paco) cãñupo. Apeo Sebedeo nʉmo cãñupo. Aperã quena cãñuparã na mena, Jesu mena Jerusalẽpʉ caejaricarã. ");
INSERT INTO tav_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cabero canaiori paʉ jʉgoyeacã jĩcaʉ caapeye paii, José cawamecʉcʉ Arimatea na caĩri maca macacʉ caejayupʉ. Cʉ quena Jesure caapiʉjaʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","To bairi Pilato tʉpʉ aá, Jesu rupaʉre cʉ cajeniñupʉ, cʉ rocagʉ. To bairo cʉ caĩ jeniro: —Jaʉ, neija, cʉ caĩñupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","To bairo cʉ caĩro apii José Jesu rupaʉre ne ruio, jutiiro ajero cawama ajero mena cʉ caumañupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","To bairi cawama ope ʉ̃ta tʉare na cawerica ope cʉ majuuna cʉ cabai yajiro cʉ na carocabopa opepʉ cʉ cañujo roca cũñupʉ. Ñujo roca cũ yaparo cabipeyupʉ ʉ̃ta joroa mena. Bipe yaparo cáaácoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Topʉ cʉ na cacũ rocaro María Magdalena quena cãñupo. Cõ apeo María cawamecʉco mena catʉjʉ ruiyuparã cʉ na carocarica ope riapepʉ. ");
INSERT INTO tav_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jesure cʉ na cajĩarica rʉmʉ boje rʉmʉ na cátipere na caquenoo jʉgoyeyeri rʉmʉ cãñupe. Cabero macá rʉmʉ, judío maja na yerijãrica rʉmʉ majuu cãñupe yua. To bairi sacerdote maja ʉparã, fariseo maja mena Pilato tʉpʉ aá, ocõo bairo cʉ caĩñuparã: ");
INSERT INTO tav_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Ʉpaʉ, mani cajĩayaecʉ cacatii ãcʉpʉ, “Itia rʉmʉ bero yʉ catí tunugʉ,” caĩtowĩ. Ti wame jocʉna cʉ caĩtorica wame jã tʉgooña. ");
INSERT INTO tav_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","To bairi polisía majare cʉ ãnacʉre na carocarica paʉpʉ itia rʉmʉ caroaro na cote rotiya, cʉ buerã cãnana cʉ rupaʉ ãnatore ne aárema ĩi. Ne aáti, “Mere catí tunuñupi,” camajare na ĩtoborãma. To bairo na caĩata cʉ ãnacʉ cʉ caĩtoriquere na caapi nʉcʉbʉgoricaro netoro api nʉcʉbʉgoborãma camaja. ");
INSERT INTO tav_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","To bairo na caĩro apii: —Ati maja polisía majare na jee aánaja. Cʉ ãnacʉre na carocarica paʉre caroaro na coteato, na caĩñupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","To bairo Pilato na cʉ caĩro sacerdote maja ʉparã, fariseo maja mena polisía majare na cajee aájuparã Jesure cʉ na carocarica paʉpʉ. To bairi cʉ na carocarica ope biarica joroa bui caroaro cajʉgoocõañuparã, aperã na capãata mani tʉjʉ majiborã ĩrã. To bairo átiri polisía majare cacũñuparã, coteya na ĩrã. ");
INSERT INTO tav_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judío maja na yerijãrica rʉmʉ bero macá rʉmʉ, cabujuri paʉacã cãno, ape semana cãni jʉgori rʉmʉ majuu cãñupe yua. To bairi Jesu rupaʉre na carocarica paʉpʉ catʉjʉra ejayuparã María Magdalena, apeo María cawamecʉco mena. ");
INSERT INTO tav_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","To bairo na cabairi paʉna yepa seeto cananaañupe. To bairo cabairo watoana Dio tʉ macacʉ rui atí, ʉ̃taa joroa Jesure cʉ na carocarica ope bui na cabipebata joroare cane woocõañupʉ ángel. Ti joroare ne woo yaparo ti joroa bui caruiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bʉpo cʉ cayaberije cõo caajiyayupʉ. Cʉ jutii seeto majuu cabotirije cãñupe. ");
INSERT INTO tav_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","To bairi polisía rocarica paʉre cacotebatana cʉ̃re tʉjʉrã seeto cauwiyuparã. Uwibana, seeto nanaa, cariaricarãre bairo cabaicõa nʉcañuparã polisía maja. ");
INSERT INTO tav_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","To bairi cãromia catʉjʉra ejaricarãre ocõo bairo na caĩñupʉ ángel: —Uwiquẽja. Jesure, na capapua jĩaricʉre macarã ejarã mʉja bairã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","—Maami atore. Catí tunucoami mere, “Yʉ catí tunugʉ,” mʉjaare cʉ caĩ buioricarore bairona. Adʉja. Cʉ̃re na cañujo roca cũbata paʉre tʉjʉya, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Tʉjʉ yaparo uwaro aáti cʉ buerã cãnanare ocõo bairo na ĩ buiorãja: “Cabai yajiricʉ ãnacʉ tunu catiyupi mere. Mʉja jʉgoye aágʉmi Galilea yepapʉ, mʉja yuʉ aácʉ. Topʉ cʉ mʉja boca tʉjʉgarã,” na ĩ buiorãja, caĩñupʉ ángel na romirire. ");
INSERT INTO tav_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","To bairo na cʉ caĩro apirã rocarica paʉpʉ catʉjʉrã ejabatana romiri caatʉcoajuparã, Jesu buerã cãnanare na buiora aána. Tʉgooña uwibana quena seeto cawariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na caatʉ aátopʉ Jesu na cabocayupʉ. Na boca, na cañuu rotiyupʉ. To bairo na cʉ caĩro cʉ tʉacã atí, rʉpopatua tuatu cumu eja, seeto nʉcʉbʉgorique mena cʉ rʉporire cañeñuparã. ");
INSERT INTO tav_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","To bairo na cáto ocõo bairo na caĩñupʉ Jesu: —Uwiquẽja. Yʉ yarãre ocõo bairo na ĩ buiorãja: “Galileapʉ aánaja. Topʉ Jesure mʉja tʉjʉgarã,” na ĩ buiorãja. To bairo na cʉ caĩro cabuiora aájuparã na romiri. ");
INSERT INTO tav_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cãromia na cáaátoye polisía maja rocarica paʉre cacotebatana macapʉ aá, sacerdote maja ʉparãre nipetiro cabairiquere nare caĩ buioyuparã. ");
INSERT INTO tav_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","14","To bairo na caĩ buiorije apirã aperã cabʉcʉrã carotirã nipetirãre na pi, na mena neñapo, jĩcaro mena camaja na caĩ buiopere cawadapeniñuparã. To bairo camajare na caĩ buiopere wadapeni yaparo Jesure cʉ na carocabata paʉre cacotebatanare polisía majare ocõo bairo na caĩñuparã: —“Jesu ãnacʉ cʉ buerã cãnana ñamipʉ jã cacanitoye atí, cʉ rupaʉ ãnatore ne ruti aájupa,” na ĩ buiotoya camajare. To bairo na mʉja caĩ buiorijere Ʉpaʉ Pilato cʉ caqueti apiata cʉ̃re jã wadapenigarã, mʉja cacaniriquere queti apiri mʉjaare cʉ tutiqueticõato ĩrã. To bairo na ĩ buio rotirã, niyerure na cawapayeyuparã, to bairo jeto camajare na ĩ buioya ĩrã, polisía majare na caĩñuparã sacerdote maja ʉparã jãa. ");
INSERT INTO tav_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","To bairo na caĩro to bairo jeto camajare na caĩ buiope wapa jee, sacerdote maja ʉparã nare na caĩ rotirore bairona caĩtoyuparã polisía camajare. To bairi yucʉ quenare ti wame polisía maja nare na caĩtoriquere ame buionucuma judío maja yua. ");
INSERT INTO tav_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Cabero Galileapʉ Jesu buerã cãnana jã cáaápʉ jĩcaʉ ʉ̃taʉpʉ, “Topʉ mʉjaare yʉ boca tʉjʉgʉ,” jãre cʉ caĩricʉpʉ. Topʉ cʉ̃re jã catʉjʉwʉ. ");
INSERT INTO tav_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","To bairo cʉ tʉjʉrã rʉpopatua tuatu cumu ejari seeto cʉ̃re jã cáti nʉcʉbʉgowʉ. Jĩcaarã cʉ tʉjʉbana quena, “¿Cʉ majuuna cacati tunuricʉ cʉ ãti? jã caĩ tʉgooñawʉ. ");
INSERT INTO tav_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","To bairo jã caĩ tʉgooñari paʉna Jesu jã tʉacãna atí, ocõo bairo jã caĩwĩ: —Ati ʉmʉrecoo, ati yepa nipetiro carotipaʉre yʉ cũmi Dio. ");
INSERT INTO tav_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","To bairi camaja nipetiri poari macanare yʉ ye quetire nare mʉja buio teñarã aágarã. Na quena yʉre caapiʉjarã na ãmaro ĩrã na mʉja buio teñarã aágarã. Na caapiʉjaro nare mʉja bautisagarã mani Pacʉ cʉ carotiro mena, yʉ, cʉ Macʉ yʉ carotiro mena, Dio Espíritu Santo cʉ carotiro mena. ");
INSERT INTO tav_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","To bairo átiri nipetiro mʉjaare yʉ cáti rotiepere, “To bairona ája,” nare mʉja ĩ buio teñarã aágarã. To bairo mʉja cáto mʉja mena yʉ anicõa aninucugʉ ati ʉmʉrecoo capetiropʉ, jã caĩwĩ Jesu. To cõona ã.");
INSERT INTO tav_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Dio Macʉ ye queti caroa queti ocõo bairo cãni jʉgoyupa. ");
INSERT INTO tav_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tirʉmʉpʉ macacʉ Dio ye queti buiori majocʉ Isaía cawamecʉcʉ ocõo bairo caĩ ucayupi Jesucristo ati yepapʉre cʉ cáatípere: Camajare na canetoo catiopaʉ majuu cʉ jʉgoye yʉ joogʉ apeĩre yʉ ye quetire cabuio jʉgoyeyepaʉre. Cʉna anigʉmi camaja na yerire caroaro catʉgooña quenoo yuu rotii. ");
INSERT INTO tav_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jĩcaʉ cayucʉ mani yepapʉre camaja manopʉ awaja tʉjʉnucu teñagʉmi. Ocõo bairo ĩ buiogʉmi cʉ tʉpʉ caejarãre: “Caroaro quenoo yuuya mʉja yerire, cariape tʉgooñari mani Ʉpaʉ cʉ cáatíparo jʉgoye. Caroa macare ája,” caĩ ucayupi Isaía, Juan cʉ cabaipere Dio cʉ̃re cʉ caĩ rotiriquere. ");
INSERT INTO tav_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","To bairi Juan cayucʉ mani yepapʉre ãcʉ ocõo bairo na caĩñupʉ camajare: —Caroorije mʉja cátinucurijere jʉtiritiri mʉja yeri wajoaya. Coje rericarore bairo caroorije jã cátiere Dio cʉ majirioato ĩrã bautisa rotiya, na caĩñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Capãarã ti yepapʉ Judeapʉ macana, Jerusalén macana quena capãarã camaja Juan cʉ cabuiorijere caapirã aájuparã. Caroorije na cátajere jʉtiriti, “Caroorije cána jã ã,” Diore na caĩro Jordán cawamecʉti yapʉ na cabautisayupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Cʉ jutiiro waibʉcʉrã cameyo cawamecʉna poa mena juarica wʉ cajañanucuñupʉ Juan. Cʉ wẽarica wẽ waibʉcʉ ajero wẽ cãñupe. To bairi diroare, ñimiare ʉga, beroa ocore caetinucuñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Camajare ocõo bairo na caĩ buionucuñupʉ Juan: —Yʉ bero apeĩ yʉ netoro cãni majuʉ atígʉmi. Cʉ̃re bairo cabaii mee yʉ ã. Cawatoa macacʉ, paa coteri majocʉre bairona yʉ ã. ");
INSERT INTO tav_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Oco mena cabautisaʉ yʉ ã yʉa. Cʉ maca Espíritu Santore mʉja joogʉmi cʉ̃re caboorãre. Cʉ̃ Espíritu Santore joʉ, oco mena coje majuuricarore bairo mʉja átigʉmi, caroorije mʉja cátiere rei. ");
INSERT INTO tav_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan camajare cʉ cabautisari rʉmʉrina Jesu quena Galilea yepa Nasaré macapʉ cãnacʉ Jordán cawamecʉti ya Juan tʉpʉ caejayupʉ Jesu. Topʉ cʉ caejaro cʉ cabautisayupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cʉ cabautisaro bero Jesu camaa nʉcañupʉ ti ya tʉjaro. Maanʉca, ʉmʉrecoo jope capãro catʉjʉyupʉ Jesu. Cʉ catʉjʉro buare bairo bauʉ Espíritu Santo carui ajupʉ Jesu bui. ");
INSERT INTO tav_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","To bairo cʉ cabairi paʉna ʉmʉrecoopʉ cʉ Pacʉ cʉ cawadarijere caapiyupʉ Jesu: —Yʉ Macʉ, yʉ camai netoʉ majuu mʉ ã. Seeto mʉ yʉ tʉjʉ wariñuu, cʉ caĩñupʉ Dio Jesure. ");
INSERT INTO tav_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesure Juan cʉ cabautisaricaro bero nemoona Espíritu Santo cʉ cane aájupʉ cayucʉ mani yepa, camaja manopʉ yua. ");
INSERT INTO tav_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesu topʉre cuarenta rʉmʉri majuu cãñupʉ. Waibʉcʉrã cauwarã watoapʉ cãñupʉ. Topʉ Jesu cʉ cãno Sataná maca ¿Diore cʉ bai netoo nʉcabocʉti? ĩi ricati wame caroori wamere cʉ cáti rotibajupʉ. Jesure Sataná to bairo cʉ caĩ wadajãrona Dio tʉ macana cʉ cacotera ejayuparã ángel maja Jesure. ");
INSERT INTO tav_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cabero ʉpaʉ Herode Juan camajare bautisari majocʉre presopʉ cʉ cajõoñupʉ. Juan presopʉ cʉ cãnitoye Jesu Galilea yepapʉ cáaájupʉ tunu, Dio ye quetire buio teñaʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ocõo bairo caĩ buio teñañupʉ: —Mere ejatʉgami mʉja tʉpʉre yoaro mʉja cayuuricʉ. Yucʉacãna mere Ʉpaʉ jãagʉmi. To bairi caroorije mʉja cátinucurijere jʉtiritiri mʉja catʉgooñarijere wajoaya. Dio camajare na netoo catiogʉmi ĩriquere api nʉcʉbʉgoya, caĩ buio teñañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cabero Jesu Galilea cawamecʉti ra ʉtabʉcʉra tʉjaropʉ cáaáteñañupʉ. Ti ra tʉjaro aáteñaʉ topʉ Simón, apeĩ cʉ bai André na cabʉga ejayupʉ. Wai wajari maja cãñuparã naa. To bairi Jesu na tʉpʉ cʉ caejari paʉna bapire caroca ñuañuparã ti rapʉre. ");
INSERT INTO tav_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","To bairo na cáto tʉjʉʉ: —Jitá yʉ mena, na caĩñupʉ Jesu. —Caroaro mʉja wai waja maji. Yucʉra yʉ mena aána camajare Dio ye quetire mʉja buio majigarã. To bairo mʉja caĩ buiorijere apirã na quena Diore caapiʉjarã anigarãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","To bairo cʉ caĩrijere apirã nemoona na bapi yucʉre piti cũ, Jesu mena cáaácoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu petoacã aánemoʉ pʉgarãre na cabʉga ejayupʉ. Sebedeo punaare Jacobo, cʉ bai Juan jãare na cabʉga ejayupʉ. Bapi yucʉ cawooriquere jia quenoorã cumuapʉ cáti jañañuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na quenare na capiyupʉ Jesu. To bairo na cʉ caĩ piro apiri na pacʉ Sebedeore, cʉ paari majare na cáaáweoyuparã, Jesu mena aána yua. ");
INSERT INTO tav_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Cabero Capernaum cawamecʉti macapʉ caejayupʉ Jesu cʉ buerã mena. Sábado cãno judío maja na yerijãrica rʉmʉ cãno na caneñaponucuri wiipʉ cajãa ejayupʉ Jesu. Ti wiipʉ jãa ejaʉ ti wiipʉ cãnare na cabuio jʉgoyupʉ Dio ye quetire. ");
INSERT INTO tav_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesu cʉ cabuiorijere apirã api wariñuubana quena caapi acʉacoajuparã, caroaro camaji netoʉ ãmi ĩrã. Nare cabuionucurãre bairo na cabuioquẽjupʉ Jesu maca. ");
INSERT INTO tav_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti wii na caneñapori wiipʉ jĩcaʉ cawãti jãa ecooricʉ cãñupʉ. Ocõo bairo caĩ awajayupʉ: ");
INSERT INTO tav_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Jesu, Nasaré macacʉ! ¡Jã patowãcooqueticõaña! ¿Jãre rei acʉ́ mʉ bairi? Mʉ yʉ tʉjʉ maji. Dio cʉ cajooricʉna mʉ ã mʉa, caroorije cátiquẽcʉ. Cañuu netoʉ majuu mʉ ã, cʉ caĩ awajayupʉ cawãti jãa ecooricʉ. ");
INSERT INTO tav_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","To bairo cʉ caĩ awajaro apii Jesu wãti camajocʉpʉre cajañaʉre cʉ tutii ocõo bairo cʉ caĩñupʉ: —¡Janacoacʉja! To cõona buti aácʉja, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","To bairo Jesu cʉ caĩrona wãti camajocʉpʉre cãcʉ cʉ cayugui mecʉ riañao joroque cʉ cájupʉ. To bairo cʉ áti, seeto majuu caawajacoa buti aájupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","To bairo cʉ cabairo tʉjʉrã ti wiipʉ caneñaporã catʉjʉ acʉacoajuparã. Tʉjʉ acʉa, na majuuna caame jeniñañuparã: —¿Ñee unie to ãti ati wame cʉ cawama buerije? Wãtia camajapʉre cajañarã quenare na buu recõami. Na cʉ cabuti rotirona buticoapa, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","To bairi yoaro mee Jesu cʉ cãnie quetire Galilea yepa macana caqueti api peticoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesu neñaporica wiipʉ butiri bero Simón, André jãa ya wiipʉre caejayuparã Jacobo, Juan, Jesu jãa. ");
INSERT INTO tav_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ti wiipʉre Simón mañico bʉgoye riao cájupo. Jesure, “Riao áamo,” cʉ caĩ buioyuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesu to bairo na caĩro apii co catʉjʉ jãajupʉ. Jãa, co wamopʉ ñe, co catʉ̃ga wamʉo nʉcoñupʉ. To bairo cʉ cátona nemoo bʉgoye cajanacoajupe. To bairi catí wamʉnʉca, nare caʉgarique peobojayupo yua. ");
INSERT INTO tav_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Muipu cʉ caroca jãaro bero canaiori paʉ bero cãno camaja nipetirã cariaye cʉnare, cawãtiacʉna quenare na cajee ejayuparã Jesu tʉpʉre. ");
INSERT INTO tav_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","To bairi nipetirã ti maca macana jope tʉpʉ caneñapoyuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","To bairo na caneñaporo tʉjʉʉ capãarã cariarãre na cariaye cʉtiere na canetoobojayupʉ Jesu. Ricati wameri jeto na cariaye cʉtiere na cacatioyupʉ. Cawãtia jañarã quenare na canetooñupʉ Jesu. Wãtiare na buu rei na cawada rotiquẽjupʉ, Dio Macʉ yʉ cãniere camajare na ĩqueticõato ĩi. ");
INSERT INTO tav_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ape rʉmʉ cabujuparo jʉgoye Jesu yopi, ti maca tʉjaro camaja manopʉ Diore cajenii aájupʉ. ");
INSERT INTO tav_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Cabero Simón, aperã cʉ mena macana mena Jesure camacara aájuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cʉ̃re bʉga ejarã, ocõo bairo cʉ caĩñuparã: —Camaja nipetirã mʉre macarã áama, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","To bairo na caĩro: —Jitá apero catʉacã cãni macaripʉ. Topʉ quenare yʉ ye quetire na yʉ buiogʉ. Tierena buio teñaʉ acʉ́ yʉ cáapʉ́ ati yepapʉre, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","To bairi Jesu nipetiro Galilea yepapʉ camaja na caneñaponucuri wiiripʉ na cabuio teñanucuñupʉ. Cawãtia cʉnare na carebojanucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesu Galileapʉ cʉ cãno jĩcaʉ camajocʉ carupaʉ ajeri boaʉ Jesu tʉpʉ caejayupʉ. Cʉ tʉ eja, rʉpopatua mena tuatu ejacumuri ocõo bairo cʉ caĩñupʉ Jesure: —Yʉ carupaʉ ajero boarijere yʉ mʉ canetoogaata mʉ netoo maji. ");
INSERT INTO tav_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu cʉ bopacoo tʉjʉʉ cʉ pañari ocõo bairo cʉ caĩñupʉ: —Mʉre yʉ netoogʉ. To cõona mʉ caboarije mʉre yaticoagaro. ");
INSERT INTO tav_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","To bairo cʉ caĩrona cʉ caboabataje nemoona cayati peticoajupe yua. Carupaʉ boaquẽcʉ cãñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cabero Jesu, caroaro mena aácʉja ĩi, cariape cʉ caĩ buioyupʉ: ");
INSERT INTO tav_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Aperãre mʉre yʉ canetoorijere na buioquẽja mai. Cariapena aácoacʉja Dio wii macacʉ sacerdote majocʉ tʉpʉ. Aá, mʉ cacami boariquere cayatirijere cʉ iñooña. Cʉ majuuna tʉjʉʉ, “Yati peticoajupa,” ĩgʉmi. To bairo mʉre cʉ caĩro bero Diore mʉ canʉcʉbʉgorijere iñoori waibʉcʉ mʉ cajoe buje mʉgopaʉre cʉ mʉ joogʉ sacerdote majocʉre, Moisé cʉ carotiricarore bairona. To bairo mʉ cáto camaja nipetirã majigarãma mʉ cacami yatirijere. ");
INSERT INTO tav_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","To bairo Jesu cʉ caĩriquere cátiquẽjupʉ cacami boaricʉ. Átiquẽcʉna aá, nemoona camaja nipetirãre na cabuio bate peocõañupʉ. To bairi Jesu camaja capãarã na cãni macaripʉre caeja majiquẽjupʉ yua. Ti macari tʉjaropʉna cáaáteñañupʉ Jesu camaja capãarã na camanopʉ. Macaripʉ cʉ cãniquetibato quena camaja capãarã nipetiro macana Jesure cʉ catʉjʉrã ejanucuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Capee rʉmʉri bero meena carupaʉ ajeri boaʉre cʉ cacatioricaro beroacãna Capernaupʉ catunu aájupʉ Jesu tunu. Topʉ cʉ cãno aperã, “Ti wiipʉ ãcʉmi,” caĩ majiñuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","To bairi nemoo camaja capãarã Jesu tʉpʉ caneñañuparã. Capãarã majuu na caneñaro ti wii cajira netocoajupe. To bairi jope tʉpʉ quenare cajiracoajuparã. To bairi cʉ ye quetire na cabuioyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","To bairi cʉ caĩ buio ani paʉna Jesu tʉpʉ jĩcaʉ cáaá majiquẽcʉre bapari cãnacãʉ caʉmʉa cariaʉre yo nericaro mena cʉ cayo ne ejayuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jesu tʉacã capãarã majuu camaja na cãno Jesu tʉpʉre cajãa eja majiquẽjuparã. Jãa eja majiquetibana wii buipʉ wamʉ aá, Jesu cʉ catʉjʉnucuro bui majuu jĩca ope cajee weyuparã. Ti opepʉ cáaá majiquẽcʉre cʉ̃re na cayo neata yeje menana cayo ruio jooyuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","To bairo cʉ̃re na cayo ruio jooro tʉjʉʉ, “Caroaro yʉre catʉgooña nʉcʉbʉgorã ãnama,” caĩ majiñupʉ Jesu. To bairo ĩ majiri: —Yʉ yaʉ, caroorije mʉ cátajere mʉ yʉ majiriobojacõa, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","To bairo cʉ̃re cʉ caĩro apirã topʉ caruirã Moisé ãnacʉ cʉ caucariquere cabueri maja ocõo bairo caĩ tʉgooñañuparã: ");
INSERT INTO tav_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nope ĩi ani to bairo cʉ ĩti? Diore rooro ĩmi. Dio jĩcaʉna ãmi caroorije átajere camajiritio majii,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesu to bairo na caĩ tʉgooñarijere tʉjʉ majiri ocõo bairo na caĩñupʉ: —¿Nope ĩrã to bairo yʉre mʉja ĩ tʉgooñati? ");
INSERT INTO tav_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","—Cáaá majiquẽcʉre, “Caroorije mʉ cátajere majiritioʉ yʉ áa,” cʉ yʉ caĩro, “Jocʉna ĩmi,” mʉja ĩrã. “Wamʉnʉcacoa aácʉja,” cʉ yʉ caĩata cʉ riaye to canetoro yʉ catutuarijere mʉja tʉjʉ majigarã. To bairi mʉja catʉjʉro cʉ riayere yʉ netoogʉ. Cʉ yʉ canetooro camaja caroorije na cátajere na yʉ camajiritioboja majirije quenare mʉja tʉjʉ majigarã. “Dio Macʉ camaja tʉpʉ cʉ cajooricʉ caroorije camaja na cátajere na majiritioboja majimi,” yʉre mʉja caĩ majiparore bairo ĩi, cʉ yʉ netoogʉ, na caĩñupʉ Jesu. To bairo na ĩi, cáaá majiquẽcʉre ocõo bairo cʉ caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Wamʉnʉcaña, mʉ cuñaricarore tune ne, mʉ ya wiipʉ tunu aácʉja, mʉre yʉ ĩ, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","To bairo cʉ̃re cʉ caĩrona cáaá majiquetibatacʉ cawamʉ nʉcañupʉ. Wamʉnʉca, cʉ cuñaricarore tune, camaja nipetiro na catʉjʉro cáaácoajupʉ. To bairo cʉ cabairo camaja nipetiro catʉjʉ acʉacoajuparã. Tʉjʉ acʉari Diore cʉ ĩ nʉcʉbʉgorã ocõo bairo caĩñuparã: —To bairije catʉjʉya maninucuwʉ, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu cáaá majiquẽcʉre catiori bero, ʉtabʉcʉra tʉjaropʉ cáaájupʉ tunu. Topʉ cʉ cãno camaja capãarã caneñapoyuparã cʉ tʉpʉ. Cʉ tʉpʉ camaja capãarã na caneñaporo tʉjʉʉ Dio ye quetire na cabuioyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Topʉ neto aácʉ Leví, Alfeo macʉre cʉ catʉjʉyupʉ. Leví maca gobierno ye cãnipere camaja ye niyeru jeebojari majocʉ cãñupʉ. To bairi cʉ capaari arʉapʉ caruiyupʉ. Jesu topʉ cʉ caruiro cʉ tʉjʉʉ ocõo bairo cʉ caĩñupʉ: —Jitá yʉ mena. To bairo cʉ caĩrona Leví wamʉnʉca, Jesu mena cáaácoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cabero Jesu Leví mena cʉ ya wiipʉ caʉgaʉ aájupʉ. Capãarã niyeru gobiernore camaja yere jeebojari maja, caroorije cátinucurã quena cãñuparã. To bairo cabairã capãarã Jesu mena cáaáteñarã cãñuparã. To bairi na quena Jesu buerã mena Leví ya wiipʉ caʉga ruiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","To bairo na cabairo catʉjʉyuparã judío majare cabuerã, aperã fariseo maja. Jesu capãarã niyeru gobiernore jeebojari maja, aperã, “Caroorã ãma,” camaja na caĩ tʉgooñarã mena cʉ caʉgaro tʉjʉrã, cʉ buerãre ocõo bairo na caĩñuparã: —¿Nope ĩi mʉjaare cabuei gobiernore camaja ye niyeru jeebojari maja mena, caroorijere cátinucurã mena cʉ bapacʉti ʉganucuti? caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu to bairo na caĩro apii ocõo bairo na caĩñupʉ: —Cariaye mana ʉcoyeri majocʉre macaquẽnama. Cariayecʉna maca ʉcoyeri majocʉre macarãma. To bairona, “Caroarã jã ã,” caĩrãre na átinemoʉ acʉ́ mee yʉ cáapʉ́. Caroorã macare caroorije na cátiere jʉtiriti rotii yʉ cáapʉ́. Rooro na catʉgooñarijere na wajoa rotii acʉ́ yʉ cáapʉ́, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jĩca rʉmʉ Juan camajare bautisari majocʉ cʉ cabuerã, fariseo maja quena ʉgaqueti Diore cajeni nʉcʉbʉgoyuparã. To bairo cabairã jĩcaarã Jesu tʉpʉ aá, ocõo bairo cʉ caĩ jeniñañuparã: —Juan camajare bautisari majocʉ cʉ cabuerã ʉgaquẽnana Diore jeni nʉcʉbʉgonucuma. Fariseo maja na cabuerã quena to bairona átinucuma. ¿Nope ĩrã mʉ cabuerã maca to bairo na baiquẽeti? caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","To bairo na caĩ jeniñaro Jesu maca ocõo bairo na caĩñupʉ: —Jĩcaʉ cʉ cawamo jiari boje rʉmʉ cʉ cáto cʉ mena macana tʉgooñarique pai ʉgaqueti baiquẽnama. Nipetiro wariñuurãma cʉ mena ãnaa. ");
INSERT INTO tav_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Cabero ape rʉmʉ aperã aperopʉ cʉ̃re na cañe aápata to cõona tʉgooñarique pai ʉgaqueti wariñuuquetiborãma, na caĩñupʉ Jesu. Cʉ buerã mena cʉ cãnona na caʉgaqueti tʉgooñarique pai majiquẽtiere na ĩ buioʉ na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ape wame tunu queti buio majiorica wame na caĩ buioyupʉ. Cʉ ye queti fariseo maja jãa jocarãna na caĩ buiorije mena catʉgooña ajuquetipe ã, ocõo bairo na caĩ buioyupʉ: —Camajoco jutiro cawamaro cajañaña manore woo nequẽcomo cabʉcʉrore e tuugo. To bairo co cápata cawama rʉca rʉgaboro mʉja cacojero. To bairo rʉgari netobʉjaro wooboro, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","—Vino ʉje oco etirique cawama mʉja cátiere cabʉcʉ poa wecʉ ajero erica poare mʉja pio jãa majiquẽna. Cabʉcʉ poapʉrena mʉja capio jãata ti poa woocoaboro. To bairi ʉje oco pio recoaboro yua. To bairi vino cawamare cawama poa mena capio jãpe ã, caĩñupʉ Jesu. To bairo ĩi cʉ ye mena fariseo maja ye mena caajuquetipe ã ĩi, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jĩca rʉmʉ judío maja na cayerijãri rʉmʉ cãno Jesu cʉ buerã mena trigo wejepʉ caneto aájupʉ. Cʉ buerã ti wejepʉ neto aána trigore catune jee ʉgayuparã. ");
INSERT INTO tav_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","To bairo na cajee ʉga neto aáto tʉjʉrã fariseo maja Jesure cʉ caĩ tutiyuparã: —¿Nope ĩrã mʉ buerã yerijãrica rʉmʉ cãnibato quena capaa rotiya maniere na áati? ");
INSERT INTO tav_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","To bairo na caĩro ocõo bairo na cayʉyupʉ Jesu: —Tirʉmʉpʉ macacʉ mani ñicʉ jãa Ʉpaʉ David ãnacʉ cʉ mena macana mena ñigo boabana na cátajere mere mʉja bue tʉgaricarã. ");
INSERT INTO tav_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar cawamecʉcʉ sacerdote maja ʉpaʉ cʉ cãni yʉtea cãno David Dio wiipʉ jãa áti, cajawapʉ capejarije ʉgarica rupaare Diore na cajoobatajere jee ʉga átiri cʉ mena macana quenare na canuñupʉ. Sacerdote maja aniquetibana quena tiere caʉgayuparã. Sacerdote maja jetore na caʉga rotirique cãnibajupa. ");
INSERT INTO tav_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu apeye na caĩnemoñupʉ tunu: —Caroaro mani cãnipere yerijãrica rʉmʉre cacũñupi Dio. Ti rʉmʉ maca manire to rotiato ĩi mee cacũñupi. ");
INSERT INTO tav_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","To bairi yʉ camaja tʉpʉ Dio cʉ cajooricʉ caroti majii aniri yerijãrica rʉmʉ cãno cátipe quenare caroti majii yʉ ã. ");
INSERT INTO tav_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Cabero Jesu cajãañupʉ ape wii judío maja na caneñapo buenucuri wiipʉ tunu. Topʉ cãñupʉ jĩcaʉ cawamo rooye tuaricʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aperã fariseo maja topʉ cãna Jesure catʉjʉ coteyuparã, ¿yerijãrica rʉmʉ cãno cʉ̃re cʉ netoʉati? ĩrã. Cʉ̃re cʉ canetoata ʉparãre cʉ mani wadajãgarã ĩrã to bairo cʉ catʉjʉ coteyuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu yua cawamo rooye tuaricʉre ocõo bairo cʉ caĩñupʉ: —Adʉja yʉ tʉ maca, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","To bairo cʉ tʉpʉ cʉ cáató tʉjʉʉ fariseo majare ocõo bairo na caĩñupʉ Jesu yua: —¿Yerijãrica rʉmʉ cãno cañuurije cátipe to ãti? o ¿caroorije macare cátipe to ãti que? ¿Camajare na cacatiope to ãti? o ¿nare cajĩape to ãti? To bairo cʉ caĩro na maca dope bairo caĩquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Cʉ̃re na cayʉgaquẽto, cʉ̃re na caapigaquẽtore jʉtiritiri ocõo bairo cawamo rooye tuaricʉre cʉ caĩñupʉ Jesu: —Mʉ wamore ñujoya. To bairo cʉ caĩro cʉ wamore cañujoyupʉ. Cʉ cañujorona cañuucoajupe cʉ wamo yua. ");
INSERT INTO tav_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","To bairo Jesu cʉ̃re cʉ canetoo catioro tʉjʉrã fariseo maja cabuticoajuparã. Buti, Herode ya poa macana mena cawadapeni jʉgoyuparã, ¿dope bairo Jesure cʉ mani áti rocarãati? ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","10","Cabero Jesu neñapo buerica wiipʉ cãnacʉ cʉ buerã mena ʉtabʉcʉra tʉjaropʉ cáaájupʉ yua. Capãarã Galilea yepa macana, Judea yepa macana quena cʉ caʉja aájuparã, capee caroa cʉ cáti iñoorije queti apirã. Jerusalén maca macana, Idumea macana, Jordán na caĩri ya ape nʉgoa macana quena, Tiro, Sidón cawamecʉtie macana Jesu tʉpʉ caejayuparã camaja capãarã majuu, cʉ cáti iñoorijere queti apirã. Cʉ tʉpʉ caejarãre na cacatioyupʉ Jesu cariarãre. Capãarã cʉ cacatioro maca nipetirã cariarã cʉ tʉacã jeto caneñapoyuparã, cʉ pañagarã. Cʉ̃re pañari mani netogarã ĩrã to bairo cájuparã. Capãarã majuu na caʉtabijaro tʉjʉʉ cʉ buerãre jĩca cumua na caquenoo yuu rotiyupʉ Jesu, camaja yʉ tuperema, tiapʉ jañari na yʉ buiogʉ ĩi. ");
INSERT INTO tav_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cawãtia jaña ecoorã cʉ tʉjʉrã cʉ tʉpʉ rʉpopatuaripʉ catuatu ejacumuñuparã. Ejacumuri, “¡Dio Macʉ majuuna mʉ ã!” cʉ caĩ awajayuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesu maca Dio Macʉ cʉ caniere na buio rotiquetiri na cajana rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cabero Jesu ʉ̃taʉpʉ wamʉ aá, cʉ buerã cãniparãre cʉ cabejeparãre na pijo, na cabejeyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","To bairi na cabejeyupʉ cʉ mena cabue teñanucuparãre doce majuu. Na beje, cʉ ye quetire na cabuio roti jooyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Cariarãre catio majirique quena, to bairi wãtiare cabuu roti majirije quenare na cajooyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ato cãnacãʉ na cabejeyupʉ: Simón, Pedro cʉ cawame wajoaricʉre cʉ cabejeyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, cʉ bai Juan Sebedeo punaare na cabejeyupʉ Jesu. Boanerges na cawameyeyupʉ Jesu, “Bʉpo Punaa” ĩrica wame. ");
INSERT INTO tav_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aperã André, Felipe, Bartolomé, Mateo, Tomás, Jacobo Alfeo macʉ, Tadeo cãñuparã. To bairi Simón cananista poa macacʉ quena cãninemoñupʉ na mena. ");
INSERT INTO tav_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote caberopʉ Jesure catʉjʉ tutirãre cawadajãpaʉ quenare cʉ cabejebajupʉ Jesu. To cãnacãʉna cãñuparã Jesu cʉ cabejericarã, cʉ ye quetire cabuio teñanucuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cabero Jesu cʉ buerã mena cʉ cãni wiipʉ cajãañupʉ, na mena ʉgagʉ. Topʉ cʉ cãno camaja capãarã caneñapoyuparã. To bairi ti wii cajira netoro caʉga majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","To bairo na cabairo Jesu yarã caqueti apiyuparã. Queti apirã, “Jã yaʉ mecʉ bairicʉmi,” ĩ tʉgooñari cʉ capira aájuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aperã Jerusalẽpʉ cáatána judío majare cabuerã ocõo bairo caĩñuparã: —Sataná Beelsebú cawamecʉcʉ, wãtia ʉpaʉ cʉ jãaricʉmi Jesure. To bairi wãtia ʉpaʉ cʉ catutuarije mena wãtiare na buu reimi, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","To bairo na caĩro apii Jesu na pijo, ocõo bairo na caĩ buio majioñupʉ: —Sataná cʉ majuurena dope bairo roca buu majiquẽcʉmi. ");
INSERT INTO tav_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jĩca maja ame quẽrã na majuuna ame reborãma. ");
INSERT INTO tav_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","To bairi jĩca wii macana ame tutirã jĩca wiina ani majiquetiborãma. ");
INSERT INTO tav_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","To bairi Sataná cʉ majuuna cʉ carocaata cʉ majuuna bai yajicoaboʉmi. Cʉ yarã mena cʉ caamequẽata cʉ yarã aniquetiborãma. ");
INSERT INTO tav_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jĩcaʉ seeto catutuaʉ caquẽ ocabʉti majii yere emagarã aperã maca cʉ ya wiipʉre jãa majiquẽnama, cʉ uwibana. Cʉ quẽ netogarã, cʉ yere emagarã jʉgoye cʉ̃re jia tu cũborãma, na caĩñupʉ Jesu, yʉ maca Sataná netoro catutuaʉ majuu yʉ ã ĩi. ");
INSERT INTO tav_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Cariapena mʉjaare yʉ ĩ. Camaja caroorije na cátie, Diore rooro na caĩrije quenare na majiriogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dio Espíritu Santore caroorije caĩ ũcʉ maca camajiriobojaya mácʉ aninucucõagʉmi. To cãnacã rʉmʉna cabui pacoʉ anicõagʉmi, Espíritu Santo macare caroorije caĩ ũcʉ. ");
INSERT INTO tav_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Espíritu Santo cʉ catutuarije mena Jesu cʉ cátibato quena, “Cawãti cʉgoʉ ãmi Jesu, Sataná cʉ catutuarije mena áami Jesu,” na caĩrijere apii to bairo na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","To bairo cʉ caĩri paʉ Jesu paco, cʉ bairã cʉ camacarã ejayuparã. Jope tʉpʉna ejanʉcari jope tʉ catʉjʉnucurãre Jesure cʉ capi rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","To bairi Jesu tʉ caruirã: —Mʉ paco, mʉ bairã mʉ mena wadapenigarã macapʉ tʉjʉnucuma, cʉ caĩ buioyuparã. ");
INSERT INTO tav_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu maca ocõo bairo na caĩñupʉ: —¿Noa na ãti yʉ paco, yʉ bairã ãma, yʉ caĩ tʉgooñarã majuu? ");
INSERT INTO tav_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Cʉ tʉacã caapi ruirãre na ñu puari: —Ati maja maca ãma yʉ paco, yʉ bairã majuu yʉ catʉgooña tʉjʉrã. ");
INSERT INTO tav_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Noa Dio cʉ caboorijere cátinucurã maca yʉ bairã, yʉ bairã romiri, yʉ pacore bairona yʉ catʉgooña tʉjʉrã ãma. ");
INSERT INTO tav_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Cabero Jesu ʉtabʉcʉra tʉjaropʉ Dio ye quetire camajare na cabuio jʉgoyupʉ tunu. Camaja capãarã majuu caneñapoyuparã. Capãarã majuu na caneñaporo tʉjʉʉ Jesu cumuapʉ eja jãa, caejanumu ejayupʉ. Camaja maca paputiropʉ cãñuparã. ");
INSERT INTO tav_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Topʉ na cãno capee wameri buio majiorica wameri mena na cabuioyupʉ. Nare buio majioʉ, ocõo bairo na caĩ buioyupʉ: ");
INSERT INTO tav_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Apiya mʉjaa yʉ cabuiorijere: Jĩcaʉ camajocʉ cʉ ya wejepʉre trigo apeacãre caote aájupʉ. ");
INSERT INTO tav_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jĩca rupaa cʉ caoterije ma tʉpʉ cawẽñupe. To bairi minia ti rupaare tʉjʉ rui atí, caʉga recõañuparã. ");
INSERT INTO tav_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Ape rupaa ʉ̃ta yepapʉ care cumuñupe cajita manibʉjaropʉ. To bairi jita põreroacã cãno nʉcoo joo majiqueti, caputibatato beroacã muipu cʉ caajiro cajini recoajupe. ");
INSERT INTO tav_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ape rupaa tunu cʉ cayaye bate oterije pota yucʉ watoapʉ care cumuñupe. To bairi caputibata apearire pota yucʉ maca bʉcʉa neto, caputi biacoajupe. To bairi tie carica cʉtiquẽjupe. ");
INSERT INTO tav_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ape rupaa care cumuñupe caroa yepa cajita cʉti paʉre. To bairi tie caroaro puti, bʉcʉa, caroaro carica cʉticoajupe. Jĩca rupaari carica cʉjupe treinta rupaari. Ape rupaari sesenta rupaari carica cʉjupe. Ape rupaari tunu cien rupaari carica cʉjupe, na caĩ buioyupʉ Jesu, cumuapʉ ruiri petapʉ catʉjʉnucurã paarãacãre yua. ");
INSERT INTO tav_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","—Yʉ caĩ buiorijere apiri caroaro apiʉjaya, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cabero camaja paarãacã na cáaáto bero cʉ mena macana, cʉ buerã doce cãna quena cʉ caĩ jeniñañuparã: —¿Dope bairo ĩ buiogʉ mʉ ĩri mʉ caĩ buioejere? ");
INSERT INTO tav_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","To bairo cʉ̃re na caĩ jeniñaro ocõo bairo na caĩ buioyupʉ Jesu: —Ʉpaʉ cʉ cãnie quetire majioʉ áami Dio mʉjaare cajʉgoye camajare cʉ camajioquetajere. Aperã yʉre caapiʉjaquẽna macare buio majiorica wameri mena na yʉ buio. ");
INSERT INTO tav_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","To bairi na maca yʉ cátiere tʉjʉ, yʉ cabuiorijere api, baibana quena api puoquẽema. To bairi caroorije na cátiere wajoagaquẽema. “Caroorije jã cátajere jã majiriobojaya,” Diore jeniquẽema, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Apeye na caĩnemoñupʉ Jesu tunu: —¿Mʉjaare yʉ caĩ buio majiobaé wamere mʉja api puoquẽeti? To roquere tiere mʉja caapiquẽpata ape wameri yʉ cabuio majiorije quenare dope bairo áti mʉja api puoquetiborã. ");
INSERT INTO tav_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ocõo bairo ã: Oteriquere caotei Dio ye quetire cabuioʉre bairo ãmi. ");
INSERT INTO tav_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","To bairi jĩcaarã Dio ye quetire apibana quena api puoquẽema. Sataná na yeripʉ atí, na caapibatajere ema jee rericarore bairo nare áami, na majiriticõato ĩi. Ma tʉ care cumurique minia na caʉga reriquere bairona cãna ãma camaja to bairo cabairã. ");
INSERT INTO tav_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aperã camaja ʉ̃ta yepa jita põreroacã cãni yepapʉ care cumuriquere bairona cabairã ocõo bairo ãma Dio Wadariquere jĩacã caapirã. Nemoopʉre Dio ye quetire caroaro api wariñuurãma. ");
INSERT INTO tav_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Api wariñuubana quena jita põreroacãpʉ care cumu putibatajere bairona, canʉcori manajere bairona yoaro apiʉjaquẽnama. Popiye nare to cãno to cõona janacõarãma. ");
INSERT INTO tav_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aperã camaja oterique aperi pota yucʉ watoapʉ care cumuriquere bairona ãma. ");
INSERT INTO tav_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Dio ye quetire apibana quena ati yepa macaje macare seeto tʉgooñanucuma. Capee apeye unie, ati yepa macajere na cacʉgo wariñuupe boo netorãma. Tiere boo netobana Dio ye queti macare apiʉja janacõarãma. To bairi pota yucʉ watoapʉ care cumurique carica manajere bairona ãma, yʉ caboorijere átiquẽnana. ");
INSERT INTO tav_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aperã camaja caroa yepa cajita cʉtopʉ care cumuriquere bairona ãma. Dio ye quetire apirã caroaro caapiʉjacõa aninucurã ãma. To bairi jĩcaarã Dio ye quetire caapiʉjarã treinta aperi carica cʉtajere bairona ãma. Aperã Dio ye quetire caapiʉjarã sesenta, aperi carica cʉtajere bairona ãma. Aperã caroaro Dio yere caapiʉjarã oterica aperi cien aperi carica cʉtajere bairona ãma yua, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ape wame na caĩ buio nemoñupʉ Jesu tunu: —Camaja jĩa bujuricarore jĩa bujurã carupa pata ẽoropʉ o cani cuñaricaro ẽoropʉ cũquẽnama. Caroaro cabaujari paʉ bui maca peorãma nipetiropʉ caroaro to ʉ̃ bujuato ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","To bairi tie cabujurore bairona yʉ cabuiorijere noa cajʉgoye caapi majiquetana api majigarãma. Cajʉgoyepʉre caapi majiña manaje to cãnibato quena api majigarãma. ");
INSERT INTO tav_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yʉ caĩ buiorijere apirã caroaro apiʉjaya, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ocõo bairo na caĩnemoñupʉ Jesu: —Mʉja caapirijere caroaro tʉgooña ʉjaya. Yʉ ye quetire mʉja caapi nʉcʉbʉgoro cõona mʉja quenare mʉja caapi majiro átigʉmi Dio. Caroaro caapi nʉcʉbʉgorãre caroaro na átinemo netogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","To bairi noa yʉ cabuiorijere caroaro caapiʉjarãre capee api majiriquere na joogʉmi Dio. Aperã maca yʉ cabuiorijere caapiʉjagaquẽna yʉ yere na caapi majibatajeacã quenare na catʉgooña mawijiaro átigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ĩ yaparoʉ, apeye na caĩ buioyupʉ Jesu tunu: —Ʉpaʉ Dio cʉ cãnie queti buiorique jĩcaʉ camajocʉ yepapʉ cʉ caoterijere bairona ã. ");
INSERT INTO tav_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ote yaparo tʉjʉ ʉjaquẽcʉna aácoacʉmi. Cabero to cãnacã ñami canirique cʉti, to cãnacã rʉmʉ anicõa, to bairo cʉ cabaitoye cʉ caoterique puticoato. Dope bairo putiro ĩ majiquẽcʉmi. ");
INSERT INTO tav_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Puti, yoaro mee pũu butiro. Buti yaparo carupa cape jeeñaro. Carupa cape jeeñari bero carica butiro. Tie bʉcʉa, carupa rupaa jeeñaro yua. ");
INSERT INTO tav_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti rupaa cajũaro tʉjʉʉ tiere caotericʉ jeimi, to cõona bʉcʉa yaparo ĩi. Dio cʉ cãnie queti buiorique tie oteriquere bairona bai, caĩñupʉ Jesu, Diore caapiʉjarãre caricare jeericarore bairona na jee neogʉmi Dio caberopʉre ĩi, caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","To bairo ĩ yaparo ocõo bairo caĩ buionemoñupʉ Jesu: —Ʉpaʉ Dio cʉ cãnie quetire ¿dope bairo maca mani ĩ buio majiobocʉti? ");
INSERT INTO tav_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ocõo bairo ã: Jĩcaʉ camajocʉ mostasa apeacãre oteimi cʉ ya wejepʉ. Tie ape õqueacã majuu ã, oterique aperi nipetiri wame rʉgarijeacã. ");
INSERT INTO tav_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Õca aperiacã anibato quena bʉcʉatopʉ apeye oterica yucʉ netoro ʉmʉari yucʉ aápá. Paca majuu rʉpʉricʉti. To bairi minia atí, tii rʉpʉripʉ na batirire peoma. To bairona ã Ʉpaʉ Dio cʉ cãnie queti. Apeye netoro cãni majuuri wame ã. ");
INSERT INTO tav_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Capee wame queti buio majiorica wameri mena camajare na caĩ buioyupʉ Jesu. Na caapi majiro cõona na caĩ buioyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Camajare buei buio majiorica wame manona na caĩ buioquetinucuñupʉ Jesu. Cʉ buerã jetore, ocõo bairo ĩgaro ĩi, na ĩ majiato ĩi cariapena na caĩ buionucuñupʉ aperã na caapiquẽtopʉ. ");
INSERT INTO tav_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesu oterique mena camajare cʉ cabuio majiorica rʉmʉ canaiori paʉ cãno Jesu caĩñupʉ cʉ buerãre: —Jitá, ʉtabʉcʉra i nʉgoapʉ mani peña aáparo, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","To bairi Jesu camaja paarãacãre, “Aácʉ yʉ áa,” nare cʉ caĩ yaparoro cʉ cajʉgo peña aájuparã cʉ buerã cʉ cajañari cumua menana. Na capeña aáto tʉjʉrã, aperã quena na ye cumuari mena capeña aájuparã, Jesure ʉja peña aána. ");
INSERT INTO tav_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ti ra recomaca na catʉja peña aáto seeto majuu wino capapu ajupe. Wino seeto capapuro seeto majuu ti ra canacuañupe. Seeto majuu nacuabato cumuare pairo majuu caoco pa jãañupe. To bairi cumua ruacoato cabaibajupe yua. ");
INSERT INTO tav_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","To bairo to cabaibato quena Jesu maca cumua caʉjaro maca caabari ajero mena ẽoturi cacanicõa jañañupʉ. To bairi cumua caruagaro tʉjʉrã Jesure cʉ cayopioyuparã. —¡Jesu, jã Ʉpaʉ, yopiya! ¿Mʉ tʉjʉbapari? ¡Rua yajicoa aána mani bai! cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","To bairo cʉ na caĩro apii Jesu wamʉnʉca, winore, cajaberijere cajana rotiyupʉ. —¡To cõona janatoja! caĩñupʉ. To bairo cʉ caĩrona wino, cajaberije nipetiro cajana peticoajupe. ");
INSERT INTO tav_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—¿Nope ĩrã yʉ mena aábana quena yʉre catʉgooña nʉcʉbʉgoquẽnare bairona to cõo mʉja uwiri? caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na maca to bairo nemoo cajanaro tʉjʉrã catʉjʉ acʉacoajuparã: —¡Abʉma! Seeto majuu camajii ãcʉmi. Wino, cajaberije quena cʉ carotiro caroaro apicõa, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu winore cajaberijere cʉ janaoricaro bero cʉ buerã mena Galilea cawamecʉti ra ʉtabʉcʉra peña, Gadara cawame cʉtopʉ capeña ejayuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Topʉ peña ejari Jesu cumuapʉre cajañaricʉ camaa nʉcañupʉ. Cʉ camaa nʉcarona camajocʉ cʉ yeripʉ cawãti jaña ecooricʉ ʉ̃ta tʉa pʉto camaja cariaricarãre na cayaarica totiripʉ cajañanucuricʉ cabuti ajupʉ. Topʉ cãnacʉ buti atí, Jesure cabocayupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Ti operipʉ jeto cãninucuñupʉ. Come wẽri mena na cajia cũbato quena catʉ̃ga tacoa átinucuñupʉ. To bairi dope áti cajia cũ majiña mañupʉ. Capee niri come wẽri mena cʉ rʉpori, cʉ wamori cʉ cajia cũnucubajuparã. To cãnacã ni na cajia cũro catʉ̃ga jure renucuñupʉ. Jĩcaʉ macana cʉ cáti neto majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ʉmʉrecori, ñamiri quenare ʉ̃ta yucʉ buiripʉ, camaja na cayaaricaroripʉre caawaja mecʉ teñanucuñupʉ. Áti mecʉbacʉ ʉ̃ta rupaa mena cʉ majuuna cacamiyenucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","To bairi Jesure cʉ tʉjʉjo, cʉ tʉpʉ atí, cʉ tʉna caejacumuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Seeto awajarique mena ocõo bairo cʉ caĩñupʉ Jesure: —¡Jesu! Ʉmʉrecoo macacʉ Dio Macʉ ¿nope ĩi yʉre mʉ patowãcoʉ atíti? Dio cʉ catʉjʉrona mʉre yʉ jeni. Rooro yʉ catamʉoro yʉre átiqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesu wãti cʉ̃pʉre cajañaʉre cʉ cabuti rotirona to bairona caĩ awajayupʉ. To bairo cʉ caĩ awajaro apii ocõo bairo cʉ caĩñupʉ Jesu: —¡Wãti, ani camajocʉpʉre cajañaʉ, to cõona buti aácʉja! ");
INSERT INTO tav_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","To bairo ĩri bero Jesu cʉ caĩ jeniñañupʉ: —¿Ñamʉ mʉ wamecʉti? —Legión yʉ wamecʉ, caĩñupʉ. —Capãarã majuu wãtia jã ã ĩi, to bairo yʉ wamecʉti, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","—¡Aperopʉ cayoaropʉ jãre joo requeticõaña! Wãtia na caĩ jeni rotiro to bairona caĩ awajayupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","To bairo cabairi paʉ na jʉgoye maca buuropʉre capãarã nuricarã yejea caʉga tʉjʉnucuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nare tʉjʉrã wãtia ocõo bairo caĩñuparã Jesure: —I maja yejeapʉre jã jãa rotiya, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","To bairo na caĩ jeniñaro: —To bairona baiya. Yejeapʉrena jãaña, na caĩñupʉ Jesu. To bairi camajocʉpʉre cãnana buti aá, yejeapʉre cajãañuparã. Topʉre yejea pʉga mil cõo majuu cãñuparã. Yejeapʉre wãtia na cajãarona carupa tʉapʉ atʉ mecʉ ro aá, ti rapʉ care ñua peticoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","To bairo na cabairo tʉjʉrã yejeare cacotebatana seeto catʉjʉ acʉacoajuparã. Tʉjʉ acʉa, macapʉ caatʉ ruticoajuparã. Topʉ atʉ ruti ejari maca macanare, maca tʉjarori macana quenare na cabuio bateyuparã nipetiro cabairiquere na catʉjʉrique cõo. To bairo na caĩ buioro apirã camaja topʉre catʉjʉrã aájuparã, ¿dope bairo to baiyupari? ĩ majigarã. ");
INSERT INTO tav_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesu tʉpʉ ejarã cawãtia cʉgobatacʉre caroaro caruiire cʉ catʉjʉyuparã. Cajuti maninucubatacʉ juti jaña, caroaro catʉgooña maja catí, caruiyupʉ. To bairo cʉ cabairo catʉjʉ acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","To bairi Jesu camajocʉpʉre cãnanare wãtiare cʉ cabuu rero catʉjʉricarã nipetiro na catʉjʉriquere na cabuioyuparã catʉjʉra ejarãre. To bairi yejea na cabairique quenare na caĩ buioyuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","To bairo na caĩ buiorijere apirã Jesure: —¡Aperopʉ aácʉja! ¡Jã ya paʉpʉ aniqueticõaña! seeto cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","To bairo na caĩro apii Jesu cumuapʉre caeja jãañupʉ, tunu aágʉ. Cʉ caeja jãaro tʉjʉʉ cawãtia cʉtibatacʉ ocõo bairo caĩñupʉ Jesure: —Yʉ quena mʉ mena yʉ aágʉ, seeto cajenibajupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesu, “Jaʉ, jitá,” cʉ ĩquẽcʉna ocõo bairo maca cʉ caĩñupʉ: —Mʉ yarã tʉpʉ maca tunu aácʉja. Caroaro Dio mʉre bopaca tʉjʉri mʉre cʉ cátiejere mʉ yarãre na buio peocõaña, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","To bairo Jesu cʉ caĩro cáaácoajupʉ. Aá, ti yepa Decápoli cawamecʉti macari macana nipetirore cabuio jʉgoyupʉ Jesu cʉ̃re cʉ canetooriquere yua. Nipetirã to bairo cʉ caĩ buioro apirã caapi acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cabero ʉtabʉcʉra ape nʉgoapʉ capeña aájupʉ Jesu tunu. Peña ejari bero ʉtabʉcʉra tʉjaro cʉ catʉjʉnucuro capãarã caneñapoyuparã cʉ tʉpʉre. ");
INSERT INTO tav_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","To bairo na cabairo jĩcaʉ Jairo cawamecʉcʉ neñapo buerica wii ʉpaʉ caejayupʉ. Eja, Jesure cʉ tʉjʉʉ rʉpopatua mena tuatu ejacumuri ocõo bairo seeto cʉ bopacoo tʉjʉ rotiri cʉ caĩ jeniñupʉ: ");
INSERT INTO tav_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Yʉ macoacã bai yaji aáco baimo. Cõre ñiga peoñaʉ ajá. Cõre mʉ cañiga peoro catigomo, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","To bairo cʉ caĩro apii Jairo mena cáaácoajupʉ Jesu. Cʉ cáaáto camaja capãarã majuu cʉ̃re caʉja aájuparã. Capãarã majuu aáti seeto majuu caʉtabija nutuajuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na paarãacã watoapʉ jĩcao ámo janaquetajere cariayecʉco Jesu jõcʉ bero caejayupo. Doce cʉmari majuu tiere cariayecʉco cãñupo. ");
INSERT INTO tav_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cõre capãarã ʉcoyeri maja cõre na caʉcoyebato quena to bairona capopiye tamʉonucucõañupo. Co niyeru co cacʉgobataje quenare cõre na caʉcoyero wapayebaco cawapaye peocõañupo. To bairo co cátibato quena co cariaye cʉtie canetoqueti majuucõañupe. Seetobʉjare rooro majuu caria nutuajupo. ");
INSERT INTO tav_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","To bairi Jesu camajare cʉ cariaye netoonucurijere caqueti apiyupo. Tiere queti apiri camaja watoapʉ Jesu bero atí, cʉ jutirore capañañupo, cʉ jutiro jetore pañari yʉ catigo, ĩ tʉgooñao. ");
INSERT INTO tav_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cʉ jutirore co capañarona co cariaye cʉtibataje cajanacoajupe. To bairi, “Mere yʉre janacoapa yʉ cariaye cʉtie,” caĩ tʉgooña majiñupo. ");
INSERT INTO tav_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","To bairi nemoona Jesu, “Yʉ camajirije mena jĩcao co cariaye cʉtiere yʉ netoowʉ,” caĩ tʉgooña majiñupʉ. To bairo ĩ tʉgooña majiri camajare amojore tʉjʉʉ na cajeniñañupʉ: —¿Noa yʉ jutirore na pañari? na caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","To bairo cʉ caĩro apirã cʉ buerã ocõo bairo caĩ yʉyuparã: —Camaja capãarã majuu ʉtabijaro mʉre na caroca tuabato quena: “¿Noa yʉre na pañari?” ¿mʉ ĩ jeniñati? ");
INSERT INTO tav_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","To bairo na caĩbato quena, noa yʉ jutirore na pañañupari ĩi, nipetirore catʉjʉ macañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","To bairo cʉ catʉjʉ macarona seeto nanaa uwio cʉ tʉpʉ caejacumucoajupo. “Mere yʉ cariaye cʉtiere yʉ netoocõawĩ,” ĩ majiri cariape, “Yʉna mʉre yʉ pañawʉ,” Jesure cʉ caĩ cabuioyupo. ");
INSERT INTO tav_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","To bairo co caĩro: —Yʉ yao, caroaro yʉre mʉ catʉgooña nʉcʉbʉgoro mʉ cariaye cʉtiere yʉ netoowʉ. Caroaro cariaye máco wariñuurique mena anicõaña yua, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu cõre to bairo cʉ caĩri paʉna Jairo ya wii macana na tʉpʉre caejayuparã Jesu cʉ cãnopʉre. Eja, cawimao pacʉ Jairore ocõo bairo cʉ caĩñuparã: —Mʉ macoacã bai yajicoamo mere, cʉ caĩñuparã. —To bairi mani Ʉpaʉ manire cabueire to cõona cʉ patowãcoonemoqueticõaña, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesu maca to bairo na caĩrijere apii neñapo buerica wii ʉpaʉre ocõo bairo caĩñupʉ: —Acʉaqueticõaña. Acʉaquẽcʉna yʉ macare tʉgooña nʉcʉbʉgoya, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","To bairo Jairore cʉ ĩ, Pedrore, Jacobore, Jacobo bai Juan na jetore na capi aájupʉ Jairo ya wiipʉ aácʉ. Aperã macare caʉja aá rotiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","To bairi neñapo buerica wii ʉpaʉ Jairo ya wiipʉ caejayuparã. Topʉ ejaʉ camaja capãarã seeto caoti awajarãre catʉjʉyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ti wiipʉ jãa ácʉ na caĩñupʉ: —¿Nope ĩrã to cõo mʉja awaja otiti? Cawimao cayajirico me ãmo. Canio áamo, caĩwĩ Jesu. Mere cabai yajirico co cãnibato quena na caĩñupʉ, tunu catigomo cani yopiricarore bairona ĩi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","To bairo cʉ caĩro apirã cʉ caĩ epeyuparã, mere bai yajicoamo ĩrã. To bairo cʉ na caapi nʉcʉbʉgoquẽtie to cãnibato quena Jesu aperãre na buti rotiri cawimao pacʉre, co pacore, cʉ buerã itiarãre co capejari arʉapʉ na capi jãajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti arʉapʉ jãa ejari co wamopʉ ñeri, cʉ ye arameo mena cabai yajiricore caĩñupʉ: —Talita, cumi. To bairo ĩi, “Cawimao, wamʉnʉcaña,” ĩi caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","To bairo cʉ caĩrona cawimao doce cʉmari cacʉgoo wamʉnʉca, cáaá maji jʉgoyupo. Cabai yajirico anibaco quena co catunu catiro camaja topʉ cãna catʉjʉ acʉa netocoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu, —To bairo yʉ cátiere aperãre na buioqueticõaña, caĩñupʉ. Ĩ yaparo —Cawimaore ʉgarique co nuña yua, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu Capernaupʉ cãnacʉ cʉ ya macapʉ catunu aájupʉ. Cʉ buerã quena cʉ mena cáaájuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","To bairi judío maja na cayerijãri rʉmʉ cãno Jesu na caneñapo bueri wiipʉ Dio ye quetire na cabuio jʉgoyupʉ. Camaja capãarã cʉ cabuiorijere apirã caapi acʉacoajuparã. Api acʉari ocõo bairo caame ĩñuparã: —¿Noopʉ atie cʉ cabuio majirijere cʉ camajiñupari? ¿Dope bairo majuu to bairije cáti majiña maniere cʉ cáti majiñupari? ");
INSERT INTO tav_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Atona cãninucuecʉna ãmi. Yucʉ pãirire capaanucuecʉ, María macʉna ãmi. Jacobo, José, Juda, Simón na jʉgocʉna ãmi. Cʉ bairã romiri quena mani tʉna aninucuma, caame ĩñuparã. To bairo ĩ tʉgooñarã cʉ caapi nʉcʉbʉgogaquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","To bairo cʉ̃re na canʉcʉbʉgogaquẽto tʉjʉʉ ocõo bairo na caĩñupʉ Jesu: —Jĩcaʉ Dio ye quetire buiori majocʉ ũcʉ aperopʉ cʉ cabuio teñaro to macana cʉ api nʉcʉbʉgorãma. Cʉ ya maca macana maca, cʉ yarã majuu, cʉ ya wii macana jeto cʉ nʉcʉbʉgoquẽnama, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","To bairi topʉ cʉ cabʉcʉarica macapʉ capee cáti majiña mani wame cáti iñooquẽjupʉ, cʉ̃re na caapi nʉcʉbʉgoquẽto tʉgooñarique paibacʉ. Jĩcaarãacã jetore cariarãre na ñiga peori na canetoo catioyupʉ baii pʉa. Cabero to tʉacã cãni macaripʉ cʉ ye quetire cabuio teñanucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cabero Jesu cʉ buerã doce cãnacãʉre cʉ tʉpʉ neori pʉgarãri jeto cʉ ye quetire na cabuio teña roti jʉgoyupʉ. To bairi camaja na yeripʉ cawãtia jañarãre na cabuu reboja majipe quenare na cajooyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Apeye unie na cacʉgorijere na cajee aá rotiquẽjupʉ. Wajopoa uno, ʉgarique, niyeru quenare na cajee aá rotiquẽjupʉ. Tuericʉ jetore na cane aá rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Rʉpo jutii na cacʉtarije jeto, na jutii na cajañarije jeto menare na cajooyupʉ. Na cawajoa jañape macare na cajee aá rotiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ocõo bairo na caĩñupʉ: —Caroaro mʉjaare cãni rotii ũcʉ ya wiipʉ jãa ejarã ti wiipʉna anicõaña ti macapʉ mʉja cãni rʉmʉri cõo. ");
INSERT INTO tav_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Noo mʉjaare aperã na cabooquẽto, Dio ye quetire mʉja cabuioro na caapigaquẽto topʉ mʉja buti weogarã. Buti aána mʉja rʉporipʉre jita catujarijere pa bate reya. To bairo ána, mʉjaare jã cabuioro mʉja caapigaquẽtore bairona mʉja booquẽemi Dio, na ĩ iñoorã mʉja átigarã. Cariapena mʉjaare yʉ ĩ. Dio camajare cʉ cabejepa rʉmʉ cãno ti maca macanare mʉjaare cabooquetanare seeto na popiyeyegʉmi. Sodoma, Gomora macana tirʉmʉpʉ macanare cʉ capopiyeyericaro netoro na popiyeyegʉmi Dio, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","To bairo cʉ caĩro bero cáaácoajuparã yua. Aá, camajare, “Caroorijere mʉja cátinucurijere tʉgooña jʉtiriti wajoaya,” caĩ buio teñanucuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","To bairi capãarã camajare na yeripʉ cawãtia jañarã quenare care buubojayuparã, Dio cʉ catutuarije mena. Capãarã cariayecʉna quenare ʉje mena wareri na canetoo cationucuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","To bairi camaja nipetirã Jesu cariarãre canetoo catiorijere caqueti apiyuparã. To bairi Ʉpaʉ Herode quena caqueti apiyupʉ. Tiere queti apiri ocõo bairo caĩñupʉ: —Juan camajare bautisari majocʉ na carʉpoa pa ta rocaricʉpʉ anibacʉ quena tunu catiricʉmi. Catunu catiricʉ aniri capee majuu áti iñoo netonucuʉmi, caĩñuparã jĩcaarã. ");
INSERT INTO tav_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aperã maca ocõo bairo caĩñuparã: —Aniquẽcʉmi. Tirʉmʉpʉ macacʉpʉ Dio ye queti buiori majocʉ Elías cãniñaricʉ tunu catiricʉmi, caĩñuparã. Aperã maca: —Cʉ quena tirʉmʉpʉ macana Dio ye quetire buiori majare bairona cabaii ãcʉmi, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","To bairo na caĩro apii Herode maca ocõo bairo caĩñupʉ: —Tirʉmʉpʉ yʉ carʉpoa pa ta roca rotiricʉna ãcʉmi. Juan bautisari majocʉna tunu catiricʉmi, caĩnucucõañupʉ Herode. ");
INSERT INTO tav_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herode to jʉgoyepʉ Herodía cawamecʉco jʉgori Juãre presopʉ cʉ cañe aá rotiyupʉ. Co Herodía cʉ bai Felipe cawamecʉcʉ nʉmo cãñupo. To bairo co cãnibato quena Herode maca co caneñupʉ. To bairo cʉ cáto tʉjʉri Juan bautisari majocʉ Herodere ocõo bairo cʉ caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","—Mʉ bai nʉmore nʉmo cʉtiqueticõaña. To bairi mʉ cátie ñuuquẽe, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","To bairo cʉ caĩnucurije wapa Herodía Juãre seeto tʉjʉ punijiniri Herodere, “Mʉ polisíare cʉ jĩa rotiya Juãre,” caĩbajupo. To bairo ĩbaco quena dope bairo cáti majiquẽjupo. ");
INSERT INTO tav_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode maca Juãre, “Cañuʉ ãmi, caroorije mácʉ ãmi,” caĩ tʉgooña nʉcʉbʉgoyupʉ. To bairo ĩ tʉgooña nʉcʉbʉgori Juãre rooro na cáti rotiquẽjupʉ. Juan cʉ cabuiorijere api acʉari, “¿Dope bairo ĩgʉ cʉ ĩti?” caĩ tʉgooñañupʉ. To bairo ĩ tʉgooñabacʉ quena caroaro cʉ caapiganucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Cabero Herode cʉ cabuiarica rʉmʉ cãno boje rʉmʉ caquenooñupʉ. Boje rʉmʉ quenoo, cʉ mena macana cʉ ẽoro carotirã, cʉ yarã polisía maja ʉparãre, aperã Galilea yepa macana cãni majuurã quenare na capi neoñupʉ, yʉ boje rʉmʉ tʉjʉrã ajá ĩi. To bairo cabairi paʉ Herodía Juãre co cajĩa rotipere catʉgooña bʉgayupo. ");
INSERT INTO tav_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","To bairi Herode cʉ capi neoricarã nipetirore na cajʉgo ʉgayupʉ. Na caʉgari paʉ Herodía maco jãa ejari na cabaja iñooñupo. Co cabaja iñoorijere Herode jãa aperã cʉ mena caruirã seeto majuu catʉjʉ wariñuuñuparã. Tiere tʉjʉ wariñuuri Herode ocõo bairo co caĩñupʉ Herodía macore: —Noo mʉ caboorije, yʉre mʉ cajenigari wamere mʉ yʉ joogʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","To bairi cʉ capiricarã na caapiropʉ: —Ĩtoricaro mano ĩi mʉ yʉ ĩ, to bairi yʉ carotiri yepa quenare mʉ cajeniata carecomaca mena mʉ yʉ joo maji, co caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","To bairo cʉ caĩro apio, co paco tʉpʉ aá, cõre cajeniñañupo: —¿Ñee unie macare cʉ̃re yʉ jenioati? caĩñupo. To bairo co caĩro apio ocõo bairo co caĩñupo co paco maca: —Juan bautisari majocʉ rʉpoare pa ta neri na ne aparo, cʉ ĩ jeniya, caĩñupo. ");
INSERT INTO tav_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To bairo co caĩro nemoona Herode tʉpʉ jãa ejari ocõo bairo cʉ caĩñupo: —Yucʉacã yoaro mee Juan bautisari majocʉ rʉpoare pa tari jotʉ bapa mena ne jãri yʉre na joato, caĩñupo. ");
INSERT INTO tav_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","To bairo co caĩro apii Ʉpaʉ Herode seeto majuu catʉgooña jʉtiritiyupʉ. Nipetirã topʉ caneñaporã na caapiro, “Mʉ caboori wame yʉ mʉ cajeniata mʉ yʉ joogʉ,” caĩricʉ aniri dope bairo caĩto majiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","To bairi, “Yʉ jooquẽe,” caĩ majiquẽjupʉ. To bairi nemoona Ʉpaʉ Herode cʉ polisíare Juan rʉpoare capa ta neatí rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","To bairi polisía preso wiipʉ aá, Juan rʉpoare pa ta, jotʉ bapapʉ ne jã atíri Herodía macore co cajooyupʉ. Cõre cʉ cajooro co maca co pacore cajoo netoñupo yua. ");
INSERT INTO tav_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juãre to bairo na cáti rocariquere queti apiri cʉ cabuiorijere caapiʉjanucuricarã atí, cʉ rupaʉ ãnatore ne aá, cʉ cayaa rocayuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cabero Jesu cʉ cabuio teña rotiricarã tunu ejarã nipetiro na cátajere, na cabuio teñarique quenare cʉ cabuioyuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na cabuio yaparoro Jesu nare: —Jitá, petoacã mani yerijãgarã camaja na camanopʉ, caĩñupʉ. Camaja capãarã na tʉpʉre nairo majuu na caejaro dope bairo cáti ʉga majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","To bairi Jesu cʉ buerã mena na jeto cumua mena eja jãa, camaja manopʉ cáaácoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Camaja capãarã topʉ na cáaáto catʉjʉyuparã. To bairi Jesure tʉjʉ majiri cʉ cáaátopʉ macaa macana cãno cõo mapʉ nipetiro caatʉ jʉgocoajuparã, na capeña ejaparopʉre aána. ");
INSERT INTO tav_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","To bairi Jesu topʉ roca tu, ma eja, na paarãacãre catʉjʉyupʉ. Na tʉjʉri na cabopaca tʉjʉyupʉ, oveja nuricarã nare cacotei manare bairona cãna na cãno maca. To bairi capee wameri na caĩ buio jʉgoyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","To bairi ñamicaa cãno cʉ buerã cʉ tʉpʉ aáti ocõo bairo cʉ caĩñuparã: —Naio aáto bai. Atopʉre maca maa. ");
INSERT INTO tav_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","To bairi camajare to cõona na tunu aá rotiya. Topʉ tunu aáti macaripʉ na wapaye ʉgara aáparo. ");
INSERT INTO tav_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","To bairo na caĩro apii Jesu na caĩñupʉ cʉ buerãre: —Mʉjaana ʉgarique na nuña. To bairo cʉ caĩro na maca cʉ caĩñuparã: —¿Pairo, dosciento rʉmʉri wapataricaro cõo mena pan rupaarire jã wapayera aánaati, nare nugarã? caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","To bairo na caĩro: —Tʉjʉñaja. ¿Mʉjaa noo cãnacã pan rupaari mʉja cʉgoti? caĩ jeniñañupʉ Jesu. To bairo cʉ caĩro tʉjʉri bero cʉ cabuioyuparã: —Jĩca wamo cãnacã rupaa ã. To bairi wai quena pʉgarã ãma, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","To bairo na caĩro apii camaja na cãno cõo ricati poari jeto caroa ta yepa cãnopʉ na carui rotiyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","To bairi jĩca poarire cien majuu camaja caruiyuparã. Ape poarire cincuenta majuu camaja caruiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","To bairi Jesu pan rupaarire, na wai pʉgarãre neri jõ bui maca tʉjʉ mʉgori Dio cʉ Pacʉre caĩ wariñuu nʉcʉbʉgoyupʉ. To bairo ĩ yaparo pan rupaarire pe mʉto, cʉ buerã na cajooyupʉ, camajare na bate rotii. Wai quenare to bairona pe mʉto, na cabate rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","To bairo cʉ cátiere camaja nipetiro caʉga yapicoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na caʉga yapi rʉgarije doce piiri jiraro majuu cajee neoñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tiere caʉgaricarã cinco mil majuu cãñuparã caʉmʉa jeto ãnaa. Cãromia, cawimarã cacõoñaquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesu camajare ʉgarique na nuri bero cʉ buerãre: —Cumuare peña jʉgoya. Ĩ nʉgoa Betsaidapʉ mʉja ani yuuwa camajare yʉ cáaátaje uitoye, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","To bairo cʉ buerãre ĩi, camaja paarãacãre na aátaje ui yaparo ʉ̃taʉpʉ cawamʉ aájupʉ, Diore cʉ ĩ jeni nʉcʉbʉgoʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Canaiori paʉ bero Jesu buerã cumua mena ʉtabʉcʉra recomacapʉ capajayuparã. Jesu maca jõ boepʉ jĩcaʉna cãnicõañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Seeto wino capapuro popiye catamʉoñuparã, apero maca capapu jooro cariape maca we aágarã. To bairi Jesu cumuare na cawe eja atí majiquẽto catʉjʉyupʉ. To bairi cabujuparo jʉgoye na tʉpʉ aácʉ oco buina cáaácoajupʉ. Nare neto aácʉ cabaibajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","To bairo oco bui cʉ cáatí nutuato tʉjʉrã, cabai yajiricʉ wãti ãcʉmi ĩrã catʉjʉ acʉa awajayuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Na nipetiro cʉ catʉjʉ acʉa awajayuparã. To bairo na caĩ awajaro apii Jesu nemoona ocõo bairo na caĩñupʉ: —Uwiqueticõaña. Yʉna yʉ ã, mʉja ʉpaʉna. Tʉgooña uwi acʉaqueticõaña, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","To bairo na ĩri bero na mena cumuapʉre caeja jãañupʉ. Cʉ caeja jãari paʉna wino capapu janacoajupe. Wino capapu janaro tʉjʉrã seeto catʉjʉ acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Cajʉgoye pan rupaarire Jesu cʉ cáti bʉoriquere catʉjʉricarã anibana quena cʉ cáti maji netorijere catʉgooña majiquẽjuparã. Na yeri mena catʉgooña puoquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","To bairo bairi bero peña, Genesaret cawamecʉtopʉ capeña ejayuparã. Topʉ ejarã na cumuare jia tu poo, camaa nʉcañuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Topʉ na camaa nʉcari paʉ to macana nemoona Jesure catʉjʉ majiñuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","To bairi nipetiropʉ atʉ aá, ti yepa macana cariaye cʉnare na cajee atí rotiyuparã. To bairo na caĩro apirã cariaye cʉnare na cacuñarije mena, “Topʉ ãmi Jesu,” camaja na caĩropʉ na cajee ejayuparã. ");
INSERT INTO tav_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","To bairi Jesu noo cʉ cãnopʉ macaripʉ, macari tʉjaropʉ cariaye cʉnare jee atí, macari recomacapʉ na cũri, Jesure ocõo bairo cʉ caĩ jeninucuñuparã: —Mʉ jutiro yapa jetore jã pañagarã. To bairo átiri jã netogarã, cʉ caĩñuparã. To bairi cʉ jutiro yapare capañaricarã caneto petiyuparã na cariaye cʉtiere yua. ");
INSERT INTO tav_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Cabero fariseo maja aperã judío majare cabuerã jĩcaarã Jerusalẽpʉ cãnana Jesu tʉpʉ cáajuparã. ");
INSERT INTO tav_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesu buerãre jĩcaarã wamo cojequẽnana na caʉgaro catʉjʉyuparã fariseo maja. “Ʉgagarã jʉgoye manire bairo wamo cojequẽema Jesu buerã. To bairi caroorã ãnama,” na caĩ tʉjʉyuparã fariseo maja Jesu buerãre. ");
INSERT INTO tav_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseo maja, judío maja nipetirã quena na ñicʉ jãa na cáti jʉgo atájere bairona cáti ʉjayuparã. To bairi caroaro na wamorire cojeri bero jeto caʉganucuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na caʉgarique nuniri paʉpʉ cawapayera aátana tunu ejarã quena to bairona na wamorire cacojenucuñuparã. Na ñicʉa na cátinucurique cõo cátinucuñuparã. To bairona etirica baparire na capio jãnucuri rʉri quenare, na come rʉri quenare cacojenucuñuparã. To bairo mani cátiquẽpata Dio, “Caroorã ãma,” mani ĩ tʉjʉboʉmi ĩrã, to bairo cátinucuñuparã ti wamere yua. ");
INSERT INTO tav_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","To bairi Jesu buerã na cawamo cojequẽto tʉjʉrã Jesure cʉ caĩ jeniñañuparã fariseo maja, judío majare cabuerã: —¿Nope ĩrã mani ñicʉa na cátinucuriquere na átiquẽeti? Na wamorire cojequẽnana ʉgarã rooro ána áama, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","To bairo na caĩro ocõo bairo na caĩñupʉ Jesu: —Cariapena caĩ ucayupi Isaía tirʉmʉpʉ macacʉ Dio ye quetire buiori majocʉ mʉja cabaipere. Ocõo bairo caĩ ucayupi: Ati maja, “Diore camairã jã ã,” ĩbana quena na yeripʉ yʉ tʉgooña nʉcʉbʉgoquẽema. ");
INSERT INTO tav_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","To bairi jocarãna, “Diore cáti nʉcʉbʉgorã jã ã,” ĩnucuma. Na majuuna na catʉgooñari wamere, “Atie Dio cʉ carotirique ã,” ĩbana na ya wame macare áti nʉcʉbʉgonucuma, caĩ ucayupi Isaía. ");
INSERT INTO tav_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dio cʉ caroti majuurijere mʉja átiquetinucu, camaja na cátinucurije macare cáti ʉjarã aniri. To bairi etirica bapare cojerique, ape rʉri cojerique jetore mʉja tʉgooñanucu. Capee wame mʉja ñicʉ jãa na cáti jʉgo atájere mʉja tʉgooñanucu, Dio cʉ caroti majuurijere tʉgooñaquẽnana. ");
INSERT INTO tav_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Tie macare mʉja recõanucu, mʉja ñicʉ jãa na cáti jʉgo atáje jetore átigarã, na caĩnemoñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","—Ocõo bairo caĩ ucayupi Moisé: “Mʉja pacʉare na nʉcʉbʉgoya. Rooro na pacʉare caĩrã unare na cajĩa repe ã.” ");
INSERT INTO tav_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mʉja maca ti wamere mʉja bai netoonucu, ocõo bairo mʉja pacʉare na ĩri: “Atie niyerure mʉjaare yʉ joo majiquẽe,” mʉja pacʉare jocarãna na mʉja ĩ. “Dio ye cãnipe ã, cʉ̃re yʉ cajoope. To bairi mʉjaare yʉ átinemo majiquẽe,” mʉja pacʉare jocarãna na mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Mʉja majuuna mʉja ye niyerure maibana to bairo na mʉja ĩtonucu. To bairi nare átinemogaquetiri nare canʉcʉbʉgoquẽna mʉja ã. To bairo ĩ tʉgooñabana Dio cʉ carotirica wamere mʉja bai netoonucu. “Mʉja pacʉare na nʉcʉbʉgoya,” Dio cʉ carotirica wamere mʉja bai netoonucu, na átinemoquẽnana. To bairije mʉja ñicʉ jãa na cáti jʉgo atáje capee wame mʉja átinucu. ");
INSERT INTO tav_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","To bairo na ĩ yaparo camajare na pijo, ocõo bairo na caĩ buioyupʉ Jesu: —Caroaro yʉ apiya, yʉ cabuiorijere majigarã. ");
INSERT INTO tav_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Camaja na majuuna roorije na yeripʉ na catʉgooñarije jʉgori caroorã ãma. Na caʉgarije jʉgori mee caroorã ãma. ");
INSERT INTO tav_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Noa yʉre caapirã yʉ caĩ buiorijere caroaro apiʉjaya. ");
INSERT INTO tav_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ĩ yaparo camaja capãarã watoapʉ cãnacʉ na cáaáweoyupʉ Jesu. Aá, cʉ buerã mena wiipʉ cajãacoajupʉ. Wiipʉ cʉ cajãaro bero, cʉ buerã ti wame cõorique mena cʉ cabuioriquere cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","To bairo cʉ̃re na caĩ jeniñaro: —¿Mʉja quena tiere mʉja api puoquẽeti? na caĩñupʉ. —Camaja na ʉgarique unie jʉgori rooye tuaquetinucuma. ");
INSERT INTO tav_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Na caʉgarije na yeripʉ jañaquẽe. Na caʉgari wame cõo paropʉ eja, to cõona yajicoapa. To bairo ĩ, nipetiro ʉgarique caroa jeto ã ĩi, to bairo caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Apeye na caĩnemoñupʉ Jesu tunu: —Camaja na majuuna caroorije na cátie na rooye tuu. ");
INSERT INTO tav_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Camaja na yeripʉ caroorije na catʉgooñari wame cõo caroorije átinucuma. Ato cãnacã wame majuu na cátinucurije ã: Áti epericarã cʉtaje, jee rutirique, aperãre jĩarique, apeĩ nʉmore eperico cʉtaje, aperã na cacʉgorijere tʉjʉ ʉgoorique, aperãre rooro átaje, ĩtorique, aperãre wada pairique, mani majuuna, “Aperã netoro cãcʉ yʉ ã,” ĩ tʉgooñarique, caroaro tʉgooñaquẽnana átaje. ");
INSERT INTO tav_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Atie nipetiri wame camaja caroorije na majuuna na yeripʉ na catʉgooñarije jʉgori rooye tuama. ");
INSERT INTO tav_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu Genesarépʉ cãnacʉ Tiro, Sidón cawamecʉti macaripʉ cáaájupʉ. Topʉ eja, topʉ cʉ caejarijere na camajiro cabooquẽjupʉ, aperã capãarã yʉ tʉpʉ neñarema ĩi. To bairi jĩca wiipʉ cajãacoajupʉ. To bairo baibacʉ quena dope bairo baii cayaji majiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nemoona Jesu cʉ caejarijere caapiyupo jĩcao cawãti jãa ecoorico paco. Apero macaco, Sirofenicia macaco cãñupo. Jesu cʉ caejarijere queti apio, Jesu tʉ ejao, rʉpopatuaripʉ caejacumuñupo. Ejacumuri wãti co macoacãpʉ cãcʉre cabuu roca rotiyupo. ");
INSERT INTO tav_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesu maca co caĩñupʉ: —Aperã Israel maja cãniquẽnare yʉ cátinemoro cawimarã ye ʉgariquere na emari yaiare nare nuʉre bairo yʉ átiboʉ. Cawimarãre canu jʉgope ã, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","To bairo cʉ caĩro: —Ʉpaʉ, cariape mʉ ĩ. To bairo yaiare cawimarã ye ʉgariquere cajooquetipe to cãnibato quena na caʉga ruiri cajawa ẽoropʉ caña rerijere ʉganucuma yaia. To bairona caĩñupo Jesure, yʉ quena apeo yʉ cãnibato quena Israel majare na átinemo yaparoʉ petoacã yʉ quenare yʉ átinemoña ĩo, caĩñupo Jesure. ");
INSERT INTO tav_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","To bairo co caĩro ocõo bairo co caĩñupʉ Jesu: —Caroaro yʉre mʉ caĩ tʉgooña nʉcʉbʉgori wamere apii wãti mʉ macopʉre cãcʉre mere yʉ buu rocatʉga. Mere yʉre caĩ nʉcʉbʉgoo aniri tunu aácoja, co caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","To bairo Jesu cʉ caĩro co ya wiipʉ catunucoajupo. Tunu eja, co macore co cuñaricaropʉ capejaore co catʉjʉyupo, mere wãti cõpʉre cãnibatacʉ cʉ cabutiricopʉre yua. ");
INSERT INTO tav_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu Tiro cawamecʉtopʉ cãnacʉ cabuti aájupʉ. Buti aácʉ Sidón cawamecʉtopʉ to bairi Decápoli cãni macaripʉ caneto aájupʉ. To neto aá, Galilea ʉtabʉcʉra tʉ caejayupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Topʉ jĩcaʉ caapi majiquẽcʉ, caroaro cawada majiquẽcʉre Jesu tʉpʉ cʉ caneajuparã, mʉ wamo mena cʉ ñiga peori cʉ netooña ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","To bairi Jesu aperobʉjaacã camaja na catʉjʉquẽtopʉ cʉ cane aájupʉ. Topʉ cʉ ne aá, cʉ wamo jũari mena cʉ amoo operipʉre ñu nʉcori bero cʉ wamo jũare ʉcoo wareri cʉ ñemerore capañañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","To bairo cʉ ñemerore paña, ʉmʉrecoopʉ tʉjʉ mʉgori cayeri jinijãñupʉ. Yaparo: —¡Efata! cʉ ye mena caĩñupʉ. Cʉ amoo tujuya ĩi, to bairo caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","To bairo Jesu cʉ caĩrona caapi majii, caroaro cawada majii cãñupʉ mere yua. ");
INSERT INTO tav_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","To bairi topʉ cãnare, “Aperãre na buio batequeticõaña,” na caĩñupʉ Jesu. Seeto buioquẽja cʉ caĩbato quena seetobʉja capãarãre na cabuio bateyuparã. ");
INSERT INTO tav_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Seeto majuu tʉjʉ acʉari ocõo bairo caĩñuparã: —Nipetiri wamere caroaro átinucumi Jesu. Caapi majiquẽna quenare na caapi majiro áami. Cawada majiquẽna quenare na cawada majiro áami, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jesu camajare cʉ canetooro bero camaja capãarã cʉ tʉpʉ caneñapoyuparã tunu. Topʉ ãnaa na caʉgapere cacʉgoquẽjuparã. To bairo na cabairo tʉjʉʉ Jesu cʉ buerãre pijori na caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ati maja paarãacãre yʉ bopaca tʉjʉcʉpʉ. Mani mena na cãno itia rʉmʉ neto. To bairi na ʉgarique peticoapa. ");
INSERT INTO tav_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cañigo riarãrena na ye wiiripʉ na yʉ catunuo jooata ma recomacana riañaborãma. Aperã cayoaropʉ cáatána ãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","To bairo cʉ caĩro ocõo bairo cʉ caĩñuparã cʉ buerã Jesure: —Mani atopʉ camaja manopʉre dope bairo átiri ati maja capãarãre na mani ʉgarique nu majiquẽe. ");
INSERT INTO tav_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","To bairo na caĩro Jesu na cajeniñañupʉ: —¿Noo cãnacã majuu pan rupaa mʉja cʉgoti? To bairo na cʉ caĩ jeniñaro: —Siete rupaari majuu jã cʉgo, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","To bairo na caĩro apiri camajare na carui rotiyupʉ Jesu yepapʉre. Na rui roti yaparo pan rupaarire jee, Diore caĩ nʉcʉbʉgoyupʉ. Ĩ yaparo ti rupaare pe mʉto, cʉ buerãre na cajooyupʉ, camajare na bate jooya ĩi. ");
INSERT INTO tav_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","To bairi wai quenare petoacã cacʉgoyuparã. Na quenare joori jʉgoye Diore caĩ nʉcʉbʉgoyupʉ Jesu. Ĩ yaparo na quenare cabate rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","To bairo cʉ cátiere caroaro caʉga yapi peticoajuparã. Na caʉga yapi rʉgarijere siete piiri majuu cajee neoñuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Tiere caʉgaricarã cuatro mil majuu cãñuparã camaja nipetiro ãnaa. To cõona nare aátaje uiri bero, cumuapʉ eja jãa, cáaácoajupʉ cʉ buerã mena Dalmanuta cawame cʉtopʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesu cʉ buerã mena Dalmanutapʉ caejayuparã yua. Topʉ na caejaro fariseo maja Jesu mena seeto capee cawadayuparã. ¿Dio cʉ cajooricʉna cʉ ãti? ĩrã ʉmʉrecoo cabairije uniere cʉ cáti iñoo rotibajuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","To bairo na caĩro Jesu yeri jinijãri ocõo bairo caĩñupʉ: —¿Nope ĩrã ati yʉtea macana ʉmʉrecoo macajere áti iñooriquere na tʉjʉgati? Cariapena mʉjaare yʉ ĩgʉ. Ʉmʉrecoo macajere mʉjaare yʉ áti iñooqueti majuucõagʉ, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","To bairo na ĩ yaparo cumuapʉ eja jãa, ape nʉgoapʉ capeñacoajupʉ cʉ buerã mena tunu. ");
INSERT INTO tav_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ape nʉgoapʉ peña aána Jesu buerã na caʉgapere cajeequẽjuparã. Pan jĩcana cane aájuparã bairã pʉa. ");
INSERT INTO tav_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","To bairi ocõo bairo na caĩñupʉ Jesu: —Caroaro tʉgooña majiña. Fariseo maja, to bairi Ʉpaʉ Herode na ya wame pan to wauato ĩrã levadura na caĩrije tiepʉ na caajurijere caroaro tʉjʉ majiri tiere átiquẽja, na caĩbajupʉ cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To bairo cʉ caĩrijere api majiquetibana: —Pan mani caʉgape mani cajee atíquẽto ĩi to bairona mani ĩimi, caame ĩñuparã cʉ buerã. ");
INSERT INTO tav_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","To bairo na caame ĩrijere majiri ocõo bairo na caĩñupʉ Jesu: —¿Nope ĩrã, “Pan mani caʉgapere mani cajee atíquẽto ĩi to bairona mani ĩimi,” yʉre mʉja ame ĩti? ¿Mʉjaare yʉ cátinemoro mʉja majiriticoati? Caroaro yʉ cátajere tʉjʉbana quena, yʉ cabuiorijere apibana quena mʉja tʉgooña majiquẽe. Mʉja majuuna mʉja yeripʉ mʉja tʉgooña majigaquẽna. ");
INSERT INTO tav_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","To jʉgoye jĩca wamo cãnacã pan rupaari mena jĩca wamo cãnacã mil cãna camajare na yʉ canuepere ¿mʉja tʉgooñaquẽeti? ¿Noo cãnacã pii majuu na caʉga rʉgarijere mʉja cajee neori? caĩñupʉ Jesu. Cʉ buerã maca: —Doce piiri majuu jã cajee neowʉ, caĩñuparã. To bairo na caĩro na caĩnemoñupʉ Jesu tunu: ");
INSERT INTO tav_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ape ni quenare siete rupaari pan rupaari mena bapari cãnacã mil cãna camajare yʉ canuwʉ. ¿Ti paʉ quenare noo cãnacã pii majuu mʉja cajee neori? na caĩñupʉ Jesu. —Siete piiri majuu jã cajee neowʉ, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","To bairo na caĩro na caĩñupʉ Jesu tunu: —To bairo yʉ cátajere majibana quena ¿nope ĩrã mʉja api majiquẽeti mai? na caĩñupʉ. To bairo ĩi pan macaje meere ĩi caĩñupʉ. Fariseo maja jocarãna na cabuerijere caroaro tʉgooña majiri na apiʉjaquẽja ĩi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesu cʉ buerã mena ʉtabʉcʉrare peña, ape nʉgoa Betsaida cawamecʉti macapʉ capeña ejayuparã. Ti macapʉ na caejaro Jesu tʉpʉ jĩcaʉ cacape tʉjʉquẽcʉre cane ejayuparã. Jesu tʉpʉ cʉ ne ejari, ocõo bairo cʉ caĩ jeniñuparã: —Anire cʉ pañari cʉ netooña, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","To bairi Jesu cacape tʉjʉquẽcʉre cʉ wamo mena tʉ̃ga aáti maca tʉjaropʉ cʉ cane aájupʉ. Cabero Jesu cʉ ʉcoo mena cʉ catu wareyupʉ cʉ capere. To bairo áti yaparo Jesu cʉ wamori mena cʉ capere cañiga peoyupʉ. To bairo átiri cʉ caĩ jeniñañupʉ: —¿Mʉre apeye unie to bauti? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","To bairo cʉ caĩro, tʉjʉ pã: —Yʉ tʉjʉ camajare baii pʉa. Yucʉre bairo cabaurã aáteñama, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","To bairo cʉ caĩro apii Jesu cʉ capere cʉ wamori mena cañiga peonemoñupʉ tunu. To bairo cʉ cátopʉna caroaro majuu catʉjʉ majiñupʉ yua. To cãnacã wame cariape catʉjʉ majiñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","To bairi Jesu: —Macapʉre aáquẽja. Mʉre yʉ canetoorijere aperãre buio batequẽcʉna mʉ ya wiipʉ tunu aácʉja, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cabero Jesu cʉ buerã mena Césarea Filipo tʉ cãni macaripʉ cáaájuparã. Topʉ na jʉgo aácʉ ocõo bairo cʉ buerãre na caĩ jeniñañupʉ Jesu: —Camaja yʉ cabairijere wadapenirã, ¿Ñamʉ majuu cʉ̃ ãcʉmi, na ĩnucuti? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","To bairo cʉ caĩ jeniñaro ocõo bairo cʉ caĩ yʉyuparã: —Jĩcaarã, “Juan bautisari majocʉ cajĩa ecooricʉ ãnacʉ catunu catiricʉ ãcʉmi,” mʉre ĩma. Aperã, “Tirʉmʉpʉ macacʉ Dio ye quetire buiori majocʉ, Elías cãniñaricʉ tunu ejaricʉmi,” mʉre ĩnucuma. Aperã maca, “Apeĩ Dio ye quetire cabuioricʉ tirʉmʉpʉ macacʉ catunu catiricʉ ãcʉmi,” mʉre ĩma, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesu cʉ buerãre na caĩ jeniñanemoñupʉ tunu: —Mʉja maca, ¿ñamʉ majuu ãcʉmi, yʉre mʉja ĩ tʉgooñati? To bairo cʉ caĩro apii Pedro maca cʉ caĩ yʉyupʉ: —Tirʉmʉpʉ macana, “Camaja tʉpʉ joogʉmi Dio jĩcaʉ cãni majuʉre,” na caĩricʉna mʉ ã, cʉ caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","To bairo Pedro cʉ caĩriquere aperãre na cabuio rotiquẽjupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cabero Jesu cʉ buerãre ocõo bairo na cabuio jʉgoyupʉ: —Yʉa camaja tʉpʉ Dio cʉ cajooricʉ anibacʉ quena seeto yʉ popiye tamʉogʉ. Cabʉcʉrã judío majare carotirã, sacerdote maja ʉparã, judío majare cabuerã nipetirã yʉ tʉjʉteeri aperãre na jĩa rotigarãma yʉre. To bairo yʉre na cajĩabato quena itia rʉmʉ bero yʉ tunu catigʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Caroaro na api majiato ĩi, cariape to bairije na caĩ buioyupʉ Jesu. To bairije na cʉ caĩ buioro Pedro aperobʉjaacã cʉ ne aáti: —¡To bairo ĩqueticõaña! Jesure cʉ caĩ tutiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To bairo Pedro cʉ caĩro cʉ buerãre amojore tʉjʉri Pedrore cʉ catutiyupʉ Jesu: —¡Sataná, yʉre aáweoya! caĩñupʉ. Pedro Sataná cʉ caĩgari wamere cʉ caĩro ĩi, to bairo Pedrore cʉ caĩ tutiyupʉ Jesu. To bairi: —Dio cʉ caboorijere mʉ tʉgooñaquẽe. Camaja na caboorije macare mʉ tʉgooña mʉa, cʉ caĩñupʉ Pedrore. ");
INSERT INTO tav_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cabero Jesu cʉ buerã aperã camaja quenare pi neojori na cabuioyupʉ: —Yʉ mena macana anigarã mʉja majuuna mʉja cátigarijere tʉgooñaqueticõaña. To cãnacã rʉmʉ yʉ caboorije macare áti ʉjaya. Yʉre na cajĩagarore bairona mʉja quenare na cajĩagarije to cãnibato quena yʉre áti ʉjanucucõaña. ");
INSERT INTO tav_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Noa, “Yʉ majuuna yʉ caboorije yʉ átigʉ,” caĩrã Dio tʉpʉ to cãnacã rʉmʉ catirique bʉgaquetigarãma. To bairi ati yepa ãnapʉ mʉja majuuna mʉja caboorije átiquẽna, yʉ caboorije macare ána, yʉ ye quetire apiʉjarã, caroa ãnajere mʉja bʉgagarã. ");
INSERT INTO tav_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","To bairi jĩcaʉ ati yepa macaje apeye unie nipetiro cacʉgoʉ Dio tʉpʉ cʉ cãnibope macare catʉgooñaquẽcʉ ũcʉ catirique bʉgaquetigʉmi. To bairi cʉ yeri maca Sataná tʉpʉ aá, cʉ cabaiata ñuuquetiboro. Sataná tʉpʉ cʉ cáaáquetipere wapaye majiquetiboʉmi, ati yepa macaje nipetiro cʉ cacʉgorije to cãnibato quena. ");
INSERT INTO tav_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ati yʉtea macana caroorã, yʉre canʉcʉbʉgoquẽna watoapʉ ãnaa, “Jesu yarã jã ã, cʉ ye quetire caapiʉjarã jã ã,” ĩ boboqueticõaña. Ape rʉmʉpʉ yʉ tunu atígʉ, yʉ Pacʉ cʉ caaji baterije mena, cʉ tʉ macana ángel maja mena. Ti paʉ cãno yʉre caboboricarãre yʉ quena na yʉ bobogʉ. “Yʉ cabuericarã me ãma,” yʉ quena na yʉ ĩgʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu camajare cʉ cabuioricaro bero ape wame cʉ buerãre na cabuioyupʉ tunu: —Cariape mʉjaare yʉ ĩ. Atopʉ cãna mʉjaa jĩcaarã mʉja cabai yajiparo jʉgoye Ʉpaʉ Dio cʉ cãniere mʉja tʉjʉgarã tutuaro mena cʉ caejaro. ");
INSERT INTO tav_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis cãnacã rʉmʉri bero jĩcaʉ ʉ̃taʉ caʉmʉaricʉpʉ cáaájupʉ Jesu. Pedro, Jacobo, Juan na jetore na cajee aájupʉ cʉ mena. Topʉ eja, ti ʉ̃taʉpʉ ãnaa na catʉjʉjoro Jesu cʉ cabaurije ricati cabauyupe. ");
INSERT INTO tav_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cʉ jutii seeto ajiya, seeto majuu cabotiyupe. Camaja sabaũ mena jutii cabotirije na cacojero netoro cabotiyupe. ");
INSERT INTO tav_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","To bairo cabairi paʉna Elías, to bairi Moisé buia nʉcari Jesu mena cawadapeni tʉjʉnucuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","To bairo na cabairo tʉjʉʉ Pedro maca ocõo bairo caĩñupʉ Jesure: —Jã Ʉpaʉ, ñuu majuucõa atopʉ mani cãno. To bairi itia wiiacãre mani ána. Mʉ ya wii cãnipa wii, Moisé ya wii, Elías ya wii cãnipa wiiri mani ána. ");
INSERT INTO tav_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jesu buerã caacʉa netocoajuparã. To bairi Pedro dope bairo ĩ majiquetibacʉna to bairije caĩcõañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","To bairo Pedro cʉ caĩri paʉna bujeri bʉrʉa na cabuje bipe ájupe. To bairi bʉrʉa bujeri bʉrʉa watoapʉ ocõo bairo caĩ wadaro caapiyuparã: —Ani yʉ Macʉ, yʉ camaii majuu ãmi. Cʉ cabuiorijere caroaro apiʉjaya, ĩriquere caapiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","To bairo caĩro bero catʉjʉjobajuparã tunu. Jesu jĩcaʉna cʉ catʉjʉnucuro catʉjʉyuparã. Aperã cʉ mena catʉjʉnucuricarã camañuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","To cõona ʉ̃taʉpʉ cãnana na carui aáto Jesu to bairo cabairo na catʉjʉriquere aperãre cabuio rotiquẽjupʉ: —Yʉ, camaja tʉpʉ Dio cʉ cajooricʉ yʉ cãnibato quena yʉre jĩa rocagarãma. To bairi cabai yajiricʉ cãnacʉ yʉ catunu catiro bero aperãre na mʉja buiogarã yua, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","To bairi aperãre buioquẽnana na jetona catʉgooñañuparã. To bairo tʉgooñari caame ĩ jeniñañuparã: —¿Dope bairo cabaipere bai yajiricaro bero tunu catirique cʉ ĩti? caame ĩ jeniñañuparã na majuuna. ");
INSERT INTO tav_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Cabero Jesu quenare cajeniñañuparã tunu: —¿Nope ĩrã judío majare cabuerã, “Dio cʉ cajoopaʉ majuu jʉgoye Elías ãnacʉ tunu atígʉmi,” na ĩnucuti? cʉ caĩ jeniñañuparã. To bairo na caĩ jeniñaro ocõo bairo caroaro na caĩ buioyupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Cariape ĩma. Elías cʉ cáatípena cãñupa Dio yʉre cʉ cajooparo jʉgoye. Camajare na cayeri quenoo jʉgoyeyepaʉ cãmi. Dio ye queti ucarica pũuropʉ ocõo bairo baigʉmi Dio cʉ cajooricʉ ati yepapʉ ejaʉ, ĩ ucarique ã: “Yʉ tʉjʉteebana yʉre popiyeyegarãma,” ĩ ucarique ã. ");
INSERT INTO tav_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Cariape mʉjaare yʉ ĩ: Elías ãnacʉ caejatʉgawĩ mere. Cʉ caejabato quena tirʉmʉpʉ macana, “Elías atígʉmi,” na caĩricʉ Juãre, “Cʉna ãmi,” cʉ caĩ tʉjʉquẽma. Na caboorije maca cʉ cájuparã, cʉ jĩarã. To bairo ána tirʉmʉpʉ macana na caĩ ucaricarore bairona cabaiyupa Juãre. ");
INSERT INTO tav_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ʉ̃taʉpʉ caejaricarã na mena macana na cãnopʉ rui ejarã camaja capãarã cãnare catʉjʉyuparã. Aperã quena judío majare cabuerã Jesu buerã mena seeto caame wada canamuñuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","To bairi Jesu na tʉpʉ cʉ carui ejaro tʉjʉrã catʉjʉ acʉacoajuparã. To bairi cʉ tʉpʉ atʉ aáti, cʉ cañuu rotira aájuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","To bairo na cáto: —¿Ñe uniere wadapenirã to cõo mʉja wada canamuri? na caĩ jeniñañupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To bairo cʉ caĩ jeniñaro apii jĩcaʉ na paarãacã watoapʉ cãcʉ cʉ caĩ yʉyupʉ Jesure: —Ʉpaʉ, yʉ macʉ jĩcaʉna cãcʉre wãti cacʉgoʉre yʉ neapʉ́. Yʉ macʉ wãti jʉgori wada majiquẽemi. ");
INSERT INTO tav_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wãti cʉ cañe roca cũrona cʉ rijeropʉ jopo tu, cʉ opi baque ruio, to bairi bʉ yajicoanucumi yʉ macʉ. Mere mʉ buerã quenare, “Wãtire cʉ buu rocabojaya yʉ macʉre,” na yʉ ĩbapʉ. Cʉ buu roca majiquẽma, Jesure caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","To bairo cʉ caĩro apii ocõo bairo caĩñupʉ Jesu cʉ buerãre: —Caroaro yʉre mʉja api nʉcʉbʉgoquẽe. Cariape mʉja tʉgooñaquẽe. Yoaro mʉjaare yʉ caĩ buiobato quena mʉja api majiquẽe. Ani cʉ macʉre yʉ tʉpʉ cʉ neajá, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","To bairo cʉ caĩro Jesu tʉpʉ cawimaʉre caneajuparã. Cawimaʉre Jesu tʉpʉ na caneatóna majiña mano cawimaʉre cʉ caria ñaro cʉ cájupʉ wãti tunu. To bairo cʉ cáto cawimaʉ maca roca cumu, yugui mecʉ, cʉ rijeropʉ jopo tu, cabaicoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","To bairo cʉ cabairo tʉjʉri Jesu cawimaʉ pacʉre cajeniñañupʉ: —¿Diwatipʉ to bairo cʉ cabai jʉgori? cʉ caĩñupʉ. Cawimaʉ pacʉ maca ocõo bairo cʉ caĩ yʉyupʉ: —Cawimaʉpʉna to bairo cabai jʉgowĩ. ");
INSERT INTO tav_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Capee niri wãti cʉ jĩagʉ peropʉ cʉ roca joe, riapʉ quenare cʉ roca ñuanucumi. Mʉ catutuarije mena cʉ̃re mʉ canetoo majiata jã bopaca tʉjʉri jã átinemoña. ");
INSERT INTO tav_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","To bairo cʉ caĩro Jesu maca ocõo bairo cʉ caĩñupʉ: —Yʉre mʉ canʉcʉbʉgoata cʉ̃re yʉ netooboja maji. Yʉre canʉcʉbʉgorã nipetirore nipetiri wamere na yʉ netooboja maji. ");
INSERT INTO tav_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To bairo cʉ caĩro apii cawimaʉ pacʉ tutuaro ĩ, seeto Jesure cʉ caĩ jeniñupʉ: —Mʉre yʉ nʉcʉbʉgo. Netobʉjaro yʉ canʉcʉbʉgoro yʉre átinemoña, seetobʉja cʉ caĩ jeninemoñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu camaja capãarã na tʉpʉ na caatʉ ató tʉjʉʉ wãtire roca buʉ ocõo bairo caĩñupʉ: —Wãti cʉ cawada majiquẽto, cʉ caapi majiquẽto cácʉ, buti aácʉja. Ani cawimaʉpʉre cãcʉ aácʉja. Pʉgani cʉ̃pʉre jãanemoqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","To bairo cʉ caĩrona wãti cʉ caawaja buti aátona cawimaʉ caria ñacoajupʉ tunu. To bairo bai, ria yajicoacʉre bairo cabaiyupʉ. To bairi aperã maca: —Ria yajicoapi, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesu maca cʉ wamopʉ ñeri, cʉ catʉ̃ga wamʉo nʉcoñupʉ. To bairo cʉ cátona cawamʉ nʉcacoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cabero Jesu wiipʉ cʉ cajãaro cʉ buerã aperã na caapiquẽtopʉ cʉ caĩ jeniñañuparã: —¿Nope ĩrã wãtire jã roca buu majiquẽjupari? ");
INSERT INTO tav_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","To bairo na caĩro: —To bairo cabairã una wãtiare buugarã ʉgaqueti seeto Diore cajeni nʉcʉbʉgope ã. ");
INSERT INTO tav_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","To bairi Césarea Filipopʉ cãnana Galilea yepapʉ cáaácoajuparã tunu. Topʉ na cáatíere aperã na camajiro cabooquẽjupʉ Jesu, cʉ buerã jetore na ĩ buiogʉ. Ocõo bairo na caĩ buioyupʉ: —Aperã yʉre ñeri, yʉ joogarãma yʉre cajĩaparãre. To bairo yʉre na cajĩa rocabato quena itia rʉmʉ bero yʉ tunu catigʉ, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cʉ buerã maca to bairo cʉ caĩrijere caapi majiquẽjuparã. Api majiquetibana quena, “¿Dope bairo ĩgʉ mʉ ĩti?” cʉ caĩ jeniña uwiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cabero Capernaum cawamecʉti macapʉ caejayuparã. Ti macapʉ eja, na cãni wiipʉ na cajãaro bero cʉ buerãre na caĩ jeniñañupʉ Jesu: —Mapʉ aána ¿ñe uniere mʉja ame wadapeniri? ");
INSERT INTO tav_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na maca mapʉre aána, ¿ni maca mani mena macacʉ nipetiro netoro caroti majii cʉ anicʉti? caame wada peniricarã aniri cʉ cayʉquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","To bairi Jesu ejanumu, cʉ buerã doce majuu cãnare pijo, na caĩñupʉ: —Aperã netoro caroti majirã anigarã nipetirã bero macana, nare capaa coterã cãnipe ã. ");
INSERT INTO tav_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","To bairo ĩ, jĩcaʉ cawimaʉre cʉ pijo, na watoapʉ cʉ catʉjʉnucu rotiyupʉ. Cʉ tʉjʉnucu roti, cʉ ne mʉgoñari ocõo bairo caĩñupʉ cʉ buerãre: ");
INSERT INTO tav_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ani cawimaʉre bairo cãna cawatoa cãna na cãnibato quena yʉ carotiro mena nare mʉja cátinemoata yʉrena átinemorã mʉja áa. Yʉre cátinemorã maca yʉ Pacʉre átinemorã áama, caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Cabero Jesure cʉ caĩ buioyupʉ Juan: —Jãre cabuei, apeĩ camaja na yeri wãtiare na cʉ cabuu rebojaro jã tʉjʉwʉ. “Jesure caapi nʉcʉbʉgoʉ yʉ ã,” ĩri na yeri wãtiare na buti rotiwĩ. Mani mena macacʉ cʉ cãniquẽto maca, “Átiqueticõaña,” cʉ̃re jã boca ĩ matawʉ, caĩñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","To bairo cʉ caĩro apii Jesu maca ocõo bairo cʉ caĩñupʉ Juãre: —Cʉ mataqueticõaña. Ni ũcʉ yʉ wame mena apeye uniere áti iñoori bero rooro yʉre ĩ majiquetigʉmi. ");
INSERT INTO tav_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Manire cateequẽcʉ ũcʉ mani mena macacʉna ãmi. ");
INSERT INTO tav_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Noa yʉ yarã mʉja cãno mʉjaare cátinemorã, ocore mʉjaare catĩarã quenare caroaro na joogʉmi Dio, na quena mʉjaare petoacã cátinemorã ãma ĩi. ");
INSERT INTO tav_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Noo yʉre canʉcʉbʉgorãacãre rooro na cáto cácʉ ũcʉ Dio cʉ capopiyeyepaʉ majuu anigʉmi. Nemoona ʉ̃ta capairica mena cʉ wamʉ tutupʉ jia yori caʉ̃cʉari yapʉ roca ñuacõa jooata ñuuboro. To bairo átato nemoona bai yajiri cabero yʉ yarãre rooro na cáto áti rooye tuuquetiboʉmi. ");
INSERT INTO tav_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mʉja wamo mena rooro átigarã pa ta rocaricarore bairo ána to cõona caroorije áti janaña. Jĩca wamo mana anibana quena Dio tʉpʉ to cãnacã rʉmʉ mʉja cãno maca ñuubʉja. Pʉga nʉgoapʉna cawamoricʉna anibana quena pero cayatiqueti peropʉ mʉja cáaáto ñuuquetiboro. ");
INSERT INTO tav_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pero to bairo to caʉ̃nucucõarije to cãnibato quena becoa riaqueti majuucõagarãma. ");
INSERT INTO tav_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","48","Mʉja rʉpo mena rooro átigarã quena pa ta rocaricarore bairo ána to cõona caroorije áti janaña. Jĩca rʉpo mana anibana quena Dio tʉpʉ to cãnacã rʉmʉ mʉja cãno maca ñuubʉja. Pʉga nʉgoapʉna rʉporicʉna anibana quena peropʉ mʉja cáaáto ñuuquetiboro. To bairona mʉja capeari mena ape wame tʉjʉri caroorijere mʉja cátigaro mʉja capeari pĩa rocaricarore bairo tʉjʉ janacõaña. Cacapea mana anibana quena Dio tʉpʉ mʉja cáaáto ñuubʉja. Pʉga capeapʉna cape cʉtiri peropʉ mʉja cáaápata ñuuquetiboro. Topʉ pero to caʉ̃nucucõabato quena becoa ria yajiqueti majuucõagarãma. ");
INSERT INTO tav_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Camaja nipetiro ʉgariquere roarã pero mena jeto roanucuma. To bairi tiere bairo nipetiro yʉre caapi nʉcʉbʉgorã popiye tamʉori bero netobʉjaro tʉgooña ocabʉtigarãma yua. ");
INSERT INTO tav_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa caocaarije ñuubʉja. Caocaaquẽtie macare dope bairo caocaaro áti majiña maa. Moa caroaro caocaarijere bairo caroaro ãña. To bairi ame quẽrique mano aninucuña mʉjaa. ");
INSERT INTO tav_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu Capernaupʉ cãnacʉ Judea yepapʉ, Jordán na caĩri ya ape nʉgoapʉ quenare cáaájupʉ. Topʉ cʉ caejaro camaja capãarã cʉ tʉpʉ caneñapoyuparã. To bairi cʉ cátinucurore bairona Dio ye quetire na cabuioyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","To bairo cʉ cabuioro jĩcaarã fariseo maja Jesu tʉpʉ atí, cʉ tʉgooña mawijia bui cʉparo ĩrã ocõo bairo cʉ caĩ jeniñañuparã: —¿Mani judío majare jĩcaʉ cʉ nʉmore cʉ carocagaro roca rotirique to ãti? ");
INSERT INTO tav_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ocõo bairo na caĩ yʉyupʉ Jesu fariseo majare: —¿Moisé tirʉmʉpʉ macacʉ dope bairo cʉ carotiyupari? ");
INSERT INTO tav_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","To bairo cʉ caĩro: —Moisé ãnacʉ ocõo bairo caucayupi: “Jĩcaʉ cʉ nʉmore rocagʉ papera pũuro, ‘Ocõo bairo mʉ cabairije wapa mʉ yʉ rocagʉ,’ ĩ ucarica pũuro, cõre cʉ joato,” caĩ ucayupi Moisé, caĩñuparã fariseo maja Jesure. ");
INSERT INTO tav_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","To bairo na caĩro: —Mʉja yeripʉ Dio cʉ caboorijere mʉja cabai netoogaro to bairo caucayupi Moisé, jĩcaʉ cʉ nʉmore carocagaʉre mataquetigʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dio nipetiri wame áti jʉgoʉpʉna caʉmʉ, cãromio cájupi. ");
INSERT INTO tav_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","To bairi caʉmʉ cʉ pacʉ, cʉ pacore tʉgooña janari cʉ nʉmo ye macare tʉgooñagʉmi. ");
INSERT INTO tav_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","To bairi co mena aniri pʉgarã anibana quena cʉ nʉmo mena jĩcaʉre bairona ãma, cʉ nʉmo jãa. ");
INSERT INTO tav_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","To bairi camajocʉ jĩcaʉ cʉ nʉmo mena jĩcaʉre bairona aniri Dio cʉ cacũricarã ãma jĩca bapa. To bairona Dio cʉ cacũricarã aniri caame rocaquetiparã ãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cabero wiipʉ ãnaa Jesu buerã cʉ caĩriquerena caĩ jeniña nemoñuparã tunu. ");
INSERT INTO tav_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tiere na caĩ jeniñaro ocõo bairo na caĩ yʉyupʉ Jesu: —Noo cʉ nʉmore rocari apeo macare nʉmocʉcʉ rooro ácʉ áami cãni jʉgoricore. ");
INSERT INTO tav_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Cãromio quena, co manapʉre rocari apeĩ macare manapʉcʉco rooro áco áamo cãni jʉgoricʉre. ");
INSERT INTO tav_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cabero aperã na punaare Jesu tʉpʉ cajee ajuparã, na ñiga peori Diore na jenibojaya ĩrã. To bairo na cáto tʉjʉrã Jesu buerã maca nare matagabana: —Cawimarãre na jee atíqueticõaña, Jesure cʉ patowãcoorema, na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","To bairo na caĩ matarijere apii Jesu maca tʉjooquẽcʉ, ocõo bairo na caĩñupʉ: —Cawimarã yʉ tʉpʉ na aparo. Na mataqueticõaña. Ʉpaʉ Dio cʉ cãnopʉ cáaáparã ãma ati maja cawimarãre bairona caroaro yʉre catʉgooñarã. ");
INSERT INTO tav_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cariape mʉjaare yʉ ĩ. Ati maja cawimarã yʉre na caboorore bairo cabaiquẽna maca, Ʉpaʉ Dio cʉ cãnopʉ aáquetigarãma, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","To bairo ĩ yaparo cawimarãre na ne mʉgo, na ñiga peo, Diore na cajenibojayupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cabero Jesu aperopʉ cʉ cáaáti paʉ jĩcaʉ cʉ bero caatʉ ʉja ajupʉ. Cʉ tʉpʉ atʉ ejari, cʉ tʉpʉ ejacumu, cʉ nʉcʉbʉgori ocõo bairo cʉ caĩ jeniñañupʉ: —Jesu, caroaro camajare cabuei mʉ ã. Cañuu netoʉ mʉ ã. To bairi yʉre buioya. ¿Ñee uniere yʉ ácʉati yʉ cacaticõa aninucupere bʉgagʉ? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu maca ocõo bairo cʉ caĩ yʉyupʉ: —¿Nope ĩi cañuu netoʉ yʉre mʉ ĩti? ");
INSERT INTO tav_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dio jĩcaʉna ãmi cañuu netoʉ. Dio cʉ carotiriquere mʉ majii. “Camajare na jĩaqueticõaña. Ati epericarã cʉtiqueticõaña. Jee rutiqueticõaña. Jocʉna aperãre na ĩtoqueticõaña. Aperãre ĩtorique mena rooro na átiqueticõaña. Mʉ pacʉ, mʉ pacore na nʉcʉbʉgoya.” ");
INSERT INTO tav_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","To bairo cʉ caĩro apii: —Cawimaʉ ãcʉpʉna tiere yʉ cáti peocõawʉ, caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu cʉ mai tʉjʉri ocõo bairo cʉ caĩñupʉ: —Jĩca wameacã mʉ cátipe rʉja. Mʉ cacʉgorijere nuni peo wapa jeija. Mʉ cawapa jeerijere cabopacarãre na joo bate peocõaña. To bairo ácʉ ʉmʉrecoopʉ capee cañuu netorijere mʉ cʉgogʉ. To bairo áti yaparo mʉre camajiriobato quena, yʉ mena ajá, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","To bairo Jesu cʉ caĩrijere api tʉjooquẽcʉ, seeto tʉgooñarique pairi catunucoajupʉ, caapeye paii aniri. ");
INSERT INTO tav_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Cʉ cáaáto bero Jesu cʉ buerãre na tʉjʉri ocõo bairo na caĩñupʉ: —Caapeye unie pairãre Dio tʉpʉ na cáaápe seeto majuu majiriocõa, caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","To bairo cʉ caĩrijere apirã, Jesu buerã caapi acʉayuparã. To bairi Jesu na caĩnemoñupʉ tunu: —Yʉ punaare bairo cãna, caapeye unie cʉgo netorãre Dio tʉpʉ na cáaápe seeto majuu majirio netocõa. ");
INSERT INTO tav_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Waibʉcʉ cameyo cawamecʉcʉ capaii apopota yita wẽ pĩorica opeacãre cʉ caame butigaata majiriobʉja. To bairona seeto majirio caapeye unie pairã Dio tʉpʉ na cáaágaro. ");
INSERT INTO tav_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tiere cʉ caĩro cʉ buerã caapi acʉanemocoajuparã tunu: —Baiyupa cariape cʉ caĩata noa Dio tʉpʉ eja majiquẽnama, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu to bairo na caame ĩro apii ocõo bairo na caĩñupʉ: —Camaja na majuuna Dio tʉpʉ aá majiquẽema. Dio maca nipetiri wame cáti majii aniri jĩcaʉna ãmi cʉ tʉpʉ cáaáparãre canetoo majii. ");
INSERT INTO tav_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","To bairo cʉ caĩro Pedro ocõo bairo cʉ caĩñupʉ: —Nipetiro jã yere jã cáaáweowʉ, mʉ mena macana anigarã. ");
INSERT INTO tav_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","To bairo cʉ caĩro: —Cariape mʉjaare yʉ ĩ. Jĩcaʉ ũcʉ cʉ ya wii, cʉ pacʉa, cʉ yarã, cʉ punaa, cʉ wejeri, nipetirore cʉ cáaáweoquẽpata, Dio cʉ caboorije macare átigʉ, capee majuu caroa cʉ cacʉgo jʉgorique netoro majuu bʉganemogʉmi ati yepapʉre. Aperã rooro nare na cátibato quena caroare bʉgagʉmi. Caberopʉ quenare Dio mena aninucucõagʉmi. ");
INSERT INTO tav_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","To bairi yucʉacã, “Cãni majuurã jã ã,” caĩrã caberopʉ cawatoa cãna anigarãma. Capãarã yucʉacãre cawatoa macana cãna quena caberopʉ cãni majuurã anigarãma na maca, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cabero Jesu Jerusalẽpʉ aáta wãpʉre aácʉ cʉ buerã jʉgoye cajʉgoyupʉ. ¿Dope bairo Jerusalẽpʉ to bairoati? ĩrã tʉgooña acʉari uwirique mena cʉ bero caʉjayuparã. To bairi na caejaparo jʉgoye cʉ buerãre ricati pi neori cʉ̃re cabaipere na caĩ buioyupʉ: ");
INSERT INTO tav_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Jerusalẽpʉ aána mani bai, mʉja maji. Topʉ yʉ caejaro Dio ati yepapʉ cʉ cajooricʉ yʉ cãnibato quena aperã yʉre ñeri yʉre joogarãma sacerdote maja ʉparãre, judío majare cabuerãre. To bairi yʉre joo netogarãma tunu judío maja cãniquẽnapʉre, cʉ jĩa rocacõaña ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","To bairi na maca yʉre ĩ eperi, yʉ ʉcoo eo turi, yʉre baperi, yʉre jĩa rocagarãma yua. To bairo yʉre na cajĩa rocabato quena itia rʉmʉ bero yʉ tunu catigʉ, na caĩ buioyupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cabero Jacobo, Juan Sebedeo punaa Jesu tʉpʉ aáti: —Jãre cabuei, mʉre jã cajeniri wame jãre mʉ cátibojaro jã boo, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Ñee uniere mʉjaare yʉ cátibojaro mʉja booti? na caĩ jeniñañupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Mʉ carotiri paʉ cãnopʉ mʉ mena carotinemoparãre jãre mʉ cũwã. Jĩcaʉ cariape nʉgoa, apeĩ cacõ nʉgoapʉ mʉ mena ruiri carotiparã jã anigarã, cʉ caĩñuparã Sebedeo punaa. ");
INSERT INTO tav_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","To bairo na caĩro ocõo bairo na caĩñupʉ Jesu maca: —Mʉja cajeniri wamere mʉja tʉgooña majiquẽe. Aperã seeto yʉ popiyeyegarãma. Yʉre na capopiyeyepere bairo mʉja quena mʉjaare na capopiyeyero ¿mʉja nʉca majicʉti? na caĩ jeniñañupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ʉ̃ʉjʉ, jã nʉca ocabʉti majirã, caĩñuparã. To bairo na caĩro ocõo bairo na caĩñupʉ Jesu: —Yʉre na capopiyeyepere bairona mʉja quenare mʉja popiyeyegarãma aperã. ");
INSERT INTO tav_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yʉre bairona catamʉoparã mʉja cãnibato quena yʉ mena carotiparãre mʉjaare yʉ cũ majiquẽe. Yʉ riape nʉgoa, yʉ cacõ nʉgoapʉ yʉ mena caroti ruiparãre carotipaʉ mee yʉ ã. Yʉ Pacʉ maca bejegʉmi yʉ mena caroti ruiparãre. ");
INSERT INTO tav_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","To bairo Jesure cʉ na cajeniro apirã aperã Jesu buerã diez cãnacʉ cãna maca na catʉgooña punijiniñuparã Jacobore, Juãre to bairo Jesure na caĩ jenirijere. ");
INSERT INTO tav_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","To bairo na cabairo tʉjʉʉ Jesu na pijori ocõo bairo na caĩñupʉ: —Mʉja majirã. Ape macari macana na ʉparã tutuaro rotima. Na ẽoro carotirã quena na majare rotima tunu. ");
INSERT INTO tav_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉja maca to bairo cabaiquetiparã mʉja ã. Nii mʉja yaʉ cãni majuʉ anigʉ capaa cotei cʉ ãmaro. ");
INSERT INTO tav_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cajʉgo ãcʉ majuu anigʉ, aperã nipetirore capaabojaʉ cʉ ãmaro cʉ quena. ");
INSERT INTO tav_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","To bairona yʉ camaja tʉpʉ Dio cʉ cajooricʉ anibacʉ quena aperãre, “Yʉre capaa coteri maja ãña,” caĩi mee yʉ ã. Yʉ majuuna aperãre átinemoʉ acʉ́ yʉ cáapʉ́. To bairi camaja capãarã majuu caroorije na cátajere bai yaji wapayebojaʉ acʉ́ yʉ cáapʉ́ ati yepapʉ, caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jerusalẽpʉ ma aána Jericó cawamecʉti macapʉ caejayuparã. Jesu cʉ buerã mena aperã capãarã camaja mena ti macare eja, na caneto aáti paʉ Bartimeo cawamecʉcʉ, Timeo macʉ cacape tʉjʉquẽcʉ ma tʉjaro caniyeru jeni ruiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","To bairi, “Aperã Jesu Nasaré macacʉ neto aácʉ áami,” na caĩro apii caĩ awajajoyupʉ: —¡Jesu! ¡Ʉpaʉ David ãnacʉ pãrami, Dio cʉ cajooricʉna mʉ ã! ¡To bairi yʉre bopaca tʉjʉya! caĩ awajajoyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","To bairo cʉ caĩro apirã capãarã camaja: —¡Awajaqueticõaña! ¡Janaacʉja! cʉ caĩ tutiyuparã Jesu jʉgoye cáaána maca. To bairo na caĩ tutirije to cãnibato quena seetobʉja caĩ awajanemoñupʉ tunu: —¡Ʉpaʉ David ãnacʉ pãrami, Dio cʉ cajooricʉna mʉ ã! ¡To bairi yʉre bopaca tʉjʉya! ");
INSERT INTO tav_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","To bairo cʉ caĩ awajarijere apii Jesu catua nʉcañupʉ. Tuanʉca, cʉ̃re capi awajaʉre aperãre cʉ tʉpʉ na catʉ̃ga atí rotiyupʉ. To bairo cʉ̃re Jesu na cʉ catʉ̃ga atí rotiro, cʉ caĩñuparã: —Tʉgooñarique paiquẽja. Adʉja uwaro. Mʉre pimi Jesu, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","To bairo na caĩro apii, cabui macá wʉ tu we roca cũ, bapa wamʉnʉca, Jesu tʉpʉ cáaájupʉ. ");
INSERT INTO tav_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu tʉpʉ cʉ caejaro: —¿Ñeere mʉre yʉ cátibojapere mʉ booti? cʉ caĩ jeniñañupʉ Jesu. —Yʉ Ʉpaʉ, yʉ cape yʉ catʉjʉpere yʉ boo, caĩñupʉ Bartimeo. ");
INSERT INTO tav_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","To bairo cʉ caĩro: —“Yʉre netoo majiimi,” yʉre mʉ tʉgooña nʉcʉbʉgowʉ. To bairi mere mʉre yʉ netootʉgawʉ. To cõona aácʉja. To bairo Jesu cʉ caĩrona Bartimeo catʉjʉ majicoajupʉ. Tʉjʉ maji, Jesu mena mapʉ cáaácoajupʉ cʉ quena. ");
INSERT INTO tav_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesu cʉ buerã mena Jerusalẽpʉ cʉ caejaparo tʉacãna cãñupe Betfagé, Betania cawamecʉti macari Ʉ̃taʉ Olivo cawamecʉtii canamuñaro caejayuparã. Topʉ eja, cʉ buerã pʉgarãre ocõo bairo na caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Aánaja, i maca mani jʉgoye cãni macapʉ. Ejarã jĩcaʉ burroacã na cajia nʉcoricʉre mʉja bʉgagarã capejañaña mácʉre. Cʉ̃re popio, ne ajá. ");
INSERT INTO tav_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aperã mʉjaare, “¿Nope ĩrã to bairo mʉja áati?” na caĩro, “Jã Ʉpaʉ boojowĩ. Yoaro meena cʉ tunuogʉmi tunu,” mʉja ĩwã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","To bairo cʉ caĩro aá, wiire na cajani jãarica jope tʉna ma tʉjaro na cajia nʉcoricʉre cabʉgayuparã. Cʉ bʉga ejari cʉ capopioyuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","To bairo na cáto tʉjʉri topʉ catʉjʉnucurã ocõo bairo na caĩñuparã: —¿Dope átigarã cʉ̃re mʉja popioti? ");
INSERT INTO tav_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","To bairo na caĩro apirã Jesu na cʉ caĩ rotiricarore bairona caĩ yʉyuparã. To bairo na caĩro apirã: —Ne aánaja, na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cabero Jesu tʉpʉ cʉ ne aá, na jutii cabui macajere catu we peoyuparã. To bairo na cáto na jutii bui pejari cáaámi Jesu yua. ");
INSERT INTO tav_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cʉ̃re áti nʉcʉbʉgorã capãarã cʉ caneto aápa wãre na ye jutii bui macajere ejoo cũri cacũ jʉgoye cʉjuparã. Aperã maca ma tʉjaro macaje bo queri capajure cũñuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cʉ jʉgoye cáaána, cʉ bero caʉjarã quena ocõo bairo caĩ awaja wariñuuñuparã: —¡Mani Ʉpaʉre caĩ wariñuupe ã! ¡Ani Dio cʉ cajooricʉ cañuu netoʉ ãmi! ");
INSERT INTO tav_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mani ñicʉ Ʉpaʉ David cʉ cãnatore bairo caroaro to baicõa ãmaro. ¡Dio jõ bui cãcʉ caroaro cʉ̃re mani áti nʉcʉbʉgoto! ");
INSERT INTO tav_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cabero Jesu Jerusalẽpʉ eja, Dio wii capairi wii majuure cajãañupʉ. Topʉ nipetirijere ti wii macajere tʉjʉ peti, Betaniapʉ cʉ buerã mena cáaácoajupʉ canaiori paʉacã cãno maca naio aáto bai ĩi. ");
INSERT INTO tav_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ape rʉmʉ cabujuri paʉ Betaniapʉ cãnana Jerusalẽpʉre aána na cabairi paʉ Jesu maca seeto cañigo riayupʉ. ");
INSERT INTO tav_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma tʉjaro cayoabʉjaroacãpʉ higuera cawamecʉtii yucʉre caroaro capũ cʉtiire catʉjʉyupʉ. Tiire tʉjʉ bʉga, ricacʉto ĩi tiire catʉjʉʉ aájupʉ. Cʉ catʉjʉ ejaro capũ jeto cãñupe. Carica maca camañupe. Caricacʉti yʉtea mee cãñupe. ");
INSERT INTO tav_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Carica mano tʉjʉri tiire ocõo bairo caĩñupʉ Jesu: —To ricacʉti nemoqueticõato yua, caĩñupʉ Jesu tii yucʉre. To bairo cʉ caĩro cʉ buerã caapiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","To bairo bairi bero Jerusalẽpʉ caejayuparã. Jesu Dio wii capairi wiire jãa ejaʉ catʉjʉyupʉ cawapayerãre, caapeye joo wapatarã quenare. Na tʉjʉ, Dio wiipʉre to bairo na cátiere booquẽcʉ na cabuuyupʉ. Aperã niyeru wajoari maja ye cajawarire catupu cũ re peocõañupʉ. Aperã na cajĩa joe buje mʉgo jooparã buaare joori cawapa jeerã quenare na caruirijere catupu cũ recõañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aperã quenare apeye uniere na cajee neto rotiquẽjupʉ Dio wii recomacapʉre. ");
INSERT INTO tav_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","To bairi Dio ye quetire tirʉmʉpʉ macana na caĩ ucarique na caĩ buioyupʉ: —Dio Wadariquepʉ, “Yʉ ya wii camaja nipetiro to cãnacã poa macana yʉre na cajeni nʉcʉbʉgopa wii ã,” ĩ ucarique ã. Mʉja maca to bairo Dio wiipʉna wapa jeerã cajee ruti pairã na cãni paʉre bairona mʉja áa, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","To bairo cʉ caĩ buiorijere apirã sacerdote maja ʉparã, judío majare cabuerã to bairo cʉ caĩrijere caapiyuparã. Tiere apirã, ¿dope bairo átiri cʉ̃re mani jĩarãati? caame ĩ wadapeni jʉgoyuparã. Cʉ cabuiorijere camaja nipetiro na caapi tʉjʉ acʉaro cʉ cauwiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cabero canaiori paʉ cãno Jesu ti macapʉ cãnacʉ cáaácoajupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ape rʉmʉ cabujuri paʉ tunu Jerusalẽpʉ aána higuera cawamecʉtii yucʉre canʉcoripʉna cajini yajiricʉre catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","To bairi Pedro, “To ricacʉti nemoqueticõato atii yucʉ,” Jesu cʉ caĩriquere tʉgooñari ocõo bairo Jesure cʉ caĩñupʉ: —Ʉpaʉ, tʉjʉya. “Icʉ cañuuquẽtii to ãmaro,” mʉ caĩecʉ jini yajicoajupa, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","To bairo cʉ caĩro ocõo bairo caĩñupʉ Jesu cʉ buerãre: —Diore cariapena tʉgooña ocabʉtiya. ");
INSERT INTO tav_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","—Cariape mʉjaare yʉ ĩ. Diore tʉgooña ocabʉtiri, “Diore yʉ cajenibato quena baiquetigaro,” ĩ tʉgooñaquẽnana Diore jeni nʉcʉbʉgoya. To bairo mʉja cáto Diore mʉja cajeniri wamere mʉja átibojagʉmi. Icʉ ʉ̃taʉ, “Ato cãnacʉ pairi yapʉ roca ñua yaji aátoja,” mʉja caĩata quenare to bairona baigaro. ");
INSERT INTO tav_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","To bairi, “Yʉ joogʉmi Dio,” cʉ mʉja caĩ tʉgooña nʉcʉbʉgoro nipetiro mʉja cajenirijere mʉja joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","To bairi Diore jenirã aperã mena apeye unie rooro mʉjaare cátana na cãmata na majirioya. To bairo aperã rooro mʉjaare na cátajere na mʉja camajirioro mani Pacʉ ʉmʉrecoo macacʉ mʉja quenare caroorije mʉja cátajere majiriogʉmi. ");
INSERT INTO tav_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Caroorije aperã mʉjaare na cátajere mʉja camajirioquẽpata mʉja majirioquetigʉmi mani Pacʉ rooro mʉja cátaje quenare, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cabero Jerusalẽpʉ catunu ejayuparã tunu. Jesu Dio wii capairi wii pupeapʉ cʉ cáaáteñari paʉ ocõo bairo cabaiyupe. Sacerdote maja ʉparã, judío majare cabuerã aperã cabʉcʉrã carotirã quena Jesu tʉpʉ caejayuparã. ");
INSERT INTO tav_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Cʉ tʉpʉ ejari ocõo bairo cʉ caĩ jeniñañuparã: —¿Ñamʉ maca to bairo mʉ cátiere cʉ cáti rotiri? ");
INSERT INTO tav_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu maca na caĩ yʉyupʉ: —Yʉ quena mʉjaare yʉ jeniñagʉ. Cariapena yʉre mʉja cayʉata mʉja quenare, “Cʉ̃ yʉ áti rotimi,” mʉjaare yʉ ĩ buiogʉ. ");
INSERT INTO tav_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ñamʉ maca Juan cabautisari majocʉre cʉ cajooyupari? ¿Dio maca o camaja maca cʉ̃re na cabautisa rotiyupari? Tiere yʉre buioya, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","To bairo cʉ caĩro apirã na majuuna ocõo bairo caame ĩ wadapeniñuparã: —“Diona cʉ rotiricʉmi,” mani caĩata, “¿Nope ĩrã Dio cʉ carotiricʉrena cʉ mʉja caapiʉjaqueti?” mani ĩboʉmi Jesu. ");
INSERT INTO tav_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Camaja na majuuna Juãre cʉ rotiricarãma,” mani caĩata, camaja manire tutirema ĩrã na mani uwiborã. “Dio ye quetire cabuioʉ, Dio cʉ cajooricʉna ãnacʉmi Juan,” ĩ tʉgooñama camaja nipetirã, caame ĩ wadapeniñuparã na majuuna. ");
INSERT INTO tav_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","To bairo ame ĩ wadapeniri: —Jã majiquẽe, caĩñuparã. To bairo na caĩro: —Yʉ quena cʉ̃ cʉ carotirije mena to bairo yʉ áa, yʉ ĩ buioquẽe, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Cabero Jesu buio majiorica wame mena nare buioʉ ocõo bairo na caĩñupʉ: —Jĩcaʉ cʉ ya wejepʉ ʉje miji wẽrire caoteyupʉ. Ote yaparo ti wejere cajani jãcõañupʉ. To bairo átiri jĩca paʉ ʉ̃taa capairicapʉre carupa coro ʉje ocore cʉ caripe jãpa corore caquenooñupʉ. Áti yaparo caʉmʉari wii cájupʉ jee rutiri maja na cáató na catʉjʉ cotepa wiire. To bairo áti yaparo aperopʉ aáteñaʉ aágʉ aperãre ocõo bairo na caĩ cũñupʉ: “Yʉ ʉje wejere yʉ cotebojaya. Yʉre mʉja cacotebojaro mʉjaare yʉ joogʉ carecomaca caricare.” To bairo na ĩ cũ yaparo aperopʉ cáaáteñaʉ aájupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Cabero ʉje caricacʉti yʉtea cãno jĩcaʉ cʉ paabojari majocʉre cʉ cajooyupʉ cʉ ya wejere cʉ cacote rotiricarã tʉpʉre. “Yʉ ye ʉje ricare na ricawo joato, nare jeniija,” cʉ caĩ jooyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","To bairo cʉ caĩro apii cajenii aábajupʉ. Cʉ caejaro wejere cʉ cacote rotiricarã maca cʉ ñe, cʉ caquẽñuparã, cʉ joogaquẽna. To bairo na cáto bʉgaquẽcʉna catunucoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Cabero ti weje ʉpaʉ apeĩ cʉ paabojari majocʉre cajoobajupʉ tunu. To bairo cʉ cajooro cʉ quena cáaábajupʉ. Cʉ caejaro ti wejere cʉ cacote rotiricarã ʉ̃ta rupaa mena cʉ rerã cʉ rʉpoare camiroyeri rooro cʉ caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","To bairo cʉ quenare na cajoogaquẽto tʉjʉʉ ti weje ʉpaʉ apeĩre cajoobajupʉ tunu. Ti wejere cʉ cacote rotiricarã maca topʉ cʉ caejarona cʉ cajĩa rocacõañuparã. Cabero capãarã cajoonemobajupʉ tunu. Topʉ na caejaro ti wejere cʉ cacote rotiricarã maca jĩcaarãre na pawa, aperãre na cajĩa recõañuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’To bairo na cáto bero jĩcaʉ carʉjayupʉ mai cʉ macʉ seeto cʉ camai majuʉ. To bairi na nipetirore na carero bero cʉ quenare cʉ cajoobajupʉ, ʉpaʉ macʉ ãmi ĩrã yʉ macʉre cʉ nʉcʉbʉgogarãma ĩi. ");
INSERT INTO tav_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","To bairi ti wejere cʉ cacote rotiricarã maca cʉ macʉrena cʉ cajooricʉre cʉ tʉjʉrã ocõo bairo caame ĩñuparã: “Anina ãmi caberopʉ ati wejere cʉ pacʉ yere cacʉgo ʉjapaʉ. Cʉ̃re mani jĩa rocacõato. To bairo ána tiere mani majuuna mani cʉgogarã.” ");
INSERT INTO tav_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","To bairo ĩrã cʉ ñe, cʉ cajĩa rocacõañuparã. Cʉ jĩa yaparo ti weje tʉjaropʉ cʉ rupaʉ ãnatore carocacõañuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—To bairo cʉ ya wejere cʉ cacote rotibatana to bairo rooro na cátajere tʉjʉʉ ¿dope bairo nare átacʉmi mʉja ĩ tʉgooñati? na caĩñupʉ Jesu. —Cʉ majuuna atí, cʉ ya wejere cʉ cacote rotiricarãre na cajĩa re roti peocõañupʉ. Na jĩa re rotiri bero aperã macare na cajooyupʉ ti weje ʉje wejere. ");
INSERT INTO tav_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Nope ĩrã Dio Wadariquepʉ tirʉmʉpʉ macana na caĩ ucariquere mʉja tʉgooña majiquẽeti ocõo bairi wamere? Ocõo bairo ĩ ucarique ã: Ʉ̃ta wiire wegarã jĩca ʉ̃taare cabeje rocacõañuparã, tia ñuuquẽe ĩrã. Tia na carocabatacarena cane cũñuparã aperã maca, atie ñuu majuucõa ĩrã. To bairi tierena wii pucua cãniparore cawe peo jʉgoyuparã, tia mena mani cacooñaata cariape anigaro ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mani Ʉpaʉ Dio cʉ cátaje ã. Tiare cʉ cane we peoro caroaro jã tʉjʉ wariñuu, ĩ ucarique ã, na caĩ buioyupʉ Jesu sacerdote majare. ");
INSERT INTO tav_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ti wame queti buio majiorica wamere Jesu cʉ cabuioro, cʉ̃re mani cabooquẽtierena ĩimi, ĩ punijinirã nemoona cʉ cañegabajuparã. To bairo ñegabana quena camaja macare uwibana to cõona janari cáaácoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cabero fariseo maja na mena macana jĩcaarãre Herode ya poa macana menare na cajooyuparã Jesu tʉpʉre. Camajiriori wame cʉ̃re mani caĩ jeniñarijere ricati cʉ caĩ yʉata, “Carooʉ ãmi, cabai buicʉcʉ ãmi Jesu,” ʉparãre cʉ mani ĩ wadajãgarã ĩrã, Jesure na cajeniña roti jooyuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","To bairi na cajooricarã Jesu tʉpʉ ejarã ocõo bairo cʉ caĩñuparã: —Dio yere cariapena cabuioʉ mʉ ã. Ĩtoquẽcʉna mʉ buionucu. “To bairona na yʉ caĩ buioro yʉ tutiborãma,” mʉ ĩ tʉgooñaquẽe. Camaja jĩcarore bairo na mʉ tʉjʉ. To bairi jã ĩ buioya: Roma macana ʉparã jãre carotirã niyeru jãre na cajeninucurijere nare jã cajooro, ¿cʉ rotibocʉti Dio? ¿Nare cawapayepe to ãti? ¿O nare cawapayequetipe to ãti? Jesure cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesu maca na caĩtorijere, rooro cʉ̃re na cátigarijere majiri ocõo bairo na caĩñupʉ: —¿Nope ĩrã roorije Jesu cʉ ĩ bui cʉparo ĩrã yʉre mʉja jeniñati? Niyeru cuire neajá. Yʉ tʉjʉpa. ");
INSERT INTO tav_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","To bairo cʉ caĩro niyeru cuire neatíri cʉ caiñooñuparã. Jesu ti cuire tʉjʉri: —¿Ñamʉ wame to tujati? ¿Ñamʉ cʉ cabaurije majuu to tujati? na caĩ jeniñañupʉ Jesu. To bairo cʉ caĩ jeniñaro: —Ʉpaʉ majuu, Roma macacʉ cʉ cabaurije ã. Cʉ wame tuja, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","To bairo na caĩro: —Baiyupa ʉpaʉ Roma macacʉre cʉ jooya cʉ ye cãnipere. Dio ye quenare mʉjaare cʉ cajenirijere cʉ jooya, na caĩñupʉ Jesu. To bairo na cʉ caĩ yʉro apirã caapi acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Cabero tunu saduceo maja na caĩrã Jesure cajeniñarã ejayuparã. “Cabai yajiricarã tunu catiquetigarãma,” caĩ buionucurã cãñuparã saduceo maja. To bairi Jesu tʉpʉ eja, ocõo bairo cʉ caĩñuparã: ");
INSERT INTO tav_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Camajare cabuei, ocõo bairi wame carotirijere caucayupi Moisé: “Jĩcaʉ nʉmocʉti capunaa mácʉna cʉ cabai yajiata cabai maca cʉ nʉmo cʉparo cʉ jʉgocʉ nʉmo cãnibatacore. Cabero co mena ãcʉ cʉ camacʉ cʉti jʉgoʉ, cabai yajiricʉ macʉ maca anibojagʉmi,” caĩ ucayupi Moisé, Jesure caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—To bairi siete cãnacʉ jĩcaʉ punaa cãñuparã. Cãni jʉgoʉ canʉmo cʉtibajupʉ. Punaa mácʉna cabai yajiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Punaa mácʉna cʉ cabai yajiro bero cʉ bai, cʉ bero macacʉ cõrena cawapearicore canʉmo cʉtibajupʉ. Cʉ quena to bairona punaa mácʉna cabai yajicoajupʉ. Cʉ bero macacʉ quenare to bairona cabaiyupe tunu. ");
INSERT INTO tav_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","To bairo jetona jĩcaʉ punaa siete cãnibatana co jĩcaorena nʉmo cʉtiba, punaa manana cabai yaji peticoajuparã. Na cabairo bero na nʉmo cãnibataco quena cabai yajicoajupo, co quena. ");
INSERT INTO tav_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na nipetiro jĩcaʉ punaa sietepʉna cõre canʉmo cʉtibajuparã. To bairi cabai yajiricarã tunu catirãpʉ ¿nii nʉmo maca co ãcoati? caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","To bairo na caĩrijere apii ocõo bairo na caĩñupʉ Jesu: —Mʉja tʉgooña mawijia. Dio Wadariquere mʉja api majiquẽe. Dio cʉ cáti majirije quenare mʉja majiquẽe. ");
INSERT INTO tav_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cabai yajiricarã tunu catirãpʉ canʉmoa cʉtiquẽna, camanapʉa cʉtiquẽna anigarãma. Dio tʉ macana ángel majare bairo cabairã anigarãma. ");
INSERT INTO tav_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ape wame mʉjaare yʉ buionemogʉ cabai yajiricarã na catunu catirijere. Moisé quena cʉ caucarique mʉja buericarã. Cañee mani yepapʉ jĩcaʉ yucʉ turo caʉ̃ro watoapʉ ocõo bairo caĩ wadayupʉ Dio Moisére: “Diona yʉ ã. Mʉ ñicʉ jãa Abraham, Isaá, Jacobo cãniñaricarã Ʉpaʉna yʉ ã,” caĩñupʉ Dio Moisére. ");
INSERT INTO tav_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","To bairo ĩi, Dio tʉpʉ catima mai ĩi, caĩñupʉ Jesu. —Dio cabai yajiricarã Ʉpaʉ aniquẽemi. Cacaticõa aninucurã Ʉpaʉ maca ãmi Dio. Tiere mʉja tʉgooña mawijia, na caĩñupʉ Jesu saduceo majare. ");
INSERT INTO tav_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cabero apeĩ judío majare cabuerã mena macacʉ Jesu tʉpʉ caejayupʉ. Jesu mena saduceo maja seeto na caame wadaro caapiricʉ cãñupʉ. To bairi Jesu caroaro nare cʉ cayʉ majirijere apiri ocõo bairo Jesure caĩ jeniñañupʉ cʉ quena: —Moisé cʉ carotirique ¿di wame maca cãni majuuri wame to ãti? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","To bairo cʉ caĩro ocõo bairo cʉ caĩñupʉ Jesu: —Ape wame rotirique netoro cãni majuurije ocõo bairo ĩrique ã: “Israel maja, apiya. Mani Ʉpaʉ Dio jĩcaʉna ãmi mani Ʉpaʉ. Apeĩ maami. ");
INSERT INTO tav_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","To bairi mani Ʉpaʉ Diore nʉcʉbʉgoya. Seeto cʉ maiña. Mʉja yeri mena, mʉja catʉgooñarije mena, mʉja catʉgooña ocabʉtirije mena, nipetiro mʉja catʉgooña majiro cõo, mʉja Ʉpaʉ Diore cʉ mai nʉcʉbʉgoya.” To cõona ã cãni majuuri wame. ");
INSERT INTO tav_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ti wame bero macá wame tiere bairobʉjana ã tie quena. Ocõo bairo ã: “Mʉja majuuna mʉja camairore bairona aperã quena na maiña.” Apeye tie netoro cãnie maa, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","To bairo cʉ caĩrijere apii judío majare cabuei ocõo bairo caĩñupʉ Jesure: —Cariapena mʉ ĩ. To bairona ã. Dio jĩcaʉna ãmi. Apeĩ cʉ netobʉjaro carotii mácʉmi. ");
INSERT INTO tav_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Diore mani camai nʉcʉbʉgorije, mani yeri mena, mani catʉgooñarije mena, mani catʉgooña ocabʉtirique mena mani camairije ape wame netoro cãni majuurije ã. To bairi mani majuuna mani camairore bairona aperãre mani camairije caroa ã. Waibʉcʉrã joe buje mʉgorique netoro cãni majuurije ã Diore mani camairije, aperãre mani camairije maca, Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu maca caroaro cʉ cayʉro tʉjʉʉ ocõo bairo cʉ caĩñupʉ: —Petoacã mʉre rʉja Ʉpaʉ Diore cariapena mʉ catʉgooña nʉcʉbʉgoparo. To bairo cʉ caĩro bero cʉ jeniña uwirã jĩcaʉ mácana Jesure caĩ jeniñanemoquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu Dio wiipʉ camajare na buioʉ ocõo bairo na caĩñupʉ: —¿Nope ĩrã judío majare cabuerã, “Cristo, Dio cʉ cajoʉ David pãramipʉ anigʉmi,” na ĩnucuti? na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","—David cʉ majuuna Espíritu Santo cʉ camajirije jʉgori ocõo bairo caĩ ucayupi: Dio ʉmʉrecoopʉ cãcʉ cʉ Macʉre yʉ Ʉpaʉre cʉ caĩñupʉ: “Ato yʉ mena ruiya yʉ tʉ maca, yʉ mena carotii anigʉ. Yʉ mena ruiri mʉ carotiro mʉre catʉjʉ tutirãre na yʉ regʉ,” caĩñupʉ Dio yʉ Ʉpaʉre, caĩ ucayupi David tirʉmʉpʉre. ");
INSERT INTO tav_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","To bairo ĩi, “Cristo yʉ Ʉpaʉ ãmi,” ĩi to bairo caĩ ucayupi David, Dio cʉ cajoopaʉ Cristore. To bairo, “Ʉpaʉ,” David cʉ caĩata ¿Dope bairo cʉ pãramipʉ cãcʉ maca Cristo cʉ anibocʉti? na caĩñupʉ Jesu. Ʉpaʉ David ãnacʉ netoro cãcʉ yʉ ã ĩi, to bairo caĩñupʉ Jesu. Capãarã camaja topʉ cãna nipetiro seeto cʉ caapi wariñuuñuparã nipetiro cʉ caĩ buiorijere. ");
INSERT INTO tav_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu camajare buioʉ ocõo bairo na caĩñupʉ: —Judío majare cabuerãre caroaro na tʉjʉ majiña. Jutii caroa cayoerije jaña teñaganucuma, aperã caroaro manire na tʉjʉ nʉcʉbʉgoato ĩrã. To bairi maca recomacapʉ na cáaáteñari paʉri camaja nare na cañuu roti nʉcʉbʉgopere booma. ");
INSERT INTO tav_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Neñapo buerica wiiripʉ aána ʉparã ye cumu pãiripʉ jeto ruigama. Boje rʉmʉ quenare ʉparãre bairo aperã jʉgoye jeto ʉgaganucuma. ");
INSERT INTO tav_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Cawapearicarã romiri cabopacoorã romiri apeye uniere na joorã pairo majuu wapa jeninucuma. To bairo átiri na cacʉgorije nipetirore jee weonucuma. To bairo cabopacoorã cawapearicarã romiri yere cajee pairã anibana quena Dio wiipʉ jãari yoaro Diore jeni nʉcʉbʉgotonucuma, camaja jãre na tʉjʉ nʉcʉbʉgoato ĩrã. Nana ãma aperã netoro Dio cʉ capopiyeyeparã, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu Dio wiipʉ Jerusalén macá wiipʉ ãcʉ camaja na caniyeru jãnucuri pata tʉ caruiyupʉ. Dio wii na caquenoope wapare na cajãri pata cãñupe. Camaja ti patapʉ na caniyeru jãaro catʉjʉcõa ruiyupʉ. Aperã pairo caniyeru cʉgorã ti patapʉre pairo cajãñuparã. ");
INSERT INTO tav_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","To bairo na cáti ani paʉna jĩcao cawapearico cabopacao caejayupo. Co quena pʉga cui niyeru cuiriacã cawapa maniacãre ti patapʉ cajãñupo. ");
INSERT INTO tav_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","To bairo co cáto tʉjʉʉ cʉ buerãre pijori ocõo bairo na caĩñupʉ Jesu: —Cariape mʉjaare yʉ ĩ. Atio cawapearico cabopacao maca Dio cʉ catʉjʉro aperã nipetiro na netoro joomo. ");
INSERT INTO tav_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Na maca pairo cacʉgorã aniri nare carʉjarijere jooma. Co maca, “Cabopacao yʉ ã,” ĩ tʉgooñaquẽcona nipetiro co cacʉgobatajeacãre joomo. Co caʉga catíboriqueacãre joo peocõamo, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu Dio wiipʉ cãnacʉ cʉ cabuti aáto jĩcaʉ cʉ cabuei ocõo bairo cʉ caĩñupʉ: —Jãre cabuei, tʉjʉya ati wiire caroa arʉri cãniere, ʉ̃ta rupaari mena caroaro na cawerica wiire. Ati wii caroa wiiro majuu anicõa, Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu maca ocõo bairo cʉ caĩñupʉ: —¿Ati wii na cawerica wiire tʉjʉrã mʉja áati? Ape rʉmʉpʉ atie mʉja catʉjʉrijere re peocõagarãma aperã. Jĩca ʉ̃taa mácana apea bui pejanucu baiquetigaro. Nipetiro recõagarãma, na caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cabero Jesu cʉ buerã mena Ʉ̃taʉ Olivo cawamecʉtii Dio wii canamuñaro cabauricʉ tʉpʉ cáaájuparã. Jesu topʉ cʉ caruiri paʉ Pedro, Jacobo, Juan, André aperã na caapiquẽtopʉ cʉ cajeniñañuparã Jesure: ");
INSERT INTO tav_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jãre buioya. ¿Noo cõopʉ mʉ caĩeje to bairoati? ¿Dope bairo majuu jã tʉjʉ majirãati to bairo baigaro mʉ caĩejere? cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","To bairo na caĩro ocõo bairo na caĩ buioyupʉ Jesu: —Aperã jã ĩtorema ĩrã caroaro tʉgooña majiña. ");
INSERT INTO tav_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Capãarã ĩtori, “Dio cʉ carotiro mena yʉ áa. Dio cʉ cajooricʉ majuu, Cristo yʉ ã,” caĩtorã anigarãma. To bairo na caĩtorijere apiʉjagarãma camaja capãarã. ");
INSERT INTO tav_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Na caame jĩarije quetire mʉja apigarã. Capee paʉri to bairo cabairijere mʉja queti apigarã. To bairo cabairijere apirã uwiqueticõaña. To bairona bai jʉgogaro ati ʉmʉrecoo capetiparo jʉgoye. Capetiparo rʉjagaro mai. ");
INSERT INTO tav_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jĩca maja ape maja mena ame quẽgarãma. To bairi jĩca yepa macana, ape yepa macana mena ame jĩagarãma. Capee paʉri yepa nanaagaro. Ape paʉri ñigo riarique quena anigaro. Atie nipetiro popiye tamʉorique bai jʉgogaro. To bairo to cabaibato quena ati ʉmʉrecoo capetiparo rʉjagaro mai. ");
INSERT INTO tav_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’To bairo cabairi paʉ yʉ ye quetire caapiteerã rooro mʉja átigarãma. Yʉre mʉja caapiʉjarije wapa ʉparã tʉpʉ jee aáti, na neñapo buenucuri wiiripʉre mʉja bapegarãma. To bairo na cáto ʉparãre yʉre mʉja caapi nʉcʉbʉgorijere nare mʉja buiogarã. To bairi mʉja majuu caroaro tʉgooña ocabʉtiya, rooro mʉjaare na cátigarije to cãnibato quena. ");
INSERT INTO tav_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ati ʉmʉrecoo capetiparo jʉgoye nipetiro macanare Dio camajare cʉ canetoo catiorije quetire cabuio bate teña peocõape ã. ");
INSERT INTO tav_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ʉparã tʉpʉ mʉjaare na cajee áato tʉgooñarique paiquẽnana aánaja. Mʉjaare na cajeniñarijere na mʉja caĩ yʉpere tʉgooñarique paiqueticõaña. Nare mʉja caĩ yʉpere mʉja majiogʉmi Dio. To bairi mʉja majuuna mʉja caĩpe aniquetigaro. Dio Espíritu Santo mʉjaare cʉ caĩ majiope macare mʉja ĩ yʉgarã. ");
INSERT INTO tav_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti paʉ cãno jĩcaʉ apeĩ cʉ bairena ʉparãre wadajãgʉmi, Jesucristore caapiʉjaʉ ãmi ĩi. To bairo átiri ʉparã cʉ̃re na cajĩa rocaro átigʉmi. Aperã na punaa majuurena ʉparãpʉre na wadajãgarãma, Jesure na caapiʉjarije wapa na jĩa recõaña ĩrã. Aperã na pacʉarena ʉparãpʉre na wadajãri jĩa re rotigarãma. Jesucristore caapiʉjarã ãma ĩrã to bairo jeto átigarãma ati ʉmʉrecoo capetiparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","To bairi camaja nipetiro yʉre caapi nʉcʉbʉgorãre tʉjʉ teegarãma. Yʉre caapi nʉcʉbʉgonucucõarã macare na netoogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tirʉmʉpʉ macacʉ Daniel cawamecʉcʉ ati ʉmʉrecoo capetiparo jʉgoye cabaipere ocõo bairo caĩ uca jʉgoyeyeyupi: “Carooʉ majuu Dio wiipʉna anigʉmi. Ti wiipʉ caroorije majuu átiri Dio wii macajere epe regʉmi.” (To bairo Jesu cʉ buerãre cʉ caĩ buiorique atie ucariquere buerã caroaro api majiña.) To bairo Dio wii to bairo roorije cabairo tʉjʉrã, popiyeyegʉmi Dio ĩrã, Judeapʉ cãna ʉ̃ta yucʉpʉ na ruti aáparo. ");
INSERT INTO tav_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Noa wii bui cãni arʉapʉ cãna uwaro atʉ rutiri wii pupeapʉ jãa áti na apeyere na jeequeticõato. ");
INSERT INTO tav_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aperã noo wejeripʉ paari maja quena na wiiripʉ na apeyere, na jutiire jeerã aána na tunu aáqueticõato. Cariapena ʉ̃ta yucʉpʉ na ruticoaparo. ");
INSERT INTO tav_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","To bairo cabairi paʉ ʉta pacoa romiri, aperã caũpurãacãre capʉjarã quena popiye majuu tamʉogarãma, atʉ ruti majiquetibana. ");
INSERT INTO tav_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Diore cʉ jeniya, mʉja carutiri rʉmʉ caocari rʉmʉ, cajoori rʉmʉ to aniqueticõato ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ti yʉtea cãno popiye majuu tamʉorique anigaro. Dio ati ʉmʉrecoore cʉ cátato berore to cõo majuu popiye tamʉoya maa. Caberopʉ quenare manigaro. ");
INSERT INTO tav_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","To bairo popiye catamʉori rʉmʉrire Dio cʉ cajanaoquẽpata, camaja nipetiro yaji peticoaborãma. Jĩcaʉ maca catiquetiboʉmi. To bairi Dio yarã cãniparãre cʉ cabejericarã na cacatiparore bairo to cõo ti rʉmʉri popiye tamʉorica rʉmʉrire jana rotigʉmi Dio yua. ");
INSERT INTO tav_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ti paʉ cãno, “Jĩpʉ ãmi Cristo, Dio cʉ cajooricʉ,” o “Jõpʉ ãñupʉ,” mʉjaare na caĩro na api nʉcʉbʉgoqueticõaña. ");
INSERT INTO tav_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Capãarã, “Dio cʉ cajooricʉ majuuna yʉ ã,” caĩto pairã anigarãma. Aperã, “Dio ye quetire cabuiorã jã ã,” caĩtorã quena capãarã anigarãma. Capee áti iñoogarãma, Dio yarã cʉ cacũricarã Diore na apiʉja janaato ĩrã, ¿jã macare na apiʉjabocʉti? ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","To bairo cabaipere caroaro mʉjaare yʉ buiotʉgawʉ mere. To bairi ti yʉtea cãno caroaro mʉja tʉjʉ majigarã, na caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","To bairo ĩ yaparo ocõo bairona na caĩnemoñupʉ Jesu: —To bairo popiye tamʉorica yʉtea bero muipu ʉmʉrecoo macacʉ naitĩacoagʉmi. Ñami macacʉ quena bujuquetigʉmi. ");
INSERT INTO tav_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ñocoa quena wẽgarãma. Ʉmʉrecoo macana quena nipetiro seeto wãregarãma. ");
INSERT INTO tav_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","To bairo cabairi paʉ yʉ, camaja tʉpʉ Dio cʉ cajooricʉ yʉ catutuarije mena ʉmʉrecoopʉ cãnacʉ yʉ rui atígʉ. Bujeri bʉrʉa watoapʉ Dio ye seeto caaji baterije mena yʉ carui ató yʉ tʉjʉ mʉgojogarãma camaja nipetiro. ");
INSERT INTO tav_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cabero Dio tʉ macana ángel majare na yʉ jee neo rotigʉ, yʉ cabejericarã jetore ati ʉmʉrecoo nipetiropʉ cãnare. ");
INSERT INTO tav_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Higuera cawamecʉtii cabairije tʉgooña majiña. Carʉpʉri bʉcʉanemo, cawama pũu wajoa cabairo tʉjʉrã, “Yucʉacãna cʉma anigaro bai,” mʉja ĩ maji. ");
INSERT INTO tav_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To bairona mʉjaare yʉ caĩ buiori wameri cabairo tʉjʉrã, “Yucʉacãna tunu atígʉmi Jesu,” mʉja ĩ tʉjʉ majigarã. ");
INSERT INTO tav_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cariape mʉjaare yʉ ĩ. Atie nipetiro mʉjaare yʉ caĩ buiori wamere bairona baigaro ati yʉtea Dio cʉ cawajoaparo jʉgoye macana na cayajiparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ʉmʉrecoo, yepa quena wajoagaro. Yʉ caĩ buiorije maca wajoaquetigaro. Yʉ caĩ buiorore bairona bainucucõagaro. ");
INSERT INTO tav_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ati ʉmʉrecoo capetipere, “Ti rʉmʉ cãno, ti paʉ majuu cãno petigaro,” ĩ majiña maa. Dio tʉ macana quena ĩ majiquẽema. Yʉ quena Dio Macʉ anibacʉ quena yʉ majiquẽe. Mani Pacʉ ʉmʉrecoo macacʉ jeto majimi to bairo cabaipere. ");
INSERT INTO tav_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Di rʉmʉ majuu yʉ catunu atípere mʉja majiquẽe mʉjaa. To bairi caroaro tʉgooña maja catiri yʉ caboorore bairo to cãnacã rʉmʉ áticõa aninucuña. ");
INSERT INTO tav_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ocõo bairo mʉjaare yʉ ĩ buio majiogʉ: Jĩcaʉ camajocʉ apero cayoaropʉ cáaáteñaʉ aátacʉ cʉ catunu ejarore bairona baigaro yʉ catunu atípe quena. Camajocʉ aperopʉ aágʉ jʉgoye cʉ ʉmʉa to cãnacãʉre na paariquere cũʉmi. Jĩcaʉre cʉ ya wii macajere caroaro cʉ cote rotiimi. Roti yaparo aperopʉ aácʉmi. ");
INSERT INTO tav_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cʉ cáaáto bero caroaro na cãni yuurore bairona baiya mʉja quena. Na quena, “To cõo majuu tunu atígʉmi mani Ʉpaʉ,” ĩ majiquẽnama. Canaiori paʉ, ñami recomaca, ãbocʉ cʉ cayopiri paʉ, o cabujuri paʉ bero tunu atíboʉmi. Mʉja quena nare bairona majiquetibana caroaro yʉre yuunucucõaña. ");
INSERT INTO tav_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Majiña mano yʉ cáatí paʉpʉre cacanirãre bairona mʉja aniborã to cãnacã rʉmʉ mʉja catʉgooña maja catíquẽpata. ");
INSERT INTO tav_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mʉjaare yʉ caĩrijere yʉ yarã nipetirãre to bairona mʉjaare yʉ ĩ. Caroaro coteya to cãnacã rʉmʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pʉga rʉmʉ carʉjayupe pan cawauarije manona na caʉgapa boje rʉmʉ. Ti rʉmʉ cãno sacerdote maja ʉparã judío majare cabuerã, ¿dope bairo áti ñeri Jesure mani jĩarãati? ĩrã, átitorique mena cʉ̃re na cañepere caquenoo jʉgoyeyeyuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","To bairo cʉ ñegabana quena ocõo bairo caame ĩñuparã: —Boje rʉmʉ cãno mani átiquẽna. Camaja capãarã boje rʉmʉ catʉjʉra ejarã cʉ mairã noo na cabooro manire awaja tutiborãma. To bairo mani cátiere rooye tuuborãma, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","“Cʉ̃re jã jĩagarã,” na caame ĩtoye Jesu maca Betaniapʉ Simón caajeri boabatacʉ ya wiipʉ cãñupʉ. Jesu cʉ caʉga ruiri paʉna cãromio alabastro cawamecʉti rʉ werica rʉ cajʉti ñuurije pairo cawapacʉtie cajañari rʉre cane ejayupo. Ti rʉre neatí, pã, Jesu rupoare capio peoyupo tiere. ");
INSERT INTO tav_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jĩcaarã topʉ cãna to bairo co cáto tʉjʉrã, “Rooro majuu áamo,” caĩ tʉgooñañuparã. Ĩ tʉgooñari ocõo bairo caame ĩñuparã: —¿Nope ĩo cawapa pacarije to cãnibato quena joco majuuna co áti reti? ");
INSERT INTO tav_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aperãre co cajoata jĩca cʉma paarique wapa cõo wapa jooboricarãma. To cõo wapa jee, cabopacoorãre jooboricomo, caĩñuparã. To bairo ame ĩri co catutiyuparã. Jesu maca ocõo bairo na caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","—Co cátigari wame co áparo. ¿Nope ĩrã cõre mʉja patowãcooti? Caroaro yʉre áamo. ");
INSERT INTO tav_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cabopacoorã mʉja watoapʉ anicõa aninucugarãma. Noo mʉja caboori paʉ nare mʉja átinemo maji. Yʉ maca mʉja mena yoaro yʉ aniquetigʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Caroaro yʉre co cáti majiri wame áamo. To bairi atie caroa jʉti ñuurijere yʉre pio peomo, yʉ cabai yajiro bero yʉ rupaʉre na cayaaro na capio peoparore bairo iñoo áamo. ");
INSERT INTO tav_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cariape mʉjaare yʉ ĩ. Ati yepa nipetiro yʉ ye quetire cabuio teñarã yʉre co cátaje quenare buiogarãma. Yʉre co cátajere majiritiqueti nucugarãma. ");
INSERT INTO tav_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Cabero Judas Iscariote, Jesu buerã doce cãnacãʉ mena cãnacʉ cáaájupʉ sacerdote maja ʉparã tʉpʉ, Jesure na cañepere na wadajãʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","To bairo cʉ caĩrijere api wariñuuri, “Niyeru mʉre jã wapayegarã,” cʉ caĩñuparã. To bairo na caĩro apii Jesure dope bairo átiri cʉ na cañepere caquenooñupʉ Judas yua. ");
INSERT INTO tav_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cabero pascua boje rʉmʉ judío maja pan cawauarije caajuya manie na caʉga jʉgori rʉmʉ cãñupe. Oveja cawimaʉre boje rʉmʉ na caʉgapaʉre na cajĩari paʉ cãno Jesu buerã ocõo bairo cʉ caĩñuparã: —¿Noopʉ pascua boje rʉmʉ mani caʉgapa paʉre jã quenoorãati? cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","To bairo na caĩro apii cʉ buerã pʉgarãre, ocõo bairo na caĩ buioyupʉ: —Aánaja Jerusalẽpʉ. Topʉ ejarã jĩcaʉ cʉ mʉja boca tʉjʉgarã caoco jotʉ tu peo aácʉre. ");
INSERT INTO tav_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cʉ mena aáti cʉ cajãari wiipʉ mʉja ejagarã. Topʉ eja, ti wii ʉpaʉre ocõo bairo cʉ ĩña: “Manire cabuei ocõo bairo mʉ ĩ joomi: ¿Noopʉ to ãti yʉ buerã mena pascua boje rʉmʉ yʉ caʉgapa arʉa? mʉ ĩ joomi,” cʉ ĩ buioya. ");
INSERT INTO tav_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","To bairo mʉja caĩro cabui macá arʉa capairi arʉa, quenoo yaparorica arʉare mʉja iñoogʉmi. Topʉ mani caʉgapere quenoo yuuya, caĩ buioyupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","To bairo cʉ caĩro apirã Jesu buerã pʉgarã cáaácoajuparã Jerusalén macapʉ. Ti macapʉ eja, Jesu cʉ caĩricarore bairona cabʉga ejayuparã. To bairi ti arʉapʉ pascua cãno na caʉgapere caquenoo yuuyuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Cabero canaiori paʉ caejaro Jesu cʉ buerã doce cãnacãʉ mena eja, caʉga ruiyuparã. Topʉ na mena ʉga ruiina ocõo bairo na caĩñupʉ Jesu: —Cariapena mʉjaare yʉ ĩ. Jĩcaʉ mʉja mena macacʉ yʉ mena caʉgaʉ yʉre catʉjʉteerãre yʉre wadajãgʉmi, yʉre na ñeato ĩi. ");
INSERT INTO tav_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","To bairo cʉ caĩro apirã seeto catʉgooñarique paiyuparã. To bairo tʉgooñarique paibana: —¿Yʉna yʉ baiquetibacʉati? Jesure cʉ caĩ jeniña peticõañuparã, na cãno cõona. ");
INSERT INTO tav_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","To bairo na caĩro ocõo bairo na caĩ yʉyupʉ Jesu maca: —Jĩcaʉ mʉja mena macacʉ yʉ mena jĩca bapapʉna cayoje ʉgaʉna ãmi, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Yʉ cabaipe tirʉmʉpʉ macana Dio ye quetire cabuiorã na caĩ ucaricarore bairona yʉre baigaro. To bairo yʉ cabaipe to cãnibato quena rooro majuu baigaro yʉ catʉjʉ teerãre yʉre cawadajãʉ macare. Ati yepapʉ cʉ cabuiaquẽpata cʉ̃re ñuucõaboricaro, na caĩñupʉ Jesu cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ĩ yaparo Jesu cʉ buerã mena ʉgaʉ, pãre ne, cʉ Pacʉ Diore cajeni nʉcʉbʉgoyupʉ. Jeni nʉcʉbʉgo yaparo tiare pe mʉto, nare joo, ocõo bairo na caĩñupʉ: —Ʉgaya. Atie yʉ rupaʉ ã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cabero etirica bapare ne, Diore cajeni nʉcʉbʉgoyupʉ tunu. Jeni nʉcʉbʉgo yaparo cʉ buerãre na catĩañupʉ. Nipetiro cʉ buerã ti bapare caeti peticõañuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nare tĩaʉna ocõo bairo na caĩñupʉ Jesu: —Atie yʉ rií ã. Yʉ rií re yajigʉ, camaja capãarã caroorije na cátiere wapayebojaʉ. To bairo yʉ carií re yaji wapayebojaro camaja caroorije na cátajere majiriobojagʉmi Dio cʉ̃re cajeni nʉcʉbʉgorãre. To bairo mʉjaare yʉ caĩ cũri wamere tʉgooñari etiya. ");
INSERT INTO tav_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cariapena mʉjaare yʉ ĩ. Atie ʉje ocore yucʉacã mani caetirore bairo yʉ etinemoquetigʉ. Cabero yʉ Pacʉ caʉpaʉ yʉre cʉ cacũro beropʉ mʉja mena ape ni yʉ etinemogʉ tunu, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesu cʉ buerã mena na caʉgaricaro bero Diore ĩ baja yaparo ti wii cãnana cabuticoajuparã, Olivo na caĩricʉ ʉ̃taʉpʉ aána. ");
INSERT INTO tav_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Topʉ na cáaáto ocõo bairo na caĩñupʉ Jesu cʉ buerãre: —Mʉja nipetiro ati ñami uwibana yʉre mʉja ruti weo peticoagarã. To bairo mʉja cabaipere Dio ye queti ucarica pũuropʉ caĩ ucaricarore bairona baigaro. Ocõo bairo ĩ ucarique ã: “Oveja ʉpaʉre cʉ jĩagarãma. Cʉ na cajĩaro oveja aá bategarãma,” ĩ ucarique ã. To bairo na cáaá baterore bairona mʉja quena yʉre mʉja ruti aáweogarã, uwibana. ");
INSERT INTO tav_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na cajĩa rocaricʉ anibacʉ quena yʉ tunu catigʉ. Tunu catiri bero Galilea yepapʉ mʉja jʉgoye yʉ aágʉ, mʉjaare yuʉ aácʉ, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","To bairo cʉ caĩro apii Pedro cʉ caĩñupʉ: —Aperã nipetiro uwibana mʉre na caruti aáweorije to cãnibato quena yʉ maca yʉ aáquetigʉ, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","To bairo cʉ caĩro: —Cariapena mʉre yʉ ĩ. Yucʉ ñamina cabujuri paʉ jʉgoye ãbocʉ pʉgani cʉ cawadaparo jʉgoye itiani, “Cʉ mena macacʉ mee yʉ ã,” yʉre mʉ ĩtogʉ, caĩñupʉ Jesu Pedrore. ");
INSERT INTO tav_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","To bairo cʉ caĩro apibacʉ quena Pedro caĩnemoñupʉ tunu: —Mʉ mena yʉre na cajĩa rocarije to cãnibato quena, “Cʉ mena macacʉ mee yʉ ã,” yʉ ĩqueti majuucõagʉ yʉa, caĩñupʉ Pedro. Aperã cʉ mena macana quena cʉ̃re bairo jeto caĩ peticõañuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Olivo cawame cʉtiipʉ aána Getsemaní cawamecʉtopʉ caejayuparã. Topʉ ejaʉ Jesu cʉ buerãre ocõo bairo caĩñupʉ: —Atona mʉja ruiwa, Diore yʉ cajeni nʉcʉbʉgoʉ aátoye, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Topʉ Diore jeni nʉcʉbʉgoʉ aácʉ Pedrore, Jacobore, Juãre na capi aájupʉ. Topʉ aá, seeto majuu catʉgooñarique pai yapapua jʉgoyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tʉgooñarique pai netobacʉ ocõo bairo na caĩñupʉ: —Yʉ bai yajibo, seeto majuu tʉgooñarique pai netori yapapuabacʉ. Atona mʉja yuu ruiwa caniquẽnana, na caĩbajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","To bairo ĩ yaparo na jʉgoyebʉjaacã aá, yepapʉ mubia roca cumu áti, ocõo bairo caĩ jeniñupʉ Diore: —Caacʉ, mʉ cabooata, yʉ capopiye tamʉope to baiqueticõato, caĩ jeniñupʉ Diore. ");
INSERT INTO tav_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Caacʉ, nipetirijere mʉ áti maji. To bairi mʉ cabooata rooro yʉ catamʉope to baiqueticõato. Yʉ maca yʉ capopiye tamʉope yʉ cabooquẽtie to cãnibato quena mʉ caboorore bairo maca to baiato, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","To bairo Diore ĩ jeni yaparo cʉ buerã tʉpʉ tunu aá, nare catʉjʉyupʉ cacani cuñarãre. Cacani cuñarãre na tʉjʉ, ocõo bairo na caĩñupʉ Pedrore: —Simón, ¿canirã mʉja áati? ¿Petoacã caniquẽnana mʉja cote ocabʉtiquẽeti? ");
INSERT INTO tav_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Caniquẽnana cotecõaña mʉjaa. Diore cʉ jeniya, Sataná cʉ caboorije macare jã áti wadajãremi ĩrã. Mʉja yeripʉre yʉre mʉja cáaáweogaquẽtie to cãnibato quena mʉja rupaʉri macare mʉja ocabʉtiquẽe, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","To bairo ĩ yaparo cʉ Pacʉre cʉ cajenirica paʉpʉna aáti to bairona cʉ caĩ jeniñupʉ tunu. ");
INSERT INTO tav_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jeni yaparo cʉ buerã tʉ maca aáti cacanirãrena catʉjʉyupʉ tunu. Seeto majuu nare cawʉgoa ejayupe. To bairi dope bairo cʉ̃re caĩ yʉ majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","To bairo bai yaparo cʉ Pacʉre Jesu cajeni tʉjayupʉ to bairo cʉ caĩricarore bairona tunu. Jeni yaparo tunu atí, cʉ buerãre ocõo bairo na caĩñupʉ: —¿Canirã mʉja áati mai? To cõona caniña. Mere yopiya. Mere ejacoapa yʉre na cañepa paʉ. Mere ejatʉgami yʉre catʉjʉ teerãre cañe rotiricʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Wamʉnʉcaña! ¡Jitá! Mere ejatʉgami yʉ mena cãnibatacʉna caroorãre yʉre cawadajãricʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","To bairo Jesu cʉ buerãre cʉ cawada ani paʉna na mena macacʉ cãnibatacʉ Judas Iscariote caejayupʉ. Cʉ mena caejayuparã camaja capãarã jarerica pãiri, yucʉri cacʉgorã. Sacerdote maja ʉparã, judío majare cabuerã, aperã cabʉcʉrã carotirã na cajooricarã cãñuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na caejaparo jʉgoye Judas maca na caĩ buio jʉgoyeyeyupʉ, Jesure na tʉjʉ majiato ĩi. —Jesu cʉ cãni paʉpʉ ejaʉ cʉ yʉ pabario jeniñagʉ. To bairo cʉ yʉ cáto tʉjʉrã cʉ mʉja ñegarã. Cʉ ñe, caroaro cʉ jia, cʉ̃re mʉja ne aágarã, na caĩ jʉgoyeyeyupʉ Judas. ");
INSERT INTO tav_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","To bairi Judas Jesu tʉpʉ ejaʉ cʉ caĩ jʉgoyeyericarore bairona Jesu tʉpʉ atí, caroaro cʉ pabariori: —¡Mʉ anibapari, Ʉpaʉ! Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","To bairo Judas cʉ cáto tʉjʉrã to cõona cʉ cañecoajuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cʉ̃re na cañeri paʉ jĩcaʉ Jesu mena macacʉ topʉ catʉjʉnucuricʉ cʉ jarerica pãire tʉ̃ga we neri sacerdote maja ʉpaʉ paabojari majocʉre cʉ amoorore capa ta rocacõañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","To bairo cʉ cáto bero Jesu na caĩñupʉ cʉ̃re cañerãre: —¿Jee rutiri majocʉre cañerã anáre bairo jarerica pãiri, yucʉri mena yʉre mʉja ñerã atíti? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","—To cãnacã rʉmʉ Dio wiipʉ Dio ye quetire buionucuri mʉja watoapʉ yʉ cãninucuwʉ. To bairo yʉ cãnibato quena yʉre mʉja cañequẽpʉ. Yucʉacã Dio ye queti ucarica pũuropʉ tirʉmʉpʉ macana na caĩ ucaricarore bairona yʉre mʉja áa. ");
INSERT INTO tav_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesure na cañero tʉjʉrã cʉ buerã cʉ caruti weo peticoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesure na cañe aáto jĩcaʉ cawamaʉ cʉ cacaniri jutiro mena dʉre turi caʉja aájupʉ. To bairo cʉ cabairo cʉ quenare cañeñuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Cʉ̃re ñebana cʉ cacaniri jutirore cʉ cadʉre tubatarore cañe woo rocacõañuparã. To bairi jutiro mácʉna caatʉ ruticoajupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesure cʉ ñe aá, sacerdote maja ʉpaʉ tʉpʉ cʉ cane aájuparã. Topʉ nipetiro sacerdote maja ʉparã, judío majare carotirã cabʉcʉrã, judío majare cabuerã quena caneñapo yuuyuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro maca Jesu bero cayoabʉjaroacãpʉ tʉjʉ ʉja nutua, sacerdote maja ʉpaʉ majuu ya wii jope tʉ macá yepapʉ caejayupʉ. Topʉ polisía maja mena ejanumu, capero jumacõa ruiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nipetiro sacerdote maja ʉparã, judío majare carotirã nipetiro, “¿Dope bairo átiri Jesure mani wadajãrãati?” caame ĩñuparã, Jesure na cajĩa rotipere. To bairo átigabana quena, “Ocõo bairo cʉ cátaje wapa cʉ capopiyeyepe ã,” caĩri wamere cabʉga majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Capãarã cʉ̃re caĩ wadajãrã caĩtoyuparã. To bairo ĩbana quena cariape jĩcaro mena caĩrã camañuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aperã wamʉnʉcari jocarãna ocõo bairo caĩtoyuparã: ");
INSERT INTO tav_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ocõo bairo cʉ caĩrijere jã apiwʉ: “Ati wii, Dio wii capairi wiire camaja na cáta wiire yʉ rocagʉ. Itia rʉmʉ bero ape wii camaja na cátiqueti wii macare yʉ áti wajoagʉ,” caĩwĩ, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","To bairo na caĩrije quenare jĩcaro mena caĩ maji petiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","To bairo na caĩrijere apii sacerdote maja ʉpaʉ majuu na watoapʉ cãnacʉ wamʉnʉcari Jesure ocõo bairo caĩ jeniñañupʉ: —¿To bairo mʉre na caĩrijere mʉ yʉgaquẽeti? ¿Dope bairo mʉre ĩrã na ĩti? ");
INSERT INTO tav_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesu maca cayʉquẽjupʉ to bairo cʉ caĩrijere. To bairo cʉ cayʉquẽto tʉjʉʉ sacerdote maja ʉpaʉ cajeniñanemoñupʉ tunu: —Mʉna tirʉmʉpʉ macana, “Atígʉmi jĩcaʉ Cristo na caĩi, Dio cʉ cajoʉ,” na caĩricʉ, ¿Dio caroaʉ majuu Macʉna mʉ ãti? cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","To bairo cʉ caĩro: —Cʉna yʉ ã, cʉ caĩñupʉ Jesu. —Dio cʉ cajooricʉ aniri caberopʉ cʉ tʉna ruiri cʉ mena carotii yʉ anigʉ. Ati yepapʉ rui acʉ́ bujeri bʉrʉari watoapʉ yʉ carui ató yʉre mʉja tʉjʉgarã, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","To bairo cʉ caĩro apii sacerdote maja ʉpaʉ majuu, yʉ capunijinirijere na tʉjʉ majiato ĩi cʉ jutiire catʉ̃ga woo reyupʉ. Woo re yaparo: —Nope ĩrã caroorije cʉ cáti buicʉtiere aperã cabuioparãre na mani jeniñanemoquẽna. ");
INSERT INTO tav_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Rooro Diore cʉ caĩrijere mʉja apiwʉ mere. ¿Dope bairo mʉja tʉgooñati mʉjaa? caĩñupʉ. To bairo cʉ caĩro topʉ cãna nipetiro: —¡Cʉ̃re cajĩape ã! caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","To bairo ĩri jĩcaarã to catʉjʉnucurã cʉ caʉco eo bate tuyuparã Jesure yua. Aperã jutiro ajero mena cʉ capere jia biperi, cʉ bape: —¿Ni maca mʉre cʉ baperi? cʉ caĩ epeyuparã. Polisía maja quena Jesu riyare capayuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Jesure na cañe jãaro bero Pedro maca tii wii jope tʉ macá yepapʉ capero juma ruiyupʉ. To bairo cʉ cabairi paʉ jĩcao cãromio sacerdote maja ʉpaʉre capaabojao Pedro tʉpʉ caejayupo. Cʉ tʉpʉ ejari ocõo bairo cʉ caĩñupo: —Mʉ quena Jesu Nasaré macacʉ mena cáaáteñaepaʉna mʉ ãcʉ, cʉ caĩñupo. ");
INSERT INTO tav_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro maca to bairo co caĩro ocõo bairo co caĩtoyupʉ: —¡Cʉ mena macacʉ mee yʉ ã! Yʉ majiquẽe to bairo mʉ caĩrijere. To bairo ĩ yaparo wiire na cajani jãa amojorerica janiro jopepʉ caeja nʉcañupʉ. Topʉ cʉ catʉjʉnucurona ãbocʉ cawadayupʉ. ");
INSERT INTO tav_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sacerdote maja ʉpaʉre capaabojao apeo tunu cʉ tʉjʉo topʉ cãnare: —Ani quena na mena macacʉna ãmi, caĩñupo. ");
INSERT INTO tav_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","To bairo co caĩro apii co quenare caĩtoyupʉ Pedro tunu. Caberoacãna topʉ cãna Pedrore ocõo bairo caĩñuparã: —Jocarã mee jã ĩ. Mʉ quena na mena macacʉna mʉ ã. Mʉ quena Galilea macacʉ mʉ ã, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","To bairo na caĩro apii na caĩtonemoñupʉ tunu: —¡Jĩ mʉja caĩire yʉ majiqueti majuucõa! ¡Cariape mee yʉ caĩata Dio yʉre cʉ popiyeyeato! ");
INSERT INTO tav_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","To bairo cʉ caĩrona ãbocʉ cawadayupʉ tunu. To cõona Pedro Jesu cʉ caĩriquere catʉgooña bʉgayupʉ. “Ãbocʉ pʉgani cʉ cawadaparo jʉgoye itiani, ‘Jesure cʉ yʉ majiquẽe,’ na mʉ ĩtogʉ,” cʉ caĩrique catʉgooña bʉgayupʉ. Tiere tʉgooñari, seeto caotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cabujuri paʉ sacerdote maja ʉparã, aperã cabʉcʉrã carotirã, aperã judío majare cabuerã mena caneñapoyuparã. Neñapo, jĩcaro mena tʉgooñari romano maja ʉparãre Jesure nare na cajĩa rotipere cawadapeniñuparã. Wadapeni yaparo Jesure jiari Pilato tʉpʉ cʉ cane aájuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesure tʉjʉʉ cʉ caĩ jeniñañupʉ: —¿Mʉna mʉ ãti judío maja Ʉpaʉ? cʉ caĩñupʉ. —Mʉ caĩrore bairona yʉ ã, cʉ caĩ yʉyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdote maja ʉparã maca Pilatore capee cʉ cawadajãñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","To bairo na caĩrijere apii Pilato Jesure caĩ jeniñanemoñupʉ tunu: —¿To cõo capee majuu mʉre na cawadajãbato quena mʉ yʉgaquẽeti? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","To bairo Pilato cʉ caĩbato quena, “Jocarã yʉre ĩma,” cʉ caĩ yʉquẽjupʉ Jesu. To bairo cʉ cayʉquẽto tʉjʉʉ Pilato catʉjʉ acʉayupʉ. Dope bairo caĩ tʉgooña majiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","To cãnacã cʉma pascua boje rʉmʉ cãno Pilato presopʉ cãcʉre nii camaja na cabuu rotiire cabuunucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jesure to bairo na cáti yʉteare Barrabá cawamecʉcʉ ʉparãre caregarã mena macacʉ camajare cajĩaricʉ aperã camajare cajĩaricarã mena caruiyupʉ preso wiipʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Camaja maca Pilato tʉpʉ aá, “Boje rʉmʉ cãno mʉ cátinucurore bairona ája,” cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","To bairo na caĩro Pilato na caĩñupʉ: —¿Judío maja Ʉpaʉre yʉ cabuuro mʉja booti? caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sacerdote maja ʉparã Jesure cʉ tʉjʉteerã cʉ ñeñupa, caĩ majiñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sacerdote maja ʉparã maca, “Barrabá macare cʉ buuya,” seeto majuu camajare caĩ rotiyuparã Pilato macare. ");
INSERT INTO tav_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","To bairo na caĩro apii Pilato na caĩ jeniñañupʉ: —Judío maja Ʉpaʉ mʉja caĩi macare ¿dope bairo yʉ cáto mʉja booti? caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","To bairo cʉ caĩro camaja nipetiro ocõo bairo caĩ awajayuparã: —¡Yucʉ tẽorica pãipʉ cʉ̃re na papua jĩato! caĩ awajayuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato maca: —¿Nope ĩi ani caroorije cátiquetacʉrena cʉ yʉ papua jĩa rotibocʉti? caĩbajupʉ. To bairo cʉ caĩbato quena, camaja maca caĩ awajanemoñuparã tunu: —¡Yucʉ tẽorica pãipʉ cʉ̃re na papua jĩacõato! caĩ awajanemoñuparã tunu. ");
INSERT INTO tav_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","To bairo na caĩ awajarijere apii Pilato maca, camaja caroaro yʉre na ĩato ĩi, Barrabá macare cabuu rotiyupʉ. To bairo ĩ yaparo Jesu macare polisía majare na bape roti, yucʉ tẽorica pãipʉ capapu jĩa rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","To cõona ʉpaʉ Pilato ya wii macá yepa carecomaca cãni yepapʉ cʉ̃re cane aájuparã. Topʉ cʉ ne ejari polisía maja nipetiri poari macanare capi neoñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Topʉ Jesure cʉ ne ejari ʉpaʉ cʉ cajañari jutiiro unore cʉ cajã epeyuparã cajũari jutirore. To bairo átiri pota beto mena cʉ rʉpoare capeoyuparã, “Ʉpaʉ cʉ capejari beto unore pejaya,” ĩrã. ");
INSERT INTO tav_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","To bairo cʉ áti yaparori cʉ caĩ epeyuparã: —¡Judío maja Ʉpaʉ! ¡Caroaro wariñuuña! caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","To bairo ĩrãna yucʉ mena cʉ rʉpoare capanucuñuparã. Cʉ̃re ʉco eo bate turi, cʉ tʉ ejacumuri cʉ caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","To bairo cʉ̃re ĩ epe yaparo cajũari jutiro na cajãricarore tu weri cʉ jutiro majuu macare cajãñuparã tunu. To bairo áti yaparo yucʉ tẽorica pãipʉ cʉ papua jĩarã aána cʉ canecoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesure jĩarã aána na cane aáti paʉ jĩcaʉ Sirene cawamecʉti maca macacʉ, maca tʉjaropʉ cáaáteñaʉ ejaricʉre cabocayuparã. Alejandro, Rufo cawamecʉna pacʉ cãñupʉ. Topʉ cʉ̃re bocarãna cʉ ñeri, yucʉ tẽorica pãi Jesure na capapuapa pãire cʉ capʉja rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","To bairi Jesure Gólgota cawamecʉti buuropʉ cʉ cane aájuparã. Gólgota caĩri wame “rʉpoa õwa coro buuro” ĩgaro ĩ. ");
INSERT INTO tav_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Topʉ Jesure cʉ ne ejari ʉje oco capiyarije mena na caajuriquere cʉ catĩañuparã. Jesu maca tiere caetigaquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","To bairo átiri bero yucʉ tẽorica pãipʉ cʉ capapua jĩañuparã. Polisía maja cʉ ye jutire ĩ bʉga eperique mena caricawoyuparã, ¿ñe unie majuure jã bʉgarãati? ĩrã, to bairo cájuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yucʉ bui muipu cʉ cãni paʉ las nueve cãno majuu Jesure yucʉ tẽorica pãipʉ cʉ capapuayuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesu ye wapa caĩri wamere ocõo bairo cauca tuyuparã: “Ani judío maja Ʉpaʉ ãmi.” ");
INSERT INTO tav_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aperã pʉgarã cajee ruti pairã quenare Jesu mena yucʉ tẽorica pãiripʉ capapua jĩañuparã. Jĩcaʉre cariape nʉgoa maca, apeĩre cacõ nʉgoa maca canʉcoñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","To bairo na cátie Dio ye queti ucarica pũuropʉ na caucaricarore bairona cariape cabaiyupe. Ocõo bairo ucarique cãñupe: “ ‘Cʉ quena caroorã mena macacʉ ãmi,’ ĩ tʉgooñagarãma.” ");
INSERT INTO tav_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Camaja Jesure na capapua nʉcoricaropʉ caneto aánucurã cʉ ñu puari ocõo bairo cʉ caĩ epeyuparã: —Jocʉna caĩricʉ mʉ ã. “Dio ya wiire yʉ rocagʉ. Rocabacʉ quena itia rʉmʉ bero yʉ wajoagʉ ape wii yʉ camajirije mena.” ");
INSERT INTO tav_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jocʉ majuuna mʉ ĩñupa. Mʉ majuuna netooña. Mʉ cáti majirije mena yucʉ tẽorica pãipʉ na capapuaricʉ cãnacʉ rui ajá, cʉ caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sacerdote maja ʉparã, judío majare cabuerã quena to bairona cʉ caĩ epeyuparã: —Aperãre na canetooricʉ anibacʉ quena cʉ majuuna netoo majiquẽemi. ");
INSERT INTO tav_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel maja Ʉpaʉ, Dio cʉ cajooricʉ cʉ cãmata yucʉ tẽorica pãipʉ na capapuaricʉ cãnacʉ cʉ majuuna cʉ ruiato. To bairo cʉ cabairo tʉjʉrã cariapena cʉ̃re mani api nʉcʉbʉgogarã, caĩ epeyuparã. Cajee rutiricarã cʉ mena yucʉ tẽorica pãiripʉ na canʉcoricarã quena to bairona rooro cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesure na capa puaricaro bero pajaribota caejaro ati yepa nipetiropʉ canaitĩacoajupe. Itia hora majuu muipu cabujuquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To bairi las tres cãni paʉ majuu muipu yucʉ bui cʉ cãnibopa paʉna ocõo bairo capi awajayupʉ Jesu cʉ ye mena: —Eloi, Eloi, ¿Rama sabactani? To bairo ĩi ocõo bairo ĩi caĩñupʉ: “Dio, Dio, ¿nope ĩi yʉre mʉ aáweori?” ");
INSERT INTO tav_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aperã jĩcaarã topʉ cãna to bairo cʉ caĩro apirã ocõo bairo caĩñuparã: —¡Jã! Apiya cʉ caĩrijere. Elías tirʉmʉpʉ macacʉ Dio ye quetire buiori majocʉ cãniñaricʉre pii ĩcʉmi, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","To bairi jĩcaʉ to catʉjʉnucuʉ atʉ aá, bujare bairo cãni bʉrʉa mena ʉje ocopʉ weyoo, yucʉpʉ tupua átiri cʉ cañu mʉgo jooyupʉ, cʉ etiato ĩi. To bairo átiri ocõo bairo caĩñupʉ: —Mani tʉjʉto mai. Elías cʉ ne ruioʉ acʉ́ atígʉmi, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","To bairo cʉ caĩri paʉna Jesu maca seeto awajaʉna, yeri jinijã tʉja, cabai yajicoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cʉ cabai yajiri paʉna Dio wii pupea macá arʉare na cayo matarica ajero juti ajero to majuuna cawoo atʉ aájupe carecomaca mena. Cabui maca woo atʉ rui atí, cayapapʉ cawoo ejooyupe. ");
INSERT INTO tav_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Roma maja polisía maja ʉpaʉ Jesu ẽoro catʉjʉnucuricʉ Jesu cʉ cayeri jinijã tʉjaro tʉjʉʉ ocõo bairo caĩñupʉ: —Cariapena ani Dio Macʉ majuuna ãñupi. ");
INSERT INTO tav_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jĩcaarã romiri cayoabʉjaroacãpʉ catʉjʉjo tʉjʉnucuñuparã na quena. Na mena cãñuparã María Magdalena, apeo María pʉgarã Jacobo, José jãa paco, to bairi Salomé cãñuparã. ");
INSERT INTO tav_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na romiri Jesu Galileapʉ cʉ cãno cʉ̃re cátinemonucurica romiri cãñuparã. Aperã capãarã romiri Jerusalẽpʉ Jesu mena caejaricarã cãñuparã na quena. ");
INSERT INTO tav_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Judío maja na yerijãrica rʉmʉ jʉgoye macá rʉmʉ cãñupe. To bairi yerijãrica rʉmʉ na caʉgapere na caquenoo yuuri paʉ, canaiori paʉ cãno majuu caejayupʉ José Arimatea cawamecʉti maca macacʉ. Cʉ quena cabʉcʉrã rotiri maja mena macacʉ cãñupʉ. Cristore cabooquẽna mena macacʉ anibacʉ quena jĩcaʉna Dio cʉ cajoʉ Ʉpaʉ cʉ caejapere cayuʉ cãñupʉ. To bairi tʉgooña ocabʉtiri Pilato tʉpʉ aá, Jesu rupaʉ ãnatore ne ruiori cʉ yaa rocagʉ cʉ cajeniñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesu ya rupaʉre José cʉ cajeniro apii Pilato maca ¿mere cʉ riacoabauyupari? ĩ majigʉ romano yaʉ polisía maja ʉpaʉre cʉ pijori cʉ cajeniñañupʉ: —¿Cariapena cʉ bai yajicoati, mere? cʉ caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Mere, bai yajicoami,” polisía maja ʉpaʉ cʉ caĩro apiri: —Jesu rupaʉ ãnatore Josére cʉ jooya, cʉ caĩñupʉ Pilato polisía maja ʉpaʉre. ");
INSERT INTO tav_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","To bairo cʉ caĩro José Jesu rupaʉ ãnatore ne ruio, jutiiro ajero cʉ cawapayerica ajero, cabotiri ajero mena cʉ caumañupʉ. To bairo átiri jĩca toti ʉ̃ta toti na cawerica totipʉ camaja cayaaya mani totipʉre cʉ cañujo rocayupʉ Jesu rupaʉre. Áti yaparo ti totire ʉ̃ta cuiro mena catu bia cũcõañupʉ. ");
INSERT INTO tav_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, apeo María, José, Jacobo na pʉgarã paco Jesure na cayaaro catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado judío maja na cayerijãri rʉmʉ capetiro María Magdalena, María Jacobo paco, apeo Salomé cajʉti ñuurijere cawapayeyuparã. Jesu rupaʉ ãnatore pio tugarã cabaibajuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","To bairi ape semana cãni jʉgori rʉmʉ cabujuri paʉacã majuu cãno muipu cʉ cawamʉ atí paʉna Jesure na cayaarica ope tʉpʉ cáaájuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Topʉ aána: —¿Ñamʉ maca ʉ̃ta cuirore manire cʉ ne woobojaʉati? caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Topʉ eja, na catʉjʉro ʉ̃ta cuiro ti totire na cabiabata cuiro aperopʉ cãno catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","To bairo to cabairo tʉjʉri ti toti pupeapʉ cajãacoajuparã. Topʉ jãa ejari jĩcaʉ cawamaʉ cariape nʉgoa maca jutii caroaro cabotiri wʉre cajaña ruiire catʉjʉyuparã. Cʉ tʉjʉrã seeto catʉjʉ acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","To bairo na cabairo tʉjʉʉ ocõo bairo na caĩñupʉ topʉ caruii ángel maca: —Yʉre tʉjʉ acʉaqueticõaña. Mʉjaa Jesu Nasaré macacʉ yucʉ tẽorica pãipʉre na capapua jĩaricʉre macarã mʉja áa. Mere tunu catícoami. Atopʉre maami. Cʉ̃re na capeobata paʉre tʉjʉrã ajá. ");
INSERT INTO tav_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tʉjʉ yaparo aáti cʉ buerã cãnanare, Pedro quenare buiorã aája: “Cʉ maca mʉja jʉgoye Galileapʉ, mere aá yuugʉmi. Cajʉgoye mʉjaare cʉ caĩ buioricarore bairona topʉ cʉ̃re mʉja tʉjʉgarã,” na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na romiri to bairo cʉ caĩro apirã Jesure na cayaaricaropʉ cãnana caatʉcoajuparã yua. Seeto uwibana cananaañuparã. To bairi aperãre na catʉjʉriquere caĩ buioquẽjuparã, uwibana. ");
INSERT INTO tav_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Judío maja na yerijãrica rʉmʉ bero macá rʉmʉ cabujuro bero Jesu catunu catiricʉ cabuia eja jʉgoyupʉ María Magdalenare. Co maca cajʉgoyepʉ siete wãtiare cʉ cabuu rebojarico cãñupo. ");
INSERT INTO tav_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Cõre cʉ cabuia ejaricaro bero Jesu mena cáaáteña nucuricarãre, cʉ cabai yajiriquere tʉgooñarique pairi caotirãre cabuio aájupo. ");
INSERT INTO tav_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Jesu mere tunu catiyupi, cʉ̃re yʉ tʉjʉwʉ,” co caĩrijere apirã co caapi nʉcʉbʉgoquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesu María Magdalenare cʉ cabuia ejaricaro bero aperã pʉgarã cʉ̃re canʉcʉbʉgorãre cabuia ejayupʉ tunu. Maca tʉjaropʉ cáaáteñarãre apeĩre baii ricati bauʉ cabuia ejayupʉ. ");
INSERT INTO tav_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nare cʉ cabuia ejaro, cʉ tʉjʉ majiri bero aperã cʉ buerã cãnanare cabuiorã aájuparã. Na quenare na caapi nʉcʉbʉgoquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","María Magdalenare, to bairi aperã quenare cʉ cabuia ejaricaro bero Jesu cʉ buerã cãnana once cãnacãʉna quenare cabuia ejayupʉ. Na caʉga ruiri paʉna cabuia ejayupʉ. Nare buia ejari, “Tunu catícoajupi,” na yarã na caĩrijere na caapi nʉcʉbʉgoquetaje jʉgori, “¿Nope ĩrã, ‘Tunu catícoajupi,’ na caĩrijere, cariape mʉja api nʉcʉbʉgoqueti?” na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ĩ yaparoʉ ocõo bairo na caĩñupʉ: —Ati yepa macana nipetirore yʉ ye quetire na buio teñarãja. ");
INSERT INTO tav_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","To bairo noo mʉja cabuiorijere apiʉjari, cabautisa rotiricarã unare na yʉ netoogʉ. Yʉre canʉcʉbʉgoquẽna una macare na yʉ popiyeyegʉ. ");
INSERT INTO tav_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yʉre caapiʉjarãre cʉ camajirijere na joogʉmi Dio. Tiere nare cʉ cajooro capee wameri áti iñoo majigarãma. Yʉ catutuaro mena wãtia camajare cajãaricarã quenare re buu majigarãma. Aperã yere na cawada majiquetibatajere wada majigarãma. ");
INSERT INTO tav_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Añare ñerã quena, capunirijere etirã quena ñe uniere tamʉoquetigarãma. Apeye quenare cariarãre na wamori mena na cañiga peorona na cariaye cʉtie netoogaro, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","To bairo Jesu cʉ buerãre ĩ buio yaparori bero ʉmʉrecoopʉ caame pea nʉcacoajupʉ. Cʉ Pacʉ Dio tʉpʉre ejaʉ cariape nʉgoa maca caejanumuñupʉ. ");
INSERT INTO tav_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ʉmʉrecoopʉ cʉ cawamʉ aáto bero cʉ buerã cãnana nipetiropʉ Jesu ye quetire cabuio teñarã aájuparã. Na cabuio teñaro mani Ʉpaʉ cʉ majuuna na cátinemoñupʉ. “Na cabuiorijere cariapena ã,” camaja na ĩ majiato ĩi capee wame cañuuri wameri cʉ buerã cãnana na cáti iñooro cájupʉ mani Ʉpaʉ. To cõona ã.");
INSERT INTO tav_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teófilo, yucʉ mʉre uca joogʉ yʉ áa. Jesu jã mena ãcʉ cʉ cabaiepere caucabajupa aperã. Jesu nipetiro cʉ cátajere catʉjʉricarã jã cabuiowã. To bairi jãre na caĩ buioepere bairona cauca tuyupa aperã. ");
INSERT INTO tav_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Yʉ quena nemoopʉre Jesu ye quetire na caucariquere yʉ cabue peticõawʉ. To bairi na caucariquere bue peticõaripʉ atiere cariape jĩcaro cõo yʉ ucagʉ. To bairo yʉ cáto ñuuga ĩi mʉ yʉ uca joo, Teófilo. To bairi mʉ quena, “Cariape ã na caĩ buiorique,” mʉ ĩ majigʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ocõo bairo cabaiyupa, cariapera: Herode, Judea macana ʉpaʉ cʉ cãni yʉteapʉre jĩcaʉ sacerdote Sacaría cawamecʉcʉ cãñupʉ. Abías maja cawamecʉti poa macacʉ cãñupʉ. Cʉ nʉmo Elisabé cawamecʉjupo. Co quena tirʉmʉpʉ macacʉ Aarón cawamecʉcʉ sacerdote ãnacʉ pãrameopʉ cãñupo. ");
INSERT INTO tav_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Naa pʉgarãpʉna cañuurã cãñuparã Dio cʉ catʉjʉro. Dio Moisépʉre cʉ carotiriquere bairo caroaro cátinucuñuparã. To bairi noa maca, “Caroorã ãma,” na caĩ majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Naa capunaa mana cãñuparã. Elisabé ʉta cãni majiquẽco cãñupo. Seeto cabʉcʉrã cãñuparã, mere. ");
INSERT INTO tav_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jĩca rʉmʉ Sacaría cʉ ya poa macana mena Dio wiipʉre sacerdote maja na cátinucuricarore bairo capaayupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","To cãnacã yʉtea jĩcaʉre cʉ cabejenucuñuparã Dio wii pupea cãni majuuri arʉapʉre caroa cajʉti ñuurije cajoe buje mʉgopaʉre. Ti paʉna Sacaríare cʉ cabejeyuparã, ti arʉapʉ cajʉti ñuurije cʉ joe jʉti ñuu mʉgoato ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","To bairi caroa cajʉti ñuurijere Sacaría cʉ cajoe buje mʉgotoye camaja capãarã ti arʉa wijaropʉna Diore cajeni nʉcʉbʉgo ãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","To cõona yua, topʉre Sacaría cʉ cajoe buje mʉgo ani paʉna cabuia ejanʉcañupʉ jĩcaʉ ángel Dio tʉ macacʉ, cʉ cajoe buje mʉgo ani cajawa cariape nʉgoa tʉ macare. ");
INSERT INTO tav_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Topʉ cʉ cabau ejanʉcaro tʉjʉʉ Sacaría maca cʉ catʉjʉ uwi acʉacoajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","To bairo cʉ cabairo cʉ tʉjʉʉ ocõo bairo cʉ caĩñupʉ Dio tʉ macacʉ maca: —¡Sacaría, uwiqueticõaña! Diore cʉ mʉ cajeni nʉcʉbʉgonucurijere apinucumi Dio. To bairi mʉ nʉmo Elisabé macʉ cʉtigomo. Cʉ cabuiaropʉ Juan cʉ mʉ wameyegʉ, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","—“Yʉ yaʉ ãmi, cãni majuʉ ãmi,” cʉ ĩ tʉjʉgʉmi Dio mʉ macʉre. To bairi seeto mʉ yeri wariñuugʉ. Cʉ cabuiaro tʉjʉrã capãarã wariñuugarãma aperã quena, cʉ caĩñupʉ ángel. —Ʉje wẽri rica oco jibioriquere, camecʉorijere cʉ etiqueticõato. Cʉ cabuiaparo jʉgoyepʉna Dio Catirique Espíritu Santo cʉ mena anitʉgagʉmi mere, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","—To bairi mʉ macʉ Israel macanare Dio ye quetire na buiori capãarã na Ʉpaʉ Diore na api nʉcʉbʉgoo joroque na átigʉmi moquena. ");
INSERT INTO tav_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cristo mari Ʉpaʉ jʉgoye buio majio jʉgoyeyeri majocʉ anigʉmi. Elías cawamecʉcʉ Dio ye quetire cabuioricʉ tirʉmʉpʉ macacʉ Dio Espíritu Santo cʉ catutuarije mena cabuionucuñupi. Cʉ ãnacʉ cʉ cabuio ocabʉtiricarore bairona buio ocabʉtigʉmi mʉ macʉ quena. Capacʉa na punaa mena ame ĩ punijiniricaro mano caroaro na anio joroque na átigʉmi. Dio yere cabai botioricarã quena Diore caroaro apipajeegarãma, mʉ macʉ cʉ cabuiorijere apiri. To bairi mʉ yarã Israel macana na Ʉpaʉ Cristo cʉ caejapere caroaro api nʉcʉbʉgo yuurã baigarãma, mʉ macʉ cʉ cabuiorijere apirã, cʉ caĩñupʉ ángel Sacaríare. ");
INSERT INTO tav_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","To bairo cʉ caĩrijere apii Sacaría maca cʉ cajeniñañupʉ Dio tʉ macacʉre yua: —¿Nope ĩi yʉ mʉ caĩri wame, “Cariapena ã,” yʉ ĩ majibocʉti yʉa? Cabʉcʉ majuu yʉ ã. Yʉ nʉmo quena cabʉcʉo ãmo. ");
INSERT INTO tav_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","To bairo cʉ caĩro ocõo bairo cʉ caĩñupʉ ángel Sacaríare: —Gabriel cawamecʉcʉ yʉ ã, Dio tʉ macacʉ. Caroa quetire mʉre yʉ buio rotimi Dio. ");
INSERT INTO tav_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","To bairi yʉre api nʉcʉbʉgoquẽcʉ cawada majiquẽcʉ mʉ anigʉ. Mʉ macʉ cʉ cabuiari paʉpʉ moquena mʉ wada majigʉ. Yʉre mʉ caapi nʉcʉbʉgoquẽtie to nibao joroquena nipetiro mʉ yʉ cabuiori wame cõona baigaro, cʉ caĩñupʉ Sacaríare. ");
INSERT INTO tav_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","To bairo cʉ cabairi paʉ aperã Sacaría cʉ cãno wijaro cayuurã caĩ tʉgooñañuparã. “¿Nope ĩi to cõo yoaro ti arʉapʉ cʉ tuacõacʉti?” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cabero cʉ wamori mena na cáti buioyupʉ, wada majiquetibacʉ. Cʉ cawada majiquẽtore tʉjʉrã, “Ricati wame cʉ iñooricʉmi Dio,” caĩ tʉgooñañuparã camaja. ");
INSERT INTO tav_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cabero Sacaría Dio wiipʉ cʉ ye paarica rʉmʉri capetiro catunucoajupʉ cʉ ya wiipʉre moquena. ");
INSERT INTO tav_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cʉ ya wiipʉre cʉ catunu ejaro bero cʉ nʉmo Elisabé ʉta cãñupo yua. Jĩca wamo cãnacãʉ muipʉa aperã tʉripʉ aáteñaricaro mano cãnicõañupo co ya wiipʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ocõo bairo caĩ tʉgooñañupo Elisabé: “Yucʉra yʉ átinemomi Dio. ‘Capunaa máco ãmo,’ yʉre ame ĩ wadaquetigarãma yua.” ");
INSERT INTO tav_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Cabero seis muipʉa Elisabé ʉta co cãno Dio caqueti jooyupʉ Gabriere cʉ tʉ macacʉre moquena. Galilea na caĩri yepapʉ, Nasaré cawamecʉti macapʉre cʉ cajooyupʉ Dio María cawamecʉco tʉpʉ. Cõa caʉmʉ mena cãniñaquẽco cãñupo. José cawamecʉcʉ nʉmo cãnipao cãñupo María yua. José maca tirʉmʉpʉ macacʉ Israel macana Ʉpaʉ David ãnacʉ pãrami cãñupʉ cʉ̃a. ");
INSERT INTO tav_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","To bairi Gabriel María tʉpʉ buia nʉca eja, ocõo bairo co caĩñupʉ: —Caroa wame mʉre yʉ buio rotimi Dio. Mʉ mena ãmi. Aperã romiri netoro caroa wame majuure mʉ átibojagʉmi Dio, co caĩñupʉ Dio tʉ macacʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","To bairo cʉ caĩrijere apio caapi acʉacoajupo María. “¿Nope ĩi to bairije cʉ ĩti?” caĩ tʉgooñañupo. ");
INSERT INTO tav_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","To bairo co caĩ uwi tʉgooñaro majii: —Uwiqueticõaña, co caĩñupʉ. —Caroaro mʉ cãniere mʉ tʉjʉ tʉjoomi Dio. To bairi mʉ bejemi. ");
INSERT INTO tav_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yucʉacã ʉta mʉ anigo. Cawimaʉ mʉ cʉgogo. To bairi mʉ Macʉ cʉ cabuiaropʉ JESU cʉ mʉ wameyego. ");
INSERT INTO tav_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pairo cãcʉ anigʉmi cʉ̃a. “Dio jõ bui macacʉ Macʉ ãmi,” cʉ ĩgarãma camaja. Dio cʉ̃re Caʉpaʉ jõogʉmi Israel macana Ʉpaʉ cʉ ñicʉ ãnacʉ, Ʉpaʉ David tirʉmʉpʉ macacʉre bairona. ");
INSERT INTO tav_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","To bairi Israel macanare rotinucugʉmi to cãnacã rʉmʉ. Cʉ carotirije petiquetigaro, co caĩñupʉ Dio tʉ macacʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","To bairo cʉ caĩro apio María maca cʉ cajeniñañupo: —¿Dope bairo yʉre to bairoati, caʉmʉ mena jĩcani uno yʉ cãniquetibao joroquena? ");
INSERT INTO tav_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","To bairo co caĩro: —Mʉpʉre ani ejagʉmi Dio Espíritu Santo. Cʉ camajirije mena to bairo mʉre baigaro. To bairi cañuu netoʉ, Dio Macʉ anigʉmi mʉ Macʉ, co caĩñupʉ Gabriel. ");
INSERT INTO tav_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Mʉ yao Elisabé quena ʉta ãmo yucʉra cabʉcʉo anibaopʉcona. Seis muipʉa ʉta ãmo capunaa máco na caĩbataco. ");
INSERT INTO tav_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","To bairi Diora jĩca wame unoacã cʉ cáti majiqueti wame maa, co caĩñupʉ ángel Gabriel Maríare. ");
INSERT INTO tav_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","To bairo cʉ caĩrije apio: —Diore paabojari majoco yʉ ã. To bairi yʉ mʉ caĩ buiori wamere bairona yʉre to baiato, cʉ caĩñupo María. To bairo co caĩro apii cáaácoajupʉ Dio tʉ macacʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ángel cʉ cáaáto bero cáaácoajupo María uwaro caʉ̃ta yucʉ cʉti yepapʉ, Judea cawamecʉti yepa. ");
INSERT INTO tav_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Topʉ ejao Sacaría ya wiipʉ cáaájupo. Cʉ ya wiipʉ jãa, cʉ nʉmo Elisabere cañuu rotiyupo. ");
INSERT INTO tav_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cõre co cañuu rotirona Elisabé cawimaʉ cõpʉre cãcʉacã seeto cayuguiyupʉ. Dio Espíritu Santo co yeripʉ cãni ejayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","To bairi Espíritu Santo cʉ cãni ejaroi wariñuurique mena baujaro ocõo bairo caĩñupo Elisabé Maríare: —Aperã romiri netoro caroa wame majuure mʉ joomi Dio. Cañuu majuʉ ãñupi mʉ Macʉacã mʉpʉre cãcʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cawatoa macaco yʉ anibao joroquena yʉ Ʉpaʉ cãnipaʉ paco yʉ mʉ tʉjʉo eja. Yʉre mʉ catʉjʉo ejaro seeto yʉ wariñuu. ");
INSERT INTO tav_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yʉ mʉ cañuu rotiri paʉna cawimaʉ yʉpʉre cajañaʉacã wariñuʉ yuguimi, co caĩñupo Maríare. ");
INSERT INTO tav_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dio mʉ cʉ caĩricarore bairona cariapena mʉre baigaro. Mʉre cʉ cabuioriquere mʉ caapipajeeroi wariñuuriquere mʉ joogʉmi Dio, co caĩñupo Elisabé. ");
INSERT INTO tav_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","To bairo co caĩro ocõo bairo co caĩñupo María maca: Yʉ Ʉpaʉ Dio ñuu majuucõami. Seeto yʉ yeri wariñuucʉpʉ, yʉre cacatioʉ ãmi Dio ĩo. ");
INSERT INTO tav_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Cawatoa cãco, cʉ paabojari majoco jeto yʉ anibao joroquena yʉ tʉgooña maimi Dio. Yʉ bero macana, “Caroaro co cájupi Dio cõre,” ĩgarãma yʉre. ");
INSERT INTO tav_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dio nipetiro cáti majii aniri caroaro yʉ átibojami. Cañuu majuʉ, caroorije mácʉ ãmi Dio, caĩñupo María. ");
INSERT INTO tav_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Noa cʉ̃re canʉcʉbʉgorã nipetirore na mai tʉjʉmi Dio. Tirʉmʉpʉ macanare to bairona na camai tʉjʉyupi. Cabero macana quenare to bairona na mai tʉjʉgʉmi Dio cʉ̃re canʉcʉbʉgorãre. ");
INSERT INTO tav_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cʉ catutuarije mena capee caroare áami Dio. “Aperã netoro camajirã jã ã,” na yeripʉre caĩ tʉgooñarãre na recõami. ");
INSERT INTO tav_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Caʉparã quenare na recõami. Cabopacarã macare caroti majirã na anio joroque na áami Dio. ");
INSERT INTO tav_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Cacʉgoquẽnare na joogʉmi cañuurijere. Caapeye pairã macare caroare jooquetigʉmi. Cabopacarã na anio joroque na átigʉmi Dio, caapeye unie paibatanare. ");
INSERT INTO tav_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mari ñicʉa Abraham jãare na cʉ cabuioricarore bairona átigʉmi Dio. “Mʉja bopaca tʉjʉri caroare mʉjaare yʉ joogʉ,” na cʉ caĩriquere majiritiquetigʉmi. To bairi yucʉra marire Israel macanare mari átinemogʉmi Dio, caĩñupo María yua. ");
INSERT INTO tav_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","To bairi itiarã muipʉa cãñupo María Elisabé tʉpʉ. Itiarã muipʉa ani, catunucoajupo co ya wiipʉ moquena. ");
INSERT INTO tav_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cabero Elisabé macʉ cʉ cabuiari rʉmʉ caejayupe yua. To bairi ti rʉmʉ cãno cabuiayupʉ co macʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Co macʉ cʉ cabuiarijere queti apirã co yarã, co ya maca macana co cawariñuunemoñuparã. —Dio caroaro co átibojami, co tʉjʉ maii, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho rʉmʉri cʉ cabuiaricaro bero, cawimaʉ cʉ̃re circuncisión na cáti wameyeri rʉmʉ cãno Sacaría, cʉ pacʉ wamere bairo Sacaría cʉ cawameyegabajuparã na yarã. ");
INSERT INTO tav_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Cʉ pacʉ wamere cʉ na cawameyegaro: —Baiquẽe. Juan wamecʉtigʉmi, caĩñupo cʉ paco. ");
INSERT INTO tav_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","To bairo co caĩro: —¿Nope ĩo cʉ mʉ wameyegati ti wamere? Aperã cʉ yarã to bairije cawamecʉna maama, co caĩñuparã na yarã. ");
INSERT INTO tav_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","To bairi cʉ pacʉre ocõo bairo caĩ jeniñañuparã na wamori mena áti iñoori cawada majiquẽcʉ cʉ cãnoi: —¿Dope bairo cʉ mʉ wameyegati? ");
INSERT INTO tav_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","To bairo cʉ na cáti jeniñaro Sacaría cʉ wamori mena ucarica pũuro jeni, ti pũuropʉ, “Juan wamecʉtigʉmi,” caĩ ucayupʉ. To bairo cʉ caĩ ucaro catʉjʉ acʉa peticoajuparã. ");
INSERT INTO tav_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nemoo cʉ caĩ ucari paʉna cawada majiquetibatacʉ cawada maji jʉgoyupʉ moquena Sacaría yua. Wadaʉ, Diore caĩ wariñuuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","To bairije cʉ cabairo na tʉ macana caapi acʉa peticoajuparã. Judea macana, caʉ̃ta yucʉ cʉti yepa macana nipetirã caame queti buionucuñuparã tie cabairijere. ");
INSERT INTO tav_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tie cabairijere ame queti buio, seeto catʉgooñañuparã nipetirã. Cʉ̃ cawimaʉ mena caroaro cãñupʉ Dio. To bairi, “¿Dope bairo cabaipaʉ cʉ ãcʉati cabʉcʉ ãcʉpʉ?” caame ĩñuparã to macana. ");
INSERT INTO tav_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cʉ pacʉ Sacaría cʉ yeripʉre Dio Espíritu Santo cʉ cãni eja netoroi ocõo bairo caĩ buioyupʉ cʉ macʉ cʉ cabaipere: ");
INSERT INTO tav_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mari Ʉpaʉ Dio Israel macana Ʉpaʉ ãmi. Cʉna caroaro cátinemoñupi marire cʉ yarãre. Marire átinemocõami mere. ");
INSERT INTO tav_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dio marire joomi catutuaʉ majuu, marire canetoo catiopaʉre. David ãnacʉ, Dio cʉ caboorijere cátacʉ pãramerã watoapʉ cãnipaʉre marire joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tirʉmʉpʉ cʉ yarã cʉ ye quetire cabuioricarã ãnana jʉgori cʉ caĩ buioricarore bairona átigʉmi. ");
INSERT INTO tav_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mari wapanare, marire catʉjʉteerãre marire matabojagʉmi. ");
INSERT INTO tav_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mari ñicʉ jãapʉre, “Mʉñʉja mai tʉjʉgʉ,” cʉ caĩricarore bairona majiritiquẽemi Dio. ");
INSERT INTO tav_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mari cãniparo jʉgoye macacʉ Abrahãre, “Mʉ pãramerãpʉre caroaro na yʉ átibojagʉ,” cʉ caĩriquere majiritiquẽemi Dio. ");
INSERT INTO tav_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Noa mari catʉjʉ tutirãre mari matabojagʉmi Dio. Aperãre uwiquẽnana yʉre na áti nʉcʉbʉgoato ĩi na matagʉmi. ");
INSERT INTO tav_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","To bairo cʉ cáto caroaro cʉ̃re mari áti nʉcʉbʉgocõa aninucugarã mari cacatiri rʉmʉri cõo. Cʉ catʉjoorijere mari átigarã. Cariape cãna mari anicõagarã, caĩñupʉ Sacaría. ");
INSERT INTO tav_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","To bairo ĩ, ocõo bairo caĩñupʉ Sacaría moquena cʉ macʉacãre: Camaja, “Mari Ʉpaʉ jõ bui macacʉ ye quetire buiori majocʉ majuu ãmi,” mʉ ĩgarãma. Mari Ʉpaʉ cʉ cáatíparo jʉgoye camajare na mʉ buio jʉgoyeyegʉ. Mari Ʉpaʉ ye quetire caroaro na apiato ĩi, cʉ jʉgoye mʉ buio jʉgoyeyegʉ. ");
INSERT INTO tav_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","“Caroorije mʉja cátiere mʉja majiritiobojagʉmi Dio cʉ mʉja cajeniro,” na mʉ ĩ buionucugʉ. To bairo na mʉ cabuiorijere apirã Dio na cʉ careboriquere netogarãma. Cʉ mena caroaro catirique bʉgagarãma. ");
INSERT INTO tav_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dio marire bopaca tʉjʉri mari joogʉmi cʉ Macʉre. Jĩca rʉmʉ caroa rʉmʉ muipʉ caroaro cʉ caaji atí rʉmʉ cãnore bairona caroaro mari átibojagʉmi Dio yucʉacã. Caroaro cãni majiquẽnare caroaro na cãnipe macare na majiogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","To bairo ácʉ jĩa bujuricaro cabujurore bairo caroaro na átibojagʉmi Dio canaitĩaropʉ cãnare bairo cãnibatanare. Cariarã quenare na átinemogʉmi mari Ʉpaʉ. Caroaro ani wariñuuriquere mari joogʉmi Dio, caĩñupʉ Sacaría yua. ");
INSERT INTO tav_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cabero cʉ macʉ bʉti, seeto catʉgooña maji ocabʉti bʉtiyupʉ. Israel macanare Dio ye quetire cʉ cabuioparo jʉgoye mai camaja manopʉ cañe unie manopʉ cãnicõa aninucuñupʉ Juan yua. ");
INSERT INTO tav_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti paʉ cãno César Augusto cawamecʉcʉ nipetiro yepa ʉpaʉ cãñupʉ. Ʉpaʉ majuu ãcʉ camaja nipetirãre cõoñagʉ na wamerire cauca tura aá rotiyupʉ cʉ ẽoro macana ʉparã tʉpʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Siria cawamecʉti yepa macana “Sirenio” cawamecʉcʉ na ʉpaʉ cʉ cãni yʉteapʉre camajare na cacõoña roti jʉgoyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","To bairi camaja na cãno cõo na ñicʉ jãa na cãna macaripʉ César Augusto cʉ cacũricarãre ʉparãre na wamere cabuiora aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","To bairi José quena Nasaré na caĩri maca Galilea yepapʉ cãnacʉ cáaácoajupʉ cʉ quena. David ãnacʉ pãrami aniri David cʉ cabuiaricaropʉ aácʉ cájupʉ Belén na caĩri macapʉ, Judea yepapʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cʉ nʉmo cãnipao María mena Belẽpʉ cáaácoajupʉ José, ʉparãre cʉ wamere buioʉ aácʉ. Ti paʉre seeto majuu ʉta cãñupo María mere. ");
INSERT INTO tav_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","To bairi Belẽpʉ na cãno mere buiagʉpʉ cájupʉ co macʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Topʉ camaja cateñarã ejarã na cacaniri wii cajiracoajupe. Cajiraro tʉjʉrã wecʉare na canuri wiipʉ cáaácoajuparã, ape paʉ canirica paʉ bʉgaquetibana. Ti wiipʉ na cãno cabuiayupʉ María Macʉ yua, cãni jʉgoʉ. Cʉ cabuiaro María cʉ̃re juti ajero mena cʉ uma, cʉ cajãñupo wecʉare na canuri coropʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén maca tʉacã tataboaropʉ waibʉcʉrã oveja cawamecʉnare cacoterã cãñuparã. Ñami quena ovejare to bairona catʉjʉ cote bujucoanucuñuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","To bairo na cabairo na catʉgooñaqueti paʉna na tʉpʉre cabuia ejayupʉ ángel, Dio tʉ macacʉ. Na tʉpʉ cʉ cabau ejaro seeto cabujuyupe Dio ye caaji baterije. To bairo cabairo seeto catʉjʉ acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","To bairo na cabairo ángel maca: —Uwiqueticõaña, na caĩñupʉ. —Caroa quetire mʉja buio acʉ́ yʉ baiwʉ, camaja nipetirã na cawariñuupa wame majuure. ");
INSERT INTO tav_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ati ñami David ãnacʉ ya macapʉre buiami Dio cʉ cajoʉ Cristo, mari Ʉpaʉ, mʉjaare canetoo catiopaʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Topʉ aána wecʉa wiipʉ camaja wecʉare na caʉgarique nuri coropʉ juti ajero mena umaricʉ cʉ mʉja bʉgagarã. To bairo átacʉre cʉ tʉjʉrã cariapena, “Cʉna ãmi,” mʉja ĩ majigarã, na caĩñupʉ ángel. ");
INSERT INTO tav_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","To bairo cʉ caĩro cʉ mena capãarã cabuia eja nʉcanemoñuparã Dio tʉ macana. Na bau eja, ocõo bairo Diore caĩ baja wariñuuñuparã: ");
INSERT INTO tav_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cañuu netoʉ ãmi Dio, ʉmʉrecoo macacʉ! ¡Wariñuurique cʉ joato noa cʉ caboorijere cánare! ");
INSERT INTO tav_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","To bairo Diore ĩ wariñuu baja yaparo ʉmʉrecoopʉ catunucoajuparã. Ʉmʉrecoopʉ na catunu aáto bero ocõo bairo caame ĩñuparã oveja coteri maja yua: —¡Jitá! ¡Belẽpʉ mari aáparo! Atie queti Dio marire cʉ cabuioejere mari tʉjʉra aáparo. ");
INSERT INTO tav_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","To bairo ame ĩ, nemoo uwaro catʉjʉra aácoajuparã. Aá, macapʉ piya ejarã, na cabʉgayuparã Maríare, Josére. Cawimaʉ quenare wecʉare na canuri coropʉ cajañaʉre cʉ catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cʉ tʉjʉ, to cõona Dio tʉ macacʉ, “Cadaquei buiami,” na cʉ caĩ buioriquere cabuio bateyuparã aperãre. ");
INSERT INTO tav_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","To bairi camaja nipetiro oveja coteri maja na caĩ buiorijere apirã seeto catʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María maca co yeripʉ caroaro catʉgooñañupo tiere na caĩ buiorijere. Seeto majuu tiere catʉgooñañupo. ");
INSERT INTO tav_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Cabero oveja coteri maja wariñuuri catunucoajuparã. “Dio tʉ macacʉ marire cʉ caĩ buiorore bairona cariape mari tʉjʉwʉ. Cañuu netoʉ ãmi Dio,” caĩñuparã tunu aána yua. ");
INSERT INTO tav_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho cãnacã rʉmʉ bero cʉ̃re wameyerica rʉmʉ, circuncisión cʉ̃re na cátipa rʉmʉ cãñupe. To bairi ʉta María co cãniparo jʉgoyepʉna Dio tʉ macacʉ na cʉ cawameye rotirica wamere bairona JESU cʉ cawameyeyuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cabero María co cacati petiri rʉmʉri bero Moisé, Israel maja ñicʉ ãnacʉ cʉ carotiricarore bairona átigarã cáaájuparã Jerusalẽpʉ. María macʉacãre, “Dio yaʉ anigʉmi,” ĩ nʉcʉbʉgorã aána cáaácoajuparã Dio wiipʉ Jerusalẽpʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","24","Ocõo bairo caĩ ucayupi Dio cʉ carotirijere Moisé: “Nipetirã cabuia jʉgorã caʉmʉare, Dio yarã majuu ãma ĩrã cajoe buje mʉgoparãre na jooya sacerdote majare buaare jĩca bapa. Na camamata buaacãrena na jooya,” caĩ ucayupi Moisé. To bairona átira aána cáaácoajuparã José, María Jerusalẽpʉ Dio wiipʉre. ");
INSERT INTO tav_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti paʉ cãno jĩcaʉ cãñupʉ Jerusalẽpʉ Simeón cawamecʉcʉ. Cañuʉ cãñupʉ, Diore canʉcʉbʉgoʉ. Israel macanare canetoo catiopaʉre cáacʉ́re cayuʉ cãñupʉ. Dio Catirique Espíritu Santo Simeón mena cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","To bairi Espíritu Santo cajʉgoyepʉna cʉ caĩ buioyupʉ Simeóre: “Mʉ cabai yajiparo jʉgoye Cristore, Dio cʉ cajoʉre mʉ tʉjʉgʉ.” ");
INSERT INTO tav_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","To bairi Jesu pacʉa na caejapa rʉmʉ majuuna Simeóre Dio wiipʉre cʉ cáaá rotiyupʉ Dio Espíritu Santo. To bairi ti wiipʉ cʉ cãno María, José jãa cajãajuparã, Moisé cʉ carotiricarore bairona átira anaa. To bairi na cajãa atí paʉna cawimaʉre Jesure cʉ caboca neñupʉ Simeón. ");
INSERT INTO tav_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Cʉ boca ne, ocõo bairo Diore caĩ wariñuuñupʉ: ");
INSERT INTO tav_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Yʉ mʉ cabuioepere bairona mere yʉ majuuna yʉ tʉjʉ camajare canetoo catiopaʉre. To bairi wariñuurique mena yʉ bai yajigʉ, yʉ Ʉpaʉ Dio. ");
INSERT INTO tav_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Cʉ mʉ jooyupa camaja nipetirã na camajipaʉre. ");
INSERT INTO tav_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mʉ yarã Israel macanare caroaro mʉ cãniere majiogʉmi ani cawimaʉ. To bairo cʉ cáto aperã Israel macana mee quena caroaro mʉ cãniere tʉjʉ majigarãma, caĩñupʉ Simeón. ");
INSERT INTO tav_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","To bairi José, María jãa caapi acʉacoajuparã Jesu cʉ cabaipere Simeón cʉ caĩ buiorijere apirã. ");
INSERT INTO tav_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","To bairo na caapi acʉarona Simeón, “Mari Pacʉ Dio caroa wariñuurique mʉjaare cʉ joato,” na caĩñupʉ. To bairo na ĩ, ocõo bairo Maríare co caĩñupʉ moquena: —Ani mʉ Macʉre cʉ cajooyupi Dio camaja na yeripʉ macajere cabejepaʉre. To bairi Israel macana capãarã cʉ tʉjʉrã cʉ teebʉjagarãma. To bairi seeto tutuarije majuu mʉ yeripʉ tʉgooñarique pairique mʉre anigaro. Aperã maca Israel macana cʉ boogarãma mʉ Macʉre. ");
INSERT INTO tav_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Apeo Ana cawamecʉco Dio ye quetire buiori majoco ti wiipʉre cãñupo co quena. Fanuel maco, Aser ãnacʉ pãrameopʉ cãñupo. Cawamao ãcopʉ camanapʉ cʉtibataco cãñupo. Co manapʉ siete cʉmari anibacʉ cayaji weoyupʉ. Cʉ cabai yajiro bero cawapearico cãnicõañupo yua. To bairi seeto cabʉcʉo cãñupo, ochenta y cuatro cʉmari majuu cacʉgoo ti wiipʉ Jesure cʉ pacʉa cʉ na cane ejari paʉre. Tona Dio wiipʉ cãnicõa aninucuñupo, Diore jeni nʉcʉbʉgo ãco. To cãnacã rʉmʉ, ñami quenare Diore cajeni nʉcʉbʉgonucuñupo. Nairoacã ʉgaquẽcona Diore cajeni nʉcʉbʉgonucuñupo. ");
INSERT INTO tav_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","To bairi Simeón cʉ cawadari paʉna caejanʉcao ejayupo co quena. Ejanʉca, Jesuacãre tʉjʉri, “Ñuu majuucõa,” Diore cʉ caĩ wariñuuñupo. Cabero Jerusalén macanare, “Jĩcaʉ marire canetoo catiopaʉ atígʉmi,” caĩ tʉgooñanucurãre na caĩ buioyupo Jesu cʉ cabuiarije nipetiro. “Cawimaʉ yʉ catʉjʉecʉ mari cayuuricʉ ãmi,” na caĩ buionucuñupo Ana cawamecʉco cabʉcʉo. ");
INSERT INTO tav_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","To bairi María, José cawimaʉ cʉ cabuiaro bero macaje, Dio cʉ carotiricarore bairo áti yaparo catunucoajuparã na ya maca Nasarépʉ, Galilea na caĩri yepapʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Topʉ cawimaʉ caocabʉtii, camajii cãni bʉtiyupʉ. Dio caroaro cʉ cájupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","To cãnacã cʉma Jesu paco María, José Jerusalẽpʉ cáaánucuñuparã, pascua boje rʉmʉ tʉjʉra aána. ");
INSERT INTO tav_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","To bairi Jesu doce cʉmari cacʉgoʉ cʉ cãno moquena na cáaánucuricarore bairona cáaájuparã. To bairi Jesu quenare cʉ cane aájuparã Jerusalẽpʉ. ");
INSERT INTO tav_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Topʉ eja, ani, pascua boje rʉmʉ capetiro catunu aájuparã na ya macapʉ. Na catunu aáto na caʉja tunu aáquẽjupʉ Jesu na mena. Cʉ pacʉa maca, “Tuacõaʉmi,” caĩ majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Aperã mari yarã cáaáteñarã mena aácʉmi,” caĩ tʉgooñañuparã. To bairo ĩ tʉgooñarã jĩca rʉmʉ aátato cõo catʉja aájuparã. Jĩca rʉmʉ aá tʉjabanana cʉ camacañuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na yarã mena cʉ camano tʉjʉrã Jerusalẽpʉ catunucoajuparã moquena, cʉ macara aána. ");
INSERT INTO tav_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Itia rʉmʉ Jerusalẽpʉ cʉ macabana majuu cʉ cabʉgayuparã Dio wiipʉre. Judío majare cabuerã mena caruiyupʉ. Na cabuiorijere apiri cʉ quena na caĩ jeniñañupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Cʉ̃re caapirã nipetiro cʉ caĩ majirijere apirã, na cʉ caĩ yʉrije quenare apirã caapi acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","To bairi cʉ paco, José mena topʉ cʉ cabʉgayuparã. Cʉ bʉgarã catʉjʉ acʉacoajuparã na quena. Cʉ paco maca ocõo bairo cʉ caĩñupo: —¿Nope ĩi to bairo jãre mʉ bai tua weoyari? Mʉ pacʉ, yʉ yoaro mʉre jã macabapʉ. Seeto mʉre jã tʉgooñarique paiwʉ, cʉ caĩñupo. ");
INSERT INTO tav_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","To bairo co caĩro ocõo bairo co caĩ yʉyupʉ Jesu: —¿Nope ĩrã ape paʉripʉ tʉgooñarique pairi yʉ mʉja macari? Yʉ Pacʉ yere cátipaʉ yʉ ã. “Tiere ácʉmi,” yʉ mʉja caĩ majipe anibajupa. ");
INSERT INTO tav_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Na maca to bairo cʉ caĩri wamere caapi majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Cabero na mena catunucoajupʉ Nasarépʉ moquena. Nasarépʉ tunu aácʉ cajʉgoye cʉ cátinucuricarore bairona na carotirijere caroaro cáticõa aninucuñupʉ. Jerusalẽpʉ cʉ cabairique nipetirore catʉgooñanucuñupo cʉ paco maca. ");
INSERT INTO tav_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Atie bero Jesu cabʉtinemoñupʉ. Bʉti, catʉgooña majii bʉtinemoñupʉ. Dio caroaro cʉ catʉjʉ wariñuuñupʉ. Camaja quena caroaro cʉ catʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Cabero Juan, Sacaría macʉ cabʉcʉ cãñupʉ. Camaja mani paʉpʉ, cayucʉ manopʉ cãninucuñupʉ Juan. Ti paʉ cãnopʉ Tiberio César cawamecʉcʉ romano maja ʉpaʉ carotii cãñupʉ. To cãnacã yepa ape macaripʉre cʉ̃re carotibojarã cãñuparã. Ponsio Pilato cawamecʉcʉ Judea yepapʉre cʉ carotibojayupʉ. Herode cawamecʉcʉ Galilea yepapʉre cʉ carotibojayupʉ. Herode bai Felipe cawamecʉcʉ Iturea, Traconite pʉga yepapʉre cʉ carotibojayupʉ cʉ̃a. Apei Lisanias cawamecʉcʉ Abilinia yepapʉre cʉ carotibojayupʉ. To bairo na carotiri yʉteare sacerdote maja ʉparã cãñuparã Aná, Caifá cawamecʉna. To bairi Tiberio César quince cʉmari caʉpaʉ cʉ cãno Dio cʉ ye quetire cʉ cabuio teña rotiyupʉ Juãre camaja manopʉ cãninucuʉre. ");
INSERT INTO tav_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","To bairi Jordán na caĩri ya tʉpʉ nipetiro to cãnare na cabuio teñanucuñupʉ Juan. Ocõo bairo na cabuionucuñupʉ nare: —Caroorije mʉja cátinucurijere jʉtiritiri mʉja yeri wajoaya. Coje rericarore bairo caroorije jã cátiere Dio cʉ majirioato ĩrã bautisa rotiya, caĩ buio teñanucuñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","To bairo buio teñaʉ, tirʉmʉpʉ macacʉ Dio ye quetire cabuioricʉ Isaía cawamecʉcʉ ãnacʉ cʉ caĩ ucarica wamere bairona cájupʉ Juan. Ocõo bairo caĩ ucayupi Isaía Juan cʉ cabaipere: Ocõo bairo ĩ awaja buiogʉmi jĩcaʉ camaja manopʉ cãcʉ: “Caroaro quenoo yuuya mʉja yerire mari Ʉpaʉ cʉ cáatíparo jʉgoye. Caroa macare ája. Camaja na ʉpaʉ cʉ cáatípa wãre na caquenoo yuurore bairona caroaro quenoo yuuya. ");
INSERT INTO tav_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Camaja maca na ʉpaʉ cʉ cáatípa wãpʉre ope to cãmata jita mena cũ jiroo bipema. Ʉ̃ta buuri to cãmata yejea cũ quenooma. Carupa betori quenare cariape quenoo ame buuma ti wãre. Caroaro yabi ñuuri wã quenooma na ʉpaʉ cʉ cáatípa wãre. To bairo na cátore bairona mari Ʉpaʉ cʉ cáatíparo jʉgoye mʉja yeri macajere quenoo yuuya. Caroorije mʉja cátiere áti janaña. ");
INSERT INTO tav_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","To bairo mʉja cáto camajare canetoo catiopaʉre tʉjʉgarãma camaja nipetiro,” ĩ awajagʉmi jĩcaʉ camaja manopʉ cãcʉ, caĩ ucayupi Isaía ãnacʉ tirʉmʉpʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","To bairi Isaía cʉ caĩ ucaricarore bairona cabaiyupʉ Juan. To bairi Juan tʉpʉ caejayuparã camaja capãarã cʉ bautisa rotira anaa. Ocõo bairo na caĩñupʉ Juan cʉ tʉpʉ caejarãre: —Caroorije mʉja áticõa aninucu. ¿Nope ĩrã yʉ tʉpʉ ejari yʉre mʉja bautisa rotiti? Mʉja popiyeyegʉmi Dio mʉja cayeri wajoaquẽpata. ");
INSERT INTO tav_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Caroorije mʉja cátiere jʉtiritiri áti janaña. Caroa macare ája. To bairo ána Dio yarã mʉja cãniere mʉja ani iñoogarã. “Abraham pãramerã jã ã, to bairi Dio yarã jã ã,” ĩ tʉgooñaqueticõaña. Atie ʉ̃ta rupaarena áti rupeo majimi Dio Abraham pãramerãre nare cʉ caboonemoata, na caĩñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","—Mʉja catʉgooñarijere mʉja cawajoaquẽpata, caroa macare mʉja cátiquẽpata mʉja regʉmi Dio. Yucʉ carica maniire quetí joe rocaricarore bairona mʉja átigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","To bairo na cʉ caĩ buioro apiri ocõo bairo cʉ caĩ jeniñañuparã: —Baiyupa, ¿dope bairo jã ánaati? ");
INSERT INTO tav_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","To bairo cʉ na caĩ jeniñaro: —Nii camisa pʉgaro cacʉgoʉ apei cacamisa mácʉre jĩcaro cʉ jooya, na caĩñupʉ Juan. —Noa caʉgarique cʉgorã na jooya aperãre caʉgarique manare, na caĩ yʉyupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aperã Juan tʉpʉ caejayuparã gobiernore camaja yere niyeru jeebojari maja. Na quena bautisa rotira anaa cabaiyuparã. Ocõo bairo cʉ caĩ jeniñañuparã: —Jãre camajioʉ, ¿dope bairo jã ánaati jãa? ");
INSERT INTO tav_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","To bairo na caĩ jeniñaro: —Mʉja ʉparã niyeru camaja yere mʉja na cajee rotinucuro cõona jeeya. Netoro jeniqueticõaña, na caĩñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Polisía maja quena ocõo bairo cʉ caĩ jeniñañuparã: —¿Jãate dope bairo jã cátipe to ãti? Juãre cʉ caĩ jeniñañuparã. To bairo na caĩ jeñiñaro: —Camajare na ĩ uwiotori na yere emaqueticõaña. Cariape mʉja cawapataro cõona cʉgo wariñuuña. Boonemoqueticõaña, na caĩñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Camaja nipetiro Juan cʉ cabuiorijere apirã seeto cʉ catʉgooñañuparã. “Dio ye quetire cabuiori maja ãnana, ‘Jĩcaʉ Cristo, camajare cátinemopaʉre cʉ joogʉmi Dio,’ ¿na caĩricʉ cʉ anicʉti ania?” caame ĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","17","To bairo na caame ĩ jeniñaro ocõo bairo na caĩ buioyupʉ Juan cʉ tʉpʉ caejarã nipetirore: —Oco mena cabautisaʉ yʉ ã. Yʉ bero anigʉmi yʉ netoro cãcʉ, cãni majuʉ. Cʉ menare cʉ paabojari majocʉre bairo yʉ ã. Cʉ maca cʉ Espíritu Santo, cʉ catutuarije mena joogʉmi. Cʉ Espíritu Santore joo, cʉ̃re caboorãre caroorije na cátiere oco mena ʉgueri coje rericarore bairona na átigʉmi. Cʉ̃re cabooquẽna macare na regʉmi, cʉ yarã jetore na beje jeegʉ. Trigo rupaa ajeri caroorije papu beje joe rericarore bairona na regʉmi. Caroa macare beje cũrica paʉpʉ cũricarore bairona na átigʉmi cʉ yarã jetore. Aperã macare pero cayatiqueti peropʉ na regʉmi, na caĩ buioyupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Apeye Dio ye quetire capee na caĩ buionemoñupʉ Juan. ");
INSERT INTO tav_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herode ti yepa ʉpaʉ maca Juan cʉ cabuionucurijere caapigateeyupʉ. Cʉ maca cʉ bai Felipe nʉmore Herodía cawamecʉcore caemañupʉ. Apeye quenare capee rooro majuu cácʉ cãñupʉ Herode. To bairo cácʉre, “Ñuuqueti majuucõa to bairo rooro mʉ cátinucurije,” cʉ caĩbajupʉ Juan Herodere. ");
INSERT INTO tav_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","To bairo Juan cʉ caĩrijere apibaopʉcʉna rooro cʉ cájupʉ Herode. Presopʉ cʉ cajooyupʉ, “Rooro mʉ átinucu,” Juan cʉ̃re cʉ caĩnucurijere apigatei. ");
INSERT INTO tav_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Atie jʉgoye, presopʉ Ʉpaʉ Herode Juãre cʉ cajõoparo jʉgoye camaja capãarãre na cabautisayupʉ Juan. Nare cʉ cabautisaro Jesu quena bautisa rotii caejayupʉ. To bairi Jesure Juan cʉ cabautisaro bero cʉ Pacʉre cajeni nʉcʉbʉgoyupʉ Jesu. Cʉ cajeni nʉcʉbʉgori paʉ ʉmʉrecoo capãñupe. ");
INSERT INTO tav_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Capãro Dio Espíritu Santo Jesupʉre buare bairo cʉ cabau rui ejayupʉ. To bairo Jesupʉre cʉ cabau rui ejaro Dio ʉmʉrecoopʉi caĩ wadayupʉ: —Yʉ Macʉ, yʉ camai netoʉ majuu mʉ ã. Seeto mʉ yʉ tʉjʉ wariñuu, Jesure cʉ caĩñupʉ Dio yua. ");
INSERT INTO tav_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Treinta cʉmari cacʉgoʉ majuu ãcʉ camajare cabuio teña jʉgoyupʉ Jesu. Dio Macʉ cʉ nibao joroquena, “José macʉ ãmi,” caĩ tʉgooñabajuparã camaja Jesure. Joséa Elí macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí maca Matá cawamecʉcʉ macʉ cãñupʉ. Matá Leví macʉ cãñupʉ. Leví Melqui macʉ cãñupʉ. Melqui Jana macʉ cãñupʉ. Jana José macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías macʉ cãñupʉ. Matatías Amós macʉ cãñupʉ. Amós Esri macʉ cãñupʉ. Esri maca Nagai macʉ cãñupʉ cʉ̃a. ");
INSERT INTO tav_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat macʉ cãñupʉ. Maat Matatías macʉ cãñupʉ. Matatías Semei macʉ cãñupʉ. Semei José macʉ cãñupʉ. José Judá macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joana macʉ cãñupʉ. Joana maca Resa macʉ cãñupʉ. Resa Sorobabé macʉ cãñupʉ. Sorobabé Saratié macʉ cãñupʉ. Saratié Neri macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui macʉ cãñupʉ. Melqui Adi macʉ cãñupʉ. Adi Cosam macʉ cãñupʉ. Cosam Elmodam macʉ cãñupʉ. Elmodam Er macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué macʉ cãñupʉ. Josué Elieser macʉ cãñupʉ. Elieser Jorim macʉ cãñupʉ. Jorim Matá macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matá Leví macʉ cãñupʉ. Leví Simeón macʉ cãñupʉ. Simeón Judá macʉ cãñupʉ. Judá José macʉ cãñupʉ. José Jonán macʉ cãñupʉ. Jonán Eliaquim macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea macʉ cãñupʉ. Melea Mainán macʉ cãñupʉ. Mainán Matata macʉ cãñupʉ. Matata Natán macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David macʉ cãñupʉ. David Isaí macʉ cãñupʉ. Isaí Obé macʉ cãñupʉ. Obé Booz macʉ cãñupʉ. Booz Salmón macʉ cãñupʉ. Salmón Naasón macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadá macʉ cãñupʉ. Aminadá Aram macʉ cãñupʉ. Aram Esrom macʉ cãñupʉ. Esrom Fares macʉ cãñupʉ. Fares Judá macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacobo macʉ cãñupʉ. Jacobo Isaá macʉ cãñupʉ. Isaá Abraham macʉ cãñupʉ. Abraham Taré macʉ cãñupʉ. Taré Nacor macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serú macʉ cãñupʉ. Serú Ragau macʉ cãñupʉ. Ragau Pelé macʉ cãñupʉ. Pelé Heber macʉ cãñupʉ. Heber Sala macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán macʉ cãñupʉ. Cainán Arfasá macʉ cãñupʉ. Arfasá Sem macʉ cãñupʉ. Sem Noé macʉ cãñupʉ. Noé Lame macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame Matusalẽ macʉ cãñupʉ. Matusalẽ Enocʉ macʉ cãñupʉ. Enocʉ Jared macʉ cãñupʉ. Jared Mahalaleel macʉ cãñupʉ. Mahalaleel Cainán macʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós macʉ cãñupʉ. Enós Sete macʉ cãñupʉ. Sete Adán macʉ cãñupʉ. Adán nemoopʉre Dio macʉ cãñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Juan Jesure cʉ cabautisaro bero Dio Espíritu Santo seeto majuu cãnicõañupʉ Jesu mena. To bairi Jesure Jordán na caĩri ya cãnacʉre camaja na camanopʉ, cayucʉ manopʉ cʉ cajʉgo aájupʉ Espíritu Santo yua. ");
INSERT INTO tav_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Topʉ cãñupʉ Jesu cuarenta rʉmʉri majuu. Topʉ cañee unie mani paʉpʉ cʉ cãno Sataná caroorije cʉ cáti rotibajupʉ. To bairo cʉ cabairi rʉmʉrire Jesu caʉgaquẽjupʉ. To bairi seeto cañigo riabʉjayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","To bairo cañigo riaʉre tʉjʉʉ ocõo bairo cʉ caĩñupʉ Sataná: —Dio Macʉ mʉ cãmata atia ʉ̃taarena ʉgarique jeñoori ʉgaya, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","To bairo cʉ̃re cʉ caĩro: —Yʉ átiquẽe. Dio ye queti ucarica pũuripʉ ocõo bairo ĩ ucarique ã: “Camaja ʉgarique jeto mena caroaro mari catí majiquẽe. Dio Wadarique macare tʉgooñacõari caroaro mari catí ani maji,” cʉ caboca ĩñupʉ Jesu maca. ");
INSERT INTO tav_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Cabero Sataná cʉ cajʉgo aájupʉ caʉmʉaricʉ ʉ̃taʉpʉ. Cʉ jʉgo aá, tii buipʉ yoaro mee cʉ caiñoo peocõañupʉ ati yepa macaje nipetirore. To cãnacã maca cʉ caiñooñupʉ. Tiere cʉ iñoʉ ocõo bairo cʉ caĩñupʉ Sataná: ");
INSERT INTO tav_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","—Atie mʉ yʉ caiñoorije caroa majuu ati yepa macaje yʉ ye jeto ã. To bairi noo yʉ cajoogaʉre cʉ yʉ joogʉ. Mʉrena mʉ cabooata mʉ yʉ joogʉ. To bairi nipetiri macari macanare caʉpaʉ mʉ yʉ jõogʉ yʉ tʉpʉ rʉpopatuapʉ numu cumuri yʉre mʉ cajeni nʉcʉbʉgoata. Jaʉ, mʉ ĩwã, Jesure cʉ caĩbajupʉ Sataná. ");
INSERT INTO tav_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","To bairo cʉ caĩro: —¡Aácʉja! Dio ye quetire ucarica pũuripʉ caĩrore bairo jeto yʉ átigʉ. Ocõo bairo ĩ ucarique ã: “Dio jĩcaʉna ãmi Caʉpaʉ mari cáti nʉcʉbʉgopaʉ. Cʉ carotirije jetore ája,” Satanáre cʉ caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Cabero Sataná moquena cʉ jʉgo aá, Jerusalẽpʉ Dio wii buipʉ cʉ cajʉgo aájupʉ. Topʉ cʉ jʉgo aá, ocõo bairo cʉ caĩñupʉ: —Cariapena Dio Macʉna yʉ ã mʉ caĩata atopʉi bapa ña rui aácʉja yepapʉre. Cariapena Dio Macʉ mʉ cãmata mʉ riaquetigʉ, cʉ caĩbajupʉ Sataná Jesure. ");
INSERT INTO tav_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","—Dio ye queti ucarica pũuripʉ ocõo bairo ĩ: Ángel majare mʉ cote rotigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nare mʉ boca ñe rotigʉmi ʉ̃ta rupaapʉre mʉ caña roca peaquetiparore bairo ĩi. Ti wame ĩ ucarique ã. ");
INSERT INTO tav_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","To bairo cʉ caĩro: —Ocõo bairo ĩ Dio Wadarique, cʉ caĩñupʉ Jesu moquena: “Mʉja Ʉpaʉ Diore, ‘Mʉ camajirijere áti iñooña,’ ĩ nʉcʉbʉgorique manona apeye uniere cʉ áti rotiquẽja,” cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","To bairo Sataná caĩtobajupʉ Jesure, caroorijere cʉ cáto boobacʉ. Apeye cʉ caĩtope majiquetibacʉ cʉ cáaáweoyupʉ. “Ape rʉmʉ cʉ yʉ ĩtogʉ moquena caroorijere cʉ cátiparore bairo,” caĩ tʉgooñabajupʉ Sataná. ");
INSERT INTO tav_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Cabero Jesu camaja manopʉ cãnacʉ Galilea yepapʉ catunucoajupʉ. Seeto majuu Dio Espíritu Santore cʉgori catunucoajupʉ. Topʉre cʉ cabairijere camaja nipetiro caame buio jeja peticoajuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Topʉre to cãnacã maca na caneñapo buenucuri wiiripʉre camajare na cabuio jʉgoyupʉ Jesu. Nipetiro cʉ̃re caapirã caroaro cʉ caĩ wariñuu nʉcʉbʉgoyuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Cabero Nasarépʉ catunu ejayupʉ Jesu, cʉ cabʉtirica macapʉ. Topʉ eja, judío maja na yerijãrica rʉmʉ sábado cãno na caneñapo bueri wiipʉ cajãañupʉ. To bairo jeto cátinucuñupʉ ti rʉmʉ unore. To bairi ti wiipʉ jãa, cawamʉ nʉcañupʉ, Dio Wadariquere to cãnare bue apiogʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","To bairo cʉ cabairo Isaía, Dio ye quetire cabuiori majocʉ ãnacʉ cʉ caucariquere bue rotirã cʉ cajooyuparã Jesure. Jesu ti pũurore ne, pã maca, cʉ cabuegari paʉ bʉga átiri catʉjʉyupʉ. Isaía ãnacʉ cʉ caucariquere ocõo bairo na caĩ bue apio jʉgoyupʉ: ");
INSERT INTO tav_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dio Espíritu Santo yʉpʉ ãmi, cabopacarãre caroa quetire yʉre buio rotii. Catʉgooñarique pairãre na wariñuo joroque yʉ áti rotimi Dio. Presopʉ cãnare bairo cãnare na buu rotii yʉ joomi Dio. Noa cacape tʉjʉquẽnare tʉjʉrique nare yʉ joo rotimi Dio. Aperã rooro capopiyeye ecoorãre na yʉ mataboja rotimi Dio. ");
INSERT INTO tav_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","“Yucʉ Dio caroaro na átibojagʉmi,” camajare yʉ ĩ buio rotimi Dio. Tiere Isaía ãnacʉ Dio ye quetire cʉ caĩ ucariquere na caĩ bue apioyupʉ Jesu ti wiipʉ cãnare. ");
INSERT INTO tav_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na ĩ bue apio yaparo ti pũurore bʉgá, ti wii papera pũurire cacoteire cʉ tunuo joo, caejanumucoajupʉ moquena. Cʉ caejanumu áto seeto cʉ catʉjʉyuparã nipetirã. ");
INSERT INTO tav_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","To bairi ocõo bairo na caĩ buio jʉgoyupʉ Jesu: —Yucʉra mʉja caapiropʉ yʉ cabue apioeje cõo Isaía cʉ caĩ ucariquere bairona bai, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","To bairo caroaro Jesu cʉ cabuioro apirã caapi acʉacoajuparã. —¿Nope ĩi to cõo caroaro cʉ buio majiti mari mena cãnacʉ anibaopʉcʉna? José macʉna ãmi, caame ĩñuparã, Jesure nʉcʉbʉgogaquẽna. ");
INSERT INTO tav_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","To bairo na caame ĩrijere tʉjʉʉ ocõo bairo na caĩñupʉ Jesu: —Yʉre nʉcʉbʉgoquẽna ocõo bairi wame mari ñicʉ jãa na caĩnucurica wame, “ ‘Ʉcoyeri majocʉ, riayere canetoo majii mʉ cãmata mʉ majuuna mʉ cariaye cʉtiere netooña. Caroaro canetoo majii ãcʉmi, na ĩato ĩi to bairona ája.’ To bairi Capernaupʉ mʉ cáti iñooriquere jã queti apiwʉ. To bairi topʉ mʉ cátatore bairona atopʉ mʉ ya macapʉ quenare áti iñooña,” yʉre mʉja ĩrã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cabero na caĩnemowĩ Jesu: —Dio ye queti buiori majocʉre cʉ ya maca macana cʉ nʉcʉbʉgoquẽnama. ");
INSERT INTO tav_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tirʉmʉpʉre Elías cawamecʉcʉ Dio ye quetire buiori majocʉ cãñupʉ Israelpʉ. Cʉ cãni yʉteapʉ cawapearicarã romiri capãarã cãñuparã Israelpʉ. Ti paʉ cãno itia cʉma ape cʉma recomaca caocaquẽjupe. To bairi ʉgarique camañupe. Camaja cañigo tamʉoñuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","To bairi cawapearicarã romiri capãarã catamʉorã Israelpʉre na nibao joroquena Elíare na cátinemo rotiquẽjupʉ Dio. Ape macapʉ cãco jetore cátinemo rotiyupʉ Dio Elíare, Sidón cawamecʉtopʉ Sarepta macacore, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Apei moquena Eliseo Dio ye quetire buiori majocʉ cʉ cãni yʉteapʉ to bairona cabaiyupe. Israelpʉ capãarã caajeri boarã cãñuparã. Israelpʉ capãarã na nibao joroquena Eliseo na riayere na canetoobojaquẽjupʉ. Ape yepa macacʉre Siria macacʉ jetore cʉ cariarije cʉ canetoobojayupʉ Eliseo, na caĩ buioyupʉ Jesu ti wiipʉ cãnare. ");
INSERT INTO tav_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","To bairo cʉ caĩro apirã ti wii neñapo buerica wiipʉ cãna seeto cʉ capunijiniñuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","To bairi cʉ punijinirã Jesure cʉ cañecoajuparã. Cʉ ñe, na cãni maca tʉjaropʉ ʉ̃taʉ buipʉ cʉ ne aá, cʉ catune roca ñoogabajuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Cʉ na catune roca ñoogari paʉna Jesu maca camajiña manona na watoapʉ cáaá netocoajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cabero Jesu cáaácoajupʉ moquena Capernaupʉ, Galilea yepapʉ cãni maca. Topʉ ãcʉ to cãnacã semana judío maja na yerijãrica rʉmʉri sábado cãno to macanare Dio yere na cabuionucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Caroti majiire bairo na cabuioyupʉ. To bairi caapi acʉacoajuparã to macana. ");
INSERT INTO tav_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na neñapo buerica wiipʉ jĩcaʉ cayeri wãticʉcʉ cãñupʉ. To bairi Jesure seeto cʉ caĩ awajayupʉ cʉ̃a: ");
INSERT INTO tav_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesu, Nasaré macacʉ! ¡Jã patawãcooqueticõaña! ¿Jãre rei acʉ́ mʉ bairi? Mʉre yʉ maji. Mʉa Dio Macʉ majuu caroaʉ cʉ cajooricʉ mʉ ã, cʉ caĩ awajayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","To bairo cʉ caĩrona Jesu maca ocõo bairo caĩ tutiyupʉ wãtire camajocʉpʉre cajañaʉre: —¡Janacõaña! ¡Cʉ buti aácʉja! To bairo cʉ caĩrona camajocʉpʉre wãti cʉ catune roca cũcõa buti aájupʉ, camaja nipetiro na catʉjʉropʉ. Wãti cʉ cabutiro bero camajocʉ jĩacã cami cʉtiquẽcʉ, cañuʉna cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","To bairo cʉ cañuuro tʉjʉrã Jesure catʉjʉ acʉacoajuparã camaja nipetirã. —¿Ñe unie wadarique to ãti atie cʉ cawadarije? Tie cʉ cawadarije menana acu buu majimi wãtia quenare. Nare cʉ cabuti rotiro nemoo buticoapa, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","To bairi ti maca tʉjarori macana nipetiro Jesu cʉ cátiere caqueti api peticoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu neñapo buerica wiipʉ cãnacʉ cabuti aájupʉ. Buti, Simón Pedro ya wiipʉre caejayupʉ. Topʉ cʉ caejaro Simón Pedro mañico seeto cabʉgoye riayupo. To bairi to cãna cabʉgoye riaore co cariarijere Jesure canetoo rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesu co tʉ ejanʉca, bʉgoyere cajana rotiyupʉ. Cʉ cajana rotirona, “¡Janaña!” cʉ caĩrona cajanacoajupe cõre cabʉgorije. Seeto cariabatacona yua wamʉnʉca átiri na caʉgarique peobojayupo Simón Pedro mañico yua. ");
INSERT INTO tav_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Muipʉ cʉ caroca jãari paʉ cãno camaja nipetiro na yarã ricatiri cariaye cʉnare na cajee ajuparã Jesu tʉpʉ. Na cãno cãnacãʉpʉrena na cañiga peoyupʉ Jesu cʉ wamo mena, na riaye netooʉ. ");
INSERT INTO tav_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Capãarã wãtia camajare cajañarã quenare na cabuuyupʉ Jesu. Nare cʉ cabuurona cʉ caĩ awajayuparã wãtia: —¡Mʉna Dio Macʉ mʉ ã! cʉ caĩ awajayuparã. Wãtia maca Dio cʉ cajooricʉ Jesu cʉ cãniere camajicõañuparã. To bairi Jesu maca na jana rotiri na cawada rotiquẽjupʉ wãtiare yua. ");
INSERT INTO tav_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ape rʉmʉ cabujuri paʉ yopi, maca tʉjaropʉ camaja na camanopʉ cáaájupʉ Jesu. To bairo cʉ cabairo camaja capãarã cʉ maca, cʉ caʉja ejayuparã. Aperopʉ cʉ cáaá rotigaquetibajuparã. ");
INSERT INTO tav_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","To bairo na caĩbao joroquena: —Ape macari macana quenare Ʉpaʉ Dio cʉ cãnie quetire na cabuiopaʉ yʉ ã. To bairo na buioya ĩi, yʉ cajoowĩ Dio, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","To bairi cabuionemo ʉjaajupʉ Jesu judío maja na cãni macaripʉre na neñapo buerica wiiripʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jĩca rʉmʉ Jesu Genesaret cawamecʉti ra tʉjaropʉ cãñupʉ. Topʉ cʉ cãno camaja capãarã caejayuparã, Dio ye quetire cʉ cabuioro apigarã. Cʉ apigarã seeto cʉ tujaroacã cãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pʉga cumua camaja manie catʉjʉyupʉ Jesu ti ra tujaro capajarijere. Na bapi yucʉre cojerã cájuparã ti cumuari ʉparã. Wai jĩari wapatari maja cãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","To bairi camaja capãarã cʉ tujaroacã majuu na cãno tʉjʉri jĩca cumua Simón cawamecʉcʉ ya cumuapʉre caeja jãañupʉ. Eja jãa, cʉ cañu wio rotiyupʉ Jesu Simóre. Ti cumuapʉ jañari camaja petapʉ catʉjʉnucurãre na caqueti buioyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na buio yaparo Simóre cʉ caĩñupʉ: —Carecomacapʉ we wio joori mʉja bapire roca ñuaña, wai jĩagarã, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","To bairo cʉ caĩro: —Jãre camajioʉ, mepʉ macá ñamire jã áti bujucoabapʉ, wai jĩagarã. Na jã bʉgaquẽpʉ, cʉ caĩñupʉ Simón. —To bairo cátiena nibaopʉnana mʉ caĩrore bairo yʉ átigʉ. Bapi yucʉre yʉ roca ñuagʉ, Jesure cʉ caĩñupʉ Simón Pedro. ");
INSERT INTO tav_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","To bairi na bapi yucʉre caroca ñuañuparã. Na caroca ñuarona wai capãarã majuu cajãañuparã. Capãarã majuu na cajãroi bapi yucʉ woogaropʉ cabaiyupe. ");
INSERT INTO tav_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","To bairi wai capãarã majuu na cajãaro tʉjʉrã, na yarãre ape cumuapʉ cãnare na cabʉgá piyuparã, bapire jã ne mʉgonemorã ajá ĩrã. To bairo na cáto caejayuparã na cabʉgá pijorã. Eja, waire na cajʉ jeenemoñuparã. Pʉga cumuapʉna cajira ruaboyupe yua. ");
INSERT INTO tav_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","To bairo cabairijere catʉjʉ acʉacoajuparã Pedro, cʉ mena macana. Sebedeo punaa — Jacobo, cʉ bai Juan — Pedro mena waire cajĩanemonucurã cãñuparã. To bairi Pedro acʉa tʉjʉʉ Jesu tʉ rʉpopatuapʉ numu cumuri cʉ caĩñupʉ Simón Pedro: —Yʉ Ʉpaʉ, carooʉ yʉ ã yʉa. To bairi yʉre bapa cʉtiqueticõaña. Jesure cʉ tʉjʉ acʉa bobori cʉ caĩñupʉ. To bairi Jesu maca Pedro, “Yʉre bapa cʉtiqueticõaña,” cʉ caĩro apii cʉ caĩñupʉ: —Yʉre bobo tʉgooñaquẽja. Yucʉacãre wai jĩarique caroaro camajii mʉ ã. Atie bero yʉ ye quetire cabuio majii mʉ anigʉ. To bairo camajare na mʉ caĩ buioro yʉre apipajeegarãma, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","To bairi pã atí, roca tu, na cumuarire, na apeye unie nipetiro cáaáweocoajuparã, Jesure cʉ ʉja aána yua. ");
INSERT INTO tav_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cabero ape macapʉ Jesu cʉ cãno jĩcaʉ seeto rupaʉna caajeri boaʉ cʉ catʉjʉyupʉ Jesure. Jesure cʉ tʉjʉ, cʉ tʉpʉ eja, rʉpopatuapʉ canumu cumu nʉcʉbʉgoyupʉ. —Yʉ Ʉpaʉ, yʉ caboarijere caroaro mʉ yaá majii. To bairi mʉ cabooata yʉre mʉ netoo catiogʉ, bopacooro cʉ caĩ jeniñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","To bairo cʉ caĩro apii Jesu cʉ wamore ñu peo, cʉ capañañupʉ: —Mʉ caboarijere yʉ netoogʉ. To cõona mʉ caboarije yaticoagaro, cʉ caĩñupʉ. To bairo cʉ caĩ pañarona nemoo cʉ caboarije cayaticoajupe yua. ");
INSERT INTO tav_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","To bairi cʉ pañari bero ocõo bairo cʉ caĩñupʉ Jesu: —Mʉ canetorijere aperãre na buioquẽja mai. Cariapena aácʉja Dio wii macacʉ sacerdote majocʉ tʉpʉ. Aá, caboarique mʉ cayatirijere cʉ iñooña. Cʉ iñoo, topʉ Moisé ãnacʉ cʉ cajoo rotiriquere apeye uniere Diore cʉ jooya. To bairo mʉ cáto to cõona mʉ canetorijere mʉ tʉjʉ majigarãma camaja, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ati wame bero nipetiropʉ Jesu cʉ cátie queti cajejacoajupe. Tie quetire apirã camaja capãarã Jesu tʉpʉ caejayuparã. Jĩcaarã cʉ cabuiorijere apigarã, aperã na riayere cʉ netoo rotigarã cʉ tʉpʉ caejayuparã. ");
INSERT INTO tav_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","To bairo na cátibao joroquena Jesu maca cʉ Pacʉ Diore jeni nʉcʉbʉgoʉ camaja na camanopʉ nairoacã cáaánucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jĩca rʉmʉ Jesu camajare cʉ cabuioro fariseo maja quena, aperã judío majare cabuerã quena cʉ catʉjʉ ruijoyuparã. To cãnacã maca macana cáatána cãñuparã. Galilea yepapʉ cãni macari macana, Judea yepapʉ cãni macari macana, Jerusalén macana cãñuparã. Na catʉjʉ ruijori paʉ Jesu cariaye cʉnare na catioʉ cájupʉ. Dio cʉ camajirije mena cájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","To bairo na cʉ cáti ãno aperã cáaá majiquẽcʉre cʉ cayo neajuparã. To bairo Jesu cʉ cáti ani wiipʉ cʉ cane jãagabajuparã, Jesu tʉpʉ cʉ cũgarã. ");
INSERT INTO tav_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Camaja capãarã na cãnoi cʉ cane jãa majiquẽjuparã. To bairi wii bui cʉ yo ne wamʉ aá, oco juurica pãiri na capeoriquere jĩca jope jee woo átiri, cʉ cayojaricaro menana cʉ cayo ruio jooyuparã Jesu tʉpʉ, camaja watoapʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","To bairo cʉ na cáto, “Mari yaʉre catio majiimi,” cʉ na caĩ tʉgooña nʉcʉbʉgorijere camajiñupʉ Jesu. Cʉ na caĩ tʉgooña nʉcʉbʉgorijere majii ocõo bairo caĩñupʉ Jesu cáaá majiquẽcʉre: —Caroorije mʉ cátajere majiritioʉ yʉ áa, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To bairo cʉ caĩro apirã judío majare cabuerã fariseo maja quena ocõo bairo caĩ tʉgooñañuparã Jesure: “¿Nope ĩi rooro Dio cʉ caapi tʉjooquẽtiere cʉ ĩti? Cʉ̃a manire baii camajocʉ cãcʉna caroorije camaja na cátiere na majiritioboja majiquẽemi. Dio jĩcaʉna ãmi camaja caroorije na cátiere camajiritioboja majii,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","To bairo na caĩ tʉgooñarijere majiri ocõo bairo na caĩñupʉ Jesu: —¿Nope ĩrã to bairo yʉ mʉja ĩ tʉgooñati? na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","—Cáaá majiquẽcʉre, “Caroorije mʉ cátiere majiritioʉ yʉ áa,” cʉ yʉ caĩro, “Jocʉna ĩmi,” mʉja ĩrã. “Wamʉnʉcacoa aácʉja,” cʉ yʉ caĩata cʉ riaye to canetoro yʉ catutuarijere mʉja tʉjʉ majigarã. To bairi mʉja catʉjʉro cʉ riayere yʉ netoogʉ. Cʉ yʉ canetooro camaja caroorije na cátajere na yʉ camajiritioboja majirijere mʉja tʉjʉ majigarã. “Dio Macʉ camaja tʉpʉ Dio cʉ cajooricʉ caroorije camaja na cátajere na majiritioboja majimi,” yʉre mʉja caĩ majiparore bairo ĩi, cʉ yʉ netoogʉ, na caĩñupʉ Jesu. To bairo na ĩ, ocõo bairo cʉ caĩñupʉ Jesu cáaá majiquẽcʉre: —Wamʉnʉcacõaña. Mʉ yojaricarore ne, aácʉja mʉ ya paʉpʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","To bairo cʉ caĩrona cáaá majiquetibatacʉ wamʉnʉca, cʉ cayojaricarore ne, cáaácoajupʉ cʉ ya wiipʉ aácʉ. —¡Ñuu majuucõa! Diore cʉ caĩ wariñuuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ti wiipʉ cãna to bairo cʉ cañuuro tʉjʉrã catʉjʉ acʉacoajuparã. —Yucʉacã mari tʉjʉwʉ catʉjʉñaña maniere. Dio cʉ cátie ñuu neto majuucõa, caĩ wariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cabero ti paʉ cãnacʉ buti aá, Leví cawamecʉcʉre catʉjʉyupʉ Jesu. Leví maca camaja yere gobiernore niyeru jeebojari majocʉ cãñupʉ. To bairi cʉ capaari arʉapʉ cʉ caruiro Jesu cʉ tʉjʉ bʉga: —Yʉ mena ajá, cʉ caĩñupʉ Levíre. ");
INSERT INTO tav_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","To bairo cʉ caĩro apii cʉ ye cʉ paarique nipetiro cacũ aáweocoajupʉ, Jesu mena aácʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Cabero Leví cʉ ya wiipʉre ejaʉ Jesure boje rʉmʉ cʉ cátibojayupʉ. To bairi Levíre bairona capaariquecʉna camaja yere gobiernore niyeru jeebojari maja na yarã mena caejayuparã. Eja, boje rʉmʉ ʉgariquere na caʉganemoñuparã. ");
INSERT INTO tav_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","To bairo cabairã mena Jesu cʉ caboje ʉgaro tʉjʉrã fariseo maja, judío majare cabuerã ocõo bairo na caĩ tutiyuparã Jesu cʉ cabuerãre: —¿Nope ĩrã camaja yere gobiernore niyeru jeebojari maja, aperã caroorã mena mʉja bapacʉti ʉganucuti? ");
INSERT INTO tav_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","To bairo na caĩ tutiro apii ocõo bairo na caĩñupʉ Jesu maca: —Ʉcoyeri majocʉ cariaye manare na ʉcoyequẽcʉmi. Cariayecʉna jetore na ʉcoye majimi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","—To bairona, “Cañuurã jã ã,” caĩrãre na átinemoʉ acʉ́ mee yʉ cáapʉ́. Caroorã macare caroorije na cátiere jʉtiriti rotii yʉ cáapʉ́. Rooro na catʉgooñarijere na wajoa rotii acʉ́ yʉ cáapʉ́, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Cabero aperã Jesure cʉ caĩ jeniñanemoñuparã moquena: —Juan bautisari majocʉ cʉ cabuerã nairoacã ʉgaquẽnana Diore jeni nʉcʉbʉgonucuma. Fariseo maja na cabuerã quena to bairona nairoacã bainucuma. Mʉ cabuerã maca baiquetinucuma. Na maca ʉga, eti, áticõa aninucuma, caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","To bairo na caĩro: —Jĩcaʉ cʉ cawamo jiari boje rʉmʉ cãno cʉ mena macana tʉgooñarique pairi ʉgaqueti bai majiquẽnama na mena cʉ cãnoi. ");
INSERT INTO tav_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ape rʉmʉ aperã maca to cõona aperopʉ cʉ̃re na cañe aápata tiere tʉgooñarique paibana ʉgaqueti baiborãma. Mai Jesu cʉ cabuerã cʉ mena ãnaa na caʉgaqueti tʉgooñarique paiquẽtiere na ĩ buio majioʉ, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ape wame queti buio majiorica wame na caĩ buioyupʉ Jesu moquena. Cʉ ye quetire fariseo maja jãa jocarãna na caĩ buiorije mena catʉgooña ajuquetipe ã ĩi, ocõo bairo na caĩ buiowĩ: —Camajoco jutiiro cawamaro cajañaña manore woo nequẽcomo cabʉcʉrore e tuugo. To bairo co cápata cawamaro quena ope cʉtiboro. Co cawoo nebata ajero ape jutiiro cabʉcʉro mena caroaro tʉjooquetiboro, na caĩñupʉ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Vino ʉje oco etirique cawama mʉja cátiere cabʉcʉ poa wecʉ ajero poare mʉja pio jãquẽna. Cabʉcʉ poapʉ mʉja capio jãata woocoaboro. Vino etirique pio recoaboro yua. ");
INSERT INTO tav_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vino etirique cawama mʉja cátiere cawama poapʉ mʉja pio jãnucu, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Vino ʉje oco cabʉcʉ macajere caetirã aperã cawama na cátiere booquẽnama. “Cabʉcʉ macaje ñuubʉja. Apeye jã etiquẽe,” ĩborãma. To bairona na caĩñupʉ Jesu, “Mʉja ya wame cabʉcʉ wame jetore mʉja boo, yʉ ye queti cawama wamere mʉja apigatee,” na ĩi. ");
INSERT INTO tav_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ape rʉmʉ sábado, judío maja na yerijãrica rʉmʉ cãno trigo wejeri recomacapʉ caneto aájupʉ Jesu cʉ cabuerã mena. Neto aánana trigo apere tune jee átiri, cajĩque poo ʉga aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","To bairo na cáti ʉga aáto na catʉjʉyuparã fariseo maja. Na tʉjʉri, ocõo bairo na caĩñuparã: —¿Nope ĩrã Moisé ãnacʉ yerijãrica rʉmʉ cãno cʉ cáti rotiquetajere paarique mʉja áati? na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","To bairo na caĩro Jesu maca ocõo bairo na caĩñupʉ: —Ʉpaʉ David ãnacʉ cʉ mena macana mena ñigo riabana na cátajere mere mʉja bue tʉgaricarã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","—David Dio wiipʉre jãa áti, ñigo riabacʉ cajawa bui capejarijere ʉgarique rupaare Diore cʉ na cajoobatajere jee, ʉga átiri, cʉ mena macanare tiere na canuñupʉ. Dio wii macana sacerdote maja jetore na caʉga rotirije cãnibajupa. David, cʉ mena macana sacerdote maja aniquetibaopʉnana Moisé ãnacʉ na unare cʉ caʉga rotiquetajere caʉgayuparã, na caĩñupʉ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","—Yʉa Dio Macʉ camaja tʉpʉ Dio cʉ cajooricʉ, caroti majii aniri yerijãrica rʉmʉ cãno cátipe quenare carotii yʉ ã yʉa, na caĩñupʉ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ape rʉmʉ moquena sábado rʉmʉ, judío maja na yerijãrica rʉmʉ cãno Jesu neñapo buerica wiipʉ cajãa aájupʉ. Jãa, topʉ cãnare Dio Wadariquere na cabuioyupʉ. Topʉ cãñupʉ jĩcaʉ camajocʉ cariape nʉgoa macare cawamo rooye tuaricʉ. ");
INSERT INTO tav_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Judío majare cabuerã, fariseo maja mena Jesure seeto cʉ catʉjʉ pojerooyuparã. “Jesu anire cawamo rooye tuaricʉre yucʉ yerijãrica rʉmʉ to nibao joroquena cʉ̃re cʉ canetooata ʉparãpʉre cʉ mari wadajãcõagarã,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","To bairo cʉ na caĩ tʉgooñarijere camajicõañupʉ Jesu. To bairi cawamo rooye tuaricʉ macare ocõo bairo cʉ caĩñupʉ Jesu: —Wamʉnʉcacõaña. Yʉ tʉ maca adʉja. To bairo cʉ cʉ caĩro wamʉnʉcari cʉ tʉ caeja nʉcañupʉ cawamo rooye tuaricʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","To bairo cʉ cabairo rooro cʉ̃re caĩ tʉgooñarãre na caĩñupʉ Jesu: —¿Nope ĩrã to bairije mʉja ĩ tʉgooñati? Tʉgooñañaja. ¿Yerijãrica rʉmʉ cãno caroa wame aperãre cʉ átiboja rotiti Dio? O ¿caroorije macare cʉ áti rotiti que? ¿Yerijãrica rʉmʉ cãno aperãre mari cʉ catio rotiti? o ¿na jĩaña cʉ ĩti? na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","To bairo na ĩ, cʉ̃re catʉjʉ pojeroorãre na tʉjʉ peti, cawamo rooye tuaricʉre: —Mʉ wamore ñupoya, cʉ caĩñupʉ. To bairo cʉ̃re cʉ caĩrona cʉ wamore cañupoyupʉ. Cʉ cañuporona cʉ wamo cañuucoajupe. ");
INSERT INTO tav_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","To bairo cabairo tʉjʉrã judío majare cabuerã, fariseo maja jãa Jesure seeto cʉ capunijiniñuparã. Cʉ punijiniri: —¿Dope bairo cʉ mari áti wadajãcʉti? ʉparã cʉ na jĩa rocacõato ĩrã caame ĩ wadapeniñuparã. ");
INSERT INTO tav_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ape rʉmʉ ʉ̃taʉpʉ cáaácoajupʉ Jesu, Diore cʉ jeni nʉcʉbʉgoʉ aácʉ. Ti ñami Diore cajeni nʉcʉbʉgo bujucoajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ape rʉmʉ cabujuri paʉ cãno na capijoyupʉ cʉ cabuerãre. Na pijori na cabejeyupʉ doce cãnacãʉpʉrena, yʉ ye quetire cabuionemorã mʉja anigarã na ĩi. ");
INSERT INTO tav_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simóre cʉ cabejeyupʉ. Ape wame Pedro cʉ caĩñupʉ Simóre. Simón Pedro bai André quenare cʉ cabejeyupʉ. Apei Jacobo, apei Juan, apei Felipe, apei Bartolomé, ");
INSERT INTO tav_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","apei Mateo, apei Tomás na cabejeyupʉ. Apei Alfeo macʉ Jacobo quenare cʉ cabejeyupʉ. Apei Simón cananista ya poa macacʉre cabejeyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Apei Jacobo yaʉ Juda quenare cʉ cabejeyupʉ Jesu. Apei Judas Iscariote quenare cʉ cabejebajupʉ. Jesure cʉ cajĩaparãre cawadajãpaʉ cãñupʉ cʉ̃a. To cãnacãʉ cãñuparã Jesu cʉ cabejericarã cʉ ye quetire cabuionemoparã. ");
INSERT INTO tav_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Jesu na beje yaparo ʉ̃taʉ buipʉ cãnacʉ cʉ cabuerã mena rui atí, ti ʉ̃taʉ pʉto cãni yepapʉ na mena caejayupʉ. Cʉ carui ejaro camaja capãarã cʉ cacote tʉjʉnucuñuparã, cʉ cabuiorijere apigarã, na riayere Jesure cʉ netoo rotigarã. Judea yepa macana, Jerusalén macana, aperã capairi ya tʉjaro macá macari macana Tiro, Sidón cawamecʉti macari macana Jesure cʉ cacote tʉjʉnucuñuparã. Jesu cayeri wãtiacʉna quenare na canetooñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","To bairo cʉ cáti majirije mena cariayecʉna nipetirãre cʉ canetooro tʉjʉrã aperã cariarã quena cʉ capañagabajuparã, “Cʉ yʉ capañarona yʉ riaye netogaro,” ĩ tʉgooñari. ");
INSERT INTO tav_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Cʉ cabuiorijere caapipajeerãre na tʉjʉri ocõo bairo na caĩñupʉ Jesu: —Yucʉacãre cabopacarã mʉja ã. To bairo mʉja baibao joroquena Dio mʉja Ʉpaʉ aniri wariñuurique macare mʉja joogʉmi, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Yucʉacãre mʉja ñigo ria. Cabero cãni wariñuu yapirã mʉja anigarã. ’Yucʉra catʉgooñarique pairã mʉja ã. Caberopʉre caepe wariñuurã mʉja anigarã. ");
INSERT INTO tav_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Yʉre canʉcʉbʉgo ʉjarã mʉja cãnoi camaja mʉjaare tʉjʉtee, mʉja buu regarãma. “Caroorã ãma,” mʉja ĩ tutiri mʉja peju cʉtigarãma. To bairo mʉja na caĩbao joroquena mʉja wariñuugarã. ");
INSERT INTO tav_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","To bairo rooro mʉja na cabaibao joroquena seeto wariñuuña. Capee cañuurijere mʉja joogʉmi Dio jõ buipʉ. To bairo mʉja na cátore bairona cájupa na ñicʉ jãa quena Dio ye quetire buiori maja ãnanare, na caĩñupʉ Jesu cʉ̃re caapipajeerãre. ");
INSERT INTO tav_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aperã pairo caapeye cʉgorã macare ocõo bairo na caĩñupʉ Jesu: —Mʉjaa ati yepapʉre ãnaa pairo apeye uniere mʉja cʉgotʉga. Caberopʉ rooro baigaro mʉjaare, na caĩñupʉ Jesu pairo cacʉgorãre. ");
INSERT INTO tav_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Yucʉre ati yepa ãnapʉ caʉga yapirãre bairona mʉja ani wariñuutʉga. Caberopʉ rooro mʉjaare baigaro. Mʉja ñigo tamʉogarã, na caĩ buioyupʉ Jesu. —Mʉjaa yucʉacãre seeto caepe wariñuurã mʉja ã. Caberopʉ ñuuquẽto tamʉobana caotirã mʉja anigarã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Tirʉmʉpʉ Dio Wadariquere cabuiotorãre, “Caroaro, cariape buioma,” na caĩbajupa camaja. Yucʉ mʉja quenare to bairona ĩma na pãramerã quena. Jocarãna Dio Wadariquere na mʉja cabuiorije to nibao joroquena, “Caroaro, cariape buioma,” mʉja ĩnucuma mʉja quenare. Caberopʉ rooro mʉjaare baigaro, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ocõo bairo yʉre caapirãre mʉñʉja ĩ buiogʉ: Mʉjaare catʉjʉ tutirãre na maiña. Mʉjaare cateerã quenare caroaro na ája, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","—Rooro mʉjaare cawada pairã quenare, “Caroaro mʉjaare to baiato,” na ĩnucuña. Caroorije mʉjaare cána na cãnibao joroquena na cãnipere Diore na jenibojaya. ");
INSERT INTO tav_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jĩcaʉ mʉjaare jĩca nʉgoa cʉ cawajopana paata ape nʉgoa quenare cʉ wajopana pa rotiya moquena. Jĩcaʉ mʉ jutiiro bui macatore cʉ catu we neata mʉ camisa quenare cʉ jooya, tiere cʉ cabooata. ");
INSERT INTO tav_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nii jĩcaʉ mʉjaare cʉ cajenirore cʉ jooya. Aperã mʉja yere na cajeero, “Jã tunuo joocõaña,” na ĩ tutiquẽja. ");
INSERT INTO tav_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aperã caroare mʉjaare na cátipere boorã caroaro na áti ameña. ");
INSERT INTO tav_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mʉjaare camairã jetore na mʉja camaiata, “Caroaro camairã mʉja ã,” mʉja ĩquẽcʉmi Dio. Caroorã quena to bairona na mena macanare na maima. To bairi aperã mʉjaare camaiquẽna na cãnibao joroquena na maiña mʉja maca. ");
INSERT INTO tav_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mʉjaare caroaro cána jetore caroaro na mʉja caame ápata, “Aperãre caroaro cána ãma,” mʉja ĩquẽcʉmi Dio. Caroorã quena to bairona caroaro ame áama caroaro na cánare. To bairi mʉja maca mʉjaare caroorije cána quenare caroaro na mʉja cáto, “Caroaro cána majuu ãma,” mʉja ĩgʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mʉja apeye uniere wajorã, “Jã tunuocõagarãma,” ĩ tʉgooñaquetibaopʉnana na mʉja cajooro, “Caroaro cána majuu ãma,” mʉja ĩgʉmi Dio. “Jã tunuocõagarãma,” ĩ majiripʉ na wajoma caroorã quena. ");
INSERT INTO tav_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","To bairi mʉja maca, “Yoaro mee jã tunuocõagarãma,” ĩ majiquetibaopʉnana na wajocõaña. Caroaro aperãre na átinemoña. Mʉjaare catʉjʉ tutirã na nibao joroquena na maiña. To bairo mʉja cáto caroare capee mʉja joogʉmi Dio. Dio caroorã, cʉ caĩ wariñuuquẽna na nibao joroquena caroaro na áami. To bairi mʉja quena caroaro ája aperãre, mʉjaare catʉjʉtee tutirã na nibao joroquena. To bairo ána Dio cãni majuʉ punaa, cʉ̃re bairo cãna mʉja anigarã. ");
INSERT INTO tav_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mʉja quena aperãre na bopaca tʉjʉ maiña, mari Pacʉ Dio marire cʉ cabopaca tʉjʉ mairore bairona. ");
INSERT INTO tav_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Aperãre, “Rooro áama, na capopiyeyepe ã,” na ĩ batequeticõaña. To bairo mʉja caĩ batequẽpata, “Rooro áama, na capopiyeyepe ã,” mʉja ĩquetigʉmi Dio mʉja quenare. Aperã caroorije mʉjaare na cátiere majiritioya. To bairo mʉja cáto Dio quena majiritiogʉmi caroorije mʉja cátiere, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","’Aperã cacʉgoquẽnare na jooya. To bairo mʉja cáto mʉja quenare capee mʉja joogʉmi Dio. Mʉja cajoorije netoro mʉja joogʉmi. To bairi aperãre mʉja cátore bairo mʉja átigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","To bairo na ĩ yaparo Jesu atie queti buio majiorica wamere na caĩñupʉ. Cʉ yere cabooquẽna Dio Wadarique jocarãna na caĩ buiorijere cʉ cabuerãre na ĩ majioʉ ocõo bairo na caĩñupʉ: —Jĩcaʉ camajocʉ cacape mácʉ cʉ bapa quena cacape mácʉre, “Mʉ yʉ jʉgo tʉ̃ga aácʉpa,” cʉ̃re cʉ caĩata na pʉgarãpʉna opepʉre re jãacõarãma. ");
INSERT INTO tav_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jĩcaʉ camajii cʉ cabuerã cʉ netoro majiquẽnama. Nipetirã nare cʉ cabuero beropʉ to cõona nare camajioricʉre bairona camajirã anigarãma, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Ape wame queti buio majiorica wame na caĩñupʉ Jesu moquena: —¿Nope ĩrã mʉja yarãre, mʉja majuuna pairo caroorije átibaopʉnana, “Caroorije mʉja áa,” na mʉja ĩti? Mʉja majuuna caroorije áti janaña aperãre, “Caroorije mʉja áa,” na mʉja caĩparo jʉgoye. To bairi apeire, “Mʉ capeapʉ jitaacã cajañarijeacãre yʉ ne rocapa,” caĩrãre bairo mʉja ĩ, mʉja majuuna pairi pocaro mʉja cápeepʉre to cajañabato quena. To bairo mʉja caĩata jocarã majuu mʉja ĩborã. Mʉja majuuna mʉja cápeepʉ cajañari pocarore ne rocaya. Ne rocari bero caroaro tʉjʉ majirã apei cʉ capeapʉ jitaacã cajañarijeacãre mʉja ne rocaboja majigarã. To bairona apeire, “Ati wame caroorije áti janacõaña,” cʉ ĩgarã jʉgoye mʉja majuuna cʉ netoro caroorije mʉja cátinucurijere áti janacõaña. ");
INSERT INTO tav_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ocõo bairo na cabuioyupʉ Jesu moquena: —Jĩcaʉ yucʉ caroa caricacʉtii caroorije rica cʉtiquẽto. Apei yucʉ caroorije caricacʉtii caroa macare rica cʉtiquẽto. ");
INSERT INTO tav_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nipetirije yucʉre tie rica mena tʉjʉ majirique ã. Narañaʉ nibaopʉtona higo na caĩrije caroa caipitirije macare rica cʉtiquẽto. Pota miji wẽri quena ʉjena rica cʉtiquẽto. ");
INSERT INTO tav_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tiere bairona áama camaja quena. Camajocʉ cañuʉ cʉ yeripʉ caroa macaje cãno caroa wadami. Apei maca cʉ yeripʉre caroorije cãno caroorije wadami. To cãnacãʉpʉna na yeripʉ cãnie jetore wadama. ");
INSERT INTO tav_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Nope ĩrã, “Jã Ʉpaʉ,” yʉre ĩbaopʉnana yʉ carotiri wamere mʉja átiquẽeti? ");
INSERT INTO tav_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Noa yʉ tʉpʉ ejari yʉ cabuiorijere caapirã cabero tiere ána ocõo bairo cãnare bairo ãma: ");
INSERT INTO tav_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jĩcaʉ caroaro catʉgooñaʉ wii átigʉ pupeapʉ yejeari, ʉ̃ta rupaapʉ yejea ejari, ope átiri, cʉ wii botari nʉcoʉmi. Cʉ canʉcoro bero seeto caocaro, ria capairo, wino cáatíe quena ti wiire papu pĩa ñooquẽto. ");
INSERT INTO tav_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aperã maca yʉre apibaopʉnana yʉ cabuiorijere cátiquẽna ocõo bairo cácʉre bairona ãma na maca: Jĩcaʉ wii átigʉ ria tʉacã, pupeapʉ yejeaquẽcʉna wii ácʉmi, caroaro tʉgooñaquetibacʉ. Cʉ cáto bero ria pue paibato ti wiire oco pue tima pĩa yucõa jooboro, ñee rʉjaricaro mano. Cabairi wii caquenoʉre bairona ãma yʉ caĩrijere apibaopʉnana cátigaquẽna, caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu camajare cʉ cabuiogarijere buio yaparo Capernaupʉ cáaácoajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Topʉ cʉ caejaro romano yaʉ, polisía maja ʉpaʉ cãñupʉ. Cʉ paabojari majocʉ, aperã cʉ paabojari maja netoro cʉ camaii seeto cariabʉjayupʉ. Bai yajigʉpʉ cabaiyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesu cariaye cʉnare na cʉ cacatio majirijere caqueti apiyupʉ polisía maja ʉpaʉ. To bairi judío maja ʉparã cabʉcʉrã jĩcaarãre Jesure na capi roti jooyupʉ, “Yʉre capaabojari majocʉre cʉ catioʉ aparo,” ĩi. ");
INSERT INTO tav_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","To bairi cʉ capi roti joorã Jesu tʉpʉ ejarã ocõo bairo cʉ caĩ buioyuparã: —Cʉ̃a polisía maja ʉpaʉ cañuu majuʉ ãmi. To bairi mʉ cátinemopaʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Cʉ̃a judío majare caroaro mari maimi. Cʉ majuuna mari neñapo buerica wiire cáti rotiwĩ. To bairi cʉ cajeni jooriquere cʉ átibojaya, cʉ caĩ buioyuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","To bairo na caĩrije apii na mena cáaájupʉ Jesu. Polisía maja ʉpaʉ romano yaʉ cʉ ya wii tʉacã Jesure cʉ na cajʉgo tʉja ató tʉjʉri, ocõo bairo na caĩ jooyupʉ cʉ yarãre: —Ʉpaʉre seeto cʉ yʉ patawãcoogatee, cawatoa macacʉ aniri. To bairi yʉ ya wiipʉ cʉ yʉ jãa roti majiquẽe, cañuu majuʉ cʉ cãno maca. ");
INSERT INTO tav_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","To bairo quenare cʉ tʉ yʉ aá majiquẽe. Topʉna ãcʉna cʉ camaji wadarije mena yʉ paabojari majocʉre cʉ catioato, yʉ tʉpʉ ejaquẽcʉna. Cʉ cawadarije mena catigʉmi yʉ paabojari majocʉ. ");
INSERT INTO tav_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Apei ʉpaʉ yʉ rotimi. Yʉ quena polisía majare carotii yʉ ã. To bairi jĩcaʉ polisía yʉ ẽoro macacʉre, “Aácʉja,” cʉ yʉ caĩro aágʉmi. Apeire, “Adʉja,” cʉ yʉ caĩro atígʉmi. Yʉ paabojari majocʉre apeye uniere cʉ yʉ cáti rotiro yʉ átibojagʉmi. To bairi Jesu quena carotii aniri yʉ paabojari majocʉ cʉ cariaye cʉtiere cʉ netoo rotiato, yʉ tʉpʉ ejaquẽcʉna, caĩ jooyupʉ cʉ yarãre Jesure. ");
INSERT INTO tav_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","To bairo cʉ caĩ buio joorijere apii Jesu seeto caapi acʉayupʉ. Api acʉa, cʉ̃re caʉjarãre amejore nʉca, na tʉjʉ, ocõo bairo na caĩñupʉ: —Cariape mʉñʉja ĩ buio. Cʉ̃a romano yaʉ seeto yʉre catʉgooña nʉcʉbʉgoʉ ãmi. Cʉ̃re bairo caroaro yʉre catʉgooña nʉcʉbʉgorã maama Israel macana, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cabero Jesure caqueti buiora aátana romano yaʉ ya wiipʉ tunu ejarã cariaricʉ mere cañuʉpʉre cʉ caejayuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesu polisía maja ʉpaʉ cʉ capaabojari majocʉre cʉ canetooro bero macá rʉmʉ cãno Jesu cáaácoajupʉ Naí na caĩri macapʉ cʉ cabuerã mena. Topʉ cʉ cáaáto camaja capãarã cʉ caʉja aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti maca tʉ na catʉja aáto camajocʉ cabai yajiricʉ maja potire cane aájuparã, cʉ yaara aána. Cawapearico macʉ jĩcaʉna cãnibatacʉ cãñupʉ. Capãarã ti maca macana co mena cáaájuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesu cõre co tʉjʉʉ seeto co cabopaca tʉjʉyupʉ. —Otiquẽja, co caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","To bairo co ĩ, maja poti tʉpʉ ejanʉca, ti potire capañañupʉ, cabai yajiricʉre cʉ catiogʉ. To cõona cʉ ãnacʉre cayaara aábatana catua nʉcacõañuparã. Na catua nʉcarona: —Wamʉ nʉcacõaña, cʉ caĩñupʉ Jesu cʉ ãnacʉre. ");
INSERT INTO tav_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","To bairo cʉ caĩro cabai yajicoatacʉ nibaopʉcʉna wamʉnʉca, cawada jʉgoyupʉ moquena. To bairo cʉ tunu catio áticõari cʉ pacore, “Ʉ̃jʉ, mʉ macʉ catíbʉjami,” co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","To bairo cʉ̃re cʉ cáti catiorijere tʉjʉrã nipetirã catʉjʉ acʉacoajuparã. —Dio ye quetire buiori majocʉ majuu mari tʉpʉ ejami. Dio yarãre marire átinemoʉ acʉ́ ájupi, caĩ wariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","To bairi camaja nipetiro Judea yepapʉre, Judea yepa tʉjarori macana camajocʉ cabai yajiricʉre Jesu cʉ catunu catiorijere caqueti api peticoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesu cʉ cátiere cʉ cabuio peocõañuparã Juan bautisari majocʉre cʉ cabuerã presopʉ cʉ cãno. ");
INSERT INTO tav_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","To bairo Jesu cʉ cátiere cʉ na cabuioro apii Jesure cajeniña roti jooyupʉ Juan cʉ cabuerã pʉgarãre: —“Dio joogʉmi jĩcaʉ camajare na cátinemopaʉ na caĩricʉ, ¿mʉna mʉ ãti? o ¿apei maca jã cayuupaʉ cʉ ãcʉati?” Jesure cʉ ĩ jeniñaña, na caĩ jooyupʉ Juan cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","To bairi Juan cʉ cajeniña rotiricarã Jesu tʉpʉ eja: —¿Mʉna mʉ ãti, “Dio joogʉmi camajare na cátinemopaʉ,” na caĩricʉ? o ¿apei maca cʉ ãcʉati que? cʉ caĩ jeniñañuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","To bairo cʉ̃re na cajeniñari paʉre Jesu camaja cariaye cʉnare na catio ãcʉ cájupʉ. Cayeri wãtia jañarãre na reboja ãcʉ cájupʉ. Cacape tʉjʉquẽnare na tʉjʉ majio joroque cáti ãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","To bairi Juan cʉ cajooricarã Jesure na cajeniñaro ocõo bairo na caĩ yʉyupʉ Jesu: —Nipetiro yʉ cáto mʉja catʉjʉrijere, mʉja caapirijere Juãre cʉ buiorã aája. “Cacape tʉjʉquetibatana yucʉra catʉjʉrã ãma. Cáaáquetibatana quena cáaá majirã ãma yua. Caajeri boabatana quenare yaticoapa. Caapiquetibatana quena caapi majirã ãma yucʉra. Cabai yajiricarã anibaopʉnana tunu catima,” cʉ ĩ buioya Juãre. “Bopacooro cabairicarã Dio ye quetire apima na cʉ cabuioro. ");
INSERT INTO tav_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","To bairi caroaro wariñuurã anigarãma yʉre caapipajeerã, ‘Jocʉna ĩmi,’ yʉre caĩ tʉgooñaquẽna,” ĩmi Jesu, Juãre cʉ ĩ buiorãja, na caĩñupʉ Jesu, Juan cʉ cajeniña roti jooricarãre. ");
INSERT INTO tav_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan cʉ cajeniña roti jooricarã na cáaáto bero camaja pato to cãnare ocõo bairo na caĩ buioyupʉ Jesu Juan cʉ cãnajere: —Camaja na camanopʉ Juãre mari tʉjʉrã aáparo ĩrã, ¿Ñamʉ ũcʉre mari tʉjʉgarã, mʉja caĩ tʉgooñari? “Cauwioʉ, catʉgooñarique mácʉ yeru cʉ̃ oó wino capapuro cawãre tʉjʉnucurore bairo cãcʉre mari tʉjʉgarã,” mʉja caĩ tʉgooñaquetana. Catʉgooña ocabʉti majuʉ ãmi Juan. ");
INSERT INTO tav_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","To bairo quenare caroa jutii jañaricʉ cãcʉre camaja mani paʉpʉ mari tʉjʉrã aágarã mʉja caĩ tʉgooñaquetana. Caroa jutiire cajañarã, capee apeye uniere cacʉgorã caʉparã tʉpʉ maca ãnama. Nare bairo cabaii me ãmi Juan. ");
INSERT INTO tav_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","To bairi, “Camaja mani paʉpʉ jĩcaʉ Dio ye quetire cabuioʉ macare mari tʉjʉrã aágarã,” mʉja ĩ tʉgooñaricarã. Aperã Dio ye quetire buiori maja ãnana netoro cãcʉ ãmi Juan, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","—Juan jʉgoyepʉ macana ãnana Dio ye quetire buiori maja Juan cʉ cabaipere ocõo bairo caĩ ucayupa: Camajare na canetoo catiopaʉ jʉgoye yʉ joogʉ jĩcaʉ yʉ ye quetire cabuio jʉgoyeyepaʉre. Camaja na yerire caroaro tʉgooña quenoo yuu rotigʉmi. To bairona na caĩ ucaricʉna ãmi Juan. ");
INSERT INTO tav_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jĩcaʉ maca Juan netoro cãni majuʉ maami ati yepapʉre. To bairo to baibao joroquena cawatoa cãna quena Dio tʉpʉre ãnaa Juan netoro cãni majuurã anigarãma, na caĩ buioyupʉ Jesu. Cawama wame Jesu ye quetire caapipajeerã maca Juan netoro cãna anigarãma ĩi, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","To bairo Jesu cʉ caĩ buiorijere caroaro caapiyuparã camaja capãarã gobiernore camaja yere niyeru jeebojari maja quena. Juan cʉ cabautisa rotiricarã aniri caroaro caapiyuparã Jesu cʉ caĩrijere. To bairi, “Cariape áami Dio,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo maja, aperã judío majare cabuerã Juãre cʉ cabautisa rotiquetana cãñuparã na maca. To bairi Dio na cʉ cátibojagari wamere cabooquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu yua ocõo bairo caĩ buioyupʉ moquena: —Ati yʉtea macana camaja Juãre catʉjʉ teericarã yʉ quenare tʉjʉ teebʉjama. Caroa quetire apigaquẽna ocõo bairo ãma: ");
INSERT INTO tav_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cawimarã macá recomacapʉ caruirã na mena macana mena epegabana na ĩ pi awajarãma: “Jã caperuu putiro, ‘Jã mena bajaya,’ jã caĩrije to nibao joroquena jã mena mʉja bajagaquẽpʉ. Tʉgooñarique pai eperique tõroari mena jã cabaja epero quenare mʉja ĩ epenemogaquẽpʉ, ‘Mʉja ya wamere jã epegateebʉja,’ ĩrã.” To bairona cawimarã, “Jã caĩri wamere jã mena epeya,” caame ĩbanare bairona baima ati yʉtea macana. Caroa quetire apigaquẽna na majuuna na caĩ tʉgooñari wamere ame ĩ botioma. ");
INSERT INTO tav_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan bautisari majocʉ caroa ʉgarique caʉgaquetinucuwĩ, ʉje oco quenare caetiquetinucuwĩ. To bairo cʉ cabairo tʉjʉrã, “Cawãticʉcʉ, catʉgooña majiquẽcʉ ãcʉmi,” cʉ̃re mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Cʉ bero yʉ maca caroa ʉgariquere caʉganucuʉ, ʉje ocore caetinucuʉ yʉ ã. To bairo yʉ cabairo tʉjʉrã, “Caʉga pacaʉ, vinore caeti pacaʉ ãmi Jesu,” yʉre mʉja ĩ. “Cʉ mena macana caroorã ãma, gobiernore camaja yere caniyeru jeebojarã ãma,” mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Dio cʉ carotiro mena buiomi, cariape áami,” yʉre ĩ majigarãma Dio cʉ camajirijere catʉgooñarã maca, na caĩ buioyupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jĩcaʉ fariseo majocʉ Simón cawamecʉcʉ Jesure cʉ caʉga rotiyupʉ cʉ tʉpʉ. To bairi Jesu cʉ ya wiipʉ cajãa ejayupʉ. Jãa eja, cajawa tʉ caejanumuñupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti maca macaco cãromio jĩcao caroo cãñupo. Co maca fariseo majocʉ ya wiipʉ Jesu cʉ cajãa ejarijere queti apio caneajupo carupa rʉ alabastro cawamecʉti rʉ werica rʉ caroa cajʉti ñuurije cajañari rʉre. ");
INSERT INTO tav_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesu tʉ cane ejanʉcañupo ti rʉre. Jesu tʉ ejanʉca, caotiyupo. Co caotiro Jesu rʉporipʉ co cape oco care peayupe. To bairi tuatu, ejacumu nʉcʉbʉgori, cʉ rʉporire ñe, co cape oco care pearijere co poa ñapo mena Jesu rʉporire catu cojeyupo. Tu coje, cajʉti ñuurije co cajee atáje mena Jesu rʉporipʉre capio peóyupo yua. ");
INSERT INTO tav_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ti wii macacʉ fariseo majocʉ Simón cawamecʉcʉ Jesure caʉga rotiricʉ maca to bairo cʉ co cáto tʉjʉri ocõo bairo caĩ tʉgooñañupʉ: “Ani Dio ye quetire cabuioʉ majuu cʉ cãmata atio cʉ rʉporire cañeore majiboʉmi. ‘Caroo ãmo,’ ĩ tʉjʉ majiboʉmi,” caĩ tʉgooñañupʉ Simón. ");
INSERT INTO tav_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesu maca Simón cʉ caĩ tʉgooñari wamere tʉjʉ majicõari ocõo bairo cʉ caĩ buioyupʉ: —Jĩca wame queti buio majiorica wame mʉ yʉ buioga, cʉ caĩñupʉ Jesu. To bairo cʉ caĩro: —Jaʉ, jãre Cabuei, yʉ buioya, cʉ caĩñupʉ Simón. ");
INSERT INTO tav_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","To bairi Jesu ocõo bairo cʉ caĩ buio majioñupʉ: —Caʉmʉa pʉgarã niyerure cawapamorã ãnama. Nare niyeru cawajoricʉre jĩcaʉ pairo majuu quiniento rʉmʉri paarique wapa cõo wapamoʉmi. Apei petoacã cincuenta rʉmʉri paarique wapa cõo wapamoʉmi niyeru cajooricʉre. ");
INSERT INTO tav_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na cawajoricʉ maca na cawapayepe na cacʉgoquẽto tʉjʉʉ, “To nicõato. Mʉja cawapamorijere yʉ majiritigʉ,” na ĩimi, na maii. To bairi ¿ni maca ati maja mʉ yʉ cabuiorã cʉ camai netoʉ cʉ nibocʉti cʉ na cawapamoriquere cʉ camajiritioro bero? cʉ caĩ jeniñañupʉ Jesu Simóre. ");
INSERT INTO tav_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","To bairo cʉ caĩro: —Pairo cawapamobatacʉ maca niyeru cajooricʉre cʉ mai netoboʉmi, Jesure cʉ caĩñupʉ Simón. To bairo Simón cʉ caĩro: —Cariapena yʉ mʉ ĩ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","To bairo cʉ ĩi, cãromio macare co amojore tʉjʉ, ocõo bairo Simóre cʉ caĩnemoñupʉ: —Atiore co tʉjʉya mʉ quena. Mʉ ya wiipʉ yʉ cajãa ejaro ocore yʉ mʉ jooquẽpʉ yʉ rʉporire cacojepere. Co maca co cape oco mena yʉ rʉporire coje, co poa ñapo mena tu coje ejamo. ");
INSERT INTO tav_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yʉ caejari paʉ yʉ mʉ boca tʉjʉ nʉcʉbʉgo pabarioquẽpʉ. Atio maca yʉ cajãa ejaro tʉjʉo yʉ áti nʉcʉbʉgo yʉ rʉporire ñeri, pitigaquẽemo, caroaro yʉre cáti nʉcʉbʉgoo aniri. ");
INSERT INTO tav_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉa yʉ rʉpoare ʉje cajʉti ñuurije yʉ mʉ pio peóquẽpʉ. Co maca cajʉti ñuurije cawapa pacarijere yʉ pio peówõ yʉ rʉporipʉre. ");
INSERT INTO tav_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","To bairi cariape mʉ yʉ buiopa. To bairo yʉ co cátie mena seeto yʉ co camairijere yʉ iñoomo. Caroorije pairo cátaco co nibao joroquena cõre yʉ majiritiobojacõa. To bairi seeto yʉ maimo. Apei maca petoacã caroorije cátacʉ ũcʉ macare yʉ camajirioata jĩacã yʉ maigʉmi cʉ maca, Simóre cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","To bairo cʉ ĩ yaparo cãromiore co caĩñupʉ Jesu: —Caroorije mʉ cátajere yʉ majiritio peocõa. ");
INSERT INTO tav_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","To bairo co cʉ caĩro apirã aperã ti wiipʉ caʉga ruirã ocõo bairo caame ĩ jeniñañuparã: —¿Nope ĩi, “Caroorije mʉ cátajere yʉ majiritio peocõa,” cʉ ĩti marire baii camajocʉ cãcʉ nibaopʉcʉna? caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesu maca cãromiore ocõo bairo co caĩñupʉ: —Yʉre mʉ catʉgooña nʉcʉbʉgoro maca caroorije mʉ cátajere yʉ majiritioboja. To bairi caroaro wariñuurique mena aácoja, co caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cabero Jesu ape macaripʉre cáaáteñañupʉ, Ʉpaʉ Dio cʉ cãnie quetire buio teñaʉ. Cʉ cabuerã doce cãnacãʉ cʉ mena cáaájuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cãromia quena na mena cáaájuparã. Cariaye cʉtanare Jesu cʉ cacatioricarã romiri cãñuparã. Aperã na yeri wãtiare Jesu cʉ cabuu rebojaricarã romiri cãñuparã. Jĩcao María Magdalena cãñupo. Cõpʉre wãtia cajañarã siete cãnacãʉ majuure Jesu cʉ cabuu rerico cãñupo. ");
INSERT INTO tav_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apeo Juana cawamecʉco Chusa nʉmo cãñupo. Chusa maca Ʉpaʉ Herode ya wiipʉ paariquere cʉ̃re cajʉgo átibojaʉ cãñupʉ. Apeo Susana cawamecʉco cãñupo. Aperã capãarã cãñuparã na cacʉgorije mena Jesure cátinemonucurã. ");
INSERT INTO tav_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Camaja capãarã capee macari macana Jesu tʉpʉ caejayuparã. Cʉ tʉpʉ na caeja neñaporo tʉjʉʉ ati wame queti buio majiorica wamere na caĩ buioyupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jĩcaʉ camajocʉ trigo aperire cʉ wejepʉ cawẽ bate oteyupʉ. Apeye ma tʉacã cañarijere camaja cacʉta yajio reyuparã. Minia quena atí, caʉga recõañuparã tie aperiacãre. ");
INSERT INTO tav_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ape rupaa cʉ cawẽ bate oterije ʉ̃ta yepa bui care cumuñupe. Cabero tie putiba, cajita põreroacã cayepa oco mano maca cajinicoajupe. ");
INSERT INTO tav_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ape rupaa cʉ cawẽ bate otero pota miji wẽri watoapʉ care cumuñupe. To bairi pota miji wẽri maca ti aperiacã caputibatiere cabʉti weocoajupe. ");
INSERT INTO tav_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ape aperi care cumuñupe cañuuri yepa caroa cajitacʉti paʉpʉre. To bairi tie caroaro puti, bʉti, caroa carica cʉjupe. To cãnacã apea caputirique caroa capee carica cʉjupe. To bairo ĩ yaparo: —Noa yʉre caapirã caroaro na apipajeato, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cabero Jesu cʉ cabuerã: —¿Dope bairo ĩgaro to ĩti atie queti buio majiorica wame? cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","To bairo na caĩ jeniñaro ocõo bairo na caĩ buioyupʉ Jesu: —Ʉpaʉ Dio cʉ cãnie quetire cajʉgoye camajiriorije cãnibatajere caroaro mʉja majio joroque mʉja áami. Aperã macare buio majiorica wame mena na yʉ buio. Na maca yʉ cátiere tʉjʉ, yʉ cabuiorijere api, baibaopʉnana api majiquẽema. ");
INSERT INTO tav_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ocõo bairo ĩgaro ĩ tie queti buio majiorica wame: Oterica aperi Dio ye quetire bairona ã. ");
INSERT INTO tav_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jĩcaarã Dio ye quetire apirãma. Cabero Sataná na tʉpʉ atí, tiere api nʉcʉbʉgorema ĩi, na majiritio joroque ácʉmi. To bairo Sataná cʉ cátie jʉgori Dio cʉ canetooricarã majuu aniquẽnama. To bairi ma tʉ cañarique minia na caʉga reriquere bairona cãna ãnama. ");
INSERT INTO tav_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aperã ʉ̃ta yepa jita põreroacã cãni yepapʉ care cumuriquere bairo cabairã ãnama. Nemoopʉre Dio ye quetire caroaro caapi wariñuubatana ãnama. Api wariñuubaopʉnana jita capõreroacãpʉ care cumu putibatajere bairona, canʉcori manajere bairona yoaro apipajeequẽnama. Popiye na to cãno tʉgooñari to cõona janacõarãma. ");
INSERT INTO tav_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aperã tie aperi pota miji wẽri watoapʉ care cumuriquere bairona cãna ãma. Dio ye quetire apiba, ati yepa macaje macare seeto tʉgooñama. Apeye unie macare seeto boo neto tʉgooñarãma. Seeto caroorije na cáti wariñuupe quenare tʉgooñarãma. To bairo tʉgooñabana seeto tʉgooña rooye tuarãma. Dio yere átigaquẽnama. To bairo baibana atie pota miji wẽri watoapʉ cañarique carica manajere bairona anicõarãma. ");
INSERT INTO tav_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aperã maca Dio ye quetire nemoo apirã caroaro apipajeecõa aninucurãma. Na maca ãnama oterica rupaa caroa yepapʉ care cumu putiriquere bairona cabairã. Ti aperi caputirique pairo ricacʉto. Na quena Dio ye quetire apipajeecõa aninucuri capee caroare ánama Dio cʉ caboorijere, na caĩ buioyupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ape wame queti buio majiorica wame ocõo bairo caĩñupʉ Jesu moquena: —Jĩa bujuriquere jĩa bujurã apeye unie muu cũricaro ẽoropʉ mari jĩa bujuquẽna. Cani cuñaricaro ẽoropʉ quena mari cũquẽna. Cabui maca mari jĩa buju peorã camaja cajãa ejarã nipetiro caroaro na tʉjʉato ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","To bairi tie cabujurore bairona yʉ cabuiorijere noa cajʉgoye caapi majiquetana api majigarãma. Cajʉgoyepʉre caapi majiña manaje to anibao joroquena api majigarãma. ");
INSERT INTO tav_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’To bairi caroaro apiya atie mʉñʉja caĩ buiorijere. Noa atie yʉ cabuiorijere caapipajeerãre capee api majiriquere na joogʉmi Dio. Aperã yʉ cabuiorijere caapipajeegaquẽna na cãno maca yʉ yere na caapi majibatajeacã quenare na majiquetio joroque na átigʉmi Dio, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","To bairo camajare na cʉ caĩ buio ani paʉna Jesu paco, cʉ bairã cʉ camacara ejayuparã. Camaja capãarã na cãnoi cʉ tʉpʉ cajãa eja majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","To bairi aperã: —Mʉ paco, mʉ yarã mʉ tʉjʉgarã macapʉ tʉjʉnucuma, cʉ caĩ buioyuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","To bairo cʉ na caĩro apii: —Noa Dio ye quetire caapirã, tiere cána nipetirã yʉ paco, yʉ bairãre bairona cãna ãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jĩca rʉmʉ Jesu cʉ cabuerã mena cumua capairicapʉ caeja jãañupʉ. —Jitá, ʉtabʉcʉra jĩ nʉgoapʉ mari peña aáparo, na caĩñupʉ. To bairo cʉ caĩro apirã, cáaájuparã, ape nʉgoa tʉpʉre aána. ");
INSERT INTO tav_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na capeña aáto Jesu cacanicoajupʉ. Cʉ cacaniri paʉna wino seeto capapu ájupe. Wino to capapuro seeto cajabeyupe. Ti cumuapʉ cajabe jãa ruugayupe. ");
INSERT INTO tav_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ti cumua caruagaro tʉjʉrã Jesure cʉ cayopioyuparã. —¡Jesu, jãre camajioʉ, yopiya! ¡Rua yajirã mari bai! cʉ caĩñuparã. To bairo cʉ na caĩro Jesu yopi, winore, cajaberijere to cõona cajana rotiyupʉ. To bairo cʉ caĩ jana rotirona wino, cajaberije cajana peticoajupe yua. ");
INSERT INTO tav_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tie cajana petiro tʉjʉʉ ocõo bairo na caĩñupʉ Jesu cʉ cabuerãre: —¿Nope ĩrã yʉ mena aábaopʉnana yʉre canʉcʉbʉgoquẽnare bairo, “Rua yajigarã mari áa,” mʉja ĩ tʉgooñabati? Na maca to bairo cabairijere tʉjʉrã catʉjʉ acʉacoajuparã. —¡Abʉma! Seeto majuu camajii ãcʉmi. Wino, cajaberije quena cʉ carotiro caroaro apicõa, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilea cawamecʉti nʉgoa tʉpʉ cãnana ape nʉgoa tʉpʉ Gadara cawamecʉtopʉ capeña ejayuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Peña eja, camaa nʉcañuparã. Jesu cʉ camaa nʉca ejaro tʉjʉʉ jĩcaʉ camajocʉ ti maca macacʉ cayeri wãtiacʉcʉ cʉ cabocayupʉ Jesure. Yoaro jutii jañaquẽcʉna cãninucuʉ cãñupʉ. Wiipʉre cãniquetinucuñupʉ. Ʉ̃ta tʉa pʉto maja operi na cawerica operi jeto cãninucuñupʉ. Nairoacã yeri wãtia cʉ cañenucuñuparã. Aperãre rooro átiremi ĩrã cʉ cajianucubajuparã to macana come wẽri mena cʉ rʉporire, cʉ wamoripʉre. To bairo na cátibao joroquena caboca tʉ̃ga jure recõanucuñupʉ come wẽri cʉ̃re na cajiabatajere. Yeri wãtia cʉ̃re cajañarã camaja manopʉ cʉ atʉ mecʉo joroque cʉ cátinucuñuparã. To bairi Jesu maca cʉ tʉjʉʉ cʉ yeri wãtia cʉ̃re cajañarãre na cabuti aá rotiyupʉ. Cʉ maca Jesure cʉ boca tʉjʉʉ seeto awaja, cʉ tʉ ejacumu, ocõo bairo cʉ caĩ awajayupʉ: —¡Jesu, Dio ʉmʉrecoo macacʉ Macʉ! ¿Nope ĩi yʉ mʉ patawãcoʉ apari mʉa? ¡Popiye tamʉorica paʉpʉre yʉ jooqueticõaña! cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","To bairo cʉ caĩro: —¿Ñamʉ mʉ wamecʉti mʉa? cʉ caĩñupʉ Jesu maca. —Yʉa Legión yʉ wamecʉ, cʉ caĩñupʉ Jesure, yeri wãtia capãarã cʉ na cajañaro maca. ");
INSERT INTO tav_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—¡Wãtia na cãni paʉ caʉ̃cʉari opepʉ jã jooqueticõaña! cʉ caĩñuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na jʉgoye buuropʉ yejea capãarã caʉga ãñuparã. Yejeare na tʉjʉrã: —Yejeapʉre jã jãa rotiya, Jesure cʉ caĩñuparã, wãtia ya paʉpʉ aágaquẽna. To bairo cʉ na cajenirore bairona yejeapʉre na cajãa rotiyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","To cõona camajocʉpʉre cajañabatana yeri wãtia buti, yejeapʉre cajãañuparã. Na cajãarona yejea carupa tʉapʉ atʉ mecʉ atʉ ro aá, care ñuacoajuparã ti rapʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yejeare cacotebatana to bairo na cabairo tʉjʉ acʉari atʉ aá, macapʉ, maca tʉjaroripʉ macana quenare cabuio baterã aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tiere na cabuiorijere apirã camaja catʉjʉra aájuparã. Jesu tʉ ejarã cayeri wãtia cʉtibatacʉre catʉjʉyuparã. Jesu tʉpʉ caroaro jutii jañacõari caroaro catʉgooña majii cʉ caruiro cʉ catʉjʉyuparã. To bairo cʉ cabairo tʉjʉrã cauwiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cʉ̃re yeri wãtia cajañaricarãre Jesu na cʉ cabuu rero catʉjʉricarã maca na caĩ buioyuparã: —Ocõo bairo bai catícoami cayeri wãtia jañabatacʉ, na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tiere apirã Gadara yepa macana seeto cauwibʉjayuparã. To bairi Jesure: —¡Aácʉja aperopʉ! ¡Atopʉ aniqueticõaña! seeto cʉ caĩñuparã. Jesu cʉ̃re na cabooquẽto tʉjʉʉ cumuapʉ eja jãa, catunucoajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Cumuapʉ Jesu cʉ caeja jãaro tʉjʉʉ cʉ cawãtia buu rericʉ maca: —Yʉ quena mʉ mena yʉ aágʉ, cʉ caĩ jenibajupʉ. To bairo cʉ caĩro: —Aáquẽja. Mʉ ya wiipʉ tunu aácʉja. Caroaro Dio mʉre cʉ cátiejere mʉ yarãre na buio peocõaña, cʉ caĩñupʉ Jesu. To bairo cʉ caĩro macapʉ cáaácoajupʉ. Macapʉ aá, nipetiro Jesu cʉ̃re cʉ cátajere maca macanare na cabuio peocõañupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesu cʉ catunu peña ejaparore camaja capãarã cʉ̃re cayuuyuparã. Seeto wariñuurique mena cʉ cabocayuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jĩcaʉ na watoapʉ cãnacʉ neñapo buerica wii ʉpaʉ Jairo cawamecʉcʉ Jesu tʉpʉ caejayupʉ. Jesu tʉ ejari rʉpopatua tuatu ejacumuri, cʉ caĩ jeni nʉcʉbʉgoyupʉ: —Yʉ ya wiipʉ yʉ macore co catioʉ ajá, cʉ caĩ jeniñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cʉ maco jĩcaoacãna cãco doce cʉma cacʉgoo cãñupo. Bai yajigopʉ cabaiyupo. To bairo Jairo cʉ caĩrore apii cáaájupʉ Jesu. Mapʉ cʉ cáaáto Jesu mena camaja capãarã ma bijarona cáaájuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na watoapʉ jĩcao doce cʉmari majuu ámo janaquetajere cariayecʉco cãñupo. Co caʉcoye rotibataje wapa niyeru co cacʉgobataje nipetiro capeti weocoajupe. Co na caʉcoyerije to anibao joroquena jĩcaʉ maca co cacatio majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","To bairi Jesu bero maca atí, cʉ jutiro yapare capañañupo. Cʉ jutirore co capañarona co cariaye cʉtibataje nemoo cajanacoajupe yua. ");
INSERT INTO tav_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Cʉ jutirore co capañaro: —¿Ñamʉ yʉ cʉ pañari? caĩ jeniñañupʉ Jesu. Cʉ caĩ jeniñaro: —Jã pañaquẽpʉ jãa, cʉ caĩñuparã camaja nipetiro. To bairi Pedro maca ocõo bairo cʉ caĩñupʉ Jesure: —Jãre cabuei, camaja capãarã mʉ cʉ̃goma. Nope ĩi, “¿Ñamʉ yʉre cʉ pañari” mʉ ĩti? Jesure cʉ caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","To bairo cʉ caĩro: —Jĩcao yʉ pañawõ. Yʉre co capañarona yʉ camajirije mena co cariaye cʉtibatajere canetoro yʉ majiwʉ, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Cãromio maca, yʉ majiimi Jesu ĩo, nanaa uwiri cʉ rʉpori tʉ cʉ caejacumu nʉcʉbʉgoyupo. To bairo ácona camaja nipetiro na caapiropʉ: —Yʉna mʉ jutiirore mʉ yʉ pañawʉ. Yʉ capañarona yʉ cariaye cʉtie yʉ netocoapa, caĩ buioyupo. ");
INSERT INTO tav_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","To bairo co caĩro apii ocõo bairo co caĩñupʉ Jesu: —Yʉ yao, caroaro yʉre mʉ catʉgooña nʉcʉbʉgoroi mʉ cariaye cʉtiere yʉ netoowʉ. Caroa wariñuurique mena ãña, co caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mai to bairo co cʉ caĩ wada ani paʉna Jairo ya wiipʉ cãnacʉ jĩcaʉ caejayupʉ, Jairore cʉ buioʉ acʉ́: —Mʉ maco bai yajicoapo. To bairi marire cabueire cʉ patawãcoo nemoqueticõaña, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","To bairo cʉ caĩrijere apii Jesu maca ocõo bairo cʉ caĩñupʉ Jairore: —Tʉgooñaqueticõaña. Yʉ macare mʉ catʉgooña nʉcʉbʉgoro mʉ maco catigomo, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairo ya wiipʉ ejaʉ aperãre na cajãa rotiquẽjupʉ co ãnaco co cãni arʉapʉre. Pedro, Juan, cʉ jʉgocʉ Jacobo, cabai yajirico pacʉa na jetore cajãa rotiyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ti wii cãna nipetirã cõre otirã cájuparã. Nare ocõo bairo caĩñupʉ Jesu: —Otiqueticõaña. Cayajirico me ãmo. Canio áamo, caĩwĩ Jesu. Mere cabai yajirico co nibao joroquena na caĩwĩ, tunu catigomo cani yopiricarore bairona ĩi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","To bairo cʉ caĩro apirã caotirã maca cʉ caĩ epeyuparã, mere bai yajicoamo ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","To bairo cʉ na caapi nʉcʉbʉgoquetibao joroquena cabai yajirico co cãni arʉapʉre jãa, co wamore cañeñañupʉ. Ñeña: —Maco, catiya. Wamʉnʉcacõaña, co caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","To bairo cʉ caĩrona cawimao catunu catí wamʉ nʉcacõañupo yua. Co cawamʉ nʉcarona: —Ʉgariquere co nuña, na caĩñupʉ Jesu co pacʉare. ");
INSERT INTO tav_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Cabai yajirico nibaopʉcona co catunu catiro tʉjʉrã co pacʉa seeto caacʉayuparã. Jesu maca co catunu catirijere aperãre na cabuio rotiquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cabero Jesu cʉ cabuerã doce cãnacãʉre na caneoñupʉ. Na neocõari na cáti iñoo majipere na cajooyupʉ. Aperã na yeri wãtiare na cabuu reboja majipere, cariaye cʉnare na cacatio majipe quenare na cajooyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yucʉacãna Dio joogʉmi Ʉpaʉ ati yepapʉ carotipaʉ majuure caĩrijere na caqueti buio teña roti jooyupʉ. Cariaye cʉnare na cacatio teña rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ocõo bairo na caĩ roti jooyupʉ Jesu: —Buio teñarã aána apeye unie jee aáqueticõaña mʉjaa. Yucʉ mʉja tuericʉ, wajopoa uno, ʉgarique, niyeru, apeye unie jee aáqueticõaña. Jutiiro mʉja cajañarije mena jeto aánaja. Apeye jee aánemoquẽja. ");
INSERT INTO tav_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jĩca macapʉre ejarã mʉjaare na cãni rotiri wiina anicõaña na mena. Na mena mʉja anicõagarã ti maca mʉja cãni rʉmʉri cõo. ");
INSERT INTO tav_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ape macapʉ mʉja caejaro ti maca macana maca mʉjaare na cabooquẽpata mʉja buti weogarã. Buti aána, mʉja rʉporipʉre jita catujarijere pa bate cũña. To bairo ána mʉjaare jã cabuioro mʉja caapigaquẽtore bairona mʉja booquẽemi Dio, na ĩ iñoorã mʉja átigarã. ");
INSERT INTO tav_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","To bairi to cãnacã macaripʉ cáaá teñarã aájuparã, Dio ye quetire buio teñarã aána. Cariayecʉna quenare cacatio teñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herode, Galilea yepa ʉpaʉ nipetiro Jesu cʉ cátiere caqueti apiyupʉ. “Juan, Herode cʉ cajĩa rotiricʉ catunu catii ãcʉmi Jesu,” caĩñuparã jĩcaarã. To bairo na caĩrijere queti apii seeto caapi acʉa tʉgooñañupʉ Herode. ");
INSERT INTO tav_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aperã maca: “Elías ãnacʉ catunu buia ejaʉ ãcʉmi Jesu,” caĩñuparã. Aperã: “Jĩcaʉ tirʉmʉ macacʉ Dio ye quetire cabuioricʉ catunu catii ãcʉmi Jesu,” caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herode maca ocõo bairo caĩñupʉ: —Juan rʉpoare mere yʉ capa ta rocacõa rotiwʉ. To bairi ¿ñamʉ cʉ nicʉti cʉ̃a capee yʉre na caĩ buionucuʉ? caĩñupʉ. To bairi Jesu cʉ cátiere queti apiri seeto cʉ catʉjʉgabajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cabero Jesu cʉ cabuio teña rotiricarã tunu ejarã na cátajere cʉ cabuio peocõañuparã Jesure. Na cabuio yaparoro na jetore na cajʉgo aájupʉ Jesu Betsaida cawamecʉti macapʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Camaja aperã Jesu topʉ cʉ cáaáto majirã, cʉ camacarã aájuparã. Cʉ tʉpʉ na caejaro caroaro na caboca tʉjʉyupʉ Jesu. To bairi Ʉpaʉ Dio cʉ cãnie quetire na cabuioyupʉ. Cariayecʉna quenare na cacatioyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Canaio aáti paʉ cãno tʉjʉrã cʉ cabuerã maca cʉ tʉpʉ aá, Jesure ocõo bairo cʉ caĩñuparã: —Mere naio aáto bai. Ñee maa atore. Camajare capãarã cãnare na aá rotiya. Macaripʉ, camaja na cãnopʉ na caʉgape, na cacanipa paʉri quenare na macarã aáparo, cʉ caĩñuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","To bairo na caĩro: —Mʉja majuuna na nuña, na caboca ĩñupʉ Jesu. —Cinco cãnacã pan ʉgarica rupaariacã ã. Wai pʉgarãacã ãma, cʉ caĩñuparã. —Atieacã ati maja capãarã camajare ejaqueti majuucõa. ¿Nare jã canupere jã wapayerã aácʉti? Jesure cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Naa capãarã caʉmʉa jeto ãnaa jĩca wamo cõo mil cãnacãʉ cãñuparã. To bairi na caĩñupʉ Jesu cʉ cabuerãre: —Cincuenta cãnacãʉ jeto to cãnacã paʉre na rui rotiya. ");
INSERT INTO tav_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","To bairo cʉ caĩ rotirore bairona carotiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","To cõo jeto na carui petiro tʉjʉʉ Jesu jĩca wamo cõo ʉgarica rupaariacãre jee, wai pʉgarãre na jee, ʉmʉrecoopʉre tʉjʉ mʉgo, cʉ Pacʉ Diore, “Caroaro jã caʉgapere mʉ jooyupa,” cʉ caĩñupʉ Jesu. Diore ĩ yaparo pan rupaare na cape ricawo nuniñupʉ cʉ cabuerãre. To bairi na maca camajare na caricawo nuñuparã moquena. ");
INSERT INTO tav_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Camajare na caricawo nuro caʉga yapi peticoajuparã. Na caʉga yapi rʉgarije doce wʉri jiraro majuu cajee jãñuparã na maca. ");
INSERT INTO tav_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ape rʉmʉ Jesu jeto cʉ Pacʉ Diore cʉ cajeni nʉcʉbʉgoro cʉ cabuerã quena cʉ mena cãñuparã. To bairi na caĩ jeniñañupʉ Jesu: —Camaja “¿Ñamʉ cʉ nicʉti?” ame ĩ jeniñarã, ¿dope bairo na ame ĩ yʉnucuti? ");
INSERT INTO tav_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","To bairo cʉ caĩ jeniñaro: —“Juan camajare cabautisari majocʉ catunu catiricʉ ãcʉmi,” mʉ ĩ wadama. Aperã maca, “Tirʉmʉpʉ macacʉ Elías cawamecʉcʉ ãnacʉ catunu catiricʉ ãcʉmi,” mʉ ĩ wadama. Aperã, “Apei Dio ye quetire cabuioricʉ tirʉmʉpʉ macacʉ catunu catiricʉ ãcʉmi,” mʉ ĩ wadama, Jesure cʉ caĩ yʉyuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","To bairo na caĩrijere apii na caĩ jeniñanemoñupʉ Jesu: —Mʉja maca ¿ñamʉ ãcʉmi, yʉ mʉja ĩ tʉgooñati? Pedro maca cʉ caĩ yʉyupʉ: —“Dio, ‘Cʉ yʉ joogʉ,’ cʉ caĩricʉ majuuna ãmi,” mʉre jã ĩ. ");
INSERT INTO tav_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","To bairo Pedro cʉ caĩro: —Aperãre na buioqueti majuucõaña, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Yʉa camaja tʉpʉ Dio cʉ cajooricʉ cãcʉ seeto yʉ tamʉogʉ. Cabʉcʉrã judío majare carotirã, sacerdote maja ʉparã, judío majare cabuerã nipetiro yʉ tʉjʉteeri aperãre na jĩa rotigarãma yʉre. Yʉ na cajĩa rocarije to nibao joroquena yʉ tunu catiogʉmi Dio moquena itia rʉmʉ bero, na caĩ buioyupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cabero camaja nipetirore na caĩñupʉ Jesu: —Yʉ cabuerã anigarã mʉja majuuna mʉja cátigarijere tʉgooñaqueticõaña. To cãnacã rʉmʉ yʉ caboorije macare áti ʉjacõaña. Yʉre na cajĩagarore bairona mʉja quenare na cajĩagarije to nibao joroquena yʉre áti ʉjacõa aninucuña. ");
INSERT INTO tav_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","To bairi ati yepa ãnapʉ mʉja majuuna mʉja caboorijere mʉja cáticõamata Dio tʉpʉ catiriquere mʉja bʉgaquetigarã. Mʉja majuuna mʉja caboorije átiquẽna, yʉ caboorije macare ána caroa ãnajere mʉja bʉgagarã. ");
INSERT INTO tav_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","To bairi jĩcaʉ ati yepa macaje apeye unie nipetiro cacʉgoʉ Dio tʉpʉ cʉ cãnibope macare catʉgooñaquẽcʉ catirique bʉgaquetigʉmi. ");
INSERT INTO tav_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Jesu cʉ cabuerã jã ã,” ĩ boboqueticõaña. Ape rʉmʉpʉ yʉ tunu atígʉ yʉ caaji baterije, Dio cʉ caaji baterije mena ángel maja mena ati yepapʉre. Ti paʉ cãno yʉre caboboricarãre, “Yʉ cabuericarã me ãma,” yʉ quena na yʉ ĩgʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cariapena mʉñʉja ĩ buiopa. Atopʉ cãna mʉja jĩcaarã mʉja cabai yajiparo jʉgoye Ʉpaʉ Dio cʉ cãniere cʉ carotirijere mʉja tʉjʉgarã. ");
INSERT INTO tav_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","“Ʉpaʉ Dio caroa cʉ cãniere mʉja tʉjʉgarã,” cʉ caĩricaro bero canetocoajupe jĩca semana. To cõo Jesu ʉ̃taʉpʉ cʉ Pacʉ Diore cajeni nʉcʉbʉgoʉ aájupʉ. Cʉ mena macanare cajee aájupʉ itiarã Pedrore, Juãre, Jacobore. ");
INSERT INTO tav_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Diore cʉ cajeni nʉcʉbʉgori paʉna cʉ cabaurije, cʉ riya caroaro caaji bateyupe. Cʉ jutii quena caroaro seeto botiro cãñupe. ");
INSERT INTO tav_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","To bairo cʉ cabairi paʉna caʉmʉa pʉgarã carupea nʉca ejayuparã, Jesu mena wadapenirã. Jĩcaʉ Moisé, apei Elías cawamecʉna cãñuparã tirʉmʉpʉ cãnana. ");
INSERT INTO tav_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na quena Jesure bairona caaji bateyuparã. Jesure cʉ wadapenirã cájuparã Jerusalẽpʉ cʉ cabai yajipere yua. ");
INSERT INTO tav_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, cʉ mena macana maca canirã cájuparã, wʉgoa paibana. To bairo cabairijere caacʉa yopi eja tʉjʉyuparã Pedro jãa. To bairo bairã Jesu cʉ caaji baterijere catʉjʉyuparã. Tiere tʉjʉrã Jesu mena cawadapeni tʉjʉnucurã quenare na catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","To bairi Jesu mena cawadapenirã na cáaáti paʉna ocõo bairo caĩñupʉ Pedro Jesure: —Jã Ʉpaʉ, atopʉ mari cãno ñuu majuucõa. To bairi itia wiiacãre mari ána. Mʉ ya wii cãnipa wii, Moisé ya wii, Elías ya wii cãnipa wiiri mari ána. Pedro caroaro tʉgooñaquẽcʉna caĩ tʉgooña mawijiacõañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","To bairo cʉ caĩri paʉna bujeri bʉrʉa na cabuje bipe ájupe. To bairo ti bujeri bʉrʉa watoapʉ ãnaa cauwiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","To bairi bujeri bʉrʉapʉi Jesu Pacʉ Dio ocõo bairo caĩ wadayupʉ: —Ani yʉ Macʉ seeto yʉ camaii ãmi. Yʉ cabejericʉ ãmi. Cʉ cabuiorijere caroaro cʉ apipajeeya, caĩ wadayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","To bairo Dio cʉ caĩro bero jĩcaʉna catuayupʉ Jesu. Cʉ cabuerã tie na catʉjʉriquere cayajiobʉjayuparã. Aperãre na cabuioquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ape rʉmʉ bero ʉ̃taʉ bui cãnana Jesu jãa na carui atí paʉ camaja capãarã na caboca tʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na watoapʉ cãcʉ jĩcaʉ ocõo bairo Jesure cʉ caĩ pijoyupʉ: —Jãre camajioʉ, yʉ macʉ jĩcaʉna cãcʉre cʉ tʉjʉ ajá. ");
INSERT INTO tav_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yʉ macʉre cajañaʉ wãti rooro cʉ awaja mecʉ ria yaji aánucuo joroque cʉ átinucumi. To bairo quenare cʉ rijeropʉ cʉ jopo butio joroque cʉ átinucumi yʉ macʉre. Rooro cʉ tamʉo popiyecʉtio joroque cʉ átinucumi. Cʉ pitigaquẽemi wãti, caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—Mʉ cabuerãre, “Wãtire cʉ buu rocabojaya yʉ macʉre,” na yʉ ĩbapʉ. Cʉ buu roca majiquẽma, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","To bairo cʉ caĩro apii ocõo bairo cʉ cabuerãre na caĩñupʉ Jesu: —Caroaro yʉre mʉja api nʉcʉbʉgoquẽe. Mʉñʉja cabuiorijere cariape mʉja tʉgooña majiquẽe. Yoaro mʉñʉja cabuiorije to nibao joroquena mʉja api majiquẽe. To bairo cʉ cabuerãre na ĩ, cawimaʉ pacʉre: —Mʉ macʉre cʉ neajá yʉ tʉ maca, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cawimaʉ Jesu tʉ cʉ cáatóna yua, wãti cʉ̃re cajañaʉ cʉ catu ne roca cũcõañupʉ. To bairo cʉ ácʉna cʉ cabainucuricarore bairona cʉ baio joroque cʉ cáticõañupʉ wãti cawimaʉre. To bairo cʉ cʉ cáto Jesu maca wãtire cʉ cabuti aá rotiyupʉ. Cʉ cabuti aá rotirona cawimaʉ cañuucoajupʉ. To bairi: —Mere mʉ mena cʉ tunu aáparo, caĩñupʉ Jesu cʉ pacʉre yua. ");
INSERT INTO tav_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","To bairo cʉ cañuuro tʉjʉrã camaja catʉjʉ acʉacoajuparã, Dio cʉ catutuarijere Jesu na cʉ cáti iñooro tʉjʉrã. Camaja Jesu na cʉ cáti iñoorijere na catʉjʉ acʉari paʉna ocõo bairo cʉ cabuerãre na caĩñupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Yucʉacã mʉñʉja cabuiorijere caroaro apiya. Aperã yʉre ñecõari yʉ joogarãma yʉre catʉjʉ teerã macare, cʉ jĩacõaña ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","To bairo cʉ caĩ buiorije to nibao joroquena cʉ caapi majiquẽjuparã. Dio na caapi majipere na cajooquẽjupʉ mai. To bairi caapi majiquẽjuparã cʉ cabuiorijere. Cʉ cajeniña uwiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Cabero Jesu cʉ cabuerã na majuuna caame ĩ wada neto oca botioyuparã, ¿Ni maca marire cajʉgo ani majuʉ cʉ ãcʉati? ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu maca to cãnacãʉpʉna, “Yʉ caroti majuʉ yʉ anigʉ,” na caĩ tʉgooñarijere catʉjʉ majicõañupʉ. To bairi jĩcaʉ cawimaʉre cʉ capi ejoo nʉcoñupʉ cʉ tʉpʉ. Cʉ pi ejoo nʉcori, ocõo bairo na caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Ani cawimaʉre, “Cãni majuʉ me ãmi,” mʉja caĩ tʉgooñarije to nibao joroquena yʉ maca cãni majuʉre bairo cʉ yʉ tʉjʉ. To bairi, “Mari mena macacʉ cawatoa cãcʉ ãmi,” mʉja caĩ tʉgooñaʉ ũcʉ macare, “Cãni majuʉ ãmi,” cʉ yʉ ĩ tʉjʉ. To bairi ani cawimaʉre bairo cãna cawatoa cãna na nibao joroquena na mʉja cátinemoata yʉpʉre átinemorã mʉja áa. Yʉre átinemorã yʉ Pacʉpʉre átinemorã mʉja áa. ");
INSERT INTO tav_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Cabero Jesure cʉ caĩ buioyupʉ Juan: —Jãre cabuei, jĩcaʉ camaja na yeri wãtiare na cʉ cabuu rebojaro cʉ jã tʉjʉwʉ. “Jesure caapipajei yʉ ã,” ĩri na yeri wãtiare na buti rotiwĩ. Mari mena macacʉ cʉ cãniquẽto maca, “Átiqueticõaña,” cʉ̃re jã boca ĩ matawʉ, cʉ caĩwĩ Juan Jesure. ");
INSERT INTO tav_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","To bairo cʉ caĩro: —Cʉ mataqueticõaña. Marire cateequẽcʉ ũcʉ mari mena macacʉ ãmi, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesu mere bai yaji, ʉmʉrecoopʉ cʉ catunu wamʉ aápere camaji weocõañupʉ. To bairi, “Nemoona Jerusalẽpʉ yʉ aácʉpa,” caĩ tʉgooñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","To bairi aperã cʉ mena macanare na cabuio roti joo jʉgoyeyeyupʉ, yʉ cacanipa paʉre jenibojaya ĩi. To bairi naa, cʉ mena cãna Samaria yepa cãni macapʉre Jesu cʉ cacanipa wiire camaca yuura aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","To bairi ti maca macana Jesu na tʉpʉ cʉ cacani ejaro cabooquẽjuparã, mari catʉjʉteerã tʉpʉ Jerusalẽpʉ cáaápaʉ ãmi ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","To bairi Samaria macana Jesure cʉ na cabooquẽto apirã cʉ cabuerã Jacobo, Juan ocõo bairo Jesure cʉ caĩ jeniñañuparã: —Ʉpaʉ, ¿ʉmʉrecoopʉ cãni pero nare cajoepa pero mari rui roticõacʉti? ¿Elías tirʉmʉpʉ macacʉ cʉ cátatore bairona mari ánaati? cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","To bairo na caĩro Jesu maca na tʉjʉ, ocõo bairo na caĩ tutiyupʉ: —Tiere to bairo mʉja caĩ tʉgooñaata cariape mʉja caĩ tʉgooñari wame me ã. ");
INSERT INTO tav_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Camajare jĩaʉ acʉ́ mee yʉ cabaiwʉ. Na catioʉ acʉ́ maca yʉ cabaiwʉ, na caĩñupʉ Jesu. Cabero ape macapʉ cáaá netocoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ape macapʉ na cáaá neto aáti paʉna jĩcaʉ nare cabocayupʉ. Na boca, Jesure cʉ caĩñupʉ: —Ʉpaʉ, yʉ quena yʉ aágʉ nipetiro mʉ cáaá teñaropʉ, mʉ cabuei anigʉ. ");
INSERT INTO tav_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","To bairo cʉ caĩro: —Waibʉcʉrã na cãni paʉri cʉgoma. Minia quena cʉgoma na ria batiripʉ na cacaniri paʉri. Yʉ maca camaja tʉpʉ Dio cʉ cajooricʉ anibaopʉcʉna yʉ cacaniri paʉ maa. To bairi yʉ mena mʉ cáaáteñaata caroa paʉ mʉ cʉgoquetiboʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Apei macare cʉ caĩñupʉ Jesu: —Adʉja yʉ mena. To bairo cʉ cʉ caĩro: —Ʉpaʉ, yʉ pacʉ tʉpʉ yʉ anigʉ mai cʉ cabai yajiparo jʉgoye. Cʉ cabai yajiro bero mʉ mena yʉ aágʉ, cʉ caĩñupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","To bairo cʉ caĩro: —Yʉre caapi nʉcʉbʉgoquẽna na majuuna na yarãre na coteato yʉ tʉpʉ cãniquetiparãre. Mʉ maca yʉ mena ajá. Ʉpaʉ Dio cʉ cãnie quetire aperãre na buio teñaña, cʉ caĩbajupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Apei ocõo bairo cʉ caĩñupʉ Jesure: —Ʉpaʉ, mʉ mena yʉ aágʉ. Mʉ mena aágʉ jʉgoye yʉ ya wii macanare, “Aácʉ yʉ áa,” na yʉ ĩ buio tʉjaʉpa mai. ");
INSERT INTO tav_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","To bairo cʉ caĩro ocõo bairo cʉ caĩ buioyupʉ Jesu: —Jĩcaʉ cʉ paarique paabaopʉcʉna, apeye unie macare tʉgooña tunuoʉ, cʉ paariquere caroaro to baiquetio joroque baiimi. To bairona baiimi yʉ cabuei nibaopʉcʉna apeye macare catʉgooñaʉ. To bairo cãcʉ Dio ye macare caroaro átiquẽcʉmi, cʉ caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cabero mari Ʉpaʉ Jesu aperã cʉ ye quetire cabuio teñaparãre setenta majuu na cabejenemoñupʉ. Nare beje, cʉ cáaápa macaripʉre na cáaá jʉgoyecʉti rotiyupʉ. Pʉgarã, pʉgarã jeto na cabuio teña aá rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ocõo bairo na caĩ buioyupʉ: —Caoterique mere jũacoapa. Pairo majuu rica cʉticoapa. Cajeeparã maca jĩcaarãacã jeto ãma. To bairo caoterique ʉpaʉre cʉ jeniya. “Carica cajeenemoparãre jooya,” cʉ ĩ jeniya, caĩñupʉ. —Capãarã majuu ãma yʉ ye quetire caapipajeeparã. To bairi Diore cʉ jeniya, aperã nare cabuiorã na cãninemoparore bairo ĩrã, na caĩñupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Aánaja mʉjaa, yʉ ye quetire buiora aána. Mʉjaare cauwiope to nibao joroquena mʉñʉja aá roti caroorã na cãnopʉ. To bairi waibʉcʉrã oveja cawimarã yaia jeto na cãnopʉ na cáaátore bairona mʉñʉja aá roti cauwioropʉre. ");
INSERT INTO tav_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Topʉ buio teñarã aána niyeru jãrica poari, apeye jãrica poari quenare jee aáqueticõaña. Rʉpo jutii jĩca bapa mʉja cacʉtape jetore jee aánaja. Ape bapa mʉja cawajoapere jee aáqueticõaña. Mapʉ aperãre na bocarã yoaro wadapeni tuaqueticõaña. ");
INSERT INTO tav_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maca ejarã mʉja caejari wii macanare na ñuu rotirã, “Caroa ãnaje mʉjaare cʉ joato Dio ati wii macanare,” nare mʉja ĩgarã. ");
INSERT INTO tav_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ti wii macanare to bairo na mʉja caĩ ñuu rotiro to bairona caroare na joogʉmi Dio. “Caroaro jã mena anicõaña,” mʉjaare caĩrãre mʉja caĩrore bairona caroare na joogʉmi Dio. Caroaro mʉjaare cãni rotiquẽna macare caroare na jooquetigʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ti wiina caroaro mʉjaare na cãni rotiri wii jetona mʉja anicõagarã. Ti wiina mʉjaare na canurijere ʉga, eti, áti anicõaña. Mʉjaare na canurijere Dio ye quetire mʉja cabuiorije wapayerãre bairo ána átigarãma. To bairi ape wiiripʉ ʉga teñaquẽja. ");
INSERT INTO tav_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mʉja caejari maca macana caroaro mʉjaare na cabooro ʉgaya mʉjaare na canurijere. ");
INSERT INTO tav_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ti macapʉ cariaye cʉnare na catioya. Ocõo bairo na ĩ buioya: “Ʉpaʉ Dio cʉ cãnie quetire mʉja tʉpʉ jã buiorã ejawʉ,” na ĩ buioya. ");
INSERT INTO tav_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ape macare mʉja caejaro ti maca macana mʉjaare na cabooquẽpata ti maca carecomacapʉ aáti, ocõo bairo na ĩña: ");
INSERT INTO tav_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mʉja ya maca macaje jita jã rʉporipʉre catujarijere pa bate cũrã jã áa. Jã cabuiorijere mʉja cabooquẽtie bui mʉja popiyeyegʉmi Dio ĩrã, to bairona jã áa. Ʉpaʉ Dio cʉ cãniere mʉja tʉpʉ jã buiorã ejabapʉ,” na mʉja ĩ buiogarã. ");
INSERT INTO tav_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉjaare cabooquẽnare rooro na baigaro Diore cabooquẽnare na cʉ capopiyeyeri paʉ cãnopʉ. Tirʉmʉpʉ macana Sodoma macanare na cʉ capopiyeyericaro netoro na popiyeyegʉmi Dio mʉjaare cabooquẽnare, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","To bairo na ĩ yaparo ocõo bairo caĩñupʉ Jesu Corasín, Betsaida cawamecʉti macari macanare: —Cabero rooro mʉja baigaro Corasín, Betsaida macanare. Tirʉmʉpʉ macana Tiro, Sidón macana quena mʉjaare yʉ cáti iñoorijere bairona na yʉ cáti iñoata na yeri wajoaboricarãma na maca. Nemoopʉna caroorije na cátajere jʉtiritiri áti janaboricarãma na maca. Mʉja maca caroorije mʉja cátiere mʉja janagaquẽe. ");
INSERT INTO tav_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","To bairi Diore caapipajeequẽnare na cʉ capopiyeyeri paʉ cãnopʉ seeto mʉja popiyeyegʉmi. Tirʉmʉpʉ macana Tiro, Sidón macanare na cʉ capopiyeyericaro netoro mʉja popiyeyegʉmi Dio mʉja macare, na caĩñupʉ Jesu Corasín, Betsaida macanare. ");
INSERT INTO tav_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum cawamecʉti maca macana quenare ocõo bairo na caĩñupʉ Jesu: —“Ʉmʉrecoopʉ Dio tʉpʉ jã aágarã,” ĩ tʉgooñaqueticõaña mʉjaa. Mʉjaare regʉmi Dio caroorãre na cʉ capopiyeyenucuri paʉpʉ, na caĩ buioyupʉ Jesu Capernaum macanare. ");
INSERT INTO tav_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na ĩ yaparo cʉ cabuerã, cʉ caroti jooricarãre ocõo bairo na caĩñupʉ: —Mʉja cabuiorijere caapirã yʉpʉre apirã áama. Mʉja cabuiorijere caapigaquẽna maca yʉrena apigaquẽna áama. Yʉre caapigaquẽna Dio yʉre cajooricʉ quenare apigaquẽna áama, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Cabero setenta cãnacãʉ majuu Jesu mena macana cʉ cabuio teña rotiricarã buio teña, tunu ejarã wariñuurique mena catunu ejayuparã. Tunu eja, Jesure cʉ caĩ buioyuparã: —Jã Ʉpaʉ, cayeri wãtia camajapʉ cajañarãre, “Jesucristo caapipajeerã jã cãnoi butiya,” nare jã cabuti rotiro nemoona butiwã. Jãre neto majiquẽema. ");
INSERT INTO tav_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","To bairo na caĩro ocõo bairo na caĩñupʉ Jesu: —Satanáre carocawĩ Dio ʉmʉrecoopʉ cãnibatacʉre yʉ catʉjʉrona. Bʉpo cʉ cayaberijere bairona caña rui aámi Dio cʉ carocaropʉ. To bairi mʉjaare neto majiquẽema wãtia, Dio cʉ carericarã aniri. ");
INSERT INTO tav_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tutuariquere mʉjaare yʉ cajoowʉ. To bairi aña, cotapa na mʉja cacʉtabao joroquena mʉja rooye tuuquetigarãma. Sataná cʉ catutuarije netoro cãniere áti rotiriquere mʉñʉja cajoowʉ. To bairi wãtia mʉja áti rooye tuu neto majiquẽema. ");
INSERT INTO tav_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wãtia mʉja carotiro apiri na cabutiro mʉja wariñuurã. To bairo mʉja cabairije to nibao joroquena ape wame maca seeto cãni wariñuuri wame majuu ã. Ʉmʉrecoopʉ Dio yarã na wamere cʉ cauca turi pũuropʉ cʉ cauca turicarã aniri maca seeto wariñuuña, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","To bairo cʉ cabuerãre ĩ yaparoʉ ocõo bairo cʉ Pacʉ Diore cʉ caĩñupʉ Jesu, Espíritu Santo wariñuu netoriquere cʉ cʉ cajooroi: —Caacʉ, mʉna mʉ ã ʉmʉrecoo, ati yepa quenare carotii. “Mere camajirã jã ã,” caĩ tʉgooñarãre yʉ cabuiorijere api majiriquere na mʉ jooquẽe. Aperã, “Caroaro jã majiquẽe Dio yere, cawimarãre bairona camajiquẽna jã ã,” caĩ tʉgooñarã macare yʉ cabuiorijere caroaro api majiriquere na mʉ joo. Caroaro na majiato ĩi api majiriquere na mʉ joo. To bairo mʉ cátiere tʉgooñari, “Caroaro mʉ áa,” mʉ yʉ ĩ wariñuu, Caacʉ. To bairo mʉ caboorore bairona na mʉ ájupa, caĩñupʉ Jesu cʉ Pacʉ Diore. ");
INSERT INTO tav_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","To bairo cʉ Pacʉre cʉ ĩ, cʉ cabuerãre ocõo bairo na caĩñupʉ: —Yʉ Pacʉ nipetiro áti majiriquere yʉ cajoowĩ. Yʉ cãniere majiquẽema camaja. Jĩcaʉna ãmi yʉ Pacʉ Dio yʉ cãniere camajii. Yʉ Pacʉ cʉ cãnie quenare majiquẽema camaja. Jĩcaʉna yʉ ã cʉ cãniere camajii. Noa cʉ cãniere na yʉ camajioro na quena majigarãma yʉ Pacʉ cʉ cãniere, caĩñupʉ cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","To bairo na ĩ, cʉ cabuerãre na tʉjʉ, aperã na caapiquẽtopʉ ocõo bairo na caĩñupʉ: —Ato capaʉpʉre mʉja catʉjʉnucuri wame, mʉja caapinucuri wamere catʉjʉgabajuparã capãarã tirʉmʉpʉ macana Dio ye quetire cabuiorã, maca ʉparã quena. To bairi mʉja maca tiere caapinucurã, catʉjʉrã aniri wariñuuña, na caĩñupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Moisé ãnacʉ cʉ caucariquere caroaro cabuei jĩcaʉ caejayupʉ Jesu tʉpʉ. Eja, ¿dope bairo yʉ cʉ ĩ yʉgabaupari ĩi? cʉ caĩ jeniñañupʉ Jesure: —Camajare camajioʉ, ¿dope bairo yʉ ácʉati Dio tʉpʉ anicõa aninucugʉ? ");
INSERT INTO tav_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","To bairo cʉ caĩ jeniñaro: —¿Moisé cʉ caucarica pũuripʉ dope bairo ĩ ucarique to ãti? Mʉa tiere mʉ cabueata, ¿dope bairo mʉ tʉgooñati? cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","To bairo cʉ caĩro: —Ocõo bairo ĩ ucarique ã: “Mʉ Ʉpaʉ Diore nipetiro seeto mʉ yeri mena cʉ maiña. Mʉ caocabʉtirije mena, mʉ catʉgooñarije mena Diore cʉ maiña. Aperã quenare na maiña mʉ majuuna mʉ rupaʉre mʉ camairore bairona,” ĩ ucarique ã, Jesure cʉ caĩ yʉyupʉ Moisé ãnacʉ cʉ caucariquere caroaro cabuei. ");
INSERT INTO tav_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tiere cʉ caĩro apii Jesu cʉ caĩñupʉ: —Cariapena mʉ ĩ. To bairo ácʉ Dio tʉpʉ mʉ anicõa aninucugʉ, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","To bairi, “Caroaro aperãre camaii ãñupi,” yʉ cʉ ĩato ĩi, ocõo bairo cʉ caĩ jeniñanemoñupʉ Jesure: —¿Noa una na ãti, “Aperãre camaipe ã,” caĩrã? ");
INSERT INTO tav_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","To bairo cʉ caĩro atie queti buio majiorica wame cʉ caĩ buioyupʉ Jesu: —Jĩcaʉ Jerusalẽi caro aáti wãpʉ Jericópʉ aácʉ caro aájupʉ. Topʉ cʉ cáaáto ma recomacapʉ jee rutiri maja tutuaro mena cʉ boca ñe átiri, cʉ pa camiye, cʉ jutii, cʉ apeye unie, nipetiro cʉ caema peocõañuparã. Cʉ bai yajibo joroque cʉ áti, cũ roca, cáaácoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","To bairo cʉ na cáti cũ roca aáto bero jĩcaʉ sacerdote majocʉ ti wãpʉ cáaájupʉ. Ti wãpʉ aácʉ to bairo na cáti cũ rocaricʉre cʉ tʉjʉba, cʉ caowa netocoajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cʉ caneto aáto bero moquena apei Levita poa macacʉ cáajupʉ́. Cʉ quena to bairona cʉ tʉjʉʉ cʉ caowa netocoa aájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na caneto aáto bero ti wãna cáajupʉ́ apei Samaria macacʉ, judío maja na cateerã yaʉ. Cʉ maca na caquẽ rocaricʉre cʉ tʉjʉʉ cʉ cabopaca tʉjʉyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Cʉ bopaca tʉjʉri cʉ tʉjʉ aá, cʉ na caquẽrique camiire cʉ caʉcoyeyupʉ. Ʉje wẽri rica oco mena cʉ cacoje ʉcoyeyupʉ, ʉje majuu mena quena. Áti yaparo juti ajeri mena cʉ camiire cʉ cadʉreyupʉ. Cabero cʉ yaʉ burro caumaʉ bui cʉ ne peo, cʉ canecoajupʉ. Cʉ ne aá, aáteñari maja na cacanirã ejanucuri wiipʉ cʉ cane ejayupʉ. Ne eja átiri, topʉ cʉ cacote ãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ape rʉmʉ yua, Samaria macacʉ topʉ ani, neto aágʉ aáteñari maja na cacanirã ejari wii ʉpaʉre niyeru cʉ cajooyupʉ. Pʉga rʉmʉ paarique wapayerique cõo cʉ cawapayeyupʉ. “Caroaro anire cʉ coteya,” ĩi cájupʉ. “Noo caboorije cʉ mʉ cátinemoro cabero acʉ́ mʉ yʉ wapayenemogʉ,” cʉ caĩñupʉ Samaria macacʉ ti wii ʉpaʉre yua. ");
INSERT INTO tav_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","To bairi ti wamere buio majio yaparo ocõo bairo caĩ jeniñañupʉ Jesu Moisé ãnacʉ cʉ caucarique caroaro cabueire: —Tiere apii ¿dope bairo mʉ tʉgooñati? Camaja itiarã jee rutiri maja na caquẽ rocaricʉre cʉ catʉjʉyuparã. Naa itiarã catʉjʉricarã, ¿ni maca cʉ̃re cʉ camaiñupari? cʉ caĩ jeniñañupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","To bairo cʉ caĩro: —Cʉ̃re cabopaca tʉjʉricʉ maca cãñupʉ cʉ̃re camaii, cʉ caĩñupʉ Jesure. To bairo cʉ caĩro: —Mʉ quena to bairona ája. Cʉ̃re cabopaca tʉjʉricʉ cʉ cátatore bairona ája, caĩñupʉ Jesu Moisé cʉ caucariquere caroaro cabueire yua. ");
INSERT INTO tav_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu cʉ cabuerã mena aáteñaʉ aácʉ, caejayupʉ ape macaacãpʉ. Ti macapʉ cʉ caejaro Marta cawamecʉco cʉ cáatí rotiyupo co ya wiipʉ. ");
INSERT INTO tav_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jesu cʉ cajãa ejaro Marta baio María cawamecʉco Jesu tʉ caruiyupo, cʉ cabuiorijere apigo. ");
INSERT INTO tav_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta maca ʉgarique quenoorique capee capaarique paibʉjayupo. To bairi Jesu tʉ co baio co caruiro tʉjʉri Jesure cʉ caĩñupo Marta: —Yʉ Ʉpaʉ, yʉa jĩcaona capee paarique yʉ áticõabapa. Atio yʉ baio yʉ átinemoquẽemo, cʉ caĩñupo. —¿To bairo co cabairijere co mʉ tʉgooñaquẽeti? “Mʉ jʉgocore co átinemoña,” co ĩña, cʉ caĩñupo Marta. ");
INSERT INTO tav_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesu maca ocõo bairo co caĩ yʉyupʉ: —Marta, mʉa capee majuu paabaco seeto mʉ tʉgooñarique cʉti neto. ");
INSERT INTO tav_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mʉ baio co caapirije maca jetore catʉgooñape nibapa. María maca, “Jesu cʉ cabuiorijere yʉ apigo,” ĩo caroa macare átigamo. Yʉ cabuiorijere co caapiri wamere co majiritio joroque áti majiquetigarãma aperã, co caĩñupʉ Jesu Martare yua. ");
INSERT INTO tav_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jĩca paʉ Jesu cʉ Pacʉ Diore jeni nʉcʉbʉgoʉ cájupʉ. Cʉ cajeni nʉcʉbʉgo yaparoro cʉ cabuei jĩcaʉ cʉ caĩñupʉ: —Jã Ʉpaʉ, Juan bautisari majocʉ cʉ cabuerãre Diore jeni nʉcʉbʉgoriquere na camajiowĩ. To bairi mʉ quena jãre majioña, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","To bairo cʉ caĩro ocõo bairo cʉ caĩñupʉ Jesu: —Diore jeni nʉcʉbʉgorã, ocõo bairo cʉ ĩña mʉjaa: Jã Pacʉ, ʉmʉrecoo macacʉ, jĩcaʉna mʉ ã caroaʉ majuu, cáti nʉcʉbʉgopaʉ. Ati yepapʉ Caʉpaʉ majuu ãña. Ʉmʉrecoo macana caroaro mʉ caboorije átinucuma. To bairo na cátore bairona ati yepa macana quena mʉ caboorijere na áparo. ");
INSERT INTO tav_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʉgarique ati rʉmʉ jã caʉgaparo cõo jã jooya. ");
INSERT INTO tav_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Caroorije jã cátajere majiritioya. Jã quena aperã caroorije jã na cátajere na jã majiritiogarã. Sataná caroorijere jãre cʉ cáti rotiro cʉ̃re jã matabojaya. ");
INSERT INTO tav_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Apeye na caĩ buionemoñupʉ Jesu moquena: —Jĩcaʉ mʉja yaʉ cáaáteñaʉ aátacʉ ñami recomacapʉ cʉ catunu ejaro apei mʉja bapare cʉ tʉpʉ aáti ocõo bairo cʉ mʉja ĩborã: “Yʉ yaʉ, ʉgarique yʉ wajoya itia joroa pãre. Apei yʉ yaʉ aperopʉ cáaáteñaʉ aátacʉ tunu ejami. Cʉ yʉ canupe maa. To bairi mʉ yʉ jenii apʉ́,” cʉ mʉja ĩborã. ");
INSERT INTO tav_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To bairo cʉ mʉja caĩro wii pupeapʉi mʉja yʉ́ bujoboʉmi: “Yʉ patawãcooquẽja. Mere jope yʉ bipecõawʉ. Yʉ punaa canirã áama. To bairi dope bairo áti mʉ yʉ joo majiquẽe,” ĩboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mʉjaare camaii nibaopʉcʉna jooquetiboʉmi, seeto cãnigabacʉ. Seeto cʉ mʉja cajeni netocõarore apii jooboʉmi. Yʉ cʉ patawãcoo janaato ĩi, jopere pã, mʉja jooboʉmi, ʉgariquere cʉ mʉja cajenirije cõo, na caĩñupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—To bairi mʉja quena to bairona Diore cʉ jeniya. Mʉja cajeniro mʉja joogʉmi cʉ̃re mʉja cajenirijere. Jenicõa ãna mʉja bʉgagarã. Mʉja yaʉ jopepʉ cʉ capi jenirore bairona mʉja átigarã Diore cʉ jenirã. To bairo mʉja cajenicõa ãnoi jope pãri camajocʉ cʉ yaʉre cʉ cajoorore bairona mʉja joogʉmi Dio cʉ̃re mʉja cajenirijere. ");
INSERT INTO tav_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Noa nipetirã Diore cajenirãre na joogʉmi na cajenirijere. Cajeni macarã na cajenirijere bʉgagarãma. Joo ecoogarãma jopepʉ cajeni ãnacʉre bairona. ");
INSERT INTO tav_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Mʉjaa capunaacʉna mʉjaare naorore na cajeniata ʉ̃taare mʉja jooquẽna. Waire na cajeniata añare mʉja jooquẽna. ");
INSERT INTO tav_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ãboco riare na cajeniata cotapare na mʉja jooquẽna. ");
INSERT INTO tav_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","To bairona caroare mʉja punaare na mʉja joo maji, caroaro cáti majiquẽna anibaopʉnana. To bairi caroa na mʉja cajoorije netoro mʉja joogʉmi mʉja Pacʉ ʉmʉrecoo macacʉ cʉ Espíritu Santore cʉ̃re mʉja cajeniro. ");
INSERT INTO tav_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ape rʉmʉ Jesu wãti camajocʉpʉre cajañaʉre cʉ cabuu rocayupʉ. Wãti cʉ̃pʉre cʉ cajañaro cawada majiquẽjupʉ. To bairi Jesu wãtire cʉ carocaro bero cawada majiquetibatacʉ cawada majicõañupʉ yua. Tiere tʉjʉrã catʉjʉ acʉacoajuparã camaja. ");
INSERT INTO tav_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jĩcaarã ocõo bairo caĩñuparã: —Wãtia na ʉpaʉ Sataná, Beelsebú cawamecʉcʉ cʉ catutuarije mena na buu reimi, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aperã maca, “Dio cʉ cajooricʉ yʉ ã,” jãre ĩi, “Tʉjʉ acʉarica wamere jã áti iñooña,” cʉ caĩbajuparã. ");
INSERT INTO tav_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesu maca to bairije na catʉgooñarijere tʉjʉ majiri, ocõo bairo na caĩñupʉ: —Jĩca maca macana nibaopʉnana na caame quẽata na majuuna ame jĩa peocõaborãma. To bairo quena jĩca wii macana anibaopʉnana na caame tutiata jĩca wiina ani majiquetiborãma. ");
INSERT INTO tav_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","To bairona Sataná Beelsebú cawamecʉcʉ quena cʉ yarã mena cʉ caame quẽata cʉ yarã aniquetiborãma. To bairi cʉ carotirã cʉgoquetiboʉmi. To bairi ¿nope ĩrã to bairo, “Beelsebú cʉ catutuarije mena wãtiare na buu reimi,” yʉ mʉja ĩti? ");
INSERT INTO tav_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","To bairi jocarã majuuna, “Sataná cʉ catutuarije mena wãtiare na buu reimi,” yʉ mʉja ĩ. Mʉja yarã jĩcaarã na quena wãtiare na buu rema. “Dio cʉ catutuarije mena na buu rema,” na mʉja ĩnucu. To bairi na quena, “Jocarã ĩma,” mʉja ĩgarãma, “Sataná cʉ catutuarije mena wãtiare na buu reimi Jesu,” yʉre mʉja caĩata. ");
INSERT INTO tav_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","To bairi Dio cʉ catutuarije mena wãtiare na yʉ buu re. “To bairi Dio yere carotii ãcʉmi,” yʉre mʉja caĩpe nibajupa. To bairi mʉja popiyeyegʉmi Dio, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Camajocʉ catutuaʉ nipetiro beju wamooricʉ caroaro cʉ ya wiire cʉ cacotero aperã cʉ yere jee ruti majiquẽnama. ");
INSERT INTO tav_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Apei maca cʉ netoro beju wamoocõaricʉ cãcʉ cʉ caejaata cʉ quẽ netoboʉmi. To bairo cʉ quẽ netori cʉ cacʉgobatajere, cʉ cajarerijere, cʉ ãpoa bejurori ema peocõaboʉmi, cʉ caquẽ netoricʉ aniri. To bairo áti, cʉ yarãre na ricawoboʉmi cʉ̃re cʉ caemariquere, na caĩ buioyupʉ Jesu. Sataná netoro catutuaʉ yʉ ã ĩi, na caĩ buio majioñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’ “Dio cʉ cajooricʉ ãmi,” yʉre caĩquẽna yʉ yarã me ãma. Yʉ cabuiorijere caapipajeegaquẽna aniri aperãre yʉre caapipajeeboparãre na matarã áama, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ape wame quena ocõo bairo caĩ buioyupʉ Jesu: —Wãti camajocʉre cabuti weoricʉ oco camanopʉ aáteñaʉmi cʉ cãniparore macaʉ aácʉ. Bʉgaquẽcʉ ocõo bairo ĩ tʉgooñaʉmi: “Yʉ cabutiepaʉpʉrena yʉ tunu jãagʉ moquena,” ĩimi. ");
INSERT INTO tav_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cʉ̃pʉre tunu jãagʉ caroaro owa quenoorica wiire bairo cãcʉre tʉjʉʉmi. ");
INSERT INTO tav_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","To baii cʉ cãno tʉjʉri wãtia aperã siete cãnacãʉre cʉ netoro caroorã majuure na pijo, na menapʉ cʉ̃pʉre jãʉmi. To bairi caroorã majuu wãtia capãarã cʉ mena na cãno cajʉgoye cʉ cãnato netoro majuu rooro ãcʉmi, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","To bairije Jesu cʉ caĩ ani paʉ cãromio jĩcao camaja watoapʉ cãco caĩ awajayupo: —¡Caroaro majuu wariñuomo mʉ camacʉ cʉtaco, mʉre caũpuorico! caĩñupo Jesure. ");
INSERT INTO tav_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesu maca to bairo co caĩ awajaro apii: —Dio Wadariquere caapirã tiere caroaro cána na maca wariñuu netogarãma, co caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Camaja aperã capãarã Jesu tʉpʉ na caejanemoro tʉjʉʉ ocõo bairo na caĩ buioyupʉ: —Ati yʉtea macana ñuuqueti majuucõama. Caroorã aniri, “Caacʉori wame jã áti iñooña, ‘Dio cʉ cajooricʉ ãmi,’ mʉre jã caĩ majiparore bairo ĩi,” yʉ ĩma. To bairo na catʉjʉgarije to nibao joroquena ati wame jetore na yʉ ĩ buiogʉ. Tirʉmʉpʉre Jonás cawamecʉcʉre Nínive na caĩri macapʉ cʉ cajooyupʉ Dio, yʉ ye quetire na buioʉja ĩi. Jonáre caacʉori wame cʉ cabairo catʉjʉyuparã Nínive macana. Caacʉori wame tʉjʉrã, “Dio cʉ cajooricʉ ãcʉmi Jonás,” caĩ tʉjʉyuparã Nínive macana. To bairo cʉ cabairicarore bairona bairo caacʉori wame yʉre baigaro. Ti wame yʉ cabairi wame jetore tʉjʉgarãma ati yʉtea macana, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Caroorãre Dio na cʉ capopiyeyeri paʉ cãnopʉ Seba cawamecʉti yepa ʉpao tirʉmʉpʉ macaco ati yʉtea macanare, “Rooro majuu mʉja caapipajeequẽjupa mʉjaa,” ĩ buiogomo. Cayoaropʉ cãnaco cáajupó Salomón mari ñicʉ jãa ʉpaʉ tirʉmʉpʉ macacʉ tʉpʉ, cʉ cabuio majirijere apigo. Yʉ maca Salomón ãnacʉ netoro camajii yʉ cãnibao joroquena yʉre mʉja apigatee. ");
INSERT INTO tav_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","To bairi Jonás tirʉmʉpʉ macacʉ Dio ye quetire Nínive macana cãniñaricarã nare cʉ cabuioro caroorije na cátiere jʉtiriticõari cajanañuparã. Yʉ maca Jonás netoro cãcʉ yʉ cãnibao joroquena yʉ cabuiorijere mʉja apigatee. Caroorije mʉja cátiere mʉja tʉgooñaquẽe, mʉja janagaquẽe. To bairi caroorãre Dio nare cʉ capopiyeyeri paʉ cãnopʉ Nínive macana tirʉmʉpʉ macana, “Rooro mʉja caapipajeequẽjupa,” mʉja ĩgarãma ati yʉtea macanare, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ocõo bairo na caĩ buionemoñupʉ Jesu: —Jĩa bujuriquere jĩa bujurã cabauquẽtopʉ mari cũquẽe. Apeye jotʉ ẽoro unopʉ mari cũquẽe. Cabui maca jeto mari jĩa buju peó, camaja cajãa ejarã caroaro na tʉjʉato ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Caroaro catʉjʉ majirã mʉja cãmata caroaro mʉja áti ani maji. To bairona mʉja yeri quena Dio mena caroaro cayericʉna mʉja cãmata caroaro mʉja áti maji. Mʉja cape carooye tuaricarã mʉja cãmata apeye uniere caroaro mʉja áti majiquetiborã. To bairona mʉja yeri Dio mena mʉja cañuuquẽpata caroaro cʉ mena mʉja ani majiquẽe. ");
INSERT INTO tav_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dio yere mʉja camajirije jĩa bujuriquere bairo ã. To bairi Dio yere mʉja camajibatiere mʉja cabai botioata canaitĩarije maca to anio joroque áti rooye tuuboro. To bairi caroaro Diore áti nʉcʉbʉgocõaña. ");
INSERT INTO tav_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Caroaro Dio mena cayericʉna mʉja cãmata mʉja cáti anie caroa jeto anigaro. To bairi caroaro jĩa bujurique mena cáti ãnare bairo caroaro mʉja áti ani majigarã, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu to bairo cʉ caĩ buio yaparoro jĩcaʉ fariseo majocʉ, “Yʉ ya wiipʉ ʉgaʉ ajá,” cʉ caĩñupʉ. To bairi Jesu cʉ mena aá, cʉ ya wiipʉ jãa, ʉgarica cajawa tʉ caejanumuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","To bairo cʉ cabairo fariseo majocʉ maca ocõo bairo cʉ caĩ tʉjʉyupʉ: “¿Nope ĩi jã cátinucurore bairo cʉ wamorire cojequẽcʉna cʉ ejanumu ʉgati?” caĩ acʉa tʉjʉyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mari Ʉpaʉ Jesu maca cʉ catʉgooñarijere tʉjʉ majii ocõo bairo cʉ caĩñupʉ: —Mʉjaa fariseo maja baujarije jeto caroa mʉja átaje cʉtibapa. Jotʉ bapari cabui jeto cojericarore bairo mʉja ã, pupea macare cacojeya manore bairo. To bairi cabui macare caroarã anibaopʉnana mʉja yeri macare caroorije pairã mʉja ã. Aperã yere caemarã mʉja ã, fariseo majare na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","—Camajiquẽna mʉja ã. Jotʉ bapare caweo caroaro quenoomo cabuire, capupea quenare. To bairona Dio mari rupaʉre cájupi, mari yeri quenare cájupi. ");
INSERT INTO tav_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","To bairi cabopacarãre mʉja yeri mena na mai tʉjʉri na jooya mʉja cacʉgorijere. To bairo mʉja cáto tʉjʉʉ, “Caroarã ãma na yeripʉ quenare,” mʉja ĩ tʉjʉgʉmi Dio mʉjaare, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Rooro anigaro mʉjaare, fariseo majare. Mʉja caoteriquere to cãnacã wameacã pʉga wamo cãnacã caricacʉto jĩca mʉja joonucu Diore. Menta na caĩrijeacã, ruda na caĩrijeacã, apeye mʉja caoterijeacã nipetiro cawapa maniere, caroaro cõoñari mʉja joonucu Diore jĩca jeto. Tiere cajoorã nibaopʉnana aperãre cariape na mʉja átiquẽe. Diore cʉ mʉja nʉcʉbʉgoquẽe. To bairi Diore nʉcʉbʉgori caroaro aperãre na cátiparã mʉja anibapa, Diore apeye uniere cʉ joo janaquetiri, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Rooro anigaro mʉjaare fariseo majare, na caĩñupʉ Jesu moquena. —Camaja nipetiro na catʉjʉjoro neñapo buerica wiiripʉre ejarã ʉparã na caruirije unie jetore mʉja ruiga, camaja jãre na tʉjʉ nʉcʉbʉgoato ĩrã. Macari recomacapʉre aána camaja nipetiro caroaro mʉja na cañuu roti nʉcʉbʉgorijere mʉja apiga, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Rooro anigaro mʉjaare fariseo majare, judío majare cabuerãre. Mʉjaa maja yaarica ope cabauquẽtore bairona mʉja ã. Camaja yaarica ope buire aábaopʉnana, “Camaja yaarica ope ãno,” ĩ majiquẽnama. Ti ope pupeapʉ caboarije quenare tʉjʉ majiquẽnama. To bairo tiere na catʉjʉ majiquẽtore bairona aperã mʉja yeripʉ caroorije cãniere tʉjʉ majiquẽema, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","To bairo cʉ caĩro apii jĩcaʉ caroaro Moisé ãnacʉ cʉ caucariquere cabue majii ocõo bairo cʉ caĩñupʉ Jesure: —Jãre camajioʉ, fariseo majare na ĩ buioʉ jã quenare to bairo jã ĩ tuticõaʉ mʉ ĩ, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","To bairo cʉ caĩro: —Rooro anigaro mʉja quenare, Moisé cʉ caucariquere cabuerãre. Capee popiye majuu na tʉgooñao joroque mʉja áti roti aperãre, mʉja majuuna átiquetibaopʉnana. ");
INSERT INTO tav_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Rooro anigaro mʉjaare. Dio ye quetire cabuioricarã ãnana na maja operi buina caroa wiiriacã mʉja nʉco. To bairo ána, na cãnaje ocõo bairo cãñupa ĩrã mʉja áa. Mʉja ñicʉ jãapʉ na cajĩa jʉgo ájupa. ");
INSERT INTO tav_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mʉjaa Dio ye quetire buiori maja na cabuioriquere mʉja átiquẽe. Yʉ quenare mʉja api nʉcʉbʉgoquẽe. To bairo baibana mʉja ñicʉ jãa na cátajere mʉja cabai buicʉti aninemorijere mʉja bai iñoo aperãre. Dio ye quetire buiori majare cajĩa recõañupa. Mʉja maca na maja operi buirire caroa wiiriacãre mʉja nʉco. ");
INSERT INTO tav_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’To bairi Dio cajʉgoyepʉna cʉ camajirije mena ocõo bairo caĩñupi: “Nare yʉ buio roti joogʉ yʉ ye quetire cabuioparãre. Jĩcaarãre na jĩagarãma. Aperãre to cãnacã wame rooro na átigarãma,” caĩñupi Dio, caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","—Dio ye queti buiori maja nipetirore na cajĩa rerique wapa na popiyeyegʉmi Dio ati yʉtea macanapʉre. ");
INSERT INTO tav_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ati yepa cãni jʉgori paʉpʉna Abel cawamecʉcʉre na cajĩa jʉgorique mena, pʉʉʉ, Sacaría cawamecʉcʉre, Dio wii recomacapʉ na cajĩarique mena yapacʉ. Cariape mʉñʉja ĩ buiogʉ: Na cajĩa jʉgo atáje wapa ati yʉtea macanare tamʉorique anigaro, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Rooro anigaro mʉjaare, Moisé cʉ caucariquere cabuerãre. Tiere buebaopʉnana aperãre cariape cãnie macare na mʉja buioquẽe. Cariape macaje macare mʉja nʉcʉbʉgoquẽe. To bairo ána aperã quenare tiere na api nʉcʉbʉgoquetio joroque na mʉja ĩ matanucu, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","To bairo cʉ caĩ yaparo buti aáto bero judío majare cabuerã, fariseo maja quena seeto cʉ capunijini tʉgooñañuparã. To bairi capee cʉ cajeniña patawãcoogayuparã. ");
INSERT INTO tav_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","To bairi seeto cʉ catʉjʉ pojerooyuparã. “Ricati cʉ cabuioata ʉparãre cʉ mari wadajãgarã,” ĩrã cabaiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Camaja capãarã Jesure apigarã cʉ tʉpʉ caneñapo ejayuparã. Capãarã majuu aniri na majuuna caame cʉtayuparã. Mai, cʉ cabuerã jetorena na neopori na cabuio jʉgoyupʉ Jesu: —Fariseo maja na ya wame pan to wauato ĩrã levadura na caĩrije tiepʉ na caajurijere caroaro tʉjʉ majiri tiere átiquẽja, na caĩñupʉ Jesu. To bairo ĩi, fariseo maja na cabuiori wame caĩtorijere apipajeequeticõaña ĩi, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","—Na majimi Dio caroorije na cátiere. Rooro na caĩrije quenare majimi Dio. Nipetiro na cáti rutirije to nibao joroquena camaja nipetiro na caapijoro buiogʉmi Dio, na caĩ buioyupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Yʉ mena macanare ocõo bairo mʉñʉja ĩ buio: Mʉjaare cajĩagarãre na uwiqueticõaña. Mʉja rupaʉrire jĩari bero dope bairo áti majiquẽema mʉja catiriquere. ");
INSERT INTO tav_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","To bairi Dio jetore caroaro cʉ nʉcʉbʉgoya. Jĩcaʉna ãmi mʉja catiriquere caroorã ya paʉpʉ peropʉ care majii. To bairi caroaro cʉ nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Minia wapa maama. To bairo cawapa mana na nibao joroquena jĩcaʉ macare majiqueticõa átiquẽemi Dio minia quenare. ");
INSERT INTO tav_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mʉja macare minia netoro mʉja mai tʉjʉ pojeroomi Dio. To bairi camaja rooro mʉjaare na cátigarijere tʉgooñarique pai uwiquẽja. Mʉja poa wẽriacã quenare tʉjʉ cõoña majimi Dio. To bairo mʉja cabairijere caroaro catʉjʉ cõoña majii aniri caroaro mʉja tʉjʉ pojeroo majimi Dio, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Yʉre mʉja canʉcʉbʉgorijere aperãre na ĩ buioya. “Jesu yʉ Ʉpaʉ ãmi. Caroaʉ ãmi. To bairi cʉ caboorijere yʉ átigʉ,” na ĩ uwiquẽja. To bairo caĩrã mʉja cãnoi, “Yʉ mena macana ãma,” yʉ ĩgʉ Dio tʉ macana ángel majare. Cariapena mʉñʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aperã maca bobobana, “Jesure caapi nʉcʉbʉgorã jã ã,” ĩquẽema. To bairo caĩrãre yʉ quena, “Yʉ yarã me ãma,” na yʉ ĩgʉ Dio tʉ macanare, caĩ buioyupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Camaja caroorije yʉre caĩ wada pairã na nibao joroquena na majiritio majimi Dio. Dio Espíritu Santo macare caroorije cʉ̃re na caĩ wadaro majiritioquetigʉmi Dio Espíritu Santore na cawada pairijere, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Aperã mʉja ñe aágarãma neñapo buerica wiiripʉ, maca ʉparã tʉripʉ quenare, na popiyeyeya ĩrã. To bairo mʉjaare na cáto ʉparã mʉjaare na cajeniñapere, na mʉja cayʉpere seeto tʉgooñarique paiqueticõaña. “¿Dope bairo na mari ĩrãati?” ĩ tʉgooñaquẽja. ");
INSERT INTO tav_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Na mʉja caĩ yʉpere mʉjaare majiogʉmi Dio Espíritu Santo maca mʉjaare na cajeniña tutiri paʉna. ");
INSERT INTO tav_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jesu camajare to bairo cʉ caĩ buiori paʉ jĩcaʉ camaja watoapʉ cãcʉ Jesure cʉ caĩñupʉ: —Jãre cabuei, jã pacʉ ãnacʉ ye cãnajere yʉ jʉgocʉ cʉ cacʉgorijere ricawo nuni rotiya yʉre. ");
INSERT INTO tav_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu maca ocõo bairo cʉ caĩ yʉyupʉ: —“Dio cʉ cũricʉmi apeye uniere carotipaʉre o jã caame wada netorijere cabuio matabojapaʉre,” yʉre ĩ tʉgooñaqueticõaña, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","To bairo cʉ ĩ, topʉ cãna nipetirãre na caĩ buionemoñupʉ Jesu moquena: —Caroaro api majiña. Apeye unie pairo tʉjʉ boo netoqueticõaña. Apeye unie pairo anibaopʉtona mʉja ani wariñuo joroque átiquẽto. ");
INSERT INTO tav_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","To bairo na ĩ, ati wame mena na caĩ buio majioñupʉ Jesu moquena: —Jĩcaʉ apeye unie capee cacʉgoʉ caroa yepa oterica yepa cacʉgoyupʉ. Ti yepa cʉ caoterica yepa pairo majuu carica cʉjupe cʉ caoterique. ");
INSERT INTO tav_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Capee caricacʉto tʉjʉʉ, ocõo bairo caĩ tʉgooñañupʉ: “¿Dope bairo yʉ ácʉati atie capee carica cʉtiere? Noopʉ yʉ cacũparo maa,” caĩ tʉgooñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","To bairo ĩ tʉgooña, ocõo bairona caĩ tʉgooña bʉga quenooñupʉ: “Yʉ ʉgarique cũrica wiirire yʉ recõagʉ, ape wiiri capaca wiiri macare átigʉ. Ti wiiri áti yaparoʉ topʉ yʉ caoterique ricare noo, yʉ apeye unie yʉ cacʉgorije nipetiro yʉ cũgʉ. ");
INSERT INTO tav_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","To bairo yʉ cáto yoaro petiquetigaro to bairo yʉ cáti quenoo cũrique. To bairi yʉ yerijãgʉ. Yerijã, caroa ʉga, eti, wariñuu yʉ áticõa anigʉ,” caĩ tʉgooñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","To bairo cʉ caĩ tʉgooñaro tʉjʉri Dio maca ocõo bairo cʉ caĩñupʉ: “Mʉ tʉgooña majiqueti majuucõa mʉa. Ati ñamina mʉ bai yajicoagʉ. Bai yajiri bero mʉ cacʉgobatajere mʉ cʉgo wariñuu majiquetigʉ. Aperã maca tiere cʉgo ʉjagarãma,” cʉ caĩ buioyupʉ Dio, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ti wamere queti buio majio yaparo ocõo bairo na caĩ buioyupʉ Jesu: —To bairona ãmi jĩcaʉ Diore catʉgooñaquẽcʉ apeye unie jetore camai jee cũ cʉgoʉ. Cabopacaʉre bairo cʉ tʉgooña tʉjʉmi Dio maca cʉ ũcʉre, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","To bairo na ĩ yaparo cʉ cabuerãre ocõo bairo na caĩñupʉ Jesu moquena: —Ape wame mʉñʉja ĩgʉ: Ati yepa macajere seeto tʉgooñaqueticõaña. Dope bairo mʉja cabaipere, mʉja cacʉgopere, mʉja caʉgapere, mʉja cajañapere nipetiro tʉgooñarique paiqueticõaña. ");
INSERT INTO tav_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dio marire carupeoricʉ aniri mari caʉgapere, mari cajañapere mari joo majimi tie quenare. ");
INSERT INTO tav_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Miniare na tʉgooñaña. Caoterã me ãma naa. “Mari caoterije caricacʉto tiere mari ʉgagarã,” caĩrã me ãma. Na caʉgape quenoo cũrica wiiri cãnipe quenare cacʉgorã me ãma. To bairo cabairã na nibao joroquena na numi Dio. To bairi mʉja quenare mʉja cotegʉmi Dio, miniacã netoro cʉ cámáirã mʉja cãno maca. ");
INSERT INTO tav_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ʉmʉabʉjaro mʉja bʉcʉanemo aá majiquẽna, seeto tʉgooñabaopʉnana. ");
INSERT INTO tav_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","To bairi wame cáti majiquẽna aniri apeye unie quenare catʉgooñarique paiquetiparã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Oóre tʉgooñañajate. Paaquẽtona bʉcʉa, owa, caroa baucõa. Jutii to cajañapere paaquẽe. To bairi paaquetibaopʉtona caroaro bau, mari ñicʉ jãa ãnana ʉpaʉ Salomón ãnacʉ caroa jutii cʉ cajañarique netoro. ");
INSERT INTO tav_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","To bairona bai tie ta. Yoaro mee catí, canaiori paʉ cãnona jini, ape rʉmʉ peropʉ joe re ecoocõaro. To bairo yoaro mee cajinipe to nibao joroquena caroa cabaupere joomi Dio tie tare. To bairi, “Mari roquere mari cacʉgopere mari joogʉmi Dio,” cʉ ĩ tʉgooña nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","To bairi seeto tʉgooñarique paiqueticõaña mʉja caʉgapere, mʉja caetipere. ");
INSERT INTO tav_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ati yepa macana Diore canʉcʉbʉgoquẽna seeto tʉgooñama tiere. Mʉja macare mʉja cacʉgopere majitʉgami mʉja Pacʉ ʉmʉrecoo macacʉ. ");
INSERT INTO tav_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","To bairi Dio ye macare tʉgooña nʉcʉbʉgo netoña, ati yepa macaje apeye unie macare boo neto tʉgooñaquẽnana. To bairo mʉja cabairo mʉja joonemogʉmi Dio ati yepa macaje mʉja caboo rʉjarijere, caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ocõo bairo caĩ buionemoñupʉ Jesu: —Petoacã cãna yʉ yarã mʉñʉja ĩ. Tʉgooñarique pai uwiqueticõaña. Mʉja Pacʉ Dio mʉjaare tʉjʉ wariñuumi. To bairi cʉ mena caroare cacʉgoparã mʉja cãno boomi. ");
INSERT INTO tav_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mʉja ye apeye uniere mʉja cacʉgorijere joo, wapa jeeya. Wapa jeeri, cabopacarãre na jooya. Ati yepa macaje caboapere tʉgooñaquẽja. Dio ye, caboaquetipe macare tʉgooñaña. Dio tʉpʉ mʉja cacʉgope capetiquẽtie anicõa anigaro. Topʉre jee rutiri maja manigarãma. Topʉ mʉja cacʉgorijere caroorã unaacã caʉga rooye tuu reparã manigarãma ʉmʉrecoopʉre. ");
INSERT INTO tav_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mʉja camai netorije cãnopʉre caroaro tʉgooñari tie jetore mʉja tʉgooñacõa aninucugarã. To bairi Dio ye maca jetore áti tʉgooñacõaña, caĩ buioyupʉ Jesu. Ocõo bairo caĩ buionemoñupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Yʉ catunu atípere tʉgooñari mʉja yeri macajere caroaro quenoocõaricarã ani yuuya. Jĩa bujurique pẽo bujuricarore bairo átana anicõaña. ");
INSERT INTO tav_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cʉ paari maja na ʉpaʉ wamo jiarica boje rʉmʉ cãno cʉ cáaáto bero cʉ catunu ejaparore cʉ yuurãma. To bairi tunu ejaʉ jopepʉ na cʉ cajeniñaro apirã nemoo cʉ boca pã jõorãma. ");
INSERT INTO tav_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Caniquẽnana caroaro cʉ̃re cayuuricarã aniri na ʉpaʉ cʉ catunu ejaro seeto wariñuurãma. Cariapena mʉñʉja ĩ buio. To bairo na cabairo na ejaʉ na ʉpaʉ nemoo ʉgarica cajawapʉ na rui roti, ʉgarique na ricawo nuʉmi. Cʉ majuuna na ʉpaʉ nibaopʉcʉna na ʉgarique ricawo nuʉmi. ");
INSERT INTO tav_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","To bairi ñami recomaca o cabuju atí paʉ cacaniquẽnare cʉ cabʉga ejarã aniri wariñuurãma. To bairi nare bairona cátiparã mʉja ã, yʉ catunu atíparo jʉgoye mʉja yeri quenoo yuurãa. ");
INSERT INTO tav_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ape wame quenare tʉgooñaña. Wii ʉpaʉ, “Ati ñami to capaʉ majuu ejagʉmi jee rutiri majocʉ,” ĩ majiquẽcʉmi. Cʉ camajiata caroaro bipe, caniquẽcʉna coteboʉmi, jee rutiri majocʉ jãaremi ĩi. ");
INSERT INTO tav_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","To bairona yʉ quenare, “To capaʉ majuu tunu ejagʉmi jã Ʉpaʉ,” mʉja ĩ majiquetigarã. To bairi caroaro yʉ catunu atípere tʉgooñarã caroaro yʉ caboorije jetore áticõa aninucuña, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","To bairi Pedro maca Jesure cʉ cajeniñañupʉ: —Ʉpaʉ, ¿atie camaja nipetirore na buioʉ mʉ ĩti? O ¿jã jetore que buioʉ mʉ ĩti? ");
INSERT INTO tav_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","To bairo cʉ caĩro Jesu caĩnemoñupʉ moquena: —Ʉpaʉ jĩcaʉ aperopʉ aágʉ jʉgoye cʉ paabojari majocʉ jĩcaʉre ocõo bairo cʉ ĩimi: “Yʉ paabojari majare na capaapere na rotiya. Na caʉgapere to cãnacã rʉmʉ na jooya.” ");
INSERT INTO tav_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","To bairo cʉ ĩri aperopʉ aáteñaʉmi. Cáaáteñaʉ aátacʉ tunu ejaʉ cʉ yere carotibojaʉ cʉ caĩ rotiricarore bairona caroaro cʉ cáto tʉjʉ, seeto cʉ wariñuu tʉjʉʉmi. ");
INSERT INTO tav_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cʉ wariñuu tʉjʉri, “Nipetiro yʉ yere yʉ ẽoro macacʉ carotii mʉ anigʉ,” cʉ ĩ, ʉpaʉ jõʉmi. ");
INSERT INTO tav_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Cʉ̃re carotibojaʉ rooro cʉ cápata, “Yoaro bauquetigʉmi yʉ ʉpaʉ,” ĩ tʉgooñari, cʉ ʉpaʉ paari majare na quẽ, jibiorique caeti pairã mena eti cumu, ʉga paca, cʉ cabaiata rooro popiyeye ecooboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","“Yʉ ʉpaʉ di rʉmʉ, noo capaʉ cãno majuu tunu atígʉmi,” cʉ caĩ majiqueti paʉna cʉ tunu ejaboʉmi cʉ ʉpaʉ yua. Tunu eja, caroaro cʉ cacotequetajere tʉjʉ, aperã caroorã, cʉ̃re caapipajeequẽna menapʉ cʉ rocacõaboʉmi caroorã na cãnopʉre. ");
INSERT INTO tav_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","To bairi paa coteri majocʉ cʉ ʉpaʉ cʉ caboorijere majibaopʉcʉna cʉ carotirijere átiquẽcʉna cabai botioʉ ũcʉre seeto cʉ popiyeyegʉmi cʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Apei cʉ paa coteri majocʉ macare cʉ caboorijere cariape cáti majiquẽcʉ cʉ cãnoi jĩabʉjana cʉ popiyeyegʉmi cʉ macare. To bairi na ʉpaʉ caroaro cʉ caboorijere cáti majirãre, “Caroaro ája,” na ĩgʉmi. Aperã na netoro camajirã macare, “Seeto majuu na netoro caroaro ája,” na ĩgʉmi na ʉpaʉ. “Jĩabʉjana camajirã netoro camajirã mʉja ã. To bairi caroaro ája mʉjaa,” na ĩgʉmi. To bairi mʉja cáti majiri wame cõo mʉja cátipere boomi Dio, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","’Ati yepapʉ yʉ caejawʉ, Dio Espíritu Santore camaja na yeripʉre joʉ acʉ́. Na yʉ cajooparo jʉgoye yʉ capopiye tamʉope anigaro. To bairi yʉ capopiye tamʉope uwaro to cayaparoro yʉ boobapa. ");
INSERT INTO tav_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ati yepapʉ ejami Jesu, caroa ãnajere joogʉ,” yʉ ĩ tʉgooñaquẽja. Yʉ caejarije jʉgori camaja ricati yʉ cãniere tʉgooñabana ame tuti, ame quẽgarãma. ");
INSERT INTO tav_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Camaja jĩcaʉ punaa nibaopʉnana, “Jĩcarona caroaro mari anigarã,” ĩ majiquetigarãma. ");
INSERT INTO tav_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jĩcaʉ yʉ boogʉmi. Apei maca yʉ booquetigʉmi. To bairi capacʉ cʉ macʉ mena ame tutigarãma. Capaco co maco mena ame tutigarãma. To bairona ame bai punijinigarãma jĩcaʉ yʉre caboʉ, apei maca yʉre cabooquẽcʉ, to bairo anibana, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Camajare ocõo bairo na caĩ buionemoñupʉ Jesu moquena: —Muipʉ cʉ caroca jãa atí nʉgoa macare oco bʉrʉri mʉja catʉjʉata, “Oco ocagaro bai,” mʉja ĩ tʉjʉ majirã. To bairo mʉja caĩrore bairona ocaro. ");
INSERT INTO tav_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wino cajõcʉ nʉgoa macai to capapuro tʉjʉrã, “Ajigaro bai,” mʉja ĩ. To bairo mʉja caĩrore bairona ajiro. ");
INSERT INTO tav_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mʉjaa ʉmʉrecoo macajere dope bairo cabaurije tʉjʉrina ati yepa macajere to bairona baigaro bai, mʉja ĩ tʉjʉ maji. To bairo catʉjʉ majirã nibaopʉnana, ¿Nope ĩrã ato cõo mʉñʉja cáti iñoobatie macare to bairo ĩgaro áa, mʉja ĩ majigaquẽeti? To bairi, “Camajirã jã ã,” caĩtorã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Nope ĩrã mʉja majuuna, “Atie cariape macaje cátipe ã,” mʉja ĩ tʉgooña beje majiquẽeti? ¿Nope ĩrã mʉja majuuna caroare mʉja tʉjʉ beje majiquẽeti? ");
INSERT INTO tav_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Apei, “Rooro yʉ mʉ ájupa, to bairi yʉ mʉ wapamo,” mʉjaare ĩ tutiri, ʉparãpʉre cʉ cawadajãgaro nemoo cʉ mena oca quenoocõaña. Cʉ mena mʉja caoca quenooquẽpata ʉpaʉ jues tʉpʉ mʉja jooboʉmi. Cʉ mena mʉja caoca quenoata jues tʉpʉ mʉja jooquetigʉmi. To bairo mʉja caĩ oca quenooquẽpata jues tʉpʉ mʉja cʉ cajooro cʉ maca polisía maja ʉpaʉre cʉ pijo átiri, presopʉ mʉjaare cʉ cũ rotiboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","To bairi presopʉ mʉja na cajooro nipetiro mʉja cawapamorijere mʉja cawapaye peoquẽpata mʉja buuquetiborãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesu camajare cʉ cabuio ani paʉ aperã cʉ tʉpʉ caejayuparã. Eja, Pilato, ti maca ʉpaʉ jĩcaarã Galilea macanare na cʉ cajĩa rotiriquere Jesure cʉ cabuioyuparã. Pilato ocõo bairo na cáti jĩa rotiyupʉ. Na maca waibʉcʉrãre jĩa joe buje mʉgori Diore áti nʉcʉbʉgorã cátibajuparã. To bairo na cáti ani paʉna Pilato cʉ cajĩa rotiricarã ejari, na cajĩa recõañuparã. ");
INSERT INTO tav_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","To bairo na caĩ buiorijere apii ocõo bairo na caĩñupʉ Jesu: —¿Dope bairo mʉja ĩ tʉgooñati mʉjaa? Na yarã aperã netoro caroorije cána aniri jĩa ecooricarãma, ¿mʉja ĩ tʉgooñati? ");
INSERT INTO tav_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","To bairo cabaiquẽjupa. Cariape mʉñʉja ĩ buiogʉ. Mʉja quena caroorije mʉja cátajere tʉgooñarique pairi mʉja cawajoaquẽpata to bairona mʉja tamʉo yajigarã mʉja quena, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—Ape wame quenare mʉñʉja ĩ buio. Siloépʉ na cawe nʉcorica tutu capua ña aáto dieciocho cãnacãʉ camaja cajĩa ecooyuparã ti tuture. Aperã Jerusalén macana netoro caroorije cána aniri jĩa ecooricarãma, ¿mʉja ĩ tʉgooñati? ");
INSERT INTO tav_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","To bairo cabaiquẽjupa. Mʉja quena caroorije mʉja cátajere tʉgooñarique pairi mʉja cawajoaquẽpata to bairona mʉja tamʉo yajigarã mʉja quena, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","To bairo na ĩri bero queti buio majiorica wame ocõo bairo na caĩ buioyupʉ Jesu: —Jĩcaʉ camajocʉ cʉ ya wejepʉre higuera cawamecʉtii yucʉre caoteyupʉ. Cabero, “Mere rica cʉticoato,” ĩi catʉjʉ aábajupʉ. Carica mañupe. ");
INSERT INTO tav_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Carica mano tʉjʉri cʉ ya wejere capaabojaʉre ocõo bairo cʉ caĩñupʉ: “Itia cʉma aápá. Atii ricare jeegʉ nairoacã yʉ tʉjʉ atínucubapa. Jĩca unoacã yʉ bʉgaquẽe. To bairi tiire queti rocacõaña. Cañuuquẽtii majuuna apeye caroa macare yʉ caoteborore mata tʉjʉnucu.” ");
INSERT INTO tav_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","To bairo cʉ caĩro: “Ʉpaʉ, mari rocaquẽna mai. Tii pʉtore yʉ yejea aju õwa tuuñagʉ, ¿ape cʉma to rica cʉtiquetibocʉti? ĩi. To carica cʉtiqueticõaata to cõona mari queti rocacõagarã,” cʉ caĩñupʉ cʉ capaabojaʉ, caĩ buioyupʉ Jesu. Tiere to bairo ĩi camaja na cawajoapere na yʉ yuugʉ mai, nemoona na yʉ popiyeyequetigʉ ĩi, to bairo caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jĩca rʉmʉ yerijãrica rʉmʉ cãno neñapo buerica wiipʉ camajare na ĩ buio ãcʉ cájupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ti wiipʉ cãñupo cãromio cáaá wamʉnʉca po aá majiquẽco. Yeri wãti to bairo co baio joroque co cájupʉ. Dieciocho cʉmari to bairo cabai ãco cãñupo. ");
INSERT INTO tav_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu cõre co tʉjʉ, co capijoyupʉ: —Mʉ cariaye cʉtiere mʉ yʉ netoocõa, co caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","To bairo co ĩna, cʉ wamori mena co cañu peoyupʉ. Co cʉ cañu peorona mere cariape cawamʉ poyupo. Wamʉ pona, Diore, “Seeto ñuubʉja,” caĩ wariñuuñupo. ");
INSERT INTO tav_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Neñapo buerica wii ʉpaʉ Jesure cʉ capunijini tʉjʉyupʉ, yerijãrica rʉmʉrena co cariaye cʉtiere co cʉ canetooro tʉjʉri. Punijini tʉjʉri, camajare ocõo bairo na caĩñupʉ: —Seis rʉmʉrina ã paarica rʉmʉri. To bairi ti rʉmʉri paarica rʉmʉri jetore netoo rotira ajá mʉja cariaye cʉtiere. Yerijãrica rʉmʉ capaaya mani rʉmʉre mʉja cariaye cʉtiere netoo rotira atíqueticõaña, na caĩñupʉ ti wii ʉpaʉ to cãnare. ");
INSERT INTO tav_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","To bairo cʉ caĩrijere apii mari Ʉpaʉ Jesu ocõo bairo cʉ caĩñupʉ: —Seeto caĩto pairã majuu mʉja anicõa. Yerijãrica rʉmʉ to nibao joroquena mʉja yarãre wecʉare, o burrore jia tu nʉcoricarãre na popiori na tʉ̃ga aá átiri ocore na mʉja tĩaborã na etirica paʉpʉre. ");
INSERT INTO tav_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","To bairona atio Abraham ãnacʉ pãrameo quenare yerijãrica rʉmʉ to nibao joroquena co cátipe ã. Cõre canetoope ã Sataná yoaro jiaricarore bairo co cʉ cátibatajere. Yerijãrica rʉmʉ to nibao joroquena to bairo co cátipe ã, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","To bairo cʉ caĩro apirã cʉ capunijini tʉjʉricarã maca nipetiro dope bairo cʉ caĩ wada canamu majiquẽjuparã. Aperã maca camaja pato cawariñuuñuparã Jesu caroaro cʉ cáti iñoorijere tʉjʉrã. ");
INSERT INTO tav_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Ocõo bairo na caĩ buio majioñupʉ Jesu moquena: —Ʉpaʉ Dio cʉ cãnie queti ocõo bairo ã: Jĩcaʉ cʉ ya wejepʉ jĩca ape mostasa cawamecʉtii rica apeacãre oteimi. Tii putiro pairicʉ majuu bʉcʉaro. To bairi tiipʉre minia eja, na ria bati cãnipere peorãma tii rʉpʉripʉre. Tii apeacãre bairona ani jʉgo Ʉpaʉ Dio cʉ cãnie queti. Cabero pairicʉ cabʉtirore bairona nipetiropʉ cʉ ye queti jeja aáto. Minia to na capeja ani wariñuurore bairona camaja Jesure apipajeeri yerijã wariñuuriquere bʉgagarãma ĩi, to bairo caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Ocõo bairo caĩñupʉ Jesu moquena: —Ʉpaʉ Dio cʉ cãnie queti ati wamere bairo ã: Cãromio pan átigo trigo pocare itia bapa jee átiri oco mena pʉgo ajuomo. Cabero moquena tiepʉre petoacã levadura na caĩrijere ajuomo, to wauato ĩo. Tieacã mena co caajurona pan cãnipa bʉrʉa pairo wauacoato yua. Tieacã cawauorije ti bʉrʉa nipetiro cawauarore bairona Ʉpaʉ Dio cʉ cãnie queti quena ati yepa nipetiropʉ jeja batecoato. ");
INSERT INTO tav_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Cabero Jesu Jerusalẽpʉ aácʉ cʉ caneto aáto cãnacã macapʉrena camajare na cabuio neto aájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","To bairo cʉ caĩ buio aátopʉ jĩcaʉ Jesure cʉ caĩ jeniñañupʉ: —Jã Ʉpaʉ, ¿petoacã na nicʉti Dio cʉ cacatiorã mʉ tʉpʉ caneto ejaparã? To bairo cʉ caĩro: ");
INSERT INTO tav_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Capãarã Dio tʉpʉ ejagabaopʉnana eja majiquetigarãma, Diore canʉcʉbʉgoquẽna aniri. Mʉja maca Diore caapi nʉcʉbʉgorã caéjaqueti jopeacãpʉ cajãa aánaacãre bairona mʉja ã, jĩcaarãacã aniri. To bairi ti jopeacãpʉ cajãagarãre bairo maca anicõaña Dio cʉ catʉjoorije átiri. ");
INSERT INTO tav_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Apeye na caĩ buio majioñupʉ Jesu moquena: —Wii ʉpaʉ cʉ cabia jãato bero cʉ jopepʉ cañoje tʉjʉnucurãre bairona mʉja anigarã Dio tʉpʉre jãagarã. To bairi mʉjaa, “Ʉpaʉ, jã pã jõo joʉ ajá,” cʉ mʉja ĩbagarã. To bairo mʉja caĩrijere mʉja yʉquetigʉmi. “Mʉjaare yʉ majiquẽe. Noo macana mʉja ãnaa ta, mʉñʉja majiquẽe,” mʉja ĩcõagʉmi. ");
INSERT INTO tav_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","To bairo cʉ caĩro ocõo bairo mʉja ĩcõa ani bʉgañagarã: “Jãana mʉ mena jã cabapacʉti eti ʉganucuwʉ. Jã ya macapʉre Dio ye quetire mʉ cabuio teñawʉ,” cʉ mʉja ĩgarã. ");
INSERT INTO tav_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","To bairo cʉ mʉja caĩro, “Mʉñʉja majiquẽe, mere mʉñʉja ĩwʉ. Aperopʉ aánaja. Caroorã mʉja ã nipetiro,” mʉja ĩgʉmi. ");
INSERT INTO tav_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Topʉ Ʉpaʉ Dio cʉ cãnopʉ Abraham, Isaá, Jacobo, Dio ye quetire cabuioricarã tirʉmʉpʉ macanare Dio tʉpʉ cãnare na mʉja tʉjʉgarã. Na tʉjʉrã, “Marire recõañupi,” mʉja ĩ tʉgooñarique paigarã. “¡Agʉ!” mʉja ĩ otigarã, seeto tʉgooñarique pairique mena. ");
INSERT INTO tav_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","To bairi camaja nipetiropʉ macana Dio tʉpʉ ejagarãma. Topʉ cʉ mena ʉga ruigarãma, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","To bairo cabairi paʉre ocõo bairo baigaro: Ati yʉteapʉ cãna jĩcaarã cawatoa cãna na caĩ tʉgooñabatana maca ʉparãre bairo anigarãma Dio tʉpʉ. Aperã ati yʉteapʉ cãna jĩcaarã caʉparã cãna una maca topʉre cawatoa cãna anicõagarãma, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesu to bairo camajare cʉ cabuiori paʉna fariseo maja jĩcaarã cʉ tʉpʉ caejayuparã. Cʉ tʉpʉ eja, ocõo bairo cʉ caĩñuparã: —Ʉpaʉ Herode mʉ jĩagami. To bairi uwaro aperopʉ aácʉja. ");
INSERT INTO tav_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","To bairo cʉ na caĩro: —Herodere caĩtorique paiire ocõo bairo cʉ ĩ buioya: “ ‘Yucʉ, bujuye camaja na yeripʉ cajañarã wãtiare na yʉ buu rebojagʉ mai. Cariayecʉna quenare na yʉ catiogʉ. Bujuye ape rʉmʉ maca to cõona yʉ áti yaparogʉ,’ ĩmi Jesu,” cʉ ĩña Herodere. ");
INSERT INTO tav_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bujuye ape rʉmʉpʉ yʉ eja aágʉ Jerusalẽpʉre. To bairi yucʉ, bujuye, to bairona áticõa ãcʉ yʉ áa mai Jerusalẽpʉ yʉ caeja aáparo jʉgoye. Topʉ ejaʉ to cõona yʉ áti janacõagʉ tiere. Jĩcaʉ maca Dio ye quetire buiori majocʉ aperopʉ Jerusalén cãniquẽtopʉ jĩa ecoorique maa, na caĩñupʉ Jesu. To bairi Jerusalẽpʉ na cajĩapaʉ yʉ ã ĩi, to bairo na caĩ buioyupʉ Jesu fariseo majare. To bairo na ĩ, ocõo bairo caĩñupʉ Jesu Jerusalén macanare: ");
INSERT INTO tav_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Mʉjaa Jerusalén macana Dio ye quetire cabuiorãre cajĩa rerã mʉja ã. Mʉja tʉpʉ Dio cʉ cabuio roti joobanare ʉ̃ta rupaa mena care jĩarã mʉja ã. Mʉjaare maii capee yʉ tʉpʉ mʉñʉja pi neonucugabapa. Ãboco co punaacãre maio nare co cajee neo cũrore bairona mʉñʉja átiganucubapa. Yʉre mʉja booquẽe. ");
INSERT INTO tav_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","To bairi mʉja cãni paʉre rocagʉmi Dio. Cariapena mʉñʉja ĩ. Mere to cõona yʉ mʉja tʉjʉ tʉja. Yʉre mʉja tʉjʉnemoquetigarã ati yepapʉ yʉ catunu atíparo jʉgoye. Ti paʉ cãno yʉre tʉjʉrã ocõo bairo yʉre mʉja ĩgarã: “Cajʉgoyepʉ Dio, ‘Cʉ yʉ joogʉ,’ cʉ caĩricʉna ãmi Jesu. Cañuu majuucõaʉ ãmi,” yʉre mʉja ĩgarã, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jĩca rʉmʉ na yerijãrica rʉmʉ cãno Jesu caʉgaʉ aájupʉ fariseo majocʉ ʉpaʉ jĩcaʉ cʉ ya wiipʉ. Topʉ cʉ cãno fariseo maja seeto Jesure cʉ catʉjʉ coteyuparã. ");
INSERT INTO tav_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Topʉ Jesu riape majuure cãñupʉ jĩcaʉ rupaʉna cabipii. ");
INSERT INTO tav_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","To bairi judío majare cabuerãre, fariseo maja quenare na cajeniñañupʉ Jesu: —Yerijãrica rʉmʉ cãno ¿Moisé cʉ caucarique cariaye cʉnare to catio rotiquetibaupari? ");
INSERT INTO tav_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","To bairo na cʉ caĩ jeniñaro dope bairo cʉ caboca ĩ yʉquẽjuparã. To bairi cariaʉre cʉ pañari cʉ cacatioyupʉ Jesu. Cʉ catio yaparo cʉ catunu aá rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cʉ tunu aá rotiri bero cʉ̃re catʉjʉ coterãre ocõo bairo na caĩñupʉ: —Mʉja yaʉ burro, o wecʉ oco jeerica opepʉ cʉ caroca jãa aápata nemoona cʉ mʉja ne buuborã yerijãrica rʉmʉ to nibao joroquena, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na maca dope bairo cʉ caĩ yʉ majiquẽjuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseo majocʉ, yʉ tʉpʉ na ʉgaato ĩi, cʉ capijoricarã caroa paʉri ʉparã na caruirijepʉre na cabeje ruiro tʉjʉri ocõo bairo na caĩ buioyupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Wamo jiarica boje rʉmʉ mʉjaare na caʉga rotiata ʉparã na caruirijere ruigaqueticõaña. Ʉparã yepʉre mʉja caruiata jĩcaʉ mʉja beropʉ caʉpaʉ maca ejaboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Cʉ caejaro, “Ani ʉpaʉ cʉ caruiparore wamʉnʉcaña. Jõ maca ruija,” mʉja ĩboʉmi mʉjaare capijoricʉ. To bairo mʉja cʉ caĩro aperã na catʉjʉjoro boboro mʉja baiborã. ");
INSERT INTO tav_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","To bairi mʉja na caʉga rotiata caʉjaro maca ruiya mʉjaa. To bairo mʉja cabairo tʉjʉʉ mʉjaare caʉga rotiricʉ mʉja ĩgʉmi, “Yʉ yaʉ, atobʉjaacã ʉparã mena ruiya,” ĩboʉmi. To bairo mʉja cʉ caĩro apirã mʉja tʉ caruirã boboro tʉjʉquetigarãma. “Ati maja cañuurã ãñupa,” mʉja ĩgarãma. ");
INSERT INTO tav_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nii, “Cãni majuʉ yʉ ã, cʉ majuuna caĩ tʉgooñaʉ cawatoa macacʉ cʉ anio joroque cʉ cũgʉmi Dio.” “Cawatoa cãcʉ yʉ ã yʉa,” caĩi maca aperã netoro cãcʉ anigʉmi, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na ĩ yaparo, “Yʉ mena ʉgaya,” cʉ caĩricʉre, ocõo bairo cʉ caĩ buioyupʉ Jesu: —Mʉa aperãre mʉ mena na ʉga rotii mʉ mena macanare, mʉ bairãre, mʉ yarãre, pairo cacʉgorãre na pijoqueticõaña. Nare mʉ capijoata na quena mʉre ʉga rotirã mʉ pijo ameborãma. Nare mʉ capijo jʉgorique wapare bairona mʉ ĩrã mʉ ĩborãma. ");
INSERT INTO tav_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mʉ tʉpʉ aperãre mʉ caʉga rotigaata cabopacarã macare na pijoya. Cáaá majiquẽnare, jĩca rʉpo carooye tuaricarãre, cacape manare, to bairo cabairã macare na pijoya. ");
INSERT INTO tav_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","To bairo mʉ cáto wariñuuriquere mʉ joogʉmi Dio. Na maca mʉ ʉga roti ame majiquẽema. Mʉ maca to bairo ácʉ Dio yarã caroarã na catunu catiri paʉpʉre caroa majuure mʉ bʉgagʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","To bairo Jesu cʉ caĩro apii jĩcaʉ cʉ mena caʉgaʉ ocõo bairo cʉ caĩñupʉ Jesure: —Ʉpaʉ Dio cʉ cãnopʉ cʉ mena caʉgaparã wariñuugarãma, cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesu maca ocõo bairo cʉ caĩ buio majioñupʉ: —Jĩcaʉ caroaro boje rʉmʉ áti ʉgagʉ caquenooñupʉ. Quenoo yaparori capãarã majuure na cáatí roti joobajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Caʉgapa paʉ majuu cãno cʉ paa cotebojari majocʉre, “Yʉ mena caʉgaparã yʉ cabuioricarãre, ‘Mere na ʉgara aparo. Yʉ quenoo yaparo mʉja ĩ joomi,’ na ĩ buioʉja,” caĩñupʉ. To bairi cʉ paabojari majocʉ maca na cabuioʉ aábajupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","To bairo na cʉ caĩ buioʉ ejarijere apirã nipetiro cʉ capibatana, “Jã aá majiquẽe,” cʉ caboca ĩñuparã. Jĩcaʉ ocõo bairo cʉ caĩñupʉ: “Jĩca yepa oterica yepa yʉ wapaye yaparo. To bairi yucʉacã ti yepare tʉjʉ aácʉ yʉ áa. To bairi, ‘Atí majiquẽemi,’ cʉ ĩña mʉ ʉpaʉre,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Apei, “Pʉga wamo cõo cãnacãʉ wecʉare na yʉ wapaye yaparo. To bairi yucʉacã na tʉjʉ aácʉ yʉ áa mai. To bairi, ‘Atí majiquẽemi,’ cʉ ĩña mʉ ʉpaʉre,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Apei quena, “Yʉ nʉmo cʉticoapʉ yucʉacãna. To bairi yʉ aá majiquẽe,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","To bairo na caĩro catunucoajupʉ paabojari majocʉ cʉ ʉpaʉ tʉpʉ. Tunu aá, cʉ ʉpaʉre na caĩrica wame cõo cʉ cabuio peocõañupʉ. To bairo na caĩriquere apiri, capunijiniñupʉ caʉpaʉ. Punijini, cʉ paabojari majocʉre ocõo bairo cʉ caĩñupʉ yua: “Uwaro macapʉ aácʉja. Nipetiro maca watoaripʉ noo cãni paʉriacãpʉ cãna cabopacarã macare na piya. To bairi cáaá majiquẽnare, cacape tʉjʉquẽnare, carʉpori rooye tuaricarãre, to cãnacã paʉ macana to bairo cabairã jetore na piya.” ");
INSERT INTO tav_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","To bairi cʉ paabojari majocʉ cʉ ʉpaʉ cabopacarãre cʉ capi rotiricarore bairona na capii aájupʉ. Na pi yaparo ocõo bairo cʉ caĩñupʉ cʉ ʉpaʉre: “Ʉpaʉ, yʉ mʉ carotiricarore bairona yʉ pi yaparowʉ. To baibao joroquena wii maca jiraquẽe mai,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","To bairo cʉ caĩro apii ocõo bairo cʉ caĩñupʉ cʉ ʉpaʉ moquena: “Aácʉja maca tʉjaroripʉ macanare ma mʉ cáaáti paʉ cãna quenare na piija. To bairo mʉ cáto yʉ wii jiragaro yua,” cʉ caĩñupʉ paabojari majocʉre cʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Yucʉra yua yʉ caʉga roti jʉgobatana maca ʉgaqueti majuucõagarãma, jocʉ mee yʉ ĩ,” cʉ caĩñupʉ cʉ ʉpaʉ, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Camaja capãarã Jesure cʉ caʉja aájuparã. To bairo na cabairo Jesu na amejore nʉca tʉjʉri, ocõo bairo na caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Aperã mʉja camairo netoro yʉre maiña. Yʉre mʉja camairo netoro aperã macare mʉja camaiata yʉ mena macana mʉja ani majiquetigarã. To bairi mʉja pacʉare, mʉja nʉmoare, mʉja punaare, mʉja bairãre, mʉja cãniecʉtie quenare mʉja camairo netoro yʉre maiña. ");
INSERT INTO tav_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yʉa yʉ popiye tamʉogʉ. Apei yʉ cabuei anigabaopʉcʉna, “Cʉ cabairicarore bairo yʉ popiye tamʉogatee yʉa,” caĩi ũcʉ maca yʉ mena macacʉ aniquetigʉmi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Jĩcaʉ caʉmʉari wiire átigʉ cʉ niyerure cõoña jʉgoʉmi, ti wiire paarique wapa ¿yʉ cawapayepe to ejagabapari? ĩi. ");
INSERT INTO tav_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cʉ cacõoña jʉgoquẽpata ti wii recomaca cãnona cʉ niyeru cʉ cawapayerique peticoaboro. To bairi cʉ cátibata wiire áti yaparo majiquetiboʉmi. To bairo cabairijere tʉjʉrã aperã cʉ ĩ epeborãma ti wiire capaabatacʉre. ");
INSERT INTO tav_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ani capairi wiire átigabajupi. Yaparo majiquẽjupi,” cʉ ĩ epeborãma. ");
INSERT INTO tav_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","To bairo quena jĩcaʉ ʉpaʉ apei ʉpaʉ mena cʉ caame quẽparo jʉgoye ocõo bairo tʉgooñaʉmi: “¿Yʉa peeto bʉjaacãna yʉ ʉmʉa mena cʉ maca yʉ netobʉjaro caʉmʉacʉcʉre cʉ yʉ ame quẽ ocabʉtibocʉti?” ĩ tʉgooñaʉmi. ");
INSERT INTO tav_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","To bairi apei ʉpaʉ maca jõpʉna cʉ yarã jĩari maja pato mena cʉ cãno, “Mari ame quẽqueticõato,” ĩi, cʉ queti joʉmi. ");
INSERT INTO tav_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","To bairi yʉ cabuerã anigarã caroaro tʉgooña jʉgoya mʉja cátipere. Na cacõoña jʉgoricarore bairona ája. To bairi nii cʉ yere maii tiere cacũ aáweogaquẽcʉ yʉ mena macacʉ ani majiquetigʉmi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Moa caocaarije ñuubʉja. Caocaaquẽtie macare dope bairo apeye unie ʉgariquepʉre jaña maniboro. ");
INSERT INTO tav_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Õwa turique quena ñuuquetiboro caocaaquẽtie aniri. Carepe aniboro. Noa yʉre caapirã yʉ caĩ buiorijere caroaro apiʉjaya, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Camaja yere gobiernore niyeru jeebojari maja, aperã caroorã quena Jesu tʉpʉ caejanucuñuparã, cʉ cabuiorijere apigarã. ");
INSERT INTO tav_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","To bairi fariseo maja, aperã judío majare cabuerã roorije Jesure cʉ caĩ wada pai coteyuparã: —Ani caroorãre na bapacʉti ʉganucumi, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","To bairo na caĩro apii ocõo bairo na caĩ buio majioñupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Jĩcaʉ cien ovejare cacʉgoʉ jĩcaʉ cʉ cabauquẽpata nare noventa y nueve majuu carʉjarãre caroa ta cãni paʉpʉ na cũcõari cayajiricʉre cʉ macaʉ aáboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cʉ maca bʉgacõaripʉ cʉ ne apa, wariñuuboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wariñuuri cʉ ya wiipʉ tunu eja, aperã cʉ yarãre, cʉ mena macanare neñapo rotiboʉmi. “Cʉ yʉ bʉgawʉ yʉ oveja cayajiricʉre. Mʉja quena yʉ wariñuunemorã ajá,” na ĩboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","To bairi ocõo bairo mʉñʉja ĩgʉ: Oveja cayajiricʉre cʉ cabʉga wariñuurore bairona, jĩcaʉ ũcʉ caroorije cʉ cátajere cʉ cajʉtiriti wajoa reata ʉmʉrecoopʉre Dio cʉ tʉ macana mena wariñuu netogʉmi. Aperã, “Cañuurã jã ã. Caroorije maa jãra. To bairi jã jʉtiritiquẽe,” caĩ tʉgooñarã macare na jʉgo tʉjʉ wariñuuquetigʉmi Dio cʉ tʉ macana mena, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ape wame na caĩ queti buio majioñupʉ Jesu moquena: —Cãromio pairo cawapacʉti tiiri pʉga wamo cõo cãnacã tii cacʉgoo jĩca tii cayajiro tʉjʉo jĩa bujuricarore jĩa buju átiri to cãnacã paʉpʉre owa macabomo, ti tiire bʉgago. ");
INSERT INTO tav_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ti tiire bʉgacõaripʉ wariñuo aperãre co yarãre, co mena macanare na pi neobomo, yʉ wariñuunemoña mʉja quena na ĩo. “Yʉ niyeru tii cayajirica tiire yʉ bʉgacõawʉ,” na ĩbomo. ");
INSERT INTO tav_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cariapena mʉñʉja ĩ: Co cawariñuurore bairona wariñuu netogʉmi Dio cʉ tʉ macana mena camajocʉ carooʉ caroorije cʉ cátajere jʉtiriticõari cʉ cawajoaro, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ape wame queti buio majiorica wame cabuioyupʉ Jesu moquena: —Jĩcaʉ camajocʉ cʉ punaa caʉmʉa pʉgarã cãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cabai maca cʉ pacʉre ocõo bairo cʉ caĩñupʉ: “Caacʉ, mʉ cacʉgorijere mʉ cabai yajiro bero carecomaca yʉ cʉgo ʉjagʉ. To bairi nemoona yʉ ricawoya yʉ cacʉgo ʉjapere,” cʉ caĩñupʉ. To bairo cʉ caĩro na pʉgarãpʉrena na caricawoyupʉ cʉ yere yua. ");
INSERT INTO tav_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Noo cãnacã rʉmʉ bero meena cabai maca cʉ ye apeye uniere nipetiro jee, aperopʉ cayoaropʉ cáaáteñaʉ aácoajupʉ. Topʉ cʉ cáaáteñari paʉpʉ cʉ ye niyeru cʉ pacʉ cʉ caricawobatajere caroorije cʉ caboorijerena cawapaye re peticõañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cʉ niyeru cʉ cawapaye re petiro bero ti yepapʉ quena caʉgarique peticoajupe. To bairo to cabairo seeto cañigo tamʉo jʉgoyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ñigo riabacʉ ti yepa macacʉre capaarique jenii aájupʉ. To bairi ti yepa macacʉ maca cʉ yejeare cʉ canu cote rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","To bairi na coteipʉ caroorije yejea na caʉgarijerena caʉgaganucuñupʉ, seeto ñigo riabacʉ. Camaja noa aperã cʉ caʉgarique nuquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","To bairi rooro baibacʉ cʉ yeripʉ ocõo bairo caĩ tʉgooñañupʉ: “Capãarã yʉ pacʉ ʉmʉa na ʉgarique petiquẽto. Yʉ maca ¿nope ĩi atopʉ yʉ ñigo riacʉti yʉa?” caĩ tʉgooñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Yʉ pacʉ tʉpʉ catunu aápaʉ yʉ ãcʉ. Tunu ejaʉ ocõo bairo cʉ yʉ ĩgʉ: ‘Caacʉ, rooro mʉ yʉ caoca apipajeequẽpʉ. Dio quenare to bairona rooro cʉ yʉ caoca apipajeequẽpʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mʉ macʉre bairo yʉ cʉgoqueticõaña yucʉra yua. Jĩcaʉ mʉ ʉmʉ mʉre capaabojari majocʉre bairo yʉ cʉgoya,’ yʉ pacʉre cʉ yʉ ĩgʉ,” caĩ tʉgooñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’To bairo ĩ tʉgooñari cʉ pacʉ tʉpʉ catunucoajupʉ yua. Topʉ cʉ catunu aáto jõpʉna cʉ catʉja ató cʉ pacʉ maca cʉ catʉjʉjoyupʉ. Topʉna cʉ tʉjʉjori, cʉ atʉ boca, cʉ wamo ñe, cʉ capabarioyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","To bairo cʉ caboca tʉjʉro, “Caacʉ, rooro mʉ yʉ caoca apipajeequẽpʉ. Dio quenare rooro cʉ yʉ caoca apipajeequẽpʉ. To bairi, ‘Yʉ macʉ ãmi,’ yʉ ĩqueticõaña yucʉra yua,” cʉ caĩñupʉ cʉ pacʉre. ");
INSERT INTO tav_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","To bairo cʉ caĩrije to nibao joroquena cʉ pacʉ na caĩñupʉ cʉ ʉmʉare: “Uwaro jutii caroare jeerãja cʉ cajañapere. Wamo jãrica beto cʉ cajãpa beto, rʉpo jutii cʉ cacʉtape jeerãja,” na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Wecʉre cʉ jĩarã aája, caroaro caricʉcʉ mari canunucuecʉre. Yʉ macʉ cʉ catunu ejarijere boje rʉmʉ mari áato, yʉ macʉ cʉ catunu ejarijere wariñuurã. ");
INSERT INTO tav_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ani yʉ macʉre, ‘Bai yajiricʉmi,’ yʉ ĩ tʉgooñanucubapʉ. Bai yajiquẽjupi. Catiyupi. Cáaá yajiricʉre yʉ macʉre cʉ yʉ tʉjʉ bʉga,” na caĩ wariñuuñupʉ cʉ pacʉ cʉ ʉmʉare. To bairi boje rʉmʉ cáti wariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’To bairo na cáti ani paʉ cʉ jʉgocʉ wejepʉ capaaricʉ tunu acʉ́ na cabajarijere caapi tunu ajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tiere apiri cʉ pacʉ ʉmʉ jĩcaʉre cʉ capijoyupʉ. Cʉ pijo, cʉ cajeniñañupʉ. “¿Dope bairo to baiti wiipʉre?” cʉ caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","To bairo cʉ caĩ jeniñaro, “Mʉ bai tirʉmʉpʉ cáaáteñaʉ aátacʉ tunu ejami. To bairi, ‘Bai yajiquẽjupi yʉ macʉ ĩri boje rʉmʉ mari áato,’ ĩmi mʉ pacʉ, mʉ bai cʉ catunu ejaro tʉjʉri. To bairi wecʉ caroaʉ caricʉcʉre mari canunucuecʉre jĩa rotimi, boje rʉmʉ átigʉ,” cʉ caĩñupʉ cʉ pacʉ ʉmʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","To bairo cʉ caĩ buiorijere apii punijini, cajãagaquẽjupʉ. To bairo cʉ cabairo tʉjʉʉ cʉ pacʉ maca cʉ capii buti ajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","To bairi, “Caacʉ, yoaro majuu caroaro mʉre yʉ capaanemonucuwʉ. Yʉ mʉ carotirijere mʉ yʉ ĩ botioquetinucu. To bairo mʉ yʉ cabairije to nibao joroquena jĩcaʉ nuricʉ ũcʉacãre yʉ mʉ jooquetinucu, yʉ mena macana mena boje rʉmʉ yʉ cáti ʉgabopaʉre. ");
INSERT INTO tav_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ani mʉ macʉ macare aperopʉ mʉ ye niyerure cáti bate rei aátacʉ cʉ catunu ejaro tʉjʉʉ wecʉ caroaʉ caricʉcʉre na mʉ jĩa roti, cʉ̃re boje rʉmʉ yʉ áti wariñuugʉ ĩi. To bairi caroaro cʉ mʉ átiboja mʉ niyeru cʉ mʉ cajoobatajere caroorã romiri mena cáti recõaricʉ cʉ nibao joroquena,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","To bairo cʉ caĩro, “Macʉ, yʉ mena ato mʉ aninucu mʉa. Atie yʉ cacʉgorije mʉ ye jeto ãno bai. ");
INSERT INTO tav_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ani mʉ bai cáaáteñaʉ aátacʉ, ‘Bai yajicoatacʉmi,’ yʉ caĩ tʉgooñanucubapʉ. Catiyupi. Tunu ejami. Cáaá yajiricʉre mʉ baire cʉ mari tʉjʉ bʉga moquena. To bairi cʉ̃re wariñuurã boje rʉmʉ cátipe ã,” cʉ caĩñupʉ cʉ pacʉ, na caĩ buioyupʉ Jesu camajare. ");
INSERT INTO tav_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ape wame queti buio majiorica wame na caĩ buioyupʉ Jesu cʉ cabuerãre: —Jĩcaʉ caapeye unie paii cʉ yere carotibojari majocʉ cacʉgoyupʉ. Aperã maca, “Mʉ yere ati rei áami mʉre carotibojari majocʉ,” cʉ caĩ wadajãñuparã cʉ ʉpaʉre. ");
INSERT INTO tav_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","To bairo na caĩro apii cʉ yere rotibojari majocʉre cʉ pijori ocõo bairo cʉ caĩñupʉ: “Aperã mʉ cáti rerijere yʉ buioma. To bairi mʉ cátajere cõoñari yʉ uca tu jooya. To cõona yʉ yere mʉ rotibojaquetigʉ yua.” ");
INSERT INTO tav_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","To bairo cʉ caĩro cʉ rotibojari majocʉ caĩ tʉgooñañupʉ: “Abʉ. ¿Dope bairo yʉ baiati? Yʉ ʉpaʉ yʉ buumi. Ape wame paarique caotepa yeparire yejearique uno yʉ áti ocabʉtiquẽcʉ. Boboro aperãre niyeru yʉ jeni rui teñagaqueticʉpʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Baiyupa ocõo bairo yʉ átigʉ yʉ ʉpaʉ yʉre cʉ cabuuro bero, aperã na tʉpʉ yʉre na ani rotiato ĩi, yʉre na átinemoato ĩi.” ");
INSERT INTO tav_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","To bairi cʉ ʉpaʉre cawapamorãre na cãno cõo na capi peticõañupʉ. Na pi, ocõo bairo cʉ caĩñupʉ cãni jʉgoʉre: “¿Noo cõo majuu yʉ ʉpaʉre mʉ wapamoti mʉa?” cʉ caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","To bairo cʉ caĩ jeniñaro: “Capee ʉgarique ajurique ʉje raperi cien majuu yʉ wapamo,” cʉ caĩñupʉ. To bairo cʉ caĩro: “Ruiya uwaro. Atie mʉ cawapamorije catujari pũuropʉ cincuenta raperi jeto uca tuya,” cʉ caĩñupʉ rotibojari majocʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","To bairo cʉ ĩ, apei macare moquena, “¿Noo cõo majuu mʉ wapamoti, mʉ quena?” cʉ caĩ jeniñañupʉ. “Capee, cien pori majuu capan quenoopere trigore pan cátipere yʉ wapamo yʉa,” cʉ caĩñupʉ. To bairo cʉ caĩro: “Atie mʉ cawapamorije cãni pũuropʉre rʉgaro maca, ochenta pori jeto uca tuya,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Cʉ̃re cʉ yere carotibojaricʉre cʉ caĩtorijere cʉ camajicõañupʉ cʉ ʉpaʉ. Majiri, “Cáti majii majuu ãñupi,” caĩñupʉ cʉ ʉpaʉ. Ti wamere buio yaparo ocõo bairo na caĩnemoñupʉ Jesu: —Ati yepa macana Diore caapipajeequẽna seeto áti majima na cátiere. Diore caapipajeerã na cátie na cáti majiro netoro áti majima. ");
INSERT INTO tav_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","To bairi mʉja maca apeye uniere cʉgorã tie mena aperãre na átinemoña. Cabopacarãre mʉja yere na jooya, mʉja mena na cawariñuuparore bairo ĩrã. To bairo ána ʉmʉrecoopʉre caroa ãnajere mʉja bʉgagarã. ");
INSERT INTO tav_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Jĩcaʉ õcoacãrena caroaro cacote majii pairo majuu quenare caroaro cote majigʉmi. Õcoacãrena cacote majiquẽcʉ maca pairo quenare cote majiquetiboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","To bairi ati yepa macaje apeye unieacã mena caroaro mʉja cátiquẽpata mʉja jooquetigʉmi Dio cʉ tʉ macajere caroa pairo cawapa cʉtiere. ");
INSERT INTO tav_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aperã na yere caroaro na mʉja cacotebojaquẽpata mʉja ye mʉja cacʉgope macare mʉja jooquetiborãma. ");
INSERT INTO tav_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jĩcaʉ paabojari majocʉ pʉgarã ʉparã cʉti majiquẽcʉmi. To bairo cʉ cãmata jĩcaʉre maiquetiboʉmi, apei macare maii. Jĩcaʉ cʉ carotirijere átiboʉmi, apei cʉ carotirije macare átiquẽcʉna. To bairona Diore áti nʉcʉbʉgorã apeye unie macare maiquẽja. Apeye uniere mʉja camaiata Diore mʉja áti nʉcʉbʉgo majiquetiborã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseo maja to bairo cʉ caĩrijere apirã cʉ caĩ epeyuparã Jesure, apeye uniere, niyerure camairã aniri. ");
INSERT INTO tav_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","To bairo na caĩro ocõo bairo na caĩñupʉ Jesu fariseo majare: —Camaja, “Cañuurã ãma,” jãre na ĩ tʉjʉato ĩrã cátito pairã mʉja ã. Dio maca caroorije mʉja cátiere mʉja yeripʉre caroaro tʉjʉ majimi. Camaja, “Caroarã majuu ãma,” mʉja na caĩ tʉjʉrije to nibao joroquena mʉja tʉjooqueti majuucõami Dio, mʉja yeripʉre caroaro catʉjʉ majii aniri. ");
INSERT INTO tav_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Nemoopʉre Dio yere Moisé cʉ carotiriquere, aperã Dio ye quetire buiori maja na cabuiorijere camaja na cáti nʉcʉbʉgorije cãñupa. Tie jetore na cáti nʉcʉbʉgobataje Juan bautisari majocʉ cʉ cabuiari paʉna cãni ejooyupa yua. Ti paʉna cawama queti maca cãni jʉgoyupa. Tie queti jetore api nʉcʉbʉgori Ʉpaʉ Dio cʉ cãnopʉ eja majima camaja. To bairi tie quetire yʉ cabuioro camaja seeto apigama. ");
INSERT INTO tav_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ati ʉmʉrecoo, ati yepa yoaro anigaro. To bairona Dio cʉ carotirique maca jĩca wame uno petiquetigaro, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Jĩcaʉ cʉ nʉmore rocari, apeo macare nʉmocʉcʉ rooro ácʉ áami. Apei quena apei cʉ carocaricore cʉ canʉmo cʉpata rooro ácʉ áami cʉ quena. ");
INSERT INTO tav_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ocõo bairo na caĩ buioyupʉ Jesu moquena: —Cãñupʉ jĩcaʉ caapeye unie paii. Caroa jutii cawapa pacarije jetore cajañanucuñupʉ. To cãnacã rʉmʉ pairo ʉgarique caroa jetore caʉga wariñuunucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cʉ ya wii jope tʉre jĩcaʉ cabopacaʉ yepapʉre cacuña cotenucuñupʉ, Lásaro cawamecʉcʉ. Rupaʉna cacamicʉcʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jope tʉacãpʉ cote cuñaʉ, caapeye unie paii cʉ caʉga rerijere seeto caʉgaganucuñupʉ. To bairo cʉ cabairo yaia cʉ camiire cʉ caweronucuñuparã. ");
INSERT INTO tav_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cabero cabai yajiyupʉ yua. Cʉ cabai yajiro bero cʉ yerire Dio tʉ macana jõ buipʉ Abraham ãnacʉ cʉ cãnopʉ cʉ cane aájuparã. Cabero caapeye unie paii quena cabai yajiyupʉ. Cʉ cabai yaji aáto bero camaja cʉ cayaa rocayuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","To bairi cabai yajiricarã ya paʉpʉ seeto capopiye tamʉoñupʉ cʉ maca. Popiye tamʉo, tʉjʉ mʉgobacʉ Abrahãre cʉ catʉjʉyupʉ jõpʉ cãcʉre. Lásaro quenare cʉ catʉjʉyupʉ Abraham mena cʉ cãno. ");
INSERT INTO tav_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na tʉjʉʉ ocõo bairo caĩ awajayupʉ: “Ñicʉ Abraham, yʉ bopaca tʉjʉya. Seeto popiye tamʉoʉ yʉ áticʉpʉ ati peropʉ. Lásarore yʉ tʉpʉ cʉ aá rotiya. Oco petoacã cʉ waa aparo yʉ caetipere.” ");
INSERT INTO tav_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","To bairo cʉ caĩro ocõo bairo cʉ caboca ĩ yʉyupʉ Abraham maca: “Tʉgooñaña mʉa. Mʉ cãna yepapʉre ãcʉ caroare mʉ cacʉgonucuwʉ wariñuurique mena. Lásaro maca topʉre ãcʉ seeto catamʉowĩ. Yucʉra caroa wariñuurique mena ãcʉ baimi. Mʉ maca popiye tamʉoʉ mʉ bai yua,” cʉ caĩñupʉ Abraham. ");
INSERT INTO tav_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“To bairo quenare pairi ope ã mari recomacapʉre. To bairi jã tʉpʉ cãna mʉ tʉpʉre aá majiquẽema. To bairona topʉ mʉ tʉpʉ cãna quena jã tʉpʉre eja atí majiquẽema,” cʉ caĩñupʉ Abraham. ");
INSERT INTO tav_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","To bairo cʉ caĩro: “Ñicʉ, yʉ bairã jĩca wamo cãnacãʉ cãma. Lásarore cʉ buio roti jooya yʉ pacʉ ya wiipʉ. Na quena yʉre bairona ati paʉ tamʉorica paʉpʉre ejarema,” cʉ caĩñupʉ caapeye unie paii cãnibatacʉ Abrahãre. ");
INSERT INTO tav_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","To bairo cʉ caĩro: “Moisé ãnacʉ cʉ caucariquere, Dio ye quetire cabuioricarã ãnana na caucarique quenare mere tiere cʉgoma. Mʉ yarã tiere na bue nʉcʉbʉgoato,” cʉ caĩ yʉyupʉ Abraham. ");
INSERT INTO tav_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","To bairo Abraham cʉ̃re cʉ caĩro: “Baiquẽe, ñicʉ Abraham. Jĩcaʉ cabai yajiricʉpʉ tunu catiri na cʉ cabuioro na catʉgooñarije wajoari caroorije na cátajere janaborãma,” cʉ caĩñupʉ tamʉorica paʉpʉ cãcʉ. ");
INSERT INTO tav_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","To bairo cʉ caĩro: “Moisé, aperã Dio ye quetire buiori maja ãnana na caucariquere caapipajeequẽna aniri to bairo na cabaiata quena apipajeequetiborãma. To bairona cabai yajiricʉ tunu catícõari na cʉ cabuioʉ eja aápata quenare apipajeequetiborãma,” cʉ caĩñupʉ Abraham, caĩ buioyupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ocõo bairo caĩñupʉ Jesu cʉ cabuerãre: —Camajare caroorijere cáti rotirã anigarãma. To bairi caroorijere aperãre cáti rotii ũcʉ pairo majuu popiye tamʉogʉmi, to bairo caroorijere cʉ cáti rotirije bui. ");
INSERT INTO tav_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","To bairi aperãre caroorije nare cʉ áti rotiqueticõato ĩrã ʉ̃ta capairica mena cʉ wamʉapʉre jia yo, capairi yapʉ cʉ̃re roca ñua rocacõaata ñuuboro. To bairo átatoi yʉre caapi nʉcʉbʉgorãre caroorijere na ĩ ocajãquetiboʉmi. ");
INSERT INTO tav_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Atiere caroaro tʉgooñaña. Mʉja yaʉ caroorije mʉjaare cʉ cápata, “Átiquẽja, caroorije ã tie,” cʉ ĩña. To bairo cʉ mʉja caĩro apiri caroorije mʉjaare cʉ cátiere cʉ cajʉtiritiata cʉ majiritioya. ");
INSERT INTO tav_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jĩca rʉmʉre siete cãnacã ni caroorijere mʉjaare cʉ cápata to cãnacã nina moquena jʉtiritirique mena, “Yʉ majiritioya,” mʉja cʉ caĩata cʉ majiritioya, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesu cʉ cabuerã ocõo bairo cʉ caĩñuparã: —Ʉpaʉ, Diore jã catʉgooña majicõa anipere jã joonemoña, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","To bairo cʉ na caĩro: —Jĩacãna Diore mʉja catʉgooña ocabʉtirije to nibao joroquena atiire sicómoro cawame cʉtiire mʉja cáaá rotiata, to majuuna wʉgue, jõ maca ria recomacapʉ tʉjʉnucuro aáboro. ");
INSERT INTO tav_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Paabojari majocʉ mʉja cacʉgoata cʉ mʉja carotirijere tʉgooñaña. Caotepa yepare mʉja yejeaboja, ovejare mʉja coteboja, cʉ paariquere peo, cʉ catunu ejaropʉ nemoona mʉja jʉgoye cʉ mʉja ʉga rotiquẽna. ");
INSERT INTO tav_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ocõo bairo maca cʉ mʉja rotirã: “Jã caʉgapere jã átibojaya. Jã caʉga yaparoro bero mʉ ʉgagʉ mʉa,” cʉ mʉja ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Cʉ mʉja carotirijere cʉ cáto tʉjʉʉ, “Caroa majuu mʉ ájupa,” cʉ mʉja ĩquẽna. “Cʉ ye riapena paʉ ácʉmi,” cʉ mʉja ĩ tʉgooñacõarã. ");
INSERT INTO tav_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mʉja quena, “Dio, ‘Caroaro yʉ mʉ átibojawʉ,’ yʉre cʉ ĩato,” ĩ tʉgooñaqueticõaña. Dio cʉ cáti rotirijere áti yaparorã ocõo bairo cʉ ĩña mʉjaa: “Mʉ paabojari maja jã ã, cawatoa cãna jã ã. Jã ye riapere, ‘Ocõo bairo cátipe ã,’ mʉ caĩ rotirique jetore jã ápʉ́. To bairi aperãre átinemorique me ãmʉ,” caĩpe ã, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cabero Jesu Jerusalẽpʉ aácʉ Galilea yepapʉ cãnacʉ, neto aácʉna, Samaria yepapʉ caejayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Topʉ aácʉ jĩca macapʉ caejayupʉ. Ti macapʉ cʉ caejaro pʉga wamo cãnacãʉ caajeri boarã cʉ cabocayuparã. Tie capenirije cãno maca cʉ tʉacãpʉ ejaquẽnana yoaropʉna cʉ caĩ piyuparã: ");
INSERT INTO tav_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—¡Jesu, camajare cabuei! ¡Jã bopaca tʉjʉya! cʉ caĩ piyuparã. ");
INSERT INTO tav_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu na tʉjʉʉ ocõo bairo na caĩñupʉ: —Aánaja sacerdote maja tʉpʉ. Na iñoorãja mʉja cabairijere, na caĩñupʉ. To bairo na cʉ caĩro apirã cáaájuparã. Ma na cáaátopʉna na caboabataje cayaticoajupe. ");
INSERT INTO tav_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jĩcaʉ na caboarije cayatiro tʉjʉʉ jĩcaʉna caamejorecõa tunu aájupʉ Jesu tʉpʉ. —¡Seeto ñuu majuucõa! Diore caĩ wariñuuñupʉ baujarije. ");
INSERT INTO tav_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesu tʉpʉ eja, rʉpopatuapʉ tuatu mubia cumuri cʉ caĩñupʉ Jesure: —Caroaro majuu yʉre mʉ átibojayupa. To bairo caĩi Samaria yepa macacʉ cãñupʉ cʉ̃a. ");
INSERT INTO tav_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu maca cʉ jetore cʉ tʉjʉri ocõo bairo caĩñupʉ: —Pʉga wamo cãnacãʉre na yʉ catiowʉ. ¿Aperã maca noo na aáti? ");
INSERT INTO tav_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ani jĩcaʉna judío majocʉ aniquetibaopʉcʉna Diore, “Ñuu majuucõa,” cʉ ĩi acʉ́ tunu ajupi, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","To bairo ĩi Samaria macacʉ caajeri boabatacʉre cʉ caĩñupʉ: —Wamʉnʉcaña. Mʉ ya paʉpʉ tunu aácʉja. Yʉ mʉ apipajee nʉcʉbʉgowʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo maja Jesure ocõo bairo cʉ caĩ jeniñañuparã: —¿Noo cõopʉ Dio ati yepapʉre camaja tʉpʉre cãni majuʉre cʉ joʉati Ʉpaʉre? To bairo cʉ na caĩro: —Baujarije tʉjʉriquena aniquetigaro. ");
INSERT INTO tav_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","To bairi ape wame caacʉori wamere tʉjʉrã, “Atopʉ roti jʉgoʉmi,” o “Jõpʉ maca roti jʉgoʉmi Ʉpaʉ Dio cʉ cajoʉ,” ĩ majiquetigarãma camaja. Ʉpaʉ Dio cʉ cajoʉ mʉja tʉpʉ anitʉgami, na caĩ buioyupʉ Jesu fariseo majare. Mere yʉna yʉ ã ĩi to bairo na caĩbajupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Cabero Jesu cʉ cabuerãre ocõo bairo na caĩñupʉ: —Cabero ape rʉmʉ cãno, “Cʉ catunu atípere jã boobapa,” yʉre mʉja ĩgarã. To bairo mʉja caĩrije to nibao joroquena yʉ bauquetigʉ. Yʉre mʉja tʉjʉquetigarã. ");
INSERT INTO tav_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aperã, “Mere ejatʉgami. Atopʉ ãmi,” mʉja ĩgarãma. Aperã, “Jõpʉ ãmi,” mʉja ĩgarãma. To bairo na caĩro na tʉjʉ ʉja aáqueticõaña. ");
INSERT INTO tav_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bʉpo cʉ cayaberije muipʉ cʉ cawamʉ ató maca yabe roca jooro muipʉ cʉ caroca jãari jopepʉ cayabe roca turore bairona yʉ catunu ató baugaro. ");
INSERT INTO tav_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","To bairo yʉ cabaiparo jʉgoye seeto yʉ popiye tamʉogʉ. Ati yʉtea macana, “Dio cʉ cajooricʉ me ãmi,” yʉ ĩbana yʉ popiye tamʉo joroque yʉre átigarãma. ");
INSERT INTO tav_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé cʉ cãna yʉteapʉre na cáti ãnatore bairona áticõa anigarãma yʉ catunu ejari paʉpʉ quenare. ");
INSERT INTO tav_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ocõo bairo cáticõañupa Noé cumua capairicapʉ cʉ cajãaparo jʉgoye, oco pairo caocaparo jʉgoye: Ti yʉtea macana ʉga, eti cumu, nʉmocʉti, cãromia manapʉacʉti, to bairona cáticõa aninucuñuparã na carua petiparo jʉgoye. Ti yʉtea macana na cátatore bairona camaja áticõa anigarãma, yʉ catunu ejari paʉpʉ quenare. ");
INSERT INTO tav_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","30","Lote cawamecʉcʉ ãnacʉ cʉ cãni yʉtea quenare Sodoma cawamecʉti maca cʉ caruti butiro bero nemoo pero caʉ̃rije oco caocarore bairo care peayupe ʉmʉrecoo macaje. To bairo baibato na cáti jĩa re peticõañupe Sodoma macanare. To bairije na to cáti jĩa reparo jʉgoye ocõo bairo cabai ãñuparã ti maca macana quena: Ʉga, eti cumu, apeyere wapaye cʉgo, nuni wapatanucu, ote, wiiriye, cáticõa aninucuñuparã. To bairona átigarãma camaja Lote cʉ cãni yʉtea macana na cátatore bairona, yʉ catunu ejari paʉpʉ quenare. To bairo na cáticõanona yʉ atígʉ. ");
INSERT INTO tav_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yʉ caejari paʉ cãnore jĩcaarã na ya wiiri tʉbʉja capaa ãna na ya wiiripʉre na tunu jãaqueticõato. Na yere na jeeyora aáqueticõato. Aperã quena wejeripʉ capaa ãna na ya wiiripʉre na tunu aáqueticõato. ");
INSERT INTO tav_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lote nʉmo co cabairiquere tʉgooñaña. Co ya maca, Sodoma caʉ̃ro co apeyere maibaco seeto catʉgooñarique paiyupo. To bairi Dio co carocayupʉ Lote nʉmore, apeye uniere seeto co catʉgooña mai pairije bui. To bairi cõre bairo baiqueticõaña. Apeye uniere tʉgooña mai tunuoqueticõaña. ");
INSERT INTO tav_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Noa na majuuna na caboorijere cáticõa ãna maca yajigarãma. Aperã maca na majuuna na caboorijere átiquẽnana Dio cʉ caboorije macare cána caroa na cãnicõa anipere bʉgagarãma, caĩ buioyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na caĩ buionemoñupʉ Jesu moquena: —Yʉ catunu atí paʉ ñami cãno caʉmʉa pʉgarã jĩca arʉarena canigarãma. To bairo na cabairi paʉna ejaʉ, jĩcaʉre cʉ yʉ ne aágʉ. Apei maca tuagʉmi, yʉre caapipajeequẽcʉ aniri. ");
INSERT INTO tav_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ʉmʉreco cãno yʉ caejaata cãromia pʉgarã ʉgarique cawãia tʉjʉnucurã anigarãma. Jĩcaore co yʉ ne aágʉ. Apeo tuagomo, yʉre caapipajeequẽco aniri. ");
INSERT INTO tav_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Caʉmʉa pʉgarã wejepʉ paa anigarãma. Jĩcaʉre cʉ yʉ ne aágʉ. Apei tuagʉmi, yʉre caapipajeequẽcʉ aniri. ");
INSERT INTO tav_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","To bairo cʉ caĩro: —¿Atie noopʉ to bairije to bairoati? cʉ caĩ jeniñañuparã cʉ cabuerã. To bairo cʉ na caĩ jeniñaro: —Yucaa na cawʉ amejorero tʉjʉrã, “Caboaʉ ãcʉmi,” mʉja ĩ maji. To bairona yʉ catunu atópʉ caroaro mʉja majigarã. “Mere caroorã, Jesure caapipajeequẽnare na cʉ capopiyeyeri paʉ ejatʉga,” mʉja ĩ majigarã, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ocõo bairo caĩñupʉ Jesu cʉ cabuerãre: —Diore cʉ jeninucuña, “Apiquẽcʉmi,” ĩ tʉgooñaquẽnana. To bairo na ĩ, ocõo bairo queti buio majiorica wame na caĩ buioyupʉ: ");
INSERT INTO tav_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Jĩca macare ʉpaʉ jues cãñupʉ, caroorije cánare capopiyeye rotii. Diore canʉcʉbʉgoquẽcʉ cãñupʉ. Camaja dope bairo na caboori wamere nare cátinemogaquẽcʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cʉ ya macapʉre jĩcao cawapearico nairoacã ocõo bairo cʉ caĩ jenio ejanucuñupo: “Yʉ átinemoña. Yʉre catʉjʉ tutii ñuuquẽto yʉre átinucumi,” cʉ caĩnucubajupo. ");
INSERT INTO tav_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nemoona co cátinemogaquẽjupʉ. Nairoacã to cãnacã nina cʉ̃re co caĩ jeniroi ocõo bairo caĩ tʉgooñañupʉ: “Diore cáti nʉcʉbʉgoquẽcʉ yʉ ã yʉa. Camaja quenare na caboori wamere yʉ tʉgooñaquẽe. ");
INSERT INTO tav_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","To bairo canʉcʉbʉgoquẽcʉ yʉ anibao joroquena atio cawapearico nairoacã yʉ jeni patawãcoomo. To bairi co yʉ átinemogʉ. Cõre yʉ cátinemoquẽpata yʉ quepeboʉ nairoacã co cajenio ejanucuro,” caĩ tʉgooñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti wamere na ĩ buio yaparo ocõo bairo na caĩ buioyupʉ Jesu cʉ cabuerãre: —To bairona cájupʉ jues cañuuquẽcʉ. Co caapiquẽjupʉ nairoacã co cajenirije to nibao joroquena. ");
INSERT INTO tav_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dio maca cʉ yarã cʉ cabejerã nairoacã cʉ na cajeniro na átibojagʉmi. Yoaro mee na átibojagʉmi Dio maca. ");
INSERT INTO tav_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cʉ na cajeniro nemoo na átibojagʉmi. To bairi yʉa ati yepapʉ tunu acʉ́pʉ ¿caroaro yʉre caapipajee nʉcʉbʉgo jenirãre na yʉ bʉgaʉati? na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jĩcaarã to macana ocõo bairo caĩ tʉgooñañuparã: “Cañuurã majuu jã ã. Aperã maca caroorã ãma.” To bairo caĩ tʉgooñarãre atiere queti buio majiorica wamere na caĩ buioyupʉ Jesu: ");
INSERT INTO tav_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Caʉmʉa pʉgarã Dio wiipʉ jenira aána cáaájuparã. Jĩcaʉ fariseo majocʉ cãñupʉ. Apei gobiernore camaja yere niyeru jeebojari majocʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo majocʉ maca Dio wiipʉre jãa, ejanʉca, ocõo bairo caĩñupʉ, Diore jenigabacʉ: “Dio, aperãre bairo yʉ aniquẽe. Cajee ruti pairã, cátito pairã, cáti epericarã cʉnare bairo yʉ aniquẽe. Jĩ gobiernore camaja yere niyeru jeebojari majocʉ, cʉ̃re bairo yʉ aniquẽe. To bairi mʉre yʉ ĩ wariñuu. ");
INSERT INTO tav_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","To cãnacã semana pʉgani ʉgaquẽcʉna mʉre yʉ jeni nʉcʉbʉgonucu. Yʉ capaarije wapa pʉga wamo cõo cãnacã tiiri niyeru tiirire wapataʉ, jĩca tiire mʉ yʉ joonucu,” Diore caĩbajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Apei gobiernore camaja yere niyeru jeebojari majocʉ maca jõpʉna macapʉ tuacõari catʉjʉ mʉgogaquẽjupʉ, caroorije cʉ cátajere bobobacʉ. “Seeto caroorije paii yʉ ã,” ĩ jʉtiriti netocõari ocõo bairo Diore cʉ caĩ jeniñupʉ: “Dio, carooʉ majuu yʉ ã. Yʉre bopaca tʉjʉya,” caĩ jeniñupʉ Diore, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—Cariape mʉñʉja ĩ buio: Cʉ̃ cañuuquetacʉ maca mere caroorije cʉ cátajere majiritioricʉpʉ cʉ ya wiipʉ catunucoajupʉ. Apei fariseo majocʉ maca caroorije cʉ cátajere camajiritioya mácʉna catunucoajupʉ. To bairi jĩcaʉ, “Aperã netoro cañuʉ yʉ ã,” caĩ tʉgooñaʉ ũcʉ cawatoa cãcʉ cʉ anio joroque cʉ cũgʉmi Dio. Apei maca, “Cawatoa cãcʉ yʉ ã,” caĩi ũcʉ macare aperã netoro cãcʉre cʉ cũgʉmi Dio, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aperã na punaare cajee ajuparã Jesu tʉpʉ, Jesu nare cʉ ñiga peoato jã punaare ĩrã. To bairo nare na cáto tʉjʉrã Jesu cʉ cabuerã maca nare matagabana: —Cawimarãre na jee atíqueticõaña, Jesure cʉ patawãcoorema, na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","To bairo na caĩ matarijere apii Jesu maca cawimarãre na pijori ocõo bairo na caĩñupʉ cʉ cabuerãre: —Cawimarã yʉ tʉpʉ na aparo. Na mataqueticõaña. Ʉpaʉ Dio cʉ cãnopʉ cáaáparã ãma ati maja cawimarãre bairona caroaro yʉre catʉgooñarã. ");
INSERT INTO tav_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cariape mʉñʉja ĩ. Ati maja cawimarã yʉre na caboorore bairo cabaiquẽna maca Ʉpaʉ Dio cʉ cãnopʉ aáquetigarãma, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jĩcaʉ judío majare carotii Jesure cʉ cajeniñañupʉ: —Jesu, caroaro camajare cabuei mʉ ã. Cañuʉ mʉ ã. To bairi yʉre buioya. ¿Ñee uniere yʉ ácʉati cacaticõa anipere bʉgagʉ? ");
INSERT INTO tav_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","To bairo cʉ caĩro: —¿Nope ĩi cañuʉ yʉ mʉ ĩti? Dio jĩcaʉna cañuʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dio cʉ caroti cũriquere mʉ majii: “Áti eperico cʉtiqueticõaña. Camajare jĩaquẽja. Aperã na yere emaqueticõaña. Ĩtoqueticõaña. Mʉ pacʉ, mʉ pacore na nʉcʉbʉgoya,” cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","To bairo cʉ caĩro: —Tie Dio cʉ carotiriquere mere cawimaʉacã ãcʉpʉ tie nipetiro yʉ cáti bʉtiwʉ, Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","To bairo cʉ caĩro: —Jĩca wame mʉ rʉja. Mʉ cacʉgorijere nuni wapa jee peticõaña. Tie mʉ cawapa jeerijere cabopacarãre na ricawo nuni peocõaña. To bairo ácʉ ʉmʉrecoopʉre pairo cañuu netorijere mʉ cʉgogʉ. To bairo áti yaparo to cõona yʉ mena ajá, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","To bairo Jesu cʉ caĩrijere apii seeto catʉgooñarique paiyupʉ, caapeye unie paii aniri. ");
INSERT INTO tav_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","To bairo cʉ cabairo tʉjʉʉ ocõo bairo caĩñupʉ Jesu: —Caapeye unie pairãre majiriobʉja Dio tʉpʉ eja aágabapata. ");
INSERT INTO tav_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cameyo na caĩi waibʉcʉ capaii apopota yita wẽ pĩorica opeacãre cʉ caame butigaata majiriobʉja. To bairona majiriobʉja, caapeye unie pairã Dio tʉpʉ na cáaágabatie. ");
INSERT INTO tav_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","To bairo cʉ caĩro: —Baiyupa to bairo cariape mʉ caĩata noa majuu Dio tʉpʉ eja majiquẽnama, cʉ caĩñuparã cʉ̃re caapirã maca. ");
INSERT INTO tav_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","To bairo na caĩro: —Camaja na cáti majiquẽtiere cáti majii ãmi Dio. Cʉ jeto na netoo majimi. ");
INSERT INTO tav_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ocõo bairo cʉ caĩñupʉ Pedro: —Ʉpaʉ, jã cacʉgorijere jã wiirire nipetiro jã cáaáweocõawʉ, mʉ mena macana anigarã. ");
INSERT INTO tav_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","To bairo cʉ caĩro: —Cariape mʉjaare yʉ ĩ. Jĩcaʉ ũcʉ cʉ ya wii, cʉ pacʉa, cʉ bairã, cʉ nʉmo, cʉ punaa nare cʉ cáaáweocoapata Dio cʉ caboorije macare átigʉ, capee caroa cʉ cacʉgo jʉgorique netoro bʉganemogʉmi ati yepapʉre. Bai yajiri bero cʉ cacaticõa anipe quenare bʉgagʉmi, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu cʉ cabuerã mena jeto doce cãnacãʉre aperobʉjaacã na pi aá, ocõo bairo na caĩ buioyupʉ: —Caroaro apiya. Yucʉacã Jerusalẽpʉ mari aágarã. Topʉ yʉ caejaro rooro yʉre átigarãma. Tirʉmʉpʉ macana Dio ye quetire buiori maja nipetiro yʉre na caĩ ucariquere bairona yʉre baigaro. ");
INSERT INTO tav_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Topʉ yʉ caejaro apero macana mena yʉre ĩ epe, yʉ roo epe, yʉre ʉcoo eo re tuti, yʉre átigarãma. To bairo áticõari judío maja cãniquẽnare yʉ joogarãma, cʉ bapeya, cʉ jĩaña na ĩrã. Yʉ na cajĩaro bero itia rʉmʉ bero yʉ tunu catícõagʉ, na caĩñupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cʉ cabuerã to bairo cʉ caĩrijere caapi majiquẽjuparã. “To bairo ĩi ĩmi,” caĩ majiquẽjuparã. Jesu to bairo cʉ caĩ buiorije caapi majiña manie cãñupa. ");
INSERT INTO tav_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesu Jericó na caĩri macapʉ cʉ cáaáto ma tʉre caruiyupʉ catʉjʉquẽcʉ. Caniyeru jeni ruinucuñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Camaja capãarã na canetorijere apii: —¿Dope bairo to baiti? caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","To bairo cʉ caĩ jeniñaro: —Jesu Nasaré macacʉ neto aácʉ áami, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","To bairo na caĩro apii caawajajoyupʉ: —¡Jesu! ¡Ʉpaʉ ãnacʉ David pãrami, Dio cʉ cajooricʉ mʉ ã. To bairi yʉre bopaca tʉjʉya! caĩ pi awajayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","To bairo cʉ caĩ awajarijere apirã: —¡Awajaqueticõaña! ¡Janaacʉja! cʉ caĩ tutiyuparã Jesu jʉgoye cáaána maca. To bairo na caĩ tutirije to nibao joroquena seeto caĩ awajanemoñupʉ moquena: —¡Ʉpaʉ David ãnacʉ pãrami, yʉre bopaca tʉjʉya! ");
INSERT INTO tav_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","To bairo cʉ caĩ awajarijere apii Jesu catua nʉcañupʉ. Tuanʉca átiri cʉ̃re capi awajaʉre aperãre cʉ tʉpʉ na catʉ̃ga atí rotiyupʉ Jesu. Cʉ tʉpʉ cʉ na cane ejaro: ");
INSERT INTO tav_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ñe uniere mʉ yʉ cátibojapere mʉ booti? cʉ caĩ jeniñañupʉ Jesu. To bairo cʉ caĩ jeniñaro: —Ʉpaʉ, yʉ cape catʉjʉ bʉga majipere yʉ boo, Jesure cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","To bairo cʉ caĩro: —“Yʉre tʉjʉ majio joroque áti majiimi,” yʉre mʉ ĩ tʉgooña nʉcʉbʉgoyupa. To bairi catʉjʉ bʉgaʉ mʉ anicõagʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","To bairo Jesu cʉ caĩri paʉna catʉjʉ bʉga majicõañupʉ yua. To cõona Diore, “Ñuu majuucõa,” ĩri, Jesure cʉ caʉjacoajupʉ catʉjʉquetibatacʉ. To bairo cʉ cáto catʉjʉrã maca nipetiro seeto: —Caroaro majuu áami Dio, cʉ caĩ wariñuu nʉcʉbʉgoyuparã Diore yua. ");
INSERT INTO tav_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu Jericó na caĩri macapʉ eja, neto aácʉ cájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ti macapʉre cãñupʉ Saqueo cawamecʉcʉ. Cʉ̃a gobiernore camaja yere niyeru jeebojari maja ʉpaʉ cãñupʉ. To bairi caapeye unie paii cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesu cʉ cáatíere apii seeto cʉ catʉjʉgabajupʉ. Camaja capãarã na cãni mataro dope bairo cʉ cáti tʉjʉ majiquẽjupʉ, ʉmʉaquetibacʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","To bairi Jesu cʉ caneto aápa wãpʉ cʉ jʉgoye atʉ aá, yucʉpʉ cawamʉ pea aájupʉ, Jesure cʉ tʉjʉgʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Topʉ cʉ capejaro caejayupʉ Jesu cʉ capejari paʉ ẽoro majuu. Eja, Saqueore cʉ catʉjʉ mʉgoñupʉ. Cʉ tʉjʉ mʉgo: —Saqueo, uwaro rui ajá. Yucʉ mʉ ya wiipʉ yʉ anigʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","To bairo cʉ caĩro apii Saqueo uwaro wariñuurique mena Jesure cʉ cabocaʉ rui ajupʉ. Rui atí, Saqueo cʉ ya wiipʉ cʉ cajʉgo aájupʉ Jesure. ");
INSERT INTO tav_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","To bairi Saqueo tʉpʉ Jesu cʉ cáaáto tʉjʉri ocõo bairo caame ĩñuparã camaja aperã: —¿Nope ĩi caroorije cáti paii tʉpʉre cʉ anigati? cʉ caĩ wada paiyuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saqueo maca wamʉnʉcari ocõo bairo mari Ʉpaʉ Jesure cʉ caĩñupʉ: —Ʉpaʉ, yʉ cacʉgorije apeye uniere cabopacarãre na yʉ ricawo nunigʉ carecomacai. Aperã yere na ĩtori yʉ majuuna yʉ cajeewʉ. To bairi ĩtori na yʉ caemaricaro netobʉjaro na yʉ tunuogʉ. Jĩca tii niyeru tiire na ĩtori yʉ caemaricaro bero to cãmata bapari cãnacã tii maca na yʉ tunuogʉ, Jesure cʉ caĩñupʉ Saqueo. ");
INSERT INTO tav_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","To bairo cʉ caĩro: —Yucʉ ati wii macanare mʉjaare netoo catiomi Dio caroorije mʉja cátibatajere. Mʉ quena Abraham pãramerã mena macacʉna mʉ ã. ");
INSERT INTO tav_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","To bairi cayajiricarãre bairo cãna Diore catʉgooñaquẽnare na macaʉ acʉ́ yʉ cáapʉ́ ati yepapʉre. Na maca bʉga, na yʉ netoo catiogʉ, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","“Camajare na netoo catioʉ acʉ́ yʉ cáapʉ́,” Saqueore Jesu cʉ caĩrijere caapiyuparã to macana. To bairo na caapiro buio majiorica wame mena na caĩ buionemoñupʉ Jesu. Jerusalén tʉacãna ãcʉ to bairo na caĩñupʉ. Na maca, “Nemoo ati yepare carotii jãagʉmi Jesu,” caĩ tʉgooñabajuparã. ");
INSERT INTO tav_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","To bairi ati wame na caĩ buio majioñupʉ Jesu: —Jĩcaʉ apeyere carotii aperopʉ cáaájupʉ, ʉpaʉ ãnajere yʉre na jõoato ĩi. “Cabero na caʉpaʉ jõocõaricʉpʉ yʉ tunu atígʉ,” caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cʉ cáaáparo jʉgoye cʉ paabojari majare pʉga wamo cõo cãnacãʉre na capiyupʉ. Na piri, to cãnacãʉpʉrena niyeru tiiri pairo cawapacʉtiere jĩca tiiri jeto na cajooyupʉ. Na joo, ocõo bairo na caĩñupʉ: “Yʉ camano atie niyeru wajoa wapayeya, pairo niyeru to bʉato ĩrã,” na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cʉ ya maca macana majuu maca caʉpaʉ cʉ cãnipere cabooquẽjuparã. To bairi cʉ cáaáto bero aperãre ocõo bairo na caĩ jooyuparã: “Cʉ̃re jã ʉpaʉ cʉ cãnipere jã booquẽe.” ");
INSERT INTO tav_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","To bairo cʉ na caĩ joorije to nibao joroquena cʉ maca na caʉpaʉ jõocõaricʉpʉ catunu ejayupʉ cʉ ya macapʉre. Tunu eja, cʉ yarã cʉ caniyeru jooricarãre na capijoyupʉ, niyeru mʉñʉja cajoorique mena ¿noo cõo mʉja cawapata bʉori? na ĩ majigʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Caeja jʉgoʉ ocõo bairo cʉ caĩñupʉ: “Ʉpaʉ, yʉ mʉ cajoepa tii mena yʉ wapatanemowʉ pʉga wamo cõo cãnacã tiirire,” cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","To bairo cʉ caĩro: “Caroaro mʉ ájupa. Caroaro paa cotebojari majocʉ mʉ ãñupa. Õcoacã mʉ yʉ cajoorique menana caroaro mʉ ájupa. To bairi pʉga wamo cõo cãnacã macarire yʉre carotibojapaʉre mʉ yʉ jõogʉ,” cʉ caĩñupʉ cʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Cʉ bero apei caejayupʉ moquena. “Yʉ ʉpaʉ, yʉ mʉ cajoepa tii mena jĩca wamo cõo cãnacã tiirire yʉ wapatanemowʉ,” cʉ caĩñupʉ cʉ ʉpaʉre. ");
INSERT INTO tav_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","To bairo cʉ caĩro: “Jĩca wamo cõo cãnacã macarire yʉre carotibojapaʉre mʉ yʉ jõogʉ mʉre,” cʉ caĩñupʉ cʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","’Cʉ bero apei caejayupʉ moquena. Eja, cʉ ʉpaʉre ocõo bairo jocʉna cʉ caĩñupʉ: “Ʉpaʉ, tutuaro carotii mʉ ã. Aperã na capaa wapatarijere cajei mʉ ã. To bairi, ‘Yʉ capaa wapatarije to nibao joroquena yʉ wapa jooquetiboʉmi,’ yʉ caĩ tʉgooña uwiwʉ. To bairo mʉ cátinucurijere tʉgooñari mʉ niyeru tiire jutiiro ajero mena umari caroaro mʉ yʉ caquenoo cũ cotebojawʉ. Ʉ̃jʉ, mʉ niyeru tiire neña,” cʉ ʉpaʉre cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","To bairo cʉ caĩrijere apii cʉ ʉpaʉ ocõo bairo cʉ caĩñupʉ: “Yʉ mʉ caĩrije jʉgori rooro mʉ cátajere yʉ majitʉga. Mʉ ñuuquẽjupa mʉa. To bairi mʉ yʉ popiyeyegʉ. Jocʉna, ‘Aperã yere na cawapatarijere cajei ãmi yʉ ʉpaʉ,’ yʉ mʉ ĩ. ‘Yʉ cawapatabao joroquena yʉ wapa jooquetiboʉmi,’ mʉ ĩ tʉgooñabacʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","To bairi yʉ niyeru tiire niyeru cũrica wiipʉ to macanare na mʉ caquenoo cũ rotipe anibajupa, to ani bʉnemoato ĩi. To bairi topʉ mʉ cacũata cabero tunu ejaʉ pairo cãniere cabʉnemorique menare niyeru tiire yʉ neboricʉ,” cʉ caĩñupʉ cʉ ʉpaʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","To bairo cʉ ĩ, topʉ catʉjʉnucurãre ocõo bairo na caĩñupʉ: “Anire cʉ yʉ cajoobata tiire cʉ emaña. Cʉ emari, pʉga wamo cõo cãnacã tiiri cawapatanemoricʉ macare cʉ jooya,” na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","’To bairo na cʉ caĩro: “Ʉpaʉ, mere pairo pʉga wamo cõo cãnacã tii cʉgomi,” cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","To bairo cʉ na caĩro: “Cariape mʉñʉja ĩ. Noa maca na cacʉgorije mena caroaro cánare netobʉjaro na yʉ joonemogʉ. Aperã maca na cacʉgorije mena caroaro cátiquẽna aniri na cacʉgobatiere cáti renucurã maca cʉgoquetigarãma. To bairi ani cʉ cacʉgorijeacã quenare cʉ emari cʉ jooya pairo cawapataricʉ macare. ");
INSERT INTO tav_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","To bairi ati maja yʉre catʉjʉ teericarã ʉpaʉ yʉ cajãaro cabooquetanare na jee ajá. Na jee atíri na jĩacõaña yʉ catʉjʉrona,” na caĩñupʉ caʉpaʉ, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","To bairi atie queti buio majiorica wame ĩ buio yaparo Jesu cáaácoajupʉ, Jerusalẽpʉ aácʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aá, pʉga macari Betfagé, Betania cawamecʉti macariacã tʉpʉ caejayupʉ. Ti macariacã Olivo ʉ̃taʉ na caĩricʉ pʉtore cãñupe. Topʉ ejaʉ cʉ cabuerã pʉgarãre ocõo bairo na caĩ jooyupʉ: ");
INSERT INTO tav_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Aánaja jĩ macapʉ. Ti macapʉ ejarã cʉ mʉja bʉgagarã burro cawamaʉ, na cajia nʉcoricʉ, na capejañaquẽcʉre. Cʉ tʉjʉ bʉga, cʉ popiori, yʉ tʉpʉ cʉ̃re mʉja neapá. ");
INSERT INTO tav_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aperã, “¿Nope ĩrã cʉ mʉja popioti?” mʉja na caĩata, “Jã Ʉpaʉ cʉ boomi,” na ĩña, na caĩ jooyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","To bairi cʉ cabuerã pʉgarã ti macapʉre cáaájuparã. Ti macapʉre eja, burrore cabʉga ejayuparã Jesu na cʉ caĩ jooricarore bairona. ");
INSERT INTO tav_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cʉ bʉga eja, cʉ capopioyuparã. Cʉ na capopioro tʉjʉrã cʉ ʉparã na caĩñuparã: —¿Nope ĩrã cʉ mʉja popioti mʉjaa? ");
INSERT INTO tav_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","To bairo na na caĩro: —Jã Ʉpaʉ cʉ boomi, na caĩñuparã Jesu cʉ cabuerã maca. ");
INSERT INTO tav_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Cʉ cane aájuparã Jesu tʉpʉ yua. Cʉ ne eja, na jutii cabui macajere cʉ bui peo átiri Jesure cʉ capeja rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","To bairi Jesu burro bui cʉ capeja aápa wãre na ye jutii cabui macaje mena cʉ cacũ jʉgoye cʉjuparã, seeto cʉ wariñuurã. ");
INSERT INTO tav_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivo cawamecʉtii ʉ̃taʉ tʉ cʉ catʉja ro aáti paʉna capãarã cʉ̃re caʉjarã cʉ nʉcʉbʉgorã wariñuurique mena caĩ awajayuparã. Nipetiro Jesu cʉ cáti iñooriquere na catʉjʉrique tʉgooñari Diore caĩ wariñuu awajayuparã. ");
INSERT INTO tav_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ocõo bairo caĩ awaja wariñuuñuparã: —¡Caroaro to baiato mari Ʉpaʉre, Dio cʉ cajooricʉre! ¡Wariñuurique to ani neto majuucõato ʉmʉrecoopʉre! ¡Camaja nipetiro Diore na nʉcʉbʉgoato! caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na caawajarijere apirã jĩcaarã fariseo maja topʉ cãna ocõo bairo Jesure cʉ caĩñuparã: —Camajioʉ, mʉre caʉjarãre, “Ĩ awajaqueticõaña,” na ĩña. ");
INSERT INTO tav_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","To bairo na caĩro: —Ati maja na cajanaata atie ʉ̃taa rupaarena yʉre to caawaja wariñuupere rotiboʉmi Dio, na caĩñupʉ Jesu fariseo majare. ");
INSERT INTO tav_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","To bairi Jesu Jerusalén maca tʉ tʉja acʉ́ tʉjʉjori, ti macare caoti tʉjʉyupʉ. Ti macare oti tʉjʉ, ocõo bairo caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Yucʉna Jerusalén macana caroa ani wariñuuriquere nare Dio cʉ cajoogarije na camajiata ñuuboricaro. Na majuuna apipajeequẽjupa. To bairi ani wariñuu majiqueti majuucõagarãma naa. ");
INSERT INTO tav_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","To bairi ñuuquẽtie tamʉorique na anigaro. Nare catʉjʉ tutirã na ejagarãma. Na eja átiri na jotoo amejoregarãma, na quẽgarã. ");
INSERT INTO tav_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na jotoo amejore, na caruti butibopere mata, caroaro na jĩa baurio peo recõagarãma ati maca macanare. Dio cʉ cajooricʉ na tʉpʉ yʉ cãno na cabooquẽtie wapa to bairona na baigaro tie, ati majare Jerusalén macanare, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","To bairo ĩ yaparo ti macapʉ ejaʉ Dio wiipʉ cajãajupʉ Jesu. Jãa, camaja topʉ caame wapaye ãnare na catʉjʉyupʉ. Nare to bairo na cáti aniere booquẽcʉ na cabuuyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na buʉ ocõo bairo na caĩñupʉ: —Dio Wadarique ocõo bairo ĩ: “Ati wii yʉ ya wii Diore jeni nʉcʉbʉgorica wii jeto ã.” Mʉja maca to bairo ána cajee ruti pairã ya paʉre bairona to anio joroque mʉja áa, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ti paʉ Jerusalén ãcʉpʉ to cãnacã rʉmʉ Dio wiipʉ Dio ye quetire cabuionucuñupʉ Jesu. To bairo cʉ cabuiorijere apirã sacerdote maja ʉparã, judío majare cabuerã, aperã camajare cajʉgo ãna maca cʉ carocagabajuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Camaja maca caroaro cʉ cabuiorijere caapiganucuñuparã. To bairi dope bairo cʉ cáti majiquẽjuparã, camaja mani punijiniborãma ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jĩca rʉmʉ Jesu Dio wiipʉre camajare na buioʉ camajare cʉ canetoo catiorije quetire na cabuio ãñupʉ. To bairo cʉ cabuio ani paʉna cʉ tʉpʉ caejayuparã sacerdote maja ʉparã, judío majare cabuerã, aperã cabʉcʉrã camajare cajʉgo ána. Cʉ tʉpʉ ejari, ocõo bairo cʉ caĩ jeniñañuparã: ");
INSERT INTO tav_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—¿Ñamʉ atie mʉ cátiere, camajare mʉ cabuiorije mʉre cʉ rotiti? ");
INSERT INTO tav_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","To bairo cʉ na caĩro: —Yʉ quena mʉñʉja jeniñapa. ");
INSERT INTO tav_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ñamʉ Juãre cʉ cʉ cabautisa rotiyupari? ¿Diona cʉ carotiyupari? O ¿camaja maca cʉ na carotiyupari que? ¿Ñamʉ maca cʉ ãti cʉ carotiricʉ? na caĩ jeniñañupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","To bairo na cʉ caĩ jeniñaro na majuu ocõo bairo caame ĩ wadapeniñuparã: —¿Dope bairo cʉ mari ĩcʉti? “Diona cʉ rotiricʉmi,” cʉ mari caĩata, “¿Nope ĩrã Dio cʉ carotiricʉ cʉ nibao joroquena Juãre mʉja caapipajee nʉcʉbʉgoqueti?” mari ĩboʉmi Jesu. ");
INSERT INTO tav_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Dio ye quetire cabuioʉ cãmi Juan,” caĩrã ãma camaja. To bairo na caĩirena jocarãna, “Camajana cʉ rotiricarãma Juãre,” cʉ mari caĩata quena camaja maca marire re jĩaborãma ʉ̃ta rupaa mena, marire punijinirã. ");
INSERT INTO tav_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","To bairo ame ĩ wadapeni, ocõo bairo Jesure cʉ caboca ĩ yʉyuparã: —Õoba. Ñamʉ cʉ rotiricʉmi jã ĩ majiquẽe, Jesure cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","To bairo Jesure na caĩro: —Baiyupa yʉ quena, “Atiere cʉ̃ cʉ carotiroi yʉ áa,” mʉñʉja ĩ buioquẽe, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cabero atie queti buio majiorica wame camajare na caĩ buioyupʉ Jesu: —Cãñupʉ ʉje miji wẽri wejere caotericʉ. Ti wejere ote yaparoʉ ti wejere cacoteparãre na cacũñupʉ, aperopʉ aáteñaʉ aágʉ. Na cũʉ ocõo bairo na caĩ cũñupʉ: “Yʉ ʉje wejere yʉ cotebojaya. Yʉre mʉja cacotebojaro mʉñʉja ricawogʉ carecomaca caricare.” To bairo na ĩ yaparo aperopʉ cáaáteñaʉ aácoajupʉ yoaro. ");
INSERT INTO tav_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cabero ʉje caricacʉti yʉtea caejaro apei cʉ paabojari majocʉre cʉ cajooyupʉ ʉje wejere cʉ cacote rotiricarã tʉpʉ. “Yʉ yere na ricawo joato,” cʉ caĩñupʉ. To bairo cʉ caĩi cáaácoajupʉ cʉ ʉpaʉ ya wejepʉ. Topʉ cʉ caejaro ti wejere cacoterã maca seeto cʉ caboca quẽcõañuparã, ʉjere cʉ joogaquẽna. ");
INSERT INTO tav_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","To bairo cʉ na cátoi cʉ ʉpaʉ maca apeire cʉ cáaá rotiyupʉ moquena. Cʉ quenare to bairona cʉ quẽ, rooro cʉ caboca áti acʉo tunuocoa jooyuparã, cʉ quenare cʉ joogaquẽna. ");
INSERT INTO tav_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","To bairo cʉ na cáto apeire cʉ cáaá rotiyupʉ moquena. Cʉ quenare to bairona rooro cʉ quẽ camiye, cʉ caboca áti acʉo tunuocoa jooyuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’To bairo jeto na na cáto tʉjʉʉ ʉje miji wẽri weje ʉpaʉ ocõo bairo caĩ tʉgooñañupʉ: “¿Dope bairo yʉ ácʉati? Baiyupa yʉ macʉre yʉ camaiire cʉ yʉ aá rotigʉ. Yʉ macʉre cʉ tʉjʉrã cʉ tʉjʉ nʉcʉbʉgogarãma,” caĩ tʉgooñañupʉ. To bairo ĩ tʉgooñari cʉ macʉre cʉ cáaá rotiyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","To bairi ti wejere cacoterã maca cʉ macʉ cʉ cajooricʉre cʉ tʉjʉrã ocõo bairo caame ĩñuparã: “Ani ati weje ʉpaʉ macʉ ãmi. Cʉ pacʉ cʉ cabai yajiro bero atie wejere cacʉgo wajoapaʉ ãmi. To bairi cʉ mari jĩa rocacõato. To bairo ána ti wejere mari majuuna mari cʉgogarã.” ");
INSERT INTO tav_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","To bairo ame ĩ, cʉ̃re ñe aáti, ti weje tʉjaropʉ cʉ cajĩa rocacõañuparã, na caĩ buioyupʉ Jesu. —To bairi cʉ ya wejere cʉ cacote rotiricarã cʉ macʉrena na cajĩa rocacõaro tʉjʉʉ, ¿Dope bairo na átacʉmi mʉja ĩ tʉgooñati? ");
INSERT INTO tav_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","To bairi cʉ majuuna atí, na cajĩa re peocõañupʉ ti wejere cʉ cacote rotibatanare. To bairo na áti re peocõa, cabero aperã macare na cajooyupʉ. To bairo na cʉ caĩro apirã: —Weje ʉpaʉ na cʉ cátatore bairo requetiboʉmi Dio, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","To bairo na caĩro Jesu na tʉjʉ, ocõo bairo na caĩñupʉ moquena: —¿Dope bairo ĩgaro ĩ, mʉja ĩ tʉgooñati Dio Wadarique ocõo bairo caĩri wamere? Ʉ̃ta wiire wegarã jĩca ʉ̃taare cabeje rocacõañuparã, tia ʉ̃ta ñuuquẽe ĩrã. Tia na carocabatacarena cane cũñuparã aperã maca, atia cañuu majuucõarica ã ĩrã. To bairi tiarena wii pucua cãniparore cawe peo jʉgoyuparã, tia mena mari cacõoñaata cariape eja majigaro ĩrã. To bairona ĩ ucarique ã. ");
INSERT INTO tav_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","To bairi camaja nipetiro tiapʉre capʉga ta re cumurã na õwa pecoanucugarãma. Tia maca na buipʉre to caroca peaata caroaro na roca aboo recõagaro, caĩñupʉ Jesu. To bairona baigarãma yʉre caapipajeequẽna ĩi, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ti wame queti buio majiorica wamere Jesu na cʉ cabuioro apirã judío majare cabuerã, sacerdote maja ʉparã, “Marirena buioʉ ácʉmi,” cʉ caĩ tʉjʉyuparã. To bairo ĩrã ti paʉna nemoo cʉ cañegabajuparã. Camajare na uwibana dope bairo cʉ cáti ñe majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","To bairi aperãre na caĩñuparã, “Cʉ̃re canʉcʉbʉgorãre bairona baitori caroaro cʉ jeniña pojerooya. To bairi roorije cʉ caboca ĩ yʉata nemoona gobierno macanare cʉ mari wadajãgarã, cʉ na ñeato ĩrã,” na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","To bairo na caĩ jeniña rotiricarã maca Jesu tʉpʉ ejari ocõo bairo cʉ caĩ jeniñañuparã: —Jãre camajioʉ, cariape jeto mʉ buionucu Dio yere. To bairi camaja nipetiro jĩcarore bairona cãna na mʉ tʉjʉnucu. ");
INSERT INTO tav_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","To bairi jã ĩ buioya: ¿Roma macana ʉparã jãre carotirã niyeru jãre na cajeninucurijere nare jã cajooro Dio cʉ rotibocʉti? Jesure cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesu maca caroorije cʉ̃re na caĩ tʉgooñarijere tʉjʉ majiri ocõo bairo na caĩñupʉ: ");
INSERT INTO tav_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Niyeru tiire yʉ iñooña. To bairo cʉ caĩro niyeru tiire ne, cʉ caiñooñuparã. Cʉ na caiñooro tʉjʉʉ: —¿Ñamʉ wame to tujati? ¿Ñamʉ riyare bairo cabaurije uca turique to tujati? na caĩ jeniñañupʉ Jesu. To bairo cʉ caĩro: —Romano maja Ʉpaʉ majuu wame ã. Cʉ ye macaje ã, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Baiyupa Romano maja Ʉpaʉre cʉ jooya cʉ ye cãnipere. To bairona Dio cʉ caboorije mʉjaare cʉ cajenirije quenare Diore cʉ jooya, na caĩ yʉyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","To bairo cʉ caĩro apirã ocõo bairo caame ĩñuparã: —¡Ago name! Caroaro mari yʉ majimi. Ricati caroori wamere ĩ buioquẽemi camaja na caapiro, caĩñuparã. To bairi ʉparãre cʉ na cawadajãpere dope bairo cʉ caĩ jeniña bʉga majiquẽjuparã. To bairi cʉ cajeniña janacoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cabero moquena saduceo maja mena macana maca Jesure cʉ cajeniñarã ejayuparã. Camaja cabai yajiricarã tunu catíquẽnama caĩrã cãñuparã saduceo maja. ");
INSERT INTO tav_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","To bairi naa Jesu tʉpʉ eja, ocõo bairo cʉ caĩ jeniñañuparã: —Jãre camajioʉ, Moisé ati wame rotiriquere caĩ ucayupi jã cabuenucuri wamere: “Jĩcaʉ nʉmocʉti punaa mácʉna cʉ cabai yajiata cabai maca cʉ nʉmo cʉparo cʉ jʉgocʉ nʉmo cãnibatacore. To bairo cʉ cáto cʉ macʉ cabuia jʉgoʉ cabai yajiricʉ macʉ anibojagʉmi,” caĩ ucayupi Moisé, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","To bairi siete cãnacãʉ jĩcaʉ punaa cãñuparã. Cãni jʉgoʉ canʉmo cʉtibajupʉ. Punaa mácʉna cabai yajiyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Cabero macacʉ quena cʉ jʉgocʉ cʉ cabai yajiro bero cõrena cawapearicore canʉmo cʉtibajupʉ. Cʉ quena to bairona cabai yajicoajupʉ punaa mácʉna. ");
INSERT INTO tav_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na bero macacʉ quena nare bairona cõrena nʉmo cʉtiba, punaa mácʉna cabai yajicoajupʉ. To bairo jetona jĩcaʉ punaa siete cãnacãʉ cãnibatana co jetorena nʉmo cʉtibana punaa manana cayaji peticoajuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na bero na nʉmo cãnibataco cabai yajiyupo co quena. ");
INSERT INTO tav_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na nipetiro siete cãnacãʉna cõre canʉmo cʉtibajuparã. To bairi na cabai yajiricaro bero tunu catirãpʉ ¿ni maca co cʉ nʉmocʉti majibocʉti? Jesure cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","To bairo na caĩ jeniñaro apii Jesu na caĩ yʉyupʉ: —Caʉmʉa ati yepa macana nʉmocʉma. Cãromia quena manapʉcʉma. ");
INSERT INTO tav_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Cabero Dio cʉ cabejerã na cʉ catunu catioro bero nʉmo cʉtiquẽema. Cãromia quena manapʉ cʉtiquẽema. ");
INSERT INTO tav_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dio tʉ macana ángel majare bairo cãna anigarãma. Dio mena cacaticõa ãna anigarãma. Bai yaji bapooquetigarãma. ");
INSERT INTO tav_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisé cʉ caucariquere tʉjʉrã, “Cabai yajiricarã tunu catigarãma,” mari ĩ maji. Moisé yucʉ puti caʉ̃ tʉjʉnucurijere cʉ catʉjʉ ejanʉcaro ocõo bairo cʉ caĩñupʉ Dio yucʉ puti caʉ̃rijepʉ: “Yʉa Diona yʉ ã. Mʉ ñicʉ jãa na cáti nʉcʉbʉgoʉ yʉ ã. Abraham, Isaá, Jacobo jãa na cáti nʉcʉbʉgoʉ yʉ ã,” cʉ caĩñupʉ Dio Moisére. “Mʉ ñicʉ jãa tirʉmʉpʉ macana na cáti nʉcʉbʉgoricʉ yʉ ã,” caĩquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","To bairi, yucʉ quena yʉ áti nʉcʉbʉgoma ĩi, caĩñupʉ Dio. To bairi yucʉ quenare na yeri cacaticõa ãna aniri cʉ̃re cáti nʉcʉbʉgorã ãma. Cʉ̃re caapipajeerãre na tunu catiogʉmi Dio. To bairi yucʉ quenare cacaticõa ãnare bairona na tʉjʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","To bairo cʉ caĩrijere apirã jĩcaarã judío majare cabuerã: —Jãre camajioʉ, cariape majuu mʉ buio, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cabero cʉ cajeniña nemogaquẽjuparã, “Mari buio netoremi,” ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Cabero na caĩ jeniñañupʉ Jesu moquena: —Aperã, “Cristo Dio cʉ cabejericʉ David pãramipʉ anigʉmi,” ĩnucuma. ¿Nope ĩrã to bairo na ĩnucuti? na caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","—David cʉ majuuna Salmo cawamecʉti pũuropʉ ocõo bairo caĩ ucayupi: Ato yʉ mena ruiya yʉ tʉ maca, yʉ mena carotii anigʉ. ");
INSERT INTO tav_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Yʉ mena ruiri mʉ carotiro mʉre catʉjʉ tutirãre na yʉ regʉ, caĩñupʉ Dio yʉ Ʉpaʉre, caĩ ucayupi David, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","—¿Dope bairo, “Yʉ Ʉpaʉpʉ ãmi,” David cʉ caĩi nibaopʉcʉna cʉ pãramipʉ cʉ ãti Dio cʉ cabejericʉ? na caĩ jeniñañupʉ Jesu. To bairo na cʉ caĩ jeniñaro dope bairo cʉ caĩ yʉ majiquẽjuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Camaja nipetiro na caapijoro ocõo bairo caĩ buioyupʉ Jesu cʉ cabuerãre: ");
INSERT INTO tav_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Judío majare cabuerãre na tʉjʉ majiña. Nare bairo átiqueticõaña. Jutii cayoarije mena jaña aáteñaganucuma, aperã caroaro marire na tʉjʉ nʉcʉbʉgoato ĩrã. To bairi macapʉ wapayerica paʉripʉ na cáaáteñari paʉri camaja nare na cañuu roti nʉcʉbʉgopere booma. Neñapo buerica wiiripʉ ejarã to bairi wamena nare na cáti nʉcʉbʉgopere booma. To bairi caʉparã na caruinucurijepʉ jetore ruiganucuma. Na caboje rʉmʉri áti ʉgari paʉri quenare to bairo jeto baiganucuma. ");
INSERT INTO tav_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Cawapearicarã romiri yere na cacʉgorije cajee pairã nibaopʉnana Dio wiipʉre jãa aána yoaro Diore jeni nʉcʉbʉgotoma. Baitoriquere bairã camaja na catʉjʉro bainucuma. Narena aperã netoro cabai buicʉna na cãnoi aperã netoro na popiyeyegʉmi Dio, na caĩñupʉ Jesu cʉ cabuerãre. ");
INSERT INTO tav_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu Dio wiipʉ ãcʉ niyeru Dio wii na caquenoope wapa na cajãri patapʉ camaja niyeru na cajãro catʉjʉyupʉ. Pairo cacʉgorã ti patapʉre pairo cajãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na berore cawapearico cabopacao pʉga tiiriacã cawapa maniacãre cajãñupo. ");
INSERT INTO tav_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tiere co cajãro tʉjʉʉ Jesu ocõo bairo caĩñupʉ: —Cariape mʉñʉja ĩ. Atio cawapearico cabopacao maca Dio cʉ catʉjʉro aperã nipetiro na netoro joo netocoamo. ");
INSERT INTO tav_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Na maca pairo cacʉgorã aniri nare carʉjarijere jooma. Co maca, “Cabopacao yʉ ã,” ĩ tʉgooñaquẽcona nipetiro co cacʉgobatajeacãre joomo. Co caʉga catíboriqueacãrena joo peocõamo, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aperã Dio wii cãniere wadapenirã Jesure cʉ caĩñuparã: —Tʉjʉya ati wiire Dio wii. Caroa wii majuu anicõa. Ʉ̃ta rupaa caroa rupaa mena jeto áta wii ã. Diore na cajoorique mena caroa jeto cabauri wiire cájupa. ");
INSERT INTO tav_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","To bairo na caĩro: —Ape rʉmʉpʉ atie mʉja catʉjʉrije nipetiro re peocõagarãma aperã. Ʉ̃ta rupaa na capeobataje jĩca rʉjaricaro mano re peticõagarãma aperã. ");
INSERT INTO tav_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Cabero Jesure cʉ cajeniñañuparã: —Jãre camajioʉ, ¿noo cõopʉ to bairoati mʉ caĩri wame? ¿Dope bairo jã majirãati to bairo cabaiparo jʉgoye? ");
INSERT INTO tav_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","To bairo cʉ na caĩ jeniñaro ocõo bairo na caĩ buioyupʉ Jesu: —Aperã mʉjaare na caĩtorijere mari apipajeere ĩrã caroaro tʉgooña majiña. “Dio cʉ cajooricʉna yʉ ã. Cristo Dio cʉ cajoʉ cʉ caejari paʉ anitʉga,” ĩtogarãma. To bairo na caĩtorijere api nʉcʉbʉgoqueticõaña. ");
INSERT INTO tav_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Camaja ame quẽri ame jĩagarãma. Camaja ati yepa macana na ʉparãre ĩ punijiniri na regarãma. To bairo cabairijere queti apirã uwiqueticõaña. To bairo jeto baigaro mai. To baibao joroquena ati ʉmʉrecoo capetiparo rʉjagaro mai, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","To bairo na ĩ, ocõo bairo na caĩnemoñupʉ Jesu: —Jĩca maja ape maja mena ame quẽgarãma. Jĩca yepa macana ape yepa macana mena ame quẽgarãma na ʉparã na caame quẽ rotiroi. Ati yepa nipetiropʉ to bairo jeto ame átigarãma. ");
INSERT INTO tav_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ati yepa seeto nanaagaro. Ape paʉri ʉgarique camano ñigo boagarãma camaja. Ape paʉri riaye tamʉo yaji petigarãma. Ʉmʉrecoopʉre cauwiorije ape wame mʉja catʉjʉñaquẽtie baugaro. ");
INSERT INTO tav_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’To bairo cabaiparo jʉgoye yʉ ye quetire caapigateerã rooro mʉja átigarãma. Na neñapo buerica wiiripʉ mʉja ñe aánucu, mʉja jeniñacõari presopʉ mʉja joogarãma, yʉre mʉja cáti nʉcʉbʉgorije wapa. Maca ʉparã tʉripʉ mʉja joogarãma, “Na popiyeyeya,” ĩrã. ");
INSERT INTO tav_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","To bairo mʉja na cátibao joroquena caroaro na mʉja boca buiocõagarã yʉre mʉja cáti nʉcʉbʉgorijere. ");
INSERT INTO tav_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mʉjaare na caĩ jeniñaparo jʉgoye, “Ocõo bairije na mari ĩ yʉ majigarã rooro marire na cátiquetiparore bairo ĩrã,” ĩ tʉgooña yuuqueticõaña. ");
INSERT INTO tav_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉ maca mʉñʉja majiogʉ nare mʉja caĩ yʉpere. To bairi mʉjaare catʉjʉ tutirã mʉja wada neto majiquetigarãma. ");
INSERT INTO tav_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mʉja pacʉa, mʉja bairã, mʉja yarã majuu, mʉja mena macana anibaopʉnana mʉja wadajãgarãma mʉjaare catʉjʉ tutirãre. To bairo mʉjaare na cawadajãro jĩcaarãre mʉjaare jĩa regarãma. ");
INSERT INTO tav_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yʉre caapipajeerã mʉja cãno maca camaja to cãnacã maca macana mʉja teegarãma. ");
INSERT INTO tav_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","To bairo mʉja átibaopʉnana, jĩacã jĩca wame uno mʉja áti rooye tuuquetigarãma mʉja catiriquere. ");
INSERT INTO tav_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","To bairi yʉre api nʉcʉbʉgocõa aninucuña. To bairo bairã catirique majuu mʉja bʉgagarã. ");
INSERT INTO tav_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Polisía capãarã Jerusalén macare na cajotoo ame jorero na tʉjʉrã, “Mere ati macare rocagarã áama,” mʉja ĩ tʉjʉ majigarã. ");
INSERT INTO tav_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","To bairi Judea yepapʉ cãna ʉ̃ta yucʉpʉ na ruti aáparo. Camaja Jerusalén macapʉre cãna aperopʉ na ruti aáparo. Maca tʉjaro cãna macapʉ na tunu piya atíquẽparo. ");
INSERT INTO tav_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti paʉna Jerusalén macanare Dio nare cʉ capopiyeyeri rʉmʉri anigaro. Dio ye queti ucarica pũuri caĩrore bairona na baigaro. ");
INSERT INTO tav_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti paʉre rooro na anigaro ʉta pacoa romirire, aperã cawimarãacãre caũpuorã romiri quenare. Atʉ ruti aá majiquetigarãma. Ti paʉ judío majare seeto popiye tamʉorique na anigaro Dio nare cʉ capopiyeyerije jʉgori. ");
INSERT INTO tav_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Camaja capãarã bai yajigarãma ame jĩarique jʉgori. Aperãre na jee aá bate cʉgogarãma aperoripʉ. To bairo na átiri Jerusalén macare jĩa baurio rocacõagarãma. Judío maja cãniquẽna to bairije átigarãma ati macapʉre. “To cõona ája,” Dio nare cʉ caĩri paʉ cãnopʉ janagarãma yua. ");
INSERT INTO tav_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’To bairi ʉmʉrecoopʉre ricati cabaurije anigaro. Muipʉ caajii, ñami macacʉ muipʉ quena, ñocoa quena ricati cabaurã anigarãma. Ria capaca yari mar seeto paca jabe ocacʉtigaro. Pairo cajabe ocacʉto apirã camaja ati yepa macana seeto acʉa uwigarãma. ");
INSERT INTO tav_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ñocoa quena yuguigarãma. To bairi, “¿Dope bairo to bairoati ati yepapʉ? ¿Ñeere ĩro to baiti?” ĩ tʉgooñagarãma camaja, uwi netobana. ");
INSERT INTO tav_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","To bairo cabairi paʉna yʉ catutuarije mena yʉ atígʉ ʉmʉrecoopʉi. To bairo baii bujeri bʉrʉapʉ seeto yʉ caaji baterije mena yʉ cáató tʉjʉgarãma camaja. ");
INSERT INTO tav_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","To bairi atie cauwiorije cabai jʉgoro tʉjʉrã tʉjʉ wariñuu ocabʉticõaña. Ati yepapʉ cabairijere nemoo marire netoo catiogʉ atígʉmi Jesu ĩrã wariñuu ocabʉtiya, na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","To bairo na ĩ, ocõo bairo na caĩ buioyupʉ Jesu moquena: —Higuera cawamecʉtii, ape wame yucʉ cabairije quenare tʉgooñaña. ");
INSERT INTO tav_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Apeye capũ cawajoarijere tʉjʉrã, “Yucʉacãna cʉma anigaro bai,” ĩ majirique ã. ");
INSERT INTO tav_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","To bairo mʉñʉja cabuiori wamerire bairo cabairo tʉjʉrã, “Yucʉacã Jesu tunu atígʉmi ati yepapʉ, Ʉpaʉ anigʉ,” mʉja ĩ tʉjʉ majigarã. ");
INSERT INTO tav_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Cariapena mʉñʉja ĩ. Atie nipetiro mʉñʉja caĩri wamere bairona baigaro ati yepa macaje capetiparo jʉgoye. ");
INSERT INTO tav_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ʉmʉrecoo, ati yepa quena to cõona wajoagaro. “To bairo yʉ átigʉ,” yʉ caĩrije maca wajoaquetigaro. Yʉ caĩ buiorore bairona baigaro. ");
INSERT INTO tav_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’To bairi caroaro tʉgooña maja catiya, mʉja cátiere ána. Ati yepa macajere tʉgooñarique paiqueticõaña. Eti cumuqueticõaña. Caroorije jeto mari áticõa anire ĩrã caroorijere átigaqueticõaña. To bairo caroorije cátiquetinucurã mʉja cãmata yʉre mʉja tʉjʉ acʉaquetigarã yʉ catunu ejari paʉ cãno. ");
INSERT INTO tav_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Camaja nipetiro na yʉ capopiyeyepere yʉ ruti majiquetigarãma. ");
INSERT INTO tav_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","To bairi caroaro quenoo yuuricarãre bairo yʉ caboorijere áticõa aninucuña. Tie popiye tamʉorique mʉja canetooparore bairo ĩrã Diore jenicõa aninucuña. To bairo ána boboricaro mano yʉre mʉja boca tʉjʉgarã, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ti rʉmʉrire to cãnacã rʉmʉ Dio wiipʉ cʉ ye quetire camajare cabuio ãñupʉ Jesu. Ñami cãno ti macare buti aá, Olivo cawamecʉtii ʉ̃taʉpʉ cacani ñamicʉti bujucoajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","To bairi cabujuri paʉ cãno camaja nipetiro Dio wiipʉ cáaájuparã, Jesu cʉ cabuiorijere apigarã. ");
INSERT INTO tav_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pan levadura na caĩrije cawauorije caajuya manie na caʉgapa rʉmʉ pascua rʉmʉ jʉgoyeacã cãñupe yua. ");
INSERT INTO tav_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","To bairi sacerdote maja ʉparã, judío majare cabuerã Jesure cʉ cajĩagayuparã. “¿Dope bairo cʉ áti ñeri cʉ mari jĩarãati?” caame ĩñuparã. To bairo ĩbaopʉnana camajare na cauwiyuparã, capãarã cʉ̃re canʉcʉbʉgorã na cãno maca. ");
INSERT INTO tav_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","To bairo na caĩri paʉre Judas Iscariote cawamecʉcʉpʉre cajãañupʉ Sataná. Jesu cʉ cabuerã doce cãnacãʉ mena macacʉ cãnibajupʉ Judas. ");
INSERT INTO tav_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","To bairi cʉ̃re Sataná cʉ cajãaro cáaácoajupʉ Judas sacerdote maja ʉparã, aperã Dio wii coteri maja tʉpʉre. Na tʉpʉ eja, Jesure dope bairo cʉ̃re na cáti ñepere na mena cawadapeniñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","To bairo cʉ caĩ wadajãrijere apirã, seeto cawariñuuñuparã: —To bairo jã mʉ caĩ buioroi niyeru mʉre jã wapayegarã, Judare cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Jaʉ, na caĩñupʉ Judas. “Jaʉ,” na ĩ, “¿Dope bairo áti Jesure cʉ yʉ wadajãʉati ʉparãpʉre, aperã yʉre na camajiquẽtopʉ?” caĩ tʉgooñañupʉ Judas. ");
INSERT INTO tav_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Cabero pan cawauorije mena caajuya manie na caʉgari rʉmʉ majuu cãñupe. Ti rʉmʉna cãñupe Diore tʉgooñari nuricʉ waibʉcʉ oveja na caĩi cawamaʉre na cajĩanucurica rʉmʉ. Pascua rʉmʉ cãno to cãnacã cʉma to bairo jeto cátinucuñuparã ti rʉmʉ unore. ");
INSERT INTO tav_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","To bairi ti rʉmʉ cãno Pedrore, Juãre ocõo bairo na caĩñupʉ Jesu: —Pascua boje rʉmʉ macaje mari caʉgapere quenoo yuurãja. ");
INSERT INTO tav_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","To bairo na cʉ caĩro: —¿Noopʉ jã quenoo yuurãati? cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","To bairo cʉ na caĩ jeniñaro: —Jerusalén macapʉre aánaja. Maca ejarã jĩcaʉ cʉ mʉja tʉjʉgarã caoco jotʉ tu peo aácʉre. Cʉ tʉjʉrã di wii cʉ cajãa aáti wiire cʉ mʉja ʉja jãa aágarã. ");
INSERT INTO tav_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cʉ mena jãa aá, ocõo bairo ti wii ʉpaʉre cʉ mʉja ĩgarã: “Jãre camajioʉ ocõo bairo jã ĩ joomi, ‘¿Noopʉ to ãti pascua boje rʉmʉ cãno yʉ cabuerã mena yʉ caʉgapa arʉa? cʉ ĩ jeniñarãja ti wii ʉpaʉre,’ jã ĩ joomi,” cʉ mʉja ĩgarã. ");
INSERT INTO tav_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","To bairo cʉ mʉja caĩro, cabui macá arʉa, capairi arʉa, quenoo yaparorica arʉare mʉja iñoogʉmi. Ti arʉapʉ mari caʉgapere quenoo yuurãja, na caĩñupʉ Jesu Pedrore, Juãre. ");
INSERT INTO tav_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","To bairi macapʉ cáaácoajuparã na pʉgarã. Aá, cabʉga ejayuparã Jesu cʉ caĩricarore bairona. To bairi ti arʉapʉre pascua cãno na caʉgapere caquenoo yuuyuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nipetiro na caquenoo yaparoricaro bero Jesu cʉ cabuerã mena ʉgagarã caneñapoyuparã ti arʉapʉre. ");
INSERT INTO tav_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ʉgarica cajawa tʉ na carui petiro tʉjʉʉ ocõo bairo na caĩñupʉ Jesu: —Atie pascua macaje ʉgarique mʉja mena seeto yʉ ʉgaga yʉ capopiye tamʉoparo jʉgoye. Atie pascua macaje mʉja mena yʉ caʉga tʉjarije anigaro bai. ");
INSERT INTO tav_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cariape mʉñʉja ĩ: Atie pascua macajere mʉja mena yʉ ʉganemoquetigʉ. Cabero moquena Ʉpaʉ Dio yʉre cʉ cajõori paʉ cãnopʉ, tiere mʉja mena yʉ ʉganemogʉ, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","To bairo na ĩ, etirica jotʉre ne, Diore, “Ñuubʉja,” cʉ ĩ, ocõo bairo na caĩñupʉ: —Atie etiriquere neri etiya mʉja cãno cãnacãʉna. ");
INSERT INTO tav_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cariapena mʉñʉja ĩ: Atie ʉje wẽ rica ocore Ʉpaʉ Dio yʉre cʉ cajõoparo jʉgoye yʉ etinemoquetigʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","To bairo na ĩ, ʉgarique pãre caneñupʉ Jesu. Tiere ne, Diore, “Ñuubʉja,” cʉ caĩñupʉ moquena. To bairo Diore cʉ ĩ, ʉgarique pãre pe bate, na caricawoyupʉ. Na ricawo, ocõo bairo na caĩ buioyupʉ: —Atie yʉ rupaʉ ã. Mʉjaare yʉ cabai yajibojapere tʉgooñari ʉgaya atiere, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ʉgarique pãre ricawori bero moquena etirica jotʉre ne, ocõo bairo na caĩñupʉ: —Dio, “Camaja caroorije na cátiere na yʉ majiritiogʉ,” caĩ cũwĩ. Mʉjaare yʉ carií yajibojape jʉgori jeto majiritiomi Dio caroorije mʉja cátajere. Yʉ rií cayuyurijena mʉja ye wapa anigaro. To bairi atiere etirã ti wamere tʉgooñaña. ");
INSERT INTO tav_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","’Yʉre baigaro Dio ye queti ucarica pũuripʉ tirʉmʉpʉ macana na caĩ ucaricarore bairona. To bairi jĩcaʉ ati cajawapʉ mari mena caʉga ruii yʉre cajĩaparãre yʉ wadajãgʉmi. To bairo caĩire seeto ñuuquetigaro cʉ̃re, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","To bairo Jesu na cʉ caĩro: —¿Ni maca mari mena macacʉ to bairo caĩpaʉ cʉ ãti? caame ĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesu to bairo na cʉ caĩ buioro bero cʉ cabuerã ocõo bairo caame ĩ wada netoñuparã: —¿Ni maca cʉ ãcʉati marire cajʉgo ani majuupaʉ? caame ĩ wada netoñuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","To bairo na caame ĩ wada netorijere apii ocõo bairo na caĩñupʉ Jesu: —Ati yepa macanare na ʉparã tutuaro na rotima. “Jã ʉparã caroaro jã rotima, caroaro jã átinemoma,” jãre na ĩato ĩrã tutuaro na rotima. ");
INSERT INTO tav_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉja maca nare bairo baiqueticõaña mʉjaa. Nii aperãre cajʉgo anipaʉ anigʉ cawatoa macacʉre bairona cʉ anicõato. Nii aperãre carotii anigʉ nare capaabojaʉre bairo maca cʉ anicõato. ");
INSERT INTO tav_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ocõo bairo ĩma camaja: “Caʉpaʉ cãni majuʉ ãmi. Cʉ̃re capaabojaʉ maca cawatoa macacʉ ãmi,” ĩma camaja. Yʉ maca mʉja Ʉpaʉ nibaopʉcʉna mʉjaare capaabojaʉre bairona yʉ ã. ");
INSERT INTO tav_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Aperã rooro yʉ na caĩ eperije to nibao joroquena yʉ menana mʉja anicõa. Yʉre mʉja aáweoquẽe. ");
INSERT INTO tav_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","To bairi yʉ Pacʉ yʉre Ʉpaʉ cʉ cajõoricarore bairona yʉ quena mʉjaare ʉparã mʉñʉja jõogʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","To bairi Ʉpaʉ yʉ cãni paʉpʉ yʉ mena eti, ʉga, mʉja áti ruigarã. Israel macanare doce cãnacã poari macanare mʉja rotigarã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesu Simón Pedrore ocõo bairo cʉ caĩñupʉ: —Simón, apiya. Sataná caroorije mʉja átigao joroque seeto mʉja ocajãgami. Trigo aperire ti ajerire jʉgá papu bate rericarore bairona mʉja átigami Sataná. ");
INSERT INTO tav_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","To bairi Diore mʉ yʉ jenibojawʉ, yʉre mʉ caapipajee nʉcʉbʉgo janaquetiparore bairo ĩi. To bairi yʉre catutirãre uwibacʉ, yʉre mʉ caĩtoro bero moquena yʉre catʉgooña ocabʉtii ãcʉpʉ aperã yʉ cabuerãre na mʉ tʉgooña ocabʉtiogʉ, Pedrore cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","To bairo cʉ caĩro: —Ʉpaʉ, presopʉ mʉre na cajoata yʉ quena yʉ aágʉ. Mʉre na cajĩaata quena yʉ quenare na jĩato, cʉ caĩñupʉ Simón Pedro. ");
INSERT INTO tav_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","To bairo cʉ caĩro: —Pedro, cariape mʉ yʉ ĩ. Ati ñamina ãbocʉ cʉ capiparo jʉgoye itiani, “Jesure cʉ yʉ majiquẽe,” na mʉ ĩtogʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Cabero Jesu ocõo bairo na caĩ jeniñañupʉ cʉ cabuerãre: —Tirʉmʉ mʉñʉja cabuio teña rotiro mʉja wajopori mʉja niyeru, mʉja rʉpo jutii jee aáquẽnana mʉja cáaápʉ. To bairona mʉja cabuio teñaropʉ ¿noo cõo mʉja caboori wame mʉja to carʉjari? na caĩ jeniñañupʉ. —Jã carʉjaquẽpʉ. Caroaro jã cabaiwʉ, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","To bairo na caĩro: —Yucʉacã cawajoporicʉna jee aánaja. Niyeru jãrica pori quenare jee aánaja. Nii cajarerica pãi mácʉ cʉ ye jutii cabui macajere nuni wapa jee, jarerica pãi macare cʉ wapayeato. ");
INSERT INTO tav_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ocõo bairo mʉñʉja ĩ buio: Dio ye queti ucarica pũuripʉ ocõo bairo ĩ ucarique ã yʉ cabaipere: “Caroorãre átatore bairona cʉ átigarãma, cʉ popiyeyerã,” ĩ ucarique ã. To bairona yʉ átigarãma yucʉra, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Cʉ cabuerã ocõo bairo cʉ caĩñuparã: —Ʉ̃jʉ, Ʉpaʉ, atona pʉga pãi jarerica pãirire jã cʉgo. To bairo cʉ na caĩro: —Ñuugaro, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","To bairo na ĩri bero Jerusalén cãnacʉ cabuti aájupʉ Jesu. Buti aácʉ, cʉ cabainucuricarore bairo, Olivo cawamecʉtii ʉ̃taʉpʉ cáaájupʉ. Cʉ cabuerã quena cʉ caʉja aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Topʉ ejaʉ ocõo bairo na caĩñupʉ Jesu: —Diore cʉ jeniya, Sataná mʉjaare cʉ caocajãquetiparore bairo ĩrã, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","To bairo na ĩ, na jʉgoyebʉjaacã cáaájupʉ ʉ̃taa re ejooricaro cõo yoaroacã. Aá, yepapʉre rʉpopatuapʉ tuatu cumuri Diore cʉ cajeniñupʉ: ");
INSERT INTO tav_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Caacʉ, caĩñupʉ. —Mʉ cabooata yʉ capopiye tamʉope yʉre to baiquetio joroque ája. To bairo mʉre yʉ cajenirije to nibao joroquena mʉ maca mʉ caboori wame ája. Yʉ maca yʉ caboori wame átiquẽja, caĩñupʉ Jesu Diore. ");
INSERT INTO tav_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","To bairo cʉ caĩri paʉna ʉmʉrecoo macacʉ jĩcaʉ ángel cʉ tʉna cabuianʉca ejayupʉ, tʉgooña ocabʉtiriquere cʉ joʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesu seeto yeri tʉgooñarique pairique mena catamʉoñupʉ. To bairo baibacʉ moquena Diore cajeninemoñupʉ. Seeto caajipuayupʉ. Cʉ caajipuarije riíre bairo cawẽñupe yepapʉre. ");
INSERT INTO tav_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","To bairo Diore cʉ ĩ yaparo wamʉnʉca, cʉ cabuerã tʉpʉ aá, cacanirãre na caejayupʉ. Yoaro jʉtiriti cote anibana wʉgo ejari cacanicoajuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","To bairo cacanirãre na tʉjʉʉ: —¿Nope ĩrã mʉja caniti? ¡Yopiya! Diore cʉ jeniya, Sataná marire cʉ caocajãro caroorije jã átiqueticõato ĩrã, na caĩñupʉ Jesu moquena. ");
INSERT INTO tav_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","To bairo na cʉ caĩ wada ani paʉna, camaja capãarã caejayuparã. Judas cawamecʉcʉ, Jesu cʉ cabuerã mena cãnibatacʉ na cajʉgo ajupʉ. Na jʉgo atí, Jesu tʉ eja, caroarona, “Manibapare,” ĩri cʉ cañe pabarioyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","To bairo cʉ cáto: —Judas, ¿nope ĩi caroaro ñuu roti pabariotori yʉre cajĩaparãre yʉ tʉpʉ na mʉ jʉgo ejati? cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesu mena cãna maca cʉ na cañegaro tʉjʉrã, ocõo bairo cʉ caĩ jeniñañuparã: —Ʉpaʉ, ¿jarerica pãiri mena na mari quẽrãati? cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","To bairo na caĩri paʉna Jesu cʉ cabuei sacerdote maja ʉpaʉ cʉ paabojari majocʉ jĩcaʉre cʉ caamooro pa ta rocacõañupʉ, cariape nʉgoa macatore. ");
INSERT INTO tav_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","To bairo cʉ cáto tʉjʉʉ Jesu maca: —Átiqueticõaña, cʉ caĩñupʉ. To bairo cʉ cabueire cʉ ĩ, cʉ capa taricʉre cʉ amoorore paña, cʉ catu quenoocõañupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Cabero cʉ̃re cañegarãre, sacerdote majare, Dio wii coteri majare, aperã cabʉcʉrã judío majare carotirãre ocõo bairo na caĩñupʉ Jesu: —¿Nope ĩrã jee rutiri majocʉre ánare bairo jarerica pãiri, yucʉ rʉcari jee atíri, yʉ mʉja áti ñegati? ");
INSERT INTO tav_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","To cãnacã rʉmʉ Dio wiipʉ mʉja mena yʉ cãno to bairo yʉre mʉja cáti ñequẽpʉ. Yucʉra mʉja caboorijere mʉja átigarã. Sataná caroorije ʉpaʉ cʉ caboorije mʉja cʉ cáti rotirijere mʉja átigarã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","To bairo na cʉ caĩro bero Jesure cʉ cañe aájuparã sacerdote maja ʉpaʉ ya wiipʉ. Topʉ cʉ na cañe aáto Pedro quena na beropʉ caʉja aájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jesure cʉ na cane aáti wii jania amejorerica janiro pupeapʉ capero rioyuparã Dio wii paabojari maja. Pero rio átiri cajuma ruiyuparã. To bairo na cabairo tʉjʉʉ Pedro quena na tʉ cajuma ejanumu ajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pero caʉ̃ bujuro cʉ cajuma ruiro cʉ tʉjʉo jĩcao paabojari majoco caroaro cʉ tʉjʉ quenoo, ocõo bairo caĩñupo to cãnare: —Ani quena Jesu mena cãninucuepaʉ ãmi, caĩñupo. ");
INSERT INTO tav_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","To bairo co caĩrije apii: —Cʉ yʉ majiquẽe, caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Petoacã bero apei Pedrore cʉ tʉjʉʉ ocõo bairo cʉ caĩñupʉ: —Mʉa Jesu cabuerã mena macacʉna mʉ ã mʉ quena, cʉ caĩñupʉ. To bairo cʉ caĩro: —Yʉ baiquẽe yʉa, cʉ caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jĩca hora yoaroacã bero apei caĩñupʉ moquena: —Ani Jesu mena macacʉna ãmi, jocʉ mee yʉ ĩ. Cʉ quena Galilea macacʉ ãmi, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","To bairo cʉ caĩro: —¡Yʉ mʉ caĩrijere yʉ majiqueti majuucõa, name! cʉ caĩñupʉ Pedro. To bairo cʉ caĩ ani paʉna ãbocʉ capiyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ãbocʉ cʉ capiro Jesu cʉ caamejore nʉca tʉjʉyupʉ Pedrore. Cʉ caamejore nʉca tʉjʉro Pedro catʉgooña bʉgayupʉ Jesu cʉ̃re cʉ caĩriquere. “Ati ñami ãbocʉ cʉ capiparo jʉgoye itiani, ‘Cʉ yʉ majiquẽe,’ mʉ ĩtogʉ,” mari Ʉpaʉ Jesu cʉ caĩriquere catʉgooña bʉgayupʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ti wamere tʉgooña bʉga, buti aá, caotiyupʉ Pedro seeto, jʉtiritibacʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesure cañericarã cʉ ĩ eperi cʉ capayuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Cʉ capere juti ajero mena jia bipecõari cʉ capa epeyuparã. Cʉ pa átiri: —¿Ni maca mʉ cʉ pari? Dio ye quetire buiori majocʉ mʉ cãmata mʉ majuuna tʉgooña bʉga majiri jã buioya, cʉ caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ape wame capee caroorije cʉ caĩ wada epeyuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cabujuri paʉ yua, cabʉcʉrã rotiri maja, sacerdote maja ʉparã, aperã judío majare cabuerã caneñapoyuparã, Jesure cʉ jeniñagarã. To bairi Jesure cʉ cane aájuparã na cawadapeniri arʉapʉ. ");
INSERT INTO tav_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Cʉ ne aá, ocõo bairo cʉ caĩ jeniñañuparã: —Mʉa Dio cʉ cajooricʉna Cristona mʉ cãmata mʉ cãniere jã ĩ buioya. To bairo cʉ na caĩ jeniñaro: —To bairo mʉñʉja cabuiorije to nibao joroquena yʉ mʉja api nʉcʉbʉgoquetiborã. ");
INSERT INTO tav_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ape wame mʉjaare yʉ cajeniñarije to nibao joroquena yʉ mʉja yʉquetiborã. Yʉ mʉja buuquetiborã. ");
INSERT INTO tav_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yucʉ bero mena to cõona Dio tʉ ruiri cʉ mena yʉ rotigʉ, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","To bairo cʉ caĩro: —¿Mʉa Dio Macʉna mʉ ãti? cʉ caĩ jeniñañuparã. To bairo na caĩro: —Cʉna yʉ ã, mʉja caĩrore bairona, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","To bairo cʉ caĩro: —To cõona aperã caroorije cʉ caĩ wadarijere caapiricarã na cabuiorijere mari apinemoqueticõato. Mari majuuna mere Jesu cʉ caĩrijere mari apicõa, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Cabero na nipetiro na caneñapori arʉapʉ cãnana Pilato tʉpʉ Jesure cʉ cane aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Topʉ ejarã ocõo bairo cʉ caĩñuparã: —Ani jãre judío majare caĩto paii ãmi. Niyeru gobierno macacʉ romano maja ʉpaʉ camajare cʉ cawapa jee roti joorijere, “Jooqueticõaña,” camajare na ĩnucumi. To bairo quenare, “Yʉa Dio tʉpʉ cãnacʉ camaja tʉpʉ cʉ cajooricʉ majuu yʉ ã,” ĩmi. To bairo ĩi, “Ʉpaʉ yʉ ã,” ĩi ĩnucumi, cʉ caĩ buioyuparã Pilatore. ");
INSERT INTO tav_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","To bairo na caĩro apii Pilato ocõo bairo cʉ caĩ jeniñañupʉ Jesure: —Mʉa, ¿judío maja Ʉpaʉna mʉ ãti? cʉ caĩ jeniñañupʉ. —To bairona yʉ ã mʉ caĩrore bairona, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","To bairo cʉ caĩro bero Dio wii ʉparãre, camaja capãarã to cãnare ocõo bairo na caĩñupʉ Pilato: —Ani caroorije cátacʉ ãmi, cabai buicʉcʉ ãmi, yʉ ĩ majiquẽe, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","To bairo na cʉ caĩrije to nibao joroquena ocõo bairo cʉ caĩnemoñuparã Pilatore: —Camajare ĩ rooye tuu teñanucumi, Judea yepa nipetiropʉ. Galilea yepapʉre to bairo caĩ rooye tuu teña jʉgoyupi. Atopʉ quenare to bairona ĩ rooye tuu teñaʉ ejami, cʉ caĩnemoñuparã Pilatore. ");
INSERT INTO tav_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato to bairo na caĩrije apii ocõo bairo na caĩ jeniñañupʉ: —¿Ani Jesu Galilea macacʉna cʉ ãti? —Ʉ̃ʉjʉ, cʉna ãmi, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Cʉna ãmi,” na caĩro apii: —Herode tʉpʉ cʉ ne aánaja, na caĩñupʉ. Herode Galilea yepa ʉpaʉ cãñupʉ. To bairo cabairi rʉmʉri cãno cʉ quena Jerusalẽpʉna cãñupʉ. To bairo Pilato na cʉ caĩrijere apii Jesure cʉ cane aájuparã Herode tʉpʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Cʉ tʉ cʉ na cane ejaro tʉjʉʉ seeto cawariñuuñupʉ Herode, Jesure cʉ tʉjʉʉ. Cajʉgoyepʉre seeto Jesure cʉ catʉjʉganucubajupʉ Herode. “Jesu ãñupʉ,” na caĩrijere caqueti apinucuñupʉ. Seeto cʉ cáti iñoorijere catʉjʉganucubajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","To bairi Jesure cʉ tʉjʉʉ capee wameri cʉ cajeniñabajupʉ. Jesu maca cʉ cayʉquẽjupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sacerdote maja ʉparã, aperã judío majare cabuerã to catʉjʉnucurã tutuaro mena, “Carooʉ majuu ãmi Jesu,” cʉ caĩñuparã Herodere. ");
INSERT INTO tav_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","To cõona Herode cʉ polisía maja mena rooro cʉ caĩ epeyuparã Jesure. To bairo cʉ ĩ eperã caʉpaʉ jañarique jutii caroa mena cʉ cajã epeyuparã. To bairona rooro Jesure cʉ áti epe, cʉ catunuo jooyupʉ Pilato tʉpʉ moquena. ");
INSERT INTO tav_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti rʉmʉna Herode Pilato mena caame oca quenooñuparã, cajʉgoye caame tʉjʉgaquetibatana. ");
INSERT INTO tav_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Cabero Pilato na cajʉgo neñapoyupʉ sacerdote maja ʉparãre, camajare cajʉgo ãnare, camaja aperã quenare yua. ");
INSERT INTO tav_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na jʉgo neñapo, ocõo bairo na caĩñupʉ: —Anire yʉ tʉpʉ cʉ mʉja neajupa, “Camajare carooye tuʉ ãmi,” ĩrã. To bairi mʉja caapiro caroaro cʉ yʉ jeniñawʉ. Caroorije cʉ cátaje cʉ mʉja caĩrijere yʉ bʉgaquẽe. Cabai bui cʉtiquẽcʉ ãñupi. ");
INSERT INTO tav_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode quena jã tʉpʉ cʉ tunuo jooyupi, “Cabai bui cʉtiquẽcʉ ãmi,” ĩi. To bairi ñe unie cátiquẽcʉrena cʉ cajĩaquetipe ã. ");
INSERT INTO tav_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Baiyupa cʉ̃re wecʉ ajero wẽri mena na bape roti átiri to cõona cʉ yʉ buucõagʉ, na caĩñupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","To cãnacã cʉma pascua boje rʉmʉ cãno jĩcaʉre na cabuunucuñupʉ Pilato presopʉ cãcʉre. ");
INSERT INTO tav_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","To bairi Pilato, “Jesure cʉ yʉ buugʉ,” cʉ caĩro apirã caawajayuparã: —¡Anire Jesure cʉ na jĩa rocacõato! ¡Barrabá macare cʉ buuya! caĩ awajayuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabá cawamecʉcʉ cʉ mena macanare na cajʉgo quẽricʉ cãñupʉ ʉparãre. To bairo jʉgo quẽi camajare na cajĩañupʉ. To bairo cʉ cátaje wapa presopʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","To bairi Pilato seeto Jesure cʉ buugʉ na caĩbajupʉ moquena. ");
INSERT INTO tav_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","To bairo na cʉ caĩ buiorije to nibao joroquena seeto caĩ awajayuparã: —¡Yucʉ pãi tẽorica pãipʉ cʉ na papuacõato! ");
INSERT INTO tav_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","To bairo na caĩro ocõo bairo na caĩñupʉ Pilato moquena: —¿Ñee unie caroorije cʉ cátaje to ãti cʉ̃re? Ñee unie cátiquẽcʉrena cʉ cajĩaquetipe ã. To bairi wecʉ ajero wẽri mena na bape rotiri cʉ yʉ buugʉ, na caĩñupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na maca to bairo cʉ caĩrijere apirã seeto janaricaro mano caawajanemoñuparã sacerdote maja ʉparã jãa: —¡Yucʉ tẽorica pãipʉ cʉ na papuacõato! To bairi seeto na caĩ jeni awaja netorijere caapicõañupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","To cõona na caboori wame cʉ na cajeniri wame na cáti rotiyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barrabá, caʉparãre catei, camajare cajʉgo jĩaricʉ macare cabuuyupʉ, presopʉ cãnibatacʉre. Jesu macare mʉja caboorore bairo cʉ ája ĩi, na cajooyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","To bairi Jesure cʉ cane aájuparã, yucʉ pãipʉ cʉ papua jĩagarã. Cʉ na cane aáto na cabocayupʉ Simón cawamecʉcʉ. Maca tʉjaro aáteña tunu acʉ́ cájupʉ. Sirene cawamecʉti maca macacʉ cãñupʉ Simón. To bairi Simón na cʉ cabocaro tʉjʉrã Jesure cʉ na capapua tupa pãire cʉ ne peori Jesu bero cʉ capʉja ʉja rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesure na cane aáto camaja capãarã cʉ caʉja aájuparã. Cãromia capãarã jʉtiritiri caoti ʉjayuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","To bairo na caotiro apii na amejore nʉca tʉjʉ, ocõo bairo na caĩñupʉ Jesu: —Mʉjaa, Jerusalén macana romiri yʉre tʉjʉ jʉtiriti otiqueticõaña. Mʉja majuuna, mʉja punaa macare na tʉjʉ jʉtiriti otiya. ");
INSERT INTO tav_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Caberopʉ camaja ocõo bairo ĩgarãma: “Capunaa mana mari cãmata mari wariñuuboyupa.” ");
INSERT INTO tav_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Camaja uwi netobana, “Ʉ̃ta yucʉ ña ató, marire to jĩa recõato,” ĩ tʉgooñagarãma. ");
INSERT INTO tav_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Roorije yʉ ána áama yʉre, caroorije mácʉrena. To bairi naa caroorijecʉna aniri seeto popiye tamʉogarãma na maca, na caĩñupʉ Jesu caotirã romirire. ");
INSERT INTO tav_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aperã quenare pʉgarã caroorije cátinucuricarãre na cajee aájuparã, Jesu mena na jĩagarã. ");
INSERT INTO tav_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na jee aá, Calavera na caĩri paʉpʉ eja, topʉ cʉ capapuayuparã Jesure, caroorã mena. Cariape nʉgoa jĩcaʉ, cajõcʉ nʉgoa tʉ apei na capapuayuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cʉ̃re na capapuari paʉna ocõo bairo cʉ Pacʉ Diore cʉ caĩñupʉ Jesu: —Caacʉ, yʉre capapuarãre na cátiere na majiritioya. Na cátiere majiquẽema, caĩñupʉ Jesu. Cʉ jutii cãnibatajere caame ricawo epeyuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","To bairo cabairi paʉ camaja catʉjʉ, tʉjʉnucujoyuparã. Na ʉparã quena rooro Jesure cʉ caĩ epeyuparã: —Aperãre cacatiowĩ. Yucʉra cʉ majuuna cʉ catioato Dio cʉ cajooricʉ majuu cʉ cãmata, cʉ caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Polisía quena to bairona cʉ ĩ eperi, cʉ tʉpʉ eja, ʉje oco camucurijere cʉ tĩa, ocõo bairo cʉ caĩ epeyuparã: —Mʉa judío maja Ʉpaʉ mʉ cãmata mʉ majuuna catioya, cʉ caĩ epeyuparã na quena Jesure. ");
INSERT INTO tav_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","To bairi cʉ na capapua turica pãipʉre cʉ rʉpoa buire uca turica pãi catujayupe, “Ani judío maja Ʉpaʉ ãmi,” ĩrique. ");
INSERT INTO tav_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jĩcaʉ carooʉ Jesu mena na capapuaricʉ quena rooro cʉ caĩ punijiniñupʉ Jesure: —Mʉa Dio tʉpʉ cãnacʉ cʉ cajooricʉ majuu yʉ ã ĩri, mʉ majuuna catiori, jã quenare jã catioya. ");
INSERT INTO tav_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","To bairo cʉ caĩro apii apei cʉ bapa maca ocõo bairo cʉ caĩ tutiyupʉ: —¿Nope ĩi mʉa Diore mʉ nʉcʉbʉgoquẽeti, mʉ quenare na cajĩarije to nibao joroquena? ");
INSERT INTO tav_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mari maca mari cátaje wapa cariape marire áama. Cʉ maca caroorije cátiquẽcʉ cʉ nibao joroquena cʉ áama. ");
INSERT INTO tav_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","To bairo cʉ yaʉre cʉ ĩ, ocõo bairo Jesu macare cʉ caĩñupʉ: —Yʉ Ʉpaʉ, mʉ caroti ejari paʉ cãnopʉ yʉ mʉ tʉgooña majiwã. ");
INSERT INTO tav_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","To bairo cʉ caĩro: —Ati rʉmʉna yʉ mena mʉ anigʉ cañuu majuucõari paʉpʉ, Dio tʉpʉ, cariape mʉ yʉ ĩ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jesure na cajĩari paʉ majuu pajaribota cãno nipetiropʉ canaitĩacoajupe yua. Ñamicaa maca muipʉ cʉ cãni rui aáto las tres cãno majuu cabujucoajupe moquena, itia hora beropʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Muipʉ cʉ cabujuqueti aáti paʉna Dio wii pupeapʉ macá arʉare na cayo matarica ajero juti ajero cawoocoa aájupe carecomacai, to majuuna. ");
INSERT INTO tav_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","To bairo cabairi paʉna Jesu caĩ pi awajayupʉ cʉ Pacʉre: —¡Caacʉ, mʉ tʉpʉ yʉ catiriquere joʉ yʉ áa! To bairo ĩi, cabai yajicoajupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Polisía maja ʉpaʉ maca to bairo cabairijere tʉjʉʉ Diore cʉ nʉcʉbʉgori ocõo bairo caĩñupʉ: —Ania cariape cabai buicʉtacʉ me ãñupi, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Camaja pato catʉjʉrã ejaricarã to bairo Jesu cʉ cabai yajirijere tʉjʉrã seeto catʉjʉ jʉtiriti tʉgooñarique paicõa tunu aájuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesu mena cãnibatana, Galilea macana romiri cʉ̃re caʉjabatana quena yoabʉjaroacãpʉ tie cabairijere catʉjʉcõa tʉjʉnucuñuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jesure na cajĩari paʉre José cawamecʉcʉ, cañuʉ tona cãñupʉ. Cʉ̃a Judea yepapʉre Arimatea cawamecʉti maca macacʉ cãñupʉ. Cabʉcʉrã rotiri maja mena macacʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Na mena macacʉ nibaopʉcʉna Jesure cʉ na cajĩarijere cabooquetibajupʉ. Dio joogʉmi ati yepapʉre Ʉpaʉ cãnipaʉ majuure caĩ tʉgooña yuʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","To bairi Jesu cʉ cabai yajiro tʉjʉʉ José Pilato tʉpʉ Jesu rupaʉ ãnatore ne ruiogʉ cʉ cajenii aájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cʉ jeniri bero yucʉ tẽorica pãipʉ na capapua turicʉre cʉ cane ruioyupʉ. Cʉ ne ruio yaparo caroa jutii cabotirije mena cʉ caumáñupʉ. Cʉ umá, ʉ̃ta toti na cayejea we quenoorica totipʉ camaja cayaaya mani totipʉ cacũñupʉ Jesu rupaʉ ãnatore yua. ");
INSERT INTO tav_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Judío maja na cayerijãnucuri rʉmʉ jʉgoye macá rʉmʉ canaiori paʉ jʉgoyeacã cãñupe. ");
INSERT INTO tav_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","To bairi Galileapʉ Jesu mena cáatána romiri quena ti totipʉre aáti, Jesu rupaʉre na capeoro caroaro catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tʉjʉ, catunucoajuparã. Tunu ejarã na wiiripʉ, caroa cajʉti ñuurije mena Jesu rupaʉre na cawarepere caquenooñuparã. Quenoo yaparo yerijãrica rʉmʉ cãno cayerijãñuparã. To bairo bairã judío maja na caroti jʉgoricarore bairona cabaiyuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ape semana judío maja na paa jʉgorica rʉmʉ cabujuri paʉacã cãno cãromia Jesure na cayaarica paʉpʉ cáaájuparã. Caroa cajʉti ñuurijere na caquenooriquere jee aána cájuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ti paʉpʉ ejarã ʉ̃taa ti opere na cacũ bipebataca ne wooricaro cãno catʉjʉyuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne wooricaro cãno tʉjʉrã caneto jãabajuparã, Jesu rupaʉ ãnatore na capeorica paʉpʉre tʉjʉrã aána. Topʉ na capeoricaropʉre na catʉjʉata mari Ʉpaʉ Jesu rupaʉ ãnato camañupe. ");
INSERT INTO tav_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cʉ rupaʉ camano tʉjʉrã, “¿Dope bairo to baiyupari?” caĩ tʉgooñañuparã. To bairo na caĩ tʉgooñari paʉna caʉmʉa pʉgarã seeto caaji baterijere cajañarã na tʉpʉ cabuia ejanʉcañuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nare na cabuia ejanʉcarona catʉjʉ acʉacoajuparã na romiri. Tʉjʉ acʉabana, uwirique mena camubia re cumucoajuparã. To bairo na catʉjʉ acʉaro tʉjʉrã ocõo bairo na caĩñuparã cajutii aji baterã: —¿Nope ĩrã cacatiirena cabai yajiricarãre na cacũri paʉpʉre cʉ mʉja macarã ejati? ");
INSERT INTO tav_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maami atore. Mere tunu catícoami. Tʉgooñaña Galileapʉ ãcʉ mʉjaare cʉ caĩriquere. ");
INSERT INTO tav_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ocõo bairo caĩwĩ mʉjaare: “Yʉre joogarãma caroorãre. Caroorã yucʉ tẽorica pãipʉre yʉ papua jĩagarãma. Yʉre na cajĩaro, itia rʉmʉ bero yʉ tunu catigʉ moquena.” Atie cʉ caĩriquere tʉgooñaña, na caĩ buioyuparã caaji baterijere cajañarã. ");
INSERT INTO tav_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","To bairo na caĩrijere apirã Jesu na mena ãcʉpʉ na cʉ caĩriquere catʉgooña bʉgayuparã yua. ");
INSERT INTO tav_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tʉgooña bʉga, Jesu rupaʉ ãnatore na cacũ rocarica paʉre catʉjʉra ejabatana catunucoajuparã. Tunu aá, nipetiro cabairije na catʉjʉriquere na cabuioyuparã Jesu cʉ cabuericarãre once cãnacãʉre, aperã na mena macana quenare. ");
INSERT INTO tav_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tie quetire nare cabuioricarã ato cãnacão cãñuparã: María Magdalena, Juana, apeo María Jacobo paco. To bairi aperã romiri quena cãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","To bairo na caĩro apirã, “Jocarã mʉja ĩ,” na caboca ĩñuparã, to bairo na caĩrijere api nʉcʉbʉgoquẽna. ");
INSERT INTO tav_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","To bairo na caĩrijere caapi nʉcʉbʉgoquẽcʉ nibaopʉcʉna Pedro maca Jesure cʉ na cacũ rocaricaropʉre atʉ aá, ti toti pupeapʉre camubia tʉjʉ jõoñañupʉ. Topʉre cʉ catʉjʉ jõoñaata Jesure, cʉ na caumábata ajero jutiiro jetore catʉjʉyupʉ. Tie jetore tʉjʉ, catunucoajupʉ. “¿Dope bairo to baibauyupari?” caĩ tʉgooñacõa tunu aájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti rʉmʉna Jesu cʉ cabuericarã mena macana pʉgarã cáaájuparã Emaú na caĩri macapʉ. Jerusalẽpʉi aácʉ pʉga hora aátato cõo yoaro cãñupe ti wã. ");
INSERT INTO tav_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ti wãpʉ aána nipetiro Jerusalén macana Jesure na cátajere caame wadapeni aájuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","To bairo Jesure na caame ĩ wadapeni aáti paʉna cʉna na tʉpʉ eja, na mena cáaájupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na mena cʉ cáaáto, “Jesu ãcʉmi,” caĩ majiquẽjuparã, cʉ tʉjʉbaopʉnana. ");
INSERT INTO tav_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","To bairo na cabairo: —¿Ñeere mʉja ame wadapeni aápari? na caĩ jeniñañupʉ Jesu. Na maca seeto tʉgooñarique pairã cãñuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ocõo bairo cʉ caĩñupʉ Cleopas cawamecʉcʉ: —¿Mʉ jetona cáaáteñaʉ Jerusalẽpʉ cabaiyaejere camajiquẽcʉ mʉ ãti? cʉ caĩ jeniñañupʉ Cleopas. ");
INSERT INTO tav_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","To bairo cʉ caĩro: —¿Dope bairo cabaiyaejere mʉ ĩti? cʉ caĩñupʉ Jesu. —Jesu Nasaré macacʉre na cátiyaejere, cʉ caĩñuparã na maca. —Cʉ̃a Dio ye quetire cabuio majii, caroa macajere cáti iñoʉ, catutuaʉ majuu Dio cʉ caĩ tʉjʉʉ niiñabami. Camaja quena, “Catutuaʉ majuu ãmi,” cʉ caĩ tʉgooñabama. ");
INSERT INTO tav_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yucʉra sacerdote maja ʉparã, aperã jã ʉparã mena, Jesure cʉ na papua jĩaato ĩrã cʉ jooyawã romano maja yarã na polisíare. ");
INSERT INTO tav_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Cʉ̃a Israel macanare mari wapanare marire camatabojaʉ anigʉmi,” jã caĩ tʉgooñabapʉ. Mere itia rʉmʉ neto cʉ na cajĩaeto bero. ");
INSERT INTO tav_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","To bairo to baibao joroquena, jã mena macana romiri acʉori wame jã buiowã cʉ na cacũ rocaricaropʉ cabujuri paʉpʉ catʉjʉra aábatana. ");
INSERT INTO tav_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","“Cʉ rupaʉ ãnatore jã tʉjʉquẽpʉ, Dio tʉ macana jetore na jã tʉjʉwʉ,” jã ĩwã. “ ‘Mere Jesu catícoami moquena,’ jã ĩwã Dio tʉ macana,” jã ĩ buiowã cãromia. ");
INSERT INTO tav_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","To bairo na caĩro bero jã mena macana jĩcaarã cʉ na cacũ rocarica paʉpʉre tʉjʉra aána cãromia na cabuioetore bairona tʉjʉyuparã na quena. Jesu rupaʉ ãnatore bʉgaquẽjuparã, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","To bairo na caĩro apii: —Camajiquẽna mʉja ã. Dio ye quetire buiori maja ãnana na caucariquere mʉja apipajee nʉcʉbʉgoquẽe. ");
INSERT INTO tav_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dio cʉ cajooricʉ majuu cʉ̃re capopiye tamʉo jʉgope cãmʉ Ʉpaʉ cʉ cãniparo jʉgoye. ¿Tiere mʉja majiquẽeti? na caĩñupʉ Jesu cʉ̃re na catʉjʉ majiquẽtie to nibao joroquena. ");
INSERT INTO tav_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","To bairi Cristo cʉ cabaipere Moisé tirʉmʉpʉ macacʉ cʉ caĩ ucarique, aperã nipetiro Dio ye quetire cabuioricarã na caĩ ucariquere na caĩ buioyupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na cáaáta macare coña aána cabaiyuparã yua. Jesu maca na jʉgoyepʉ neto aágʉ cabaibajupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","To bairi: —Neto aáqueticõaña. Atona jã mena tuaya. Mere ñamicaapʉ ã, cʉ caĩñuparã. To bairo seeto cʉ na caĩro apii Jesu na mena na cãni wiipʉre cajãa aájupʉ, na mena tuagʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jãa eja, na mena ʉgarica cajawa tʉpʉre rui, pãre ne, Diore, “Ñuubʉja,” cʉ ĩ, ti rupaare na cape bate nuniñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na cʉ cape bate nuniri paʉna to cõona, “Jesuna ãmi,” cʉ caĩ tʉjʉ majicõañuparã. To cõona Jesu cabauqueticõa atʉ aájupʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cʉ cabairo bero: —Mapʉ marire cʉ cabuioro, “Ocõo bairo ĩgaro ĩ Dio ye queti ucarica pũuri,” marire cʉ cabuioro mari yeripʉ caroaro mari catʉgooña wariñuuwʉ marire cʉ cabuiorijere apirã, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","To bairo ame ĩ, nemoopʉre wamʉnʉca, Jerusalẽpʉ catunucoajuparã. Jerusalẽpʉ tunu aá, Jesu cʉ cabuericarã once cãnacãʉ aperã na yarã mena na caneñaporo na cabʉga ejayuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Topʉ caneñaporã maca ocõo bairo na caĩ buioyuparã Emaúpʉ cáatánare: —Mari Ʉpaʉ Jesu catimi, jocarã mee jã ĩ. Simón Pedro cʉ tʉjʉyupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","To bairo na caĩro apirã na quena mapʉ na cáaáto na cʉ cabuia ejariquere na caĩ buioyuparã: —Cabero jãre pan cʉ cajʉgo pe bate ʉgari paʉna to cõona cʉ̃re jã tʉjʉ majiwʉ, na cabuioyuparã na quena. ");
INSERT INTO tav_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tiere na caame buiori paʉna Jesu maca na watoapʉ cabuia ejanʉcañupʉ. Buia ejanʉca, na ñuu roti, “Caroa wariñuurique mʉjaare to ãmaro,” na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","To bairo cʉ caĩro seeto catʉjʉ acʉacoajuparã. “¡Abʉ! Cabai yajiricʉ ãnacʉ wãti ãcʉmi,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","To bairi Jesu na caĩñupʉ: —¿Nope ĩrã yʉ mʉja uwiti? ¿Nope ĩrã cariape mʉja tʉgooñaquẽeti? ");
INSERT INTO tav_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tʉjʉya yʉ wamorire, yʉ rʉporire. Yʉna yʉ ã. Yʉ pañarã ajá. Cabai yajiricʉ ãnacʉ wãti maca ri mácʉmi. Õwaa mácʉmi. Yʉa yʉ ani peticõa, tʉjʉya, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","To bairo na ĩ, cʉ wamorire, cʉ rʉporire na caiñooñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","To bairi seeto wariñuurica wame na to nibao joroquena catʉjʉ nʉcʉbʉgoquẽjuparã mai. To bairo na cabairo: —¿Ʉgarique to nicʉti? na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","To bairo cʉ caĩro wai ãjʉricʉ rʉca jĩca rʉca cʉ cajooyuparã. ");
INSERT INTO tav_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na cajoori rʉcare boca ne, caʉgayupʉ Jesu na catʉjʉro. ");
INSERT INTO tav_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ʉga yaparo ocõo bairo na caĩñupʉ Jesu yua: —Nipetiro yʉre cabaiejere cajʉgoyepʉ mʉja mena ãcʉ mʉñʉja cabuiobapʉ. Nipetiri wame Moisé yʉre cʉ caĩ ucarique, aperã Dio ye quetire buiori maja ãnana yʉre na caĩ ucarique, to bairo quena Salmo na caĩri pũuropʉ yʉre na caĩ ucariquere bairona yʉre baiwʉ. Yʉre na caĩ ucarique cõona aáto baiwʉ, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","To bairo na ĩ, na cabuioyupʉ Jesu Dio ye queti ucarica pũuripʉ caĩrijere, tiere caroaro na majiato ĩi. ");
INSERT INTO tav_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Ocõo bairo ĩ ucarique cãmʉ yʉre: “Dio cʉ cajooricʉ majuu jĩa ecoogʉmi. Cʉ cabai yajiro itia rʉmʉ bero tunu catigʉmi moquena. ");
INSERT INTO tav_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","To bairi cʉ carotiroi atie caroa quetire cabuio majiope ã aperã nipetiropʉ macanare. Jerusalẽpʉi tiere cabuio jʉgope ã, cabero nipetiro macanare cabuiope anigaro. Na buiorã ocõo bairo na ĩ buiogarãma: ‘Caroorije mʉja cátajere mʉja catʉgooñarique pai jʉtiritiata mʉja majiritiogʉmi Dio,’ ĩ buiogarãma,” caĩ ucayupa na ãnana, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Mʉjaana to bairo yʉre cabairijere catʉjʉrã aniri, “Cariapena ã. To bairona cabaiwʉ,” mʉja ĩ maji. ");
INSERT INTO tav_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mʉjaare yʉ joogʉ yʉ Pacʉ cʉ caĩ majio cũricarore bairona mʉja mena cãnipaʉre, Dio Espíritu Santore. Jerusalẽpʉ yuuya mai. Espíritu Santo rui ejaʉ tutuariquere mʉja joogʉmi. Mʉjaare cʉ cajooro beropʉ mʉja buio teñara aágarã yua, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cabero Jesu na cajʉgo aájupʉ Jerusalén maca jʉgoye Betaniapʉ cáaáti wãpʉ. Topʉ ejaʉ, cʉ wamorire ñu mʉgo: —Yʉ Pacʉ caroaro mʉjaare cʉ átibojaato, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","To bairo ĩina na cawamʉ ame pea weocoajupʉ ʉmʉrecoopʉ yua. ");
INSERT INTO tav_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Cʉ cawamʉ aáto seeto cʉ cáti nʉcʉbʉgoyuparã. Cʉ áti nʉcʉbʉgo yaparo Jerusalẽpʉ catunucoajuparã, seeto wariñuurique mena yua. ");
INSERT INTO tav_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cabero Dio wiipʉ Diore caĩ wariñuucõa aninucuñuparã. To cõona ã.");
INSERT INTO tav_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nemoopʉna cãnitʉgayupi Dio Macʉ, Dio Ye Quetire Cabuioʉ Majuu cawamecʉcʉ. Ati yepare Dio cʉ cátiparo jʉgoye cãnitʉgayupi. Dio mena cãñupi Dio Ye Quetire Cabuioʉ Majuu cawamecʉcʉ. Cʉ quena Diona cãñupi. ");
INSERT INTO tav_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nemoopʉna Dio mena cãnicõañupi. ");
INSERT INTO tav_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dio cʉ Macʉ mena nipetirijere cájupi. Ati yepapʉre nipetirije cʉ mena cʉ cátaje jeto ã. Dio Ye Quetire Cabuioʉ Majuu cawamecʉcʉ cʉ camamata ati yepa macaje maniboro. ");
INSERT INTO tav_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Catiriquere cajoʉ ãmi Dio Macʉ. To bairo aniri ati yepa macanare na cajĩa bujubojaʉre bairo ãmi Dio Macʉ, cariape macajere camajare na iñoʉ. Cariape macaje na majiato ĩi to bairo cabaiwĩ Dio Macʉ, Dio Ye Quetire Cabuioʉ Majuu cawamecʉcʉ maca. ");
INSERT INTO tav_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Atie jĩa bujuriquere bairije ã Dio ye quetire buiorique, canaitĩaropʉre bairo cãnare, Diore camajiquẽnare. Cʉ Pacʉ yere iñoogʉ caejayupi Dio Macʉ. To bairi canaitĩarije jĩa bujuriquere to cayaa majiquẽtore bairona neto majiquẽe caroorije átaje Dio ye quetire buiorique macare. ");
INSERT INTO tav_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dio cajooyupi Juan cawamecʉcʉre cʉ ye quetire cabuio jʉgoyeyepaʉre. ");
INSERT INTO tav_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dio Macʉ, ati yepa macanare cajĩa bujubojaʉre bairo cãcʉ majuu cʉ cáatípere cabuio jʉgoyeyeyupi Juan. Camaja Dio Macʉre na nʉcʉbʉgoato ĩi to bairo cabuio jʉgoyeyeyupi. ");
INSERT INTO tav_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ati yepa macanare cajĩa bujubojaʉre bairona cãcʉ majuu mee cãñupi. Cajĩa bujubojaʉre bairo cãcʉ majuu macare, Dio Macʉ majuu cʉ cáatípe macare cabuio jʉgoyeyei cãñupi Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ati yepa macana nipetirãre Dio ye quetire caroaro buioʉ acʉ́ caejayupi Dio Macʉ, cajĩa bujubojaʉre bairo cãcʉ majuu. ");
INSERT INTO tav_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dio Macʉ ati yepapʉ caejayupi, Dio cʉ cãniere iñoʉ acʉ́. Dio mena ati yepare cátacʉ cʉ cãnibato quena ati yepa macana maca cʉ̃re, “Cʉna ãmi,” cʉ caĩ tʉjʉ majiquẽma ati yepapʉ cʉ caejaro. ");
INSERT INTO tav_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cʉ cáta yepa macana tʉpʉ cʉ caejabato quena cʉ yarã cʉ cabooquẽma. ");
INSERT INTO tav_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jĩcaarã maca cʉ̃re canʉcʉbʉgowã. To bairo cʉ̃re na canʉcʉbʉgoro Dio punaa cʉ yarã majuu na cãni rotiwĩ, “Jã mena caroaro ãña,” cʉ̃re caĩrã macare. ");
INSERT INTO tav_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Camaja punaa cʉtajere bairo aniquẽema Dio punaa maca. Camaja na cátaje mena na caboorije mena punaa cʉtima. Dio punaa maca cʉ jʉgori jeto cʉ punaa cãna ãma. ");
INSERT INTO tav_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","To bairi Dio Macʉ, Dio Ye Quetire Cabuioʉ Majuu maca ati yepapʉ cabuiayupi. Camajocʉ macʉre bairona buiari, jã mena cãmi. Camajare camai netocõawĩ. Nipetirije cʉ cabuiorijere cariape jeto caĩwĩ. Cʉ cátaje quena cariape jeto cámí. Dio Macʉ majuu jĩcaʉna ãmi. To bairi cʉ Pacʉre bairona ãmi. To bairo caroaro majuu cʉ cãniere, cʉ catutuarije mena cʉ cátaje quenare jã catʉjʉwʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan maca Dio Macʉ ye quetire buioʉ ocõo bairo caĩwĩ: —Anina ãmi mʉjaare yʉ caĩ buioricʉ. Ocõo bairo yʉ caĩ buiowʉ: “Caberopʉ jĩcaʉ atígʉmi. Nemoopʉna cãnicõañupi. To bairi yʉ netoro cãni majuʉ ãmi. Cʉ rʉgaro cãcʉ majuu yʉ ã,” caĩwĩ Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mani nipetirãre camai tʉjʉ netoñupi Jesucristo. To bairi cañuu netorijere manire cajooyupi. ");
INSERT INTO tav_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisé tirʉmʉpʉ macacʉ Dio cʉ carotirijere cajooyupi. Jesucristo maca mani mai tʉjʉri caejayupi, cariape macaje buiori. ");
INSERT INTO tav_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jĩcaʉ maca Diore catʉjʉricʉ maami. Cʉ Macʉ jĩcaʉna cʉ mena cãninucuʉ maca cʉ Pacʉre mani camajiro cájupi. ");
INSERT INTO tav_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén macana judío maja sacerdote maja ʉparãre, aperã levita poa macanare Juan tʉpʉ cʉ jeniña rotirã na cajooyupa. To bairi na cajooricarã Juan tʉpʉ ejarã: —¿Ñamʉ majuu mʉ ãti mʉa? cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Cariapena na caĩ yʉwĩ Juan: —Yʉa Dio cʉ cajooricʉ anibacʉ quena cʉ cabejericʉ majuu mee yʉ ã. Cristo mee yʉ ã. ");
INSERT INTO tav_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","To bairo na cʉ caĩro cʉ caĩ jeniñanemowã: —¿To roque ñamʉ majuu mʉ ãti? ¿Tirʉmʉpʉ macacʉ Dio ye queti buiori majocʉ Elías cawamecʉcʉ catunu catiricʉ mee mʉ ãti? cʉ caĩ jeniñawã. —Yʉ aniquẽe, na caĩ yʉwĩ Juan. To bairo cʉ caĩro cʉ caĩ jeniñanemowã tunu: —¿Dio yere buiori majocʉ jĩcaʉ atígʉmi na caĩricʉ mee mʉ ãti? cʉ caĩ jeniñawã. —Yʉ aniquẽe, na caĩwĩ Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","To bairo cʉ caĩro apirã: —To roque ¿Ñamʉ ũcʉ majuu mʉ ãti? Jãre cajeniña jooricarãre mʉ cayʉrijere jã cabuio majiparore bairo jãre buioya. ¿Mʉ majuu ñamʉ yʉ ã mʉ tʉgooñati? cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","To bairo na caĩro ocõo bairo na caĩ yʉwĩ Juan: —Tirʉmʉpʉ macacʉ Dio ye quetire buio jʉgoyeyeri majocʉ Isaía cawamecʉcʉ ocõo bairo caĩñupi: “Jĩcaʉ cayucʉ manopʉ, camaja na cãniquẽtopʉ caawajanucu teñaʉ anigʉmi,” cʉ caĩricʉ yʉ ã. Ocõo bairo caĩñupi Isaía: “ ‘Mani Ʉpaʉ cʉ cáatíparo jʉgoye caroaro quenoo yuuya. Cariape cãni wã caroa wã mʉja cátore bairo quenoo yuuya mʉja yerire,’ caĩi anigʉmi,” caĩñupi Isaía. Cʉ caĩricarore bairona cabaii yʉ ã. ");
INSERT INTO tav_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juãre cajeniñaricarã fariseo maja mena cabuerã na cajooricarã cãma. ");
INSERT INTO tav_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ocõo bairo cʉ caĩ jeniñanemowã tunu: —Baiyupa, “Dio cʉ cabejericʉ Cristo mee yʉ ã,” mʉ ĩ. “Elías ãnacʉ catunu catiricʉ mee yʉ ã,” mʉ ĩ. “ ‘Jĩcaʉ Dio ye quetire buiori majocʉ majuu atígʉmi,’ na caĩricʉ mee yʉ ã,” mʉ ĩ. ¿Nope ĩi camajare na mʉ bautisati, “Na mee yʉ ã,” ĩbacʉ quena? cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","To bairo cʉ̃re na caĩ jeniñaro: —Yʉ bautisanucu oco mena. Apeĩ maca ãmi jĩcaʉ mʉja watoapʉre mʉja camajiquẽcʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Cʉ maca yʉ bero buio teñagʉmi. Yʉ bero anibacʉ quena yʉ netoro majuu cãcʉ ãmi. Cʉ paabojari majocʉre bairo cãcʉ maca yʉ ã. Cañuu netoʉ ãmi, na caĩwĩ Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tie to bairije cabaiwʉ Betábara cawamecʉtopʉ, Jordán cawamecʉti ya ape nʉgoa tʉ maca. Topʉ camajare cabautisawĩ Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cabero ape rʉmʉ maca cʉ tʉpʉ Jesu cʉ caejaro catʉjʉwĩ Juan. Cʉ̃re tʉjʉʉ ocõo bairo caĩwĩ topʉ cãnare: —¡Tʉjʉya! Cʉna ãmi Dio cʉ cajooricʉ. Oveja waibʉcʉ cawimaʉre na cajĩa joe buje mʉgoʉre bairo cãcʉ ãmi. Cajʉgoye macana judío maja na caroorijere rerã jã áa ĩrã oveja cawimaʉre jĩa, cajoe buje mʉgo joonucuñupa Diore. Tie na cátinucuriquere bairona ãmi ani. Cʉ̃a ati yepa macana nipetirã rooro na cátinucurijere majiriobojagʉmi. ");
INSERT INTO tav_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cajʉgoye mʉjaare buioʉ ocõo bairo mʉjaare yʉ caĩ buiowʉ: “Caberopʉ jĩcaʉ atígʉmi. Nemoopʉna cãnicõañupi. To bairi yʉ netoro cãcʉ ãmi,” yʉ caĩwʉ, caĩwĩ Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","—Cʉ tʉjʉʉ, “Cʉna ãmi,” cʉ yʉ caĩ majiquẽpʉ. Majiquetibacʉ quena Israel macana cʉ̃re na majiato ĩi oco mena na yʉ cabautisaʉ apʉ́. ");
INSERT INTO tav_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","’Cãnʉ Espíritu Santo buare bairo cabauʉ rui atí, ani Jesu buipʉ eja peawĩ. ");
INSERT INTO tav_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nemoo to bairo cabaiire yʉ majiquẽpʉ. To jʉgoyepʉ Dio oco mena yʉre cabautisa rotii ocõo bairo yʉ caĩwĩ: “Espíritu Santo rui atí, jĩcaʉ cʉ buire cʉ caeja pearo mʉ tʉjʉgʉ. To bairo cabairo tʉjʉʉ, ‘Camajare Espíritu Santore cajoʉ ãmi,’ mʉ ĩ majigʉ,” yʉ caĩwĩ Dio. ");
INSERT INTO tav_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Atie cajʉgoye Dio yʉre cʉ caĩricarore bairona cabairije tʉjʉʉ cʉ̃re yʉ tʉjʉ majiwʉ. To bairi mʉjaare yʉ buio. Cʉna ãmi Dio Macʉ, caĩ buiowĩ Juan camajare. ");
INSERT INTO tav_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cabero ape rʉmʉ cʉ cabautisanucuropʉna cãmi Juan tunu. Jã pʉgarã yʉ, André quena Juan buerã jã cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cʉ mena jã cãno Jesu jãre cʉ caneto aáto tʉjʉri ocõo bairo caĩwĩ Juan: —¡Tʉjʉya! Jĩina ãmi Dio cʉ cajooricʉ. Ati yepa macana rooro na cátiere carei atácʉ ãmi jĩia, caĩwĩ Juan. ");
INSERT INTO tav_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","To bairo cʉ caĩrijere apirã Jesu macare cʉ jã caʉjacoapʉ Juãre caʉjabatana yua. ");
INSERT INTO tav_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","To bairo jã cabairo Jesu jã caamojore tʉjʉwĩ cʉ bero jã caʉja aánare. —¿Ñeere boorã yʉre mʉja ʉja atí? jã caĩ jeniñawĩ. To bairo jãre cʉ caĩ jeniñaro: —¿Noopʉ mʉ cãni paʉ to ãti? cʉ̃re jã caĩ jeniña yʉwʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Adʉja. Mʉjaare yʉ iñoopa, jã caĩwĩ Jesu yua. To bairo cʉ caĩro cʉ mena jã cáaápʉ. Canaiori paʉ cãno topʉ cʉ mena jã cãni naiocoapʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yʉ mena Jesure caʉjaʉ Simón Pedro bai André cawamecʉcʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","To bairi cʉ jʉgocʉ Simóre nemoona camacaʉ aácoami André. Cʉ bʉgaʉ ocõo bairo cʉ caĩwĩ: —Mesíare jã bʉgawʉ. Mesía Cristo Dio cʉ cabejericʉ ati yepapʉre cʉ cajooricʉ ĩgaro ĩ. ");
INSERT INTO tav_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","André Simóre cʉ capii ejawĩ Jesu tʉpʉ. To bairi Jesu maca cʉ̃re tʉjʉri ocõo bairo cʉ caĩwĩ: —Simón mʉ ã, Jonás macʉ. Cabero Cefa mʉ wamecʉtigʉ. Cefa Pedro o, ʉ̃taa ĩgaro ĩ. ");
INSERT INTO tav_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cabero macá rʉmʉ maca Jesu Galileapʉ aágʉ cãmi. Topʉ cʉ cáaáparo jʉgoye Felipe cawamecʉcʉre bʉga ejari ocõo bairo cʉ caĩwĩ: —Jitá yʉ mena. ");
INSERT INTO tav_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe Betsaida cawamecʉti maca macacʉ cãmi. Pedro quena cʉ bai André mena ti maca macanana cãma. ");
INSERT INTO tav_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipere, “Jitá,” Jesu cʉ caĩro apiri Natanaere cʉ capii aámi. Natanael tʉpʉ ejaʉ ocõo bairo cʉ caĩwĩ: —Dio cʉ cajoʉre jã bʉgawʉ, Moisé cʉ caucarica pũuropʉ cʉ caucaricʉrena. Dio ye quetire buiori maja quena cʉ̃rena caĩ ucayupa. Jesuna ãmi na caucaricʉ, José macʉna Nasaré macacʉ, caĩwĩ Felipe. Nemoona, “José macʉ ãcʉmi,” caĩ tʉgooñabami Felipe. ");
INSERT INTO tav_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael maca cʉ caĩwĩ: ¿Mʉ catʉgooñaro Nasarépʉre caroarã na nicʉti? cʉ caĩwĩ. To bairo cʉ caĩro: —Jitá, mani tʉjʉto, cʉ caĩ yʉwĩ Felipe. ");
INSERT INTO tav_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Cabero Natanael cʉ cáató tʉjʉri ocõo bairo caĩwĩ Jesu: —Ani Israel macacʉ, caĩtorique mácʉ majuu ãmi. ");
INSERT INTO tav_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","To bairo Jesu cʉ caĩro apii ocõo bairo cʉ caĩ jeniñawĩ Natanael: —¿Dope bairi yʉ mʉ majiti? To bairo cʉ caĩ jeniñaro Jesu ocõo bairo cʉ caĩ yʉwĩ: —Felipe mʉre cʉ capiparo jʉgoye mʉ yʉ tʉjʉtʉgawʉ, higuera cawamecʉtii ẽoro mʉ cãno. ");
INSERT INTO tav_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","To bairo cʉ caĩro Natanael maca cʉ caĩwĩ: —Dio Macʉna mʉ ãcʉ mʉa. Israel macana Ʉpaʉ majuu mʉ ãcʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","To bairo cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —“Higuera yucʉ ẽoropʉ mʉ ãmʉ,” mʉ yʉ caĩrijere apii, “Dio Macʉna mʉ ãcʉ,” ¿yʉre mʉ ĩ nʉcʉbʉgoti? Caberopʉ atie netoro caroa áti iñoorica wamerire mʉ tʉjʉgʉ. ");
INSERT INTO tav_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Cariape mʉ yʉ ĩ. Caberopʉ ʉmʉrecoo capãro mʉja tʉjʉgarã. To bairo capãro yʉ tʉpʉ ángel maja rui atínucu, na cawamʉ aánucurijere mʉja tʉjʉgarã. Camaja tʉpʉ Dio cʉ cajooricʉ yʉ cãno maca to bairo yʉre mʉja tʉjʉgarã. ");
INSERT INTO tav_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Itia rʉmʉ Felipere, Natanaere Jesu cʉ capiricaro bero Galilea yepapʉ Caná cawamecʉti macapʉ jĩcaʉ to macacʉ cawamo jiawĩ. To bairi boje rʉmʉ cámá. Jesu paco quena cãmo ti boje rʉmʉ cãno. ");
INSERT INTO tav_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu quenare, jãre cʉ buerã quenare jã capiwã. ");
INSERT INTO tav_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Boje rʉmʉ na cáto na caetirije ʉje oco capeticoapʉ. Capetiro tʉjʉo ocõo bairo caĩwõ Jesu paco co Macʉ Jesure: —Macʉ, ʉje oco etirique peticoapʉ. ");
INSERT INTO tav_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","To bairo co caĩro ocõo bairo co caĩwĩ Jesu cʉ pacore: —Caaco, ¿nope ĩo yʉ mʉ buioti yʉ macare? Yʉ Pacʉ yʉre cʉ cacũrique yʉ áti rotiquẽemi mai, co caĩwĩ Jesu cʉ pacore. ");
INSERT INTO tav_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","To bairo cʉ caĩbato quena co maca ti wii macana catĩa coterãre ocõo bairo na caĩwõ: —Mʉjaare cʉ carotipe nipetiro caroaro ája. ");
INSERT INTO tav_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Topʉ seis jotʉri ʉ̃ta mena na cáta jotʉri cãmʉ. Judío maja caroorije jã cátajere rerã jã áa ĩ majiorã na caoco pio jãnucuri jotʉri cãmʉ. Veinte o treinta galones cõo cajañari rʉri capaca rʉri cãmʉ to cãnacã jotʉna. ");
INSERT INTO tav_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","To bairi Jesu ti wii macana catĩa coterãre ocõo bairo na caĩwĩ: —Atie jotʉrire oco pio jãña. To bairo na cʉ caĩrore bairona cámá. Capio jãwã ti rʉri caroaro jiraropʉ. ");
INSERT INTO tav_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","To bairo na cáti yaparoro ocõo bairo na caĩwĩ Jesu: —Petoacã waa ne aánaja boje rʉmʉ cajʉgo ácʉ tʉpʉ. “Jaʉ,” ĩrã cane aáma. ");
INSERT INTO tav_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti boje rʉmʉ cajʉgo ácʉ, “Jesu cʉ cajeñoorije ãno,” caĩ majiquẽmi. Topʉ catĩa coterã jeto oco cãnajere ʉje oco Jesu cʉ cajeñoorijere camajiwã. To bairi ti boje rʉmʉ cajʉgo ácʉ tiere etiñari cawamo jiaʉre cʉ pijo, ocõo bairo cʉ caĩwĩ: ");
INSERT INTO tav_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Nipetirã ʉje ocore catĩarã caroa macare tĩa jʉgonucuma. Ati maja cawatoa cãnie macare tĩa jʉgoyupa manire. Pairo etiricaro bero cawatoa macajere catĩa bui peope nibapa. Caroa macare mʉ tĩa jʉgo rotiquẽjupa mʉa, caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesu atiere Galilea cawamecʉtopʉ Caná cawamecʉti macapʉ cáti iñoowĩ. Tiere ácʉ topʉ nemoona cʉ cáti majirije mena cáti iñoo jʉgowĩ. Tiere cʉ cáto tʉjʉrã jã cʉ buerã, “Dio cʉ cajoʉna ãmi,” cʉ̃re jã caĩ nʉcʉbʉgowʉ. ");
INSERT INTO tav_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cabairo bero Jesu Capernaum cawamecʉti macapʉ cáaámi. Cʉ paco, cʉ bairã cʉ mena cáaáma. Jã quena cʉ buerã quena jã cáaápʉ. Ti macapʉre capee rʉmʉriacã mee jã cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judío maja na boje rʉmʉ pascua na caĩri rʉmʉ jʉgoyeacã Jerusalẽpʉ cáaámi Jesu. ");
INSERT INTO tav_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jerusalẽpʉ ejaʉ Dio wiipʉ cajãa aámi. Ti wiipʉre waibʉcʉrã joori cawapatarãre na catʉjʉwĩ. Wecʉare, ovejare, buaare camaja na cajĩa joe buje mʉgoparãre joori cawapatawã. Aperã quena topʉ caruiwã ape yepari macaje niyeru wajoari cawapatarã. ");
INSERT INTO tav_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","To bairo na cáto tʉjʉʉ Jesu yʉta miji wẽri mena caquenoowĩ baperica wẽre. Ti wẽ mena waibʉcʉrã cajoorãre na cabape acu buucõawĩ. Niyeru cawajoari maja na ye niyeru cuirire cama bate recõawĩ. Na ye cajawori quenare catu ne roca cũcõawĩ. ");
INSERT INTO tav_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Buaare cajoo wapatarãre ocõo bairo na caĩwĩ: —Ati majare na jee buti aánaja. Yʉ Pacʉ ya wiire apeye joorica wii átiqueticõaña. ");
INSERT INTO tav_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","To bairo cʉ cáto tʉjʉrã tirʉmʉpʉ macacʉ David, cʉ caucariquere jã catʉgooñawʉ. Ocõo bairo caucayupi David: “Dio, mʉ ya wiire yʉ mai neto.” ");
INSERT INTO tav_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judío maja ʉparã to bairo cajoo wapatarãre cʉ care buuro tʉjʉrã ocõo bairo cʉ caĩ jeniñawã: —¿Ñamʉ mʉre cʉ carotiro apeye ati wiipʉ cajoo wapata ánare na mʉ acu buuti? “Dio yʉ cʉ carotiro na yʉ acu buu,” mʉ caĩata cʉ camajirije mena tʉjʉ acʉarica wamere jã áti iñooña, caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","To bairo na caĩro ocõo bairo na caĩ yʉwĩ Jesu: —Ati wiire rocacõaña. Mʉja carocaro bero itia rʉmʉna yʉ áti quenoogʉ ati wiire tunu, na caĩ yʉwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","To bairo cʉ caĩro ʉparã cʉ caĩwã tunu: —Áti majiña maa. Ati wiire ána yoaro majuu cuarenta y seis cʉmari capaawã. ¿Mʉ maca itia rʉmʉna mʉ wajoa nʉco ocabʉtibocʉti mʉa? ");
INSERT INTO tav_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesu ti wiire ĩi, cʉ majuuna cʉ rupaʉ macare ĩ buio majioʉ caĩbami. ");
INSERT INTO tav_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cʉ̃re na cajĩaricaro bero catunu catiipʉ cʉ cãno cʉ buerã cʉ cabuioriquere jã catʉgooña majiwʉ. Tiere tʉgooñarã, “Cʉ cabuioriquere cariapena caĩñupi,” jã caĩ nʉcʉbʉgowʉ. To bairi Dio ye quetire cabuiori maja tirʉmʉpʉ macana Jesu cʉ cabaipere na cauca jʉgoyeyerique quenare, “Cariape caĩñupa,” jã caĩ nʉcʉbʉgowʉ yua. ");
INSERT INTO tav_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Capãarã Jerusalẽpʉ Pascua boje rʉmʉ cãno caneñaporicarã Dio cʉ camajirije mena Jesu cʉ cáti iñoorijere tʉjʉrã, “Dio cʉ cajooricʉ ãcʉmi,” cʉ caĩ tʉgooña nʉcʉbʉgowã Jesure yua. ");
INSERT INTO tav_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Na catʉgooñarijere catʉjʉ maji peocõawĩ Jesu. To bairi, “Yʉre caapiʉjarã ãma,” caĩquẽmi. ");
INSERT INTO tav_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aperã cʉ na cabuioquetibato quena cʉ majuu na catʉgooñarijere camaji peocõawĩ. ");
INSERT INTO tav_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jĩcaʉ fariseo na caĩrã mena macacʉ Nicodemo cawamecʉcʉ cãmi. Cʉ quena judío majare carotirã mena macacʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","To bairi jĩca ñami Jesure jeniñagʉ cʉ tʉpʉ caejawĩ. Ejaʉ ocõo bairo cʉ caĩwĩ Jesure: —Mʉ mena ãcʉmi Dio. To bairi apeyere mʉ áti iñoo majii cʉ tutuarique jʉgori. Mʉ cáti iñoonucurijere tʉjʉrã, “Camajare cʉ buioato ĩi mʉre cajooyupi Dio,” jã ĩ maji, caĩwĩ Nicodemo Jesure. ");
INSERT INTO tav_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","To bairo cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Cariapena mʉ yʉ ĩ. Noo cãcʉ nemoopʉ cʉ cabuia jʉgoricarore bairona cʉ cabuianemoquẽpata Ʉpaʉ Dio cʉ cãnopʉ aá majiquetigʉmi, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","To bairo cʉ caĩro Nicodemo cʉ caĩ jeniñawĩ: —Mani cabʉcʉaro bero dope bairo mani paco ya paropʉ mani buianemo majiquẽna. Mani pacopʉre mani buia bapoo majiquẽna, Jesure cʉ caĩwĩ Nicodemo. ");
INSERT INTO tav_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—Cariapena mʉ yʉ ĩgʉ, cʉ caĩwĩ Jesu. —Noo cãcʉ ũcʉ Ʉpaʉ Dio cʉ cãnopʉ aágʉ Espíritu Santo mena, oco mena cabuianemope ã. To bairo cabuianemoquetacʉ maca Ʉpaʉ Dio cʉ cãnopʉ aá majiquetigʉmi. ");
INSERT INTO tav_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Camaja na capunaacʉna na punaana ãma. Dio punaa maca ãma Espíritu Santo napʉre cʉ cãni ejarije jʉgori yua. ");
INSERT INTO tav_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","To bairi camaja nemoopʉ na cabuia jʉgoricarore bairona cabuianemope ã yʉ caĩrijere apii tʉgooña mawijiaqueticõaña. ");
INSERT INTO tav_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Espíritu Santo camajapʉre cʉ cãni ejarijere mʉ yʉ buio, cabuianemope ã mʉre ĩ buioʉ. Espíritu Santo mena cabuiarã nipetirã winore bairona ãma. Na yeri macajere mani tʉjʉquẽe. Wino quenare mani catʉjʉquẽtie noo cabooro bʉjʉ papu tuuro. ¿Noo macaje to ajupari? mani ĩ majiquẽe. Topʉ aáto áa mani ĩ majiquẽe tie quenare, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","To bairo cʉ caĩro Nicodemo cʉ caĩ jeniñawĩ tunu: —¿Dope bairo Espíritu Santo mena buiarique to anicʉti? ");
INSERT INTO tav_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ocõo bairo cʉ caĩ yʉwĩ Jesu: —¿Israel macanare Dio yere cabuei anibacʉ quena tiere mʉ majiquẽeti? ");
INSERT INTO tav_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cariapena mʉ yʉ ĩgʉ. Yʉ, yʉ Pacʉ Dio mena jã camajirijere, jã catʉjʉriquere mʉjaare jã cabuiobapʉ. Mʉja apiʉjaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ati yepa macajere yʉ cabuioro mʉja api nʉcʉbʉgoquẽe. To bairi ʉmʉrecoo macaje Dio yere yʉ cabuioata roquere yʉre mʉja api nʉcʉbʉgoqueti majuucõaborã. ");
INSERT INTO tav_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Jĩcaʉ maca camajocʉ ʉmʉrecoopʉre cawamʉñaʉ aátacʉ maami. Yʉa jĩcaʉna ʉmʉrecoopʉ cãnacʉ yʉ carui apʉ́. Yʉa camaja tʉpʉ Dio cʉ cajooricʉ ʉmʉrecoopʉ cãnacʉ majuu yʉ ã. To bairi ʉmʉrecoo macaje Dio yere yʉ maji. ");
INSERT INTO tav_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","’Tirʉmʉpʉ yucʉ camanopʉ Moisé añare bairo cabauʉ cʉ cawericʉre yucʉpʉ cʉ canʉcoñupi. Moisé aña cʉ cawericʉre cʉ cátatore bairona camaja yucʉpʉ yʉ nʉcogarãma yʉ quenare. ");
INSERT INTO tav_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","To bairi nipetirã yʉre caapi nʉcʉbʉgorã caroorã ya paʉpʉ aáquetigarãma. Anicõa aninucugarãma Dio tʉpʉre, caĩwĩ Jesu Nicodemore yua. ");
INSERT INTO tav_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dio ati yepa macanare seeto maii cʉ Macʉ jĩcaʉna cãcʉre cʉ cajooyupi. To bairo cʉ cáto noa una cʉ Macʉre canʉcʉbʉgorã yajiquetigarãma popiye tamʉorica paʉpʉre. Cʉ mena anicõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dio ati yepa macanare cʉ popiyeyeato ĩi mee cajooyupi cʉ Macʉre. Nare yʉ netoogʉ ĩi cʉ cajooyupi Dio cʉ Macʉre ati yepapʉre. ");
INSERT INTO tav_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Cʉ Macʉre canʉcʉbʉgorãre na popiyeyequetigʉmi Dio. Cʉ Macʉ jĩcaʉna cãcʉre canʉcʉbʉgoquẽna macare, “Yʉ capopiyeyeparã ãma,” caĩtʉgayupi Dio mere. ");
INSERT INTO tav_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cʉ̃re canʉcʉbʉgoquẽna cʉ capopiyeyeparã anitʉgama. Ocõo bairo ã: Jesucristo jĩa bujuricarore bairo cãcʉ cʉ cáató cʉ cabooquẽjupa camaja. Rooro átaje macare boo netobana canaitĩaropʉ cãnare bairo catuayupa. ");
INSERT INTO tav_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nipetirã caroorije cána Dio Macʉ mena anigaquẽema, caroorije jã cátinucurijere tʉjooquẽcʉmi ĩrã. Cʉ mena macana anigaquẽema, caroorije na cátinucurijere mairã. ");
INSERT INTO tav_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dio cʉ cabooro caroaro cána maca cʉ mena macana anigama, na cátinucurije cayajioquẽna aniri. Dio cʉ catʉjoorije macare cána aniri boboquẽema. To bairi baujaro átinucuma. ");
INSERT INTO tav_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nicodemo Jesu mena cʉ cawadapeniro bero Judea cawamecʉtopʉ cʉ buerãre jã cajʉgo aámi Jesu. Topʉre camajare jã cabautisawʉ. Yoabʉjaroacã jã cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Juan, bautisari majocʉre presopʉ cʉ na cajooparo jʉgoye cʉ quena bautisaʉ cámí Salim cawamecʉto, Enón cawamecʉti majuuri paʉpʉ. Topʉ pairo oco cãmʉ. To bairi camaja cʉ tʉpʉ bautisa rotira anaa caejawã Juan tʉpʉ. ");
INSERT INTO tav_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","To bairo cʉ cabautisa ani paʉ jĩca rʉmʉ Juan cʉ cabuiorijere caapiʉjarã aperã judío maja yere cátinucurã mena caame wada netowã. Caroorije jã cátaje coje rerã jã áa ĩrã na cátinucurije unie caame ĩ wada netowã. ");
INSERT INTO tav_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","To bairo cabairo bero Juan buerã ocõo bairo cʉ caĩwã: —Jãre cabuei, tirʉmʉbʉjaacã Jordán i nʉgoapʉ mʉ mena jĩcaʉ, jãre mʉ cabuioricʉ yucʉra cʉ buerã camajare na bautisarã áama na quena. Nipetirã cʉ ʉjanucuma cʉ̃re, cʉ caĩwã Juãre, Jesu cʉ cãniere cʉ ĩ buiorã. ");
INSERT INTO tav_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","To bairo na caĩro ocõo bairo na caĩ yʉwĩ Juan: —Dio cʉ carotiquẽpata camaja cʉ ʉjaquetiborãma. ");
INSERT INTO tav_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mʉjaare yʉ cabuioriquere mʉja caapitʉgawʉ. “Yʉa Dio cʉ cabejericʉ Cristo mee yʉ ã,” mʉjaare yʉ caĩwʉ. Cʉ jʉgoye cʉ cajoo jʉgoricʉ yʉ ã yʉa. ");
INSERT INTO tav_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ocõo bairo maca ã: Jĩcaʉ cʉ nʉmore cʉ canero cʉ yao majuu ãcomo. Cʉ mena macacʉ cõre cʉ canero tʉjʉʉ wariñuunemoʉmi. Jesu jĩcaʉ canʉmo nericʉre bairona ãmi. Camaja cʉ̃re caʉjarã cʉ nʉmo cʉ canericore bairona ãma. To bairi yʉ, cʉ mena macacʉ camaja cʉ̃re na caʉjaro tʉjʉʉ yʉ wariñuunemo. ");
INSERT INTO tav_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cʉ maca yʉ netoro cãcʉ ani nutuagʉmi Jesu. Yʉ maca cawatoa macacʉ yʉ anicõagʉ, caĩwĩ Juan cʉ buerãre. ");
INSERT INTO tav_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesu ʉmʉrecoopʉ cáatácʉ nipetirã netoro ãmi. Ati yepa macana ati yepa macajere buioma. ");
INSERT INTO tav_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ʉmʉrecoopʉ cáatácʉ maca nipetirã netoro cãcʉ ãmi. Ʉmʉrecoopʉ cʉ catʉjʉriquere, cʉ caapirique quenare buiomi. Cariape cʉ cabuiorije to cãnibato quena cʉ apiʉjaquẽema camaja. ");
INSERT INTO tav_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jĩcaarã cʉ̃re caapiʉjarã ãma bairã pʉa. To bairi cʉ̃re caapiʉjarã aniri, “Cariape buiomi,” ĩ majima. ");
INSERT INTO tav_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jesucristo Dio cʉ cajooricʉ aniri Dio cʉ cabuio rotirijere cabuioʉ ãmi. Dio cʉ Espíritu Santore tutuaro cʉ̃re cʉ cajooro to bairo áami. ");
INSERT INTO tav_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cʉ Macʉre mairi, “Nipetirijere carotii mʉ anicõagʉ,” cʉ caĩñupi Dio. ");
INSERT INTO tav_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cʉ Macʉre canʉcʉbʉgorã catícõa aninucugarãma. Cʉ̃re canʉcʉbʉgoquẽna maca catícõa aniquetigarãma. Seeto na popiyeyegʉmi Dio to bairo cʉ Macʉre canʉcʉbʉgoquẽnare. ");
INSERT INTO tav_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Capãarã camaja Jesure caʉjawã. Juan cabautisari majocʉ netoro Jesu buerã maca camajare jã cabautisawʉ. Jesu cʉ majuu na cabautisaquẽmi. Capãarã cʉ̃re na caʉjarijere, na cʉ cabautisarijere caqueti apiyupa fariseo maja. Tie quetire apiyuparã ĩi, cáaácoami Jesu Judeapʉ cãnacʉ Galileapʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Topʉ aácʉ Samaria yepapʉ caneto aámi. ");
INSERT INTO tav_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ti yepapʉre Sicar cawamecʉti macapʉ caejawĩ. Ti maca tʉpʉ Jacobo tirʉmʉpʉ macacʉ cʉ macʉ Josére cʉ cajoorica yepa cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Topʉ oco waarica ope Jacobo cʉ cayejearica ope cãmʉ. Jesu topʉ neto aácʉ caniñacoami. To bairi paaribota cãno ti ope tʉpʉ cayerijã ejawĩ. ");
INSERT INTO tav_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Topʉ cʉ caruiri paʉ ʉgariquere wapayera aána macapʉ jã cáaápʉ. Jã cawapayera aáto jĩcao cãromio Samaria macaco oco wao acó caejayupo ti opepʉre. Topʉ co caejaro tʉjʉʉ: —Oco yʉ tĩaña, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Co maca ocõo bairo cʉ caĩñupo: —¿Nope ĩi mʉa Judío majocʉ anibacʉ quena yʉre Samaria macacore yʉre mʉ oco jeniti? cʉ caĩñupo. Ti yʉteapʉre judío maja Samaria macana mena caame tʉjʉ teebʉjanucuwã. Tie jʉgori to bairo cʉ caĩñupo Jesure. ");
INSERT INTO tav_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","To bairi Jesu co caĩñupʉ: —Dio camajare cʉ cajoorijere mʉ majiquẽe mʉa, co caĩñupʉ Jesu. —Yʉ quenare mʉ majiquẽe. Yʉre mʉ camajiata roquere yʉ macare ocore yʉre mʉ jeniborico. Tiere yʉre mʉ cajeniata yʉ maca cacaticõa aninucupere cajoorije ocore mʉre yʉ jooboricʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","To bairo cʉ caĩro co maca cʉ caĩnemoñupo tunu: —¿Ñee mena ocore mʉ waa nebocʉti? Ati ope pupeapʉ majuu anicõa. ¿Noopʉ cacaticõa aninucupere cajoorije ocore mʉ bʉgabocʉti mʉa? ");
INSERT INTO tav_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mani ñicʉ Jacobo ati ope macajere caetinucuñañupi. Cʉ punaa, cʉ yarã cʉ nuricarã quena caetinucuñañupa. Ati opere manire cacũñupi cʉ̃a. ¿Mʉ maca cʉ netoro cãcʉ mʉ ãti? cʉ caĩñupo. ");
INSERT INTO tav_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ocõo bairo co caĩ yʉyupʉ Jesu: —Nipetirã ati ope macaje ocore caetirã oco etigacõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yʉ cajoorije macare caetirã oco etinemogaquetigarãma. Yepapʉre oco cabuticõa ani opere bairona na anigaro wariñuurique na yeripʉre. Tie jʉgori catícõa aninucugarãma, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—To roquere tie ocore yʉ jooya. Yʉre mʉ cajooro yʉ oco etiga nemoquetigo. To bairi ati opepʉre oco waago yʉ atíquetinucugo yua, caĩñupo. ");
INSERT INTO tav_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu co caĩñupʉ: —Mʉ manapʉre cʉ pioja. ");
INSERT INTO tav_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","To bairo cʉ caĩro co maca ocõo bairo cʉ caĩ yʉyupo: —Camanapʉ máco yʉ ã yʉa. Jesu co caĩñupʉ tunu: —Camanapʉ máco yʉ ã ĩo cariapena mʉ ĩ. ");
INSERT INTO tav_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Jĩca wamo cãnacãʉ mena camanapʉ cʉtiñarico mʉ anibapa. Yucʉacã mʉ cacʉgoʉ mʉ manapʉ majuu me ãmi. To bairi cariapena mʉ caĩrije ã. ");
INSERT INTO tav_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","To bairo cʉ caĩro apio ocõo bairo cʉ caĩñupo Jesure: —Dio ye quetire buiori majocʉ mʉ ãcʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","To bairi jã ñicʉ jãa Samaria macana icʉ ʉ̃taʉpʉ Diore cáti nʉcʉbʉgonucuñupa. Mʉjaa judío maja maca, “Jerusalẽpʉ Diore cʉ cáti nʉcʉbʉgonucupe ã,” mʉja ĩnucu, cʉ caĩñupo. ");
INSERT INTO tav_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","To bairo co caĩro ocõo bairo co caĩñupʉ Jesu: —Yʉ caĩrijere apiya. Cabero icʉ ʉ̃taʉpʉ aáquetibana quena, Jerusalẽpʉ aáquetibana quena mani Pacʉ Diore mʉja áti nʉcʉbʉgogarã. ");
INSERT INTO tav_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉjaa Samaria macana mʉja cáti nʉcʉbʉgorijere caroaro mʉja majiquẽe. Jã roque jã cáti nʉcʉbʉgonucurijere jã maji. Ocõo bairo ã: Camajare caroorijere na canetoobojapaʉ judío majocʉ anigʉmi. ");
INSERT INTO tav_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mani Pacʉ Diore áti nʉcʉbʉgorica yʉtea majuu ejagaro. Mere ti yʉtea anitʉga. Camaja Diore na yeripʉ jeto áti nʉcʉbʉgogarãma. To bairona na yeripʉ caroaro cʉ̃re cáti nʉcʉbʉgorãre boomi Dio. ");
INSERT INTO tav_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dio catʉjʉya mácʉ ãmi. Cʉ̃re cáti nʉcʉbʉgorã na yeripʉ jeto cʉ cáti nʉcʉbʉgoparã ãma, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","To bairo cʉ caĩro ocõo bairo cʉ caĩñupo: —Yʉ maji. Dio cʉ cajoʉ Mesía o Cristo cawamecʉcʉ atígʉmi. Ejaʉ cʉ majuuna nipetirijere mani buiogʉmi, caĩñupo. ");
INSERT INTO tav_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","To bairo co caĩro Jesu co caĩ majioñupʉ: —Yʉna mʉ mena cawadapeniina Dio cʉ cajooricʉna yʉ ã, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","To bairo na cawadapeniri paʉna caʉgarique wapayera aátana Jesu tʉpʉ jã catunu ejawʉ. Ejarã jã catʉjʉ acʉacoapʉ Jesu cãromio mena cʉ cawadapeniro tʉjʉrã. Jĩcaʉ maca ¿ñe uniere co booti? o ¿ñe uniere co mena mʉ wadapeniti? jã caĩ jeniñaquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","To bairi cãromio jã cáató tʉjʉo co oco waarica jotʉre tona ropocõa, macapʉ cáaácoamo. Topʉ ejao camajare cabuioyupo: ");
INSERT INTO tav_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Mʉja quena tʉjʉra ajá. Jõ jĩcaʉ ãmi dope bairo yʉ cabairiquere camaji peocõaʉ. Dio cʉ cajooricʉna ãcʉmi. ");
INSERT INTO tav_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","To bairo co caĩ buioro apirã Jesu tʉpʉ cáajupá. ");
INSERT INTO tav_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","To bairo na cáatí paʉ Jesure ʉgariquere cʉ nugarã jã cátibapʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","To bairi jã caĩwĩ: —Ʉgarique yʉ cacʉgorijere mʉja majiquẽna. ");
INSERT INTO tav_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","To bairo cʉ caĩro apirã cʉ buerã: —¿Aperã mere cʉ ʉgariquere na nu tʉgayupari? jã caame ĩ jeniñawʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu ocõo bairo jã caĩwĩ: —Dio yʉre cajoowĩ. Cʉ caboorijere ácʉ yʉ áa. Cʉ cáti rotiriquere áti peoʉ caʉgaʉre bairo yʉ tʉgooña. ");
INSERT INTO tav_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ocõo bairo yʉre mʉja ĩ: Bapari cãnacãʉ muipua rʉja oterique carica cʉtiparo jʉgoye. Yʉ maca yʉ catʉjʉata mere cajeepe ã. To bairo mʉjaare buioʉ, camaja na cabairijere mʉjaare ĩi yʉ ĩ. Yʉ cabuiorije na caapi nʉcʉbʉgoparo petoacã rʉja. ");
INSERT INTO tav_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oterique ricare jeeri maja na paarique wapa wapatarãma. Nare bairona camaja yʉre na caapi nʉcʉbʉgoro cána una quenare na yʉ wapa joogʉ. Aperã na cabuiorijere api nʉcʉbʉgori bero na quena catícõa aninucugarãma. To bairi nemoopʉ cabuio jʉgoʉ, apeĩ cabuionemo nutuacʉ na cabuiorijere na caapi nʉcʉbʉgoro tʉjʉrã na pʉgarãpʉna wariñuugarãma. ");
INSERT INTO tav_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Camaja na cabuionucuri wamere bairona ã: Jĩcaʉ nemoona oteimi. Cabero cʉ caoterique carica cʉtopʉ apeĩ jeimi tunu. ");
INSERT INTO tav_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mʉjaa yʉ buerã tiere bairona mʉja bai. Aperã na cabuio jʉgoriquere buionemo rotii mʉjaare yʉ joo. Nemoopʉ na cabuio jʉgoricarãre seeto majuu camajirioyupa. Yucʉacãre na cabuioriquepʉre ána mʉjaa. To bairi seeto majuu majirioquẽe mʉjaare, jã caĩwĩ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria macana cãromio, “Jesu nipetiro yʉ cátajere maji peocõami,” co caĩro apirã capãarã cʉ caapi nʉcʉbʉgowã. ");
INSERT INTO tav_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","To bairi Jesu tʉpʉ atí, cʉ̃re na tʉpʉ catua rotiwã. To bairi na tʉpʉre pʉga rʉmʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cabero Jesu cʉ cabuiorijere apirã capãarã caapiʉja nʉcʉbʉgonemowã. ");
INSERT INTO tav_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Cãromiore ocõo bairo co caĩwã: —Jãre mʉ cabuiorijere apirã Jesure jã nʉcʉbʉgowʉ. Cʉ tʉpʉ ejari jã majuuna cʉ cabuiorijere jã apiwʉ. To bairi, “Dio cʉ cajooricʉna ãmi,” caroaro majuu cʉ̃re jã ĩ nʉcʉbʉgo. Cariapena mʉ ĩñupa. Dio cʉ cajooricʉ ati yepa macana caroorã tʉpʉ na cáaábopere na canetoobojaʉ ãmi, co caĩwã yua. ");
INSERT INTO tav_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pʉga rʉmʉ Samaria macana mena aniri bero cáaácoami Jesu Galilea yepapʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesu cʉ majuu cʉ caĩricarore bairona cabaiwʉ: “Dio ye quetire cabuiori majocʉre cʉ ya yepa macana cʉ̃re tʉjooquẽnama.” ");
INSERT INTO tav_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cʉ ya yepa Galileapʉ cʉ caejaro camaja to macana maca caroaro cʉ catʉjʉ wariñuuwã. Na quena Jerusalẽpʉ pascua boje rʉmʉ catʉjʉra ejayupa. Topʉ Jesu cʉ cáti iñooriquere catʉjʉyupa. To bairi cʉ̃re canʉcʉbʉgowã. ");
INSERT INTO tav_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesu Galileapʉ ãcʉ Caná na caĩri macapʉ ocorena apeye ʉje ocore cʉ cáti jeñoorica macapʉ catunu aámi. Ti macapʉre jĩcaʉ ti yepare carotii ʉpaʉre carotibojaʉ cãmi. Cʉ macʉ cariayupʉ. Capernaupʉ cãñupʉ cariaʉ. ");
INSERT INTO tav_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","To bairi, “Jesu Judeapʉ cãnacʉ Galileapʉ ejayupʉ,” na caĩrijere queti apii Jesu tʉpʉ cáajupí. Ejaʉ, ocõo bairo cʉ caĩwĩ Jesure: —Yʉ macʉre cʉ netoobojaʉ ajá. Bai yajigʉpʉ ãmi, caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","To bairo cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Yʉ cáti iñoorijere tʉjʉquẽnana yʉre mʉja nʉcʉbʉgogaquetibʉja. ");
INSERT INTO tav_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Cariaʉ pacʉ maca ocõo bairo caĩwĩ Jesure: —Ʉpaʉ, jitá, uwaro. Yʉ macʉ bai yajiipʉ baimi. ");
INSERT INTO tav_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","To bairo cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Mʉ ya wiipʉ tunu aácʉja. Mʉ macʉ catícoagʉmi, caĩwĩ Jesu. To bairo Jesu cʉ caĩrijere apiri cʉ ya wiipʉ catunucoami. ");
INSERT INTO tav_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cʉ catunu aáti paʉ cʉ paabojari maja mapʉ cʉ boca ejari, ocõo bairo cʉ caĩwã: —Mʉ macʉ catícoami. ");
INSERT INTO tav_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","To bairo cʉ na caĩ buioro: —¿Di paʉ majuu cʉ catí jʉgóri? na caĩ jeniñawĩ. To bairo cʉ caĩro: —Paaribota beroacã cʉ bʉgo janacoapʉ, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","To bairo na caĩ buioro: —Ti paʉ majuuna, “Mʉ macʉ catícoagʉmi,” yʉ ĩwĩ Jesu, na caĩñupʉ. To bairo cabairijere tʉjʉri Jesure canʉcʉbʉgoyupʉ, cʉ ya wii macana to bairona. ");
INSERT INTO tav_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Carotibojaʉ macʉre cʉ canetoo catiorique Galilea yepapʉre ʉje oco áti jeñoori bero cʉ cáti iñoo bapoorique cãñupa ti wame. ");
INSERT INTO tav_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Carotibojaʉ macʉre cʉ canetooro bero Jesu judío maja na boje rʉmʉ cãnopʉ tʉjʉ aácʉ Jerusalẽpʉ catunu aámi yua. ");
INSERT INTO tav_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ti maca Jerusalén ʉ̃ta mena ʉmʉaro jani jãrica maca cãmʉ. Ti janiropʉre jĩca jope oveja cawamecʉti jope cãmʉ. Ti jope tʉ ujagarã na caquenoorica coro pairi coro cãmʉ. Ti coro hebreo ye mena Betesda cawamecʉpʉ. Ti coro tʉpʉre jĩca wamo cãnacã arʉari cabiaya mani arʉari cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ti arʉaripʉre capãarã cariarã yepapʉ cacuñawã. Capea catʉjʉ majiquẽna, cáaá majiquẽna, carooye tuaricarã quena cãma. Rupaʉri cabʉrã quena cãma. Ti coropʉre majiña mano jĩcaniri Dio tʉ macacʉ carui ejanucuñupʉ. Rui ejari ocore to cawãrero cátinucuñupʉ. To bairo cʉ cáto bero ti coropʉ caroca ñua jʉgoʉre cʉ riaye canetonucuñupe. To bairi Dio tʉ macacʉ ángel ocore to cawãrero cʉ cáto coterã topʉ cacuñawã. ");
INSERT INTO tav_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Topʉre jĩcaʉ cariaʉ cãmi. Treinta y ocho cʉmari to bairona cariayecʉcʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","To bairi Jesu ti coro tʉpʉ neto aácʉ topʉ cacuñaʉre catʉjʉwĩ. Yoaro cʉ cariayecʉto tʉjʉri cʉ caĩ jeniñawĩ Jesu: —¿Mʉ riaye canetoro mʉ booti? cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","To bairo cʉ caĩro Jesure caĩ yʉwĩ cariaʉ: —Ʉpaʉ, yʉre cátinemoʉ máni majuucõami. To cãnacã nina oco cawãreri paʉ ti coropʉ yʉ cajañagaro aperã yʉ jʉgoye jañanucuma, cʉ caĩwĩ Jesure. ");
INSERT INTO tav_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","To bairo cʉ caĩro: —Wamʉnʉcaña. Mʉ cacuñari ajerore ne aácʉja, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","To bairo cʉ caĩrona cañuucoami. Mere cañuʉ aniri wamʉnʉca, cʉ cacuñari ajerore ne, cáaá jʉgówĩ. Cʉ canetori rʉmʉ sábado cãmʉ, judío maja na cayerijãnucuri rʉmʉ. ");
INSERT INTO tav_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","To bairi Jesu cʉ canetoo catioricʉ cʉ cacuñari ajerore cʉ cane aáto tʉjʉrã judío maja ʉparã ocõo bairo cʉ caĩwã: —¿Nope ĩi yucʉ yerijãrica rʉmʉ to cãnibato quena mʉ cacuñari ajerore mʉ ne aáteñati? To bairo manire carotiquẽtie ã. ");
INSERT INTO tav_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","To bairo na caĩro ocõo bairo na caĩ yʉwĩ cariabatacʉ: —Yʉre cariaye netooecʉ, “Mʉ cacuñari ajerore ne aácʉja,” yʉ ĩwĩ, na caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ocõo bairo cʉ caĩwã tunu: —¿Ñamʉ majuu to bairo mʉre cʉ áti rotiri? ");
INSERT INTO tav_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jesure camajiquẽcʉ cãmi mai cariabatacʉ. Jesu maca cʉ̃re cʉ netoo yaparo capãarã camaja watoapʉ cáaá ajuyacoami Jesu. To bairi Jesure catʉjʉ majiquẽmi cariaye cʉtibatacʉ. ");
INSERT INTO tav_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cabero Jesu maca Dio wiipʉ cariabatacʉre bʉga ejaʉ ocõo bairo cʉ caĩwĩ: —Caroare mʉ ápa. Mere canetooricʉpʉ mʉ ã. Caroorije mʉ átinemoquẽpa. Caroorije mʉ cátinemoata netoro rooro majuu mʉ baigʉ, cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","To bairo Jesu cʉ caĩro apii judío maja ʉparãre cabuioʉ aájupʉ: —Yʉre canetoo catioricʉ Jesu cawamecʉcʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","To bairo cʉ caĩro apirã judío maja ʉparã Jesu sábado cãno camajare cʉ canetoorique quetire camajiñuparã. To bairi cʉ̃re punijinirã cʉ cajĩagayupa. ");
INSERT INTO tav_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","To bairo na cabairo ocõo bairo na caĩwĩ Jesu: —Yʉ Pacʉ caroa macajere cátinucuʉ ãmi. Yʉ quena cʉ̃re bairo caroa macajere yʉ átinucu. ");
INSERT INTO tav_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Judío maja, sábado cãno cariarãre na netoʉ áti rotiquetaje áami Jesu ĩrã cʉ cajĩagawã. Cabero, “Dio yʉ Pacʉ ãmi,” cʉ caĩrijere apirã netobʉjaro cʉ cajĩagawã. “To bairo ĩi, ‘Dio mena jĩcaro cãcʉ yʉ ã,’ ĩi áami,” caĩwã judío majare cajʉ́go ãna. ");
INSERT INTO tav_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","To bairo na caame ĩro ocõo bairo na caĩwĩ Jesu: —Cariape majuu mʉjaare yʉ buiogʉ. Yʉ Dio Macʉ anibacʉ quena yʉ majuuna áti iñooriquere yʉ áti majiquẽe. Yʉ Pacʉ cʉ cátigarijere majiri cʉ carotirije mena jeto tiere yʉ áti maji. Nipetirije yʉ Pacʉ yʉ cátipe cʉ cabooro majiri tiere yʉ átinucu. ");
INSERT INTO tav_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ Pacʉ yʉre maii nipetirije cʉ cátinucurijere yʉ iñoomi. Yucʉacã cáaá majiquẽcʉre cʉ yʉ canetooeje netoro yʉ áti iñoo rotigʉmi caberopʉre. Tiere mʉja tʉjʉ acʉa majuucõagarã. ");
INSERT INTO tav_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉ Pacʉ camaja cabai yajiricarãre tunu catiocoami. Cʉ̃re bairona yʉ quena yʉ catunu catiogarãre na yʉ tunu catiogʉ. ");
INSERT INTO tav_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Yʉ Pacʉ camajare na tʉjʉ bejequẽemi. Yʉ macare camajare yʉ tʉjʉ beje rotimi. Camaja yʉ Pacʉre nʉcʉbʉgoma. To bairo cʉ na canʉcʉbʉgorore bairona yʉ quenare na nʉcʉbʉgoato ĩi to bairona yʉre tʉjʉ beje rotimi. Yʉre cáti nʉcʉbʉgoquẽna yʉ Pacʉ yʉre cajooricʉ quenare áti nʉcʉbʉgoquẽema. ");
INSERT INTO tav_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Cariapena mʉjaare yʉ ĩ. Yʉ cabuiorijere caapirã, Dio yʉre cajooricʉre canʉcʉbʉgorã catícõa aninucugarãma. Popiyeye ecooquetigarãma. Capopiye tamʉoboricarã anibana quena catícõa aninucurique cʉgotʉgama mere. ");
INSERT INTO tav_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cariape yʉ ĩ tunu. Petoacã rʉja camaja yʉre na caapiʉjaparo. Mere yʉre na caapiʉjari yʉtea anitʉga. Yʉre caapiʉjaquẽna maca cabai yajiricarãre bairona ãma. Yʉ cabuiorijere caapirã maca tiere ána catícõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yʉ Pacʉ camajare cãnicõa aninucurijere cajoʉ ãmi. To bairi yʉ quenare camajare cãnicõa aninucurijere na yʉ cajooro yʉ rotimi. ");
INSERT INTO tav_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Camajare cabejei mʉ anigʉ, yʉ caĩ cũwĩ Dio yʉre. To bairi camaja tʉpʉ Dio cʉ cajooricʉ aniri camajare yʉ bejenucu. ");
INSERT INTO tav_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","To bairo yʉ caĩrijere apirã acʉaqueticõaña. Jĩca rʉmʉ nipetirã cabai yajiricarã quena yʉ cabuiorijere apigarãma. Tiere apirã maja operipʉ cãnibatana tunu caticoagarãma tunu. ");
INSERT INTO tav_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Caroaro cátinucuricarã cacaticõa ãna aninucugarãma. Caroorije cátana macare na popiyeyegʉmi Dio, nare tunu catiori. ");
INSERT INTO tav_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Yʉ majuu jĩcaʉna camajare yʉ beje majiquẽe. Yʉ Pacʉ cʉ cabooro cʉ carotirore bairona yʉ beje maji. Yʉ majuuna yʉ cabooro yʉ cátigarijere yʉ átiquẽe. Yʉ Pacʉ yʉre cajooricʉ cʉ caboorijere yʉ áa. To bairi yʉ cátie cariape ã. ");
INSERT INTO tav_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yʉ cáti aniere, “Caroa jeto ã,” yʉ majuuna yʉ caĩbato quena, “Cariape ĩimi,” yʉre mʉja ĩ nʉcʉbʉgo majiquetiborã. ");
INSERT INTO tav_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Apeĩ ãmi yʉ cáti aniere, “Caroa jeto ã,” caĩi. To bairo caĩi yʉ Pacʉ ãmi. “Mʉ cáti anie caroa jeto ã,” yʉre cʉ caĩrije roque cariapena ã. To bairi yʉre cʉ caĩrijere mʉja caapi nʉcʉbʉgope anibapa. ");
INSERT INTO tav_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Juan cabautisari majocʉpʉre yʉ cabairijere mʉja cajeniña roti jooyupa. Cariape majuu mʉjaare cayʉyupi cʉ̃a. ");
INSERT INTO tav_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yʉ cabairijere, “Caroa majuu ã,” camaja yʉre na caĩpere macaʉ mee yʉ áa. Caroorije mʉja cátie wapare mʉjaare Dio cʉ canetoobojape macare yʉ boo. To bairo boʉ atiere mʉjaare yʉ buio. ");
INSERT INTO tav_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan cajĩa buju jʉgori majocʉre bairona cãmi. Cajĩa bujurica caʉ̃ bujuro caroaro buju. Tia jĩa bujurica caʉ̃ bujurore bairona cãmi Juan caroaro yʉ ye quetire buioʉ. Cʉ cabuiorijere apirã jĩca rʉmʉriacã jeto tiere mʉja caapi wariñuuwʉ. ");
INSERT INTO tav_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yʉ cáti iñoorije maca Juan cʉ cabuiorique netoro cãnie ã. Yʉ cáti iñoorije yʉ Pacʉ cʉ cáti rotirique ã. To bairo yʉ cáti iñoorije tʉjʉri cariapena, “Mani Pacʉ Dio cʉ cajooricʉ ãmi,” yʉre mʉja caĩ majipe anibajupa. ");
INSERT INTO tav_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yʉ Pacʉ, yʉre cajooricʉ yʉ cãniere caroaro buiomi. Dio cʉ cawadarijere mʉja caapiquetibato quena, cʉ cabaurijere mʉja catʉjʉquetibato quena to bairona yʉre buiomi yʉ Pacʉ. ");
INSERT INTO tav_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yʉre cajooricʉre mʉja nʉcʉbʉgoquẽe. To bairi cʉ cabuiorijere mʉja apiʉjaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Catícõa aninucuriquere jã bʉgagarã ĩrã Dio ye queti ucarica pũurore nʉcʉbʉgorique mena mʉja buecõa aninucu. Ti pũuro caĩrijere buerã yʉ ye quetirena mʉja buenucubapa. ");
INSERT INTO tav_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Catícõa aninucuriquere boobana quena yʉre mʉja api nʉcʉbʉgogaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Camaja, “Caroaro majuu cabuioʉ ãmi,” yʉ na caĩro yʉ macaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉja yeripʉre caroaro yʉ tʉjʉ maji. Diore mʉja nʉcʉbʉgoquẽe. ");
INSERT INTO tav_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉ Pacʉ cʉ carotiro mena yʉ cáapʉ́ ati yepapʉre. To bairo yʉ cabaibato quena yʉre mʉja booquẽe. Aperã maca mʉja tʉpʉ na majuuna na cabooro mena caejarã na cãnibato quena caroaro nare mʉja apiʉja na macare. ");
INSERT INTO tav_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aperã, “Caroarã mʉja ã,” mʉjaare na caĩrijere seeto mʉja boo. Dio jĩcaʉ cãcʉ maca, “Caroarã mʉja ã,” mʉjaare cʉ caĩpe macare mʉja macaquẽe. To bairo cabairã aniri dope bairo yʉre mʉja áti nʉcʉbʉgo majiquẽe. ");
INSERT INTO tav_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","“Yʉ Pacʉ Diopʉre, ‘Ñuuquẽema,’ manire ĩ wadajãgʉmi,” yʉre ĩ tʉgooñaqueticõaña mʉjaa. Moisé tirʉmʉpʉ macacʉ maca, “Ñuuquẽema,” Diore mʉja ĩboʉmi. “Cʉ caucarique cõo apiʉjarã Dio tʉpʉ mani aágarã,” mʉja ĩ tʉgooñabapa. Cʉ caucarique yʉ ye quetina cãmʉ. To bairi cʉ caucariquere caapiʉjarã majuu mʉja cãmata yʉre mʉja api nʉcʉbʉgoborã. To bairi Moisé cʉ caucariquere caapi nʉcʉbʉgorã majuu mʉja cãniquẽto maca, “Ñuuquẽema,” mʉja ĩboʉmi Moisé. ");
INSERT INTO tav_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yʉ ye quetire cʉ caucariquere mʉja nʉcʉbʉgoquẽe. To bairi yʉ cabuiorije quenare mʉja apiʉjaquẽe, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesu Jerusalẽpʉ judío maja na ya boje rʉmʉ catʉjʉ ejaricʉ catunucoami Galileapʉre tunu. Topʉre ãcʉ Galilea macá ra ʉtabʉcʉrapʉ ape nʉgoapʉ capeñawĩ. Ti rana tunu Tiberia wamecʉti. ");
INSERT INTO tav_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Camaja cʉ cáti iñoorije mena cariaye cʉnare cʉ canetooro tʉjʉrã capãarã cʉ caʉjawã. ");
INSERT INTO tav_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","To bairi jã quena cʉ buerã cʉ mena ape nʉgoapʉ peña ejarã ʉ̃taʉpʉ wamʉ aá, jã caruiwʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ti paʉ cãno judío maja na ya boje rʉmʉ pascua cãniparo petoacã carʉjawʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu camaja capãarã cʉ na caʉjaro tʉjʉʉ ocõo bairo cʉ caĩwĩ Felipere: —¿Noopʉ ʉgariquere mani wapayera aánaati to cõo capãarãre na mani canupere? ");
INSERT INTO tav_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Felipere ¿dope bairo cʉ yʉati? ¿Noo cõo yʉre cʉ nʉcʉbʉgoti? ĩi, to bairo cʉ cajeniñawĩ Jesu. Jesu cʉ majuuna mere camajitʉgawĩ dope bairo cʉ cátipere. ");
INSERT INTO tav_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","To bairi Felipe cʉ caĩ yʉwĩ Jesure: —Jĩca cʉma camajocʉ cʉ capaarije wapa cõo pan na mani cawapaye nubato quena, nipetirãre petoriacã cãnie bʉquetiboro. ");
INSERT INTO tav_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","To bairo cʉ caĩro apii jã mena macacʉ André, Simón Pedro bai ocõo bairo cʉ caĩwĩ Jesure: ");
INSERT INTO tav_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Atopʉre ãmi cawimaʉ jĩcaʉ. Jĩca wamo cãnacã rupaa cebada mena na cátaje pãre cʉgomi. To bairi wai pʉgarã cʉgomi. Atie ʉgariqueacã, ati maja paarãacãre na eja tuaqueti majuucõaboro. ");
INSERT INTO tav_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","To bairo cʉ caĩro apii ocõo bairo caĩwĩ Jesu: —Na rui rotiya nipetirãre. To na caruiro caroaro ta cʉto cãmʉ. To bairi caruiwã nipetirã. Jĩca wamo cãnacã mil majuu caʉmʉa cãma. ");
INSERT INTO tav_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","To na caruiro Jesu pan rupaa canewĩ. Ne, Diore, “Ñuu majuucõa atiere jãre mʉ cajoorije,” cʉ ĩ nʉcʉbʉgo, yepapʉre caruirãre tiere cabate ricawowĩ. To bairona cámí wai quenare. Na caʉgagaro cõo na canuwĩ. ");
INSERT INTO tav_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na caʉgagaro cõo na caʉga yapiro bero ocõo bairo jã caĩwĩ Jesu cʉ buerãre: —Na caʉga rʉgarijere yajire ĩrã tiere jee neoña, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","To bairo cʉ caĩro jĩca wamo cõo pan rupaa cãnibatajere jã cajee neo jiroowʉ doce piiri majuu. ");
INSERT INTO tav_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Topʉ camaja paarãacã to bairo Jesu cʉ cáti eñoro tʉjʉrã ocõo bairo caame ĩwã: —Tirʉmʉpʉ macana, “Atígʉmi ati yepapʉ jĩcaʉ Dio ye quetire cabuio majuʉ,” na caĩ buio jʉgoyeyericʉ ãcʉmi anina. Cariapena anibaumi, caame ĩwã. ");
INSERT INTO tav_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","To bairi camaja seeto ti yepa ʉpaʉ cʉ jõogarã cʉ cane aágabama Jesure. Cʉ maca to bairo cʉ na cátigarijere tʉjʉʉ jĩcaʉna anigʉ ʉ̃taʉpʉ cawamʉcoami yua. ");
INSERT INTO tav_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cabero ñamicaa cãni nutuati paʉ ʉtabʉcʉrapʉ jã caro aápʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ro aá, Capernaupʉ aágarã cumuapʉ eja jãa, jã capeña jʉgówʉ. To cõo canaioro bero cãmʉ yua. Jesu jã tʉpʉ caejaquẽmi mai. ");
INSERT INTO tav_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jã capeña aáti paʉ wino seeto capapu nutuapʉ. To bairi paca majuu cajabewʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yoaro jĩca wamo cõo cãnacã kilómetro jã cáaá nutuati paʉ Jesu jã tʉpʉ atígʉ oco buipʉ cʉ cáatí nutuato jã catʉjʉjowʉ. Cʉ tʉjʉrã seeto jã caacʉawʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","To bairo jã caacʉa tʉjʉro tʉjʉri: —Yʉna yʉ ã. Uwiqueticõaña, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","To bairo cʉ caĩro cumuapʉ cʉ jã cajãa rotiwʉ. Cʉ caeja jãaro bero ape nʉgoa tʉpʉ nemoo jã caejacoapʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ape rʉmʉ maca camaja ape nʉgoapʉ catuaricarã cãni tʉjari cumua mena jã capeñariquere camajiñupa. “Jesu cʉ buerã mena peña aáquẽmi,” caĩ majiñupa. ");
INSERT INTO tav_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Petoacã bero caejayuparã aperã Tiberia macá cumuu mena. Pãre Jesu na cʉ canuricaropʉ caejayupa. Jesu, “Ñuu majuucõa atie jãre mʉ cajoorije,” Diore cʉ caĩricaro bero caʉgaricaropʉ caejayupa. ");
INSERT INTO tav_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ti paʉpʉ ejari Jesu cʉ buerã quena na camano tʉjʉrã ti cumuu eja jãa, aá, Capernaupʉ Jesure camacarã ejayupa. ");
INSERT INTO tav_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","To bairi na capeña ejari nʉgoa tʉpʉ peña ejarã, Jesure cʉ bʉga eja, ocõo bairo cʉ caĩ jeniñawã: —¿Ʉpaʉ, dope bairo bairi mʉ peña ejari ati nʉgoapʉre? ");
INSERT INTO tav_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","To bairo na caĩro ocõo bairo na caĩ yʉwĩ Jesu: —Cariapena mʉja yʉ ĩ. Pan mʉja caʉga yapirique jʉgori yʉre mʉja maca. Yʉ cáti iñoorique macare ¿dope bairo ĩgaro to ĩti? mʉja ĩ api majiquẽe. ");
INSERT INTO tav_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʉja ʉgarique jetore wapatagarã paaqueticõaña. Tie yoaro mee peticoa. Mʉjaare yʉ cajoogarije macare macaña. Tie maca anicõa aninucugaro. To bairi yʉ Pacʉ Dio yʉre cajoowĩ, catícõa aninucupere camajare na mʉ joogʉ ĩi, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","To bairo cʉ caĩro ocõo bairo cʉ caĩ jeniñawã: —¿Dope bairo jã áticʉti Dio cʉ caboorijere caroaro áti peogarã? Jesure cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","To bairo na caĩ jeniñaro: —Dio mʉjaare cʉ cáti rotirije ocõo bairo ã: Yʉre, cʉ cajooricʉre mʉja api nʉcʉbʉgo rotimi, na caĩ yʉwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","To bairi: —¿Ñee unie jãre mʉ áti iñoʉati jã caapi nʉcʉbʉgoparore bairo ĩi? ¿Dope bairije mʉ ácʉati? caĩ jeniñawã tunu. ");
INSERT INTO tav_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mani ñicʉ jãa maná cawame cʉtiere caʉgayupa. Cʉ ye queti ucarica pũuripʉ caĩrore bairona tie ʉgarique ʉmʉrecoo macajere Dio cʉ cajoorique cãñupa, caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","To bairo na caĩro, ocõo bairo na caĩ yʉwĩ Jesu: —Cariapena mʉjaare yʉ ĩ: Moisé ʉgarique ʉmʉrecoo macaje majuu na cajooquẽjupi. Yʉ Pacʉ maca ʉgarique ʉmʉrecoo macaje majuure cajoʉ ãmi, caroare. ");
INSERT INTO tav_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dio ʉgarique catícõa aninucurije cajoorije uniere joʉ yʉre cajoowĩ ʉmʉrecoopʉ cãnacʉre ati yepa macana tʉpʉ, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","To bairo cʉ caĩro: —Ʉpaʉ, tie ʉgarique jãre joocõa aninucuña, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","To bairo na caĩro: —Yʉna yʉ ã ʉgarique catícõa aninucurijere cajoʉ. Yʉre caapiʉjarã ñigo riaquetigarãma. Yʉre caapi nʉcʉbʉgorã ñeme jipiquetigarãma. To bairo na ĩi, yʉre caapi nʉcʉbʉgorãre ñe unie rʉjaquetigaro na cãni wariñuu anipere ĩ buio majioʉ, caĩwĩ Jesu. To bairo ĩi ocõo bairo na caĩnemowĩ tunu: ");
INSERT INTO tav_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Cajʉgoye mʉjaare yʉ ĩbapʉ: Yʉre tʉjʉbana quena yʉre mʉja api nʉcʉbʉgoquẽe. ");
INSERT INTO tav_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yʉ Pacʉ, “Cʉ̃re api nʉcʉbʉgogarãma yʉ Macʉre,” cʉ caĩrã nipetirã yʉre api nʉcʉbʉgogarãma. Yʉre na caapi nʉcʉbʉgoro na booqueticõa yʉ baiquetigʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ʉmʉrecoopʉ cãnacʉ yʉ cáapʉ́ yʉre cajooricʉ cʉ caboorijere átigʉ. Yʉ majuuna yʉ caboorije átigʉ mee yʉ cáapʉ́. ");
INSERT INTO tav_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yʉ Pacʉ yʉre cajooricʉ yʉre cʉ cajooricarãre na cayajiro booquẽemi. To bairi ati ʉmʉrecoo capetiro nare yʉ catunu catioro boomi. ");
INSERT INTO tav_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yʉ Pacʉ ocõo bairo camaja na cáti majuupe macare boomi: Camaja nipetirã yʉ cãniere camajirã, caroaro yʉre catʉgooñarã, yʉre canʉcʉbʉgorã na cacaticõa aninucupere boomi. To bairi ati ʉmʉrecoo capetiro nare yʉ tunu catiogʉ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","To bairo cʉ caĩro apirã judío maja ʉparã cʉ cawada paiyuparã. Jesu, “Ʉmʉrecoo macaje ʉgarique majuu yʉ ã,” cʉ caĩro apirã ocõo bairo cʉ cawada pai coteyuparã: ");
INSERT INTO tav_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Ani Jesuna ãmi. José macʉna ãmi. Cʉ pacʉ, cʉ paco mani camajirã jeto ãma. ¿Nope ĩi ʉmʉrecoopʉ cãnacʉ yʉ carui apʉ́ cʉ ĩti? ");
INSERT INTO tav_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","To bairo na caĩro apii ocõo bairo na caĩwĩ Jesu: —Yʉre wada paiqueticõaña. ");
INSERT INTO tav_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jĩcaʉ maca cʉ majuuna cʉ cabooro yʉre apiʉja majiquẽemi. Yʉ Pacʉ yʉre na canʉcʉbʉgopere cʉ cajoorã jeto yʉ apiʉja majima. Yʉre caapiʉjarãre ati ʉmʉrecoo capetiro na yʉ tunu catiogʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dio ye quetire buiori maja tirʉmʉpʉ macana ocõo bairo caucayupa: “Dio nipetirãre na majiogʉmi cʉ yere.” To bairi nipetirã yʉ Pacʉ cʉ cabuiorijere caapi nʉcʉbʉgorã yʉre apiʉjama. ");
INSERT INTO tav_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Jĩcaʉ maca yʉ Pacʉ Diore catʉjʉricʉ maami. Cʉ mena cãnacʉ jĩcaʉna yʉ ã cʉ catʉjʉricʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cariape mʉja yʉ ĩ. Yʉre canʉcʉbʉgorã catícõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉna yʉ ã ʉmʉrecoo macaje ʉgarique majuure catícõa aninucuriquere cajoʉ. To bairi cacaticõa aninucurijere yʉ joo. ");
INSERT INTO tav_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉja ñicʉ jãa camaja na cãniquẽtopʉ, ñee manopʉ maná na caĩrije ʉgariquere caʉgayupa Dio na cʉ cajoorijere. Tiere ʉgabana quena cabai yaji peticoajupa. ");
INSERT INTO tav_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yʉ maca, ape wame ʉgarique ʉmʉrecoo macaje macare mʉjaare yʉ buio. Tiere caʉgarã catícõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉna yʉ ã tie ʉgarique ʉmʉrecoopʉ carui atácʉ. Tiere caʉgarã catícõa aninucugarãma. Ʉgarique yʉ cajoorije yʉ rupaʉ ã. Ati yepa macana na cacaticõa aninucuparore bairo ĩi atie ʉgariquere yʉ joogʉ, caĩwĩ Jesu. Caroorije mani cátie wapa cʉ rupaʉpʉre manire cʉ cabai yajibojapere ĩi, na caĩ buiobami Jesu tiere. ");
INSERT INTO tav_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","To bairo cʉ caĩro apirã judío maja ʉparã ocõo bairo caame ĩ wada netowã: —¿Ani dope bairo cʉ rupaʉre manire cʉ ʉga rotibocʉti? ");
INSERT INTO tav_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","To bairo na caame ĩro ocõo bairo na caĩwĩ Jesu: —Cariapena mʉja yʉ ĩ. Yʉ rupaʉre ʉgaquẽna, yʉ riíre etiquẽna mʉja catícõa aninucuquetigarã. ");
INSERT INTO tav_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yʉ rupaʉre caʉgarã maca, yʉ riíre caetirã maca catícõa aninucugarãma. Na cabai yajiricaro bero ati yepa capetiro nare yʉ tunu catiogʉ. ");
INSERT INTO tav_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ rupaʉ ʉgarique majuu ã. Yʉ rií etirique majuu ã. Tie ʉgarique ati yepa macajere bairo aniquẽe. To bairi petiquetigaro. ");
INSERT INTO tav_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yʉ rupaʉre caʉgarã, yʉ riíre caetirã yʉ mena macanana ãma naa. Yʉ quena na menana yʉ ã. ");
INSERT INTO tav_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ Pacʉ, yʉre cajooricʉ catícõa aninucumi. Cʉ jʉgori yʉ ã. To bairi yʉ rupaʉre caʉgarã yʉ jʉgori catícõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ʉmʉrecoopʉ macaje ʉgarique majuu carui atáje yʉ buio. Atie ʉgarique maná cawame cʉtaje, mʉja ñicʉ jãa na caʉgariquere bairo aniquẽe. Tie manáre ʉgabana quena cabai yaji peticoajupa naa. Yʉ rupaʉre caʉgarã roque catícõa aninucugarãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Atiere Capernaupʉ judío maja na neñapo buerica wiipʉ to bairijere na caĩ buiowĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesure caʉjarã to bairo cʉ cabuiorijere apirã ocõo bairo caĩwã: —Atie cʉ cabuiorije majirio neto. Noa tiere api puo majiquetiborãma. ");
INSERT INTO tav_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","To bairo na caĩrijere majii ocõo bairo na caĩwĩ Jesu: —¿To bairo yʉ caĩ buiorijere mʉja api tʉjooquẽeti? ");
INSERT INTO tav_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Dope bairo mʉja tʉgooñabocʉti cajʉgoye yʉ cãnatopʉ yʉ catunu wamʉ aáto mʉja catʉjʉata? ");
INSERT INTO tav_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Catiriquere mani cacʉgoro mani rupaʉ catí. Catiriquere mani cacʉgoquẽto mani rupaʉ wapa maa. Mepʉ yʉ cabuioeje ʉgarique, etirique maca yeri macaje ã. Cacaticõa aninucurijere cajoorije ã. ");
INSERT INTO tav_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jĩcaarã mʉja mena macana yʉ cabuiorijere api nʉcʉbʉgoquẽema, caĩwĩ Jesu. Camajitʉgawĩ Jesu cʉ̃re canʉcʉbʉgoquetiparãre. Cʉ̃re cañeparãre na cawadajãpaʉ quenare camajitʉgawĩ. ");
INSERT INTO tav_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ocõo bairo caĩwĩ Jesu tunu: —To bairo jĩcaarã yʉre mʉja canʉcʉbʉgoquẽto maca, mepʉ mʉjaare yʉ caĩe wamere bairona yʉ ĩ tunu: Jĩcaʉ maca cʉ majuuna cʉ cabooro yʉre apiʉja majiquẽemi. Yʉ Pacʉ yʉre na caapi nʉcʉbʉgoro cʉ cátana jeto yʉre apiʉja majima, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","To bairo cʉ cabuiorijere api tʉjooquetibana capãarã cʉ̃re caʉjabatana cʉ caʉja janacõawã. ");
INSERT INTO tav_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","To bairo cʉ na caʉja janaro tʉjʉʉ Jesu cʉ buerãre ocõo bairo jã caĩ jeniñawĩ: —¿Mʉja quena yʉre mʉja aáweogati? ");
INSERT INTO tav_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","To bairo cʉ caĩro ocõo bairo cʉ caĩ yʉwĩ Simón Pedro: —Ʉpaʉ, ¿noa macare jã ʉjabocʉti? Mʉ jeto mʉre caapi nʉcʉbʉgorãre catícõa aninucuriquere mʉ buio. Noo apeĩ jã caapi nʉcʉbʉgopaʉ mácʉmi. ");
INSERT INTO tav_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","To bairi mʉrena jã nʉcʉbʉgotʉga. “Jĩcaʉna mʉ ã caroaʉ Dio cʉ cajooricʉ,” mʉre jã ĩ tʉgooña nʉcʉbʉgo, cʉ caĩwĩ Simón Pedro. ");
INSERT INTO tav_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","To bairo cʉ caĩro, Jesu jã caĩwĩ: —Doce majuu yʉ mena cãniparãre mʉjaare yʉ cabejewʉ. To bairo mʉjaare yʉ cabejerique to cãnibato quena jĩcaʉ mʉja mena macacʉna Sataná yaʉ ãmi yua. ");
INSERT INTO tav_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","To bairo ĩi Simón, Iscariote macʉ, Judas Iscariotere cʉ ĩi caĩwĩ Jesu. Judas jã mena macacʉ anibacʉ quena cabero Jesure cañeparãre cawadajãwĩ. ");
INSERT INTO tav_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jesu camajare to bairo na cʉ cabuioro bero Galilea yepapʉre cãni teñawĩ. Judea yepapʉre cáaágaquẽmi mai topʉ cãna judío maja cʉ na cajĩagaro maca. ");
INSERT INTO tav_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ti paʉ cãno judío maja na ñicʉ jãa wiiriacã camaja máni paʉpʉ na cãninucuñariquere tʉgooña ʉjagarã cámá. To bairi ti boje rʉmʉ cãniparo jʉgoyeacã Jesu bairã ocõo bairo cʉ caĩwã: ");
INSERT INTO tav_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","—Atopʉ tuaquẽja. Judeapʉ aácʉja, topʉ macana mʉre catʉjoorã quena mʉ cáti iñoorijere na tʉjʉato ĩi. ");
INSERT INTO tav_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nii apeye uniere cáti majii ũcʉ aperã na catʉjʉrona ácʉmi, camaja yʉre na majiato ĩi. Cayajioropʉ áti iñooquetiboʉmi. Mʉa cáti iñoʉ mʉ ãcʉ. To bairi camaja nipetirã mʉre na majiato ĩi, baujaro áti iñoʉja camaja capãarã na catʉjʉjoropʉ, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cʉ bairã anibana quena, “Dio cʉ cajooricʉ ãmi Jesu,” cʉ caĩ nʉcʉbʉgoquẽma. To bairi ocõo bairo na caĩwĩ Jesu: ");
INSERT INTO tav_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—Noo yʉ cabooro yʉ aá majiquẽe. Yʉ Pacʉ rooro yʉ catamʉopere rotiquẽemi mai. Mʉja roque noo mʉja cabooro mʉja aá maji. ");
INSERT INTO tav_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ati yepa macana Diore caapiʉjaquẽna mʉjaare tʉjʉtee majiquẽema. Yʉ macare yʉ tʉjʉ teebʉjama, “Caroorije cána mʉja ã,” na yʉ caĩrije jʉgori. ");
INSERT INTO tav_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉja jetona boje rʉmʉre tʉjʉrãja. Topʉ yʉ cáaápa paʉ majuu aniquẽe mai. To bairi yʉ aáquẽe yʉa, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","To bairo na ĩ, Galileapʉna catuacõawĩ. ");
INSERT INTO tav_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","To bairi cʉ bairã Jerusalẽpʉ boje rʉmʉ catʉjʉrã aáma. Na beropʉ Jesu quena boje rʉmʉ recomacapʉ cãni nutuati paʉpʉ cáaámi. Camaja capãarã cʉ na catʉjʉjoropʉ cáaáquẽmi paro. Cʉ̃re na catʉjʉ majiqueti paʉ maca cáaámi. ");
INSERT INTO tav_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","To bairi ti boje rʉmʉ cãno judío maja ʉparã Jesure macarã, “Jõ cãniepaʉate ¿noopʉ cʉ anicʉti?” caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Topʉ cãna paarãacã camaja Jesu cʉ cãniere caame ĩ wada netowã. “Caroaʉ ãmi,” cʉ caĩñuparã jĩcaarã. Aperã maca, “Caroaʉ me ãmi. Camaja na catʉgooña mawijioro cáti paii ãmi,” caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","To bairi judío maja ʉparãre na uwirã nipetirã na caapijoropʉ, “Caroaʉ ãmi Jesu,” caĩ wadaquẽma. ");
INSERT INTO tav_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jerusalẽpʉ boje rʉmʉ recomaca cãni atí paʉpʉ Jesu Dio wiipʉ jãa, camajare na cabuio jʉgówĩ. ");
INSERT INTO tav_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Cʉ cabuiorijere apirã judío maja ʉparã caapi acʉacoama. —Ani cabuequetacʉ anibacʉ quena ¿dope bairo to cõo cʉ majiti? caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","To bairi Jesu na caĩwĩ: —Yʉ cabuiorije yʉ ye me ã. Yʉ Pacʉ, yʉre cajooricʉ ye macaje maca ã. ");
INSERT INTO tav_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Noo Dio cʉ caboorije cátigaʉ ũcʉ yʉ cabuiorijere, “Cariapena ã,” ĩ majigʉmi. “Dio cʉ carotiro mena buiomi. Cʉ majuuna cʉ cabooro mena buioquẽemi,” ĩ majigʉmi. ");
INSERT INTO tav_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jĩcaʉ cʉ majuuna cʉ cabooro camajare buioʉ, yʉre na nʉcʉbʉgoato ĩina to bairona buiomi. Apeĩ Dio cʉ carotiro mena cabuioʉ maca camaja Diore na nʉcʉbʉgoato ĩi buiomi. To bairo cácʉ roque cariape buiomi. Caĩtoquẽcʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Dio cʉ carotiriquere mʉjaare cajooyupi Moisé tirʉmʉpʉ macacʉ. To bairo cʉ cajoobato quena jĩcaʉ maca tie Dio cʉ carotiriquere mʉja átiquẽe. To bairi ¿nope ĩrã yʉre mʉja jĩagati? na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","To bairo cʉ caĩro ocõo bairo cʉ caĩwã: —¿Noa mʉre na jĩagati? Wãtire cacʉgoʉ mʉ ãcʉ, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu na caĩwĩ: —Sábado, yerijãrica rʉmʉ cãno cáaá majiquẽcʉre cʉ cáaá majiro yʉ tʉjʉ acʉarã yʉre mʉja jĩaga. ");
INSERT INTO tav_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","¿Ñeere ĩrã mʉja acʉati? Moisé circuncisión átajere mʉja cáti rotiyupi. To bairo Moisé cʉ carotirije jʉgoye mʉja ñicʉ jãa nemoona to bairo cáti jʉgó ájupa. Ape paʉra mʉja punaa na cabuiari rʉmʉ bero jĩca semana cõo sábado anigaro. ");
INSERT INTO tav_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","To bairi Moisé cʉ carotiriquere cõoricaro átigarã circuncisión mʉja áa mʉja punaare sábado cãnibato quena. To bairo átibana quena sábado cãno jĩcaʉre cʉ riaye yʉ canetooro tʉjʉrã ¿ñeere ĩrã yʉre mʉja tʉjʉ punijiniti? ");
INSERT INTO tav_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yʉ cãniecʉtiere majiquetibana quena, “Ñuuquẽemi,” yʉre ĩ tʉgooñaqueticõaña. Caroaro majirãpʉ yʉ cãniere caroaro mʉja ĩ majigarã, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","To bairo Jesu camajare cʉ caĩ buiori paʉ aperã Jerusalén macana ocõo bairo caĩwã: —¿Anina na cajĩaganucuʉ cʉ anibauti? ");
INSERT INTO tav_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nipetirã na catʉjʉjoropʉ camajare buioʉ áami. Na catʉjʉ majiropʉ camajare cʉ cabuiobato quena, “Janaña,” cʉ ĩ tutiquẽema mani ʉparã. To bairi, “Ani Dio Macʉ cʉ cajooricʉna ãcʉmi,” ¿cʉ̃re na ĩ tʉgooña nʉcʉbʉgoti? ");
INSERT INTO tav_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ani, “Dio joogʉmi jĩcaʉ cʉ cabejericʉ,” Dio ye quetire cabuiorã cãniñaricarã na caĩricʉ aniquẽcʉmi. “Topʉ macacʉna ãmi,” cʉ mani ĩ maji. Dio cʉ cajooricʉ majuu cʉ cãmata, “Topʉ macacʉ ãmi,” mani ĩ majiquetiborã, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesu yua camajare na cʉ caĩ buiori paʉ to bairo na caĩ wadaro apii tutuaro mena na caĩwĩ yua: —“Cʉ̃re jã maji, cʉ cáatátopʉre jã maji,” yʉre mʉja ĩbapa. Jocarãna mʉja ĩ. Yʉre camajiquẽna mʉja ã. Dio cariape cácʉ yʉre cajoowĩ. To bairi yʉ majuuna yʉ cabooro mena yʉ cáatíquẽpʉ. Dio maca cʉ cajooepaʉ yʉ ã. Cariape caĩi ãmi yʉre cajooricʉ. Cʉ̃re camajiquẽna mʉja ã. ");
INSERT INTO tav_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yʉ maca caroaro cʉ̃re yʉ maji, cʉ tʉpʉ cãnacʉ aniri, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","To bairo cʉ caĩrijere apigateerã cariapena presopʉ cʉ cajõogabajuparã. Rooro cʉ̃re na cátipe carotiquẽjupi Dio mai. To bairi cʉ cañe majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Camaja capãarã cʉ canʉcʉbʉgowã. Cʉ̃re nʉcʉbʉgori ocõo bairo caame ĩwã: —¿Dio cʉ cabejericʉ Cristo acʉ́ ani cʉ cáti iñoorije netoro cʉ áti majiquetibauti? caame ĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo maja maca, “Ani Dio cʉ cabejericʉna ãmi,” camaja Jesu na caĩ buioro caqueti apiyuparã. To bairi fariseo maja sacerdote maja ʉparã mena Dio wiire cacoterã, polisía maja Jesure na ñeato ĩrã na cajooyuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","To bairi Jesu maca ocõo bairo na caĩwĩ camajare: —Mʉja mena yoaroacã mee yʉ anigʉ. Cabero yʉre cajooricʉ tʉpʉ yʉ aácoagʉ. ");
INSERT INTO tav_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","To bairi yʉre macabana quena yʉre mʉja bʉgaquetigarã. Yʉ cáaáti paʉpʉre mʉja aá majiquetigarã. ");
INSERT INTO tav_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judío maja ʉparã caame ĩ jeniñawã: —¿Noopʉ cʉ aácʉati ani, “Yʉre mʉja bʉgaquetigarã,” caĩi? ¿Judío maja griego maja tʉpʉ cáaá batericarãre cʉ buio teñaʉ aácʉati? ¿Griego maja quenare cʉ buio teñaʉati? ");
INSERT INTO tav_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Dope bairo ĩi, “Yʉre macabana quena yʉre mʉja bʉgaquetigarã,” manire cʉ ĩti? caame ĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jesu na caboje rʉmʉ áti yaparori rʉmʉ cãno wamʉnʉca, tutuaro mena camajare ocõo bairo na caĩ buiowĩ: —Oco etigarã, yʉ tʉpʉ atí, etirã ajá. ");
INSERT INTO tav_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","To bairi mʉja yeripʉre ria oco cauma yuaánucucõarore bairona anigaro, Dio ye queti ucarica pũuripʉ caĩricarore bairona mʉjaare yʉ ĩ buio, caĩwĩ Jesu. To bairo na ĩi, mʉja yeripʉ caroa anicõa aninucugarã yʉre apiʉjaya ĩgʉ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Oco cauma yuaánucucõarije buioʉ Espíritu Santore cʉ cabairijere ĩ buioʉ caĩwĩ Jesu. Cʉ̃a Espíritu Santona Jesure caapi nʉcʉbʉgorã menapʉre anigʉmi ĩi, caĩwĩ. Espíritu Santo cʉ cáatíparo jʉgoye cãmʉ mai. Jesu cabai yajiricʉ catunu catiipʉ ʉmʉrecoopʉre cʉ cãniparopʉre catunu aáquẽmi mai. To bairi Espíritu Santo jã menapʉre anigʉ cáatíquẽmi mai. ");
INSERT INTO tav_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Aperã Jesu cʉ cabuiorijere apirã ocõo bairo caĩwã: —Cariapena ã, ani, “Dio ye quetire cabuioʉ majuu atígʉmi,” tirʉmʉpʉ macana na caĩñaricʉna ãmi Jesu, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ocõo bairo caĩwã aperã tunu: —Ani, “Dio joogʉmi caroaʉ majuu cʉ cabejericʉre Cristo,” na caĩricʉna ãcʉmi, caĩwã. Aperã maca: —Dio cʉ cajoʉna cʉ cãmata Galilea macacʉ aniquetiboʉmi. ");
INSERT INTO tav_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dio ye queti ucarica pũuropʉ ocõo bairo ĩrica wame ã: “Dio cʉ cajoʉ David ãnacʉ pãrami aniri cʉ ãnacʉ cʉ cãna maca macacʉ, Belén macacʉ anigʉmi. Cʉ pãrami cãni buipeaʉpʉ anigʉmi,” ĩ ucarique ã, caĩwã aperã. ");
INSERT INTO tav_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Camaja Jesure jĩcaro cõo catʉgooñaquẽma. To bairi ricati jeto catʉgooñawã. ");
INSERT INTO tav_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aperã presopʉ cʉ jõogarã cʉ cañegawã. Cʉ ñegabana quena cʉ cañe aáquẽma mai. ");
INSERT INTO tav_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dio wii cacoterã polisía maja maca fariseo maja tʉpʉ, sacerdote maja ʉparã tʉpʉ cáaáma tunu. Topʉ na caejaro tʉjʉrã ocõo bairo na caĩwã sacerdote maja ʉparã: —Jesure cʉ ñeña ĩrã mʉjaare jã cajoobapʉ. ¿Nope ĩrã cʉ̃re mʉja ñe atíqueti? caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Polisía maja maca ocõo bairo na caĩ yʉyuparã: —Jĩcaʉ maca cʉ̃re bairo caĩ buioʉre jã apiñaqueti majuucõanucu, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseo poa macana ocõo bairo na caĩñuparã tunu: —¿Mʉja quena cʉ caĩtorijere mʉja apiʉjati? ");
INSERT INTO tav_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Caroaro api majiña. Jĩcaʉ maca ʉpaʉ cãcʉ o fariseo majocʉ ũcʉ cʉ api nʉcʉbʉgoquẽema. ");
INSERT INTO tav_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Cʉ cabuiorijere caapi nʉcʉbʉgorã Dio cʉ carotiriquere camajiquẽna jeto ãma. To bairi rooro baigaro nare, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, ñamipʉ Jesure catʉjʉ ejaricʉ fariseo maja mena macacʉ ocõo bairo na caĩñupʉ cʉ̃a: ");
INSERT INTO tav_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Manire carotirije ocõo bairo mani roti: Camajocʉ rooro cʉ cátiere caroaro majiquetibana quena, cʉ cabuioquẽtona cʉ capopiyeyequetipe ã. Cʉ cabuioro bero, roorije cʉ cátaje majiri bero cariapena cʉ capopiyeyepe ã, na caĩñupʉ Nicodemo. ");
INSERT INTO tav_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","To bairo cʉ caĩro: —¿Mʉ quena Galilea macacʉ mʉ ãti? Dio ye queti ucarica pũuripʉ caroaro bueya. Tiere caroaro bueri, “Jĩcaʉ maca Dio ye quetire cabuiori majocʉ Galilea macacʉ aniquẽemi,” mʉ ĩ majigʉ, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","To bairo ame ĩri bero Jerusalẽpʉ boje rʉmʉ caejaricarã na ye wiiripʉ catunu peticoajuparã. ");
INSERT INTO tav_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu maca cʉ cãni wiipʉ tunu aáquẽcʉna Jerusalén tʉacã Olivo cawamecʉtii ʉ̃taʉpʉ cáaámi. ");
INSERT INTO tav_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cabero ape rʉmʉ cabujuri paʉ Dio wiipʉ cáaámi tunu. Camaja nipetirã cʉ tʉpʉ caneñapowã, cʉ cabuiorijere apigarã. To bairo na cabairo Jesu topʉ ejanumu ejari nare caĩ buiowĩ. ");
INSERT INTO tav_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","To bairo cʉ caĩ buiori paʉna judío majare cabuerã, fariseo maja Jesu tʉpʉ caejawã. Jĩcao cãromio co manapʉ cãniquẽcʉ mena rooro cátacore camaja watoapʉ co cane ejawã. ");
INSERT INTO tav_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Co ne eja, ocõo bairo caĩwã Jesure: —Ʉpaʉ, atio co manapʉ cãniquẽcʉ mena rooro cácore jã bʉga ejawʉ. ");
INSERT INTO tav_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisé ãnacʉ to bairo cácore ʉ̃ta rupaa mena care jĩa rotiyupi. ¿Dope bairo mʉ ĩti mʉa? ");
INSERT INTO tav_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","To bairo cʉ caĩ jeniñawã, “Ricati wame cʉ cayʉ buicʉto, ‘Cañuuquẽcʉ ãmi,’ ʉparãre cʉ mani ĩ wadajãgarã,” ĩ tʉgooñari. To bairo cʉ na caĩ jeniñaro apii, mubia roca cumu, cʉ wamo jũa mena yepapʉ caucawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cʉ̃re na cajeniña janaquẽto apii camubiaricʉ cariape ponʉcari ocõo bairo na caĩwĩ Jesu: —Mʉja mena macacʉ jĩcani uno caroorije cátiñaquetacʉ ʉ̃taare neri cõre cʉ re jʉ́goato. ");
INSERT INTO tav_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","To bairo ĩ yaparo mubia, caucanemowĩ tunu. ");
INSERT INTO tav_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","To bairo cʉ caĩro apirã, “Cabui pacoorã majuu jã ã,” ĩ tʉgooñari cabuti peticoama jĩcaʉri jeto. Cabʉcʉrã majuu cãna cabuti jʉgowã. Na bero aperã quena caʉja buti aáma. To bairi jĩcaʉna cãromio mena catuanʉcawĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","To bairi Jesu ponʉca, jĩcaona co cãno tʉjʉʉ ocõo bairo co caĩwĩ: —¿Mʉre cawadajãrã noo na aápari? “Mʉre capopiyeyepe ã,” ¿na ĩquẽti? ");
INSERT INTO tav_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","To bairo cʉ caĩro: —Ĩquẽema, cʉ caĩwõ. Jesu ocõo bairo co caĩwĩ tunu: —Yʉ quena, “Mʉre capopiyeyepe ã,” yʉ ĩquẽe. Aácoja. Caroorije átinemoqueticõaña, co caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ape paʉ tunu Jesu camajare buioʉ ocõo bairo caĩwĩ: —Ati yepa macanare cajĩa bujubojaʉre bairona yʉ ã. Yʉre caapiʉjarã canaitĩaropʉ cãnare bairo aniquẽema. Na mena yʉ aninucu. Dope bairo na cátipere na yʉ áti iñoonucu. To bairi caroaro anicõa aninucuma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","To bairo cʉ caĩro apirã fariseo maja ocõo bairo caĩwã Jesure: —Mʉ majuu mʉ cátiere caroaro mʉ ĩ buionucu. Mʉ cabuiorije wapa maa. Mʉre jã nʉcʉbʉgoquẽe, mʉ majuuna mʉ caĩ buioro maca. ");
INSERT INTO tav_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ocõo bairo na caĩwĩ Jesu fariseo majare: —Yʉ majuuna yʉ cabuiorije anibato quena cariape wame ĩrique ã. Yʉ cãnatopʉ, yʉ catunu aápere yʉ maji. Mʉja roque, “¿Noopʉ cáatácʉ cʉ ãti, noopʉ cʉ aácʉati?” yʉre mʉja ĩ majiquẽe. ");
INSERT INTO tav_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ati yepa macana na cabeje rotirore bairona mʉja beje, “Caroorã ãma,” ĩgarã. Yʉ roque jĩcaʉ macare cʉ popiyeyegʉ yʉ bejequẽe. ");
INSERT INTO tav_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yʉ cabejeata cariapena yʉ bejeboʉ. Yʉ majuuna yʉ cabooro yʉ bejequẽe. Yʉ Pacʉ yʉre cajooricʉ mena jã bejenucu. ");
INSERT INTO tav_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉja carotirije na caucarique ocõo bairo ã: “Pʉgarã camaja jĩcarore bairo na catʉjʉrique na cawadajãro na caapi nʉcʉbʉgope ã. ");
INSERT INTO tav_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉ cabuiorije quena to bairona ã. Yʉ majuuna yʉ ã yʉ cátiere caroaro cabuioʉ. To bairi yʉ Pacʉ ãmi apeĩ. To bairi yʉ Pacʉ mena cariapena jã buionucu. ");
INSERT INTO tav_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jesure ocõo bairo cʉ caĩ jeniñawã: —¿To roquere mʉ Pacʉ noopʉ cʉ anicʉti? Ocõo bairo na caĩ yʉwĩ Jesu: —Yʉre mʉja majiquẽe mʉjaa. Yʉ Pacʉ quenare mʉja majiquẽe. Yʉre mʉja camajiata yʉ Pacʉ quenare mʉja majiborã. ");
INSERT INTO tav_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu to bairo buioʉ Dio wiipʉ cãmi. Camaja niyeru cajoorã na cajãri patari tʉpʉ catʉjʉnucuwĩ. Topʉ cʉ cãno camaja cʉ̃re na cajĩape cãniquẽjupa. Dio cʉ̃re na cañero cabooquẽjupi mai. To bairi Jesure cʉ cañe majiquẽjupa mai. ");
INSERT INTO tav_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ocõo bairo na caĩwĩ Jesu judío maja ʉparãre: —Cáaápaʉ yʉ ã. Yʉ cáaáto bero yʉre mʉja macagarã. Caroorije cáti aninucurãna mʉja bai yajigarã. Yʉ cáaáparopʉre mʉja aá majiquetigarã. ");
INSERT INTO tav_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","To bairo cʉ caĩro na majuuna caame ĩ jeniñawã: —¿Cʉ majuuna cʉ jĩa yajiati? To bairo cátipaʉ yʉ ã ĩi, “Yʉ cáaátopʉ mʉja aá majiquetigarã,” ¿cʉ ĩti? ");
INSERT INTO tav_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu maca ocõo bairo na caĩwĩ: —Mʉjaa ati yepa macana mʉja ã mʉja roque. Yʉ maca jõ buipʉ macacʉ yʉ ã. Ati yepa macacʉ mee yʉ ã. ");
INSERT INTO tav_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","To bairi mepʉbʉja mʉjaare yʉ ĩ buiobapʉ. Caroorije cáti aninucurãpʉna mʉja bai yajigarã, yʉ ĩwʉ. Mʉjaa, “Dio cʉ cajooricʉ cʉna ãmi,” yʉre mʉja ĩ nʉcʉbʉgoquẽe. To bairi rooro cáti aninucurãpʉna mʉja bai yajigarã, mʉja yʉ ĩ tunu. ");
INSERT INTO tav_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ocõo bairo caĩ jeniñawã Jesure: —¿Ñamʉ majuu mʉ ãti mʉa? Ocõo bairo na caĩwĩ Jesu: —Mere nemoo mʉjaare yʉ buiotʉgabapʉ. ");
INSERT INTO tav_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Capee majuu ã rooro mʉja cátie buiori mʉjaare yʉ capopiyeyepe. Yʉre cajooricʉ maca cariapena buiomi. To bairi yʉ Pacʉ cʉ cabuioriquere caapiricʉ aniri tiere yʉ buio neto ati yepa macanare tunu, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","To bairo na cʉ caĩ buiorijere caapi majiquẽma. Cʉ maca cʉ Pacʉre buioʉ caĩbami. ");
INSERT INTO tav_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","To bairi ocõo bairo na caĩwĩ Jesu tunu: —Yucʉ tẽorica pãipʉ yʉre mʉja tu mʉgo nʉcorãpʉ Dio Macʉ yʉ cãniere mʉja majigarã. “Cʉ cabooro átiquẽemi,” yʉre mʉja ĩ majigarã. Yʉ Pacʉ yʉre cʉ cabuiorique cõona mʉjaare yʉ buio. ");
INSERT INTO tav_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉre cajooricʉ yʉ mena ãmi. Jĩcaʉna yʉ cũquẽemi. Cʉ catʉjoorije jeto yʉ átinucu. To bairi yʉre rocaqueti majuucõami. ");
INSERT INTO tav_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","To bairo Jesu cʉ caĩrijere apirã camaja capãarã cʉ caapi nʉcʉbʉgowã. ");
INSERT INTO tav_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ocõo bairo caĩwĩ Jesu judío majare, “Cañuʉna ãcʉmi,” cʉ caĩ tʉgooñarãre: Mʉjaare yʉ cabuiorijere mʉja caapi nʉcʉbʉgoata yʉ yarã majuu mʉja anigarã. ");
INSERT INTO tav_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Cariape macajere mʉja majigarã. Cariape macajere camajirã mʉja cãno apeĩ cʉ carotiro, cʉ pojare bairo cãna mʉja aniquetigarã, caĩwĩ Jesu. To bairo ĩi, Sataná cʉ carotirã mʉja aniquetigarã ĩi, caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","To bairo cʉ caĩro: —¿Nope ĩi, “Apeĩ cʉ carotiro, cʉ pojare bairo cãna mʉja aniquetigarã,” mʉ ĩti? Abraham pãramerãna jã ã. Apeĩ cʉ carotirijere cáti aninucurã mee jã anitʉga, cʉ caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu ocõo bairo na caĩnemowĩ tunu: —Cariapena mʉjaa yʉ ĩ: Nipetirã caroorije cána rooro na cátinucurijere jana majiquẽema. To bairi caroorijere áticõa aninucuma. ");
INSERT INTO tav_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jĩcaʉ apeĩre cʉ paabojari majocʉ cʉ ʉpaʉ ya wii macacʉ majuu, cʉ ʉpaʉ macʉre bairo cãcʉ aniquẽemi. Cʉ ʉpaʉ macʉ maca ti wii macacʉ majuu ãmi. ");
INSERT INTO tav_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","To bairi yʉ Dio Macʉ aniri caroorijere mʉja cátinucurijere carotiire cʉ rocaʉ acʉ́ yʉ cáapʉ́. To bairo mʉjaare cʉ yʉ carocabojaro bero cariapena apeĩ cʉ carotiquẽna majuu mʉja anicõagarã yua. Sataná yarã, cʉ poja mʉja aniquetigarã. ");
INSERT INTO tav_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mere yʉ majitʉga Abraham pãramerã mʉja cãniere. Cʉ pãramerã anibana quena yʉ cabuiorijere cabai netoo nʉcarã mʉja ã. To bairi yʉre cajĩaga coterã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉ Pacʉ yʉre cʉ cabuio roti jooriquere mʉjaare yʉ buio. Mʉja quena mʉja pacʉ cʉ carotirijere apiri tiere mʉja átinucu. ");
INSERT INTO tav_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na maca ocõo bairo cʉ caĩwã: —Jã pacʉ Abraham ãmi. ");
INSERT INTO tav_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ocõo bairo na caĩwĩ Jesu tunu: —Abraham pãramerã majuu mʉja cãmata cʉ cátinucuriquere bairona mʉja átiborã. Yʉ Pacʉ yʉre cʉ cabuiorijere, cariape cãniere yʉ cabuiobato quena yʉre mʉja jĩaga cote. Abraham to bairo cátiquẽcʉ cãñupi. ");
INSERT INTO tav_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉja pacʉ cʉ cátinucurore bairona mʉja áa, na caĩwĩ Jesu. To bairo cʉ caĩro apirã ocõo bairo cʉ caĩwã: —Jã pacʉa punaa majuu jã ã. Cáti epericarã punaa mee jã ã. To bairi Dio jã Pacʉna ãmi. ");
INSERT INTO tav_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu na caĩwĩ tunu: —Cariapena, “Dio jã Pacʉna ãmi,” mʉja caĩata yʉre mʉja nʉcʉbʉgoborã. Yʉa Dio mena cãnacʉ yʉ cáapʉ́. Yʉ majuuna yʉ cabooro yʉ cáatíquẽpʉ. Dio majuuna yʉre cajoowĩ. ");
INSERT INTO tav_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nope ĩrã yʉ cabuiorijere mʉja api puo majiquẽeti? Ocõo bairo ã: Yʉ cabuiorijere mʉja api nʉcʉbʉgogaquẽe. To bairona mʉja bai. ");
INSERT INTO tav_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉja pacʉ Satanána ãmi. Cʉ yarã mʉja ã. To bairi cʉ caboorije macare mʉja átiganucu. Nemoopʉna camajare cajĩa rei cãnitʉgayupi. Cariape cátiquẽcʉ majuu ãmi. Jĩca wame unoacã cariape buioquetinucumi. Jocʉna ĩnucumi, to bairona caĩto paii cãnaje cʉtinucuʉ aniri. Caĩto paii aniri caĩto pairã pacʉre bairona cãcʉ ãmi, nare carotii aniri. ");
INSERT INTO tav_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","To bairi mʉjaa cʉ mena macana aniri cariape macaje yʉ cabuiorije macare mʉja apiʉjaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ni maca mʉja mena macacʉ, “Ati wame majuu caroorije cátacʉ mʉ ã,” cariapena yʉre cʉ ĩ majiti? Cariape yʉ cabuiorije to cãnibato quena yʉre mʉja api nʉcʉbʉgogaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dio yarã caroaro apiʉjama Dio ye quetire. Mʉjaa Dio yarã aniquetibana yʉ cabuiorijere mʉja api nʉcʉbʉgogaquẽe, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","To bairo cʉ caĩro apirã ocõo bairo cʉ caĩwã judío maja: —Jocarã mee jã ĩ Samaria macacʉ mʉ ãcʉ. Cawãti cʉgoʉ mʉ ãcʉ, cʉ caĩwã Jesure. ");
INSERT INTO tav_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","To bairo na caĩro: —Cawãti cʉgoʉ mee yʉ ã. Yʉ cátinucurijere yʉ Pacʉre cʉ nʉcʉbʉgoʉ yʉ áa. Mʉja maca yʉ cátiere tʉjʉrã, “Caroorije cácʉ ãmi,” yʉre mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Caroaro yʉ cátinucurijere ácʉ camaja, “Cãni majuʉ ãmi,” yʉre na ĩato ĩi mee yʉ bai. Jĩcaʉ ãmi Dio, “Cãni majuʉ ãmi,” yʉre caĩ buioʉ. To bairi yʉre canʉcʉbʉgoquẽnare na popiyeyegʉmi. ");
INSERT INTO tav_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cariapena mʉja yʉ ĩ: Yʉ cabuiorijere caapiʉjarã bai yajiquetigarãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","To bairo cʉ caĩro apirã ocõo bairo cʉ caĩwã judío maja: —“Yʉ cabuiorijere caapiʉjarã bai yajiquetigarãma,” mʉ caĩrijere apiri, cariapena, “Cawãti cʉgoʉna ãmi,” mʉre jã ĩ maji. Cajʉgoye macana nipetirã Dio ye quetire cabuiori maja cabai yaji peticoajupa. Abraham quena cabai yajiyupi. ");
INSERT INTO tav_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mʉa jã ñicʉ Abraham netoro cãcʉ mʉ ãti? Dio ye quetire buiori maja tirʉmʉpʉ macana quena cabai yaji peticoajupa. To bairi, “Seeto majuu cãcʉ yʉ ã,” ¿mʉ ĩ tʉgooñati? ");
INSERT INTO tav_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","To bairo na caĩro ocõo bairo na caĩwĩ Jesu: —Yʉ majuuna, “Caroaro cácʉ yʉ ã,” yʉ caĩata yʉ cabuiorije wapa maniboro. “Dio jã Ʉpaʉ ãmi,” mʉja caĩecʉna, “Caroaro cácʉ ãmi,” yʉre ĩnucumi. ");
INSERT INTO tav_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉja maca cʉ̃re mʉja majiqueti majuucõa. Yʉ roque cʉ̃re yʉ maji. Cʉ̃re majibacʉ quena: “Cʉ̃re yʉ majiquẽe,” yʉ caĩata mʉjaare bairona ĩtorique paii yʉ aniboʉ. Cariapena yʉ ĩ, “Cʉ̃re yʉ maji,” mʉjaare yʉ caĩata. To bairi cʉ carotirijere yʉ áa. ");
INSERT INTO tav_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉja ñicʉ Abraham ati yepapʉ yʉ cáatípere queti apiri cawariñuuñupi. ");
INSERT INTO tav_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ocõo bairo cʉ caĩwã judío maja tunu: —¿Cincuenta cʉmari cʉgoquetibacʉ quena Abraham tirʉmʉpʉ macacʉre mʉ catʉjʉri? ");
INSERT INTO tav_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ocõo bairo na caĩwĩ Jesu tunu: —Cariapena mʉja yʉ ĩ. Abraham cʉ cabuiaparo jʉgoye cãniepaʉpʉna yʉ ã. ");
INSERT INTO tav_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","To bairo cʉ caĩro apirã ʉ̃ta rupaa mena cʉ̃re care jĩagabama. Cʉ maca ti wii, Dio wiipʉ cãnacʉ na watoapʉ caruti buti aámi. ");
INSERT INTO tav_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu neto aábacʉ jĩcaʉ cacape tʉjʉquẽcʉre catʉjʉwĩ. Cawimaʉpʉna cacape tʉjʉquẽcʉ cabuiaricʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jã maca Jesu buerã cʉ̃re tʉjʉrã Jesure jã cajeniñawʉ: —Ʉpaʉ, ¿nope ĩi ani cacape mácʉna cʉ cabuiayupari? ¿Noa ye wapa to bairo cabaii cʉ cabuiayupari? ¿Cʉ pacʉa ye wapa o cʉ majuuna cʉ ye wapa maca to bairo cabaii cʉ cabuiayupari? ");
INSERT INTO tav_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","To bairo jã caĩro ocõo bairo jã caĩwĩ Jesu: —Rooro cʉ cátaje wapa mena mee baimi. To bairona cʉ pacʉa ye wapa mee baimi. Cʉ jʉgori Dio caroaro cʉ cátiere iñoogʉ, to bairo cabaii cʉ cabuia carotiyupi Dio. ");
INSERT INTO tav_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yʉre Dio cʉ carotiriquere nemoona cátipaʉ yʉ ã. Caberopʉ majiriobʉjaboro. ");
INSERT INTO tav_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ati yepapʉ ãcʉ camajare na cajĩa bujubojaʉre bairona cãcʉ yʉ ã, cariape macajere na tʉjʉ majiato ĩi. ");
INSERT INTO tav_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesu to bairo ĩ yaparo cʉ ʉcoore, yepapʉ eo roca cũ átiri tiere jitare jee, catʉjʉ majiquẽcʉ capearire catu warewĩ. ");
INSERT INTO tav_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yaparo ocõo bairo cʉ caĩwĩ: —Siloé cawamecʉto na cawerica coro, ujarica coropʉ mʉ capearire tu cojeija, caĩwĩ Jesu. Siloé maca “cajooricʉ” ĩgaro ĩ. To bairo Jesu cʉ caĩro, topʉ aáti cʉ capere catu cojeyupi. Tu cojeri bero, tunu acʉ́ caroaro catʉjʉ majicoajupi yua. ");
INSERT INTO tav_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Cʉ ya wii tʉ macana to jʉgoye cacape tʉjʉquẽcʉ cʉ cãno catʉjʉricarã ocõo bairo cʉ caĩñuparã: —¿Ani cajʉgoye caniyeru jeni ruinucuecʉna cʉ anibauti? caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jĩcaarã: —Cʉna ãmi, caĩñuparã. Aperã maca: —Cʉ aniquẽcʉmi. Apeĩ cʉ̃re bairona cabauʉ ãcʉmi, caĩñuparã. Cʉ maca: —Yʉna yʉ ã, caĩñupʉ catʉjʉ majiquetibatacʉ maca. ");
INSERT INTO tav_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","To bairi cʉ caĩ jeniñañuparã: —¿Dope bairo bairi yucʉacã mʉ cape to quenoo ejati? ");
INSERT INTO tav_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ocõo bairo na caĩñupʉ cacape mácʉ cãnacʉ yua: —Jõ cãniecʉ Jesu cawamecʉcʉ jita caococʉtie mena yʉ capearire tu warewĩ. Tu ware yaparoʉ Siloé na cawerica coropʉ yʉ coje rotiwĩ. Topʉ aá, yʉ cacojero bero yʉ tʉjʉ majicoapʉ, na caĩ buioyupʉ. ");
INSERT INTO tav_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Cʉ caĩ jeniñanemoñuparã tunu: —¿Noopʉ cʉ ani cʉ̃a? —Yʉ majiquẽe. Noopʉ ãcʉ ãcʉmi, caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Cabero cacape tʉjʉ majiquetacʉre fariseo maja tʉpʉ cʉ cane aájuparã cʉ̃re camajirã. ");
INSERT INTO tav_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesu cʉ̃re cʉ canetoorica rʉmʉ sábado cãmʉ, judío maja na yerijãrica rʉmʉ. ");
INSERT INTO tav_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","To bairi cacape tʉjʉ majiquetibatacʉre cajeniñañuparã fariseo maja tunu: —¿Dope bairo bairi caroaro mʉ tʉjʉti? To bairo na caĩro ocõo bairo na caĩ yʉwĩ: —Jĩcaʉ yʉ capearire jita caococʉtie mena tu warewĩ. Tiere yʉ cacojero bero caroaro yʉ tʉjʉ majicoapʉ, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jĩcaarã fariseo maja ocõo bairo cʉ caĩñuparã: —Manire yerijãrica rʉmʉre to bairo cácʉ ũcʉ Dio yaʉ aniquẽemi. Dio cʉ cajooricʉ cʉ cãmata yerijãrica rʉmʉre nʉcʉbʉgoboʉmi. Aperã maca ocõo bairo caĩñuparã: —Caroorije cácʉ cʉ cãmata atie caroare áti iñoo majiquetiboʉmi, caĩñuparã. To bairi ricati jeto cʉ caĩ tʉgooñañuparã Jesure. ");
INSERT INTO tav_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Cabero cacape tʉjʉquetacʉre cʉ caĩ jeniñañuparã tunu: —Mʉate, ¿dope bairo mʉ ĩti mʉ catʉjʉro cátacʉre? Ocõo bairo na caĩ yʉyupʉ: —Yʉa, Dio ye quetire cabuioʉ ãcʉmi, yʉ ĩ. ");
INSERT INTO tav_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judío maja, “Cajʉgoye cacape tʉjʉ majiquẽcʉ cãmi,” caĩrijere caapi nʉcʉbʉgogaquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","To bairi cʉ pacʉare pijori ocõo bairo na caĩ jeniñañuparã: —¿Ani mʉ macʉna cʉ ãti? ¿Cawimaʉpʉna cacape tʉjʉquẽcʉ cʉ cabuiari? ¿Dope bairo bairi cʉ tʉjʉcoati yucʉra? ");
INSERT INTO tav_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Cʉ pacʉa maca ocõo bairo na caĩ yʉyuparã: —Ʉ̃ʉjʉ, jã macʉna ãmi. To bairona cacape tʉjʉquẽcʉ cabuiawĩ. Tie jetore jã maji. ");
INSERT INTO tav_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Dope bairo baicõari yucʉacã tʉjʉʉmi, jã ĩ majiqueticʉpʉ. Cʉ capearire caquenooricʉ quenare jã majiquẽe. Cʉ̃rena jeniñaña. Cawimaʉ me ãmi. To bairi cʉ majuuna buio majimi, caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cʉ pacʉa uwirã to bairo caĩñuparã. Cajʉgoye judío maja ʉparã ocõo bairo caĩñuparã: “Noa Jesure, ‘Dio cʉ cajooricʉna ãmi,’ caĩrã unare Dio wiipʉna mani re buugarã. To bairo caĩrã unare mani mena mani neñapo bue rotiquetigarã,” caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","To bairo na caĩriquere uwirã, “Cawimaʉ me ãmi. Cʉ̃rena cʉ jeñiñaña,” caĩñuparã cʉ pacʉa. ");
INSERT INTO tav_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","To bairi judío maja ʉparã cacape tʉjʉquetacʉre cʉ catunuo pijoyuparã tunu. Cʉ̃re: —Dio cʉ caapijoropʉre cariape buioya. Mʉre catʉjʉ majiro cátacʉ carooʉ ãmi, jã ĩ maji, cʉ caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ocõo bairo na caĩñupʉ cʉ maca: —Carooʉ ãcʉmi o cañuʉ ãcʉmi, cʉ yʉ ĩ majiquẽe. Atie jetore yʉ maji. To jʉgoyepʉ catʉjʉquẽcʉ yʉ cãmʉ. Yucʉra mere yʉ tʉjʉ majicõa yua. ");
INSERT INTO tav_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na maca cʉ caĩ jeniñanemoñuparã tunu: —Mepʉ ¿dope bairo mʉre cʉ átí? ¿Dope bairo cʉ cáto mʉ capeari mʉ tʉjʉ majiri? ");
INSERT INTO tav_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","To bairo na caĩro: —Mere mʉjaare yʉ buiotʉgabapʉ. Yʉre mʉja apiʉjaquẽpʉ. ¿Nope ĩrã yʉre mʉja jeniñanemoti tunu? ¿Mʉja quena cʉ̃re caapiʉjarã mʉja anigati? ");
INSERT INTO tav_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","To bairo cʉ caĩro apirã cʉ caĩ tutiyuparã yua: —Mʉna cʉ apiʉjaya. Jã roque Moisé cʉ carotirique macare jã apiʉjagarã. ");
INSERT INTO tav_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisére Dio cʉ cabuioyupi, jã ĩ maji. Mʉre canetooricʉ macare noa na carotiricʉ ãcʉmi, jã ĩ majiquẽe. ");
INSERT INTO tav_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ocõo bairo na caĩñupʉ cʉ maca: —¡Ayo name! Yʉre catʉjʉquetacʉre caquenoʉ cʉ cãnibato quena, Noa na carotiricʉ ãcʉmi, ¿mʉja ĩ majiquẽeti? ");
INSERT INTO tav_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Caroorã cʉ̃re na cajenirijere yʉquẽcʉmi Dio, caroaro mani ĩ maji. Cʉ̃re canʉcʉbʉgorãre cʉ caboorije cána jetore na yʉʉmi. ");
INSERT INTO tav_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jĩcani uno, “Jĩcaʉ cawimaʉpʉna cacape tʉjʉquẽcʉ cabuiaricʉre cʉ catʉjʉro cájupʉ,” camaja na caĩro apiya maa. ");
INSERT INTO tav_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dio cʉ cajooricʉ mee cʉ cãmata yʉ catʉjʉro áti majiquetiboricʉmi. ");
INSERT INTO tav_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","To bairo cʉ caĩro na maca ocõo bairo cʉ caĩñuparã: —Nemoopʉna carooʉ cabuiaricʉ anibacʉ quena ¿jãre mʉ buiogati? To bairo cʉ ĩ tutiri na mena caneñapo buenemo rotiquẽjuparã yua. ");
INSERT INTO tav_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","To bairo catʉjʉ majiquetibatacʉre cʉ na caroca buuriquere quetire caapiwĩ Jesu. To bairi cʉ bʉga ejaʉ ocõo bairo cʉ caĩwĩ: —¿Mʉa Dio Macʉre canʉcʉbʉgoʉna mʉ ãti? ");
INSERT INTO tav_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","To bairo cʉ caĩro: —Ʉpaʉ, cʉ̃re yʉ nʉcʉbʉgogacʉpʉ. To bairi yʉ buioya, ¿nii majuu cʉ ãti cʉ̃a? Jesure cʉ caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Mere mʉ catʉjʉecʉna yʉ ã. Mʉ mena cawada peniina yʉ ã, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","To bairo cʉ caĩro apii Jesu tʉna ejacumu, ocõo bairo cʉ caĩwĩ: —Ʉpaʉ, mʉre yʉ api nʉcʉbʉgo majuucõa. ");
INSERT INTO tav_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","To bairo cʉ caĩro: —Dio ye quetire camajiquẽna cacape tʉjʉquẽnare bairona ãma. Na catʉjʉ majipere joʉ acʉ́ yʉ cáapʉ́. Aperã maca, “Dio ye quetire camajirã jã ã,” ĩ tʉgooñanucuma. To bairo ĩ tʉgooñabana cacapea tʉjʉquẽnare bairona anicõa aninucugarãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","To bairo cʉ caĩro apirã jĩcaarã fariseo maja topʉ cãna ocõo bairo cʉ caĩwã: —Jã quenare, “Cacape tʉjʉquẽnare bairona cãna ãma, Dio yere camajiquẽna aniri,” ¿jãre mʉ ĩti? cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu maca na caĩ yʉwĩ: —Cacape tʉjʉquẽnare bairo Dio yere camajiquẽna mʉja cãmata seeto cabai buicʉna mʉja aniquetiborã. “Caroaro camajirã jã ã,” caĩrã aniri cabui pacoorã majuu mʉja ã, na caĩ yʉwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Jesu camajare na buionemoʉ, ocõo bairo buio majiorica wame mena na caĩ buiowĩ: —Cariapena mʉjaare yʉ ĩ. Nuricarã ovejare cacotei oveja na cãni janiro macá jope na cajani jãarica jopepʉ jetore jãʉmi. Aperã ovejare cajee rutigarã maca cajope manona jãarãma. ");
INSERT INTO tav_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jopere cacotei maca ovejare cacoteire cʉ pã jõʉmi. To bairo cʉ cajãaro oveja cʉ cawadarijere api majirãma nare cacoteire. Ovejare cacotei na wamere piimi. To bairo nare cʉ capiro apirã cʉ̃re ʉjanucurãma. ");
INSERT INTO tav_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nare pi buti aáti na jʉgo aácʉmi. Cʉ cawadarijere api majirã cʉ bero cʉ ʉja nutuanama. ");
INSERT INTO tav_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Apeĩ na ʉpaʉ cãniquẽcʉre, na catʉjʉ majiquẽcʉre cʉ ʉjaquẽnama. Cʉ cawadarijere api majiquẽnama. To bairi noo cabooro cʉ ruti batecoanama, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Fariseo maja atie buio majiorica wame mena cʉ cabuiorijere to bairo ĩgʉ ĩmi caĩ majiquẽma. ");
INSERT INTO tav_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Na caapi majiquẽto tʉjʉʉ ocõo bairo na caĩnemowĩ Jesu tunu: —Cariapena mʉjaare yʉ ĩ: Yʉna oveja na cajãari jopere bairona cãcʉ yʉ ã. To bairi yʉ jʉgori camaja Dio tʉpʉ aá majigarãma. ");
INSERT INTO tav_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","9","To bairi yʉre caapi nʉcʉbʉgorãre na yʉ netoogʉ rooro na catamʉoboriquere. Nare yʉ cotegʉ. Caroaro yʉ mena anicõagarãma. Caroa na caboorije na yʉ joocõa anigʉ. Oveja nare cacotei caroa ta cãnopʉre nare cʉ cajʉgo buti aátore bairona caroaro na yʉ jʉgo anigʉ yʉre caapiʉjarãre. Aperã yʉ jʉgoye cáatána, caroorã maca ovejare jee rutiri majare bairona cãñupa, ĩtorique mena cabuiorã aniri. To bairi oveja maca na cawadarijere api majiquetiri nare caʉjaquẽjupa. ");
INSERT INTO tav_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ovejare jee rutiri maja nare jee ruti, jĩa regarãma. Yʉ maca catícõa aninucuriquere na joʉ acʉ́ yʉ cabaiwʉ. To bairi caroaro majuu na ani wariñuunucucõato ĩi yʉ cáapʉ́ ati yepapʉre. ");
INSERT INTO tav_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Ovejare caroaro cacoteire bairo cãcʉ yʉ ã. Caroaro cacotei cʉ yarã ovejare apeĩ yai ũcʉ nare cʉ caʉgagaro tʉjʉʉ nare matabojaʉ, cʉ cabuti aáto cʉ macare cʉ jĩa ʉgaboʉmi carooʉ. ");
INSERT INTO tav_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Apeĩ maca ovejare cacotebojaʉ, cacotei majuu mee maca cʉ cacotebojarique wapa jetore tʉgooñaʉmi. To bairi yai cʉ cáató tʉjʉʉ to bairona na re nʉco, atʉ ruti aácʉmi. Cʉ yarã majuu na cãniquẽto maca to bairo ácʉmi. To bairo cʉ caruti aáto bero yai maca atí, ovejare na ñe, na acʉo re bate peocõaʉmi. ");
INSERT INTO tav_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ovejare cacotebojaʉ nare cacotei majuu aniquetiri to bairo na tʉjʉ ʉjaquẽcʉmi. Cʉ yarã majuu na cãniquẽto maca cʉ cawapatarije jeto tʉgooñaʉmi. ");
INSERT INTO tav_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Yʉa ovejare caroaro cacote majiire bairona yʉ ã, oveja ʉpaʉre bairona. Yʉ Pacʉ yʉre majimi. Yʉ quena cʉ̃re yʉ maji. To bairona yʉ quena yʉ yarã yʉre caapiʉjarãre na yʉ maji. Ovejare cacotei cʉ yarã ovejare nare cʉ catʉjʉ majirore bairona yʉ quena yʉre caapiʉjarãre na yʉ tʉjʉ maji. Na quena yʉre majima. Na anicõa aninucuato ĩi na yʉ bai yajibojagʉ. ");
INSERT INTO tav_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aperã judío maja aniquetibana quena yʉ yarã ãma na quena. Na quenare yʉ tʉpʉ na yʉ jee neogʉ. Na quena yʉ cabuiorijere api nʉcʉbʉgogarãma. Nipetirã yʉre canʉcʉbʉgorã jĩca poa macanana anigarãma. Yʉna ovejare cacoteire bairona jĩcaʉna cãcʉ yʉ anigʉ. ");
INSERT INTO tav_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Camajare na yʉ cabai yajibojapere ĩi, yʉre maimi yʉ Pacʉ. ");
INSERT INTO tav_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jĩcaʉ maca cʉ majuuna yʉre jĩa majiquẽcʉmi. Yʉ majuuna yʉ carotiro yʉre jĩagarãma. Yʉre na cajĩaro yʉ roti maji. Yʉre na cajĩarije cãnibato quena yʉ tunu catí maji. Yʉ Pacʉ to bairona yʉre cáti rotiwĩ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judío maja to bairo cʉ caĩro apirã ricati jeto catʉgooñawã. ");
INSERT INTO tav_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jĩcaarã ocõo bairo caĩwã: —¿Nope ĩrã cʉ̃re mʉja apiti? Camecʉ ãmi. Cawãti cʉgoʉ ãcʉmi, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aperã maca: —Cawãti cʉgoʉ maca to bairo buioquetiboʉmi. Cawãti cʉgoʉ cacape tʉjʉquẽcʉre cʉ catʉjʉro áti majiquẽcʉmi, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Pue cãno judío maja tirʉmʉpʉ macana Dio wiire áti peorã na catʉgooñari rʉmʉ boje rʉmʉ cãmʉ. Ti boje rʉmʉ na cáti paʉ Jesu cáaámi Dio wiipʉ. ");
INSERT INTO tav_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Dio wiipʉre aá, Salomón ya arʉa cawamecʉtopʉ jãa, cʉ canetogari paʉ judío maja ʉparã cʉ̃re carupa beto cʉ amojore nʉca ejari, ocõo bairo cʉ caĩ jeniñawã: —Jãre ĩtoʉ mʉ áticõabapa mʉa. ¿Noo cõopʉ majuu cariape jãre mʉ buioʉati? Dio cʉ cajooricʉna mʉ cãmata cariapena jãre buioya, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","To bairo cʉ na caĩro ocõo bairo na caĩwĩ Jesu: —Mere mʉjaare yʉ buiotʉgabapʉ. Yʉre mʉja api nʉcʉbʉgoquẽpʉ. Yʉ Pacʉ cʉ carotiro mena yʉ cátie jʉgori Dio cʉ cajooricʉ yʉ cãniere mʉjaare yʉ iñoo. ");
INSERT INTO tav_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Cʉ carotiro mena yʉ cáti iñoorije to cãnibato quena yʉre mʉja api nʉcʉbʉgoquẽe. Yʉ yarã aniquetibana yʉre mʉja api nʉcʉbʉgoquẽe, na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","—Yʉ yarã maca yʉre api nʉcʉbʉgoma, oveja nare cacotei cʉ cawadarijere na caapi majirore bairona. Yʉ yarãre na yʉ tʉjʉ maji. Yʉre api nʉcʉbʉgori yʉre ʉjama. ");
INSERT INTO tav_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","To cãnacã rʉmʉ catícõa ãnajere na yʉ joo nare. To bairi yajiquetigarãma. Caroaro na yʉ cʉgo. Yʉ mena cãnare yʉ ema majiquetigarãma aperã maca. ");
INSERT INTO tav_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉ Pacʉ nare yʉ cajoowĩ. Cʉ̃a nipetirã netoro catutuaʉ ãmi. To bairi aperã maca yʉ Pacʉ cʉ cacʉgorãre cʉ ema majiquetigarãma. ");
INSERT INTO tav_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉ, yʉ Pacʉ mena jĩcaʉna jã ã. ");
INSERT INTO tav_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","To bairo cʉ caĩro apirã judío maja ʉ̃ta rupaa mena cʉ care jĩagawã. ");
INSERT INTO tav_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","To bairo na cátigaro tʉjʉʉ ocõo bairo na caĩwĩ Jesu: —Yʉ Pacʉ cʉ cáti majirije mena caroare capee mʉjaare yʉ cáti iñoowʉ. ¿Di wamere yʉ cátaje wapa yʉre mʉja re jĩagati? na caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na maca Jesure cʉ caĩwã: —Caroaro mʉ cátaje wapa mʉre jã jĩaquẽna. Diore rooro mʉ caĩrije wapa mʉre jã jĩaga. Mʉa camajocʉ anibacʉ quena Diore bairo mʉ aniga. Tie wapa mʉre jã jĩaga, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","To bairo na caĩro ocõo bairo na caĩwĩ Jesu tunu: —Dio cʉ carotiriquere ucarica pũuri mʉja cacʉgorije ocõo bairo ĩ ucarique ã: “Mʉja quena Diore bairona cãna mʉja ã.” ");
INSERT INTO tav_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mani maji: Dio ye queti ucarica pũuripʉ caĩrijere, “To bairo caĩtorije ã,” ĩ majiña maa. Dio ye queti caapi nʉcʉbʉgorãre, “Mʉja quena Diore bairona cãna mʉja ã,” na caĩñupi. ");
INSERT INTO tav_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dio ati yepapʉre yʉre joogʉ yʉ cabejewĩ. ¿Nope ĩrã que mʉja maca, “Dio Macʉ yʉ ã,” yʉ caĩrije jʉgori, “Diore rooro caĩi mʉ ã,” yʉre mʉja ĩti? ");
INSERT INTO tav_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ Pacʉ yʉre cʉ carotiro mena yʉ cátiquẽpata yʉre api nʉcʉbʉgoqueticõaña. ");
INSERT INTO tav_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Cʉ carotiro mena yʉ cáto maca yʉ cáti iñoorijere tʉgooña nʉcʉbʉgoya, yʉre nʉcʉbʉgoquetibana quena. Tiere mʉja catʉgooña nʉcʉbʉgoata yʉ Pacʉ yʉ mena cʉ cãniere mʉja majigarã. To bairi yʉ quena jĩcaʉna yʉ Pacʉ mena yʉ cãniere mʉja majigarã, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","To bairo cʉ caĩ buiorijere apiri presopʉ cʉ cane aágabama tunu. Cʉ maca nare caruticoami. ");
INSERT INTO tav_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Cabero Jesu Jordán i nʉgoapʉ capeña aácoami. Topʉre Juan cabautisari majocʉ cʉ cabautisanucuricaropʉ catuanʉcawĩ. ");
INSERT INTO tav_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Capãarã cʉ tʉ ejarã ocõo bairo cʉ caĩwã yua: —Cariapena caĩñupi Juan cabautisari majocʉ anire buio jʉgoyeyei. Juan apeye unie áti iñooquetibacʉ quena Jesu cʉ cabaipere cariape cabuio jʉgoyeyeyupi. ");
INSERT INTO tav_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Topʉ Jesu cʉ cãno camaja capãarã cʉ caapi nʉcʉbʉgowã. ");
INSERT INTO tav_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jesu Jordán i nʉgoapʉ cʉ cãnitoye Lásaro cawamecʉcʉ cʉ ya maca Betaniapʉ riaʉ cájupi. Cʉ jʉgoco jãa romiri María, Marta na quena ti macapʉ cãñupa. ");
INSERT INTO tav_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Cõa Maríana cãmo Jesure cʉ rʉporipʉ cajʉti ñuurijere pio peo, co poa ñapo mena catu cojerico. ");
INSERT INTO tav_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lásaro seeto cʉ cariaro tʉjʉrã cʉ jʉgoco jãa romiri aperãre Jesure cʉ cabuio roti jooyupa: —Ʉpaʉ, mʉ mena macacʉ mʉ camaii seeto riami, caĩ jooyupa. ");
INSERT INTO tav_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","To bairo tie quetire apii ocõo bairo caĩwĩ Jesu: —Cʉ riaye tamʉo, riacoagʉmi baii pʉa. Baibacʉ quena catigʉmi. To bairo cʉ cabairije jʉgori Dio cʉ catutuarijere iñoorique anigaro. Yʉ Dio Macʉ quenare, “Catutuaʉ majuu ãmi,” yʉ ĩgarãma, yʉ cátiere tʉjʉrã. ");
INSERT INTO tav_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na camaiwĩ Jesu Martare, co baio Maríare, Lásaro quenare. ");
INSERT INTO tav_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na maibacʉ quena nemoona cáaáquẽmi, tie quetire apibacʉ quena. Pʉga rʉmʉ catuanemowĩ topʉna. ");
INSERT INTO tav_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cabero jã caĩwĩ: —Jitá Judeapʉ tunu. ");
INSERT INTO tav_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ocõo bairo cʉ jã caĩwʉ jã maca: —Ʉpaʉ, cãnʉ to macana judío maja ʉ̃ta rupaari mena mʉre care jĩagabama. ¿Mʉre na cajĩagarije to cãnibato quena topʉ mʉ tunu aágati tunu? Jesure jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","To bairo cʉ jã caĩro: —To cãnacã rʉmʉna doce hora jeto buju. To bairi cabujuropʉ ʉmʉrecopʉ aáteñarã mʉja pʉga ta roca cumuquẽna. Ʉmʉrecopʉ cabujuro maca to bairo mʉja aá maji, ñaquẽnana. Ocõo bairo ã: Dio cʉ cabooro mʉja cáto rooro mʉja tamʉoquetigarã. ");
INSERT INTO tav_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Canaitĩaropʉ mʉja cáaápata roque nemoo cabauquẽtie jʉgori mʉja pʉga ta roca cumucõaborã. To bairona Dio cʉ cabooquẽto mʉja cápata to bairona rooro mʉja tamʉogarã, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cabero ocõo bairo jã caĩnemowĩ: —Mani mena macacʉ Lásaro canicoajupʉ. To bairi cʉ yʉ yopioʉ aágʉ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","To bairo cʉ caĩro ocõo bairo cʉ jã caĩwʉ: —Ʉpaʉ, cʉ cacaniata ñuubʉjaro. Cʉ cacaniro bero jĩacã ñuugʉmi. ");
INSERT INTO tav_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesu, “Lásaro canicoajupʉ,” ĩi, bai yajicoajupʉ ĩi, caĩwĩ. Jã maca, canirique majuure jã catʉgooñabapʉ. ");
INSERT INTO tav_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","To bairo cʉ jã caapi majiquẽto cariape jã caĩ buiowĩ Jesu: —Lásaro bai yajicoajupʉ. ");
INSERT INTO tav_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Topʉ mani cãniquẽto ñuubʉja. Yʉ wariñuubʉja caroaro mʉja cabaipere ĩi. To bairo cʉ cabai yajirije jʉgori netobʉjaro yʉre mʉja nʉcʉbʉgogarã. Jitá, Lásaro ãnacʉ cʉ cãnopʉre mani aáparo. ");
INSERT INTO tav_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás, casʉ̃rʉaricʉ na caĩi ocõo bairo jã caĩwĩ: —Jitá, Jesure cʉ na cajĩaro, mani quenare na jĩato ĩrã mani aáparo. ");
INSERT INTO tav_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesu Lásaro ya macapʉ ejaʉ cʉ̃re na cayaariquere caqueti apiwĩ. Cʉ̃re na cayaaricaro bero bapari cãnacã rʉmʉ canetocoajupe. ");
INSERT INTO tav_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lásaro ya maca Betania Jerusalén tʉacãna cãmʉ. Itia kilómetro ape kilómetro recomaca cõo yoaro cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","To bairi Jerusalén macana capãarã Marta, Maríare na tʉgooña ocabʉtiato ĩrã, na tʉpʉ cáajupá. ");
INSERT INTO tav_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","To bairi Marta Jesu cʉ caejaro queti apio cʉ̃re caboca ejawõ. María maca wiipʉna catuacõañupo. ");
INSERT INTO tav_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesu tʉpʉ ejao ocõo bairo cʉ caĩwõ: —Ʉpaʉ, atopʉ mʉ cãmata yʉ bai bai yajiquetiboricʉmi. ");
INSERT INTO tav_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Cʉ cabai yajirique to cãnibato quena, “Dio nipetiro cʉ̃re mʉ cajenirijere joʉmi,” yʉ ĩ maji, caĩwõ. ");
INSERT INTO tav_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","To bairo co caĩro: —Mʉ bai tunu catigʉmi, co caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Mere yʉ maji, cʉ caĩwõ Jesure. —Tunu catigʉmi ati yepa capetiro cabai yajiricarã nipetirã na catunu catiri paʉpʉ, caĩwõ. ");
INSERT INTO tav_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","To bairo co caĩro: —Catiriquere cajoʉ yʉ ã. Cabai yajiricarãpʉ quenare na catunu catioʉ yʉ ã. Yʉre canʉcʉbʉgorã cabai yajiricarã anibana quena catigarãma tunu. ");
INSERT INTO tav_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yucʉ cacatirã yʉre canʉcʉbʉgorã capetiqueti yeri mena anicõagarãma. To bairo yʉ caĩro ¿mʉ api nʉcʉbʉgoti? co caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Co maca cʉ caĩwõ tunu: —Ʉpaʉ, mʉre yʉ api nʉcʉbʉgo. Dio cʉ cajooricʉna Cristona, Dio Macʉna mʉ ã. Mʉna tirʉmʉpʉ macana, “Jĩcaʉ atígʉmi,” na caĩricʉna mʉ ã, caĩwõ. ");
INSERT INTO tav_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta Jesu mena wada peniri bero co baio Maríare capio aámo. Aperã na caapiquẽtopʉ ocõo bairo co caĩ buioyupo: —Mani Ʉpaʉ ejatʉgawĩ. Mere mʉre macami. ");
INSERT INTO tav_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","To bairo co caĩro apio cʉ tʉpʉ yoaro mee cáajupó. ");
INSERT INTO tav_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesu macapʉre caejaquẽmi mai. Marta cʉ̃re co cabocarica paʉpʉna cãnicõawĩ. ");
INSERT INTO tav_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María co ya wiipʉ cãnaco patowãcaro co cabuti aáto tʉjʉrã judío maja co tʉpʉ co caocabʉtiora atána co caʉja aájuparã. “Co bai ãnacʉ maja opepʉ otio aáco ácomo,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesu tʉpʉ ejao camubia roca cumu ejawõ, cʉ rʉpori tʉpʉ. Mubia roca cumu ejari ocõo bairo cʉ caĩwõ: —Ʉpaʉ, atopʉ mʉ cãmata yʉ bai bai yajiquetiboricʉmi. ");
INSERT INTO tav_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu to bairo co caĩ otiro tʉjʉʉ, cʉ̃re caʉja atána quena na caotiro tʉjʉʉ seeto tʉgooñarique pai, na cabopacoo tʉjʉwĩ. ");
INSERT INTO tav_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bopacoo tʉjʉri ocõo bairo na caĩ jeniñawĩ: —¿Noopʉ cʉ mʉja yaari? na caĩwĩ Jesu. Na maca: —Jitá, mani tʉjʉto, cʉ caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Topʉ na mena aácʉ Jesu quena caotiwĩ. ");
INSERT INTO tav_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Cʉ caotiro tʉjʉrã jĩcaarã judío maja ocõo bairo caĩwã: —Carina. Seeto cʉ camaii anibatacʉmi. ");
INSERT INTO tav_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aperã maca ocõo bairo caĩwã: —¿Ani cacape tʉjʉquẽcʉre canetooricʉ Lásarore cʉ cabai yajiquẽto cʉ áti majiboyupari? ");
INSERT INTO tav_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu seeto bopaca tʉgooñari Lásaro maja opepʉ cáaámi. Cʉ maja ope ʉ̃ta toti cãmʉ. Ti toti jope ʉ̃ta cui mena biarica toti cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","To bairi ti ope tʉpʉ ejaʉ: —Ʉ̃ta cuire ne weya, na caĩwĩ Jesu. To bairo cʉ caĩro: —Ʉpaʉ, ʉnicoatacʉmi. Bapari cãnacã rʉmʉ netocoapa cʉ̃re jã cacũ rocaricaro bero, Jesure cʉ caĩwõ Marta. ");
INSERT INTO tav_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Mʉre yʉ buiobapʉ. Yʉre mʉ canʉcʉbʉgoata Dio cʉ catutuarijere mʉ tʉjʉgo, mʉ yʉ ĩbapʉ, co caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","To bairo cʉ caĩro apirã ti totire capã woowã. Jesu ʉmʉrecoore tʉjʉ mʉgori, Diore ocõo bairo cʉ caĩwĩ: —Caacʉ, yʉ cajeniejere mʉ apitʉgawʉ. Ñuu majuucõa. ");
INSERT INTO tav_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉ maji yʉre mʉ caapicõa aninucurijere. Ati majare caroaro na yʉ cátibojaparo jʉgoye, “Dio cʉ cajooricʉna ãmi,” yʉre na ĩ nʉcʉbʉgoato ĩi to bairo mʉ yʉ jeni. ");
INSERT INTO tav_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","To bairo Diore jeniri bero seeto awajarique mena ocõo bairo caĩwĩ: —¡Lásaro, buti ajá! caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","To bairo Jesu cʉ caĩrona cabai yajiricʉ cabuti amí cʉ maja opepʉre. Cʉ wamori, cʉ rʉpori jutii mena dʉrericʉ cãmi. Cʉ rʉpoa quena jutii ajero mena na caumarica cãmʉ. To bairi Jesu ocõo bairo na caĩwĩ: —Cʉ̃re mʉja cadʉrerica ajerire õwari cʉ ruu jooya. ");
INSERT INTO tav_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Capãarã judío maja Maríare catʉjʉrã atána Jesure cʉ canʉcʉbʉgowã. “Dio cʉ cajooricʉna ãmi Jesu,” cʉ caĩ nʉcʉbʉgowã to bairo Lásarore cʉ catunu catioriquere tʉjʉri. ");
INSERT INTO tav_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aperã maca cʉ̃re canʉcʉbʉgoquẽna aniri fariseo majare cawadajãrã aáma. ");
INSERT INTO tav_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","To bairi fariseo maja sacerdote maja ʉparã mena caneñapoyuparã. Neñapori ocõo bairo caame ĩñuparã: —¿Dope bairo mani ánaati? Jesu maca capee majuu caroa wameri áti iñoʉ áami. ");
INSERT INTO tav_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cʉ̃re mani cacamotaquẽpata nipetirã cʉ̃re canʉcʉbʉgorã anigarãma. To bairi Roma macana ʉparã na polisíare joogarãma. Na joori mani ya macapʉ cãni wii Dio wiire roca roti joogarãma. Mani ya maca, nipetirije mani cãniecʉtie quenare re roti joogarãma. ");
INSERT INTO tav_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","To bairi jĩcaʉ na mena macacʉ Caifá cawamecʉcʉ ti cʉmare sacerdote maja ʉpaʉ cãñupi. To bairi cʉ maca ocõo bairo na caĩñupʉ: —Mʉja majiqueti majuucõa. ");
INSERT INTO tav_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mani yarã nipetirã mani ya maca macanare Roma macana na cajĩaro rooro majuu mani ya maca baiboro. To bairi jĩcaʉ jeto nare cʉ cajĩa ecooro maca ñuugaro. To bairi nipetirã ye wapa cabai yajibojaʉ anigʉmi. ");
INSERT INTO tav_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifá cʉ majuu tʉgooñari to bairo caĩñupʉ. Ti cʉma sacerdote maja ʉpaʉ cʉ cãnie jʉgori Diona to bairo cʉ catʉgooñaro cájupi. To bairi, judío majare Jesu na bai yajibojagʉmi ĩi, to bairo caĩñupʉ Caifá. ");
INSERT INTO tav_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesu judío maja cãna jeto meere cabai yajibojayupi. Dio punaa cãna nipetirãre ati yepa nipetiropʉre cãni baterã nipetirã jĩca poa cʉ punaa na ãmaro ĩi, na cabai yajibojayupi Jesu. ");
INSERT INTO tav_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","To bairo na caneñapo wadapeniri rʉmʉna, “¿Dope bairo átiri Jesure mani jĩabocʉti?” caame wadapeni jʉgóyuparã yua. ");
INSERT INTO tav_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","To bairi Jesu cʉ̃re na cajĩagarijere majiri judío maja na catʉjʉropʉ cáaáteñaquẽmi. To bairi Judeapʉre buti, jĩca maca Efraín cawamecʉti maca cayucʉ mani maca cãnopʉre cáaámi. Ti macapʉ jã mena cʉ buerã mena catuawĩ. ");
INSERT INTO tav_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mere petoacã carʉjawʉ judío maja na boje rʉmʉ pascua na caĩri rʉmʉ caejaparo. Camaja capãarã Jerusalẽpʉ cáaájupa ti boje rʉmʉ jʉgoye caroorije na cátajere na carerije iñoogarã. ");
INSERT INTO tav_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ti macapʉ ãnaa Jesure cʉ tʉjʉgarã camacañuparã. Dio wiipʉ ãnaa caame ĩ jeniñañuparã: —¿Mʉja catʉgooñaata boje rʉmʉ cãno cʉ atígabauti? ");
INSERT INTO tav_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo maja, sacerdote maja ʉparã ocõo bairo caĩñuparã camajare: —Jesu topʉ ãñupʉ caĩrijere queti apirã jãre buioya, caĩ rotiyuparã. Presopʉ cʉ̃re jã jõogarã ĩrã, to bairo carotiyuparã. ");
INSERT INTO tav_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis rʉmʉri pascua boje rʉmʉ cãni paro jʉgoye Jesu Efraín cawamecʉtopʉ cãnacʉ Betania cawamecʉti macapʉ cáaámi, Lásarore cʉ catunu catiorica macapʉre. ");
INSERT INTO tav_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Topʉ cʉ caejaro cʉ caboje ʉgapere caquenoo yuubojawã. Marta jãre caʉgarique peobojao cãmo. Topʉ cãna mena Lásaro quena Jesu mena caʉga ruiwĩ. ");
INSERT INTO tav_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jã caʉgari paʉ María cajʉti ñuurije cawapa pacarije Jesu tʉre caneamó. Neatí, cʉ rʉporire capio peowõ. Cabero co poa ñapo mena catu cojewõ. To bairo co cáto ti wii nipetiro cajʉti ñuu peticoapʉ. ");
INSERT INTO tav_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","To bairo co cáto tʉjʉʉ Judas Iscariote, Jesu cʉ cabuei, caberopʉ cʉ̃re cajĩagarãre cawadajãpaʉ ocõo bairo caĩwĩ: ");
INSERT INTO tav_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Nope ĩo atie cajʉti ñuurijere aperãre mʉ nuni wapataqueti? Tiere nuni wapatao jĩca cʉma paarique wapa cõo mʉ wapataborico. Tie niyerure cabopacarãre na mʉ jooborico. ");
INSERT INTO tav_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Cabopacarãre na mai tʉjʉquetibacʉ quena to bairo caĩwĩ. Niyerure cajee ruti paii aniri caĩwĩ Judas Iscariote. Cʉ̃a jã niyerure cacotebojaʉ cãmi. To bairi jã niyeru jãrica poapʉ cãniere cajee ruticõanucuñupi. ");
INSERT INTO tav_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesu ocõo bairo cʉ caĩwĩ yua: —Co cátigari wame co áparo. Yʉre na cayaa rocapere tʉgooñari to bairo áamo. ");
INSERT INTO tav_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Cabopacarãre na joori nare mʉja átinemonucu anicõagarã. Yʉ macare caberopʉ mʉja átinemo majiquetigarã. Atopʉ mʉja mena cãnicõa aninucupaʉ mee yʉ ã. Cabopacarã maca mʉja mena cãnicõa aninucuparã ãma, caĩwĩ Jesu Judare. ");
INSERT INTO tav_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judío maja capãarã caqueti apiyupa Jesu Betaniapʉ cʉ cãniere yua. To bairi Jesure cʉ tʉjʉgarã caejawã. Lásaro cʉ catunu catioricʉ quenare cʉ tʉjʉgarã caejawã. ");
INSERT INTO tav_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesu Lásarore cʉ catunu catiorique tʉjʉrã sacerdote maja ʉparã na carotirique cátinucubatana Jesu macare cʉ caapiʉjawã capãarã. Aperã maca cabooquẽma Jesure. To bairi judío maja ricati jeto catʉgooñawã. To bairo Jesu macare na caapiʉjaro tʉjʉrã sacerdote maja ʉparã Lásaro quenare cʉ cajĩagawã, Jesure na cajĩagarore bairona. ");
INSERT INTO tav_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pascua judío maja boje rʉmʉ cãno yua camaja capãarã Jerusalẽpʉre caejawã. Na caejaricaro bero macá rʉmʉ maca Jesu boje rʉmʉ tʉjʉ acʉ́ cʉ cáatípere caqueti apiyupa. ");
INSERT INTO tav_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tiere queti apiri bo pũure pajure jee, cʉ̃re cabocara aájupa. Cʉ bocara aána ocõo bairo caĩ awaja nutuama: —¡Dio cañuu netoʉ ãmi! Cʉ cajooricʉ quenare caroa cʉ̃re to ãmaro. ¡Cʉna ãmi mani yaʉ Israel macana Ʉpaʉ! caĩ awajawã. ");
INSERT INTO tav_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu burrore cʉ tʉjʉʉ cʉ bui capeja aámi. To bairo ácʉ Dio ye queti ucarica pũuripʉ cabuiorore bairona cámí Jesu. Sacaría tirʉmʉpʉ macacʉ Dio ye quetire buiori majocʉ ocõo bairo caĩ ucayupi: ");
INSERT INTO tav_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mʉjaa Sión cawamecʉti maca macana uwiqueticõaña. Tʉjʉya, mʉja Ʉpaʉ burro bui peja nutuatími, caĩ ucayupi Sacaría. ");
INSERT INTO tav_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jã cʉ buerã nemoo atie na caucariquere, “Jesu cʉ cabaiperena caĩ ucayupa,” jã caĩ majiquẽpʉ. Cabero ʉmʉrecoopʉ cʉ catunu aáto bero jã camajiwʉ yua. “Dio ye queti ucarica pũuripʉ to caĩricarore bairona cariapena cabaiwʉ Jesure,” jã caĩ majiwʉ. ");
INSERT INTO tav_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lásarore na cayaa rocaricʉpʉre Jesu cʉ̃re cʉ tunu catioriquere catʉjʉricarã aperãre na cabuioyupa. “Lásaro na cayaa rocaricʉ cʉ cãnibato quena cʉ catunu catioyupi Jesu, cʉ ãnacʉre pi buujori,” na caĩ buionucuñupa. ");
INSERT INTO tav_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","To bairi ti wame Jesu cʉ cáti iñooriquere caqueti apiricarã aniri cʉ caboca tʉjʉra ajupa. ");
INSERT INTO tav_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseo maja maca to bairo na cáto tʉjʉrã na majuu ocõo bairo caame ĩñuparã: —Tʉjʉya mʉjaa to bairo cabairijere. Camaja cʉ mena jeto aá peticoapa. Dope bairo na mani áti mata majiquẽna. ");
INSERT INTO tav_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalẽpʉ pascua boje rʉmʉ cãno Diore canʉcʉbʉgorã caneñaporicarã watoapʉ jĩcaarã griego maja quena caejawã. ");
INSERT INTO tav_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Naa Jesure cʉ tʉjʉgarã Felipe tʉpʉ caejawã. Felipe maca Betsaida Galilea yepapʉ cãni maca macacʉ cãmi. To bairi: —Jesure jã tʉjʉga, caĩwã Felipere griego maja. ");
INSERT INTO tav_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","To bairo na caĩro Felipe Andrére cʉ cabuioʉ aámi. Cabero na pʉgarãpʉna Jesu tʉpʉ aá, cʉ caĩ buiowã. ");
INSERT INTO tav_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","“Griego maja mʉ tʉjʉgarã ejama,” na caĩro apii ocõo bairo caĩwĩ Jesu: —Petoacã rʉja yʉ camaja tʉpʉ Dio cʉ cajooricʉ aniri bai yajiri bero yʉ catunu catí wamʉ aáparo. ");
INSERT INTO tav_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cariapena mʉja yʉ ĩ. Mani caotebori apeare mani caotequẽto to bairona tuacõa tia jetona. Ti apeare jitapʉ mani caotero puticoato. Caputiro bero ti ape ãnato boacoato. To caboarije to cãnibato quena bʉcʉa, tia netobʉjaro capee ricacʉto. To bairo cabairijere bairona yʉ bai yaji, bai yajiri bero yʉ catunu catirije jʉgori Dio punaa capãarã anigarãma. ");
INSERT INTO tav_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ati yepa macajere camai netorã una maca catícõa aninucuquetigarãma. Ati yepa macajere camaiquẽna maca ʉmʉrecoopʉ catícõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yʉ carotirijere cátigarã yʉ cátore bairo na áti ʉjaato. Yʉ mena macana anigarãma yʉ cãni paʉpʉre. Yʉ carotirijere cáti nʉcʉbʉgorãre caroa majuure na joogʉmi yʉ Pacʉ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ocõo bairo caĩwĩ Jesu: —Yucʉacã seeto yʉ tʉgooñarique pai. ¿Dope bairo Diore cʉ yʉ ĩ jeniati? “Caacʉ, yʉ capopiye tamʉope to baiqueticõato. Yʉre netooña,” Diore yʉ ĩquẽe. Tierena popiye tamʉo yaji acʉ́ yʉ cáapʉ́ ati yepapʉ. ");
INSERT INTO tav_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Caacʉ, mʉ catutuarijere iñooña, caĩwĩ Jesu, Diore jeniri. To bairo cʉ caĩro bero jĩcaʉ ʉmʉrecoopʉ cʉ cawadarijere jã caapiwʉ. Ocõo bairo caĩwĩ: —Yʉ catutuarijere mere yʉ áti iñoonucuwʉ. Yʉ iñoonemogʉ tunu, caĩwĩ Dio ʉmʉrecoopʉ wadaʉ. ");
INSERT INTO tav_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jĩcaarã ʉmʉrecoopʉ cawadarijere apirã: —Bʉpo bʉjʉwĩ, caĩwã. Aperã maca: —Dio tʉ macacʉ apeye unie Jesure cʉ buiowĩ, caĩwã. ");
INSERT INTO tav_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu maca ocõo bairo na caĩwĩ: —Yʉre api rotii mee wadawĩ. Mʉja macare na apiato ĩi wadawĩ. ");
INSERT INTO tav_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yucʉacãna Dio ati yepa macanare na bejegʉmi cʉ̃re caapi nʉcʉbʉgoquẽnare, na regʉ. To bairi yucʉacã ati yepa macana ʉpaʉ Satanáre cʉ roca buugʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yucʉpʉ yʉre na catu mʉgoro nipetirã yʉ yarã cãniparã yʉ mena macana na ãmaro ĩi to bairo yʉ átigʉ, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","To bairo ĩi yucʉ tẽorica pãipʉ yʉ papua tu mʉgo jĩagarãma ĩi, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Camaja tiere apirã ocõo bairo caĩwã: —Dio ye queti ucarica pũuripʉ jãre na cabue eñoro ocõo bairo jã caapiwʉ: Dio cʉ cabejericʉ Cristo catícõa aninucugʉmi, ĩrique jã caapiwʉ. ¿Mʉ maca nope ĩi camaja tʉpʉ Dio cʉ cajooricʉre yʉ tu mʉgo jĩagarãma, mʉ ĩti? ¿Ni maca cʉ ãti camaja tʉpʉ Dio cʉ cajooricʉ? cʉ caĩ jeniñawã. ");
INSERT INTO tav_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ocõo bairo na caĩwĩ Jesu: —Yʉa ati yepa macanare cajĩa bujubojaʉre bairo cãcʉ yʉ ã. Yoaroacã mee mʉja mena yʉ anigʉ. To bairi atopʉ yʉ cãno yʉ cabuiorijere apiʉjaya. To bairo mʉja caapiʉjaro majiña mano canaitĩaropʉ cãnare bairo rooro mʉja baiquetigarã. Yʉre caapiʉjaquẽna canaitĩaropʉ cãnare bairona baima. “Noopʉ aána jã baiti,” ĩ majiquẽema. ");
INSERT INTO tav_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yʉ maca mʉjaare cajĩa bujubojaʉre bairo cabaii yʉ ã, mʉja mena ãcʉ. Mʉja tʉpʉ yʉ cãno yʉre apiʉjaya. To bairi mʉja quena aperãre cajĩa bujubojarãre bairona mʉja anigarã mʉja quena, yʉ ye quetire na buiorã, caĩwĩ Jesu. To bairije ĩ buio yaparoʉ Jesu na cayaji weocoami yua. ");
INSERT INTO tav_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesu capee wameri cʉ cáti iñoobato quena judío maja cʉ caapiʉjaquẽma. ");
INSERT INTO tav_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cʉ̃re na caapiʉjaquẽto tirʉmʉpʉ macacʉ Isaía cʉ caucarica wamere bairona cabaiwʉ. Ocõo bairo caucayayupi Isaía: Jĩcaʉ mácana jã cabuiorijere apiʉjaquẽema. Mani Ʉpaʉ Dio cʉ cáti iñoorije tʉjʉbana quena apiʉjaquẽema. ");
INSERT INTO tav_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","To bairi Isaía cʉ caĩrica wamere bairona Jesure caapiʉjaqueti majuucõawã. Isaía ocõo bairo caucayupi ape wame tunu: ");
INSERT INTO tav_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dio ye quetire cabuiorã na cabuiorijere camaja na caapi majiquẽto na cájupi Dio. To bairi caroaro cʉ cátiere tʉjʉbana quena tʉjʉ majiquetigarãma. Api puo majiquetibana apiʉjaquetigarãma. To bairi, “Caroorije jã cátajere jã majirioya,” Diore ĩ majiquetigarãma, caĩñupi Isaía. ");
INSERT INTO tav_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaía ti wamere buioʉ caĩ ucayayupi. Cʉ majuuna Jesu cʉ catutuarijere, cʉ caaji baterijere catʉjʉyayupi cʉ ãnacʉ. Tiere tʉjʉri to bairona caucayayupi. ");
INSERT INTO tav_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judío maja capãarã Jesure, “Dio cʉ cajooricʉ ãcʉmi,” cʉ caĩ tʉgooña nʉcʉbʉgowã bairã pʉa. Jĩcaarã na ʉparã quena to bairona caĩ tʉgooña nʉcʉbʉgowã. To bairo cʉ̃re tʉgooña nʉcʉbʉgobana quena caĩ buio baujaquẽma, fariseo majare uwibana. Neñapo buerica wiipʉ jã cãno jã buurema ĩrã caĩ baujaquẽma. ");
INSERT INTO tav_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Dio caroaro nare cʉ caĩ tʉjʉro netoro cabooyupa camaja to bairo caroaro nare na caĩ tʉjʉpe macare. ");
INSERT INTO tav_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu nipetirã na apiato ĩi tutuaro wadari na caĩ buiowĩ: —Yʉre caapiʉjarã yʉ jeto meere apiʉjama. Yʉ Pacʉ, yʉre cajooricʉ quenare apiʉjarã áama. ");
INSERT INTO tav_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yʉre camajirã yʉre cajooricʉ quenare majima. ");
INSERT INTO tav_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cajĩa bujubojaʉre bairona cãcʉ yʉ cáapʉ́ ati yepapʉ. Yʉre caapiʉjarã canaitĩaropʉre cãnare bairo na aniqueticõato ĩi yʉ cáapʉ́. Nare yʉ cabuiorijere api majigarãma. Caroaro caapi majirã anigarãma. ");
INSERT INTO tav_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yʉ cabuiorijere apibana quena tiere cátiquẽna cabui pacoorã anigarãma. To bairo na cabaibato quena na yʉ popiyeyequetigʉ. Ati yepa macanare na popiyeyei acʉ́ mee yʉ cabaiwʉ. Nare netooʉ acʉ́ yʉ cápʉ́. ");
INSERT INTO tav_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉre cabooquẽna, yʉ cabuiorijere cátigaquẽna Dio cʉ capopiyeyeparã anitʉgama. Yʉ cabuiorije na caapiʉjaquẽtie jʉgori na popiyeyegʉmi Dio ati ʉmʉrecoo capetiropʉre. ");
INSERT INTO tav_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉ majuuna yʉ cabuiogaro yʉ buioquẽe. Yʉ Pacʉ, yʉre cajooricʉ, “To bairo ĩ buioya,” yʉre cʉ caĩ rotiro yʉ buionucu. ");
INSERT INTO tav_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yʉ maji, yʉ Pacʉ cʉ carotirijere caapiʉjarã catícõa aninucugarãma. To bairi yʉre cʉ cabuio rotiricarore bairona camajare na yʉ buio, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Judío maja boje rʉmʉ pascua cãniparo jʉgoye macá rʉmʉ cãñupe yua. Jesu camajitʉgawĩ ati yepapʉ cãnacʉ cʉ Pacʉ tʉpʉ cʉ cáaápere. Ati yepapʉ cãna cʉ̃re caapiʉjarã seeto majuu jã camai netocõa aninucuwĩ. To bairi jãre cʉ camai netorijere iñoʉ cʉ majuuna manire cabai yajibojawĩ. ");
INSERT INTO tav_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","To bairi Simón Iscariote macʉ, Judas Iscariote, “Jesure cañeparãre cʉ yʉ wadajãgʉ,” caĩ tʉgooña tʉgayupi, cʉ yeripʉre Sataná cʉ carotiro. Jesu Dio tʉpʉ cáatácʉ aniri camajitʉgawĩ topʉ cʉ Pacʉ tʉpʉ cʉ catunu aápere. Nipetirije cáti majirije cʉ Pacʉ cʉ̃re cʉ cajoorique quenare camajitʉgawĩ. To bairi jã caʉga ruiri paʉ Jesu wamʉnʉca, cʉ jutiro cabui macatore catu we cũwĩ. Tu we cũ, juti ajero cajia tuwĩ wẽanucuri paʉpʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jia tu yaparo ocore carupa bapapʉre capio jãwĩ. Tie oco mena jã rʉporire cacoje jʉgówĩ. Cojeri bero juti ajero mena catu coje caroowĩ. ");
INSERT INTO tav_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedro rʉporire cʉ cacojegari paʉ Pedro maca ocõo bairo cʉ caĩwĩ Jesure: —Yʉ Ʉpaʉ, yʉ roquere yʉ rʉporire cacojepaʉ mʉ aniquẽe. ");
INSERT INTO tav_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu ocõo bairo cʉ caĩwĩ Pedrore: —Yucʉacã yʉ cátiere mʉ tʉgooña majiquẽe. Caberopʉ mʉ majigʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro cʉ caĩwĩ Jesure: —Yʉa, yʉ rʉporire mʉ yʉ coje rotiqueti majuucõa. Jesu cʉ caĩwĩ Pedrore tunu: —Yʉ cacojequẽpata yʉ mena macacʉ mʉ ani majiquetigʉ, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro cʉ caĩwĩ Jesure: —To roquere yʉ rʉpori cojei yʉ wamori, yʉ rʉpoa quenare cojeya. ");
INSERT INTO tav_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu maca ocõo bairo cʉ caĩwĩ tunu: —Ujari bero mani ujanemoquẽna. Ujari bero petoacã aána mani rʉpori jeto ʉgueri tuarique ãno. To bairi mani rʉpori jetore tu cojerique ãno. Mʉja yeri caʉgueri manare bairona mʉja anicõa. To bairo cabairã anibana quena jĩcaʉ mʉja mena macacʉ cʉ yeri caʉgueri paiire bairo ãmi, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu cʉ̃re cañeparãre cawadajãpaʉre camajitʉgawĩ. Cʉ tʉjʉ majiri, “Mʉja mena macacʉ jĩcaʉ cʉ yeri caʉgueri paiire bairo ãmi,” ĩi, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jã rʉporire coje yaparoʉ cʉ jutiro cʉ catu wericarore jaña, cajawo tʉ caejanumuwĩ tunu. Ejanumu, ocõo bairo jã caĩwĩ: —¿Mʉja majiti to bairo mʉjaare yʉ cáti iñooro? ");
INSERT INTO tav_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jã Ʉpaʉ, jãre camajioʉ, yʉre mʉja ĩnucu. To bairona yʉ ã mʉja caĩrore bairona. ");
INSERT INTO tav_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","To bairi yʉ, mʉja Ʉpaʉ, mʉjaare camajioʉ anibacʉ quena mʉja rʉporire yʉ cojewʉ. To bairi mʉja quena ame cojeri, paabojari majare bairona ame átiboja aninucuña. ");
INSERT INTO tav_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","To bairo yʉ cátore bairo na áparo ĩi to bairona mʉjaa yʉ ápʉ́. Mʉja quena to bairona ája. ");
INSERT INTO tav_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cariapena mʉjaare yʉ buio. Jĩcaʉ maca paa coteri majocʉ, “Yʉ ʉpaʉ netoro cãcʉ yʉ ã,” ĩ majiquẽemi. Jĩcaʉ cʉ cajooricʉ quena cʉ̃re cajooricʉ netoro aniquẽemi. ");
INSERT INTO tav_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","To bairije mʉjaare yʉ caĩ buiorijere api majiri tiere mʉja cátinucuata caroaro cãni wariñuurã mʉja anigarã. ");
INSERT INTO tav_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mʉja nipetirãpʉre buioʉ mee yʉ ĩ. Yʉ cabejericarãre yʉ maji. Dio ye queti ucarica pũuripʉ caĩricarore bairona baigaro. Ocõo bairo caĩ ucayupa: “Yʉ mena caʉga ruii anibacʉ quena yʉre catʉjʉ punijinii ãmi.” ");
INSERT INTO tav_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mʉjaare buio jʉgoyeyei yʉ ĩ. To bairi yʉ caĩricarore bairona cabairo tʉjʉrã cariapena, “Dio cʉ cajooricʉ ãmi,” yʉre mʉja ĩ nʉcʉbʉgogarã yua. ");
INSERT INTO tav_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cariapena mʉjaare yʉ ĩ. Yʉ cajoorã na cabuiorijere caapi nʉcʉbʉgorã yʉ quenare api nʉcʉbʉgorã áama. Yʉre caapi nʉcʉbʉgorã maca yʉre cajooricʉ quenare api nʉcʉbʉgorã áama, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","To bairo ĩri bero Jesu seeto catʉgooñarique paiwĩ. Tʉgooñarique pai, caroaro jã caĩ buiowĩ: —Cariapena mʉjaare yʉ ĩ. Jĩcaʉ mʉja mena macacʉ yʉre catʉjʉteerãre yʉre na wadajãgʉmi, yʉre na ñeato ĩi, caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","To bairo cʉ caĩro apirã, ¿ni macare to bairo manire cʉ ĩbauti? ĩrã, jã caame tʉjʉwʉ, “Anina ãcʉmi,” ĩ majiquetibana. ");
INSERT INTO tav_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yʉ, Jesu cʉ camai majuʉ cʉ tʉna yʉ caruiwʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","To bairi Simón Pedro cʉ wamori mena cáti buiowĩ, Jesure ¿ñamʉ majuure mʉ ĩti? cʉ jeniñaña, yʉre ĩi. ");
INSERT INTO tav_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","To bairi Jesu tʉacã pua tuari cʉ̃re yʉ cajeniñawʉ: —Ʉpaʉ, ¿ni majuure mʉ ĩti? ");
INSERT INTO tav_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ocõo bairo yʉ caĩwĩ Jesu: —Pan cuire yojeri yʉ cajoʉna anigʉmi. To bairo ĩri bero Simón macʉ Judas Iscariotere cayoje joowĩ. ");
INSERT INTO tav_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","To bairo cʉ cayoje joori paʉna Judas yeripʉ cajãawĩ Sataná yua. To bairo cʉ cajãaro majiri Jesu cʉ caĩwĩ: —Mʉ cátigarijere yoaro mee ája. ");
INSERT INTO tav_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jã nipetirã topʉ caʉga ruirã, nope ĩi to bairo cʉ ĩimi, jã caĩ majiquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jĩcaarã ocõo bairo jã caĩ tʉgooñawʉ: Judas niyeru poare cacotei cʉ cãno Jesu apeye uniere boje rʉmʉ macajere wapaye rotii ĩimi, o cabopacoorãre niyeru na joo rotii ĩimi, jã caĩ tʉgooñawʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","To bairi Judas Jesu cʉ cayoje joori cuire ne ʉgari bero jã tʉpʉ cãnacʉ cabuticoa aámi. Cʉ cabuti aáti paʉ ñamipʉ cãmʉ mere. ");
INSERT INTO tav_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cʉ cabuti aáto bero ocõo bairo jã caĩwĩ Jesu: —Yucʉacã camaja tʉpʉ Dio cʉ cajooricʉ yʉ catutuarije iñoorique anigaro. Dio cʉ catutuarije quena yʉ jʉgori iñoorique anigaro. ");
INSERT INTO tav_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dio cʉ catutuarijere yʉ caiñooro yʉ Pacʉ quena yʉ catutuarijere iñoogʉmi. Nemoona átigʉmi. ");
INSERT INTO tav_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ yarã yoaroacã mee mʉja mena yʉ ani tʉjagʉ. Yʉre mʉja macagarã. Cajʉgoyepʉ judío majare na yʉ caĩeparore bairona mʉjaare yucʉacã yʉ ĩ tunu: Yʉ cáaáparopʉre mʉja aá majiquetigarã. ");
INSERT INTO tav_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","To bairi cawama wame Dio cʉ carotiri wame ocõo bairi wame mʉjaare yʉ cũ: Mʉjaare yʉ camairore bairona ame maiña mʉja quena. ");
INSERT INTO tav_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉja caame mairo tʉjʉrã aperã nipetirã, “Jesu yarã ãnama,” mʉja ĩ majigarãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","To bairo cʉ caĩro Simón Pedro ocõo bairo cʉ caĩ jeniñawĩ Jesure: —Ʉpaʉ, ¿noopʉ mʉ aácʉati? Jesu maca cʉ caĩwĩ Pedrore: —Yucʉacã yʉ cáaáparopʉre mʉ aá majiquẽe. Caberopʉ mʉ aágʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro cʉ caĩwĩ tunu: —Ʉpaʉ, ¿nope ĩi mʉ mena nemoona yʉ aá majiqueticʉti? Mʉre yʉ caapiʉjarije jʉgori yʉre na cajĩagabato quena mʉ menana yʉ aágʉ. ");
INSERT INTO tav_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","To bairo cʉ caĩro Jesu cʉ caĩwĩ: —“Jesure yʉ caapiʉjarije jʉgori yʉre na cajĩagabato quena cʉ mena yʉ tuagʉ,” ¿mʉ ĩ tʉgooñati? Cariapena mʉ yʉ ĩ. Ãbocʉ cʉ cawadaparo jʉgoye itiani, “Jesure cʉ yʉ majiquẽe,” na mʉ ĩtogʉ, uwibacʉ, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ocõo bairo jã caĩnemowĩ Jesu: —Mʉjaa seeto majuu yʉre tʉgooñarique paiqueticõaña. Diore tʉgooña nʉcʉbʉgoya. To bairi yʉ quenare tʉgooña nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉ Pacʉ tʉpʉ mʉja cãnipa wiiri capee ã. To camamata mʉjaare yʉ buioboricʉ. Ani majuucõa. To bairi mʉja cãnipa paʉrire quenoo yuʉ aácʉ yʉ áa. ");
INSERT INTO tav_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mʉja cãnipa paʉrire quenooboja yaparori bero mʉjaare yʉ jei atígʉ. Topʉ mʉja quena yʉ cãnopʉre yʉ mena mʉja anicõa aninucugarã. ");
INSERT INTO tav_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yʉ cáaátopʉre mʉja majirã. Dope bairo topʉ ejarique to anicʉti mʉja ĩ majirã, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Ʉpaʉ, cʉ caĩwĩ Tomás, —mʉ cáaátopʉre jã majiquẽe. ¿Dope bairo majuu jã aá majibocʉti mʉ cáaátopʉre ejagarã? ");
INSERT INTO tav_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu cʉ caĩwĩ: —Yʉna yʉ ã camaja yʉ Pacʉ tʉpʉ na caejaro cácʉ. Yʉ jʉgori jeto yʉ Pacʉ tʉpʉ ejarique ã. Cariape macajere yʉ buio. Catícõa aninucuriquere cajoʉ yʉ ã. Yʉre canʉcʉbʉgorã jeto yʉ Pacʉ tʉpʉ ejagarãma. ");
INSERT INTO tav_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yʉre majirã yʉ Pacʉ quenare mʉja majigarã. Yucʉ mena mere cʉ̃re mʉja majitʉga. Mere cʉ̃re catʉjʉcõa aninucurã mʉja ã, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe Jesure cʉ caĩwĩ: —Ʉpaʉ, mʉ Pacʉre jãre iñooña. Cʉ̃re tʉjʉrã to cõona jã ani wariñuugarã, cʉ caĩwĩ Felipe. ");
INSERT INTO tav_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu cʉ caĩwĩ tunu: —Felipe, mʉja mena yoaro yʉ cãmʉ. ¿Yʉre mʉja tʉjʉ majiquẽeti mai? Noa yʉre catʉjʉrã yʉ Pacʉ quenare tʉjʉma. ¿Nope ĩi, mʉ Pacʉre jã iñooña, yʉre mʉ ĩti? ");
INSERT INTO tav_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yʉ, yʉ Pacʉ mena pʉgarã anibana quena jĩcaʉna jã ã. ¿Tiere mʉja majiquẽeti? Yʉ cabuiorijere yʉ majuuna yʉ buioquẽe. Yʉ Pacʉ yʉpʉre cãcʉ maca cʉna cʉ caboorije áami yʉ jʉgori. ");
INSERT INTO tav_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yʉ, yʉ Pacʉ mena pʉgarã anibana quena jĩcaʉna jã cãniere yʉ caĩ buiorijere api nʉcʉbʉgoya. Tiere api nʉcʉbʉgoquẽna maca yʉ cátie macare tʉjʉ nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cariapena mʉjaare yʉ ĩ. Yʉre caapi nʉcʉbʉgorã una yʉ cátiere bairona átigarãma na quena. Yʉ cátie netoro átigarãma. Yʉ Pacʉ tʉpʉ yʉ cáaá jʉgoyecʉto maca to bairo átigarãma. ");
INSERT INTO tav_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nipetirije yʉ jʉgori yʉ wame mena Diore mʉja cajeniro mʉjaare yʉ átibojagʉ. Yʉ jʉgori yʉ Pacʉ cʉ catutuarijere na majiato ĩi to bairo mʉjaare yʉ átibojagʉ. ");
INSERT INTO tav_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Noo nipetirije yʉ jʉgori yʉ wame mena Diore mʉja cajeniro mʉjaare yʉ átibojagʉ. ");
INSERT INTO tav_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Yʉre mʉja canʉcʉbʉgoata yʉ carotirijere mʉja átigarã. ");
INSERT INTO tav_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Yʉ Pacʉre mʉja yʉ jenibojagʉ, Espíritu Santore na jooya ĩi. Cʉ maca mʉja átinemori, mʉja catʉgooña tutuaro átigʉmi Espíritu Santo. To bairi mʉja mena anicõa aninucugʉmi. Espíritu Santo cariape mʉjaare majiogʉmi. Aperã ati yepa macana yʉre caapiʉjaquẽna cʉ̃re majiquẽema. To bairi cʉ̃re cʉgoquetigarãma naa. Mʉja maca cʉ̃re mʉja majigarã. Mʉja mena anigʉmi. Mʉjaapʉre anicõa aninucugʉmi. ");
INSERT INTO tav_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mʉjaare yʉ aáweoqueticõagʉ. Mʉja mena anigʉ yʉ atígʉ tunu. ");
INSERT INTO tav_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Caberoacã yʉre caapiʉjaquẽna yʉre tʉjʉnemoquetigarãma yua. Mʉja maca yʉre mʉja tʉjʉgarã. Cacaticõa aninucuʉ yʉ ã. To bairi mʉja quena mʉja catícõa aninucugarã. ");
INSERT INTO tav_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yʉ Pacʉ cʉ Espíritu Santore joogʉmi mʉjaare. To bairo mʉjaare cʉ cajooro caroaro mʉja majigarã yʉ Pacʉ mena jĩcaʉna jã cãniere. To bairi yʉ mena mʉja cãnie quenare mʉja majigarã. Mʉja mena yʉ cãnie quenare caroaro mʉja majigarã. ");
INSERT INTO tav_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nii yʉ carotirijere majii, tiere caapiʉjaʉ ũcʉ cariapena yʉre camaii ãmi. Yʉre camaii ũcʉre cʉ maigʉmi yʉ Pacʉ. Yʉ quena cʉ̃re yʉ maigʉ. To bairi yʉ cãniecʉtiere cʉ yʉ majiogʉ to bairo cariapena yʉre camaii ũcʉre, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juda cawamecʉcʉ, Iscariote mee ocõo bairo cʉ caĩwĩ Jesure: —Ʉpaʉ, ¿dope bairo ácʉ mʉ cãniecʉtiere jãre mʉ majioʉati, ati yepa macana mʉre caapiʉjagaquẽna macare na majioquẽcʉna? ");
INSERT INTO tav_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ocõo bairo cʉ caĩ yʉwĩ Jesu: —Yʉre canʉcʉbʉgorã ãnaa yʉ cabuiorijere mʉja apiʉjagarã. To bairi mʉja maigʉmi yʉ Pacʉ. Jã pʉgarãpʉna mʉja mena jã anicõagarã. ");
INSERT INTO tav_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉre canʉcʉbʉgoquẽna maca yʉ cabuiorijere apiʉjaquẽema. Mʉjaare yʉ cabuiorije yʉ ye me ã. Yʉ Pacʉ yʉre cajooricʉ yʉre cʉ cabuio rotirique maca ã. ");
INSERT INTO tav_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mʉja mena ãcʉ mai atie nipetirijere mʉjaare yʉ buio. ");
INSERT INTO tav_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yʉ Pacʉre yʉ cajeniro maca Espíritu Santore joogʉmi mʉjaare. To bairi Espíritu Santo mʉjaare átinemogʉmi. Mʉja catʉgooña tutuaro mʉja átigʉmi. Nipetirije mʉjaare majiogʉmi. Nipetirije mʉjaare yʉ cabuiorique quenare mʉja catʉgooña bʉga majiro mʉja átigʉmi. ");
INSERT INTO tav_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yucʉacã aácʉ yʉ áa. To cõona caroaro tʉgooña yerijã ani wariñuurique mʉjaare to ãmaro. Mʉjaare yʉ joo mʉja catʉgooña yerijã wariñuucõa anipere. Tiere joʉ ati yepa macana Diore camajiquẽna na cáti aniere bairo mee mʉjaare yʉ joo. To bairi, “Aácʉ yʉ áa,” yʉ caĩrijere apirã jʉtiriti tʉgooñarique paiqueticõaña. ");
INSERT INTO tav_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yʉ Pacʉ tʉpʉ aácʉ yʉ áa,” yʉ caĩro mere mʉja apitʉgawʉ. “Cabero mʉja mena anigʉ yʉ atígʉ tunu,” yʉ caĩro quenare mʉja apitʉgawʉ. Yʉ Pacʉ yʉ netoro cãcʉ ãmi. To bairi yʉ netoro cãcʉ tʉpʉ, yʉ Pacʉ tʉpʉ yʉ cáaátie quetire apirã cawariñuparã mʉja anibapa. Caroaro yʉre mʉja canʉcʉbʉgoata mʉja wariñuuborã cʉ tʉpʉ yʉ cáaátiere tʉgooñari. ");
INSERT INTO tav_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mʉjaare yʉ buio jʉgoyeyewʉ mere. To bairi mʉjaare yʉ cabuio jʉgoyeyerique cõo to cabairo tʉjʉrã, “Cariapena caĩñupi,” yʉre mʉja ĩ nʉcʉbʉgogarã. ");
INSERT INTO tav_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ati yepa macana yʉre caapiʉjaquẽnare carotii, Sataná atore atítʉgami. To bairi yoaro mʉjaare yʉ buionemoquetigʉ. Yʉre caroti majii aniqueti majuucõami Sataná, ati yepa macajere roti majibacʉ quena. ");
INSERT INTO tav_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yʉ Pacʉ yʉre cʉ cáti rotiriquere yʉ átigʉ. To bairo yʉ cáto ati yepa macana yʉ Pacʉre cʉ yʉ canʉcʉbʉgorijere majigarãma, jã caĩ buiowĩ Jesu. To bairo ĩ buio yaparoʉ: —Wamʉnʉcaña. Jitá, mani aáparo, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesu jãre buio majio, ocõo bairo caĩwĩ tunu: —Yʉ jĩca wʉ ʉje wʉre bairona yʉ ã. Yʉ Pacʉ ti wʉre cacoteire bairo cãcʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yʉre caapi nʉcʉbʉgonucurã ti wʉ rʉpʉrire bairona ãma. Ʉje wʉre caotericʉ carica mani rʉpʉrire pajure recõaʉmi. Ape rʉpʉri caricacʉti rʉpʉri macare capee to rica cʉtinemoato ĩi pajure rʉgoboʉmi. To bairo cʉ cátore bairona yʉre caapi nʉcʉbʉgo quetinucurãre na regʉmi Dio. Yʉre caapi nʉcʉbʉgorã macare netobʉjaro caroare na áparo ĩi caroorije na cátinucurijere na rebojagʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yʉ cabuiorijere caapi nʉcʉbʉgorã aniri caroorije mʉja cátinucurijere Dio cʉ camajirio bojaricarãpʉ mʉja anitʉga. ");
INSERT INTO tav_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mʉja menapʉ yʉ cãnicõa aninucurore bairona mʉja quena yʉ mena anicõa aninucuña. Ʉje wʉ carʉpʉ jetona ricacʉti majiquẽe tie majuuna. Carupa wʉpʉre caputirica rʉpʉ jeto ricacʉti maji. Ti rʉpʉ cabairore bairona yʉ menapʉ mʉja cãniquẽpata caroare mʉja áti majiquetiborã. ");
INSERT INTO tav_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’To bairi ʉje wʉre bairona cãcʉ yʉ ã. Mʉja maca carʉpʉrire bairo cãna mʉja ã. Ti wʉpʉre carʉpʉri caricacʉtore bairona caroare átinucuma yʉ mena macana cãnicõa aninucurã. Yʉ mena mʉja cãnicõa aniquẽpata caroare mʉja áti majiquetiborã. ");
INSERT INTO tav_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yʉ mena cãnicõa aninucuquẽna pajure rerica rʉpʉrire bairona ãma. Ti rʉpʉrire jee, peropʉ joe rerique ãno. Tiere bairona yʉ mena macana cãniqueticõa aninucurãre na regʉmi Dio peropʉre yua. ");
INSERT INTO tav_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Yʉ mena macana mʉja cãnicõa aninucuata yʉ cabuiorijere majiritiquẽnana Diore mʉja caboorijere cʉ jeniya. Tiere mʉja cajeniro tiere mʉja átibojagʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aperã camaja quena capee caroare mʉja cáto tʉjʉrã Diore api nʉcʉbʉgogarãma. “Cariapena Jesu yarã, Jesu cʉ cabuericarã ãma,” mʉja ĩ tʉjʉ majigarãma. ");
INSERT INTO tav_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉ Pacʉ yʉre cʉ camairore bairona yʉ quena mʉjaare yʉ mai. To bairi mʉjaare yʉ camairore bairona mʉja quena ame mairi anicõa aninucuña. ");
INSERT INTO tav_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ Pacʉ cʉ carotirijere cácʉ yʉ cãno yʉre maimi. Mʉja quena yʉ carotirijere cáticõa aninucurã mʉja cãmata yʉ camairã mʉja anicõagarã. ");
INSERT INTO tav_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Tiere mʉjaare yʉ buio, yʉ cãni wariñuurore bairo na quena na ani wariñuato ĩi. To bairi mʉja ani wariñuu netogarã. ");
INSERT INTO tav_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yʉ carotirije ocõo bairo ã: Ame maiña, mʉjaare yʉ camairore bairona. ");
INSERT INTO tav_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jĩcaʉ cʉ yarãre mai netori na bai yajibojaboʉmi. Ape wame mani yarãre mairica wame netoro cãni wame maa. ");
INSERT INTO tav_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yʉ carotirijere cána mʉja cãmata yʉ mena macana majuu mʉja anigarã. ");
INSERT INTO tav_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Yʉre capaabojarã mʉja ã,” mʉjaare yʉ ĩquẽe. Cʉ paabojari maja na ʉpaʉ cʉ cátiere majiquẽnama. Yʉ mena macana majuu cãna mʉja ã. To bairi mʉjaare yʉ buio peocõawʉ yʉ Pacʉ yʉre cʉ caĩrique nipetirije. ");
INSERT INTO tav_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉja majuuna, “Cʉ mena macana jã anigarã,” yʉre mʉja caĩquẽpʉ. Yʉ maca, yʉ mena macana anigarãma ĩi, mʉjaare yʉ cabejewʉ. Capee caroare na áparo ĩi, mʉjaare yʉ cabejewʉ. Caroaro mʉja cátie to capetiquetiparore bairo ĩi, mʉjaare yʉ cabejewʉ. To bairi yʉ jʉgori, yʉ wame mena noo mʉja caboorije Diore mʉja cajeniro mʉja joogʉmi. ");
INSERT INTO tav_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ame maiña mʉjaa. Ti wame ã mʉjaare yʉ cáti rotiri wame. ");
INSERT INTO tav_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Ati yepa macana yʉre caapiʉjaquẽna maca mʉjaare na catʉjʉteero yʉre na catʉjʉtee jʉgoriquere tʉgooñaña. ");
INSERT INTO tav_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ati yepa macana yʉre caapiʉjaquẽna mʉja cãmata na mena macanare nare na camairore bairona mʉja maiborãma mʉja quenare. Mʉjaare yʉ cabejewʉ na mena cãnibatanare. To bairi ati yepa macana majuu mee mʉja ã. To bairi mʉjaare tʉjʉteema. ");
INSERT INTO tav_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tʉgooñaña mepʉ mʉjaare yʉ caĩejere. Jĩcaʉ maca paa coteri majocʉ, “Yʉ ʉpaʉ netoro cãcʉ yʉ ã,” ĩ majiquẽemi. To bairi rooro yʉre cána mʉja quenare to bairona rooro átigarãma. Yʉ cabuiorijere caapiʉjarã maca mʉja quenare apiʉjagarãma. ");
INSERT INTO tav_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yʉ yarã mʉja ã. To bairi yʉre caapiʉjaquẽna maca rooro mʉjaare átigarãma, ati yepapʉ yʉre cajooricʉre camajiquẽna aniri. ");
INSERT INTO tav_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ati yepapʉre nare yʉ cabuioʉ ejaquẽpata bui pacooquetiborãma. Yucʉacãre cabui pacoorã ãma, yʉ cabuiorijere caapigaquẽna aniri. “Cabui pacooquẽna jã ã,” ĩ majiquẽema. ");
INSERT INTO tav_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉre catʉjʉteerã yʉ Pacʉ quenare tʉjʉteema. ");
INSERT INTO tav_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jĩcaʉ maca apeĩ cʉ cáti iñooquetajere capee caroare yʉ cáti iñoobapʉ. Yʉ cáti iñooquẽpata cabui pacoorã aniquetiborãma. Yʉ cáti iñooriquere catʉjʉwã. Tiere tʉjʉbana quẽna yʉre catʉjʉteewã. Yʉ Pacʉ quenare cʉ catʉjʉteewã. ");
INSERT INTO tav_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tirʉmʉpʉ macana na caucaricarore bairona bai. To bairi Dio ye queti ucarica pũuripʉ to caĩrore bairona bai. Ocõo bairo ĩ: “Ñe wapa mano majuu yʉre catʉjʉteewã.” ");
INSERT INTO tav_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Espíritu Santo, cariape caĩ buioʉ mʉjaare átinemoʉ atígʉmi. Yʉ Pacʉ cʉ carotiro mena cʉ yʉ joogʉ. To bairi Espíritu Santo mʉja tʉpʉ acʉ́ cariape yʉ cãniere buiogʉmi. ");
INSERT INTO tav_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mʉja quena yʉ cãniere mʉja buiogarã aperãre. Nemoopʉna yʉ mena mʉja cãnitʉgawʉ. To bairi mʉja quena yʉ cãniere mʉja buiogarã aperã quenare. ");
INSERT INTO tav_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Yʉre mʉja caapiʉjarije wapa aperã rooro mʉjaare popiyeyegarãma ĩriquere mʉjaare yʉ buiowʉ mere. Yʉ cabuiorijere mʉja camajiritiquetiparore bairo ĩi, to bairo mʉjaare yʉ ĩ buiowʉ. ");
INSERT INTO tav_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judío maja na caneñapo buenucuri wiiripʉ mʉja cãno mʉjaare re buugarãma aperã. Noo mʉjaare na cajĩa reropʉ, “Dio cʉ booro jĩarã jã áa,” ĩ tʉgooñagarãma. ");
INSERT INTO tav_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yʉ Pacʉre camajiquẽna aniri, yʉ quenare camajiquẽna aniri to bairo mʉja átigarãma. ");
INSERT INTO tav_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tiere mʉjaare buio jʉgoyeyei yʉ áa. To bairo cabairo tʉjʉrã, “To bairona jãre caĩ buiowĩ Jesu,” mʉja ĩ tʉgooñagarã. ’Nemoopʉre mʉja mena ãcʉ atiere mʉjaare yʉ caĩ buioquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Yucʉacã mʉjaare yʉ buio. Yʉre cajooricʉ tʉpʉ aácʉ yʉ áa. To bairo mʉjaare yʉ caĩro apibana quena, “¿Noopʉ mʉ aácʉ aáti?” yʉre mʉja ĩ jeniñaquẽe. Mʉja tʉgooñarique paibʉja paro. ");
INSERT INTO tav_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cariapena mʉjaare yʉ ĩ: Mʉjaare ñuubʉjagaro mʉjaare yʉ cáaáweoro bero. Aáti bero Espíritu Santore mʉjaare yʉ joogʉ. Yʉ cáaáquẽpata mʉjaare cátinemoʉ, mʉja mena cãnipaʉ atíquetiboʉmi. ");
INSERT INTO tav_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cʉ̃ acʉ́pʉ ati yepa macanare, “Caroorã jã ã,” na caĩ tʉgooña majiparore bairo nare buiogʉmi. Apeye caroa cãnie macare buiogʉmi. To bairi Dio ati yepa macanare caroorije na cátaje wapa nare cʉ capopiyeyepere na majiogʉmi Espíritu Santo. ");
INSERT INTO tav_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yʉre caapiʉjaquẽna na cãno maca to bairo na ĩ majiogʉmi na capopiye tamʉopere. ");
INSERT INTO tav_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉ Pacʉ tʉpʉ yʉ cáaáto bero yʉre mʉja tʉjʉnemoquetigarã. To bairo yʉ cáaábato quena Espíritu Santo yʉre wajoagʉmi, cʉ maca ati yepapʉ anigʉ. To bairi cʉ maca cariape átajere na iñoogʉmi ati yepa macanare. ");
INSERT INTO tav_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ati yepa macana Diore caapiʉjaquẽnare carotii, Sataná mere Dio cʉ capopiyeyepaʉ anitʉgami. To bairi Diore caapiʉjaquẽna Sataná cʉ carotirã ãma. To bairi Dio popiyeyegʉmi na quenare. ");
INSERT INTO tav_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Capee mʉjaare yʉ cabuiope anibapa. Yucʉacã mʉja api majiquetiborã. To bairi yʉ buioquẽe. ");
INSERT INTO tav_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cariapena caĩ buioʉ Espíritu Santo ejaʉpʉ caroaro nipetiro cariape cãniere buiogʉmi. Nipetiro cʉ cabuiorije cariape majuu cãnie ã. Cʉ majuuna ĩquetigʉmi. Dio cʉ cabuio rotirona cʉ caapiriquere buiogʉmi. Caberopʉ cabaipe quenare mʉjaare buio jʉgoyeyegʉmi. ");
INSERT INTO tav_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Jesu cañuʉ majuu ãmi,” yʉre mʉja caĩ majiparore bairo mʉja buiogʉmi. Yʉ cãniere cʉ̃re yʉ cabuio rotirijere mʉja buiogʉmi. ");
INSERT INTO tav_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nipetiro yʉ Pacʉ cʉ cãnie yʉ ye ã. To bairi Espíritu Santo mʉjaare yʉ cãnie quetire buiogʉmi yua. ");
INSERT INTO tav_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","17","’Petoacã bero yʉre mʉja tʉjʉnemoquetigarã. Cabero yʉre mʉja tʉjʉgarã tunu. Yʉ Pacʉ tʉpʉ yʉ cáaátie jʉgori to bairo baigaro. To bairo cʉ caĩro apirã jĩcaarã jã mena macana ocõo bairo caame ĩwã: —¿Dope bairo ĩgʉ cʉ ĩbauti to bairo ĩi? ");
INSERT INTO tav_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Petoacã bero,” cʉ caĩrije ¿dope bairo ĩgʉ cʉ ĩcʉti? ¿Ñee uniere buioʉ cʉ ĩcʉti? jã ĩ majiquẽe, caame ĩwã. ");
INSERT INTO tav_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu to bairo na caame ĩrijere majiri ocõo bairo na caĩwĩ: —“Petoacã bero yʉre mʉja tʉjʉnemoquetigarã. Cabero yʉre mʉja tʉjʉgarã tunu,” mʉjaare yʉ caĩrijere, ¿ame jeniñarã mʉja áati? ");
INSERT INTO tav_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cariapena mʉjaare yʉ buio: Seeto majuu oti, mʉja tʉgooñarique paigarã. Ati yepa macana yʉre caapiʉjaquẽna maca wariñuugarãma. Seeto mʉja catʉgooñarique pairicaro bero mʉja wariñuurique cʉti wajoagarã. ");
INSERT INTO tav_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jĩcao ʉta paco macʉ cʉtigopʉ seeto wijio tʉgooñaomo. Cʉ cabuiaro bero co cawijioriquere tʉgooñaquẽcomo. Co macʉ cʉ cabuiarije macare tʉgooña wariñuomo. ");
INSERT INTO tav_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","To bairo co cabairore bairona mʉja quena popiye majuu mʉja tʉgooñarique pai yucʉacãre. Cabero mʉjaare yʉ tʉjʉ atígʉ tunu. To bairo yʉ catunu tʉjʉ ejaro tʉjʉrã mʉja wariñuu netogarã. Cãni wariñuu netorã aniri aperã maca mʉja catʉgooñarique pairo áti majiquetigarãma yua. ");
INSERT INTO tav_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","To bairo ani wariñuucõari mʉja caapi majiquẽtiere yʉre mʉja jeniñaquetigarã yua. Cariapena mʉjaare yʉ ĩ. Nipetirije yʉ carotiro mena, yʉ wame mena mʉja cajeniro yʉ Pacʉ mʉjaare joogʉmi. ");
INSERT INTO tav_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yʉ carotiro mena, yʉ wame mena Diore cʉ mʉja jeniquetinucu mai. Yucʉacã jeniya yua. To bairo mʉja cajeniro mʉja joogʉmi Dio. Mʉjaare cʉ cajooro mʉja wariñuu netocõagarã. ");
INSERT INTO tav_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yucʉpʉna buio majiorica wameri mena mʉjaare buioʉ yʉ áa. Caberopʉre buio majiorica wameri mena mʉjaare yʉ buionemoquetigʉ. Cariape to caĩrore bairona yʉ Pacʉ ye quetire yʉ buiocõagʉ. ");
INSERT INTO tav_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Espíritu Santo cʉ caejaro bero yʉ carotiro mena, yʉ wame mena yʉ Pacʉre mʉja jenigarã. To bairi yʉ majuuna yʉ Pacʉre mʉjaare yʉ cajenibojape aniquetigaro yua. ");
INSERT INTO tav_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yʉ Pacʉ Dio maimi mʉjaare. Ocõo bairo ã. Yʉre mʉja mai. To bairi, “Dio tʉpʉ cáatácʉna ãmi,” yʉre mʉja ĩ nʉcʉbʉgo. To bairo yʉre mʉja caĩ nʉcʉbʉgoro Dio maimi mʉjaare. ");
INSERT INTO tav_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉ Pacʉ mena cãnacʉ ati yepapʉre yʉ cáapʉ́. Topʉ cáatácʉ aniri, yucʉacã atopʉre cãnacʉ yʉ Pacʉ tʉpʉ yʉ tunu aágʉ tunu. ");
INSERT INTO tav_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","To bairo cʉ caĩro apirã cʉ buerã maca ocõo bairo cʉ̃re jã caĩwʉ: —Yucʉacã buio majiorica wame mena mʉ buioquẽe. Cariapena mʉ buiocõa. ");
INSERT INTO tav_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yucʉacã, “Nipetirijere camajii mʉ ã,” jã ĩ maji. Noo jã cajeniñagarijere mʉ majitʉga mere, jã cajeniñaquẽtona. To bairi, “Dio tʉpʉ cáatácʉ ãmi,” mʉre jã ĩ nʉcʉbʉgo. ");
INSERT INTO tav_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","32","To bairo jã caĩro apii ocõo bairo jã caĩwĩ Jesu tunu: —To bairo yʉre caĩ nʉcʉbʉgorã anibana quena petoacã bero noo mʉja cabooro mʉja ruti aá bategarã. Yʉre mʉja aáweocoagarã. Jĩcaʉna yʉ tuagʉ. Jĩcaʉna yʉ cãnibato quena, yʉ Pacʉ yʉ mena ãmi. ");
INSERT INTO tav_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yʉ jʉgori patowãcaricaro mano, uwiricaro mano mʉjaare to ãmaro. Ati yepapʉ mʉja cãno aperã yʉre caapiʉjaquẽna maca mʉjaare popiyeyegarãma. To bairo mʉjaare na capopiyeyebato quena tʉgooña ocabʉtiya. Ati yepa macana yʉre caapiʉjaquẽnare na yʉ canetotʉgawʉ mere, jã caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","To bairo ĩri bero tʉjʉ mʉgo, ocõo bairo cʉ caĩwĩ Jesu cʉ Pacʉ Diore: —Caacʉ, rooro yʉre na cátipe yʉre mʉ cacũrica paʉ ejatʉga mere. To bairi mʉ Macʉ yʉ cãniere camajare na iñooña. To bairo na mʉ cáti iñooro bero camaja caroaro mʉre na catʉgooña nʉcʉbʉgoro yʉ átigʉ. ");
INSERT INTO tav_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Camaja nipetirãre carotipaʉre yʉre mʉ cacũwʉ. Nipetirã yʉre mʉ cajooricarãre na catícõa aninucupere na joo rotii to bairo yʉre mʉ cacũwʉ. ");
INSERT INTO tav_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","To bairi camaja Dio, jĩcaʉna cariape cãcʉre caapi nʉcʉbʉgorã, yʉre mʉ cajooricʉ quenare caapi nʉcʉbʉgorã catícõa aninucugarãma. ");
INSERT INTO tav_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ati yepapʉre ãcʉ, camaja, “Caroaʉ ãmi Dio,” mʉre na caĩro yʉ cápʉ́. Nipetiro yʉre mʉ cáti rotiriquere yʉ cáti peocõawʉ. ");
INSERT INTO tav_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Caacʉ, ati yepa mʉ cátiparo jʉgoye mʉ mena yʉ cãnicõawʉ mere. Nemoona mʉ mena caroaro yʉ cãnicõa anieparore bairona yʉre ája tunu. ");
INSERT INTO tav_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ati yepa macana mena cãnibatanare mʉ cabejeyupa yʉ mena macana cãniparãre. Na tʉpʉre cʉ yʉ joogʉ yʉ Macʉre ĩi, to bairo mʉ cájupa. Mʉ cãniere na yʉ camajiowʉ. Mʉ yarã cãnanare yʉre mʉ cajoowʉ. Mʉ carotirijere cána cãma. ");
INSERT INTO tav_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yucʉacã caroaro majima: Nipetirije yʉ cáti majirije yʉre mʉ cajoorique ã. ");
INSERT INTO tav_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nipetiro nare yʉ mʉ cabuio rotiriquere na yʉ cabuiowʉ. Tiere na yʉ cabuioro caapi nʉcʉbʉgowã. Cariapena mʉ tʉpʉ cãnacʉ yʉ cáatájere, yʉre mʉ cajooriquere apiʉja nʉcʉbʉgoma. ");
INSERT INTO tav_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Na cabaipere na yʉ jeniboja mʉre. Aperã, ati yepa macana yʉre caapiʉjaquẽnare na yʉ jenibojaquẽe. Yʉre mʉ cajooricarã mʉ yarã ãma. To bairi na yʉ jeniboja mʉre. ");
INSERT INTO tav_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mʉ yarã cãna nipetirã yʉ quenare yʉ yarã ãma. Yʉ yarã cãna quena mʉ yarã ãma. Na jʉgori aperã quena, “Caroaʉ ãmi Jesu,” yʉre ĩ nʉcʉbʉgoma. ");
INSERT INTO tav_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ati yepapʉre yʉ tuaquetigʉ. Yʉ cabuerã jeto tuagarãma. Yʉa mʉ tʉpʉ aácʉ yʉ áa. Caacʉ, caroaʉ majuu aniri mʉ catutuarije mena caroaro na coteya yʉre mʉ cajooricarãre. To bairo mʉ cáto jĩcaʉna mani cãnore bairona jĩcaro mena anigarãma. ");
INSERT INTO tav_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ati yepapʉ ãcʉ, yʉre mʉ cajooricarã mena ãcʉ mʉ catutuarije yʉre mʉ cajoorique mena nare yʉ cacotenucuwʉ. To bairi jĩcaʉ maca yʉre yaji weoquẽmi. Jĩcaʉ jeto cajʉgoyepʉna yʉ mena cãnibatacʉ cayajipaʉ ãmi. Mʉ caĩricarore bairona cʉ jetona yʉre yaji weomi. To bairo cʉ cayaji weoro Dio ye queti ucarica pũuripʉ tirʉmʉpʉ macana na caĩ ucaricarore bairo cariapena bai. ");
INSERT INTO tav_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Yucʉacã mʉ tʉpʉ aácʉ yʉ áa. Ati yepapʉ ãcʉ mʉ ye quetire yʉ cabuionucuwʉ. Nare yʉ cabuionucuwʉ yʉ yarã na cãni wariñuu netoparore bairo ĩi. ");
INSERT INTO tav_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yʉre mʉ cabuio rotiriquere na yʉ cabuio netonucuwʉ. Tiere yʉ cabuioro caapiʉjarã aniri ati yepa macana majuu me ãma. Yʉ quena ati yepa macacʉ mee yʉ ã. To bairi na quena yʉre bairona cãnicõa aninucuparã ãma. To bairo ati yepa macana mena cãniquẽna na cãno yʉ cabuiorijere caapiʉjaquẽna maca na tʉjʉteema. ");
INSERT INTO tav_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ati yepapʉ yʉre cabooquẽna watoapʉ cãnare nemoona mʉ tʉpʉ na jee aácʉja yʉ yarãre ĩi mee yʉ ĩ. Sataná caroorije nare cʉ cáti rotigaro na matabojaya ĩi, to bairo yʉ ĩ. ");
INSERT INTO tav_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ati yepa macacʉ yʉ aniquẽe yʉa. Na quena ati yepa macana majuu me ãma. ");
INSERT INTO tav_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mʉ ye queti cariape macajere na caapiʉjaro na ája. To bairo tiere na caapiʉjaro mʉ yarã caroarã majuu na cãno na mʉ átigʉ. Mʉ ye queti caĩtorije me ã. Cariape macaje ã. ");
INSERT INTO tav_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mʉ ye quetire ati yepa macanare yʉre buio rotii yʉ mʉ cajoowʉ. To bairona yʉ quena yʉ buerãre ati yepa macana aperãre na buioato ĩi, na yʉ joo. ");
INSERT INTO tav_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yʉ majuuna na ye wapa na yʉ bai yajibojagʉ. To bairo yʉ cabairo na quena mʉ ye queti cariape cãniere apiʉjari mʉ yarã majuu caroarã anigarãma. ");
INSERT INTO tav_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Yʉ buerã jeto meere na jenibojaʉ yʉ áa. Caberopʉ na cabuiorijere caapi nʉcʉbʉgoparã quenare na yʉ jeniboja mʉre. ");
INSERT INTO tav_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Jĩcaʉna mani cãnore bairona jĩcaro mena na ãmaro ĩi, na yʉ jeniboja. Caacʉ, yʉ mena mʉ cãnore bairo, yʉ quena mʉ mena yʉ cãnore bairo na quena jĩcaro mena na ãmaro. To bairo jĩcaro mena caroaro na cãno tʉjʉrã aperã quena ati yepa macana, “Dio cʉ cajooricʉna ãmi Jesu,” ĩ nʉcʉbʉgogarãma na quena. ");
INSERT INTO tav_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Caroa majuu cãniere yʉre mʉ cajooriquere na yʉ cajoo netowʉ, jĩcaro mani cãnore bairona na quena jĩcaro mena na ãmaro ĩi. ");
INSERT INTO tav_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na menapʉre yʉ ã. Mʉ maca yʉpʉre mʉ ã. To bairi na quena jĩcaro mena anigarãma. To bairo na cabairo tʉjʉ cõoñari aperã ati yepa macana quena, “Dio ʉmʉrecoo macacʉ cʉ cajooricʉna ãmi Jesu,” ĩ majigarãma. “Cʉ̃re caapiʉjarãre na maimi Dio, cʉ Macʉre cʉ camairore bairona,” ĩ majigarãma. ");
INSERT INTO tav_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ati yepare átigʉ jʉgoyepʉna mere yʉre mʉ camaiwʉ. Yʉre maii caroa majuu cãniere yʉre mʉ cajoowʉ. Yʉre caapiʉjarã yʉre mʉ cajooricarã na quena yʉ mena mʉ tʉpʉ na cáaápere yʉ boo. Caroa majuu yʉ cãniere yʉre mʉ cajooriquere na tʉjʉato ĩi, mʉ tʉpʉ na cáaápere yʉ boo. ");
INSERT INTO tav_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Caacʉ, caroa jetore cátinucuʉ mʉ ã. Caroare cácʉ mʉ cãnibato quena ati yepa macana mʉre majiquẽema. Mʉre yʉ maji yʉa. Ati maja yʉ buerã quena majima yʉre mʉ cajooriquere. ");
INSERT INTO tav_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","To bairi mʉ cãniecʉtiere nare yʉ camajionucuwʉ. Nare yʉ majio janaquetigʉ. To bairona na yʉ majiocõa aninucugʉ. Napʉre yʉ anicõagʉ. To bairo napʉre yʉ cãno caame mairã anicõa aninucugarãma. Yʉre mʉ camairore bairona na quena ame maigarãma. To bairi yʉ quena na mena yʉ anicõa aninucugʉ, na caĩ jenibojawĩ Jesu cʉ buerãre cʉ Pacʉ Diore yua. ");
INSERT INTO tav_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu cʉ Pacʉre cʉ cajeniro bero Jerusalẽpʉ cãnana jã cáaápʉ. Aána Cedrón cawamecʉti ya riaacãre jã capeña aápʉ. Ti yaacãre peña, ape nʉgoapʉ Olivo na caoterica yepa cãmʉ. Topʉ jã caejawʉ Jesu mena. ");
INSERT INTO tav_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas Jesure catʉjʉ teerãre cañe rotipaʉ quena camajiwĩ ti paʉ olivo oterica yepare. Jesu topʉ nairoacã jãre cajʉgo aáteñanucuwĩ. To bairi caroaro camajiwĩ Judas. ");
INSERT INTO tav_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","5","Topʉ jã cãni paʉ polisía maja mena caejawĩ Judas. Aperã Dio wiire cacoterã polisía quena caejawã Judas mena. Sacerdote maja ʉparã, fariseo maja na cajooricarã cãma. Caroaro cabeju wamooricarã cãma. To bairi na cajĩa bujuricʉri mena cajĩa buju ejawã. Judas, Jesure cawadajãricʉ na mena cãmi. Jesu camaji tʉgayupi cʉ̃re cabaipere. To bairo majitʉgabacʉ quena na bocaʉ: —¿Ñamʉre mʉja macati? caĩwĩ. Ocõo bairo cʉ caĩ yʉwã: —Jesu, Nasaré macacʉre jã maca, caĩwã. Jesu na caĩwĩ tunu: —Cʉna yʉ ã. ");
INSERT INTO tav_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesu, “Cʉna yʉ ã,” cʉ caĩro api acʉari, cauwi dui tunu re cumuwã. ");
INSERT INTO tav_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","To bairo na cabairo: —¿Ñamʉre mʉja macati? na cajeniñanemowĩ Jesu tunu. —Jesu, Nasaré macacʉre jã maca, cʉ̃re caĩ yʉwã cʉ̃re cañerã atána tunu. ");
INSERT INTO tav_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","To bairo na caĩro: —Mere, “Yʉna yʉ ã,” mʉjaare yʉ ĩtʉgawʉ, na caĩwĩ Jesu. —To roquere yʉre mʉja camacaata ati majare yʉ buerãre na buti aá rotiya. ");
INSERT INTO tav_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cajʉgoye Jesu cʉ cabuiorique cariape to baiato ĩi, to bairo caĩwĩ. Ocõo bairo cʉ caĩrique cãmʉ: “Yʉ Pacʉ yʉre cʉ cajooricarãre jĩcaʉ maca yʉre yaji weoquẽmi,” ĩrique cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","To bairo tiere cʉ caĩro Simón Pedro cʉ jarerica pãire cayo we newĩ. Yo we ne, sacerdote maja ʉpaʉre capaa coteri majocʉ Malco cawamecʉcʉre cariape nʉgoa macá amoorore capa ta ñoocõa joowĩ. ");
INSERT INTO tav_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","To bairo cʉ cáto tʉjʉʉ ocõo bairo cʉ caĩwĩ Jesu Pedrore: —Mʉ jarerica pãire quenoo cũña. Yʉ Pacʉ cʉ capopiye tamʉo rotiricarore bairona yʉ popiye tamʉogʉ, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","To bairi polisía maja, na ʉpaʉ mena, aperã sacerdote maja ʉparã na cajooricarã mena Jesure cʉ jia turi, cʉ canecoama Aná cawamecʉcʉ ya wiipʉ. Caifá mañicʉ cãmi cʉ̃a. Caifána cãmi sacerdote maja ʉpaʉ ti cʉmare. ");
INSERT INTO tav_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifána cajʉgoyepʉre judío majare: “Jĩcaʉ jeto romano majare cʉ cajĩa ecooro ñuugaro. To bairi nipetirã ye wapa manire cabai yajibojaʉ anigʉmi,” caĩricʉ cãmi. ");
INSERT INTO tav_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesure na cañe aáto Simón Pedro, yʉ quena nare jã caʉja aápʉ. Sacerdote maja ʉpaʉ yʉre catʉjʉ majiwĩ. To bairi cʉ ya wiire cʉ cajani jãarica janiro pupeapʉre yʉ cajãa aápʉ. ");
INSERT INTO tav_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro maca jopepʉna catuanʉcawĩ. To bairo cʉ cabairo tʉjʉʉ jope cacoteore jeniri cʉ̃re yʉ capijo jõowʉ. ");
INSERT INTO tav_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","To bairi Pedro cʉ cajãaro co maca cʉ cajeniñawõ: —¿Mʉa cʉ mena macacʉ mee mʉ ãti? To bairo co caĩro: —Yʉ aniquẽe, co caĩwĩ Pedro. ");
INSERT INTO tav_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Seeto cajoowʉ. To bairi ti wiire paa coteri maja polisía maja mena capero riowã. Ti pero tʉ cajuma tʉjʉnucucõawã. Pedro quena na mena cajumaʉ aámi. ");
INSERT INTO tav_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sacerdote maja ʉpaʉ Jesure ocõo bairo cʉ caĩ jeniñawĩ yua: —¿Di maja una na ãti mʉ cabuerã? ¿Ñe uniere nare mʉ buenucuti? cʉ caĩ jeniñawĩ. ");
INSERT INTO tav_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","To bairo cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Nipetirã na caapijoropʉ yʉ cabuiowʉ judío maja neñapo buerica wiiripʉ, Jerusalén macá wii Dio wiipʉ quenare yʉ cabuionucuwʉ. Yajioropʉ yʉ cabuioquetinucuwʉ. ");
INSERT INTO tav_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nope ĩi yʉre mʉ jeniñati? Aperã yʉre caapiricarãre na jeniñaña. Yʉ cabuionucuriquere majirãma. To bairi mʉre buiogarãma, cʉ caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","To bairo Jesu cʉ caĩro apii jĩcaʉ polisía Dio wiire coteri majocʉ Jesu riyare cʉ pari ocõo bairo cʉ caĩwĩ: —¿Ñeere ĩi to bairo rooro mʉ yʉti sacerdote maja ʉpaʉre? ");
INSERT INTO tav_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu maca ocõo bairo cʉ caĩwĩ: —Jocʉna yʉ caĩata yʉ caĩtori wame macare ĩ buioya. Cariapena yʉ caĩbato quena ¿nope ĩi yʉre mʉ pati? cʉ caĩwĩ Jesu polisíare. ");
INSERT INTO tav_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Cabero Aná Jesure jia turicʉpʉre cʉ cajoowĩ sacerdote maja ʉpaʉ Caifá tʉpʉre. ");
INSERT INTO tav_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","To bairo cabairi paʉ Pedro pero tʉ cajuma tʉjʉnucuwĩ. Topʉ cʉ catʉjʉnucuro cʉ cajeniñawã: —¿Mʉa jĩ mena macacʉ mee mʉ áti? cʉ caĩ jeniñawã. To bairo cʉ na caĩro: —Cʉ mee yʉ ã, na caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Cabero jĩcaʉ sacerdote maja ʉpaʉre capaa coteri majocʉ Pedrore cʉ caĩwĩ tunu: —Mepʉ mʉ yʉ tʉjʉwʉ Olivo na caotericaropʉ cʉ mena mʉ cãno, cʉ caĩwĩ. To bairo caĩi Pedro cʉ amooro cʉ capa taricʉ bai cãmi. ");
INSERT INTO tav_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","To bairo cʉ̃re cʉ caĩro apii Pedro: —Yʉ aniquẽe, cʉ caĩtowĩ tunu. To bairo cʉ caĩtori paʉna ãbocʉ cawadawĩ yua. ");
INSERT INTO tav_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cabero cabujuparo jʉgoyeacã Jesu Caifá ya wiipʉ cãnacʉre cʉ cane aáma romano maja ʉpaʉ majuu cʉ cacũricʉ cʉ carotibojaʉ ya wiipʉre. Jesure cañericarã judío maja aniri ti wiipʉre cajãaquẽma. Romano maja ya wiipʉre na cajãa aápata pascua macaje boje ʉga rotiya maniboricaro. Caʉgueri pairãre bairona tuaboricarãma. To bairi Pilato ya wiipʉre cajãaquẽma, judío majocʉ aniquẽemi ĩrã. ");
INSERT INTO tav_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Na cajãagaquẽto tʉjʉʉ Pilato cabuti amí, na mena wadapenigʉ. Ocõo bairo na caĩwĩ: —¿Ñee unie caroorije cácʉ ãmi ĩrã anire mʉja wadajãti? ");
INSERT INTO tav_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ocõo bairo cʉ caĩwã judío maja maca: —Caroorije cátiquẽcʉ cʉ cãmata mʉ tʉpʉ cʉ̃re jã ne atíquetiboricarã. ");
INSERT INTO tav_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","To bairo na caĩro apii Pilato na caĩwĩ tunu: —Cʉ ne aánaja. Mʉja majuuna mʉja carotirique cʉtinucurore bairona cʉ jeniñari cʉ popiyeyeya. To bairo cʉ caĩro judío maja ʉparã ocõo bairo cʉ caĩwã Pilatore: —Jãre judío majare jã jĩa rotiquẽema mʉ yarã ʉparã gobierno maja. ");
INSERT INTO tav_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","To bairi cariapena cabaiwʉ, “Yucʉ tẽorica pãipʉ yʉre tu mʉgo nʉco jĩagarãma,” Jesu to jʉgoyepʉ jãre cʉ caĩ buiorica wamere bairona. ");
INSERT INTO tav_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","To bairi Pilato cʉ ya wiipʉ jãa átiri Jesu quenare cʉ cajãa rotiwĩ. Cʉ jãa roti, ocõo bairo cʉ caĩ jeniñañupʉ: —¿Mʉna judío maja Ʉpaʉ mʉ ãti? ");
INSERT INTO tav_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu ocõo bairo cʉ caĩ yʉyupʉ Pilatore: —¿Mʉ majuu mʉ catʉgooñari wamere yʉre mʉ jeniñati? o ¿aperã judío maja mʉre na buioti que? cʉ caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","To bairo cʉ caĩro: —Judío majocʉ mee yʉ ã. Yʉa judío maja mʉja cáti aniere yʉ majiquẽe. Mʉ ya yepa macana judío maja, sacerdote maja ʉparã, ¿ñe unie mʉ cáti buicʉto atopʉ mʉre na neatí? Jesure cʉ caĩñupʉ Pilato. ");
INSERT INTO tav_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","To bairo cʉ caĩro Jesu cʉ caĩñupʉ tunu Pilatore: —Yʉa ati yepa macana ʉpaʉ mee yʉ ã. Ati yepa macana ʉpaʉ yʉ cãmata judío maja ʉparã yʉre na cajĩagaro yʉre caapiʉjarã maca na quẽborãma. Yʉre na cajĩagaro matabojarã na quẽborãma. Ati yepa macana ʉpaʉ mee yʉ ã yʉa. ");
INSERT INTO tav_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","To bairo cʉ caĩro apii Pilato cʉ caĩñupʉ: —¿To roquere ʉpaʉ majuu mʉ ãti? To bairo cʉ caĩro: —Mʉ caĩrore bairona ʉpaʉ majuuna yʉ ã, cʉ caĩñupʉ Jesu Pilatore. —Cariape macajere buioʉ acʉ́ ati yepapʉ yʉ cabuiawʉ. Nipetirã cariape macajere caboorã yʉ cabuiorijere apiʉjama, caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","To bairo cʉ caĩro: —¿Dije unie majuu to ãti cariape macaje? cʉ caĩñupʉ Pilato. Pilato to bairo Jesure jeniñari bero judío maja ʉparã mena wadapenigʉ cabuti ejawĩ tunu. Buti ejaʉ, ocõo bairo na caĩwĩ: —Caroorijere cátacʉ ãmi, cabui pacoʉna ãmi, yʉ ĩ majiquẽe. ");
INSERT INTO tav_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mʉja cabainucurije ocõo bairo ã: Pascua boje rʉmʉ cãno jĩcaʉ presopʉ cãcʉre yʉre mʉja buu rotinucu. To bairi Jesure, ¿judío maja Ʉpaʉ macare yʉ cabuuro mʉja booti? ");
INSERT INTO tav_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","To bairo cʉ caĩro apirã seeto awajarique mena ocõo bairo cʉ caĩ awajawã Pilatore: —Cʉ̃re buuqueti majuucõaña. Barrabá macare cʉ buu jooya, caĩ awajawã. Barrabá cajee ruti paii cãmi. ");
INSERT INTO tav_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Camaja, “Barrabá macare cʉ buuya,” na caĩ awajaro apii Jesure na cabape rotiwĩ Pilato. ");
INSERT INTO tav_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cʉ yarã polisía pota beto cʉ rʉpoapʉre capeowã. To bairi jutiiro cajũabʉjariro ʉpaʉ cʉ cajañari yeje unore cʉ cajãawã Jesure. ");
INSERT INTO tav_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Cabero cʉ tʉpʉ aá, ocõo bairo cʉ caĩ epewã: —¡Judío maja Ʉpaʉ caroa cʉ̃re to ãmaro! To bairo ĩ eperãna cʉ riyare capanucuwã. ");
INSERT INTO tav_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Cabero Pilato cʉ ya wiipʉ cãnacʉ cabuti ejawĩ tunu. Buti ejaʉ, camajare na caĩwĩ: —Ñe unie majuu caroorije cácʉ ãmi, cabui pacoʉ ãmi, ĩrica wame yʉ bʉgaqueti majuucõa. To bairi mʉja tʉpʉ cʉ yʉ pi buti atígʉ. Mʉja tʉjʉ majigarã. ");
INSERT INTO tav_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","To bairi Jesure cʉ cane buti ejawã. Jesu maca buti ejaʉ pota beto cʉ̃re na peorica betore capejawĩ cʉ rʉpoapʉ. Ʉpaʉ ya jutiiro polisía maja na cajãricaro quenare cajaña buti ejawĩ. Cʉ̃re na cane buti ejaro Pilato ocõo bairo na caĩwĩ camajare: —¡Tʉjʉya! Anina ãmi. ");
INSERT INTO tav_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","To bairo cʉ̃re tʉjʉrã sacerdote maja ʉparã, aperã Dio wii cacoterã polisía maja seeto caĩ awajawã: —¡Yucʉ tẽorica pãipʉ cʉ̃re na papua jĩacõato! cʉ caĩ awajawã Pilatore. Pilato ocõo bairo na caĩwĩ: —Mʉja majuuna yucʉ tẽorica pãipʉ cʉ papua jĩarãja. Yʉa, “Caroorije cátacʉ ãmi, cabui pacoʉna ãmi,” yʉ ĩ majiquẽe, caĩwĩ Pilato. ");
INSERT INTO tav_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judío maja ʉparã maca cʉ caĩwã: —Cʉ majuuna, “Yʉa Dio Macʉna yʉ ã,” jã caĩwĩ. To bairije caĩi ũcʉre cajĩape ã. To bairona áti rotirique ã jãre, caĩwã Pilatore. ");
INSERT INTO tav_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato, “ ‘Dio Macʉna yʉ ã,’ caĩwĩ,” na caĩrijere apii netobʉjaro cauwiwĩ yua. ");
INSERT INTO tav_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","To bairi Jesure cʉ pi jãa, cʉ cajeniñawĩ tunu: —¿Noopʉ cáatácʉ mʉ ãti mʉa? To bairo cʉ̃re cʉ caĩ jeniñaro Pilatore cʉ cayʉquẽjupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Cʉ cayʉquẽto tʉjʉʉ Pilato cʉ caĩñupʉ tunu: —¿Nope ĩi yʉre mʉ yʉquẽeti? ¿Mʉ majiquẽeti? Mʉre yʉ cabuugaata mʉre yʉ buu maji. Mʉre yʉ cajĩa rotigaata quenare mʉre yʉ jĩa roti maji polisía majare. ");
INSERT INTO tav_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","To bairo Pilato cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Dio to bairo mʉre cʉ cáti rotiquẽpata to bairo yʉ cabaipere carotii mʉ aniquetiboʉ. To bairi mʉ tʉpʉ yʉre cajooricʉ mʉ netoro cabai bui pacoʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","To bairo cʉ caĩro apii Pilato, ¿dope bairo majuu Jesure yʉ buugabauti? seeto caĩ tʉgooñawĩ. To bairo cʉ cátigaro tʉjʉrã judío maja ʉparã seeto caĩ awajawã: —¡Cʉ̃re mʉ cabuuata romano maja ʉpaʉre caneto nʉcaʉrena mʉ buuboʉ! Nii, “Yʉ majuuna ʉpaʉ yʉ ã,” caĩi ũcʉ romano maja ʉpaʉre caneto nʉcaʉ ãmi. ¡To bairi romano maja ʉpaʉre camaii mee mʉ ã Jesure mʉ cabuuata! caĩ awajawã. ");
INSERT INTO tav_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","To bairo na caĩ awajaro apii Pilato Jesure capi buti aá rotiwĩ, ʉ̃ta pãiri na cawe cũrica yepapʉ. Hebreo ye mena Gabata cawamecʉpʉ. Topʉ Pilato camajare cajeniña bejenucuwĩ. To bairi topʉ caruiwĩ. ");
INSERT INTO tav_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jĩca rʉmʉ carʉjawʉ pascua boje rʉmʉ cáaáparo jʉgoye. Paaribota majuu cãmʉ. To bairi Pilato topʉ rui, ocõo bairo caĩwĩ judío maja ʉparãre: —Mʉja Ʉpaʉre cʉ tʉjʉya. ");
INSERT INTO tav_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","To bairo cʉ caĩro apirã caawajanemowã: —¡Cʉ̃re na jĩacõato! ¡Yucʉ tẽorica pãipʉ cʉ na papua jĩa rocacõato! caĩwã. To bairo na caĩ awajanemoro apii: —¿Mʉja Ʉpaʉrena yucʉ tẽorica pãipʉre na yʉ papua jĩa roticʉti? na caĩwĩ Pilato. To bairo cʉ caĩro sacerdote maja ʉparã ocõo bairo cʉ caĩwã: —Jã ʉpaʉ jĩcaʉna ãmi, romano maja ʉpaʉ majuu. ");
INSERT INTO tav_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","To bairo na caĩro apii Pilato polisía majare, “Yucʉ tẽorica pãipʉre cʉ papua jĩarãja,” na caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","To bairo cʉ caĩro cʉ canecoama Jesure yua. Cʉ̃rena yucʉ tẽorica pãire cʉ capʉja rotiwã. To bairi Jesu yucʉ tẽorica pãire capʉja aámi rʉpoa coro buuro na caĩropʉ aácʉ. Hebreo ye mena Gólgota cawamecʉpʉ. Ti buuro camajocʉ rʉpoa caboa werica corore bairo cabauwʉ. To bairi ti paʉre to bairo cawameyewã. ");
INSERT INTO tav_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Topʉ yucʉ tẽorica pãipʉre cʉ capapua tuwã Jesure. Aperã pʉgarã quenare to bairona cámá. Jesure na recomacapʉ cʉ canʉcowã. Jĩcaʉre cariape nʉgoa maca, apeĩre cacõ nʉgoa maca canʉcowã. ");
INSERT INTO tav_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato Jesu rʉpoa bui yucʉ tẽorica pãipʉ cʉ caucariquere catu rotiwĩ polisíare. Ocõo bairo caucayupi: “Jesu, Nasaré macacʉ judío maja Ʉpaʉ ãmi.” ");
INSERT INTO tav_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tie ucarique hebreo ye, griego ye mena, latín ye mena ucarique cãmʉ. Jesure na capapuarica paʉ Jerusalén maca tʉna cãmʉ. To bairi capãarã judío maja tiere catʉjʉwã. ");
INSERT INTO tav_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tie ucariquere tʉjʉrã sacerdote maja ʉparã Pilatore ocõo bairo caĩñuparã: —Judío maja Ʉpaʉ ãmi, caĩ ucaquetipe ã. Ocõo bairo maca caucape ã: “ ‘Judío maja Ʉpaʉ yʉ ã,’ caĩwĩ,” caĩ ucape ã, caĩwã Pilatore. ");
INSERT INTO tav_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","To bairo na caĩro: —Mere yʉ uca tutʉgawʉ. Yʉ wajoaquẽcʉ, na caĩwĩ Pilato. ");
INSERT INTO tav_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cabero bapari cãnacãʉ polisía maja Jesure capapuaricarã cʉ ye jutiire cajee neowã. Jee neo, na cãno cõo cajee batewã. Cʉ jutiiro cabui macato cae turoya mamʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","To bairi polisía maja ocõo bairo caame ĩwã: —Atore mani wooqueticõarã. Mani ĩ bʉga eperã. ¿Ñamʉ maca cʉ ĩ bʉgaʉati ati yejere? caĩwã. To bairo na cáto Dio ye queti ucarica pũuripʉ ucarique cariape cabaiwʉ. Ocõo bairo ucarique cãmʉ: “Yʉ jutiire caricawowã. Tiere boorã caĩ bʉga epewã.” Tie to caĩrore bairona cámá polisía maja cʉ̃re. ");
INSERT INTO tav_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yucʉ tẽorica pãi Jesure na capapuarica pãi tʉpʉre bapari cãnacão cãromia catʉjʉnucuwã. Cʉ paco, cʉ mʉgo, apeo María Cleopas nʉmo, María Magdalena, to cãnacãona topʉ catʉjʉnucuwã. ");
INSERT INTO tav_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu cʉ pacore, yʉ seeto cʉ camaii co tʉ yʉ catʉjʉnucuro tʉjʉʉ ocõo bairo co caĩwĩ: —Caaco, ani mʉ macʉ ãmi. ");
INSERT INTO tav_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cabero yʉre caĩwĩ: —Tona ãmo mʉ paco, caĩwĩ Jesu. Mʉ paco majuure bairona yʉ pacore co jʉgo ãña ĩi, yʉ caĩwĩ. Cabero cõre yʉ cane aápʉ yʉ ya wiipʉ, yʉ tʉpʉ co anicõato ĩi. ");
INSERT INTO tav_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesu cʉ pacore yʉre cʉ cajʉgo ani rotiro bero, “Nipetirije Dio yʉre cʉ cáti rotiriquere yʉ áti peocõawʉ,” caĩ majiwĩ Jesu. To bairi Dio ye queti ucarica pũuropʉ ucarique to bairona baigaro ĩi, ocõo bairo caĩwĩ: —Yʉ oco etigacʉpʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Topʉre ʉje oco capiyarije cajañari rʉ cãmʉ. To bairi polisía maja carupa bʉrʉare ne átiri caweyoo newã ti jotʉpʉre. Weyoo ne átiri yucʉ hisopo cawame cʉtiipʉ ti bʉrʉare dʉre turi, cañu mʉgo joowã Jesu tʉpʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","To bairo na cáto tiere caetiñawĩ Jesu. Etiña yaparoʉ: —Nipetiro yʉ áti peocõa mere, caĩwĩ Jesu. To bairo ĩ yaparo cʉ rʉpoare roca yo, cabai yajicoami yua. ");
INSERT INTO tav_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jesu cʉ cabai yajiri paʉre jĩca rʉmʉ carʉjawʉ mai pascua boje rʉmʉ cãniparo jʉgoye. Ti boje rʉmʉ sábado judío maja na cayerijãri rʉmʉ cãni majuuri rʉmʉ cãmʉ. Ti rʉmʉ cãno cabai yajiricarã yucʉ tẽorica pãipʉ na catujaro cabooquẽjuparã judío maja ʉparã. To bairi Pilato tʉpʉ aá, cʉ yarã polisía majare na ñicaarire capa pe rotiyuparã, yoaro mee na bai yajiato ĩrã. “Cabero cabai yajiricarãpʉre ne ruio, aperopʉ na mʉja jeecoapa,” caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","To bairi polisía jĩcaʉ ye ñicaarire capa pe jʉgowã. Cabero apeĩ quenare to bairona capa pe jĩawã. ");
INSERT INTO tav_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesu macare mere cabai yajiricʉpʉre catʉjʉwã. To bairi cʉ ñicaarire capa pequẽma. ");
INSERT INTO tav_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Cabai yajiricʉ cʉ cãnibato quena jĩcaʉ polisía Jesu waruure cʉ ãpoa bejuro mena cajarewĩ. To bairo cʉ cáto rií, oco mena cabutiwʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yʉ majuuna to bairijere yʉ catʉjʉwʉ. Cariapena ã. Mʉja quena Jesu ye quetire api nʉcʉbʉgoya ĩi, mʉjaare yʉ ĩ buio ati pũurore ucaʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Atie to bairo cabaiwʉ Dio ye queti ucarica pũuripʉ tirʉmʉpʉ macana na caucaricarore bairona. Ocõo bairo Jesu cʉ cabaipere ĩ ucarique cãmʉ: “Cʉ õwaa jĩca õwaro uno pa pe ecooya manigaro.” ");
INSERT INTO tav_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ape wame quena Dio ye queti ocõo bairo ĩ ucarique cãmʉ: “Na cacamiyericʉre tʉjʉjogarãma.” ");
INSERT INTO tav_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesure na cajarericaro bero José Arimatea cawamecʉti maca macacʉ Pilatore Jesu rupaʉ ãnatore cajeniñupʉ. Jesure canʉcʉbʉgoʉ cãmi José. Jesure nʉcʉbʉgobacʉ quena aperãre caĩ buioquẽmi, judío maja ʉparãre uwibacʉ. To bairi Pilato, “Jaʉ, cʉ ne aácʉja,” cʉ caĩro apii Jesu rupaʉre cane ruiowĩ. ");
INSERT INTO tav_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo cajʉgoye ñamipʉ Jesure cajeniña ejaricʉ quena capee treinta kilos cajʉti ñuurije cajee ajupi. Tie cajʉti ñuurije mirra, áloes cawamecʉtie mena ajurique cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na pʉgarã José, Nicodemo mena juti ajeripʉre cajʉti ñuurijere pio tu átiri, ti ajeri mena Jesu rupaʉ ãnatore caumawã. Judío maja cabai yajiricarãre yaarã na cátinucurore bairona cámá. ");
INSERT INTO tav_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","To bairi Jesure na capapuarica paʉ tʉpʉ jĩca janiro na caoterica janiro cãmʉ. Ti janiro pupeapʉ jĩca ope maja ope ʉ̃tapʉre na cawerica ope cãmʉ, carupa toti yua. Ti toti cabai yajiricʉre cañujo rocaya mani toti cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Muipu cʉ caroca jãa aáti paʉ cãmʉ mere. Judío maja na capaa rotiqueta rʉmʉ cãnipa rʉmʉ cãmʉ. To bairi ti toti catʉacã cãno maca Jesu rupaʉ ãnatore ne aá, ti totipʉre cʉ cañujo rocawã. ");
INSERT INTO tav_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cabero ape semana cãni jʉgori rʉmʉ cabujuwʉ yua yerijãrica rʉmʉ bero cãni rʉmʉ. Cabujuri paʉ jʉgoye María Magdalena Jesu maja opepʉ catʉjʉo aájupo. Aá, topʉ eja, ti opere na cabiabata cuiro ʉ̃ta cuiro aperopʉ cacuñaro catʉjʉyupo. ");
INSERT INTO tav_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","To bairi jã tʉpʉ caatʉ tunu ajupo. Yʉ, Pedro mena jã cãnopʉ atʉ tunu ejao, ocõo bairo jã caĩ buiowõ: —Mani Ʉpaʉre aperopʉ cʉ necoajupa. Noopʉ cʉ ne aána ne aátanama, caĩwõ. ");
INSERT INTO tav_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","To bairo co caĩro apirã jã Simón Pedro, yʉ, cʉ̃re na carocaricaropʉ jã catʉjʉra aápʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Topʉ aána Pedro netoro yʉ caatʉ ocabʉtiwʉ. To bairi cʉ jʉgoye yʉ caejacoapʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Topʉ ejaʉ ti totipʉ yʉ camubia tʉjʉwʉ, jãaquẽcʉna. Topʉ capejawʉ cʉ̃re na caumarica ajeri jeto. ");
INSERT INTO tav_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉ bero maca Pedro caatʉ ejawĩ. Cʉ̃a cariapena cajãacoami. Cʉ quena catʉjʉwĩ tie juti ajerire. ");
INSERT INTO tav_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ape ajero Jesu rʉpoare na caumarica ajero quena topʉ capejawʉ. Ape ajeri mena cãniquẽpʉ. Ape paʉpʉ tuperica ajero capejawʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yʉ quena cʉ bero ti totipʉ yʉ cajãa aápʉ. Nipetiro ti ajerire tʉjʉʉ yʉ catʉgooña bʉga nʉcʉbʉgowʉ, “Yʉ tunu catigʉ,” Jesu jãre cʉ caĩriquere. ");
INSERT INTO tav_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Dio ye queti ucarica pũuripʉ Jesu cabai yajiricʉpʉ tunu catigʉmi caĩrijere jã caapi puoquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","To bairi ti totire tʉjʉ yaparori jã ya wiipʉ jã catunucoapʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalena maca ti toti tʉpʉna caoti tua nʉcacõawõ. Otiona co quena ti totipʉ camubia tʉjʉ jõoñupo. ");
INSERT INTO tav_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","To bairo mubia tʉjʉ jõobaco pʉgarã jutii cabotirijere cajañarãre ángel majare catʉjʉyupo. Jesure na capeobata paʉpʉre caruiyuparã. Jĩcaʉ Jesu rʉpoa cãnatopʉ, apeĩ cʉ rʉpori cãnatopʉ caruiyuparã. ");
INSERT INTO tav_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","To bairo nare co catʉjʉro ocõo bairo co caĩ jeniñañuparã: —¿Nope ĩo mʉ otiti? Co maca na caĩñupo: —Yʉ Ʉpaʉre necoajupa. ¿Noopʉ na ne aájupari? yʉ ĩ majiquẽe. ");
INSERT INTO tav_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","To bairo ĩ, amojore nʉca tʉjʉo, Jesure co tʉna cʉ catʉjʉnucuro catʉjʉyupo María Magdalena. “Jesuna ãmi,” caĩ tʉjʉ majiquẽjupo. ");
INSERT INTO tav_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","To bairi Jesu co caĩ jeniñañupʉ: —¿Nope ĩo mʉ otiti? ¿Ñamʉre macao mʉ áati? Na caoterica janirore cacotei ãcʉmi, caĩ tʉgooñabajupo. To bairi: —Mʉna cʉ̃re cane aátacʉ mʉ cãmata topʉ yʉ cũwʉ, yʉ ĩ buioya. Yʉre mʉ caĩ buioro apero maca cʉ̃re yʉ ne aágo, caĩñupo María. ");
INSERT INTO tav_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","To bairo co caĩro: —¡María! co caĩñupʉ Jesu. To bairo cʉ caĩro apio amojore tʉjʉri, cʉ caĩñupo: —¡Raboni! Ti wame hebreo ye mena, “Yʉre camajioʉ,” ĩgaro ĩ. ");
INSERT INTO tav_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu co caĩñupʉ yua: —Yʉre ruuya. Yʉ Pacʉ tʉpʉ yʉ wamʉ aáquẽpʉ mai. Yʉ buerã cãnieparãre na buiója. Ocõo bairo ĩwĩ, na ĩ buioya: “Cʉ̃a cʉ Pacʉ tʉpʉ, ‘Aácʉ yʉ áa,’ ĩwĩ. ‘Cʉ̃a yʉ Pacʉ, mʉja Pacʉ quena ãmi Dio,’ ĩwĩ,” na ĩña, co caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","To bairo cʉ caĩro apio María Magdalena jã tʉpʉ cʉ buerã cãnana tʉpʉ cabuio ejawõ. Ejao cʉ̃re co catʉjʉriquere, cõre cʉ caĩriquere jã caĩ buiowõ. ");
INSERT INTO tav_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","To bairo cabairi rʉmʉ judío maja na yerijãrica rʉmʉ bero macá rʉmʉ cãmʉ mai. Ti rʉmʉ canaiori paʉ bero jã cʉ buerã cãnana jã caneñapowʉ. Judío maja ʉparãre uwirã caroaro jã cabiacõa jãapʉ. Topʉ jã cãni paʉ Jesu jã watoapʉ cabuia ejanʉcawĩ. Buianʉca eja, jãre cañuu rotiwĩ: —Caroaro wariñuurique mʉjaare to ãmaro. ");
INSERT INTO tav_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","To bairo jã ĩ, cʉ̃re na capapuariquere, cʉ̃re na cajarerica paʉre jã caiñoowĩ ti camiire. Cʉ̃re tʉjʉrã seeto jã cawariñuuwʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Cʉ maca jã caĩnemowʉ tunu: —Caroaro wariñuurique mʉjaare to ãmaro. Yʉ Pacʉ yʉre cʉ cajooricarore bairona yʉ quena yʉ ye quetire buio rotii mʉjaare yʉ joo. ");
INSERT INTO tav_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","To bairo ĩi, jãre puti peó, ocõo bairo jã caĩwĩ: —Espíritu Santo mʉja mena cʉ ãmaro. ");
INSERT INTO tav_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aperã caroorije na cátajere mʉja camajirioro cabui mana anigarãma. Nare mʉja camajirioquẽto camajirioya mana anigarãma, caĩwĩ Jesu. ");
INSERT INTO tav_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás Jesu buei cãnacʉ casʉ̃rʉaricʉ na caĩnucuʉ Jesu jã tʉpʉ cʉ cabuia ejanʉcaro camami. ");
INSERT INTO tav_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Cabero cʉ catunu ejaro cʉ̃re jã caĩwʉ: —Mani Ʉpaʉre jã tʉjʉwʉ, cʉ jã caĩwʉ. Tomás maca ocõo bairo jã caĩwĩ: —Cʉ wamori na capapuarique camii wiere yʉ catʉjʉquẽpata, “Tunu catiyupi,” yʉ ĩ nʉcʉbʉgoquetigʉ. To bairi cʉ̃re na cajarerica camiro wirore yʉ capañaquẽpata mʉja caĩrijere yʉ nʉcʉbʉgoquetigʉ. Tiere pañacõaripʉ, “Cariapena ĩma,” mʉjaare yʉ ĩ nʉcʉbʉgogʉ. ");
INSERT INTO tav_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jĩca semana bero Jesu cʉ cabuia ejanʉcaro bero jã caneñapowʉ tunu. Ti paʉre Tomás quena jã mena cãmi. Ti wii jope biarica wii cãmʉ. To bairo to cãnibato quena Jesu jã watoapʉ cabuia ejanʉcawĩ. Buia ejari jã cañuu rotiwĩ: —Caroaro wariñuurique mʉjaare to ãmaro, caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","To bairo ĩ, ocõo bairo caĩwĩ Jesu Tomáre yua: —Tʉjʉya yʉ wamorire. Yʉre na cajarerica camiro wiro quenare pañaña. “Tunu catíquẽcʉmi,” ĩ nʉcʉbʉgoqueticõa baiquẽja. Yʉre api nʉcʉbʉgoya. ");
INSERT INTO tav_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","To bairo cʉ caĩro apii ocõo bairo cʉ caĩwĩ Tomás: —¡Jesu, yʉ Ʉpaʉ! ¡Mʉa, Diona mʉ ã! caĩwĩ. ");
INSERT INTO tav_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu maca ocõo bairo cʉ caĩwĩ: —Tomás, yʉ catunu catiro tʉjʉcõaripʉ yʉre mʉ nʉcʉbʉgo. Yʉre tʉjʉquetibana quena canʉcʉbʉgorã macare netobʉjaro caroaro wariñuuriquere na joogʉmi Dio. ");
INSERT INTO tav_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu jã catʉjʉrona apeye uniere capee cáti iñoowĩ. Tie nipetirije ati pũuropʉre yʉ ucaquẽe. ");
INSERT INTO tav_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nipetirijere ucaquetibacʉ quena atie jetore yʉ uca. Jesu Dio cʉ cajooricʉna ãmi, cʉ Macʉna ãmi, na ĩ nʉcʉbʉgoato ĩi to bairona yʉ uca. To bairi cʉ̃re nʉcʉbʉgorã, mʉja catícõa aninucugarã cʉ mena yua. ");
INSERT INTO tav_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cabero Jesu cabuia ejanʉcawĩ tunu Tiberia cawamecʉti ra tʉjaropʉ. Ocõo bairo cabaiwʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Topʉre cãna ato cãnacãʉna jã cãmʉ. Simón Pedro, Tomás casʉ̃rʉaricʉ na caĩnucuʉ, to bairi Natanael Galilea yepa Caná cawamecʉti maca macacʉ, aperã quena jã pʉgarã Sebedeo punaa jã cãmʉ. To bairi aperã pʉgarã Jesu cʉ cabuericarã cãma na quena. ");
INSERT INTO tav_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Topʉ jã cãni paʉ Simón Pedro ocõo bairo jã caĩwĩ: —Wai jĩaʉ aácʉ yʉ áa. —To bairo cʉ caĩro: —Jã quena mʉ mena jã aágarã, jã caĩwʉ. To bairi aá, cumuapʉ jã caeja jãawʉ. Eja jãa, ti ñamire jã cawai waja bujucõabapʉ. Jã cajĩaquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cabuju jʉgori paʉ cãno yua Jesu ti ra tʉjaropʉ cabuianʉcawĩ. “Cʉna ãmi,” jã caĩ tʉjʉ majiquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","To bairi: —¿Mʉja jĩari? jã caĩwĩ. —Jã jĩaqueti majuucõa, jã caĩwʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","To bairo jã caĩro apii, ocõo bairo jã caĩwĩ: —Cariape nʉgoa maca roca ñuaña mʉja bapire. To bairo ána mʉja jĩagarã. To bairi cʉ caĩrore bairona jã cápʉ́. To bairo jã cáto capãarã majuu cajãawã. Capãarã majuu na cajãaro jã bapire jã cane mʉgo ocabʉtiquẽpʉ. To bairo cabairo tʉjʉʉ yʉa Juan, Jesu seeto cʉ camaii Pedrore cʉ yʉ caĩwʉ: —¡Mani Ʉpaʉna ãmi! ");
INSERT INTO tav_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","To bairo yʉ caĩro apii Simón Pedro cʉ jutiire cajañawĩ. Jañari Jesu tʉpʉ aágʉ caroca ñuawĩ. ");
INSERT INTO tav_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jã maca ʉtabʉcʉra tʉjaro cien metro cõo capajaricarã bapire wai capãarã cajañaricʉre jã cawe tʉ̃ga pua pã apʉ́ yua. ");
INSERT INTO tav_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Topʉ pã ejarã pero mere cariorica perore jã catʉjʉwʉ. Ti peropʉ jĩcaʉ wai pʉ̃o nʉcoricʉ cãmi. Pan quena jĩca cãmʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","To bairi jã capã ejaro ocõo bairo jã caĩwĩ Jesu: —Wai mʉja cajĩaricarãre na jee ajá. ");
INSERT INTO tav_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","To bairo cʉ caĩro Simón Pedro cumuapʉ eja jãa, waire cawema amí paputiropʉre. Wai capacarã ciento cincuenta y tres majuu cajãawã. To cõo majuu capãarã na cajãabato quena bapi cawooquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","To bairi: —Ʉgarã ajá, jã caĩwĩ Jesu. To cõopʉ, Jesuna ãmi, jã caĩ tʉjʉ maji peticoapʉ yua. Mere cʉ tʉjʉ maji peticõari, “¿Ñamʉ mʉ ãti?” cʉ jã caĩ jeniñaquẽpʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","To bairi Jesu pãre jã canuwĩ. Wai quenare jã canuwĩ. ");
INSERT INTO tav_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesu cʉ catunu catiricaro bero pʉgani jã tʉpʉ cabuia ejanʉcawĩ. Yucʉ mena buia ejaʉ itiani jã tʉpʉ cabuia ejanʉcawĩ yua. ");
INSERT INTO tav_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jã caʉgaro bero ocõo bairo Jonás macʉ Simón Pedrore cʉ cajeniñawĩ Jesu: —Simón, ¿atie mʉ cumua, wai wajarique, mʉ yere mʉ camairo netoro yʉre mʉ maiti? cʉ caĩ jeniñawĩ: —Ʉ̃ʉjʉ, Ʉpaʉ, mʉ maji mʉre yʉ camairijere, cʉ caĩwĩ Pedro. To bairo cʉ caĩro ocõo bairo cʉ caĩwĩ Jesu: —Baiyupa to roquere yʉre canʉcʉbʉgorãre caroaro na jʉgo ãña. Ovejare cacʉgoʉ waibʉcʉrã oveja cawimarãacãre cʉ cacoterore bairona na jʉgo ãña. ");
INSERT INTO tav_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Cabero Pedrore cʉ cajeniñanemowĩ Jesu tunu: —Simón, ¿yʉre mʉ maiti? —Ʉ̃ʉjʉ, mʉ yʉ mai. Mʉ maji mʉre yʉ camairijere, cʉ caĩwĩ Pedro. —To roquere yʉ yarãre caroaro na jʉgo ãña, cʉ caĩwĩ Jesu tunu. ");
INSERT INTO tav_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Cabero cʉ caĩnemowĩ tunu Jonás macʉ Simóre: —Simón, ¿yʉre mʉ maiti? Jesu itiani cʉ̃re cʉ cajeniñaro apii Pedro seeto tʉgooñarique pairi ocõo bairo cʉ caĩwĩ Jesure: —Yʉ Ʉpaʉ, nipetirije mʉ maji. Mʉ maji mʉre yʉ camairijere. To bairo cʉ caĩro: —To roquere yʉ yarãre caroaro na jʉgo ãña, cʉ caĩwĩ Jesu tunu. ");
INSERT INTO tav_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Cariapena mʉ yʉ ĩ. Cawamaʉ ãcʉpʉ mʉ cabooro jutiirore jaña, noo mʉ cáaágaro cáaáteñaʉ mʉ cãmʉ. Cabero cabʉcʉ mʉ cãnopʉ aperã maca mʉ wamorire mʉ ñu mʉgo rotigarãma. To bairo mʉre ñu mʉgo rotiri, mʉ jia turi, mʉ cáaágaqueti paʉpʉre mʉre ne aágarãma. ");
INSERT INTO tav_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu to bairo ĩi Pedro dope bairo cʉ cabai yajipere ĩi caĩwĩ. Cʉ cabai yajirije jʉgori camaja Diore nʉcʉbʉgogarãma ĩgʉ, to bairona caĩwĩ Jesu. To bairo ti wamere cʉ ĩri bero ocõo bairo cʉ caĩnemowĩ Jesu: —Yʉ cátinucurijere bairona áticõa aninucuña. ");
INSERT INTO tav_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Cabero Pedro tʉjʉ tunuobacʉ na bero yʉ caʉjaro catʉjʉwĩ. Yʉna yʉ cãmʉ Jesu cʉ camai netoʉna. Yʉna to jʉgoye jã caʉga tʉjari ñami, “¿Ni majuu mʉre catʉjʉ teerãre cʉ wadajãʉati?” yʉ caĩ jeniñawʉ. ");
INSERT INTO tav_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","To bairi Pedro yʉre tʉjʉʉ Jesure cʉ cajeniñawĩ: —Ʉpaʉ, ani maca ¿dope bairo cʉ baiati? ");
INSERT INTO tav_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","To bairo cʉ caĩro Jesu cʉ caĩwĩ Pedrore: —Nemoona cʉ cabai yajiata o cabero yʉ catunu atí paʉpʉre cʉ cacaticõamata mʉ camajipa wame me ã. Cʉ maca cʉ cabaipa wamere tʉgooñaquẽcʉna yʉ cátinucurijere bairona áticõa aninucuña mʉa. ");
INSERT INTO tav_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","To bairo Jesu cʉ caĩro apirã jĩcaarã jã mena macana, “Bai yajiquetigʉmi Juan,” yʉre caĩ tʉgooñabama. Jesu maca, “Bai yajiquetigʉmi,” yʉ caĩquẽmi. Ocõo bairo maca caĩwĩ: “Caberopʉ yʉ catunu atí paʉpʉna cʉ cacaticõa anipere yʉ cabooata quena ti wamere catʉgooñaquetipe ã mʉ macare, caĩwĩ Jesu Pedrore. ");
INSERT INTO tav_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yʉ Juan yʉ ã. Yʉ catʉjʉriquere yʉ uca. To bairi yʉ caucarique cariapena ã, ĩ majirique ã. ");
INSERT INTO tav_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Apeye capee ã Jesu cʉ cátaje. Yʉ catʉgooñaro cʉ cátaje cõo yʉ caucaata capee pũuri majuu ani neto majuucõaboro. To cõona ã.");
INSERT INTO tav_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, mʉ yʉ cauca joo jʉgoriquepʉ mere mʉ yʉ cauca buiowʉ Jesu nemoopʉ cʉ cátajere, camajare cʉ cabuiorique nipetirijere. ");
INSERT INTO tav_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ʉmʉrecoopʉ cʉ catunu aáparo jʉgoye cʉ buerã cãnanare, apóstol maja na caĩrã na cátipere na carotiyupʉ Jesu. Dio Catirique, Espíritu Santo na cʉ caĩ rotiro mena tiere na caĩ buioyupʉ Jesu apóstol majare. ");
INSERT INTO tav_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesure cʉ na cajĩaricaro bero bai yaji, cabero catí tunu yaparori tunu cuarenta cãnacã rʉmʉri cãñupʉ mai. To cõo cãnacã rʉmʉri aniri capee niri na tʉpʉ cabuia ejanucuñupʉ cʉ buerã cãnanare. “Mere catí tunucoajupi Jesu,” na caĩ majiparore bairo capee wame na catʉjʉrona cájupʉ. Na tʉpʉ buia eja, Ʉpaʉ Dio cʉ cãnipe quetire na caĩ buioyupʉ. ");
INSERT INTO tav_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","To bairi na mena ãcʉpʉ ocõo bairo na caĩñupʉ Jesu: —Jerusalẽpʉna tuacõaña mai aperopʉ aáquẽnana, na caĩñupʉ. —Jerusalẽpʉ mʉja cayuuro yʉ Pacʉ cajʉgoye cʉ caĩ buioricarore bairona mʉja joogʉmi cʉ Catirique, cʉ Espíritu Santore. Mere mʉjaare yʉ caĩ buiowʉ ti wamere. ");
INSERT INTO tav_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan oco mena cabautisanucuwĩ, “Dio yʉ catʉgooñarijere yʉ wajoami,” mʉja caĩro. Yucʉacãna Espíritu Santore mʉja joogʉmi Dio mʉja mena cãnipaʉre. To bairo mʉja mena cʉ cãno tʉjʉrã Diore mʉja caapiʉjarijere tʉjʉ majigarãma camaja, na caĩñupʉ Jesu yua. ");
INSERT INTO tav_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cabairo bero ʉ̃taʉpʉ Olivo na caĩricʉpʉ nare cʉ capi neori paʉ ocõo bairo cʉ caĩ jeniñañuparã Jesure: —Jã Ʉpaʉ, ¿yucʉacãna aperã Roma macana jã ya yepare carotirãre na mʉ reiati? ¿Jã majuuna Israel maja jã ya yepare jã ʉparã cʉnaati? Jesure cʉ caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","To bairo cʉ na caĩ jeniñaro: —Mani Pacʉ Dio jeto rotigʉmi ati yepa cabaipere. Noo cõopʉ cʉ carotipere majioquẽemi mʉjaare. To bairi ati wame catʉgooñaquetiparã mʉja ã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","—Ape rʉmʉbʉjaacã cáti majirã mʉja anigarã Dio cʉ Espíritu Santore mʉjaare cʉ cajooro. Cʉ Espíritu Santo majirique mʉjaare cʉ cajooro yʉ cabairijere mʉja camajiri wame cõo aperãre mʉja buiora aágarã. Jerusalén maca macanare, Judea yepa macanare, Samaria yepa macanare, ati yepa nipetiro macana quenare na mʉja buiora aágarã, na caĩñupʉ Jesu. ");
INSERT INTO tav_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","To bairo na ĩ yaparo cawamʉcoajupʉ na catʉjʉ mʉgorona. To cõona bujeri bʉrʉri cʉ cabuje biayupe. To bairi cʉ catʉjʉ nemoquẽjuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mai jõ buipʉ na catʉjʉ mʉgojorona Dio tʉ macana pʉgarã cabotirije cajañarã na tʉna cabuia ejanʉcañuparã. ");
INSERT INTO tav_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na tʉna buia ejanʉca, ocõo bairo na caĩñuparã: —Mʉjaa, Galilea macana, ¿nope ĩrã ʉmʉrecoore mʉja tʉjʉ mʉgo tʉjʉnucuti? Cʉ̃ Jesu mʉjaare cáaáweoecʉ, ʉmʉrecoopʉ cawamʉ aáecʉ to bairona tunu atígʉmi. Cʉ cáaátore mʉja catʉjʉetore bairona tunu atígʉmi. ");
INSERT INTO tav_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","To bairi Olivo na caĩricʉ ʉ̃taʉpʉ cãnana catunucoajuparã Jerusalén macápʉ. Yoaroacã mee, jĩca hora rʉgaro aátato ã Olivo na caĩricʉ mena Jerusalẽpʉ ejaricaro. ");
INSERT INTO tav_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalén macápʉ tunu aá, na cãni paʉpʉ cajãa ejayuparã, cabui macá arʉapʉre. Cãñuparã Pedro, Jacobo, Juan, André, Felipe, Tomás, Bartolomé, Mateo, Jacobo (Alfeo macʉ), Simón (cananista majocʉ), Juda (Jacobo yaʉ). To cãnacãʉna cãñuparã. ");
INSERT INTO tav_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Naa nipetirã jĩcarore bairo tʉgooñari Diore cajeni nʉcʉbʉgorã cãninucuñuparã. Na yarã romiri quena to bairona na mena neñapori Diore cajeni nʉcʉbʉgorã cãninucuñuparã, María Jesu paco mena, Jesu bairã jãa. ");
INSERT INTO tav_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jĩca rʉmʉ, noo cãnacã rʉmʉ beroacã meena na mena caneñapoyuparã aperã Jesucristore caapiʉjarã capãarã. Noo cõo ciento veinte cõo majuu ãnanama. ");
INSERT INTO tav_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","Na caneñapori paʉ Pedro wamʉnʉcari ocõo bairo na caĩñupʉ: —Yʉ yarã, tirʉmʉpʉ Judas cʉ cabaipere mani ñicʉ Ʉpaʉ David cãniñaricʉ caucayupi Dio Wadariquepʉre Dio Espíritu Santo cʉ cauca rotiro mena. David cʉ caĩ ucaricarore bairona cabaiwĩ Judas. Mani mena macacʉ cãnibami. Mani mena Dio yere cátinemoʉ cãnibami. To bairo cabaii anibacʉ quena Jesure cañeparãre na cajʉgo aámi, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jesure cañeparãre na cʉ cañe rotirique wapa niyerure cʉ cajooyuparã. Cabero tie rooro cʉ cátaje wapare na catunuocõañupʉ. Nare cʉ catunuo jooro bero jĩca yepa cawapayeyuparã tie mena. Judas cʉ majuuna bai yajigʉ cʉ wamʉ tuture jia, roca yo átiri cabai yajiyupʉ. Bai yaji, cʉ paro wati, cʉ ʉta miji wẽri buti, cabai yajiyupʉ yua. ");
INSERT INTO tav_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","To bairi Jerusalén macana nipetirã ati wame majiri, ti yepa Judas ye niyeru cãnibataje mena na cawapayerica yepare Aquédema cawameyeyuparã na ye mena, Rií Yepa ĩrica wame. ");
INSERT INTO tav_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","To bairo na ĩ, ocõo bairo na caĩnemoñupʉ Pedro: —Dio Wadarique Salmo cawamecʉti pũuripʉ ocõo bairo to caĩrore bairona cabaiyupi Judas: Cʉ ya paʉ ãnatore camaja na aniqueticõato. Cʉ cátibatajere apeĩ maca cʉ wajoaato, ĩ Dio Wadarique Judas cʉ cabaipere. ");
INSERT INTO tav_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’To bairi apeĩ maca Judas ãnacʉre cʉ cawajoape ã jã mena, “Jesu bai yajiri bero catunu catiyupi tunu,” tiere caĩ buio teñapaʉ. Jĩcaʉ mani Ʉpaʉ Jesu mani mena cʉ cãno catʉjʉricʉ, Jesucristo cʉ cabairique nipetiro mani mena catʉjʉricʉre cabejepe ã. ");
INSERT INTO tav_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan Jesure cʉ cabautisaro catʉjʉricʉre cabejepe ã. Apeye nipetiro Jesu cʉ cátajere, pʉ, cʉ Pacʉ Dio ʉmʉrecoopʉ cʉ̃re cʉ cane wamʉ aáto catʉjʉricʉre cabejepe ã mani mena Jesu ye quetire cabuio teñapaʉre, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","To bairo cʉ caĩro pʉgarãre cabejeyuparã. José Justo — Barsabá quena cawamecʉjupʉ. Apeĩ Matía, na pʉgarãre na cabejeyuparã. ");
INSERT INTO tav_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Na beje, ocõo bairo Diore caĩ jeni nʉcʉbʉgoyuparã: —Jã Ʉpaʉ, camaja nipetirã na yeripʉre mʉ tʉjʉ maji. Judas jã mena cãnibaepaʉ mʉ yere cáaáweowĩ, cʉ caboori wame macare átigʉ, caroorã na capopiye tamʉori paʉpʉ aácʉ. To bairi jã majioña. Ati maja pʉgarã ¿ni maca mʉ cabejei cʉ ãti Judare cawajoapaʉ, jã mena mʉ yere cabuio teñapaʉ? ");
INSERT INTO tav_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","To bairo Diore jeni nʉcʉbʉgo, ʉ̃ta rupaa pʉga ne, Matía, Barsabá na wamerire uca, tiare cañooñuparã. Na cañooriquere tunu tʉjʉquẽnana jĩca caneñuparã. Na catʉjʉro Matía cawame tujarica cãñupe. To bairi Matíare aperã Jesu ye quetire cabuio teñaparã once cãnacãʉ na mena cabuio teñapaʉre cʉ cacũñuparã Matíare yua. ");
INSERT INTO tav_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","To cõona Pentecosté na caĩri boje rʉmʉ caejayupe, Pascua caĩri boje rʉmʉ pʉgarã muipua bero macá boje rʉmʉ yua. Ti boje rʉmʉ cãno jĩca paʉ caneñapoyuparã Jesure caapiʉjarã nipetirã. ");
INSERT INTO tav_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na caneñapori paʉ majiña mano seeto cabʉjʉyupe ʉmʉrecoopʉre cáatíe. Ti wiipʉ na caneñapo ruiri wiipʉ wino seeto capapurije to cáató cabʉjʉrijere bairo seeto cabʉjʉyupe. ");
INSERT INTO tav_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","To bairo cabairi paʉna na tʉpʉ carupeayupe caʉ̃ bujurijere bairo cabaurije. Na cãno cãnacãʉpʉrena caʉ̃ buju tʉjʉnucuñupe na rʉpoari buiacã. ");
INSERT INTO tav_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","To bairona cabairi paʉ Dio Espíritu Santo na nipetirãpʉre caejayupʉ, na mena ani ejaʉ. Na mena cʉ caejarona cawada jʉgóyuparã aperã ye mena. Cajʉgoyepʉ camajiquetana anibana quena Espíritu Santo na cʉ cawada majioro apero macana yere capee wadariquere cawadayuparã. Jĩcaʉ ape oca cawadayupʉ. Apeĩ ricati wadarique cawadayupʉ, to cãnacãʉna ricati jeto Espíritu Santo na cʉ cawada majioro yua. ");
INSERT INTO tav_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti boje rʉmʉ cãno judío maja Jerusalén macápʉ boje rʉmʉ catʉjʉ teñarã ejaricarã cãñuparã. Diore canʉcʉbʉgorã cãñuparã. Judío maja anibana quena to cãnacãʉ ricati cawadarã cãñuparã, ape macaripʉ cãni batericarã aniri. ");
INSERT INTO tav_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","To bairi na camaja capãarã tie cabʉjʉrijere apirã, catʉjʉra ejayuparã. Tʉjʉra eja, to cãnacãʉna na ye ocare Jesure caapiʉjarã na cawadaro apirã: ");
INSERT INTO tav_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","—¡Abʉma! caĩñuparã. —¿Dope bairo na baiti? Ati maja to bairo cawadarã Galilea macana anibana quena ¿dope bairo to cãnacãʉna mani cabuiarica macari macanare bairo to cãnacãʉna mani cawadarijere na wada majiti? caĩ api acʉacoajuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","—Atopʉ mani mena catʉjʉ teñarã ãma Partia macana, Media macana, Erame macana, Mesopotamia macana ãma. Aperã Judea macana quena, Capadosia macana, Ponto macana, Asia macana quena ãma. ");
INSERT INTO tav_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Aperã Frijia macana, Panfilia macana, Ejipto macana, Libia na caĩri yepapʉ Sirene maca tʉ macana ãma. Aperã quena Roma maca macana mani mena catʉjʉ teñarã ãma judío maja. Aperã ãma Roma macana judío maja aniquetibana quena judío majare bairona Diore canʉcʉbʉgorã, na catʉgooñari wamere cawajoaricarã aniri. ");
INSERT INTO tav_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aperã Creta macana, Arabia macana quena ãma. To bairo to cãnacã maca macana anibana quena to cãnacãʉna ati maja, “Dio caroare mani átibojami,” na caĩro mani cawadarije mena na cawadaro mani api maji, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","To bairi seeto caacʉa tʉjʉ tʉgooñañuparã to bairo to cabairije tʉjʉri. —¿Dope bairo to baiti tie? caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aperã maca: —Ati maja caeti cumurã ãnama, na caĩ epeyuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","To bairo na caĩro Pedro apóstol maja mena wamʉnʉcari baujaro nipetirã na apiato ĩi, ocõo bairo camajare na caĩ buioyupʉ: —Mʉjaa, Jerusalén maca cãna, Judea yepa macana nipetirã, mʉjaare yʉ caĩ buiogari wame caroaro apiya mʉjaa. ");
INSERT INTO tav_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Ati maja caeti cumurã ãnama,” jãre mʉja ĩ. Jã mecʉqueti majuucõa. Ato capaʉ cabujuri paʉ beroacã las nueve cãno camaja eti cumuquetinucuma. ");
INSERT INTO tav_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ocõo bairo maca bai: Dio ye quetire buiori majocʉ Joe cãniñaricʉ cʉ caĩ ucarica wamere bairona bai, na caĩñupʉ Pedro. —Tirʉmʉpʉ ocõo bairi wame caĩ ucayupi Joe cãniñaricʉ Dio ye quetire buioʉ: ");
INSERT INTO tav_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ati yepapʉ cãni tʉjari rʉmʉri cãnopʉ yʉ Espíriture seeto tutuarique mena cʉ yʉ joogʉ camaja nipetirãre, mʉja ĩmi Dio. Na yʉ cajooro mʉja punaa yʉ ye quetire buiogarãma. Mʉja mena macana caʉmʉa cawamarã, cabʉcʉrã quena quẽgueriquere bairo tʉjʉgarãma na yʉ caiñoogarijere. ");
INSERT INTO tav_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti rʉmʉri cãnopʉ yʉ ye cánare yʉ Espíriture na yʉ joogʉ caʉmʉare, cãromia quenare. To bairo yʉ Espíritu Santore na yʉ cajooro yʉ ye quetire buiogarãma. ");
INSERT INTO tav_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ʉmʉrecoo ricati cabaurijere caacʉori wamere yʉ iñoogʉ. Ati yepa quena yʉ iñoogʉ camaja cajʉgoyepʉ na catʉjʉñaquẽtiere. Rií, pero, bujeri quena baugaro, mʉja ĩmi Dio, caĩ ucayupi Joe. ");
INSERT INTO tav_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Muipu caajii naitĩacoagʉmi. Ñami macacʉ maca riíre bairo jũagʉmi. To bairona baigaro Dio caroorãre na cʉ capopiyeyeparo jʉgoyeacã. Cãni majuuri rʉmʉ, cauwio bʉgari rʉmʉ anigaro mani Ʉpaʉ Dio to bairo cʉ cáto. ");
INSERT INTO tav_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","To bairo cabairi paʉ to cãnacãʉrena mani Ʉpaʉ Jeováre, “Dio, pairo caroorije yʉ átinucu, caroorije yʉ cátiere majirioya,” yʉ na caĩro na yʉ netoogʉ. To bairo caĩrã jetore na yʉ capopiyeyebopere na yʉ netoobojagʉ, mʉja ĩmi Dio, caĩ ucayupi Joe. ");
INSERT INTO tav_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’To bairi yʉ yarã Israel macana, yʉ apiya, na caĩnemoñupʉ Pedro. —Jesure Nasaré macacʉre cʉ cacũñupi Dio manire canetoopaʉre. “Cʉ cacũricʉ ãmi,” mani caĩ majiparore bairo caacʉori wame cʉ camajirije mena carupeori wame Jesure cʉ cáti rotiyupi Dio. Mani tʉpʉre cáti iñooñupi Jesu. To bairi wame mere mʉja majirã. ");
INSERT INTO tav_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","To bairo Jesu, Dio cʉ cacũricʉ cʉ cãnibato quena caroorãre cʉ̃re na mʉja capapua jĩa rotiyupa yucʉ tẽorica pãipʉ. Dio maca, “To bairona átigarãma,” cajʉgoyepʉna caĩ majiñupi. ");
INSERT INTO tav_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","To bairo Jesure cʉ mʉja cáto bero Dio cʉ cacatioyupi tunu, cabai yajiricʉ cʉ cãnibato quena. Jesu rupaʉ caboaquẽjupe, cabai yajirã mena tua majiquetiri. Catunu catiyupi. ");
INSERT INTO tav_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ʉpaʉ David tirʉmʉpʉ macacʉ Cristo cʉ cabuiaparo jʉgoyepʉna ocõo bairo caucayupi Cristo cʉ caĩpa wamere: Dio yʉ mena anicõa aninucumi to cãnacã rʉmʉ, yʉre átinemoʉ. To bairi yʉ uwiquẽe. Yʉ tʉgooñarique paiquẽe. ");
INSERT INTO tav_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","To bairi yeri wariñuʉ cañuuri wame Diore yʉ ĩnucu. ");
INSERT INTO tav_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Cabai yajiricarã ya paʉpʉ yʉ mʉ rocaquetigʉ. Mʉ yaʉ caroaʉ, mʉ cabejericʉ yʉ cãno maca yʉ rupaʉ ãnatore mʉ boa rotiquetigʉ. Bai yajibacʉ quena, yʉ tunu catigʉ. ");
INSERT INTO tav_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","To cãnacã rʉmʉ caroa ãnaje yʉre mʉ joogʉ. Yʉ mena mʉ ã. To bairi caroaro yʉ wariñuu, caĩ ucayupi David. ");
INSERT INTO tav_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Yʉ yarã, mani ñicʉ David cʉ cabairique mʉjaare yʉ ĩ buiopa, na caĩnemoñupʉ Pedro. —Cʉ cabai yajiropʉ cʉ cayaa rocayayuparã. Cʉ maja ope ati macapʉna ã. To bairi atie cʉ caucariquere cʉ majuu me ĩi caĩ ucayupi David. Apeĩ ye macare ĩi caĩñupi. ");
INSERT INTO tav_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David ãnacʉ catiipʉ Dio ye quetire cabuioʉ cãñupi. To bairi ati wame cʉ caĩ buioyupi Dio Davire: “Mʉ pãramerãpʉ jĩcaʉ ati yepapʉ Ʉpaʉ anigʉmi. Mʉ carotirore bairona cʉ quena rotigʉmi,” Davire cʉ caĩñupi Dio. ");
INSERT INTO tav_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","To bairo Dio cʉ caĩro Cristo cʉ cabaipere ocõo bairo caĩ buio majiñupi David: “Bai yajigʉmi Cristo. Bai yajibacʉ quena tunu catigʉmi. Cabai yajiricarã ya paʉpʉ tuaquetigʉmi Cristo. Cʉ rupaʉ boaquetigaro,” caĩ buio ucayupi David. Ati wame ucari beropʉ cabai yajiyupi David. Atopʉ mani ya macapʉ cʉ cayaa rocayayupa. Cʉ̃re na cayaa rocaricaro bero cʉ rupaʉ ãnato boaricaro yua. To bairi ati wame ĩ buio ucaʉ Jesu cʉ cabaipe macare ĩ buioʉ caĩñupi David, caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","—Cʉ̃ Jesurena cʉ catunu catioyupi Dio. Cʉ cabai yajiricaro bero jã nipetirã cʉ̃re jã catʉjʉwʉ catunu catiricʉpʉre. ");
INSERT INTO tav_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","To bairi Jesu cʉ catunu catiro bero Dio maca cʉ tʉpʉ cʉ cane aámi. To bairi Jesu cʉ Pacʉre cʉ carotibojaʉ aniri cʉ Espíritu Santore jã joomi yucʉacãna, cajʉgoyepʉna Dio, “Cʉ yʉ joogʉ,” cʉ caĩ buioricarore bairona. Jãre cʉ cajooro to cõona yucʉra tʉjʉ acʉori wame mʉja tʉjʉ, mʉja api yua. ");
INSERT INTO tav_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David macare cʉ rupaʉ ãnato boaricaro. To bairi Dio tʉpʉ tunu catí aá majiquetato cʉ rupaʉ. To bairi Jesu maca cʉ cabaipere caĩ ucayupi David ocõo bairi wame ucaʉ: Ato yʉ mena ruíya, caĩñupʉ Dio yʉ Ʉpaʉ Cristore. ");
INSERT INTO tav_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mʉ caruítoye mʉ wapanare mʉ paabojari majare bairo na yʉ cũgʉ, caĩ ucayupi David, caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’To bairo ĩ, ocõo bairo na caĩnemoñupʉ Pedro: —Yʉ yarã nipetirã Israel macana yʉ apiya. Aperãre na mʉja capapua jĩa rotiwʉ Jesure. Cʉ̃rena Caʉpaʉ majuu, manire cacatiopaʉre cʉ cacũñupi Dio maca cʉ cabejericʉ Jesure, caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","To bairo Pedro na cʉ caĩ buiorije apirã seeto majuu catʉgooñarique paiyuparã. Tʉgooñarique pairã, ocõo bairo caĩñuparã: —¡Ade, rooro majuu jã cáticõarajawʉ! Cʉ̃re jã cajĩa rotiqueticõape cãnibajupa, caĩ tʉgooñarique paiyuparã. —To bairi jã yarã, ¿dope bairo jã cátipe to ãti yua? Pedro jãare na caĩñuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","To bairo na caĩro: —Caroorije mʉja cátaje jʉtiritiri Jesucristore apiʉjaya mʉja nipetirã. Cʉ apiʉjari, “Jesucristo, caroorije yʉ cátajere yʉ majirioya,” cʉ ĩña. To bairo cʉ ĩri bautisa rotiya. To bairo mʉja cáto Espíritu Santore mʉja joogʉmi Dio, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","—Mani Ʉpaʉ Dio, “Yʉ Espíritu Santore yʉ joogʉ,” tirʉmʉpʉ cʉ caĩ buioricarore bairona cʉ joogʉmi mʉjaare, mʉja bero macanare, aperoripʉ cãni baterã quenare. Nipetirã noa cʉ cabejerãre Espíritu Santore cʉ joogʉmi Dio, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Capee wame na caĩ buionemoñupʉ Pedro: —Ati yepa macana rooro na cátaje wapa na popiyeyegʉmi Dio. To bairi caroorije mʉja cátaje wapa mʉjaare cʉ capopiyeyebopere netogarã Diore, “Caroorije yʉ cátajere yʉ majirioya,” cʉ ĩ jeniya. To bairo mʉja cáto mʉja popiyeyequetigʉmi Dio, na caĩñupʉ Pedro yua. ");
INSERT INTO tav_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","To bairo Pedro cʉ caĩrijere caroaro caapiʉjayuparã capãarã majuu. Apiʉjari cabautisa rotiyuparã. To bairi ti rʉmʉna Jesucristo cʉ buerã cãnana mena macana itia mil majuu cãnacãʉ cãninemoñuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","To bairo apiʉja, Jesu cʉ buerã cãnana apóstol maja na caĩrã na mena caneñaponucuñuparã. Na mena neñaponucuri, na cabuiorijere caroaro api, na mena caroaro jʉgo ʉga, wadapeni, Diore jeni nʉcʉbʉgo, cátinucuñuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesu cʉ buerã cãnana apóstol maja na caĩrã caacʉori wame cáti iñoori wame capee cájuparã Dio Espíritu Santo na cʉ camajiorije mena. To bairo na cáto tʉjʉrã camaja nipetirã catʉjʉ acʉa tʉgooña nʉcʉbʉgoyuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","To bairi Jesucristo ye quetire caapiʉjarã nipetirã caroaro caame bapa cʉjuparã. Caroaro ame bapacʉti, na cacʉgorije mena caame átinemonucuñuparã. Pairo cacʉgorã na yere nuni wapa jeeri cacʉgoquẽnare na caricawonucuñuparã. To bairi na nipetirã jĩcarore bairo cacʉgoyuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","To cãnacã rʉmʉ Dio wiipʉ caneñaponucuñuparã. Na ya wiiripʉ quena ame tʉjʉri caroaro wariñuurique mena caame jʉgo ʉganucuñuparã. ");
INSERT INTO tav_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","To bairo átiri, “Caroaro majuu mani áami Dio,” caĩnucuñuparã. To bairo caroaro na caame áto tʉjʉrã aperã nipetirã, “Cañuurã jeto ãma Jesucristore caapiʉjarã,” caĩ tʉgooñañuparã. To bairi to cãnacã rʉmʉ aperã Jesucristo ye quetire caapiʉjarã cãninemoñuparã. To bairo na caapiʉjaro Dio cʉ yarã cãniparãre na cacũñupʉ nare cʉ capopiyeyeboriquere na netoori yua. ");
INSERT INTO tav_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cabero jĩca rʉmʉ tunu Pedro, Juan mena yucʉ bui muipu cʉ catʉja rui áto a las tres cãno Dio wiipʉ cáaájuparã. To capaʉ cãno camaja Dio wiipʉ cáaánucuñuparã, Diore jeni nʉcʉbʉgorã aána. ");
INSERT INTO tav_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","To bairi Dio wiipʉ Pedro, Juan mena na cáaáparo jʉgoyeacã camajocʉre cáaá majiquẽcʉre cʉ cane aájuparã aperã. To cãnacã rʉmʉ to bairona Dio wiipʉ jope tʉpʉ cʉ cacũnucuñuparã, Caroa Jope cawamecʉti jope Dio wiipʉ, cajãa ejarãre niyeru cʉ jeni ruiato ĩrã. Nemoopʉ to bairona cabuiaricʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","To bairi Pedro, Juan Dio wiipʉ jãagarã na caejaro tʉjʉ: —Niyeru yʉ jooya, caĩbajupʉ. ");
INSERT INTO tav_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","To bairo cʉ caĩro Pedro, Juan cʉ tʉbea tʉjʉ: —Jã tʉjʉya, cʉ caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","To bairo Pedro cʉ caĩro, cáaá majiquẽcʉ maca na tʉjʉ, “Apeye unieacã yʉ joogarãma,” caĩ tʉgooñabajupʉ. ");
INSERT INTO tav_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","To bairo na cʉ catʉjʉro ocõo bairo cʉ caĩñupʉ Pedro: —Niyeru yʉ cʉgoquẽe. Apeye caroare yʉ cacʉgori wame macare mʉ yʉ átinemogʉ. To bairi Jesucristo Nasaré macacʉ mʉre cʉ canetoo majiro mena wamʉnʉcari aácʉja, cʉ caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","To bairo cʉ ĩi, cʉ wamore ñe, cariape nʉgoa maca cʉ catʉ̃ga wamʉo nʉcoñupʉ. To bairo Pedro cʉ catʉ̃ga wamʉo nʉcorona nemoo cʉ rʉpori ocabʉtirique cʉ cájupe. ");
INSERT INTO tav_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rʉpori ocabʉtiri cariapena wamʉnʉca, cáaá jʉgóyupʉ. Aá jʉgó, Pedro, Juan mena Dio wiipʉ na mena cajãa aájupʉ. Na mena jãa aá, bapa mʉgo, bapa mʉgo, cáaájupʉ. To bairo bapa mʉgo aá, “Dio yʉ átinemomi cañuu netori wame,” caĩ wariñuuñupʉ. ");
INSERT INTO tav_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","To bairo Diore ĩ wariñuuri cʉ cabapa mʉgo aáto aperã maca cʉ tʉjʉrã: ");
INSERT INTO tav_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","—Ani cáaá majiquetibatacʉna Caroa Jope cawamecʉti jope Dio wii jãarica jope tʉpʉ niyerure cajeni ruibatacʉna ãcʉmi, caame ĩñuparã. To bairo cʉ ãnacʉre tʉjʉ majiri cʉ catʉjʉ acʉacoajuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","To bairi Pedrore, Juãre na pitigaquetiri na tʉna catuayupʉ. To bairo na cʉ cabairo camaja nipetirã catʉjʉ acʉarã na tʉpʉ catʉjʉra atʉ aájuparã. Portal de Salomón na caĩri arʉa majuu, jope tʉ cabiaya mani arʉapʉ, Pedro, Juan na cãnopʉ catʉjʉra atʉ aájuparã. ");
INSERT INTO tav_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","To bairo na tʉpʉ na catʉjʉra atʉ ató tʉjʉri ocõo bairo na caĩñupʉ Pedro: —Yʉ yarã Israel macana, ¿nope ĩrã ani cʉ canetorije tʉjʉri mʉja tʉjʉ acʉati? ¿Nope ĩrã, “Ati maja na majuuna na camajirije mena, Dio mena cañuurã aniri cáaá majiquetibatacʉre cʉ netoo majirãma,” jãre mʉja ĩ tʉgooñati mʉjaa? ");
INSERT INTO tav_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","Jesu maca cʉ camajirije mena cʉ netoowĩ. Mani ñicʉ jãa, Abraham, Isaá, Jacobo, aperã nipetirã cãni jʉgoricarã Diore cáti nʉcʉbʉgorã cãniñañuparã. To bairi Dio na cáti nʉcʉbʉgoricʉ cʉ Macʉre cãni majuʉre cʉ cacũñupi Dio Jesure, aperãre mʉja cajĩa rotiepaʉ maca. “Cʉ̃re jã booquẽe,” mʉja caĩwʉ, Pilato, gobierno macacʉ maca, “Cʉ yʉ buugʉ, cʉ̃re cajĩaquetipe ã,” cʉ caĩrije to cãnibato quenare. “Cʉ̃re jã booqueti majuucõa,” mʉja caĩwʉ, Dio yere cácʉ, cañuu majuʉ cʉ cãnibato quena. “Jesure jã booqueti majuucõa,” ĩri, “Camajare cajĩaricʉ presopʉ cãcʉ macare cʉ buuya,” mʉja caĩwʉ Pilatore. ");
INSERT INTO tav_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","To bairo ĩ, camajare catirique cajoʉre aperãre na mʉja cajĩa rotiwʉ Jesure. Cʉ̃re na mʉja cajĩa rotiro bero Dio maca cʉ catunu catioyupi. Jã majuuna Jesure cʉ jã catʉjʉwʉ catunu catiricʉpʉre, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","—To bairi ani cáaá majiquetibatacʉre mʉja camajiire Jesu maca cʉ camajirije mena cʉ netoomi. Jesure jã caapiʉjaro ĩi anire cʉ netoomi Jesu mʉja catʉjʉrona. ");
INSERT INTO tav_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yʉ yarã, mʉjaa, “Dio Macʉna ãmi Jesu,” caĩ tʉgooña majiquẽna aniri aperãre na mʉja cajĩa rotiwʉ Jesure. Mʉja ʉparã quena to bairona cajĩa rotiwã. ");
INSERT INTO tav_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tirʉmʉpʉ to bairona, “Popiye tamʉogʉmi Cristo,” Dio ye quetire caĩ buio jʉgoyeyeyupa Dio ye quetire buiori maja cãniñaricarã. To bairi cajʉgoyepʉna Dio na cʉ caĩricarore bairona baiwʉ Cristore na mʉja cajĩa rotirique yua. ");
INSERT INTO tav_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","To bairi caroorije mʉja cátiere jʉtiriticõari, “Mani catʉgooñarijere jã wajoagarã,” ĩri Cristore apiʉjaya mʉjaa. To bairo mʉja cáto caroorije mʉja cátaje majiriogʉmi mani Ʉpaʉ Dio. Caroa ani tʉgooña yerijã wariñuuriquere mʉja joogʉmi. ");
INSERT INTO tav_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Cʉ cabejericʉ Cristore mʉja tʉpʉ joogʉmi. ");
INSERT INTO tav_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tirʉmʉpʉ Dio ye quetire buiori maja cãniñaricarã, “Cristo ʉmʉrecoopʉ Dio tʉpʉ tuagʉmi mai,” caĩ buioyupa. “Cabero Dio ati ʉmʉrecoo wajoagʉmi. Nemoopʉ cʉ cátatore bairona átigʉmi tunu. Camaja Diore cʉ na cabai netooparo jʉgoye cabairicarore bairona átigʉmi Dio. Ti paʉ majuu Cristore mani Ʉpaʉre joogʉmi Dio ati yepapʉre,” caĩ ucayupa Dio ye quetire buiori maja cãniñaricarã. ");
INSERT INTO tav_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisé tirʉmʉ macacʉ ati wame buioʉ, “Mani Ʉpaʉ Dio jĩcaʉ cʉ ye quetire cabuiopaʉre mʉja joogʉmi. Yʉre cʉ cajooeparore bairona cʉ joogʉmi. Jĩcaʉ mani yaʉ anigʉmi cʉ quena. Caroaro cʉ̃re caapiʉjaparã mʉja ã. ");
INSERT INTO tav_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","To bairi noo cãnacãʉ majuu cʉ̃re caapiʉjaquẽna anigarãma ta. Na una Dio yarã mena macana aniquetigarãma. Na regʉmi Dio,” caĩ buioyupi Moisé. ");
INSERT INTO tav_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Nemoopʉre Dio ye quetire buiori majocʉ tirʉmʉpʉ macacʉ Samuel cawamecʉcʉ ati rʉmʉri yucʉacã cabaipere caĩ uca jʉgoyeyeyupi. Cʉ bero macana nipetirã na quena Dio ye quetire buiori maja caĩ queti buio jʉgoyeyeyupa Jesucristo cʉ cabaipere. ");
INSERT INTO tav_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yucʉ ati rʉmʉ macanare mʉjaare caĩñupi Dio cañuuri wame ĩ buio jʉgoyeyei. Ocõo bairo mani ñicʉpʉre Abrahãre cʉ caĩñupi Dio: “Mʉ pãramerãpʉre jĩcaʉ mʉ pãrami anigʉmi. Cʉ̃ cʉ caejaro camaja nipetirã seeto wariñuurique bʉgagarãma,” caĩñupi Dio Abrahãre. To bairo cʉ ĩ, yucʉ rʉmʉ manipʉre cabaipere cʉ caĩñupi Dio Abrahãre. ");
INSERT INTO tav_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","To bairi manire Israel macanare aperã jʉgoye cʉ cabejericʉ Jesu ye quetire mani joomi Dio. Mani joomi tie quetire, caroorije mani cátiere mani cajana majiparore bairo ĩi. Mani cajanaro wariñuuriquere mani joomi Dio yua, caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","To bairo Pedro, Juan camajare na caĩ wadari paʉ majuu caejayuparã na tʉpʉ sacerdote maja, apeĩ Dio wii coteri maja ʉpaʉ, aperã saduceo maja. ");
INSERT INTO tav_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Na maca Pedro, Juan mena camajare na na cabuiorijere booquetiri capunijiniñuparã. Ocõo bairo Pedro, Juan mena camajare cabuioyuparã: “Bai yajiri bero catunu catiyupi Jesu. To bairi mani maji. Mani cabai yajiro beropʉ tunu catirique ã mani camaja quenare,” caĩ buioyuparã Pedro, Juan mena. ");
INSERT INTO tav_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","To bairi ti wamere camajare na cabuioro booquetiri na cañeñuparã. Na ñe, mere canaiori paʉ cãno presopʉ na cacũñuparã, “Bujiyʉpʉ na mani jeniñagarã,” ĩrã. ");
INSERT INTO tav_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aperã maca capãarã majuu Jesu ye quetire Pedro, Juan na cabuioro caapiʉjayuparã. To bairi caapiʉjarã caʉmʉa jetore nare na cacõoñaata jĩca wamo cãnacã mil majuu cãñuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","To bairi ape rʉmʉ cãno ti macapʉ Jerusalẽpʉ caneñapoyuparã caʉparã, cabʉcʉrã, judío majare cabuerã nipetiro yua. ");
INSERT INTO tav_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na mena cãñupʉ sacerdote maja ʉpaʉ quena, Aná cawamecʉcʉ. Aperã quena Caifá, Juan, Alejandro, aperã nipetirã sacerdote maja ʉparã yarã quena na mena caneñapoyuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Neñapori Pedrore, Juãre na recomacapʉ tʉjʉnucu roti, ocõo bairo na caĩ jeniñañuparã: —¿Dope bairo anire cáaá majiquetibaecʉre cʉ mʉja netoo majiri? ¿Ñamʉ maca to bairo mʉjaare cʉ áti rotiri? na caĩ jeniñañuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","To bairo na caĩ jeniñaro Pedro Espíritu Santo cʉ catutuarije mena yeri ocabʉtiri ocõo bairo camaja ʉparãre cabʉcʉrãre na caĩ buioyupʉ: ");
INSERT INTO tav_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Cáaá majiquetibaecʉre caroa wame cʉ̃re to cabairo jã cátiere tʉjʉrã jãre mʉja ñewʉ, ¿dope bairo bairi cʉ netoti? ĩrã. ");
INSERT INTO tav_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","To bairo jã mʉja cajeniñaro mʉja nipetirãre Israel macanare mʉjaare yʉ buiopa. Ani cáaá majiquetibaecʉre Jesucristo Nasaré macacʉ cʉ camajirije mena anire cʉ catioyawĩ. Jesure na mʉja capapua jĩa rotirique to cãnibato quenare Dio maca cʉ catunu catioyupi. ");
INSERT INTO tav_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tirʉmʉpʉ Dio ye quetire buiori majocʉ to bairo Jesure cʉ mʉja cabooquetipere caĩ buio jʉgoyeyeyupi atiere caĩ ucaricʉ: Mʉjaa ʉ̃ta wii quenoorã jĩca ʉ̃taa, “Atia ñuuquẽe. Tiare jã booquẽe,” mʉja caĩwʉ. To bairo mʉja caĩrije to cãnibato quena aperã maca tia mʉja carocaricarena cacũ jʉ́goyupa apeye ʉ̃ta rupaa cũgarã jʉgoye. “Atia ʉ̃taa ñuu majuucõa,” caĩwã aperã, mʉja cabooquetacarena. To bairi ʉ̃taa wii quenoori maja na cabooquetatore bairona Cristore mʉja booquetigarã. Aperã maca tiare cañuurica na cacũ jʉgoricarore bairona Dio cacũñupi Cristore Caʉpaʉ majuu, caĩ buio jʉgoyeyeyupi Dio ye quetire buiori majocʉ cãniñaricʉ maca. ");
INSERT INTO tav_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","To bairi Jesucristo jeto ãmi camajare cacatio majii. Nii majuu manire cacatioʉ apeĩ jooquẽemi Dio ati yepapʉre, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","To bairo Pedro, Juan mena yeri ocabʉtiri na caĩ buioro, caapi acʉacoajuparã caʉparã caneñaporã maca. —¡Ago name! Judío maja mani caneñapo buerica wiipʉ cabuericarã aniquetibana quena caroaro buio majima. To bairi Jesu mena cãnieparã ãnama, caame ĩñuparã sacerdote maja ʉparã jãa. ");
INSERT INTO tav_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","To bairi cáaá majiquetibatacʉ mere cañuʉpʉ na mena cʉ catʉjʉnucuro maca, “Jocarã mʉja ĩ,” na caĩ majiquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","To bairi Pedrore, Juãre na cabuti rotiyuparã mai na caneñapo ame jeniñari arʉapʉ, na jeto ame wadapenigarã. Na buti roti, ocõo bairo caame ĩ wadapeniñuparã: ");
INSERT INTO tav_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Dope bairo Pedrore, Juãre na mani ánaati? “Ati wame caacʉori wame átiyayupa naa,” ĩ majima Jerusalén macana nipetirã. Mani maca, “Jocarã mʉja ĩ, baiquẽjupa,” na mani ĩ majiquẽe. ");
INSERT INTO tav_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","To bairi, “Jesu cʉ cabairique to cõona camajare na buio janacõaña,” na mani ĩ tutigarã, aperã capãarã atie quetire caapiʉjarã aninemorema ĩrã, caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","To bairo ame ĩ yaparo na capijoyuparã Pedrore, Juãre. Na pijo, ocõo bairo na caĩbajuparã: —Jesu cʉ cabairiquere to cõona camajare na buio janacõaña mʉjaa. ");
INSERT INTO tav_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","To bairo na caĩro: —Jãre mʉja cabuio jana rotirijere mʉjaare jã caapiʉjaata Dio macare jã bai netooborã. To bairi tʉgooñaña mʉjaa. Dio maca jã tʉjʉʉ, ¿dije jã cátipe cʉ boocʉti? ¿Cʉ ye jã cátipere cʉ boocʉti? o ¿mʉja ye macare jã cátipere cʉ boocʉti Dio? Booquẽcʉmi. ");
INSERT INTO tav_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","To bairi Jesu cʉ caĩepere, cʉ cátiepere jã catʉjʉepere jã buio jana majiquẽe, na caĩñuparã Pedro jãa. ");
INSERT INTO tav_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","To bairo na caĩro: —Jesu cʉ cabairique camajare mʉja cabuio janaquẽpata mʉjaare jã popiyeyegarã, na caĩ tutinemoñuparã. Aperã maca, “Dio caroaro áami,” caĩñuparã cáaá majiquetibatacʉ cʉ canetorije tʉjʉri. To bairi to caneñaporã maca Pedro jãare, “Ñee caroorije wapa nare capopiyeyepe ã,” caĩ majiquẽjuparã. To bairi presopʉ cãnanare na cabuuyuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Cáaá majiquetibatacʉ Dio cʉ canetooricʉ cuarenta cãnacã cʉma netobʉjaroacã cacʉgoʉ cãñupʉ cʉ̃a. ");
INSERT INTO tav_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","To bairi Pedro, Juan mena buti, catunucoajuparã na mena macana Jesure caapiʉjarã tʉpʉ. Na tʉpʉ aá, nipetiro sacerdote maja ʉparã, cabʉcʉrã nare na caĩ buioriquere na caĩ buioyuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","To bairo na caĩ buiorijere apirã Jesure caapiʉjarã nipetirã jĩcarore bairona tʉgooñari Diore jeniri ocõo bairo caĩñuparã: —Jã Ʉpaʉ Dio, ʉmʉrecoo, ati yepa nipetiro cátacʉ mʉ ã. ");
INSERT INTO tav_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tirʉmʉpʉ jã ñicʉ David ãnacʉ mʉre cáti nʉcʉbʉgoricʉ mʉ Espíritu Santo mena cʉ mʉ cauca rotiro ocõo bairo caĩ buio ucayupi mʉ Macʉ Jesure rooro na cátipere: ¿Nope ĩrã judío maja cãniquẽna na cáti majiqueti wame jocarã, “Jã átigarã,” na ĩbajupari? ¿Nope ĩrã aperã quena Diore na ĩ punijiniti? ");
INSERT INTO tav_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Neñapori, “Manire cʉ carotipe mani booquẽe. Cʉ mani rocagarã,” caĩbajupa maca ʉparã. “Dio cʉ cacũricʉ Cristo quenare mani booquẽe,” caĩbajupa, caĩ ucayupi David ãnacʉ. ");
INSERT INTO tav_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Cʉ caĩ ucarica wamere bairona áama yucʉra, Diore caĩ nʉcʉbʉgoyuparã. —Ati macapʉ to bairona caneñapowã, cañuʉre mʉ Macʉ Jesure mʉ cajooricʉre rocagarã. Ʉpaʉ Herode, Ʉpaʉ Ponsio Pilato quena, Israel macana mena, aperã mena caneñapowã, Jesure booquẽna cʉ na carocapere wadapenirã. ");
INSERT INTO tav_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mere cajʉgoyepʉna, “To bairona rooro átigarãma,” mʉ caĩñupa, camajii aniri, Diore caĩ wada nʉcʉbʉgoyuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","—To bairi yucʉacã, “Janacõaña,” jãre na caĩ tutiejere mʉ apii. To bairi jãre átinemoña. Yeri tʉgooña ocabʉtiriquere jã jooya, na uwiquẽnana mʉ ye quetire jã cabuio majiparore bairo ĩi. Mʉ caboori wame jã átigarã, mʉ ye quetire buiorã. ");
INSERT INTO tav_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","To bairo jãre átinemori, camajare mʉ catutuarijere na iñooña. Cariarãre na netooña. Ape wame quena, caacʉori wame, áti iñoorica wamere ája, caroaʉ mʉ Macʉ Jesu cʉ catutuarije mena, Diore caĩ wadayuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","To bairo Diore na caĩ jeni nʉcʉbʉgo yaparoro na caneñapori wii cananaañupe. To bairo to cananaari paʉna Espíritu Santo seeto majuu ti wiipʉ cãna napʉ cãninemo ejayupʉ. To bairi Espíritu Santo seeto majuu napʉ cʉ cãninemo ejaro uwi tʉgooñarique manona Dio ye quetire aperãre cabuio ocabʉtiyuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","35","To bairi uwiquẽnana, “Jã Ʉpaʉ Jesu cʉ̃re na cajĩaricaro bero catunu catiyupi,” caĩ buio ocabʉtiyuparã. Apóstol majare Espíritu Santo majirique, wariñuurique quenare na cajooyupʉ. To bairo na cʉ cajooro nipetirã Cristore caapiʉjari poa macana jĩcarore bairona catʉgooñarique cʉjuparã. Jĩcaʉ ũcʉ na yaʉ, “Yʉ yere yʉ maibʉja,” caĩ ajuyaʉ camañupʉ. To cãnacãʉna na yere caame ricawoyuparã na yarã cacʉgoquẽnare. Wiiri cacʉgorã, yepari quenare cacʉgorã cãna quena aperãre canuniñuparã, niyerure jeegarã. Niyerure jee, apóstol maja Jesu buerã cãnanare na cajooyuparã, “Mani mena macana cacʉgoquẽnare na ricawoya,” ĩrã. To bairo na cáto na mena macana ñee camacaquẽjuparã. ");
INSERT INTO tav_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jĩcaʉ to bairo cácʉ cãñupʉ José cawamecʉcʉ. Levita poa macacʉ cãñupʉ. Chipre na caĩri paʉ cabuiaricʉ cãñupʉ. Apóstol maja “Bernabé” cʉ caĩñuparã. Na ye mena “aperãre tʉgooña ocabʉtiriquere cajoʉ” ĩrica wame ã. ");
INSERT INTO tav_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Cʉ̃a José jĩca yepa oterica yepa aperãre nuni, niyeru cajeeyupʉ. Niyeru jee átiri, apóstol majare na cajooyupʉ, mani mena macana cacʉgoquẽnare na mʉja ricawowa ĩi. ");
INSERT INTO tav_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Apeĩ cãñupʉ Ananía cawamecʉcʉ. “Nipetiro yʉ niyeru yʉ joo peocõa,” caĩtoʉ maca cãñupʉ. Cʉ̃a, cʉ nʉmo Safira mena jĩca yepa canuniñuparã aperãre, niyeru jeegarã. ");
INSERT INTO tav_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ti yepare nuni, niyerure jee, apeye na majuuna caquenoo cũcõañuparã, “Mani majuuna tiere mani cʉgogarã,” yajioro ame ĩri. To bairi Ananía ti yepa aperãre cʉ canunirique wapa niyeru apeye cʉ majuuna quenoo cũ, apeye Jesu buerã cãnana apóstol majare na canuniñupʉ ocõo bairo na ĩtori: —Atie yʉ ya yepa yʉ canunirique wapa yʉ niyeru nipetirona ã, na caĩtoyupʉ. —Mani mena macana cacʉgoquẽnare tiere na ricawo jooya, na caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","To bairo cʉ caĩro: —Ananía, ¿nope ĩi Sataná mʉre cʉ cawadajãrijere mʉ apiʉjari? Dio Espíritu Santopʉre jocʉna cʉ mʉ ĩtowʉ, “Yʉ ya yepa yʉ canunie yepa wapa niyeru nipetirona yʉ joo,” ĩtoʉ, cʉ caĩñupʉ Pedro. —Mʉ niyerure apeye mʉ cũcõaricʉ, mʉ majuuna yajioropʉ cʉgogʉ. ");
INSERT INTO tav_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ti yepa aperãre mʉ canuniparo jʉgoye mʉ ye jeto cãñupa. To bairi na mʉ canuniro bero mʉre na cawapayerique niyeru mʉ ye riape noo mʉ cabooro cátipe anibajupa. ¿Nope ĩi mʉ yeripʉ, “ ‘Atie yʉ niyeru nipetirona mʉjaare yʉ joo,’ na yʉ ĩtogʉ,” mʉ ĩ tʉgooñari? cʉ caĩñupʉ Pedro. —Jã jetore ĩtoʉ mee mʉ ĩ. “Atie to cõona yʉre na cawapayerique ã,” ĩtoʉ Diopʉre cʉ ĩtoʉ mʉ ĩ, cʉ caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","To bairo cʉ caĩro apii Ananía nemoopʉre ria ña, cabai yajicoajupʉ. To bairo cʉ cabai yajirijere apirã camaja nipetirã cauwiyuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","To bairi caʉmʉa cawamarã atí, cʉ ãnacʉre jutii ajero mena cʉ umá, cʉ ne buti aá, cʉ cayaa rocayuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Itia hora bero cajãa ejayupo cʉ ãnacʉ nʉmo Safira. Co manapʉ cʉ cabai yajiriquere camajiquẽjupo co maca. ");
INSERT INTO tav_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Co cajãa ejaro tʉjʉʉ: —¿Ato cõo majuu mʉja ya yepa wapa niyeru mʉjaare na nuniri? co caĩ jeniñañupʉ Pedro. —Ʉ̃ʉjʉ, to cõo majuu jã nuniwã, co manapʉ cʉ caĩtoricarore bairona cʉ caĩñupo Pedrore. ");
INSERT INTO tav_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","To bairo cʉ co caĩtorijere apii: —¿Nope ĩrã mʉja majuuna apeye cũcõabana quena, “ ‘Atie jã ya yepa jãre na cawapayerique nipetirona ã,’ jocarãna mani ĩtogarã,” mʉja ame ĩri? “Dio Espíritu Santo mani popiyeyequẽcʉmi,” ¿mʉja ĩ tʉgooñabati? Espíritu Santore mʉ manapʉ cʉ caĩtoeje wapa cʉ cabai yajiro cʉ cayaa rocaena mere tunu ejama. To bairi mʉ cabai yajiro mʉ ne buti aátina, mʉ yaa rocacõagarãma mʉ quenare, co caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","To bairo cʉ caĩrona to catʉjʉnucubatacona ria ña, cabai yajicoajupo yua. Caʉmʉa cawamarã jãa eja, cabai yajiore co catʉjʉyuparã. Cabai yajiore co tʉjʉ, co ne buti aá, co manapʉ ãnacʉ tʉna co cayaa rocayuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","To bairi Jesucristore caapiʉjarã aperã quena nipetirã to bairo na cabai yajirijere apiri seeto cauwiyuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Jesure caapiʉjarã caneñaponucuñuparã Portal de Salomón na caĩri paʉ Dio wii jope tʉpʉ cãni arʉapʉ, cabiaya mani arʉa. Jesure caapiʉjaquẽna maca na mena cabapacʉti uwibʉjayuparã. Bapacʉti uwibana quena caroaro na catʉgooña nʉcʉbʉgoyuparã Jesure caapiʉjarãre. To bairi aperã capãarã caʉmʉa, cãromia quena mani Ʉpaʉ Jesucristore caapiʉjanemoñuparã. To bairi to cãnacã rʉmʉ na mena macana cãninemoñuparã. Apóstol maja caacʉori wame cáti iñoorijere capee cájuparã camaja na catʉjʉrona. ");
INSERT INTO tav_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","To bairo na cátiere tʉjʉrã cariarãre na yarã na cajee ejooyuparã na cayojarijepʉna. “Pedro cʉ caneto aáparo tʉacã na cãmata na tʉacã cʉ caneto aátona ñuugarãma, nare cʉ cañiga peoquetibato quena,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Apero macana quena Jerusalén maca tʉacã macá macari macana Jerusalẽpʉ atí, na yarã cariarãre na cajee ejooyuparã. Rooro cawãtiacʉna quenare na cajee ejooyuparã. To bairo na cáto na nipetirã cañuuñuparã yua. ");
INSERT INTO tav_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","To bairi sacerdote maja ʉpaʉ, cʉ mena macana saduceo maja mena Jesu buerã cãnana apóstol majare na capunijiniñuparã. Camaja, “Cañuurã ãma naa,” nare na caĩrije cabooquetibajuparã, na tʉjʉ ʉgoobana. ");
INSERT INTO tav_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","To bairi polisía majare na ñe roti, na capreso cũ rotibajuparã sacerdote maja ʉpaʉ jãa, cʉ mena macana mena. ");
INSERT INTO tav_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","To bairo na cátibato quena preso cãna tʉpʉ caejayupʉ Dio tʉ macacʉ ti ñamina. Ti ñamina eja, preso jope turiquere pã, apóstol majare na cajʉgo butiyupʉ. ");
INSERT INTO tav_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Na jʉgo buti, ocõo bairo na caĩñupʉ: —Dio wiipʉ aánaja. Camajare to cãnare Jesucristo ye quetire nipetiro na buioya. “Noa Jesure caapiʉjagarãre caroaro catiriquere mʉja joogʉmi,” na ĩ buioya to cãnare, na caĩñupʉ Dio tʉ macacʉ. ");
INSERT INTO tav_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","To bairo na cʉ caĩro apii presopʉ cãnana buti, cabujuri paʉ cãnopʉ Dio wiipʉ cáaácoajuparã. Dio wiipʉ aá, Jesucristo ye quetire to cãnare na cabuio jʉgóyuparã yua. To bairo na cabairi paʉ sacerdote maja ʉpaʉ, cʉ mena macana mena, Israel maja cabʉcʉrã mena caneñapoyuparã. Neñapo, polisíare presopʉ na cabipe cũbatanare apóstol majare na cajee atí rotiyuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","To bairi polisía cáaájuparã presopʉ. Aá, preso wiipʉ jãa, ti arʉare pã, na cabipe cũbatanare cabʉgaquẽjuparã. To bairi na camano tʉjʉrã caneñaporã tʉpʉ catunucoajuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tunu eja: —Nare jã macabapʉ. Preso wii caroaro bipericaro, na capreso bipe cũricarãre catʉjʉ coterã to catʉjʉnucu coterãre na jã tʉjʉwʉ. Na tʉjʉ, pã, jãa átiri, na jã macabapʉ. To bairo caroaro bipe cotericaro to cãnibato quena na jã bʉgaquẽpʉ mʉja capreso bipe cũ rotibatanare, na caĩñuparã polisía. ");
INSERT INTO tav_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","To bairo na caĩrijere apirã Dio wii coteri maja ʉpaʉ, sacerdote maja ʉparã mena seeto api acʉari catʉgooñañuparã. “¿Dope bairo na baiyupari?” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","To bairo na caĩ tʉgooñari paʉna apeĩ caejayupʉ. Ejaʉ: —Presopʉ mʉja cabipe cũbatana Dio wiipʉ camajare buiorã áama, na caĩ buioyupʉ. ");
INSERT INTO tav_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","To bairo cʉ caĩ buiorije apii Dio wiipʉ cáaácoajupʉ Dio wii coteri maja ʉpaʉ polisía maja mena. Dio wiipʉ aá, apóstol majare na cajee ajuparã na cajeniñapa arʉapʉ tunu. Na quẽquẽnana na cajee ajuparã, camajare na uwibana. “Na maibʉjarãma mani cañebaenare. Na mani caquẽata camaja mani punijiniri ʉ̃ta rupaa mena mani re jĩaborãma,” caĩ tʉgooñañuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","To bairi apóstol majare na jee atí, to caneñaporã recomacapʉ na tʉjʉnucu roti, to bairo na cáto ocõo bairo na caĩ tutiyupʉ sacerdote maja ʉpaʉ: ");
INSERT INTO tav_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—“Jesu cʉ cabairique camajare na buio janacõaña,” cariapena mʉjaare jã caĩbapʉ. Jã mʉja caapiʉjaquẽto Jerusalén macana nipetiro apima mʉja cabuiori wamere. Jã quenare, “Cabai buiyebʉjawã naa, Jesure cajĩa rotiricarã aniri,” jã mʉja ĩ. ");
INSERT INTO tav_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","To bairo na caĩro ocõo bairo na caĩñupʉ Pedro jãa: —“Buio janacõaña,” jã mʉja caĩrijere jã caapiʉjaata Diore jã bai botioborã. To bairi Dio macare caapiʉjaparã jã ã, na caĩñuparã Pedro jãa. ");
INSERT INTO tav_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","—Jesure yucʉ pãipʉ na mʉja capapua jĩa rotiwʉ aperãre. To bairo mʉja capapua jĩa rotirique to cãnibato quena Dio mani ñicʉ jãa na cáti nʉcʉbʉgoricʉ maca cʉ catunu catioyupi tunu. ");
INSERT INTO tav_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Cʉ tunu catiori cʉ tʉpʉ cʉ cane aájupi Dio. Cʉ tʉpʉ ne aá, Caʉpaʉ cʉ cacũñupi camajare cacatiopaʉre, caĩñupʉ Pedro. —To bairi mania Israel maja caroorije mani cátiere jʉtiritiri mani catʉgooñarije mani cawajoaata mani majiriobojagʉmi Dio caroorije mani cátiere. ");
INSERT INTO tav_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","To bairo Jesucristo cʉ cabairiquere cabuiorã jã ã. Dio cʉ cãniere cʉ Espíritu Santo maca jãre camajioʉ ãmi, Diore caapiʉjarã jã cãno maca. To cãnacãʉna cʉ̃re caapiʉjarãre na joomi Dio cʉ Espíritu Santore, na caĩñupʉ Pedro. ");
INSERT INTO tav_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","To bairo Pedro na cʉ caĩrijere apirã seeto caapi punijiniñuparã to caneñaporã. Punijini, “Na cajĩa repe ã,” caame ĩñuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","To bairo na caame ĩri paʉ yua cawamʉ nʉcañupʉ jĩcaʉ caneñaporã mena macacʉ, na buiogʉ. Gamalié cawamecʉjupʉ. Fariseo majocʉ cãñupʉ. Moisé ãnacʉ cʉ caucarique caroaro camajii cãñupʉ. To bairi camaja nipetirã, “Cañuʉ ãmi Gamalié,” cʉ caĩ tʉgooña nʉcʉbʉgoyuparã naa. To bairi cʉ̃ wamʉnʉcari: —Jesu buerã cãnana na buti aáparo mai, caĩñupʉ. Na caapiquẽtopʉ ʉparãre apeye na buiogʉ to bairo caĩñupʉ. To bairo cʉ caĩro polisía na jʉgo buti aá, na cáto bero ocõo bairo caneñaporãre na caĩñupʉ Gamalié: ");
INSERT INTO tav_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","—Mʉjaa, Israel macana ati maja nare mʉja cátipe caroaro tʉgooñaña mʉjaa. ");
INSERT INTO tav_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tirʉmʉpʉ Teuda cawamecʉcʉ, “Camajii majuu yʉ ã,” caĩnucubajupʉ. To bairo cʉ caĩro caʉmʉa cuatrociento majuu cʉ mena aninemogarã cabaibajuparã. To bairo na cabairo camaja aperã maca Teudare cʉ cajĩa rocacõañuparã. To bairo cʉ na cajĩa rocaricaro bero cʉ yarã cãnibatana cáaá bate peticoajuparã. Cabero, “Cʉ cabuiorije ñuuquẽjupa,” caĩ tʉgooñañuparã camaja yua. ");
INSERT INTO tav_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Cʉ bero tunu apeĩ Juda, Galilea macacʉ, cʉ̃re bairona cabaiyupʉ. Caʉparã camajare na cacõoñari rʉmʉrina, “Caʉparãre na mani quẽto,” caĩñupʉ. To bairo cʉ caĩro capãarã camaja cʉ mena cãninemogayuparã. To bairo cʉ na cabainemorije to cãnibato quena aperã cʉ cajĩañuparã cʉ quenare. Cʉ̃re cãninemobatana cʉ na cajĩaricaro bero cáaá bate peticoajuparã na quena. ");
INSERT INTO tav_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yucʉ roquere ati maja Pedro jãare rooro na átiqueticõaña. Na buucõaña. Atie camajare na cabuio teñarije na majuuna na cáti tʉgooñarije to cãmata yoaro mee peticoagaro. Camaja majiritigarãma atie quenare Teuda, Juda cãnibatana na cabaibataje na camajiritiricarore bairona. ");
INSERT INTO tav_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dio maca na cʉ cabuio rotirijere na caĩrije to cãmata nare mʉja mata majiquetigarã. Dio macare mʉja bocateeborã, na caĩñupʉ Gamalié caneñaporãre. ");
INSERT INTO tav_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","To bairi: —Jaʉ, cariape mʉ ĩ mʉa, cʉ caĩñuparã Gamaliére. To bairo cʉ ĩ, capi ejooyuparã Jesu cʉ cabuericarãre tunu. Na pi ejoo, polisía majare na cabape rotiyuparã. Na bape roti, nare na cabape yaparoro: —To cõona Jesu cʉ cabairiquere buio janacõaña, na ĩba, to cõona na cabuuyuparã Pedro jãare yua. ");
INSERT INTO tav_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","To bairo na cáto caʉparã na caneñapo jeniñarica arʉa cãnana cabuticoajuparã. Buti, cawariñuuñuparã Jesu ye quetire na cabuiorije wapa nare na cabaperique to cãnibato quena. —Ñuubʉjami Dio. Jesu ye quetire na buioato ĩi mani cabejeyupi Dio, caĩ wariñuuñuparã. ");
INSERT INTO tav_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","To bairi Dio wiipʉ, “Jesu camajare na canetooʉ ãmi,” caĩrijere cabuiocõa aninucuñuparã. Na ya wiiri quenare neñapori cabuiocõa aninucuñuparã, caʉparã, “Janacõaña,” na caĩrije to cãnibato quena. ");
INSERT INTO tav_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Cabero Jesucristore caapiʉjarã capãarã cãninemoñuparã tunu. Capãarã majuu na cãninemori paʉna caame tuti jʉgóyuparã. Jerusalén macanare catutiyuparã judío maja apero macana griego yere cawadarã maca: —Mʉja yarã cawapearã romiri, cabʉcʉrã romiri quena jã yarã romirire jooricaro netoro mʉja joo mani yere to cãnacã rʉmʉ ʉgarique ricaworã, caĩ tutiyuparã judío maja griego yere cawadarã maca Jerusalén macanare. ");
INSERT INTO tav_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","To bairo na caĩ tutirijere caapiyuparã apóstol maja. Tiere apirã nipetiro Jesucristore caapiʉjarãre caneñapo rotiyuparã. Na caneñapori paʉpʉ ocõo bairo na caĩñuparã apóstol maja: —Jãra ʉgariquere caricaworã jã cãmata Jesu ye quetire jã buio majiquetiborã. Tiere jã cabuio janaro ñuuquetiboro. ");
INSERT INTO tav_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","To bairi mani yarã, Jesucristore caapiʉjarãre siete cãnacãʉre na bejeya cacʉgoquẽnare caricawoparãre. “Cañuurã ãma,” camaja na caĩ tʉjʉrã jetore na bejeya. Caroaro Dio Espíritu Santore cacʉgorã, caroaro camajirã jetore na bejeya. ");
INSERT INTO tav_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jã maca Diore cajenirã, Dio Wadarique cabuiorã jã anicõagarã, caĩñuparã apóstol maja. ");
INSERT INTO tav_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","To bairo na caĩro apirã: —Jaʉ, to bairona cátipe ã, caĩñuparã Jesure caapiʉjarã nipetiro. To bairo ĩ, Estebare cʉ cabejeyuparã. Caroaro Diore caapi nʉcʉbʉgoʉ cãñupʉ. Espíritu Santore cacʉgo netoʉ cãñupʉ. Aperã quenare cʉ̃re bairo cãnare cabejeyuparã: Felipe, Prócoro, Nicanó, Timó, Parmena, Nicolás (Antioquía macacʉre) cabejeyuparã. Nicolás apeĩ anibacʉ quena judío majare bairo Diore cáti nʉcʉbʉgoʉ cãñupʉ. ");
INSERT INTO tav_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","To cãnacãʉna na cabejeyuparã. To bairi na beje, apóstol maja tʉ na cajee ajuparã na cabejericarãre. Na jee atí, Diore na jenibojari na rʉpoarire cañiga peoyuparã. Dio mʉja cátibojape cʉ átinemoato ĩrã cájuparã. ");
INSERT INTO tav_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","To bairi Jesu ye queti cajejanemoñupe. To cajejaro Jesucristore caapiʉjarã Jerusalẽpʉre capãarã cãninemoñuparã. Sacerdote maja capãarã Jesu ye quetire caapiʉjayuparã na quena yua. ");
INSERT INTO tav_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dio caroaro cátinemoñupʉ Estebare. To bairo cʉ cátinemoro mena caacʉori wame cáti iñoorijere camaja na catʉjʉrona cátinucuñupʉ Esteban. ");
INSERT INTO tav_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","To bairi judío maja ape wii neñapo buerica wii macana, Los Libertados cawamecʉti poa macana jĩcaarã cʉ caĩ wada neto jʉgóyuparã. Cãñuparã Sirene macana, Alejandría macana, Cilicia yepa macana, Asia yepa macana Estebare caĩ wada netorã. ");
INSERT INTO tav_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Cʉ̃re na caĩ wada netorije cãnibato quena dope bairo cʉ caĩ neto majiquẽjuparã, Espíritu Santo mena nare cʉ caĩ buio majiro. ");
INSERT INTO tav_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","To bairi cʉ ĩ neto majiquetibana, aperãre yajioro niyeru na cajooyuparã, ʉparãre cʉ wadajãña ĩrã. —“ ‘Mani ñicʉ Moisé cʉ carotirique ñuuquẽe,’ ĩnucumi Esteban. Dio quenare rooro ĩmi Esteban,” ĩ buio bateya camajare, na caĩñuparã, niyeru na joori. To bairo na caniyeru jooro rooro majuu Estebare cʉ caĩ buio bateyuparã. ");
INSERT INTO tav_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","To bairo na caĩ buio baterijere apirã camaja, cabʉcʉrã, judío majare cabuerã Estebare cʉ capunijiniñuparã. Cʉ punijini, cʉ ñe, caʉparã na cajeniña neñapori arʉapʉre cʉ cañe aájuparã. ");
INSERT INTO tav_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Caʉparã tʉpʉ cʉ ñe aá, ocõo bairo Estebare cʉ caĩ wadajãñuparã: —Ani Dio wiire rooro ĩnucumi. “Mani ñicʉ Moisé cʉ carotirique ñuuquẽe,” ĩnucumi tie quenare. ");
INSERT INTO tav_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Jesu Nasaré macacʉ ati wiire rocacõagʉmi,” ĩmi. “Mani ñicʉ Moisé manire cʉ carotiriquere mani cabai nʉcʉbʉgorijere recõagʉmi Jesu,” ĩnucumi Esteban, caĩ wadajãtoyuparã. ");
INSERT INTO tav_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","To bairo na caĩ wadajãri paʉna to cãna nipetirã Estebare cʉ na catʉjʉro cʉ riya caaji bateyupe, Dio tʉ macacʉre bairona. ");
INSERT INTO tav_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Cʉ̃re na catʉjʉri paʉ sacerdote maja ʉpaʉ cʉ caĩ jeniñañupʉ Estebare: —¿Cariapena mʉ na ĩti mʉre na caĩrijera? cʉ caĩ jeniñañupʉ. ");
INSERT INTO tav_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","To bairo cʉ caĩro ocõo bairo na caĩ yʉyupʉ Esteban: —Yʉ yarã, mʉjaare yʉ caĩ buiopa wame yʉ apiya. Mani ñicʉ Abraham tʉpʉ caejayupʉ Dio caroaro caaji batei Mesopotamia yepa cʉ ya yepapʉ cʉ cãnopʉ, Harán na caĩri macapʉ cʉ cáaáparo jʉgoye. Abraham tʉpʉ buia eja, ocõo bairo cʉ caĩñupʉ Dio: ");
INSERT INTO tav_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Ati yepare mʉ yarãre na buti weoya. Ape yepa mʉ yʉ caiñoopa yepapʉ mʉ anigʉ,” cʉ caĩñupʉ Dio Abrahãre. ");
INSERT INTO tav_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","To bairo Dio cʉ̃re cʉ caĩro cʉ ya yepare, Mesopotamia yepare, Caldea maja cʉ yarãre na cabuti weoyupʉ. Buti aá, Harán na caĩri macapʉ caejayupʉ. Topʉ eja, cãñupʉ. To cʉ cãnitoye cʉ pacʉ cabai yajiyupʉ. Cʉ pacʉ cʉ cabai yajiro bero ati yepa mani cãnipa yepapʉ cʉ cajʉgo ejayupʉ Dio yua, caĩñupʉ Esteban. ");
INSERT INTO tav_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","—Abraham cʉ cãni yʉteapʉre mai ati yepare cʉ canuniquẽjupʉ Dio. To bairi jĩca paʉacã maca, “Ati paʉ yʉ ya paʉ ã,” caĩ majiquẽjupʉ Abraham. To bairo cʉ caĩ majiquẽtie cãnibato quena, “Cabero ati paʉ, ati yepa mʉ ya yepa anigaro. Mʉ pãramerã ya yepa anigaro,” cʉ caĩñupʉ Dio. Mai Abraham capunaa mácʉ cʉ cãnibato quena to bairo cʉ caĩñupʉ. ");
INSERT INTO tav_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Apeye cʉ caĩ buionemoñupʉ Dio Abrahãre tunu: “Mʉ pãramerã cãni ʉjarãpʉ aperopʉ aperã na ya yepapʉ cáaáteñarã anigarãma mai. To bairo na cabairopʉ tutuaro quẽrique mena na paa rotigarãma to macana. Cuatrociento cãnacã cʉma popiye tamʉogarãma, tutuaro paabojari maja anibana. ");
INSERT INTO tav_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Cabero yʉ majuuna popiye nare capaa rotirã macare na yʉ popiyeyegʉ. Na yʉ capopiyeyero bero mʉ pãramerã maca topʉ cãnana buti weogarãma. Cabuti weoricarã ati yepapʉre tunu ejagarãma yua. Tunu eja, yʉre cáti nʉcʉbʉgorã, yʉ yarã anigarãma,” Abrahãre cʉ caĩñupʉ Dio. ");
INSERT INTO tav_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","To bairo cʉ ĩ, circuncisión cʉ cáti rotiyupʉ Dio, cʉ bero macana quena na cáti petipa wame. To bairi circuncisión cájuparã, Diore cáti nʉcʉbʉgorã jã ã ĩrã. Cabero Abraham camacʉ cʉjupʉ Isaá cawamecʉcʉre. Isaá jĩca semana cʉ cabuiaro bero circuncisión cʉ cájupʉ Abraham. To bairona cájupʉ Isaá cʉ macʉ Jacobo quenare. Jacobo to bairona cájupʉ cʉ punaa quenare doce cãnacãʉpʉrena mani ñicʉare yua. ");
INSERT INTO tav_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","’Cabero mani ñicʉapʉ na bai Josére cʉ capejucʉti punijiniñuparã cʉ jʉgocʉ jãa. Cʉ pejucʉti punijiniri Ejipto yepapʉre cáaánare niyeru jeeri nare cʉ cajooyuparã, na paabojari majocʉ cʉ ãmaro ĩrã. To bairo rooro cʉ na cátaje cãnibato quena Josére cʉ cátinemoñupʉ Dio rooro cʉ catamʉori paʉre. Cʉ átinemoʉ capee majiriquere cʉ cajooyupʉ Dio. To bairi José caroaro camajii cʉ cãno maca Faraõ, Ejipto macana ʉpaʉ cʉ catʉjoo netocõañupʉ. To bairi cʉ ẽoro macacʉ ʉpaʉ cʉ cacũñupʉ. Cʉ ya wii macaje paarique ʉpaʉ quenare cʉ cacũñupʉ Josére. ");
INSERT INTO tav_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Cabero Ejipto yepapʉ Canaá yepa quena cʉ yarã na cãni yepapʉ ʉgarique na caotebataje capetiyupe. To capetiro seeto cañigo tamʉoñuparã mani ñicʉa, ʉgarique bʉgaquetibana, na caĩñupʉ Esteban sacerdote maja ʉpaʉ jãare. ");
INSERT INTO tav_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","—To bairi na pacʉ Jacobo Ejipto macana ʉgarique na cacũrique to cãnore queti apii cʉ punaare mani ñicʉare caʉgarique wapayera aá rotiyupʉ. ");
INSERT INTO tav_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na cʉ cawapaye rotiro cawapayera aájuparã Ejiptopʉre. Ejiptopʉ eja, wapaye tunu atí, cãñuparã. Cabero na cawapayebataje capetiro tʉjʉrã catunu wapayera aájuparã tunu. Ti paʉ na caejaro José maca, “Yʉa mʉja baina yʉ ã tirʉmʉpʉ Ejiptopʉre mʉja cajoo rocabatacʉ,” na caĩ buioyupʉ. To bairo na ĩ buio yaparo Ejipto macana ʉpaʉ Faraõre, “Ati maja yʉ jʉgocʉ jãana ãma,” cʉ caĩ buioyupʉ. ");
INSERT INTO tav_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Cʉ ĩ buio yaparo cʉ pacʉ Jacobo jãare na capijoyupʉ. “Yʉ tʉpʉ na aparo,” na caĩ queti jooyupʉ, caĩñupʉ Esteban. ");
INSERT INTO tav_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","—To bairo José na cʉ capijoro apii Ejipto yepapʉre cáaácoajupʉ Jacobo José cʉ cãni yepapʉre, cʉ punaa nipetirã mena. Setenta y cinco cãnacãʉ majuu cãñuparã Ejiptopʉ cáaátana. Topʉ ãcʉna cabai yajiyupʉ Jacobo yua. Cʉ punaa mani ñicʉa na quena to bairona Ejipto yepapʉ cabai yaji peticoajuparã. ");
INSERT INTO tav_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Cayoaro beropʉ na cabai yajiro bero na õwaa cacararije ãnajere cajee aájuparã na pãramerãpʉ Siquẽ na caĩri macapʉ, topʉ yaagarã. Na õwaa ãnajere cañujo reyuparã ʉ̃ta totipʉ, mani ñicʉ Abraham Hamor cawamecʉcʉ punaare na cʉ cawapayerica paʉ majuu. Ejiptopʉ ãnaa, capãarã majuu camaja bʉyuparã. ");
INSERT INTO tav_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Caberopʉ yua Abrahãre, “Ati yepa Canaá cawamecʉti yepa mʉ pãramerã na ya yepa anigaro,” cʉ caĩ buioricarore bairona Dio cʉ cajoogari paʉ caejayupe. ");
INSERT INTO tav_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ti paʉ cãno apeĩ José cãniñaricʉre camajiquẽcʉ Ejipto macana ʉpaʉ cajãañupʉ yua. ");
INSERT INTO tav_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cʉ maca ĩtori rooro majuu mani ñicʉare na cájupʉ. Na punaa niñaacãre, “