﻿USE sofia;
DROP TABLE IF EXISTS sofia.taq_vpl;
CREATE TABLE taq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES taq_vpl WRITE;
INSERT INTO taq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ăṭṭarex n-ƔisaĂlmasex wa n-ahăya n-ănnăbi Dawəd d-ahăya n-Ibrahim da: ");
INSERT INTO taq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ikrăš Ibrahim Isxaqq, Isxaqq ikrăš Yaqub, Yaqub ikrăš Yăhuda d-ayətma-s wi iyyăḍnen. ");
INSERT INTO taq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yăhuda ənta, təkrăš-as hănne-s Tamar, Faris d-Zira. Ikrăš Faris Xăšrun, ikrăš Xăšrun Aram, ");
INSERT INTO taq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ikrăš Aram Aminădab, ikrăš Aminădab Nasun, ikrăš Nasun Sălmun. ");
INSERT INTO taq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ikrăš Sălmun d-hănne-s Rahab Boɣaz, ikrăš Boɣaz d-hănne-s Rutt Ɣubăyd, Ɣubăyd ənta, ikrăš Yasa. ");
INSERT INTO taq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yasa ənta a orăwăn ămănokal Dawəd. Dawəd ənta, ikrăš d-hănne-s n-Urya Sulăyman, ");
INSERT INTO taq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulăyman ənta ikrăš Raxăbyăm, Raxăbyăm ikrăš Abya, Abya ikrăš Asaf, ");
INSERT INTO taq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf, ikrăš Yăhušăffat, Yăhušăffat ikrăš Yoram, Yoram ikrăš Uzya, ");
INSERT INTO taq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzya ikrăš Yotam, Yotam ikrăš Axaz, Axaz ikrăš Ezekya, ");
INSERT INTO taq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekya, ikrăš Mănase, Mănase ikrăš Amon, Amon ikrăš Yozya, ");
INSERT INTO taq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yozya ikrăš Yăxunya d-ayətma-s wi iyyăḍnen. Ăzzăman-wen-dăɣ a dăɣ-əttəkfălăn kăl-Iṣrayil s-ăkall wa n-Babilun. ");
INSERT INTO taq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ḍarăt atəkfəl-wen-dăɣ ad-ikrăš Yakonya Ăṣṣălat, Ăṣṣălat ikrăš Zurubabil, ");
INSERT INTO taq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zurubabil ikrăš Abihud, Abihud, ikrăš Ilyakim, Ilyakim ikrăš Yazur, ");
INSERT INTO taq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yazur ikrăš Ăssăddiq, Ăssăddiq, ikrăš Yahim, Yahim ikrăš Ɣəlihud, ");
INSERT INTO taq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɣəlihud ikrăš Ɣəlyazăr, Ɣəlyazăr, ikrăš Mittăn, Mittăn, ikrăš Yaqub. ");
INSERT INTO taq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaqub-en-dăɣ a ăshăyăwăn Yusəf wa n-ăhaləs n-Măryăma ta torăwăt Ɣisa wa s-itawănna Ălmasex. ");
INSERT INTO taq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ɣur-ăzzăman wa n-Ibrahim təkkəd ăzzăman wa n-Dawəd, okăynăt mărawăt əzzurəyaten d-əkkoẓăt; ɣur-ăzzăman wa n-Dawəd təkkəd ăzzăman wa n-atəkfəl n-kăl-Iṣrayil s-ăkall wa n-Băbilun, okăynăt mărawăt əzzurəyaten d-əkkoẓăt; ɣur-ăzzăman daɣ wa n-atəkfəl n-kăl-Iṣrayil s-ăkall wa n-Babilun təkkəd ăzzăman wa n-tiwit n-Ălmasex, mărawăt əzzurəyaten d-əkkoẓăt a okăynen. ");
INSERT INTO taq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ǝnta da əmmək wa s-iwa Ɣisa Ălmasex: ma-s Măryăma, ittar-tăt ăhaləs s-isəm-net Yusəf măšan dăɣ-a-wa ităjj Măssinăɣ s-tărna n-Unfas Šăddijăn, təkrăš ənniyăt hărwa wăr toher d-Yusəf isəftaɣ. ");
INSERT INTO taq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusəf-i n-anəmmutăr-net, ăhaləs n-ămaɣdal a ămoos, inhăy a-s tanfust-den-dăɣ ɣas, ăssosăm, wăr t-illa ere dăɣ-ija isălan ed wăr-irha ad-tăt-ikšəf. Təssəba n-a-wen-dăɣ a făl t-dd-ijjăš ənniyăt n-ad-hin-izjăr isălan-net dăɣ-ufăr. ");
INSERT INTO taq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Izinəzjum dăɣ-a-wen-dăɣ a-s has-dd ănfalăl ănjălos n-Emăli dăɣ-tăharjit, innʼ-as: «Yusəf Ăgg-Dawəd, wăr tăksuḍăd adubən n-Măryăma făl-a-s ənniyăt wa la, Unfas Šăddijăn a-s əssəbab-net, ");
INSERT INTO taq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ad-təkrəš alyaḍ, təjəd-as isəm Ɣisa făl-a-s ənta a madăn-iɣləs tamətte-net dăɣ-ibăkkaḍăn-net.» ");
INSERT INTO taq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A-wa iket-net ija i-ad-itbət a-wa innă ănnăbi n-Măssinăɣ iyyăn a-s innă: «Innă Emăli: ");
INSERT INTO taq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‹Săjdăt! Ad-təkrəš tămawaḍt wărăt təzzey meddən ənniyăt, təkrəš alyaḍ, iwăr-t isəm Imanuwil›. Imanuwil, ălmăɣna-net: Măssinăɣ, izzăɣ-dd jere-năɣ.» ");
INSERT INTO taq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Inkăr-dd Yusəf dăɣ-eḍəs, ămešăl a-wa has-innă ănjălos n-Emăli, iẓẓəẓlăy-dd Măryăma, ");
INSERT INTO taq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","măšan wăr dăr-s oher isəftaɣ har təjrăw eɣăf-net, təkrăš alyaḍ, ăswăr-t isəm Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ăzzăman wa d-ămoos Harudəs ămănokal n-teje ta n-Ălyăhudəyăt ad-iwa Ɣisa dăɣ-taɣrəmt ta n-Bătlehăm hăt teje-ten-dăɣ. Ăzzăman-en-dăɣ daɣ ad-dd-osăn imusănăn dd-falnen emăynăj, əkkan-dd Yărussălam, ");
INSERT INTO taq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sastanăn ăddinăt d-ămănokal n-kăl-Ălyăhud wa s-iket iwa s-ənhăyăn atăr-net a-s dd-izjăr s-emăynăj; əllăɣen-asăn a-s ass ad-dd-jăn i-ad-t-əɣbədăn. ");
INSERT INTO taq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Islʼ ămănokal Harudəs i-măjrăd-wen-dăɣ ɣas, iššəwwăš ənta d-kăl-Yărussălam iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ăsdăw-dd ḍarăt-a-wen e d t-illăm ămănokal n-kăl-tikutawen d-ălɣalim n-Ăṭṭăwrăt, issəstăn-tăn d-edăgg wa dăɣ-mad-iwəy Ălmasex. ");
INSERT INTO taq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ǝnnăn-as: «Bătlehăm ta hăt teje ta n-Ălyăhudəyăt a dăɣ-mad-iwəy făl-a-s iktab ănnăbi iyyăn a-s, inna Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ya Bătlehăm, kămm-i hăt teje ta n-Ălyăhudəyăt, tidət, wăr təkned təmɣăre jer-tiɣărmaten ti n-kăl-Ălyăhud măšan, kămm-i-dăɣ ənḍărrăt ad-dd-mad-izjăr ămănokal wa madăn-izar i-tamətte-nin ta n-kăl-Iṣrayil, isəssiɣəd-tăt.› » ");
INSERT INTO taq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Islă Harudəs i-a-wen ɣas, ikkăs-dd imusănăn-winnin s-takše, ad-tăn-ikann asəstan d-ăzzăman wa dăɣ-hasăn-dd-ănfalăl atăr wa s-ənnăn ənhayăn-t. ");
INSERT INTO taq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Issəglʼ-en ḍarăt-a-wen, dăɣ-a-s hasăn-inna: «Ăkkăt Bătlehăm, təknəm asəstan d-alyaḍ, afăl t-təjrăwăm, əqqəlăt-ahi-dd, təjəm dăɣ-i isălan i-ad-t-ăkkăɣ, ărkăɣăɣ-as năkk-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ǝslăn i-a-wa inna, əglăn. A ənḍărrăn, atăr-wənnin ənhăyăn s-emăynăj-da-dăɣ, ăzzar-asăn har tanămhăla n-ehăn wa iha alyaḍ. ");
INSERT INTO taq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ǝnhăyăn atăr-en, əknăn tedăwit. ");
INSERT INTO taq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ǝjjăšăn ehăn wa jənnəj-ənhăyăn atăr, ənhăyăn alyaḍ d-ma-s Măryăma, ărkăɣăn-as, ad-t-ɣabbădăn. Orăn ḍarăt-a-wen tisətwar-năsăn, əkkăsăn-as-dd tibəddar n-orăɣ d-matălxer d-telḍəḍt. ");
INSERT INTO taq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ǝllan-t dihen-dăɣ a-s tăn-issəlmăd Măssinăɣ dăɣ-tăharjit s-udaɣnet i-ad-əqqəlăn Harudəs. Jăn tabarăt tiyyăt săl ta dd-jăn, əqqălăn ăkall-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ǝglăn imusănăn ənnin ɣas, ănfalăl-dd ănjălos n-Emăli i-Yusəf dăɣ-tăharjit, innʼ-as: «Yusəf, ənkăr, əḍkəl alyaḍ d-ma-s, jawăḍ s-ăkall wa n-Miṣra, təzzăɣăd dihen-dăɣ har ašăl wa d-hak mad-ănnăɣ tăddoobed ad-dd-təqqəlăd făl-a-s alyaḍ-i, itammăɣ-as Harudəs i-ad-t-ănɣ.» ");
INSERT INTO taq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Inkăr, iḍkăl alyaḍ d-ma-s, ăhona s-Miṣra ehăḍ-wen-dăɣ, ");
INSERT INTO taq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","izzăɣ dihen har ăba Harudəs. Ijʼ-a-wen i-ad-itbət a-wa innă ănnăbi iyyăn a-s innă, innă Emăli: «Ǝɣreɣ-dd Rure-ɣ i-ad-dd-izjăr Miṣra.» ");
INSERT INTO taq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ilmăd Harudəs a-s əssəswădăn-t imusănăn ed wăr t-dd-olesăn uɣəl ɣas, ikăf s-aḍkăr. Omăr ălwăqq-wen-dăɣ s-ad-ămmătăn ilyaḍăn wi hănen Bătlehăm d-attayăn-net t-əllanen daw-əssin iwətyan ed tăqqăn-ten-dăɣ a togdăhăt d-ta s-has-ənnăn imusănăn, ănfalălăn-asăn-dd atăr dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ămoos a-wen-dăɣ ijăn a ăssiitbătăn a-wa innă ănnăbi Yirmiya a-s inna dăɣ-əlkəttab n-Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ijʼ emăsli n-tisnant dăɣ-aɣrəm wa n-Rama, ja tahăla d-tikălelen. A-wa Răhila hallăt ilyaḍăn-net, ăbă-dd a tăt-isəssisumăn, ed ilyaḍăn-net, ămmun iket-dăɣ-năsăn.» ");
INSERT INTO taq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ăba Harudəs ɣas, ănfalăl-dd ănjălos n-Emăli i-Yusəf dăɣ-tăharjit dăɣ-ăkall wa n-Miṣra, innʼ-as: ");
INSERT INTO taq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Ǝḍkəl alyaḍ d-ma-s ămăra, təqqəlăd ăkall wa n-Iṣrayil ed ăddinăt wi s-kăla tattarăn iji n-iman-net, ăba-tăn.» ");
INSERT INTO taq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Inkăr Yusəf, iḍkăl alyaḍ d-ma-s, iqqăl ăkall wa n-Iṣrayil. ");
INSERT INTO taq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Măšan, islă a-s Erkilyas ăgg Harudəs a ămnakălăn dăɣ-edăgg n-ti-s făll-teje ta n-Ălyăhudəyăt ɣas, igdăl-as əmməttəsu ad-tăt-ăkk i-ad-dăɣ-s izzăɣ. Ănfalăl-as-dd Măssinăɣ dăɣ-tăharjit, innʼ-as ad-ăkk teje ta n-Galila. ");
INSERT INTO taq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Iwwăḍ-in teje-ten ɣas, izzăɣ dăɣ-taɣrəmt s-isəm-net Năṣirăt. Ija a-wen i-ad-itbət a-wa ənnăn ănnăbităn făll-Ɣisa a-s ənnăn: «Ad-t-iwăr isəm: U-Năṣirăt.» ");
INSERT INTO taq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Išilan-win-dăɣ d-izzăɣ Ɣisa taɣrəmt ta n-Năṣirăt, ad-issəntă Exya wa n-Enəsselmăɣ ămašal-net, ijanna i-ăddinăt dăɣ-tenere n-teje ta n-Ălyăhudəyăt: ");
INSERT INTO taq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Utabăt făl-a-s Təmmənəya n-Măssinăɣ, tohăẓ-kăwăn-dd.» ");
INSERT INTO taq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A-wen-dăɣ išlăn Exya, a dăɣ-ăssewăl ănnăbi Saya, a-s innă: «Ad-t-iməl ăhaləs ăsiɣăren dăɣ-tenere, ijanna i-ăddinăt: ‹Ăknăt tabarăt i-Emăli, səssiɣədăt data-s ibaran-net.› » ");
INSERT INTO taq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A-s ităjj a-wen-dăɣ, ilsa Exya asălso iknan s-elăm n-amnəs warăn amẓadăn, ijbas s-taməntəka n-elăm, iddar s-tašwalt d-torawăt. ");
INSERT INTO taq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tisən-t-dd ăddinăt dd-falnen aɣrəm wa n-Yărussălam d-teje ta n-Ălyăhudəyăt iket-net d-idăggan iket-năsăn wi ohăẓnen ejănš wa n-Ɣurdəni, ");
INSERT INTO taq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ad-tilɣun ibăkkaḍăn-năsăn dat-tamətte, isalmaɣ-tăn Exya dăɣ-ejănš wa n-Ɣurdəni. ");
INSERT INTO taq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ijrăh-in Exya a-s tamətte ta t-dd-təkkăt, han-tăt ăddinăt ăjjootnen la taggayt ta n-kăl-faris d-ta n-kăl-sadus ărhanen ad-tăn-isəlmăɣ, innăḍ-dd săr-săn, innʼ-asăn: «Ya taššălen-i-dăɣ! Wădden tənnăm təmsădăm! Ǝyya, a tărham ad-tətwəsəlmăɣăm i-ad-təfələm daw-ăššăreɣa n-Măssinăɣ wa s-išwar fălla-wăn dd-oḍa? Lăɣătăt-ahi, mi kăwăn-issəlmădăn s-a-wen? ");
INSERT INTO taq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sətbətăt tătubt-năwăn s-timašalen ăhuuskătnen, ");
INSERT INTO taq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","wăr tăsfăllăm făll-tənna n-a-s əzzurəyăt n-Ibrahim a tămoosăm ed afăl tăqqăl s-isălan n-əzzurəyăt ɣas, Măssinăɣ, ăddoobăt ad-isəmməskəl tihun-ti-dăɣ hannăyăm, ixlək-dd dăɣ-snăt əzzurəyăt i-Ibrahim. ");
INSERT INTO taq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ăjăt ənniyăt făl-a-s emm n-tutăla ăru d-insa făll-ikewăn n-ihəškan, e d t-illăm ahəšk wărăn itirəw aratăn iha ălfăyda, ad-hin-ăttănkăḍ, itwəjăr-in dăɣ-efew. ");
INSERT INTO taq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Năkk, aman a dăɣ-kăwăn-salmaɣăɣ i-ad-umas a-wen ašămol n-tătubt-năwăn măšan, ilkam-ahi ăhaləs hi-ijan mijraw wa-dăɣ s-wăr-ănhăjjăɣ wăla-dăɣ d-ad-əḍəsăɣ issal n-tifădelen-net, ənta, Unfas Šăddijăn d-efew a dăɣ-kăwăn-mad-isəlmăɣ, ");
INSERT INTO taq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","iṭṭaf tesăyt-net ta s-mad-hin-izuzzăr allon-net, isədəw əttăɣam wa olăɣăn dăɣ-ejănd-net, irməs ahošăr wa wăr-ihʼ ălfăyda, ijăr-t-in dăɣ-efew ăhijăljălăn hărkuk.» ");
INSERT INTO taq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dăɣ-a-wen-dăɣ a dd-ifăl Ɣisa teje ta n-Galila, ikkă-dd Exya i-ad-t-isəlmăɣ dăɣ-ejănš wa n-Ɣurdəni ");
INSERT INTO taq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","măšan, unjăy Exya s-a-wen, ănn-ak, innʼ-as: «Năkk a ămiɣatărăn s-ad-hi-səlmăɣăd dăɣ-aman, ɣas əndek e-d ilʼ əmmək n-a-s kăyy a hi-dd-itakkăn i-a-wen?» ");
INSERT INTO taq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Innʼ-as Ɣisa: «Ămăra-dăɣ, əqbəl s-a-wen ed əmmək-wen-dăɣ a-s mad-nămašăl a-wa oɣădăn, irha Măssinăɣ.» Ijʼ-as Ɣisa măjrăd-wen-dăɣ ɣas, issəlmăɣ-t Exya. ");
INSERT INTO taq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ătwăsălmăɣ Ɣisa, diha-dăɣ dd-izjăr aman, ad-dd-ămerăn išənnawăn dăɣ-təssəba-net, inhăy Unfas Šăddijăn n-Măssinăɣ har fălla-s dd-ăzzubbăt dăɣ-ănnuɣ n-tedăbert măllăt. ");
INSERT INTO taq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dăɣ-tamăzăyyat-ten-dăɣ ad-dd-ijmăḍ emăsli išənnawăn, innăn: «A-wa Rure-ɣ wa əkneeɣ tărha, ənta a dăɣ-ăsriwăn iman-in.» ");
INSERT INTO taq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Oɣăd Unfas ŠăddijănƔisa ḍarăt-a-wen s-tenere i-ad-t-ižžurrəbət Iblis. ");
INSERT INTO taq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ija dihen əkkoẓăt timərwen n-ehăḍ d-ašăl, ăẓum, wăr-ikša, wăr-iswa. Šămad tokay tăqqăn-ten-dăɣ, ad-ălluẓ. ");
INSERT INTO taq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ălwăqq-wen-dăɣ ad-t-ohăẓ Iblis-i n-ălmužărrib, innʼ-as: «Šămad kăyy a-s Rure-s n-Măssinăɣ, ănn i-tihun-ti-dăɣ ad-umasnăt tijəlwen!» ");
INSERT INTO taq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Innʼ-as Ɣisa: «Iktab dăɣ-măjrăd n-Măssinăɣ a-s: ‹Tămudre n-ăgg-adəm, wăr təmdă făl tetăte ɣas, iddăret daɣ s-e d t-illăm măjrăd dd-izjarăn emm n-Măssinăɣ.› » ");
INSERT INTO taq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iwwăy-t Iblis ḍarăt-a-wen s-aɣrəm wa šăddijăn n-Yărussălam, ijʼ-e făll-afălla n-ehăn n-ămudd wa măqqărăn, innʼ-as: ");
INSERT INTO taq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«Šămad kăyy a-s Rure-s n-Măssinăɣ, ăyy iman-năk s-ăkall ed iktab dăɣ-măjrăd n-Măssinăɣ a-s: ‹Ad-săr-k dd-amăr Măssinăɣ ănjălosăn-net əkbəlăn-kăy dăɣ-ifassăn-năsăn i-ad-wăr hak-rəssəl wăla-dăɣ tăhunt tiyyăt ɣas.› » ");
INSERT INTO taq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Innʼ-as Ɣisa: «Iktab daɣ dăɣ-măjrăd n-Măssinăɣ a-s: ‹Wăr-e tarəməd Emăli-năk, Măssinăɣ.› » ");
INSERT INTO taq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iwwăy-t daɣ Iblis s-aḍaɣ iyyăn iknan aḍkul, issəknʼ-e əddəwəlăn n-ăddunya iket-net d-ălxurmăt-năsăn, innʼ-as ămăra: ");
INSERT INTO taq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«Hakkăɣ-kăy a-wa-dăɣ iket-net, afăl dat-i tărkăɣăd, tăɣbădăd-ahi.» ");
INSERT INTO taq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Innʼ-as Ɣisa: «Iblis, ajəj-ahi; iktab dăɣ-măjrăd n-Măssinăɣ a-s: ‹Ăɣbəd Emăli-năk Măssinăɣ, ənta ɣas a fălla-k ilan ălxidmăt.› » ");
INSERT INTO taq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oyyʼ-e Iblis ḍarăt-a-wen, osăn-t-dd ănjălosăn ăssaɣăt-wen-dăɣ, ăxdămăn-as. ");
INSERT INTO taq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Islă Ɣisa atărməs n-Exya wa n-Enəsselmăɣ ɣas, ikkă teje ta n-Galila. ");
INSERT INTO taq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Izjăr taɣrəmt ta n-Năṣirăt, iglă izzăɣ ta n-Qăfărnaxum, a-wen taɣrəmt hat asălim n-ejănš wa n-Galila dăɣ-attayăn n-teje ta n-Ẓabilun d-ta n-Naftali; ");
INSERT INTO taq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ămoos a-wen a ăssiitbătăn măjrăd wa ija ănnăbi Saya a-s innă: ");
INSERT INTO taq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ya kăl-Ẓabilun, ya kăl-Naftali! Kăwăneḍ-i hănen asălim d-ejănš wa n-Galila, Kăwăneḍ-i hin-əllanen i-ejănš wa n-Ɣurdəni, săjdăt! Kăwăneḍ-i n-kăl-teje ta n-Galila əzzăɣăn inəẓẓulam, săjdăt! ");
INSERT INTO taq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tamətte ta hăt tihay, ămlăwlăw-dd fălla-s ănnur măqqărăn, ăddinăt daɣ wi s-kăla əzzăɣăn tihay ti hănen tamăttant, ašăl-i, ăzzubbăt-dd fălla-săn ănnur.» ");
INSERT INTO taq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ɣur-dihen-dăɣ ad-issənta Ɣisa ămašal-net, ixaṭṭăb, ijanna i-ăddinăt: «Utabăt făl-a-s Təmmənəya n-Măssinăɣ, tohăẓ-dd.» ");
INSERT INTO taq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Irjaš Ɣisa ašăl iyyăn dăɣ-asălim n-ejănš wa n-Galila a-s inhăy əssin ayətmatăn: Simyon wa s-itawănna Bəṭrus d-ăŋŋa-s Idris, təjjarăn tătart-năsăn dăɣ-aman ed iməhhuyya n-imănan a ămoosăn, ");
INSERT INTO taq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","innʼ-asăn: «Ǝlkəmăt-ahi, ad-kăwăn-ăjăɣ meddən săr-i dd-sadawnen ăddinăt i-ad-tăn-ăɣləsăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oyyăn titarren-năsăn ălwăqq-wen-dăɣ, əlkămăn-as. ");
INSERT INTO taq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Illa-hin i-dihen, olăs daɣ Ɣisa ahănay n-əssin ayətmatăn iyyăḍ: Yaqub d-ăŋŋa-s Exya, han turăft n-aman əntăneḍ d-abba-năsăn Zăbdi, samăkrasăn titarren-năsăn; iɣrʼ-en-dd s-iman-net əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Oyyăn abba-năsăn hakd turăft n-aman dihen-dăɣ, əlkămăn-as ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ălliil Ɣisa teje ta n-Galila iket-net, isaɣra ăddinăt dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, ixaṭṭăb isălan n-Ălənžil n-Təmmənəya n-Măssinăɣ, izizuy ăddinăt dăɣ-turhənnawen-năsăn d-ălɣibăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Intăj isəm-net dăɣ-ăkall iket-net har ăwwăḍ Surya. Tamawayăn-dd săr-s imarhinăn d-inaɣyabăn d-iməlšan d-wi təjrăw tašăkărkărăt d-inəbdan, izizuy-tăn iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dăɣ-asikəl-net, təlkam-as tamətte tăjjeet han ăddinăt dd-falnen teje ta n-Galila d-tidbi ti n-mărawăt; iyyăḍ, Yărussălam d-Ălyăhudəyăt d-illa-hin i-Ɣurdəni sihen ad-dd-falăn. ");
INSERT INTO taq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Inhăy Ɣisa əjut n-tamətte ta has-təlkămăt ɣas, iwwăn taḍaɣt tiyyăt, ăqqima, əkkăn-t-dd inəṭṭulab-net, ăqqimăn edes-has; ");
INSERT INTO taq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","iḍkăl măjrăd, ad-tăn-isaɣra, ijannʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Tənḍəḍ i-wi ăẓoẓnen iman-năsăn dat-Măssinăɣ ed Təmmənəya n-Măssinăɣ ti-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tənḍəḍ i-wi ăsninnen dăɣ-iman-năsăn ed ad-ismaḍăn ulhawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tənḍəḍ i-wi ăẓednen ha taẓidert ed ad-əkusən ăkall. ");
INSERT INTO taq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tənḍəḍ i-wi inaqq laẓ d-fad n-asətbat n-iqqud ed ad-ăyyăwănăn dăɣ-a-wa s-tammăɣăn. ");
INSERT INTO taq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tənḍəḍ i-wi s-ha tăhanint ulhawăn-năsăn ed ad-hasăn-aḍən Măssinăɣ tăhanint. ");
INSERT INTO taq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tənḍəḍ i-wi s-šăddijăn ulhawăn-năsăn ed ad-ənhəyăn Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tənḍəḍ i-wi n-kăl-ălɣafyăt ed ad-tăn-iwăr isəm: dăgg-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tənḍəḍ i-wi tamăḍraynen dăɣ-təssəba n-iqqud-năsăn dăɣ-erhet n-Măssinăɣ ed Təmmənəya n-Măssinăɣ, ti-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tənḍəḍ-awăn e-d kăwăn-gaggărăn ăddinăt, tiɣəzzəbun-kăwăn, jannen fălla-wăn s-bahu e d t-illăm a lăbasăn dăɣ-ăddimmăt-in. ");
INSERT INTO taq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dăwătăt, talwəm dăɣ-iman-năwăn ed ad-ijat marušăt-năwăn dăɣ-ălžănnăt, ălɣizabăt-wen-dăɣ kăwăn-săknen ăddinăt ašăl-i-dăɣ, a əssəknăn i-ănnăbităn wi hawăn-dd-ăzzarnen.» ");
INSERT INTO taq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Kăwăneḍ a-s tesəmt n-ăddunya măšan, tesəmt, afăl tăt-təjmăḍ temḍe-net, ma s-tăt-e-isəsməm ăwadəm? Ad-ăbas t-illa a tənfa ar ad-hin-tăḍf, əfkəlfəkəlăn-tăt ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kăwăneḍ a-s ănnur n-ăddunya. Aɣrəm ya iwarăn afălla n-aḍaɣ wăr mad-iffăr; ");
INSERT INTO taq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ăddinăt, wăr sărmisăn tefătelt təzzar, əjən-tăt daw-ăkoss, ănn-ak, ăsaḍəf ăsikakăn a făll-tăt-e-siləyăn i-ad-ăsimălăwlăw ănnur-net ehăn d-a-wa t-ihăn iket-net. ");
INSERT INTO taq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","A-wen-dăɣ a făl, imləwləwet ănnur-năwăn kăwăneḍ-dăɣ, s-əmmək-en-dăɣ, dat-ăddinăt i-ad-ənhəyăn imărkedăn-năwăn, səmɣărăn Abba-năwăn-i ihăn išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Innʼ-asăn Ɣisa daɣ: «Wăr teɣalăt năkk, oseɣ-dd i-ad-hin-əkkəsăɣ a-wa innă alămăr wa n-ănnăbi Mosa d-a-wa ənnăn ănnăbităn wi iyyăḍnen, asətbat-net a-s dd-oseɣ wădden anăxas-net. ");
INSERT INTO taq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ăsidătteɣ-awăn a-s ad-iba išənnawăn d-ăkall, wăr-ăba wăla-dăɣ tahnəqqet wăla tătbăqqet tiyyăt ɣas dăɣ-alămăr n-Măssinăɣ a ikkăs wăr-itbet a-wa dăɣ-s ătwănnăn iket-net. ");
INSERT INTO taq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A-wen-dăɣ a făl ere ănmăšrăyăn i-alămăr wa dăɣ-săn ojărăn təmməḍrit, meɣ ittăr ad-išənnəməšrəy ăwadəm iyyăn s-a-wen-dăɣ, ăwadəm-en, ənta a madăn-umas wa ojărăn iba n-təfărre dăɣ-Təmmənəya n-Măssinăɣ măšan, ere itamašalăn a-wa innă alămăr, isalmad ăddinăt a-wa inna i-ad-t-ămašălăn əntăneḍ-dăɣ, ăwadəm-en, ad-umas ămizăr dăɣ-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ǝkkasăɣ-kăwăn dăɣ-taɣdărt n-a-s afăl wăr-ojer iqqud-năwăn wa n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, xăram-awăn ujəš n-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Wădden, təslam a-s imɣarăn-năwăn wi n-ibda, ătwănnʼ-asăn, inna Măssinăɣ: ‹Wăr jed iman ed ere ijăn iman dăɣ, iwăr-t uḍlem dat-Măssinăɣ›, ");
INSERT INTO taq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","măšan năkk, ənneɣ-awăn a-s: ere ijjăš aḍkăr făll-ăŋŋa-s dăɣ, iwar-t uḍlem, ere innăn i-ăŋŋa-s: ‹Amăros›, ăniihăjja s-ad-ămawăy s-ăššăreɣa wa măqqărăn s-itawănna Sinhidrin i-ad-itwəšrăɣ; ere daɣ innăn i-ăŋŋa-s: ‹Təkšăfăd›, ăniihăjja d-ad-t-ăkš efew wa n-žohănnăma. ");
INSERT INTO taq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Afăl təkked ehăn n-ămudd wa măqqărăn, tăwwayăd takute-năk, afăl ălwăqq wa d-sănsed tăkute-năk făll-tasəskărt ta n-tikutawen har dd-təkted a-s ikka hărăt jere-k d-ăŋŋa-k, ");
INSERT INTO taq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wăr ketăd, ăyyʼ-et dədi-dăɣ, əqqəl ăŋŋa-k har hak-ănš təzzar, təjəd takute-năk i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kunta irwas-kăy ăwadəm, iškʼ-ak s-əlxəkum, ufʼ-ak ad-dăr-s tənməknăd šik iket-di d-hin-tiwəḍăm əlxəkum ed əlxəkum, afăl t-in-tăwwăḍăm, ad-kăy-ăj ere wa kăy-ăsiwărăn uḍlem dăɣ-ifassăn n-ăgg-ăššăreɣa, ăjʼ-ik ăgg-ăššăreɣa dăɣ-ifassăn n-ălgomi, ăjʼ-ik ălgomi dăɣ-takărmut. ");
INSERT INTO taq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ăsidătteɣ-ak a-s edăgg-en, afăl t-təjjăšăd, wăr t-dd-mad-təzjărăd a təkked wăr dd-təssəmdăd timẓal n-har tămma ta kăy-irwăs.» ");
INSERT INTO taq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Wădden, təslam a-s ătiwănna: ‹Wăr jed əzzəna›, ");
INSERT INTO taq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","năkk ənneɣ-awăn a-s ere ijăn dăɣ-tamăḍt wăr-ădobăn akăyad n-derhan, isălan əmdăn, iznʼ-et dăɣ-ulh-net. ");
INSERT INTO taq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kăyy, kunta tiṭṭ-năk ta n-aɣil a kăy-isifun abăkkaḍ, kukkərət-tăt-dd, təjrəd-tăt-in fălla-k hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ, ed ufʼ-ak, iji n-tiṭṭ təjjəšăd ălžănnăt, uhən tətwəjărăd-in dăɣ-temse təmda taɣəssa-năk. ");
INSERT INTO taq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kunta daɣ ăfuss-năk wa n-aɣil a kăy-isifun abăkkaḍ, ənkəḍ-t, təjrəd-t-in fălla-k hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ, ed ufʼ-ak, iji n-ăfuss təjjəšăd ălžănnăt, uhən təjjăšăd temse təmda taɣəssa-năk.» ");
INSERT INTO taq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Təssanăm a-s ătwănnă: ‹Ere irhăn azəmməzzi n-hănne-s, ăkfʼ-et-tăt tăkarḍe n-aməzzi təzzar› ");
INSERT INTO taq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","măšan, năkk, ənneɣ-awăn: ere ăzmăzzăyăn hănne-s s-wădden arămas a tăt-ija tikər-as, ijʼ-et temăznit; ere daɣ wa ădobănăn tamăḍt dd-tămmiizzăyăt, izna.» ");
INSERT INTO taq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ḍarăt-a-wen-dăɣ, innʼ-asăn: «Təslam a-s ătiwănna i-imɣarăn-năwăn wi n-ibda: ‹Wăr mad-tărẓəd tafləst, a-wa hăḍăd s-Măssinăɣ s-ad-t-tăjəd, ăjʼ-e›, ");
INSERT INTO taq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","măšan, năkk, ənneɣ-awăn: wăr heḍăm făw. Wăr heḍăm s-išənnawăn ed əntăneḍ a-s tasăqqaymut n-təmmənukəla n-Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wăla s-ăkall ed ənta a-s isəkkukal n-iḍarăn-net wăla s-Yărussălam ed ənta a-s aɣrəm wa n-Măssinăɣ-i n-ămănokal măqqărăn, ");
INSERT INTO taq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","wăla făll-eɣăf-năk ed wăr tăddobed ad-səmləlăd wăla ad-səkwəlăd wăla-dăɣ iyyăn ɣas dăɣ-amẓadăn-năk. ");
INSERT INTO taq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E-d kăwăn-issəstăn ăwadəm d-hărăt, ănnăt-as: ‹Ǝyya› i-tidət, tənnəm: ‹Ăbo› i-bahu, a tăssewăḍăm făll-a-wen-dăɣ, Iblis a dd-ifal.» ");
INSERT INTO taq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Innʼ-asăn daɣ: «Təslam a-s ătiwănna: ‹Tiṭṭ a təẓẓalăt tiṭṭ, esen a itəẓẓalăn esen›, ");
INSERT INTO taq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","măšan, năkk, ənneɣ-awăn: əlɣənăt i-ere hawăn-irhan a lăbasăn; afăl hak-istăɣ ăwadəm făll-tăjomăst-năk ta n-aɣil, səgdəl-as daɣ ta iyyăḍăt. ");
INSERT INTO taq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Afăl hak-iška ăwadəm s-əlxəkum dăɣ-təssəba n-tanăkăbbat-năk, ăyy-as-in daɣ anăkăbba-năk i-ad-wăr-ija a-wen, ");
INSERT INTO taq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","afăl kăy-ăšhăššăl ăgg-əlxəkum aḍkul n-ăẓuk har əḍḍəkuḍ n-kelumetăr, awəy-as-t har əssin kelumetărăn; ");
INSERT INTO taq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ere kăy-idălăn, təkfəd-t, wăr tənneḍăd făll-ere dăɣ-k ittarăn ămarwas.» ");
INSERT INTO taq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Təslam a-s ătiwănna: ‹Ărh ănhăraj-năk, təknəsăd ašănjo-năk› ");
INSERT INTO taq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","măšan, năkk, ənneɣ-awăn: ărhăt išənja-năwăn. Ăjăt ălhimmăt i-wi hawăn-tajjănen terk tittar, ăjăt a olaɣăn i-wi dăr-wăn okăḍnen, ădəlăt Măssinăɣ i-wi kăwăn-samăḍraynen, tiɣəzzəbun-kăwăn. ");
INSERT INTO taq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dihen, ad-itbət a-s aratăn n-Abba-năwăn-i ihăn išənnawăn a tămoosăm; ənta, isajmaḍ-dd tăfukt-net făll-ăddinăt wi lăbasnen hakd wi olăɣnen, isasaway-dd akăsa-net făll-imaɣdalăn hakd inămăšrayăn. ");
INSERT INTO taq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Afăl wăr tărhem ar imărhan-năwăn, ma kăwăn-ibḍan d-ăddinăt wi iyyăḍnen, əndek marušăt-năwăn? Inarmasăn n-tiwse-dăɣ, a-wen, tajjăn-t. ");
INSERT INTO taq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Afăl wăr təjjəm isofan ar i-ayətma-wăn, ma kăwăn-iẓlayăn d-ăddinăt wi iyyăḍnen? Wădden inəẓẓulam-dăɣ, a-wen, tajjăn-t. ");
INSERT INTO taq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Umasăt ăddinăt əmdanen, wăr iwer ălɣib ed Abba-năwăn-i ihăn išənnawăn, imda, wăr t-illa ălɣib t-iwarăn.» ");
INSERT INTO taq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ăjăt ənniyăt, wăr-itumaset iqqud-năwăn i-Măssinăɣ a jam i-ad-kăwăn-in-əjrăhăn ăddinăt ed afăl a-wen-dăɣ a tajjăm, wăr mad-təkrəšăm marušăt ɣur-Măssinăɣ-i n-Abba-năwăn ihăn išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","E-d təkkatăd, wăr wetăd tăsinsăɣt data-k šund a-wa tăjjăn ălmunafeɣăn dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud d-tišarriten i-ad-tăn-aməlăn ăddinăt; ăsidătteɣ-awăn a-s marušăt-năsăn, imdă-dd ɣur-təmmal-ten-dăɣ tăn-tăjjăn ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A ăniihăjjăn a-s, kăyy, e-d təkkatăd, ăjʼ-e dăɣ-ufăr, wăr-ilămmădet wăla-dăɣ ăfuss-năk wa n-tăšalje a-wa ikfa wa n-aɣil, ");
INSERT INTO taq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","dihen, ad-tumas takute-năk a iṣtarăn, ăkfʼ-ik Măssinăɣ-i n-Abba-năk ihannăyăn wăla a-wa iṣtarăn, timẓal n-emărked-năk.» ");
INSERT INTO taq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«E-d təddalăm Măssinăɣ, wăr tolehăm d-ălmunafeɣăn-i s-e-d tumadăn, təjraẓ-asăn tebădde dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud d-ammas n-tišarriten i-ad-tăn-in-əjrăhăn ăddinăt. Ăsidătteɣ-awăn a-s marušăt-năsăn, imdă-dd ɣur-təmmal-ten-dăɣ tăn-tăjjăn ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kăyy, e-d təddalăd Măssinăɣ, əjjəš ider n-ehăn-năk, təɣfəlăd-t-dd făll-iman-năk, tədləd Abba-năk-i ăttunkălăn ed Abba-năk-i ihannăyăn wăla a-wa ijăn dăɣ-atunkəl, ad-hak-ăj erhet-năk. ");
INSERT INTO taq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","E-d təddalăd Măssinăɣ, wăr tăsjătăd măjrăd wărăn infa hărăt šund a-wa tăjjăn inəẓẓulam -i ɣur-ija a-s asjət n-măjrăd-en-dăɣ a dd-madăn-isəmmənənnăḍ ăfuss n-Măssinăɣ, ăkfʼ-en a-wa dăɣ-s əttărăn. ");
INSERT INTO taq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wăr dăr-săn tolehăm, a-wa s-tămiɣatărăm, issan-t Abba-năwăn iket-net hărwa wăr dăɣ-s t-tətterăm.» ");
INSERT INTO taq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«E-d təddalăm Măssinăɣ, ănnăt: ‹Abba-nănăɣ-i ihăn išənnawăn, ");
INSERT INTO taq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","səmɣărnet ăddinăt isəm-năk wa šăddijăn. Taset-dd Təmmənəya-năk, ăjet erhet-năk făll-ărori n-ăkall, s-əmmək wa s-ija dăɣ-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ăkfʼ-anăɣ isudar wi s-nămiɣatăr ašăl-i-dăɣ, ");
INSERT INTO taq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ănš-anăɣ uḍlemăn-nănăɣ s-əmmək wa s-nənašš i-inaḍlamăn-nănăɣ. ");
INSERT INTO taq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wăr toyyed Iblis ăžžurrăbăt-anăɣ isiḍəw-anăɣ dăɣ-abăkkaḍ, agəẓ-anăɣ dăɣ-s, ed Təmmənəya, tărna hakd ălxurmăt, i-năk hărkuk. Amin!› ");
INSERT INTO taq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Afăl naššăm i-ăddinăt wi kăwăn-ḍallămnen, ad-hawăn-in-ănš daɣ Abba-năwăn-i ihăn išənnawăn, ");
INSERT INTO taq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","măšan afăl wăr nəššəm i-ăddinăt wi kăwăn-ḍallămnen, wăr hawăn-in-e-ănš daɣ Măssinăɣ-i n-Abba-năwăn ibăkkaḍăn-năwăn.» ");
INSERT INTO taq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ašăl wa d-tuẓamăm i-ad-tăɣbədăm Măssinăɣ, wăr tăsbănẓăẓăm šund a-wa tăjjăn ălmunafeɣăn-i sawărnen tekenẓart idmawăn-năsăn i-ad-səlmədăn ăddinăt a-s ăẓumăn; ăsidătteɣ-awăn a-s marušăt-năsăn, imdă-dd ɣur-təmmal-ten-dăɣ tăn-tăjjăn ăddinăt, ");
INSERT INTO taq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ănn-ak, kăyy, e-d tăẓumăd, ərdəb-in, sănɣəlăd aḍutăn ");
INSERT INTO taq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","i-ad-wăr-iləmməd ăwadəm a-s tăẓumăd i-ad-tăɣbədăd Măssinăɣ ed igdăh-ak a-wa dăɣ s-Abba-năk-i ăttunkălăn, ihannăy a-wa ijăn dăɣ-atunkəl, ad-hak-ăj erhet-năk.» ");
INSERT INTO taq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Wăr təjmerăm ărrəzăɣ i-ăddunya ed tăddoobăt tukmadt d-tenekt ad-t-tăkš, ăddooben daɣ imăkrăḍăn ad-t-akrən. ");
INSERT INTO taq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ănn-ak, a-wa jammărăd, əjmăr-t i-ălžănnăt-i wăr ha tukmadt wăla tenekt wăla imăkrăḍăn t-ărẓănen wăla-i t-okărnen. ");
INSERT INTO taq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ădduuttăt a-s inəzjam n-ulh n-ăwadəm, wăr təffilăn edăgg wa dăɣ-itwăr təla-net.» ");
INSERT INTO taq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Tiṭṭ n-ăgg-adəm a-s tefătelt n-taɣəssa-net, afăl tolaɣ tiṭṭ-năk, ad-hannăy taɣəssa-năk iket-net, ");
INSERT INTO taq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","măšan afăl ijraw hărăt tiṭṭawen-năk, adiš taɣəssa-năk daɣ, wăr hənnəy hărăt. Ɣas kunta kăyy ănnur wa hak-ămoosnăt tiṭṭawen-năk, iha tihay, adiš tidət-dăɣ a-s, ad-kăy-ărməsnăt tihay ăssuksăḍnen.» ");
INSERT INTO taq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Wăr t-illa ăwadəm ăddooben ad-ixdam i-əssin imălan: iyyăt-i-dăɣ, ad-akəḍ d-iyyăn, ărh wa iyyăḍăn meɣ daɣ ikfʼ-iman-net i-iyyăn, iksən wa iyyăḍăn. Wăr-ăddoobăt ăwadəm ad-ixdam i-Măssinăɣ, ošal daɣ ḍarăt terše n-aẓrəf. ");
INSERT INTO taq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","A-wen-dăɣ a-făl hawăn-janneɣ: wăr kăwăn-jărrăwnet inəzjam n-a-wa mad-təkšəm d-a-wa mad-təswəm d-a-wa mad-təlsəm; iman-năwăn, ajăn wădden ojărăn tetăte? Ăssexăt n-taɣəssa-năwăn daɣ, wădden ojăr isəlsa? ");
INSERT INTO taq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Səjrăhăt ɣas igḍaḍ-wi əllăynen dăɣ-ălhăwa, wăr tədumun, wăr təjlubun, wăr təggărăn dăɣ-ijăndăn măšan, ăssodăr-tăn Abba-năwăn-i ihăn išənnawăn. Ajăn wădden tufăm-tăn s-a ăjjeen! ");
INSERT INTO taq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ǝndek ɣas dăɣ-wăn wa ăddooben s-inəzjam-net ad-isiwəḍ taɣrəst-net wăla s-a ogdăhăn d-emm n-asənnan? ");
INSERT INTO taq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Adiš, mafăl kăwăn-əjrawăn inəzjam n-a-wa mad-təlsəm? Săɣret-kăwăn tăboyt n-išəkraš hărăt, ənhəywăt-tăt-ak, daggăl, wăr ẓətt, wăr ẓəmməy ");
INSERT INTO taq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","măšan ăsidătteɣ-awăn a-s wăla ămănokal Sulăyman hakd terše-net iket-net, wăr kăla ojăr tăboyt-i-dăɣ asəssihăɣ n-ašăl. ");
INSERT INTO taq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɣas kunta Măssinăɣ isalsa teyəšše n-išəkraš s-ašăl-i-dăɣ təbdaj, ašəkka ad-hin-tiɣar, tărɣ s-əmmək-wen-dăɣ, ăbʼ ăṭṭăma n-ad-wăr hawăn-iẓẓəẓmăy kăwăneḍ? Təmmətkit ija immun-năwăn! ");
INSERT INTO taq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wăr kăwăn-ɣăllăbnet inəzjam har dd-təqqəlăm jannem: ‹Ma mad-năkš? Ma mad-nəsəw? Ma mad-năls?› ");
INSERT INTO taq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Inəzjam šund-win-dăɣ, inəẓẓulam a dăɣ-săn ošalnen, ɣallăbăn-tăn. Kăwăneḍ, Abba-năwăn-i ihăn išənnawăn, wăr t-illa a-s tămiɣatărăm s-wădden, issan-t. ");
INSERT INTO taq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ǝdgəẓăt s-tizarăt dăɣ-umăɣ n-Təmmənəya n-Măssinăɣ d-iqqud dăɣ-isălan-net, dihen, ad-hawăn-in-isiwəḍ Măssinăɣ a-wa iyyăḍăn iket-net. ");
INSERT INTO taq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wăr kăwăn-ɣăllăbnet inəzjam n-ašəkka ed hak ašăl d-a-wa ăwwăy dăɣ-inəzjam, hak ašăl-dăɣ, təgdăh-as tămăɣatert-net.» ");
INSERT INTO taq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Wăr toẓemăm ăwadəm i-ad-wăr kăwăn-itiẓəm ăwadəm ");
INSERT INTO taq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","făl-a-s, a-wa s-toẓămăm ăddinăt wi iyyăḍnen a-s kăwăn-e-aẓəmăn kăwăneḍ-dăɣ; a-wa s-kătăm ăddinăt wi iyyăḍnen a-s kăwăn-e-əkətən əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mafăl hannăyăd teẓewt ta hăt tiṭṭ n-ăŋŋa-k, a-s ija a-wen, wăr hənnəyăd afăɣot wa ihăn tiṭṭ ta-năk? ");
INSERT INTO taq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Meɣ daɣ, əndek əmmək wa s-mad-tənnəd i-ăŋŋa-k: ‹Ăyy-ahi ad-əkkəsăɣ teẓewt dăɣ-tiṭṭ-năk›, a-s ija a-wen, kăyy iman-năk, iha afăɣot tiṭṭ ta-năk. ");
INSERT INTO taq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ălmunafeɣ yaden! Ǝkkəs-in afăɣot wa ihăn tiṭṭ-năk təzzar, dihen, ad-tudabed ahănay, tudabed ukəs n-teẓewt ta hăt tiṭṭ n-ăŋŋa-k. ");
INSERT INTO taq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ǝllan-t ăddinăt-i s-dăɣ-a-wa tăjjăn, wăr-əẓleyăn d-iyyăḍan, wăr tăn-təkfem a šăddijăn ed hălăn ad-kăwăn-dd-əqqəlăn, aḍwən fălla-wăn; iyyăḍ, wăr-əẓleyăn d-əlxənžărăn, wăr daw-săn-in-jerăm tisɣalen-năwăn ed ad-tănăt-əfkəlfəkəlăn.» ");
INSERT INTO taq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ădəlăt Măssinăɣ, ad-kăwăn-ăkf; əmmăɣăt, ad-təjrəwăm; ăɣrăt-t, ad-hawăn-ăkawăn. ");
INSERT INTO taq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ere idălăn, ad-ikrəš, ere immăɣăn ad-ijrəw; ere iɣrăn Măssinăɣ dăɣ-tămăɣatert t-tărmasăt, ad-has-tăt-ikkəs. ");
INSERT INTO taq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ǝndek dăɣ-wăn wa s-e-d dăɣ-s ittăr rure-s tajəlla ad-t-ăkf tăhunt? ");
INSERT INTO taq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Meɣ wa s-e-d t-idăl dăɣ-emăn, ad-t-ăkf taššălt? ");
INSERT INTO taq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɣas, kunta kăwăneḍ-i n-inăllăbăsăn, təssanăm isuf n-a-wa olăɣăn i-aratăn-năwăn, ăbʼ ăṭṭăma n-ad-wăr kăwăn-ikfa Abba-năwăn-i ihăn išənnawăn a-wa ufăn, afăl t-dălăm dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tajjăt i-ăddinăt a-wa s-tărhăm ad-hawăn-t-tajjăn ed a-wen-dăɣ a innă alămăr wa n-ănnăbi Mosa d-ănnăbităn wi iyyăḍnen.» ");
INSERT INTO taq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Ǝjjəšăt tămudre ta n-tidət s-emm wa kărruẓăn făl-a-s illʼ-ee zăbo hărəwăn, olwan, ənta a tilal təššəm n-ăddinăt măšan, ajilal-net, əlhəllak, ");
INSERT INTO taq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","a-s ija a-wen, emm wa kărruẓăn d-zăbo wa sădidăn, wăr-əjjətăn ăddinăt wi săr-s tajjăšnen măšan, tămudre ta n-tidət a-s itiɣəd.» ");
INSERT INTO taq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ăgəẓăt iman-năwăn dăɣ-ănnăbităn wi n-bahu-i s-a-s kăwăn-dd-tisən, jan iman-năsăn ikərwatăn wăr ihʼ ăššar, a-s ija a-wen, tiɣəs ənsaynen a ămoosăn. ");
INSERT INTO taq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wăr hawăn-təmtəllənet, ad-tăn-təzzəyăm s-timašalen-năsăn. Ajăn ewărwăr, itiirəw-dd lăɣnăb? Meɣ ajăn ajărof itiirəw-dd tehăyne? ");
INSERT INTO taq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ahəšk olaɣăn, ad-dd-arəw aratăn olaɣnen măšan erk ahəšk, wăr dd-e-arəw a săl aratăn lăbasnen. ");
INSERT INTO taq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ahəšk olaɣăn, wăr-itirəw aratăn lăbasnen, ahəšk daɣ lăbasăn, wăr-e arəw aratăn olaɣnen. ");
INSERT INTO taq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","E d t-illăm ahəšk wărăn itirəw aratăn ihʼ ălfăyda, ad-hin-ăttănkăḍ, itwəjăr-in dăɣ-efew. ");
INSERT INTO taq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ǝmmək-wen-dăɣ daɣ a-s ănnăbităn wi n-bahu, timašalen-năsăn a-s tăn-e-təzzəyăm.» ");
INSERT INTO taq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Wădden ăddinăt iket-năsăn wi hi-jannănen: ‹Emăli, Emăli›, a he-əjjəšnen Təmmənəya n-Măssinăɣ. Təmmənəya n-Măssinăɣ, wăr tăt-e-ijjəš ar ere wa itamašalăn erhet n-Abba-nin-i ihăn išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ašăl wa ilkămăn, ad-dd-əggədăn ăddinăt ăjjootnen, ənnən-ahi: ‹Emăli, Emăli! Wădden măjrăd wa dăɣ-nălolăy i-ăddinăt, kăyy a t-ijăn dăɣ-imawăn-nănăɣ? Wădden nəkkăs alšinăn dăɣ-ăddinăt s-isəm-năk? Wădden nəja tikunen ăjjootnen s-isəm-năk?› ");
INSERT INTO taq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ăddinăt-en, ašăl-en, ad-hasăn-ănnăɣ s-afălla: ‹Năkk ya wăr kăwăn-əzzeyăɣ, ajəjăt-ahi, inămăšrayăn a tămoosăm.› » ");
INSERT INTO taq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ere islăn i-măjrăd-wa-dăɣ s-iket t-jeɣ, ad-itamašal a-wa ənnəɣ, ad-alăh d-ăhaləs ijrahăn hărăt iɣăšăn ăkall har iwwăḍ tăhunt i-ăssas, idăy fălla-s ehăn-net. ");
INSERT INTO taq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ijʼ akăsa, ărtăynăt timḍəl d-anji făll-ehăn-en măšan, wăr-oḍa ed iday făll-tăhunt. ");
INSERT INTO taq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Măšan wa islăn i-măjrăd-in, ăqqima wăr t-ămešăl, olăh d-ere irmas iba n-tayətte idăyăn ehăn-net dăɣ-tasənjit. ");
INSERT INTO taq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ijʼ akăsa, ărtăynăt timḍəl d-anji făll-ehăn-en, oḍa, ălhahăm-in s-iyyăt.» ");
INSERT INTO taq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iḍăs ălxuṭbăt-wen-dăɣ ija Ɣisa tamətte, əqqălăn-dd ăddinăt ɣas oran imawăn ");
INSERT INTO taq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","făll-əjjăruẓăt-i-dăɣ hasăn-ija a-wa isăɣra ed isaɣrʼ-en s-ălxikmăt n-ere issanăn a-wa iha wădden šund ălɣulam wi n-Ăṭṭăwrăt. ");
INSERT INTO taq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ătrară-dd Ɣisa taḍaɣt ɣas, təlkăm-as tamətte tăjjeet. ");
INSERT INTO taq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dăɣ-a-wen-dăɣ ad-has-dd-ilkăḍ ăhaləs ijraw jəri, irkăɣ data-s, innʼ-as: «Ălɣalim, afăl tărhed a-wen-dăɣ, tăddoobed ad-hi-šəšdəjăd.» ");
INSERT INTO taq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iẓẓăl ăfuss-net, iḍăs-t, innʼ-as: «Ărheeɣ-t, išdaj.» Šăddij dăɣ-jəri ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Innʼ-as Ɣisa ḍarăt-a-wen: «Wăr jed isălan i-ăwadəm wălʼ iyyăn n-a-s năkk a kăy-ăzozăyăn, əgləw, səkən iman-năk i-u-tikutawen, təjəd takute ta s-inna ănnăbi Mosa dăɣ-isălan n-təšədje n-kăl-jəri i-ad-umas a-wen tajuhe i-tamətte n-a-s təzzăyăd.» ");
INSERT INTO taq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ijjăš Ɣisa ḍarăt-a-wen aɣrəm wa n-Qăfărnaxum, ilkăḍ-as kăbtăn iyyăn, ad-t-ilaqqăd, ijannʼ-as: ");
INSERT INTO taq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Ălɣalim, ănaxdim-in insa ɣur-ehăn, təbdan-t tiẓẓurt d-tisnant.» ");
INSERT INTO taq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Innʼ-as Ɣisa: «Ad-t-asăɣ, zuzəyăɣ-t.» ");
INSERT INTO taq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ăwwežăb-as kăbtăn, innʼ-as: «Aha-aha ălɣalim! Wăr-ănhăjjăɣ d-ad-təkkəd ehăn-in, təjjəšăd-t, ănn ɣas tăfert, ad-izzəy ănaxdim-in ");
INSERT INTO taq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","făl-a-s năkk-i-hi, əllan-t imănokalăn daw-t-əlleɣ, leɣ daɣ năkk əssărdusa daw-i t-əllanen; e-d ənneɣ i-iyyăn: ‹Ǝgləw›, ad-igləw; e-d ənnəɣ i-wa iyyăḍăn: ‹Ǝyyăw›, ad-hi-dd-ass. Akli-nin daɣ e-d has-ənneɣ: ‹Ăj a-wa›, ad-t-ăj.» ");
INSERT INTO taq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Islă Ɣisa i-măjrăd-wen-dăɣ ija kăbtăn ɣas, ijrăẓ-as ălxal-net; innăḍ-dd ḍarăt-a-wen s-ăddinăt wi has-əlkamnen, innʼ-asăn: «Ăsidătteɣ-awăn a-s, wăla dăɣ-ăkall wa n-Iṣrayil, wăr kăla ənhăyăɣ ere s-ogdăh immun-net d-wa n-ăhaləs-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ăssiilmădăɣ-kăwăn a-s ilkam ad-dd-asən ăddinăt ăjjootnen, dd-falnen emăynăj d-atăram ənɣəymən d-Ibrahim d-Isxaqq d-Yaqub dăɣ-amăjaru wa madăn-ăj dăɣ-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A-s ijʼ-a-wen, ăddinăt wi s-ăniihăjja a-s əntăneḍ a ănnuflăynen dăɣ-Təmmənəya n-Măssinăɣ, ad-hin-ətwəjărăn dăɣ-tihay ti n-ajăma, ad-hallăn, ẓiməkărkiẓăn isenăn făl tămujriẓt.» ");
INSERT INTO taq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Innă Ɣisa ḍarăt-a-wen i-kăbtăn: «Ǝgləw, ijrăw-ak Măssinăɣ a-wa s-tomănăd.» Izzăy ănaxdim-net ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ifăl Ɣisa dihen, ikkă ehăn wa n-Bəṭrus. A-s hin-iwwăḍ, tənsa taḍăggalt n-Bəṭrus, tărmas-tăt tenăde. ");
INSERT INTO taq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iḍăs afuss-net, tărẓa fălla-s tenăde, təbdăd, tăsmăjarăt-t. ");
INSERT INTO taq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Toḍa tăfukt ɣas, ămewăyăn-dd săr-s iməlšan ăjjootnen, innă tăfert ɣas, əzzayăn; ăzozăy daɣ dihen e d t-illăm ere ărhinăn. ");
INSERT INTO taq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ijă a-wen i-ad-itbət a-wa innă ănnăbi Saya a-s innă: «Iḍkăl fălla-năɣ ălɣibăn-nănăɣ, ăzozăy-anăɣ dăɣ-turhənnawen-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Inhăy Ɣisa aɣliɣəli wa t-dd-ja tamətte s-əjut ɣas, innă i-inəṭṭulab-net, ad-əjləyăn ejănš s-ašrut wa iyyăḍăn. ");
INSERT INTO taq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ilkăḍ-as-dd ălɣalim n-Ăṭṭăwrăt iyyăn, innʼ-as: «Ălɣalim, e-s təkked-dăɣ, əlkamăɣ-ak.» ");
INSERT INTO taq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Innʼ-as Ɣisa: «Ibăggan lan tihaliwen, igḍaḍ lan iskak măšan, Ăgg-ăgg-adəm, wăr ila wăla edăgg dăɣ-issənsă eɣăf-net.» ");
INSERT INTO taq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iggăd-dd ăhaləs iyyăn irhan alkum-has, innʼ-as: «Ălɣalim, ăkfʼ-ahi turhajăt n-ad-ăglăɣ əẓkăɣ abba-nin, əqqəlăɣ-dd, əlkəmăɣ-ak.» ");
INSERT INTO taq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Innʼ-as Ɣisa: «Ǝlkəm-ahi, təyyəd fălla-k inəmmuttan ad-əẓkən inəmmuttan-năsăn.» ");
INSERT INTO taq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ănmăjjaš Ɣisa turăft n-aman d-inəṭṭulab-net ḍarăt-a-wen, ");
INSERT INTO taq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","wăr-ăhojăn a-s aḍu-i-dăɣ ăṣṣoohen-da-dăɣ dd-inkărăn, ad-tibhilbəhilnăt tinăzzămăren i-turăft siha d-siha. A-s ităjj a-wen-dăɣ, Ɣisa ənta, iṭṭas. ");
INSERT INTO taq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ǝssənkărăn-t inəṭṭulab-net dăɣ-eḍəs, ənnăn-as: «Ălɣalim, agəẓ-anăɣ, nəhlăk.» ");
INSERT INTO taq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Inkăr-dd, innʼ-asăn: «Ma kăwăn-ăssirmăɣăn? Təmmətkit ija immun-năwăn!» Ibdăd ălwăqq-wen, ăsmăhăḍ făll-aḍu d-ejănš, sămmeḍ-in a-wen-dăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ǝqqălăn-dd ɣas inəṭṭulab oran imawăn, jannen: «Uwwuww! Wa ăwadəm s-wăla aḍu d-ejănš, sajadăn-as, ma ămoos?» ");
INSERT INTO taq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ăsjăn Ɣisa d-inəṭṭulab-net făll-ašrut n-ejănš wa n-teje ta n-Gadara ɣas, əlkăḍăn-as-dd əssin iməlšan əzzaɣnen tiɣənneren, janen tăllăbăst-ta-dăɣ s-ăbas t-illa ere ihălăn ad-dd-ăj tiṭṭ-ten-dăɣ hăn. ");
INSERT INTO taq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ǝnhăyăn Ɣisa ɣas, ăɣwătten alšinăn, ad-jannen: «Ya Rure-s n-Măssinăɣ, ma dăɣ-năɣ tărhed? Ajăn tissust-nănăɣ a-s dd-tosed iket-di dd-tiwəḍ tăqqăn n-a-wen?» ");
INSERT INTO taq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ḍann tahrut n-əlxənžărăn dăɣ-attayăn n-dihen, ");
INSERT INTO taq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","dălăn alšinăn Ɣisa, ənnăn-as: «Kunta takkăsăd-anăɣ dăɣ-ăkall, suk-anăɣ tahrut ta n-əlxənžărăn.» ");
INSERT INTO taq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Innʼ-asăn: «Ăglăt!» Ǝzjărăn alšinăn meddən-ənnin, əjjăšăn əlxənžărăn, ad-dd-titrəktərikăn, wa-dăɣ n-afălla n-taḍaɣt, tiḍəwăn dăɣ-ejănš, tattăn-tăn aman. ");
INSERT INTO taq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ošălăn imăḍanăn-năsăn s-aɣrəm, jăn isălan n-a-wa ijăn d-a-wa dd-išreyăn făll-iməlšan wi n-əssin i-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A ənḍărrăn, aɣrəm iket-dăɣ-net da-dăɣ dd-izjărăn s-Ɣisa, ənhăyăn-t ăddinăt ɣas, ad-t-təddalăn dăɣ-ad-ifəl ăkall-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ijjăš Ɣisa ḍarăt-a-wen turăft n-aman, ijlăy ejănš s-taɣrəmt ta-net. ");
INSERT INTO taq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Diha-dăɣ hin-əwwăḍăn a-s ăddinăt-da-dăɣ, ămisawăyăn ănabdon insan făll-asəftăɣ. Inhăy Ɣisa immun-năsăn ɣas, innă i-anăbdon: «Alyaḍ-in, wăr təkkesăd ăṭṭăma, ibăkkaḍăn-năk, ătwănšăn-ak.» ");
INSERT INTO taq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Diha-dăɣ d-innă a-wen-dăɣ, a dd-əggădăn ălɣulam n-Ăṭṭăwrăt, ad-jannen dăɣ-iman-năsăn: «Wa ənta, ăskafăr.» ");
INSERT INTO taq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ilmăd Ɣisa ɣur-iman-net a-wa ihăn inəzjam-năsăn, a-wen-dăɣ a făl hasăn-inna: «Ma itajjăn erk ənniyăt-wa-dăɣ dăɣ-ulhawăn-năwăn? ");
INSERT INTO taq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma ojărăn tărăɣse jer-ad-tənnəd i-ăwadəm: ‹Ătwănšăn-ak ibăkkaḍăn-năk›, d-ad-has-tənnəd: ‹Ǝbdəd, ərjəš?› ");
INSERT INTO taq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ašăl-i, ăssiilmădăɣ-kăwăn a-s Ăgg-ăgg-adəm, ijraw făll-ărori n-ăkall turhajăt n-tenăšše n-ibăkkaḍăn.» Innă Ɣisa ḍarăt-a-wen i-anăbdon: «Ǝbdəd, əḍkəl asəftăɣ-năk, əqqəl ehăn-năk.» ");
INSERT INTO taq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ibdăd, iqqăl ehăn-net. ");
INSERT INTO taq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tărmăɣ tamətte ta tənhăyăt a-wa ijăn, ad-tiimələn ăddinăt Măssinăɣ-i ikfăn dăgg-adəm tădabit togdăhăt d-a-wa-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ifăl Ɣisa dihen ḍarăt-a-wen, inhăy ănarmas n-tiwse s-isəm-net Mătti ăqqiima dăɣ-edăgg n-ălxidmăt-net, iɣrʼ-e, innʼ-as: «Ǝlkəm-ahi»; ibdăd Mătti, ilkăm-as. ");
INSERT INTO taq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ăsmăjarăt Mătti Ɣisa s-ehăn-net ḍarăt-a-wen. Itaɣăyma Ɣisa dăɣ-edăgg wa n-imənsiwăn a-s erk ăddinăt han inarmasăn n-tiwse ăjjootnen da-dăɣ, osăn-dd, ănɣăymăn dăr-s ənta d-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ǝnhăyăn-t hărăt dăɣ-kăl-faris t-əllanen dihen ɣas, ənnăn i-inəṭṭulab-net: «Ma isaharăn ălɣalim-năwăn imənsiwăn d-inarmasăn n-tiwse d-erk ăddinăt-wi-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Islʼ-asăn Ɣisa ɣas, innă: «Ăddinăt ăssoxătnen, wăr-ămɣatărăn s-lăxtur; imarhinăn a săr-s ămiɣatărnen.» ");
INSERT INTO taq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Innʼ-asăn daɣ: «Ma ămoos ălmăɣna n-a-wa s-inna Măssinăɣ dăɣ-măjrăd-net: ‹Ojăr a-s ɣur-i la tăhanint idəm uhən tikutawen.› A-wen ălmăɣna-net a-s, năkk, wăr dd-ămešălăɣ s-ăddinăt wi ordănen iman-năsăn iqqud, inăsbăkkaḍăn a-s dd-ămešălăɣ i-ad-tăn-ăɣləsăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Osăn-dd inəṭṭulab n-Exya Ɣisa ḍarăt-a-wen, ənnăn-as: «Mafăl năkkăneḍ d-kăl-faris nətuẓam dehiyyăn, a-s ija a-wen, inəṭṭulab wi-năk, wăr tuẓamăn?» ");
INSERT INTO taq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Issăɣlăy-tăn Ɣisa tangalt dăɣ-hasăn-inna: «Ajăn kăl-tuksest ilzam-tăn ăẓum tăn-ăẓiẓăkănẓărăn a ikka ămaẓlay illʼ-e jere-săn? Ǝlkamăn išilan-wi dăɣ-tăn-mad-ifəl ămaẓlay, dihen, ad-əjrəwăn s-ăẓum. ");
INSERT INTO taq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wăr t-illa ere itəggatăn tikəst i-temălsit wăššărăt s-taswəḍt n-tabdoɣt tăynayăt; afăl ija a-wen, ad-dd-tărkəb taswəḍt ta tăynayăt temălsit, tăj amənd ojărăn wənnin. ");
INSERT INTO taq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ăddinăt, wăr təjjən aman n-lăɣnăb ăynaynen, ăxxiimmărnen dăɣ-ijdad; ere ijăn a-wen har kăfăn aman-ənnin dăɣ-ijdad, ad-has-səbbuqqen ijdad-net, ifut dăɣ-lăɣnăb hakd-dăɣ dăɣ-ijdad. Aman n-lăɣnăb ăynaynen, ăxxiimmărnen, iddidăn ăynaynen a dăɣ-tăn-itajj ăwadəm, dihen, wăr-e ifut măssi-săn dăɣ-wi wăla wi.» ");
INSERT INTO taq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ămmiijrăd Ɣisa i-tamətte dăɣ-isălan-win-dăɣ a-s a ənḍărrăn-dăɣ, iyyăn dăɣ-imănnăhăḍăn n-taɣrəmt-en-dăɣ da-dăɣ t-dd-osăn, irkăɣ data-s, innʼ-as: «Talyaḍt-in, iket tăt-ăba măšan nidawet săr-s, sənsəd fălla-s ăfuss-năk, ad-dd-təddăr.» ");
INSERT INTO taq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ibdăd Ɣisa, ăddew dăr-s ənta d-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Igla har šik-dăɣ tamăḍt tiyyăt lat măraw iwətyan d-əssin ijammăḍ-tăt ašni da-dăɣ dd-mălăt ḍara-s, ḍăs afăr n-erăswăy-net ");
INSERT INTO taq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ed a-s tăjj a-wen-dăɣ, janna dăɣ-iman-net: «Afăl ḍăsăɣ wăla-dăɣ erăswăy-net, ad-əzzəyăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Innăḍ-dd săr-s Ɣisa, inhăy-tăt, innʼ-as: «Talyaḍt-in, wăr təkkesăd ăṭṭăma, ăzozăy-kăm immun-năm.» Təzzăy tamăḍt ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","A-s hin-iwwăḍ Ɣisa d-inəṭṭulab-net ehăn n-emănnăhăḍ, inhăy imăwatăn n-tiɣnab ti n-uḍəf n-iba d-ăddinăt wi hasăn-hallănen, ăsikălăl a-wen-dăɣ iket-net, ja tăkat dăɣ-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Omăr s-ad-əzjărăn ăddinăt fălla-s ed innʼ-asăn: «Tarat, wăr tăt-ăba, eḍəs ɣas a ja.» Jăn-t tekăškăšt. ");
INSERT INTO taq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Təzjăr fălla-s tamətte ɣas, ijjăš ehăn wa dăɣ-tənsa talyaḍt, irmăs-tăt-dd s-ăfuss, tənkăr-dd. ");
INSERT INTO taq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ǝntăjăn isălan n-a-wen-dăɣ dăɣ-teje-ten-dăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ašăl iyyăn, irjaš Ɣisa a-s t-ăɣrăn əssin iməddorɣal, ăsiɣăren, jannen-as: «Ya Ăgg-Dawəd, aḍən-anăɣ tăhanint!» ");
INSERT INTO taq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iwwăḍ-in Ɣisa ehăn wa ikka, əjjăšăn-t-dd fălla-s iməddorɣal ənnin n-əssin ɣas, innʼ-asăn: «Ak tidət-dăɣ a-s təflasăm a-s ăddobeɣ ad-arăɣ tiṭṭawen-năwăn?» Ǝnnăn-as: «Ălɣalim, nəflas a-wen.» ");
INSERT INTO taq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iḍăs Ɣisa tiṭṭawen-năsăn, innʼ-asăn: «Itwəjjet-awăn a-wa dăr-ogdăh immun-năwăn.» ");
INSERT INTO taq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ămerănăt tiṭṭawen-năsăn măšan, ikna asəmmăhəḍ dăɣ-săn, innʼ-asăn: «He kăwăneḍ! Wăr jem isălan n-a-wa ijăn dăɣ-ăwadəm wălʼ iyyăn», ");
INSERT INTO taq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","măšan, əzjărăn ehăn fălla-s ɣas, əffăyăn isălan dăɣ-ăkall iket-net. ");
INSERT INTO taq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Diha-dăɣ d-əglăn iməddorɣal, a-s amălšon iyyăn s-ikras alšin wa t-ihăn iləs-net da-dăɣ săr-s dd-ăwwăyăn ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ikkăs dăɣ-s Ɣisa alšin wa t-ihăn, ad-itamăjrad. Təqqăl-dd tamətte ɣas torʼ emm, janna: «Wăr kăla ătwănhăy šund a-wa-dăɣ dăɣ-ăkall wa n-Iṣrayil.» ");
INSERT INTO taq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Măšan, kăl-faris əntăneḍ a jannen: «A-wa tărna n-Iblis-i n-ămănokal n-alšinăn a-s itakkăs alšinăn dăɣ-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ăllil Ɣisa ḍarăt-a-wen iɣărman d-tidbi iket-năsnăt, isaɣra dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, ixaṭṭăb Ălənžil wa n-Təmmənəya n-Măssinăɣ, izizuy ăddinăt dăɣ-turhənnawen d-ălɣibăn. ");
INSERT INTO taq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Inhăy Ɣisa tamətte ta tăjjet has-təlkămăt ɣas, tănɣʼ-e tăhanint-net; inhăy fălla-săn aləḍḍeš d-ezărri, olăhăn-as ɣas d-tihatten wăren la amăḍan. ");
INSERT INTO taq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Innăḍ-dd s-inəṭṭulab-net, innʼ-asăn: «Ašəkrəš ăggolăt, əttăɣam ijjət măšan, wăr-əjjətăn inaxdimăn t-olăynen. ");
INSERT INTO taq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ădəlăt măssi-s n-ašəkrəš i-ad-dd-išəmmišəl inaxdimăn olăynen ašəkrəš-net.» ");
INSERT INTO taq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iɣră-dd Ɣisa ḍarăt-a-wen inəṭṭulab-net wi n-măraw d-əssin, ikfʼ-en tărna n-ukəs n-alšinăn dăɣ-ăddinăt d-azuzi n-ăddinăt dăɣ-turhənnawen d-ălɣibăn. ");
INSERT INTO taq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ismawăn n-inəṭṭulab wi n-măraw d-əssin ăsnăfrăn da: Simyon wa s-itawănna Bəṭrus d-ăŋŋa-s Idris; Yaqub wa n-ăgg Zăbdi d-ăŋŋa-s Exya; ");
INSERT INTO taq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fəlibb d-Bărtălămma; Tomi d-Mătti wa n-ănarmas n-tiwse; Yăqub ăgg Ălfa d-Tade; ");
INSERT INTO taq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simyon wa n-Kăna d-Yăhudəs wa n-Isxaryut-i t-e-isəssăɣdărăn. ");
INSERT INTO taq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ǝntăneḍ-den-dăɣ inəṭṭulab wi n-măraw d-əssin ăšmašăl Ɣisa s-innă: «Wăr təkkem tiwsaten ti n-inəẓẓulam, wăr təjješăm aɣrəm n-kăl-Sămari; ");
INSERT INTO taq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","wăr təkkem ar tamətte ta n-kăl-Iṣrayil tăssujjălăt šund tihatten. ");
INSERT INTO taq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dăɣ-tekle-năwăn, ăxṭəbăt i-ăddinăt a-s Təmmənəya n-Măssinăɣ, tohăẓ-dd. ");
INSERT INTO taq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zuzəyăt imarhinăn, sənkărăm-dd inəmmuttan, šəšdəjăm ăddinăt wi ijrăw jəri, təkkəsăm alšinăn dăɣ-iməlšan; ănnuɣmăt n-Măssinăɣ wa təjrăwăm bănnan, ăkfăt-t i-ăddinăt bănnan. ");
INSERT INTO taq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wăr tiwəyăt orăɣ, wăla aẓrəf, wăla totəyya dăɣ-fărtəmatăn-năwăn, ");
INSERT INTO taq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","wăr tiwəyăt šăkkoš, wăla anăkăbba săl wa təlsăm, wăla tifădelen săl ti sălăm, wăla tăborit ed, wăr t-ihʼ ăššăk a-wen, hak ănaxdim-dăɣ, ărhuj-as ălxaqq n-tide-net. ");
INSERT INTO taq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aɣrəm d-tadăbayt təjjăšăm-dăɣ, səstənăt d-ere wa s-ăniihăjja ad-ɣur-s təzzubbem, təzzubbem ɣur-s har ašăl wa d-tăssawăḍăm tekle. ");
INSERT INTO taq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ehăn təjjăšăm-dăɣ, ăjrăt fălla-s ăssălam; ");
INSERT INTO taq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","afăl kăwăn-ăsbărrăkăn məssaw-s, sănsăt fălla-săn ălxer wa tăwwayăm; kunta daɣ wăr kăwăn-ăsbărrăkăn məssaw-s, ăglăt d-ălxer-năwăn. ");
INSERT INTO taq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ehăn, wăla aɣrəm, tosăm-dăɣ, har wăr kăwăn-ăsbărrăkăn məssaw-s, meɣ unjăyăn s-asjəd i-măjrăd-năwăn, əzjărăt-t, tăbbăkbăkăm iḍarăn-năwăn i-ad-wăr kăwăn-iləttăɣ wăla ăboqqal-net. ");
INSERT INTO taq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ăsidătteɣ-awăn a-s ehăn-en-dăɣ, meɣ aɣrəm-en-dăɣ, ašăl wa ilkămăn, tojăr tisnant ta t-madăt-tărməs ta tărmăsăt iɣărman wi n-Sodoma d-Gomora.» ");
INSERT INTO taq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Innʼ-asăn daɣ: «Ǝnhəywăt, năkk da-dăɣ kăwăn-ăšimašălăn i-ad-talăhăm d-tihatten əllanen jer-tiɣəs; udaɣăt i-iman-năwăn šund taššălen, ijjəšet-kăwăn ălɣafyăt wa ihăn tidăberen. ");
INSERT INTO taq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Agəẓăt iman-năwăn dăɣ-dăgg-adəm; ad-kăwăn-əjən dăɣ-ifassăn n-əlxəkum, əjən dăɣ-wăn tiwit dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dăɣ-təssəba n-isəm-in wa kăwăn-iwarăn, ad-hawăn-aškən ăddinăt s-gəfărăn d-imănokalăn, tăttărmăsăm-dd săr-săn, măšan ad-umas a-wen əssəbab făl tămoosăm tijuhawen-in, təjəm isălan-in i-tiwsaten ti n-inəẓẓulam. ");
INSERT INTO taq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Afăl təttărmăsăm, wăr tăšăwwašăt dăɣ-isălan n-a-wa mad-tənnəm d-əmmək wa s-tăn mad-tənnəm, ed afăl tăbokăm i-măjrăd, ad-kăwăn-itwəkf a-wa mad-tənnəm, ");
INSERT INTO taq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","făl-a-s wădden kăwăneḍ a maden-ămmăjrăd, Unfas wa n-Abba-năwăn a madăn-ămmăjrăd dăɣ-idăggan-năwăn. ");
INSERT INTO taq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ad-isəttărməs ăwadəm ăŋŋa-s i-ad-ămmăt, isəttărməs abba rure-s i-ad-ămmăt, ănnăbdădăn aratăn d-imărawăn-năsăn, əjən iman n-imărawăn-năsăn; ");
INSERT INTO taq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ad-dăr-wăn akəḍăn ăddinăt iket-năsăn dăɣ-ăddimmăt n-isəm-in wa kăwăn-iwarăn măšan ere ibdădăn s-ăṣṣahăt dăɣ-immun-net, ad-iɣləs. ");
INSERT INTO taq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Afăl kăwăn-ăqquzzăben ăddinăt dăɣ-aɣrəm iyyăn, jawăḍăt-asăn s-iyyăn; ăsidătteɣ-awăn a-s, a-s dd-e-săɣləyăm iɣărman n-Iṣrayil iket-năsăn, iqqal-dd Ăgg-ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Wăr t-illa ănăṭṭalib ufan ălɣalim-net wăla akli ufan măssi-s, ");
INSERT INTO taq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","igdăh ɣas i-ănăṭṭalib, ad-ăttiilăl ălɣalim-net, ăttiilăl daɣ akli măssi-s. Kunta ăddinăt wăla măssi-s n-ehăn, jăn-as isəm Abălzăbil, a-wen Iblis, ăbʼ ăṭṭăma n-a-wa he-ənnən făll-inalkimăn-net; ad-fălla-săn ənnən a ojărăn a-wa ənnăn făll-măssi-s n-ehăn.» ");
INSERT INTO taq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Ǝnneɣ-awăn: Dăgg-adəm, wăr tăn-tăksuḍăm. Wăr t-illa a ăttunkălăn s-wădden ad-dd-infiləl, wăr t-illa a iffarăn s-wădden ad-dd-iffukkăr. ");
INSERT INTO taq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A-wa hawăn-janneɣ dăɣ-takše, ănnăt-t s-afălla dat-ăddinăt iket-năsăn; a-wa hawăn-ăsmătăktăkăɣ, săqqəyyăt-t făll-afălla n-ihănan. ");
INSERT INTO taq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wăr tăksuḍăm dăgg-adəm-i wăren ăddoobăt ar tenăɣe n-taɣəssa, wăr-ăddoben tenăɣe n-iman; ănn-ak, uksaḍăt Wa ăddoben ad-ihlək iman hakd taɣəssa dăɣ-žohănnăma. ");
INSERT INTO taq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ɣur-wăn, wădden igḍaḍ əssin, tămma ɣas a nazzăn? Hakd a-wen-dăɣ, wăr-ilkem ad-dăɣ-săn oḍa iyyăn, a ikkăs Abba-năwăn wăr otes s-a-wen, ");
INSERT INTO taq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","wăla amẓadăn n-iɣăfawăn-năwăn, ăḍḍinăn. ");
INSERT INTO taq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wăr tărmeɣăm, tojărăm abrək n-igḍaḍ ălqim.» ");
INSERT INTO taq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ere ăsjăyhăn dăgg-adəm a-s năkk a t-ilăn, ad-səjjəyhăɣ năkk-dăɣ Abba-nin-i ihăn išənnawăn a-s ăwadəm-en, i-nin; ");
INSERT INTO taq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ere daɣ wa hi-ăkkuddălăn dat-dăgg-adəm, ad-t-əkkuddəlăɣ năkk-dăɣ dat-Abba-nin-i ihăn išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Olăs daɣ, innʼ-asăn: «Wăr teɣalăt ălɣafyăt ad-dd-ăwwăyăɣ s-ăkall, tăkoba, wădden ălɣafyăt a săr-s dd-ăwwăyăɣ. ");
INSERT INTO taq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Năkk, oseɣ-dd i-ad-ibḍəw ăhaləs d-ti-s, təbḍəw talyaḍt d-ma-s, təbḍəw tamăḍt d-taḍăggalt-net, ");
INSERT INTO taq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","umasăn kăl-ehăn n-ăwadəm išənja-net. ");
INSERT INTO taq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ere hi-ăssofăn ti-s meɣ ma-s, a-di, wăr-ănhăjja ad-umas ănăṭṭalib-in, ere daɣ wa hi-ăssoofăn rure-s meɣ elle-s, wăr-ănhăjja ad-umas ănăṭṭalib-in. ");
INSERT INTO taq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ere wa wărăn ăsdăw i-aḍkul n-tajəttewt-net ta n-tamăttant, ilkəm-ahi, a-di, wăr-ănhăjja d-ad-umas ănăṭṭalib-in. ");
INSERT INTO taq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ere wa wărăn idgeẓ ar dăɣ-igguẓ n-iman-net dăɣ-ăddunya-ta-dăɣ, ad-ifut dăɣ-ălžănnăt, măšan, wa irḍăn ăfota dăɣ-iman-net dăɣ-ăddunya-ta-dăɣ, dăɣ-ăddimmăt-in, ăwadəm-en, ad-iɣləs dăɣ-ălaxărăt.» ");
INSERT INTO taq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Inna daɣ: «Ere kăwăn-ăsbărrăkăn, năkk a ăsbărrăk, wa hi-ăsbărrăkăn, wa hi-dd-ăsmašălăn a ăsbărrăk. ");
INSERT INTO taq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ere ăsbărrăkăn ănnăbi dăɣ-təssəba n-a-wa s-iqqăl ănnăbi, əlkamăn dăɣ-s imraš šund wi mad-ijrəw ănnăbi; ere ăsbărrăkăn ere oɣadăn dat-Măssinăɣ dăɣ-təssəba n-iqqud-net, ilkam ad-ijrəw imraš šund wi mad-ijrəw ere oɣadăn dat-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ere wa issəswăn wăla-dăɣ alkas n-aman sămmeḍnen i-iyyăn dăɣ-inəṭṭulab dăɣ-təssəba n-a-wa s-ămoos ănăṭṭalib-in, ăsidătteɣ-awăn a-s, wăr t-e-ijmăḍ marušăt n-emărked wa ămešăl.» ");
INSERT INTO taq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Issəmdă Ɣisa asəmmətăr n-inəṭṭulab-net wi n-măraw d-əssin ɣas, ifăl dihen, ad-isaɣra ăddinăt, ixaṭṭăb dăɣ-iɣărman wi n-teje-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iha Exya takărmut a-s islă ijităn n-Ălmasex, ăšmašăl săr-s hărăt dăɣ-inəṭṭulab-net ");
INSERT INTO taq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","i-ad-has-t-dd-səstənăn kunta ənta a-s Wa s-ătwănnă ilkam ad-dd-ass meɣ ilkam ere săl ənta. Osăn-t-dd inəṭṭulab-win-dăɣ, əllăɣen-as a-wa innă Exya. ");
INSERT INTO taq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Ǝqqəlăt Exya, suɣəlăm-as a-wa s-təslăm d-a-wa tənhăyăm; ");
INSERT INTO taq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ănnăt-as: iməddorɣal hannăyăn; inəbdan rajjăšăn, wi ijrăw jəri tišdajăn, imẓaj sallăn; inəmmuttan nakkărăn-dd; tilăqqiwen, sallănăt i-Ălənžil. ");
INSERT INTO taq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tənḍəḍ i-ere wa dăɣ-i wărăn ijʼ ăššăk.» ");
INSERT INTO taq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ǝglăn meddən-winnin dd-ămešălnen ɣas, ădwănnăt Ɣisa i-tamətte dăɣ-isălan n-Exya, innʼ-asăn: «Ak, a-s təzjărăm s-tenere, ma tənhăyăm? Ak teẓewt ăsiwălawăl aḍu a tənhăyăm? Ăbo! ");
INSERT INTO taq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Adiš ma təkkăm i-ad-t-tənhəyăm? Ak ăhaləs ăsisahăɣăn ašăl a tənhăyăm? Ǝnhəywăt-tăn-ak ăddinăt wi sasahaɣnen ašăl, ihănan n-imănokalăn a əzzaɣăn? ");
INSERT INTO taq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Adiš ma təkkăm i-ad-t-tənhəyăm? Ak ănnăbi a tənhăyăm? Tidət lab a-s ănnăbi, ăssiilmădăɣ-kăwăn a-s ere ojărăn tumast n-ănnăbi a tənhăyăm. ");
INSERT INTO taq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ǝnta-en-dăɣ a făl innă əlkəttab n-Măssinăɣ: ‹Ǝnhəy! Ăzizărăɣ-ak anămmašul-in wa he-iknən tabarăt-năk.› ");
INSERT INTO taq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ăsidătteɣ-awăn a-s wăr torew tamăḍt ăhaləs wăr-ojer Exya wa n-Enəsselmăɣ măšan hakd-a-wen-dăɣ, wăr t-illa ere t-wărăn ojer dăɣ-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ɣur-ašăl wa dd-osa Exya har ašăl-i-dăɣ, ija amjăr ăṣṣoohen făll-ujəš n-Təmmənəya n-Măssinăɣ; amjăr-en, wăr dăɣ-s ikărrəš ašăl ar ăddinăt wi əkfărnen ");
INSERT INTO taq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","făl-a-s, ănnăbităn wi dd-ăzzarnen i-Exya iket-năsăn, hakd-dăɣ alămăr wa n-ănnăbi Mosa, ălolăy a-wen-dăɣ iket-net dăɣ-isălan n-Təmmənəya n-Măssinăɣ hundăɣ har ašăl-i-dăɣ n-ăzzăman wa n-Exya wa n-Enəsselmăɣ. ");
INSERT INTO taq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kunta făw ad-tăqbəlăm s-a-wen-dăɣ, ălleɣeɣ-awăn a-s dăɣ-ănnăbităn, ənta a-s ănnăbi Ɣəli wa s-ătwănna ilkam ad-dd-aləs uɣəl. ");
INSERT INTO taq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ămăra, ere ilăn timəẓẓujen s-islă-dăɣ, isăjdet!» ");
INSERT INTO taq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Olăs daɣ Ɣisa, innʼ-asăn: «Ak, mi dăr-mad-sənnəfăqqăɣ əzzurəyyăt ta-dăɣ? Tănifăqqa ɣas d-ălžămaɣăt n-aratăn janen aɣrəf dăɣ-təfărre, jannen iyyăḍ i-wi iyyăḍnen: ");
INSERT INTO taq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Ǝnhəywăt, kăwăneḍ, wăr lem asăfar; nəwăt-awăn taɣănibt, tunjăyăm s-dăllol! Nənẓăr-awăn tiswal n-tisnant măšan, wăr təṭṭefăm iba!› ");
INSERT INTO taq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Exya, ăzzăman wa dd-osa, wăr-itətt imənsiwăn olaɣnen, wăr-isəss aman n-lăɣnăb ăxxiimmărnen, ənnăn fălla-s ăddinăt: ‹Ihʼ-e alšin›, ");
INSERT INTO taq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","išrăy-t-dd Ăgg-ăgg-adəm, ənta itihăr dăr-wăn a-wa tăttăm d-a-wa săssăm, ɣas tənnăm dăɣ-s: ‹Wa ənta, insăy, irăf aman n-lăɣnăb wi ăxxiimmărnen, inarmasăn n-tiwse d-ălfusaɣ wi iyyăḍnen a-s imidiwăn-net.› Ăsidătteɣ-awăn a-s: ‹Sărho wa dd-ifălăn Măssinăɣ, ijităn n-ăwadəm a t-isatbatăn.› » ");
INSERT INTO taq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ăsmăqqa Ɣisa ḍarăt-a-wen făll-iɣărman wi dăɣ-ija tikunen ăjjootnen măšan, ăsɣărăn-as ulhawăn-năsăn, unjăyăn ătubăn. ");
INSERT INTO taq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Innʼ-asăn: «Iməskay kăl-Qorazin d-kăl-Băṭsăyda, ălmăṣṣibăt ɣas a fălla-wăn maden-iḍəw ed ənnăr iɣărman wi n-Tir d-Săyda əzzăɣăn inəẓẓulam a dăɣ-jănăt tikunen-ti-dăɣ jănen ɣur-wăn, ăru d-əlsăn šakutăn, əblənbulun dăɣ-eẓəd făl təmɣăre n-tătubt-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A-wen-dăɣ a fal hawăn-janneɣ a-s ašăl wa ilkămăn, ad-kăwăn ijjəš ăddăyyăt ojărăn wa ijjăšăn iɣărman wi n-Tir d-Săyda. ");
INSERT INTO taq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kăwăneḍ-i-š əzzăɣnen aɣrəm wa n-Qăfărnaxum, ma tăɣelăm? Tordam a-s aɣrəm-năwăn ad-itimɣar har awəḍ išənnawăn? Xăram-awăn! Ănn-ak, ad-təhələm ider, wăr kăwăn-dd-e-tawăɣ a săl temse ed tikunen ti jănen ɣur-wăn, ənnar janăt dăɣ-aɣrəm wa n-Sodoma, ăru d-ătubăn imuzăɣăn-net, ăqqayəm aɣrəm-năsăn iday har ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A-wen-dăɣ a făl hawăn-janneɣ, a-s ašăl wa ilkămăn, ad-kăwăn-ijjəš ăddăyyăt ojărăn wa ijjăšăn aɣrəm wa n-Sodoma.» ");
INSERT INTO taq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iḍkăl Ɣisa măjrăd, innă: «Abba, kăyy-i n-Emăli n-išənnawăn d-ăkall, timəlăɣ-kăy făl-a-s hărătăn-wi-dăɣ, təffărăt-tăn i-iməssorha d-imusănăn n-ăddunya-ta-dăɣ măšan, tăsnăfalălăd-tăn-dd wăla i-aratăn. ");
INSERT INTO taq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tidət Abba, kăyy a tiiməlăɣ ed ădduuttăt a-s ənta-den-dăɣ erhet-năk wa ăhusken.» ");
INSERT INTO taq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Innă Ɣisa i-ăddinăt ḍarăt-a-wen: «Wăr t-illa a-s wădden ijʼ-e Abba-nin dăɣ-ifassăn-in, wăr t-illa ere hi-ijan muzəyăt imdan kunta wădden Abba, wăr t-illa daɣ ere ijan muzəyăt imdan i-Abba kunta wădden năkk-i n-Rure-s-i t-dd-ifălăn d-ere wa s-ărheɣ ad-has-t-zuzəyăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Innʼ-asăn daɣ: «Ǝyyăwăt iket-dăɣ-năwăn kăwăneḍ-i ăsifăgga ăẓuk wa tăllinjem, ad-hawăn-sunfăɣ, ");
INSERT INTO taq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","mašălăt erhet wa-nin, təyyəm-ahi ad-kăwăn-săɣrăɣ ed năkk, ăẓeedăɣ, hahi-taẓidert, wăr hi-iha əkkəbru; ənta-den-dăɣ a-wa hawăn-ha tăsonfat n-iman-năwăn, tăɣləsăm. ");
INSERT INTO taq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","A-wa fălla-wăn ărheɣ, wăr-ăẓẓay, amišəl n-erhet-in daɣ, i făsuusăn.» ");
INSERT INTO taq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ašăl iyyăn n-əssəbət-i n-ašăl wa n-tăsonfat, irăs Ɣisa d-inəṭṭulab-net išəkraš n-ălkăma. Ǝglan dăɣ-a-wen-dăɣ a-s ălluẓăn inəṭṭulab, ad-nakkăḍăn tiɣăɣănen n-ălkăma, taffăẓăn tiblalen-năsnăt. ");
INSERT INTO taq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ǝnhăyăn-tăn hărăt dăɣ-kăl-faris ɣas, ənnăn i-Ɣisa: «Ǝnhəy, ăɣtəl inəṭṭulab-năk ed išlʼ-en a wărăn itətwəjj dăɣ-ašăl wa n-əssəbət-i n-tăsonfat.» ");
INSERT INTO taq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Innʼ-asăn: «Adiš kăwăneḍ wăr tăɣrem dăɣ-əlkəttab a-wa ijʼ ămănokal Dawəd ašăl wa d-ălluẓ ənta d-ejhăn-net? ");
INSERT INTO taq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ătwănnʼ-anăɣ, ijjăš ənta d-ejhăn-net ehăn n-Măssinăɣ, ad-tattăn tijəlwen-ti n-tikutawen s-innă alămăr wa n-ănnăbi Mosa, wăr t-illa ere s-xălal tetăte-năsnăt a săl kăl-tikutawen? Tijəlwen-tin-dăɣ, wăr has-xălalnăt ənta wăla ejhăn-net măšan, ălluẓ ɣas, ikšʼ-enăt ənta d-meddən wi dăr-ăddew. ");
INSERT INTO taq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ajăn wăr tăɣrem dăɣ-alămăr a-s ašăl wa n-əssəbət-i n-tăsonfat, kăl-tikutawen wăr hasăn-ămoos anməšri i-a-wa innă alămăr afăl əxdămăn dăɣ-ehăn n-ămudd wa măqqărăn, ed əjrawăn s-ad-ənməšrəyăn i-fărəḍăn wi ătiwăɣtăsnen i-ašăl wa n-əssəbət-i n-tăsonfat. ");
INSERT INTO taq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ăssiilmădăɣ-kăwăn a-s ehăn n-ămudd wa măqqărăn, illʼ-e jere-wăn ere t-ojărăn. ");
INSERT INTO taq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xăxx, ənnar təssanăm ălmăɣna n-a-wa innă Măssinăɣ a-s innă: ‹Ojăr a-s ɣur-i la tăhanint idəm uhən tikutawen›, iket-di-š, wăr səḍlimăm bănnan inəṭṭulab-wi-dăɣ wăren əɣšed hărăt. ");
INSERT INTO taq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ăgg-ăgg-adəm, a ănnihăḍăn dăɣ-a-wa s-ila ăgg-adəm s-ad-t-ăj d-a-wa s-wăr ila s-ad-t-ăj dăɣ-ašăl wa n-əssəbət-i n-tăsonfat.» ");
INSERT INTO taq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ifăl Ɣisa dihen, ikkʼ ehăn n-ăddin wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Diha-dăɣ d-t-ijjăš a-s ăhaləs iyyăn da-dăɣ s-ăqqur ăfuss-net. Ǝggădăn-dd ăddinăt iyyăḍ s-Ɣisa, ənnăn-as: «Ak xălal meɣ xăram ad-izuzəy ăwadəm iyyăn dăɣ-ašăl wa n-əssəbət-i n-tăsonfat?» Ăsaru ɣas făl t-əssəḍlămăn a-s tammăɣăn. ");
INSERT INTO taq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Ǝndek dăɣ-wăn wa s-afăl toḍa tehăle ta n-iyyăt ila dăɣ-anu dăɣ-ašăl wa n-əssəbət-i n-tăsonfat, ad-dăɣ-s tăt-ăyy har akəy ašăl-en təzzar? ");
INSERT INTO taq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Uhən kăwăneḍ, wăr təjrehăm a-s ăgg-adəm ufa arəzzej s-a ăjjeen? Ăssiilmădăɣ-kăwăn a-s wăr t-illa a ăssixrămăn iji n-a olaɣăn dăɣ-ašăl wa n-əssəbət-i n-tăsonfat.» ");
INSERT INTO taq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Innă Ɣisa ḍarăt-a-wen i-ăhaləs wa s-ăqqur ăfuss-net: «Ǝẓẓəl ăfuss-năk.» Iẓẓăl ăhaləs ăfuss-net, izzăy, olăh ăfuss-net ăssaɣăt-wen-dăɣ d-ăfuss-net wa iyyăḍăn wăr-ijrew hărăt. ");
INSERT INTO taq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ǝzjărăn kăl-faris edăgg-en ɣas, ănmănhăyăn jer-iman-năsăn dăɣ-isălan n-əmmək wa s-mad-əjən iman-net. Ilmăd Ɣisa a-wa lăbasăn has-kittəwăn ɣas, ifăl dihen, iglă. ");
INSERT INTO taq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dăɣ-tekle-net, əlkămăn-as-dd imarhinăn ăjjootnen, ăzozăy-tăn iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hărwa wăr-ifel dihen-dăɣ, ăsmătăr-tăn hullan d-ad-wăr jen isălan n-ere wa ămoos i-ăwadəm wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ămoos a-wen inna a ăssiitbătăn a-wa innă ănnăbi Saya a-s innă, innă Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ǝnta da ănaxdim-in wa ăsnăfrănăɣ, ənta a əkneɣ tărha, ənta a dăɣ-ăsriwăn iman-in. Ad-fălla-s sănsăɣ Unfas-in, isəssiɣəd inəẓẓulam dăɣ-iqqud i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wăr t-mad-ijjəš ăjaḍ, wăr mad-isăqqəy bănnan, wăr t-illa ere has-madăn-isəll ăsiɣăyya dăɣ-tišarriten bănnan. ");
INSERT INTO taq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wăr mad-ărẓ wăla-dăɣ teẓewt a-wa-dăɣ has-ija iba n-ăddăɣwa Wăr mad-isəmməkət wăla-dăɣ tefătelt, ad-isəjăr ăṭṭăma ăddinăt wi əbrărnen, ăj iqqud dăɣ-edăgg iket-net. ");
INSERT INTO taq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Isəm-net a madăn-isəjăr inəẓẓulam ăṭṭăma.» ");
INSERT INTO taq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ăwwăyăn-dd ăddinăt s-Ɣisa ḍarăt-a-wen amălšon ăsidărɣăl alšin wa t-ihăn, ikras daɣ iləs-net; ăzozăy-t, olăs ahănay, ad-itamăjrad. ");
INSERT INTO taq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ǝqqălăn-dd ăddinăt ɣas oran imawăn, ăkuunăn, jannen: «Ămmukkăn ənta-i-dăɣ a-s Ăgg-Dawəd wa s-ătwănna!» ");
INSERT INTO taq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ǝslăn kăl-faris i-a-wen ɣas, ənnăn: «A-wa Abălzăbil, Iblis wa n-ămănokal n-alšinăn a t-ihan; ənta a t-ikfăn tărna ta s-itakkăs alšinăn dăɣ-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ilmăd Ɣisa ɣur-iman-net a-wa zinəzjumăn, innʼ-asăn: «E d t-illăm əddəwəl s-dd-əqqălăn məssaw-s əknasăn jer-iman-năsăn, ad-t-iba, umas timšar; aɣrəm daɣ wăla ehăn wa s-dd-əqqălăn məssaw-s əknasăn jer-iman-năsăn, wăr-e ăhaj ibdad. ");
INSERT INTO taq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Afăl dd-iqqăl Iblis isattăɣ iməššerəkăn-net siha d-siha, iman-net ɣas a iknas; ere iknasăn d-iman-net ya, wăr t-illa əmmək s-ăhoja ibdad. ");
INSERT INTO taq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kunta daɣ tənnăm năkk, tărna n-Abălzăbil wa n-ămănokal n-alšinăn a-s tăn-takkăsăɣ dăɣ-ăddinăt, adiš, inəṭṭulab wi-năwăn, ma ămoos isəm wa s-tăn-takkăsăn dăɣ-ăddinăt? Inəṭṭulab-năwăn-en-dăɣ, a-s ilkam ad-ăjjayhən fălla-wăn, səḍləmăn-kăwăn, ");
INSERT INTO taq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","măšan, kunta năkk, tărna n-Unfas n-Măssinăɣ a-s takkăsăɣ alšinăn dăɣ-ăddinăt, ăniihăjja a-s ăssiilmăd-kăwăn a-wen a-s Təmmənəya n-Măssinăɣ, təllʼ-ee jere-wăn. ");
INSERT INTO taq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wăr t-illa ere ăddooben ujəš n-ehăn n-ăhaləs n-anăkfor, awəy ilalăn n-ehăn-net ar s-ad-t-ikrad təzzar; dihen, ad-udabăt terăẓẓe n-ehăn, awəy a-wa t-ihăn. ");
INSERT INTO taq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ere hi-wărăn irha-dăɣ, a-di, ašănjo-nin; ere daɣ wa hi-wărăn itilal s-asdu, ašəmmăhəš ɣas a t-išlan.» ");
INSERT INTO taq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Innʼ-asăn daɣ: «Ăssiilmădăɣ-kăwăn a-s abăkkaḍ ămešăl ăgg-adəm d-asəkkufăr ija-dăɣ, ăddoobăt Măssinăɣ ad-has-t-in-ănš măšan ere ăskafărăn dăɣ-isălan n-Unfas Šăddijăn-dăɣ, wăr-ilkem ad-has-in-ătiwănša. ");
INSERT INTO taq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ere innăn a lăbasăn făll-Ăgg-ăgg-adəm-dăɣ, ăddoobăt ad-ijrəw tenăšše n-a-wen măšan, ere wa innăn a lăbasăn dăɣ-isălan n-Unfas Šăddijăn, wăr-ilkem ad-has-in-ătiwănša dăɣ-ăddunya wăla ălaxărăt.» ");
INSERT INTO taq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Olăs daɣ, innʼ-asăn: «Ahəšk olaɣăn, a-s mad-t-tasəd, aratăn-net daɣ i olaɣnen; erk ahəšk daɣ, a-s t-mad-t-tasəd, aratăn-net daɣ, i lăbasnen; ahəšk, aratăn-net a-s ititwəzzəy. ");
INSERT INTO taq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ya kăwăneḍ-i n-taššălen-i-dăɣ! Kăwăneḍ-i n-inăllăbăsăn, əndek əmmək wa s-ăddoobăt ad-dd-izjăr măjrăd olaɣăn imawăn-năwăn? A-wa iḍkărăn ulh n-ăgg-adəm a dd-izajjărăn emm-net. ");
INSERT INTO taq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ăwadəm-wa olăɣăn, milɣaw n-ulh-net a dăɣ-dd-itakkăs a-wa olăɣăn măšan, enăllăbăs ənta, tăllăbăst n-ulh-net a dăɣ-dd-itakkăs a-wa lăbasăn. ");
INSERT INTO taq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ăssiilmădăɣ-kăwăn a-s ašăl wa ilkămăn e-d t-təllăm taxxalt d-tašujəšt inna ăwadəm, ad-tăt-iẓəl dat-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iyyăt-i-dăɣ, ad-kăy-iɣləs măjrăd-năk, meɣ daɣ, măjrăd-năk iman-net, a kăy-madăn-isiḍəw, iwăr-kăy uḍlem.» ");
INSERT INTO taq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ăwwežăbăn-as iyyăḍ dăɣ-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ənnăn-as: «Ălɣalim, ăj data-năɣ iji n-Măssinăɣ, nənhăy.» ");
INSERT INTO taq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ăwwežăb-asăn, innʼ-asăn: «Ǝzzurəyăt-ta-dăɣ n-tenăllăbăst n-temăznit, wăr tăksuḍ Măssinăɣ; wăr təmmăɣ ɣas ar ad-ətwəjjən ijităn n-Măssinăɣ data-s măšan, təlmədet a-s wăr-ilkem dăɣ-s iji n-Măssinăɣ săl wa n-ănnăbi Yunəs. ");
INSERT INTO taq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ǝmmək-wa-dăɣ s-kăla ikkăs Yunəs kăraḍ išilan d-kăraḍ ihăḍan dăɣ-tăsa n-emăn wa măqqărăn, əmmək-wen-dăɣ daɣ a-s mad-ikkəs Ăgg-ăgg-adəm kăraḍ išilan d-kăraḍ ihăḍan dăɣ-ider n-ăkall. ");
INSERT INTO taq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ašăl wa n-tebădde, ad-dd-ənkărăn kăl-aɣrəm wa n-Nəniba, səḍləmăn kăl-əzzurəyăt-ta-dăɣ, ed ašăl wa d-hasăn-ixṭăb ănnăbi Yunəs, ătubăn. Săjdăt! Ašăl-i-dăɣ, ənhəywăt-ak, illʼ-ee jere-wăn ere ojărăn Yunəs, măšan hakd-a-wen-dăɣ, tunjăyăm s-ad-tutabăm. ");
INSERT INTO taq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ašăl wa n-tebădde, ad-dd-tənkăr tămănokalt ta s-kăla tăxkăm dăɣ-ăkall wa n-ajus s-isəm-net Saba, tăjjăyh făll-kăl-ăzzăman-i-dăɣ, səḍləm-tăn dăɣ-ăššăreɣa ed, ənta təfăl-dd ăkall ujəjăn i-ad-səjəd i-iməjridăn n-tayətte wi ităjj ămănokal Sulăyman. Săjdăt! Ašăl-i-dăɣ, ənhəywăt-ak, illʼ-ee jere-wăn ere ojărăn ămănokal Sulăyman, măšan hakd a-wen-dăɣ, tunjăyăm s-asjəd-has.» ");
INSERT INTO taq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Olăs daɣ, innʼ-asăn: «E-d izjăr alšin ăwadəm, ad-ăkk tinariwen i-ad-dăɣ-snăt immăɣ i-edăgg dăɣ-ăssunfa măšan, ad-has-t-iba; ");
INSERT INTO taq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","afăl has-t-ăba, ad-ănn i-iman-net: ‹Năkk-i-dăɣ, ma hi-idgaẓăn, əqqəlăɣet ɣas ehăn-in wa dd-fălăɣ.› Afăl dd-iqqăl edăgg wa ifăl s-tizarăt, ad-t-dd-ass wăr t-ihʼ ăwadəm, ifraḍ, ămmujnăt. ");
INSERT INTO taq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Igləw ălwăqq-wen, awəy-dd əssa alšinăn iyyăḍ t-ojărnen tăllăbăst, əjjəšăn ăwadəm-ənnin-dăɣ, əzzăɣăn dăɣ-s; umas a-s talɣa n-ăwadəm-en ta tăzzarăt, təššăm i-ta təšrăyăt.» Innʼ-asăn ḍarăt-a-wen: «Ǝnta-den-dăɣ a-wa dăr-mad-talăh talɣa n-əzzurəyăt-ta-dăɣ n-tenăllăbăst.» ");
INSERT INTO taq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ămmiijrăd Ɣisa i-tamətte dihen-dăɣ a-s ma-s d-ayətma-s da-dăɣ dd-əbdădnen dat-emm n-ehăn, ăšmašălăn-dd săr-s ăwadəm i-ad-hasăn-t-dd-iɣăr. ");
INSERT INTO taq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Osă-dd ăwadəm-en Ɣisa, innʼ-as: «Anna-năk d-ayətma-k, əbdadăn-ak dat-emm n-ehăn, ărhan ahănay-năk.» ");
INSERT INTO taq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ăwwežăb Ɣisa i-ăwadəm-en, innʼ-as: «Mi iqqalăn anna-nin, mi iqqalăn ayətma-ɣ?» ");
INSERT INTO taq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iẓẓăl ăfuss dăɣ-tanămhăla n-inəṭṭulab-net təzzar, innă: «Ǝnhəywăt-tăn-ak, anna-nin d-ayətma-ɣ! ");
INSERT INTO taq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","E d t-illăm ere itamašalăn erhet n-Abba-nin-i ihăn išənnawăn, ənta a-s ăŋŋa-ɣ, ənta a-s wălătma-ɣ, ənta a-s ma-ɣ.» ");
INSERT INTO taq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Izjăr Ɣisa ašăl-wen-dăɣ, ikkʼ asălim n-ejănš, ăqqima. ");
INSERT INTO taq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tăddew-dd săr-s tamətte tăjjeet, ijjăš-as turăft n-aman, ăqqima dăɣ-s, tăqqimă-dd tamətte ənta təbdad dăɣ-asălim n-aman, tăsijăd-as. ");
INSERT INTO taq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Issăɣlăy-tăn tangalen ăjjootnen. Ijʼ-asăn tiyyăt dăɣ-hasăn-innă: ");
INSERT INTO taq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","«Kăla izjăr ănăsdamu iyyăn i-ad-iddumət ašəkrəš-net. Ălwăqq wa d-itidumut, oḍănăt tiblalen tiyyăḍ dăɣ-ăbara, ăkkukkăren-tănăt-dd igḍaḍ, əkšăn-tănăt. ");
INSERT INTO taq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oḍa ašăr iyyăn jer-tihun, ăffoqqăt-dd šik ed wăr-intem dăɣ-ăkall, ");
INSERT INTO taq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","tăsmăqqăt-dd tăfukt jənnəj-s, təssărɣa isəffuqqa, ăqqur-in a-di iket-net ed wăr-əntemăn ikewăn-net dăɣ-hărăt. ");
INSERT INTO taq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oḍa ašăr iyyăn dăɣ-tabəŋŋənt, tədwăl-dd fălla-s tabəŋŋənt, təẓmăd-as. ");
INSERT INTO taq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oḍa ašăr wa iyyăḍăn dăɣ-ăkall olaɣăn, ikrăš aratăn, ijă tibolăsen s-tiyyăḍ temeḍe n-tablalt a tănăt-iwarăn, tiyyăḍ săḍisăt timərwen, tiyyăḍ kăraḍăt timərwen. ");
INSERT INTO taq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ere ilăn timəẓẓujen s-islă-dăɣ, isăjdet!» ");
INSERT INTO taq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ǝssəstănăn-t inəṭṭulab-net ḍarăt-a-wen d-ăddălil wa făl isaɣlay ăddinăt tangalen. ");
INSERT INTO taq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ăwwežăb-asăn, innʼ-asăn: «Kăwăneḍ, təjrawăm turhajăt n-ujreh n-əddăraj wa n-isălan n-Təmmənəya n-Măssinăɣ măšan, ăddinăt wi iyyăḍnen, wăr jen a-wen. ");
INSERT INTO taq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ăwadəm wa s-išwăr ifhăm hărăt, ad has-iwwaḍ musnăt har isəssikəy măšan, wa s-wăr t-illa a ijrah, wăr t-in-ikka hărăt, ănn-ak, ad-dăɣ-s ămahăɣ wăla a-wa ənḍărrăn iṭṭăf. ");
INSERT INTO taq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ǝnta-den-dăɣ a-wa făl saɣlăyăɣ ăddinăt tangalen i-ad-: ‹Ǝswaḍăn, wăr hənniyăn; ăsijădăn, wăr səllən; wăr t-illa daɣ a jarrăhăn.› » ");
INSERT INTO taq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ămoos a-wen a ăssiitbătăn a-wa fălla-săn inna ănnăbi Saya a-s innă, innă Măssinăɣ: «Ăddinăt! Ad-sallăm, wăr jărrəhăm; ad-təkyadăm, tăsibălalăɣăm, wăr t-illa a hannăyăm.» ");
INSERT INTO taq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ǝnta daɣ a innăn a-s, innă Măssinăɣ: «Tamətte-ta-dăɣ, tăsɣăr-ahi ulh-net; tăẓmăẓẓajʼ-ahi iman-net, tăsdărɣăl-ahi iman-net i-ad-ăbas hannay, ăbas sall, i-ad-wăr jărrăh hărăt făl iba n-tărha-i-dăɣ ja n-ad-săr-i dd-tənnăḍ, tutab, zuzəyăɣ-tăt.» ");
INSERT INTO taq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Inna Ɣisa ḍarăt-a-wen i-inəṭṭulab-net: «Tənḍəḍ-awăn kăwăneḍ ed hannăynăt tiṭṭawen-năwăn, sallănăt daɣ timəẓẓujen-năwăn. ");
INSERT INTO taq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ăssiilmădăɣ-kăwăn a-s, ăsdărhănăn ănnăbităn ăjjootnen d-imaɣdalăn ahănay n-a-wa hannăyăm măšan, wăr t-ənheyăn; ăsdărhănăn măsăllăt n-a-wa s-săllăm măšan, wăr has-əslen.» ");
INSERT INTO taq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Săjdăt ămăra i-ălmăɣna n-tangalt ta n-ănăsdamu: ");
INSERT INTO taq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","«Ăbara wa dăɣ-oḍănăt tiblalen, ənta a-s ăddinăt wi săllănen i-isălan n-Təmmənəya n-Măssinăɣ măšan, wăr tăn-jărrăhăn, asʼ-en-dd Iblis, ilbəy-dd dăɣ-ulhawăn-năsăn a-wa s-əslăn. ");
INSERT INTO taq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tihun ti jer-oḍănăt tiblalen, əntănăteḍ a-s ăddinăt wi s-e-d isla iyyăn dăɣ-săn i-măjrăd n-Măssinăɣ, ad-ihliləy, iqbəl-t šik măšan, ");
INSERT INTO taq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","wăr t-itəyy ikraš ikewăn dăɣ-ulh-net; ad-ăj ăzzăman ənḍărrăn ăkoyăd dăɣ-s, măšan afăl dd-tosa tissust meɣ osă-dd ălɣizabăt dăɣ-təssəba n-măjrăd n-Măssinăɣ, ad-hin-ibbuṭṭəl a-wa s-omăn. ");
INSERT INTO taq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tabəŋŋənt ta jer-oḍănăt tiblalen, ənta a-s ăddinăt wi s-e-d isla iyyăn dăɣ-săn i-măjrăd n-Măssinăɣ, ad-has-iẓməd dăɣ-ulh-net s-tărha n-wălăt-ăddunya d-eylăl n-tărha n-ajmur-net, wăr t-illa a săr-s dd-isaɣsal. ");
INSERT INTO taq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ăkall wa olăɣăn dăɣ-oḍănăt tiblalen, ənta a-s ăddinăt wi s-e-d isla iyyăn dăɣ-săn i-măjrăd n-Măssinăɣ, ad-t-ijrăh, ijjəš-as-t ălfăyda. Tarəw-dd săr-s tiyyăt tablalt temeḍe n-tablalt, tarəw-dd săr-s tiyyăt săḍisăt timərwen n-tablalt, tarəw-dd săr-s daɣ tiyyăt kăraḍăt timərwen n-tablalt.» ");
INSERT INTO taq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Issăɣlăy-tăn-dd Ɣisa daɣ tangalt tiyyăt dăɣ-hasăn-innă: «Təmmənəya n-Măssinăɣ, tănifăqqa d-ăhaləs iyyăn infărăn əttăɣam olaɣăn dăɣ-ašəkrəš-net. ");
INSERT INTO taq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ija ehăḍ, əṭṭăsăn ăddinăt ɣas, osă-dd ămiksăn iyyăn ašəkrəš wa n-ălkăma ăddomăt ăhaləs-ənnin, infăr dăɣ-s erk idommăn, iglă. ");
INSERT INTO taq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ăsfăqqăt-dd ašəkrəš wa n-əttăɣam wa olăɣăn, orăw, tədwăl-dd daɣ terk teyəšše edes-has. ");
INSERT INTO taq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ǝnhăyăn inaxdimăn n-măssi-s n-ašəkrəš terk teyəšše ta dd-tədwălăt ɣas, osăn-t, ənnăn-as: ‹Măssi-năɣ, ajăn wădden kăyy əttăɣam olaɣăn ɣas a tənfărăd dăɣ-ašəkrəš-năk, əndek siha s-dd-ha terk teyəšše ta t-hăt ămăra?› ");
INSERT INTO taq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Innʼ-asăn: ‹A-di imojjan n-ere hi wărăn irha.› Ǝnnăn-as inaxdimăn-net: ‹Adiš, nəlbəyet-tăt-in?› ");
INSERT INTO taq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Innʼ-asăn: ‹Aha-aha! Wăr jem a-di, ed afăl təttărăm ad-hin-təlbəyăm terk teyəšše, ham miši n-ad-hin-təlbəyăm daɣ ălkăma. ");
INSERT INTO taq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ăyyăt-tăn ad-ədwəlăn issənăn-essăn har ăzzăman wa n-amili n-išəkraš, dihen, ad-ănnăɣ i-wi tiləynen išəkraš, ad-dd-əlbəyăn terk teyəšše s-tizarăt, əjən-tăt tikărrad, təzzar, sărɣən-tăt, sədwən-ahi-dd ḍarăt-a-wen ălkăma, əjən-t dăɣ-ejănd-in.› » ");
INSERT INTO taq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Issăɣlăy-tăn-dd daɣ ḍarăt-a-wen tangalt tiyyăt, innʼ-asăn: «Təmmənəya n-Măssinăɣ, tolăh d-temătăwt ăddomăt ăwadəm dăɣ-ašəkrəš-net. ");
INSERT INTO taq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Temătăwt-ten-dăɣ, ənta a tojărăt təmmətkit dăɣ-idommăn măšan, tədwăl-dd, tăqqăl ahəšk ojărăn tiyəššawen n-ašəkrəš iket-năsnăt har ẓattăn igḍaḍ iskak-năsăn dăɣ-iləktan-net.» ");
INSERT INTO taq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Issăɣlăy-tăn-dd tangalt tiyyăt daɣ, innʼ-asăn: «Təmmənəya n-Măssinăɣ, tolăh d-takməttet n-tăẓẓa təssărtăy tamăḍt d-kăraḍ ănnăfăɣatăn n-ejel n-ălkăma i-ad-ikəf iket-net.» ");
INSERT INTO taq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tangalen a dăɣ-issăɣra Ɣisa isălan-wi-dăɣ iket-năsăn, wăr t-illa a inna i-tamətte s-wădden tangalen a dăɣ-hasăn-t-inna. ");
INSERT INTO taq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ămoos a-wen a ăssiitbătăn a-wa innă ănnăbi n-Măssinăɣ iyyăn, innă Măssinăɣ: «Ad-săɣləyăɣ ăddinăt tangalen, ăjăɣ isălan s-ad-dd-tăxlăk ăddunya-dăɣ, ăttunkălăn.» ");
INSERT INTO taq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ifăl Ɣisa tamətte, ijjăš ehăn ɣas, əkkăn-t-dd inəṭṭulab-net, əttărăn dăɣ-s ad-hasăn-arr tangalt ta n-terk teyəšše. ");
INSERT INTO taq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Innʼ-asăn: «Ăgg-ăgg-adəm ənta, a ăddomen əttăɣam wa olăɣăn, ");
INSERT INTO taq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ăddunya a-s ašəkrəš-net; əttăɣam wa olăɣăn a-s aratăn n-Təmmənəya n-Măssinăɣ, terk teyəšše a-s aratăn wi n-Iblis. ");
INSERT INTO taq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iblis a-s ămiksăn wa ăddomen terk teyəšše dăɣ-ašəkrəš, amili n-išəkraš a-s sămdo n-ăddunya, ănjălosăn a-s imalayăn n-ašəkrəš. ");
INSERT INTO taq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ǝmmək-wen-dăɣ s-dd-tatălbay terk teyəšše, tămmăḍkăl, tətwəjăr-in dăɣ-efew, əmmək-wen-dăɣ a he-ijən ašăl wa d-tamănd ăddunya. ");
INSERT INTO taq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ašăl-en, ad-išəmmišəl Ăgg-ăgg-adəm ănjălosăn-net i-ad-hin-aləmăn dăɣ-Təmmənəya-net ăddinăt wi šinməšrəynen imidiwăn-năsăn d-wi tamašalnen a lăbasăn, əḍkəlăn-tăn, ");
INSERT INTO taq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","əjrən-tăn-in dăɣ-tahəst-i dăɣ-tăn wăr mad-išləw ar tahăla, ẓiməkărkiẓăn isenăn făl tămujriẓt. ");
INSERT INTO taq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ašăl-en, ăddinăt wi oɣădnen dat-Măssinăɣ, ad-fălla-săn ăj Măssinăɣ ănnur-net, əjən asmăɣmăɣ wa tăjj tăfukt dăɣ-Təmmənəya n-Abba-năsăn. Ere ilăn timəẓẓujen s-islă, isăjdet!» ");
INSERT INTO taq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Innʼ-asăn Ɣisa daɣ: «Təmmənəya n-Măssinăɣ, tolăh d-ejănd n-orăɣ inbalăn dăɣ-ašəkrəš iyyăn. Təgla tanfust har ašăl wa d-fălla-s oḍa ăhaləs iyyăn. A-wa-dăɣ has-ja tedăwit, iknʼ-e ufăr i-ad-wăr săr-s iləmməd ăwadəm wălʼ iyyăn. Iglă ḍarăt-a-wen, ăttužžăr-in a-wa ila iket-net i-ad-udabăt akăraš n-ašəkrəš-en-dăɣ dăɣ-inbal orăɣ-wənnin-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Olăs daɣ, innʼ-asăn: «Təmmənəya n-Măssinăɣ, tolăh d-u-mamăla itammăɣăn i-timăɣwanen n-tilăllaten, ");
INSERT INTO taq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ijrăw tiyyăt təknat əlləllu ɣas iglă, ăttužžăr-in a-wa ila iket-net, iqqăl-dd, ižžənšʼ-et.» ");
INSERT INTO taq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Innʼ-asăn daɣ: «Təmmənəya n-Măssinăɣ, tolăh d-tătart jărăn iməhhuyya n-imănan dăɣ-ejănš i-ad-săr-s dd-ărməsăn tulaten n-imănan ăjjootnen, ");
INSERT INTO taq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","təḍnăy tătart ɣas, əntăšăn-tăt-dd s-asălim n-aman, ad-biḍḍun imănan s-iyyăn-iyyăn, hak iyyăn d-əẓẓənəf-net. Jăn wi əfrănnen dăɣ-deketăn-năsăn, jărăn-in fălla-săn wi hasăn wăr iha ălfăyda. ");
INSERT INTO taq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","A-wen-dăɣ daɣ a madăn-ăj ašăl wa d-tamănd ăddunya, a dd-asən ănjălosăn, əbḍəwăn imaɣdalăn d-inăllăbăsăn, ");
INSERT INTO taq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","əjrən-in inăllăbăsăn dăɣ-tahəst ta-dăɣ tăn-wăr mad-išləw ar tahăla, ẓiməkărkiẓăn isenăn făl tămujriẓt.» ");
INSERT INTO taq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Issəstăn Ɣisa inəṭṭulab-net ḍarăt-a-wen, innʼ-asăn: «Ak a-wa hawăn-ənneɣ, təjrahăm-t meɣ?» Ǝnnăn-as: «Ǝyya, nəjrah-t.» ");
INSERT INTO taq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Innʼ-asăn: «E d t-illăm ălɣalim n-Ăṭṭăwrăt iknan afăham n-a-wa ămoosăn isălan n-Təmmənəya n-Măssinăɣ, irḍa săr-săn, ad-has-iwwaḍ musnăt ăynayăn făll-wa ărəwăn ila, afăl ija a-wen, ad-alăh d-abba n-eɣewən dd-itakkăsăn hărătăn ăynaynen d-i ărəwnen dăɣ-ijăndăn-net.» ");
INSERT INTO taq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Issəmda Ɣisa tənna n-tangalen-tin-dăɣ ɣas, ifăl dihen, ");
INSERT INTO taq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ikkă taɣrəmt ta dăɣ-idwăl. Issăɣra dihen dăɣ-ehăn n-ăddin wa n-kăl-Ălyăhud, ăkunăn ăddinăt iket-năsăn dăɣ-a-wa isaɣra, əqqălăn-dd ɣas oran imawăn, jannen: «Wa, əndek siha s-t-dd-ha təlɣuləma-ta-dăɣ d-tikunen ti ităjj? ");
INSERT INTO taq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ajăn wădden a-wa rure-s n-mənizye wa-dăɣ nəzzăy? Wădden ma-s, Măryăma? Ayətma-s: Yaqub, Yusəf, Simyon d-Hudd? ");
INSERT INTO taq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ajăn wădden šătma-s da-dăɣ t-əllănen jere-năɣ? Ɣas əndek siha s-t-dd-iha a-wa-dăɣ ităjj iket-net?» ");
INSERT INTO taq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jăn-as a-wen-dăɣ s-t-əzzayăn asăkor, unjăyăn săr-s omănăn. Innʼ-asăn: «Ănnăbi, wăr t-illa edăgg s-wădden ătiwăsămɣăr dăɣ-s ar dăɣ-ăkall-net d-ɣur-kăl-ehăn-net.» ");
INSERT INTO taq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Igdăl-as iba n-immun-năsăn ad-ɣur-săn ăj tikunen ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ăzzăman-en-dăɣ ad-dd-iwwăḍ mawmaw n-Ɣisa Harudəs wa n-ămănokal n-teje ta n-Galila. ");
INSERT INTO taq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Issăɣră-dd kăl-əlxəkum-net, innʼ-asăn: «Ăhaləs-wa-hi s-săllăɣ, Exya wa n-Enəsselmăɣ dd-olasăn tanăkra jer-inəmmuttan, a-wen-dăɣ a t-ikfăn tărna n-tikunen ti itamašal.» ");
INSERT INTO taq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Innă Harudəs a-wen făl-a-s ənta iman-net a ăstărmăsăn Exya, ijʼ-e dăɣ-tišəm təzzar ijʼ-e dăɣ-takărmut, dăɣ-təssəba n-Harudəyăt ta n-hănne-s n-ăŋŋa-s Fəlibb dăɣ-s ohăɣ Harudəs. ");
INSERT INTO taq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ăzzăman-en-dăɣ ad-ăsmăqqa Exya făll-Harudəs, innʼ-as: «Wăr hak-xălal ad-tărkəbăd hănne-s n-ăŋŋa-k.» ");
INSERT INTO taq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ad-itammăɣ ya Harudəs i-ăsaru făl t-issănɣa măšan, ăksuḍ tamətte ed iket-net təssan a-s Exya, ănnăbi a ămoos. ");
INSERT INTO taq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Təgla tanfust har ašăl wa n-isəkta n-tiwit n-ămănokal Harudəs. Ašăl-en, dăɣ-ăzzăho wa ijăn, təggăd-dd elle-s n-Harudəyăt, ad-dallăl dat-imăjarăn wi-dd-osănen; ijrăẓ a-wen i-ămănokal. ");
INSERT INTO taq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dăɣ-tedăwit-net, iɣrʼ-et-dd, ijjăš-as ărkăwăl n-ad-tăt-ăkf a-wa dăɣ-s mad-təttăr, a ămoos-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Təglă talyaḍt, təttăr ăddăbara dăɣ-ma-s, təntăj-tăt-dd ma-s, tənnʼ-as, ănnʼ-as: «Ărheeɣ dăɣ-k eɣăf n-Exya insa dăɣ-aẓăwa.» Təglă tămawaḍt, ja isălan dăɣ-ămănokal. ");
INSERT INTO taq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ǝnxăsăn iman n-ămănokal măšan, ăbas ăddoobăt uɣəl s-a-wa inna, ed ihăḍ-as s-ad-tăt-ăkf a-wa dăɣ-s mad-təttăr, a ămoos-dăɣ, dat-imăjarăn-net. Omăr ḍarăt-a-wen s-ad-itwəjj a-wa tărha. ");
INSERT INTO taq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Issəglă ăwadəm wa inakkăḍăn iɣăfawăn n-kăl-takărmut wi lănen s-tamăttant, inkăḍ-dd eɣăf n-Exya, ");
INSERT INTO taq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ăwwăy-t-dd insa dăɣ-aẓăwa; ikfʼ-e i-talyaḍt, tăwwăy-t talyaḍt i-ma-s. ");
INSERT INTO taq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Osăn-dd inəṭṭulab n-Exya ḍarăt-a-wen, əḍkălăn tafəkka-net, əẓkăn-tăt; əkkăn Ɣisa, jăn dăɣ-s isălan. ");
INSERT INTO taq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ǝjjăšăn isălan n-iba n-Exya Ɣisa ɣas, ifăl teje-ten-dăɣ dăɣ-turăft n-aman, ikkă tenere n-iman-net măšan, əslăn-t ăddinăt ɣas, fălăn-dd iɣărman, ălliilăn asălim n-ejănš, əlkamăn-as. ");
INSERT INTO taq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Izjăr-dd Ɣisa turăft n-aman, inhăy tamətte-ta-dăɣ tăjjet has-dd-təlkămăt ɣas, tănɣʼ-e tăhanint-net, ad-dăɣ-săn izizuy wi n-inaɣyabăn. ");
INSERT INTO taq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ja takkăṣt ɣas, ohăẓăn-t-dd inəṭṭulab-net, ənnăn-as: «Ălɣalim, tenere a nəha, ijʼ-anăɣ ehăḍ, səfəl iman-năk tamətte, ad-tăkk tidbi-ti ohăẓnen žănš-dd a təkša.» ");
INSERT INTO taq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Innʼ-asăn Ɣisa: «Wăr ămɣatărăn s-ad-əkkən edăgg. Un, šăkšăt-tăn kăwăneḍ iman-năwăn.» ");
INSERT INTO taq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ǝnnăn-as: «Wăr nəṭṭef ar səmmosăt tijəlwen d-əssin imănan.» ");
INSERT INTO taq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Innʼ-asăn: «Awəyăt-ahi-dd a-wa təṭṭăfăm.» ");
INSERT INTO taq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Omăr ḍarăt-a-wen s-ad-ăqqaymən ăddinăt făll-teyəšše, iḍkăl tijəlwen ti n-səmmosăt d-imănan wi n-əssin, ăjoẓăy išənnawăn, ămmoy i-Măssinăɣ; ăfrăsfărăs tijəlwen, ănkăḍnăkăḍ imănan təzzar, ikfă a-wen-dăɣ iket-net i-inəṭṭulab-net, ăẓunăn-t jer-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ǝkšăn iket-dăɣ-năsăn har əyyəwănăn, ăsdăwăn-dd a-wa dd-təjlăš tamətte, osăn-t iḍnăy măraw deketăn d-əssin n-tijəlwen d-imănan. ");
INSERT INTO taq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Səmmos afḍăn n-ăwadəm dăɣ-wăr ăḍḍinnăt tiḍeḍen wăla aratăn a ikšăn ašăl-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Izzəlzăm Ɣisa ḍarăt-a-wen inəṭṭulab-net ujəš n-turăft ta n-aman i-ad-has-izarăn s-efăyy n-ejănš wa iyyăḍăn, ad-isagla ənta tamətte. ");
INSERT INTO taq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Issəglă tamətte ɣas, iwwăn taḍaɣt tiyyăt, ad-itəddal Măssinăɣ. A-s toḍa tăfukt, wăr dd-ăqqima dăɣ-edăgg-ənnin-dăɣ, ar ənta ɣas. ");
INSERT INTO taq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A-s ija a-wen, turăft n-aman ta dăɣ-əglăn inəṭṭulab tăsisăgdăh ejănš măšan, inkăr-dd fălla-săn aḍu ăwwiɣwăɣăn turăft, băhhălnăt-as tinăzzămăren siha d-siha. ");
INSERT INTO taq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Iglʼ ehăḍ ɣas, ilkăm-asăn-dd irjaš făll-aman. ");
INSERT INTO taq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ǝnhăyăn-t inəṭṭulab, ikkʼ-en-dd irjaš făll-aman ɣas, ărmăɣăn, ad-jannen: «Osʼ-anăɣ ămăttănkul iyyăn», ad-naḍḍăwăn iɣăran. ");
INSERT INTO taq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ăssewăl-asăn šik, innʼ-asăn: «Meddən, ănset ənniyăt-năwăn, năkk a-wa; wăr tărmeɣăm.» ");
INSERT INTO taq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iggăd-dd Bəṭrus dăɣ-a-wen-dăɣ, innă i-Ɣisa: «Ălɣalim, kunta kăyy a-wa, amăr s-ad-kăy-in-ăkkăɣ, năkk-dăɣ, ărjašăɣ făll-aman.» ");
INSERT INTO taq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Innʼ-as Ɣisa: «Ǝyyăw!» Izjăr-dd Bəṭrus turăft n-aman, ikkă-dd Ɣisa irjaš făll-aman. ");
INSERT INTO taq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Inhăy Bəṭrus əṣṣuhu n-aḍu făll-ejănš ɣas, irmăɣ, əqqălăn-t aman alămaẓ ălwăqq-wen-dăɣ, ad-isaɣărat, ijanna: «Ya Ălɣalim! Agəẓ-ahi.» ");
INSERT INTO taq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Irmăs-t-dd Ɣisa s-ăfuss, innʼ-as: «Təmmətkit ija immun-năk, ma itajjăn ăššăk dăɣ-ulh-năk.» ");
INSERT INTO taq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ǝjjăšăn-dd turăft făll-inəṭṭulab wi iyyăḍnen ɣas, ibdăd aḍu. ");
INSERT INTO taq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ǝnhăyăn wi ăqqimănen dăɣ-turăft a-wen ɣas, ărkăɣăn data-s, ənnăn-as: «Tidət-dăɣ a-s kăyy a-s Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tăsjăn turăft n-ăman-năsăn ălwăqq-wen-dăɣ dăɣ-teje ta n-Žănnăṣarăt. ");
INSERT INTO taq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ǝzzăyăn-t kăl-aɣrəm-en ɣas, ošălăn, jăn isălan dăɣ-attayăn-en, ad-săr-s dd-tiwəyăn ăddinăt e d t-illăm ere ărhiinăn. ");
INSERT INTO taq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Laqqădăn kăl-aɣrəm Ɣisa dăɣ-ad-tăn-ăyy, ad-ăḍəsăn kud-dăɣ afăr n-erăswăy-net, ed ere t-iḍăsăn-dăɣ, ad-izzəy. ");
INSERT INTO taq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Osăn-dd kăl-faris iyyăḍ d-hărăt dăɣ-ălɣulam n-Ăṭṭăwrăt dd-falnen Yărussălam Ɣisa, ");
INSERT INTO taq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ənnăn-as: «Mafăl tinməšrəyăn inəṭṭulab-năk i-agna wa hanăɣ-dd-oyyăn imărawăn-nănăɣ? Tattăn wăr-ăsserădăn ifassăn-năsăn s-əmmək wa s-t-ifrăḍ agna-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Ad-kăwăn-səstənăɣ: kăwăneḍ-š, mafăl tinməšrəyăm i-alămăr wa n-Măssinăɣ, tajjăm agna-năwăn jənnəj-s? ");
INSERT INTO taq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wădden Măssinăɣ innă: ‹Səmɣăr ti-k d-ma-k›, innă daɣ: ‹Ere ăbodărăn ti-s meɣ ma-s, adiš, ămmătet.› ");
INSERT INTO taq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Təssanăm s-a-wen-dăɣ iket-net măšan, iyyăḍ dăɣ-wăn, saɣren ăddinăt a-s ăddoobăt ăwadəm ad-ănn i-ti-s d-ma-s: ‹A-wa s-ăsidărhănăɣ ad-kăwăn-ədhəlăɣ săr-s, jeɣ-t takute i-Măssinăɣ.› Ija ɣur-wăn a-s ere innăn a-wen-dăɣ i-imărawăn-net, ad-ăbas t-iwar ălxaqq-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ǝnhəywăt ɣas a-wa kăwăn-išlăn: tăsbăṭṭălăm-in a-wa inna Măssinăɣ, jăm a-wa hawăn-inna agna-năwăn dăɣ-edăgg-net. ");
INSERT INTO taq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ălmunafeɣăn yaden! Tidət a-wa fălla-wăn innă ănnăbi Saya a-s innă, innă Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Tamətte ta-hi, iḍlay-net ɣas a-s hi-tăssiimɣăr ulh-net, ujəj-ahi; ");
INSERT INTO taq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ălɣibadăt-wa hi-tăjj d-tikutawen ti hi-tăjj, mălayăɣna ɣas ed a-wa săɣren făll-ismawăn n-Măssinăɣ, wăr ămoos ɣas ar fărəḍăn dd-ăɣtasăn i-iman-năsăn.› » ");
INSERT INTO taq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iɣră-dd Ɣisa tamətte s-iman-net ḍarăt-a-wen, innʼ-as: «Săjdăt, təjrăhăm a-wa hawăn-janneɣ: ");
INSERT INTO taq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","wădden a-wa itajjăšăn emm n-ăgg-adəm a t-isamăḍasăn, a-wa dd-itəffalăn ammas n-ulh-net ijănna s-emm-net a t-isamăḍasăn dat-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ohăẓăn-t-dd inəṭṭulab-net, ənnăn-as: «Kăyy ya, a-wa tənned, ikma kăl-faris hullan.» ");
INSERT INTO taq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Innʼ-asăn Ɣisa: «E d t-illăm emăɣt s-wădden Abba-nin-i ihăn išənnawăn a t-ăddomen, ilkam, ad-hin-ăttălbăy. ");
INSERT INTO taq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ăyyăt kăl-faris d-iman-năsăn, olăhăn ɣas d-imalwayăn dărɣalnen; emədderɣəl ya ilwayăn amidi-net, ejăḍăl ɣas a əkkan issənăn-essăn dăɣ-anu.» ");
INSERT INTO taq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iggăd-dd Bəṭrus, innʼ-as: «Fassăr-anăɣ tangalt-ta-dăɣ jed. » ");
INSERT INTO taq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Innʼ-asăn Ɣisa: «Ɣas kăwăneḍ-dăɣ, wăr t-illa a təjrahăm hărwa? ");
INSERT INTO taq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ajăn wăr təjrehăm a-s ăsink esăk? A-wa isuk ăwadəm emm-net, tăsa-net ɣas a itakk, ijăr-t-in ḍarăt-a-wen dăɣ-tăkoyt ");
INSERT INTO taq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","măšan, măjrăd wa dd-izajjărăn emm n-ăwadəm, ulh-net a dd-itəffal, ənta-den-dăɣ a-wa t-isamăḍasăn dat-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","făl-a-s ulh n-ăgg-adəm, a dd-itəffal erk ənniyăt, iji n-iman, əzzəna, iba n-tăkrakiḍt, tikra, tajuhe n-bahu, təkkufăra. ");
INSERT INTO taq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ǝntăneḍ-den-dăɣ hărătăn wi samăḍasnen ăwadəm, wădden tetăte wăr-ăsserăd ifassăn-net.» ");
INSERT INTO taq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ifăl Ɣisa edăgg-en ənta d-inəṭṭulab-net ɣas, ikkă teje ta hăn iɣărman wi n-Tir d-Săyda. ");
INSERT INTO taq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Illʼ-ee dihen-dăɣ a-s šik-dăɣ, tamăḍt tiyyăt ila ăkall wa n-Xăna da-dăɣ t-dd-tosăt, ad-t-laqqăd, saɣărat, jannʼ-as: «Ălɣalim! Ya Ăgg-Dawəd, aḍən-ahi tăhanint; elle-ɣ tăllubbăḍ, issəknʼ-et alšin wa tăt-ihăn aɣăna.» ");
INSERT INTO taq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wăr t-illa a has-inna Ɣisa. Ǝggădăn-dd săr-s inəṭṭulab-net, ənnăn-as: «Săfəl-anăɣ tamăḍt-ta-dăɣ, tăsɣăf-anăɣ, e-s nəkka-dăɣ, tăseɣărăt ḍara-năɣ!» ");
INSERT INTO taq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Innʼ-asăn Ɣisa: «Năkk tamətte ta n-kăl-Iṣrayil-i toolăhăt d-tihatten ăssujjălnen a-s hi-dd ăšmašăl Măssinăɣ. A-wa săl əntăneḍ, wăr hi-săr-s-dd-ăšmašăl.» ");
INSERT INTO taq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Măšan hakd a-wen-dăɣ, təkkʼ-e-hi-dd tamăḍt, tărkăɣ data-s, tənnʼ-as: «Ălɣalim, əkkəs-ahi tekăriḍt.» ");
INSERT INTO taq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ăwwežăb-as Ɣisa, innʼ-as: «Wăr-ănhăjja ad-dd-ikkəs ăwadəm amənsi daw-aratăn, ijăr-t-in i-iyyăḍan?» ");
INSERT INTO taq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tənnʼ-as tamăḍt: «Ălɣalim, tidət măšan, a-wen wăr-ikkes a-s afăl ălwăqq wa d-itătt măssi-s n-ehăn, ăddooben iyyăḍan ad-ăkkămen a-wa ititrəkkin.» ");
INSERT INTO taq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ja măjrăd-wen-dăɣ ɣas, innʼ-as Ɣisa: «Tamăḍt! Immun-năm, tidət-dăɣ a-s i măqqărăn; ăjet a-wa təttărăd.» Təzzăy elle-s dăɣ-tamăzăyyat-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ifăl Ɣisa teje-ten-dăɣ ɣas, ikkă asălim n-ejănš wa n-Galila, iwwăn dihen taḍaɣt tiyyăt ăqqima fălla-s. ");
INSERT INTO taq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ǝkkăn-t-dd ăddinăt ăjjootnen ăwwaynen inəbdan d-iməddorɣal d-inaɣyabăn d-ăddinăt s-əkradăn ilsawăn-năsăn d-imarhinăn ăjjootnen, əssənsăn-tăn daw-iḍarăn-net; ăzozăy-tăn iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ăkunăn ăddinăt dăɣ-a-wa ija ed hannăyăn a-s, wi s-kăla əkrăsăn ilsawăn-năsăn, tamăjradăn; inaɣyabăn, tazzăyăn; inəbdan, rajjăšăn; iməddorɣal, hannăyăn. Tənhăy tamətte a-wen ɣas, ad-t-timəl, janna: «Təmmal i-Emăli wa n-Iṣrayil.» ");
INSERT INTO taq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ikkăs-dd Ɣisa inəṭṭulab-net s-takše, innʼ-asăn: «Naqqʼ-ahi tăhanint n-tamətte-i-dăɣ; a ilan kăraḍ išilan, təlkam-ahi, ăbas əṭṭafăn ăddinăt a əkšăn, wăr-ăddobeɣ ad-tăn-săglăɣ ălluẓăn s-əmmək-wa-dăɣ, ad-hasăn-indăr ad-hin-awəḍăn ihănan-năsăn făl iba n-ăṣṣahăt.» ");
INSERT INTO taq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ǝnnăn-as inəṭṭulab-net: «Ǝndek diha d-mad-nəjrəw tijəlwen ăššikšănen tamətte jat əjut-wa-dăɣ dăɣ-tenere-ta-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Innʼ-asăn: «Maniket tijəlwen təṭṭăfăm?» Ǝnnăn-as: «Ǝssayăt, nəṭṭaf daɣ hărăt n-imănan.» ");
INSERT INTO taq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ăsɣăyma Ɣisa tamətte iket-net, ");
INSERT INTO taq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","iḍkăl ḍarăt-a-wen tijəlwen ti n-əssayăt d-a-wa t-əkfăn dăɣ-imănan, ămmoy i-Măssinăɣ, ăfrăsfărăs annin-dăɣ iket-net təzzar, ikfʼ-e i-inəṭṭulab i-ad-t-uẓanăn jer-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Təkša tamətte ta təllăt dihen-dăɣ hundăɣ har təyyəwăn iket-dăɣ-net, ăsdăwăn-dd inəṭṭulab a-wa dd-əjlăšăn ăddinăt, osăn-t iḍnay əssa deketăn. ");
INSERT INTO taq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ǝkkoẓ afḍăn n-ăwadəm dăɣ-wăr ăḍḍinnăt tiḍeḍen d-aratăn a ikšăn ašăl-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Issəglă Ɣisa tamətte ḍarăt-a-wen təzzar, ijjăš turăft n-aman, ikkă teje ta n-Magadan. ");
INSERT INTO taq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ašăl iyyăn, osăn-dd hărăt dăɣ-kăl-faris d-kăl-sadus Ɣisa, jăn-as asəstan dăɣ-otasăn irrum-net, i-ad-əjrəwăn ăsaru făl t-əssəḍlămăn, ənnăn-as: «Ăj data-năɣ iji n-Măssinăɣ hanăɣ-issətbătăn a-s tidət-dăɣ a-s Măssinăɣ a kăy-dd-ăšmašălăn.» ");
INSERT INTO taq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ăwwežăb-asăn, innʼ-asăn: «Ajăn wădden e-d tăbok tăfukt i-ejăḍăl har tənhăyăm a-s šăggaɣ, ad-tənnəm: ‹Ašəkka, wăr-e iwət ajənna.› ");
INSERT INTO taq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Afăl ăffăw har tənhăyăm ajənna ikannă-dd, ad-tənnəm: ‹Ašăl-i, ad-iwət ajənna, ənhəywăt-ak, kăwal-dd.› Kăwăneḍ-i s-e-d təkyădăm išənnawăn, ad-təlmədăm a-wa dd-imalăn, mafăl hawăn-indar ad-tăɣrəm išmal n-ăzzămanăn wi jănen, təfhəmăm ălmăɣna-năsăn? ");
INSERT INTO taq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kăl-əzzurəyăt-ta-dăɣ, tenăllăbăst n-temăznit, wăr təmmăɣ ɣas ar i-ad-ətwəjjən ijităn n-Măssinăɣ data-s măšan, təlmədet a-s wăr dăɣ-s ilkem iji n-Măssinăɣ săl wa n-ănnăbi Yunəs.» Innʼ-asăn Ɣisa a-wen ɣas, ifăl-tăn, iglă. ");
INSERT INTO taq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ijlăy Ɣisa ənta d-inəṭṭulab-net ejănš s-ašrut wa iyyăḍăn. Ǝglan făll-ejănš-en-dăɣ a-s dd-əktăn inəṭṭulab-net a-s wăr-əwweyăn ăzzad dăɣ-tijəlwen. ");
INSERT INTO taq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ǝjlăyăn ejănš ɣas, innʼ-asăn Ɣisa: «He kăwăneḍ! Agəẓăt iman-năwăn dăɣ-tăẓẓa ta n-kăl-faris d-kăl-sadus.» ");
INSERT INTO taq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Innʼ-asăn Ɣisa a-wen ɣas, ad-tinmənnin jer-iman-năsăn: «A-wa, a-wa dăɣ s-wăr nəwwey tijəlwen a făl hanăɣ-itajj măjrăd-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ilmăd Ɣisa ɣur-iman-net a-wa dăɣ-zinəzjumăn, innʼ-asăn: «Mafăl tinmənnim? ‹A-wa, a-wa dăɣ s-wăr năwwey tijəlwen a făl hanăɣ-itajj măjrăd-wa-dăɣ›, təmmətkit ija immun-năwăn. ");
INSERT INTO taq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Adiš, kăwăneḍ har ămăra-dăɣ, wăr t-illa a təjrahăm? Ajăn təttəwăm-in səmmosăt tijəlwen-ti tăẓunăm i-səmmos afḍăn n-ăhaləs? Maniket deketăn dd-tăsdăwăm dăɣ-a-wa dd-təjlăš tamətte? ");
INSERT INTO taq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Adiš təttəwăm-in əssayăt tijəlwen-ti s-ăsyăwănăɣ əkkoẓ afḍăn n-ăhaləs, maniket deketăn dd-təjlăš tamətte? ");
INSERT INTO taq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ma hawăn-igdalăn ad-təfhəmăm a-s wădden tijəlwen a dăɣ-hawăn-ăssewălăɣ? A hawăn-ənnəɣ: ‹Agəẓăt iman-năwăn dăɣ-tăẓẓa ta n-kăl-faris d-kăl-sadus.› » ");
INSERT INTO taq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Innʼ-asăn Ɣisa a-wen ɣas, əfhămăn a-s wădden isălan n-tăẓẓa ta n-tijəlwen a dăɣ-hasăn-ăssewăl, ănn-ak, ămmijrăd-asăn dăɣ-isălan n-ad-agəẓăn iman-năsăn dăɣ-a-wa săɣren kăl-faris d-kăl-sadus. ");
INSERT INTO taq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ikkă Ɣisa ḍarăt-a-wen aɣrəm s-itawănna Qăyṣăra wa n-Fəlibb. Dihen-dăɣ ad-issəstăn inəṭṭulab-net, innʼ-asăn: «Ma jannen ăddinăt, mi ămoos Ăgg-ăgg-adəm?» ");
INSERT INTO taq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ǝnnăn-as: «Iyyăḍ jannen: kăyy a-s Exya wa n-Enəsselmăɣ; iyyăḍ jannen: kăyy a-s ănnăbi Ɣəli; iyyăḍ făw a jannen: kăyy a-s ănnăbi Yirmiya meɣ iyyăn dăɣ-ănnăbităn dd-olasăn uɣəl.» ");
INSERT INTO taq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Innʼ-asăn: «Kăwăneḍ-š, ma tənnăm, mi ămoosăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Iggăd-dd Bəṭrus, innʼ-as: «Kăyy a-s Ălmasex wa n-Rure-s n-Măssinăɣ-i iddărăn.» ");
INSERT INTO taq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Innʼ-as Ɣisa: «Simyon ăgg Exya, tənḍəḍ-ak ed isălan wi s-iket tăn-jed, wădden ad-dd-təkkasăd dăɣ-eɣăf-năk, Abba-nin-i hăn išənnawăn a hak-tăn-dd-ăsnăfalălăn. ");
INSERT INTO taq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Năkk daɣ, ənneɣ-ak: isəm-năk Bəṭrus, ăssiilmădăɣ-kăy a-s făll-tăhunt-ten-dăɣ, ad-mad-ădyăɣ ălkănisăt-in s-ălaxărăt wăla Iblis, wăr fălla-s mad-ikrəš ašăl; ");
INSERT INTO taq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ad-kăy-ăkfăɣ isyar n-Təmmənəya n-Măssinăɣ, a təgdălăd făll-ărori n-ăkall, ad-itwəgdəl dăɣ-išənnawăn, a tăqbălăd făll-ărori n-ăkall, ad-itwăqbəl dăɣ-išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ăsmăhăḍ Ɣisa ḍarăt-a-wen s-ăṣṣahăt dăɣ-inəṭṭulab-net i-ad-wăr-ənnen i-ăwadəm wălʼ iyyăn a-s ənta a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ɣur-ašăl-wen-dăɣ, ad-issəntă Ɣisa asəlmad n-inəṭṭulab-net a-s ilzam-t ad-ăkk Yărussălăm, inhəy dăɣ-s tersəmmawen ăjjootnen jer-ifassăn n-inušămăn wi n-Iṣrayil d-imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt; ad-əjən iman-net măšan, ašăl wa s-kăraḍ ḍarăt tamăttant-net, ad-dd-inkăr jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ijʼ-asăn Ɣisa măjrăd-wen-dăɣ ɣas, ikkăs-t-dd Bəṭrus s-takše, ad-itikləwləw fălla-s, ijannʼ-as: «Ălɣalim, ogăẓ-kăy Măssinăɣ! A-wen ya, wăr t-illa əmmək s-kăy-irmăs.» ");
INSERT INTO taq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ikna Ɣisa akăyad dăɣ-Bəṭrus, innʼ-as: «Šənkəš făll-i Iblis-wa, kăyy əssəbab n-anməšri a hi-tămoosăd ed inəzjam-năk, i n-dăgg-adəm wădden i n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inna Ɣisa ḍarăt-a-wen i-inəṭṭulab-net: «Ere irhăn alkum-hahi-dăɣ, adiš, iksənet iman-net, ăjet făll-tamăttant šund ta n-tajəttewt təzzar, ilkəmet-ahi. ");
INSERT INTO taq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wa wărăn itəttăr ar əmmək s-ogăẓ iman-net dăɣ-ăddunya-ta-dăɣ, ad-ifut dăɣ-ălžănnăt măšan, wa irḍăn ăfota dăɣ-iman-net dăɣ-ăddunya-ta-dăɣ, dăɣ-ăddimmăt-in, ad-ijjəš ălžănnăt. ");
INSERT INTO taq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma s-infa ăgg-adəm ad-irbăx ăddunya iket-dăɣ-net, a-s ija a-wen, ăfota dăɣ-ălaxărăt? Ajăn ma t-illan s-ăddoobăt ăwadəm ad-t-ăkf i-ad-săr-s iɣləs iman-net dăɣ-temse? ");
INSERT INTO taq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ašăl wa dd-mad-iqqəl Ăgg-ăgg-adəm dăɣ-ălxurmăt n-Abba-net ăddeew d-ănjălosăn-net, ašăl-en, hak ăwadəm d-a-wa has-jăn imojjan-net. ");
INSERT INTO taq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ăssiilmădăɣ-kăwăn a-s han-kăwăn ăddinăt əbdadnen diha-dăɣ, wăr-e iba, wăr-ənheyăn Ăgg-ăgg-adəm ijjaš Təmmənəya-net.» ");
INSERT INTO taq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Săḍis išilan ḍarăt a-s inna a-wen-dăɣ, iɣră-dd Bəṭrus d-Yaqub d-Exya wa n-ăŋŋa-s n-Yaqub s-edes, ikka dăr-săn taḍaɣt tiyyăt šəjreet. ");
INSERT INTO taq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ǝllan-t dihen-dăɣ a-s ijjăš data-săn ini ăynayăn, ămmuttăy, ăsmăɣmăɣ idəm-net šund tăfukt, jăn-dd imălsan-net təməlle ta n-ănnur ăsimăɣmăɣăn. ");
INSERT INTO taq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A ənḍărrăn ănnăbi Mosa d-ănnăbi Ɣəli da-dăɣ hasăn-dd-ănfalălnen, falăn-dd išənnawăn, ad-tamăjradăn d-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iggăd-dd Bəṭrus, innă i-Ɣisa: «Ălɣalim, ufa ad-nəzzăɣ ɣas diha-dăɣ, kunta tărḍed s-a-wen, ad-əkrəsăɣ kăraḍ ihəktan: wa-năkk, wa n-Mosa d-wa n-Ɣəli.» ");
INSERT INTO taq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hărwa-dăɣ ămmiijrăd a-s, tejărăkt tiyyăt tăsimăɣmăɣăt da-dăɣ tăn-dd-təlsăt s-tele-net, ijmăḍ-tăt-dd emăsli innăn: «A-wa Rure-ɣ wa əkneeɣ tărha, ənta a dăɣ-ăsriwăn iman-in, săjdăt-as!» ");
INSERT INTO taq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ǝslăn inəṭṭulab i-emăsli-wen-dăɣ ɣas, hăn-dd ăbbunbăyăn iket-dăɣ-năsăn a-wa-dăɣ hasăn-təja tărəmmeɣt. ");
INSERT INTO taq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ikkʼ-en-dd Ɣisa, issənsă ifassăn-net fălla-săn, innʼ-asăn: «Wăr tərmeɣăm, ənkărăt-dd.» ");
INSERT INTO taq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A-s dd-əḍkălăn idmawăn-năsăn, wăr t-illa ere hannăyăn ar Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ătrarăn-dd taḍaɣt ɣas, innʼ-asăn Ɣisa: «Wăr jem isălan n-a-wa hawăn-dd-ănfalălăn ašăl-i-dăɣ i-ăwadəm wălʼ iyyăn, har ašăl wa dd-mad-inkăr Ăgg-ăgg-adəm jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ǝssəstănăn-t ḍarăt-a-wen, ənnăn-as: «Mafăl jannen ălɣulam n-Ăṭṭăwrăt a-s ănnăbi Ɣəli a ilan s-ad-dd-ass təzzar, išrəy-t-dd Ălmasex?» ");
INSERT INTO taq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ăwwežăb-asăn, innʼ-asăn: «Tidət, ănnăbi Ɣəli a ilan s-a-dd-ass, isəssiɣəd hărăt iket-net, ");
INSERT INTO taq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","măšan, ăssiilmădăɣ-kăwăn a-s ănnăbi Ɣəli, ăru dd-osa, ăkkuddălăn-t dăgg-adəm, jăn-as a-wa s-ărhăn. A-wen-dăɣ has-jăn a-s ilkam daɣ, ad-t-əjən i-Ăgg-ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Innʼ-asăn a-wen ɣas, əfhămăn inəṭṭulab a-s Exya wa n-Enəsselmăɣ a-s hasăn-iha ti-net. ");
INSERT INTO taq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ălwăqq wa dd-iqqăl Ɣisa d-inəṭṭulab-net tamətte, ikkʼ-e-hi-dd ăhaləs iyyăn, irkăɣ data-s a t-ilaqqăd, ijannʼ-as: ");
INSERT INTO taq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Ălɣalim, aḍən tăhanint i-rure-ɣ, təjraw-t tašăkărkărăt t-saknet aɣăna hullan. E-d t-tărmăs, ad-itiḍəw dăɣ-efew, itiḍəw dăɣ-aman dehiyyăn. ");
INSERT INTO taq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ăwwăyăɣ-t-dd s-inəṭṭulab-năk măšan, indăr-asăn ad-t-zuzəyăn.» ");
INSERT INTO taq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Innăḍ-dd Ɣisa ḍarăt-a-wen s-inəṭṭulab-net, innʼ-asăn: «Ya əzzurəyăt-i-dăɣ wărăt tomen s-Măssinăɣ, tănimăšrăy-as, hundăɣ har əmme əlleɣ jere-wăn, əṣbarăɣ-kăwăn? Awəyăt-ahi-dd alyaḍ.» ");
INSERT INTO taq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Osʼ-e-hi-dd alyaḍ, ăsmăhăḍ Ɣisa dăɣ-alšin i-ad-t-izjăr; izjăr-t, izzăy ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ǝkkăsăn-dd inəṭṭulab ḍarăt-a-wen Ɣisa s-ăssaɣăt d-wăr ɣur-s t-illa ăwadəm s-takše, ənnăn-as: «Alšin-wənnin-hi, mafăl hanăɣ-indăr ad-t-nəkkəs dăɣ-alyaḍ?» ");
INSERT INTO taq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Innʼ-asăn: «Təmmətkit-i ija immun-năwăn a hawăn-igdălăn s-a-wen; ənnar wădden a-wen, ăssiilmădăɣ-kăwăn a-s afăl ogdăh immun-năwăn d-temătăwt ta tojărăt təmmətkit dăɣ-idommăn har tənnăm i-aḍaɣ-wa-dăɣ: ‹Haan dăɣ-edăgg wa hed, təddəkăd dihen›, ad-ăj a-wa has-tənnăm; ad-ăbas t-illa făw a hawăn-indarăn.  ");
INSERT INTO taq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Alšin daɣ šund wa-hi, wăr t-itəkkəs ar tamădilt n-Măssinăɣ d-ăẓum.» ");
INSERT INTO taq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ălwăqq wa dd-iqqăl Ɣisa d-inəṭṭulab-net teje ta n-Galila, innʼ-asăn: «Ăgg-ăgg-adəm, išwar ăttermăs, ijjəš ifassăn n-ăgg-adəm, ");
INSERT INTO taq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ad-əjən iman-net măšan, ašăl wa n-kăraḍ, ad-dd-inkăr jer-inəmmuttan.» Ǝnxăsăn iman n-inəṭṭulab a-s hasăn-innă a-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ijjăš Ɣisa d-inəṭṭulab-net taɣrəmt ta n-Qăfărnaxum ɣas, osăn-dd inarmasăn n-tiwse n-ehăn n-ămudd wa măqqărăn Bəṭrus, ənnăn-as: «Ajăn ălɣalim wa-năwăn, wăr-ihəkk tiwse ta n-ehăn n-ămudd wa măqqărăn?» ");
INSERT INTO taq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Innʼ-asăn Bəṭrus: «Ihakkʼ-et lab.» Ijjăš-dd Bəṭrus ehăn făll-Ɣisa ɣas, iššəšwăr-as Ɣisa, issəstăn-t, innʼ-as: «Ma torded Simyon, mi ilan s-ad-itəẓẓal tiwse i-imănokalăn n-ăddunya: ak imăjarăn meɣ kăl-ăkall a lanen s-ad-hasăn-əẓəlăn tiwse?» Innʼ-as Bəṭrus: «Imăjarăn.» ");
INSERT INTO taq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Innʼ-as Ɣisa: «Adiš kăl-ăkall, wăr tăn-təlzem. ");
INSERT INTO taq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ămăra, i-ad-wăr năqqen iɣăfawăn n-ăddinăt n-ehăn n-ămudd wa măqqărăn rammăsnen tiwse, ăkk ejănš, tərməsăd-dd dăɣ-s emăn iyyăn, tarəd emm-net, ad-dăɣ-s təjrəwăd ărriyal n-aẓrəf, təkkəsăt-t-dd, təẓləd fălla-năɣ năkk d-kăyy.» ");
INSERT INTO taq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ohăẓăn-dd inəṭṭulab Ɣisa ălwăqq-wen, ənnăn-as: «Ma ămoos ăwadəm wa ojărăn dăɣ-Təmmənəya n-Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iɣră-dd Ɣisa ara ənḍărrăn s-iman-net, ijʼ-e jere-săn, ");
INSERT INTO taq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","innʼ-asăn: «Ăssiilmădăɣ-kăwăn a-s a təkkăsăm wăr tutabăm, taləhəm d-aratăn, xăram-awăn ujəš n-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ere wa ăsrăsăn iman-net har alăh d-ara-wa-dăɣ, ənta a-s wa ojărăn dăɣ-Təmmənəya n-Măssinăɣ; ");
INSERT INTO taq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ere daɣ wa ăsbălălăn ara šund wa-dăɣ, dăɣ-ăddimmăt-in, năkk a ăsbălăl.» ");
INSERT INTO taq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Aratăn daɣ wi săr-i omănnen, ere hasăn-ămoosăn əssəbab n-tanməšrayt-dăɣ, ăwadəm-en, iššăm-as-in, ad-tətwăqqən tăhunt ta măqqărăt s-itəẓẓad ălkăma dăɣ-err-net, itwəjăr-in dăɣ-ider n-ejărew wa səmmăn, əkšən-t aman. ");
INSERT INTO taq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tamăskoyt ăddunya dăɣ-təssəba n-tinməšrayen ti dăɣ-s tajjănen făl-a-s, wăr t-illa əmmək făw s-mad-tăqqayəm ăddunya-ta-dăɣ wăr dăɣ-s ănmăšrăyăn ăddinăt, măšan, amăskoy ăwadəm wa madăn-umas əssəbab n-tanməšrayt-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kăyy, kunta ăfuss-năk meɣ aḍăr-năk a kăy-isifun abăkkaḍ, adiš, ənkăḍ-t-in, təjrəd-t-in fălla-k hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ, ed ufʼ-ak, ad-təjjəšăd ălžănnăt jeed ăfuss, meɣ aḍăr, uhən leed əssin ifassăn-năk d-əssin iḍarăn-năk, tətwəjărăd-in dăɣ-efew wa s-hărkuk ăhijăljăl; ");
INSERT INTO taq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","kunta daɣ tiṭṭ-năk a kăy-isifun abăkkaḍ, adiš, kukkərət-tăt-dd, təjrəd-tăt-in fălla-k hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ, ed ufʼ-ak, ad-təjjəšăd ălžănnăt jeed tiṭṭ, uhən ad-leed sănatăt tiṭṭawen, tətwəjărăd-in dăɣ-žohănnăma, temse ta s-hărkuk tăhijăljăl. ");
INSERT INTO taq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","He kăwăneḍ! Wăr lăkkăhăt wălʼ iyyăn dăɣ-aratăn-win-dăɣ ed ijmaḍ-t ăššăk a-s əbdadăn ănjălosăn-năsăn hak ăssaɣăt dat-Abba-nin-i ihăn išənnawăn i-ad-tăn wăr-itəḍḍis hărăt.  ");
INSERT INTO taq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ăgg-ăgg-adəm, osă-dd i-ad-iɣləs ăddinăt wi ăssujjălnen.» ");
INSERT INTO taq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Ad-kăwăn-səstənăɣ: ma tənnăm? Kunta ila ăwadəm temeḍe n-tehăle, har dăɣ-snăt tăssujjăl tiyyăt, ma he-ăj? Wădden ad-ăyy ti n-təẓẓayăt timərwen d-təẓẓayăt əfradnăt făll-tiḍaɣen, isəssəjjəl ta hin-oḍăn? ");
INSERT INTO taq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Afăl-tăt dd-ijrăw, ad-ăj tedăwit tojărăt ta ija a-s ila ti n-təẓẓayăt timərwen d-təẓẓayăt wăren ăssujjăl. ");
INSERT INTO taq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ǝmmək-wen-dăɣ daɣ a-s mad-ăddăwăt Abba-năwăn-i ihăn išənnawăn ed wăr-irha făw ad-iba wălʼ iyyăn ɣas dăɣ-aratăn-net. ");
INSERT INTO taq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Afăl kăy-iḍlăm ăŋŋa-k, ăkkʼ-e, səlmədăd-t s-a-wa hak-iɣšăd jere-wăn əssin-ewăn ɣas. Afăl hak-ăsjăd, adiš jed-t dăɣ-tabarăt ta tolăɣăt, wăr t-illa daɣ a iḍasăn temiḍt-năwăn ");
INSERT INTO taq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","măšan, afăl unjăy s-asjəd-hak, əqqəl-t-dd tăddewăd d-ăwadəm, meɣ əssin, dăɣ-təssəba n-ad-ăjjayhăn ăddinăt i-a-wa itawănnen iket-net ed ‹Hărăt iket-net, ufa ad-ila sănatăt meɣ kăraḍăt tijuhawen.› ");
INSERT INTO taq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Afăl jed a-wen-dăɣ uhən-dăɣ har ămăra-dăɣ, unjay s-asjəd-hawăn, sərrəwrəw-as s-ălkănisăt. Afăl has-təmməjrăd ălkănisăt har unjăy s-asjəd-has, umaset data-k šund ănăẓẓalim n-amăjar, meɣ šund ănarmas n-tiwse. ");
INSERT INTO taq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ăsidătteɣ-awăn a-s a-wa təkrădăm făll-ărori n-ăkall-i-dăɣ, ad-itwəkrəd ašăl wa ilkămăn, a-wa torăm daɣ făll-ărori n-ăkall-i-dăɣ, ad-ămar daɣ ašăl wa ilkămăn. ");
INSERT INTO taq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ăssiilmădăɣ-kăwăn daɣ a-s făll-ărori n-ăkall-i-dăɣ, edăgg dăɣ-ănmărḍăn əssin dăɣ-wăn făll-talɣa, a tămoos-dăɣ, har dălăn Abba-nin-i ihăn išənnawăn, ad-ăj a-wa dăɣ-s əttărăn ");
INSERT INTO taq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","făl-a-s edăgg iket-net dăɣ-ăžžimmăɣăn əssin, meɣ kăraḍ inəṭṭulab-in, dăɣ-ăddimmăt n-isəm-in, əlleɣ jere-săn.» ");
INSERT INTO taq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ohăẓ-t-dd Bəṭrus ălwăqq-wen, innʼ-as: «Ălɣalim! Har maniket ihăndăggan d-hi-təwar tenăšše i-ăŋŋa-ɣ hi-iḍallămăn? Ak, ajăn əgdăhăn əssa ihăndăggan?» ");
INSERT INTO taq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Innʼ-as Ɣisa: «Ăbo, wăr-ənneɣ har əssa ihăndăggan, a hak-janneɣ, naššʼ-as har əssayăt timərwen janen əssa inəḍfusăn.» ");
INSERT INTO taq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Issăɣlăy-tăn Ɣisa tangalt, innʼ-asăn: «Təmmənəya n-Măssinăɣ, tănifăqqa d-ămănokal dd-issăɣrăn ăddinăt wi irwăs i-ad-has-siḍənən a-wa tăn-irwăs, əẓəlăn-as. ");
INSERT INTO taq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Han isălan n-a-wen-dăɣ a-s dd-ittəlwăy ănaxdim-net iyyăn irwas aẓrəf-i-dăɣ ăjjen. ");
INSERT INTO taq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Măšan ma n-əmmək! Indăr-as ad-iẓəl aẓrəf-wen-dăɣ ɣas, omăr măssi-s s-ad-hin-ănš ənta d-hănne-s d-aratăn-net d-a-wa ila dăɣ-ilalăn iket-net i-ad-inmiwəḍ ənta d-ehăre-net. ");
INSERT INTO taq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Islʼ ănaxdim i-a-wen ɣas, ošăl s-măssi-s, irkăɣ dat-măssi-s, ad-t-ilaqqăd, ijannʼ-as: ‹Ya măssi-ɣ, əṣbăr făll-i tene-ta-dăɣ, təkfəd-ahi tăqqăn tăynayăt i-ad-hak-əẓəlăɣ ehăre-năk iket-dăɣ-net.› ");
INSERT INTO taq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tănɣa tăhanint-net măssi-s ɣas, ăsdărfăt, inšʼ-as-in a-wa t-irwăs iket-net. ");
INSERT INTO taq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Măšan, diha-dăɣ dd-izjăr ănaxdim-ənnin-dăɣ făll-măssi-s, ad-ămmoqqăs d-iyyăn dăɣ-imidiwăn-net dăr-ănnixdăm irwas hărăt n-aẓrəf, ăkbăttăt-t s-tăkorsăyt, oɣay-as, ijannʼ-as: ‹Ǝẓəl-ahi ehăre-in wa kăy-ihăn.› ");
INSERT INTO taq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Irkăɣ-as amidi-net, ad-t-ilaqqăd, ijannʼ-as: ‹Ǝṣbăr făll-i, ad-hak-əẓəlăɣ ehăre-năk.› ");
INSERT INTO taq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Unjăy s-ad-has-isəjəd, ilwăy-t, ăswăjjʼ-e dăɣ-takărmut i-ad-tăt-iha har has-iẓəl a-wa t-irwăs iket-net. ");
INSERT INTO taq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ǝnhăyăn inaxdimăn wi iyyăḍnen dăr-ănniixdăm a-wa ija amidi-năsăn ɣas, əknăn iman-năsăn tisnant, əglăn, jăn isălan n-a-wa ijăn iket-net dăɣ măssi-săn. ");
INSERT INTO taq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Issăɣrʼ-e-hi-dd măssi-s, innʼ-as: ‹Kăyy ănaxdim n-enăllăbăs a tămoosăd! Ajăn wădden təlɣădăd-ahi ɣas, oyyeɣ-ak-in a-wa kăy-ărwăsăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Adiš, ma hak-igdalăn, ad-taḍənăd tăhanint šund ta hak-oḍănăɣ i-amidi-năk?› ");
INSERT INTO taq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ijjăš-t aḍkăr hullan făll-akli-net-wen-dăɣ, issăɣră-dd gărdităn-net i-ad-t-in-əjărăn dăɣ-takărmut, ăqqayəm ihannăy dăɣ-s aɣăna har iẓəl a-wa t-irwăs has-in-oyya ihənnin iket-dăɣ-net.» ");
INSERT INTO taq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Innă daɣ ḍarăt-a-wen: «Ǝlmədăt a-s šund a-wen-dăɣ a hawăn-mad-ăj Abba-nin-i ihăn išənnawăn, afăl wăr tənmənšim jer-iman-năwăn s-ulh imdan.» ");
INSERT INTO taq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Issəmdă Ɣisa tənna n-isălan-win-dăɣ ɣas, ifăl teje ta n-Galila, ikkă tidbi ti hin-əllanen i-ejănš wa n-Ɣurdəni dăɣ-teje ta n-Ălyăhudəyăt; ");
INSERT INTO taq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","əlkămăn-as-dd ăddinăt ăjjootnen, ăzozăy dăɣ-săn wi ărhinnen. ");
INSERT INTO taq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dăɣ-a-wen-dăɣ ad-dd-əbdădăn kăl-faris iyyăḍ data-s, orămăn-t s-asəstan dăɣ-innă a wărăn itətwənn, ənnăn-as: «Dăɣ-a-wa innă alămăr-nănăɣ, ak ajăn xălal i-ăhaləs, ad-izəmməzzəy hănne-s făl-ăsaru, a ămoos-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ăwwežăb-asăn, innʼ-asăn: «Adiš kăwăneḍ wăr tăɣrem dăɣ-əlkəttab n-Măssinăɣ edăgg wa dăɣ-ătwănna a-s: ‹S-tizarăt a-s dd-ixlăk Ămaxlak ăddunya, ăhaləs d-tamăḍt a dd-ixlăk.› » ");
INSERT INTO taq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Innʼ-asăn daɣ: « ‹Təssəba n-a-wen-dăɣ a făl mad-ifəl ăhaləs ti-s d-ma-s, asăɣ d-hănne-s, umasăn făll-əssin-essăn, tiyyăt taɣəssa. ");
INSERT INTO taq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ad-ăbas ămoosăn əssin ăddinăt, ămoosăn tiyyăt taɣəssa.› A-wen-dăɣ a făl, a-wa osăɣ Măssinăɣ i-ad-umas iyyăn hărăt, wăr t-ibəḍḍəwet ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ǝnnăn-as: «Adiš mafăl ijanna ănnăbi Mosa a-s: ‹Afăl irha ăhaləs azəmməzzəy n-hănne-s, ilzam-t ad-tăt-ăkf tăkarḍe n-aməzzi təzzar, izəmməzzəy-tăt?› » ");
INSERT INTO taq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Innʼ-asăn Ɣisa: «A-wa hawăn-innă ănnăbi Mosa, innʼ-awăn-t dăɣ-təssəba n-tăɣart-i jăn ulhawăn-năwăn; ənnar wădden a-wen, s-tizarăt a-s dd-tăxlăk ăddunya, wădden a-wen a dd-ăzzăbbăt Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ăssiilmădăɣ-kăwăn a-s ere hin-ăzmăzzăyăn hănne-s a-s, ija a-wen, wădden tikra a has-təja, olăs adubən n-iyyăt, izna.» ");
INSERT INTO taq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ǝggădăn-dd inəṭṭulab-net, ənnăn-as: «Šămad a-wen-dăɣ a ijan, adiš, ufa ɣas, ăqqiima ăwadəm wăla adubən.» ");
INSERT INTO taq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Innʼ-asăn Ɣisa: «Wădden ăddinăt iket-năsăn a ăddobătnen ujreh n-măjrăd-wa-dăɣ, wi ikfa Măssinăɣ turhajăt-net ɣas, a t-jarrăhnen. ");
INSERT INTO taq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tidət, wădden ăddinăt iket-năsăn a əjrawnen turhajăt-ten-dăɣ n-ad-ăqqaymən wăr-ădobănăn: iyyăḍ, a-s dd-əwăn-dăɣ, əjrawăn s-a-wen; iyyăḍ, əgdălăn-asăn-t imidiwăn-năsăn-i tăn-jănen imudăšăn, əkkăsăn-tăn dăɣ-meddən; iyyăḍ daɣ, unjăyăn s-adubən dăɣ-təssəba n-Təmmənəya n-Măssinăɣ. Ere ăddoben ujreh n-măjrăd-wa-dăɣ, ijrăhet-t.» ");
INSERT INTO taq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ămmewăyăn-dd ḍarăt-a-wen aratăn s-Ɣisa i-ad-tăn-isəwăr ifassăn-net, ittăr-asăn dăɣ-Măssinăɣ a dăɣ-săn ijăn ălbăraka; ənhăyăn inəṭṭulab ăddinăt wi tăn-dd-ăwwăynen ɣas, ăklăwlăwăn fălla-săn. ");
INSERT INTO taq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iɣtăl-tăn Ɣisa, innʼ-asăn: «Ăyyăt aratăn ad-hi-dd-əkkən, wăr tăn-in-tăwweɣăm făll-i, făl-a-s, Təmmənəya n-Măssinăɣ, ăddinăt wi dăr-săn ănifăqqănen a-s tăt-ihakk.» ");
INSERT INTO taq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ăswăr-tăn ifassăn-net ḍarăt-a-wen, ija dăɣ-săn ălbăraka təzzar, ifăl edăgg-en. ");
INSERT INTO taq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Igla Ɣisa har šik-dăɣ ăhaləs iyyăn da-dăɣ t-dd-ikkăn, innʼ-as: «Ălɣalim, ma ămoos emărked wa s-leɣ s-ad-t-ăjăɣ i-ad-əjrəwăɣ tămudre ta tăɣlălăt?» ");
INSERT INTO taq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Innʼ-as Ɣisa: «Mafăl hi-sastanăd d-emărked s-tăddobed iji-net? Milɣaw, Măssinăɣ ɣas a olaɣăn. Ămăra, kunta tărhed ad-təjrəwăd tămudre tăynayăt, adiš, mašăl alămărăn n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Innʼ-as ămawaḍ: «Win-š alămărăn, ma ămoosăn?» Innʼ-as Ɣisa: «Ǝntăneḍ da: Wăr jed iman, wăr jed əzzəna, wăr tokerăd, wăr tăjjəyhăd s-bahu, ");
INSERT INTO taq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","səmɣăr ti-k d-ma-k, tărhəd anhăraj-năk s-tărha ta jed i-iman-năk.» ");
INSERT INTO taq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Innă ămawaḍ-en i-Ɣisa: «Ăɣdalăɣ i-a-wen-dăɣ iket-net; ma t-illan daɣ hin-oḍanăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Innʼ-as Ɣisa: «Kunta tărhed ad-dd-təmdəwăd s-iba n-ălɣib dat-Măssinăɣ, əgləw, tužžăr-in ehăre-năk, təkfəd-t i-tilăqqiwen i-ad-təkrəšăd ărrəzăɣ dăɣ-ălžănnăt; dihen, əqqəl-dd, əlkəm-ahi.» ");
INSERT INTO taq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Islʼ ămawaḍ i-a-wen-dăɣ ɣas, ənxăsăn iman-net, inkăr iglă ed a-wa ila dăɣ-ehăre, tikunen. ");
INSERT INTO taq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Innă Ɣisa ḍarăt-a-wen i-inəṭṭulab-net: «Ăsidătteɣ-awăn a-s iẓẓəwăt ad-ijjəš ere irzaɣăn Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ojăr tărăɣse ta ija ad-ijjəš amnəs s-tiṭṭ n-ănaẓmay uhən, ad-ijjəš ere irzaɣăn Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ǝslăn inəṭṭulab i-a-wen ɣas, əqqănăn iɣăfawăn-năsăn, ənnăn-as: «Adiš mi madăn-iɣləs?» ");
INSERT INTO taq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ikyăd dăɣ-săn Ɣisa, innʼ-asăn: «A-wen, wăr t-ăsmăkkănăn dăgg-adəm, măšan Măssinăɣ ənta, ăddoobăt-t ed wăr t-illa a has-indarăn.» ");
INSERT INTO taq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iggăd-dd Bəṭrus, innʼ-as: «Năkkăneḍ-i-š-i oyyănen a-wa nəla iket-net nəlkăm-ak, əndek isălan-nănăɣ, ma s-ilkam ad-t-nəjrəw?» ");
INSERT INTO taq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Innʼ-asăn Ɣisa: «Ăsidătteɣ-awăn a-s ašăl wa dd-mad-təzzubbət ăddunya-ta tăynayăt-i dăɣ-mad-ixkəm Ăgg-ăgg-adəm dăɣ-ălxurmăt-net făll-hărăt iket-net, ad-tăqqayməm kăwăneḍ-i hi-əlkămnen făll-mărawăt tisăqqima n-təmmənukəla d-sănatăt, təšrăɣăm tiwsaten ti n-mărawăt d-sănatăt n-Iṣrayil. ");
INSERT INTO taq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ere oyyăn ihănan-net d-ayətma-s d-šătma-s d-ti-s d-ma-s d-məddana-s d-išəkraš-net dăɣ-ăddimmăt-in, ilmədet a-s ad-ijrəw a-wa hin-oyyă ija temeḍe n-anəḍfus, ijrəw daɣ tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ălwăxla a-s a ăjjeen dăɣ-wi ăzzarnen ašăl-i-dăɣ, ad-ijjəš ajilal, a ăjjeen daɣ dăɣ-wi hănen ajilal ašăl-i-dăɣ, ad-izar.» ");
INSERT INTO taq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Issăɣlăy-tăn Ɣisa tangalt ḍarăt-a-wen, innʼ-asăn: «Təmmənəya n-Măssinăɣ, tănifăqqa d-ăhaləs ilan ašəkrəš-net; ăffăw-t ɣas, ifăl ehăn-net, immăɣ i-inaxdimăn issăxdăm ašəkrəš-net n-lăɣnăb. ");
INSERT INTO taq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ănmănnăk dăr-săn făll-timẓal n-ărriyal n-aẓrəf i-ašăl təzzar, ăssokʼ-en ašəkrəš-net i-ad-t-əxdəmăn. ");
INSERT INTO taq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ijʼ agdəlset ɣas, olăs azăjor, ijrăw iyyăḍ ăqqimnen ădiwănnen wăr-išla hărăt, iḍkăl-tăn; ");
INSERT INTO taq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","əntăneḍ-dăɣ, innʼ-asăn: ‹Ăglăt kăwăneḍ-dăɣ tăxdəmăm dăɣ-ašəkrəš-in wa n-lăɣnăb, ad-kăwăn-ăkfăɣ ălxaqq n-tide-năwăn›; ");
INSERT INTO taq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","əglăn, əxdămăn. Təjă tarăhut ɣas, olăs aḍkul n-iyyăḍ, olăs daɣ iji n-a-wen s-tezzar. ");
INSERT INTO taq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Təglă takkăṣt ɣas, izjăr daɣ, inhăy iyyăḍ əbdadnen wăr tăn-išla hărăt, innʼ-asăn: ‹Kăwăneḍ ma s-təbdadăm ašăl iket-net, wăr t-illa a kăwăn-išlan?› ");
INSERT INTO taq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ǝnnăn-as: ‹Wăr t-illa ere hanăɣ-ikfan əššăɣəl.› Innʼ-asăn: ‹Ăkkăt kăwăneḍ-dăɣ ašəkrəš-in, təxdəmăm dăɣ-s.› ");
INSERT INTO taq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Toḍă tăfukt ɣas, issăɣră-dd măssi-s n-ašəkrəš ănaẓraf-net, innʼ-as: ‹Ǝɣər-dd inaxdimăn, təẓləd-asăn, sănt s-wi dd-əšrăynen har təkkəd wi dd-ăzzarnen.› ");
INSERT INTO taq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ǝjrăwăn wi dd-osănen šămad təgla takkăṣt timẓal-năsăn; hak iyyăn ijraw ărriyal n-aẓrəf wa ămoosăn timẓal n-ašăl. ");
INSERT INTO taq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Osăn-dd ḍarăt-a-wen wi dd-ăzzarnen s-ălxidmăt ija ɣur-săn a-s, ad-ajărăn inaxdimăn-wi dd-əšrăynen timẓal măšan, əjrăwăn əntăneḍ-dăɣ ărriyal n-aẓrəf šund wa əjrăwăn inaxdimăn wi n-tišrayăt dăɣ-ălxidmăt. ");
INSERT INTO taq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ǝjrăwăn timẓal-năsăn ɣas, ăbjănjănăn făll-măssi-s n-ašəkrəš, ad-has-jannen: ");
INSERT INTO taq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Ajăn wădden inaxdimăn-wi dd-əšrăynen, iyyăn n-ăssaɣăt ɣas a jăn əxdamăn, a-s ija a-wen năkkăneḍ, ašăl imdan a nəja nəxdam, siknənniwət-anăɣ tăfukt. Ɣas əndek əmmək wa s-ila a-s ad-dăr-săn nagdăh timẓal?› ");
INSERT INTO taq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Innă măssi-s n-ašəkrəš i-iyyăn dăɣ-săn: ‹Amidi-nin, wăr-əkšeɣ ălxaqq-năk, wădden ărriyal n-aẓrəf a făll-nənnăfhăm, əkfeɣ-ak-t, ma tărhed daɣ? ");
INSERT INTO taq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ǝrməs ehăre-năk, təgləd. Ma dăɣ-kăy-ikma a-s ăsisăgdăhăɣ-kăy dăɣ-aẓrəf-in kăyy-i dd-ăzzarăn, tajjăd dăɣ-i erk asăwaḍ, d-wa dd-išrăyăn? ");
INSERT INTO taq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ajăn wădden a-wa ehăre-nin s-ăddoobeɣ ad-has-ăjăɣ a-wa s-ărheɣ. Ma dăɣ-kăy-ikma a-s olaɣăɣ?› » ");
INSERT INTO taq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Innă Ɣisa ḍarăt-a-wen: «Ǝlmədăt a-s s-əmmək-wen-dăɣ a-s ăddinăt wi hănen ajilal, ad-izarăn măšan, wi ăzzarnen, ad-əjjəšăn ajilal.» ");
INSERT INTO taq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ălwăqq wa d-irmăs Ɣisa tamdujt ta n-Yărussălam, ikkăs-dd inəṭṭulab-net s-takše, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ǝnhəywăt, năkkăneḍ-da-hi ăjoẓăynen, nəkka Yărussălam-i-dăɣ mad-ăttărmăs Ăgg-ăgg-adəm i-ad-ijjəš ifassăn n-imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt; ad-t-siḍəwən dăɣ-ăššăreɣa-năsăn, əɣtəsăn-as tamăttant, ");
INSERT INTO taq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","əjən-t dăɣ-ifassăn n-inəẓẓulam-i t-maden-ăj tekăškăšt, əjən dăɣ-s tiwit s-ebărtăk, əṣləbăn-t făll-tajəttewt i-ad-ămmăt măšan, ašăl wa n-kăraḍ ḍarăt tamăttant-net, ad-dd-inkăr jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Dăɣ-a-wen-dăɣ, ad-dd-tosa hănne-s n-Zăbdi Ɣisa, ənta d-məddana-s wi n-əssin, tărkăɣ data-s, tənnʼ-as tărha a dăɣ-s təttăr hărăt iyyăn. ");
INSERT INTO taq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Innʼ-as Ɣisa: «Ma tărhed?» Tənnʼ-as: «Ǝssin ilyaḍăn wi leeɣ, əntăneḍ da, ăjʼ-ahi ărkăwăl n-a-s ašăl wa dd-mad-tăqqəlăd dăɣ-Təmmənəya-năk, ad-săqqayməd iyyăn daw-aɣil-năk, săqqayməd wa iyyăḍăn daw-tăšalje-năk.» ");
INSERT INTO taq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ăwwežăb-as Ɣisa, innʼ-as: «Kăwăneḍ, wăr təssenăm a dăr-săstanăm. Ajăn năkk, kara n-tisnant wa s-ilkam ad-t-ăswăɣ, tăddoobem tesăse-net?» Ǝnnăn-as dăgg-Zăbdi: «Năddoobăt-t.» ");
INSERT INTO taq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Innʼ-asăn Ɣisa: «Tidət lab a-s ad-tənhəyăm ălɣizabăt šund wa mad-ənhəyăɣ măšan, dăɣ-isălan wi n-taɣimit daw-aɣil-in d-tăšalje-nin, wădden năkk a ihakkăn a-wen; Abba-nin a t-ihakkăn i-wi s-t-ăsmăjnăt.» ");
INSERT INTO taq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ǝslăn inəṭṭulab wi iyyăḍnen n-măraw i-a-wen ɣas, ijjăš-tăn ălhăm făll-ayətma-win-dăɣ n-əssin. ");
INSERT INTO taq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iɣrʼ-en-dd Ɣisa iket-năsăn s-iman-net, innʼ-asăn: «Təssanăm a-s imănokalăn ăxkămăn făll-kăl-ăkall-năsăn s-ăṣṣahăt; kăl-əlxəkum daɣ, wăr lămmeḍăn făll-kăl-ăkall ");
INSERT INTO taq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","măšan, kăwăweḍ, wăr jem a-wen; wa dăɣ-wăn irhăn mijraw, umaset ănaxdim i-imidiwăn-net, ");
INSERT INTO taq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ere dăɣ-wăn irhăn tăzert, umaset akli n-imidiwăn-net təzzar, ");
INSERT INTO taq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","s-əmmək wa s-Ăgg-ăgg-adəm, wăr dd-ămesăl s-ăddunya i-ad-has-əxdəmăn ăddinăt, ămešăl-dd săr-s i-ad-ixdəm ənta iman-net, ăkf iman-net, ămmăt i-ad-isəddărfət ăddinăt ăjjootnen dăɣ-ibăkkaḍăn-năsăn.» ");
INSERT INTO taq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","A-s dd-izjăr Ɣisa d-inəṭṭulab-net taɣrəmt ta n-Žărriko, təlkăm-as tamətte tăjjeet. ");
INSERT INTO taq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Igla har a ənḍărrăn, əssin iməddorɣal da-dăɣ, ăqqiimăn dăɣ-asălim n-zăbo wa dd-ija. Ǝslăn a-s Ɣisa a okayăn ɣas, ad-saɣăren, jannen: «Ya Ăgg-Dawəd, aḍən-anăɣ tăhanint!» ");
INSERT INTO taq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɣattăl-tăn tamətte i-ad-hin-susəmăn măšan, ăsɣăren dăɣ-išənnawăn: «Ya Ălɣalim, Ăgg-Dawəd, aḍən-anăɣ tăhanint!» ");
INSERT INTO taq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Islʼ-asăn Ɣisa, ibdăd, iɣrʼ-en-dd, innʼ-asăn: «Ma s-tărham ad-hawăn-t-ăjăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ǝnnăn-as: «Ălɣalim, arr tiṭṭawen-nănăɣ i-ad-nənhəy.» ");
INSERT INTO taq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tănɣʼ-e tăhanint-năsăn, iḍăs tiṭṭawen-năsăn, ămerănăt ăssaɣăt-wen-dăɣ, olăsăn ahănay; əlkămăn-as ḍarăt-a-wen. ");
INSERT INTO taq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ohăẓ-in Ɣisa d-inəṭṭulab-net Yărussălam, iha ămăra taɣrəmt ta n-Bătfaži, edes i-taḍaɣt ta tăsijătăt ihəškan wi n-əzzăytun, ăšmašăl əssin dăɣ-inəṭṭulab-net, ");
INSERT INTO taq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","innʼ-asăn: «Ăkkăt tadăbayt ta n-data-wăn, təjjašăm-tăt ɣas, ad-dăɣ-s təjrəwăm tešeḍt təkrafăt s-t-illa ăẓa-net edes-has; arăt-tăt-dd, təlwəyăm-ahi-tăt-dd ənta d-ăẓa. ");
INSERT INTO taq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ere hawăn-innăn hărăt, ănnăt-as: ‹Ălɣalim a dăɣ-săn ilan əššăɣəl,› afăl has-tənnăm a-wen, ad-hawăn-dd-ăyy tešeḍt hakd d-ăẓa-net.» ");
INSERT INTO taq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ămoos a-wen a ăssiitbătăn a-wa innă ănnăbi n-Măssinăɣ a-s innă: ");
INSERT INTO taq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ănnăt i-kăl-Yărussălam: Ǝnhəywăt, ikkʼ-iwăn-in ămănokal-năwăn, ikkʼ-iwăn-in s-əmmək wărăn inbej tiṭṭ, ešeḍ ɣas a inay ara n-tešeḍt ɣas a inay.» ");
INSERT INTO taq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ǝglăn inəṭṭulab, jăn a-wa hasăn-inna Ɣisa; ");
INSERT INTO taq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","wătăn-as-dd tešeḍt d-ăẓa-net, əstăjăn-asăn isəlsa-năsăn təzzar, inăy Ɣisa ăẓa. ");
INSERT INTO taq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ad-fattăɣ ya tamətte iket-net, isəlsa făll-tabarăt-ta ija, nakkăḍăn-dd iyyăḍ ileḍleḍăn dăɣ-ihəškan, sănsʼ-en-tăn dăɣ-zăbo-wa ija i-asəmɣar-net. ");
INSERT INTO taq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tăseɣărăt tamətte-ta has-tăzzarăt hakd ta has-təlkămăt, janna: «Ozana! Năkfet Măssinăɣ semɣar dăɣ-təssəba n-Ăgg-Dawəd, Ija Măssinăɣ ălbăraka dăɣ-wa dd-osăn dăɣ-isəm n-Emăli, Imɣaret isəm n-Emăli dăɣ-išənnawăn iket-dăɣ-năsăn!» ");
INSERT INTO taq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ijjăš-dd Ɣisa Yărussălam ɣas, ămramăr aɣrəm iket-dăɣ-net, hak ăwadəm-dăɣ, ibdad, ijanna i-amidi-net: «Ma ămoos ăwadəm-wa hanăɣ-dd-ijjăšăn?» ");
INSERT INTO taq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ad-janna tamətte ta təlkămăt i-Ɣisa: «A-wa Ɣisa, ănnăbi wa dd-ifălăn Năṣirăt ta n-Galila.» ");
INSERT INTO taq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ijjăš Ɣisa ḍarăt-a-wen ehăn n-ămudd wa măqqărăn ihăn Yărussălam, ad-dăɣ-s isattăɣ ăttužžar d-imăžănšan-năsăn, ăsbărăɣwăl tisəskar ti n-kăl-amăhaš n-iẓărfan, ijjar-in tisăqqima n-ăttužžar n-tidăberen, ");
INSERT INTO taq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","isattăɣ-tăn, ijannʼ-asăn: «Wădden iktab a-s, innă Măssinăɣ: ‹Ehăn-in, ad-umas ehăn n-tittar›; măšan kăwăneḍ jăm-t, tasəssihărt n-imăkrăḍăn.» ");
INSERT INTO taq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iha Ɣisa ehăn n-ămudd-en-dăɣ a-s t-dd-osăn iməddorɣal d-inəbdan, ăzozăy-tăn. ");
INSERT INTO taq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ǝggădăn aratăn hanen ehăn n-ămudd-en-dăɣ, ad-saɣăren, jannen: «Ozana! Năkfet Măssinăɣ semɣar dăɣ-təssəba n-Ăgg-Dawəd!» Ǝnhăyăn imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt tikunen-ti s-iket tănăt-ija, əslăn i-a-wa jannen aratăn ɣas, ijjăš-tăn ălhăm făll-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ǝggădăn-dd săr-s, ənnăn-as: «Ajăn kăyy, wăr səlləd i-a-wa jannen aratăn-wi-dăɣ?» Innʼ-asăn Ɣisa: «Sallăɣ-asăn.» Olăs, innʼ-asăn: «Ajăn wăr tăɣrem a-wa innă Măssinăɣ dăɣ-əlkəttab-net, a-s innă: ‹Imawăn n-aratăn d-imărkăsăn ad-dd-zajjăr təmmal i-Măssinăɣ.› » ");
INSERT INTO taq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ifăl Ɣisa edăgg-en ɣas, odwa tadăbayt ta n-Bitanya. ");
INSERT INTO taq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ăffăw, iqqăl Ɣisa Yărussălam dăɣ-a-s ălluẓ. ");
INSERT INTO taq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dăɣ-tekle-net, inhăy ahəšk n-ašar iɣtan dăɣ-asălim n-zăbo, ikkʼ-e-hi-dd măšan, wăr fălla-s ijrew ar ifărketăn, wăr t-hen aratăn. Imməjrăd i-ahəšk, innʼ-as: «Ija Măssinăɣ a-s wăr-ilkem ad-torawăd!» Ăqqur-in ahəšk-en s-iyyăt ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ǝnhăyăn inəṭṭulab a-wen ɣas, ăqqănăn iɣăfawăn-năsăn ad-jannen: «Ǝndek əmmək wa s-hin-ăqqur ašar wa-dăɣ s-iyyăt?» ");
INSERT INTO taq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Innʼ-asăn Ɣisa: «Ăsidătteɣ-awăn a-s afăl itbat immun-năwăn, wăr t-illa ăššăk t-ihan, ad-tudabem iji n-a-wa jeɣ i-ašar-wa-dăɣ, təgləm făw har afăl tənnăm i-aḍaɣ wa-dăɣ: ‹Tălbăy-dd dăɣ-edăgg wa hed, tăɣtəd dăɣ-ejărew wa səmmăn dihen›, ad-ăj a-wa tənnăm. ");
INSERT INTO taq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A dăɣ-dălăm Măssinăɣ s-ulh omanăn-dăɣ, ad-hawăn-t-ăkf.» ");
INSERT INTO taq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ijjăš Ɣisa ehăn n-ămudd wa măqqărăn, isaɣra tamətte dihen a-s t-dd osăn imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil, ənnăn-as: «Mi kăy-ikfăn turhajăt n-amišəl n-tikunen-ti-dăɣ? Mi kăy-ikfăn tărna-ta-dăɣ s-tăjjăd a-wa tăjjăd?» ");
INSERT INTO taq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Ad-hawăn-ăjăɣ năkk-dăɣ asəstan iyyăn, afăl hi-tăwwežăbăm, ad-hawăn-ăllăɣeɣ năkk-dăɣ ere wa hi-ikfăn turhajăt ta s-tamašalăɣ a-wa tăjjăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Innʼ-asăn: «Mi dd-ăšmašălăn Exya wa n-Enəsselmăɣ i-ad-isəlmăɣ ăddinăt dăɣ-aman? Ak Măssinăɣ a t-dd-ăšmašălăn meɣ dăgg-adəm ɣas?» Innʼ-asăn a-wen ɣas, əqqălăn-dd, ămmiizăɣăn jer-iman-năsăn, jannen: «Afăl has-nənna: ‹Măssinăɣ a t-dd-ăšmašălăn›, ad-hanăɣ-ănn: ‹Adiš, mafăl wăr tomenăm s-a-wa hawăn-innă.› ");
INSERT INTO taq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Afăl has-nənna daɣ dăgg-adəm ɣas a t-dd-ăšmašălnen, ad-fălla-năɣ tiḍəw tamətte-ta-dăɣ ed təkkas iket-net ăššăk a-s Exya ănnăbi n-Măssinăɣ a ămoos.» ");
INSERT INTO taq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ǝqqălăn-t-dd, ənnăn-as: «Wăr nəssen.» Innʼ-asăn Ɣisa: «Adiš năkk-dăɣ, wăr hawăn-e-ăllăɣeɣ ere wa hi-ikfăn tărna ta s-tăjjăɣ a-wa tăjjăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Innă Ɣisa ḍarăt-a-wen i-ăddinăt wi has-ăsijădnen: «Ma tənnăm dăɣ-tanfust-ta-dăɣ? Ătwănna, kăla t-illa ăhaləs ilan əssin aratăn. Ašăl iyyăn, iɣră-dd dăɣ-săn wa iššămăn, innʼ-as: ‹Alyaḍ-in, ašăl-i, ăkk ašəkrəš wa n-lăɣnăb, tăxdəmăn dăɣ-s.› ");
INSERT INTO taq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Innʼ-as rure-s, wăr-igla măšan, a ənḍărrăn ḍarăt-a-wen, ămmujrăẓ, ikkʼ ašəkrəš, ixdăm dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Iɣră-dd daɣ wa s-əssin, innʼ-as a ənnin-dăɣ innă i-wa ăzzarăn. Innʼ-as rure-s, igla măšan, a-s dd-təšrăy tanfust, wăr-igla. ");
INSERT INTO taq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ămăra, əndek dăɣ-săn wa ămešălăn erhet n-abba-net?» Ǝnnăn-as ăddinăt: «Un, wa ăzzarăn.» Innʼ-asăn Ɣisa: «Ăsidătteɣ-awăn a-s kăwăneḍ-i hannăyăɣ, ad-hawăn-izarăn kăl-tiwse d-tălkăxbaten ujəš n-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Exya, a-s kăwăn-dd-osa, issəknʼ-iwăn tabarăt ta n-iqqud măšan, tunjăyăm tomănăm s-a-wa hawăn-innă, a-s ija a-wen kăl-tiwse d-tălkăxbaten, omănăn săr-s; tăjjihăm i-a-wen-dăɣ iket-net măšan, wăr tătubăm, tamənăm s-a-wa hawăn-innă.» ");
INSERT INTO taq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Issăɣlăy Ɣisa tamətte tangalt tiyyăt dăɣ-innă: «Săjdăt! Kăla t-illa ăhaləs ilan təfărre-net, ijʼ-as afăraj, ija dăɣ-s ašəkrəš n-lăɣnăb, ija daɣ dăɣ-ašrut-net iyyăn, edăgg wa dăɣ-iẓimməw lăɣnăb, iday dăɣ-s edăgg n-soro i-ămagaẓ-net; ifăr-t ḍarăt-a-wen i-inəsduma iyyăḍ təzzar, ikkʼ ăkall iyyăn. ");
INSERT INTO taq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tăwwăḍ-dd tăqqăn n-amili n-ašəkrəš ɣas, ăšmašăl-dd s-inəsduma inaxdimăn-net, i-ad-has-dd-awəyăn folăt-net dăɣ-a-wa dd-orăw ašəkrəš; ");
INSERT INTO taq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","măšan, ănaxdim săr-săn dd-ăšmašăl-dăɣ, ad-t-ărməsăn, ad-tithəkken meɣ jăn iman-net meɣ t-əkfăn sămmăjori n-tihun. ");
INSERT INTO taq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Olăs-dd daɣ ašəmmišəl n-inaxdimăn iyyăḍ săr-săn, issəlkăm-asăn-dd daɣ i-ăjjootnen ojărnen wi săr-săn ăšmašăl s-tizarăt; jăn-asăn a ənnin-dăɣ jăn i-wi hasăn-dd-ăzzarnen. ");
INSERT INTO taq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A-s təšrăy tanfust, rure-s iman-net a săr-săn dd-ăšmašăl ed, inna dăɣ-iman-net: ‹Ǝnta ya i n-rure-ɣ, ănihăjja s-ad-t-səmɣărăn.› ");
INSERT INTO taq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Măšan, ənhăyăn inəsduma rure-s wa dd-imalăn ɣas, ănmănnăn jer-iman-năsăn: ‹Ǝnhəywăt-ak, amăkkasu-net; əyyăwăt, năjet iman-net i-ad-hanăɣ-dd-tăqqəl tăkasit-net.› ");
INSERT INTO taq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Osă-dd ɣas, ərmăsăn-t, əzjărăn dăr-s ašəkrəš, ănɣăn-t kərəf.» ");
INSERT INTO taq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Innʼ-asăn Ɣisa: «Ma tordam, wi-dăɣ inaxdimăn, ma hasăn-mad-ăj măssi-s n-ašəkrəš afăl tăn-dd-osa, ənta iman-net?» ");
INSERT INTO taq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ǝnnăn-as ăddinăt: «Adiš, afăl dd-osa iməkkərukaḍ-wi-dăɣ, wăr hasăn-e-aḍən tăhanint, ad-tăn-ilhəs iket-dăɣ-năsăn, aləs tefert n-ašəkrəš-net i-iyyăḍ t-e-əkfənen folăt-net afăl dd-ăwwăḍ ăzzăman wa n-amili n-ašəkrəš.» ");
INSERT INTO taq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Innʼ-asăn Ɣisa: «Adiš kăwăneḍ, kăla wăr tăɣrem edăgg wa innăn dăɣ-əlkəttab n-Măssinăɣ a-s: ‹Tăhunt ta hin-jărăn ălbănnatăn s-ənnăn wăr tənfa hărăt, ənta a-s a-s təšrăy tanfust, tămoos tăhunt ta tufăt n-aɣmăr hakkăt ăṣṣahăt ehăn; a-wen iket-net Măssinăɣ ad-t-ijăn i-ad-umas tăqqăn n-eɣăf dat-tiṭṭawen-nănăɣ.› » ");
INSERT INTO taq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Innʼ-asăn Ɣisa: «Janneɣ-awăn ămăra a-s dăɣ-təssəba n-a-wen-dăɣ a făl, Təmmənəya n-Măssinăɣ, ad-dăɣ-wăn tăttărmăs, tətwəkf i-tamətte tiyyăt madăt-tămašăl a-wa hasăn-tənnă dăɣ-erhet n-Măssinăɣ.»  ");
INSERT INTO taq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tăhunt-ta-hi, ere fălla-s oḍăn, ad-ărrăẓrăẓ; ere făll-toḍa daɣ, ad-t-təlkəẓ. ");
INSERT INTO taq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ǝslăn imănokalăn n-kăl-tikutawen d-kăl-faris i-tangalen-tin-dăɣ tăn-issăɣlăy Ɣisa ɣas, əlmădăn a-s əntăneḍ-en-dăɣ a-s iha ti-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ǝttărăn ad-t-ərməsăn măšan, ăksuḍăn tamətte ed, təkkas ăššăk a-s Ɣisa, ănnăbi a ămoos. ");
INSERT INTO taq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Issăɣlăy Ɣisa daɣ tamətte tangalen dăɣ-isălan n-Təmmənəya n-Măssinăɣ, innă: ");
INSERT INTO taq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Təmmənəya ta n-Măssinăɣ, ăddoobăt ăwadəm ad-tăt-isənnəfăqq d-tanfust n-ămănokal isidubunăn rure-s. Ašăl wa d-ităjj a-wen, ăsmăjarăt-dd ăddinăt ăjjootnen s-ehăn-net. ");
INSERT INTO taq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ămmujnăt-dd hărăt iket-net ɣas, ăšmašăl inaxdimăn-net s-ăddinăt wi dd-iɣra s-aẓli ašăl-wen-dăɣ; măšan, unjăyăn iket-dăɣ-năsăn s-ad-dd-asən. ");
INSERT INTO taq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Olăs săr-săn ašəmmišəl n-eklan săl winnin-dăɣ ăzzarnen, innʼ-asăn: ‹Ăglăt, ănnăt i-ăddinăt: tăwwăɣăm-ahi, imənsiwăn, ămmujnen, əssănɣăɣ-awăn a-wa iddăren iket-net jer-wa n-iwan hakd wa n-taɣsiwen; əyyăwăt šik, kăwăneḍ ɣas a-s iqqal aẓli ămăra.› ");
INSERT INTO taq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wăr jen teɣăre ta tăn-dd-ija hărăt, iglă hak iyyăn dăɣ-əššăɣəl-net: wa ikkăn ašəkrəš-net, wa ikkăn mamăla-net; ");
INSERT INTO taq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","əggădăn-dd iyyăḍ făw, ərmăsăn hărăt dăɣ-inaxdimăn wi dd-ăšmašăl ămănokal, ăsmăḍrăyăn iyyăḍ, jăn iman n-iyyăḍ. ");
INSERT INTO taq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ǝjjăšăn isălan ămănokal ɣas, ijjăš-t ălhăm, iɣră-dd ejhăn n-əssărdusa-net, issəglʼ-en i-ad-əlhəsăn imăjjan n-iman-win-dăɣ, səntəsăn aɣrəm-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Innă ḍarăt-a-wen i-inaxdimăn-net iyyăḍ: ‹Imənsiwăn wi n-aẓli, əskărăn-dd, măšan ăddinăt wi dd-ăsmăjareɣ săr-săn, wăr dăr-săn ănhăjjăn, ");
INSERT INTO taq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ăglăt ămăra, ilalăt tišarriten n-aɣrəm ti dăɣ-tažămmaɣăn ăddinăt, ere dăr-tămmoqqăsăm-dăɣ, səmməjurum-t-dd s-ehăn-in.› ");
INSERT INTO taq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ăllilăn inaxdimăn tišarriten iket-dăɣ-năsnăt, ăsdăwăn-dd a-wa əjrăwăn dăɣ-ăddinăt iket-net jer-wi n-erk ăddinăt hakd-dăɣ wi n-iməssorha, iḍnăy ehăn tamətte. ");
INSERT INTO taq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ijjăš-dd ămănokal făll-tamətte i-ad-tăt-isəbbărrək. Ăzjăzza tamətte, ijrăh-in a-s ihʼ-et ăhaləs wărăn ija isəlsa wi s-ănihăjja s-ad-tăn-ăj ere ihan aẓli, wăr-ăssahăɣ ašăl. ");
INSERT INTO taq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Issăɣrʼ-e-hi-dd, innʼ-as: ‹Măndam! Ǝndek əmmək wa s-dd-təjjăšăd edăgg-wa-dăɣ a-s wăr tăssahăɣăd ašăl?› Wăr t-illa a has-inna ăhaləs-en. ");
INSERT INTO taq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Inna ămănokal i-inaxdimăn-net iyyăḍ: ‹Ărməsăt-t, təkrədăm iḍarăn-net hakd ifassăn-net, təjrəm-t-in dăɣ-tihay ti n-ajăma i-ad-ihall, iẓiməkărkiẓ isenăn făl tămujriẓt.› ");
INSERT INTO taq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tidət, ătwăɣrăn-dd ăddinăt ăjjootnen măšan, wăr əjjətăn wi ənnəfrănnen.» ");
INSERT INTO taq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ănmăkkăsăn kăl-faris s-takše ḍarăt-a-wen, ad-tattărăn əmmək s-ăswănnăn Ɣisa a wărăn itətwənn i-ad-t-səttărməsăn. ");
INSERT INTO taq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ăšmašălăn-dd săr-s hărăt dăɣ-inəṭṭulab-năsăn ăddewnen d-iyyăḍ la taggayt ta n-kăl-Harudəs; osăn-t-dd, ənnăn-as: «Ălɣalim, nəssan a-s tidət ɣas a janned, wăr săɣrid ar tabarăt ta n-tuksəḍa n-Măssinăɣ, wăr tăkkulăd d-a-wa jănnen ăddinăt, wăr tăn-tăẓmăẓlăyăd; ");
INSERT INTO taq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ămăra, lăɣăt-anăɣ, dăɣ-a-wa hannăyăd: ak iwar-anăɣ ad-nəẓəl tiwse i-ămănokal wa măqqărăn Qăyṣăr meɣ?» ");
INSERT INTO taq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ilmăd Ɣisa ɣur-iman-net erk ənniyăt n-asəstan wa t-jăn ɣas, innʼ-asăn: «Ălmunafeɣăn yaden! Mafăl hi-tižărrubum?» ");
INSERT INTO taq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Innʼ-asăn ḍarăt-a-wen: «Săknăt-ahi-dd ărriyal n-aẓrəf wa s-təẓẓalăm tiwse», əkfăn-as-t-dd. ");
INSERT INTO taq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Innʼ-asăn: «Mi lăn ăṭṭăṣwer d-isəm wa t-iwărăn?» ");
INSERT INTO taq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ǝnnăn-as: «I n-ămănokal Qăyṣăr.» Innʼ-asăn: «Adiš, suɣəlăt i-ămănokal wa măqqărăn a-wa fălla-wăn ila, təkfəm daɣ Măssinăɣ a-wa fălla-wăn ila.» ");
INSERT INTO taq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iqqăn ălwižab-wen-dăɣ tăn-ikfa iɣăfawăn n-ăddinăt. Fălăn Ɣisa ḍarăt-a-wen, əglăn. ");
INSERT INTO taq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ašăl-wen-dăɣ iman-net ad-dd-əbdădăn data-s ăddinăt la taggayt ta n-kăl-sadus-i jannănen a-s wăr təlkem tanăkra jer-inəmmuttan, afăl ăba ăwadəm, əmdăn isălan-net; əssəstănăn-t, ");
INSERT INTO taq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ənnăn-as: «Ălɣalim, innʼ-anăɣ ănnăbi Mosa: ‹Afăl ădobăn ăhaləs, ăba-t wăr-oher ara d-hănne-s, idubənet-tăt ăŋŋa-s i-ad-ikrəš əzzurəyăt i-ăŋŋa-s wa ăba, i-ad-wăr hin-itiləm isəm n-wa ăba făll-ărori n-ăkall.› ");
INSERT INTO taq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ămăra, əkkəs-anăɣ dăɣ-tăqqăn n-eɣăf. Kăla hanăɣ-hăn əssa ayətma; ădobăn dăɣ-săn wa n-amăqqar, ăba-t wăr ikreš ara. Tăqqimă-dd hănne-s i-ăŋŋa-s wa has-ilkămăn ");
INSERT INTO taq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","măšan, ăba-t ənta-dăɣ wăr-oherăn ara, tăqqimă-dd i-wa s-kăraḍ ḍarăt-a-wen; təgla tanfust s-əmmək-wen-dăɣ har wa n-əssa. ");
INSERT INTO taq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ḍarăt iba-năsăn iket-năsăn, ăba tamăḍt ənta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Năssistăn-kăy: ašăl wa n-tanăkra jer-inəmmuttan, əndek dăɣ-əssa ayətma-win-dăɣ wa s-mad-tumas hănne-s ed, ənhayăn-tăt adubən iket-năsăn?» ");
INSERT INTO taq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Innʼ-asăn Ɣisa: «Tidət-dăɣ a-s kăwăneḍ toškam ed a-wa ənnăn əlkəttabăn hakd-dăɣ a-wa dăr-togdăh tărna n-Măssinăɣ, wăr t-illa a dăɣ-s təfhamăm. ");
INSERT INTO taq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ašăl wa ilkămăn, meddən hakd tiḍeḍen, ad-ăbas tidubunăn ed ad-talăh tămudre-năsăn d-ta n-ănjălosăn wi hănen išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ămăra, dăɣ-isălan wi n-tanăkra n-inəmmuttan, ajăn wăr tăɣrem a-wa hawăn-inna Măssinăɣ, a-s innă: ");
INSERT INTO taq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹Năkk a-s Măssinăɣ n-Ibrahim d-Isxaqq d-Yaqub›? A-wen, ălmăɣna-net a-s ăddinăt-win-dăɣ, han ălžănnăt, tiimələn Măssinăɣ; ənnăr wăr-ədderăn, wăr təjjən a-wen. Măssinăɣ, wădden inəmmuttan a-s ămoos Măssinăɣ, ămoos-t i-wi əddărnen.» ");
INSERT INTO taq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ijrăẓ a-wen-dăɣ issăɣra Ɣisa i-tamətte ta has-tăsijădăt. ");
INSERT INTO taq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ǝslăn kăl-faris i-əmmək wa s-ăssoḍăf Ɣisa kăl-sadus imawăn-năsăn ɣas, əžžəmmăɣăn-dd əntăneḍ-dăɣ săr-s. ");
INSERT INTO taq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iggăd-dd iyyăn dăɣ-săn n-ălɣalim n-Ăṭṭăwrăt, ija i-Ɣisa asəstan dăɣ-otas irrum-net. ");
INSERT INTO taq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Innʼ-as: «Ălɣalim, ma ămoos ɣur-Măssinăɣ alămăr wa ojărăn?» ");
INSERT INTO taq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Innʼ-as Ɣisa: «Alămăr wa ojărăn da: ‹Ad-tărhəd Emăli-năk Măssinăɣ s-ulh-năk imda, tărhəd-t s-iman-năk əmdan, tărhəd-t s-tayətte-năk iket-net.› ");
INSERT INTO taq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ǝnta-den-dăɣ alămăr wa ăzzarăn dăɣ-alămărăn, ənta daɣ a ojărăn dăɣ-alămărăn. ");
INSERT INTO taq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Illʼ-ee daɣ wa s-əssin wărăn dăr-s iẓley: ‹Ad-tărhəd ănhăraj-năk s-əmmək wa s-tărhed iman-năk.› ");
INSERT INTO taq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Alămărăn-win-dăɣ n-əssin a iṭṭafăn a-wa innă alămăr n-Măssinăɣ d-a-wa ənnăn ănnăbităn iket-net.» ");
INSERT INTO taq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Inhăy Ɣisa ažəmmăɣ wa fălla-s dd-jăn kăl-faris ɣas, issəstăn-tăn, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ak ma tordam, Ălmasex, mi iqqal? Mi s-ămoos Rure-s?» Ǝnnăn-as: «Dawəd.» ");
INSERT INTO taq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Innʼ-asăn Ɣisa: «Kunta Ălmasex rure-s n-Dawəd, adiš, mafăl has-ijanna Dawəd s-măjrăd ija Unfas Šăddijăn dăɣ-emm-net: ‹Emăli?› ");
INSERT INTO taq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dawəd en-dăɣ a imməjrădăn s-tărna n-Unfas Šăddijăn, innă: ‹Inna Emăli Măssinăɣ i-Emăli-nin: Ǝyyăw, ɣayəm daw-aɣil-in har ăjăɣ išənja-năk daw-iḍarăn-năk.› ");
INSERT INTO taq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ɣas kunta Dawəd iman-net iɣarr Ălmasex s-isəm ‹Emăli›, əndek əmmək wa s-ăddoobăt ad-umas rure-s?» ");
INSERT INTO taq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wăr tăn-ijješ ere t-ikfan ălwižab n-asəstan-wen-dăɣ hasăn-ija; ijrăw dăɣ-săn ălɣafyăt ɣur-ašăl-wen-dăɣ, ăbas t-illa-i dăɣ-săn ihălăn asəstan-net ḍarăt-a-wen. ");
INSERT INTO taq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iḍkăl Ɣisa măjrăd ḍarăt-a-wen, imməjrăd i-tamətte d-inəṭṭulab-net, innă: ");
INSERT INTO taq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ălɣulam n-Ăṭṭăwrăt d-kăl-faris a iwar ăttăfăssir n-Ăṭṭăwrăt ta n-Mosa i-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tamašalăt a-wa hawăn-jănnen iket-net, măšan, he kăwăneḍ, wăr təttəlălăm ijităn-năsăn făl-a-s a-wa jănnen, wăr-oher hărăt d-a-wa tajjăn. ");
INSERT INTO taq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tajjăn fărəḍăn n-Măssinăɣ ăẓuk sawarăn iẓerhan n-ăddinăt, šahăššalăn-tăn amišəl-năsăn, a-s ija a-wen, wăr tăn-iha ad-hasăn-ilalăn s-aggay-năsăn wăla-dăɣ s-emm n-assəkăḍ. ");
INSERT INTO taq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","A-wa tamašalăn iket-net, i n-təssəba ɣas n-ad-tăn-in-əjrăhăn ăddinăt, šallăjăn ikətban ojărnen wi n-ăddinăt, tajjăn isəlsa ăhobătnen, ");
INSERT INTO taq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ărhan taɣimit dăɣ-idăggan wi ănnuflăynen dăɣ-imjora d-ihănan n-ăddin wi n-kăl-Ălyăhud, ");
INSERT INTO taq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ijraẓ-asăn ad-hasăn-tajjăn ăddinăt isofan dăɣ-tišărriten, titwăɣrin s-isəm: ‹Ălɣalim, ălɣalim!› ");
INSERT INTO taq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kăwăneḍ, wăr jem a-wen, wăr tărḍem titwăɣrim s-isəm: ‹Ălɣalim› ed Ălɣalim-năwăn, iyyăn ɣas, kăwăneḍ, ayətmatăn a tămoosăm. ");
INSERT INTO taq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wăr tăɣrem ăwadəm wălʼ iyyăn s-isəm ‹Abba› ed Abba iyyăn ɣas a lam, a t-ămoosăn, Abba-năwăn wa ihăn išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wăr tărḍem ɣarrăn-kăwăn ăddinăt s-isəm: ‹Ămănokal›, ed wăr lem ar iyyăn n-Ămănokal, a t-ămoosăn: Ălmasex. ");
INSERT INTO taq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wa ojărăn dăɣ-wăn, umaset akli n-imidiwăn-net. ");
INSERT INTO taq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ere iḍkălăn iman-net-dăɣ, ad-irəs măšan, wa ăsrăsăn iman-net, ad-t-iḍkəl Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Ǝnhəywăt ɣas, kăwăneḍ a itiṭəbbun Təmmənəya n-Măssinăɣ i-ăddinăt; ălwăxla, a-s wăr tăt-təjjəšăm, ăddinăt daɣ wi ărhanen ujəš-net, gaddălăm-asăn s-a-wen.  ");
INSERT INTO taq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Kăwăneḍ a itihăɣăn a-wa ihăn ifassăn n-tinuḍăfen, tajjăm imaddăn šəjrootnen i-ad-kăwăn-in-əjrăhăn ăddinăt, ilkam dăɣ-wăn ăššăreɣa səmmăn. ");
INSERT INTO taq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Wăr t-illa edăgg wăr təkkəm făll-ăkall wăla făll-aman i-ad-dăɣ-s dd-təjrəwăm ăwadəm iyyăn ɣas jăm dăɣ-ăddin-năwăn măšan, igdăh-as ɣas ad-hawăn-ilkəm i-ad-t-səmmuttəyăm, umas, u-žohănnăma s-tojăr ămăra tăllăbăst ta ija ta jăm s-əssin ihăndăggan. ");
INSERT INTO taq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iməskay kăwăneḍ-i n-imalwayăn dărɣalnen. Jannem: afăl ihăḍ ăwadəm s-ehăn n-ămudd wa măqqărăn, wăr t-iwer ărkăwăl n-tahuḍe-net măšan, afăl ihăḍ s-orăɣ wa t-ihăn, iwar-t ărkăwăl n-tahuḍe ta ija. ");
INSERT INTO taq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tidət-dăɣ a-s irmas-kăwăn iba n-tayətte, dărɣalăm. Ajăn, ehăn n-ămudd wa măqqărăn, ma iẓlay d-orăɣ wa t-ihăn? Wădden təšədje-ta-dăɣ ija ehăn n-ămudd, a dd-torăwăt əlləllu wa ija orăɣ wa t-ihăn? ");
INSERT INTO taq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jannem daɣ: ere ihăḍăn s-isəm n-edăgg wa n-tikutawen, wăr t-iwer ărkăwăl n-tahuḍe-net măšan, afăl ihăḍ s-takute-ta tənsăt făll-edăgg-en, iwăr-t ărkăwăl n-tahuḍe ta ija. ");
INSERT INTO taq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Iməddorɣal yaden! Ajăn wădden tihusay n-edăgg wa n-tikutawen a ăshăsken takute ta fălla-s isănsa ăwadəm. ");
INSERT INTO taq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tidət a-s ere wa ihăḍăn s-isəm n-edăgg wa n-tikutawen, ihăḍ daɣ s-a-wa fălla-s insăn iket-net, ");
INSERT INTO taq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","wa ihăḍăn daɣ s-ehăn n-ămudd wa măqqărăn, adiš, Măssinăɣ-i n-Măssi-s n-ehăn-en a ihăḍ. ");
INSERT INTO taq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wa ihăḍăn s-išənnawăn, wădden tasăqqimit ta făll-ăminakăl Măssinăɣ a-s ihăḍ, Măssinăɣ iman-net a ihăḍ. ");
INSERT INTO taq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Hakkăm s-iqqud a-wa ămoosăn tămukăst-năwăn dăɣ-wăla ənnăɣnaɣ d-ăkamən d-tiyəššawen-ti iyyăḍnen măšan, tăsisăndărăm dăɣ-amišəl n-a-wa ifrăḍ alămăr dăɣ-isălan n-ălɣădalăt n-ulh, d-tăhanint, d-immun s-Măssinăɣ; hărătăn-win-dăɣ a-s ănihăjja a-s təssəntăm săr-săn, səlkəmăm-asăn amišəl n-wi iyyăḍnen olăɣnen. ");
INSERT INTO taq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imalwayăn dărɣalnen a tămoosăm, šănšašăm a-wa săssăm i-ad-wăr dăɣ-s dd-itaɣiməy wăla ešš iyyăn ɣas uhən-dăɣ, a-wa hin-sitrəjjim dăɣ-tisatten-năwăn, ogdăh d-amnəs təmɣăre. ");
INSERT INTO taq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Kannăm ašəšdaj n-afălla n-karatăn d-ikassăn-năwăn, a-s ija a-wen, ammas n-ulhawăn-năwăn, ixla; šašdajăm tiɣəswen-năwăn, a-s ija a-wen, ammas n-ulhawăn-năwăn, wăr-iḍney ar tikra d-əwwəli. ");
INSERT INTO taq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ya kăl-faris-i n-iməddorɣal, sirədăt ammas n-karatăn d-ikassăn-năwăn i-ad-išdajăn təzzar, ad-saradăm afălla-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Tolăhăm ɣas d-tiẓəska wăššarnen s-ăshăskăt ăwadəm afălla-năsnăt, a-s ija a-wen, ammas-năsnăt, wăr t-iha ar iɣăsan n-măɣsoy d-mărkăhaw isamăḍasăn. ");
INSERT INTO taq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ǝnta-den-dăɣ a-wa dăr-toolăhăm; saknem ăddinăt ălmăt a-s tăɣdalăm, a-s ija a-wen, ammas n-ulhawăn-năwăn, wăr-iḍney ar təlmənufăɣa d-tăxărme. ");
INSERT INTO taq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt d-kăl-faris, ălmunafeɣăn yaden! Kăwăneḍ a salmadnen ăddinăt s-idăggan wi dăɣ-əẓkăn ănnăbităn, sahaskem iẓəkwan wi n-imaɣdalăn wi n-ibda ăba; ");
INSERT INTO taq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","išlʼ-iwăn a-wen-dăɣ măšan, jannem: ‹Ǝnnăr nəzzaɣ dăɣ-ăzzăman n-abbatăn-nănăɣ, wăr dăr-săn nətumas imăjjan n-iman n-ănnăbităn-wi s-əssănɣălăn ašni-năsăn.› ");
INSERT INTO taq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jannen a-wen-dăɣ uhən-dăɣ wăr hin-təjrehăm a-s asətbat ɣas a tajjăm n-a-s, tămoosăm ihăyawăn n-abbatăn-năwăn-wi janen iman n-ănnăbităn. ");
INSERT INTO taq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","A-wa əssəntăn abbatăn-năwăn ɣas a hin-samdem. ");
INSERT INTO taq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Taššălen a tămoosăm, wăr təẓleyăm d-tanăɣwăt. Lăɣătăt-ahi ɣas əndek əmmək wa s-mad-tăɣləsăm dăɣ-žohănnăma? ");
INSERT INTO taq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dăɣ-təssəba n-a-wen-dăɣ a făl săr-wăn-in-ăšimăšălăɣ hărăt dăɣ-ănnăbităn d-iməssorha d-ălɣulam n-Ăṭṭăwrăt; ad-təjəm iman n-iyyăḍ, təṣləbăm iyyăḍ, təjəm tiwit s-ibărtăkăn dăɣ-iyyăḍ dăɣ-ihănan n-ăddin-năwăn, tăqquzzəbum iyyăḍ s-aɣrəm-aɣrəm ");
INSERT INTO taq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","i-ad-dăɣ-wăn əḍmənăn iman n-e d t-illăm ămaɣdal s-jam iman-net bănnan făll-ărori n-ăkall-i-dăɣ, ɣur-ašni n-Xăbălla wa n-ămaɣdal ăba hundăɣ har ašni n-Zăkărya wa n-ăgg Bărăyka-i s-ătwăjjăn iman-net jer-edăgg wa šăddijăn ihăn ehăn n-ămudd wa măqqărăn d-edăgg wa dăɣ-raqqănăt tikutawen. ");
INSERT INTO taq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ăsidătteɣ-awăn a-s ăddinăt-win-dăɣ ăba, əḍmanăn iman-năsăn dăɣ-kăl-əzzurəyăt-ta-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Innă Ɣisa ḍarăt-a-wen: «Yărussălam, ya Yărussălam! Tamăskoyt kămm-i tăjjăt iman n-ănnăbităn, hakkăd sămmăjori n-tihun inəmmušal wi săr-m dd-ăšmašăl Măssinăɣ, əndek ɣas a-wa-dăɣ wăr jeɣ dăɣ-utăr n-asdu n-imuzăɣăn-năm šund a-wa tăjj tekăzzit i-ikărtăn-net daw-tafriwen-net măšan, təssəndărăm-ahi. ");
INSERT INTO taq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ămăra, ənhəywăt, isălan əmdăn, ad-kăwăn-ăyy Măssinăɣ d-iman-năwăn, umas ehăn-năwăn timšar. ");
INSERT INTO taq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ăssiilmădăɣ-kăwăn, wăr t-ihʼ ăššăk a-wen, ăbas ilkam ad-hi-tənhayăm hundăɣ har ašăl wa d-mad-taləsăm tənna n-a-s: ‹Naməlet wa dd-osăn s-isəm n-Emăli!› » ");
INSERT INTO taq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ălwăqq wa d-ifăl Ɣisa ehăn n-ămudd wa măqqărăn, ohăẓăn-t-dd inəṭṭulab-net, ăddoqqen-as tihusay n-akăros wa ija ehăn n-ămudd wa măqqărăn. ");
INSERT INTO taq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Islă i-təmmal ta tăjjăn i-ehăn-en ɣas, innʼ-asăn: «Wădden hannăyăm tihusay n-edey-wa-dăɣ? Ăsidătteɣ-awăn a-s ilkam ašăl d-wăr mad-dăɣ-s dd-tăqqayəm wăla-dăɣ tăhunt tiyyăt warăt tamidit-net ed, ad-ăttăɣtăɣ iket-dăɣ-net.» ");
INSERT INTO taq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ikkă Ɣisa ḍarăt-a-wen taḍaɣt ta tăssidwălăt ihəškan wi n-əzzăytun, ăqqima. Ohăẓăn-t-dd inəṭṭulab-net, ənnăn-as dăɣ-tenere n-iman-năsăn: «Ălɣalim, lăɣăt-anăɣ, hărătăn-win-dăɣ s-tənned, əmme d-mad-əjən? Ǝkkəs-anăɣ dăɣ-taɣdărt n-išmal n-uɣəl-năk d-tăməddawt n-ăddunya.» ");
INSERT INTO taq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «He kăwăneḍ, ăjăt ənniyăt; wăr kăwăn-išăšket ăwadəm wălʼ iyyăn ");
INSERT INTO taq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","făl-a-s, ad-kăwăn-dd-asən ăddinăt ăjjootnen ăwwaynen isəm-in, ănn hak iyyăn dăɣ-săn: ‹Năkk a-s Ălmasex›, šiškən s-a-wen-dăɣ ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ad-təsləm i-isălan n-imjărăn d-măhewəl n-imjărăn, wăr tăxwelăm ed ilzam ad-ăj a-wen măšan, sămdo n-ăddunya ənta, wăr-ija hărwa. ");
INSERT INTO taq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ad-təknəs tawset tamidit-net, iknəs əddəwəl amidi-net, ăj laẓ, iškəḍkəḍ ăkall dăɣ-idăggan ăjjootnen, ");
INSERT INTO taq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","sănto n-tăməddawt n-ăddunya ɣas a-wa, olăh d-sănto n-tiẓẓurt ta rămmăsăt tamăḍt s-išwar təjraw eɣăf-net. ");
INSERT INTO taq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ad-kăwăn-ăqqəzzəbun ăddinăt, əjən iman-năwăn kərəf, akəḍnăt dăr-wăn tiwsaten iket-dăɣ-năsnăt, dăɣ-ăddimmăt n-isəm-in wa kăwăn-iwarăn. ");
INSERT INTO taq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ad-təjməḍ tuksəḍa n-Măssinăɣ ulhawăn n-i ăjjootnen dăɣ-wăn, tənmăɣdărăm jer-iman-năwăn, tənməkyəḍăm jer-iman-năwăn, ");
INSERT INTO taq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","asən-dd ănnăbităn n-bahu ăjjootnen, šənnəməšrəyăn ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ad-ăj iba n-iqqud təmɣăre ta-dăɣ făl ad-tismaḍ tărha n-Măssinăɣ dăɣ-ulhawăn n-ăddinăt ăjjootnen ");
INSERT INTO taq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","măšan, ere wa ăkoyădăn dăɣ-alkum-hahi dăɣ-immun-net har ašăl wa d-imda a-wen-dăɣ iket-net, ad-iɣləs. ");
INSERT INTO taq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ad-ətwəjjən isălan n-Ălənžil n-Təmmənəya n-Măssinăɣ i-tiwsaten n-ăddunya iket-dăɣ-năsnăt i-ad-əslənăt i-isălan-win-dăɣ təzzar, təmdəw ăddunya.» ");
INSERT INTO taq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Inna Ɣisa daɣ: «Afăl ašăl wa d-tənhăyăm ănabxas wa n-eməkkărekăḍ s-innă ănnăbi Danyăl har dd-ijjăš edăgg wa šăddijăn ihăn ehăn n-ămudd wa măqqărăn ad-t-isamăḍas, ašăl-en, ăwadəm wa iɣarrăn isălan-wi-dăɣ, ijrăhet ălmăɣna-năsăn! ");
INSERT INTO taq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ašăl-en, wi hănen teje ta n-Ălyăhudəyăt, jawăḍnet dăɣ-azzal s-ašrut wa n-iḍaɣăn; ");
INSERT INTO taq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","wi dd-ogăẓ ašăl-en əwarăn afălla n-ihănan, wăr dd-təzəbbutnet i-ad-əḍkəlăn a hasăn-ihan ammas n-ehăn, jawăḍnet dăɣ-azzal. ");
INSERT INTO taq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wi dd-ogăẓ ašăl-en han išəkraš, wăr dd-tăqqălnet ḍara-săn i-ad-əḍkəlăn isəlsa-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Timəskay tiḍeḍen ti mad-ijrəw ašăl-en-dăɣ lanăt ənniyăt meɣ siḍuḍnăt, ed ad-tăẓẓăwăt talɣa-năsnăt. ");
INSERT INTO taq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ǝttărăt dăɣ-Măssinăɣ ad-wăr itəmzəyyit ajiwəḍ-năwăn d-ăzzăman wa n-akăsa meɣ tajrəst meɣ d-ašăl n-əssəbət-i n-tăsonfat. ");
INSERT INTO taq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ăzzăman-en, ad-tăj tissust tăssuksăḍăt s-ad-dd-tăxlăk ăddunya-dăɣ, wăr kăla ătiwănhăy šund ənta făll-ărori n-ăkall; ad-təmdəw ăddunya daɣ, wăr-ilkem ad-ija a dăr-s olăhăn. ");
INSERT INTO taq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Afăl wăr-ifneẓ Măssinăɣ dăɣ-tăqqăn n-tisnant ta hăt išilan-en-dăɣ, wăr t-illa ere madăn-iɣləs; măšan ad-išəkšəl Măssinăɣ tăqqăn n-tiẓẓurt-ten-dăɣ dăɣ-təssəba n-ăddinăt wi ăsnăfrăn i-əlɣəllas. ");
INSERT INTO taq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dihen, afăl hawăn-innă ăwadəm: ‹Ǝnhəywăt-t-ak Ălmasex, ənta da› meɣ: ‹Ǝnta den›, wăr t-təflesăm. ");
INSERT INTO taq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ad-dd-asən ălmasexăn n-bahu d-ănnăbităn n-bahu, əjən ijităn d-hărătăn ăssuksăḍnen, šiškən ənnăr ămmukkăn a-wen wăla ăddinăt wi ăsnăfrăn Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","He kăwăneḍ, əkkasăɣ-kăwăn dăɣ-taɣdărt hărwa wăr jen hărătăn-win-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ere hawăn-innăn: ‹Ǝnhəywăt, Ălmasex wa n-Ămaɣlas, osă-dd, iha tenere-ta›, wăr təkkem dihen; meɣ daɣ afăl hawăn-ătwănna: ‹Ihʼ ehăn iyyăn dihen›, wăr t-təflesăm. ");
INSERT INTO taq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ăgg-ăgg-adəm, ad-alăh ass-net d-essam-i s-e-d issăm dăɣ-emăynăj, ad-itwənhəy asmăɣmăɣ-net dăɣ-atăram. ");
INSERT INTO taq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dihad t-təlla tamăɣsoyt, ad-itajj ellay.» ");
INSERT INTO taq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ăssewăḍ Ɣisa făll-a-wen, innă: « ‹Təmda ɣas tisnant n-išilan-win-dăɣ, ad-əlsənăt tihay tăfukt, iba təməlle n-ewăr; ətrəkken-dd etran, ənhəynəhəyăn iməṣṣuha wi hănen išənnawăn.› ");
INSERT INTO taq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ălwăqq-wen-dăɣ, a dd-e-tənfiləl tamătart ta sălmadăt s-ass n-Ăgg-ăgg-adəm dăɣ-išənnawăn, ad-šoršənăt tiwsaten ti wărnen ărori n-ăkall, ad-t-ənhəynăt, imal-dd, inay tijărăken, təlkam-as tărna-net d-ălxurmăt-net. ");
INSERT INTO taq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dihen, ad-išəmmišəl ănjălosăn-net i-ad-săhəḍăn tăsinsăɣt s-afălla, sədwən-dd săr-s e d t-illăm ere ăsinăfrăn Măssinăɣ dăɣ-e d t-təllăm tamdujt, səntən dăɣ-ašrut iyyăn, səmdəwăn-dd s-ašrut wa iyyăḍăn.» ");
INSERT INTO taq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Səjrăhăt ɣas əmmək wa s-idaggăl ašar: wădden e-d t-tənhăyăm a-s dd-inšăr har lămmeḍăn ifărketăn-net, ad-tənnəm, osʼ-anăɣ ăzzăman wa olăɣăn; ");
INSERT INTO taq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","əmmək-wen-dăɣ daɣ a-s afăl tənhăyăm išmal-wi-dăɣ s-hawăn-ənneɣ har jăn, adiš əlmədăt a-s Ăgg-ăgg-adəm, ohăẓ-dd uɣəl-net, osʼ-iwăn făw. ");
INSERT INTO taq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ăsidătteɣ-awăn a-s wăr-e takəy əzzurəyăt-ta-dăɣ, wăr jen hărătăn-win-dăɣ s-hawăn-ənneɣ iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ojăr tărăɣse ija ad-ibʼ išənnawăn d-ăkall, uhən ad-iba tənna-nin.» ");
INSERT INTO taq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Innă Ɣisa daɣ ḍarăt-a-wen: «Ămăra, dăɣ-isălan n-ašăl d-ăssaɣăt wa d-mad-əjən hărătăn-win-dăɣ, wăr t-illa ere t-issanăn; wăr t-əssenăn ănjălosăn wi hănen išənnawăn wăla Ăgg-ăgg-adəm; Abba ɣas, a t-issanăn. ");
INSERT INTO taq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ass n-Ăgg-ăgg-adəm, ad-alăh a-wa dăɣ-s-e-ijən d-a-wa ijăn dăɣ-išilan wi n-ănnăbi Nox. ");
INSERT INTO taq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ăzzăman wa n-Nox, dat-anji wa n-ḍuf, tayăwanăn ăddinăt, sassăn, tidubunăn, sidubunăn har ašăl wa d-ijjăš Nox turăft n-aman ta măqqărăt s-has-innă Măssinăɣ ad-tăt-ikən. ");
INSERT INTO taq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wăr t-illa a-s tăn-ha tijya-net har fălla-săn dd-oḍăn aman wi n-anji wa n-ḍuf, olăm-tăn-in iket-dăɣ-năsăn. Šund a-wen-dăɣ ijăn a madăn-ăj ašăl wa dd-mad-dd-ass Ăgg-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ašăl-en, ad-ăddewăn əssin meddən dăɣ-tenere, ămmăḍkăl iyyăn, itwəyy-dd iyyăn, ");
INSERT INTO taq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ad-taddăhnăt sănatăt tiḍeḍen dăɣ-iyyăn edăgg, tammăḍkăl tiyyăt, tətwəyy-dd tiyyăt. ");
INSERT INTO taq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","A-wen-dăɣ a făl, ɣaymăt tokayăm ed wăr təssenăm ašăl n-ass n-Emăli-năwăn. ");
INSERT INTO taq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wădden kăwăneḍ iman-năwăn təssanăm a-s ənnăr issan măssi-s n-ehăn ălwăqq wa s-t-dd-itis emăkrăḍ s-ehăḍ i-ad-ărẓ ehăn-net, iket-di, wăr-itəṭṭəs i-ad-has-ărẓ emăkrăḍ ehăn-net. ");
INSERT INTO taq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A-wen-dăɣ a făl, ɣaymăt tăsidăwăm, tăɣtafăm ed, Ăgg-ăgg-adəm, ad-dd-ass s-ăssaɣăt d-wăr fălla-s jem. ");
INSERT INTO taq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ănaxdim wa n-ămaɣdal ijrăhăn hărăt, ənta a mad-isăɣləf măssi-s təla-net i-ad-ănnihăḍ făll-inaxdimăn-net wi iyyăḍnen, isamănsaw-tăn e-d ija ălwăqq n-a-wen. ");
INSERT INTO taq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tənḍəḍ i-ănaxdim wa mad-ijrəw măssi-s ăddunkăt dăɣ-ălxidmăt wa dăɣ-t ija, ălwăqq s-t-dd-osa-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ăsidătteɣ-awăn a-s ănaxdim-en, ad-t-isăɣləf măssi-s təla-net iket-net, ");
INSERT INTO taq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","măšan, erk ănaxdim ənta, ad-ănn dăɣ-iman-net: ‹Năkk, măssi-ɣ, ăhoja-hin făll-i, ăbas dd-iqqal›, ");
INSERT INTO taq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ad-iḍannăy imidiwăn-net wi iyyăḍnen tiwit, itatt, isass ənta d-imăswan n-əlxəmăr, ");
INSERT INTO taq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ănaxdim-wen, ilkam ad-t-dd-iɣdăr măssi-s dăɣ-ašăl d-ăssaɣăt d-wăr fălla-s ija, ilməd s-erk əššăɣəl wa t-išlăn a ija a-wa-dăɣ, ");
INSERT INTO taq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","afăl t-dd-osa, ad-t-iqquzzəbət, isărtəy-t d-ălmunafeɣăn dăɣ-tihay ti n-ajăma wăr-iha ar tahăla d-aẓəmmăkărkəẓ n-isenăn făl tămujriẓt.» ");
INSERT INTO taq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ija Ɣisa i-ăddinăt tangalt tiyyăt daɣ dăɣ-hasăn-innă: «Təmmənəya ta n-Măssinăɣ, tănifăqqa d-mărawăt timawaḍen wăren əzzey meddən əḍkălnen tiftəl-năsnăt s-ehăḍ i-ad-əlkəḍnăt i-ămaẓlay s-edăgg-wa-dăɣ ităjj aẓli. ");
INSERT INTO taq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Səmmosăt dăɣ-timawaḍen-tin-dăɣ, ijraw-tănăt iba n-tayətte, səmmosăt ti iyyăḍnen, timəssorha. ");
INSERT INTO taq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ălwăqq wa d-gilləwnăt, əḍkălnăt ti ijrăw iba n-tayətte tiftəl-năsnăt măšan, wăr dăɣ-snăt jenăt aman n-kărănžil hasnăt-əgdăhnen. ");
INSERT INTO taq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ti n-timəssorha əntănăteḍ, jănăt aman dăɣ-butəlăn s-edes, ăwwăynăt-tăn. ");
INSERT INTO taq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ad-simăqqulnăt ya ḍarăt a-wen i-ămaẓlay. Tăqqălnăt-as, tăqqălnăt-as har ălḍăšnăt, ilɣăd-tănăt-in eḍəs iket-năsnăt. ");
INSERT INTO taq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Šămad iglʼ ehăḍ ad-ija eɣări innăn: ‹Ămaẓlay ya, iwwăḍ-dd, səlkəḍăt-as.› ");
INSERT INTO taq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ǝnkărnăt-dd timawaḍen iket-năsnăt, əḍkălnăt tiftəl-năsnăt. ");
INSERT INTO taq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ǝggădnăt-dd ti ijrăw iba n-tayətte, ənnănăt i-ti n-timəssorha: ‹Năkkănăteḍ ya, tiftəl-nănăɣ, išwar ămmutnăt, ăkfəmăt-anăɣ-dd hărăt n-aman.› ");
INSERT INTO taq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ǝnnănăt-asnăt ti n-timəssorha: ‹A făw, wăr năddobăt ed a-wa nəṭṭaf dăɣ-aman, wăr hanăɣ-igdeh iket-nănăɣ, ăkkəmăt u-mamăla, žănšəmăt-dd aman i-iman-năkmăt.› ");
INSERT INTO taq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ǝglănăt i-ad-dd-žənšənăt aman, osă-dd ămaẓlay ḍara-snăt. Ănmăjjašnăt dăr-s ti n-timəssorha ăsdăwnen i-a-wen, ammas n-ehăn təzzar, ăṭṭubben ishar n-edăgg. ");
INSERT INTO taq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A ənḍărrăn ḍarăt-a-wen, əqqălnăt-dd ti ijrăw iba n-tayətte, ad-takăwkawnăt ashăr, jannenăt: ‹Măndam, măndam! Arr-anăɣ-in emm n-ehăn.› ");
INSERT INTO taq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Măšan, innʼ-asnăt măssi-s n-edăgg: ‹Ălɣafyăt-năkmăt, wăr kămăt-əzzeyăɣ.› » ");
INSERT INTO taq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Innă Ɣisa ḍarăt-a-wen i-inəṭṭulab-net: «A-wen-dăɣ a făl, ɣaymăt tokayăm ed wăr təssenăm ašăl wălʼ ăssaɣăt wa s-dd-mad-dd-ass Emăli.» ");
INSERT INTO taq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Olăs daɣ Ɣisa, innă: «Təmmənəya n-Măssinăɣ, tănifăqqa d-isălan n-ăhaləs iyyăn dd-ijjăš ənniyăt n-asikəl, ăssawăḍ tekle ɣas, issăɣră-dd inaxdimăn-net, ijʼ ehăre-net iket-net jer-ifassăn-năsăn i-ad-săr-s ăxdəmăn; ");
INSERT INTO taq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ikfʼ-iyyăn səmmos ibəlɣan n-orăɣ, wa iyyăḍăn, ikfʼ-e əssin ibəlɣan, wa s-kăraḍ, ikfʼ-e iyyăn n-ablăɣ; hak iyyăn-dăɣ, ikfʼ-e s-a-wa dăr-togdăh tardast-net təzzar, ăssokăl. ");
INSERT INTO taq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Šik-dăɣ a-s hin-ămmummălăt wa n-səmmos ibəlɣan, orăɣ-net, irbăx fălla-s səmmos ibəlɣan iyyăḍ. ");
INSERT INTO taq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wa n-əssin daɣ, ija šund a-wen-dăɣ, irbăx făll-wi-net, əssin iyyăḍ daɣ. ");
INSERT INTO taq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wa n-iyyăn n-ablăɣ n-orăɣ, iglă, iɣăš-as anu, təzzar inbăl dăɣ-s a-wa t-ikfa măssi-s. ");
INSERT INTO taq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ăhoja-hin măssi-săn dăɣ-asikəl har ašăl wa dd-iqqăl; osă-dd ɣas, iɣră-dd inaxdimăn-net i-ad-has-əjən ălmeḍan n-a-wa tăn-issăɣlăf. ");
INSERT INTO taq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Os-e-hi-dd wa n-səmmos ibəlɣan n-orăɣ, ăwway daɣ səmmos ibəlɣan wi dd-irbăx; inna i-măssi-s: ‹Măssi-ɣ, səmmos ibəlɣan n-orăɣ wi hi-təssăɣlăfăd, əntăneḍ da, ărbăxăɣ-dd fălla-săn səmmos iyyăḍ.› ");
INSERT INTO taq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Innʼ-as măssi-s: ‹Ehoyd! Ănaxdim ifranăn ha tafləst a tămoosăd; šămad hʼ-ik tafləst dăɣ-a-wărăn əjjət, adiš ad-kăy-săɣləfăɣ a ăjjeen. Ǝyyăw ɣayəm edes-in, ad-nahăr tedăwit ta jeɣ.› ");
INSERT INTO taq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Osă-dd ḍarăt-a-wen wa n-əssin ibəlɣan n-orăɣ, inna i-măssi-s: ‹Măssi-ɣ, əssin ibəlɣan-wi hi-təssăɣlăfăd, ărbăxăɣ-dd fălla-săn əssin iyyăḍ.› ");
INSERT INTO taq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Innʼ-as măssi-s: ‹Ehoyd! Ănaxdim ifranăn ha tafləst a tămoosăd; šămad hʼ-ik tafləst dăɣ-a-wărăn əjət, adiš ad-kăy-săɣləfăɣ a ăjjeen. Ǝyyăw ɣayəm edes-in, ad-nahăr tedăwit ta jeɣ.› ");
INSERT INTO taq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Išrăy-dd wa n-iyyăn n-ablăɣ, innă i-măssi-s: ‹Măssi-ɣ, əssanăɣ a-s kăyy emăṣṣehi a tămoosăd, tijlubud a wăr tăddomed, tiləyəd ašəkrəš dăɣ-wăr tənferăd hărăt, ");
INSERT INTO taq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","jeɣ-ak tuksəḍa-ta-dăɣ făl təgled ɣas, əgleɣ năkk-dăɣ, jeɣ anu i-ablăɣ n-orăɣ wa hi-təssăɣlăfăd, ənbălăɣ-t dăɣ-s; ənta da, ərməs təla-năk.› ");
INSERT INTO taq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Innʼ-as măssi-s: ‹Kăyy wa-hi, erk ănaxdim n-eməssendəd a tămoosăd! A-s təssănăd a-s tijlubeɣ a wăr-ăddomeɣ, tiləyăɣ ašəkrəš dăɣ-wăr ənferăɣ hărăt, ");
INSERT INTO taq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mafăl wăr jed aẓrəf-in dăɣ-bănk i-ad-ăttăḷḷăɣăɣ hărăt fălla-s afăl dd-ăqqălăɣ?› ");
INSERT INTO taq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Inna i-ăddinăt ḍarăt-a-wen, ad-dăɣ-s ahăɣăn ablăɣ n-orăɣ wa iṭṭăf, əkfən-t i-wa n-măraw ibəlɣan. ");
INSERT INTO taq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ăssiilmădăɣ-kăwăn a-s ăwadəm wa ilăn hărăt ad-has-iwwaḍ, ijat a-wa ila măšan, wa wărăn ila hărăt, ad-dăɣ-s ăttărmăs wăla a-wa iṭṭăf. ");
INSERT INTO taq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","‹Ămăra, amălɣon wa-hi, ərməsăt-t, təjrəm-t-in dăɣ-tihay ti n-ajăma wăr iha ar tahăla d-aẓəmmăkărkəẓ n-isenăn făl tămujriẓt.› » ");
INSERT INTO taq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Innă Ɣisa daɣ: «Ašăl wa dd-mad-iqqəl Ăgg-ăgg-adəm dăɣ-ălxurmăt-net ăddew d-ănjălosăn-net, ad-ăqqayəm făll-tasăqqaymut-net ta n-ălxurmăt i-ad-imnukəl. ");
INSERT INTO taq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ašăl-en, ad-dd-ăqqaymənăt data-s tiwsaten n-ăddunya iket-dăɣ-năsnăt, iẓəmmăẓləy ăddinăt s-əmmək wa s-iẓamăẓlay amăḍan tahrut i-ad-ibḍəw tihatten d-išulaɣ. ");
INSERT INTO taq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dihen, ad-ăj tihatten daw-aɣil-net, ăj išulaɣ daw-tăšalje-net. ");
INSERT INTO taq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tihatten ti t-əllănen daw-aɣil-net, ad-hasnăt-ănn ămănokal: ‹Ǝyyăwmăt, kămăteḍ-i n-timəssunḍaḍ n-Abba-nin, uhənmăt təmmənəya ta hakmăt-ăsmăjnăt Abba a dd-tăxlăk ăddunya. ");
INSERT INTO taq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ašăl wa d-ălluẓăɣ, kămăteḍ a hi-ăswăyănăn, a-s ăffudăɣ, kămăteḍ a hi-issəswăn, a-s hakmăt-ămjareɣ, tăsbărrăkmăt-ahi, ");
INSERT INTO taq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","a-s ɣălulăɣ, təssəlsămăt-ahi, a-s ărhinăɣ, təssəfărmăt-ahi, a-s heɣ takărmut, jămăt-ahi-dd ăsafu.› ");
INSERT INTO taq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Afăl innʼ ămănokal a-wen-dăɣ, ad-has-ənnən imaɣdalăn wi t-əllănen dihen: ‹Emăli, əmme d-kăy-nənhăy tălluẓăd, nəššəkšʼ-ik? Ǝmme d-kăy-nənhăy tăffudăd, nəssəswʼ-ik? ");
INSERT INTO taq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ǝmme hanăɣ-dd-tămjared har kăy-năsbărrăk? Ǝmme d-ɣălulăd har kăy-nəssəlsa? ");
INSERT INTO taq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ǝmme d-tărhinăd meɣ əmme d-təjjăšăd takărmut har hak-in-nəja ăsafu?› ");
INSERT INTO taq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dihen, ad-hasăn-ănn ămănokal: ‹Ăsidătteɣ-awăn a-s hak ăssaɣăt d-jăm a-wen-dăɣ i-iyyăn dăɣ-ayətma-ɣ dăɣ-ăddunya, kud-dăɣ wa ənḍărrăn dăɣ-săn, šund năkk a-s t-jăm.› ");
INSERT INTO taq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ad-dd-innăḍ ămănokal ḍarăt-a-wen s-wi wărnen tăšalje-net, ănnʼ-asăn: ‹Kăwăneḍ iməlɣan ilɣan Măssinăɣ a tămoosăm, ăflăt dat-i, ăkkăt temse ta tăɣlălăt tămmujnet i-Iblis d-ănjălosăn-net, ");
INSERT INTO taq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","făl-a-s kăwăneḍ, ălluẓăɣ data-wăn, wăr hi-təššəkšăm; ăffudăɣ, wăr hi-təssəswăm; ");
INSERT INTO taq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ămjareɣ-awăn, wăr hi-tăsbărrăkăm; ɣălulăɣ, wăr hi-təssəlsăm; ărhinăɣ, əjjăšăɣ takărmut măšan, wăr hi-dd-jem ăsafu.› ");
INSERT INTO taq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Afăl hasăn-inna ămănokal a-wen, ad-has-ənnən əntăneḍ: ‹Emăli, əmme kăy-nənhăy tălluẓăd? Ǝmme kăy-nənhăy tăffudăd, meɣ ɣălulăd, meɣ tămijared-anăɣ-dd, meɣ tărhinăd, meɣ hed takărmut năqqim wăr hak-nəkna hărăt?› ");
INSERT INTO taq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ad-hasăn-ănn ămănokal: ‹Ăsidătteɣ-awăn a-s ed wăr jem a-wen i-iyyăn dăɣ-ayətma-ɣ dăɣ-ăddunya, kud-dăɣ wa ənḍărrăn dăɣ-săn, šund năkk a-s wăr t-jem.› ");
INSERT INTO taq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ăywa, wi-hi əntăneḍ, ad-hin-ətwəjărăn dăɣ-tisnant ta tăɣlălăt măšan, imaɣdalăn əntăneḍ, ad-əjjəšăn tămudre ta tăɣlălăt.» ");
INSERT INTO taq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ija Ɣisa măjrăd-wen-dăɣ ɣas, innă i-inəṭṭulab-net: ");
INSERT INTO taq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Təssanăm a-s əssin išilan a hin-ăqqimănen i-ămudd wa n-Faṣka-i dăɣ-mad-ăttărmăs Ăgg-ăgg-adəm, itwəṣləb făll-tajəttewt.» ");
INSERT INTO taq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dăɣ-isălan n-a-wen-dăɣ a dăɣ-dd-əžžəmmăɣăn imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil dăɣ ehăn n-Qayăf wa n-ămănokal n-kăl-tikutawen. ");
INSERT INTO taq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ănmănnakăn dihen făll-əmmək wa s-mad-săɣdărăn Ɣisa, əjən iman-net dăɣ-ufăr ");
INSERT INTO taq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","măšan, ənnăn, wăr-ufa ad-ăj a-wen dăɣ-ašăl wa n-ămudd i-ad-wăr təjj tamdərwayt dăɣ-tamətte. ");
INSERT INTO taq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ămjarăt Ɣisa ašăl iyyăn dăɣ-taɣrəmt ta n-Bitanya i-ehăn n-ăhaləs s-isəm-net Simyon wa s-kăla t-ijrăw jəri. ");
INSERT INTO taq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Illʼ-e ɣur-s dihen-dăɣ, ăsiɣămăr dăɣ-edăgg wa n-imənsiwăn, a-s t-dd-tosa tamăḍt tăwwayăt butəl n-aḍutăn lanen ălqim ad-tăn-sanɣal făll-eɣăf n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ǝnhăyăn inəṭṭulab-net a-wen, wăr hasăn-ijreẓ, ăhnăffen dăɣ-iman-năsăn ad-jannen: «Šăɣšad yaden! ");
INSERT INTO taq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aḍutăn-wi-dăɣ, mafăl wăr hin-ənšən, umas ălqim-năsăn takute i-tilăqqiwen.» ");
INSERT INTO taq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ilmăd Ɣisa a-wa kittəwăn, innʼ-asăn: «Ma s-naxxăsăm iman n-tamăḍt-i-dăɣ? Tihusay n-hărăt, təjʼ-ahi-t! ");
INSERT INTO taq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tilăqqiwen ya, əllanăt ɣur-wăn hărkuk, a-s ija a-wen, năkk, ilkam ad-kăwăn-ăflăɣ. ");
INSERT INTO taq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Asănɣal wa făll-i ja aḍutăn-wi-dăɣ, ašəšwar a dd-ja i-ăddinăt dăɣ-isălan n-ămukən n-taɣəssa-nin i-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ăsidătteɣ-awăn a-s edăgg dăɣ-ătwăxṭăbăn isălan n-Ălənžil dăɣ-ăddunya-ta-dăɣ, ad-dăɣ-s ətwəsuɣəlăn isălan n-a-wa təja, i-ad-tăt-kittəwăn ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dăɣ-a-wen-dăɣ, a dd-iggăd Yahudəs Isxaryut wa n-iyyăn dăɣ-inəṭṭulab wi n-măraw d-əssin, ikkʼ imănokalăn n-kăl-tikutawen, ");
INSERT INTO taq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","innʼ-asăn: «Ma hi-hakkăm afăl hawăn-əssăɣdărăɣ Ɣisa?» Ăsseḍănăn-as kăraḍăt timərwen n-ărriyal n-aẓrəf, əkfăn-as-tăn. ");
INSERT INTO taq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ad-itammăɣ Yăhudəs ɣur-ălwăqq-wen-dăɣ i-tašləlt s-hasăn-t-ăstărmăs. ");
INSERT INTO taq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ašăl wa ăzzarăn n-ămudd wa n-Faṣka, dăɣ-tamăkšanăt tijəlwen-ti wăr ha tăẓẓa, ənnăn inəṭṭulab i-Ɣisa: «Ălɣalim, əndek diha d-tărhed ad-nəsəssikəy imənsiwăn n-ămudd wa n-Faṣka?» ");
INSERT INTO taq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Innʼ-asăn: «Ǝjjəšăt aɣrəm, təkkəm ehăn n-măndam, tənnəm-as, innʼ-ak ălɣalim: ‹tăqqăn-in, tohăẓ-dd; ad-səssikəyăɣ năkk d-inəṭṭulab-in ămudd wa n-Faṣka dăɣ-ehăn-năk.› » ");
INSERT INTO taq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jăn inəṭṭulab a-wa hasăn-innă Ɣisa, əglăn ad-siməjnun imənsiwăn wi n-Faṣka. ");
INSERT INTO taq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ijʼ ehăḍ ɣas, ănɣăyma Ɣisa d-inəṭṭulab wi n-măraw d-əssin dăɣ-edăgg wa n-imənsiwăn. ");
INSERT INTO taq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tamănsawăn dihen-dăɣ a-s hasăn-innă: «Ăsidătteɣ-awăn a-s iyyăn dăɣ-wăn a hi-madăn-isəssăɣdăr.» ");
INSERT INTO taq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ǝkmăn-tăn iman-năsăn a-s hasăn-innă a-wen-dăɣ, ad-has-jannen s-iyyăn-iyyăn: «Ălɣalim, ajăn năkk?» ");
INSERT INTO taq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ăwwežăb-asăn, innʼ-asăn Ɣisa: «Wa dăr-i madăn-imzəyyət iji n-ăfuss dăɣ-ăkoss, ənta a hi-madăn-isəssăɣdăr. ");
INSERT INTO taq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tidət-dăɣ a-s Ăgg-ăgg-adəm, ad-t-iba ed a-wen-dăɣ a ənnăn əlkəttabăn n-Măssinăɣ dăɣ-isălan-net măšan, amăskoy ăwadəm wa t-madăn-isəssăɣdăr! Ăwadəm-en, iššăm-as-in, ad-wăr dd-ijješ ăddunya.» ");
INSERT INTO taq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iggăd-dd Yăhudəs wa t-madăn-isəssăɣdăr, innă ənta-dăɣ: «Ălfăqqi-nin, ăwadəm wa s-jănned, adiš năkk?» Innʼ-as Ɣisa: «Kăyy iman-năk, tənned-tăn.» ");
INSERT INTO taq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tattăn dihen-dăɣ a-s iḍkăl Ɣisa tajəlla, ămmoy i-Măssinăɣ təzzar, irẓʼ-et, ăẓun-tăt jer-inəṭṭulab-net, innʼ-asăn: «Uhənăt, ăkšăt, a-wa taɣəssa-nin.» ");
INSERT INTO taq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iḍkăl-dd daɣ kara han aman n-lăɣnăb ăxxiimmărnen, ămmoy i-Măssinăɣ təzzar, ikfʼ-asăn-t, innʼ-asăn: «Uhənăt, ăswăt iket-năwăn; ");
INSERT INTO taq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","a-wa ašni-nin wa ămoosăn ărkăwăl n-tassaɣt ta tăynayăt d-Măssinăɣ. Ašni-nin, ad-inɣəl dăɣ-təssəba n-tenăšše n-ibăkkaḍăn i-ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ăssiilmădăɣ-kăwăn a-s, wăr-ilkem ad-əsweɣ ad-dd-ijmaḍăn ara n-lăɣnăb hundăɣ har ašăl wa d-mad-aləsăɣ năkk d-kăwăneḍ tesăse-net, s-ălxal ăynayăn dăɣ-Təmmənəya ta n-Abba-nin.» ");
INSERT INTO taq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ăwwăy Ɣisa d-inəṭṭulab-net isuhaɣ n-təmmal n-Măssinăɣ dd-əzjarnen əlkəttab wa n-Ăẓẓăbur, əglăn ḍarăt-a-wen, əkkăn taḍaɣt ta tăssidwălăt ihəškan wi n-əzzăytun. ");
INSERT INTO taq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ǝwwăḍăn-in dihen ɣas, innʼ-asăn: «Xorəzzəma wa-hi madăn-irməs, ad-dd-arəw akuddəl-năwăn hahi ehăḍ-i-dăɣ, tăjawăḍăm iket-dăɣ-năwăn, təyyəm-ahi-dd năkk ɣas făl-a-s iktab dăɣ-əlkəttab a-s: ‹Ad-əwətăɣ amăḍan, iba-t, ămmăhăšnăt tihatten iket-năsnăt.› » ");
INSERT INTO taq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Innʼ-asăn daɣ: «Afăl dd-ənkărăɣ jer-inəmmuttan, ad-hawăn-izarăɣ s-teje ta n-Galila.» ");
INSERT INTO taq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iggăd-dd Bəṭrus, innă i-Ɣisa: «Năkk iman-in, kud ăjewăḍăn imidiwăn-in wi iyyăḍnen iket-năsăn dăɣ, wăr mad-ăjawăḍăɣ, ăyyăɣ-kăy, făw!» ");
INSERT INTO taq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Innʼ-as Ɣisa: «Ăsidătteɣ-ak a-s wăr mad-ăj ekăz kăraḍ iɣoran ehăḍ-i-dăɣ s-wădden tăkkudəlăd-ahi har kăraḍ ihăndăggan.» ");
INSERT INTO taq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Innʼ-as Bəṭrus: «Năkk ɣas, kud-dăɣ tamăttant a tihrăɣ dăr-k, wăr kăy-mad-əkkuddəlăɣ.» Abăraj-wen-dăɣ ija Bəṭrus, a jăn daɣ inəṭṭulab wi iyyăḍnen iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ăddew dăr-săn Ɣisa ḍarăt-a-wen s-ašəkrəš iyyăn iknan asədwal n-ihəškan s-isəm-net Žătsămmani, əwwăḍăn-in ɣas, innʼ-asăn: «Ɣaymăt, tăqqəlăm-ahi diha-dăɣ, ad-ədəlăɣ Măssinăɣ, əqqəlăɣ-kăwăn-dd.» ");
INSERT INTO taq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iššənkăš-in fălla-săn, ăddeew d-Bəṭrus d-məddana-s n-Zăbdi wi n-əssin; ɣur-ăssaɣăt-wen-dăɣ, ad-t-əssəntăn iman-net təkma, ixwăl. ");
INSERT INTO taq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Innă i-inəṭṭulab wi dăr-ăddew: «Ărɣan iman-in, ărɣan har išwar hi-ăba, wăr hanăɣ-ilăqqădet eḍəs.» ");
INSERT INTO taq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iššənkăš-in daɣ fălla-săn a ənḍărrăn, irkăɣ, ăsḍăs timme-net ăkall, ad-itəddal Măssinăɣ, ijanna: «Ya Abba-nin, kunta ămmukkăn a-wen-dăɣ, səssijəj-ahi tisnant-ta-dăɣ! Hakd a-wen-dăɣ, ăjet erhet wa-năk wădden wa-nin.» ");
INSERT INTO taq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iqqăl-dd Ɣisa inəṭṭulab-net wi n-kăraḍ, ogăẓ-tăn-dd əṭṭasăn; issənkăr Bəṭrus, innʼ-as: «Ɣas kăwăneḍ, indăr-awăn wăla-dăɣ ad-dăr-i tahərəm iyyăn n-ăssaɣăt ɣas dăɣ-wăr kăwăn-ilɣed eḍəs! ");
INSERT INTO taq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ǝnkărăt, ədəlăt Măssinăɣ i-ad-kăwăn-agəẓ dăɣ-tănḍărbaten n-Iblis; ăgg-adəm, tidət-dăɣ, a-s ăsidărhăn amišəl n-a ăjjeen ăhuusken măšan, igdal-as iba n-ăṣṣahăt n-tumast-net amišəl n-a-wa irha.» ");
INSERT INTO taq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Olăs-dd daɣ ăsihe wa s-əssin, iššənkăš-in fălla-săn, ad-itəddal Măssinăɣ, ijanna: «Abba-nin, kunta wăr t-illa făw əmmək s-ăɣlăsăɣ dăɣ-tisnant-ta-dăɣ, adiš, ăjet erhet-năk.» ");
INSERT INTO taq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Olăs-tăn uɣəl, ogăẓ-tăn-dd, ijʼ-asăn eḍəs alăɣad-wa-dăɣ făl hasăn-indăr wăla ad-arən tiṭṭawen-năsăn. ");
INSERT INTO taq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ifăl-tăn daɣ asihe wa s-kăraḍ, idăl daɣ Măssinăɣ s-əmmək-wənnin-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iglă, iqqăl-tăn-dd, issənkăr-tăn, innʼ-asăn: «Ɣas kăwăneḍ təṭṭasăm, sinfum hărwa? Ǝnkărăt-dd ămăra, ăssaɣăt n-atărməs-in, ohăẓ-dd. Ăgg-ăgg-adəm, ad-itwăɣdăr, ijjəš ifassăn n-inăsbăkkaḍăn, ");
INSERT INTO taq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ənkărăt, ăglăt-anăɣ; osʼ-anăɣ wa hi-e-isəssăɣdărăn.» ");
INSERT INTO taq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wăr-issəmdă Ɣisa tənna n-a-wen-dăɣ a-s Yăhudəs, wa n-iyyăn dăɣ-inəṭṭulab-net wi n-măraw d-əssin da-dăɣ, ăsilăl tamətte tăjjeet dd-ăšimašălăn imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil; əšlajăn iyyăḍ tikobawen, ăwwayăn iyyăḍ iboriyăn. ");
INSERT INTO taq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tamətte-ten-dăɣ, ijʼ-as Yăhudəs wa n-ămaɣdar tamătart dăɣ-has-inna: «Ăhaləs wa s-hi-tənhăyăm har t-osăsăɣ dăɣ-idmarăn-in, ənta a-s Ɣisa, ărməsăt-t.» ");
INSERT INTO taq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Osă-dd Yăhudəs, oɣăd iman-net s-Ɣisa, innʼ-as: «Ălfăqqi-nin, jeɣ-ak ăsafu!» Osăs-t dăɣ-idmarăn-net. ");
INSERT INTO taq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Innʼ-as Ɣisa: «Amidi-nin, ăj ya a-wa s-dd-tosed». Toḍa tamətte făll-Ɣisa ălwăqq-wen-dăɣ, tərmăs-t. ");
INSERT INTO taq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iggăd-dd iyyăn dăɣ-inəṭṭulab-net, ilbăy-dd tăkoba-net, ištăf-dd săr-s taməẓẓujt n-akli n-ămănokal n-kăl-tikutawen. ");
INSERT INTO taq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iɣtăl-t Ɣisa, innʼ-as: «Suɣəl tăkoba-năk dăɣ-titar-net; ere iknăsăn s-tăkoba, ad-ămmăt s-tăkoba. ");
INSERT INTO taq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ăddoobeɣ teɣăre n-Abba-nin ămăra-dăɣ, afăl t-ăɣreɣ daɣ, šik-dăɣ a-s mad-săr-i dd-išəmmišəl măraw ajhanăn n-ănjălosăn d-əssin hi-ohăɣnen tinahăɣen ");
INSERT INTO taq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","măšan afăl ija a-wen, əndek əmmək wa s-mad-itbat a-wa făll-i ənnăn ănnăbităn dăɣ-əlkəttabăn n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Innă Ɣisa i-tamətte ḍarăt-a-wen: «Ajăn năkk ănaɣtaf a ămoosăɣ a-s hi-dd-takkăm d-tikobawen d-iboriyăn i-ad-hi-tărməsăm? Wădden hannăyăm-ahi hak ašăl ăqqiimăɣ dăɣ-ehăn n-ămudd wa măqqărăn saɣreɣ, mafăl wăr hi dăɣ-s tərmesăm? ");
INSERT INTO taq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Măšan, əlmədăt a-s a-wa ijăn iket-net, ija i-ad-itbət a-wa ənnăn ănnăbităn dăɣ-əlkəttabăn.» Ăjewăḍăn inəṭṭulab-net iket-năsăn, oyyăn-t-dd ənta ɣas jer-išənja-net. ");
INSERT INTO taq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Təlwăy tamətte ta tərmăsăt Ɣisa s-Qayăf wa n-ămănokal n-kăl-tikutawen-i s-a-s ităjj a-wen-dăɣ ăžžimmăɣăn ɣur-s ălɣulam n-Ăṭṭăwrăt d-inušămăn n-Iṣrayil. ");
INSERT INTO taq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tamətte-en, ijʼ-as-dd Bəṭrus alkum šəjren har təjjăš ammas n-ăɣalla n-ehăn n-ămănokal n-kăl-tikutawen; osă-dd Bəṭrus, ijjăš ənta-dăɣ, igla ăqqima edes i-gărdităn, ad-isimăqqul i-ajilal n-tanfust-ta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ǝggădăn-dd imănokalăn n-kăl-tikutawen d-kăl-Sinhidrin wi tirənen ăššăreɣa iket-năsăn, ad-tammăɣăn i-tajuhe n-bahu ənnăn făll-Ɣisa i-ad-t-siḍəwăn dăɣ-ăššăreɣa, sənnəhəjjən-t d-tamăttant; ");
INSERT INTO taq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ənnăn fălla-s bahutăn ăjjootnen măšan, wăr tăn-iha a ibdadăn făll-hărăt. Ǝggădăn-dd əssin ăddinăt ăjjəyhnen s-bahu, ");
INSERT INTO taq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ad-jannen: «Ăhaləs-i-dăɣ, năjjəyha a-s inna, ăddoobăt ad-ănd ehăn n-ămudd wa măqqărăn n-Măssinăɣ, idəy-dd iyyăn ăynayăn dăɣ-edăgg-net dăɣ-kăraḍ išilan.» ");
INSERT INTO taq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Islʼ ămănokal n-kăl-tikutawen i-a-wen ɣas, ihă-dd ibdad, imməjrăd, innă i-Ɣisa: «Ma tənned dăɣ-a-wa fălla-k itawănnen? Măjrăd!» ");
INSERT INTO taq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wăr t-illa a has-inna Ɣisa. Innʼ-as ămănokal n-kăl-tikutawen ălwăqq-wen: «Jarăɣ-kăy s-idəm n-Măssinăɣ-i iddărăn, lăɣăt-anăɣ kunta kăyy a-s Ălmasex wa n-Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Innʼ-as Ɣisa: «Kăyy iman-năk, tənned-tăn; ăssiilmădăɣ-kăy daɣ a-s ɣur-ašăl-i-dăɣ, ad-tənhəyăm Ăgg-ăgg-adəm, ăqqiima daw-aɣil n-Wa ilăn tărna iket-net, taləsəm-t daɣ ahănay, iqqal-dd, ifal-dd išənnawăn, inay tijărăken.» ");
INSERT INTO taq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Islʼ ămănokal n-kăl-tikutawen i-a-wen-dăɣ ɣas, ijjăš-t ălhăm, wa-dăɣ făl, irmăs err n-erăswăy-net, ăsɣărrawăt-t făll-iman-net, innă: «A-wa ăskafăr, wădden sallăm-as a-s ăskafăr; ma nətajj i-tijuhawen daɣ? Igdăh-anăɣ a-wa dăɣ-inna meɣ ma tənnăm?» ");
INSERT INTO taq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ǝnnăn-as: «Wa ənta, ănihăjja d-tamăttant!» ");
INSERT INTO taq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ad-fălla-s situfăn, dabbăɣăn-as, ḍaẓẓăn dăɣ-s iyyăḍ, ");
INSERT INTO taq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jannen-as: «Ǝyyaa Ălmasex, luləy ya, tăllăɣed-anăɣ mi hak-istăɣăn?» ");
INSERT INTO taq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A-s ităjj a-wen-dăɣ, ăqqiima Bəṭrus dăɣ-təfărre n-ammas n-ăɣalla. Tosʼ-e-hi-dd tănaxdimt tiyyăt, tənnʼ-as: «Kăyy-i-dăɣ hannăyăɣ, kăla tăddewăd d-Ɣisa wa n-Galila?» ");
INSERT INTO taq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ăkkuddăl Bəṭrus a-wen dat-ăddinăt iket-năsăn, innʼ-as: «Wăr-əssenăɣ a dăɣ-hi-tăssewălăd.» ");
INSERT INTO taq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Innă Bəṭrus a-wen ɣas, ăškătarăš s-emm n-ăɣalla n-ehăn, tənhăy-t daɣ tănaxdimt tiyyăt, ad-janna i-ăddinăt wi t-əllanen dihen: «Hannăyăm-t ăhaləs-wa-dăɣ, kăla ăddew d-Ɣisa wa n-Năṣirăt.» ");
INSERT INTO taq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ad-itəhhaḍ Bəṭrus išənnawăn d-ăkall, ijanna: «Ăhaləs-wa-dăɣ s-hi-jănnem, wăr t-əzzeyăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A ənḍărrăn ḍarăt-a-wen, əkkăn-t-dd ăddinăt əbdadnen dăɣ-ammas n-ăɣalla-en-dăɣ, ənnăn-as: «Ijmaḍ-t ăššăk a-s kăyy-dăɣ, iyyăn dăɣ-ăddinăt wi n-Ɣisa, temăslăɣt-năk iman-net a tăsdăttet a-wen.» ");
INSERT INTO taq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ad-ităhhaḍ Bəṭrus, ilaqqăn iman-net siha d-siha, ijanna: «Ǝnneɣ-awăn, ăhaləs wa s-hi-jănnem, wăr t-əzzeyăɣ.» Diha-dăɣ d-innă a-wen-dăɣ, ad-iwăt ekăz ăɣora. ");
INSERT INTO taq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iktă-dd Bəṭrus măjrăd wa s-kăla has-t-ija Ɣisa, a-s has-inna: «Wăr mad-iwət ekăz ăɣora ašăl-i-dăɣ s-wădden tăkkuddălăd-ahi har kăraḍ ihăndăggan.» Izjăr ḍarăt-a-wen, ad-ihall a-wa-dăɣ has-ja tisnant. ");
INSERT INTO taq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ăffăw ɣas, əžžəmmăɣăn imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil, əṭṭăfăn iyyăn n-emm dăɣ-isălan n-iji n-iman n-Ɣisa, ");
INSERT INTO taq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ərmăsăn-t, jăn dăɣ-s tišəm təzzar, əlwăyăn-t s-Bilatəs wa n-gəfăr. ");
INSERT INTO taq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Inhăy Yăhudəs-i t-issăɣdărăn a-s ăššăreɣa n-tamăttant a əɣtăsăn i-Ɣisa ɣas, ămmujrăẓ a-wa ija; ikkʼ imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil, ăssoɣăl-asăn kăraḍăt timərwen n-ărriyal n-aẓrəf wi t-əkfăn. ");
INSERT INTO taq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Osʼ-en-dd, innʼ-asăn, «Ofeɣ abăkkaḍ, Ɣisa, wa jeɣ dăɣ-ifassăn-năwăn, wăr t-illa a iɣšad.» Ǝnnăn-as: «Un, ma năkkul? A-wen əššăɣəl-năk.» ");
INSERT INTO taq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Irmăs Yăhudəs aẓrəf-ənnin, ijăr-asăn-t-in dăɣ-ehăn n-ămudd wa măqqărăn təzzar, iglă, ăsselăy aɣan, ija tărsəm dăɣ-err-net, imməntăl i-iman-net. ");
INSERT INTO taq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ǝkkəmen-dd imănokalăn n-kăl-tikutawen aẓrəf wa hin-ijăr măšan, ənnăn: «Wăr hanăɣ-xălal iji n-aẓrəf-wa-dăɣ făll-wa n-ehăn n-ămudd wa măqqărăn, ed ənta a-s ătwăjjăn iman n-ăhaləs.» ");
INSERT INTO taq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ǝžžəmmăɣăn dăɣ-isălan n-a-wa mad-əjən i-aẓrəf-en, ohărăn emm, ənnăn, ad-săr-s žănšən ašəkrəš n-ăhaləs iyyăn hin-ižanšen iləkkan, i-ad-umas edăgg-en, tiẓəska i-imăjarăn. ");
INSERT INTO taq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dăɣ-təssəba n-ăddăbara-wen-dăɣ a făl har ašăl-i-dăɣ, təfărre-ten-dăɣ, iwăr-tăt isəm: «Ašəkrəš wa n-ašni.» ");
INSERT INTO taq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ămoos a-wen-dăɣ jăn a ăssitbătăn a-wa innă ănnăbi Yirmiya, a-s innă dăɣ-əlkəttab-net: «Ărmăsăn kăraḍăt timərwen n-ărriyal n-aẓrəf, ălqim-wen-dăɣ a-s t-əḍkăḍăn kăl-Iṣrayil, ənta-den-dăɣ a-wa dăr-ăssagdăhăn ălqim n-ăgg-adəm, ");
INSERT INTO taq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","əžžənšăn săr-s ašəkrəš wa n-i n-iləkkan s-əmmək wa s-hi-tăn-innă Emăli.» ");
INSERT INTO taq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ălwăqq wa dd-ibdăd Ɣisa dat-Bilatəs wa n-gəfăr, issəstăn-t, innʼ-as: «Ak, kăyy a-s ămănokal n-kăl-Ălyăhud meɣ?» Innʼ-as Ɣisa: «Kăyy iman-năk, tənned-tăn.» ");
INSERT INTO taq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ǝggădăn-dd imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil, ad-t-saḍlamăn siha d-siha măšan, wăr t-illa a hasăn-inna. ");
INSERT INTO taq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Innă gəfăr i-Ɣisa: «Ajăn kăyy, wăr səlləd i-tikunen ti fălla-k titwənninen?» ");
INSERT INTO taq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wăr t-təlla tăfert dd-təzjarăt emm n-Ɣisa, iqqăn a-wen eɣăf n-gəfăr. ");
INSERT INTO taq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ăzzăman-en, hak ămudd n-Faṣka, ăsiwăyyʼ-in gəfăr u-takărmut wa dăɣ-s təttăr tamətte. ");
INSERT INTO taq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A-s ităjj a-wen-dăɣ, ihʼ ăhaləs s-isəm-net Bărɣăbbas takărmut, isəm-net iyyăn Ɣisa ənta-dăɣ, wăr t-illa ere s-wădden issan făll-terwidəma-net. ");
INSERT INTO taq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Inhăy Bilatəs tamətte-ta dd-təžžəmmăɣăt săr-s ɣas, innʼ-asăn: «Lăɣătăt-ahi, əndek jer-meddən-wi-dăɣ n-əssin wa s-tărham a hawăn-t-in-səwwəyyăɣ? Ma tăssofăm Bărɣăbbas meɣ Ɣisa wa s-itawănna Ălmasex?» ");
INSERT INTO taq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ijʼ-asăn Bilatəs asəstan-wen-dăɣ făl-a-s issan a-s təmɣăre n-tismiten-năsăn ɣas a făl ăstărmăsăn Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ăqqiima Bilatəs hărwa dăɣ-edăgg wa dăɣ-iɣattăs ăššăreɣa a-s dd-tăšmašăl hănne-s ăwadəm săr-s i-ad-wăr-isəmtəltil iman-net d-iman n-ăhaləs wărăn iɣšed hărăt ed tənnʼ-as, ənḍăhaḍ, əgdălăn-as imănăwnăwăn n-ăhaləs-en-dăɣ eḍəs. ");
INSERT INTO taq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ǝggădăn imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil, ăšhăššălăn tamətte i-ad-təttăr dăɣ-gəfăr ad-hasăn-dd-isəwwəy Bărɣăbbas, ămmăt Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Olăs daɣ gəfăr, innʼ-asăn: «Ǝndek jer-meddən-wi-dăɣ n-əssin wa s-tărham ad-hawăn-t-in-səwwəyyăɣ?» Ǝnnăn-as: «Bărɣăbbas.» ");
INSERT INTO taq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Innʼ-asăn Bilatəs: «Ɣisa-š wa s-itawănna Ălmasex, ma has-e-ăjăɣ?» Ǝnnăn-as iket-dăɣ-năsăn: «Itwəṣləbet făll-tajəttewt!» ");
INSERT INTO taq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Innʼ-asăn Bilatəs: «Mafăl, ma iɣšăd t-ăsiinăhăjjăn d-tamăttant?» Ăsɣăyyăn daɣ s-ăṣṣahăt: «Itwəṣləbet făll-tajəttewt.» ");
INSERT INTO taq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Inhăy Bilatəs a-s wăr t-illa a infa măjrăd-net ed, təssəntă tamətte amdərway n-əššənju ɣas, iḍkăl-dd ăkoss han aman, ăsserăd ifassăn-net dat-tamətte təzzar, innʼ-asăn: «Ăhaləs-i-dăɣ ya ămaɣdal, tăjjihăm a-s wăr dăɣ-i əḍmenăn iman-net; oyyeɣ jere-wăn dăr-s.» ");
INSERT INTO taq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tənnʼ-as tamətte iket-net: «Ǝyya, nərḍa s-a-wen; əḍmənnet iman-net dăɣ-năɣ năkkăneḍ d-ihăyawăn-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ăswăyyʼ-asăn-in Bilatəs Bărɣăbbas, ăswăjja tiwit n-ebărtăk dăɣ-Ɣisa təzzar, ikfʼ-asăn-t i-ad-itwəṣləb făll-tajəttewt. ");
INSERT INTO taq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ǝlwăyăn əssărdusa wi n-gəfăr Ɣisa s-ammas n-ehăn wa n-gəfăr, iɣlăyɣălăy-t-dd dihen ejhăn n-əssărdusa imdan, ");
INSERT INTO taq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","əkkăsăn dăɣ-s isəlsa-net, əssəlsăn-t anăkăbba šăggăɣăn, ");
INSERT INTO taq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","jăn-as ălmăt, korona, a-wen, takənbut šund ta n-imănokalăn təẓat dăɣ-isənnanăn, jăn ălmăt tăborit ta n-təmmənukəla dăɣ-ăfuss-net wa n-aɣil, ad-rakkăɣăn data-s, ḍazzăn, jannen-as: «Ămănokal n-kăl-Ălyăhud, nəjʼ-ak gărdəbu!» ");
INSERT INTO taq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Situfăn fălla-s, tihăɣăn dăɣ-s tăborit ta jăn dăɣ-ăfuss-net, təggatăn-t săr-s făll-eɣăf. ");
INSERT INTO taq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ǝssəgdăhăn dăɣ-tekăškăšt ta tăn-təšlăt ɣas, əkkăsăn-dd fălla-s anăkăbba-wənnin šăggăɣăn, ăssoɣălăn-as isəlsa-net təzzar, əglăn dăr-s i-ad-itwəṣləb făll-tajəttewt. ");
INSERT INTO taq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ǝglan dăr-s a-s ămmoqqăsăn d-ăhaləs n-tadăbayt ta n-Qərwan s-isəm-net Simyon; ăšhăššălăn-t alənji n-tajəttewt ta făll-mad-itwəṣləb Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ǝkkăn d-Ɣisa edăgg s-itawănna: Gălgota, a-wen ălmăɣna-net: «Edăgg wa n-akărkor.» Ǝwwăḍăn-in edăgg-en ɣas, ");
INSERT INTO taq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","əssărtăyăn əssărdusa asməd d-asăfar iyyăn ifannăẓăn tisnant i-ad-has-t-səswən, măšan, ăkrăbbăt-t ɣas, unjăy săr-s. ");
INSERT INTO taq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ǝṣlăbăn-t əssărdusa făll-tajəttewt ɣas, jăn tisăɣeren i-ad-uẓanăn isəlsa-net jer-iman-năsăn; ămoos a-wen a ăssiitbătăn a-wa s-kăla tăn-innă ănnăbi iyyăn a-s innă: «Ăẓunăn isəlsa-nin jer-iman-năsăn jăn tisăɣeren făll-anăkăbba-nin.» ");
INSERT INTO taq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ǝssəmdăn a-wen-dăɣ ɣas, əqqimăn, jăn ənniyăt i-Ɣisa, ");
INSERT INTO taq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","əttəytăyăn ăllox jənnəj-s i-ad-əlmədăn ăddinăt ăddălil wa săr-s dd-orăwăn tamăttant. Ăllox-en, iktab fălla-s: ");
INSERT INTO taq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ašăl-en, ămizăyyen əssin inaɣtafăn atwəṣləb d-Ɣisa; ătwăṣlăb iyyăn daw-aɣil-net, ătwăṣlăb wa iyyăḍăn daw-tăšalje-net. ");
INSERT INTO taq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iqqăl Ɣisa tekăškăšt i-ăddinăt-wi tikəynen, gaggărăn-t, siwliwilăn iɣăfawăn-năsăn, ");
INSERT INTO taq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","jannen-as: «Ǝyyaa, kăyy-i innăn tăddoobed terăẓẓe n-ehăn n-ămudd wa măqqărăn taləsăd-t edey dăɣ-kăraḍ išilan, ăɣləs iman-năk ya ămăra! Kunta tidət-dăɣ a-s kăyy a-s Rure-s n-Măssinăɣ, zubbət-dd tajəttewt!» ");
INSERT INTO taq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ad-ḍaẓẓăn dăɣ-s daɣ imănokalăn n-kăl-tikutawen d-ălɣulam d-Ăṭṭăwrăt d-inušămăn n-Iṣrayil, jannen: ");
INSERT INTO taq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Wădden iɣlăs ăddinăt wi iyyăḍnen, iɣləset ya iman-net ămăra. Ikkəset-dd iman-net făll-tajəttewt, dihen ad-nəfləs a-s ənta a-s ămănokal n-Iṣrayil; ");
INSERT INTO taq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","wădden oman s-Măssinăɣ, iɣləset-t Măssinăɣ ya ămăra kunta ənta irhʼ-e, ed innă, ənta a-s Rure-s.» ");
INSERT INTO taq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ǝggădăn-dd daɣ inaɣtafăn wi ătwăṣlăbnen edes-has, ad-t-gaggărăn əntăneḍ-dăɣ s-əmmək-en-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ǝlsănăt tihay ărori n-ăkall iket-dăɣ-net wa-dăɣ n-tarăhut hundăɣ har tezzar. ");
INSERT INTO taq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Təjă tezzar ɣas, ăsɣărăt Ɣisa s-afălla, innă dăɣ-tawalt-net: «Yăḷḷoy, Yăḷḷoy, lama săbăxtani?» A-wen ălmăɣna-net: «Măssi-ɣ Măssinăɣ, Măssi-ɣ Măssinăɣ, mafăl hi-təyyəd d-iman-in dăɣ-tisnant-ta-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ǝslăn-as ăddinăt əbdadnen dihen, wăr-əfhemăn a-wa ijănna ɣas, ad-jannen: «Săjdăt-as, ănnăbi Ɣəli a iɣarr!» ");
INSERT INTO taq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ošăl-dd iyyăn dăɣ-săn ălwăqq-wen-dăɣ, issəlmăɣ tăḍuft təttalăt făll-ăbori dăɣ-bənegăr təzzar, ăssokʼ-et-dd emm n-Ɣisa i-ad-tăt-isuməm, infəw-t a-wen dăɣ-fad ");
INSERT INTO taq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","măšan, ənnăn-as imidiwăn-net: «Ǝšləy-as, ăyyʼ-e ad-nənhəy kunta ad-t-dd-ass ănnăbi Ɣəli, iɣləs-t.» ");
INSERT INTO taq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ăsɣărăt Ɣisa daɣ s-ăṣṣahăt, təzzar, əjmăḍăn-t iman. ");
INSERT INTO taq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Diha-dăɣ d-ija a-wen a-s ărido wa ibḍăn edăgg n-ămudd wa šăddijăn d-wa iknăn təššədje dăɣ-ehăn n-ămudd wa măqqărăn da-dăɣ a-s iqqărrawăt dăɣ-ammas, wa-dăɣ n-afălla-net har ider-net; ăškăḍkăḍ ăkall, ăṣṣoren iḍaɣăn; ");
INSERT INTO taq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ămerănăt tiẓəska, ənkărăn-dd inəmmuttan n-imumənăn ăjjootnen ");
INSERT INTO taq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ḍarăt-tanăkra n-Ɣisa jer-inəmmuttan. Ăjjəyhăn ăddinăt ăjjootnen tăn-ənhaynen a-s dd-əjjăšăn aɣrəm wa šăddijăn n-Yărussălam ḍarăt tanăkra-năsăn jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Inhăy kăbtăn iyyăn n-kăl-Roma d-əssărdusa wi jănen ənniyăt i-Ɣisa a-wa ijăn d-aškəḍkəḍ wa ija ăkall ɣas, ărmăɣăn, ad-jannen: «Tidət-dăɣ a-s ăhaləs-i-dăɣ, Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ǝbdadnăt daɣ tiḍeḍen ăjjootnen dihen, əswaḍnăt dăɣ-ijəj dăɣ-a-wa ijăn iket-net. Tiḍeḍen-tin-dăɣ a-s kăla ədhălnăt Ɣisa, ăddewnăt dăr-s wa-dăɣ n-a ifăl teje ta n-Galila har əntănăteḍ-da-dăɣ; ");
INSERT INTO taq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","hʼ-enăt Măryăma ta n-Mulăždaləyăt d-Măryăma ta n-ma-s n-Yaqub d-Yusəf, hʼ-enăt daɣ ma-s n-dăgg-Zăbdi. ");
INSERT INTO taq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tokăy takkăṣt ɣas, osă-dd ăgg-ehăre iyyăn la taɣrəmt ta n-Arimata n-anăṭṭalib n-Ɣisa s-isəm-net Yusəf. ");
INSERT INTO taq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ǝnta-en-dăɣ a ikkăn Bilatəs, ittăr dăɣ-s turhajăt n-ad-dd-ikkəs tafəkka n-Ɣisa făll-tajəttewt, iṣtăr-tăt; irḍʼ-as Bilatəs s-a-wen. ");
INSERT INTO taq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ikkăs-dd Yusəf tafəkka n-Ɣisa făll-tajəttewt, iknʼ-et, issəlsʼ-et tefit ");
INSERT INTO taq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","təzzar, issənsʼ-et dăɣ-aẓəkka ăynayăn s-ăru t-iɣaš i-iman-net dăɣ-esăwăl; ăsɣărănɣarăt-t-dd ḍarăt-a-wen tăhunt măqqoorăt, ăṭṭubbăt săr-s emm n-aẓəkka təzzar, iglă. ");
INSERT INTO taq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A-s ităjj a-wen-dăɣ, təbdad Măryăma ta n-Mulăždaləyăt d-tanəmmăɣrut-net ta iyyăḍăt, ăqqimănăt tissənen dat-aẓəkka-en-dăɣ, hannăynăt a-wa ijăn iket-net. ");
INSERT INTO taq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ăba Ɣisa dăɣ-ašăl wa n-dat-wa d-siməjnun kăl-Ălyăhud i-ašăl wa n-əssəbət-i n-tăsonfat. Ašăl wa ilkămăn i-wen n-əssəbət wa n-tăsonfat, əkkăn imănokalăn n-kăl-tikutawen d-kăl-faris Bilatəs, ənnăn-as: ");
INSERT INTO taq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Ămănokal-nănăɣ, nəkittəw a-s ăwadəm wa išinməšrəyăn ăddinăt, a-s iddăr, innă, afăl t-ăba, kăraḍ išilan ḍarăt-tamăttant-net, ad-dd-inkăr jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nărha dăɣ-k, ad-səwwəjjəd ənniyăt i-aẓəkka-net hundăɣ har akəyən kăraḍ išilan-win-dăɣ s-innă, dihen, wăr mad-akrən inəṭṭulab-net tafəkka-net, əffărăn-tăt təzzar, ənnən i-tamətte a-s inkăr-dd jer-inəmmuttan. Afăl jăn a-wen, ad-tajăr tanməšrayt ta jăn ta ija ənta iman-net.» ");
INSERT INTO taq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Innʼ-asăn Bilatəs: «Ăjăt a-wa s-tărhăm. Ǝnhəywăt, hărăt dăɣ-əssărdusa-dədi, səwwəjjəm-tăn ənniyăt i-aẓəkka s-əmmək wa s-tărhăm.» ");
INSERT INTO taq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ǝkkăn aẓəkka, əssəbdădăn data-s əssărdusa təzzar, əknăn-t ăṭabbu i-ad-wăr-itədubut ăwadəm wălʼ iyyăn arr-net. ");
INSERT INTO taq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tăbboqqăt tifawt n-ašăl wa n-ḍarăt wa n-əssəbət-i n-tăsonfat ɣas, təkka Măryăma ta n-Mulăždaləyăt aẓəkka tăddeew d-Măryăma ta iyyăḍăt n-tanəmmăɣrut-net. ");
INSERT INTO taq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A ənḍărrăn, ăzzubbăt-dd ănjălos n-Emăli dd-ifalăn išənnawăn, ăškăḍkăḍ ăkall s-ăṣṣahăt, ăsɣărarăd-in tăhunt ta hărăt emm n-aẓəkka, ăqqima fălla-s. ");
INSERT INTO taq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ănjălos-i-dăɣ, ăsimăɣmăɣ šund essam, jan isəlsa-net təməlle-i-dăɣ măqqărăt. ");
INSERT INTO taq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ija a-wen ɣas, jăn əssărdusa wi jănen ənniyăt i-aẓəkka tarəmmeɣt-ta-dăɣ făl dd-hăn ăbbunbăyăn šund ămmun. ");
INSERT INTO taq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Imməjrăd ănjălos i-tiḍeḍen, innʼ-asnăt: «Wăr tărmeɣmăt; əssanăɣ a-s Ɣisa wa ătwăṣlăbăn făll-tajəttewt a-s tammăɣmăt; ");
INSERT INTO taq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ăbas t-illa diha, inkăr-dd jer-inəmmuttan s-əmmək wa s-tăn-innă, əyyăwmăt, ənhəymăt edăgg wa s-kăla dăɣ-s insa. ");
INSERT INTO taq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Šəwənkətmăt ămăra, təjəmăt isălan n-tanăkra-net jer-inəmmuttan i-inəṭṭulab, tăllăɣătmăt-asăn daɣ a-s ăzzar-awăn iket-năwăn s-Galila ed dihen-dăɣ ad-t-mad-tənhəyăm. Ǝnta-den-dăɣ măjrăd wa s-dd-ămešălăɣ i-ad-hakmăt-t-in-səssiwəḍăɣ.» ");
INSERT INTO taq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Fălnăt šik aẓəkka, tărtay-asnăt tarəmmeɣt d-təmɣăre n-tedăwit, ošălnăt i-ad-əjənăt jănăt isălan dăɣ-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wăr t-illa a hin-əjrahnăt a-s hasnăt-dd-ilkăḍ Ɣisa iman-net, ijʼ-asnăt ăsafu. Ohăẓnăt-t-dd, ărkăɣnăt data-s, ad-timəllutnăt i-iḍarăn-net, ɣăbbădnăt-t. ");
INSERT INTO taq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Innʼ-asnăt: «Wăr tərmeɣmăt, əqqəlmăt ayətma-ɣ, tənnəmăt-asăn a-s, ăzzarăɣ-asăn s-teje ta n-Galila-i-dăɣ hi-mad-ənhəyăn.» ");
INSERT INTO taq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hărwa hanăt zăbo, əglanăt a-s əkkăn əssărdusa wi jănen ənniyăt i-aẓəkka aɣrəm, ăwwayăn isălan n-a-wa ijăn iket-net i-imănokalăn n-kăl-tikutawen. ");
INSERT INTO taq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ǝslăn imănokalăn n-kăl-tikutawen d-inušămăn n-Iṣrayil i-isălan-win-dăɣ ɣas, ănɣăymăn făl a-wen. Inkăr ălžămaɣăt-năsăn ɣas, əkfăn aẓrəf ăjjeen i-əssărdusa təzzar, ənnăn-asăn: ");
INSERT INTO taq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«Ere kăwăn-issəstănăn, ănnăt-as: osăn-anăɣ-dd inəṭṭulab n-Ɣisa s-ehăḍ, nəṭṭas, okărăn tafəkka-net, əglăn dăr-s.» ");
INSERT INTO taq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ǝnnăn i-əssărdusa: «Afăl əjjăšăn isălan gəfăr, ad-t-nəsəsmăḍ fălla-wăn, tăɣləsăm.» ");
INSERT INTO taq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ărmăsăn əssărdusa aẓrəf-năsăn, əglăn dăɣ-əššăɣəl-năsăn, jăn a-wa hasăn-ătwănnăn. Ămoos a-s isălan-win-dăɣ a əflăsăn kăl-Ălyăhud har ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ǝkkăn inəṭṭulab wi n-măraw d-iyyăn taḍaɣt ta hăt teje ta n-Galila hasăn-ija Ɣisa tasəssihărt, ogăẓăn-t-in fălla-s. ");
INSERT INTO taq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ǝnhăyăn-t ɣas, ărkăɣăn-as, ad-t-ɣabbădăn măšan, hakd a-wen-dăɣ, han-tăn iyyăḍ dăɣ-s janen ăššăk. ");
INSERT INTO taq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ohăẓ-dd Ɣisa ălžămaɣăt wa n-inəṭṭulab-net, innʼ-asăn: «Wăr t-illa jer-išənnawăn d-ăkall a-s wădden əjrawăɣ fălla-s tărna; ");
INSERT INTO taq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","a-wen-dăɣ a făl ămăra, ăglăt; ăkkăt tiwsaten n-ăddunya iket-dăɣ-năsnăt, səṭṭuləbăm dăɣ-snăt ăddinăt, səlmăɣăm-tăn dăɣ-aman s-isəm n-Abba d-Rure-s d-Unfas Šăddijăn, ");
INSERT INTO taq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","săɣrəm-tăn amišəl n-a-wa s-hawăn-omărăɣ iket-net. Năkk-da, ad-dăr-wăn ăddewăɣ, ədhalăɣ-kăwăn hak ašăl har təmdəw ăddunya.» Amin!");
INSERT INTO taq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sănto n-Ălənžil n-ƔisaĂlmasex wa n-Rure-s n-Măssinăɣ da: ");
INSERT INTO taq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ǝnta-en-dăɣ a făll-innă ănnăbi Saya dăɣ-əlkəttab-net: «Ǝnhəy! Ăzizărăɣ-ak, inna Măssinăɣ, ănămmašul-in wa he-iknən tabarăt-năk. ");
INSERT INTO taq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ănămmašul-en, ăseɣărăt dăɣ-tenere, ijanna: ‹Ăknăt tabarăt n-Măssinăɣ, səssiɣədăt ibaran-net.› » ");
INSERT INTO taq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ǝmmək-wen-dăɣ a-s dd-osă Exya wa n-Enəsselmăɣ, ixaṭṭăb, ijanna i-ăddinăt: «Utabăt, tətwəsəlmăɣăm dăɣ-aman i-ad-təjrəwăm tenăšše n-ibăkkaḍăn.» ");
INSERT INTO taq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ijanna a-wen-dăɣ, ad-săr-s dd-zajjărăn ăddinăt ăjjootnen dd-falnen teje ta n-Ălyăhudəyăt d-aɣrəm wa n-Yărussălam, safăkkarăn-dd a-wa ămešălăn dăɣ-ibăkkaḍăn dat-tamətte, isalmaɣ-tăn dăɣ-aman n-ejănš wa s-itawănna Ɣurdəni. ");
INSERT INTO taq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ilsʼ Exya emăls iknan s-elăm n-amnəs warăn amẓadăn, ijbas s-taməntəka n-elăm, iddar s-tašwalt d-torawăt. ");
INSERT INTO taq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ixaṭṭăb, ijanna i-tamətte: «Ad-hi-dd-išrəy-i hi-ojărăn tărna, ijʼ-ahi tifut ta-dăɣ s-wăr-ănhăjjăɣ wăla-dăɣ d-ad-əddunkuɣ i-ad-arăɣ issal n-tifădelen-net. ");
INSERT INTO taq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Năkk, aman a dăɣ-kăwăn-salmaɣăɣ, măšan ənta, Unfas Šăddijăn a dăɣ-kăwăn-e-isəlmăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Išilan-win-dăɣ a dăɣ-dd-ifăl Ɣisa taɣrəmt ta n-Năṣirăt hăt teje ta n-Galila, ikkă-dd Exya, issəlmăɣ-t dăɣ-aman n-ejănš wa n-Ɣurdəni. ");
INSERT INTO taq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Diha-dăɣ dd-izjăr aman, ad-inhăy išənnawăn a-s dd-ămerăn, ăzzubbăt-dd fălla-s Unfas Šăddijăn dăɣ-ănnuɣ n-tedăbert măllăt, ");
INSERT INTO taq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ijmăḍ-dd emăsli išənnawăn, innăn: «Kăyy-i-dăɣ a-s Rure-ɣ wa əkneeɣ tărha, kăyy a dăɣ-ăsriwăn iman-in.» ");
INSERT INTO taq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Šik ḍarăt-a-wen, oɣăd Unfas n-Măssinăɣ Ɣisa s-tenere, ");
INSERT INTO taq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ijă dăɣ-s əkkoẓăt timərwen n-ašăl, itižărrub-t Iblis, irtay d-iwăɣsan, ăxdamăn-as ănjălosăn. ");
INSERT INTO taq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ittărmăs Exya wa n-Enəsselmăɣ ɣas, ikkă Ɣisa teje ta n-Galila, ad-dăɣ-s ixaṭṭăb isălan n-Ălənžil n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ijanna i-ăddinăt: «Tăqqăn tăwwăḍ! Təmmənəya n-Măssinăɣ, tohăẓ-dd; utabăt, tamənăm s-isălan n-Ălənžil.» ");
INSERT INTO taq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ălliil Ɣisa asălim n-ejănš wa n-Galila a-s inhăy Simyon d-ăŋŋa-s Idris, təjjarăn titarren-năsăn dăɣ-aman ed iməhhuyya n-imănan a ămoosăn. ");
INSERT INTO taq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Innʼ-asăn Ɣisa: «Ǝlkəmăt-ahi, ad-kăwăn-ăjăɣ meddən săr-i dd-sadawnen ăddinăt i-ad-tăn-ăɣləsăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oyyăn titarren-năsăn ălwăqq-wen-dăɣ, əlkămăn-as. ");
INSERT INTO taq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Illa-hin i-dihen a ənḍărrăn, inhăy Ɣisa dăgg-Zăbdi: Yaqub d-ăŋŋa-s Exya, samăkrasăn titarren dăɣ-turăft-năsăn ta n-aman, ");
INSERT INTO taq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","iɣrʼ-en-dd ăssaɣăt-wen-dăɣ. Oyyăn abba-năsăn Zăbdi dăɣ-turăft ta n-aman ənta d-inaxdimăn, əlkămăn-as. ");
INSERT INTO taq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ǝkkăn taɣrəmt ta n-Qăfărnaxum; ijʼ-en ašăl wa n-əssəbət-i n-tăsonfat dihen ɣas, ikka Ɣisaehăn n-ăddin wa n-kăl-Ălyăhud, ad-dăɣ-s isaɣra tamətte. ");
INSERT INTO taq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ǝqqălăn-dd ăddinăt ɣas oran imawăn făl əjjăruẓăt-i-dăɣ hasăn-ija a-wa isăɣra, ed isaɣrʼ-en s-ălxikmăt n-ere issanăn a-wa iha wădden, šund ălɣulam wi n-Ăṭṭăwrăt. ");
INSERT INTO taq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ehăn n-ăddin-en, ihʼ-ee ăhaləs ihʼ alšin, inhăy Ɣisa ɣas, ad-isaɣărat, ijanna: ");
INSERT INTO taq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Ya Ɣisa wa n-Năṣirăt, ma dăɣ-năɣ tărhed? Ajăn ahălak-nănăɣ a-s dd-tosed? Ǝssanăɣ ere wa tămoosăd, kăyy-i-dăɣ a-s: Wa Šăddijăn dd-ăšmašăl Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ăsmăhăḍ dăɣ-s Ɣisa, innʼ-as: «Ǝṭṭəf emm-năk, təzjărăd ăhaləs-i-dăɣ!» ");
INSERT INTO taq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ăššăkăḍkăḍ alšin ăhaləs s-ăṣṣahăt, ăsɣărăt dăɣ-išənnawăn təzzar, izjăr-t. ");
INSERT INTO taq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Issărmăɣ a-wa ijăn ăddinăt, əqqălăn-dd hak iyyăn isastan amidi-net, ijanna: «Ma ămoos a-wa? Ma tămoos teɣăre-ta-hi tăynayăt, tăṣṣohet? Wa ənta wăla alšinăn e-d fălla-săn ăsmăhăḍ, ad-əjən a-wa inna.» ");
INSERT INTO taq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Šik-dăɣ a-s intăj isəm-net dăɣ-teje ta n-Galila iket-dăɣ-net. ");
INSERT INTO taq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Izjăr-dd Ɣisaehăn n-ăddin wa n-kăl-Ălyăhud ɣas, ăddew d-Yaqub d-Exya s-ehăn wa n-Simyon d-Idris. ");
INSERT INTO taq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A-s hin-əwwăḍăn ehăn, tăssinsa tenăde taḍăggalt n-Simyon. Ǝllăɣen-as săr-s ăddinăt ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Osʼ-e-t, irmăs-tăt-dd s-ăfuss, issəbdăd-tăt, tərẓa fălla-s tenăde, təbdăd, ad-tăn-simjurut. ");
INSERT INTO taq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Toḍa tăfukt ɣas, ămewăyăn-dd imarhinăn d-iməlšan iket-năsăn, ");
INSERT INTO taq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ăddew-dd aɣrəm iket-net dat-emm n-ehăn-wen-dăɣ iha. ");
INSERT INTO taq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ăzozăy dăɣ-săn i ăjjootnen əjrawnăt tăkmoten wăren oleh, ikkăs daɣ alšinăn ăjjootnen dăɣ-ăddinăt. Alšinăn əntăneḍ, wăr tăn-itəyy ămmijrădăn ed əssanăn ere wa ămoos. ");
INSERT INTO taq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Emăɣăr n-ašăl wa iyyăḍăn, hărwa janăt tihay, inkăr Ɣisa, ikkă tenere n-iman-net, ad-itəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kăla has-itammăɣ Simyon d-imidiwăn-net ");
INSERT INTO taq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","har t-əjrăwăn, ənnăn-as: «Tamətte iket-net a hak-təmmaɣăt.» ");
INSERT INTO taq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Innʼ-asăn: «Năkket tidbi ti n-data-năɣ i-ad-hasnăt-ăxṭəbăɣ əntănăteḍ-dăɣ, ed a-wen-dăɣ a-s dd-ămešălăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Issăɣlăy-dd teje ta n-Galila iket-net, ixaṭṭăb dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, itakkăs alšinăn dăɣ-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Osă-dd ăhaləs ijraw jəri Ɣisa, irkăɣ data-s, ad-t-ilaqqăd, ijannʼ-as: «Afăl tărhed a-wen-dăɣ, tăddobed ad-hi-šəšdəjăd.» ");
INSERT INTO taq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tănɣʼ-e tăhanint-net, iẓẓăl ăfuss-net, iḍăs-t, innʼ-as: «Ărheeɣ-t, išdaj.» ");
INSERT INTO taq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Izzăy dăɣ-jəri ălwăqq-wen-dăɣ, šăddij. ");
INSERT INTO taq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iknʼ-e Ɣisa asəmmətăr təzzar, issəglʼ-e măšan, ");
INSERT INTO taq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","innʼ-as: «Wăr jed isălan i-ăwadəm wălʼ iyyăn, əgləw, səkən iman-năk i-u-tikutawen, təjəd takute ta s-innă alămăr wa n-Mosa dăɣ-isălan n-təšədje-năk i-ad-ăllăɣăt i-ăddinăt a-s təzzeyăd.» ");
INSERT INTO taq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Măšan, iglʼ ăhaləs-ənnin-dăɣ ɣas, wăr t-illa ere dăr-ămmoqqăs s-wădden ija dăɣ-s isălan, ăbas ăddobăt Ɣisa ad-ijjəš aɣrəm wălʼ iyyăn ar s-ufăr. Ăqqima dăɣ-tenere ad-săr-s dd-təffalăn ăddinăt išrutăn n-ăkall iket-net. ");
INSERT INTO taq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hărăt n-išilan ḍarăt-a-wen, olăs-dd Ɣisa uɣəl n-Qăfărnaxum. Ǝslăn ăddinăt a-s ihʼ ehăn wa dăɣ-itizəbbut ɣas, ");
INSERT INTO taq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","əkkăn-t-dd s-əjut har ăbas t-illa edăgg wăla-dăɣ dat-emm n-ehăn. ");
INSERT INTO taq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ămmiijrăd-asăn dihen-dăɣ a-s t-dd-osăn əkkoẓ meddən ămisawăynen anăbdon iyyăn, ");
INSERT INTO taq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","măšan, igdăl-asăn əjut n-tamətte ad-t-sănsən dat-Ɣisa. Ăɣlăyăn, ăwwănăn afălla n-ehăn, əkkăsăn-in ajobăn-wi ăsiităxnen ehăn dăɣ-tanămhăla n-edăgg wa dăɣ-ibdăd Ɣisa, ăstărarăn-dd s-axăbabu wa jăn anăbdon, insa făll-asəftăɣ-net. ");
INSERT INTO taq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Inhăy Ɣisa immun-năsăn ɣas, innă i-anăbdon: «Alyaḍ, ătwănšăn-ak ibăkkaḍăn-năk.» ");
INSERT INTO taq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Edăgg-en, han-t hărăt dăɣ-ălɣulam n-Ăṭṭăwrăt. Ǝslăn i-a-wa inna ɣas, ăbjănjănăn, ");
INSERT INTO taq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ad-jannen: «Wa ma t-ăsihălăn măjrăd-wa-dăɣ? Ăskafăr! Mi ăddoben tenăšše n-ibăkkaḍăn săl Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ilmăd Ɣisa ɣur-iman-net ălwăqq-wen-dăɣ a-wa dăɣ-zinəzjumăn, innʼ-asăn: «Mafăl tajjăšăn erk inəzjam šund-wi-dăɣ ulhawăn-năwăn? ");
INSERT INTO taq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma ojărăn tărăɣse jer-ad-tənnəd i-anăbdon: ‹Ătwănšăn-ak ibăkkaḍăn-năk,› d-ad-has-tənnəd: ‹Ǝbdəd, əḍkəl asəftăɣ-năk, ărjəš.› ");
INSERT INTO taq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ašăl-i, ăssiilmădăɣ-kăwăn a-s Ăgg-ăgg-adəm, ijraw făll-ărori n-ăkall turhajăt n-tenăšše n-ibăkkaḍăn.» Innă Ɣisa i-anăbdon ḍarăt-a-wen: ");
INSERT INTO taq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ǝnneɣ-ak, əbdəd, əḍkəl asəftăɣ-năk, əqqəl ehăn-năk.» ");
INSERT INTO taq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ibdăd, iḍkăl asəftăɣ-net ăssaɣăt-wen-dăɣ, iglă hannăyăn-t ăddinăt iket-dăɣ-năsăn. Ăqqiimăn-dd ɣas, tofʼ-en tăkunt n-a-wa ijăn, tiimələn Măssinăɣ, jannen: «A-wa ijăn ašăl-i-dăɣ, wăr kăla t-nənhăy.» ");
INSERT INTO taq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Olăs Ɣisa azăjor, ikkʼ asălim n-ejănš wa n-Galila, ad-t-dd-takkăn ăddinăt ăjjootnen, isaɣrʼ-en. ");
INSERT INTO taq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Igla dăɣ-a-wen-dăɣ a-s inhăy Lewi ăgg Ălfa, ăqqiima dăɣ-edăgg n-ălxidmăt-net, ămoos ănarmas n-tiwse, innʼ-as Ɣisa: «Ǝlkəm-ahi!» Ibdăd Lewi, ilkăm-as. ");
INSERT INTO taq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ḍarăt-a-wen, ăsmăjărăt Lewi Ɣisa s-ehăn-net. Itaɣăyma Ɣisa dăɣ-edăgg wa n-imənsiwăn a-s erk ăddinăt han inarmasăn n-tiwse ăjjootnen has-əlkamnen da-dăɣ; osăn-dd, ănɣăymăn dăr-s ənta d-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ǝnhăyăn ălɣulam n-Ăṭṭăwrăt n-taggayt ta n-kăl-faris a-s ohar Ɣisa d-erk ăddinăt d-inarmasăn n-tiwse ɣas, ənnăn i-inəṭṭulab-net: «Mafăl itihăr ălɣalim-năwăn imənsiwăn d-inarmasăn n-tiwse d-erk ăddinăt?» ");
INSERT INTO taq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Islʼ-asăn Ɣisa ɣas, innʼ-asăn: «Ăddinăt ăssoxătnen, wăr-ămɣatărăn s-lăxtur; imarhinăn a săr-s ămiɣatărnen. Năkk, wăr dd-ămešălăɣ s-ăddinăt-wi ordănen iman-năsăn iqqud, inăsbăkkaḍăn a-s dd-ămešălăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ašăl iyyăn d-ăẓumăn inəṭṭulab wi n-Exya d-kăl-faris, osăn-dd ăddinăt Ɣisa, ənnăn-as: «Mafăl inəṭṭulab wi n-Exya d-kăl-faris tuẓamăn, a-s ija a-wen wi-năk əntăneḍ, wăr tuẓamăn?» ");
INSERT INTO taq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Innʼ-asăn Ɣisa: «Ajăn kăl-tuksest, ilzam-tăn ăẓum a ikkʼ ămaẓlay illʼ-e jere-săn? A ikkʼ ămaẓlay illʼ-e jere-săn, wăr tăn-ilzem ad-uẓamăn. ");
INSERT INTO taq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ǝlkamăn išilan wi tăn-e-ifəl, dihen, ad-əjrəwăn s-ăẓum. ");
INSERT INTO taq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wăr t-illa ere itəggatăn tikəst i-temălsit wăššărăt s-taswəḍt n-tabdoɣt tăynayăt. Afăl ija a-wen, wăr-e ăhaj a-s dd-e-təsăr taswəḍt ta tăynayăt făll-temălsit ta wăššărăt, tăjj amənd ojărăn wənnin. ");
INSERT INTO taq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wăr t-illa daɣ ere itajjăn aman n-lăɣnăb ăynaynen, ăxxiimmărnen dăɣ-ijdad. Ere ijăn a-wen har kăfăn aman-ənnin dăɣ-ijdad, ad-has-səbbuqqen ijdad-net, ifut ḍarăt-a-wen dăɣ-lăɣnăb hakd-dăɣ dăɣ-ijdad. Aman n-lăɣnăb ăynaynen ăxxiimmărnen, iddidăn ăynaynen a dăɣ-tăn-itajj ăwadəm.» ");
INSERT INTO taq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ašăl iyyăn n-əssəbət-i n-ašăl wa n-tăsonfat, irăs Ɣisa d-inəṭṭulab-net išəkraš n-ălkăma ad-dăɣ-săn dd-nakkăḍăn inəṭṭulab-net tiɣăɣănen n-ălkăma. ");
INSERT INTO taq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ǝnhăyăn hărăt dăɣ-kăl-faris a-wa tăn-išlăn ɣas, ənnăn-as: «Ǝnhəy, ma isawăjjen inəṭṭulab-năk a wărăn-itətwəjj dăɣ-ašăl wa n-əssəbət-i n-tăsonfat?» ");
INSERT INTO taq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Innʼ-asăn Ɣisa: «Adiš kăwăneḍ, kăla wăr tăɣrem dăɣ-əlkəttab a-wa ija Dawəd a-s ămɣatăr, ălluẓ ənta d-imidiwăn-net. ");
INSERT INTO taq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ătwănnʼ-anăɣ, ijjăš ehăn n-Măssinăɣ dăɣ-ăzzăman wa d-ămoos Ăbyatăr ămănokal n-kăl-tikutawen, ikša dăɣ-tijəlwen-ti ămoosnen takute i-Măssinăɣ, s-wăr t-illa ere s-t-təlla tetăte-năsnăt a săl kăl-tikutawen, ikfa dăɣ-snăt daɣ meddən wi dăr-s ăddewnen.» ");
INSERT INTO taq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Innʼ-asăn daɣ: «Wădden ăgg-adəm a dd-ixlăkăn i-əssəbət, ănn-ak, əssəbət a dd-ixlăkăn i-tănoflayt n-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A-wen-dăɣ a făl Ăgg-ăgg-adəm, a ănnihăḍăn dăɣ a-wa s-ila ăgg-adəm d-a-wa s-wăr ila s-ad-t-ăj, dăɣ-ašăl wa n-əssəbət-i n-tăsonfat.» ");
INSERT INTO taq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Olăs Ɣisa ḍarăt-a-wen ujəš n-ehăn n-ăddin wa n-kăl-Ălyăhud. Illʼ-e dihen ăhaləs s-ăqqur ăfuss-net. ");
INSERT INTO taq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jan-as kăl-faris ənniyăt, tassănăn ihăl ad-t-izuzəy dăɣ-ašăl n-ălɣibadăt, əjrəwăn ya ăsaru s-t-əssəḍlămăn. ");
INSERT INTO taq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Innă Ɣisa i-ăhaləs wa s-ăqqur ăfuss-net: «Ǝyyăw, əbdəd dăɣ-ammas n-ălžămaɣăt.» ");
INSERT INTO taq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Innă i-ălžămaɣăt ḍarăt-a-wen: «Ak a xălalăn dăɣ-ašăl wa n-əssəbət-i n-tăsonfat iji n-emărked, meɣ iji n-a lăbasăn, igguẓ n-iman, meɣ iji n-iman?» Wăr t-illa ere has-innan hărăt. ");
INSERT INTO taq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Issăɣlăy-tăn-dd asăwaḍ n-aḍkăr irtayăn d-tisnant făl təssəba n-tăɣart-i jăn ulhawăn-năsăn, innă ḍarăt-a-wen i-ăhaləs: «Ǝẓẓəl ăfuss-năk». Iẓẓăl ăfuss-net, izzăy. ");
INSERT INTO taq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ǝzjărăn kăl-faris edăgg-en ɣas, ănmănhăyăn d-taggayt ta n-kăl-Harudəs dăɣ-isălan n-əmmək wa s-mad-əjən iman n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ăddew Ɣisa ḍarăt-a-wen d-inəṭṭulab-net s-asălim n-ejănš wa n-Galila, tăddew-dd săr-s tamətte tăjjeet dd-falăt teje ta n-Galila d-ta n-Ălyăhudəyăt, ");
INSERT INTO taq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","iyyăḍ falăn-dd Yărussălam, iyyăḍ ăkall wa n-Iduma d-ăkall wa iwărăn ašrut wa n-emăynăj n-ejănš wa n-Ɣurdəni d-iɣărman wi n-Tir d-Săyda d-ălžămaɣăt ăjjeen dd-ikkan daw-măsăllăt n-hărătăn wi ităjj. ");
INSERT INTO taq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Innă Ɣisa i-inəṭṭulab-net ălwăqq-wen, ad-has-səmməjnun turăft n-aman ijjăš i-ad-wăr t-tăsnăkmăm tamətte ");
INSERT INTO taq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","făl-a-s ăzozăy dăɣ-săn i ăjjootnen hundăɣ har ămăra-dăɣ, əqqălăn-dd ăddinăt hak iyyăn itikəl amidi-net făl tărha n-ad-t-ăḍəsən. ");
INSERT INTO taq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iməlšan əntăneḍ, e-d t-ənhăyăn, ad-ărkăɣăn data-s, saɣăren, jannen: «Kăyy a-s Rure-s n-Măssinăɣ» ");
INSERT INTO taq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","măšan, ikann dăɣ-săn asəmmăhəḍ i-ad-wăr-əllăɣen ere wa ămoos. ");
INSERT INTO taq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iwwăn Ɣisa ḍarăt-a-wen taḍaɣt, iɣră-dd s-iman-net inəṭṭulab wi s-irha, əkkăn-t-dd. ");
INSERT INTO taq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ăsnăfrăn dăɣ-săn măraw d-əssin wi s-irha i-ad-t-əllan ɣur-s, ăswăr-tăn isəm inəmmušal wi n-inaxṭabăn n-Ălənžil, ");
INSERT INTO taq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ikfʼ-en daɣ tărna n-ukəs n-alšinăn dăɣ-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ǝntăneḍ-da wi n-măraw d-əssin ăsnăfrăn: Simyon wa ăswăr isəm Bəṭrus; ");
INSERT INTO taq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaqub d-ăŋŋa-s Exya, wi n-dăgg-Zăbdi s-ijʼ isəm Boyărnažəs, a-wen ălmăɣna-net: dăgg-ejjaj; ");
INSERT INTO taq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Idris d-Fəlibb d-Bărtălămma d-Mătti d-Tomi d-Yaqub wa n-ăgg Ălfa d-Tade d-Simyon wa n-ăššažeɣ ");
INSERT INTO taq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","d-Yăhudəs Isxaryut-i t-e-isəssăɣdărăn. ");
INSERT INTO taq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iqqăl-dd Ɣisa ehăn ɣas, olăs-dd fălla-s ălžămaɣăt tidawt har ăbas ijraw ənta d-inəṭṭulab-net wăla ălwăqq s-ăssokăn hărăt imawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ǝslăn kăl-ehăn-net i-a-wen ɣas, əkkăn-t-dd i-ad-t-ărməsăn făl-a-s jannen: «A-wa, immar-t hărăt.» ");
INSERT INTO taq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ǝggădăn ălɣulam n-Ăṭṭăwrăt wi dd-fălnen Yărussălam, ənnăn: «A-wa Abălzăbil, Iblis wa n-ămănokal n-alšinăn a t-ihan, ənta a t-ikfăn tărna ta s-itakkăs alšinăn dăɣ-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iɣrʼ-en-dd Ɣisa, issăɣlăy-tăn tangalt dăɣ-hasăn-inna: «Ǝndek əmmək wa s-tordam a-s Iblis ăddoobăt, ad-dd-iqqəl isattăɣ Iblis? ");
INSERT INTO taq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Afăl dd-əqqălăn kăl-iyyăn n-əddəwəl əknasăn jer-iman-năsăn, əddəwəl-en, wăr-e ăhaj ibdad. ");
INSERT INTO taq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ehăn daɣ s-dd-əqqălăn məssaw-s əknasăn jer-iman-năsăn, ehăn-en, wăr-e ăhaj ibdad. ");
INSERT INTO taq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Afăl ibdăd Iblis i-iməššerəkăn-net, ad-tăn-ikannăs, wăr-e ăhaj ibdad, sămdo-net ɣas a ikka. ");
INSERT INTO taq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wăr t-illa ere ăddoben ujəš n-ehăn n-ăhaləs n-anăkfor, awəy ilalăn-net ar s-ad-t-ikrad təzzar, dihen, ad-udabăt ad-awəy a-wa ihăn ehăn-net.» ");
INSERT INTO taq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Ăsidătteɣ-awăn a-s abăkkaḍ ofʼ-ăgg-adəm d-asəkkufăr ija-dăɣ, ăddoobăt Măssinăɣ ad-has-t-in-ănš, ");
INSERT INTO taq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","măšan ăwadəm wa ăskafărăn dăɣ-isălan n-Unfas Šăddijăn, wăr-ilkem ad-has-in-ătiwănša, ed iwăr-t uḍlem n-abăkkaḍ iɣlalăn.» ");
INSERT INTO taq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ijʼ-asăn Ɣisa măjrăd-wa-dăɣ făl a ənnin s-ənnăn: «Ihʼ-e alšin.» ");
INSERT INTO taq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Osăn-dd ayətma-s n-Ɣisa ăddeewăn d-ma-s, əbdădăn dat-emm n-ehăn, ăšmašălăn-dd săr-s ăwadəm i-ad-hasăn-t-dd-iɣăr. ");
INSERT INTO taq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A-s ităjj a-wen-dăɣ, ăqqiima Ɣisa jer-tamətte has-jat afăraj; ənnăn-as ăddinăt: «Təbdad ma-k d-ayətma-k d-šătma-k dat-emm n-ehăn, sastanăn dăr-k.» ");
INSERT INTO taq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Innʼ-asăn: «Ǝndek anna-nin d-ayətma-ɣ d-šătma-ɣ?» ");
INSERT INTO taq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Issăɣlăy-dd tamətte ta tăqqiimăt akăyad-net, innă: «Ǝnhəywăt anna-nin d-ayətma-ɣ, əntăneḍ-da-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","E d t-illăm ere itamašalăn erhet n-Măssinăɣ, ənta a-s ăŋŋa-ɣ d-wălătma-ɣ d-ma-ɣ.» ");
INSERT INTO taq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Olăs Ɣisa daɣ asəɣăr n-tamətte dăɣ-asălim n-ejănš wa n-Galila. Tăddew-dd săr-s tamətte tăjjeet, ijjăš-as turăft n-aman, ăqqima dăɣ-s, tăqqimă-dd tamətte ənta təbdad dăɣ-asălim n-aman, tăsijăd-as. ");
INSERT INTO taq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Issăɣra ăddinăt hărătăn ăjjootnen s-tangalen. Dăɣ-a-wa tăn-issăɣra, innʼ-asăn ašăl iyyăn: ");
INSERT INTO taq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Săjdăt! Kăla izjăr ănăsdamu iyyăn i-ad-iddumət ašəkrəš-net. ");
INSERT INTO taq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ălwăqq wa d-itidumut, oḍănăt tiblalen tiyyăḍ dăɣ-ăbara, ăkkukăren-tănăt-dd igḍaḍ, əkšăn-tănăt. ");
INSERT INTO taq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oḍa ašăr iyyăn jer-tihun, ăffoqqăt-dd šik ed wăr-intem dăɣ-ăkall, ");
INSERT INTO taq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","tăsmăqqăt-dd tăfukt jənnəj-s, təssărɣa isəffuqqa, ăqqur-in a-di iket-net ed wăr-əntemăn ikewăn-net dăɣ-hărăt. ");
INSERT INTO taq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oḍa ašăr iyyăn dăɣ-tabəŋŋənt, tədwăl-dd fălla-s tabəŋŋənt, təẓmăd-as, iɣrăy-in. ");
INSERT INTO taq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oḍa ašăr wa iyyăḍăn dăɣ-ăkall olaɣăn, ikrăš aratăn; ijă tibolăsen s-tiyyăḍ kăraḍăt timərwen n-tablalt a tănăt-iwarăn, tiyyăḍ săḍisăt timərwen, tiyyăḍ temeḍe.» ");
INSERT INTO taq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Innʼ-asăn ḍarăt-a-wen: «Ere ilăn timəẓẓujen s-islă-dăɣ, isăjdet!» ");
INSERT INTO taq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Izjăr-dd Ɣisa ălžămaɣăt ɣas, əssəstănăn-t inəṭṭulab-net wi n-măraw d-əssin, d-ăddinăt wi săr-s dd-saɣlaynen d-ălmăɣna n-tangalen ti ija. ");
INSERT INTO taq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Innʼ-asăn: «Kăwăneḍ, təjrawăm turhajăt n-ujreh n-əddăraj wa ămoosăn isălan n-Təmmənəya n-Măssinăɣ măšan, ăddinăt wi iyyăḍnen n-ajăma, a-wa s-e-əslən iket-net, tangalen a dăɣ-has-e-əslən i-innin: ");
INSERT INTO taq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‹Ad-əswaḍăn, wăr hənnəyăn, ăsijădăn, wăr səllən; i-ad-wăr t-illa a jarrăhăn, i-udaɣ ad-utabăn s-Măssinăɣ, əjrəwăn tenăšše.› » ");
INSERT INTO taq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Innʼ-asăn daɣ: «Ɣas ta-dăɣ tangalt, wăr tăt-təjrehăm? Adiš əndek əmmək wa s-mad-təjrăhăm tangalen ti iyyăḍnen? ");
INSERT INTO taq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ănăsdamu, ənta a-s ănaxṭab n-măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ăddinăt iyyăḍ, olăhăn d-ăbara wa dăɣ-oḍănăt tiblalen. E-d əslăn i-măjrăd n-Măssinăɣ, šik a-s tăn-dd-itis Iblis, isəttəw-asăn-t-in. ");
INSERT INTO taq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ăddinăt iyyăḍ, olăhăn d-tihun-ti jer-oḍănăt tiblalen; e-d əslăn i-măjrăd n-Măssinăɣ, ad-əhləyləyăn, ăqbəlăn-t šik ");
INSERT INTO taq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","măšan, wăr t-təyyən ikraš ikewăn dăɣ-ulhawăn-năsăn, ad-əjən ăzzăman ənḍărrăn ăkoyădăn dăɣ-s măšan afăl dd-tosa tissust meɣ osă-dd ălɣizabăt dăɣ-təssəba n-măjrăd n-Măssinăɣ, ad-hin-əbbuṭṭəlăn a-wa s-omănăn. ");
INSERT INTO taq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ăddinăt iyyăḍ, əntăneḍ a-s tabəŋŋənt ta jer-oḍănăt tiblalen, ad-əslən i-măjrăd n-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","măšan, ad-has-əẓmədăn dăɣ-ulhawăn-năsăn s-tărha n-wălăt-ăddunya d-eylăl n-tărha n-ajmur-net d-derhanăn iyyăḍ ăjjootnen, wăr t-illa a săr-săn dd-isaɣsal. ");
INSERT INTO taq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ăddinăt wi iyyăḍnen, əntăneḍ a-s ăkall wa olăɣăn dăɣ-oḍănăt tiblalen. Ǝntăneḍ a-s e-d əslăn i-măjrăd n-Măssinăɣ, ad-t-ăqbəlăn, ijjəš-asăn-t ălfăyda; tarəw-dd săr-săn tablalt tiyyăt kăraḍăt timərwen n-tablalt, tiyyăt săḍisăt timərwen, tiyyăt temeḍe n-tablalt.» ");
INSERT INTO taq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Innʼ-asăn Ɣisa daɣ: «Ăwadəm, wăr-isărmis tefătelt təzzar, ăjʼ-et daw-ăkoss meɣ daw-tešejit, ănn-ak, edăgg iḍkalăn a făll-tăt-e-isăns. ");
INSERT INTO taq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wăr t-illa a iffarăn s-wădden ad-dd-infiləl, wăr t-təlla takše s-wădden ad-dd-təffukkăr. ");
INSERT INTO taq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ere dăɣ-wăn ilăn timəẓẓujen s-islă-dăɣ, isăjdet! ");
INSERT INTO taq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ăjăt ənniyăt i-a-wa s-sallăm făl-a-s, a-wa dăr-ogdăh asjəd wa tăjjăm i-Măssinăɣ ad-dăr-mad-agdăh daɣ ajăraw-năwăn ɣur-s. ");
INSERT INTO taq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ăwadəm wa s-išwăr ifhăm hărăt, ad-has-iwwaḍ musnăt har isəssikəy măšan, wa s-wăr t-illa a ijrah, wăr t-in-ikka hărăt, ănn-ak, ad-dăɣ-s ămahăɣ wăla a-wa ənḍărrăn iṭṭăf.» ");
INSERT INTO taq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Innʼ-asăn daɣ: «Sănto n-Təmmənəya n-Măssinăɣ, olăh d-a-wa s-e-d ăddomăt ăwadəm ašəkrəš-net, ");
INSERT INTO taq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jer-iṭṭas wăla okay, jer-ehăḍ wălʼ ašăl, ad-idaggăl ădomm dăɣ-ašəkrəš, itifăqqut-dd, dăɣ-a-s, wăr təha tijya n-a-wen măssi-s ed, ");
INSERT INTO taq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ăkall a dd-madăn-arəw d-iman-net teyəšše s-tizarăt, ḍara-s teɣăɣănt, təzjăr-dd tejent n-ălkăma teɣăɣănt. ");
INSERT INTO taq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Diha-dăɣ d-mad-inhəy măssi-s n-ašəkrəš a-s iŋŋa ălkăma, ad-dd-mad-iḍkəl ălgori-net i-illuy-net.» ");
INSERT INTO taq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Innʼ-asăn ḍarăt-a-wen: «Ma dăr-mad-nəsəssilăh sănto n-Təmmənəya n-Măssinăɣ? Ǝndek ɣas tangalt tăsisăjrăhăt sănto-net? ");
INSERT INTO taq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sănto n-Təmmənəya n-Măssinăɣ, olăh d-temătăwt ta tojărăt təmmətkit dăɣ-idommăn. A-s tăt-itidumut ăwadəm, wăr t-təlla temătăwt dăɣ-ăddunya tăt-tojărăt təmmətkit, ");
INSERT INTO taq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","măšan, hakd a-wen-dăɣ, afăl tăt-ăddomăt ăwadəm, ad-dd-tăjj tadăwla-i-dăɣ măqqărăt, tajăr tiyəššawen iket-năsnăt təššəjrət, təkrəš iləktan-i-dăɣ măqqornen har wăla-dăɣ igḍaḍ, kallăn daw-tele-net.» ");
INSERT INTO taq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tangalen ăjjootnen olăhnen d-ti-dăɣ, s-ălxal ăsisăjrăhăn a-s issăɣra Ɣisa ăddinăt; ");
INSERT INTO taq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","wăr t-illa a inna i-tamətte s-wădden tangalen a dăɣ-hasăn-t-innă măšan, e-d ănmăjrăw d-inəṭṭulab-net dăɣ-edăgg iṣtarăn, ad-hasăn-ăffăssăr ălmăɣna n-tangalen-tin-dăɣ iket-năsnăt. ");
INSERT INTO taq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Toḍa tăfukt ɣas, innă i-inəṭṭulab-net: «Nəjləyet ejănš s-ašrut wa n-emăynăj.» ");
INSERT INTO taq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Fălăn tamətte, əglăn dăr-s inəṭṭulab dăɣ-turăft n-aman ta dăɣ-ăqqiima, ăddeewnăt dăr-săn daɣ turfen n-aman tiyyăḍ. ");
INSERT INTO taq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ǝglan a-s dd-inkăr aḍu-i-dăɣ ăṣṣoohen, ad-tibhilbəhilnăt tinăzzămăren i-turăft har išwar təḍnay aman. ");
INSERT INTO taq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A-s ităjj a-wen, ăssoomăt Ɣisa adăfor, iṭṭas dăɣ-ajilal n-turăft n-aman. Ǝssənkărăn-t inəṭṭulab dăɣ-eḍəs, ənnăn-as: «Ălɣalim! Ajăn wăr kăy-təssărmăɣ tamăttant-nănăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Inkăr-dd, ăsmăhăḍ făll-aḍu, innă i-ejănš: «Ismaḍ! Ǝzjəw!» Ibdăd-in aḍu, sămmeḍ-in a-wen-dăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Innʼ-asăn ḍarăt-a-wen: «Ma-kăwăn ăssiirmăɣăn? Ma ija immun-năwăn?» ");
INSERT INTO taq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jăn inəṭṭulab tarəmmeɣt-ta-dăɣ făl dd-əqqălăn ɣas, tinmənnin: «Ma ămoos ăwadəm-wa-dăɣ s-wăla aḍu d-ejănš, sajadăn-as?» ");
INSERT INTO taq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ǝwwăḍăn-in ašrut n-ejănš wa iyyăḍăn, a-wen dăɣ-ăkall wa n-Gadara. ");
INSERT INTO taq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Diha-dăɣ dd-izjăr Ɣisa turăft n-aman, ad-has-dd-ilkăḍ amălšon dd-izjarăn tiẓəska. ");
INSERT INTO taq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dihen-dăɣ ad-izzaɣ, wăr t-illa ăwadəm ăddoben akărad-net wăla-dăɣ s-tišəm. ");
INSERT INTO taq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akărad has-jăn ăddinăt s-tifren hakd tišəm-dăɣ, ad-tănăt-dd-isăqqətəs, wăr t-illa făw ere ăddoben a dăɣ-s ănnăhăḍ. ");
INSERT INTO taq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ehăḍ d-ašăl iha tiẓəska, meɣ ošal făll-iḍaɣăn, inaḍḍăw iɣăran, išašar iman-net s-tihun. ");
INSERT INTO taq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ojja Ɣisa dăɣ-ijəj ɣas, ošăl-dd săr-s, irkăɣ data-s, ");
INSERT INTO taq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","iḍkăl emăsli-net, innă: «Ɣisa, Rure-s n-Măssinăɣ wa iknăn aḍkul, ma dăɣ-i tărhed? Făl Măssinăɣ, wăr hi-tăqquzzăbed.» ");
INSERT INTO taq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Alšin wa t-ihăn a ijannen a-wen ed isamăhaḍ Ɣisa fălla-s i-ad-t-izjăr. ");
INSERT INTO taq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Issəstăn-t Ɣisa, innʼ-as: «Mi isəm-năk?» Innʼ-as ăhaləs: «Isəm-in: ejhăn ed nəjjət.» ");
INSERT INTO taq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ad-laqqădăn alšinăn wi t-hănen Ɣisa i-ad-tăn-wăr-ikkes dăɣ-ăkall. ");
INSERT INTO taq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A-s ităjj a-wen-dăɣ, iḍan ehăre n-əlxənžărăn făll-tasăja n-taḍaɣt hat attayăn-en-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ad-laqqădăn alšinăn Ɣisa, jannen-as: «Suk-anăɣ əlxənžărăn i-ad-tăn-nəjjəš.» ");
INSERT INTO taq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Irḍʼ-asăn s-a-wen. Ǝzjărăn alšinăn ăhaləs, əjjăšăn əlxənžărăn, ad-dd-titrəktərikăn a iwwăḍăn əssin afḍăn n-əlxənžăr, wa-dăɣ n-afălla n-taḍaɣt, tiḍəwăn dăɣ-ejănš, tattăn-tăn aman. ");
INSERT INTO taq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ǝnhăyăn imăḍanăn n-əlxənžărăn a-wa ijăn ɣas, ăjewăḍăn. Ošălăn, jăn isălan dăɣ-kăl-aɣrəm d-attayăn-net. Ad-dd-tišəl tamətte, tiwnifit-dd a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Osăn-dd ăddinăt edăgg wa iha Ɣisa, ogăẓăn-dd amălšon wa s-kăla t-ihʼ ejhăn n-alšinăn, ăqqiima, ijʼ isəlsa, təhʼ-e daɣ tijya n-iman-net. ");
INSERT INTO taq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jăn dăɣ-săn ăddinăt wi ăjjəyhnen i-a-wa ijrăwăn amălšon d-əlxənžărăn isălan ɣas, ");
INSERT INTO taq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ad-təddalăn Ɣisa d-ad-ifəl ăkall-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ălwăqq wa d-itajjăš Ɣisa turăft n-aman, ikkʼ-e-hi-dd ăhaləs wa s-kăla t-hăn alšinăn, ad-t-ilaqqăd d-ad-dăr-s idaw. ");
INSERT INTO taq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wăr has-irḍa Ɣisa s-a-wen, ănn-ak, innʼ-as: «Ǝgləw, əqqəl ehăn-năk, diha t-əllăn išăqqaɣăn-năk, tăllăɣed-asăn təmɣăre n-a-wa hak-ija Emăli d-əmmək wa s-hak-oḍăn tăhanint.» ");
INSERT INTO taq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iglă, ad-itajj isălan n-təmɣăre n-a-wa has-ija Ɣisa dăɣ-teje ta jăt isəm: «Ta n-măraw iɣărman». Ere has-islăn-dăɣ, ad-dd-iqqəl ɣas ăkun dăɣ-isălan-net. ");
INSERT INTO taq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Izjăr Ɣisa ḍarăt-a-wen s-asălim n-ejănš wa iyyăḍăn, diha-dăɣ dd-ăsjănăn dăɣ-asălim n-aman, ad-săr-s dd-tăddew tamətte tăjjeet. ");
INSERT INTO taq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Osʼ-e-hi-dd dihen iyyăn dăɣ-ălfăqqităn n-ehăn n-ăddin wa n-kăl-Ălyăhud n-taɣrəmt-en s-isəm-net Žayrus, inhăy Ɣisa ɣas, irkăɣ data-s, ");
INSERT INTO taq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ad-t-itəddal, ijannʼ-as: «Talyaḍt-in, tăbok i-iba, nidawet săr-s, sənsəd fălla-s ifassăn-năk, ad-təzzəy, təddăr.» ");
INSERT INTO taq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ăddew dăr-s Ɣisa, təlkam-as daɣ tamətte tăjjeet t-tăsinăkmămăt. ");
INSERT INTO taq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tamətte-en, hʼ-et tamăḍt ijammăḍ ašni a ilan măraw iwətyan d-əssin, ");
INSERT INTO taq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","təkna ahănay n-aɣăna jer-ifassăn n-lăxturtăn, tăsmălkăw-in a-wa təla iket-net măšan, wăr t-illa făw a-hin-ifnaẓăn dăɣ-turhənna-net, ănn-ak, tiwwaḍt ɣas ad-dd-tajj fălla-s. ");
INSERT INTO taq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Təslʼ isălan n-Ɣisa ɣas, təjjăš-dd tamətte s-ḍarăt, ḍăs erăswăy-net, ");
INSERT INTO taq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ed a-s tăjj a-wen-dăɣ, janna: «Wăla erăswăy-net, kud-t-ḍăsăɣ, ad-əzzəyăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Diha-dăɣ d-ḍăs erăswăy-net, ad-iktăl ašni wa tăt-dd-izajjărăn, tofrăy ăssaɣăt-wen-dăɣ dăɣ-taɣəssa-net a-s təzzăy dăɣ-tiẓẓurt-net. ");
INSERT INTO taq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ilmăd Ɣisa ɣur-iman-net, ălwăqq-wen-dăɣ, făl tărna ta t-dd-təjmăḍăt, innăḍ-dd s-tamətte, innă: «Mi iḍăsăn isəlsa-nin?» ");
INSERT INTO taq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ǝnnăn-as inəṭṭulab-net: «Ajăn wăr hənnəyăd tamətte ta kăy-tăsinăkmămăt a-s jănned: ‹Mi hi-iḍăsăn?› » ");
INSERT INTO taq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Issăɣlăy-tăn-dd akăyad-net i-ad-inhəy ta t-təḍăsăt. ");
INSERT INTO taq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tənhăy tamăḍt ălafu wa təjrăw ɣas, təkkʼ-e-hi-dd, tăšikăḍkăḍ a-wa-dăɣ has-ja tarəmmeɣt, toḍa data-s, tənnʼ-as tidət iket-net. ");
INSERT INTO taq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Innʼ-as Ɣisa: «Talyaḍt, ăzozăy-kăm immun-năm, əgləw dăɣ-ălxer, təzzeyăd dăɣ-tiẓẓurt-năm.» ");
INSERT INTO taq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ămmiijrăd Ɣisa hărwa a-s dd-osăn ăddinăt dd-falnen eɣewən n-ălfăqqi n-ehăn wa n-ăddin, ənnăn-as: «Elle-k, ăba-tăt. Ma s-salăyyaɣăd Ălɣalim daɣ?» ");
INSERT INTO taq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wăr hin-ijreh Ɣisa a-wa jănnen, innă i-ălfăqqi n-ehăn wa n-ăddin: «Wăr tărmeɣăd, amən ɣas.» ");
INSERT INTO taq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Igdăl Ɣisa i-ăddinăt iket-năsăn ad-dăr-s idawăn a-s təggădăd Bəṭrus d-Yaqub d-Exya wa n-ăŋŋa-s. ");
INSERT INTO taq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","A-s hin-əwwăḍăn eɣewən n-emănnăhăḍ n-ehăn wa n-ăddin, wăr hin-ogeẓăn ar tamətte tədgaẓăt; ăsikălăl, ăššurša a-wen-dăɣ, dăɣ-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ijjăš-in fălla-săn, innʼ-asăn: «Ma kăwăn-idgaẓăn, hallăm? Tarat, wăr tăt-ăba, eḍəs ɣas a ja.» ");
INSERT INTO taq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jăn-t tekăškăšt. Izzəzjăr-tăn iket-dăɣ-năsăn, wăr dd-ăqqima dihen ar d-ti-s d-ma-s n-talyaḍt, d-inəṭṭulab wi dăr-dd-ăddew. Ijjăš ḍarăt-a-wen edăgg wa dăɣ-tənsa talyaḍt, ");
INSERT INTO taq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","irmăs-tăt-dd s-ăfuss, innʼ-as: «Talita kumi», a-wen ălmăɣna-net: «Talyaḍt, ənneɣ-am, ənkăr-dd.» ");
INSERT INTO taq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Təbdăd talyaḍt ăssaɣăt-wen-dăɣ, tărjăš. Talyaḍt-en-dăɣ, la măraw iwətyan d-əssin. Ǝqqălăn-dd ăddinăt ɣas oran imawăn făl tihusay n-a-wa-dăɣ ijăn. ");
INSERT INTO taq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iknʼ-en-dăɣ Ɣisa asəmmətăr i-ad-wăr jen isălan n-a-wa ijăn dăɣ-ăwadəm wălʼ iyyăn təzzar, innʼ-asăn ad-tăt-əkfən a təkša. ");
INSERT INTO taq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ifăl Ɣisa dihen, ăddew d-inəṭṭulab-net s-taɣrəmt ta dăɣ-idwăl. ");
INSERT INTO taq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ašăl wa n-əssəbət-i n-tăsonfat, ijjăš ehăn n-ăddin wa n-kăl-Ălyăhud, ad-dăɣ-s isaɣra. Ăsijădăn-as ăddinăt ăjjootnen ăkuunnen dăɣ-a-wa ijanna, əqqălăn-dd ɣas oran imawăn, jannen: «Ăhaləs-wa-dăɣ, əndek siha s-t-dd-iha a-wa ităjj? Mi t-ikfăn təlɣuləma d-tădabit n-iji n-tikunen ti ităjj? ");
INSERT INTO taq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ak a-wa, ajăn wădden Ɣisa wa n-mənizye n-rure-s n-Măryăma n-ăŋŋa-s n-Yaqub d-Yusəf d-Hudd d-Simyon? Wădden šătma-s da-dăɣ əzzăɣnen jere-năɣ.» Jăn-as a-wen-dăɣ s-t-əzzayăn asăkor, unjăyăn săr-s omănăn. ");
INSERT INTO taq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Innʼ-asăn: «Ănnăbi, wăr t-illʼ edăgg s-wădden ătiwăsămɣăr dăɣ-s, ar dăɣ-ăkall-net, d-ɣur-imărawăn-net d-dăɣ-ehăn-net.» ");
INSERT INTO taq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Igdăl-as a-wen-dăɣ, ad-ɣur-săn ăj tikunen săl hărăt dăɣ-imarhinăn făll-ăssinsa ifassăn-net, əzzăyăn. ");
INSERT INTO taq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tofʼ-e tăkunt n-iba n-immun-năsăn. Issăɣlăy-dd ḍarăt-a-wen dăɣ-attayăn n-tidbi-en-dăɣ, isaɣra ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iɣră-dd Ɣisa inəṭṭulab-net wi n-măraw d-əssin ḍarăt-a-wen, ăšmašăl-tăn s-əssin-əssin dăɣ-a-s tăn-ikfa tărna făll-alšinăn. ");
INSERT INTO taq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ăsmătăr-tăn, innʼ-asăn: «Wăr təḍkelăm dăɣ-asikəl-năwăn a săl tăborit; wăr tăwweyăm ăzzad, wăla šăkkoš, wălʼ aẓrəf, ");
INSERT INTO taq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","asəsăt tifădelen-năwăn, wăr jem əssin irăswăyăn.» ");
INSERT INTO taq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Innʼ-asăn daɣ: «Ehăn təjjăšăm-dăɣ, təzzăɣăm dăɣ-s har ašăl wa d-tăssawăḍăm tekle. ");
INSERT INTO taq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Edăgg tosăm-dăɣ, wăr kăwăn-ăsbărrăkăn məssaw-s, unjăyăn s-asjəd-hawăn, əzjărăt-t, tăbbăkbăkăm tifădelen-năwăn i-ad-wăr tănăt-iləttăɣ wăla-dăɣ ăboqqal-net. Ilkam, ad-ăjjăyh a-wen fălla-săn.» ");
INSERT INTO taq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ǝglăn inəṭṭulab, ad-xaṭṭăbăn i-ăddinăt i-ad-utabăn, ");
INSERT INTO taq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","takkăsăn daɣ alšinăn ăjjootnen dăɣ-ăddinăt, šawwăyăn inəbdan s-əzzăyt, zizuyăn-tăn. ");
INSERT INTO taq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Islʼ ămănokal Harudəs mawmaw n-Ɣisa ed ihʼ isəm-net imawăn n-ăddinăt iket-năsăn. Jannen iyyăḍ dăɣ-săn: «A-wa Exya wa n-Enəsselmăɣ a dd-inkărăn jer-inəmmuttan, a-wen-dăɣ a t-ikfăn tădabit n-tikunen-ti itamašal.» ");
INSERT INTO taq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jannen iyyăḍ: «Ăbo, a-di ănnăbi Ɣəli», jannen wi iyyăḍnen: «A-wa iyyăn dăɣ-ănnăbităn wi n-ibda.» ");
INSERT INTO taq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Islă Harudəs i-a-wen ɣas, innă ənta: «A-wa Exya wa s-əssəfrăsăɣ eɣăf-net, ənta a dd-olăsăn tanăkra jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ăzzăman-en, Harudəs iman-net a omărăn s-ad-ăttărmăs Exya, ijjəš tišəm, itwəjăr-in dăɣ-takărmut, dăɣ-təssəba n-Harudəyăt ta n-hănne-s n-ăŋŋa-s Fəlibb dăɣ-s ohăɣ Harudəs, ");
INSERT INTO taq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","făl-a-s innin, innʼ-as Exya: «Wăr hak-xălal, ad-tărkəbăd hănne-s n-ăŋŋa-k.» ");
INSERT INTO taq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Təkšăr ya Harudəyăt Exya făl a-wen-dăɣ, ad-tattăr tamăttant-net măšan, wăr hənnəy tašləlt s-ja a-wen. ");
INSERT INTO taq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ăksuḍ daɣ Harudəs Exya ed, issan a-s ăhaləs oɣadăn n-eməššeddəj a ămoos, ogaẓ-t dăɣ-təssəba n-a-wen-dăɣ. E-d has-ăsjăd ămmiijrăd, ad-t-əkmun iman-net kud-dăɣ, ijraẓ-as asjəd-has. ");
INSERT INTO taq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Han a-wen-dăɣ a-s dd-tosa taməntelt ta s-taqqăl Harudəyăt a ija a-wa-dăɣ. Ašăl d-tajjăn iməšlan wi n-isəkta n-tiwit n-Harudəs, ăsmăjarăt-dd Harudəs kăl-əlxəkum-net d-kumăndatăn n-əlɣəskăr-net d-imizărăn n-teje ta n-Galila, ");
INSERT INTO taq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","təjjăš-dd elle-s n-Harudəyăt, ad-dallăl data-săn, ijrăẓ a-wen i-Harudəs d-imăjarăn-net. Iɣră-dd ămănokal talyaḍt, innʼ-as: «Ǝttăr dăɣ-i a-wa tărhed, ad-ham-t-ăkfăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ad-has-itəhhaḍ s-ad-tăt-ăkf a-wa dăɣ-s təttăr, kud-irha umas tăẓune n-ăkall-net. ");
INSERT INTO taq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Təzjăr talyaḍt, tənnă i-ma-s: «Ma dăɣ-s mad-əttărăɣ?» Tənnʼ-as ma-s: «Ǝttăr dăɣ-s eɣăf n-Exya wa n-Enəsselmăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tăqqăl-dd ămănokal šik, tənnʼ-as: «Ărheɣ ad-hi-təkfəd ămăra-dăɣ eɣăf n-Exya wa n-Enəsselmăɣ insa dăɣ-aẓăwa.» ");
INSERT INTO taq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ǝnxăsăn iman n-ămănokal hullan măšan, ăbas ăddoobăt uɣəl s-a-wa inna, ed ihăḍ-as s-ad-tăt-ăkf a-wa dăɣ-s mad-təttăr, a ămoos-dăɣ, dat-imăjarăn-net, wăr-irha daɣ ad-ărẓ dăɣ-tənna-net i-talyaḍt. ");
INSERT INTO taq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ăšmašăl ăssaɣăt-wen-dăɣ əssărdasi dăɣ-wi jănen ənniyăt i-ehăn-net i-ad-dd-ifrəs eɣăf n-Exya. Ikkʼ əssărdasi takărmut ta ihʼ Exya, ifrăs-dd eɣăf-net, ");
INSERT INTO taq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","iwwăy-t-dd insa dăɣ-aẓăwa, ikfʼ-e i-talyaḍt, təkfʼ-e talyaḍt i-ma-s. ");
INSERT INTO taq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ǝslăn inəṭṭulab n-Exya tamăttant-net ɣas, əglăn, əḍkălăn-dd tafəkka-net, əẓkăn-t. ");
INSERT INTO taq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ǝqqălăn-dd inəṭṭulab wi ăšmašăl Ɣisa, jăn dăɣ-s isălan n-a-wa jăn d-a-wa əssăɣrăn iket-net. ");
INSERT INTO taq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Innʼ-asăn: «Năkket edăgg n-iman-nănăɣ, sunfəm a ənḍărrăn.» Ijʼ-asăn măjrăd-wen-dăɣ, făl-a-s igdăl-asăn, əjut n-emerjaš n-ăddinăt wăla ăssaɣăt s-ăssokăn hărăt imawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ǝjjăšăn turăft n-aman, əkkăn tenere n-iman-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ǝnhăyăn-tăn ăddinăt ăjjootnen a-s əglăn, əzzăyăn-tăn ɣas, fălăn-dd iɣărman iket-năsăn, ošălăn-dd har hasăn-ăzzarăn făw s-edăgg wa əkkăn. ");
INSERT INTO taq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Izjăr-dd Ɣisa turăft n-aman, inhăy əjut wa jăn ăddinăt ɣas, tănɣʼ-e tăhanint-năsăn ed, olăhăn ɣas d-tihatten wăren la amăḍan, ad-tăn-isaɣra hărătăn ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Toḍa tăfukt ɣas, osăn-t-dd inəṭṭulab-net, ənnăn-as: «Năkkăneḍ, edăgg n-tenere a nəha, ijʼ-anăɣ ehăḍ; ");
INSERT INTO taq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","səgləw ăddinăt, ad-əkkən tidbi d-imăzzaɣăn wi ohăẓnen, žənšən-dd a əkšăn.» ");
INSERT INTO taq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Un, ăkfăt-tăn a əkšăn.» Ǝnnăn-as: «Ajăn a tărhed ad-năkk aɣrəm i-ad-dd-nəžănš tijəlwen n-sănatăt timaḍ n-ărriyal n-aẓrəf i-ad-nəšăkš tamətte-ta-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Innʼ-asăn: «Ǝssənăt-dd maniket tijəlwen lăm.» Ǝlmădăn-dd, ənnăn-as: «Səmmosăt tijəlwen d-əssin imănan.» ");
INSERT INTO taq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Omăr-asăn ḍarăt-a-wen s-ad-əbḍəwăn ăddinăt, săqqaymən-tăn făll-teyəšše ta dalet. ");
INSERT INTO taq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tăqqima tamətte s-temeḍe-temeḍe n-ăwadəm, səmmosăt-səmmosăt timərwen n-ăwadəm. ");
INSERT INTO taq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iḍkăl Ɣisa tijəlwen ti n-səmmosăt d-imănan wi n-əssin, ăjoẓăy išənnawăn, ămmoy i-Măssinăɣ; ăfrăsfărăs tijəlwen, ănkăḍnăkăḍ imănan wi n-əssin təzzar, ikfă a-wen-dăɣ iket-net i-inəṭṭulab-net i-ad-t-uẓanăn jer-ăddinăt iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ǝkšăn iket-dăɣ-năsăn har əyyəwănăn. ");
INSERT INTO taq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ăsdăwăn-dd inəṭṭulab a-wa dd-əjlăšăn, osăn-t iḍnăy măraw deketăn d-əssin n-tijəlwen d-imănan. ");
INSERT INTO taq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Səmmos afḍăn n-ăhaləs a əkšănen ašăl-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ăsrarăd Ɣisa ḍarăt-a-wen inəṭṭulab-net s-ujəš n-turăft ta n-aman, izarăn-as s-efăyy n-ejănš wa iyyăḍăn, ebre n-taɣrəmt ta n-Băṭsăyda, ad-isagla ənta tamətte. ");
INSERT INTO taq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Făl-t tamətte ɣas, iwwăn taḍaɣt tiyyăt, ad-itəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A-s ijă ehăḍ, təha turăft n-aman ta hăn inəṭṭulab ammas n-ejănš, a-s ija a-wen Ɣisa ənta, ihʼ asălim n-aman. ");
INSERT INTO taq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ojjʼ-en ăsimăɣatăr-tăn aḍu šămad igla ehăḍ, ikkʼ-en-dd irjaš făll-aman har dăroɣ tăn-okăy. ");
INSERT INTO taq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ǝnhăyăn-t ikkʼ-en-dd irjaš făll-aman ɣas, ăɣelăn ămăttănkul iyyăn, ad-naḍḍăwăn iɣăran. ");
INSERT INTO taq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hannăyăn-t măšan, indăr-asăn a t-əzzəyăn a-wa-dăɣ hasăn-təja tarəmmeɣt. Ăssewăl-asăn šik, innʼ-asăn: «Ǝfləsăt-ahi, năkk a-wa, wăr tărmeɣăm.» ");
INSERT INTO taq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ijjăš-dd fălla-săn turăft n-aman ɣas, ibdăd aḍu. Ămoos-asăn a-wa ijăn tăkunt-i-dăɣ măqqărăt. ");
INSERT INTO taq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Indăr-asăn ujreh n-asjət wa ija i-tijəlwen făl tăɣart-i-dăɣ jăn ulhawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ijlăy Ɣisa d-inəṭṭulab-net ejănš, ăsjănăn dăɣ-ăkall wa n-Žănnăṣarăt. ");
INSERT INTO taq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Diha-dăɣ dd-əzjărăn dăɣ-turăft n-aman, ad-əzzăyăn ăddinăt Ɣisa, ");
INSERT INTO taq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ad-tišələn dăɣ-ăkall iket-net, tazăwen-dd săr-s imarhinăn făll-tišija s-edăgg wa s-əslăn ihʼ-e i-ad-tăn-izuzəy. ");
INSERT INTO taq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Edăgg osa-dăɣ, jer-iɣărman, tidbi, wăla ăssukăn, ad-dd-awəyăn ăddinăt imarhinăn-năsăn, tattărăn ad-ăḍəsăn kud-dăɣ afăr n-erăswăy-net ed, ere t-iḍăsăn-dăɣ, ad-izzəy. ");
INSERT INTO taq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ǝžžəmmăɣăn-dd kăl-faris d-hărăt dăɣ-ălɣulam n-Ăṭṭăwrăt dd-falnen Yărussălam s-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ǝjrăhăn-in dăɣ-a-wen-dăɣ a-s tattăn iyyăḍ dăɣ-inəṭṭulab-net, wăr-ăsserădăn ifassăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Iqqăn a-wen iɣăfawăn-năsăn făl-a-s kăl-faris d-kăl-Ălyăhud iket-năsăn, ămoosăn ăddinăt əlkamnen i-ălɣadatăn wi hasăn-dd-oyyăn imărawăn-năsăn: wăr hasăn-t-təlla tetăte ar s-ad-ăsserădăn ifassăn-năsăn har taɣmărt təzzar. ");
INSERT INTO taq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Afăl əkkăn ăssuk har t-dd-fălăn, wăr hasăn-t-təlla tetăte ar s-ad-ăsserădăn telămăkt-năsăn iket-net. Lan daɣ ălɣadatăn ăjjootnen s-əlkamăn săl wi-dăɣ: ašəšdaj n-ikassăn d-iɣsas d-iɣerăn d-isəftaɣ. ");
INSERT INTO taq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ǝssəstănăn kăl-faris d-ălɣulam n-Ăṭṭăwrăt Ɣisa, ənnăn-as: «Mafăl inəṭṭulab wi-năk, wăr-əlkemăn i-agna wa hanăɣ-dd-oyyăn imărawăn-nănăɣ? Tattăn wăr-ăsserădăn ifassăn-năsăn.» ");
INSERT INTO taq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Innʼ-asăn Ɣisa: «Ălmunafeɣăn! Tidət-dăɣ a-wa fălla-wăn innă ănnăbi Saya, a-s innă, inna Măssinăɣ: ‹Tamətte-ta-hi, iḍlay-net ɣas a-s hi-tăssiimɣăr ulh-net, ujəj-ahi; ");
INSERT INTO taq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","semɣar wa hi-jăn ăddinăt, mălayăɣna ed a-wa saɣren dăgg-adəm făll-i, wăr-ămoos ɣas ar fărəḍăn dd-ăɣtasăn i-iman-năsăn.› ");
INSERT INTO taq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ǝmmək-wen-dăɣ a-s, kăwăneḍ-dăɣ, təšlăyăm i-alămăr wa n-Măssinăɣ, təṭṭăfăm ălɣadăt n-dăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Innʼ-asăn daɣ: «Kăwăneḍ, jărăm-in alămăr wa n-Măssinăɣ, jăm agna-năwăn dăɣ-edăgg-net. ");
INSERT INTO taq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wădden, innă ănnăbi Mosa: ‹Səmɣăr ti-k d-ma-k›, innă daɣ: ‹Ere ăbodărăn ti-s meɣ ma-s, ămmătet.› ");
INSERT INTO taq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Təssanăm s-a-wen-dăɣ iket-net măšan kăwăneḍ-da-dăɣ, iyyăḍ dăɣ-wăn, saɣren ăddinăt a-s, ăddoobăt ăwadəm ad-ănn i-abba-net d-anna-net: ‹A-wa s-ăsidărhăn ad-kăwăn-ədhəlăɣ săr-s, jeɣ-t takute i-Măssinăɣ›, ");
INSERT INTO taq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ija ɣur-wăn a-s ere innăn a-wen-dăɣ i-imărawăn-net, ad-ăbas t-iwar ălxaqq-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A-wa săɣrem d-a-ăjjeen dăr-s ănifăqqăn a-s hin-tăsbăṭṭălăm a-wa inna Măssinăɣ, jăm a-wa hawăn-inna agna-năwăn dăɣ-edăgg-net.» ");
INSERT INTO taq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iɣră-dd Ɣisa tamətte s-iman-net daɣ, innʼ-as: «Săjdăt-ahi iket-dăɣ-năwăn, təjrăhăm a-wa hawăn-janneɣ: ");
INSERT INTO taq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wăr t-illa a itajjăšăn emm n-ăgg-adəm ăddooben asəmmăḍəs-net, a-wa dd-itəffalăn ammas n-ulh-net ijănna s-emm-net a t-isamăḍasăn dat-Măssinăɣ.  ");
INSERT INTO taq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ere dăɣ-wăn ilăn timəẓẓujen s-islă-dăɣ, isăjdet.» ");
INSERT INTO taq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ifăl Ɣisa tamətte ɣas, iqqăl ehăn, əssəstănăn-t inəṭṭulab-net dihen d-ălmăɣna n-tangalt ta ija. ");
INSERT INTO taq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Innʼ-asăn: «Adiš kăwăneḍ har ămăra-dăɣ, wăr təjrehăm a-s ăsink, esăk? Ajăn wăr hənnəyăm a-s, wăr t-illa a isuk ăwadəm emm-net ăddooben a t-isəmmăḍəs ");
INSERT INTO taq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","făl-a-s, a-wa dd-itəffalăn ajăma, wăr-itəkk ulh-net, tăsa-net a itakk, izjăr ḍarăt-a-wen, ăjʼ-e-hin dăɣ-tăkoyt.» Ǝmmək-wen-dăɣ a-s isaxlal Ɣisa imənsiwăn iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Innʼ-asăn daɣ: «A-wa dd-itəffalăn ulh n-ăgg-adəm, a t-isamăḍasăn dat-Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","făl-a-s ammas n-ulh n-ăgg-adəm a dd-itəffal erk ənniyăt wa n-abjənjən, iba n-tăkrakiḍt, tikra, iji n-iman, ");
INSERT INTO taq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","əzzəna, tăkkărdădt, tăllăbăst, amsud, asəmmăḍəs n-iman, erk derhan, asəkkufăr, əkkəbru, taxxalen. ");
INSERT INTO taq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ǝntăneḍ-den-dăɣ hărătăn wi samăḍasnen ăgg-adəm, ed ammas n-ulh-net a dd-təffalăn.» ");
INSERT INTO taq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ifăl Ɣisa dihen, ikkă teje ta n-Tir. Iwwăḍ-in ɣas, ijjăš ehăn iyyăn, făl-a-s wăr irha ad-fălla-s əlmədăn ăddinăt măšan, hakd-a-wen-dăɣ, wăr-iṣter ass-net. ");
INSERT INTO taq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Šik-dăɣ a-s t-təslă tamăḍt tiyyăt s-ihʼ alšin elle-s, təkkʼ-e-hi-dd, tărkăɣ data-s. ");
INSERT INTO taq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tamăḍt-en, wăr tăt-len kăl-Ălyăhud, ti n-teje ta n-Finisya hăt ăkall wa n-Surya. Tosʼ-e-hi-dd ɣas, təttăr dăɣ-s ad-ikkəs alšin dăɣ-elle-s măšan, ");
INSERT INTO taq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","innʼ-as Ɣisa: «Ăyy aratăn ad-ăyyăwănăn təzzar ed, wăr-ănhăjja ad-dd-ikkəs ăwadəm amənsi daw-săn, ijăr-t-in i-iyyăḍan.» ");
INSERT INTO taq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tăwwežăb-as tamăḍt, tənnʼ-as: «Ălɣalim, tidət măšan a-wen wăr hin-ikkes a-s iyyăḍan, ăddooben ad-tattăn a-wa dd-sitrəkkin aratăn.» ");
INSERT INTO taq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Innʼ-as Ɣisa: «Ǝgləw, dăɣ-təssəba n-a-wa-dăɣ tənned, a făl, elle-m, izjăr-tăt alšin.» ");
INSERT INTO taq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tăqqăl ehăn-net, togăẓ-in elle-s, tənsa făll-tešejit, izjar-tăt alšin. ");
INSERT INTO taq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ifăl Ɣisa teje ta n-Tir, ikka ta n-Săyda, ihăl ebre n-ejănš wa n-Galila dăɣ-a-s ijlay teje ta n-măraw iɣărman. ");
INSERT INTO taq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ǝwwăyăn-dd săr-s ăddinăt ăhaləs măẓẓəjăn s-ikras iləs-net ad-dăɣ-s tattărăn ad-fălla-s isăns ifassăn-net. ");
INSERT INTO taq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Irmăs-t-dd Ɣisa s-edes təzzar, ijʼ assəkăḍ-net dăɣ-timəẓẓujen-net, ijă daɣ s-assəkăḍ-net emătăm-net făll-iləs n-ăhaləs, ");
INSERT INTO taq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ăjoẓăy išənnawăn, ăhnăffăt təzzar, innʼ-as: «Efata», a-wen ălmăɣna-net: «Marr.» ");
INSERT INTO taq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ămerănăt timəẓẓujen-net hakd iləs-net, ad-itamăjrad. ");
INSERT INTO taq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ăsmătăr Ɣisa ăddinăt iket-năsăn d-ad-wăr jen isălan n-a-wen-dăɣ i-ăwadəm wălʼ iyyăn măšan, a ikkʼ isamătar-tăn, sawaḍăn əntăneḍ dăɣ-tənna n-a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ămoos Ɣisa i-ăddinăt tăkunt-i-dăɣ măqqărăt, əqqălăn-dd ɣas jannen: «A-wa, a-wa ităjj iket-net ifran, isasla imẓaj, isamăjrad daɣ wi s-əkrăsăn ilsawăn-năsăn.» ");
INSERT INTO taq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tolăs-dd tamətte daɣ ažəmmăɣ făll-Ɣisa dăɣ-išilan-win-dăɣ. Inhăy a-s wăr t-illa a təṭṭaf təkšă ɣas, iɣră-dd inəṭṭulab-net, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Naqqʼ-ahi tăhanint n-tamətte-i-dăɣ; a ilan kăraḍ išilan, təlkam-ahi, ăbas əṭṭafăn a əkšăn; ");
INSERT INTO taq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","afăl tăn-əssəglăɣ s-ihănan-năsăn, ălluẓăn s-əmmək-wa-dăɣ, ad-hasăn-indăr ad-tăn-in-awəḍăn făl iba n-ăṣṣahăt ed, han-tăn-i dd-falnen ijəj.» ");
INSERT INTO taq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ǝnnăn-as inəṭṭulab-net: «Mi ăddooben dăɣ-tenere-ta-dăɣ ad-išăkš tamətte jat əjut-wa-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Issəstăn-tăn Ɣisa, innʼ-asăn: «Maniket tijəlwen təṭṭăfăm?» Ǝnnăn-as: «Ǝssayăt.» ");
INSERT INTO taq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ăsɣăyma Ɣisa tamətte iket-net, iḍkăl tijəlwen ti n-əssayăt, ămmoy i-Măssinăɣ, ăfrăsfărăs-tănăt təzzar, ikfʼ-enăt i-inəṭṭulab i-ad-tănăt-uẓanăn jer-ăddinăt; ăẓunăn-tănăt. ");
INSERT INTO taq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ǝkfăn-t a-wa lăn dăɣ-imănan, iḍkăl-t, ămmoy i-Măssinăɣ təzzar, ikfʼ-en i-inəṭṭulab-net i-ad-tăn-uẓanăn jer-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Təkša tamətte ta t-təllăt dihen-dăɣ hundăɣ har təyyəwăn. Ăsdăwăn-dd inəṭṭulab a-wa dd-əjlăšăn ăddinăt, osăn-t, iḍnay əssa deketăn. ");
INSERT INTO taq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A iwwăḍăn əkkoẓ afḍăn n-ăhaləs a ikšăn ašăl-wen-dăɣ. Təkša tamətte ɣas, issəglʼ-et Ɣisa; təglă. ");
INSERT INTO taq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ijjăš ənta d-inəṭṭulab-net turăft n-aman ăssaɣăt-wen-dăɣ, əkkăn tidbi ti hănen teje ta n-Dălmănuta. ");
INSERT INTO taq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Osăn-dd hărăt dăɣ-kăl-farisƔisa, ămɣănnănăn dăr-s, tiirəmən-t, jannen-as: «Ăj data-năɣ iji n-Măssinăɣ hanăɣ-issətbătăn a-s tidət-dăɣ a-s Măssinăɣ a kăy-dd-ăšmašălăn.» ");
INSERT INTO taq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ăhnăffăt dăɣ-iman-net, innă: «Mafăl tammăɣ əzzurəyăt-ta-dăɣ i-iji n-Măssinăɣ? Ăsidătteɣ-awăn a-s wăr-ilkem ad-ija iji n-Măssinăɣ wălʼ iyyăn data-wăn.» ");
INSERT INTO taq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ifăl-tăn ḍarăt-a-wen, olăs ujəš n-turăft n-aman, ijlăy ejănš s-efăyy wa iyyăḍăn. ");
INSERT INTO taq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dăɣ-tekle-ten-dăɣ, əttəwăn-in inəṭṭulab ad-awəyăn ăzzad, wăr-əwweyăn dăɣ-turăft n-aman ar tiyyăt tajəlla. ");
INSERT INTO taq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ăsmătăr-tăn Ɣisa, innʼ-asăn: «He kăwăneḍ! Agəẓăt iman-năwăn dăɣ-tăẓẓa ta n-kăl-faris d-Harudəs.» ");
INSERT INTO taq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ǝslăn inəṭṭulab i-a-wen ɣas, ad-tinmənnin jer-iman-năsăn: «A-wa, a-wa-dăɣ s-wăr nəwwey tijəlwen a făl hanăɣ-itajj măjrăd-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ilmăd Ɣisa ɣur-iman-net a-wa tinmənnin, innʼ-asăn: «Mafăl əkkan inəzjam-năwăn a-wa s-wăr tăwweyăm tijəlwen? Ajăn ulhawăn-năwăn jan tăɣart-ta-dăɣ făl ăbas hannăyăm, ăbas jarrăhăm? ");
INSERT INTO taq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma jănăt tiṭṭawen-năwăn tənhəyăm săr-snăt, ma jănăt timəẓẓujen-năwăn, təsləm săr-snăt? ");
INSERT INTO taq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ajăn təttəwăm-in tijəlwen ti n-səmmosăt ăẓunăɣ i-səmmos afḍăn n-ăhaləs, maniket deketăn dd-tăsdăwăm dăɣ-a-wa dd-təjlăš tamətte?» Ǝnnăn-as: «Măraw d-əssin.» ");
INSERT INTO taq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Innʼ-asăn: «Ălwăqq wa d-ăẓunăɣ əssayăt tijəlwen i-əkkoẓ afḍăn n-ăwadəm, maniket deketăn əḍnaynen dd-təjlăš tamətte?» Ǝnnăn-as: «Ǝssa.» ");
INSERT INTO taq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Innʼ-asăn: «Adiš, har ămăra-dăɣ, wăr t-illa a təjrahăm?» ");
INSERT INTO taq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iwwăḍ-in Ɣisa d-inəṭṭulab-net taɣrəmt ta n-Băṭsăyda ɣas, ittəlwăy-dd săr-s emədderɣəl iyyăn, əttărăn dăɣ-s ad-t-iḍəs, izzəy. ");
INSERT INTO taq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Irmăs-t Ɣisa s-ăfuss, ilwăy-t hundăɣ har dăr-s izjăr tadăbayt təzzar, ăswăr tisutaf-net tiṭṭawen n-emədderɣəl, ăswăr-t ḍarăt-a-wen ifassăn-net, innʼ-as: «Ak, hannăyăd hărăt meɣ?» ");
INSERT INTO taq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ăsfănăwnăw emədderɣəl, innă: «Hannăyăɣ ăddinăt măšan, olăhăn-ahi d-ihəškan ărjašnen.» ");
INSERT INTO taq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Olăs Ɣisa asəwăr n-ifassăn-net tiṭṭawen-net ɣas, ăsnăflăy ahănay, izzăy, oɣăd ahănay-net i-hărăt iket-net. ");
INSERT INTO taq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Issəglʼ-e Ɣisa, innʼ-as: «Wăr resăd wăla tadăbayt, aɣəd iman-năk ɣas s-ehăn-năk.» ");
INSERT INTO taq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Izjăr Ɣisa ḍarăt-a-wen ənta d-inəṭṭulab-net, ikka dăr-săn tidbi-ti hănen attayăn n-aɣrəm wa s-itawănna Qăyṣăra wa n-Fəlibb. Ǝglan hărwa a-s tăn-issəstăn Ɣisa, innʼ-asăn: «Ma jannen ăddinăt dăɣ-isălan-in? Ma jannen mi ămoosăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ăwwežăbăn-as, ənnăn-as: «Iyyăḍ jannen: kăyy a-s Exya wa n-Enəsselmăɣ; iyyăḍ jannen: kăyy a-s ănnăbi Ɣəli; iyyăḍ făw a jannen: kăyy iyyăn dăɣ-ănnăbităn dd-olasăn uɣəl.» ");
INSERT INTO taq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Issəstăn-tăn daɣ, innʼ-asăn: «Kăwăneḍ-š, ma tənnăm, mi ămoosăɣ?» Ăwwežăb-as Bəṭrus, innʼ-as: «Kăyy a-s Ălmasex.» ");
INSERT INTO taq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ăsmăhăḍ dăɣ-săn Ɣisa ḍarăt-a-wen, d-ad-wăr jen isălan-win-dăɣ i-ăwadəm wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɣur-dihen-dăɣ ad-issəntă Ɣisa asəɣăr n-inəṭṭulab-net n-a-s Ăgg-ăgg-adəm, ilzam-t ad-inhəy tersəmmawen ăjjootnen, ənkărăn-t inušămăn wi n-Iṣrayil d-imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt; ad-əjən iman-net măšan, kăraḍ išilan ḍarăt tamăttant-net, ad-dd-aləs tanăkra jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ijʼ-asăn Ɣisa măjrăd-wen-dăɣ s-əmmək ilan ujreh; ikkăs-t-dd Bəṭrus s-takše, ăklăwlăw fălla-s. ");
INSERT INTO taq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Innăḍ-dd Ɣisa s-inəṭṭulab-net, iɣtăl Bəṭrus, innʼ-as: «Šənkəš făll-i, Iblis-wa! Kăyy, inəzjam-năk, i n-dăgg-adəm, wădden i n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iɣră-dd Ɣisa ḍarăt-a-wen tamətte d-inəṭṭulab-net s-iman-net, innʼ-asăn: «Ere irhăn alkum-hahi-dăɣ, adiš, iksənet iman-net, ăjet făll-tamăttant šund ta n-tajəttewt təzzar, ilkəmet-ahi. ");
INSERT INTO taq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ere wa wărăn itəttăr ar əmmək s-ogăẓ iman-net, dăɣ-ăddunya-ta-dăɣ, ad-ifut dăɣ-ălžănnăt; măšan, wa irḍăn ăfota dăɣ-iman-net, dăɣ-ăddunya-ta-dăɣ, dăɣ-ăddimmăt-in, d-ăddimmăt n-Ălənžil, ad-iɣləs. ");
INSERT INTO taq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma s-infa ăgg-adəm ad-irbăx ăddunya iket-dăɣ-net, a-s ija a-wen, ăfota dăɣ-ălaxărăt? ");
INSERT INTO taq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ajăn ma t-illan s-ăddoobăt ăwadəm ad-t-ăkf i-ad-săr-s iɣləs iman-net dăɣ-temse? ");
INSERT INTO taq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ere hi-ăkrakăḍăn, năkk d-măjrăd-in, dat-əzzurəyăt-ta-dăɣ n-temăznit tănmăšrăyăt i-Măssinăɣ, ad-t-əkrukəḍăɣ năkk-dăɣ-i n-Ăgg-ăgg-adəm, ašăl wa d-mad-dd-iqqəl dăɣ-ălxurmăt n-Abba-nin, ăddew d-ănjălosăn wi n-iməššeddəjăn.» ");
INSERT INTO taq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Ăsidătteɣ-awăn a-s han-kăwăn ăddinăt əbdadnen diha-dăɣ wăr-e iba wăr-ənheyăn Təmmənəya n-Măssinăɣ tosa-dd s-ăṣṣahăt.» ");
INSERT INTO taq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Săḍis išilan ḍarăt a-s inna a-wen-dăɣ, iɣră-dd Ɣisa Bəṭrus d-Yaqub d-Exya s-edes, ikka dăr-săn taḍaɣt tiyyăt təḍkalăt təzzar, ijjăš dihen ini ăynayăn data-săn; ");
INSERT INTO taq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ămlăwlăwăn-dd imălsan-net, jăn-dd təməlle s-kăla wăr-tătwănhăy făll-ărori n-ăkall. ");
INSERT INTO taq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ănfalăl-asăn-dd dihen ănnăbi Ɣəli d-ănnăbi Mosa dd-falnen išənnawăn, ad-tamăjradăn d-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iggăd-dd Bəṭrus, innă i-Ɣisa: «Ălɣalim, ufa ad-nəzzăɣ ɣas diha-dăɣ, ad-nəkrəs kăraḍ ihəktan: wa-năk, wa n-Mosa d-wa n-Ɣəli.» ");
INSERT INTO taq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wăr-issen a ijănna a-wa-dăɣ has-ja tarəmmeɣt ənta d-imidiwăn-net. ");
INSERT INTO taq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Təlsʼ-en-dd tele n-tejărăkt tiyyăt ălwăqq-wen-dăɣ, ifăl-dd emăsli išənnawăn, innăn: «A-wa Rure-ɣ wa əkneeɣ tărha, săjdăt-as!» ");
INSERT INTO taq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A-s dd-olăsăn inəṭṭulab aḍkul n-asăwaḍ-năsăn, šanăšlamăn siha d-siha, wăr t-illa ere hannăyăn edes-hasăn kunta wădden Ɣisa ɣas. ");
INSERT INTO taq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ălwăqq wa dd-titrurun taḍaɣt, ăsmăhăḍ dăɣ-săn Ɣisa i-ad-wăr jen isălan n-a-wa ənhăyăn i-ăwadəm wălʼ iyyăn hundăɣ har ašăl wa dd-mad-inkăr Ăgg-ăgg-adəm jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ăsjădăn i-a-wa hasăn-inna, ad-tinməsəstinăn d-ălmăɣna n-tanăkra jer-inəmmuttan ed, iqqan a-wen iɣăfawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ǝssəstănăn-t, ənnăn-as: «Mafăl jannen ălɣulam n-Ăṭṭăwrăt a-s ănnăbi Ɣəli a ilan s-a dd-ass təzzar, išrəy-t-dd Ălmasex?» ");
INSERT INTO taq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Innʼ-asăn: «Tidət, ănnăbi Ɣəli a ilan s-a dd-ass isəssiɣəd hărăt iket-net; măšan, mafăl iktab a-s Ăgg-ăgg-adəm, ilzam-t ad-inhəy tersəmmawen ăjjootnen, səffăṭṭən dăɣ-s dăgg-adəm? ");
INSERT INTO taq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ăssiilmădăɣ-kăwăn a-s ănnăbi Ɣəli, ăru dd-osa, măšan ăkkuddălăn-t dăgg-adəm, jăn-as a-wa s-ărhăn ed, a-wen-dăɣ a ənnăn əlkəttabăn dăɣ-isălan-net.» ");
INSERT INTO taq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ălwăqq wa dd-iqqăl Ɣisa d-inəṭṭulab-net wi n-kăraḍ, ogăẓăn-dd inəṭṭulab-wi iyyăḍnen, ămmiizăɣăn d-ălɣulam n-Ăṭṭăwrăt, tăɣlay-tăn tamətte. ");
INSERT INTO taq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tojja tamətte Ɣisa ɣas, tofʼ-et tăkunt, tošăl săr-s, ad-has-tajjăn isofan. ");
INSERT INTO taq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Innʼ-asăn: «Ma tămmizăɣăm?» ");
INSERT INTO taq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Innʼ-as ăhaləs iyyăn dăɣ-tamətte: «Ălɣalim, əlwăyăɣ-dd săr-k rure-ɣ ihʼ alšin ikrasăn iləs-net; ");
INSERT INTO taq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","edăgg dăɣ-t irmăs-dăɣ, ad-t-ăjjăḍlăt s-ăkall, ad-isakăffaw, iẓiməkărkiẓ isenăn, isaqăqqad; əttărăɣ dăɣ-inəṭṭulab-năk ad-dăɣ-s t-əkkəsăn măšan, indăr-asăn.» ");
INSERT INTO taq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ăwwežăb-asăn, innʼ-asăn: «Ya əzzurəyăt-i-dăɣ wărăt tomen, hundăɣ har əmme əlleɣ jere-wăn, əṣbarăɣ-kăwăn? Awəyăt-ahi-dd alyaḍ.» Ăwwăyăn-as t-dd. ");
INSERT INTO taq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Diha-dăɣ d-inhăy alšin Ɣisa, ad-ijjăḍlăt alyaḍ s-ăkall, ad-itišbărḍil, isakăffaw. ");
INSERT INTO taq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Issəstăn Ɣisa ti-s, innʼ-as: «Ǝmme t-irmăs a-wa?» Innʼ-as ăhaləs: «Hărwa măḍrəy, ");
INSERT INTO taq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","dehiyyăn făw, itəjjar-t alšin dăɣ-efew meɣ dăɣ-aman i-ad-ămmăt. Ɣas, kunta tăddoobed hărăt dăɣ-a-wa-dăɣ, aḍən-anăɣ tăhanint, agəẓ-anăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Innʼ-as Ɣisa: «Tənned: ‹kunta tăddoobed!› Ǝlməd a-s wăr t-illa a-s wădden răqqiis i-amumən.» ");
INSERT INTO taq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iḍkăl ti-s n-alyaḍ emăsli-net ălwăqq-wen-dăɣ, innă: «Omanăɣ, agəẓ-ahi dăɣ-iba n-immun.» ");
INSERT INTO taq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Inhăy Ɣisa tamətte tošal-dd săr-s ɣas, ăsmăhăḍ dăɣ-alšin, innʼ-as: «Alšin wa ikrăsăn iləs n-alyaḍ-i-dăɣ, ăẓimăẓẓăj-t; omarăɣ-kăy s-ad-t-təzjărăd, wăr-ilăkkămet ad-t-dd-tăqqalăd.» ");
INSERT INTO taq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ăɣwăttăt alšin, ibbəkbăk alyaḍ s-ăṣṣahăt təzzar, izjăr-t; ăktăyyăt alyaḍ har ăɣelăn ăddinăt ăba-t ");
INSERT INTO taq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","măšan, irmăs-t-dd Ɣisa s-ăfuss, issənkăr-t-dd, ibdăd făll-iman-net. ");
INSERT INTO taq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ǝqqălăn ehăn ɣas, əssəstănăn inəṭṭulab Ɣisa s-edes, ənnăn-as: «Alšin-wənnin-hi, mafăl hanăɣ-indăr ad-t-nəkkəs dăɣ-alyaḍ?» ");
INSERT INTO taq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Innʼ-asăn: «Alšin šund-wa, wăr t-illʼ əmmək s-izjăr ar s-tamădilt n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Fălăn dihen ɣas, ăllilăn teje ta n-Galila măšan, wăr-irha Ɣisa ad-săr-s ilməd ăwadəm ");
INSERT INTO taq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ed isaɣra inəṭṭulab-net, ijannʼ-asăn: «Ăgg-ăgg-adəm, ad-ăttărmăs, ijjəš ifassăn n-dăgg-adəm, əjən iman-net măšan, kăraḍ išilan ḍarăt tamăttant-net, ad-dd-inkăr jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wăr-əjrehăn măjrăd-wen-dăɣ, hʼ-en daɣ tasăja n-ad t-səstənăn d-ălmăɣna-net. ");
INSERT INTO taq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ǝwwăḍăn-in Qăfărnaxum, əjjăšăn ehăn wa əkkăn ɣas, issəstăn Ɣisa inəṭṭulab-net, innʼ-asăn: «Ma tămmizăɣăm dăɣ-tabarăt?» ");
INSERT INTO taq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wăr t-illa a has-ənnan. Ijʼ-asăn asəstan-wen-dăɣ, făl-a-s, dăɣ-tekle-năsăn, ămmiizăɣăn jer-iman-năsăn i-ad-əlmədăn əndek dăɣ-săn wa ojărăn. ");
INSERT INTO taq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ăqqima Ɣisa ɣas, iɣră-dd inəṭṭulab-net wi n-măraw d-əssin s-iman-net, innʼ-asăn: «Wa dăɣ-wăn irhăn tăzert, iməlet daw-imidiwăn-net, umaset-asăn akli.» ");
INSERT INTO taq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Irmăs ḍarăt-a-wen ara iyyăn, ijʼ-e jere-săn təzzar, iḍkăl-t dăɣ-ifassăn-net, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ere ăsbălălăn ara šund wa-dăɣ, dăɣ-təssəba-nin, năkk a ăsbălăl; ere wa hi-ăsbălălăn, wădden năkk a ăsbălăl, Wa hi-dd-ăšmašălăn a ăsbălăl.» ");
INSERT INTO taq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Innʼ-as ănăṭṭalib wa s-isəm-net Exya: «Ălɣalim, nənhay ăhaləs itakkăsăn alšinăn dăɣ-ăddinăt s-tărna n-isəm-năk, nənnʼ-as, wăr-itiləset, ed wăr dăr-năɣ ăddew.» ");
INSERT INTO taq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Innʼ-asăn Ɣisa: «Wăr has-t-təgdelăm, făl-a-s, wăr t-illa ere madăn-ăj iji n-Măssinăɣ s-tărna n-isəm-in aləs daɣ, a ənḍărrăn ḍarăt-a-wen, tiẓmit-in. ");
INSERT INTO taq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ere wărăn hanăɣ-iknes, a-di, amidi-nănăɣ. ");
INSERT INTO taq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ere kăwăn-issəswăn kara n-aman, dăɣ-təssəba n-a-wa s-Ălmasex a kăwăn-ilăn, ăsidătteɣ-awăn a-s ilkam, ad-ijrəw, ălhăk n-emărked wa ija.» ");
INSERT INTO taq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Aratăn wi săr-i omănnen, ere ămoosăn əssəbab n-tanməšrayt i-wăla iyyăn dăɣ-săn-dăɣ, ăwadəm-en, iššăm-as-in, ad-tətwăqqən tăhunt ta măqqărăt s-itəẓẓad ălkăma dăɣ-err-net, itwəjăr-in dăɣ-ider n-ejărew wa səmmăn hărwa wăr-ofa abăkkaḍ-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kăyy, kunta ăfuss-năk a ăbokăn ad-hak-ăssăbăb s-abăkkaḍ, itiḍărrut-kăy, ənkăḍ-t-in hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ ed ufʼ-ak, ad-jeed ăfuss, təjjəšăd ălžănnăt, uhən, ad-leed əssin ifassăn, tətwəjărăd-in dăɣ-efew wa n-žohănnăma wărăn itəməkit  ");
INSERT INTO taq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","d-tiwəkkawen ti wăren təməttit s-hărkuk əfradnăt dăɣ-tiɣəswen n-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kunta daɣ aḍăr-năk a ăbokăn ad-kăy-isidəw dăɣ-abăkkaḍ, itiḍărrut-kăy, ənkăḍ-t-in hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ, ed ufʼ-ak, ad-təjjəšăd ălžănnăt, jeed aḍăr, uhən ad-leed əssin iḍarăn, tətwəjărăd-in dăɣ-efew wa n-žohănnăma-i hănăt  ");
INSERT INTO taq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","tiwəkkawen ti wăren təməttit s-hărkuk əfradnăt dăɣ-tiɣəswen n-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kunta daɣ tiṭṭ-năk a ăbokăn ad-kăy-siḍəw dăɣ-abăkkaḍ, tiḍărrut-kăy, kukkərət-tăt-dd hărwa wăr tămešălăd abăkkaḍ-wen-dăɣ, ed ufʼ-ak, ad-təjjəšăd Təmmənəya n-Măssinăɣ jeed tiṭṭ, uhən ad-leed sănatăt tiṭṭawen, tətwəjărăd-in dăɣ-efew wa n-žohănnăma. ");
INSERT INTO taq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dihen, tiwəkkawen ti əfrădnen dăɣ-tiɣəswen n-ăddinăt, əddarnăt hărkuk. ");
INSERT INTO taq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ere ămešălăn abăkkaḍ, ad-ijjəš efew s-əmmək-wa-dăɣ s-tajjăš tesəmt imənsiwăn i-ad-tăn-təjjəš temḍe. ");
INSERT INTO taq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tesəmt, hărăt olaɣăn măšan, afăl tăt-təjmăḍ temḍe, ma tăt-e-isəsməmăn? Tumaset tămudre-năwăn a ha tesəmt, tənhirəjăm dăɣ-ălɣafyăt.» ");
INSERT INTO taq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ifăl Ɣisa dihen, ikkă teje ta n-Ălyăhudəyăt d-illa-hin i-ejănš wa n-Ɣurdəni, təlkăḍ-as-dd tamətte tăjjeet, ad-isaɣra daɣ ăddinăt, s-əmmək wa s-izzăy ad-t-ăj. ");
INSERT INTO taq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Osăn-t-dd hărăt dăɣ-kăl-faris, orămăn-t s-asəstan iyyăn i-ad-ănn a wărăn itətwənn, ənnăn-as: «Dăɣ-a-wa innă alămăr-nănăɣ, ak ajăn xălal i-ăhaləs ad-izəmməzzəy hănne-s?» ");
INSERT INTO taq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Innʼ-asăn Ɣisa: «Ma dăr-kăwăn-ăsmătăr ănnăbi Mosa.» ");
INSERT INTO taq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ǝnnăn-as: «Ănnăbi Mosa, ijraw i-ăhaləs ad-ăkf tăkarḍe n-aməzzi i-hănne-s təzzar, izəmməzzəy-tăt.» ");
INSERT INTO taq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Innʼ-asăn Ɣisa: «Alămăr wa hawăn-iktăb ănnăbi Mosa, iktăb-awăn-t dăɣ-təssəba n-tăɣart-i jăn ulhawăn-năwăn, ");
INSERT INTO taq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ənnăr wădden a-wen: ‹S-tizarăt a-s dd-ixlăk Ămaxlak ăddunya, ăhaləs d-tamăḍt a dd-ixlăk, ");
INSERT INTO taq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","təssəba n-a-wen-dăɣ a făl mad-ifəl ăhaləs ti-s d-ma-s, irtəy d-hănne-s, ");
INSERT INTO taq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","umasăn făll-əssin-essăn tiyyăt taɣəssa, ad-ăbas ămoosăn əssin ăddinăt, ămoosăn tiyyăt taɣəssa.› ");
INSERT INTO taq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ɣas, a-wa osăɣ Măssinăɣ, wăr t-ibəḍḍəwet ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iqqăl-dd Ɣisa ehăn ɣas, əssətănăn-t inəṭṭulab-net d-ălmăɣna n-a-wa innă. ");
INSERT INTO taq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Innʼ-asăn: «Ere hin-ăzmăzzăyăn hănne-s, olăs adubən n-iyyăt, izna, ");
INSERT INTO taq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","tamăḍt daɣ təbḍăt d-ăhaləs-net, tolăs adubən n-iyyăn, təlmədet a-s, təzna ənta-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ǝlwăyăn-dd ăddinăt aratăn s-Ɣisa i-ad-dăɣ-săn ăj ălbăraka, măšan, ăklăwlăwăn inəṭṭulab-net făll-imalwayăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Inhăy Ɣisa a-wa tăn-išlăn ɣas, əkmăn-t iman-net, innʼ-asăn: «Ăyyăt aratăn ad-hi-dd-əkkən, wăr tăn-in-tăwweɣăm făll-i făl-a-s, Təmmənəya n-Măssinăɣ, ăddinăt wi dăr-săn ănifăqqănen a-s tăt-ihakk. ");
INSERT INTO taq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ăsidătteɣ-awăn a-s ere wărăn iqbel Təmmənəya n-Măssinăɣ s-əmmək wa s-tăt-mad-iqbəl ara, wăr tăt-mad-ijjəš.» ");
INSERT INTO taq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ăsɣăyma ḍarăt-a-wen aratăn făll-ifaddăn-net, ăswăr-tăn ifassăn-net, ijă dăɣ-săn ălbăraka. ");
INSERT INTO taq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ălwăqq wa d-ăbok Ɣisa ad-ifəl edăgg-en, ošăl-dd săr-s ăhaləs iyyăn, irkăɣ data-s, innʼ-as: «Ălɣalim wa olăɣăn, ma s-əleɣ s-ad-t-ăjăɣ i-ad-əkkusăɣ tămudre ta tăɣlălăt?» ");
INSERT INTO taq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Innʼ-as Ɣisa: «Mafăl hi-janned wa olăɣăn? Wăr t-illa ere olaɣăn săl Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","wădden, təssanăd alămărăn-net: Wăr jed iman, wăr jed əzzəna, wăr tokerăd, wăr tăjjəyhăd s-bahu, wăr təḍlemăd ăwadəm, səmɣăr ti-k d-ma-k.» ");
INSERT INTO taq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Innʼ-as ăhaləs: «Ălɣalim, hărătăn-win-dăɣ, ăɣdalăɣ-asăn hărwa ămoosăɣ ara.» ");
INSERT INTO taq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iknʼ-e Ɣisa azəjjəzz, ijrăẓ-as, innʼ-as: «Hărăt iyyăn a hak-in-ăba: əgləw, tužžăr-in a-wa leed, təkfəd-t i-tilăqqiwen i-ad-təkrəšăd ărrəzăɣ dăɣ-ălžănnăt; dihen, əqqəl-dd, əlkəm-ahi.» ");
INSERT INTO taq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Islʼ ăhaləs i-măjrăd-wen-dăɣ ɣas, innăḍ, ənxasăn iman-net, ed ilʼ ehăre n-tikunen. ");
INSERT INTO taq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Issăɣlăy-dd Ɣisa tamətte akăyad-net, innă i-inəṭṭulab-net: «Aẓwi ija i-wi ărzăɣnen ujəš n-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Inhăy a-s iqqan a-wen iɣăfawăn n-inəṭṭulab-net ɣas, innʼ-asăn daɣ: «Ilyaḍăn-in, aẓwi ija ujəš n-Təmmənəya n-Măssinăɣ! ");
INSERT INTO taq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ojăr tărăɣse ta ija ad-ijjəš amnəs s-tiṭṭ n-ănaẓmay uhən, ad-ijjəš ere irzaɣăn Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iknă măjrăd-wen-dăɣ uɣən n-iɣăfawăn-năsăn, ad-tinmənnin: «Adiš mi madăn-iɣləs?» ");
INSERT INTO taq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Issəjrăh-tăn Ɣisa, innʼ-asăn: «A-wen, dăgg-adəm wăr t-ăsmăkkănăn măšan Măssinăɣ ənta, ăddoobăt-t ed, wăr t-illa a has-indarăn.» ");
INSERT INTO taq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Innʼ-as Bəṭrus ḍarăt-a-wen: «Ălɣalim, năkkăneḍ, wădden noyyă a-wa nəla iket-net, nəlkăm-ak.» ");
INSERT INTO taq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Innʼ-asăn Ɣisa: «Ăsidătteɣ-awăn, a-s, wăr t-illa ere madăn-ifəl ehăn-net d-ayətma-s d-šătma-s d-ma-s d-ti-s d-aratăn-net d-ihărawăn-net dăɣ-ăddimmăt-in, d-ăddimmăt n-Ălənžil ");
INSERT INTO taq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","s-wădden ad-ijrəw dăɣ-ăzzăman-wa-dăɣ s-temeḍe n-anəḍfus ihănan, ayətma, šătma, matte, aratăn d-ihărawăn ăddewnen d-ălɣizabăt, ijrəw daɣ tămudre tăɣlalăt dăɣ-tilkamăt. ");
INSERT INTO taq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A ăjjeen dăɣ-wi ăzzarnen ašăl-i-dăɣ, ad-ijjəš ajilal, a ăjjeen dăɣ-wi hănen ajilal ašăl-i-dăɣ, ad-izar.» ");
INSERT INTO taq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ijjăš Ɣisa ḍarăt-a-wen eɣăf n-tamətte, irmăs tamdujt ta n-Yărussălam, ăššiwwăšăn inəṭṭulab-net, wăr ozja ənniyăt n-wi has-əlkamnen. Ikkăs-dd inəṭṭulab wi n-măraw d-əssin s-takše, ad-hasăn-itajj isălan n-a-wa t-madăn-irməs, ");
INSERT INTO taq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","innʼ-asăn: «Ǝnhəywăt, năkkăneḍ-da-hi əkkănen Yărussălam-i-dăɣ mad-ăttărmăs Ăgg-ăgg-adəm, ijjəš ifassăn n-imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt, ad-t-siḍəwăn dăɣ-ăššăreɣa-năsăn, ăɣtəsăn-as tamăttant təzzar, əjən-t jer-ifassăn n-inəẓẓulam, ");
INSERT INTO taq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","i-ad-t-əjən tekăškăšt, sutəfən fălla-s, əjən dăɣ-s tiwit, əjən iman-net măšan, ašăl wa s-kăraḍ ḍarăt tamăttant-net, ad-dd-inkăr jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ohăẓăn-dd dăgg-Zăbdi, Yaqub d-Exya Ɣisa, ənnăn-as: «Ălɣalim, nărha ad-hanăɣ-təjəd a-wa dăɣ-k mad-nəttăr.» ");
INSERT INTO taq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Innʼ-asăn: «Ma s-tărham ad-hawăn-t-ăjăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ǝnnăn-as: «Ăkfʼ-anăɣ ad-ăqqayəm iyyăn dăɣ-năɣ daw-aɣil-năk, ăqqayəm wa iyyăḍăn daw-tăšalje-năk i-ad-numas wi săr-k orăknen dăɣ-ălxikmăt, afăl dd-tăqqălăd dăɣ-ălxurmăt-năk.» ");
INSERT INTO taq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Innʼ-asăn Ɣisa: «Kăwăneḍ, wăr təssenăm a dăr-săstanăm. Ajăn năkk, kara n-tisnant wa mad-ăswăɣ, tăddobem tesăse-net, meɣ daɣ, ajăn tăddoobem hărăt i-tamăttant ta mad-ăjăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ǝnnăn-as: «Năddoobăt-t.» Innʼ-asăn Ɣisa: «Tidət lab a-s ad-təswəm kara n-tisnant wa mad-ăswăɣ, təjəm tamăttant ta mad-ăjăɣ ");
INSERT INTO taq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","măšan, dăɣ-isălan n-taɣimit daw-aɣil-in d-tăšalje-nin, wădden năkk a ihakkăn a-wen; Măssinăɣ a t-ihakkăn i-wi s-t-itwăr.» ");
INSERT INTO taq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ǝslăn inəṭṭulab wi n-măraw i-a-wen ɣas, ijjăš-tăn ălhăm făll-Yaqub d-Exya. ");
INSERT INTO taq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iɣrʼ-en-dd Ɣisa iket-năsăn s-iman-net, innʼ-asăn: «Təssanăm a-s imănokalăn n-tiwsaten, ăxkamăn fălla-snăt s-ăṣṣahăt; kăl-əlxəkum daɣ, wăr lămmeḍăn făll-kăl-ăkall ");
INSERT INTO taq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","măšan, kăwăneḍ, wăr jem a-wen; wa dăɣ-wăn irhăn mijraw, umaset akli n-imidiwăn-net təzzar, ");
INSERT INTO taq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ere dăɣ-wăn irhăn daɣ tăzert i-imidiwăn-net, umaset akli-năsăn təzzar. ");
INSERT INTO taq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ăgg-ăgg-adəm, wăr dd-ămešăl i-ad-has-ăxdəmăn ăddinăt, ănn-ak, ămešăl-dd i-ad-ixdəm ənta iman-net, ăkf tămudre-net i-ad-isəddărfət ăddinăt ăjjootnen.» ");
INSERT INTO taq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ǝglan har hin-əwwăḍăn taɣrəmt ta n-Žărriko. Ălwăqq wa dd-izajjăr Ɣisa d-inəṭṭulab-net taɣrəmt-ten-dăɣ, təlkam-asăn tamətte tăjjeet. Zăbo wa dd-jăn, ăqqiima emədderɣəl s-isəm-net Bărtima ăgg Tima dăɣ-asălim-net, itattăr takute dăɣ-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Islă a-s Ɣisa wa n-Năṣirăt a okayăn ɣas, ăsɣărăt, innă: «Ya Ɣisa wa n-Ăgg Dawəd, aḍən-ahi tăhanint!» ");
INSERT INTO taq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ăɣtălăn-t ăddinăt i-ad-hin-isusəm măšan, ăsɣărăt s-afălla: «Ya Ăgg-Dawəd, aḍən-ahi tăhanint.» ");
INSERT INTO taq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ibdăd Ɣisa, innă: «Ǝlwəyăt-ahi-t-dd.» Ǝlwayăn-as-t-dd, jannen-as: «Ǝhəl iman-năk, iɣarrʼ-ik.» ");
INSERT INTO taq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ijăr-in emədderɣəl abărnuš-net dihen, iggăd s-iyyăt, ikka Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Osʼ-e-hi-dd ɣas, innʼ-as Ɣisa: «Ma s-tărhed ad-hak-ăjăɣ?» Innʼ-as emədderɣəl: «Ălɣalim, aləsăɣet ahănay.» ");
INSERT INTO taq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Innʼ-as Ɣisa: «Ǝgləw, ăzozăy-kăy immun-năk.» Olăs Bărtima ahănay ălwăqq-wen-dăɣ, ilkăm i-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ohăẓ-in Ɣisa d-inəṭṭulab-net Yărussălam, ihʼ ămăra taɣrəmt ta n-Bătfaži, edes i-taḍaɣt ta tăsijătăt ihəškan wi n-əzzăytun. Ɣur-dihen-dăɣ, ad-ăšmašăl əssin dăɣ-inəṭṭulab-net, ");
INSERT INTO taq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","innʼ-asăn: «Ăkkăt tadăbayt ta n-data-wăn, dăɣ-ujəš-năwăn-has, ad-təjrəwăm ăẓa ojayăn s-kăla wăr t-iney ăwadəm, arăt-t-dd, təlwəyăm-t-dd. ");
INSERT INTO taq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ere hawăn-innăn, mafăl t-tirəm, ănnăt-as: ‹Ălɣalim a dăɣ-s ilan əššăɣəl, ăssimda dăr-s ɣas, năssoɣăl-awăn-t-dd.› » ");
INSERT INTO taq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ǝglăn inəṭṭulab wi n-əssin, əjrăwăn ăẓa ojayăn dăɣ-tăšarrit dat-emm n-ehăn iyyăn, orăn-t-dd. ");
INSERT INTO taq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ǝnnăn-asăn ăddinăt t-əllanen dihen: «Mafăl tirəm ăẓa?» ");
INSERT INTO taq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ăssoɣălăn-asăn a-wa hasăn-inna Ɣisa, oyyăn-tăn, orăn-t, əglăn dăr-s. ");
INSERT INTO taq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ǝlwăyăn-dd ăẓa i-Ɣisa, əstăjăn-as isəlsa-năsăn, inăy-t. ");
INSERT INTO taq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ad-fattăɣ təššəm n-ăddinăt isəlsa-năsăn făll-tabarăt, ɣattăsăn-dd wi iyyăḍnen ileḍleḍăn dăɣ-ihəškan, fattăɣăn-tăn făll-tabarăt, ");
INSERT INTO taq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ăsiɣăren wi has-ăzzarnen hakd wi has-əlkamnen, jannen: «Ozana! Năkfet Măssinăɣ semɣar! Ija Măssinăɣ ălbăraka dăɣ-wa dd-osăn dăɣ-isəm n-Emăli, ");
INSERT INTO taq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","irxăm Măssinăɣ Təmmənəya ta s-ija ărkăwăl-net i-abba-nănăɣ Dawəd. Ozana i-Măssinăɣ wa iknăn aḍkul.» ");
INSERT INTO taq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iwwăḍ-in Ɣisa aɣrəm wa n-Yărussălam, ijjăš ehăn n-ămudd wa măqqărăn, ăzjăzzʼ-e iket-net; inhăy a-s ija fălla-s ehăḍ ənta d-inəṭṭulab wi n-măraw d-əssin ɣas, ikkă dăr-săn tadăbayt ta n-Bitanya. ");
INSERT INTO taq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ăffăw, a-s dd-izjăr tadăbayt ta n-Bitanya, ălluẓ. ");
INSERT INTO taq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ojja ahəšk s-isəm-net ašar inšarăn, ikkʼ-e-hi-dd, itassăn warăn-t aratăn măšan, wăr fălla-s ijrew ar ifărketăn ed, wăr-ija ăzzăman n-tirwe-net. ");
INSERT INTO taq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Innă i-ašar: «Wăr-issəlkăm Măssinăɣ ad-torawăd har tənkăr ăddunya.» A-s innă a-wen-dăɣ, sallăn-as inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ǝwwăḍăn-in Yărussălam, ijjăš Ɣisa ehăn n-ămudd wa măqqărăn, ad-dăɣ-s isattăɣ ăttužžar d-imăžănšan-năsăn, isibrăɣwil tisəskar n-kăl-amăhaš n-iẓărfan d-tisăqqima n-ăttužžar n-tidăberen. ");
INSERT INTO taq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wăr-oyyʼ ăwadəm wălʼ iyyăn ăwwayăn a inazzăn ăttužžăr-t dăɣ-ehăn n-ămudd wa măqqărăn. ");
INSERT INTO taq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Isaɣră ăddinăt, ijannʼ-asăn: «Ajăn wădden iktab a-s, innă Măssinăɣ: ‹Ehăn-in ad-umas ehăn n-ămudd i-tiwsaten iket-dăɣ-năsnăt,› măšan kăwăneḍ, jăm-t tajnut n-imăkrăḍăn.» ");
INSERT INTO taq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ǝslăn imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt i-a-wen ɣas, ad-tattărăn əmmək s-jăn iman-net măšan, wăr helăn a-wen, făl-a-s ămoos a-wa isăɣra, a itəḍḍasăn ulhawăn n-tamətte, ijraẓ-as iket-net. ");
INSERT INTO taq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ijʼ alməẓ ɣas, izjăr Ɣisa d-inəṭṭulab-net aɣrəm. ");
INSERT INTO taq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ăffăw, əkkăn-dd edes i-ašar-wənnin, ənhăyăn-t ăqqur har ikewăn-net. ");
INSERT INTO taq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iktă-dd Bəṭrus a-wa ijăn ɣas, innă i-Ɣisa: «Ălɣalim, ənhəy-t-ak ašar wa təlɣănăd, ăqqur-in.» ");
INSERT INTO taq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Amənăt s-Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ăsidătteɣ-awăn a-s ere dăɣ-wăn innăn i-aḍaɣ-wa-dăɣ: ‹Haan, təjrəd iman-năk dăɣ-ejănš wa səmmăn›, ija a-wen, dăɣ-a-s, wăr-ijʼ ăššăk dăɣ-ulh-net, iflas s-a-wa innă ad-ăj, ad-ijrəw ɣur-Măssinăɣ a-wa dăɣ-s ittăr. ");
INSERT INTO taq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A-wen-dăɣ a făl hawăn-janneɣ a-s, a dăɣ-dălăm Măssinăɣ-dăɣ, dăɣ-a-s təflasăm a-s ad-t-təjrəwăm, ad-hawăn-t-ăkf. ");
INSERT INTO taq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","E-d təbdădăm-dăɣ i-ad-tədləm Măssinăɣ har dd-təktăm a-s iɣšad-awăn ăwadəm hărăt, ănšăt-as-in ed, afăl jăm a-wen, ad-hawăn-in-ănš daɣ Abba-năwăn Măssinăɣ-i ihăn išənnawăn erk imojjan-năwăn.  ");
INSERT INTO taq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Afăl wăr nəššəm i-ăddinăt, wăr hawăn-in-e-ănš Abba-năwăn Măssinăɣ-i ihăn išənnawăn ibăkkaḍăn-năwăn.» ");
INSERT INTO taq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Olăs-dd Ɣisa uɣəl n-Yărussălam ənta d-inəṭṭulab-net ɣas, issăɣlăy-dd dăɣ-ehăn n-ămudd wa măqqărăn. Osăn-t-dd imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt d-inušămăn n-Iṣrayil, ");
INSERT INTO taq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ənnăn-as: «Mi kay-ikfăn turhajăt n-amišəl n-tikunen-ti-dăɣ? Mi kăy-ikfăn tărna-ta-dăɣ s-tăjjăd a-wa tăjjăd?» ");
INSERT INTO taq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Innʼ-asăn Ɣisa: «Ad-hawăn-ăjăɣ năkk-dăɣ asəstan iyyăn; wažăbăt-ahi ɣas ad-hawăn-ăllăɣeɣ năkk-dăɣ ere wa hi-ikfăn turhajăt ta s-tamašalăɣ a-wa tăjjăɣ. ");
INSERT INTO taq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Asəstan-in da: Mi dd-ăšmašălăn Exya wa n-Enəsselmăɣ i-ad-isəlmăɣ ăddinăt dăɣ-aman? Ak Măssinăɣ meɣ dăgg-adəm ɣas?» ");
INSERT INTO taq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Innʼ-asăn a-wen ɣas, əqqălăn-dd ămmiizăɣăn jer-iman-năsăn, jannen: «Afăl has-nənna: ‹Măssinăɣ a t-dd-ăšmašălăn›, ad-hanăɣ-ănn: ‹Adiš, mafăl wăr tomenăm s-a-wa hawăn-inna.› ");
INSERT INTO taq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Afăl has-nənna daɣ dăgg-adəm, aaa...» Wăr helăn tənna n-a-wen, ed ăksuḍăn, ad-fălla-săn tiḍəw tamətte-ta-dăɣ ed təkkas iket-net ăššăk a-s, Exya, ănnăbi n-Măssinăɣ s-tidət a ămoos. ");
INSERT INTO taq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ǝnnăn-as: «Wăr nəssen.» Innʼ-asăn: «Adiš, năkk-dăɣ wăr hawăn-e-ăllăɣeɣ ere wa hi-ikfăn tărna ta s-tăjjăɣ a-wa tăjjăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Issăɣlăy Ɣisa daɣ tangalen tiyyăḍ tamətte. Ijʼ-asăn tiyyăt dăɣ-hasăn-innă: «Kăla t-illa ăhaləs ăddomen ašəkrəš n-lăɣnăb, ijʼ-as afăraj, ijă dăɣ-s edăgg wa dăɣ-iẓimməw lăɣnăb, idăy dăɣ-s edăgg n-soro i-ămagaẓ-net; ifăr-t ḍarăt-a-wen i-inəsduma iyyăḍ təzzar ikkʼ ăkall iyyăn. ");
INSERT INTO taq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iwwăḍ-dd ăzzăman n-amili n-ašəkrəš ɣas, ăšmašăl-dd ănaxdim-net s-inəsduma i-ad-has-dd-awəy ɣur-săn folăt-net dăɣ-a-wa dd-orăw ašəkrəš. ");
INSERT INTO taq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Osʼ-en-dd ănaxdim, ărmăsăn-t, tithəkkin-t har t-əksănăn təzzar, əssəglăn-t korăyrăy. ");
INSERT INTO taq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ăšmašăl-dd săr-săn daɣ ănaxdim iyyăn, ăsfătăqqen eɣăf-net, ăsmăḍrăyăn-t. ");
INSERT INTO taq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Olăs daɣ ašəmmišəl n-iyyăn, ărmăsăn-t ənta, ănɣăn-t kərəf; issəlkăm-asăn-dd-i ăjjootnen, ăsmăḍrăyăn aɣil-năsăn, jăn iman n-aɣil wa iyyăḍăn. ");
INSERT INTO taq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wăr has-dd-ăqqima ḍarăt-a-wen ar ad-săr-săn dd-išəmmišəl rure-s ikna tărha ed inna dăɣ-iman-net: ‹Ǝnta ya šămad rure-ɣ, ănihăjja s-ad-t-səmɣărăn›, ");
INSERT INTO taq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","măšan ənhăyăn-t inəsduma imal-dd ɣas, ănmănnăn: ‹Ǝnhəywăt-ak, amăkkasu-net; əyyăwăt, nărməset, năjet iman-net i-ad-tumas takăsit ti-nănăɣ›; ");
INSERT INTO taq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ărmăsăn-t, ănɣăn-t kərəf təzzar, jărăn-t-in ḍarăt ašəkrəš.» ");
INSERT INTO taq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Issəmdă Ɣisa tangalt ɣas, innʼ-asăn: «Ăssiistănăɣ-kăwăn, ma mad-ăj măssi-s n-ašəkrəš ămăra? Ǝḍmanăɣ-awăn a-s ad-dd-ass ənta iman-net, ilhəs inəsduma-wi-dăɣ təzzar, aləs tefert n-ašəkrəš-net i-iyyăḍ.» ");
INSERT INTO taq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Innʼ-asăn daɣ: «Ajăn wăr tăɣrem dăɣ-əlkəttab n-Măssinăɣ a-s: ‹Tăhunt ta hin-jărăn ălbănnatăn s-ənnăn wăr tənfa hărăt, ənta a-s a-s təšrăy tanfust, tămoos tăhunt ta tufăt n-aɣmăr hakkăt ăṣṣahăt ehăn; ");
INSERT INTO taq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","a-wen Emăli a t-ijăn i-ad-umas tăkunt dat-tiṭṭawen-nănăɣ.› » ");
INSERT INTO taq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Issəmdă Ɣisa tənna n-a-wen ɣas, ad-tattărăn imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt d-inušămăn n-Iṣrayil əmmək s-t-ăstărmăsăn ed əssanăn a-s əntăneḍ-en-dăɣ a ăssiiɣlăy tangalt-ta-dăɣ măšan, wăr helăn a-wen făl tuksəḍa-i jăn i-tamətte; əšlăyăn-as, əglăn. ");
INSERT INTO taq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ăšmašălăn-dd săr-s ḍarăt-a-wen hărăt dăɣ-kăl-faris d-hărăt dăɣ-kăl-Harudəs i-ad-has-əqqənăn tănḍărbat, siḍəwən-t dăɣ-a inna wărăn itətwinn. ");
INSERT INTO taq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Osăn-t-dd, ənnăn-as: «Ălɣalim, nəssan a-s tidət ɣas a janned, wăr tăkkulăd dăɣ-a-wa jănnen ăddinăt, wăr tăn-tăẓmăẓlăyăd, wăr săɣrid daɣ ɣas ar tidət n-tabarăt n-Măssinăɣ. Ămăra, năssiistăn-kăy: ak iwar-anăɣ ad-nəẓəl tiwse i-ămănokal Qăyṣăr meɣ? Năẓlet-tăt meɣ?» ");
INSERT INTO taq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ilmăd Ɣisa ɣur-iman-net s-təlmənufăɣa ta t-təllăt ḍarăt asəstan-năsăn, innʼ-asăn: «Mafăl hi-tižărrubum? Awəyăt-ahi-dd ărriyal n-aẓrəf-năwăn har t-ənhəyăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ăwwăyăn-as-t-dd, innʼ-asăn: «Mi ilăn ăṭṭăṣwer d-isəm wa t-iwărăn?» Ǝnnăn-as: «I n-ămănokal Qăyṣăr.» ");
INSERT INTO taq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Innʼ-asăn: «Adiš, suɣəlăt i-ămănokal wa măqqărăn a-wa fălla-wăn ila, təkfəm daɣ Măssinăɣ a-wa fălla-wăn ila.» Ǝqqălăn-dd ɣas, tofʼ-en tăkunt n-ălwižab-wa-dăɣ hasăn-ija. ");
INSERT INTO taq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Osăn-t-dd ḍarăt-a-wen hărăt dăɣ-kăl-sadus-i ɣur-ija a-s wăr təlkem tanăkra n-inəmmuttan, əssəstănăn-t, ənnăn-as: ");
INSERT INTO taq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Ălɣalim, innʼ-anăɣ ănnăbi Mosa: ‹Afăl ăba ăŋŋa-s n-ăwadəm, oyyă-dd hănne-s dăr-wăr oher ara, idubənet-tăt ăŋŋa-s i-ad-ikrəš əzzurəyăt i-ăŋŋa-s wa ăba i-ad-wăr hin-itiləm isəm n-wa ăba făll-ărori n-ăkall. ");
INSERT INTO taq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ămăra, əkkəs-anăɣ dăɣ-tăqqăn n-eɣăf: kăla t-əllan əssa ayətma; ădobăn dăɣ-săn wa n-amăqqar măšan, ăba-t wăr-ikreš ara. ");
INSERT INTO taq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oyyă-dd hănne-s, ădobăn-tăt wa s-əssin, ăba-t ənta-dăɣ wăr dd-oyya ara, a-wen-dăɣ daɣ a ija wa s-kăraḍ; ");
INSERT INTO taq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ăba-tăn əssa-essăn măšan, wăr tăn-iha i dd-oyyan ara; ăba daɣ tamăḍt ḍara-săn. ");
INSERT INTO taq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Năssiistăn-kăy: ašăl wa n-tanăkra jer-inəmmuttan, əndek dăɣ-săn wa s-e-tumas hănne-s ed, ənhayăn-tăt adubən əssa-essăn?› » ");
INSERT INTO taq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Innʼ-asăn Ɣisa: «Ǝnta-den-dăɣ tasətbat n-išk wa jăm ed, a-wa ənnăn əlkəttabăn hakd-dăɣ a-wa dăr-togdăh tărna n-Măssinăɣ, wăr t-illa a dăɣ-s təfhamăm. ");
INSERT INTO taq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ašăl wa dd-nakkărăn inəmmuttan, meddən hakd tiḍeḍen, ad-ăbas tidubunăn ed ad-talăh tămudre-năsăn d-ta n-ănjălosăn wi hănen išənnawăn. ");
INSERT INTO taq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ămăra, dăɣ-isălan wi n-inəmmuttan d-tanăkra-năsăn, ajăn wăr tăɣrem dăɣ-əlkəttab wa n-ănnăbi Mosa a-wa has-innă Măssinăɣ ɣur-tabsăɣt ta tăhjăljălăt wăr răqq? Wădden, innʼ-as Măssinăɣ: ‹Năkk a-s Măssinăɣ n-Ibrahim d-Isxaqq d-Yaqub.› ");
INSERT INTO taq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A-wen, ălmăɣna-net a-s, ăddinăt-win-dăɣ, han ălžănnăt, tiimələn Măssinăɣ; ənnăr wăr-ədderăn, wăr təjjən a-wen. Măssinăɣ, wădden inəmmuttan a-s ămoos Măssinăɣ, ămoos-t i-wi əddărnen. Tidət-dăɣ a-s toškam ed tənnăm wăr təlkem tanăkra jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ohăẓ-dd iyyăn dăɣ-ălɣulam n-Ăṭṭăwrăt ăsijădăn i-edăwănne wa ija Ɣisa d-kăl-sadus d-ălwižab wa ăhuusken hasăn-ija, innʼ-as: «Ma ămoos ɣur-Măssinăɣ alămăr wa ojărăn?» ");
INSERT INTO taq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Innʼ-as Ɣisa: «Ǝnta da wa ojărăn: ‹Ya Iṣrayil, səjəd! Emăli-nănăɣ Măssinăɣ, ənta ɣas a-s Emăli. ");
INSERT INTO taq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ad-tărhəd Emăli-năk Măssinăɣ s-ulh-năk imda tărhəd-t s-iman-năk əmdan, d-tayətte-năk təmda d-ăṣṣahăt-năk iket-net.› ");
INSERT INTO taq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wa s-əssin daɣ da: ‹Ad-tărhəd ănharăj-năk s-əmmək wa s-tərhed iman-năk.› Wăr t-illa alămăr ojărăn-win-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Innʼ ălɣalim n-Ăṭṭăwrăt i-Ɣisa: «Ălɣalim, tənned tidət: Măssinăɣ iyyăn, wăr t-illa ar ənta. ");
INSERT INTO taq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iwar ăgg-adəm ad-t-ărh s-ulh-net imda, d-tayətte-net təmda d-ăṣṣahăt-net iket-net; ărh daɣ ănharăj-net s-əmmək wa s-irhʼ iman-net. A-wen, wăr t-təlla tasəbḍărt wăla takute wăr-ojer.» ");
INSERT INTO taq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Inhăy Ɣisa iqqud n-ălwižab-net ɣas, innʼ-as: «Kăyy, ăbas tujəjăd Təmmənəya n-Măssinăɣ.» Ăbas t-illa ḍarăt-a-wen ere ihălăn asəstan-net. ");
INSERT INTO taq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isaɣra Ɣisa dăɣ-ehăn n-ămudd wa măqqărăn, ijanna i-ăddinăt: «Ma isawănnen ălɣulam n-Ăṭṭăwrăt a-s Ălmasex, rure-s n-Dawəd? ");
INSERT INTO taq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wădden Dawəd iman-net a innăn s-măjrăd ija Unfas Šăddijăn dăɣ-emm-net a-s: ‹Emăli Măssinăɣ, innă i-Emăli-nin, əyyăw, ɣayəm daw-aɣil-in, hundăɣ har ăjăɣ išənja-năk daw-iḍarăn-năk.› ");
INSERT INTO taq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ɣas šămad Dawəd iman-net iɣarr Ălmasex s-isəm Emăli; əndek əmmək wa s-ăddoobăt ad-umas rure-s?» Ijrăẓ măjrăd-wen-dăɣ ija Ɣisa i-tamətte ta tăjjeet has-tăsijădăt. ");
INSERT INTO taq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dăɣ-a-wa isăɣra, innʼ-asăn: «Agəẓăt iman-năwăn dăɣ-ălɣulam n-Ăṭṭăwrăt, əjraẓnăt-asăn timukal dăɣ-isəlsa ăhobătnen, ijraẓ-asăn ad-hasăn-titwəjjin isofan dăɣ-tišarriten, ");
INSERT INTO taq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ărhan tisăqqima-ti ănnuflăynen dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud d-atwəsəmɣar dăɣ-imjora, ");
INSERT INTO taq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","tihăɣăn a-wa ihăn ifassăn n-tinuḍăfen, a-s ija a-wen, hărkuk tumadăn i-ad-tăn-in-əjrăhăn ăddinăt; ilkam dăɣ-săn ăššăreɣa səmmăn.» ");
INSERT INTO taq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ăqqiima Ɣisa dăɣ-ehăn n-ămudd wa măqqărăn dat-əssəndoqq wa dăɣ-titwəjjinăt tikutawen, ikyad dăɣ-əmmək wa s-dăɣ-s săns tamətte aẓrəf. Təjjarăn dăɣ-s kăl-ehăre ăẓrəf ăjjeen; ");
INSERT INTO taq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","tosă-dd tănuḍăft lăqqəwăt, tăstărăkkăt dăɣ-əssəndoqq sănatăt tămmaten əbḍanen. ");
INSERT INTO taq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iɣră-dd Ɣisa inəṭṭulab-net s-iman-net, innʼ-asăn: «Ăsidătteɣ-awăn a-s tănuḍăft-ta-dăɣ n-talăqqe, tojăr ăddinăt iket-năsăn ihuk, ");
INSERT INTO taq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","făl-a-s iket-năsăn, a-wa s-ăssakăyăn s-wăr-ămɣatărăn a əkfăn, a-s ija a-wen ənta, a-wa təṭṭăf i-tămudre-net iket-net a təkfa.» ");
INSERT INTO taq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Izjăr-dd Ɣisa ehăn n-ămudd wa măqqărăn ɣas, innʼ-as iyyăn dăɣ-inəṭṭulab-net «Ălɣalim, ənhəy ɣas tihun-ti-dăɣ ăhuskătnen, tihusay n-ehăn!» ");
INSERT INTO taq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Innʼ-as Ɣisa: «Wădden hannăyăd-t ehăn-wa-dăɣ măqqărăn ăhusken? Wăr mad-dăɣ-s dd-tăqqayəm tăhunt tiyyăt warăt tamidit-net, ad-ăttăɣtăɣ iket-dăɣ-net.» ");
INSERT INTO taq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ăqqiima Ɣisa ḍarăt-a-wen făll-taḍaɣt ta tăssidwălăt ihəškan wi n-əzzăytun, ikyad dăɣ-ehăn n-ămudd wa măqqăran, issəstăn-t Bəṭrus d-Yaqub d-Exya d-Idris dăɣ-takše, ");
INSERT INTO taq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ənnăn-as: «Lăɣăt-anăɣ əmme d-mad-ăj a-wa s-tənned? Ǝkkəs-anăɣ dăɣ-taɣdărt n-išmal wi s-mad-nəlməd a-s sămdo n-hărăt iket-net, iwwăḍ-dd?» ");
INSERT INTO taq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «He kăwăneḍ, ăjăt ənniyăt, wăr kăwăn-išăšket ăwadəm, ");
INSERT INTO taq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ad-dd-asən ăddinăt ăjjootnen făll-isəm-in, ănn hak iyyăn dăɣ-săn: ‹Năkk a-s Ălmasex›, šiškən s-a-wen-dăɣ ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ad-təsləm i-isălan n-imjărăn d-măhewəl n-imjărăn, wăr tăxwelăm ed ilzam ad-ăj a-wen măšan, sămdo n-ăddunya ənta, wăr-ija hărwa. ");
INSERT INTO taq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ad-təknəs tawset tamidit-net, iknəs əddəwəl amidi-net, ăj laẓ, iškəḍkəḍ ăkall dăɣ-idăggan ăjjootnen, sănto n-tăməddawt n-ăddunya ɣas a-wa, olăh d-sănto n-tiẓẓurt n-tamăḍt jarrăwăt eɣăf-net. ");
INSERT INTO taq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Măšan, ăjăt ənniyăt i-iman-năwăn: ad-hawăn-aškən ăddinăt s-əlxəkum, əjən dăɣ-wăn tiwit dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud; səbdədăn-kăwăn dat-gəfărăn d-imănokalăn, dăɣ-ăddimmăt n-isəm-in wa kăwăn-iwarăn; umas a-wen əssəbab făl tămoosăm tijuhawen-in data-săn, ");
INSERT INTO taq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","i-ad-əslənăt tiwsaten iket-dăɣ-năsnăt i-isălan n-Ălənžil təzzar. ");
INSERT INTO taq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Afăl kăwăn-ăstărmăsăn ăddinăt, wăr tăšăwwašăt dăɣ-isălan n-a-wa mad-tənnəm, ăjăt măjrăd wa kăwăn-e-itwəkfən ăssaɣăt-wen-dăɣ ed wădden kăwăneḍ a maden-ămmăjrăd, Unfas Šăddijăn a he-ijən dăɣ-imawăn-năwăn a-wa s-lăm s-tənna-net. ");
INSERT INTO taq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Išilan-en, ad-isəttărməs ăwadəm ăŋŋa-s i-ad-ămmăt kərəf, isəttărməs abba rure-s, ănnăbdădăn aratăn d-imărawăn-năsăn, əjən iman n-imărawăn-năsăn; ");
INSERT INTO taq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ad-dăr-wăn akəḍăn ăddinăt iket-năsăn, dăɣ-ăddimmăt n-isəm-in wa kăwăn-iwarăn, măšan ere wa ihălăn iman-net, ăkoyăd dăɣ-alkum-hahi har ašăl wa d-imda a-wen-dăɣ iket-net, ad-iɣləs. ");
INSERT INTO taq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Afăl tənhăyăm ănabxas wa n-eməkkărekăḍ hăr ăqqima dăɣ-edăgg wa s-wăr-ila s-ad-dăɣ-s ăqqayəm, ăwadəm wa iɣarrăn isălan-wi-dăɣ, ijrăhet ălmăɣna-năsăn! Wi irmăs a-wen-dăɣ əzzaɣăn teje ta n-Ălyăhudəyăt, jawăḍnet dăɣ-azzal s-ašrut wa n-iḍaɣăn, ");
INSERT INTO taq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","wa iwărăn afălla n-ehăn, wăr dd-itəzəbbutet i-ad-iḍkəl a has-ihan ammas n-ehăn, ");
INSERT INTO taq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","wa ihăn išəkraš, wăr dd-ităqqălet ḍara-s i-ad-iḍkəl asălso-net. ");
INSERT INTO taq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Timəskay tiḍeḍen-ti mad-ărməsăn išilan-win-dăɣ lanăt ənniyăt meɣ siḍuḍnăt. ");
INSERT INTO taq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ǝttărăt dăɣ-Măssinăɣ ad-wăr-itəmzəyyit ajiwəḍ-năwăn d-ăzzăman wa n-tajrəst ");
INSERT INTO taq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ed išilan-en-dăɣ, ad-ăj ălɣizabăt ăssuksăḍăn s-ad-dd-ixlăk Măssinăɣ ăddunya-dăɣ, wăr kăla ătiwănhăy šund ənta făll-ărori n-ăkall, ad-təmdəw ăddunya daɣ, wăr-ilkem ad-ija a dăr-s olăhăn. ");
INSERT INTO taq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Afăl wăr-ifneẓ Emăli dăɣ-tăqqăn n-tisnant ta hăt išilan-win-dăɣ, wăr-iɣəlləs wălʼ ăgg-adəm iyyăn ɣas; măšan, ad-išəkšəl Măssinăɣ tăqqăn n-tiẓẓurt-ten-dăɣ, dăɣ-təssəba n-ăddinăt wi ăsnăfrăn i-əlɣəllas. ");
INSERT INTO taq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ăzzăman-en, afăl hawăn-inna ăwadəm: ‹Ǝnhəywăt-ak, Ălmasex, ənta da!› meɣ ‹Ǝnhəywăt-ak, ənta den!› wăr t-təflesăm. ");
INSERT INTO taq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ad-dd-asən ălmasexăn n-bahu d-ănnăbităn n-bahu, əjən ijităn ăssuksăḍnen d-tišušab, šiškən ənnăr ămmukkăn a-wen wăla ăddinăt wi ăsnăfrăn Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","He kăwăneḍ! Ăjăt ənniyăt i-iman-năwăn, əkkasăɣ-kăwăn dăɣ-taɣdărt hărwa wăr jen hărătăn-win-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Ḍarăt tisnant ta madăt-tăj dăɣ-išilan-win-dăɣ, ‹ad-əlsənăt tihay tăfukt, iba təməlle n-ewăr, ");
INSERT INTO taq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ətrəkken-dd etran dăɣ-išənnawăn, ənhəynəhəyăn iməṣṣuha wi hănen išənnawăn.› ");
INSERT INTO taq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ălwăqq-wen-dăɣ, ad-e-itwənhəy Ăgg-ăgg-adəm, imal-dd, inay tijărăken, təlkam-as tărna-net d-ălxurmăt-net. ");
INSERT INTO taq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dihen, ad-išəmmišəl ănjălosăn-net, sədəwən-dd săr-s dăɣ-tisdas iket-năsnăt e d t-illăm ere ăsinăfrăn Măssinăɣ dăɣ-e-d t-təllăm tamdujt făll-ărori n-ăkall hakd-dăɣ dăɣ-išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Səjrăhăt ɣas əmmək wa s-idaggăl ašar: wădden e-d t-tənhăyăm a-s dd-inšăr har lămmeḍăn ifărketăn-net, ad-tənnəm, osʼ-anăɣ ewelăn. ");
INSERT INTO taq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ǝmmək-wen-dăɣ daɣ a-s afăl tənhăyăm hărătăn-win-dăɣ s-hawăn-ənneɣ har əqqălăn iji, adiš əlmədăt a-s Ăgg-ăgg-adəm, ohăẓ-dd uɣəl-net, osʼ-iwăn făw. ");
INSERT INTO taq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ăsidătteɣ-awăn a-s, wăr-e takəy əzzurəyăt-ta-dăɣ wăr jen hărătăn-win-dăɣ s-hawăn-ənneɣ iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ojăr tărăɣse ija ad-ibʼ išənnawăn d-ăkall, uhən ad-iba tənna-nin. ");
INSERT INTO taq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Dăɣ-isălan n-ašăl meɣ ăssaɣăt wa dăɣ-mad-əjən hărătăn-win-dăɣ, wăr t-illa ere t-issanăn; wăr t-əssenăn ănjălosăn wi hănen išənnawăn wăla Ăgg-ăgg-adəm; Abba ɣas, a t-issanăn. ");
INSERT INTO taq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","He kăwăneḍ! Ɣaymăt tokayăm ed wăr təssenăm ăssaɣăt s-dd-e-ass. ");
INSERT INTO taq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A-wa madăn-ăj, olăh d-ăhaləs iɣarrăn asikəl. Ăssawăḍ tekle ɣas, issəḍmăn ehăn-net dăɣ-inaxdimăn-net; ăsmătăr hak iyyăn dăɣ-săn d-a-wa s-ila s-ad-t-ăj. Inna i-wa iɣlăfăn emm-n-ehăn, ăqqaymet okay. ");
INSERT INTO taq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","A-wen-dăɣ a făl, ɣaymăt tokayăm ed, wăr təssenăm ăssaɣăt s-dd-e-ass măssi-s n-ehăn, alməẓ meɣ tišrayăt n-ehăḍ meɣ ăɣora meɣ tifawt. ");
INSERT INTO taq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Uksaḍăt ad-dd-ass wăr jem făll-a-wen, iɣdăr-kăwăn-dd təṭṭasăm. ");
INSERT INTO taq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A-wa hawăn-janneɣ, janneɣ-t daɣ i-ăddinăt iket-năsăn, ɣaymăt tokayăm.» ");
INSERT INTO taq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ăqqiimăn-in əssin išilan i-ămudd wa n-Faṣka-i dăɣ-tamăkšanăt tijəlwen ti wăr ha tăẓẓa. Tattărăn imănokalăn n-kăl-tikutawen əmmək s-əssăɣdărăn Ɣisa, əjən iman-net măšan, ");
INSERT INTO taq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ənnăn, wăr-ufa ad-ăj a-wen dăɣ-ašăl wa n-ămudd, i-ad-wăr təjj tamdərwayt dăɣ-tamətte. ");
INSERT INTO taq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ašăl iyyăn d-ămijarăt Ɣisa i-Simyon wa s-kăla t-ijrăw jəri izzăɣăn tadăbayt ta n-Bitanya, itamănsaw dihen-dăɣ, a-s t-dd-tosa tamăḍt tăwwayăt butəl iknan dăɣ-tăhunt măllăt, han aḍutăn lanen ălqim wăr-iqqer hărăt. Tosă-dd ɣas, tărẓa emm n-butəl wa tăwwăy, ad-sănɣal aḍutăn wi t-hănen făll-eɣăf n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ǝnhăyăn ăddinăt-wi dăr-ăniɣăyma a-wen, wăr hasăn-ijreẓ, ăhnăffen dăɣ-iman-năsăn, ad-jannen: «Mafăl baxxăsăn aḍutăn-wi-dăɣ, ");
INSERT INTO taq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","wădden ăddooben ad-hin-ənšən kăraḍăt timaḍ n-ărriyal n-aẓrəf ămoosnen takute i-tilăqqiwen.» Oḍănăn ya aḍkăr i-tamăḍt-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Innʼ-asăn Ɣisa: «Ăkfăt-tăt ălɣafyăt, mafăl has-naxxăsăm iman? Tihusay n-hărăt təjʼ-ahi-t! ");
INSERT INTO taq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tilăqqiwen ya, əllanăt ɣur-wăn hărkuk, ălwăqq s-tărhăm-dăɣ, tăddoobem ad-hasnăt-təjəm ălxer măšan, năkk, ilkam ad-kăwăn-ăflăɣ. ");
INSERT INTO taq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tamăḍt-i-dăɣ, təja a-wa tăddoobăt, təššəswăr-dd i-ăddinăt dăɣ-isălan n-əmukən n-tafəkka-nin i-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ăsidătteɣ-awăn a-s edăgg dăɣ-ătwăxṭăbăn isălan n-Ălənžil, dăɣ-ăddunya-ta-dăɣ, ad-dăɣ-s ətwəsuɣəlăn isălan n-a-wa ja i-ad-tăt-kittəwăn ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Inkăr Yăhudəs Isxaryut wa n-iyyăn dăɣ-inəṭṭulab wi n-măraw d-əssin, ikkʼ imănokalăn n-kăl-tikutawen i-ad-hasăn-isăɣdăr Ɣisa, ărməsăn-t. ");
INSERT INTO taq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ăsdăwen-tăn isălan wi dd-iwwăy, jăn-as ărkăwăl n-ad-t-əkfən aẓrəf. Ad-itammăɣ Yăhudəs ɣur-ălwăqq-wen-dăɣ i-tašləlt s-hasăn-t-ăstărmăs. ");
INSERT INTO taq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ašăl wa ăzzarăn n-ămudd dăɣ-tamăkšanăt tijəlwen-ti wăr təha tăẓẓa, ălwăqq wa d-ɣarrăsăn ăddinăt i-taɣsiwen ti n-Faṣka, ənnăn inəṭṭulab i-Ɣisa: «Ǝndek diha d-tărhed ad-nəsəssikəy imənsiwăn n-ămudd wa n-Faṣka?» ");
INSERT INTO taq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ăsmašăl əssin dăɣ-săn s-aɣrəm, innʼ-asăn: «Ǝjjəšăt aɣrəm, ad-dăr-wăn immuqqəs ăhaləs ăwwayăn iddid n-aman, əlkəmăt-as ");
INSERT INTO taq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","s-ehăn wa mad-ijjəš, tənnəm i-măssi-s n-ehăn-en: ‹Innʼ-ak ălɣalim, səkən-anăɣ edăgg dăɣ-ehăn-năk wa dăɣ-mad-səssikəyăɣ ămudd wa n-Faṣka năkk d-inəṭṭulab-in.› ");
INSERT INTO taq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ad-kăwăn-isəkən soro n-ehăn-net ihʼ ehăn hərəwăn, šăddiijăn dăɣ-ămmuujnen isəftaɣ, dihen-dăɣ ad-mad-nəsəssikəy ămudd.» ");
INSERT INTO taq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ǝglăn inəṭṭulab, əjjăšăn aɣrəm, ənhăyăn hărătăn s-əmmək-wa-dăɣ s-hasăn-tăn-innă, ad-siməjnun imənsiwăn wi n-Faṣka. ");
INSERT INTO taq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ijʼ ehăḍ ɣas, osă-dd Ɣisa ăddeew d-inəṭṭulab-net wi n-măraw d-əssin. ");
INSERT INTO taq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tamănsawăn dihen-dăɣ a-s hasăn-inna: «Ăsidătteɣ-awăn a-s iyyăn dăɣ-wăn dăr-i oharăn ămăra-dăɣ a hi-madăn-isəssăɣdăr.» ");
INSERT INTO taq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ǝkmăn-tăn iman-năsăn a-s hasăn-innă a-wen-dăɣ, ad-has-jannen s-iyyăn-iyyăn: «Ajăn năkk?» ");
INSERT INTO taq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Innʼ-asăn: «Ǝnneɣ: iyyăn dăɣ-wăn dăr-i ănimăjjăn ăfuss dăɣ-ăkoss a hi-madăn-isəssăɣdăr. ");
INSERT INTO taq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tidət-dăɣ a-s Ăgg-ăgg-adəm, ad-t-iba, ed a-wen-dăɣ a ənnăn əlkəttabăn n-Măssinăɣ dăɣ-isălan-net măšan, amăskoy ăwadəm wa t-madăn-isəssăɣdăr! Ăwadəm-en, iššăm-as-in ad-wăr dd-ijješ ăddunya făw.» ");
INSERT INTO taq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tattăn dihen-dăɣ a-s iḍkăl Ɣisa tajəlla, ămmoy i-Măssinăɣ təzzar, ăẓun-asăn-tăt, innʼ-asăn: «Uhənăt, a-wa taɣəssa-nin.» ");
INSERT INTO taq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iḍkăl ḍarăt-a-wen kara han aman n-lăɣnăb, ăxxiimmărnen, ămmoy i-Măssinăɣ təzzar, ikfʼ-asăn-t iket-dăɣ-năsăn, əswăn dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Innʼ-asăn: «A-wa ašni-nin wa ămoosăn ărkăwăl n-tassaɣt ta tăynayăt d-Măssinăɣ, ašni-nin, ad-inɣəl dăɣ-təssəba n-ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ăsidătteɣ-awăn a-s ăbas ilkam ad-əsweɣ a dd-ijmaḍăn ara n-lăɣnăb hundăɣ har ašăl wa d-mad-ăswăɣ wa ăynayăn dăɣ-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ăwwăy Ɣisa d-inəṭṭulab-net isuhaɣ n-təmmal n-Măssinăɣ dd-əzjarnen əlkəttab wa n-Ăẓẓăbur, əglăn ḍarăt-a-wen, əkkăn taḍaɣt ta tăssidwălăt ihəškan wi n-əzzăytun. ");
INSERT INTO taq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Innʼ-asăn ḍarăt-a-wen: «Ad-tăqqəlăm ḍarʼ-i iket-dăɣ-năwăn ed iktab dăɣ-əlkəttab n-Măssinăɣ a-s: ‹Ad-əwətăɣ amăḍan, iba-t, ămmăhašnăt tihatten iket-năsnăt.› ");
INSERT INTO taq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Afăl dd-ənkărăɣ jer-inəmmuttan, ad-hawăn-izarăɣ s-teje ta n-Galila.» ");
INSERT INTO taq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iggăd-dd Bəṭrus, innʼ-as: «Kud-irha əkkuddəlăn-kăy imidiwăn-in iket-năsăn, năkk iman-in, wăr kăy-mad-əkkuddəlăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Innʼ-as Ɣisa: «Ăsidătteɣ-ak a-s ehăḍ-i-dăɣ, a-s-e-ăj ekăz əssin iɣoran, tăkkuddălăd-ahi har kăraḍ ihăndăggan.» ");
INSERT INTO taq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ibbărăḍ Bəṭrus, innă daɣ: «Năkk ɣas, kud-dăɣ tamăttant a tihrăɣ dăr-k, wăr kăy-mad-əkkuddəlăɣ.» Abăraj-wen-dăɣ ija Bəṭrus, a jăn imidiwăn-net. ");
INSERT INTO taq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ăddew dăr-săn Ɣisa ḍarăt-a-wen s-ašəkrəš iyyăn iknan asədwal n-ihəškan s-isəm-net Žătsămmani. Ǝwwăḍăn-in ɣas, innʼ-asăn: «Ɣaymăt, tăqqəlăm-ahi diha-dăɣ har ədəlăɣ Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iššənkăš-in fălla-săn, ăddeew d-Bəṭrus d-Yaqub d-Exya; ɣur-ăssaɣăt-wen-dăɣ ad-t-əssəntăn iman-net təkma, ixwăl. ");
INSERT INTO taq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Innʼ-asăn: «Ărɣan iman-in, ărɣan har išwar hi-ăba; wăr təṭṭesăm, ɣaymăt ɣur-i, wăr hanăɣ-ilăqqădet eḍəs.» ");
INSERT INTO taq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iššənkăš-in daɣ fălla-săn a ənḍărrăn, irkăɣ, ad-itəddal Măssinăɣ, ijanna: «Kunta ămmuukkăn a-wen-dăɣ, ajəjet-ahi ăssaɣăt-i-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Innă daɣ dăɣ-tittar-net: «Abba-nin, wăr t-illa a-s wădden tăddoobed-t, səssijəj-ahi tisnant-ta-dăɣ, măšan hakd a-wen-dăɣ, ăjet erhet wa-năk wădden wa-nin.» ");
INSERT INTO taq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iqqăl-tăn-dd Ɣisa, ogăẓ-tăn-dd əṭṭasăn, issənkăr Bəṭrus, innʼ-as: «Simyon, kăyy təṭṭasăd? Adiš, indăr-ak wăla-dăɣ ad-təjəd ăssaɣăt iyyăn tokayăd, ");
INSERT INTO taq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ăyyăt fălla-wăn eḍəs, ədəlăt Măssinăɣ i-ad-kăwăn-agəẓ dăɣ-tănḍărbaten n-Iblis; ăgg-adəm, tidət-dăɣ a-s ăsidărhăn amišəl n-a ăjjeen ăhuusken măšan, igdal-as iba n-ăṣṣahăt n-tumast-net amišəl n-a-wa irha.» ");
INSERT INTO taq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Olăs daɣ ašənkəš fălla-săn, ad-itəddal Măssinăɣ s-əmmək-wənnin-dăɣ s-t-idăl s-tizarăt. ");
INSERT INTO taq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Olăs-tăn-dd uɣəl, ogăẓ-tăn-dd, ijʼ-asăn eḍəs alăɣad wa-dăɣ făl hasăn-indăr wăla ad-arən tiṭṭawen-năsăn; issənkăr-tăn măšan, ăba-hasăn a hasăn-ənnăn a-wa-dăɣ hasăn-ija, ăẓuk n-eḍəs. ");
INSERT INTO taq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ifăl-tăn, ijʼ-asăn-dd uɣəl wa s-kăraḍ, innʼ-asăn: «Ɣas kăwăneḍ təṭṭasăm, sinfum hărwa? Igdăh-awăn; ăssaɣăt wa d-ititwăɣdir Ăgg-ăgg-adəm, ijjəš ifassăn n-inăsbăkkaḍăn, osă-dd. ");
INSERT INTO taq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ǝnkărăt, ăglăt-anăɣ, osʼ-iwăn ămaɣdar-in.» ");
INSERT INTO taq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ămmiijrăd hărwa a-s dd-osa Yăhudəs, iyyăn dăɣ-inəṭṭulab-net wi n-măraw d-əssin, ăsilăl tamətte s-iyyăḍ, əšlajăn tikobawen, iyyăḍ ăwwayăn iboriyăn; ăšimašălăn-tăn imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt d-inušămăn n-Iṣrayil. ");
INSERT INTO taq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tamətte-ten-dăɣ, ijʼ-as Yăhudəs wa n-ămaɣdar tamătart dăɣ-has-inna: «Ăhaləs wa s-hi-tənhăyăm har t-osăsăɣ dăɣ-idmarăn-in, ənta a-s Ɣisa, ărməsăt-t, təgləm dăr-s dăɣ-a-s has-təknam iji n-ənniyăt.» ");
INSERT INTO taq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Osă-dd Yăhudəs, oɣăd iman-net s-Ɣisa, innʼ-as: «Ălfăqqi!» Osăs-t dăɣ-idmarăn-net. ");
INSERT INTO taq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Toḍa tamətte făll-Ɣisa, tărmăs-t. ");
INSERT INTO taq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iggăd-dd iyyăn dăɣ-inəṭṭulab-net, ilbăy-dd tăkoba-net, iwăt săr-s akli n-ămănokal n-kăl-tikutawen, ištăf-dd săr-s taməẓẓujt-net. ");
INSERT INTO taq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Inna Ɣisa i-tamətte: «Ajăn năkk ănaɣtaf a ămoosăɣ a-s hi-dd-takkăm d-tikobawen d-iboriyăn i-ad-hi-tărməsăm? ");
INSERT INTO taq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wădden hak ašăl əlleɣ-t jere-wăn, saɣreɣ dăɣ-ehăn n-ămudd wa măqqărăn, mafăl wăr hi dăɣ-s tărmesăm? Ǝlmədăt a-s a-wa ijăn ašăl-i-dăɣ, ija i-ad-itbət a-wa ənnăn əlkəttabăn n-Măssinăɣ dăɣ-isălan-in.» ");
INSERT INTO taq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ăjewăḍăn inəṭṭulab iket-năsăn, oyyăn-dd Ɣisa ənta ɣas jer-išənja-net. ");
INSERT INTO taq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ilkăm-as-dd ămawaḍ iyyăn wărăn ilsa ar tasəjbəst lămmeḍăt daw-wăr t-illa hărăt, ăkbătten-t-dd ăddinăt ɣas, ");
INSERT INTO taq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","oyyʼ-asăn-in tasəjbəst-net, ošăl wăr ilsa tikəst. ");
INSERT INTO taq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ittəlwăy Ɣisa s-ămănokal n-kăl-tikutawen-i s-a-s ităjj a-wen-dăɣ, ăžžimmăɣăn ɣur-s kăl-tikutawen d-inušămăn n-Iṣrayil d-ălɣulam n-Ăṭṭăwrăt. ");
INSERT INTO taq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tamətte-en, ijʼ-as-dd Bəṭrus alkum šəjren har təjjăš ammas n-ăɣalla n-ehăn n-ămănokal n-kăl-tikutawen; osă-dd Bəṭrus, ijjăš ənta-dăɣ, iglă ăqqima edes i-gărdităn, ad-itazzăh s-efew. ");
INSERT INTO taq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A-s ităjj a-wen-dăɣ, tattărăn imănokalăn n-kăl-tikutawen d-kăl-Sinhidrin-i tirənen ăššăreɣa ere innăn bahu făll-Ɣisa, siḍəwən-t dăɣ-ăššăreɣa, ăɣtəsăn-as tamăttant măšan, wăr t-illa uḍlem fălla-s əjrawăn. ");
INSERT INTO taq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ǝggădăn-dd ăddinăt ăjjootnen, ad-t-saḍlamăn măšan, indăr-asăn ad-ănnăfhămăn făll-bahutăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sawarăn-t iyyăḍ bahu, ");
INSERT INTO taq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","jannen: «nəsallʼ-as a-s innă: ‹Năkk, ad-ărẓăɣ ehăn n-ămudd wa măqqărăn dăyăn ifassăn n-dăgg-adəm, səbdədăɣ-dd dăɣ-kăraḍ išilan i wăr deyăn ifassăn n-ăgg-adəm dăɣ-edăgg-net› » ");
INSERT INTO taq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","măšan, wăla bahu-wen-dăɣ, indăr-asăn ad-fălla-s ănnăfhămăn. ");
INSERT INTO taq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ihă-dd ămănokal n-kăl-tikutawen ibdad dăɣ-ammas n-ălžămaɣăt, innă i-Ɣisa: «Ma tənned dăɣ-a-wa fălla-k itawănnen? Măjrăd!» ");
INSERT INTO taq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wăr t-illa a has-inna Ɣisa. Issəstăn-t ămănokal n-kăl-tikutawen daɣ, innʼ-as: «Ajăn kăyy a-s Ălmasex wa n-Rure-s n-Wa ibbəlălăn.» ");
INSERT INTO taq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Innʼ-as Ɣisa: «Ămoosăɣ-t; ăssiilmădăɣ-kăy daɣ a-s ɣur-ašăl-i-dăɣ, ad-tənhəyăm Ăgg-ăgg-adəm, ăqqiima daw-aɣil n-Wa ilăn tărna iket-net, taləsəm-t daɣ ahănay, iqqal-dd, ifal-dd išənnawăn, inay tijărăken.» ");
INSERT INTO taq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Islʼ ămănokal n-kăl-tikutawen i-a-wen ɣas, ijjăš-t ălhăm wa-dăɣ făl irmăs err n-erăswăy-net, ăsɣărrawăt-t făll-iman-net, inna: «Ma nətajj i-tijuhawen daɣ? ");
INSERT INTO taq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Təslăm-as iket-năwăn a-s ăskafăr wădden; ma tənnăm dăɣ-isălan-net?» Ăswărăn-t uḍlem iket-năsăn, ənnăn ănihăjja d-tamăttant. ");
INSERT INTO taq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ad-fălla-s situfăn, salsen ekăršăy idəm-net, sattăɣăn-as, jannen-as: «Luləy ya!» Sattăɣăn-as daɣ gărdităn. ");
INSERT INTO taq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ăqqiima Bəṭrus dăɣ-ammas n-ăɣalla-en-dăɣ a-s t-dd tosa tiyyăt dăɣ-tinaxdimen n-ămănokal n-kăl-tikutawen; ");
INSERT INTO taq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","tənhăy-t izzah s-efew, tăzjăzzʼ-e, tənnʼ-as: «Kăyy-dăɣ, kăla tăddewăd d-Ɣisa wa n-Năṣirăt?» ");
INSERT INTO taq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ăkkuddăl Bəṭrus a-wen, innʼ-as: «Wăr-əjrehăɣ, wăr-əssenăɣ a dăɣ-hi-tăssewălăd.» Izjăr Bəṭrus ḍarăt-a-wen, ikkʼ emm n-ăɣalla ɣas, iwăt ekăz ăɣora. ");
INSERT INTO taq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tənhăy-t daɣ tănaxdimt tiyyăt, ad-janna i-ăddinăt-wi t-əllanen dihen: «Hannăyăm-t ăhaləs-wa-dăɣ, iyyăn dăɣ-săn.» ");
INSERT INTO taq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Olăs daɣ Bəṭrus akuddəl n-a-wen. A ənḍărrăn ḍarăt-a-wen, ənnăn-as ăddinăt əbdadnen dihen: «Ijmaḍ-t ăššăk a-s iyyăn dăɣ-săn a tămoosăd ed kăyy-dăɣ, Galila a kăy-lăt.» ");
INSERT INTO taq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ad-hasăn-ităhhaḍ, ilaqqăn iman-net siha d-siha, ijannʼ-asăn: «Ăhaləs wa s-hi-jănnem, wăr t-əzzeyăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Diha-dăɣ d-innă a-wen-dăɣ ad-iwăt ekăz ăɣora wa s-əssin. Iktă-dd Bəṭrus măjrăd wa s-kăla has-t-ija Ɣisa a-s has-innă: «Wăr mad-iwət ekăz əssin iɣoran wăr tənned har kăraḍ ihăndăggan, wăr hi-təzzeyăd.» Izjăr, ad-ihall. ");
INSERT INTO taq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hărwa emăɣăr ad-ănmănhăyăn kăl-tikutawen d-inušămăn n-Iṣrayil d-ălɣulam n-Ăṭṭăwrăt d-kăl-Sinhidrin-i tirənen ăššăreɣa; jăn tišəm dăɣ-Ɣisa təzzar, əlwăyăn-t s-Bilatəs. ");
INSERT INTO taq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Inhăy-t Bilatəs ɣas, issəstăn-t, innʼ-as: «Ak, kăyy a-s ămănokal n-kăl-Ălyăhud meɣ?» Innʼ-as Ɣisa: «Kăyy iman-năk, tənned-tăn.» ");
INSERT INTO taq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ad-t-sawarăn uḍlemăn ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Issəstăn-t Bilatəs daɣ, innʼ-as: «Ǝnhəy ɣas a-wa fălla-k itawănnen? Ma tənned kăyy iman-năk?» ");
INSERT INTO taq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wăr t-illa a has-inna Ɣisa har iqqăn asusəm-net eɣăf n-Bilatəs. ");
INSERT INTO taq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ăzzăman-en, hak ămudd n-Faṣka, ăsiwăyyʼ-in gəfăr u-takărmut wa dăɣ-s təttăr tamətte. ");
INSERT INTO taq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A-s ităjj a-wen, ihʼ ăhaləs s-isəm-net Bărɣăbbas takărmut ənta d-imidiwăn-net s-kăla dd-əssənkărăn tamətte har jăn iman n-ăwadəm dăɣ-a-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tənkăr tamətte iket-net ad-tattăr dăɣ-Bilatəs a-wa s-izzăy ad-hasăn-t-ăj. ");
INSERT INTO taq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Innʼ-asăn: «Ak ajăn tărham ad-hawăn-in-ăyyăɣ ămănokal n-kăl-Ălyăhud?» ");
INSERT INTO taq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Issan Bilatəs a-s təmɣăre n-tismiten n-imănokalăn n-kăl-tikutawen a făl ăstărmăsăn Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ǝntăjăn-dd tamətte s-Bilatəs i-ad-hasăn-dd-isəwwəyy Bărɣăbbas. ");
INSERT INTO taq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Olăs daɣ Bilatəs, innʼ-asăn: «Ma s-tărham ad-t-ăjăɣ i-wa s-itawănna ămănokal n-kăl-Ălyăhud?» ");
INSERT INTO taq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Olăsăn eɣări, jannen: «Itwăṣləbet făll-tajəttewt.» ");
INSERT INTO taq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Innʼ-asăn Bilatəs: «Mafăl, ma iɣšăd t-ăsiinăhăjjăn d-tamăttant?» Ăsɣăyyăn dăɣ-išənnawăn: «Itwəṣləbet făll-tajəttewt.» ");
INSERT INTO taq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ăssof Bilatəs alkum i-erhet-năsăn, ăswăyyʼ-asăn-in Bărɣăbbas, ăswăjja tiwit s-ebărtăk dăɣ-Ɣisa təzzar, ikfʼ-asăn-t i-ad-itwăṣləb. ");
INSERT INTO taq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ǝlwăyăn əssărdusa wi n-gəfăr Ɣisa s-ammas n-ehăn wa dăɣ-iɣattăs ăššăreɣa, iɣlăyɣălăy-t-dd dihen ejhăn n-əssărdusa imdan, ");
INSERT INTO taq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","əssəlsăn-t anăkăbba šăggăɣăn, jăn-as ălmăt, korona, a-wen, takənbut šund ta n-imănokalăn, təẓat dăɣ-isənnanăn, ");
INSERT INTO taq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ad-has-tajjăn isofan, jannen-as: «Ămănokal n-kăl-Ălyăhud, nəjʼ-ak gărdəbu.» ");
INSERT INTO taq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hakkăn-t tiwit s-tăborit făll-eɣăf, situfăn fălla-s, rakkăɣăn data-s, ălmăt ɣabbădăn-t. ");
INSERT INTO taq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ǝssəgdăhăn dăɣ-tekăškăšt ta tăn-təšlăt ɣas, əkkăsăn-dd fălla-s anăkabba-wənnin šăggăɣăn, ăssoɣălăn-as isəlsa-net təzzar, əzjărăn dăr-s aɣrəm s-edăgg wa-dăɣ ila s-ad-dăɣ-s itwəṣləb făll-tajəttewt. ");
INSERT INTO taq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ǝglan dăr-s a-s ămmoqqăsăn d-Simyon wa n-tadăbayt ta n-Qərwan n-abba n-Ălxaḍer d-Rəffus, ifal-dd išəkraš; ăšhăššălăn-t alənji n-tajəttewt ta făll-mad-itwăṣləb Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ăwwăyăn Ɣisa s-edăgg wa s-itawănna Gălgota, a-wen, ălmăɣna-net: «Edăgg wa n-akărkor.» ");
INSERT INTO taq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ǝssărtăyăn-as-dd dihen asməd d-asăfar iyyăn ifannăẓăn tisnant dăɣ-taɣəssa n-ăwadəm măšan, unjăy iswʼ-e. ");
INSERT INTO taq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ǝṣlăbăn-t əssărdusa făll-tajəttewt ɣas, jăn tisăɣeren i-ad-uẓanăn isəlsa-net jer-iman-năsăn, əlmədăn əndek a-wa he-ikrəš hak iyyăn dăɣ-săn. ");
INSERT INTO taq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Agdəlset a-s t-əṣlăbăn făll-tajəttewt, ɣur-ăssaɣăt wa s-təẓẓa. ");
INSERT INTO taq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ǝttəytăyăn ăllox jənnəj-s i-ad-əlmədăn ăddinăt ăddălil wa săr-s dd-orăwăn tamăttant; ăllox-en, iktab fălla-s: ");
INSERT INTO taq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ašăl-en, ămizăyyen əssin inaɣtafăn atwəṣləb d-Ɣisa; ătwăṣlăb iyyăn daw-aɣil-net, ătwăṣlăb wa iyyăḍăn daw-tăšalje-net. ");
INSERT INTO taq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","A-wen-dăɣ jăn i-Ɣisa a-s ənnăn əlkəttabăn n-Măssinăɣ ad-ăj făl-a-s, iktab a-s: «Ad-iḍan dăɣ-iməddăɣwa.» ");
INSERT INTO taq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iqqăl Ɣisa tekăškăšt i-ăddinăt-wi tikəynen, gaggărăn-t, siwliwilăn iɣăfawăn-năsăn, jannen-as: «Ǝyyaa, kăyy wădden tənned tăddobed terăẓẓe n-ehăn n-ămudd wa măqqărăn, taləsăd-t edey dăɣ-kăraḍ išilan, ");
INSERT INTO taq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","əɣləs ya iman-năk ămăra, təzzəbbud-dd tajəttewt!» ");
INSERT INTO taq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jăn-t daɣ imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt tekăškăšt, tinmənnin: «Ǝnta-i iɣlăsăn ăddinăt wi iyyăḍnen, indar-as ămăra ad-iɣləs iman-net. ");
INSERT INTO taq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kunta ənta a-s Ălmasex wa n-ămănokal n-Iṣrayil, izzubbətet-dd tajəttewt, ad-t-nənhəy, namən săr-s.» Jăn-t wi ătwăṣlăbnen edes-has tekăškăšt, ad-t-gaggărăn əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ǝlsănăt tihay ărori n-ăkall iket-dăɣ-net wa-dăɣ n-tarăhut hundăɣ har tezzar. ");
INSERT INTO taq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Təja tezzar ɣas, ăsɣărăt Ɣisa s-ăṣṣahăt, innă: «Yăḷḷoy, Yăḷḷoy, lama săbăxtani?» A-wen ălmăɣna-net: «Măssi-ɣ Măssinăɣ, Măssi-ɣ Măssinăɣ, mafăl hi-tiyyəd d-iman-in dăɣ-tisnant-ta-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ǝslăn-as ăddinăt əbdadnen dihen, wăr-əfhemăn a-wa ijănna ɣas, ad-jannen: «Săjdăt-as, ănnăbi Ɣəli a iɣarr.» ");
INSERT INTO taq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ošăl-dd săr-s iyyăn dăɣ-săn, issəlmăɣ tăḍuft təttalăt făll-ăbori dăɣ-bənegăr, iẓẓăl-as-tăt i-ad-tăt-isuməm, infəw-t a-wen dăɣ-fad, ihakk-as-tăt dihen-dăɣ, ijanna: «Ad-nənhəy ya kunta ad-t-dd-ass ănnăbi Ɣəli, izəzzubbət-t-dd tajəttewt.» ");
INSERT INTO taq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ăsɣărăt Ɣisa s-ăṣṣahăt ḍarăt-a-wen, əjmăḍăn-t iman. ");
INSERT INTO taq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iqqărrawăt ălwăqq-wen-dăɣ ărido wa ibḍăn dăɣ-ehăn n-ămudd wa măqqărăn, edăgg wa šăddijăn d-edăgg wa iknăn təšədje dăɣ-ammas, wa-dăɣ n-afălla-net har ider-net. ");
INSERT INTO taq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inhăy kăbtăn iyyăn iswaḍăn dăɣ-Ɣisa a-s t-ijmăḍ unfas a-wen ɣas, innă: «Tidət-dăɣ a-s ăhaləs-i-dăɣ, Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ǝbdadnăt daɣ dihen tiḍeḍen tiyyăḍ dăɣ-ijəj, əkyadnăt dăɣ-a-wa ijăn. Tiḍeḍen-en, hʼ-enăt Măryăma ta n-Mulăždaləyăt, Măryăma ta n-ma-s n-Yaqub wa ənḍărrăn d-Yusəf d-tiyyăt s-isəm-net Sălma. ");
INSERT INTO taq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ǝntănăteḍ-en-dăɣ ad-dd-ăddewnen d-Ɣisa, wa-dăɣ n-Galila, ədhalnăt-t s-a-wa əṭṭăfnăt har əntănăteḍ-da-dăɣ; əbdadnăt daɣ edes-hasnăt tiyyăḍ ăjjootnen dd-ăddeewnen d-Ɣisa a-s dd-ikka Yărussălam. ");
INSERT INTO taq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tokăy takkăṣt n-ašăl wa n-əlžəmət, sadaw tamətte i-ašăl wa n-əssəbət-i n-tăsonfat, ");
INSERT INTO taq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","osă-dd Yusəf wa n-Arimata, ăhaləs ătiwăsămɣărăn dăɣ-inušămăn n-Iṣrayil, ijar ăṭṭăma n-a-s təlkam Təmmənəya n-Măssinăɣ. Ǝnta-en-dăɣ a ihălăn tikawt n-Bilatəs, ittăr dăɣ-s tafəkka n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tofa tăkunt n-armuḍ n-tamăttant n-Ɣisa Bilatəs, issăɣră-dd kăbtăn iyyăn i-ad-t-isəstən d-a-s tădduuttăt tamăttant-net meɣ? ");
INSERT INTO taq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ijă dăɣ-s kăbtăn-en isălan n-a-s ăba-t ɣas, issărrăx-as aḍkul n-tafəkka-net. ");
INSERT INTO taq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iglă Yusəf, ižžənsă-dd tefit, ikkăs-dd tafəkka n-Ɣisa făll-tajəttewt, ijʼ-et dăɣ-tefit təzzar, issənsʼ-et dăɣ-aẓəkka iɣašăn dăɣ-esăwăl; ăsɣărănɣarăt ḍarăt-a-wen tăhunt măqqoorăt, ăṭṭubbăt săr-s emm n-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tăjjəyha Măryăma ta n-Mulăždaləyăt d-Măryăma ta n-ma-s n-Yusəf i-a-wen-dăɣ iket-net, əknănăt asəbbuyən n-edăgg wa dăɣ-iẓka Ɣisa təzzar, əglănăt. ");
INSERT INTO taq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Okăy əssəbət-i n-ašăl wa n-tăsonfat ɣas, təžžənšă-dd Măryăma ta n-Mulăždaləyăt d-Măryăma ta n-ma-s n-Yaqub d-Sălma əlɣənfărăn i-ad-əšwəynăt săr-săn tafəkka n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tifawt n-ălxad-i n-ašăl wa ăzzarăn dăɣ-əssəboɣ, ɣur-ajmuḍ n-tăfukt, əkkănăt aẓəkka. ");
INSERT INTO taq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ǝglanăt, tinmənninăt jer-iman-năsnăt: «Năkkănăteḍ-i-dăɣ, mi hanăɣ-e-ikkəsən tăhunt ta măqqărăt təhărăt emm n-aẓəkka?» ");
INSERT INTO taq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ǝwwăḍnăt-in ɣas, əkyădnăt, ənhăynăt a-s tăhunt-tənnin măqqărăt, tăɣirarăd-in. ");
INSERT INTO taq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ǝjjăšnăt ammas n-aẓəkka, ənhăynăt ămawaḍ ilsan emăls măllăn, ăqqiima daw-aɣil-năsnăt, tărtăy-asnăt tarəmmeɣt d-tăqqăn n-eɣăf. ");
INSERT INTO taq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Măšan, innʼ-asnăt ămawaḍ: «Wăr tăqqănnet iɣăfawăn-năkmăt, wăr tărmeɣmăt, Ɣisa wa n-Năṣirăt ătwăṣlăbăn s-tammăɣmăt, inkăr-dd jer-inəmmuttan, ăbas t-illa diha; ənhəymăt edăgg wa s-kăla dăɣ-s insa. ");
INSERT INTO taq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ămăra, ăkkəmăt inəmmušal d-Bəṭrus, tənnəmăt-as a-s ăzzar-awăn iket-năwăn s-Galila, dihen-dăɣ ad-mad-t-tənhəyăm s-əmmək wa-dăɣ s-kăla hawăn-tăn-inna.» ");
INSERT INTO taq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ǝzjărnăt-dd aẓəkka ɣas, ošălnăt, tăšišăkăḍkăḍ-tănăt tarəmmeɣt tărtayăt d-tăqqăn n-eɣăf. Wăr t-illa ere s-ənnanăt hărăt a-wa-dăɣ hasnăt-ja tarəmmeɣt.  ");
INSERT INTO taq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ašăl wa n-ălxad-i n-ašăl wa ăzzarăn dăɣ-əssəboɣ ad-dd-inkăr Ɣisa jer-inəmmuttan. Ănfalăl-dd s-tizarăt i-Măryăma ta n-Mulăždaləyăt-i dăɣ-ikkăs əssa alšinăn, ");
INSERT INTO taq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","təglă, təjʼ-isălan dăɣ-ăddinăt wi s-kăla ăddewăn d-Ɣisa-i s-a-s ităjj a-wen, əṭṭafăn iba-net, ăsniinăn. ");
INSERT INTO taq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ǝslăn a-s tənhay-t iddar măšan, unjăyăn s-ad-tăt-əfləsăn. ");
INSERT INTO taq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Issəkna Ɣisa iman-net ḍarăt-a-wen i-əssin dăɣ-inalkimăn-net əkkanen ejef. Ănfalăl-asăn-dd dăɣ-ini săl wənnin-dăɣ dd-ănfalăl i-Măryăma. ");
INSERT INTO taq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ǝqqălăn Yărussălam, jăn isălan dăɣ-imidiwăn-năsăn wi iyyăḍnen măšan, wăr tăn-əflesăn əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ănfalăl-dd Ɣisa ḍarăt-a-wen i-inəṭṭulab wi n-măraw d-iyyăn dăɣ-ălwăqq d-ăžžiimmăɣăn, tamănsawăn. Ăklăwlăw fălla-săn dăɣ-təssəba n-iba immun-năsăn d-tăɣart-ta jăn ulhawăn-năsăn făl-a-s, unjăyăn əflăsăn ăddinăt wi t-ənhăynen, inkar-dd jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Innʼ-asăn: «Ămăra, ăglăt, ilalăt ăddunya iket-net, tăxṭəbăm Ălənžil i-e d t-illăm ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wa omănăn, ătwăsălmaɣ dăɣ-aman, ad-iɣləs; wa ăsɣărăn ulh-net, ad-t-iwăr uḍlem dat-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ǝntăneḍ-da hărătăn wi mad-ămašălăn wi maden-amən: ad-əkkəsăn alšinăn dăɣ-ăddinăt s-tărna n-isəm-in, ad-ămmăjrădăn awalăn ăynaynen, ");
INSERT INTO taq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","əṭṭəfăn taššălen dăɣ-ifassăn-năsăn, kud-əswăn sunsəj-dăɣ, wăr hasăn-e-iɣšəd hărăt, e-d ăswărăn ifassăn-năsăn imarhinăn, ad-əzzəyăn.» ");
INSERT INTO taq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ijʼ-asăn Ɣisa măjrăd-wen-dăɣ ɣas, imməḍkăl s-išənnawăn, iglʼ ăqqima daw-aɣil n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ǝglăn inəṭṭulab ḍarăt-a-wen, ad-xaṭṭăbăn isălan dăɣ-idăggan iket-năsăn. Idhal-tăn Emăli, isidəttut măjrăd-năsăn s-ijităn n-Măssinăɣ wi tamašalăn. Amin!");
INSERT INTO taq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","I-Tăyofil wa əkneɣ semɣar: Ǝttărăn ăddinăt ăjjootnen, ad-əktəbăn s-ălmăɣna isălan wi jănen jere-năɣ, ");
INSERT INTO taq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","s-əmmək-wa-dăɣ s-hanăɣ-tăn-ăssoɣălăn ăddinăt wi tăn-ənhăynen s-tiṭṭawen-năsăn s-tizarăt, ija Măssinăɣ imawayăn n-măjrăd-net. ");
INSERT INTO taq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A-wen-dăɣ a făl năkk-dăɣ, ijjăš-ahi-dd ənniyăt n-ad-əmmăɣăɣ i-isălan-en-dăɣ s-iyyăn-iyyăn ɣur-alăṣăl-năsăn, hundăɣ har ašăl-i-dăɣ, i-ad-hak-hasăn-in-ăjăɣ akătab ăsisăjrăhăn, ");
INSERT INTO taq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","təkkəssăd ăššăk a-s teɣăre ta təjrăwăd, tətbat. ");
INSERT INTO taq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ăzzăman wa d-ămoos Harudəs ămănokal n-teje ta n-Ălyăhudəyăt, illʼ-e ăhaləs iyyăn dăɣ-wi n-kăl-tikutawen s-isəm-net Zăkărya, išɣal dăɣ-ehăn n-ămudd wa măqqărăn dăɣ-taggayt n-kăl-tikutawen ta n-ihăyawăn n-Abya, isəm n-hănne-s Elizăbăt, tahăyawt n-Harun a tămoos. ");
INSERT INTO taq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oɣadăn issənăn-essăn dat-Măssinăɣ, əṭṭafăn s-ălxaqq fărəḍăn d-alămărăn n-Emăli, ");
INSERT INTO taq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","măšan wăr len ara ed Elizăbăt, tăjjojra, tăwwăḍ-tăn-dd daɣ tušăre issənăn-essăn. ");
INSERT INTO taq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ašăl iyyăn dd-tăqqăl tasəssăɣlit taggayt n-kăl-tikutawen ta iha Zăkărya, išlʼ-e əššăɣəl-net dat-Măssinăɣ hundăɣ har fălla-s oḍănăt tisăɣeren, ");
INSERT INTO taq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ămoos a-wen ălɣadăt n-kăl-tikutawen n-a-s afăl oḍanăt tisăɣeren făll-ăwadəm, ənta a-madăn-isəhhuh matălxer dăɣ-ehăn wa šăddijăn n-Emăli. ");
INSERT INTO taq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ašăl-en, isihəwhəw matălxer dăɣ-ehăn-en-dăɣ, a-s ităjj a-wen-dăɣ, ălžămaɣăt wa n-inaɣbadăn, itəddal Măssinăɣ dat-emm n-ehăn n-ămudd wa s-ijjăš Zăkărya ammas-net. ");
INSERT INTO taq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A ənḍărrăn, ănfalăl-as-dd ănjălos n-Emăli făll-aɣil n-tasəskărt-ta făll-tihuh matălxer. ");
INSERT INTO taq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Inhăy Zăkărya ănjălos ɣas, iggăd ənniyăt, irmăɣ ");
INSERT INTO taq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","măšan, innʼ-as ănjălos: «Zăkărya! A-wa təttărăd dăɣ-Măssinăɣ, ad-ăj, hănne-k Elizăbăt, ad-təkrəš ara, təjəd-as isəm: Exya. ");
INSERT INTO taq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ad-hak-umas əssəbab n-tedăwit d-tisrawt, səddəwət daɣ tiwit-net ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ad-umas ere ilan isəm ɣur-Emăli d-idəm ɣur-Măssinăɣ, wăr mad-isəw aman n-lăɣnăb ăxxiimmărnen wălʼ asməd wălʼ iyyăn, ad-t-iḍnəy Unfas Šăddijăn n-Măssinăɣ hărwa iha tăsa n-ma-s. ");
INSERT INTO taq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ǝnta a dd-madăn-isuɣəl a ăjjeen dăɣ-kăl-Iṣrayil Emăli-năsăn, Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ilkəm-as s-ənniyăt d-ăṣṣahăt wa n-ănnăbi Ɣəli i-ad-dd-isuɣəl ulhawăn n-abbatăn aratăn-năsăn, əkrəšăn iməkkeddəlăn tayətte ta karrăšăn ăddinăt lanen idəm dat-Măssinăɣ, isəbdəd tamətte tăsidăwăt i-ad-təlkəm i-Emăli.» ");
INSERT INTO taq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Innă Zăkărya ḍarăt-a-wen i-ănjălos: «Ǝndek a-wa s-mad-əlmədăɣ a-s a-wa hi-jănned tidət? Năkk, amɣar wăššărăn a ămoosăɣ, hănne-ɣ daɣ ti-wăššărăt.» ");
INSERT INTO taq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Innʼ-as ănjălos: «A-wa năkk Žibril-wa s-hărkuk əbdădăɣ dat-Măssinăɣ, ăšmašăl-ahi-dd săr-k i-ad-kăy-dd-səssiwəḍăɣ isălan-wi-dăɣ ăhuskătnen. ");
INSERT INTO taq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ămăra, šămad wăr hi-təflesăd a-s hak-əmməjrădăɣ s-tizarăt, ad-itwəṭṭəf emm-năk, ikrəs iləs-năk hundăɣ har ašăl wa d-mad-itbatăn isălan-wi-dăɣ hak-jeɣ.» ");
INSERT INTO taq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A-s ităjj a-wen-dăɣ, tamətte tăqqal i-Zăkărya, tofʼ-et tăkunt n-a-wa t-in-išlăn d-a-wa t-in-iṭṭafăn. ");
INSERT INTO taq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ălwăqq wa dd-izjăr, ittăr ad-ămmăjrăd i-ăddinăt măšan, indăr-as, əlmădăn a-s hărăt a has-dd-ănfalălăn dăɣ-ehăn-en-dăɣ, ad-hasăn-isitufəy i-ad-tăn-isəfhəm a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Issəmdă Zăkărya tăqqăn-net dăɣ-əššăɣəl ɣas, iqqăl ehăn-net. ");
INSERT INTO taq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Təkrăš hănne-s ḍarăt-a-wen ənniyăt ɣas, ja səmmos orăn təffăr iman-net dăɣ-ehăn-net, ");
INSERT INTO taq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","janna: «Ǝnta da a-wa hi-ija Emăli-nin, ənta a dăɣ-i dd-iswăḍăn, ikkăs făll-i tăkrakiḍt ta ămoosăɣ jer-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Təjjăš Elizăbăt ewăr-net wa s-săḍis ɣas, ăšmašăl Măssinăɣ ănjălos-net Žibril s-taɣrəmt tiyyăt s-itawănna Năṣirăt hat teje ta n-Galila, ");
INSERT INTO taq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ăssokʼ-e tămawaḍt wărăt təzzey meddən s-isəm-net Măryăma, ittar ăhaləs n-ahăya n-ămănokal Dawəd s-isəm-net Yusəf. ");
INSERT INTO taq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Osă-dd ănjălos Măryăma, innʼ-as: «Ǝjeɣ-am ăsafu kămm-i tənnəfrănăt ed, təkrăšăd idəm ɣur-Emăli-năm.» ");
INSERT INTO taq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Issărmăɣ-tăt măjrăd-wen-dăɣ, ad-tattăr ălmăɣna n-manăwen-wa-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Innʼ-as ănjălos: «Măryăma, wăr tărmeɣăd, ăzzăbbăt-dd Măssinăɣ ănnuɣmăt-net fălla-m, ");
INSERT INTO taq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","kămm da-dăɣ, ad-təkrəšăd ənniyăt, təkrəšăd ara, təjəd-as isəm Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ad-ikrəš isəm, iwăr-t isəm Rure-s n-Măssinăɣ wa iknăn aḍkul, ad-ăj Emăli Măssinăɣ əṭṭəbəl wa n-ămănokal Dawəd-i t-ăshăyăwăn dăɣ-ifassăn-net, ");
INSERT INTO taq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ad-imnukəl hărkuk făll-ehăn wa n-ihăyawăn n-Yaqub, tiɣlal təmmənukəla.» ");
INSERT INTO taq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tənnă Măryăma ḍarăt-a-wen i-ănjălos: «Ǝndek əmmək wa s-e-ăj a-wen ed năkk, wăr-əzzeyăɣ meddən.» ");
INSERT INTO taq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Innʼ-as ănjălos: «Ad-fălla-m dd-izzubbət Unfas Šăddijăn, tălsʼ-im tărna n-wa iknăn aḍkul, a-wen-dăɣ a făl ara wa šăddijăn dd-e-iwən, ad-t-iwăr isəm Rure-s n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ara n-meddən-năm, Elizăbăt, wădden ti-wăššărăt măšan, ad-təkrəš ara ənta-dăɣ, ənta-i s-kăla tămoos teməjjejrut, ha ămăra ewăr-net wa s-săḍis ");
INSERT INTO taq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ed, wăr t-illa a-s wădden ăddoobăt-t Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tənnʼ-as Măryăma: «Năkk, taklit n-Emăli, itwəjjet-ahi a-wa s-tənned.» Ifăl-tăt ănjălos ăssaɣăt-wen-dăɣ, iglă. ");
INSERT INTO taq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Təkkă Măryăma išilan-win-dăɣ taɣrəmt tiyyăt n-kăl-Yăhuda hat iḍaɣăn. ");
INSERT INTO taq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tăwwăḍ-in ehăn wa n-Zăkărya, ad-tinməjj isofan d-Elizăbăt. ");
INSERT INTO taq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Diha-dăɣ d-has-təja Măryăma ăsafu, ad-iggăd, iɣbăr-tăt alyaḍ wa ihăn tăsa-net, iḍnăy-tăt Unfas Šăddijăn ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Təḍkăl Elizăbăt emăsli-net, tənnă: «Tənḍəḍ-am kămm jer-tiḍeḍen, tənḍəḍ daɣ i-ara wa ihăn tăsa-năm. ");
INSERT INTO taq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ǝnta năkk-i-dăɣ, ma ămoosăɣ tis-ahi-dd anna n-Emăli-nin? ");
INSERT INTO taq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ijmaḍ-t ăššăk a-s diha-dăɣ d-əslănăt timəẓẓujen-in i-ăsafu-năm, ad-iggăd ara-wa ihăn tăsa-nin s-tedăwit. ");
INSERT INTO taq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tənḍəḍ-am kămm-i təflăsăt a-s Emăli a ijăn-dăɣ, ilkam ɣas, ad-isətbət a-wa s-ijjăš ărkăwăl-net.» ");
INSERT INTO taq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tənnă Măryăma: «Timələn iman-in təmɣăre n-Emăli, ");
INSERT INTO taq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ăddiwăt ulh-in făl təssəba n-a-wa hi-ija Măssinăɣ-i n-Ămaɣlas-in. ");
INSERT INTO taq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ikyăd-dd dăɣ-təmmăḍrit n-taklit-net. Ɣur-ašăl-i-dăɣ, e d t-illăm ere ilkamăn făll-ărori n-ăkall, ad-hi-ănn: ‹Tənḍəḍ-am› ");
INSERT INTO taq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","făl-a-s, Wa ilăn tărna, ijʼ-ahi a ăjjeen, šăddiij isəm-net. ");
INSERT INTO taq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tăhanint-net tənsa făll-əzzurəyatăn ti t-ăksuḍnen dăɣ-iwətyan iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Issəkna tărna n-ăfuss-net, ăsmăḍrăy s-ăṣṣahăt-net ăddinăt wi iha əttəkəbru, ");
INSERT INTO taq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ikkăs-dd daw-kăl-ăṣṣahăt təmmənukəla-năsăn, issəfrăr tilaqqiwen, ");
INSERT INTO taq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ăsyăwăn iməlluẓa dăɣ-a-wa ăẓedăn, ăsɣăr ifassăn n-kăl-ehăre. ");
INSERT INTO taq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Idhăl kăl-Iṣrayil-i n-eklan-net, wăr hin-iṭṭef fălla-săn tăhanint-net ");
INSERT INTO taq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ed, ămoos a-wen ărkăwăl iɣlalăn ijjaš i-imărawăn-nănăɣ wi n-ibda s-əmmək wa s-t-ija i-Ibrahim d-ihăyawăn-net.» ");
INSERT INTO taq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Təzzăɣ Măryăma ɣur-Elizăbăt har tăssakăy əḍḍəkuḍ n-kăraḍ orăn təzzar, tăqqăl ehăn-net. ");
INSERT INTO taq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tăwwăḍ-dd tăqqăn ta dăɣ-jarrăw Elizăbăt eɣăf-net, təkrăš ara n-eyy. ");
INSERT INTO taq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ǝslăn ănhărajăn-net d-išăqqaɣăn-net tihusay n-a-wa has-ija Emăli ɣas, ohărăn dăr-s tedăwit ta ja. ");
INSERT INTO taq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ikrăš ara əttam išilan ɣas, ămelăy, jăn-as ăddinăt isəm Zăkărya i-ad-umas anəmmăɣru n-ti-s ");
INSERT INTO taq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","măšan, tənnʼ-asăn ma-s: «Ăbo! Iwăret-t isəm Exya.» ");
INSERT INTO taq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ǝggădăn-dd săr-s ăddinăt, ənnăn-as: «Wăr t-illa ăwadəm dăɣ-ihănan-năwăn iwar isəm-wen-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ăstafăyăn i-ti-s n-alyaḍ i-ad-ănn ənta isəm wa s-irha ad-iwăr rure-s. ");
INSERT INTO taq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ăstafăy-asăn i-ad-t-dd-əkfən a făll-iktăb, iktăb-asăn fălla-s: «Isəm-net: Exya.» Ǝqqălăn-dd ăddinăt ɣas oran imawăn. ");
INSERT INTO taq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ămera iləs n-Zăkărya ălwăqq-wen-dăɣ, ad-itamăjrad, itiməl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tărmăs tuksəḍa n-Măssinăɣ ăddinăt-wi əzzăɣnen dăɣ-attayăn-en-dăɣ d-kăl-iḍaɣăn wi n-Ălyăhudəyăt, ad-timsiɣulăn isălan-wi-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ǝṭṭăfăn ăddinăt iket-năsăn wi əslănen a-wa ijăn dăɣ-ulhawăn-năsăn, ăqqimăn-dd ɣas, jannen: «Ak ara-wa-dăɣ, ma mad-umas?» Ara-i, ăsiwăr-t Măssinăɣ ăfuss-net. ");
INSERT INTO taq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zăkărya-i n-ti-s n-alyaḍ, iḍkăr-t Unfas Šăddijăn, ălolăy, inna: ");
INSERT INTO taq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Təmmal i-Emăli-i n-Ămakraš n-Iṣrayil făl-a-s, ənta, ad-dd-iššărjăšăn tamətte-net, ăsdărfʼ-et. ");
INSERT INTO taq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ăsfăqqăt-anăɣ-dd isək n-əlɣəllas dăɣ-ehăn n-akli-net Dawəd. ");
INSERT INTO taq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A-wen ăru tăn-inna Măssinăɣ s-imawăn n-ănnăbităn-net wi n-iməššeddəjăn. ");
INSERT INTO taq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Issəlmăd-anăɣ a-s ad-hanăɣ-agəẓ dăɣ-išənja-nănăɣ, ikkəs-anăɣ dăɣ-ifassăn n-imiksănăn-nănăɣ iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A-wen-dăɣ a făl oḍăn tăhanint i-abbatăn-nanăɣ wi n-ibda, iktă-dd ărkăwăl-net wa n-tassaɣt šăddijăn hasăn-ijjăš. ");
INSERT INTO taq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ămoos a-wen tahuḍe ija i-abba-nănăɣ Ibrahim ");
INSERT INTO taq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a-s has-innă, ad-hanăɣ-agəẓ dăɣ-išənja-nănăɣ, ad-nəzzaɣ jere-săn măšan, wăr tăn-năksuḍ. ");
INSERT INTO taq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A-wen ijʼ-e, i-ad-t-năɣbəd hak ašăl dăɣ-təšədje d-iqqud dăɣ-tuksəḍa-net. ");
INSERT INTO taq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kăyy daɣ i n-rure-ɣ, ad-kăy-iwăr isəm ănnăbi n-Măssinăɣ wa iknăn aḍkul, kăyy a-madăn-izar i-Emăli i-ad-təknəd ibaran-net, ");
INSERT INTO taq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","səlmədăd ăddinăt-net s-əlɣəllas wa t-illăn ɣur-Măssinăɣ i-tenăšše n-ibăkkaḍăn-năsăn ");
INSERT INTO taq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","făl-a-s, Măssinăɣ oḍăn-anăɣ tăhanint. Dăɣ-idəm n-ehăf n-ărrăxmăt-net, ad-hanăɣ-dd-isəssiwəy Ămaɣlas olăhăn d-tăfukt dd-təjammăḍăt išənnawăn ");
INSERT INTO taq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","i-ad-imləwləw ănnur-net făll-ăddinăt wi ăqqimănen dăɣ-tihay, han tele ta n-tamăttant, i-ad-hanăɣ-išărjəš dăɣ-tabarăt ta n-ălxer.» ");
INSERT INTO taq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Idaggăl Exya, tiwwaḍ tayətte-net, izzaɣ tinariwen hundăɣ har ašăl wa t-dd-ăšmašăl Măssinăɣ s-kăl-Iṣrayil. ");
INSERT INTO taq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ăzzăman wa d-ăsiṭăbăl Qăyṣăr Ojărtăn e d t-illăm ămănokal, omăr s-ad-tiḍan tamətte făll-ărori n-ăkall. ");
INSERT INTO taq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tăḍint-ten-dăɣ tăzzarăt, təja dăɣ-ăzzăman wa d-ămoos Kirənyus gəfăr n-teje ta n-Surya. ");
INSERT INTO taq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dăɣ-təssəba n-a-wen-dăɣ innʼ ămănokal wa măqqărăn, a făl hak ăwadəm, iqqăl taɣrəmt-ta dăɣ-iwa i-ad-iḍan. ");
INSERT INTO taq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ifăl-dd Yusəf taɣrəmt ta n-Năṣirăt hăt teje ta n-Galila, ikkă taɣrəmt n-amɣar-net Dawəd ta s-itawănna Bătlehăm hăt teje ta n-Ălyăhudəyăt, ed ahăya n-Dawəd a ămoos, ");
INSERT INTO taq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","i-ad-iḍan ənta d-Măryăma ta n-tămutărt-net-i s-a-s ităjj a-wen-dăɣ, la ənniyăt. ");
INSERT INTO taq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Han taɣrəmt-ten-dăɣ, a-s dd-tosa tăqqăn ta dăɣ-jarrăw Măryăma eɣăf-net. ");
INSERT INTO taq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Təjrăw eɣăf-net, təkrăš teɣăfădde-net, təttăl-t dăɣ-ikăršăyăn, təssənsʼ-e dăɣ-efăyd făl-a-s, ehăn wa n-imăjarăn, ăbas t-iha edăgg. ");
INSERT INTO taq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ăkall-en, han-t imăḍanăn ăssinbărnen irəzzejăn-năsăn dăɣ-isalwan illa-hin i-aɣrəm sihen. ");
INSERT INTO taq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A ənḍărrăn, ibdăd-dd ănjălos n-Măssinăɣ data-săn, ăsmălăwlăw-dd ălxurmăt n-Emăli edăgg wa hăn, əknăn-dăɣ tarəmmeɣt ");
INSERT INTO taq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","măšan, innʼ-asăn ănjălos: «Wăr tărmeɣăm, ənhəywăt, ăwwayăɣ-awăn isălan n-ălxer maden-umas əssəbab n-tedăwit i-tamətte iket-dăɣ-net. ");
INSERT INTO taq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ašăl-i, iwʼ-awăn Ămaɣlas dăɣ-taɣrəmt ta n-ămănokal Dawəd, ənta a-s Ălmasex n-Emăli. ");
INSERT INTO taq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ǝnta da a-wa s-t-mad-təzzəyăm: ad-tənhəyăm ara s-iket iwa, ittal dăɣ-ikăršăyăn, insa dăɣ-efăyd.» ");
INSERT INTO taq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Diha-dăɣ d-issəmdă ănjălos tənna n-a-wen-dăɣ, ad-dd-ăddew abrək n-ănjălosăn timəlnen Măssinăɣ, jannen: ");
INSERT INTO taq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Təmmal i-Măssinăɣ dăɣ-išənnawăn, ălxer ija făll-ărori n-ăkall i-ăddinăt-wi făll-tənsa tărha-net.» ");
INSERT INTO taq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ǝqqălăn ănjălosăn išənnawăn ɣas, ănmănnăn imăḍanăn: «Adiš, năkket Bătlehăm i-ad-nənhəy a-wa ijăn d-a-wa hanăɣ-issəlmăd Emăli.» ");
INSERT INTO taq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ăšwănken ălwăqq-wen-dăɣ, ogăẓăn-in dihen Măryăma d-Yusəf d-ara wa s-iket iwa, insa dăɣ-efăyd. ");
INSERT INTO taq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ǝnhăyăn-t imăḍanăn ɣas, ăssoɣălăn i-ăddinăt a-wa hasăn-ătwănnăn făll-ara wa ənḍărrăn. ");
INSERT INTO taq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ăkunăn ăddinăt iket-năsăn wi əslănen i-a-wa ənnăn imăḍanăn ");
INSERT INTO taq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","măšan, Măryăma-i n-ma-s n-alyaḍ, təṭṭăf isălan-win-dăɣ iket-năsăn dăɣ-iman-net, siməktəw-tăn dăɣ-ulh-net i-ad-təlməd ălmăɣna-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ǝqqălăn imăḍanăn ḍarăt-a-wen, ad-samɣarăn Măssinăɣ, tiimələn-t făl təssəba n-a-wa əslăn d-a-wa ənhăyăn s-əmmək-wa-dăɣ s-hasăn-ătwănna. ");
INSERT INTO taq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ikrăš ara əttam išilan ɣas, ămelăy, jăn-as isəm Ɣisa, isəm wa s-hasăn-innă ănjălos ad-has-t-əjən hărwa wăr-iwa. ");
INSERT INTO taq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dăɣ-isălan n-a-wa tənna Ăṭṭăwrăt ta n-Mosa, ăddew Yusəf d-Măryăma s-ehăn n-ămudd wa măqqărăn ihăn Yărussălam i-ad-šəšdəjăn iman-năsăn, ăwwăyăn daɣ ara i-ad-t-săɣləfăn tărna n-Emăli ");
INSERT INTO taq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","făl-a-s, iktab dăɣ-alămăr n-Emăli a-s: «Alyaḍ n-eyy wa n-teɣăfădde, umaset eməššeddəj n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dăɣ-isălan n-ašəšdaj n-iman-năsăn, lan s-ad-əjən takute n-sănatăt tidăberen dăɣ-ti n-ăroj meɣ daɣ sănatăt măllolnen dăɣ-ti n-aɣrəm ed, a-wen-dăɣ a iktabăn dăɣ-alămăr n-Emăli. ");
INSERT INTO taq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A ənḍărrăn ăhaləs iyyăn da-dăɣ izzaɣăn Yărussălam s-isəm-net Šămɣun. A ija a-wa-dăɣ, ijar ăṭṭăma n-əlɣəllas wa s-inna Măssinăɣ i-Iṣrayil, ăssinsa daɣ Măssinăɣ Unfas Šăddijăn fălla-s. ");
INSERT INTO taq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ăru d-has-dd-ănfalăl Măssinăɣ dăɣ-tăharjit, ijjăš-as ărkăwăl s-tărna n-Unfas Šăddijăn n-a-s wăr mad-ămmăt wăr-inhey Ălmasex n-Emăli. ");
INSERT INTO taq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ašăl-en-dăɣ, imhăl-t-dd Unfas Šăddijăn s-ehăn n-ămudd wa măqqărăn i-ad-imzəyyət d-imărawăn n-Ɣisa ălwăqq wa d-tajjăn a-wa fălla-săn irha ălɣadăt dăɣ-isălan wi n-ihuk-net i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Irmăs-t-dd Šămɣun dăɣ-ifassăn-năsăn, ad-itiməl Măssinăɣ, ijanna: ");
INSERT INTO taq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Emăli! Ămăra, ărməs unfas dăɣ-akli-năk i-ad-igəl dăɣ-ălxer ed, a-wa s-has-tənned, ijă. ");
INSERT INTO taq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ăjjunfănăt tiṭṭawen-in dăɣ-əlɣəllas-năk ");
INSERT INTO taq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wa dd-tăsmăjned i-ăddunya iket-dăɣ-net. ");
INSERT INTO taq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ǝlɣəllas wa s-ənta a-s ănnur i-inəẓẓulam i-ad-hasăn-dd-tənfilələd, ămoos ălxurmăt-năk i-kăl-Iṣrayil-i n-tamətte-năk.» ");
INSERT INTO taq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iqqăl-dd ti-s d-ma-s ɣas tofʼ-en tăkunt n-a-wa itawănnen făll-alyaḍ-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ittăr Šămɣun ḍarăt-a-wen a dăɣ-săn ijăn ălbăraka təzzar, innă i-Măryăma-i n-ma-s: «Alyaḍ-i, ənhəy, ăsnăfrăn-t Măssinăɣ i-ad-umas tebădde d-ejăḍăl i-kăl-Iṣrayil, umas daɣ əssəbab n-tamɣənnant i-ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dăɣ-təssəba-net, ad-dd-iffukkăr a-wa ihăn ulhawăn n-ăddinăt ăjjootnen. Kămm daɣ, ad-ham-umas əssəbab n-uɣšad n-iman olăhăn d-tidij n-tăkoba.» ");
INSERT INTO taq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ăzzăman-en, təllʼ-ee tănnăbit təknat tušăre la tawset ta n-dăgg-Ašir s-isəm-net Hănnătu wălăt Fanwăl. Dăɣ-təmmăḍrit-net, kăla tăt-iḍăs adubən dăɣ-təja əssa iwətyan, ");
INSERT INTO taq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ăbʼ ăhaləs-net ɣas, tăqqiimă-dd, wăr toles adubən, la ămăra-dăɣ a iwwăḍăn əttamăt timərwen n-awătay d-əkkoẓ. A ija a-wen-dăɣ, kăla wăr fel ehăn n-ămudd wa măqqărăn, ehăḍ d-ašăl ɣabbăd Măssinăɣ, tăxdam-as, tuẓam. ");
INSERT INTO taq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ăssaɣăt-wen-dăɣ ad-dd-tosa ənta-dăɣ, ad-tiiməl Măssinăɣ, tajj isălan n-Ɣisa i-ăddinăt iket-năsăn wi jărnen ăṭṭăma n-ad-dd-izəzzubbət Măssinăɣ tădarfit-net făll-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ǝssəmdăn imărawăn n-Ɣisa a-wa fălla-săn ifrăḍ alămăr n-Emăli ɣas, əqqălăn taɣrəmt-năsăn Năṣirăt, dăɣ-teje ta n-Galila. ");
INSERT INTO taq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Idaggăl Ɣisa, itiṣuhut, itəggar-t sărho dăɣ-isălan n-a-wa irha Măssinăɣ făll-ăgg-adəm, ikna daɣ fălla-s Măssinăɣ asəns n-ănnuɣmăt-net. ");
INSERT INTO taq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hak awătay, əkkan imărawăn n-Ɣisa Yărussălam i-ămudd wa n-Faṣka. ");
INSERT INTO taq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ikrăš Ɣisa măraw iwətyan d-əssin ɣas, ăddewăn dăr-s ed, a-wen-dăɣ, a innă ălɣadăt n-ămudd. ");
INSERT INTO taq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ăssakăyăn ămudd dihen ɣas, əqqălăn ihănan-năsăn măšan, ăqqiima-hin Ɣisa ḍara-săn dăɣ-Yărussălam. Wăr t-oḍenăn hundăɣ har hin-əjrăhăn a-s wăr dăr-săn ăddew. ");
INSERT INTO taq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ǝjăn ašăl imdan n-asikəl ija ɣur-săn a-s ăddew d-iməssukal-wi iyyăḍnen dăr-săn ohărnen tabarăt, əjrăhăn-in a-s wăr dăr-săn ăddew ɣas, əqqălăn dăɣ-adăriš-năsăn, ad-has-tammăɣăn ɣur-išăqqaɣăn-năsăn d-imuzăyăn-năsăn ");
INSERT INTO taq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","măšan, ăba-hasăn-t hundăɣ har hin-əwwăḍăn Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Šămad okayăn kăraḍ išilan ad-t-əjrăwăn ăniɣăyma dăɣ-ehăn n-ămudd wa măqqărăn d-ălɣulam n-Ăṭṭăwrăt, ăsijăd-asăn tafăssarăn əlkəttabăn n-Măssinăɣ, isastan-tăn. ");
INSERT INTO taq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ăkunăn ăddinăt iket-dăɣ-năsăn wi sallănen i-a-wa ijănna dăɣ-tayətte-net d-ălwižabăn-net. ");
INSERT INTO taq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ălwăqq wa d-t-ənhăyăn imărawăn-net dihen, ăqqănăn iɣăfawăn-năsăn, tənnʼ-as ma-s: «Alyaḍ-in, ma ămoos a-wa hanăɣ-jed? A ija a-wa-dăɣ, nətammăɣ-ak năkk d-abba-năk ed năɣel asujjəl a jed.» ");
INSERT INTO taq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Innʼ-asăn: «Mafăl hi-tammăɣăm, ajăn wăr təssenăm a-s leɣ s-ad-hi-əšləwăn əššăɣəlăn n-Abba-nin dăɣ-ehăn-net?» ");
INSERT INTO taq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wăr t-illa a əjrahăn dăɣ-a-wa hasăn-innă. ");
INSERT INTO taq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ăddew dăr-săn ḍarăt-a-wen s-Năṣirăt, ăqqim isajăd i-a-wa has-jannen. Təṭṭaf anna-net hărătăn-winnin-dăɣ, wăr tăn-iha-i hin-tatăwa. ");
INSERT INTO taq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Idaggăl Ɣisa dăɣ-eɣăs-net, itisărhut, ijraẓ i-Măssinăɣ hakd dăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Awătay wa s-măraw d-səmmos dăɣ-təmmənukəla n-Qăyṣăr Tibăryus, ămoos Bunəs Bilatəs gəfăr n-teje ta n-Ălyăhudəyăt, ămoos Harudəs ămănokal n-teje ta n-Galila, ăŋŋa-s Fəlibb ăminakăl făll-Tarăkunit d-Ǝyyadurəya, Lisanyas ənta ăminakăl făll-ăkall wa n-Abila. ");
INSERT INTO taq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ăzzăman-en, Hənnan d-Qayăf a ăminakălnen făll-kăl-tikutawen. Išilan-win-dăɣ, ad-imməjrăd Măssinăɣ i-Exya ăgg Zăkărya dăɣ-tenere. ");
INSERT INTO taq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ikkʼ Exya ḍarăt-a-wen ikallăn iket-năsăn wi hănen attayăn n-ejănš wa s-itawănna Ɣurdəni. Ixaṭṭăb, ijanna i-ăddinăt: «Utabăt, tətwəsəlmăɣăm dăɣ-aman i-ad-təjrəwăm tenăšše n-ibăkkaḍăn.» ");
INSERT INTO taq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A-wen-dăɣ išlăn Exya, a iktabăn dăɣ-əlkəttab wa n-ănnăbi Saya ălwăqq wa d-inna dăɣ-s: «Săjdăt, ija emăsli iyyăn ijannen: ‹A-wa emăsli ăssewălăn dăɣ-tenere, ăknăt tabarăt n-Emăli, səssiɣədăt ibaran data-s. ");
INSERT INTO taq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iɣəšran-wi ɣăšnen, ad-ənbəlăn, iḍaɣăn d-ijefăn, ad-aləmən, ibaran-wi ăkrănbăynen, ad-aɣədən, tabarăten-ti ărbăɣrăbăɣnen, ad-agdăhnăt, ");
INSERT INTO taq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","e d t-illăm ăgg-adəm, ad-inhəy əlɣəllas wa dd-ăzzăbbăt Măssinăɣ.› » ");
INSERT INTO taq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Osăn-dd ăddinăt ăjjootnen ărhanen ad-tăn-isəlmăɣ Exya dăɣ aman, innʼ-asăn: «Ya taššălen-i-dăɣ! Wădden tənnăm təmsădăm! Ǝyya, a tărham ad-tətwəsəlmăɣăm i-ad-təfləm daw-ăššăreɣa n-Măssinăɣ wa s-išwar fălla-wăn dd-oḍa. Lăɣătăt-ahi, mi kăwăn-issəlmădăn s-a-wen? ");
INSERT INTO taq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sətbətăm tătubt-năwăn s-imărkedăn, təyyəm fălla-wăn tənna n-a-s əzzurəyăt n-Ibrahim a nămoos ed afăl tăqqăl s-isălan n-əzzurəyăt ɣas, ăyyăt-ahi ad-hawăn-ănnăɣ a-s: Măssinăɣ, ăddoobăt ad-isəmməskəl tihun-ti-dăɣ hannăyăm, ixlək-dd dăɣ-snăt əzzurəyăt i-Ibrahim. ");
INSERT INTO taq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ăjăt ənniyăt făl-a-s emm n-tutăla ăru d-insa făll-ikewăn n-ihəškan, e d t-illăm ahəšk wărăn itirəw aratăn ihʼ-ălfăyda, ad-hin-ăttănkăḍ, itwəjăr-in dăɣ-efew.» ");
INSERT INTO taq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ǝssəstănăn-t ăddinăt wi has-ăsijădnen, ənnăn-as: «Ma s-nəla s-ad-t-năj?» ");
INSERT INTO taq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ăwwežăb-asăn, innʼ-asăn: «Ere dăɣ-wăn ilăn əssin imălsan, ăkfet iyyăn i-wa wărăn ila wălʼ iyyăn, wa ilăn a ikša, ăkfet ere wa t-wărăn ila.» ");
INSERT INTO taq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Osăn-t-dd ḍarăt-a-wen inarmasăn n-tiwse i-ad-tăn-isəlmăɣ dăɣ-aman, ənnăn-as: «Ălɣalim, ma s-nəla s-ad-t-năj?» ");
INSERT INTO taq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Innʼ-asăn: «Wăr tətterăm dăɣ-ăddinăt ar a-wa s-omăr əlxəkum.» ");
INSERT INTO taq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ǝssəstănăn-t əssărdusa, ənnăn-as: «Năkkăneḍ-i-š, ma hanăɣ-iwarăn?» Innʼ-asăn: «Wăr toheɣăm ăwadəm, wăr təssəḍlămăm ăwadəm s-bahu, ăjăt ărramăt dăɣ-timẓal-năwăn.» ");
INSERT INTO taq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ăddinăt iket-dăɣ-năsăn wi əslănen i-a-wa ijănna Exya, jărăn ăṭṭăma, ad-tinməsəstinăn kunta wădden ənta-i-dăɣ a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ăwwežăb-asăn, innʼ-asăn: «Năkk, aman a dăɣ-kăwăn-salmaɣăɣ măšan, ilkam-ahi ăhaləs hi-ijan mijraw wa-dăɣ s-wăr-ănhăjjăɣ wăla-dăɣ d-ad-ăḍəsăɣ issal n-tifădelen-net, ənta ad-kăwăn-isəlmăɣ dăɣ-Unfas Šăddijăn d-efew i-ad-hin-istəb a-wa lăbasăn. ");
INSERT INTO taq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iṭṭaf tesăyt-net ta s-hin-e-izzuzzăr allon-net, isədəw allon wa olăɣăn, ăjʼ-e dăɣ-ejănd-net, irməs ahošăr wa wărăn infa hărăt, ăjʼ-e dăɣ-efew ăhijăljălăn hărkuk.» ");
INSERT INTO taq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ikkʼ Exya dədi, itajj isălan n-ălxer n-Ălənžil-wi-dăɣ, isamătar daɣ ăddinăt s-ălmăɣnatăn ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ăzzăman-en-dăɣ, ad-ăsmăhăḍ Exya făll-ămănokal Harudəs Intibbas dăɣ-isălan n-Hărudəyyas ta n-hănne-s n-ăŋŋa-s Fəlibb dăɣ-s ohăɣ, illăɣăt-as daɣ ibăkkaḍăn ăjjootnen ămešăl săl wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ăssewăḍ Harudəs făll-a-wen-dăɣ iket-net iji n-Exya dăɣ-takărmut. ");
INSERT INTO taq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A-wen-dăɣ iket-net, ija ḍarăt a-s ăssilmăɣ Exya ăddinăt ăjjootnen d-Ɣisa iman-net dăɣ-aman. Ălwăqq wa d-ititwəsəlmeɣ Ɣisa, itəddal Măssinăɣ dihen-dăɣ a-s dd-ămerăn išənnawăn, ");
INSERT INTO taq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ăzzubbăt-dd fălla-s Unfas Šăddijăn dăɣ-ănnuɣ n-tedăbert măllăt, ijmăḍ-dd emăsli išənnawăn, innăn: «Kăyy-i-dăɣ a-s Rure-ɣ wa əkneeɣ tărha, kăyy a dăɣ-ăsriwăn iman-in.» ");
INSERT INTO taq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ila Ɣisa əḍḍəkuḍ n-kăraḍăt timərwen n-awătay a-s issənta ămašal-net, ija ɣur-ăddinăt iket-năsăn wi t-hannăynen a-s rure-s n-Yusəf wa n-ăgg Xali. ");
INSERT INTO taq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Xali ənta, ăgg Mătata, Mătata ăgg Lewi, Lewi ăgg Mălki, Mălki ăgg Yănnay, Yănnay ăgg Yusəf, ");
INSERT INTO taq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusəf ăgg Mătaṣiyas, Mătaṣiyas ăgg Ɣămmosa, Ɣămmosa ăgg Năxwama, Năxwama ăgg Xăšli, Xăšli ăgg Naggay, ");
INSERT INTO taq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggay ăgg Mătti, Mătti ăgg Mătaṣiyas, Mătaṣiyas ăgg Šămɣi, Šămɣi ăgg Yosăx, Yosăx ăgg Yoda, ");
INSERT INTO taq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ăgg Exya, Exya ăgg Ɣisa, Ɣisa ăgg Žărrubabil, Žărrubabil ăgg Ăṣṣălat, Ăṣṣălat ăgg Năyri, ");
INSERT INTO taq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Năyri ăgg Mălki, Mălki ăgg Ăddi, Ăddi ăgg Kosăm, Kosăm ăgg Ălmădăm, Ălmădăm ăgg Err, ");
INSERT INTO taq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Err ăgg Ɣisa, Ɣisa ăgg Ɣəlyazăr, Ɣəlyazăr ăgg Yurim, Yurim ăgg Mătata, Mătata ăgg Lewi, ");
INSERT INTO taq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ăgg Simyon, Simyon ăgg Yăhuda, Yăhuda ăgg Yusəf, Yusəf ăgg Yonăm, Yonăm ăgg Ilyakim, ");
INSERT INTO taq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ilyakim ăgg Mălaya, Mălaya ăgg Măyna, Măyna ăgg Mătata, Mătata ăgg Natan, Natan ăgg Dawəd, ");
INSERT INTO taq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawəd ăgg Isaya, Isaya ăgg Ăɣbăydi, Ăɣbăydi ăgg Boɣaz, Boɣaz ăgg Sala, Sala ăgg Nasun, ");
INSERT INTO taq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasun ăgg Aminădab, Aminădab ăgg Ădmin, Ădmin ăgg Arni, Arni ăgg Xăšrun, Xăšrun ăgg Faris, Faris ăgg Yăhuda, ");
INSERT INTO taq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yăhuda ăgg Yaqub, Yaqub ăgg Isxaqq, Isxaqq ăgg Ibrahim, Ibrahim ăgg Tarăxa, Tarăxa ăgg Naxur, ");
INSERT INTO taq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naxur ăgg Sarux, Sarux ăgg Raggăw, Raggăw ăgg Falăx, Falăx ăgg Ɣăbbir, Ɣăbbir ăgg Salăx, ");
INSERT INTO taq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salăx ăgg Kăynăm, Kăynăm ăgg Arfăɣšad, Arfăɣšad ăgg Săm, Săm ăgg Nox, Nox ăgg Lamăx, ");
INSERT INTO taq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamăx ăgg Mătussaləm, Mătussaləm ăgg Inuk, Inuk ăgg Yarăt, Yarăt ăgg Măxlălyil, Măxlălyil ăgg Kăynăm, ");
INSERT INTO taq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kăynăm ăgg Anuš, Anuš ăgg Šətti, Šətti ăgg Adəm, Adəm ənta, Măssinăɣ a t-dd-ixlăkăn. ");
INSERT INTO taq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A-s dd-ifăl Ɣisa ejănš wa n-Ɣurdəni, iḍkar Unfas Šăddijăn s-ăṣṣahăt. Unfas-en-dăɣ a t-oɣădăn s-tenere. ");
INSERT INTO taq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ijă dihen əkkoẓăt timərwen n-ašăl itižărrub-t Iblis. Tăqqăn-ten-dăɣ, ijʼ-et iket-net wăr t-illa a ikkan emm-net təzzar, ălluẓ. ");
INSERT INTO taq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Osʼ-e hi-dd Iblis, innʼ-as: «Šămad kăyy a-s Rure-s n-Măssinăɣ, amăr i-tăhunt-ta-dăɣ ad-tumas tajəlla.» ");
INSERT INTO taq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ăwwežăb-as Ɣisa, innʼ-as: «Iktab dăɣ-măjrăd n-Măssinăɣ: ‹Tămudre n-ăgg-adəm, wăr təmda făll-tetăte ɣas.› » ");
INSERT INTO taq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iwwăy-t Iblis s-edăgg iknan aḍkul, issəknʼ-e dăɣ-ešăfălli n-tiṭṭ, e d t-illăm əddəwəl iwarăn ărori n-ăkall, ");
INSERT INTO taq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","innʼ-as ămăra: «Ad-kăy-ăkfăɣ tărna d-təmɣăr făll-əddəwəlăn-wi-dăɣ hannăyăd iket-năsăn făl-a-s i-nin, hakkăɣ-tăn daɣ i-ere wa s-ărheɣ, ");
INSERT INTO taq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","a-wen-dăɣ a făl, hakkăɣ-ak-tăn iket-năsăn afăl hi-tăɣbădăd.» ");
INSERT INTO taq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ăwwežăb-as, innʼ-as: «Iktab dăɣ-măjrăd n-Măssinăɣ a-s: ‹Emăli-năk Măssinăɣ a dat-e-tărkăɣăd, ənta ɣas a fălla-k ilan ălɣibadăt.› » ");
INSERT INTO taq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Iwwăy-t Iblis ḍarăt-a-wen s-Yărussălam, issəbdăd-t făll-afălla n-ehăn n-ămudd wa măqqărăn təzzar, innʼ-as: «Šămad kăyy a-s Rure-s n-Măssinăɣ, ăyy iman-năk s-ăkall ed, iktab dăɣ-edăgg iyyăn dăɣ-măjrăd n-Măssinăɣ a-s: ");
INSERT INTO taq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹Ad-dd-išəmmišəl ănjălosăn-net i-ad-kăy-agəẓən dăɣ-ăššar, ");
INSERT INTO taq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","əkbəlăn-kăy dăɣ-ifassăn-năsăn i-ad-wăr hak-răssəl wăla-dăɣ tăhunt tiyyăt ɣas.› » ");
INSERT INTO taq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Innʼ-as Ɣisa: «Iktab dăɣ-măjrăd n-Măssinăɣ a-s: ‹Wăr-e tarməd Emăli-năk Măssinăɣ.› » ");
INSERT INTO taq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ăžžurrăbăt-t Iblis s-a-wa s-ăddobăt iket-net, indăr-as ɣas, ujəj-t, ad-isimăqqul i-ad-săr-s ijrəw taffawt tiyyăt daɣ. ");
INSERT INTO taq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iqqăl Ɣisa ḍarăt-a-wen teje ta n-Galila, toɣad-t tărna n-Unfas Šăddijăn dăɣ-a-wa ităjj, intăj isəm-net dăɣ-teje-ten-dăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Isaɣra ăddinăt dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, ăssiimɣărăn-t ăddinăt iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ifăl Ɣisa dihen, ikkă taɣrəmt ta n-Năṣirăt-i-dăɣ idwăl, ijʼ-e ašăl wa n-əssəbət-i n-tăsonfat, ikkʼ ehăn n-ăddin wa n-kăl-Ălyăhud ed, a-wen-dăɣ a-s izzay ad-t-ăj. ");
INSERT INTO taq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Təddalăn ăddinăt Măssinăɣ dihen-dăɣ a-s ibdăd Ɣisa jere-săn, əkfăn-t əlkəttab wa n-ănnăbi Saya i-ad-hasăn-dăɣ-s iɣăr. Ikkăs-in i-əlkəttab aḍh wa ija təzzar, orʼ-e dăɣ-edăgg wa dăɣ-iktăb: ");
INSERT INTO taq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Insa făll-i Unfas n-Emăli, ăsnăfrănăn-ahi i-ad-ăjăɣ isălan n-Ălənžil i-tilăqqiwen, ăšmašăl-ahi-dd i-ad-ăjăɣ isălan i-wi hănen tikărmuten, əjrəwăn iman-năsăn, zuzəyăɣ iməddorɣal, səddărfeɣ ăddinăt-wi ătiwăkrăšnen, ");
INSERT INTO taq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","zəzzubbeɣ-dd awătay n-ănnuɣmăt n-Emăli făll-ărori n-ăkall.» ");
INSERT INTO taq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Issəmdă Ɣisa teɣăre ɣas, iɣfăl əlkəttab, ăssoɣăl-t i-ănaxdim-wa ijăn ənniyăt i-ehăn wa n-ăddin. Iqqăl-dd, ăqqima ɣas, ăsbălalăɣăn dăɣ-s ăddinăt-wi hănen ehăn n-ăddin-en-dăɣ iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iḍkăl măjrăd, innʼ-asăn: «Măjrăd wa s-təslăm ašăl-i-dăɣ, itbăt.» ");
INSERT INTO taq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ǝqqălăn-dd ɣas oran imawăn, tofʼ-en tăkunt n-tihusay n-iməjridăn wi dd-zajjărnen emm-net, ad-jannen: «Ak ajăn a-wa wădden ăgg-Yusəf wa-dăɣ nəzzăy?» ");
INSERT INTO taq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Innʼ-asăn Ɣisa: «Ǝssanăɣ a-s ad-hi-dd-səktəwăm oẓẓ wa innăn: ‹Lăxtur, kăyy-ak səssəfăr i-iman-năkk təzzar›, tənnəm-ahi: ‹Təmmaẓ jed dăɣ-ăkall-năk a-wa s-nəsla jed-t dăɣ-aɣrəm wa n-Qăfărnaxum.› » ");
INSERT INTO taq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Innʼ-asăn daɣ: «Tidət-dăɣ a-s wăr t-illa ănnăbi ătiwăqbălăn dăɣ-ăkall-net. ");
INSERT INTO taq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ăsidătteɣ-awăn a-s kăla t-əllănăt tinuḍăfen ăjjootnen dăɣ-Iṣrayil dăɣ-ăzzăman wa n-ănnăbi Ɣəli. Ăzzăman-en, oɣăy mănna i-ăddinăt, jăn kăraḍ iwətyan d-săḍis orăn wăr t-təlla teddamt n-ajənna watăt ăkall-en-dăɣ, ija laẓ s-kăla wăr-ătwănhăy a dăr-olăh făll-ărori n-ăkall. ");
INSERT INTO taq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ija a-wen iket-net măšan, wăr dd-ăšmašăl Măssinăɣ ănnăbi Ɣəli ar s-tănuḍăft tiyyăt ɣas dăɣ-snăt təzzaɣăt taɣrəmt ta n-Sarăfta dăɣ-teje ta n-Săyda. ");
INSERT INTO taq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ḍarăt Ɣəli daɣ, osă-dd ăzzăman wa n-ănnăbi Ilyas. Ăzzăman-en, əllan-t ăddinăt ăjjootnen dăɣ-ăkall wa n-Iṣrayil ijraw jəri măšan, wăr tăn-iha-i s-dd-ăšimašăl Măssinăɣ Ilyas a săl ăhaləs iyyăn n-amăjar ilʼ ăkall wa n-Surya s-isəm-net Năɣma i-ad-t-išəšdəj.» ");
INSERT INTO taq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ǝslăn ăddinăt i-hărătăn-win-dăɣ hasăn-innă dăɣ-ehăn n-ăddin ɣas, kăfăn a-wa-dăɣ hasăn-ija aḍkăr-net, ");
INSERT INTO taq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ămẓăyẓăyăn-t iket-năsăn, əzzəwen-t hundăɣ har afălla n-aḍaɣ wa făll-idăy aɣrəm i-ad-t-in-səttərəkken, ămmăt ");
INSERT INTO taq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","măšan, ikka Ɣisa jere-săn, iglă. ");
INSERT INTO taq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ătrară-dd Ɣisa ḍarăt-a-wen, ikka taɣrəmt ta n-Qăfărnaxum hăt teje ta n-Galila ad-isaɣra dihen ăddinăt hak ašăl n-əssəbət-i n-tăsonfat; ");
INSERT INTO taq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","əqqălăn-dd ăddinăt ɣas oran imawăn făll-əjjăruẓăt-i-dăɣ hasăn-ija a-wa isăɣra ed isaɣrʼ-en s-ălxikmăt ăṣṣohen. ");
INSERT INTO taq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ehăn n-ăddin-en, ihʼ-e ăhaləs ihʼ alšin, inhăy Ɣisa ɣas, ad-isaɣărat s-afălla, ijanna ");
INSERT INTO taq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ya Ɣisa wa n-Năṣirăt, ma dăɣ-năɣ tărhed? Ajăn ahălak-nănăɣ a-s dd-tosed? Ǝssanăɣ ere wa tămoosăd, kăyy-i-dăɣ a-s: Wa Šăddijăn dd-ăšmašăl Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ăsmăhăḍ dăɣ-s Ɣisa, innʼ-as «Ǝṭṭəf emm-năk, təzjărăd ăhaləs-i-dăɣ!» Ijjăḍlăt alšin ăhaləs jer-ăddinăt təzzar, izjăr-t, wăr t-illa a has-iɣšad. ");
INSERT INTO taq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ǝqqălăn-dd ăddinăt ɣas oran imawăn, tinmənnin: «Ma ămoos măjrăd wa? Wa ənta wălʼ alšinăn e-d fălla-săn ăsmăhăḍ s-tărna-net, ad-əzjărăn ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Intăj isəm n-Ɣisa ḍarăt-a-wen-dăɣ, wăr t-illa edăgg dăɣ-teje-ten-dăɣ s-wădden timsiɣulăn dăɣ-s isălan-net. ");
INSERT INTO taq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Izjăr Ɣisa ehăn wa n-ăddin ɣas, ikka ɣur-Simyon. Ămzăyyăt-in d-a-s tărmas tenăde tăṣṣoohet taḍăggalt n-Simyon, əttărăn dăɣ-s ăddinăt ad-tăt-izuzəy. ");
INSERT INTO taq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ibdăd-dd Ɣisa jənnəj-s, ăsmăhăḍ făll-tenăde, tărẓa fălla-s. Tənkăr-dd ălwăqq-wen-dăɣ, ad-tăn-simjurut. ");
INSERT INTO taq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Toḍa tăfukt ɣas, ămewăyăn-dd săr-s imarhinăn s-hak iyyăn d-turhənna-net i-ad-tăn-izuzəy, ăswăr hak iyyăn ifassăn-net, ăzozăy-tăn. ");
INSERT INTO taq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Zajjărăn alšinăn ăddinăt ăjjootnen, saɣăren, jannen: «Kăyy a-s Rure-s n-Măssinăɣ» măšan, isamăhaḍ fălla-săn, wăr tăn-itəyy ămmijrădăn ed, əssanăn a-s ənta a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ăffăw ɣas, ikka Ɣisa tenere n-iman-net măšan təmmăɣ-as tamətte hăr t-təjrăw, ad-tattărăn ăddinăt əmmək s-t-əṭṭăfăn edes-hasăn i-ad-wăr-ilkem ad-tăn-ifal; ");
INSERT INTO taq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","inhăy tayətte-năsăn ɣas, innʼ-asăn: «Iwar-ahi ad-ăxṭəbăɣ isălan n-ălxer n-Təmmənəya n-Măssinăɣ i-iɣărman-wi iyyăḍnen əntăneḍ-dăɣ ed a-wen-dăɣ a-s dd-ămešălăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ad-ixaṭṭăb ḍarăt-a-wen dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud n-teje ta n-Ălyăhudəyăt. ");
INSERT INTO taq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ašăl iyyăn d-ibdad Ɣisa dăɣ-asălim n-ejănš wa n-Žănnăṣarăt, tăɣlăyɣălăy-t-dd tamətte tăjjeet tărhat ad-səjəd i-măjrăd n-Măssinăɣ wa ităjj. ");
INSERT INTO taq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Inhăy sănatăt turfen n-aman ojaynen s-ăqqiimăn məssaw-snăt dăɣ-asălim n-aman, saradăn titarren-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ijjăš dăɣ-snăt ta n-Simyon, ittăr dăɣ-s ad-has-tăt-in-imhəl hundăɣ har təfəl asălim n-aman, ăqqima dăɣ-s, ad-isaɣra tamətte. ");
INSERT INTO taq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Issəmdă măjrăd ɣas, inna i-Simyon: «Səgləw turăft-năk hundăɣ har ammas n-aman, təjrəd kăyy d-imidiwăn-nak titarren-năwăn.» ");
INSERT INTO taq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Innʼ-as Simyon: «Ălɣalim, ehăḍ imdan a nəja nəšɣal wăr t-illa a nărmas măšan, făl tənna-năk, ad-nəjăr titarren-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jăn a-wa hasăn-innă, ărmăsăn-dd ašăl-en-dăɣ imănan-i-dăɣ ăjjootnen har dd-ăqqălnăt titarren-năsăn, təssarnăt. ");
INSERT INTO taq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ad-tallăfăn i-imidiwăn-năsăn wi hănen turăft-ta iyyăḍăt i-ad-dd-ašələn, ilalăn-asăn. Osăn-dd, əḍnăyăn turfen-năsăn tissənen hundăɣ har-dăɣ tilkəyyitnăt. ");
INSERT INTO taq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Inhăy Simyon Bəṭrus a-wa ijăn ɣas, irkăɣ dat-Ɣisa, innʼ-as: «Emăli, ajəj-ahi făl-a-s năkk anăsbăkkaḍ a ămoosăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tărmăs tarəmmeɣt-i-dăɣ măqqărăt Simyon d-imidiwăn-net făl təssəba n-əjut n-imănan-i-dăɣ ărmăsăn. ");
INSERT INTO taq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tăkunt-ta tărmăsăt Simyon, ənta daɣ a tărmăsăt Yaqub d-Exya wi n-dăgg-Zăbdi-i dăr-ohăr ălxidmăt. Innă Ɣisa i-Simyon ḍarăt-a-wen: «Wăr tărmeɣăd, ɣur-ašăl-i-dăɣ, ad-tumasăd ăwadəm săr-i dd-isadawăn ăddinăt i-ad-tăn-ăɣləsăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ăssoɣălăn-dd ḍarăt-a-wen turfen-năsăn asălim n-aman, oyyăn a-wa tăn-išlăn iket-net, əlkămăn-as. ");
INSERT INTO taq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iha Ɣisa iyyăn dăɣ-iɣărman a-s t-inhăy ăhaləs ilsa jəri, ikkʼ-e-hi-dd, irkăɣ data-s, ad-t-ilaqqăd, ijannʼ-as: «Ălɣalim, afăl tărhed a-wen-dăɣ, tăddoobed ad-hi-šəšdəjăd.» ");
INSERT INTO taq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iẓẓăl Ɣisa ăfuss-net, iḍăs-t, innʼ-as: «Ărheeɣ a-wen, išdaj», ifăl-t jəri ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ăsmătăr-t Ɣisa, innʼ-as: «Wăr jed isălan i-ăwadəm wălʼ iyyăn n-a-s năkk a kăy-ăzozăyăn; ănn-ak, əgləw, səkən iman-năk i-u-tikutawen, təjəd takute ta n-təšədje s-ălmăɣna wa s-tăn-innă alămăr wa n-ănnăbi Mosa i-ad-hasăn-umas a-wen tajuhe n-a-s təzzăyăd.» ");
INSERT INTO taq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hak ašăl tiwwaḍ-dd terše n-isəm i-Ɣisa, tidaw-dd săr-s tamətte tăjjeet i-ad-səjəd i-isălan n-Ălənžil, təzzəy dăɣ-turhənnawen-net. ");
INSERT INTO taq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Măšan Ɣisa ənta, ăssoof edăgg iṣtarăn dăɣ-ijraw s-tamădilt n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ijraw Ɣisa ɣur-Emăli tărna tăṣṣoohet ăssitbăt azuzi wa ităjj i-ăddinăt. Ašăl iyyăn d-isaɣra, ăqqiimăn edes-has kăl-faris d-ălɣulam n-Ăṭṭăwrăt dd-falnen tidbi n-Galila d-Ălyăhudəyăt d-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A ənḍărrăn meddən iyyăḍ-da-dăɣ ămisawăyăn anăbdon insan făll-asəftăɣ. Ǝttărăn a-wa dăɣ-he-əjən ərəsăn tamətte, sənsən-t dat-Ɣisa ");
INSERT INTO taq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","măšan, ăba-hasăn ălmăɣna n-a-wen făl əjut-i-dăɣ ja tamətte. Ăɣlăyăn, ăwwănăn afălla n-ehăn, sărăn dăɣ-assətax n-ehăn edăgg s-ăddooben ad-săr-s dd-šujəšăn anăbdon, ăstărarăn-t-dd ḍarăt-a-wen har t-dd-əssənsăn dăɣ-ammas n-tamətte, dat-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Inhăy Ɣisa immun-năsăn ɣas, innă: «Ăhaləs, ătwănšăn-ak ibăkkaḍăn-năk.» ");
INSERT INTO taq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ǝslăn ălɣulam n-Ăṭṭăwrăt d-kăl-faris i-a-wen ɣas, ad-jannen dăɣ-iman-năsăn: «Ma ămoos wa ăwadəm isikuforăn s-əmmək-wa-dăɣ? Mi ăddoben tenăšše n-ibăkkaḍăn săl Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ilmăd Ɣisa ɣur-iman-net a-wa ămiɣănnănăn ulhawăn-năsăn, innʼ-asăn: «Ma tămmizăɣăm dăɣ-ulhawăn-năwăn? ");
INSERT INTO taq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma ojărăn tărăɣse jer-ad-tənnəd i-ăwadəm: ‹Ătwănšăn-ak ibăkkaḍăn-năk› d-ad-has-tənnəd: ‹Ǝbdəd, ărjəš.› ");
INSERT INTO taq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ašăl-i, ăssiilmădăɣ-kăwăn a-s Ăgg-ăgg-adəm, ijraw făll-ărori n-ăkall turhajăt n-tenăšše n-ibăkkaḍăn.» Inna ḍarăt-a-wen i-anăbdon: «Ǝnneɣ-ak, əbdəd, əḍkəl asəftăɣ-năk, əqqəl ehăn-năk.» ");
INSERT INTO taq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ibdăd anăbdon ăssaɣăt-wen-dăɣ dat-ăddinăt iket-năsăn, iḍkăl asəftăɣ-net, iqqăl ehăn-net itiməl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ăqqiimăn-dd ăddinăt ɣas tofʼ-en tăkunt n-a-wa ijăn, tiimlən Măssinăɣ. Təjʼ-asăn tarəmmeɣt arămas wa-dăɣ făl jannen: «Ašăl-i, iman-net, nənhăy hărătăn ăqqannen eɣăf.» ");
INSERT INTO taq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ifăl Ɣisa edăgg-en ɣas, inhăy ăhaləs irammăsăn tiwse s-isəm-net Lewi, ăqqiima dăɣ-edăgg n-ălxidmăt-net, innʼ-as: «Ǝlkəm-ahi.» ");
INSERT INTO taq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ibdăd Lewi, ibḍă d-a-wa t-išlăn iket-net, ilkăm-as. ");
INSERT INTO taq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ăsmăjarăt Lewi Ɣisa ḍarăt-a-wen s-ehăn-net. Itaɣăyma Ɣisa dăɣ-edăgg wa n-imənsiwăn a-s erk ăddinăt han inarmasăn n-tiwse ăjjootnen da-dăɣ, osăn-dd, ănɣăymăn dăr-s ənta d-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ǝnhăyăn kăl-faris d-ălɣulam n-Ăṭṭăwrăt a-wen ɣas, ămjănjănăn jer-iman-năsăn ad-jannen i-inəṭṭulab-net: «Mafăl tattăm, sassăm, tihrəm ikassăn d-inarmasăn n-tiwse d-erk ăddinăt?» ");
INSERT INTO taq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ăwwežăb-asăn, innʼ-asăn: «Ăddinăt ăssoxătnen, wăr-ămɣatărăn s-lăxtur, imarhinăn a săr-s ămiɣatărnen; ");
INSERT INTO taq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","năkk, wăr dd-ămešălăɣ s-ăddinăt-wi ordănen iman-năsăn iqqud, inăsbăkkaḍăn a-s dd-ămešălăɣ i-ad-utabăn.» ");
INSERT INTO taq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ǝnnăn-as ḍarăt-a-wen: «Inəṭṭulab wi n-Exya hakd-dăɣ kăl-faris, hărkuk tuẓamăn, tumadăn măšan, wi-năk əntăneḍ, tattăn, sassăn.» ");
INSERT INTO taq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Issăɣlăy-tăn tangalt dăɣ-hasăn-inna: «Kăl-tuksest, wăr tăn-ilzem ăẓum a ikka ămaẓlay illʼ-e ɣur-săn ");
INSERT INTO taq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","măšan, ilkam ad-dd-ass ăzzăman-wa tăn-mad-ifəl ămaẓlay, ăzzăman-en, ad-uẓamăn.» ");
INSERT INTO taq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ijʼ-asăn Ɣisa tangalt tiyyăt dăɣ-hasăn-innă: «Wăr t-illa ere dd-isaɣărrawen tikəst dăɣ-erăswăy ăynayăn i-ad-săr-s isəmməkukəs i wăššărăn ed, afăl ija a-wen, ad-dd-isăqqərriwət erăswăy wa ăynayăn bănnan, ḍarăt-a-wen daɣ, tabdoɣt-ta tăynayăt, wăr mad-talăh d-ta wăššărăt ini. ");
INSERT INTO taq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wăr t-illa daɣ ere itajjăn aman n-lăɣnăb ăynaynen ăxxiimmărnen dăɣ-ijdad, ere ijăn a-wen har kăfăn aman ənnin ăynaynen dăɣ-ijdad, ad-has-səbbuqqen ijdad-net, ifut ḍarăt-a-wen dăɣ-aman hakd-dăɣ dăɣ-ijdad. ");
INSERT INTO taq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aman n-lăɣnăb ăynaynen ăxxiimmărnen, iddidăn ăynaynen a dăɣ-tăn-itajj ăwadəm. ");
INSERT INTO taq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ăwadəm daɣ wa iswăn aman n-lăɣnăb s-ăru d-ăxximmărăn, ăbas ăsidărhăn tesăse n-wi ăynaynen ed ad-ănn: ‹Wi s-ăru d-əxxəmărăn a ăẓednen.› » ");
INSERT INTO taq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ašăl iyyăn n-əssəbət-i n-ašăl wa n-tăsonfat, ălliil Ɣisa išəkraš n-ălkăma, əlkamăn-as inəṭṭulab-net, nakkăḍăn tiɣăɣănen n-ălkăma, tifəffərun-tănăt jer-ifassăn-năsăn, taffăẓăn tiblalen-ti tănăt-dd-zajjărnen. ");
INSERT INTO taq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ǝggădăn-dd hărăt dăɣ-kăl-faris tăn-hannăynen, ənnăn-asăn: «Mafăl tajjăm a wărăn itətwəjj dăɣ-ašăl wa n-əssəbət-i n-tăsonfat?» ");
INSERT INTO taq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ăwwežăb-asăn Ɣisa, innʼ-asăn: «Adiš kăwăneḍ, wăr tăɣrem dăɣ-əlkəttab a-wa ija Dawəd ašăl wa d-ălluẓ ənta d-ejhăn-net? ");
INSERT INTO taq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wădden ătwănnă, ijjăš ehăn n-Măssinăɣ, iḍkăl dăɣ-tijəlwen ti n-tikutawen s-wăr t-illa ere s-xălal tetăte-năsnăt săl kăl-tikutawen măšan, ənta, ikšʼ-enăt, ikfă dăɣ-snăt daɣ imidiwăn-net wi dăr-ăddew.» ");
INSERT INTO taq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Ăgg-ăgg-adəm a ănnihăḍăn dăɣ-a-wa s-ila ăgg-adəm d-a-wa s-wăr ila s-ad-t-ăj dăɣ-ašăl wa n-əssəbət-i n-tăsonfat.» ");
INSERT INTO taq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Iqqăl-dd əssəbət-i n-ašăl wa n-tăsonfat ɣas, ijjăš Ɣisa ehăn n-ăddin wa n-kăl-Ălyăhud ad-dăɣ-s isaɣra. Ehăn-en, ihʼ-e ăhaləs s-ăqqur ăfuss-net wa n-aɣil. ");
INSERT INTO taq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jan-as ălɣulam n-Ăṭṭăwrăt d-kăl-faris ənniyăt, tassănăn ihăl ad-t-izuzəy dăɣ-ašăl wa n-əssəbət-i n-tăsonfat meɣ i-ad-t-səḍləmăn. ");
INSERT INTO taq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ilmăd Ɣisa ɣur-iman-net a-wa dăɣ-zinəzjumăn, innă i-ăhaləs wa s-ăqqur ăfuss-net: «Ǝyyăw, əbdəd dăɣ-ammas n-ălžămaɣăt.» Inkăr-dd ăhaləs, ibdăd diha s-has-innă. ");
INSERT INTO taq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Ăssiistănăɣ-kăwăn: Ak a xălalăn dăɣ-ašăl wa n-əssəbət-i n-tăsonfat iji n-emărked meɣ iji n-a lăbasăn, igguẓ n-iman meɣ iji n-iman?» ");
INSERT INTO taq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Issăɣlăy-tăn-dd Ɣisa asăwaḍ-net iket-dăɣ-năsăn təzzar, innă i-ăhaləs: «Ǝẓẓəl ăfuss-năk.» Ija a-wa has-innă, izzăy ăfuss-net ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ija a-wen ɣas, wăsăn kăl-ăddin, ănmănhăyăn jer-iman-năsăn dăɣ-isălan n-a-wa he-əjən i-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Išilan-win-dăɣ ad-iwwăn Ɣisa taḍaɣt, ikkăs dihen ehăḍ imdan, itəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ăffăw ɣas, iɣră-dd inəṭṭulab-net, ăsnăfrăn dăɣ-săn măraw d-əssin, ăswăr-tăn isəm inəmmušal. ");
INSERT INTO taq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ǝntăneḍ da inəṭṭulab-wi ăsnăfrăn: Simyon wa s-ija isəm Bəṭrus d-ăŋŋa-s Idris; Yaqub d-Exya, Fəlibb d-Bărtălămma, ");
INSERT INTO taq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mătti d-Tomi; Yaqub wa n-ăgg Ălfa d-Simyon wa s-itawănna ăššažeɣ, ");
INSERT INTO taq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Hudd ăgg Yaqub d-Yăhudəs wa n-Isxaryut-i ămoosăn ămaɣdar. ");
INSERT INTO taq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ăzzubbăt-dd Ɣisa taḍaɣt ḍarăt-a-wen ənta d-inəṭṭulab-net, ătrarăn-dd făll-eɣărɣăr dăɣ-təbdad tamətte tăjjeet d-ăddinăt ăjjootnen dd-falnen Ălyăhudəyăt d-Yărussălam d-iɣărman wi n-Tir d-Săyda hănen asălim n-ejănš. ");
INSERT INTO taq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ăddinăt-en-dăɣ, osăn-dd iket-dăɣ-năsăn i-ad-səjdən i-a-wa isaɣra, əzzəyăn dăɣ-turhənnawen-năsăn, əjrəwăn dăɣ-săn wi hăn alšinăn iman-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tattăr taxləkt-ten-dăɣ iket-net ad-t-təḍəs ed zajjăr-t-dd tărna tăn-zizuyăt iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iswăḍ Ɣisa dăɣ-inəṭṭulab-net, innă: «Tənḍəḍ-awăn kăwăneḍ-i ăẓoẓnen iman-năwăn dat-Măssinăɣ ed, Təmmənəya n-Măssinăɣ, ti-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tənḍəḍ-awăn kăwăneḍ-i inăqq laẓ ašăl-i-dăɣ ed, ad-tăyyăwănăm; tənḍəḍ-awăn kăwăneḍ-i hallănen ašăl-i-dăɣ ed, ad-tăddăwem. ");
INSERT INTO taq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tənḍəḍ-awăn afăl dăr-wăn okăḍăn dăgg-adəm, afăl kăwăn-əkkăsăn jer-iman-năsăn; afăl kăwăn-gaggărăn; afăl əttărăn uɣšad n-ismawăn-năwăn dăɣ-ăddimmăt n-Ăgg-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dăwătăt, taləwəm dăɣ-ašăl-wen-dăɣ făl-a-s ad-ijat marušăt-năwăn dăɣ-ălžănnăt; erk ălxal-wen-dăɣ hawăn-han ašăl-i-dăɣ, a əjjăšăn abbatăn-năsăn i-ănnăbităn.» ");
INSERT INTO taq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Iməskay kăwăneḍ-i n-imărrəzăɣăn ed, ălxer-năwăn, ihʼ ifassăn-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Iməskay kăwăneḍ-i n-imăyyăwănăn n-ašăl-i-dăɣ ed, ad-tulaẓăm. Iməskay kăwăneḍ-i daẓẓănen ašăl-i-dăɣ ed, ad-təṭṭəfăm iba, təlhəm. ");
INSERT INTO taq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iməskay kăwăneḍ-i timələn ăddinăt ed, ălxal-wen-dăɣ a əjjăšăn abbatăn-năsăn i-ănnăbităn wi n-bahu n-ibda.» ");
INSERT INTO taq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kăwăneḍ-i hi-ăsijădnen, ənneɣ-awăn: Ărhăt išənja-năwăn, ăjăt a olaɣăn i-ăddinăt-wi dăr-wăn okăḍnen, ");
INSERT INTO taq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ăjăt ălhimmăt i-wi hawăn-ărhanen a lăbasăn, ădəlăt Măssinăɣ i-wi fălla-wăn jannănen bahu. ");
INSERT INTO taq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Afăl hak-istăɣ ăwadəm făll-tăjomăst-năk tiyyăt, səgdəl-as daɣ ta iyyăḍăt; afăl irmăs ăwadəm tanăkkăbbat-năk, ăkfʼ-e daɣ anăkăbba-năk. ");
INSERT INTO taq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ere kăy-idălăn-dăɣ, ăkfʼ-e; wăr tətterăd dăɣ-ăwadəm ad-hak-isuɣəl a-wa dăɣ-k irmăs. ");
INSERT INTO taq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A-wa s-tărhăm, ad-hawăn-t tajjăn ăddinăt, ăjăt-asăn-t kăwăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Afăl wăr tărhem ar imărhan-năwăn, əndek marušăt-năwăn? Wădden, inăsbăkkaḍăn-dăɣ, ărhan ăddinăt wi tăn-ărhanen. ");
INSERT INTO taq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Afăl wăr təjjəm a olaɣăn ar i-wi hawăn-t-tajjănen, əndek irhuj-năwăn? Wădden, wălʼ inăsbăkkaḍăn, a-wen, tajjăn-t. ");
INSERT INTO taq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Afăl daɣ wăr səmərwisăm ar i-ăddinăt wi dăɣ-tordăm timẓal, əndek marušăt wa s-mad-təjrəm ăṭṭăma-net? Wădden, inăsbăkkaḍăn-dăɣ, samărwasăn i-imidiwăn-năsăn ed, ordan ɣur-săn azăbăna. ");
INSERT INTO taq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ărhăt išənja-năwăn, tajjăt-asăn a olaɣăn; səmmərwəsăt i-ere dăɣ-wăr jerăm ăṭṭăma n-timẓal. Dihen, ad-ijat marušăt-năwăn, tumasăm aratăn n-Măssinăɣ wa iknan aḍkul ed, ənta, milɣaw-net, wăr săr-s iẓley wi wăr ha tămayit hakd-dăɣ wi n-inăllăbăsăn. ");
INSERT INTO taq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Təjjəšet-kăwăn təmɣăre n-tăhanint ta hăt Abba-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Afăl wăr tənnem dăɣ-ăwadəm, wăr mad-dăɣ-wăn ănn ăwadəm, afăl wăr təssəḍlămăm ăwadəm, wăr kăwăn-e-isəḍləm ăwadəm, naššăt i-ad-təjrəwăm tenăšše. ");
INSERT INTO taq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ăkfăt, ad-təjrəwăm; ere wa ihakkăn, ad-ijrəw a ăjjeen dăɣ-asəbbətăr-net ed, ilkam ad-hanăɣ-ikət Măssinăɣ isuf-net s-əmmək wa s-nətəkkat isuf-nănăɣ i-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Issăɣlăy-tăn-dd Ɣisa tangalt dăɣ-hasăn-inna: «Ajăn emədderɣəl ăddoobăt ad-ilwəy emədderɣəl? Wădden, ad-iḍwən issənăn-essăn dăɣ-anu? ");
INSERT INTO taq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wăr t-illa ănăṭṭalib ojărăn ălɣalim-net măšan, ănăṭṭalib iket-net iɣradăn, ad-alăh d-ălɣalim-net. ");
INSERT INTO taq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Uhən kăyy, mafăl hannăyăd teẓewt ta hăt tiṭṭ n-ăŋŋa-k, a-s ija a-wen, wăr hənnəyăd afăɣot wa ihăn tiṭṭ ta-năk? ");
INSERT INTO taq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Meɣ daɣ, əndek əmmək wa s-mad-tənnəd i-ăŋŋa-k: ‹Ăyy-ahi ad-hak-əkkəsăɣ teẓewt dăɣ-tiṭṭ-năk›, a-s ija a-wen, kăyy iman-năk, iha afăɣot tiṭṭ ta-năk. Ălmunafeɣ! Ǝkkəs-in afăɣot wa ihăn tiṭṭ-năk təzzar i-ad-tudabed ahănay d-ukəs n-teẓewt ta hăt tiṭṭ n-ăŋŋa-k.» ");
INSERT INTO taq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Wăr t-illa ahəšk olaɣăn itiirəwən aratăn lăbasnen, wăr t-illa daɣ erk ahəšk itiirəwən aratăn olaɣnen. ");
INSERT INTO taq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hak ahəšk-dăɣ aratăn-net a-s ititwəzziy. Wăr mad-dd-təkkəsăd ara n-ašar făll-ewărwăr, wăr mad-təkkəsăd daɣ lăɣnăb făll-tahəjjart. ");
INSERT INTO taq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ăwadəm-wa olăɣăn, milɣaw n-ulh-net a dăɣ-dd-itakkăs a-wa olăɣăn măšan, enăllăbăs ənta, tăllăbăst n-ulh-net a dăɣ-dd-itakkăs a-wa lăbasăn ed, a-wa iḍkărăn ulh n-ăgg-adəm a dăɣ-itamăjrad emm-net.» ");
INSERT INTO taq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Mafăl hi-jannem: ‹Emăli, Emăli!› a-s ija a-wen, wăr təjjəm a-wa hawăn-janneɣ. ");
INSERT INTO taq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ere hi-dd-ikkăn-dăɣ, ăsjăd i-măjrăd-in, ad-itamašal a-wa ənneɣ, ad-kăwăn-săknăɣ ere wa dăr-olăh. ");
INSERT INTO taq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Olăh d-ăwadəm itəddayăn ehăn, iɣăš ăssas-net har iwwăḍ tăhunt, idăy fălla-s. Ijʼ akăsa, ijʼ anji ăṣṣoohen, inkăf i-taɣăšamt siha d-siha măšan, wăr tăt-ăsmăramăr ed, təknʼ ăntum dăɣ-ăkall ");
INSERT INTO taq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","măšan ere wa islăn i-măjrăd-in wăr has-ăsjăd, olăh d-ere idăyăn ehăn-net făll-tasənjit wărăt la ăssas, osă-dd anji, inkăf i-ehăn, immăr-t-in s-iyyăt, ijʼ-as tenăde təmdat.» ");
INSERT INTO taq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Issəsla Ɣisa isălan-win-dăɣ i-tamətte ɣas, ijjăš aɣrəm wa n-Qăfărnaxum. ");
INSERT INTO taq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Illʼ-e dihen kăbtăn ilan akli ikna tărha-i s-a-s ităjj a-wen-dăɣ ija turhənna ta-dăɣ s-išwar hin-ăssijja. ");
INSERT INTO taq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Islă kăbtăn a-s dd-ijjaš Ɣisa ăkall ɣas, ăšmašăl săr-s hărăt dăɣ-inušămăn n-kăl-Ălyăhud i-ad-dăɣ-s əttărăn ad-dd-ass, izuzəy akli-net. ");
INSERT INTO taq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Osăn-dd kăl-Ălyăhud Ɣisa, dălăn-t dăɣ-ad-t-izuzəy, ənnăn-as: «Ăhaləs-i-dăɣ, ăniihăjja s-ad-has-təkkəsăd tekăriḍt, ");
INSERT INTO taq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","irha tumast-nănăɣ hullan, ənta a hanăɣ-issəkrăsăn ehăn n-ăddin wa nəla.» ");
INSERT INTO taq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ăddew dăr-săn Ɣisa. Wăr-ujəj a-s has-dd-əlkăḍăn imidiwăn n-kăbtăn dd-ăšimašăl, ənnăn-as: Innʼ-ak kăbtăn: «Ălɣalim! Wăr tăslăyyăɣăd iman-năk făl-a-s, wăr-ănhăjjăɣ d-ad-dd-təjjəšăd ehăn-in, ");
INSERT INTO taq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","a-wen-dăɣ daɣ a făl wăr-ăsnăhăjjăɣ iman-in d-ad-kăy-in-ăkkăɣ, ănn tiyyăt tăfert, ad-izzəy ănaxdim-in. ");
INSERT INTO taq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Năkk, əllan-t imănokalăn jənnəj-i, leɣ daɣ năkk əssărdusa daw-i t-əllanen, e-d ənnəɣ i-iyyăn: ‹Ǝgləw›, ad-igləw, e-d ənnəɣ i-wa iyyăḍăn: ‹Ǝyyăw›, ad-hi-dd-ass; akli-nin daɣ, e-d has-ənneɣ: ‹Ăj a-wa›, ad-t-ăj.» ");
INSERT INTO taq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Islă Ɣisa i-a-wen ɣas, ijrăẓ-as kăbtăn, innăḍ-dd s-ăddinăt wi has-əlkămnen, innʼ-asăn: «Ăsidătteɣ-awăn a-s wăla dăɣ-ăkall wa n-Iṣrayil, wăr kăla ənhăyăɣ ere s-ogdăh immun-net d-wa n-ăhaləs-i-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ǝqqălăn meddən-wi dd-ămešălnen, ogăẓăn-in akli wa s-kăla ărhin, izzay. ");
INSERT INTO taq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ašăl wa n-ḍarăt wen, ăddew Ɣisa d-inəṭṭulab-net s-taɣrəmt s-isəm-net Nayin, təlkam-asăn daɣ tamətte tăjjeet. ");
INSERT INTO taq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Diha-dăɣ dd-əjjăšăn aɣrəm, ad-ămmoqqăsăn d-ăddinăt ăwwăḍnen hărăt ăwwaynen enəmmettən s-tiẓəska; enəmmettən-en, alyaḍ s-wăr təla ma-s ar ənta, ti-s daɣ wăr-idder. ");
INSERT INTO taq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ojjă Ɣisa tamăḍt-ten-dăɣ, tănɣʼ-e tăhanint-net, innʼ-as: «Ǝlɣən Iblis.» ");
INSERT INTO taq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ikkă-dd enəmmettən, iḍăs-t, əbdădăn ăddinăt-wi t-ămisawăynen, innă i-enəmmettən: «Ămawaḍ, ənneɣ-ak: ənkăr!» ");
INSERT INTO taq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ăqqimă-dd enəmmettən ăssaɣăt-wen-dăɣ, ad-itamăjrad, ăssoɣăl-t Ɣisa i-ma-s. ");
INSERT INTO taq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ărmăɣăn ăddinăt iket-năsăn, ad-tiimələn Măssinăɣ, jannen: «Ašăl-i, ănfalăl-dd ănnăbi măqqoorăn jere-năɣ, Măssinăɣ osă-dd tamətte-net i-ad-tăt-iɣləs.» ");
INSERT INTO taq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ămsaɣăl măjrăd-wen-dăɣ ătwănnăn făll-Ɣisa dăɣ-Ălyăhudəyăt d-attayăn-net. ");
INSERT INTO taq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Osăn-dd inəṭṭulab n-Exya, jăn dăɣ-s isălan n-a-wa ijăn iket-dăɣ-net. ");
INSERT INTO taq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Iɣră-dd dăɣ-săn əssin, ăšmašăl-tăn s-ălɣalim i-ad-t-səstənăn kunta ənta a-s Wa s-ătwănna ilkam ad-dd-ass meɣ ilkam iyyăn săl ənta. ");
INSERT INTO taq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Osăn-dd meddən, ənnăn-as: «Exya wa n-Enəsselmăɣ a hanăɣ-dd-ăšmašălăn săr-k, innʼ-anăɣ ad-kăy-nəsəstən, ‹kunta kăyy a-s Wa s-ătwănna ilkam ad-dd-tasəd meɣ ilkam ere săl kăyy?› » ");
INSERT INTO taq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ăssaɣăt-wen-dăɣ t-sastanăn, ăzozăy Ɣisa ăddinăt ăjjootnen dăɣ-tiẓẓoren d-alšinăn, ikfa daɣ iməddorɣal ăjjootnen turhajăt n-ahănay. ");
INSERT INTO taq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ăwwežăb i-meddən wi dd-ăšmašăl Exya, innʼ-asăn: «Ăqqəlăt Exya, suɣəlăm-as a-wa tənhăyăm d-a-wa təslăm, ănnăt-as: iməddorɣal hannăyăn, inəbdan rajjăšăn; wi ijraw jəri, tišdajăn, imẓaj, sallăn; inəmmuttan nakkărăn-dd; tilăqqiwen, sallănăt i-Ălənžil. ");
INSERT INTO taq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tənḍəḍ i-ere wa dăɣ-i wărăn ijʼ ăššăk.» ");
INSERT INTO taq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ǝglăn inămmašalăn n-Exya ɣas, ădwănnăt Ɣisa i-tamətte dăɣ-isălan n-Exya, innʼ-asăn: «Ak, a-s təzjărăm s-tenere, ma tənhăyăm? Ak teẓewt ăsiwălawăl aḍu a tənhăyăm? Ăbo! ");
INSERT INTO taq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Adiš ma təkkăm i-ad-t-tənhəyăm? Ak ăhaləs ăsisahăɣăn ašăl a tənhăyăm? Ǝnhəywăt-tăn-ak ăddinăt-wi sasahaɣnen ašăl, əntăneḍ-den ănnuflăynen dăɣ-ihănan-wi n-imănokalăn. ");
INSERT INTO taq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Adiš mi təkkăm i-ad-t-tənhəyăm? Ak ănnăbi? Tidət lab a-s ănnăbi, ăssiilmădăɣ-kăwăn a-s ere ojărăn tumast n-ănnăbi a tənhăyăm. ");
INSERT INTO taq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Exya, ənta-en-dăɣ a făl inna əlkəttab n-Măssinăɣ: ‹Ǝnhəy! Ăzizărăɣ-ak ănămmašul-in wa he-iknən tabarăt data-k.› ");
INSERT INTO taq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ăssiilmădăɣ-kăwăn a-s, wăr t-illa ara n-tamăḍt ojărăn Exya măšan, hakd a-wen-dăɣ, wăr t-illa ere t-wărăn ojer dăɣ-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ăddinăt-wi has-əslănen iket-năsăn hakd-dăɣ inarmasăn n-tiwse ărḍăn s-Təmmənəya n-Măssinăɣ ed, ăqbălăn ad-tăn-isəlmăɣ Exya ");
INSERT INTO taq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","măšan, kăl-faris d-ălɣulam-i unjăynen s-asəlmaɣ-net, ăsfatăn iman-năsăn dăɣ-a-wa iɣtăs Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Innă Ɣisa: «Ak, mi dăr-mad-sənnəfăqqăɣ kăl-əzzurəyăt-ta-dăɣ? Ak, mi dăr-olăhăn? ");
INSERT INTO taq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Olăhăn ɣas d-aratăn janen aɣrəf dăɣ-təfărre, jannen iyyăḍ i-wi iyyăḍnen: ‹Ǝnhəywăt, kăwăneḍ, wăr lem asăfar; nəwăt-awăn taɣănibt, tunjăyăm s-dăllol! Nənẓăr-awăn tiswal n-tisnant măšan, wăr təlhem!› ");
INSERT INTO taq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Exya wa n-Enəsselmăɣ, ăzzăman wa dd-osa, wăr-itətt imənsiwăn olaɣnen, wăr-isəss aman n-lăɣnăb ăxxiimmărnen; tənnăm: ‹Ihʼ-e alšin›, ");
INSERT INTO taq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","išrăy-t-dd Ăgg-ăgg-adəm, ənta itihar dăr-wăn a-wa tăttăm d-a-wa săssăm, ɣas tənnăm dăɣ-s: ‹Wa ənta, insăy, irăf aman wi n-lăɣnăb ăxxiimmărnen, amidi n-inarmasăn n-tiwse d-ălfusaɣ wi iyyăḍnen.› ");
INSERT INTO taq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Măšan a-wen wăr hin-ikkes a-s: ‹Sărho wa dd-ifălăn Măssinăɣ, ijităn n-aratăn-net a t-isatbatăn.› » ");
INSERT INTO taq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ămjarăt-dd Ɣisa ašăl iyyăn i-u-faris iyyăn, ikkʼ-e-hi-dd, ad-tamănsawăn. ");
INSERT INTO taq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Təsla tamăḍt n-tanăsbăkkaḍt hat aɣrəm-en-dăɣ a-s Ɣisa ămijarăt i-u-faris-en ɣas, a ənḍărrăn, ənta da-dăɣ tăwway butəl n-aḍutăn. ");
INSERT INTO taq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tosă-dd, təjjăš fălla-săn ehăn wa dăɣ-tamănsawăn, təkka dihad ăsiɣămăr Ɣisa, măl daw-iḍarăn-net, ad-hall. Hall har təssəbdăj iḍarăn-net s-imeṭṭawăn-net, ad-tăn-timəs s-tišəkkaḍ-net, timəllut-asăn, sănɣal fălla-săn aḍutăn. ");
INSERT INTO taq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Inhăy u-faris wa dd-ăsmăjaren Ɣisa a-wen ɣas, ad-ijanna dăɣ-iman-net: «Ǝnnăr ămoos ăhaləs-i-dăɣ ănnăbi, ilməd a-s tamăḍt-ta-dăɣ t-təḍasăt, tălkăxbat.» ");
INSERT INTO taq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Innʼ-as Ɣisa: «Simyon, ărheɣ ad-hak-ănnăɣ hărăt iyyăn.» Innʼ-as Simyon: «Ălɣalim, ăsijădăɣ-ak, măjrăd.» ");
INSERT INTO taq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Innʼ-as Ɣisa: «Kăla t-illa ăhaləs irwasăn əssin meddən: iyyăn, irwas-t səmmosăt timaḍ n-ărriyal n-aẓrəf, wa iyyăḍăn, irwas-t, səmmosăt timərwen n-ărriyal n-aẓrəf. ");
INSERT INTO taq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Inhăy a-s wăr tăn-iha-i ăddooben timẓal n-ehăre-net, ma n-əmmək ɣas, inšʼ-asăn-in a-wa tăn-irwăs. Ăssistănăɣ-kăy kăyy Simyon: ‹Ǝndek dăɣ-săn wa has-madăn-ikən tămayit?› » ");
INSERT INTO taq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Innʼ-as Simyon: «Ordeɣ a-s wa s-hin-oyyă ămarwas wa ojărăn.» Innʼ-as Ɣisa: «Toɣadăd.» ");
INSERT INTO taq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Innăḍ-dd Ɣisa ḍarăt-a-wen s-tamăḍt təzzar, innă i-Simyon: «Wădden hannăyăd tamăḍt-ta-dăɣ, əjjăšăɣ-dd ehăn-năk, wăr hi-təkfed aman s-ăsserădăɣ iḍarăn-in măšan ənta, təssəbdăj-tăn s-imeṭṭawăn-net, tomăs-tăn s-tišəkkaḍ-net, ");
INSERT INTO taq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ălwăqq wa dd-oseɣ ehăn-năk, wăr hi-dd-təlkeḍăd, tasəsăd-ahi dăɣ-idmarăn-năk măšan ənta, a dd-oseɣ, timəllut i-iḍarăn-in făll-semɣar-i-dăɣ hi-təja. ");
INSERT INTO taq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kăyy daɣ, wăr təšweyăd eɣăf-in, a-s ija a-wen ənta, iḍarăn-in a təšwăy s-aḍutăn. ");
INSERT INTO taq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dăɣ-təssəba n-tărha-i-dăɣ măqqărăt hi-təssəkna, a-wa ăjjen la dăɣ-ibăkkaḍăn, ătiwănšăn-as-in. Tidət-dăɣ a-s ere wa s-hin-ătwănša a ənḍărrăn, tămayit-net daɣ ti-ənḍărrăt.» ");
INSERT INTO taq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Inna Ɣisa ḍarăt-a-wen i-tamăḍt: «Ibăkkaḍăn-am, ătiwănšănăm-in.» ");
INSERT INTO taq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ǝslăn imăjarăn i-a-wen-dăɣ ɣas, ad-jannen dăɣ-iman-năsăn: «Ma ămoos ăwadəm wa ăddooben tenăšše n-ibăkkaḍăn n-ăddinăt?» ");
INSERT INTO taq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Innă Ɣisa i-tamăḍt ḍarăt-a-wen: «Immun-năm a kăm-iɣlăsăn, əgləw dăɣ-ălxer.» ");
INSERT INTO taq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ălliil Ɣisa ḍarăt-a-wen iɣărman d-tidbi ăjjootnen, ixaṭṭăb i-ăddinăt isălan n-ălxer n-Təmmənəya n-Măssinăɣ, ăddeewăn dăr-s inəṭṭulab-net wi n-măraw d-əssin ");
INSERT INTO taq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","d-hărăt dăɣ-tiḍeḍen s-tiyyăḍ, ikkas dăɣ-snăt, alšinăn d-tiyyăḍ ăzozăy dăɣ-turhənnawen. Tiyyăt dăɣ-snăt, isəm-net Măryăma ta n-Mulăždaləyăt, ikkas dăɣ-s ənta əssa alšinăn, ");
INSERT INTO taq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tiyyăt isəm-net Tăxya, ənta a-s hănne-s n-Šuza wa ixkămăn făll-inaxdimăn n-ehăn n-ămănokal n-ăkall wa s-isəm-net Harudəs, tiyyăt Suzănna d-timidiwen-net tiyyăḍ ăjjootnen, iket-dăɣ-năsnăt, ədhalnăt Ɣisa d-inəṭṭulab s-a-wa əṭṭăfnăt. ");
INSERT INTO taq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tăddew-dd tamətte tăjjeet s-wăr t-illa aɣrəm wăr dd-fel s-Ɣisa. Issăɣlăy tamətte tangalt, innʼ-asăn: «Kăla izjăr ănăsdamu iyyăn i-ad-iddumət ašəkrəš-net. ");
INSERT INTO taq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ălwăqq wa d-itidumut, oḍănăt tiblalen tiyyăḍ dăɣ-ăbara, ăfkălfăkălăn-tănăt ăddinăt, ăkkukkăren-tănăt-dd igḍaḍ, əkšăn-tănăt. ");
INSERT INTO taq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oḍa ašăr iyyăn jer-tihun, diha-dăɣ dd-ăffoqqăt, ad-hin-ăqqur făl iba n-abduj. ");
INSERT INTO taq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oḍa ašăr iyyăn dăɣ-tabəŋŋənt, tədwăl-dd fălla-s tabəŋŋənt, təẓmăd-as. ");
INSERT INTO taq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ašăr wa iyyăḍăn, oḍa dăɣ-ăkall olaɣăn, idwăl-dd, ikrăš aratăn s-timaḍ.» Ija măjrăd-wen-dăɣ ɣas, iḍkăl emăsli-net, innă: «Ere ilăn timəẓẓujen s-islă-dăɣ, isăjdet.» ");
INSERT INTO taq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ǝssəstănăn-t inəṭṭulab-net ḍarăt-a-wen d-ălmăɣna n-tangalt ta ija. ");
INSERT INTO taq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Innʼ-asăn: «Kăwăneḍ, təjrawăm turhajăt n-ujreh n-əddăraj wa n-isălan n-Təmmənəya n-Măssinăɣ mašăn, ăddinăt wi iyyăḍnen, wăr jen a-wen. ‹Ad-əswaḍăn, wăr hənnəyăn; sallăn, wăr jărrăhăn.› » ");
INSERT INTO taq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Ămăra, tangalt, ălmăɣna-net da: Tiblalen a-s măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ăbara wa dăɣ-oḍănăt tiblalen tiyyăḍ, ənta a-s ăddinăt-wi sallănen i-măjrăd n-Măssinăɣ, asʼ-en-dd Iblis, ilbəy-t-dd dăɣ-ulhawăn-năsăn i-ad-wăr-omenăn s-Măssinăɣ, iɣləs-tăn. ");
INSERT INTO taq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tihun ti jer-oḍănăt tiblalen tiyyăḍ, əntănăteḍ a-s ăddinăt-wi s-e-d əslăn i-măjrăd n-Măssinăɣ, ad-əhləyləyăn, ăqbəlăn-t šik, măšan wăr t-təyyən ikraš ikewăn dăɣ-ulhawăn-năsăn, ad-əjən ăzzăman ənḍărrăn ălmăt ătubăn, măšan afăl ătwăžžurrăben, ad-hin-əbbuṭṭəlăn a-wa s-omănăn. ");
INSERT INTO taq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tabăŋŋənt ta dăɣ-oḍănăt tiblalen tiyyăḍ, ənta a-s ăddinăt wi s-e-d əslăn i-măjrăd n-Măssinăɣ, ad-tăn-ăɣləbăn inəzjam n-tărha d-ajmur d-iẓəjraẓ n-wălăt-ăddunya, əẓmədăn-as, indăr-asăn ad-əhələn s-data dăɣ-tuksəḍa-năsăn i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ăkall wa olăɣăn dăɣ-oḍănăt tiblalen tiyyăḍ, olăh d-ăddinăt-wi s-e-d əslăn i-măjrăd n-Măssinăɣ, ad-t-əknən uḍəf s-sărho dăɣ-ulhawăn-năsăn, ad-hasăn-t-ijjəš ălfăyda ăddewăn d-akuyəd.» ");
INSERT INTO taq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Innʼ-asăn Ɣisa daɣ: «Wăr t-illa ere isarmasăn tefătelt təzzar, isəbbumbəy fălla-s ăkoss meɣ tăt-ija daw-tešejit, ănn-ak, asili a tăt-itajj făll-ăsaḍəf ăsikakăn i-ad-hannăyăn ăddinăt wi dd-tajjăšnen ehăn ănnur-net. ");
INSERT INTO taq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wăr t-illa a iffarăn s-wădden ad-dd-infiləl, wăr t-təlla daɣ takše s-wădden ad-dd-təffukkăr s-tarăhut. ");
INSERT INTO taq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ăjăt ənniyăt i-əmmək wa s-sajadăm; ăwadəm wa ifhămăn hărăt, ad-has-iwwaḍ musnăt har isəssikəy măšan, wa s-wăr t-illa a ijrah, wăr t-in-ikka hărăt, ănn-ak, ad-dăɣ-s ămahăɣ wăla a-wa s-orda a-s iṭṭaf-t.» ");
INSERT INTO taq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tosă-dd anna n-Ɣisa d-ayətma-s măšan, igdăl-asăn əjut n-tamətte ad-t-ənhəyăn. ");
INSERT INTO taq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ătwănnʼ-as: «Təbdad anna-năk d-ayətma-k dat-emm n-ehăn, ărhan ahănay-năk.» ");
INSERT INTO taq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ăwwežăb-asăn, innʼ-asăn: «Anna-nin d-ayətma-ɣ, ăddinăt-wi sajadnen i-măjrăd n-Măssinăɣ, tamašalăn a-wa inna.» ");
INSERT INTO taq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ijjăš Ɣisa ašăl iyyăn turăft n-aman ənta d-inəṭṭulab-net, innʼ-asăn: «Nəjləyet ejănš s-ašrut wa iyyăḍăn», əglăn. ");
INSERT INTO taq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ǝglan făll-aman-en-dăɣ a-s hin-iṭṭăs Ɣisa. A ənḍărrăn, inkăr-dd aḍu-i-dăɣ ăṣṣoohen, ad-ḍakkăr turăft aman, əjjăšăn miši. ");
INSERT INTO taq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ohăẓăn-dd inəṭṭulab Ɣisa, ad-t-sănkarăn dăɣ-eḍəs, jannen-as: «Ălɣalim, Ălɣalim, nəhlăk!» Inkăr-dd Ɣisa, ăsmăhăḍ făll-aḍu d-tinăzzămăren ti ăṣṣoohătnen, ibdăd a-wen-dăɣ iket-net, sămmeḍ-in. ");
INSERT INTO taq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Innʼ-asăn Ɣisa: «Ma ija immun-năwăn.» Ǝqqălăn-dd ɣas ărmaɣăn, oran imawăn, tinmənnin: «Ma ămoos ăwadəm-wa-dăɣ s-e-d omăr i-aḍu d-aman ad-has-səjdən?» ");
INSERT INTO taq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ăsjănăn ḍarăt-a-wen dăɣ-ăkall wa n-kăl-Gadara ănimăswăḍăn d-teje ta n-Galila. ");
INSERT INTO taq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Diha-dăɣ dd-izjăr Ɣisa turăft n-aman, ad-has-dd-ilkăḍ ăhaləs n-aɣrəm-en-dăɣ han alšinăn. A ilan ăzzăman, wăr-iləss tikəst, wăr-ilʼ edăgg n-iman-net, izzaɣ tiẓəska. ");
INSERT INTO taq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Inhăy Ɣisa ɣas, ăsɣărăt təzzar, irkăɣ data-s, innʼ-as: «Ya Ɣisa wa n-Rure-s n-Măssinăɣ wa iknăn aḍkul, ma dăɣ-i tărhed? Dalăɣ-kăy d-ad-wăr hi-tăqquzzăbed.» ");
INSERT INTO taq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A-s ijănna a-wen-dăɣ, isamăhaḍ Ɣisa făll-alšin wa t-ihăn, i-ad-t-izjăr. Ăhaləs-en, itajjăš-t alšin s-e-d t-ijjăš, akărad ad-t-tajjăn ăddinăt s-tišəm d-tifren măšan, isaɣătas-dd a-wen-dăɣ iket-net, ăzzăwăt-t alšin s-tinariwen. ");
INSERT INTO taq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Issəstăn-t Ɣisa, innʼ-as: «Mi isəm-năk?» Innʼ-as amălšon: «Isəm-in ejhăn», ed alšinăn ăjjootnen a t-hanen. ");
INSERT INTO taq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ad-laqqădăn alšinăn-wi t-hănen Ɣisa i-ad-wăr tăn-ăssoka anu wa wărăn ilʼ ider ihăn ălaxărăt. ");
INSERT INTO taq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iḍan dihen ehăre n-əlxənžărăn făll-tasăja n-taḍaɣt, əlɣădăn alšinăn Ɣisa i-ad-tăn-ăyy ad-əjjəšăn əlxənžărăn-en-dăɣ, irḍʼ-asăn s-a-wen. ");
INSERT INTO taq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ǝzjărăn alšinăn ăhaləs, əjjăšăn əlxənžărăn, ad-dd-titrəktərikăn wa-dăɣ n-afălla n-taḍaɣt, tiḍəwăn dăɣ-ejărew wa səmmăn, tattăn-tăn aman. ");
INSERT INTO taq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ǝnhăyăn imăḍanăn-năsăn a-wa ijăn ɣas, ăjewăḍăn, jăn isălan dăɣ-kăl-aɣrəm d-attayăn-net. ");
INSERT INTO taq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Osăn-dd ăddinăt ăwinafătnen a-wa ijăn, ogăẓăn-dd ăhaləs wa dăɣ-ikkăs Ɣisa alšinăn, ăqqiima edes i-iḍarăn n-Ɣisa, ijă isəlsa, hʼ-e daɣ tijya n-iman-net; ărmăɣăn. ");
INSERT INTO taq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jăn dăɣ-săn ăddinăt wi ăjjəyhnen i-a-wa ijăn isălan n-əmmək wa s-dd-iɣlăs amălšon dăɣ-alšinăn wi t-əzzăɣnen. ");
INSERT INTO taq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Măšan, əjjăšăn-tăn isălan n-a-wa ijăn ɣas, ad-tattărăn kăl-Gadara dăɣ-Ɣisa ad-ifəl ăkall-năsăn făll-tarəmmeɣt-i-dăɣ jăn. Ijjăš Ɣisa turăft n-aman, iqqăl. ");
INSERT INTO taq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ittăr dăɣ-s ăhaləs wa dăɣ-ikkăs alšinăn ad-t-ăyy ad-dăr-s idaw măšan, innʼ-as Ɣisa: ");
INSERT INTO taq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ǝqqəl ehăn-năk, tăllăɣed i-ăddinăt təmɣăre n-a-wa hak-ija Măssinăɣ». Iglă ḍarăt-a-wen, ad-isanăfas dăɣ-aɣrəm iket-net təmɣăre n-a-wa has-ija Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ălwăqq wa dd-iqqăl Ɣisa ašrut n-ejănš wa iyyăḍăn, təlkăḍ-as-dd tamətte has-tăqqalăt. ");
INSERT INTO taq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A ənḍărrăn ăhaləs iyyăn da-dăɣ s-isəm-net Žayrus, ənta a-s ălfăqqi n-ehăn n-ăddin wa n-kăl-Ălyăhud n-taɣrəmt-en; irkăɣ dat-Ɣisa, ad-dăɣ-s itattăr ad-idawăn s-ehăn-net, ");
INSERT INTO taq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","făl-a-s itiba elle-s lat marăw iwətyan d-əssin s-ənta ɣas a ila. Ăddeew dăr-s s-ehăn-net dăɣ-a-s t-tăɣilăyɣălăy tamətte siha hakd siha. ");
INSERT INTO taq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tamətte-en, hʼ-et tamăḍt izajjăr ašni a ilan măraw iwətyan d-əssin, wăr t-illa lăxtur wăr tosa măšan, ăbă-dd i tăt-ăzozăyăn. ");
INSERT INTO taq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Təkkă-dd ḍarăt Ɣisa, ḍăs afăr n-erăswăy-net, iktăl ašni wa tăt-dd-izajjărăn ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Innă Ɣisa: «Ma ămoos ăwadəm wa hi-iḍăsăn?» Wăr t-illa ere innan hărăt. Iggăd-dd Bəṭrus, innʼ-as: «Ălɣalim, tăsinăkmăm-kăy tamətte tăjjeet dăɣ-ifăyyăn iket-năsăn.» ");
INSERT INTO taq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Innʼ-asăn Ɣisa: «Iḍăs-ahi ăwadəm iyyăn făl-a-s, ofrayăɣ i-tărna ta hi-dd-təjmăḍăt.» ");
INSERT INTO taq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Təlmăd tamăḍt a-s tăffukkăr-dd ɣas, təkkă-dd Ɣisa tăšikăḍkăḍ, tărkăɣ data-s, təllăɣăt-as dat-ăddinăt iket-năsăn ăddălil wa făl ḍăs afăr n-erăswăy-net d-əmmək wa s-təzzăy ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Innʼ-as Ɣisa: «Talyaḍt-in, ăzozăy-kăm immun-năm, əgləw dăɣ-ălxer.» ");
INSERT INTO taq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ămmiijrăd Ɣisa dihen-dăɣ a-s dd-osa ăhaləs dd-ifalăn eɣewən n-ălfăqqi n-ehăn wa n-ăddin, innʼ-as: «Elle-k, ăba-tăt, wăr tăslăyyăɣăd ălɣalim daɣ.» ");
INSERT INTO taq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Islă Ɣisa i-isălan wi dd-ăssawăḍ ăhaləs-en ɣas, innă i-Žayrus: «Wăr kăy-isărmaɣet hărăt, amən ɣas, ad-təzzəy.» ");
INSERT INTO taq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iwwăḍ-in Ɣisa ehăn n-Žayrus ɣas, igdăl i-ăddinăt ad-t-əjjəšăn, wăr-ăddew ar d-Bəṭrus d-Exya d-Yaqub d-ti-s d-ma-s n-talyaḍt. ");
INSERT INTO taq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A-s ităjj a-wen-dăɣ, tăsikălăl tamətte iket-dăɣ-net, hall iba n-talyaḍt măšan, innʼ-asăn Ɣisa: «Wăr təlhem ed talyaḍt, wăr tăt-ăba, eḍəs ɣas a ja.» ");
INSERT INTO taq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jăn-t tekăškăšt ed əkkasăn ăššăk a-s ăba-tăt. ");
INSERT INTO taq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ijjăš Ɣisa edăgg wa dăɣ-tənsa talyaḍt, irmăs-tăt-dd s-ăfuss, iɣrʼ-et, innʼ-as: «Talyaḍt, ənkăr-dd!» ");
INSERT INTO taq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ǝqqălăn-tăt-dd iman-net, təbdăd-dd s-iyyăt, omăr-tăn d-ad-tăt-əkfən a təkša. ");
INSERT INTO taq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ǝqqălăn-dd imărawăn-net ɣas tofʼ-en tăkunt. Ăsmătăr-tăn Ɣisa d-ad-wăr jen isălan n-a-wa ijăn dăɣ-ăwadəm wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iɣră-dd Ɣisa inəṭṭulab-net wi n-măraw d-əssin, ikfʼ-en tărna d-ălxikmăt făll-e d t-illăm alšin d-tădabit n-ad-zizuyăn ăddinăt dăɣ-turhənnawen-năsăn, ");
INSERT INTO taq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ăšmašăl-tăn ḍarăt-a-wen i-ad-xaṭṭăbăn isălan n-Təmmənəya n-Măssinăɣ d-ad-zizuyăn imarhinăn, ");
INSERT INTO taq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","innʼ-asăn: «Wăr tiwəyăt wăla a ənḍărrăn dăɣ-asikəl-năwăn, wăr tiwəyăt tăborit, wăla šăkkoš, wăla ăzzad, wăla aẓrəf; wăr tiwəyăt əssin irăswăyăn. ");
INSERT INTO taq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ehăn təjjăšăm-dăɣ har kăwăn-ăsmăjarăt, ɣaymăt dăɣ-s har ašăl wa d-tăssawăḍăm tekle. ");
INSERT INTO taq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aɣrəm təjjăšăm wăr kăwăn dăɣ-s ăsbărrăk ăwadəm, əzjărăt-t, tăbbăkbăkăm iḍarăn-năwăn i-ad-wăr kăwăn-iləttăɣ wăla ăboqqal-net, ilkam ad-ăjjăyh a-wen fălla-săn.» ");
INSERT INTO taq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ǝglăn inəṭṭulab, tadăbayt əmmărăn-dăɣ, ad-dăɣ-s ăxṭəbăn isălan n-ălxer, zuzəyən dăɣ-s imarhinăn. ");
INSERT INTO taq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Islă Harudəs-i ixkămăn făll-teje ta n-Galila a-wa ităjj Ɣisa d-inəṭṭulab-net ɣas, iqqăn eɣăf-net făl-a-s, jannen ăddinăt iyyăḍ dăɣ-isălan n-Ɣisa a-s ənta-i-dăɣ a-s Exya wa n-Enəsselmăɣ dd-olasăn tanăkra jer-inəmmuttan, ");
INSERT INTO taq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","jannen iyyăḍ: «A-wa ănnăbi Ɣəli dd-olasăn uɣəl», jannen wi iyyăḍnen: «A-wa iyyăn dăɣ-ănnăbităn wi n-ibda dd-olasăn tanăkra jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Harudəs ənta iman-net, innă: «Exya-š, ajăn wădden năkk a dd-issəfrăsăn eɣăf-net, ma ămoos-š wa hi-dd-išreyăn făll-sallăɣ ijităn-wi-dăɣ?» Ad-itattăr ya Harudəs əmmək s-inhăy Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ǝqqălăn-dd inəmmušal, jăn dăɣ-Ɣisa isălan n-a-wa jăn iket-net. Ikkăs-tăn-dd s-takše, ikka dăr-săn taɣrəmt ta n-Băṭsăyda. ");
INSERT INTO taq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ǝlmădăn ăddinăt s-a-wen ɣas, əlkămăn-as-dd. Ilkăḍ-asăn-dd Ɣisa, ad-hasăn-itajj isălan n-Təmmənəya n-Măssinăɣ, izizuy dăɣ-săn wi n-imărhinăn ăḍḍirărnen s-a-wen. ");
INSERT INTO taq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ohăẓ-dd ejăḍăl n-tăfukt ɣas, ohăẓăn-t-dd inəṭṭulab-net wi n-măraw d-əssin, ənnăn-as: «Səgləw tamətte ad-tăkk tidbi-ti ohăẓnen d-imăzzaɣăn i-ad-təmmăɣ i-edăgg dăɣ-tənsa d-i dăɣ-təkša făl-a-s, edăgg n-tenere a nəha.» ");
INSERT INTO taq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Innʼ-asăn: «Un, šăkšăt-tăn kăwăneḍ iman-năwăn.» Ǝnnăn-as: «Wăr nəṭṭef ar səmmosăt tijəlwen d-əssin imănan, afăl wădden aɣrəm a nəkka, i-ad-dd-nəžănš a təkša tamətte jat əjut-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ălžămaɣăt-en-dăɣ, ihʼ-e a iwwăḍăn səmmos afḍăn n-ăhaləs. Innă Ɣisa i-inəṭṭulab-net: «Săqqaymət ăddinăt, təbḍəwăm-tăn s-səmmosăt-səmmosăt timərwen n-ăwadəm.» ");
INSERT INTO taq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jăn inəṭṭulab a-wa hasăn-innă, ăsɣăymăn ăddinăt iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iḍkăl Ɣisa ḍarăt-a-wen tijəlwen ti n-səmmosăt d-imănan wi n-əssin, ăjoẓăy išənnawăn, ămmoy i-Măssinăɣ, ăfrăsfărăs tijəlwen, ănkăḍnăkăḍ imănan təzzar, ikfă a-wen-dăɣ iket-net i-inəṭṭulab-net i-ad-t-uẓanăn jer-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ǝkšăn iket-dăɣ-năsăn har əyyəwănăn, ăsdăwăn-dd a-wa əjlăšăn, osăn-t iḍnăy măraw deketăn d-əssin n-tijəlwen d-imănan. ");
INSERT INTO taq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ašăl iyyăn, itəddal Ɣisa Măssinăɣ, əllan-t ɣur-s inəṭṭulab-net, har šik-dăɣ, innʼ-asăn: «Ma janna tamətte dăɣ-isălan-in, ma janna, mi ămoosăɣ?» ");
INSERT INTO taq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ǝnnăn-as: «Iyyăḍ jannen: kăyy a-s Exya wa n-Enəsselmăɣ, iyyăḍ jannen: kăyy a-s ănnăbi Ɣəli, iyyăḍ făw a jannen: kăyy iyyăn dăɣ-ănnăbităn wi n-ibda dd-olasăn tanăkra jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Innʼ-asăn: «Kăwăneḍ-i-š, ma tənnăm, mi ămoosăɣ?» Ăwwežăb-as Bəṭrus, innʼ-as: «Kăyy a-s Ălmasex wa n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ăsmăhăḍ dăɣ-săn Ɣisa, omăr-tăn d-ad-wăr jen isălan-win-dăɣ i-ăwadəm wălʼ iyyăn, ");
INSERT INTO taq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","innʼ-asăn: «Ăgg-ăgg-adəm, ilzam-t ad-inhəy tersəmmawen ăjjootnen, ənkărăn-t inušămăn wi n-Iṣrayil d-imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt, əjən iman-net măšan, ašăl wa s-kăraḍ ḍarăt tamăttant-net, ad-dd-inkăr jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Innʼ-asăn iket-năsăn ḍarăt-a-wen: «Ere irhăn alkum-hahi-dăɣ, adiš, iksənet iman-net, ăjet hak ašăl făll-tamăttant šund ta n-tajəttewt təzzar, ilkəmet-ahi. ");
INSERT INTO taq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wa wărăn itəttăr ar əmmək s-ogăẓ iman-net dăɣ-ăddunya-ta-dăɣ, ad-ifut dăɣ-ălžănnăt, măšan, wa irḍăn ăfota dăɣ-iman-net dăɣ-ăddunya-ta-dăɣ, dăɣ-ăddimmăt-in, ad-iɣləs. ");
INSERT INTO taq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma s-infa ăgg-adəm ad-irbăx ăddunya iket-dăɣ-net, a-s ija a-wen, ăššiiška iman-net, ăfota dăɣ-ălaxărăt? ");
INSERT INTO taq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ere hi-ăkrakăḍăn-dăɣ năkk d-măjrăd-in, ad-t-əkrukəḍăɣ năkk-dăɣ i n-Ăgg-ăgg-adəm ašăl wa d-mad-dd-ăqqəlăɣ dăɣ-ălxurmăt-in d-ălxurmăt n-Abba d-ănjălosăn wi n-iməššeddəjăn. ");
INSERT INTO taq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ăsidătteɣ-awăn a-s han-kăwăn ăddinăt əbdadnen diha-dăɣ wăr-e iba wăr-ənheyăn Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ǝḍḍəkuḍ n-əttam išilan ḍarăt a-s hasăn-ija Ɣisa măjrăd-wənnin-dăɣ, ăddew d-Bəṭrus d-Exya d-Yaqub s-taḍaɣt tiyyăt i-ad-idəl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Itəddal Măssinăɣ dihen-dăɣ a-s data-săn dd-ijjăš ini ăynayăn, iqqăl-dd emăls-net i măllăn-măllăn šund essam. ");
INSERT INTO taq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A ənḍărrăn, əssin meddən-da-dăɣ dd-falnen išənnawăn hasăn-dd-ănfalălnen, ad-tamăjradăn d-Ɣisa. Meddən-en-hi, iyyăn ănnăbi Mosa, wa iyyăḍăn ănnăbi Ɣəli. ");
INSERT INTO taq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ănfalălăn-as-dd dăɣ-ălxurmăt, əjăn-as isălan n-əmmək wa s-mad-hin-isəssiwăḍ ămašal n-Măssinăɣ s-tamăttant-net, dăɣ-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A-s ităjj a-wen-dăɣ, ilɣad eḍəs Bəṭrus d-imidiwăn-net, ənkărăn-dd ɣas, ənhăyăn təmɣăre n-ălxurmăt n-Ɣisa d-meddən wi n-əssin dăr-ănnibdăd. ");
INSERT INTO taq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ălwăqq wa d-igilləw Mosa d-Ɣəli, innă Bəṭrus i-Ɣisa: «Ălɣalim, ufa ad-nəzzăɣ ɣas diha-dăɣ, nəkrəs kăraḍ ihəktan: wa-năk, wa n-Mosa d-wa n-Ɣəli.» Wăr-issen Bəṭrus a ijanna. ");
INSERT INTO taq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ijanna a-wen-dăɣ a-s tăn-dd-təlsa tele n-tejărăkt tiyyăt, ărmăɣăn. ");
INSERT INTO taq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Izjăr-dd emăsli tejărăkt-en innăn: «A-wa Rure-ɣ wa n-iyyăn ăsnăfrănăɣ, săjdăt-as!» ");
INSERT INTO taq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A-s imda măjrăd-ənnin-dăɣ, wăr t-illa ere dd-ăqqimăn dihen-dăɣ a săl Ɣisa. Ăssosămăn inəṭṭulab făll-a-wa ənhăyăn dăɣ-išilan-win-dăɣ, wăr t-illa ere dăɣ-jan isălan. ");
INSERT INTO taq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ašăl wa ilkămăn i-wen, ălwăqq wa dd-ăzzubbăt Ɣisa d-inəṭṭulab-net taḍaɣt, təlkăḍ-as-dd tamətte tăjjeet. ");
INSERT INTO taq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A ənḍărrăn ăhaləs iyyăn da-dăɣ, iḍkăl emăsli-net, innă: «Ălɣalim, aḍən tăhanint i-ara-nin s-ənta ɣas a leɣ. ");
INSERT INTO taq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","E-d t-irmăs alšin wa t-ihăn-dăɣ, ad-isaɣărat, itišbărḍil, isakăffaw, isiləbbuḍ-t, šărnaš dăr-s ibiḍḍəw, ");
INSERT INTO taq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","əttărăɣ dăɣ-inəṭṭulab-năk ad-dăɣ-s t-əkkəsăn măšan, indăr-asăn.» ");
INSERT INTO taq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ăwwežăb-asăn, innʼ-asăn: «Ya əzzurəyăt-i-dăɣ wărăt tomen s-Măssinăɣ, tănimăšrăy-as, hundăɣ har əmme əlleɣ jere-wăn, əṣbarăɣ-kăwăn?» Innă i-ăhaləs ḍarăt-a-wen: «Awəy-ahi-dd rure-k.» ");
INSERT INTO taq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ikka-dd alyaḍ Ɣisa a-s t-ăssoḍa alšin, ad-itišbărḍil măšan, ăsmăhăḍ Ɣisa făll-alšin, izzăy alyaḍ, ăssoɣăl-t i-ti-s. ");
INSERT INTO taq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ăkunăn ăddinăt iket-dăɣ-năsăn făl təssəba n-təmɣăre n-ijităn n-Măssinăɣ. Inhăy Ɣisa a-s ăkunăn dăɣ-a-wa ităjj ɣas, innă i-inəṭṭulab-net: ");
INSERT INTO taq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ǝjjəšnet isălan-wi-dăɣ timəẓẓujen-năwăn: Ăgg-ăgg-adəm, išwar ăttirmăs, ijjəš ifassăn n-dăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wăr-əjrehăn măjrăd-wen-dăɣ hasăn-ija, ăttunkăl-asăn ălmăɣna-net i-ad-wăr t-jărrăhăn hakd a-wen-dăɣ, ăksuḍăn ad-t-səstənăn d-ălmăɣna-net. ");
INSERT INTO taq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tənkăr ḍarăt-a-wen tamɣənnant tăṣṣoohet jer-inəṭṭulab i-ad-əlmədăn əndek dăɣ-săn wa ojărăn. ");
INSERT INTO taq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iɣră Ɣisa edăwănne n-ulhawăn-năsăn ɣas, iḍkăl-dd ara iyyăn, ijʼ-e edes-has, ");
INSERT INTO taq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","innʼ-asăn: «Ere ăsbălălăn ara-wa-dăɣ, dăɣ-ăddimmăt-in, năkk a ăsbălăl, ere wa hi-ăsbălălăn, wa hi-dd-ăšmašălăn a ăsbălăl; wa dăɣ-wăn ăsrăsăn iman-net, ənta a-s wa ojărăn.» ");
INSERT INTO taq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Issəstăn-t ănăṭṭalib-net Exya, innʼ-as: «Ălɣalim, nənhay ăwadəm iyyăn itakkăsăn alšinăn dăɣ-ăddinăt s-tărna n-isəm-năk, nənnʼ-as, wăr-itilset, ed wăr hanăɣ-iha s-alkum-hak.» ");
INSERT INTO taq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Innʼ-as Ɣisa: «Wăr has-t-təgdelăm făl-a-s ere wărăn kăwăn-iknes-dăɣ, a-di, amidi-năwăn.» ");
INSERT INTO taq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ohăẓăn-dd išilan-wi d-ila Ɣisa s-ad-t-iba, inkăr-dd jer-inəmmuttan, ăkk išənnawăn ɣas, təjjăš-dd tărha n-tikawt n-Yărussălam ənniyăt-net s-ăṣṣahăt. ");
INSERT INTO taq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Issəglă inămmašalăn data-s, ăssokʼ-en taɣrəmt tiyyăt n-Sămari i-ad-has-əjrəwăn ehăn dăɣ-ăzzubbăt ");
INSERT INTO taq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","măšan, unjăyăn kăl-taɣrəmt-ten-dăɣ s-ad-hasăn-imjurət, ed ija tamdujt ta n-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Inhăy Yaqub d-Exya a-wen ɣas, ənnăn-as: «Ălɣalim, wi hi-ăddinăt, ăyy-anăɣ ad-fălla-săn dd-nəzəzzubbət efew tăn-ilhăsăn.» ");
INSERT INTO taq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Innăḍ-dd săr-săn Ɣisa, ăsnărɣăm fălla-săn, innʼ-asăn: «Wăr təssenăm a jănnem, ");
INSERT INTO taq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ăgg-ăgg-adəm wăr dd-osa i-ad-ilhəs ăddinăt, osă-dd i-ad-tăn-iɣləs.» Okăyăn ḍarăt-a-wen s-taɣrəmt săl-ten. ");
INSERT INTO taq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ǝglan dăɣ-a-wen-dăɣ a-s innʼ ăhaləs iyyăn i-Ɣisa: «E-s təkked-dăɣ, əlkamăɣ-ak.» ");
INSERT INTO taq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Innʼ-as Ɣisa: «Ibăggan lan tihaliwen, igḍaḍ lan iskak măšan, Ăgg-ăgg-adəm, wăr ila wăla edăgg dăɣ-issənsa eɣăf-net.» ");
INSERT INTO taq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Innă Ɣisa i-ăhaləs iyyăn ḍarăt-a-wen: «Ǝlkəm-ahi.» Innʼ-as wa: «Ălɣalim, ăkfʼ-ahi turhajăt n-ad-ăglăɣ ăẓkăɣ abba-nin, ăqqəlăɣ-kăy-dd, əlkəmăɣ-ak.» ");
INSERT INTO taq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Innʼ-as Ɣisa: «Ăyy inəmmuttan ad-əẓkən inəmmuttan-năsăn, kăyy, əgləw ăj i-ăddinăt isălan n-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Innʼ-as iyyăn daɣ: «Ălɣalim, ărheɣ ad-hak-əlkəmăɣ măšan, ăkfʼ-ahi turhajăt n-ad-ăjăɣ isənnăɣlaf d-ăddinăt-in təzzar.» ");
INSERT INTO taq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Innʼ-as Ɣisa: «Ere issəntăn azzal wa n-ălxidmăt i-Măssinăɣ təzzar, ad-išanăšlam ḍara-s, a-di, wăr-ănhăjja d-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ăsnăfrăn ălɣalim Ɣisa ḍarăt-a-wen, əssayăt timərwen n-ănăṭṭalib d-əssin, ăšmašăl-tăn s-əssin-əssin i-ad-has-izarăn s-idăggan wi s-ikittəw ad-tăn-immăr. ");
INSERT INTO taq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Innʼ-asăn: «Ašəkrəš ăggolăt, əttăɣam ijjət măšan, wăr-əjjətăn inaxdimăn t-olăynen, ădəlăt măssi-s n-ašəkrəš i-ad-dd-išəmmišəl inaxdimăn olăynen ašəkrəš-net. ");
INSERT INTO taq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Săjdăt! Ăglăt, ăšimašălăɣ-kăwăn i-ad-talăhăm d-ikərwatăn əllanen jer-tiɣəs. ");
INSERT INTO taq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wăr tiwəyăt ăẓrəf, wăla šăkkoš, wăla tifădelen, wăr kăwăn-šəllunet isofan dăɣ-tabarăt. ");
INSERT INTO taq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ehăn təjjăšăm-dăɣ, ăjrăt fălla-s ăssălam s-tizarăt. ");
INSERT INTO taq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kunta ehăn-en, izzaɣ-t ăgg-ălxer, ad-kăwăn-isəbbărrək, ăns fălla-s ălxer-năwăn, kunta daɣ wăr t-iha ăgg-ălxer, adiš, akəyăt d-ălxer-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Afăl təjrăwăm ehăn wa n-ăgg-ălxer, əzzăɣăt dăɣ-s, təkšəm, təswəm a-wa kăwăn-mad-ăkf măssi-s făl-a-s, hak ănaxdim-dăɣ, ărhuj-as ălxaqq n-tide-net, udaɣăt i-tikawt jer-ihănan. ");
INSERT INTO taq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aɣrəm tosăm-dăɣ, ăsbărrăkăn-kăwăn məssaw-s, ăkšăt a-wa s-kăwăn-mad-səmməjurun, ");
INSERT INTO taq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","zuzəyăt imarhinăn-năsăn, tənnəm i-məssaw-s: ‹Təmmənəya n-Măssinăɣ, tohăẓ-kăwăn-dd› ");
INSERT INTO taq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","măšan, aɣrəm tosăm, wăr kăwăn-ăsbărrăkăn məssaw-s, ilalăt tišarriten-net, tənnəm i-məssaw-s: ");
INSERT INTO taq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Tăjjəyhăm a-s wăla-dăɣ ăboqqal n-aɣrəm-năwăn wa iwărăn iḍarăn-nănăɣ, năbbikbăk-in măšan, əlmədăt a-s Təmmənəya n-Măssinăɣ, tohăẓ-dd.› ");
INSERT INTO taq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ǝnneɣ-awăn a-s ašăl wa ilkămăn, ad-tajăr tisnant ta madăt-tărməs aɣrəm-en-dăɣ, ta tărmăsăt aɣrəm wa n-Sodoma.» ");
INSERT INTO taq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Iməskay kăl-Qorazin, iməskay kăl-Băṭsăyda! Ălmăṣṣibăt ɣas a fălla-wăn madăn-iḍəw ed ənnăr iɣărman wi n-Tir d-Săyda əzzăɣăn inəẓẓulam a dăɣ-jănăt tikunen-ti-dăɣ jănen ɣur-wăn, ăru d-əlsăn šakutăn, əblənbulun dăɣ-eẓəd făl təmɣăre n-tătubt-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A-wen-dăɣ a făl ašăl wa ilkămăn, ad-kăwăn ijjəš ăddăyyăt ojărăn wa ijjăšăn iɣărman wi n-Tir d-Săyda. ");
INSERT INTO taq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kăwăneḍ-i-š-i əzzăɣnen aɣrəm wa n-Qăfărnaxum, ma tăɣelăm? Tordam a-s ad-itimɣar aɣrəm-năwăn har awəḍ išənnawăn? Xăram-awăn! Ănn-ak, ad-təhələm ider, wăr kăwăn-dd-e-awăɣ ar temse.» ");
INSERT INTO taq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Innă daɣ Ɣisa i-inəṭṭulab-net: «Ere hawăn-ăsjădăn, năkk a-s ăsjăd, wa kăwăn-irfăḍăn, năkk a irfăḍ, ere daɣ wa hi-irfăḍăn, wa hi-dd-ăšmašălăn a irfăḍ.» Issəmdă Ɣisa măjrăd ɣas, issəglă inəṭṭulab-net i-ad-hin-səssiwəḍăn ămašal-net. ");
INSERT INTO taq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ǝglăn inəṭṭulab wi n-əssayăt timərwen d-əssin, a-s dd-əqqălăn əknan dăɣ-tedăwit. Osăn-dd ɣas, ənnăn-as: «Ălɣalim, wălʼ alšinăn, rakkăɣăn-anăɣ e-d hasăn-năɣra isəm-năk.» ");
INSERT INTO taq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Innʼ-asăn: «Hannăyăɣ Iblis har dd-ătrăkkăt dăɣ-išənnawăn šund essam. ");
INSERT INTO taq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ǝlmədăt a-s əkfeɣ-kăwăn tărna făll-taššălen d-tiẓerdəmen d-a-wa ila Iblis dăɣ-tărna iket-net, wăr t-illa făw a ăddooben ad-hawăn-iɣšəd hărăt ");
INSERT INTO taq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","măšan, wăr kăwăn-isădăwatet a-wa s-data-wăn rakkăɣăn alšinăn, ănn-ak, isəddəwətet-kăwăn a-wa s-əktăbăn ismawăn-năwăn dăɣ-išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tăsdăwăt tărna n-Unfas ŠăddijănƔisa ălwăqq-wen-dăɣ, innă: «Abba, kăyy-i n-Emăli n-išənnawăn d-ăkall, timəlăɣ-kăy făl-a-s hărătăn-wi-dăɣ, təffărăt-tăn i-iməssorha d-imusănăn n-ăddunya-ta-dăɣ măšan, tăsnăfalălăd-tăn-dd wăla i-aratăn. Tidət Abba, kăyy a timəlăɣ ed ădduuttăt a-s ənta-den-dăɣ erhet-năk wa ăhusken. ");
INSERT INTO taq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wăr t-illa a-s wădden ijʼ-e Abba-nin dăɣ-ifassăn-in, wăr t-illa ere hi-ijan muzəyăt imdan kunta wădden Abba, wăr t-illa daɣ ere ijan muzəyăt imdan i-Abba kunta wădden năkk-i n-Rure-s-i t-dd-ifălăn d-ere wa s-ărheɣ ad-has-t-zuzəyăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Innăḍ-dd Ɣisa ḍarăt-a-wen s-inəṭṭulab-net, ikkăs-tăn-dd s-takše, innʼ-asăn: «Tənḍəḍ i-tiṭṭawen ti hannăynen a-wa hannăyăm! ");
INSERT INTO taq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ăssiilmădăɣ-kăwăn a-s ăsdărhănăn ănnăbităn ăjjootnen d-imănokalăn ahănay n-a-wa hannăyăm măšan, wăr t-ənheyăn, ăsdărhănăn măsăllăt n-a-wa s-sallăm măšan, wăr has-əslen.» ");
INSERT INTO taq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A ənḍărrăn ălɣalim n-Ăṭṭăwrăt iyyăn da-dăɣ dd-inkărăn, ija i-Ɣisa asəstan dăɣ-otas irrum-net, innʼ-as: «Ălɣalim, ma s-leɣ s-ad-t-ăjăɣ i-ad-əkkusăɣ tămudre ta tăɣlălăt?» ");
INSERT INTO taq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Innʼ-as Ɣisa: «Ma iktabăn dăɣ-Ăṭṭăwrăt, ma dăɣ-s tăɣred?» ");
INSERT INTO taq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Innʼ-as ălɣalim, iktab dăɣ-s a-s: «Ad-tărhəd Emăli-năk Măssinăɣ s-ulh-năk imda, tărhəd-t s-iman-năk əmdan, d-ăṣṣahăt-năk imda d-tayətte-năk təmda, tărhəd daɣ ănhăraj-năk s-əmmək wa s-tărhed iman-năk.» ");
INSERT INTO taq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Innʼ-as Ɣisa: «Toɣadăd, ăj a-wen, ad-təddărăd.» ");
INSERT INTO taq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Măšan irha ălɣalim-en ad-ikrəš tidət ɣas, innă daɣ i-Ɣisa: «Mi ămoosăn ănhăraj-in?» ");
INSERT INTO taq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Innʼ-as Ɣisa: «Kăla dd-ătrara ăhaləs iyyăn aɣrəm wa n-Yărussălam s-wa n-Žărriko, igla har fălla-s oḍan inaɣtafăn, ohăɣăn a-wa ila, tithəkkin-t har ăktăyyăt təzzar, əšlăyăn-as. ");
INSERT INTO taq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Israd dihen-dăɣ, a-s t-dd-immar u-tikutawen dd-ijan tabarăt-ten-dăɣ, inhăy-t măšan, okăy-t šund wăr t-ihənnəy; ");
INSERT INTO taq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","immăr-t-dd iyyăn n-u-Lewi, okăy-t ənta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Măšan, immăr-t-dd u-Sămari dd-ijan tabarăt-ten-dăɣ, inhăy-t ɣas, tănɣʼ-e tăhanint-net, ");
INSERT INTO taq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","osʼ-e-hi-dd, ăsserăd ibuyəsăn-net s-əzzăyt d-asməd n-lăɣnăb, ittăl-tăn təzzar, ăsnăy-t tasnit-net, ăwwăy-t s-tăhănzabbut, iṭṭăf-as tăməzzuɣt d-tămudre. ");
INSERT INTO taq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ăffăw-t ɣas, ikfă əssin ărriyalăn n-aẓrəf ahănzabbu, innʼ-as: ‹Taɣălift-năk ăhaləs-i-dăɣ har dd-ăqqəlăɣ, a fălla-s təbxăsăd-dăɣ, afăl dd-ăqqălăɣ, ad-hak-ăẓlăɣ.› » ");
INSERT INTO taq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Innă Ɣisa ḍarăt-a-wen i-ălɣalim: «Ǝndek dăɣ-ăddinăt-wi-dăɣ n-kăraḍ wa s-torded a-s ənta a-s ănhăraj n-ăhaləs-wa oḍăn dăɣ-ifassăn n-inaɣtafăn?» ");
INSERT INTO taq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Innʼ-as: «Wa has-oḍănăn tăhanint.» Innʼ-as Ɣisa: «Adiš, əgləw kăyy-dăɣ, təjəd šund a-wen-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ifăl Ɣisa dihen ăddeew d-inəṭṭulab-net hăr dd-răsăn taɣrəmt tiyyăt dăɣ-tăn-tăsbărrăk tamăḍt s-isəm-net Marta, ");
INSERT INTO taq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","təla wălătma-s s-isəm-net, Măryăma. Tăqqiima Măryăma ɣur-ălɣalim Ɣisa, ad-sajad i-a-wa ijănna, ");
INSERT INTO taq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","a-s ija a-wen Marta ənta, tədgaẓ dăɣ-imjora n-Ɣisa. Tăhoja ɣas, təjjăš-dd fălla-săn, tənnʼ-as: «Ălɣalim, ajăn wăr kăy-ikma a-wa s-tăqqiima wălătma-ɣ wăr hi-tilal s-əššăɣəl, ănnʼ-as, ad-təbdəd tilal-ahi.» ");
INSERT INTO taq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Innʼ-as Ɣisa: «Marta, Marta! Toẓarăd dăɣ-a ăjjeen wărăn infa hărăt, ");
INSERT INTO taq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","hărăt iyyăn a ilan tənfa, wen ənta, tăsnăfrăn-t Măryăma, wăr-ilkem daɣ ad-dăɣ-s ămehăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ašăl iyyăn, itəddal Ɣisa Măssinăɣ dăɣ-edăgg iyyăn, issəmdă ɣas, innʼ-as iyyăn dăɣ-inəṭṭulab-net: «Ălɣalim, səlməd-anăɣ tamădilt n-Măssinăɣ šund a-wa ija Exya i-inəṭṭulab-net.» ");
INSERT INTO taq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Innʼ-asăn ḍarăt-a-wen: «E-d təddalăm Măssinăɣ, ănnăt: ‹Abba, səmɣărnet ăddinăt isəm-năk wa šăddijăn, taset-dd Təmmənəya-năk, ");
INSERT INTO taq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ăkfʼ-anăɣ hak ašăl isudar-nănăɣ, ");
INSERT INTO taq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ănš-anăɣ ibăkkaḍăn-nănăɣ ed năkkăneḍ-dăɣ, nənašš i-wi hanăɣ-ḍallămnen, wăr toyyed Iblis ăžžurrăbăt-anăɣ, isiḍəw-anăɣ dăɣ-abăkkaḍ.› » ");
INSERT INTO taq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Innʼ-asăn daɣ: «Təssanăm kăwăneḍ iman-năwăn a-s afăl dăɣ-wăn ila iyyăn amidi har t-osa s-ammas n-ehăḍ, innʼ-as: ‹Amidi-nin, əffəd-ahi-dd kăraḍăt tijəlwen ");
INSERT INTO taq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","făl-a-s leɣ amidi-nin s-iket dd-osa ifal-dd asikəl, ăzzubbăt ɣur-i, wăr-əleɣ a t-əššəkšăɣ›, ");
INSERT INTO taq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","təssanăm a-s wăr has-mad-ănn amidi-net: ‹Wăr hi-tăsɣăfăd, ăbas ăddobeɣ tanăkra, ehăn iɣfal ămăra-dăɣ, aratăn daɣ ənsan.› ");
INSERT INTO taq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ălleɣeɣ-awăn a-s kud-dăɣ wăr ibded i-ad-t-ăkf a-wa dăɣ-s ittăr dăɣ-idəm n-təmmidəwa ta n-jere-săn, ad-has-t-ăkf făl təssəba n-tăkrakiḍt ta mad-has-umas a-wen afăl əslăn ăddinăt i-tăkunt ta ija. ");
INSERT INTO taq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ǝnneɣ-awăn: ădəlăt Măssinăɣ, ad-kăwăn-ăkf, əmmăɣăt, ad-təjrəwăm; ăɣrăt-t, ad-hawăn-ăkawăn. ");
INSERT INTO taq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ere idălăn, ad-ikrəš, ere immăɣăn, ad-ijrəw; ere iɣrăn Măssinăɣ dăɣ-tămăɣatert t-tărmasăt, ad-has-tăt-ikkəs. ");
INSERT INTO taq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ǝndek abba dăɣ-wăn wa s-e-d t-idăl rure-s dăɣ-emăn, ad-t-ăkf taššălt? ");
INSERT INTO taq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Meɣ əndek wa s-e-d t-idăl dăɣ-tekăkit, ad-t-ăkf teẓerdəmt? ");
INSERT INTO taq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɣas kunta kăwăneḍ-i n-inăllăbăsăn, təssanăm isuf n-a-wa olăɣăn i-aratăn-năwăn, ăbʼ-ăṭṭăma n-ad-wăr kăwăn-ikfa Abba-năwăn-i ihăn išənnawăn Unfas Šăddijăn, afăl t-dălăm dăɣ-s.» ");
INSERT INTO taq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ikkăs Ɣisa ḍarăt-a-wen dăɣ-ăhaləs iyyăn alšin has-igdalăn măjrăd, izjăr-t alšin, imməjrăd ɣas, ămoos a-wen tăkunt i-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ad-jannen iyyăḍ dăɣ-săn: «A-wa tărna n-Abălzăbil, Iblis wa n-ămănokal n-alšinăn a-s itakkăs alšinăn dăɣ-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ǝttărăn wi iyyăḍnen ad-t-arəmən, ənnăn-as: «Ăj data-năɣ iji n-Măssinăɣ hanăɣ-issətbătăn a-s tidət-dăɣ a-s, Măssinăɣ a kăy-dd-ăšmašălăn.» ");
INSERT INTO taq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ilmăd Ɣisa ɣur-iman-net a-wa ihăn ənniyăt-năsăn, innʼ-asăn: «E d t-illăm əddəwəl s-dd-əqqălăn məssaw-s əknasăn jer-iman-năsăn, ad-t-iba; ehăn daɣ wa s-dd-əqqălăn məssaw-s əknasăn jer-iman-năsăn, ad-ănd. ");
INSERT INTO taq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Afăl-dd iqqăl Iblis iknas iməššerəkăn-net, əndek əmmək wa s-e-tăhaj təmmənəya-net? Wădden tənnăm năkk, tărna ta n-Abălzăbil a-s takkăsăɣ alšinăn dăɣ-ăddinăt? ");
INSERT INTO taq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kunta daɣ a-wa jănnem tidət, adiš inəṭṭulab wi-năwăn əntăneḍ, mi tăn-ikfăn tărna ta s-takkăsăn alšinăn dăɣ-ăddinăt? Inəṭṭulab-năwăn en-dăɣ a-s ilkam ad-ăjjayhən fălla-wăn, səḍləmăn-kăwăn. ");
INSERT INTO taq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Măšan, kunta năkk, tărna n-assəkăḍ n-Măssinăɣ a-s takkăsăɣ alšinăn, adiš Təmmənəya n-Măssinăɣ, təllʼ-e jere-wăn. ");
INSERT INTO taq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","A ikkʼ ăhaləs n-anăkfor ijbas făll-tăẓoli-net, iɣlaf ehăn-net, ad-ogaẓ ehăre-net ");
INSERT INTO taq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","măšan, afăl fălla-s dd-oḍa ere t-ojărăn ăṣṣahăt, ad-t-ărn, ahăɣ dăɣ-s tăẓoli-net ta făll-ăsifălla, uẓan ḍarăt-a-wen ehăre-net. ");
INSERT INTO taq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ǝlmədăt a-s ere hi-wărăn irha-dăɣ, a-di, ašănjo-nin; ere daɣ wa hi-wărăn itilal s-asdu, ašəmmăhəš ɣas a t-išlan. ");
INSERT INTO taq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","E-d izjăr alšin ăwadəm, ad-ăkk tinariwen i-ad-dăɣ-snăt immăɣ i-edăgg dăɣ-ăssunfa, afăl has-t-ăba, ad-ănn i-iman-net: ‹Năkk-i-dăɣ, ma hi-idgaẓăn, ăqqəlăɣet ɣas ehăn-in wa dd-fălăɣ.› ");
INSERT INTO taq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Afăl dd-iqqăl edăgg wa ifăl s-tizarăt, ad-t-dd-ass ifraḍ, ămmujnăt. ");
INSERT INTO taq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Igləw ălwăqq-wen, awəy-dd əssa alšinăn t-ojărnen tăllăbăst, əjjəšăn ăwadəm-ənnin-dăɣ, əzzăɣăn dăɣ-s; umas a-s talɣa n-ăwadəm-en ta tăzzarăt, təššăm i-ta təšrăyăt.» ");
INSERT INTO taq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ămmiijrăd Ɣisa dihen-dăɣ a-s təḍkăl tamăḍt tiyyăt emăsli-net dăɣ-tamətte, tənnʼ-as: «Tənḍəḍ i-tăsa ta dd-təzjărăd, tənḍəḍ i-ifăfan-wi təṭṭăḍăd.» ");
INSERT INTO taq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Innʼ-as Ɣisa: «Ănn-ak, tənḍəḍ i-wi sajadnen i-măjrăd n-Măssinăɣ, tamašalăn a-wa inna.» ");
INSERT INTO taq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Inhăy Ɣisa a-s tidawăn-dd săr-s ăddinăt ɣas, innʼ-asăn: «Ǝzzurəyăt-ta-dăɣ, tenăllăbăst, wăr təmmăɣ ɣas ar ad-ətwəjjən ijităn n-Măssinăɣ data-s măšan, təlmədet a-s wăr dăɣ-s ilkem iji n-Măssinăɣ săl wa n-ănnăbi Yunəs. ");
INSERT INTO taq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ǝmmək wa s-kăla săr-s ămoos Yunəs iji n-Măssinăɣ i-kăl-Nəniba a-s ija kăraḍ išilan dăɣ-tăsa n-emăn, əmmək-wen-dăɣ daɣ a-s mad-umas Ăgg-ăgg-adəm iji n-Măssinăɣ i-əzzurəyăt-ta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ašăl wa n-tebădde, ad-dd-tənkăr tămănokalt ta s-kăla tăxkăm făll-ăkall wa n-ajus s-isəm-net Saba, tăjjayh făll-kăl-ăzzăman-i-dăɣ, səḍləm-tăn ed, ənta făl-dd diha dd-imda ăkall i-ad-səjəd i-iməjridăn n-sărho wi ităjj ămănokal Sulăyman. Săjdăt! Ašăl-i-dăɣ, ənhəywăt-ak, illʼ-e jere-wăn ere ojărăn ămănokal Sulăyman măšan hakd a-wen-dăɣ, tunjăyăm s-asjəd-has. ");
INSERT INTO taq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ašăl wa n-tebădde, ad-dd-ənkărăn kăl-aɣrəm wa n-Nəniba, səḍləmăn kăl-əzzurəyăt-ta-dăɣ ed ašăl wa d-hasăn-ixṭăb ănnăbi Yunəs, ătubăn. Săjdăt! Ašăl-i-dăɣ, ənhəywăt-ak, illʼ-e jere-wăn ere ojărăn Yunəs măšan hakd a-wen-dăɣ, tunjăyăm s-ad-tutabăm.» ");
INSERT INTO taq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Wăr t-illa ere isarmasăn tefătelt təzzar iffăr-tăt meɣ tăt-ija daw-ăkoss, ănn-ak, aswăr a tăt-itajj edăgg iḍkalăn i-ad-hannăyăn ăddinăt wi dd-tajjăšnen ehăn ănnur-net. ");
INSERT INTO taq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tiṭṭ-năk a-s tefătelt n-taɣəssa-năk. Afăl toolaɣ tiṭṭ-năk, adiš taɣəssa-năk, hannăy iket-net măšan, afăl wăr toleɣ tiṭṭ-năk, taɣəssa-năk iket-net a ihan tihay. ");
INSERT INTO taq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ɣas he kăyy! Ăj ənniyăt i-iman-năk, wăr-itumaset ănnur-năk tihay i-taɣəssa-năk. ");
INSERT INTO taq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Afăl ha taɣəssa-năk iket-net ănnur, wăr tăt-iha făw a ihan tihay, ad-tajjăd ahănay wa tăjjăd afăl hed edăgg tăsimălăwlăw tefătelt.» ");
INSERT INTO taq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Issəmdă Ɣisa măjrăd ɣas, issəklʼ-e u-faris iyyăn ɣur-iman-net. Osă-dd Ɣisa ehăn n-u-faris ɣas, ikkʼ edăgg wa dăɣ-əskarăn imənsiwăn, ăsɣămăr dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ăkun u-faris dăɣ-a-wa s-issənta Ɣisa tetăte wăr-ăsserăd ifassăn-net s-ălxal wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Innʼ-as ălɣalim Ɣisa: «Kăwăneḍ-i n-kăl-faris, šašdajăm afălla n-kara d-ikassăn wi iyyăḍnen, a-s ija a-wen, ammas n-ulhawăn-năwăn, wăr-iḍney ar tikra d-tăllăbăst. ");
INSERT INTO taq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tidət-dăɣ a-s irmas-kăwăn iba n-tayətte! Ajăn wădden wa dd-ijăn afălla n-ăkoss, ənta daɣ a dd-ijăn ammas-net? ");
INSERT INTO taq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ăktăt a-wa ihăn karatăn-năwăn d-ikassăn-năwăn i-tilăqqiwen, dihen, ad-data-wăn išdaj hărăt iket-net. ");
INSERT INTO taq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Iməskay kăwăneḍ-i n-kăl-faris! Hakkăm s-iqqud a-wa ămoosăn tămukăst-năwăn dăɣ-ənnăɣnaɣ d-tiyəššawen-ti iyyăḍnen, a-s ija a-wen, təšlalăm-in făll-a-wa ămoosăn iqqud d-tărha n-Măssinăɣ, hărătăn-win-dăɣ a-s ăniihăjja a-s təssəntăm săr-săn, səlkəmăm-asăn amišəl n-wi iyyăḍnen olăɣnen. ");
INSERT INTO taq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Iməskay kăwăneḍ-i n-kăl-faris! Tărham tisăqqima ti ănnuflăynen dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, ijraẓ-awăn ad-hawăn-tajjăn ăddinăt isofan dăɣ-tišarriten. ");
INSERT INTO taq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Iməskay-năwăn făl-a-s, tolăhăm ɣas d-tiẓəska făll-irajjăš ăwadəm wăr-issen s-a-wen, səmməḍəsnăt-t.» ");
INSERT INTO taq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Inna iyyăn dăɣ-ălɣulam n-Ăṭṭăwrăt i-Ɣisa: «Ălɣalim, kăyy ya năkkăneḍ-dăɣ, jed-anăɣ erk măjrăd.» ");
INSERT INTO taq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Innʼ-as Ɣisa: «Iməskay kăwăneḍ-dăɣ ălɣulam n-Ăṭṭăwrăt! Sawarăm ăddinăt ăẓuk s-iẓẓəwăt aggay-net, a-s ija a-wen, wăr kăwăn-iha ad-hasăn-tilalăm s-aggay-net wăla-dăɣ s-emm n-assəkăḍ. ");
INSERT INTO taq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Iməskay kăwăneḍ-i təqqašnen iẓəkwan ăhuskătnen i-ănnăbităn wi ănɣăn abbatăn-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ǝmmək-wen-dăɣ a-s saknem a-s tărḍam s-a-wa jăn ed əntăneḍ, ănɣăn-tăn, kăwăneḍ ɣăšăm iẓəkwan-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A-wen-dăɣ a făl inna Măssinăɣ dăɣ-təmɣăre n-sărho-net: ‹Ad-săr-săn-dd-šəmmišəlăɣ ănnăbităn d-inəmmušal ăjjootnen, ad-əjən iman iyyăḍ dăɣ-săn, ăqquzzəbun wi iyyăḍnen.› ");
INSERT INTO taq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Han iman n-ănnăbităn wi ăba ɣur-sănto n-ăddunya har ašăl-i-dăɣ dăɣ-kăl-əzzurəyăt-ta-dăɣ, ");
INSERT INTO taq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","issəntă-dd a-wen ɣur-iman wi n-Xăbălla-i ăba s-tizarăt făll-ăkall-i-dăɣ har iman wi n-Zăkărya wa n-ămănokal n-kăl-tikutawen wa išrăyăn s-inɣăl ašni-net dăɣ-ehăn n-ămudd wa măqqărăn, jer-edăgg wa n-tikutawen d-edăgg wa šăddijăn. Tidət, ăssiilmădăɣ-kăwăn a-s ăddinăt-win-dăɣ, əḍmanăn iman-năsăn iket-dăɣ-năsăn dăɣ-kăl-əzzurəyăt-ta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Iməskay kăwăneḍ-i n-ălɣulam n-Ăṭṭăwrăt! Təṭṭafăm asăyar wa n-musnăt măšan, wăr ləmmədăm, ăddinăt daɣ wi ărhănen almud, tənkaẓăm-asăn-t.» ");
INSERT INTO taq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","A-s ifăl Ɣisa ehăn-ənnin-dăɣ, samădadăn ălɣulam d-kăl-faris fălla-s, tajjăn-as isəstanăn ăjjootnen ");
INSERT INTO taq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","dăɣ-otasăn ad-t-səwwənnən a wărăn oɣed, i-ad-əjrəwăn ăsaru s-t-əssəḍlămăn. ");
INSERT INTO taq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ḍarăt-a-wen, tăddew-dd tamətte-i-dăɣ tăjjet s-Ɣisa har dd-ăqqimăn ăddinăt tinməkukulăn. Innă Ɣisa i-inəṭṭulab-net s-tizarăt: «Ăjăt ənniyăt i-tăẓẓa ta n-təlmənufăɣa n-kăl-faris. ");
INSERT INTO taq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wăr t-illa a ăttunkălăn s-wădden ad-dd-infiləl, wăr t-illa a iffarăn s-wădden ad-dd-iffukkăr. ");
INSERT INTO taq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A-wen-dăɣ a făl, a tənnăm dăɣ-takše-dăɣ, ad-dd-iffukkăr, a tăsmătăktăkăm dăɣ-ammas n-ihănan-năwăn-dăɣ, ad-t-săqqəyən ăddinăt făll-afălla n-ihănan-năsăn.» ");
INSERT INTO taq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Kăwăneḍ-i n-imidiwăn-in, ənneɣ-awăn: wăr tăksuḍăm dăgg-adəm-i wăren ăddobăt ar tenăɣe n-taɣəssa-năwăn, wăr t-illa a ăddoben săl a-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ăyyăt-ahi ad-hawăn-ăllăɣeɣ ere wa s-təlam s-ad-t-tuksaḍăm: Uksaḍăt Măssinăɣ-i inaqqăn, ila daɣ ḍarăt-a-wen tărna s-kăwăn-in-ijăr dăɣ-žohănnăma, tidət, ənta-en-dăɣ a-s lam s-ad-t-tuksăḍăm! ");
INSERT INTO taq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ɣur-wăn, wădden təssanăm a-s iba n-təfărre n-tošəmba a făl hin-nazzăn səmmos dăɣ-săn sănatăt tammaten? Hakd a-wen-dăɣ, wăr tăn-iha i hin-itatăwa Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","wăr tărmeɣăm, wăla amẓadăn n-eɣăf-năwăn, ăḍinăn, tojărăm abrək n-igḍaḍ ălqim. ");
INSERT INTO taq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ălleɣeɣ-awăn a-s ere ăsjăyhăn dăgg-adəm a-s năkk a t-ilăn, ad-ăjjayhăɣ năkk-dăɣ i n-Ăgg-ăgg-adəm dat-ănjălosăn n-Măssinăɣ a-s ăwadəm-en, i-nin. ");
INSERT INTO taq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ere daɣ wa hi-ăkkuddălăn dat-dăgg-adəm, ad-t-əkkuddəlăɣ năkk-dăɣ dat-ănjălosăn n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ere innăn a lăbasăn dăɣ-isălan n-Ăgg-ăgg-adəm-dăɣ, ăddobăt ad-ijrəw tenăšše n-a-wen măšan, ăwadəm wa ăskafărăn dăɣ-isălan n-Unfas Šăddijăn, wăr-ilkem ad-has-in-ătiwănša. ");
INSERT INTO taq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Afăl tămewăyăm s-ăššăreɣa dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, meɣ daɣ dat-kăl-ăššăreɣa d-əlxəkum, wăr kăwăn-ităšăwwašet əmmək wa s-mad-təhələm iman-năwăn wăla a-wa mad-tənnəm, ");
INSERT INTO taq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","afăl ălwăqq wa d-tamăjradăm, Unfas Šăddijăn a kăwăn-e-isăɣrən ăssaɣăt-wen-dăɣ a-wa s-ănihăjja s-ad-tăn-tənnəm.» ");
INSERT INTO taq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ijanna Ɣisa a-wen-dăɣ a-s dd-iggăd ăwadəm iyyăn dăɣ-tamətte, innʼ-as: «Ălɣalim, ănn i-ăŋŋa-ɣ a dăr-i uẓan tăkasit-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Innʼ-as Ɣisa: «Ăhaləs, mi hi-ijăn ălqaḷḷi-năwăn tuẓanăɣ-awăn tăkasit.» ");
INSERT INTO taq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Inna Ɣisa i-tamətte ḍarăt-a-wen: «He kăwăneḍ! Agəẓăt iman-năwăn dăɣ-tărha n-hărăt făl-a-s, ăgg-adəm, kud-ila hărăt-dăɣ, wădden ărrəzăɣ-net a iḍmanăn tămudre-net.» ");
INSERT INTO taq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Issăɣlăy-tăn tangalt, innʼ-asăn: «Kăla t-illa ăhaləs n-amărrəzăɣ ilan išəkraš has-dd-izajjăr ălfăyda măqqoorăn. ");
INSERT INTO taq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Inhăy a-s ibbăɣăr hullan ɣas, iqqăl-dd ad-ijanna i-iman-net: ‹Năkk-i-dăɣ, ma mad-ăjăɣ, ăbas leɣ edăgg ăwwayăn əttăɣam-in?› ");
INSERT INTO taq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ijʼ ăddăbara i-iman-net, innă: ‹Ad-ărẓăɣ ijăndăn-in, sădəyăɣ i tăn-ojărnen, sădwăɣ dăɣ-săn ălkăma-nin d-a-wa leɣ iket-net, ");
INSERT INTO taq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","dihen, ad-ănnăɣ i-iman-in: Ya iman-in, sunfăt, təkšəm, təzhəm dăɣ-tănoflayt, itwar-awăn ărrəzăɣ madăn-ăj iwətyan ăjjootnen.› ");
INSERT INTO taq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Diha-dăɣ d-issəmda tənna n-a-wen, ad-has-innă Măssinăɣ: ‹Isəm n-enəbbeddəl, ad-kăy-iba ehăḍ-i-dăɣ, ɣas mi madăn-ikus a-wa ăjjen tăsdăwăd?› ");
INSERT INTO taq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Šund a-wen-dăɣ a madăn-irməs ere ijmarăn iman-net wăr-ikəttəw Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Innă Ɣisa ḍarăt-a-wen i-inəṭṭulab-net: «A-wen-dăɣ a făl hawăn-janneɣ: wăr kăwăn-jărrăwnet inəzjam n-a-wa mad-təkšəm d-a-wa mad-təswəm d-a-wa mad-təlsəm. ");
INSERT INTO taq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Iman-năwăn, ojărăn tetăte; ăssexăt n-taɣəssa-năwăn daɣ, ojăr isəlsa. ");
INSERT INTO taq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ǝkyədăt ɣas dăɣ-iẓuyaj, wăr tədumun, wăr təjlubun, wăr len timšiten wăla ijăndăn măšan, ăssodăr-tăn Măssinăɣ, tufăm-tăn s-a ăjjeen. ");
INSERT INTO taq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ǝndek ɣas dăɣ-wăn wa ăddoben s-inəzjam-net, ad-isiwəḍ taɣrəst-net wăla s-a ogdăhăn d-emm n-asənnan? ");
INSERT INTO taq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Šămad a ogdăhăn d-a-wen-dăɣ təmmətkit wăr t-tăddobem, adiš ma dăɣ-toẓarăm dăɣ-a-wa săl a-wen? ");
INSERT INTO taq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ǝkyədăt ɣas dăɣ-tadăwla n-tăboyt: wăr ẓətt, wăr ẓəmməy măšan, wălʼ ămănokal Sulăyman hakd terše-net iket-net, wăr kăla ojăr tăboyt-i-dăɣ asəssihăɣ n-ašăl. ");
INSERT INTO taq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɣas kunta Măssinăɣ isalsa teyəšše n-išəkraš s-ašăl-i-dăɣ təbdaj, ašəkka ad-hin-tărɣ dăɣ-efew s-əmmək-wen-dăɣ, ăbʼ ăṭṭăma n-ad-wăr hawăn-iẓẓəẓmăy kăwăneḍ. Təmmətkit ija immun-năwăn! ");
INSERT INTO taq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wăr kăwăn-daggăẓnet inəzjam n-a-wa mad-təkšəm d-a-wa mad-təswəm. ");
INSERT INTO taq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hărătăn-win-dăɣ, kăl-ăddunya a ɣallăbăn. Kăwăneḍ, Abba-năwăn-i ihăn išənnawăn, wăr t-illa a-s tămiɣatărăm s-wădden, issan-t. ");
INSERT INTO taq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ǝmmăɣăt s-tizarăt i-Təmmənəya n-Măssinăɣ, dihen, ad-hawăn-in-iwwaḍ a-wa iyyăḍăn. ");
INSERT INTO taq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tahrut-in ta ənḍărrăt, wăr tărmeɣăm făl-a-s, irha Abba-năwăn, ad-ăj Təmmənəya-net dăɣ-ifassăn-năwăn, ");
INSERT INTO taq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","tužžărăt-in a-wa lăm, təktəm-t i-tilăqqiwen, təjəm i-iman-năwăn aẓrəf iɣlalăn d-ijăndăn s-wăr-iɣəššəd a-wa dăɣ-săn itwărăn ed išənnawăn, wăr tăn-hen imăkrăḍăn wăla temedhe. ");
INSERT INTO taq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tidət-dăɣ a-s inəzjam n-ulh n-ăwadəm, wăr təffilăn dihad itwăr təla-net.» ");
INSERT INTO taq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ɣaymăt tasidăwăm, təjbasăm, tăssirɣăm tiftəl-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Alăhăt d-inaxdimăn əqqalnen i-măssi-săn dd-ifalăn aẓli s-tišrayăt n-ehăḍ s-ad-dd-itis ɣas, oran-as emm n-ehăn. ");
INSERT INTO taq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tənḍəḍ i-eklan-en-dăɣ dd-mad-agəẓ măssi-săn okayăn ăssaɣăt s-tăn-dd-osa-dăɣ. Ăsidătteɣ-awăn a-s afăl tăn-dd-osa, ad-ijbəs ənta iman-net, isăqqaymʼ-en, isəmmənsəw-tăn. ");
INSERT INTO taq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jer-iqqăl-dd s-tišrayăt n-ehăḍ wăla s-emăɣăr, tənḍəḍ i-inaxdimăn-wi dd-mad-agəẓ okayăn. ");
INSERT INTO taq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wădden kăwăneḍ iman-năwăn təssanăm a-s ənnăr issan măssi-s n-ehăn ăssaɣăt wa s-t-dd-itis emăkrăḍ s-ehăḍ i-ad-ărẓ ehăn-net, iket-di, wăr-itəṭṭəs i-ad-has-ărẓ emăkrăḍ ehăn-net. ");
INSERT INTO taq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kăwăneḍ-dăɣ, ɣaymăt tăsidăwăm, tăɣtafăm ed Ăgg-ăgg-adəm, ad-dd-ass s-ăssaɣăt d-wăr fălla-s jem.» ");
INSERT INTO taq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iggăd-dd Bəṭrus, innă i-Ɣisa: «Ălɣalim, năkkăneḍ ɣas a tăssiɣlăyăd tangalt-ta-dăɣ meɣ nohar-tăt d-ăddinăt-wi iyyăḍnen?» ");
INSERT INTO taq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Innʼ-as ălɣalim Ɣisa: «Ǝndek ănaxdim wa n-ăgg-ărkăwăl ijrahăn hărăt? Ǝnta-en-dăɣ a mad-isăɣləf măssi-s ehăn-net i-ad-ituẓan imənsiwăn i-inaxdimăn-wi iyyăḍnen. ");
INSERT INTO taq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tənḍəḍ i-akli wa dd-mad-agəẓ măssi-s ăddunkăt dăɣ-ălxidmăt wa dăɣ-t ija, ălwăqq s-t-dd-osa-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ăsidătteɣ-awăn a-s wen ənta, ad-t-isăɣləf măssi-s ehăre-net iket-net ");
INSERT INTO taq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","măšan, ănaxdim wa innăn dăɣ-iman-net: ‹Năkk, măssi-ɣ ăhoja-hin făll-i›, oḍa ḍarăt-a-wen dăɣ-inaxdimăn d-tinaxdimen ti iyyăḍnen, ad-tăn-itəggat, itatt, isass əlxəmăr har t-ijmăḍ ənniyăt, ");
INSERT INTO taq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ănaxdim-en, ilkam ad-t-dd-iɣdăr măssi-s dăɣ-ašăl d-ăssaɣăt d-wăr fălla-s ija, ilməd s-erk əššăɣəl wa t-išlăn a ija a-wa-dăɣ; afăl t-dd-osa, ad-t-iqquzzəbət, isărtəy-t d-inămăšrayăn dăɣ-edăgg wăr-iha ar tahăla d-aẓəmmăkărkəẓ n-isenăn făl tămujriẓt. ");
INSERT INTO taq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A-wen-dăɣ a făl ănaxdim-wa issanăn erhet n-măssi-s, ăqqima wăr t-ija, əlkamnăt dăɣ-s tiwit ăjjootnen ");
INSERT INTO taq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","măšan, ănaxdim-wa wărăn issen erhet n-măssi-s, ija a wărăn oɣed, ad-ijrəw tiwit wăren əjjət. Ere ijrawăn a ăjjen, ad-dăɣ-s itwəttar a ăjjeen, ere iɣlafăn a măqqoorăn, ad-dăɣ-s itwəttar daɣ ad-dd-ikkəs a măqqoorăn.» ");
INSERT INTO taq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Oseɣ-dd i-ad-sărɣăɣ efew făll-ăkall, ăsidărhănăɣ a-s ăru d-irɣa. ");
INSERT INTO taq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ilkam dăɣ-i atwəsəlmaɣ s-wăr mad-sunfăɣ făw wăr-ija. ");
INSERT INTO taq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ak tăɣelăm ălɣafyăt a-s dd-oseɣ i-ad-t-ăkfăɣ i-ăkall? Ăbo, ənneɣ-awăn, tăbəḍḍawt a săr-s dd-ăwwăyăɣ. ");
INSERT INTO taq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ɣur-ašăl-i-dăɣ, wăla-dăɣ ehăn han səmmos ăddinăt, ad-ənməkšărăn jer-iman-năsăn, ad-əššunjun wi n-kăraḍ wi n-əssin, əššunjun daɣ wi n-əssin wi n-kăraḍ. ");
INSERT INTO taq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ad-ibḍəw abba d-rure-s, ibḍəw alyaḍ d-ti-s, təbḍəw anna d-elle-s, təbḍəw talyaḍt d-ma-s, təbḍəw taḍăggalt d-hănne-s n-rure-s, təbḍəw tamăḍt d-taḍăggalt-net.» ");
INSERT INTO taq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Innă Ɣisa daɣ i-tamətte: «Wădden e-d tənhăyăm tejărăkt təzjar-dd s-emăynăj, ad-tənnəm: ‹Osʼ-anăɣ ajənna›, ăj a-wen s-əmmək-wa-dăɣ s-tăn-tənnăm; ");
INSERT INTO taq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","e-d tənhăyăm daɣ aḍu wa dd-ihan s-afălla, ad-tənnəm: ‹Ilkam dăɣ-năɣ ašăl ăkkuusăn›, ăj a-wen s-əmmək-wa-dăɣ s-tăn-tənnăm. ");
INSERT INTO taq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ălmunafeɣăn a tămoosăm! Kăwăneḍ-i əssănnen teɣăre n-išmal wi n-išənnawăn d-ăkall, uhən-dăɣ, indar-awăn ad-təfhəmăm ăzzăman wa fălla-wăn ijăn ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mafăl wăr tăddobem ad-təlmədăm ɣur-iman-năwăn iji n-a-wa olăɣăn? ");
INSERT INTO taq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","E-d kăy-iɣra ere kăy-ăsiwărăn uḍlem s-ăššăreɣa, əttăr əmmək s-dăr-s tănmăknăd hărwa wăr hin-tăwweḍăm ehăn wa n-ăššăreɣa, dihen, wăr mad-kăy-irməs ăgg-ăššăreɣa, ăjʼ-ik dăɣ-ifassăn n-əlxəkum ed, əlxəkum afăl təjjăšăd ifassăn-net, ad-kăy-ăj dăɣ-takărmut. ");
INSERT INTO taq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ăsidătteɣ-ak a-s edăgg-en, wăr mad-t-dd-təzjărăd a təkkăsăd wăr ẓelăd har tămma ta kăy-irwăs.» ");
INSERT INTO taq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ămmiijrăd Ɣisa hărwa a-s t-dd-osăn ăddinăt has-jănnen isălan n-aɣăras wa ija Bilatəs wa n-ămănokal n-teje ta n-Ălyăhudəyăt i-meddən n-Galila təzzar, issărtăy ašni-năsăn d-wa n-tikutawen-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Innʼ-asăn: «Ak tordam a-s kăl-Galila win-dăɣ ənhaynen tamăttant-ten-dăɣ səmmăt, ojărăn kăl-Galila-wi iyyăḍnen tumast n-inăsbăkkaḍan? ");
INSERT INTO taq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Făw, măšan, ăsidătteɣ-awăn kăwăneḍ-dăɣ, a-s afăl wăr tătubăm, ad-təjəm tamăttant šund-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Meɣ daɣ tordam a-s meddən wi n-măraw d-əttam hănen Yărussălam făll-dd-oḍa ăɣalla wa n-tăsahaɣt ta s-itawănna ta n-Silwi inɣʼ-en, tordam a-s ojărăn kăl-Yărussălam wi iyyăḍnen tumast n-inăsbăkkaḍăn? ");
INSERT INTO taq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Făw, măšan, ăsidătteɣ-awăn daɣ a-s afăl wăr tătubăm, ad-təjəm tamăttant šund-ten-dăɣ jăn.» ");
INSERT INTO taq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Issăɣlăy-tăn-dd daɣ tangalt tiyyăt dăɣ-hasăn-innă: «Kăla ăddomăt ăhaləs ašar dăɣ-ašəkrəš-net n-lăɣnăb, iwwăḍ-dd ăzzăman n-tirwe-net ɣas, osă-dd i-ad-dăɣ-s ijrəw a lăn aratăn măšan, wăr t-illa a fălla-s ijraw. ");
INSERT INTO taq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Innă i-ănaxdim n-ašəkrəš: ‹Awătay wa s-kăraḍ da-dăɣ tisăɣ-dd, jarăɣ ăṭṭăma n-ad-əjrəwăɣ aratăn dăɣ-ašar-wa-dăɣ măšan, wăr t-illa a t-dd-ijammăḍăn, ămăra, ăɣtəs-t-in ed, ăsinăkmăm edăgg bănnan.› ");
INSERT INTO taq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Innʼ-as ănaxdim: ‹Măssi-ɣ, ărheɣ dăɣ-k ad-t-təyyəd tene-ta-dăɣ ɣas, ad-ăɣəšăɣ dawa-s, ăjăɣ dawa-s ădanda, ");
INSERT INTO taq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","iha miši s-awătay wa dd-imalăn, ad-ikrəš aratăn, afăl wăr-ija a-wen, ăɣtəs-t-in.› » ");
INSERT INTO taq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ašăl iyyăn n-əssəbət, isaɣra Ɣisa dăɣ-ehăn n-ăddin wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Təllʼ-e dihen tamăḍt lat măraw iwətyan d-əttam iṭṭaf-tăt alšin tăt-ăsikărănbăyăn har ăbas tăddobăt iqqud n-tebădde-net. ");
INSERT INTO taq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Inhăy-tăt Ɣisa, iɣrʼ-et, innʼ-as: «Tamăḍt, ălɣib-năm, təbḍed dăr-s.» ");
INSERT INTO taq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ăswăr-tăt ifassăn-net, toɣăd tebădde-net ălwăqq-wen-dăɣ, ad-tiiməl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Inhăy ălfăqqi n-ehăn n-ăddin a-s ăzozăy-tăt Ɣisa dăɣ-ašăl n-əssəbət ɣas, ijjăš-t ălhăm fălla-s, inna i-tamətte: «Ajăn wădden săḍis išilan a t-əllanen i-ălxidmăt, tisăt-dd dăɣ-išilan-win-dăɣ, təyyəm-dd ass ašăl wa n-əssəbət-i n-tăsonfat.» ");
INSERT INTO taq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ăwwežăb-as Ɣisa, innʼ-as: «Ălmunafeɣăn, ajăn ihʼ-iwăn-i s-wădden itir awdes-net meɣ ešeḍ-net dăɣ-ašăl n-əssəbət i-ad-t-išrəj? ");
INSERT INTO taq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma hawăn-ijrawăn, ad-təfhamăm ašăroj n-awdes-năwăn meɣ ešeḍ-năwăn dăɣ-ašăl n-əssəbət-i n-tăsonfat, a-s ija a-wen, indar-awăn, ad-təfhəmăm azuzi wa jeɣ i-tahăyawt-ta-dăɣ n-Ibrahim lat măraw iwətyan d-əttam iṭṭaf-tăt Iblis dăɣ-tišəm-net.» ");
INSERT INTO taq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Innă Ɣisa a-wen ɣas, təlsa tăkrakiḍt imiksănăn-net iket-năsăn, tăqqăl-dd tamətte ənta, tăddiiwăt dăɣ-təssəba n-timašalen-ti ăhuskătnen ităjj. ");
INSERT INTO taq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Inna Ɣisa daɣ: «Ma dăr-tolăh Təmmənəya n-Măssinăɣ? Ma dăr-tăt-mad-səssiləhăɣ? ");
INSERT INTO taq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tolăh d-temătăwt-ta tojărăt təmmətkit ăddomăt ăwadəm dăɣ-ašəkrəš, tədwăl-dd, tăqqăl ahəšk, ad-ẓattăn igḍăḍ iskak-năsăn dăɣ-iləktan-net.» ");
INSERT INTO taq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Innʼ-asăn daɣ: «Ma dăr-e-səssilăhăɣ Təmmənəya n-Măssinăɣ? ");
INSERT INTO taq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tolăh d-takməttet n-tăẓẓa təssărtăy tamăḍt d-kăraḍ ănnăfăɣatăn n-ejel n-ălkăma i-ad-ikəf iket-net.» ");
INSERT INTO taq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ifăl Ɣisa dihen ɣas, ăllil iɣărman d-tidbi iket-năsnăt, isaɣra ăddinăt, ija tabarăt ta n-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Igla a-s has-innă ăhaləs iyyăn: «Ălɣalim, wădden ăddinăt wi maden-əjjəš ălžănnăt, wăr-əjjətăn?» ");
INSERT INTO taq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Innă Ɣisa i-tamətte: «Băllănăt i-ad-təjjăšăm s-ăṣṣahăt tămudre ta n-tidət s-emm wa kărruẓăn făl-a-s, ăsidătteɣ-awăn a-s ăddinăt ăjjootnen, ad-əttărăn ujəš-net măšan, ad-hasăn-indăr. ");
INSERT INTO taq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Afăl iɣfăl măssi-s n-ehăn tashărt n-ehăn făll-iman-net, ad-dd-təbdədăm data-s ad-tăt-takăwkawăm, ɣarrăm-t, jannem-as: ‹Măndam, măndam! Arr-anăɣ-in emm n-ehăn› măšan, ad-hawăn-ănn: ‹Ălɣafyăt-năwăn, wăr kăwăn-əzzeyăɣ, wăr əssenăɣ əndek siha s-dd-hăm;› ");
INSERT INTO taq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tənnəm-as daɣ: ‹Ajăn wădden, nohăr dăr-k išəkša d-isəswa, təssăɣrăd dăɣ-tišarriten n-iɣărman-nănăɣ?› ");
INSERT INTO taq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Măšan, ad-hawăn-ănn: ‹Ya inăsbăkkaḍăn-i-dăɣ, năkk ya wăr kăwăn-əzzeyăɣ, ăjəjăt-ahi.› ");
INSERT INTO taq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ašăl-wen-dăɣ, ad-tăj tahăla d-aẓəmmăkărkəẓ n-isenăn făl tămujriẓt, ed ad-tənhəyăm Ibrahim d-Isxaqq d-Yaqub d-ănnăbităn iket-dăɣ-năsăn ăqqiimăn dăɣ-Təmmənəya n-Măssinăɣ, a-s ija a-wen kăwăneḍ, ejer a-hin-mad-tətwəjjəm dăɣ-žohănnăma.» ");
INSERT INTO taq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","«Ašăl-en, ad-dd-əfələn ăddinăt emăynăj d-atăram d-afălla d-ajus, ănɣəymən dăɣ-amăjaru wa madăn-ăj dăɣ-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ašăl-en, ənhəywăt! Wi hănen ajilal, ad-izarăn, wi ăzzarnen, ad-əjjəšăn ajilal.» ");
INSERT INTO taq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ohăẓăn-t-dd hărăt dăɣ-kăl-faris, ənnăn-as: «He kăyy, jawăḍ făl-a-s, irha Harudəs ad-ăj iman-năk.» ");
INSERT INTO taq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Innʼ-asăn: «Ăglăt, ănnăt i-isəm n-ebăgg-di a-s năkk, takkăsăɣ alšinăn dăɣ-ăddinăt, zizuyăɣ ašăl-i-dăɣ d-ašəkka, ašăl wa s-kăraḍ, ad-imdəw a-wa hi-išlăn. ");
INSERT INTO taq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ădduuttăt a-s əkkeɣ Yărussălăm ašăl-i-dăɣ d-ašəkka d-ašăl-wen făl-a-s, wăr-ămmukkăn ad-ibʼ ănnăbi dăɣ-edăgg săl Yărussălam.» ");
INSERT INTO taq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Innă Ɣisa: «Yărussălam, ya Yărussălam! Tamăskoyt kămm-i tăjjăt iman n-ănnăbităn, hakkăd sămmăjori n-tihun inəmmušal wi săr-m dd-ăšmašăl Măssinăɣ, əndek ɣas a-wa-dăɣ wăr jeɣ dăɣ-utăr n-asdu n-imuzăɣăn-năm šund a-wa tăjj tekăzzit i-ikărtăn-net daw-tafriwen-net măšan, təssəndărăd-ahi. ");
INSERT INTO taq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ămăra, isălan əmdăn, ad-kăwăn-ăyy Măssinăɣ d-iman-năwăn, umas aɣrəm-năwăn timšar, wăr-ilkem ad-hi-tənhayăm hundăɣ har ašăl wa d-mad-taləsăm tənna n-a-s: ‹Năkfet wa dd-osăn dăɣ-isəm n-Emăli semɣar.› » ");
INSERT INTO taq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ašăl iyyăn daɣ n-əssəbət-i n-tăsonfat, ikla Ɣisa ɣur-iyyăn dăɣ-imănokalăn n-kăl-faris, jan-as dihen ăddinăt iket-năsăn ənniyăt. ");
INSERT INTO taq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A ənḍărrăn ăhaləs iyyăn da-dăɣ s-ăsilăfafăɣnăt tikussawen taɣəssa-net iket-net, ");
INSERT INTO taq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","issəstăn Ɣisa kăl-faris d-ălɣulam-wi t-əllănen dihen: «Ak xălal meɣ xăram, ad-izuzəy ăwadəm ămarhin dăɣ-ašăl n-əssəbət-i n-tăsonfat?» ");
INSERT INTO taq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wăr t-illa a has-ənnan ɣas, iḍăs ămarhin, ăzozăy-t, issəglʼ-e. ");
INSERT INTO taq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Innʼ-asăn ḍarăt-a-wen: «Ǝndek dăɣ-wăn wa s-afăl oḍa rure-s meɣ awdes-net dăɣ-anu ašăl wa n-əssəbət-i n-tăsonfat ad-t-ăyy dăɣ-s har akəy ašăl-en təzzar?» ");
INSERT INTO taq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ăbă-hasăn-dd a has-ənnăn. ");
INSERT INTO taq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ijrăh-in Ɣisa asənnəfrən wa tăjjăn imăjarăn i-idăggan wi ănnuflăynen dăɣ-ehăn ɣas, issăɣlăy ăddinăt-wi dd-əklănen dihen tangalt, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«E-d kăwăn-ăsmăjarăt ăwadəm s-edăgg n-aẓli, wăr tăsnăfrănăm idăggan-wi t-əllănen s-data ed, ăddobăt ad-dd-ass ăwadəm kăwăn-ojărăn atwəsəmɣăr, ");
INSERT INTO taq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ănnʼ-awăn măssi-s n-ehăn, ad-tənkărăm, təkfəm-t edăgg. Ad-hawăn-umas a-wen tăkrakiḍt ed, ad-kăwăn-təhhuššəl tebădde dat-ăddinăt iket-năsăn, tăqqəlăm ḍara-săn. ");
INSERT INTO taq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ufa a-s kăwăn-dd-ăsmăjarăt ăwadəm, ad-təkkəm ḍarăt ăddinăt iket-năsăn, tăqqayməm, dihen, afăl dd-ijjăš măssi-s n-ehăn, inhăy dihad tăqqimăm, ad-kăwăn-dd-iɣăr, ănnʼ-awăn: ‹Ǝyyăwăt, ɣaymăt s-data.› Ad-hawăn-umas a-wen semɣar măqqoorăn dat-ăddinăt wi dăr-tăniɣăymăm. ");
INSERT INTO taq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ere iḍkălăn iman-net ad-irəs, ere ăsrăsăn iman-net, ad-itwəsəmɣăr.» ");
INSERT INTO taq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Innă Ɣisa ḍarăt-a-wen i-u-faris wa t-dd-ăsmăjaren: «E-d dd-simjurud ăddinăt s-ehăn-năk, s-ašăl wăla s-ehăḍ, wăr dd-tăsmăjared imidiwăn-năk d-ayətma-k d-išăqqaɣăn-năk d-ănhărajăn-năk wi lănen hărăt făl-a-s, əntăneḍ, ăddooben ad-hak-dd-suɣələn azăbăna, ");
INSERT INTO taq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ănn-ak, e-d, tărhed asəmməjəru n-ăddinăt, ăɣăr-dd tilăqqiwen d-imăsjătăɣăn d-inəbdan d-iməddorɣal. ");
INSERT INTO taq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tənḍəḍ-ak ed, əntăneḍ wăr-ăddoben ad hak-əẓələn ălxer wa hasăn-jed, Măssinăɣ a ɣur-hak-t-əllan imraš n-a-wa jed ašăl wa n-tebădde.» ");
INSERT INTO taq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Islʼ iyyăn dăɣ-imăjarăn i-a-wa inna Ɣisa ɣas, innʼ-as: «Tənḍəḍ i-ere wa madăn-ăkš dăɣ-imjora-wi madăn-ăj dăɣ-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Innʼ-as Ɣisa: «Kăla t-illa ăhaləs ijăn amăjaru-i-dăɣ măqqărăn, ăsmăjarăt-dd săr-s ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ămmujnen imənsiwăn ɣas, ăšmašăl ănaxdim-net s-ăddinăt wi dd-iɣra i-ad-hasăn-ănn: ‹Hărătăn ămmujnen, tăwwăɣăm-anăɣ› ");
INSERT INTO taq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","măšan, ăssălăhăn-as isoran iket-dăɣ-năsăn. Innʼ-as wa ăzzarăn: ‹Iket əžžənšăɣ ašəkrəš, ărheɣ ad-t-asăɣ, ənhəyăɣ-t təzzar, ănšʼ-ahi-dd.› ");
INSERT INTO taq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Inna wa iyyăḍăn: ‹Iket əžžənšaɣ măraw iwdesăn-wi s-mad-ăxdəmăɣ išəkraš-in, ărheɣ ad-tăn-arəmăɣ təzzar, ănšʼ-ahi-dd.› ");
INSERT INTO taq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Innʼ-as wa s-kăraḍ: ‹Iket dd-əẓẓəẓlăyăɣ, wăr-ăddobeɣ ad-hin-asăɣ.› ");
INSERT INTO taq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Iqqăl-dd akli, ijʼ isălan i-măssi-s ɣas, ijjăš-t ălhăm făll-ăddinăt-win-dăɣ; innă i-ănaxdim-net ămăra: ‹Ašəl šik, ilal tišarriten, təlwəyăd-dd tilăqqiwen d-inaɣyabăn d-iməddorɣal d-imăsjătăɣăn.› ");
INSERT INTO taq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Iglʼ ănaxdim, iqqăl-dd, inna i-măssi-s: ‹Măssi-ɣ, a-wa tənned ija măšan, ehăn, ihʼ e edăgg hărwa.› ");
INSERT INTO taq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Innʼ-as măssi-s: ‹Ǝqqəl šik, ilal tišarriten, ăkk attayăn n-ifərjan, šəhhəššəl ăddinăt ad-dd-asən i-ad-iḍnəy ehăn-in. ");
INSERT INTO taq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ǝḍmanăɣ-awăn a-s meddən-winnin-dăɣ dd-ăsmăjareɣ s-tizarăt, wăr tăn-e-ijjəš-i madăn-ikrəbbət imənsiwăn-in.› » ");
INSERT INTO taq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Innăḍ-dd Ɣisa s-tamətte ta tăjjet has-təlkămăt, innă: ");
INSERT INTO taq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ere irhăn alkum-hahi, a-s ija a-wen, wăr tojer tărha ta hi-ija ta ija i-abba-net, d-anna-net, d-hănne-s, d-aratăn-net, d-ayətma-s, d-šătma-s d-iman-net, wăr-ăddobăt ad-umas ănăṭṭalib-in. ");
INSERT INTO taq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ere wărăn ăsdăw i-alənji n-tajəttewt-net ta n-tamăttant i-ad-hi-ilkəm, wăr-ăddobăt ad-umas ănăṭṭalib-in. ");
INSERT INTO taq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ǝndek dăɣ-wăn wa s-wădden afăl irha edey n-ehăn, ad-ăqqayəm təzzar ixsəb ălqim n-a-wa dăɣ-s mad-ăkš təzzar isănt edey-net, ");
INSERT INTO taq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","afăl wăr ija a-wen, ad-isănt ăssas n-ehăn, indăr-as ad-t-in-isəmdəw, əjən-t ăddinăt tadăẓẓa ");
INSERT INTO taq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ed, ad-ənnən: ‹Wa ăwadəm, issəntă edey n-ehăn, indăr-as ad-t-in-isəmdəw.› ");
INSERT INTO taq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ajăn wădden e-d irha ămănokal ad-ijăḍ amidi-net, ad-issən ăddobăt ad-ikrəš fălla-s ašăl ənta-i ilăn măraw afḍăn n-ăhaləs făll-ămănokal wa dăr-mad-iknəs-i ilăn ənta sănatăt timərwen n-efăḍ n-ăhaləs. ");
INSERT INTO taq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Afăl inhăy a-s a-wen wădden a dăr-ăddobăt amjăr, ad-išəmmišəl săr-s ălžămaɣăt n-ălxer, ittăr dăɣ-s əmmək n-ălɣafyăt hărwa-dăɣ ogaẓ. ");
INSERT INTO taq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","A-wen-dăɣ a făl hawăn-janneɣ, ere wa dăɣ-wăn wărăn iksen a-wa ila iket-net, wăr-ăddobăt ad-umas ănăṭṭalib-in. ");
INSERT INTO taq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tesəmt, hărăt olaɣăn măšan, afăl tăt-təjmăḍ temḍe-net, ma s-tăt-e-isəsməm ăwadəm? ");
INSERT INTO taq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ad-ăbas tənfa ăkall wăla ădanda, ad-hin-tăḍf ɣas. Ere ilăn timəẓẓujen s-islă-dăɣ, isăjdet!» ");
INSERT INTO taq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tisən-dd inarmasăn n-tiwse d-erk ăddinăt ăjjootnen Ɣisa i-ad-has-əslən. ");
INSERT INTO taq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ǝnhăyăn kăl-faris d-ălɣulam n-Ăṭṭăwrăt a-wen ɣas, ad-simtəktikăn, jannen: «Ak, təjrahăm-in anɣim d-tihra ta ităjj d-erk ăddinăt?» ");
INSERT INTO taq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Issăɣlăy-tăn-dd Ɣisa tangalt dăɣ-hasăn-inna: ");
INSERT INTO taq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ǝndek dăɣ-wăn wa s-afăl ila temeḍe n-tehăle har dăɣ-snăt tăssujjăl tiyyăt, wădden ad-ăyy ti n-təẓẓayăt timərwen d-təẓẓayăt əfradnăt, igləw, isəssəjjəl ta dăɣ-s ăba har tăt-dd-ijrəw? ");
INSERT INTO taq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Afăl tăt-dd-ijrăw, ad-tăt-isəwăr iẓerhan-net ikna tedăwit, ");
INSERT INTO taq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","afăl hin-iwwăḍ ihănan, ad-dd-iɣăr imidiwăn-net d-ănhărajăn-net, ănnʼ-asăn: ‹Ǝyyăwăt, ăhrăt dăr-i tedăwit, tehăle-nin ta tăssujjălăt, əjrăwăɣ-tăt-dd.› ");
INSERT INTO taq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","S-əmmək-wen-dăɣ daɣ a făl, ăssiilmădăɣ-kăwăn a-s, ad-tajăr tedăwit ta madăt-tăj dăɣ-išənnawăn dăɣ-təssəba n-iyyăn anăsbăkkaḍ ătubăn, uhən i-təẓẓayăt timərwen n-ăwadəm d-təẓẓa ɣur-ija a-s, wăr-ămɣatărăn s-tătubt. ");
INSERT INTO taq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wădden daɣ afăl la tamăḍt măraw ărriyalăn n-aẓrəf hundăɣ har dăɣ-săn ăbʼ iyyăn, ad-sărməs tefătelt, ad-tišriwit ăkall n-ehăn, tiskənsəkit-t hundăɣ har dd-təjrəw ărriyal-net wa ăba? ");
INSERT INTO taq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Afăl t-dd təjrăw, ad-dd-sədəw timidiwen-net d-tănhărajen-net, tănnʼ-asnăt: ‹Ahărmăt dăr-i tedăwit, ed ărriyal-in wa ăba, əjrăwăɣ-t-dd.› ");
INSERT INTO taq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A-wen-dăɣ a făl hawăn-ălleɣeɣ a-s, tămoos tătubt n-anăsbăkkaḍ iyyăn əssəbab n-tedăwit măqqoorăt i-ănjălosăn n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Innʼ-asăn Ɣisa daɣ: «Kăla t-illa ăhaləs ilan əssin aratăn. ");
INSERT INTO taq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ašăl iyyăn, osă-dd wa ənḍărrăn ti-s, innʼ-as: ‹Abba, akfʼ-ahi ejădăr-in dăɣ-tăkasit.› Ăẓun ti-săn a-wa ila jere-săn. ");
INSERT INTO taq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hărăt n-išilan ḍarăt-a-wen, ăttužžăr-in wa ənḍărrăn ejădăr-net, irmăs aẓrəf-net, ikkʼ ăkall iyyăn ujəjăn, ăllil iẓəjraẓ n-iman-net, ad-ibaxxăs a-wa ila. ");
INSERT INTO taq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ălwăqq wa d-ikkəykăy a-wa iṭṭăf, oḍă-dd laẓ făll-ăkall wa iha iket-net, toɣăy-as tămăɣatert. ");
INSERT INTO taq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Igla, ixdăm ɣur-iyyăn dăɣ-kăl-ăkall, ăssokʼ-e ăgg-ăkall išəkraš-net i-ad-dăɣ-săn iḍən əlxənžărăn. ");
INSERT INTO taq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ijʼ-as laẓ asəmmănənnăḍ wa-dăɣ făl dd-iqqăl isadărhan tetăte n-išəkša-wi-dăɣ tattăn əlxənžărăn măšan, wăr t-ikfa măssi-săn turhajăt n-a-wen. ");
INSERT INTO taq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ǝqqălăn-t-dd iman-net ašăl iyyăn, ăznăzjamăt, innă: ‹Năkk-i-dăɣ, ma hi-ijăn dăɣ a-wa? Ajăn wădden a-wa ila abba-nin dăɣ-inaxdimăn ijarrăw a ikša har t-isəssikəy, uhən-dăɣ năkk, năkk-da-dăɣ, isimnənniḍ-ahi laẓ; ");
INSERT INTO taq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ăddăbara, ad-ənkărăɣ, ăqqəlăɣ abba-nin, ănnăɣ-as: Abba, ănmăšrăyăɣ i-Măssinăɣ, ăbodărăɣ-kăy, ");
INSERT INTO taq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ăbas ăniihăjjăɣ d-ad-itwənn rure-k a ămoosăɣ, ăjʼ-ahi iyyăn dăɣ-inaxdimăn-năk.› ");
INSERT INTO taq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ibdăd, iqqăl ăkall wa iha ti-s. Ikkă-dd ehăn dăɣ-ijəj a-s t-ojja ti-s, tănɣʼ-e tăhanint-net, ošăl săr-s, orʼ-as ifassăn-net, oḍă dăɣ-săn, ad-t-itisəs dăɣ-ijərjar-net, itiməllut-as. ");
INSERT INTO taq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Innă alyaḍ ălwăqq-wen i-ti-s: ‹Abba, ănmăšrăyăɣ i-Măssinăɣ, ăbodărăɣ-kăy, ăbas ăniihăjjăɣ d-ad-itwənn năkk rure-k.› ");
INSERT INTO taq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iɣră-dd ti-s inaxdimăn-net, innʼ-asăn: ‹Ašəlăt tărmaḍ, awəyăt-dd anăkăbba wa ufăn, təjəm-as-t, ăjăt taḍhot dăɣ-assəkăḍ-net, təkfəm-t tifădelen ăynaynen, ");
INSERT INTO taq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ărməsăt-dd ašjăr wa ojărăn tadhont, tăɣrəsăm-as, ăjet amăjaru d-ăzzăho ");
INSERT INTO taq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","făl-a-s rure-ɣ wa s-kăla ămmut iddăr-dd, kăla ăssujjăl măšan, ittəjrăw-dd.› Ǝssəntăn eqqas d-tiɣləla ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","A-s ităjj a-wen, rure-s wa n-teɣăfădde ihʼ išəkraš. Ikka-dd dihen a-s isla i-tandiwen d-tihărdănen d-isuhaɣ əkkan išənnawăn, ");
INSERT INTO taq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","iɣră-dd iyyăn dăɣ-inaxdimăn, issəstăn-t d-a-wa ijăn, ");
INSERT INTO taq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","innʼ-as ănaxdim: ‹Ăŋŋa-k, ad-dd-iqqălăn, inɣʼ-as ti-k ašjăr wa iddăren ed, iqqăl-t-dd rure-s, iddar-iɣlas.› ");
INSERT INTO taq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ojăl, unjăy s-ad-dd-ijjəš ehăn. Ikkʼ-e-hi-dd ti-s, ad-t-isalɣad. ");
INSERT INTO taq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Inna i-ti-s: ‹Wădden năkk, a ilan iwətyan əšɣalăɣ-ăk, wăr kăla ănmăšrăyăɣ i-a hi-tənned măšan, wăr kăla hi-təkfed wăla dăɣ-eɣăyd s-əkleɣ năkk d-imidiwăn-in ");
INSERT INTO taq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","măšan, iqqăl-dd rure-k wa hin-ibxăsăn aẓrəf-năk dăɣ-tălkăxbaten ɣas, tăɣrăsăd-as i-ašjăr-wa iddăren.› ");
INSERT INTO taq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Innʼ-as ti-s: ‹Alyaḍ-in, kăyy, wăr kăla hi-fălăd, a-wa əleɣ iket-net i-năk ");
INSERT INTO taq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","măšan ašăl-i, ăniihăjja s-ad-năj amăjaru d-ăzzăho, făl-a-s ăŋŋa-k wa s-kăla ămmut, iddăr-dd, kăla ăssujjăl măšan, ittəjrăw-dd.› » ");
INSERT INTO taq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Innă Ɣisa daɣ i-inəṭṭulab-net: «Kăla t-illa ăhaləs n-amărrəzăɣ dd-osăn ăddinăt, əjăn dăɣ-s isălan n-əmmək wa s-ibaxxăs ănaẓraf-net ehăre-net. ");
INSERT INTO taq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Issăɣrʼ-e-hi-dd, innʼ-as: ‹Kăyy, ma ămoos a-wa sallăɣ fălla-k? Siḍən-ahi ehăre-nin ed, ăbas ărheɣ əššăɣəl-năk.› ");
INSERT INTO taq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Innă ănaẓraf ălwăqq-wen-dăɣ dăɣ-iman-net: ‹Ǝndek a-wa mad-ăjăɣ afăl hi-ikkăs măssi-ɣ dăɣ-ălxidmăt? Ajăyak n-išəkraš, wăr t-ăddobeɣ, tamădilt daɣ tăsikărakăḍ-ahi. ");
INSERT INTO taq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ǝssanăɣ a-wa he-ăjăɣ s-kud-dăɣ ikkăs-ahi măssi-ɣ dăɣ-əššăɣəl, ad-hi-siməjurun ăddinăt dăɣ-ihănan-năsăn›. ");
INSERT INTO taq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Issăɣră-dd ăddinăt wi irwăs măssi-s iket-năsăn, innă i-wa ăzzarăn: ‹Kăyy, maniket kăy-irwăs măssi-ɣ?› ");
INSERT INTO taq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Innʼ-as: ‹Temeḍe n-bărgo n-əzzăyt›. Innʼ-as ănaẓraf: ‹Tăkarḍe-năk da ta n-ămarwas, ɣayəm, əktəb šik fălla-s, səmmosăt timərwen n-bărgo.› ");
INSERT INTO taq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Innă i-wa iyyăḍăn: ‹Kăyy-i-š, ma kăy-irwas măssi-ɣ?› Innʼ-as: ‹Temeḍe n-šaku n-ălkăma.› Ikfʼ-e-hi-dd ənta-dăɣ ălkaḍ-net wa n-ămarwas d-aɣănib, innʼ-as: ‹Ǝktəb: əttamăt timərwen n-šaku.› ");
INSERT INTO taq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Islă măssi-s n-ehăre i-amsud n-ănaẓraf-net ɣas ad-t-itiməl.» Inna Ɣisa daɣ: «Ădduuttăt a-s inəẓẓulam n-ăzzăman-i-dăɣ, ojărăn imakṣaḍăn n-Măssinăɣ amsud.» ");
INSERT INTO taq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Olăs daɣ, innʼ-asăn: «Ăjăt imidiwăn s-ehăre wa xăramăn n-wălăt-ăddunya-ta-dăɣ n-ămăra, dihen, afăl fălla-wăn tăt-ăba, ad-təjrəwăm irošan n-a-wen dăɣ-tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wa iɣdălăn dăɣ-a-wa wărăn făror, ad-iɣdəl daɣ dăɣ-a-wa ăjjen, wa wărăn iɣdel dăɣ-a-wa wărăn făror, wăr mad-iɣdəl daɣ dăɣ-a-wa ăjjen. ");
INSERT INTO taq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Afăl wăr tăɣdelăm dăɣ-ărrəzăɣ wa xăramăn n-ăzzăman-wa-dăɣ wărăn infa hărăt, mi kăwăn-madăn-isăɣləf ărrəzăɣ wa n-tidət ihăn ăddunya ta təlkămăt. ");
INSERT INTO taq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Afăl wăr tăɣdelăm dăɣ-ehăre n-ăddinăt wa kăwăn-əssăɣlăfăn, mi kăwăn-madăn-isăɣləf wa mad-təkrəšăm dăɣ-ăddunya-ta dd-malăt. ");
INSERT INTO taq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wăr t-illa ănaxdim ăddooben ad-ixdam i-əssin imălan; iyyăt-i-dăɣ, ad-akəḍ d-iyyăn, ărh wa iyyăḍăn, meɣ daɣ, ikfʼ-iman-net i-iyyăn, iksən wa iyyăḍăn. Wăr-ăddobăt ăwadəm ad-ixdam i-Măssinăɣ, ošal daɣ ḍarăt terše n-aẓrəf.» ");
INSERT INTO taq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ija Ɣisa măjrăd-wen-dăɣ ɣas, jăn-t kăl-faris tekăškăšt ed, əntăneḍ əknan tărha n-aẓrəf. ");
INSERT INTO taq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Innʼ-asăn Ɣisa: «Kăwăneḍ, jam iman-năwăn ăddinăt oɣadnen dat-dăgg-adəm, măšan, Măssinăɣ issan a-wa ihăn ulhawăn-năwăn făl-a-s, a-wa ăsihăsken dăgg-adəm, tajləlheyt ɣur-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ăzzăman wa n-alămăr wa n-Mosa d-əlkəttabăn wi n-ănnăbităn, ibdăd ɣur-ănnăbi Exya wa Enəsselmăɣ, a ija a-wen-dăɣ, titwəjjin isălan n-Ălənžil wa n-Təmmənəya n-Măssinăɣ, tattărăn ăddinăt ujəš-net s-ăṣṣahăt-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ojăr tărăɣse ija ad-iba išənnawăn d-ăkall uhən, ad-iba wăla-dăɣ tătbăqqet tiyyăt ɣas dăɣ-alămăr n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ere hin-ăzmăzzăyăn hănne-s, olăs adubən n-iyyăt, ilmədet a-s izna, ere daɣ wa ădobănăn tamăḍt dd-tămmizzăyăt, ilmədet a-s izna ənta-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Innʼ-asăn daɣ: «Kăla t-illa ăhaləs n-amărrəzăɣ s-hak ašăl ăsisahăɣ ašăl dăɣ-isəlsa wi ăsmăɣmăɣnen, lănen ălqim, izha, ănnuflăy, ăyyiwăn. ");
INSERT INTO taq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A-s ităjj a-wen-dăɣ, insʼ ăhaləs n-talăqqe s-isəm-net Lazar dat-emm n-ehăn-net, əlsanăt tikussawen dăɣ-iffay arəssuḍ elăm-net. ");
INSERT INTO taq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A-wa has-ija əllăqqu, isadărhan ad-ăkš a-wa dd-ititrəkkin dăɣ-imənsiwăn wi itătt amărrəzăɣ măšan, wăr t-ijărrəw; ăddeew-as a-wen d-afḍărfăḍăr wa jănăt tikussawen făll-taɣəssa-net hundăɣ har dd-əqqălăn iyyăḍan tallăɣăn-tănăt. ");
INSERT INTO taq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Har ašăl wa d-tămmut talăqqe, ăwwăyăn-tăt ănjălosăn s-Ibrahim dăɣ-ălžănnăt, ămmut amărrəzăɣ ənta-dăɣ, iẓka. ");
INSERT INTO taq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iha tisənsa ti n-žohănnăma-en-dăɣ ihannăy aɣăna a-s iḍkăl asăwaḍ-net, ojjʼ Ibrahim illʼ-e Lazar edes-has. ");
INSERT INTO taq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ad-iɣar Ibrahim, ijannʼ-as: ‹Yʼ Abba Ibrahim, aḍən-ahi tăhanint, šəmmišəl-dd săr-i Lazar i-ad-isəlmăɣ emm n-assəkăḍ-net dăɣ-aman, isəsmăḍ iləs-in făl-a-s, ăsrăkăttăt-ahi efew wa heɣ.› ");
INSERT INTO taq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Innʼ-as Ibrahim: ‹Alyaḍ-in, əktəw-dd a-s kăyy, tărzăɣăd hullan dăɣ-tămudre-năk, a-s ija a-wen, Lazar, wăr-inhey a săl aɣăna, ămăra, ənta a ăssismăḍăn, ănnuflăy, a-s ija a-wen kăyy, tiknənnəwid; ");
INSERT INTO taq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ḍarăt-a-wen daɣ, illʼ-e eɣăy wărăn ila ider jere-năɣ dăr-wăn, wăr-ăddoben wi n-ɣur-năɣ, ad-kăwăn-in-əkkən, wăr-ăddoben daɣ wi n-ɣur-wăn, ad-hanăɣ-dd-əkkən kud-tărham-dăɣ.› ");
INSERT INTO taq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Innʼ ăhaləs ămăra: ‹Adiš abba, dalăɣ-kăy d-ad-šəmmišəlăd Lazar s-ehăn n-abba-nin ");
INSERT INTO taq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","făl-a-s, leɣ səmmos ăŋŋatăn i-ad-tăn-isəmmətăr, udaɣ ad-dd-əjjəšăn edăgg-wa-dăɣ n-tissust.› ");
INSERT INTO taq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Innʼ-as Ibrahim: ‹Wădden lan Mosa d-ănnăbităn-wi iyyăḍnen, səjədnet-asăn.› ");
INSERT INTO taq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Inna i-Ibrahim: ‹Ăbo! Abba Ibrahim, afăl tăn-dd-iqqăl ere dd-inkarăn jer-inəmmuttan, imməjrăd-asăn, ad-utabăn.› ");
INSERT INTO taq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Innʼ-as Ibrahim: ‹Afăl wăr-ăsjădăn i-ănnăbi Mosa d-ănnăbităn wi iyyăḍnen, wăr mad-utabăn kud-hasăn-ija ăwadəm dd-inkarăn jer-inəmmuttan isălan-dăɣ.› » ");
INSERT INTO taq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Innă Ɣisa ḍarăt-a-wen i-inəṭṭulab-net: «Tanməšrayt, ad-tajj ɣas, măšan, iməskay kăl-əssəbab-net. ");
INSERT INTO taq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wa has-issəbăbăn, iššăm-as-in, ad-tətwăqqən tăhunt ta s-itəẓẓad ălkăma dăɣ-err-net, itwəjăr-in dăɣ-ejărew wa səmmăn, uhən ad-umas əssəbab n-tanməšrayt i-iyyăn dăɣ-inəṭṭulab-in. ");
INSERT INTO taq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ăjăt ənniyăt i-iman-năwăn: afăl kăy-iḍlăm ăŋŋa-k, ăɣtəl-t, kunta ămmujrăẓ, ănšʼ-as. ");
INSERT INTO taq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Afăl hak-ija əssa uḍlemăn dăɣ-ašăl, ijʼ-ak-dd əssa uɣlawăn dăɣ-dăɣ-k itattăr tenăšše, ănšʼ-as.» ");
INSERT INTO taq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ǝnnăn inəmmušal i-Ɣisa: «Ălɣalim, siwəḍ immun-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Innʼ-asăn Ălɣalim Ɣisa: «Afăl lam immun ogdăhăn d-temătăwt ta tojărăt təmmətkit dăɣ-idommăn, ad-tudabem ad-tənnəm i-ahəkš-wa-dăɣ: ‹Ǝlbəy-dd iman-năk, săɣtəd-tăn dăɣ-ejănš›, ad-ăj a-wa has-tənnăm. ");
INSERT INTO taq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ǝndek dăɣ-wăn wa s-afăl t-dd-odwa akli-net wa ăssixdăm dăɣ-ašəkrəš-net, meɣ wa ăsḍăn arəzzej-net, ad-has-ănn: ‹Ǝyyăw mănsăw›, ");
INSERT INTO taq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","wădden a has-mad-ănn: ‹Săŋŋʼ-ahi-dd a əkšeɣ, təjəd isəlsa-năk wi n-ălxidmăt, təkfəd-ahi amənsi har ăkšăɣ, ăswăɣ təzzar, təkšəd, təswəd kăyy.› ");
INSERT INTO taq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tordam a-s ăhaləs-en-dăɣ, illʼ-e a mad-umay i-akli-en-dăɣ, ijăn a-wa t-iwarăn? ");
INSERT INTO taq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kăwăneḍ-dăɣ, e-d jăm a-wa s-hawăn-ătwănnă, ănnăt: ‹Năkkăneḍ, jer-t-nəlla wăla wăr t-nəlla, eklan ɣas a nămoos, wăr nəja ɣas ar a-wa hanăɣ-iwarăn.› » ");
INSERT INTO taq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ălwăqq wa d-ikka Ɣisa Yărussălam, ăllil zăbo wa ikkăn jer-teje ta n-Sămari d-ta n-Galila. ");
INSERT INTO taq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ijjăš-dd tadăbayt tiyyăt ɣas, əlkăḍăn-as-dd măraw meddən ijraw jəri, əbdădăn-as dihen, ");
INSERT INTO taq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","əḍkălăn imăslan-năsăn, ənnăn-as: «Ălɣalim Ɣisa! Aḍən-anăɣ tăhanint.» ");
INSERT INTO taq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Inhăy-tăn, innʼ-asăn: «Ăglăt, săknăt iman-năwăn i-kăl-tikutawen.» Ǝglan hărwa a-s əzzăyăn iket-năsăn, šăddijăn. ");
INSERT INTO taq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Inhăy iyyăn dăɣ-săn a-s izzăy ɣas, iqqăl dăɣ-adăriš-net, iḍkăl emăsli-net, ad-itiiməl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Osă-dd, irkăɣ dat-Ɣisa, ad-has-itumay, ăhaləs-en, i n-teje ta n-Sămari. ");
INSERT INTO taq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Innă Ɣisa: «Ajăn wădden măraw meddən a əzzăynen, ma jăn təẓẓa wi iyyăḍnen? ");
INSERT INTO taq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ɣas wăr tăn-dd-izjer făw ere dd-iqqalăn i-ad-aməl Măssinăɣ ar amăjar-wa-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Innă Ɣisa i-ăhaləs ḍarăt-a-wen: «Ǝbdəd, əgləw, iɣlăs-kăy immun-năk.» ");
INSERT INTO taq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ǝssəstănăn kăl-faris Ɣisa, ənnăn-as: «Ǝmme dd-mad-təzzubbət Təmmənəya n-Măssinăɣ?» Innʼ-asăn: «Təmmənəya n-Măssinăɣ, wăr mad-dd-tăj ass ilan mănhoy, ");
INSERT INTO taq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","wăr mad-itwənn: ‹Ǝnta da›, wăla: ‹Ǝnta den›, făl-a-s ădduuttăt a-s, Təmmənəya n-Măssinăɣ, təllʼ-e jere-wăn.» ");
INSERT INTO taq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Innă i-inəṭṭulab-net ḍarăt-a-wen: «Ǝlkamăn išilan dăɣ-mad-səddărhənăm ahănay n-Ăgg-ăgg-adəm kud-dăɣ i-ašăl iyyăn ɣas, măšan, wăr t-mad-tənhəyăm. ");
INSERT INTO taq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Afăl hawăn-ătwănna: ‹Ǝnta den›, meɣ: ‹Ǝnta da›, wăr təglem, wăr təlkemăm i-a-wen ");
INSERT INTO taq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","făl-a-s, Ăgg-ăgg-adəm, ass-net, ad-alăh d-essam-i s-e-d issăm dăɣ-ašrut iyyăn n-išənnawăn, ad-isəmmələwləw ašrut wa iyyăḍăn. ");
INSERT INTO taq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Măšan, wăr mad-ăj a-wen ar s-ad-inhəy tersəmmawen, təkkuddəl-t əzzurəyăt-ta-dăɣ təzzar, ");
INSERT INTO taq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","făl-a-s, a-wa ijăn dăɣ-išilan wi n-ănnăbi Nox, a madăn-ăj daɣ dăɣ-išilan-wi dd-mad-iqqəl Ăgg-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ăzzăman wa n-ănnăbi Nox, tayăwanăn ăddinăt, sassăn, tidubunăn, sidubunăn har ašăl wa d-ijjăš Nox turăft n-aman ta măqqărăt s-has-innă Măssinăɣ a tăt-ikən, oḍăn-dd fălla-săn aman wi n-ḍuf, əlhăsăn-tăn iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Šund a-wen-dăɣ daɣ a ijăn dăɣ-išilan wi n-Lut, tattăn ăddinăt, sassăn, žanšen, satajăn, tidumun, təddayăn ihănan ");
INSERT INTO taq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","har ašăl wa d-izjăr Lut aɣrəm wa n-Sodoma, iffăy-dd fălla-săn Măssinăɣ ajənna n-efew d-əlkăbrit, ilhăs-tăn iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Šund a-wen-dăɣ a madăn-ăj ašăl wa dd-mad-iqqəl Ăgg-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ašăl-en, wa iwarăn afălla n-ehăn, wăr dd-itəzəbbutet i-ad-iḍkəl ilalăn has-hanen ider n-ehăn; wa ihan ašəkrəš-net daɣ, wăr-ităqqălet ehăn, ");
INSERT INTO taq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","wăr hin-təttəwăm a-wa ijrăwăn hănne-s n-Lut. ");
INSERT INTO taq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ere wa wărăn idgeẓ ar dăɣ-ajăraw n-iman-net dăɣ-ăddunya-ta-dăɣ, ad-ifut dăɣ-ălžănnăt, măšan, ăwadəm wa irḍăn ăfota dăɣ-iman-net, dăɣ-ăddunya-ta-dăɣ, dăɣ-ăddimmăt-in, ad-iɣləs. ");
INSERT INTO taq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ăssiilmădăɣ-kăwăn s-ehăḍ-wen-dăɣ, ad-ənsan əssin meddən făll-asəftăɣ iyyăn, ămmăḍkăl iyyăn, itwəyy-dd wa iyyăḍăn, ");
INSERT INTO taq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ad-təẓẓadnăt sănatăt tiḍeḍen əttăɣam dăɣ-edăgg iyyăn, tămmăḍkăl tiyyăt, tətwəyy-dd ta iyyăḍăt;  ");
INSERT INTO taq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ad-əhan əssin meddən ašəkrəš iyyăn, ămmăḍkăl iyyăn, itwəyy-dd iyyăn.» ");
INSERT INTO taq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ǝssəstănăn inəṭṭulab Ɣisa, ənnăn-as: «Ălɣalim, əndek dihad-e-ăj a-wen?» Innʼ-asăn: «Dihad t-təlla tamăɣsoyt, ad-itajj ellay.» ");
INSERT INTO taq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ijʼ-asăn Ɣisa daɣ tangalt tiyyăt dăɣ-irha ad-tăn-isəlməd a-s lan s-ad-təddalăn Măssinăɣ hărkuk, wăr dăɣ-s təkkəsăn ăṭṭăma. ");
INSERT INTO taq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Innʼ-asăn: «Kăla t-illa aɣrəm ihʼ ălqaḷḷi wărăn ăksuḍ Măssinăɣ, wăr-issəfrăr daɣ dăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Təllʼ-e daɣ dihen tănuḍăft t-dd-tiisət hak ašăl, təjannʼ-as: ‹Ǝkkəs-ahi tekăriḍt dăɣ-ăwadəm wa hi-ohăɣăn.› ");
INSERT INTO taq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ăhojă ălqaḷḷi wăr tăt-in-ijreh, har šik, innă dăɣ-iman-net ašăl iyyăn: ‹Kud-dăɣ wăr-ăksuḍăɣ Măssinăɣ, wăr-əssəfrărăɣ dăgg-adəm, ");
INSERT INTO taq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ad-əkkəsăɣ tekăriḍt i-tamăḍt-i-dăɣ hi-tăsɣăfăt i-ad-hi-tăkf ălɣafyăt.› » ");
INSERT INTO taq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Innʼ-asăn Ălɣalim Ɣisa: «Săjdăt ɣas i-a-wa-dăɣ inna ălqaḷḷi-wa-dăɣ n-enăllăbăs. ");
INSERT INTO taq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ɣas tordam a-s Măssinăɣ wăr-e-ikkəs tekăriḍt i-wi ăsnăfrăn săr-s dd-hallănen ehăḍ d-ašăl? Tordam a-s ad-hin-ăhaj fălla-săn? ");
INSERT INTO taq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ăbo! Ălleɣeɣ-awăn a-s, ad-hasăn-ikkəs tekăriḍt šik măšan, tordam făw s-ašăl wa dd-mad-iqqəl Ăgg-ăgg-adəm, ad-dd-agəẓ immun făll-ărori n-ăkall?» ");
INSERT INTO taq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Issăɣlăy Ɣisa ḍarăt-a-wen tangalt ăddinăt wi ordănen iman-năsăn iqqud, a-s ija a-wen, əlkăhăn imidiwăn-năsăn, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Kăla əkkăn əssin meddən ehăn n-ămudd wa măqqărăn i-ad-umadăn, ăɣbədăn Măssinăɣ. Iyyăn u-faris, wa iyyăḍăn ănarmas n-tiwse. ");
INSERT INTO taq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Osăn-in ɣas, ibdăd wa n-u-faris, ad-itumad, ijanna dăɣ-iman-net: ‹Ăjoḍăyăɣ-ak Măssinăɣ făl-a-s, wăr-olehăɣ d-ăddinăt-wi iyyăḍnen n-imăkrăḍăn d-iməzzəna, wăr-olehăɣ daɣ d-u-tiwse-wa-dăɣ, ");
INSERT INTO taq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","tuẓamăɣ əssin išilan dăɣ-əssəboɣ, takkăsăɣ tămukăst n-a-wa jarrăwăɣ iket-net.› ");
INSERT INTO taq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A-s ităjj a-wen u-tiwse ənta, ibdad dihen, təgdal-as tăkrakiḍt wăla ad-iḍkəl asăwaḍ-net, ăsninăn iman-net, ijanna ənta: ‹Ya Măssinăɣ! Səsməḍ făll-i, əkrəšăɣet data-k idəm năkk-i n-anăsbăkkaḍ.› » ");
INSERT INTO taq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn a-s u-tiwse-wa-dăɣ, a-s iqqăl ehăn-net, ijraw idəm wăr-ijrew u-faris dat-Măssinăɣ. Ere iḍkălăn iman-net, ad-irəs, ere daɣ wa ăsrăsăn iman-net, ad-t-iḍkəl Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ămmewăyăn-dd ḍarăt-a-wen imărkăsăn s-Ɣisa i-ad-dăɣ-săn ăj ălbăraka, măšan, ənhăyăn inəṭṭulab-net a-wen ɣas, ăklăwlăwăn făll-imărawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iɣrʼ-en-dd Ɣisa s-iman-net, innʼ-asăn: «Ăyyăt aratăn ad-hi-dd-əkkən, wăr tăn-in-tăwweɣăm făll-i făl-a-s Təmmənəya n-Măssinăɣ, ăddinăt-wi dăr-săn ănifăqqănen a-s tăt-ihakk. ");
INSERT INTO taq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ăsidătteɣ-awăn a-s ere wărăn iqbel Təmmənəya n-Măssinăɣ s-əmmək wa s-tăt-mad-iqbəl ara, wăr tăt-mad-ijjəš.» ");
INSERT INTO taq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Osă-dd ălfăqqi iyyăn n-kăl-Ălyăhud Ɣisa, innʼ-as: «Ălɣalim wa olăɣăn, ma s-leɣ s-ad-t-ăjăɣ i-ad-əkkusăɣ tămudre ta tăɣlălăt?» ");
INSERT INTO taq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Innʼ-as Ɣisa: «Mafăl hi-ɣarrăd s-isəm: Wa olăɣăn? Wăr t-illa ere olaɣăn săl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wădden təssanăd alămărăn-net: ‹Wăr jed əzzəna, wăr jed iman, wăr tokerăd, wăr tăjjəyhăd s-bahu, səmɣăr ti-k d-ma-k.› » ");
INSERT INTO taq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Innʼ-as ălfăqqi: «Ăɣdalăɣ i-a-wen-dăɣ iket-net hărwa ămoosăɣ ara.» ");
INSERT INTO taq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isla Ɣisa i-măjrăd wa ija ɣas, innʼ-as: «Hărăt iyyăn a hak-in-ăba: tužžăr-in a-wa led iket-net, tuẓanăd-t i-tilăqqiwen i-ad-təjrəwăd ărrəzăɣ dăɣ-ălžănnăt, dihen, əqqəl-dd, əlkəm-ahi.» ");
INSERT INTO taq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Islʼ ălfăqqi i-a-wen ɣas, ənxăsăn iman-net ed ila ehăre n-tikunen. ");
INSERT INTO taq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Inhăy-t Ɣisa ănxasăn iman-net ɣas, innă: «Unhh! Aẓwi ija i-ere irzaɣăn ujəš n-Təmmənəya n-Măssinăɣ! ");
INSERT INTO taq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ojăr tărăɣse ta ija i-amnəs ujəš s-tiṭṭ n-ănaẓmay uhən i-ere irzaɣăn ujəš n-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ǝnnăn-as ăddinăt-wi has-ăsijădnen a-s inna a-wen-dăɣ: «Adiš mi madăn-iɣləs.» ");
INSERT INTO taq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Innʼ-asăn: «A-wa wăr-ăsmăkkănăn dăgg-adəm, ăddoobăt-t Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Iggăd-dd Bəṭrus, innʼ-as: «Năkkăneḍ-i-š oyyănen ihănan-nănăɣ nəlkăm-ak, əndek isălan-nănăɣ, ma s-ilkam ad-t-nəjrəw?» ");
INSERT INTO taq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Innʼ-asăn Ɣisa: «Ăsidătteɣ-awăn a-s wăr t-illa dăɣ-wăn-i madăn-ăyy ehăn-net meɣ hănne-s meɣ ayətma-s meɣ imărawăn-net meɣ məddana-s dăɣ-təssəba n-Təmmənəya n-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","s-wădden, ad-ijrəw a ănnuḍfăsăn făll-a-wen dăɣ-ăddunya-ta-dăɣ, ijrəw daɣ tămudre ta tăɣlălăt dăɣ-ăddunya ta dd-malăt.» ");
INSERT INTO taq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ikkăs-dd Ɣisa ḍarăt-a-wen inəṭṭulab-net wi n-măraw d-əssin s-takše, innʼ-asăn: «Ǝnhəywăt, năkkăneḍ-da hi-əkkănen Yărussălam i-ad-itbət a-wa əktăbăn ănnăbităn dăɣ-isălan n-Ăgg-ăgg-adəm ");
INSERT INTO taq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","făl-a-s, ad-t-əjən ayətma-s dăɣ-ifassăn n-inəẓẓulam, əjən-t tekăškăšt, səmmăḍrəyăn-t, sutəfən fălla-s, ");
INSERT INTO taq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","əjən dăɣ-s tiwit, əjən iman-net măšan, ašăl wa s-kăraḍ ḍarăt tamăttant-net, ad-dd-inkăr jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ijʼ-asăn Ɣisa măjrăd-wen-dăɣ măšan, wăr t-illa a dăɣ-s əjrahăn ed, ăttunkăl-asăn ălmăɣna-net, wăr-əjrehăn a-wa dăɣ-hasăn-ăssewăl. ");
INSERT INTO taq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ălwăqq wa d-hin-ohăẓăn taɣrəmt ta n-Žărriko, əkkăn-dd edes i-emədderɣəl ăqqiimăn dăɣ-asălim n-zăbo, itattăr takute dăɣ-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Islă i-tăkat ta ja tamətte ɣas, issəstăn d-a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ǝnnăn-as ăddinăt: «Ɣisa wa n-Năṣirăt a okayăn.» ");
INSERT INTO taq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ăsɣărăt, innă: «Ya Ɣisa wa n-Ăgg-Dawəd, aḍən-ahi tăhanint!» ");
INSERT INTO taq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ăɣtălăn-t ăddinăt-wi ăzzarnen i-tamətte i-ad-hin-isusəm măšan, ăsɣărăt s-afălla: «Ya Ăgg Dawəd, aḍən-ahi tăhanint!» ");
INSERT INTO taq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ibdăd Ɣisa, omăr s-ad-săr-s dd-ăttălwăy. Osʼ-e-hi-dd emədderɣəl ɣas, issəstăn-t, innʼ-as: ");
INSERT INTO taq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ma s-tărhed ad-hak-t-ăjăɣ?» Innʼ-as emədderɣəl: «Ălɣalim, aləsăɣet ahănay.» ");
INSERT INTO taq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Innʼ-as Ɣisa: «Ǝnhəy! Iɣlăs-kăy immun-năk.» ");
INSERT INTO taq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Inhăy ălwaqq-wen-dăɣ, ilkăm i-Ɣisa, ad-itiiməl Măssinăɣ, tiiməl daɣ tamətte ta tənhăyăt a-wa ijăn Măssinăɣ făl tihusay n-ijităn-net. ");
INSERT INTO taq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ijjăš Ɣisa aɣrəm wa n-Žărriko, ăllil-t. ");
INSERT INTO taq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A ənḍărrăn ăhaləs n-amărrəzăɣ n-ămănokal n-inarmasăn n-tiwse s-isəm-net Zakəyyu da-dăɣ, ");
INSERT INTO taq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","itattăr əmmək s-inhăy Ɣisa afăl okăy măšan, tənjăr-as-t tamətte ed, i jəzzəlăn. ");
INSERT INTO taq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ošăl, ăzzar i-tamətte, iwwăn ahəšk s-isəm-net sikamur i-ad-isənnəfləy dăɣ-Ɣisa, afăl ikka dawa-s. ");
INSERT INTO taq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iwwăḍ-dd Ɣisa dihen ɣas, iḍkăl asăwaḍ-net, innʼ-as: «Zakəyyu! Zubbət-dd šik, ašăl-i, ămijareɣ-ak.» ");
INSERT INTO taq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ăzzubbăt-dd Zakəyyu šik, ăsmăjarăt Ɣisa dăɣ-tedăwit. ");
INSERT INTO taq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ǝnhăyăn ăddinăt a-wen ɣas, ad-simtəktikăn, jannen: «A-wa, ăbă-has ere ɣur-ăzzubbăt ar anăsbăkkaḍ-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ibdăd Zakəyyu dat-Ălɣalim Ɣisa, innʼ-as: «Ălɣalim, hakkăɣ tilăqqiwen tăẓune n-ehăre-nin, kunta daɣ illʼ-e ere s-kăla dăɣ-s ohăɣăɣ ehăre-net, siɣulăɣ-as-t ija əkkoẓ inəḍfusăn.» ");
INSERT INTO taq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Innă Ɣisa ălwăqq-wen-dăɣ dăɣ-isălan n-Zakəyyu: «Ašăl-i-dăɣ, ehăn-wa-dăɣ, ijjăš-t-dd əlɣəllas, ed ăhaləs-i-dăɣ, ənta-dăɣ ahăya n-ănnăbi Ibrahim a ămoos ");
INSERT INTO taq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","făl-a-s, Ăgg-ăgg-adəm, osă-dd, immaɣ i-ăddinăt-wi ăssujjălnen i-ad-tăn-iɣləs.» ");
INSERT INTO taq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ǝnhăyăn ăddinăt Ɣisa d-inəṭṭulab-net han attayăn n-Yărussălam ɣas, ăɣelăn ălwăqq wa d-fălla-săn dd-mad-təzzubbət Təmmənəya n-Măssinăɣ, iwwăḍ-dd. Təssəba n-a-wen-dăɣ a făl issăɣlăy Ɣisa tangalt-ta-dăɣ i-wi has-ăsijădnen, ");
INSERT INTO taq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","innʼ-asăn: «Kăla ikkʼ ăhaləs n-ăgg-ehăn ăkall ujəjăn i-ad-dăɣ-s dd-ijrəw təmmənukəla, iqqəl-dd. ");
INSERT INTO taq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ăssawăḍ tekle ɣas, iɣră-dd măraw dăɣ-inaxdimăn-net, hak iyyăn dăɣ-săn, ikfʼ-e ablăɣ n-orăɣ təzzar, innʼ-asăn: ‹Ăxdəmăt s-orăɣ-i-dăɣ iket-di dd-taqqălăɣ.› ");
INSERT INTO taq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Măšan, făl mikḍaw-i-dăɣ dăr-s əjăn kăl-ăkall-net, oyyăn-t har iglă təzzar, əssəlkămăn-as ălžămaɣăt ăšimašălăn s-ămănokal wa măqqărăn ikka i-ad-has-ənnən: ‹Ăhaləs-di, wăr nărha ad-fălla-năɣ imnukəl.› ");
INSERT INTO taq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hakd a-wen-dăɣ, ijrăw-dd təmmənukəla, iqqăl-dd ăkall-net; osă-dd ɣas, iɣră-dd inaxdimăn-net winnin ikfa orăɣ i-ad-ilməd a-wa ărbăxăn dăɣ-mamăla-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Osʼ-e-hi-dd wa ăzzarăn, innʼ-as: ‹Măssi-ɣ, ablăɣ-năk, ărbăxăɣ fălla-s măraw iyyăḍ.› ");
INSERT INTO taq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Innʼ-as măssi-s: ‹Ehoyd! Ănaxdim ifranăn ha tafləst a tămoosăd; šămad hʼ-iik tafləst dăɣ-a-wărăn ijət, ad-kăy-səmmənukəlăɣ făll-măraw iɣărman n-ăkall-in.› ");
INSERT INTO taq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Osă-dd wa s-əssin ḍarăt-a-wen, innă: ‹Măssi-ɣ, ablăɣ-năk, ărbăxăɣ fălla-s səmmos iyyăḍ.› ");
INSERT INTO taq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Innă daɣ i-wa: ‹Kăyy, ad-təmnukəlăd făll-səmmos iɣărman n-ăkall-in.› ");
INSERT INTO taq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Osă-dd iyyăn daɣ, innʼ-as: ‹Măssi-ɣ, ablăɣ-năk, ənta da; a təgled-dăɣ, əkmasăɣ-t, itwar, ");
INSERT INTO taq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","jeɣ-ak tuksəḍa-i-dăɣ măqqărăt ed əssanăɣ a-s emăṣṣehi a tămoosăd, sikusăd-dd a wăr təssətwărăd, tiləyəd-dd ašəkrəš wăr tăddomed.› ");
INSERT INTO taq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Innʼ-as măssi-s: ‹Kăyy wa-hi, erk ănaxdim a tămoosăd! A-wa-dăɣ dd-izjărăn emm-năk a-s kăy-e-səḍləmăɣ; a-s təssanăd a-s năkk emăṣṣehi a ămoosăɣ dd-isikusăn a wăr əssətwărăɣ, tiləyăɣ-dd ašəkrəš wăr-ăddomeɣ, ");
INSERT INTO taq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","mafăl wăr jed aẓrəf-in dăɣ-bănk, dihen a-s t-dd-mad-ăqqəlăɣ, ăttillăɣăɣ hărăt fălla-s.› ");
INSERT INTO taq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Innă ămănokal ḍarăt-a-wen i-ăddinăt-wi t-əllănen dihen: ‹Ahăɣăt dăɣ-s ablăɣ wa iṭṭăf, təkfəm-t i-wa n-măraw.› ");
INSERT INTO taq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ǝnnăn-as ăddinăt: ‹Ǝnta-š wădden ila măraw?› » ");
INSERT INTO taq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn a-s ăwadəm wa ilăn hărăt, ad-has-iwwaḍ măšan, wa wărăn ila hărăt, ad-dăɣ-s ămahăɣ wăla a-wa iṭṭăf. ");
INSERT INTO taq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","‹Ḍarăt-a-wen, išənja-nin winnin wăren irha ad-fălla-săn əmnukəlăɣ, əlwəyăt-ahi-tăn-dd, tăɣrəsăm-asăn dat-i.› » ");
INSERT INTO taq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Innă Ɣisa a-wen ɣas, ăzzar-i-inəṭṭulab-net s-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ohăẓ-in tidbi ti n-Bătfaži d-Bitanya, edes i-taḍaɣt ta tăsijătăt ihəškan wi n-əzzăytun; dihen-dăɣ ad-ăšmašăl əssin dăɣ-inəṭṭulab-net, ");
INSERT INTO taq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","innʼ-asăn: «Ăkkăt tadăbayt ta-n data-wăn, afăl tăt-təjjăšăm, ad-təjrəwăm ăẓa ojayăn s-kăla wăr t-iney ăwadəm; arăt-t-dd, təlwəyăm-t-dd. ");
INSERT INTO taq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ere kăwăn-issəstănăn d-a-wa făl t-tirəm, ănnăt-as: ‹Ila dăɣ-s ălɣalim əššăɣəl.› » ");
INSERT INTO taq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ǝglăn inəṭṭulab-wi ăšmašăl, ogăẓăn-in hărătăn s-əmmək-wa-dăɣ s-hasăn-tăn-innă; ");
INSERT INTO taq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","tiirən ăẓa a-s tăn-ăɣtălăn məssaw-s d-a-wa făl t-tirən. ");
INSERT INTO taq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ǝnnăn-asăn inəṭṭulab wi n-əssin: «Ălɣalim a dăɣ-s ilan əššăɣəl.» ");
INSERT INTO taq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ǝlwăyăn-dd aẓa i-Ɣisa, əstăjăn-as inkubba-năsăn, ăsnăyăn-as-t ɣas, ");
INSERT INTO taq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ad-fattăɣăn ăddinăt isəlsa-năsăn făll-zăbo wa mad-ilal iket-net. ");
INSERT INTO taq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Issəntă-dd Ɣisa atrur n-taḍaɣt ta n-əzzăytun ɣas, təddəwăt tamətte ta n-inəṭṭulab-net iket-net, siiɣləlit, tiiməl Măssinăɣ s-afălla dăɣ-təssəba n-ijităn wi ăssuksăḍnen tənhăy. ");
INSERT INTO taq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tiiməl Măssinăɣ, janna: «Ozana! Ija Măssinăɣ ălbăraka dăɣ-ămănokal wa dd-osăn dăɣ-isəm n-Emăli, ălxer ija, imăl-t ălxurmăt dăɣ-išənnawăn iket-năsăn.» ");
INSERT INTO taq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ǝggădăn-dd kăl-faris hanen tamətte, ənnăn i-Ɣisa: «Ălɣalim, səssusəm inəṭṭulab-năk.» ");
INSERT INTO taq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn a-s afăl ăssosămăn, ad-săqqărətnăt tihun.» ");
INSERT INTO taq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ohăẓ-in Ɣisa Yărussălam, inhăy-tăt ɣas, ad-ihall fălla-s, ");
INSERT INTO taq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ijanna: «Yărussălam! Ǝnnăr tăddobed ad-təlmədăd ašăl-i-dăɣ, əmmək wa s-tăddobed ad-təjrəwăd ălɣafyăt n-iman-năm măšan, ăttunkăl-am a-wen, wăr t-hənnəynăt tiṭṭawen-năm. ");
INSERT INTO taq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ădduuttăt a-s, əlkamăn dăɣ-m išilan sămuumnen dăɣ-mad-kăm-ăɣləyɣələyăn išənja-năm, ăẓbəbăn-kăm s-išrutăn iket-dăɣ-năsăn, ");
INSERT INTO taq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ăttăɣtăɣăn-kăm, kămm d-aratăn-năm, wăr mad-dăɣ-m-dd-əyyən wăla ablăɣ iwarăn amidi-net făl-a-s, tunjăyăd s-ašăl wa săr-m dd-ăšbašăjăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ijjăš Ɣisa ḍarăt-a-wen ehăn n-ămudd wa măqqărăn, ad-dăɣ-s isattăɣ ăttužžar, ");
INSERT INTO taq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ijannʼ-asăn: «Ajăn wădden iktab a-s inna Măssinăɣ: ‹Ehăn-in, ad-umas ehăn n-tittar›, măšan, kăwăneḍ jăm-t tajnut n-imăkrăḍăn.» ");
INSERT INTO taq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Isaɣra ḍarăt a-wen-dăɣ hak ašăl dăɣ-ehăn n-ămudd wa măqqărăn. Ǝnkărăn-dd imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt d-imizărăn n-kăl-Ălyăhud, ad-tattărăn əmmək s-jăn iman-net ");
INSERT INTO taq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","măšan, ăbă-hasăn taməntelt făl jăn a-wen ed, tăsijăd-as tamətte iket-net, ijraẓ-as daɣ a-wa ijănna. ");
INSERT INTO taq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ašăl iyyăn, isaɣra Ɣisa dăɣ-ehăn n-ămudd wa măqqărăn, ixaṭṭăb i-ăddinăt isălan n-Ălənžil a-s t-dd-osăn kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt d-inušămăn n-Iṣrayil, ");
INSERT INTO taq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ənnăn-as: «Lăɣăt-anăɣ, mi kay-ikfăn turhajăt n-amišəl n-tikunen-ti-dăɣ, meɣ daɣ mi kăy-ikfăn tărna-ta-dăɣ s-tăjjăd a-wa tăjjăd?» ");
INSERT INTO taq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Innʼ-asăn: «Ad-hawăn-ăjăɣ năkk-dăɣ asəstan iyyăn, ămăra, lăɣătăt-ahi: ");
INSERT INTO taq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mi dd-ăšmašălăn Exya wa n-Enəsselmăɣ i-ad-isəlmăɣ ăddinăt dăɣ-aman? Ak Măssinăɣ a t-dd-ăšmašălăn meɣ dăgg-adəm ɣas?» ");
INSERT INTO taq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ănmăkkăsăn s-takše, ad-jannen: «Afăl has-nənna: ‹Măssinăɣ a t-dd-ăšmašălăn›, ad-hanăɣ-ănn: ‹Adiš, mafăl wăr tomenăm s-a-wa hawăn-inna.› ");
INSERT INTO taq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Afăl has-nənna dăgg-adəm ɣas a t-dd-ăšmašălnen, ad-hanăɣ-tăkf tamətte iket-net sămmăjori n-tihun ed təkkas iket-net ăššăk a-s Exya ănnăbi n-Măssinăɣ a ămoos.» ");
INSERT INTO taq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ǝqqălăn-dd, ənnăn-as wăr əssenăn ere t-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Innʼ-asăn Ɣisa: «Adiš năkk-dăɣ, wăr hawăn-e-ăllăɣeɣ ere wa hi-ikfăn tărna ta s-tăjjăɣ a-wa tăjjăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Issăɣlăy-tăn-dd Ɣisa ḍarăt-a-wen tangalt dăɣ-hasăn-innă: «Kăla ăddomăt ăhaləs iyyăn ašəkrəš n-lăɣnăb, ifăr-t i-inəsduma iyyăḍ təzzar, ikkʼ ăkall iyyăn dăɣ-hin-ăhoja. ");
INSERT INTO taq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tăwwăḍ-dd tăqqăn n-amili n-ašəkrəš ɣas, ăšmašăl-dd săr-săn ănaxdim i-ad-has-dd-awəy ɣur-săn folăt-net dăɣ-a-wa dd-orăw ašəkrəš. Osă-dd inəsduma wi fărnen ašəkrəš, əḍnăyăn-t tiwit təzzar, əssəglăn-t korăyrăy. ");
INSERT INTO taq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Olăs-dd săr-săn ašəmmišəl n-ănaxdim iyyăn daɣ, jăn dăɣ-s ənta-dăɣ tiwit, ăsmăḍrăyăn-t, əssəglăn-t korăyrăy. ");
INSERT INTO taq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ăšmašăl-dd săr-săn daɣ wa s-kăraḍ, ənta, ăsbayăsăn-t təzzar, əntăjăn-t-in korăyrăy. ");
INSERT INTO taq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Innă măssi-s n-ašəkrəš ḍarăt-a-wen: ‹Ǝndek ăddăbara ămăra? Wăr hin-ăqqima ɣas ar ad-săr-săn šəmmišəlăɣ rure-ɣ wa əkneɣ tărha, ənta ya, ănihăjja s-ad-t-səmɣărăn.› ");
INSERT INTO taq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ǝnhăyăn inaxdimăn rure-s n-măssi-s n-ašəkrəš imal-dd ɣas, ănmănnăn jer-iman-năsăn: ‹Ǝnhəywăt-ak, amăkkasu-net, nărməset-t, năjet iman-net, dihen ad-tumas tăkasit ti-nănăɣ›. ");
INSERT INTO taq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ărmăsăn-t, əzjărăn dăr-s ašəkrəš, ănɣăn-t kərəf.» Innʼ-asăn Ɣisa: «Ma tordam, wi-dăɣ inaxdimăn, ma hasăn-mad-ăj măssi-s n-ašəkrəš? ");
INSERT INTO taq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ǝḍmanăɣ-awăn a-s ămăra, ad-tăn-dd-ass ənta iman-net, ilhəs-tăn iket-dăɣ-năsăn, aləs tefert n-ašəkrəš-net i-iyyăḍ.» Ǝslăn, ăddinăt i-a-wen ɣas, ənnăn: «Assəkăḍ ăkall!» ");
INSERT INTO taq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Issăɣlăy-tăn-dd akăyad-net, innʼ-asăn: «Adiš mafăl ătiwănna dăɣ-əlkəttab n-Măssinăɣ a-s: ‹Tăhunt ta hin-jărăn ălbănnatăn s-ənnăn wăr tənfa hărăt, ənta a-s a-s təšrăy tanfust, tămoos tăhunt ta n-aɣmăr tufăt, hakkăt ăṣṣahăt ehăn; ");
INSERT INTO taq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","tăhunt-ta-hi, ere fălla-s oḍăn, ad-ărrăẓrăẓ; ere făll-toḍa daɣ, ad-ilkəẓ.› » ");
INSERT INTO taq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Innʼ-asăn Ɣisa a-wen ɣas, əttărăn ălɣulam n-Ăṭṭăwrăt d-imănokalăn n-kăl-tikutawen əmmək s-t-ăstărmăsăn ălwăqq-wen-dăɣ ed, əssanăn a-s əntăneḍ-en-dăɣ, a ăssiiɣlăy tangalt-ta-dăɣ măšan, wăr jen a-wen ed, ăksuḍăn tamətte. ");
INSERT INTO taq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jăn-as ḍarăt-a-wen ənniyăt dăɣ-ijəj, ăšmašălăn-dd săr-s inaramăn janen iman-năsăn ălmăt ăddinăt oɣadnen i-ad-t-səwwənnən a-wărăn itətwənn, əjən-t dăɣ-ifassăn n-gəfăr d-əlxəkum-net. ");
INSERT INTO taq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Osăn-t-dd, ənnăn-as: «Ălɣalim, nəssan a-s a-wa jănned d-a-wa săɣred iket-net, oɣad; wăr tăẓmăẓlăyăd ăddinăt ed tabarăt ta n-Măssinăɣ ɣas a saɣred. ");
INSERT INTO taq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ămăra, năssistăn-kăy: ak iwar-anăɣ ad-nəẓəl tiwse i-Qăyṣăr wa n-ămănokal măqqărăn meɣ?» ");
INSERT INTO taq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ilmăd Ɣisa ɣur-iman-net amsud wa t-illăn ḍarăt asəstan wa has-jăn, innʼ-asăn ");
INSERT INTO taq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Săkənăt-ahi-dd ărriyal, tăllăɣem-ahi ere wa ilăn ăṭṭăṣwer d-isəm wa t-iwărăn?» Ǝnnăn-as: «I n-ămănokal Qăyṣăr.» ");
INSERT INTO taq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Innʼ-asăn: «Adiš, suɣəlăt i-Qăyṣăr a-wa fălla-wăn ila, təkfəm daɣ Măssinăɣ a-wa fălla-wăn ila.» ");
INSERT INTO taq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Indăr-asăn făw a t-səwwənnən erk măjrăd dat-tamətte, əqqălăn-dd ɣas tofʼ-en tăkunt n-ălwižab wa hasăn-ija, ăssosămăn. ");
INSERT INTO taq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Osʼ-e-hi-dd ḍarăt-a-wen hărăt dăɣ-kăl-taggayt ta n-kăl-sadus-i jănnănen a-s wăr təlkem tanăkra jer-inəmmuttan, afăl ăba ăwadəm, əmdăn isălan-net. ");
INSERT INTO taq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ǝssəstănăn-t, ənnăn-as: «Ălɣalim, innʼ-anăɣ ănnăbi Mosa: ‹Afăl ădobăn ăhaləs, ăba-t wăr oher ara d-hănne-s, idubənet-tăt ăŋŋa-s i-ad-ikrəš əzzurəyăt i-ăŋŋa-s wa ăba i-ad-wăr hin-itiləm isəm n-wa ăba făll-ărori n-ăkall.› ");
INSERT INTO taq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ămăra, əkkəs-anăɣ dăɣ-tăqqăn n-eɣăf: Kăla t-əllăn əssa ăŋŋatăn, ădobăn dăɣ-săn wa n-amăqqar măšan, ăba-t wăr-ikreš ara, ");
INSERT INTO taq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","išrăy-t wa s-əssin s-adubən n-hănne-s, ");
INSERT INTO taq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ilkăm-as daɣ wa s-kăraḍ măšan, wăr tăn-iha i dăr-s oharăn ara; ădobănăn-tăt əssa-essăn, ăba-tăn daɣ iket-năsăn, wăr t-illa i dăr-s oharăn ara. ");
INSERT INTO taq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ăba daɣ ḍara-săn tamăḍt. ");
INSERT INTO taq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Năssiistăn-kăy: ašăl wa n-tanăkra jer-inəmmuttan, əndek dăɣ-săn wa s-e-tumas hănne-s ed, ənhayăn-tăt adubən əssa-essăn?» ");
INSERT INTO taq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Innʼ-asăn Ɣisa: «Dăɣ-ăddunya-ta-dăɣ, tidubunăn meddən, tidubunnăt tiḍeḍen ");
INSERT INTO taq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","măšan, ăddinăt wi ikfa Măssinăɣ turhajăt n-ad-dd-ənkărăn jer-inəmmuttan i-ad-əjjəšăn ălžănnăt, jer-wi n-meddən wăla tiḍeḍen, ad-ăbas ămiɣatărăn s-adubən, ");
INSERT INTO taq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ed ăbas dăɣ-săn təlkam tamăttant, ad-alăhăn d-ănjălosăn, umasăn aratăn n-Măssinăɣ ed, ənkărăn-dd jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dăɣ-a-wa dd-iqqălăn isălan n-tanăkra jer-inəmmuttan, issətbăt-tăn ănnăbi Mosa ed, ašăl wa t-iɣră Emăli dăɣ-tabsăɣt ta tăhjăljălăt wăr răqq, iɣrʼ-e Mosa s-isəm: Măssinăɣ n-Ibrahim d-Isxaqq d-Yaqub. ");
INSERT INTO taq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A-wen, ălmăɣna-net a-s, ăddinăt-win-dăɣ, han ălžănnăt, tiimələn Măssinăɣ; ənnăr wăr ədderăn wăr təjjən a-wen. Măssinăɣ, wădden inəmmuttan a-s ămoos Măssinăɣ, ămoos-t i-wi əddărnen ed data-s, əddarăn iket-dăɣ-năsăn.» ");
INSERT INTO taq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Imməjrăd hărăt dăɣ-ălɣulam n-Ăṭṭăwrăt ḍarăt-a-wen i-Ɣisa, ənnăn-as: «Ălɣalim, edăwănne-năk, ikna.» ");
INSERT INTO taq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ăbas t-illa ḍarăt-a-wen ere ihălăn asəstan-net. ");
INSERT INTO taq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Issəstăn-tăn Ɣisa ḍarăt-a-wen, innʼ-asăn: «Ma isawănnen ăddinăt a-s Ălmasex, rure-s n-Dawəd? ");
INSERT INTO taq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ajăn wădden Dawəd iman-net inna fălla-s dăɣ-əlkəttab wa n-Ăẓẓăbur: ‹Inna Emăli i-Emăli-nin, ɣayəm daw-aɣil-in, ");
INSERT INTO taq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hundăɣ hăr ăjăɣ išənja-năk daw-iḍarăn-năk.› ");
INSERT INTO taq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɣas kunta Dawəd iman-net iɣarr Ălmasex s-isəm ‹Emăli›, əndek əmmək wa s-ăddobăt ad-umas rure-s?» ");
INSERT INTO taq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Innă Ɣisa ḍarăt-a-wen i-inəṭṭulab-net dat-tamətte ta has-tăsijădăt: ");
INSERT INTO taq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Agəẓăt iman-năwăn dăɣ-ălɣulam n-Ăṭṭăwrăt, ijraẓ-asăn ad-tikələn timukal dăɣ-isəlsa ăhobătnen, ijraẓ-asăn ad-hasăn-tajjăn ăddinăt isofan dăɣ-tišarriten, ărhan tisăqqima ti ănnuflăynen dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud d-atwəsəmɣar dăɣ-imjora, ");
INSERT INTO taq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","saknen a-s hărkuk tumadăn, a-s ija a-wen, tihăɣăn a-wa ihăn ifassăn n-tinuḍăfen, ilkam dăɣ-săn ăššăreɣa səmmăn.» ");
INSERT INTO taq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iḍkăl Ɣisa ḍarăt-a-wen asăwaḍ-net, inhăy kăl-ehăre tajjăn aẓrəf wa təkkatăn dăɣ-əssəndoqq wa n-tikutawen ihăn ehăn n-ămudd wa măqqărăn, ");
INSERT INTO taq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","inhăy daɣ tănuḍăft tiyyăt lăqqəwăt har dd-tosa, tăstărăkkăt dăɣ-əssəndoqq sănatăt tămmaten əbḍanen. ");
INSERT INTO taq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Inhăy Ɣisa a-wen ɣas, inna: «Tidət-dăɣ a-s tănuḍăft-ta-dăɣ n-talăqqe, tojăr ăddinăt iket-năsăn ihuk, ");
INSERT INTO taq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","făl-a-s iket-năsăn, a-wa s-ăssakăyăn s-wăr-ămɣatărăn a əkfăn, a-s ija a-wen ənta, dăɣ-əllăqqu-net, a-wa təṭṭăf i-tămudre-net iket-net, a təkfa.» ");
INSERT INTO taq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Islă Ɣisa ḍarăt-a-wen i-ăddinăt iyyăḍ dăɣ-tamətte, tiimələn tihusay-ti ija ehăn n-ămudd wa măqqărăn, tiimələn daɣ a-wa t-ihăn d-tihun ti s-idăy d-a-wa s-idlăj măšan, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«A-wa-dăɣ hannăyăm ăhusken, əlkamăn išilan dăɣ-wăr mad-dd-tăqqayəm tăhunt tiyyăt ɣas warăt tamidit-net, ad-ăttăɣtăɣ iket-dăɣ-net.» ");
INSERT INTO taq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ǝssəstănăn-t, ənnăn-as: «Ălɣalim, əmme d-mad-ăj a-wen? Ǝkkəs-anăɣ dăɣ-taɣdărt n-išmal wi-s-e-nəlməd a-s sămdo, osă-dd.» ");
INSERT INTO taq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Innʼ-asăn Ɣisa: «He kăwăneḍ, wăr kăwăn-išăšket ăwadəm ed, ad-dd-asən ăddinăt ăjjootnen s-isəm-in, ănn hak iyyăn dăɣ-săn: ‹Năkk a-s Ălmasex!› meɣ ănn: ‹Tăqqăn, tăwwăḍ!› wăr tošelăm ḍara-săn. ");
INSERT INTO taq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Afăl təslăm i-isălan n-imjărăn d-tanăkra n-timəttawen, wăr-ităggădet ənniyăt-năwăn; a-wen a ilan s-ad-ăj təzzar išrəy-t-dd sămdo n-hărăt iket-net.» ");
INSERT INTO taq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Innʼ-asăn daɣ ḍarăt-a-wen: «Ad-təknəs tawset tamidit-net, iknəs əddəwəl amidi-net, ");
INSERT INTO taq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ad-iškəḍkəḍ ăkall dăɣ-idăggan ăjjootnen, ăj laẓ d-turhənnawen ăjjootnen, əzjărăn-dd hărătăn d-ijităn ăssuksăḍnen išənnawăn ");
INSERT INTO taq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","măšan, dat-ad-ăj a-wen-dăɣ, ad-tăttărmăsăm, tətwăɣəzzəbem, tăttălwăyăm s-ăššăreɣa dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, təjjəšăm tikărmuten, sərrəwrəwăn-awăn ăddinăt s-imănokalăn d-gəfărăn dăɣ-təssəba n-isəm-in wa kăwăn-iwarăn, ");
INSERT INTO taq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ad-hawăn-umas a-wen əssəbab făl tămoosăm tijuhawen-in. ");
INSERT INTO taq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wăr tăšăwwašnet ulhawăn-năwăn dăɣ-isălan n-a-wa mad-tənnəm ");
INSERT INTO taq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","făl-a-s, ad-kăwăn-ăkfăɣ ăllifaẓ d-sărho dăɣ-măjrăd s-wăr t-illa ašănjo-năwăn ăddoben tebădde data-wăn, wăla asəbbəggu-năwăn. ");
INSERT INTO taq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ad-kăwăn-səttărməsăn imărawăn-năwăn, d-ayətma-wăn, d-išăqqaɣăn-năwăn, d-imidiwăn-năwăn, səssănɣən kərəf iyyăḍ dăɣ-wăn, ");
INSERT INTO taq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ad-dăr-wăn akəḍăn ăddinăt iket-năsăn dăɣ-təssəba n-isəm-in wa kăwăn-iwarăn ");
INSERT INTO taq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","măšan, wăr hin-e-iba wăla emẓăd n-eɣăf-năwăn iyyăn ɣas. ");
INSERT INTO taq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ere wa ăkoyădăn dăɣ-alkum-hahi dăɣ-immun-net har ašăl wa d-imda a-wen-dăɣ iket-net, ad-iɣləs.» ");
INSERT INTO taq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Afăl tənhăyăm Yărussălam a-s tăt-dd-ăɣlăyɣălăyăn əlɣəskărăn, əlmədăt a-s əlhəllak-net, ohăẓ-dd. ");
INSERT INTO taq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dihen, wi əzzăɣnen teje ta n-Ălyăhudəyăt, jawăḍnet dăɣ-azzal s-ašrut wa n-iḍaɣăn; wi əzzăɣnen aɣrəm wa n-Yărussălam, əzjărnet-t; wi əzzăɣnen ăroj-net, wăr dd-tăjjăšnet aɣrəm ");
INSERT INTO taq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","făl-a-s, išilan-en, išilan n-ukəs n-eɣa dăɣ-mad-ăj a-wa ənnăn əlkəttabăn n-Măssinăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Timəskay tiḍeḍen-ti irmăs a-wen-dăɣ lanăt ənniyăt meɣ siḍuḍnăt, făl-a-s, ad-tăj tiẓẓurt măqqoorăt făll-ăkall, iḍəw aḍkăr n-Măssinăɣ făll-tamətte-ta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aɣil-net iyyăn, ad-t-tăkš tăkoba, aɣil wa iyyăḍăn, ad-ăkkălăt dăɣ-ikallăn wi iyyăḍnen, ad-əddəšnăt tiwsaten wăren ămoos ti n-Ălyăhud, Yărussălam hundăɣ har akəy ăzzăman-năsnăt.» ");
INSERT INTO taq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ad-ăj hărăt dăɣ-tăfukt d-ewăr d-etran, əjənăt tirəmmaɣ dăɣ-tiwsaten ti wărnen ărori n-ăkall dăɣ-təssəba n-emăsli-i-dăɣ ăssuksăḍăn he-ikkəs ejărew wa səmmăn d-tinăzzămăren-net. ");
INSERT INTO taq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ăddinăt iyyăḍ, ad-tăn-tănɣ tarəmmeɣt n-a-wa hannăyăn itajj făll-ăkall ed, wăla iməṣṣuha wi hănen išənnawăn, ad-ənhəynəhəyăn. ");
INSERT INTO taq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ălwăqq-wen-dăɣ, ad-e-ənhəyăn ăddinăt Ăgg-ăgg-adəm imal-dd, inay tijărăken, təlkam-as tărna-net d-ălxurmăt-net. ");
INSERT INTO taq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Afăl əssəntăn hărătăn-win-dăɣ iji, əbdədăt, təḍkəlăm iɣăfawăn-năwăn făl-a-s, əlɣəllas-năwăn, ohăẓ-dd.» ");
INSERT INTO taq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Issăɣlăy-tăn Ɣisa ḍarăt-a-wen tangalt tiyyăt, innʼ-asăn: «Səjrăhăt dăɣ-ašar d-ihəškan wi iyyăḍnen; ");
INSERT INTO taq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","wădden e-d, tăn-tənhăyăm a-s dd-ənšărăn, ad-təlmədăm d-iman-năwăn a-s osʼ-iwăn akăsa. ");
INSERT INTO taq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ǝmmək-wen-dăɣ daɣ a-s afăl tənhăyăm hărătăn-win-dăɣ s-hawăn-ənneɣ har əqqălăn iji, adiš əlmədăt a-s Təmmənəya n-Măssinăɣ, tohăẓ-dd. ");
INSERT INTO taq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ăsidătteɣ-awăn a-s wăr-e takəy əzzurəyăt-ta-dăɣ wăr jen hărătăn-win-dăɣ s-hawăn-ənneɣ iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ojăr tărăɣse ija ad-ibʼ-išənnawăn d-ăkall uhən ad-iba tənna-nin. ");
INSERT INTO taq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ăjăt ənniyăt i-iman-năwăn, wăr ẓăẓayet tesăse n-asməd d-əlxəmăr d-inəzjam n-ăddunya ulhawăn-năwăn, wăr toyyem ašăl-en-dăɣ oḍa-dd fălla-wăn ");
INSERT INTO taq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","šund tătart făl-a-s ašăl-en, ad-dd-iḍəw făll-ăddinăt wi wărnen ărori n-ăkall iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ɣas, ɣaymăt jam ənniyăt, tăɣbadăm Măssinăɣ s-ălwăqq iket-net i-ad-tăɣləsăm dăɣ-a-wa dd-imalăn, tudabem daɣ tebădde dat-Ăgg-ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Itajj Ɣisa ašăl iket-net isaɣra dăɣ-ehăn n-ămudd wa măqqărăn măšan, e-d t-ija ehăḍ, ad-adəw taḍaɣt ta n-əzzăytun; ");
INSERT INTO taq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","e-d ăffăw, ad-dd-tənšəy tamətte iket-net ehăn n-ămudd wa măqqărăn i-ad-has-səjəd. ");
INSERT INTO taq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ohăẓ-dd ămudd wa n-Faṣka-i dăɣ-tattăn ăddinăt tijəlwen ti wăr tăskăf tăẓẓa ɣas, ");
INSERT INTO taq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","əggădăn-dd imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt, ad-tattărăn əmmək s-əjăn iman n-Ɣisa măšan, təgdăl-asăn-t tuksəḍa ta jăn i-tamətte. ");
INSERT INTO taq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dăɣ-a-wen-dăɣ, ad-ijjăš Iblis Yăhudəs Isxaryut, iyyăn dăɣ-inəṭṭulab n-Ɣisa wi n-măraw d-əssin, ");
INSERT INTO taq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","iglă, imməjrăd d-imănokalăn n-kăl-tikutawen d-imănokalăn n-ălgomităn, ănmăknăn dăr-s i-ad-hasăn-isăɣdăr Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ăsdăwăt-tăn a-wa hasăn-inna, əjjăšăn-as ărkăwăl n-ad-t-əkfən aẓrəf, ");
INSERT INTO taq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","irḍʼ-asăn, ad-itammăɣ i-ăssaɣăt ănnuflăyăn d-wăr t-təlla tamətte edes i-Ɣisa i-ad-hasăn-t-isəttărməs. ");
INSERT INTO taq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Osă-dd ašăl wa dăɣ-tattăn ăddinăt tijəlwen-ti wăr ha tăẓẓa d-ɣarrăsnăt taɣsiwen ti n-Faṣka, ");
INSERT INTO taq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ăšmašăl Ɣisa Bəṭrus d-Exya, innʼ-asăn: «Ăglăt, səmməjnum-anăɣ imənsiwăn wi n-ămudd wa n-Faṣka.» ");
INSERT INTO taq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ǝnnăn-as: «Ǝndek diha d-tărhed ad-tăn-nəsəmmujnət?» ");
INSERT INTO taq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Innʼ-asăn: «Diha-dăɣ d-e-təjjəšăm aɣrəm ad-dăr-wăn-e-immuqqəs ăhaləs dd-iktarăn, əlkəmăt-as s-ehăn wa mad-ijjəš, ");
INSERT INTO taq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tənnəm i-măssi-s n-ehăn-en: ‹Innʼ-ak ălɣalim, səkən-anăɣ edăgg dăɣ-ehăn-năk wa-dăɣ mad-səssikəyăɣ ămudd wa n-Faṣka năkk d-inəṭṭulab-in.› ");
INSERT INTO taq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ad-kăwăn-isəkən ehăn n-soro dăɣ-ămmujnen isəftaɣ, dihen-dăɣ ad-mad-nəsəssikəy ămudd. ");
INSERT INTO taq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ǝglăn, ənhăyăn hărătăn s-əmmək-wa-dăɣ s-hasăn-tăn-inna Ɣisa, ad-siməjnun imənsiwăn wi n-Faṣka.» ");
INSERT INTO taq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ămmujnăt-dd hărăt iket-net, əskărăn-dd imənsiwăn ɣas, ănɣăyma Ɣisa d-inəmmušal dăɣ-edăgg wa n-imənsiwăn, ");
INSERT INTO taq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","innʼ-asăn: «Ăsdărhănăɣ hullan ad-dăr-wăn ahărăɣ Faṣka-ta-dăɣ hărwa wăr-ăqquzzăbeɣ ");
INSERT INTO taq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","făl-a-s, ădduuttăt a-s ăbas ilkam, ad-dăr-wăn tăt-oharăɣ hundăɣ har ašăl wa d-mad-ăttălmăd ălmăɣna-net dăɣ-Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iḍkăl-dd Ɣisa kara han aman n-lăɣnăb ăxxiimmărnen, ăjoḍăy i-Măssinăɣ təzzar, ikfʼ-en i-inəṭṭulab-net, innʼ-asăn: «Năɣəbbətăt a-wa jer-iman-năwăn ");
INSERT INTO taq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","făl-a-s, ăssiilmădăɣ-kăwăn a-s wăr-ilkem ɣur-ašăl-i-dăɣ ad-əsweɣ a dd-ijmaḍăn lăɣnăb, hundăɣ har ašăl-wa dd-mad-tass Təmmənəya n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iḍkăl Ɣisa ḍarăt-a-wen tajəlla, ămmoy i-Măssinăɣ, irẓʼ-et təzzar, ăẓun-asăn-tăt, innʼ-asăn: «A-wa taɣəssa-nin ta mad-ăkfăɣ dăɣ-idăggan-năwăn, tuẓanăt tajəlla jer-iman-năwăn kăwăneḍ-dăɣ i-ad-hi-dd-kittəwăm.» ");
INSERT INTO taq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ǝssəmdăn tetăte ɣas, iḍkăl kara han aman n-lăɣnăb ăxxiimmărnen, innʼ-asăn: «A-wa ihăn kara-i-dăɣ a-s ărkăwăl n-tassaɣt wa ăynayăn ijăn s-ašni-nin wa madăn-inɣəl dăɣ-ăddimmăt-năwăn ");
INSERT INTO taq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","măšan, ənhəywăt-ak ămaɣdar-in, ənta-da-dăɣ dăr-i oharăn. ");
INSERT INTO taq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ăsidătteɣ-awăn a-s Ăgg-ăgg-adəm, ătiwatăs ad-t-iba măšan, amăskoy ăwadəm wa t-madăn-isəssăɣdăr!» ");
INSERT INTO taq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ad-tinməsəstinăn ya inəṭṭulab jer-iman-năsăn i-ad-əlmədăn ere wa ihălăn ad-ăj tăkunt-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tənkăr dăɣ-săn tamădašt tăṣṣoohet ălwăqq-wen-dăɣ i-ad-əlmədăn ere wa dăɣ-săn ojărăn. ");
INSERT INTO taq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Innʼ-asăn Ɣisa: «Imănokalăn ăsiikălen əddəwəlăn-wi făll-ăxkamăn măšan, hakd a-wen-dăɣ, ărhan ad-hasăn-itawănna dăgg-ălxer ");
INSERT INTO taq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","măšan, kăwăweḍ, wăr jem a-wen: Wa ojărăn dăɣ-wăn, umaset šund wa ənḍărrăn, wa n-ămizăr, umaset ănaxdim n-wi iyyăḍnen. ");
INSERT INTO taq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ăssistănăɣ-kăwăn: əndek ere wa ăniihăjjăn d-semɣar jer-ere wa ăqqiimăn itatt d-ere wa has-ixdamăn? Wădden wa ăqqiimăn itatt a ăniihăjjăn d-semɣar. Ăywa! Năkk a-s kăwăn-dd-oseɣ, əjeɣ iman-in jere-wăn dăɣ-edăgg n-ănaxdim. ");
INSERT INTO taq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kăwăneḍ-i-dăɣ ɣas, ad-dd-ăqqimănen təlkamăm-ahi ḍarăt aɣăna wa ənhăyăɣ, ");
INSERT INTO taq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","a-wen-dăɣ a făl, tajjăɣ Təmmənəya ta n-Abba-nin jer-ifassăn-năwăn s-əmmək wa s-tăt-ija jer-wi-nin, ");
INSERT INTO taq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","i-ad-dăr-wăn ahărăɣ išəkša d-isəswa dăɣ-Təmmənəya-nin, tăqqayməm făll-tisăqqima n-təmmənukəla i-ad-təšrăɣăm tiwsaten ti n-mărawăt d-sănatăt n-Iṣrayil.» ");
INSERT INTO taq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Innă Ălɣalim Ɣisa ḍarăt-a-wen: «Simyon, Simyon, ittăr iblis turhajăt n-ad-kăwăn-iskənsəkət šund ălkăma ");
INSERT INTO taq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","măšan, dălăɣ-ak Măssinăɣ i-ad-wăr-ăba immun-năk săr-i; afăl hi-dd-tăqqălăd, səbdəd ayətma-k dăɣ-ăddin.» ");
INSERT INTO taq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Iggăd-dd Bəṭrus, innă i-Ɣisa: «Ălɣalim, năkk, ăsidăwăɣ i-ad-dăr-k idawăɣ s-takărmut hakd-dăɣ s-tamăttant.» ");
INSERT INTO taq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Innʼ-as Ɣisa: «Bəṭrus, ăssiilmădăɣ-kăy a-s, a-s mad-iwət ekăz ăɣora ašăl-i-dăɣ, tăkkuddălăd-ahi har kăraḍ ihăndăggan.» ");
INSERT INTO taq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Innʼ-asăn Ɣisa iket-năsăn ḍarăt-a-wen: «Ălwăqq wa d-kăwăn-ăšmašălăɣ s-tizarăt wăr tăwweyăm aẓrəf wăla šăkkoš, wăla tifădelen, ajăn ăba-hin hărăt fălla-wăn.» Ǝnnăn-as: «Wăla a ənḍărrăn.» ");
INSERT INTO taq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ɣas, innʼ-asăn: «Ămăra, ere ilăn aẓrəf, iḍkəlet-t, ere ilăn šăkkoš, išləjet-t, ere dăɣ-wăn wărăn ila tăkoba, ižănšet-in anăkăbba-net i-ad-tăt-ikrəš ");
INSERT INTO taq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ed, ălleɣeɣ-awăn a-s a-wa ătwănnăn făll-i dăɣ-əlkəttab n-Măssinăɣ a-s inna: ‹Ăḍin dăɣ-inaḍlimăn›, ad-ăj.» ");
INSERT INTO taq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ǝnnăn-as əntăneḍ: «Ălɣalim, sănatăt tikobawen da»; innʼ-asăn: «Tăkat, igdăh-awăn măjrăd!» ");
INSERT INTO taq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ifăl dihen ɣas, ăddew dăr-săn s-taḍaɣt ta n-əzzăytun ed, ăru-dăɣ a-wen-dăɣ a-s izzay ad-t-ăj. ");
INSERT INTO taq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ǝwwăḍăn-in taḍaɣt-en ɣas, innʼ-asăn: «Ădəlăt Măssinăɣ i-ad-kăwăn-agəẓ dăɣ-tănḍărbaten n-Iblis.» ");
INSERT INTO taq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iššənkăš-in Ɣisa fălla-săn s-əḍḍəkuḍ n-tejere n-tăhunt, irkăɣ, ad-itəddal Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ijanna: «Abba, kunta tărhed a-wen-dăɣ, səssijəj-ahi kara n-tisnant-ta-dăɣ măšan hakd a-wen-dăɣ, ăjet erhet wa-năk wădden wa-nin.» ");
INSERT INTO taq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ijanna a-wen-dăɣ a-s has dd-ănfalăl ănjălos n-Măssinăɣ i-ad-t-isəṣṣuhət. ");
INSERT INTO taq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Idgăẓ Ɣisa, ijlăy hullan dăɣ-tamădilt n-Măssinăɣ har tămoos tide-net a olăhăn d-tikruten n-ašni dd-titrəkkitnen făll-ăkall. ");
INSERT INTO taq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Imdă d-tamădilt n-Măssinăɣ ɣas ibdăd, iqqăl-dd inəṭṭulab-net, ogăẓ-tăn-dd tăssooḍăs-tăn tisnant. ");
INSERT INTO taq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Innʼ-asăn: «Ma s-təṭṭasăm? Ǝnkărăt-dd, ădəlăt Măssinăɣ i-ad-kăwăn-agəẓ dăɣ-tănḍărbaten n-Iblis.» ");
INSERT INTO taq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hărwa-dăɣ ămmiijrăd i-inəṭṭulab-net a-s dd-osa ejhăn wa t-ittărăn, ăzzar-as iyyăn dăɣ-inəṭṭulab-net wi n-măraw d-əssin wa s-isəm-net Yăhudəs. Ohăẓ-dd Yăhudəs Ɣisa i-ad-t-asəs dăɣ-idmarăn-net ");
INSERT INTO taq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","măšan, innʼ-as Ɣisa: «Ɣas kăyy Yăhudəs, əmmək wa-dăɣ a-s saɣdarăd Ăgg-ăgg-adəm?» ");
INSERT INTO taq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ǝnhăyăn inəṭṭulab wi iyyăḍnen a-wa ikkăn iji ɣas, ənnăn: «Ak năwtet-t s-tikobawen-nănăɣ meɣ?» ");
INSERT INTO taq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iwăt iyyăn dăɣ-săn akli n-ămănokal n-kăl-tikutawen s-tăkoba-net, ištăf-dd taməẓẓujt-net ta n-aɣil. ");
INSERT INTO taq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iɣtăl-tăn Ɣisa, innʼ-asăn: «Wăr jem a-di.» Iḍăs taməẓẓujt n-ăhaləs, ăzozăy-t. ");
INSERT INTO taq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Innă Ɣisa i-imănokalăn n-kăl-tikutawen d-imănokalăn n-ălgomităn wi ăɣlăfnen ehăn n-ămudd wa măqqărăn d-inušămăn n-Iṣrayil d-wi t-ăššunjătnen: «Ma s-săr-i dd-tăwwayăm tikobawen d-iboriyăn šund ănaɣtaf? ");
INSERT INTO taq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wădden hak ašăl ărtayăɣ dăr-wăn dăɣ-ehăn n-ămudd wa măqqărăn, mafăl wăr hi-dăɣ-s tărmesăm; əlmədăt a-s ašăl-wa-dăɣ, ašăl-năwăn kăwăneḍ d-Iblis d-tihay-net.» ");
INSERT INTO taq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ărmăsăn Ɣisa, əlwăyăn-t s-ehăn n-ămănokal wa n-kăl-tikutawen, ijʼ-asăn Bəṭrus alkum šəjren. ");
INSERT INTO taq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A-s hin-əwwăḍăn dihen, irɣă efew dăɣ-ammas n-ăɣalla, əzzahăn săr-s ăddinăt; ijjăš Bəṭrus ənta-dăɣ, iglă ăqqima edes i-ăddinăt-en. ");
INSERT INTO taq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tənhăy-t tănaxdimt tiyyăt ăqqiima s-efew, təknʼ-e azəjjəzz, tənnă: «Hannăyăm-t wa-daɣ, amidi n-Ɣisa.» ");
INSERT INTO taq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ăkkuddăl Bəṭrus a-wen, innʼ-as: «Tamăḍt, wăr t-əzzeyăɣ.» ");
INSERT INTO taq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A ənḍărrăn ḍarăt-a-wen-dăɣ, inhăy-t ăwadəm iyyăn daɣ, innʼ-as: «Iyyăn dăɣ-săn a tămoosăd.» Innʼ-as Bəṭrus: «Ăhaləs, ălɣafyăt-năk.» ");
INSERT INTO taq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Okăy a iwwăḍăn ăssaɣăt ḍarăt-a-wen, ikyăd dăɣ-s ăhaləs iyyăn, inna: «Ijmaḍ-t ăššăk a-s ăhaləs-i-dăɣ, amidi-năsăn făl-a-s ənta-dăɣ, i n-Galila.» ");
INSERT INTO taq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Innʼ-as Bəṭrus: «Ăhaləs, wăr-əssenăɣ a dăɣ-hi-tăssewălăd.» Diha-dăɣ d-innă Bəṭrus a-wen-dăɣ, hărwa-dăɣ ămmijrăd a-s iwăt ekăz ăɣora. ");
INSERT INTO taq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Innăḍ-dd săr-s Ɣisa, ămmoqqăs asawaḍ-năsăn, iknă dăɣ-s Ɣisa akăyad ɣas, iktă-dd Bəṭrus măjrăd wa s-kăla has-t-ija a-s has-innă: «A-s mad-iwət ekăz ăɣora ašăl-i-dăɣ, tăkkuuddălăd taməzzuyt-in har kăraḍ ihăndăggan.» ");
INSERT INTO taq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Izjăr Bəṭrus, ad-ihall a-wa-dăɣ has-ja tisnant. ");
INSERT INTO taq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ǝzzănăn meddən-wi jănen ənniyăt i-Ɣisa săr-s, ad-dăɣ-s ḍaẓẓăn, təggatăn-t; ");
INSERT INTO taq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ăqqănăn idəm-net s-ekăršăy, ad-has-jannen: «Luləy ya, tăllăɣed-anăɣ ere wa kăy-iwătăn.» ");
INSERT INTO taq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ad-sikuforăn, gaggărăn-t. ");
INSERT INTO taq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ăffăw ɣas, ăddew-dd ălžămaɣăt wa n-inušămăn n-Iṣrayil d-imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt, əlwăyăn Ɣisa s-kăl-ăššăreɣa. ");
INSERT INTO taq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ǝwwăḍăn-in ɣas, əssəstănăn-t, ənnăn-as: «Kunta kăyy a-s Ălmasex, əkkəs-anăɣ dăɣ-taɣdărt.» Innʼ-asăn: «Kud-hawăn-tăn-ənneɣ-dăɣ, wăr hi-e-təfləsăm; ");
INSERT INTO taq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kud-kăwăn-əssəstănăɣ daɣ, wăr hi-e-tăwwăžžăbăm ");
INSERT INTO taq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","măšan, əlmədăt a-s ɣur-ašăl-i-dăɣ, ad-tənhəyăm Ăgg-ăgg-adəm, ăqqiima daw-aɣil n-Măssinăɣ-i ilăn tărna.» ");
INSERT INTO taq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ǝnnăn-as iket-dăɣ-năsăn: «Adiš kăyy a-s Rure-s n-Măssinăɣ?» Innʼ-asăn: «Kăwăneḍ iman-năwăn, tənnăm a-s năkk a t-ămoosăn.» ");
INSERT INTO taq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ǝnnăn ălwăqq-wen: «Ma nətajj i-tajuhe săl ta-dăɣ? Wădden nəslă năkkăneḍ iman-nănăɣ i-a-wa dd-izjărăn emm-net.» ");
INSERT INTO taq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Inkăr ălžămaɣăt iket-net, ittəlwăy Ɣisa s-Bilatəs wa n-gəfăr. ");
INSERT INTO taq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Osăn-in dihen ɣas, ad-t-saḍlamăn, jannen i-gəfăr: «A-s nărmăs ăhaləs-i-dăɣ, išaška tamətte-nănăɣ, ijanna ənta a-s Ălmasex wa n-ămănokal, ijanna daɣ i-ăddinăt wăr ẓelăm tiwse i-Qăyṣăr-i n-ămănokal wa măqqărăn.» ");
INSERT INTO taq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Issəstăn Bilatəs Ɣisa, innʼ-as: «Ak, kăyy a-s ămănokal n-kăl-Ălyăhud meɣ?» Innʼ-as Ɣisa: «Kăyy iman-năk, tənned-tăn.» ");
INSERT INTO taq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Innă Bilatəs i-imănokalăn n-kăl-tikutawen d-tamətte: «Ăhaləs-i-dăɣ, wăr hənnəyăɣ fălla-s uḍlem t-ăsinăhăjjăn d-tamăttant.» ");
INSERT INTO taq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ǝẓẓăjăn ăddinăt imăslan-năsăn s-afălla, ənnăn-as: «Issəntă-dd ašəšk n-tamətte s-a-wa tăt-isăɣra ɣur-Galila ta dd-ifăl har dd-imdă Ălyăhudəyăt, iwwăḍ-dd Yărussălam ămăra.» ");
INSERT INTO taq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Islă Bilatəs i-a-wen ɣas, issəstăn d-a-s Ɣisa i n-Galila meɣ? ");
INSERT INTO taq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ilmăd a-s Galila a t-təlăt ɣas, ăssawăy-t i-Harudəs wa n-gəfăr n-Galila-i fălla-s ixkamăn ed, a-s ităjj a-wen-dăɣ, iha Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Inhăy Harudəs Ɣisa ɣas, iddəwăt hullan făl-a-s ăru irhʼ ahănay-net dăɣ-təssəba n-a-wa fălla-s isăll, ijar daɣ ăṭṭăma n-ad-ăj Ɣisa, iji n-Măssinăɣ iyyăn data-s. ");
INSERT INTO taq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ija Harudəs isəstanăn ăjjootnen i-Ɣisa măšan, wăr t-illa a has-inna Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A-s ităjj a-wen, imănokalăn n-kăl-tikutawen d-ălɣulam n-Ăṭṭăwrăt, saḍlamăn Ɣisa s-ăṣṣahăt. ");
INSERT INTO taq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Iggăd-dd daɣ Harudəs d-əssărdusa-net, ad-t-samăḍrayăn, tajjăn-t tekăškăšt; əssəlsăn-t anăkăbba iknan tihusay, ăssoɣălăn-t ḍarăt-a-wen i-Bilatəs wa n-gəfăr. ");
INSERT INTO taq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ašăl-ənnin-dăɣ, ad-ănmăẓăl Harudəs d-Bilatəs, ămedăwăn ed, dat-a-wa, ănimăkšărăn. ");
INSERT INTO taq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ăsdăw-dd Bilatəs imănokalăn n-kăl-tikutawen d-inušămăn d-tamətte, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","«Ăhaləs-i-dăɣ ya, tăwwăyăm-ahi-t-dd, tənnăm-ahi: ‹Išaška ăddinăt›, əssəstănăɣ-t data-wăn măšan, wăr fălla-s əjrewăɣ făw a t-ăsinăhăjjăn d-tamăttant dăɣ-hărătăn-wi-dăɣ t-sawarăm. ");
INSERT INTO taq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ăssawăyăɣ-t i-Harudəs ənta-dăɣ măšan, wăr t-illʼ uḍlem fălla-s ijraw ed, ăssoɣăl-anăɣ-t-dd. Wăr fălla-s hənnəyăɣ făw a t-ăsinăhăjjăn d-tamăttant. ");
INSERT INTO taq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ăddăbara ămăra, ad-dăɣ-s səwwəjjăɣ tiwit, ăyyăɣ-t-in.»  ");
INSERT INTO taq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ăzzăman-en, hak ămudd n-Faṣka, ăsiwăyyʼ-asăn-in Bilatəs u-takărmut iyyăn. ");
INSERT INTO taq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ohărăn iket-năsăn iyyăn n-emm, ăsɣăren dăɣ-išənnawăn, jannen: «Ămmătet ăhaləs-wa-dăɣ, səwwəyəd-anăɣ-dd Bărɣăbbas.» ");
INSERT INTO taq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bărɣăbbas-i-hi, iha takărmut făl-a-s kăla dd-issənkăr tamətte dăɣ-aɣrəm har ijʼ iman n-ăwadəm dăɣ-a-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ittăr Bilatəs ad-hasăn-ămmăjrăd daɣ ed irha ənta ad-hin-isəwwəyy Ɣisa ");
INSERT INTO taq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","măšan, ăsɣăren iket-dăɣ-năsăn dăɣ-išənnawăn, ənnăn-as: «Itwəṣləbet făll-tajəttewt, itwəṣləbet făll-tajəttewt!» ");
INSERT INTO taq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Olăs-tăn asəstan wa s-kăraḍ, innʼ-asăn: «Mafăl, ma iɣšăd t-ăsiinăhăjjăn d-tamăttant? Wăr fălla-s əjrewăɣ a t-ăsinăhăjjăn d-tamăttant; ăddăbara ămăra, ad-dăɣ-s səwwəjjăɣ tiwit, səwwəyyăɣ-t-in.» ");
INSERT INTO taq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ăxwălăn-t s-iɣăran-năsăn, tattărăn dăɣ-s ad-itwăṣləb făll-tajəttewt. Oyyʼ-asăn iman-net, ăsjăd-asăn Bilatəs, ");
INSERT INTO taq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ăllil erhet-năsăn, iɣtăs-as tamăttant, ");
INSERT INTO taq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ăswăyyʼ-asăn-in ăhaləs wa dăɣ-s əttărăn ihăn takărmut dăɣ-təssəba n-asənkar wa dd-ija i-tamətte d-iman-wi ija, ija Ɣisa dăɣ-ifassăn-năsăn i-ad-has-əjən a-wa s-ărhăn. ");
INSERT INTO taq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ălwăqq wa d-ăwwăyăn Ɣisa i-ad-itwăṣləb, ăšhăššălăn ăhaləs s-isəm-net Simyon n-tadăbayt ta n-Qərwan dd-ifalăn išəkraš alənji n-tajəttewt ta făll-mad-itwăsḷəb Ɣisa; iḍkăl-tăt, ilkăm-asăn. ");
INSERT INTO taq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Təlkam-asăn daɣ tamətte tăjjeet əhanăt tiḍeḍen ăsiikălălnen, təggatnăt iman-năsnăt s-ăkall. ");
INSERT INTO taq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Innăḍ-dd săr-snăt Ɣisa, innʼ-asnăt: «Šăt-Yărussălam, wăr təlhemăt făll-i, əlhəmăt făll-iman-năkmăt d-aratăn-năkmăt ");
INSERT INTO taq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ed, malăn-dd išilan dăɣ-mad-itwənn: ‹Tənḍəḍ i-timəjjejruten d-ti s-kăla wăr-əkrešnăt ara, wăr kăla ăssoḍăḍnăt›, ");
INSERT INTO taq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ašăl-en, ad-ənnən ăddinăt i-iḍaɣăn: ‹Aḍəwăt fălla-năɣ›, ənnən i-tiḍaɣen: ‹Ălsəmăt-anăɣ› ");
INSERT INTO taq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","făl-a-s, efew kunta ošal dăɣ-ahəšk ibdajăn s-əmmək-wa-dăɣ, ma inna wa ăqqurăn?» ");
INSERT INTO taq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ăttilwăyăn daɣ dăɣ-a-wen-dăɣ əssin inaɣtafăn əkkanen tamăttant əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ălwăqq wa d-hin-əwwăḍăn edăgg wa s-itawănna: «Edăgg wa n-akărkor», əṣlăbăn Ɣisa, əṣlăbăn daɣ inaɣtafăn edes-has, iyyăn daw-aɣil-net, wa iyyăḍăn daw-tăšalje-net. ");
INSERT INTO taq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ălwăqq wa d-əṣlăbăn Ɣisa, innă: «Abba, ănš-asăn făl-a-s, wăr-əssenăn a hăn»; jăn ḍarăt-a-wen tisăɣeren i-ad-uẓanăn isəlsa-net jer-iman-năsăn. ");
INSERT INTO taq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A-s ităjj a-wen, təbdad tamətte, tăjjəyha i-a-wa ijăn iket-net; ḍaẓẓăn imănnăhăḍăn n-kăl-Ălyăhud dăɣ-Ɣisa, jannen: «Wădden iɣlăs ăddinăt wi iyyăḍnen, iɣləset ya iman-net ămăra kunta ənta a-s Ălmasex wa ăsnăfrăn Măssinăɣ i-iman-net.» ");
INSERT INTO taq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ǝjăn-t əssărdusa taḍăẓẓa, ẓahaẓăn-t-dd bənegăr, hakkăn-as-t, ");
INSERT INTO taq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","jannen-as: «Kunta kăyy a-s ămănokal n-kăl-Ălyăhud, ăɣləs iman-năk ya!» ");
INSERT INTO taq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ǝttəytăyăn ăllox jənnəj-s, iktab fălla-s: ");
INSERT INTO taq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iggăd-dd iyyăn dăɣ-inaɣtafăn wi ătwăṣlăbnen dihen, ad-isamăḍray Ɣisa, ijannʼ-as: «Wădden kăyy a-s Ălmasex, ăɣləs iman-năk ya, tăɣləsăd-anăɣ!» ");
INSERT INTO taq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ăklăwlăw ănaɣtaf-wa iyyăḍăn făll-amidi-net, innʼ-as: «Kăyy-i dăr-s oharăn tisnant-ta-dăɣ, uksaḍ Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","năkkăneḍ, a-wa hanăɣ-irmăsăn, imojjan-nănăɣ a săr-năɣ-t-dd-orăwăn, nănihăjja dăr-s, iwar-anăɣ uḍlem măšan ənta, wăr t-illa a lăbasăn iɣšad.» ");
INSERT INTO taq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Innʼ ănaɣtaf wa s-iket imməjrăd i-Ɣisa: «Ǝktəw-ahi-dd afăl dd-tăqqălăd tăminakălăd.» ");
INSERT INTO taq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Innʼ-as Ɣisa: «Ăsidătteɣ-ak a-s ašăl-i-dăɣ, ad-dăr-i tahərəd ălžănnăt.» ");
INSERT INTO taq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A-s ităjj a-wen-dăɣ, išwar təja tarăhut, əlsănăt tihay ărori n-ăkall iket-dăɣ-net hundăɣ har təja tezzar. ");
INSERT INTO taq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tăttunkăl tăfukt, iqqărrawăt ărido wa ibḍăn dăɣ-ehăn n-ămudd wa măqqărăn, edăgg wa šăddijăn d-wa iknăn təšədje. ");
INSERT INTO taq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ăsɣărăt Ɣisa s-ăṣṣahăt ḍarăt-a-wen, innă: «Abba, ărməs unfas-in.» Innă a-wen-dăɣ ɣas, əjmăḍăn-t iman. ");
INSERT INTO taq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Inhăy kăbtăn wa ixkămăn făll-əssărdusa wi əṣlăbnen Ɣisa a-wa ijăn ɣas, omăl Măssinăɣ, innă: «Wăr t-ihʼ ăššăk a-s ăhaləs-i-dăɣ, ămaɣdal.» ");
INSERT INTO taq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ǝnhăyăn ăddinăt wi dd-ăddewnen s-edăgg-wen-dăɣ a-wa ijăn, əqqălăn, ănxasăn iman-năsăn hullan. ");
INSERT INTO taq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A-s ităjj a-wen-dăɣ, əbdadăn imidiwăn n-Ɣisa dăɣ-ijəj əkyadăn əntăneḍ d-tiḍeḍen-ti has-dd-əlkămnen wa-dăɣ n-Galila har əntănăteḍ-da-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Osă-dd ăhaləs oɣadăn, olaɣăn n-taɣrəmt ta n-Arimata s-isəm-net Yusəf, iha inušămăn n-Iṣrayil-wi ɣattăsnen ăššăreɣa, ");
INSERT INTO taq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","wăr-oher d-imizărăn-wi iyyăḍnen ăddăbaratăn-wi jăn dăɣ-isălan n-Ɣisa ed ijar ăṭṭăma n-a-s ilkam ad-dd-təzzubbət Təmmənəya n-Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ənta-en-dăɣ a ihălăn ad-ăkk Bilatəs, ittăr dăɣ-s tafəkka n-Ɣisa, ");
INSERT INTO taq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","oyyas-tăt Bilatəs ɣas, ikkăs-dd Yusəf tafəkka n-Ɣisa făll-tajəttewt, ijʼ-et dăɣ-tefit təzzar, issənsʼ-et dăɣ-aẓəkka iɣašăn dăɣ-esăwăl s-kăla wăr dăɣ-s insa ere ăba. ");
INSERT INTO taq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Itajj a-wen-dăɣ ašăl wa d-siməjnun ăddinăt i-ămudd wa n-əssəbət-i n-tăsonfat. ");
INSERT INTO taq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ǝlkămnăt tiḍeḍen-ti dd-ăddewnen d-Ɣisa wa-dăɣ n-Galila har diha-dăɣ i-Yusəf, ənhăynăt edăgg n-aẓəkka-en hakd-dăɣ əmmək wa s-tənsa tafəkka n-Ɣisa dăɣ-aẓəkka-en. ");
INSERT INTO taq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ǝqqălnăt ihănan ɣas, ad-sadawnăt əlɣənfărăn d-aḍutăn. Ijă ašăl wa n-əssəbət-i n-tăsonfat ɣas, ăssunfănăt ed, a-wen-dăɣ, a innă alămăr wa n-ănnăbi Mosa. ");
INSERT INTO taq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Abənnəbən n-ălxad-i n-ašăl wa ăzzarăn dăɣ-əssəboɣ, əkkănăt tiḍeḍen aẓəkka ăwwaynăt əlɣənfărăn d-aḍutăn-wi dd-ăsdăwnăt, ");
INSERT INTO taq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ăwwăḍnăt-in aẓəkka, ogăẓnăt-in tăhunt-ta hărăt emm n-aẓəkka, tăɣirarăd-in, ");
INSERT INTO taq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","əjjăšnăt ammas n-aẓəkka măšan, wăr dăɣ-s ənheynăt tafəkka n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ăqqanăn iɣăfawăn-năsnăt dăɣ-a-wen-dăɣ a-s dd-əbdădăn əssin meddən əlsanen isəlsa ăsimăɣmăɣnen edes-hasnăt, ");
INSERT INTO taq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","jănăt tarəmmeɣt-ta-dăɣ făl dd-hănăt-ărkaɣnăt, ăsiḍăsnăt timmawen-năsnăt ăkall. Ǝnnăn-asnăt meddən: «Ma s-tammăɣmăt i-ere iddarăn jer-inəmmuttan? ");
INSERT INTO taq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɣisa, wăr t-illa diha, inkăr-dd dăɣ-tamăttant. Ǝktəwmăt-dd a-wa innă hărwa iha teje ta n-Galila, ");
INSERT INTO taq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","a-s innă: ‹Ăgg-ăgg-adəm, ilzam ad-ăttărmăs, ijjəš ifassăn n-inăsbăkkaḍăn, əṣləbăn-t măšan, ašăl wa s-kăraḍ, a dd-inkăr jer-inəmmuttan.› » ");
INSERT INTO taq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ǝktănăt-dd iməjridăn-win-dăɣ ija Ɣisa. ");
INSERT INTO taq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Fălnăt aẓəkka ɣas, əkkănăt inəṭṭulab wi n-măraw d-iyyăn d-inalkimăn-wi iyyăḍnen, jănăt dăɣ-săn isălan. ");
INSERT INTO taq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tiḍeḍen-en, hʼ-enăt Măryăma ta n-tadăbayt ta n-Mulăždaləyăt, Tăxya d-Măryăma ta n-ma-s n-Yaqub d-tiyyăḍ daɣ sidəttutnen a-wa ənnănăt i-inəṭṭulab ");
INSERT INTO taq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","măšan, jăn-tănăt tinəbbuddal wăren əssen a jannenăt, unjăyăn s-ad-tănăt-əfləsăn. ");
INSERT INTO taq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iggăd-dd Bəṭrus, ošăl s-aẓəkka, iwwăḍ-in ɣas, ăssijja dăɣ-ămmas-net măšan, wăr dăɣ-s inhey ar tefit tənsat d-iman-net, iqqăl ənta-dăɣ iqqan a-wa ijăn eɣăf-net. ");
INSERT INTO taq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ǝkkăn inalkimăn n-Ɣisa əssin ašăl-wen-dăɣ taɣrəmt ta n-Imayus tănimăjjajăt d-Yărussălam s-əḍḍəkuḍ n-măraw kelumetărăn d-əssin, ");
INSERT INTO taq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ăssokalăn, simɣuɣulăn isălan n-a-wa ijăn iket-net ");
INSERT INTO taq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","a-s tăn-dd-iwwăḍ Ɣisa iman-net, ăddew dăr-săn ");
INSERT INTO taq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","măšan, indăr i-tiṭṭawen-năsăn ad-t-əzzəynăt. ");
INSERT INTO taq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Imməjrăd-asăn, innʼ-asăn: «Ma s-tărjašăm ham ti-net?» Ăqqănăn iɣăfawăn-năsăn, əbdădăn, ");
INSERT INTO taq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","innʼ-as dăɣ-săn wa s-isəm-net Kălyobbas: «Ɣas, kăyy ɣas, dăɣ-Yărussălam təmdat a wăr hen isălan n-a-wa dăɣ-s ijăn išilan-wi-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Innʼ-asăn: «Ma dăɣ-s ijăn?» Ǝnnăn-as: «Un a-wa ijrăwăn Ɣisa wa n-Năṣirăt-i ămoosăn ănnăbi ăṣṣoohen s-imojjan-net hakd măjrăd-net dat-Măssinăɣ d-tamətte iket-net, ");
INSERT INTO taq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ărmăsăn-t imănokalăn n-kăl-tikutawen d-imizărăn-nănăɣ, ăssoḍăn-t dăɣ-ăššăreɣa-năsăn təzzar, əṣlăbăn-t. ");
INSERT INTO taq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Năkkăneḍ, nămoos hărăt dăɣ-wi əjărnen ăṭṭăma n-a-s ənta a madăn-iɣləs Iṣrayil măšan, a-wa ašăl wa s-kăraḍ d-əjăn hărătăn-win-dăɣ, ");
INSERT INTO taq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ăqqănnăt daɣ tiḍeḍen-nănăɣ tiyyăḍ iɣăfawăn-nănăɣ ed, ənšăynăt aẓəkka ");
INSERT INTO taq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","măšan, wăr dăɣ-s in-ogeẓnăt tafəkka-net, ăqqălnăt-dd, ənnănăt ănfalălăn-asnăt-dd ănjălosăn hasnăt-ənnănen, iddar. ");
INSERT INTO taq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Osăn iyyăḍ dăɣ-năɣ daɣ aẓəkka, ăsbayănăn a-wa ənnănăt tiḍeḍen măšan, Ɣisa iman-net, wăr t-illa ere t-inhayăn.» ");
INSERT INTO taq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Innʼ-asăn Ɣisa ălwăqq-wen: «Kăwăneḍ-i-š, tidət-dăɣ a-s ijraw-kăwăn iba n-tayətte, uhən, ma ăsiɣărăn ulhawăn-năwăn, igdal-awăn ad-təjrăhăm a-wa ənnăn ănnăbităn dăɣ-əlkəttabăn n-Măssinăɣ? ");
INSERT INTO taq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wădden ənnăn ilzam ad-inhəy Ălmasex tăhănšariḍt təzzar, ijjəš ălxurmăt-net.» ");
INSERT INTO taq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Irmăs-asăn-dd ḍarăt-a-wen ɣur-ănnăbi Mosa, ikkă-dd ɣur-ănnăbităn wi iyyăḍnen iket-năsăn, itafăssar-asăn a-wa ənnăn əlkəttabăn dăɣ-isălan-net. ");
INSERT INTO taq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ohăẓăn-in taɣrəmt ta əkkăn ɣas, issəknʼ-en a-s okay-tăn ");
INSERT INTO taq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","măšan, ənnăn-as: «Ɣayəm ɣur-năɣ ed, ašăl iglă, ehăḍ-dăɣ, išwar ija», ăzzubbăt ɣur-săn. ");
INSERT INTO taq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ǝqqălăn tetăte ɣas, iḍkăl tajəlla, ămmoy i-Măssinăɣ, irẓʼ-et, ikfʼ-asăn-tăt. ");
INSERT INTO taq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ămerănăt tiṭṭawen-năsăn ălwăqq-wen-dăɣ, əzzăyăn-t măšan, ăttunkăl-asăn ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ănmănnăn jer-iman-năsăn: «Wădden a-s hanăɣ-ămmijrăd dăɣ-tabarăt, isafham-anăɣ əlkəttabăn n-ănnăbităn, sanăjmaḍăn ulhawăn-nănăɣ făll-ad-t-əzzəyăn.» ");
INSERT INTO taq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ǝbdădăn ăssaɣăt-wen-dăɣ, əqqălăn Yărussălam. Ogăẓăn-in inəṭṭulab wi n-măraw d-iyyăn d-inalkimăn-wi iyyăḍnen, ăžžiimmăɣăn dăɣ-edăgg iyyăn. ");
INSERT INTO taq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ǝnnăn-asăn inəṭṭulab d-inalkimăn-wi iyyăḍnen: «Ijmaḍ-t ăššăk a-s Ɣisa, inkăr-dd jer-inəmmuttan, inhay-t Simyon.» ");
INSERT INTO taq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ǝllăɣen-asăn əntăneḍ-dăɣ amuqqəs wa əjăn dăr-s dăɣ-tabarăt d-əmmək wa s-t-əzzăyăn ălwăqq wa d-irẓa tajəlla. ");
INSERT INTO taq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ămmiijrădăn hărwa a-s dd-ibdăd Ɣisa iman-net jere-săn, innʼ-asăn: «Insʼ ălxer n-Măssinăɣ fălla-wăn.» ");
INSERT INTO taq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ăxwălăn, əggădăn ənniyătăn-năsăn, əknăn tarəmmeɣt ed, ăɣelăn ămăttănkul a hannăyăn ");
INSERT INTO taq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","măšan, innʼ-asăn Ɣisa: «Ma kăwăn-ixwalăn, iggad d-ənniyătăn-năwăn, ikkas tafləst dăɣ-ulhawăn-năwăn? ");
INSERT INTO taq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ǝkyədăt dăɣ-ifassăn-in d-iḍarăn-in, năkk iman-in a-wa, ăḍəsăt-ahi, təkyədăm dăɣ-i i-ad-təkkəsăm ăššăk, ămăttănkul, wăr dăr-i mad-alăh ed, wăr-ila taɣəssa wăla iɣăsan.» ");
INSERT INTO taq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ijannʼ-asăn a-wen, isaknʼ-en ifassăn-net d-iḍarăn-net ");
INSERT INTO taq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","măšan, təgdăl-asăn təmɣăre n-tedăwit-i-dăɣ jăn ad-t-əfləsăn. Inhăy a-s ăqqanăn iɣăfawăn-năsăn ɣas, innʼ-asăn: «Ak təlam a itamăkšen diha?» ");
INSERT INTO taq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ǝkfăn-t-dd ašăr n-emăn ăhhoɣen, ");
INSERT INTO taq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","irmăs-t-dd, ikšʼ-e data-săn. ");
INSERT INTO taq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Innʼ-asăn ḍarăt-a-wen: «A-wa-dăɣ a hawăn-janneɣ hărwa əlleɣ jere-wăn a-s ăhhuuššăl ad-itbət a-wa făll-i iktabăn dăɣ-alămăr wa n-ănnăbi Mosa d-əlkəttabăn wi n-ănnăbităn d-Ăẓẓăbur.» ");
INSERT INTO taq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ora ălwăqq-wen tiyətwen-năsăn i-ad-əfhəmăn əlkəttabăn, ");
INSERT INTO taq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","innʼ-asăn: «Iktab a-s Ălmasex, ilzam ad-inhəy tăhănšariḍt, inkăr-dd ašăl wa s-kăraḍ jer-inəmmuttan, ");
INSERT INTO taq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ətwəjjən ḍarăt-a-wen isălan n-tătubt d-tenăšše n-ibăkkaḍăn s-isəm-net i-tiwsaten iket-dăɣ-năsnăt, isănt a-wen dăɣ-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kăwăneḍ a jeɣ tijuhawen n-a-wen iket-net, ");
INSERT INTO taq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","năkk daɣ, ad-hawăn-dd-səssiwəyăɣ a-wa s-hawăn-ija Abba-nin ărkăwăl-net, a-wen-dăɣ a făl wăr felăm aɣrəm-wa-dăɣ, a təkkăs tărna ta dd-fălăt išənnawăn wăr kăwăn-təlsa.» ");
INSERT INTO taq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ilwăy-tăn ḍarăt-a-wen har edes i-tadăbayt ta n-Bitanya, iḍkăl ifassăn-net, ija dăɣ-săn ălbăraka. ");
INSERT INTO taq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Itajj dăɣ-săn ălbăraka hărwa a-s dăr-săn ibḍa, imməḍkăl s-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ărkăɣăn-as əntăneḍ dihen-dăɣ təzzar, əqqălăn Yărussălam əknan dăɣ-tedăwit. ");
INSERT INTO taq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hak ašăl ḍarăt-a-wen, timăqqusăn dăɣ-ehăn n-ămudd wa măqqărăn ihăn Yărussălam, tiimələn Măssinăɣ. Amin!");
INSERT INTO taq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","S-tizarăt, a-s wăr t-illa a dd-ixlakăn, wăr t-illa a t-illăn a săl Wa s-itawănna Măjrăd, Măjrăd illʼ-e ɣur-Măssinăɣ, Măjrăd ənta a-s Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Illʼ-e s-tizarăt ɣur-Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ənta a-s dd-ixlăk Măssinăɣ hărăt iket-net, wăr t-illa a dd-ixlakăn ar s-ənta, ");
INSERT INTO taq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ənta a ăssodărăn hărăt iket-net, tămudre-ten-dăɣ ihakk a-s ănnur i-dăgg-adəm; ");
INSERT INTO taq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ănnur, ămilăwlăw dăɣ-tihay măšan, unjăynăt săr-s. ");
INSERT INTO taq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Osă-dd ăhaləs dd-ăsimašăl Măssinăɣ s-isəm-net Exya, ");
INSERT INTO taq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","i-ad-umas tajuhe, amənăn dăgg-adəm s-ănnur wa făll-hasăn-itajăyha. ");
INSERT INTO taq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wăr-ămoos ənta iman-net ănnur, tajuhe-net a ămoos. ");
INSERT INTO taq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ănnur-i-hi, ənta a-s wa n-tidət dd-osăn ăddunya i-ad-imləwləw făll-dăgg-adəm, arr tiṭṭawen-năsăn. ");
INSERT INTO taq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wa s-itawănna Măjrăd, ijjăš-dd ăddunya, təbnă-dd săr-s măšan, tunjăy s-ad-t-təzzəy, ");
INSERT INTO taq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","osă-dd ănnur ăkall-net măšan, wăr t-ăqbelăn imălan-net, ");
INSERT INTO taq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","hakd a-wen-dăɣ dăɣ, wi t-ăqbălnen, omănăn săr-s, ăsdabăt-tăn ad-umasăn aratăn n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aratăn-en, tiwit-năsăn, wăr tămoos ta n-tăsa wăla ta n-erhet n-taɣəssa wăla erhet n-ăgg-adəm, ti n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Măjrăd, ămoos-dd ăgg-adəm, izzăɣ-dd jere-năɣ ănnuuflăy dăɣ-ănnuɣmăt d-tidət, năjjunfă dăɣ-ălxurmăt-net, ălxurmăt daɣ wa ikarrăš Alyaḍ s-wăr-ilʼ Abba i săl ənta. ");
INSERT INTO taq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ǝnta-en-dăɣ a făll-ăjjəyha ănnăbi Exya a-s innă s-afălla: «Ad-hi-dd-išrəy ere hi-ojărăn făl-a-s illʼ-e hărwa wăr dd-ăxlekăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nəjrăw iket dăɣ-nănăɣ ejădăr-nănăɣ dăɣ-ălxurmăt n-ănnuɣmăt-net, ajăraw nəja-dăɣ, ilkam-as iyyăn ");
INSERT INTO taq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","făl-a-s, əmmək wa s-ija Măssinăɣ Ăṭṭăwrăt dăɣ-ăfuss n-ănnăbi Mosa, ənta daɣ a-s ija ănnuɣmăt-net d-tidət-net dăɣ-ăfuss n-ƔisaĂlmasex. ");
INSERT INTO taq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Măssinăɣ, wăr t-illa ere s-kăla t-inhăy măšan, Rure-s wa n-iyyăn ɣur-s izzăɣăn, ăsbayăn-anăɣ-t-dd. ");
INSERT INTO taq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ǝnta da tajuhe ta ijʼ Exya a-s săr-s dd-ăšmăšălăn imănokalăn n-kăl-Ălyăhud wi hănen Yărussălam, kăl-tikutawen d-dăgg-Lewi i-ad-t-səstənăn d-a-wa ămoos. ");
INSERT INTO taq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wăr hasăn-iffer iman-net, innʼ-asăn: «Wădden năkk a-s Ălmasex.» ");
INSERT INTO taq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Olăsăn-t asəstan: «Adiš mi tămoosăd? Ămmuukkăn kăyy a-s ănnăbi Ɣəli?» Innʼ-asăn: «Wăr t-ămoosăɣ.» Ǝnnăn-as: «Adiš kăyy a-s ănnăbi wa s-ənnăn ănnăbităn ilkam a dd-ass?» Innʼ-asăn: «Ăbo!» ");
INSERT INTO taq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Olăsăn-as tənna: «Adiš, mi tămoosăd? Nărha ălwižab năwwăy i-ăddinăt wi hanăɣ-dd-ăšmašălnen, ma tənned, mi tămoosăd?» ");
INSERT INTO taq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Innʼ-asăn: «Năkk a-s wa ăseɣăren dăɣ-tenere, janneɣ: ‹səssiɣədăt tabarăt dat-Emăli›, s-əmmək wa s-tăn-innă ănnăbi Saya.» ");
INSERT INTO taq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ăddinăt-win-dăɣ săr-s dd-ămešălnen, i n-taggayt ta n-kăl-faris. ");
INSERT INTO taq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Olăsăn-t asəstan daɣ, ənnăn-as: «Adiš mafăl salmaɣăd ăddinăt dăɣ-aman a-s wădden kăyy a-s Ălmasex wăla, Ɣəli wăla ănnăbi wa s-ătwănna?» ");
INSERT INTO taq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ăwwežăb-asăn, innʼ-asăn: «Năkk, aman a dăɣ-salmaɣăɣ ăddinăt măšan, illʼ-e jere-wăn ere wăr təzzeyăm, ");
INSERT INTO taq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ad-hi-dd-išrəy, wăr-ănhăjjăɣ wăla-dăɣ d-ad-ăḍəsăɣ issal n-tifădelen-net făl mijraw-i-dăɣ hi-ija.» ");
INSERT INTO taq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tadăbayt ta n-Bitanya təwărăt asălim n-Ɣurdəni wa n-atăram a dăɣ-itajj a-wa-dăɣ, dihen-dăɣ ad-isalmaɣ Exya ăddinăt dăɣ-aman. ");
INSERT INTO taq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ašăl wa n-ḍarăt-wen, inhăy Exya Ɣisa ikkʼ-e-hi-dd, innă i-tamətte: «Ǝnhəywăt-ak Ašăɣol n-Măssinăɣ wa itakkăsăn ibăkkaḍăn n-ăddunya! ");
INSERT INTO taq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ǝnta-i-dăɣ a făll-hawăn-ənneɣ: ad-hi-dd-išrəy ere hi-ojărăn făl-a-s illʼ-e hărwa wăr dd-ăxlekăɣ; ");
INSERT INTO taq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","năkk iman-in, ibda wăr t-əzzeyăɣ măšan, i-ad-dd-ibbuyən i-kăl-Iṣrayil, oseɣ-dd i-ad-salmaɣăɣ dăɣ-aman.» ");
INSERT INTO taq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Olăs daɣ Exya ajəyh, inna: «Hannăyăɣ Unfas Šăddijăn, ifal-dd išənnawăn dăɣ-ănnuɣ n-tedăbert măllăt har fălla-s ăsjăn, izzăɣ fălla-s. ");
INSERT INTO taq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kăla t-əlleɣ wăr t-əzzeɣăɣ măšan, wa hi-dd-ăšmašălăn i-ad-salmaɣăɣ dăɣ-aman, innʼ-ahi: ‹Ere wa s-tənhăyăd Unfas har fălla-s ăsjăn, izzăɣ fălla-s, ənta a ihakkăn Unfas Šăddijăn.› ");
INSERT INTO taq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Năkk daɣ, ənhăyăɣ-t, ăjjəyhăɣ a-s ənta a-s Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ašăl wa n-ḍarăt-wen, ibdad Exya d-inəṭṭulab-net əssin dăɣ-edăgg-wənnin-dăɣ a-s iswăḍ, ");
INSERT INTO taq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","inhăy Ɣisa okay ɣas, innă: «Ǝnhəywăt-ak Ašăɣol n-Măssinăɣ!» ");
INSERT INTO taq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ǝslăn inəṭṭulab-net wi n-əssin i-măjrăd-wen-dăɣ ijʼ Exya ɣas, əlkămăn i-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ăšnăšlăm Ɣisa ḍara-s, inhăy a-s əlkamăn-as ɣas, innʼ-asăn: «Ma tărham?» Ǝnnăn-as: «Răbbi, a-wen ălmăɣna-net: Ălɣalim! Ǝnde d-təzzaɣăd?» ");
INSERT INTO taq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Innʼ-asăn: «Ǝyyăwăt, ad-t-tənhəyăm.» Ǝglăn, ənhăyăn dihad izzăɣ, əzzăɣăn ɣur-s ašăl-en-dăɣ. Itajj a-wen s-takkăṣt. ");
INSERT INTO taq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Inəṭṭulab wi n-əssin əslănen i-măjrăd wa ijʼ Exya făll-Ɣisa ɣas əlkămăn-as, iyyăn dăɣ-săn Idris wa n-ăŋŋa-s n-Simyon Bəṭrus; ");
INSERT INTO taq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Idris-en-dăɣ a osăn ăŋŋa-s Simyon, innʼ-as: «Ǝyyăw, nəjrăw Ălmasex». Ălmasex, ălmăɣna-net: Wa innəfrănăn. ");
INSERT INTO taq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ilwăy Idris Simyon s-Ɣisa. Ikna Ɣisa akăyad dăɣ-Simyon, innʼ-as: «Wădden isəm-năk: Simyon ăgg Yunəs? Ad-kăy-iwăr isəm Sefas». Sefas, ălmăɣna-net: Tăhunt. ");
INSERT INTO taq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ašăl wa n-ḍarăt-wen, ikka Ɣisa teje ta n-Galila a-s ămmoqqăs d-Fəlibb, innʼ-as: «Fəlibb, əlkəm-ahi.» ");
INSERT INTO taq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fəlibb hakd Idris d-Bəṭrus, iket-năsăn, i n-taɣrəmt ta n-Băṭsayda. ");
INSERT INTO taq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iglă Fəlibb ənta-dăɣ har osa Natanăhil, innʼ-as: «Ašăl-i, nəjrăw ere wa s-ijʼ ănnăbi Mosa isălan-net dăɣ-Ăṭṭăwrăt, əllăɣen daɣ ănnăbităn s-ass-net: a t-ămoosăn Ɣisa wa n-ăgg Yusəf n-taɣrəmt ta n-Năṣirăt». ");
INSERT INTO taq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Innʼ-as Natanăhil: «Ajăn Năṣirăt, a tăt-dd-ifəl a olaɣăn?» Innʼ-as Fəlibb: «Ǝyyăw, ənhəy-t.» ");
INSERT INTO taq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Inhăy Ɣisa Natanăhil ikkʼ-e-hi-dd ɣas, innă: «Ašăl-i-š, hannăyăɣ U-Bănu-Iṣrayil n-ăgg-alăṣăl wăr ha tăkkărzăzzăl.» ");
INSERT INTO taq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Innʼ-as Natanăhil: «Ǝnde hi-təzzăyăd?» Innʼ-as Ɣisa: «Hannăyăɣ-kăy hărwa wăr kăy-dd-iɣra Fəlibb, a-s ija a-wen, təlled-t daw-tele n-ašar.» ");
INSERT INTO taq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Iḍkăl Natanăhil emăsli-net, innă: «Ălɣalim, kăyy a-s Rure-s n-Măssinăɣ, kăyy a-s ămănokal n-Iṣrayil!» ");
INSERT INTO taq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Innʼ-as Ɣisa: «Ɣas a-wa-dăɣ făl hak-ənneɣ hannăyăɣ-kăy hărwa təlled-t daw-tele n-ašar a făl tomănăd? Ǝlməd a-s ilkam dăɣ-k ad-tənhəyăd hărătăn ojărnen a-wen-dăɣ təmɣăre. ");
INSERT INTO taq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ad-tənhəyăm išənnawăn ămerăn, tənhəyăm daɣ ănjălosăn n-Măssinăɣ tiwənən tizəbbun-dd făll-Ăgg-ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kăraḍ išilan ḍarăt-a-wen, ijʼ aẓli dăɣ-hin-tătiwăɣra ma-s n-Ɣisa dăɣ-taɣrəmt n-Kăna ta n-Galila; ");
INSERT INTO taq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ătwăɣrʼ-in daɣ Ɣisa s-aẓli-en-dăɣ ənta d-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ǝmdăn aman n-lăɣnăb wi ăxxiimmărnen tamăswanen dăɣ-aẓli ɣas, tənnʼ-as ma-s: «Ăddinăt ya, ăbas lan aman n-lăɣnăb wi ăxxiimmărnen əswăn.» ");
INSERT INTO taq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Innʼ-as Ɣisa: «Anna, taẓidert, ăssaɣăt-in, wăr dd-iwweḍ hărwa.» ");
INSERT INTO taq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tənnă ma-s i-inaxdimăn: «A hawăn-innă-dăɣ, təjəm-t.» ");
INSERT INTO taq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ǝllan-t dihen săḍis iɣsas măqqornen əknanen dăɣ-tăhunt s-təggatăn kăl-Ălyăhud ălwăḷḷa s-aman-wi tăn-hănen; hak iyyăn dăɣ-iɣsas-en-dăɣ, itiwəy temeḍe n-lităr. ");
INSERT INTO taq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Innă Ɣisa i-inaxdimăn: «Ǝḍkărăt-dd iɣsas-i-hi aman»; əḍkărăn-tăn har imawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Innʼ-asăn daɣ: «Ǝlkəwăt ămăra, tawəyəm i-ere-wa ănnihăḍăn dăɣ-imənsiwăn»; jăn a-wa hasăn-inna. ");
INSERT INTO taq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ăkrăbbăt emănnăhăḍ n-imənsiwăn aman n-lăɣnăb wi ăxxiimmărnen s-wăr-issen e-s t-dd-hăn kud-dăɣ əssanăn inaxdimăn-wi tăn-dd-əlkăwnen siha s-dd-hăn; iɣră-dd ămaẓlay, ");
INSERT INTO taq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","innʼ-as: «Wăr t-illa ere s-wădden aman n-lăɣnăb wi ăxxiimmărnen ăẓednen a isaswa ăddinăt har tăn-ijməḍ ənniyăt təzzar, išəšrəy-tăn-dd wi wăren əkna tăẓude măšan, kăyy wi ăẓednen a təššəšrăyăd.» ");
INSERT INTO taq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iji n-Măssinăɣ wa-dăɣ ija Ɣisa dăɣ-Kăna ta n-Galila a-s iji-net wa ăzzarăn, ăsnăfalăl-dd săr-s tărna-net dat-ăddinăt, omănăn sar-s inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ătrara Ɣisa ḍarăt-a-wen, ikka taɣrəmt ta n-Qăfărnaxum ăddeew d-ma-s d-ayətma-s d-inəṭṭulab-net măšan, wăr-ăhoja dihen. ");
INSERT INTO taq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ohăẓ-dd ămudd n-kăl-Ălyăhud wa n-Faṣka ɣas, ăjoẓăy Ɣisa, ikka Yărussălam. ");
INSERT INTO taq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ogăẓ-dd dăɣ-ehăn n-ămudd wa măqqărăn ăttužžar n-iwdesăn d-tihatten d-tidăberen d-kăl-amăhaš ăqqiimăn dăɣ-s, ");
INSERT INTO taq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","iknă-dd ebărtăk n-iɣunan, ad-tăn-isattăɣ əntăneḍ d-tihatten-năsăn d-iwdesăn-năsăn, išamăhaš iẓărfan n-kăl-amăhaš, isibrăɣwil tisəskar-năsăn, ");
INSERT INTO taq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ijanna i-ăttužžar n-tidăberen: «Ǝkkəsăt a-wa diha, wăr jem ehăn n-Abba-nin ehăn n-mamăla.» ");
INSERT INTO taq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Innă a-wen ɣas, əktăn-dd inəṭṭulab-net a-s iktab dăɣ-măjrăd n-Măssinăɣ a-s: «Tədgaẓ-ahi tărha n-ehăn-năk.» ");
INSERT INTO taq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ǝggădăn-dd săr-s imizărăn n-kăl-Ălyăhud, ənnăn-as: «Ma ămoos iji n-Măssinăɣ wa s-tăddobed iji-net i-ad-hanăɣ-səfləsăd a-s a-wa jed ămăra-dăɣ, led săr-s.» ");
INSERT INTO taq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Innʼ-asăn: «Ăndăt ehăn n-ămudd-wa-dăɣ ad-hawăn-t-dd səbdədăɣ dăɣ-kăraḍ išilan.» ");
INSERT INTO taq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ǝnnăn-as kăl-Ălyăhud: «Kăhh! Ajăn wădden ehăn n-ămudd-wa-dăɣ, əkkoẓăt timərwen n-awătay d-săḍis a ija ibinnəw təzzar imdă, ɣas əndek dihad ila əmmək ad-t-dd-səbdədăd kăyy dăɣ-kăraḍ išilan?» ");
INSERT INTO taq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ijʼ-asăn Ɣisa măjrăd-wen-dăɣ măšan, wăr-əjrehăn a-s ehăn n-ămudd wa s-hasăn-iha isălan-net, taɣəssa-net ənta iman-net. ");
INSERT INTO taq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Šămad dd-inkăr Ɣisa jer-inəmmuttan a dd-əktăn inəṭṭulab-net tifer-tin-dăɣ ija, omănăn s-a-wa ənnăn əlkəttabăn d-a-wa innă ənta iman-net. ");
INSERT INTO taq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ăzzăman-wen-dăɣ n-ămudd wa n-Faṣka ăssakăy dăɣ-Yărussălam, omănăn săr-s ăddinăt ăjjootnen hannăynen ijităn n-Măssinăɣ wi ităjj, ");
INSERT INTO taq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","măšan wăr tăn-ifles ed izzay-tăn iket-dăɣ-năsăn, ");
INSERT INTO taq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","wăr-ămɣatăr daɣ, ad-has-ăjjăyh ăwadəm wălʼ iyyăn făll-iyyăn ed, issan d-iman-net a-wa ihăn ulh n-e d t-illăm ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ehăḍ iyyăn, osă-dd iyyăn dăɣ-imănokalăn n-kăl-Ălyăhud la taggayt ta n-kăl-faris s-isəm-net Nikodem Ɣisa, ");
INSERT INTO taq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","innʼ-as: «Ălɣalim, nəssan a-s kăyy ălɣalim dd-ăšimasăl Măssinăɣ a tămoosăd făl-a-s ijităn n-Măssinăɣ wi tăjjăd, wăr t-illa ere ăddooben iji-năsăn ar s-ad-t-idhal Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ăwwežăb-as Ɣisa, innʼ-as: «Ălleɣeɣ-ak s-tidət tădduuttet a-s a ikkăs ăwadəm wăr-ija tiwit ta tăynayăt dd-fălăt išənnawăn, wăr mad-inhəy Təmmənəya ta n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Innʼ-as Nikodem: «Ǝndek əmmək wa s-mad-iwəy ăwadəm wăššărăn? Ajăn ăddobăt ad-iqqəl tăsa n-ma-s, ăj-dd tiwit ta s-sănatăt?» ");
INSERT INTO taq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Innʼ-as Ɣisa: «Ălleɣeɣ-ak s-tidət tădduuttet a-s ere wărăn iwa s-aman d-Unfas Šăddijăn, wăr-e ijjəš Təmmənəya n-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","făl-a-s, a-wa dd-torăw taɣəssa, i n-taɣəssa, a-wa dd-orăw Unfas daɣ, i n-Unfas. ");
INSERT INTO taq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wăr-ităqqănet eɣăf-năk făl-a-s innin ənneɣ-ak: ‹Wăr hawăn-t-təlla ar tiwit ta tăynayăt dd-fălăt išənnawăn.› ");
INSERT INTO taq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wădden aḍu itəhhal siha s-irha, sallăd i-emăsli-net măšan, wăr təssenăd siha s-dd-iha wăla siha s-ikka, a-wen-dăɣ daɣ, a ijʼ ăwadəm iket-net dd-iwan s-Unfas n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Issəstăn Nikodem Ɣisa daɣ, innʼ-as: «Ǝndek əmmək wa s-mad-ăj a-wen?» ");
INSERT INTO taq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Innʼ-as Ɣisa: «Ǝndʼ-e-d-ilʼ əmmək a-s kăyy ălɣalim n-Iṣrayil ogdăhăn d-a-wa-dăɣ, uhən-dăɣ wăr kăy-hen isălan n-a-wen-dăɣ? ");
INSERT INTO taq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ălleɣeɣ-ak s-tidət tădduuttet a-s nətajj isălan n-a-wa nəssăn, nətajăyha daɣ făll-a-wa nənhăy măšan kăwăneḍ, wăr tărḍem s-tajuhe-nănăɣ. ");
INSERT INTO taq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ɣas, kunta wăr hi-təflesăm dihad hawăn-ăssewălăɣ dăɣ-isălan n-hărătăn wi n-ăddunya, əndek əmmək wa s-hi-mad-təfləsăm afăl hawăn-ăssewălăɣ dăɣ-isălan wi n-tidət əlkămnen n-išənnawăn? ");
INSERT INTO taq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wăr t-illa ere iwwaḍăn išənnawăn kunta wădden ere wa-tăn-dd-ifălăn, a-wen a t-ămoosăn Ăgg-ăgg-adəm-i dăɣ-săn izzăɣăn. ");
INSERT INTO taq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ǝmmək-wa-dăɣ s-issărjăj ănnăbi Mosa taššălt dăɣ-tenere, əmmək-wen-dăɣ daɣ a-s ilzam, ad-itwəḍkəl Ăgg-ăgg-adəm, ");
INSERT INTO taq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","dihen, ere săr-s omănăn-dăɣ, ad-ijrəw tămudre tăɣlalăt ");
INSERT INTO taq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","făl-a-s, Măssinăɣ, ija i-ăddunya tărha-ta-dăɣ făl ikfa Rure-s wa n-iyyăn i-ere săr-s omănăn-dăɣ, wăr-e ămmăt, ănn-ak, ad-ijrəw tămudre ta tăɣlălăt; ");
INSERT INTO taq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Măssinăɣ, wăr dd-ăšmašăl Rure-s s-ăddunya i-ad-tăt-išrăɣ, ănn-ak i-ad-tăt-iɣləs. ");
INSERT INTO taq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ere săr-s omănăn, wăr t-e-išrăɣ măšan, ere săr-s wărăn omen, ăru d-itbăt ăššăreɣa-net făl-a-s, wăr-omen s-Rure-s n-Măssinăɣ wa n-iyyăn. ");
INSERT INTO taq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ăddălil n-ăššăreɣa-en, ənta da: osă-dd ănnur ăddunya măšan, ăssofăn dăgg-adəm tihay ed timašalen-năsăn ti lăbasnen. ");
INSERT INTO taq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ăwadəm itamašalăn a lăbasăn hărkuk ăššunjăt ănnur, wăr dawa-s dd-itəmmil ed ăksuḍ ad-dd-əffukkărăn erk imojjan-net ");
INSERT INTO taq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","măšan, ere iglan făl tidət, wăr-ăksuḍ ad-dd-ăkk ănnur i-ad-dd-infiləl a-s imojjan-net, Măssinăɣ a-s əssəbab-năsăn.» ");
INSERT INTO taq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ḍarăt-a-wen, ikka Ɣisa d-inəṭṭulab-net teje ta n-Ălyăhudəyăt, əzzăɣăn dihen-dăɣ, ad-isalmaɣ ăddinăt. ");
INSERT INTO taq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A-s ija a-wen, Exya ənta, tisən-t-dd ăddinăt, isalmaɣ-tăn dăɣ-edăgg s-isəm-net Anun dăɣ-ihəẓ n-tadăbayt ta n-Saləm făl-a-s, əjjətăn aman dihen. ");
INSERT INTO taq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A-wen itajj hărwa wăr hin-ătwăjăr Exya dăɣ-takărmut. ");
INSERT INTO taq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tənkăr tamɣənnant jer-inəṭṭulab n-Exya d-ăgg-Ălyăhud iyyăn dăɣ-isălan n-ălwăḷḷa wa išăšdajăn ɣas, ");
INSERT INTO taq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","əkkăn-t-dd, ənnăn-as: «Ălɣalim, ăhaləs wa s-kăla dăr-s tărtăyăd făll-tăjjəyhăd făll-ašrut n-ejănš n-Ɣurdəni wa iyyăḍăn, ămăra isalmaɣ ənta-dăɣ, takkăn-t ăddinăt iket-năsăn.» ");
INSERT INTO taq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Innʼ-asăn Exya: «Ăgg-adəm, wăr-e ăj ar a-wa dăr-t-ăskăllăf Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wădden, tăjjəyhăm iket-năwăn a-s ənneɣ: ‹Năkk, wăr-ămoosăɣ Ălmasex, ămišəl ɣas a dd-jeɣ data-s.› ");
INSERT INTO taq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nəssan a-s ămaẓlay ənta a ilăn tămaẓlayt măšan, amidi n-ămaẓlay-i ɣur-săn t-illăn ăsijăd, ăsidăwăt-t emăsli n-ămaẓlay wa s-isăll. Ǝlmədăt a-s tedăwit-ten-dăɣ ităjj amidi n-ămaẓlay, a jeɣ năkk-dăɣ ămăra, tedăwit-in daɣ, təjlay, təmda. ");
INSERT INTO taq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Imɣaret isəm-net, ifnəẓet wa-nin.» ");
INSERT INTO taq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Ere wa dd-ifălăn išənnawăn, ojăr ăddinăt iket-năsăn, ere wa dd-ifălăn ăkall, i n-ăkall, wăr mad-ăj daɣ ar isălan n-ăkall-i-dăɣ măšan, ere wa dd-ifălăn išənnawăn, ojăr ăddinăt iket-năsăn ed ");
INSERT INTO taq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ənta isălan n-a-wa inhăy d-a-wa islă a itajj măšan, wăr t-illa ere t-iflasăn. ");
INSERT INTO taq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ere wa t-iflăsăn, ăssiitbăt tənna n-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","făl-a-s, ere wa dd-ăšmašăl Măssinăɣ, a-wa innă Măssinăɣ a ijanna ed ăsinăflăy-t Măssinăɣ dăɣ-isuf n-Unfas-net. ");
INSERT INTO taq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abba ikna tărha n-Rure-s, hărăt iket-net a ija dăɣ-ifassăn-net. ");
INSERT INTO taq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ere wa omănăn s-Rure-s, ijraw tămudre ta tăɣlălăt, ere wa săr-s wărăn omen, wăr mad-inhəy tămudre ta ihăkk Măssinăɣ ed, insa fălla-s aḍkăr n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ilmăd Ɣisa a-s əslăn kăl-faris a-s ojărăn inəṭṭulab wi isălmaɣ ənta, uhən wi isălmaɣ Exya, a-wen-dăɣ a ăɣelăn. ");
INSERT INTO taq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tidət a-s, Ɣisa ənta iman-net, wăr t-illa ere ăssilmăɣ, inəṭṭulab-net ɣas a salmaɣnen ăddinăt. ");
INSERT INTO taq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ifăl teje ta n-Ălyăhudəyăt, olăs tikawt n-ta n-Galila ");
INSERT INTO taq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","măšan, i-ad-ăj a-wen, ilzam-t ad-ijləy teje ta n-Sămari. ");
INSERT INTO taq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ăssookal har dd-iwwăḍ aɣrəm n-Sămari s-isəm-net Sišar, ikkă dihen anu wa ihăn ašəkrəš wa iɣăš ănnăbi Yaqub təzzar ikfʼ-e i-rure-s Yusəf, anu-en, iwăr-t isəm wa n-Yaqub. ");
INSERT INTO taq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Osă-dd anu ɣas, ăqqimă făll-emm-net i-ad-isunf a-wa-dăɣ has-ija aləḍḍeš n-asikəl. A-wen a itajjăn s-tarăhut. ");
INSERT INTO taq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ăqqiima făll-emm n-anu-en-dăɣ a-s dd-tosa tu-Sămarit dd-təšrajăt, innʼ-as Ɣisa: «Tamăḍt, săswʼ-ahi-dd.» ");
INSERT INTO taq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A-s ităjj a-wen-dăɣ, əkkan inəṭṭulab-net aɣrəm i-ad-dd-žənšən imənsiwăn əkšăn. ");
INSERT INTO taq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tənnʼ-as tamăḍt: «Ma kăy-ăsihălăn kăyy-i n-ăgg-Ălyăhud, ad-dăɣ-i təttărăd aman năkk-i n-tu-Sămarit?» Ăzzăman-en, kăl-Ălyăhud d-kăl-Sămari, wăr-ănmănnăkăn. ");
INSERT INTO taq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Innʼ-as Ɣisa: «Ǝnnar təssanăd făll-isuf n-Măssinăɣ d-ere wa ham-ijănnen: ‹săswʼ-ahi-dd›; kămm a has-madăn-ănn: ‹săswʼ-ahi-dd›; ăkfʼ-im ənta, aman əddărnen.» ");
INSERT INTO taq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tənnʼ-as tamăḍt: «Ălɣalim, anu-i, i šəjreen, kăyy daɣ wăr led ăja, ɣas, əndek əmmək wa s-mad-dd-təjrəwăd aman əddărnen wi s-jănned? ");
INSERT INTO taq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ajăn tojărăd abba-nănăɣ ănnăbi Yaqub-i hanăɣ-ikfăn anu-i-dăɣ dăɣ-iswa ənta d-aratăn-net d-irəzzejăn-net?» ");
INSERT INTO taq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Innʼ-as Ɣisa: «Ere iswăn aman n-anu-i-dăɣ, ad-aləs fad ");
INSERT INTO taq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","măšan, ere iswăn aman-wi t-mad-ăkfăɣ, wăr dăɣ-s ilkem fad ed, ad-dăɣ-s umasăn aman wi t-mad-ăkfăɣ, a dăɣ-has-dd-təffay tămudre ta tăɣlălăt.» ");
INSERT INTO taq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tənnʼ-as tamăḍt: «Ălɣalim, săswʼ-ahi dăɣ-aman-win-dăɣ i-ad-ăbas tifadăɣ, əbḍəwăɣ s-iyyăt d-ašăroj n-anu-i-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Innʼ-as Ɣisa: «Ǝgləw, idaw-dd d-ăhaləs-năm, tăqqəlăd-ahi-dd.» ");
INSERT INTO taq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tənnʼ-as tamăḍt: «Wăr-ădobănăɣ.» Innʼ-as Ɣisa: «Tənned tidət a-s wăr tădobănăd ");
INSERT INTO taq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","făl-a-s, jed səmmos idubnawăn măšan, təzjărăt-tăn-dd iket-năsăn, ăhaləs daɣ wa dăr-tărtăyăd ămăra-dăɣ, wăr tămsăxlălăm.» ");
INSERT INTO taq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tənnʼ-as tamăḍt: «Ălɣalim, hannăyăɣ a-s kăyy ya ănnăbi a tămoosăd! ");
INSERT INTO taq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ibda abbatăn-nănăɣ aḍaɣ-wa-dăɣ a făll-ɣabbădăn Măssinăɣ măšan, kăwăneḍ-i n-kăl-Ălyăhud, tənnăm wăr t-illa ălɣibadăt n-Măssinăɣ ar dăɣ-Yărussălam.» ");
INSERT INTO taq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Innʼ-as Ɣisa: «Tamăḍt, əfləs-ahi, ilkam ălwăqq d-wăr mad-tăɣbədăm Abba făll-aḍaɣ-wa-dăɣ wăla dăɣ-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kăwăneḍ, ɣabbădăm a wăr təssenăm măšan, năkkăneḍ nəssan ere wa nəɣabbăd ed, əlɣəllas, kăl-Ălyăhud a dd-ifăl. ");
INSERT INTO taq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Măšan, ilkam ăssaɣăt s-ənta-da-dăɣ nəha ămăra-dăɣ dăɣ-mad-ăɣbədăn imumənăn wi n-tidət Abba s-tidət dăɣ-ənniyătăn-năsăn făl-a-s, inaɣbadăn əjlaynen šund-win-dăɣ a has-əjraẓnen. ");
INSERT INTO taq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Măssinăɣ, Unfas, wăr-itətwənhəy, a-wen-dăɣ a făl ere t-iɣabbădăn, iɣbədet-t s-ənniyăt d-tidət.» ");
INSERT INTO taq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tənnʼ-as tamăḍt: «Ǝssanăɣ a-s Wa innəfrănăn s-itawănna Ălmasex, ilkam ad-dd-ass, afăl dd-osa, ad-hanăɣ-isəssiɣəd dăɣ-hărăt iket-net.» ");
INSERT INTO taq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Innʼ-as Ɣisa: «Năkk-i-dăɣ ham-ămmiijrădăn a t-ămoosăn.» ");
INSERT INTO taq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ămmiijrăd-as Ɣisa hărwa a-s dd-əqqălăn inəṭṭulab-net. Iqqăn a-wa s-ămmijrăd i-tamăḍt iɣăfawăn-năsăn măšan, hakd a-wen-dăɣ, wăr tăn-iha-i t-ăssistănăn d-a-wa dăɣ-s irha wăla a-wa făl dăr-s ădiwănnăt. ");
INSERT INTO taq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Toyyă tamăḍt aɣăsis-net dihen-dăɣ, tăqqăl aɣrəm, tənnă i-ăddinăt: ");
INSERT INTO taq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ǝyyăwăt, ənhəywăt ăhaləs hi-illăɣen a-wa s-kăla t-jeɣ iket-net, ămmuukkăn a-s ənta-i-dăɣ a-s Ălmasex.» ");
INSERT INTO taq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ǝzjărăn-dd kăl-aɣrəm, əkkăn-dd Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A-s ităjj a-wen, salɣadăn inəṭṭulab ălɣalim-năsăn i-ad-ămmăklăw ");
INSERT INTO taq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","măšan, innʼ-asăn: «Năkk, leɣ a əkšeɣ wăr təssenăm.» ");
INSERT INTO taq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ad-tinmənnin: «Ajăn iwwăy-as-dd ăwadəm amənsi ḍara-năɣ?» ");
INSERT INTO taq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Innʼ-asăn Ɣisa: «Amənsi-nin, iji n-erhet n-Wa hi-dd-ăšmašălăn, sətbətăɣ ămašal-net. ");
INSERT INTO taq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wădden a jannem diha-dăɣ s-əkkoẓ orăn ad-ămalăyăn išəkraš? Ǝnneɣ-awăn: ənhəywăt, əḍkəlăt tiṭṭawen-năwăn, təkyədăm dăɣ-išəkraš, əŋŋan, wăr-ərhen ɣas ar amili. ");
INSERT INTO taq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ăssaɣăt wa d-ijarrăw ănaxdim wa itiləyən išəkraš ălxaqq n-tide-net, ənta-da-dăɣ dăɣ-təssəba n-ad-isədəw allon-net i-tămudre ta tăɣlălăt, i-ad-imzəyyət ănaxdim-wa ăddomen d-wa itiləyən tedăwit ");
INSERT INTO taq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ed, oẓẓ wa innăn: ‹ăddomăt iyyăn, olăy wa iyyăḍăn›, innă tidət. ");
INSERT INTO taq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Năkk, ăssokăɣ-kăwăn illuy n-išəkraš dăɣ-wăn wăren irhʼ ăṣṣahăt, iyyăḍ a tăn-ixdămăn, tărbăxăm kăwăneḍ-dăɣ ăṣṣahăt-năsăn.» ");
INSERT INTO taq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Omănăn kăl-Sămari n-aɣrəm-ənnin-dăɣ ăjjootnen s-Ɣisa dăɣ-təssəba n-tajuhe ta hasăn-təja tamăḍt a-s hasăn-tənna: «Illăɣăt-ahi a-wa s-kăla t-jeɣ iket-net.» ");
INSERT INTO taq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A-wen-dăɣ a făl osăn-dd Ɣisa ɣas, dălăn-t d-ad-ɣur-săn izzăɣ, ija ɣur-săn əssin išilan. ");
INSERT INTO taq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ǝslăn-as ənta iman-net ămmijrăd ɣas, jăn wi săr-s omănnen əjut ojărăn wənnin. ");
INSERT INTO taq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ǝnnăn wi săr-s omănnen i-tamăḍt: «Ămăra, ăbas săr-s noman dăɣ-təssəba n-a-wa hanăɣ-tənned, nəslʼ-as iman-nănăɣ, nomăn daɣ a-s ădduuttăt a-s ənta a-s Ămaɣlas n-ăddunya.» ");
INSERT INTO taq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ăssakăy Ɣisa əssin išilan-win-dăɣ dihen ɣas, ikkă teje ta n-Galila ");
INSERT INTO taq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ed, issan a-s: «Wăr t-illa ănnăbi ătiwăsămɣărăn dăɣ-ăkall-net.» ");
INSERT INTO taq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Măšan, diha-dăɣ d-hin-iwwăḍ Galila, ad-t-ăsbărrăkăn kăl-ăkall ed, ənhăyăn dăɣ-săn i ăjjootnen dăɣ-wi ăssakăynen ămudd dăɣ-Yărussălam a-wa ija Ɣisa iket-net. ");
INSERT INTO taq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iqqăl Ɣisa ḍarăt-a-wen tadăbayt ta n-Kăna hăt teje ta n-Galila dăɣ-ăsmăskăl aman, ijʼ-en aman n-lăɣnăb ăxxiimmărnen. A-s ităjj a-wen-dăɣ, ihʼ ăgg-əlxəkum iyyăn s-ărhin rure-s aɣrəm wa n-Qăfărnaxum. ");
INSERT INTO taq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Islă a-s Ɣisa ifăl-dd Ălyăhudəyăt s-Galila ɣas, ikkʼ-e-hi-dd, ad-t-ilaqqăd i-ad-dd-itrur, izuzəy rure-s s-išwar t-ăba. ");
INSERT INTO taq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Innʼ-as Ɣisa: «Adiš kăwăneḍ a təkkăm wăr tənheyăm ijităn n-Măssinăɣ d-tikunen, wăr-e tamənăm s-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Innʼ-as kăbtăn: «Ălɣalim, năglet šik iket-di d-wăr-ămmut alyaḍ-in.» ");
INSERT INTO taq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Innʼ-as Ɣisa: «Ǝgləw, rure-k iddar.» Iflăs kăbtăn a-wa has-innă Ɣisa, iglă. ");
INSERT INTO taq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ikka-dd ehăn-net hărwa a-s has-dd-əlkăḍăn inaxdimăn-net, ənnăn-as: «Rure-k, iddar.» ");
INSERT INTO taq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Issəstăn-tăn d-ăssaɣăt wa-dăɣ ijrăw ălafu, ənnăn-as: «Ǝnḍəšel s-tezzar ad-t-toyyă tenăde.» ");
INSERT INTO taq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Inhăy abba n-alyaḍ a-s ălwăqq-wen-dăɣ iman-net ad-has-innă Ɣisa: «Rure-k, iddar». Omăn ašăl-wen-dăɣ s-Ɣisa ənta hakd ejădăš-net iket-net. ");
INSERT INTO taq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iji n-Măssinăɣ wa-dăɣ a-s wa s-əssin ija Ɣisa ḍarăt efel-net i-Ălyăhudəyăt s-Galila. ");
INSERT INTO taq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ijă ămudd iyyăn daɣ n-kăl-Ălyăhud ɣas, olăs Ɣisa tikawt n-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yărussălam, ujəš-net wa s-itawănna wa n-tihatten, hʼ-e tăsahaɣt n-aman s-isəm-net dăɣ-Ɣăbranəyya: Bătẓata, ăɣlaynăt-tăt səmmosăt tisəkla ");
INSERT INTO taq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","daw-ənsan imarhinăn d-iməddorɣal d-inəbdan d-inaɣyabăn ăjjootnen ăqqalnen i-emăremar n-aman ");
INSERT INTO taq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","făl-a-s dehiyyăn, itizəbbut-dd ănjălos n-Emăli dăɣ-tăsahaɣt, isəmrumăr aman-net. Ere ăzzarăn s-ujəš n-aman-en-dăɣ ḍarăt a-s tăn-ăsimăramăr ănjălos, ad-izzəy a tămoos turhənna-net dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Insʼ ăhaləs dihen ibdanăn a ilan kăraḍăt timərwen n-awătay d-əttam. ");
INSERT INTO taq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Inhăy-t Ɣisa insa, ilmăd dăɣ-iman-net a-s ăhoja ăssinsʼ-e bəddin-net dihen-dăɣ ɣas, innʼ-as: «Ajăn tărhed ad-kăy-dd-iqqəl ăssexăt-năk?» ");
INSERT INTO taq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Innʼ-as anăbdon: «Ălɣalim, wăr leɣ ăwadəm hi-ijărăn dăɣ-tăsahaɣt e-d ămramărăn aman. E-d săr-săn dd-ămhărhămărăɣ-dăɣ, ad-hi săr-săn išwăr ere hi-ojărăn armuḍ.» ");
INSERT INTO taq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Innʼ-as Ɣisa: «Ǝbdəd, əḍkəl asəftăɣ-năk, ărjəš.» ");
INSERT INTO taq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Izzăy ăhaləs ălwăqq-wen-dăɣ, iḍkăl asəftăɣ-net, irjăš. Ašăl wa d-ităjj a-wen-dăɣ, ašăl n-əssəbət-i n-tăsonfat. ");
INSERT INTO taq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Izzăy ɣas, osăn-t-dd imizărăn n-kăl-Ălyăhud, ənnăn-as: «Ajăn wăr təssenăd a-s ašăl-i, əssəbət-i-dăɣ wăr hak-xălal aggay n-asəftăɣ-năk.» ");
INSERT INTO taq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Innʼ-asăn: «Ăhaləs wa hi-ăzozăyăn, a hi-innăn: ‹Ǝḍkəl asəftăɣ-năk, ărjəš.› » ");
INSERT INTO taq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ǝnnăn-as: «Ma ămoos ăhaləs wa hak-innăn: ‹Ǝḍkəl asəftăɣ-năk, ărjəš?› » ");
INSERT INTO taq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ăhaləs wa izzăyăn, wăr-izzey ere wa t-ăzozăyăn ed ăzozăy-t Ɣisa ɣas, izjăr tamətte. ");
INSERT INTO taq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ămmoqqăs dăr-s Ɣisa ḍarăt-a-wen dăɣ-ehăn n-ămudd wa măqqărăn, innʼ-as: «Ămăra d-təzzeyăd, wăr tolesăd iji n-abăkkaḍ, uksaḍ ad-kăy-ijrəw a irnăn a-wa s-kăla kăy-ijrăw.» ");
INSERT INTO taq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iglʼ ăhaləs ḍarăt-a-wen, illăɣăt i-imizărăn n-kăl-Ălyăhud a-s Ɣisa a t-ăzozăyăn. ");
INSERT INTO taq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ǝslăn i-a-wen ɣas, ad-tattărăn arămas n-Ɣisa ed ămešăl iji n-Măssinăɣ wen-dăɣ dăɣ-ašăl n-əssəbət-i n-tăsonfat. ");
INSERT INTO taq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Innʼ-asăn Ɣisa: «Abba-nin, ixdam hărkuk, năkk-dăɣ, a-wen-dăɣ a jeɣ.» ");
INSERT INTO taq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ămoos a-wen ămăra ăsaru wa făl tattărăn imizărăn n-kăl-Ălyăhud iji n-iman-net ed ənnăn, wăr-issəmɣăr ašăl wa n-əssəbət-i n-tăsonfat, ăsisăgdăh daɣ iman-net d-Măssinăɣ ed, innă Abba-net a ămoos. ");
INSERT INTO taq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Innʼ-asăn Ɣisa daɣ: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s, wăr t-illa a ixaddăm Rure-s n-Măssinăɣ ar a-wa s-inhăy Abba-net ixdam-t, a-wa ămešăl Abba iket-net, ad-t-ămašăl Rure-s ənta-dăɣ ");
INSERT INTO taq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","făl-a-s, Abba ikna tărha n-Rure-s, isaknʼ-e daɣ a-wa itamašal iket-net, ad-t-isəkən daɣ ijităn ojărnen wi-dăɣ təmɣăre, əknən iɣăfawăn-năwăn uɣən. ");
INSERT INTO taq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Făl-a-s, əmmək wa s-dd-isănkar Abba inəmmuttan i-ad-tăn-isudăr, əmmək-wen-dăɣ daɣ a-s ihakk Rure-s tămudre ere wa s-tăt-irha. ");
INSERT INTO taq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wăr-išərrăɣ Abba ăwadəm wălʼ iyyăn măšan, ija ăššăreɣa n-hărăt iket-net jer-ifassăn n-Rure-s ");
INSERT INTO taq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","dăɣ-təssəba n-ad-t-səmɣărăn ăddinăt iket-năsăn s-əmmək wa s-ăssimɣărăn Abba-net. Ere wărăn issəmɣăr Rure-s n-Măssinăɣ, wăr mad-isəmɣăr Abba-i t-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ere ăsjădăn i-măjrăd-in, omăn s-wa hi-dd-ăšmašălăn, ijraw tămudre ta tăɣlălăt, wăr-e inhəy ăššăreɣa, ănn-ak, ad-dd-ihləbbət dăɣ-ifassăn n-tamăttant, ijjəš tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ălleɣeɣ-ăwăn s-tidət tădduuttet a-s imal-dd ăssaɣăt s-ənta-da-dăɣ nəha dăɣ-mad-əslən inəmmuttan i-emăsli n-Rure-s n-Măssinăɣ. Wi has-maden-isəll, ad-əddărăn ");
INSERT INTO taq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","făl-a-s, əmmək-wa-dăɣ s-tămudre, ifassăn n-Abba a təha, əmmək-wen-dăɣ daɣ a-s ikfa Rure-s tădabit n-ad-isudăr ăddinăt. ");
INSERT INTO taq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ǝnta a ikfă tădabit n-ăššăreɣa-năsăn ed ənta iman-net a-s Ăgg-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ɣas, wăr tăqqănnet iɣăfawăn-năwăn făl-a-s, imal-dd ăssaɣăt dăɣ-mad-əslən inəmmuttan iket-năsăn i-emăsli n-Ăgg-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ašăl-en dd-nakkăr tamətte jer-inəmmuttan, ăddinăt wi ămešălnen sărho, ad-dd-ənkărăn i-tămudre ta tăɣlălăt, wi s-tăllăbăst ɣas a ămešălăn, ad-dd-ənkărăn i-ăššăreɣa.» ");
INSERT INTO taq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Năkk, wăr t-illa făw a tajjăɣ d-iman-nin ɣas, tənna n-Măssinăɣ ɣas a-s šarrăɣăɣ, ăššăreɣa-nin daɣ hărkuk oɣad ed, wădden erhet wa n-iman-in a-s tattărăɣ iji-net, wăr təttărăɣ ar iji n-erhet n-Wa hi-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Afăl ăqqălăɣ tajuhe i-iman-in, wăr mad-tənfəw tajuhe-nin hărăt. ");
INSERT INTO taq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ere săl năkk a făll-i itajăyhen, əssanăɣ daɣ a-s tajuhe-net făll-i ənta, wăr tăt-iha ăššăk. ");
INSERT INTO taq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wădden a-s tăšmašălăm ăddinăt s-Exya, ăjjəyha făll-i. ");
INSERT INTO taq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ǝlmədăt a-s năkk, wăr t-illa ăgg-adəm dăɣ-tattărăɣ tajuhe măšan, a-wa hawăn-ənneɣ, ənnəɣ-awăn-t dăɣ-derhan n-ad-tăɣləsăm. ");
INSERT INTO taq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Exya, a-s dd-osă, ămoos tefătelt tărɣat, tămilăwlăw măšan, wăr tətterăm ar tedăwit n-ăssaɣăt ənḍărrăn dăɣ-ănnur-net. ");
INSERT INTO taq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Năkk, leɣ tajuhe tojărăt ta făll-i ijă Exya făl-a-s, ijităn wi s-hi-ikfa Abba tădabit-năsăn, əntăneḍ-en-dăɣ a ăsidăttătnen s-ənta a hi-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Abba daɣ-i hi-dd-ăšmašălăn, ăsidăttăt a-wa ənneɣ măšan, wăr kăla təslăm i-emăsli-net, wăr kăla t-tənhăyăm daɣ, ");
INSERT INTO taq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tănimăšrăyăm daɣ i-măjrăd-net ed, wăr tomenăm s-ere wa dd-ăšmašăl. ");
INSERT INTO taq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ǝlkəttabăn n-Măssinăɣ di-dăɣ safăykem, tammăɣăm dăɣ-săn i-tămudre ta tăɣlălăt, a tajăyhanen făll-i ");
INSERT INTO taq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","măšan, hakd a-wen-dăɣ, tunjayăm s-ad-hi-dd-təkkəm năkk, i-ad-təjrəwăm tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Təmmal-in wădden dăgg-adəm a dd-təfal ");
INSERT INTO taq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","măšan, əzzayăɣ-kăwăn, əssanăɣ a-s wăr təha tărha n-Măssinăɣ ulhawăn-năwăn. ");
INSERT INTO taq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Năkk-i dd-osăn făll-isəm n-Abba-nin, tənkarăm-ahi măšan, afăl kăwăn-dd-osa ere iglan dăɣ-ălhimmăt n-iman-net, šik a-s mad-t-tăqbəlăm. ");
INSERT INTO taq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ǝndek əmmək wa s-mad-tamənăm kăwăneḍ-i wăren ətəmmăɣ ar i-təmmal jer-iman-năwăn, a-s ija a-wen, wăr təmmeɣăm i-təmmal ta dd-fălăt Măssinăɣ-i n-iyyăn. ");
INSERT INTO taq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wăr teɣalăt năkk a kăwăn-e-isəḍləmăn dat-Abba, ănnăbi Mosa-i s-tənnăm ənta a dăɣ-jarăm ăṭṭăma, a kăwăn-e-isəḍləmăn ");
INSERT INTO taq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","făl-a-s, ənnar təflasăm ănnăbi Mosa, tamənăm săr-i ed, isălan-nin, iktab-tăn. ");
INSERT INTO taq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɣas, šămad wăr təflesăm a-wa iktăb, əndek əmmək wa s-mad-təfləsăm a-wa hawăn-janneɣ?» ");
INSERT INTO taq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ijlăy Ɣisa ḍarăt-a-wen s-asălim n-ejănš wa iyyăḍăn n-Galila s-itawănna wa n-Tibăryad. ");
INSERT INTO taq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ǝlkămăn-as-dd ăddinăt ăjjootnen hannăynen ijităn n-Măssinăɣ wi s-izizuy imarhinăn. ");
INSERT INTO taq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iwwăn taḍaɣt ənta d-inəṭṭulab-net, ăqqima fălla-s. ");
INSERT INTO taq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ăzzăman-en, ohaẓ-dd ămudd n-kăl-Ălyăhud wa s-itawănna Faṣka. ");
INSERT INTO taq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iḍkăl Ɣisa akăyad-net, inhăy tamətte ta tăjjet t-dd-təkkăt ɣas, inna i-Fəlibb: «Ǝndek diha d-mad-nəžănš tijəlwen ăššikšănen tamətte-ta-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Irrum ɣas a t-itajj ed issan ɣur-iman-net a-wa mad-ăj. ");
INSERT INTO taq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ăwwežăb-as Fəlibb, innʼ-as: «Kud-nəžžənša tijəlwen n-sănatăt timaḍ n-ărriyal n-aẓrəf-dăɣ, wăr mad-igdăh a-wen i-tamətte jat əjut-wa-dăɣ kud-dăɣ s-afărs-afărs.» ");
INSERT INTO taq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iggăd-dd iyyăn dăɣ-inəṭṭulab wa s-isəm-net Idris n-ăŋŋa-s n-Simyon Bəṭrus, innʼ-as: ");
INSERT INTO taq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Illʼ-e alyaḍ diha ilan səmmosăt tijəlwen n-tărruza d-əssin imănan măšan, a-wen ma ikna dăɣ-tamətte jat əjut-wa-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Innʼ-asăn Ɣisa: «Săqqəymăt tamətte.» Eddăg-en, ăssiidwăl teyəšše, tăqqima fălla-s tamətte iha a iwwăḍăn səmmos afḍăn n-ăhaləs. ");
INSERT INTO taq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iḍkăl Ɣisa tijəlwen ti n-səmmosăt, ămmoy i-Măssinăɣ təzzar, ăẓun-tănăt i-tamətte. Ija a-wen-dăɣ daɣ i-imănan wi n-əssin, təkša tamətte har tăssakăy. ");
INSERT INTO taq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ălwăqq wa d-əkšăn, əyyəwănăn, innă Ɣisa i-inəṭṭulab-net: «Sădwăt-dd ifărsăn wi ăjolăšnen i-ad-wăr-ibăxxəs əttăɣam.» ");
INSERT INTO taq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ăsdăwăn-dd a-wa dd-əjlăšăn ăddinăt, osăn-t iḍnăy măraw deketăn d-əssin n-tijəlwen. ");
INSERT INTO taq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ǝnhăyăn ăddinăt iji n-Măssinăɣ wa s-iket t-ija Ɣisa ɣas, ənnăn: «Ădduuttăt a-s ənta-da-dăɣ ănnăbi wa ilăn s-a dd-ass ăddunya.» ");
INSERT INTO taq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ilmăd Ɣisa a-s ărhan ad-t-səmmənukəlăn s-ăššil ɣas, ifăl-tăn, olăs aggan n-taḍaɣt ənta ɣas. ");
INSERT INTO taq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ijă ehăḍ ɣas, ătrarăn-dd inəṭṭulab-net ejănš, ");
INSERT INTO taq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","əjjăšăn turăft n-aman, ad-jallăyăn ejănš s-efăyy wa n-aɣrəm wa n-Qăfărnaxum. A-s ităjj a-wen-dăɣ, janăt tihay, wăr tăn-dd-ăwweḍ daɣ Ɣisa hărwa. ");
INSERT INTO taq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Inkăr-dd fălla-săn aḍu ăṣṣoohen, ănmăntaš ejănš. ");
INSERT INTO taq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ăɣyămmen turăft n-aman-năsăn har ujəjăn asălim n-ejănš s-a iwwăḍăn səmmos meɣ săḍis kelumetărăn təzzar, ənhăyăn-t, ikkʼ-en-dd, irjaš făll-aman. ");
INSERT INTO taq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ărmăɣăn măšan, innʼ-asăn: «Năkk a-wa, wăr tărmeɣăm.» ");
INSERT INTO taq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Diha-dăɣ d-əttărăn ad-dd-ijjəš turăft fălla-săn ad-tăsjăn, təḍăs ăkall wa əkkăn. ");
INSERT INTO taq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ăffăw ɣas, əjrăhăn-in ăddinăt-wi wărnen asălim n-ejănš wa dd-fălăn a-s turăft n-aman tiyyăt ɣas a-s kăla tăsjăn dihen măšan, wăr dăɣ-s igla Ɣisa, inəṭṭulab a dăɣ-s əglănen, ăkunăn. ");
INSERT INTO taq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Osănăt-dd daɣ turfen n-aman tiyyăḍ dd-falnen Tibăryad, əkkanăt-dd edăgg-wənnin dăɣ-əkšăn ăddinăt tijəlwen ḍarăt tămayit ta ija Ɣisa i-Emăli. ");
INSERT INTO taq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Təjrăh-in tamətte a-s Ɣisa hakd inəṭṭulab-net ăbas t-əllan dihen ɣas, əjjăšăn turfen n-aman ti s-iket dd-osănăt, əkkăn Qăfărnaxum, əmmaɣăn-as. ");
INSERT INTO taq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ǝjrăwăn-t făll-asălim n-ejănš wa iyyăḍăn ɣas, ənnăn-as: «Ălɣalim, əmme dd-tosed diha?» ");
INSERT INTO taq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s wădden ijităn n-Măssinăɣ wi tənhăyăm a făl hi-tammăɣăm, ănn-ak, tammăɣăm-ahi dăɣ-təssəba n-tijəlwen ti-dăɣ təyyəwănăm. ");
INSERT INTO taq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Wăr tăxdemăm i-išəkša-i s-ilkam ad-tăn-iba, ănn-ak, ăxdəmăt i-išəkša wi dd-tiirəwnen săr-wăn tămudre ta tăɣlălăt-i kăwăn-mad-ăkf Ăgg-ăgg-adəm, ed ənta-en-dăɣ a ăswăr Abba Măssinăɣ ešwăl-net.» ");
INSERT INTO taq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ǝnnăn-as: «Ǝndek əmmək wa s-mad-năxdəm erhet n-Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Innʼ-asăn Ɣisa: «Erhet n-Măssinăɣ a t-ămoosăn ad-təfləsăm wa dd-ăšmašăl.» ");
INSERT INTO taq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ǝnnăn-as: «Săkən-anăɣ iji n-Măssinăɣ wa hanăɣ-kăy-madăn-isəfləs. ");
INSERT INTO taq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abbatăn-nănăɣ a-s əzzaɣăn tenere, əkšăn tajəlla ta hasăn-dd-ăsfăl Măssinăɣ išənnawăn făl-a-s, iktab a-s: ‹Ikfʼ-en Măssinăɣ tajəlla dd-falăt išənnawăn i-ad-tăt-əkšən.› » ");
INSERT INTO taq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s wădden ănnăbi Mosa a kăwăn-ikfăn tajəlla ta dd-fălăt išənnawăn, Abba-nin ənta, ad-kăwăn-ăkf tajəlla ta n-tidət dd-fălăt išənnawăn ");
INSERT INTO taq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ed, tajəlla ta ihăkk Măssinăɣ a tăt-ămoosăn ere wa dd-ifălăn išənnawăn, ənta a ihakkăn tămudre i-ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ǝnnăn-as: «Ălɣalim, ten-dăɣ tajəlla, ăkfʼ-anăɣ-tăt hărkuk.» ");
INSERT INTO taq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Innʼ-asăn Ɣisa: «Năkk a-s tajəlla ta hakkăt tămudre, wa hi-dd-ikkăn, wăr-ilkem ad-ălluẓ, wa săr-i omănăn wăr-ilkem ad-ăffud. ");
INSERT INTO taq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ăssiilmădăɣ-kăwăn a-s tənhăyăm-ahi măšan, tunjăyăm tomănăm. ");
INSERT INTO taq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɣas, əlmədăt a-s ăddinăt-wi hi-ikfa Abba-nin a hi-dd-asən iket-dăɣ-năsăn, wăr mad-ăkfăɣ daɣ ărori-nin i-ere hi-dd-ikkan ");
INSERT INTO taq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ed, wăr dd-felăɣ išənnawăn i-ad-ăjăɣ erhet-in, fălăɣ-tăn-dd i-ad-ăjăɣ erhet n-Wa hi-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Erhet daɣ n-Wa hi-dd-ăšmašălăn a t-ămoosăn, ad-wăr-ăsbătăɣ wălʼ iyyăn dăɣ-ăddinăt-wi hi-ikfa, ănn-ak, a irha ad-tăn-dd-sənkărăɣ dăɣ-tamăttant ašăl wa ilkămăn ");
INSERT INTO taq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","făl-a-s, erhet n-Abba-nin ənta da: e d t-illăm ere săr-i omanăn năkk-i n-Rure-s, ad-ijrəw tămudre ta tăɣlălăt, sənkărăɣ-t-dd dăɣ-tamăttant ašăl wa ilkămăn.» ");
INSERT INTO taq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ad-simtəktikăn kăl-Ălyăhud jer-iman-năsăn făl-a-s innin innʼ-asăn: «Năkk a-s tajəlla ta dd-fălăt išənnawăn», ");
INSERT INTO taq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","tinmənnin: «Ak wa ənta, wădden Ɣisa wa-dăɣ n-ăgg Yusəf, nəzzay ti-s, nəzzay ma-s? Ɣas, ma t-isawănnen išənnawăn a dd-ifal?» ");
INSERT INTO taq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ăwwežăb-asăn, innʼ-asăn: «Ăyyăt fălla-wăn takšiwen, ");
INSERT INTO taq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","wăr t-illa ere ăddoben ad-hi-dd-ăkk ar s-ad-t-dd-intaš Abba-nin săr-i, ere daɣ wa săr-i omănăn, ad-t-dd-sənkărăɣ dăɣ-tamăttant ašăl wa ilkămăn. ");
INSERT INTO taq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ajăn wădden əktabăn ănnăbităn a-s: ‹Ilkam ad-umasăn dăgg-adəm iket-năsăn inəṭṭulab n-Măssinăɣ›, ɣas, ere islăn i-tənna n-Abba, irḍa s-a-wa t-issăɣra, ad-hi-dd-ăkk. ");
INSERT INTO taq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ălmăɣna n-a-wen a-s wăr t-illa ere inhayăn Abba kunta wădden ere wa dd-ašmašăl Măssinăɣ, ənta ɣas a inhayăn Abba. ");
INSERT INTO taq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ere wa săr-i omănăn, ijraw tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Năkk a-s tajəlla ta hakkăt tămudre. ");
INSERT INTO taq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Abbatăn-năwăn a-s əzzaɣăn tenere, əkšăn mana, a-wen tajəlla n-taləmmiẓt ta hasăn-dd-ăsfăl Măssinăɣ išənnawăn, hakd a-wen-dăɣ, ămmun, ");
INSERT INTO taq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","măšan, tajəlla ta dd-təšrăyăt dd-fălăt išənnawăn, ere tăt-ikšăn, wăr-e ămmăt. ");
INSERT INTO taq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Năkk a-s tajəlla ta n-tămudre dd-fălăt išənnawăn, ere ikšan tajəlla-ten-dăɣ, ad-iddar hărkuk; taɣəssa-nin a-s tajəlla-ten-dăɣ mad-ăkfăɣ i-ad-təddăr ăddunya.» ");
INSERT INTO taq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Inna Ɣisa a-wen ɣas, tənkăr tamɣənnant tăṣṣoohet jer-kăl-Ălyăhud, ad-tinmənnin: «Ǝndek əmmək wa s-mad-hanăɣ-ăkf taɣəssa-net i-ad-tăt-năkš?» ");
INSERT INTO taq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s afăl wăr təkšem taɣəssa-nin năkk-i n-Ăgg-ăgg-adəm, təswəm daɣ ašni-nin, wăr mad-təddărăm. ");
INSERT INTO taq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ere ikšăn taɣəssa-nin, iswă ašni-nin, ijraw tămudre ta tăɣlălăt, sənkărăɣ-t-dd daɣ dăɣ-tamăttant ašăl wa ilkămăn ");
INSERT INTO taq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","făl-a-s, taɣəssa-nin a-s amənsi wa n-tidət, ašni-nin a-s tesăse ta n-tidət. ");
INSERT INTO taq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ere ikšăn taɣəssa-nin, iswă ašni-nin, nosăɣ năkk d-ənta, heeɣ-t, ihʼ-ahi. ");
INSERT INTO taq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ǝmmək wa s-iddăr Abba-i hi-dd-ăšmašălăn, əmmək-wen-dăɣ a-s əddarăɣ năkk-dăɣ. Ɣas, ere ikšăn taɣəssa-nin dăɣ, ad-has-umasăɣ əssəbab n-tămudre tăɣlalăt. ");
INSERT INTO taq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ǝnta-da-dăɣ tajəlla ta dd-fălăt išənnawăn təẓlăyăt d-tajəlla ta əkšăn abbatăn-năwăn uhən-dăɣ, ămmun. Ere wa ikšăn tajəlla ta ămoosăɣ, ad-iddar hărkuk.» ");
INSERT INTO taq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ǝnta-da-dăɣ ălxuṭbăt wa ija Ɣisa dăɣ-ehăn n-ăddin wa n-kăl-Ălyăhud ihăn aɣrəm wa n-Qăfărnaxum. ");
INSERT INTO taq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ǝslăn inəṭṭulab-net ăjjootnen i-ălxuṭbăt wa s-iket t-ijă ɣas, ănmănnăn jer-iman-năsăn: «Wa măjrăd, ojăr-anăɣ, mi ăddoben asjəd-has?» ");
INSERT INTO taq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ilmăd Ɣisa ɣur-iman-net a-wa simtəktikăn, innʼ-asăn: «Ajăn wa măjrăd, ikmʼ-iwăn? ");
INSERT INTO taq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kud-tăjjəyhăm i-Ăgg-ăgg-adəm har iqqăl dăɣ-išənnawăn edăgg wa s-kăla t-iha s-tizarăt, ma mad-tənnəm? ");
INSERT INTO taq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Unfas n-Măssinăɣ a ihakkăn tămudre, taɣəssa mălayăɣna. Iməjridăn wi hawăn-jeɣ, hen tămudre ed, Unfas Šăddijăn a dd-falăn ");
INSERT INTO taq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","măšan, iyyăḍ dăɣ-wăn hi-əlkamnen, wăr săr-i omenăn.» Innʼ-asăn Ɣisa a-wen ed issan ašăl ăzzarăn ăddinăt wi has-əlkămnen a-s ija a-wen wăr săr-s omenăn, issan daɣ dăɣ-săn ere wa t-madăn-isəssăɣdăr. ");
INSERT INTO taq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ăssewăḍ Ɣisa făll-a-wen, innă: «Ǝnta-den-dăɣ a-wa făl hawăn-ənneɣ ihənnin a-s wăr t-illa ere hi-dd-madăn-ăkk ar s-ad-ijraw turhajăt n-a-wen ɣur-Abba.» ");
INSERT INTO taq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ɣur-ten-dăɣ, əqqălăn ḍara-s inalkimăn ăjjootnen, ăbas has-əlkamăn. ");
INSERT INTO taq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Innăḍ-dd Ɣisa ḍarăt-a-wen s-inəṭṭulab-net wi n-măraw d-əssin, innʼ-asăn: «Kăwăneḍ-i-š, ajăn wăr tărhem uɣəl ḍarʼ-i?» ");
INSERT INTO taq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Innʼ-as Simyon Bəṭrus: «Ălɣalim, mi mad-năkk? Kăyy a iṭṭafăn iməjridăn-wi hakkănen tămudre ta tăɣlălăt; ");
INSERT INTO taq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","noman săr-k, nəkkas daɣ ăššăk a-s kăyy a-s Wa Šăddijăn dd-ifălăn Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Innʼ-asăn Ɣisa: «Kăwăneḍ-i n-măraw d-əssin, ajăn wădden năkk a kăwăn-ăsnăfrănăn? Hakd a-wen-dăɣ, iyyăn dăɣ-wăn, iblis.» ");
INSERT INTO taq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Măjrăd-wen-dăɣ, ijʼ-e Ɣisa făll-Yăhudəs Ăgg Simyon wa n-Isxaryut făl-a-s, ənta-i-dăɣ n-iyyăn dăɣ-inəṭṭulab wi n-măraw d-əssin a t-madăn-isəssăɣdăr. ");
INSERT INTO taq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ăllil Ɣisa ḍarăt-a-wen teje ta n-Galila făl-a-s, wăr irha ad-ilal ta n-Ălyăhudəyăt ed, ăɣtafăn-as dăɣ-s imizărăn n-kăl-Ălyăhud i-ad-t-ănɣən kərəf. ");
INSERT INTO taq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ăzzăman-en, ohaẓ ămudd n-kăl-Ălyăhud wa s-e-d dd-ija ad-əzzăɣăn daw-ihəktan. ");
INSERT INTO taq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ǝggădăn-dd ayətma-s n-Ɣisa, ənnăn-as: «Ăkk Ălyăhudəyăt i-ad-ənhəyăn inəṭṭulab-năk wi t-əllanen dihen ijităn-năk əntăneḍ-dăɣ, ");
INSERT INTO taq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ed ere irhan ad-săr-s əlmədăn ăddinăt, wăr-ixəddəm dăɣ-ufăr, ɣas, kunta tajjăd timašalen ogdăhnen d-a-wa-dăɣ asuksăḍ, ăjʼ-enăt dat-ăddunya iket-net.» ");
INSERT INTO taq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ǝnnăn-as ayətma-s a-wen ed wăr săr-s omenăn əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Innʼ-asăn Ɣisa: «Ălwăqq-in wăr-ija hărwa măšan, wa-năwăn ija hărkuk, ");
INSERT INTO taq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","kăwăneḍ wăr təla ăddunya ăddălil făl kăwăn-təkšăr măšan, năkk təkšar-ahi ed, tajăyheɣ făll-ijităn-net wi lăbasnen. ");
INSERT INTO taq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ăglăt ɣas kăwăneḍ, ăkkăt ămudd, năkk wăr t-əkkeɣ ed ăssaɣăt-in, wăr-iwweḍ.» ");
INSERT INTO taq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Innʼ-asăn Ɣisa a-wen ɣas, ăqqima dăɣ-Galila-en-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ǝkkăn ayətma-s ămudd ɣas, ikkʼ-e ənta-dăɣ ḍarăt-a-wen, măšan, dăɣ-ufăr i-ad-wăr săr-s ilmed ăwadəm. ");
INSERT INTO taq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ijʼ ašăl wa n-ămudd ɣas, ad-has-tammăɣăn imizărăn n-kăl-Ălyăhud, sastanăn d-diha d-t-illa. ");
INSERT INTO taq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tənkăr tamɣənnant dăɣ-tamətte dăɣ-isălan-net, ijanna aɣil iyyăn: «Ăwadəm olaɣăn a ămoos», ijanna aɣil wa iyyăḍăn: «A făw, a-di, išinməšrəy tamətte»; ");
INSERT INTO taq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","măšan, hakd a-wen-dăɣ, wăr t-illa ere iḍakkălăn emăsli-net i-ad-aməl Ɣisa făl tuksəḍa n-imizărăn n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ăẓunăn išilan n-ămudd ɣas, ikka Ɣisa ehăn n-ămudd wa măqqărăn, ad-dăɣ-s isaɣra. ");
INSERT INTO taq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ăkunăn kăl-Ălyăhud dăɣ-ălxikmatăn wi tăn-isasla har jannen: «Wa ălžahil, ənde d-dd-iɣra, mi t-issəlmădăn ăttăfăssir n-əlkəttabăn?» ");
INSERT INTO taq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ăwwežăb-asăn, innʼ-asăn: «A-wa săɣreɣ, wădden a dd-izjarăn erhet-in, erhet n-Măssinăɣ-i hi-dd-ăšmašălăn a dd-ifal. ");
INSERT INTO taq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɣas, ere irhăn ad-ămašăl erhet n-Măssinăɣ, ad-ilməd kunta asəssăɣăr wa tajjăɣ Măssinăɣ a dd-ifal meɣ-i dd-əkneɣ ɣur-iman-in. ");
INSERT INTO taq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ere itamăjradăn făll-iman-net, aḍkul n-iman-net ɣas a itattăr măšan, ere itattărăn təmmal n-wa t-dd-ăšmašălăn, tidət a ijanna, wăr t-iha a ifraɣăn. ");
INSERT INTO taq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ajăn wădden ănnăbi Mosa a kăwăn-ikfăn Ăṭṭăwrăt? Adiš mafăl wăr təmišilăm a-wa hawăn dăɣ-s inna? Ma hawăn-ăɣšădăɣ a-s tattărăm tenăɣe-nin?» ");
INSERT INTO taq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ǝnnăn-as: «Tidət-dăɣ a-s ihʼ-ik alšin, mi itattărăn tenăɣe-năk?» ");
INSERT INTO taq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Innʼ-asăn Ɣisa: «Jeɣ data-wăn iji iyyăn ɣas, tăkunăm dăɣ-s, ");
INSERT INTO taq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","amili, nəssan a-s wădden ănnăbi Mosa a făll-dd-ăzzubbăt s-tizarăt, imɣarăn wi has-ăzzarnen a făll-dd-ăzzubbăt măšan, omăr-kăwăn săr-s ɣas, ad-samalayăm aratăn wăla dăɣ-ašăl n-əssəbət-i n-tăsonfat. ");
INSERT INTO taq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ɣas, šămad wăr kăwăn-ăšnămăšrăy d-Ăṭṭăwrăt asəmmili n-ara dăɣ-ašăl n-əssəbət-i n-tăsonfat, adiš, mafăl kăwăn făll-i ihʼ ălhăm făl-a-s innin ăzozăyăɣ ăwadəm imdan dăɣ-ašăl n-əssəbət? ");
INSERT INTO taq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","He kăwăneḍ! Wăr təḍkeḍăm ăwadəm s-a-wa s-tordăm, hannăyăm fălla-s, əḍkəḍăt-t s-a-wa ămoosăn tidət.» ");
INSERT INTO taq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Innă Ɣisa a-wen ɣas, ad-jannen iyyăḍ dăɣ-kăl-Yărussălam: «Ajăn wădden ənta-i-dăɣ a-s tattărăn tenăɣe-net? ");
INSERT INTO taq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ǝnhəywăt-t, ădiwănnăt dăr-săn s-əmmək wa s-irha uhən wăr t-illa a has-ɣaššădăn. Tordam a-s wădden asədəttu a jăn imizărăn-nănăɣ a-s ənta-i-dăɣ a-s Ălmasex? ");
INSERT INTO taq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ălwăxla a-s ənta-i, nəssan siha s-dd-iha, a-s ija a-wen Ălmasex, wăr t-illa ere issanăn siha s-mad-dd-ihiy.» ");
INSERT INTO taq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iḍkăl Ɣisa emăsli-net, hărwa isaɣra dăɣ-ehăn n-ămudd wa măqqărăn, innă: «Wădden təzzayăm-ahi, təssanăm daɣ siha s-dd-heɣ măšan, hakd a-wen-dăɣ, əlmədăt a-s wăr dd-ăšmašălăɣ iman-in, ere wa hi-dd-ăšmašălăn, wăr t-təzzeyăm măšan, ădduuttăt; ");
INSERT INTO taq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","năkk-i t-dd-ifălăn, əzzayăɣ-t ed ənta a hi-dd-ăšmašălăn.» ");
INSERT INTO taq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ǝttărăn arămas-net măšan, wăr t-illa ere t-iḍasăn ed ălwăqq-net, wăr dd-iwweḍ hărwa. ");
INSERT INTO taq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Omănăn ăddinăt ăjjootnen hanen ălžămaɣăt-en-dăɣ s-Ɣisa ɣas, ad-tinmənnin jer-iman-năsăn: «Ak tordam a-s Ălmasex făw kud-dd-osa-dăɣ, ajăn ad-ăj ijităn n-Măssinăɣ ojărnen wi ijʼ ăhaləs-i-dăɣ!» ");
INSERT INTO taq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ǝslăn kăl-faris i-aḍkul wa təja tamətte Ɣisa dăɣ-ătuktek ɣas, əssəglăn imizărăn n-kăl-tikutawen d-kăl-faris ălgomităn n-ehăn n-ămudd wa măqqărăn i-ad-dd-ărməsăn Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Innʼ-asăn Ɣisa: «Ǝlleɣ jere-wăn ălwăqq ənḍărrăn, ḍarăt-a-wen, ad-ăqqəlăɣ ere wa hi-dd-Ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ilkam dăɣ-wăn ad-hi-təmmăɣăm măšan, wăr mad-hi-təjrəwăm ed siha s-əkkeɣ, wăr tăddobem aggaḍ-net.» ");
INSERT INTO taq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ănmănnăn imizărăn n-kăl-Ălyăhud jer-iman-năsăn: «Ǝndek ɣas edăgg wa mad-ăkk dăɣ-t wăr mad-nəjrəw? Tordam a-s irha ad-ăkk kăl-Ălyăhud wi əmmăhăšnen jer-kăl-Ălyunan meɣ tordam a-s kăl-Ălyunan-en-dăɣ a mad-ăkk i-ad-tăn-isăɣăr ămăra? ");
INSERT INTO taq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Meɣ ma tordam əndek ălmăɣna n-a-wa s-innă: ‹Ad-hi-təmmăɣăm măšan, wăr hi-mad-təjrəwăm› d-a-wa s-innă daɣ: ‹Siha s-əkkeɣ, wăr tăddobem aggaḍ-net?› » ");
INSERT INTO taq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ašăl wa išrăyăn măqqărăn d-imiddəw ămudd, ibdăd Ɣisa dat-ălžămaɣăt, iḍkăl emăsli-net, innă: «Ere ăffudăn-dăɣ, aset-ahi-dd, ăswet. ");
INSERT INTO taq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ere săr-i omănăn, ad-ənjəyăn ijərwan n-aman əddarnen dăɣ-ulh-net s-əmmək wa s-tăn-innă əlkəttab n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Innă Ɣisa a-wen, dăɣ-isălan n-Unfas n-Măssinăɣ wa mad-əjrəwăn wi maden-amən săr-s ed a-s ităjj a-wen-dăɣ, wăr dd-ăzzubbăt Unfas Šăddijăn ed Ɣisa wăr-ijješ ălxurmăt-net hărwa. ");
INSERT INTO taq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Təslă tamətte ta tăsijădăt i-a-wa innă ɣas, innʼ aɣil-net iyyăn: «Ădduuttăt a-s ănnăbi wa s-ătwănna ənta-da-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Innʼ aɣil iyyăn daɣ: «Ălmasex lab ənta-da-dăɣ.» Innʼ aɣil wa iyyăḍăn: «Ajăn Ălmasex Galila a mad-dd-ifəl? ");
INSERT INTO taq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wădden innʼ-anăɣ əlkəttab n-Măssinăɣ a-s: ‹Ălmasex əzzurəyăt ta n-ămănokal Dawəd d-tadăbayt-net Bătlehăm ta s-kăla dăɣ-s-izzăɣ a dd-mad-izjăr?› » ");
INSERT INTO taq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tăẓun tamətte dăɣ-təssəba n-Ɣisa, ");
INSERT INTO taq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","əttărăn iyyăḍ dăɣ-săn ad-t-ărməsăn măšan, ikkă jere-săn, wăr t-illa ere t-iḍasăn. ");
INSERT INTO taq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ǝqqălăn-dd ălgomităn n-ehăn n-ămudd wa măqqărăn, ənnăn-asăn imizărăn n-kăl-tikutawen d-kăl-faris: «Mafăl wăr t-dd-təlweyăm?» ");
INSERT INTO taq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ǝnnăn-asăn ălgomităn: «Năkkăneḍ a nəwa-dăɣ, wăr kăla nəslă i-ăwadəm ijan măjrăd irẓan wa ija ăhaləs-i-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ǝnnăn-asăn kăl-faris: «Adiš kăwăneḍ-dăɣ, ăšnămăšrăy-kăwăn? ");
INSERT INTO taq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Meɣ ajăn hannăyăm dăɣ-năɣ ămizăr meɣ ere təla taggayt ta n-kăl-faris săr-s omanăn? ");
INSERT INTO taq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ajăn wăr hənnəyăm a-s wăr săr-s omen ar ăddinăt wi n-ălžuhal wăren əssen a ihăn Ăṭṭăwrăt.» ");
INSERT INTO taq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Iggăd-dd Nikodem wa n-u-faris s-kăla dd-ădwănnăt i-Ɣisa s-ehăḍ, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ajăn ăššăreɣa-nănăɣ isaḍlam ăwadəm dat-ad-has-əslən ăddinăt, itwəlməd a-wa iɣšăd?» ");
INSERT INTO taq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ǝnnăn-as: «Ajăn kăyy-dăɣ Galila a kăy-təlăt? Səffəyk ɣas əlkəttabăn n-Măssinăɣ, təmmaẓ təkkăsăd-dd dăɣ-săn ănnăbi dd-ifalăn Galila.»  ");
INSERT INTO taq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ḍarăt măjrăd-wen-dăɣ, hak ăwadəm ikkʼ ehăn-net. ");
INSERT INTO taq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Odwa Ɣisa ənta ehăḍ-wen taḍaɣt ta n-ihəškan wi n-əzzăytun. ");
INSERT INTO taq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ăffăw ɣas, olăs-dd uɣəl n-ehăn n-ămudd wa măqqărăn, tăddew-dd săr-s daɣ tamətte iket-net, ăqqima, ad-tăt-isaɣra. ");
INSERT INTO taq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ǝwwăyăn-dd ălɣulam n-Ăṭṭăwrăt d-kăl-faris tamăḍt tăttirmăsăt dăɣ-əzzəna, əssəbdădăn-tăt dăɣ-ammas n-ălžămaɣăt təzzar, ");
INSERT INTO taq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ənnăn i-Ɣisa: «Ălɣalim, ta-dăɣ tamăḍt, a-s tăt-dd-năɣdăr, izinnəw-tăt ăhaləs iyyăn. ");
INSERT INTO taq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dăɣ-isălan n-tiḍeḍen-ti maden-ăttărmăs dăɣ-əzzəna, innʼ-anăɣ ănnăbi Mosa dăɣ-Ăṭṭăwrăt a-s ad-tănăt-năkf sămmăjori n-tihun. Ămăra, năssistăn-kăy, ma tənned kăyy dăɣ-isălan-win-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Otasăn ălɣulam n-Ăṭṭăwrăt d-kăl-faris asəstan-net, wăr təmmăɣăn ɣas ar i-ăsaru făl t-əssəḍlămăn. Ǝnnăn-as a-wen ɣas, ăddunkăt Ɣisa ad-ikattăb făll-ăkall s-assəkăḍ-net. ");
INSERT INTO taq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ăxwălăn-t s-asəstan ɣas, iḍkăl-dd săr-săn asăwaḍ-net, innʼ-asăn: «Ijăret-tăt dăɣ-wăn wa s-kăla wăr-ofa abăkkaḍ s-tăhunt ta tăzzarăt.» ");
INSERT INTO taq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ăddunkăt daɣ ḍarăt-a-wen, ad-ikattăb făll-ăkall. ");
INSERT INTO taq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ǝslăn ălɣulam n-Ăṭṭăwrăt d-kăl-faris i-a-wa hasăn-inna ɣas, əglăn s-iyyăn-iyyăn, ɣur-wi wăššarnen har wi măḍroynen. Wăr dd-ăqqima dăɣ-edăgg-ənnin-dăɣ ar Ɣisa, təbdad data-s tamăḍt, dăɣ-ammas n-edăgg wa s-kăla dăɣ-s ibdăd ălžămaɣăt. ");
INSERT INTO taq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ibdăd-dd săr-s Ɣisa, innʼ-as: «Tamăḍt! Ma jăn ăddinăt wi s-kăla kăm-əṭṭăfăn? Ajăn ăbas kăm-ăsiwăr ăwadəm wălʼ iyyăn uḍlem?» ");
INSERT INTO taq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tənnʼ-as: «Ăbo, Ălɣalim, ăbas t-illa ăwadəm wălʼ iyyăn.» Innʼ-as Ɣisa daɣ: «Wăr kăm-əssəḍlămăɣ năkk-dăɣ, ămăra, əgləw măšan, wăr tolesăd iji n-abăkkaḍ.» ");
INSERT INTO taq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Innă Ɣisa ḍarăt-a-wen i-tamətte: «Năkk a-s ănnur n-ăddunya, ere-wa hi-ilkămăn wăr mad-irjəš dăɣ-tihay, ănn-ak, ad-ijrəw ănnur wa ihăkkăn tămudre.» ");
INSERT INTO taq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ǝggădăn-dd kăl-faris, ənnăn-as: «Kăyy ya tajăyhed făll-iman-năk, a-wen-dăɣ daɣ a ăsdătten a-s tajuhe-năk, bahu.» ");
INSERT INTO taq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Innʼ-asăn Ɣisa: «Kud-tajăyheɣ făll-iman-in-dăɣ, năkk, tajuhe-nin, tădduuttăt ed, əssanăɣ siha s-dd-heɣ, əssanăɣ daɣ siha s-hălăɣ măšan kăwăneḍ, wăr təssenăm siha s-dd-heɣ, wăla siha s-əkkeɣ. ");
INSERT INTO taq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kăwăneḍ, tayətte ta n-dăgg-adəm a-s šarrăɣăm ăddinăt, năkk wăr t-illa ere šarrăɣăɣ, ");
INSERT INTO taq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ḍarăt-a-wen daɣ, năkk, kud-əšrăɣăɣ ăwadəm-dăɣ, a-s mad-tasəm ăššăreɣa-nin, i n-tidət făl-a-s, wăr t-jeɣ d-iman-in ɣas, oharăɣ-t d-Abba-nin i hi-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wădden iktab dăɣ-alămăr-năwăn a-s təgdăh tajuhe n-əssin ăddinăt i-asətbat n-hărăt. ");
INSERT INTO taq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ăywa, năkk leɣ sănatăt tijuhawen, ămoosăɣ tajuhe făll-iman-in, ăjjəyhʼ-ahi daɣ Abba-i hi-dd-ăšmašălăn.» ");
INSERT INTO taq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Innă Ɣisa a-wen ɣas, ənnăn-as kăl-faris: «Abba-năk-i-š, əndek diha t-illa?» Innʼ-asăn Ɣisa: «Wăr hi-təzzeyăm năkk wăla Abba-nin ed, ənnăr hi-təzzayăm, təzzəyăm daɣ Abba-nin.» ");
INSERT INTO taq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A-s ijă Ɣisa măjrăd-wa-dăɣ, isaɣra dăɣ-ehăn n-ămudd wa măqqărăn, edes i-əssəndoqq wa dăɣ-inass aẓrəf d-orăɣ wa təkkatăn ăddinăt i-ehăn n-ămudd wa măqqărăn măšan, wăr t-illa ere t-irmasăn ed, ălwăqq-net wăr dd-iwweḍ hărwa. ");
INSERT INTO taq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Innʼ-asăn Ɣisa daɣ: «Təlkam dăɣ-i tekle, tekle daɣ dăɣ-mad-hi-təmmăɣăm măšan, ad-tămmătăm dăɣ-abăkkaḍ-năwăn ed, edăgg wa əkkeɣ, wăr tăddobem aggaḍ-net.» ");
INSERT INTO taq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ǝslăn kăl-Ălyăhud i-a-wen ɣas, ănmănnăn jer-iman-năsăn: «Tordam a-s wădden a-s ăbok ad-ănɣ iman-net a-s ijăn: ‹Edăgg wa əkkeɣ, wăr tăddobem aggaḍ-net.› » ");
INSERT INTO taq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Innʼ-asăn Ɣisa: «Kăwăneḍ ăddunya-i-dăɣ a kăwăn-lăt, năkk išənnawăn a hi-lănen, kăwăneḍ, təlʼ-iwăn ăddunya-ta-dăɣ, a-s ija a-wen năkk, wăr hi-təla. ");
INSERT INTO taq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A-wen-dăɣ daɣ a făl hawăn-ənneɣ a-s ad-tămmătăm dăɣ-ibăkkaḍăn-năwăn ed, ijmăḍ-t ăššăk a-s afăl wăr tomenăm a-s ‹Năkk a iɣlalăn›, ad-tămmătăm dăɣ-ibăkkaḍăn-năwăn.» ");
INSERT INTO taq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ǝnnăn-as: «Kăyy-š, mi tămoosăd?» Innʼ-asăn Ɣisa: «Ămoosăɣ a-di-dăɣ s-ăru d-hawăn-ənneɣ: ‹Năkk ăɣlalăɣ›. ");
INSERT INTO taq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Leɣ a ăjjeen fălla-wăn ənneɣ, illʼ-e daɣ uḍlem ăjjeen kăwăn-ăswărăɣ măšan, Wa hi-dd-ăšmašălăn, ădduuttăt, wăr jənneɣ daɣ i-ăddunya ar a-wa s-has-əsleɣ har tăn-innă.» ");
INSERT INTO taq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Innʼ-asăn Ɣisa a-wen-dăɣ măšan, wăr əfhemăn s-isălan n-Abba-net a hasăn-itajj. ");
INSERT INTO taq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Innʼ-asăn daɣ ălwăqq-wen: «Afăl dd-osa ašăl wa d-tənhăyăm Ăgg-ăgg-adəm ămmiiḍkăl s-išənnawăn dăɣ-ammas-năwăn, dihen, ad-təlmədăm a-s: ‹Năkk a iɣlalăn›, təlmədăm daɣ a-s wăr t-illa a tajjăɣ d-iman-nin, wăr jənneɣ ɣas ar a-wa hi-issăɣra Abba. ");
INSERT INTO taq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ǝnta-i hi-dd-ăšmašălăn, idhal-ahi, wăr hi-oyya d-iman-in ɣas ed, ənta ɣas a-s tamašalăɣ erhet-net hărkuk.» ");
INSERT INTO taq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Orăw-dd măjrăd-wen-dăɣ ija Ɣisa, immun s-ăddinăt ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Inna Ɣisa ḍarăt-a-wen i-kăl-Ălyăhud wi săr-s omănnen: «Afăl təkfăm iman-năwăn i-măjrăd-in, ad-tumasăm inəṭṭulab ətbatnen, ");
INSERT INTO taq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","təzzəyăm tidət, səddărfət-kăwăn.» ");
INSERT INTO taq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ǝnnăn-as: «Năkkăneḍ-š wădden əzzurəyăt n-ănnăbi Ibrahim a nămoos, wăr kăla hanăɣ-ikrăš ăwadəm wălʼ iyyăn ɣas, ənnăr əmmək wa s-jănned ad-năddărf?» ");
INSERT INTO taq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s, e d t-illăm ăwadəm itamašalăn abăkkaḍ, ăkkilăt-as. ");
INSERT INTO taq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Təssanăm a-s akli, wăr-itəzzăɣ dăɣ-ehăn n-măssi-s hărkuk măšan, Rure-s n-măssi-s n-ehăn ənta, ad-dăɣ-s izzaɣ hărkuk. ");
INSERT INTO taq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Afăl kăwăn-ăsdărfăt Rure-s n-măssi-s n-ehăn, ad-təjrəwăm iman-năwăn. ");
INSERT INTO taq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ǝssanăɣ a-s əzzurəyăt n-ănnăbi Ibrahim a tămoosăm măšan, hakd a-wen-dăɣ, tattărăm tenăɣe-nin făl-a-s, wăr-ijrew măjrăd-in edăgg dăɣ-ulhawăn-năwăn. ");
INSERT INTO taq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Năkk, wăr hawăn-jənneɣ ar a-wa ənhăyăɣ ɣur-Abba-nin ɣas, kăwăneḍ daɣ, wăr təjjəm ɣas ar a-wa s-təslăm ɣur-abba-năwăn.» ");
INSERT INTO taq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ăwwežăbăn-as, ənnăn-as: «Năkkăneḍ, ănnăbi Ibrahim a-s abba-nănăɣ.» Innʼ-asăn Ɣisa: «Ǝnnar ihăyawăn n-ănnăbi Ibrahim a tămoosăm, ikad-di, tămašălăm a-wa ămešăl ");
INSERT INTO taq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","măšan ămăra, kăwăneḍ-da-dăɣ, tattărnen tenăɣe-nin făl-a-s innin ənneɣ-awăn tidət-ta s-əsleɣ ɣur-Măssinăɣ, tăkunt šund-ten, wăr tăt-ija Ibrahim. ");
INSERT INTO taq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","A-wen-dăɣ a făl hawăn-janneɣ a-s kăwăneḍ, ijităn n-abba-năwăn ɣas, a tamašalăm.» Ǝnnăn-as: «Năkkăneḍ ya, wădden ikẓewăn a nămoos, Abba iyyăn a nəla, a t-ămoosăn: Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Innʼ-asăn Ɣisa: «Ǝnnar ămoos Măssinăɣ Abba-năwăn, tărhəm-ahi ed ənta a dd-əzjarăɣ, ənta daɣ a dd-fălăɣ, wăr dd-əgleɣ d-iman-in, ənta a hi-dd-ăšmašalăn. ");
INSERT INTO taq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ajăn ma hawăn-igdalăn ad-təjrăhăm a-wa hawăn-janneɣ? Igdal-awăn-t a-wa-dăɣ s-tunjăyăm asjəd i-măjrăd-in. ");
INSERT INTO taq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Iblis a-s abba-năwăn, ənta a-s tăqbalăm amišəl n-derhanăn-net, ənta-i-s s-alăṣăl dăɣ-emăjj n-iman, wăr kăla ibdăd făll-tidət ed, tidət făw a wăr-issen. E-d imməjrăd-dăɣ, bahu ɣas a ijanna ed a-wen-dăɣ a-s agna-net făl-a-s, ănăsbahu a ămoos, ənta daɣ a-s abba n-bahu. ");
INSERT INTO taq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Năkk wăr hi-təflesăm ed tidət a hawăn-janneɣ. ");
INSERT INTO taq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ǝndek dăɣ-wăn ɣas wa ăddoben ad-ăjjăyh a-s kăla ămešălăɣ abăkkaḍ? Šămad tidət a hawăn-janneɣ, adiš mafăl wăr hi-fəlləsăm? ");
INSERT INTO taq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ere wa ila Măssinăɣ, asjəd a itajj i-a-wa innă Măssinăɣ măšan, kăwăneḍ, wăr tămoosăm aratăn n-Măssinăɣ, a-wen-dăɣ a făl wăr hi-səjidăm.» ");
INSERT INTO taq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ăwwežăbăn-as kăl-Ălyăhud, ənnăn-as: «A-wa tidət-dăɣ a-s nənna kăyy u-Sămari a tămoosăd, ihʼ-ik alšin.» ");
INSERT INTO taq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Innʼ-asăn Ɣisa: «Năkk lab, wăr hʼ-iha alšin, semɣar ɣas a jeɣ Abba-nin, a-s ija a-wen kăwăneḍ, tunjayăm s-asəmɣar-in. ");
INSERT INTO taq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Năkk, wăr təttărăɣ ad-hi-səmɣărăn ăddinăt, illʼ-e ere wa itattărăn ad-hi-səmɣărăm, ənta-en-daɣ a kăwăn-madăn-išrăɣ. ");
INSERT INTO taq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ere iṭṭafăn măjrăd-in, wăr dăɣ-s ilkem ad-inhay tamăttant.» ");
INSERT INTO taq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ǝnnăn-as kăl-Ălyăhud: «Ɣur-ta-dăɣ, ad-nəlmăd s-tidət-dăɣ a-s ihʼ-ik alšin, ajăn wădden Ibrahim hakd ănnăbităn wi iyyăḍnen, təmmăr-tăn-in tamăttant, ɣas kăyy, ma kăy-ăsihălăn tənna n-a-s: ‹Ere iṭṭafăn măjrăd-in, wăr dăɣ-s ilkem ad-inhay tamăttant.› ");
INSERT INTO taq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Adiš kăyy ija ɣur-k a-s tojărăd abba-nănăɣ Ibrahim d-ănnăbităn wi iyyăḍnen ămmutnen? Ajăn kăyy, ma s-tăɣelăd tămoosăd-t?» ");
INSERT INTO taq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Innʼ-asăn Ɣisa: «Ǝnnar iman-in ɣas a timəlaɣ, wăr-inəffəw a-wen hărăt, Abba-nin-i s-tənnăm Emăli-năwăn a ămoos, ənta a hi-itiməlăn. ");
INSERT INTO taq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Abba-nin-en, əzzayăɣ-t măšan kăwăneḍ, wăr t-təzzeyăm. Afăl hawăn-ənneɣ wăr t-əzzeyăɣ, ad-umasăɣ ănăsbahu dăr-wăn olăhăn. Ădduuttăt a-s Abba-nin, əzzayăɣ-t, tamašalăɣ daɣ măjrăd-net. ");
INSERT INTO taq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ănnăbi Ibrahim daɣ-i s-jannem abba-năwăn a ămoos, iddəwăt dăɣ-derhan n-ahănay n-ašăl wa n-tiwit-in, inhăy-t ɣas, ija tedăwit təmdat.» ");
INSERT INTO taq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Innă Ɣisa a-wen ɣas, ənnăn-as kăl-Ălyăhud: «Kăyy, wăr led wăla-dăɣ səmmosăt timərwen n-awătay, uhən-dăɣ, hălăd ad-tənnəd, tənhayăd ănnăbi Ibrahim?» ");
INSERT INTO taq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Innʼ-asăn Ɣisa: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s dat-tiwit n-Ibrahim, əlleɣ-t ed ‹Năkk ăɣlalăɣ.› » ");
INSERT INTO taq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ǝḍkălăn ălwăqq-wen-dăɣ tihun i-ad-t-əjrən săr-snăt măšan, iffăr-asăn dăɣ-tamətte, izjăr ehăn n-ămudd wa măqqărăn. ");
INSERT INTO taq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ašăl iyyăn, irjaš Ɣisa a-s inhăy ăhaləs s-a-s dd-iwa-dăɣ dărɣal. ");
INSERT INTO taq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ǝssəstănăn-t inəṭṭulab-net, ənnăn-as: «Ălɣalim, ak ăhaləs-i-dăɣ s-ad-dd-iwa-dăɣ dărɣal, ənta a ămešălăn abăkkaḍ wa has-ămoosăn əssəbab n-tăddărɣălt meɣ imărawăn-net?» ");
INSERT INTO taq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ăwwežăb-asăn, innʼ-asăn: «Wăr-ofa abăkkaḍ ənta wăla imărawăn-net, ănn-ak Măssinăɣ a irhan ad-ăj ălɣib-net əssəbab s-issəkna tărna-net. ");
INSERT INTO taq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iwar-anăɣ ad-năxdəm tărha n-Wa hi-dd-ăšmašălăn hărwa ijʼ ašăl făl-a-s, imal-dd ehăḍ s-wăr t-illa ere ăddoben ălxidmăt dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","A əkkeɣ heɣ ăddunya-ta-dăɣ, năkk a-s ănnur-net.» ");
INSERT INTO taq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Innă Ɣisa a-wen ɣas, ăssotăf făll-ăkall, issəbdăj tălaɣt s-tisutaf-net təzzar, isəlsʼ-et tiṭṭawen n-emədderɣəl. ");
INSERT INTO taq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Innʼ-as ḍarăt-a-wen: «Ǝgləw, ărdəb dăɣ-tăsahaɣt n-aman ta n-Silwi.» (Silwi, ălmăɣna-net: ănămmašul.) Iglă, irdăb-dd, a-s dd-iqqăl, ihannăy. ");
INSERT INTO taq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ǝnhăyăn-t ănhărajăn-net d-ăddinăt wi t-əzzăynen hărwa dărɣal ɣas, ănmănnăn: «Ka! Ajăn wădden a-wa emədderɣəl wa itaɣăymen dăɣ-tăšarrit itattăr takute dăɣ-ăddinăt?» ");
INSERT INTO taq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Innʼ aɣil-năsăn: «Ewăḷḷa ənta.» Innʼ aɣil wa iyyăḍăn: «Aa făw! Wădden ənta, milhaw ɣas a jan.» Iggăd-dd emədderɣəl iman-net ălwăqq-wen, innʼ-asăn: «A-wa năkk wədi-dăɣ təzzăyăm.» ");
INSERT INTO taq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ǝnnăn-as: «Ǝndek əmmək wa s-ămerănăt tiṭṭawen-năk?» ");
INSERT INTO taq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Innʼ-asăn emədderɣəl: «Ăhaləs wa s-isəm-net Ɣisa a issəbdăjăn tălaɣt, issəlsʼ-et tiṭṭawen-in təzzar, innʼ-ahi: ‹Ǝgləw, ărdəb dăɣ-tăsahaɣt n-aman ta n-Silwi›. Ǝkkeɣ tăsahaɣt n-aman ălwăqq-wen-dăɣ, ărdăbăɣ-dd dăɣ-s.» ");
INSERT INTO taq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ǝnnăn-as ăddinăt: «Wa kăy-ăzozăyăn-š, ma ija?» Innʼ-asăn ăhaləs: «Wăr-əssenăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ǝmdăn ăddinăt d-asəstan n-ăhaləs wa s-kăla dărɣal ɣas, ăwwăyăn-t s-kăl-faris ");
INSERT INTO taq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","făl-a-s, ašăl n-əssəbət-i n-tăsonfat a dăɣ-issəbdăj Ɣisa tălaɣt-ta ăswăr tiṭṭawen-net, orʼ-enăt. ");
INSERT INTO taq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Osă-dd emədderɣəl wa izzăyăn kăl-faris ɣas, əssəstănăn-t d-əmmək wa s-izzăy. Innʼ-asăn: «Ăswăr Ɣisa tălaɣt tiṭṭawen-in, ărdăbăɣ, ənhăyăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Innʼ aɣil n-kăl-faris iyyăn: «Wa-dăɣ Ɣisa, wăr-ămoos ănămmašul n-Măssinăɣ ed ənnar t-ămoos, isəmɣăr ašăl wa n-əssəbət-i n-tăsonfat.» Innʼ aɣil-năsăn wa-iyyăḍăn: «Ajăn anăsbăkkaḍ wăr-idhel Măssinăɣ, ăddoobăt amišəl n-ijităn wi ităjj ăhaləs-i-dăɣ ?» Ǝqqălăn-dd ɣas ămiɣănnănăn jer-iman-năsăn dihen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ǝssəstănăn ḍarăt-a-wen emədderɣəl wa izzăyăn, ənnăn-as: «Kăyy ma tənned, ma iqqal ăhaləs wa orăn tiṭṭawen-năk?» Innʼ-asăn: «Un ănnăbi a ămoos.» ");
INSERT INTO taq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ăɣrăn-dd imizărăn n-kăl-Ălyăhud ḍarăt-a-wen imărawăn n-emədderɣəl făl-a-s, wăr-əflesăn a-s kăla dărɣal, izzăy. ");
INSERT INTO taq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Osăn-dd imărawăn n-ăhaləs ɣas, əssəstănăn-tăn: «Ak rure-wăn wa s-tənnăm a-s dd-iwa-dăɣ, dărɣal, ənta-da-dăɣ meɣ? Kunta daɣ a dd-iwa-dăɣ, dărɣal, əndek əmmək wa s-ămăra, ihannăy?» ");
INSERT INTO taq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ǝnnăn-asăn imărawăn n-ăhaləs: «Tidət lab a-s a-wa rure-năɣ, wăr t-ihʼ ăššăk daɣ s-a-s dd-iwa-dăɣ, dărɣal ");
INSERT INTO taq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","măšan, dăɣ-isălan n-əmmək wa s-ihannăy ămăra d-ere wa orăn tiṭṭawen-net, a-wen, wăr hanăɣ-ha tijya-net, səstənăt-t ənta iman-net ed ăhaləs iššamăn a ămoos, ăddoobăt ad-ăj isălan n-a-wa t-iqqălăn.» ");
INSERT INTO taq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tuksəḍa n-imizărăn n-kăl-Ălyăhud a tăswănnăt imărawăn-net a-wen făl-a-s, ăssiibdădăn imizărăn n-kăl-Ălyăhud s-e d t-illăm ere irḍăn a-s: «Ɣisa a-s Ălmasex», ad-has-əgdəlăn ujəš n-ehăn n-ăddin wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Dăɣ-tuksəḍa n-a-wen-dăɣ a făl ənnăn imărawăn n-ăhaləs: «Ăhaləs iššamăn a ămoos, səstənăt-t ənta iman-net.» ");
INSERT INTO taq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Olăsăn-dd kăl-faris teɣăre n-ăhaləs wa s-kăla dărɣal, ənnăn-as: «Ănn tidət i-Măssinăɣ făl-a-s, nəssan a-s wa kăy-ăzozăyăn, anăsbăkkaḍ a ămoos.» ");
INSERT INTO taq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Innʼ-asăn: «Kunta anăsbăkkaḍ a ămoos wăla, wăr-əssenăɣ; hărăt iyyăn a əssanăɣ: kăla dărɣalăɣ, ămăra, hannăyăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ǝnnăn-as daɣ: «Lăɣăt-anăɣ ma hak-ija? Ǝndek əmmək wa s-ora tiṭṭawen-năk?» ");
INSERT INTO taq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Innʼ-asăn ăhaləs: «Wădden ăru d-hawăn-tăn-ənneɣ măšan, wăr hi-tăsjădăm ɣas, mafăl tărham daɣ ad-hawăn dăɣ-s ăqqəlăɣ? Adiš a tărham ad-tumasăm kăwăneḍ-dăɣ hărăt dăɣ-inəṭṭulab-net?» ");
INSERT INTO taq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Innʼ-asăn a-wen ɣas, ad-t-gaggărăn, jannen-as: «Aa təfəw! Kăyy ɣas a-s ănăṭṭalib-net, năkkăneḍ, inəṭṭulab n-ănnăbi Mosa a nămoos, ");
INSERT INTO taq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","nəssan daɣ a-s ănnăbi Mosa imməjrăd-as Măssinăɣ măšan, wa-hi, wăr nəssen e-s dd-iha.» ");
INSERT INTO taq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Innʼ-asăn emədderɣəl wa izzăyăn: «Adiš tăqqăn n-eɣăf təja hărwa ed, ənta a orăn tiṭṭawen-in măšan hakd a-wen, wăr təssenăm e-s dd-iha.» ");
INSERT INTO taq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Innʼ-asăn daɣ: «Nəssan a-s Măssinăɣ, wăr iɣəbbəl tittar n-inăsbăkkaḍăn măšan, iɣabbăl tittar n-e d t-illăm ere t-ăksuḍăn, itamašalăn erhet-net. ");
INSERT INTO taq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nəssan daɣ a-s wăr kăla ătwăsla ăwadəm oran tiṭṭawen n-ere s-a-s dd-iwa-dăɣ, dărɣal. ");
INSERT INTO taq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɣas, ăhaləs-i-dăɣ, ənnăr wădden Măssinăɣ a dd-ifal, wăr-ikərrəš tădabit n-a-wa ităjj.» ");
INSERT INTO taq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Issəmdă emədderɣəl wa izzăyăn d-măjrăd ɣas, ənnăn-as: «Ewad! Kăyy iket-năk abăkkaḍ a dăɣ-wed, ma kăy-ăsihălăn ălxuṭbăt wa hanăɣ-tăjjăd?» Ăššewăjăn săr-s ḍarăt-a-wen har t-əzzəzjărăn ehăn n-ăddin wa hăn. ");
INSERT INTO taq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Islă Ɣisa a-s əkkăsăn-t dăɣ-ehăn n-ăddin-năsăn ɣas, osʼ-e-hi-dd, innʼ-as: «Ak kăyy tomanăd s-Ăgg-ăgg-adəm meɣ?» ");
INSERT INTO taq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Innʼ-as ăhaləs wa s-kăla dărɣal: «Ălɣalim, săkən-ahi-t ɣas ad-săr-s amənăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Innʼ-as Ɣisa: «Tənhăyăd-t ed, ənta-da-dăɣ hak-ămmijrădăn ămăra-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Innʼ-as ăhaləs ălwăqq-wen: «Ălɣalim, omanăɣ săr-k.» Irkăɣ dat-Ɣisa ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Innă Ɣisa i-tamətte ḍarăt-a-wen: «Năkk, oseɣ-dd i-ad-əbḍəwăɣ jer-ăddinăt: wi dărɣalnen, ad-ənhəyăn, wi hannăynen, ad-ăddărɣălăn.» ");
INSERT INTO taq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ǝslăn kăl-faris wi t-əllănen ɣur-Ɣisa i-măjrăd-wen-dăɣ ija ɣas, ənnăn-as: «Ajăn năkkăneḍ-dăɣ iməddorɣal a nămoos?» ");
INSERT INTO taq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Innʼ-asăn Ɣisa: «Ǝnnăr tămoosăm iməddorɣal, wăr kăwăn-itəgger uḍlem wa n-abăkkaḍ măšan, dăɣ-təssəba n-a-di-dăɣ s-tənnăm hannăyăm, a făl, tumast-năwăn i-inăsbăkkaḍăn, tətbat.» ");
INSERT INTO taq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s e d t-illăm ere dd-ijjašăn afăraj n-arəzzej s-ašrut săl wa n-emm-net, emăkrăḍ d-ănarkab a ămoos, ");
INSERT INTO taq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","măšan, amăḍan n-tihatten ənta, emm n-afăraj a-s dd-itajjăš făll-tihatten-net. ");
INSERT INTO taq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","E-d tănăt-dd-osa, ad-has-arr ănaɣlaf-năsnăt s-ehăḍ emm n-afăraj. Afăl has-ămera afăraj har dd-ijjăš fălla-snăt, ad-əslənăt tihatten-net i-emăsli-net, iɣăr hak iyyăt s-isəm-net təzzar, izəzjăr-tănăt, ");
INSERT INTO taq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","afăl tănăt-dd-izzəzjăr iket-năsnăt, ad-iməl data-snăt, əlkəmnăt-as ed, əzzaynăt emăsli-net. ");
INSERT INTO taq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amăḍan-en, tihatten-net, wăr mad-əlkəmnăt i-amăjar, ănn-ak, ad-has-əffoqqətnăt ed, wăr-əzzeynăt emăsli-net.» ");
INSERT INTO taq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ăsnăfăqqʼ-asăn Ɣisa isălan-win-dăɣ măšan, indăr-asăn ad-əfhəmăn a dăɣ-hasăn-ăssewăl. ");
INSERT INTO taq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Olăs daɣ, innʼ-asăn: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s năkk a-s emm n-afăraj wa s-tajjăšnăt tihatten, ");
INSERT INTO taq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ăddinăt-wi hi-dd-ăzzarnen, imăkrăḍăn d-inarkabăn a ămoosăn iket-dăɣ-năsăn, wăr hasăn-ăsjădnăt tihatten; ");
INSERT INTO taq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","năkk a-s emm n-afăraj, ere săr-i t-dd-ijjăšăn-dăɣ, ad-iɣləs, ad-igilləw, itaqqăl-dd, ijarrăw daɣ amăḍon. ");
INSERT INTO taq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Emăkrăḍ ənta, wăr dd-itis ar i-tikra d-aɣăras d-ahălak; năkk, oseɣ-dd i-ad-əjrəwăn dăgg-adəm tămudre, əjrəwăn-tăt daɣ s-tănoflayt. ");
INSERT INTO taq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Năkk a-s amăḍan wa olăɣăn, amăḍan wa olăɣăn iman-net a ihakk i-ad-ăɣləsnăt tihatten-net ");
INSERT INTO taq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","măšan, ere wa s-tefert a făl ixdam, wăr-ămoos amăḍan olaɣăn, wădden ənta a-s măssi-s n-tihatten. A-wen-dăɣ a-s, afăl inhăy taɣəssit dd-malăt, ad-ăjawăḍ, ăyy tihatten d-iman-năsnăt, təjjəš-tănăt taɣəssit, šəmməhəš-tănăt, ");
INSERT INTO taq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ed issan a-s tefert ɣas a făl ixdam, wăr-ăkkul a jănăt tihatten. ");
INSERT INTO taq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Năkk a-s amăḍan wa olăɣăn, əzzayăɣ tihatten-in, əzzaynăt-ahi daɣ. ");
INSERT INTO taq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ǝzzaynăt-ahi s-əmmək wa s-əzzayăɣ Abba, izzay-ahi daɣ ənta. Hakkăɣ-tănăt tămudre-nin, ");
INSERT INTO taq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","leɣ hărwa tihatten ăjjootnen wăren ha afăraj-wa-dăɣ, iwar-ahi s-ad-tănăt-dd-əwətăɣ, əslənăt əntănăteḍ-dăɣ i-emăsli-nin, təməl-t tiyyăt tahrut iḍan iyyăn n-amăḍan. ");
INSERT INTO taq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Abba ənta, irhʼ-ahi ed hakkăɣ tămudre-nin, siɣulăɣ-tăt-dd iman-in. ");
INSERT INTO taq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wăr t-illa ere ăddoben ad-dăɣ-i ahăɣ tămudre-nin, hakkăɣ-tăt d-iman-in, siɣulăɣ-tăt-dd dăɣ d-iman-in, ənta-den-dăɣ turhajăt ta əjrăwăɣ ɣur-Abba-nin.» ");
INSERT INTO taq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ǝslăn kăl-Ălyăhud i-măjrăd-wen-dăɣ ija Ɣisa ɣas, tənkăr tamɣənnant daɣ jere-săn. ");
INSERT INTO taq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ǝggădăn-dd dăɣ-săn iyyăḍ ăjjootnen, ad-jannen: «Ak mafăl tăsijădăm i-ere ihʼ alšin, ăbbuddăl?» ");
INSERT INTO taq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jannen wi iyyăḍnen: «Măjrăd wa dd-izjărăn emm n-ăhaləs-i-dăɣ, wădden măjrăd s-ăddoobăt ad-t-ăj ere ihʼ alšin, nəssan daɣ a-s ere ihʼ alšin, wăr-ăddoobăt ad-arr tiṭṭawen n-iməddorɣal.» ");
INSERT INTO taq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ăzzăman-en, ijă ămudd n-tasăktot n-ašəšdaj wa jăn kăl-Ălyăhud i-ehăn n-ămudd wa măqqărăn ihăn Yărussălam s-tajrəst, ");
INSERT INTO taq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","irjăš Ɣisa dăɣ-ehăn n-ămudd wa măqqărăn dăɣ-tele n-edăgg wa s-itawănna: Wa n-Sulăyman, ");
INSERT INTO taq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","əžžəmmăɣăn-dd fălla-s kăl-Ălyăhud, ənnăn-as: «Ǝkkəs-anăɣ dăɣ-taɣdărt, kunta kăyy a-s Ălmasex, ănnʼ-anăɣ-tăn, ma s-tăqqalăd, təkkəsăd-anăɣ dăɣ-tăqqăn n-eɣăf-ta-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ăwwežăb-asăn, innʼ-asăn: «Wădden, əllăɣeɣ-awăn măšan, tunjăyăm tomănăm săr-i, ənhəywăt ɣas ijităn wi s-hi-ikfa Abba-nin turhajăt n-amišəl-năsăn, əntăneḍ-en-dăɣ a tajăyhanen făll-i. ");
INSERT INTO taq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kăwăneḍ, wăr săr-i tomenăm făl-a-s wăr tăḍḍinăm dăɣ-ăddinăt wi hănen tahrut ta n-inalkimăn-in. ");
INSERT INTO taq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tahrut ta leɣ n-inalkimăn-in, sallăn i-emăsli-nin, əzzayăɣ-tăn, əlkamăn-ahi daɣ. ");
INSERT INTO taq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wi leɣ, hakkăɣ-tăn tămudre ta tăɣlălăt, wăr dăɣ-săn təlkem tamăttant, wăr tăn-mad-ahăɣ daɣ ăwadəm wălʼ iyyăn dăɣ-ăfuss-in ");
INSERT INTO taq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","făl-a-s, Abba-nin-i hi-tăn-ikfăn, wăr t-illa ere s-wădden illʼ-e jənnəj-s, wăr t-illa daɣ ere ăddooben ukəs-năsăn dăɣ-ăfuss-net. ");
INSERT INTO taq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Năkk d-Abba, iyyăn hărăt, wăr nəẓley.» ");
INSERT INTO taq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Innă Ɣisa a-wen ɣas, obărăn-dd săr-s tihun i-ad-t-əkfən sămmăjori-năsnăt măšan, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","«Lăɣătăt-ahi ɣas dăɣ-ijităn n-Abba wi-dăɣ ăhuskătnen jeɣ jere-wăn, əndek dăɣ-săn wa ilăn ăddălil n-tenăɣe ta s-tărham ad-hi-tăt-təjəm?» ");
INSERT INTO taq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ǝnnăn-as kăl-Ălyăhud: «Wădden dăɣ-təssəba n-iji ăhusken jed a făl kăy-nəhakk tamăttant, ănn-ak dăɣ-təssəba n-asəkkufar wa jed ed kăyy-i n-ăgg-adəm, tăsisăgdăhăd iman-năk d-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Innʼ-asăn Ɣisa: «Ajăn wădden iktab dăɣ-Ăṭṭăwrăt-năwăn a-s, Măssinăɣ, innă: ‹Ăxlăkăɣ-dd dăgg-adəm dăɣ-milhaw-in›. ");
INSERT INTO taq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wădden, nəssan daɣ a-s măjrăd n-Măssinăɣ, iɣlal, wăr-itəməttəy. Ɣas kunta ăddinăt wi əlkămnen i-măjrăd-en, ixlăk-tăn-dd dăɣ-milhaw-net, ");
INSERT INTO taq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","mafăl jannem ăskafărăɣ, năkk-i ăsnăfrăn Abba, ăšmašăl-ahi-dd s-ăddunya făl-a-s innin ənneɣ-awăn: ‹Năkk Rure-s n-Măssinăɣ a ămoosăɣ.› ");
INSERT INTO taq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ămăra kunta ɣas a-wa tamašalăɣ wădden Abba-nin a dd-ifal, adiš wăr săr-i tomenăm măšan, ");
INSERT INTO taq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kunta a-wa tamašalăɣ Abba-nin a dd-ifal, adiš kud-dăɣ wăr săr-i tomenăm năkk, ămənăt s-timašalen-en-dăɣ i-ad-təlmədăm, səbbuyənăm a-s năkk, ărtayăɣ d-Abba, irtay dăr-i daɣ ənta, heeɣ-t, ihʼ-ahi.» ");
INSERT INTO taq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ăsmăgăggăyăn daɣ kăl-Ălyăhud dăɣ-arămas-net măšan, ăẓlăbbăt-dd Ɣisa dăɣ-săn, iglă. ");
INSERT INTO taq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ikka ḍarăt-a-wen asălim wa n-emăynăj n-ejănš wa n-Ɣurdəni, dăɣ-edăgg wa s-kăla dăɣ-s isalmaɣ Exya ăddinăt, izzăɣ dihen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ǝkkăn-t-dd ăddinăt ăjjootnen, jannănen: «Exya, wăr-ija tăkunt wălʼ iyyăt măšan, a-wa inna făll-ăhaləs-i-dăɣ, itbat iket-net.» ");
INSERT INTO taq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Omănăn ăddinăt ăjjootnen s-Ɣisa dăɣ-edăgg-en-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ăzzăman-wen-dăɣ ad-ărhin Lazar wa n-taɣrəmt ta n-Bitanya n-ăŋŋa-s n-Marta d-Măryăma ");
INSERT INTO taq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ta s-kăla təssənɣăl aḍutăn făll-iḍarăn n-Ɣisa təzzar, ad-tăn-timəs s-tišəkkaḍ-net. Ǝnta-i-dăɣ a-s ămăra, ărhiin ăŋŋa-s, Lazar. ");
INSERT INTO taq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ărhin ɣas, ăssawăynăt šătma-s ămašal s-Ɣisa, ənnănăt-as: «Ălɣalim, ăss-dd, emărh-năk Lazar ărhiin.» ");
INSERT INTO taq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iwwăḍ-dd ămašal Ɣisa ɣas, innă: «Turhənna ta tărmăsăt Lazar, wădden ənta a t-madăt-tawəy s-ălaxărăt, turhənna-net ta-dăɣ a madăt-tumas əssəbab făl ătwăsămɣăr Măssinăɣ, itwəsəmɣăr daɣ Rure-s.» ");
INSERT INTO taq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tărha ta ija Ɣisa i-Lazar, ənta daɣ a ija i-Marta d-wălătma-s Măryăma. ");
INSERT INTO taq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ǝjjăšăn isălan n-turhənna n-Lazar Ɣisa măšan, ăssakăy dăɣ-edăgg-ənnin-dăɣ əssin išilan təzzar, ");
INSERT INTO taq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","innă i-inəṭṭulab-net: «Ăqqəlăt-anăɣ Ălyăhudəyăt.» ");
INSERT INTO taq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ǝnnăn-as inəṭṭulab-net: «Ălɣalim, ajăn wădden a ăynayăn tattărăn kăl-Ălyăhud, ad-kăy-əkfən sămmăjori n-tihun dăɣ-teje-ten-dăɣ, ɣas ma dăɣ-s tăqqalăd?» ");
INSERT INTO taq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Innʼ-asăn Ɣisa: «Ajăn wădden măraw ăssaɣătăn d-əssin a hanen ašăl? Ere irjašăn hărwa ijă ašăl, wăr mad-ăjjărtăqqəl făl-a-s ihannăy data-s ");
INSERT INTO taq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","măšan, ăwadəm irjašăn s-ehăḍ, ad-ăjjărtăqqăl ed irjaš dăɣ-tihay.» ");
INSERT INTO taq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ija Ɣisa măjrăd-wen-dăɣ ɣas, innʼ-asăn: «Emărh-nănăɣ Lazar, iṭṭas măšan, əgleɣ i-ad-t-dd-sənkărăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ǝnnăn-as inəṭṭulab-net: «Ălɣalim, adiš kunta eḍəs ɣas a ija, illʼ-e ăṭṭăma n-ad-izzəy.» ");
INSERT INTO taq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Măjrăd wa hasăn-ija, ijʼ-asăn-t i-ad-tăn-isəlməd a-s Lazar ăba-t măšan, əbdadăn ənniyătăn-năsăn făll-eḍəs wa n-ere ilɣad eḍəs. ");
INSERT INTO taq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ijʼ-asăn Ɣisa ḍarăt-a-wen măjrăd s-ăddooben afăham-net, innʼ-asăn: «Ǝlmədăt a-s Lazar ya ăba-t, măšan, ");
INSERT INTO taq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ăddiweɣ dăɣ-təssəba-năwăn ed a-s ărhin, wăr ɣur-s t-əlleɣ, ătiwatăs a-wen i-ad-săr-i tamənăm; ămăra, ənkărăt, ăkkăt-anăɣ-t.» ");
INSERT INTO taq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iggăd-dd Tomi wa s-itawănna Didim, a-wen ălmăɣna-net: ekne, innă i-inəṭṭulab wi iyyăḍnen: «Ăglăt-anăɣ năkkăneḍ-dăɣ i-ad-nahăr d-ălɣalim-nănăɣ tamăttant.» ");
INSERT INTO taq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","A-s hin-osa Ɣisa Bitanya, ila Lazar əkkoẓ išilan dăɣ-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitanya-i dăɣ-t-ăba, wăr jere-s t-illa d-Yărussălam ar kăraḍ kelumetărăn. ");
INSERT INTO taq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ăba Lazar ɣas, osăn-dd kăl-Ălyăhud ăjjootnen Marta d-Măryăma, ad-sasmaḍăn ulhawăn-năsnăt. ");
INSERT INTO taq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Təsla Marta a-s imal-dd Ɣisa ɣas, təlkăḍ-as, a-s ija a-wen Măryăma ənta, tăqqima-hin ɣur-ehăn. ");
INSERT INTO taq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tămmoqqăs d-Ɣisa ɣas, tənnʼ-as: «Ălɣalim, əssanăɣ a-s ənnăr təlled diha-dăɣ, wăr-itiba ăŋŋa-ɣ. ");
INSERT INTO taq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Măšan hakd a-wen-dăɣ, əssanăɣ a-s kăyy a təttărăd, dăɣ-Măssinăɣ-dăɣ, ad-hak-t-ăkf.» ");
INSERT INTO taq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Innʼ-as Ɣisa: «Ăŋŋa-m a dd-inkăr dăɣ-tamăttant.» ");
INSERT INTO taq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tənnʼ-as Marta: «Ǝssanăɣ lab s-ad-dd-inkăr dăɣ-tamăttant ašăl wa ilkămăn.» ");
INSERT INTO taq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Innʼ-as Ɣisa: «Năkk a-s Wa dd-isănkarăn dăɣ-tamăttant, năkk a ihakkăn tămudre, ere săr-i omănăn-dăɣ, ad-iddar hărkuk kud-dăɣ ămmut, ");
INSERT INTO taq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ere iddarăn daɣ har săr-i omăn, wăr dăɣ-s təlkem tamăttant făw. Ak kămm Marta, təflasăd a-wen meɣ?» ");
INSERT INTO taq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tənnʼ-as Marta: «Ǝyya Ălɣalim, omanăɣ a-s kăyy a-s Ălmasex wa n-Rure-s n-Măssinăɣ s-ătwănna ilkam ad-dd-ass ăddunya.» ");
INSERT INTO taq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Təja Marta măjrăd-wen-dăɣ ɣas, təglă, təkkăs-dd wălătma-s s-takše, tənnʼ-as: «Ălɣalim ya, osă-dd, innʼ-am ad-t-in-tasəd.» ");
INSERT INTO taq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Təsla Măryăma i-a-wen ɣas, təggăd ăssaɣăt-wen-dăɣ, təkkă Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A-s ităjj a-wen-dăɣ, wăr dd-ijješ Ɣisa aɣrəm hărwa, ihʼ edăgg-wənnin-dăɣ dăɣ-dăr-s tămmoqqăs Marta, ");
INSERT INTO taq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","əllan-t daɣ imănokalăn n-kăl-Ălyăhud iyyăḍ ɣur-Măryăma dăɣ-ehăn, sasmaḍăn ulh-net. Ǝnhăyăn-tăt a-s təbdăd šik, təzjăr ɣas, əlkămăn-as ed ija ɣur-săn a-s Lazar a təkka i-ad-tălh făll-aẓəkka-net. ");
INSERT INTO taq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tăwwăḍ-in Măryăma diha t-illa Ɣisa, tənhăy-t ɣas, tărkăɣ-as, tənnʼ-as: «Emăli, əssanăɣ a-s ənnăr təlled diha-dăɣ, wăr-itiba ăŋŋa-ɣ.» ");
INSERT INTO taq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Inhăy-tăt Ɣisa hall ənta d-wi dăr-s ăddewnen, ɣas, ăsnin, əkmăn-t iman-net, ");
INSERT INTO taq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","innʼ-asăn: «Săknăt-ahi aẓəkka wa dăɣ-jăm Lazar.» Ǝnnăn-as: «Ǝyyăw, ənhəy-t.» Inhăy-t ɣas, ");
INSERT INTO taq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ilhă Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ǝnnăn iyyăḍ dăɣ-imănokalăn n-kăl-Ălyăhud: «Təmɣăre n-tărha ijʼ-et i-Lazar», ");
INSERT INTO taq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ənnăn wi iyyăḍnen: «Ǝnta-i orăn tiṭṭawen n-emədderɣəl, indăr-as ad-igdəl i-Lazar tamăttant?» ");
INSERT INTO taq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Olăsăn-t iman-net təkma, iglă ḍarăt-a-wen, ikkʼ aẓəkka wa iha Lazar iɣăšăn dăɣ-esăwăl, ihar s-tăhunt măqqoorăt. ");
INSERT INTO taq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Osă-dd Ɣisa aẓəkka ɣas, innă i-ăddinăt: «Ǝkkəsăt-in tăhunt ta hărăt aẓəkka.» Təggăd-dd Marta ta n-wălăt ma-s n-enəmmettən ăssaɣăt-wen, tənna i-Ɣisa: «Ălɣalim, Lazar ya ăru d-irkăh, ašăl-net wa s-əkkoẓ a-wa ihʼ aẓəkka.» ");
INSERT INTO taq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Innʼ-as Ɣisa: «Ajăn wădden Marta ăru d-ham-ənneɣ a-s afăl săr-i tomănăd, ad-tənhəyăd tărna n-Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ǝkkăsăn-in ăddinăt tăhunt făll-emm n-aẓəkka ɣas, ăjoẓăy Ɣisa išənnawăn, innă: «Abba, ămmoyăɣ-ak aɣăbal wa jed a-wa dăɣ-k əttărăɣ, ");
INSERT INTO taq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","əssanăɣ daɣ a-s ɣabbălăd tittar-in hărkuk măšan, ămmijrădăɣ-ak ămăra dăɣ-təssəba n-ălžămaɣăt-wa-dăɣ ibdădăn, dăɣ-təssəba n-ad-amənăn ăddinăt a-s kăyy a hi-dd-ăšmašălăn.» ");
INSERT INTO taq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Innă Ɣisa a-wen ɣas, iḍkăl emăsli-net, innă: «Lazar, əzjăr-dd!» ");
INSERT INTO taq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Izjăr-dd Lazar aẓəkka, ăqqanăn ifassăn-net d-iḍarăn-net s-isəssora, ilsă ekăršăy idəm-net. Innʼ-asăn Ɣisa ălwăqq-wen: «Arăt-t, təbḍəwăm-t d-ikăršăyăn-wi-dăɣ ittăl, təyyəm-t ad-igləw.» ");
INSERT INTO taq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Osăn-dd kăl-Ălyăhud ăjjootnen, ənhăyăn a-wa ija Ɣisa ɣur-Măryăma ɣas, omănăn săr-s ");
INSERT INTO taq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","măšan, əglăn iyyăḍ dăɣ-săn, osăn kăl-faris, əllăɣen-asăn a-wa ija Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ǝžžəmmăɣăn-dd imănokalăn n-kăl-tikutawen d-kăl-faris d-ălžămaɣăt wa n-kăl-Sinhidrin-i iɣattăsăn ăššăreɣa, ănmănnăn: «Ǝndek ăddăbara? Wa ăwadəm, əjjətăn fălla-năɣ ijităn-net wi ăssuksăḍnen! ");
INSERT INTO taq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ǝlmədăt a-s afăl t-noyya s-əmmək-wa-dăɣ, ad-săr-s amənăn ăddinăt iket-năsăn. Afăl ămoos a-wen a ijan, ad-ărẓən kăl-Roma-i hanăɣ-ăsităɣmărnen ehăn n-ămudd-nănăɣ wa šăddijăn, ăttăɣtăɣăn ăkall-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iggăd-dd dăɣ-săn Qayăf-i s-ənta a ăminakălăn făll-kăl-tikutawen awătay-wen-dăɣ, innă: «Ijmaḍ-t ăššăk a-s wăr t-illa a təjrahăm iket-dăɣ-năwăn, ");
INSERT INTO taq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ajăn wăr hənnəyăm a-s ufʼ-awăn, ad-ămmăt ăwadəm iyyăn dăɣ-təssəba n-tamətte uhən ad-tămmăt tamətte iket-net.» ");
INSERT INTO taq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Măjrăd-wen-dăɣ ija Qayăf, wădden a dd-ifalăn tayətte-net măšan, šămad ənta a ăminakălăn făll-kăl-tikutawen awătay-wen-dăɣ, ikfʼ-e Măssinăɣ măjrăd hin-ăssawăḍ tamətte n-a-s ilkam ad-ămmăt Ɣisa, dăɣ-təssəba n-tamətte ta n-Iṣrayil iket-net. ");
INSERT INTO taq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Təzzar daɣ wădden kăl-Iṣrayil ɣas a-s mad-ămmăt, ad-ămmăt i-ad-dd-isədəw aratăn n-Măssinăɣ wi əmmăhăšnen jer-ikallăn, umasăn tiyyăt taɣəssa. ");
INSERT INTO taq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ăɣtăsăn ɣur-ašăl-wen-dăɣ n-a-s wăr-e sunfən făw wăr jen iman-net. ");
INSERT INTO taq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iɣtăf ənta-dăɣ ɣur-ašăl-wen-dăɣ i-răjjoš dăɣ-edăgg t-hannăyăn kăl-Ălyăhud. Ifăl ăkall-wen-dăɣ hăn, ikkă teje ta tohăẓăt tanəẓruft, izzăɣ ənta d-inəṭṭulab-net dăɣ-aɣrəm s-isəm-net Ifɣahim. ");
INSERT INTO taq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ohăẓ-dd ămudd n-kăl-Ălyăhud wa n-Faṣka ɣas, ăhhujjăjăn-dd ăddinăt ăjjootnen s-Yărussălam i-ad-šəšdəjăn iman-năsăn dat-ămudd-en-dăɣ, ");
INSERT INTO taq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ad-tammăɣăn iməhhujjaj iket-năsăn i-Ɣisa, tinmənnin jer-iman-năsăn dăɣ-ehăn n-ămudd wa măqqărăn: «Ak, tordam a-s ihăl a dd-ăkk ămudd meɣ?» ");
INSERT INTO taq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A-s jănnen a-wen-dăɣ, omarăn imănokalăn n-kăl-tikutawen d-kăl-faris s-ere ilmădăn diha t-illa Ɣisa iket-net, isăɣdăret-t i-ad-ăttărmăs. ");
INSERT INTO taq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ašăl wa s-săḍis dat-ămudd wa n-Faṣka, ikkă Ɣisa taɣrəmt ta n-Bitanya dăɣ-izzăɣ Lazar wa dd-issənkăr jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Təssəskăr-dd Marta imənsiwăn dat-Ɣisa, ăniɣăyma d-Lazar d-imăjarăn wi iyyăḍnen. ");
INSERT INTO taq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Təḍkăl Măryăma ḍarăt-a-wen tăẓune n-lităr n-aḍutăn lanen ălqim wăr-iqqer hărăt, ad-tăn-sanɣal făll-iḍarăn n-Ɣisa, timəs-tăn s-tišəkkaḍ-net. Ăbɣănɣălăn aḍutăn dăɣ-ehăn-ənnin-dăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iggăd-dd iyyăn dăɣ-inəṭṭulab n-Ɣisa wa s-isəm-net Yăhudəs wa n-Isxaryut-i t-e-isəssăɣdărăn, innă: ");
INSERT INTO taq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Mafăl aḍutăn-wi-dăɣ wăr hin-ənšen kăraḍăt timaḍ n-ărriyal n-aẓrəf ămoosnen takute i-tilăqqiwen.» ");
INSERT INTO taq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Innă a-wen wădden dăɣ-a-s innin oẓar dăɣ-a əjrăwnăt tilăqqiwen, ănn-ak făl-a-s innin emăkrăḍ a ămoos, ənta a-s ănaẓraf n-taggayt ta n-inalkimăn n-Ɣisa, a ătwăjjăn dăɣ-əssəndoqq wa n-aẓrəf-dăɣ, ad-dăr-s in-išləy. ");
INSERT INTO taq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Innʼ-asăn Ɣisa: «Ăkfăt-tăt ălɣafyăt, a-wa təja, təjʼ-e dăɣ-təssəba n-ašăl wa d-mad-əjjəšăɣ aẓəkka. ");
INSERT INTO taq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tilăqqiwen ya, əllanăt ɣur-wăn hărkuk măšan năkk, ilkam ad-kăwăn-ăflăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ǝslăn kăl-Ălyăhud ăjjootnen a-s iha Ɣisa taɣrəmt ta n-Bitanya ɣas, fălăn-dd Yărussălam, əkkăn-t-dd măšan, wădden ənta ɣas a-s otasăn ahănay-net, ərhan daɣ, ad-ənhəyăn Lazar wa dd-issənkăr jer-inəmmuttan, ");
INSERT INTO taq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ăɣtăsăn imănokalăn n-kăl-tikutawen s-ad-əjən iman n-Lazar ənta-dăɣ ");
INSERT INTO taq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ed hannăyăn a-s, dăɣ-təssəba n-asənkar wa t-dd-ija Ɣisa jer-inəmmuttan a făl, taqqălăn imănokalăn n-kăl-Ălyăhud ăjjootnen ḍarăt kăl-tikutawen, timənən s-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ăffăw ɣas, təslă tamətte ta tăjjet dd-təkkăt ămudd a-s Ɣisa ikkă-dd Yărussălam. ");
INSERT INTO taq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ǝjjăšăn-tăt isălan ɣas, ad-dd-ɣattăsăn ăddinăt iləktan n-tišday, lakkăḍăn-as, săɣăren s-afălla: «Ozana! Ija Măssinăɣ ălbăraka dăɣ-ămănokal wa n-Iṣrayil dd-osăn făll-isəm n-Emăli.» ");
INSERT INTO taq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ijrăw Ɣisa ăẓa iyyăn dăɣ-zăbo, inăy-t, ămoos a-wen a ăssitbătăn a-wa iktăbăn dăɣ-əlkəttab n-Măssinăɣ a-s innă: ");
INSERT INTO taq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Yărussălam ta dăyăt făll-taḍaɣt ta n-Sayon, wăr tărmeɣăd, ənhəy ɣas ămănokal-năm imal-dd inay ara n-tešeḍt.» ");
INSERT INTO taq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ašăl wa d-jăn hărătăn-winnin-dăɣ, wăr tăn-əfhemăn inəṭṭulab n-Ɣisa măšan, ašăl wa d-ijjăš təmɣăre n-ălxurmăt-net, əktăn-dd a-s ənta-en-dăɣ a făl əktăbăn ănnăbităn hărătăn-win-dăɣ, ămešăl-tăn daɣ. ");
INSERT INTO taq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ašăl-wen-dăɣ, tăssoɣăl tamətte iket-net a-wa ijă Ɣisa ed, tăjjəyha a-s dd-issənkăr Lazar jer-inəmmuttan, ikkăs-t-dd dăɣ-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Təlkăḍ-dd tamətte-en iket-net i-Ɣisa dăɣ-təssəba n-iji n-Măssinăɣ wa-dăɣ s-təslă ijʼ-e. ");
INSERT INTO taq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ǝnhăyăn kăl-faris a-wen ɣas, ănmănnăn jer-iman-năsăn: «Tənhăyăm ămăra a-s a-wa wădden a dd-nəkka d-hărăt, tamətte iket-dăɣ-net a ḍara-s tošalăt.» ");
INSERT INTO taq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Osăn-dd hărăt dăɣ-kăl-Ălyunan s-ijraẓ ăddin wa n-kăl-Ălyăhud, əkkan-dd daw-ămudd-i-dăɣ i-ad-ăɣbədăn Măssinăɣ dăɣ-Yărussălam, ");
INSERT INTO taq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","əjrăwăn ănăṭṭalib wa s-isəm-net Fəlibb wa n-taɣrəmt ta n-Băṭsăyda ta n-Galila, ənnăn-as: «Ăhaləs, nărha ad-nənhəy Ɣisa.» ");
INSERT INTO taq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Iglă Fəlibb, ija isălan dăɣ-Idris, ăddewăn issənăn-essăn s-Ɣisa, əllăɣen-as. ");
INSERT INTO taq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ǝwwăḍăn-dd Ɣisa ɣas, innʼ-asăn: «Ăssaɣăt wa dăɣ-mad-ijjəš Ăgg-ăgg-adəm ălxurmăt-net, osă-dd. ");
INSERT INTO taq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ălleɣeɣ-awăn s-tidət tădduuttet a-s a təkkăs temătăwt n-ălkăma wăr tənbel dăɣ-ăkall tămmăt, ad-tămoos tiyyăt tablalt ɣas măšan, afăl tənbăl dăɣ-ăkall har tămmut, a dd-tarəw tiblalen ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ere wa wărăn itəttăr ar əmmək s-ijmăr iman-net dăɣ-ăddunya-ta-dăɣ, ad-ifut dăɣ-ălžănnăt, măšan, ăwadəm wa irḍăn ăfota dăɣ-iman-net, dăɣ-ăddunya-ta-dăɣ, dăɣ-ăddimmăt-nin, ad-ijrəw tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ere dăɣ-wăn irhăn tumast n-ănaxdim-in-dăɣ adiš, ilkəmet-ahi făl-a-s, năkk edăgg wa dăɣ-mad-əzzăɣăɣ, ənta daɣ a dăɣ-mad-izzăɣ ănaxdim-in, ijrəw semɣar ɣur-Abba.» ");
INSERT INTO taq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Ărɣan iman-in, ărɣan ămăra-dăɣ, ak ma he-ănnăɣ făw? Abba, ăɣləs-ahi dăɣ-ăssaɣăt-wa-dăɣ? Făw, năkk, əssanăɣ a-s təssəba n-ăssaɣăt-wa-dăɣ a făl dd-ămešălăɣ. ");
INSERT INTO taq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abba, səkən ăddinăt təmɣăre n-ălxurmăt n-isəm-năk.» Ifăl-dd emăsli ălwăqq-wen-dăɣ išənnawăn innăn: «Isəm-in, əssəmɣărăɣ-t, ad-t-aləsăɣ daɣ asəmɣar.» ");
INSERT INTO taq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Təslă tamətte ta t-təllăt dihen i-emăsli-ənnin-dăɣ ɣas, innă aɣil-net iyyăn: «Ak sallăm i-ejjaj wa ijjăjăn?» Inna aɣil wa iyyăḍăn: «A-di wădden ejjaj, ănjălos a has-imməjrădăn.» ");
INSERT INTO taq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Innʼ-asăn Ɣisa daɣ: «Emăsli wa s-iket has-təslăm, wădden təssəba-nin a dăɣ-ija, təssəba-năwăn kăwăneḍ a dăɣ-ija. ");
INSERT INTO taq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ǝlmədăt a-s ămăra-dăɣ, ad-mad-tətwəšărrăɣ ăddunya, itwəstăɣ daɣ ămănokal-net Iblis, ");
INSERT INTO taq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","năkk daɣ, afăl əmməḍkălăɣ, ad-dd-ăɣrăɣ s-iman-in ăddinăt iket-năsăn.» ");
INSERT INTO taq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Innă a-wen-dăɣ i-ad-tăn-isəlməd əmmək wa s-mad-ămmăt. ");
INSERT INTO taq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tənnʼ-as tamətte: «Ajăn wădden năɣra dăɣ-Ăṭṭăwrăt a-s Ălmasex, wăr-e ămmăt, iɣlal, adiš ma kăy-isawănnen: ‹Ăgg-ăgg-adəm, ad-ămmăḍkăl?› Wa Ăgg-ăgg-adəm făl wăr nəssen madăn-ămmăḍkăl, mi ămoos?» ");
INSERT INTO taq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Innʼ-asăn Ɣisa: «Ănnur, wăr has-in-ăqqima ar a ənḍărrăn illʼ-e jere-wăn, ăsimătărăɣ-kăwăn d-ad-has-təlkəmăm i-ad-wăr kăwăn-ɣăddărnet tihay făl-a-s, ere irjašăn dăɣ-tihay, wăr-issen e-s ihăl. ");
INSERT INTO taq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iket-di tăẓẓegăẓăm a-wen, a ikkăs ănnur illʼ-e jere-wăn, amənăt săr-s i-ad-tumasăm dăgg-ănnur.» Innă Ɣisa a-wen ɣas, ifăl tamətte, iffăr. ");
INSERT INTO taq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ija Ɣisa data-săn ijităn n-Măssinăɣ-i-dăɣ ăjjootnen măšan, unjăyăn săr-s omănăn, ");
INSERT INTO taq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ămoos a-wen a ăssiitbătăn măjrăd wa ikfă Măssinăɣ ănnăbi Saya a-s innă dăɣ-əlkəttab n-Măssinăɣ: «Emăli, mi omănăn s-a-wa nənna? Mi s-dd-tănfalăl tărna n-ăfuss n-Emăli?» ");
INSERT INTO taq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ăqqurăn ulhawăn n-kăl-Iṣrayil făl-a-s, innă ănnăbi Saya daɣ: ");
INSERT INTO taq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Ăsdărɣăl-tăn Măssinăɣ, ăsɣăr ulhawăn-năsăn i-ad-wăr hənnəyăn s-tiṭṭawen-năsăn, əjrăhăn hărăt s-ulhawăn-năsăn, utabăn i-ad-tăn-izuzəy Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Măjrăd-wen-dăɣ, ijʼ-e ănnăbi Saya ăzzăman wa d-has-dd-ănfalăl ălxurmăt n-Ɣisa, ădwănnăt dăɣ-isălan-net. ");
INSERT INTO taq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hakd a-wen-dăɣ, omănăn imizărăn n-kăl-Ălyăhud ăjjootnen s-Ɣisa măšan, təgdal-asăn tuksəḍa n-kăl-faris ad-sətbətăn immun-năsăn, făl-a-s ăksuḍăn ad-tăn-əkkəsăn dăɣ-ihănan n-ăddin-năsăn, ");
INSERT INTO taq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ăssofăn təmmal ta dd-fălăt dăgg-adəm uhən ta n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iḍkăl Ɣisa emăsli-net, innă: «Ere săr-i omănăn-dăɣ, ilmədet a-s wădden năkk a-s omăn, Măssinăɣ-i hi-dd-ăšmašălăn a-s omăn, ");
INSERT INTO taq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ere daɣ wa hi-inhăyăn, ilmədet a-s Măssinăɣ-i hi-dd-ăšmašălăn a inhăy. ");
INSERT INTO taq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Năkk a-s ănnur, ămešălăɣ-dd s-ăddunya dăɣ-təssəba n-ad-wăr-itəzzăɣ făw ere săr-i omanăn dăɣ-tihay, ");
INSERT INTO taq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ere islăn i-măjrăd-in wăr t-iṭṭef, wădden năkk a t-madăn-išrăɣ făl-a-s, wăr dd-ămešălăɣ i-ad-əšrăɣăɣ ăddunya, ănn-ak, ămešălăɣ-dd i-ad-tăt-ăɣləsăɣ. ");
INSERT INTO taq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ere săr-i unjăyăn, unjăy s-măjrăd-in, măjrăd-en-dăɣ a t-e-išrăɣăn ašăl wa ilkămăn ");
INSERT INTO taq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","făl-a-s, măjrăd wa jeɣ iket-net, wădden a dd-əkkasăɣ dăɣ-eɣăf-in ɣas, Abba-nin ənta iman-net-i hi-dd-ăšmašălăn a hi-ikfăn turhajăt n-ad-ănnăɣ a-wa hi-inna, ăjăɣ daɣ isălan-net i-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ǝssanăɣ daɣ a-s e d t-illăm ăwadəm ilkamăn i-a-wa innă, ad-ijrəw tămudre ta tăɣlălăt. A-wen-dăɣ a făl năkk, a-wa jănneɣ iket-net, jănneɣ-tăn s-əmmək wa s-hi-tăn-innă Abba.» ");
INSERT INTO taq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ehăḍ wa n-dat-wa n-ămudd wa n-Faṣka, ilmăd Ɣisa s-ăssaɣăt n-ajmuḍ-net i-ăddunya i-ad-akk Abba, iwwăḍ-dd. Ehăḍ-en-dăɣ, issəmdă-dd təmɣăre n-tărha-net s-inəṭṭulab-net, issəknʼ-en tărha tokăyăt ta tăn-isakna hak ašăl a ija a-wa-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hărwa tamănsawăn a-s ija Iblis dăɣ-ulh n-Yăhudəs Ăgg Simyon wa n-Isxaryut erk ənniyăt wa n-ad-isăɣdăr Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Dăɣ-təlluləya-net, issan Ɣisa a-s wăr t-illa a-s wădden ijʼ-e Abba-net dăɣ-ifassăn-net, issan daɣ a-s Măssinăɣ-i t-dd-ăšmašălăn, ənta a iqqal. ");
INSERT INTO taq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ǝssəmdăn tetăte ɣas, ibdăd Ɣisa, ikkăs emăls-net, iḍkăl-dd ekăršăy iyyăn, ijbăs săr-s, ");
INSERT INTO taq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ijă ḍarăt-a-wen aman dăɣ-taẓăwat, ad-isarad iḍarăn n-inəṭṭulab-net, itiməs-tăn s-ekăršăy wa s-ijbăs. ");
INSERT INTO taq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iwwăḍ-dd ăssaɣăt wa n-asirəd n-iḍarăn n-Simyon Bəṭrus ɣas, iggăd inna i-Ɣisa: «Xăša Ălɣalim! Năkk a iwar asirəd n-iḍarăn-năk wădden kăyy.» ");
INSERT INTO taq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Innʼ-as Ɣisa: «A-wa hi-išlăn, wăr mad-təjrăhăd ălmăɣna-net ămăra-dăɣ măšan, ilkam ad-t-təfhəmăd.» ");
INSERT INTO taq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Innʼ-as Bəṭrus ălwăqq-wen: «Kăla kăla Ălɣalim, năkk lab wăr-ilkem ad-ărḍeɣ tăsserădăd iḍarăn-in.» Innʼ-as Ɣisa: «Afăl wăr-ăsserădăɣ iḍarăn-năk, wăr hak t-illa ad-nahăr.» ");
INSERT INTO taq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Innă Simyon Bəṭrus: «Adiš Ălɣalim, wăr təbdedăd ɣur-iḍarăn-in ɣas, sirəd daɣ eɣăf-in hakd ifassăn-in.» ");
INSERT INTO taq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Innʼ-as Ɣisa: «Wădden ere ăsserădăn telămăkt-net, wăr-ămɣatăr s-ad-aləs asirəd daɣ kunta wădden iḍarăn-net ed, šăddij iket-net, kăwăneḍ, a-s təkkăsăm iyyăn dăɣ-wăn, šăddiijăm.» ");
INSERT INTO taq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Măjrăd-wen-dăɣ, ijʼ-e Ɣisa ed, issan ere wa t-madăn-isəssăɣdăr. Dăɣ-təssəba n-a-wen-dăɣ a făl hasăn-innă iyyăn dăɣ-săn, wăr šăddij. ");
INSERT INTO taq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ăsserăd iḍarăn-năsăn ɣas, ilsʼ emăls-net, iqqăl-dd, ăqqima dăɣ-edăgg wa n-imənsiwăn, innʼ-asăn: «Ak, kăwăneḍ, təfhamăm a-wa s-iket hawăn-t-jeɣ meɣ? ");
INSERT INTO taq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wădden a hi-jannem: ‹Ălɣalim d-Emăli,› ikna ed a-wen-dăɣ a ămoosăɣ ");
INSERT INTO taq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ɣas, šămad năkk-i n-Emăli d-ălɣalim, ăsserădăɣ iḍarăn-năwăn, adiš kăwăneḍ-dăɣ, iwar-kăwăn ad-tinməsiridăm iḍarăn jer-iman-năwăn; ");
INSERT INTO taq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","əssəknăɣ-kăwăn ălmital he-tinməjjim jer-iman-năwăn s-əmmək-wa-dăɣ s-hawăn-t-jeɣ. ");
INSERT INTO taq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ălleɣeɣ-awăn s-tidət tădduuttet a-s wăr t-illa akli ojărăn măssi-s, wăla ănămmašal ojărăn ere wa t-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tənḍəḍ-awăn kunta təssanăm s-hărătăn-wi-dăɣ, ad-tăn-tamašalăm. ");
INSERT INTO taq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","A-wa hawăn-janneɣ, wădden iket-năwăn a făl t-janneɣ făl-a-s năkk, əzzayăɣ inəṭṭulab-in wi ăsnăfrănăɣ, ămăra, măjrăd n-Măssinăɣ a madăn-isətbət a-wen ed, iktab dăɣ-s a-s: ‹Wa dăr-i ohărăn ăkoss, ənta a-s ašănjo-nin.› ");
INSERT INTO taq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ǝkkasăɣ-kăwăn dăɣ-taɣdărt n-hărătăn-wi-dăɣ hărwa wăr-ətbetăn dăɣ-təssəba n-a-s afăl jăn, ad-tamənăm a-s: ‹Năkk, ăɣlalăɣ›. ");
INSERT INTO taq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ere ăsbărrăkăn ere hin-ăsimašălăɣ, a ămoos-dăɣ, năkk a ăsbărrăk, ere daɣ wa hi-ăsbărrăkăn, Wa hi-dd-ăšmašălăn a ăsbărrăk.» ");
INSERT INTO taq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","A-s issəmda Ɣisa măjrăd-wa-dăɣ, əkman-t iman-net, innʼ-asăn: «Ălleɣeɣ-awăn s-tidət tădduuttet a-s iyyăn dăɣ-wăn a hi-madăn-isəssăɣdăr.» ");
INSERT INTO taq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ǝslăn inəṭṭulab i-a-wen ɣas, ad-tinməkyidăn, tinməsəstinăn d-ere wa s-iha ti-net. ");
INSERT INTO taq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A-s ităjj a-wen-dăɣ, ăsiɣămăr ănăṭṭalib wa ikna Ɣisa tărha edes-has, ");
INSERT INTO taq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","inẓăj-as Simyon Bəṭrus tiṭṭ, innʼ-as, ad-isəstən Ɣisa d-ere wa s-iha ti-net. ");
INSERT INTO taq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ăsmătăktăk ănăṭṭalib-en i-Ɣisa, innʼ-as: «Ălɣalim, mi kăy-madăn-isəssăɣdăr?» ");
INSERT INTO taq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Innʼ-as Ɣisa: «Ere wa s-mad-səlmăɣăɣ afărs n-tajəlla dăɣ-aḍrəẓ, ənta-en-dăɣ a hi-madăn-isəssăɣdăr.» Issəlmăɣ Ɣisa afărs n-tajəlla dăɣ-aḍrəẓ, ikfʼ-e Yăhudəs wa s-itawănna Isxaryut n-ăgg Simyon. ");
INSERT INTO taq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Diha-dăɣ d-irmăs Yăhudəs afărs n-tajəlla-ənnin-dăɣ, ad-innăhăḍ Iblis dăɣ-ulh-net, innʼ-as Ɣisa ălwăqq-wen: «Yăhudəs! A-wa tăjjăd, ăjʼ-e šik.» ");
INSERT INTO taq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ijă Ɣisa i-Yăhudəs măjrăd-wen-dăɣ măšan, wăr t-illa dăɣ-inəṭṭulab-net wi iyyăḍnen ăsiiɣămărnen dăɣ-isəftaɣ i ifhamăn a-wa innă, ");
INSERT INTO taq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ăɣelăn a has-innă: «Žănš-dd a-wa s-nămiɣatăr i-ămudd wa n-Faṣka» meɣ «Ăkf hărăt tilăqqiwen» făl-a-s, ənta a-s ănaẓraf-năsăn. ");
INSERT INTO taq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Irmăs-dd Yăhudəs afărs n-tajəlla wa has-dd-iẓẓăl Ɣisa ɣas, izjăr. Isălan-wi-dăɣ, ehăḍ a-s tajjăn. ");
INSERT INTO taq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Izjăr Yăhudəs ɣas, innă Ɣisa i-inəṭṭulab-net: «Ămăra-dăɣ ad-mad-itwəsəmɣăr Ăgg-ăgg-adəm, itwəsəmɣăr daɣ Măssinăɣ dăɣ-təssəba-net, ");
INSERT INTO taq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ăkf Ăgg-ăgg-adəm ălxurmăt ɣur-iman-net, ăkfʼ-as-t daɣ šik. ");
INSERT INTO taq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ilyaḍăn-in, wăr-e ăhajăɣ əlleɣ jere-wăn, əssanăɣ a-s ilkam ad-hi-təmmăɣăm măšan, ənneɣ-awăn a-wa s-kăla tăn-ənneɣ i-kăl-Ălyăhud wi iyyăḍnen: ‹Edăgg wa əkkeɣ, wăr mad-tudabem aggaḍ-net›. ");
INSERT INTO taq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ămăra, ənta-da fărəḍ wa ăynayăn əfrăḍăɣ fălla-wăn: ‹Nəməjjăt jer-iman-năwăn anmărh šund wa hawăn-jeɣ, nəmărhăt jer-iman-năwăn, ");
INSERT INTO taq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","anmărh jer-iman-năwăn en-dăɣ a he-isəlmədăn ăddinăt a-s tidət-dăɣ a-s inəṭṭulab-in a tămoosăm.› » ");
INSERT INTO taq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Issəmdă Ɣisa măjrăd-wen-dăɣ ɣas, iggăd-dd Simyon Bəṭrus, innă: «Ălɣalim, əndek siha s-təkked?» Innʼ-as Ɣisa: «Edăgg wa əkkeɣ, wăr tăddobed ad-hi-săr-s təlkəmăd ămăra-dăɣ măšan, ilkam dăɣ-k ad-hi-dd-tawəḍăd dăɣ-s.» ");
INSERT INTO taq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Innʼ-as Bəṭrus: «Ălɣalim, mafăl wăr-ăddobeɣ alkum-hak ămăra-dăɣ? Ăddobeɣ-t, năkk, ăsidăwăɣ wăla i-tamăttant dăɣ-təssəba-năk.» ");
INSERT INTO taq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Innʼ-as Ɣisa: «Wădden tənned tăsidăwăd wăla i-tamăttant dăɣ-təssəba-nin? Ikna măšan, ăsidătteɣ-ak a-s, wăr-e iwət ekăz ăɣora wăr hi-tăkkuddălăd har kăraḍ ihăndăggan.» ");
INSERT INTO taq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Innʼ-asăn Ɣisa ḍarăt-a-wen: «Wăr rammăɣnet ulhawăn-năwăn, amənăt s-Măssinăɣ, amənăt săr-i, ");
INSERT INTO taq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ehăn n-Abba-nin, han-t idăggan ăjjootnen, ənnăr wăr-itbet a-wen, wăr hawăn-jənneɣ əgleɣ i-ad-hawăn-səmməjnuɣ edăgg, ");
INSERT INTO taq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","afăl əgleɣ har hawăn-ăsmăjneɣ edăgg, ad-kăwăn-dd-ăqqəlăɣ, əḍkəlăɣ-kăwăn, təmləm diha t-əlleɣ. ");
INSERT INTO taq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Edăgg daɣ wa əkkeɣ, təssanăm tabarăt-net.» ");
INSERT INTO taq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Iggăd-dd ănăṭṭalib wa s-isəm-net Tomi, innʼ-as: «Ălɣalim, năkkăneḍ lab, wăr nəssen siha s-təkked, əndek əmmək wa s-mad-nəlməd tabarăt-net?» ");
INSERT INTO taq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Innʼ-as Ɣisa: «Năkk a-s tabarăt, năkk a-s tidət, năkk daɣ a-s tămudre, wăr t-illa făw ere ăddooben aggaḍ n-Abba ar s-ad-hi-ija əssəbab n-a-wen. ");
INSERT INTO taq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Šămad daɣ năkk təzzayăm-ahi, ad-təzzəyăm Abba-nin, šămad təzzayăm-t, adiš, tənhăyăm-t.» ");
INSERT INTO taq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iggăd-dd wa s-isəm-net Fəlibb, innʼ-as: «Ălɣalim, səkən-anăɣ ɣas Abba, igdăh-anăɣ a-wen-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Innʼ-as Ɣisa: «Ɣas Fəlibb, a-wa-dăɣ jeɣ iket-net ărtayăɣ dăr-wăn, wăr hi-təzzeyăd? Wa hi-inhăyăn, inhay Abba, ɣas əndek əmmək wa s-jănned: ‹săkən-anăɣ Abba›. ");
INSERT INTO taq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ajăn wăr tomenăd a-s năkk ărtayăɣ d-Abba, irtay dăr-i daɣ ənta, heeɣ-t, ihʼ-ahi? A-wen-dăɣ a făl iməjridăn wi hawăn-tăjjăɣ, wădden a dd-əkkasăɣ dăɣ-eɣăf-in ɣas, Abba-i dăr-i irtăyăn a ămoosăn əssəbab n-ijităn wi tamašalăɣ iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Amənăt a-s năkk ărtayăɣ d-Abba, irtay dăr-i daɣ ənta, heeɣ-t, ihʼ-ahi. Kunta daɣ wăr tomenăm s-măjrăd-in, amənăt bănnan s-ijităn-wi tamašalăɣ. ");
INSERT INTO taq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ere săr-i omănăn-dăɣ, ad-ăj ənta-dăɣ ijităn-wi jeɣ, ăj făw-i tăn-əknanen mijraw ed năkk, əkkeɣ Abba. ");
INSERT INTO taq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A-wen-dăɣ a făl a təttărăm-dăɣ s-isəm-in, ad-t-ăjăɣ i-ad-ijrəw Abba ălxurmăt dăɣ-təssəba n-Rure-s. ");
INSERT INTO taq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","A təttărăm-dăɣ s-isəm-in, ad-hawăn-t-ăjăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Kunta tidət-dăɣ a-s tărham-ahi adiš, əṭṭəfăt fărəḍăn-in, ");
INSERT INTO taq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ad-hawăn-ădəlăɣ Abba i-ad-kăwăn-ăkf ănabdid iyyăn ɣur-wăn e-illan hărkuk, ");
INSERT INTO taq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ənta a-s Unfas wa s-tidət ɣas a t-dd-zajjărăt, wăr tăddoobăt ăddunya ad-t-tăqbəl făl-a-s wăr tăddobăt ahănay-net wăla muzəyăt-net măšan, kăwăneḍ, təzzayăm-t ed ăherăj dăr-wăn, izzaɣ daɣ dăɣ-ulhawăn-năwăn. ");
INSERT INTO taq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Wăr kăwăn-mad-ăyyăɣ tăjohălăm, ad-kăwăn-dd-ăqqəlăɣ, ");
INSERT INTO taq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ăqqim-in a ənḍărrăn i-ad-ăbas hi-hannăy ăddunya măšan kăwăneḍ, a hi-hannăyăm făl-a-s, əddarăɣ, təddarăm. ");
INSERT INTO taq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ašăl-wen-dăɣ ad-mad-təlmədăm a-s năkk ărtayăɣ d-Abba, tărtayăm dăr-i kăwăneḍ, ărtayăɣ dăr-wăn daɣ năkk. ");
INSERT INTO taq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ere wa iknăn uḍəf n-fărəḍăn-in, ənta a-s emărh-in, ere daɣ wa hi-irhăn, ad-t-ărh Abba-nin, ărhăɣ-t năkk-dăɣ, sənnəfiləlăɣ-as-dd daɣ iman-in.» ");
INSERT INTO taq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Innʼ-as ănăṭṭalib wa s-isəm-net Hudd iẓleyăn d-Yăhudəs wa n-Isxaryut: «Ălɣalim, əndek əmmək wa s-mad-hanăɣ-dd-sənnəfiləlăd iman-năk wăr tăn-dd-tăsnăfalălăd i-ăddunya?» ");
INSERT INTO taq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Innʼ-as Ɣisa: «Ere hi-irhan, ad-agəẓ măjrăd-in, dihen, ad-t-ărh Abba-nin, nidaw-dd săr-s, nəzzăɣ ɣur-s. ");
INSERT INTO taq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ere wa hi-wărăn-irha, wăr mad-iṭṭəf măjrăd-in. Măjrăd wa s-təslăm ɣur-i, wădden a dd-əkkasăɣ dăɣ-eɣăf-in ɣas, Abba-nin-i hi-dd-ăšmašălăn ahi-ikfăn turhajăt n-tənna-net. ");
INSERT INTO taq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ɣas, əkkasăɣ-kăwăn dăɣ-taɣdărt hărwa əlleɣ jere-wăn, ");
INSERT INTO taq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ănabdid daɣ wa s-hawăn-ənneɣ, a t-ămoosăn Unfas Šăddijăn, ad-hawăn-t-dd-isəssiwəy Abba s-isəm-in, afăl hawăn-t-dd-ăssawăy, ad-kăwăn-isăɣăr hărăt iket-net, isəktəw-kăwăn-dd a-wa hawăn-ənneɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ămăra, oyyeɣ ɣur-wăn ălxer, ălxer daɣ wa s-năkk ɣas a t-ihakkăn a ɣur-wăn oyyeɣ ed năkk, isuf-wi hawăn-tăjjăɣ, wăr-olehăn d-wi hawăn-tăjj ăddunya, wăr tăšăwwašnet ulhawăn-năwăn, wăr rămmăɣăt. ");
INSERT INTO taq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Wădden, sallăm-ahi a-s hawăn-ənneɣ: ‹Ǝgleɣ dăɣ-təssəba n-ad-kăwăn-dd-ăqqəlăɣ›, ɣas ənnăr hi-tărham, ijrəẓ-awăn a-wa hawăn-ənneɣ ed Abba-i əkkeɣ, ojăr-ahi. ");
INSERT INTO taq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hărătăn-wi-dăɣ, janneɣ-awăn-tăn ămăra-dăɣ i-ad-kăwăn-əkkəsăɣ dăɣ-taɣdărt hărwa wăr jen, dihen afăl jăn, ad-tamənăm săr-i. ");
INSERT INTO taq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Igdăh dăɣ-măjrăd diha-dăɣ ămăra făl-a-s, Iblis-i n-ămănokal n-ăddunya, imal-dd. Ǝlmədăt a-s wăr făll-i ila tărna ");
INSERT INTO taq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","măšan, ărheɣ ad-təlməd ăddunya a-s năkk ărheɣ Abba, wăr təmišilăɣ daɣ ɣas ar erhet-net. Ǝnkărăt ămăra, ăflăt-anăɣ edăgg-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Fălăn dihen ɣas, innʼ-asăn Ɣisa: «Năkk a-s ahəšk n-lăɣnăb wa n-tidət, Abba-nin a-s ănăsdamu. ");
INSERT INTO taq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kăwăneḍ a-s iləktan n-ahəšk, e d t-illăm elăkăt dăɣ-i irmamăn wărăn itirəw, ad-t-in-iɣtəs Abba-nin, elăkăt daɣ iket-net itirəwăn aratăn, ad-hin-isrəmsərəm ileḍan-net, išəšdəj-t i-ad-dd-arəw aratăn s-əjut. ");
INSERT INTO taq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɣur-ămăra-dăɣ, əlmədăt a-s šăddijăm dăɣ-təssəba n-asəssăɣăr wa kăwăn-jeɣ. ");
INSERT INTO taq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","A-wen-dăɣ a făl ɣaymăt tărtayăm dăr-i s-əmmək wa s-dăr-wăn ărtayăɣ. Wăr t-illa elăkăt ăddooben tiirwe d-iman-net afăl wăr-irmem d-tafăja, əmmək-wen-dăɣ daɣ a-s wăr t-illa a iha ărramăt s-tăddobem amišəl-net i-Măssinăɣ ar s-ad-dăr-i tărtayăm. ");
INSERT INTO taq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ăssiilmădăɣ-kăwăn a-s năkk a-s tafăja n-ahəšk n-lăɣnăb, kăwăneḍ a-s iləktan-net. Ere wa dăr-i irtayăn, ărtayăɣ dăr-s năkk-dăɣ, ad-ămašăl i-Măssinăɣ a iha ărramăt făl-a-s, wăr t-illa a-s tăddobem iji-net wăla năkk. ");
INSERT INTO taq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ere dăr-i wărăn irtey iket-net, ad-hin-itwăɣtəs, itwəjăr-in šund elăkăt ăqqurăn s-afăl hin-ătwăjăr dăɣ-efew, ad-ărɣ s-iyyăt măšan, ");
INSERT INTO taq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","afăl năkk a ihan inəzjam-năwăn, ad-dăr-i tărtayăm, tamašalăm măjrăd-in, a təttărăm dăɣ-Măssinăɣ-dăɣ, ad-hawăn-t-ăkf. ");
INSERT INTO taq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Afăl inəṭṭulab tamašalnen a iha ărramăt i-Măssinăɣ a tămoosăm, ad-hawăn-dd-isənnifiləl a-wen ălxurmăt n-Abba-nin. ");
INSERT INTO taq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tărha ta-hi ija Abba, ənta a hawăn-jeɣ năkk-dăɣ; əṭṭəfăt tărha-nin, təzzăɣăm dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tărha-nin daɣ, wăr tăt-mad-təṭṭəfăm ar s-ad-təṭṭafăm fărəḍăn-in s-əmmək wa s-əṭṭafăɣ fărəḍăn n-Abba-nin, əlkamăɣ i-tărha-net, əzzaɣăɣ dăɣ-s.» ");
INSERT INTO taq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Măjrăd-wa-dăɣ hawăn-jeɣ, jeɣ-awăn-t dăɣ-təssəba n-ad-təjəm tedăwit šund ta jeɣ, təjəm daɣ tedăwit təmdat. ");
INSERT INTO taq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ămăra, ənta da fărəḍ wa kăwăn-ăsiwărăɣ: ‹Nəmărhăt jer-iman-năwăn s-əmmək-wa-dăɣ s-kăwăn-ărheɣ›. ");
INSERT INTO taq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wăr t-təlla tărha tojărăt ad-ăkf ăwadəm iman-net dăɣ-təssəba n-imidiwăn-net, ");
INSERT INTO taq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","afăl tamašalăm a-wa fălla-wăn əfrăḍăɣ, ad-kăwăn-ɣarrăɣ s-isəm: ‹imidiwăn-in›, ");
INSERT INTO taq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ad-ăbas kăwăn-jeɣ eklan-in ed akli, wăr dăɣ-s itəjj măssi-s isălan-net, ănn-ak, ad-tumasăm imidiwăn-in făl-a-s, a-wa s-əsleɣ ɣur-Abba-nin iket-net, əssəlmădăɣ-awăn-t. ");
INSERT INTO taq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wădden kăwăneḍ a hi-ăsnăfrănăn, năkk a kăwăn-ăsnăfrănăn, ăɣreɣ-kăwăn-dd i-ad-tamašalăm a iha ărramăt i-Măssinăɣ, umasnăt timašalen-năwăn a iɣlalăn. Afăl jăm a-wen, a təttărăm dăɣ Abba-nin s-isəm-in, ad-hawăn-t-ăkf. ");
INSERT INTO taq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ǝnta da a-wa s-kăwăn-omarăɣ: ‹Nəmărhăt jer-iman-năwăn.› » ");
INSERT INTO taq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Kunta tokăḍ dăr-wăn ăddunya, əlmədăt a-s tokăḍ dăr-i data-wăn, ");
INSERT INTO taq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ənnăr tămoosăm ăddinăt ăttilălnen a-wa făll-təglʼ ăddunya, wăr kăwăn-kəssən. Ăssiilmădăɣ-kăwăn a-s wăr kăwăn-təla ăddunya, tokăḍ dăr-wăn daɣ dăɣ-təssəba n-a-wa s-kăwăn-ăsnăfrănăɣ. ");
INSERT INTO taq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ɣaymăt dd-kittəwăm măjrăd wa s-kăla hawăn-t-jeɣ a-s hawăn-ənnəɣ: ‹Wăr t-illa akli ojărăn măssi-s.› Kunta, tăqquzzăbăt-ahi ăddunya-ta-dăɣ, adiš ad-kăwăn-tăqquzzəbət kăwăneḍ-dăɣ, kunta daɣ tăsjăd i-măjrăd-in, adiš, ad-hawăn-səjəd kăwăneḍ-dăɣ ");
INSERT INTO taq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","măšan, əlmədăt a-s wăr hawăn-mad-səjdən ăddinăt, ănn-ak, ălɣizabăt a kăwăn-e-səknən dăɣ-təssəba-nin ed, wăr-əzzeyăn ere wa hi-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ǝnnăr wăr dd-oseɣ i-ad-hasăn-ăjăɣ isălan, iket-di, wăr tăn-itəwwer abăkkaḍ măšan, ămăra-dăɣ d-hasăn-jeɣ isălan, ăbas hasăn-t-illa ăsaru injărăn ibăkkaḍăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ere wa dăr-i okăḍăn, okăḍ daɣ d-Abba-nin. ");
INSERT INTO taq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ǝnnăr wăr jere-săn jeɣ ijităn n-Măssinăɣ s-kăla wăr tăn-ija ăwadəm dat-i, ăqqaymən wăr tăn-iwer abăkkaḍ, măšan ămăra-dăɣ, d-ənhăyăn ijităn n-Măssinăɣ wi jeɣ dat-tiṭṭawen-năsăn, okăḍăn dăr-i năkk hakd Abba-nin. ");
INSERT INTO taq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hakd a-wen-dăɣ, mikḍaw-năsăn dăr-i, i n-təssəba n-ad-itbat măjrăd n-Măssinăɣ wa iktăbăn dăɣ-alămăr-năsăn a-s tăn-iɣtăl, innʼ-asăn: ‹Okăḍăn dăr-i dăgg-adəm bănnan baṭilăn.› ");
INSERT INTO taq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Afăl hawăn-dd-ăssawăyăɣ ănabdid wa t-illan ɣur-Abba, ənta-i n-Unfas wa wăr dd-zəjjăr ar tidət ta dd-fălăt Abba, ad-hawăn-ăj isălan-in, ");
INSERT INTO taq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","tumasăm tijuhawen-in făl-a-s, kăwăneḍ-i-dăɣ a-s wi s-a əssəntăɣ ămašal-in har năkk-da-dăɣ, tăddewăm dăr-i.» ");
INSERT INTO taq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Jeɣ dăɣ-wăn isălan-wi-dăɣ i-ad-wăr tinməšrəyăm. ");
INSERT INTO taq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ilkam ad-hawăn-əgdəlăn kăl-Ălyăhud ămudd dăɣ-ihănan n-ăddin-năsăn, ilkam făw ăzzăman s-ăwadəm inɣăn iyyăn dăɣ-wăn, ad-iɣal teɣse a ikăt i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ad-əjən a-wen ed wăr hi-əzzeyăn năkk wăla Abba. ");
INSERT INTO taq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ǝllăɣeɣ-awăn hărwa ămăra, dăɣ-təssəba n-a-s afăl dd-əwwăḍăn hărătăn-win-dăɣ, ad-dd-təktəwăm a-s ălleɣeɣ-awăn săr-săn hărwa wăr jen, wăr hawăn săr-săn əllăɣeɣ ăru ed a-s ija a-wen, ărtayăɣ dăr-wăn măšan ");
INSERT INTO taq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ămăra-dăɣ d-ăssawăḍăɣ uɣəl n-Wa hi-dd-ăšmašălăn, wăr kăwăn-iha-i hi-isastanăn d-diha əkkeɣ ");
INSERT INTO taq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","măšan, ăɣšadăn ulhawăn-năwăn dăɣ-təssəba n-a-wa hawăn-ənneɣ. ");
INSERT INTO taq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tidət a hawăn-ənnəɣ, ufʼ-awăn ad-ăglăɣ ed, afăl wăr-əgleɣ, wăr mad-kăwăn-dd-ass ănabdid, afăl əgleɣ, ad-hawăn-t-dd-sukăɣ. ");
INSERT INTO taq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Afăl dd-osa ănabdid, ad-isəlməd a-s toška ăddunya dăɣ-a-wa ămoosăn abăkkaḍ d-a-wa ămoosăn iqqud d-a-wa ămoosăn ăššăreɣa n-Măssinăɣ; ");
INSERT INTO taq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ad-isəlməd ăddinăt a-s oškan dăɣ-isălan n-ibăkkaḍăn ed, wăr săr-i omenăn, ");
INSERT INTO taq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","isəlməd-tăn a-s oškan dăɣ-isălan n-iqqud ed əkkeɣ Abba, wăr-ilkem ad-hi-tənhayăm, ");
INSERT INTO taq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","isəlməd-tăn a-s oškan dăɣ-isălan n-ăššăreɣa ed Iblis-i n-ămănokal n-ăddunya, ăššăreɣa-net, ăru d-t-iɣtăs Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Leeɣ a ăjjeen s-ărheɣ ad-hawăn-t-ănnăɣ măšan, wăr tăddobem ujreh-net ămăra-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Afăl dd-osa Unfas wa wăr dd-zəjjăr ar tidət, ad-kăwăn-aɣəd dăɣ-tidət iket-net făl-a-s, wădden isălan n-iman-net a dăɣ-e ămmăjrăd, ănn-ak, ad-ăj isălan n-a-wa s-islă, ăllăɣăt-awăn hărătăn-wi dd-malənen. ");
INSERT INTO taq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Afăl dd-osa Unfas, ad-hi-isəmɣăr făl-a-s, ad-dd-irməs măjrăd-in, isuɣəl-awăn-t. ");
INSERT INTO taq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A-wa ila Abba iket-net, i-nin, a-wen-dăɣ a făl hawăn-ənneɣ, ad-dd-irməs măjrăd-in, isuɣəl-awăn-t.» ");
INSERT INTO taq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ăqqima-hin a ənḍărrăn i-ad-ăbas hi-hannăyăm, akəy daɣ ăssaɣăt ənḍărrăn, taləsăm-ahi ahănay.» ");
INSERT INTO taq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ǝslăn iyyăḍ dăɣ-inəṭṭulab-net i-tifer-tin-dăɣ ɣas, ănmănnăn jer-iman-năsăn: «Ǝndek ălmăɣna n-măjrăd wa hanăɣ-ija a-s innă: ‹Ăqqima-hin a ənḍărrăn i-ad-ăbas hi-hannăyăm, akəy daɣ ăssaɣăt ənḍărrăn, taləsăm-ahi ahănay.› Ma ămoos daɣ ălmăɣna n-: ‹əkkeɣ Abba-nin› wa hanăɣ-innă?» ");
INSERT INTO taq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ănmănnăn daɣ: «Năkkăneḍ ya wăr t-illa a nəfham, ma ămoos ălmăɣna ‹n-ălwăqq ənḍărrăn› wa s-hanăɣ-ijănna.» ");
INSERT INTO taq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ilmăd Ɣisa a-s ărhan ad-t-səstənăn ɣas, innʼ-asăn: «Kăwăneḍ, tinməssəstinăm hărwa jer-iman-năwăn dăɣ-a-wa s-hawăn-ənneɣ: ‹Ăqqima-hin a ənḍărrăn i-ad-ăbas hi-hannăyăm, akəy daɣ ăssaɣăt ənḍărrăn, taləsăm-ahi ahănay›. ");
INSERT INTO taq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ălleɣeɣ-awăn s-tidət tădduuttet a-s ad-šoršəm, səkkələlăm, a-s ija a-wen ăddunya ənta tăsriiw, ad-ăɣšədăn iman-năwăn măšan, ad-dd-təšrəy tedăwit a-wen. ");
INSERT INTO taq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wădden tamăḍt ed, tăbok ajăraw n-eɣăf-net, ad-taẓăr hullan măšan, afăl təjrăw eɣăf-net ad-hin-titaw tiẓẓurt-net tənnin-dăɣ iket-net, tisnant-net, ad-has-tăt-in-sətəw tedăwit n-ara wa təkrăš. ");
INSERT INTO taq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ǝmmək-wen-dăɣ a-s kăwăneḍ-dăɣ ămăra-dăɣ, ăɣšadăn iman-năwăn măšan, ad-kăwăn-aləsăɣ ahănay, ăddăwen ulhawăn-năwăn, əjən daɣ tedăwit-ta-dăɣ s-wăr t-illa ere ăddoben aɣăšad-net. ");
INSERT INTO taq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ašăl-wen d-hi-mad-tənhəyăm, wăr mad-t-iməl făw a-s tămiɣatărăm d-asəstan-in dăr-s. Ălleɣeɣ-awăn s-tidət tădduuttet a-s a təttărăm dăɣ-Abba s-isəm-in, ad-hawăn-t-ăkf. ");
INSERT INTO taq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Har ămăra-dăɣ, wăr t-illa a dăɣ-t-dalăm s-isəm-in, ădəlăt-t ămăra, ad-kăwăn-ăkf a-wa dăɣ-s təttărăm i-ad-săr-wăn dd-təmdəw tedăwit.» ");
INSERT INTO taq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«A ija a-wa-dăɣ, saɣlayăɣ-kăwăn tangalen, sinfăqqeɣ-awăn hărătăn, măšan, imal-dd ălwăqq d-ăbas hawăn-e-tamăjradăɣ s-tangalen, ašăl-en, ad-hawăn-ăjăɣ isălan n-Abba s-əmmək ăssiifhămăn. ");
INSERT INTO taq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ašăl-wen, wăr mad-təmɣutărăm s-ad-hawăn-ădəlăɣ Abba, ad-t-tədələm kăwăneḍ iman-năwăn s-isəm-in ");
INSERT INTO taq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","făl-a-s, Abba iman-net irhʼ-iwăn ed tărham-ahi, tomanăm daɣ a-s Măssinăɣ a dd-falăɣ. ");
INSERT INTO taq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ǝnta a hi-dd-ăšmašălăn s-ăddunya ɣas, ămăra, falăɣ-tăt, ăqqalăɣ-t ənta-i n-Abba.» ");
INSERT INTO taq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ǝnnăn-as inəṭṭulab-net: «Năkkăneḍ iket nəjrăh a-wa hanăɣ-janned ed, ăbas hanăɣ-saɣlayăd tangalen, a-wa hanăɣ-janned ămăra iket-net, ilʼ ujreh. ");
INSERT INTO taq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nəssan ămăra a-s wăr t-illa a-s wădden təssanăd-t, wăr tămɣatărăd s-ad-kăy-isəstən ăwadəm d-hărăt wălʼ iyyăn. Dăɣ-təssəba n-a-wen-dăɣ a făl noman a-s kăyy Măssinăɣ a dd-falăd.» ");
INSERT INTO taq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Innʼ-asăn Ɣisa: «Ak tənnăm tomanăm săr-i wădden? ");
INSERT INTO taq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ikna măšan, ăssiilmădăɣ-kăwăn a-s imal-dd ăssaɣăt, ăssaɣăt daɣ s-išwar dd-osa, ad-tămmăhăšăm, ilal hak iyyăn dăɣ-wăn tenere n-iman-net, təyyəm-ahi năkk ɣas măšan, kud-hi-fălăm-dăɣ, wăr mad-ăqqaymăɣ năkk ɣas ed, idhal-ahi Abba. ");
INSERT INTO taq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ǝkkăsăɣ-kăwăn dăɣ-taɣdărt n-hărătăn-wi-dăɣ i-ad-săr-i tamənăm, təjrəwăm ălxer. Ǝlmədăt a-s ad-tənhəyăm aɣăna dăɣ-ăddunya-ta-dăɣ măšan, wăr kăwăn-isărmaɣet hărăt, əkrăšăɣ ašăl făll-ăddunya.» ");
INSERT INTO taq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ija Ɣisa isălan-win-dăɣ ɣas, ăjoẓăy išənnawăn, innă: «Abba, tăqqăn ta hi-təkfed, tăwwăḍ-dd, sətbət təmɣăre n-ălxurmăt n-Rure-k i-ad-isətbət ənta-dăɣ wa-năk ");
INSERT INTO taq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","făl-a-s Rure-k, ənta a təkfed tărna făll-e d t-illăm ăgg-adəm i-ad-umas əssəbab wa ihăkkăn tămudre ta tăɣlălăt i-ăddinăt wi t-təssăɣlăfăd. ");
INSERT INTO taq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tămudre-en, a tăt-ămoosăn: ad-kăy-əzzəyăn, kăyy-i n-Măssinăɣ wa n-tidət, əzzəyăn Rure-k Ɣisa Ălmasex wa dd-tăšmašălăd. ");
INSERT INTO taq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ǝssəlmădăɣ s-ălxurmăt-năk făll-ărori n-ăkall, ăssawăḍăɣ-in daɣ ămašal wa hi-təssăɣlăfăd, ");
INSERT INTO taq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ămăra Abba, iqqəlet-ahi-dd ălxurmăt wa ɣur-k leɣ hărwa wăr dd-tăxlek ăddunya. ");
INSERT INTO taq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Dăɣ-a-wa əkkăsăɣ heɣ ăddunya-ta-dăɣ, ăsbayănăɣ-kăy i-ăddinăt wi hi-dd-tohăɣăd dăɣ-s, təssăɣlăfăd-ahi-tăn; kăyy a tăn-ilăn măšan, təkfed-ahi-tăn daɣ ɣas, əlkămăn i-măjrăd-năk, əṭṭăfăn-t. ");
INSERT INTO taq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ašăl-i, əlmădăn a-s a-wa hi-təkfed iket-net, kăyy a dd-ifal ");
INSERT INTO taq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","făl-a-s, a-wa hi-tənned iket-net, ənneɣ-asăn-t, ăqbălăn-t, əlmădăn daɣ a-s tidət a-s kăyy a dd-fălăɣ, əflăsăn a-s kăyy a hi-dd-ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Təddalăɣ-kăy hasăn, wăr kăy-təddilăɣ i-ăddunya ta wărăt săr-k tomen, təddalăɣ-kăy i-ăddinăt wi hi-tăsnăfrănăd făl-a-s, ăddinăt-win-dăɣ a-s wi-năk. ");
INSERT INTO taq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A-wa leɣ iket-net, i-năk, a-wa led daɣ iket-net, i-nin; əntăneḍ-en-dăɣ daɣ săr-k omănnen a dăɣ-dd-ănfalăl ălxurmăt-in. ");
INSERT INTO taq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Šămad năkk ămăra, əzjarăɣ ăddunya-ta-dăɣ i-ad-kăy-in-ăkkăɣ, ăqqaymən dăɣ-s əntăneḍ, əttarăɣ dăɣ-k Abba Šăddijăn, ad-tăn-tagəẓăd s-tărna n-isəm-năk wa hi-təkfed năkk-i n-Rure-k, i-ad-osaɣăn s-əmmək wa s-nosaɣ năkk d-kăyy. ");
INSERT INTO taq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ăzzăman wa əkkăsăɣ jere-săn, ogaẓăɣ-tăn s-tărna n-isəm-năk, ogăẓăɣ-tăn daɣ iket-dăɣ-năsăn, jeɣ ənniyăt, wăr tăn-iha făw-i hi-ănimăšrăyăn a-s təkkăsăd wa n-ăgg-əlhəllak i-ad-itbət a-wa dăɣ-ălolăy əlkəttab. ");
INSERT INTO taq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ămăra, năkk-da-dăɣ s-išwar kăy-in-ăqqalăɣ, tajjăɣ-asăn măjrăd-wa-dăɣ, dăɣ-ăddunya-ta-dăɣ, i-ad-ăddăwen s-tedăwit n-tănoflayt ta s-năkk ɣas a tăt-ihakkăn. ");
INSERT INTO taq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ǝssăɣlăfăɣ-tăn măjrăd-năk măšan, tăššunjăt-tăn ăddunya ed, wăr tăn-təla s-əmmək wa s-wăr hi-təla năkk-i s-omănăn. ");
INSERT INTO taq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Abba, wăr dăɣ-k təttărăɣ ad-tăn-təkkəsăd dăɣ-ăddunya-ta-dăɣ, ănn-ak, tattărăɣ dăɣ-k, ad-tăn-tagəẓăd dăɣ-a-wa lăbasăn. ");
INSERT INTO taq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wăr tăn-təla ăddunya-ta-dăɣ s-əmmək wa s-wăr hi-təla năkk-dăɣ-i s-omănăn. ");
INSERT INTO taq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Šəšdəj-tăn s-măjrăd-năk ed măjrăd-năk a-s tidət ta n-tidət. ");
INSERT INTO taq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ăšimašălăɣ-tăn s-ăddunya s-əmmək wa s-hi-dd-tăšmašălăd săr-s, ");
INSERT INTO taq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","năkk, hakkăɣ-kăy iman-in dăɣ-təssəba-năsăn i-ad-kăy-əkfən iman-năsăn əntăneḍ-dăɣ, šəšdəj-tăn s-tidət-năk. ");
INSERT INTO taq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wădden əntăneḍ-i-dăɣ ɣas a făl kăy-təddalăɣ, təddalăɣ-kăy daɣ i-ăddinăt iket-dăɣ-năsăn wi s-ilkam ad-săr-k amənăn dăɣ-təssəba n-tajuhe-ta mad-əjən făll-i, ");
INSERT INTO taq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","umasnet iket-dăɣ-năsăn iyyăt taɣəssa s-əmmək wa s-nămoos năkk d-kăyy iyyăn, heɣ-kăy, hed-ahi, umasnet əntăneḍ-dăɣ iyyăn dăr-năɣ i-ad-təfləs ăddunya a-s kăyy a hi-dd-Ăšmašălăn. ");
INSERT INTO taq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Năkk daɣ, ălxurmăt wa hi-təkfed, əkfeɣ-asăn-t i-ad-osaɣăn, ămoosăn iyyăn s-əmmək wa s-nosaɣ, nămoos năkk d-kăyy, iyyăn. ");
INSERT INTO taq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tartit-ta dăr-k jeɣ a dăr-săn jeɣ năkk-dăɣ i-ad-tumas tartit-năsăn ti təmdat, təlməd daɣ ăddunya a-s kăyy a hi-dd-ăšmašălăn, təlməd daɣ a-s jed-asăn tărha šund ta hi-jed. ");
INSERT INTO taq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ǝttarăɣ dăɣ-k Abba a-s edăgg wa hi-təkfed, ăhrăɣet-t ɣur-k daɣ d-ăddinăt-wi hi-təkfed i-ad-əjjunfun əntăneḍ-dăɣ, dăɣ-ălxurmăt wa hi-təkfed ed, kăyy tărha-ta hi-jed, jed-ahi-tăt hărwa wăr dd-tăxlek ăddunya. ");
INSERT INTO taq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Abba, kăyy-i oɣădăn, tunjăy ăddunya-ta-dăɣ s-ad-kăy-təzzəy măšan năkk, əzzăyăɣ-kăy, ăddinăt daɣ wi săr-i omănnen, əflasăn a-s kăyy a hi-dd-ăšmašălăn; ");
INSERT INTO taq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ăzozăyăɣ-tăn isəm-năk, ad-kăy-aləsăɣ daɣ azuzi-hasăn i-ad-təjjəš tărha-ta hi-jed ulhawăn-năsăn, ăknăɣ tartit dăr-săn.» ");
INSERT INTO taq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Issəmda Ɣisa d-tittar-tin-dăɣ ɣas, iglă ənta d-inəṭṭulab-net, əjlăyăn tasənjit ta s-itawănna ta n-Šădron, əjjăšăn ammas n-ašəkrəš n-ihəškan ihan asălim n-aman, ");
INSERT INTO taq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","a-wen edăgg s-issan Yăhudəs-i t-madăn-isəssăɣdăr a-s itakkʼ-e-hi-dd Ɣisa d-inəṭṭulab-net. ");
INSERT INTO taq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iha Ɣisa ammas n-ašəkrəš-en-dăɣ a-s Yăhudəs-da-dăɣ ăddew d-əssărdusa d-ălgomităn n-ehăn n-ămudd wa măqqărăn dd-ăssiglăn imănokalăn n-kăl-tikutawen d-kăl-faris ăwwayăn tiftəl d-imămmălăn, əšlajăn tikobawen. ");
INSERT INTO taq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Issan Ɣisa ɣur-iman-net a-wa has-iqqălăn, izjăr-dd săr-săn, innʼ-asăn: «Mi s-tammăɣăm?» ");
INSERT INTO taq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ǝnnăn-as: «Ɣisa wa n-Năṣirăt.» Innʼ-asăn Ɣisa: «Năkk da.» Ăddinăt-en, ihʼ-en Yăhudəs-i t-e-isəssăɣdărăn. ");
INSERT INTO taq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Diha-dăɣ d-hasăn-innă: «Năkk da», issəknʼ-en iman-net, ad-ăškătarăšăn, təwăt-tăn tarəmmeɣt s-ăkall ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Olăs-tăn asəstan, innʼ-asăn: «Ak kăwăneḍ, mi s-tammăɣăm?» Ǝnnăn-as daɣ: «Ɣisa wa-n Năṣirăt.» ");
INSERT INTO taq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Innʼ-asăn: «Wădden ənneɣ-awăn: ‹Năkk da.› Kunta tidət-dăɣ a-s năkk a-s təmmaɣăm adiš, ăyyăt inəṭṭulab-in ad-əglun.» ");
INSERT INTO taq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ijă Ɣisa măjrăd-wen-dăɣ i-ad-umas a ăsidătten a-wa s-kăla tăn-innă a-s innă: «Abba, wi hi-təkfed, wăr dăɣ-săn ănmăšrăy wălʼ iyyăn.» ");
INSERT INTO taq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ilbăy-dd ălwăqq-wen-dăɣ Simyon wa s-itawănna Bəṭrus tăkoba-net, iwăt săr-s Malkus wa n-akli n-ămănokal n-kăl-tikutawen, inkăḍ-dd taməẓẓujt-net ta n-aɣil. ");
INSERT INTO taq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iɣtăl Ɣisa Bəṭrus, innʼ-as: «Suɣəl tăkoba-năk titar; wăr t-illa əmmək s-unjăyăɣ s-tesăse n-kara n-tisnant wa hi-iẓẓăl Abba ăssaɣăt-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Irmăs kumănda d-əssărdusa-net d-ălgomităn-wi dd-ăšmašălăn imănokalăn n-kăl-Ălyăhud Ɣisa, əkrădăn-t, ");
INSERT INTO taq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","əlwăyăn-t s-tizarăt s-ehăn n-Xăna wa n-aḍăggal n-Qayăf-i n-ămănokal n-kăl-tikutawen awătay-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Qayăf-en-dăɣ a-s kăla innă i-imănokalăn n-kăl-Ălyăhud dăɣ-isălan n-Ɣisa: «Ufa ămmut ăhaləs iyyăn uhən təlhăs tamətte iket-net.» ");
INSERT INTO taq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A-s ităjj a-wen-dăɣ, ăddeew Simyon Bəṭrus d-ănăṭṭalib iyyăn, əjan alkum šəjren i-Ɣisa. Ănăṭṭalib-en dăr-ăddew Simyon, izzay-t ămănokal n-kăl-tikutawen, ijrăw-as a-wen-dăɣ ad-imzəyyət d-Ɣisa ujəš n-ăɣalla n-ehăn n-ămănokal n-kăl-tikutawen ");
INSERT INTO taq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","măšan, ăqqima-hin Bəṭrus ənta ibdad dăɣ-təfărre dat-emm n-ăɣalla. Ăhoja ănăṭṭalib wa izzăy ămănokal n-kăl-tikutawen ɣas, izjăr-dd, imməjrăd i-tamăḍt ta təṭṭăfăt emm n-ăɣalla, toyyʼ-e, ăššojăš-dd Bəṭrus. ");
INSERT INTO taq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Təkyăd tănaxdimt ta təṭṭăfăt emm n-ăɣalla dăɣ-Bəṭrus, tənnʼ-as: «Ajăn kăyy wădden iyyăn dăɣ-inəṭṭulab n-ăhaləs-wa-dăɣ s-iket ittărmăs?» Innʼ-as Bəṭrus: «Wăr t-ămoosăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Itajj a-wen s-ăzzăman n-tajrəst, ăssiirɣăn inaxdimăn n-ămănokal n-kăl-tikutawen d-ălgomităn wi ăɣlăfnen ehăn n-ămudd wa măqqărăn efew, əzzahăn săr-s, ibdăd-dd Bəṭrus edes-hasăn, ad-itazzăh ənta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Issəstăn ămănokal n-kăl-tikutawen Ɣisa, ittăr dăɣ-s ad-has-ăj isălan n-inəṭṭulab-net d-a-wa tăn-isăɣra. ");
INSERT INTO taq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ăwwežăb-as Ɣisa, innʼ-as: «Năkk, wăr kăla ənneɣ hărăt făw i-ăddinăt dăɣ-ufăr, əssăɣrăɣ dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud d-ehăn n-ămudd wa măqqărăn-i dăɣ-tažămmaɣăn kăl-Ălyăhud, wăr t-illa a ăssiɣrăɣ dăɣ-ufăr ɣas, ");
INSERT INTO taq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","mafăl hi-sastanăd? Səstən ăddinăt-wi əslănen i-a-wa əssăɣrăɣ, əssanăn a-wa hasăn-ənneɣ.» ");
INSERT INTO taq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Diha-dăɣ d-innă Ɣisa a-wen-dăɣ ad-has-istăɣ iyyăn dăɣ-ălgomităn n-ehăn n-ămudd wa măqqărăn, innʼ-as: «Kăyy, ma kăy-ăsihălăn a təjəd erk măjrăd i-amănokăl n-kăl-tikutawen?» ");
INSERT INTO taq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Innʼ-as Ɣisa: «Kunta jeɣ erk măjrăd, săkənăt-ahi a-wa dăɣ-ănmăšrăyăɣ, kunta daɣ măjrăd oɣadăn a jeɣ adiš, mafăl tamătteɣ?» ");
INSERT INTO taq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Issəgdăh Xăna dăɣ-isəstanăn n-Ɣisa ɣas, ikrăd-t, ăssawăy-t i-Qayăf-i n-ămănokal n-kăl-tikutawen. ");
INSERT INTO taq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","A-s ităjj a-wen-dăɣ, ăqqiima Simyon Bəṭrus hărwa s-efew, itazzăh. A ənḍărrăn, ăkrăttăt-t ăwadəm iyyăn, innʼ-as: «Wădden kăyy-dăɣ iyyăn dăɣ-inəṭṭulab-net?» Ăkkuddăl Bəṭrus a-wen, innă: «Wăr t-ămoosăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iggăd-dd iyyăn dăɣ-inaxdimăn n-ămănokal n-kăl-tikutawen, ămoosăn ašăqqaɣ n-ăhaləs wa s-dd-ifrăs Bəṭrus taməẓẓujt-net s-tăkoba, innă i-Bəṭrus: «Kăyy-i-dăɣ, ənhayăɣ-kăy tăddewăd d-Ɣisa dăɣ-ašəkrəš n-ihəškan wa-dăɣ ittărmăs?» ");
INSERT INTO taq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Olăs daɣ Bəṭrus akuddəl n-a-wen. Tamăzăyyat-ten-dăɣ, ad-iwăt ekăz ăɣora. ");
INSERT INTO taq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hărwa tifawt ad-fălăn d-Ɣisa ehăn wa n-Qayăf, əkkăn dăr-s ehăn wa n-gəfăr măšan, unjăyăn s-ad-əjjəšăn ammas-net făl tuksəḍa n-ad-səmməḍəsăn iman-năsăn, igdəl-asăn a-wen-dăɣ tetăte n-isan n-taɣsiwen-ti lănen s-ad-ăɣrəsnăt ašăl wa n-ămudd wa n-Faṣka. ");
INSERT INTO taq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ǝbdadăn dăɣ-ajăma n-ehăn-en-dăɣ a-s săr-săn dd-izjăr Bilatəs, innʼ-asăn: «Ma ămoos uḍlem wa tăsiwărăm ăhaləs wa təlwăyăm?» ");
INSERT INTO taq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ǝnnăn-as: «Ǝnnăr a-s ija a lăbasăn, wăr t-dd-nələwwəy săr-k.» ");
INSERT INTO taq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Innʼ-asăn Bilatəs: «Ăglăt, əšrăɣăt-t s-a-wa innă ălqanun-năwăn.» Ǝnnăn-as imănokalăn n-kăl-Ălyăhud: «Năkkăneḍ, dăɣ-a-wa innă ălqanun-nănăɣ, wăr hanăɣ-t-illa ad-năj iman n-ăwadəm.» ");
INSERT INTO taq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wăr hasăn-ijrew ălqanun-năsăn tenăɣe n-ăwadəm i-ad-tədduttət tənna n-Ɣisa făl tamăttant ta mad-ăj. ");
INSERT INTO taq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Olăs Bilatəs ujəš n-ehăn-net, iɣră-dd Ɣisa təzzar, innʼ-as: «Ak, kăyy a-s ămănokal n-kăl-Ălyăhud meɣ?» ");
INSERT INTO taq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Innʼ-as Ɣisa: «Ak tifer-ti-dăɣ jed ămăra-dăɣ, ad-dd-təkkasăd dăɣ-eɣăf-năk meɣ măsăllăt a tănăt-jed?» ");
INSERT INTO taq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Innʼ-as Bilatəs: «Năkk-š ma ăkkulăɣ, ajăn ăgg-Ălyăhud a ămoosăɣ, tăjjăšăn-ahi isălan-năk? Tumast-năk d-imănokalăn n-kăl-tikutawen a kăy-dd-ăwwăynen săr-i, ɣas, lăɣăt-ahi, ma tăɣšădăd?» ");
INSERT INTO taq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Innʼ-as Ɣisa: «Təmmənəya-nin, wăr tăt-təla ăddunya-ta-dăɣ, ənnăr tăt-təla ăddunya-ta-dăɣ, iket-di, əknəsăn inəṭṭulab-in i-ad-wăr hi-jen imănokalăn n-kăl-Ălyăhud dăɣ-ifassăn-năk, ămăra, Təmmənəya-nin, wăr tăt-təla ăddunya-ta-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Innʼ-as Bilatəs ălwăqq-wen: «Adiš tidət-dăɣ a-s ămănokal a tămoosăd?» Innʼ-as Ɣisa: «Kăyy iman-năk tənned-tăn, ămănokal a ămoosăɣ. Năkk, ămešălăɣ-dd s-ăddunya-ta-dăɣ, weɣ-dd dăɣ-s i-ad-umasăɣ tajuhe i-tidət, ere wa ilkămăn i-tidət iket-net, ad-isəjəd i-a-wa jănneɣ.» ");
INSERT INTO taq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Innă Ɣisa a-wen ɣas, innʼ-as Bilatəs: «Tidət-i-dăɣ făw, əndek-tăt?» Innă Bilatəs a-wen ɣas, izjăr-dd daɣ s-imănokalăn n-kăl-Ălyăhud, innʼ-asăn: «Ăhaləs wa hi-dd-tăwwăyăm, wăr fălla-s əjrewăɣ uḍlem t-ăsinăhăjjăn d-tamăttant măšan, ");
INSERT INTO taq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","šămad ăssilmădăɣ-kăwăn a-s hak ămudd n-Faṣka, ăsiwăyyăɣ-awăn-in u-takărmut iyyăn, əssənăt tenʼ-i-dăɣ tărham ad-hawăn-in-səwwəyyăɣ ămănokal n-kăl-Ălyăhud meɣ?» ");
INSERT INTO taq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ǝslăn i-a-wen ɣas, ăsɣăren dăɣ-išənnawăn, ənnăn-as: «Făw, wăr hanăɣ-t-dd-toyyed, ănn-ak, səwwəyy-anăɣ-dd Bărɣăbbas.» Bărɣăbbas-i s-ărhan a hasăn-t-dd-isəwwəyy, ătiwăssan a-s ănaɣtaf a ămoos. ");
INSERT INTO taq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Irmăs Bilatəs Ɣisa, omăr əssărdusa i-ad-dăɣ-s əjən tiwit s-ibărtăkăn. ");
INSERT INTO taq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ǝggădăn-dd əssărdusa, əẓẓăn ălmăt, korona, a-wen, takənbut n-isənnanăn šund ta tăjjăn imănokalăn təzzar, ăswărăn-tăt eɣăf-net, əssəlsăn-t anăkăbba šăggăɣăn ");
INSERT INTO taq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","təzzar, ad-t-tiɣliɣələyăn, jannen-as: «Ămănokal n-kăl-Ălyăhud, nəjʼ-ak gărdəbu», sattăɣăn-as siha d-siha. ");
INSERT INTO taq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Izjăr-dd Bilatəs daɣ s-kăl-Ălyăhud, innă: «Ǝnhəywăt, ăhaləs-i-dăɣ, ăssoɣălăɣ-awăn-t-in i-ad-kăwăn-səlmədăɣ a-s wăr t-illa uḍlem fălla-s əjrawăɣ t-ăsinăhăjjăn d-tamăttant.» ");
INSERT INTO taq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Izjăr-dd Ɣisa săr-săn ḍarăt-a-wen, ija takənbut ta n-isənnanăn, ilsa anăkăbba wa šăggăɣăn, innʼ-asăn Bilatəs ălwăqq-wen «Ăhaləs-năwăn dədi.» ");
INSERT INTO taq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ǝnhăyăn imănokalăn n-kăl-tikutawen d-ălgomităn Ɣisa ikkʼ-en-dd ɣas, ăsɣăren iket-năsăn, ənnăn i-Bilatəs: «Itwəṣləbet făll-tajəttewt, Itwəṣləbet făll-tajəttewt!» Innʼ-asăn Bilatəs ămăra: «Ărməsăt-t, təṣləbăm-t făll-tajəttewt kăwăneḍ iman-năwăn făl-a-s năkk, wăr t-illa uḍlem fălla-s əjrawăɣ t-ăsinăhăjjăn d-tamăttant.» ");
INSERT INTO taq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ǝnnăn-as imănokalăn n-kăl-Ălyăhud: «Năkkăneḍ, ijraw-anăɣ Ăṭṭăwrăt iji n-iman-net ed, ija iman-net Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Isla Bilatəs i-măjrăd-wen-dăɣ ɣas, irmăɣ, ");
INSERT INTO taq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ijjăš ehăn-net təzzar, innă i-Ɣisa: «Kăyy-i-dăɣ făw, əndek siha s-dd-hed?» Wăr t-illa a has-inna Ɣisa. Innʼ-as Bilatəs: ");
INSERT INTO taq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","«Mafăl wăr hi-jənnid hărăt? Ajăn wăr təssenăd a-s năkk leɣ tădabit n-ad-kăy-in-ăyyăɣ, leɣ daɣ tădabit n-ad-kăy-əṣləbăɣ făll-tajəttewt?» ");
INSERT INTO taq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Innʼ-as Ɣisa: «Wăr făll-i mad-təkrəšăd tărna wălʼ iyyăt săl ta kăy-ikfa Măssinăɣ dăɣ-ăssaɣăt-wa-dăɣ, a-wen-dăɣ a făl ere wa hi-ijăn jer-ifassăn-năk, ojăr-kăy tifut n-abăkkaḍ.» ");
INSERT INTO taq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ad-itammăɣ ya Bilatəs i-ăddăbara s-t-in-ăswăyya măšan, ăsɣăren kăl-Ălyăhud dăɣ-išənnawăn, ənnăn-as: «Afăl t-in-toyyed, ad-nəlməd a-s kăyy wădden amidi n-Qăyṣăr a tămoosăd făl-a-s, nəssan a-s ere ijan iman-net ămănokal iket-net, ad-umas ašănjo n-Qăyṣăr.» ");
INSERT INTO taq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Islă Bilatəs i-a-wen ɣas, izzəzjăr-dd Ɣisa təzzar, ăqqima dăɣ-edăgg wa dăɣ-iɣattăs ăššăreɣa s-itawănna dăɣ-Ɣăbranəyya: Ɣăbbata. ");
INSERT INTO taq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Itajj a-wen s-tarăhut n-ašăl wa n-dat-wa n-ămudd wa n-Faṣka. Innă Bilatəs i-imănokalăn n-kăl-Ălyăhud: «Uhənăt, ămănokal-năwăn dədi.» ");
INSERT INTO taq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Măšan, ăskălălăn iket-năsăn, ənnăn-as: «Ămmătet, ămmătet, itwəṣləbet făll-tajəttewt.» Innʼ-asăn Bilatəs: «Ɣas kăwăneḍ, ăba-hawăn ere təṣlăbăm ar ămănokal-năwăn?» Ǝnnăn-as imănokalăn n-kăl-tikutawen: «Năkkăneḍ, wăr nəla ămănokal săl Qăyṣăr.» ");
INSERT INTO taq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ijă Bilatəs Ɣisa jer-ifassăn-năsăn i-ad-itwəṣləb făll-tajəttewt. Ărmăsăn əssărdusa Ɣisa, əlwăyăn-t təzzar, ");
INSERT INTO taq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ăslănjen-t tajəttewt ta făll-mad-itwəṣləb, əzjărăn dăr-s aɣrəm, əkkăn dăr-s edăgg wa s-itawănna dăɣ-Ɣăbranəyya: «Gălgota»; a-wen ălmăɣna-net: «Edăgg wa n-akărkor.» ");
INSERT INTO taq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ašăl-en, ămizăyyen əssin inaɣtafăn atwəṣləb d-Ɣisa; iyyăn daw-aɣil-net, wa iyyăḍăn daw-tăšalje-net, imăl-t ənta jere-săn. ");
INSERT INTO taq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ǝṣlăbăn Ɣisa ɣas, issəktăb Bilatəs făll-ăllox iyyăn a-s: «A-WA ƔISA WA N-NĂṢIRĂT N-ĂMĂNOKAL N-KĂL-ĂLYĂHUD». Ǝttəytăyăn-t jənnəj-s făll-tajəttewt ta făll-ătwăṣlăb. ");
INSERT INTO taq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Akătab-en, ăɣrăn-t kăl-Ălyăhud ăjjootnen făl-a-s, edăgg wa dăɣ-ătwăṣlăb Ɣisa, ohaẓ aɣrəm. Ăllox-en, akătab wa t-iwarăn, ija dăɣ kăraḍ iməjridăn: Ɣăbranəyya, Tăromanit d-Tălyunanit. ");
INSERT INTO taq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ǝggădăn-dd imănokalăn n-kăl-tikutawen d-kăl-Ălyăhud, ăsmătărăn Bilatəs d-udaɣ ad-iktəb a-s Ɣisa ămănokal n-kăl-Ălyăhud ănn-ak, iktəbet a-s, innă: năkk, ămănokal n-kăl-Ălyăhud măšan, ");
INSERT INTO taq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","innʼ-asăn Bilatəs: «A-wa s-išwăr əktăbăɣ-t, əktăbăɣ-t.» ");
INSERT INTO taq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ǝṣlăbăn əssărdusa Ɣisa făll-tajəttewt ɣas, əjăn i-isəlsa-net əkkoẓăt tiẓunawen, iḍkăl hak iyyăn dăɣ-săn tăẓune tiyyăt, wăr dd-ăqqima ar tanăkăbbat wăr iha aẓămay wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ărmăsăn-tăt əssărdusa ɣas, ănmănnăn jer-iman-năsăn: «Udaɣ ad-tăt-nəsăɣărriwət, năjet fălla-s tisăɣeren i-ad-t-ikrəš iyyăn dăɣ-năɣ.» Ǝjăn tisăɣeren, ămoos a-wen a ăssiitbătăn a-wa iktăbăn dăɣ-măjrăd n-Măssinăɣ a-s inna: «Ăẓunăn isəlsa-nin, jăn tisăɣeren făll-tanăkăbbat-in.» Jăn əssărdusa a-wen s-əmmək-wa-dăɣ s-tăn-innă əlkəttab n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Edes i-tajəttewt ta făll-ătwăṣlăb Ɣisa, təbdad ma-s d-wălătma-s n-ma-s d-Măryăma ta n-hănne-s n-Klufas d-Măryăma ta s-itawănna ta n-Mulăždaləyăt. ");
INSERT INTO taq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Inhăy Ɣisa ma-s təbdad edes i-ănăṭṭalib wa ikna tărha ɣas, innʼ-as: «Anna, rure-m dədi ibdădăn edes-ham.» ");
INSERT INTO taq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Innă daɣ i-ănăṭṭalib: «Kăyy daɣ, ma-k dədi təbdădăt edes-hak, taɣălift-năk.» Ɣur-ašăl-wen-dăɣ, ijʼ-et-dd ănăṭṭalib-en s-iman-net, iṭṭăf-as tămudre. ");
INSERT INTO taq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ilmăd Ɣisa a-s əssəbab wa făl dd-ămešăl s-ăddunya, ăssawăḍ-t-in iket-net, făll-tajəttewt-en-dăɣ, innă: «Ăffuudăɣ.» Ămoos a-wen a ăssiitbătăn a-wa innă əlkəttab n-Măssinăɣ fălla-s. ");
INSERT INTO taq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Iskar dihen ăkoss iḍkarăn bənegăr, innă Ɣisa ăffuud ɣas, əttălăn əssărdusa tăḍuft făll-ăbori, əssəlmăɣăn-tăt dăɣ-bənegăr təzzar, əẓẓălăn-as-tăt i-ad-tăt-isuməm măšan, ");
INSERT INTO taq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ăkrăbbăt Ɣisa bənegăr ɣas, inna: «A-wa s-dd-oseɣ, ijă, imdă». Ăskărăyrăy-dd eɣăf-net ḍarăt-a-wen, ijmăḍ-t unfas. ");
INSERT INTO taq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Itajj a-wen ašăl wa n-dat-wa n-Faṣka-i-dăɣ sadawăn ăddinăt i-ămudd. Šămad wăr-ərhen imănokalăn n-kăl-Ălyăhud ad-tăn-dd-iɣdăr ămudd wa n-Faṣka-i əknăn asəmɣar ed awătay-wen, oḍa ašăl wa n-ămudd făll-əssəbət-i n-tăsonfat, ɣas, osăn Bilatəs, əttărăn dăɣ-s ad-amăr i-əssărdusa terăẓẓe n-iḍarăn n-ăddinăt-wi ătwăṣlăbnen făll-tijəttewen təzzar, əkkəsăn-tăn-dd fălla-snăt. ");
INSERT INTO taq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Osăn-dd əssărdusa ɣas, ărẓăn iḍarăn n-ănaɣtaf wa ăzzarăn, okăyăn daɣ s-amidi-net wa iyyăḍăn, jăn-as a-wen-dăɣ ənta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ǝwwăḍăn-dd Ɣisa, ənhăyăn-t ămmut ɣas, okăyăn-t wăr-ărẓen iḍarăn-net ");
INSERT INTO taq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","măšan, inbăj iyyăn dăɣ-əssărdusa tajəẓẓelt n-Ɣisa s-allaɣ-net, izjăr-tăt-dd ašni s-əlkamăn aman. ");
INSERT INTO taq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Năkk a iktăbăn isălan-wi-dăɣ ed, ăjjəyhăɣ-asăn iket-dăɣ-năsăn, tajuhe-nin daɣ, wăr tăt-ihʼ ăššăk. Ɣas, siɣulăɣ-tăn năkk-i tăn-inhăyăn s-tiṭṭawen-in dăɣ-təssəba n-ad-tamənăm s-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Isălan-wi-dăɣ, jăn i-ad-itbət a-wa iktăbăn dăɣ-măjrăd n-Măssinăɣ a-s innă: «Wăr mad-ărẓ eɣăs-net wălʼ iyyăn.» ");
INSERT INTO taq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Innă daɣ măjrăd n-Măssinăɣ dăɣ-edăgg iyyăn săl-wen: «Ad-əjjənfun ăddinăt dăɣ-wa dăjăn.» ");
INSERT INTO taq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Osă-dd Yusəf wa n-tadăbayt ta n-Arimata. Ămoos ənta iman-net, ănăṭṭalib n-Ɣisa, măšan, iffar a-wen făl tuksəḍa n-a-wa dăɣ-s-e-ənnən imănokalăn n-kăl-Ălyăhud. Ǝnta-en-dăɣ a ihălăn tikawt n-Bilatəs, ittăr dăɣ-s turhajăt n-ad-dd-ikkəs tafəkka n-Ɣisa făll-tajəttewt; ikfʼ-e Bilatəs turhajăt n-a-wen ɣas, ikkăs-dd tafəkka n-Ɣisa făll-tajəttewt. ");
INSERT INTO taq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Osă-dd daɣ dihen Nikodem wa s-kăla dd-ădwănnăt i-Ɣisa s-ehăḍ, iwway a okăyăn kăraḍăt timərwen n-kelu n-matălxer d-aḍutăn. ");
INSERT INTO taq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ărmăsăn tafəkka n-Ɣisa, əknăn-tăt s-matălxer d-ăḍutăn təzzar, əttălăn-tăt dăɣ-tefit, ed a-wen-dăɣ a tajjăn kăl-Ălyăhud i-ere ăba təzzar, əjăn-t dăɣ-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Edăgg wa dăɣ-ătwăṣlăb Ɣisa, ohaẓ-t ašəkrəš n-ihəškan, iha aẓəkka s-kăla wăr dăɣ-s insa ere ăba. ");
INSERT INTO taq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aẓəkka-wen-dăɣ a dăɣ-jăn tafəkka n-Ɣisa ed, wăr tăn-ujəj, ăsinăkmăm-tăn daɣ ămudd-i s-afăl dd-iwwăḍ ăssaɣăt-net, ad-ăbas t-illa emăremar. ");
INSERT INTO taq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Abənnəbən n-ălxad-i n-ašăl ăzzarăn dăɣ-əssəboɣ, hărwa janăt tihay, tənšăy Măryăma ta n-Mulăždaləyăt aẓəkka wa iha Ɣisa, tənhăy a-s tăhunt ta măqqărăt hărăt emm n-aẓəkka, tămmuqqăs-in. ");
INSERT INTO taq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tošăl s-Simyon Bəṭrus d-ănăṭṭalib wa iyyăḍăn ikna Ɣisa tărha, tənnʼ-asăn: «Tafəkka n-Ălɣalim-nănăɣ, təmmăḍkăl, ăbas ha aẓəkka, wăr nəssen ənde d-tăt-jăn ămăra.» ");
INSERT INTO taq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Igla Bəṭrus d-ănăṭṭalib wa iyyăḍăn, əkkăn aẓəkka. ");
INSERT INTO taq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ošălăn issənăn-essăn măšan, ijmăḍ ănăṭṭalib wa iyyăḍăn Bəṭrus dăɣ-azzal, išwăr-t-in s-aẓəkka, ");
INSERT INTO taq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ăddunkăt, ăssijjă dăɣ-ammas-net, inhăy tefit tənsa d-iman-net măšan, wăr-ijješ ammas n-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Iwwăḍ-t-dd Simyon Bəṭrus ɣas, ijjăš ənta aẓəkka, inhăy tefit ta tənsăt d-iman-net, ");
INSERT INTO taq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","olăs daɣ ahănay n-taswəḍt ta s-kăla təttăl eɣăf n-Ɣisa, tənsa d-iman-net s-edes, toḍha. ");
INSERT INTO taq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ijjăš-dd fălla-s ḍarăt-a-wen ănăṭṭalib wa iyyăḍăn t-dd-išwărăn s-aẓəkka, inhăy, omăn; ");
INSERT INTO taq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","făl-a-s, a-wa-dăɣ jăn ărtayăn d-Ɣisa iket-net, wăr-əfhemăn a-wa ənnăn əlkəttabăn dăɣ-isălan-net, a-s ənnăn a-s, ilzam ad-t-iba təzzar, inkăr-dd jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ǝqqălăn ḍarăt-a-wen ihănan-năsăn. ");
INSERT INTO taq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tăqqimă-dd ḍara-săn Măryăma, təbdad edes i-aẓəkka, hall. Halla dihen-dăɣ har šik-dăɣ tăssijjă dăɣ-ammas n-aẓəkka, ");
INSERT INTO taq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","tənhăy əssin ănjălosăn ăssiimlălnen, ăqqimăn dăɣ-edăgg wa s-kăla dăɣ-s tənsa tafəkka n-Ɣisa. Ăqqiima iyyăn dăɣ-edăgg wa s-kăla dăɣ-s insa eɣăf n-Ɣisa, ăqqiima wa iyyăḍăn dăɣ-edăgg wa s-kăla dăɣ-s ənsăn iḍarăn-net. ");
INSERT INTO taq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ǝssəstănăn ănjălosăn Măryăma, ənnăn-as: «Măryăma, ma kăm-isalhen?» Tənnʼ-asăn: «Tafəkka n-Ălɣalim-in a təmmăḍkălăt, wăr-əssenăɣ ənde d-tăt-jăn ămăra.» ");
INSERT INTO taq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tənna a-wen ɣas, tăšnăšlăm, tənhăy Ɣisa ibdad măšan, indăr-as ad-t-təzzəy. ");
INSERT INTO taq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Imməjrăd-as, innʼ-as: «Tamăḍt, ma kăm-isalhen? Ma dăɣ-m ăba?» Ămmiijrăd-as măšan, tăɣel Măryăma măssi-s n-ašəkrəš a has-ămmijrădăn, tənnʼ-as: «Ya ăhaləs-i-dăɣ, kunta kăyy a iḍkălăn tafəkka n-Emăli-nin, əttarăɣ dăɣ-k idəm n-ad-hi-səknəd diha tăt-jed i-ad-tăt-əḍkəlăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iɣrʼ-et Ɣisa s-isəm-net, innʼ-as: «Măryăma!» Təggăd təzzar, tənnăḍ-dd săr-s, tənnʼ-as dăɣ-Ɣăbranəyya: «Rabbuni»; a-wen ălmăɣna-net: «Măssi-ɣ.» ");
INSERT INTO taq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Innʼ-as Ɣisa ălwăqq-wen: «Wăr hi-ḍesăd, tawəɣəd-ahi făl-a-s, wăr-oseɣ išənnawăn-i iha Abba-nin hărwa. Ămăra, əgləw, lăɣăt i-ayətma-ɣ a-s əkkeɣ Abba-nin-i s-ənta daɣ a-s Abba-năwăn, əkkeɣ Măssi-ɣ-i n-Măssinăɣ-i s-ənta a-s Măssinăɣ-i n-Măssi-wăn.» ");
INSERT INTO taq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Təkkă Măryăma ta n-Mulăždaləyăt inəṭṭulab, tənnʼ-asăn: «Năkk, ənhayăɣ Emăli». Ad-dăɣ-săn tajj isălan n-a-wa has-innă Ɣisa. ");
INSERT INTO taq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ehăḍ n-ašăl-wənnin-dăɣ n-ălxad, ăžžiimmăɣăn inəṭṭulab dăɣ-ehăn iyyăn, ăṭṭubben imawăn-net făll-iman-năsăn a-wa hasăn-təja tuksəḍa n-imănokalăn n-kăl-Ălyăhud. Wăr tăn-hen isălan a-s ənta iman-net da-dăɣ dd-ibdădăn jere-săn, innʼ-asăn: «Insʼ ălxer n-Măssinăɣ fălla-wăn.» ");
INSERT INTO taq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ijʼ-asăn isofan, ad-tăn-isakna ifassăn-net d-tajəẓẓelt-net. Ălwăqq-i-dăɣ t-ənhăyăn, əjăn inəṭṭulab tedăwit-i-dăɣ măqqărăt. ");
INSERT INTO taq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Innʼ-asăn Ɣisa: «Insʼ ălxer n-Măssinăɣ fălla-wăn. Ămašal wa ijă Abba dăɣ-ifassăn-in, jeɣ-t năkk-dăɣ ămăra dăɣ-ifassăn-năwăn.» ");
INSERT INTO taq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ḍarăt-a-wen, ăshăḍ Ɣisa jənnəj-iɣăfawăn-năsăn, innʼ-asăn: «Uhənăt Unfas Šăddijăn, ");
INSERT INTO taq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ere wa s-tənšăm ibăkkaḍăn-net, ad-ijrəw tenăšše-năsăn, ere wa s-tăn wăr tənšem, wăr mad-ijrəw tenăšše-năsăn.» ");
INSERT INTO taq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ašăl wa d-jăn isălan-wi-dăɣ, wăr t-illa iyyăn dăɣ-inəṭṭulab wi n-măraw d-əssin s-isəm-net Tomi wa s-itawănna Ekne. ");
INSERT INTO taq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Osă-dd ɣas, ənnăn-as inəṭṭulab wi iyyăḍnen: «Išrăy-kăy-dd Emăli Ɣisa.» Unjăy s-ad-tăn-ifləs, innʼ-asăn: «Năkk ɣas, a əkkăsăɣ wăr t-ənheyăɣ s-tiṭṭawen-in, ənhəyăɣ daɣ idraš n-ibuyəsăn dăɣ-ifassăn-net, ăjăɣ daɣ assəkăḍ-in dăɣ-adăriš n-ibuyəsăn, ăjăɣ ăfuss-in dăɣ-tajəẓẓəlt-net ta inbăj allaɣ, wăr mad-əfləsăɣ a-s dd-inkar jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ašăl wa n-əttam ḍarăt-a-wen, ăžžiimmăɣăn inəṭṭulab dăɣ-ehăn ăṭṭubben, ihʼ-en ămăra Tomi. Wăla hin-əjrăhăn a-s dd-ibdăd Ɣisa jere-săn, innʼ-asăn: «Insʼ ălxer n-Măssinăɣ fălla-wăn.» ");
INSERT INTO taq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Innă Ɣisa i-Tomi ḍarăt-a-wen: «Ahəẓ-ahi-dd, səjrăh ifassăn-in, hənda assəkăḍ-năk, ăjʼ-e dăɣ-ăfuss-in, təjəd-t daɣ dăɣ-tajəẓẓelt-in, wăr tăsɣărăd ulh-năk.» ");
INSERT INTO taq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ăwwežăb-as Tomi, innʼ-as: «Emăli-nin, Măssi-ɣ Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Innʼ-as Ɣisa: «Kăyy, tənhăyăd-ahi təzzar tomănăd, tənḍəḍ i-ăddinăt wi hi-wăren-ənhey măšan, omănăn.» ");
INSERT INTO taq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ija Ɣisa dat-inəṭṭulab-net ijităn n-Măssinăɣ ăjjootnen wăren əkteb dăɣ-əlkəttab-wa-dăɣ ");
INSERT INTO taq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","măšan, a-wa dăɣ-săn iktăbăn dăɣ-əlkəttab-wa-dăɣ iket-net, iktab dăɣ-təssəba n-ad-tamənăm a-s Ɣisa a-s Ălmasex wa n-Rure-s n-Măssinăɣ, ere omănăn s-isəm-net-dăɣ, ad-ijrəw tămudre ta tăɣlălăt. ");
INSERT INTO taq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ḍarăt-a-wen-dăɣ ijăn, ăsnăfalăl-dd Ɣisa daɣ iman-net i-inəṭṭulab-net dăɣ-asălim n-ejănš wa s-itawănna Tibăryad. Ǝnta da əmmək wa s-hasăn-dd ăsnăfalăl iman-net: ");
INSERT INTO taq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ašăl iyyăn, ăžžiimmăɣ Simyon Bəṭrus, Tomi wa n-ekne d-Natanăhil wa n-taɣrəmt ta n-Kăna təhăt teje ta n-Galila d-dăgg-Zăbdi d-əssin inəṭṭulab iyyăḍ daɣ, ");
INSERT INTO taq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ăqqiimăn har šik-dăɣ, innʼ-asăn Simyon Bəṭrus: «Năkk, əkkeɣ ejănš i-ad-əhhuyeɣ imănan.» Ǝnnăn-as inəṭṭulab wi iyyăḍnen: «Ăqqəl-anăɣ, năddew dăr-k.» Ǝzjărăn, əjjăšăn turăft n-aman, əglăn. Okăy-tăn ehăḍ-wen-dăɣ iket-net, wăr t-illa a ărmasăn. ");
INSERT INTO taq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ăffăw ɣas, iwăr-dd Ɣisa asălim n-ejănš măšan, indăr-asăn ad-t-əzzəyăn. ");
INSERT INTO taq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iɣrʼ-en, innʼ-asăn: «Ilyaḍăn, ajăn wăr lem a təkšăm?» Ǝnnăn-as: «Ăbo!» ");
INSERT INTO taq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Innʼ-asăn: «Ăjrăt ămăra tătart-năwăn s-ašrut wa n-aɣil n-turăft n-aman, ad-tărməsăm imănan.» Jărăn tătart-năsăn s-ašrut-wen-dăɣ tăn-issəkna, əttărăn ad-tăt-dd-ărkəbăn dăɣ-aman măšan, təndăr-asăn făl aḍănay-i-dăɣ təja imănan. ");
INSERT INTO taq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Inhăy ănăṭṭalib wa ikna Ɣisa tărha a-wen ɣas, inna i-Bəṭrus: «Ijmaḍ-t ăššăk a-s a-wa Emăli-nănăɣ.» Islă Simyon Bəṭrus a-s a-wa Emăli Ɣisa ɣas, iḍkăl emăls-net wa ikkăs i-ălxidmăt, ijʼ-e dăɣ-err-net, ijăr iman-net dăɣ-aman, išyăf, ikkʼ asălim. ");
INSERT INTO taq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ăɣyămmen-dd inəṭṭulab wi iyyăḍnen turăft, ăhoben-dd tătart ta təḍkărăt imănan ed, wăr t-illa jere-săn d-asălim n-ejănš ar sănatăt timaḍ n-aɣil. ");
INSERT INTO taq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ǝwwăḍăn asălim n-aman ɣas, ənhăyăn efew irɣan făll-naŋŋăn imănan d-tajəlla, ");
INSERT INTO taq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","innʼ-asăn Ɣisa: «Awəyăt-dd a lăn imănan dăɣ-wi s-iket tăn-dd-tărmăsăm.» ");
INSERT INTO taq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ijjăš Simyon Bəṭrus turăft ta n-aman, ăhobăt-dd tătart s-asălim n-aman, osăn-tăt, ihʼ-et a iwwăḍăn temeḍe d-səmmosăt timərwen n-emăn d-kăraḍ dăɣ-wi šuharnen măšan, hakd a-wen-dăɣ, wăr ser tătart. ");
INSERT INTO taq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ǝŋŋăn imănan d-tajəlla ɣas, innʼ-asăn Ɣisa: «Ǝyyăwăt, mănsăwăt.» Itajj a-wen-dăɣ iket-net măšan, wăr tăn-iha-i ihălăn asəstan-net d-ere wa ămoos ed, əssanăn ămăra a-s Emăli iman-net a-wa. ");
INSERT INTO taq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iḍkăl Ɣisa tajəlla, ăẓun-asăn-tăt, ăẓun daɣ imănan jere-săn. ");
INSERT INTO taq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ǝnta-da-dăɣ anfiləl wa s-kăraḍ dd-ija Ɣisa i-inəṭṭulab-net ḍarăt tanăkra-net jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ǝkšăn ɣas, innă Ɣisa i-Simyon Bəṭrus: «Simyon ăgg Yunəs, ak torded a-s tojăr tărha ta hi-jed, ta hi-jăn imidiwăn-năk?» Innʼ-as Simyon: «Emăli, təssanăd a-s ărheɣ təmmidəwa-năk.» Innʼ-as Ɣisa: «Adiš, ăj i-inəṭṭulab-in taɣălift ta ităjj amăḍan i-ikərwatăn-net.» ");
INSERT INTO taq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ijʼ-as Ɣisa asəstan wa s-əssin, innʼ-as: «Simyon ăgg Yunəs, ak torded a-s tărhed-ahi?» Innʼ-as Simyon: «Năkk lab, ărheɣ təmmidəwa-năk.» Innʼ-as Ɣisa: «Adiš, ăj i-inəṭṭulab-in tamăḍint ta ităjj amăḍan i-tihatten-net.» ");
INSERT INTO taq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ijʼ-as Ɣisa asəstan wa s-kăraḍ, innʼ-as: «Simyon ăgg Yunəs, ak tidət-dăɣ a-s tărhed təmmidəwa-nin?» Inxăs a-wen-dăɣ iman n-Bəṭrus d-a-s har kăraḍ ihăndăggan isastan-t d-a-s irhʼ-e meɣ? Innʼ-as Bəṭrus ămăra: «Emăli, wăr t-illa a-s wădden təssanăd-t, təssanăd a-s jeɣ-ak tărha təmdat.» Innʼ-as Ɣisa: «Adiš, ăj i-inəṭṭulab-in taɣălift ta ităjj amăḍan i-tihatten-net. ");
INSERT INTO taq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ălleɣeɣ-ak s-tidət tădduuttet a-s dăɣ-təmmiwəḍa-năk, salsed iman-năk, erhet-năk ɣas a kăy-išilləwăn măšan, afăl wăššarăd, ere wăr tămoosăd a kăy-madăn-isăls, tăttărmăsăd, tăttălwăyăd s-edăgg wăr tărhed.» ");
INSERT INTO taq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Innʼ-as a-wen-dăɣ i-ad-isəlməd Bəṭrus ălxal n-tamăttant ta has-tăqqălăt madăt-tumas tajuhe ta s-mad-isəmɣăr Măssinăɣ. Ijʼ-as Ɣisa măjrăd-wen-dăɣ ɣas, innʼ-as: «Ǝlkəm-ahi.» ");
INSERT INTO taq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ăšnăšlăm Bəṭrus ḍara-s, inhăy ănăṭṭalib wa irha Ɣisa, ilkam-asăn. Ănăṭṭalib-wen-dăɣ a dd-insăn făll-idmarăn n-Ɣisa ehăḍ wa dăr-s ohărăn amənsi, ənta-en-dăɣ a issəstănăn Ɣisa ehăḍ-wen a-s has-innă: «Ălɣalim, əndek dăɣ-năɣ wa kăy-madăn-isəssăɣdăr?» ");
INSERT INTO taq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Inhăy-t Bəṭrus ilkam-asăn ɣas, innă i-Ɣisa: «Emăli, wa hi-š ănăṭṭalib, ma dăɣ-s ilkamăn?» ");
INSERT INTO taq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Innʼ-as Ɣisa: «Kud-ărheɣ ad-iddar har dd-ăqqəlăɣ, ma tăkkuulăd dăɣ-a-wen? Kăyy, əlkəm-ahi ɣas.» ");
INSERT INTO taq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Măjrăd-wen-dăɣ ija Ɣisa i-Bəṭrus a dd-orăwăn a-wa s-jannen inalkimăn n-Ɣisa, ănăṭṭalib-en-dăɣ, wăr dăɣ-s təlkem tamăttant măšan, wăr has-inna Ɣisa wăr mad-ămmăt, ănn-ak a inna i-Bəṭrus: «Ajăn kud-ărheɣ ad-iddar har dd-ăqqəlăɣ, ma tăkkuulăd dăɣ-a-wen?» ");
INSERT INTO taq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ănăṭṭalib-wen-dăɣ făll-ija Ɣisa tajuhe-ten-dăɣ, a ăjjəyhăn i-isălan-wi-dăɣ, iktăb-tăn, nəssan daɣ a-s tajuhe-net, tădduuttăt. ");
INSERT INTO taq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ǝllan-t hărătăn ăjjootnen ija Ɣisa wăren əkteb diha-dăɣ. A-wa ija, ija əjut wa-dăɣ s-ənnăr ittăr ăwadəm akătab-net s-iyyăn-iyyăn, wăr-ordeɣ a-s tăddobăt tăkost n-ăkall-i-dăɣ aggay n-əlkəttabăn-win-dăɣ he-siwəlnen dăɣ-isălan-net. Amin!");
INSERT INTO taq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A-wa năkk hin-iktabăn i-enəssemɣăr-in Tăyofil: Dăɣ-əlkəttab-in wa ăzzarăn, ăssoɣălăɣ-ak isălan n-a-wa s-issəntă Ɣisa iji-net d-a-wa issăɣra iket-net ");
INSERT INTO taq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hundăɣ har ašăl wa d-imməḍkăl s-išənnawăn, ḍarăt a-s ăsimătăr inəmmušal wi ăsnăfrăn s-tărna n-Unfas Šăddijăn. ");
INSERT INTO taq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ǝntăneḍ-en-dăɣ a-s dd-ăsnăfalăl iman-net s-tizarăt ḍarăt tamăttant-net i-ad-tăn-isəlməd s-timtăr ăjjootnen a-s iddar. Ija ḍarăt tanăkra-net jer-inəmmuttan əkkoẓăt timərwen n-ašăl izzaɣ jer-inəṭṭulab-net, itajjʼ-asăn isălan n-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ašăl iyyăn, ohar dăr-săn amənsi har šik-dăɣ, innʼ-asăn: «Wăr felăm aɣrəm wa n-Yărussălam, əqqəlăt i-a wa s-hi-təslăm saɣreɣ-t s-hawăn-ijjăš Abba ărkăwăl-net; ");
INSERT INTO taq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","tidət, Exya, aman a dăɣ-issəlmăɣ ăddinăt măšan kăwăneḍ, dăɣ-hărăt n-išilan, ad-tətwəsəlmăɣăm dăɣ-Unfas Šăddijăn-i dd-e-izzubben fălla-wăn.» ");
INSERT INTO taq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ăžžiimmăɣăn dihen-dăɣ a-s t-əssəstănăn, ənnăn-as: «Emăli, ajăn ăzzăman wa dăɣ-dd-taqqăl təmmənukəla Iṣrayil, osă-dd?» ");
INSERT INTO taq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Innʼ-asăn: «Wădden kăwăneḍ a iwar almud n-tăqqăn wăla ăssaɣăt wa iɣtăs Abba dăɣ-ălxikmăt-net; ");
INSERT INTO taq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kăwăneḍ, ad-təjrəwăm tărna, ad-fălla-wăn dd-izzubbət Unfas Šăddijăn, tumasăm tijuhawen-in dăɣ-aɣrəm wa n-Yărussălam, dăɣ-teje ta n-Ălyăhudəyăt iket-net d-ta n-Sămari təkkəm har diha dd-təmda ăddunya.» ");
INSERT INTO taq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Innʼ-asăn a-wen ɣas, imməḍkăl data-săn s-išənnawăn; əbdadăn, əswaḍăn dăɣ-s har hasăn-t tənjăr tejărăkt. ");
INSERT INTO taq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ăjoẓăyăn išənnawăn-i s-imməḍkăl a-s hasăn-dd-ănfalălăn əssin meddən ăssiimlălnen, ənnăn-asăn: ");
INSERT INTO taq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Ya kăl-Galila, ma s-təbdadăm tăjoẓăyăm išənnawăn? Ɣisa wa imməḍkălăn jere-wăn s-išənnawăn, ilkam a dd-iqqəl s-əmmək-wa-dăɣ s-t-tənhăyăm ikkʼ-en.» ");
INSERT INTO taq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Fălăn inəmmušal ḍarăt-a-wen taḍaɣt ta n-əzzăytunităn, əqqălăn aɣrəm wa n-Yărussălam-i hasăn-t-illăn əḍḍəkuḍ n-tăẓune n-ăssaɣăt n-răjjoš. ");
INSERT INTO taq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ǝwwăḍăn-in aɣrəm, əkkăn soro n-ehăn-wa s-əzzăyăn ažəmmăɣ dăɣ-s. A-wen: Bəṭrus, Exya, Yaqub, Idris, Fəlibb, Tomi, Bartălămma, Mătti, Yaqub ăgg Ălfa, Simyon wa s-itawănna Ăššažeɣ, Hudd wa n-ăgg Yaqub. ");
INSERT INTO taq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ǝjlayăn iket-dăɣ-năsăn dăɣ-a-wa hăn, oharăn iyyăn n-ulh dăɣ-temădilt n-Măssinăɣ əntăneḍ d-tiḍeḍen təha Măryăma ta n-ma-s n-Ɣisa d-ayətma-s n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ăžžiimmăɣăn dihen-dăɣ, ămoosăn temeḍe n-ăwadəm d-sănatăt timərwen a-s dd-ibdăd Bəṭrus jere-săn, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ayətma-ɣ, a-wa innă Unfas Šăddijăn s-emm n-ănnăbi Dawəd, dăɣ-isălan n-Yăhudəs-i dd-ăslălăn ăddinăt wi ărmăsnen Ɣisa, ijă; ");
INSERT INTO taq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","kăla dăɣ-năɣ ăḍḍiin, kăla t-illa ijraw folăt-net dăɣ-ămašal wa hanăɣ-issăɣlăf Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aẓrəf-wa xăramăn irmăs i-ad-ămašăl abăkkaḍ wa ofa, ižžənšă săr-s ašəkrəš wa dăɣ-dd-iha ăsikăṭṭăy făll-eɣăf-net, ăsfătăqqăt iman-net, ăẓun dăɣ-ammas, ăbrăẓẓăt-dd a-wa ihăn tăsa-net iket-net făll-ăkall; ");
INSERT INTO taq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","wăr t-illa ere izzaɣăn Yărussălam s-wădden han-t isălan n-a-wen-dăɣ, əglăn ăddinăt făw har ašəkrəš-wen-dăɣ dăɣ-t-ăba, əjăn-as isəm dăɣ-tawalt-năsăn: ‹Hăqqăldăma›, a-wen ălmăɣna-net: ‹Ašəkrəš wa n-ašni›. ");
INSERT INTO taq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ămăra, iktab dăɣ-əlkəttab wa n-Ăẓẓăbur a-s: ‹Iqqəlet ehăn-net timšar, wăr t-itiləset ăwadəm uzăɣ.› Iktab daɣ a-s: ‹Ijjəšet iyyăn edăgg-net.› ");
INSERT INTO taq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ilzam ămăra ad-nəsənnəfrən iyyăn dăɣ-meddən wi hanăɣ-hănen s-alkum i-Ɣisa dăɣ-takliwen-net d-uɣlawăn-net dăɣ-a-wa ikkăs Emăli Ɣisa illʼ-e jere-năɣ, ");
INSERT INTO taq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a-wen, ɣur-ašăl wa t-issəlmăɣ Exya dăɣ-aman har ašăl wa dd-inkăr jer-inəmmuttan təkkəd ašăl wa d-imməḍkăl jere-năɣ s-išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ăsnăfrănăn-dd əssin meddən, iyyăn Yusəf wa s-itawănna Bărsabas, jannen-as iyyăḍ Istus, wa iyyăḍăn Matiyas. ");
INSERT INTO taq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dălăn Măssinăɣ ḍarăt-a-wen, ənnăn: «Emăli, kăyy a issanăn a-wa ihăn ulh n-e d t-illăm ăgg-adəm, səlməd-anăɣ wa tăsnăfrănăd jer-meddən-wi-dăɣ n-əssin ");
INSERT INTO taq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","i-ad-ijjəš edăgg wa n-tənnəmušəla irfăḍ Yăhudəs, ikkʼ edăgg wa ija i-iman-net.» ");
INSERT INTO taq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jăn tisăɣeren ḍarăt-a-wen, oḍănăt făll-Matiyas, ăḍḍin ya făll-inəmmušal wi n-măraw d-iyyăn. ");
INSERT INTO taq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A-s dd-iwwăḍ ašăl n-ămudd n-kăl-Ălyăhud wa s-itawănna Fantăkawt, ăžžiimmăɣăn inəṭṭulab iket-dăɣ-năsăn dăɣ-iyyăn n-edăgg. ");
INSERT INTO taq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wăla a hin-əjrăhăn a-s dd-ifăl emăsli iyyăn olăhăn d-i n-tamăḍalt tăṣṣoohet išənnawăn, ănhăynăhăy edăgg-ənnin-dăɣ dăɣ-ăqqiimăn iket-net; ");
INSERT INTO taq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ibdăd-dd făll-hak iyyăn dăɣ-săn a olăhăn d-ilsawăn n-imămmălăn n-efew əbḍanen, ");
INSERT INTO taq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","iḍnăy-tăn Unfas Šăddijăn ălwăqq-wen-dăɣ, ad-tamăjradăn awalăn ăynaynen s-əmmək wa s-hasăn-issărɣăs Unfas turhajăt n-a-wen. ");
INSERT INTO taq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A-s ităjj a-wen-dăɣ, ăhhujjăjăn-dd kăl-Ălyăhud ăjjootnen ăddinnen s-Yărussălam, wăr t-illa ăkall s-wădden falăn-t-dd. ");
INSERT INTO taq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Təslă tamətte n-aɣrəm i-emăsli wa ijăn, tošăl-dd iket-net s-edăgg wa dăɣ-ija, təjraw-tăt tăkunt n-emăsli-wa-dăɣ d-a-wa s-hak ăwadəm-dăɣ, isall i-inəmmušal ămmijrădăn tawalt n-ăkall-wa-dăɣ dd-ifăl. ");
INSERT INTO taq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ǝqqălăn-dd ăddinăt ɣas, oran imawăn, təjraw-tăn tăkunt, jannen: «Kăhh! Wi ăddinăt hanăɣ-ămmiijrădnen, ajăn wădden teje ta n-Galila a tăn-lăt? ");
INSERT INTO taq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma n-əmmək n-a-s hasăn-nəsall ămmiijrădăn tawalen-nănăɣ? ");
INSERT INTO taq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Han-anăɣ ăddinăt dd-falnen Bartas, Midyas, Ilam, Mizəbbuṭamya, Ălyăhudəyăt, Kafadusya, Fon, Azya; ");
INSERT INTO taq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frižya, Banfilya, Miṣra, Libya, Qərwan, Roma, ");
INSERT INTO taq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","iyyăḍ dăɣ-năɣ kăl-Ălyăhud s-alăṣăl, iyyăḍ inalkimăn n-ăddin wa n-kăl-Ălyăhud, iyyăḍ dăɣ-năɣ kăl-Kritus, iyyăḍ Arabăn; măšan, nəsallʼ-asăn iket-dăɣ-nănăɣ tiimələn tihusay n-ijităn n-Măssinăɣ dăɣ-tawalen-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ǝqqălăn-dd ăddinăt ɣas oran imawăn, iqqan a-wa ijăn iɣăfawăn-năsăn, tinmənnin: «Ma ămoos ălmăɣna n-a-wa-dăɣ?» ");
INSERT INTO taq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ǝggădăn-dd iyyăḍ, jăn inəṭṭulab tekăškăšt, ad-jannen: «A-di, asməd a dăɣ-ăyyiwănăn.» ");
INSERT INTO taq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ibdăd-dd Bəṭrus jer-imidiwăn-net wi n-măraw d-iyyăn, iḍkăl emăsli-net, innă i-tamətte: «Meddən, kăwăneḍ-i n-iməhhujjaj, kăwăneḍ-i n-kăl-Ălyăhud əzzăɣnen Yărussălam, săjdăt-ahi iket-dăɣ-năwăn, təjrăhăm a-wa hawăn-e-ănnăɣ dăɣ-ălmăɣna n-a-wa ijăn jere-wăn ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wădden a-wa tordăm a ijan, meddən wi hannăyăm, wăr-əswen asməd dăɣ-săn ikkasăn ənniyăt, wăr-ămmukkăn a-wen ed agdəlset-dăɣ iket ija. ");
INSERT INTO taq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","A-wa ijăn ašăl-i-dăɣ, wăr-ămoos ɣas ar tasətbat n-a-wa innʼ ănnăbi Yuwil ăzzăman wa d-ălolăy, innă; innă Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Ǝnta da a-wa ilkămăn dăɣ-išilan wi dd-malənen, A dd-zəzzubbuɣ Unfas-in făll-e d t-illăm ăgg-adəm, ad-ăkfăɣ măjrăd-in mədda-wăn d-ešše-wăn, səssiwəḍăn-t-in dăgg-adəm, ad-dd-ənfilələn hărătăn ăttunkălnen i-imawaḍăn-năwăn, əhhərjun imɣarăn-năwăn tikunen; ");
INSERT INTO taq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","išilan-en, a dd-zəzzubbuɣ Unfas-in făll-eklan-in d-tiklaten-in, əluləyăn iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ad-dd-əjmăḍăn hărătăn ăssuksăḍnen išənnawăn, ăjăɣ ijităn n-Măssinăɣ făll-ărori n-ăkall, inɣəl ašni, ărɣ efew, inkăr ăho s-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ad-tămaɣăy tăfukt, əjənăt tihay, išwaɣ ewăr šund ašni təzzar, ass-dd ašăl wa măqqărăn n-ălxurmăt iɣtăs Emăli. ");
INSERT INTO taq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ašăl-en, ere iɣrăn isəm n-Emăli i-tinahăɣen, ad-iɣləs.› ");
INSERT INTO taq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ya kăl-Iṣrayil, săjdăt i-isălan-wi-dăɣ: Ɣisa wa n-Năṣirăt, təssanăm kăwăneḍ iman-năwăn a-s ăhaləs ăsinăfrăn Măssinăɣ a ămoos, issətbăt a-wen dat-tiṭṭawen-năwăn s-tikunen d-tišušab d-ijităn n-Măssinăɣ wi ija jere-wăn, ");
INSERT INTO taq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","dăɣ-a-wa ităjj Măssinăɣ d-təlluləya-net, oyyʼ-iwăn tărmăsăm-t, jăm iman-net s-ifassăn n-inəẓẓulam wi t-əṣlăbnen făll-tajəttewt; ");
INSERT INTO taq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","tidət, ămmut măšan, ikkăs-t-dd Măssinăɣ dăɣ-tamăttant ta t-təẓbăbăt, ed wăr t-illa əmmək s-t-təṭṭăf dăɣ-tišəm-net. ");
INSERT INTO taq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Isălan n-a-wen-dăɣ a dăɣ-ălolăy ănnăbi Dawəd a-s innă: ‹Hannăyăɣ hak ăssaɣăt Emăli dat-i; iwar aɣil-in i-ad-ozja ənniyăt-in. ");
INSERT INTO taq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ăsidăwăt a-wen ulh-in, olwa iləs-in ed jarăɣ ăṭṭăma n-ad-tăns tafəkka-nin dăɣ-ălxer, ");
INSERT INTO taq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","wăr-e təyyəd iman-in ənsan dăɣ-ider n-ăkall, wăr-e təyyəd Eməššeddəj-năk rakkăh tafəkka-net dăɣ-aẓəkka. ");
INSERT INTO taq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kăyy a hi-issəknăn tabarăt ta ha tămudre, sămmeḍ ulh-in, ăddiwăt ed təlled-t edes-in.› ");
INSERT INTO taq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Meddən, kăwăneḍ-i n-ayətma-ɣ, əkkasăɣ ăššăk dăɣ-a-wa hawăn-janneɣ: Amɣar n-amăzzaɣ Dawəd, ăba-t, iẓka; aẓəkka-net daɣ har ašăl-i-dăɣ, illʼ-e diha-dăɣ jere-năɣ. ");
INSERT INTO taq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ǝnta-i n-ănnăbi, issan făll-ărkăwăl wa has-ihăḍ Măssinăɣ a-s has-innă: ‹Ilkam ad-isəbdəd dăɣ-edăgg-net iyyăn dăɣ-ihăyawăn-net dăɣ-təmmənukəla.› ");
INSERT INTO taq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A-s ijănna Dawəd a-wen, ihannăy dăɣ-ijəj tanăkra n-Ălmasex jer-inəmmuttan ed ăru d-ălolăy Dawəd dăɣ-isălan n-a wa s-ilkam ad-ăj. Ǝnta-en-dăɣ a dăɣ-ăssewăl Dawəd a-s innă: ‹Wăr-e təyyəd tafəkka-nin təjar-in dăɣ-aẓəkka, wăr-e təyyəd tafəkka-nin rakkăh dăɣ-aẓəkka.› ");
INSERT INTO taq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ɣisa-i s-hawăn-heɣ isălan-net, năjjəyha i-asənkar wa t-dd-ija Măssinăɣ jer-inəmmuttan təzzar ");
INSERT INTO taq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","iḍkăl-t s-išənnawăn, ăsɣăymʼ-e daw-aɣil-net i-ad-imnukəl, ikfʼ-e Abba Unfas Šăddijăn wa s-ijjăš ărkăwăl-net, ăzzăbbăt-t-dd daɣ fălla-năɣ, ăsnăflăy-anăɣ dăɣ-s, ənta-den-dăɣ a-wa dd-orăwăn a-wa s-săllăm d-a-wa hannăyăm ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ănnăbi Dawəd ya, təssanăm a-s wăr-imməḍkăl s-išənnawăn ed ənta iman-net a innăn: ‹Innă Emăli Măssinăɣ i-Emăli-nin: Ǝyyăw, ɣayəm, tăxkəmăd daw-aɣil-in ");
INSERT INTO taq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hundăɣ har ăjăɣ išənja-năk isəkkukal daw-iḍarăn-năk.› ");
INSERT INTO taq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ašăl-i, əlmədnet kăl-Iṣrayil iket-dăɣ-năsăn a-s Ɣisa wa təṣlăbăm făll-tajəttewt, ənta a ija Măssinăɣ Emăli d-Ălmasex!» ");
INSERT INTO taq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iḍăs măjrăd wa ija Bəṭrus ulhawăn n-ăddinăt wi has-ăsijădnen, ənnăn-as ənta d-inəmmušal wi iyyăḍnen: «Ayətma-năɣ, ma hanăɣ-iwarăn?» ");
INSERT INTO taq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Innʼ-asăn Bəṭrus: «Utabăt, tətwəsəlmăɣăm iket-năwăn dăɣ-aman s-isəm n-Ɣisa Ălmasex, i-ad-təjrəwăn tenăšše n-ibăkkaḍăn-năwăn, ăkfʼ-iwăn Măssinăɣ Unfas Šăddijăn, ");
INSERT INTO taq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ed ărkăwăl wa ijjăš Măssinăɣ, kăwăneḍ d-ihăyawăn-năwăn d-ăddinăt wi əzzăɣnen dăɣ-ijəj, d-e d t-illăm ere dd-iɣra Emăli-nănăɣ Măssinăɣ s-iman-net a-s t-ija.» ");
INSERT INTO taq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ijʼ-asăn Bəṭrus isălan ăjjootnen, isatbat hărătăn data-săn, isamătar-tăn, ijannʼ-asăn: «Agəẓăt iman-năwăn dăɣ-əzzurəyăt-ta-dăɣ təfrăɣăt.» ");
INSERT INTO taq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ăddinăt wi omănnen s-a-wa ătwănnăn, ătwăsălmăɣăn dăɣ-aman; ămoos a-s, kăraḍ afḍăn n-ăwadəm ašăl-wen-dăɣ a dd-əwwăḍnen făll-imumənăn. ");
INSERT INTO taq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ǝkfăn imumənăn iket-dăɣ-năsăn iman-năsăn i-a-wa tăn-săɣren inəmmušal, oharăn ittus, tuẓanăn amənsi wa šăddijăn n-tasăktot, təddalăn Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Təjjăš tuksəḍa n-Măssinăɣ tamətte iket-net, făl-a-s tamašalăn inəmmušal tišušab d-ijităn n-Măssinăɣ ăqqannen eɣăf. ");
INSERT INTO taq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ănimăṭṭafăn imumənăn iket-dăɣ-năsăn jer-iman-năsăn, əzzaɣăn iyyăn n-edăgg, tihərən a-wa əṭṭăfăn, ");
INSERT INTO taq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","žănšʼ-en-in a-wa lăn dăɣ-ehăre, ad-tuẓanăn ălqim-net s-a-wa dăr-ogdăhnăt timɣutar n-hak iyyăn dăɣ-săn. ");
INSERT INTO taq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ăkoyădăn hak ašăl s-iyyăn n-ənniyăt dăɣ-ažəmmăɣ dăɣ-təfărre n-ehăn n-ămudd wa măqqărăn, tihərən imənsiwăn dăɣ-ihănan-năsăn s-iman ăddiwătnen; a-wa tăjjăn iket-net, ilʼ əmmək, ");
INSERT INTO taq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","tiimələn Măssinăɣ, ăssiimɣărăn-tăn ăddinăt iket-năsăn. Isawaḍ-dd Emăli hak ašăl făll-ălžămaɣăt-năsăn ăddinăt wi iɣallăs. ");
INSERT INTO taq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ašăl iyyăn, ikka Bəṭrus ehăn n-ămudd wa măqqărăn, ăddeew d-Exya i-ămudd wa n-tezzar. ");
INSERT INTO taq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ălwăqq-wen-dăɣ daɣ, ad-dd-ămewăy s-emm n-ehăn n-ămudd wa s-itawănna: «Tihusay», ăhaləs s-a-s dd-iwa-dăɣ ibdan. Hak ašăl dihen-dăɣ a t-sănsen ăddinăt-net i-ad-itattăr takute dăɣ-ăddinăt wi dd-tajjăšnen ehăn n-ămudd. ");
INSERT INTO taq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Inhăy Bəṭrus d-Exya ăbokăn ujəš n-ehăn n-ămudd ɣas, iẓẓăl-asăn ăfuss. ");
INSERT INTO taq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iknʼ-e Bəṭrus d-Exya azəjjəzz təzzar, innʼ-as Bəṭrus: «Ǝkən dăɣ-năɣ akăyad.» ");
INSERT INTO taq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iknă dăɣ-săn ăhaləs akăyad, ijar ăṭṭăma n-ad-t-əkfən hărăt ");
INSERT INTO taq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","măšan, innʼ-as Bəṭrus: «Wăr leɣ orăɣ wălʼ aẓrəf măšan, a-wa leɣ, hakkăɣ-ak-t s-isəm n-ƔisaĂlmasex wa n-Năṣirăt: əbdəd, ărjəš.» ");
INSERT INTO taq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ăshătăl-as-dd Bəṭrus s-ăfuss-net wa n-aɣil, issəbdăd-t. Iqqăl-dd ăṣṣahăt iḍarăn-net d-timẓəẓẓəden-net ăssaɣăt-wen-dăɣ; ");
INSERT INTO taq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ijă-dd tiyyăt teggedt, irjăš, ănmăjjaš dăr-săn ehăn n-ămudd, itaggăd a-wa-dăɣ has-təja tedăwit, itiiməl Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ǝnhăyăn-t ăddinăt iket-năsăn irjaš, itiiməl Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","əzzăyăn-t ɣas, ad-jannen: «Ak, wa wădden emădăl wa s-hărkuk ăqqiima dat-emm wa ăhusken n-ehăn n-ămudd wa măqqărăn.» Ǝnhăyăn a-wa dăɣ-s ijăn ɣas, ăqqănăn iɣăfawăn-năsăn, tofʼ-en tăkunt n-a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iltăɣ ăhaləs-ənnin Bəṭrus d-Exya, unjăy făw dăr-săn ibḍa. Tošăl-dd tamətte iket-net s-edăgg wa dăɣ-əbdădăn s-itawănna tisuḍaf n-ehăn wa n-Sulăyman, ăɣlăyɣălăyăn-tăn-dd ăddinăt tufa tăkunt n-a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Inhăy Bəṭrus awnaf wa hasăn-ămoosăn ɣas, innʼ-asăn: «Kăl-Iṣrayil, ma s-dăɣ-năɣ təkyadăm s-əmmək-wa-dăɣ šund a-s năkkăneḍ d-iman-nănăɣ, meɣ s-iqqud-nănăɣ dat-Măssinăɣ a-s năzozăy ăhaləs-i-dăɣ? ");
INSERT INTO taq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Măssinăɣ wa n-Ibrahim d-Isxaqq d-Yaqub, ənta-i n-Măssi-s n-abbatăn-nănăɣ, ənta a iḍkălăn s-ălxurmăt-net, akli-net Ɣisa-wa tăstărmăsăm təzzar, tăkkuddălăm-t dat-Bilatəs-i a-s ităjj a-wen-dăɣ, ăbook ad-t-in-isəwwəyy măšan, ");
INSERT INTO taq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kăwăneḍ tăkkuddălăm Eməššeddəj d-Ămaɣdal, təttărăm dăɣ-ămănokal ad-hawăn-dd-isəwwəyy emăjj n-iman, ");
INSERT INTO taq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","jăm iman n-ămănokal wa ihakkăn tămudre măšan, issənkăr-t-dd Măssinăɣ jer-inəmmuttan, năkkăneḍ a-s tijuhawen-net. ");
INSERT INTO taq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ǝlmədăt a-s s-tărna n-isəm n-Ɣisa d-təssəba n-immun wa săr-s nəja, a făl hannăyăm ăhaləs-wa-dăɣ təzzayăm, har t-dd-iqqăl ăṣṣahăt-net data-wăn; immun s-isəm n-Ɣisa a ăzozăyăn ăhaləs-i-dăɣ hannăyăm ibdăd data-wăn. ");
INSERT INTO taq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ămăra ayətma-ɣ, əssanăɣ a-s a-wa təjăm kăwăneḍ d-imizărăn-năwăn, ălžăhalăt a dăɣ-t təjăm, ");
INSERT INTO taq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","a-wa ijăn, a otas Măssinăɣ i-ad-isətbət a-wa s-ăru d-ălolăyăn ănnăbităn dăɣ-isălan-net, a-s ənnăn a-s Ălmasex, ad-inhəy aɣăna təzzar imnukəl. ");
INSERT INTO taq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","A-wa ənnăn, ijă, a-wen-dăɣ a făl ămăra, mujrəẓăt ibăkkaḍăn-năwăn, tutabăm i-ad-hin-aməs Măssinăɣ ibăkkaḍăn-năwăn, ");
INSERT INTO taq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","izəzzubbət-dd fălla-wăn išilan n-ălxer, i-ad-hawăn-dd isuɣəl Ɣisa-i n-Ălmasex ăsnăfrăn-i s-ămăra-dăɣ, ");
INSERT INTO taq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ihʼ išənnawăn har ašăl wa d-mad-isəynəy Măssinăɣ hărăt iket-net, s-əmmək wa s-ăru tăn-innă s-imawăn n-ănnăbităn-net wi n-iməššeddəjăn. ");
INSERT INTO taq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Dăɣ-isălan n-a-wen-dăɣ, ad-innʼ ănnăbi Mosa: ‹Ad-hawăn-dd-isəssiwəy Emăli Măssinăɣ ănnăbi dăr-toharăm temiḍt, dăr-i olăhăn, săjdăt i-a-wa hawăn-e-ănn iket-net. ");
INSERT INTO taq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ere unjăyăn s-asjəd-has, ad-ăbas ăḍḍiin dăɣ-tamətte n-Măssinăɣ, ămmătet.› ");
INSERT INTO taq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ămăra, ănnăbităn iket-năsăn, ɣur-Sumăyla har wi t-dd-əšrăynen, ălolăyăn iket-dăɣ-năsăn dăɣ-isălan wi s-hanăɣ-sallăm nəttajjʼ-awăn-tăn ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kăwăneḍ a-s iməkkusa n-ănnăbităn-win-dăɣ ed tăkosăm ărkăwăl wa ohăr Măssinăɣ d-abbatăn-nănăɣ ašăl wa d-innă i-Ibrahim: ‹S-isəm n-əzzurəyăt-năk a-s mad-ijjəš ălbăraka tiwsaten n-ăkall iket-năsnăt.› ");
INSERT INTO taq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Təssəba-năwăn kăwăneḍ, s-tizarăt, a făl dd-issənkăr Măssinăɣ akli-net, Ɣisa Ălmasex, ăšmašăl-t-dd săr-wăn i-ad-dăɣ-wăn ăj ălbăraka, təbḍəwăm d-erk imojjan-năwăn.» ");
INSERT INTO taq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ămmiijrăd Bəṭrus d-Exya hărwa i-tamətte a-s tăn-dd-osăn hărăt dăɣ-kăl-tikutawen, ăddewăn d-emănnăhăḍ n-ehăn n-ămudd wa măqqărăn d-kăl-sadus. ");
INSERT INTO taq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ăsɣăf-tăn asəɣăr wa tăjjăn inəmmušal i-tamətte ed, jannen i-ăddinăt a-s Ɣisa Ălmasex, inkăr-dd jer-inəmmuttan, ");
INSERT INTO taq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ărmăsăn-tăn, jăn-tăn dăɣ-takărmut har ăffăw ed a-s ităjj a-wen-dăɣ, ijjaš-dd ehăḍ. ");
INSERT INTO taq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Omănăn ăddinăt ăjjootnen əslanen i-măjrăd wa jăn, a-wa ătubăn dăɣ-ašăl-wen-dăɣ, iwwăḍ səmmos afḍăn n-ăwadəm. ");
INSERT INTO taq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ăffăw ɣas, əžžəmmăɣăn-dd imizărăn n-kăl-Ălyăhud d-inušămăn d-ălɣulam n-Ăṭṭăwrăt wi hănen Yărussălam ");
INSERT INTO taq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","d-Hənnan wa n-ămănokal n-kăl-tikutawen d-Qayăf d-Exya d-Ălxaḍer d-kăl-ehăn n-ămănokal n-kăl-tikutawen iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ǝssəbdădăn-dd Exya d-Bəṭrus jere-săn, ənnăn-asăn: «Kăwăneḍ, ma tămoos tărna d-isəm wa s-tăjjăm a-wa tăjjăm?» ");
INSERT INTO taq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ăzzubbăt-dd Unfas Šăddijăn s-ăṣṣahăt făll-Bəṭrus ăssaɣăt-wen-dăɣ, innʼ-asăn: «Imizărăn n-kăl-Ălyăhud, kăwăneḍ-i n-inušămăn, ");
INSERT INTO taq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","asəstan a hanăɣ-tajjăm ašăl-i-dăɣ, dăɣ-isălan n-a-wa ăhusken ătwăjjăn i-anăbdon d-əmmək wa s-iɣlăs. ");
INSERT INTO taq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nărha ad-təlmədăm iket-năwăn, kăwăneḍ hakd kăl-Iṣrayil wi iyyăḍnen a-s tărna n-isəm n-Ɣisa Ălmasex wa n-Năṣirăt təṣlăbăm făll-tajəttewt măšan, issənkăr t-dd Măssinăɣ jer-inəmmuttan, tărna-net ənta-en-dăɣ a tăzozăyăt ăhaləs wa hannăyăm ibdad data-wăn. ");
INSERT INTO taq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɣisa, ənta a-s tăhunt ta hin-jărăm kăwăneḍ-i n-ălbănnatăn măšan, tămoos-dd tăhunt ta n-aɣmăr făll-insa ehăn iket-net. ");
INSERT INTO taq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wăr t-illa əlɣəllas ar s-isəm wa-net făl-a-s wăr t-illa isəm ikfa Măssinăɣ daw-išənnawăn i-əlɣəllas n-dăgg-adəm săl wa-net.» ");
INSERT INTO taq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Islă ălžămaɣăt i-əṣṣuhu n-măjrăd wa hasăn-ija Bəṭrus d-Exya ɣas, tofʼ-en tăkunt-năsăn, ed jan-tăn ăddinăt əžhalnen wăren əɣra măšan, əlmădăn a-s Bəṭrus d-Exya, ămoosăn inalkimăn n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ḍarăt-a-wen daɣ, anăbdon-wa izzăyăn, ənta-da-dăɣ ibdădăn edes-hasăn, ăbas əssanăn a mad-ənnən. ");
INSERT INTO taq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ǝzzəzjărăn Bəṭrus d-Exya ehăn wa dăɣ-ɣattăsăn ăššăreɣa iket-di d-tamănhayăn əntăneḍ. ");
INSERT INTO taq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Dăɣ-taɣimit-năsăn, ənnăn: «Wi ăddinăt, ma hasăn-e-năj? Iji n-Măssinăɣ wa ijăn, wăr t-iha ăššăk ed əssanăn săr-s kăl-Yărussălam iket-dăɣ-năsăn, wăr năddoobăt akuddəl-net. ");
INSERT INTO taq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ămăra, i-ad-wăr səməlsin isălan-wi-dăɣ făll-tamətte, nəsəmmăhăḍet fălla-săn i-ad-ăbas ilkam ad-jan isălan n-isəm n-Ɣisa i-ăwadəm wălʼ iyyăn, olasăn ɣas, ămminănhayăn d-iman-năsăn.» ");
INSERT INTO taq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ǝssăɣrăn-dd Bəṭrus d-Exya ḍarăt-a-wen, ăsmăqqăn fălla-săn i-ad-ăbas ilkam ad-ăɣran wăla ăssiɣrăn isəm n-Ɣisa i-ăwadəm wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ăwwežăbăn-asăn, innʼ-asăn Bəṭrus d-Exya: «Ǝssənăt kăwăneḍ iman-năwăn kunta ma ufăn asjəd-hawăn kăwăneḍ, meɣ asjəd i-Măssinăɣ? ");
INSERT INTO taq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dăɣ-a-wa hanăɣ-dd-iqqălăn năkkăneḍ, wăr năddobăt asusəm făll-isălan nənhay, nəslʼ-asăn.» ");
INSERT INTO taq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Olăs ălžămaɣăt asəmmăhəḍ dăɣ-săn təzzar, oyyăn-tăn-in ed wăr t-illa uḍlem fălla-săn əjrawăn. Tăqqăl-dd tamətte iket-net, tiiməl Măssinăɣ făl təssəba n-a-wa ija. ");
INSERT INTO taq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anăbdon-wa izzăyăn, ăhaləs ilan a okăyăn əkkoẓăt timərwen n-awătay. ");
INSERT INTO taq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ătwăyyăn-in inəmmušal ɣas, əkkăn imidiwăn-năsăn, əjăn dăɣ-săn isălan n-a-wa ənnăn imănokalăn n-kăl-tikutawen d-inušămăn. ");
INSERT INTO taq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ǝslăn i-isălan-en-dăɣ ɣas, əṭṭăfăn iyyăn n-emm, ad-təddalăn Măssinăɣ s-afălla, jannen: «Emăli, kăyy a dd-ixlăkăn išənnawăn d-ăkall d-ejărew wa səmmăn d-a-wa tăn-ihăn iket-net, ");
INSERT INTO taq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","kăyy a innăn s-tărna n-Unfas Šăddijăn s-emm n-abba-nănăɣ Dawəd-i n-akli-năk: ‹Ma dăɣ-ədgaẓnăt tiwsaten? Ma ijan ăddinăt dăɣ-a wăren infa hărăt?› ");
INSERT INTO taq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ma ăsihălăn imănokalăn əššənju-năk, tihərən d-imănnăhăḍăn emm făll-Emăli d-Ălmasex-net. ");
INSERT INTO taq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Itbat a-s ijăḍ Bunəs Bilatəs d-Harudəs akli-năk Ɣisa Wa n-Eməššeddəj tăsnăfrănăd i-ad-umas Ălmasex. Ohărăn fălla-s emm əntăneḍ d-tiwsaten ti n-inəẓẓulam d-kăl-Iṣrayil dăɣ-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A-wen jăn-t i-ad-itbat erhet-năk d-a-wa s-ăru t-dd-tăɣtăsăd. ");
INSERT INTO taq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ămăra Emăli, agəẓ-anăɣ dăɣ-ăššar-năsăn, təkfəd eklan-năk ənniyăt ozjan s-ăxṭăbăn măjrăd-năk. ");
INSERT INTO taq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ilal-anăɣ s-tărna n-ăfuss-năk i-ad-nəzizuy ăddinăt, năj tikunen d-tišušab s-isəm n-akli-năk Ɣisa Wa Šăddijăn.» ");
INSERT INTO taq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Diha-dăɣ d-əssəmdăn tamădilt n-Măssinăɣ, ad-ăškăḍkăḍ edăgg-wənnin-dăɣ dăɣ-ăžžiimmăɣăn, iḍnay-tăn Unfas Šăddijăn iket-năsăn, ad-xaṭṭăbăn măjrăd n-Măssinăɣ s-ənniyăt ozjan. ");
INSERT INTO taq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iṭṭaf ălžămaɣăt wa n-imumənăn iyyăn n-ulh d-iyyăn n-ənniyăt, wăr tăn-iha făw ere ijannen a-wa i-nin wăla a-wa i-nin, ănn-ak tihərən a-wa lăn iket-net jer-iman-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tajăyhen inəmmušal s-tărna tăṣṣohet, xaṭṭăbăn i-ăddinăt tanăkra-ta dd-ija Emăli Ɣisa jer-inəmmuttan, ăssinsa daɣ Măssinăɣ ănnuɣmăt-net s-ăṣṣahăt fălla-săn iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wăr tăn-iha făw ere ămiɣatărăn s-hărăt, žănšʼ-en-in dăɣ-săn wi lănen išəkraš d-ihănan, ");
INSERT INTO taq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tiwəyən-dd ălqim n-a-wa tăn-in-əžžənšăn, sansʼ-en-t dat-inəmmušal i-ad-t-uẓanăn jer-imumənăn. Hak ăwadəm, ijraw s-a-wa dăr-ogdăhnăt timɣutar-net. ");
INSERT INTO taq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Osă-dd Yusəf wa n-ahăya n-Lewi, ilʼ ăkall wa n-Qəbrus, ɣarrăn-t inəmmušal s-isəm Bărnăbbas, a-wen ălmăɣna-net: enəssesmăḍ n-talɣiwen. Ižžənša-hin ašəkrəš-net, ");
INSERT INTO taq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","iwwăy-dd a-wa t-in-ižžənša, ikfʼ-e inəmmušal. ");
INSERT INTO taq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dăɣ-a-wen-dăɣ a dd-iggăd Ănanyas ənta d-hănne-s Săfiɣa, ižžənša-hin ašəkrəš-net ");
INSERT INTO taq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","măšan, ănmănnăk d-hănne-s făll-ad-hin-iṭṭəf aɣil n-ălqim n-inăzzan-net, awəy-dd a-wa iyyăḍăn i-inəmmušal. ");
INSERT INTO taq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Osă-dd ɣas, innʼ-as Bəṭrus: «Ănanyas! Mafăl təyyəd Iblis itajj erk ənniyăt ogdăhăn d-a-wa-dăɣ dăɣ ulh-năk? Ma kăy-isawănnen bahu i-Unfas Šăddijăn a-s hin-taṭṭăfăd aɣil n-ălqim n-ašəkrəš-năk? ");
INSERT INTO taq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mi kăy-ăšhăššălăn inăzzan-net? Ajăn wădden jer-inša-hin wăla, i n-năk ɣas, tăddobed ad-has-təjəd a-wa s-tărhed. Ma dd-orăwăn săr-k erk əššăɣəl-wa-dăɣ? Ǝlməd a-s wădden dăgg-adəm a-s tənned bahu, Măssinăɣ a-s tăn-tənned.» ");
INSERT INTO taq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Islă Ănanyas i-tifer-tin-dăɣ ɣas, oḍa, əjmăḍăn-t iman. Ămoos a-wen isəksaḍ i-ăddinăt wi əslănen i-a-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Osăn-dd hărăt dăɣ-imawaḍăn, əssəlsăn-in tafəkka-net, əglăn dăr-s, ənbălăn-t-in. ");
INSERT INTO taq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Okăy a iwwăḍăn kăraḍ ăssaɣătăn ḍarăt-a-wen ɣas, tosă-dd hănne-s n-Ănanyas, wăr tăt-təha tijya n-a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Təjjăš-dd ɣas, issəstăn-tăt Bəṭrus, innʼ-as: «Săfiɣa, lăɣăt-ahi, ak ajăn ălqim-wa-dăɣ a-s hin-təžžənšăm ašəkrəš meɣ?» Tənnʼ-as: «Ǝyya!» ");
INSERT INTO taq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Innʼ-as Bəṭrus: «Ma săr-wăn dd-orăwăn tanmənnakt šund-ta-dăɣ, tiirəməm Unfas Šăddijăn? Ǝnhəy adăriš n-ăddinăt wi s-iket hin-ənbălăn ăhaləs-năm, əqqalăn-dd, əbdadăn dat-emm n-ehăn i-ad-kăm-awəyăn kămm-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Toḍă ălwăqq-wen-dăɣ daw-iḍarăn n-Bəṭrus, tămmut ənta-dăɣ s-iyyăt. Ǝḍkălăn-tăt imawaḍăn, əẓkăn-tăt edes i-ăhaləs-net. ");
INSERT INTO taq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Orăw-dd a-wen-dăɣ taksăḍt-i-dăɣ măqqărăt făll-ălkănisăt iket-net d-ăddinăt wi iyyăḍnen əslănen i-a-wa ijăn. ");
INSERT INTO taq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ǝjăn inəmmušal ijităn n-Măssinăɣ d-hărătăn ăssuksăḍnen ăjjootnen dat-ăddinăt. Tažămmaɣăn imumənăn n-Ɣisa hak ašăl dăɣ-ehăn n-ămudd wa măqqărăn edes i-tăfala ta s-itawănna ta n-Sulăyman. Ǝknan tassaɣt, əṭṭafăn iyyăn n-emm, ");
INSERT INTO taq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","wădden ere dd-iggădăn-dăɣ, ad-fălla-săn dd-iwwaḍ, ăssiimɣărăn-tăn ăddinăt. ");
INSERT INTO taq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tiwwaḍăn-dd fălla-săn meddən d-tiḍeḍen ăjjootnen omannen s-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tiwəyăn-dd săr-săn ăddinăt imarhinăn, sănsʼ-en-tăn făll-isəftaɣ dăɣ-ittus n-ad-tăn-tăls kud-dăɣ tele n-Bəṭrus afăl okăy, ed ere təlsa tele-net dăɣ, ad-izzəy. ");
INSERT INTO taq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Təffalăn-dd ăddinăt iɣărman wi ohăẓnen, tišələn-dd s-Yărussălam ăwwayăn imarhinăn d-iməlšan, zizuyăn-tăn inəmmušal iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iggăd-dd ămănokal n-kăl-tikutawen, osăm hullan ənta d-iyyăḍ săr-s oraknen n-taggayt ta təglăt făll-tidət n-iman-net, s-itawănna ta n-kăl-sadus, ănmănnakăn i-ad-əjrəwăn əmmək s-ăɣšădăn hărăt i-inəmmušal. ");
INSERT INTO taq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ăstărmăsăn-tăn, əjăn-tăn dăɣ-takărmut ta măqqărăt. ");
INSERT INTO taq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Măšan, osă-dd ănjălos dd-ăšimašăl Măssinăɣ s-ehăḍ, ora tishar n-takărmut, izzəzjăr-tăn-dd təzzar, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ăkkăt ehăn n-ămudd wa măqqărăn, tăxṭəbăm i-tamətte isălan n-tămudre ta tăɣlălăt.» ");
INSERT INTO taq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ǝjăn inəmmušal a-wa hasăn-ătwănnăn, ənšăyăn ehăn n-ămudd wa măqqărăn ad-dăɣ-s saɣren ăddinăt. Ălwăqq wa dd-osa ămănokal n-kăl-tikutawen ənta d-ăddinăt wi săr-s orăknen, issăɣră-dd kăl-Sinhidrin wi n-imizărăn n-kăl-Ălyăhud ɣattăsnen ăššăreɣa, d-inušămăn n-kăl-Iṣrayil wi iyyăḍnen, omărăn s-ad-dd-ăttălwăyăn inəmmušal dăɣ-takărmut. ");
INSERT INTO taq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ǝglăn əssărdusa măšan wăr tăn-in-ogeẓăn dăɣ-səllul-năsăn, əqqălăn-dd, əjăn isălan dăɣ-ălžămaɣăt wa ăqqimăn, ənnăn-asăn: ");
INSERT INTO taq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«A-s hin-nosa takărmut, ăṭṭubben imawăn-net, əbdadăn əssardusa wi tăt-ăɣlăfnen dăɣ-idăggan-năsăn măšan, ălwăqq wa d-nora səllul, wăr t-təha tiṭṭ.» ");
INSERT INTO taq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Islă kumănda wa ănniihăḍăn dăɣ-əssărdusa wi jănen ənniyăt i-ehăn n-ămudd wa măqqărăn d-ămănokal n-kăl-tikutawen i-a-wen ɣas, ăqqănăn iɣăfawăn-năsăn har ăbas əssanăn a mad-ənnən. ");
INSERT INTO taq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Osă-dd ămaway n-isălan, innʼ-asăn: «Meddən wi jăm dăɣ-takărmut, han ehăn n-ămudd wa măqqărăn, saɣren dăɣ-s tamətte.» ");
INSERT INTO taq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iggăd-dd kumănda ăddew d-ejhăn n-əssărdusa, əlwăyăn-dd inəmmušal s-tilăqqad, ed ăksuḍăn ad-fălla-săn dd-təggəd tamətte əntăneḍ-en-dăɣ, tăkfʼ-en sămmăjori n-tihun. ");
INSERT INTO taq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Osăn-dd ɣas, ăššojăšăn-tăn ehăn wa dăɣ-ăqqiima ălžămaɣăt wa n-imănokalăn. Iḍkăl ămănokal n-kăl-tikutawen măjrăd, innă i-inəmmušal: ");
INSERT INTO taq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Ajăn wădden ăru d-fălla-wăn năsmăhăḍ i-ad-ăbas ilkam ad-tăssiɣrăm ăwadəm wălʼ iyyăn s-isəm-wa-dăɣ? Ǝnhəywăt ɣas a-wa jăm ămăra, təḍkărăm-anăɣ Yărussălam iket-net teɣăre-năwăn, tărham daɣ ḍarăt-a-wen, ad-hanăɣ-səwərəm iman n-ăhaləs wa s-jannem.» ");
INSERT INTO taq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ăwwežăb-asăn Bəṭrus d-inəmmušal: «Ufa amišəl n-a-wa innă Măssinăɣ uhən asjəd i-a-wa jănnen dăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Măssi-s n-abbatăn-nănăɣ, ad-dd-issənkărăn Ɣisa wa s-jăm iman-net a-s t-təṣlăbăm făll-tajəttewt, ");
INSERT INTO taq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","təzzar iḍkăl-t s-iman-net, ăsɣăymʼ-e daw-aɣil-net i-ad-imnukəl, umas Ămaɣlas făll-hărăt iket-net. A-wen ijʼ-e Măssinăɣ i-ad-utabăn kăl-Iṣrayil, əjrəwăn tenăšše n-ibăkkaḍăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","A-wen, năjjəyhʼ-as iket-net, ăjjəyhʼ-as daɣ Unfas Šăddijăn-i ikfă ăddinăt wi tamašalnen erhet-net.» ");
INSERT INTO taq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ăfḍănḍărrăy ălžămaɣăt dăɣ-ălhăm a-s islă i-a-wen-dăɣ, ad-tattărăn əmmək s-tăn-in-olămăn făll-ărori n-ăkall. ");
INSERT INTO taq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kittəwăn a-wen-dăɣ a-s, dd-ibdăd jere-săn iyyăn dăɣ-săn la taggayt ta n-kăl-faris s-isəm-net Gamălyăl, ălɣalim ăzizăbben alămăr wa n-ănnăbi Mosa a ămoos, tăssiimɣăr-t daɣ tamətte iket-net. Omăr s-ad-zəzjărăn inəmmušal i-hărăt n-ăssaɣăt təzzar, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","«Kăl-Iṣrayil, ăjăt ənniyăt i-a-wa s-tăbokăm ad-t-təjəm i-meddən-wi-dăɣ; ");
INSERT INTO taq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","əktəwăt-dd ɣas Tadi wa s-a ilan ăzzăman dd-osa, iji iman-net hărăt dat-ăddinăt, ăslăl ḍara-s a iwwăḍăn əkkoẓăt timaḍ n-ăwadəm măšan, wăr-ăhoja a-s ătwăjjăn iman-net, əmmăhăšăn inalkimăn-net, ăbă-dd isălan-năsăn ḍarăt-a-wen. ");
INSERT INTO taq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ḍara-s daɣ, dăɣ-ăzzăman wa n-tăḍint n-ăddinăt, osă-dd Yăhudəs wa n-Galila, ăslăl ənta-dăɣ tamətte tăjjeet ḍara-s măšan, ămmut ənta-dăɣ, əmmăhăšăn inalkimăn-net. ");
INSERT INTO taq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ămăra, ăyyăt-ahi ad-hawăn-ăjăɣ ăddăbara: əjmăḍăt isălan n-ăddinăt-wi-dăɣ, ăkfăt-tăn ălɣafyăt, təyyəm-tăn ad-əglun făl-a-s tiyyăt-i-dăɣ, kunta a-wa tăn-išlăn, erhet n-ăgg-adəm meɣ a dd-ifalăn dăgg-adəm, adiš, ad-t-in-iba ");
INSERT INTO taq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","măšan, kunta Măssinăɣ ad-dd-ifal a-wa tăn-išlăn, adiš, wăr has-lem tărna. He kăwăneḍ! Wăr-itumaset a-s Măssinăɣ a dăr-tăt-jam.» Ăsjăd ălžămaɣăt iket-net i-ăddăbara-wen-dăɣ hasăn-ija Gamălyăl. ");
INSERT INTO taq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ǝssăɣrăn-dd inəmmušal, ăswăjjăn dăɣ-săn tiwit s-ibărtăkăn, ăsmăhăḍăn dăɣ-săn i-ad-ăbas ilkam ad-ămmijrădăn s-isəm n-Ɣisa təzzar, ăswăyyăn-tăn-in. ");
INSERT INTO taq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A-s fălăn inəmmušal ehăn-en-dăɣ, əknan dăɣ-tedăwit făl təssəba n-turhajăt ta tăn-ikfa Măssinăɣ n-ad-ənhəyăn erk əmmək šund wa-dăɣ, dăɣ-idəm n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tažămmaɣăn ḍarăt-a-wen hak ašăl dăɣ-ehăn n-ămudd wa măqqărăn, d-ihănan n-imumənăn wi iyyăḍnen. Wăr t-illa edăgg s-wădden xaṭṭăbăn dăɣ-s, saɣren dăɣ-s Ălənžil n-ƔisaĂlmasex. ");
INSERT INTO taq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ăzzăman-en, hak ašăl tiwwaḍăn-dd imaksaḍăn n-Măssinăɣ dăɣ-wi əlkamnen i-ăttăbeɣa wa n-kăl-Ălyunan făll-ălžămaɣăt wa n-imumənăn. Dăɣ-a-wen-dăɣ, ad-ikka măjrăd jer-kăl-Ălyăhud wi əzzăɣnen jer-kăl-Ălyunan d-kăl-Ălyăhud wi sawalnen Ɣăbranəyya. Ǝnnăn wi n-kăl-Ălyunan, timəddun wi n-Ɣăbranităn tinuḍăfen-năsăn dăɣ-isălan n-tiẓunawen n-tadhəlt ta tajjăn hak ašăl. ");
INSERT INTO taq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ǝssăɣrăn-dd inəmmušal wi n-măraw d-əssin tamətte ta n-inəṭṭulab, ənnăn-asăn: «Wăr-ănhăjja ad-năyy ălxuṭbăt n-isălan n-Măssinăɣ, năqqəl-dd nănnuṭṭăf d-tiẓunawen n-imənsiwăn. ");
INSERT INTO taq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","A-wen-dăɣ a făl, sənnəfrənăt jere-wăn əssa meddən ătiwăsămɣărnen, iḍnay Unfas Šăddijăn n-iməssorha, ănnuṭṭăfnen d-əššăɣəl-wen-dăɣ, ");
INSERT INTO taq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","dihen, năkkăneḍ, ad-năkf iman-nănăɣ tamădilt n-Măssinăɣ d-ălxuṭbăt hak ašăl n-măjrăd-net.» ");
INSERT INTO taq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ijrăẓ ăddăbara-wen-dăɣ i-ălžămaɣăt iket-net, innəfrăn-dd Stifan, a-wen ăhaləs n-immun imdan, iḍnay Unfas Šăddijăn d-Fəlibb d-Brukurus d-Nikanur d-Timun d-Bărmenas d-Nikola wa n-teje ta n-Intyuš s-kăla ilkam i-ăddin wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Meddən-win-dăɣ a dd-issəbdăd ălžămaɣăt dat-inəmmušal, əttărăn-asăn s-Măssinăɣ təzzar, ăswărăn-tăn ifassăn-năsăn, jăn dăɣ-săn ălbăraka. ");
INSERT INTO taq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ad-xaṭṭăbăn əntăneḍ măjrăd n-Măssinăɣ, tijatăn-dd fălla-săn hak ašăl imumənăn ăynaynen dăɣ-Yărussălam. Omănăn făw kăl-tikutawen ăjjootnen, ad-tamašalăn əntăneḍ-dăɣ, a-wa innă măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stifan, ămoos ăhaləs s-tidət-dăɣ, făll-ăssinsa Măssinăɣ ănnuɣmăt-net d-tărna-net, itamašal hărătăn ăqqannen eɣăf d-ijităn n-Măssinăɣ dat-tamətte iket-net. ");
INSERT INTO taq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ǝggădăn-dd meddən ila ehăn n-ăddin wa n-kăl-Ălyăhud s-itawănna «Idărfan», əntăneḍ d-iyyăḍ dd-falnen Qərwan d-Iskăndərya d-tajiwen ti n-Silisi d-ti n-Azya, ad-tamăzaɣăn d-Stifan, ");
INSERT INTO taq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","măšan indăr-asăn ad-t-siḍəwən dăɣ-măjrăd făl tihusay n-sărho wa t-ikfa Unfas Šăddijăn. ");
INSERT INTO taq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ǝglăn, əžžənšăn imawăn n-ăddinăt iyyăḍ i-ad-t-səḍləmăn, ənnăn, əslan-asăn har ăskafar, innă daɣ a lăbasăn făll-ănnăbi Mosa d-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ǝntăjăn-dd s-a-wen-dăɣ tamətte d-imizărăn-net d-ălɣulam n-Ăṭṭăwrăt. Wăla a hin-ijrăh Stifan a-s fălla-s oḍăn ăddinăt, əwwăyăn-t s-kăl-Sinhidrin wi n-imizărăn n-kăl-Ălyăhud ɣattăsnen ăššăreɣa. ");
INSERT INTO taq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ăwwăyăn-dd daɣ tijuhawen n-bahu ənnănen: «Ăhaləs-i-dăɣ, wăr kăla okăy ašăl d-wăr-innă a lăbasăn făl ehăn n-Măssinăɣ wa šăddijăn d-alămăr wa n-Mosa.» ");
INSERT INTO taq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Təhhaḍăn, jannen: «Ijmaḍ-t ăššăk a-s nəslʼ-as har innă a-s ilkam, ad-ărẓ Ɣisa wa n-Năṣirăt ehăn n-ămudd wa măqqărăn, isəmməskəl ălɣadatăn wi hanăɣ-dd-oyya ănnăbi Mosa.» ");
INSERT INTO taq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iqqăl-dd ălžămaɣăt iket-net ăsibălalăɣ dăɣ-Stifan, iqqăl-dd săr-săn a-s ănjălos a dăɣ-əkyadăn făl tihusay-i-dăɣ dd-ija idəm-net. ");
INSERT INTO taq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Issəstăn ămănokal n-kăl-tikutawen wa măqqărăn Stifan ḍarăt-a-wen, innʼ-as: «Kăyy, a-wa ătwănnăn fălla-k, ak tidət meɣ bahu?» ");
INSERT INTO taq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Innʼ-asăn Stifan: «Ayətma, abbatăn, săjdăt-ahi: Măssinăɣ-i ilăn ălxurmăt iket-net, ənta a dd-ănfalălăn i-abba-nănăɣ Ibrahim hărwa izzaɣ ăkall wa n Mizəbbuṭamya, hărwa wăr dd-iddek ăkall wa n-Haran. ");
INSERT INTO taq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","A-s has-dd-ănfalăl Măssinăɣ, innʼ-as: ‹Ǝfəl ăkall-năk d-imărawăn-năk, tăhanəd s-ăkall wa kăy-mad-săknăɣ.› ");
INSERT INTO taq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ăhona ya Ibrahim, ifăl ăkall wa n-Kăldăyăn, iddăk wa n-Haran. ");
INSERT INTO taq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ăba abba-net dihen ɣas, innʼ-as Măssinăɣ, ad-ăhan s-ăkall-wa-dăɣ, təzzaɣăm ašăl-i-dăɣ. Ăkall-en, wăr dăɣ-s ikfa Măssinăɣ Ibrahim tăkasit n-wăla edăgg dăɣ-ăssinsa aḍăr-net măšan, ijjăš-as ărkăwăl n-ad-t-ăkf ăkall-en-dăɣ ənta d-ihăyawăn-net. A-s has-ijănna Măssinăɣ a-wen-dăɣ, wăr-ila Ibrahim ara. ");
INSERT INTO taq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Innʼ-as Măssinăɣ ăzzăman-en: ‹Ihăyawăn-năk ad-umasăn imăjarăn dăɣ-ăkall wăr len, ad-ăkkălen, ənhəyăn aɣăna har əkkoẓăt timaḍ n-awătay ");
INSERT INTO taq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","măšan, ad-hasăn-əkkəsăɣ tekăriḍt, əšrăɣăɣ ăkall-en tăn-ăskălen, zəzjărăɣ-asăn-t-dd, ăɣbədăn dăɣ-edăgg wa-dăɣ tăn-əkfeɣ.› ");
INSERT INTO taq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ijjăš Măssinăɣ ărkăwăl n-tassaɣt i-Ibrahim, ărkăwăl-en, amili a-s tamătart-net. A-wen-dăɣ a făl ikrăš Ibrahim Isxaqq, ăsmalăy-t ašăl wa s-əttam; a-wen-dăɣ daɣ a ija Isxaqq i-rure-s Yaqub, ijʼ-e daɣ Yaqub i-məddana-s wi n-măraw d-əssin i n-imɣarăn n-imăzzaɣăn n-tiwsaten-nănăɣ ti n-mărawăt d-sănatăt. ");
INSERT INTO taq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Osămăn ḍarăt-a-wen məddana-s n-Yăqub wi n-imɣarăn n-imăzzaɣăn făll-Yusəf-i n-ăŋŋa-săn, əžžənšăn-t-in i-ad-ăkkălăt dăɣ-Miṣra măšan, issăn Măssinăɣ dăɣ-Yusəf dăɣ-ăkall-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wăr t-illa erk əmmək dăɣ-wăr t-dd-ikkes Măssinăɣ, issənsă fălla-s ănnuɣmăt-net d-sărho i-ad-ikrəš idəm dat-Firɣăwna-i n-ămănokal n-Miṣra-i has-ijăn tafləst-ta-dăɣ făl t-ăsmănakăl dawa-s făll-ăkall d-a-wa ihăn eɣewən-net iket-net. ");
INSERT INTO taq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dăɣ-a-wen-dăɣ a dd-oḍa laẓ lăbasăn făll-Miṣra d-Xăna, ămɣatărăn ăddinăt hullan har ăbas əṭṭafăn imărawăn-nănăɣ a əkšăn. ");
INSERT INTO taq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Isla Yaqub a-s ihʼ əttăɣam Miṣra ɣas, ăšmašăl săr-s məddana-s wi hanăɣ-ăshăyăwnen. ");
INSERT INTO taq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Osăn-dd, əqqălăn, šămad dd-jan asikəl wa s-əssin a tăn-ăzozăy Yusəf iman-net, ilmăd daɣ Firɣăwna s-a-wen-dăɣ, tumast n-Yusəf. ");
INSERT INTO taq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ăssotăr Yusəf ti-s d-imărawăn-net iket-năsăn, ămoos a-wen-dăɣ əssayăt timərwen n-ăwadəm d-səmmos. ");
INSERT INTO taq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Iddăk-dd ya Yaqub Miṣra, ăba-t daɣ dihen-dăɣ ənta d-imărawăn-nănăɣ wi hanăɣ-ăshăyăwnen. ");
INSERT INTO taq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ǝmməḍkălnăt tifəkwen-năsăn ḍarăt tamăttant-năsăn s-aɣrəm wa n-Sišăm i-ad-ənbəlăn dihen dăɣ-təfărre ta ižžənša Ibrahim făll-məddana-s n-Hămmăr dăɣ-Sišăm. ");
INSERT INTO taq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","A-s dd-tăwwăḍ tăqqăn n-ărkăwăl wa ijjăš Măssinăɣ i-Ibrahim, təkna tamətte-nănăɣ əjut dăɣ-Miṣra. ");
INSERT INTO taq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Inăy-dd ăzzăman-en Firɣăwna ăynayăn wărăn izzey Yusəf. ");
INSERT INTO taq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ijjăš săr-năɣ erk ălxal, issəknă tumast-nănăɣ aɣăna, ijă a wărăn ijreẓ i-imărawăn-nănăɣ, ăsmăḍrăy-tăn hullan s-ălxidmăt wa dăɣ-tăn-ijă, iglă dăɣ-tăllăbăst-net har hasăn-innă ad-hin-ənḍəwăn aratăn-năsăn wi n-eyyan i-ad-ămmătăn. ");
INSERT INTO taq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ăzzăman-en-dăɣ ad-iwa Mosa-i ikrăšăn idəm dat-Măssinăɣ; kăraḍ orăn ɣas a jăn imărawăn-net əṭṭafăn-t, təzzar, ăšhăššăl-tăn a-wa inna Firɣăwna tăbəḍḍawt dăr-s. ");
INSERT INTO taq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jărăn-t-in ɣas, təkkəmăt-t-dd elle-s n-Firɣăwna, təjʼ-e-hi-dd s-iman-net, təjʼ-as asədwal wa mad-tăj i-ara n-tăsa-net. ");
INSERT INTO taq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ămoos Mosa ere iɣran dăɣ-təlɣuləma d-musnăt wa n-kăl-Miṣra, ikfʼ-e Măssinăɣ ăṣṣahăt dăɣ-măjrăd hakd dăɣ-timašalen. ");
INSERT INTO taq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ikrăš əkkoẓăt timərwen n-awătay ɣas, ijjăs-t-dd ənniyăt n-ad-ăkk ayətma-s wi n-Iṣrayil, idhəl-tăn, əntăneḍ-i n-tumast-net. ");
INSERT INTO taq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ašăl iyyăn, inhăy iyyăn dăɣ-săn isalmaḍ u-Miṣra t-irnan ɣas, ohăɣ-as tinahăɣen, ijă iman n-wa n-u-Miṣra. ");
INSERT INTO taq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ăɣel afăl ija a-wen, ad-əjrăhăn ayətma-s a-s Măssinăɣ a t-dd-ăšmašălăn săr-săn i-ad-tăn-ikkəs dăɣ-əkkəlu wa hăn măšan, wăr əjrehăn a-wen. ");
INSERT INTO taq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ašăl wa ilkamăn i-wen, inhăy əssin meddən n-kăl-Ălyăhud əknasnen, ittăr ad-ăkk jere-săn, ibḍəw-tăn, əjən ălxer. Innʼ-asăn: ‹Imidiwăn, kăwăneḍ wădden ayətmatăn a tămoosăm, mafăl tinməjjim a lăbasăn jer-iman-năwăn.› ");
INSERT INTO taq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Iggăd-dd săr-s wa irnăn, imhăl-t-in, innʼ-as: ‹Kăyy, mi kăy-ijăn ămizăr d-ălqaḷḷi-hanăɣ, ");
INSERT INTO taq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","əyya, a tărhed ad-hi-tănɣəd šund a wa jed i-u-Miṣra wa s-jed iman-net ənḍəšel.› ");
INSERT INTO taq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Islă Mosa i-măjrăd-wen-dăɣ ɣas, irmăɣ, ăjewăḍ ălwăqq-wen-dăɣ s-ăkall wa n-Mădyan, izzăɣ, ădobăn ya dihen-dăɣ, ikrăš əssin ilyaḍăn. ");
INSERT INTO taq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Šămad okaynăt əkkoẓăt timərwen n-awătay ad-has-dd-ănfalăl ănjălos n-Măssinăɣ dăɣ-tenere făll-aḍaɣ wa n-Săynay dăɣ-tabsăɣt ta tăhijăljălăt wăr răqq. ");
INSERT INTO taq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tăqqăn tănăfalilt-ta-dăɣ ihannăy eɣăf-net, iknă-dd ihəẓ n-tabsăɣt i-ad-ikən asənnəfli dăɣ-a-wa ihannăy măšan, izjăr-tăt-dd emăsli n-Emăli has-innăn: ");
INSERT INTO taq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Năkk a-s Măssinăɣ n-imɣarăn wi kăy-ăshăyăwnen, năkk a-s Măssinăɣ wa n-Ibrahim d-Isxaqq d-Yaqub.› Ihă-dd ɣas Mosa ăšikăḍkăḍ a-wa-dăɣ has-ja tarəmmeɣt har ăbas ihăl wăla-dăɣ ad-iḍkəl idəm-net, ikyəd. ");
INSERT INTO taq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Innʼ-as Emăli daɣ: ‹Ǝkkəs tifădelen-năk făl-a-s edăgg wa dăɣ-təbdadăd, edăgg šăddiijăn, ");
INSERT INTO taq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ənhăyăɣ tisnant ta tărmăsăt tamətte-nin dăɣ-Miṣra, əsleɣ i-tihnəffa-năsăn, a-wen-dăɣ a făl dd-ăzzubbeɣ i-ad-tăn-səddărfeɣ. Ămăra, əgləw, kăyy a he-šəmməsəlăɣ s-ăkall wa n-Miṣra.› ");
INSERT INTO taq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Wădden hannăyăm a-s Mosa-wa-dăɣ ăkkuddălăn a-s has-ənnăn: ‹Mi kăy-ijăn ămizăr d-ălqaḷḷi-hanăɣ?› Ǝnta-en-dăɣ a dd-ăšmašăl Măssinăɣ i-ad-izar i-kăl-Iṣrayil, isəddărfʼ-en-dd s-tărna n-ănjălos wa has-dd-ănfalălăn dăɣ-tabsăɣt ta tăhijăljălăt wăr răqq. ");
INSERT INTO taq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ǝnta-en-dăɣ a tăn-dd-izzəzjărăn Miṣra itajj s-tărna n-Măssinăɣ hărătăn ăqqannen eɣăf d-ijităn n-Măssinăɣ har əjlăyăn ejărew wa səmmăn šăggăɣăn, əjăn ḍarăt-a-wen əkkoẓăt timərwen n-awătay ăhonăn dăɣ-tenere. ");
INSERT INTO taq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosa, ənta a-s kăla innă i-kăl-Iṣrayil: ‹Ilkam ad-săr-wăn dd-išəmmišəl Măssinăɣ ănnăbi dăr-i olăhăn, ănnăbi dăr-wăn oharăn temiḍt.› ");
INSERT INTO taq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ǝnta-en-dăɣ daɣ a ibdădăn dăɣ-tenere ta n-Săynay jer-ănjălos wa has-ămmiijrădăn făll-afălla n-aḍaɣ wa n-Săynay d-tamətte, ikfʼ-e Măssinăɣ măjrăd wa ihakkăn tămudre i-ad-hanăɣ-t-dd isəssiwăḍ ");
INSERT INTO taq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","măšan, unjăyăn abbatăn-nănăɣ s-asjəd-has, ăsɣărăn-as ulhawăn-năsăn, ənnăḍăn fălla-s, ad-sadărhanăn uɣəl n-Miṣra-i dd-əzjărăn. ");
INSERT INTO taq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dăɣ-a-wen-dăɣ, a dd-təggăd tamətte s-Harun, tənnʼ-as: ‹Ăjʼ-anăɣ imălan ăynaynen ărjăšnen data-năɣ făl-a-s Mosa wa hi-hanăɣ-dd-izzəzjărăn Miṣra, ăbas nəssan a ija.› ");
INSERT INTO taq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ǝṣṣəwwărăn-dd ḍarăt-a-wen i-iman-năsăn ehădăl n-orăɣ, ad-tajjăn tikutawen i-ăṣṣănăm wa jăn s-ifassăn-năsăn, ad-t-ɣabbădăn, tiimələn-t, sănkarăn iẓəjraẓ d-isudal dat-a-wa dd-əknăn ifassăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ǝssəksănăn iman-năsăn Măssinăɣ s-a-wen-dăɣ tăn-išlăn, oyyʼ-en ənta-dăɣ s-ăṣṣănăm-năsăn d-ălɣibadăt wa tăjjăn i-ajhanăn wi n-išənnawăn: tăfukt, ewăr d-etran; ămoos a-wen a ăssiitbătăn a-wa innă ănnăbi Ɣămmosa a-s inna dăɣ-əlkəttab-net, innă Măssinăɣ: ‹Ya kăl-Iṣrayil! Ǝkkoẓăt timərwen n-awătay a jăm dăɣ-tenere, ɣarrăsăm i-taɣsiwen, təkkatăm-tănăt, ak ăssistănăɣ-kăwăn, ajăn năkk a-s tănăt-kătăm? ");
INSERT INTO taq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wădden ehăket n-ăṣṣănăm wa s-isəm-net Molax d-atăr wa s-isəm-net Rufan-i jăm emăli-năwăn, tahanem dăr-s siha d-siha, a-s tănăt-kătăm, tăqqălăm-dd ɣabbădăm-tăn. Dăɣ-təssəba n-a-wen-dăɣ tămešălăm a făl mad-ărẓən kăl-Băbilun ăkall-năwăn, tăkkălem dăɣ-ikallăn wi hasăn-in-əllanen.› ");
INSERT INTO taq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","A-s hăn imɣarăn-nănăɣ tenere, əṭṭafăn ehăket wa n-tămuqqest n-Măssinăɣ ămoosăn tajuhe i-ărkăwăl n-tassaɣt wa ijjăš Măssinăɣ i-Mosa a-s, has-innă, ad-ikrəs ehăket-en s-əmmək wa s-has-omăr s-a-wen. ");
INSERT INTO taq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ehăket-en, togăẓ-t-dd əzzurəyăt ta hasăn-təlkămăt har ăzzăman wa d-hasăn-ăzzar Yešwa, əjjăšăn d-ehăket ăkall wa tăn-ikfa Măssinăɣ, ohăɣăn dăɣ-əddəwəlăn wi iyyăḍnen; əṭṭafăn ehăket-en dăɣ-ăkall-en-dăɣ har ăzzăman wa n-Dawəd-i ");
INSERT INTO taq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ijrăwăn idəm d-ănnuɣmăt dat-Măssinăɣ. Ǝnta-en-dăɣ a ittărăn dăɣ-Măssinăɣ turhajăt n-ad-isəkrəs ehăn i-Măssi-s n-Yaqub ");
INSERT INTO taq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","măšan, turhajăt-ten-dăɣ, Sulăyman-i n-rure-s n-Dawəd a tăt-ijrăwăn. ");
INSERT INTO taq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ikrăs ehăn-en măšan, issəlmăd-t Măssinăɣ s-hărăt iyyăn, ");
INSERT INTO taq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","innʼ-as Emăli: ‹Išənnawăn a-s tasăqqaymut-in, ăkall a-s isəkkukal n-iḍarăn-in. Ma ămoos ehăn wa s-tăddobem a hi-t-tədəyəm i-ad-hi-awəy, sunfăɣ dăɣ-s? ");
INSERT INTO taq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ajăn wădden ăfuss-in a dd-ixlăkăn hărăt iket-net.› » ");
INSERT INTO taq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Olăs daɣ innʼ-asăn Stifan: «Ya meddən-i-dăɣ n-iɣăfawăn ăqqurnen n-ulhawăn wăren ătub s-ăṭṭubbătnăt timəẓẓujen-năsăn, tunjayăm s-Unfas Šăddijăn šund a-wa jăn abbatăn-năwăn, ");
INSERT INTO taq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ijmaḍ-t ăššăk a-s a-wa əjăn abbatăn-năwăn ɣas a kăwăn-išlăn kăwăneḍ-dăɣ, wăr t-illa ănnăbi s-wădden ăqquzzăben-t, jăn iman n-wi hasăn-ălolăynen n-a-s ilkam a dd-ass wa n-iyyăn n-Ămaɣdal ăsnăfrăn Măssinăɣ, təttəlălăm-tăn kăwăneḍ-dăɣ ed təssăɣdărăm-t ənta-dăɣ təzzar, tănɣăm-t kərəf, ");
INSERT INTO taq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ăzzăbbăt-dd Măssinăɣ fălla-wăn alămărăn-net, əmməjrădăn-awăn săr-săn ănjălosăn măšan, tunjăyăm s-asjəd-hasăn.» ");
INSERT INTO taq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Islă ămănokal n-ălžămaɣăt wa iɣattăsăn ăššăreɣa i-a-wen-dăɣ ɣas, ad-isamădad ənta d-ăddinăt-net, ẓimkărkəweẓăn isenăn, făll-ălhăm-i-dăɣ măqqărăn tăn-ijjăšăn făll-Stifan. ");
INSERT INTO taq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ǝnta ălwăqq-wen-dăɣ, iḍnăy-t Unfas Šăddijăn, iḍkăl asăwaḍ-net s-išənnawăn, inhăy ălxurmăt n-Măssinăɣ d-Ɣisa ibdad daw-aɣil n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iḍkăl emăsli-net ălwăqq-wen, innă i-ălžămaɣăt: «Săjdăt, ənhəywăt išənnawăn, ămerăn, ibdad Ăgg-ăgg-adəm daw-aɣil n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ǝslăn i-a-wen ɣas, ăsɣăyyăn dăɣ-išənnawăn, hărăn timəẓẓujen-năsăn, ošălăn-dd šund iyyăn n-ăwadəm săr-s iket-dăɣ-năsăn, oḍăn fălla-s, ");
INSERT INTO taq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ăšrăwrăwăn-t har dăr-s əzjărăn aɣrəm, ad-t-hakkăn sămmăjori n-tihun har t-ănɣăn kərəf. Ăddinăt wi jănen a-wen-dăɣ, ămawaḍ s-isəm-net Sawəl a əssăɣlăfăn isəlsa-năsăn təzzar ăšewăjăn s-Stifan. ");
INSERT INTO taq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hakkăn-t sămmăjori n-tihun wăr dd-išrey, itəddal ənta Măssinăɣ, ijanna: «Emăli Ɣisa, ăssiɣlăfăɣ-kăy iman-in.» ");
INSERT INTO taq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Irkăɣ ḍarăt-a-wen, iḍkăl emăsli-net s-afălla, innă: «Emăli, wăr tăn-tăswărăd abăkkaḍ-wa-dăɣ.» Innă a-wen-dăɣ ɣas, əjmăḍăn-t iman. ");
INSERT INTO taq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A-wa ijăn ašăl-wen-dăɣ iket-net issan-as Sawəl hărăt, iqqăs i-tamăttant ta ija Stifan. Ɣur-ašăl-wen-dăɣ, ad-intă ălɣizabăt səmmăn făll-ălkănisăt ta təhăt Yărussălam, əmmăhăšăn imumənăn dăɣ-tajiwen ti n-Ălyăhudəyăt d-Sămari, inəmmušal ɣas a dd-ăqqimănen dăɣ-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Osăn-dd meddən ăddinnen, əṣtărăn-in Stifan, əṭṭăfăn iba-net dăɣ-tisnant. ");
INSERT INTO taq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iggăd-dd Sawəl dăɣ-a-wen-dăɣ, ad-itammăɣ i-əmmək s-hin-olăm ălkănisăt edăgg t-təlla-dăɣ, wăr t-illa ehăn wăr-ijješ, isatărmas ăddinăt wi omănnen s-Ɣisa jer-ămoosăn meddən wăla tiḍeḍen, itəjjar-tăn-in dăɣ-tikărmuten. ");
INSERT INTO taq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Imumənăn wi dd-əzjărnen Yărussălam, əmmăhăšăn ɣas, ăllilăn ăkall iket-net, xaṭṭăbăn Ălənžil i-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Dăɣ-a-wen-dăɣ ad-ikkă Fəlibb aɣrəm iyyăn ihan teje ta n-Sămari ad-dăɣ-s ixaṭṭăb i-tamətte isălan n-Ălmasex. ");
INSERT INTO taq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sajadăn-as ăddinăt ăjjootnen s-ijraẓ măjrăd wa ităjj d-ijităn n-Măssinăɣ wi itamašal data-săn, ");
INSERT INTO taq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","itakkăs alšinăn naḍḍăwnen iɣăran dăɣ-ăddinăt, izizuy daɣ inaɣyabăn d-inəbdan ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ja tedăwit măqqoorăt dăɣ-aɣrəm-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Izzaɣ dihen ăhaləs n-emăssăxăr s-isəm-net Simon, ămoos a-wa ităjj awnaf i-kăl-Sămari, ăssimɣăr iman-net hullan, ");
INSERT INTO taq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","əltaɣăn-t wi măḍroynen hakd wi wăššarnen, jannen fălla-s: «Wa ăhaləs, tărna ta tojărăt n-Măssinăɣ a iṭṭaf.» ");
INSERT INTO taq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ǝltăɣăn-t ya ăddinăt ăjjootnen dăɣ-təssəba n-əssăxăr wa ităjj, itaqqăn iɣăfawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Inhăy Simon a-s omănăn ăddinăt s-Ălənžil wa hasăn-ixaṭṭăb Fəlibb făl Təmmənəya n-Măssinăɣ d-Ɣisa Ălmasex ɣas, ad-titwəsəlmiɣăn meddən hakd tiḍeḍen dăɣ-aman, ");
INSERT INTO taq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","omăn ənta-dăɣ, ătwăsălmăɣ dăɣ-aman. Iltăɣ ya Fəlibb ḍarăt-a-wen făl təssəba n-ijităn n-Măssinăɣ d-tikunen ti s-t-ihannăy itajjʼ-enăt, ăqqănnen eɣăf-net ənta-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ǝslăn inəmmušal wi hănen Yărussălam a-s kăl-Sămari-dăɣ omănăn s-măjrăd n-Măssinăɣ ɣas, ăšmašălăn-dd săr-săn Bəṭrus d-Exya. ");
INSERT INTO taq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ǝwwăḍăn-in ɣas, dălăn Măssinăɣ i-ad-dd-izəzzubbət Unfas Šăddijăn făll-ăddinăt wi ătubnen dihen ");
INSERT INTO taq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ed, dat-a-wen-dăɣ, wăr tăn-iha-i făll-dd-ăzzubbăt Unfas Šăddijăn, atwəsəlmaɣ ɣas a ătwăjjăn dăɣ-aman s-isəm n-Emăli Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ăswăr-tăn Bəṭrus d-Exya ifassăn-năsăn, ăzzubbăt-dd fălla-săn Unfas Šăddijăn. ");
INSERT INTO taq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Inhăy Simon a-s šămad tăn-ăsiwărăn inəmmušal ifassăn-năsăn, ad-fălla-săn dd-ăzzubbăt Unfas Šăddijăn ɣas, ittăr ad-tăn-ăkf aẓrəf, ijannʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Ăkfăt-ahi năkk-dăɣ tădabit-ta-dăɣ i-ad-umas a-s ere ăswărăɣ ifassăn-in năkk-dăɣ, ad-fălla-s dd-izzubbət Unfas Šăddijăn.» ");
INSERT INTO taq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Innʼ-as Bəṭrus: «Təkšăfăd, kăyy hakd aẓrəf-năk ed torded a-s a-wa ikfa Măssinăɣ bănnan, tăddoobed ažənš-net. ");
INSERT INTO taq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Šămad kăyy ənniyăt-năk da-dăɣ, əlməd a-s a-wa ijăn, ăbas t-iha folăt-năk ed ifraɣ ulh-năk dat-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","A-wen-dăɣ a făl utab dăɣ-amsud-năk iket-di, tədəlăd Emăli kunta ămmukkăn a-wen, ad-hak-ănš erk ənniyăt wa innăhăḍăn dăɣ-ulh-năk ");
INSERT INTO taq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ed, hannăyăɣ a-s ulh-năk, wăr-iḍney a săl tăllăbăst d-iba n-iqqud.» ");
INSERT INTO taq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ăwwežăb Simon, innʼ-asăn: «Ǝttărăt-ahi-in kăwăneḍ-di-dăɣ dăɣ-Emăli i-ad-wăr hi-irəmməs a-wa s-tənnăm.» ");
INSERT INTO taq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ăjjəyhăn inəmmušal, ăxṭăbăn măjrăd n-Emăli i-ăddinăt ăjjootnen təzzar, əqqălăn Yărussălam. Dăɣ-asikəl-năsăn, tajjăn isălan n-Ălənžil dăɣ-tidbi ăjjootnen n-Sămari. ");
INSERT INTO taq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Imməjrăd ḍarăt-a-wen ănjălos n-Emăli i-Fəlibb, innʼ-as: «Fəlibb, tărur, təjəd tabarăt ta fălăt Yărussălam təkka Gaza ed wăr dăɣ-s əjjətăn iməssukal ămăra-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Iglă, wăr-ăhoja a-s ăhaləs iyyăn n-ămudăš n-minəstăr-da-dăɣ, ənta a ănnihăḍăn dăɣ-a-wa la Kăndas ta n-tămănokalt n-ăkall wa n-Ityobya. Ăhhujjăjj-dd ənta-dăɣ s-Yărussălam i-ad-dăɣ-s iɣbəd Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Issəmda ăhujjəj ɣas, iqqăl ăkall-net dăɣ-turăft-net əlwayăn ibəjwan. Ăssookal minəstăr-di iɣarr əlkəttab wa n-ănnăbi Saya a-s dăr-s ămmuqqăs Fəlibb. ");
INSERT INTO taq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Innă Unfas Šăddijăn i-Fəlibb ad-hin-ahəẓ turăft-net. ");
INSERT INTO taq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ošăl Fəlibb har dăr-s ămsadăɣ, islʼ-as iɣarr əlkəttab wa n-ănnăbi Saya ɣas, innʼ-as: «Ăhaləs, ak a-wa ɣarrăd, təjrahăd ălmăɣna-net meɣ?» ");
INSERT INTO taq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Innʼ-as ăhaləs: «Ǝndek a-wa he-ăjăɣ əjrăhăɣ-t a-s wăr t-illa ere hi-t-iffəssărăn.» ");
INSERT INTO taq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ăsnăy-t-dd ăhaləs edes-has ad-has-iɣarr edăgg wa dăɣ-iktăb a-s: «Olăh ɣas d-tiɣse tăttilwăyăt s-asăɣrəs, olăh d-takəndəmt s-təllasăn ăddinăt, wăr t-illa emăsli dd-izjarăn emm-net, ");
INSERT INTO taq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","imməḍrăy bănnan, wăr has-ătwăjja ăššăreɣa wa dăr-ăniihăjja. Mi s-ilkam ad-dd-iḍkal isălan-net i-ihăyawăn-net ed tărẓa taɣrəst-net dăɣ-ăddunya?» ");
INSERT INTO taq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Issəstăn ăhaləs wa n-ămudăš n-Ityobya Fəlibb, innʼ-as: «Lăɣăt-ahi, mi s-iha ănnăbi ti-net dăɣ-edăgg-wa-dăɣ? Ak iman-net a dăɣ-ămmijrăd meɣ isălan n-ere s-ilkam ad-dd-ass a-s iha ti-net?» ");
INSERT INTO taq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Irmăs-as-dd Fəlibb tifer-ti-dăɣ, ad-has-itafăssar a-wa inna Ălənžil n-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ǝglan har dd-əkkăn edes i-edăgg han aman ɣas, innʼ-as ăhaləs wa n-ămudăš: «Aman da, ma igdalăn ad-ətwəsəlmăɣăɣ?»  ");
INSERT INTO taq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Innʼ-as Fəlibb: «Amən ɣas s-ulh imdan.» Innʼ-as ăhaləs wa n-ămudăš: «Omanăɣ a-s Ɣisa Ălmasex a-s Rure-s n-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Omăr ălwăqq-wen-dăɣ i-ad-təbdəd turăft, ijjăš dăr-s Fəlibb aman, issəlmăɣ-t. ");
INSERT INTO taq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Diha-dăɣ dd-əzjărăn aman ad-iḍkăl Unfas n-Emăli Fəlibb, wăr t-oles ămudăš-ənnin-dăɣ ahănay, iglă ənta dăɣ-zăbo-net, ikna tedăwit. ");
INSERT INTO taq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A-s hin-ijrăh Fəlibb iman-net ḍarăt-a-wen, iha ăkall wa n-Ašdud, ifăl dihen, ikkʼ aɣrəm wa n-Qăyṣăra. Tadăbayt immăr-dăɣ, ad-dăɣ-s ăj isălan n-Ălənžil. ");
INSERT INTO taq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ăzzăman-en-dăɣ, a dd-iggăd Sawəl, isamădad, isamăhaḍ, wăr t-illa anəzjum ila săl wa n-iji n-iman n-inəṭṭulab n-Ɣisa. Dăɣ-isălan n-a-wen-dăɣ a dăɣ-ikka ămănokal n-kăl-tikutawen ");
INSERT INTO taq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","i-ad-t-ăkf tikarḍiwen issəknă dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud hănen Dămašăq i-ad-ijrəw s-asəttărməs n-e d t-illăm ere ăllilăn tabarăt-ten-dăɣ n-Emăli, jer-ăhaləs wăla tamăḍt, i-ad-t-dd-awəy dăɣ-tišəm s-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ăssookal Sawəl dăɣ-a-wen a-s hin-ohăẓ aɣrəm wa n-Dămašăq. A ənḍărrăn, ămlăwlăw ănnur-i-dăɣ ăṣṣoohen dd-ifalăn išənnawăn; ");
INSERT INTO taq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ihă-dd oḍa, islʼ ălwăqq-wen-dăɣ i-emăsli has-innăn: «Sawəl, Sawəl, ma kăy-orămăn săr-i tiɣəzzəbud-ahi?» ");
INSERT INTO taq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Innʼ-as Sawəl: «Mi tămoosăd Emăli?» Innʼ-as Emăli: «A-wa năkk Ɣisa wa tiɣəzzəbud, ad-hak-indăr amẓəẓẓaj dăr-i hărkuk. ");
INSERT INTO taq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ămăra, əbdəd, əjjəš aɣrəm wa n-Dămašăq, ad hak-itwənn dihen a-wa s-led s-ad-t-təjəd.» ");
INSERT INTO taq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ǝqqălăn-dd ɣas meddən wi ăddewnen d-Sawəl oran imawăn, ăbas əssanăn a he-ənnən ed əslan i-emăsli-wənnin-dăɣ măšan, wăr t-illa ere hannăyăn. ");
INSERT INTO taq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ibdăd Sawəl ḍarăt-a-wen făll-iman-net, ittăr ad-arr tiṭṭawen-net măšan, wăr t-illa a ihannăy. Ǝlwăyăn-t imidiwăn-net har dăr-s əjjăšăn aɣrəm wa əkkăn. ");
INSERT INTO taq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ija kăraḍ išilan ḍarăt-a-wen dărɣal, wăr-ikša, wăr-iswa. ");
INSERT INTO taq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Aɣrəm wa n-Dămašăq, ihʼ-e ănăṭṭalib n-Ɣisa s-isəm-net Ănanyas, ănfalăl-as-dd Măssinăɣ, innʼ-as: «Ănanyas!» Innʼ-as Ănanyas: «Năkk da Emăli.» ");
INSERT INTO taq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Innʼ-as Emăli: «Ăkk tăšarrit ta s-itawănna ‹ta toɣădăt›, təjjəšăd ehăn wa n-Yăhudəs, səstənăd d-ăhaləs n-taɣrəmt ta n-Tarša s-isəm-net Sawəl.» A-s ităjj a-wen-dăɣ, itəddal Sawəl Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ănfalăl-as-dd dăɣ-a-wen-dăɣ a-s ikkʼ-e-hi-dd ăhaləs s-isəm-net Ănanyas-i t-madăn-isəwăr ifassăn-net i-ad-t-dd-iqqəl ahănay-net. ");
INSERT INTO taq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Innă Ănanyas: «Emăli, əsleɣ a ăjjeen făll-ăhaləs-i-dăɣ, əllăɣen-ahi ăddinăt ăjjootnen erk əmmək wa issəkna iməššeddəjăn wi hănen Yărussălam, ");
INSERT INTO taq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","wăla Dămašăq-i dd-ikka, ikkʼ-et-dd ăwway tikarḍiwen t-dd-əkfan imănokalăn n-kăl-tikutawen has-əjrawnen ad-isəttărməs e d t-illăm ere iɣarrăn isəm-năk.» ");
INSERT INTO taq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Innʼ-as Emăli: «Ǝgləw, ăhaləs-di, năkk a t-ăsnăfrănăn i-ad-awəy isəm-in, isəlməd tiwsaten ti n-inəẓẓulam d-imănokalăn d-kăl-Iṣrayil a-wa ămoosăɣ, ");
INSERT INTO taq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ad-t-săknăɣ aɣăna wa mad-inhəy dăɣ-təssəba-nin.» ");
INSERT INTO taq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iglʼ Ănanyas, ikkʼ ehăn wa s-has-ătwănna ihʼ-e Sawəl, osʼ-in, ăswăr-t ifassăn-net, innʼ-as: «Ăŋŋa-ɣ Sawəl, Emăli Ɣisa-i hak-dd-ănfalălăn dăɣ-tabarăt ta dd-jed, ənta a hi-dd-ăšmašălăn săr-k i-ad-kăy-dd-iqqəl ahănay-năk, iḍnəy-kăy Unfas Šăddijăn.» ");
INSERT INTO taq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tamăzăyyat-ten-dăɣ a dăɣ-dd-ătrăkkăt a olăhăn d-tifrənkawen dăɣ-tiṭṭawen n-Sawəl təzzar iqqăl-t-dd ahănay-net, ");
INSERT INTO taq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ibdăd ḍarăt-a-wen, ătwăsălmaɣ dăɣ-aman, immənsăw, iqqăl-t-dd ăṣṣahăt-net, izzăɣ Sawəl ɣur-inəṭṭulab wi n-aɣrəm-en-dăɣ har ɣur-săn ăssakăy a lăn išilan. ");
INSERT INTO taq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wăr-ăhoja a-s issəntă axăṭab n-isălan n-Ɣisa dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, isatbat dat-tamətte iket-net a-s, Ɣisa a-s, Rure-s n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ăkunăn ăddinăt wi has-sallănen, əqqălăn-dd ɣas, jannen: «A-wa, wădden Sawəl wa izzănăn s-wi ɣarrănen isəm wa n-Ɣisa hănen Yărussălam? Ajăn wădden ass-net i-aɣrəm-wa-dăɣ, i n-təssəba n-ad-tăn-isəttărməs, ăjʼ-en dăɣ-ifassăn n-ămănokal n-kăl-tikutawen?» ");
INSERT INTO taq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sawəl ənta, itiiṣuhut immun-net s-Măssinăɣ hak ašăl, isimxəlxil kăl-Ălyăhud wi əzzăɣnen Dămašăq, isikus-tăn ăššăk a-s Ɣisa a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Okăy ăzzăman ɣas, ănmănnakăn kăl-Ălyăhud făll-əmmək wa s-t-mad-săɣdărăn, ănɣən-t kərəf. Ǝssəbdădăn ḍarăt-a-wen meddən dăɣ-imawăn n-aɣrəm iket-net i-ad-ăqqaymən has-ăɣtafăn i-ad-əjrəwăn əmmək s-t-ănɣăn ");
INSERT INTO taq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","măšan, əjjăšăn-t isălan n-taɣdărt ta s-ăbokăn ad-has-tăt-əjən. ");
INSERT INTO taq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ǝnkărăn inəṭṭulab s-ehăḍ, jăn Sawəl dăɣ-deke hərəwăn, ăstărarăn-t s-ašrut n-ăɣalla wa iyyăḍăn iɣlăyăn aɣrəm, əssəjmăḍăn-t, ikkă Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Iwwăḍ-in ɣas, ikkă inəṭṭulab wi iyyăḍnen i-ad-dăr-săn irtəy măšan, ăksuḍăn-t iket-năsăn ed wăr-əflesăn hărwa a-s iyyăn dăɣ-săn a ămoos. ");
INSERT INTO taq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Irmăs-t-dd Bărnăbbas s-iman-net, ilwăy-t s-inəmmušal, illăɣăt-asăn əmmək wa s-inhăy Sawəl Emăli Ɣisa dăɣ-tabarăt ta n-Dămašăq d-əmmək wa s-has-imməjrăd Măssinăɣ d-turhajăt ta t-ikfa n-ad-ămmăjrăd s-ənniyăt ozjan dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud i-ad-ăjjăyh a-s Ɣisa a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ăsbărrăkăn-t ălwăqq-wen-dăɣ, irtăy dăr-săn; edăgg əkkăn dăɣ-Yărussălam-dăɣ, ăddeew dăr-săn, itajăyha s-ənniyăt ozjan ənta-dăɣ făll-isəm n-Emăli, ");
INSERT INTO taq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","itidwənnit, itamăzaɣ d-kăl-Ălyăhud wi sawalnen Tălyunanit măšan, əggădăn-dd săr-s, ad-tammăɣăn əntăneḍ-dăɣ i-tašləlt s-əjăn iman-net. ");
INSERT INTO taq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ǝslăn ayətma-s dăɣ-ăddin i-a-wen ɣas, əssəjmăḍăn-t s-aɣrəm wa n-Qăyṣăra təzzar, ikkă ḍarăt-a-wen wa n-Tarša. ");
INSERT INTO taq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ăzzăman-en, təjraw ălkănisăt ălɣafyăt dăɣ-tajiwen ti n-Ălyăhudəyăt d-Galila d-Sămari, tiṣuhun inəṭṭulab dăɣ-immun-năsăn, tinməkfin tayətte, tamašalăn hărăt iket-net dăɣ-tuksəḍa n-Emăli, idhal-tăn Unfas Šăddijăn, isawaḍ-dd fălla-săn hak ašăl ăddinăt wi iɣlăs Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ălliil Bəṭrus ənta ăkall iket-net har dd-osa iməššeddəjăn wi əzzăɣnen tadăbayt ta n-Ludd. ");
INSERT INTO taq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Illʼ-e dihen ăhaləs s-isəm-net Inyas s-a ilan əttam iwətyan ibdan, wăr kăla ifăl asəftăɣ-net. ");
INSERT INTO taq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Osʼ-e-hi-dd Bəṭrus, innʼ-as: «Inyas, ăzozăy-kăy Ɣisa Ălmasex, əbdəd, aḍh asəftăɣ-năk.» Ibdăd Inyas ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ǝnhăyăn kăl-Ludd əntăneḍ d-ăddinăt wi əzzăɣnen telămse ta n-Sarun a-wen ɣas, omănăn s-Emăli iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A-s ităjj a-wen-dăɣ, təzzaɣ tănăṭṭalibt s-isəm-net Tăbita aɣrəm wa n-Žafa, tawăɣra daɣ s-isəm wa n-Dorkas, a-wen ălmăɣna-net: «Tašənkăḍt.» Tămoos tamăḍt n-wălăt-ălxer, tajj imărkedăn ăjjootnen, təkkat. ");
INSERT INTO taq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Išilan-en-dăɣ ad-tărhin, ăba-tăt, əknăn ăddinăt tafəkka-net, əssənsăn-tăt dăɣ-ehăn n-soro. ");
INSERT INTO taq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ǝslăn inəṭṭulab wi hănen taɣrəmt-en wărăt tănmăjjaj d-Ludd a-s dd-ijjaš Bəṭrus ăkall ɣas, ăšmašălăn săr-s əssin meddən i-ad-dăr-săn dd-idaw šik. ");
INSERT INTO taq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ăddew dăr-săn Bəṭrus, əwwăḍăn-dd ɣas, əlwăyăn-t s-soro wa dăɣ-tənsa tafəkka n-tamăḍt, əlkăḍnăt-as-dd tinuḍăfen əṭṭafnăt iba-net, hallănăt, saknenăt isəlsa wi hasnăt-təẓẓəẓmăy Dorkas dăɣ-a-wa təkkăs təllʼ-e jere-snăt. ");
INSERT INTO taq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Izzəzjăr-tănăt əntănăteḍ d-tamətte iket-net, irkăɣ ḍarăt-a-wen jənnəj-s, idăl Măssinăɣ. Issəmdă tittar ɣas, innăḍ-dd săr-s, innʼ-as: «Tăbita, ənkăr-dd!» Toră-dd tiṭṭawen-net ălwăqq-wen-dăɣ, tənhăy Bəṭrus, tăqqimă-dd. ");
INSERT INTO taq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ăshătăl-as-dd s-ăfuss-net, issəbdăd-tăt, iɣră-dd iməššeddəjăn d-tinuḍăfen ḍarăt-a-wen, issəknʼ-asăn-tăt, təddar. ");
INSERT INTO taq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Šik-dăɣ a-s dd-əssăɣlăyăn isălan n-a-wen-dăɣ aɣrəm wa n-Žafa iket-net, omănăn ăddinăt ăjjootnen s-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ija Bəṭrus ăzzăman dăɣ-Žafa izzaɣ dăɣ-ehăn n-Simyon wa isafalăn ilămawăn. ");
INSERT INTO taq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aɣrəm wa n-Qăyṣăra, izzaɣ-t kăbtăn n-kăl-Roma s-isəm-net Kărnəlyus, ănnihăḍ dăɣ-ejhăn n-əssărdusa wi hănen taggayt ta s-itawănna: Iṭali. ");
INSERT INTO taq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ăhaləs ăddiinăn a ămoos ənta hakd kăl-eɣewən-net, itəkkat, infa tamətte s-a ăjjeen, hărkuk daɣ itəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ašăl iyyăn, ebre n-tezzar, ɣur ăssaɣăt wa s-kăraḍ, ănfalăl-as-dd ănjălos n-Măssinăɣ dăɣ-ehăn-net s-ălmăɣna ăsisăjrăhăn, innʼ-as: «Kărnəlyus!» ");
INSERT INTO taq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Issəjrăh Kărnəlyus dăɣ-ănjălos dăɣ-a-s irmaɣ, innʼ-as: «Emăli, năkk-da, ma tənned?» Innʼ-as ănjălos: «Tittar-năk, d-tikutawen-năk, əwwăḍnăt Măssinăɣ, wăr kăy-in-ittəwa, ");
INSERT INTO taq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","šəmmišəl ămăra meddən s-Žafa i-ad-hak-dd aɣrən Simyon wa s-itawănna Bəṭrus, ");
INSERT INTO taq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ăzzubbăt ɣur-Simyon wa isafalăn ilămawăn s-t-illa ehăn-net dăɣ-asălim n-ejărew wa səmmăn.» ");
INSERT INTO taq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ifăl-t ănjălos wa hasăn-imməjrădăn ɣas, issăɣră-dd Kărnəlyus əssin dăɣ-inaxdimăn-net, ăsdăw-tăn d-əssărdasi ăddinăn dăɣ-wi ăɣlăfnen ehăn-net, ikna tafləst. ");
INSERT INTO taq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ijă dăɣ-săn isălan n-a-wa ijăn iket-net təzzar, ăšmašăl-tăn s-Žafa. ");
INSERT INTO taq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hărwa han tabarăt ašăl wa iyyăḍăn, ad-iwwăn Bəṭrus afălla n-ehăn s-tarăhut, ad-itəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Itəddal Măssinăɣ dihen-dăɣ a-s ălluẓ, ăsdărhăn a ikša. Samăjnen-as ăddinăt imənsiwăn dihen-dăɣ a-s t-irmăs hărăt, ");
INSERT INTO taq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ojja išənnawăn a-s dd-ămerăn, ifăl-tăn-dd ăssărer măqqoorăn ătiwăṭṭăfăn s-əkkoẓ išrutăn-net, insă-dd data-s. ");
INSERT INTO taq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ăssărer-en, iskar fălla-s a-wa t-illăn dăɣ-irəzzejăn d-iẓlulam d-igḍaḍ. ");
INSERT INTO taq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Innʼ-as emăsli iyyăn ălwăqq-wen: «Bəṭrus, ăɣrəs, ăkš.» ");
INSERT INTO taq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Innʼ-as Bəṭrus: «Făw Emăli! Năkk, wăr kăla əkšeɣ a xăramăn wăla a ămmiḍăsăn.» ");
INSERT INTO taq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Innʼ-as emăsli daɣ: «Wăr kăy-iwer asăxrəm n-a-wa issăxlăl Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Itajj ănjălos măjrăd-wənnin-dăɣ i-Bəṭrus har kăraḍ ihăndăggan təzzar, imməḍkăl data-s ăssărer s-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Iqqăn a-wen-dăɣ eɣăf-net, ad-isiməktəw, itassăn ad-ijrăh ălmăɣna n-a-wa has-dd-ănfalălăn. Tamăzăyyat-ten-dăɣ a dăɣ-dd-əbdădăn meddən dăr-s sastannen dat-emm n-ehăn wa n-Simyon-i ɣur-ăzzubbăt, ");
INSERT INTO taq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","əssəstănăn s-afălla kunta ehăn-wen-dăɣ a dăɣ-izzaɣ Simyon wa s-itawănna Bəṭrus. ");
INSERT INTO taq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Isiməktəw Bəṭrus dăɣ-isălan n-tănăfalilt-ta-dăɣ a-s has-innă Unfas Šăddijăn: «Sastanăn dăr-k kăraḍ meddən, ");
INSERT INTO taq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","wăr tăsmăsăndădăd tidawt dăr-săn ed năkk a tăn-dd-ăšmašălăn săr-k.» ");
INSERT INTO taq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ăzzubbăt-dd săr-săn Bəṭrus, ăzozăy-tăn iman-net, issəstăn-tăn d-ăddălil wa făl dăr-s sastanăn. ");
INSERT INTO taq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ǝnnăn-as: «Kărnəlyus wa n-kăbtăn n-Roma a hanăɣ-dd-ăšmašălăn săr-k, ăhaləs n-ămaɣdal n-ămaksaḍ n-Măssinăɣ, ăssiimɣărăn kăl-Ălyăhud iket-năsăn a ămoos. A ilan išilan d-has-dd-ănfalăl ănjălos n-eməššeddəj n-Măssinăɣ t-ăsmătărăn d-ad-kăy-dd-isəssăɣăr, isəjəd i-a-wa has-mad-tənnəd afăl t-dd-tosed.» ");
INSERT INTO taq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ăsbărrăkăt Bəṭrus meddən wi dd-ăšmašăl Kărnəlyus, ăsmăjarăt-tăn. Ăffăw ɣas, ărkăbăn, ăddewăn dăr-săn hărăt dăɣ-ayətma-săn dăɣ-ăddin əzzaɣnen Žafa. ");
INSERT INTO taq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ǝwwăḍăn-in ašăl wa iyyăḍăn Qăyṣăra. A-s hin-osăn, iqqal-asăn Kărnəlyus ənta d-kăl-eɣewən-net d-inaflisăn-net. ");
INSERT INTO taq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Irăs-dd Bəṭrus ehăn ɣas, ilkăḍ-as-dd Kărnəlyus, oḍa daw-iḍarăn-net, irkăɣ data-s ");
INSERT INTO taq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","măšan, issəbdăd-t-dd Bəṭrus, innʼ-as: «Ahaa, wăr jed a-di, năkk-dăɣ ăgg-adəm ɣas a ămoosăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ădiiwănnen har-əjjăšăn făll-ălžămaɣăt wa ăqqiimăn dăɣ-ammas n-ehăn. ");
INSERT INTO taq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Iḍkăl Bəṭrus măjrăd, innʼ-asăn: «Təssanăm kăwăneḍ iman-năwăn a-s ăssixrăm alămăr wa n-kăl-Ălyăhud i-iyyăn dăɣ-săn ujəš n-ehăn, wăla təmmidəwa d-ere d-wăr-oher ăddin măšan, năkk-i-hi, innʼ-ahi Măssinăɣ a-s wăr leɣ s-ad-səjrăhăɣ ăwadəm wălʼ iyyăn i-ad-t-ăjăɣ a xăramăn wăla a ămmiḍăsăn. ");
INSERT INTO taq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Təssəba n-a-wen-dăɣ afăl wăr jeɣ ăsaru wălʼ iyyăn i-ad-wăr kăwăn-dd-əkkeɣ, lăɣătăt-ahi ămăra, ăddălil wa făl hi-dd-təssăɣrăm.» ");
INSERT INTO taq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Innʼ-as Kărnəlyus: «A ilan kăraḍ išilan, s-ăssaɣăt šund-wa-dăɣ, təddalăɣ Măssinăɣ s-tezzar dăɣ-ehăn-in, har šik-dăɣ, ibdăd-dd ăhaləs ilsan imălsan ăsimăɣmăɣnen dat-i, ");
INSERT INTO taq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","innʼ-ahi: ‹Kărnəlyus, tittar-năk d-tikutawen-năk, əwwăḍnăt Măssinăɣ, wăr kăy-in-ittəwa, ");
INSERT INTO taq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","šəmmišəl ămăra meddən s-aɣrəm wa n-Žafa i-ad-dd-idawăn d-ăhaləs s-isəm-net Simyon wa s-itawănna Bəṭrus, ăzzubbăt dăɣ-ehăn n-Simyon wa isafalăn ilămawăn, ehăn-net, ihʼ asălim n-ejărew wa səmmăn.› ");
INSERT INTO taq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ăšmašălăɣ-in săr-k ălwăqq-wen-dăɣ meddən-in, irăš-ak Măssinăɣ ass wa hi-dd-jed. Ămăra, iket-dăɣ-nănăɣ da-dăɣ, Măssinăɣ a dăɣ-nəjar ăṭṭăma, năsijăd daɣ iket-nănăɣ i-a-wa s-hak-inna Emăli ad-hanăɣ-t-səlmədăd.» ");
INSERT INTO taq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Iḍkăl Bəṭrus măjrăd, innă: «Tidət-dăɣ a-s, iket əjrăhăɣ a-s, Măssinăɣ, wăr-iẓley ăddinăt, ");
INSERT INTO taq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ănn-ak, e d t-illăm ere t-ăksuḍăn, itamašal erhet-net s-iqqud, tawset t-təlăt-dăɣ, ijraẓ-as. ");
INSERT INTO taq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Măssinăɣ, ăssawăy-dd s-tizarăt măjrăd-net i-kăl-Iṣrayil i-ad-tăn-isəlməd s-ălxer wa tăn-mad-ăkf ƔisaĂlmasex-i n-Emăli n-e d t-illăm ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Təssanăm a-wa ijăn dăɣ-Galila d-Ălyăhudəyăt ḍarăt asəlmaɣ wa ijʼ Exya i-ăddinăt dăɣ-aman. ");
INSERT INTO taq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɣisa wa n-Năṣirăt, ăsnăfrăn-t Măssinăɣ, ikfʼ-e Unfas, issăɣlăy-dd ăkall iket-net, itajj ălxer, izizuy ăddinăt iket-năsăn wi ăssirmăɣ Iblis. ");
INSERT INTO taq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Năjjəyh i-a-wa ija iket-net dăɣ-teje ta n-Ălyăhudəyăt d-aɣrəm wa n-Yărussălam hundăɣ har ašăl wa d-t-ărmăsăn kăl-Ălyăhud, əṣlăbăn-t făll-tajəttewt ");
INSERT INTO taq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","măšan, issənkăr-t-dd Măssinăɣ s-tărna-net jer-inəmmuttan ašăl wa s kăraḍ i-ad-t-ənhəyăn ăddinăt, iddar, ");
INSERT INTO taq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","wădden ăddinăt iket-năsăn a t-ənhăynen, wăr t-inhey ar wi ăsnăfrăn ənta iman-net i-a-wen. Ăddinăt-en, nəhʼ-en năkkăneḍ-i ohărnen išəkša d-isəswa d-Ɣisa ḍarăt a-s t-dd-ăssinkăr Măssinăɣ jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ǝnta-en-dăɣ a hanăɣ-ăsnăfrănăn, omăr-anăɣ s-axăṭṭab n-isălan-net i-ăddinăt, nəsəlməd-tăn a-s Ɣisa a ăsnăfrăn Măssinăɣ i-ad-išrăɣ e d t-illăm ăgg-adəm, wi ăba hakd wi əddărnen. ");
INSERT INTO taq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dăɣ-isălan-net ənta-en-dăɣ a dăɣ-ăjjəyhăn, ənnăn ănnăbităn iket-dăɣ-năsăn a-s, ere săr-s omănăn-dăɣ, ad-ijrəw tenăšše n-ibăkkaḍăn-net s-tărna n-isəm-net.» ");
INSERT INTO taq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ijanna Bəṭrus a-wen-dăɣ a-s dd-ăzzubbăt Unfas Šăddijăn făll-ălžămaɣăt-en iket-net. ");
INSERT INTO taq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iqqăn a-wen eɣăf n-imumənăn wi n-kăl-Ălyăhud ămelăynen ăddewnen d-Bəṭrus ed ənhăyăn Unfas Šăddijăn har dd-ăzzubbăt făll-ăddinăt s-alăṣăl-năsăn, inəẓẓulam a ămoosăn. ");
INSERT INTO taq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Sallăn-asăn daɣ ămmiijrădăn awalăn ăynaynen, samɣarăn Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Innʼ-asăn Bəṭrus ḍarăt-a-wen: «Ak, ma igdalăn i-ăddinăt făll-dd-ăzzubbăt Unfas Šăddijăn s-əmmək wa s-fălla-năɣ dd-ăzzubbăt ad-ətwəsəlmăɣăn dăɣ-aman?» ");
INSERT INTO taq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Omăr ălwăqq-wen-dăɣ s-ad-ətwəsəmăɣăn dăɣ-aman s-isəm n-Ɣisa Ălmasex. Ittăr Kărnəlyus d-ălžălmaɣăt-net dăɣ-Bəṭrus ad-ɣur-săn isəssikəy a lăn išilan. ");
INSERT INTO taq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ǝslăn inəmmušal d-ayətma wi iyyăḍnen hănen teje ta n-Ălyăhudəyăt a-s iyyăḍ dăɣ-inəẓẓulam omănăn s-măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ălwăqq wa dd-iqqăl Bəṭrus Yărussălam, ămẓăyẓăyăn-t imumənăn wi n-dăgg-Ălyăhud jănen amili hărăt, ənnăn-as: ");
INSERT INTO taq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Kăyy, ma kăy-ăsihălăn ujəš n-ehăn n-ăddinăt wăren ămelăy tihərəd dăr-săn imənsiwăn?» ");
INSERT INTO taq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Issəntʼ-asăn Bəṭrus afəssăr n-isălan s-iyyăn-iyyăn ɣur-alăṣăl-năsăn har ašăl-i-dăɣ, innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Heɣ aɣrəm wa n-Žafa, təddalăɣ Măssinăɣ a-s dd-heɣ oḍeɣ, irmăs-ahi hărăt, ănfalăl-ahi-dd ăssărer dd-ifalăn išənnawăn ");
INSERT INTO taq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","făll-ənsanăt taɣsiwen d-tawăqqast d-iẓlulam d-igḍaḍ. Zajăzzeɣ a-wa insăn făll-ăssărer-en-dăɣ ");
INSERT INTO taq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","a-s əsleɣ i-emăsli hi-innăn: ‹Bəṭrus, ăɣrəs, ăkš› ");
INSERT INTO taq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","măšan, ənneɣ-as: ‹Făw Emăli! Năkk, wăr kăla əkšeɣ a xăramăn wăla a ămmiḍăsăn.› ");
INSERT INTO taq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Innʼ-ahi emăsli-ənnin daɣ: ‹Wăr kăy-iwer asăxrəm n-a-wa issăxlăl Măssinăɣ.› ");
INSERT INTO taq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Itajj a-wen har kăraḍ ihăndăggan təzzar, imməḍkăl dat-i ăssărer s-išənnawăn. ");
INSERT INTO taq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Iqqan a-wa ijăn eɣăf-in dihen-dăɣ a-s dd-əbdădăn kăraḍ meddən dd-falnen Qăyṣăra dat-emm n-ehăn wa ɣur-ăzzubbeɣ, ");
INSERT INTO taq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","innʼ-ahi Unfas Šăddijăn ad-dăr-săn idawăɣ šik. Ăddewăɣ dăr-săn, ăddeewăɣ daɣ d-săḍis ayətma wi t-əllănen data-wăn ămăra-dăɣ s-ehăn n-Kărnəlyus-i hi-dd-issăɣrăn. ");
INSERT INTO taq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Năwwăḍ-in ɣas, ija dăɣ-năɣ Kărnəlyus isălan n-əmmək wa s-has-dd-ănfalăl ănjălos wa has-innăn: ‹Šəmmišəl ămăra ăwadəm s-aɣrəm wa n-Žafa i-ad-dd-idaw d-ăhaləs s-isəm-net Simyon wa s-itawănna Bəṭrus. ");
INSERT INTO taq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Afăl dd-osa, ad-hak-ăllăɣăt əmmək wa s-mad-tăɣləsăd kăyy d-eɣewən-năk.› ");
INSERT INTO taq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ămmiijrădăɣ-asăn dihen-dăɣ, a-s fălla-săn dd-ăzzubbăt Unfas Šăddijăn iket-năsăn s-əmmək wa s-fălla-năɣ dd-ăzzubbăt năkkăneḍ ašăl ăzzarăn. ");
INSERT INTO taq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ǝkteɣ-dd ălwăqq-wen măjrăd n-Emăli Ɣisa a-s inna: ‹Exya, issəlmăɣ dăɣ-aman măšan, kăwăneḍ, ad-tətwəsəlmăɣăm dăɣ-Unfas Šăddijăn.› ");
INSERT INTO taq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɣas šămad ijʼ-asăn Măssinăɣ ihuk šund wi hanăɣ-ija a-s nomăn s-Emăli ƔisaĂlmasex, mi ămoosăɣ timsəgəggiyăɣ d-Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Islʼ ălžămaɣăt i-isălan-win-dăɣ ɣas, sămmeḍ ənniyăt-net ad-tiimələn Măssinăɣ, jannen: «Itbat a-s inəẓẓulam-dăɣ, ikfʼ-en Măssinăɣ turhajăt n-ad-utabăn, amənăn săr-s, əjrəwăn əntăneḍ-dăɣ tămudre ta n-tidət.» ");
INSERT INTO taq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Imumənăn wi əmmăhăšnen ḍarăt tissust ta təlkămăt i-tamăttant n-Stifan, əkkăn dăɣ-săn iyyăḍ ăkall wa n-Finisya, əkkăn iyyăḍ awtəl wa n-Qəbrus, əkkăn iyyăḍ aɣrəm wa n-Intyuš, măšan wăr xəṭṭəb təššəm-năsăn ar i-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Dăɣ-a-wen-dăɣ a dăɣ-săn əkkăn iyyăḍ əwanen dăɣ-ăkall wa n-Qəbrus d-wa n-Libya aɣrəm wa n-Intyuš, ad-xaṭṭăbăn dihen isălan n-ălxer n-Emăli Ɣisa i-kăl-Ălyunan. ");
INSERT INTO taq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Idhal-tăn Emăli dăɣ-a-wa tăjjăn. Omănăn ăddinăt ăjjootnen dăɣ-a-wen-dăɣ, əkfăn iman-năsăn i-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Təslʼ ălkănisăt ta hăt Yărussălam i-a-wen ɣas, tăšmašăl-dd Bărnăbbas s-aɣrəm wa n-Intyuš. ");
INSERT INTO taq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Osa-hin, inhăy tihusay n-ănnuɣmăt n-Măssinăɣ ɣas, ăsdăwăt-t a-wen, ad-isamătar imumənăn d-ad-əknən uḍəf n-Emăli s-ulhawăn əjlaynen. ");
INSERT INTO taq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ămoos ənta iman-net ăhaləs n-emăssărho, iḍnay Unfas Šăddijăn, ăṣṣoohăt daɣ dăɣ-immun-net. Išilan-en-dăɣ, omănăn ăddinăt ăjjootnen s-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dăɣ-a-wen-dăɣ ad-ikka Bărnăbbas taɣrəmt ta n-Tarša itammăɣ i-Sawəl, ijrăw-t ɣas, ilwăy-t-dd s-Intyuš. ");
INSERT INTO taq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jăn dihen awătay imdan ănniixdămăn d-ălkănisăt n-aɣrəm-en, saɣrʼ-en tamətte tăjjet. Aɣrəm-wen-dăɣ n-Intyuš a dăɣ-ătwăɣrăn inəṭṭulab n-Ɣisa s-isəm wa n-ălmăssexităn s-tizarăt. ");
INSERT INTO taq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ăzzăman-en-dăɣ ad-dd-fălăn ănnăbităn iha Ăggăbbas aɣrəm wa n-Yărussălam, əkkăn-dd Intyuš. ");
INSERT INTO taq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ǝnta-en-dăɣ a ibdădăn, ălolăy s-tărna n-Unfas Šăddijăn n-a-s ilkam ad-ăj laẓ lăbasăn făll-ărori n-ăkall iket-net. Ija daɣ a-wen s-əmmək-wen-dăɣ s-tăn-innă dăɣ-ăzzăman wa d-ămoos Kəlod ămănokal n-ăkall. ");
INSERT INTO taq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Təssəba n-a-wen-dăɣ a făl, ănmănnakăn imumənăn wi hănen Intyuš i-ad-arəj hak iyyăn dăɣ-săn s-a-wa iṭṭăf d-a-wa s-ăddoobăt i-ayətma-săn dăɣ-ăddin wi hănen Ălyăhudəyăt. ");
INSERT INTO taq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ǝjăn a-wen s-əmmək-en-dăɣ təzzar, jăn tasəssiwit-ten-dăɣ jer-ifassăn n-Bărnăbbas d-Sawəl i-ad-tăt-in-səssiwəḍăn inušămăn n-ălkănisăt ta hăt Ălyăhudəyăt. ");
INSERT INTO taq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ăzzăman-wen-dăɣ, ad-izzăn ămănokal Harudəs Ăgribba s-iyyăḍ dăɣ-ăddinăt n-ălkănisăt ta hăt Yărussălam, ad-tăn-itiɣəzzəbut. ");
INSERT INTO taq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dăɣ-a-wen-dăɣ, ad-inɣa s-tăkoba Yaqub wa n-ăŋŋa-s n-Exya. ");
INSERT INTO taq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Inhăy a-s a-wa ija, ijraẓ i-kăl-Ălyăhud ɣas, ăstărmăs Bəṭrus ašăl n-ămudd wa n-Faṣka-i-dăɣ tattăn ăddinăt tijəlwen ti wăr ha tăẓẓa, ");
INSERT INTO taq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ijʼ-e dăɣ-takărmut təzzar, issəbdăd əkkoẓăt taggayen n-əkkoẓ-əkkoẓ əssărdusa i-ad-t-ăɣləfăn ed irha ad-t-dd-isəbdəd dat-kăl-ăššăreɣa afăl okăy ašăl wa n-Faṣka. ");
INSERT INTO taq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iha Bəṭrus takărmut-en-dăɣ măšan, a-s ija a-wen-dăɣ, ălkănisăt ənta, tăžžiimăɣ, tajăynan dat-Măssinăɣ, tattăr dăɣ-s ad-t-dd-ăswăyyăn. ");
INSERT INTO taq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Dăɣ-ehăḍ wa n-dat-wa d-ila Harudəs ad-t-išrăɣ, insa Bəṭrus dăɣ-takărmut jer-əssin əssărdusa dăɣ-s janen sănatăt tišəm, əbdadăn daɣ əssărdusa iyyăḍ dat-emm n-takărmut. ");
INSERT INTO taq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Har šik-dăɣ, osă-dd ănjălos n-Emăli edăgg-en, ămlăwlăw səllul wa iha, ăkrăttăt ănjălos tasăja n-Bəṭrus, issənkăr-t, innʼ-as: «Tărmaḍ, əbdəd šik!» Sărnăt fălla-s tišəm ăssaɣăt-wen-dăɣ, oḍănăt. ");
INSERT INTO taq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Innʼ-as ănjălos daɣ: «Tărmaḍ, əjbəs taməntəka-năk, əsəl tifădelen-năk, uhən, ăj anăkăbba-năk, əlkəm-ahi.» Ija Bəṭrus a-wa has-innă ănjălos iket-net. ");
INSERT INTO taq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Izjăr-dd Bəṭrus takărmut, ilkăm i-ănjălos măšan har ămăra-dăɣ, ija ɣur-s a-s tăharjit ɣas a-wa-dăɣ iket-net. ");
INSERT INTO taq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ǝkkăn-dd edes i-əssărdusa wi ăzzarnen, əkkăn-dd daɣ edes i-taggayt ta s-sănatăt har dd-ohăẓăn tashărt ta n-tăẓoli təkfăt emm-net aɣrəm, tămera d-iman-net data-săn, əzjărăn, əjjăšăn ammas n-tăšarrit ɣas, ifăl ănjălos Bəṭrus. ");
INSERT INTO taq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ălwăqq-wen-dăɣ, ad-t-dd-iqqăl ənniyăt-net, ikkăs ăššăk a-s Măssinăɣ a săr-s dd-ăšmašălăn ănjălos-net i-ad-t-dd-ikkəs jer-ifassăn n-Harudəs, d-a-wa lăbasăn s-ărhăn kăl-Ălyăhud ad-has-t-əjən. ");
INSERT INTO taq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ijrăh taɣărha-net ămăra ɣas, ikkă ehăn n-Măryăma ta n-ma-s n-Exya wa s-itawănna Marqəs, ăžžiimmăɣăn ɣur-s imumənăn ăjjootnen təddalnen Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ikkəwkăw emm n-ehăn, tošăl-dd săr-s tămawaḍt n-tănaxdimt s-isəm-net Roda, təssəstăn-t d-ere wa ămoos, ");
INSERT INTO taq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","təzzăy temăslăɣt-net măšan, təja tedăwit-ta-dăɣ făl hin-təttəwa wăla-dăɣ ad-has-tarr emm n-ehăn, tošăl, tăqqăl ammas n-ehăn, təja isălan dăɣ-ălžămaɣăt n-a-s Bəṭrus a itakăwkawăn emm n-ehăn. ");
INSERT INTO taq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ǝslăn i-a-wa jănna ɣas, əjăn-tăt tenəbbeddəlt, ənnăn-as: «A-di ănjălos-net ɣas a-s təsled.» Măšan, tənnʼ-asăn: «Tidət-in, əjlayăɣ a-s ənta.» ");
INSERT INTO taq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Jannen a-wen-dăɣ, itakăwkaw-asăn Bəṭrus emm n-ehăn. Ǝglăn, orăn-as-t, əqqălăn-dd ɣas, tofʼ-en tăkunt n-a-s tidət-dăɣ a-s ənta a-wa. ");
INSERT INTO taq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ăswăr-asăn assəkăḍ emm-net, ăstafăy-asăn d-ad-susəmăn, ad-hasăn-itajj ḍarăt-a-wen isălan n-əmmək wa s-t-dd-ikkăs Emăli dăɣ-takărmut. Innʼ-asăn daɣ: «Ăglăt, ăjăt ămăra isălan dăɣ-Yaqub d-ayətma-năɣ dăɣ-ăddin wi iyyăḍnen.» Ifăl-tăn ḍarăt-a-wen, ikkʼ edăgg iyyăn. ");
INSERT INTO taq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ăffăw ɣas təjă tămdărwăy măqqoorăt dăɣ-əssărdusa, hak iyyăn isastan amidi-net d-a-wa ija Bəṭrus. ");
INSERT INTO taq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ăssomăɣ-asăn-t Harudəs măšan, ăba-hasăn-t-dd. Issăɣră-dd əssărdusa wi s-kăla t-ăɣlăfăn, omăr s-ad-ətwəsəstənăn təzzar, ămmătăn. Ifăl Harudəs ḍarăt-a-wen teje ta n-Ălyăhudəyăt, ikkʼ aɣrəm wa n-Qăyṣăra i-ad-dăɣ-s isəssikəy a lăn išilan. ");
INSERT INTO taq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A-s ităjj a-wen-dăɣ, ihʼ aḍkăr n-iɣărman wi n-Tir d-Săyda ămănokal Harudəs. Təssəba n-ad-ăj ălxer dăr-săn a făl dd-ăšmašălăn iɣărman-en ălžămaɣăt n-ălɣafyăt. Ănmănnakăn d-Blastas-i ănnihăḍăn dăɣ-ehăn n-ămănokal Harudəs d-a-wa t-dd-iqqălăn iket-net. Ǝnta-en-dăɣ a dăɣ-əttărăn ad-ilɣəd ămănokal i-ad-ăj ălxer ed isudar-năsăn teje-ten-dăɣ făll-ixkăm Harudəs a dd-təffalăn. ");
INSERT INTO taq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ašăl wa d-əlăn s-ad-sətbətən ălxer jere-săn, ăssahăɣ-dd Harudəs ašăl dăɣ-isəlsa-net wi n-təmmənukəla, ăqqima făll-tasăqqaymut-net ta n-təmmənukəla, imməjrăd i-tamətte. ");
INSERT INTO taq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Təsla tamətte i-măjrăd-net ɣas, tăsɣăyya dăɣ-išənnawăn, ad-janna: «Ašăl-i, Măssinăɣ iman-net a hanăɣ-ămmijrădăn, wădden ăgg-adəm.» ");
INSERT INTO taq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Diha-dăɣ d-tənna tamətte a-wen-dăɣ, ad-has-ăẓẓuggăt ănjălos n-Măssinăɣ ed unjăy ikfa Măssinăɣ semɣar wa dăr-ănihăjja. A-s t-in-əjrăhăn ăddinăt, əfradnăt dăɣ-s tiwəkkawen har ămmut. ");
INSERT INTO taq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Intăj măjrăd n-Măssinăɣ dăɣ-idăggan ăjjootnen, omănăn ăddinăt dăɣ-išilan-win-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ăssawăḍ-in Bărnăbbas d-Sawəl ămašal-năsăn i-kăl-Yărussălam ɣas, əqqălăn siha s-dd-hăn, ăddeewăn ămăra d-Exya wa s-itawănna Marqəs. ");
INSERT INTO taq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ălkănisăt ta hăt aɣrəm wa n-Intyuš, ănnăbităn-net d-imăsăɣran-net da: Bărnăbbas, Simyon wa s-itawănna «Ekăwel», Lisyus wa n-ăkall wa n-Qərwan, Mănahin wa s-ənta d-Harudəs Intibbas a ədwălnen dăɣ-iyyăn n-ehăn d-Sawəl. ");
INSERT INTO taq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ašăl wa n-ălɣibadăt n-Emăli, ăẓuumăn imumənăn, ăžžiimmăɣăn dăɣ-iyyăn n-edăgg, ɣabbădăn Emăli a-s hasăn-innă Unfas Šăddijăn. «Ăjăt-ahi Bărnăbbas d-Sawəl s-edes i-ămašal wa s-tăn-dd-ăɣreɣ.» ");
INSERT INTO taq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ăẓumăn, dălăn Măssinăɣ təzzar, ăswărăn ifassăn-năsăn Bărnăbbas d-Sawəl, oyyăn-tăn, əglăn. ");
INSERT INTO taq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Oɣăd-tăn Unfas Šăddijăn, ăzzubben s-aɣrəm wa n-Slukya təzzar əjjăšăn turăft n-aman, jăn tamdujt ta n-Qəbrus; ");
INSERT INTO taq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","əwwăḍăn-in taɣrəmt s-isəm-net Sălamin ɣas, jăn isălan n-măjrăd n-Măssinăɣ dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, ămoos-asăn Exya Marqəs ămadhal. ");
INSERT INTO taq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ǝjlăyăn awtəl wa n-Qərwan iket-net har Bafus, əjrăwăn dihen ăgg-Ălyăhud n-emăssăxăr s-isəm-net Bărɣisa, ijanna s-bahu, ănnăbi a ămoos, ");
INSERT INTO taq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","izzaɣ ɣur-Saržus Buləs-i n-ămănokal n-awtəl, ăhaləs, a-wen, iknan terše n-tayətte. Isla ămănokal Bărnăbbas d-Sawəl ɣas, issăɣrʼ-en-dd dăɣ-derhan n-ad-t-səslən măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iggăd-dd Ɣəlimas wa n-emăssăxăr, a-wen isəm-net dăɣ-Tălyunanit, ăšmăšăkkăt-asăn măjrăd, ad-itattăr ad-hin-išəšləl ămănokal făll-isălan n-immun. ");
INSERT INTO taq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ibdăd-dd săr-s Sawəl-i s-itawănna daɣ Buləs, iḍkar-t Unfas Šăddijăn, ikna asəns n-akăyad-net făll-Ɣəlimas, ");
INSERT INTO taq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","innʼ-as: «Ǝyya isəm n-ăgg-Iblis, kăyy wăr təḍneyăd a săl amsud d-təlmənufăɣa, ašănjo n-a-wa oɣădăn a tămoosăd, isəm n-eməkkerrəs, ɣas ăba-hak a kăy-išilləwăn ar asəfraɣ n-tabarăt ta toɣădăt n-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ămăra, səjəd-ahi: ad-fălla-k isăns Emăli ăfuss-net, tăddărɣălăd, tăhajəd wăr tənheyăd tăfukt s-tiṭṭawen-năk.» Wărnăt tihay d-tăhoẓt tiṭṭawen-net ăssaɣăt-wen-dăɣ, ad-isikluluf siha d-siha, itammăɣ i-ere t-ilwăyăn. ");
INSERT INTO taq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Inhăy ămănokal n-ăkall a-wa ijăn ɣas, omăn, təḍăs teɣăre ta s-islă făll-Emăli ulh-net. ");
INSERT INTO taq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ijjăš Buləs d-imidiwăn-net turăft n-aman dăɣ-Bafus, əkkăn aɣrəm wa n-Birga dăɣ-ăkall wa n-Bănfəli, dihen-dăɣ a dăr-săn ibḍa Marqəs, ăssof ad-iqqəl Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Fălăn Birga, əkkăn Intyuš ta n-teje ta n-Bəssidi. Ijʼ-en ašăl wa n-əssəbət dihen ɣas, əkkăn ehăn n-ăddin wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ăqqimăn dihen-dăɣ, itawăɣra alămăr n-Măssinăɣ d-a-wa ənnăn ănnăbităn dăɣ-əlkəttabăn ɣas, ənnăn-asăn imizărăn n-ehăn wa n-ăddin: «Meddən, ayətma-năɣ, kunta lam isəmməterăn s-tărham ad-tăn-təjəm i-ăddinăt, ăxṭəbăt-asăn.» ");
INSERT INTO taq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ăstafăy Buləs i-ălžămaɣăt, ibdăd, innʼ-asăn: «Kăl-Iṣrayil d-imaksaḍăn n-Măssinăɣ, săjdăt-ahi. ");
INSERT INTO taq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Măssinăɣ n-tamətte-ta-dăɣ n-Iṣrayil, ənta a ăsnăfrănăn abbatăn-nănăɣ, ăssetʼ-en hărwa han ăkall wa n-Miṣra təzzar, izzəzjăr-asăn-t-dd s-tărna n-ăfuss-net, ");
INSERT INTO taq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","wăr t-illa erk ălxal wăr has-əjješăn măšan, ăẓẓăydăr fălla-săn har jăn əkkoẓăt timərwen n-awătay dăɣ-tenere. ");
INSERT INTO taq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ḍarăt a-s tăn-ikfa tărna făll-əssa əddəwəlăn dăɣ-Xăna a tăn-ikfa tăkasit ta hasăn-ămoos ăkall-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Okăy ḍarăt-a-wen a ojărăn əkkoẓăt timaḍ n-awătay d-səmmosăt timərwen təzzar, ikfʼ-en ălqaḷḷităn-i fălla-săn ămnakălnen hundăɣ har ăzzăman wa n-ănnăbi Sumăyla. ");
INSERT INTO taq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ǝnta-en-dăɣ a dăɣ-əttărăn kăl-Iṣrayil ere fălla-săn ămnakălăn, ijʼ-asăn a-wa dăɣ-s əttărăn, ikfʼ-en Măssinăɣ Sayəl ăgg Kis wa n-tawset ta n-Bănyamin. Ămnakăl fălla-săn əkkoẓăt timərwen n-awătay ");
INSERT INTO taq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","măšan, innăḍ fălla-s Măssinăɣ, ijă-dd Dawəd ăgg Yasa-i s-ənta a făll inna Măssinăɣ: ‹Ǝjrăwăɣ Dawəd ăgg Yasa, ənta a-s ăhaləs-wa s-ulh-net ilkam i-wa-nin, ad-ămašăl erhet-in iket-net.› ");
INSERT INTO taq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ijəllan n-Dawəd-en-dăɣ a dăɣ-dd-ikkăs Măssinăɣ Ɣisa-i s-ənta a-s Ămaɣlas wa s-ijjăš ărkăwăl-net i-kăl-Iṣrayil. ");
INSERT INTO taq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ɣisa, a-s ija Exya isălan-net hărwa wăr-issənta ămašal-net ălwăqq wa d-ixaṭṭăb asəlmaɣ dăɣ-aman i-ad-umas a-wen ašămol n-tătubt i-tamətte n-Iṣrayil iket-net. ");
INSERT INTO taq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ălwăqq wa dd-tohăẓ tamăttant n-Exya, innă i-tamətte: ‹Mi s-tordam ămoosăɣ-t? Wăr teɣalăt năkk a-s ătwănna ilkam a dd-asăɣ; wa s-ătwănna ilkam a dd-ass, imal-dd, ənta-en, wăr-ănhăjjăɣ wăla-dăɣ d-ad-əkkəsăɣ tifădelen dăɣ-iḍarăn-net.› ");
INSERT INTO taq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ayətma-ɣ wi n-ihăyawăn n-Ibrahim, kăwăneḍ-i ăksuḍnen Măssinăɣ, năkkăneḍ a-s dd-ăssawăy Emăli măjrăd wa n-əlɣəllas. ");
INSERT INTO taq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ădduuttăt a-s Yărussălam d-imizărăn-net, əžžəžhălăn iman-năsăn i-Ɣisa, wăr t-illa a əfhamăn dăɣ-a-wa ənnăn ănnăbităn dăɣ-əlkəttabăn wi titwăɣrinen hak əssəbət n-ălɣibadăt dăɣ-ihănan n-ăddin, ăswărăn Ɣisa uḍlem, ittărmăs, ");
INSERT INTO taq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","a-s ija a-wen, wăr t-illa uḍlem fălla-s ăttijrăwăn, hakd a-wen-dăɣ, əttărăn dăɣ-Bilatəs ad-ətwəjjən iman-net. ");
INSERT INTO taq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ǝssətbătăn a-wa fălla-s ənnăn əlkəttabăn ɣas, əkkăsăn-t-dd făll-tajəttewt, jăn-t dăɣ-aẓəkka ");
INSERT INTO taq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","măšan, issənkăr-t-dd Măssinăɣ jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ănfalăl-dd i-ăddinăt ăjjootnen dăɣ-wi dăr-s ăddewnen wa-dăɣ n-Galila har Yărussălam, ija išilan ăjjootnen illʼ-e jere-săn. Ămăra, ăddinăt-win-dăɣ s-dd-ănfalăl a tajăyhanen i-isălan-win-dăɣ data-wăn. ");
INSERT INTO taq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Năkkăneḍ ămăra, nətajjʼ-awăn isălan-win-dăɣ n-ălxer s-ătwăjja ărkăwăl-năsăn i-abbatăn-nănăɣ. ");
INSERT INTO taq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ărkăwăl-en, năkkăneḍ-i ămoosnen ihăyawăn-năsăn a-s t-ijjăš Măssinăɣ ənta-i dd-issənkărăn Ɣisa jer-inəmmuttan s-əmmək wa s-iktăb dăɣ-əlxəsəb-wa s-əssin n-əlkəttab wa n-Ăẓẓăbur, innă Măssinăɣ dăɣ-isălan n-Ɣisa: ‹Kăyy a-s Rure-ɣ, orăwăɣ-kăy ašăl-i-dăɣ.› ");
INSERT INTO taq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ăywa, Ɣisa ya, Măssinăɣ iman-net a innăn, a t-dd-issənkărăn jer-inəmmuttan hărwa wăr-inhey mărkăhaw wa n-aẓəkka. A-wen-dăɣ daɣ a făl innă dăɣ-isălan-net: ‹Ad-kăwăn-ăkfăɣ ălbăraka wa šăddijăn itbătăn s-jeɣ ărkăwăl n-ad-t-ăkfăɣ i-ănnăbi Dawəd.› ");
INSERT INTO taq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iktab daɣ a-s: ‹Wăr-e təyyəd Eməššeddəj-năk irakkăh dăɣ-aẓəkka.› ");
INSERT INTO taq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Təssanăm a-s Dawəd ənta iman-net ămešăl a-wa fălla-s irha Măssinăɣ dăɣ-ăzzăman-net təzzar, ămmut, inhăy mărkăhaw wa n-aẓəkka šund a-wa jăn abbatăn-net wi has-dd ăzzarnen ");
INSERT INTO taq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","măšan Ɣisa ənta, wăr-inhey mărkăhaw-wen-dăɣ ed, issənkăr-t-dd Măssinăɣ jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ayətma, əlmədăt a-s Ɣisa-i, ənta a ɣur-hawăn-t-təlla tenăšše n-ibăkkaḍăn, ənta a-s sămdo n-a-wa hawăn-ihăn alămăr wa dd-ăzzăbbăt Măssinăɣ făll-ănnăbi Mosa iket-net, ");
INSERT INTO taq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ənta a ɣur-ijarrăw e d t-illăm amumən idəm dat-Măssinăɣ, ");
INSERT INTO taq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","a-wen-dăɣ a făl, agəẓăt iman-năwăn iket-di d-wăr fălla-wăn oḍa ăššar-wa s-ənnăn ănnăbităn. Innă Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Ǝnhəywăt, kăwăneḍ-i əḍnăynen kəssən, tărməset-kăwăn tăqqăn n-eɣăf, ibăhet-kăwăn făl-a-s ad-əjən ijităn dăɣ-ăzzăman-năwăn s-kud-dăɣ ijʼ-awăn ăwadəm isălan-năsăn, wăr mad-t-təfləsăm.› » ");
INSERT INTO taq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Izjăr-dd Buləs d-Bărnăbbas ehăn n-ăddin ɣas, əttărăn dăɣ-săn ăddinăt a dd-aləsăn uɣəl əssəbət-wa ilkămăn i-ad-hasăn-aləsən iji n-isălan-wi-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Immăhăš ălžămaɣăt ɣas, əlkămăn-asăn kăl-Ălyăhud ăjjootnen d-iyyăḍ əlkamnen i-ăddin wa n-kăl-Ălyăhud, ădwănnen dăr-săn, sisibuyunăn-tăn, sikusăn-tăn ăššăk n-ad-ăqqăymən əṭṭafăn ănnuɣmăt n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ijă ašăl wa n-əssəbət-i n-tăsonfat ɣas, ăddew-dd aɣrəm iket-dăɣ-net i-ad-isəjəd i-măjrăd n-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ǝnhăyăn kăl-Ălyăhud əjut n-tamətte ɣas, osămăn, ad-šimšəkken măjrăd i-Buləs, jannen isikufor. ");
INSERT INTO taq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Buləs d-Bărnăbbas ămoosăn meddən ozjanen s-itbat immun-năsăn, ənnăn-asăn: «Kăwăneḍ a-s ăniihăjja ad-hawăn-itwăxṭəb măjrăd n-Măssinăɣ s-tizarăt măšan, tunjăyăm săr-s ed, wăr tăsnăhăjjăm iman-năwăn d-tămudre ta tăɣlălăt, a-wen-dăɣ a făl ămăra, əlmədăt a-s ad-nənnăḍ s-inəẓẓulam. ");
INSERT INTO taq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ǝnta-den-dăɣ a-wa s-hanăɣ-omăr Emăli dăɣ-əlkəttab-net a-s innă: ‹Jeɣ kăy-ănnur i-tiwsaten i-ad-hin-səssiwăḍəd əlɣəllas ifăyyăn n-ăkall iket-net.› » ");
INSERT INTO taq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ǝslăn inəẓẓulam i-a-wen ɣas, əddəwen, ad-timələn măjrăd n-Emăli, omănăn wi s-ătiwatăs ad-əjrəwăn tămudre ta tăɣlălăt iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Intăj măjrăd n-Emăli dăɣ-ăkall iket-net. ");
INSERT INTO taq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Jăn kăl-Ălyăhud erk iman dăɣ-tiḍeḍen ătiwăsămɣărnen d-imuzărăn n-aɣrəm, oḍă-dd ălɣizabăt səmmăn făll-Buləs d-Bărnăbbas, ăsmăhăḍăn dăɣ-săn ăddinăt i-ad-əzjărăn isăɣlay n-ăkall-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ǝbbəkbăkăn ăboqqal n-iḍarăn-năsăn făll-aɣrəm-en təzzar, əkkăn aɣrəm wa n-Ikanyun. ");
INSERT INTO taq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ăqqimăn-dd inəṭṭulab wi n-Intyuš ḍarăt tekle-năsăn, əknan dăɣ-tedăwit, iḍnay-tăn daɣ Unfas Šăddijăn. ");
INSERT INTO taq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Olăs Buləs d-Bărnăbbas dăɣ-Ikanyun iji n-a-wa s-əzzăyăn iji-net dăɣ-ăzzăman-en-dăɣ, əjjăšăn ehăn n-ăddin wa n-kăl-Ălyăhud, jăn dăɣ-s măjrăd-wa-dăɣ făl omănăn kăl-Ălyăhud ăjjootnen d-tamətte tăjjeet dăɣ-ta n-kăl-Ălyunan, ");
INSERT INTO taq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","măšan, əssənkărăn-dd kăl-Ălyăhud wi s-ăqqurăn ulhawăn-năsăn inəẓẓulam, jăn dăɣ-săn erk iman i-ad-əššunjen ăddinăt-wi omănnen s-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ădwănnăt Buləs d-Bărnăbbas dăr-săn har jăn ăzzăman, tajjăn-asăn măjrăd ădduutten, tajăyhen-asăn făll-Emăli. Ikfʼ-en daɣ Măssinăɣ ănnuɣmăt s-tajjăn ijităn n-Măssinăɣ d-hărătăn ăssuksăḍnen, wăr t-illa a tăn-ăssirmăɣăn, ed ăsiwăr-tăn Emăli tărna-net. ");
INSERT INTO taq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Təbḍa tamətte n-aɣrəm iket-net, əlkămăn iyyăḍ i-kăl-Ălyăhud, əlkămăn wi iyyăḍnen i-inəmmušal. ");
INSERT INTO taq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ǝjjăšăn-dd erk iman inəẓẓulam d-kăl-Ălyăhud iyyăḍ d-imizărăn-năsăn, ad-tattărăn əmmək s-ăsmăḍrăyăn Buləs d-Bărnăbbas, əkfən-tăn sămmăjori n-tihun, ");
INSERT INTO taq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","əlmădăn inəṭṭulab s-a-wen ɣas, ăjewăḍăn s-Likawni d-Listra d-Darba d-attayăn n-tidbi-tin-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jăn isălan n-Ălənžil dăɣ-iɣărman-win-dăɣ iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Aɣrəm wa n-Listra, ihʼ-e ăhaləs n-anăbdon s-a dd-iwa-dăɣ, ibdan. ");
INSERT INTO taq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Islă i-Buləs ămmijrăd ɣas, ăsjăd-as. Inhăy Buləs dăɣ-tiṭṭawen-net a-s ila immun t-ăzozăyăn, iɣləs ɣas, ");
INSERT INTO taq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","innʼ-as s-afălla: «Ǝbdəd făll-iman-năk.» Iggăd ăhaləs, irjăš. ");
INSERT INTO taq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ǝnhăyăn ăddinăt a-wa ija Buləs ɣas, ăsɣăren, ənnăn dăɣ-tawalt ta n-Likawni: «Ašăl-i, məssaw-năɣ dd-falnen išənnawăn dăɣ-taɣəssa n-dăgg-adəm a dd-ăzzubbătnen fălla-năɣ.» ");
INSERT INTO taq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jăn i-Bărnăbbas isəm Zuss, jăn i-Buləs isəm Armas ed, ənta a ămmijrădăn ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ošăl-dd u-tikutawen wa n-Zuss ila ehăn-n-ămudd wa ihăn emm n-aɣrəm, ilwăy-dd iwdesăn d-tăboyt n-isəhhəska, ad-itattăr ənta d-tamətte əmmək s-jăn hărătăn-win-dăɣ takute i-Buləs d-Bărnăbbas. ");
INSERT INTO taq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ǝlmădăn inəmmušal s-a-wen ɣas, ăsɣărrawen inkubba-năsăn făll-iman-năsăn, ošălăn s-tamətte ăseɣăren, ");
INSERT INTO taq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","jannen: «Ya meddən! Wăr jem a-di, ma ămoos a-wa s-tăbokăm iji-net? Năkkăneḍ dăgg-adəm ɣas a nămoos, wăr t-illa a dăr-wăn nəẓlay. Isălan n-ălxer a hăwăn-năwway i-ad-təbḍəwăm d-mălayăɣna, tutabăm s-Măssinăɣ-i n-Ămaɣlal dd-ixlăkăn išənnawăn d-ăkall d-ijərwan d-a-wa tăn-ihăn iket-net. ");
INSERT INTO taq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ibda, oyya əzzurəyyatăn-ti okăynen əlkamnăt i-erhet n-iman-năsnăt ");
INSERT INTO taq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","măšan hakd a-wen-dăɣ, wăr hin-issəbdăd fălla-snăt ălxer-net. Ǝnta a fălla-wăn dd-ăzzăbben ijənnawăn, iɣmăr-kăwăn s-ăzzămanăn olaɣnen, ikfʼ-iwăn isudar, ijʼ ălxer dăɣ-ulhawăn-năwăn.» ");
INSERT INTO taq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jannen-asăn a-wen-dăɣ măšan, šărnaš d-əgdălăn tikutawen-ti s-ărhan ăddinăt a tănăt-əjən dăɣ-təssəba-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Osăn-dd hărăt dăɣ-kăl-Ălyăhud dd-falnen Intyuš d-Ikanyun, əzzănăn s-Buləs. Ǝkfăn-t sămmăjori n-tihun təzzar, ăšrăwrăwăn-t har t-əzzəzjărăn aɣrəm ed, ăɣelăn ăba-t. ");
INSERT INTO taq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ǝlkămăn-as-dd inəṭṭulab-net, ăɣlăyɣălăyăn-t ɣas, inkăr-dd, olăs ujəš n-aɣrəm. Ăffăw ɣas, ăddew d-Bărnăbbas s-Darba. ");
INSERT INTO taq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ăslănžen aɣrəm-wen-dăɣ, jăn dăɣ-s inəṭṭulab ăwwăḍnen hărăt təzzar, əqqălăn Listra d-Ikanyun d-Intyuš. ");
INSERT INTO taq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Samătarăn inəṭṭulab dăɣ-idăggan-win-dăɣ d-ad-əṭṭəfăn immun s-Măssinăɣ ed, itbat a-s ujəš n-Təmmənəya n-Măssinăɣ, ăddeew daɣ d-ălɣizabăt ăjjeen. ");
INSERT INTO taq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ălkănisăt əmmărăn-dăɣ, a dăɣ-s səbdədăn inušămăn, ədələn-asăn Măssinăɣ, uẓamăn təzzar, săɣləfăn-tăn i-tărna n-Emăli-i s-omănăn i-ad-dăɣ-săn ăj ălbăraka. ");
INSERT INTO taq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ǝjlăyăn ḍarăt-a-wen teje ta n-Bəssidi, okăyăn s-ta n-Bănfəli, ");
INSERT INTO taq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ăxṭăbăn dăɣ-aɣrəm wa n-Birga təzzar ătrarăn s-Antalya. ");
INSERT INTO taq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ǝjjăšăn turăft n-aman dihen, jăn tamdujt ta n-Intyuš-i-dăɣ dd-ămešălăn ḍarăt a-s ăssiiɣlăfăn imumənăn i-ănnuɣmăt n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Osăn-in ɣas, ăsdăwăn-dd ălkănisăt, ad-siɣulăn i-imumənăn isălan n-a-wa s-tăn-ikfa Măssinăɣ turhajăt n-iji-net, d-əmmək wa s-ora Măssinăɣ emm n-ehăn n-immun i-inəẓẓulam. ");
INSERT INTO taq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ăhojăn ḍarăt-a-wen əzzaɣăn ɣur-inəṭṭulab wi n-dihen. ");
INSERT INTO taq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ăzzăman-en-dăɣ a dd-fălăn meddən iyyăḍ teje ta n-Ălyăhudəyăt, ad-saɣren imumənăn n-a-s ere wărăn ămelăy s-ălɣadăt wa dd-oyya ănnăbi Mosa, wăr-e iɣləs. ");
INSERT INTO taq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ija dăr-săn Buləs d-Bărnăbbas tamɣənnant tăṣṣoohet təzzar, ănmărḍăn imumənăn făl ad-sukən Buləs d-Bărnăbbas d-hărăt dăɣ-meddən n-ălkănisăt-năsăn Yărussălam i-ad-əjən isălan n-tamɣənnant-ta-dăɣ i-inəmmušal d-inušămăn wi t-əllănen dihen i-ad-hasăn-tăt-arən. ");
INSERT INTO taq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ăssofăḍăn-tăn-in imumənăn n-ălkănisăt ta n-Intyuš-i tăn-tăšmašălăt s-tizarăt, răsăn teje ta n-Finisya d-ta n-Sămari, siɣulăn isălan n-əmmək wa s-ătubăn inəẓẓulam i-Măssinăɣ. Ămoos umăr wa tăn-dd-jăn a iknan asəddəwi n-ayətma-săn dăɣ-ăddin dăɣ-idăggan-win-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ǝwwăḍăn-in Yărussălam, tăsbărrăk-tăn ălkănisăt d-inəmmušal d-inušămăn, jăn dăɣ-săn isălan n-a-wa s-tăn-ikfa Măssinăɣ turhajăt n-iji-net s-ifassăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ǝggădăn-dd meddən iyyăḍ hanen taggayt ta n-kăl-faris təglăt făll-tidət n-iman-net, ənnăn əflasăn a-s ămoos amili d-alkum i-alămăr wa n-ănnăbi Mosa a ifraḍăn făll-inəẓẓulam i-ad-əjjəšăn Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ǝžžəmmăɣăn inəmmušal d-inušămăn i-ad-əjrəwăn ăddăbara dăɣ-isălan-wi-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Təja dăɣ-săn tamăzaɣt tăṣṣoohet. Dăɣ-a-wen-dăɣ, ad-dd-ibdăd Bəṭrus jere-săn, inna: «Ayətma-ɣ, təssanăm a-s ăru d-hi-ăsnăfranăn Măssinăɣ jere-wăn i-ad-săslăɣ inəẓẓulam isălan n-Ălənžil i-ad-amənăn s-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Măssinăɣ i issănăn a-wa ihăn ulh n-ăgg-adəm a hasăn-imməjrădăn, ikfʼ-en Unfas Šăddijăn s-əmmək wa s-hanăɣ-t-ikfa năkkăneḍ-i n-kăl-Ălyăhud, ");
INSERT INTO taq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","wăr t-illa a-s hanăɣ-aẓimăẓlăy dăr-săn ed, immun s-Măssinăɣ a iššəšdăjăn ulhawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Šămad tidət a-wen, adiš mafăl tirəməm Măssinăɣ, tajjăm făll-errawăn n-inəṭṭulab ăẓuk s-năkkăneḍ wăla abbatăn-nănăɣ, indăr-anăɣ ălănji-net? ");
INSERT INTO taq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wădden ănnuɣmăt n-Emăli Ɣisa-i s-nomăn, iɣlăs-anăɣ, ənta daɣ a-s omănăn əntăneḍ-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tăssosăm tamətte iket-net, ăsjădăn ăddinăt ḍarăt-a-wen i-Bărnăbbas d-Buləs siɣulăn isălan n-ijităn n-Măssinăɣ wi jăn d-hărătăn wi ăssuksăḍnen jăn jer-inəẓẓulam. ");
INSERT INTO taq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ǝssəmdăn măjrăd ɣas, iḍkăl-t Yaqub, inna: «Ayətma-ɣ, săjdăt-ahi. ");
INSERT INTO taq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ija dăɣ-năɣ Simyon Bəṭrus isălan n-əmmək wa s-dd-ăšbašăj Măssinăɣ s-inəẓẓulam i-ad-dăɣ-săn isənnəfrən tamətte təlkamăt i-isəm-net ed, ");
INSERT INTO taq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ămoos a-wen a ănimănnakăn d-a-wa ənnăn ănnăbităn ed, iktab a-s, innă Măssinăɣ: ");
INSERT INTO taq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Ḍarăt-a-wen, ilkam a dd-ăqqəlăɣ i-ad-aləsăɣ edey n-ehăn n-Dawəd-wa oḍăn, səbdədăɣ-t-dd dăɣ-timšar-net, ădyăɣ-t.› ");
INSERT INTO taq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","A-wen, dăɣ-təssəba n-ad-immăɣ a-wa t-illăn dăɣ-ăddinăt i-Emăli, əmmăɣnăt-as daɣ tiwsaten-ti făll-itawăɣra isəm-in. A-wen, Emăli a tăn-innăn, erhet-net daɣ den-dăɣ ənta-i ilăn tărna n-iji n-hărătăn-win-dăɣ daɣ den-dăɣ, ");
INSERT INTO taq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","wăr t-illa daɣ a has-idrajăn dăɣ-a-wen-dăɣ, ed issăn-t ɣur-alăṣăl-net. ");
INSERT INTO taq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Təssəba n-a-wen-dăɣ a făl hawăn-janneɣ a-s, wăr tăsmăɣatărăm inəẓẓulam-wi maden-utab s-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","măšan, nəktəbet-asăn tăkarḍe n-tamătert i-ad-əbḍəwăn d-hărăt iket-net ăddooben asəmmăḍəs-năsăn, əbḍəwnet d-ălɣibadăt n-ăṣṣănămăn d-əzzəna d-tetăte n-măɣsoy d-tesăse n-ašni. ");
INSERT INTO taq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ădduuttăt a-s ila ănnăbi Mosa dăɣ-əzzurəyatăn-ti-dăɣ hakd-dăɣ ti-okăynen ăddinăt dăɣ-iɣărman iket-năsăn ɣarrănen əlkəttabăn-net hak əssəbət-i n-tăsonfat dăɣ-ihănan n-ăddin.» ");
INSERT INTO taq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ănmănnakăn inəmmušal d-inušămăn d-ălkănisăt ḍarăt-a-wen făll-ad-sənnəfrənăn hărăt dăɣ-meddən-năsăn maden-idaw d-Buləs d-Bărnăbbas s-Intyuš, ăsdăwăn dăr-săn daɣ Yahudəs wa itawăɣren s-isəm Bărsabas d-Sillas, əssin meddən a-wen ătiwăsămɣărnen jer-ayətma-săn dăɣ-ăddin. ");
INSERT INTO taq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ǝkfăn-tăn tăkarḍe əktabăn s-ifassăn-năsăn. Ǝnnăn dăɣ-s: A-wa năkkăneḍ inəmmušal d-inušămăn wi n-ayətma-wăn dăɣ-ăddin. Năhuul-in ayətma-năɣ wi s-kăla ămoosăn inəẓẓulam hănen Intyuš d-Surya d-Silisi. ");
INSERT INTO taq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ijmaḍ-t ăššăk a-s nəššəwwăš a-s nəslă ass wa kăwăn-in-jăn meddən hanăɣ-in-falnen wăr hin-năšmašăl, nəssan a-s, ənxăsăn iman-năwăn. ");
INSERT INTO taq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","A-wen-dăɣ a făl nohăr iyyăn n-ăddăbara iket dăɣ-nănăɣ i-ad-kăwăn-in-nəsuk meddən năsidaw d-Bărnăbbas d-Buləs-i nəkna tărha ed, ");
INSERT INTO taq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ămoosăn meddən jănen iman-năsăn dăɣ-miši făl təssəba n-isəm n-Emăli-nănăɣ ƔisaĂlmasex. ");
INSERT INTO taq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Năšimašăl-in daɣ săr-wăn Yăhudəs d-Sillas i-ad-hawăn-aləsăn asuɣəl n-isălan-wi-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Issəlmăd-anăɣ Unfas Šăddijăn, nărḍa daɣ s-ad-wăr nətəjj fălla-wăn ăẓuk wălʼ iyyăn săl wa ămoosăn fărəḍ, ");
INSERT INTO taq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","a-wen a t-ămoosăn, asăxrəm n-tetăte n-takute jat i-ăṣṣănămăn, asăxrəm n-tesăse n-ašni d-tetăte n-măɣsoy d-tăbəḍḍawt d-iji n-əzzəna. Afăl təṭṭăfăm iman-năwăn făll-hărătăn-win-dăɣ, ad-təjəm a ăhuusken ed, wăr mad-iɣšəd isəm-năwăn dat-ăddinăt. Năhuul-kăwăn-in, wăssălam! ");
INSERT INTO taq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ărkăbăn ḍarăt-a-wen, əqqălăn Intyuš, ăwwayăn tăkarḍe-tənnin-dăɣ. Ǝwwăḍăn-in ɣas, ăsdăwăn-dd ălkănisăt, əkfăn ălžămaɣăt tăkarḍe, ");
INSERT INTO taq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tătwăɣra, ămoosăn isălan-wi tăt-hănen əssəbab n-tedăwit măqqoorăt. ");
INSERT INTO taq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ăsmătăr-tăn daɣ Yăhudəs d-Sillas ed ănnăbităn a ămoosăn s-iməjridăn ăjjootnen, sasmaḍăn ulhawăn n-imumənăn, siṣuhun-tăn dăɣ-immun-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ăssakăyăn hărăt n-išilan dihen ɣas, fălăn-tăn imumənăn-wi dd-fălnen Yărussălam dăɣ-ălxer, əqqălăn ălkănisăt ta tăn-dd-tăšmašălăt  ");
INSERT INTO taq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","măšan, ăqqima Sillas ḍara-săn. ");
INSERT INTO taq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Izzăɣ Buləs d-Bărnăbbas dăɣ-Intyuš-en-dăɣ, saɣrʼ-en əntăneḍ d-iyyăḍ, xaṭṭăbăn s-ălxalăn ăjjootnen isălan n-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hărăt n-išilan ḍarăt-a-wen, innă Buləs i-Bărnăbbas: «Năqqəlet ayətma-năɣ dăɣ-ăddin wi hănen iɣărman wi dăɣ-nəja isălan n-măjrăd n-Emăli, nəssən əndek əmmək-năsăn.» ");
INSERT INTO taq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ittăr Bărnăbbas a-dăr-săn aləs Exya Marqəs tădiwt ");
INSERT INTO taq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","măšan, wăr has-irḍa Buləs s-a-wen. Innʼ-as, wăr-ănhăjja a-dăr-săn idaw ed, ənta iman-net a hin-iɣtăsăn iman-net dăr-săn a-s ḍara-săn ibḍa dăɣ-Bănfəli. ");
INSERT INTO taq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tăkkus talɣa jere-săn har dd-orăw a-wen-dăɣ tăbəḍḍawt-năsăn s-iyyăt. Ăddew Bărnăbbas d-Marqəs ḍarăt-a-wen, əjjăšăn turăft n-aman, əkkăn Qəbrus. ");
INSERT INTO taq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Iɣră-dd Buləs Sillas s-iman-net, iglă ḍarăt a-s t-ăsseɣlăfăn ayətma-s dăɣ-ăddin ănnuɣmăt n-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Immăr Buləs ăkall wa n-Surya d-Silisi, isiṣuhut immun n-ălkănisăten dăɣ-idăggan-win-dăɣ iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Immăr Buləs aɣrəm wa n-Darba d-wa n-Listra, illʼ-e dihen-dăɣ a-s ănăṭṭalib iyyăn da-dăɣ s-isəm-net Timoti, ma-s tamumənt lan kăl-Ălyăhud măšan, ti-s, i n-kăl-Ălyunan, ");
INSERT INTO taq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","jannen fălla-s imumənăn wi n-Listra hakd-dăɣ wi n-Ikanyun a ăhuusken. ");
INSERT INTO taq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Iɣrʼ-e-hi-dd Buləs s-iman-net i-ad-dăr-s idaw măšan, ăsmalăy-t təzzar i-ad-wăr jărrəwăn kăl-Ălyăhud wi t-əllănen dihen a fălla-s ənnăn ed, əssanăn iket-năsăn a-s abba-net, i n-kăl-Ălyunan. ");
INSERT INTO taq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aɣrəm əmmărăn-dăɣ ḍarăt-a-wen, ad-dăɣ-s səmmətărăn imumənăn dăɣ-alkum d-uḍəf n-ăddăbaratăn-wi hasăn-ăɣtăsăn inəmmušal d-inušămăn dăɣ-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Samătarăn ălkănisăten i-ad-iṣṣuhət immun n-inəṭṭulab, isajat-dd Măssinăɣ hak ašăl ăddinăt ăynaynen dăɣ-ălkănisăt əkfanen iman-năsăn i-Emăli. ");
INSERT INTO taq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ijlăy Buləs d-imidiwăn-net Frižya d-teje ta n-Gălasya măšan, wăr hasăn-irḍa Unfas Šăddijăn jan isălan dăɣ-ăkall wa n-Azya, ");
INSERT INTO taq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","əwwăḍăn-dd Masi, əttărăn ad-əkkən Bətni măšan, igdal-asăn daɣ Unfas n-Ɣisa s-a-wen, ");
INSERT INTO taq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","əjlăyăn Masi, ăzzubben dăɣ-Tărwas. ");
INSERT INTO taq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ǝllan-t dihen-dăɣ a-s ăhhurjăt Buləs u-Masidunya iyyăn t-iɣarrăn, ibdad, iddal Măssinăɣ, ijannʼ-as: «Ya Măssinăɣ! Šəmmišəl-dd săr-năɣ ere hanăɣ-ohăɣăn tinahăɣen, năɣləs.» ");
INSERT INTO taq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nəfhăm s-a-wen-dăɣ dd-ănfalălăn i-Buləs, a-s irha fălla-năɣ Măssinăɣ ad-nəsəllənžət teje-ten-dăɣ, ad-nətammăɣ ya i-əmmək s-nəkka Masidunya. Ɣur-dihen-dăɣ ad-tăn-dd-əjjăšăɣ, ohărăɣ d-Buləs asikəl năkk-i iktăbăn isălan-wi-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nəjjăš turăft n-aman dăɣ-Tărwas, nəja s-iyyăt tamdujt ta n-Somătras, ăffăw nəkka Năyyabolis; ");
INSERT INTO taq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","nəfăl dihen, nəkka aɣrəm wa n-Fəlibb-i s-ənta a itammăr ere dd-ijjăšăn Masidunya s-tizarăt, ămoos daɣ aɣrəm făll-ixkam Roma, năssakăy hărăt n-išilan dihen. ");
INSERT INTO taq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ašăl wa n-əssəbət-i n-tăsonfat, nəzjăr aɣrəm, nəkka asălim n-ejărew ed, norda s-ad-dăɣ-s nəjrəw edăgg iṣtarăn dăɣ-nədăl Măssinăɣ, nogăẓ-in dihen tiḍeḍen ăžžiimmăɣnen, năqqima ad-hasnăt-nətajj isălan. ");
INSERT INTO taq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tăsjăd-anăɣ tiyyăt dăɣ-snăt n-tămaksaḍt n-Măssinăɣ s-isəm-net Lidya, tu-mamălat n-aɣrəm wa n-Təyatir hin-žănšet măṣăr wa n-nefran n-ini šăggăɣăn. Oră Emăli ulh-net, tomăn s-a-wa has-ijănna Buləs, ");
INSERT INTO taq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","tătwăsălmăɣ dăɣ-aman ənta d-kăl-ehăn-net. Tənnă i-Buləs d-imidiwăn-net ḍarăt-a-wen: «Kunta təflasăm a-s tamumənt n-Emăli a ămoosăɣ, məjurətăt-ahi». Laqqăd-anăɣ har hanăɣ-tăšhăššăl s-a-wen. ");
INSERT INTO taq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nolăs daɣ nəkka edăgg n-tittar a-s hanăɣ-dd-təlkăḍ tănaxdimt tiyyăt ihʼ alšin iknan tăllăbăst, tămoos i-məssaw-s əssəbab n-ărrəzăɣ ed, itiləɣut alšin wa tăt-ihăn a-wa ilkămăn, təẓẓalăn-as ăddinăt. ");
INSERT INTO taq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tənhăy-anăɣ ɣas, təltăɣ-anăɣ, e-s nəkka-dăɣ tăseɣărăt ḍara-năɣ, janna: «Ya ăddinăt, əlmədăt a-s meddən-wi-dăɣ hannăyăm, eklan n-Măssinăɣ wa iknăn aḍkul, isălan n-tabarăt ta n-əlɣəllas a-s dd-osăn i-ad-tăn-əjən.» ");
INSERT INTO taq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Təjʼ-anăɣ alkum-wen-dăɣ har ja išilan, təglă făw har tăsɣăf Buləs; ămlăllăy-dd săr-s, ăsmăhăḍ făll-alšin wa tăt-ihăn, innʼ-as: «Omarăɣ-kăy s-isəm n-Ɣisa Ălmasex, əsjăr-tăt!» Izjăr-tăt alšin ăssaɣăt-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ǝnhăyăn məssaw-s a-s taklit-năsăn ăbas-hasăn-dd-saɣsal ehăre ɣas, ărmăsăn Buləs d-Sillas, əlwăyăn-tăn s-eɣărɣăr wa n-tamɣənnant s-itawănna Larofaž dăɣ-itamăr ăššăreɣa, əssəbdădăn-tăn dat-ălqaḷḷităn, ");
INSERT INTO taq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","əssəknăn-tăn ḍarăt-a-wen daɣ i-kăl-ăššăreɣa wi n-Roma, ənnăn-asăn: «Meddən-i n-kăl-Ălyăhud hannăyăm, wăr dd-ăwweyăn a săl ăḍḍărora s-aɣrəm-nănăɣ, ");
INSERT INTO taq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","sasăɣren ăddinăt ălɣadatăn s-năkkăneḍ-i n-kăl-Roma wăr hanăɣ-t-illa uḍəf-năsăn wăla alkum-hasăn.» ");
INSERT INTO taq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Təsla tamətte i-a-wen ɣas, təzzăn săr-săn. Ǝnnăn kăl-ăššăreɣa, ətwəkkəsnet isəlsa dăɣ-Buləs d-Sillas, ăttăwătnet. ");
INSERT INTO taq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ǝknăn-tăn asəsnan təzzar, jărăn-tăn-in dăɣ-takărmut dăɣ-a-s ənnan i-əssărdusa ad-hasăn-əknən iji n-ənniyăt. ");
INSERT INTO taq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ătwănnă a-wen i-emănnăhăḍ n-takărmut ɣas, ija dăɣ-săn tišəm, ijʼ-en dăɣ-səllul. ");
INSERT INTO taq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ebre n-ammas n-ehăḍ, irmăs Buləs d-Sillas ăsahăɣ n-təmmal i-Măssinăɣ, ăsijădăn-asăn kăl-takărmut wi iyyăḍnen. ");
INSERT INTO taq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A ənḍărrăn-dăɣ ăškăḍkăḍ-dd ăkall daw-săn s-ăṣṣahăt hăr ăsnăhăynăhăy issas n-takărmut, ămerăn isăɣfal n-takărmut iket-dăɣ-năsăn ăssaɣăt-wen-dăɣ, ămerănăt daɣ tišəm-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Inkăr-dd emănnăhăḍ n-takărmut dăɣ-eḍəs, inhăy tishar n-takărmut ămerănăt ɣas, ilbăy-dd takoba-net i-ad-săr-s idəj iman-net ed, ăɣel kăl-takărmut wi iɣlăf, əjmăḍăn. ");
INSERT INTO taq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Măšan, ăsɣărăt-as Buləs s-afălla, innʼ-as: «Ahaa! Wăr jed a-di, nəllʼ-e diha iket-nănăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Irmăs-dd emănnăhăḍ n-takărmut emămmăl n-efew s-inhăy data-s, ošăl-dd, irkăɣ dat-Buləs d-Sillas ăšikăḍkăḍ, ");
INSERT INTO taq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ikkăs-tăn-dd dăɣ-ammas n-takărmut təzzar, innʼ-asăn: «Meddən, ma s-leɣ s-ad-t-ăjjăɣ i-ad-ăɣləsăɣ?» ");
INSERT INTO taq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ǝnnăn-as: «Amən kăyy d-ejădăš-năk s-Emăli Ɣisa, ad-tăɣləsăm.» ");
INSERT INTO taq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ăxṭăbăn-as măjrăd n-Emăli ənta d-kăl-ehăn-net ălwăqq-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ilwăy-tăn dăɣ-tăkkăwălt n-ehăḍ-en-dăɣ s-ehăn-net, issəfăr ibuyəsăn-năsăn, ătwăsălmaɣ dăɣ-aman ḍarăt-a-wen ənta hakd kăl-ehăn-net iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ăsmăjarăt-tăn dăɣ-a-s ikna tedăwit ənta d-kăl-ehăn-net n-a-wa s-omănăn iket-năsăn s-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ăffăw ɣas, ăšmašălăn-dd kăl-ăššăreɣa meddən s-emănnăhăḍ n-takărmut i-ad-hin-isəwwəy Buləs d-Sillas. ");
INSERT INTO taq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ija dăɣ-săn emănnăhăḍ isălan n-a-wa ənnăn kăl-ăššăreɣa măšan, ");
INSERT INTO taq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","innʼ-as Buləs: «Făw, šămad jăn dăɣ-năɣ tiwit dat-tamətte, a-s ija a-wen, wăr nătwăšrăɣ, năkkăneḍ-i ăḍḍinnen făll-Roma, jărăn-anăɣ-in dăɣ-takărmut s-əmmək-wa-dăɣ, ămăra ărhan ad-hin-nətwəyy dăɣ-ufăr, wăr nărḍa s-a-wen, asənet-dd əntăneḍ iman-năsăn, səwwəyyən-anăɣ-in.» ");
INSERT INTO taq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ǝqqălăn meddən-wi dd-ămešălnen, ăssoɣălăn isălan n-a-wa inna Buləs i-imănnăhăḍăn. Ǝslăn i-isălan n-a-s Buləs d-Sillas ăḍḍinăn făll-Roma ɣas, ărmăɣăn. ");
INSERT INTO taq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Osăn-tăn-dd ḍarăt-a-wen əntăneḍ iman-năsăn, əttărăn tenăšše dăɣ-Buləs d-Sillas, əkkəsăn-tăn-dd dăɣ-takărmut dăɣ-a-s dăɣ-săn əttarăn ad-əfələn aɣrəm-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ǝzjărăn-dd takărmut ɣas, əkkăn ehăn wa n-Lidya, ad-samătarăn dihen ayətma-săn dăɣ-ăddin d-alkum i-Măssinăɣ təzzar, əglăn. ");
INSERT INTO taq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ǝjlăyăn Ănfibbolis d-Abuləbbis, osăn-dd Tăslonika ɣas, ijjăš Buləs ehăn n-ăddin wa n-kăl-Ălyăhud ");
INSERT INTO taq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ed a-wen-dăɣ a-s izzay ad-t-ăj. Ija dihen kăraḍ əssəbətăn itidwənnit d-kăl-Ălyăhud dăɣ-isălan n-a-wa ənnăn əlkəttabăn n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Itafăssar-asăn-tăn, isatbat-asăn a-s iktab dăɣ-săn a-s Ălmasex, ilzam-t ad-inhəy tersəmmawen, ămmăt təzzar, inkăr-dd jer-inəmmuttan. Ijannʼ-asăn daɣ a-s Ɣisa-wa hasăn-ixaṭṭăb a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ǝkkăsăn iyyăḍ dăɣ-săn ăššăk dăɣ-a-wa hasăn-ijanna, əlkămăn-asăn daɣ kăl-Ălyunan ăjjootnen ăddinnen d-tiḍeḍen ăjjootnen lanen isəm dăɣ-aɣrəm. ");
INSERT INTO taq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Măšan, osămăn fălla-săn kăl-Ălyăhud, əglăn, ăsdăwăn-dd hărăt dăɣ-erk ăddinăt, ăsmădărwăyăn aɣrəm təzzar, əkkăn ehăn wa n-Yazun, əmmaɣăn i-Buləs d-Sillas i-ad-tăn-səbdədăn dat-tamətte, təšrăɣ-tăn. ");
INSERT INTO taq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wăr tăn-in-ogeẓăn dihen ɣas, oḍăn făll-Yazun iman-net, ăšrăwrăwăn-t ənta d-imumənăn iyyăḍ, əssəbdădăn-tăn dat-imănnăhăḍăn n-aɣrəm, ad-tăn-sawarăn kăl-Ălyăhud uḍlem, jannen: «Ăddinăt-wi-dăɣ, ăkall iket-net a ăsnăxănbălăn siha d-siha təzzar, əwwăḍăn-anăɣ-dd ămăra, ");
INSERT INTO taq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","əntăneḍ-da-dăɣ ăsmăjarăt Yazun, ad-tajjăn hărătăn əšlaynen i-a-wa innă ămănokal wa măqqărăn ed, jannen illʼ-e ămănokal săl Qăyṣăr s-isəm-net Ɣisa.» ");
INSERT INTO taq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wăr-əjreẓăn isălan-wi-dăɣ i-tamətte wăla i-imănnăhăḍăn n-aɣrəm, ");
INSERT INTO taq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ăɣtăsăn i-Yazun d-imumənăn wi iyyăḍnen ăddăyyăt s-lan s-ad-t-əẓələn i-əlxəkum təzzar, ətwəyyən-in. ");
INSERT INTO taq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ǝnhăyăn imumənăn tukəse n-talɣa-ta-dăɣ ɣas, əssəjmăḍăn Buləs d-Sillas ehăḍ-wen-dăɣ, ăssokăn-tăn aɣrəm wa n-Biri. Ǝwwăḍăn-in dihen ɣas, əkkăn ehăn n-ăddin wa n-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ǝssəknăn-tăn kăl-aɣrəm wa n-Biri tărha tojărăt ta n-kăl-Tăslonika, ed əntăneḍ, əslăn i-măjrăd n-Măssinăɣ ɣas, omănăn săr-s šik, ad-ɣarrăn hak ašăl əlkəttabăn, tassănăn a-wa hasăn-itawănnen tidət meɣ. ");
INSERT INTO taq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Omănăn dăɣ-săn ăddinăt ăjjootnen hanăt tiḍeḍen ăjjootnen n-Tălyunaniten lanen isəm d-meddən daɣ ăjjootnen. ");
INSERT INTO taq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ǝslăn kăl-Ălyăhud wi n-Tăslonika a-s itajj Buləs isălan n-măjrăd n-Măssinăɣ dăɣ-Biri ɣas, əlkămăn-as-dd, ad-tattărăn daɣ asənkar n-tamətte fălla-s ənta d-imidiwăn-net; ");
INSERT INTO taq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","əssəglăn imumənăn Buləs ḍarăt-a-wen dăɣ-armuḍ, əssəjmăḍăn-t aɣrəm s-ašrut wa n-ejărew măšan, ăqqimă-dd ɣur-săn Sillas d-Timoti. ");
INSERT INTO taq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ăddewăn meddən wi hin-ăssofăḍnen Buləs har hin-əwwăḍăn aɣrəm wa n-Atinya təzzar, ənnăḍăn-dd, ăssawăy-tăn Buləs ămašal i-ad-has-dd-ilkəm Sillas d-Timoti dăɣ-armuḍ. ");
INSERT INTO taq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Isimăqqul-asăn Buləs dăɣ-Atinya dihen-dăɣ a-s inxăs a-wa ihannăy iman-net făl əjut-i-dăɣ jăn ăṣṣănămăn dăɣ-aɣrəm-en-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iglă, ădwănnăt d-kăl-Ălyăhud dăɣ-ehăn n-ăddin-năsăn, ad-itidwənnit daɣ hak ašăl d-inaɣbadăn n-Măssinăɣ wi hănen eɣărɣăr wa n-tamɣənnant s-itawănna Larofaž. ");
INSERT INTO taq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ădwănnen dăr-s dihen kăl-fălṣăfa wi s-itawănna kăl-Ibbikur d-iyyăḍ s-itawănna kăl-Stoyis. Jannen dăɣ-săn iyyăḍ: «Ak i n-iləs šəjren-wa, ma ijanna?» Jannen wi iyyăḍnen: «A-wa məssaw-năɣ iyyăḍ făll-wăr nəssen əzzaɣnen išənnawăn a-s hanăɣ-ixaṭṭăb isălan-năsăn.» Jannen a-wen făl-a-s ijʼ-asăn Buləs isălan n-ălxer n-Ɣisa d-isălan n-tanăkra jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ărmăsăn Buləs ḍarăt-a-wen, əlwăyăn-t s-Larofaž, ənnăn-as. «Săsəl-anăɣ ya ămăra isălan n-teɣăre ta tăynayăt dăr-hanăɣ-dd-tosed ");
INSERT INTO taq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","făl-a-s kăyy, tikunen ti s-hanăɣ-săsled, wăr kăla hasnăt-nəsla dăɣ-ăddunya, făssăr-anăɣ ălmăɣna-năsnăt.» ");
INSERT INTO taq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ăzzăman-en, kăl-Atinya hakd-dăɣ imăjarăn-năsăn, wăr t-illa ere s-wădden issan a-s wăr-oren timəẓẓujen ar dăɣ-umaɣ n-isălan d-iji-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ibdăd-dd Buləs dăɣ-ămmas n-Larofaž, eɣărɣăr wa n-tamɣənnant, innă: «Ya kăl-Atinya, dăɣ-a-wa hannăyăɣ, ijmaḍ-t ăššăk a-s təjlayăm hullan dăɣ-ăddin wa hăm, ");
INSERT INTO taq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","əssăɣlăyăɣ-dd dăɣ-aɣrəm-năwăn, əkneɣ azəjjəzz n-idăggan n-ălɣibadăt-năwăn, əgleɣ făw har oḍeɣ făll-edăgg n-tikutawen-năwăn făll-iktăb: ‹I-Ămakraš wa wăr nəzzey›. Ǝlmədăt ašăl-i, a-s Wa ɣabbădăm wăr t-təzzeyăm a-wa hawăn-ija ălžăhalăt, ənta a-s hawăn-tajjăɣ isălan-net. ");
INSERT INTO taq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Măssinăɣ-i dd-ixlăkăn ăddunya d-a-wa tăt-ihăn iket-net, ənta-i n-Emăli n-išənnawăn d-ăkall, wăr-itəzzăɣ ehăn dayăn ifassăn-n-ăgg-adəm, ");
INSERT INTO taq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","wăr-ămɣatăr s-tadhəlt n-ifassăn n-ăgg-adəm wăla s-hărăt wălʼ iyyăn ed, ənta a ihakkăn e d t-illăm ăgg-adəm tămudre, ənta daɣ a ihakkăn unfas d-tămudre i-hărăt iket-net. ");
INSERT INTO taq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ǝnta a dd-ixlăkăn ăhaləs-wa dd-ăshăyăwăn e d t-illăm ăgg-adəm iwarăn ărori n-ăkall, ənta a iɣtăsăn tăkost n-ikallăn wi tazzăɣăn, ənta daɣ a hanăɣ-dd ijăn ăzzămanăn. ");
INSERT INTO taq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","A-wen, ijʼ-e Măssinăɣ i-ad-has-əmmăɣăn ăddinăt kud-dăɣ s-ekălelaf i-ad-t-əjrəwăn ed, ijmaḍ-t ăššăk a-s Măssinăɣ, wăr hanăɣ-iha i ujəj. ");
INSERT INTO taq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ǝnta a hanăɣ-ikfăn tămudre d-emăremar d-tumast. Măjrăd-wen-dăɣ, tăsdăttăt tăsawit-năwăn ta tənnăt: ‹Nolăh dăr-s ed nămoos aratăn-net.› ");
INSERT INTO taq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ɣas, šămad nămoos aratăn-net, adiš təlăš fălla-năɣ torda n-a-s Măssinăɣ ănifăqqa d-a ămoosăn orăɣ meɣ aẓrəf meɣ tăhunt meɣ ăṭṭăṣwer dd-izjarăn tăhore wăla tayətte n-ăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ǝlmədăt a-s Măssinăɣ, iwətyan-wi ăssakăyăn ăddinăt dăɣ-ălžăhalăt, wăr tăn-ixseb făll-errawăn-năsăn, a-wen-dăɣ a făl ămăra, omar i-e d t-illăm ăgg-adəm dăɣ-e d-t-illăm edăgg s-ad-utab ");
INSERT INTO taq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","făl-a-s ăssiibdăd ašăl dăɣ-mad-išrăɣ ăddunya-ta-dăɣ s-ăhaləs-wa ăsnăfrăn tat-madăn-išrăɣ s-iqqud. A-wen, issətbăt-t Măssinăɣ i-tamətte iket-net s-əmmək wa s-dd-issənkăr Ɣisa jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Təslă tamətte i-isălan n-tanăkra jer-inəmmuttan ɣas, jăn-t iyyăḍ tekăškăšt, ənnăn-as iyyăḍ: «Ǝgləw, tăqqəlăd-anăɣ-dd ašăl iyyăn săl wa i-ad-naləs asjəd i-isălan-wi-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ifăl Buləs jere-săn ălwăqq-wen-dăɣ măšan, əlkămăn-as iyyăḍ omănnen s-a-wa innă. ");
INSERT INTO taq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ăddinăt-en, ihʼ-en Denis wa ijăn ənniyăt i-Larofaž d-tamăḍt tiyyăt s-isəm-net Dămaris d-iyyăḍ daɣ săl-win-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ifăl Buləs Atinya ḍarăt-a-wen, ikkă aɣrəm wa n-Kurənta. ");
INSERT INTO taq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ămmoqqăs dihen d-ăgg-Ălyăhud n-ăkall wa n-Fon s-isəm-net Akilas. Iket-dd ifăl Iṭali ənta d-hănne-s s-isəm-net Briska făl-a-s ăzziizjăr-dd ămănokal n-ăkall Kəlod alămăr dăɣ-iktab a-s, əzjărnet kăl-Ălyăhud iket-năsăn Roma. ");
INSERT INTO taq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ămedăw Buləs d-Akilas ed oharăn ălxidmăt wa n-iji n-ihəktan. ");
INSERT INTO taq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Hak əssəbət-i n-tăsonfat, isatbat Buləs isălan i-ăddinăt dăɣ-ehăn n-ăddin i-kăl-Ălyăhud hakd-dăɣ kăl-Ălyunan. ");
INSERT INTO taq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Iwwăḍ-dd Sillas d-Timoti Buləs, falăn-dd Masidunya ɣas, oyyă iji n-ihəktan, ikfă iman-net axăṭab n-măjrăd n-Măssinăɣ, itajăyha i-kăl-Ălyăhud a-s Ɣisa a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ăšmăšăkken a-wa hasăn-ijanna, ad-sikuforăn. Ibbəkbăk Buləs isəlsa-net, innʼ-asăn: «Ǝḍmanăn dăɣ-wăn iman-năwăn, ăbas dăɣ-i əḍmanăn, ămăra, inəẓẓulam a-s e-ənnăḍăɣ, ăjăɣ-asăn isălan.» ");
INSERT INTO taq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ifăl Buləs dihen, ikkʼ ehăn n-ăhaləs s-isəm-net Titus Istus, ănaɣbad n-Măssinăɣ s-ănimăltaɣ ehăn-net d-wa n-ăddin. ");
INSERT INTO taq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Dăɣ-a-wen-dăɣ, ad-omăn Krisbus wa n-ălfăqqi n-ehăn n-ăddin s-Emăli ənta hakd d-ejădăš-net d-kăl-Kurənta ăjjootnen ăsijădnen i-Buləs; omănăn, ad-titwəsəlmiɣăn dăɣ-aman. ");
INSERT INTO taq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ehăḍ iyyăn, ănfalăl-dd Emăli i-Buləs, innʼ-as: «Buləs, wăr kăy-isărmaɣet hărăt, măjrăd, wăr tăssosămăd, ");
INSERT INTO taq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","əlleɣ-t edes-hak, ədhalăɣ-kăy, wăr t-illa ere hak madăn-iɣšəd hărăt făl-a-s leɣ tamətte tăjjeet s-ărheeɣ ad-tăt-ăɣləsăɣ dăɣ-aɣrəm-wa-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Izzăɣ Buləs dihen har ija awătay d-săḍis orăn, isaɣra ăddinăt măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ăzzăman wa d-ămoos Galyon gəfar n-Akaya, ănmănnakăn kăl-Ălyăhud făll-Buləs, ăɣrăn-t s-ălqaḷḷităn i-ad-t-əšrăɣăn. ");
INSERT INTO taq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ăswărăn-t uḍlem dat-gəfăr, ənnăn-as: «Ăhaləs-i, isaɣra ăddinăt ălɣibadăt n-Măssinăɣ s-ălɣadăt ănimăšrayăn i-a-wa innă alămăr.» ");
INSERT INTO taq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ittăr Buləs ad-arr emm-net i-ad-ămmăjrăd ɣas, innă Galyon i-kăl-Ălyăhud: «Ǝnnăr anməšri i-ăššăreɣa meɣ erk ămašal a făl hi-dd-təkkăm i-ad-hawăn-arăɣ ăššăreɣa-net, ăjăɣ-awăn-t ");
INSERT INTO taq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","măšan, šămad a-wa tamădašt jat fall-tijəttewen n-teɣăre-năwăn d-ismawăn wi əktăbnen dăɣ-alămăr-năwăn, wăr-ărheɣ ad-umasăɣ ălqaḷḷi-năwăn dăɣ-isălan-win-dăɣ, əšrăɣăt-tăn kăwăneḍ iman-năwăn.» ");
INSERT INTO taq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ăsfăl-tăn Galyon ehăn wa n-ăššăreɣa ḍarăt-a-wen. ");
INSERT INTO taq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Təzzăn tamətte iket-net s-Sustin wa n-ălfăqqi n-ehăn n-ăddin, ad-t-təggatăn dat-ălqaḷḷităn măšan, wăr t-illa a hasăn-inna Galyon wa n-gəfăr. ");
INSERT INTO taq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ăhoja Buləs dăɣ-Kurənta təzzar, ăssăllăm făll-imumənăn, əkfăn-t turăft n-aman ijjăš s-ăkall wa n-Surya, igla, ăddew d-Briska d-Akilas. Ǝwwăḍăn-in aɣrəm wa n-Sănkərya ɣas, ăstăbălbăl Buləs i-ad-umas a-wen a ăssitbătăn ărkăwăl wa ijjăš. ");
INSERT INTO taq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Osăn-dd aɣrəm wa n-Ifăsus ɣas, ibḍa dăr-săn Buləs, ijjăš ehăn n-ăddin, ad-itidwənnit d-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ǝttărăn dăɣ-s ad-ɣur-săn ăhaj ");
INSERT INTO taq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","măšan, wăr hasăn-irḍa s-a-wen ed, innʼ-asăn: «Kunta otăs Măssinăɣ a-wen, ilkam ad-kăwăn-dd-ăqqəlăɣ.» Ifăl-tăn, ijjăš turăft n-aman, ");
INSERT INTO taq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ăzzubbăt dăɣ-Qăyṣăra ḍarăt-a-wen. Ijjăš aɣrəm, ăssăllăm făll-ălkănisăt təzzar, okăy s-Intyuš. ");
INSERT INTO taq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ija hărăt n-išilan dihen ɣas, ijlăy s-teje ta n-Gălasya d-ta n-Frižya. Edăgg immăr-dăɣ, ad-dăɣ-s isəmmətăr inəṭṭulab i-ad-isəṣṣuhət immun-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A-s ităjj a-wen-dăɣ, aɣrəm wa n-Ifăsus, ihʼ-e ăhaləs n-ăgg-Ălyăhud ilʼ aɣrəm wa n-Iskăndərya s-isəm-net Ăbbăloš. Ălɣalim iknan musnăt n-măjrăd a ămoos, ikna daɣ teɣăre n-a-wa ənnăn əlkəttabăn. ");
INSERT INTO taq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Han-t isălan n-tabarăt n-Emăli, ijlay hullan dăɣ-a-wa iha, itamăjrad, isaɣra s-ălmăɣna oɣadăn isălan n-Ɣisa dăɣ-a-s wăr t-təha tijya ar ta n-asəlmaɣ dăɣ-aman wa n-Exya. ");
INSERT INTO taq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Təslʼ-as Briska d-Akilas a-s ixṭăb s-tihusay dăɣ-ehăn n-ăddin wa n-Ifăsus ɣas, ăɣrăn-t-dd s-iman-năsăn, ad-t-sasaɣadăn, tafăssarăn-as tabarăt n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ăsdărhăn Ăbbăloš ḍarăt-a-wen tikawt n-ăkall wa n-Akaya, ədhălăn-t imumənăn dăɣ-derhan-net wen-dăɣ, əkfăn-t tăkarḍe i-inəṭṭulab wi n-ăkall-en i-ad-t-səbbărrəkăn afăl tăn-in-iwwăḍ. Iwwăḍ-in ɣas, ămoos tadhəlt măqqoorăt i-ăddinăt-wi omănnen s-ănnuɣmăt n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Isibəggut s-tayətte kăl-Ălyăhud dat-tamətte, isasăjrăh-tăn a-s Ɣisa a-s Ălmasex. ");
INSERT INTO taq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ăzzăman-wen-dăɣ d-iha Ăbbăloš Kurənta, ad-ijlăy Buləs ejărew s-afălla n-ăkall, ikka Ifăsus. Ijrăw dihen hărăt dăɣ-inəṭṭulab, ");
INSERT INTO taq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","innʼ-asăn: «Ak kăwăneḍ, a-s tomănăm, təjrăwăm Unfas Šăddijăn?» Ǝnnăn-as: «Wăr kăla nəslă făw a-s t-illa a-s itawănna Unfas Šăddijăn.» ");
INSERT INTO taq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Innʼ-asăn: «Adiš ma ămoos asəlmaɣ wa hawăn-ătwăjjăn?» Ǝnnan-as: «Asəlmaɣ wa n-Exya.» ");
INSERT INTO taq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Innʼ-asăn Buləs: «Exya, issəlmăɣ tamətte dăɣ-aman i-ad-umas a-wen ašămol n-tătubt-năsăn măšan, illăɣăt i-ăddinăt a-s ilkam iyyăn wăr-ămoos, a-wen a t-ămoosăn Ɣisa, ənta-en-dăɣ a-s lan ăddinăt ad-săr-s amənăn.» ");
INSERT INTO taq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ǝslăn meddən-en i-măjrăd-wen-dăɣ ɣas, əttărăn ad-ətwəsəlmăɣăn dăɣ-aman s-isəm n-Emăli Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ăswăr-tăn Buləs ḍarăt-a-wen ifassăn-net, ăzzubbăt-dd Unfas Šăddijăn fălla-săn, ad-tamăjradăn tawalen ăynaynen, tamajradăn dăɣ-isălan n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Meddən-en, măraw-essăn d-əssin. ");
INSERT INTO taq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Itakk Buləs ehăn n-ăddin wa n-kăl-Ălyăhud, ixaṭṭăb dăɣ-s tidət s-ăṣṣahăt har ăssakăy dihen kăraḍ orăn, itidwənnit d-ăddinăt, isatbat-asăn isălan wi n-Təmmənəya n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Măšan, ăsɣărăn iyyăḍ dăɣ-săn ulhawăn-năsăn, unjăyăn omănăn s-a-wa ijanna, əglăn făw har jannen a lăbasăn făll-tabarăt-ta-dăɣ s-ităjj Buləs isălan-net dat-tamətte. Ikkăs-dd Buləs iman-net dăɣ-săn, ad-isaɣra hak ašăl inəṭṭulab dăɣ-lăkkol n-ăddin ora ăhaləs s-isəm-net Tiranus. ");
INSERT INTO taq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Išlʼ-e a-wen-dăɣ dihen har əssin iwətyan, əmmək-wen-dăɣ a-s əslăn kăl-Azya iket-năsăn i-măjrăd n-Emăli jer-wi n-kăl-Ălyăhud-năsăn hakd-dăɣ wi n-kăl-Ălyunan. ");
INSERT INTO taq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Itajj Măssinăɣ s-ifassăn n-Buləs tikunen ăjjootnen, ăqqannen eɣăf, ");
INSERT INTO taq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","tišələn-dd ăddinăt săr-s, tazăwen imălsan d-ikăršăyăn t-ḍasnen, sănsen-tăn făll-imarhinăn, tazzăyăn, zajjărăn daɣ alšinăn iməlšan. ");
INSERT INTO taq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ǝggădăn-dd imăssăxărăn n-kăl-Ălyăhud takkănen jer-ikallăn, ad-ɣarrăn əntăneḍ-dăɣ făll-iməlšan isəm n-Emăli Ɣisa-wa ixaṭṭăb Buləs. ");
INSERT INTO taq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Meddən-wi išla a-wen-dăɣ, əssa-essăn, abba-năsăn u-tikutawen s-isəm-net Žibba. ");
INSERT INTO taq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","E-d əttărăn teɣăre n-isəm n-Ɣisa făll-iməlšan, ad-hasăn-ănn alšin: «Năkk ya əzzaɣăɣ Ɣisa, əssanăɣ daɣ a-wa ămoos Buləs-i t-ixaṭṭăbăn măšan kăwăneḍ, mi tămoosăm?» ");
INSERT INTO taq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Oḍa fălla-săn amălšon iyyăn, iknăs-tăn ed irnʼ-en ăṣṣahăt, iknʼ-en asəlmaḍ hundăɣ har a-s əzjărăn ehăn-en-dăɣ, əzzafăn, šarăn. ");
INSERT INTO taq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ǝslăn kăl-Ălyăhud hakd kăl-Ălyunan-wi hănen Ifăsus i-isălan-en-dăɣ ɣas, ărmăɣăn ad-samɣarăn isəm n-Emăli Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","A dd-tisən ăddinăt ăjjootnen omannen s-Măssinăɣ, safăkkarăn-dd terk timašalen-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ăwwăyăn-dd imăssăxărăn ăjjootnen əlkəttabăn-năsăn, ad-tăn-sarɣen dat-tamətte iket-net, ăḍkăḍăn ălqim n-a-wen-dăɣ irɣăn, osăn-t, iwwăḍ səmmosăt timərwen n-efăḍ n-ărriyal n-aẓrəf. ");
INSERT INTO taq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ǝmmək-wen-dăɣ a-s təntăm tărna n-Măssinăɣ d-ăṣṣahăt n-măjrăd n-Emăli dăɣ-ulhawăn n-ăddinăt, ad-nattăjăn daɣ isălan-net. ");
INSERT INTO taq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ijjăš-dd ḍarăt-a-wen ənniyăt n-Buləs tărha n-ad-ijləy Masidunya d-Akaya, ăkk Yărussălam, ijanna dăɣ-iman-net a-s afăl-hin-iwwăḍ dihen, ad-ittăr əmmək s-ikka Roma. ");
INSERT INTO taq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ăšmašăl Timoti d-Errast wi n-imadhalăn-net s-Masidunya, ija ənta ăzzăman dăɣ-Azya. ");
INSERT INTO taq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ăzzăman-en-dăɣ ad-təja tamdərwayt măqqoorăt făl təssəba n-tabarăt n-Emăli-ta isaɣra Buləs. ");
INSERT INTO taq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iggăd-dd enhăḍ iyyăn s-isəm-net Dimitrus, ikanna ăṭṭăṣwerăn n-aẓrəf făll-ăṣṣiwwwăr idəm n-temălit tiyyăt s-isəm-net Artamis, ămoos a-wen a ihʼ ălfăyda măqqoorăn i-inhăḍăn ed, itiirəw-dd săr-săn ehăre n-tikunen. ");
INSERT INTO taq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ăsdăw-dd inhăḍăn-wi dăr-ohăr ălxidmăt, innʼ-asăn: «Meddən, nəhlăk, təssanăm a-s ălxidmăt-nănăɣ, a-s terše-nănăɣ, wădden hannăyăm, sallăm daɣ dăɣ-Ifăsus hakd-dăɣ dăɣ-Azya iket-net a-s Buləs-wa-hi, ");
INSERT INTO taq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ăsmăttăy tamətte tăjjeet ed edăgg osa-dăɣ, ad-dăɣ-s ănn a-s: ‹Imakrašăn wi nəkann s-ifassăn-nănăɣ, mălayăɣna ɣas.› ");
INSERT INTO taq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ămoos-anăɣ a-wa t-išlăn săbxas, ămoos-t daɣ i-ehăn n-ămudd wa n-Artamis făl-a-s išwar ăba s-tăt-ăssimɣărăn ăddinăt wi tăt-ɣabbădnen dăɣ-Ifăsus d-ikallăn n-ăddunya wi iyyăḍnen.» ");
INSERT INTO taq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ǝslăn i-a-wen ɣas, ijjăš-tăn aḍkăr, ad-saɣăren dăɣ-išənnawăn, jannen: «Artamis ta n kăl-Ifăsus, ənta a-s măssa-năɣ ta tojărăt dăɣ-išənnawăn d-ăkall.» ");
INSERT INTO taq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ămdărwăy aɣrəm iket-net, ad-dd-tidaw tamətte s-ehăn wa n-ăddăl d-iẓəjraẓ. Təzzăn tamətte s-Gayəs d-Aristarăq wi n-Masidunya n-imidiwăn n-Buləs dăr-ohăr asikəl, əlwăyăn-tăn. ");
INSERT INTO taq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ittăr Buləs ənta-dăɣ ad-ăkk ehăn wa n-ăddăl d-iẓəjraẓ măšan, əgdalăn-as inəṭṭulab s-a-wen, ");
INSERT INTO taq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ăsmătărăn-t daɣ imizărăn n-Azya n-imidiwăn-net t-əllanen dihen-dăɣ d-ad-wăr-ikka ehăn-en. ");
INSERT INTO taq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A-s ităjj a-wen-dăɣ, tăseɣărăt tamətte dăɣ-išənnawăn, ămidărwăy a-wen-dăɣ iket-net s-iɣăran, wăr t-illa-i s-olăhăn iɣăran-net d-wi n-amidi-net, făl-a-s təššəm n-tamətte-ten-dăɣ, wăr təssen wăla-dăɣ ăddălil n-tamdərwayt-ta-dăɣ təjăt. ");
INSERT INTO taq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ǝmhălăn-dd kăl-Ălyăhud ăhaləs s-isəm-net Ălxaḍer i-ad-iməl dat-tamətte, jăn-as isălan n-a-wa ijăn, ăstafăy-asăn i-ad-hasăn-ămmăjrăd ");
INSERT INTO taq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","măšan, təlmăd tamətte a-s i n-kăl-Ălyăhud ɣas, ad-saɣăren, jannen: «Artamis ta n-kăl-Ifăsus, ənta a-s măssa-năɣ ta tojărăt dăɣ-išənnawăn d-ăkall.» Tăseɣăyya tamətte s-əmmək-wen-dăɣ hundăɣ har okăyăn əssin ăssaɣătăn. ");
INSERT INTO taq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Iggăd-dd ălmer n-aɣrəm wa n-Ifăsus, ad-isasmaḍ tamətte, ijannʼ-as: «Ya kăl-Ifăsus, mi wărăn issen dăɣ-ăddunya a-s năkkăneḍ-i-dăɣ n-Ifăsus a iɣlafăn ehăn wa-dăɣ titwăɣbid Artamis ta tojărăt, ənta d-tele-net ta tăṣṣiwwărăt dăɣ-tăhunt ta dd-tătrăkket dăɣ-išənnawăn? ");
INSERT INTO taq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ɣas, šămad a-wen, wăr t-ihʼ ăššăk, adiš, sănsăt ənniyăt-năwăn, wăr tăjjăt a išlayăn, ");
INSERT INTO taq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","meddən-wi dd-tăwwăyăm, wăr-ăskafărăn, wăr-ənnen daɣ a lăbasăn făll-măssa-năɣ, ");
INSERT INTO taq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","kunta ăɣšadăn a lăbasăn i-Dimitrus d-imidiwăn-net, adiš, əqqəlnet i-išilan wi dăɣ-itaɣătăs ăššăreɣa ed, əllan-t ălqaḷḷităn i-a-wen, əškəwnet săr-săn; ");
INSERT INTO taq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kunta daɣ tăsiwărăm-tăn uḍlem săl wen-dăɣ, ad-itwăɣtəs ăššăreɣa-net dăɣ-ălžămaɣăt wa ilăn s-a-wen. ");
INSERT INTO taq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Afăl wăr nəlkem i-ăddăbara-wen-dăɣ, ad-hanăɣ-isəwăr əlxəkum uḍlem ed ažəmmăɣ-nănăɣ ămăra-dăɣ, wăr-ila ăddălil.» ");
INSERT INTO taq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Innă ălmer a-wen ɣas, innă i-tamətte, ad-tămmăhăš. ");
INSERT INTO taq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tokăy tamdərwayt, sămmiḍ tanfust ɣas, issăɣră-dd Buləs inəṭṭulab, ad-tăn-isamătar, isasmaḍ ulhawăn-năsăn, issəllăm fălla-săn ḍarăt-a-wen, ikkă teje ta n-Masidunya. ");
INSERT INTO taq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Issăɣlăy-dd dăɣ-s iket-net, isamătar imumənăn. Ifăl dihen, ikkʼ ăkall wa n-Ălyuna, ");
INSERT INTO taq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ăssakăy dihen, kăraḍ orăn; ălwăqq wa d-itəffal ăkall-en, ăkk wa n-Surya, əjjăšăn-t isălan n-taɣdărt ta s-ărhăn kăl-Ălyăhud ad-has-tăt-əjən ɣas, olăs uɣəl n-teje ta n-Masidunya, ");
INSERT INTO taq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ăddeew d-Subatir ăgg Birus wa n-aɣrəm wa n-Biri, d-Aristarăq d-Skăndus wa n-Tăslonika d-Gayəs wa n-Darba d-Timoti, d-Tušik d-Tirfim wa n-teje ta n-Azya. ");
INSERT INTO taq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ăzzarăn-as meddən-win-dăɣ, əqqălăn-asăn dăɣ-aɣrəm wa n-Tărwas, ");
INSERT INTO taq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","okăy-anăɣ ămudd wa dăɣ-tattăn ăddinăt tijəlwen ti wăr ha tăẓẓa ɣas, nəjjăš turăft n-aman dăɣ-aɣrəm wa n-Fəlibb, năssakăy səmmos išilan făll-ejărew təzzar, năwwăḍ-tăn-in dăɣ-Tărwas-i-dăɣ năssakăy əssəboɣ imdan. ");
INSERT INTO taq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ijʼ-anăɣ ašăl wa n-ălxad-i n-ašăl wa ăzzarăn dăɣ-əssəboɣ dihen ɣas, năžžiimăɣ iket-nănăɣ, nətatt amənsi wa n-tasăktot šăddijăn. Issan Buləs, a-s ašăl wa ilkămăn i-wen, iglă. Dăɣ-təssəba n-a-wen-dăɣ a făl ăssakăy ehăḍ-wen-dăɣ, ădiwănnăt d-imadhalăn-net d-ăddinăt. ");
INSERT INTO taq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Năžžiimmăɣ iket-nănăɣ făll-afălla n-ehăn n-soro ăsimălăwlăwnăt tiftəl ăjjootnen, ");
INSERT INTO taq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ădiwănnăt Buləs i-ălžămaɣăt dihen-dăɣ, a-s ija a-wen-dăɣ, ăsihătăl ămawaḍ s-isəm-net Itikus făll-fənetăr ămerăn. Ămmiijrăd Buləs ehăḍ-en-dăɣ a-s hin-ilɣăd eḍəs Itikus, ătrăkkăt-dd făll-afălla n-soro wa s-kăraḍ. A-s săr-s dd-ăzzubben imumənăn, əjmaḍăn-t iman. ");
INSERT INTO taq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ăzzubbăt-dd săr-s Buləs ənta-dăɣ, ibdăd jənnəj-s, irmăs-t-dd s-ăfuss təzzar, innă i-ăddinăt: «Ănset ənniyăt-năwăn, iddar.» ");
INSERT INTO taq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iqqăl ḍarăt-a-wen afălla n-ehăn, ăẓun amənsi wa n-tasăktot šăddijăn, olăs-asăn edăwănne har tănfărarăw tifawt. ");
INSERT INTO taq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iqqăl ămawaḍ ənta ehăn-net, iddar-iɣlas. Ămoos a-wen əssəbab n-tedăwit ăssismăḍăn ulhawăn n-tamətte iket-net. ");
INSERT INTO taq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Năzzar năkkăneḍ i-Buləs, nəjjăš turăft n-aman, nəkka Asus-i dăr-s nohăr ed, ăssof ənta ad-ăj asikəl-en făll-iḍarăn-net. ");
INSERT INTO taq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Iwwăḍ-anăɣ-dd dăɣ-Asus ɣas, nămohăr dăr-s asikəl har năsjăn dăɣ-Mittilăn, ");
INSERT INTO taq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","nokăy ašăl wa iyyăḍăn s-Šayo, təzzar, nokăy s-Samos d-Milati. ");
INSERT INTO taq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ăssof Buləs ad-wăr-immer aɣrəm wa n-Ifăsus i-ad-wăr t-ăwweɣăn dăɣ-s ăddinăt wi n-teje ta n-Azya ed, ărorăd Yărussălam i-ad-dăɣ-s isəssikəy ămudd wa n-Fantăkawt. ");
INSERT INTO taq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ălwăqq wa d-năsjăn dăɣ-Milati, ăssoka Buləs inušămăn n-ălkănisăt ta n-Ifăsus. ");
INSERT INTO taq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Osăn-t-dd ɣas, innʼ-asăn: «Təssanăm kăwăneḍ iman-năwăn tămudre ta əṭṭăfăɣ ɣur-wăn dăɣ-a-wa əkkăsăɣ əlleɣ jere-wăn ašăl wa d-kăwăn-dd-oseɣ dăɣ-teje ta n-Azya, ");
INSERT INTO taq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","təssanăm əmmək wa s-ăsrăsăɣ iman-in data-wăn dăɣ-ălxidmăt wa heɣ i-Emăli. A-wen, jeɣ-t s-imeṭṭawăn d-ahănay n-talɣiwen sămumnen săr-i dd-orawăn kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Təssanăm daɣ a-s wăr t-illa a hawăn-əffarăɣ, ăxṭăbăɣ-awăn, əssăɣrăɣ-kăwăn dăɣ-ihănan-năwăn hakd tifărrawen a-wa hawăn-iha ălfăyda iket-net, ");
INSERT INTO taq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","wăr kăla hi-okăy ašăl d-wăr-ăsmătărăɣ kăl-Ălyăhud hakd inəẓẓulam d-ad-utabăn i-Măssinăɣ, əjən immun-năsăn dăɣ-Emăli Ɣisa. ");
INSERT INTO taq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ămăra năkk da-hi, izzəlzăm Unfas Šăddijăn tikawt n-Yărussălam, wăr-əssenăɣ a hi-iqqălăn dăɣ-s ");
INSERT INTO taq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","măšan, ikkas-ahi Unfas Šăddijăn dăɣ-taɣdărt n-a-s taɣrəmt oseɣ-dăɣ, ăjăɣet făll-ujəš n-tišəm d-ahănay n-aɣăna. ");
INSERT INTO taq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Diha t-əlleɣ, wăr-əjeɣ tămudre-nin hărăt, wăr fălla-s ărmeɣăɣ ed, wăr hənnəyăɣ a săl ittus wa s-ošalăɣ i-ad-hin-səssiwəḍăɣ amăšal wa hi-issăɣlăf Emăli Ɣisa, ăxṭəbăɣ isălan n-Ălənžil-i hăn isălan n-ănnuɣmăt n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ămăra, kăwăneḍ-i jer-ăxṭăbăɣ isălan n-Təmmənəya n-Măssinăɣ, əssanăɣ a-s ăbas ilkam ad-tənhayăm idəm-in, ");
INSERT INTO taq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","əkkasăɣ-kăwăn dăɣ-taɣdărt iket-dăɣ-năwăn, ăbas dăɣ-i əḍmanăn iman-năwăn ed, a-wa ămoosăn ălmăɣna n-əlɣəllas n-Măssinăɣ wa hawăn-irha, ");
INSERT INTO taq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","əssăɣrăɣ-kăwăn tayətte-net iket-net, wăr dăɣ-s-in-oyyeɣ hărăt. ");
INSERT INTO taq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ămăra, ăjăt ənniyăt i-iman-năwăn, tagəẓăm daɣ ălžămaɣăt n-imumənăn wa kăwăn-issăɣlăf Unfas Šăddijăn, umasăt šund imăḍanăn ăɣdalnen, agəẓăt ălkănisăt n-Măssinăɣ ta ikfă iman-net s-ašni-net wa inɣălăn. ");
INSERT INTO taq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ǝssanăɣ a-s afăl kăwăn-əfălăɣ, ad-jere-wăn dd-əlmuməsnăt tiɣəs wăren-e-aḍən tăhanint i-tahrut ta n-imumənăn. ");
INSERT INTO taq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ad-kăwăn-dd-əzjărăn meddən n-inəsbuha maden-əttăr ere ăslălăn ḍara-săn, ");
INSERT INTO taq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","a-wen-dăɣ a făl, ăjăt ənniyăt, əktəwăt-dd a-s kăraḍ iwətyan-wi əkkăsăɣ jere-wăn, ehăḍ d-ašăl, samătarăɣ-kăwăn s-iyyăn-iyyăn, dehiyyăn făw, imeṭṭawăn a-s jeɣ a-wen. ");
INSERT INTO taq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ămăra, ayətma, ăssiiɣlăfăɣ-kăwăn i-Măssinăɣ d-ănnuɣmăt n-măjrăd-net, Măssinăɣ a ilan tărna n-ad-kăwăn-isədwəl dăɣ-immun-năwăn, isətbət tăkasit ta itwăr i-iməššeddəjăn iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A-s t-əlleɣ jere-wăn, wăr-ăsdărhănăɣ aẓrəf wăla orăɣ wăla isəlsa n-wălʼ iyyăn dăɣ-wăn, ");
INSERT INTO taq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","səjrăhăt ifassăn-in, təssanăm kăwăneḍ iman-năwăn a-s ifassăn-in a-s ăxdămăɣ i-a-wa s-ămiɣatărăɣ, năkk d-meddən-wi dăr-i ăddewnen, ");
INSERT INTO taq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","əssəknăɣ-kăwăn hak ašăl a-s a-wen-dăɣ a-s təlam s-ad-t-təjəm i-ad-tədhəlăm tilăqqiwen. Ǝktəwăt-dd a-wa innă Emăli Ɣisa a-s innă: ‹Ojăr ălxer ihăn isuf uhən ajăraw.› » ");
INSERT INTO taq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Issəmdă Buləs d-timtăr-tin-dăɣ ɣas, ărkăɣăn iket-dăɣ-năsăn, ad-hasăn-itəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Hallăn iket-dăɣ-năsăn, tikrirəyăn dăɣ-s, tisəsăn-t dăɣ-idmarăn-năsăn, ");
INSERT INTO taq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ăsniinăn iman-năsăn făll-a-wa s-hasăn-innă, ăbas ilkam ad-t-ənhayăn. Ăssofăḍăn-t-in ḍarăt-a-wen hundăɣ har ijjăš turăft n-aman təzzar, əqqălăn. ");
INSERT INTO taq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nəbḍa dăr-săn ɣas, nəjjăš turăft n-aman, nărmăs tamdujt n-awtəl wa n-Kus, ăffăw-anăɣ, nokăy s-Rudus təzzar, nəkkă Batara. ");
INSERT INTO taq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nəjrăw dihen turăft n-aman tiyyăt təkkat teje ta n-Finisya, nəjjăš-tăt, ");
INSERT INTO taq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","nohăẓ-in awtəl wa n-Qəbrus, noyyʼ-e făll-tăšalje-nănăɣ, nokăy s-Surya, năzzubbăt dăɣ-aɣrəm wa n-Tir-i dăɣ-la turăft s-ad-zəzzubbət ilalăn wi tăt-əhănen. ");
INSERT INTO taq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nəjrăw hărăt dăɣ-inəṭṭulab, năssakăy ɣur-săn əssa išilan. Nəllʼ-e ɣur-săn dihen-dăɣ a-s tăn-dd-imhăl Unfas Šăddijăn s-Buləs, ad-t-salɣadăn d-ad-wăr-ikka Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Okăyăn-anăɣ išilan-en-dăɣ dihen ɣas, ăssofăḍăn-anăɣ-in imumənăn-win-dăɣ, meddən, tiḍeḍen d-aratăn har nəzjăr aɣrəm, nărkăɣ dăɣ-asălim n-ejărew, ad-nətəddal Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nəssəmdă tittar d-isənnăɣlaf dăr-săn ɣas, nəjjăš turăft n-aman, əqqălăn əntăneḍ ihănan-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nəfăl năkkăneḍ Tir, nəkkă Bătlomis. Năsjăn dăɣ-s ɣas, nəkkă ayətma-năɣ dăɣ-ăddin wi t-əllănen dihen, năssăllăm fălla-săn təzzar, năssakăy ašăl ɣur-săn. ");
INSERT INTO taq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ăffăw-anăɣ ɣas, nəkkʼ ehăn wa n-Filəbb wa n-amăllănžal, izzaɣ aɣrəm wa n-Qăyṣăra, ənta a-s iyyăn dăɣ-meddən wi n-əssa ənnəfrănnen dăɣ-Yărussălam, năzzubbăt ɣur-s. ");
INSERT INTO taq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ila əkkoẓăt tilyaḍen wăren əzzey meddən, jarrăwnăt măjrăd ɣur-Măssinăɣ i-ad-t-in-səssiwəḍnăt ăddinăt. ");
INSERT INTO taq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Năssakăy hărăt n-išilan dihen-dăɣ a-s hanăɣ-dd-osa ănnăbi dd-ifalăn Ălyăhudəyăt s-isəm-net Ăggăbbas. ");
INSERT INTO taq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Osʼ-anăɣ-dd ɣas, iḍkăl taməntəka n-Buləs, osăɣ săr-s ifassăn-net d-iḍarăn-net, inna: «Ǝnta da a-wa innă Unfas Šăddijăn: măssi-s n-taməntəka-ta-dăɣ, ilkam ad-t-əkrədăn kăl-Ălyăhud s-əmmək-wa-dăɣ dăɣ-Yărussălam, əjən-t jer-ifassăn n-inəẓẓulam.» ");
INSERT INTO taq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nəslă i-isălan-win-dăɣ ɣas, ad-nəlaqqăd năkkăneḍ hakd imumənăn wi əzzăɣnen Qăyṣăra Buləs i-ad-wăr ikkă Yărussălam ");
INSERT INTO taq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","măšan, innʼ-anăɣ: «Ma ămoos a-wa kăwăn-išlăn, naxxăsăm ulh-in s-imeṭṭawăn-năwăn? Năkk, diha t-əlleɣ, ăsidăwăɣ i-tišəm hakd-dăɣ i-tamăttant dăɣ-Yărussălam făl təssəba n-isəm n-Emăli Ɣisa.» ");
INSERT INTO taq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Issəndăr-anăɣ ɣas, nəkfʼ-e ălɣafyăt, nənn-as: «Ija Măssinăɣ erhet-net.» ");
INSERT INTO taq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Năssakăy ăzzăman dăɣ-Qăyṣăra təzzar, năsdăw, năjoẓăy s-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ăssofăḍăn-anăɣ-in hărăt dăɣ-inəṭṭulab n-aɣrəm-en, ăwwăyăn-anăɣ s-ehăn n-amumən s-isəm-net Mănasun ila awtəl wa n-Qəbrus, năzzubbăt ɣur-s. ");
INSERT INTO taq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Năwwăḍ-in Yărussălam ɣas, ăsbărrăkăn-anăɣ dăɣ-s ayətma-năɣ dăɣ-ăddin s-tedăwit. ");
INSERT INTO taq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ăffăw, năddew d-Buləs s-ehăn wa n-Yaqub-i ɣur-ăžžimmăɣăn inušămăn n-ălkănisăt iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nănmăjja dăr-săn isofan təzzar, illăɣăt-asăn Buləs isălan s-iyyăn-iyyăn n-a-wa ija Măssinăɣ iket-net jer-inəẓẓulam s-ălxidmăt wa ija jere-săn. ");
INSERT INTO taq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ǝslăn i-isălan-en-dăɣ ɣas, ad-tiimələn Măssinăɣ. Ǝnnăn-as ḍarăt-a-wen: «Ăŋŋa-năɣ Buləs, ənhəy ɣas afḍăn făll-afḍăn n-kăl-Ălyăhud wi omănnen s-Măssinăɣ, əṭṭafăn iket-dăɣ-năsăn alkum i-alămăr wa n-Mosa dăɣ-isălan n-asəmmili n-aratăn d-ălɣadatăn wi-iyyăḍnen; ");
INSERT INTO taq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","nəssan a-s ămăra d-əslăn a-s dd-tosed, ilkam dăɣ-săn tənna n-hărăt ed əslăn a-s kăyy, tănimăšrayăd i-alămăr wa n-Mosa. ");
INSERT INTO taq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nărha fălla-k ămăra ad-tăn-təkkəsăd dăɣ-tăqqăn n-eɣăf-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ămăra, ăddăbara-nănăɣ hak da: hann-anăɣ əkkoẓ meddən əjjašnen ărkăwăl, ");
INSERT INTO taq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","idawnet dăr-k s-edăgg wa dăɣ-šašdajăn ăddinăt iman-năsăn, šəšdəjăd iman-năk dăr-săn, təkkəsăd-asăn ehăre wa n-asəttəbəlbəl-năsăn, dihen, ad-əlmədăn ăddinăt a-s a-wa fălla-k itawănnen, wădden a ijan ed, a-wa mad-təjəd, ăsijăyha a-s wăr tănmăšrăyăd i-alămăr wa n-Mosa. ");
INSERT INTO taq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Dăɣ-isălan n-inəẓẓulam wi s-ămăra, omanăn s-Ălmasex, nəktab-asăn tăkarḍe n-tamătert dăɣ-hasăn-nənnă, wăr tăttănet isan ămoosnen takute i-ăṣṣănăm, wăr săssănet ašni, wăr tăttănet măɣsoy, əbḍəwnet d-e d t-illăm a isamăḍasăn taɣəssa.» ");
INSERT INTO taq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ăffăw, ăddew Buləs d-meddən wi n-əkkoẓ, ijjăš dăr-săn edăgg wa n-təšədje, illăɣăt i-ăddinăt tăqqăn ta mad-səssikəyən təzzar išdajăn, təzzar ăkt hak iyyăn dăɣ-săn făll-iman-net. ");
INSERT INTO taq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Išwar imda əssəboɣ wa n-təšədje-năsăn, ənhăyăn hărăt dăɣ-kăl-Ălyăhud n-ăkall wa n-Azya Buləs dăɣ-ehăn n-ămudd wa măqqărăn ɣas jăn-dd erk iman dăɣ-tamətte, toḍa fălla-s, ");
INSERT INTO taq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","saɣăren ăddinăt, jannen: «Ya kăl-Iṣrayil, əyyăwăt! Ǝnhəywăt ăwadəm-wa s-edăgg osa-dăɣ, išinməšrəy tamətte-nănăɣ s-a-wa ixaṭṭăb făll-alămăr wa n-Mosa d-a-wa ijăn făll-ehăn n-ămudd wa măqqărăn, ənhəywăt-ak, igla făw har dd-ăššojăš dăgg-Ălyunan iyyăḍ ehăn n-ămudd wa măqqărăn, ăsmăḍăs-t.» ");
INSERT INTO taq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ǝnnăn a-wen făl-a-s innin, ənhayăn Tirfim wa n-Ifăsus ăddeew d-Buləs dăɣ-ammas n-aɣrəm, ăɣelăn, ăššojăs-t-dd ehăn n-ămudd wa măqqărăn. ");
INSERT INTO taq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Iwăs aɣrəm-ənnin-dăɣ iket-net, tošăl-dd tamətte, ărmăsăn ăddinăt Buləs, ăšrăwrăwăn-t har t-əzzəzjărăn ehăn n-ămudd təzzar, ăɣfălăn tishar-net ḍara-săn. ");
INSERT INTO taq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tattărăn iji n-iman-net dihen-dăɣ a-s osăn isălan n-tamdərwayt ta jat dăɣ-aɣrəm kumănda wa ănnihăḍăn dăɣ-əssărdusa wi n-kăl-Roma hănen Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Issăɣră-dd ălwăqq-wen-dăɣ kăbtănăn d-əssărdusa, ăddew dăr-săn šik s-tamətte. Tənhăy-t tamətte imal-dd ənta d-əssărdusa-net ɣas, əbḍăn d-Buləs. ");
INSERT INTO taq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ikkă-dd kumănda Buləs, omăr s-ad-dăɣ-s ətwəjjənăt sănatăt tišəm təzzar, issəstăn-t d-ere wa ămoos d-a-wa iɣšăd. ");
INSERT INTO taq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tăsiɣărăt tamətte iket-net, hak ašrut-dăɣ wăr-oher d-amidi-net iɣăran, indăr i-kumănda ad-isəl i-a-wa has-ijanna Buləs. Omăr ḍarăt-a-wen s-ad-ăttălwăy Buləs s-ehăn wa n-əlɣəskăr. ");
INSERT INTO taq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ălwăqq wa d-itiwən Buləs asəggaggən wa išijušăn ăwadəm ehăn wa n-əlɣəskăr, amsiwi a t-əjăn əssărdusa făl təssəba n-ašunəj-i-dăɣ săr-s təja tamətte i-ad-t-tănɣ. Issəntă Buləs ujəš n-ehăn, təzzăn săr-s tamətte har dd-əqqălăn əssărdusa jan-as afăraj. ");
INSERT INTO taq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tăsiɣărăt tamətte iket-dăɣ-net, janna: «Ămmătet, ămmătet.» ");
INSERT INTO taq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ălwăqq wa d-ăbok Buləs ujəš n-ammas n-ehăn wa n-əlɣəskăr, innă i-kumănda: «Ak ăddobeɣ ad-hak-ănnăɣ hărăt meɣ?» Innʼ-as kumănda: «Kăhh! Ɣas kăyy təssanăd Tălyunanit? ");
INSERT INTO taq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Adiš kăyy, wădden u-Miṣra-wa s-a ăynayăn d-ăsfăllăg əkkoẓ afḍăn n-ăwadəm wi has-əlkămnen s-tenere?» ");
INSERT INTO taq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Innʼ-as Buləs: «Năkk, ăgg-Ălyăhud, əweɣ dăɣ-taɣrəmt ta n-Tarša dăɣ-teje ta n-Silisi, a-wen taɣrəmt təlat isəm. Ămăra, ărheeɣ dăɣ-k, ad-hi-təkfəd turhajăt n-ad-ăjăɣ hărăt n-măjrăd i-tamətte-ta-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ikfʼ-e kumănda măjrăd ɣas, ibdăd Buləs, ikkă-dd tamətte, ibdăd făll-isəgguggan n-ehăn, illăf i-tamətte i-ad-susəm, tăssosăm. Imməjrăd-asăn ălwăqq-wen dăɣ-Ɣăbranəyya, tawalt ta-dăɣ ənkăsăn. Innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ayətma-ɣ, abba-tăn-in, săjdăt ămăra i-măjrăd wa s-ărheɣ ad-hawăn-t-ăjăɣ i-ad-săr-s əkkəsăɣ uḍlem făll-iman-in.» ");
INSERT INTO taq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ǝslăn a-s Ɣăbranəyya-ta-dăɣ əttăḍăn a dăɣ-hasăn-ăssewăl, əṭṭăfăn ṭăbb, ăsjădăn-as. Innʼ-asăn: ");
INSERT INTO taq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Năkk, ăgg-Ălyăhud, əweɣ dăɣ-taɣrəmt ta n-Tarša təhăt Silisi măšan, aɣrəm wa n-Yărussălam a dăɣ-ədwălăɣ. A-wa əlmădăɣ iket-net, əlmădăɣ-t daw-təlɣuləma n-Gamălyăl. Ǝnta a hi-issăɣrăn alkum i-a-wa innă alămăr n-abbatăn-nănăɣ iket-net. Ǝjjəluyăt-in dăɣ-tuksəḍa n-Măssinăɣ a hi-iwwăyăn s-əššənju n-tabarăt ta-dăɣ n-Ɣisa s-əmmək wa s-tăt-tăššunjem ašăl-i-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ǝgleɣ dăɣ-əššənju wa has-jeɣ har tajjăɣ iman n-ăddinăt wi əlkămnen i-zăbo-wen-dăɣ, tajjăɣ tišəm dăɣ-iyyăḍ, təjjarăɣ-tăn dăɣ-takărmut, wăr-əẓleyăɣ meddən d-tiḍeḍen. ");
INSERT INTO taq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","A-wen, ăjjəyhʼ-as ămănokal n-kăl-tikutawen, ăjjəyhăn-as daɣ inušămăn wi ɣattăsnen ăššăreɣa ed əntăneḍ iman-năsăn a hi-əkfănen tikarḍiwen əkkanen kăl-Ălyăhud wi n-aɣrəm wa n-Dămašăq i-ad-əjrəwăɣ tabarăt n-asəttărməs n-ăddinăt-wi əlkămnen i-tabarăt-ta-dăɣ, ăjăɣ dăɣ-săn tišəm təzzar, əlwəyăɣ-tăn-dd s-Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ăssokalăɣ dăɣ-isălan n-a-wen-dăɣ har hin-ohăẓăɣ Dămašăq. Diha-dăɣ tăt-in-ohăẓăɣ s-tarăhut, wăla a hin-əjrăhăɣ, a-s făll-i dd-ăzzubbăt ănnur, dd-ifalăn išənnawăn, ijan amləwləw n-tikunen, ");
INSERT INTO taq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","əheɣ-dd oḍeɣ, əsleɣ i-emăsli hi-innăn: ‹Sawəl, Sawəl! Ma kăy-orămăn săr-i, tiɣəzzubud-ahi?› ");
INSERT INTO taq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ǝnneɣ: ‹Emăli, mi tămoosăd?› Innʼ-ahi: ‹Năkk a-wa Ɣisa wa n-Năṣirăt tiɣəzzəbud.› ");
INSERT INTO taq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ǝnhăyăn meddən wi dăr-ăddewăy ănnur wa dd-ămlăwlăwăn măšan, wăr-əslen i-emăsli wa hi-ămmijrădăn. ");
INSERT INTO taq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ǝnneɣ-as: ‹Emăli! Ma s-leɣ s-ad-t-ăjăɣ?› Innʼ-ahi Emăli: ‹Ǝbdəd, ăkk aɣrəm wa n-Dămašăq, ad-hak-itwənn dihen a-wa s-led s-ad-t-təjəd.› ");
INSERT INTO taq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","A-s ităjj a-wen-dăɣ, wăr t-illa a hannăyăɣ ed, ăsdărɣăl-ahi ănnur wa făll-i dd-ăzzubben. Ǝlwăyăn-ahi imidiwăn-in s-ăfuss har nəjjăš Dămašăq. ");
INSERT INTO taq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Illʼ-e dihen ăhaləs ăddiinăn dăɣ-a-wa innă alămăr wa n-Mosa, ăssiimɣărăn kăl-Ălyăhud s-isəm-net Ănanyas, ");
INSERT INTO taq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ənta-en-dăɣ a hi-dd-osăn, ăzozăy-ahi iman-net, innʼ-ahi: ‹Ăŋŋa-ɣ Sawəl, arr tiṭṭawen-năk›. Ămerănăt-dd tiṭṭawen-in, ənhăyăɣ-t. ");
INSERT INTO taq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Innʼ-ahi daɣ: ‹Măssinăɣ-i s-əlkămăn abbatăn-nănăɣ a-s ăru d-kăy-ăsnăfrăn i-ad-kăy-isəlməd erhet-net, tənhəyăd wa s-itawănna Ămaɣdal, təsləd i-a-wa fălla-k irha s-emm-net, ");
INSERT INTO taq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","tumasăd tajuhe-net dat-dăgg-adəm, tăllăɣed-asăn a-wa tənhăyăd d-a-wa s-təsled iket-net. ");
INSERT INTO taq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ămăra, ma kăy-iwwaɣăn? Ǝbdəd, tətwəsəlmăɣăd dăɣ-aman, săɣləfăd iman-năk Măssinăɣ i-ad-kăy-išəšdəj dăɣ-ibăkkaḍăn-năk.› ");
INSERT INTO taq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ălwăqq wa d-ăqqălăɣ Yărussălam ḍarăt-a-wen, təddalăɣ Măssinăɣ dăɣ-ehăn n-ămudd wa măqqărăn ašăl iyyăn a-s hi-tăssoḍa tănăfalilt dd-falăt Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ǝnhăyăɣ Emăli, innʼ-ahi: ‹Tărmaḍ, əzjăr Yărussălam šik făl-a-s wăr mad-ărḍən imuzăɣăn-net s-tajuhe ta făll-i mad-təjəd.› ");
INSERT INTO taq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ǝnneɣ-as: ‹Emăli, wădden, əssanăn imumənăn əmmək wa s-əkkeɣ jer-ihănan n-ăddin wi n-kăl-Ălyăhud, naqqăɣ iyyăḍ dăɣ-săn, tajjăɣ tiwit s-ebărtăk dăɣ-iyyăḍ, təjjarăɣ-in wi iyyăḍnen dăɣ-takărmut. ");
INSERT INTO taq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ašăl wa d-inɣăl ašni n-Stifan-i n-tajuhe-năk, əbdadăɣ, taqqăsăɣ i-wi t-naqqănen, năkk făw a əssăɣlăfăn isəlsa-năsăn.› ");
INSERT INTO taq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Innʼ-ahi Emăli ălwăqq-wen: ‹Ǝgləw, ad-kăy-sukăɣ tiwsaten n-inəẓẓulam ti hănen ikallăn wi ujəjnen.,› » ");
INSERT INTO taq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ăsijădăn-as ăddinăt hundăɣ har ten-dăɣ ɣas, ăsɣăren dăɣ-išənnawăn, ad-jannen: «Ǝlhəsăt fălla-năɣ ăwadəm-wa-dăɣ, wăr-ilă s-ad-ăqqayəm iddar.» ");
INSERT INTO taq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Naḍḍăwăn iɣăran, tăkkăsăn isəlsa-năsăn făll-iman-năsăn, nabbăsăn-as ăkall. ");
INSERT INTO taq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Omăr kumănda ălwăqq-wen i-ad-t-šujəšăn əssărdusa ammas n-ehăn wa n-əlɣəskăr, əjən dăɣ-s tiwit i-ad-t-šəhhəššəlăn tənna n-ăddălil-wa făl fălla-s saɣărat tamətte. ");
INSERT INTO taq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Karrădăn-t əssărdusa dihen-dăɣ i-ad-dăɣ-s əjən tiwit a-s innă Buləs i-kăbtăn wa t-illăn dihen: «Ajăn, ijraw-awăn ălqanun ad-təjəm tiwit dăɣ-u-Roma wăr-ăswăr ăššăreɣa uḍlem.» ");
INSERT INTO taq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Isla kăbtăn-en i-a-wen ɣas, ošăl s-kumănda, innʼ-as: «Hekăyy! Ăj ənniyăt i-a-wa s-tărhed iji-net, ăhaləs-i, i n-Roma.» ");
INSERT INTO taq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ikkă-dd kumănda Buləs, innʼ-as: «Ɣas, tidət kăyy u-Roma?» Innʼ-as Buləs: «Ǝyya.» ");
INSERT INTO taq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Innʼ-as kumănda: «Năkk, aẓrəf ăjjeen a ẓălăɣ i-ad-əjrəwăɣ tumast-ten-dăɣ.» Innʼ-as Buləs: «Năkk, a əweɣ-dăɣ, ămoosăɣ-t.» ");
INSERT INTO taq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ǝššənkăšăn fălla-s əssărdusa wi s-ihənnin ărhan ad-t-əkrədăn, əjən dăɣ-s tiwit. Irmăɣ kumănda ed, ija tišəm dăɣ-ere la Roma iket-di d-ititwəšreɣ. ");
INSERT INTO taq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ăffăw ɣas, ad-itammăɣ kumănda i-ăddălil n-ăḍḍărora wa t-ăswărăn kăl-Ălyăhud, ikkăs Buləs dăɣ-tišəm, issăɣră-dd ḍarăt-a-wen imănokalăn n-kăl-tikutawen d-inušămăn-wi ɣattăsnen ăššăreɣa təzzar, issăɣră-dd Buləs, ijʼ-e jere-săn. ");
INSERT INTO taq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ikna Buləs akăyad n-inušămăn wi n-Sinhidrin ɣattăsnen ăššăreɣa təzzar, innʼ-asăn: «Ayətma-ɣ, wăr t-illa a dăɣ-əššakăɣ iman-in, a-wa s-ila ăgg-adəm s-iji-net dăɣ-isălan n-ta n-jere-s d-Măssinăɣ, wăr kăla has-ănmăšrăyăɣ har năkk-da-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Iggăd-dd săr-s Ănanyas wa n-ămănokal n-kăl-tikutawen, omăr i-əssărdusa wi t-əllanen edes i-Buləs s-ad-has-ənfăẓăn, isusəm s-iyyăt. ");
INSERT INTO taq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ǝnfăẓăn əssărdusa i-Buləs ɣas, innă i-ămănokal n-kăl-tikutawen: «Infăẓ-ak Măssinăɣ isəm n-erk ăwadəm; ənde d-ămmukkăn a-s kăyy-i s-ăniihăjja d-ad-hi-təšrăɣăd s-iqqud s-a-wa innă alămăr, kăyy-da-dăɣ ămăra has-itinməšriyăn, sasănɣed-ahi.» ");
INSERT INTO taq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ǝnnăn-as ăddinăt: «Kăyy, ma kăy-ăsihălăn tigəggar n-ămănokal n-kăl-tikutawen n-Măssinăɣ?» ");
INSERT INTO taq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Innʼ-asăn Buləs: «Ayətma, ănšăt-ahi-dd, wăr-əssenăɣ a-s ənta-i-dăɣ a-s ămănokal n-kăl-tikutawen ed əssanăɣ a-s iktab a-s: ‹Wăr tənned a lăbasăn făll-ămănokal-năk.› » ");
INSERT INTO taq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Dăɣ-a-wen-dăɣ, ad-ilmăd Buləs a-s ašrut n-tamətte iyyăn, i n-taggayt ta n-kăl-sadus, wa iyyăḍăn, i n-ta n-kăl-faris. Iḍkăl emăsli-net dat-kăl-Sinhidrin, innă: «Ayətma-ɣ, năkk u-faris n-ăgg-u-faris a ămoosăɣ, kunta illʼ-e uḍlem hi-iwarăn ašăl-i-dăɣ, wăr t-illa a ămoos kunta wădden wa n-ăṭṭăma-i jărăɣ n-a-s təlkam tanăkra jer-inəmmuttan.» ");
INSERT INTO taq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Innă a-wen ɣas, tənkăr tamɣənnant jer-kăl-faris d-kăl-sadus, tăẓun tamətte. ");
INSERT INTO taq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ămoos ašrut iyyăn wa n-kăl-sadus-i jannănen wăr təlkem tanăkra n-inəmmuttan, wăr t-əllen ănjălosăn wăla alšinăn; ămoos ašrut wa iyyăḍăn wa n-kăl-faris-i ăssiitbătăn emel n-hărătăn-win-dăɣ iket-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Təwăs tamətte iket-net, ja tăkat. Ǝggădăn ălɣulam wi n-taggayt ta n-kăl-faris, əwărăn s-ăṣṣahăt s-ašrut wa n-Buləs, ad-jannen: «Ăhaləs-i-dăɣ, wăr t-illa uḍlem fălla-s nəhannăy, ak mi issanăn făw kunta wădden a dd-ifalăn išənnawăn meɣ ănjălos iyyăn a has-imməjrădăn?» ");
INSERT INTO taq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Inhăy kumănda tukəse n-talɣa ta dd-təšrăyăt ɣas, irmăɣ făll-ad-t-təmẓəyẓəy tamətte, tənkăḍnəkăḍ-t. Omăr i-əssărdusa s-ad-t-əlwəyăn s-ehăn wa n-əlɣəskăr i-ad-t-səssijəjăn tamətte. ");
INSERT INTO taq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ehăḍ wa ilkămăn i-wen, ănfalăl-dd Emăli i-Buləs, innʼ-as: «Buləs, kuyəd, wăr kăy-išăšlalet hărăt făll-ămašăl wa kăy-əssăɣlăfăɣ, əmmək wa s-hi-tămoosăd tajuhe dăɣ-Yărussălam, əmmək-wen-dăɣ daɣ a-s mad-hi-tumasăd tajuhe dăɣ-Roma.» ");
INSERT INTO taq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ăffăw ɣas, hăḍăn kăl-Ălyăhud n-a-s wăr t-illa a mad-əkšən wăla a mad-əswən a əkkăn wăr-əssăɣdărăn Buləs, əjən iman-net. ");
INSERT INTO taq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ǝkkoẓăt timərwen n-ăhaləs a jănen tahuḍe-ten-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Dăɣ-a-wen-dăɣ, ad-əkkăn ămănokal n-kăl-tikutawen d-imănnăhăḍăn n-tamətte, ənnăn-asăn: «Nəjʼ-awăn tahuḍe, ilɣăn-anăɣ daɣ Măssinăɣ kunta illʼ-e a he-năkš wăla a he-nəsəw a nəkkăs wăr nəja iman n-Buləs. ");
INSERT INTO taq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nărha dăɣ-wăn ămăra, ad-təttărăm dăɣ-kumănda d-kăl-Sinhidrin, ad-dd-səbdədăn Buləs data-wăn dăɣ-ăsaru n-a-s tărham asəstan-net, afăl təjăm a-wen, ad-năj năkkăneḍ əmmək făll-has-in-nəssəmdă.» ");
INSERT INTO taq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Təsla tejăše n-Buləs i-taɣdărt-năsăn ɣas, ikka ehăn n-əssărdusa wa iha Buləs, ija dăɣ-s isălan. ");
INSERT INTO taq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Iɣră-dd Buləs iyyăn dăɣ-kăbtănăn, innʼ-as: «Ǝlwəy alyaḍ-i-dăɣ s-kumănda făl-a-s ila a-s irha ad-has-tăn-ănn.» ");
INSERT INTO taq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ăddew dăr-s kăbtăn-en s-kumănda, innă i-kumănda: «Buləs wa n-u-takărmut a hi-innăn ad-săr-k dd-əlwəyăɣ ămawaḍ-i-dăɣ făl-a-s ăwway isălan s-irha ad-dăɣ-k tăn-ăj.» ");
INSERT INTO taq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ikkăs-dd kumănda alyaḍ s-takše təzzar, issəstăn-t d-isălan wi ăwwăy. ");
INSERT INTO taq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Innʼ-as alyaḍ: «Ănmănnakăn kăl-Ălyăhud făll-ad-dăɣ-k əttărăn ašəkka ad-dd-təyyəd Buləs săr-săn i-ad-t-səbdədăn dat-kăl-Sinhidrin ălmăt ărhan ad-t-əknən asəstan d-a-wa iɣšăd, ");
INSERT INTO taq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","wăr kăy-săswadnet făl-a-s, a iwwăḍăn əkkoẓăt timərwen n-ăhaləs a ihăḍăn n-a-s wăr mad-əkšən, wăr mad-əswən a əkkăn wăr jen iman-net, wăr-ăqqelăn ămăra ɣas ar i-ad-săr-săn t-dd-təyyəd.» ");
INSERT INTO taq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ălwăqq wa d-isigləw kumănda ămawaḍ-ənnin-dăɣ, ăsmătăr-t d-ad-wăr ija isălan-wi-dăɣ i-ăwadəm wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Issăɣră-dd ḍarăt-a-wen əssin kăbtănăn, innʼ-asăn: «Sădwăt-dd sănatăt-timaḍ n-əssărdusa, əssayăt timərwen n-əssărdasi dăɣ-wi năynen ibəjwan d-sănatăt timaḍ dăɣ-wi ărjašnen, ăwwayăn allaɣăn, sədəwəm afăl okăynăt tisuḍəsen i-tikawt n-Qăyṣăra, ");
INSERT INTO taq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","əstəjăt i-tisnay, səssiwəḍăm-in Buləs iddar-iɣlas Filiks wa n-gəfăr.» ");
INSERT INTO taq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iktăb kumănda tăkarḍe ḍarăt-a-wen-dăɣ innă: ");
INSERT INTO taq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","A-wa năkk Kəlod Lisyas hin-ăhuulăn gəfăr Filiks-i əkneɣ semɣar. ");
INSERT INTO taq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ăhaləs-i-dăɣ săr-k-in-ăssiiglăɣ, ărmăsăn-t kăl-Ălyăhud, əttărăn ad-əjən iman-net. Ǝlmădăɣ a-s ăḍḍiin făll-Roma ɣas, ăssokăsăɣ-t-dd jer-ifassăn-năsăn s-ejhăn n-əssărdusa. ");
INSERT INTO taq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Dăɣ-derhan-in n-almud n-a-wa făl ărhăn tenăɣe-net, əssəbdădăɣ-t-dd dat-inušămăn-wi ɣattăsnen ăššăreɣa i-ad-əlmədăɣ ăddălil n-uḍlem wa t-ăsiwărăn, ");
INSERT INTO taq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","əlmădăɣ a-s a ihalăn ebre n-tijəttewen n-alămăr-năsăn ɣas, wădden a ănihăjjăn d-tamăttant wăla takărmut. ");
INSERT INTO taq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Iket hi-əjjăšăn isălan n-a-s ărhan kăl-Ălyăhud asăɣdăr-net i-ad-əjən iman-net. Dăɣ-təssəba n-a-wen-dăɣ a făl t-in-əssărmăḍăɣ săr-k, səlmədăɣ daɣ wi has-dd-əškănen a-s kăyy a ănnihăḍăn dăɣ-isălan-net. Wăssălam! ");
INSERT INTO taq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ǝjăn əssărdusa ălwăqq-wen-dăɣ a-wa hasăn-innă kumănda, əglăn d-Buləs ehăḍ-en-dăɣ har t-in-ăssawăḍăn taɣrəmt ta n-Antibatris. ");
INSERT INTO taq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ăffăw ɣas, əqqălăn əssărdusa wi ărjăšnen Yărussălam, ăssofăḍăn-in wi năynen ibəjwan Buləs s-Qăyṣăra. ");
INSERT INTO taq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ǝwwăḍăn-in ɣas, jăn tăkarḍe-tənnin-dăɣ ifassăn n-gəfăr, əssəbdădăn-dd daɣ Buləs data-s. ");
INSERT INTO taq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Iɣra gəfăr tăkarḍe təzzar, issəstăn d-teje ta lăt Buləs. Ilmăd a-s Silisi a t-lăt ɣas, innʼ-as: ");
INSERT INTO taq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Ad-kăy-dd-săɣrăɣ afăl dd-əwwăḍăn ăddinăt wi hak-dd-əškănen.» Omăr ḍarăt-a-wen i-əssărdusa i-ad-t-əjən dăɣ-ehăn s-ătiwăjja ənniyăt, dăɣ-ehăn n-təmmənukəla wa ăsdăy ămănokal Harudəs. ");
INSERT INTO taq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Səmmos išilan ḍarăt-a-wen, osă-dd Ănanyas wa n-ămănokal n-kăl-tikutawen ifal-dd Yărussălam, ăddeew d-hărăt dăɣ-inušămăn d-ănabdid s-isəm-net Tartăloš. Osăn-dd ɣas, əškăn i-Buləs s-gəfăr. ");
INSERT INTO taq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ătwăɣră-dd Buləs. Diha-dăɣ dd-osa, ad-săr-s ăšonăj Tărtăloš, ad-t-isawar uḍlem, ijanna: ");
INSERT INTO taq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","«Ămănokal-nănăɣ Filiks, nămmoy-ak ălxal wa ăhusken d-ălɣafyăt wa s-tăzozăɣăd ăkall-nănăɣ, a-wen, wăr t-illa ăwadəm s-wădden issan săr-s. ");
INSERT INTO taq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ămăra, wăr nărha asɣəf-năk s-măjrăd ăjjen, ărheeɣ dăɣ-k dăɣ-milɣaw-năk, ad-hanăɣ-təkfəd ăssaɣăt ənḍărrăn n-măjrăd. ");
INSERT INTO taq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ăhaləs-i-dăɣ n-ăgg-ăḍḍărora, edăgg osa-dăɣ, ad-dăɣ-s isəffəlləg kăl-Ălyăhud, ittăr ašənnəməšri-năsăn, ămoos iyyăn dăɣ-imizărăn n-taggayt ta təglăt făll-tidət n-iman-net s-itawănna ta n-kăl-Năṣirăt. ");
INSERT INTO taq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Dăɣ-təmɣăre n-anməšri-i-dăɣ ija, ittăr făw ad-isəmmăḍəs ehăn n-ămudd wa măqqărăn. Năstărmăs-t s-a-wa innă alămăr-nănăɣ  ");
INSERT INTO taq_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","măšan, ohăɣ-t dăɣ-năɣ Kumănda Lisyas s-ăṣṣahăt. ");
INSERT INTO taq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Tăddobed kăyy iman-năk ad-t-səstənnăd d-uḍlem wa t-năswăr ed ənta iman-net, illʼ-e diha.» ");
INSERT INTO taq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ohărăn kăl-Ălyăhud wi iyyăḍnen iket-năsăn iyyăn n-emm, ad-jannen isălan-den-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ăstafăy gəfăr ḍarăt-a-wen i-Buləs, innʼ-as ad-ămmăjrăd. Iḍkăl Buləs măjrăd, innă: «Ǝssanăɣ ămănokal-in a-s kăyy ăru tămoosăd ăgg-ăššăreɣa i-kăl-ăkall-i-dăɣ, a-wen-dăɣ daɣ a făl əflasăɣ a-s ad-hi-təkkəsăd tekăriḍt. ");
INSERT INTO taq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","A ilan măraw išilan d-əssin dd-əjjăšăɣ Yărussălam i-ad-dăɣ-s ăɣbədăɣ Măssinăɣ, tăddoobed kăyy iman-năk ad-səbbuyənăd isălan-win-dăɣ, ");
INSERT INTO taq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","wăr t-illa ere hi-inhayăn əntajăɣ tamətte, wăla ămiiɣănnanăɣ d-ăwadəm dăɣ-ehăn n-ămudd wa măqqărăn, wăla dăɣ-ihănan n-ăddin wi n-kăl-Ălyăhud, wăla dăɣ-aɣrəm, ");
INSERT INTO taq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","wăr t-illa daɣ dăɣ-ăddinăt wi-hi-sawarnen uḍlem data-k-i ăddooben asətbat n-a-wen ed, wăr len tijuhawen. ");
INSERT INTO taq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Hakd a-wen-dăɣ, hărăt iyyăn, ădduuttăt, janneɣ-t daɣ data-k: năkk, Măssinăɣ wa n-abbatăn-nănăɣ a-s əlkamăɣ s-əmmək wa s-tăn-innă alămăr d-əlkəttabăn n-ănnăbităn. A-wen-dăɣ a-s jannen əntăneḍ taggayt təglat făll-tidət n-iman-net. ");
INSERT INTO taq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Măssinăɣ a dăɣ-jarăɣ ăṭṭăma, jarăn-t dăɣ-s əntăneḍ-dăɣ n-a-s təlkam tanăkra n-inəmmuttan, jer-wi olăɣnen, wăla wi lăbasnen. ");
INSERT INTO taq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Təssəba n-a-wen-dăɣ a făl tattărăɣ, ad-wăr-itəmmil a dăɣ-əššakăɣ iman-in, dat-Măssinăɣ wăla dat-dăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","A ilan iwətyan d-əzjărăɣ ăkall-i-dăɣ, a-s t-dd-ăqqălăɣ, ăwwayăɣ takute n-aẓrəf tămoosăt tadhəlt i-imumənăn n-ăkall-in, ăwwayăɣ daɣ năkk a-wa s-ărheɣ ad t-əkətăɣ i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ašăl wa d-əssəmdăɣ a-wa iktăbăn dăɣ-alămăr dăɣ-isălan n-təšədje-nin, əbdadăɣ dăɣ-ammas n-ehăn n-ămudd wa măqqărăn, wăr ɣur-i t-təlla tamətte wăla tamdərwayt wălʼ-iyyăt. Ǝbdadăɣ dihen-dăɣ a-s făll-i toḍa tamətte. ");
INSERT INTO taq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","A-wa wăr-ihʼ ăššăk ənta da: kăl-Ălyăhud wi dd-fălnen Azya a făll-i oḍănen, a-wen-dăɣ a făl ăniihăjja daɣ a-s kunta illʼ-e uḍlem hi-iwarăn, əntăneḍ-en-dăɣ a lanen s-ad-hi-səwrən uḍlem data-k i-ad-səddəttun a-wa făll-i itawănnen. ");
INSERT INTO taq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kunta a-wen, wăr-ija, adiš, lăɣătnet meddən-wi əbdădnen diha uḍlem wa hi-iwarăn a-s dd-əbdădăɣ dat-kăl-Sinhidrin-wi ɣattăsnen ăššăreɣa. ");
INSERT INTO taq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Wăr t-illa uḍlem hi-iwarăn săl wa n-a-s ənneɣ: təlkam tanăkra jer-inəmmuttan, tənna daɣ n-a-wen-dăɣ a făl əbdadăɣ data-k ašăl-i-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ăsfăl Filiks ăddinăt iman-net ḍarăt-a-wen ed issan a ăjjeen făll-taggayt-ta-dăɣ təglăt făll-tidət n-iman-net, innʼ-asăn: «Afăl dd-osa Lisyas wa n-ămănokal n-əssărdusa, ad-kăwăn-dd-săɣrăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Omăr ḍarăt-a-wen i-kăbtăn iyyăn i-ad-ăj ənniyăt i-Buləs măšan, ăkfet-t turhajăt n-ad-t-dd-tisən ăddinăt-net, tassănăn dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hărăt n-išilan ḍarăt-a-wen, iqqăl-dd Filiks ăddeew d-Dərusil ta n-hănne-s lăn kăl-Ălyăhud. Issăɣră-dd Buləs, ăsjăd i-isălan-wi ităjj făll-immun s-ƔisaĂlmasex. ");
INSERT INTO taq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Itajjʼ-as Buləs isălan har dd-iwwăḍ edăgg-wa dăɣ-has-ijanna əmmək wa s-ila ăgg-adəm ad-săr-s iddăr dat-Măssinăɣ, ijrəw ălɣafyăt, isədəw i-ăššăreɣa wa dd-imalăn, ănnăhăḍ dăɣ-iman-net ɣas, irmăɣ Filiks, innă i-Buləs: «Ǝgləw ămăra, afăl săr-k əjrăwăɣ, ad-kăy-dd-aləsăɣ asăɣăr.» ");
INSERT INTO taq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","E-d ăhoj a dd-isăɣăr Buləs, isəddəwənnət-t, dăɣ-a-s, ijar ăṭṭăma n-ad-t-ăkf Buləs a ila aẓrəf. ");
INSERT INTO taq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ija a-wen-dăɣ har okăyăn əssin iwətyan, izjăr Filiks Təmmənəya, ijjăš Bursəs Fistus edăgg-net. Ăssof ənta, ad-iṭṭəf Buləs dăɣ-takărmut i-ad-iẓəjrəẓ iman-net i-kăl-Ălyăhud. ");
INSERT INTO taq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Kăraḍ išilan ḍarăt a-s iḍkal Fistus tanăya, ifăl-dd Qăyṣăra, teje ta făll-ixkăm, ikkă Yărussălam. ");
INSERT INTO taq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ǝškăn-dd săr-s imănokalăn n-kăl-tikutawen d-imizărăn n-Ălyăhud dăɣ-isălan n-Buləs, ");
INSERT INTO taq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","laqqădăn-t d-ad-hasăn-dd-isəwwəyy Buləs i-ad-t-əšrăɣăn dăɣ-Yărussălam, jannen a-wen, a-s ija a-wen, ăru d-əjăn ăddăbara n-ad-t-săɣdărăn dăɣ-tabarăt, ănɣən-t kərəf. ");
INSERT INTO taq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Innʼ-asăn Fistus: «Buləs iha takărmut dăɣ-Qăyṣăra, ḍarăt-a-wen daɣ, năkk iman-in, əkkeɣ Yărussălam dăɣ-išilan-i-dăɣ, ");
INSERT INTO taq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","idawnet dăr-i iyyăḍ dăɣ-wăn təflasăm i-ad-əbdədăn fălla-wăn, umasăn tijuhawen-năwăn dăɣ-isălan n-ăhaləs-wa-dăɣ sawarăn uḍlem.» ");
INSERT INTO taq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ikkă Fistus Yărussălam, ija dăɣ-s a t-illan jer-əttam təkkəd măraw išilan təzzar, iqqăl-dd Qăyṣăra. Ašăl wa ilkămăn i-wa n-uɣəl-net, issăɣră-dd Buləs s-edăgg wa dăɣ-iɣattăs ăššăreɣa. ");
INSERT INTO taq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ijjăš-dd Buləs ehăn-en ɣas, ăɣlăyɣălăyăn-t-dd kăl-Ălyăhud wi-dd fălnen Yărussălam, ad-t-sawarăn bahutăn d-uḍlemăn s-wăr t-illa ere ăddoben asəddəttu-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Iḍkăl Buləs măjrăd i-ad-ihəl iman-net, isəbbuggət a-wa fălla-s itawănnen, inna: «Wăr t-illa uḍlem hi-iwarăn, wăr t-illa a lăbasăn ăɣšadăɣ wăla ənneɣ făll-alămăr n-kăl-Ălyăhud, wăla făll-ehăn n-ămudd wa măqqărăn, wăla făll-Qăyṣăr-i n-ămănokal wa măqqărăn.» ");
INSERT INTO taq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Innă Fistus ălwăqq-wen i-Buləs i-ad-ijrăẓ i-kăl-Ălyăhud: «Ak tărḍed s-ad-təkkəd Yărussălam i-ad-kăy dăɣ-s əšrăɣăɣ meɣ?» ");
INSERT INTO taq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Innʼ-as Buləs: «Năkk, ămăra, Qăyṣăr-i n-ămănokal wa măqqărăn ihăn Roma, ənta a-s ărheɣ tebădde data-s i-ad-hi-išrăɣ. Kăl-Ălyăhud-i săr-k dd-əškănen, wăr t-illa a hasăn-ăɣšadăɣ, a-wen, kăyy iman-năk, hannăyăd-t. ");
INSERT INTO taq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kunta illʼ-e a ăɣšadăɣ wăla a jeɣ lăbasăn, ărḍeeɣ s-tamăttant măšan, kunta a wa făll-i itawănnen bahu, adiš, wăr-əleɣ s-ad-ətwəjjăɣ jer-ifassăn-năsăn. Ămăra, šămad tanfust-da-dăɣ, ăɣreɣ Qăyṣăr wa n-ămănokal măqqărăn.» ");
INSERT INTO taq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ănmănhăy Fistus d-inušămăn wi ɣattăsnen ăššăreɣa təzzar, innă i-Buləs: «Šămad kăyy iman-năk a iɣrăn ămănokal wa măqqărăn, adiš, ad-hak-sukăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hărăt n-išilan ḍarăt-a-wen-dăɣ, osă-dd ămănokal iyyăn s-isəm-net Ăgribba ăddeew d-wălătma-s s-isəm-net Berenis, jan-dd tăbošăjt s-Fistus dăɣ-Qăyṣăra. ");
INSERT INTO taq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Jăn išilan dihen ɣas, iḍkăl-asăn-dd Fistus isălan n-Buləs, innʼ-asăn: «Illʼ-e diha ăhaləs dd-oyya Filiks dăɣ-takărmut, ");
INSERT INTO taq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","əškăn-dd săr-i fălla-s imănokalăn n-kăl-tikutawen d-inušămăn n-kăl-Ălyăhud, əttărăn dăɣ-i ad-t-siḍəwăɣ dăɣ-ăššăreɣa ");
INSERT INTO taq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","măšan, əllăɣeɣ-asăn a-s ălqanun-nănăɣ năkkăneḍ-i n-kăl-Roma, wăr hanăɣ-ijrew ad-nəsiḍəw ăwadəm dăɣ-ăššăreɣa ar s-ad-t-dd-năssibdăd dat-ăššăreɣa təzzar, nəlməd kunta a-wa fălla-s itawănnen tidət meɣ. ");
INSERT INTO taq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Osăn-ahi-dd dăɣ-Qăyṣăra ɣas, əssăɣrăɣ-asăn-dd năkk iman-in ăhaləs wa s-săr-i dd-əškăn. ");
INSERT INTO taq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ăɣelăɣ dăɣ-a-wa fălla-s jannen, iɣšad a măqqoorăn măšan, oseɣ-t wăr-ija a-wen ");
INSERT INTO taq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ed, isălan n-ăddin-năsăn d-isălan əkkanen ăhaləs iyyăn ămmun s-isəm-net Ɣisa, s-orda ənta a-s inkăr-dd jer-inəmmuttan, ənta-den-dăɣ a-wa ikkăn jere-săn, ");
INSERT INTO taq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","wăr-əssenăɣ a has-e-ăjăɣ, əttărăɣ dăɣ-s ad-ăkk Yărussălam i-ad-dăɣ-s itwəšrăɣ ed, năkk iman-in, wăr hənnəyăɣ uḍlem t-ăswărăɣ ");
INSERT INTO taq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","măšan, ăssof teɣăre n-Qăyṣăr wa n-ămănokal măqqărăn ed, ijraw-as ălqanun-nănăɣ a-wen.» ");
INSERT INTO taq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Iggăd-dd Ăgribba ălwăqq-wen, inna i-Fistus: «Ăhaləs-wa-dăɣ, săslʼ-ahi-has năkk-dăɣ.» Innʼ-as Fistus: «Ašəkka, ad-t-dd-səbdədăɣ data-k, təsləd-as.» ");
INSERT INTO taq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ăffăw ɣas, ăssahăɣ-dd Ăgribba ašăl s-ălxal wa n-imănokalăn ənta d-Berenis ta n-wălătma-s, əjjăšăn ehăn wa n-ăššăreɣa ăddewăn d-kumănda d-inušămăn n-aɣrəm. Issăɣră-dd Fistus Buləs, ittəlwăy-dd. ");
INSERT INTO taq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Imməjrăd Fistus, innă: «Ămănokal Ăgribba, kăwăneḍ-i dd-əžžəmmăɣnen diha-dăɣ ašăl-i, ăhaləs-i-dăɣ hannăyăm, wăr t-illa dăɣ-Yărussălam hakd diha-dăɣ, ere s-wădden innă, ăbas ănihăjja d-tămudre. ");
INSERT INTO taq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Dăɣ-a-wa hi-dd-iqqălăn năkk, wăr t-illa uḍlem fălla-s əjrawăɣ t-ăsinăhăjjăn d-tamăttant măšan, šămad ənta iman-net a ăsnăfrănăn ad-t-išrăɣ ămănokal wa măqqărăn, adiš ad-has-t-sukaɣ i-ad-t-išrăɣ. ");
INSERT INTO taq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Hakd a-wen-dăɣ, wăr-ărheɣ, ad-has-t-sukaɣ ar s-ad-t-ăsidăwăɣ d-tăkarḍe dăɣ-iktab uḍlem wa t-iwarăn. Təssəba n-a-wen-dăɣ a făl ăssofăɣ ad-t-dd-səbdədăɣ data-k i-ad-hi-təkfəd tayətte n-a-wa mad-əktəbăɣ dăɣ-tăkarḍe i-ămănokal wa măqqărăn ḍarăt isəstanăn wi t-mad-ăjăɣ ");
INSERT INTO taq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ed, wăr-ilʼ əmmək n-ad-sukaɣ ămănokal u-takărmut s-wăr-ătwăssăn a-wa iɣšăd.» ");
INSERT INTO taq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Iḍkăl Ăgribba măjrăd, inna i-Buləs: «Măjrăd! Ǝkkəs uḍlem făll-iman-năk.» Iḍkăl Buləs ăfuss-net i-ad-has-səjəd tamətte, innă: ");
INSERT INTO taq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ămănokal Ăgribba, ămoos-ahi a măqqorăn turhajăt n-măjrăd wa hi-təkfed ašăl-i-dăɣ i-ad-əkkəsăɣ făll-i uḍlem wa hi-ăswărăn kăl-Ălyăhud wi hi-dd-əškănen săr-wăn. ");
INSERT INTO taq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ǝssanăɣ a-s wăr t-illa a hak-idrajăn dăɣ-ălɣadatăn-năsăn, wăla dăɣ-tijəttewen n-ăddin-năsăn, a-wen-dăɣ a făl əttarăɣ dăɣ-k taẓidert n-ad-hi-səjədəd. ");
INSERT INTO taq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Năkk, wăr t-illa ăgg-ăkall-i-dăɣ wărăn issen a-s təmmăḍrit-in iket-net, jeɣ-tăt jer-kăl-tumast-in dăɣ-Yărussălam-i-dăɣ ədwălăɣ. ");
INSERT INTO taq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ăru əzzayăn-ahi, əssanăn daɣ a-wa ămoosăɣ kunta ăbokăn i-a-wen, tămudre-nin iket-net, əjeɣ-tăt dăɣ-alkum i-a-wa saɣra taggayt ta n-kăl-faris, wăr t-təlla taggayt tăt-tojărăt isəm, wăla ălɣădalăt dăɣ-ăddin-nănăɣ. ");
INSERT INTO taq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ašăl-i, əbdadăɣ dat-ăššăreɣa făl təssəba n-ăṭṭăma wa jărăɣ dăɣ-ărkăwăl-wa ijjăš Măssinăɣ i-abbatăn-nănăɣ wi n-ibda, ");
INSERT INTO taq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ăṭṭăma-en-dăɣ, a-s ăqqalnăt tiwsaten-nănăɣ ti n-mărawăt d-sănatăt n-Iṣrayil ed, a-wen-dăɣ a săr-snăt dd-orăwăn ălɣibadăt n-Măssinăɣ ehăḍ d-ašăl. Ămănokal-in, wăr t-illa uḍlem hi-ăsiwărăn kăl-Ălyăhud wi hi-dd-əškănen săl wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ak ajăn ămoos-awăn tăkunt a-wa s-ilkam ad-dd-isənkăr Măssinăɣ inəmmuttan? ");
INSERT INTO taq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Dăɣ-a-wa hi-dd-iqqălăn năkk, wăr t-illa a-wa-dăɣ wăr-əjeɣ i-ad-hin-aləmăɣ s-iyyăt isəm wa n-Ɣisa wa n-Năṣirăt. ");
INSERT INTO taq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","A-wen, jeɣ-t dăɣ-aɣrəm wa n-Yărussălam-i dăɣ-hi-əjrăwăn imănokalăn n-kăl-tikutawen asəttărməs n-e d t-illăm ere ilkamăn i-Ɣisa Ălmasex, ăjăɣ-t dăɣ-takărmut. Afăl ənhăyăɣ i dăɣ-săn ăniihăjjăn d-tamăttant, ifassăn-in a-s tajjăɣ iman-net. ");
INSERT INTO taq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ǝkkeɣ jer-ihănan n-ăddin wi n-kăl-Ălyăhud i-ad-tăn-săknăɣ dăɣ-săn aɣăna, šahăššalăɣ-tăn s-asəkkufăr, dăɣ-təmɣăre n-aḍkăr-năsăn wa hi-ihăn, ăhoreɣ-tăn har ikallăn wi iyyăḍnen dăɣ-əzzaɣăn. ");
INSERT INTO taq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Dăɣ-isălan n-a-wen-dăɣ a făl əkkeɣ Dămašăq, ăwwayăɣ tikarḍiwen hi-əkfăn imănokalăn n-kăl-tikutawen, hi-əjrawnen tădabit n-a-wa s-ărheɣ iji-net. ");
INSERT INTO taq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ămănokal-in, əgleɣ dăɣ-a-wen-dăɣ a-s hin-ohăẓăɣ Dămašăq s-ammas n-tarăhut, wăla a hin-əjrăhăɣ năkk d-imidiwăn-in a-s ənhăyăɣ ănnur dd-ifalăn išənnawăn ojărăn tăfukt amləwləw. ");
INSERT INTO taq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nəhă-dd noḍa iket-dăɣ-nănăɣ, əsleɣ dihen i-emăsli hi-innăn dăɣ-Ɣăbranəyya: ‹Sawəl, Sawəl! Ma kăy-orămăn săr-i, tiɣəzzəbud-ahi? Ad-hak-indăr amẓəẓẓaj dăr-i hărkuk.› ");
INSERT INTO taq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ǝnneɣ-as: ‹Emăli, mi tămoosăd?› Innʼ-ahi Emăli: ‹Năkk a-wa Ɣisa wa tiɣəzzəbud. ");
INSERT INTO taq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ămăra, əbdəd făll-iman-năk, ănfalălăɣ-ak-dd i-ad-tumasăd ănămmašul-in, tumasăd daɣ tajuhe-nin dăɣ-a-wa tənhăyăd ašăl-i-dăɣ d-a-wa hak dd-madăn-infiləl ḍarăt a-wa, ");
INSERT INTO taq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ad-kăy-dd-ăɣləsăɣ dăɣ-kăl-Ălyăhud d-inəẓẓulam šəmmišəlăɣ-kăy săr-săn, ");
INSERT INTO taq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","i-ad-tarəd tiṭṭawen-năsăn, əzjărăn-dd tihay s-ănnur, əzjărăn-dd tărna n-Iblis s-Măssinăɣ, amənăn săr-i i-ad-tăn-ăkfăɣ tenăšše n-ibăkkaḍăn i-ad-ahərən tăkasit d-iməššeddəjăn wi iyyăḍnen.› ");
INSERT INTO taq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ămănokal-in Ăgribba, wăr-ətterăɣ anməšri i-a-wa hi-dd-ănfalălăn dd-ifălăn išənnawăn ed, Măssinăɣ ad-dd-ifal. ");
INSERT INTO taq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ǝmməjrădăɣ s-tizarăt i-kăl-Dămašăq d-kăl-Yărussălam təzzar, okăyăɣ s-Ălyăhudəyăt d-iɣărman wi iyyăḍnen hăn inəẓẓulam, xaṭṭăbăɣ-asăn iket-dăɣ-năsăn isălan n-a-s lan s-ad-utabăn, əjən tămudre tăddewăt d-imărkedăn olaɣnen ăssiitbătnen tiynəya ta dd-təšrăyăt fălla-săn. ");
INSERT INTO taq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Təssəba n-a-wen dăɣ, a făl făll-i oḍăn kăl-Ălyăhud dăɣ-ammas n-ehăn n-ămudd wa măqqărăn, əttărăn tenăɣe-nin ");
INSERT INTO taq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","măšan, idhăl-ahi Măssinăɣ, ikkăs-ahi-dd dăɣ-ifassăn-năsăn i-ad-udabeɣ tebădde, ăjjayhăɣ făll-isălan-net har ašăl-i-dăɣ i-wi lănen isəm hakd wi t-wăren əla. A-wa jănneɣ daɣ ašăl-i-dăɣ, wăr-ămoos a ăynayăn, ăru dăɣ-s ăssewălăn ănnăbităn d-Mosa-i əssətbătnen a-s əlkamăn isălan-wi-dăɣ hawăn-tajjăɣ. ");
INSERT INTO taq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","A-wen a t-ămoosăn, a-s ilkam ad-inhəy Ɣisa Ălmasex tersəmmawen təzzar, umas teɣăfădde n-ăddinăt wi dd-maden-ənkăr jer-inəmmuttan i-ad-ətwəjjən isălan n-ănnur n-əlɣəllas i-kăl-Ălyăhud hakd inəẓẓulam.» ");
INSERT INTO taq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ămmiijrăd Buləs itakkăs uḍlem făll-iman-net dihen-dăɣ a-s iḍkăl Fistus emăsli-net, innă: «Kăyy Buləs, ăbas təssanăd a jănned, təkkas dăɣ-k təmɣăre n-təlɣuləma tayətte.» ");
INSERT INTO taq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Innʼ-as Buləs: «Ămănokal-in Fistus, năkk ɣas ozja ənniyăt-in, əjrahăɣ a-wa heɣ; a-wa jănneɣ iket-net, wăr-ămoos ɣas ar tidət lat ujreh. ");
INSERT INTO taq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kăyy daɣ ămănokal-in Ăgribba, wăr hak-ədrejăn isălan-win-dăɣ, a-wen-dăɣ daɣ a făl wăr-ăksuḍăɣ măjrăd data-k, ed wăr t-illa dăɣ-isălan-wi-dăɣ a-s wădden təssanăd săr-s e-d, əkkasăɣ ăššăk a-s isălan-wi-dăɣ, wăr jen dăɣ-ufăr. ");
INSERT INTO taq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ămănokal-in Ăgribba, tomanăd s-a-wa ənnăn ănnăbităn, wădden?» ");
INSERT INTO taq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Iggăd-dd Ăgribba ălwăqq-wen s-Buləs, innʼ-as: «Kăyy, hannăyăɣ-kăy, a ənḍărrăn ɣas teɣalăd ămoosăɣ ălmăssexi.» ");
INSERT INTO taq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Innʼ-as Buləs: «Jer-a ənḍărrăn wăla a hin-illan i-ad-tumasăd a-wen, dalăɣ-ak Măssinăɣ kăyy hakd ălžămaɣăt wa hi-ăsijădăn, ad-dăr-i taləhəm hărăt iket-net, a săl tišəm-ti-dăɣ hi-hănen.» ");
INSERT INTO taq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Issəmdă Buləs măjrăd-wen-dăɣ ɣas, ibdăd ămănokal Fistus hakd Ăgribba d-Berenis, təlkăm-asăn daɣ tamətte, ");
INSERT INTO taq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","zajjărăn ăddinăt, tinmənnin: «Ăhaləs-i-dăɣ, wăr t-illa a iɣšad t-ăsinăhăjjăn d-tamăttant wăla tišəm.» ");
INSERT INTO taq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Inna Ăgribba i-Fistus ălwăqq-wen: «Ǝnnăr wădden teɣăre-i ija ăhaləs-i-dăɣ i-Qăyṣăr wa n-ămănokal măqqărăn, itwəyyʼ-in.» ");
INSERT INTO taq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tăwwăḍ-dd tăqqăn ta n-tikawt n-ăkall wa n-Iṭali ɣas, jăn kăl-əlxəkum Buləs d-kăl-takărmut wi iyyăḍnen dăɣ-ifassăn n-kăbtăn s-isəm-net Yulyus, ənta a ănnihăḍăn făll-ejhăn n-əlɣəskăr wa s-isəm-net: «Wa tăn-ojărăn». ");
INSERT INTO taq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nəjjăš turăft n-aman jat isəm Adăramit, nəkkă ăkall wa n-Azya, năddeew dăɣ-asikəl-nănăɣ d-Aristarăq wa n-Tăslonika. ");
INSERT INTO taq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ašăl wa ilkămăn i-wen, năsjăn dăɣ-teje ta n-Sidon. Ămoos kăbtăn Yulyus ăwadəm s-ikna Buləs əjjăruẓăt, iglă făw har t-ikfă turhajăt n-ad-ăkk imuzăyăn-net wi hănen aɣrəm-en i-ad-has-arəjăn dăɣ-asikəl. ");
INSERT INTO taq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nəfăl dihen, năllil asălim n-aman, nămsadăɣ i-awtəl wa n-Qəbrus i-ad-nəmjušət d-aḍu d-tinăzzămăren-ti dd-bahhălnen i-turăft. ");
INSERT INTO taq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nəjlăy ḍarăt-a-wen ejărew wa səmmăn ošălăn dăɣ-ăkall wa n-Silisi d-Banfəli, năsjăn dăɣ-taɣrəmt ta n-Mira təhăt ăkall wa n-Lisya. ");
INSERT INTO taq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ijrăw kăbtăn-nănăɣ dihen turăft n-aman təkkat Iṭali, ijʼ-anăɣ dăɣ-s. ");
INSERT INTO taq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nəjă išilan năsilalăm sollan făll-aman har šărnaš d-nănmawăḍ d-aɣrəm wa n-Kănida, igdăl-anăɣ əṣṣuhu n-aḍu ad-nakəy ɣas, nărmăs tamdujt ta n-ajus n-ăkall wa n-Kritus, nəkka dawa-s har nămsadăɣ d-Sălmuni. ");
INSERT INTO taq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Šărnaš d-năllil asălim n-ejărew har dd-năwwăḍ edăgg ijan isəm: tasjənt ta n-tihusay, a-wen edăgg, ănimahăẓăn d-taɣrəmt ta n-Lazaya. ");
INSERT INTO taq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nəja išilan s-əmmək-en-dăɣ a-s fălla-năɣ ănmăntaš ejărew, nəjjăš miši, okăy fălla-năɣ daɣ ăẓum wa n-tajrəst. ");
INSERT INTO taq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Dihen-dăɣ, ad-ăsmătăr Buləs iməssukal wi iyyăḍnen hănen turăft n-aman, innʼ-asăn: «Meddən, hannăyaɣ a-s asikəl-nănăɣ wăr-mad-ăj wăla šăɣšad d-miši; năkkăneḍ hakd a-wa ihăn turăft, nəha miši d-šăɣšad-wen-dăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Măšan ojăr tafləst ija kăbtăn a-wa has-innă u-taɣăya-net a-wa innă Buləs. ");
INSERT INTO taq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ǝnhăyăn a-s edăgg-wa-dăɣ ăsjănăn wădden edăgg dăɣ-isasakay ăwadəm tajrəst ɣas, ăssoɣălăn tisdas n-turăft, ărmăsăn tamdujt n-aɣrəm wa n-Fənikus daw-awtəl wa n-Kritus i-ad-dăɣ-s səssikəyăn tajrəst. ");
INSERT INTO taq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ǝllan-t dihen-dăɣ a-s dd-isrăj aḍu dd-ifalăn ajus, orăn-dd turăft, ărkăbăn dăɣ-a-s ăllilăn tasăja n-ejărew ed, ăɣelăn ăɣlăsăn dăɣ-ăššar-net. ");
INSERT INTO taq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","A ənḍărrăn ḍarăt-a-wen-dăɣ, toḍă-dd fălla-săn tăšikwalt tăṣṣoohet s-itawănna dăɣ-Tălyunanit: Erakilun. ");
INSERT INTO taq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Izzəwăt ăṣṣahăt-net turăft, iglă dăr-s emănăn, ăbas t-illa ere dăɣ-s ănnihăḍăn. ");
INSERT INTO taq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ija a-wen-dăɣ har nokăy afălla n-awtəl wa n-Kluda, ijʼ-anăɣ aɣrəm-en eff ɣas, nəttăr ăddăbara s-nănmawăḍ d-isăɣlas wi hănen turăft. ");
INSERT INTO taq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ǝjrăwăn meddən aḍkul n-asăɣləs wa n-ənḍărrăn ihăn turăft, ăstărăkken-t dăɣ-aman, əkrăsăn-t dăɣ-turăft s-iɣunan, nəḍkăl tisdas i-ad-tănăt-isəkəf aḍu i-ad-ăbas hanăɣ-ăzziwăt aḍu. Năšinanăj s-əmmək-wen-dăɣ har nănmawăḍ d-Libya, noyya iman-nănăɣ s-ašrut wa dăɣ-wăr šəjrətăn aman. ");
INSERT INTO taq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Okăy fălla-năɣ ašăl imdan năbbillăn d-aḍu s-əmmək-wen-dăɣ, har hanăɣ-ilzăm ašăl wa iyyăḍăn, ad-hin-nəjăr ilalăn wi hănen turăft i-ad-tifsas. ");
INSERT INTO taq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ašăl wa s-kăraḍ, jărăn-in inaxdimăn a-wa ăẓẓayăn ihăn turăft iket-net. ");
INSERT INTO taq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nəjă ăzzăman wăr nənhey tăfukt wăla etran, a ija a-wen-dăɣ, itiwwaḍ-dd fălla-năɣ ăṣṣahăt n-aḍu har ăbas hanăɣ-iha ere ijarăn ăṭṭăma n-tămudre. ");
INSERT INTO taq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Išilan-win-dăɣ, năssakăy-tăn wăr t-illa a nəkša, dăɣ-a-wen-dăɣ ad-dd-ibdăd Buləs, innă i-ăddinăt: «Imidiwăn-in, ənnăr hi-tăsijădăm ihənnin a-s hawăn-əmməjrădăɣ dăɣ-awtəl wa n-Kritus, wăr nətəjjəš miši d-šăɣšad ogdăhăn d-a-wa-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ărheeɣ fălla-wăn ămăra, ad-hi-səjdəm: sănsăt ənniyăt-năwăn, əḍmanăɣ-awăn a-s wăr t-illa i dăɣ-năɣ mad-iba măšan, turăft ənta, əkkəsăt ăṭṭăma-net. ");
INSERT INTO taq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ănfalăl-ahi-dd ănjălos n-Măssinăɣ ənḍăhaḍ, ");
INSERT INTO taq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","innʼ-ahi: Buləs, wăr tărmeɣăd ed, wăr t-illa ad-wăr təbdedăd dat-Qăyṣăr wa n-ămănokal măqqărăn. Ad kăy-iɣləs Măssinăɣ kăyy d-iməssukal wi dăr-tăddewăd. ");
INSERT INTO taq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ɣas, imidiwăn-in, kuyədăt, wăr təkkesăm ăṭṭăma, əflasăɣ a-s Măssinăɣ a-wa hi-innă, ad-ăj, ");
INSERT INTO taq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ilkam dăɣ-năɣ ad-nəsəjən făll-awtəl iyyăn.» ");
INSERT INTO taq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nəja ehăḍ-nănăɣ wa s-măraw d-əkkoẓ măšan, ăzziwăt-anăɣ aḍu hărwa făll-ejărew wa səmmăn s-itawănna Adərya, a-wen, dăɣ-ejărew wa səmmăn măqqărăn n-Miditerani. Ebre n-ammas n-ehăḍ, ofrăyăn kăl-taɣăya n-turăft a-s ohaẓăn edăgg dăɣ-wăr əknen aman əjut. ");
INSERT INTO taq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Jărăn aɣan dăɣ-aman i-ad-săr-s əkətən təššəjrət n-aman, osăn aman jan təššəjrət n-kăraḍăt timərwen n-metăr d-əssa. Ǝglăn har dihen, olăsăn daɣ ejer n-aɣan-ənnin dăɣ-aman, imăl-asăn ider n-aman ămăra, dăɣ-sănatăt timərwen n-metăr d-əttam. ");
INSERT INTO taq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ăksuḍăn kăl-taɣăya ad-tiḍəw turăft-năsăn, tənkəf i-tihun, ɣas, jărăn əkkoẓăt tiẓolyawen dăɣ-aman i-ad-əhəlnăt turăft, əqqălăn ḍarăt-a-wen i-tebădde n-ašăl. ");
INSERT INTO taq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Dăɣ-a-wen-dăɣ, ad-tattărăn kăl-taɣăya əmmək s-əjmăḍăn, ăsrăsăn dăɣ-aman asăɣləs ənḍărrăn, jăn ăsaru n-a-s ărhan ad-hin-šəššənkəšăn tiẓolyawen ti jăn dăɣ-aman i-ad-əknənăt antum, əṭṭəfnăt turăft. ");
INSERT INTO taq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ilmăd Buləs făll-amsud-năsăn ɣas, innă i-kăbtăn d-əssărdusa: «Ănn i-meddən-năk, afăl wăr-ăqqimăn meddən-wi-dăɣ dăɣ-turăft, adiš, əkkəsnet ăṭṭăma n-tămudre.» ");
INSERT INTO taq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ăɣtăsăn əssărdusa ḍarăt-a-wen iɣunan n-asăɣləs wa ənḍărrăn, oyyăn-t iglă, ăwwăyăn-t aman. ");
INSERT INTO taq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","A ənḍărrăn dat-ăbaqqu n-tifawt, ăsmătăr Buləs imidiwăn-net i-ad-əkšən hărăt făl-a-s lan a iwwăḍăn măraw išilan d-əkkoẓ wăr t-illa a ikkan imawăn-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Innʼ-asăn Buləs: «Ǝnfəwăt iman-năwăn s-hărăt iyyăn, əfləsăt a-s wăr t-illa dăɣ-wăn-i s-mad-hin-iba wăla-dăɣ emẓăd iyyăn ɣas dăɣ-eɣăf-net.» ");
INSERT INTO taq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Innʼ-asăn Buləs a-wen-dăɣ ɣas, iḍkăl-dd tijəlwen, ămmoy i-Măssinăɣ dat-ăddinăt wi hanen turăft, ăẓun-tănăt ḍarăt-a-wen, ad-itatt. ");
INSERT INTO taq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tokăy-tăn tarəmmeɣt, ad-tattăn əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Dăɣ-turăft-en-dăɣ, năwwăḍ sănatăt timaḍ n-ăhaləs d-əssayăt timərwen d-săḍis. ");
INSERT INTO taq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ălwăqq wa d-əyyəwănăn ăddinăt, əssănɣălăn-in ălkăma dăɣ-ejărew i-ad-səfsəsăn turăft. ");
INSERT INTO taq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ja tifawt, əšlămăn dăɣ-ijəj taɣmărt dăɣ-ijjət ăkall măšan wăr-əssenăn ma ămoos ăkall-wen-dăɣ. Ǝnnăn ad-săr-s ənnăḍăn turăft, səjnən-tăt dihen-dăɣ kunta ămmukkăn a-wen. ");
INSERT INTO taq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ǝkkăsăn isăssărăn wi iṭṭăfnen turăft, oyyăn-tăn-in s-aman, orăn iɣunan wi n-taɣăya sasaɣadnen turăft, jăn tisdas i-aḍu s-data n-turăft i-ad-tăn-in-imhəl aḍu s-edăgg wa ăqqurăn əšlămăn. ");
INSERT INTO taq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Diha-dăɣ d-əkkăn s-data a ənḍărrăn ad-oḍăn făll-hărăt n-tejeft, təntăm-asăn turăft dăɣ-ăkall. Ittəytăy ăkumkum-net dăɣ-ăkall hundăɣ har ăbas timtəkwəy, irẓă-dd daɣ ajilal-net făll-ăṣṣahăt wa ija anməntaš n-ejărew wa səmmăn. ");
INSERT INTO taq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ǝnhăyăn əssărdusa a-wen ɣas, ănmănnakăn i-ad-əjən iman n-kăl-takărmut i-udaɣ ad-ijmăḍ wălʼ iyyăn dăɣ-eššaf, ");
INSERT INTO taq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","măšan unjăy-asăn kăbtăn s-a-wen făl tărha-i ija i-Buləs. Dihen-dăɣ ad-innă kăbtăn i-ăddinăt wi əssănnen eššaf, ad-əyyən iman-năsăn s-tizarăt s-aman, əšyəfăn s-asălim. ");
INSERT INTO taq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Innă i-wi iyyăḍnen, ad-əjən ăddăbara făl năyăn iferəsăn n-tisəjwen n-turăft wi dd-irẓa aḍu. Ǝmmək-wen-dăɣ a-s hin-əwwăḍăn iket-dăɣ-năsăn asălim n-aman, əddarăn-ăɣlasăn. ");
INSERT INTO taq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Năɣlăs-dd dăɣ-a-wen-dăɣ iket-dăɣ-nănăɣ, nəzjăr-dd aman ɣas, nəslă a-s awtəl wa dăɣ-năsjăn, isəm-net Malta. ");
INSERT INTO taq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ăsmăjaren-anăɣ kăl-awtəl-en, əssărɣăn-anăɣ efew, nəzzăh săr-s iket-nănăɣ ed, iwat ajənna, ija esămeḍ. ");
INSERT INTO taq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ikkəmăt-dd Buləs isuksukăn s-ăshăjăljăl efew măšan, tăkwăttăt-t taššălt dd-təstaɣ tukəse n-efew, tărmăm dăɣ-ăfuss-net. ");
INSERT INTO taq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ǝnhăyăn kăl-awtəl a-wen ɣas, ad-tinmənnin: «Ăhaləs-i-dăɣ, wăr t-ihʼ ăššăk a-s emăjj n-iman, ənta da-dăɣ s-iket dd-iɣlăs dăɣ-aman măšan, ilkăm-as-dd əlɣədăr n-a-wa iɣšăd i-Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Irsăy-in Buləs taššălt ḍarăt-a-wen făll-iman-net, ănnunnăẓăt-tăt dăɣ-efew, wăr t-illa a has-tăɣšad. ");
INSERT INTO taq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ija a-wen ɣas, ăsbălalăɣăn kăl-awtəl dăɣ-Buləs, ija ɣur-săn a-s a ənḍărrăn ɣas a has-in-ăqqimăn ihḍəḍi, meɣ ămmut ălwăqq-wen-dăɣ. Ăhojăn wăr t-illa a ijan dăɣ torda-năsăn ɣas, əqqălăn s-a-wa ənnăn, ad-jannen ămăra: «A-wa, hărăt dăɣ-imălan wi n-išənnawăn.» ");
INSERT INTO taq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Edăgg-en, ohaẓăn-t išəkraš n-ămănokal n-awtəl s-isəm-net Bubləs. Islʼ-anăɣ ɣas, ăsmăjarăt-anăɣ s-ehăn-net, năssakăy ɣur-s kăraḍ išilan. ");
INSERT INTO taq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nəllʼ-e dihen-dăɣ a-s tărmăs tenăde tăddewăt d-tanănăɣat abba n-ămănokal. Osʼ-e Buləs, ăswăr-t ifassăn-net, ittăr-as dăɣ-Măssinăɣ, izzăy. ");
INSERT INTO taq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ăwwăyăn-dd kăl-ăkall ḍarăt-a-wen imarhinăn-năsăn, ăzozăy-tăn Buləs əntăneḍ-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ǝssəmɣărăn-anăɣ kăl-awtəl en-dăɣ făl təssəba n-a-wen-dăɣ. Năssawăḍ tekle ɣas, jăn-anăɣ ăzzad igdăhăn i-a-wa hanăɣ-in-ăqqimăn dăɣ-asikəl. ");
INSERT INTO taq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Šămad fălla-năɣ okayăn kăraḍ orăn n-asikəl, ad-nəjrăw turăft n-aman tăṣṣiwwărăt idmawăn d-ismawăn n-imălan n-eknewăn wi s-itawănna: Kăstur d-Bolăkəs dd-falăt Iskăndərya, nəjjăš-tăt, tăssakăy dăr-năɣ tajrəst dăɣ-awtəl-wen-dăɣ. ");
INSERT INTO taq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nəfăl dihen, năsjăn kăraḍ išilan dăɣ-Sirakuz, ");
INSERT INTO taq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","təzzar năllil asălim n-aman har Rajyo. Ašăl wa ilkămăn i-wen, inkăr-dd fălla-năɣ aḍu dd-ifalăn ajus, izzəwăt-anăɣ emănăn har năsjăn dăɣ-Băzula. ");
INSERT INTO taq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nəjrăw dihen hărăt dăɣ-ayətma-năɣ dăɣ-ăddin, ăsmăjaren-anăɣ; năssakăy ɣur-săn əssəboɣ imdan. Ɣur-săn en-dăɣ, ad-nărmăs tamdujt ta n-Roma. ");
INSERT INTO taq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ǝslăn-anăɣ hărăt dăɣ-ălmăssexităn n-Roma ɣas, əlkăḍăn-anăɣ-dd s-ăssuk n-aɣrəm wa n-Abyud, əssəlkăḍăn-anăɣ-dd daɣ iyyăḍ s-ăssuk wa n-aɣrəm wa n-kăraḍăt tihənzubba. Inhăy-tăn Buləs ɣas, irăš i-Măssinăɣ, ikfʼ-e a-wen-dăɣ ăṭṭăma d-ăṣṣahăt ăynayăn. ");
INSERT INTO taq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Năwwăḍ-in Roma ɣas, irḍa əlxəkum i-Buləs s-ad-ifăr ehăn n-iman-net, izzăɣ dăɣ-s ənta d-əssărdasi wa has-ijăn ənniyăt. ");
INSERT INTO taq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kăraḍ išilan ḍarăt-a-wen, issăɣră-dd Buləs inušămăn n-kăl-Ălyăhud wi əzzăɣnen Roma. Ǝžžəmmăɣăn-dd săr-s ɣas, innʼ-asăn: «Ayətma-ɣ, wăr t-illa a ăɣšadăɣ s-ănimăšrăyăɣ i-tumast-nănăɣ, wăla i-ălɣadatăn-nănăɣ. Aɣrəm wa n-Yărussălam a dăɣ-dd-əttărmăsăɣ, əjjăšăɣ dăɣ-s takărmut, ătwăjjăɣ jer-ifassăn n-kăl-Roma, ");
INSERT INTO taq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","əttărăn əntăneḍ almud n-a-wa ăɣšădăɣ ḍarăt a-s hi-ăsimăjrădăn măšan, wăr t-illa ăḍḍărora făll-i əjrawăn hi-ăsinăhăjjăn d-tamăttant, əttărăn făw ad-hin-səwwəyyən măšan, ");
INSERT INTO taq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ənkărăn-dd kăl-Ălyăhud dihen făll-i, unjăyăn ărḍăn a-wa hi-ăɣtăsăn kăl-Roma. Ǝnhăyăɣ a-s wăr t-illa a ărhan săl tamăttant-in ɣas, tămoos-ahi teɣăre n-Qăyṣăr wa n-ămănokal măqqărăn ihăn Roma tăhaššilt. Măšan, hakd a-wen-dăɣ, wăr-iha ənniyăt-in n-ad-săwrăɣ tumast-in uḍlem wălʼ iyyăn. ");
INSERT INTO taq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","A-wa-dăɣ a făl ăsdărhănăɣ ahănay-năwăn, səfhəmăɣ-kăwăn a-s tišəm-ti-heɣ, wăr tănăt-dd-orew săr-i a săl ăṭṭăma wa ohărăɣ d-kăl-Iṣrayil iket-năsăn.» ");
INSERT INTO taq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Innʼ-as ălžămaɣăt wa săr-s dd-ăddewăn: «Dăɣ-a-wa hanăɣ-dd-iqqălăn năkkăneḍ, wăr t-təlla tăkarḍe hanăɣ-dd-tosat dd-falăt Ălyăhudəyăt hanăɣ-təjat isălan-năk, wăr t-illa daɣ ere nənhay dăɣ-ayətma-năɣ dd-ifalăn dihen hanăɣ-kăy-omalăn wăla i hanăɣ-kăy-oẓamăn. ");
INSERT INTO taq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ămăra, năssof, ad-hak-nəsəll năkkăneḍ iman-nănăɣ ed taggayt ta hed təglăt făll-tidət n-iman-net, nəssan a-s wăr t-illa edăgg s-wădden ăššunjen-tăt dăɣ-s ăddinăt.» ");
INSERT INTO taq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ohărăn dăr-s ḍarăt-a-wen ašăl dăɣ-t-dd-mad-ăqqəlăn ăddewăn d-ăddinăt ojărnen wi dd-osănen ăsihe-wa. Osăn-dd ašăl-en, imməjrăd-asăn wa-dăɣ n-tifawt har toḍa tăfukt, itafăssar-asăn tijəttewen n-a-wa isaɣra, ixaṭṭăb-asăn isălan n-Təmmənəya n-Măssinăɣ d-a-wa innă alămăr wa n-Mosa d-ănnăbităn wi iyyăḍnen, isafham-tăn daɣ a-wa ənnăn făll-ƔisaĂlmasex. ");
INSERT INTO taq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Issətbăt ašrut iyyăn dăɣ-săn tənna-net, ăsɣăr-as ašrut wa iyyăḍăn ulh-net, unjăyăn omănăn s-măjrăd n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","A-s t-fălăn ăddinăt, ăẓunăn dăɣ-a-wa ordăn făll-Ɣisa Ălmasex. Inhăy Buləs tăẓune ta jăn ɣas, innʼ-asăn: «Ijmaḍ-t ăššăk a-s tidət a-wa innă Unfas Šăddijăn i-imărawăn-nănăɣ s-emm n-ănnăbi Saya a-s t-ăšmašăl Măssinăɣ. Ăzzăman-en, innʼ-as: ");
INSERT INTO taq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Ǝgləw, ăkk ăddinăt-i-dăɣ, tənnəd-asăn: ad-sallăm s-timəẓẓujen-năwăn măšan, wăr t-illa a mad-təfhəmăm, ad-təswaḍăm s-tiṭṭawen-năwăn măšan, wăr t-illa a mad-tənhəyăm ");
INSERT INTO taq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","făl-a-s tamətte-i, tăsɣăr-ahi ulh-net, tăɣfăl-ahi timəẓẓujen-net, tăhăr-ahi tiṭṭawen-net i-ad-wăr hənnəy, wăr səll, i-ad-wăr t-illa a isalmaḍăn ulh-net, i-ad-săr-i dd-tənnăḍ, zuzəɣăɣ-tăt.› » ");
INSERT INTO taq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Innʼ-asăn Buləs ḍarăt-a-wen: «Ǝlmədăt, ɣur-ašăl-i-dăɣ a-s, əlɣəllas wa kăwăn-ikfa Măssinăɣ, ikfʼ-e daɣ i-inəẓẓulam -i has-e-səjədnen.»  ");
INSERT INTO taq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Issəmda Buləs tənna n-a-wen ɣas, fălăn-t kăl-Ălyăhud ămiiɣănnăn jer-iman-năsăn. ");
INSERT INTO taq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Izzăɣ Buləs dăɣ-ehăn-wen-dăɣ ifăr har dăɣ-s ăssakăy əssin iwətyan əmdanen. Ijraw iman-net, ehăn-en-dăɣ, a dăɣ-t-dd-tisən ăddinăt iket-năsăn wi ărhănen ahănay-net, ");
INSERT INTO taq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ixaṭṭăb-asăn isălan n-Təmmənəya n-Măssinăɣ, isaɣrʼ-en, wăr t-illa daɣ ere has-igdalăn tənna n-a-wa s-irha, ad-tăn-ănn făll-Emăli Ɣisa Ălmasex.");
INSERT INTO taq_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","A-wa năkk Buləs wa n-akli n-ƔisaĂlmasex dd-iɣra s-iman-net i-ad-umasăɣ ănămmašul ixaṭṭăbăn Ălənžil n-Măssinăɣ i-dăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ălənžil, isălan-net, ăru d-ăsjăr Măssinăɣ ăṭṭăma-năsăn dăɣ-əlkəttabăn wi šăddijnen əktăbăn ănnăbităn ");
INSERT INTO taq_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","i-ad-əjən dăɣ-săn isălan n-Ɣisa Ălmasex wa n-Rure-s n-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ɣisa, s-eɣăs-net, ahăya n-ămănokal Dawəd a ămoos măšan, tumast-net i-Rure-s n-Măssinăɣ, ăsdăttăt-tăt Măssinăɣ s-tărna n-Unfas Šăddijăn-i t-dd-issənkărăn jer-inəmmuttan. ");
INSERT INTO taq_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Təssəba n-Ɣisa Ălmasex-i n-Emăli-nănăɣ-en-dăɣ, ad-fălla-năɣ dd-ăzzăbbăt Măssinăɣ ănnuɣmăt-net, ijʼ-anăɣ inəmmušal-net i-ad-amənnăt tiwsaten ti n-inəẓẓulam, ămašălnăt erhet-net, səmɣărnăt isəm-net. ");
INSERT INTO taq_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Inəẓẓulam, kăla tăn-ham kăwăneḍ-dăɣ, măšan, ašăl-i-dăɣ, iɣrʼ-iwăn-dd Ɣisa Ălmasex s-iman-net. ");
INSERT INTO taq_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Təssəba n-a-wen-dăɣ a făl hawăn-in-kattăbăɣ tăkarḍe-ta-dăɣ, kăwăneḍ-i n-iməššeddəjăn ikna Măssinăɣ tărha əzzaɣnen aɣrəm wa n-Roma. Ăhuulăɣ-kăwăn-in, ikfʼ-iwăn Măssinăɣ-i n-Abba-nănăɣ d-Emăli Ɣisa Ălmasex ănnuɣmăt d-ălxer. ");
INSERT INTO taq_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Dăɣ-eɣăf n-a-wa s-ărheɣ ad-hawăn-tăn-ănnăɣ, ărheɣ ad-umayăɣ i-Măssinăɣ dăɣ-idəm n-ƔisaĂlmasex făl-a-s, wăr t-illʼ ăwadəm dăɣ-ăddunya s-wădden islʼ isălan n-iqqud n-immun-năwăn. ");
INSERT INTO taq_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","A-wa heɣ dăɣ-asəssiwăḍ n-isălan n-Ălənžil n-Rure-s n-Măssinăɣ, heɣ-t s-ulh imdan. Măssinăɣ-i ɣabbădăɣ s-ulh imdan a-s tajuhe-nin, wăr kăla okăy ašăl s-wădden kittəwăɣ-kăwăn, təddalăɣ-awăn-t ");
INSERT INTO taq_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","hak ašăl n-a-s kunta erhet-net a-wen, isărɣəset-ahi əmmək făl kăwăn-in-əkkeɣ. ");
INSERT INTO taq_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ijmaḍ-t ăššăk a-s ăsidărhănăɣ hullan ahănay-năwăn, əzzəyăɣ-kăwăn, ăkfăɣ-kăwăn hărăt dăɣ-isuf wi hi-ija Unfas Šăddijăn i-ad-iṣṣuhət immun-năwăn, ");
INSERT INTO taq_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","tənfum-ahi, ənfəwăɣ-kăwăn năkk-dăɣ dăɣ-immun wa hanăɣ-osaɣăn. ");
INSERT INTO taq_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ayətma-ɣ, ărheeɣ ad-təssanăm a-s ăru d-ăsdărhănăɣ ad-kăwăn-in-ăkkăɣ măšan, har ašăl-i-dăɣ, wăr-otes Măssinăɣ a-wen. Ăsidărhănăɣ hullan ad-ikrəš ălxidmăt wa heɣ fălla-wăn ălfăyda s-əmmək wa s-t-ikrăš jer-tiwsaten ti iyyăḍnen n-inəẓẓulam ");
INSERT INTO taq_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","făl-a-s dăɣ-isălan wi n-Ălənžil, wăr t-illa ere s-wădden ila făll-i ălɣar jer-kăl-iɣărman wăla kăl-ejef, jer-ălɣulam wăla ălžuhal. ");
INSERT INTO taq_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Iba n-aẓəmmăẓli n-ăddinăt-en-dăɣ a săr-i dd-orăwăn derhan n-ad-kăwăn-in-ăkkăɣ kăwăneḍ-dăɣ i əzzăɣnen Roma, ăjăɣ-awăn isălan n-Ălənžil. ");
INSERT INTO taq_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Wăr-ăkrakăḍăɣ Ălənžil ed ənta a-s tărna ta s-iɣallăs Măssinăɣ ere săr-s omănăn-dăɣ, kăl-Ălyăhud təzzar əlkămăn-asăl inəẓẓulam. ");
INSERT INTO taq_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ălənžil-en-dăɣ a hanăɣ-isalmadăn mi ilan idəm dat-Măssinăɣ s-əmmək wa s-tăn-ənnăn əlkəttabăn n-Măssinăɣ a-s ənnăn: «Ɣur-sănto har sămdo, immun a ihakkăn ăgg-adəm idəm dat-Măssinăɣ i-ad-ăj tămudre ta fălla-s irha Măssinăɣ.» ");
INSERT INTO taq_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tidət, Măssinăɣ, izazăbbat-dd aḍkăr-net făll-dăgg-adəm dăɣ-təssəba n-iba n-tuksəḍa ta t-wăr jen d-iba n-iqqud dăɣ-a-wa tamašalăn, əgdalăn i-iman-năsăn tidət, ənkaẓăn-tăt daɣ i-ăddinăt wi iyyăḍnen s-a-wa lăbasăn tamašalăn. ");
INSERT INTO taq_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","A-wa s-ămiɣatăr ăgg-adəm i-ad-săr-s izzəy Măssinăɣ, inbaj tiṭṭawen ed ăsnăfalăl-t-dd. ");
INSERT INTO taq_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","A-wa dăr-olăh Măssinăɣ, wăr t-illa ere t-inhayăn s-tiṭṭawen-net măšan, tărna-net ta tăɣlălăt, tumast-net i-Măssinăɣ, a-wen-dăɣ iket-net, afăl dăɣ-s ăznăzjamăt ăgg-adəm, ad-t-inhəy dăɣ-a-wa dd-ibna a-s dd-ixlăk ăddunya. ");
INSERT INTO taq_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Təssəba n-a-wen-dăɣ a făl ăbas t-illa asăru wălʼ iyyăn i-iba n-tuksəḍa-net ed, dăgg-adəm, əssanăn a-s Măssinăɣ illʼ-e măšan, unjăyăn s-ad-t-səmɣărăn wăla s-ad-has-umayăn. Ǝzzəwen-tăn erk inəzjam-năsăn s-mălayăɣna, orăw-dd săr-săn a-wen-dăɣ tekle dăɣ-tihay d-tăɣart n-ulh. ");
INSERT INTO taq_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Jan iman-năsăn ăddinăt ăzizăbbătnen musnăt, a-s ija a-wen, irmas-tăn iba n-tayətte. ");
INSERT INTO taq_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ǝnnăr lan tayətte, wăr həkkən iroriyawăn-năsăn Măssinăɣ-i iɣlălăn n-Măssi-s n-ănnur, samăskalăn-t ălɣibadăt n-ăṣṣănămăn ăṣṣiwwărnen dăgg-adəm-i s-a ijăn-dăɣ, ad-tăn-iba, ad-ɣabbădăn taliwen d-igḍaḍ d-irəzzejăn d-iẓlulam. ");
INSERT INTO taq_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Inhăy Măssinăɣ erk əẓẓənəf wa əjjăšăn ɣas, ăsrăs-tăn, oyyʼ-en, iwway-tăn aḍu, ošăl dăr-săn ḍarăt erk derhanăn n-ulhawăn-năsăn, ad-samăḍasăn iman-năsăn, šilləwnăt-tăn tikrukaḍ. ");
INSERT INTO taq_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ăsmăttăyăn tidət ta n-Măssinăɣ, jăn-tăt bahu; əqqălăn-dd ɣabbădăn amătăwăxlak, oyyăn Ămaxlak-i ănihăjjăn d-təmmal hărkuk. Amin! ");
INSERT INTO taq_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Təssəba n-a-wen-dăɣ a făl fălla-săn innăḍ Măssinăɣ, oyyʼ-en, oḍăn dăɣ-tikrukaḍ-tin-dăɣ. A-wa issăxrăm Măssinăɣ, ăssiixlălăn-t əntăneḍ; əbḍănăt tiḍeḍen-năsăn d-meddən-năsnăt, oyyănăt a-wa ilăn əmmək, ăqqălnăt-dd tinməkkinăt jer-iman-năsnăt. ");
INSERT INTO taq_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","A-wen-dăɣ daɣ a jăn meddən-năsnăt, jărăn-in a-wa dd-ăzzăbbăt Măssinăɣ ašăl ăzzarăn, ad-tăn-išilləw a ăsikărakăḍăn. Oyyăn meddən tiḍeḍen-năsăn, izzəwăt-tăn iblis-năsăn ad-itakk ăhaləs-ăhaləs, ămoos a-wen-dăɣ tăn-išlăn ălxaqq wa dăr-ănihăjjăn imojjan-năsăn d-təmɣăre n-tanməšrayt-năsăn. ");
INSERT INTO taq_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Šămad, unjăyăn s-ad-uksaḍăn Măssinăɣ, išlăy-asăn ənta-dăɣ dăɣ-xorəzzəma wa əkfăn iman-năsăn, immăr hărăt tiyətwen-năsăn, ad-tăn-išilləw a ăsikărakăḍăn wărăn itətwəjj. ");
INSERT INTO taq_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ăsisakăyăn ulhawăn-năsăn dăɣ-iba n-iqqud d-tăllăbăst d-erk derhan, d-tismiten d-iji n-iman d-ikənnasăn d-əkkăẓẓu d-erk inəzjam d-ukšaf. ");
INSERT INTO taq_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ămoosăn imawayăn n-ănnămima, ăššunjen Măssinăɣ, əkfărăn, hălăn, əḍnayăn əttəkəbru d-ibărajăn, ăsisakăyăn dăɣ-musnăt n-iji n-a-wa lăbasăn, inəbbudar iket-dăɣ-năsăn, ");
INSERT INTO taq_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","irmas-tăn iba n-tayətte, imărẓan n-ărkăwăl, ăqqurăn, kăwalăn ulhawăn-năsăn, wăr tăn-ha tăhanint. ");
INSERT INTO taq_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Išlʼ-en a-wen-dăɣ kud-dăɣ əssanăn a-s ilkam dăɣ-săn ăššăreɣa n-Măssinăɣ ed iktab dăɣ-măjrăd-net a-s ăddinăt wi šillun hărătăn-win-dăɣ, əlhəllak ɣas a dăɣ-săn ilkamăn. Ăssetăn dăɣ-a-wa ăssuksăḍăn tăn-išlăn har eqqas făw a tajjăn i-ăddinăt wi tamašalnen a-wen-dăɣ tăn-išlăn wărăn ilʼ əmmək. ");
INSERT INTO taq_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ăywa, kăyy-i isawarăn ăddinăt wi iyyăḍnen uḍlem, ere tămoosăd-dăɣ, ăbas hak t-illa ăsaru; dədi-dăɣ făw d-sawarăd ăddinăt wi iyyăḍnen uḍlem, ad-satbatăd a-s kăyy iman-năk, iwar-kăy uḍlem ed a-wa-dăɣ tăn-sawarăd a xaddămăd kăyy iman-năk. ");
INSERT INTO taq_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Wăr t-ihʼ ăššăk, nəssan iket-dăɣ-nănăɣ, a-s ăddinăt wi tamašalnen hărătăn-win-dăɣ lăbasnen, ad-tăn-išrăɣ Măssinăɣ s-ăššăreɣa wăr-iha bahu. ");
INSERT INTO taq_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Uhən kăyy, ma ɣur-k ijan? Kăyy-i s-a-wa tăjjăd, i lăbasăn, sawarăd uḍlem ăddinăt, torded a-s ad-tăɣləsăd dăɣ-ăššăreɣa n-Măssinăɣ wa ilkămăn? ");
INSERT INTO taq_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Meɣ kăyy šăɣnet, wăr təssəfrărăd təmɣăre n-milɣaw wa ija Măssinăɣ d-taẓidert-net d-marušăt-net? Ăniihăjja s-orăw-dd săr-k a-wen-dăɣ tămujriẓt, tutabăd. ");
INSERT INTO taq_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Măšan, kăyy wa hannăyăɣ, ăqqur ulh-năk, wăr tărhed ad-tutabăd. Ăššar ɣas n-Măssinăɣ a-s ilkam ad-t-dd-izəzzəbbət fălla-k ašăl wa n-aḍkăr-net d-ăššăreɣa-net wa oɣădăn. ");
INSERT INTO taq_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ašăl-en, hak ăwadəm d-a-wa has-jăn imojjan-net. ");
INSERT INTO taq_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ăddinăt-wi ăkoyădnen dăɣ-amišəl n-a-wa olăɣăn d-təmmal n-Măssinăɣ d-semɣar-net d-umăɣ i-tămudre ta n-tidət, ad-tăn-ăkf Măssinăɣ tămudre ta tăɣlălăt ");
INSERT INTO taq_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","măšan, wi has-ăffullăgnen, ăssofnen iba n-iqqud uhən tidət, ad-tăn-isəlməd a-s wăr has-ijreẓ ălxal-năsăn, izəzzubbət-dd aḍkăr-net fălla-săn. ");
INSERT INTO taq_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ad-tărməs tissust d-tiẓẓurt e d t-illăm ăgg-adəm itamašalăn a lăbasăn, isănt a-wen s-kăl-Ălyăhud, akəy s-tiwsaten ti iyyăḍnen n-inəẓẓulam. ");
INSERT INTO taq_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Măšan, ăddinăt-wi tamašalnen a-wa olăɣăn, ad-əjrəwăn semɣar d-təmmal d-ălxer ɣur-Măssinăɣ, isănt a-wen s-kăl-Ălyăhud, akəy s-tiwsaten ti iyyăḍnen ");
INSERT INTO taq_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","făl-a-s Măssinăɣ, wăr-ăẓmăẓlăy ăddinăt. ");
INSERT INTO taq_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ăddinăt wi ofănen abăkkaḍ a-s ija a-wen əžhalăn i-a-wa innă alămăr n-Măssinăɣ wa dd-ăzzăbbăt făll-ănnăbi Mosa, ad-dd-ətwăɣrən s-ăššăreɣa əntăneḍ-dăɣ măšan, wăr mad-ətwəšrăɣăn s-tijəttewen ti n-alămăr-wen-dăɣ. Kăl-Ălyăhud-i ha tijya n-a-wa innă alămăr, wăr t-illa a hasăn-idrajăn dăɣ-s, tijəttewen n-alămăr-en-dăɣ a-s tăn-e-išrăɣ Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Wădden ăddinăt-wi sajadnen i-a-wa innă alămăr s-timəẓẓujen-năsăn a he-əkrəšnen idəm ɣur-Măssinăɣ, ănn-ak, wi has-sajadnen s-ulhawăn-năsăn, tamašalăn a-wa dăɣ-s iktăbăn, a data-s-e-əkrəšnen idəm. ");
INSERT INTO taq_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kunta tiwsaten ti n-inəẓẓulam, wăr-əssennăt s-alămăr wa dd-ăzzăbbăt Măssinăɣ făll-ănnăbi Mosa, măšan tamašalnăt d-iman-năsnăt dăɣ-ălžăhalăt a-wa dăɣ-s ătwănnăn, ăssiilmăd-anăɣ a-wen-dăɣ a-s, əssannăt a-wa olăɣăn d-iman-năsnăt, ămešălnăt-t. ");
INSERT INTO taq_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ǝnta-den-dăɣ a-wa hanăɣ-isalmadăn a-s a-wa innă alămăr n-Măssinăɣ, iktab-t dăɣ-ulhawăn-năsnăt i-ad-t-ămašălnăt, ăssiilmăd-tănăt daɣ ənniyăt-năsnăt săr-s, măqqăr daɣ iššaki wa jănăt dăɣ-iman-năsnăt, tănăt-isalmadăn s-išk wa jănăt kud-dăɣ dehiyyăn unjaynăt s-a-wen. ");
INSERT INTO taq_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Wăr t-illa a-s wădden ilkam ad-itbət, infiləl-dd iket-dăɣ-net ašăl wa ilkămăn d-e-išrăɣ Măssinăɣ ăddinăt s-ƔisaĂlmasex, isənnəfiləl-dd a-wa iffărăn dăɣ-ulhawăn n-dăgg-adəm s-əmmək wa s-tăn-innă Ălənžil-i xaṭṭăbăɣ. ");
INSERT INTO taq_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kăyy-i ijănnen ăgg-Ălyăhud a tămoosăd, tabărajăd n-a-s ilʼ-ik Măssinăɣ, tăsifăllăd făll-a-wa s-tamašalăd a-wa innă alămăr wa n-Mosa, ");
INSERT INTO taq_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ija ɣur-k a-s təssanăd a-wa fălla-k irha Măssinăɣ, issəlmăd-kăy alămăr jer-a-wa olăɣăn d-a-wa lăbasăn, ");
INSERT INTO taq_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","təkkasăd ăššăk a-s ăddinăt wi iyyăḍnen, iməddorɣal, kăyy a-s ămalway-năsăn, kăyy a-s ănnur i-wi əzzăɣnen dăɣ-tihay; ");
INSERT INTO taq_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","tărhed tumast n-ălɣalim i-ălžuhal, emăssăɣăr n-aratăn, təflasăd iman-năk s-tidət ta kăy-issăɣra alămăr wa n-Mosa. ");
INSERT INTO taq_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Uhən kăyy-i s-hărkuk təmmaɣăd i-ere təssăɣrăd, ma s-hak-indar ad-săɣrəd iman-năk? Xaṭṭăbăd i-ăddinăt iba n-tikra, a-s ija a-wen, tikərəd; ");
INSERT INTO taq_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","xaṭṭăbăd-asăn tăxărme n-əzzəna, a-s ija a-wen, zinnud; janned-asăn, udaɣ ad-ɣabbădăn ăṣṣănămăn, a-s ija a-wen, tikərəd a-wa ihăn ihănan wi dăɣ-əzzăɣăn ăṣṣănămăn-win-dăɣ, ad-t-in-žanšed. ");
INSERT INTO taq_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tabărajăd n-a-s təssanăd alămăr wa n-Mosa, a-s ija a-wen, tănimăšrăyăd-as; ənta-den-dăɣ iba n-tuksəḍa-năk i-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","A-wen-dăɣ a făl inna əlkəttab n-Măssinăɣ dăɣ-isălan n-kăl-Ălyăhud: «Təssəba-năwăn kăwăneḍ-di-dăɣ a făl wăr-ătwăsămɣăr isəm n-Măssinăɣ jer-inəẓẓulam.» ");
INSERT INTO taq_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Tidət, amili infa hărăt afăl itamašăl ăwadəm a-wa fălla-s ifraḍ alămăr măšan, ere iraẓẓăn a-wa innă alămăr, wăr-iẓley amili-net d-iba-net ");
INSERT INTO taq_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","făl-a-s, kunta ere wa wărăn ămelăy, ilkam i-a-wa ifrăḍ alămăr făll-ăgg-adəm, ajăn wădden dat-Măssinăɣ, ad-ăbas iẓlay d-wa ămelăyăn. ");
INSERT INTO taq_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Kăwăneḍ, təssanăm a-wa fălla-wăn ifrăḍ alămăr, samalayăm iman-năwăn, a-s ija a-wen, wăr kăwăn-išla ar terăẓẓe n-a-wa fălla-wăn ifrăḍ alămăr, kunta inəẓẓulam əntăneḍ, wăr səmiləyăn iman-năsăn măšan, tamašalăn a-wa fălla-săn ifrăḍ alămăr, əntăneḍ-en-dăɣ a-s ilkam ad-kăwăn-səḍləmăn dat-Măssinăɣ, səkkərukəḍăn-kăwăn. ");
INSERT INTO taq_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Săjdăt ămăra, tidət, ənta da: ăgg-Ălyăhud wa n-tidət, wădden ere iwar ešwăl ilan mănhoy wăla amili, ănn-ak, ");
INSERT INTO taq_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ămoos-t ere wa s-ăsmalăy Măssinăɣ ulh-net, wădden ere wa ɣur-ija a-s itamašal a-wa innă alămăr dăɣ-tăkarḍe-net. Ǝnta-den-dăɣ, ăgg-Ălyăhud wa n-tidət. Ḍarăt-a-wen daɣ, amili wa n-tidət, a t-ămoosăn a-wa ija Unfas Šăddijăn n-Măssinăɣ dăɣ-ulh n-ăgg-adəm wădden hărăt n-taknəsset jat dăɣ-taɣəssa. Amili wa dd-orăw Unfas Šăddijăn s-ăgg-adəm, kud irha wăr-ikreš idəm dat-dăgg-adəm, ad-t-ikrəš dat-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Adiš, əndek abăraj wa ihăn tumast n-ăgg-Ălyăhud? Meɣ daɣ: amili-i-dăɣ, ma infa? ");
INSERT INTO taq_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ila tănfo măqqărăt ed kăl-Ălyăhud əntăneḍ a făll-dd-ăzzăbbăt Măssinăɣ măjrăd-net. ");
INSERT INTO taq_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nəssan a-s wăr has-ăsjădăn, ed, wăr-ămešălăn a-wa hasăn-innă măšan hakd a-wen-dăɣ, ajăn a-wen a hin-ăsibăṭṭălăn ălɣădalăt n-Măssinăɣ-hasăn? Ăbo, wăr-ămmukkăn a-wen ed, ");
INSERT INTO taq_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","kunta dăgg-adəm raẓẓăn dăɣ-tənna-năsăn, Măssinăɣ, tidət ɣas a t-dd-təffalăt s-əmmək wa s-tăn-innă əlkəttab n-Măssinăɣ a-s innă: «Măssinăɣ, a innă-dăɣ, oɣad. Ere has-iškăn daɣ, ad-fălla-s ikrəš tidət.» ");
INSERT INTO taq_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Măšan, kunta iba n-iqqud-nănăɣ ənta, a iẓaẓharăn iqqud wa n-Măssinăɣ, ma nənnă dăɣ-a-wen? Ămăra, edăwănne wa ităjj ăgg-adəm dăɣ-isəstanăn-net a hawăn-tajjăɣ năkk-dăɣ. Ak ajăn Măssinăɣ-i-dăɣ, wăr-oɣed făl-a-s innin itakkăs dăɣ-năɣ ălxaqq? ");
INSERT INTO taq_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Aa făw ed ənnăr ha wăla-dăɣ tafrăɣt tiyyăt ɣas Măssinăɣ, əndek əmmək wa s-mad-išrăɣ ăddunya? ");
INSERT INTO taq_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ămmukkăn a-s dăɣ-a-wa jănneɣ, əllan-t ăddinăt jannănen a-s: kunta bahu wa janneɣ, isinfiləl-dd tidət i-ad-iwwaḍ semɣar făll-isəm n-Măssinăɣ, adiš mafăl hi-itəggar uḍlem, tumasăɣ anăsbăkkaḍ bănnan? ");
INSERT INTO taq_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Adiš šămad isălan əntăneḍ-den-dăɣ, nilbaset ɣas i-ad-dd-tarəw tăllăbăst-nănăɣ-en-dăɣ imărkedăn. Tordam a-s bahu šund-wen-dăɣ, hălăɣ ad-t-səssăɣrăɣ. Ăddinăt wi tiwəynen ănnămimatăn šund-win-dăɣ, iskar ăššăreɣa wa dăr-ănihăjjăn ɣur-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Adiš, əndek tidət dăɣ-a-wa-dăɣ? Ak, ajăn năkkăneḍ-i n-kăl-Ălyăhud, nufa ăddinăt wi iyyăḍnen? Ma n-əmmək? Ǝssəjrăhăɣ-kăwăn-in a-s kăl-Ălyăhud hakd inəẓẓulam, wăr-əẓleyăn, ănnihăḍ dăɣ-săn abăkkaḍ iket-dăɣ-năsăn. ");
INSERT INTO taq_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Isălan n-a-wen-dăɣ a dăɣ-hanăɣ-ăssewăl əlkəttab n-Măssinăɣ a-s innă: «Wăr t-illa ăgg-adəm oɣadăn, wăla-dăɣ iyyăn ɣas, ");
INSERT INTO taq_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","wăr t-illa-i ijrahăn hărăt, wăla-i itattărăn ad-uksaḍ Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Oškan iket-dăɣ-năsăn, wăr-ăɣnen hărăt, wăr tăn-iha wăla-dăɣ iyyăn ɣas itamašalăn a-wa olăɣăn. ");
INSERT INTO taq_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","A-wa dd-izajjărăn imawăn-năsăn, ija mărkăhaw wa ija aẓəkka ămerăn; ilsawăn-năsăn a-s saswadăn ăddinăt; a-wa jănnen s-iḍlay-năsăn, irnʼ ihărăynănăn n-emăjăl. ");
INSERT INTO taq_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Laqqănăn ăddinăt, sasmamăn fălla-săn s-a-wa dd-ijammăḍăn imawăn-năsăn, ");
INSERT INTO taq_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ărorădăn iji n-iman, ");
INSERT INTO taq_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","edăgg əmmărăn-dăɣ, wăr dăɣ-s dd-tiyyən a săl ahălak d-ălmăṣṣibăt. ");
INSERT INTO taq_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","A-wa s-itawănna tabarăt n-ălxer, wăr hen zăbo-net, ");
INSERT INTO taq_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","wăr ha tuksəḍa n-Măssinăɣ tiṭṭawen-năsăn.» ");
INSERT INTO taq_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nəssan ya a-s a-wa innă alămăr wa n-Mosa iket-net, innʼ-en i-ăddinăt əssannen s-alămăr-en, hakd a-wen-dăɣ, han-tăn-i ăsisăndărnen. A-wen, ădduuttăt i-ad-wăr-itəmmil ăwadəm itabărajăn dat-Măssinăɣ ed ăddunya iket-dăɣ-net, a iwar uḍlem dat-Măssinăɣ. ");
INSERT INTO taq_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","A-wen ălmăɣna-net a-s wădden amišəl n-a-wa innă alămăr a hanăɣ-ihakkăn idəm dat-Măssinăɣ ed wăr t-ihʼ ăššăk a-s a-wa innă alămăr, indăr i-dăgg-adəm ad-t-ămašălăn. Ǝnta-den-dăɣ a-wa ăssiitbătăn a-s ăgg-adəm-i-dăɣ, tidət-dăɣ a-s anăsbăkkaḍ a ămoos. ");
INSERT INTO taq_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ămăra, a-wa hanăɣ-ihakkăn idəm dat-Măssinăɣ, ăsnăfalăl-anăɣ-t-dd. Iktab dăɣ-alămăr d-a-wa ənnăn əlkəttabăn wi n-ănnăbităn, ");
INSERT INTO taq_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ăsdătten iket-dăɣ-năsăn a-s immun s-ƔisaĂlmasex a ihakkăn imumənăn idəm dat-Măssinăɣ, a-wen, wăr săr-s iẓley dăgg-adəm. ");
INSERT INTO taq_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Dăgg-adəm iket-dăɣ-năsăn a ofăn abăkkaḍ, ibḍʼ-en a-wen d-ănnur n-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","măšan, hakd a-wen-dăɣ, iɣtăs Măssinăɣ dăɣ-ănnuɣmăt-net n-a-s ere omănăn s-Ɣisa Ălmasex-dăɣ, ad-ikrəš idəm dat-Măssinăɣ ed ămoos-as Ɣisa Ălmasex, Ămaɣlas wa has-in-inaššăn ibăkkaḍăn-net bănnan. ");
INSERT INTO taq_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Măssinăɣ dăɣ-tărha-net i-iqqud, ija Ɣisa tasəbḍărt i-ad-isəlməd s-iqqud, inɣăl ašni-net făll-tajəttewt, ămmut dăɣ-idăggan-nănăɣ i-ad-iẓəl ibăkkaḍăn-nănăɣ. Ibda, Măssinăɣ dăɣ-taẓidert-net, wăr-išreɣ ibăkkaḍăn wi ămešălăn ăddinăt ");
INSERT INTO taq_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","măšan ămăra, takute n-tăfaṣke-ta-dăɣ ijă a hanăɣ-salmadăt s-iqqud n-a-wa ija, a-wen-dăɣ a hanăɣ-isalmadăn a-s ila tărna n-ad-ăkf idəm dat-Măssinăɣ i-ere wa omănăn s-Ɣisa. ");
INSERT INTO taq_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ǝndek ɣas a-wa dăɣ-mad-ăbbărăj ăgg-adəm? Wăr t-illa ed ămăra, immun s-ƔisaĂlmasex a iɣallăsăn wădden amišəl n-a-wa ifrăḍ alămăr. ");
INSERT INTO taq_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ǝnta-den-dăɣ a-wa hanăɣ-isawănnen a-s: immun a ihakkăn ăgg-adəm idəm dat-Măssinăɣ wădden amišəl n-a-wa fălla-s ifrăḍ alămăr. ");
INSERT INTO taq_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Meɣ daɣ a tordam a-s Măssinăɣ-i-dăɣ, i n-kăl-Ălyăhud wădden in-inəẓẓulam? ");
INSERT INTO taq_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","I năsăn lab iket-dăɣ-năsăn ed Măssinăɣ, iyyăn ɣas, ənta a ihakkăn ere wa săr-s omănăn idəm, tawset t-lăt-dăɣ, jer-ti n-kăl-Ălyăhud-i jănen amili hărăt wăla ti n-inəẓẓulam-i wăren əja amili hărăt. ");
INSERT INTO taq_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ajăn a-wen-š ălmăɣna-net a hin-ikkasăn alămăr wa n-ănnăbi Mosa făl-a-s innin nənna a-s immun a ihʼ ălfăyda? Ăbo, wăr nənnă a-wen, alămăr, ihʼ edăgg-net. ");
INSERT INTO taq_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ămăra, ănnăbi Ibrahim-i hanăɣ-ăshăyăwăn, ma dăɣ-s-e-nănn, ma t-ikfăn idəm dat-Măssinăɣ? ");
INSERT INTO taq_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ǝnnăr timašalen-net a t-əkfănen idəm dat-Măssinăɣ, umas-as a-wen abăraj, măšan, wăr-ăddobăt a-wen dat-Măssinăɣ ");
INSERT INTO taq_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ed, əlkəttab n-Măssinăɣ iman-net a hanăɣ-innăn a-s: «Omăn Ibrahim s-Măssinăɣ, ikrăš data-s idəm.» ");
INSERT INTO taq_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ăgg-adəm ya, afăl ixdăm hărăt, timẓal-net dihen, wădden bănnan, ăniihăjja d-ălxaqq n-tide-net ");
INSERT INTO taq_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","măšan ăgg-adəm, immun-net s-Măssinăɣ a t-ihakkăn data-s idəm, wădden ălxidmăt ija s-ăṣṣahăt-net. Ǝnta-den-dăɣ əmmək wa s-ihakk Măssinăɣ idəm i-wi wăren ăddin. ");
INSERT INTO taq_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dăɣ-təssəba n-a-wen-dăɣ ijarrăw ăwadəm ikrašăn idəm ɣur-Măssinăɣ wăla imărkedăn a făl innă ămănokal Dawəd: ");
INSERT INTO taq_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Tənḍəḍ i-wi s-hin-inša Măssinăɣ erk imojjan-năsăn, omăs-in ibăkkaḍăn-năsăn, ");
INSERT INTO taq_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","tənḍəḍ i-wa s-hin-inša Emăli ibăkkaḍăn-net, wăr tăn-dd-iḍkel dăɣ-meḍan.» ");
INSERT INTO taq_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ălxer-wen-dăɣ, ajăn wădden, illʼ-e făll-wi ămelăynen hakd wi wăren ămelăy? Wădden, ătwănnʼ-anăɣ a-s: «Omăn Ibrahim s-Măssinăɣ, ikrăš data-s idəm.» ");
INSERT INTO taq_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ǝmme d-ikrăš Ibrahim idəm-wen-dăɣ dat-Măssinăɣ? Ak ajăn a-s t-ikrăš, ăzizăbbăt-dd Măssinăɣ amili meɣ? Ăbo, a-s ikrăš Ibrahim idəm dat-Măssinăɣ, wăr fălla-s insʼ absăr. ");
INSERT INTO taq_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Šămad oman s-Măssinăɣ, ikraš ɣur-s idəm, ad-ămelăy i-ad-umas a-wen tamătart tăssitbătăt idəm wa ikrăš. Otăs Măssinăɣ s-a-wen-dăɣ ad-umas Ibrahim abba n-e d t-illăm amumən dăɣ-təssəba n-ad-ɣur-s əkrəšăn wi ămelăynen hakd-dăɣ wi wăren ămelăy idəm ");
INSERT INTO taq_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","s-əmmək wa s-t-ɣur-s ikrăš Ibrahim-i s-ənta a-s abba n-ăddinăt-wi wăren ăsfălla făll-amili, ănn-ak wăr-omenăn ar s-Măssinăɣ s-əmmək wa s-săr-s omăn Ibrahim-i n-abba-nănăɣ-i ɣur-s ikrăšăn idəm hărwa wăr t-immer absăr. ");
INSERT INTO taq_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ijjăš Măssinăɣ ărkăwăl i-Ibrahim, innʼ-as, ad-ikus ăddunya ənta d-ihăyawăn-net măšan, tăkasit-en, wădden alkum i-a-wa innă alămăr a has-tăt-e-ikfən, immun s-Măssinăɣ d-idəm wa ɣur-s ikrăš a has-ijrăwăn a-wen. ");
INSERT INTO taq_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","A-wen-dăɣ afăl kunta tăkasit-ten-dăɣ, alkum i-alămăr a-s əssəbab-net, adiš ma infa immun s-ƔisaĂlmasex ed, ărkăwăl-wa t-ăssitbătăn, ibbəṭṭăl-in? ");
INSERT INTO taq_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Măšan, alămăr, wăr dd-itirəw săr-năɣ ar aḍkăr n-Măssinăɣ ed, ənnăr wăr dd-ixlek, wăr-itəmməl musnăt n-a-wa ămoos abăkkaḍ, wăr-itəmmil dihen ere iwar uḍlem. ");
INSERT INTO taq_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Dăɣ-təssəba n-a-wen-dăɣ a făl, ere wa omănăn s-Măssinăɣ ɣas a-s tətwar tăkasit-ten-dăɣ i-ad-tumas isuf ătiwăjjănen dăɣ-ănnuɣmăt-net. Ɣas, a-wen-dăɣ a dd-orăwăn a-s ărkăwăl wa ijjăš Măssinăɣ i-Ibrahim, oharăn-t dăr-s ihăyawăn-net iket-dăɣ-năsăn jer-wi əṭṭăfnen alămăr hakd wi omănnen s-Măssinăɣ s-əmmək wa s-săr-s omăn Ibrahim-i n-abba-nănăɣ iket-dăɣ-nănăɣ. ");
INSERT INTO taq_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Isălan n-a-wen-dăɣ a făl innă əlkəttab n-Măssinăɣ: «Ibrahim, jeɣ-kăy abba n-abrək n-tiwsaten.» Ɣas, Ibrahim-en-dăɣ dat-Măssinăɣ-i dd-isankarăn 