﻿USE sofia;
DROP TABLE IF EXISTS sofia.tap_vpl;
CREATE TABLE tap_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tap_vpl WRITE;
INSERT INTO tap_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pa kutendeka Leza waalengele myulu ni kyalo. ");
INSERT INTO tap_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ozo musita, kyalo kyaali kyali sie kibeebeebe, kabili tekuba mwali kantu, ni nfinzi yaali yakupiliile pa menda azikile. Inzi Mweo wakua Leza waali walela peulu menda. ");
INSERT INTO tap_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Leza waalandile evi, “Kube kisue!” Ni kisue kya-alukileko. ");
INSERT INTO tap_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Leza waamwene nangue kisue kyaali kyaweme. Waalekenkaniizie kisue ni nfinzi. ");
INSERT INTO tap_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kisue Leza waakiinikile musita wa koba, ni nfinzi waiinikile busiku. Kwa-alukile kyungulo, kabili kwa-alukile lukeelekeele. Bobo i bwaali busiku bwa mambo. ");
INSERT INTO tap_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kabili Leza waalandile evi, “Kube lweleele pa bukata bwa menda pakuti lulekenkanie menda ni menda.” ");
INSERT INTO tap_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Evi Leza waakitile lweleele ni kulekekania menda ali pensina lweleele ku menda ali mu muulu. Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Lweleele Leza waalwinikile lyulu. Kwa-alukile kyungulo, kabili kwa-alukile lukeelekeele. Bobo i bwaali busiku bwa bubili. ");
INSERT INTO tap_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kabili Leza waalandile evi, “Menda a pa kyalo akolonghane pa nkendo imo, evi musili umoneke.” Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Musili Leza wawinikile kyalo, ni menda aakolongheene pamo waenikile lyezi. Leza waamwene nangue kyaali kyaweme. ");
INSERT INTO tap_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kabili Leza waalandile evi, “Kyalo kimenie bikusi ni saasa uliwaseekako mbezu ilekenkeene, ni bimuti bilibyaseekako mazabo kukonkana ni misango yabyo, mazabo ali ni mbezu mukati.” Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kyalo kyaameniizie bikusi ni saasa uliwaseekako mbezu ilekenkeene, ni bimuti bilibyaseekako mazabo kukonkana ni misango yabyo, mazabo ali ni mbezu mukati. Leza wamwene nangue kyaali kyaweme. Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kwa-alukile kyungulo, kabili kwa-alukile lukeelekeele. Bobo i bwaali busiku bwa butatu. ");
INSERT INTO tap_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kabili Leza waalandile evi, “Misaniko imoneke mu lyulu ya kuti ilekenkanie musita wa koba ni musita wa busiku, kuti iye yali tulangi twa nsita ni nsiku ni myaka, ");
INSERT INTO tap_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","kabili misaniko iye yali mu lyulu kuti iye yasanikila pa kyalo.” Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Leza waakitile misaniko ibili ikata, musaniko utaniisie uye wasanikila musita wa koba, ni ukeepeleko uye wasanikila musita wa busiku. Kabili Leza waakitile ni ntanda. ");
INSERT INTO tap_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Leza waabiikile misaniko mu lyulu kuti iye yasanikila pa kyalo, ");
INSERT INTO tap_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","iye yateeka musita wa koba ni wa busiku, evi iye yalekenkaniizie kisue ni nfinzi. Leza waamwene nangue kyaali kyaweme. ");
INSERT INTO tap_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kwa-alukile kyungulo, kabili kwa-alukile lukeelekeele. Bobo i bwaali busiku bwa buna. ");
INSERT INTO tap_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kabili Leza waalandile evi, “Mu menda mube bilengua bikose bilibyaenda, ni mu lweleele mube byoni bilibyapupuka peulu kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Leza waalengele bilengua bikata bya mu lyezi mu misango yabyo, ni bilengua bikose bilibyaenda mu menda mu misango yabyo pamo ni byoni bilibyapupuka mu lweleele mu misango yabyo. Leza waamwene nangue kyaali kyaweme. ");
INSERT INTO tap_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Leza waabipaalile walanda bivyalane, bisanduluke ni kwizula mu menda a mu lyezi, ni byoni bisanduluke mu kyalo. ");
INSERT INTO tap_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kwa-alukile kyungulo, kabili kwa-alukile lukeelekeele. Bobo i bwaali busiku bwa busaano. ");
INSERT INTO tap_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kabili Leza waalandile evi, “Kyalo kifumie misango yonse ya bilengua bikose mu misango ilekenkeene. Nama ya kuteekua, ni bilibyayibula pansi, ni nama ya mu kisonso mu misango ilekenkeene.” Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Leza waakitile nama ya mu musitu mu misango yayo, ni nama ya kuteekua mu misango yayo, ni kubalua kilengua kilikyayibula pansi mu misango yayo. Leza waamwene nangue kyaali kyaweme. ");
INSERT INTO tap_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kabili Leza waalandile evi, “Ale kansi tubumbe muntu mu lukebu lwetu wapaleene ni fwefue. Kabili tumupeele buvinde bwa kuteeka masabi a mu lyezi, ni tooni twa mu lweleele, ni nama ya kuteekua, ni buvinde bwa kuteeka kyalo kyonse pamo ni bilengua byonse bilibyayibula pansi.” ");
INSERT INTO tap_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Evi Leza waalengele muntu mu lukebu lwakue mwine. Mu lukebu lwakua Leza i mwaalengeelue muntu. Mwalalume ni mwanakazi, waabalengele. ");
INSERT INTO tap_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Leza waabapaalile wabaana nangue, “Ale vyalane musanduluke. Izuzie kyalo ni kukinasia. Muye mwali bakateeka ba masabi a mu lyezi, ni ba byoni bya mu lweleele, ni ba bilengua byonse bikose bilibyayibula pansi.” ");
INSERT INTO tap_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Leza waalandile evi, “Mone namipeela kubalua saasa uli pa kyalo kyonse uliwaseekako mbezu, ni kubalua kimuti kilikyaseekako mazabo ali ni mbezu mukati kuti bikabe bya kulia byenu. ");
INSERT INTO tap_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Inzi nama yonse ya pa kyalo, ni tooni twa mu lweleele, ni kyonse kilikyayibula pansi kili ni bukose, nabipeela maani a saasa kuti bibe bilio byabo.” Evio i vikyaali. ");
INSERT INTO tap_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Leza waamwene nangue byonse bi-aakitile byaali byakilile kuwama. Kwa-alukile kyungulo, kabili kwa-alukile lukeelekeele. Bobo i bwaali busiku bwa mutanda. ");
INSERT INTO tap_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Evi i vyaapwile kulengua kwa lyulu ni kyalo pamo ni byonse bilimo. ");
INSERT INTO tap_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mu busiku bwa kilooba, Leza waali wasyapwile miilo yakue yonse i-aali wakita. Ni pakako, waatuziizie busiku bwa kilooba ni kulekela kubomba miilo yakue yonse i-aali wakita. ");
INSERT INTO tap_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Leza waapaalile busiku bwa kilooba ni kubuzuukia pantu i busiku bu-atuziiziemo pa kyamba kya miilo ya kulenga bintu byonse. ");
INSERT INTO tap_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Leli i lyasi lya kulengua kwa lyulu ni kyalo. Yawe Leza lu-aalengele lyulu ni kyalo, ");
INSERT INTO tap_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","pa kyalo tepaali pamenene kantu, ni saasa wa mu kisonso waali teunamene, pantu Yawe Leza waali tananokiepo nvula, kabili tepaali muntu wa kulima musili. ");
INSERT INTO tap_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Inzi menda a pansi i-aali aleeta kinwanvi pa bulongo. ");
INSERT INTO tap_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yawe Leza waabuulile lufunko lwa bulongo, wabumba mwalalume ni kumupuzila mupuze wa bukose mu myona, ni ye wa-aluka kilengua kikose. ");
INSERT INTO tap_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kabili Yawe Leza waakitile bukaba mu Edeni lya ku kabanga ni kubiikamo muntu u-aabumbile. ");
INSERT INTO tap_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yawe Leza waameniizie misango yonse ya bimuti pa musili, bimuti biweme mu monekelo, bilibyaseekako mazabo aweme a kulia. Pa bukata bwa bukaba, paali pali kimuti kya bukose ni kimuti kya kumana biweme ni bibiipile. ");
INSERT INTO tap_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Momo mu Edeni i mwaali mwafumine mwenzi waali waleeta kinwanvi mu bukaba. Ozo mwenzi waali wakasanikilemo myenzi ina. ");
INSERT INTO tap_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mwenzi wa mambo uliwakuutua Pishoni. Ozo mwenzi i uzyungulukiile kyalo kya Havila kilimo oro. ");
INSERT INTO tap_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Oro ya mu kekio kyalo iwamiisie, kabili i muli butonvu bwa bunu ni mabue a oniksi. ");
INSERT INTO tap_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mwenzi wa bubili uliwakuutua Gioni. Ozo mwenzi i uzyungulukiile kyalo kya Kushi. ");
INSERT INTO tap_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mwenzi wa butatu uliwakuutua Tigri. Ozo i upitile lya ku kabanga ka Asiria. Ni mwenzi wa buna uliwakuutua Efrati. ");
INSERT INTO tap_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kabili Yawe Leza waamutweme muntu ni kuya kumuteeka mu bukaba bwa mu Edeni kuti aye wasekwila ni kubulabukila. ");
INSERT INTO tap_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yawe Leza waamwanine evi, “Mazabo onse a ku bimuti bya mu bukaba kuti wa-alia, ");
INSERT INTO tap_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","inga sie mazabo a ku kimuti kya kumana biweme ni bibiipile, kyene tekuti ukalieko. Busiku buwaakalia mazabo a ku keki kimuti, kisinka waakafua!” ");
INSERT INTO tap_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kabili Yawe Leza waalandile evi, “Muntu tapalile kuya waikeele bunke bwakue. Ndikumukitila mukwasi amupalile.” ");
INSERT INTO tap_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yawe Leza waabuulile bulongo ni kubumba kubalua nama wa mu kisonso, ni kubalua kyoni kya mu lweleele ni kumutwalila muntu, evi Leza amone vi-alikubiinika meena. Kubalua liina lyainikilue kilengua kikose, i lyaali liina lyakyo. ");
INSERT INTO tap_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Muntu wainikile meena a nama ya kuteekua ni meena a byoni pamo ni meena a nama ya mu kisonso, inzi pa bebi byonse muntu taamwenepo mukwasi amupalile. ");
INSERT INTO tap_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yawe Leza waamuoniizie muntu tulo tukata. Lu-aali waonene, waamusomwenemo lubali lumo ni pa kyamba walinghaniapo munofu. ");
INSERT INTO tap_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yawe Leza waakitile mwanakazi na lolia lubali lu-aasomwene ku muntu mwalalume, ni kumutwala ozo mwanakazi kuli mwalalume. ");
INSERT INTO tap_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mwalalume waalandile evi, “Ozu i kikuza kya mu bikuza byane, ni munofu wa mu munofu wane. Evi alikuya wakuutua mwanakazi pantu afumiiziwe ku mwalalume.” ");
INSERT INTO tap_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ni pakako, kubalua mwalalume waakaba wasia se ni nghina ni kuya kulundana na mukazi wakue, ni bo baakaaluka mubili umo. ");
INSERT INTO tap_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mwalalume ni mukazi wakue baali bali sie bwamba, inzi tebaali baunvua busoni. ");
INSERT INTO tap_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kizoka kyaali kyakengeele kukila nama yonse ya mu kisonso yaalengelue na Yawe Leza. Kizoka kyaamwipuziizie mwanakazi, “Ati, ni kiine Leza waamikaniizie kulia mazabo a ku bimuti byonse bya mu bukaba?” ");
INSERT INTO tap_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mwanakazi wa-asukile evi, “Mazabo a ku bimuti byonse bya mu bukaba kuti twalia, ");
INSERT INTO tap_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","inzi Leza waalandile nangue, ‘Tekuti mukalie buzabo bwa ku kimuti kili pa bukata bwa bukaba, anzia kukumiako, pantu nga mwaakafua.’” ");
INSERT INTO tap_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kizoka kyaamwasukile mwanakazi, “Mwandi, temukafua. ");
INSERT INTO tap_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Pantu Leza amanine nangue busiku bumwakaba kulia azo mazabo, menso enu akaba kwizuka, ni mwe mwakaba kwaluka nga Leza mu kumana biweme ni bibiipile.” ");
INSERT INTO tap_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mwanakazi lu-aamwene nangue mazabo a ku kekio kimuti aali aweme kuliiwa, ni aweme mu kumoneka, kabili apalilile kumuletela mulangue, waakunwineko buzabo, walia, wamupeelako mulume wakue, ni ye walia. ");
INSERT INTO tap_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Penka papo, menso abo bonse babili aizuka ni kwinika nangue baali bali bwamba. Kupwako, babamba kutunga kumo maani a kimuti kya miku kuti bavwale. ");
INSERT INTO tap_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mwalalume ni mwanakazi lubaunvwile Yawe Leza walimukwenda mu bukaba musita wa kyungulo kwasyataleele, baamufyeme mu bimuti bya mu bukaba. ");
INSERT INTO tap_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yawe Leza waamukuutile muntu ni kumwipuzia, “Uli pi?” ");
INSERT INTO tap_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ni ye wa-asukile evi, “Naunvwanga lizui lyobe mu bukaba, ni ne natiinanga pantu ngiile nali bwamba, kusyali kufyama!” ");
INSERT INTO tap_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Leza waamwipuziizie evi, “Eba! Nani wakwananga nangue wiile wali bwamba? Eba! Walyanga buzabo bwa ku kimuti kinakikukaania kuliako?” ");
INSERT INTO tap_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mwaalume wa-asukile evi, “Ozu mwanakazi uwan'mpeele i wan'mpelanga buzabo, ni ne nalia.” ");
INSERT INTO tap_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kabili Yawe Leza waamwipuziizie mwanakazi, “Ati, wakitilangaki evio?” Mwanakazi wa-asukile evi, “Kizoka i kyan'mbeepanga, ni ne nalia.” ");
INSERT INTO tap_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ni pakako, Yawe Leza waakyanine kizoka nangue, “Pantu wakitanga evio, watiipua pa nama yonse iliyateekua ni ya mu kisonso. Kutula lelo, waya wasyaendela na kavumo ni kuya walia lufunko nsiku yonse ya bukose bobe. ");
INSERT INTO tap_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ndikubiika bulwani pakati kobe ni mwanakazi, ni pakati ka luvyalo lobe ni lwa mwanakazi. Luvyalo lwa mwanakazi lwaakasyesyeta mutue obe, ni we waakasuma kasinghino kakue.” ");
INSERT INTO tap_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kabili Yawe waamwanine mwanakazi nangue, “Naakakizia maavia mu kuvyala kobe, pa kuvyala baana waakaba wakisua. Kutona kobe kwaakaba kwali ku mulume obe, kabili i waakaba wakuteekele.” ");
INSERT INTO tap_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Yawe waamwanine mwalalume nangue, “Pantu waitabilanga bintu byalandanga mukazi obe ni kulia buzabo bwa ku kimuti kinakikukaania kuliako, bulongo bwatiipua pa mulandu obe. Mu bukose bobe bonse waakaba wabombesia na maka pa kusanga bilio. ");
INSERT INTO tap_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mu bulongo mwaakaba mwamena sie lubamba ni myunga, kabili waakaba walia saasa wa mu kisonso. ");
INSERT INTO tap_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mu kubombesia ni mu kusulwila kobe i muwaakaba wasangila bilio, mpaka paukabwelela ku bulongo kuwaafumine. Uli lufunko, waakabwelela ku lufunko.” ");
INSERT INTO tap_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mwalalume, liina lyakue Adamu, waamwinikile mukazi wakue liina lya Eva, pantu ozo i wa-alukile nghina wa bantu bonse. ");
INSERT INTO tap_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kabili Yawe Leza waabakitiile bivwalo bya mpapa ya nama ni kubavwika. ");
INSERT INTO tap_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kabili Yawe Leza waalandile evi, “Evi muntu wa-aluka nga fwefue mu kumana biweme ni bibiipile. Ni pakako, tapalile kupeelua nsambu ya kukununa buzabo bwa ku kimuti kya bukose ni kulia evi akeekalilila muyayaya.” ");
INSERT INTO tap_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yawe Leza waamukumbile Adamu mu bukaba bwa mu Edeni, evi aye alime mu bulongo bu-abumbiilueko. ");
INSERT INTO tap_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Leza lu-aamukumbile Adamu mu bukaba, waabiikile makerubi pa nghingililo ya ku kabanga ka bukaba bwa mu Edeni, ni kipanga kya mulilo kyaali kyazyunguluka konse konse kusakilila nzila ya kuya ku kimuti kya bukose. ");
INSERT INTO tap_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu waaleele ni mukazi wakue Eva, ni ye waimitile ni kuvyala mwana mwalalume. Eva waalandile evi, “Ozu mwana napeelua na Yawe.” Ni pakako, waamwinikile Kaini. ");
INSERT INTO tap_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pa kyamba, waavyele unge mwana mwalalume ni kumwinika Abeli. Abeli waali wali kateeka wa mikooko, inzi Kaini waali mulimi. ");
INSERT INTO tap_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Busiku bumo Kaini waatwele ngelelo ya buzombozi kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeli ni ye waatwele libeli wa pa mikooko yakue, waipaya ni kufumiako munofu unonene kuti ube ngelelo. Yawe waawamiinue na Abeli pamo ni ngelelo yakue, ");
INSERT INTO tap_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","inzi taawaamiinue na Kaini pamo ni ngelelo yakue. Ni pakako, Kaini waafiitiisiwe mpaka ni pa menso pakalabana. ");
INSERT INTO tap_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yawe waamwipuziizie Kaini, “Eba, ale wafiitiluaki? Kabili wakalabaniiziaki pa menso? ");
INSERT INTO tap_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mona we Kaini uwamyenge, nga wawaminwanga. Inzi pantu waluvyanga, kibalo kikupembeele kyalimukukeba ku kuteeka. Inzi upalile kukyanzia.” ");
INSERT INTO tap_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaini waamwanine mwalawakue Abeli nangue, “We mwalawane, twende mu kisonso.” Lubaafikile mu kisonso, Kaini waamwalukiile Abeli ni kumwipaya. ");
INSERT INTO tap_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yawe waamwipuziizie Kaini, “Mwalaobe ali pi?” Wa-asukile nangue, “Ne nsimanine. Eba! Nene i musungi wakua mwalawane?” ");
INSERT INTO tap_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kabili waamwipuziizie evi, “Wakitangaki? Mulopa wakua mwalaobe uwazuumiizyanga pa bulongo ulimukundilila. ");
INSERT INTO tap_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Evi wewe watiipua ni kukumbua pa bulongo bwaizulanga kanua kakue ni kupokelela mulopa wakua mwalaobe waazuumiiwanga na kuboko kobe. ");
INSERT INTO tap_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Paukalima mu bulongo, tebukakuleetela kibwezia, inzi waakaba wali kanukunta mwaya kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini waamwanine Yawe, “Kukanda kuwankanda kwangaviizia, nsivinda kusipikizia. ");
INSERT INTO tap_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mona wankumba mu keno kyalo ni ku menso obe. Evi naakaba nali sie kanukunta mwaya kyalo, ni onse waakan'mona, waakangipaya.” ");
INSERT INTO tap_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yawe waamwanine Kaini, “Onse waakakwipaya, waakalandwilua nghendo kilooba.” Ni pakako, Yawe waamubiikile kalangi, evi onse waakamumona tekuti akamwipaye. ");
INSERT INTO tap_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaini waafumine ku menso akua Yawe ni kuya kwikala mu kyalo kya Nodi, nkendo ili ku kabanga ka Edeni. ");
INSERT INTO tap_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini waaleele ni mukazi wakue, ni ye waimitile ni kuvyala mwana mwalalume ni kumwinika Enoki. Kaini waakuulile muzi ni kuwinika liina lya mwana wakue mwalalume. ");
INSERT INTO tap_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki waavyele mwana mwalalume ni kumwinika Iradi, Iradi waavyele Mehuyaeli, Mehuyaeli waavyele mwana mwalalume ni kumwinika Metushaeli, Metushaeli waavyele Lameki. ");
INSERT INTO tap_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki waupile banakazi babili, umo waali wakuutua Ada, ni unge waali wakuutua Zila. ");
INSERT INTO tap_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada waavyele Yabali waali kikolue wa bantu baali baikala mu maema ni kuya bali bateeki ba nama. ");
INSERT INTO tap_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mwalawakue waali wakuutua Yubali. Ozo mwalawakue i kikolue wa balia baali balizia bilimba ni mimpyeta. ");
INSERT INTO tap_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila waavyele Tubali-Kaini. Ozo muntu i waali mutili wa bibombelo bya misango ilekenkeene, bya mukuba ni bya kyela. Nkaziize kwa Tubali-Kaini waali wakuutua Naama. ");
INSERT INTO tap_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki waabaanine bakazi bakue babili, “Ada ni Zila, ntwilizie mwe bakazi bakua Lameki unvue twebo twane. Nene nakiipaya muntu wakinkisia, mulumendo pantu wakinghuma. ");
INSERT INTO tap_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kaini kine waakalandwilua nghendo kilooba, Lameki waakalandwilua nghendo 77.” ");
INSERT INTO tap_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kabili Adamu waaleele ni mukazi wakue, Eva lu-aimitile waavyele unge mwana mwalalume ni kumwinika Seti. Waalandile evi, “Leza wan'mpeela unge mwana mwalalume wa kupyanikizia pali Abeli waipailue na Kaini.” ");
INSERT INTO tap_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti ni ye waavyele mwana mwalalume ni kumwinika Enoshi. Ozo musita bantu i ubaatendekeelepo kumupupa Yawe ni kubombia Liina lyakue. ");
INSERT INTO tap_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Keki i kitabu kya nvyalo yakua Adamu. Leza lu-aalengele muntu, waamukitile wapaleene ni Leza. ");
INSERT INTO tap_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Leza waalengele mwalalume ni mwanakazi, waabapaalile ni kubenika liina lya muntu bobo busiku bubaalengelue. ");
INSERT INTO tap_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu lu-aakumaniizie myaka 130, waavyele mwana mwalalume mu lukebu lwakue, wapaleene nakue ni kumwinika Seti. ");
INSERT INTO tap_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pa kyamba kya kuvyala Seti, Adamu waikeele pa kyalo myaka 800 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu waafwile wali na myaka 930. ");
INSERT INTO tap_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti lu-aakumaniizie myaka 105, waavyele mwana mwalalume ni kumwinika Enoshi. ");
INSERT INTO tap_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pa kyamba kya kuvyala Enoshi, Seti waikeele pa kyalo myaka 807 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti waafwile wali na myaka 912. ");
INSERT INTO tap_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi lu-aakumaniizie myaka 90, waavyele mwana mwalalume ni kumwinika Kenani, ");
INSERT INTO tap_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","pa kyamba kya kuvyala Kenani, Enoshi waikeele pa kyalo myaka 815 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi waafwile wali na myaka 905. ");
INSERT INTO tap_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani lu-aakumaniizie myaka 70, waavyele mwana mwalalume ni kumwinika Mahalaleli. ");
INSERT INTO tap_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pa kyamba kya kuvyala Mahalaleli, Kenani waikeele pa kyalo myaka 840 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani waafwile wali na myaka 910. ");
INSERT INTO tap_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli lu-aakumaniizie myaka 65, waavyele mwana mwalalume ni kumwinika Yaredi, ");
INSERT INTO tap_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","pa kyamba kya kuvyala Yaredi, Mahalaleli waikeele pa kyalo myaka 830 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli waafwile wali na myaka 895. ");
INSERT INTO tap_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaredi lu-aakumaniizie myaka 162, waavyele mwana mwalalume ni kumwinika Enoki, ");
INSERT INTO tap_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","pa kyamba kya kuvyala Enoki, Yaredi waikeele pa kyalo myaka 800 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaredi waafwile wali na myaka 962. ");
INSERT INTO tap_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoki lu-aakumaniizie myaka 65, waavyele mwana mwalalume ni kumwinika Metusela. ");
INSERT INTO tap_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Pa kyamba kya kuvyala Metusela, Enoki waendele pamo ni Leza myaka 300, kabili waavyele ni bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoki waafwile wali na myaka 365. ");
INSERT INTO tap_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki waendele pamo ni Leza, kabili taamwenekele pantu waatwemue na Leza wakosele. ");
INSERT INTO tap_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela lu-aakumaniizie myaka 187, waavyele mwana mwalalume ni kumwinika Lameki, ");
INSERT INTO tap_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","pa kyamba kya kuvyala Lameki, Metusela waikeele pa kyalo myaka 782 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela waafwile wali na myaka 969. ");
INSERT INTO tap_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki lu-aakumaniizie myaka 182, waavyele mwana mwalalume ");
INSERT INTO tap_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ni kumwinika Noa. Waalandile evi, “Ozu i waakatusansamusia kukonkana ni miilo ikolele itulitwabomba pa kyalo kyaatiipilue na Yawe.” ");
INSERT INTO tap_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pa kyamba kya kuvyala Noa, Lameki waikeele pa kyalo myaka 595 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki waafwile wali na myaka 777. ");
INSERT INTO tap_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa lu-aakumaniizie myaka 500, waavyele Shemu, ni Hamu, ni Yafeti. ");
INSERT INTO tap_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bantu lubaatendekele kusanduluka pa kyalo, baali bavyala ni baana banakazi. ");
INSERT INTO tap_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Baana bena Leza lubaamwene nangue bakazyana bena bantu baali baweme, baisaakwiliilepo bamo kuba bali bakazi babo. ");
INSERT INTO tap_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yawe waalandile evi, “Mweo wane teukikanzyania na muntu muyayaya pantu wene ni wa kufua. Kutula lelo, myaka yakue teikikaba yakila pa myaka 120.” ");
INSERT INTO tap_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mu ezio nsiku Banefili baali bali pa kyalo. Pa kyamba baana bena Leza lubaile kuupa baana banakazi bena bantu, baavyelemo baana balalume. Babo i baali bali babipami ba bantu baali bamanikile pa ozo musita. ");
INSERT INTO tap_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yawe lu-aamwene nangue bubi bwa muntu bwakila pa kyalo, ni kumona nangue malanga a mu mutima wakue lyonse aali akila kubiipa, ");
INSERT INTO tap_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yawe waunvwile bulanda pantu waalengele muntu pa kyalo, ni mutima wakue waamukisile. ");
INSERT INTO tap_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yawe waalandile evi, “Nakaba kulovia muntu unaalengele pa kyalo, bonse muntu ni nama, ni bilibyayibula pamo ni tooni twa mu lweleele. Naunvua bulanda pantu naabilengele.” ");
INSERT INTO tap_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Inzi Noa waali watonenue na Yawe. ");
INSERT INTO tap_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Leli i lyasi lyakua Noa ni luvyalo lwakue. Noa waali wali mulunghami ni wa kisinka mu bantu ba pa musita wakue, kabili waali waenda ni Leza. ");
INSERT INTO tap_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa waavyele baana balalume batatu, Shenu, Hamu, ni Yafeti. ");
INSERT INTO tap_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Leza waamwene nangue kyalo kyainooneka, ni kukitilana bibiipile kwakila kukumana mwaya kyalo. ");
INSERT INTO tap_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Leza waakentele ni kumona nangue kyalo kyabiipa pantu bantu bonse baali baikeele mu bwikazi bubi. ");
INSERT INTO tap_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Leza waamwanine Noa nangue, “Mpeleezio ya bantu bonse yakumana pantu bubi bwabo bwaizula mu kyalo kyonse. Kabili nakaba kubaloviizia pamo ni kyalo. ");
INSERT INTO tap_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","We Noa, nakwana ukite safina ikata ya mbao ilumine, ni kuputulamo miputule, ukabe kusubako kabulimbu mukati ni panze. ");
INSERT INTO tap_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ukabe kukita safina ileepele metre 133, ni mu bukata metre 22, ni mu kutuuluka metre lyanondo ni itatu. ");
INSERT INTO tap_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ukabe kukitako mutenge ni kusiako mando ali ni santimetre 44. Ukabe kukitamo mpungu itatu yateekaleene yali ni mulyango mumbali, ");
INSERT INTO tap_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","pantu nakaba kubunzia kyalo ni kwinoona bilengua byonse bikose. Bilengua byonse bili pa kyalo byakaba kufua. ");
INSERT INTO tap_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Inzi nakaba kupinghana nobe. Wewe ukengile mu safina ni mukazi obe, ni baana bobe balalume pamo ni bakazi babo. ");
INSERT INTO tap_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kabili pa bilengua byonse bikose ukabe kubuulapo bibili bibili ni kubingizia mu safina, ukabisunge byakosele kilume ni kikota. ");
INSERT INTO tap_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ukabe kubuula misango yonse ya nama, ni misango yonse ya tooni, ni ya byonse bilibyayibula. Bebi byonse, byaakeeza kuli wewe bibili bibili kuti ukabisunge byakosele. ");
INSERT INTO tap_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ukabe kubuula misango yonse ya bilio ukabe kubisunga, evi wewe ni nama pamo ni tooni mukabe mwabilia.” ");
INSERT INTO tap_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa waakitile bintu byonse nga mwa-aniinue na Leza. ");
INSERT INTO tap_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yawe waamwanine Noa nangue, “Ale ingila mu safina pamo ni lupua lobe pantu nakikumona wali mulunghami pa bantu bonse. ");
INSERT INTO tap_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Buulapo mpe kilooba ya misango yonse ya nama isambikile ndume ni ikota, inzi nama itiikeene ubuulepo mpe imo imo ndume ni ikota. ");
INSERT INTO tap_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kabili buula mpe kilooba ya misango yonse ya tooni tulume ni tukota. Ukite evio kumona sie misango yonse ya nama ni ya tooni ikasungue bwino, evi ikavyalane paakale ni kuvula pa kyalo, ");
INSERT INTO tap_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","pantu kwasyala nsiku kilooba nkabe kunokia nvula pa kyalo. Ezio nvula yakaba kunoka nsiku 40 busiku ni koba. Nakaba kwinoona bilengua byonse bikose binaalengele pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa waakitile bintu byonse bya-aninue na Yawe. ");
INSERT INTO tap_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kyalo lukyaabundile, Noa waali wali na myaka 600. ");
INSERT INTO tap_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa ni mukazi wakue ni baana bakue balalume pamo ni bakazi babo, baingiile mu safina evi tekuti bafue na azo menda a kibunda. ");
INSERT INTO tap_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Misango yonse ya nama ni ya tooni kilume ni kikota, bisambikile ni bisisambikile pamo ni bilibyayibula pansi, ");
INSERT INTO tap_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","byaingiile bibili bibili mu safina pamo ni Noa nga mwaalandiile Leza. ");
INSERT INTO tap_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pa kyamba kya nsiku kilooba, kibunda kyaizile pa kyalo. ");
INSERT INTO tap_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa lu-aali na myaka 600, mu mwezi wa bubili pa nsiku lyanondo ni kilooba, menda aabambile kusula na maka mu tusulo. Mu muulu ni mo mwaabambile kwituluka menda. ");
INSERT INTO tap_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ezio nvula yaanokele pa kyalo nsiku 40 busiku ni koba. ");
INSERT INTO tap_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Bobo bwenka busiku, Noa ni mukazi ni baana bakue balalume batatu, Shemu, ni Hamu, ni Yafeti pamo ni bakazi babo, baingiile mu safina. ");
INSERT INTO tap_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Baingiile mu safina pamo ni nama ya mu kisonso mu misango yayo. Nama ya kuteekua mu misango yayo, ikata ni iniini, ni bilibyayibula pansi mu misango yabyo, ni tooni pamo ni byonse bilibyapupuka mu misango yabyo. ");
INSERT INTO tap_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bilengua bikose, bibili bibili kilume ni kikota, byaingiile mu safina pamo ni Noa. ");
INSERT INTO tap_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kubalua kilengua kikose, kilume ni kikota byaingiile mu safina nga mwa-aniinue Noa na Leza. Kupwako, Yawe wamwizalila Noa. ");
INSERT INTO tap_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Nvula yaatwaliliile kunoka mpaka nsiku 40 busiku ni koba. Menda aizwile pa kyalo mpaka ni safina yabamba kweleela. ");
INSERT INTO tap_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Menda aizwile pa kyalo mpaka ni mpili yonse yatibila. ");
INSERT INTO tap_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Azo menda atwaaliliile kwizula pa kyalo mpaka metre kilooba kufuma peulu lupili luleepeesie. ");
INSERT INTO tap_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kubalua kilengua kikose kyaali kyaenda pa kyalo, kyoni, ni nama wa kuteekua ni nama wa mu kisonso, ni kilikyayibula pa kyalo pamo ni muntu, byaafwile. ");
INSERT INTO tap_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bilengua byonse byaali byapeema pano pa kyalo byaafwile. ");
INSERT INTO tap_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yawe waloviizie bilengua byonse bya pano pa kyalo. Waaloviizie bantu ni nama pamo ni byoni. Paasyele sie Noa ni balia baali wali nabo mu safina. ");
INSERT INTO tap_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Menda aasyele aizwile pa kyalo nsiku 150. ");
INSERT INTO tap_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Leza waamulangulukile Noa ni bilengua byonse bikose bi-aali nabio mu safina. Leza waabuusiizie mwela pa kyalo, ni menda aatendekele kuya akama. ");
INSERT INTO tap_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Monse mwaali mwafuma menda pansi mwaasinkile, lyulu lyaizalikile, ni nvula yaakatile, ");
INSERT INTO tap_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","menda aatwaliliile kuya akama buke buke mpaka nsiku 150. ");
INSERT INTO tap_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pa busiku bwa lyanondo ni kilooba mwezi wa kilooba, safina yaikeele peulu mpili ya Ararati. ");
INSERT INTO tap_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Menda aatwaliliile kukeepa. Mu mwezi wa lyanondo pa busiku bwa mambo, mpili yaatendekele kumoneka. ");
INSERT INTO tap_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lupaapitile nsiku 40, Noa waizwile nzota ");
INSERT INTO tap_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ni kutuma kazooko. Kazooko tekaabwelele, inzi kaali kaya kazyunguluka sie mu lweleele mpaka musita waakamine menda pa kyalo. ");
INSERT INTO tap_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kabili Noa waatumine kakunda kaye kamone kine menda akeepa pa kyalo, ");
INSERT INTO tap_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","inzi pantu menda aali teanakame pa kyalo kyonse, kakunda tekaamwene nkendo ya kuya kwikalapo. Ni pakako, kaabweleele kuli Noa. Noa wakakwata ni kukengizia mu safina. ");
INSERT INTO tap_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Pa kyamba kya mulungu umo, kabili Noa waafumiizie kakunda mu safina ni kukatuma. ");
INSERT INTO tap_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Bobo bwenka busiku kyungulo, kakunda kaabwelele katweme lyani lya muzeituni ku mulomo. Noa i lu-ainikile nangue menda akeepa. ");
INSERT INTO tap_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kabili Noa waapembeele ni unge mulungu. Waatumine kakunda paakale. Lolo lwendo lwene kakunda tekaabwelele. ");
INSERT INTO tap_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa lu-aakumaniizie myaka 601, mu mwezi wa mambo pa busiku bwa mambo, menda aakamine pa kyalo. Noa waatupukwile ntupiko ya safina, ni kiine wamwene menda akamine. ");
INSERT INTO tap_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mu mwezi wa bubili pa nsiku 27, Musili waumine. ");
INSERT INTO tap_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Leza waamwanine Noa nangue, ");
INSERT INTO tap_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Fuma mu safina, wewe ni mukazi obe, ni baana bobe balalume pamo ni bakazi babo. ");
INSERT INTO tap_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fumia kubalua kilengua kikosele ki-uli nakio mu safina, byoni, ni nama pamo ni kubalua kilengua kya pa kyalo, evi bivyalane ni kusanduluka pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ni kiine Noa waafumine pamo ni mukazi wakue, ni baana bakue balalume pamo ni bakazi babo. ");
INSERT INTO tap_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nama ni byoni pamo ni bilengua byonse bikose byaali byali mu safina, byaafumine. ");
INSERT INTO tap_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa waamukuuliile Yawe kitale. Waabuulilepo misango yonse ya bilengua bisambikile, pa nama ni tooni, ni kubiziziizia byonse pa kitale kuti bibe ngelelo. ");
INSERT INTO tap_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yawe waawamiinue na bunu bwa ngelelo yaaziziiziwe. Yawe waalandile evi, “Nsikikatiipa kabili kyalo pa mulandu wa muntu, anzia kine malanga a muntu abiipile kutula ku bulumendo bwakue. Kabili nsikikeenoona bilengua byonse bikose mu ozu musango. ");
INSERT INTO tap_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Lyonse kyalo lukikilipo, kuli kwaya kwali musita wa kubyala ni musita wa kuzombola, musita wa kasama ni musita wa lyuza, musita wa mwela ni musita wa likungulu, musita wa koba ni musita wa busiku, ni byo byaakabeelelela.” ");
INSERT INTO tap_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Leza waamupaalile Noa pamo ni baana bakue balalume wabaana nangue, “Vyalane musanduluke evi luvyalo lobe lwizuzie kyalo. ");
INSERT INTO tap_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nama yonse ya pa kyalo ni tooni tonse twa mu lweleele, ni bilengua byonse bilibyayibula pansi, ni masabi onse a mu lyezi, byaakaba byaunvua mwezo ni kumitiina. Kabili namipeela buvinde pa bintu byonse bya pa kyalo. ");
INSERT INTO tap_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nama ya misango yonse ikosele yaakaba bilio byenu nga vinaamipeele saasa ulekenkeene. ");
INSERT INTO tap_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Inzi tekuti mukaliililile nama pamo ni mulopa wakue, pantu i bukose bwakue. ");
INSERT INTO tap_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kisinka naakakita kibwelezi pa mulopa wa bukose bwenu, naakakita kibwelezi ku muntu ni ku nama, ni ku muntu ni muntu nakue. ");
INSERT INTO tap_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ozo waakeetila mulopa wa muntu, ni ye mulopa wakue waakeetilua na muntu, pantu muntu waalengelue wapaleene ni Leza. ");
INSERT INTO tap_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Inzi mwemue vyalane musanduluke evi luvyalo lobe lwizuzie kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kabili Leza waamwanine Noa ni baana bakue balalume nangue, ");
INSERT INTO tap_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Unvue, napinghana nenu pamo ni nvyalo yenu. ");
INSERT INTO tap_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Napinghana na bilengua byonse bikose: Toni tonse, ni nama yonse ya kuteekua pamo ni nama yonse ya mu kisonso imwakifuma nayo mu safina. ");
INSERT INTO tap_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Napinghana nenu nangue, nene nsikikeenoona kabili bilengua bikose na kibunda. Kabili tekukaba kinge kibunda kyaakeenoona kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Leza waabaanine nangue, “Kaka i kalangi ka kipingo kinapinghana nenu pamo ni bilengua byonse bikose, kalangi ka muyayaya ku nvyalo yonse ya ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nabiika mukolanvula mu malezi kuti ube kalangi ka kipingo kinapinghana na kyalo. ");
INSERT INTO tap_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Naakaba nakita kine nakolonghania malezi, ni mukolanvula wamoneka mu malezi, ");
INSERT INTO tap_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","naakaba nalangakana kipingo kinapinghana nenu, ni nama yonse ni tooni tonse pamo ni bilengua byonse bikose nangue nsikikabinoona kabili na kibunda. ");
INSERT INTO tap_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mukolanvula paukaba wamoneka mu malezi, naakaba nakentako kuti nanguluke kipingo kya muyayaya kili pakati kane ni bilengua byonse bikose bya pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Leza waamwanine Noa, “Kaka i kalangi ka kipingo kinapinghana na bilengua byonse bikose bya pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Meena a baana balalume bena Noa baafumine mu safina ni aza: Shemu, ni Hamu, Ni Yafeti. Hamu i waavyele Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Babo baana batatu balalume bena Noa i babikolue ba bantu bonse baasalangheene mwaya kyalo. ");
INSERT INTO tap_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa wa-alukile mulimi. Kabili i waali wa mambo kulima bukaba bwa mizabibu. ");
INSERT INTO tap_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Busiku bumo Noa waaminine divai, wakolua, ngubo yakue yaapenukile paali waleele mu liema lyakue. ");
INSERT INTO tap_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, se kwa Kanaani, lu-aamwene se waleele bwamba, waile kubwilako Shemu ni Yafeti. ");
INSERT INTO tap_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shemu ni Yafeti lubaunvwile evio, baatweme ngubo pa nkombe, babamba kuya nayo kinfwefue mpaka kuya kumuvimba sibo. Bene tebaamukentele sibo waali waleele bwamba. ");
INSERT INTO tap_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa lu-aakololokelue ni kumana vyaakitile mwana wakue Hamu, ");
INSERT INTO tap_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","waalandile evi, “Kanaani atiipue! Kabili aye wali muzia wakua Shemu ni Yaferi.” ");
INSERT INTO tap_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kabili waalandile evi, “Yawe, Leza wakua Shemu apaalue! Kanaani aye wali muzia wakua Shemu! ");
INSERT INTO tap_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Leza avuzie bunonsi bwakua Yafeti. Yafeti ekale mu maema akua Shemu, ni Kanaani aye wali muzia wakua Yafeti.” ");
INSERT INTO tap_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pa kyamba kya kibunda, Noa waikeele pa kyalo myaka 350. ");
INSERT INTO tap_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa waafwile wali na myaka 950. ");
INSERT INTO tap_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa waavyele baana batatu balalumenke: Shemu, ni Hamu, pamo ni Yafeti. Babo batatu ni bo baavyele baana balalume pa kyamba kya kibunda. ");
INSERT INTO tap_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafeti waavyele Gomeri, ni Magogi, ni Madai, ni Yavani, ni Tubali, ni Mesheki, pamo ni Tirasi. ");
INSERT INTO tap_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeri waavyele Ashkenazi, ni Rifati, pamo ni Togarma. ");
INSERT INTO tap_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavani waavyele Elisha, ni Tarshishi, ni Kitimu, pamo ni Dodanimu. ");
INSERT INTO tap_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Babo i babikolue ba bantu baali baikeele mu bilila. Ezi i nvyalo yakua Yafeti yaali yaikeele kubalua mukowa mu kyalo kyakue. Kubalua libumba lyaali lyalanda lulimi lwakue. ");
INSERT INTO tap_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamu waavyele Kushi, ni Misri, ni Puti, pamo ni Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kushi waavyele Seba, ni Havila, ni Sabuta, ni Raama, pamo ni Sabuteka. Raama i waavyele Sheba ni Dedani. ");
INSERT INTO tap_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi waavyele Nimrodi. Ozo Nimrodi i waali kalwisia wa maka pa kyalo. ");
INSERT INTO tap_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Waali wali mbwela wa nama mwine mwine ku menso akua Yawe. Ni pakako, bantu balibalanda nangue, “Nga Nimrodi mbwela wa nama mwine mwine ku menso akua Yawe.” ");
INSERT INTO tap_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ntendeko ya bukolo bwakue yaali mu Babeli, ni mu Ereki, ni mu Akadi, pamo ni mu Kalne mu kyalo kya Sinari. ");
INSERT INTO tap_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrodi lu-aafumine koko, waile ku Asuria, wakuulako muzi wa Ninawe, ni muzi wa Rehoboti-Iri, ni muzi wa Kala, ");
INSERT INTO tap_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","pamo ni muzi ukata wa Reseni, muzi uli pa bukata bwa muzi wa Ninawe ni wa Kala. ");
INSERT INTO tap_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misri waavyele Baludia, ni Ba-anamu, ni Baleabu, ni Banafutui, ");
INSERT INTO tap_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ni Bapatrusi, ni Bakaslui. Babo i babikolue ba Bafilistini ni Bakaftori. ");
INSERT INTO tap_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani waavyele Sidona waali libeli wakue, kabili waavyele Heti. ");
INSERT INTO tap_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaani ni ye waali wali kikolue wa Bayebushi, ni Ba-amori, ni Bagirgashi, ");
INSERT INTO tap_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ni Bahivi, ni Ba-ariki, ni Basini ");
INSERT INTO tap_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ni Ba-arvati, ni Basemari, pamo ni Bahamati. Pa kyamba, nvyalo ya Bakanaani yaasalangheene. ");
INSERT INTO tap_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mipaka ya kyalo kyabo yaali yafumine ku Sidona yaile lya ku Gerasi mpaka ku Gaza. Kabili yaali yapitile lya ku Sodoma, ni lya ku Gomora, ni lya ku Adima, pamo ni lya ku Seboimu mpaka ku Lasha. ");
INSERT INTO tap_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ezi i nvyalo yakua Hamu yaali yaikeele kubalua mukowa mu kyalo kyakue. Kubalua libumba lyaali lyalanda lulimi lwakue. ");
INSERT INTO tap_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, mukuluube kwa Yafeti, i waali kikolue wa Baeberi bonse. ");
INSERT INTO tap_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shemu waavyele Elamu, ni Ashuri, ni Arpakishadi, ni Ludi, pamo ni Aramu. ");
INSERT INTO tap_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu waavyele Uzi, ni Huli, ni Geteri, pamo ni Mashi. ");
INSERT INTO tap_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakishadi waavyele Sela. Sela ni ye waavyele Eberi. ");
INSERT INTO tap_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi waavyele baana babili balalume: Umo waali wakuutua Pelegi, pantu waavyelue musita ubaakaseene kyalo mu mikoa mikoa. Ni unge wainikilue Yoketani. ");
INSERT INTO tap_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoketani waavyele Almodadi, ni Shelefu, ni Asarmaveti, ni Yera, ");
INSERT INTO tap_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ni Hadoramu, ni Uzali, ni Dikla, ");
INSERT INTO tap_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ni Obali, ni Abimaeli, ni Sheba, ");
INSERT INTO tap_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ni Ofiri, ni Avila, pamo ni Yobabu. Babo bonse baali ba mu luvyalo lwakua Yoketani. ");
INSERT INTO tap_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kyalo kibaali baikeelemo kyaali kyatendekeele ku Mesha kine ulimukuya ku Sefari ku kapili ka ku kabanga ka kyalo. ");
INSERT INTO tap_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ezi i nvyalo yakua Shemu yaali yaikeele kubalua mukowa mu kyalo kyakue. Kubalua libumba lyaali lyalanda lulimi lwakue. ");
INSERT INTO tap_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Babo bantu bonse ba mu luvyalo lwakua Noa, i ntundu yaafumine mu baana balalume bena Noa, ntundu yaasalangheene mwaya kyalo kyonse pa kyamba kya kibunda. ");
INSERT INTO tap_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pa ozo musita, bekala kyalo bonse baali balanda sie lulimi lumo ni twebo tumo. ");
INSERT INTO tap_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lubaali baya lya ku kabanga, baafikile mu lulambe lwa Sinari, ni momo i mubaikeele. ");
INSERT INTO tap_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Baalanzyaniizie nangue, “Emwe, ize tukite mabiliki ni ku-azizia bwino.” Pa kifuka kya mabue, baakitile mabiliki, ni kukuulila na kabulimbu. ");
INSERT INTO tap_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Baalandile nangue, “Tukuule muzi ni munara ufikile mu lyulu pakuti tuye twamanikile evi tekuti tukasalanghanine mwaya kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yawe waakookele kuya kumona muzi wa munara waali wakuulua na bena bantu. ");
INSERT INTO tap_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yawe waalandile evi, “Baba bantu bali mu mutundu umo, kabili balimukulanda lulimi lumo, ni ezi ikili sie ntendeko ya miilo yabo. Tekuli kyaakabanzia kukita kelia kiboomiine kukita. ");
INSERT INTO tap_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ale tukooke tuye tuvulunghanie nandilo yabo, evi tekuti bonvwane.” ");
INSERT INTO tap_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ni pakako, Yawe waabasalanghaniizie pa kyalo kyonse. Ni bo baalekeele kukuula muzi. ");
INSERT INTO tap_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Evi muzi wainikilue Babeli, pantu papo Yawe i pa-aavulunghaniizie lulimi lwa bantu bonse. Kutula papo, Yawe waabasalanghaniizie mwaya kyalo. ");
INSERT INTO tap_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ezi i nvyalo yakua Shemu. Pa kyamba kya kibunda lupaali pasyapitile myaka ibili, Shemu lu-aakumaniizie myaka 100, waavyele mwana mwalalume ni kumwinika Arpakisadi. ");
INSERT INTO tap_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Pa kyamba kya kuvyala Arpakisadi, Shemu waikeele pa kyalo myaka 500 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpakisadi lu-aakumaniizie myaka 35, waavyele Sela. ");
INSERT INTO tap_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Pa kyamba kya kuvyala Sela, Aripakisadi waikeele pa kyalo myaka 403 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela lu-aakumaniizie myaka 30, waavyele mwana mwalalume ni kumwinika Eberi. ");
INSERT INTO tap_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Pa kyamba kya kuvyala Eberi, Sela waikeele pa kyalo myaka 403 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi lu-aakumaniizie myaka 34, waavyele Pelegi. ");
INSERT INTO tap_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pa kyamba kya kuvyala Pelegi, Eberi waikeele pa kyalo myaka 430 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi lu-aakumaniizie myaka 30, waavyele Reu. ");
INSERT INTO tap_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pa kyamba kya kuvyala Reu, Pelegi waikeele pa kyalo myaka 209 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu lu-aakumaniizie myaka 32, waavyele Serugi. ");
INSERT INTO tap_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Pa kyamba kya kuvyala Serugi, Reu waikeele pa kyalo myaka 207 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi lu-aakumaniizie myaka 30, waavyele Nahori. ");
INSERT INTO tap_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Pa kyamba kya kuvyala Nahori, Serugi waikeele pa kyalo myaka 200 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori lu-aakumaniizie myaka 29, waavyele Tera. ");
INSERT INTO tap_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Pa kyamba kya kuvyala Tera, Nahori waikeele pa kyalo myaka 119 ni kuvyala bange baana balalume ni banakazi. ");
INSERT INTO tap_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera lu-aakumaniizie myaka 70, waavyele Abramu, ni Nahori pamo ni Harani. ");
INSERT INTO tap_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ezi i nvyalo yakua Tera se kwa Abramu, ni se kwa Nahori pamo ni Harani. Harani i waavyele Loti. ");
INSERT INTO tap_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani waafwiliile mu kyalo ki-aavyaliiluemo, mu Uri, muzi wa Bakaldayo. Ozo musita sibo Tera waali wakikosele. ");
INSERT INTO tap_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu waupile Sarai, Nahori ni ye waupile Milka mwana mwanakazi mwina Harani. Harani i waavyele Milka ni Iska. ");
INSERT INTO tap_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai muka Abramu taali na mwana pantu waali nghumba. ");
INSERT INTO tap_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera waamutweme mwana wakue Abramu ni mwinzikulu wakue Loti mwana mwalalume mwina Harani, pamo ni Sarai muka mwana wakue Abramu. Tera waafumine nabo mu Uri mu muzi wa Bakaldayo ni kuya nabo mu kyalo kya Kanaani. Inzi lubaafikile ku Harani, baikeele koko. ");
INSERT INTO tap_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera waafwiliile ku Harani wali na myaka 205. ");
INSERT INTO tap_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawe waamwanine Abramu nangue, “Fuma mu kyalo kyobe, sia bantu bobe pamo ni nghanda yakua so uye waya mu kyalo kindikukulangisia. ");
INSERT INTO tap_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Nene naakakukita kuba mutundu ukata, kabili naakakupaala. Naakalengia liina lyobe kumanika, ni we waakaba wali mapaalo. ");
INSERT INTO tap_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Olia waakakupaala, ni ne naakamupaala. Inzi olia waakakutiipa, ni ne naakamutiipa. Kabili ntundu yonse ya pa kyalo yaakapaalilua muli wewe.” ");
INSERT INTO tap_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abramu waafumine mu Harani nga mwaalandiile Yawe. Pa ozo musita, Abramu waali wasyali na myaka 75. Loti ni ye waile pamo nakue. ");
INSERT INTO tap_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramu waile ni mukazi wakue Sarai pamo ni Loti mwana mwalalume mwina mwalawakue Harani, kabili waatweme bunonsi bwabo pamo ni bantu babaanonkele mu Harani, ni kutendeka lwendo, waya kwingila nabo mu kyalo kya Kanaani. Lubaafikile ku Kanaani, ");
INSERT INTO tap_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramu waile waendooka mu kyalo mpaka waya kufika ku muzi wa kimuti kikata kya More kya ku Sekemu. Pa ozo musita, Bakanaani baali bakikeele sie mwenka momo mu Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yawe waamumonekeele Abramu ni kumwana nangue, “We Abramu, keki i kyalo kinaakapeela nvyalo yobe.” Ku ezio nkendo, Abramu i ku-aamukuuliile Yawe kitale. ");
INSERT INTO tap_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Abramu lu-aafumine papo, waile ku kapili ku kabanga ka muzi wa Beteli ni kuya kwimikako liema lyakue pa bukata bwa Beteli ni Ai. Beteli yaali yali ku mboosi, ni Ai yaali yali ku kabanga. Koko kwenka ku Ai, Abramu i ku-aamukuuliile Yawe kinge kitale ni kumupupa Yawe. ");
INSERT INTO tap_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kabili Abramu waatwaliliile kuya. Waile walungi ku Negebu. ");
INSERT INTO tap_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nzala luyaakilile mu Kanaani, Abramu waile kwikalanke ku Misri nga mweni. ");
INSERT INTO tap_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Lu-aali wasyafika ku Misri, waamwanine mukazi wakue Sarai nangue, “N'manine nangue wewe uli mwanakazi aweme lukebu. ");
INSERT INTO tap_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Bamisri pabaya kukumona ni kwinika nangue uli mukazi wane, baya bangipaye, ni we uye usyale wakosele. ");
INSERT INTO tap_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kansi pabaya kukwipuzia, uye ubaasuke nangue uli nkazyamwine pantu kine uye ulande evio, nakaba kusungua bwino.” ");
INSERT INTO tap_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abramu waile kufika mu Misri. Bantu ba mu Misri lubaamumwene Sarai, baamwene nangue ozo mwanakazi waali wakilile kuwama. ");
INSERT INTO tap_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Babiloolo ni bo lubaamumwene, baile kumutasiizia Likolo Farao. Kupwako, bamutwama ni kumutwala ku nghanda yakua Farao. ");
INSERT INTO tap_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Farao waamukitiile Abramu bintu biweme pa mulandu wakua Sarai, ni pakako waapeelue mikooko ni nghombe, ni punda ndume ni ikota, ni ba bombi balalume ni banakazi, pamo ni nghamia. ");
INSERT INTO tap_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Inzi Yawe waamulwalikile Farao pamo ni bantu ba mu nghanda yakue, pantu waamutweme Sarai muka Abramu kuti aye wali mukazi wakue. ");
INSERT INTO tap_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Farao waamukuutile Abramu ni kumwipuzia nangue, “Abramu, ni kiki kiwakinkitila? Ale wakinghaninaki nangue Sarai te mukazi obe? ");
INSERT INTO tap_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ale kabili wakilandilaki nangue Sarai ni nkaziizo? Wewe i wakilengia nene n'mutwame ni kumwalula mukazi wane. Ewe, mutwame mukazi obe uye waya.” ");
INSERT INTO tap_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farao wa-anine bantu bakue bamuseekezie Abramu ni mukazi wakue pamo ni bintu byonse bi-aali nabio. ");
INSERT INTO tap_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramu ni mukazi wakue pamo ni byonse bi-aali nabio, baafumine ku Misri ni kuya ku Negebu. ");
INSERT INTO tap_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu waakilile kuba munonsi wa biteekua, ni wa mutofue pamo ni wa oro. ");
INSERT INTO tap_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Waafumine ku Negebu mpaka waya kufika ku Beteli, palia paali waimikilenke liema lyakue pa bukata bwa Beteli ni Ai. ");
INSERT INTO tap_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Papo i paali ni kitale ki-aakuulile pa mambo. Pa ezio nkendo Abramu i paali wamupupila Yawe. ");
INSERT INTO tap_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti waile pamo ni Abramu, ni ye waali wakwete bisepe bya nghombe ni mikooko, kabili waali wakwete ni maema. ");
INSERT INTO tap_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Inzi nkendo ya kulisiiziamo nama yabo yaamwenekele kukeepa, pantu baali bateekele nama ingi. Ni keki i kyaalengele tekuti bekale pamo. ");
INSERT INTO tap_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Basungi ba biteekua byakua Abramu ni basungi ba biteekua byakua Loti baatendekele kukankabula. Ozo musita Bakanaani ni Baperizi, baali bakikeele sie mu kekio kyalo. ");
INSERT INTO tap_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abramu Waamwanine Loti, “Ewe, mona fwefue tuli benenke. Bantu bobe ni bantu bane, tebapalile kuya bakankabula. ");
INSERT INTO tap_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ni pakako, namona kuti tulekenkane. Saakula nkendo i utonene. Kine ulikuya lya kuso, nene ndikuya lya kulio, kine ulikuya lya kulio, nene ndikuya lya kuso.” ");
INSERT INTO tap_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti waakentele ni kumona lulambe lonse lwa Yordani, mpaka ku Zoari kwaali kwali menda engi nga bukaba bwakua Yawe, ao nga kyalo kya Misri. Pa ozo musita Yawe waali tanainoone mizi ya Sodoma ni Gomora. ");
INSERT INTO tap_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti waasaakwile lulambe lonse lwa Yordani ni kuya lya ku kabanga. Evi i vibaalenkenkeene. ");
INSERT INTO tap_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu waikeele mu kyalo kya Kanaani. Loti wene waikeele pa bukata bwa mizi mu lulambe ni kwimika maema akue pepi ni Sodoma. ");
INSERT INTO tap_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Inzi bantu ba mu Sodoma baali bali babi ni ba bibalo bingi ku menso akua Yawe. ");
INSERT INTO tap_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti lu-aile, Yawe waamwanine Abramu nangue, “Kenta lya ku nkungua ni lya ku nkungulua, kabili kenta lya ku kabanga ni lya ku mboosi.” ");
INSERT INTO tap_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yawe wamwanine Abramu nangue, “Keki kyalo kyonse kiwamona, naakakupeela wewe ni nvyalo yobe kuti kikabe kyenu lonse. ");
INSERT INTO tap_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Naakakita nvyalo yobe kuba nga lufunko lwa pa kyalo, nvyalo isikavinda kupendua na muntu. Inzi kine muntu waakavinda kupenda lufunko lwa pa kyalo, ni vyalo yobe waakavinda kuipenda. ");
INSERT INTO tap_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ale endo waya mu kuleepa ni mu kutana kwa kyalo pantu i kindikukupeela.” ");
INSERT INTO tap_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abramu waakuusiizie liema ni kuya kwikala pepi na bimuti bya Mamure ku Hebroni ni kukuulako kitale kyakua Yawe. ");
INSERT INTO tap_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Amrafeli likolo wa ku Sinari, ni Arioki likolo wa ku Elasari, ni Kedori-Laomeri likolo wa ku Elamu, pamo ni Tidali likolo wa ku Goimu, ");
INSERT INTO tap_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","baile kulua na Bera likolo wa ku Sodoma, ni Birsa likolo wa ku Gomora, ni Sinabu likolo wa ku Adima, ni Semeberi likolo wa ku Zeboimu, pamo ni likolo wa ku Bela (i Zoari). ");
INSERT INTO tap_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Azo makolo asaano pamo ni balukale babo baakolongheene mu lulambe lwa Sidimu. Pa ono musita i muli Lyezi lya Mukele. ");
INSERT INTO tap_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Azo makolo aabombeele likolo Kedori-Laomeri myaka lyanondo ni ibili. Inzi mu mwaka wa lyanondo ni itatu, azo makolo aasangukile. ");
INSERT INTO tap_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mu mwaka wa lyanondo ni ina, Kedori-Laomeri ni makolo a-aunvwene nao pamo ni balukale babo, baumine Barifaimu mu Hasteroti-Karnaimu, ni Bazuzimu mu Hamu, ni Baemi mu Sawe-Kiriataimu, ");
INSERT INTO tap_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ni Bahoriti ku lupili lwa Seiri. Baile babakumbile mpaka kubafikia ku Eli-Parani pepi ni kaseeba. ");
INSERT INTO tap_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kabili baabweleele ku Eni-Misipati (kulikwakuutua Kadeshi), baumine kyalo kya Ba-amaleki, ni Ba-amori baali baikeele mu Hasasoni-Tamari. ");
INSERT INTO tap_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kabili likolo wa ku Sodoma, ni wa ku Gomora, ni wa ku Adima, ni wa ku Zeboimu, pamo ni wa ku Bela (i Zoari), baile kutantama mu lulambe lwa Sidimu pakuti balue nabo. ");
INSERT INTO tap_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedori-Laomeri likolo wa ku Elamu, ni Tidali likolo wa ku Goimu, ni Amrafeli likolo wa ku Sinari, pamo ni Arioki likolo wa ku Elasari. Aza makolo ana aile kulua na makolo asaano. ");
INSERT INTO tap_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mu lolo lulambe lwa Sidimu mwaali mwali biina bingi bya kabulimbu. Likolo wa ku Sodoma ni wa ku Gomora lubaabutukile, baile kuponena mu biina. Inzi babo bange batatu baabutukiile ku mpili. ");
INSERT INTO tap_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Azo makolo ana aatweme bunonsi bonse bwa mu Sodoma ni mu Gomora pamo ni bilio ni kuya nabio. ");
INSERT INTO tap_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loti mwina mwalawakue kwa Abramu waali waikeele mu Sodoma, ni ye kumo waatwaminiinue pamo ni bintu byakue. ");
INSERT INTO tap_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kwaali muntu umo waabutukile ku bobo bului ni kuya kutwala mpunda kuli Abramu. Abramu waali Muebrania waali waikeele pepi na bimuti byakua Mamure Muamori wa kwakue kwa Eskoli, ni wa kwakue kwa Aneri. Baba i baali bamukwasia Abramu. ");
INSERT INTO tap_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramu lu-aunvwile nangue mwana mwina mwalawakue akwetue, waakolonghaniizie balalume 318 ba mu nghanda yakue, bantu baali basambiliziiziwe bului. Baile babakonkele mpaka ku Dani. ");
INSERT INTO tap_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Musita wa busiku, Abramu waabasalanghaniizie bantu bakue mu mabumba mabumba ni kuya kusakukila balwani babo. Waaboomine ni kubakumba mpaka ku Hoba, ku nkungua ya Damaski. ");
INSERT INTO tap_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ni pakako, waabweziizie bintu byonse, ni kumubwezia Loti mwina mwalawakue pamo ni bintu byakue byonse. Kabili waabweziizie banakazi pamo ni bange bantu. ");
INSERT INTO tap_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramu lu-aafumine ku kuuma balwani bakue, Kedori-Laomeri pamo ni ange makolo a-aunvwene nao, likolo wa ku Sodoma waile kusensekela Abramu mu lulambe lwa Sawe (ao Lulambe lwakua Likolo). ");
INSERT INTO tap_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ni Melkisedeki waali likolo wa ku Salemu, kabili waali kitambua wakua Leza Kabezia Mpungu, waatwele mukate ni divai kuli Abramu, ");
INSERT INTO tap_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ni kumupaala walimukulanda nangue, “Abramu apaalue na Leza Kabezia Mpungu, Kalenga wa lyulu ni kyalo! ");
INSERT INTO tap_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Alumbue Leza Kabezia Mpungu waakupeele maka a kuuma balwani bobe!” Abramu ni ye waamupeele Melkisedeki kamo ka pa lyanondo ka pa bintu byonse. ");
INSERT INTO tap_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Likolo wa ku Sodoma waamwanine Abramu, “N'mpeeleko sie bantu we usyale ni bobo bunonsi.” ");
INSERT INTO tap_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abramu wa-anine likolo wa ku Sodoma nangue, “Nene nalapa ntanzi yakua Yawe Leza Kabezia Mpungu, Kalenga wa lyulu ni kyalo ");
INSERT INTO tap_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nangue, nene nsitwamapo kantu pa bintu byobe byonse, anzia kine ni nyunzi ao mukonda wa pa nkwabilo, evi tekuti ukalande nangue, ‘Nene i waamunonsiizie Abramu.’ ");
INSERT INTO tap_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Inzi wewe lipako sie bilio byaaliile balukale ni kulipa bantu bankwasiizie: Aneri, ni Eskoli, pamo ni Mamure, evi baye nabio.” ");
INSERT INTO tap_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bebio byonse lubyaapitile, Yawe waamwanine Abramu mu kimonua nangue, “Tekutiina pantu nene ndi kisoolelo kyobe ni kilambu kyobe kikata.” ");
INSERT INTO tap_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abramu waipuziizie evi, “We Yawe Kabezia Mpungu, waakan'mpeelaki? Pantu nene nsili na mwana. Kubako Eliezeri wa ku Damaski i waakapyana bintu byane?” ");
INSERT INTO tap_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abramu waalandile evi, “Mona nene tewan'mpeele luvyalo. Kansi ozu mubombi wa mu nghanda yane i waakaba mupyani wa bintu byane!” ");
INSERT INTO tap_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yawe waamwanine Abramu nangue, “Ozu mubombi takaba mupyani wa bintu byobe, inzi mwana obe mwalalume wakwivyalila i waakaba mupyani wa bintu byobe!” ");
INSERT INTO tap_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yawe waamufumiiziizie Abramu panze ni kumwana nangue, “Ale kenta mu lyulu upende ntanda kine uli kuvinda kupenda.” Kabili wamwana nangue, “Evi nvyalo yobe i viyaakaba yavulile.” ");
INSERT INTO tap_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abramu waamuketekeele Yawe. Ni pakako, Yawe waamumwene wali mulunghami. ");
INSERT INTO tap_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kabili waamwanine evi, “Mona nene ndi Yawe waakufumiizie mu Uri mu kyalo kya Bakaldayo ni kukupeela keki kyalo kuti kibe kyobe.” ");
INSERT INTO tap_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abramu waipuziizie evi, “We Yawe Kabezia Mpungu! Ale kuti namana syani nangue kyaakaba kyane?” ");
INSERT INTO tap_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yawe waamwasukile evi, “Ale n'mpeelepo nghombe musoka wa myaka itatu, ni mbuzi mukota wa myaka itatu, ni mpanga wa myaka itatu, ni kibondo kya nkunda pamo ni kya kipeele.” ");
INSERT INTO tap_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abramu waatweme nama, waibazula pa bukata, ni kubiika bibazu byakenteene. Inzi byoni byene taabibazwile. ");
INSERT INTO tap_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ni makubi lu-aakookeele pa bibazu bya nama, Abramu wa-akumbile. ");
INSERT INTO tap_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Koba lukaali kasyazimina, Abramu waonene tulo tukata, kabili waunvwile mwezo wa nfinzi ikata. ");
INSERT INTO tap_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yawe waamwanine evi, “Nvyalo yobe yaakaba yeni mu kyalo nghwana, kabili baakaba bazia ba bene kyalo, ni bo baakeemiwa na bene kyalo myaka 400. ");
INSERT INTO tap_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Naakakanda ntundu yaakabateeka buzia, ni pa kyamba, baakafuma batweme bunonsi bwingi. ");
INSERT INTO tap_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Inzi wewe waakafua wali ni mutende. Kabili waakaziikua wali ni bukote buweme. ");
INSERT INTO tap_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ni luvyalo lwa buna lwaakabwelela pano pantu bubi bwa Ba-amori tebunaakumane.” ");
INSERT INTO tap_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Koba lukaazimiine, paizile nfinzi ikata. Kyunsi kikata pamo ni libeebe lyaamwenekele lyalimukupita pa bukata bwa bibazu bya nama. ");
INSERT INTO tap_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Bobo busiku Yawe waakitile kipingo ni Abramu ni kumwana nangue, “Napeela keki kyalo ku nvyalo yobe kutula ku lyezi lya ku Misri mpaka ku mwenzi ukata wa Efrati, ");
INSERT INTO tap_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","pamo ni ku kyalo kya Bakeni, ni kya Bakenesi, ni kya Bakadmoni, ");
INSERT INTO tap_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ni kya Bahiti, ni kya Baperizi, ni kya Barefaimu, ");
INSERT INTO tap_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ni kya Ba-amori, ni Kya Bakanaani, ni kya Bagirgasi, pamo ni kya Bayebusi.” ");
INSERT INTO tap_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai muka Abramu waali wali nghumba. Inzi abanga wali ni mubombi umo mukazyana Mumisri liina lyakue Hagari. ");
INSERT INTO tap_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai waamwanine Abramu nangue, “Unvua, Yawe tan'mpeele luvyalo lwa kuvyala baana, kansi laala sie na ozu mubombi wane pantu pange waakanvyalila mwana.” Abramu waitabiile. ");
INSERT INTO tap_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai muka Abramu waabuulile mubombi wakue Hagari wa ku Misri ni kumupeela Abramu kuti aye wali mukazi mwanike. Bebi bintu byaakitikile Abramu lu-aali wasyaikeele myaka lyanondo mu Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramu waaleele na Hagari, ni ye waimita. Hagari lu-ainikile nangue waimita, Sarai waamwenekele wa mpuni kuli Hagari. ");
INSERT INTO tap_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai waamwanine Abramu, “Bubi bwane bube pali wewe. Nene naakupeele mubombi wane mu nkulo yobe. Inzi lu-akimona nangue waimita, wakin'mona wampuni. Yawe atupingule, nene ni wewe!” ");
INSERT INTO tap_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramu ni ye waamwanine Sarai, “Mona mubombi obe ali mu minue yobe, mukitile muutoneene.” Sarai waamwemizie, ni ye mpaka wamubutuka. ");
INSERT INTO tap_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaika wakua Yawe waamusangile Hagari mu kaseeba pa kasulo ka menda, kasulo kaali mumbali nzila yaali yaile ku Suri ");
INSERT INTO tap_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ni kumwana nangue, “We Hagari mubombi wakua Sarai, ulimukufuma pi? Kabili ulimukuya pi?” Wene wa-asukile evi, “N'mbutukile yangulenzi Sarai.” ");
INSERT INTO tap_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malaika wakua Yawe waamwanine evi, “Bwela uye umunakile nokolenzi.” ");
INSERT INTO tap_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kabili malaika wakua Yawe waamwanine evi, “Naakasandulula nvyalo yobe, ni yo teikapendeka kukonkana ni viyaakaba yavulile.” ");
INSERT INTO tap_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malaika wakua Yawe waamwanine evi, “Mona wewe wimisi, wakaba kuvyala mwana mwalalume, kabili wakaba kumwinika liina lyakue Isimaeli pantu Yawe wakyunvua malilo a maavia obe. ");
INSERT INTO tap_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ni ye waakaba nga punda wa mu kisonso pakati ka bantu. Waakaba mulwani wa bantu bonse, ni bantu bonse baakaba balwani bakue, ni bwikazi bwakue bwaakaba bwa bulwani ku lupwa lwakue lonse.” ");
INSERT INTO tap_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagari waakuutile Liina lyakua Yawe u aalandile nakue. “Wewe uli Leza Aliwan'mona.” (Mu Kiebrania ni El-Roi) Pantu waalandile evi, “Na mumona aliwan'mona.” ");
INSERT INTO tap_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ni pakako, keki kiina kya menda i kikilikyakuutilua Beer-Lahai-Roi, ni kyo kili pa bukata bwa Kadesi ni Beredi. ");
INSERT INTO tap_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagari waamuvyaliile Abramu mwana mwalalume, Abramu waamwinikile Isimaeli olia mwana waavyelue na Hagari. ");
INSERT INTO tap_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu waali na myaka 86 lu-aavyaliilue Isimaeli na Hagari. ");
INSERT INTO tap_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramu lu-aakumaniizie myaka 99, Yawe waamumonekeele ni kumwana nangue, “Nene ndi Leza wa Maka onse, enda ku ntanzi yane ni kuba wapwililikile. ");
INSERT INTO tap_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ni ne naakakita kipingo kyane pakati kane ni wewe, kabili naakakila kusandulula nvyalo yobe.” ");
INSERT INTO tap_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kupwako, Abramu walaala kyuba, ni Leza waamwana nangue, ");
INSERT INTO tap_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nene nakita kipingo ni wewe, ni we waakaba kikolue wa ntundu ingi. ");
INSERT INTO tap_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Teukikakuutua kabili Abramu, inzi waya wasyakuutua Abrahamu pantu nakukita kuba kikolue wa ntundu ingi. ");
INSERT INTO tap_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Naakavuzia nvyalo yobe, naakakukita kuba ntundu, ni makolo aakafuma muli wewe. ");
INSERT INTO tap_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Naakeemika kipingo pakati kane ni wewe, ni pakati ka nvyalo yobe ya ku ntanzi pamo ni nvyalo yabo kuti kikabe kipingo kya muyayaya. Pantu naakaba Leza obe, ni Leza wa luvyalo lobe lwa ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Keki kyalo kimwikeelemo mwali baeni, kyalo kyonse kya Kanaani, naakakupeela wewe pamo ni luvyalo lobe lwa ku ntanzi kuba bupyani bwa muyayaya, ni nene naakaba Leza wabo.” ");
INSERT INTO tap_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Leza waamwanine Abrahamu, “Ni we ukasunge bwino kipingo kyane, wewe pamo ni luvyalo lobe lwa ku ntanzi pamo ni nvyalo yabo. ");
INSERT INTO tap_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ni keki i kipingo kimwakaba kusunga pakati kenu, wewe ni luvyalo lobe lwa ku ntanzi. Kubalua mwalalume pakati kenu apalile kuteetua yando. ");
INSERT INTO tap_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mukabe mwateeta yando. Kaka i kaakaba kalangi ka kipingo pakati kane ni mwemue. ");
INSERT INTO tap_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mwana mwalalume wa nsiku mwanda pakati kenu apalile kuteetua yando, pamo ni olia avyelue mu nghanda yobe ao asitilue na nfolanga, ni kubalua mweni asili wa mu luvyalo lobe. ");
INSERT INTO tap_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Olia avyelue mu nghanda yobe, ni asitilue na nfolanga yobe apalile kuteetua yando, kako i kalangi kaakaba ku mibili yenu, kalangi ka kipingo kyane kya muyayaya. ");
INSERT INTO tap_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ni mwalalume asiteetelue yando, waakafumiiwa pa ba kwakue pantu enoonene kipingo kyane.” ");
INSERT INTO tap_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Leza waamwanine Abrahamu nangue, “Sarai mukazi obe teukiya wamukuuta Sarai, inzi waya wasyamukuutua Sara. ");
INSERT INTO tap_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Naakamupaala, kabili naakakupeela mwana kupitila muli wene. Naakamupaala, ni ye waakaba nghina wa ntundu, ni makolo a bantu aakafuma muli wene.” ");
INSERT INTO tap_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahamu waaponene kyuba, waasekele ni kulandila mu mutima nangue, “Ati emwe! Ni kiine muntu wasyali na myaka 100 kuti wavyala ni mwana? Ni Sara ozu asyali na myaka 90 kuti wavyala?” ");
INSERT INTO tap_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahamu waamwanine Leza nangue, “Kansi nga wamuleka Isimaeli apokelele bulayo bobe.” ");
INSERT INTO tap_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Inzi Leza waamwanine evi, “Ata, mukazi obe Sara waakakuvyalila mwana mwalalume, ni wewe waakamwinika liina lyakue Izaaki. Naakeemika sinta kipingo kyane pali wene ni nvyalo yakue kuti kikabe kya muyayaya. ");
INSERT INTO tap_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ni palwakua Isimaeli, nakikunvua. Naakamupaala ni kumusandulula. Kabili naakakila kumuvuzia. Waakavyala bakulu lyanondo ni babili, kabili naakamukita kuba mutundu ukata. ");
INSERT INTO tap_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Inzi keki kipingo kyane naakakiimika sinta na Izaaki uwaakavyalilua na Sara pa musita nga ono ozu mwaka ulimukwiza.” ");
INSERT INTO tap_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kupwako, Leza walekela kulanda na Abrahamu, wamusia. ");
INSERT INTO tap_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Bobo bwenka busiku, Abrahamu waamutweme Isimaeli pamo ni bonse baavyaliilue mu nghanda yakue, ni bonse baasitilue na nfolanga yakue, balalume bonse ba mu nghanda yakua Abrahamu, ni kuya kubateeta yando nga mwa-aniinue na Leza. ");
INSERT INTO tap_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu waateetelue yando wasyali na myaka 99. ");
INSERT INTO tap_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Mwana wakue Isimaeli ni ye waateetelue yando wasyali na myaka 13. ");
INSERT INTO tap_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Bobo bwenka busiku Abrahamu ni Isimaeli mwana wakue baateetelue yando. ");
INSERT INTO tap_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Bantu bonse ba mu nghanda yakue, pamo ni baavyaliilue mu nghanda yakue, ni baasitilue na nfolanga ku baeni, baateetelue yando pamo nakue busiku bumo. ");
INSERT INTO tap_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kabili Yawe waamumonekeele Abrahamu lya ku bimuti bikata byakua Mamure lu-aali waikeele mu mulyango wa liema koba lukaali kazangukile. ");
INSERT INTO tap_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahamu waakentele ni kumona bantu batatu baimeene ku ntanzi yakue. Ni lu-aabamwene, waafumine lubilo mu mulyango wa liema ni kuya kusaakaana nabo. Kupwako, wafwinamina pansi ");
INSERT INTO tap_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ni kulandapo na umo nangue, “We mulopue wane, kine kuti wangitabizia, nakulomba tekuti mupitilile pa mubombi wenu. ");
INSERT INTO tap_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Pembelenke muleetelue menda aniini a kusamba ku makasa enu mane mutuuzie mwinsina kimuti, ");
INSERT INTO tap_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","n'mileetele ni ka kulia evi muteekieko mitima yenu, pa kyamba mane mulunduluke ni lwendo lwenu pantu mwaizanga kuli mubombi wenu.” Ni bo baalandile evi, “Ale kita muwalandila.” ");
INSERT INTO tap_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kupwako, Abrahamu waya lubilo lubilo mu liema ni kumwana Sara nangue, “Ewe, lenga uye uleete kilo 25 ya bunga buwamiisie ulenge ukite mikate.” ");
INSERT INTO tap_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kabili penka papo, wakundukila koko kwaali kisepe kya nghombe, watwamapo nghombe musoka enine ni kumutwala ku babombi balenge bamusinze. ");
INSERT INTO tap_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Waabuulile mafuta ali afuma ku mabeele a nghombe, ni mabeele a kumina pamo ni bipusa byeleke, waya kubatwalila ku baali baikeele. Lubaali balimukulia, Abrahamu waali waimeene pambali mwinsina kimuti. ");
INSERT INTO tap_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Baamwipuziizie Abrahamu, “Ewe, mukazi obe ali pi?” Wa-asukile nangue, “Ali mu liema.” ");
INSERT INTO tap_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yawe waalandile evi, “Kisinka nakaba kwiza kabili ozu mwaka waiza pa ono wenka musita, ni Sara mukazi obe wakaba kuvyala mwana mwalalume.” Sara ni ye waali waimeene ku kyamba kyakue lya ku mulyango watwiliziizie. ");
INSERT INTO tap_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamu ni Sara baali basyakilile kukota, ni musita wakuvyala waali wasyapitile. ");
INSERT INTO tap_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara lu-aunvwile evio, waasekeele sie mu mutima walanda nangue, “Kubako nasyakotele evi kuti nawaminua kulaala ni mulume wane mukote?” ");
INSERT INTO tap_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yawe waamwipuziizie Abrahamu, “Sara, wasekelaki evi ni kulanda nangue, ‘Kubako evi kuti navyala ni mwana nasyakotele?’ ");
INSERT INTO tap_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Eba, kuli ni kintu kili kya-anda kuli Yawe? Naakeeza kabili ozu mwaka waiza nga munalandilanga. Naakeeza kusanga mukazi obe Sara wavyele mwana mwalalume.” ");
INSERT INTO tap_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara waakeene walanda nangue, “Nsisekele.” Pantu waali waunvwile mwezo. Inzi Yawe waamwanine evi, “Wasekanga.” ");
INSERT INTO tap_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Balia bantu baafumine papo ni kulunghama lya ku Sodoma. Abrahamu waile kubaseekezia. ");
INSERT INTO tap_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yawe waalandile evi, “Nene nsivinda kumufiika Abrahamu bintu binghumiine kukita. ");
INSERT INTO tap_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Pantu kulanda kisinka Abrahamu waakaba mutundu ukata waakaba walumine, ni muli wene ntundu yonse ya pa kyalo yaakapaaliluamo. ");
INSERT INTO tap_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pantu naamusaakwile kuti akabaane baana bakue pamo ni nghanda yakue pa kyamba kyakue kuti bakasunge nzila yakua Yawe, ni kukita nsambu pamo ni bupinguzi, pakuti Yawe ni ye akafikilizie bintu byonse bi-aamulaile Abrahamu.” ");
INSERT INTO tap_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yawe waalandile evi, “Pantu malilo a mu Sodoma ni mu Gomora akila, ni bibalo byabo byakila kuvula, ");
INSERT INTO tap_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ndikukookelako ngie n'mone kine kibalimukukita kipaleene ni malilo anakyunvua, kine te evio nakaba kumana.” ");
INSERT INTO tap_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Babo bantu babili baafuminepo ni kuya lya ku Sodoma, inzi Abrahamu waali wakiimeene ni Yawe. ");
INSERT INTO tap_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahamu waamupaleeme walanda nangue, “Ati, ni kiine wakaba kulovia bonse mulunghami ni mubi? ");
INSERT INTO tap_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kine mu muzi muli balunghami 50, wakaba kulovia muzi onse? Teukaba kubeeleela pa mulandu wa babo balunghami 50? ");
INSERT INTO tap_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nakupaapaata tekuti uye wipailile mulunghami pamo ni mubi, evi mulunghami tekuti aye wali nga mubi. Tekuti ukabe kukita evio. Eba, Mupinguzi wa kyalo kyonse tavinda kupingula mu nsambu?” ");
INSERT INTO tap_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yawe wa-asukile evi, “Kine naya kusangamo balunghami 50 mu Sodoma, nakaba kweleela muzi onse pa mulandu wabo.” ");
INSERT INTO tap_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahamu waalandile evi, “Natwalilila kulanda na Mulopue ne ali sie lufunko, kabili nali mito. ");
INSERT INTO tap_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ale kine pabula basaano pa balia balunghami 50, wakaba kulovia muzi onse pantu papusa bantu basaano?” Mulopue wa-asukile evi, “Kine naya kusangamo balunghami 45 nene nsikaba kulovia muzi.” ");
INSERT INTO tap_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kabili Abrahamu waipuziizie evi, “Ale kine bali sie 40?” Waamwasukile, “Kine bakabe 40, nsikakita kantu pa mulandu wa baba bantu 40.” ");
INSERT INTO tap_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahamu waalandile evi, “We Mulopue, tekufiitua. Ntonene nandepo kabili. Ale kine bali sie balunghami 30?” Waamwasukile, “Nsikakita kantu pa mulandu wa baba bantu 30.” ");
INSERT INTO tap_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahamu waalandile evi, “Natwalilila kulanda na Yawe, ale kine bali sie 20?” Waamwasukile, “Kine bali 20 nene nsikaba kubalovia.” ");
INSERT INTO tap_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahamu waalandile evi, “We Yawe, napaapaata tekufiitua. N'mpeleeziepo sie limo. Ale kine bali sie lyanondo?” Waamwasukile, “Kine bali lyanondo nsikaba kubalovia.” ");
INSERT INTO tap_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yawe lu-aapwile kulanda na Abrahamu, Waile. Abrahamu ni ye waabwelele kwakue. ");
INSERT INTO tap_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bobo bwenka busiku kyungulo, balia bamalaika babili baafikile mu Sodoma. Loti waali waikeele pa mulyango wa muzi wa Sodoma. Lu-aabamwene, waile kubasensekela. Lu-aafikile pa baali, waaleele kyuba ");
INSERT INTO tap_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ni kubaana nangue, “Mwe balopue bane, namipaapaata twende mwingile mu nghanda yakua mubombi wenu, mulaale musambe ni ku makasa, mane lukeele lukeelekeele paakili mukatwalilile mu lwendo lwenu.” Ba-asukile evi, “Abe, fwefue tulikupunga sie pano penka panze.” ");
INSERT INTO tap_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Inzi Loti waatwaliliile kubapaapaata mpaka bamwitabila ni kuya kwingila mu nghanda yakue. Loti waateaniizie matebeto, wabaapikila mikate isiliko ntutumusi. Ni bo balia. ");
INSERT INTO tap_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Babo baeni lubaali tebanalaale, bantu ba mu Sodoma, balumendo ni bakote, baizile kuzyungulukila nghanda yaalimo baeni. ");
INSERT INTO tap_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Baamwipuziizie Loti, “Balia baeni bawapokelanga keno kyungulo bali pi? Bafumiizie pano tupungule nabo.” ");
INSERT INTO tap_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti waafumiine panze ni kusia waizalako. ");
INSERT INTO tap_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Loti waabapaapaatile walanda nangue, “Mwe ba kwane, tekubakitile bintu bibiipile evio! ");
INSERT INTO tap_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Unvue, ndi ni babinundue bane babili. Namipaapaata n'mbaleete kuli mwemue kuti mubakitile mumutoneene. Inzi tekuti mupungule na baeni, pantu basungilue bwino mu nghanda yane.” ");
INSERT INTO tap_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bene baalandile evi, “Wewe uli mweni mu ono muzi wetu! Eba, tewakeba kutupingula? Tupisie, kine wakaana, fwefue tulikukukitila kibiipile kukila baeni bobe.” Baamutintiile ku mulyango bakebele kupantula mulyango. ");
INSERT INTO tap_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Inzi baeni bakua Loti baizwile mulyango, bamukulila Loti mukati ni kwizalako. ");
INSERT INTO tap_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Babo bantu baali panze, bakulu ni banike, bauminue kafiifi na baeni bakua Loti mpaka ba-andua kumona mulyango. ");
INSERT INTO tap_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Balia bantu babili baamwanine evi, Loti, “Kine mu ono muzi ulimo ni baana balalume ni baana banakazi, pamo ni bako bobe ao bantu ba kobe, baane bafumemo ");
INSERT INTO tap_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","pantu fwefue tulikwinoona ono muzi. Yawe wakyunvua malilo a ono muzi. Ni pakako, wakitwana kwiza kwinoona ono muzi.” ");
INSERT INTO tap_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Loti waile kubaana balumendo baali basakile baana bakue nangue, “Lenge mufume mu ono muzi pantu Yawe alikwinoona ono Muzi.” Inzi bene baali baizi nangue alimukubasekia sie. ");
INSERT INTO tap_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lubwaali bwasyakia, bamalaika baamwanine evi, Loti, “Lenga ufumie mukazi obe ni baana bobe banakazi mukeeza kulobelela mu bubi bwa ono muzi.” ");
INSERT INTO tap_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loti lu-aali wasyatuubatuuba, bamalaika baamusakatiile ku kuboko kwakue ni kwa kwakua mukazi wakue pamo ni ku maboko a baana bakue banakazi babili pantu Yawe waamunvwiliile nkumbu. Baabafumiiziizie kunze ya muzi. ");
INSERT INTO tap_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kupwako, malaika umo wamwana nangue, “Butuka wipususie, tekwikebuka ao kwimana mu lulambe, butukila ku mpili ukeeza kuloba.” ");
INSERT INTO tap_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Inzi Loti wa-asukile evi, “We mulopue, evio abe. ");
INSERT INTO tap_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mona, mubombi obe wamulanga buwame ni kumunvwila nkumbu mu kumupususia. Ni pakako, nsibutukila ku lupili nkakitikilua na kibiipile ni kufua. ");
INSERT INTO tap_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mona muzi uniini ozu uli papa pepi wa kubutukilamo. Eba, te uniini? Nakupaapaata ungitabizie, n'mbutukilemo, ngiipususie.” ");
INSERT INTO tap_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Waamwasukile, “Ni makola, nakwitabizia nsikaba kwinoona ozo muzi. ");
INSERT INTO tap_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Malaika waamwanine evi, Ale lenga ubutukilemo pantu nsivinda kukita kantu lu-usinafike ku ozo muzi.” Ni pakako, ozo muzi wainikilue Zoari. I kulanda nangue “kaniini.” ");
INSERT INTO tap_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loti lu-aafikile ku Zoari, koba kaali kasyatulile. ");
INSERT INTO tap_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kupwako, Yawe wanokia nvula ya mulilo mu muzi wa Sodoma ni wa Gomora, mulilo wa kibiliti kufuma mwiulu mwa Yawe. ");
INSERT INTO tap_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ni kulovia ezio mizi pamo ni lulambe lonse, ni bantu bonse baali balimo pamo ni byonse byaali byamenenemo. ");
INSERT INTO tap_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Inzi muka Loti waali pa kyamba, waikebukile ni kwaluka lipumpu lya mukele. ");
INSERT INTO tap_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Lukeele lwakue lukeelekeele, Abrahamu waile pa kifuka pa-aali waimeene ntanzi yakua Yawe. ");
INSERT INTO tap_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Waakentele lya ku Sodoma ni lya ku Gomora ni mu lulambe lonse, waamwene kyunsi kyaafutumuka nga kyunsi kya mu kikuka kya mulilo. ");
INSERT INTO tap_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Leza lu-ainoonene mizi ya mu lulambe yaali yaikeelemo Loti, Leza waalangulukile Abrahamu ni kumupususia Loti. ");
INSERT INTO tap_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti ni baana bakue banakazi babili baile kwikala ku mpili mu lisele pantu waatiinine kwikala mu Zoari. ");
INSERT INTO tap_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mwana mukulu waamwanine mwalawakue nangue, “Situe wakota, kabili kono kutuli tekuli mwalalume wakutuupa kukonkana ni mibeele ya pa kyalo. ");
INSERT INTO tap_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kansi tumuminie situe divai, ni fwe tulaale nakue pakuti tumusungile situe luvyalo.” ");
INSERT INTO tap_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Baamuminizie sibo divai bobo busiku, mwana mukulu waingiile ni kukumana nakue. Inzi Loti wene taamanine lwaaleele mwana ni lu-aabuukile. ");
INSERT INTO tap_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Busiku bwaakonkelepo, mwana mukulu waamwanine mwalawakue, “Mona lukeele naakilaala ni tawe, kansi kabili tumuminie situe divai bono busiku, evi ni wewe uye ulaale nakue evi tusunge luvyalo lwakua situe.” ");
INSERT INTO tap_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Baamuminiizie sibo divai, ni bobo busiku, mwana mwanike ni ye waile kulaala na se. Loti taamanine lwaleele mwana ni lu-aabuukile. ");
INSERT INTO tap_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Evi i vyaimitile baana banakazi babili kuli sibo. ");
INSERT INTO tap_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mwana mukulu mwina Loti waavyele mwana mwalalume ni kumwinika Moabu. Ozo mwana i kikolue wa Bamoabu ni lenu kumo. ");
INSERT INTO tap_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mwana mwanike mwina Loti ni ye waavyele mwana mwalalume ni kumwinika Beni-Ami. Ozo mwana i kikolue wa Ba-amoni ni lenu kumo. ");
INSERT INTO tap_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu waafumine papo ni kuya ku kyalo kya Negebu, waile kwikala pa bukata bwa Kadesi ni Suri. Pa kyamba waile kwendela mu Gerari. ");
INSERT INTO tap_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abrahamu waalandile palua mukazi wakue Sara nangue, “Ozu ni nkazyamwine.” Abimeleki Likolo wa mu Gerari wa-anine bantu bamuleetele Sara. ");
INSERT INTO tap_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Inzi Leza waamumonekeele Abimeleki busiku mu kilooto ni kumwana nangue, “Unvua, wafua wewe! Pantu watwamanga muka nghwana.” ");
INSERT INTO tap_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleki ni ye waali tanapalamane nakue. Waamwanine evi, “Ati we Mulopue, ulikwipaya ntundu isili na mulandu? ");
INSERT INTO tap_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Wene wakinghana nangue, Sara ni nkaziize. Mwanakazi ni ye wakinghana nangue, Abrahamu ni ndumeze. Nakikita evi na mutima waswetele.” ");
INSERT INTO tap_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Leza waamwanine Abimeleki mu kilooto nangue, “Ee, n'manine nangue wewe wakikita evi na mutima waswetele, ni ne nakikukingilila tekuti ubale. Ni pakako, nsyakikulekeela kuti umukumie. ");
INSERT INTO tap_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ale kansi mubwezie ozu mwanakazi ku mulume wakue Abrahamu, pantu Abrahamu ni kabika, ni ye alikukulombela pantu wene ni kabika, ni we uli kuba mukose. Inzi kine teumubweziizie, umane nangue kisinka wakaba kufua pamo ni bonse bauli nabo.” ");
INSERT INTO tap_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki waabuukile paakili ni kukuuta babombi bakue bonse ni kubabwila milandu yonse. Ni babo bantu baatiinisie. ");
INSERT INTO tap_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kupwako, Abimeleki wamukuuta Abrahamu ni kumwipuzia nangue, “Ewe, ni kiki kiwaakitukitila? Ati, nene nakikuluviaki pakuti uleete kibalo kikata pali nene ni pa bukolo bwane? Waakinkitila bintu bisipalile.” ");
INSERT INTO tap_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kabili Abimeleki waamwipuziizie Abrahamu nangue, “Ati, wakilengiwa naki pakuti ukite evi?” ");
INSERT INTO tap_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahamu wa-asukile evi, “Nene nakimona nangue, kisinka pano tepali muntu aliwatiina Leza, kuti bangipaya pa mulandu wa mukazi wane. ");
INSERT INTO tap_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Inzi kulanda kisinka ozu mwanakazi ni nkazyamwine pantu situe ni umo sie, inzi banghinetue i balekenkeene. Anzia kine kili evio, ozu ni mukazi wane. ");
INSERT INTO tap_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Leza lu-aanghenziizie kufuma mu nghanda yakua tawe, naamwanine Sara nangue, ‘Konse kutwaakaba twaya ukabe wanandila biweme nangue nene ndi ndumezo.’” ");
INSERT INTO tap_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleki waabuulile mikooko ni nghombe ndume pamo ni babombi balalume ni banakazi, wamupeela Abrahamu ni kumubweziizia mukazi. ");
INSERT INTO tap_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki waalandile evi, “Mona, keki kyalo kyonse kiumwene ni kyane, kuti waikala konse ku ulikutona.” ");
INSERT INTO tap_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kabili Abimeleki waamwanine Sara nangue, “Mona namupeela ndumezo nfolanga 1,000 kuti iye yali nfuto pa menso a bonse bauli nabo. Ni pakako, teuli na mulandu.” ");
INSERT INTO tap_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abrahamu waamulombele Leza, Leza wamukosia Abimeleki ni mukazi wakue pamo ni babombi bakue banakazi. Ni bo baavyele baana ");
INSERT INTO tap_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","pantu Yawe waali waimikile luvyalo lwa bantu ba mu nghanda yakua Abimeleki pa mulandu wakua Sara muka Abrahamu. ");
INSERT INTO tap_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe waizile kuli Sara nga mu-aalandiile. Yawe waamukitiile Sara nga mu-aalandiile. ");
INSERT INTO tap_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara waimitile ni kumuvyalila Abrahamu mwana mwalalume wa mu bukote bwakue. Sara waavyele pa olia wenka musita waalandiilepo Leza. ");
INSERT INTO tap_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mwana waavyaliilue Abrahamu na Sara, Abrahamu waamwinikile liina lya Izaaki. ");
INSERT INTO tap_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Izaaki lu-aakumaniizie nsiku mwanda, Abrahamu waamuteetele yando nga vya-aninue na Leza. ");
INSERT INTO tap_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Izaaki lu-aavyelue, Abrahamu waali wasyali na myaka 100. ");
INSERT INTO tap_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara waalandile evi, “Leza wane wanengia kuseka. Kubalua muntu wakaba kunvuako ezi mpunda, wakaba kuseka pamo nane.” ");
INSERT INTO tap_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kabili waatwaliliile kulanda nangue, “Emwe, nani waali wamanine nangue Abrahamu waakavyalilua baana na Sara! Inzi evi namuvyalila mwana mwalalume wa mu bukote bwakue.” ");
INSERT INTO tap_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana waakulile mpaka wasumunua. Busiku bwaasumwinue Izaaki, Abrahamu waakitile nsikunkulu ikata. ");
INSERT INTO tap_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara waamwene mwana mwalalume mwina Hagari wa ku Misri waavyaliilue Abrahamu walimukumupunika mwana wakue Izaaki. ");
INSERT INTO tap_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara waamwanine Abrahamu nangue, “Mukumbe ozu mwanakazi muzia pamo ni mwana wakue Isimaeli, pantu ozu mwana wakue takapyana pamo ni mwana wane Izaaki.” ");
INSERT INTO tap_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ozo mulandu waakilile kumubipila Abrahamu pantu Isimaeli ni ye waali mwana wakue. ");
INSERT INTO tap_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Leza waamwanine Abrahamu, “Tekufiitua palwakua Isimaeli ni nghina Hagari, inzi konka sie twebo tonse twakwana Sara, pantu muli Izaaki i mwaakafuma nvyalo yobe. ");
INSERT INTO tap_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mwana mwalalume mwina mwanakazi muzia naakamukita kuba mutundu ukata, pantu ni ye ni mwana obe.” ");
INSERT INTO tap_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Lukeele lwakue paakili, Abrahamu waabuukile ni kumupailila Hagari bilio ni menda a kumina mu mbukulu ya mpapa ya nama, wamutwika pa nkombe, ni kumwana ailepo ni mwana wakue. Ozo mwanakazi waile wazeezooka sie mu kaseeba ka Beri-Seba. ");
INSERT INTO tap_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Menda a kumina lu-aapwile mu mbukulu ya mpapa ya nama, waamulaalikile mwana wakue mwinsina kavuule ");
INSERT INTO tap_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ni kuya kwikala pa nkendo imo paleepele mu pepi metre 100 ni kulanda nangue, “Nsitonene kumona kufua kwa mwana wane.” Hagari lu-aali waikeele papo, waatendekele kulila wa-angwile. ");
INSERT INTO tap_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mwana ni ye waali walimukulila. Leza lu-aunvwile kulila kwa mwana, malaika wakua Leza kufuma mu mulu waamukuutile Hagari ni kumwana nangue, “Ati Hagari, wasakamanapoki papa? Unvua, tekutiina pantu Leza waunvwanga kulila kwa mwana obe. ");
INSERT INTO tap_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ale endo ubuusie mwana umusungilile, pantu naakamukita kuba mutundu ukata.” ");
INSERT INTO tap_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Leza waamwizwile Hagari menso, ni ye waamwene kiina kya menda. Kupwako, waya kwizuzia menda mu mbukulu ya mpapa ya nama ni kumunwinsia. ");
INSERT INTO tap_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Leza waali wali pamo ni ozo mwana, ni ye waakulile. Waile kwikala mu kaseeba ni kwaluka mbwela wa nama mu kubombia buta ni mivui. ");
INSERT INTO tap_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Lu-aali waikeele mu kaseeba ka Parani, nghina waamukebeele mukazi wa ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Pa ozo musita, Abimeleki ni Fikoli mukulu wa balukale bakue, baile kumwana Abrahamu nangue, “Leza obe ali pamo ni wewe mu bintu byonse bi-uliwakita. ");
INSERT INTO tap_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ale lapa mu kyeni kyakua Leza nangue teukikan'mbeepa ao kubeepa mwana wane, ao kubeepa mwinzikulu wane, inzi ukankitile biweme pamo ni keki kyalo kiwikeelemo nga evelia vinaakukitiile.” ");
INSERT INTO tap_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahamu waalandile evi, “Ee, ndikulapa.” ");
INSERT INTO tap_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kabili Abrahamu waamwanine Abimeleki nangue, “Nene nsiwamiinue pa mulandu wa kiina kya menda kyaapokelue na babombi bobe.” ");
INSERT INTO tap_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki waamwasukile evi, “Ewe, nene nsimanine muntu waakitile evio, ni we kumo tewan'mbwilileko, kabili nsinaunvuepo, ni evi vyenka lelo i kunvua.” ");
INSERT INTO tap_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kupwako, Abrahamu wabuula mikooko ni nghombe, wamupeela Abimeleki. Babo babili baakitile kipanghano. ");
INSERT INTO tap_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahamu waabuulile misoka kilooba ya mikooko ikota ni ku-ibiika pambali. ");
INSERT INTO tap_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki waamwipuziizie Abrahamu, “Ewe, ale ezi misoka kilooba ya mikooko ikota iwabiika pambali i kulanda syani?” ");
INSERT INTO tap_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahamu wa-asukile evi, “Ezi misoka ya mikooko ni ya kukupeela wewe, evi kiye kyali kisininkizizio kya kusininkizia nangue nene i mwine waimbile keki kiina kya menda.” ");
INSERT INTO tap_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ni pakako, pa ezio nkendo paakuutilue Beri-Seba i kulanda nangue, “Kiina kya menda kya kilooba ao kiina kya mulapo.” Pantu babo babili i pa baakitiile kipanghano. ");
INSERT INTO tap_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pa kyamba kya kwitabizyania ku Beri-Seba, Abimeleki ni Fikoli, mukulu wa balukale bakue, baabweleele ku kyalo kya Bafilistini. ");
INSERT INTO tap_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamu waalimbilemo kamuti ka tamariski ni kukuutilapo Liina lyakua Yawe Leza wa muyayaya. ");
INSERT INTO tap_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahamu waikeele nsiku ingi mu kyalo kya Bafilistini wali mweni. ");
INSERT INTO tap_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Pa kyamba, Leza waamweziizie Abrahamu. Leza waamukuutile, Abrahamu, Abrahamu ni ye waiteebe, “Ne ono pano.” ");
INSERT INTO tap_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Leza waamwanine Abrahamu, “Ale twama mwana obe lyonga Izaaki, mwana u-utoneesie uye nakue mu kyalo kya Moria, uye umukite ngelelo ya kuzizia pa lupili lundikukulangilila.” ");
INSERT INTO tap_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahamu waabuukile paakili, waateania punda wakue, watwama babombi bakue babili pamo ni mwana wakue Izaaki, ni kutyaba nkuni ya ezio ngelelo ya kuzizia, watendeka lwendo waya mpaka kolia kwa-aninue na Leza. ");
INSERT INTO tap_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Busiku bwa butatu, Abrahamu waamwene ku nkendo ku-aali walimukuya wakili kule. ");
INSERT INTO tap_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahamu waabaanine babombi bakue, “Syale pano ni ozu punda, nene ni ozu mulumendo tulikuya ku kupupa, pa kyamba mane tubwele.” ");
INSERT INTO tap_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kupwako, Abrahamu wamutwika mwana wakue Izaaki nkuni ya kuziziiziako ngelelo, ni ye watwamako mwele ni mulilo, bonse babili baya. ");
INSERT INTO tap_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Izaaki waamukuutile se, “We tawe!” Se wa-asukile evi, “We mwana wane, ne ono pano.” Izaaki waamwipuziizie se, “Nkuni ni mulilo bebi. Ale musoka wa mukooko wakuti tukite ngelelo ya kuzizia ali pi?” ");
INSERT INTO tap_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahamu waamwasukile evi, “We mwana wane, Leza mwine alikwipeela musoka wa mukooko wa ngelelo ya kuzizia.” Kupwako, bonse babili batwalilila kuya. ");
INSERT INTO tap_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lubaile kufika kolia ku-aalangilue na Leza, Abrahamu waakuulile kitale, ni kulongapo nkuni, wamukaka mwana wakue Izaaki ni kumubiika pa kitale peulu nkuni. ");
INSERT INTO tap_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kupwako, Abrahamu wabuula mwele kuti amusinze mwana wakue. ");
INSERT INTO tap_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Inzi malaika wakua Yawe kufuma mu muulu waamukuutile, “Abrahamu, Abrahamu!” Ni ye waitaba, “Ne ono pano.” ");
INSERT INTO tap_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaika wamwana nangue, “Tekumukitila kintu kibiipile ao kumwipaya mwana obe. Evi nainika nangue ni kiine wewe umukindikile Leza, kabili umunakiile pantu tewakikaana kwelela mwana obe lyonga.” ");
INSERT INTO tap_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahamu lu-aikebukile, waamwene mpanga wakobelue na binkobankoba ku masengo akue. Waile kumukwata ni kwiza kumupyanika pa mwana wakue kuti aye wali ngelelo ya kuzizia. ");
INSERT INTO tap_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Pa kekio kifuka Abrahamu wainikilepo liina lya “Yawe-Yire.” Ni pakako, i kikilikyalandilua nangue, “Pa lupili lwakua Yawe i payaakamoneka.” ");
INSERT INTO tap_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaika wakua Yawe kufuma mu muulu waamukuutile Abrahamu lya bubili. ");
INSERT INTO tap_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ni kumwana nangue, “Yawe walanda nangue nalapa mu Liina lyane ne mwine nangue naakakupaala pantu tewakikaana kungelela mwana obe lyonga. ");
INSERT INTO tap_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kisinka naakakupaala, ni kusandulula nvyalo yobe, evi ikabe ingi nga ntanda ya mu lyulu, kabili nga musenga wa mumbali lyezi. Nvyalo yobe yaakanzia balwani babo. ");
INSERT INTO tap_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kupitila mu nvyalo yobe, ntundu yonse ya pa kyalo yaakapaalua pantu waanakiile mwano wane.” ");
INSERT INTO tap_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kupwako, Abrahamu wabwelelamo ku babombi bakue. Wabatwama ni kuya nabo ku Beri-Seba. Abrahamu waikeele koko ku Beri-Seba. ");
INSERT INTO tap_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Pa kyamba kya bebi byonse, Abrahamu waaleeteelue mpunda nangue, “Milka wakimuvyalila mwaobe Nahori baana.” ");
INSERT INTO tap_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Libeli wakue waali wakuutua Uzi, wa bubili waali wakuutua Buzi, waakonkelepo waali wakuutua Kemueli ozo waavyele Ba-aramu, ");
INSERT INTO tap_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ni Kesedi, ni Hazo, ni Pildasi, ni Idilafu, pamo ni Betueli. ");
INSERT INTO tap_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli i waavyele Rebeka. Milka waamuvyaliile Nahori mwalawakue kwa Abrahamu baana balalume mwanda, ");
INSERT INTO tap_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ni Reuma mukazi wa bubili waavyele Teba, ni Gahama, ni Tahasi, pamo ni Maaka. ");
INSERT INTO tap_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara waikeele pa kyalo myaka 127 ");
INSERT INTO tap_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara waafwiliile ku Kiriati-Arba (i kulanda nangue Hebroni) mu kyalo kya Kanaani, ni Abrahamu waile paali mubili wakua Sara walimukulila ni kuloosia. ");
INSERT INTO tap_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrahamu waafumine paali pabiikilue mubili wakua mukazi wakue, waya kubaana baana bakua Heti nangue, ");
INSERT INTO tap_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nene kono ndi mweni ni mulendo pakati kenu, n'mpeeleko nkendo imulimwaziikapo, ni ne nziikepo mukazi wane evi aye wali kule ni nene.” ");
INSERT INTO tap_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bahiti baamwasukile Abrahamu. ");
INSERT INTO tap_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“We mwinzio, unvua! Wewe uli mulombozi mukulu pakati ketu, tepali muntu alikukaana kukupeela kilibu kya kuziikamo mukazi obe. We muziike sie mu kilibu ki-ulikusaakulapo.” ");
INSERT INTO tap_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kupwako, Abrahamu wafwinamina bekala kyalo ni baana bakua Heti ");
INSERT INTO tap_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ni kubaana nangue, “Mwe bamwinzio, kine mwangitabila kuziika mukazi wane kono, namilomba mumwane Efuroni mwana mwalalume mwina Zohari ");
INSERT INTO tap_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ansisie lisele lya ku Makipela lili ku nkingo ya bukaba bwakue. Mumwane alande mutengo wa bolia bukaba pa menso enu, evi ikabe nkendo yane ya kuziikamo.” ");
INSERT INTO tap_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efuroni Muhiti waali waikeele pa bukata bwa baana bakua Heti, waamwasukile Abrahamu ntanzi ya baana bakua Heti pamo ni bonse baali baingila mu ozo muzi nangue, ");
INSERT INTO tap_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“We mwinzio, unvua, nene nakupeela bukaba bonse pamo ni lisele lilimo, nakupeela bebi byonse pa menso a bantu bane. Ziikamo mukazi obe.” ");
INSERT INTO tap_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahamu waakontamiine ku bekala kyalo ");
INSERT INTO tap_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ni kumwana Efuroni pa menso a bekala kyalo walanda nangue, “Inzi kine watona, nakulomba untwilizie. Ndikukusita bukaba. Ale twama nfolanga, ni ne ndikuziikamo mukazi wane.” ");
INSERT INTO tap_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuroni waamwasukile Abrahamu nangue, ");
INSERT INTO tap_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“We mwinzio, unvua, bobu bukaba kine bwasitua na shekeli 400, kuti byatukitaki nene ni wewe? Ni pakako, ziika sie mukazi obe.” ");
INSERT INTO tap_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamu waamwitabiizie Efuroni, Abrahamu waamupendeele Efuroni nfolanga i-aalandile ntanzi ya baana bakua Heti shekeli 400 ya mutofue mu kipendo kya basulu. ");
INSERT INTO tap_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Bukaba bwakua Efuroni bwa ku Makipela bwaali bwali lya ku kabanga ka Mamure, ni bimuti byonse, ni lisele, byaamanikile kuba ");
INSERT INTO tap_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","byakua Abrahamu ntanzi ya baana bakua Heti ni ntanzi ya bonse baali baingila pa mulyango wa muzi wakue. ");
INSERT INTO tap_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Pa kyamba, Abrahamu waamuziikile mukazi wakue Sara mu lisele lya mu bukaba bwa ku Makipela bwaali bwali lya ku kabanga ka Mamure, (i kulanda nangue Hebroni) mu kyalo kya Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Bukaba ni lisele lyaalimo byaamaniiziwe na baana bakua Heti kuba byakua Abrahamu, kuti biye byaali bunonsi bwakue ni nkendo ya kuziikamo. ");
INSERT INTO tap_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamu waali wasyali mukote wa nsiku ingi, Yawe waali wamupaalile Abrahamu mu byonse. ");
INSERT INTO tap_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahamu waamwanine mubombi wakue mukulu wa mu Nghanda yakue, waali mukulu pa byonse bi-aali nabio nangue, “Biika kuboko kobe kwinsina litanta lyane. ");
INSERT INTO tap_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ndikukulapia kuli Yawe Leza wa mwiulu ni wa pa kyalo nangue, tekuti ukasaakwile mwana wane mukazi pa babinundue ba Bakanaani bangikeele nabo. ");
INSERT INTO tap_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Inzi ukabe kuya ku kyalo kyane ni ku lupua lwane, umusaakwile mwana wane Izaaki mukazi.” ");
INSERT INTO tap_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mubombi waipuziizie evi, “Ale kine ozo mukazyana wakaana kwiza mu keno kyalo naakakita syani? Kuti namutwala mwana obe ku kyalo ku waafumine?” ");
INSERT INTO tap_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahamu waalandile evi, “Kengela, tekukeezia kubwezia mwana wane ku kyalo kunaafumine. ");
INSERT INTO tap_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe Leza wa mwiulu wanfumiizie mu nghanda yakua tawe ni mu kyalo kinaavyaliiluemo, ozo wandaile ni kulapa nangue waakapeela keki kyalo ku nvyalo yane, waakatangizia malaika ku ntanzi yobe kuti ukamusaakwila mwana wane mukazi wakue. ");
INSERT INTO tap_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kine ozo mukazyana wakaana kwiza pamo nobe, teukaba na mulandu pa keki kilapo. Inzi tekukeezia kubwezia mwana wane ku kelia kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kupwako, mubombi wabiika kuboko kwakue kwinsina litanta lyakua Abrahamu selenzi ni kulapa palua ozu mulandu. ");
INSERT INTO tap_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Mubombi waatweme nghamia lyanondo yakua selenzi, watwama ni bintu biweme waya nabio lya ku Aramu-Naharaimu, ku muzi kwaali kwaikeele Nahori. ");
INSERT INTO tap_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Lu-aafikile, waafukamikile nghamia lya ku kiina kya menda kyaali kumbali muzi. Ozo, waali musita wa kyungulo waali wailapo banakazi ku kutapa menda. ");
INSERT INTO tap_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Waalombele evi, “We Yawe Leza wakua tawelenzi Abrahamu, nakulomba lelo un'mpaale ni kumulangisia tawelenzi buwame. ");
INSERT INTO tap_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mona ndi pano pa kiina kya menda palipaiza kutapa menda bakazyana bena bantu ba mu muzi. ");
INSERT INTO tap_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mukazyana undikwana atuule katondo kakue ka menda ni kumulomba n'minemo, alande nangue, ‘Mina, kabili ndikunwinsia ni nghamia yobe,’ ozo i wakuti uye wasaakwiliile mubombi obe Izaaki. Keki i kindikwinikilako nangue wamukitila tawelenzi buwame.” ");
INSERT INTO tap_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Lu-aali tanapwililile kulanda, Rebeka mwina Betueli waizile watweme katondo ka menda pa nkombe. Ozo Betueli waali mwina Nahori mwalawakue kwa Abrahamu. Nahori waali waupile Milka. ");
INSERT INTO tap_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka waali ni lukebu lwakilile kuwama, kabili waali wakili kinundue. Waakookeele ku kutapa menda, waizuzia katondo ni kusela. ");
INSERT INTO tap_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Olia mubombi waile lubilo kumusensekela ni kumwana nangue, “Nakupaapaata un'mpeeleko menda aniini a mu katondo kobe n'mine.” ");
INSERT INTO tap_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Waalandile evi, “We mwinzio, menda aza umine.” Penka papo watuula kale katondo ka-aali watweme pa nkombe ni kumupeela. ");
INSERT INTO tap_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Lu-aapwile kumina, mukazyana waalandile evi, “Ndikuya kutapa ni ange menda a kunwinsia nghamia mpaka pailikupwila kumina.” ");
INSERT INTO tap_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Penka papo wapongwela kale menda mu kiina kya kumininamo nama ni kuya lubilo ku kutapa ange, watapila nghamia yakue yonse. ");
INSERT INTO tap_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ozo mubombi mukulu waamutonokeele wataleele amone kine Yawe wakipaala lwendo lwakue ao abe. ");
INSERT INTO tap_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Nghamia luyaapwile kumina, ozo mubombi waabuulile kazele ka oro kaali kafinine shekeli mutanda ni bikano bya oro bibili bya ku maboko byaali byafinine shekeli 120. ");
INSERT INTO tap_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ozo mubombi mukulu waamwanine evi, “Nakulomba unghane, wewe uli mwina ni? Ku nghanda yakua so kuli ni nkendo kwa kulaala busiku?” ");
INSERT INTO tap_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka waamwanine evi, “Nene ndi mwina Betueli waavyelue na Milka muka Nahori.” ");
INSERT INTO tap_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kabili waamwanine evi, “Tukwete bikusi bingi pamo ni binge bilio, ni nkendo ya kulaalako.” ");
INSERT INTO tap_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ozo mubombi mukulu waafukeeme ni kumupupa Yawe. ");
INSERT INTO tap_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Waalandile evi, “Yawe Leza wakua tawelenzi Abrahamu atasiiwe, pantu bukisinka ni bulayo bwakue bitwaliliile pali tawelenzi. Yawe wakinombola mu nzila mpaka ku nghanda ya balupua bakua tawelenzi.” ");
INSERT INTO tap_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeka waile lubilo ku nghanda yakua nghina ni kubabwila lyasi lyonse. ");
INSERT INTO tap_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Labani ndumeze kwa Rebeka lu-aunvwile, waile lubilo ku ozo mubombi ku kiina kya menda. ");
INSERT INTO tap_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labani lu-aamwene kazele ni bikano byaali byavwele nkaziize Rebeka, ni kunvua vi-aalandile, waile lubilo kuli mubombi waali waimeene pepi ni nghamia ku kiina kya menda. ");
INSERT INTO tap_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labani waamwanine evi, “Twende ku nghanda we apaalilue na Yawe. Ale wimaniineki kono? Pantu nene nateanianga nghanda ni nkendo ya nghamia.” ");
INSERT INTO tap_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mubombi mukulu ni ye waingiile mu nghanda, ni Labani wakakula bitwamo pa nghamia, wapeela nghamia bikusi ni binge bilio, kabili waamuleeteele ozo muntu menda a kusamba ku makasa, wene, pamo ni bantu bakue. ");
INSERT INTO tap_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bilio lubyaaleetelue, mubombi wakua Abrahamu waalandile evi, “Nene nsilia kale kine nsinalandenke ka nghendeele.” Labani waamwanine evi, “Ale landa.” ");
INSERT INTO tap_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Waalandile evi, “Nene ndi mubombi mukulu wakua Abrahamu.” ");
INSERT INTO tap_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe waakilile kumupaala tawelenzi, ni ye wakyaluka mukindami. Waamupeele mikooko ni nghombe, ni nfolanga, ni oro, ni babombi balalume ni banakazi, ni nghamia pamo ni punda. ");
INSERT INTO tap_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara muka tawelenzi Abrahamu lu-aali wasyali mukote, waamuvyaliile Abrahamu mwana mwalalume wa mu bukote bwakue. Se waamupeele bintu byonse bi-aali nabio. ");
INSERT INTO tap_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tawelenzi wandapiizie walanda nangue, “Tekuti ukasaakwile mwana wane mukazi pa bakazyana ba Bakanaani ba mu kyalo kingikeelemo. ");
INSERT INTO tap_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Inzi ukaye ku nghanda yakua tawe ni ku lupua lwane, ukaye kumusaakwila mwana wane mukazi wakue.” ");
INSERT INTO tap_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Naamwipuziizie tawelenzi, “Ale kine mukazyana wakaana kwiza kono?” ");
INSERT INTO tap_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Wangasukule, “Yawe undinanakila i waakatangizia malaika wakue ku waakaya, ni ye waakapaala nzila yobe, ni we waakasaakwila mwana wane mukazi wa mu lupua lwane ni wa mu nghanda yakua tawe. ");
INSERT INTO tap_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Inzi paukaya kwana bantu bane, kine bakakaane kukupeela mukazyana, kupwako, wewe teukaba na mulandu. ");
INSERT INTO tap_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Lunafikanga ku kiina kya menda, nalombanga Yawe Leza wakua tawelenzi Abrahamu, namupaapaata ankwasie mu keki kindimukukita. ");
INSERT INTO tap_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mona ndi pano pa kiina kya menda. Kansi mukazyana alikwiza ku kutapa menda, ni undikulomba menda aniini a kumina mu katondo kakue, ");
INSERT INTO tap_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kine waitabila kun'mpeela ni kunwinsia nghamia yane, i wakuti uye wasaakwile kuya wali muka mwana wakua tawelenzi. ");
INSERT INTO tap_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Lunaba nasyapwililila mapepo ane a mukansongia, Rebeka wakookelanga ku kiina ku kutapa menda watweme katondo pa nkombe. Namwananga mukazyana, napaapaata kuti an'mpeeleko menda a kumina. ");
INSERT INTO tap_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Penka papo watuula kale katondo ka menda, walanda nangue, ‘Poka umine, kabili ndikunwinsia ni nghamia yobe.’ Nene naminanga, kabili wanwisyanga ni nghamia yane. ");
INSERT INTO tap_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Namwipuzyanga evi, ‘So nani?’ Wangasukanga nangue, ‘Tawe ni Betueli waavyelue na Milka muka Nahori.’ Kupwako, nabuula kazele namuvwika ku moona ni bikomo namuvwika ku maboko. ");
INSERT INTO tap_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Namufukaminanga Yawe ni kumupupa. Namutasyanga Leza wakua tawelenzi Abrahamu wakinombola mu nzila iweme kwiza ku bantu bakua tawelenzi, kono kunaiza kusanga mwana mukazyana mwina wa kwakue kwa tawelenzi wa kuupua na mwina tawelenzi. ");
INSERT INTO tap_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kansi kine mulikwitabila ni kukita mwanghaniine tawelenzi, nghane. Kabili kine mulikukaana, nghane n'mane kwa kulunghama, kine ni kulio ao kuso.” ");
INSERT INTO tap_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani ni Betueli ba-asukile, “Fwefue tetuli na kakulandapo pantu ozu mulandu ufumine kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ozu, mutwame aye oopue na mwina solenzi nga mwakilandila Yawe.” ");
INSERT INTO tap_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mubombi mukulu wakua Abrahamu lu-aunvwile evio, waakonteeme pansi ni kumupupa Yawe. ");
INSERT INTO tap_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ozo mubombi mukulu waafumiizie tuzele twa mutofue ni twa oro pamo ni ngubo, wamupeela Rebeka. Kabili waafumiizie byabupe bya mponvu ni kubapeela ba kwakue kwa mukazyana pamo ni nghina. ");
INSERT INTO tap_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Mubombi mukulu wakua Abrahamu pamo ni bantu baizile nakue baaliile ni kumina, ni kulaala koko kwenka. Lubwaakiile, baabuukile. Mubombi mukulu wakua Abrahamu waalandile evi, “Emwe, n'mpeele nsambu ya kuti n'mbwelelemo kuli tawelenzi.” ");
INSERT INTO tap_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Labani pamo ni nghina kwa Rebeka baalandile evi, “Ata, mulekenke twikale nakue mulungu umo ao nsiku lyanondo, mane akabe kuya.” ");
INSERT INTO tap_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Inzi wene waalandile evi, “Emwe, tekunkaanie pantu Yawe wakin'mpaala mu lwendo lwane, kansi ndeke n'mbwelelemo kuli tawelenzi.” ");
INSERT INTO tap_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Baalandile evi, “Kansi tumukuute mukazyana tumwipuzie tunvue vi-alikulanda.” ");
INSERT INTO tap_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kupwako, bamukuuta Rebeka, bamwipuzia nangue, “Ati, utonene kuya pamo ni mubombi wakua Abrahamu?” Wa-asukile nangue, “Ee, ndikuya nakue.” ");
INSERT INTO tap_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kupwako, bamupeela nsambu Rebeka kuti aye pamo ni mwanakazi wa mu nghanda waali wamusunga. Babo bonse babili baile pamo ni mubombi mukulu wakua Abrahamu pamo ni bantu baali baizile na mubombi mukulu wakua Abrahamu. ");
INSERT INTO tap_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Baamupaalile Rebeka bamwana, “We mukwetu, ube nghina wa nvyalo ingi. Nvyalo yobe ikaanzie balwani babo!” ");
INSERT INTO tap_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka pamo ni babombi bakue bakazyana baiteaniizie, basela pa nghamia ni kuya na mubombi mukulu wakua Abrahamu pamo ni bantu ba-aali nabo. ");
INSERT INTO tap_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Izaaki waile mu nzila ya ku Beri-Lahai-Roi (i kulanda nangue, Kiina kya menda kyakua Mukose aliwan'mona), pantu waali waikeele ku Negebu. ");
INSERT INTO tap_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Musita wa kyungulo Izaaki waile ku makaba ku kulangakana. Waakentele lwa kule ni kumona nghamia yalimukwiza. ");
INSERT INTO tap_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka ni ye lu-aakentele lwa kule ni kumumona Izaaki, waakookele pa nghamia ");
INSERT INTO tap_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ni kumwipuzia mubombi mukulu wakua Abrahamu, “Ale olia muntu alimukwenda mu bukaba waiza kutusensekela nani?” “Olia i tawelenzi Izaaki.” Kupwako, wabuula kiteebo ni kwikupilila pa menso. ");
INSERT INTO tap_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mubombi mukulu wakua Abrahamu waamwanine Izaaki bintu byonse bi-aakitile. ");
INSERT INTO tap_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Izaaki waamwingiziizie Rebeka mu liema mwaali mwaikala nghina Sara. Kupwako, Rebeka wa-aluka mukazi wakue. Izaaki waamutonene Rebeka. Waakoseleziiziwe na kubapo kwakua Rebeka pantu nghina waali wasyafwile. ");
INSERT INTO tap_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamu waupile unge mwanakazi liina lyakue Ketura. ");
INSERT INTO tap_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Baana baavyaliilue Abrahamu na Ketura meena abo ni aza: Simurani, ni Yokisani, ni Medani, ni Midiani, ni Isibaki pamo ni Sua. ");
INSERT INTO tap_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani waavyele Seba ni Dedani. Dedani waavyele Asuri ni Letusi pamo ni Lumi. ");
INSERT INTO tap_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midani waavyele Efa, ni Eferi, ni Hanoki, ni Abida pamo ni Elda. Babo bonse i ba mu luvyalo lwakua Ketura. ");
INSERT INTO tap_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamu waamupeele Izaaki bintu byonse bi-aali nabio. ");
INSERT INTO tap_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Abrahamu lu-aali wakikosele, waabuulile byabupe ni kupeela baana bakue ba-aavyele mu bakazi banike. Babo baana waabaanine baye bekale ku kyalo kya ku kabanga, kule ni kwaali kwaikeele Izaaki. ");
INSERT INTO tap_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Myaka yaikeele Abrahamu yaali 175. ");
INSERT INTO tap_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahamu waafwile wa wamiinue mu bukote bwakue ni kuya kwikala pamo ni babikolue bakue baamutangiliile. ");
INSERT INTO tap_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Baana bakue, Izaaki ni Isimaeli, baamuziikile mu lisele lya ku Makipela, mu bukaba bwaali bwakua Efuroni mwina Zohari Muhiti, bukaba bwaali lya ku kabanga ka Mamure, ");
INSERT INTO tap_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bobo bukaba bwaasitilue na Abrahamu ku baana bena Heti. Mu bobo bukaba i mwaaziikilue Abrahamu ni mukazi wakue Sara. ");
INSERT INTO tap_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pa kyamba kya kufua kwakua Abrahamu, Leza waamupaalile Izaaki. Izaaki waakuukiile pa kifuka kyaali kyakuutua Beri-Lahai-Roi. Beri-Lahai-Roi i kulanda nangue kiina kya menda kyakua Mukose aliwan'mona. ");
INSERT INTO tap_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nvyalo yakua Isimaeli mwina Abrahamu, mwana mwalalume u aavyaliilue na Hagari wa ku Misri, muzia wakua Sara, ");
INSERT INTO tap_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","meena abo ni aza mwaali mwabeleele nvyalo: Libeli wakue waali wakuutua Nebayoti. Balabakue ni bo meena abo ni aza: Kedari, ni Adibeli, ni Mibusani, ");
INSERT INTO tap_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ni Misime, ni Duma, ni Masa, ");
INSERT INTO tap_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ni Hadadi, ni Tema, ni Yeturi, ni Nafisi, pamo ni Kedema. ");
INSERT INTO tap_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Babo i baali babikolue ba ntundu lyanondo ni ibili, ni mizi yabo yaali yakuutua azo enka meena, ni ku tutanda ni ko azo enka meena abo. ");
INSERT INTO tap_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Myaka yaikeele Isimaeli pa kyalo yaali 137. Waafwile ni kuya kwikala pamo ni babikolue bakue baamutangiliile. ");
INSERT INTO tap_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Baikeele kufuma ku Awila mpaka ku Suri ili ku ntanzi ya Misri kine ulimukuya mu nzila ya ku Asuria. Isimaeli waafwile ntanzi ya kufua ba kwakue bonse. ");
INSERT INTO tap_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nvyalo yakua Izaaki mwina Abrahamu ni ezi: ");
INSERT INTO tap_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Izaaki waali na myaka 40 lu-aupile Rebeka mwina Betueli Muamea wa ku Padani-Aramu. Ndumeze kwa Rebeka waali wakuutua Labani. ");
INSERT INTO tap_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Izaaki waamupepeele mukazi wakue Rebeka kuli Yawe pantu waali nghumba. Yawe waamwasukile, ni Rebeka waimitile. ");
INSERT INTO tap_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Baana baabambile kulua munda. Rebeka waalandile evi, “Ale kyakitikilaki evi? Kine ni evi, ni kufua kwa wama.” Kupwako, waya kumwipuzia Yawe. ");
INSERT INTO tap_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yawe waamwanine evi, “Mu livumo lyobe muli ntundu ibili. Misango ibili ya bantu bali munda mobe yaakaba yapuseene. Mutundu umo waakaba wapamine kukila unge. Mukulu waakaba wabombela mwanike.” ");
INSERT INTO tap_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Musita wa kuvyala kwakua Rebeka luwaakumeene, munda mwaali mwali bampundu. ");
INSERT INTO tap_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana wa mambo waavyelue wali wa kasi mubili onse ni bupipi nga ngubo ya masako a nama. Ni pakako, waanikilue Esau. ");
INSERT INTO tap_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Pa kyamba, wa kwakue waavyelue wakwete ku kasinghino kakua Esau, ni pakako, wainikilue Yakobo. Rebeka lu-aavyele babo bampundu, Izaaki waali wasyali na myaka 60. ");
INSERT INTO tap_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Babo baana lubaakulile. Esau wa-alukile mbwela wa nama, muntu waali wapisia nsita ingi mu kisonso, inzi Yakobo waali wateekameene wazikia sie mu liema. ");
INSERT INTO tap_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izaaki waali wamutonene Esau pantu waali wamuleetela nama i-aali waipaya, inzi Rebeka waali wamutonene Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Busiku bumo Yakobo waelekele nseepa. Esau lu-aabwelele kufuma mu kukumba nama, waali wasyaumiine kupenzuka na nzala. ");
INSERT INTO tap_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau waamwanine Yakobo, “Ewe, napaapaata n'mpeeleko kilunzi kya nseepa kikasikile, lenga nafua nzala.” (Ni pakako, i ki-aakuutiilue Edomu) ");
INSERT INTO tap_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo waamwasukile evi, “Nsisienke nsambu ya bubeli bobe.” ");
INSERT INTO tap_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau waalandile evi, “Kili sie bwino! Mona pasyanfue. Ale nsambu ya bubeli bwane ilikuya yali na kibweziaki?” ");
INSERT INTO tap_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo waamwanine evi, “Kansi lapanke.” Esau waalapile ni kumusisia Yakobo nsambu ya bubeli bwakue. ");
INSERT INTO tap_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kupwako, Yakobo wamupeela Esau mukate pamo ni kilunzi kya nseepa. Esau lu-aaliile ni kumina, waafuminepo. Evi Esau i vi-aafuupwile nsambu ya bubeli bwakue. ");
INSERT INTO tap_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kabili pa kyalo paali kimina kya nzala kukila kimina kya nzala kyaali mu nsiku yakua Abrahamu. Izaaki waile kuli Abimeleki Likolo wa Bafilistini mpaka ku Gerari. ");
INSERT INTO tap_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yawe waamumonekeele Izaaki. Waamwanine evi, “Tekuya ku Misri, inzi nakaba kukulangisia kwa kuti ukabe kuya kwikala. ");
INSERT INTO tap_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ikala sie mu keki kyalo kya bweni, naakaba pamo nobe ni kukupaala pantu wewe pamo ni nvyalo yobe yonse nakaba kumipeela keki kyalo kyonse, kabili naakafikilizia kilapo kinaalapiile so Abrahamu. ");
INSERT INTO tap_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Naakasandulula nvyalo yobe nga ntanda ya mu lyulu, kabili naakaipeela bebi byalo byonse. Ntundu yonse ya pa kyalo yaakapaalilua mu luvyalo lobe, ");
INSERT INTO tap_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","pantu Abrahamu waunvwiliile lizui lyane ni kusunga milao yane, ni mafunde ane, ni bupinguzi bwane pamo ni mizilo yane.” ");
INSERT INTO tap_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ni pakako, Izaaki waikeele mu Gerari. ");
INSERT INTO tap_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bantu ba mu Gerari lubaamwipuziizie palua mukazi wakue, waalandile nangue, “Ni nkazyamwine.” Taitabiile nangue waali mukazi wakue pantu waali watiina nangue pange bantu kuti bamwipaya ni kumutwama Rebeka, pantu Rebeka waali wa lukebu luweme. ");
INSERT INTO tap_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Izaaki lu-aapwileko nsiku ingi, Abimeleki likolo wa Bafilistini waapuziizie menso pa nzota ni kumona Izaaki walimukusaapa na mukazi wakue Rebeka. ");
INSERT INTO tap_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki waamukuutile Izaaki ni kumwana nangue, “Kisinka nainika nangue Rebeka ni mukazi obe! Ale wakilandilaki nangue ni nkaziizo?” Izaaki waamwasukile evi, “Nandenge nangue ni mukazi wane, nga nakiipailuapo.” ");
INSERT INTO tap_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kabili Abimeleki waamwanine evi, “Wakitubeepelaki? Umo wa mu bantu bane akambulenge na mukazi obe, wewe nga i wakilengia bantu bane kuba ni kilubo.” ");
INSERT INTO tap_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ni pakako, Abimeleki waabasokele bantu bakue nangue, “Emwe, onse wakaba kumukitila ozu muntu pamo ni mukazi wakue bibiipile, wakaba kwipaiwa.” ");
INSERT INTO tap_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izaaki waabyele mbezu mu kekio kyalo, ni ozo mwaka, waazombwele mbezu ingi nghendo 100 kukila elia i-aabyele, pantu Yawe waamupaalile. ");
INSERT INTO tap_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Izaaki waanonkele, ni bunonsi bwakue bwaatwaliliile mpaka wa-aluka munonsi mukata. ");
INSERT INTO tap_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Bafilistini baamunvwiliile bunkua pantu waali ni bisepe bya mikooko, ni bya nghombe, pamo ni babombi bengi. ");
INSERT INTO tap_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ni pakako, Bafilistini baabiikiile bulongo mu biina byakue bya menda byaimbilue na babombi bakua se Abrahamu, Abrahamu lu-aali wakikosele. ");
INSERT INTO tap_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki waamwanine Izaaki, “Ewe, fuma pakati ketu pantu wa-aluka ni maka kukila fwefue.” ");
INSERT INTO tap_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Izaaki waafumine papo, waya kwimika tutanda mu lulambe lwa Gerari, ni kwikala koko. ");
INSERT INTO tap_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Izaaki waimbulwile biina bya menda byaali byaimbilue pa musita waali wakikosele Abrahamu, pantu Bafilistini baamubiikiilemo bulongo mu bebio biina bya menda Abrahamu lu-aali wasyafwile, kabili waabiinikile meena enka alia a byainikilue na se. ");
INSERT INTO tap_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Babombi bakua Izaaki baimbile biina bya menda mu lulambe mpaka basanga tusulo twa menda. ");
INSERT INTO tap_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Basungi ba ku Gerari baakankabwile na basungi bakua Izaaki. Basungi ba ku Gerari baalandile nangue, “Aza menda ni etu.” Ni pakako, keki kiina kya menda Izaaki waakiinikile “Mukanka.” Pantu baakankabwile nakue. ");
INSERT INTO tap_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kabili baimbile kinge kiina kya menda, inzi ni kyo baakankabwiliilepo. Ni pakako, Izaaki waakiinikile Sitina. ");
INSERT INTO tap_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Izaaki waafumine papo ni kuya kwimba kinge kiina kya menda. Pa kekio kyene tebaakankabwiliilepo. Ni pakako, Izaaki waakiinikile Rehoboti. Waalandile evi, “Pantu evi Yawe watupeela nkendo ni fwe twaakavula mu kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Izaaki waafumine papo ni kusela waya ku Beri-Seba. ");
INSERT INTO tap_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Bobo busiku musita wa busiku, Yawe waamumonekeele. Waamwanine evi, “Nene ndi Leza wakua so Abrahamu. Tekutiina, pantu ndi pamo nobe. Naakakupaala ni kusandulula nvyalo yobe pa mulandu wa mubombi wane Abrahamu.” ");
INSERT INTO tap_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Izaaki waakuulilepo kitale ni kukuuta Liina lyakua Yawe. Kabili waimikilepo liema lyakue. Babombi bakue baimbileko ni kinge kiina kya menda. ");
INSERT INTO tap_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki, ni kibuza wakue Ahuzati, pamo ni Fikoli mukulu wa balukale, baafumine ku Gerari ni kuya kuli Izaaki. ");
INSERT INTO tap_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izaaki waabaanine evi, “Mwemue temuntonene, kabili mwankumbile kwenu. Eba, ale mwaiza mwankonkeeleki?” ");
INSERT INTO tap_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ba-asukile evi, “Evi i vitwainika nangue Yawe ali pamo nobe, kabili twakimona nangue tupalile kunvwana nobe. Ni pakako, tutonene tupinghane nobe ");
INSERT INTO tap_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","nangue teukatukitila kibiipile pantu ni fwefue tetwaakukitiile kibiipile, inga sie kiweme, pamo ni kukupeela nsambu ya kuti uilepo bwino. Wewe lenu upaalilue na Yawe.” ");
INSERT INTO tap_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Izaaki waabatebetele, ni bo baaliile ni kumina. ");
INSERT INTO tap_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Lukeele lwakue paakili lukeelekeele, bonse baunvwene ni kupinghana. Kupwako, Izaaki wabalaya nangue, “Ale ilepo bwino.” ");
INSERT INTO tap_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Bobo bwenka busiku, babombi bakua Izaaki baizile kumwana palua kiina kya menda kibaali balimukwimba nangue, “Twasanganga menda.” ");
INSERT INTO tap_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izaaki waakiinikile, “Siba.” Ni ozo muzi i kiwakuutilua Beri-Seba ni lenu kumo. ");
INSERT INTO tap_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau lu-aakumaniizie myaka 40, waupile Bahiti babili, Yuditi mwana mwanakazi mwina Beri, ni Basemati mwana mwanakazi mwina Eloni. ");
INSERT INTO tap_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Babo banakazi baaletele bulanda kuli Izaaki ni Rebeka. ");
INSERT INTO tap_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Izaaki lu-aakotele ni kwaluka mpofu, waakuutile libeli wakue mwalalume Esau, “We mwana wane.” Mwana wakue waiteebe, “Ne ono pano.” ");
INSERT INTO tap_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Izaaki waamwanine evi, “Mona nene nakota, nsimanine busiku bwa kufua kwane. ");
INSERT INTO tap_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ale iisape utwame bilwilo byobe, buta pamo ni mivui, uye waya mu kisonso evi uye ungipailemo nama, ");
INSERT INTO tap_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","mane wize ungelekele muto mu musango untonene. Pauya kundeetela, ni ne nalia, naya nkupaale ntanzi ya kufua kwane.” ");
INSERT INTO tap_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Izaaki lu-aali walimukulanda na Esau, Rebeka waali watwiliziizie. Esau lu-aile mu kisonso mu kukumba nama aleete, ");
INSERT INTO tap_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka waamwanine Yakobo, “We mwana wane, nene naunvua so walimukulanda na mukuluubo Esau nangue, ");
INSERT INTO tap_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ndeetele nama ungelekele muto ndie, mane nkupaale pa menso akua Yawe lunsinafue.’ ");
INSERT INTO tap_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kabili Rebeka waamwanine evi, ‘Kansi we mwana wane, nakulomba ukite kindikukwana. ");
INSERT INTO tap_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Endo utwamepo misoka ibili ya mbuzi iweme, evi ngize n'mwelekele so muto mu musango u-atoneenemo. ");
INSERT INTO tap_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ni we waya umutwalile so alie, ni kukupaala ntanzi ya kufua kwakue.’” ");
INSERT INTO tap_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobo waamwanine nghina Rebeka, “We yangu, Esau ali ni bunkupili bwingi, inzi nene mubili uteleele. ");
INSERT INTO tap_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pange tawe kuti wankumia ni kwinika nangue naibeepezia kuba Esau, ni pakako, kuti naileetelela ntiipu pa kifuka kya mapaalo.” ");
INSERT INTO tap_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nghina waamwanine evi, “Ntiipu yobe ibe pali nene. Wewe kita sie munakwanina. Endo undeetele mbuzi.” ");
INSERT INTO tap_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakobo waile kutwama mbuzi ni kumuleetela nghina. Nghina waelekele muto mu musango waali watoneenemo se kwa Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nghina waabuulile ngubo iwamiisie yakua Esau mwana mukulu, ngubo i-aali wamusungiile mu nghanda ni kumuvwika Yakobo mwana mwanike. ");
INSERT INTO tap_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Rebeka waamukupiliile Yakobo mpapa ya mbuzi ku maboko ni mu mukosi. ");
INSERT INTO tap_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Waamupeele Yakobo muto pamo ni mukate bi aateaniizie. ");
INSERT INTO tap_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kupwako, Yakobo waya kumwana se nangue, “We tawe, naiza.” Se waamwipuziizie evi, “We mwana wane, uli ni?” ");
INSERT INTO tap_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo wa-asukile evi, “Ni nene libeli obe Esau. Nateania kale bintu biwanghananga. Ale buuka ulie minofu iwanghananga kuti nkuleetele, evi un'mpaale.” ");
INSERT INTO tap_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izaaki waamwipuziizie evi, “We mwana wane! Waipaya kale?” Waamwasukile, “Yawe Leza obe i wankwasia kuti ndenge ngipaye nama.” ");
INSERT INTO tap_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Izaaki waamwanine Yakobo, “Ale palama pano nkukumie nghunvue kine uli wenka mwana wane Esau ao abe.” ");
INSERT INTO tap_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kupwako, Yakobo wamupalama se, se ni ye wamukumia ni kumwana nangue, “Lizui ni lyakua Yakobo, inzi maboko ni akua Esau.” ");
INSERT INTO tap_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Izaaki taamwinikile pantu maboko akue aali akupiliilue na mpapa yaali ni masako nga bunkupili bwakua Esau. Kupwako, wamupaala. ");
INSERT INTO tap_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Izaaki waamwipuziizie Yakobo, “Ati, kubako ni kiine wewe uli mwana wane Esau?” Yakobo wa-asukile evi, “Ee, i nene wenka.” ");
INSERT INTO tap_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Izaaki waamwanine evi, “Ale n'mpalamikile minofu ya nama iwaipayanga ndie, evi nkupaale.” Yakobo waamupalamikiile bilio walia, wamuleetela ni bya kumina wamina. ");
INSERT INTO tap_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Izaaki waamwanine evi, “We mwana wane, ale palama pano unkumbatile.” ");
INSERT INTO tap_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakobo lu-aapaleeme ni kumukumbatila, Izaaki waunvwile bunu bwa ngubo yakue, wamupaala walanda, “Bunu bwa mwana wane buli nga bunu bwa kisonso kipaalilue na Yawe. ");
INSERT INTO tap_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Leza akupeele lume lwa mwiulu, ni bunonsi bwa pa kyalo, bilio ni bya kumina bingi! ");
INSERT INTO tap_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ntundu ikubombele, ni mikowa ifwiname pa ntanzi yobe. Ube mukulu pa ba kobe, ni bena noko bafwiname pa ntanzi yobe. Atiipue kubalua muntu aliwakutiipa, ni aliwakupaala apaalue.” ");
INSERT INTO tap_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Izaaki lu-aapwile kumupaala Yakobo, mu kufumapo sie, mukuluube Esau wafika wafuma mu kukumba nama. ");
INSERT INTO tap_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ni ye waelekele muto ni kumuleetela se walanda nangue, “We tawe, ale buuka ulie munani unakuleetela evi un'mpaale.” ");
INSERT INTO tap_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Se Izaaki waamwipuziizie evi, “Eba! Ale wewe uli ni?” Esau wa-asukile evi, “Ni nene libeli obe Esau.” ");
INSERT INTO tap_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Izaaki waakilile kukwaka walanda nangue, “Emwe! Ale olia muntu wandetelanga munani ni kumuliila byonse nani? Pantu i wenka unapaalanga. Ni azo mapaalo nsivinda ku-apokolola. Mapaalo ni akue.” ");
INSERT INTO tap_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau lu-aunvwile evio, waalilile malilo akata waunvwile bulanda. Waalandile evi, “We tawe, ale ni nene n'mpaale!” ");
INSERT INTO tap_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Izaaki wa-asukile evi, “Mwalaobe waizanga kun'mbeepa. Wene i wakutwaminanga mapaalo.” ");
INSERT INTO tap_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau waalandile evi, “Kansi i ki-ainikiilue Yakobo pantu Lolu i lwendo lwa bubili kungibila. Lwendo lwa mambo wangibiile nsambu yane ya bubeli, kabili evi wangibila mapaalo ane. Ati we tawe, kubako tewansungilangapo mapaalo?” ");
INSERT INTO tap_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izaaki wa-asukile evi, “Unvua, namupeela kale nsambu ya kuba mukuluubo, ni ba kwakue bonse kuti baye bamubombela. Namupaalanga kuti aye wali ni bilio ni bya kumina bingi. Ni evi nsili na mapaalo a kuti nkupaale we mwana wane!” ");
INSERT INTO tap_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau waamwanine se, “We tawe, Tekusyele ata kamo ka kuti un'mpaale ni nene?” Esau waali wapaapaata koku walimukulila. ");
INSERT INTO tap_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Izaaki waamwanine evi, “Wewe waakeekala kule ni musili ufukile, kule ni lume lwa mwiulu. ");
INSERT INTO tap_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bwikazi bobe bwaakaba bwa bului, inzi waakaba wabombela mwalaobe. Luwaakamona kuti wilubule, waakatyona mupingo wa mu mukosi obe.” ");
INSERT INTO tap_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau waamusuulile Yakobo pantu i waapaalilue na se. Waalandile evi, “Muleke sie, nsiku ya kumulila tawe ilimukuya yapalama, ni pa kyamba i panaakamwipaya mwalawane Yakobo.” ");
INSERT INTO tap_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka lu-aunvwile palua mapange akua Esau, waamwanine Yakobo, “We mwana wane, mukuluubo Esau alimukwiteekia mutima palwakua wewe wakambila kukwipaya. ");
INSERT INTO tap_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","We mwana wane, unvua vindikukwana. Butukila ku Harani kuli ndumyamwine Labani, ");
INSERT INTO tap_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","evi uye wikaleko nsiku iniini mpaka kipuki kyakua mukuluubo kikapue ");
INSERT INTO tap_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ni kukweleela kiwakimukitila, mane nkakulaizie ukeeze, pantu kuti kyakila kun'mbiipila kufwilua na bantu babili busiku bumo.” ");
INSERT INTO tap_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka waamwanine Izaaki, “Nalwala, kabili napeleelua pa mulandu wa banakazi Bahiti. Kine Yakobo waupa umo wa pa baba banakazi Bahiti ba mu keno kyalo, kyawama sie ni kufua.” ");
INSERT INTO tap_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kupwako, Izaaki wamukuuta Yakobo. Wamupaala wamwana nangue, “Tekuti ukoope mwanakazi Mukanaani. ");
INSERT INTO tap_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Inzi endo waya ku Padani-Aramu, ku nghanda yakua Betueli se kwa noko. Koko i kwa kuti ukaye kuupila. Ukoope mwana mwanakazi mwina mwinzyobo Labani. ");
INSERT INTO tap_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Leza wa Maka onse akupaale ni kukusandulula ni kukuvuzia kuba libumba lya bantu! ");
INSERT INTO tap_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Leza apaale nvyalo yobe nga vi-aapaalile Abrahamu, evi kyalo kiwikeelemo wali mweni kibe kyobe, kyalo kyaapeelue Abrahamu na Leza!” ");
INSERT INTO tap_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Izaaki waamwanine Yakobo ailepo bwino ku Padani-Aramu kuli Labani waali mwana mwalalume mwina Betueli wa ku Aramea. Labani waali ndumeze kwa Rebeka nghinabo kwa Yakobo ni Esau. ");
INSERT INTO tap_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau waamwene nangue Izaaki waamupaalile Yakobo ni kumutuma kuti aye oopile ku Padani-Aramu. Kabili waamwene nangue lu-aamupaalile, waamwanine tekuti akoope mwanakazi Mukanaani. ");
INSERT INTO tap_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau waamwene nangue Yakobo waamunakiile se pamo ni nghina ni kuya ku Padani-Aramu. ");
INSERT INTO tap_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau wainikile nangue se Izaaki taali wawamiinue na banakazi ba ku Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ni pakako, Esau waile kuupilapo mukazi unge pa balia bakazi ba-aali nabo. Ozo mwanakazi waali wakuutua Mahalati mwana mwanakazi mwina Isimaeli. Isimaeli waali mwana mwalalume mwina Abrahamu. Ozo mukazyana waali nkaziize kwa Nebayoti. ");
INSERT INTO tap_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo waafumine ku Beri-Seba waya ku Harani. ");
INSERT INTO tap_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Waafikile pa nkendo imo, walaala pantu busiku bwailile. Waabuulilepo libue limo ni kusaaminapo mutue wakue. Papo i pa-aaleele ni kuona. ");
INSERT INTO tap_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Waalootele ni kumona kiselelo kyaimikilue pansi kyakumizie mwiulu, ni bamalaika bakua Leza balimukusela ni kukooka mu kiselelo. ");
INSERT INTO tap_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yawe waali waimeene peulu kiselelo ni kulanda nangue, “Nene ndi Yawe Leza wakua Abrahamu ni wakua Izaaki. Keki kyalo ki-uleelepo naakakupeela wewe pamo ni nvyalo yobe. ");
INSERT INTO tap_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nvyalo yobe yaakaba nga lufunko lwa pa kyalo. Kabili yaakakumana kufuma ku mboosi mpaka ku kabanga, kufuma ku nkungua mpaka ku nkungulua. Muli wewe pamo ni nvyalo yobe, ntundu yonse ya pa kyalo yaakapaaliluamo. ");
INSERT INTO tap_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nene ndi pamo nobe, naakakusunga konse ku waakaya, kabili naakakubweziizia mu keno kyalo, pantu nsikakusia mpaka nkafikilizie bulayo bunaakulaile.” ");
INSERT INTO tap_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo lu-abuukile mu tulo waalandile evi, “Kisinka Yawe ali pano, nene nsyamananga!” ");
INSERT INTO tap_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakobo waatiinine walanda nangue, “Iye, pano pantu pakila kutiinia! Pano te pange, inzi ni pa Nghanda yakua Leza, kabili i pa mulyango wa mwiulu.” ");
INSERT INTO tap_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Lukeele lwakue paakili lukeelekeele, Yakobo waabuukile, wabuula libue li-aali wasaamiinepo, waliimika misiki nga lipumpu ni kupongwelapo mafuta. ");
INSERT INTO tap_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Pa ezio nkendo waapeenikile Beteli. Ozo muzi kale waali wakuutua Luzi. ");
INSERT INTO tap_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakobo waalapile walanda nangue, “We Yawe, kine ulikunsunga mu lwendo lwane ni kun'mpeela bilio ni ngubo ya kuvwala, ");
INSERT INTO tap_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ni kubwela nakosele ku nghanda yakua tawe, Yawe waakaba Leza wane. ");
INSERT INTO tap_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Leli libue linaimika nga lipumpu lyaakaba Nghanda yakua Leza, ni pa byonse biwaakan'mpeela, naakafumiapo kamo ka pa lyanondo ni kukupeela.” ");
INSERT INTO tap_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo waatwaliliile mu lwendo lwakue ni kuya kufika mu kyalo kya bantu ba ku kabanga. ");
INSERT INTO tap_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Waamwene kiina kya menda mu bukaba pamo ni bisepe bitatu bya mikooko yaali yaleele mumbali. Bebi bisepe byaali byanwinsiiwa menda pa kekio kiina kya menda, ni po paali patupikilue libue likata. ");
INSERT INTO tap_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bisepe byonse lubyaali byaiza pa kumina menda, basungi baali batupukulapo libue pakuti mikooko imine menda. Luyaali yapua kumina, kabili basungi baali batupikilapo. ");
INSERT INTO tap_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo waabeepuziizie basungi, “Ati mwe ba kwane, muli ba kupi?” Baamwasukile nangue, “Fwefue tuli ba ku Harani.” ");
INSERT INTO tap_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Waabeepuziizie evi, “Mumumanine Labani mwinzikulu wakua Nahori?” Baamwasukile nangue, “Ee, tumumanine.” ");
INSERT INTO tap_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kabili waabeepuziizie evi, “Ati, Labani akosele?” Ba-asukile evi, “Ee, akosele, ni Rakeli mwana wakue mwanakazi olia alimukwiza ni mikooko.” ");
INSERT INTO tap_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobo waalandile evi, “Emwe, mone kakili koba, ono te musita wakukolonghania mikooko ni kwinwinsia menda. Ale nwinsie mikooko mwitwale ku kulia bikusi.” ");
INSERT INTO tap_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Baamwanine evi, “Ata, tetuvinda kunwinsia kale ezi mikooko inge luisinakolonghaniwe. Mpaka ni inge ileetuenke mane tutupukule keki kilibue ni kwinwinsia.” ");
INSERT INTO tap_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo lu-aali wakilimukulanda nabo, Rakeli waafikile ni mikooko yakua se pantu wene i waali musungi. ");
INSERT INTO tap_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo lu-aamwene Rakeli mwina Labani ndumeze kwa nghina, ni mikooko yakua mwinzioye, waile pa kiina kya menda ni kutupukulapo kilibue. Kupwako, wabamba kunwinsia mikooko yakua mwinzioye. ");
INSERT INTO tap_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakobo waamukumbatiile Rakeli ni kutendeka kulila wa-angwile. ");
INSERT INTO tap_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo waamwanine Rakeli nangue, “Nene ndi wa mu lupua lwakua so, kabili ndi mwina Rebeka.” Penka papo, Rakeli waya kale lubilo aye amubwileko se. ");
INSERT INTO tap_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani lu-aunvwile sie nangue mwipua wakue waiza, waile kumusensekela wali lubilo. Luamusangile, waamukumbatiile. Kupwako, waingila nakue mu nghanda yakue, ni Yakobo waamulondolwela Labani byonse byaakitikile. ");
INSERT INTO tap_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani waalandile evi, “Kisinka wewe uli lupua lwane, kabili tuli mubili umo ni mulopa umo.” Yakobo waikeele koko mwezi walingi. ");
INSERT INTO tap_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani waamwanine Yakobo nangue, “Anzia kine uli mwipua wane, nsivinda kukubombia sie kya mpuni. Landa nsazio in'mpalile kuya nakusazia.” ");
INSERT INTO tap_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani waali wali na baana babili bakazyana. Mukulu waali wakuutua Lea, ni mwanike waali wakuutua Rakeli. ");
INSERT INTO tap_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Menso akua Lea aali atope, inzi Rakeli waali waweme mubili ni lukebu. ");
INSERT INTO tap_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo waamutonene Rakeli. Waamwanine Labani nangue, “Naakakubombela myaka kilooba pa mulandu wakua Rakeli mwana obe mwanike.” ");
INSERT INTO tap_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani waalandile evi, “Ee, kuti kyawama kukupeela wewe kukila unge. Ikala nane pamo.” ");
INSERT INTO tap_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakobo waabombele myaka kilooba pa mulandu wakua Rakeli. Inzi yaamwenekele sie nga nsiku iniini pantu waali wamutoneesie. ");
INSERT INTO tap_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yakobo waamwanine Labani, “N'mpeele Rakeli abe mukazi wane, ndaale nakue pantu nsiku yane yakumana.” ");
INSERT INTO tap_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ni pakako, Labani waateaniizie matebeto ni kukupa bantu ba mu muzi. ");
INSERT INTO tap_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Musita wa kyungulo, waamutweme Lea ni kumutwalila Yakobo, ni ye waleele nakue. ");
INSERT INTO tap_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani waabuulile mubombi wakue mukazyana liina lyakue Silipa ni kumupeela Lea kuti aye wali mubombi wakue. ");
INSERT INTO tap_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Lubwaakiile, Yakobo wainikile nangue waufiiziwe Lea. Yakobo waamwipuziizie Labani, “We mwinzio, ni syani? Ne naabombeele kuufiwa Rakeli. Ale wakin'mbeepelaki?” ");
INSERT INTO tap_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani wa-asukile evi, “Kono kwetu tetuli na mibeele ya kuufianke mwanike kine mukulu tanaupue. ");
INSERT INTO tap_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Pwilililanke mulungu umo wa nsikunkulu yakua Lea. Mane tukabe kukupeela Rakeli wakuti ukabombele inge myaka kilooba.” ");
INSERT INTO tap_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo waitabiile. Lu-aapwile mulungu umo mu bwinga bwakue, Labani waufiizie Rakeli kuli Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani waabuulile mubombi wakue mukazyana liina lyakue Biliha ni kumupeela Rakeli kuti aye wali mubombi wakue. ");
INSERT INTO tap_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobo waile kulaala ni Rakeli, kabili waali wamutoneesie Rakeli kukila Lea. Ni pakako, waamubombeele Labani inge myaka kilooba. ");
INSERT INTO tap_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yawe lu-aamwene nangue Lea taali watonenue, waapeelue buvyazi, inzi Rakeli waali wali nghumba. ");
INSERT INTO tap_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea lu-aimitile, waavyele mwana mwalalume. Lea waalandile evi, “Yawe Leza wamona maavia ane, evi mulume wane alikuntona.” Ni pakako, ozo mwana waamwinikile Rubeni. Kabili waalandile evi, “Wakimona bwavia bwane.” ");
INSERT INTO tap_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kabili lu-aimitile, waavyele mwana mwalalume. Lea waalandile evi, “Yawe Leza wan'mpeela ozu mwana mwalalume pantu wakyunvua nangue nene nsitonenue.” Ni pakako, ozo mwana waamwinikile Simeoni. ");
INSERT INTO tap_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kabili lu-aimitile, waavyele mwana mwalalume. Lea waalandile evi, “Lono lwendo mulume wane alikukila kwampana ni nene pantu namuvyalila kale baana batatu balalumenke.” Ni pakako, ozo mwana waamwinikile Lawi. ");
INSERT INTO tap_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kabili lu-aimitile, waavyele mwana mwalalume. Lea waalandile evi, “Lono lwendo namutasia Yawe.” Ni pakako, ozo mwana waamwinikile Yuda. Kupwako ni luvyalo lwapela. ");
INSERT INTO tap_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakeli lu-aamwene nangue wene taamuvyaliile Yakobo baana, waamunvwiliile mukuluube bunkua. Rakeli waamwanine Yakobo nangue, “We Yakobo, n'mpeele baana, kine teun'mpeele ndikufua.” ");
INSERT INTO tap_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo waamufiitiilue Rakeli. Waalandile evi, “Eba, nene i Leza waakulengiizie kuba nghumba?” ");
INSERT INTO tap_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rakeli waamwanine Yakobo, “Ndi ni mubombi wane Biliha. Laala nakue anvyalile baana, evi kupitila muli wene ngie nali ni luvyalo.” ");
INSERT INTO tap_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rakeli waamupeele mulume wakue nsambu ya kuupa Biliha. Yakobo waaleele nakue. ");
INSERT INTO tap_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha lu-aimitile, waamuvyaliile Yakobo mwana mwalalume. ");
INSERT INTO tap_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rakeli waalandile evi, “Leza wapingula mulandu wane, waunvua mapepo ane ni kun'mpeela mwana mwalalume.” Ni pakako, ozo mwana waamwinikile Dani. ");
INSERT INTO tap_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kabili Biliha mubombi wakua Rakeli lu-aimitile, waamuvyaliile Yakobo mwana mwalalume wa bubili. ");
INSERT INTO tap_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rakeli waalandile evi, “Bului bunalwana na mukuluamwine ni bukata, inzi namwanzia.” Ni pakako, ozo mwana waamwinikile Nafutali. ");
INSERT INTO tap_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea ni ye lu-aamwene nangue buvyazi bwapua, waufiizie mubombi wakue Silipa ku mulume wakue. ");
INSERT INTO tap_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silipa mubombi wakua Lea waamuvyaliile Yakobo mwana mwalalume. ");
INSERT INTO tap_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea waalandile evi, “Nasyuka!” Ni pakako, ozo mwana waamwinikile Gadi. ");
INSERT INTO tap_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silipa mubombi wakua Lea waamuvyaliile Yakobo unge mwana mwalalume wa bubili. ");
INSERT INTO tap_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Kabili Lea waalandile evi, “Nasansamuka! Pantu bakazyana balikuyabankuuta asyukile.” Ni pakako, ozo mwana waamwinikile Aseri. ");
INSERT INTO tap_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Musita wa kuseepa nghano, Rubeni waile mu bukaba, waya kusangamo kitwabalindu ni kumutwalila nghina. Rakeli waamwanine Lea, “N'mpeele miti ya luvyalo yakua mwana obe Rubeni.” ");
INSERT INTO tap_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea waamwanine evi, “Eba, we wan'mpokele mulume, kabili tewakeba kun'mpoka ni miti yakua mwana wane Rubeni?” Rakeli wa-asukile evi, “Lelo Yakobo alikulaala ku nghanda yobe pa mulandu wa miti ya luvyalo yakua mwana obe.” ");
INSERT INTO tap_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yakobo lu-aafumine ku makaba musita wa kyungulo, Lea waile kumusensekela ni kumwana nangue, “Lelo ulikulaala ku nghanda yane pantu nakusitanga kuli Rakeli na kitwabalindu kyakua mwana wane.” Ni pakako, bobo busiku waaleele ku nghanda yakua Lea. ");
INSERT INTO tap_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Leza waunvwile mapepo akua Lea. Lea lu-aimitile, waamuvyaliile Yakobo mwana mwalalume wa busaano. ");
INSERT INTO tap_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea waalandile evi, “Leza wanambula pantu naufiizie mubombi wane kuli mulume wane Yakobo.” Ni pakako, ozo mwana waamwinikile Isakari. ");
INSERT INTO tap_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kabili Lea lu-aimitile, waamuvyaliile Yakobo mwana mwalalume wa mutanda. ");
INSERT INTO tap_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea waalandile evi, “Leza wanambula kilambu kiweme. Evi mulume wane waya wasyankindika pantu namuvyalila baana mutanda.” Ni pakako, ozo mwana waamwinikile Zabuloni. ");
INSERT INTO tap_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pa kyamba, waavyele mwana mwanakazi ni kumwinika Dina. ");
INSERT INTO tap_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kabili Leza waamulangulukile Rakeli. Leza lu-aunvwile mapepo akue, waizwile buvyazi bwakue. ");
INSERT INTO tap_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rakeli lu-aimititile, waavyele mwana mwalalume. Rakeli waalandile evi, “Leza wan'mpwisia busoni pantu wan'mpeela mwana mwalalume.” ");
INSERT INTO tap_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ni pakako, ozo mwana waamwinikile Yusufu, Kuti kyawama Yawe anundilepo ni unge mwana mwalalume. ");
INSERT INTO tap_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rakeli lu-aamuvyele Yusufu, Yakobo waamwanine Labani, “N'mpeele nsambu ya kubwelela ku kyalo kyetu, ");
INSERT INTO tap_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","un'mpeele bakazi bane pamo ni baana banaakubombeele ngie nabo pantu umanine mwilo unaakubombeele.” ");
INSERT INTO tap_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani waamwanine Yakobo nangue, “Kine wangitabila, ikala sie kwenka kono pantu nakibuka ni kumona nangue Yawe wakin'mpaala kupitila muli wewe.” ");
INSERT INTO tap_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Labani waalandile evi, “Nghane nsazio yobe ni ne ndikukusazia.” ");
INSERT INTO tap_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo waamwanine evi, “We mwine umanine vinakikubombela ni nghombe viyakivula kuli nene. ");
INSERT INTO tap_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Lunaali nsinaize, nama yobe teyaali yavulile, inzi evi ivulile. Yawe wakikupaala kupitila muli nene. Ale ni musitaki unakaba kubombela ba mu nghanda yane?” ");
INSERT INTO tap_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani waamwipuziizie evi, “Ale ndikukupeelaki?” Yakobo wa-asukile evi, “Teun'mpeela kantu, kine ulikunkitila keki kintu, ndikutwalilila kuliisia ni kusunga kisepe kyobe. ");
INSERT INTO tap_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Lelo ndikupita mu kisepe kyobe kyonse nalimukufumia kubalua nama wa mabala mabala ni mantolintoli, ni kubalua nama wa fi pa mikooko, ni wa mabala mabala pa mbuzi. Ezio i yaakaba nsazio yane. ");
INSERT INTO tap_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kisinka kyane kyaakamoneka bobo busiku buwaakeeza kumona nsazio yane. Kine ukeeze kusanga mbuzi asili na mabala mabala ao mantolintoli, ao kubalua mukooko asili wa fi, wewe waakaba wali ni nsambu ya kulanda nangue nakikwibila.” ");
INSERT INTO tap_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani waamwanine evi, “Ee, kibe nga muwalandila.” ");
INSERT INTO tap_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bobo busiku Labani waafumiiziepo tupwata twa mabala mabala ni twa mingoloozio, ni mbuzi ikota ya mabala mabala ni mantolintoli, ni ya mabala mabala a sue pamo ni mikooko ya fi wapeela baana bakue. ");
INSERT INTO tap_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ezio nama baile nayo kule kwa kwenda nsiku itatu. Yakobo wene waasyele wasunga kisepe kyakua Labani. ");
INSERT INTO tap_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobo waabuulile misambo ibisi ya milibna ni ya mlozi ni ya mwaramoni, waubulako mamba pakuti mumoneke mingoloozio ya sue. ");
INSERT INTO tap_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ezio misambo i aubwileko waiimikile mu biziba bya menda byaali byaminamo nama yakentele ku misambo. Nama yaimitiile papo payaali yaiza kuminina menda. ");
INSERT INTO tap_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Nama yaimitile ntanzi ya misambo yaali mu menda. Nama yaavyele twana twa mingoloozio, ni twa mabala mabala pamo ni twa mantolintoli. ");
INSERT INTO tap_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo waakasaniizie mikooko, wabiika nama yakentele ku nama ili ni mingoloozio ni kubalua nama wa fi wakua Labani. Wabiika bisepe byakue kule, kabili taasanziizie pa bisepe byakua Labani. ");
INSERT INTO tap_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nama yaamwenekelepo yalumine luyaimitile, Yakobo waabiikile misambo ku ntanzi ya ezio nama palia payaali yaminina menda, evi iye yaimitila pa ezio misambo. ");
INSERT INTO tap_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Inzi ezio misambo taibiikile ku ntanzi ya nama yaali itope. Evi Yakobo i vi-aakwete nama ilumine, ni Labani nama itope. ");
INSERT INTO tap_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yakobo waanonkeesie. Waali wakwete bisepe bingi. Waali wakwete babombi bengi balalume ni banakazi, ni nghamia pamo ni punda. ");
INSERT INTO tap_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo waunvwile baana balalume bena Labani balanda nangue, “Mwamona! Yakobo watwama bunonsi bonse bwakua situe. Bobu bunonsi bonse wanonkela mu bunonsi bwakua situe.” ");
INSERT INTO tap_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo waamwene lukebu lwakua Labani tekuba lwali nga vilwaali pa mambo. ");
INSERT INTO tap_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yawe waamwanine Yakobo, “Bwelela mu kyalo kya babikolue bobe uye wikale kwikeele bantu bobe, ni nene naakaba naali pamo nobe.” ");
INSERT INTO tap_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakobo waamukuutile Rakeli ni Lea beze basaakaane nakue ku kisonso kwaali kwali bisepe byakue. ");
INSERT INTO tap_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Waabaanine evi, “Namona lukebu lwakua sinue tekuba lwali nga vilwaali pa mambo. Inzi Leza wakua tawe ali pamo nane. ");
INSERT INTO tap_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kabili mumanine bwino nangue nene naamubombeele sinue na maka ane onse. ");
INSERT INTO tap_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Sinue wan'mbiibikiziizie ni kwalulula nsazio yane nghendo lyanondo, inzi Leza wandabukiile. ");
INSERT INTO tap_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Labani lu-aalandile nangue mikooko ya mabala mabala i yaakaba nsazio yobe, kisepe kyonse kyaavyele twana twa mabala mabala. Kabili lu-aalandile nangue ya mingoloozio i yaakaba nsazio yobe, kisepe kyonse kyaavyele twana twa mingoloozio. ");
INSERT INTO tap_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Evi Leza i vi-aan'mpeele bisepe bi-aafumiizie mu bisepe byakua sinue. ");
INSERT INTO tap_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Musita wakuti ezi nama iimite, naalootele nama ndume ya mabala mabala ni ya mingoloozio pamo ni ya mantolintoli yalimukusela pa ikota. ");
INSERT INTO tap_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Naalootele malaika wankuuta nangue, ‘Yakobo.’ Ni nene na-asukile, ‘Ne ono pano.’ ");
INSERT INTO tap_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Wanghanine evi, ‘Mona,’ nama ndume yonse ya ezi nama i uliwasunga, ilimukusela pa ikota yali ni mabala mabala, ni mingoloozio, ni mantolintoli. Nakita evi pantu n'mwene Labani vi-alimukukubiibikizia. ");
INSERT INTO tap_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nene ndi Leza waakumwenekeele ku Beteli lolia luwaapongweleele mafuta a mizeituni pa libue liwaasaamiinepo ni kundaya. Ale bwelela ku kyalo ku waavyaliilue.” ");
INSERT INTO tap_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rakeli ni Lea baamwanine evi, “Fwefue tetukili na kantu kakuti tukapyane mu nghanda yakua Situe. ");
INSERT INTO tap_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Fwefue tupendelue sie nga baeni mu nghanda yakua situe. Wene waatusisiizie, ni nfolanga yonse waaliile sie bunke. ");
INSERT INTO tap_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bobu bunonsi bobe bonse buuli nabo bwaabuulile Leza pa bunonsi bwakua situe, i bunonsi bwetu pamo ni baana betu. Wewe kita sie kyonse kyakikwana Leza.” ");
INSERT INTO tap_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kupwako, Yakobo wasezia baana bakue pamo ni bakazi bakue peulu nghamia. ");
INSERT INTO tap_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Mu lwendo lwakue lwa kubwelela kuli se mu kyalo kya Kanaani, waile ni biteekua byakue byonse pamo ni bunonsi bwakue bonse bu-aanonkele ku Padani-Aramu. ");
INSERT INTO tap_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani lu-aali waile ku kutebula masako a mikooko yakue, Rakeli waibile baleza bakua se. ");
INSERT INTO tap_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo waamuzembulukile Labani Muaramea pasili kumulaya. ");
INSERT INTO tap_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakobo waatweme bintu byakue byonse waya. Lu-aile kwabuka mwenzi wa Efrati, waile walungheeme lya ku kyalo kya mpili kya Gileadi. ");
INSERT INTO tap_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Pa busiku bwa butatu, Labani waabwililue nangue Yakobo wakibutuka. ");
INSERT INTO tap_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Waile pamo ni ba kwakue wamukonkele Yakobo. Busiku bwa kilooba, waile kumusanga mu kyalo kya mpili kya Gileadi. ");
INSERT INTO tap_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Leza waizile kumwana Labani Muaramea mu kilooto musita wa busiku nangue, “Kengela, tekwezia kumwana Yakobo kantu kaweme ao kabiipile.” ");
INSERT INTO tap_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani lu-aamusangile Yakobo, Yakobo waali waimikile liema lyakue mu kyalo kya mpili kya Gileadi, Labani ni bantu bakue ni ye waimikile liema mu kyalo kya mpili kya Gileadi. ");
INSERT INTO tap_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani waamwanine Yakobo, “Wakinzembulukilaki watwama ni baana bane banakazi nga banakazi bakwetue ku bului? ");
INSERT INTO tap_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ale wakinzembulukilaki pasili kunghana? Pantu unghanenge, nga nakikulaya bwino. Nga pakiimbua nghimbo ni kombua nghoma pamo ni kulizia bilimba. ");
INSERT INTO tap_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kabili tewakin'mpeela nsambu ya kubalaya nabakumbatila benzikulu bane pamo ni baana bane. Waakikita bintu bimo bya bulubi. ");
INSERT INTO tap_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nene ndi ni nsambu ya kukukitila kintu kibiipile, inzi Leza wakua so wakinsoka lukeele busiku kuti nkengele, kabili tekuti nkwane kantu kaweme ao kabiipile. ");
INSERT INTO tap_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","N'manine nangue uli ni nkulu ya kubwelela kuli so. Ale kiwakiibila baleza bane ni kiki?” ");
INSERT INTO tap_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo waamwasukile evi, “Nakitiina kukulaya pantu nakimona nangue pange kuti wan'mpoka baana bobe bakazyana mu maka. ");
INSERT INTO tap_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kansi kine wasangapo umo pakati ketu wali ni babo baleza bobe, tapalile kuba mukose. Ale iza umone kine pali ni kintu kyobe, kine pakili ukitwame.” Yakobo waalandile evio pantu taali wamanine nangue Rakeli i waali waibile baleza bakua Labani. ");
INSERT INTO tap_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kupwako, Labani waingila mu liema lyakua Yakobo, ni mu liema lyakua Lea, ni mu liema lya babombi babili banakazi. Momo taasangilemo baleza bakue. Kabili waile kwingila ni mu liema lyakua Rakeli. ");
INSERT INTO tap_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rakeli i waali watweme babo baleza ba mu nghanda ni kuya wababiikile pensina mpapa i-aali wapanzikile pa nghamia ni kuya waikeelepo. Labani waakebele mu maema onse pasili kumona. ");
INSERT INTO tap_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeli waamwanine se nangue, “We tawe, tekunfiitilua pantu nsimeene pa ntanzi yobe. Ndimukutiina kwimana pantu ndwele malwele a banakazi.” Labani waakilile kukeba pasili kusanga baleza bakue. ");
INSERT INTO tap_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobo waakilile kufiitua. Waalandile evi, “Eba, nene nakikuluviaki pakuti wize wankonkele wafiitilue mu ozu musango?” ");
INSERT INTO tap_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mu bintu byane byonse biwakebamo, kine wasangamo kintu kyobe, kibiike papa kimonue na bantu bobe ni bantu bane, evi batupingule kine nani ali ni nsambu. ");
INSERT INTO tap_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nakiikala nobe myaka 20. Mikooko yobe ao mbuzi yobe teyaapulumwine ata livumo, kabili nsyaaliilepo mpanga wa pa bisepe byobe. ");
INSERT INTO tap_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Naali nakita kine mukooko waipawa na kinama, napyanikiziapo unge. Nsyaali nakuleetela ni kukwana nangue te kilubo kyane. Mikooko yonse yaali yaibua musita wa koba ni musita wa busiku, waali wanomba kuti nkubweziizie. ");
INSERT INTO tap_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Musita wa koba naali nazia na lyuza, ni musita wa busiku naali naumina na kasama. Nsyaali nalaala. ");
INSERT INTO tap_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Evi i vinaemene myaka yonse 20 naali mu nghanda yobe. Pakuti ungufie baana bobe babili, naakubombeele myaka lyanondo ni ina. Kabili naakubombeele myaka mutanda pakuti un'mpeele bisepe bya nama anzia kine waali wa-alulula alulula sie nsazio yane nghendo yonse lyanondo. ");
INSERT INTO tap_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kabenge Leza wakua tawe ni Leza wakua Abrahamu, Leza waatiininue na Izaaki, tekuba wali pamo nane, kisinka wewe nga wankumbile kale pasili kun'mpeela kantu. Inzi Leza waamwene maavia ane ni kubomba kunaakubombeele. Kabili wakikusoka lukeele busiku. ");
INSERT INTO tap_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani waamwanine Yakobo, “Babo baana banakazi, ni bane. Baana babo ni bo ni bane, ni bebi bisepe ni byo ni byane. Bebi byonse bi umwene ni byane. Inzi evi nsili na buvinde bwa kusunga babo baana bane pamo ni benzikulu. ");
INSERT INTO tap_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kansi evi, twende tupinghane pakuti kiye kyali kisininkizio pakati kobe ni nene.” ");
INSERT INTO tap_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kupwako, Yakobo wabuula libue ni kuliimika nga lipumpu. ");
INSERT INTO tap_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakobo waabaanine bantu bakue batoole mabue ni ku-atuulika pepi na lelio libue. Kupwako, Yakobo ni Labani babamba kulia baikeele mumbali mabue. ");
INSERT INTO tap_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Pa ezi nkendo Labani waapeenikile Yegari-Sahaduta. Inzi Yakobo wene waapeenikile Galedi. ");
INSERT INTO tap_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani waamwanine Yakobo, “Aza mabue i-aakaba kisininkizio kyetu bonse babili.” Ni pakako, ozo mului wainikilue Galedi, ");
INSERT INTO tap_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ni lelia libue ni lyo lyainikilue Misipa. Pantu Labani waalandile nangue, “Yawe aye watukenteleele fwe bonse babili pa tukalekana.” ");
INSERT INTO tap_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labani waalandile evi, “Kine ukeemie baana bane banakazi ao kuupilapo bange, anzia kine ne nsikaba namanine, ukamane sie nangue Leza i musininkizi pakati ketu.” ");
INSERT INTO tap_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani waamwanine Yakobo, “Mona ozu mului wa mabue ni lipumpu linakiimika pakati kobe ni nene. ");
INSERT INTO tap_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ozu mului pamo ni leli lipumpu biye byali kisininkizio kya kulangulukilako nangue nene nsikataaluka ozu mului ni kwiza kukusakukila, ao wewe kutaaluka ozu mului ni kwiza kunsakukila. ");
INSERT INTO tap_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Leza wakua Abrahamu ni Leza wakua Nahori, ni Leza wa babikolue babo, akatupingule fwe bonse babili.” Yakobo waalapile mu Liina lyakua Leza aliwatiinua na se Izaaki. ");
INSERT INTO tap_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo waipaile nama ni kwelela peulu lupili, kabili waakupile bantu bakue kuti balie nakue ozo munani. Pa kyamba, baaleele penka papo peulu lupili. ");
INSERT INTO tap_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Labani lu-aabuukile paakili lukeelekeele, waakumbatiile baana bakue pamo ni benzikulu ni kubaana bailepo bwino. Kupwako, Labani wabwelela kwakue. ");
INSERT INTO tap_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo lu-aali walimukubwelela kwabo, bamalaika bakua Leza baasaakeene nakue. ");
INSERT INTO tap_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo lu-aamwene babo bamalaika waalandile nangue, “Leli i libumba lyakua Leza.” Ni pakako, pa ezio nkendo wainikilepo Mahanaimu. ");
INSERT INTO tap_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo waatumine mikenzi kuli mukuluube Esau mu Seiri, mu kyalo kya Edomu. ");
INSERT INTO tap_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Waabalaiziizie wabaana baye balande nangue, “Mubombi obe Yakobo walanda evi, ‘We mukuluamwine, naile kwikala ni Labani nali mweni ezi myaka yonse, ");
INSERT INTO tap_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ni evi naiza nali ni nghombe, ni punda, ni mikooko, ni mbuzi, pamo ni babombi balalume ni banakazi. Nalaizia evio naswapiile kwitabilua na we mukuluamwine.’” ");
INSERT INTO tap_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mikenzi yaizile kubwezia kapingu kuli Yakobo nangue, “Twayanga kuli mukuluubo Esau, ni ye alimukwiza kukupokelela wali ni bantu 400.” ");
INSERT INTO tap_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobo lu-aunvwile evio, waatoobokele ni kutiina. Ni pakako, waakasaniizie bantu ba-aali nabo pamo ni mikooko, ni mbuzi, ni nghombe, pamo ni nghamia mu mabumba abili. ");
INSERT INTO tap_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Waalandile evi, “Kine Esau waiza kusakukila libumba limo, linge lilikupusuka.” ");
INSERT INTO tap_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kabili waamulombele Leza walanda nangue, “We Leza wakua tawekulu Abrahamu ni wakua tawe Izaaki, we Yawe wanghanine nangue, ‘Bwelela ku kyalo kyobe ni ku lupua lobe evi nkakukitile biweme.’ ");
INSERT INTO tap_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Naikeefia ku buwame ni ku kisinka kyobe kiwaanangisiizie ne mubombi obe, pantu mwenzi wa Yordani naawabukile tekuba natweme kantu inga sie kabango, inzi evi nabwela natweme mabumba abili. ");
INSERT INTO tap_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nakulomba un'mpususie kuli mukuluamwine Esau, pantu natiina nkeeza kusakukilua, nene ni bakazi bane pamo ni baana bane. ");
INSERT INTO tap_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","We Leza languluka bulayo buwandaile nangue waakankitila biweme ni kuvuzia nvyalo yane, ikabe yavulile nga musenga wa mumbali lyezi usili wavinda kupendua na muntu.” ");
INSERT INTO tap_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Bobo busiku Yakobo waaleele penka papo. Kupwako, wabuulapo bimo pa bintu bi-aali nabio, evi amutwalile mukuluube Esau kilambu. ");
INSERT INTO tap_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Waabuulile makota a mbuzi 200 ni tupwata 20 ni mikooko ikota 200 ni mpanga 20, ");
INSERT INTO tap_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","nghamia 30 yaali yaonsia pamo ni twana twabo, nghombe ikota 40 ni nghombe ndume lyanondo, punda ikota 20, ni punda ndume lyanondo. ");
INSERT INTO tap_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yakobo waakasaniizie bisepe, kubalua kisepe kyaali kyali ni musungi umo. Waabaanine basungi nangue, “Ale abuke mwenzi muntangilile, kubalua kisepe kiye kyaenda kyalekenkeene ni kinge.” ");
INSERT INTO tap_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakobo waamwanine mubombi wa mambo nangue, “Esau pa-aya kusaakaana nobe ni kwipuzia nangue, ‘Wewe uli muntu wakua ni? Kabili ulimukuya pi? Ni ezi nama ikutangiliile ni yakua ni?’” ");
INSERT INTO tap_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Uye umwane nangue, “Ezi nama ni yakua mubombi obe Yakobo. Wene wamutumina selenzi Esau. Inzi Yakobo alimukwiza pa kyamba kyetu.” ");
INSERT INTO tap_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Evi i vya-anine ni musungi wa bubili, ni wa butatu, ni bange basungi ba bisepe. Evi i vyakuti muye mulande pamuya kusaakaana ni Esau. ");
INSERT INTO tap_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kabili muye mulande nangue, “Mubombi obe Yakobo alimukwiza pa kyamba.” Yakobo waali walangakana evi, “Bobu bupe bunamutumina, pange bulikumufuukiako mutima evi n'monane nakue ni kungeleela bilubo byane.” ");
INSERT INTO tap_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Evi i vyaatangiile bupe bwakue. Yakobo waasyele kulaala papo pa tutanda. ");
INSERT INTO tap_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bobo bwenka busiku musita wa busiku Yakobo waabuukile, watwama bakazi bakue babili ni babombi bakue banakazi babili pamo ni baana bakue lyanondo ni umo, waya kwabuka pa musalala wa mwenzi wa Yaboki. ");
INSERT INTO tap_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Yakobo wa-abusiizie lupua lwakue pamo ni bintu byakue byonse bi-ali nabio, ");
INSERT INTO tap_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","inzi waasyele bunke ku kyamba. Kwaizile muntu umo waabambile kukanzana nakue mpaka ku makia. ");
INSERT INTO tap_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ozo muntu lu-aamwene nangue wamwandua, waamukwete Yakobo pa kitungu, kitungu kyakua Yakobo kyaavyukile musita u-ali walimukulua nakue. ");
INSERT INTO tap_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ozo muntu waalandile evi, “Ndekele ngie naya! Mona pasyabukie.” Yakobo waalandile evi, “Nsikulekela kine teunan'mpaale.” ");
INSERT INTO tap_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ozo muntu waamwipuziizie evi, “Liina lyobe uli ni?” Wa-asukile nangue, “Nene ndi Yakobo.” ");
INSERT INTO tap_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ozo muntu waalandile evi, “Wewe teukiya wakuutua Yakobo pantu wakanzana na Leza ni bantu, ni we wa-anzia. Inzi waya wasyakuutua Izraeli.” ");
INSERT INTO tap_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo waamwipuziizie evi, “Ale wewe uli ni?” Waamwasukile, “Wangipuziiziaki Liina lyane?” Kupwako, ozo muntu wamupaala Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo waalandile evi, “Namonana ni Leza, kabili nasyala nakosele.” Ni pakako, pa ezio nkendo wainikilepo nangue, “Penueli.” ");
INSERT INTO tap_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Koba lukaali kasyatula, Yakobo waafumine pa Penueli ni kubamba kuya wasunkuta pantu waali wavyulilue kitungu kyakue. ");
INSERT INTO tap_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ni pakako, Baizraeli i kibasilibaliila buzwazua bwa mu kitungu, pantu pa buzwazua i paakumiiziwe Yakobo ni kuvyulua kitungu. ");
INSERT INTO tap_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo lu-aamumwene Esau walimukwiza pamo ni bantu 400, waalekenkaniizie baana bakue: Lea ni baana bakue, Rakeli ni baana bakue, ni babombi babili banakazi ni baana babo. ");
INSERT INTO tap_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Waatangiziizie babombi bakue babili pamo ni baana babo, Lea ni baana bakue i baakonkelepo, Rakeli i waali wasyaliile pamo ni Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakobo waabatangiliile koku walimukuya wafwinamina pansi mpaka nghendo kilooba ni kuya kufika mu kyeni kyakua mukuluube. ");
INSERT INTO tap_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Inzi Esau waile kumusensekela wali lubilo. Lu-aafikile, waamukumbatiile mu mukosi ni kumufyompa, ni bonse babili batendeka kulila. ");
INSERT INTO tap_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau akente evi, wamona banakazi baimeene pamo ni baana babo. Esau waipuzia kale, “Eba, ale baba bauli nabo ni bani?” Yakobo waalandile evi, “Baba i baana baapeelue mubombi obe na nkumbu yakua Leza.” ");
INSERT INTO tap_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Babombi banakazi bakua Yakobo pamo ni baana babo baamupalamiine Esau ni kumufwinamina. ");
INSERT INTO tap_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea ni baana bakue ni bo baile kumufwinamina. Pa mpeleezio, Yusufu ni Rakeli ni bo baile kumufwinamina. ");
INSERT INTO tap_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau waamwipuziizie Yakobo, “Ewe, ale belia bisepe binasaakaananga nabio kolia ni byaki?” Yakobo waamwasukile evi, “Nakituma bebi bisepe pakuti n'mpokelelue na mukuluamwine.” ");
INSERT INTO tap_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau wa-asukile evi, “Sunga sie bebi bisepe byobe, ni nene wenka nkwete sie bingi.” ");
INSERT INTO tap_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo waalandile evi, “Napaapaata upokelele pakuti kiye kyali kisininkizio kya kulangisia nangue wan'mpokelela. Kumona kunakumona, ni kukonkana ni viwan'mpokelela, na-aluka nga ne wamona lukebu lwakua Leza. ");
INSERT INTO tap_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nakupaapaata upokelele bobu bupe bwane buwaleetelua pantu Leza wakin'mpaala ni kun'mpeela kubalua kantu.” Yakobo waakilile kumupaapaata Esau mpaka wafikiila kupokelela. ");
INSERT INTO tap_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau waalandile evi, “Ale iza twende, ni ne ndikuya nakutangiliile.” ");
INSERT INTO tap_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakobo waalandile evi, “We mukuluamwine, umwene baana vibanakile, kabili nene wenka i alimukusunga mikooko ni mbuzi ilimukonsia twana. Ezi nama yane kine yaenda kukila busiku bumo yonse ilikufua. ");
INSERT INTO tap_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ni pakako, wewe tangila sie, ne ozo alimukwiza buke buke kukonkana ni nghendelo ya baana ni bisepe byane. Twakaba kwiza kumonana koko kwenka ku Seiri.” ");
INSERT INTO tap_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau waalandile evi, “Kansi nkusiile baba bantu bandi nabo wize pamo nabo.” Yakobo waalandile evi, “Ata, ale viwangeleela kale! Wewe endo waya sie.” ");
INSERT INTO tap_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kupwako, Esau wamusia ni kubwelela ku Seiri. ");
INSERT INTO tap_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakobo ni ye waile ku Sukoti ku-aakuulile nghanda yakue ni bipata bya nghombe. Ni pakako, pa ezio nkendo i kipalipakuutilua Sukoti. ");
INSERT INTO tap_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobo lu-aabwelele kufuma ku Padani-Aramu, waabwelele sie bwino mpaka kuya kufika ku Sekemu mu kyalo kya Kanaani ni kwimika liema lyakue ntanzi ya muzi. ");
INSERT INTO tap_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ezi nkendo i aimikilepo liema, waasitile ku luvyalo lwakua Hamori se kwa Sekemu na shekeli 100 ya mutofue. ");
INSERT INTO tap_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Waakuulilepo kitale ni kwi-inika Eli-Elohe-Izraeli. ");
INSERT INTO tap_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, se waali Yakobo, ni nghina waali Lea. Waile kupita wapempula bakazyana nakue ba mu kekio kyalo. ");
INSERT INTO tap_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekemu mwana mwalalume mwina Hamori Muhivi, mukulu wa kyalo, lu-aamumwene Dina walimukupita, waamukwete ni kumupatikizia kukumana nakue. ");
INSERT INTO tap_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekemu waawamiinue sana na ozo mukazyana Dina mwina Yakobo. Sekemu waabambile kumubembia ozo mukazyana na twebo tuweme. ");
INSERT INTO tap_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekemu waamwanine se Hamori amutwamine ozo mukazyana kuti abe mukazi wakue. ");
INSERT INTO tap_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo lu-aunvwile nangue mwana wakue Dina wakipatikiziiwa na Sekemu kuti alaale nakue, taalandile kantu pantu baana bakue balalume baali baile ku kusunga nama mu kisonso. Waapembeele mpaka musita ubaabwelele. ");
INSERT INTO tap_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori se kwa Sekemu waile kuli Yakobo kuti alanzyanie nakue. ");
INSERT INTO tap_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Baana bena Yakobo lubaunvwile byaakitikile, baabwelele ku muzi, baafiitilue sana pantu Sekemu waakitile bintu bya bulubi mu Izraeli. Bintu bisipalile kukitika. ");
INSERT INTO tap_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamori waamwanine Yakobo ni baana bakue, “Mwana wane Sekemu wamutona sana Dina. Kansi namipaapaata mumupeele nsambu ya kuti abe mukazi wakue. ");
INSERT INTO tap_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tunvwane sie kuti tuye twaufyania. Tupeele baana benu banakazi, ni fwe tumipeele baana betu banakazi. ");
INSERT INTO tap_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kuti mwaikala pamo ni fwefue mu keno kyalo. Kuti mwaikala konse kumwatona kwikala, ni kusuluzia kyonse kimwatona kusuluzia ni kwikwatila kazonga kenu.” ");
INSERT INTO tap_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekemu waamwanine se kwa Dina ni bakuluube, “Namipaapaata kuti mungitabile, ni nene ndikumikitila kyonse kimulikutona kuti n'mikitile. ");
INSERT INTO tap_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Anzia munundila mutengo ni bupe, ndikumipeela byonse bimulikun'mpingula, inzi mun'mpeele nsambu ya kuupa ozu mukazyana Dina kuti abe mukazi wane.” ");
INSERT INTO tap_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Inzi pantu Sekemu waamupatikiizie Dina kukumana nakue, baana bena Yakobo baamwasukile Sekemu pamo ni Hamori mu bukengezi. ");
INSERT INTO tap_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Baalandile evi, “Fwefue tetuvinda kuufia nkazyetu ku bantu basiteetelue yando. Keki ni kya busoni kuli fwefue. ");
INSERT INTO tap_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Inzi kine mwaitabila kuya mwateetua yando nga fwefue, kuti twaitabila kuti muye mwaupila kono kwetu. ");
INSERT INTO tap_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Baana benu kuti baupua na baana betu ni baana betu kuti baupua na baana benu. Kabili kuti twaikala nenu ni kuba mutundu umo. ");
INSERT INTO tap_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Inzi kine mwakaana kuteetua yando, tulikumutwama Dina ni kukuuka tukuuke pa eno nkendo.” ");
INSERT INTO tap_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamori ni mwana wakue Sekemu baawamiinue na kako kaalandilue. ");
INSERT INTO tap_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ni pakako, mulumendo taakokwele kuteetua yando pantu waali wamutoneesie Dina. Sekemu waali wakindikilue sana mu lupua lwakue. ");
INSERT INTO tap_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamori ni mwana wakue baile pa mulyango wa muzi ni kulanzyania ni bantu ba mu muzi wabo nangue, ");
INSERT INTO tap_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Emwe, baba bantu ni bantu ba mutende. Kansi baleke bekale pamo ni fwefue mu keno kyalo ni kusuluzia. Keno kyalo ni kikata kuti baikala. Baana betu kuti baupua na baana babo, ni baana babo kuti baupua na baana betu. ");
INSERT INTO tap_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Inzi tupalile sie kukita kintu kimo pakuti tuye twapwene nabo ni kuya twali mutundu umo. Balalume bonse mu lono lupua lwetu bapalile kuya bateetua yando. ");
INSERT INTO tap_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Fwe bonse kine twaitabizyania, twaakeekala nabo, ni bunonsi bwabo bonse pamo ni bisepe byabo byonse bya nama ni inge nama, byonse byaakaba byetu.” ");
INSERT INTO tap_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bekazi bonse ba mu ozo muzi baitabiziizie bintu byaalandile Hamori ni mwana wakue Sekemu. Balalume bonse baateetelue yando. ");
INSERT INTO tap_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Lupaapitile nsiku itatu bantu bakilimukukisua na bilonda bya yando i baateetelue, Simeoni ni Lawi bandumeze ba munda mumo ni Dina baatweme bipanga, baya kusakukila muzi mu kafiso ni kwipaya balalume bonse. ");
INSERT INTO tap_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamori ni mwana wakue Sekemu ni bo kumo baipailue. Baamufumiizie Dina ku nghanda yakua Sekemu ni kuya nakue. ");
INSERT INTO tap_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Pa kyamba kya kwipaiwa kwa babo bantu, baana bena Yakobo baatweme bintu bya babo baipailue, pantu Sekemu waamupatikiizie Dina kukumana nakue. ");
INSERT INTO tap_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bintu bibaabatwamiine ni bebi: Mikooko, ni mbuzi, ni punda, pamo ni binge byaali byali mu muzi ni mu makaba. ");
INSERT INTO tap_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Kubalua nghanda baatwememo bunonsi bwabo bonse, ni baana babo bonse, ni bakazi babo bonse pamo ni bintu byonse bibaali nabio. ");
INSERT INTO tap_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakobo waamwanine Simeoni ni Lawi, “Mwe baana bane, mone vimwakita! Evi mwanghingizia mu bwavia bukata ku bantu ba mu Kanaani ni ku bantu ba mu Perisi bekeele batuzyungulukiile. Evi bantu bonse bakaba kunsuula. Nene nsili na bantu bengi. Kine bakabe kukolonghana ni kwiza kunsakukila, bakaba kungipaya pamo ni bantu bane bonse.” ");
INSERT INTO tap_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Inzi baana baalandile evi, “Fwefue tetuvinda kulekelela nkazyetu kwalulua nga mukambue.” ");
INSERT INTO tap_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Leza waamwanine Yakobo nangue, “Ale bwela uye wikale ku Beteli kunaakumonekeele lolia luwaamubutukile mukuluubo Esau. Koko i kwa kuti ukabe kuya kukuula nghanda yobe pamo ni kunkuulila kitale.” ");
INSERT INTO tap_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakobo wa-anine lupua lwakue pamo ni bantu ba-aali nakue nangue, “Ale fumie baleza baeni pakati kenu, musambe ni kuvwala ngubo inge. ");
INSERT INTO tap_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mane tuye twaya ku Beteli, koko kunakaba kuya kumukuulila Leza kitale. Wene i Leza wanghunvwile mu maavia ane, ni waali pamo nane konse kunaali naya.” ");
INSERT INTO tap_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Baamupeele Yakobo baleza baeni bonse babaali nabo pamo ni ntimbi yabo. Yakobo waabuulile bebio byonse ni kubifiika mwinsina kimuti kya ku Sekemu. ");
INSERT INTO tap_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo ni bantu bakue lubaali basyaya, bantu ba mu mizi yaali yabazyungulukiile baunvwile mwezo ukata. Kabili tekuli muntu waeziizie kukonka baana bena Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Evi, Yakobo waafikile ku Luzi (i Beteli) mu kyalo kya Kanaani, wene pamo ni bantu bonse baali bali pamo nakue. ");
INSERT INTO tap_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Pa ezio nkendo waakuulilepo kitale kyaali kyakuutua, “Eli-Beteli.” Papo Leza i pa-aamumwenekeele lu-aali wabutukile mukuluube Esau. ");
INSERT INTO tap_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ni Debora kalela wakua Rebeka waafwile ni kuziikua lya ku nkungulua ya Beteli, mwinsina kimuti kya Muterebinti. Kekio kimuti kyaakuutilue, “Aloni-Bakuti.” ");
INSERT INTO tap_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kabili Leza waamumonekeele Yakobo lu-aafumine ku Padani-Aramu ni kumupaala. ");
INSERT INTO tap_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Leza waamwanine evi, “Liina lyobe uli Yakobo. Teukiya wakuutua Yakobo, inzi waya wasyakuutua Izraeli.” Kupwako wamwinika Izraeli. ");
INSERT INTO tap_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Leza waamwanine evi, “Nene ndi Leza wa Maka onse. Sanduluka ni kuvula. Ntundu ni libumba lya ntundu ingi yaakafuma muli wewe, ni makolo aakafuma mu kitungu kyobe. ");
INSERT INTO tap_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kyalo kinaamupeele Abrahamu ni Izaaki, naakakupeela wewe pamo ni nvyalo yobe.” ");
INSERT INTO tap_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kupwako, Leza wafumapo ni kumusia Yakobo penka papo pa-aalandile nakue. ");
INSERT INTO tap_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ni Yakobo waimikile lipumpu lya libue pa kifuka ki-aalanziiziwepo na Leza, ni kwitililapo ngelelo ya bya kumina, ni mafuta. ");
INSERT INTO tap_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo pa kelia kifuka ki-aalanziiziwepo na Leza, waapeenikile, Beteli. ");
INSERT INTO tap_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Baafumine ku Beteli. Lubaali basyafika ku Efura, misa ya luvyalo yaamukwete Rakeli. Waakisilue sana na misa ya luvyalo. ");
INSERT INTO tap_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ozo musita misa ya luvyalo luyaakilile, kinghombe waamwanine evi, “Tekutiina! Ulikuvyala ni unge mwana.” ");
INSERT INTO tap_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rakeli lu-aali wasyafua, (pantu waafwile), waasiile wainika mwana nangue ni Benoni. Inzi se waasyele kumwinika Benyamina. ");
INSERT INTO tap_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rakeli lu-aafwile waaziikilue mu nzila ya kuya ku Efura. Linge liina lya ozo muzi ni Betlehemu. ");
INSERT INTO tap_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo waimikile lipumpu lya libue lya kulangulukilako pa kilibu. Leli lipumpu lya libue ni lenu kumo lililyakuutua nangue kilibu kyakua Rakeli. ");
INSERT INTO tap_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Izraeli waile kwimika liema lyakue ku bunge bwala bwa lupungu lwa Ederi. ");
INSERT INTO tap_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Izraeli lu-aali wakiikeele mu kekio kyalo, Rubeni waaleele ni Biliha mukazi mwanike muka Izraeli. Izraeli waunvwile ezio mpunda. Baana bena Yakobo baali lyanondo ni babili. ");
INSERT INTO tap_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Baana bena Lea meena abo ni aza: Rubeni (libeli wakua Yakobo), ni Simeoni, ni Lawi, ni Yuda, ni Isakari pamo ni Zabuloni. ");
INSERT INTO tap_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Baana bena Rakeli meena abo ni aza: Yusufu ni Benyamina. ");
INSERT INTO tap_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Baana bena Biliha mubombi wakua Rakeli meena abo ni aza: Dani ni Nafutali. ");
INSERT INTO tap_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Baana bena Silipa mubombi wakua Lea meena abo ni aza: Gadi ni Aseri. Babo i baana bena Yakobo baavyaliilue ku Padani-Aramu. ");
INSERT INTO tap_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo waile kuli se Izaaki ku Mamure pepi ni Kiriati-Arba, i Hebroni, koko kwaali kwaikeele Abrahamu ni Izaaki. ");
INSERT INTO tap_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Izaaki waikeele pa kyalo myaka 180. ");
INSERT INTO tap_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Izaaki waafwile ni kuya kwikala pamo ni bantu bakue wasyali mukote wa myaka ingi. Waaziikilue na baana bakue babili, Esau ni Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ezi i mpendua ya bantu ba mu lupua lwakua Esau. (Esau i Edomu). ");
INSERT INTO tap_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau waupile banakazi ba mu Kanaani: Ada mwana mwanakazi mwina Eloni Muhiti i waali mukazi wa mambo. Mukazi wa bubili waali wakuutua Oholibama mwana mwanakazi mwina Ana, mwinzikulu wakua Sibeoni Muhivi. ");
INSERT INTO tap_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Mukazi wa butatu waali wakuutua Basemati mwana mwanakazi mwina Isimaeli, ndumeze kwa Nebayoti. ");
INSERT INTO tap_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada waavyele, Elifasi. Basemati waavyele, Rueli. ");
INSERT INTO tap_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama waavyele Yeusi ni Yalama pamo ni Kora. Babo bonse baana balalume i baana bena Esau baavyaliilue mu kyalo kya Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau waatweme bakazi bakue pamo ni baana bakue balalume ni banakazi, pamo ni bantu bonse ba mu nghanda yakue, kabili waatweme biteekua byakue byonse ni bunonsi bonse bu-aanonkele mu kyalo kya Kanaani. Waamusiile mwalawakue Yakobo ni kuya kwikala ku kyalo kinge. ");
INSERT INTO tap_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ba-aandilue kwikala pamo pantu bunonsi bwabo bwaali bwavulile, kabili mu kyalo kibailemo, temwaali nkendo pantu nama yabo yaali yavulile. ");
INSERT INTO tap_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau, i Edomu, waile kwikala ku kyalo kya mpili kya Seiri. ");
INSERT INTO tap_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ezi i nvyalo yakua Esau kikolue wa Baedomu ba mu kyalo kya mpili kya Seiri. ");
INSERT INTO tap_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Aza i meena a baana balalume bena Esau: Elifasi mwana mwalalume mwina Ada muka Esau. Rueli mwana mwalalume mwina Basemati muka Esau. ");
INSERT INTO tap_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Baana balalume bena Elifasi ni baba: Temani, ni Omari, ni Zefo, ni Gatamu pamo ni Kenasi. ");
INSERT INTO tap_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timuna waali mukazi mwanike muka Elifasi mwana mwalalume mwina Esau. Timuna waamuvyaliile Elifasi mwana mwalalume liina lyakue Amaleki. Baba bonse i baana balalume bena Ada muka Esau. ");
INSERT INTO tap_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Baana balalume bena Rueli ni baba: Nahati, ni Zera, ni Sama, pamo ni Miza. Baba i baana balalume bena Basemati muka Esau. ");
INSERT INTO tap_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Baana bena Esau baavyelue na Oholibama mwana mwanakazi mwina Ana, mwinzikulu wakua Zibeoni, baali baana batatu balalumenke. Ni meena abo ni aza: Yeusi, ni Yalamu pamo ni Kora. ");
INSERT INTO tap_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Baba i babikolue ba nvyalo yakua Esau. Baana bena Elifasi libeli wakua Esau, meena abo ni aza: Lisiiko Temani, ni Omari, ni Zefo, ni Kenasi, ");
INSERT INTO tap_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ni Kora, ni Gatamu, pamo ni Amaleki. Baba i babikolue baafumine kuli Elifasi mu kyalo kya Edomu. Baba i baana balalume bena Ada. ");
INSERT INTO tap_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Baana balalume bena Rueli mwana mwalalume mwina Esau, meena abo ni aza: Lisiiko Nahati, ni Zera, ni Sama pamo ni Miza, baba i babikolue baafumine kuli Rueli mu kyalo kya Edomu. Baba i baana balalume bena Basemati muka Esau. ");
INSERT INTO tap_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Baana balalume bena Oholibama muka Esau, meena abo ni aza: Lisiiko Yeusi, ni Yalamu pamo ni Kora, baba i babikolue baafumine kuli Oholibama mwana mwanakazi mwina Ana muka Esau. ");
INSERT INTO tap_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Babo bonse i baana balalume bena Esau, kabili i babikolue ba Baedomu. ");
INSERT INTO tap_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Baana balalume bena Seiri Muhori, bene kyalo, meena abo ni aza: Lotani, ni Sobali, ni Sibeoni, ni Ana, ");
INSERT INTO tap_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ni Disoni, ni Ezeri pamo ni Disani. Babo bantu i babikolue baafumine ku Bahori, baana balalume bena Seiri mu kyalo kya Edomu. ");
INSERT INTO tap_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Baana balalume bena Lotani, meena abo ni aza: Hori ni Hemamu. Lotani waali ni nkaziize liina lyakue Timuna. ");
INSERT INTO tap_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Baana balalume bena Sobali, meena abo ni aza: Alwani, ni Manahati, ni Ebali, ni Sefo pamo ni Onamu. ");
INSERT INTO tap_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Baana balalume bena Sibeoni, meena abo ni aza: Aya ni Ana. Ozu Ana i olia waasangile nsulo ya menda a mwenzi mu kaseeba lu-aali wasunga punda yakua se Sibeoni. ");
INSERT INTO tap_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Meena a baana bena Ana ni aza: Disoni ni Oholibama waali mwana mwanakazi mwina Ana. ");
INSERT INTO tap_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Baana balalume bena Disoni, meena abo ni aza: Hemudani, ni Esibani, ni Itirani pamo ni Kerani. ");
INSERT INTO tap_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Baana balalume bena Ezeri, meena abo ni aza: Bilihani, ni Zawani pamo ni Akana. ");
INSERT INTO tap_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Baana balalume bena Disani, meena abo ni aza: Uzi ni Arani. ");
INSERT INTO tap_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Babikolue baafumine mu Bahori, meena abo ni aza: Lotani, ni Sobali, ni Sibeoni, ni Ana, ");
INSERT INTO tap_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ni Disoni, ni Ezeri, pamo ni Disani. Baba i babikolue ba Bahori, kukonkana ni mikowa yabo mu kyalo kya Seiri. ");
INSERT INTO tap_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Baba i bamakolo baateekele mu kyalo kya Edomu lukwaali tekunabe likolo ku Baizraeli. ");
INSERT INTO tap_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana mwalalume mwina Beori waateekele mu Edomu. Liina lya muzi wakue lyaali lyakuutua Dinihaba. ");
INSERT INTO tap_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela lu-aafwile, Yobabu mwana mwalalume mwina Zera wa ku Bosera waateekele pa kifuka kyakue. ");
INSERT INTO tap_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu lu-aafwile, Husamu wa ku kyalo kya Batemani waateekele pa kifuka kyakue. ");
INSERT INTO tap_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamu lu-aafwile, Hadadi mwana mwalalume mwina Bedadi, waumine Bamidiani mu bukaba bwakua Moabu, waateekele pa kifuka kyakue. Ozo muzi waali wakuutua Awiti. ");
INSERT INTO tap_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi lu-aafwile, Samula wa ku Masireka, waateekele pa kifuka kyakue. ");
INSERT INTO tap_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula lu-aafwile, Sauli wa ku Rehoboti ili mumbali mwenzi, waateekele pa kifuka kyakue. ");
INSERT INTO tap_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sauli lu-aafwile, Bali-Hanani mwana mwalalume mwina Akibori, waateekele pa kifuka kyakue. ");
INSERT INTO tap_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bali-Hanani mwana mwalalume mwina Akibori lu-aafwile, Hadari waateekele pa kifuka kyakue. Liina lya muzi wakue lyaali lyakuutua Pau, ni liina lya mukazi wakue lyaali lyakuutua Mehetabeli mwana mwanakazi mwina Matiredi, ni Matiredi ni ye waali mwana mwanakazi mwina Me-Zahaba. ");
INSERT INTO tap_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Babikolue baafumine kuli Esau mu lupua lwabo ni mu nkendo yabo, meena abo ni aza: Timuna, ni Alwa, ni Yeteti, ");
INSERT INTO tap_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ni Oholibama, ni Ela, ni Pinoni, ");
INSERT INTO tap_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ni Kenasi, ni Temani, ni Mibusari, ");
INSERT INTO tap_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ni Magdieli pamo ni Irama. Baba i baali babikolue ba Baedomu baali baikeele mu kyalo kibaapeelue. Esau i kikolue wa Baedomu. ");
INSERT INTO tap_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo waatwaliliile kwikala mu kyalo kya Kanaani, momo mwaali mwaikeele se nga mweni. ");
INSERT INTO tap_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Lyasi lyakua Yakobo ni leli. Yusufu lu-aali wakili na myaka lyanondo ni kilooba, waali wasunga mikooko ni mbuzi, kabili waali wali pamo ni bakuluube bena Biliha ni Silipa, bakazi bakua Yakobo. Yusufu waile kumubwila se bintu bibiipile byaali byakita bakuluube. ");
INSERT INTO tap_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Inzi Izraeli waali wamutoneesie Yusufu kukila bange baana bonse pantu waali mwana wa mu bukote, kabili waamukitiile nkanzu ya mikumino ilekenkeene. ");
INSERT INTO tap_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bakuluube lubaamwene nangue Yusufu waali watonenue kukila bange bonse, baamusuulile sana mpaka balekela ni kulanda nakue bwino bwino. ");
INSERT INTO tap_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Busiku bumo Yusufu waalootele kilooto kimo. Lu-aile kubwilako bakuluube kilooto kyakue, baakilile kumusuula. ");
INSERT INTO tap_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusufu waalandile evi, “Emwe, unvue kilooto kinalootanga. ");
INSERT INTO tap_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Twile twalimukukaka bisi bya nghano mu bukaba, kisi kyane kyabuukanga ni kwimana misiki, inzi bisi byenu byaimananga byazyungulukiile kisi kyane ni kukikontamina.” ");
INSERT INTO tap_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bakuluube baamwipuziizie evi, “Eba, umwene nangue wewe i wakaba kututeeka ao kuya wali ni buvinde pali fwefue?” Kabili baakilile sie kumusuula pa mulandu wa bilooto byakue ni pa mulandu wa bintu bi-aali walanda. ");
INSERT INTO tap_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kabili Yusufu waalootele ni kinge kilooto ni kubabwila bakuluube nangue, “Emwe, kabili nalootanga ni kinge kilooto. Namonanga koba ni kwezi pamo ni ntanda lyanondo ni lumo byankontamina.” ");
INSERT INTO tap_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Inzi lu-aabwilileko se pamo ni bakuluube, se waamusasiliile wamwana nangue, “Eba, i kilooto kya musangoki keki kiwalootanga? Ulangakeene nangue noko ni nene pamo ni bakuluubo bonse twaakeeza kukukontamina?” ");
INSERT INTO tap_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Bakuluube kwa Yusufu baamunvwiliile sana bunkua, inzi se waatwaliliile sie kuya walangakana palua bebio bilooto. ");
INSERT INTO tap_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Busiku bumo bakuluube baile ku Sekemu ku kusunga mikooko yakua sibo. ");
INSERT INTO tap_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izraeli waamwanine Yusufu, “Unvua, bakuluubo balimukusunga mikooko ku Sekemu.” Ale iza nkutume uye wayako. Yusufu waalandile evi, “We tawe, kili sie bwino, kuti naya.” ");
INSERT INTO tap_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Se waamwanine evi, “Ale endo waya umone kine bakuluubo bakosele, uye umone ni mikooko kine ili bwino, mane uye wize un'mbwile.” Evi i vyaatuminue Yusufu na se kufuma mu lulambe lwa Hebroni kuya ku Sekemu. ");
INSERT INTO tap_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Muntu umo waamusangile walimukwenda mu kisonso. Ozo muntu waamwipuziizie Yusufu, “Ewe, ulimukukebaki?” ");
INSERT INTO tap_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu wa-asukile evi, “Ndimukukeba bakuluamwine. Kuti wanangilila kubalimukusungila mikooko yabo?” ");
INSERT INTO tap_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ozo muntu waamwanine evi, “Pano baafumangapo kale, pantu naunvwanga balimukulanda nangue, ‘Twende ku Dotana.’” Kupwako, Yusufu wabakonka ni kuya kubasanga ku Dotana. ");
INSERT INTO tap_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bakuluube baamumwene walimukwiza lwa kule. Lu-aali tanafike papo pa baali, baunvwene kuti bamwipaye. ");
INSERT INTO tap_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Baalandile evi, “Mone kaloota wa bilooto olia alimukwiza! ");
INSERT INTO tap_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ale tumwipaye ni kumupooza mu kiina kimo kya pa biina. Twaya tulande sie nangue bamwipayanga na kinama, evi tumone kine bilooto byakue byaakakitaki.” ");
INSERT INTO tap_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubeni lu-aunvwile balanda evio, waamupokolwele walanda nangue, “Emwe, tekuti tumwipaye, ");
INSERT INTO tap_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","tekumukisie, inzi mupooze sie mu keki kiina kili mono mu kaseeba pasili kumukita kantu.” Mapange akua Rubeni aali a kuti aye eze amutwame ni kumutwala kuli se. ");
INSERT INTO tap_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusufu lu-aafikile papo paali bakuluube, baamuvuulile nkanzu yakue ya mikumino ilekenkeene i-aali wavwele, ");
INSERT INTO tap_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","bamutwama ni kuya kumupooza mu kiina kyaali kyakaminemo menda. ");
INSERT INTO tap_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Lubaikeele kuti balie, baamwene libumba lya Baisimaeli basulu pamo ni nghamia yabo, baali batweme manukato ni zeri ni manemane balimukukookela ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda waabaanine bakuluube, “Emwe, unvue! Kine twamwipaya mwalawetu ni kuzuumia mulopa wakue tulikunonkapoki? ");
INSERT INTO tap_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nene namona sie kuti tumusisie ku Baisimaeli pasili kumukisia pantu ni mwalawetu, kabili tuli sie nakue mubili umo ni mulopa umo.” Ba kwakue baamwitabiizie. ");
INSERT INTO tap_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Basulu ba Bamidiani lubaali balimukupita lya papo, bakuluube baamufumiizie mu kiina ni kumusisia ku Baisimaeli na nfolanga 20. Babo bantu baamutweme ni kuya nakue ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni lu-aabwelele ni kusanga Yusufu tekuba wali mu kiina, waunvwile bulanda bukata ni kuzabula ngubo yakue. ");
INSERT INTO tap_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Waile kwaali kwali balabakue ni kubaana nangue, “Emwe, Yusufu mu kiina talimo! Ndikukita syani?” ");
INSERT INTO tap_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Baabuulile nkanzu ni kutubia mu mulopa wa kapwata kabaipaile. ");
INSERT INTO tap_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Baatweme nkanzu ya mikumino ilekenkeene ni kuya kumutwalila sibo balanda nangue, “We tawe, twatoolanga ezi ngubo! Monanke kine ni yakua mwana obe ao abe.” ");
INSERT INTO tap_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Se wainikile ni kulanda nangue, “Ezi ni ngubo yakua mwana wane, waliiwanga na kinama. Kisinka Yusufu waazanghununwanga bipusa bipusa!” ");
INSERT INTO tap_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakobo waazabwile ngubo yakue ni kuvwala lisaaka mu kitungu. Waamulilile mwana wakue nsiku ingi. ");
INSERT INTO tap_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Baana bakue bonse, balalume pamo ni banakazi, baile kumutalazia, inzi wene waakeene kutalaziwa. Waalandile evi, “Nakaana. Nene nakaba kufua nalimukulila ni kuziikua pepi ni mwana wane.” Ni pakako, waatwaliliile sie kumulila mwana wakue Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Balia Bamidiani baile kumusisia Yusufu ku Misri kuli Potifari kiloolo wakua Farao, kabili i waali kiloolo wa bakalinda. ");
INSERT INTO tap_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Pa ozo musita Yuda waasiile bakuluube ni kuya kwikala na muntu umo wa ku Adulamu liina lyakue Hira. ");
INSERT INTO tap_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda waamweneko mukazyana mwina Mukanaani umo liina lyakue Sua, waamuupile ni kukumana nakue. ");
INSERT INTO tap_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ozo mwanakazi waimitile ni kuvyala mwana mwalalume ni kumwinika Eri. ");
INSERT INTO tap_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kabili waimitile, wavyala unge mwana mwalalume ni kumwinika Onanu. ");
INSERT INTO tap_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Lu-aimitile lya butatu, waavyele unge mwana mwalalume ni kumwinika Sela. Ozo mwana lu-aavyelue, Yuda wali ku Kezibu. ");
INSERT INTO tap_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Pa kyamba, Yuda waakebele mwanakazi wa kuupua na mwana wakue libeli liina lyakue Eri. Ozo mukazyana waali wakuutua Tamari. ");
INSERT INTO tap_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Inzi Eri, libeli wakua Yuda, waali wali mubi ku menso akua Yawe. Ni pakako, Yawe waamwipaile. ");
INSERT INTO tap_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yuda waamwanine Onanu, “We mwana wane, pyana ozu mwanakazi muka Eri evi umuvyalile wa kobe baana.” ");
INSERT INTO tap_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Inzi Onanu waamanine nangue baana tebakaba bakue. Ni pakako, lu-aali walaala na ozo mwanakazi, waali waitilila mbezu ya buvyazi pansi watiina kumuvyalila wa kwakue baana. ");
INSERT INTO tap_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yawe taawamiinue na misango yaakitile Onanu. Ni pakako, ni ye waamwipaile. ");
INSERT INTO tap_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda waamwanine Tamari muka mwana wakue nangue, “Ikala mu bumukanfwilua mu nghanda yakua so wapembeele mpaka musita waakakula mwana wane mwalalume Sela.” Ki-aalandiile evio, waali watiina nangue Sela ni ye kuti wafua nga vyaafwile bakuluube. Kupwako, Tamari wabwelela ku nghanda yakua se. ");
INSERT INTO tap_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Lupaapitile myaka ingi, muka Yuda, mwana mwanakazi mwina Sua, waafwile. Malilo lu-aapwile, Yuda ni kibuza wakue Hira wa ku Adulamu, baile ku Timuna kwaali kwatebulua mikooko yakue. ");
INSERT INTO tap_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Muntu umo waile kumubwila Tamari nangue sevyala waya kutebula mikooko yakue ku Timuna. ");
INSERT INTO tap_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamari waavuulile ngubo yakue ya bumukanfwilua, waikupa kitambala ni kwikala pa mulyango wa nghingililo ya muzi wa Enaimu waali mumbali musebo uwile ku Timuna. Waakitile evi pantu waali wamanine nangue Sela mwana mwalalume mwina Yuda waali wasyakulile, kabili pantu tanapeelue Sela kuba mulume wakue. ");
INSERT INTO tap_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda lu-aapitiile paali paikeele Tamari, waalangakeene nangue ozo mwanakazi waali wali mukambue pantu waali waikupile pa menso. ");
INSERT INTO tap_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Waamukonkele mumbali musebo ni kumwana nangue, “Nene natona kuti ndaale nobe.” Taali wamanine nangue i waali muka mwana wakue. Ozo mwanakazi waamwipuziizie evi, “Kine walaala ni nene ulikun'mpeelaki?” ");
INSERT INTO tap_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Waamwasukile, “Nakaba kukupeela musoka wa mbuzi wa pa kisepe kyane.” Mwanakazi waamwanine evi, “Ale kansi n'mpeele kikwatizi kya kuti nsyale nakio mpaka paukantumina ozo mbuzi.” ");
INSERT INTO tap_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mwalalume waipuziizie evi, “Ale ndikukusiila kikwatiziki?” Mwanakazi waalandile evi, “Ulikunsiila kazele ka kumunue ni lwando pamo ni kabango kauliwaendelako.” Kupwako wamupeela. Lu-aaleele nakue, mwanakazi waimitile. ");
INSERT INTO tap_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kupwako, wabuuka waya, waivimbula kitambala kyakue ni kuvwala paakale ngubo ya bumukanfwilua. ");
INSERT INTO tap_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda waamutumine kibuza wakue Muadulamu kuti aye atwale mbuzi kuli ozo mwanakazi ni kupoka bintu bi-aasiileko, inzi taamusangile. ");
INSERT INTO tap_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Waipuziizie bantu bamo ba ku Enaimu, “Emwe, olia mukambue waali waikeele papa mumbali musebo ali pi?” Baamwasukile nangue, “Pano tetunamonepo mukambue.” ");
INSERT INTO tap_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Waabweleele kuli Yuda. Waamwanine evi, “Nsyamusanghanga. Ni bantu ba koko banghananga nangue pano tetunamonepo mukambue.” ");
INSERT INTO tap_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda waalandile evi, “Muleke sie asyale ni bikwatizi. Tetutonene kusekua na bantu. Namutuminanga mbuzi, inzi we tewamusanghanga.” ");
INSERT INTO tap_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Lupaapitile myezi itatu, muntu umo waizile kumubwila Yuda nangue, “Tamari muka mwana obe waakikita bukambue, kabili ali ni liimi lya mu bukambue.” Yuda waalandile evi, “Ozo mwanakazi aziziiwe mu mulilo afue.” ");
INSERT INTO tap_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ozo mwanakazi lu-aali walimukutwalua, waatumine muntu umo kuli sevyala aye amwane nangue, “Nene nghimisiiziwe na mwine wa bebi bintu. Waalandile evi, ‘Nakulomba winike mwine wa kaka kazele ka ku munue ni lwando pamo ni kabango.’” ");
INSERT INTO tap_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda lu-aabiinikile, waalandile evi, “Ozu mwanakazi ali ni nsambu kukila nene, pantu nsyamupeele Sela mwana wane amuupe.” Ni pakako, taaleele nakue kabili. ");
INSERT INTO tap_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Musita wakuvyala luwakumeene, kyaamwenekele nangue alikuvyala bampundu. ");
INSERT INTO tap_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Misa luyaamukwete, mwana umo waafumiizie kuboko. Kinghombe waakakile nyunzi ya kasi ku kuboko. Waalandile evi, “Ozu i wa mambo.” ");
INSERT INTO tap_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Inzi lu-aabweziizie kuboko, mwinakue waavyelue. Kinghombe waalandile evi, “Wewe i waizula nzila.” Ni pakako, ozo mwana wainikilue Perezi. ");
INSERT INTO tap_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mwinakue waakakilue nyunzi ya kasi ku kuboko lu-aavyelue, wainikilue Zera. ");
INSERT INTO tap_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yusufu waatwelue ku Misri. Potifari wa ku Misri, kiloolo wakua likolo, mukulu wa bakalinda, i waamusitile Yusufu ku Baisimaeli baamutwele koko. ");
INSERT INTO tap_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe waali pamo ni Yusufu ni kumupaala mu byonse bi-aali wakita mu nghanda yakua selenzi Mumisri. ");
INSERT INTO tap_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifari wainikile nangue Yawe waali wali pamo ni Yusufu, kabili nangue waali wapaalilue mu byonse bi-aali wakita. ");
INSERT INTO tap_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifari waawamiinue sana mpaka wamupeela Yusufu mwilo wa kulabukila nghanda yakue pamo ni bintu byonse bi-aali nabio. ");
INSERT INTO tap_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kutula musita u-aabiikilue kuba ndabukizi wa mu nghanda yakua Potifari ni wa bintu byonse bi-aali nabio, Yawe waapaalile nghanda yakua Potifari pa mulandu wakua Yusufu, ni kupaala bintu byonse bi-aali nabio mu nghanda ni mu makaba. ");
INSERT INTO tap_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Waasiile bintu byonse mu maboko akua Yusufu, kabili taapoozeleko maano ku bintu byakue, inga sie ku bilio bi-aali walia Ni Yusufu waali ni mibeele iweme, ni lukebu lwaweme. ");
INSERT INTO tap_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Pa kyamba kya bebi byonse, muka Potifari waamutokeemue Yusufu ni kumwana alaale nakue. ");
INSERT INTO tap_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Inzi wene waakeene wamwana muka Potifari nangue, “Potifari tamanine bintu bindi nabio mono mu nghanda, wene an'mpeele nsambu ya kusunga byonse. ");
INSERT INTO tap_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mu eno nghanda temuli unge ankilile pa nsambu in'mpeelue, kabili n'mpeelue nsambu pa bintu byonse kufumiako sie wewe pantu uli mukazi wakue. Ale ndikukitilaki kintu kibiipile evi ni kumuluvia Leza?” ");
INSERT INTO tap_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Anzia kine waali wamukebakeba sie kubalua busiku, wene taamwitabiizie kuti alaale nakue ao kuba pamo nakue. ");
INSERT INTO tap_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Busiku bumo Yusufu lu-aingiile mu nghanda mu kubomba miilo yakue, ozo musita mu nghanda temwaali ata mubombi unge. ");
INSERT INTO tap_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Muka Potifari waamukwete ku ngubo wamwana nangue, “Iza ulaala ni nene!” Yusufu waifompwele, wabutukila panze ni kumusia wakwete ngubo yakue. ");
INSERT INTO tap_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Muka Potifari lu-aamwene nangue Yusufu wabutukila panze, ni ye wasyala sie wakwete ngubo yakua Yusufu mu minue, ");
INSERT INTO tap_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","waapundile wakuuta bantu ba mu nghanda yakue wabaana nangue, “Mone, waaleetele Muebrania kono kwetu kuti atuleebule! Wakiba waumiine kulaala ni nene, inzi nene nasamunanga na maka, ");
INSERT INTO tap_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ni ye lu-aunvwanga nasamuna, wabutukilanga panze ni kunsiila ngubo yakue.” ");
INSERT INTO tap_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Muka Potifari waasungile ngubo yakua Yusufu mpaka lwaizile mulume wakue. ");
INSERT INTO tap_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Waamwanine mulume wakue lyasi lyonse nangue, “Ozu Muebrania muzia uwaatuleeteele, wakinghingilila wakebele kulaala ni nene. ");
INSERT INTO tap_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Inzi lunakisamuna, wakibutukila panze ni kunsiila ngubo yakue.” ");
INSERT INTO tap_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mulume wakue Potifari lu-aunvwile bi-aabwililue na mukazi wakue nangue i vyakikita mubombi wakue, waafiitilue sana. ");
INSERT INTO tap_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifari waamutweme ni kumukaka mu buloko mwaali mwakakilue bakakua bakua likolo. ");
INSERT INTO tap_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Inzi Yawe waali wali pamo ni Yusufu ni kumulangisia ntono yakue ikata, evi mukulu wa buloko aye wawamiinue na Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kalinda wa buloko waamupeele Yusufu bukulu pa bakakua bonse, ni byonse bibaali bakita papo, wene i waali watantika. ");
INSERT INTO tap_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kalinda wa buloko taapoozeleko maano ku bintu byaali byatantika Yusufu pantu Yawe waali wali pamo nakue. Ni byonse bi-aali wakita, Yawe waali wabipaalile. ");
INSERT INTO tap_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bebi byonse lubyaapitile, muntu waali wapeelue nsambu ya kupeela likolo divai, ni olia kaapika wa mikate baamuluviizie Farao, likolo wa ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao waabafiitiilue babo babiloolo babili, mukulu wa balia bapeelue nsambu ya kupeela likolo divai, ni mukulu wa bakaapika ba mikate. ");
INSERT INTO tap_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Waabatumine kuya kusungua mu buloko mu nghanda ya mukulu wa bakalinda, momo mwaali mwakakilue Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mukulu wa buloko waamwanine Yusufu kuti aye wali mubombi wa babo babiloolo babili. Waabasuungile, ni bo baikeelemo musita uniini. ");
INSERT INTO tap_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Busiku bumo busiku, babo bakakua babili, mukulu wa bakateania ba divai ni mukulu wa bakaapika ba mikate baali babombela likolo wa ku Misri, kubalua muntu waalootele kilooto kyaali ni ndubulwilo iibeeleele. ");
INSERT INTO tap_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu lu-aile kubamona lukeelekeele, waabamwene baali ni bulanda. ");
INSERT INTO tap_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Waipuziizie balia babiloolo babili bakua Farao baali bakakilue pamo nakue mu nghanda yakua Potifari nangue, “Ale lelo mumwenekeeleki mwali ni bulanda?” ");
INSERT INTO tap_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Baamwasukile nangue, “Fwefue twalootanga kubalua muntu kilooto kyakue, ni evi tetuli na muntu wa kutulondolwela.” Yusufu waabaanine evi, “Eba, Leza te i ali ni buvinde bwa kulondolola bilooto? Ale n'mbwile vimwalootanga.” ");
INSERT INTO tap_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mukulu wa bakateania ba divai waamwanine Yusufu kilooto kyakue, “Nene nalootanga muzabibu waimeene ku ntanzi yane. ");
INSERT INTO tap_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ku ozo muzabibu kwakiba misambo itatu. Penka papo maani atomba kale, buluba ni bo bwatoota, ni bisansa bya mizabibu ni byo byapia. ");
INSERT INTO tap_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Namonanga nakwete kikombe kyakua Farao, nabuula mizabibu, nafininamo ni kuya kumupeela Farao.” ");
INSERT INTO tap_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu waalandile evi, “Elia misambo itatu, i nsiku itatu. ");
INSERT INTO tap_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nsiku itatu paikaba kupua, Farao wakaba kukufumia mu buloko, ni kukubweziizia mwilo obe u waali wabomba. Wewe wakaba kumupeela Farao kikombe kya divai mu minue nga viwaali wamupeela pa mambo luwaali wali kateania wa divai. ");
INSERT INTO tap_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Inzi ukaananguluke paukapaalua, kabili tekukalaba kunandilako kuli Farao evi ni nene nkakakulue mono mu buloko. ");
INSERT INTO tap_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pantu kisinka lunaali ku kyalo kyetu kya Baebrania, naibilue. Kabili ni mono mwenka mu Misri nkakilue mu buloko tekuba nali na mulandu.” ");
INSERT INTO tap_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mukulu wa bakaapika ba mikate lu-aunvwile ndubulwilo ya kilooto yaweme, waamwanine Yusufu nangue, “Ni nene wenka nalootanga naitwikile bipanda bitatu bya mikate. ");
INSERT INTO tap_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mu kipanda kya pa muulu mwaba mwali bilio byapikilue bya misango ilekekeene byakua Farao, mu kekio kipanda mwakookelanga tooni twaizanga kulia ezio mikate.” ");
INSERT INTO tap_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu waamwanine evi, “Ndubulwilo ya kilooto ni ezi: Bipanda bitatu i nsiku itatu. ");
INSERT INTO tap_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nsiku itatu paikaba kupua, Farao wakaba kuputula mutue ni kukulika mubili obe ku kimuti evi tooni tukabe ku kulia.” ");
INSERT INTO tap_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Busiku bwa butatu bwa nsikunkulu ya kuvyalua kwakua Farao, Farao waabatebetele babombi bakue bonse. Mukulu wa bakateania ba bya kumina ni mukulu wa bakaapika ba mikate baakakwilue ni kuleetua pa ntanzi yakua Farao, ni pa ntanzi ya babombi bakue. ");
INSERT INTO tap_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mukulu wa bakateania ba bya kumina waabweziiziwe pa mwilo wakue, evi atendeke kumutwalila Farao kikombe. ");
INSERT INTO tap_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Inzi mukulu wa bakaapika ba mikate waakulikilue. Byonse byaakitikile nga mwaalandiile Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Inzi mukulu wa bakateania ba bya kumina taamulangulukile Yusufu. Waamulabile. ");
INSERT INTO tap_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ku mpeleezio ya myaka ibili, Farao waalootele waimeene mumbali Mwenzi wa Nile. ");
INSERT INTO tap_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Waamwene nghombe kilooba iweme yainine yalimukufuma mu mwenzi. Luyaafumine, yaatendekele kulia bikusi. ");
INSERT INTO tap_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kabili waamwene inge nghombe kilooba yalimukufuma mu mwenzi. Nghombe yabiipile kabili yaondele. Ezio nghombe yaizile kwimana pepi na inge nghombe mumbali mwenzi. ");
INSERT INTO tap_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nghombe iinine yaweme yaatelekelue na nghombe yondele yabiipile. Mu kumona sie evio, Farao wasantamuka. ");
INSERT INTO tap_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Farao waaleele paakale ni kuloota kinge kilooto. Waamwene misokoti kilooba ya nghano iweme yatanine yali ku kamuti kamo ka nghano. ");
INSERT INTO tap_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kabili waamwene, misokoti kilooba ya nghano yondele yapukilue na mwela wa ku kabanga. ");
INSERT INTO tap_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Misokoti kilooba yaatelekele misokoti ya nghano yaali yatanine. Farao lu-aasantamukile, wainikile nangue waali walimukuloota. ");
INSERT INTO tap_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Lubwaakiile, Farao waatoobokele. Waatumine bantu ba kuya kukuuta nghanga ni bantu ba maano ba mu Misri. Waababwilile kilooto kyakue, inzi tekwaali muntu waamulondolweleele. ");
INSERT INTO tap_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Muntu waali wapeelue nsambu ya kupeela likolo divai waamwanine Farao, “Nene nalanguluka bilubo byane lelo. ");
INSERT INTO tap_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Musita umo Farao waafiitiilue babombi bakue, wankakile mu nghanda ya mukulu wa bakalinda, nene pamo ni mukulu wa bakaapika ba mikate. ");
INSERT INTO tap_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Busiku bumo fwe babili twaalootele kubalua muntu kilooto kili ni bulondolozi bwakue. ");
INSERT INTO tap_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kwaali mulumendo umo Muebrania utwaali twakakilue nakue, mubombi wakua mukulu wa bakalinda. Lutwaamwanine bilooto byetu, kubalua muntu waalondolweleelue ndubulwilo ya kilooto kyakue. ");
INSERT INTO tap_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Byonse bi-aalandile byaatukitikiile. Wewe wan'mbweziizie nene pa mwilo wane, inzi mukulu wa bakaapika ba mikate wewe waamukulikile.” ");
INSERT INTO tap_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Farao waatumine muntu wa kuya kumutwama Yusufu. Penka papo wakakulua kale mu buloko. Lu-aatebwilue misisi ni kuvwala ngubo yakue, waile kwimana ntanzi yakua Farao. ");
INSERT INTO tap_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao waamwanine Yusufu, “Nakiloota bilooto, ni bebi bilooto bantu bakyandua kubilondolola. Inzi nakyunvua nangue wewe kuti wavinda kubilondolola.” ");
INSERT INTO tap_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu waamwasukile Farao, “Nene na maano ane nsivinda, inga sie Leza mwine i alikumulondolwela Farao ndubulwilo ya kiine.” ");
INSERT INTO tap_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Farao waalandile evi, “Nene nakiloota naimeene mumbali mwenzi. ");
INSERT INTO tap_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nakimona nghombe kilooba iweme yainine yalimukufuma mu mwenzi. Luyakifuma, yakitendeka kulia bikusi. ");
INSERT INTO tap_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kabili nakimona inge nghombe kilooba yondele itope yabiipile yalimukufuma mu mwenzi. Mono mu Misri nsinamonemo nghombe yondele nga ezio. ");
INSERT INTO tap_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nghombe yondele yabiipile yaatelekele nghombe kilooba ya mambo yaali yainine. ");
INSERT INTO tap_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Luyaatelekele ezio nghombe, teyaamanikile nangue i yatelekanga nghombe iinine, inzi yaali yamwenekele sie yabiipile nga viyaali pa mambo. Kupwako, nasantamuka. ");
INSERT INTO tap_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kabili nakiloota misokoti kilooba ya nghano yatanine yaweme yaali yasyakosele yatweme ku kamuti kamo ka nghano. ");
INSERT INTO tap_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kabili nakimona misokoti kilooba ya nghano yondele yapukilue na mwela wa ku kabanga. ");
INSERT INTO tap_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Nghano yaali yaondele yaatelekele misokoti kilooba iweme. Nakilootolwela banghanga, inzi tekuli muntu wakinondolwela ndubulwilo.” ");
INSERT INTO tap_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu waamwanine Farao nangue, “Bebi bilooto byobe ni bimonke sie. Leza wakikulangisia vi-aliwakaba kukita pa kyamba kya musita uniini. ");
INSERT INTO tap_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Elia nghombe kilooba iweme, i myaka kilooba, ni elia misokoti kilooba ya nghano iweme, ni yo i myaka kilooba. Bebi bilooto byonse ni bimonke sie. ");
INSERT INTO tap_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Elia nghombe kilooba yondele ni ibiipile yaafumine pa kyamba kya inge, i myaka kilooba, ni elia misokoti kilooba musili kantu, i myaka kilooba ya nzala. ");
INSERT INTO tap_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kaka i keebo kanamwana Farao, Leza wakimulangisia Farao vi-aliwakaba kukita pa kyamba kya nsiku iniini. ");
INSERT INTO tap_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Unvua, myaka kilooba mu Misri mwaakaba bya kulia bingi, ");
INSERT INTO tap_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ni inge myaka kilooba yaakakonkapo, mwaakaba nzala. Ni bantu bonse baakalaba nangue mu kyalo kya Misri mwaali ni bya kulia bingi, pantu ezio nzala yaakeenoona kyalo. ");
INSERT INTO tap_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ni pakako, bwingi bwa bilio tebukalangulukua mu kyalo pantu ezio nzala yaakeeza, yaakaba yakilile kubiipa. ");
INSERT INTO tap_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Keki kilooto kyakua Farao kikibweleele libili, ni pa mulandu wa kusininkizia mapange akaba kukitua na Leza pa kyamba kya nsiku iniini. ");
INSERT INTO tap_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ni pakako, Farao akebe muntu wa maano ni mulangue wakuti abe ndabukizi wa kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kabili asaakwilepo ni bange babiloolo bakuti baye babiika kimo kya pa bisaano bya pa buzombozi bwa mu myaka kilooba ya bilio mu kyalo kya Misri, ");
INSERT INTO tap_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","bakolonghanie buzombozi mu eno myaka iweme ilimukwiza ni kuziba bobo buzombozi mu matala a mu mizi ni kubusunga. ");
INSERT INTO tap_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bebi bilio byaakasungua mu kyalo mu myaka kilooba ya nzala yaakaba mu kyalo kya Misri, evi kyalo tekuti kikeenoonue na nzala.” ");
INSERT INTO tap_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao pamo ni babiloolo bakue bonse baawamiinue sana na bobo bulanzi. ");
INSERT INTO tap_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farao waipuziizie evi, “Ati, kubako ni kiine kuti twasanga unge muntu nga ozu ali ni Mweo wakua Leza?” ");
INSERT INTO tap_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farao waamwanine Yusufu, “Tekuli unge ali ni maano ni mulangue nga wewe, pantu wewe i wakifyulilua na Leza totu twebo tonse. ");
INSERT INTO tap_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ni pakako, wewe wenka i waakaba mukulu pa nghanda yane, ni bulanzi bobe bwaakanakilua na bantu bane bonse. Inzi naakaba mukulu wa kyalo kyonse kukila wewe.” ");
INSERT INTO tap_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao waamwanine Yusufu, “Mona nakubiika kuba mukulu wa kyalo kyonse kya Misri.” ");
INSERT INTO tap_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Farao waavuulile kazele kakue ka kalangi ni kumuvwika Yusufu ku munue, waamuvwika ni ngubo ya kitani kiweme, kabili wabuula ni mukufu wa oro wamuvwika mu mukosi. ");
INSERT INTO tap_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Yusufu waaseziiziwe mu tyakala ya bubili yakua Farao kuya wali nkonkani wakua Farao. Bakalinda bakue baali baya bamutangiliile balimukupunda nangue, “Fukame.” Yusufu wapeelua bukulu bwa kuteeka kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao waamwanine Yusufu nangue, “Nene ndi Farao, inzi mono mu Misri monse tekuli muntu wakulendula kuboko ao lukasa kine teumupeele nsambu.” ");
INSERT INTO tap_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao waamwinikile Yusufu linge liina lya Zafenati-Panea ni kumuufia mwana mwanakazi liina lyakue Asenati mwina Potifera kitambua wa mu muzi wa Oni. ");
INSERT INTO tap_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu waali na myaka 30 lu-aabiikilue pa mwilo na Farao, likolo wa ku Misri. Yusufu waafumine kuli Farao ni kuya kwenda mu kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mu ezio myaka kilooba, kyalo kyaameniizie bilio bingi. ");
INSERT INTO tap_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mu ezio myaka kilooba Yusufu waakolonghaniizie bilio byonse bya mu kyalo kya Misri ni kubiziba mu milue. Mu mizi yonse ya mu Misri mwaazibilue bilio bya mu makaba aali aizyungulukiile. ");
INSERT INTO tap_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu waazibile bilio bingi sana byavulile nga musenga wa mumbali lyezi. Baalekeele ni kupenda pantu byaali byakilile kuvula. ");
INSERT INTO tap_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Lubaali tebanaingile mu mwaka wa nzala, Asenati mwana mwanakazi mwina Potifera kitambua wa mu muzi wa Oni, waali wasyamuvyaliile Yusufu baana babili balalume. ");
INSERT INTO tap_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Libeli wakue waamwinikile Manase. I kulanda nangue, “Leza wanengia kulaba maavia ane onse pamo ni lupua lwane.” ");
INSERT INTO tap_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana wa bubili waamwinikile Efraimu. I kulanda nangue, “Leza wan'mpeela luvyalo mu kyalo kya lyemo lyane.” ");
INSERT INTO tap_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Myaka kilooba ya bilio yaali mu kyalo kya Misri yaapwile, ");
INSERT INTO tap_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ni myaka kilooba ya nzala yaabambile nga mwaalandiile Yusufu, ni nzala yaakumeene mu kyalo kyonse. Inzi mu kyalo kya Misri temwaabulile bilio. ");
INSERT INTO tap_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nzala luyaakumeene mu kyalo kyonse kya Misri, bantu baile kumulilila Farao. Farao waabaanine Bamisri bonse nangue, “Endo mwaya kuli Yusufu. Kyonse ki-alikumyana, kite.” ");
INSERT INTO tap_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzala luyaakumeene mu kyalo kyonse, Yusufu waizwile milue onse ni kubamba kubasisia Bamisri bilio, ni nzala yaali yakilile kubiipa mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bantu ba mu byalo byonse baali baya kusita bilio mu Misri kuli Yusufu pantu nzala yaali yakilile kubiipa pa kyalo. ");
INSERT INTO tap_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo lu-aamanine nangue bilio bili ku Misri, waabaanine baana bakue nangue, “Mwe baana, ale mukentaniineki? ");
INSERT INTO tap_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nene nakyunvua nangue ku Misri bilio kubili. Kansi kookeleko muye mutusitileko, evi tekuti tufue na nzala.” ");
INSERT INTO tap_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kupwako, bakuluube lyanondo bakua Yusufu bakookelako baya ku kusita nghano. ");
INSERT INTO tap_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Inzi Yakobo taamutumineko Benyamina mwalawakue kwa Yusufu pantu waali watiina nangue pange kuti wakitikilua na kibiipile. ");
INSERT INTO tap_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Baizraeli baile pamo ni bange bantu ku kusita bilio ku Misri pantu mu kyalo kya Kanaani nzala yaali yakilile. ");
INSERT INTO tap_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ozo musita, Yusufu waali wali ndabukizi wa kyalo, kabili i waali wasisia bilio ku bantu bonse ba mu byalo. Bakuluube kwa Yusufu baizile kumufukamina ni kulaala kyuba. ");
INSERT INTO tap_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu lu-ainikile nangue ni bakuluube, waabambile kulanda nabo wasasile nga asibenikile. Waabeepuziizie evi, “Mufumine pi?” Baamwasukile nangue, “Fwefue tufumine ku kyalo kya Kanaani. Twizile kono ku kusita bilio.” ");
INSERT INTO tap_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Anzia kine Yusufu waabenikile, bene tebaamwinikile. ");
INSERT INTO tap_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu waalangulukile bilooto bi-aali waloota. Waabaanine evi, “Mwemue muli nengu. Mwiziile sie kumona bunake bwa kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Baakeene balanda nangue, “Ata we mukulu, fwefue tuli babombi bobe, twiziile sie kusita bilio. ");
INSERT INTO tap_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Fwefue tuli bena umo, tetuli nengu. We mukulu, fwefue tuli bantu ba kisinka.” ");
INSERT INTO tap_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusufu waabaanine evi, “Tekukaane, mwemue mwiziile kulengula bunake bwa kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Baalandile evi, “Fwe babombi bobe twaavyelue lyanondo ni babili, baana bena muntu umo wa mu kyalo kya Kanaani, mwalawetu wa mpeleezio asyele na situe, ni unge umo talipo.” ");
INSERT INTO tap_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu waalandile evi, “Mwemue muli nengu, nga munamyaninanga. ");
INSERT INTO tap_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ni pakako, namilapila mu liina lyakua Farao nangue mupalile kweziiwanke. Kine mwalawenu tanamoneke pano temukapeelua nsambu ya kubwelela kwenu. ");
INSERT INTO tap_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tume umo pakati kenu wakuti aye amutwame mwalawenu, ni mwe bange musyale mwakakilue mpaka lwakaba kusininkiziwa bintu bimwalanda. Inzi kulanda kisinka ntanzi yakua Farao mwemue muli nengu.” ");
INSERT INTO tap_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kupwako, wabakaka bonse mu buloko nsiku itatu. ");
INSERT INTO tap_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Busiku bwa butatu Yusufu waabaanine evi, “Kite bindikumyana mukeeza kufua pantu nene ndinatiina Leza. ");
INSERT INTO tap_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kine muli bantu ba kisinka, mukwenu umo asyale wakakilue molia mu buloko mumukakilue, inzi mwe bange endo mutwale bilio bya kupwisia nzala kwenu. ");
INSERT INTO tap_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mukabe kumuleeta mwalawenu pano evi nkabe kusininkizia nangue bulanzi bwenu ni bwa kisinka. Kine mukabe kukita evio nsikaba kumiipaya.” Ni bo baakitile evio. ");
INSERT INTO tap_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Baalanzyaniizie nangue, “Emwe, kisinka tulubile pantu twaakeene kunvwila mwalawetu nkumbu lu-aali watupaapaata. Keki i kitwaingilila mu aza maavia.” ");
INSERT INTO tap_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni waalandile evi, “I kalia kanaamyanine nangue tekumukitile kibiipile, inzi mwe mwaakeene. Te mwamona! Mulopa wakue ulimukukebua pali fwefue.” ");
INSERT INTO tap_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tebaamanine nangue Yusufu waabenikile pantu waali walanda nabo kupitila mu muntu waali walondolola bulanzi bwabo. ");
INSERT INTO tap_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu lu-aafumine papo pa baali, waatendekele kulila. Lu-aabweleelepo kabili, waamukwete Simeoni wamukaka ni bonse bamwene. ");
INSERT INTO tap_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu wa-anine bantu babeezuziizie bilio mu masaaka ni kubabiikilamo nfolanga yabo, kabili babapailile ni mpamba ya mu nzila. Evi i vibaabakitiile. ");
INSERT INTO tap_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Baaseziizie masaaka abo pa punda. Kupwako, babamba kuya. ");
INSERT INTO tap_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Lubaafikile pa nkendo ya kuti balaale, umopo waakakwile lisaaka lyakue abuulemo bilio bya kuliisia punda wakue, waamwene nfolanga yakue yali mukati. ");
INSERT INTO tap_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Waabaanine benakue nangue, “Emwe, ize mumone nfolanga yane inabweziiziwanga ezi ili momu mu lisaaka lyane.” Bonse baabambile kukwaka na mwezo balanda nangue, “Ni kiki keki kyatukitilanga Leza?” ");
INSERT INTO tap_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Lubaile kufika kuli sibo Yakobo ku kyalo kya Kanaani, baamubwilile byonse byaabakitikiile nangue, ");
INSERT INTO tap_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ozo mukulu wa kekio kyalo waali walanda wasasile sana kuli fwefue, kabili waali walanda nangue, ‘Tuli nengu ya kyalo.’” ");
INSERT INTO tap_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Twaamwanine, “We mukulu, fwefue tetuli nengu, inzi tuli sie bantu ba kisinka. ");
INSERT INTO tap_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Fwefue tuli benenke baana lyanondo ni babili bena situe umo. Mwana umo talipo, mwana mukala wene asyele ku kyalo kya Kanaani kuli situe.” ");
INSERT INTO tap_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ozo mukulu wa kyalo wakitwana evi, “Pakuti nsininkizie nangue mwemue muli bantu ba kisinka, umo pakati kenu alikusyala kono, inzi bange babwelelemo ni bilio pantu kuli nzala. ");
INSERT INTO tap_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Endo mumutwame mwalawenu mumuleete, mane nkabe kusininkizia nangue temuli nengu, kabili mane nkabe kumibweziizia muntu wenu. Kabili ni mwe mwaakaba mwasuluzia mu keno kyalo.” ");
INSERT INTO tap_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bonse lubaapongwele bilio mu masaaka abo, kubalua muntu waamwene kafunda kakue ka nfolanga mu lisaaka. Baana bonse pamo ni sibo lubaamwene evio, baatiinine. ");
INSERT INTO tap_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Sibo Yakobo waabaanine evi, “Mwemue mulimukun'mpwila baana bane! Yusufu talipo, ni Simeoni talipo, kabili evi mulimukukeba mumutwame ni Benyamina! Ena we lyemo!” ");
INSERT INTO tap_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubeni waamwanine se, “We tawe, kine nsikakubweziizia ozu mwana obe, ukepailemo baba baana bane babili. N'mpeele, ni ne nakaba kumubwezia” ");
INSERT INTO tap_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Waalandile evi, “Ata, ozu mwana wane wene temuya nakue. Unvue, mukuluube waafwile, ozu i wenka asyelepo sie. Pa-akaba kukitikilua na kibiipile mu nzila, nga mwakaba kunengia kufua na kikonko kya mu bukote bwane.” ");
INSERT INTO tap_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ozo musita, nzala yaakilile kubiipa mu kyalo. ");
INSERT INTO tap_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Lubaapwile bilio byonse bibaile kusita ku Misri, sibo waabaanine evi, “Endo mutusitileko binge bilio.” ");
INSERT INTO tap_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda waamwanine evi, “Olia muntu waatwaanine nangue, ‘Kine temukeeza ni mwalawenu, tekuti tukamonane nenu.’ ");
INSERT INTO tap_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kine ulikutupeela mwalawetu kuti tuye nakue, tulikukooka kuya ku kusitila bilio. ");
INSERT INTO tap_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Inzi kine wakaana kuti tuye nakue, fwefue tetukookelako pantu olia muntu waatwaanine nangue, ‘Kine temukeeza pamo ni mwalawenu, tekuti tukamonane nenu.’” ");
INSERT INTO tap_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izraeli waalandile evi, “Mwandeetela bwavia bukata sana. Ale mwaamubwiliileki nangue muli ni unge mwalawenu?” ");
INSERT INTO tap_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Baamwasukile nangue, “Ozo muntu waatwipuziizie biipuzio bingi sana palua lupua lwetu nangue, ‘Sinue akikosele? Temuli na mwalawenu?’ Fwefue twaamwasukile kukonkana ni vikili, inzi tetwaali twamanine nangue kuti watwana tukeeze ni mwalawetu.” ");
INSERT INTO tap_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda waamwanine se Izraeli, “N'mpeele mulumendo ngie nakue, ni fwe tulikuya, tetukafua na nzala, inzi twaakaba twakosele, fwefue ni wewe pamo ni baana betu. ");
INSERT INTO tap_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nene naakaba kikwatizi kyakue. Kine nsikamubwezia wakosele, ukansonze, ni kilubo kyaakaba kyali kyane muyayaya. ");
INSERT INTO tap_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Pantu kabenge tekukokola, evi nga tetusyabweleleko ni lya bubili.” ");
INSERT INTO tap_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Sibo Izraeli waabaanine evi, “Kine ni evio, kite evi: Twame mazabo awamiisie a mu keno kyalo mu bitwamo byenu mumutwalile ozo muntu byabupe: Zeri iniini, ni kapelo kaniini, ni manukato, ni manemane, ni batani, pamo ni lozi. ");
INSERT INTO tap_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mutwame nfolanga ya kuya kusitamo bilio ni ya kuya kubweziizia pa elia nfolanga i mwaiziliile nayo mu masaaka enu pantu pange baalabiliile kubiikamo. ");
INSERT INTO tap_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mumutwame ni mwalawenu muye nakue kuli ozo muntu. ");
INSERT INTO tap_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Leza wa Maka onse akalengie ozo muntu kumyunvwila nkumbu, evi mukabwele ni Benyamina pamo ni mukuluube. Kine kufwilua na baana bonse, nkafwilue sie.” ");
INSERT INTO tap_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kupwako, babo baana batwama byabupe ni Benyamina pamo ni nfolanga ya kusitamo bilio ni ya kuya kubwezia. Baabambile lwendo, bakookela ku Misri ni kuya kwimana pa ntanzi yakua Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu lu-aabamwene bali pamo ni Benyamina, waamwanine mubombi wakue nangue, “Bengizie mu nghanda yane, sinza nama uteanie pantu baba bantu lelo ndikulia nabo bilio bya musita wa koba.” ");
INSERT INTO tap_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mubombi waabengiziizie mu nghanda mwa Yusufu nga mwa-aniinue. ");
INSERT INTO tap_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bakuluube baatiinine pantu baingiziiziwe mu nghanda mwa Yusufu. Baalandile evi, “Twaingiziiwa mono pa mulandu wa nfolanga i twatwaaminiine mu masaaka etu lolia lutwaizile kusita bilio lwa mambo, evi atupeele mulandu ni kutupingula, apoke punda yetu ni kutwalula bazia bakue.” ");
INSERT INTO tap_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Baamupaleeme kalinda wa nghanda yakua Yusufu, babamba kulanda nakue pa mulyango nangue, ");
INSERT INTO tap_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“We mukulu, kisinka twaakookele kono lwa mambo kukusita bilio. ");
INSERT INTO tap_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Lutwaafikile pa nkendo ya kulaala, twaakakwile masaaka etu, kubalua muntu waamwene nfolanga yakue elia itwaasitilemo bilio yali mu lisaaka lyakue nga muyaali yabeeleele. Nfolanga ezi i twabwela nayo. ");
INSERT INTO tap_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kabili twaiza ni inge nfolanga ya kusitilako binge bilio. Fwefue tetumanine muntu waabiikile nfolanga yetu mu masaaka etu.” ");
INSERT INTO tap_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mubombi waalandile evi, “Mutende ube nenu, tekutiine. Leza wenu, Leza wakua sinue i waamipeele nfolanga mu masaaka enu. Pantu nene mwan'mpeele yakumeene.” Kupwako, wabaleetela Simeoni. ");
INSERT INTO tap_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mubombi waabengiziizie mu nghanda yakua Yusufu, wabapeela menda a kusamba ku makasa, kabili waya kuliisia ni punda yabo. ");
INSERT INTO tap_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Baateaniizie byabupe bya kupeela Yusufu, pantu waabaanine kwiza kulia nabo musita wa koba. ");
INSERT INTO tap_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu lu-aizile kwakue, baamupeele byabupe bibaizile nabio mu nghanda ni kumukontamina. ");
INSERT INTO tap_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Waabeepuziizie wabaana nangue, “Ale sinue mukote umwaalandile palwakua wene, ali sie bwino? Ni lenu kumo akikosele?” ");
INSERT INTO tap_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Baamwasukile nangue, “Mubombi obe, situe, ali sie bwino, ni lenu kumo akikosele.” Kabili baafukeeme ni kumukontamina. ");
INSERT INTO tap_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Lu-aamumwene mwalawakue Benyamina, mwana mwina nghina, waalandile evi, “Ati, ozu i mwalawenu umwan'mbwilile? Waalandile evi, ‘We mwana wane, Leza akunvwile nkumbu.’” ");
INSERT INTO tap_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kupwako, Yusufu wafumapo pantu waali wasyakeba kulila na nsansa ya kumona mwalawakue. Waingiile mu nghanda ku kati ni kubamba kulila. ");
INSERT INTO tap_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pa kyamba, waasambile ku menso, wafuma waisipikiizie ni kubaana bateanie bilio. ");
INSERT INTO tap_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusufu waateaniiziiziwe pa bunke, ni bakuluube pa bunke, Bamisri baali balia koko ni bo pa bunke pantu kyaali kya busoni Bamisri kuliila pamo ni Baebrania. ");
INSERT INTO tap_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Balupua bakua Yusufu baikeele pa ntanzi yakue bakonkeene, libeli pa nsambu yakue ya bubeli, ni mukala pa nsambu yakue ya bumukala. Ni bo, baali basyaipapa sie. ");
INSERT INTO tap_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Waabapeele bilio byaali byafuma pa ntanzi yakue. Benyamina waatuulikiiluepo lisaano kukila bakuluube. Baaminine ni kuwaminua pamo nakue. ");
INSERT INTO tap_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu wa-anine mubombi wa mu nghanda yakue nangue, “Izuzia bilio mu masaaka a baba bantu kukonkana ni vibalikuvinda kutwama, ubabiikilemo ni nfolanga yabo. ");
INSERT INTO tap_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kabili ubiike ni kikombe kyane kya mutofue mu lisaaka lyakua ozu mwanike, ubiikemo ni nfolanga yakue.” Ni ye waakitile mwa-aniinue na Yusufu. ");
INSERT INTO tap_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Lukeele lwakue paakili ba-aninue kuti baye pamo ni punda yabo. ");
INSERT INTO tap_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lubaali tebanafike kule ni muzi, Yusufu waamwanine mubombi wa mu nghanda yakue nangue, “Lenga ubakonke balia bantu bayanga. Pauya kubasanga, uye ubeepuzie evi, ‘Mwakitilangaki bibiipile ku muntu waamikitiile biweme? ");
INSERT INTO tap_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Temuli na kikombe kyakua tawelenzi? ki-aliwamininamo ni kubukilako? Mwaluvia sana.’” ");
INSERT INTO tap_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Lu-aabasangile, waabaanine totu twebo. ");
INSERT INTO tap_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Baamwanine evi, “We mulopue, walandilaki evio? Kulanda kisinka tetwakitanga kintu kya ozu musango. ");
INSERT INTO tap_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Unvua, lolia lutwaatwaminiine nfolanga mu masaaka etu mpaka ku Kanaani, twakikubweziizia. Eba, ale tulikwibilaki mutofue ao oro yakua solenzi? ");
INSERT INTO tap_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ewe, kansi kine pa fwefue babombi bobe palikusangua umo ali nakio, afue, ni fwefue bange bonse tukabe bazia benu.” ");
INSERT INTO tap_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Waalandile evi, “Kibe nga mumwalandila. Olia alikusangua nakio, alikuya wali muzia wane, ni mwe bange temuya mwali na kilubo.” ");
INSERT INTO tap_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kupwako, penka papo bakoosiizia masaaka abo pansi, kubalua muntu wabamba kukakula lisaaka lyakue. ");
INSERT INTO tap_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Waabambiile kukeba mu lisaaka lyakua mukulu mpaka wapeleezia mu lisaaka lyakua mwanike. Kikombe kyaamonekele mu lisaaka lyakua Benyamina. ");
INSERT INTO tap_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kupwako, bonse bazabula ngubo yabo, kubalua muntu wabiika lisaaka lyakue pa punda wakue ni kubwelela ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda ni bakuluube baile mu nghanda yakua Yusufu, ni ye waali wakili penka palia. Bonse baaleele kyuba. ");
INSERT INTO tap_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu waabaanine evi, “Mwakitilangaki evi? Temumanine nangue muntu nga nene kuti nabuka ni kumana bintu byonse?” ");
INSERT INTO tap_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda waamwasukile evi, “We mukulu, tulikukwanaki? Kabili tulikulandaki? Tulikukaana syani kibalo? Leza mwine i-amwene bubi bwa babombi bobe. Evi fwe bonse tuli bazia bobe pamo ni olia wakwatwanga watweme kikombe.” ");
INSERT INTO tap_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu waalandile evi, “Ata, nene nsivinda kukita evio! Nalanda evi, olia wenka wakwatwanga wali ni kikombe i muzia wane. Inzi mwemue bange ilepo bwino kuli sinue.” ");
INSERT INTO tap_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda waamupaleeme ni kumwana nangue, “We mulopue, napaapaata nandepo keebo kamo ka kunvwika ku matui akua tawelenzi. Tekufiitilua mubombi obe pantu wewe uli nga Farao. ");
INSERT INTO tap_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","We Tawelenzi, waatwipuziizie fwe babombi bobe nangue, ‘Kubako muli ni sinue ao mwalawenu?’ ");
INSERT INTO tap_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Fwefue twa-asukile evi, ‘Ee, tuli ni situe mukote ni mwana wa mu bukote bwakue, inzi mukuluube kwa ozo mwanike waafwile. Ozo mwana i asyelepo sie wakosele mu livumo lyabo, ni se amutonene.’ ");
INSERT INTO tap_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Wewe waatwanine fwe babombi bobe tumuleete umumone, ");
INSERT INTO tap_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Inzi fwefue twa-asukile nangue, ‘Mulumendo tavinda kumusia se, pantu kine wamusia, se kuti wafua.’ ");
INSERT INTO tap_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Wewe wa-anine babombi bobe nangue, ‘Kine temukeeza ni mwalawenu, tekuti tukamonane nenu.’ ");
INSERT INTO tap_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Lutwaabweleele kuli situe, twaamubwilile byonse bitwa-aninue na tawelenzi. ");
INSERT INTO tap_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Situe waalandile evi, ‘Kabili endo mwaye mutusitileko binge bilio.’ ");
INSERT INTO tap_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Fwefue twaalandile evi, ‘Tetuvinda kukookelako. Inzi kine tulikuya ni mwalawetu, tulikukookelako, pantu tetuvinda kuya kumonana na olia muntu kine tetuiile ni mwalawetu.’ ");
INSERT INTO tap_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mubombi obe, tawe, waatwanine, ‘Mumanine nangue mukazi wane Rakeli wanvyaliile sie baana babili balalumenke. ");
INSERT INTO tap_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Umo nsikili nakue, kisinka waaputwilue sie tuniini tuniini, kabili nsyamumwene. ");
INSERT INTO tap_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kine mwantwamina ni ozu, ni ye waya kukitikilua na kibiipile, kuti mwangipailila sie na bulanda bwa mu bukote bwane.’ ");
INSERT INTO tap_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ni pakako kine naya kuli tawe, mubombi obe, tekuba nali na ozu mulumendo, pantu maswapi a bukose bwakua tawe ali mu ozu mwana, ");
INSERT INTO tap_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","pa-akaba kumona nangue mulumendo tetuli nakue wakaba kufua. Ni babombi bobe baakeepaizia sibo mukote wali ni bulanda. ");
INSERT INTO tap_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Pantu mubombi obe waikitile kikwatizi kuli se walanda nangue, ‘Kine nsikaba kumubwezia kuli wewe, naakaba ni kilubo kya muyayaya kuli we tawe.’ ");
INSERT INTO tap_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kansi evi ne mubombi obe nakulomba nsyale nali muzia kuli we tawelenzi pa kifuka kyakua ozu mulumendo, inzi ozu mulumendo asele aye pamo ni bakuluube. ");
INSERT INTO tap_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ale ndikubwela syani kuli tawe tekuba namutweme ozu mulumendo? Nsitonene kuya kumona kyakaba kumukitikila tawe.” ");
INSERT INTO tap_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusufu wa-andilue kusipikizia ntanzi yabo bonse baali baimeene pepi nakue. Waalandile evi, “Mwe babombi bonse ba mu Misri, fume.” Lwaafuminepo babombi bonse ba mu Misri, Yusufu waimaniizie ku bakuluube. ");
INSERT INTO tap_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wa-angwile walila mpaka ni Bamisri baali bali panze baunvua, pamo ni ba mu nghanda yakua Farao. ");
INSERT INTO tap_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu waabaanine bakuluube, “Nene ndi Yusufu. Tawe akikosele ni lenu kumo?” Bakuluube lubaunvwile evio, ba-andilue kumwasuka pantu baamutiinine. ");
INSERT INTO tap_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu waabaanine bakuluube, “Namilomba mun'mpalame.” Baamupaleeme. Waabaanine evi, “Nene ndi Yusufu umwasisiizie ni kuleetua kono ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kansi tekunvue bulanda ao kufiitilwane pantu mwansisiizie, inzi waminue sie pantu Leza wantangiziizie kono pakuti n'mpususie bukose bwa bantu. ");
INSERT INTO tap_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Eno ikili sie myaka ibili ya nzala mu kyalo. Kusyele ni inge myaka isaano ya nzala. Mu ezio myaka tekukaba kulima ao kuzombola. ");
INSERT INTO tap_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Leza wantangiziizie ntanzi yenu pakuti n'misunge mwe basyelepo, kuti luvyalo lwenu lukatwalilile pa kyalo ni kumipususia na bupusuko bukata. ");
INSERT INTO tap_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kansi te mwemue bandeetele pano, inzi ni Leza. Ni ye wankitile kuba nga se kwa Farao ni mukulu wa mu nghanda yakue yonse, ni ndabukizi wa kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ale lenge musele kuli tawe mumwane nangue Yusufu mwana obe walanda evi, ‘Leza anteekele kuba ndabukizi wa kyalo kyonse kya Misri. Lenga ukookele kono kuli nene, ");
INSERT INTO tap_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ukabe kwiza kwikala ku Goseni, koko i kuwaakaba wapalameene ni nene. Wewe ni baana bobe, ni benzikulu bobe, ni mikooko yobe, ni nghombe yobe pamo ni binge byonse byuli nabio. ");
INSERT INTO tap_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Papo i panaakakusunga pantu kukili ni inge myaka isaano ya nzala, evi tekuti ukabe mupabi, wewe ni lupua lobe pamo ni byonse byuli nabio.’ ");
INSERT INTO tap_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Evi mwaimwena na menso enu, ni mwalawane Benyamina waimwena na menso akue nangue nene i wenka Yusufu alimukulanda nenu. ");
INSERT INTO tap_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mukabe kuya kumubwila tawe bulumba bwane bonse bundi nabo mu kyalo kya Misri, ni bintu byonse bimwamona. Kabili mukabe kulenga kumukoosiizia tawe kono.” ");
INSERT INTO tap_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kupwako, wamukumbatila Benyamina watendeka kulila. Benyamina ni ye wamukumbatila ni kutendeka kulila. ");
INSERT INTO tap_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kabili waakumbatiile bakuluube bonse ni kubalilila. Pa kyamba, bakuluube baalanzyenie nakue. ");
INSERT INTO tap_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mpunda luyaunvwikile ku nghanda yakua Farao nangue bakuluube kwa Yusufu bakiiza, Farao ni babombi bakue baawamiinue. ");
INSERT INTO tap_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao waamwanine Yusufu, “Baane bakuluubo nangue, ‘Kite evi, longele bintu pa nama yenu musele muye ku kyalo kya Kanaani, ");
INSERT INTO tap_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","muye mu mutwame sinue ni lupua lwenu mwize kono kwane, ni ne naakamipeela biweme bya mu kyalo kya Misri, kabili mwaakaba mwalia binonene bya mu kyalo.’ ");
INSERT INTO tap_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kabili baane nangue, ‘Twame matyakala a mono mu Misri a kuti muye mutwaminemo baana benu ni bakazi benu pamo ni sinue mwize nakue. ");
INSERT INTO tap_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kabili tekusakamane palua bintu byenu pantu bintu biweme bya mu kyalo kyonse kya Misri byaakaba byenu.’” ");
INSERT INTO tap_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Baizraeli baakitile muba-aniinue. Yusufu waabapeele matyakala ni mpao ya mu nzila nga mwaalandiile Farao. ");
INSERT INTO tap_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kubalua muntu waapeelue ngubo ya lenu, inzi Benyamina wene waapeelue ngubo isaano ya lenu ni nfolanga ya mutofue 300. ");
INSERT INTO tap_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Waamutumiine se punda lyanondo yaali yatweme bintu biweme bya mu Misri ni punda ikota lyanondo yaali yatweme nghano ni mikate pamo ni binge bilio bya mpao ya mu nzila. ");
INSERT INTO tap_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Lu-aabapeele nsambu ya kuya, waabaanine evi, “Tekukankabule mu nzila.” ");
INSERT INTO tap_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kupwako, basela kufuma ku Misri ni kuya ku kyalo kya Kanaani kuli sibo Yakobo. ");
INSERT INTO tap_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Baamwanine nangue, “Yusufu akikosele ni lenu kumo, kabili i ndabukizi wa mu kyalo kyonse kya Misri!” Yakobo lu-aunvwile evio, waapenzukile pantu taabaketekeele. ");
INSERT INTO tap_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Baamulondolweleele byonse biba-aninue na Yusufu. Lu-aamwene matyakala aatuminue na Yusufu akuti atwamuemo, mutima wakua sibo Yakobo waateekameene. ");
INSERT INTO tap_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Izraeli waalandile evi, “Emwe! Eyo mwana wane akikosele! Mpaka nkabe kuya kumumona lunsinafue.” ");
INSERT INTO tap_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Izraeli waile pamo ni byonse bi-aali nabio waya kufika ku Beri-Seba, wamwelela Leza wakua se Izaaki ngelelo. ");
INSERT INTO tap_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Leza waamwanine Izraeli mu kimonua kya busiku. Waamukuutile, “Yakobo, Yakobo.” Wa-asukile nangue, “Ne ono pano.” ");
INSERT INTO tap_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Waamwanine, “Nene ndi Leza, Leza wakua so. Tekutiina kukookela ku Misri pantu i kunaakakukita kuba mutundu ukata. ");
INSERT INTO tap_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ndikukooka pamo nobe ku Misri, kabili naakakusezia paakale. Yusufu i waakakuziika.” ");
INSERT INTO tap_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakobo waafumine ku Beri-Seba. Baizraeli baamutweme sibo Yakobo, ni baana babo pamo ni bakazi babo mu matyakala aatuminue na Farao kuti bamutwamemo. ");
INSERT INTO tap_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kupwako, batwama nama yabo pamo ni bunonsi bwabo bubaanonkele mu kyalo kya Kanaani. Yakobo waya ku Misri pamo ni luvyalo lwakue lonse. ");
INSERT INTO tap_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Baana bakue balalume, ni baana bakue banakazi, ni benzikulu bakue balalume ni banakazi, waile nabo ku Misri. ");
INSERT INTO tap_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakobo ni baana bakue baile ku Misri. Meena a baana bena Yakobo, aliwakutua Izraeli, ni aza: Rubeni i libeli. ");
INSERT INTO tap_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ni bena Rubeni ni baba: Hanoki, ni Palu, ni Hesroni pamo ni Karmi. ");
INSERT INTO tap_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ni meena a baana balalume bakua Simeoni ni aza: Yemueli, ni Yaminu, ni Ohadu, ni Yakini, ni Zohari pamo ni Sauli mwina mwanakazi wa ku Kanaani. ");
INSERT INTO tap_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ni meena a baana balalume bakua Lawi ni aza: Gershoni, ni Kohati pamo ni Merari. ");
INSERT INTO tap_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ni meena a baana balalume bakua Yuda ni aza: Eri, ni Onanu, ni Sela, ni Peresi, ni Zera. Inzi Eri ni Onanu baafwiliile mu kyalo kya Kanaani. Ni meena a baana balalume bakua Perezi ni aza: Hesroni ni Hamuli. ");
INSERT INTO tap_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ni meena a baana balalume bakua Isakari ni aza: Tola, ni Pua, ni Iobu pamo ni Simuroni. ");
INSERT INTO tap_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ni meena a baana balalume bakua Zabuloni ni aza: Seredi, ni Eloni pamo ni Yaleli. ");
INSERT INTO tap_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Babo i bena Lea ba-aamuvyaliile Yakobo ku Padani-Aramu pamo ni Dina mwana mwanakazi. Baana bakue bonse, balalume ni banakazi, baali 33. ");
INSERT INTO tap_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ni meena a baana balalume bakua Gadi ni aza: Sifioni, ni Hagi, ni Suni, ni Eziboni, ni Eri, ni Arodi pamo ni Areli. ");
INSERT INTO tap_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ni meena a baana balalume bakua Aseri ni aza: Imuna, ni Isiwa, ni Isiwi, ni Beria pamo ni nkazi yabo Sera. Ni meena a baana balalume bakua Beria ni aza: Heberi ni Malkieli. ");
INSERT INTO tap_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Baba i baana bena Silipa waufiiziwe Yakobo. Lea waapeelue ozu Silipa na Labani kuti aye wali mubombi wakue. Bonse pamo baali lyanondo ni mutanda. ");
INSERT INTO tap_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ni meena a baana balalume bakua Rakeli muka Yakobo ni aza: Yusufu ni Benyamina. ");
INSERT INTO tap_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufu waavyele baana babili balalume muli Asenati mwina Potifera kitambua wa mu muzi wa Oni, ni bo meena abo ni aza: Manase ni Efraimu. ");
INSERT INTO tap_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ni meena a baana balalume bakua Benyamina ni aza: Bela, ni Bekeri, ni Asibeli, ni Gera, ni Naamani, ni Ehi, ni Rosi, ni Mupimu, ni Hupimu pamo ni Ardi. ");
INSERT INTO tap_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Baba i baana lyanondo ni bana bakua Yakobo ba-aavyele muli Rakeli. ");
INSERT INTO tap_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani waavyele mwana mwalalume Husimu. ");
INSERT INTO tap_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ni meena a baana balalume bakua Nafutali ni aza: Yazeli, ni Guni, ni Yezeri pamo ni Silemu. ");
INSERT INTO tap_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Baba i baana kilooba bakua Yakobo ba-aavyele muli Biliha. Rakeli waapeelue Biliha na Labani kuti aye wali mubombi wakue. ");
INSERT INTO tap_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bantu baile na Yakobo mu Misri, bantu ba mu luvyalo lwakue pasili kupendako bamuka baana bakue, baali bantu 66. ");
INSERT INTO tap_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusufu lu-aali ku Misri waavyele baana babili balalume. Bantu bonse ba mu luvyalo lwakua Yakobo baile ku Misri baali bantu 70. ");
INSERT INTO tap_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo waamutumine Yuda kuti abatangilile kuya kumwana Yusufu bakabe kuya kusaakaana nakue mu Goseni. Lubaafikile ku Goseni, ");
INSERT INTO tap_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu waingiile mu tyakala yakue aye asaakaane ni se Izraeli ku Goseni. Lubaamoneene, Yusufu waile kumukumbatila mu mukosi. Waalilile musita ukata. ");
INSERT INTO tap_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izraeli waamwanine Yusufu nangue, “Evi vinakumona wakosele mpaka lenu, kansi kuti nafua.” ");
INSERT INTO tap_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kabili Yusufu waabaanine bakuluube pamo ni lupua lonse lwakua se nangue, “Evi ndikusela ngie n'mubwile Farao nangue, ‘Bakuluamwine pamo ni lupua lwakua tawe bakifuma ku Kanaani, baiza. ");
INSERT INTO tap_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Baba bantu ni basungi ba nama, kabili bezile ni bisepe byabo bya nghombe ni bya mikooko pamo ni bintu byabo byonse.’ ");
INSERT INTO tap_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kine Farao akabe kumikuuta ni kumiipuzia nangue, ‘Mulimwabomba mwiloki?’ ");
INSERT INTO tap_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mukabe kumwana nangue, ‘Fwefue tuli basungi ba nama kutula ku bwanike bwetu nga mwaali mwakitila babikolue betu.’ Ni pakako, wakaba kumyana mukabe kwikala ku Goseni, pantu kubalua musungi wa mikooko, Bamisri bamumwene kuba wa mpuni.” ");
INSERT INTO tap_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu waile kumwana Farao nangue, “Tawe ni bakuluamwine kufuma ku Kanaani, bakiiza ni bisepe bya nghombe ni bya mikooko pamo ni bintu byonse bibali nabio. Evi bali ku Goseni.” ");
INSERT INTO tap_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Waatweme bakuluube basaano ni kuya kubalangisia kuli Farao. ");
INSERT INTO tap_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao waabeepuziizie babo bantu, “Mulimwabomba mwiloki?” Baamwasukile Farao, “Fwefue tuli basungi ba nama nga vyaali babikolue betu. ");
INSERT INTO tap_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Twaiza twikale mu keno kyalo pantu mu kyalo kya Kanaani nzala yakila kubiipa, kabili ni bikusi bya kuliisia nama yetu tekuli. Ni pakako, twapaapaata utwitabizie kwikala ku Goseni.” ");
INSERT INTO tap_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao waamwanine Yusufu, “Kyawama pantu so ni bakuluubo bakiiza. ");
INSERT INTO tap_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Kyalo kya Misri kili mu maboko obe. Baleke bakuluubo pamo ni so bekale pa nkendo iwamiisie ya Goseni. Kabili kine umaninepo bantu bapamine, ukababiike pa busungi bwa nama yane.” ");
INSERT INTO tap_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusufu waile kumulangisia se Yakobo kuli Farao. Yakobo waamupaalile Farao. ");
INSERT INTO tap_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao waamwipuziizie Yakobo, “Uli na myaka inga?” ");
INSERT INTO tap_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo wa-asukile evi, “Ndi sie na myaka 130, kabili naali nakuukakuuka sie. Babikolue bane ni bo baali bakuukakuuka sie. Inzi bene baikeele myaka ingi, kabili ni bwikazi bwabo tebwaali bwabiipile nga bwane.” ");
INSERT INTO tap_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kupwako, Yakobo wamupaala Farao ni kufumamo waya. ");
INSERT INTO tap_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu waamupeele se ni bakuluube nkendo yaali yawamiisie ya mu kyalo kya Misri pepi ni muzi wa Ramese nga mwa-aniinue na Farao. ");
INSERT INTO tap_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yakobo ni baana bakue pamo ni luvyalo lwakue lonse, baali bapeelua bilio na Yusufu kukonkana ni bwingi bwa baana babo. ");
INSERT INTO tap_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nzala yaakilile kubiipa mpaka bilio byapwililika mu kyalo kyonse, bantu ba mu Misri ni ba ku Kanaani baemiiziwe sana na nzala. ");
INSERT INTO tap_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu waakolonghaniizie nfolanga yonse yaamwenekele mu kyalo kya Misri ni mu kyalo kya Kanaani, ezio yaanonkelue lubaasisiizie nghano. Yusufu waatwele nfolanga mu nghanda yakua Farao. ");
INSERT INTO tap_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nfolanga yonse luyaapwile mu kyalo kya Misri ni kya Kanaani, Bamisri baile kumwana Yusufu nangue, “Tupeele bilio tukeeza kufua na nzala pa ntanzi yobe pantu tetukili na nfolanga.” ");
INSERT INTO tap_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu waabaanine evi, “Kine temukwete nfolanga, n'mpeele nama yenu ni nene n'mipeele bilio.” ");
INSERT INTO tap_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Bamisri baamupeele Yusufu farasi, ni mikooko, ni mbuzi, ni nghombe, pamo ni punda. Ni wene waabapeele bilio bya kulia mwaka onse walingi. ");
INSERT INTO tap_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka waakonkelepo, baile kumwana Yusufu nangue, “Tetuvinda kukufiika kantu. We mukulu, nfolanga yetu yonse yapua, ni bisepe bya nama bitwaali nabio twaakupeele. Evi tetukili kabili na kantu ka kukupeela, inga sie mibili yetu ni kyalo kyetu. ");
INSERT INTO tap_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tekutulekeela tufue pa ntanzi yobe, fwefue ni kyalo kyetu. Kansi twaipeela sie utusite fwefue benka ni kyalo kyetu na bilio, evi tuye twali bazia bakua Farao, twalomba utupeele bilio tulie tukafua, ni kyalo kyetu kikeeza kusyala kibolia.” ");
INSERT INTO tap_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yusufu waamusitiile Farao kyalo kyonse kya Misri. Bamisri baasisiizie kyalo pa mulandu wa nzala yaakilile kubiipa. Kyalo kyonse kya Misri kya-alukile kyakua Farao. ");
INSERT INTO tap_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusufu waakuusiizie Bamisri kufuma mu mipaka yonse ya Misri ni kubaleeta mukati mizi. ");
INSERT INTO tap_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Inga sie nkendo yaali yaikeelemo babitambua i isyaasitilue pantu Farao waali wabapeela bilio bya kulia. Keki i kyaalengele tekuti basisie nkendo yabo. ");
INSERT INTO tap_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu waabaanine bantu nangue, “Unvue, kyalo pamo ni mwemue namusitila Farao. Ale poke mbezu ezi mubyale mu makaba enu. ");
INSERT INTO tap_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pa musita wa kuzombola, mukabuulepo kimo kya pa bisaano ni kumupeela Farao, ni byaakasyalapo i bimwaakaba mwafumiapo mbezu ni bilio bimwaakaba mwalia ni baana benu pamo ni ba mu nghanda yenu.” ");
INSERT INTO tap_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Baalandile evi, “We mukulu, wabomba. Evi watupususia. Twaitabila kuya twali bazia bakua Farao.” ");
INSERT INTO tap_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ozu mulandu Yusufu waukitile kuba muzilo nangue, kimo kya pa bisaano kiye kyapeelua likolo. Leli lifunde ni lenu kumo likiliko. Inga sie mu nkendo yaali yaikeelemo babitambua. ");
INSERT INTO tap_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Baizraeli baikeele ku Goseni mu Misri momo mubaanonkele, baasandulukile ni kukila kuvula. ");
INSERT INTO tap_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo waikeele mu Misri myaka lyanondo ni kilooba. Myaka yonse yaikeele Yakobo pa kyalo yaali 147. ");
INSERT INTO tap_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kufua kwakua Izraeli lukwaapaleeme, waamukuutile mwana wakue Yusufu wamwana nangue, “Kine wangitabizia, biika kuboko kobe kwinsina litanta lyane unkitile kiweme ni kisinka. Nakulomba tekuti ukanziike mu Misri. ");
INSERT INTO tap_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Inzi pankafua ntonene ukanziike kolia kwaaziikilue babikolue bane.” Yusufu wa-asukile evi, “Nakaba kukita nga muwalandila.” ");
INSERT INTO tap_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Izraeli waalandile evi, “Ale ndapile.” Yusufu walapa. Kupwako, Izraeli wafwinamina pa bulita lya ku mitue. ");
INSERT INTO tap_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Pa kyamba kya nsiku, muntu umo waamubwilile Yusufu nangue se Yakobo alwele ku Goseni. Kupwako, Yusufu watwama baana bakue, Manase ni Efraimu, baya. ");
INSERT INTO tap_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Lubaafikile, muntu umo waamubwilile Yakobo nangue, “Mwana obe Yusufu waiza,” Izraeli waikoseleziizie, wabuuka ni kwikala pa bulita. ");
INSERT INTO tap_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo waamwanine Yusufu nangue, “Leza wa Maka onse lu-aan'mwenekeele ku Luzi mu kyalo kya Kanaani, waan'mpaalile. ");
INSERT INTO tap_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Wanghanine nangue, ‘Naakakuvuzia ni kukusandulula, kabili naakakukita kuba libumba lya ntundu, ni pa kyamba kyobe, nvyalo yobe naakaipeela keki kyalo kuba bupyani bwabo lonse.’ ");
INSERT INTO tap_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ni evi baba baana babili bawaavyaliile mu Misri lunaali nsinaize kuli wewe, ni baana bane. Efraimu ni Manase baakaba bane nga Rubeni, ni Simeoni. ");
INSERT INTO tap_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Inzi baana bawaakavyala pa kyamba kya baba, baakaba bobe, ni bupyani bwabo bwaakaba kuli Efraimu ni Manase. ");
INSERT INTO tap_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nakita evi pa mulandu wakua noko Rakeli waafwiliile mu Kanaanni pepi ni Efura lunaali nalimukufuma ku Padani-Aramu. Naamuziikile mu Kanaani mumbali musebo ulungi ku Efura.” (Eno nsiku Efura i Betlehemu). ");
INSERT INTO tap_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Izraeli lu-aamwene bena Yusufu waipuziizie evi, “Ale baba ni bani?” ");
INSERT INTO tap_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu wa-asukile evi, “Baba ni baana bane banaapeelue na Leza mono mu Misri.” Yakobo waalandile evi, “Ale bapalamike pano n'mbapaale.” ");
INSERT INTO tap_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Menso akua Yakobo te aali amona pa mulandu wa bukote. Yusufu waamupalamikiile baana, Yakobo ni ye waabakwete ni kubakumbatila. ");
INSERT INTO tap_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izraeli waamwanine Yusufu, “Nsyaali naswapiile nangue twaakamonana kabili. Inzi evi Leza wan'mpaala namonako ni baana bobe.” ");
INSERT INTO tap_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kupwako, Yusufu wabafumia mu kyeni kyakua Izraeli. Yusufu waakontamiine pansi. ");
INSERT INTO tap_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusufu waabakwete baana bonse babili. Efraimu ku kuboko kwakue kwa kulio walungheeme ku kuboko kuso kwakua Izraeli, ni Manase ku kuboko kwakue kwa kuso walungheeme ku kuboko kulio kwakua Izraeli ni kubapalamika kuli wene. ");
INSERT INTO tap_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Inzi Izraeli waakilinghaniizie maboko akue, kuboko kulio wabiika pa mutue wakua Efraimu waali wali mwanike, ni kuboko kwakue kwa kuso wabiika pa mutue wakua Manase waali wali mukulu. ");
INSERT INTO tap_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yakobo waamupaalile Yusufu walanda, “Leza waali watangiliile tawekulu Abrahamu ni tawe Izaaki, Leza waali wanombwele mu bukose bwane bonse mpaka lenu, ");
INSERT INTO tap_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","olia malaika wan'mpususiizie mu maavia onse, abapaale baba balumendo. Bakabe bakuutua mu liina lyane, ni mu liina lyakua tawekulu Abrahamu ni lyakua tawe Izaaki. Bakakile kusanduluka mu kyalo kyonse.” ");
INSERT INTO tap_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu lu-aamwene nangue se wabiika kuboko kwakue kwa kulio pa mutue wakua Efraimu, taawaamiinue. Ni pakako, waakwete kuboko kwakua se, wafumia pa mutue wakua Efraimu wabiika pa mutue wakua Manase. ");
INSERT INTO tap_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Waamwanine se nangue, “We tawe, tekukita evi pantu mukulu ni ozu. Wene i wakuti ubiikile kuboko kobe kwa kulio pa mutue wakue.” ");
INSERT INTO tap_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Se waakeene walanda nangue, “We mwana wane, n'manine kindimukukita. Manase waakaba mutundu ukata. Inzi mwalawakue waakaba mukulu kukila wene, ni nvyalo yakue yaakaba libumba lya ntundu.” ");
INSERT INTO tap_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Bobo busiku, Yakobo waabapaalile wabaana nangue ku ntanzi Baizraeli baakaba balombelana mapaalo balanda nangue, “Leza akupaale nga vi-aapaalile Efraimu ni Manase.” Yakobo waatangiziizie Efraimu pali Manase. ");
INSERT INTO tap_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kabili Izraeli waamwanine Yusufu, “Mona nene nsisyaumiine kufua, inzi Leza waakaba pamo nenu, kabili waakamilombola kuti mukabwelele mu kyalo kya babikolue betu. ");
INSERT INTO tap_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Inzi wewe pantu uli nga mukulu pa ba kobe, nakulundilako nkendo imo pa nkendo inaapokele ku Ba-amori ku maka a kipanga ni buta bwane.” ");
INSERT INTO tap_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakobo waakuutile baana bakue wabaana nangue, “Ize munkolonghane n'myane bintu byaakamikitikila mu nsiku ya ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Mwe bena Yakobo, kolonghane munvue. Mutwilizie sinue Izraeli. ");
INSERT INTO tap_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubeni, wewe uli libeli wane, maka ane ni ntendeko ya kuluma kwane, mukulu mu mukinzi, mukulu mu buvinde. ");
INSERT INTO tap_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Wewe uliwabiluluka nga menda. Teukaba wakindeeme, pantu waaselele pa bulita bwakua so ni kubutiikaania. ");
INSERT INTO tap_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni ni Lawi, ni benenke. Bipanga byabo i bilwilo bya bubi. ");
INSERT INTO tap_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","We mutima wane, tekwingila mu mapange abo a mu kafiso. Bulumba bwane tekuti bwampane na kilie kyabo pantu baipaile muntu na kipuki kyabo, ni mubutaale bwabo baaputwile misipa ya nghombe ndume. ");
INSERT INTO tap_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kikonko kyabo kitiipue, pantu kikilile kusasa, ni kipuki kyabo pantu tekyaali na nkumbu. Naakabakasania muli Yakobo. Naakabasalanghania muli Izraeli. ");
INSERT INTO tap_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“We Yuda, ba kobe baakakutasia. Kuboko kobe kwaakaba pa mukosi wa balwani bobe. Baana bena so baakakukontamina. ");
INSERT INTO tap_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, i nkalamu musoka kufuma mu kwipaya nama, we mwana wane wakibwela. Wene waakonteeme, waifiika nga nkalamu, nga nkalamu mukota, nani waakamubuusia? ");
INSERT INTO tap_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nfimbo teikafuma mu Yuda, ao kabango ka bukolo mu maulu akue, mpaka Shilo akeeze, wene waakanakilua na ntundu. ");
INSERT INTO tap_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wene waakakakila punda wakue ku muzabibu, ni musoka wa punda ku muzabibu uwamiisie. Waakufula ngubo yakue mu divai, ni bivwalo byakue mu mulopa wa mizabibu. ");
INSERT INTO tap_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Menso akue akaba akasikile na divai. Meeno akue aswetele na mabeele. ");
INSERT INTO tap_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabuloni waakeekala mumbali lyezi, ni ye waakaba kyabu kya maato. Mipaka yakue yaakaba yafikile ku Sidona. ");
INSERT INTO tap_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakari i punda alumine aliwaifiika mu bipata bya mikooko. ");
INSERT INTO tap_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Amwene nkendo ya kutuuziapo paweme, ni kyalo nangue kyaali kyafwaniine. Akoosiizie kikoope kyakue kuti kitwame bitwamo, ni kuya wali mubombi wa miilo ikolele. ");
INSERT INTO tap_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani waakapingula bantu bakue nga umo wa mu mikoa yakua Izraeli. ");
INSERT INTO tap_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani waakaba kizoka kya mumbali musebo, kizoka kiniini kya mumbali nzila kili ni bwimba kilikyasuma farasi ku kasinghino ni aselelepo wapona kansenia. ");
INSERT INTO tap_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“We Yawe, n'mpembeele bupusuko bobe. ");
INSERT INTO tap_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi, waakasakukilua na libumba, inzi wene waakabasakukila ni kubakonka. ");
INSERT INTO tap_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Mu kyalo kya Aseri mwaakaba bilio bingi, ni ye waakaba wafumia bya kulia biweme bya makolo. ");
INSERT INTO tap_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutali i mbazi asikakilue aliwalanda twebo tuweme. ");
INSERT INTO tap_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusufu i musambo wa mazabo, musambo wa mazabo mumbali kasulo. Misambo yakue itambaleele mu kibumba. ");
INSERT INTO tap_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wene waasakukiilue na bantu bali ni mivui, baamulasile mivui ni kumwemia. ");
INSERT INTO tap_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Inzi buta bwakue bwaasyele bwalumine, maboko akue aalumiiziwe na maboko akua wa Maka onse, wakua Yakobo. Wa-aalwilue musungi wa mikooko, libue lyakua Izraeli, ");
INSERT INTO tap_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Na Leza wakua so waakakukwasia. Na Leza wa Maka onse waakakupaala. Na mapaalo a mwiulu mu muulu, mapaalo a mu biina bifikile pansi, mapaalo a konsia ni a kwimita. ");
INSERT INTO tap_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mapaalo akua so ni akata kukila mapaalo a mpili ya kale, kukila bintu bitonekele bya mpili ya muyayaya. Bebi byonse biye byali pa mutue wakua Yusufu, pa mpala yakua mulombozi pa bakuluube. ");
INSERT INTO tap_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamina i mumbue asasile. Lukeelekeele alikulia mabingo, ni kyungulo alikukasania bi-aipayanga.” ");
INSERT INTO tap_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ezi i mikoa lyanondo ni ibili yakua Izraeli, kabili evi i viba-aninue na sibo ni kubapaala kubalua muntu mapaalo akue. ");
INSERT INTO tap_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakobo waabaanine baana bakue nangue, “Evi pasyankabe kufua ni kuya ku bantu bane. Mukabe kunziika mu kilibu kili mu bukaba bwakua Efuroni Muhiti, ");
INSERT INTO tap_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kilibu kili mu bukaba bwa ku Makipela lya ku kabanga ka Mamure mu kyalo kya Kanaani, kilibu kyaasitilue na Abrahamu pamo ni bukaba bwakua Efuroni Muhiti, evi iye yali nkendo ya kuziikamo bantu bakue. ");
INSERT INTO tap_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Momo i mwaaziikilue Abrahamu ni mukazi wakue Sara, momo i mwaaziikilue Izaaki ni mukazi wakue Rebeka, kabili momo i munaaziikile mukazi wane Lea. ");
INSERT INTO tap_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Bobo bukaba pamo ni kilibu kilimo, byaasitilue ku bena Heti.” ");
INSERT INTO tap_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo lu-aapwile kulanda na baana bakue, waaleele pa bulita ni kufua. Waakolonghaniiziwe pamo ni bantu bakue. ");
INSERT INTO tap_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu waipoozele pali se ni kubamba kumulila wamukumbatiile. ");
INSERT INTO tap_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yusufu wa-anine babombi bakue bakondapa, basube mubili wakua se na mafuta tekuti ubole. ");
INSERT INTO tap_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Baapwile nsiku 40 bamusuba mafuta akusibola. Bamisri baamulilile nsiku 70. ");
INSERT INTO tap_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nsiku ya kumulila luyaapitile, Yusufu waabaanine babiloolo bakua Farao nangue, “Kine kuti mwangitabizia, namipaapaata muye mumwane Farao nangue, ");
INSERT INTO tap_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tawe lu-aali wasyafua, wanghanine nkaye nkamuziike mu kilibu ki-aateaniizie mu kyalo kya Kanaani. Ni pakako, namilomba mun'mpeele nsambu ya kuya kuziika tawe, mane kabili nkabe kubwela.’” ");
INSERT INTO tap_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao waamwanine evi, “Endo umuziike so nga mu-aakwaniine.” ");
INSERT INTO tap_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kupwako, Yusufu wasela ku Kanaani, waya kumuziika se. Babiloolo bonse bakua likolo, ni babikolue ba Baizraeli pamo ni babikolue ba Bamisri, baile pamo nakue. ");
INSERT INTO tap_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Lupua lwakue lonse, ni bakuluube pamo ni bange bonse ba mu lupua lwakua se baile pamo nakue. Mu Goseni mwaasyele sie baana babo, ni mikooko yabo, ni mbuzi pamo ni nghombe. ");
INSERT INTO tap_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bantu baali baselele mu matyakala ni baali baselele pa punda, baile pamo nakue. Lyaali lyali libumba likata sana. ");
INSERT INTO tap_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Lubaafikile ku Atadi pa nkendo ya kupupiiziapo lya ku kabanga ka Yordani, paapitile musita ukata balimukulila muzowa ukata. Yusufu pamo ni bange baamulilile se nsiku kilooba. ");
INSERT INTO tap_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Bekazi ba mu Kanaani lubaamwene babo bantu balimukulila ku Atadi baalandile evi, “Azo malilo onvwikile, ni malilo akata a Bamisri!” Pa ezio nkendo i kipalipakuutilua Abeli-Misuraimu, ili ku bwala Yordani. ");
INSERT INTO tap_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Baana bakue baamukitiile nga mu-aabaaniine. ");
INSERT INTO tap_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Baamutweme ni kuya kumuziika mu kilibu kya ku Makipela lya ku kabanga ka Mamure, kilibu kyaasitile Abrahamu pamo ni bukaba kuli Efuroni Muhiti, pakuti ibe nkendo ya kuziikamo bantu bakue. ");
INSERT INTO tap_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu lu-aapwile kumuziika se, waabweleele ku Misri ni bakuluube bonse pamo ni bonse baile pamo nakue. ");
INSERT INTO tap_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bakuluube kwa Yusufu lubaamwene nangue sibo wafua, baalandile evi, “Pange Yusufu waakaba kutusuula ni kutukitila kibwelezi kya belia byonse bitwaamukitiile.” ");
INSERT INTO tap_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ni pakako baatumine mpunda kuli Yusufu ya kulanda nangue, “So lu-aali tanaafue waatukonkobeziizie walanda, ");
INSERT INTO tap_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Mukabe kuya kumwana Yusufu nangue, ‘Nakupaapaata weleele bubi bwa bakuluubo bubaakuluviizie.’ Ni pakako, twakupaapaata weleele bubi bwa babombi bakua Leza wakua so.” Mpunda Luyaamufikiile, Yusufu waalilile. ");
INSERT INTO tap_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bakuluube baile kumukontamina balanda nangue, “Ewe, mona fwefue tuli babombi bobe.” ");
INSERT INTO tap_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Inzi Yusufu waabaanine evi, “Tekutiine! Nene nsili na nsambu ya kwalula bintu bitantikile Leza. ");
INSERT INTO tap_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwemue mwantekeele kilie kya kunkitila bintu bibiipile, inzi Leza waatonene kuti mapange akue aweme akitue, mapange a kupususia bantu bengi nga vikili lelo. ");
INSERT INTO tap_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kansi evi tekutiine. Nakaba kumiliisia, mwemue pamo ni baana benu.” Waabakoseleziizie ni kulanda nabo bwino bwino. ");
INSERT INTO tap_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu waatwaliliile kwikala mu Misri pamo ni lupua lwakua se. Yusufu waafwile wali na myaka 110. ");
INSERT INTO tap_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu waikeele nsiku ingi mpaka waamwene kuvyalua kwa baana bena Efraimu ni bena benzikulu. Kabili waamwene ni benzikulu bakua Manase baavyelue na Makiri, ni babo baana waabapokeleele mu lupua lwakue. ");
INSERT INTO tap_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusufu waabaanine bakuluube, “Kufua kwane kwapalama. Inzi kulanda kisinka, Leza waakamisunga, kabili waakamilombola ni kumisezia ku kyalo ki-aalaile Abrahamu, ni Izaaki pamo ni Yakobo.” ");
INSERT INTO tap_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusufu waabalapiizie baana bakua Izraeli wabaana nangue, “Kisinka Leza waakamimona. Ni pakako, pamukaba mwaya, namyana mukatwame ni bikuza byane.” ");
INSERT INTO tap_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusufu waafwile wali na myaka 110. Mubili wakue waasubilue mafuta tekuti ubole, ni pa kyamba, waabiikilue mu lisanduku.");
INSERT INTO tap_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Baana bena Izraeli baingiile mu Misri pamo ni basiibo, kubalua muntu ni lupua lwakue, meena abo ni aza: ");
INSERT INTO tap_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, ni Simeoni, ni Lawi, ni Yuda, ");
INSERT INTO tap_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ni Isakari, ni Zabuloni, ni Benyamina, ");
INSERT INTO tap_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ni Dani, ni Nafutali, ni Gadi, pamo ni Aseri. ");
INSERT INTO tap_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Bantu bonse ba mu luvyalo lwakua Yakobo baali 70. Yusufu umo wa pa baana bena Yakobo waali wasyatangiile mu Misri. ");
INSERT INTO tap_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yusufu ni bakuluube pamo ni balia baizile mu Misri baafwile. ");
INSERT INTO tap_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Inzi Baizraeli lubaali basyavyalana, baali baya bakila kuvula ni kusanduluka, ni bo baali bali babipami. Ni pakako kyalo kya Misri mwaali mwaizuzi sie benkanke. ");
INSERT INTO tap_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Pa kyamba, mu Misri mwaizile likolo wa lenu asyaali wamanine kantu palwakua Yusufu, ni palua bintu bi-aaliwakita. ");
INSERT INTO tap_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ozo likolo wa-anine bantu bakue nangue, “Emwe, mone vyavula Baizraeli, kabili mone vibapamine kukila fwefue. ");
INSERT INTO tap_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kansi tupalile kubombia maano etu onse evi tekuti bakavule, pantu kine twasakukilua na balwani, ni baba Baizraeli bailunda kuli bene, kuti batuuma ni kutufumia mu keno kyalo.” ");
INSERT INTO tap_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ni pakako, baabiikile bakulu ba kubeemia mu buzia na miilo ikata. Baizraeli baamukuuliile Farao mizi ya kuzibamo bilio, Pitomu ni Ramisesi. ");
INSERT INTO tap_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Inzi kukonkana ni vibaali bakila kwemiwa, i vibaali bakila kuvula ni kukumana mu kyalo. Bamisri baunvwile mwezo pa mulandu wa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Baizraeli baabombiiziwe bubi bubi na Bamisri. Bwikazi bwa Baizraeli bwaakilile kubiipa. Baabombiiziwe mu kukandila mukando ni mu kukita mabiliki, ni mu misango yonse ya miilo ya makaba. Mu ezio miilo yaviizie Baizraeli baababombiizie bubi bubi. ");
INSERT INTO tap_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Likolo wa mu Misri waalandile na bakinghombe ba Baebrania, Sifura ni Pua, nangue, ");
INSERT INTO tap_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Musita umulimwavyazia banakazi ba Baebrania, kine mwamona nangue mwanakazi wavyala mwana mwalalume, ipaye ozo mwana. Inzi kine ozo mwanakazi wavyala mwana mwanakazi, tekwipaye ozo mwana.” ");
INSERT INTO tap_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Inzi babo bakinghombe tebaakitile nga mwaalandiile likolo wa ku Misri pantu baali bamunakila Leza. Ni pakako, baana balalume baali basiiwa bakosele. ");
INSERT INTO tap_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kupwako likolo wa ku Misri wakuuta bakinghombe ni kubeepuzia nangue, “Ale mwakitilaki evi? Ni kiki kimulimukusiila baana balalume bakosele?” ");
INSERT INTO tap_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Bakinghombe baamwasukile Farao nangue, “Baba banakazi Baebrania tebali nga banakazi Bamisri, bene bakilile kuluma. Fwefue tulitwasanga basyavyele.” ");
INSERT INTO tap_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ni pakako, bakinghombe baakitiilue biweme na Leza. Baizraeli baakilile kuvula ni kukila kuya balumine. Pantu bakinghombe baali bamunakila Leza, ni ye waabapaalile na kuvyala baana. ");
INSERT INTO tap_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pa mpeleezio Farao wa-anine bantu bakue bonse nangue, “Kubalua mwana mwalalume Muebrania wakaba kuvyalua, mukabe kumupooza mu Mwenzi wa Nile, inzi mwana mwanakazi wakaba kuvyalua mukabe kumusia wakosele.” ");
INSERT INTO tap_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Pa ozo musita kwaali muntu umo wa mu mukowa wakua Lawi waile kuupa mukazyana wa mu ozo wenka mukowa. ");
INSERT INTO tap_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ozo mwanakazi waimitile ni kuvyala mwana mwalalume. Lu-aamwene vyaali vyaweme ozo mwana, waamufiikile myezi itatu. ");
INSERT INTO tap_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Inzi lu-aamwene nangue takili na musango wa kumufiika musita waleepele, waamusukiile mpuuto ya masanza ni kusingako kabulimbu. Waabiikile mwana mukati ni kuya ku-ibiika mu matete mumbali Mwenzi wa Nile. ");
INSERT INTO tap_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nkaziize kwa ozo mwana waali waimeene lwa kule wamweneneene kilikumukitikila mwana. ");
INSERT INTO tap_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mukazyana mwina likolo waile pamo ni babombi bakue ku mwenzi kuti aye asambe. Babombi bakue lubaali baenda mumbali mwenzi, mukazyana mwina likolo waamwene mpuuto mu matete. Waatumine mubombi wakue kuti aye aitwame ni kumuleetela. ");
INSERT INTO tap_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mukazyana mwina likolo lu-aatupukwile mpuuto ni kumonamo mwana mwalalume walimukulila, waamunvwiliile nkumbu. Mukazyana mwina likolo waalandile nangue, “Ozu mwana apalile kuba mwana mwina Baebrania.” ");
INSERT INTO tap_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nkaziize kwa ozo mwana waamwipuziizie mwina Farao nangue, “Kuti naya kukukebela mwanakazi Muebrania wakuti aye wakonsiizia ozu mwana?” ");
INSERT INTO tap_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mukazyana mwina likolo waamwasukile, “Endo umukebe.” Nkaziize kwa ozo mwana waile kumutwama nghina wa ozo mwana. ");
INSERT INTO tap_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwina likolo waamwanine nghina wa ozo mwana nangue, “Twama mwana ozu uye wanghonsiizia, nakaba kuya nakusazia nsazio yobe.” Kupwako, nghina wamutwama ozo mwana ni kubamba kumonsia. ");
INSERT INTO tap_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mwana lu-aakulile, nghina wa ozo mwana waamubweziizie kuli mukazyana mwina Farao, ni ye waaamwalwile nga mwana wakue. Mukazyana mwina Farao waalandile evi, “Namufumia mu menda,” ni pakako ndikumwinika Musa. ");
INSERT INTO tap_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Pa kyamba kya myaka, Musa wasyakulile, waile kupempula Baebrania nakue ni kumona vibaali babombiiwa kibombebombe. Mu kupempula kwakue, waamwene Muebrania nakue walimukuumua na Mumisri. ");
INSERT INTO tap_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa lu-aakentele koku ni koku kuti asininkizie nangue tamwenue na muntu, waamwipaile ozo Mumisri ni kumufiika mu musenga. ");
INSERT INTO tap_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Busiku bwaakonkelepo Musa lu-aile kupempula paakale Baebrania nakue, waamwene Baebrania babili balalume balimukulua. Musa waamwanine olia waali waluviizie nangue, “Ewe, ulimukuuminaki Muebrania nobe?” ");
INSERT INTO tap_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Olia waali waluviizie waalandile evi, “Nani wakikubiika kuba kateeka ni mupinguzi wetu? Ulimukukeba kungipaya nga viwakiipaya olia Mumisri lukeele?” Ni pakako Musa waatiinine walanda nangue, “Kisinka mulandu unkitile umanikile.” ");
INSERT INTO tap_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Farao lu-aunvwile nangue Musa wakiipaya Mumisri, waali wasyakambila kumwipaya Musa. Inzi Musa waamubutukile Farao ni kuya mu kyalo kya Midiani. Lu-aafikile ku kekio kyalo, waile kwikala mumbali kiina kya menda. Kwaali banakazi kilooba bena kitambua wa ku Midiani, babo baile ku kiina kya menda ku kutapa menda a kubiika mu mukondo kuti banwinsie mikooko yakua sibo. ");
INSERT INTO tap_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kwaali basungi bamo ba mikooko baizile kubakumba, inzi Musa waabasakiile ni kubakwasia kunwinsia mikooko yabo. ");
INSERT INTO tap_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lubaabweleele kuli sibo Yetoro, sibo waabepuziizie nangue, “Ale lelo kimusikokweleele ni kiki?” ");
INSERT INTO tap_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ni bo baamwasukile evi, “Basungi lubaizanga kutukumba, Mumisri umo waizanga kutusakila. Kabili watutapilanga menda etu ni menda a kunwinsia mikooko yetu.” ");
INSERT INTO tap_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Sibo Yetoro waabeepuziizie baana bakue banakazi nangue, “Ale ozo muntu ali pi? Mwamusiilangaki? Endo mumukuute eze tulie nakue.” ");
INSERT INTO tap_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa waawamiinue kwikala koko pamo ni Yetoro. Yetoro waufiizie mwana wakue mwanakazi kuli Musa. Ozo mwanakazi waali wakuutua Sipora. ");
INSERT INTO tap_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipora lu-aavyele mwana mwalalume, Musa waamwinikile Gershomu walimukulanda nangue, “Nakyaluka mweni mu kyalo kya bweni.” ");
INSERT INTO tap_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Pa kyamba kya nsiku ingi, likolo wa ku Misri waafwile. Baizraeli baatwaliliile kulila na bulanda bwa mu buzia ni kuya baitendooka mpaka ni Leza waunvua malilo abo. ");
INSERT INTO tap_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Leza lu-aunvwile malilo abo, waalangakeene kipingo kyakue ki-aapingheene na Abrahamu, ni Izaaki pamo ni Yakobo. ");
INSERT INTO tap_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Leza waamwene Baizraeli vibaali baema. Ni pakako, waabonvwiliile nkumbu. ");
INSERT INTO tap_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Busiku bumo Musa lu-aali wasunga mikooko yakua sevyala Yetoro, kitambua wa ku Midiani, Musa waalombwele mikooko ni kuitwala lya ku mboosi ya kaseeba, waya kufika ku Horebu lupili lwakua Leza. ");
INSERT INTO tap_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Koko i kwaamumonekeele malaika wakua Yawe wali nga libeebe lya mulilo mu kavuule. Musa waakentele ni kupapa kumona kavuule kalimukuleema mulilo inzi tekuuba kazia. ");
INSERT INTO tap_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ni pakako, Musa waalangakeene walanda nangue, “Ale kaka kavuule kikasilimukuziila ni kiki! Kansi n'mpalamenke n'mone keki kintu kya kupapia.” ");
INSERT INTO tap_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yawe lu-aamwene Musa waya wapalama kuti akentesie, lizui lyakua Yawe lyaunvwikile mu kavuule lyakuuta, “Musa! Musa!” Musa waiteebe nangue, “Ne ono pano.” ");
INSERT INTO tap_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yawe waamwanine nangue, “Tekupalama pano. Vuula nkwabilo yobe, pantu wimeene pa kifuka kizuuke.” ");
INSERT INTO tap_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Kabili waalandile evi, “Nene ndi Leza wakua so, Leza wakua Abrahamu, wakua Izaaki, ni wakua Yakobo.” Kupwako, Musa waikupa pa menso akue pantu waatiinine kumukenta Leza. ");
INSERT INTO tap_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yawe waalandile nangue, “Namona lyemo lya bantu bane bali mu Misri, kabili naunvua malilo pa mulandu wa kwemiiwa na bakulu ba buzia. Kisinka nabonvwila nkumbu. ");
INSERT INTO tap_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ni pakako, nakooka kuti n'mbapususie mu maboko a Bamisri, n'mbafumie mu kekio kyalo, n'mbasezie ni kubatwala mu kyalo kiweme kyatanine, kyalo kiizuzimo mabeele ni kapelo, momo mwikeele Bakanaani, ni Bahiti, ni Ba-amori, ni Baperizi, ni Bahivi, pamo ni Bayebusi. ");
INSERT INTO tap_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Kisinka naunvua malilo a Baizraeli, kabili namona lyemo libeemiiziwe na Bamisri. ");
INSERT INTO tap_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ni pakako, nakutuma kuli Farao kuti uye ufumie bantu bane, Baizraeli, kufuma mu Misri.” ");
INSERT INTO tap_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Inzi Musa waamukanzile Leza waamwana, “Kubako nene ndi ni wakuti aye kuli Farao ni kufumia Baizraeli mu Misri?” ");
INSERT INTO tap_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Leza waamwanine nangue, “Kisinka ndikuya nali pamo nobe. Kalangi kawakaba kusininkiziiziako nangue nkutumine ni kaka: Pa kyamba kya kufumia bantu mu Misri, mwakaba kun'mpupila pa lono lupili.” ");
INSERT INTO tap_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Inzi Musa waamukanzile Leza nangue, “Ale kine nkabe kuya ku Baizraeli ni kubaana nangue, ‘Leza wa babikolue benu i wantuma kuli mwemue,’ Ni bo kine bakangipuzie nangue, ‘Ozo Leza Liina lyakue nani?’ Nakaba kubaanaki?” ");
INSERT INTO tap_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Leza waamwasukile Musa nangue, “Ndi olia Ndi. Evi i vyakuti uye ubaane Baizraeli nangue, ‘Olia aliwakuutua NDI i antumine kuli mwemue.’” ");
INSERT INTO tap_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kabili Leza waamwanine Musa nangue, “Baane Baizraeli nangue, ‘Yawe Leza wa babikolue benu, Leza wakua Abrahamu, Leza wakua Izaaki, ni Leza wakua Yakobo, i-antumine kuli mwemue.’ Leli i Liina lyane muyayaya. Ni evio i vinaakaba nalangulukua na nvyalo yonse. ");
INSERT INTO tap_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Endo ukolonghanie masiiko a Baizraeli ni kubaana nangue, ‘Yawe Leza wa babikolue benu, Leza wakua Abrahamu, wakua Izaaki, ni wakua Yakobo, wakin'monekela wanghana nangue kisinka amikentele ni kumona vimulimukwemiwa mu Misri. ");
INSERT INTO tap_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Namilaya nangue naakamifumia mu lyemo lya mu Misri nkamisezie ni kumitwala mu kyalo kya Bakanaani, ni Bahiti, ni Ba-amori, ni Baperizi, ni Bahivi, pamo ni Bayebusi, kyalo kiizuzimo mabeele ni kapelo.’ ");
INSERT INTO tap_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Masiiko a Baizraeli akaba kukunvua. Wewe pamo ni masiiko a Baizraeli mupalile kuya kuli likolo wa ku Misri ni kumwana nangue, ‘Yawe Leza wa Baebrania waakitumonekela. Kansi twakulomba utuleke tuye mu kaseeba lwendo lwa nsiku itatu kuti tuye twelele ngelelo kuli Yawe Leza wetu.’ ");
INSERT INTO tap_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Inzi n'manine nangue likolo wa ku Misri takaba kumilekeela kuya, anzia mukakita syani, inga sie kine wapatikiziiwa na kuboko kwa maka. ");
INSERT INTO tap_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Anzia kikaba evio, nakaba kukanda Bamisri na bipezia maano binakaba kukita pali bene, mane pa kyamba akabe kumilekeela kuya. ");
INSERT INTO tap_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nakaba kulengia Baizraeli kutonua na Bamisri, ni musita wa kuya kwenu, temukaya tonte. ");
INSERT INTO tap_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kubalua mwanakazi Muizraeli waakamulomba mwanakazi Mumisri u-apalameene nakue ni mweni wa mu nghanda yakue kuti amupeeleko bifwanizio bya mutofue, ni bya oro, ni ngubo, bebio bimwaakabavwika baana benu balalume ni banakazi, ni mwe mwaakatwama bunonsi bwa Bamisri.” ");
INSERT INTO tap_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Inzi Musa waamukanzile Leza paakale walanda nangue, “Ale kyaakaba syani kine masiiko a Baizraeli aya kukaana kungitabila ao kunghunvua ni kunghana nangue Yawe takikumonekela?” ");
INSERT INTO tap_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yawe waamwipuziizie nangue, “Ukweteki ku minue yobe?” Wa-asukile evi, “Nkwete kabango.” ");
INSERT INTO tap_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Inzi Yawe waamwanine nangue, “Pooza kabango pansi.” Musa lu-aapoozele pansi, kabango ka-alukile kizoka, ni Musa waiseeluka. ");
INSERT INTO tap_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kupwako Yawe wamwana Musa nangue, “Ale olola kuboko kobe ukwate ku mukila.” Musa waolola kuboko kwakue, wakikwata, ni kyo kya-aluka kabango paakale mu minue yakue. ");
INSERT INTO tap_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Leza waamwanine Musa nangue, “Kaka kalangi i kakuti ukakite pakuti bakabe kwitabila nangue ne Yawe Leza wa babikolue babo, Leza wakua Abrahamu, Leza wakua Izaaki, ni Leza wakua Yakobo nakikumonekela.” ");
INSERT INTO tap_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kabili Yawe waamwanine Musa nangue, “Ale biika kuboko kobe mu nkanzu lya pa nkulo yobe.” Musa waabiikile kuboko kwakue mu nkanzu lya pa nkulo yakue. Lu-aafumiiziemo, kuboko kwa-alukile ni tembue ni kusweta nga kibue. ");
INSERT INTO tap_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yawe waamwanine nangue, “Kabili biika kuboko kobe mu nkanzu lya pa nkulo yobe.” Ni ye waabiikile kuboko kwakue mu nkanzu lya pa nkulo yakue. Lu-aafumiiziemo, kuboko kwa-alukile nga vikwaali pa mambo. ");
INSERT INTO tap_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yawe waamwanine nangue, “Kine tebakaba kukwitabila ao kukunvua pa kapapo ka mambo, bakaba kwitabila pa kapapo ka bubili. ");
INSERT INTO tap_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kine tebakaba kwitabila totu tupapo tubili, ao kukunvua, wakaba kutapula menda mu Mwenzi wa Nile ni kwitila pansi, ni menda awakaba kutapula mu mwenzi akaba kwaluka mulopa.” ");
INSERT INTO tap_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa waamupaapaatile Yawe walanda, “We Yawe, nene nsimanine kulanda bwino bwino pantu umanine kisinka nangue kutula musita uwakibamba kulanda na nene, ndinameemeetela.” ");
INSERT INTO tap_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yawe waamwipuziizie Musa nangue, “Eba, nani waalengele kanua ka muntu? Nani aliwalengia muntu kulanda ao kuba kameme? Nani aliwalengia muntu kunvua ao kuba mpokoto? Nani aliwalengia muntu kumona ao kuba mpofu? Kubako te nene Yawe? ");
INSERT INTO tap_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ale endo waya, ndikuba nobe mu kulanda, ni kukusambilizia viupalile kulanda.” ");
INSERT INTO tap_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Inzi kabili Musa waamupaapaatile Yawe walanda, “We Yawe nakupaapaata utumeko sie unge.” ");
INSERT INTO tap_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Yawe waamufiitiilue Musa walanda nangue, “Eba, kubako wewe teuli na mukuluubo Haruni wa mu mukowa wa Balawi? N'manine nangue wene kuti walanda bwino. Ni evi vyenka alimukwiza kusaakaana nobe, musita u-alikukumona alikuwaminua. ");
INSERT INTO tap_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Wewe ulikuyawalanda nakue ni kubiika twebo mu kanua kakue. Mwe babili nakaba kumikwasia kulanda, nene nakaba kumisambilizia kimupalile kukita. ");
INSERT INTO tap_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Haruni i wakaba kuya wakulandila ku Baizraeli pantu i wakaba kuya wali kanua kobe. Wewe wakaba kuya wali nga Leza kuli wene mu kumubwila bi-upalile kulanda. ");
INSERT INTO tap_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Twama kaka kabango mu minue yobe evi uye wakabombia kukitilako toto tupapo.” ");
INSERT INTO tap_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa i lu-aabweleele kuli sevyala Yetoro ni kumwana nangue, “Nakupaapaata un'mpeele nsambu ya kubwelela ku lupua lwane luli mu Misri, pantu nsimanine kine bakikosele.” Yetoro waamwasukile evi, “Kili sie bwino, ale iilapo bwino.” ");
INSERT INTO tap_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa lu-aali wakili mu kyalo kya Midiani, Yawe waamwanine nangue, “Bwelela ku Misri pantu balia baali baumiine kukwipaya bakifua.” ");
INSERT INTO tap_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kupwako, Musa wamutwama mukazi ni baana bakue balalume, wabasezia pa punda ni kubwelela ku kyalo kya Misri, watwama ni kabango kabiikiluemo buvinde na Leza mu minue yakue. ");
INSERT INTO tap_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yawe waamwanine Musa nangue, “Paukaba kubwela ku Misri, ukabe kuya kukita tupapo tonse ntanzi yakua Farao na buvinde bunakikupeela. Inzi nakaba kukosia mutima wakue, evi tekuti akabe kulekeela Baizraeli kuya. ");
INSERT INTO tap_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kabili ukabe kumwana Farao nangue ne Yawe nalanda evi, ‘Izraeli i mwana wane mwalalune, kabili i libeli wane. ");
INSERT INTO tap_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nakwana umuleke mwana wane kuti aye an'mpupe. Kine wamukaanina kuya, nakaba kwipaya mwana mwalalume, libeli obe.’” ");
INSERT INTO tap_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Musa ni lupua lwakue lubaali bakili mu nzila balimukuya ku Misri, baafikile pa nghanda ya bweni pakuti balaale. Musita wa busiku, Yawe waile pali Musa wakebele kumwipaya. ");
INSERT INTO tap_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Sipora muka Musa waabuulile libue litwile, wamuteeta yando mwana wakue mwalalume ni kupooza mpapa ku makasa akua Musa walimukulanda evi, “Kisinka wewe uli syabuinga wa mulopa kuli nene.” Ni pakako, Yawe taamukitiile Musa kintu kibiipile. Sipora waalandile evi, “Wewe uli syabuinga wa mulopa pa mulandu wa kuteeta yando.” ");
INSERT INTO tap_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yawe waamwanine Haruni nangue, “Endo usaakaane ni Musa mu kaseeba.” Haruni waile kusaakaana nakue ku lupili lwakua Leza ni kumukumbatila. ");
INSERT INTO tap_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa waamwanine Haruni twebo tonse tu-aatuminue na Yawe kuti alande, kabili waamwanine tupapo tu-aali wa-aninue kukita. ");
INSERT INTO tap_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kupwako, Musa ni Haruni baya mu Misri, bakolonghania masiiko onse a Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haruni waabaanine twebo tonse twakua Yawe twa-aninue Musa, waakitile tupapo ntanzi ya bantu, ");
INSERT INTO tap_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ni bo baazumiine. Kabili lubaunvwile nangue Yawe waali wapoozele maano ku Baizraeli ni kumona lyemo lyabo, baakontamikile mitue yabo ni kumupupa. ");
INSERT INTO tap_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Pa kyamba kya kulanda ni masiiko a Baizraeli, Musa ni Haruni baile kumwana Farao nangue, “Yawe Leza wa Baizraeli walanda evi, ‘Baleke bantu bane baye bankitile nsikunkulu mu kaseeba.’” ");
INSERT INTO tap_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao waalandile nangue, “Eba, ozo Yawe nani wakuti nghunvue lizui lyakue ni kumwitabizia kuti ndekeele Baizraeli baye? Ozo Yawe nsimumanine, kabili nsivinda kwitabizia kulekeela Baizraeli baye.” ");
INSERT INTO tap_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa ni Haruni baalandile evi, “Leza wa Baebrania wakitwana twize kuli wewe. Ale twitabizie tuye lwendo lwa nsiku itatu mu kaseeba, evi tuye tumwelele Yawe Leza wetu ngelelo akeeza kutwipaya na kimina kya malwele ao na bului.” ");
INSERT INTO tap_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Inzi likolo wa ku Misri wa-anine Musa ni Haruni nangue, “Ni kiki kimwakeba kufumiizia bantu ku miilo yabo? Bwelele ku miilo yenu.” ");
INSERT INTO tap_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kabili Farao waalandile nangue, “Baba bantu bavula kukila Bamisri, ale kimulimwakebela baba bantu batuuzie ni kiki?” ");
INSERT INTO tap_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Bobo bwenka busiku Farao waakuutile bakulu ba Bamisri pamo ni nombozi ya bazia wabaana nangue, ");
INSERT INTO tap_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kutula lelo tekuli kupeela bantu bikusi bya kukitilako mabiliki nga vimulimwakita. Baleke baye baikebele bo bene. ");
INSERT INTO tap_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Inzi bakinkizie sie kukita mabiliki ni kukumania mpendua yenka elia pasili kukeefiapo ata limo, pantu baba bantu ni bananghani. Ni pakako i kibalimukunghemiizia balimukulanda nangue, ‘Twitabizie tuye tumwelele Leza wetu ngelelo.’ ");
INSERT INTO tap_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kizie kupeela baba bantu miilo ikolele, evi basulwile ni kulekela kutwilizia twebo twa bufi.” ");
INSERT INTO tap_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kupwako, bakulu ba Bamisri pamo ni nombozi ya bazia babaana Baizraeli nangue, “Farao walanda nangue nsikiya namipeela bikusi. ");
INSERT INTO tap_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Endo mwaye mwikebele mwe bene koko kumulikuya kubisangila. Inzi mupalile kukita mpendua ya mabiliki nga mumulimwakitila lyonse.” ");
INSERT INTO tap_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ni pakako, bantu baasalagheene mu Misri mu kukeba bikusi bya kukitilako mabiliki. ");
INSERT INTO tap_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Banombozi ba bazia baabakonkobeziizie babaana nangue, “Fikilizie mpendua ya mabiliki nga vimwaali mwakita kubalua busiku lutwaali twamipeela bikusi.” ");
INSERT INTO tap_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Bakulu ba Bamisri baatendekele kuuma banombozi ba bazia ba Baizraeli koku balimukubeepuzia nangue, “Ni kiki kyakilengia lukeele ni lelo tekuti mukumanie mpendua ya mabiliki nga vimwakiba mwabomba ku mambo?” ");
INSERT INTO tap_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ni pakako, banombozi ba bazia ba Baizraeli baile kumupaapaata Farao balanda nangue, “Wakitilaki evi ku fwe babombi bobe? ");
INSERT INTO tap_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Fwefue tetukilimukupeelua bikusi, inzi tulimukwanua tukumanie mpendua ya mabiliki ni kuya twaumua. Keki te kilubo kyetu, inzi ni kilubo kya bantu bobe.” ");
INSERT INTO tap_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Inzi Farao waalandile nangue, “Mwe bananghani! Kisinka muli bananghani, kabili i kimulimukulandila nangue, ‘Twitabizie tuye tumwelele Yawe ngelelo.’ ");
INSERT INTO tap_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ni evi vyenka bwele muye mubombe! Tekuli muntu alikumipeela bikusi, inzi mupalile mukumanie mpendua yenka elia ya mabiliki amulimwakita kubalua busiku.” ");
INSERT INTO tap_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kupwako, banombozi ba bazia ba Baizraeli baisanga kuba mu bwavia bukata pantu baabaanine nangue, “Tekuli kutuuzia ata kaniini kine temunakumanienke mpendua ya mabiliki amulimwakita kubalua busiku.” ");
INSERT INTO tap_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Lubaafumine ku kipango kyakua Farao, baile kusaakaana ni Musa pamo ni Haruni baali babapembeele panze. ");
INSERT INTO tap_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kupwako, bamwana Musa ni Haruni nangue, “Yawe amipingule ni kumikanda, pantu mwakitulengia kukendua na Farao ni babombi bakue, kabili mwakilengia batendeke kutwipaya.” ");
INSERT INTO tap_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa waile paakale kuli Yawe ni kumwana nangue, “We Yawe, wakitilaki bobu bwavia pa baba bantu bobe? Ale wakintuminaki kono? ");
INSERT INTO tap_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Pantu kutula busiku bunakingila kwa Farao ni kumwana biwanghanine, kuleetele bwavia bukata ku bantu bobe, kabili teukitilepo kantu ka kulanga nangue waakabapususia!” ");
INSERT INTO tap_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Inzi Yawe waamwanine Musa nangue, “Wewe wakaba kumona vinakaba kumukitila Farao, pantu nakaba kumupatikizia na maka ane kuti akabe kubetabizia kuya. Kisinka Farao wakaba kubakumba mu kyalo kyakue.” ");
INSERT INTO tap_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kabili Leza waamwanine Musa nangue, “Nene ndi Yawe. ");
INSERT INTO tap_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Naifyulile kuli Abrahamu, kuli Izaaki ni Yakobo, nga Leza wa Maka onse, inzi nsyaifyulile mu Liina lya bu Yawe kuli bene. ");
INSERT INTO tap_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Kabili naapingheene nabo ni kubalaya nangue naakabapeela kyalo kya Kanaani, momo mu baali baikeele nga baeni. ");
INSERT INTO tap_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nene nakyunvua malilo a Baizraeli kukonkana ni vibalimukupatikiziiwa na Bamisri kubomba miilo ya buzia. Ni pakako, nakilangakana kipingo kinaapingheene nabo. ");
INSERT INTO tap_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kansi ana Baizraeli nangue, ‘Nene ndi Yawe, nakaba kumifumia mu mutembo umutwikilue na Bamisri. Nakaba kumifumia mu buzia bubamiteekele, nakaba kubakanda bubi bubi ni kumilubula na maka ane. ");
INSERT INTO tap_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nakaba kumyalula kuba bantu bane. Nene naakaba Leza wenu, kabili mwaakamana nangue nene i Yawe Leza wenu waamifumiizie mu buzia ku Misri. ");
INSERT INTO tap_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nene naakamitwala mu kyalo kinaamulaile Abrahamu, ni Izaaki pamo ni Yakobo. Keki kyalo naakamipeela kuti kikabe kyenu, pantu nene ndi Yawe.’” ");
INSERT INTO tap_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ni pakako, Musa waabaanine Baizraeli twebo twaalandile Yawe, inzi bene tebaamutwiliziizie pa mulandu wa mutima misa, ni pa mulandu wa buzia bubi bubaali bateekelue. ");
INSERT INTO tap_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yawe i pakumwana Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Endo umwane Farao likolo wa mu Misri abapeele Baizraeli nsambu ya kufuma mu kyalo kyakue.” ");
INSERT INTO tap_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Inzi Musa waamwanine Yawe nangue, “Bantu bane tebalimukunghunvua ata kaniini. Ale Farao kuti wanghunvua syani ne aliwameemeetela?” ");
INSERT INTO tap_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yawe i pakumwana Musa ni Haruni palua Baizraeli nangue, “Mwane Farao likolo wa ku Misri afumie Baizraeli mu Misri.” ");
INSERT INTO tap_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Babikolue ba mu mikowa ya Baizraeli meena abo ni aza: Bena Rubeni, libeli wakua Izraeli, meena abo ni aza: Hanoki, ni Palu, ni Hesroni pamo ni Karmi. Baba i ba mu lupua lwakua Rubeni. ");
INSERT INTO tap_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Bena Simeoni meena abo ni aza: Yemueli, ni Yamini, ni Ohadu, ni Yakini, ni Zohari pamo ni Sauli mwina mwanakazi Mukanaani. Baba i ba mu lupua lwakua Simeoni. ");
INSERT INTO tap_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Bena Lawi ni baba: Gershoni, ni Kohati pamo ni Merari. Lawi waikeele pa kyalo myaka 137. ");
INSERT INTO tap_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Bena Gershoni meena abo ni aza: Libni ni Simei, kukonkana ni mikowa yabo. ");
INSERT INTO tap_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Bena Kohati meena abo ni aza: Amramu, ni Izihari, ni Hebroni pamo ni Uzieli. Kohati waikeele pa kyalo myaka 133. ");
INSERT INTO tap_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Bena Merari meena abo ni aza: Mali ni Musi. Baba i babikolue ba mu lupua lwakua Lawi. ");
INSERT INTO tap_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramu waupile nghina senge Yokebedi, ozo waamuvyaliile Haruni ni Musa. Amramu waikeele pa kyalo myaka 137. ");
INSERT INTO tap_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Bena Izihari meena abo ni aza: Kora, ni Nefegi pamo ni Sikiri. ");
INSERT INTO tap_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Bena Uzieli meena abo ni aza: Misaeli, ni Elizafani pamo ni Sitiri. ");
INSERT INTO tap_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruni waupile Eliseba mwina Abinadabu, nkaziize kwa Nasoni. Eliseba waavyele Nadabu, ni Abihu, ni Eleazari pamo ni Itamari. ");
INSERT INTO tap_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Bena Kora meena abo ni aza: Asiri, ni Elkana, pamo ni Abiasafu. Baba i babikolue ba mu lupua lwakua Kora. ");
INSERT INTO tap_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazari mwina Haruni waupile mwanakazi umo wa pa baana bakazyana bena Putieli, ni ye waavyele mwana mwalalume liina lyakue Finehasi. Baba bonse i baali babikolue ba mu lupua lwa Balawi. ");
INSERT INTO tap_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Haruni ni Musa i ba-aninue na Yawe nangue, “Fumie Baizraeli mu kyalo kya Misri bali mu mabumba mabumba.” ");
INSERT INTO tap_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Baba babili, Musa ni Haruni, i baali balanda ni Farao likolo wa ku Misri palua kufumia Baizraeli mu Misri. ");
INSERT INTO tap_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mu ezio nsiku Yawe lu-aalandile kuli Musa mu kyalo kya Misri, ");
INSERT INTO tap_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","waamwanine nangue, “Nene ndi Yawe. Endo umwane Farao likolo wa ku Misri byonse bindikukwana.” ");
INSERT INTO tap_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Inzi Musa waamukanzile Yawe nangue, “Nene nsivinda kukita evio pantu ndinameemeetela. Ale ni kiki kilikulengia Farao kuti antwilizie?” ");
INSERT INTO tap_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yawe i lu-aamwanine Musa nangue, “Unvua twebo tundikukwana, nene nakubiika kuba nga Leza ntanzi yakua Farao, ni Haruni alikuba kabika obe. ");
INSERT INTO tap_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ulikumwana Haruni byonse bindikukwana, ni ye alikumwana Farao etabizie Baizraeli bafume mu kyalo kyakue. ");
INSERT INTO tap_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Inzi nakaba kufinia mutima wakua Farao, kabili anzia kine nakaba kukila kukita tupapo twane mu kyalo kya Misri, Farao takaba kumyunvua. Ni pakako, nakaba kulanga maka ane pa kyalo kya Misri ni kufumia bantu bane, Baizraeli, mu Misri na tupapo tukata. ");
INSERT INTO tap_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Musita unakaba kulangisia tupapo twane pa kufumia Baizraeli, Bamisri i pa bakaba kumana nangue nene ndi Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Kupwako Musa ni Haruni bakita nga muba-aniinue na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Pa ozo musita ubaalandile ni Farao, Musa waali na myaka 80, ni Haruni waali na myaka 83. ");
INSERT INTO tap_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kabili Yawe wa-anine Musa ni Haruni nangue, ");
INSERT INTO tap_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kine Farao akabe kumyana kukita kapapo ka kusininkizia, ukabe kumwana Haruni akabe kubuula kabango kakue ni kukapooza pansi ntanzi yakua Farao, ni ko kakaba kwaluka kizoka.” ");
INSERT INTO tap_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa ni Haruni i lubaingiile kuli Farao ni kukita nga muba-aniinue na Yawe. Haruni waapoozele kabango kakue pansi ntanzi yakua Farao, ni ntanzi ya babombi bakue, ni ko ka-alukile kizoka. ");
INSERT INTO tap_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kupwako, penka papo Farao wakuuta kale bantu bakue ba mulangue ni bandozi pamo ni banghanga ba mu Misri beze bengile. Ni bo baakitile evio vyenka mu bunghanga bwabo. ");
INSERT INTO tap_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bonse baapoozele tubango twabo pansi, ni to twa-alukile bizoka. Inzi kabango kakua Haruni kaatelekele tubango twabo. ");
INSERT INTO tap_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Anzia kyaali evio, Farao waali watwaliliile sie kufinia mutima, ni ye taabatwiliziizie nga mwaalandiile Yawe. ");
INSERT INTO tap_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kupwako Yawe wamwana Musa nangue, “Mutima wakua Farao ufinine, ni ye wakaana kwitabizia Baizraeli kuti baye. ");
INSERT INTO tap_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kansi lukeele lukeelekeele, Farao pa-akaba kuya waya ku menda, ukabe kuya kwimana kumbali Mwenzi wa Nile kuti ukabe kusaakaana nakue watweme ni kabango mu minue yobe, kabango kalia kakyaluka kizoka. ");
INSERT INTO tap_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mane ukabe kumwana nangue, ‘Yawe Leza wa Baebrania wakintuma kuli wewe kuti ubaleke Baizraeli baye ban'mpupe mu kaseeba. Inzi ni lenu kumo teunaunvue. ");
INSERT INTO tap_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ni pakako, ulikumwinika nangue Yawe nani. Ndikuuma pa menda a mwenzi na kaka kabango, ni menda onse alikwaluka mulopa. ");
INSERT INTO tap_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Masabi ali mu mwenzi alikufua, mwenzi ulikununka, ni Bamisri balikwandua kumina menda a mwenzi.’” ");
INSERT INTO tap_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kabili Yawe waamwanine Musa nangue, “Mwane Haruni nangue, ‘Buula kabango kobe ni kuolwela kuboko pa menda a mu Misri: Pa myenzi yabo, ni pa twezi twabo, ni pa biina byabo bya menda, ni pa biziba byabo byonse bya menda, ni menda alikwaluka mulopa. Ozo mulopa wakaba kuya wali mu kyalo kyonse kya Misri, mu bibaya ni mu ngeso.’” ");
INSERT INTO tap_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ni pakako, Musa ni Haruni baakitile nga muba-aniinue na Yawe. Haruni waalendwile kabango ni kuuma pa menda a mwenzi ntanzi yakua Farao ni ntanzi ya babombi bakue. Menda onse a mwenzi a-alukile mulopa. ");
INSERT INTO tap_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Masabi aali mu mwenzi aafwile. Mwenzi waanunkile, ni Bamisri ba-andilue kumina menda a mwenzi. Mulopa waakumeene mu kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Inzi banghanga ba mu Misri ni bo baakitile evio vyenka mu bunghanga bwabo. Farao waatwaliliile kufinia mutima, kabili taamutwiliziizie Musa ni Haruni nga mwaalandiile Yawe. ");
INSERT INTO tap_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farao waabweleele ku nghanda yakue pasili kupoozako maano ku bintu byaakitikile. ");
INSERT INTO tap_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bamisri bonse i lubaimbile biina bya menda mumbali Mwenzi wa Nile evi bapate menda a kumina pantu ba-andilue kumina menda a ozo mwenzi. ");
INSERT INTO tap_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Paapitile nsiku kilooba menda a mwenzi ainoonekele na kekio kimina. ");
INSERT INTO tap_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kabili Yawe waamwanine Musa nangue, “Endo umwane Farao nangue Yawe walanda evi, ‘Baleke bantu bane baye, evi bakabe kun'mpupa. ");
INSERT INTO tap_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kine ulikukaana, ndikukanda kyalo kyobe kyonse na kwizuziamo byula. ");
INSERT INTO tap_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mu Mwenzi wa Nile mulikwizula byula, ni byo bilikwingila mu nghanda yobe, ni mu muputule mu-uliwalaala, ni kusela pa bulita bobe, bilikwingila mu nghanda ya babombi bobe, ni mu kubalua nghanda ya bantu bobe, ni mu bipe biuliwa-apikilamo mikate, ni mu bipe byobe bya kukandilamo bunga. ");
INSERT INTO tap_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Byula bilikusela pali wewe, ni pa bantu bobe, pamo ni pa babombi bobe bonse.’” ");
INSERT INTO tap_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yawe i lu-aamwanine Musa amwane Haruni nangue, “Olola kuboko kobe ni kabango kobe pa myenzi ni pa twezi, ni pa biziba, evi byula bifume ni kukumana pa kyalo kya Misri.” ");
INSERT INTO tap_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kupwako, Haruni waolwela kuboko kwakue pa menda onse, ni byula byafuma ni kukumana pa kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Inzi banghanga ni bo mu bunghanga bwabo baakitile evio vyenka. Baaleetele byula pa kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pa kyamba, Farao waakuutile Musa ni Haruni ni kupaapaata walanda, “Nandileko kuli Yawe afumie byula pali nene ni pa bantu bane, ni ne ndikubaleka Baizraeli baye, evi bakabe kumwelela Yawe ngelelo.” ");
INSERT INTO tap_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa waamwasukile Farao nangue, “Landa we mwine musita un'mpalile kukupepela wewe ni babombi bobe, ni bantu bobe, evi byula biloviiwe mu nghanda yenu, bisyalilile sie mu mwenzi!” ");
INSERT INTO tap_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao waamwanine nangue, “Lukeele.” Musa wa-asukile evi, “Kibe nga muwalandila, evi uye wamanine nangue tekuli unge ali nga Yawe Leza wetu. ");
INSERT INTO tap_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Byula byakaba kufuma pali wewe, ni mu nghanda yenu, ni pa babombi bobe, ni pa bantu bobe. Inzi byakaba kusyalilila sie mu Mwenzi wa Nile.” ");
INSERT INTO tap_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kupwako, Musa ni Haruni bafuma ku kipango kyakua Farao, ni Musa wamulilila Yawe amupususie Farao pa mulandu wa kimina kya byula. ");
INSERT INTO tap_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yawe waakitile mwaapepeele Musa. Waipaile byula byaali mu nghanda ni mu misolo pamo ni mu makaba. ");
INSERT INTO tap_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Bamisri baatuulikile byula milui milui, ni kyalo kyonse kyaanunkile. ");
INSERT INTO tap_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Inzi Farao lu-aamwene nangue bapeemako, kabili waafiniizie mutima wakue ni kukaana kutwilizia kuli Musa ni Haruni nga mwaalandiile Yawe. ");
INSERT INTO tap_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yawe i lu-aamwanine Musa nangue, “Mwane Haruni aolole kabango kakue aume pa lufunko, ni lo lwaluke nda mwaya kyalo kya Misri.” ");
INSERT INTO tap_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ni pakako, Musa ni Haruni baakitile nga muba-aniinue na Yawe. Haruni lu-aalendwile kuboko ni kuuma pa lufunko, nda yaakupile ku Bamisri ni ku biteekua byabo. Lufunko lonse lwa mu kyalo kya Misri lwa-alukile nda. ");
INSERT INTO tap_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Banghanga bakua Farao ni bo mu bunghanga bwabo baeziizie kukita evio, inzi lolo lwendo lwene ba-andilue. Ni pakako, nda yaakupile ku bonse, muntu ni nama. ");
INSERT INTO tap_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Banghanga baamwanine Farao nangue, “Maka akua Leza i akita evi.” Inzi Farao waafiniizie mutima wakue, kabili taabatwiliziizie nga mwaalandiile Yawe. ");
INSERT INTO tap_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kabili Yawe waamwanine Musa nangue, “Lukeele ukabe kubuuka paakili ukabe kuya kuli Farao pa-akaba kuya ku menda. Ukabe kumwana nangue Yawe walanda evi, ‘Baleke bantu bane baye ban'mpupe. ");
INSERT INTO tap_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kine ukaane kubetabizia kuya, nakaba kukukanda na kukutumina bisepe bya balunzi, kabili nakaba kubituma pa babombi bobe, ni pa bantu bobe, balunzi bakaba kwingila mu nghanda yenu. Mu nghanda yonse ya Bamisri mwakaba kwizula bisepe bya balunzi pamo ni pansi ponse mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Inzi bobo busiku kyalo kya Goseni kikeelemo bantu bane nakaba kukikingilila. Momo mwene temukaba bisepe bya balunzi. Ni pakako, mwakaba kumana nangue ne Yawe ndimukubomba mu keno kyalo. ");
INSERT INTO tap_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kabili nakaba kubiika bupusano pakati ka bantu bane ni pakati ka bantu bobe. Kaka kalangi kakaba kukitika lukeele.’” ");
INSERT INTO tap_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ni Yawe waakitile mu-aalandiile. Bisepe bikata bya balunzi byaazoomokeele mu nghanda yakua Farao, pamo ni mu nghanda ya babombi bakue. Kyalo kyonse kya Misri kyainoonekele na bisepe bya balunzi. ");
INSERT INTO tap_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Farao waakuutile Musa ni Haruni. Waabaanine evi, “Ale endo mumwelele Leza wenu ngelelo. Inzi mumwelele sie mu keno kyenka kyalo.” ");
INSERT INTO tap_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Inzi Musa waamwasukile nangue, “Bila, tetuvinda kukita evio! Pantu kine twamwelela Yawe Leza wetu ngelelo, tulikukita mufuupula ku Bamisri, kine batumona twaelela ngelelo imwenekele yali mufuupula ku Bamisri, balikututoota mabue. ");
INSERT INTO tap_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Fwefue tupalile kuya lwendo lwa nsiku itatu mu kaseeba, kuya kumwelela Yawe Leza wetu ngelelo nga vi-akitwana.” ");
INSERT INTO tap_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao waalandile nangue, “Ndikumileka muye mu kaseeba kuti muye mumwelele Yawe Leza wenu ngelelo, inzi tekuye kuleepeesie. Muye mun'mpepeleko ni nene wenka.” ");
INSERT INTO tap_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa waamwasukile evi, “Evi vyenka vinsyali nafuma pano, ndikuya kukupepela kuli Yawe evi lukeele bisepe bya balunzi bikabe kufuma pali wewe, ni pa babombi bobe, pamo ni pa bantu bobe. Inzi we Farao nakusoka tekuti utubeepe paakale, kabili tekukaana kwitabizia bantu baye bamwelele Yawe ngelelo.” ");
INSERT INTO tap_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kupwako, Musa wafuma mu nghanda mwa Farao, waya kumupaapaata Yawe. ");
INSERT INTO tap_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yawe waakitile mwaapaapaatiile Musa. Waafumiizie bisepe bya balunzi pali Farao, ni pa babombi bakue, pamo ni pa bantu bakue. Tepaali ata lunzi umo waasyelepo. ");
INSERT INTO tap_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Inzi Farao waafiniizie mutima paakale ni kukaana kwitabizia kuti baye. ");
INSERT INTO tap_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kabili Yawe waamwanine Musa nangue, “Endo umwane Farao nangue Yawe wa Baebrania walanda evi, ‘Baleke bantu bane baye ban'mpupe. ");
INSERT INTO tap_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Pantu kine wabakakatila ni kukaana kubaleka baye, ");
INSERT INTO tap_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nakaba kukukanda na kuleeta kimina kya nfua pa biteekua byobe: Pa farasi ni pa punda, pa nghamia ni pa nghombe, pamo ni pa mikooko ni pa mbuzi. ");
INSERT INTO tap_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Inzi nakaba kulekenkania paakale pakati ka biteekua bya Baizraeli ni pakati ka biteekua bya Bamisri. Tepali nama wa pa Baizraeli wakaba kufua.’” ");
INSERT INTO tap_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yawe waabiikile musita walanda nangue, “Lukeele i musita unakaba kukitilapo keki kintu mu Misri.” ");
INSERT INTO tap_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ni kiine kukeele lwakue lukeelekeele Yawe waakitile mu-aalandiile. Nama yonse ya Bamisri yaafwile. Inzi pa nama ya Baizraeli tepaafwile ata umo. ");
INSERT INTO tap_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao i lu-aatumine babombi bakuya kukebelezia palua nama ya Baizraeli. Waizile kubwilua nangue pa nama ya Baizraeli tepaafwile ata umo. Anzia kyaali evio, Farao waali watwaliliile sie kufinia mutima ni kukaana kubaleka Baizraeli baye. ");
INSERT INTO tap_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yawe wa-anine Musa ni Haruni nangue, “Buule mito linsue limo mu kikuka, kusyali Musa aulwile mito mu muulu ntanzi yakua Farao. ");
INSERT INTO tap_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mito yaakaba tunkolopiilo twaakakumana pa kyalo kyonse kya Misri, ni yo yaakaaluka bipute byaakamena ku muntu ni ku nama mu kyalo kyonse kya Misri.” ");
INSERT INTO tap_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ni pakako, baabuulile mito ya mu kikuka kya mulilo ni kuya kwimana pa ntanzi yakua Farao. Musa waulwile mito mu muulu, ni yo ya-alukile bipute byaamenene ni kwaluka bilonda pa bantu ni pa biteekua. ");
INSERT INTO tap_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Banghanga ba-andilue kwimana pa ntanzi yakua Musa pantu ni bo baamenenue na bipute pamo ni Bamisri bonse. ");
INSERT INTO tap_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Inzi Yawe waafiniizie mutima wakua Farao, ni ye taamutwiliziizie Musa ni Haruni nga mwa-aninue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kabili Yawe waamwanine Musa nangue, “Buuka paakili lukeelekeele uye wimane pa ntanzi yakua Farao ni kumwana nangue Yawe Leza wa Baebrania walanda evi, ‘Baleke bantu bane baye ban'mpupe. ");
INSERT INTO tap_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kine teukitile evio, lono lwendo nakaba kumikanda bonse. Wewe ni babombi bobe pamo ni bantu bobe. Upalile kumana nangue mu byalo byonse temuli unge ali nga nene. ");
INSERT INTO tap_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Pantu evi nga nsisyakukandile pamo ni bantu bobe na kimina, kabili nga teusyaloviiziwe pa kyalo. ");
INSERT INTO tap_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Inzi n'milekeleele kuba bakose pa mulandu wakuti musininkizie vili maka ane, ni Liina lyane limanike mwaya kyalo. ");
INSERT INTO tap_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ni evi nsimwene kiulimukwitantamwina pa bantu bane pasili kubaleka baye. ");
INSERT INTO tap_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ni pakako, lukeele pa ono wenka musita nakaba kunokia nvula ikata ya kibue isinanokepo kutula kulengua kwa kyalo kya Misri mpaka lelo. ");
INSERT INTO tap_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kansi lenga wane babombi baye bengizie nama yobe mu nghanda, pamo ni byonse bi-uli nabio mu makaba, pantu kubalua muntu, ni nama ozo wakaba kusangililua ku makaba pasili kusungua mu nghanda, nvula ya kibue yakaba kumunoka ni kumwipaya.’” ");
INSERT INTO tap_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Mubombi wa pa babombi bakua Farao, ozo waapoozele maano ku keebo kakua Yawe, waingiziizie babombi bakue pamo ni nama yakue mu nghanda. ");
INSERT INTO tap_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Inzi olia asyaapoozele maano ku keebo kakua Yawe, waalekeleele babombi bakue ni nama yakue ku makaba. ");
INSERT INTO tap_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kabili Yawe waamwanine Musa nangue, “Olola kuboko kobe mu muulu evi nvula ya kibue inokele mu kyalo kyonse kya Misri, pa bantu, ni pa biteekua pamo ni pa bilimbua byonse bya mu makaba.” ");
INSERT INTO tap_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa lu-aolwele kabango kakue mu muulu, Yawe waatumine mitukumo ni nvula ya kibue, ni nkuba yaaponeene pansi. Ni pakako, Yawe waanokiizie nvula ya kibue yakilile kubiipa mu kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ezio nvula ikata ya kibue yaali yalimo mitukumo ni bimpenimpeni, yaali teinanokepo kutula kutendeka kwa ntundu mu kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ezio nvula ya kibue yaanokele, yainoonene kubalua kantu kaali kali mu makaba a mu kyalo kyonse kya Misri ni bantu pamo ni nama. Ezio nvula yainoonene bilimbua byonse bya mu makaba ni kutyona bimuti byonse. ");
INSERT INTO tap_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Inga sie mu kyalo kya Goseni kyaali kyalimo Baizraeli, i musyaanokele nvula ya kibue. ");
INSERT INTO tap_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pa kyamba, Farao waatumine muntu wa kuya kukuuta Musa ni Haruni. Waabaanine evi, “Lono lwendo naluvia. Yawe ni mulunghami, nene ni bantu bane tuluviizie. ");
INSERT INTO tap_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mupaapaate Yawe pantu ezi mitukumo ni nvula ya kibue byakila. Nene ndikumileka muye evi tekuti mutwalilile kwikala mono mu Misri.” ");
INSERT INTO tap_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa waamwasukile nangue, “Musita undikufuma mu muzi, ndikupepa namulendwiliile Yawe maboko ane, mitukumo ni nvula ya kibue bilikupua pakuti winike nangue Yawe i mwine kyalo. ");
INSERT INTO tap_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Inzi n'manine sie nangue wewe ni babombi bobe kumunakila Yawe Leza tekunabepo.” ");
INSERT INTO tap_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Kitani ni nghano ya shairi byainoonenue pantu shairi yaali yasyakosele, ni kitani kyasyatootele buluba. ");
INSERT INTO tap_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Inzi nghano ni binge tebyainoonenue pantu byaali tebinakule.) ");
INSERT INTO tap_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kupwako, Musa wafuma kuli Farao ni kuya kunze ya muzi. Musa lu-aalendwile maboko akue kuli Yawe, mitukumo ni nvula ya kibue byaapwile, nvula teyaatwaliliile kabili kunoka. ");
INSERT INTO tap_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao lu-aamwene nangue mitukumo ni nvula ya kibue byapua, waabalile paakale ni kufinia mutima wakue, wene pamo ni babombi bakue. ");
INSERT INTO tap_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ni pakako, Farao waafiniizie mutima ni kukaana kubaleka Baizraeli baye baya nga mwaalandiile Yawe kupitila muli Musa. ");
INSERT INTO tap_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yawe i lu-aamwanine Musa nangue, “Endo kuli Farao, pantu nakifinia mutima wakue ni wa babombi bakue pakuti n'mbalangisie tupapo twane pakati kabo, ");
INSERT INTO tap_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","evi ukabe wabalondolwela baana bobe ni benzikulu bobe bintu binaabakitiile Bamisri nafiitilue ni vinaalangisiizie tupapo twane pakati kabo, ni mwe mwaakamana nangue nene ndi Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ni pakako, Musa ni Haruni baile kuli Farao ni kumwana nangue, “Yawe Leza wa Baebrania walanda evi, ‘Eba, waakaba wakaanakaana sie pasili kunakila kuli nene? Baleke bantu bane baye ban'mpupe. ");
INSERT INTO tap_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kine wakaana kubalekela kuti baye, nakaba kuleeta luzie lukeele mu kyalo kyobe. ");
INSERT INTO tap_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Lolo luzie lwakaba kukupilila kyalo, ni kyo kyakaba kwanda kumoneka. Lolo luzie lwakaba kulia byonse bisyakiinoonua na nvula ya kibue, lwakaba kulia kubalua kantu kali ku kimuti kilikyamena mu makaba enu. ");
INSERT INTO tap_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Lolo luzie lwakaba kwizula mu nghanda yobe ni mu nghanda yonse ya babombi bobe pamo ni mu nghanda yonse ya bange Bamisri. Kekio kintu tekinamonekepo ku basiinue ni ku babikolue benu kutula busiku bubabambile kwikala mu keki kyalo mpaka lenu.’” Kupwako, Musa wafuma pali Farao ni kuya. ");
INSERT INTO tap_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Babombi bakua Farao baamwipuziizie evi, “Emwe, kubako ozu muntu waakaba watwaliliile sie kuya wali muteo kuli fwefue? Baleke Baizraeli baye bamupupe Yawe Leza wabo. Kubako teumwene nangue kyalo kya Misri kilimukwinoonua?” ");
INSERT INTO tap_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kupwako, Musa ni Haruni bakuutua kuli Farao ni kubaana nangue, “Kuti mwaya kumupupe Yawe Leza wenu. Inzi nghane, ni bani bakaba kuyako?” ");
INSERT INTO tap_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa wa-asukile nangue, “Twakaba kuya na balumendo betu ni bakote, baana betu balalume ni banakazi, mikooko ni mbuzi yetu, pamo ni nghombe yetu, pantu tupalile kumukitila Yawe nsikunkulu.” ");
INSERT INTO tap_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao waabanine mu kapuni nangue, “Yawe abe pamo nenu kine namilekeela kuya ni lupua lwenu pantu n'mwene mwali na mapange abi. ");
INSERT INTO tap_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nakaana! Inzi pantu i mumwalombelanga, kuti mwaya sie bakulunke kumupupa Yawe.” Kupwako, Musa ni Haruni bakumbua pa ntanzi yakua Farao. ");
INSERT INTO tap_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kabili Yawe waamwanine Musa nangue, “Ale olwela kuboko kobe pa kyalo kya Misri, evi luzie lwize pa kyalo kya Misri ni kulia bilimbua byonse bya mu makaba byaasiiluepo na nvula ya kibue.” ");
INSERT INTO tap_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ni pakako, Musa waolweleele kabango kwakue pa kyalo kya Misri, ni Yawe waabuusiizie mwela wa kufuma ku kabanga, ni o waapuupiile pa kyalo koba konse ni busiku bonse. Musita wa lukeelekeele mwela wa ku kabanga waaleetele luzie. ");
INSERT INTO tap_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Lolo luzie lwaasakukiile kyalo kyonse kya Misri ni kukupa nkendo yonse pantu lwaali lwakilile kuvula. Keki kimina kya luzie lwa ozu musango tekinamonekepo, kabili tekikikamonekapo. ");
INSERT INTO tap_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mu kyalo kyonse kya Misri mwa-alukile nfinzi pantu luzie lwaali lwakupiliile kyalo. Lolo luzie lwaaliile bilimbua byonse pamo ni mazabo onse a ku bimuti byaasyelepo musita waanokele nvula ya kibue. Pa kyalo kyonse kya Misri tepaasyele lyani libisi lya ku kimuti pamo ni bilimbua bya mu makaba. ");
INSERT INTO tap_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kupwako, penka papo Farao wakuuta kale Musa ni Haruni ni kubaana nangue, “Nene nakibala kuli Yawe Leza wenu ni kuli mwemue. ");
INSERT INTO tap_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ni pakako, ngeleele sie kibalo kyane lono lwendo ni kumupaapaata Yawe Leza wenu afumie keki kimina kya lufu pali nene.” ");
INSERT INTO tap_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kupwako, Musa wafuma pali Farao ni kuya kumupaapaata Yawe. ");
INSERT INTO tap_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yawe ni ye wa-asukile na kubuusia mwela ukata wa kufuma ku mboosi. Ozo mwela waululwile luzie lonse ni kulutwala ku Lyezi lya Kasi. Tekwaali luzie lwaasyele mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Inzi Yawe waafiniizie paakale mutima wakua Farao. Ni pakako, waakeene kubalekeela Baizraeli kuti baye. ");
INSERT INTO tap_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kabili Yawe waamwanine Musa nangue, “Olwela kuboko kobe mwiulu, evi kwaluke nfinzi itikeeme pa kyalo kya Misri, nfinzi ya kuvinda kupaapaatua ni kunvwika.” ");
INSERT INTO tap_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ni pakako, Musa waolweleele kuboko kwakue mwiulu. Ni nfinzi itikeeme yaapwile nsiku itatu yakupiliile kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nsiku yonse itatu Bamisri ba-andilue kumonana, kabili ba-andilue kuteluluka ponse pa baali. Inzi kisue kyaali kyali sie koko kwaali kwaikeele Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pa mpeleezio Farao waamukuutile Musa ni kumwana nangue, “Endo mumupupe Yawe. Banakazi ni baana benu kuti mwabatwama, inzi tekutwame mikooko, ni mbuzi pamo ni nghombe.” ");
INSERT INTO tap_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Inzi Musa waalandile evi, “Wewe upalile kutupeela nsambu ya kutwama nama ya bupe bwa ngelelo ya kumuziziizia Yawe Leza wetu. ");
INSERT INTO tap_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Fwefue tupalile kuya ni biteekua byetu. Tekuli lubondo lulikusyala pano, pantu pa bebi biteekua i patupalile kufumia nama wa kwelela Yawe Leza wetu, kabili tetumanine kine ni nama wapipo utwaya tumwelele patuya kufika kolia.” ");
INSERT INTO tap_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Inzi Yawe waafiniizie mutima wakua Farao mpaka wakaana kubaleka Baizraeli kuti baye. ");
INSERT INTO tap_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao waamusasiliile Musa wamwana nangue, “Fuma papa! Endo waya. Tekuti nkakumone kabili, pantu busiku buwaakamona lukebu lwane, waakafua!” ");
INSERT INTO tap_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa waamwasukile nangue, “Walanda kisinka. Nene nsikikaba kumona lukebu lobe.” ");
INSERT INTO tap_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yawe waamwanine Musa nangue, “Kwasyala kimina kimo kinakaba kumuleetela Farao pamo ni bekazi ba mu Misri, mane pa kyamba akabe kumiitabizia kuya ni kumikumbilila sie lonse kufuma pano. ");
INSERT INTO tap_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ale endo ubaane Baizraeli bonse, balalume ni banakazi, baye balombe bifwanizio bya mutofue, ni bya oro ku Bamisri babapalameene nabo.” ");
INSERT INTO tap_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yawe waalengiizie Baizraeli kutonua na Bamisri. Musa ni ye waali wakindamiisie pa babombi bakua Farao, ni pa bantu bonse ba mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ni pakako, Musa waamwanine Farao nangue, “Yawe walanda evi, ‘Lelo pakati busiku ndikwiza kupita mu kyalo kyonse kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Musita undikwiza kupita, kubalua libeli ali mu Misri alikufua, kubambila pa libeli obe wa kukupyana pa kitebe kya bukolo, mpaka ku libeli wakua mwanakazi muzia aliwapela nghano. Mabeli onse a biteekua ni o alikufua. ");
INSERT INTO tap_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mu kyalo kyonse kya Misri mwakaba kuya mwali malilo akata asinaunvwikemo ni asikikonvwikamo. ");
INSERT INTO tap_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Inzi ku Baizraeli tekukaba kunvwika lizui lya kabua ka kuboza Baizraeli, ni ka kuboza nama. Papo i pa mwakaba kwinika Yawe vi-abiikile bupusano pakati ka Bamisri ni Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Babombi bobe bonse bakaba kwiza kun'mpaapaata kuti nfume ni bantu bane, ni ne nakaba kufuma.’” Kupwako, Musa wafuma pali Farao ni kuya wakilile kufiitua. ");
INSERT INTO tap_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yawe waamwanine Musa nangue, “Farao wakaba kukaana. Ni pakako, tupapo twane twakaba kutwalilila kukitika mu kyalo kya Misri.” ");
INSERT INTO tap_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa ni Haruni baakitile toto tupapo tonse ntanzi yakua Farao. Inzi Yawe waafiniizie mutima wakua Farao. Farao ni ye waakeene kwitabizia Baizraeli kufuma mu kyalo kyakue. ");
INSERT INTO tap_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Baizraeli lubaali bakili mu kyalo kya Misri, Yawe waamwanine Musa ni Haruni nangue, ");
INSERT INTO tap_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ono mwezi waya wali mwezi wa mambo pa myezi kuli mwemue, i kulanda nangue mwezi wa mambo wa mwaka kuli mwemue. ");
INSERT INTO tap_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ane libumba lyonse lya Baizraeli nangue pa busiku bwa lyanondo bwa ono mwezi, kubalua lupua lukabe kusaakula musoka umo wa mukooko ao wa mbuzi kukonkana ni bwingi bwa bantu ba mu lupua lwakue. ");
INSERT INTO tap_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kine bantu ba mu lolo lupua baisanga bakeepele, bapalile kwilunda na lunge lupua lwa bantu bakeepele babapalameene nabo, kusyali kukasana nama ubalikuvinda kulia ni kupua. ");
INSERT INTO tap_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ozo musoka wa mukooko tekuti aye walemeene. Apalile aye wali mpanga wa mwaka umo. Mukabe kubuula pa mikooko ao pa mbuzi. ");
INSERT INTO tap_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ozo nama mukabe kumusunga mpaka busiku bwa lyanondo ni buna ya ozo wenka mwezi. Kubalua lupua lwa mu Baizraeli lwakaba kusinza nama wabo musita wa kyungulo. ");
INSERT INTO tap_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Bakabuule mulopa ni ku-usuba ku miilimiili ibili ya mumbali mulyango, ni ku bulato bwa pa muulu ku ezio nghanda ya kuliilamo munani wa ozo nama. ");
INSERT INTO tap_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mu bobo bwenka busiku musita wa busiku, bakabe kwapika bipusa bya ozo nama ni kulia busikunke, bakabe kuliila na kolo pamo ni mukate usiliko ntutumusi. ");
INSERT INTO tap_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tekuti mukabe kulia minofu ibisi ao ifulumiiziwe, mupalile sie kwapika byonse, mutue, ni myendo pamo ni bya munda. ");
INSERT INTO tap_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tekuti mukabe kusiapo bya kulia lukeele. Inzi kine bikabe kusyalapo mpaka lukeelekeele, mukabe kubizizia. ");
INSERT INTO tap_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Mafunde a kukonka pa kulia bebio bilio ni aza: Mukabe kuya mwaisapile, mwaikakile misipi mu bitungu byenu, mwavwele ni nkwabilo yenu ku makasa, mwakwete ni tubango mu minue yenu. Kusyali kulia lubilolubilo. Ezi i yaakaba Pasaka imwaakaba mwankitila nsikunkulu. ");
INSERT INTO tap_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Bobo busiku musita wa busiku, nakaba kupita mu kyalo kyonse kya Misri ni kwipaya mabeli onse alalume a bantu ni a nama. Kabili nakaba kukanda baleza bonse ba mu Misri, pantu nene ndi Yawe. ");
INSERT INTO tap_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mulopa i wakaba kuya wali kalangi kuli mwemue ka kulanga nghanda imwakaba kuya mwalimo. Musita unakaba kumona mulopa, nakaba kupita peulu pasili kumiinoona lunakaba kuya nakanda kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Bobu busiku bupalile bukabe bwalangulukua na nvyalo ya ku ntanzi, kabili bukabe bwali busiku bwa nsikunkulu yakua Yawe kubalua mwaka.” Leli i lifunde lya kubalua nsita. ");
INSERT INTO tap_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yawe waalandile nangue, “Mu nsiku kilooba mwemue mwakaba kuya mwalia mikate isiliko ntutumusi. Busiku bwa mambo bwa mu ezio nsiku kilooba ya nsikunkulu, mukabe kufumia ntutumusi yonse ili mu nghanda yenu. Onse wakaba kulia mukate uliko ntutumusi mu ezio nsiku kilooba ya nsikunkulu, wakaba kufumiiwa mu libumba lya Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pa busiku bwa mambo bwa nsikunkulu, kabili ni pa busiku bwa kilooba, bantu bonse bapalile kusunga busiku bwa kulonghana kuzuuke. Mu ezio nsiku tekukaba mwilo waakaba wabombua, inga sie mwilo wa kuteania bilio bya kulia kubalua muntu. ");
INSERT INTO tap_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mukasunge bobo busiku bwa nsikunkulu ya mikate isiliko ntutumusi, evi mukabe mwalanguluka busiku bunaamifumiizie mwe mabumba a Baizraeli mu kyalo kya Misri. Ezio nsikunkulu ipalile kusungua na nvyalo ya ku ntanzi kuba lifunde lya muyayaya. ");
INSERT INTO tap_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Pa busiku bwa lyanondo ni ina ya mwezi wa mambo musita wa kyungulo, i pamwaakaba mwatendekela kulia mikate isiliko ntutumusi mpaka kyungulo kya nsiku 21 ya ozo wenka mwezi wa mambo. ");
INSERT INTO tap_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mu ezio nsiku kilooba, tekuti kukabe muntu waakaba ni ntutumusi mu nghanda yakue. Ni pakako, namyana nangue kubalua muntu waakalia mukate ututumukile, anzia akaba wali mweni ao avyaliilue mu kyalo, waakafumiiwa mu libumba lya Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mu ezio nsiku kilooba tekuti mukabe mwaliamo kintu kiliko ntutumusi. Konse ku mwaakaba mwaikeele mukabe mwalia sie mukate usiliko ntutumusi.” ");
INSERT INTO tap_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa i lu-aakuutile masiiko onse a Baizraeli ni kubaana nangue, “Endo musaakule musoka wa mukooko ao wa mbuzi wa pa bisepe byenu mu kubalua lupua, evi musinze ni kukita nsikunkulu ya Pasaka kubalua muntu ni lupua lwakue. ");
INSERT INTO tap_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Muye mubuule misambo ya hisopo, mutubie mu mulopa uli mu kibakuli ni kusuba ku bulato bwa pa muulu, ni ku miilimiili ibili ya mu milyango ya nghanda yenu. Busiku bonse mpaka lukeelekeele tekuti kuye kwali muntu wakufuma mu nghanda, ");
INSERT INTO tap_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","pantu Yawe alikupita mu kyalo kyonse walimukwipaya Bamisri. Inzi musita u-alikumona mulopa ku bulato bwa pa muulu ni ku miilimiili, alikupita peulu, kabili tavinda kwitabizia malaika ngipaani kwingila mu nghanda yenu ni kumiipaya. ");
INSERT INTO tap_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mwemue pamo ni baana benu bonse, mupalile kulanguluka ni kunakila leli lifunde muyayaya. ");
INSERT INTO tap_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Musita umwaakengila mu kekio kyalo kimwaakapeelua na Yawe nga vi-aamilaile, mupalile mukabe mwatwaliliile kukita musango wa ezi mbeela. ");
INSERT INTO tap_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kine baana benu bakamiipuzie ndubulwilo ya keki kimulimukukita, ");
INSERT INTO tap_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mukaba-asuke evi, ‘Ezi i ngelelo ya Pasaka yakua Yawe lu-aapitile peulu nghanda ya Baizraeli mu kyalo kya Misri ni kutupususia fwefue lu-aali walimukwipaya Bamisri.’” Musa lu-aapwile kulanda, Baizraeli baakontamikile mitue ni kumupupa Yawe. ");
INSERT INTO tap_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kupwako, Baizraeli bakita nga muba-aniinue na Musa ni Haruni kukonkana ni mulao wakua Yawe. ");
INSERT INTO tap_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Lubwaali bwasyali pakati busiku Yawe waipaile mabeli onse alalume a mu kyalo kya Misri, kubambila ku mwana libeli mwalalume wakua Farao waali wapalile kumupyana se pa kitebe kyakue kya bukolo, mpaka ku mwana mwalalume libeli wakua muntu waali wakakilue mu buloko, pamo ni ku mabeli onse a biteekua. ");
INSERT INTO tap_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao ni babombi bakue pamo ni Bamisri baabuukile musita wa busiku, ni mizowa ikata yaunvwikile mwaya kyalo kyonse kya Misri pantu tekwaali nghanda yaasyele pasili kufwamo muntu. ");
INSERT INTO tap_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Farao i lu-aakuutile Musa ni Haruni busikunke ni kubaana nangue, “Mwemue pamo ni Baizraeli fume mu bantu bane muye mumupupe Yawe nga mumwakilandila. ");
INSERT INTO tap_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Twame bisepe byenu bya mikooko ni bya nghombe muye nga vimwakilanda. Ni nene muye mun'mpepeleko Leza an'mpaale.” ");
INSERT INTO tap_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Bamisri baapimpiliziizie Baizraeli balenge bafume mu kyalo ni kubaana nangue, “Kine temufumine, fwe Bamisri tulikufua bonse.” ");
INSERT INTO tap_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Baizraeli baatweme bunga bwa mikate bwaali bwakandiilue mu bipe lubwaali tebunaabiikueko ntutumusi. Baakakile mu ngubo yabo ni kupinga pa nkombe. ");
INSERT INTO tap_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Baizraeli baakitile nga mwaalandiile Musa. Baalombele bifwanizio bya mutofue ni bya oro pamo ni ngubo ku Bamisri. ");
INSERT INTO tap_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yawe waalengiizie Baizraeli kutonua na Bamisri. Baizraeli baapeelue kubalua kantu kabaalombele. Evio i vibaatweme bunonsi bwa Bamisri. ");
INSERT INTO tap_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Baizraeli baafumine paakili ku Ramese ni kuya lwa pansi mpaka ku Sukoti. Mpendua yabo yaali mupepi bantu 600,000 pasili kupendako banakazi ni baana. ");
INSERT INTO tap_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Kwaali ni Bazima baisanziiziepo ni kuya nabo, pamo ni bisepe bya mbuzi, ni bya mikooko ni nghombe. ");
INSERT INTO tap_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kukonkana ni vibaafumine lubilo lubilo mu Misri, ba-andilue kuteania mpao ya mu nzila. Ni pakako, ba-apikile mikate isiliko ntutumusi ya bunga bwali bwakandiilue bubaafumine nabo mu Misri. ");
INSERT INTO tap_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Baizraeli baikeele mu kyalo kya Misri myaka 430. ");
INSERT INTO tap_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ku mpeleezio ya mwaka wa 430, mu bobo bwenka busiku, mabumba a mikowa yonse ya bantu bakua Yawe aafumine mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Bobo busiku musita wa busiku Yawe waapungile pa mulandu wa kufumia Baizraeli mu kyalo kya Misri. Ni pakako, bobo busiku bwapungile Yawe bupalile kuya bwalangulukua kubalua mwaka na nvyalo ya Baizraeli ni kuya bapunga mu kumukindika Yawe. ");
INSERT INTO tap_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yawe waamwanine Musa ni Haruni nangue, “Mafunde palua Pasaka ni aza: Kubalua mweni tapalile kuliako bilio bya Pasaka. ");
INSERT INTO tap_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kubalua muzia asitilue na nfolanga kine wateetua yando, apalile kuliako bilio bya Pasaka. ");
INSERT INTO tap_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Inzi mweni ni kubalua mubombi aliwasaziiwa tapalile kuliako bilio bya Pasaka. ");
INSERT INTO tap_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Kubalua mwana mukooko wa Pasaka apalile luliilua sie mu nghanda imo. Temupalile kutwama minofu kufuma mu ezio nghanda. Kabili temupalile kutyona kikuza kya ku ozo nama. ");
INSERT INTO tap_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Libumba lyonse lya Baizraeli lipalile kuya lyakita ezio nsikunkulu ya Pasaka. ");
INSERT INTO tap_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kubalua mweni ali pakati kenu kine watona kwampana nenu ku nsikunkulu ya Pasaka mu kumukindika Yawe, balalume bonse ba mu lupua lwakue bapalile kuteetuanke yando, mane bapalame ku ezio nsikunkulu. Ni ozo muntu alikupendua kuba nga muntu avyaliilue mu kekio kyalo. Ni ye alikuba ni nsambu ya kuliako. Inzi olia asiteetelue yando tapalile kuliako bilio bya Pasaka. ");
INSERT INTO tap_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ozo wenka muzilo i waakaba wali ku Muizraeli avyaliilue mu kyalo ni ku mweni ekeele pakati kenu.” ");
INSERT INTO tap_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Baizraeli bonse baakitile nga mwa-aniinue Musa ni Haruni na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ni mu bobo bwenka busiku, Yawe waafumiizie Baizraeli mabumba mabumba mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ale nzuukiizie kubalua mwana mwalalume wa mambo. Libeli mwalalume wa Baizraeli, pamo ni wa nama, waakaba wane.” ");
INSERT INTO tap_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa wa-anine bantu nangue, “Mukabe mwalanguluka lyonse bono busiku bumwafumiiwa mu buzia bumwaali mwateekelue mu Misri, pantu Yawe wamifumiamo na maka a kuboko kwakue. Mu bobu busiku tekuti mukabe mwaliamo mukate uliko ntutumusi. ");
INSERT INTO tap_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Mwemue mwafuma lelo mu keno kyalo kya Misri kuntendeko ya mwezi wa Abibu. ");
INSERT INTO tap_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Musita umwaakafikiiwa na Yawe mu kyalo kya Bakanaani, ni kya Bahiti, ni kya Ba-amori, ni kya Bahivi, pamo ni kya Bayebusi, kyalo kyaalailue basinue nangue waakamipeela, kyalo kiizuzimo mabeele ni kapelo, mupalile mukabe mwakita ezi nsikunkulu kubalua mwaka mu ono wenka mwezi wa mambo. ");
INSERT INTO tap_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mu nsiku kilooba mwaakaba mwalia mikate isiliko ntutumusi, ni mu busiku bwa kilooba mwaakaba mwakitamo nsikunkulu ya kumukindika Yawe. ");
INSERT INTO tap_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mu ezio nsiku kilooba mwaakaba mwalia mikate isiliko ntutumusi, pakati kenu tekuti pakabe kintu kiliko ntutumusi, ni mu mipaka ya kyalo kyenu tekuti mukamoneke ntutumusi. ");
INSERT INTO tap_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Pa busiku bwa kilooba mupalile kulondolwela baana benu nangue, ‘Tulimukukita nsikunkulu pa mulandu wa belia byaatukitiile Yawe lu-aatufumiizie mu kyalo kya Misri.’ ");
INSERT INTO tap_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ezio nsikunkulu ya kubalua mwaka ikabe kalangi kuli mwemue ka kulangulukilako, nga kamanino kali ku kuboko kwenu ao pa mpala yenu, ikabe yamilangulusia kutwalilila kusambilila mizilo yakua Yawe, pantu Yawe waamifumiizie mu Misri na maka a kuboko kwakue. ");
INSERT INTO tap_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ni pakako, sunge leli lifunde lya ezi nsikunkulu pa musita utantikilue kubalua mwaka. ");
INSERT INTO tap_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Yawe pa-akaba kumifikia mu kyalo kya Bakanaani ni kumipeela kekio kyalo nga vi-aalapiile basiinue ni mwe benka, ");
INSERT INTO tap_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mupalile kumupeela Yawe kubalua mwana mwalalume libeli, ni kubalua nama ndume libeli wa pa biteekua byenu pantu byonse ni bunonsi bwakue. ");
INSERT INTO tap_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kubalua punda ndume libeli mwaakamulubula na musoka wa mukooko, inzi kine temukamulubula, mwaakatyona mukosi wakue. Ni kubalua libeli mwalalume wa muntu mu baana benu mwaakamulubula. ");
INSERT INTO tap_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mu nsiku ilimukwiza baana benu pa bakaba kumiipuzia nangue kitulitwakitila evi ni kiki? Mukabaasuke evi, ‘Tulimukita evi pantu Yawe waatufumiizie mu Misri, mu nghanda ya buzia, na maka akue. ");
INSERT INTO tap_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farao lu-aakeene kutwitabizia kuya, Yawe waipaile mabeli onse alalume a bantu ni a nama mu kyalo kya Misri. Ni pakako, i kitulitwamwelela Yawe kubalua libeli ndume wa nama, inzi mabeli alalume a mu baana betu tuli twa-alubula. ");
INSERT INTO tap_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Leli lifunde mwaakaba mwalilanguluka nga kamanino kali ku kuboko kwenu ao pa mpala yenu. Byaakaba byatulangulusia Yawe vi-aatufumiizie mu Misri na buvinde bwa kuboko kwakue.’” ");
INSERT INTO tap_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao lu-aitabiizie bantu kuya, Leza taabalombwele kuti baye bapite mu kyalo kya Bafilistini anzia kine i yaali nzila iipipiisie. Leza waalandile nangue, “Kine baba bantu basakukilua, kuti ba-alulula malanga abo ni kubwelela ku Misri.” ");
INSERT INTO tap_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Inzi Leza waazyungulusiizie bantu mu nzila ipitile ku kaseeba yalungi ku Lyezi lya Kasi. Baizraeli i kibaafumiine ku Misri bali mabumba mabumba nga balukale balimukuya ku bului. ");
INSERT INTO tap_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa waile watweme bikuza byakua Yusufu, nga mwa-aniinue Baizraeli na Yusufu kuti balape ni kukita. Yusufu waalandile evi, “Leza pa-akaba kumipususia, mukatwame ni bikuza byane pa kufuma pa eno nkendo.” ");
INSERT INTO tap_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Baizraeli lubaafumine ku Sukoti, baakuulile mitanda ku Etamu mumbali kaseeba. ");
INSERT INTO tap_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Musita wa koba Yawe waali waya wabatangiliile mu lilezi lyaali nga lipumpu pakuti abalangisie nzila, ni musita wa busiku waali waya wabatangiliile mu mulilo waali nga lipumpu pakuti abasanikile, evi baye baendele busiku ni koba. ");
INSERT INTO tap_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ni Yawe taafumiiziepo lipumpu lya lilezi musita wa koba, ni lipumpu lya mulilo musita wa busiku pa nkendo yakue ntanzi ya bantu. ");
INSERT INTO tap_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yawe i lu-aamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Baane Baizraeli babwele baye bakuule mitanda ku ntanzi ya Pi-Hahiroti, pa bukata bwa Migidoli ni lyezi, pepi ni Bali-Sefoni mumbali lyezi. ");
INSERT INTO tap_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao wakaba kulangakana nangue Baizraeli bakilinghaniwa na kaseeba, ni kwandua kufuma mu kyalo. ");
INSERT INTO tap_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nene nakaba kufinia paakale mutima wakua Farao, ni ye wakaba kumikonka. Inzi nakaba kuipeela mukinzi na kuuma Farao ni libumba lyakue lyonse. Ni Bamisri bonse baakeenika nangue nene ndi Yawe.” Ni pakako, Baizraeli baakuulile mitanda ni kutuuzia nga muba-aniinue. ");
INSERT INTO tap_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Farao lu-aabwililue nangue Baizraeli babutuka, wene pamo ni babombi bakue ba-alulwile malanga abo bai-ipuzia nangue, “Ati emue! Twakitapoki pa kulekelela Baizraeli baye tekuti batubombele?” ");
INSERT INTO tap_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ni pakako, Farao waateaniiziiziwe tyakala yakue ya bului ni kuya pamo ni balukale bakue. ");
INSERT INTO tap_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Waatweme matyakala 600 awamiisie mu Misri. Kubalua tyakala mwaali mwali mukulu ni balukale besapiile. ");
INSERT INTO tap_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yawe waafiniizie mutima wakua Farao likolo wa ku Misri. Ni pakako Farao waile wabakonkele Baizraeli baali baya bapamine. ");
INSERT INTO tap_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bamisri ni bafarasi babo bonse pamo ni matyakala onse akua Farao, ni baseli ba pa farasi pamo ni balukale, baile babakonkele pa kyamba mpaka baya kubasanga ku mitanda lya kumbali lyezi ku ntanzi ya Pi-Hahiroti pepi ni Bali-Sefoni. ");
INSERT INTO tap_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Baizraeli lubaikebukile ni kumona Farao walimukwiza wabakonkele pamo ni balukale bakue, baunvwile mwezo ukata. Kupwako, batendeka kumulilila Yawe. ");
INSERT INTO tap_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Baamwanine Musa nangue, “Ewe, ni pa mulandu wa kubulua bilibu mu Misri i kiwakitufumiiziamo evi twize tufwile mu kaseeba? Ni kiki kyakikulengia utufumie mu Misri? ");
INSERT INTO tap_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Lolia lutwakiba twakili mu Misri tetwakikwana nangue tuleke fwe bene tubombele Bamisri? Pantu kuti kyawama kubombela Bamisri kukila kufwila mu kaseeba.” ");
INSERT INTO tap_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Inzi Musa waabaanine nangue, “Tekutiine! Sipe sie, ni mwe mulikumona Yawe vi-alikumipususia bono bukiile, pantu baba Bamisri bamumwene lelo temukikabamona kabili. ");
INSERT INTO tap_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Teekamane sie Yawe mwine alikumilwila.” ");
INSERT INTO tap_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yawe i lu-aamwanine Musa nangue, “Ulimukundililaki? Baane Baizraeli baye baya. ");
INSERT INTO tap_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ni we lendula kabango kobe, uolwele kuboko kobe pa lyezi ni kulikasania, evi Baizraeli bapite mu lyezi pa musili uume. ");
INSERT INTO tap_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nene ndikufinia mitima ya Bamisri, ni bo balikwiza bamikonkele. Nene ndikuipeela mukinzi na kuuma Farao ni libumba lyakue lyonse, ni matyakala akue pamo ni baseli bakue ba pa farasi. ");
INSERT INTO tap_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Bamisri bonse balikwinika nangue nene ndi Yawe musita undikuipeela mukinzi na kuuma Farao ni matyakala akue pamo ni baseli bakue ba pa farasi.” ");
INSERT INTO tap_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ni pakako, malaika wakua Leza waali watangiliile libumba lya Baizraeli, waabweleele ku kyamba kyabo, ni lilezi lyaali lyali nga lipumpu lyaafumine ku ntanzi ni kuya kwimana ku kyamba kyabo. ");
INSERT INTO tap_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Lilezi lyaile kwimana pa bukata bwa libumba lya Bamisri ni Baizraeli. Lelio lilezi lyaaleetele nfinzi ku lubali lwa Bamisri, ni kuleeta kisue ku lubali lwa Baizraeli. Ni pakako, tekwaali libumba lyaapalamiine liinakue. ");
INSERT INTO tap_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kabili Musa waolwele kuboko kwakue pa lyezi, ni Yawe waatintile lyezi na mwela wa maka kufuma ku kabanga busiku bonse. Menda aakasanikile, ni palia paali menda paumine. ");
INSERT INTO tap_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Baizraeli baile mu lyezi pa musili uume. Menda aimeene nga kibumba kuso ni kulio pa mulandu wabo. ");
INSERT INTO tap_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Bamisri baakonkelemo, baingila mu lyezi ni farasi yonse yakua Farao, ni matyakala akue onse, pamo ni baseli bakue ba pa farasi. ");
INSERT INTO tap_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Inzi lubwaali bwasyakia, Yawe mu lipumpu lya mulilo ni lya lilezi, waakentele pansi pa libumba lya Bamisri ni kubavulunghania. ");
INSERT INTO tap_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Waafumiizie mipeto ku matyakala abo mpaka a-andua ni kwenda. Ni Bamisri baalandile evi, “Emwe, tumubutuke Izraeli, pantu Yawe alimukubalwila.” ");
INSERT INTO tap_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Baizraeli bonse lubaafikile ku bunge bwala, Yawe waamwanine Musa nangue, “Ale olwela kuboko kobe paakale pa lyezi, evi menda abwele ni kubakupa Bamisri pamo ni matyakala abo, ni baseli ba farasi yabo.” ");
INSERT INTO tap_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ni kiine musita wa lukeelekeele paakili, Musa waolweleele kuboko kwakue pa lyezi, lyezi lyaabwelele na maka. Bamisri baeziizie kubutuka, inzi Yawe waabakupiliile mu lyezi. ");
INSERT INTO tap_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Menda i lu-abwelele ni kukupilila matyakala a bului, ni baseli ba pa farasi pamo ni libumba lyonse lyakua Farao lyaali lyakonkele Baizraeli mu lyezi. Pakati kabo tepaali muntu waapusukile. ");
INSERT INTO tap_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Inzi Baizraeli bene baile baenda mu lyezi pa musili uume, ni azo menda aali ali kibumba ku kuboko kwabo kwa kulio ni kwa kuso. ");
INSERT INTO tap_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Evi Yawe i vi-aapususiizie Baizraeli bobo busiku mu maboko a Bamisri. Baizraeli baamwene Bamisri bafwile mumbali lyezi. ");
INSERT INTO tap_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Baizraeli lubaamwene maka akata akua Yawe pa Bamisri, baamukindikile Yawe. Baamuketekeele Yawe pamo ni Musa mubombi wakue. ");
INSERT INTO tap_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Musa ni Baizraeli i lubaamwimbiile Yawe lwimbo balanda nangue, “Ndikumwimbila Yawe pa mulandu wa bwanzio bwakue bwa bulumba, farasi ni museli bakipoozua mu lyezi. ");
INSERT INTO tap_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yawe i maka ane ni lwimbo lwane, wene i bwanzio bwane. Wene i Leza wane, ni ne ndikumutasia, wene i Leza wakua tawe, ni ne ndikumulumba. ");
INSERT INTO tap_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yawe i kalwisia wa bului. Yawe i Liina lyakue. ");
INSERT INTO tap_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Wene wakipooza matyakala akua Farao ni libumba lyakue mu lyezi. Babiloolo bakue baswapiilue bakitibiziiwa mu Lyezi lya Kasi. ");
INSERT INTO tap_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Buziba bwakibakupilila. Bakitibiziiwa mu buziba nga libue. ");
INSERT INTO tap_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Kuboko kobe kwa kulio we Yawe, ni kwa buvinde ni maka. Kuboko kobe kwa kulio we Yawe, kulikwasansa balwani. ");
INSERT INTO tap_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ku bwingi bwa maka obe, balwani bakiponiiziwa pansi. Kikonko kyobe kyakibafita nga makapa omine. ");
INSERT INTO tap_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na mupuze wa mu myona yobe, menda akiseziiwa. Mabimbi akiimana nga kibumba. Buziba bwakikwatana mu mutima wa lyezi. ");
INSERT INTO tap_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mulwani waitantamwine walanda, ‘Ndikubakonka ni kubakwata. Ndikubapoka bunonsi bwabo, ndikububombia muntoneene. Ndikwisumba kipanga kyane, kuboko kwane kulikubalovia.’ ");
INSERT INTO tap_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Inzi wewe wakipuza na mupuze obe, ni lyezi lyakibakupilila. Bakitibila nga libue mu menda engi. ");
INSERT INTO tap_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“We Yawe, pa baleza bonse nani ali nga wewe? Nani ali nga wewe mu bulumba ni buzuuke? Nani aliwatiinia mu kutasiiwa kwakue lu-aliwakita tupapo? ");
INSERT INTO tap_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Wewe wakyolola kuboko kobe kwa kulio, ni kyalo kyakiteleka balwani betu. ");
INSERT INTO tap_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Wewe na ntono yobe isili na mpeleezio, wakilombola bantu bawakilubula, wewe na maka obe, wakibalombola kuya mu kifuka kyobe kizuuke. ");
INSERT INTO tap_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ntundu yakyunvua ni kitutuma. Bafilistini bakilwala na mwezo. ");
INSERT INTO tap_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Bakulu ba ku Edomu bakitooboka. Bakindami ba ku Moabu bakikwaka. Bakanaani bonse bakiswapulukua. ");
INSERT INTO tap_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Lubebue ni mwezo byakiba pali bene. Na maka a kuboko kobe, bakiikala tondolo nga libue. Mpaka musita wakyabuka bantu bobe we Yawe, bantu bobe bawaalubwile mu buzia. ");
INSERT INTO tap_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wakaba kubengizia ni kubalimba mu lupili lwa bupyani bobe, pa nkendo i waiteaniiziizie we Yawe kuba pa kwikala pobe, pa kifuka kizuuke kiwaimikiile we mwine na kuboko kobe. ");
INSERT INTO tap_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","We Yawe, kuteeka kobe ni kwa muyayaya ni muyayaya.” ");
INSERT INTO tap_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Farasi yakua Farao likolo wa ku Misri ni matyakala akue, ni baseli ba pa farasi lubaingiile mu lyezi pa musili uume, Yawe waabweziizie menda a lyezi pali bene. Inzi Baizraeli baendele pa musili uume mu lyezi. ");
INSERT INTO tap_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ni pakako, kabika Miriamu, nkaziize kwa Haruni, waabuulile nghoma yakue, ni banakazi bonse baile bamukonkele balimukomba nghoma koku balimukukinda. ");
INSERT INTO tap_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu waabalombwele mukwimba nangue, “Mwimbile Yawe pantu wa-anzia na bulumba. Farasi ni amuselelepo bapoozua mu lyezi.” ");
INSERT INTO tap_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musa i lu-aalombwele Baizraeli kufuma ku Lyezi lya Kasi mpaka kuya kulapukila mu kaseeba ka Shuri. Baendele lwendo lwa nsiku itatu mu kaseeba pasili kumona menda. ");
INSERT INTO tap_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Lubaafikile pa kalambe ka Mara, ba-andilue kumina menda a pa ezio nkendo pantu aali alulile. Ni pakako, pa ezio nkendo i kipainikiilue Mara. ");
INSERT INTO tap_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Bantu baamwitendokeele Musa balimukumwipuzia nangue, “Tulikuminaki?” ");
INSERT INTO tap_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa i lu-aamuliliile Yawe kuti abakwasie, ni Yawe waamulangisiizie kaputu ka kamuti. Musa waakapoozele pa menda, ni menda awama. Papo pa Mara, Yawe i pa-aabapeele Baizraeli mizilo ni mafunde pamo ni kubeezia amone kine kuti bamuketekela. ");
INSERT INTO tap_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Waalandile evi, “Kine mulikunvua lizui lyakua Yawe Leza wenu mwapoozeleko ni maano, ni kukita biweme pa menso akue, ni kufikilizia milao yakue, pamo ni kusunga mafunde akue onse, nene nsikamikanda na kumilwalika malwele onse analwalikile Bamisri pantu nene ndi Yawe aliwamikosia.” ");
INSERT INTO tap_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Pa kyamba kya kufuma pa Mara, Baizraeli baile kufika ku Elimu, koko kwaali tusulo lyanondo ni tubili twa menda ni bimuti 70 bya bikoma. Koko i kubaakuulile mitanda yabo pepi ni menda. ");
INSERT INTO tap_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Pa busiku bwa lyanondo ni isaano bwa mwezi wa bubili pa kyamba kya kufuma ku Misri, libumba lyonse lya Baizraeli lyaafumine ku Elimu ni kuya kufika ku kaseeba ka Sini kali pa bukata bwa Elimu ni Sinai. ");
INSERT INTO tap_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Lubaafikile mu kaseeba, baabambile kumwitendookela Musa ni Haruni balanda nangue, ");
INSERT INTO tap_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Kansi Yawe nga waatwipaile sie mu kyalo kya Misri, koko kutwaali twaikeele twazyungulukiile mipika iizuzimo minofu ya nama, ni kulia bilio byonse bitwatonene kulia. Inzi evi mwakituleeta kono kufuma Misri kuti mwize mutwipaye na nzala mono mu kaseeba.” ");
INSERT INTO tap_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yawe i lu-aamwanine Musa nangue, “Unvua, nakaba kuya nabanokiizia bilio kufuma mwiulu, evi kubalua busiku bantu bakabe kuya bafuma ni kutoolapo bilio bya kulia bobo busiku, pakuti nkabe kubeezia ni kumona kine kuti bakonka mizilo yane ao abe. ");
INSERT INTO tap_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Inzi busiku bwa mutanda baakaba bateania bilio bya kulia nsiku ibili.” ");
INSERT INTO tap_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ni pakako, Musa ni Haruni baabaanine Baizraeli nangue, “Lelo kyungulo mulikwinika nangue Yawe i wakimifumia mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ni lukeelekeele mwakaba kumona bulumba bwakua Yawe, pantu wakyunvua vimwakiba mwamwitendookela. Ale fwefue tuli bani pakuti mutwitendookele?” ");
INSERT INTO tap_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kabili Musa waatwaliliile kulanda nangue, “Mwakaba kumona bulumba bwakua Yawe pa-akaba kumipeela munani wa kulia musita wa kyungulo, ni bilio bya kulia ni kwikuta musita wa lukeelekeele, pantu Yawe waunvua kwitendooka kwenu kumulimukumwitendookela. Ale fwefue tuli bani pakuti mutwitendookele? Mwemue mulimukwitendookela Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kabili Musa waamwanine Haruni nangue, “Ana Baizraeli bonse baye kuli Yawe pantu wakyunvua kwitendooka kwabo.” ");
INSERT INTO tap_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Haruni lu-aali walanda na Baizraeli, penka papo bakenta kale ku kaseeba ni kumona bulumba bwakua Yawe bwalimuku-unguzima mu lilezi. ");
INSERT INTO tap_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nakyunvua kwitendooka kwa Baizraeli. Ale baane nangue kubalua kyungulo mwakaba kuya mwalia munani wa nama, ni kubalua lukeelekeele mwakaba kuya mwalia mikate. I pamwakaba kwinika nangue nene ndi Yawe Leza wenu.” ");
INSERT INTO tap_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Musita wa kyungulo nkwale ingi yaizile kwikala monse mwaali mitanda. Ni lukeele lwakue lukeelekeele lume lwakumeene monse mwaali mitanda. ");
INSERT INTO tap_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lume palwaakunkikile, mu kaseeba mwaamwenekele tuntu twaali twamaatikile twaswetele nga kibue. ");
INSERT INTO tap_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Baizraeli lubaamwene toto tuntu, baapapile ni kwipuzyania nangue, “Ale totu tuntu ni tuki?” Pantu tebaali batumanine. Musa waabaasukile evi, “Bebi i bilio bimwapeelua na Yawe kuti mulie. ");
INSERT INTO tap_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yawe waafumiizie mwano walanda nangue, ‘Kubalua lupua lutoole kukonkana ni vilulikuvinda kulia. Kubalua muntu ali mu mutanda apeelue tupe tubili.’” ");
INSERT INTO tap_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ni pakako, Baizraeli baakitile muba-aniinue. Bange baatolele bingi, ni bange baatoolele sie biniini. ");
INSERT INTO tap_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Inzi lubaabiikile mu kalingo, kubalua muntu byaali byamukumeene, olia waatoolele bingi taali na bivuliisie, ni olia waatoolele biniini taali na bikeepeesie. Kubalua lupua lwaatoolele bya kuti bekute. ");
INSERT INTO tap_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ni pakako, Musa waabaanine nangue, “Tekusiepo bya kufika lukeele lukeelekeele.” ");
INSERT INTO tap_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Anzia kyaali evio, tebaamunvwile Musa, bange pakati kabo baasiilepo mpaka lukeelekeele, inzi ni byo byaabolele, bya-alukamo myolo ni kutendeka kununka. Ni pakako, Musa waabafiitiilue. ");
INSERT INTO tap_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lyonse lukeelekeele kubalua muntu waali watoola bya kulia bya kuti ekute, ni koba lukaali kasaama, byaali byasunguluka. ");
INSERT INTO tap_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Busiku bwa mutanda baatolele libili, kubalua muntu tupe tubili. Ni bakulu bonse ba libumba baizile kumubwila Musa. ");
INSERT INTO tap_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa waabaanine nangue, “Yawe walanda evi, ‘Lukeele i busiku bwa kutuuzia, Sabata izuuke yakua Yawe. Kansi apike bimulikuvinda kwapika, ni kufulumia bimulikuvinda kufulumia. Bilikusyalapo mubisunge mpaka lukeelekeele.’” ");
INSERT INTO tap_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ni bo baasungile mpaka lukeelekeele nga muba-aniinue na Musa. Bebio bilio tebyaanunkile, kabili temwa-alukile myolo. ");
INSERT INTO tap_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa waabaanine nangue, “Evi lelo vibuli busiku bwa Sabata, busiku buzuuke bwa kutuuzia bwakua Yawe, bebi bilio bilie lelo lyenka pantu lelo temutoola bilio. ");
INSERT INTO tap_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mwakaba kuya mwatoola bya kulia mu nsiku mutanda, inzi busiku bwa kilooba, busiku bwa Sabata tebikaba byamonekamo.” ");
INSERT INTO tap_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Lubwaafikile busiku bwa kilooba, bantu bamo baile bakeba kutoola, inzi tebaabimwene. ");
INSERT INTO tap_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yawe waamwipuziizie Musa nangue, “Eba, mwaakaba mwakaanakaana sie kusunga milao ni mizilo yane mpaka musitaki? ");
INSERT INTO tap_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mupalile kumana nangue Yawe wakimipeela busiku bwa Sabata, ni pakako, pa busiku bwa mutanda i ki-akimipeelela bilio bya nsiku ibili. Kansi kubalua muntu apalile sie kuya waikeele mu busiku bwa kilooba. Tekuli muntu ali ni nsambu ya kufuma kuya mu kutoola bilio.” ");
INSERT INTO tap_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ni pakako, bantu tebaatoole bilio pa busiku bwa kilooba. ");
INSERT INTO tap_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Baizraeli baabiinikile bebio bilio nangue maana. Byaali byaswetele nga masaka. Byaali ni mulio wakue waali wasonsele nga mukate umaatikile ukitiliilue na kapelo. ");
INSERT INTO tap_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa waabaanine nangue, “Yawe wakitwana evi, ‘Sungepo kalingo kamo ka maana pa mulandu wa nvyalo yenu, evi ikamoneko bilio binaamilisiizie mu kaseeba, lunaamifumiizie mu kyalo kya Misri.’” ");
INSERT INTO tap_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa waamwanine Haruni nangue, “Buula kape kamo ubiikemo kalingo kamo ka maana ni kukateeka pa ntanzi yakua Yawe, evi maana alabukilue bwino pa mulandu wa nvyalo ya ku ntanzi.” ");
INSERT INTO tap_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Haruni waakitile mwa-aniinue Musa na Yawe, waabuulile kape kalimo maana ni kukateeka mu Lisanduku lya Kipingo pakuti azo maana alabukilue bwino. ");
INSERT INTO tap_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ni pakako, Baizraeli baaliile maana mu myaka 40, mpaka musita ubaile kufika mu kyalo kibaile kwikalamo. Baaliile maana mpaka kuya kufika ku mipaka ya kyalo kya Kanaani. ");
INSERT INTO tap_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Kako kape kaali kalingo kamo ka lyanondo mu efa imo.) ");
INSERT INTO tap_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Baizraeli bonse baafumine mu kaseeba ka Sini ni kuya kukuukila ku inge nkendo kukonkana ni viba-aninue na Yawe. Baile kukuula mitanda ku Refidimu, inzi koko ku Refidimu tekwaali menda a kumina bantu. ");
INSERT INTO tap_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ni pakako, baamusakukiile Musa balanda nangue, “Lenga utupeele menda a kumina.” Musa waabaasukile evi, “Ale kimulimukungitendookela ni kiki? Mulimukumweziiziaki Yawe?” ");
INSERT INTO tap_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Inzi bantu baakilile kunvua kyaka ni kukila kumwitendookela balanda nangue, “Eyo wakitufumia mu Misri ni kwiza kutwipaila mono na kyaka, fwe ni baana betu pamo ni nama yetu!” ");
INSERT INTO tap_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kabili Musa waamuliliile Yawe walanda nangue, “Ale baba bantu ndikubakitilaki? Evi tebakeba kuntoota mabue.” ");
INSERT INTO tap_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yawe waamwanine Musa nangue, “Twamapo masiiko amo a Baizraeli uye nao ku ntanzi ya libumba. Utwame ni kabango kawaumine pa Mwenzi wa Nile. ");
INSERT INTO tap_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ndikuya kwimana pa ntanzi yobe pa mwalala ku Horebu. Uye uume mwalala, evi menda a kumina bantu afume.” Musa waakitile evio pa menso a masiiko a Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Pa ezio nkendo Musa wainikilepo liina lya Masa ni Meriba pantu Baizraeli baamusakukiile Musa ni kumwezia Yawe lubaipuziizie nangue, “Ati emwe, kubako Yawe ali pamo ni fwefue ao abe?” ");
INSERT INTO tap_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Baizraeli lubaali ku Refidimu, baizile kusakukilua na Ba-amaleki. ");
INSERT INTO tap_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa waamwanine Yoshua nangue, “Saakulapo balalume pa bantu betu uye ulue na Ba-amaleki. Nene lukeele nakaba kuya kwimana pa lupili nakwete kabango kana-aninue na Leza kuba nako mu minue yane.” ");
INSERT INTO tap_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ni pakako, Yoshua waile kulua na Ba-amaleki nga mwa-aniinue na Musa. Ozo musita Musa ni Haruni pamo ni Huri baaselele peulu lupili. ");
INSERT INTO tap_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa lyonse lu-aali walendula maboko akue waakwete ni kabango, Baizraeli baali ba-anzia. Inzi lu-aali wakoosia maboko akue, Ba-amaleki i baali ba-anzia. ");
INSERT INTO tap_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Maboko akua Musa teakokwele kunaka ni ye waali wasya-andua kulendula maboko. Ni pakako, Haruni ni Huri baamuleeteele Musa libue lya kuti ekalepo. Kabili baimeene umo kulio ni unge kuso bakwatiliile maboko akua Musa aali alendukile mpaka kyungulo. ");
INSERT INTO tap_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ni pakako, Yoshua wa-anziizie balukale ba Ba-amaleki ku bului. ");
INSERT INTO tap_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Pa kyamba kya kwanzia, Yawe waamwanine Musa nangue, “Lemba totu twebo twa bwanzio mu kitabu, evi kikabe kyalangulukua lyonse, ni pa kyamba umwane Yoshua nangue naakalovia Ba-amaleki, kabili tekuli muntu waakaba wabalanguluka pano pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa waakuulile kitale ki-ainikile, “Yawe-Nisi.” ");
INSERT INTO tap_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa waalandile evi, “Yawe walapa nangue waakaba watwaliliile kulua na Ba-amaleki, pantu maboko akilendulua ku kitebe kya bukolo kyakua Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetoro kitambua wa ku Midiani, sevyala kwa Musa, waunvwile mpunda palua bintu byonse byaakitile Leza palwakua Musa ni palua Baizraeli, bantu bakue, pa kyamba kya kubafumia mu Misri. ");
INSERT INTO tap_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Pa ozo musita Musa waali wasyapeele mukazi wakue Sipora nsambu ya kuya kuli se Yetoro. Ni ye waamupokeleele mwanaye ");
INSERT INTO tap_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","pamo ni baana bakue balalume babili. Wa mambo waali wainikilue liina lya Gershomu, pantu Musa waalandile evi, “Nakyaluka mweni mu kyalo kya bweni.” ");
INSERT INTO tap_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Wa bubili waali wainikilue liina lya Eliezeri, pantu Musa waalandile evi, “Leza wakua tawe wakiba wali mukwasi wane wakin'mpususia mu lufu kuli Farao.”) ");
INSERT INTO tap_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetoro sevyala kwa Musa waile kumupempula Musa. Waile pamo ni muka Musa waali ni baana bakue babili. Pa ozo musita Musa waali wakuulile mitanda mu kaseeba mumbali lupili lwakua Leza. ");
INSERT INTO tap_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetoro waalaiziizie mpunda kuli Musa nangue, “Ne so vyala ndimukwiza kukupempula nali ni mukazi obe pamo ni baana bobe babili.” ");
INSERT INTO tap_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ni pakako, Musa waafumine ni kuya kumupokelela sevyala. Waamukontamiine, kabili waamukumbatiile koku balimukwipuzyania mutende. Pa kyamba, baingiile mu liema lyakua Musa. ");
INSERT INTO tap_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa waamulondolweleele sevyala byonse byaakitile Yawe kuli Farao ni ku Bamisri pa mulandu wa Baizraeli, kabili waamulondolweleele palua Baizraeli vibaapususiiziwe na Yawe mu maavia aabakitikiile mu nzila. ");
INSERT INTO tap_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetoro waakilile kuwamiinua lu-aunvwile palua bintu byonse biweme byaakitiilue Baizraeli na Yawe, ni palua kubapususia ku Bamisri. ");
INSERT INTO tap_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetoro waalandile evi, “Yawe atasiiwe pantu waakupususiizie ku Bamisri ni kuli Farao. Ee, atasiiwe pantu waapususiizie bantu bakue ku Bamisri! ");
INSERT INTO tap_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Evi nainika nangue Yawe i mukulu kukila baleza bonse pantu waapususiizie bantu bakue mu kukitilua bibiipile na kitoni kya Bamisri.” ");
INSERT INTO tap_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ni pakako Yetoro sevyala kwa Musa waaleetele ngelelo ya kuzizia ni kumwelela Leza. Haruni pamo ni masiiko onse a Baizraeli baizile kulia maliila a ngelelo pamo ni Yetoro sevyala kwa Musa ntanzi yakua Leza. ");
INSERT INTO tap_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Lukeele lwakue Musa waikeele pa kitebe kya bupinguzi ni kuya wabatwiliziizie vibaali basongelana koku bamuzyungulukiile kutula lukeelekeele mpaka kyungulo. ");
INSERT INTO tap_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yetoro sevyala kwa Musa lu-aamwene miilo yaali yabomba Musa, waamwipuziizie evi, “Ewe, uliwabombelaki miilo yatanine evi we bunke ni bantu bakuzyungulukiile koba konse kutula lukeelekeele mpaka kyungulo?” ");
INSERT INTO tap_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa wa-asukile evi, “Ndimukubomba evi pantu bantu balimukwiza bakebele kumana kutona kwakua Leza. ");
INSERT INTO tap_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bantu lubalibaiza ni milandu kuli nene, ndinapingula kubalua muntu ni kumonapo ali ni nsambu. Ndinabaana mafunde akua Leza ni kubapeela mizilo yakua Leza.” ");
INSERT INTO tap_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Sevyala kwa Musa waamwanine evi, “Teulimukubomba bwino. ");
INSERT INTO tap_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Wewe pamo ni baba bantu bauli nabo mwakaba kutopa. Ozu mwilo ukilile bukata, te mwilo wa kubomba we bunke. ");
INSERT INTO tap_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ale unvua nsokezi yane, ni Leza abe pamo nobe. Upalile kuya wali mwimanizi wa bantu kuli Leza ni kumwana milandu yabo. ");
INSERT INTO tap_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Upalile kubasambilizia mizilo ni mafunde akua Leza pamo ni kubalanga ngikalilo ni miilo ibapalile kuya babomba. ");
INSERT INTO tap_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Inzi saakulapo bantu ba maano, bantu ba kisinka, bantu balibamukindika Leza pamo ni basuulile bituulilo. Usaakulepo banombozi ba mabumba a bantu 1,000, ni a bantu 100, ni a bantu 50, pamo ni a bantu lyanondo. ");
INSERT INTO tap_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Baba banombozi bapalile bakabe bapingula milandu ya bantu kubalua busiku. Mane bakabe kuya bakuleetelako sie milandu ikata, inzi milandu iniini bakabe kuya bapingula bo bene. Ni pakako, wakaba kuya wa-angukiilue pantu bakukwasiako miilo. ");
INSERT INTO tap_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kine wakonka ezi nsokezi, ni Leza kine wakwitabizia kukita evio, teukiya wanaka. Ni bantu bakaba kuya babwela kwabo bali ni mutende.” ");
INSERT INTO tap_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa waunvwile nsokezi yakua sevyala Yetoro ni kukita kubalua kantu mwa-aniinue. ");
INSERT INTO tap_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa waasaakwile bantu ba maano mu Baizraeli bonse ni kubabiika kuba banombozi ba bantu. Waababiikile kuba banombozi ba mabumba a bantu 1,000, ni a bantu 100, ni a bantu 50, pamo ni a bantu lyanondo. ");
INSERT INTO tap_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ni bo baali bapingula bantu kubalua busiku. Milandu ikata baali bamutwaalila Musa, inzi milandu iniini baali bapingula bo bene. ");
INSERT INTO tap_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Pa kyamba kya bebio, Musa ni sevyala Yetoro balayene, ni Yetoro waabwelele ku kyalo kyakue. ");
INSERT INTO tap_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Baizraeli baafumine ku Refidimumu, ni mu busiku bwa mambo bwa mwezi wa butatu pa kyamba kya kufuma ku Misri, baile kufika mu Kaseeba ka Sinai. Koko i kubaimikile mitanda yabo mwinsina Lupili lwa Sinai. ");
INSERT INTO tap_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Pa kyamba, Musa waaselele ku lupili aye asaakaane ni Leza. Yawe waamukuutile ni kumwana nangue, “Peela aza mafunde ku Baizraeli, nvyalo yakua Yakobo ni kubaana nangue, ");
INSERT INTO tap_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mwakimona vinakikita ku Bamisri, kabili mumanine vinakimitwama nga nzwiba atweme twana twakue pa mapaapi. Nene nakimipalamika mu kyeni kyane. ");
INSERT INTO tap_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ni pakako, kine mwanakila kisinka lizui lyane ni kusunga kipingo kyane, mulikuya mwali bunonsi bwane bwa mponvu pa ntundu yonse anzia kine kyalo kyonse ni bunonsi bwane. ");
INSERT INTO tap_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mulikuya mwali bukolo bwane bwa babitambua, kabili mulikuya mwali ntundu yane izuuke.’ Ezi i mpunda i wakaba kulanda ku Baizraeli.” ");
INSERT INTO tap_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ni pakako, Musa waakookele kufuma ku lupili. Waakuutile masiiko a bantu ni kubalondolwela twebo tonse mwaalandiile Yawe. ");
INSERT INTO tap_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ni bantu bonse baitabiile mwakimo balanda nangue, “Bintu byonse byalandanga Yawe tulikukita.” Kupwako, Musa waya kubwezia kapingu kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yawe waamwanine Musa nangue, “Ndikukwizila mu lilezi litikeeme evi bantu beyunvwile ni kukuketekela lyonse musita undikuya nalanda nobe.” Kupwako, Musa wamwana Yawe twebo twaalandilue na bantu. ");
INSERT INTO tap_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kabili Yawe waamwanine Musa nangue, “Ale kooka uye uteanie bantu pa mulandu wa kwiza kwane, ubazuukie lelo ni lukeele ni kubaana bafule ngubo yabo, ");
INSERT INTO tap_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","evi busiku bwa butatu bakabe kusangua baiteaniizie pantu bobo busiku nakaba kukookela pa Lupili lwa Sinai ni bantu bonse bamwene. ");
INSERT INTO tap_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ukabe kusakilila lupili lonse ni kubaana tekuti bakabe kusela ku lolu lupili, ao kwezia kukumiako, kabili tekuti bakabe kutaaluka lusako. Kubalua muntu wakaba kukumia ku lolu lupili wakaba kwipawa. ");
INSERT INTO tap_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ozo muntu wakaba kwipawa sie na kutootua mabue ao kulasua mivui pasili kukumiiwa. Anzia kine ni nama wakaba kwipawa evio nyenka. Inzi ntandala paikaba kulila yakonkeene, bantu bakabe kusela ku lupili.” ");
INSERT INTO tap_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ni pakako, Musa waakookele kufuma ku lupili ni kuya kuzuukia bantu, ni bo baafulile ngubo yabo. ");
INSERT INTO tap_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Waabaanine bantu nangue, “Mu ezi nsiku itatu ikale mwaiteaniizie, kabili tekukumane na mwanakazi.” ");
INSERT INTO tap_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Busiku bwa butatu lukeelekeele, ku lupili kwaali kwali bimpenimpeni ni mitukumo pamo ni lilezi litikeeme, kabili kwaunvwikile lizui likata lya ntandala, ni bantu bonse baali mu mitanda baatutumine na mwezo. ");
INSERT INTO tap_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa waafumiizie bantu mu mitanda ni kubalombola kuti baye bakumane ni Leza. Baile kwimana mwinsina lupili. ");
INSERT INTO tap_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Lupili lonse lwa Sinai lwaakupilue na kyunsi pantu Yawe waakookeelepo wali mu mulilo. Kyunsi kyaafutumukile mu lupili nga kyunsi kya kikuka kikata kya mulilo. Lupili lonse lwaatentele bubi bubi. ");
INSERT INTO tap_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Lizui lya ntandala lulyaakilile kulila na maka, Musa waalandile, Leza ni ye waamwasukile mu mutukumo. ");
INSERT INTO tap_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yawe waakookeele peulu Lupili lwa Sinai ni kumukuuta Musa aselepo. Musa ni ye waaselele pa lupili. ");
INSERT INTO tap_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kabili Yawe waamwanine Musa nangue, “Kooka ubasoke bantu tekuti basakulule lusako ni kwiza kun'mona, pantu kine bakita evio, bengi pakati kabo nga balikufua. ");
INSERT INTO tap_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Babitambua balikun'mpalamina ni bo bapalile kwizuukia, kine te evio ndikubakanda.” ");
INSERT INTO tap_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa waamukanzile Yawe walanda nangue, “Bantu tebavinda kusela pa Lupili lwa Sinai pantu we mwine wakitusoka nangue, ‘Sakilile lusako lwazyungukiile lupili ni kuluzuukia.’” ");
INSERT INTO tap_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yawe waamwasukile evi, “Kooka uye umutwame Haruni usele nakue. Inzi babitambua pamo ni bantu bonse bene tekuti bezie kukiluka lusako ni kwiza kuli nene, pantu nga ndikubakanda.” ");
INSERT INTO tap_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ni pakako, Musa waakookeele ku bantu ni kuya kubaana nga mwa-aniinue Yawe ");
INSERT INTO tap_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Leza waalandile totu twebo tonse nangue, ");
INSERT INTO tap_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nene ndi Yawe Leza obe waakufumiizie mu kyalo kya Misri muwaali wateekelue buzia. ");
INSERT INTO tap_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Teupalile kuya wali na baleza bange inga sie nene. ");
INSERT INTO tap_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Tekwibaazila mikisi ipaleene na bilengua bya mu muulu mu myulu, ao bya pansi pa kyalo, ao bya mu menda pensina kyalo. ");
INSERT INTO tap_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tekufukamina mikisi ao kwipupa, pantu nene Yawe Leza obe ndi Leza wa bunkua, Leza aliwakanda baana pa mulandu wa bubi bwa basibo mpaka ku luvyalo lwa butatu ni lwa buna lwa balia bansuulile. ");
INSERT INTO tap_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Inzi ndinalanga ntono ku nvyalo nfu ya mu balia bantonene ni kusunga mafunde ane. ");
INSERT INTO tap_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Tekuzimbula liina lyane pa mapange abi, pantu ne Yawe Leza obe ndinakanda muntu aliwazimbula Liina lyane pa lisipalile. ");
INSERT INTO tap_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Izukila kuzuukia busiku bwa Sabata. ");
INSERT INTO tap_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mu nsiku mutanda waya wabombamo miilo yobe yonse, ");
INSERT INTO tap_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","inzi busiku bwa kilooba, i Sabata yakua Yawe Leza obe, mu bobo busiku tekubombamo miilo, wewe pamo ni mwana obe mwalalume, ni mwana obe mwanakazi, ni mubombi obe mwalalume, ni mubombi obe mwanakazi, ni nama yobe, pamo ni mweni wa mu nghanda yobe, ");
INSERT INTO tap_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","pantu ne Yawe naalengele myulu ni kyalo, ni myenzi pamo ni byonse bilimo mu nsiku mutanda, ni mu busiku bwa kilooba naatuuziizie. Ni pakako, ne Yawe naapaalile bobu busiku bwa Sabata ni kubuzuukia. ");
INSERT INTO tap_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Kindika so ni noko evi uye wali na nsiku ingi ya kwikala mu kyalo kiulailue na Yawe Leza obe. ");
INSERT INTO tap_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Tekwipaya. ");
INSERT INTO tap_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Tekukita bukende. ");
INSERT INTO tap_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Tekwiba. ");
INSERT INTO tap_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Tekubeepezia mwinobe bya bufi. ");
INSERT INTO tap_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Tekutokamua nghanda ya mwino, tekutokamua muka mwino, ao mubombi wakue mwalalume ao mwanakazi, ao nghombe wakue, ao punda wakue, ao kubalua kantu ka mwino.” ");
INSERT INTO tap_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Bantu lubaamwene bimpenimpeni ni kunvua mutukumo pamo ni lizui lya ntandala, ni lubaamwene lupili lwalimukufwinka kyunsi, baiseelukile koku balimukututuma na mwezo. ");
INSERT INTO tap_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Baamwanine Musa nangue, “Ewe, landa ni fwefue, ni fwefue tulikukunvua, inzi Leza tekuti alande ni fwefue tukeeza kufua.” ");
INSERT INTO tap_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa waabaasukile evi, “Tekutiine pantu Leza eziile kuti amyezie, evi mumane vili maka akue mukeeza kuya mwatwaliliile mu bibalo.” ");
INSERT INTO tap_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Bantu baatwaliliile kwimana kule, inga sie Musa i waapalamiine nfinzi ikata ya lilezi lyaalimo Leza. ");
INSERT INTO tap_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kabili Yawe waamwanine Musa abaane Baizraeli nangue, “Mwakiimwena mwe bene vinakifuma mwiulu ni kwiza kulanda nenu. ");
INSERT INTO tap_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Tekuye mwaikitila baleza ba mutofue ao ba oro ba kuya mwapupa pambali. ");
INSERT INTO tap_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ni pakako, kaba kunkitila kitale kya bulongo ni kwelelapo ngelelo yobe ya kuzizia, ni bupe bwa bupwanikizi bwa pa mikooko yobe ni mbuzi pamo ni nghombe. Kubalua nkendo inaakaba nakusaakwila kuti uye wan'mpupilapo, i panaakaba naiza kumipaalila. ");
INSERT INTO tap_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kine wankuulila kitale kya mabue, tekuti ukakuule na mabue abaazilue, pantu kine wabombia kyela ku azo mabue, waakatiikaania kitale. ");
INSERT INTO tap_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tekuti ukankuulile kitale kyaliko kiselelo, pantu pa kusela muntu kuti wakupunamina ni kumona mubili obe. ");
INSERT INTO tap_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Mizilo inge ya kwana Baizraeli ni ezi: ");
INSERT INTO tap_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kine wasita muzia Muebrania, waakakubombela sie myaka mutanda. Inzi mu mwaka wa kilooba, pa kulubuka kwa ozo muntu tapalile kusia walipako kantu. ");
INSERT INTO tap_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kine waizile kuteekua buzia tanaupe, alubulue wali bunke. Inzi kine waizile kuteekua buzia waupile, alubulue pamo ni mukazi wakue. ");
INSERT INTO tap_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kine selenzi waapeela mwalalume muzia mwanakazi wa kuupa, ni ozo mwalalume wavyalamo baana balalume ao banakazi, ozo mwalalume alubulue sie wene bunke. Inzi mukazi pamo ni baana balikusyala bakua selenzi. ");
INSERT INTO tap_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kine muzia wailandila nangue nene nsitonene kulubuka pantu n'mutonene tawelenzi, ni mukazi wane pamo ni baana bane, ");
INSERT INTO tap_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","selenzi alikuya nakue ku nghanda ya mpupo pa ntanzi yakua Leza ni kumwimika pa mulyango, ao mu miilimiili ya mulyango ni kumufutula kutui na muvui. Ni ozo muntu waakaba wali muzia wakue lonse. ");
INSERT INTO tap_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kine muntu wasisia mwana wakue mwanakazi kuba muzia, wene tapalile kulubulua nga vilivyalubulua mwana mwalalume muzia pa kyamba kya myaka mutanda. ");
INSERT INTO tap_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kine mwana mwanakazi wasisiiwa ku muntu, ni ozo muntu watona kuti abe mukazi wakue, inzi pa kyamba takimutonene, apalile kumusisia paakale kuli se muvyazi. Selenzi tapalile kumusisia ku Bazima pantu taamukitiile biweme. ");
INSERT INTO tap_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kine muntu wasita mwanakazi muzia ni kutona kuti asakue na mwana wakue, ozo muntu asunge ozo mwanakazi nga vi-aliwasunga baana bakue banakazi. ");
INSERT INTO tap_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kine ozo mwana waufiiwa ozo mwanakazi watona kuupilapo unge mwanakazi, apalile kutwalilila kufikilizia bipalile kukitilua mukazi wa mambo mu kumupeela bilio ni ngubo pamo ni nsambu yonse ya kyupo. ");
INSERT INTO tap_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kine wa-andua kufikilizia bebi bintu bitatu, ozo mwanakazi wa mambo alubukile. Kuti waya pasili kusia walipako kantu. ");
INSERT INTO tap_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Muntu kine wauma mwinakue ni kumwipaya, apalile kwipawa. ");
INSERT INTO tap_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Inzi kine ozo muntu tamwipaile na bufue, ni Leza kine walekelela kuti kikitike evio, ozo muntu apalile kubutukila kolia kundikukulanga. ");
INSERT INTO tap_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Inzi kine muntu wamwipaya mwinakue na bufue, anzia abutukila ku kitale kyane, mupalile kumufumiako ni kumwipaya. ");
INSERT INTO tap_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Muntu kine wauma se ao nghina, apalile kwipawa. ");
INSERT INTO tap_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Muntu kine waiba muntu nakue kuti amusisie ao kumwalula muzia, apalile kwipawa. ");
INSERT INTO tap_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Muntu kine wafuupula se ao nghina, apalile kwipawa. ");
INSERT INTO tap_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Bantu kine balwana, ni umopo wamutoota mwinakue libue, ao kumuuma lupi, ni ye pasili kufua, inzi wa-aluka wa pa kasalo, pa-akaba kubuuka ni kutendeka kwendela na kabango kakue, olia wakimuuma alikulekelua, inzi apalile kumundapia ni kumufuta pa mulandu wa nsiku yakipita waleele pa kasalo. ");
INSERT INTO tap_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Selenzi kine wauma muzia wakue mwalalume ao mwanakazi na kabango, ni ye wafua na bebio bipumo, apalile kukandua. ");
INSERT INTO tap_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Inzi kine muzia wakita busiku bumo ao nsiku ibili pasili kufua, selenzi tavinda kukandua pantu ozo muzia ni wa mu bunonsi bwakue. ");
INSERT INTO tap_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kine balalume balimukulwana bapunka mwanakazi emisi mpaka ni liimi lyakue lyainooneka, inzi pasili kukisiiwa, olia wamupunkanga apalile kulipa nfolanga yonse ilikupingulua na mulume nga mulimwapingwila bapinguzi. ");
INSERT INTO tap_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Inzi kine ozo mwanakazi wakitikilua na kibiipiisie, olia wapunkananga alikukitilua kibiipiisie. Kine waipayananga, ni ye alikwipawa, ");
INSERT INTO tap_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","linso pa linso, ni liino pa liino, ni kuboko pa kuboko, ni kuulu pa kuulu, ");
INSERT INTO tap_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kine wazizyanianga, ni ye alikuziziiwa, kine wakisyanianga, ni ye alikukisiiwa, kine wafubulananga, ni ye alikufubulua. ");
INSERT INTO tap_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kine selenzi wauma muzia wakue mwalalume ao mwanakazi ni kumutula linso, ozo muzia apalile kulubulua pa mulandu wa linso lyakue. ");
INSERT INTO tap_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kabili kine selenzi wauma muzia wakue mwalalume ao mwanakazi pa liino, ni lyo lyakuuka, muzia apalile kulubulua pa mulandu wa liino lyakue. ");
INSERT INTO tap_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kine nghombe ndume wapunka mwalalume ao mwanakazi na masengo ni ozo muntu wafua, ozo nghombe apalile kwipawa na kutootua mabue, ni minofu yakue tekuti iliwe. Inzi mwine wa nghombe tekuti epawe. ");
INSERT INTO tap_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kine ozo nghombe ndume aliwapunkapunka bantu, ni mwine wa nghombe kine waasokeluemo kale, ni ye tekuba wamukaka, kusyali ozo nghombe waipaya muntu, nghombe alikwipawa na kutotua mabue, ni mwine wa nghombe alikwipawa. ");
INSERT INTO tap_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kine ozo muntu walombua nfolanga, apalile kulipa kukonkana ni kipendo kyali kulombua, pakuti alubule bukose bwakue. ");
INSERT INTO tap_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ozu muzilo waakaba wabomba ni ku nghombe ndume aliwapunka mwana mwalalume ao mwana mwanakazi. ");
INSERT INTO tap_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kine nghombe ndume waipaya muzia mwalalume ao mwanakazi na masengo, mwine wa nghombe amufute mwine wa muzia na shekeli 30 ya mutofue, nghombe ndume ni ye alikwipawa na kutootua mabue. ");
INSERT INTO tap_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Kine muntu watupukula kiina kyakue ao kine waimba kiina pasili kutupikilapo, ni nghombe ao punda nghwana waponenamo, ");
INSERT INTO tap_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mwine wa kiina alikulipa ku mwine wa nama, ni ozo nama afwile atwamue na mwine wa kiina. ");
INSERT INTO tap_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kine nghombe ndume wakua muntu umo wakisia nghombe ndume wakua muntu unge, ni ozo nghombe ndume wafua, nghombe ndume waipaananga alikusisiiwa, ni baba bantu babili balikukasana ozo nghombe ndume afwile pamo ni nfolanga. ");
INSERT INTO tap_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Inzi kine kimanikile nangue ozo nghombe ndume ali ni mibeele ya kupunkana na masengo, ni mwine tekuba wamukaka, ozo mwine apalile kulipilamo nghombe ndume akosele, ni nghombe ndume afwile alikutwamua na mwine nghombe ndume waipaananga. ");
INSERT INTO tap_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kine muntu waiba nghombe ndume ao mukooko ni kumusinza ao kumusisia, ozo kabooko pa nghombe ndume umo alikulipa nghombe ndume isaano, ni pa mukooko umo alikulipa mikooko ina. ");
INSERT INTO tap_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","“Kine kabooko wasangililua walimukwiba mu nghanda musita wa busiku, waumua ni kwipawa, olia wamwipaya tali na mulandu palua kufua kwakue. Inzi kine wasangililua musita wa koba, waumua ni kwipawa, olia epeene alikuba ni mulandu wa kwipaana. Inzi ozo kabooko apalile kulipa. Kine tali na kantu apalile kusisiiwa nga muzia pa mulandu wa lwibo lwakue. Kine nama wakiibua wasangua wakosele mu minue yakua kabooko, kine ni nghombe ndume, ao kine ni punda, ao kine ni mukooko, ozo muntu apalile kulipilamo mutengo wa ozo nama nghendo ibili. ");
INSERT INTO tap_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kine muntu walekelela biteekua byakue kulia bilimbua nghwana mu bukaba, ao mu bukaba bwa mizabibu, apalile kulipilamo biwamiisie bya mu makaba akue, ao bya mu makaba a mizabibu. ");
INSERT INTO tap_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Muntu kine wakozia mulilo mu bukaba bwakue, ni mulilo wazambukila mu bukaba nghwana ni kuya kuzizia buzombozi nghwana, ozo muntu wakikozia mulilo alikulipilamo belia byakizia. ");
INSERT INTO tap_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Muntu kine waitabila kumusungila mwinakue nfolanga ao binge bintu, ni ezio nfolanga ao bintu byaibua, ozo kabooko kine wamoneka, alikulipilamo nghendo ibili. ");
INSERT INTO tap_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Inzi kine kabooko tamwenekele, ozo mwine wa nghanda alikutwalua ku bapinguzi evi aye asininkizie kine takimwibila mwinakue. ");
INSERT INTO tap_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Mu milandu yonse ya kupusana palua nghombe ndume, ao punda, ao mikooko, ao palua ngubo, ao palua kubalua kantu kazeezele, ni kubalua muntu walanda nangue ozu ni nama wane ao nangue kaka ni kantu kane, babo babili balikutwala milandu ku bapinguzi. Olia alikutanua nsambu na bapinguzi i alikumulipa mwinakue nghendo ibili ya bukindami bwa kekio kintu. ");
INSERT INTO tap_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kine muntu wateekia nghombe ndume, ao punda, ao mikooko ku muntu nakue, ni ozo nama wafua ao kukisiiwa na nama nakue ao kine waibua muntu tekuba wamwene, ");
INSERT INTO tap_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","baba bantu babili balikukita mulapo ntanzi yakua Yawe. Kine Yawe wasininkizia nangue ozo muntu tali na mulandu, mwine wa nama apalile kwitabila bobo bupinguzi, ni olia wakimuteekela tapalile kulipa. ");
INSERT INTO tap_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Inzi kine ozo nama kisinka ebilue, alikumulipa mwine wa nama. ");
INSERT INTO tap_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ozo nama kine wakizanghununua tupusa tupusa na kinama, apalile kutwamapo tupusa twa kusininkiziiziako, ni ye tapalile kulipa ozo nama wakizanghununua. ");
INSERT INTO tap_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Muntu kine wa-azimia nama wakue ku mwinakue, ni ozo nama wakisiiwa ao wafua, mwine wa nama tekuba walipo, ozo muntu wa-azimanga apalile kulipa. ");
INSERT INTO tap_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Inzi kine mwine wa nama wasanguapo pa kufua kwa ozo nama, ozo muntu tapalile kulipa. Kine nama wakiba wali wa kusonkela alikulipako sie musonko wa nama u-akyazima. ");
INSERT INTO tap_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Mwalalume kine wabembia mukazyana wa kisungu asinasakue, ni ye wakumana nakue, apalile kulipa bwimazi ni kumuupa. ");
INSERT INTO tap_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Inzi kine se kwa mwanakazi wakaana kuufia mwana wakue mwanakazi, mwalalume apalile kulipa nfolanga kukonkana ni vibalibalipa ku mukazyana wa kisungu. ");
INSERT INTO tap_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Mwanakazi ndozi tekumulekelela kuba mukose. ");
INSERT INTO tap_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Kubalua muntu aliwakumana na nama apalile kwipawa. ");
INSERT INTO tap_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Muntu aliwaelela ngelelo ku baleza mu kifuka kya kumwelela Yawe, apalile kuloviiwa. ");
INSERT INTO tap_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Tekukitile mweni bibiipile ao kumwemia pantu ni mwe kumo mwaali baeni mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Tekubiibikizie mukanfwilua ao mwana nsiiwa. ");
INSERT INTO tap_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kine mwababiibikizia ni bo bandilila, kisinka ndikunvua malilo abo. ");
INSERT INTO tap_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Naakafiitua ni kumiipaila ku bului, bakazi benu baakaaluka bamukanfwilua, ni baana benu baakaaluka baana nsiiwa. ");
INSERT INTO tap_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kine wakopia nfolanga ku mupabi wa mu bantu bane babuliilue, tekuya wali nga balia balibakopia nfolanga ya kaloba, tekumulomba alundepo ni inge. ");
INSERT INTO tap_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kine muntu watwama ngubo ya muntu mupabi kuti iye yali kikwatizi, apalile kusangua waabweziizie koba lukasinazimine, ");
INSERT INTO tap_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","pantu i ngubo yakue ya kwivimba. Ale alikwivimbaki? Wene kine wandilila, ndikumunvua pantu ndi wa nkumbu. ");
INSERT INTO tap_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tekumufuupula Leza ao kutiipa lisiiko wa bantu bobe. ");
INSERT INTO tap_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Tekukokola kun'mpeela mazabo a mambo a bya kumina byobe. “Kubalua libeli obe mwalalume upalile kun'mpeela nene. ");
INSERT INTO tap_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Mupalile kukita evio ni ku mabeli enu a nghombe ni a mikooko ao a mbuzi. Aza mabeli kuti aikalanke kuli nghinabo nsiku kilooba, kusyali kundeetela busiku bwa mwanda. ");
INSERT INTO tap_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mupalile kuba bantu bane bazuuke. Ni pakako, temupalile kuya mwalia minofu ya nama epailue na kinama mu kisonso, inzi mupalile sie kupoozela tubua. ");
INSERT INTO tap_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Tekuvumia mpunda ya bufi ni kwampana na muntu mubi mu kusininkizia bya bufi. ");
INSERT INTO tap_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tekukonkelela bantu bengi mu kukita bibiipile. Luuliwakuutua kusininkizia mu kilie, tekubembua na bwingi bwa bantu mukwinoona nsambu. ");
INSERT INTO tap_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kabili tekumupeela mupabi nsambu pantu ni mupabi. ");
INSERT INTO tap_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kine wamona nghombe ndume ao punda wakua mulwani obe wazeezele, upalile kumubweziizia mwine. ");
INSERT INTO tap_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kine punda wakua mulwani obe wamusanga waponene wailikiilue na bitwamo, tekumulekeela pa-aponenanga. Sininkizia nangue wamukwasia mulwani obe na kubuusia ozo punda. ");
INSERT INTO tap_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Tekumubiibikizia mupabi mu milandu yakue. ");
INSERT INTO tap_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Iikeke ku busongezi bwa bufi, kabili te kwipaya muntu asili na kilubo ao mulunghami, pantu muntu ali ni bubi nsikamupenda kuba asili na bubi. ");
INSERT INTO tap_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tekupoka bituulilo pantu bituulilo bilibyazibatika menso ni kukalanghania twebo twa balunghami. ");
INSERT INTO tap_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Tekwemia mweni pantu mumanine vili mutima wa mweni, pantu ni mwemue mwaali baeni mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Mu myaka mutanda ukabe wabyalamo ni kuzombola. ");
INSERT INTO tap_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Inzi mu mwaka wa kilooba upalile kulekela bukaba butuuzie, evi bapabi bali pakati kobe bakabe basololamo, ni byaakaba byasyalamo bikabe byaliiwa na nama ya mu kisonso. Evi i vyakuti ukabe wakita mu bukaba bobe bwa mizabibu ni bwa mizeituni. ");
INSERT INTO tap_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Nsiku mutanda waya wabombamo miilo yobe, inzi busiku bwa kilooba upalile kutuuzia, evi nghombe yobe ni bapunda bobe batuuzie. Bazia bobe ni baeni bonse bawikeele nabo ni bo batuuzie. ");
INSERT INTO tap_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Pooze maano ku twebo tunaamyanine. Tekwezie kuzimbula liina lya baleza bange, kabili tekuti lyunvwiwe mu tunua twenu. ");
INSERT INTO tap_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Kubalua mwaka mukabe mwankitilamo nsikunkulu itatu. ");
INSERT INTO tap_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Mukabe mwakita nsikunkulu ya mukate usiliko ntutumusi. Mu nsiku kilooba mukabe mwalia mukate usiliko ntutumusi nga vinaakwanine, mukabe mwakita evio pa nsita ipalile mu mwezi wa Abibu, (pantu mu ozu mwezi i mwezi umwaafumiinemo mu Misri) tekuti kukabe kwali muntu waakaba waiza kuli nene tekuba wali na kantu ka kun'mpeela. ");
INSERT INTO tap_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mukabe mwakita nsikunkulu ya kuzombola mazabo a mambo a mu belia bimwaabyele mu makaba enu. “Mukabe mwakita nsikunkulu ya kuzombola kwa ku mpeleezio ya mwaka kine mwafumia bimwaabyele mu makaba. ");
INSERT INTO tap_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kubalua nghendo itatu pa mwaka, balalume bonse bapalile bakabe baiza kun'mpupa ne Yawe Kabezia Mpungu. ");
INSERT INTO tap_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Tekungelele ngelelo ya nama pamo ni kintu kisanziziweko ntutumusi. Mafuta a nama ya ngelelo yane ya kyungulo teapalile akabe asungua mpaka lukeele lwakue lukeelekeele. ");
INSERT INTO tap_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Buzombozi bwa mambo bwa mu makaba enu mupalile mukabe mwabutwala mu Nghanda yakua Yawe Leza wenu. “Tekuti mukabe mwaeleka mwina mbuzi mu mabeele akua nghina. ");
INSERT INTO tap_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Unvue, ndikumitumina malaika wakumitangilila ni kumisunga mu lwendo evi akabe kumifikia bwino ku nkendo inakimiteaniizia. ");
INSERT INTO tap_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kansi poozeko maano a kumunakila, tekumulengie kufiitua evi akamyeleele bilubo byenu, pantu aliwakita byonse mu Liina lyane. ");
INSERT INTO tap_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Inzi kisinka kine mwemue mwaunvua ni kukita byonse bindimukulanda, ndikuya nali mulwani wa balwani benu, ni kulua na balia balibalwana nenu. ");
INSERT INTO tap_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malaika wane wakaba kumitangilila ni kumitwala ku kyalo kya Ba-amori, ni kya Bahiti, ni kya Baperizi, ni kya Bakanaani, ni kya Bahivi pamo ni kya Bayebusi, ni bo nakaba kubalovia. ");
INSERT INTO tap_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tekuti mukabe mwafukamina baleza babo ao kubapupa, tekuti mukabe mwakita mubalibakitila. Inzi mukabe kubeenoona, ni kuvunghania mapumpu abo. ");
INSERT INTO tap_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mwemue mupalile kumubombela sie Yawe Leza wenu, ni ye waakaba wapaalile bilio byenu, ni menda enu, ni ne naakamikingilila ku malwele. ");
INSERT INTO tap_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mu kyalo kyenu temukaba mwanakazi wa kupisia liimi, kabili temukaba nghumba. Mwaakeekala nsiku ingi ");
INSERT INTO tap_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Naakatuma bya kutiinia byane bikabe byamitangiliile ni kuvulunghania bantu bonse konse kumwaakalunghama, ni balwani benu bonse baakamifunghamina ni kubutuka. ");
INSERT INTO tap_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Naakatuma nzuki yaakamitangilila kuya kukumba Bahivi, ni Bakanaani pamo ni Bahiti. ");
INSERT INTO tap_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nsikabakumba bonse mu mwaka umo, evi kyalo tekuti kikasyale kibolia, ni nama ya mu kisonso tekuti ikakile kuvula ni kumikila maka. ");
INSERT INTO tap_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Naakaba nabakumba baniini baniini mpaka pamukasanduluka ni kupyana kyalo. ");
INSERT INTO tap_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Kabili naakabiika mupaka wenu kutula ku Lyezi lya Kasi mpaka ku lyezi lya Bafilistini, ni kufuma ku kaseeba mpaka ku Mwenzi wa Efrati. Nene naakababiika bene kyalo mu maboko enu kuti mukabakumbe. ");
INSERT INTO tap_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tekuti mukakite nabo kipingo ao kukita kipingo na baleza babo. ");
INSERT INTO tap_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Tekuti mukabeetabizie kwikala mu kyalo kyenu pantu nga baakamilengia kunduvia, kine mukabombele baleza babo, mwaakakwatua mu muteo wa kupupa mikisi.” ");
INSERT INTO tap_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Pa kyamba, Yawe waamwanine Musa nangue, “Mutwame Haruni, ni Nadabu, ni Abihu pamo ni masiiko 70 a Baizraeli usele nabo kono ku lupili, evi mwize mun'mpupe mwaliko lwa kule. ");
INSERT INTO tap_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Wewe sie bunke i etabiilue kumupalamina Yawe. Baba bange tekuti bezie kusela pamo nobe peulu lupili ni kun'mpalamina.” ");
INSERT INTO tap_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ni pakako Musa waile kubaana bantu twebo tonse ni milao yonse yaalandile Yawe pamo ni mafunde onse. Bantu bonse baitabiile balanda nangue, “Tulikukita byonse mwalandilanga Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kabili Musa waalembele kubalua keebo ka-aapeelue na Yawe. Lukeele lwakue paakili lukeelekeele waabuukile ni kukuula kitale mwinsina lupili ni kwimika mapumpu lyanondo ni abili a mabue emaniineko mikowa lyanondo ni ibili ya Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Pa kyamba, waatumine balumendo ba mu Baizraeli kuti baye bamwelele Yawe ngelelo ya kuzizia ni kumusinzila nghombe ndume kuba bupe bwa bupwanikizi. ");
INSERT INTO tap_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa waabuulilemo ntibu ya mulopa, waubiika mu bibakuli, ni unge wausansila pa kitale. ");
INSERT INTO tap_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kabili waabuulile kitabu kya kipingo ni kubabelengela bantu batwiliziizie. Bonse baalandile evi, “Byonse byalanda Yawe tulikubikita ni kubinakila.” ");
INSERT INTO tap_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Pa kyamba, Musa waabuulile mulopa waali mu bibakuli, wausansila ku bantu walanda nangue, “Ozu i mulopa wa kipingo kyakua Yawe ki-akikita pamo nenu pa kumipeela aza mafunde onse.” ");
INSERT INTO tap_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kabili Musa ni Haruni, ni Nadabu, ni Abihu pamo ni masiiko 70 a Baizraeli, baaselele ku lupili. ");
INSERT INTO tap_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Koko ku lupili kubaile, baamumwene Leza wakua Izraeli. Mwinsina makasa akue mwaali mwali kintu kyaali kyakitilue na safiri, kyaali kyali nga lyulu lisambikile. ");
INSERT INTO tap_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Anzia baamumwene Leza, tebaakitiilue kibiipile. Baaliile bilio ni kumina pa ntanzi yakue. ");
INSERT INTO tap_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yawe i lu-aamwanine Musa nangue, “Ale sela wize pano pandi peulu lupili, musita uulikuba pano, ndikukupeela bibazu bibili bya mabue anembelepo mizilo ni milao ya kubasambilizia.” ");
INSERT INTO tap_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ni pakako Musa waaseekeziiziwe na mubombi wakue Yoshua. Musa waaselele ku lupili lwakua Leza. ");
INSERT INTO tap_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa ntanzi ya kusela wa-anine masiiko a Baizraeli nangue, “Syale mwatupembeele pano mpaka musita utwakaba kubwela. Unvue, kine muntu wa-aluka ni mulandu, autwale kuli Haruni ni Huri.” ");
INSERT INTO tap_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa lu-aali wali koko ku lupili, lupili lwaakupiliilue na lilezi. ");
INSERT INTO tap_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Bulumba bwakua Yawe bwaali pa lolo Lupili lwa Sinai. Lupili lwaakupiliilue na lilezi nsiku mutanda, ni mu busiku bwa kilooba, Musa waunvwile lizui lyakua Yawe lyamukuuta mu lilezi. Monekelo ya bobo bulumba bwakua Yawe, Baizraeli baabumwene bwaali nga mulilo uliwazizia peulu lupili. ");
INSERT INTO tap_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ni pakako, Musa waingiile mu lilezi ni kutwalilila kusela peulu lupili. Musa waikeele ku lupili nsiku 40 busiku ni koba. ");
INSERT INTO tap_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ana Baizraeli bandeetele bupe. Kubalua bupe bubalikufumia mutoneene mitima yabo, i bwa kuti mupokelele. ");
INSERT INTO tap_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bupe buwakaba kupokelela ni bobu: Oro, ni mutofue, ni mukuba, ");
INSERT INTO tap_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ni nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, ni ya kitani kiweme, ni masako a mbuzi, ");
INSERT INTO tap_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ni kipapa kya mpanga kisubilueko mukumino wa kasi, ni kipapa kya kipomo, ni kimuti kya kasiiya, ");
INSERT INTO tap_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ni mafuta a mizeituni a mu litala, ni manukato a kubiika ku mafuta azuuke, ni ku bubaani buweme, ");
INSERT INTO tap_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ni mabue a oniksi, pamo ni mabue a kubiika ku efodi ni ku mufuko wa pa nkulo wakua Kitambua Mukulu. ");
INSERT INTO tap_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Kabili bakankitile liema lizuuke, evi nkabe naikeele pakati kabo. ");
INSERT INTO tap_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Bapalile kunghimikila Tabernakulo ni kukita kubalua kantu nga mundikukwanina. ");
INSERT INTO tap_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Baane bakakite lisanduku lya mbao ya kimuti kya kasiiya. Likabe lyaleepele metre imo ni santimetre 25, mu bukata likabe lyatanine santimetre 75, ni mu kutuuluka likabe lyatuulukile santimetre 75, ");
INSERT INTO tap_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","kabili bakakupeako oro isambikile mukati ni panze. Mumbali bakabe kuzyungulusiamo lufito lwa oro. ");
INSERT INTO tap_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Bakakite bikobo bina bya oro ni kubibiika ku tufuli tuna twa lisanduku. Bibili ku bwala bumo ni bibili ku bunge bwala. ");
INSERT INTO tap_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kabili bakakite mipingo ibili ya kimuti kya kasiiya ni kukupako oro. ");
INSERT INTO tap_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Mipingo ya kupingilako bakabe kwi-ingizia mu bikobo bya ku lisanduku kumbali yonse ibili. ");
INSERT INTO tap_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ezio mipingo ikabe yaikaliliile sie mu bikobo bya lisanduku pasili kufumiamo. ");
INSERT INTO tap_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mu lelio lisanduku ukabiikemo bibazu bibili bya mabue binakaba kukupeela, papo palembelue mizilo. ");
INSERT INTO tap_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Bakakite ntupiko ya oro isambikile. Ezio ntupiko ikabe yaleepele metre imo ni santimetre 25, ni mu bukata santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Bakakite makerubi abili atililue bwino ali a oro, ni kuemika ku mpeleezio ibili ya ntupiko mu kuleepa. ");
INSERT INTO tap_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Bakakite likerubi limo ku mpeleezio imo, ni linge ku inge mpeleezio. Azo makerubi akabe akitiliilue ku ntupiko ku mpeleezio yakue ibili. ");
INSERT INTO tap_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Azo makerubi akabe alendwile mapaapi abo mu muulu lya pa ntupiko akupilile lisanduku, ni nkebu yabo yakenteene lya pa ntupiko. ");
INSERT INTO tap_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mu lisanduku ukabiikemo belia bibazu bibili bya mabue binaakakapeela ni kutupikilapo ntupiko. ");
INSERT INTO tap_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Papo i panaakaba nasaakaana nobe, kabili i panaakaba nalanda nobe peulu ntupiko, pa bukata bwa azo makerubi abili ali peulu Lisanduku lya Kipingo, ni kulanda nobe palua mafunde onse akuti ukabe wabaana Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Bakakite meza ya kimuti kya kasiiya ileepele metre imo ni mu bukata yatanine santimetre 50, ni mu kutuuluka ikabe yatuulukile santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Bakakupeko oro isambikile, ni mumbali bakazyungulusiamo lufito lwa oro. ");
INSERT INTO tap_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Bakazyungulusie lufito lwatuulukile santimetre mwanda, kusyali kupisia ni mukovio wa oro ku lufito. ");
INSERT INTO tap_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Bakakite bikobo bina bya oro ni kubibiika ku tufuli tuna twa meza lya palia pabeeleele mikonzo. ");
INSERT INTO tap_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Bakabiike bikobo pepi na mbao ya pa muulu. Momo i mwakwingizia mipingo ya kupingilako meza. ");
INSERT INTO tap_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Bakakite mipingo ya kimuti kya kasiiya ni kukupako oro. Ezio mipingo ikabe ya kupingilako meza. ");
INSERT INTO tap_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Bakakite masaani, ni mpindi, ni bibakuli pamo ni makopo a kubombia ku bupe bwa bya kumina. Bebio bibombelo byonse bya pa meza bakakite byali bya oro isambikile. ");
INSERT INTO tap_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ukabiike ni mikate ya kilangililo pa meza ya kuti ikabe yali pa ntanzi yane lyonse. ");
INSERT INTO tap_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Bakakite kya kuteekapo matala kya oro itililue yasambikile bwino. Kya kwimikapo pamo ni mukonzo wakue, ni tubakuli twakue twali nga maluba, ni mapingu akue pamo ni maani akue, bikabe byalundeene kumo. ");
INSERT INTO tap_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ku ozo mukonzo umo kukabe kwafumine misambo mutanda. Misambo itatu ku bwala bumo, ni inge itatu ku bunge bwala. ");
INSERT INTO tap_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ku musambo umo kukabe kwali tubakuli tutatu tuli nga maluba a almonde ali ni mapingu pamo ni maani a azo enka maluba. Ku musambo unge ni ko bakakiteko evio vyenka mpaka ku misambo yonse mutanda yakaba yafumine ku ozo mukonzo. ");
INSERT INTO tap_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ni ku mukonzo wa pa bukata uli pa kya kuteekapo kuye kwali tubakuli tuna tuli nga maluba a almonde ni mapingu pamo ni maani a azo enka maluba. ");
INSERT INTO tap_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ntanzi ya kufika pa misambo ibili pakabe lipingu lya liluba limo. Kikabe kyali evio ku misambo ibili ya mambo, ni ku misambo ibili ya bubili, pamo ni ku misambo ibili ya butatu. ");
INSERT INTO tap_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mukonzo ni misambo yakue yonse bikabe byakitiliilue kumo ni kya kuteekapo. Kyonse kikabe kyali kya oro itililue yasambikile. ");
INSERT INTO tap_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Bakakite azo matala kilooba ni ku-aleemia kuti akabe asanikiile ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Bakakite nmano pamo ni bisaani bya kekio kya kuteekapo matala, bebio byonse bikabe byali bya oro isambikile. ");
INSERT INTO tap_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Bakakite kya kuteekapo matala pamo ni bibombelo byonse na kilo 35 ya oro isambikile. ");
INSERT INTO tap_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Poozako maano kuti bakakite kubalua kantu nga vinaakulangisiizia ku lupili. ");
INSERT INTO tap_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Bakakite Tabernakulo yakua Leza na bipempe lyanondo bya kitani kiweme kipyatilue bwino na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi pamo ni ya mukumino wa kasi. Balia bamanine kulenga bakalengemo makerubi. ");
INSERT INTO tap_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kubalua kipempe kikabe kyaleepele metre lyanondo ni ina, ni mu bukata kyatanine metre ibili. Bipempe byonse bikabe byalingheene. ");
INSERT INTO tap_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Bipempe bisaano bakabilundanie kuti kikabe kimo, ni binge bisaano kubilundania kuti kikabe kimo. ");
INSERT INTO tap_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Bakakite mikobelo ya ngubo ya mukumino wa lyulu ku mpeleezio ibili ya kipempe kimo, ni ku kinge kipempe bakakite evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Bakakite mikobelo 50 ku kipempe kimo, ni inge mikobelo 50 ku kipempe kinge. Ezio mikobelo ikabe yakenteene. ");
INSERT INTO tap_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Bakabiike bikobo 50 bya oro bya kulundania kumo bipempe bibili pakuti Tabernakulo ikabe kintu kimo. ");
INSERT INTO tap_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Bakakite bipempe lyanondo ni kimo bya masako a mbuzi ni kubivimba peulu Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kubalua kipempe kikabe kyaleepele metre lyanondo ni isaano, ni mu bukata metre ibili. Bebio bipempe lyanondo ni kimo bikabe byalingheene. ");
INSERT INTO tap_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Bipempe bisaano bakabilundanie kumo, ni binge mutanda ni byo kumo. Kelia kipempe kya mutanda bakakipete lya ku ntanzi pakuti Tabernakulo ikabe kintu kimo. ");
INSERT INTO tap_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Bakakite mikobelo 50 lya ku mpeleezio ya kipempe kimo, ni inge mikobelo 50 lya ku mpeleezio ya kipempe kinge. ");
INSERT INTO tap_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kabili bakakite bikobo 50 bya mukuba ni kwingiziamo mikobelo pakuti bipempe bikabe byalundeene, evi Tabernakulo ikabe kintu kimo. ");
INSERT INTO tap_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ni kelia kiputu kya kipempe kyaakapulamo, ukakikupe ku kyamba kya Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kiputu kya kipempe kyaakasyalako mu kuleepa, kelia kyaakaba kyali santimetre 50 ku bwala bumo, ni ku bunge bwala santimetre 50, i kyaakaba kyakupiliile Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Bakakite mpapa ya mpanga isubilueko mukumino wa kasi ya kuvimba peulu Tabernakulo, kabili bakakite ni inge mpapa ya bipomo ni yo bakavimbe peulu mpapa ya mpanga. ");
INSERT INTO tap_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Bakeemike kipuupa kya Tabernakulo na mbao ya kasiiya. ");
INSERT INTO tap_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kubalua lubao lukabe lwaleepele metre isaano, kabili lukabe lwatanine santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kubalua lubao lukabe lwali na matui abili kwinsina, matui a kukwatania mulongo wa mbao. Evi i vyakuti bakakite mbao yonse ya ku Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Bakakite mbao 20 lya ku nkungulua ya Tabernakulo, ");
INSERT INTO tap_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ni kukita bintu 40 bya mutofue bya kwimikuamo mbao 20. Mu bintu bibili mukabe mwaimikua matui abili a lubao lumo, ni mu binge bibili ni mo evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ni ku bunge bwala bwa Tabernakulo, lya ku nkungua ni ko kukabe mbao 20, ");
INSERT INTO tap_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ni bintu 40 bya mutofue bya kwimikuamo. Bya kwimikuamo bibili ni byo mukengiziiwe matui abili a lubao lumo. ");
INSERT INTO tap_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kumusana wa Tabernakulo, lya ku mboosi bakeemikeko mbao mutanda, ");
INSERT INTO tap_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ni mbao ibili ikeemikue mu tufuli twa Tabernakulo ku kyamba. ");
INSERT INTO tap_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ezio mbao ibili ya mutufuli ipalile ikeemikue yakuminkeene kutula pansi, ni pa muulu ikakuminkaniiwe na kikobo, bakakite evio mu tufuli tonse tubili. ");
INSERT INTO tap_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ni pakako, yaakaba yali mbao mwanda, ni bintu bya mutofue bya kwimikuamo byakaba byali lyanondo ni mutanda. Bya kwimikuamo bibili bikabe byaingiziwamo matui abili a lubao lumo, ni binge evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Bakakite mbango ya kimuti kya kasiiya, mbango isaano pa mbao ili ku lubali lumo lwa Tabernakulo, ");
INSERT INTO tap_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ni inge isaano pa mbao ili ku bunge bwala bwa Tabernakulo, kabili inge isaano pa mbao ili ku kyamba kya Tabernakulo ku mboosi. ");
INSERT INTO tap_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Lubango lwa pa bukata bwa mbao lwene lukabe lwapulilemo koku ni koku. ");
INSERT INTO tap_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ezio mbao bakakupeko oro, kabili bakakite ni bikobo bya oro bya kukwatizia mbango, ni ezio mbango bakakupeko oro. ");
INSERT INTO tap_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Bakeemike Tabernakulo nga viwakilangisiiwa ku lupili. ");
INSERT INTO tap_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kabili bakakite kipempe kya nyunzi ya mukumino wa lyulu, ni wa bulumbi pamo ni wa kasi, pamo ni ngubo ya kitani kiweme kya nyunzi ipyatilue, ni kukifwanizia na kubilamo nkebu ya makerubi. Ezio miilo ikabombue na bantu bamaniisie. ");
INSERT INTO tap_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Bakakobeke kipempe ku mapumpu ana a kimuti kya kasiiya akupilueko oro. Bikobo byakue bikabe byali bya oro pa bintu bina bya mutofue bya kwimikuamo. ");
INSERT INTO tap_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Bakakobeke kipempe ku bikobo evi Lisanduku lya Kipingo likabe ku kyamba kya kipempe, pantu kipempe i kyakaba kyalekenkaniizie Kifuka Kizuukiisie. ");
INSERT INTO tap_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Bakabiike ntupiko peulu Lisanduku lya Kipingo mu kifuka kizuukiisie. ");
INSERT INTO tap_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kunze ya kipempe kikingiliile Kifuka Kizuukiisie bakabiikeko meza lya ku nkungua ya Tabernakulo, kusyali kubiika kinara lya ku nkungulua kyakenteene ni meza. ");
INSERT INTO tap_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Bakakite kipempe kya pa mulyango wa Tabernakulo, kipempe kya nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni kitani kiweme kipyatilue. Ikabe yaali miilo ya muntu amaniisie kubila. ");
INSERT INTO tap_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Bakakite mapumpu asaano a kimuti kya kasiiya ni kukupako oro, koko i kuwaakakobeka kipempe na bikobo bya oro. Bakasungulule ni bya kwimikuamo bisaano bya mukuba pa mulandu wa mapumpu. ");
INSERT INTO tap_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Bakakite kitale kya mbao ya kimuti kya kasiiya. Kitale kikabe kyaleepele metre ibili ni kitika, ni mu bukata kikabe kyali metre ibili ni kitika. Kekio kitale peulu kikabe kyalingheene monse monse, kabili kikabe kyatuulukile metre imo ni kitika. ");
INSERT INTO tap_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Mu tufuli tuna bakabiikemo mbao ituulukile nga masengo, mbao yakuti ikabe yalundanizie kitale. Kekio kitale kikabe kyakupilueko mukuba. ");
INSERT INTO tap_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Bakakite bya kuzoolelapo mito, ni bipawa, ni bibakuli, ni bikobo, ni bya kubiikapo mulilo. Bebi bibombelo byonse bya ku kitale bikabe byali bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Bakakite kasaaso ka mukuba ka ku kitale ni kubiika bikobo bina bya mukuba ku tufuli tuna twa kasaaso. ");
INSERT INTO tap_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Bakabiike kako kasaaso mukati kitale, kwinsina lubao luzyungulukiile kitale, evi kako kasaaso kakabe kafikile pa bukata mu kutuuluka. ");
INSERT INTO tap_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Bakakite mipingo ya kimuti kya kasiiya, mipingo ya kupingilako kitale. Bakakupeko mukuba ku ezio mipingo. ");
INSERT INTO tap_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ezio mipingo yaakengiziiwa mu bikobo evi ikabe yali mumbali ibili ya kitale musita wa kukipinga. ");
INSERT INTO tap_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kekio kitale kikakitue kyazikukile mukati. Ukabaane bakakite nga viwakilangisiiwa ku lupili. ");
INSERT INTO tap_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Kabili bakakite musolo wa Tabernakulo. Ku lubali lwa ku nkungulua bakakite luuba lwa kipempe kya kitani kiweme kipyatilue. Kekio kipempe kikabe kyaleepele metre 50 bwala bumo. ");
INSERT INTO tap_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Bakakite mapumpu 20 ni bintu bya kwimikuamo 20 bya mukuba, bikobo bya ku mapumpu ni mikobelo yakue bikabe bya mutofue. ");
INSERT INTO tap_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ku lubali lwa ku nkungua ni ko bakakiteko evio vyenka. Kukabe kipempe kya kitani kileepele metre 50, ni mapumpu akue 20, ni bintu bya kwimikuamo 20 bya mukuba. Bikobo bya ku mapumpu ni mikobelo yakue bikabe bya mutofue. ");
INSERT INTO tap_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Lya ku mboosi kukabe luuba lwa kipempe kileepele metre 25, kukabe mapumpu lyanondo ni bya kwimikuamo lyanondo. ");
INSERT INTO tap_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Bukata bwa musolo lya ku kabanga kukabe metre 25 mu bukata. ");
INSERT INTO tap_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Ni luuba lwa kipempe ku lubali lumo lwa mulyango lukabe lwaleepele metre kilooba ni kitika, mapumpu akue atatu, ni bya kwimikuamo bitatu. Ni ku bunge bwala kukabe luuba lwa kipempe luleepele metre kilooba ni kitika, mapumpu akue atatu, ni bya kwimikuamo bitatu. ");
INSERT INTO tap_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ku mulyango wa musolo kukabe luuba lwa kipempe kileepele metre lyanondo, kya mukumino wa lyulu, ni wa bulumbi, ni wa kasi pamo ni kitani kiweme kipyatilue. Ezio miilo ikabombue na bantu bamaniisie. Kekio kipempe kikabe kyakwatiliilue na mapumpu ana ni bya kwimikuamo bina. ");
INSERT INTO tap_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mapumpu onse a musolo mumbali monse akabe ni mikobelo ya mutofue, bikobo byonse ni byo bikabe bya mutofue, ni bya kwimikuamo bikabe byali bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ozo musolo ukabe waleepele metre 50, ni mu bukata ukabe watanine metre 25 kubalua lubali. Luuba lwa musolo lukabe lwaatuulukile metre ibili ni kitika. Lukabe lwali lwa kitani kiweme kipyatilue, ni bya kwimikuamo bikabe bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Bibombelo byonse bya kubombiiwa ku Tabernakulo mu miilo ilekenkeene, pamo ni bikili byonse bya ku Tabernakulo ni ku luuba lwa musolo, bikabe bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ukabaane Baizraeli bakabe bakuleetela mafuta aweme a mizeituni pa mulandu wa kisue, evi matala akabe aleemene musita onse. ");
INSERT INTO tap_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Azo matala ali mu Tabernakulo kunze ya kipempe kili ku ntanzi ya Lisanduku lya Kipingo, Haruni ni baana bakue balalume i baakaba ba-awamia evi akabe aleemene ntanzi yane kutula kyungulo mpaka lukeelekeele. Leli i lifunde lya muyayaya ku nvyalo ya ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ale pa Baizraeli nsoobwelepo Haruni mukuluubo pamo ni baana bakue balalume, Nadabu, ni Abihu, ni Eliazari pamo ni Itamari, kuti ban'mombele mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ukamuzukiizie Haruni mukuluubo ngubo ya kuti ikabe yamuleeteele bulumba ni bukindami. ");
INSERT INTO tap_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ukabaane bantu bonse bakengeele mu kubomba, balia banaapeele mutima wa mulangue, bakakite ngubo yakua Haruni kuti ikazuukiiwe, evi akabe wan'mombela mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ngubo i baakakita ni ezi: Mufuko wa pa nkulo, ni efodi, ni kazula, ni nkanzu, ni kitambala pamo ni musipi. Bakamukitile Haruni mukuluubo ngubo izuuke, wene pamo ni baana bakue, evi bakabe bavwala musita wa kubomba mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bakengezi ba ozo mwilo bakabombie oro ni nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni kitani kiweme. ");
INSERT INTO tap_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Bakengezi ba ozo mwilo bakakite efodi na oro, na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni kitani kiweme. ");
INSERT INTO tap_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ezio efodi ikabe yali na mikobelo ibili ya kupisia pa nkombe kuti ikabe yalundaniizie kya ku ntanzi ni kya ku musana. ");
INSERT INTO tap_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ni musipi upalile ukabe wakitilue bwino na bintu bikitiilueko efodi, kuti ukabe wali kimo nakio, ni o ukakitue na nyunzi ya mukumino wa oro, ni wa nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni ya kitani kiweme kipyatilue. ");
INSERT INTO tap_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Bakabuule mabue abili a oniksi ni kulembapo meena lyanondo ni abili a bena Izraeli. ");
INSERT INTO tap_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Meena mutanda pa libue limo, ni ange mutanda pa linge libue kukonkana ni mubaavyaliilue. ");
INSERT INTO tap_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ozo mwilo ukabombue na muntu amanine kulemba pa mabue nga evelia vilivyalembua kamanino, akalembe meena a bena Izraeli pa mabue abili ni ku-abiika mu tukwatililo twa oro. ");
INSERT INTO tap_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ozo muntu akabililile azo mabue abili peulu mikobelo ipitile pa nkombe yafumine ku efodi, pakuti akabe aimaniineko mikowa lyanondo ni ibili ya Baizraeli. Evi Haruni i vi-aliwaakaba watwama meena abo pa nkombe ntanzi yakua Yawe, pakuti Yawe akabe wabalanguluka. ");
INSERT INTO tap_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Toto tukwatililo twa azo mabue tukabe twa oro. ");
INSERT INTO tap_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Akakite ni mikufu ibili ya oro isambikile. Akakite yali nga nkamba ipyatilue, kusyali kukobeka ku toto tukwatililo. ");
INSERT INTO tap_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Mukengezi wa ozo mwilo akamukitile Haruni mufuko wa pa nkulo wa kumaninako bupinguzi bwakua Leza, akakite na nyunzi yaakitiilueko efodi: Na nyunzi ya mukumino wa oro, ni ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni ya kitani kiweme kipyatilue. Evi i vyakuti akakite. ");
INSERT INTO tap_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ozo mufuko ukapimpuemo limo walingheene monse monse. Mu kuleepa ni mu bukata ukabe wali na santimetre 25. ");
INSERT INTO tap_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Akakiteko milongo ina ya tukwatilililo twa kubiikamo mabue a mutengo ukata. Mu mulongo wa mambo akabiikemo libue lya akiki, ni lya topazi, pamo ni lya emerodi. ");
INSERT INTO tap_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mu mulongo wa bubili akabiikemo libue lya zumaridi, ni lya yakuti lya mukumino wa lyulu, ni lya almasi. ");
INSERT INTO tap_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mu mulongo wa butatu akabiikemo libue lya yakinto, ni lya agata, ni lya ametisti. ");
INSERT INTO tap_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mu mulongo wa buna akabiikemo libue lya berile, ni lya oniksi, ni lya yaspi. Azo mabue onse akabe akwatiliilue na tukwatililo twa oro. ");
INSERT INTO tap_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Azo mabue akabe ali lyanondo ni abili, kubalua libue pakalembue liina limo lya pa meena a bena Izraeli. Kubalua libue limo pakalembue liina limo liimaniineko mukowa umo. ");
INSERT INTO tap_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ku ozo mufuko wa pa nkulo ukakitileko mikufu ya oro isambikile ili nga nkamba ipyatilue. ");
INSERT INTO tap_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kabili akakite tuzele tubili twa oro ni kutubiika ku tufuli tubili twa ozo mufuko wa pa nkulo. ");
INSERT INTO tap_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Akakobeke mikufu ibili ya oro mu tuzele tubili tuli ku tufuli twa mufuko wa pa nkulo. ");
INSERT INTO tap_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mpeleezio inge ibili ya ezio mikufu akakobeke ku tukobo tubili twa oro ni ku-ilundania ku elia mikobelo ya pa nkombe ya ku efodi lya pa ntanzi. ");
INSERT INTO tap_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kabili akakite tuzele tubili twa oro ni kutubiika ku tufuli tubili twa ku mufuko wa pa nkulo kwinsina lya mukati pepi ni efodi. ");
INSERT INTO tap_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kabili akakite ni tunge tuzele tubili twa oro ni kutukobeka lya kwinsina mikobelo ya pa nkombe lya ku ntanzi ya efodi pepi ni kilundilo peulu musipi usukilue. ");
INSERT INTO tap_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tuzele twa ku mufuko wa pa nkulo tukalundaniwe ku tuzele twa ku efodi na mikobelo ya nyunzi ya mukumino wa lyulu, evi mufuko ukabe wali lya peulu musipi wa efodi usukilue bwino, ni ozo mufuko wa pa nkulo tekuti ukabe walekenkana na efodi. ");
INSERT INTO tap_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Evi Haruni i vi-aliwaakaba watwama meena a Baizraeli pa mufuko wa pa nkulo wa bupinguzi, pa mutima wakue musita u-aliwaakaba waingila mu kifuka kizuuke ntanzi yakua Yawe, pakuti Yawe akabe wabalanguluka. ");
INSERT INTO tap_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Mu ozo mufuko wa pa nkulo wa bupinguzi, mukabiikue Urimu ni Tumimu, ni byo byaakaba peulu mutima wakua Haruni musita u-aliwaakaba waingila mu kifuka kizuuke ntanzi yakua Yawe. Evi Haruni i vi-aliwaakaba ni buvinde bwa kumana mutoneene Leza pa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Akakite kazula ka kuvwalilapo efodi ka mukumino wa lyulu. ");
INSERT INTO tap_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ni ko kakabe ni lipulo pa bukata lya kupuziamo mutue, kakabe kasukilue bwino mumbali lipulo, evi tekuti kakazabuke. ");
INSERT INTO tap_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Kwinsina kazula konse bakakakeko komamanga isukilueko nyunzi ya mukumino wa lyulu, ni wa bulumbi, ni wa kasi. Bakabiike ni ndibu ya oro yatolokele komamanga imo imo yazyungulukile kwinsina konse. Evio i vyakuti bakabiike ndibu ya oro yatolokele komamanga imo imo yazyungulukile kwinsina konse. ");
INSERT INTO tap_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haruni waakaba wavwala kako kazula musita wa kubomba mwilo wa bukitambua, ni lizui lya ndibu lyaakaba lyaunvwika pa kwingila kwakue mu kifuka kizuuke ntanzi yakua Yawe, ni musita wakufuma akeeza kufua. ");
INSERT INTO tap_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Bakakite kalilata ka oro isambikile ni kulembapo nangue, ‘Muzuuke wakua Yawe.’ Ukalembe nga vilivyalembua kamanino. ");
INSERT INTO tap_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kako kalilata ka oro bakakakeko mikobelo ya mukumino wa lyulu, evi Haruni akabe wakavwala pa mpala peulu kitambala. ");
INSERT INTO tap_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Nga Haruni vi-aliwaakaba wakavwala pa mpala lyonse, i vi-aliwaakaba watwama bubi bwa Baizraeli bubaakaba bakita pa kungelela ngelelo yabo ya bintu bizuuke, evi bakabe baitabilua ntanzi yakua Yawe. ");
INSERT INTO tap_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Bakamukitile Haruni kazula ka kitani kiweme, ni kitambala kya kitani kiweme, pamo ni musipi ufwaniziiziwe bwino. ");
INSERT INTO tap_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Baana balalume bena Haruni ni bo ukabakitile nkanzu ni misipi pamo ni bisote, bya kubaleeteela bulumba ni bukindami. ");
INSERT INTO tap_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ni we Musa, ukamuvwike mukuluubo Haruni bivwalo byakue, ni baana bakue bivwalo byabo, kabili ukabasube mafuta ni kubazuukia evi bakabe ban'mombela mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Bakabakitile tuputula twa kitani evi tukabe twakupile mibili yabo, toto tuputula tukabe twafumine mu kitungu mpaka mu matanta. ");
INSERT INTO tap_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruni ni baana bakue balalume bakabe bavwala toto tuputula musita wa kwingila mu Tabernakulo, ao musita wakusela ku kitale ku kwelela ngelelo mu kifuka kizuuke, evi tekuti bakabe balangisia mibili yabo bakeeza kufua. Ozu muzilo waakaba wali wa muyayaya kuli wene ni ku nvyalo yakue.” ");
INSERT INTO tap_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Pa kumuzuukia Haruni ni baana bakue balalume ni kubabiika pa mwilo wa bukitambua kuti ban'mombele, ukabuule nghombe ndume umo musoka ni mpanga ibili isilemeene. ");
INSERT INTO tap_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Kabili ukabuule bunga bunekekele bwa nghano busiliko ntutumusi ni kukitamo mukate, ni mikate isonsele isanziiziweko mafuta, pamo ni mikate iniini yondele. ");
INSERT INTO tap_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ukabiike ezio mikate mu kipanda kimo ni kundeetela luwaakaba waelela nghombe ndume, ni mpanga ibili. ");
INSERT INTO tap_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Ukamuleete Haruni ni baana bakue balalume pa mulyango wa Tabernakulo ni kubasamba na menda mubeeleele lifunde. ");
INSERT INTO tap_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ukabuule nkanzu, ni kazula ni efodi pamo ni mufuko wa pa nkulo, kusyali kumuvwika Haruni pantu ezio i ngubo ya bukitambua, mane ukamukake ni musipi usukilue bwino wa efodi. ");
INSERT INTO tap_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ukamuvwike kitambala ku mutue wakue ni kukakilila kalilata kazuuke ka oro peulu kitambala. ");
INSERT INTO tap_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Mane ukabuule mafuta azuuke ni kumwitilila pa mutue kuti ukamuzuukie. ");
INSERT INTO tap_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Ukabaleete baana balalume bena Haruni ni kubavwika kubalua muntu nkanzu yakue. ");
INSERT INTO tap_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ukabakake ni misipi mu bitungu, ni kubavwika bisote ku mitue. Evi i vyakuti ukamuzuukie Haruni ni baana bakue balalume kuti bakabe babomba mwilo wa bukitambua muyayaya. ");
INSERT INTO tap_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ukaleete nghombe ndume ku ntanzi ya Tabernakulo, mane Haruni pamo ni baana bakue bakabiike maboko abo pa mutue wa nghombe ndume. ");
INSERT INTO tap_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ukamusinze ozo nghombe ndume ntanzi yakua Yawe pa mulyango wa Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ukatubie munue obe mu mulopa ni kusuba ku mbao ituulukile nga masengo ku kitale, ni mulopa wakasyalamo ukawitile kwinsina kitale. ");
INSERT INTO tap_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ukabuule mafuta onse ni bya munda, ni tuete twa ku mabu, ni nfio yakue ibili pamo ni mafuta aliko ni kubizizia peulu kitale kuba ngelelo. ");
INSERT INTO tap_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Inzi minofu ya nghombe ndume, ni kipapa pamo ni bya munda, ukabizizie kunze ya mitanda. Ezi i ngelelo ya kufumia bibalo bya babitambua. ");
INSERT INTO tap_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Pa elia mpanga ibili ukabuulepo umo, ni kumwana Haruni ni baana bakue balalume bakabiike maboko abo pa mutue wa ozo mpanga. ");
INSERT INTO tap_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ukasinze mpanga, ni kubuula mulopa wakue ni kusansila ku kitale mumbali yonse. ");
INSERT INTO tap_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ozo mpanga ukamuteetanie bipusa bipusa, ukasambe bya munda ni myendo yakue, mane ukabibiike byonse pa kitale pamo ni mutue. ");
INSERT INTO tap_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ukazizie mpanga walingi pa kitale. Ozo mpanga akabe wali ngelelo ya kuzizia ya bunu buweme, bupe bwa kuzizia bupeelue Yawe. ");
INSERT INTO tap_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Ukabuule olia mpanga wa bubili, ni kumwana Haruni ni baana bakue balalume bakabiike maboko abo pa mutue wa ozo mpanga. ");
INSERT INTO tap_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ukamusinze ozo mpanga, ukatubie munue obe mu mulopa ni ku-usuba ku kalebelebe ka ku kutui kwa kulio kwakua Haruni ni ku matui a kulio a baana bakue balalume, ni ku binkumua byabo bya ku maboko a kulio pamo ni ku bikondo bikata bya ku makasa abo a kulio. Ozo mulopa waakasyalamo ukausansile ku kitale mumbali yonse. ");
INSERT INTO tap_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ukabuule mulopa wa pa kitale pamo ni mafuta azuuke, ukamusansile Haruni pamo ni baana bakue, kabili ukasansile ni ku ngubo yabo yonse, evi Haruni ni baana bakue balalume bakabe bali bazuuke pamo ni ngubo yabo yonse. ");
INSERT INTO tap_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ku ozo mpanga ukabuuleko mafuta, ni mukila uli ni mafuta, ni mafuta akupilile bya munda, ni tuete twa ku mabu, ni nfio ibili pamo ni mafuta akupileko, ni mwendo wa kulio. Ukakite evio pantu ni mpanga wa ngelelo palua kubiikua kwa babitambua pa miilo izuuke. ");
INSERT INTO tap_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Mu kipanda kya mikate isiliko ntutumusi kili ku ntanzi yakua Yawe ukabuulemo mukate umo wa munzyungulu, ni mukate umo utikeeme usanziiziweko mafuta a mizeituni, ni mukate umo umaatikile. ");
INSERT INTO tap_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Bebi byonse ukabibiike mu minue yakua Haruni, ni mu minue ya baana bakue balalume, ni bo bakabitensie ntanzi yakua Yawe, kuba bupe bwa kutensia. ");
INSERT INTO tap_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kusyali ukabibuule mu minue yabo ni kubizizia pa kitale pamo ni ngelelo ya kuzizia kuti ikabe bunu bumuwamiine Yawe, bupe bwa kuzizia bupeelue Yawe. ");
INSERT INTO tap_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Ukabuule kabambo ka mpanga wa ngelelo palua kubiikua kwakua Haruni pa mwilo wa bukitambua, evi ukantensiizie ne Yawe. Ni kaka kabambo kaakaba kobe. ");
INSERT INTO tap_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ukazuukie kabambo ka ngelelo ya kutensia, ni mwendo wa ngelelo ya kulendulua, bebio bifumiiziwe ku mpanga asaakwilue ku mwilo uzuuke. Kabambo kaakaba kakua Haruni, ni mwendo waakaba wa baana bakue babitambua. ");
INSERT INTO tap_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Evi Baizraeli i vibaakaba bakitila Haruni ni baana bakue balalume babitambua. Bobo i bwaakaba bupe bwa bupwanikizi bubaakaba ban'mpeela ne Yawe. Ozu i waakaba wali muzilo wa muyayaya. ");
INSERT INTO tap_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Bivwalo bizuuke byakua Haruni, byaakaba byavwalua na kubalua muntu wa mu luvyalo lwakue waakaba wapyana pa ozo mwilo wa bukitambua, pa kyamba kya kufua kwakua Haruni. ");
INSERT INTO tap_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Kitambua mwina Haruni waakamupyana Haruni pa kyamba kya kufua kwakue, waakakita nsiku kilooba wavwele ezio ngubo, mane pa kyamba akengile mu Tabernakulo kuti abombele mu kifuka kizuuke. ");
INSERT INTO tap_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ukabuule bipusa bya ozo mpanga wa ngelelo palua kubiikua kwa babitambua pa miilo izuuke, ni kubifulumiizia mu musolo wa kifuka kizuuke. ");
INSERT INTO tap_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruni ni baana bakue balalume bakabe balia bebio bipusa bya mpanga pamo ni mukate uli mu kipanda kili pa nghingililo ya Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Bakabe balia belia bintu bibaapwanikiziiziweko pa kubabiika pa mwilo wa bukitambua ni kubazuukia, inzi muntu unge tekuti akalieko pantu bebio bilio bizuukile. ");
INSERT INTO tap_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ni bilio byeleelue palua kubiikua pa mwilo wa bukitambua kine byasyalapo mpaka lukeelekeele, tekuti bikaliiwe, inzi bikaziziiwe pantu bebio bilio bizuukile. ");
INSERT INTO tap_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Evi i vyakuti ukakitile Haruni ni baana bakue balalume kukonkana ni byonse binakikwana. Ozo mwilo wa kubabiika pa bukitambua ukakitue mu nsiku kilooba. ");
INSERT INTO tap_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kubalua busiku ukabe wafumia nghombe ndume wa bupe bwa kibalo pa mulandu wa bupwanikizi. Mu kukita evio waakaba wasamba kitale. Ukabe wasubako mafuta ni kwizuukia musita uwaakaba wabakitila bupwanikizi. ");
INSERT INTO tap_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mu nsiku kilooba kubalua busiku ukabe wakita bupwanikizi pa mulandu wa kitale, ni kitale kyaakaba kyazuukiisie. Kubalua kintu kyaakaba kyakumia ku kitale kyaakaba kyazuuka.” ");
INSERT INTO tap_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ngelelo iwaakaba waelela pa kitale kubalua busiku ni ezi: Misoka ibili ya mpanga ya mwaka umo. ");
INSERT INTO tap_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ukabe waelela musoka umo lukeelekeele, ni unge kyungulo. ");
INSERT INTO tap_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pa elia ngelelo ya mambo ya musoka wa mpanga, ukabe waelela pamo ni kamo ka pa lyanondo ka bunga bunekekele butwilue bwino bwasanziiziwemo litre imo ni kitika ya mafuta a mizeituni, ni litre imo ni kitika ya divai kuti ikabe ngelelo ya kumina. ");
INSERT INTO tap_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ni pa musoka wa bubili wa mpanga wa ngelelo ya kyungulo ukabe wakita nga muwaakaba wakitila ngelelo ya mambo ya lukeelekeele, kuba bunu buweme, bupe bwa kuzizia bupeelue Yawe. ");
INSERT INTO tap_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Evi i vyakuti ukabe wakita wewe pamo ni nvyalo ya ku ntanzi. Mwaakaba mwaelela ngelelo ya kuzizia pa mulyango wa Tabernakulo ntanzi yakua Yawe, papo panaakaba nasaakaana nobe ni kulanda nobe. ");
INSERT INTO tap_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Papo i panaakaba nasaakaana na Baizraeli, ni pa ezio nkendo paakaba pazukiiwa na bulumba bwane. ");
INSERT INTO tap_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Tabernakulo ni kitale naakabizuukia, kabili naakazuukia Haruni ni baana bakue balalume pakuti bakabe ban'mombela mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Papo i panaakaba naikeele pamo ni Baizraeli, kabili naakaba Leza wabo. ");
INSERT INTO tap_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ni bo baakamana nangue nene ndi Yawe Leza wabo waabafumiizie mu kyalo kya Misri, evi ngie nali pamo nabo. Nene i Yawe Leza wabo. ");
INSERT INTO tap_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ukakite kitale kya kimuti kya kasiiya kya kufunkiiziapo bubaani. ");
INSERT INTO tap_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ukakite kyalingheene monse monse, kikabe kyali na santimetre 50 mu kuleepa ni mu bukata. Mu kutuuluka kikabe kyali metre imo. Bintu bituulukile nga masengo bikabe byalundeene na kitale. ");
INSERT INTO tap_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Peulu ni mumbali monse pamo ni ku mbao ituulukile nga masengo, ni ku mikonzo yonse ina ukakupeko oro isambikile, mane kabili peulu lya mumbali ukazyungulusiamo mukovio wa oro. ");
INSERT INTO tap_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ukakite bikobo bibili ku bwala bumo bwa kitale, ni binge bibili ku bunge bwala mwinsina olia mukovio wa oro. Mu bebio bikobo i mwakwingizia mipingo ya kupingilako. ");
INSERT INTO tap_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ezio mipingo ukakite ya kimuti kya kasiiya, kabili ukakupeko oro. ");
INSERT INTO tap_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kekio kitale ukakibiike pa ntanzi ya kipempe kili pepi ni Lisanduku lya Kipingo lili ni ntupiko, papo panaakaba nasaakaana nobe. ");
INSERT INTO tap_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kubalua busiku lukeelekeele, Haruni pa-akaba wawamia matala, akabe wafunkia bubaani buweme pa kekio kitale. ");
INSERT INTO tap_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ni musita wa kyungulo, Haruni pa-akaba waleemia matala, akabe wafunkia bubaani kuti bukabe ngelelo ya muyayaya ntanzi yakua Yawe ku nvyalo ya ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Pa kekio kitale tekuli kufunkiapo bubaani busipalile, ao kwelelapo ngelelo ya kuziziiwa, ao bupe bwa bunga, ao kwitililapo bupe bwa bya kumina. ");
INSERT INTO tap_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Limo mu mwaka, Haruni waakaba wakita bupwanikizi pa kitale pa elia mbao ituulukile nga masengo. Bobu bupwanikizi bwa limo mu mwaka, bupalile bukabe bwakitua na mulopa wa ngelelo ya bupwakizi pa mulandu wa bibalo bya nvyalo ya ku ntanzi, pantu keki ni kitale kizuukiisie kuli Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kabili Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Paukaba wapenda Baizraeli, kubalua mwalalume apalile akabe wamupeela Yawe nfuto pa mulandu wa bukose bwakue, evi kimina tekuti kikabe kyali pakati kabo musita wakubapenda. ");
INSERT INTO tap_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kubalua mwalalume waakaba wapendua, apalile akabe wafumia kipendo kya grama isaano ya mutofue kibiikilue mu kifuka kizuuke. Bobu bwaakaba bwali bupe bwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kubalua muntu wa mu balia baakaba bapendua ali na myaka 20 ni kukilapo, i waakaba wafumia bobo bupe bwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Anzia aya wali munonsi ao mupabi, apalile kufumia kipendo kimonke kya grama isaano ya mutofue kibiikilue mu kifuka kizuuke lu-aliwamufumiizia Yawe bupe bwa bupwanikizi pa mulandu wa bukose bwakue. ");
INSERT INTO tap_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Wewe waakapokelela bobo bupe bwa bupwanikizi kufuma ku Baizraeli ni kububombia kuwamiiziako Tabernakulo, evi bukabe bwali bupe bwa malanguluzi pa mulandu wa Baizraeli ntanzi yakua Yawe. Ezio i nfuto ya bukose bwenu.” ");
INSERT INTO tap_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ukakite musambilo wa mukuba wa kusambilamo ni kya kuteekapo kya mukuba. Ukauteeke pa bukata bwa kitale ni Tabernakulo, mane ukabiikemo menda. ");
INSERT INTO tap_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruni ni baana bakue balalume bakabe basambamo ku maboko ni ku makasa abo. ");
INSERT INTO tap_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Bapalile bakabe basamba ntanzi ya kwingila mu Tabernakulo, ni musita ubaakaba bapalama ku kitale kuti babombe mwilo wa kumufumiizia Yawe bupe bwa kuzizia. ");
INSERT INTO tap_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ni pakako, Haruni ni baana bakue balalume baakaba basamba ku maboko ni ku makasa abo bakeeza kufua. Ozu waakaba wali muzilo wa muyayaya kuli Haruni ni baana bakue balalume pamo ni ku nvyalo ya ku ntanzi.” ");
INSERT INTO tap_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ukabuule bintu bili ni bunu buweme: Manemane a menda kilo isaano, ni mudalasini ununkiile bwino kilo ibili ni kitika, ni kane inunkiile bwino kilo ibili ni kitika, ");
INSERT INTO tap_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ni kida kilo isaano kukonkana ni kipendo kya mu kifuka kizuuke, pamo ni mafuta a mizeituni litre ina. ");
INSERT INTO tap_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ukakite mafuta azuuke. Azo mafuta akakitue na bantu bamanine kusanzia bebio bintu, akabe ali mafuta akuzuukiiziako. ");
INSERT INTO tap_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kabili ukasube mafuta ku Tabernakulo pamo ni ku Lisanduku lya Kipingo, ");
INSERT INTO tap_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ni ku meza pamo ni ku bibombelo byakue byonse, ku kinara pamo ni ku bibombelo byakue byonse, ku kitale kya kufunkiiziapo bubaani, ");
INSERT INTO tap_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ku kitale kya kuziziiziapo ngelelo pamo ni ku bibombelo byakue byonse, ku musambilo pamo ni ku kya kuteekapo. ");
INSERT INTO tap_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ukabizuukie kuti bikabe byazuukiisie. Kubalua kintu kyaakaba kyakumia bebio bibombelo kyaakaba kyazuuka. ");
INSERT INTO tap_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Haruni ni baana bakue balalume ukabasube mafuta azuuke ni kubazuukia kuti bakabe ban'mombela mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ukabaane Baizraeli nangue, ‘Aza i akaba mafuta ane azuuke akaba asubua bantu pa mwilo wa bukitambua mu nvyalo ya ku ntanzi. ");
INSERT INTO tap_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Aza mafuta tekuti akabe asubua pa mubili wa muntu asili kitambua, kabili tekuti ukabe wakita mafuta a ozu musango na bintu byaakakitiluako aza mafuta, pantu azuukile. Kabili aakaba ali azuuke lyonse kuli mwemue. ");
INSERT INTO tap_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kubalua muntu aliwasanzia mafuta nga aza ni kusuba muntu asili kitambua, waakafumiiwa pakati ka Baizraeli.’” ");
INSERT INTO tap_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kabili Yawe waamwanine Musa nangue, “Buula bintu bya bunu buweme: Bya butonvu bwa natafi, ni bwa shekeleti, ni bwa kelbena, ni bwa bubaani buweme. Bebi bintu byonse bikabe mu tulingo twalingheene. ");
INSERT INTO tap_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ku bebi i kuwaakakita bubaani bwa bunu buweme bukitilue na bantu bamanine kukita. Bobo bubaani bukabe bwalimo ni mukele pakuti bukabe bwasambikile ni buzuukile. ");
INSERT INTO tap_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ukapelepo bubaani buniini ukabubiike ntanzi ya Lisanduku lya Kipingo mu Tabernakulo pa nkendo inakaba nasaakaana nobe. Bwaakaba bwali bubaani buzuukiisie kuli wewe. ");
INSERT INTO tap_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kabili tekuti mukabe mwaikitila bubaani bwa ozu musango na bintu byaakakitiluako bobu bubaani, pantu bwaakaba bwali buzuuke kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kine kukabe muntu waakaikitila bubaani nga bobu kuti abubombie ku mubili wakue, waakafumiiwa pakati ka Baizraeli.” ");
INSERT INTO tap_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Namusaakula Besaleli wa mu mukowa wakua Yuda, mwana mwalalume mwina Uri, mwinzikulu wakua Huri ");
INSERT INTO tap_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ni kumwizuzia Mweo wane. Nakimupeela maano, ni mulangue, pamo ni kumana kubomba miilo ilekenkeene ");
INSERT INTO tap_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","kuti akite bintu bya maano mu kukita bintu bya oro, ni bya mutofue, pamo ni bya mukuba, ");
INSERT INTO tap_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ni kukita mabue a kufwanizia, ni kubaza bimuti, pa mulandu wa kubomba miilo ilekenkeene. ");
INSERT INTO tap_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Kabili unvua, nakimusaakula ni Aholiabu mwana mwalalume mwina Ahisamaki wa mu mukowa wakua Dani evi aye wamukwasia. Kabili ni bange bonse nakibapeela buvinde bwa kukita byonse binakikwana kukita: ");
INSERT INTO tap_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tabernakulo, ni Lisanduku lya Kipingo, ni ntupiko pamo ni bibombelo byonse bya mu Tabernakulo, ");
INSERT INTO tap_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ni meza pamo ni bibombelo byakue, ni kinara kya oro isambikile ni bibombelo byakue byonse, pamo ni kitale kya bubaani, ");
INSERT INTO tap_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ni kitale kya kuziziiziapo ngelelo ni bibombelo byakue, ni musambilo pamo ni kya kuteekapo, ");
INSERT INTO tap_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ni ngubo isukilue bwino, ngubo izuuke yakua Haruni ni ya baana bakue balalume, ngubo ya kuvwala musita wa kubomba mwilo wa bukitambua, ");
INSERT INTO tap_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ni mafuta azuuke, pamo ni bubaani bwa bunu buweme pa mulandu wa mu kifuka kizuuke. Bakakite bebio bintu byonse nga vinakikwana.” ");
INSERT INTO tap_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Baane Baizraeli bakabe basunga busiku bwa Sabata yane, pantu i kalangi pakati kenu ni nene pamo ni nvyalo ya ku ntanzi, evi mukabe mwamanine nangue nene ndi Yawe aliwamizuukia. ");
INSERT INTO tap_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kansi mukabe mwasunga Sabata pantu ni izuuke. Kubalua muntu asikaba wasunga Sabata waakeepawa. Onse waakaba wabomba mwilo mu bobo busiku, waakafumiiwa pa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nsiku mutanda ya mu mulungu mwaakaba mwabombamo miilo. Inzi busiku bwa kilooba, bwene ni Sabata, busiku bwa kutuuzia kwine kwine, busiku buzuuke kuli Yawe. Onse wakabomba mu busiku bwa Sabata, waakeepawa. ");
INSERT INTO tap_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ni pakako, Baizraeli ni nvyalo ya ku ntanzi, bapalile kusunga bobu busiku bwa Sabata pantu i kipingo kya muyayaya. ");
INSERT INTO tap_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kaka i kalangi kaakabeelelela pakati ka Baizraeli ni nene, pantu ne Yawe naalengele myulu ni kyalo mu nsiku mutanda, inzi busiku bwa kilooba nsyaabombele, naatuuziizie.” ");
INSERT INTO tap_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Yawe lu-aapwile kulanda na Musa ku Lupili lwa Sinai, waamupeele Musa bibazu bibili bya mabue byaali byalembeluepo mizilo na munue wakua Leza. ");
INSERT INTO tap_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Bantu lubaamwene nangue Musa wakokola pasili kukooka kufuma ku lupili, baamukolonghaniine Haruni ni kumwana nangue, “Iza utukitile leza wakuti aye watutangiliile pantu ozu Musa wakitufumia mu kyalo kya Misri, tetumanine kyakimukitikila.” ");
INSERT INTO tap_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ni pakako, Haruni waabaanine evi, “Vuule ntimbi ya oro ku matui a bakazi benu, ni a baana benu balalume ni banakazi, mundeetele.” ");
INSERT INTO tap_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bantu bonse baavuulile ntimbi ya oro yaali ku matui abo ni kumutwalila Haruni. ");
INSERT INTO tap_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Haruni waapokeleele ntimbi yabo ya oro, waisungulula ni kupongwela mu kintu kyaafumiizie mukisi wa nghombe musoka. Baizraeli baalandile evi, “We Izraeli, ozu i leza obe waakufumiizie mu kyalo kya Misri.” ");
INSERT INTO tap_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Haruni lu-aamwene evio, waakuulile kitale ntanzi ya mukisi wa nghombe musoka. Waalandile nangue, “Lukeele kwakaba nsikunkulu yakua Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Lukeele lwakue baabuukile paakili lukeelekeele baya kwelela ngelelo ya kuzizia ni kutwala bupe bwa bupwanikizi. Bantu baikeele pansi kuti balie ni kumina. Pa kyamba, baabuukile ni kutendeka kukinda. ");
INSERT INTO tap_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yawe waamwanine Musa nangue, “Lenga ukooke pantu bantu bobe baawafumiizie mu kyalo kya Misri babala kibalo kikata. ");
INSERT INTO tap_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Baba bantu baluba kale pantu balekela kukonka binaabaanine. Basungulula oro ni kwikitila mukisi wa nghombe musoka. Baupupa pamo ni ku-uwelela ngelelo balimukulanda nangue, ‘We Izraeli ozu i leza obe waakufumiizie mu kyalo kya Misri.’ ");
INSERT INTO tap_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yawe waamwanine Musa nangue namona baba bantu vibafinine mitima. ");
INSERT INTO tap_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ni pakako, tekunkania kubakanda ni kubalovia pantu nabafiitilua. Inzi wewe pamo ni nvyalo yobe ndikumikita kuba mutundu ukata.” ");
INSERT INTO tap_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Inzi Musa waamupaapeete Yawe Leza wakue wamwipuzia nangue, “We Yawe, ni kiki kyalengia kufiitilua bantu bobe bawaafumiizie mu kyalo kya Misri na buvinde ni maka obe? ");
INSERT INTO tap_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kine wakita evi, Bamisri bakaba kulanda nangue Leza waabafumiizie Baizraeli mu Misri na mapange abi a kubeepaila mu mpili ni kubalovia pa kyalo. We Yawe, fuukia kipuki kyobe, tekukitila bantu bobe bibiipile. ");
INSERT INTO tap_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Languluka babombi bobe, Abrahamu ni Izaaki pamo ni Yakobo, balia baawalaile we mwine nangue waakalengia nvyalo yabo ikasanduluke ni kuvula nga ntanda ya mu lyulu, ni kubapeela kyalo kiwaabalaile kuti baakakipyane muyayaya.” ");
INSERT INTO tap_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ni pakako, Yawe wa-alulwile mapange abi a mutima wakue palua bubi bu-aalandile kukitila bantu bakue. ");
INSERT INTO tap_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa waapilibukile ni kubamba kukooka ku lupili watweme bibazu bibili bya mabue byaali byalembeluepo mizilo kumbali ibili kubalua kibazu. ");
INSERT INTO tap_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Leza i waakitile bebio bibazu, ni azo malembo aali alembelue na mwine Leza. ");
INSERT INTO tap_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua lu-aunvwile mazui a bantu baali basaamiizie, waamwanine Musa nangue, “Koku ku mitanda kuli nsungu ya bului.” ");
INSERT INTO tap_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa waalandile evi, “Ezi nsungu te ya bwanzio bwa bului, ao ya kwanziwa ku bului, inzi ni nsungu ya bantu balimukwimba nghimbo ya nsansa.” ");
INSERT INTO tap_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Lubaapaleeme ku mitanda, Musa waamwene mukisi wa nghombe musoka ni bantu balimukukinda. Musa waafiitilue ni kupooza bibazu bya mabue pansi mwinsina lupili, ni byo byatobeka. ");
INSERT INTO tap_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Pa kyamba waabuulile ozo mukisi wa nghombe musoka ubaakitile, wauzizia mu mulilo, waupela mpaka wa-aluka nga lufunko. Waapuupiile lolo lufunko mu menda ni kubapatikizia Baizraeli bamine. ");
INSERT INTO tap_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa waamwanine Haruni nangue, “Ewe, baba bantu bakikukitaki pakuti ubalengie kukita kibalo kyabiipile evi?” ");
INSERT INTO tap_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruni wa-asukile nangue, “We tawelenzi, tekufiitua. Umanine bwino nangue baba bantu bali ni kasonto ka kukita bibiipile. ");
INSERT INTO tap_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Baizile kunghana evi, ‘Iza utukitile leza wakuti aye watutangiliile pantu ozu Musa wakitufumia mu kyalo kya Misri, tetumanine kyakimukitikila.’ ");
INSERT INTO tap_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nene i lunakibaana nangue onse ali ni ntimbi ya oro ku matui avuule andeetele, kupwako, ban'mpeela, ni ne naipoza mu mulilo, penka papo mukisi wa nghombe musoka wamoneka.” ");
INSERT INTO tap_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa lu-aamwene nangue Haruni waabalekeleele kukita mubatoneene, ni kubalengia kuba ba mpuni ku balwani babo, ");
INSERT INTO tap_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","waile kwimana pa nghingililo ya mitanda walanda evi, “Onse amutonene Yawe eze kuli nene.” Balawi bonse baamukolongheene Musa. ");
INSERT INTO tap_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Musa i lu-aabaanine nangue, “Yawe Leza wakua Izraeli walanda nangue kubalua muntu pakati kenu atwame kipanga kyakue ni kuya kupita mu mitanda waipaya wa kwakue, ni kibuza wakue pamo ni onse u-apalameene nakue.” ");
INSERT INTO tap_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Balawi baakitile muba-aniinue na Musa. Bobo busiku baipaile bantu mu pepi 3,000. ");
INSERT INTO tap_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa waabaanine Balawi nangue, “Lelo mwaizuukia mwe bene pantu temwakituntumbila kwipaya baana benu ni ba kwenu. Leza amipaale.” ");
INSERT INTO tap_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Lukeele lwakue Musa waabaanine Baizraeli nangue, “Mwakibala kibalo kikata. Inzi ndikuya paakale ku lupili kuli Yawe ngie n'mipaapaatile, pange kuti wamyeleela kibalo kyenu.” ");
INSERT INTO tap_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa lu-aile kuli Yawe, waalandile evi, “Ee, kisinka baba bantu bakibala kibalo kikata. Baakiikitila leza akitilue na oro. ");
INSERT INTO tap_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ni pakako, nakupaapaata weleele kibalo kyabo. Inzi kine wakaana, vuwa liina lyane liwaalembele mu kitabu kyobe kya bukose.” ");
INSERT INTO tap_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yawe waamwanine Musa nangue, “Onse wakinduvia i unakaba kuvuwila liina lyakue mu kitabu kyane kya bukose. ");
INSERT INTO tap_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ale endo ulombole Baizraeli ubatwale pa nkendo inakikwana, uye watangiliilue na malaika wane. Inzi musita paukaba kukumana, nakaba kubakanda pa mulandu wa kibalo kyabo.” ");
INSERT INTO tap_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yawe i lu-aakandile babo bantu na kimina kikata kya malwele pantu baamwanine Haruni abakitile mukisi wa nghombe musoka. ");
INSERT INTO tap_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yawe waamwanine Musa nangue, “Ale fuma pano, wewe ni bantu bawaafumizie mu kyalo kya Misri, uye nabo mu kyalo kinalaile kupeela Abrahamu, ni Izaaki pamo ni Yakobo lunaalandile nangue keki i kyalo kinaakapeela nvyalo yobe. ");
INSERT INTO tap_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Naakatuma malaika wakuti akabe wamitangiliile, kabili naakakumba Bakanaani, ni Ba-amori, ni Bahiti, ni Baperizi, ni Bahivi pamo ni Bayebusi. ");
INSERT INTO tap_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mwakaba kwingila mu kyalo kiizuzimo mabeele ni kapelo, inzi nene nsikaba kuya pamo nenu nkeeza kumiloviizia mu nzila pantu muli babisanguka ni bafinine mitima.” ");
INSERT INTO tap_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Bantu lubaunvwile ezio mpunda ibi, baalilile. Ni pakako, baavuulile bifwanizio byabo. ");
INSERT INTO tap_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pantu Yawe waali wamwanine Musa abaane Baizraeli nangue, “Mwemue muli bantu bafinine mitima. Kine naezia kuya nenu, anzia kine ni kamusita kaniini, ndikumilovia. Kansi vuule bifwanizio byenu, evi n'mone vindikukita.” ");
INSERT INTO tap_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ni pakako, kutula musita ubaafumine pa lupili lwa Horebu, Baizraeli te baavwele kabili bifwanizio byabo. ");
INSERT INTO tap_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa waali ni mibeele ya kutwama liema ni kuliimika kunze, kule ni mitanda, ni lyo lyaali lyakuutua liema lya kusaakaaninamo. Kubalua muntu waali ni ka kumwipuzia Yawe, waali wafuma mu mitanda ni kuya mu liema lya kusaakaaninamo kunze ya mitanda. ");
INSERT INTO tap_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musa lu-aali wafuma ni kuya ku lelio liema, kubalua muntu waali waimana mu mulyango wa ku mutanda wakue wakenteleele mpaka musita u-alikwingila mu liema. ");
INSERT INTO tap_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa lu-aaliwaingila mu liema, lipumpu lya lilezi lyaali lyakooka ni kwimana pa mulyango wa liema, Yawe lu-aali walanzyania ni Musa. ");
INSERT INTO tap_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bantu bonse lubaali bamona lipumpu lya lilezi lyaimana pa mulyango wa liema, kubalua muntu waali waimana ni kupupa pa mulyango wa mutanda wakue. ");
INSERT INTO tap_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yawe waali walanda bakenteene ni Musa nga muntu alimukulanzyania na kibuza wakue. Pa kyamba, Musa waali wafuma ni kubwelela ku mitanda. Inzi mulumendo Yoshua, mwana mwina Nuni, mubombi wakua Musa, taali wafuma mu liema. ");
INSERT INTO tap_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa waamwanine Yawe nangue, “Unvua, wewe wakilanda evi, ‘Fumia baba bantu,’ inzi tewakinghana kine nani unakaba kuya nakue. Wakilanda sie nangue, ‘Nkumanine mu liina lyobe, ni evi nkwitabiile.’ ");
INSERT INTO tap_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kansi evi kine ungitabiile, nsambilizie nzila yobe pakuti nkumane, ni kwitabilua ntanzi yobe. Nakulomba wizukile nangue ezi ntundu i bantu bobe.” ");
INSERT INTO tap_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yawe waamwasukile evi, “Nakaba kuya pamo nobe ni kukupeela kutuuzia. Kubalua kantu kaakaba ka kuwamiine” ");
INSERT INTO tap_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa waamwanine evi, “Kine teukaba kuya pamo ni fwefue, tekuti ukabe kutufumia pano. ");
INSERT INTO tap_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ale bantu kuti bamana syani nangue ungitabiziizie nene ni bantu bobe kine teuya pamo ni fwefue? Kine waya pamo ni fwefue ulikutulengia kuba bantu bebeeleeleko pa bantu bonse bali pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yawe waamwanine Musa nangue, “Ndikukita evio vyenka muwalandila, pantu unghwamiine, kabili nkumanine mu liina lyobe.” ");
INSERT INTO tap_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa waalandile evi, “Nakupaapaata unangisie bulumba bobe.” ");
INSERT INTO tap_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yawe waamwasukile evi, “Nakaba kupisia buwame bwane bonse pa ntanzi yobe ni kusimikila Liina lyane ‘Yawe’ pa ntanzi yobe. Kabili nakaba kulangisia buwame ku onse unaakatona kulangisia buwame, ni kweleela onse unaakatona kweleela. ");
INSERT INTO tap_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Inzi wewe teuvinda kunkenta ku lukebu lwane, pantu muntu tavinda kumona lukebu lwane ni kusyala wakosele, ");
INSERT INTO tap_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","inzi wewe imana nane pa ozu mwalala. ");
INSERT INTO tap_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Musita ulikupita bulumba bwane, ndikukuzindika mu mulale wa mwalala ni kupita nakuvimbiliile kuboko kwane. ");
INSERT INTO tap_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Pa kyamba nasyapitile, ndikukuvimbula kuboko kwane, ni we ulikumonako sie musana wane, inzi lukebu lwane teulumona.” ");
INSERT INTO tap_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yawe waamwanine Musa nangue, “Ale kita bibazu bibili bya mabue nga belia bya mambo, evi nembepo twebo tumonke twaali pa belia bibazu bya mambo biwaatobele. ");
INSERT INTO tap_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Iiteanie lukeele lukeelekeele ukabe kusela pano pa Lupili lwa Sinai ni kusaakaana ni nene peulu lupili. ");
INSERT INTO tap_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tekuti ukabe kwiza na unge muntu, ku lupili tekuti kukamoneke unge muntu, mwinsina lupili ni mo tekuti mukamoneke mukooko ao nghombe, ao mbuzi wa kulia bikusi.” ");
INSERT INTO tap_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ni pakako, Musa waabaazile bibazu bibili bya mabue byaali nga belia bya mambo, waabuuka paakili lukeelekeele, wasela ku Lupili lwa Sinai nga mwa-aniinue na Yawe, watwama ni bebio bibazu bibili bya mabue mu minue yakue. ");
INSERT INTO tap_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kupwako Yawe waakooka mu lilezi litikeeme, waimana ni Musa pa lupili, Yawe wasimikila Liina lyakue mwine, “Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kabili Yawe waapitile ku ntanzi yakua Musa walimukulanda nangue, “Yawe, Yawe! Ne Leza ezuzi nkumbu ni buwame, asiizi kulenga kufiitua, ne wa ntono ikata ni wa kisinka. ");
INSERT INTO tap_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ndi ni ntono ku nvyalo nfu ingi, ndinaeleela bubi ni bilubo pamo ni bibalo. Inzi nsiizi kubula kukanda mubi. Ndinakanda baana ni benzikulu, pa mulandu wa bubi bwa basiibo ni bwa basiibokulu mpaka ku luvyalo lwa butatu ni lwa buna.” ");
INSERT INTO tap_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Penka papo Musa wafwinamina kale pansi ni kupupa. ");
INSERT INTO tap_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Musa waalandile evi, “We Yawe, kine wangitabizia, nakupaapaata uye pamo ni fwefue anzia kine baba bantu ni babisanguka ni bafinine mitima. Eleela bubi bwetu ni bibalo byetu ututwame tuye twali bantu bobe.” ");
INSERT INTO tap_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yawe waamwanine Musa nangue, “Unvua, ndikukita nenu kipingo. Naakakita tupapo ntanzi ya bantu bobe bonse mu musango usinakituepo mu kyalo kyonse, ao mu ntundu yonse, ni bantu bonse bawikeele nabo baakamona miilo yakua Yawe, pantu kintu kinaakakita nobe kyaakaba kya kutiinia. ");
INSERT INTO tap_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Poozeko maano ku twebo tundimukulanda lelo. Nene nakaba kumitangilila ku ntanzi ni kukumba Ba-amori, ni Bakanaani, ni Bahiti, ni Baperizi, ni Bahivi, pamo ni Bayebusi. ");
INSERT INTO tap_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ni pakako, ilabukile tekuti mukapwane na bekala kyalo koko kumulimukuya, evi tekuti mukabe mwakita bubi nga bene. ");
INSERT INTO tap_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Inzi mupalile kutuuta bitale byabo ni kutyonania mapumpu abo azuuke pamo ni kuputulania mikisi yabo yakua Ashera. ");
INSERT INTO tap_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Temupalile kupupa leza unge, pantu Yawe Liina lyakue ni Bunkua, wene i Leza wa bunkua. ");
INSERT INTO tap_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Temupalile kukita kipingo na bene kyalo, pantu musita ubaakaba baelela ngelelo ni kupupa baleza babo, babo bantu nga baakaba bamikupa ni kumibembia kulia bilio bibalibaelela ku baleza babo, ");
INSERT INTO tap_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","kabili nga mwaakeetabizia baana benu balalume kuupa baana babo banakazi balibapupa baleza babo. Babo banakazi baakaba babembia baana benu balalume kupupa baleza babo. ");
INSERT INTO tap_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Tekuti mukakite mikisi na mutofue usungulwilue. ");
INSERT INTO tap_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Mukabe mwakita nsikunkulu ya mukate usiliko ntutumusi. Mu nsiku kilooba mukabe mwalia mukate usiliko ntutumusi nga vinaamyanine. Mukabe mwakita evio pa musita upalile mu mwezi wa Abibu, pantu mu ozo mwezi i umwafumiinemo mu Misri. ");
INSERT INTO tap_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Libeli mwalalume wa Baizraeli ni wane, pamo ni kubalua libeli wa biteekua byobe, wa nghombe pamo ni wa mikooko. ");
INSERT INTO tap_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Inzi punda ndume libeli mwaakamulubula na musoka wa mukooko. Kine temukamulubula, mwaakatyona mukosi wakue. Ni kubalua libeli mwalalume wa muntu mu baana benu mwaakamulubula. “Tekuti kukabe muntu wa kwiza pa ntanzi yane tekuba watweme bupe. ");
INSERT INTO tap_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Nsiku mutanda ya mu mulungu mwaakaba mwabombamo miilo. Inzi busiku bwa kilooba mwaakaba mwatuuzia, anzia kine ni pa musita wa kulima ao pa musita wa kuzombola, mwaakaba mwatuuzia. ");
INSERT INTO tap_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mukabe kuya mwakita Nsikunkulu ya Milungu, ni yo i ya mazabo a mambo a buzombozi bwa nghano, pamo ni Nsikunkulu ya Buzombozi bwa mpeleezio ya mwaka. ");
INSERT INTO tap_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Balalume bonse ba mu libumba lyenu baakabe baiza ntanzi yakua Yawe Kabezia Mpungu wakua Izraeli nghendo itatu kubalua mwaka. ");
INSERT INTO tap_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nakaba kukumba ntundu ntanzi yenu ni kulundako kyalo kyenu. Kabili tekukaba muntu waakeezia kupoka kyalo kyenu musita umwaakaba mwaiza ntanzi yakua Yawe Leza wenu nghendo itatu mu mwaka. ");
INSERT INTO tap_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Tekuti mukabe mwangelela mulopa pamo ni mukate uliko ntutumusi. Tekuti mukabe mwasiapo minofu ya ngelelo ya nsikunkulu ya Pasaka ya kyungulo mpaka lukeelekeele. ");
INSERT INTO tap_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Buzombozi bwa mambo bwa mu makaba enu mupalile mukabe mwabutwala mu Nghanda yakua Yawe Leza wenu. “Tekuti mukabe mwaeleka mwina mbuzi mu mabeele akua nghina.” ");
INSERT INTO tap_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yawe i lu-aamwanine Musa nangue, “Lemba totu twebo pantu twaimaninako kipingo kinapinghana nobe pamo ni Baizraeli.” ");
INSERT INTO tap_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa waikeele ku Lupili lwa Sinai pamo ni Yawe nsiku 40 busiku ni koba pasili kulia bilio ao kumina menda. Ni Yawe waalembele milao lyanondo pa bebio bibazu. ");
INSERT INTO tap_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa lu-aali walimukukooka kufuma ku Lupili lwa Sinai watweme bibazu bibili bya busininkizio mu minue yakue, lukebu lwakue lwaali lwalimukubenghema pantu waalanzyenie ni Yawe, inzi taali wamanine. ");
INSERT INTO tap_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruni ni Baizraeli bonse lubaamukentele Musa, baamwene lukebu lwakue lwalimukubenghema. Ni pakako, baatiinine kumupalama. ");
INSERT INTO tap_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Inzi Musa waakuutile Haruni pamo ni banombozi bonse ba mabumba ni kulanda nabo. ");
INSERT INTO tap_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pa kyamba, Baizraeli bonse baamupaleeme Musa, ni ye waabaanine twebo tonse twa-aninue na Yawe ku Lupili lwa Sinai. ");
INSERT INTO tap_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa lu-aapwile kulanda nabo, waikupile kitambala ku menso. ");
INSERT INTO tap_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Inzi Musa lu-aali waingila ntanzi yakua Yawe kuti aye alande nakue, waali waikupulula kitambala mpaka musita wa kufuma. Lu-aali wafuma, waali wabaana Baizraeli twebo tu-aali wa-anua. ");
INSERT INTO tap_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Baizraeli baali bamona lukebu lwakue lwaali lwabenghema. Musa waali waikupa kitambala paakale mpaka lu-aali waya kulanda ni Yawe paakale. ");
INSERT INTO tap_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa waakolonghaniizie mabumba onse a Baizraeli. Waabaanine evi, “Totu i twebo twakilandua na Yawe kuti mukabe mwakita: ");
INSERT INTO tap_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Nsiku mutanda ya mu mulungu mwaakaba mwabombamo miilo. Inzi busiku bwa kilooba, bwaakaba bwali busiku buzuuke kuli mwemue, Sabata ya kutuuzia yakua Yawe. Kubalua muntu waakabomba mu busiku bwa kutuuzia, waakeepawa. ");
INSERT INTO tap_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mu busiku bwa Sabata tekuti mukabe mwakozia mulilo mu nkendo yonse mumwakaba mwaikala.” ");
INSERT INTO tap_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa wa-anine mabumba onse a Baizraeli nangue, “Twebo twakilanda Yawe kuti muye mwakita ni totu: ");
INSERT INTO tap_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mupeele Yawe bupe bwa bunonsi bumuli nabo. Kubalua muntu ali ni mutima wantono apalile kumupeela Yawe oro, ni mutofue, ni mukuba, ");
INSERT INTO tap_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ni nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, ni ya kitani kiweme, ni masako a mbuzi, ");
INSERT INTO tap_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ni kipapa kya mpanga kisubilueko mukumino wa kasi, ni kipapa kya kipomo, ni mbao ya kasiiya, ");
INSERT INTO tap_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ni mafuta a mizeituni a mu litala, ni manukato a kubiika ku mafuta azuuke, ni ku bubaani buweme, ");
INSERT INTO tap_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ni mabue a oniksi, pamo ni mabue a kubiika ku efodi ni ku mufuko wa pa nkulo. ");
INSERT INTO tap_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Kubalua muntu ali ni maano akukita miilo imo pakati kenu, eze akite bintu byonse byaalandile Yawe: ");
INSERT INTO tap_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Akite liema lizuuke ni nkupo ya ku liema, ni bipempe, ni bikobo, ni mbao, ni mbango yakue, ni mapumpu akue pamo ni bya kwimikuamo. ");
INSERT INTO tap_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Akite Lisanduku lya Kipingo pamo ni mipingo ya kupingilako ni ntupiko, ni kipempe kya kukingako, ");
INSERT INTO tap_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ni meza pamo ni mipingo ya kupingilako, ni bibombelo byonse bya ku meza, ni mikate ya kilangililo, ");
INSERT INTO tap_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ni kya kuteekapo matala ni bibombelo byakue, ni matala pamo ni mafuta pa mulandu wa kisue, ");
INSERT INTO tap_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ni kitale kya kufunkiiziapo bubaani, ni mipingo ya kupingilako, ni mafuta azuuke, ni bubaani buweme, ni kipempe kya pa mulyango wa liema lizuuke, ");
INSERT INTO tap_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ni kitale kya kuziziiziapo ngelelo pamo ni kasaaso ka mukuba, ni mipingo ya kupingilako, ni bibombelo byonse, ni musambilo pamo ni kya kuteekapo, ");
INSERT INTO tap_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ni bipempe bizyungulukiile musolo wa mukati, ni mapumpu a ku musolo pamo ni bya kwimikuamo, ni kipempe kya pa mulyango wa musolo, ");
INSERT INTO tap_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ni bikili bya ku liema lizuuke, ni bikili bya ku luuba lwa musolo, ni nkamba yakue, ");
INSERT INTO tap_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ni ngubo isukilue bwino, ngubo izuuke yakua Haruni ni baana bakue balalume, ngubo ya kuvwala musita wa kubomba mwilo wa bukitambua mu kifuka kizuuke.” ");
INSERT INTO tap_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ni pakako, libumba lyonse lya Baizraeli lyaafumine pa ntanzi yakua Musa ni kubwelela ku mitanda. ");
INSERT INTO tap_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Kubalua muntu kukonkana ni mu-aatoneene mu mutima wakue, waile kuli Musa ni kumutwalila Yawe bupe bwa kubombia pa kukuula Tabernakulo ni bupe bwa mwilo wa kubombela Leza, pamo ni bupe bwa bya kukitilako bivwalo bizuuke. ");
INSERT INTO tap_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bonse, balalume ni banakazi, baali ni mutima wa kupeela, baaleetele bikomo, ni ntimbi, ni tuzele twa kusyusyutilako, ni bikano, pamo ni bibombelo byonse bya oro. Kubalua muntu waamuleetele Yawe bupe bwa oro kuti bube bupe bwa kutensia. ");
INSERT INTO tap_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kubalua muntu waali ni nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, ni ya kitani kiweme, ni masako a mbuzi, ni kipapa kya mpanga kisubilueko mukumino wa kasi, pamo ni kipapa kya kipomo, waaleetele. ");
INSERT INTO tap_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Kubalua muntu waafumiizie mutofue ni mukuba, waamuleeteele Yawe. Kubalua muntu waali ni kimuti kya kasiiya, waakileetele ku mwilo upalile. ");
INSERT INTO tap_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Banakazi bonse baali ni maano a kusuka, baaleetele ngubo ibaasukile na minue yabo. Ngubo ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni ngubo ya kitani kiweme. ");
INSERT INTO tap_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ni banakazi baali ni maano a kusuka, baasukile masako a mbuzi. ");
INSERT INTO tap_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Masiiko a Baizraeli baaleetele mabue a oniksi, pamo ni mabue a mponvu a kubiika ku efodi ni ku mufuko wa pa nkulo, ");
INSERT INTO tap_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ni manukato, ni mafuta a mizeituni a mu matala, ni mafuta azuuke, ni bubaani bwa bunu buweme. ");
INSERT INTO tap_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Baizraeli bonse, balalume ni banakazi, baaleetele bupe bwa kupeela Yawe bawamiinue mu mitima yabo pa mulandu wa miilo yonse ya-aninue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Pa kyamba, Musa wa-anine Baizraeli nangue, “Yawe wakimusaakula Besaleli wa mu mukowa wakua Yuda, mwana mwalalume mwina Uri, mwinzikulu wakua Huri, ");
INSERT INTO tap_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ni kumwizuzia Mweo wakue. Wakimupeela maano, ni mulangue, pamo ni kumana kubomba miilo ilekenkeene ");
INSERT INTO tap_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","kuti akite bintu bya maano mu kukita bintu bya oro, ni bya mutofue, pamo ni bya mukuba, ");
INSERT INTO tap_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ni kukita mabue a kufwanizia, ni kubaza bimuti pa mulandu wa kubomba miilo ilekenkeene. ");
INSERT INTO tap_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Besaleli ni Aholiabu mwina Ahisamaki wa mu mukowa wakua Dani, baapeelue buvinde na Yawe bwa kusambilizia bange. ");
INSERT INTO tap_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Yawe waabapeele maano a kubomba miilo ilekenkeene: Mwilo wa kubaaza mabue, ni mwilo wa kufwanizia bivwalo na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, ni mwilo wa kukita kitani kiweme, pamo ni mwilo wa kusuka inge ngubo. Baba i bantu bakengeele mu kukita miilo ilekenkeene, kabili i baakaba bakita miilo ya misango yonse iweme. ");
INSERT INTO tap_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ni pakako Besaleli ni Aholiabu pamo ni kubalua muntu apeelue mutima wa maano ni mulangue na Yawe pakuti abombe miilo yonse ya kukuula liema lizuuke, wakaba kubomba nga mwaalandiile Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa i lu-aakuutile Besaleli ni Aholiabu pamo ni kubalua muntu apeelue mutima wa maano ni mulangue na Yawe, ni kubalua muntu epeele kubomba mwilo na mutima uweme. ");
INSERT INTO tap_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa waapeele babo bantu bupe bonse bwaafumiiziwe na Baizraeli pa mulandu wa miilo ya kukuula liema lizuuke. Inzi Baizraeli baali batwaliliile sie kufumia bupe bwabo kubalua lukelekeele koku bawamiinue. ");
INSERT INTO tap_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Babo bantu bonse ba mulangue baali babomba miilo ilekenkeene ya kwimika kifuka kizuuke, baafumine pa mwilo wabo ni ");
INSERT INTO tap_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","kuya kumwana Musa nangue, “Bantu baleeta bintu bingi kukila pa belia bipalile kuleetua mu miilo itwa-aninue na Yawe.” ");
INSERT INTO tap_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kupwako, Musa wapunda mu mitanda walimukulanda nangue, “Kubalua muntu, mwalalume ao mwanakazi, tekuti afumie kabili bupe pa mulandu wa kifuka kizuuke.” Ni pakako, baalekeele kutwala bupe, ");
INSERT INTO tap_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","pantu bintu bibaaleetele byaakilile kuvula, kabili byaakumeene bya kubombia ku miilo yonse. ");
INSERT INTO tap_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bonse baali ni mutima wa mulangue mu babo babombi, baakitile Tabernakulo na bipempe lyanondo bya kitani kiweme kyaali kyapyatilue bwino na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi pamo ni ya mukumino wa kasi. Ni Besaleli waalengelemo nkebu ya makerubi. ");
INSERT INTO tap_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kubalua kipempe kyaali kyaleepele metre lyanondo ni isaano, ni mu bukata metre ibili. Bebio bipempe byonse byaali byalingheene. ");
INSERT INTO tap_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Besaleli waalundaniizie bipempe bisaano kumo, ni binge bisaano evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Waabiikile mikobelo 50 ya nyunzi ya mukumino wa lyulu kupela lya kunze ya kipempe, ni ku kinge kipempe waakitile evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Mikobelo 50 ya ku kipempe kimo yaali yakenteene na mikobelo 50 ya ku kipempe kinge. ");
INSERT INTO tap_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Kabili waakitile tukobo 50 twa oro twa kulundaniiziako bebio bipempe bibili pakuti Tabernakulo ibe kintu kimo. ");
INSERT INTO tap_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Kabili waakitile bipempe lyanondo ni kimo bya masako a mbuzi bya kubivimba peulu Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kubalua kipempe kyaali kyaleepele metre lyanondo ni isaano, ni mu bukata metre ibili. Bebio bipempe lyanondo ni kimo byaali byalingheene. ");
INSERT INTO tap_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Besaleli waalundaniizie kumo bipempe bisaano, ni binge mutanda ni byo waalundaniizie kumo. ");
INSERT INTO tap_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Waabiikile mikobelo 50 kupela lya kunze ya kipempe, ni ku kinge kipempe waakitile evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Waakitile tukobo 50 twa kulundaniiziako bipempe bibili pakuti kiye kyali kimo. ");
INSERT INTO tap_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kabili waakitile nkupo ya lelio liema, nkupo ya mpapa ya mpanga isubilueko mukumino wa kasi, ni peulu ezio nkupo waakitiilepo nkupo ya mpapa ya kipomo. ");
INSERT INTO tap_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Waakitile mbao ya kimuti kya kasiiya ya kwimikilako Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Lubao lumo lwaali lwaleepele metre isaano, ni mu bukata lwaali lwatanine santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kubalua lubao lwaali lwali na matui abili, evi i vi-aakitile ku mbao yonse ya ku Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Waakitile mbao 20 ya ku Tabernakulo lya ku nkungulua, ");
INSERT INTO tap_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Kabili waakitile bintu 40 bya mutofue bya kwimikuamo mbao 20. Mu bintu bibili bya kwimikuamo, mwaimikilue lubao lumo lwa matui abili, ni mu binge bibili ni mo evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ku bunge bwala bwa liema lya ku nkungua, waakitileko mbao 20, ");
INSERT INTO tap_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ni bintu 40 bya mutofue bya kwimikuamo. Mu bintu bibili bya kwimikuamo, mwaimikilue lubao lumo, ni mu binge bibili ni mo evio vyenka. ");
INSERT INTO tap_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kumusana wa liema, lya ku mboosi, waimikileko mbao mutanda, ");
INSERT INTO tap_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ni mbao ibili yaimikilue mu tufuli twa Tabernakulo lya ku mboosi. ");
INSERT INTO tap_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ezio mbao ibili ya mutufuli waimikile yakuminkeene kutula pansi, ni pa muulu waakuminkaniizie na kikobo kimo. Evio i vi-aakitile ku tufuli tonse tubili. ");
INSERT INTO tap_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ni pakako, yaali mbao mwanda, ni bintu bya mutofue bya kwimikuamo byaali lyanondo ni mutanda. Bya kwimikuamo bibili byaimikiluemo lubao lumo. ");
INSERT INTO tap_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Waakitile mbango ya kimuti kya kasiiya, mbango isaano pa mbao ili ku lubali lumo lwa Tabernakulo, ");
INSERT INTO tap_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ni inge isaano pa mbao ili ku bunge bwala bwa Tabernakulo, kabili ni inge isaano pa mbao ili ku kyamba kya Tabernakulo kuzika koba. ");
INSERT INTO tap_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Lubango lwa pa bukata bwa mbao lwene lwaali lwapulilemo koku ni koku. ");
INSERT INTO tap_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ezi mbao pamo ni mbango baakupileko oro, kabili baakitile ni bikobo bya oro bya kupisiamo mbango. Ni ezio mbango baakupileko oro. ");
INSERT INTO tap_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Baakitile kipempe kya nyunzi ya mukumino wa lyulu, ni wa bulumbi, pamo ni wa kasi, pamo ni ngubo ya kitani kiweme kya nyunzi ipyatilue, ni kukifwanizia na kubilamo nkebu ya makerubi. Ezio miilo yaabombelue na bantu bamaniisie. ");
INSERT INTO tap_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Baakitile mapumpu ana a kimuti kya kasiiya ni kukupako oro. Bikobo byakue ni byo byaali bya oro. Kabili baakitile bintu bina bya mutofue bya kwimikuamo. ");
INSERT INTO tap_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Pa kyamba baakitile kipempe kya pa mulyango wa liema, kipempe kya nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni kitani kiweme kipyatilue. Yaali yali miilo ya bantu bamaniisie kubila. ");
INSERT INTO tap_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Bebio bipempe byaakitiilue mapumpu asaano pamo ni bikobo byakue. Baasubile oro ku mikobelo pamo ni peulu mapumpu. Inzi baakitile ni bya kwimikuamo bisaano bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besaleli waakitile Lisanduku lya Kipingo lya mbao ya kimuti kya kasiiya. Lyaali lyaleepele metre imo ni santimetre 25, mu bukata lyaali lyatanine santimetre 75, ni mu kutuuluka lyaali lyatuulukile santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Waakupileko oro isambikile mukati ni panze, ni mumbali waazyungulusiiziemo lufito lwa oro. ");
INSERT INTO tap_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Waakitile bikobo bina bya oro ni kubibiika ku tufuli tuna twa lisanduku. Bibili ku bwala bumo ni bibili ku bunge bwala. ");
INSERT INTO tap_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kabili waakitile mipingo ibili ya kimuti kya kasiiya ni kukupako oro. ");
INSERT INTO tap_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Mipingo ya kupingilako wai-ingiziizie mu bikobo bya ku lisanduku kumbali yonse ibili. ");
INSERT INTO tap_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Waakitile ntupiko ya oro isambikile. Ezio ntupiko yaali yaleepele metre imo ni santimetre 25, ni mu bukata santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Waakitile makerubi abili atililue bwino ali a oro ni kuemika ku mpeleezio ibili ya ntupiko mu kuleepa. ");
INSERT INTO tap_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Waakitile likerubi limo ku mpeleezio imo, ni linge ku inge mpeleezio. Azo makerubi wa-akitiliile ku ntupiko ku mpeleezio yakue ibili. ");
INSERT INTO tap_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Azo makerubi aali alendwile mapaapi abo mu muulu lya pa ntupiko akupiliile lisanduku, ni nkebu yabo yakenteene lya pa ntupiko. ");
INSERT INTO tap_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Waakitile meza ya kimuti kya kasiiya yaali yaleepele metre imo ni mu bukata yatanine santimetre 50, ni mu kutuuluka yaali yatuulukile santimetre 75. ");
INSERT INTO tap_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Waakupileko oro isambikile, ni mumbali waazyungulusiiziemo lufito lwa oro. ");
INSERT INTO tap_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Waazyungulusiizie lufito lwatuulukile santimetre mwanda, kusyali kupisia ni mukovio wa oro ku lufito. ");
INSERT INTO tap_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Waakitile bikobo bina bya oro ni kubibiika ku tufuli tuna twa meza lya palia pabeeleele mikonzo. ");
INSERT INTO tap_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Bebio bikobo byaabiikilue pepi na mbao ya pa muulu. Momo i mwaali mwakwingizia mipingo ya kupingilako meza. ");
INSERT INTO tap_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Waakitile mipingo ya kimuti kya kasiiya ni kukupako oro. Ezio mipingo yaali ya kupingilako meza. ");
INSERT INTO tap_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Kabili waakitile masaani, ni mpindi, ni bibakuli pamo ni makopo a kubombia ku bupe bwa bya kumina. Bebio bibombelo byonse bya pa meza waabikitile byali bya oro isambikile. ");
INSERT INTO tap_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Waakitile kya kuteekapo matala kya oro itililue yasambikile bwino. Kya kwimikapo pamo ni mukonzo wakue, ni tubakuli twakue twaali twali nga maluba, ni mapingu akue pamo ni maani akue, byaali byalundeene kumo. ");
INSERT INTO tap_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ku ozo mukonzo umo kwaali kwafumine misambo mutanda. Misambo itatu ku bwala bumo, ni inge itatu ku bunge bwala. ");
INSERT INTO tap_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ku musambo umo kwaali kwali tubakuli tutatu tuli nga maluba a almonde ali ni mapingu pamo ni maani a azo enka maluba. Ku musambo unge ni ko baakitileko evio vyenka mpaka ku misambo yonse mutanda yaali yafumine ku ozo mukonzo. ");
INSERT INTO tap_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ni ku mukonzo wa pa bukata uli pa kya kuteekapo kwaali kwali tubakuli tuna tuli nga maluba a almonde ni mapingu pamo ni maani a azo enka maluba. ");
INSERT INTO tap_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ntanzi ya kufika pa misambo ibili paali pali lipingu lya liluba limo. Kyaali kyali evio ku misambo ibili ya mambo, ni ku misambo ibili ya bubili, pamo ni ku misambo ibili ya butatu ");
INSERT INTO tap_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mukonzo ni misambo yakue yonse byaali byakitiliilue kumo ni kya kuteekapo. Kyonse kyaali kyali kya oro itililue yasambikile. ");
INSERT INTO tap_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Besaleli waakitile matala kilooba, ni nmano pamo ni bisaani na oro isambikile. ");
INSERT INTO tap_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Waakitile kya kuteekapo matala pamo ni bibombelo byonse na kilo 35 ya oro isambikile. ");
INSERT INTO tap_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Waakitile kitale kya kimuti kya kasiiya kya kufunkiiziapo bubaani. Waakitile kyalingheene monse monse, kyaali kyali na santimetre 50 mu kuleepa ni mu bukata. Mu kutuuluka kyaali metre imo. Bintu bituulukile nga masengo byaali byalundeene na kitale. ");
INSERT INTO tap_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Peulu ni mumbali monse pamo ni ku mbao ituulukile nga masengo, ni ku mikonzo yonse ina waakupileko oro isambikile, ni peulu lya mumbali waazyungulusiiziemo mukovio wa oro. ");
INSERT INTO tap_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Waakitile bikobo bibili ku bwala bumo bwa kitale, ni binge bibili ku bunge bwala mwinsina olia mukovio wa oro. Mu bebio bikobo i mwaali mwakwingizia mipingo ya kupingilako. ");
INSERT INTO tap_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Waakitile mipingo ya kimuti kya kasiiya ni kukupako oro. ");
INSERT INTO tap_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Kabili waakitile mafuta azuuke, ni bubaani buweme bwa mafuta anunkiile. Azo mafuta aakitilue na bantu bamanine ozo mwilo. ");
INSERT INTO tap_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besaleli waakitile kitale kya kuziziiziapo ngelelo kya mbao ya kimuti kya kasiiya, kekio kitale kyaali kyaleepele metre ibili ni kitika, ni mu bukata kyaali metre ibili ni kitika. Kekio kitale peulu kyaali kyalingheene monse monse. Mu kutuuluka kyaali metre imo ni kitika. ");
INSERT INTO tap_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Mu tufuli tuna waabiikilemo mbao yaali yatuulukile nga masengo, mbao ilundaniizie kitale. Kekio kitale kyaakupilueko mukuba. ");
INSERT INTO tap_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Baakitile bibombelo byonse bya ku kitale: Bya kuzoolelapo mito, ni bipawa, ni bibakuli, ni bikobo, ni bya kubiikapo mulilo. Bebio bibombelo byonse bya ku kitale byaali bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Baakitile kasaaso ka mukuba ka ku kitale ni kukabiika mwinsina lubao luzyungulukiile kitale lya mwinsina. Kako kasaaso kaali kafikile pa bukata mu kutuuluka. ");
INSERT INTO tap_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Baakitile bikobo bina bya kubiika ku tufuli tuna twa kasaaso ka mukuba, evi biye byali bya kwingiziamo mipingo ya kupingilako. ");
INSERT INTO tap_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Baakitile mipingo ya kimuti kya kasiiya ni kukupako mukuba. ");
INSERT INTO tap_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ezio mipingo waingiziizie mu bikobo kuti iye yaali mumbali ibili ya kekio kitale musita wa kukipinga. Kitale kyaali kyakitilue na mbao, kyaali kyazikukile mukati. ");
INSERT INTO tap_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Besaleli waakitile musambilo wa mukuba ni kya kuteekapo kya mukuba na biizino bya mukuba byaaleetelue na banakazi baali babomba pa mulyango wa Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Besaleli waakitile musolo wa Tabernakulo. Ku lubali lwa ku nkungulua waakitile luuba lwa kipempe kya kitani kiweme kipyatilue. Kekio kipempe kyaali kyaleepele metre 50. ");
INSERT INTO tap_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Waakitile mapumpu 20 ni bintu bya kwimikuamo 20 bya mukuba, bikobo bya ku mapumpu ni mikobelo yakue byaali bya mutofue. ");
INSERT INTO tap_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ku lubali lwa ku nkungua ni ko kwaali kipempe kyaali kyaleepele metre 50, ni mapumpu akue 20, ni bintu bya kwimikuamo 20 bya mukuba. Bikobo bya ku mapumpu ni mikobelo yakue byaali bya mutofue. ");
INSERT INTO tap_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Lya ku mboosi kwaali luuba lwa kipempe kyaali kyaleepele metre 25, ni mapumpu akue lyanondo, ni bya kwimikuamo lyanondo. Bikobo byakue ni mikobelo yakue byaali bya mutofue. ");
INSERT INTO tap_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Lya ku kabanga mu bukata kwaali metre 25. ");
INSERT INTO tap_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Bipempe bya ku lubali lumo lwa mulyango byaali byaleepele metre kilooba ni kitika. Mapumpu akue atatu, ni bya kwimikuamo bitatu. ");
INSERT INTO tap_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Luuba lonse lwaali lwazyungulukiile musolo, lwaali lwa kitani kiweme kipyatilue. ");
INSERT INTO tap_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Bya kwimikuamo mapumpu byaali bya mukuba. Bikobo ni mikobelo yakue byaali bya mutofue. Peulu mapumpu paali pakupilue mutofue, ni mapumpu onse a ozo musolo aali alundaniiziwe na bikobo bya mutofue. ");
INSERT INTO tap_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Kipempe kya pa mulyango wa musolo, kyaali kya nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, pamo ni kitani kiweme kipyatilue. Ezio miilo yaabombelue na bantu bamaniisie. Kekio kipempe kyaali kyaleepele metre lyanondo, ni mu kutuuluka metre ibili ni kitika nga vyaali vyatuulukile luuba lwa kipempe kya musolo. ");
INSERT INTO tap_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Mapumpu akue aali ali ana, ni bya kwimikuamo bina byaali bya mukuba. Bikobo ni mikobelo yakue byaali bya mutofue. Peulu mapumpu paali pakupilue mutofue. ");
INSERT INTO tap_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Bikili byonse bya ku Tabernakulo ni bya ku luuba lwa musolo byaali bya mukuba. ");
INSERT INTO tap_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ezi i mpendua ya bibombelo byaabombele pa kukuula Tabernakulo ya kusungilamo bibazu bibili bya mabue a busininkizio nga vikyaalandilue na Musa kuti bipendue na Balawi. Itamari mwana mwalalume mwina kitambua Haruni i waali mukulu pa ezio miilo. ");
INSERT INTO tap_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besaleli wa mu mukowa wakua Yuda, mwana mwalalume mwina Uri, mwinzikulu wakua Huri, waakitile bintu byonse bya-aninue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Waali wakwasiiziwe na Aholiabu mwana mwalalume mwina Ahisamaki wa mu mukowa wakua Dani, ozo waali wamaniisie kufwanizia ni waali wamanine miilo ilekenkeene, miilo ya kubila na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni kitani kiweme kipyatilue. ");
INSERT INTO tap_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Oro yonse yaabombiiziwe ku mwilo wa ku kifuka kizuuke, yaali kilemo kya kilo 877 ni grama 300 kukonkana ni kalingo ka mu kifuka kizuuke. ");
INSERT INTO tap_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Mutofue waaleetelue na libumba waali kilemo kya kilo 3,017 ni grama 750 kukonkana ni kalingo ka mu kifuka kizuuke. ");
INSERT INTO tap_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kubalua mwalalume waali na myaka kubambila pa 20 ni kukilapo, waali wafumia nfolanga grama isaano yaali yalombua. Mpendua ya balalume baapendelue yaali 603,550. ");
INSERT INTO tap_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Mutofue waali wafinine kilo 3,000 waasungulwilue kuti ikituemo bya kwimikuamo 100 bya ku kifuka kizuuke, ni bya ku kekio kipempe. I kulanda nangue kilo 30 ku kya kwimikuamo kimo. ");
INSERT INTO tap_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Waakitile bikobo bya ku mapumpu ni bya kukupa peulu mapumpu pamo ni mikobelo. Bebio bintu byaali na kilemo kya kilo 17 ni grama 750 yaasyelepo. ");
INSERT INTO tap_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bupe bonse bwa mukuba bwaafumiizie Baizareli bwaali bwafinine kilo 2,124. ");
INSERT INTO tap_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ozo mukuba waakitiluemo bya kwimikuamo bya pa mulyango wa Tabernakulo, ni kasaaso ka mukuba, ni kitale kisubilueko mukuba, ni bibombelo byonse bya ku kitale, ");
INSERT INTO tap_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ni bya kwimikuamo bya ku luuba lwa musolo, ni bya kwimikuamo bya pa mulyango wa pa musolo, ni bikili byonse bya ku liema, pamo ni bikili byonse bya ku luuba lwa musolo. ");
INSERT INTO tap_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bivwalo bya kuvwala pa kubomba mu kifuka kizuuke byaakitilue na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi pamo ni ya mukumino wa kasi. Bebi bivwalo byaali byasukilue bwino. Kabili baakitile ni bivwalo bizuuke byakua Haruni nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Besaleli ni bakwasi bakue baakitile efodi ya nyunzi ya mukumino wa oro, ni ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni kitani kiweme kipyatilue. ");
INSERT INTO tap_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Baatilile oro mpaka yasyala kamutika kakeepeesie, kusyali kuteeta kuba nyunzi evi isukililue pamo ni nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, ni ya kitani kiweme. Yaakitilue na muntu amanine ozo mwilo. ");
INSERT INTO tap_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Baamukitiile mikobelo ibili ya kupisia pa nkombe kuti iye yalundaniizie kya ku ntanzi ni kya ku musana. ");
INSERT INTO tap_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ni musipi waali wasukilue bwino na bintu bikitiilueko efodi kuti uye wali kimo nakio, ni o waakitilue na nyunzi ya mukumino wa oro, ni ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi pamo ni ya kitani kiweme kipyatilue kukonkana ni mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Baakitile mabue abili a oniksi ni ku-abiika mu tukwatililo twa oro. Azo mabue aali alembeluepo meena a bena Izraeli nga evelia vilivyalembua kamanino. ");
INSERT INTO tap_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Baabililiile azo mabue peulu mikobelo ipitile pa nkombe yafumine ku efodi pakuti aye aimaniineko mikowa lyanondo ni ibili ya Baizraeli nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Besaleli ni bakwasi bakue baakitile mufuko wa pa nkulo na bintu bibaakitiileko efodi: Na nyunzi ya mukumino wa oro, ni ya mukumino wa lyulu, ni ya mukumino wa bulumbi, ni ya mukumino wa kasi, pamo ni kitani kiweme kipyatilue nga vyaakitilue efodi. Ozo mwilo waakitilue na bantu bamaniisie. ");
INSERT INTO tap_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ozo mufuko waali wapimpiluemo limo walingheene monse monse. Mu kuleepa ni mu bukata waali wali na santimetre 25. ");
INSERT INTO tap_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ku ozo mufuko baabiikileko milongo ina ya mabue a mutengo ukata. Mu mulongo wa mambo baabiikilemo libue lya akiki, ni libue lya topazi pamo ni libue lya emerodi. ");
INSERT INTO tap_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Mulongo wa bubili baabiikilemo libue lya zumaridi, ni libue lya yakuti lya mukumino wa lyulu, ni libue lya almasi. ");
INSERT INTO tap_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Mulongo wa butatu baabiikilemo libue lya yakinto, ni libue lya agata ni libue lya ametisti. ");
INSERT INTO tap_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ni mulongo wa buna baabiikilemo libue lya berile, ni lya oniksi, ni lya yaspi. Azo mabue onse aali akwatiliilue na tukwatililo twa oro. ");
INSERT INTO tap_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Azo mabue aali ali lyanondo ni abili. Kubalua libue paalembelue liina limo lya pa meena a bena Izraeli. Kubalua libue limo paalembelue liina limo liimaniineko mukowa umo wa pa mikowa lyanondo ni ibili ya Baizraeli. ");
INSERT INTO tap_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ku ozo mufuko wa pa nkulo baakitiileko mikufu ya oro isambikile yaali yali nga nkamba ipyatilue. ");
INSERT INTO tap_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Baakitile tukwatililo twa oro tubili ni tuzele tubili twa oro, ni kutubiika ku tufuli tubili twa ozo mufuko wa pa nkulo. ");
INSERT INTO tap_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Baakobekele ezio mikufu ibili ya oro mu tuzele tubili tuli ku tufuli twa mufuko wa pa nkulo. ");
INSERT INTO tap_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Mpeleezio inge ibili ya ezio mikufu baakobekele ku tukobo tubili twa oro ni ku-ilundania ku elia mikobelo ya pa nkombe ya ku efodi lya pa ntanzi. ");
INSERT INTO tap_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kabili waakitile tuzele tubili twa oro ni kutubiika ku tufuli tubili twa ku mufuko wa pa nkulo kwinsina lya mukati pepi ni efodi. ");
INSERT INTO tap_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kabili waakitile ni tunge tuzele tubili twa oro ni kutukobeka lya kwinsina mikobelo ya pa nkombe lya ku ntanzi ya efodi pepi ni kilundilo peulu musipi usukilue. ");
INSERT INTO tap_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Baalundaniizie tuzele twa ku mufuko wa pa nkulo ku tuzele twa ku efodi na mikobelo ya nyunzi ya mukumino wa lyulu, evi mufuko wikale lya peulu musipi wa efodi usukilue bwino, ni ozo mufuko wa pa nkulo tekuti uye walekenkana na efodi nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Besaleli ni bakwasi bakue baakitile kazula ka kuvwalilapo efodi ka mukumino wa lyulu. ");
INSERT INTO tap_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kazula kaali ni lipulo pa bukata lya kupuziamo mutue, kabili kaali kasukilue bwino mumbali lipulo, evi tekuti kakazabuke. ");
INSERT INTO tap_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Kwinsina kazula kwaali kwafukilue, kabili baabiikileko komamanga isukilueko nyunzi ya mukumino wa lyulu, ni wa bulumbi, ni wa kasi, ni kitani kiweme kipyatilue. Ni bo baakitile ndibu ya oro isambikile ni ku-ibiika kwinsina kazula yatolokele komamanga imo imo. Evi ivibaabiikile ndibu ni komamnga yazyungulukile kwinsina kazula konse, kuti kaye kavwalua musita wa kubomba mukati nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Baakitile makanzu a kitani kiweme, akuvwalua na Haruni ni baana bakue balalume, ");
INSERT INTO tap_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ni kitambala kya kitani kiweme ni kisote kya kitani kiweme ni kaputula ka ngubo ya kitani kiweme kipyatilue, ");
INSERT INTO tap_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ni musipi wa kitani kiweme kipyatilue, na nyunzi ya mukumino wa lyulu, ni ya mukumino wa bulumbi, pamo ni ya mukumino wa kasi. Byaakitilue na bantu bamanine ozo mwilo, nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Baakitile kalilata kazuuke ka oro isambikile ni kulembapo nangue, “Muzuuke wakua Yawe.” Baalembele nga vilivyalembua kamanino. ");
INSERT INTO tap_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Baakakakile na mikobelo ya mukumino wa lyulu kuti kaye kali peulu kitambala lya pa mpala nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Evi i vyaapwile miilo yonse ya Tabernakulo, liema lya kusaakaaninamo. Baizraeli baakitile byonse nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Baamuleeteele Musa bibombelo bya liema, liema ni bibombelo byakue byonse: Bikobo byakue, ni mbao yakue, ni mbango yakue, ni mapumpu akue, ni bya kwimikuamo byakue, ");
INSERT INTO tap_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ni nkupo ya mpapa ya mpanga isubilueko mukumino wa kasi, ni nkupo ya mpapa ya kipomo, ni kipempe kya kukingako, ");
INSERT INTO tap_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ni Lisanduku lya Kipingo, ni mipingo yakue, ni ntupiko, ");
INSERT INTO tap_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ni meza pamo ni bibombelo byakue byonse, ni mikate ya kilangililo, ");
INSERT INTO tap_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ni kinara kya oro isambikile pamo ni matala akue, ni bibombelo byakue byonse pamo ni mafuta a mu matala, ");
INSERT INTO tap_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ni kitale kya oro, ni mafuta azuuke, ni bubaani bwa bunu buweme, ni kipempe kya pa mulyango wa liema, ");
INSERT INTO tap_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ni kitale kya mukuba ni kasaaso ka mukuba, ni mipingo yakue pamo ni bibombelo byakue byonse, ni musambilo pamo ni kya kuteekapo. ");
INSERT INTO tap_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Luuba lwa kipempe lwa musolo, mapumpu akue ni bya kwimikuamo byakue, ni kipempe kya pa mulyango wa musolo, ni nkamba yakue, ni bikili byakue, pamo ni bibombelo byonse bya kubombiiwa mu mwilo wa mu Tabernakulo, mu liema lya kusaakaaninamo, ");
INSERT INTO tap_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ni bivwalo bya mwilo uweme bya kubomba nabyo pa kifuka kizuuke, bivwalo bizuuke byakua kitambua Haruni, pamo ni bivwalo bya baana bakue bya kubomba nabyo mu mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Baizraeli baakitile miilo yonse nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa lu-aamwene nangue miilo yonse yapua nga mwa-aniinue na Yawe, waabapaalile. ");
INSERT INTO tap_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kabili Yawe waamwanine Musa nangue, ");
INSERT INTO tap_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Pa busiku bwa mambo bwa mwezi wa mambo, ukeemike Tabernakulo, liema lya kusaakaaninamo. ");
INSERT INTO tap_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ukabiikemo Lisanduku lya Kipingo, mane ukakobeke ni kipempe kya kukingilila lisanduku. ");
INSERT INTO tap_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ukengiziemo meza ni kubiikapo bintu bya pa meza, kabili ukengizie kinara mukati ni kubiikapo matala akue. ");
INSERT INTO tap_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ukeemike kitale kya oro kya kufunkiiziapo bubaani ntanzi ya Lisanduku lya Kipingo ni kubiika kipempe kya pa mulyango wa Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ukabiike kitale kya kuziziiziapo ngelelo pa ntanzi ya nghingililo ya Tabernakulo, liema lya kusaakaaninamo. ");
INSERT INTO tap_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kabili ukabiike musambilo pa bukata bwa Tabernakulo ni kitale ni kubiikamo menda. ");
INSERT INTO tap_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ukeemike luuba luzyungulukile musolo ni kukobeka kipempe pa mulyango. ");
INSERT INTO tap_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Ukabuule mafuta azuuke, ukasube ku Tabernakulo pamo ni ku bintu byonse bilimo. Ni byo byaakaba bizuuke. ");
INSERT INTO tap_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kabili ukasube mafuta ku kitale kya kuziziiziapo ngelelo ni kuizuukia pamo ni bibombelo byakue byonse. Ni yo yaakaba yazuukiisie. ");
INSERT INTO tap_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ukasube mafuta ku musambilo ni ku kya kuteekapo, ni byo ukabizuukie. ");
INSERT INTO tap_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ukamuleete Haruni ni baana bakue balalume pa mulyango wa liema lya kusaakaaninamo, ni kubasamba na menda. ");
INSERT INTO tap_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kabili ukamuvwike Haruni bivwalo bizuuke, ukamusube mafuta ni kumuzuukia, evi akan'mombele mu mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ni baana balalume bena Haruni ukabaleete ni kubavwika makanzu, ");
INSERT INTO tap_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","kabili ukabasube mafuta nga viwakasuba sibo pakuti bakabe ban'mombela mwilo wa bukitambua. Bobu busubo bwa mafuta bwaakabaalula kuba babitambua ba muyayaya mu nvyalo yabo yonse.” ");
INSERT INTO tap_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa waafikiliziizie byonse mwa-aniinue na Yawe. Evi i vi-aakitile. ");
INSERT INTO tap_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Pa busiku bwa mambo bwa mwezi wa mambo mu mwaka wa bubili pa kyamba kya kufuma ku Misri, Tabernakulo yaimikilue. ");
INSERT INTO tap_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa lu-aimikile Tabernakulo, waabiikile bya kwimikuamo, kusyali waimikamo mbao ni kwalapo mbango, ni kwimika mapumpu. ");
INSERT INTO tap_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Kabili waakobekele maema ku Tabernakulo ni kubiika nkupo ya liema peulu nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Pa kyamba, waabuulile bibazu bya mabue bya busininkizio ni kubibiika mu lisanduku. Kusyali kubiika mipingo ku Lisanduku lya Kipingo, ni kutupikilapo ntupiko. ");
INSERT INTO tap_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kabili waingiziizie Lisanduku lya Kipingo mu Tabernakulo, ni kukobeka kipempe kya kukingilila Lisanduku lya Kipingo nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa waingiziizie meza mu Tabernakulo, waibiika lya ku nkungua ntanzi ya kipempe ");
INSERT INTO tap_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ni kubiikapo mikate ya kilangililo ntanzi yakua Yawe, nga mwa-aniinue na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Waabiikile kinara mu Tabernakulo lya ku nkungulua kyakenteene ni meza, ");
INSERT INTO tap_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ni kulemia matala ntanzi yakua Yawe nga mwa-aniinue na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Waabiikile kitale kya oro kya kufunkiiziapo mu Tabernakulo ntanzi ya kipempe ");
INSERT INTO tap_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ni kufunkiiziapo bubaani bwa manukato a bunu buweme nga mwa-aniinue na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Waakobekele kipempe kya pa nghingililo ya Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Pa kyamba, waabiikile kipempe pa nghingililo ya liema, wabiika kitale kya kuziziiziapo ngelelo pepi ni pa nghingililo ya Tabernakulo. Kusyali waziziiziapo ngelelo ya nama ni ngelelo ya bunga nga mwa-aniinue na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Musa waabiikile musambilo pa bukata bwa Tabernakulo ni kitale kya kwelelapo ngelelo ya kuzizia, kusyali wabiika menda mu musabilo kuti babitambua baye basambamo. ");
INSERT INTO tap_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, ni Haruni pamo ni baana bakue, i mu baali baisambila ku minue ni ku makasa. ");
INSERT INTO tap_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Baali baisamba musita ubaali baingila mu liema lya kusaakaaninamo, ni musita ubaali bapalamina ku kitale nga mwa-aniinue Musa na Yawe. ");
INSERT INTO tap_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kabili Musa waimikile luuba lwa musolo luzyungulukiile Tabernakulo ni kitale, kusyali wakobeka kipempe kya pa nghingililo ya musolo. Musa i vi-aapwile miilo. ");
INSERT INTO tap_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kupwako, lilezi lyakupa kale Tabernakulo, ni bulumba bwakua Yawe bwaizulamo. ");
INSERT INTO tap_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ni pakako, Musa wa-andilue kwingila mu Tabernakulo pantu yaali yakupiliilue na lilezi, ni bulumba bwakua Yawe bwaali bwaizwile mu Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Lyonse Baizraeli mu lwendo lwabo, baali bateluluka sie kine lilezi lyalendulua kufuma pa Tabernakulo. ");
INSERT INTO tap_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Inzi kine lilezi telinalendulue tebaali baya, baali bapempa sie mpaka busiku bulyaakalendulua. ");
INSERT INTO tap_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Mu lwendo lwabo lonse baali bamona lilezi lyakua Yawe peulu Tabernakulo musita wa koba, ni musita wa busiku baali bamona mulilo waleemene peulu Tabernakulo.");
INSERT INTO tap_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Pa ozo musita, Bapinguzi lubaali balombola, kwaali kimina kya nzala mu kyalo. Muntu umo wa mu Betlehemu ya mu kyalo kya Yudea, wa mu mukowa wakua Efraimu, ni mukazi wakue pamo ni baana bakue balalume babili, baabutukiile mu kyalo kya Moabu. ");
INSERT INTO tap_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ozo muntu waali wakuutua Elimeleki. Mukazi wakue ni ye waali wakuutua Naomi. Meena a baana bakue balalume ni aza: Umo waali wakuutua Maloni, ni unge waali wakuutua Kilioni, baali Baefurati ba ku Betlehemu ya mu kyalo kya Yudea. Lubaafikile koko ku Moabu ni kwikala, ");
INSERT INTO tap_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Elimeleki muka Naomi waafwile. Naomi waasyele sie ni baana bakue babili balalumenke. ");
INSERT INTO tap_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Baba baana baupile banakazi ba mu kyalo kya Moabu. Mwanakazi umo waali wakuutua Orpa, ni unge waali wakuutua Rutu. Baikeele koko mupepi myaka lyanondo. ");
INSERT INTO tap_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Maloni ni Kilioni ni bo baafwile. Evi Naomi waafwiliilue na baana bonse babili pamo ni mulume wakue. ");
INSERT INTO tap_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi lu-aunvwile nangue Yawe wakipaala bantu bakue ba ku Betlehemu na kubapeela bilio, waamwene kuti afume mu kyalo kya Moabu aye pamo ni bamuka baana bakue babili. ");
INSERT INTO tap_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Waabambile kuya ni bamuka baana bakue, lwendo lwa kubwelela ku kyalo kya Yudea. ");
INSERT INTO tap_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi waabaanine bamuka baana nangue, “Bwelele kuli banghinenue. Yawe amikitile biweme nga vimwaakitile kuli nene ni ku balume benu baafwile. ");
INSERT INTO tap_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Kabili Yawe amikwasie mukoopue, ni kubalua muntu akeekale bwino ni mulume wakue.” Kupwako, wabalaya bailepo. Inzi bene ba-angwile balila. ");
INSERT INTO tap_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Baamwanine evi, “Twakaana. Fwefue tulikuya pamo nobe ku bantu bobe.” ");
INSERT INTO tap_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naomi waabaanine evi, “Mwe baana bane, bwele sie. Ale mulikunkonkelaki? Nsikikavyala kabili baana balalume bakuti bakamyupe. ");
INSERT INTO tap_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Mwe baana bane, bwele, endo mwaya, pantu nene nsisyakotele, nsikikoopua. Kibenge evio, nga lelo lyenka naupua ni kuvyala baana balalume. ");
INSERT INTO tap_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Anzia kibenge evio, kubako nga mwaapembeele baana bakule ni kuya mwaikeele pasili kuupua? Mwe baana bane, keki kyangaviizia nene kukila mwemue, pantu Yawe wandekeela.” ");
INSERT INTO tap_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kabili baatendekele kulila. Kupwako, Orpa wamulaya nghinavyala, inzi Rutu wene waasyele sie wamuuminiine. ");
INSERT INTO tap_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi waamwanine evi, “Ewe, mona muupua nobe wabwela ku bantu bakue ni ku baleza bakue. Kansi ni we bwela umukonke.” ");
INSERT INTO tap_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rutu wa-asukile evi, “Tekunkania kuya nobe, konse kuwaakaya, i kunaakaya ni nene. Pawaakeekala, i panaakeekala ni nene. Bantu bobe, baakaba bantu bane. Leza obe, waakaba Leza wane. ");
INSERT INTO tap_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Palia pawaakafwila, i panaakafwila ni kuziikua. Ndimukumulomba Yawe ankitile evio ni kukiziapo. Nsikalekana nobe, inga sie kufua i kwaakandekania ni wewe.” ");
INSERT INTO tap_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi lu-aamwene nangue Rutu waali wamuuminiine sie kuya pamo nakue, taalandile kantu kabili. ");
INSERT INTO tap_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Kupwako, bonse babili baya mpaka ku Betlehemu. Lubaafikile mu muzi wa Betlehemu, bantu bonse baapapile. Banakazi ba mu Betlehemu baipuzyaniizie, “Kubako ozu i Naomi?” ");
INSERT INTO tap_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomi waabaanine evi, “Tekunkuute Naomi. Inzi nkuute sie Mara, Pantu wa Maka onse wakinkitila bintu bya bulanda. ");
INSERT INTO tap_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Naile nakwete bintu bingi, inzi Yawe wan'mbwezia naikumbeete. Ale mulikunkuutilaki Naomi ne akandilue na Yawe? Ne waakitiilue bintu bya bulanda na Yawe wa Maka onse?” ");
INSERT INTO tap_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Evi i vyaabwelele Naomi pamo ni Rutu muka mwana wakue wa ku kyalo kya Moabu. Lubaafikile ku Betlehemu, waali wasyali musita wa kuseepa nghano. ");
INSERT INTO tap_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Boazi waali muntu munonsi kabili mukindami. Ozo Boazi, waali wa mu lupua lwakua Elimeleki muka Naomi. ");
INSERT INTO tap_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Rutu wa ku kyalo kya Moabu waamwanine Naomi nangue, “N'mpeele nsambu ya kuya ku bukaba ku kusolola nghano. Nketekeele nangue naya nsangeko muntu umo waya angitabizie kubomba nakue.” Naomi waamwanine evi, “We mwana wane, endo.” ");
INSERT INTO tap_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kupwako, waya ku bukaba. Lu-aafikile, waatendekele kusolola molia mwaali mwapita mwaseepa babombi. Ni mu lisyuko lyakue, waingiile mu bukaba bwakua Boazi wa mu lupua lwakua Elimeleki. ");
INSERT INTO tap_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Pa kyamba, Boazi waizile kufuma ku Betlehemu ni kuya kupozia babombi walanda nangue, “Yawe abe nenu.” Ni bene baamwitabiile balanda nangue, “Yawe akupaale.” ");
INSERT INTO tap_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boazi waamwipuziizie mubombi mukulu wabo nangue, “Ale olia mukazyana ni wa kupi?” ");
INSERT INTO tap_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mukulu wa babombi waamwasukile evi, “Olia mukazyana ni wa ku Moabu, wakiiza watwemue na Naomi kufuma mu kyalo kya Moabu. ");
INSERT INTO tap_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Wakilanda evi, ‘Nalombako nsambu ya kuya napita nasolola molia mulimwapita mwaseepa babombi.’ Ni pakako, wabombanga kutula lukeelekeele mpaka ono musita, inzi ku katanda wayanga sie kutuuziako musita uniini.” ");
INSERT INTO tap_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boazi waamwanine Rutu, “We mwana wane, unvua nkusoke, tekuba waya kusolola mu ange makaba, inga sie mu bobu bukaba. Bomba sie na baba benka babombi bane bakazyana bali pano. ");
INSERT INTO tap_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Pooza sie maano mu bobu bwenka bukaba bubalimukuseepamo, wali sie pano penka pamo nabo, kabili tekulekeela balumendo bakusaapile, inzi kine waunvua kyaka, upalile kumina sie mu katondo ka menda atapilue na balumendo.” ");
INSERT INTO tap_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Kupwako, Rutu wafukama, wafwinamina pansi wamwana nangue, “Ale ne mweni nasyuka syani pakuti un'mpoozeko maano?” ");
INSERT INTO tap_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boazi waamwasukile evi, “Bakin'mbwila byonse biwaakitiile nokovyala lwaafwile mulume obe, ni viwaasiile noko ni so, ni kyalo kiwaavyaliiluemo, mpaka watona kwiza ku bantu bausyaali wamanine kutula ku kale. ");
INSERT INTO tap_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Yawe akulambwilepo pa byonse biwakikita. Yawe wa Baizraeli uwakibutukilako mu kyeni kyakue akupaale.” ");
INSERT INTO tap_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutu waalandile evi, “We mukulu, kisinka wankitila biweme. Wewe wanengia kwiunvua bwino mu kulanda kobe wafuukile anzia kine nsilingheene na mubombi umo wa pa babombi bobe banakazi.” ");
INSERT INTO tap_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kabili pa musita wa kulia, Boazi waamwanine Rutu nangue, “Iza ulie mukate utulitwaliako ni kutobela mu divai iseeme.” Kupwako, waikala pamo ni babombi, Boazi wamupeelako ni nghano ikangile, walia, waikuta ni kusiapo binge bilio. ");
INSERT INTO tap_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Kabili lu-aabuukile kuti aye ku kusolola nghano, Boazi wa-anine babombi bakue nangue, “Anzia asomona ni ili mu bisi, tekumusasilile. ");
INSERT INTO tap_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Mu elia milui imulimwatuulika, muye mwamusiilamo iniini ya kuti aye watoola, tekumukaanie.” ");
INSERT INTO tap_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ni pakako, Rutu waasolwele nghano mu bukaba mpaka kyungulo. Lu-aapuulile, wauluziizie mupepi kilo 22 ya nghano. ");
INSERT INTO tap_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Waitwikile ni kubwelela ku muzi, waya kumulangisia nghinavyala nghano i-aasolwele. Kupwako, wamupeela bilio bi-aasiilepo lolia lu-aikutile. ");
INSERT INTO tap_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nghinavyala waamwipuziizie evi, “Lelo wayanga kusolwela pi? Wasololanga mu bukaba bwakua ni? Ozo muntu wakupoozangako maano apaalue!” Rutu waamwanine Naomi nangue, “Nasololanga mu bukaba bwakua Boazi.” ");
INSERT INTO tap_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ni Naomi waamwanine muka mwana wakue nangue, “Yawe olia atwaliliile kufikilizia bulayo bwakue ku bakosele ni bafwile, apaale ozo muntu wa mu lupua lwetu lwa pepi, pantu wene i wa mu bakalubula betu.” ");
INSERT INTO tap_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rutu wa ku Moabu waalandile evi, “Boazi wanghananga evi, ‘Ba wali pamo ni babombi bane mpaka pabakaba kupua kuseepa nghano yane yonse.’” ");
INSERT INTO tap_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Kupwako, Naomi wamwana Rutu muka mwana wakue nangue, “We mwana wane, kyawama uye wabomba pamo ni babombi bakazyana bakua Boazi, kabili tekuti ukasangue na bange bantu mu bukaba nghwana ukeeza kukitikilua na kibiipile.” ");
INSERT INTO tap_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ni kiine, Rutu waabombele pamo nabo ni kuya wasololamo mpaka ku mpeleezio ya kuseepa shairi ni nghano. Kabili waatwaliliile kwikala ni nghinavyala. ");
INSERT INTO tap_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Busiku bumo, Naomi waamwanine Rutu nangue, “Nene n'mpalile kukuufia evi ni we wikwatile nghanda yobe. ");
INSERT INTO tap_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Upalile kumana nangue ozu Boazi wakiba wabombelua na bakazyana bawakiba nabo, i kalubula wetu. Ale unvua, lelo kyungulo alikuya wauluzia nghano ku kyuluziizio. ");
INSERT INTO tap_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ni pakako, nakwana usambe bwino wisube ni mafuta anunkiile, uvwale ngubo yobe i-umwene yawamiisie, mane uye wimane palia pa-alikuya wauluziizia. Inzi tekuti uye wilangisie kuli wene mpaka musita u alikuya kupwilapo kulia ni kumina. ");
INSERT INTO tap_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Upoozeko maano kumana pa-alikuya kulaala. Musita u alikuya kuona, uye umuvimbule ku makasa ni kulaala lya koko kwenka. Ni ye waya akwane vyakukita.” ");
INSERT INTO tap_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rutu waamwaanine, “Naya nkite kubalua kantu kawanghana.” ");
INSERT INTO tap_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Rutu ni ye waile ku kyuluziizio ni kukita kubalua kantu mwamwaaniine nghinavyala. ");
INSERT INTO tap_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boazi lu-aapwile kulia ni kumina, waasansamukile, waile kulaala mumbali mului wa nghano. Rutu waile buke buke, wamuvimbula Boazi ku makasa ni kulaala lya koko kwenka. ");
INSERT INTO tap_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Pakati busiku Boazi waatulumukile, mukwana nangue apilibuke, waapapile kumona mwanakazi waleele lya ku makasa akue. ");
INSERT INTO tap_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Boazi waamwipuziizie evi, “Uli ni?” Wa-asukile nangue, “Ni nene mubombi obe Rutu, nvimbeko sie lupipi lwa ngubo yobe pantu wewe uli kalubula wetu. Nakulomba ube mulume wane.” ");
INSERT INTO tap_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boazi waamwanine Rutu nangue, “We mwana wane, Yawe akupaale, pantu buwame buwakita, bwakila buwame buwaakitile pa mambo, pantu tewakibembua na balumendo, na bapabi ao na banonsi. ");
INSERT INTO tap_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Kansi we mwana wane tekutiina, nene ndikukukitila byonse muwalandila pantu bantu bonse mu ono muzi bamanine nangue uli mwanakazi wa mibeele iweme. ");
INSERT INTO tap_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Anzia kine nene ndi kalubula wa pepi, inzi kulanda kisinka, kuli ni unge kalubula apalamiisie kukila nene. ");
INSERT INTO tap_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Wewe pembela sie bono busiku bukie, kine ozo muntu wakaba kwitabila kukukitila mukipaliile mu lupua, kyakaba kuwama. Inzi kine akabe kukaana, nene nakaba kukukitila mukipaliile, nene nalapa mu Liina lyakua Yawe Mukose nangue nakaba kukupoozako maano. Ale laala sie bukie.” ");
INSERT INTO tap_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kupwako, mwanakazi walaala ku ntambalilo mpaka ku makia. Waabuukile ku makia pa kamuntu uli ni, pantu Boazi waalandile nangue, “Tekipalile kimanike nangue ku kyuluziizio kwakiiza ni mwanakazi.” ");
INSERT INTO tap_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boazi waamwanine evi, “Leeta ngubo i-uvwele u-ipanzike papa.” Ni ye waapanzikile. Boazi waamupongweleelepo nghano kukila pa kilo 20 ni kumutwika. Kupwako, Rutu waya ku muzi. ");
INSERT INTO tap_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Lu-aafikile ku nghanda, nghinavyala waamwipuziizie evi, “We mwana wane, ni syani?” Rutu waamubwilile byonse bi-aakitiilue na Boazi. ");
INSERT INTO tap_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Kabili waamwanine nangue, “Nghano i an'mpeelanga ezi. Walandanga evi, ‘Tekubwela minue kuli nokovyala.’” ");
INSERT INTO tap_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nghinavyala waamwanine evi, “Ale teekamana sie upembele byakaba kukitika. Boazi tavinda kwikalapo sie pasili kupwisia ozu mulandu. Alikuupwisia lelo lyenka.” ");
INSERT INTO tap_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boazi waile pa kifuka kya kulonghaninapo ni kuya kwikala pa nghingililo ya muzi. Olia kalubula waali walanduapo na Boazi lu-aizile kupita lya papo, Boazi waamwanine evi, “Ewe, iza wikalenke pano.” Ni ye waile kwikala. ");
INSERT INTO tap_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boazi waakuutile babikolue lyanondo ba mu muzi ni kubaana bekale papo. Ni bo baikeele. ");
INSERT INTO tap_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Pa kyamba, waamwanine olia kalubula nangue, “Naomi olia wakibwela kufuma ku kyalo kya Moabu, alimukusisia nkendo ya bulongo bwakua mukwetu Elimeleki. ");
INSERT INTO tap_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Nene nakimona kuti nkubwileko ozu mulandu ni kukwana usite ezi nkendo ntanzi ya baba bantu bekeele papa ni ntanzi ya masiiko a bantu bane. Kine wewe ulikusita, sita. Inzi kine teusita, landa, pantu tekuli unge apalile kusita ezi nkendo, inga sie wewe. Kine te wewe, ni nene.” Ni ye waalandile evi, “Ndikusita.” ");
INSERT INTO tap_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boazi waalandile evi, “Mana nangue busiku buwakaba kusita ezi nkendo kuli Naomi ni kuli Rutu, i busiku buwakaba kumusita ni Rutu wa ku kyalo kya Moabu, evi akavyale mwana mwalalume waakapyana bintu byakua mulume wakue waafwile.” ");
INSERT INTO tap_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ozo kalubula wa-asukile evi, “Nene nsivinda kusita ezi nkendo nkeeza kwinoona bupyani bwane. Kansi nsambu yane ya bukalubula itwamue sie na wewe wenka, pantu nene na-andua.” ");
INSERT INTO tap_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Mu ezio nsiku, Baizraeli baali ni mibeele yabo ya kusininkiziiziako pa kulubula ni kusintuzyania kintu. Muntu waali wavuula nkwabilo yakue ni kumupeela mwinakue. Keki i kyaali kisininkiziizio ku Baizraeli. ");
INSERT INTO tap_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ozo muntu waamwanine Boazi nangue, “Sita sie wewe wenka.” Kupwako, kalubula wavuula nkwabilo ni kumupeela Boazi. ");
INSERT INTO tap_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boazi ni ye wa-anine bantu bonse pamo ni alia masiiko aalipo nangue, “Mwe bonse bali pano muli basininkizi bakusininkizia nangue, lelo nasita kuli Naomi bintu byonse byaali byakua Elimeleki ni byakua Kilioni pamo ni byakua Maloni. ");
INSERT INTO tap_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Kabili ni ozu Rutu wa ku Moabu muka Maloni ni ye kumo namusita kuti aye waali mukazi wane. Nakita evi kuti nsunge liina lya muntu waafwile, pakuti akabe walangulukilue mu muzi wetu ni mu lupua lwetu. Ni evi vyenka lelo muli basininkizi.” ");
INSERT INTO tap_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Masiiko pamo ni bantu baali balipo baalandile evi, “Ee, fwefue tuli basininkizi. Ozu mwanakazi uwatwama kuba mukazi obe, twalomba Yawe amukite kuba nga Rakeli ni Lea, babo baamukuuliile Izraeli nghanda. Kabili twalomba wewe uye walumine mu Efrati ni kuya wamanikile mu Betlehemu. ");
INSERT INTO tap_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Baana bawaakapeelua na Yawe mu ozu mukazyana bakalengie lupua lobe lukapalane ni lwakua Perezi lwaavyelue na Tamari kuli Yuda.” ");
INSERT INTO tap_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kupwako, Boazi wamutwama Rutu ni kumwalula mukazi. Yawe waamupaalile, waimita ni kuvyala mwana mwalalume. ");
INSERT INTO tap_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Banakazi baamwanine Naomi nangue, “Yawe atasiiwe! Ozo asikulekeleele lelo kuti uye wali ni kalubula. Twalomba alengie ozu mwana kumanika mu Izraeli. ");
INSERT INTO tap_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ozu mwanavyala obe kisinka akutonene, wakikukitila bintu bikata kukila bintu bya kukitilua na baana balalume kilooba. Kabili wakuvyalila ni mwinzikulu, ozo waakaalula bwikazi bobe kuba bwa lenu ni kukusunga mu bukote bobe.” ");
INSERT INTO tap_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kupwako, Naomi wabuula mwana wamufukatila ni kutwalilila kumusunga. ");
INSERT INTO tap_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Banakazi baali bali pepi nakue baamwinikile mwana liina lya Obedi. Baalandile evi, “Naomi wavyalilua mwana mwalalume!” Obedi i waavyele Yese, ni Yese i waavyele Daudi. ");
INSERT INTO tap_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Bobu i butantiko bwa meena a lupua lwakua Perezi mpaka kuli Daudi. Perezi waavyele Hezroni, Hezroni waavyele Ramu, Ramu waavyele Aminadabu, Aminadabu waavyele Nasoni, Nasoni waavyele Salmoni, Salmoni waavyele Boazi, Boazi waavyele Obedi, Obedi waavyele Yese, Ni Yese waavyele Daudi.");
INSERT INTO tap_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","1","Mu mwaka wa mambo wa kuteeka kwakua Kiro likolo wa ku Persia, Yawe waakoseleziizie mutima wakua likolo wa ku Persia kuti keebo kakua Yawe kaalandilue na kabika Yeremia kafikiliziwe. Waamwanine apunde mu bukolo bwakue bonse ni kulemba nangue: ");
INSERT INTO tap_vpl VALUES ("ER1_2","016_1_2","EZR","1","2","2","Kiro likolo wa ku Persia walanda evi, “Yawe Leza wa mwiulu wakin'mpeela bukolo bonse bwa pa kyalo, ni kunghana kumukuulila nghanda mu Yeruzalemu ya mu Yudea. ");
INSERT INTO tap_vpl VALUES ("ER1_3","016_1_3","EZR","1","3","3","Kubalua muntu pakati kenu wa mu bantu bakue, Leza aye waali pamo nakue, kabili aye ku Yeruzalemu ya mu Yudea ku kukuula paakale Nghanda yakua Yawe, Leza wakua Izraeli, wene i Leza ali mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","Kubalua Muyuda ali mu Babeli konse kwaikeele kine watona kubwelela ku Yeruzalemu, bantu ba ku ezio nkendo bapalile kumukwasiako mutofue, ni oro, ni binge bintu, ni nama, pamo ni bupe bwa kupeela mu Nghanda yakua Leza mu Yeruzalemu.” ");
INSERT INTO tap_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Kupwako, bakulu ba mu lupua lwakua Yuda ni lwakua Benyamina, ni babitambua, ni Balawi, pamo ni bonse baakoseleziiziwe mu mitima na Leza, baiteaniizie kuya kukuula paakale Nghanda yakua Yawe mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Bonse baali bapalameene nabo baabakwasiizie mutofue, ni oro, ni binge bintu, ni nama, ni bintu bikindeeme, pamo ni bupe bubaali bapeela mutoneene mitima yabo. ");
INSERT INTO tap_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","Ni pakako, Likolo Kiro waafumiizie bintu bya mu Nghanda yakua Yawe byaatwemue na Nebukadneza kufuma ku Yeruzalemu, ni kubibiika mu nghanda ya baleza bakue. ");
INSERT INTO tap_vpl VALUES ("ER1_8","016_1_8","EZR","1","8","8","Bebio bintu, Kiro likolo wa ku Persia, waamupeele Mitiredati aliwalabukila bukonto, ni kumupendela Sesebasari mulombozi wa Bayuda. ");
INSERT INTO tap_vpl VALUES ("ER1_9","016_1_9","EZR","1","9","9","Mpendua ya bintu ni ezi: Masaani 30 akata a oro, masaani 1,000 akata a mutofue, myele 29, ");
INSERT INTO tap_vpl VALUES ("ER1_10","016_1_10","EZR","1","10","10","bibakuli 30 bya oro, bibakuli bya mutofue bikonkelepo pa bukindami 410, ni bintu binge 1,000. ");
INSERT INTO tap_vpl VALUES ("ER1_11","016_1_11","EZR","1","11","11","Bintu byonse bya oro ni bya mutofue pamo ni binge bintu, byaali 5,400. Bebi byonse Sesebasari waabitwele lolia lwaabweziiziwe balia baali bafuma ku Babeli balimukuya ku Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER2_1","016_2_1","EZR","2","1","1","Baba i bekazi ba mu nsempu ya kiputu kya kyalo baatwemue na Nebukadneza likolo wa ku Babeli mpaka ku Babeli, i baabwelele ku Yeruzalemu ni ku kyalo kya Yudea, kubalua muntu mu muzi wakue. ");
INSERT INTO tap_vpl VALUES ("ER2_2","016_2_2","EZR","2","2","2","Baba bantu i baile pamo ni Zerubabeli, ni Yoshua, ni Nehemia, ni Seraia, ni Relaia, ni Mordekai, ni Bilsani, ni Misipari, ni Bigwai, ni Rehumu, ni Bana. Mpendua ya baana balalume ba mu Izraeli ni ezi: ");
INSERT INTO tap_vpl VALUES ("ER2_3","016_2_3","EZR","2","3","3","Baana balalume bena Parosi baali 2,172. ");
INSERT INTO tap_vpl VALUES ("ER2_4","016_2_4","EZR","2","4","4","Baana balalume bena Sefatia baali 372. ");
INSERT INTO tap_vpl VALUES ("ER2_5","016_2_5","EZR","2","5","5","Baana balalume bena Ara baali 775. ");
INSERT INTO tap_vpl VALUES ("ER2_6","016_2_6","EZR","2","6","6","Baana balalume bena Phati-Moabu, benzikulu bakua Yeshua ni Yoabu, baali 2,812. ");
INSERT INTO tap_vpl VALUES ("ER2_7","016_2_7","EZR","2","7","7","Baana balalume bena Elamu baali 1,254. ");
INSERT INTO tap_vpl VALUES ("ER2_8","016_2_8","EZR","2","8","8","Baana balalume bena Zatu baali 945. ");
INSERT INTO tap_vpl VALUES ("ER2_9","016_2_9","EZR","2","9","9","Baana balalume bena Zakai baali 760. ");
INSERT INTO tap_vpl VALUES ("ER2_10","016_2_10","EZR","2","10","10","Baana balalume bena Bani baali 642. ");
INSERT INTO tap_vpl VALUES ("ER2_11","016_2_11","EZR","2","11","11","Baana balalume bena Bebai baali 623. ");
INSERT INTO tap_vpl VALUES ("ER2_12","016_2_12","EZR","2","12","12","Baana balalume bena Agzadi baali 1,222. ");
INSERT INTO tap_vpl VALUES ("ER2_13","016_2_13","EZR","2","13","13","Baana balalume bena Adonikamu baali 666. ");
INSERT INTO tap_vpl VALUES ("ER2_14","016_2_14","EZR","2","14","14","Baana balalume ba mu luvyalo lwakua Bigwai baali 2,056. ");
INSERT INTO tap_vpl VALUES ("ER2_15","016_2_15","EZR","2","15","15","Baana balalume bena Adini baali 454. ");
INSERT INTO tap_vpl VALUES ("ER2_16","016_2_16","EZR","2","16","16","Baana balalume bena Ateri, benzikulu bakua Hezekia, baali 98. ");
INSERT INTO tap_vpl VALUES ("ER2_17","016_2_17","EZR","2","17","17","Baana balalume bena Besai baali 323. ");
INSERT INTO tap_vpl VALUES ("ER2_18","016_2_18","EZR","2","18","18","Baana balalume bena Yora baali 112. ");
INSERT INTO tap_vpl VALUES ("ER2_19","016_2_19","EZR","2","19","19","Baana balalume bena Hasumu baali 223. ");
INSERT INTO tap_vpl VALUES ("ER2_20","016_2_20","EZR","2","20","20","Baana balalume bena Gibari baali 95. ");
INSERT INTO tap_vpl VALUES ("ER2_21","016_2_21","EZR","2","21","21","Baana balalume ba ku Betlehemu baali 123. ");
INSERT INTO tap_vpl VALUES ("ER2_22","016_2_22","EZR","2","22","22","Baana balalume ba ku Netofa baali 56. ");
INSERT INTO tap_vpl VALUES ("ER2_23","016_2_23","EZR","2","23","23","Baana balalume ba ku Anatoti baali 128. ");
INSERT INTO tap_vpl VALUES ("ER2_24","016_2_24","EZR","2","24","24","Baana balalume ba ku Azimaweti baali 42. ");
INSERT INTO tap_vpl VALUES ("ER2_25","016_2_25","EZR","2","25","25","Baana balalume ba ku Kiriati-Arimu, Kefira, ni Beroti, baali 743. ");
INSERT INTO tap_vpl VALUES ("ER2_26","016_2_26","EZR","2","26","26","Baana balalume ba ku Rama ni Geba baali 621. ");
INSERT INTO tap_vpl VALUES ("ER2_27","016_2_27","EZR","2","27","27","Baana balalume ba ku Mikimasi baali 122. ");
INSERT INTO tap_vpl VALUES ("ER2_28","016_2_28","EZR","2","28","28","Baana balalume ba ku Beteli ni ku Ai baali 223. ");
INSERT INTO tap_vpl VALUES ("ER2_29","016_2_29","EZR","2","29","29","Baana balalume ba ku Nebo baali 52. ");
INSERT INTO tap_vpl VALUES ("ER2_30","016_2_30","EZR","2","30","30","Baana balalume ba ku Magibisi baali 156. ");
INSERT INTO tap_vpl VALUES ("ER2_31","016_2_31","EZR","2","31","31","Baana balalume ba ku Eleamu unge baali 1,254. ");
INSERT INTO tap_vpl VALUES ("ER2_32","016_2_32","EZR","2","32","32","Baana balalume ba ku Harimu baali 320. ");
INSERT INTO tap_vpl VALUES ("ER2_33","016_2_33","EZR","2","33","33","Baana balalume ba ku Lodi, ni ku Adidi, ni ku Ono, baali 725. ");
INSERT INTO tap_vpl VALUES ("ER2_34","016_2_34","EZR","2","34","34","Baana balalume ba ku Yeriko baali 345. ");
INSERT INTO tap_vpl VALUES ("ER2_35","016_2_35","EZR","2","35","35","Baana balalume ba ku Sena baali 3,630. ");
INSERT INTO tap_vpl VALUES ("ER2_36","016_2_36","EZR","2","36","36","Nvyalo ya babitambua bena Yedaia, wa mu nghanda yakua Yeshua, baali 973. ");
INSERT INTO tap_vpl VALUES ("ER2_37","016_2_37","EZR","2","37","37","Baana balalume bena Imeri baali 1,052. ");
INSERT INTO tap_vpl VALUES ("ER2_38","016_2_38","EZR","2","38","38","Baana balalume bena Pashuri baali 1,247. ");
INSERT INTO tap_vpl VALUES ("ER2_39","016_2_39","EZR","2","39","39","Baana balalume bena Harimu baali 1,017. ");
INSERT INTO tap_vpl VALUES ("ER2_40","016_2_40","EZR","2","40","40","Nvyalo ya Balawi baabwelele kufuma mu buzia ni ezi: Baana balalume bena Yeshua ni Kadimieli, benzikulu bakua Hodavia, baali 74. ");
INSERT INTO tap_vpl VALUES ("ER2_41","016_2_41","EZR","2","41","41","Nvyalo ya bakemba, baana balalume bena Asafu, baali 128. ");
INSERT INTO tap_vpl VALUES ("ER2_42","016_2_42","EZR","2","42","42","Nvyalo ya baana balalume bena bakalinda ba pa mulyango wa Nghanda yakua Leza, bena Salumu, ni bena Ateri, ni bena Talumoni, ni bena Akubu, ni bena Hatita, ni bena Sobai, bonse pamo baali 139. ");
INSERT INTO tap_vpl VALUES ("ER2_43","016_2_43","EZR","2","43","43","Nvyalo ya babombi ba mu Nghanda yakua Leza baabwelele kufuma mu buzia ni ezi: Baana balalume bena Siha, ni bena Hasufa, ni bena Tabaoti, ");
INSERT INTO tap_vpl VALUES ("ER2_44","016_2_44","EZR","2","44","44","ni bena Kerosi, ni bena Siaha, ni bena Padoni, ");
INSERT INTO tap_vpl VALUES ("ER2_45","016_2_45","EZR","2","45","45","ni bena Lebana, ni bena Hegaba, ni bena Akubu, ");
INSERT INTO tap_vpl VALUES ("ER2_46","016_2_46","EZR","2","46","46","ni bena Hagabu, ni bena Semaia, ni bena Hanani, ");
INSERT INTO tap_vpl VALUES ("ER2_47","016_2_47","EZR","2","47","47","ni bena Gideli, ni bena Gahari, ni bena Reaia, ");
INSERT INTO tap_vpl VALUES ("ER2_48","016_2_48","EZR","2","48","48","ni bena Resini, ni bena Nekoda, ni bena Gazamu, ");
INSERT INTO tap_vpl VALUES ("ER2_49","016_2_49","EZR","2","49","49","ni bena Uza, ni bena Pasea, ni bena Besai, ");
INSERT INTO tap_vpl VALUES ("ER2_50","016_2_50","EZR","2","50","50","ni bena Asina, ni bena Munimu, ni bena Nefisimu, ");
INSERT INTO tap_vpl VALUES ("ER2_51","016_2_51","EZR","2","51","51","ni bena Bakubuki, ni bena Hakufa, ni bena Harihuri, ");
INSERT INTO tap_vpl VALUES ("ER2_52","016_2_52","EZR","2","52","52","ni bena Basiluti, ni bena Mehida, ni bena Harsa, ");
INSERT INTO tap_vpl VALUES ("ER2_53","016_2_53","EZR","2","53","53","ni bena Barkosi, ni bena Sisera, ni bena Tema, ");
INSERT INTO tap_vpl VALUES ("ER2_54","016_2_54","EZR","2","54","54","ni bena Nesia, ni bena Hatifa. ");
INSERT INTO tap_vpl VALUES ("ER2_55","016_2_55","EZR","2","55","55","Nvyalo ya babombi bakua Solomoni baabwelele kufuma mu buzia ni ezi: Baana balalume bena Sotai, ni bena Soferiti, ni bena Pedura, ");
INSERT INTO tap_vpl VALUES ("ER2_56","016_2_56","EZR","2","56","56","ni bena Yala, ni bena Darkoni, ni bena Gideli, ");
INSERT INTO tap_vpl VALUES ("ER2_57","016_2_57","EZR","2","57","57","ni bena Sefatia, ni bena Hatili, ni bena Pokereti-Hazebaimu, ni bena Ami. ");
INSERT INTO tap_vpl VALUES ("ER2_58","016_2_58","EZR","2","58","58","Nvyalo ya babombi ba mu Nghanda yakua Leza, ni baana balalume bena babombi bakua Solomoni, baali 392. ");
INSERT INTO tap_vpl VALUES ("ER2_59","016_2_59","EZR","2","59","59","Baba i balia baafumine ku Teli-Mela, ni ku Teli-Harsa, ni ku Kerubu, ni ku Adani, ni ku Imeri. Inzi tebaile kulondolola nangue babikolue babo pamo ni nvyalo yabo baali Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER2_60","016_2_60","EZR","2","60","60","Nvyalo ya baana balalume bena Delaia, ni bena Tobia, ni bena Nekoda, baali 652. ");
INSERT INTO tap_vpl VALUES ("ER2_61","016_2_61","EZR","2","61","61","Ni bena Hobaia, ni bena Hakosi, ni bena Barzilai waupile mukazyana wa mu lupua lwakua Barzilai Mugileadi, ni kwinikua liina lyabo. ");
INSERT INTO tap_vpl VALUES ("ER2_62","016_2_62","EZR","2","62","62","Babo bantu baakebele mu butantiko bwa meena a nvyalo yabo, inzi tebaamwenekelemo. Ni pakako, baamwenekele kuba batiikeene, i kyaalengele kuti babafumie pa mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("ER2_63","016_2_63","EZR","2","63","63","Ndabukizi waabakaaniizie kulia bintu bizuukiisie, mpaka musita waakabapo kitambua wa kubombia Urimu ni Tumimu. ");
INSERT INTO tap_vpl VALUES ("ER2_64","016_2_64","EZR","2","64","64","Bantu bonse baabwelele kufuma mu buzia baali 42,360 ");
INSERT INTO tap_vpl VALUES ("ER2_65","016_2_65","EZR","2","65","65","pasili kupendako babombi babo balalume ni banakazi baali 7,337, momo mwaali ni bakemba balalume ni banakazi 200. ");
INSERT INTO tap_vpl VALUES ("ER2_66","016_2_66","EZR","2","66","66","Bafarasi babo baali 736 ni nyumbu twaali 245. ");
INSERT INTO tap_vpl VALUES ("ER2_67","016_2_67","EZR","2","67","67","Nghamia yabo yaali 435 bapunda baali 6,720. ");
INSERT INTO tap_vpl VALUES ("ER2_68","016_2_68","EZR","2","68","68","Lubaafikile mu Nghanda yakua Yawe ku Yeruzalemu, bamasiiko babo baapeele bupe bwa bunonsi bwabo na mutima onse pakuti Nghanda yakua Leza ikuulue paakale pa nkendo pa yaali yakuulilue. ");
INSERT INTO tap_vpl VALUES ("ER2_69","016_2_69","EZR","2","69","69","Baapeele mwaali mwabeeleele buvinde bwabo, ni mu kipao baabiikilemo kilo 500 ya oro, ni kilo 2,800 ya mutofue, pamo ni nkanzu 100 ya babitambua. ");
INSERT INTO tap_vpl VALUES ("ER2_70","016_2_70","EZR","2","70","70","Evi babitambua, ni Balawi, ni balia bakalinda ba pa mulyango wa Nghanda yakua Leza, ni bakemba, ni bange bantu, ni babombi ba mu Nghanda yakua Leza, pamo ni Baizraeli bonse, i vibaikeele mu mizi yabo. ");
INSERT INTO tap_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Mwezi wa kilooba luwaakumeene, ni Baizraeli bonse lubaali basyali mu mizi yabo, bonse baakolongheene mu Yeruzalemu bali mu kimo. ");
INSERT INTO tap_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Kupwako, Yoshua mwina Yozadaki wabuuka pamo ni ba kwakue babitambua ni Zerubabeli mwina Shealtieli pamo ni ba kwakue, ni kutendeka kukuula paakale kitale kyakua Leza wa Baizraeli, evi baye baelelapo ngelelo ya kuziziiwa nga mukilembeelue mu kitabu kya mizilo yakua Musa muntu wakua Leza. ");
INSERT INTO tap_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Baakuulile paakale kitale palia payaali, anzia baali batiina baeni baali bali mu kyalo, baatendekele kumwelela Yawe ngelelo ya kuzizia ya lukeelekeele ni ya kyungulo. ");
INSERT INTO tap_vpl VALUES ("ER3_4","016_3_4","EZR","3","4","4","Baakitile nsikunkulu ya mitanda nga mukilembeelue, kubalua busiku baali bafumia ngelelo ya kuzizia mukipaliile. ");
INSERT INTO tap_vpl VALUES ("ER3_5","016_3_5","EZR","3","5","5","Pa kyamba, baeleele ngelelo ya kuziziiwa lyonse, ni ngelelo ya kubaluka kwa kwezi, ni ya nsikunkulu yonse yakua Yawe yaalandilue kuti izuukiwe, ni ya kubalua muntu waapeele bupe bwakue kuli Yawe na mutima wakue onse. ");
INSERT INTO tap_vpl VALUES ("ER3_6","016_3_6","EZR","3","6","6","Kutula busiku bwa mambo bwa mwezi wa kilooba, baatendekele kumwelela Yawe ngelelo ya kuziziiwa, inzi kiputa kya Nghanda yakua Yawe Leza kyaali tekinaakuulue. ");
INSERT INTO tap_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Bantu baalongiizie nfolanga ya kusazia babaazi ba mabue ni babaazi ba mbao, kabili baalongiizie ni bilio, ni bya kumina, ni mafuta, evi bitwalue ku bantu ba ku Sidona ni ba ku Tiro kuti bakite makabu na bimuti bya mumpelempele kufuma ku Lebanoni. Bebio bimuti byaaleetelue lya pa mendanke mpaka ku Yopa nga mubaapeleelue nsambu na Kiro likolo wa ku Persia. ");
INSERT INTO tap_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Kupwako, mu mwezi wa bubili wa mu mwaka wa bubili lubaabweleele ku Nghanda yakua Leza ya mu Yeruzalemu, Zerubabeli mwina Shealtieli, ni Yoshua mwina Yozadaki, baabambile kubomba pamo ni ba kwabo, ni babitambua, ni Balawi babaafumine nabo mu buzia ni kubwelela ku Yeruzalemu. Baasaakwile Balawi baali bali na myaka kutendekela pa 20 ni mpuzio kuti baye bali bemanizi ba mwilo wa Nghanda yakua Yawe. ");
INSERT INTO tap_vpl VALUES ("ER3_9","016_3_9","EZR","3","9","9","Yeshua i lu-aabuukile pamo ni baana bakue ni ba kwakue, ni Kadimieli ni baana bakue, ni baana bena Yuda, ni baana bena Henadadi pamo ni baana ba balupua babo Balawi, bonse pamo baabuukile ni kwimaninako bakuuli ba Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("ER3_10","016_3_10","EZR","3","10","10","Bakuuli lubaapwile kukuula kiputa kya Nghanda yakua Yawe, baabiikile babitambua bavwele makanzu a bukitambua koku bakwete ni ntandala, ni Balawi bena Asafu bakwete binsekelembue kuti bamutasie Yawe nga muba-aniinue na Daudi likolo wa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER3_11","016_3_11","EZR","3","11","11","Ni bo baimbile bamutasia Yawe balanda nangue, “Wene aweme, ni ntono yakue ku Baizraeli, ya muyayaya.” Bantu bonse baazanzwile mazui lubaali bamutasia Yawe, pantu kiputa kya Nghanda yakua Yawe kyaali kyasyakuulilue. ");
INSERT INTO tap_vpl VALUES ("ER3_12","016_3_12","EZR","3","12","12","Inzi babitambua bengi ni Balawi, ni bakulu ba mikowa, pamo ni bamasiiko baamweneko Nghanda ya mambo yakua Yawe, lubaamwene kiputa kya ezi Nghanda kyakuulilue, baalilile bazanzwile mazui, ni bange bengi baasamwine na nsansa. ");
INSERT INTO tap_vpl VALUES ("ER3_13","016_3_13","EZR","3","13","13","Bantu ba-andilue kwinika mazui a nsansa ni mazui a malilo, pantu bantu baakilile kusamuna ni mazui abo aunvwikile kule. ");
INSERT INTO tap_vpl VALUES ("ER4_1","016_4_1","EZR","4","1","1","Balwani ba Bayuda ni ba mu mukowa wakua Benyamina lubaunvwile nangue, balia baafumine mu buzia balimukukuula paakale Nghanda yakua Yawe Leza wa Baizraeli, ");
INSERT INTO tap_vpl VALUES ("ER4_2","016_4_2","EZR","4","2","2","baile kuli Zerubabeli, ni ku bakulu ba mikowa. Baabaanine nangue, “Twatona tumikwasie kukuula paakale, pantu ni fwefue benka tulitwamupupa Leza wenu nga mwemue, kabili tulitwaelela ngelelo kutula pa musita wakua Esari-Hadoni, likolo wa ku Asuria waatuleetele pano.” ");
INSERT INTO tap_vpl VALUES ("ER4_3","016_4_3","EZR","4","3","3","Inzi Zerubabeli ni Yoshua, ni bakulu ba mikowa ya Baizraeli pamo ni bange ba-asukile nangue, “Mwemue temulipo na kantu ka kutukwasiizia kukuula paakale Nghanda yakua Leza wetu, inzi fwe bene twakaba kumukuulila Nghanda Yawe Leza wa Baizraeli, nga mutwa-aniinue na Kiro likolo wa ku Persia.” ");
INSERT INTO tap_vpl VALUES ("ER4_4","016_4_4","EZR","4","4","4","Bekala kyalo baatoobwele mitima ya Bayuda ni kubatiinia sana evi tekuti batwalilile kukuula paakale. ");
INSERT INTO tap_vpl VALUES ("ER4_5","016_4_5","EZR","4","5","5","Baapeele ni bituulilo ku babiloolo kuti banzie mapange a Bayuda mu nsiku yonse yakua Kiro likolo wa ku Persia, mpaka pa musita wa kuteeka kwakua Dario likolo wa ku Persia. ");
INSERT INTO tap_vpl VALUES ("ER4_6","016_4_6","EZR","4","6","6","Ni mu buteeko bwakua Ahasuero, ku ntendeko ya buteeko bwakue, bantu baalembele lupapulo lwa kusongela bekazi ba mu Yudea ni ba mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER4_7","016_4_7","EZR","4","7","7","Kabili mu nsiku yakua Artasasta, Bisilamu, ni Mitiredati, ni Tabeli, pamo ni benakue bonse, baamulembeele Artasasta likolo wa ku Persia. Lolo lupapulo lwaalembelue mu lulimi lwa Kishami, ni kubelengua mu lulimi lwa Kishami. ");
INSERT INTO tap_vpl VALUES ("ER4_8","016_4_8","EZR","4","8","8","Kiloolo Rehumu, ni Simusai kalemba, baamulembeele likolo Artasasta lupapulo lwa busongezi palua Yeruzalemu nangue, ");
INSERT INTO tap_vpl VALUES ("ER4_9","016_4_9","EZR","4","9","9","“Lupapulo kufuma kuli ndabukizi Rehumu kiloolo wa balukale, ni kalemba Simusai, ni ba mu mukowa wakue, ni bapinguzi, ni bange babiloolo baali bafumine ku mizi ya Ereki, ni ku Babeli, ni ku Susani, ni ku kyalo kya Elamu, ");
INSERT INTO tap_vpl VALUES ("ER4_10","016_4_10","EZR","4","10","10","ni ntundu yonse yaasyeelepo, yaakumbilue na Osinapari mukulu mukindami, ni kubatwala mu muzi wa Samaria, ni mu nkendo ya kyalo yaali yasyele ku bwala mwenzi wa Efrati.” ");
INSERT INTO tap_vpl VALUES ("ER4_11","016_4_11","EZR","4","11","11","Lupapulo lwaatumiinue likolo Artasasta lwaali lwalembelue evi, “Fwe babombi bobe bali ku bwala mwenzi wa Efrati twakupozia. ");
INSERT INTO tap_vpl VALUES ("ER4_12","016_4_12","EZR","4","12","12","We Likolo, twalomba umane nangue, balia Bayuda baafumine kwenu ni kwiza kono kwetu ku Yeruzalemu, balimukukuula paakale muzi wa bukisanguka ni wa bubi, evi lenu balimukupwililila kibumba ni kukuula paakale kiputa. ");
INSERT INTO tap_vpl VALUES ("ER4_13","016_4_13","EZR","4","13","13","Ni pakako we likolo upalile kumana nangue kine ozu muzi wakuulua ni bibumba byakue byapua, baba bantu tebakaba basonka musonko ni kulambula mulambu pamo ni kusonkela musebo, ni ku mpeleezio bukolo tebukaba na kibwezia. ");
INSERT INTO tap_vpl VALUES ("ER4_14","016_4_14","EZR","4","14","14","Kabili ni fwefue benka pantu tuli ba kisinka ku nghanda ya bukolo, tetupapile kumona likolo wafuupulua. Ni pakako i kitwatumina lupapulo, evi likolo amane nangue ");
INSERT INTO tap_vpl VALUES ("ER4_15","016_4_15","EZR","4","15","15","kipalile kukebelezia mu kitabu kya malanguluzi a babikolue bobe, momo i muulikumona ni kusanga nangue, ozu muzi, kisinka ni muzi wa bukisanguka, ni wa busanzo ku makolo ni ku biputu bya kyalo. Ezio nkendo, ni nkendo ya bwavia kutula pa kale, kabili i kyaalengele ozu muzi winoonue. ");
INSERT INTO tap_vpl VALUES ("ER4_16","016_4_16","EZR","4","16","16","Twakubwila we likolo nangue kine ozu muzi wakuulua paakale ni bibumba byakue kine byapua, kisinka teukaba na nsempu ku bwala mwenzi wa Efrati.” ");
INSERT INTO tap_vpl VALUES ("ER4_17","016_4_17","EZR","4","17","17","Likolo waamwasukile kiloolo Rehumu ni kalemba Simusai, ni benabo bange bonse baali baikele mu Samaria, pamo ni bonse baali baikeele ku bwala mwenzi wa Efrati nangue, “Namipozia. ");
INSERT INTO tap_vpl VALUES ("ER4_18","016_4_18","EZR","4","18","18","Lupapulo lumwakitutumina bakilwalula mu lulimi lwetu ni kun'mbelengela, ");
INSERT INTO tap_vpl VALUES ("ER4_19","016_4_19","EZR","4","19","19","ni nene nakibeetabizia, ni bo bakikebelezia, ni kusanga nangue ozu muzi, kisinka ni muzi wa bukisanguka, ni wa busanzo. ");
INSERT INTO tap_vpl VALUES ("ER4_20","016_4_20","EZR","4","20","20","Bamakolo ba buvinde baali ku Yeruzalemu ni bo baali bateeka kyalo kyonse mpaka ku bwala mwenzi wa Efrati, kabili baali basonkia musonko ni kusonkia mulambu pamo ni kusonkia musebo, ni binge bintu byaali byafuma mu nkendo inge. ");
INSERT INTO tap_vpl VALUES ("ER4_21","016_4_21","EZR","4","21","21","Kansi, biike lifunde lya kubalekezia baba bantu tekuti bakuule paakale ozu muzi mpaka pankaba kubapeela nsambu. ");
INSERT INTO tap_vpl VALUES ("ER4_22","016_4_22","EZR","4","22","22","Kabili kengele tekulekelele ezi milandu inamyana, evi busanzo bukeeza kutwalilila kwemia makolo.” ");
INSERT INTO tap_vpl VALUES ("ER4_23","016_4_23","EZR","4","23","23","Lupapulo lwakua likolo Artasasta pa lwaabelengelue pa menso akua Rehumu, ni Samusai kalemba, ni benabo, baile lubilo ku Bayuda ku Yeruzalemu kuya kubakaania na maka ni buvinde kuti balekele kukuula paakale. ");
INSERT INTO tap_vpl VALUES ("ER4_24","016_4_24","EZR","4","24","24","Evi i vyaimeene miilo ya kukuula paakale Nghanda yakua Leza mu Yerualemu mpaka mu mwaka wa bubili wa kuteeka kwakua Dario likolo wa ku Persia. ");
INSERT INTO tap_vpl VALUES ("ER5_1","016_5_1","EZR","5","1","1","Kupwako, bakabika babili Hagai ni Zakaria wa mu luvyalo lwakua Ido, babikwila Bayuda baali bali mu Yudea ni mu Yeruzalemu. Baababikwiliile mu Liina lyakua Leza wa Baizraeli waali wabasunga. ");
INSERT INTO tap_vpl VALUES ("ER5_2","016_5_2","EZR","5","2","2","Zerubabeli mwina Shealtieli, ni Yoshua mwina Yozadaki, baile kutendeka kukuula paakale Nghanda yakua Leza ya mu Yeruzalemu, kabili baali bakwasiiziwe na bakabika bakua Leza. ");
INSERT INTO tap_vpl VALUES ("ER5_3","016_5_3","EZR","5","3","3","Ozo wenka musita, Tatinai ndabukizi wa kiputu kya kyalo kya ku bwala mwenzi wa Efrati, ni Setari-Bozinai pamo ni benabo bange, baile kuli bene ni kubeepuzia nangue, “Nani wakimipeela nsambu ya kupwililila kukuula paakale ezi Nghanda yakua Leza ni kubiikamo byonse bipalile?” ");
INSERT INTO tap_vpl VALUES ("ER5_4","016_5_4","EZR","5","4","4","Kabili baabepuziizie meena a bantu baali bakuula. ");
INSERT INTO tap_vpl VALUES ("ER5_5","016_5_5","EZR","5","5","5","Inzi Leza waabalabukiile bakulu ba Bayuda. Ni pakako, babiloolo ba ku Persia ba-andilue kubakaania kukuula, mpaka pa bakalembanke lupapulo kuli likolo Dario ni kunvua bwasuko bwakue. ");
INSERT INTO tap_vpl VALUES ("ER5_6","016_5_6","EZR","5","6","6","Lolu i lupapulo lwaatumiinue likolo Dario kuli Tatinai ndabukizi wa kiputu kya kyalo kya ku bwala mwenzi wa Efrati, ni Setari-Bozinai pamo ni benabo bange. ");
INSERT INTO tap_vpl VALUES ("ER5_7","016_5_7","EZR","5","7","7","Lupapulo lwaali lwalembelue evi, “We likolo Dario twakupozia. ");
INSERT INTO tap_vpl VALUES ("ER5_8","016_5_8","EZR","5","8","8","We likolo, twalomba umane nangue lutwakiya kwingila mu Yudea mpaka mu Nghanda yakua Leza Mukulu, twakisanga bantu balimukukuula na mabue akata balimukubiika ni mbao mu bibumba, ezi miilo yakiba yabombua bwino bwino, kabili itwaliliile kubombua lubilo lubilo. ");
INSERT INTO tap_vpl VALUES ("ER5_9","016_5_9","EZR","5","9","9","Twakiipuzia bamasiiko batwane kine nani wakibapeela nsambu ya kupwililila kukuula paakale ezi Nghanda yakua Leza ni kubiikamo byonse bipalile. ");
INSERT INTO tap_vpl VALUES ("ER5_10","016_5_10","EZR","5","10","10","Twakibeepuzia ni meena abo, evi tukulembele twasininkiziiziemo ni meena a bantu babalombwele. ");
INSERT INTO tap_vpl VALUES ("ER5_11","016_5_11","EZR","5","11","11","Bakitwasuka nangue fwefue tuli babombi bakua Leza wa mwiulu ni pansi, kabili tulimukukuula paakale Nghanda yakua Leza nga muyaakuuliilue mu myaka yaapitileko na likolo mukulu wa Baizraeli ni kubiikamo byonse bipalile. ");
INSERT INTO tap_vpl VALUES ("ER5_12","016_5_12","EZR","5","12","12","Inzi basiitue lubaaluviizie kuli Leza wa mwiulu, waabalekeleele kuti batwamue na Nebukadneza Mukaldea likolo wa ku Babeli, kabili i wenka wainoonene ni eno Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("ER5_13","016_5_13","EZR","5","13","13","Inzi mu mwaka wa mambo wakua Kiro likolo wa ku Babeli, ozu likolo waafumiizie nsambu ya kukuula paakale eno Nghanda yakua Leza, ");
INSERT INTO tap_vpl VALUES ("ER5_14","016_5_14","EZR","5","14","14","kabili i waabweziizie ni bintu bya oro ni bya mutofue bya mu Nghanda yakua Leza, belia byaafumiiziwe na Nebukadneza mu Nghanda yakua Leza ya mu Yeruzalemu, ni kubitwala mu nghanda ya baleza ya ku Babeli. Likolo Kiro ni ye waafumiizie bebio bintu mu nghanda ya baleza ya ku Babeli ni kubitwala ku muntu umo liina lyakue Sesebasari waabiikilue kuba ndabukizi wa ku Yudea ");
INSERT INTO tap_vpl VALUES ("ER5_15","016_5_15","EZR","5","15","15","ni kumwana nangue, ‘Twama bebi bintu bya mu Nghanda yakua Leza ukabe kutwala ku Yeruzalemu, ni kumwana kuti Nghanda yakua Leza ikakuulue paakale pa nkendo payaali yakuulilue.’ ");
INSERT INTO tap_vpl VALUES ("ER5_16","016_5_16","EZR","5","16","16","Kupwako Sesebasari waiza ye mwine ni kukuula biputa bya Nghanda yakua Leza ya mu Yeruzalemu. Kutula papo mpaka lenu, ilimukukuulua, ni lenu kumo teinapue. ");
INSERT INTO tap_vpl VALUES ("ER5_17","016_5_17","EZR","5","17","17","Ni pakako, kine kuti kyamuwamina likolo, kuti wakeba mu kitabu kili mu Babeli kilembeluemo bintu byaali byakitika, evi amone kine kisinka likolo Kiro waafumiizie nsambu ya kukuula paakale ezi Nghanda yakua Leza mu Yeruzalemu, ni likolo atwane vili bupinguzi bwakue palua ozu mulandu.” ");
INSERT INTO tap_vpl VALUES ("ER6_1","016_6_1","EZR","6","1","1","Kupwako, likolo Dario wapaana nsambu ya kukeba mu nghanda ya bitabu ili mu Babeli, bitabu byaali byalembeluemo bintu byaali byakitika. ");
INSERT INTO tap_vpl VALUES ("ER6_2","016_6_2","EZR","6","2","2","Ni bo baasangile kitabu mu nghanda ikata ya ku Ekibatana mu kiputu kya kyalo kya ku Media, kekio kyaali kyalembeluepo twebo twa malanguluzi. ");
INSERT INTO tap_vpl VALUES ("ER6_3","016_6_3","EZR","6","3","3","Likolo Kiro mu kuteeka kwakue kwa mwaka wa mambo, waapeene nsambu palua Nganda yakua Leza ya mu Yeruzalemu kuti ikuulue paakale pa nkendo payaali yakuulilue kuti ibe nkendo ya kwelelapo ngelelo ya kuzizia. Mu kutuuluka iye yali metre 27, ni mu kutana iye yali metre 27. ");
INSERT INTO tap_vpl VALUES ("ER6_4","016_6_4","EZR","6","4","4","Bakakite milongo itatu ya mabue akata, ni mulongo umo wa bimuti bya lenu. Ni nfolanga ya kubombia ku ozu mwilo ikafume mu kipao kyakua likolo. ");
INSERT INTO tap_vpl VALUES ("ER6_5","016_6_5","EZR","6","5","5","Ni bibombelo bya oro, pamo ni bya mutofue bya mu Nghanda yakua Leza belia byaatwemue na Nebukadneza kufuma ku Yeruzalemu kutwalua ku Babeli, bipalile bikabweziwe ni kubiikua paakale mu Nghanda yakua Leza ya mu Yeruzalemu, kubalua kintu pa nkendo yakyo, ni byo ukabibiike mu Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("ER6_6","016_6_6","EZR","6","6","6","Ni pakako, we Tatinai ndabukizi wa ku bwala mwenzi wa Efrati, ni Setari-Bozinai, pamo ni benenu bali mu kekio kiputu, fume pa ezio nkendo. ");
INSERT INTO tap_vpl VALUES ("ER6_7","016_6_7","EZR","6","7","7","Tekubavulunghaniizie miilo ya kukuula. Muleke ndabukizi wa Bayuda, pamo ni masiiko a Bayuda bakuule paakale Nghanda yakua Leza pa nkendo pa yaali yakuulilue. ");
INSERT INTO tap_vpl VALUES ("ER6_8","016_6_8","EZR","6","8","8","Unvue vimwaakakitila masiiko a Bayuda palua ezi miilo ya kukuula paakale Nghanda yakua Leza. Mupalile mukabe mwabapeela nfolanga ya pa musonko wa ku bwala mwenzi wa Efrati ya kufuma mu kipao kyakua likolo, evi miilo ya kukuula tekuti ikeemane. ");
INSERT INTO tap_vpl VALUES ("ER6_9","016_6_9","EZR","6","9","9","Bintu byonse bilibyabombiiwa na babitambua ba mu Yeruzalemu, misoka ya nghombe, ni mpanga, ao twina mikooko, ni nghano, ni mukele, ni bya kumina, pamo ni mafuta kuba ngelelo ya kuzizia iliyaelelue Leza wa Mwiulu, bapalile kupeelua kubalua busiku, ");
INSERT INTO tap_vpl VALUES ("ER6_10","016_6_10","EZR","6","10","10","evi baye baelela ngelelo ya bunu buweme kuli Leza wa mwiulu, ni kupepelela bukose bwakua likolo pamo ni baana bakue. ");
INSERT INTO tap_vpl VALUES ("ER6_11","016_6_11","EZR","6","11","11","Kabili nafumia nsambu ya kulanda nangue kubalua muntu asikanakila totu twebo, mukafumie kimuti kimo ku nghanda yakue, mukakisongole ni kumusomekako, ni nghanda yakue ikaalulue mului wa bintu bituutikile. ");
INSERT INTO tap_vpl VALUES ("ER6_12","016_6_12","EZR","6","12","12","Leza olia waalengele liina lyakue kuti liye lyali pa kekio kifuka, alovie makolo ni ntundu yonse yaakaba yatonene kwalulula kaka keebo ni kwinoona ezi Nghanda yakua Leza ili mu Yeruzalemu. Nene Dario i wafumia ezi nsambu, kuti ifikiliziiwe na maka onse. ");
INSERT INTO tap_vpl VALUES ("ER6_13","016_6_13","EZR","6","13","13","Tatinai ndabukizi wa kiputu kya kyalo wa ku bwala mwenzi wa Efrati, ni Setari-Bozinai, pamo ni benabo, baakitile nga muba-aniinue na likolo Dario. ");
INSERT INTO tap_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Masiiko a mu Bayuda baatwaliliile miilo ya kukuula koku balimukukoseleziiwa na kabika Hagai, ni kabika Zakaria wa mu luvyalo lwakua Ido. Baakuulile Nghanda yakua Leza nga muba-aniinue na Leza wa Baizraeli, ni mwaali mwabeeleele lifunde lyakua likolo Kiro, ni lyakua likolo Dario ni Artasasta likolo wa ku Persia. ");
INSERT INTO tap_vpl VALUES ("ER6_15","016_6_15","EZR","6","15","15","Ezi Nghanda yakua Leza yaapwile mu busiku bwa butatu bwa mwezi wa Adari, mu mwaka wa mutanda wa mu buteeko bwakua likolo Dario. ");
INSERT INTO tap_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Baizraeli, ni babitambua, ni Balawi, pamo ni bonse baali bafumine mu buzia, baakitile nsikunkulu ya kuzuukia Nghanda yakua Leza basansamukile. ");
INSERT INTO tap_vpl VALUES ("ER6_17","016_6_17","EZR","6","17","17","Pa kuzuukia Nghanda yakua Leza, baafumiizie bupe bwa nghombe 100, ni mpanga 200, ni mpanga misoka 400, ni palua ngelelo ya bibalo bya Baizraeli, baafumiizie bupe bwa tupwata lyanondo ni tubili, nga mubeeleele mikowa lyanondo ni ibili ya Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER6_18","016_6_18","EZR","6","18","18","Baababiikile babitambua mu mabumba abo, ni Balawi mu mabumba abo batantikilue kuti babombe miilo yakua Leza mu Yeruzalemu nga vikilembeelue mu kitabu kyakua Musa. ");
INSERT INTO tap_vpl VALUES ("ER6_19","016_6_19","EZR","6","19","19","Busiku bwa lyanondo ni buna bwa mwezi wa mambo, balia baabwelele kufuma mu buzia, baakitile nsikunkulu ya Pasaka. ");
INSERT INTO tap_vpl VALUES ("ER6_20","016_6_20","EZR","6","20","20","Pantu bobo busiku babitambua bonse pamo ni Balawi, baisambile ni kwiswesia kukonkana ni mbeela ya mpupo, ni kwipaya mukooko wa Pasaka pa mulandu wa bonse baali babwelele kufuma mu buzia, ni pa mulandu wa babitambua nabo, pamo ni pa mulandu wabo bene. ");
INSERT INTO tap_vpl VALUES ("ER6_21","016_6_21","EZR","6","21","21","Baizraeli bonse baabwelele kufuma mu buzia, pamo ni bonse baali baikekele ku mibeele itiikeene ya Bazima kuti bamupalamine Yawe Leza wa Baizraeli, baaliile mukooko wa Pasaka. ");
INSERT INTO tap_vpl VALUES ("ER6_22","016_6_22","EZR","6","22","22","Baakitile nsikunkulu ya mikate isili na ntutumusi mu nsiku kilooba basansamukile, pantu Yawe waabasansamusiizie ni kulengia mutima wakua likolo wa ku Asuria waluluke, evi abakwasieko mu mwilo wa kukuula paakale Nghanda yakua Leza, Leza wa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER7_1","016_7_1","EZR","7","1","1","Pa kyamba kya bebi byonse, mu buteeko bwakua Artasasta likolo wa ku Persia, Ezra mwina Seraia, Seraia mwina Azaria, Azaria mwina Hilkia, ");
INSERT INTO tap_vpl VALUES ("ER7_2","016_7_2","EZR","7","2","2","Hilkia mwina Salumu, Salumu mwina Sadoki, Sadoki mwina Ahitubu, ");
INSERT INTO tap_vpl VALUES ("ER7_3","016_7_3","EZR","7","3","3","Ahitubu mwina Amaria, Amaria mwina Azaria, Azaria mwina Merayoti, ");
INSERT INTO tap_vpl VALUES ("ER7_4","016_7_4","EZR","7","4","4","Merayoti mwina Zerahia, Zerahia mwina Usi, Usi mwina Buki, ");
INSERT INTO tap_vpl VALUES ("ER7_5","016_7_5","EZR","7","5","5","Buki mwina Abisua, Abisua mwina Finehasi, Finehasi mwina Eleazari, Eleazari mwina Haruni mukulu wa babitambua. ");
INSERT INTO tap_vpl VALUES ("ER7_6","016_7_6","EZR","7","6","6","Ozu Ezra waizile kufuma ku Babeli, kabili i waali wamaniisie mizilo yaapeelue Musa kuli Yawe Leza wa Baizraeli. Likolo waamupeele Ezra byonse bi-aalombele nga mu-aalailue na Yawe. ");
INSERT INTO tap_vpl VALUES ("ER7_7","016_7_7","EZR","7","7","7","Baizraeli bange, ni babitambua, ni Balawi, ni bakemba, ni bakalinda ba pa milyango, pamo ni babombi ba mu Nghanda yakua Leza baile ku Yeruzalemu mu mwaka wa kilooba wa kuteeka kwakua likolo Artasasta. ");
INSERT INTO tap_vpl VALUES ("ER7_8","016_7_8","EZR","7","8","8","Ezra waafikile nabo ku Yeruzalemu mu mwezi wa busaano mu mwaka wa kilooba wa kuteeka kwakua likolo. ");
INSERT INTO tap_vpl VALUES ("ER7_9","016_7_9","EZR","7","9","9","Pantu busiku bwa mambo bwa mu mwezi wa mambo, waatendekele kufuma ku Babeli, ni mu busiku bwa mambo bwa mwezi wa busaano waafikile mu Yeruzalemu, ni Leza waali wamulabukiile. ");
INSERT INTO tap_vpl VALUES ("ER7_10","016_7_10","EZR","7","10","10","Kabili Ezra waali waipeele mu kusambilila mizilo yakua Yawe ni ku-ikonka, pamo ni kusambilizia milao ni bupinguzi ku Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER7_11","016_7_11","EZR","7","11","11","Lupapulo lwaafumine kuli likolo Artasasta lu-aamulembeele kitambua Ezra, kalemba wa milao ni mizilo yakua Yawe ku Baizraeli lwaali evi, ");
INSERT INTO tap_vpl VALUES ("ER7_12","016_7_12","EZR","7","12","12","“Nene Artasasta likolo wa makolo, natuma lupapulo kuli wewe kitambua Ezra kalemba wa mizilo yakua Leza wa mwiulu, nakupozia. ");
INSERT INTO tap_vpl VALUES ("ER7_13","016_7_13","EZR","7","13","13","Nafumia nsambu ya kulanda nangue Baizraeli bonse, ni babitambua babo, pamo ni Balawi, bantu bonse bali mu bukolo bwane, balia batonene kuya ku Yeruzalemu kuti baya pamo ni wewe. ");
INSERT INTO tap_vpl VALUES ("ER7_14","016_7_14","EZR","7","14","14","Pantu wewe watumua na likolo pamo ni bakasoka bakue kilooba kuti uye wipuzie palua Yudea ni Yeruzalemu, nga mubeeleele mizilo yakua Leza obe ili mu minue yobe, ");
INSERT INTO tap_vpl VALUES ("ER7_15","016_7_15","EZR","7","15","15","ni kuya kutwama mutofue, ni oro byaafumiizie likolo ni bakasoka bakue kukonkana ni kutona kwabo ni kumupeela Leza wa Baizraeli ekeele mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER7_16","016_7_16","EZR","7","16","16","Kabili upalile kutwama mutofue onse, ni oro yonse i waakasanga mu kiputu kyonse kya kyalo kya Babeli, pamo ni bupe bwaafumiizie bantu bonse kukonkana ni kutona kwabo, ni bwaafumiizie babitambua pa mulandu wa Nghanda yakua Leza wabo ili ku Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER7_17","016_7_17","EZR","7","17","17","Ezio nfolanga upalile kukita maka obe onse ukabe kusitamo nghombe ndume, ni mpanga, ni twana twa mikooko, pamo ni ngelelo yabo ya bunga, ni ya divai ukaye kwelela pa kitale kya mu Nghanda yakua Leza wenu kili ku Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER7_18","016_7_18","EZR","7","18","18","Mutofue onse ni oro yakaba kusyalapo, wewe ni ba kobe, mukabe kwibombia nga mu mutoneene kukonkana ni kutona kwakua Leza wenu. ");
INSERT INTO tap_vpl VALUES ("ER7_19","016_7_19","EZR","7","19","19","Bibombelo biwaapeelue pa mulandu wa miilo ya mu Nghanda yakua Leza obe, ukabe kubitwala mu Yeruzalemu kuli Leza wa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER7_20","016_7_20","EZR","7","20","20","Kubalua kintu kyaakabula mu Nghanda yakua Leza obe, ukakisite na nfolanga ya mu nghanda ya bukonto yakua likolo. ");
INSERT INTO tap_vpl VALUES ("ER7_21","016_7_21","EZR","7","21","21","Nene likolo Artasasta, napeela nsambu ku basungi bonse ba bukonto ba mu kiputu kya kyalo kya ku bwala mwenzi wa Efrati nangue kubalua kintu kyakaba kukebua na kitambua Ezra kalemba wa Mizilo yakua Leza wa mwiulu mukabe kumupeela pasili kutuntumbila, ");
INSERT INTO tap_vpl VALUES ("ER7_22","016_7_22","EZR","7","22","22","mu kalingo ka talanta kilo 3,400 ya mutofue, ni kilo 10,000 ya nghano, ni litre 22,000 ya divai, ni litre 22,000 ya mafuta a mizeituni, pamo ni mukele wingi nga vi-ali waakalomba. ");
INSERT INTO tap_vpl VALUES ("ER7_23","016_7_23","EZR","7","23","23","Kintu kyonse kyaakalombua na Leza wa mwiulu pa mulandu wa Nghanda yakua Leza, mupalile kukifikilizia bwino, kine te evio, busanzo bwakeeza pali likolo ni pa baana bakue. ");
INSERT INTO tap_vpl VALUES ("ER7_24","016_7_24","EZR","7","24","24","Kabili namyana nangue, tekusonkie musonko ni kulambula mulambu pamo ni kusonkia musebo ku babitambua bakua Leza, ni ku Balawi, ni ku bakemba, ni ku bakalinda ba pa milyango, ni ku babombi ba mu Nghanda yakua Leza, ao babombi bange balibabombelamo. ");
INSERT INTO tap_vpl VALUES ("ER7_25","016_7_25","EZR","7","25","25","Ni we Ezra, kukonkana ni maano awaapeelue na Leza obe, ukabe kusaakula babiloolo ba bapinguzi bakupingula bwino bantu ba mu kiputu kya kyalo kya ku bwala mwenzi wa Efrati. Ukabe kusaakula bantu bamanine mizilo yakua Leza obe. Ni balia basimanine mizilo ukabasambilizie. ");
INSERT INTO tap_vpl VALUES ("ER7_26","016_7_26","EZR","7","26","26","Kubalua muntu asiliwanakila mizilo yakua Leza obe, ni yakua likolo, kisinka apalile kwipawa, ao kukumbua, ao kupokua bunonsi bwakue, ao kukakua mu buloko.” ");
INSERT INTO tap_vpl VALUES ("ER7_27","016_7_27","EZR","7","27","27","Ezra waalandile evi, “Apaalue Yawe Leza wa babikolue wakinasia mutima wakua likolo Artasasta kuti apeele mukinzi ku Nghanda yakua Leza ili mu Yeruzalemu, ");
INSERT INTO tap_vpl VALUES ("ER7_28","016_7_28","EZR","7","28","28","ni kunangisia buwame bwakue pa menso akua likolo ni a bakasoka bakue, ni pa menso a babiloolo bonse ba buvinde bakua likolo. Nakikoseleziiwa pantu Leza wane wakinkwasia. Nakikolonghania bakulu bonse ba mu Izraeli kuti babwele pamo ni nene.” ");
INSERT INTO tap_vpl VALUES ("ER8_1","016_8_1","EZR","8","1","1","Baba i bakulu ba mikoa pamo ni nvyalo yabo, balia baabwelele pamo ni nene kufuma ku Babeli musita wa kuteeka kwakua likolo Artasasta. ");
INSERT INTO tap_vpl VALUES ("ER8_2","016_8_2","EZR","8","2","2","Gershomu waali mukulu wa luvyalo lwakua Finehasi, Danieli waali mukulu wa luvyalo lwakua Itamari, Hatusi waali mukulu wa luvyalo lwakua Daudi ");
INSERT INTO tap_vpl VALUES ("ER8_3","016_8_3","EZR","8","3","3","Bantu ba mu luvyalo lwakua Sekania, ni Parosi pamo ni Zakaria, mpendua yabo baali balalume 150. ");
INSERT INTO tap_vpl VALUES ("ER8_4","016_8_4","EZR","8","4","4","Bantu ba mu luvyalo lwakua Pahati-Moabu: Elioenai mwina Zerahia, waali wali pamo ni balalume 200. ");
INSERT INTO tap_vpl VALUES ("ER8_5","016_8_5","EZR","8","5","5","Bantu ba mu luvyalo lwakua Zatu, ni Sekania mwina Yahasieli, mpendua yabo baali balalume 300. ");
INSERT INTO tap_vpl VALUES ("ER8_6","016_8_6","EZR","8","6","6","Bantu ba mu luvyalo lwakua Adini, ni Ebedi mwina Yonatana, mpendua yabo baali balalume 50. ");
INSERT INTO tap_vpl VALUES ("ER8_7","016_8_7","EZR","8","7","7","Bantu ba mu luvyalo lwakua Elamu, ni Yesaia mwina Atalia, mpendua yabo baali balalume 70. ");
INSERT INTO tap_vpl VALUES ("ER8_8","016_8_8","EZR","8","8","8","Bantu ba mu luvyalo lwakua Sefatia, ni Zebadia mwina Mikaeli, mpendua yabo baali balalume 80. ");
INSERT INTO tap_vpl VALUES ("ER8_9","016_8_9","EZR","8","9","9","Bantu ba mu luvyalo lwakua Yoabu, ni Obadia mwina Yehieli, mpendua yabo baali balalume 218. ");
INSERT INTO tap_vpl VALUES ("ER8_10","016_8_10","EZR","8","10","10","Bantu ba mu luvyalo lwakua Selomiti mwina Yosifia ni wa mu luvyalo lwakua Bani, mpendua yabo baali balalume 160. ");
INSERT INTO tap_vpl VALUES ("ER8_11","016_8_11","EZR","8","11","11","Bantu ba mu luvyalo lwakua Bebai ni Zakaria mwina Bebai, mpendua yabo baali balalume 28. ");
INSERT INTO tap_vpl VALUES ("ER8_12","016_8_12","EZR","8","12","12","Bantu ba mu luvyalo lwakua Azgadi, ni Yohana mwina Hakatani, mpendua yabo baali balalume 110. ");
INSERT INTO tap_vpl VALUES ("ER8_13","016_8_13","EZR","8","13","13","Bantu ba mu luvyalo lwakua Adonikamu, lwaali lwa mpeleezio, meena abo ni aza: Elifeleti, Yueli, ni Semaia, mpendua yabo baali balalume 60. ");
INSERT INTO tap_vpl VALUES ("ER8_14","016_8_14","EZR","8","14","14","Bantu ba mu luvyalo lwakua Bigwai, ni Utai mwina Zakuri, mpendua yabo baali balalume 70. ");
INSERT INTO tap_vpl VALUES ("ER8_15","016_8_15","EZR","8","15","15","Nene Ezra naakolonghaniizie baba bonse mumbali mwenzi uile ku Ahava, papo patwaikeele nsiku itatu, naakebele mu bantu ni mu babitambua, nsyaasangilemo bantu ba mu luvyalo lwakua Lawi. ");
INSERT INTO tap_vpl VALUES ("ER8_16","016_8_16","EZR","8","16","16","Ni pakako naakuutile Eliezeri, ni Arieli, ni Semaia, ni Elnatana, ni Yaribu, ni Elnatana, ni Natana, ni Zakaria, ni Mesulamu pantu i baali bakulu ba maano, pamo ni bakasambilizia babili Yoyaribu, ni Elnatana. ");
INSERT INTO tap_vpl VALUES ("ER8_17","016_8_17","EZR","8","17","17","Baba bantu naabatumine kuli Ido mukulu wa ku Kasifia, baye bamwane Ido ni ba kwakue babombi ba mu Nghanda yakua Leza ba ku Kasifia batuleeteleko bantu ba kubomba mu Nghanda yakua Leza wetu. ");
INSERT INTO tap_vpl VALUES ("ER8_18","016_8_18","EZR","8","18","18","Kukonkana ni buwame bwakua Leza pali fwefue, baatuleteele muntu wa maano, Serebia pamo ni baana bakue ni balupua bakue. Bonse pamo baali lyanondo ni mwanda. Ozo Serebia waali wa mu luvyalo lwakua Mali, Mali mwina Lawi, Lawi mwina Izraeli. ");
INSERT INTO tap_vpl VALUES ("ER8_19","016_8_19","EZR","8","19","19","Kabili baatutumiine ni linge libumba lyaali lyalombwelue na Hasabia ni Yesaia ba mu luvyalo lwakua Merari, ni lupua lwabo pamo ni baana babo. Bonse pamo baali 20. ");
INSERT INTO tap_vpl VALUES ("ER8_20","016_8_20","EZR","8","20","20","Baizile pamo ni babombi 220 baasaakwilue na Daudi ni masiiko kuti bakwasie miilo ya mu Nghanda yakua Leza. Ni meena abo amanikile. ");
INSERT INTO tap_vpl VALUES ("ER8_21","016_8_21","EZR","8","21","21","Ni pakako, na-anine kuti twizilike kulia twali mumbali mwenzi wa Ahava, twikeefie ku menso akua Leza wetu, evi atwenzie bwino, fwefue, ni baana betu, pamo ni bunonsi bwetu bonse, ");
INSERT INTO tap_vpl VALUES ("ER8_22","016_8_22","EZR","8","22","22","pantu naunvwile busoni bwa kumulomba likolo kuti atupeele libumba lya balukale, ni baseli ba pa farasi bakutukingilila ku balwani betu mu nzila, pantu twaamwanine likolo nangue, “Balia balibamukeba Leza, Leza aliwabakitila buwame, inzi kikonko ni kukanda kwakue kuli pa balia bonse balibamukaana.” ");
INSERT INTO tap_vpl VALUES ("ER8_23","016_8_23","EZR","8","23","23","Kupwako, twaizilika bilio, twamulomba Leza wetu atusunge, ni ye watwitabila. ");
INSERT INTO tap_vpl VALUES ("ER8_24","016_8_24","EZR","8","24","24","Naasaakwile bamakolo lyanondo ni babili ba babitambua: Serebia, ni Hasabia, pamo ni bange lyanondo ba mu lupua lwabo, ");
INSERT INTO tap_vpl VALUES ("ER8_25","016_8_25","EZR","8","25","25","naabapimiine mutofue ni oro, pamo ni bibombelo, ni bulongio bwa mu Nghanda yakua Leza wetu, bwaalongiiziwe na likolo, ni bakasoka bakue, na masiiko akue, pamo ni bwaalongiiziwe na Baizraeli bonse baalipo. ");
INSERT INTO tap_vpl VALUES ("ER8_26","016_8_26","EZR","8","26","26","Naabapiimiine talanta kilo 22,000 ya mutofue, ni bibombelo bya mutofue talanta 3,400, ni bya oro talanta 3,400, ");
INSERT INTO tap_vpl VALUES ("ER8_27","016_8_27","EZR","8","27","27","ni bibakuli bya oro 20 byaali byafinine diriki kilo 8.5, ni bibombelo bibili bya mukuba bikindeeme byaali byabeeka nga oro. ");
INSERT INTO tap_vpl VALUES ("ER8_28","016_8_28","EZR","8","28","28","Naabaanine nangue, “Mwemue muli bazuuke bakua Yawe, ni bibombelo ni byo bizuukile. Mutofue ni oro, byonse ni byabupe byakua Yawe Leza wa basiinue. ");
INSERT INTO tap_vpl VALUES ("ER8_29","016_8_29","EZR","8","29","29","Kansi labukile bebi bintu ni kubisunga mpaka musita umwaakabipiima pa menso a nombozi ya babitambua, ni Balawi, ni bakulu ba mikowa ya Baizraeli bali mu Yeruzalemu, mu miputule ya Nghanda yakua Yawe.” ");
INSERT INTO tap_vpl VALUES ("ER8_30","016_8_30","EZR","8","30","30","Kabili babitambua ni Balawi baapokeleele tulingo twa mutofue ni oro, ni bibombelo bizuuke, ni kubileeta ku Yeruzalemu mu Nghanda yakua Leza wetu. ");
INSERT INTO tap_vpl VALUES ("ER8_31","016_8_31","EZR","8","31","31","Mu mwezi wa mambo, mu busiku bwa lyanondo ni ibili, twaafumine pa mwenzi wa Ahava ni kuya ku Yeruzalemu. Leza waali wali pamo ni fwefue ni kutupususia ku balwani, ni ku bantu baali batubenza mu nzila. ");
INSERT INTO tap_vpl VALUES ("ER8_32","016_8_32","EZR","8","32","32","Lutwaafikile mu Yeruzalemu, twaatuuziizie nsiku itatu. ");
INSERT INTO tap_vpl VALUES ("ER8_33","016_8_33","EZR","8","33","33","Ni mu busiku bwa buna, twaapiimiinue mutofue ni oro, pamo ni bibombelo bizuuke bya mu Nghanda yakua Leza wetu ni kumupeela Meremoti mwina kitambua Uria, pamo ni Eleazari mwina Finehasi, ni Balawi babili, Yozadaki mwina Yeshua, ni Noadia mwina Binui. ");
INSERT INTO tap_vpl VALUES ("ER8_34","016_8_34","EZR","8","34","34","Bebio byonse byaalembelue mpendua yabyo ni kufina kwabyo. ");
INSERT INTO tap_vpl VALUES ("ER8_35","016_8_35","EZR","8","35","35","Bonse baabwelele kufuma mu buzia, baamweleele Leza wa Baizraeli ngelelo ya kuziziiwa, nghombe ndume lyanondo ni ibili mubeleele mikowa ya Baizraeli, mpanga 96, twina mikooko 77, tupwata lyanondo ni tubili twa ngelelo ya bibalo. Bebi bintu byonse, byaali ngelelo ya kuziziiwa yakua Yawe. ");
INSERT INTO tap_vpl VALUES ("ER8_36","016_8_36","EZR","8","36","36","Kabili baatwele mwano wakua likolo ku babiloolo ni ku bandabukizi ba ku bwala mwenzi wa Efrati, ni bo baakwasiizie bantu pamo ni Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("ER9_1","016_9_1","EZR","9","1","1","Pa kyamba kya bebi byonse, bakulu bamo baizile kun'mbwila nangue, Baizraeli ni babitambua pamo ni Balawi, tebakiikeka ku bekala kyalo ni mu kukita bubi nga Bakanaani, ni Bahiti, ni Baperizi, ni Bayebusi, ni Ba-amoni, ni Bamoabu, ni Bamisri, pamo ni Ba-amori. ");
INSERT INTO tap_vpl VALUES ("ER9_2","016_9_2","EZR","9","2","2","Pantu Bayuda bakiya kuupila ku Bazima ni kuufia baana babo balalume ku banakazi Bazima. Ni pakako, luvyalo luzuuke lwakiisanzia ni lwa bekala kyalo mu bobu bubi. Baatendekeelepo ni banombozi pamo ni babiloolo. ");
INSERT INTO tap_vpl VALUES ("ER9_3","016_9_3","EZR","9","3","3","Lunaunvwile toto twebo, kisinka naapeleleelue. Naazabwile ngubo yane ni nkanzu yane, naazukwile misisi ku mutue pamo ni ndevu, ni kwivopeka pansi napeleleelue. ");
INSERT INTO tap_vpl VALUES ("ER9_4","016_9_4","EZR","9","4","4","Bantu bonse baali baunvwile mwezo wa twebo twakua Leza wa Baizraeli pa mulandu wa kilubo kya bantu baabwelele kufuma mu buzia. Baba bantu bankolongheene, ni ne naali nasyaikeele sie napeleleelue mpaka musita wa ngelelo ya kyungulo. ");
INSERT INTO tap_vpl VALUES ("ER9_5","016_9_5","EZR","9","5","5","Lwaakumeene musita wa ngelelo ya kyungulo, naabuukile panaali nali ni bulanda, ni nkanzu yane yazabukile. Naafukeeme ni kulendula maboko ane kuli Leza wane ");
INSERT INTO tap_vpl VALUES ("ER9_6","016_9_6","EZR","9","6","6","nalanda nangue, “We Leza wane, naunvua busoni ni kutooboka pakuti nkente kuli wewe Leza wane, pantu bibalo byetu byakila kiimo kyetu, ni bilubo byetu byakila kuvula, byafika mpaka mwiulu. ");
INSERT INTO tap_vpl VALUES ("ER9_7","016_9_7","EZR","9","7","7","Kutula mu nsiku ya babikolue betu, twaali twali ba bibalo bikata mpaka lenu, ni pa mulandu wa bilubo byetu, fwefue ni makolo etu, ni babitambua betu, twaakwetue na makolo a byalo byeni evi twipawe, tukakue ni kutwalua mu buzia pamo ni kumoniiwa busoni nga vikili lelo. ");
INSERT INTO tap_vpl VALUES ("ER9_8","016_9_8","EZR","9","8","8","Inzi lenu mu kasita kaniini, buwame bwakua Leza wetu bwakitufikila ni kutusiilapo bamo, ni kutupeela nkendo ya mutende pa kifuka kyakue kizuuke, kabili Leza wetu atusanikiile ni kuya watupeele bukose anzia kine tukili mu buzia bwetu. ");
INSERT INTO tap_vpl VALUES ("ER9_9","016_9_9","EZR","9","9","9","Anzia kine tuli bazia, Leza takitulekelela mu buzia bwetu, inzi wakitulanga ntono yakue kupitila ku makolo a ku Persia, ni kutusia twakosele kuti tukuule paakale Nganda yakua Leza wetu, ni kuwamia bituuti, kabili wakitupeela nkendo ya mutende mu Yudea ni mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("ER9_10","016_9_10","EZR","9","10","10","“We Leza wetu, ale evi lenu tulikulanda syani pa kyamba kya ezi milandu? Pantu twakilekela kukonka mafunde obe ");
INSERT INTO tap_vpl VALUES ("ER9_11","016_9_11","EZR","9","11","11","awaatwanine kupitila mu babombi bobe bakabika walanda nangue kyalo kimulimukuya kupyana, kitiikeene na bya nkeni bya bekala kyalo, pantu mu kyalo bezuziiziemo bubi bwabo. ");
INSERT INTO tap_vpl VALUES ("ER9_12","016_9_12","EZR","9","12","12","Ni pakako, tekulekelele bakazyana benu kuti boopue na baana babo, ao baana benu balalume kuti boope bakazyana babo, kabili tekuti mukakite nabo bukibuza pa musita uli onse, evi mukabe ni maka ni kulia bilio biweme bya mu kyalo, ni kusiila baana benu bupyani bwa muyayaya. ");
INSERT INTO tap_vpl VALUES ("ER9_13","016_9_13","EZR","9","13","13","Ni pa kyamba kya bebi byonse byaatuponeene, byaakitikile pa mulandu wa bikitua byetu bibiipile, ni pa mulandu wa kilubo kyetu kikata, inzi twamona nangue wewe Leza wetu tewakitukanda nga mubeeleele bibalo byetu, wewe wakilengia kuti tusyalepo nga evi vituli. ");
INSERT INTO tap_vpl VALUES ("ER9_14","016_9_14","EZR","9","14","14","Kubako kabili kuti twainoona mafunde obe mu kuupana ni bekala kyalo balibakita bebi bilubo? Eba, teulikutufiitilua ni kutulovia pasili kupususiapo ata umo? ");
INSERT INTO tap_vpl VALUES ("ER9_15","016_9_15","EZR","9","15","15","We Yawe Leza wa Baizraeli! Wewe uli mulunghami, pantu fwefue i baasyelepo bapusukile, ni evi vyenka, mona tuluviizie ku menso obe, pantu tekuli muntu wakuvinda kwimana ku menso obe pa mulandu wa bobu bubi.” ");
INSERT INTO tap_vpl VALUES ("ER10_1","016_10_1","EZR","10","1","1","Ezra lu-aali wapepa ni kulapila walimukulila ni kuya waipooza pansi pa ntanzi ya Nghanda yakua Leza, libumba likata lya Baizraeli, balalume ni banakazi pamo ni baana, baamukolongheene. Baba bantu baalilile sana ni bulanda bukata. ");
INSERT INTO tap_vpl VALUES ("ER10_2","016_10_2","EZR","10","2","2","Ni Sekania mwina Yehieli, umo wa mu bena Elamu, waamwanine Ezra nangue, “Fwefue twakiluvia kuli Leza wetu pantu twakyupa banakazi Bazima, inzi anzia kili evio, maswapi akiliko ku Baizraeli palua ozu mulandu. ");
INSERT INTO tap_vpl VALUES ("ER10_3","016_10_3","EZR","10","3","3","Kansi evi, tukite kipingo ni Leza wetu kya kukaana banakazi bonse, pamo ni bonse baavyelueko kukonkana ni nsokezi yakua tawelenzi, ni ya balia balibanakila milao yakua Leza wetu, kikitue kukonkana ni mizilo. ");
INSERT INTO tap_vpl VALUES ("ER10_4","016_10_4","EZR","10","4","4","Kansi buuka pantu ozu ni mwilo obe we bunke, ni fwefue tuli pamo nobe. Ikoselezie sie.” ");
INSERT INTO tap_vpl VALUES ("ER10_5","016_10_5","EZR","10","5","5","Kupwako, Ezra wabuuka ni kubalapizia bakulu ba babitambua, ni Balawi, ni Baizraeli bonse kuti bakabe kukita kukonkana ni totu twebo, ni bo balapa. ");
INSERT INTO tap_vpl VALUES ("ER10_6","016_10_6","EZR","10","6","6","Ezra i lu-aabuukile kufuma pa ntanzi ya Nghanda yakua Leza, waingila mu muputule wakua Yohanani mwina Eliasibu, koko kwaaleele pasili kulia kantu ao kumina menda, pantu waali walimukulila pa mulandu wa bibalo bya balia baali bafumine mu buzia. ");
INSERT INTO tap_vpl VALUES ("ER10_7","016_10_7","EZR","10","7","7","Baapundile mu Yudea ni mu Yeruzalemu ku bantu bonse baabwelele kufuma mu buzia kuti bakolonghane mu Yeruzalemu, ");
INSERT INTO tap_vpl VALUES ("ER10_8","016_10_8","EZR","10","8","8","kabili onse asikasangua waizile mu ezi nsiku itatu, nga mwaalandiile masiiko ni babiloolo, waakapokua bunonsi bwakue bonse, ni ye mwine waakakumbua mu libumba lya balia baabwelele kufuma mu buzia. ");
INSERT INTO tap_vpl VALUES ("ER10_9","016_10_9","EZR","10","9","9","Bantu bonse ba mu mukowa wakua Yuda ni wakua Benyamina, baakolongheene mu Yeruzalemu mu ezio nsiku itatu, ozo waali mwezi wa fundi pa nsiku 20 ya mwezi, ni bantu bonse baikeele pa kifuka kya pa musolo wa Nghanda yakua Leza balimukututuma na mwezo wa ezi milandu, kabili pantu kwaali ni nvula ikata. ");
INSERT INTO tap_vpl VALUES ("ER10_10","016_10_10","EZR","10","10","10","Kitambua Ezra waimeene ni kubaana nangue, “Mwakiluvia pa kuupa banakazi Bazima, ni kulunda bilubo pa bilubo bya Baizraeli. ");
INSERT INTO tap_vpl VALUES ("ER10_11","016_10_11","EZR","10","11","11","Ni pakako, lapile kuli Yawe Leza wa babikolue benu ni kukita mwatoneene, kabili mwikeke ku Bazima bonse ba mu kyalo, pamo ni ku bakazi Bazima.” ");
INSERT INTO tap_vpl VALUES ("ER10_12","016_10_12","EZR","10","12","12","Kupwako, libumba lyonse lya-asuka na lizui likata nangue, “Tulikukita nga muwalandila.” ");
INSERT INTO tap_vpl VALUES ("ER10_13","016_10_13","EZR","10","13","13","Baatwaliliile kulanda nangue, “Inzi bantu bavulile, ni nvula ilimukunoka, kabili tetuvinda kwimana panze, ezi miilo te ya busiku bumo ao nsiku ibili sie, pantu tuli ni bilubo bingi pa ozu mulandu. ");
INSERT INTO tap_vpl VALUES ("ER10_14","016_10_14","EZR","10","14","14","Kansi evi, banombozi betu bemaniineko libumba lyonse, ni balia bonse ba mu mizi yetu boopile banakazi Bazima, baye baiza kubalua bantu pa musita ubapeelue baseekeziiziwe na masiiko ni bapinguzi ba mu muzi. Kine twakita evio, kikonko kyakua Leza kyakaba kufumiiwa pali fwefue, pa mulandu wa bilubo bitwakikita.” ");
INSERT INTO tap_vpl VALUES ("ER10_15","016_10_15","EZR","10","15","15","Yonatana sie mwina Asaheli, ni Yazeia mwina Tikwa i basyaitabiile ozu mulandu, pamo ni Mesulamu, ni Sabetai Mulawi. ");
INSERT INTO tap_vpl VALUES ("ER10_16","016_10_16","EZR","10","16","16","Inzi balia baabwelele kufuma mu buzia baakitile mukyaalandiilue, kitambua Ezra waasaakwile bakulu ba mikowa, kukonkana ni mpendua ya mikowa yabo, ni kubatantika kukonkana ni meena abo, baba bantu baikeele mu busiku bwa mambo bwa mwezi wa lyanondo kuti bakebelezie ozu mulandu. ");
INSERT INTO tap_vpl VALUES ("ER10_17","016_10_17","EZR","10","17","17","Ni mu busiku bwa mambo bwa mwezi wa mambo, baapwile milandu ya balia bonse baupile banakazi Bazima. ");
INSERT INTO tap_vpl VALUES ("ER10_18","016_10_18","EZR","10","18","18","Bantu baupile banakazi Bazima: Ba mu luvyalo lwakua Yoshua mwina Yozadaki ni ba mu luvyalo lwa ba kwakue mwaali: Maseia, ni Eliezeri, ni Yaribu, ni Gedalia. ");
INSERT INTO tap_vpl VALUES ("ER10_19","016_10_19","EZR","10","19","19","Baba bantu baalaile nangue bakaba kukaana bakazi babo, kabili pantu baali ni kibalo, baeleele mpanga ya pa kisepe pa mulandu wa kibalo kyabo. ");
INSERT INTO tap_vpl VALUES ("ER10_20","016_10_20","EZR","10","20","20","Mu luvyalo lwakua Imeri, mwaali Hanani ni Zebadia. ");
INSERT INTO tap_vpl VALUES ("ER10_21","016_10_21","EZR","10","21","21","Mu luvyalo lwakua Harimu, mwaali Maseia, ni Elia, ni Semaia, ni Yehieli, ni Uzia. ");
INSERT INTO tap_vpl VALUES ("ER10_22","016_10_22","EZR","10","22","22","Mu luvyalo lwakua Pashuri, mwaali Elioenai, ni Maseia, ni Isimaeli, ni Netaneli, ni Yozabadi, ni Elasa. ");
INSERT INTO tap_vpl VALUES ("ER10_23","016_10_23","EZR","10","23","23","Yozabadi, ni Simei, ni Kelaia aliwakuutua Kelita, ni Petahia, ni Yuda, ni Eliezeri. ");
INSERT INTO tap_vpl VALUES ("ER10_24","016_10_24","EZR","10","24","24","Eliasibu. Salumu, ni Telemu, pamo ni Uri. ");
INSERT INTO tap_vpl VALUES ("ER10_25","016_10_25","EZR","10","25","25","Ba mu luvyalo lwakua Parosi mwaali: Ramia, ni Izia, ni Malkia, ni Miaminu, ni Eleazari, ni Malkia pamo ni Benaya. ");
INSERT INTO tap_vpl VALUES ("ER10_26","016_10_26","EZR","10","26","26","Mu luvyalo lwakua Elamu, mwaali Matania, ni Zakaria, ni Yehieli, ni Abudi, ni Yeremoti, ni Elia. ");
INSERT INTO tap_vpl VALUES ("ER10_27","016_10_27","EZR","10","27","27","Mu luvyalo lwakua Zatu, mwaali Elioenai, ni Eliasibu, ni Matania, ni Yeremoti, ni Zabadi, ni Aziza. ");
INSERT INTO tap_vpl VALUES ("ER10_28","016_10_28","EZR","10","28","28","Mu luvyalo lwakua Bebai, mwaali Yohanani, ni Hanania, ni Zabai, ni Atilai. ");
INSERT INTO tap_vpl VALUES ("ER10_29","016_10_29","EZR","10","29","29","Mu luvyalo lwakua Bani, mwaali Mesulamu, ni Maluku, ni Adaia, ni Yasubu, ni Seali, ni Yeremoti. ");
INSERT INTO tap_vpl VALUES ("ER10_30","016_10_30","EZR","10","30","30","Mu luvyalo lwakua Pahati-Moabu, mwaali Adina, ni Kelali, ni Benaya, ni Maaseia, ni Matania, ni Besaleli, ni Binui, pamo ni Manase. ");
INSERT INTO tap_vpl VALUES ("ER10_31","016_10_31","EZR","10","31","31","Mu luvyalo lwakua Harimu, mwaali Eliezeri, ni Isia, ni Malkia, ni Semaia, pamo ni Simeoni, ");
INSERT INTO tap_vpl VALUES ("ER10_32","016_10_32","EZR","10","32","32","ni Benyamina, ni Maluku, ni Semaria. ");
INSERT INTO tap_vpl VALUES ("ER10_33","016_10_33","EZR","10","33","33","Mu luvyalo lwakua Hasumu, mwaali Matenai, ni Matata, ni Zabadi, ni Elifeleti, ni Yeremai, ni Manase, pamo ni Simei. ");
INSERT INTO tap_vpl VALUES ("ER10_34","016_10_34","EZR","10","34","34","Mu luvyalo lwakua Bani, mwaali Madai, ni Amramu, ni Ueli, ");
INSERT INTO tap_vpl VALUES ("ER10_35","016_10_35","EZR","10","35","35","ni Benaya, ni Bedia, ni Keluhi, ");
INSERT INTO tap_vpl VALUES ("ER10_36","016_10_36","EZR","10","36","36","ni Wania, ni Meremoti, ni Eliasibu, ");
INSERT INTO tap_vpl VALUES ("ER10_37","016_10_37","EZR","10","37","37","ni Matania, ni Matenai, pamo ni Yasu. ");
INSERT INTO tap_vpl VALUES ("ER10_38","016_10_38","EZR","10","38","38","Mu luvyalo lwakua Binui mwaali Simei, ");
INSERT INTO tap_vpl VALUES ("ER10_39","016_10_39","EZR","10","39","39","ni Selemia, ni Natana, ni Adaia, ");
INSERT INTO tap_vpl VALUES ("ER10_40","016_10_40","EZR","10","40","40","ni Makinadebai, ni Sasai, ni Sarai, ");
INSERT INTO tap_vpl VALUES ("ER10_41","016_10_41","EZR","10","41","41","ni Azaraeli, ni Selenia, ni Semaria, ");
INSERT INTO tap_vpl VALUES ("ER10_42","016_10_42","EZR","10","42","42","ni Salumu, ni Amaria, ni Yusufu. ");
INSERT INTO tap_vpl VALUES ("ER10_43","016_10_43","EZR","10","43","43","Mu luvyalo lwakua Nebo mwaali Yeieli, ni Matitia, ni Zabadi, ni Zebina, ni Yadai, ni Yoeli, ni Benaya. ");
INSERT INTO tap_vpl VALUES ("ER10_44","016_10_44","EZR","10","44","44","Baba bonse i baupile banakazi Bazima, ni bange pakati kabo baali ni banakazi baali basyabavyaliile ni baana. Babo banakazi baakumbilue pamo ni baana babo.");
INSERT INTO tap_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","1","Totu i twebo twakua Nehemia mwina Hakalia. Lunaali mu Susani muzi ukata wa kyalo, mu mwezi wa Kisileu mu mwaka wa 20 mu kuteeka kwakua Artasasta, ");
INSERT INTO tap_vpl VALUES ("NH1_2","017_1_2","NEH","1","2","2","Hanani, umo wa mu balupua bane waizile pamo ni bange balalume kufuma ku kyalo kya Yudea. Naabeepuziizie palua Bayuda baasyele pasili kutwalua mu buzia, ni mpunda palua Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","Bangasukile nangue, pa balia baabwelele kufuma mu buzia, balia bekeele mu kiputu kya kyalo, bali mu lyemo likata ni kufuupulua sana. Kibumba kya Yeruzalemu ni kyo kyaatuutilue, ni milyango yakue yaaziziiziwe na mulilo. ");
INSERT INTO tap_vpl VALUES ("NH1_4","017_1_4","NEH","1","4","4","Lunaunvwile evio, naikeele ni kutendeka kulila. Naakitile nsiku ingi nalimukulosia ni kuizilika bilio pamo ni kupepa kuli Leza wa mwiulu. ");
INSERT INTO tap_vpl VALUES ("NH1_5","017_1_5","NEH","1","5","5","Naalandile nangue, “We Mulopue Leza wa mwiulu, Leza Mukulu aliwatiinia, we aliwafikilizia kipingo kyobe kya ntono ku balia bakutonene ni kunakila milao yobe, ");
INSERT INTO tap_vpl VALUES ("NH1_6","017_1_6","NEH","1","6","6","twilizia mapepo ane ne mubombi obe lundinapepa busiku ni koba pa mulandu wa babombi bobe Baizraeli, nalapila bibalo byetu fwe Baizraeli, bibalo binaakubalile nene ni byaakubalile bantu ba mu nghanda ya babikolue bane. ");
INSERT INTO tap_vpl VALUES ("NH1_7","017_1_7","NEH","1","7","7","Twaakitile bilubo bingi, kabili tetwaanakiile milao ni nsokezi pamo ni mizilo nga muwaamwaniine mubombi obe Musa. ");
INSERT INTO tap_vpl VALUES ("NH1_8","017_1_8","NEH","1","8","8","Nakupaapaata wizukile keebo kawaamwanine mubombi obe Musa nangue, ‘Kine mwaluvia, naakamisalanghaniizia ku ntundu inge. ");
INSERT INTO tap_vpl VALUES ("NH1_9","017_1_9","NEH","1","9","9","Inzi kine mwabwela kuli nene ni kunakila milao yane ni kwikita, anzia kine bantu benu bali mu buzia kule kupeleele kyalo, naakabaleeta ni kubakolonghania pa nkendo inaasaakwile kuti ngie nalanga kubapo kwane.’ ");
INSERT INTO tap_vpl VALUES ("NH1_10","017_1_10","NEH","1","10","10","“Baba i babombi bobe, kabili i bantu bobe bawaapususiizie na buvinde bobe bukata na maka a kuboko kobe. ");
INSERT INTO tap_vpl VALUES ("NH1_11","017_1_11","NEH","1","11","11","We Mulopue, nakupaapaata utwilizie mapepo ane ne mubombi obe, ni mapepo a babombi bobe bawamiinue kukindika liina lyobe, kabili nakulomba un'mpaale bono busiku, ni kumulengia ozu muntu anghunvwileko nkumbu.” Pa ozo musita naali kateaniawa divai yakua likolo. ");
INSERT INTO tap_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","1","Mu mwezi wa Nisani, mu mwaka wa 20 mu kuteeka kwakua likolo Artasasta lu-aaleeteelue divai, naipokeleele ni kumutwalila likolo. Pa ozo musita naali nsinamonekepo wa bulanda ku menso akue, inga sie bobo bwenka busiku. ");
INSERT INTO tap_vpl VALUES ("NH2_2","017_2_2","NEH","2","2","2","Likolo wangipuziizie, “Wewe teulwele, ale kiubeeleele ni bulanda ni kiki? Uli nga we ali ni bwavia mu mutima.” Ni nene naatiinine sana. ");
INSERT INTO tap_vpl VALUES ("NH2_3","017_2_3","NEH","2","3","3","Na-asukile, “We likolo, ba wali ni bukose muyayaya. Ale ndikuwaminua syani koku muzi wane waaziikiluemo babikolue bane wasyele kibolia ni milyango yonse yaziziiziwe na mulilo?” ");
INSERT INTO tap_vpl VALUES ("NH2_4","017_2_4","NEH","2","4","4","Likolo wangipuziizie, “Ukebeleki?” Ni ne naapepele kuli Leza wa mwiulu. ");
INSERT INTO tap_vpl VALUES ("NH2_5","017_2_5","NEH","2","5","5","I lunaamwasukile likolo nangue, “Kine kuti kyamuwamina likolo, kabili kine ne mubombi obe naitabilua ku menso obe, kuti kyawama untume ku Yudea mu muzi uziikiluemo babikolue bane kuti nkabe kuya kukuula paakale.” ");
INSERT INTO tap_vpl VALUES ("NH2_6","017_2_6","NEH","2","6","6","Likolo wangipuziizie ni nabeeza waikeele pepi nakue nangue, “Lwendo lobe lwaakaba lwa nsiku inga? Kabili waakabwela musitaki?” Evi kyamuwaamiine likolo kuti an'mpeele nsambu ya kuya, ni nene i pakumwana musita. ");
INSERT INTO tap_vpl VALUES ("NH2_7","017_2_7","NEH","2","7","7","Kabili naamwanine likolo nangue kine kuti kyamuwamina, an'mpeele mpapulo ya kutwala ku ndabukizi ya mu biputu bya kyalo bya ku bwala mwenzi evi bakangitabizie kupita mpaka kuya kufika mu Yudea, ");
INSERT INTO tap_vpl VALUES ("NH2_8","017_2_8","NEH","2","8","8","kabili nalomba n'mpeelue lupapulo lwa kutwala kuli Asafu aliwasunga musitu wakua likolo, evi nkapeelue mbao ya kukita milyango ya byubo bya Nghanda yakua Leza, ni milyango ya mu kibumba kya muzi, ni ya mu nghanda mu naakaba naikala. Ni likolo wan'mpeele mwaali mwabeeleele buwame bwakua Leza pali nene. ");
INSERT INTO tap_vpl VALUES ("NH2_9","017_2_9","NEH","2","9","9","Kupwako, naya kufika ku ndabukizi ya mu biputu bya kyalo bya ku bwala mwenzi wa Efrati, nabapeela mpapulo yaafumine kuli likolo. Ni likolo wantumine pamo ni bakulu ba balukale, ni baseli ba pa bafarasi kuti ngie pamo nabo. ");
INSERT INTO tap_vpl VALUES ("NH2_10","017_2_10","NEH","2","10","10","Sanibalati Muhori, ni kiloolo Tobia Muamoni lubaunvwile ezi mpunda, baafiitilue sana pa mulandu wa muntu waizile kukebela Baizraeli mutende. ");
INSERT INTO tap_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","11","Lunaafikile ku Yeruzalemu, naikeeleko nsiku itatu, pa kyamba kya nsiku itatu, ");
INSERT INTO tap_vpl VALUES ("NH2_12","017_2_12","NEH","2","12","12","naabuukile busiku, pamo ni bange bantu, kabili nsyaabwilileko muntu keebo kana-aninue na Leza wane kakuti nkabe kukita ku Yeruzalemu, kabili nsyaile na tunge tunama, inga sie kalia kanaali naselelepo. ");
INSERT INTO tap_vpl VALUES ("NH2_13","017_2_13","NEH","2","13","13","Naafumiine ku mulyango wa lulambe busikunke, lya ku lubali lwa kiina kya menda kya nghina nzoka, ni ku mulyango wa kizyalala, ni kumona kibumba kya Yeruzalemu vikyaali kyatuutilue, ni milyango viyaali yaziziiziwe na mulilo. ");
INSERT INTO tap_vpl VALUES ("NH2_14","017_2_14","NEH","2","14","14","Kabili naile mpaka ku mulyango wa kasulo, ni ku kiziba kyakua likolo, inzi tekwaali nkendo ya kupitapo ni punda unaali naselelepo. ");
INSERT INTO tap_vpl VALUES ("NH2_15","017_2_15","NEH","2","15","15","Kupwako, nasela busikunke mu lulambe nalimukukazia kibumba kya muzi. Pa kyamba naabwelele ni kuya kwingila pa mulyango wa lulambe unaafumiinepo. ");
INSERT INTO tap_vpl VALUES ("NH2_16","017_2_16","NEH","2","16","16","Babiloolo tebaamanine kunaali naile, kabili tebaamanine kinaali nakita. Bayuda, ni babitambua, ni bamasiiko, ni babiloolo, pamo ni balia bonse baali babomba ezi miilo, nsyaababwilile. ");
INSERT INTO tap_vpl VALUES ("NH2_17","017_2_17","NEH","2","17","17","Kupwako, nabaana nangue, “Mone maavia atuli nao, Yeruzalemu wasyala kibolia, ni milyango iziziiziwe na mulilo! Ize tukuule paakale kibumba kya Yeruzalemu, evi tekuti tuye twafuupulua kabili.” ");
INSERT INTO tap_vpl VALUES ("NH2_18","017_2_18","NEH","2","18","18","Naabalondolweleele buwame bwakua Leza vibwaali bwali pali nene, ni vina-aninue kuli likolo. Baalandile nangue, “Ale twende tukuule paakale.” Kupwako, babamba ozu mwilo uweme. ");
INSERT INTO tap_vpl VALUES ("NH2_19","017_2_19","NEH","2","19","19","Inzi Sanibalati Muhori, ni kiloolo Tobia Muamoni, pamo ni Gesemi Muarabu lubaunvwile ezi mpunda, baatusekele sana ni kutupunika balanda nangue, “Ni kiki keki kimulimukukeba kukita? Mulimwakeba kumusangukila likolo?” ");
INSERT INTO tap_vpl VALUES ("NH2_20","017_2_20","NEH","2","20","20","Naabaasukile, “Leza wa mwiulu waakatupaala. Ni pakako, fwe babombi bakue twakaba kubamba kukuula paakale, inzi mwemue temuli na nsempu, ao nsambu, kabili temukalangulukua mu Yeruzalemu.” ");
INSERT INTO tap_vpl VALUES ("NH3_1","017_3_1","NEH","3","1","1","Eliasibu Kitambua Mukulu, waabuukile ni kuya pamo ni lupua lwakue lwa babitambua ku kukuula mulyango wa mikooko. Bauzuukiizie ni kubiikamo milyango yakue kubambila ku lupungu lwa katua kamo mpaka ku lupungu lwa Hananeli. ");
INSERT INTO tap_vpl VALUES ("NH3_2","017_3_2","NEH","3","2","2","Kufuma papo paapeziizie Eliasibu, bantu ba ku Yeriko i baatwaliliile kukuula paakale. Zakuri mwina Imuri ni ye i waatwaliliile kukuula paakale paapeziizie bantu ba ku Yeriko. ");
INSERT INTO tap_vpl VALUES ("NH3_3","017_3_3","NEH","3","3","3","Baana balalume bena Hasena i baakuulile paakale mulyango wa lisabi. Baabiikile miilimiili, ni milyango, ni byela, ni minkolonto. ");
INSERT INTO tap_vpl VALUES ("NH3_4","017_3_4","NEH","3","4","4","Meremoti mwina Uria, Uria mwina Hakosi, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. Mesulamu mwina Berekia, Berekia mwina Mesezabeli, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. Sadoki mwina Bana, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_5","017_3_5","NEH","3","5","5","Bantu ba ku Tekoa i baakuulile paakale kiputu kya kibumba kyaakonkelepo. Inzi bakulu babo tebaakwasiizieko miilo ya bemanizi ba miilo. ");
INSERT INTO tap_vpl VALUES ("NH3_6","017_3_6","NEH","3","6","6","Yoyada mwina Pasea ni Mesulamu mwina Besodia, i baawamiizie mulyango wa kale, baabiikilemo miilimiili ni milyango, ni byela pamo ni minkolonto. ");
INSERT INTO tap_vpl VALUES ("NH3_7","017_3_7","NEH","3","7","7","Melatia Mugibeoni, Yadoni Mumerono, ni bantu ba ku Gibeoni, ni ba ku Misipa, bantu ba mu buteeko bwakua ndabukizi wa kubwala mwenzi wa Efrati, i baakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_8","017_3_8","NEH","3","8","8","Usieli mwina Harihaia, umo wa pa babombi baali basungulula oro, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. Hanania umo wa pa babombi ba kukita manukato, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. Baakuulile Yeruzalemu yalumine mpaka pa kelia kibumba kikata. ");
INSERT INTO tap_vpl VALUES ("NH3_9","017_3_9","NEH","3","9","9","Refaia mwina Huri, kateeka wa kitika kya kiputu kya Yeruzalemu, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_10","017_3_10","NEH","3","10","10","Yedaia mwina Harumafi, i waakuulile paakale kiputu kya kibumba kyaakonkelepo kyakenteene ni nghanda yakue. Hatusi mwina Hasabunia i waakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_11","017_3_11","NEH","3","11","11","Malkia mwina Harimu, ni Hasubu mwina Pahati-Moabu, i baakuulile paakale kiputu kya kibumba kyaakonkelepo ni lupungu lwa kikuka. ");
INSERT INTO tap_vpl VALUES ("NH3_12","017_3_12","NEH","3","12","12","Salumu mwina Halohesi, kateeka wa kitika kya kiputu kya Yeruzalemu, pamo ni baana bakue bakazyana, i baamukwasiizie kukuula paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_13","017_3_13","NEH","3","13","13","Hanuni, pamo ni bekazi ba mu Zanoa, i baakuulile paakale mulyango wa lulambe. Baukuulile ni kubiikamo mulyango, ni byela pamo ni minkolonto, ni kulundako metre 450 mu kuleepa kwa kibumba mpaka pa mulyango wa kizyalala. ");
INSERT INTO tap_vpl VALUES ("NH3_14","017_3_14","NEH","3","14","14","Malkia mwina Rekabu, kateeka wa Beti-Karemu, i waakuulile paakale kiputu kya kibumba kyaakonkelepo ni kubiikamo milyango, ni byela pamo ni minkolonto. ");
INSERT INTO tap_vpl VALUES ("NH3_15","017_3_15","NEH","3","15","15","Salumu mwina Kolihoze, kateeka wa ku Misipa, i waawamiizie mulyango wa kasulo, i waukuulile paakale ni kubiikapo mutenge, wabiikamo milyango, ni byela pamo ni minkolonto ni kukuula paakale kibumba kya kiziba kya Siloamu, pepi ni bukaba bwakua likolo, mpaka mu biselelo tukookele twafumine ku muzi wakua Daudi. ");
INSERT INTO tap_vpl VALUES ("NH3_16","017_3_16","NEH","3","16","16","Nehemia, mwina Azibuku kateeka wa kitika kya kiputu kya ku Beti-Suri, i waakuulile paakale kiputu kya kibumba kyaakonkelepo mpaka ku nghanda ikata ikenteene ni kilibu kyakua Daudi, mpaka ku kiziba kya menda kyaimbilue na bantu, kabili mpaka ku nghanda ya babipami. ");
INSERT INTO tap_vpl VALUES ("NH3_17","017_3_17","NEH","3","17","17","Balawi baali balombwelue na Rehumu mwina Bani, i baakuulile paakale kiputu kya kibumba kyaakonkelepo. Hasabia, kateeka wa kitika kya kiputu kya kyalo kya Keila, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_18","017_3_18","NEH","3","18","18","Binui mwina Henadadi, kateeka wa kitika kya kiputu kya kyalo kya Keila, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_19","017_3_19","NEH","3","19","19","Ezeri mwina Yeshua, kateeka wa ku Misipa, i waakuulile paakale kiputu kya kibumba kyaakonkelepo, kabili i waakuulile paakale ni ku nkendo inge kine uliwasela waya lya ku nghanda ya bilwilo, pa lipeto lya kibumba. ");
INSERT INTO tap_vpl VALUES ("NH3_20","017_3_20","NEH","3","20","20","Baruku mwina Zabai, i waakuulile paakale kiputu kya kibumba kyaakonkelepo pamo ni mu nkendo inge kutula pa lipeto lya kibumba, mpaka pa mulyango wa nghanda yakua Eliasibu Kitambua Mukulu. ");
INSERT INTO tap_vpl VALUES ("NH3_21","017_3_21","NEH","3","21","21","Meremoti mwina Uria, Uria mwina Hakosi, i waakuulile paakale kiputu kya kibumba kyaakonkelepo, kabili waakuulile paakale ni mu nkendo inge, kutendekela pa mulyango wa nghanda yakua Eliasibu, mpaka pa mpeleezio ya ezio nghanda. ");
INSERT INTO tap_vpl VALUES ("NH3_22","017_3_22","NEH","3","22","22","Babitambua baafumine mumbali Yeruzalemu, i baakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_23","017_3_23","NEH","3","23","23","Benyamina ni Hasubu, i baakuulile paakale kiputu kya kibumba kyaakonkelepo kyakenteene ni nghanda yabo. Azaria mwina Maseia, Maseia mwina Anania, i waakuulile paakale kiputu kya kibumba kyaakonkelepo lya mumbali nghanda yakue ye mwine. ");
INSERT INTO tap_vpl VALUES ("NH3_24","017_3_24","NEH","3","24","24","Binui mwina Henadadi, i waakuulile paakale kiputu kya kibumba kyaakonkelepo, kabili waakuulile paakale ni kunge, kutendekela pa nghanda yakua Azaria, mpaka pa lipeto lya kibumba, kabili mpaka pa kafuli. ");
INSERT INTO tap_vpl VALUES ("NH3_25","017_3_25","NEH","3","25","25","Palali mwina Uzai ni ye i waakuulile paakale kiputu kya kibumba kyaakonkelepo kutula pa lipeto lya kibumba, ni ku lupungu luleepeesie pa nghanda ya bukolo ili pepi ni musolo wa bakalinda. Pa kyamba kyakue, waakonkelepo ni Pedaia mwina Parosi, ");
INSERT INTO tap_vpl VALUES ("NH3_26","017_3_26","NEH","3","26","26","pamo ni babombi ba mu Nghanda yakua Leza, babo baali baikeele ku lupili lwa Ofeli, babo i baakuulile paakale kibumba kikenteene ni mulyango wa menda lya ku kabanga ni ku lupungu luleepeesie. ");
INSERT INTO tap_vpl VALUES ("NH3_27","017_3_27","NEH","3","27","27","Bantu ba ku Tekoa i baakuulile paakale kiputu kya kibumba kyaakonkelepo ni mu nkendo inge walungheeme lya kolia kufumine lupungu luleepeesie, kabili mpaka ku kibumba kya pa lupili lwa Ofeli. ");
INSERT INTO tap_vpl VALUES ("NH3_28","017_3_28","NEH","3","28","28","Pa muulu mulyango wa farasi, paakuulilue paakale na babitambua, kubalua kitambua waakuulile paakale pa ntanzi ya nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("NH3_29","017_3_29","NEH","3","29","29","Sadoki mwina Imeri, i waakuulile paakale kiputu kya kibumba kyaakonkelepo kyaali kyali pa ntanzi ya nghanda yakue. Semaia mwina Sekania kalinda wa pa mulyango wa ku kabanga, i waakuulile paakale kiputu kya kibumba kyaakonkelepo. ");
INSERT INTO tap_vpl VALUES ("NH3_30","017_3_30","NEH","3","30","30","Hanania mwina Selemia, ni Hanuni mwana wa mutanda mwina Zalafi, i baakuulile paakale kiputu kya kibumba kyaakonkelepo, kabili baakuulile paakale ni mu nkendo inge. Mesulamu mwina Berekia, i waakuulile paakale kiputu kya kibumba kyaakonkelepo kyaali kyali pa ntanzi ya nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("NH3_31","017_3_31","NEH","3","31","31","Malkia umo wa pa babombi baali basungulula oro, i waakuulile paakale kiputu kya kibumba kyaakonkelepo mpaka ku nghanda ya babombi ba mu Nghanda yakua Leza ni ya basulu ikenteene ni mulyango wa bakalinda ba pa mulyango, kabili mpaka pa muputule wa pa muulu wa mu kafuli. ");
INSERT INTO tap_vpl VALUES ("NH3_32","017_3_32","NEH","3","32","32","Babombi baali basungulula oro pamo ni basulu, i baakuulile paakale kiputu kya kibumba kyaakonkelepo, kabili i baakuulile pa bukata bwa muputule wa pa muulu wa mu kafuli, mpaka pa mulyango wa mikooko. ");
INSERT INTO tap_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","1","Sanibalati lu-aunvwile nangue twaali twalimukukuula paakale kibumba, waafiitilue ni kukisua mutima, ni kutendeka kubapunika Bayuda. ");
INSERT INTO tap_vpl VALUES ("NH4_2","017_4_2","NEH","4","2","2","Waalandile ntanzi ya balupua bakue, ni ntanzi ya balukale ba Basamaria nangue, “Kubako baba Bayuda bananghani kuti bakitaki? Eba, kuti baikuulila paakale kyubo? Kubako kuti baelelamo ni ngelelo? Kuti bapua mu busiku bumo? Kubako kuti babombia mabue elikiliilue na mului uziile wa bintu bituutikile?” ");
INSERT INTO tap_vpl VALUES ("NH4_3","017_4_3","NEH","4","3","3","Kupwako, Tobia Muamoni waali wali pepi nakue walanda nangue, “Keki kibalimukukuula paakale anzia kine mumbue waiza kuselapo, kuti wabunghumuna kibumba kyabo kya mabue.” ");
INSERT INTO tap_vpl VALUES ("NH4_4","017_4_4","NEH","4","4","4","Ni ne naapepele, “Twilizia we Leza wetu, pantu twakila kufuupulua. Ozu mufuupula ubabwelele bo bene, baleke bateekue buzia mu kyalo kya bweni, ");
INSERT INTO tap_vpl VALUES ("NH4_5","017_4_5","NEH","4","5","5","kabili tekuvimba bubi bwabo ao kweleela bibalo byabo, pantu bakikuluvia ntanzi ya balia balibakuula.” ");
INSERT INTO tap_vpl VALUES ("NH4_6","017_4_6","NEH","4","6","6","Ni pakako, fwefue twatwaaliliile kukuula paakale kibumba, kibumba kyonse twakikuulile mpaka pa bukata mu kutuuluka kwa kibumba, pantu bantu baali bali ni mutima wa kubomba miilo. ");
INSERT INTO tap_vpl VALUES ("NH4_7","017_4_7","NEH","4","7","7","Kabili Sanibalati ni Tobia, ni Ba-arabu, ni Ba-amoni, ni Ba-asidodi, lubaunvwile nangue miilo ya kukuula paakale kibumba kya Yeruzalemu itwaliliile, ni palia paali patuutikile pakizibua, baakilile kufiitua. ");
INSERT INTO tap_vpl VALUES ("NH4_8","017_4_8","NEH","4","8","8","Libumba lyabo lyonse, lyaabambile kukambila kuti beze balwisie Yeruzalemu ni kuleeta kinvulunghania mukati muzi. ");
INSERT INTO tap_vpl VALUES ("NH4_9","017_4_9","NEH","4","9","9","Inzi twaapepele kuli Leza wetu, ni kubiika bakalinda bakutukingilila busiku ni koba. ");
INSERT INTO tap_vpl VALUES ("NH4_10","017_4_10","NEH","4","10","10","Pa ozo wenka musita Bayuda baalandile evi, “Maka a balia balibatwama bitwamo akeepa, Kabili pali mului ukata wa bintu bituutikile bya kutwanzia kukuula paakale kibumba.” ");
INSERT INTO tap_vpl VALUES ("NH4_11","017_4_11","NEH","4","11","11","Balwani ni bo baalandile nangue, “Tebakaba kumana ao kumona musita utwakaba kwiza pakati kabo ni kubeepaya, pamo ni kulovia ozu mwilo wabo.” ");
INSERT INTO tap_vpl VALUES ("NH4_12","017_4_12","NEH","4","12","12","Bayuda baali baikeele pepi ni balwani betu lubaunvwile twebo twabo, baizile kutusoka nghendo lyanondo nangue, “Konse kumwaakaya, baakamisakukila.” ");
INSERT INTO tap_vpl VALUES ("NH4_13","017_4_13","NEH","4","13","13","Ni pakako, naabiikile bantu ku kyamba kya kibumba kiipi ni paali pali tepanakuulue, naabiikilepo bantu mubabeelele mu lupua lwabo, bantu baali bali ni bipanga byabo, ni mikuuki, pamo ni mata abo. ");
INSERT INTO tap_vpl VALUES ("NH4_14","017_4_14","NEH","4","14","14","Lunaamwene nangue bantu batooboka, naabaanine babiloolo, ni bemanizi, pamo ni bantu bange bonse nangue, “Tekutiine balwani benu, languluke vili bukulu bwakua Mulopue ni vi-ali ni maka. Kansi lue ni balwani benu pa mulandu wa lupua lwenu ni baana benu balalume ni banakazi, ni pa mulandu wa bakazi benu, pamo ni nghanda yenu.” ");
INSERT INTO tap_vpl VALUES ("NH4_15","017_4_15","NEH","4","15","15","Balwani betu lubainikile nangue twaunvua kale mpunda, ni kwinika nangue Leza wakiinoona mapange abo, fwe bonse twaabweleele ku kibumba kubalua muntu pa mwilo wakue. ");
INSERT INTO tap_vpl VALUES ("NH4_16","017_4_16","NEH","4","16","16","Kutula pa ozo musita, nsempu ya babombi bane baatwaliliile kubomba koku inge nsempu ya babombi yalimukubomba mwilo wa bukalinda batweme mikuuki, ni bisoolelo, ni mata, ni makanzu a byela. Babiloolo betu baali bali ku lubali lwa Bayuda ");
INSERT INTO tap_vpl VALUES ("NH4_17","017_4_17","NEH","4","17","17","baali bakuula kibumba. Balia baali batwama bitwamo bya makuule, kubalua muntu waali wabomba na kuboko kumo ni kunge wakwete kilwilo. ");
INSERT INTO tap_vpl VALUES ("NH4_18","017_4_18","NEH","4","18","18","Bakakuula ni bo, kubalua muntu waali wakuula wakakile kipanga mu kitungu. Ni wakulizia ntandala waali wali pepi ni nene. ");
INSERT INTO tap_vpl VALUES ("NH4_19","017_4_19","NEH","4","19","19","Naabaanine babiloolo, ni bemanizi, pamo ni bantu bange bonse nangue, “Miilo ivulile, kabili itanine, ni fwefue twakisalanghaniwa mu kibumba kubalua muntu kule ni mwinakue, ");
INSERT INTO tap_vpl VALUES ("NH4_20","017_4_20","NEH","4","20","20","lyonse kine mwaunvua ntandala yalila, palamineko, pantu Leza wetu alikutulwila.” ");
INSERT INTO tap_vpl VALUES ("NH4_21","017_4_21","NEH","4","21","21","Ni pakako, twaatwaliliile kubomba, bangepo pakati ketu baali batweme mikuuki kutula lukeelekeele mpaka musita wa kumoneka kwa ntanda. ");
INSERT INTO tap_vpl VALUES ("NH4_22","017_4_22","NEH","4","22","22","Ozo wenka musita, na-anine kubalua mwalalume pamo ni mubombi wakue bekale mu Yeruzalemu musita wa busiku, evi tuye twali ni bakutusunga musita wa busiku, ni musita wa koba baye batwaliliile kubomba. ");
INSERT INTO tap_vpl VALUES ("NH4_23","017_4_23","NEH","4","23","23","Ni pakako, nene ni lupua lwane, ni babombi bane, ni bakalinda baali bankonkele, tetwaavuulile ngubo yetu. Kubalua muntu waali waya ku kutapa menda watweme ni kilwilo kyakue. ");
INSERT INTO tap_vpl VALUES ("NH5_1","017_5_1","NEH","5","1","1","Pa kyamba kwaunvwikile mizowa ya bantu, ni ya bakazi babo, baali balimukwitendookela Bayuda nabo. ");
INSERT INTO tap_vpl VALUES ("NH5_2","017_5_2","NEH","5","2","2","Bantu baali balanda nangue, “Fwefue ni baana betu balalume ni banakazi tuvulile, kansi tupalile kupeeluako nghano tulie tukeeza kufua.” ");
INSERT INTO tap_vpl VALUES ("NH5_3","017_5_3","NEH","5","3","3","Kwaali ni bange baali balanda nangue, “Twakibiikia makaba etu kuba kikwatizi, ni makaba a mizabibu, ni nghanda yetu, pakuti tukabe ni nghano pa musita wa nzala.” ");
INSERT INTO tap_vpl VALUES ("NH5_4","017_5_4","NEH","5","4","4","Kabili bange baali balanda nangue, “Twakikopa nfolanga ya kuti tukasonke musonko wa bisonso byetu, ni makaba a mizabibu kuli likolo. ");
INSERT INTO tap_vpl VALUES ("NH5_5","017_5_5","NEH","5","5","5","Fwefue tuli sie bantu bamo, ni baana betu bali sie nga baana babo. Anzia kili evio, tupatikiziiziwe kutwala baana betu mu buzia, ni bamo ba mu baana betu bakazyana tebasyali kale bazia, tetuli na ka kukita pantu bisoka byetu, ni makaba etu a mizabibu tebisyapokelue na bantu bange.” ");
INSERT INTO tap_vpl VALUES ("NH5_6","017_5_6","NEH","5","6","6","Naafiitilue sana lunaunvwile kwitendooka kwabo ni bulanzi bwabo. ");
INSERT INTO tap_vpl VALUES ("NH5_7","017_5_7","NEH","5","7","7","Pa kyamba, naamwene kuti nsoke babiloolo ni bakateeka nabaana nangue, “Mwemue mulimwakopia bya kaloba ku bantu.” Ni pakako, naakolonghaniizie bantu bengi kuti nande nabo. ");
INSERT INTO tap_vpl VALUES ("NH5_8","017_5_8","NEH","5","8","8","Naabaanine nangue, “Fwefue kukonkana ni buvinde bwetu, twakilubula Bayuda netu baasitilue na Bazima. Eba, kabili ni mwemue temwakeba kubasisia kuti ni fwe tubasite paakale?” Tepaali muntu waalandilepo kantu, bonse baikeele sie tondolo. ");
INSERT INTO tap_vpl VALUES ("NH5_9","017_5_9","NEH","5","9","9","Kabili naalandile evi, “Bintu bimulimukukita tebiweme. Ale mwa-andiluaki kutiina Leza wetu evi balwani betu Bazima tekuti baye bali na nsambu ya kuya batutuka? ");
INSERT INTO tap_vpl VALUES ("NH5_10","017_5_10","NEH","5","10","10","Ni nene wenka ni balupua bane pamo ni babombi bane, ndinabakopesia nfolanga ni nghano. Ni pakako, tulekele kukopia bya kaloba. ");
INSERT INTO tap_vpl VALUES ("NH5_11","017_5_11","NEH","5","11","11","Ale babweziizie byonse bimwaali mwabakopia bya kaloba: bisonso byabo, makaba a mizabibu, ni makaba a mizeituni, ni nghanda yabo, pamo ni kibwezia kyonse kimwaalundilepo pa nfolanga, ni pa nghano, ni pa divai pamo ni pa mafuta.” ");
INSERT INTO tap_vpl VALUES ("NH5_12","017_5_12","NEH","5","12","12","Kupwako, ni bo balanda nangue, “Tulikubabweziizia, kabili tetukasonza kantu ka kaloba kuli bene, tulikukita muwalandila.” Naakuutile babitambua, evi babiloolo ni bakateeka balape nangue baakakita nga mubaalandiile. ");
INSERT INTO tap_vpl VALUES ("NH5_13","017_5_13","NEH","5","13","13","Pa kyamba, naakunkile nkanzu yane nalanda nangue, “Kubalua muntu asikaba kufikilizia keki kilapo, Leza amukunke ni kumufumia mu nghanda yakue pamo ni mu miilo yakue. Akunkike pasili kusyala na kantu.” Libumba lyonse lyaalandile nangue, “Evio sile. Yawe alumbue.” Bantu ni bo baakitile nga vibaalapile. ");
INSERT INTO tap_vpl VALUES ("NH5_14","017_5_14","NEH","5","14","14","Kabili kutula sie lunaabiikilue kuba mulombozi wa mu kyalo kyakua Yuda, kutendeka mu mwaka wa 20 mpaka mu mwaka wa 32 mu kuteeka kwakua likolo Artasasta, nene ni lupua lwane twaapwile myaka lyanondo ni ibili, pasili kulia bilio bya bandabukizi. ");
INSERT INTO tap_vpl VALUES ("NH5_15","017_5_15","NEH","5","15","15","Inzi bandabukizi bantangiliile, baali babiibikizia bantu ni kubapoka bilio ni bya kumina, kukila shekeli 40 ya nfolanga ya bityele, ku mpeleezio, babombi babo ni bo baatendekele kubiibikizia bantu, inzi nene nsyakikita evio pantu ndinatiina Leza. ");
INSERT INTO tap_vpl VALUES ("NH5_16","017_5_16","NEH","5","16","16","Ee, naatwaaliliile ni miilo ya keki kibumba, kabili tetwaasitile bukaba, ni babombi bane bonse baali baiza kukolonghana pamo ni nene ku kubomba. ");
INSERT INTO tap_vpl VALUES ("NH5_17","017_5_17","NEH","5","17","17","Ku meza yane kwaali kwaiza kulia bantu 150, Bayuda ni bakateeka, kubiikapo ni balia baafumine ku byalo byaali byatuzyungulukiile. ");
INSERT INTO tap_vpl VALUES ("NH5_18","017_5_18","NEH","5","18","18","Ni bilio byaali byateaniwa bya busiku bumo, paali paelekua nghombe umo ndume, ni mikooko iweme mutanda, kabili baali bandeetela ni tooni, ni bukonto bwa bya kumina bya kubalua musango, lwendo lumo mu nsiku lyanondo, anzia evio, pa mulandu wa bebi bintu byonse, nsyaakebele bilio ku bantu, pantu kubiibikiziiwa kwaali kwakilile ku babo bantu. ");
INSERT INTO tap_vpl VALUES ("NH5_19","017_5_19","NEH","5","19","19","We Leza wane nanguluke pa mulandu wa buwame bunakikitila baba bantu. ");
INSERT INTO tap_vpl VALUES ("NH6_1","017_6_1","NEH","6","1","1","Sanibalati, ni Tobia, ni Gesemi Muarabu, pamo ni balwani betu baali basyelepo lubaunvwile mpunda nangue, nakikuula paakale kibumba, kabili nangue tekusyele nkendo ituutikile, anzia pa ozo musita naali nsinabiike milyango, ");
INSERT INTO tap_vpl VALUES ("NH6_2","017_6_2","NEH","6","2","2","Sanibalati ni Gesemi baalaiziizie mikenzi ya kunghana nangue, “Iza mu muzi umo wa mu lulambe lwa Ono.” Inzi mapange abo aali a kunkitila kibiipile. ");
INSERT INTO tap_vpl VALUES ("NH6_3","017_6_3","NEH","6","3","3","Ni nene naalaiziizie mikenzi kwabo ya kubaana nangue, “Ezi miilo indimukubomba ni ikata, ni pakako, nene nsiizako. Ale kindikwimikila miilo pa mulandu wa kwiza koko ni kiki?” ");
INSERT INTO tap_vpl VALUES ("NH6_4","017_6_4","NEH","6","4","4","Ni bo baatwaliliile kulaizia nghendo yonse ina balanda sie twebo tumonke, ni ne nakaana sie. ");
INSERT INTO tap_vpl VALUES ("NH6_5","017_6_5","NEH","6","5","5","Kabili Sanibalati waatumine mubombi wakue watweme ni lupapulo tekuba lwaizeelue. Lolu lwaali lwendo lwa busaano. ");
INSERT INTO tap_vpl VALUES ("NH6_6","017_6_6","NEH","6","6","6","Mu lupapulo mwaali mwalembelue evi, “Mpunda ilimukunvwika ku Bazima, ni Gesemi alimukusininkizia nangue wewe pamo ni Bayuda, mulimukukambila kwisangula. Ni pakako, i kimulimukukuulila paakale kibumba. Kukonkana ni ezio mpunda, wewe ulimukukeba kuba likolo wabo. ");
INSERT INTO tap_vpl VALUES ("NH6_7","017_6_7","NEH","6","7","7","Wewe usoobwele bakabika bakuti babikule pa mulandu obe mu Yeruzalemu nangue mu kyalo kya Yudea muli ni likolo, ni evi likolo wakaba kubwilua mubeeleele ezi milandu. Ni pakako tupalile kulanzyania.” ");
INSERT INTO tap_vpl VALUES ("NH6_8","017_6_8","NEH","6","8","8","Ni nene na-asukile nangue, “Bebi biwalanda tebiliko, walanda sie bya mu mutue obe.” ");
INSERT INTO tap_vpl VALUES ("NH6_9","017_6_9","NEH","6","9","9","Baba bonse balimukukeba sie kututiinia balanda nangue, “Bakaba kunakapo sie, ni miilo teikaba kubombeka.” Inzi naamulombele Leza nalanda, “Ale n'mpeele maka.” ");
INSERT INTO tap_vpl VALUES ("NH6_10","017_6_10","NEH","6","10","10","Busiku bumo naile ku nghanda yakua Semaia mwina Delaia, Delaia mwina Mehetabeli waali waizaliilue mu nghanda yakue. Ni ye waalandile nangue, “Twende tusaakaane mu Nghanda yakua Leza ni kwikiikilila pantu bakambiile kwiza kukwipaya. Ee, kwiza kukwipaya busiku.” ");
INSERT INTO tap_vpl VALUES ("NH6_11","017_6_11","NEH","6","11","11","Naalandile evi, “Kubako muntu ali nga nene kuti wabutuka? Kubako muntu ali nga nene kuti waingila mu Nghanda yakua Leza kuti epususie? Nene nsingilamo.” ");
INSERT INTO tap_vpl VALUES ("NH6_12","017_6_12","NEH","6","12","12","Kisinka nainikile nangue taatuminue na Leza, inzi waakitile sie ezi mbiko pa mulandu wane, pantu Tobia ni Sanibalati baamulipile. ");
INSERT INTO tap_vpl VALUES ("NH6_13","017_6_13","NEH","6","13","13","Baamulipile kuti eze antiinie, evi pa nduvia bamone mulandu ubi wa kunfuupwilapo. ");
INSERT INTO tap_vpl VALUES ("NH6_14","017_6_14","NEH","6","14","14","“We Leza wane languluka Tobia ni Sanibalati kukonkana ni bikitua byabo, kabili languluka ni Noadia kabika mwanakazi, ni bange bakabika basyelepo balimukukeba kuntiinia.” ");
INSERT INTO tap_vpl VALUES ("NH6_15","017_6_15","NEH","6","15","15","Kibumba kyaakuulilue nsiku 52, ni kyo kyaapwile pa nsiku 25 ya mwezi wa Eluli. ");
INSERT INTO tap_vpl VALUES ("NH6_16","017_6_16","NEH","6","16","16","Balwani betu bonse lubaunvwile evio, balia Bazima bonse baali batuzyungulukiile ni bo baatiinine ni kwitoobokelela bo bene, pantu bainikile nangue ezio miilo yaabombelue na bukwasi bwakua Leza wetu. ");
INSERT INTO tap_vpl VALUES ("NH6_17","017_6_17","NEH","6","17","17","Mu ezio nsiku, banombozi ba Bayuda baali bamutumiine Tobia mpapulo ingi, ni maasuko akua Tobia aali afika kuli bene. ");
INSERT INTO tap_vpl VALUES ("NH6_18","017_6_18","NEH","6","18","18","Mu Yudea mwaali bantu bengi baali balapile pa mulandu wakue, pantu waali muko wakua Sekania mwina Ara, ni Yohanani mwanaye waali waupile mwina Mesulamu mwina Berekia. ");
INSERT INTO tap_vpl VALUES ("NH6_19","017_6_19","NEH","6","19","19","Kabili baalandile bikitua byakue biweme kuli nene, ni ye baamwanine vinaalandile. Inzi Tobia ni ye waatwaliliile kuntumina mpapulo ya kuntiinia. ");
INSERT INTO tap_vpl VALUES ("NH7_1","017_7_1","NEH","7","1","1","Kibumba lukyaali kyasyapwile kukuulua paakale, ni milyango luyaali yasyabiikilue, ni bakalinda ba milyango, ni bakemba, ni Balawi basyababiikile, ");
INSERT INTO tap_vpl VALUES ("NH7_2","017_7_2","NEH","7","2","2","Naamubiikile Hanani umo wa mu lupua lwane kuba kalinda wa Yeruzalemu, pamo ni Hanania waali wali kiloolo wa balukale baali balinda kyubo kya Yeruzalemu pantu Hanania waali wa kisinka, kabili waali watiina Leza kukila vyaali vyatiina bange bantu. ");
INSERT INTO tap_vpl VALUES ("NH7_3","017_7_3","NEH","7","3","3","Naabaanine nangue, “Milyango ya Yeruzalemu tekuti iye yaizulua mpaka sie koba kasyaselele, ni musita onse bakalinda lubakiimeene pa mwilo wa kulinda, milyango iye yaizeelue yakiikilue, kabili mubiikepo bekazi ba mu Yeruzalemu kuti baye bali bakalinda, kubalua muntu pa musita wakue, kabili kubalua muntu aye waimeene wakentele ku nghanda yakue.” ");
INSERT INTO tap_vpl VALUES ("NH7_4","017_7_4","NEH","7","4","4","Muzi wa Yeruzalemu waali waleepele kabili watanine, inzi bantu tebaali bavulilemo, ni mo mwaali temunakuulue nghanda. ");
INSERT INTO tap_vpl VALUES ("NH7_5","017_7_5","NEH","7","5","5","Mu mutima mwane Leza waabiikilemo malanga akukolonghania babiloolo, ni bakateeka, ni bantu bange kuti bapendue kukonkana ni mubabeeleele mu nvyalo. Naasangile kitabu kyaali kyalembeluemo balia baabwelele mu lwendo lwa mambo. Ni ne naamwene balembeluemo. ");
INSERT INTO tap_vpl VALUES ("NH7_6","017_7_6","NEH","7","6","6","Baba i bekazi ba mu kiputu kya kyalo, balia baafumine mu buzia, bantu ba mu balia baatwelue kuli Nebukadneza likolo wa ku Babeli, baba bantu baabweleele mu Yeruzalemu ni mu Yudea, kubalua muntu mu muzi wakue. ");
INSERT INTO tap_vpl VALUES ("NH7_7","017_7_7","NEH","7","7","7","Balia baizile pamo ni Zerubabeli meena abo ni aza: Yoshua, ni Nehemia, ni Azaria, ni Ramia, ni Nahamani, ni Mordekai, ni Bilsani, ni Misipereti, ni Bigwai, ni Nehumu, pamo ni Bana. Mpendua ya balalume Baizraeli ni ezi: ");
INSERT INTO tap_vpl VALUES ("NH7_8","017_7_8","NEH","7","8","8","Bena Parosi baali 2,172. ");
INSERT INTO tap_vpl VALUES ("NH7_9","017_7_9","NEH","7","9","9","Bena Sefatia baali 372. ");
INSERT INTO tap_vpl VALUES ("NH7_10","017_7_10","NEH","7","10","10","Bena Ara baali 652. ");
INSERT INTO tap_vpl VALUES ("NH7_11","017_7_11","NEH","7","11","11","Bena Pahati-Moabu, bena Yeshua ni Yoabu, baali 2,818. ");
INSERT INTO tap_vpl VALUES ("NH7_12","017_7_12","NEH","7","12","12","Bena Elamu baali 1,254. ");
INSERT INTO tap_vpl VALUES ("NH7_13","017_7_13","NEH","7","13","13","Bena Zatu baali 845. ");
INSERT INTO tap_vpl VALUES ("NH7_14","017_7_14","NEH","7","14","14","Bena Zakai baali 760. ");
INSERT INTO tap_vpl VALUES ("NH7_15","017_7_15","NEH","7","15","15","Bena Binui baali 648. ");
INSERT INTO tap_vpl VALUES ("NH7_16","017_7_16","NEH","7","16","16","Bena Bebai baali 628. ");
INSERT INTO tap_vpl VALUES ("NH7_17","017_7_17","NEH","7","17","17","Bena Azgadi baali 2,322. ");
INSERT INTO tap_vpl VALUES ("NH7_18","017_7_18","NEH","7","18","18","Bena Adonikamu baali 667. ");
INSERT INTO tap_vpl VALUES ("NH7_19","017_7_19","NEH","7","19","19","Bena Bigwai baali 2,067. ");
INSERT INTO tap_vpl VALUES ("NH7_20","017_7_20","NEH","7","20","20","Bena Adini baali 655. ");
INSERT INTO tap_vpl VALUES ("NH7_21","017_7_21","NEH","7","21","21","Bena Ateri, benzikulu bakua Hezekia, baali 98. ");
INSERT INTO tap_vpl VALUES ("NH7_22","017_7_22","NEH","7","22","22","Bena Hasumu baali 328. ");
INSERT INTO tap_vpl VALUES ("NH7_23","017_7_23","NEH","7","23","23","Bena Besai baali 324. ");
INSERT INTO tap_vpl VALUES ("NH7_24","017_7_24","NEH","7","24","24","Bena Harifu baali 112. ");
INSERT INTO tap_vpl VALUES ("NH7_25","017_7_25","NEH","7","25","25","Bena Gibeoni baali 95. ");
INSERT INTO tap_vpl VALUES ("NH7_26","017_7_26","NEH","7","26","26","Bantu ba ku Betlehemu, ni ba ku Netofa baali 188. ");
INSERT INTO tap_vpl VALUES ("NH7_27","017_7_27","NEH","7","27","27","Bantu ba ku Anatoti baali 128. ");
INSERT INTO tap_vpl VALUES ("NH7_28","017_7_28","NEH","7","28","28","Bantu ba ku Beti-Asimaweti, baali 42. ");
INSERT INTO tap_vpl VALUES ("NH7_29","017_7_29","NEH","7","29","29","Bantu ba ku Kiriati-Yearimu, ni ba ku Kefira, ni ba ku Beroti, baali 743. ");
INSERT INTO tap_vpl VALUES ("NH7_30","017_7_30","NEH","7","30","30","Bantu ba ku Rama, ni ba ku Geba, baali 621. ");
INSERT INTO tap_vpl VALUES ("NH7_31","017_7_31","NEH","7","31","31","Bantu ba ku Mikimasi baali 122. ");
INSERT INTO tap_vpl VALUES ("NH7_32","017_7_32","NEH","7","32","32","Bantu ba ku Beteli, ni ba ku Ai baali 123. ");
INSERT INTO tap_vpl VALUES ("NH7_33","017_7_33","NEH","7","33","33","Bantu ba ku muzi unge wa Nebo baali 52. ");
INSERT INTO tap_vpl VALUES ("NH7_34","017_7_34","NEH","7","34","34","Bantu ba ku muzi unge wa Elamu baali 1,254. ");
INSERT INTO tap_vpl VALUES ("NH7_35","017_7_35","NEH","7","35","35","Bena Harimu baali 320. ");
INSERT INTO tap_vpl VALUES ("NH7_36","017_7_36","NEH","7","36","36","Bantu ba ku Yeriko baali 345. ");
INSERT INTO tap_vpl VALUES ("NH7_37","017_7_37","NEH","7","37","37","Bantu ba ku Lodi, ni ba ku Hadidi, pamo ni ba ku Ono, baali 721. ");
INSERT INTO tap_vpl VALUES ("NH7_38","017_7_38","NEH","7","38","38","Bena Sena baali 3,930. ");
INSERT INTO tap_vpl VALUES ("NH7_39","017_7_39","NEH","7","39","39","Babitambua, bena Yedaia, ba mu nghanda yakua Yeshua, baali 973. ");
INSERT INTO tap_vpl VALUES ("NH7_40","017_7_40","NEH","7","40","40","Bena Imeri baali 1,052. ");
INSERT INTO tap_vpl VALUES ("NH7_41","017_7_41","NEH","7","41","41","Bena Pasuri baali 1,247. ");
INSERT INTO tap_vpl VALUES ("NH7_42","017_7_42","NEH","7","42","42","Bena Harimu baali 1,017. ");
INSERT INTO tap_vpl VALUES ("NH7_43","017_7_43","NEH","7","43","43","Balawi, bena Yeshua i kulanda nangue Kadimieli, pamo ni bena Hodavia baali 74. ");
INSERT INTO tap_vpl VALUES ("NH7_44","017_7_44","NEH","7","44","44","Bakemba, bena Asafu baali 148. ");
INSERT INTO tap_vpl VALUES ("NH7_45","017_7_45","NEH","7","45","45","Bakalinda ba pa mulyango, ni bena Salumu, ni bena Ateri, ni bena Talmoni, ni bena Akubu, ni bena Hatita, pamo ni bena Sobai, baali 138. ");
INSERT INTO tap_vpl VALUES ("NH7_46","017_7_46","NEH","7","46","46","Babombi ba mu Nghanda yakua Leza, bena Siha, ni bena Hasufa, ni bena Tobaoti, ");
INSERT INTO tap_vpl VALUES ("NH7_47","017_7_47","NEH","7","47","47","ni bena Kerosi, ni bena Sia, ni bena Padoni, ");
INSERT INTO tap_vpl VALUES ("NH7_48","017_7_48","NEH","7","48","48","ni bena Lebana, ni bena Hagaba, ni bena Salmai, ");
INSERT INTO tap_vpl VALUES ("NH7_49","017_7_49","NEH","7","49","49","ni bena Hanani, ni bena Gideli, ni bena Gahari, ");
INSERT INTO tap_vpl VALUES ("NH7_50","017_7_50","NEH","7","50","50","ni bena Reaia, ni bena Resini, ni bena Nekoda, ");
INSERT INTO tap_vpl VALUES ("NH7_51","017_7_51","NEH","7","51","51","ni bena Gazamu, ni bena Uza, ni bena Pasea, ");
INSERT INTO tap_vpl VALUES ("NH7_52","017_7_52","NEH","7","52","52","ni bena Besai, ni bena Munimu, ni bena Nefusemu, ");
INSERT INTO tap_vpl VALUES ("NH7_53","017_7_53","NEH","7","53","53","ni bena Bakibuki, ni bena Hakufa, ni bena Harihuri, ");
INSERT INTO tap_vpl VALUES ("NH7_54","017_7_54","NEH","7","54","54","ni bena Basiliti, ni bena Mehida, ni bena Harsa, ");
INSERT INTO tap_vpl VALUES ("NH7_55","017_7_55","NEH","7","55","55","ni bena Barkosi, ni bena Sisera, ni bena Tema, ");
INSERT INTO tap_vpl VALUES ("NH7_56","017_7_56","NEH","7","56","56","ni bena Nezia, ni bena Hatifa. ");
INSERT INTO tap_vpl VALUES ("NH7_57","017_7_57","NEH","7","57","57","Bantu ba mu luvyalo lwa babombi bakua Solomoni: Bena Sitai, ni bena Sofereti, ni bena Perida, ");
INSERT INTO tap_vpl VALUES ("NH7_58","017_7_58","NEH","7","58","58","ni bena Yala, ni bena Darkoni, ni bena Gideli, ");
INSERT INTO tap_vpl VALUES ("NH7_59","017_7_59","NEH","7","59","59","ni bena Sefatia, ni bena Hatili, ni bena Pokereti-Hazebaimu, ni bena Amoni. ");
INSERT INTO tap_vpl VALUES ("NH7_60","017_7_60","NEH","7","60","60","Babombi bonse ba mu Nghanda yakua Leza pamo ni bena Solomoni, baali 392. ");
INSERT INTO tap_vpl VALUES ("NH7_61","017_7_61","NEH","7","61","61","Baba i balia baabwelele kufuma ku Teli-Mela, ni ku Teli-Harsa, ni ku Kerubu, ni ku Adoni, pamo ni ku Imeri, inzi ba-andilue kulondolola bikolue ni masiiko abo pakuti kisininkiziiwe nangue baali Baizraeli. ");
INSERT INTO tap_vpl VALUES ("NH7_62","017_7_62","NEH","7","62","62","Bena Delaia, ni bena Tobia, ni bena Nekoda, baali 642. ");
INSERT INTO tap_vpl VALUES ("NH7_63","017_7_63","NEH","7","63","63","Bena babitambua, ni bena Hobaia, ni bena Hakosi, ni bena Barzilai, olia waupile mukazyana mwina Barzilai Mugileadi wa mu mukowa wakua Barzilai, ni kwinikua liina lyabo. ");
INSERT INTO tap_vpl VALUES ("NH7_64","017_7_64","NEH","7","64","64","Babo bantu baakebele butantiko bwa meena abo mu balia baapendeelue nvyalo, inzi tebaamwenekelemo. Ni pakako, baamwenekele kuba batiikeene, i kyaalengele kuti babafumie pa mwilo wa bukitambua. ");
INSERT INTO tap_vpl VALUES ("NH7_65","017_7_65","NEH","7","65","65","Ndabukizi waabakaaniizie kulia bintu bizuukiisie, mpaka musita waakabapo kitambua wa kubombia Urimu ni Tumimu. ");
INSERT INTO tap_vpl VALUES ("NH7_66","017_7_66","NEH","7","66","66","Bantu bonse pamo, baali 42,360. ");
INSERT INTO tap_vpl VALUES ("NH7_67","017_7_67","NEH","7","67","67","Babombi babo, balalume ni banakazi, baali 7,337. Bakemba balalume ni banakazi baali 245. ");
INSERT INTO tap_vpl VALUES ("NH7_68","017_7_68","NEH","7","68","68","Bafarasi babo baali 736. Nyumbu 245. ");
INSERT INTO tap_vpl VALUES ("NH7_69","017_7_69","NEH","7","69","69","Nghamia yabo yaali 435. Punda yabo yaali 6,720. ");
INSERT INTO tap_vpl VALUES ("NH7_70","017_7_70","NEH","7","70","70","Bamasiiko bamo ba mu basibo, baafumiizie bunonsi bwabo pa mulandu wa ezi miilo. Tirshata waafumiizie mu kipao darkoni 1,000 ya oro, bibakuli 50, bya kuvwala babitambua 530. ");
INSERT INTO tap_vpl VALUES ("NH7_71","017_7_71","NEH","7","71","71","Bange bamasiiko ba mu basibo baabiikile mu bukonto bwa miilo, darkoni 20,000 ya oro, ni manemane 2,200 ya mutofue. ");
INSERT INTO tap_vpl VALUES ("NH7_72","017_7_72","NEH","7","72","72","Ni bantu baasyelepo, baafumiizie darkoni 20,000 ya oro, ni manemane 2,000 ya mutofue, ni bya kuvwala 67 bya babitambua. ");
INSERT INTO tap_vpl VALUES ("NH7_73","017_7_73","NEH","7","73","73","Evi babitambua, ni Balawi, ni balia bakalinda ba pa mulyango wa Nghanda yakua Leza, ni bakemba, ni bange bantu, ni babombi ba mu Nghanda yakua Leza, pamo ni Baizraeli bonse, baikeele mu mizi yabo. Mu mwezi wa kilooba, Baizraeli bonse baile kwikala mu mizi yabo. ");
INSERT INTO tap_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Bantu bonse baakolongheene nga muntu umo pa kifuka kimo kikata kyaali pa ntanzi ya mulyango wa menda. Baamwanine Ezra kasambilizia wa mizilo aleete kitabu kya mizilo yakua Musa yaalailue Baizraeli kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Mu busiku bwa mambo bwa mwezi wa kilooba, kitambua Ezra waaleetele kitabu kya mizilo ku libumba lya balalume ni banakazi, ni ku bonse baali ni buvinde bwa kunvua. ");
INSERT INTO tap_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Ezra waabelengele kitabu pa ntanzi yabo bonse pa musolo waali wali lya pa mulyango wa menda, kutendeka lukeelekeele mpaka koba mukati, ntanzi ya babo balalume ni banakazi, pamo ni bonse baali ni buvinde bwa kunvua, bantu bonse baali batwiliziizie vyaali vyabelengua kitabu kya mizilo. ");
INSERT INTO tap_vpl VALUES ("NH8_4","017_8_4","NEH","8","4","4","Ezra kasambilizia wa mizilo waali waimeene pa kintamba kya bimuti, kyaali kyakitiilue sie pa mulandu wa ezio miilo. Ku kulio kwakue kwaali kwaimeene Matitia ni Sema, ni Anaia, ni Uria, ni Hilkia, ni Maseia, ni ku kuso kwakue kwaali kwaimeene Pedaia, ni Misaeli, ni Malkia, ni Hasumu, ni Hasubadana, ni Zakaria pamo ni Mesulamu. ");
INSERT INTO tap_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Ezra waavingulwile kitabu ni bantu bonse bamumwene, pantu waali wali pa muulu kukila bantu bonse, ni lu-aavingulwile sie kekio kitabu, bantu bonse baimeene. ");
INSERT INTO tap_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Ezra waamutasiizie Yawe Leza Mukulu. Kupwako, bantu bonse baitabizia balanda nangue, “Evio sile! Evio sile!” Koku balendwile maboko mu muulu. Pa kyamba baafukeeme, bakontama ni kumupupa Yawe ni nkebu yabo yakumiizie pansi. ");
INSERT INTO tap_vpl VALUES ("NH8_7","017_8_7","NEH","8","7","7","Bantu lubaimeene kubalua muntu pa kifuka kyakue, baba Balawi, Yeshua, ni Bani, ni Serebia, ni Yamini, ni Akubu, ni Sebetai, ni Hodia, ni Maseia, ni Kelita, ni Azaria, ni Yozabadi, ni Hanania, ni Pelaia, baatendekele kubalondolwela bantu mizilo. ");
INSERT INTO tap_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","Baabelengele bwino bwino mu kitabu kya mizilo yakua Leza, ni kulondolola mpaka ni bantu baunvwisia byaali byabelengua. ");
INSERT INTO tap_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Bantu bonse lubaunvwisiizie mizilo, baatendekele kulila. Ni pakako, Nehemia waali ndabukizi, ni kitambua Ezra kabili kasambilizia wa mizilo, pamo ni Balawi balia baali basambilizia bantu, baabaanine bantu bonse nangue, “Bono i busiku buzuuke bwakua Yawe Leza wenu, kansi tekuloosie, ao kulila.” ");
INSERT INTO tap_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Nehemia waalandile evi, “Ale bwelele ku nghanda muye mukite nsikunkulu, mulie manone, ni kumina divai isonsele. Inzi tekulabe kubapeelako balia basili na bilio bingi pantu bono busiku i busiku buzuuke bwakua Yawe Leza wetu. Tekuye mwali ni bulanda pantu nsansa yakua Yawe i maka enu.” ");
INSERT INTO tap_vpl VALUES ("NH8_11","017_8_11","NEH","8","11","11","Ni pakako, Balawi baatalaziizie bantu bonse balanda nangue, “Talale pantu bono busiku buzuukile, kabili tekuye mwali ni bulanda.” ");
INSERT INTO tap_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","Kupwako, bantu bonse baya ku kulia ni kumina, ni kutwalilako basikwete nsempu ya bilio, ni kusangalala sana, pantu baunvwisiizie twebo tubaabelengeelue. ");
INSERT INTO tap_vpl VALUES ("NH8_13","017_8_13","NEH","8","13","13","Busiku bwa bubili, bamasiiko ba mikowa pamo ni babitambua ni Balawi, baamukolonghaniine kalemba Ezra kuti basambilile bwino bwino twebo twa mizilo. ");
INSERT INTO tap_vpl VALUES ("NH8_14","017_8_14","NEH","8","14","14","Ni bo baasangile mwalembelue mizilo ya-aninue Musa na Yawe nangue Baizraeli bapalile bakabe baikala mu mitanda pa busiku bwa nsikunkulu ya mwezi wa kilooba, ");
INSERT INTO tap_vpl VALUES ("NH8_15","017_8_15","NEH","8","15","15","kabili nangue, bapalile kupunda mu mizi yabo yonse pamo ni mu Yeruzalemu balanda nangue, “Sele ku lupili muye mutwame misambo ya mizeituni, ni misambo ya mizeituni ya mu kisonso, ni misambo ya ngazi, ni ya bunkindu, ni ya bimuti binge bikata, evi muye mwimike mitanda nga mulandiile mizilo.” ");
INSERT INTO tap_vpl VALUES ("NH8_16","017_8_16","NEH","8","16","16","Kupwako, bantu baya kutwama misambo, bakitilako mitanda kubalua muntu pa muulu wa nghanda yakue, ni mu misolo yabo, ni mu misolo ya Nghanda yakua Leza, ni pa kifuka kikata kili pa mulyango wa menda, pamo ni pa kifuka kikata kya pa mulyango wa Efraimu. ");
INSERT INTO tap_vpl VALUES ("NH8_17","017_8_17","NEH","8","17","17","Ni bonse baafumine mu buzia, baakitile mitanda, ni kwikalamo, pantu kutula ku nsiku yakua Yoshua mwina Nuni, mpaka pa bobo busiku, Baizraeli baali tebanakitepo nsikunkulu ya ozu musango. Kabili yaali nsansa ikata sana. ");
INSERT INTO tap_vpl VALUES ("NH8_18","017_8_18","NEH","8","18","18","Kubalua busiku, kutula busiku bwa mambo, mpaka busiku bwa mpeleezio, Ezra waali wababelengela bantu kitabu kya mizilo yakua Leza. Ni busiku bwa kilooba, baakitile nsikunkulu. Busiku bwa mwanda kwaali kulonghana kuzuuke nga mubeeleele mafunde. ");
INSERT INTO tap_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","1","Mu ozo mwezi pa nsiku 24 Baizraeli baakolongheene ni kuizilika bilio bavwele masaaka, ni kuya baipuupile bulongo ku mitue. ");
INSERT INTO tap_vpl VALUES ("NH9_2","017_9_2","NEH","9","2","2","Baizraeli baikekele ku baeni bonse, baimeene ni kutendeka kulapila bibalo byabo ni bilubo bya basibo. ");
INSERT INTO tap_vpl VALUES ("NH9_3","017_9_3","NEH","9","3","3","Baimeene pa kifuka kyabo ni kubelengelua kitabu kya mizilo yakua Yawe Leza wabo mwila wa nsita itatu, ni inge nsita itatu baali balimukulapila bibalo ni kumupupa Yawe Leza wabo. ");
INSERT INTO tap_vpl VALUES ("NH9_4","017_9_4","NEH","9","4","4","Yeshua, ni Kadimieli, ni Bani, ni Sebania, ni Buni, ni Serebia, ni Bani unge pamo ni Kenani, baimeene mu nkendo ya Balawi balimukupepa Yawe Leza wabo basamwine. ");
INSERT INTO tap_vpl VALUES ("NH9_5","017_9_5","NEH","9","5","5","Pa kyamba, baba Balawi, Yeshua, ni Kadimieli, ni Bani, ni Hesbunia, ni Serebia, ni Hodia, ni Sebania pamo ni Petahia baalandile nangue, “Imane mumutasie Yawe Leza wenu wa muyayaya ni muyayaya.” “Liina lyakue lilumbue, liina likindeeme kukila mapaalo onse ni bulumba bonse.” ");
INSERT INTO tap_vpl VALUES ("NH9_6","017_9_6","NEH","9","6","6","Ezra waalandile, “We Yawe, wewe bunke bobe uli Yawe, Waalengele myulu, ni byonse bilimo, Kyalo pamo ni byonse bilimo, Myenzi pamo ni byonse bilimo. Kubalua kintu ukipeele bukose. Ni libumba lya mwiulu lililyakupupa. ");
INSERT INTO tap_vpl VALUES ("NH9_7","017_9_7","NEH","9","7","7","Wewe uli Yawe, Leza waamusaakwile Abramu, Waamufumiizie mu Uri ya Bakaldayo, Waamwinikile liina lya Abrahamu. ");
INSERT INTO tap_vpl VALUES ("NH9_8","017_9_8","NEH","9","8","8","Waamwene vi-aali wa kisinka kuli wewe, Waakitile nakue kipingo Waalaile kupeela nvyalo yakue kyalo kya Bakanaani, Kya Bahiti, ni kya Ba-amori, Kya Baperizi, ni kya Bayebusi, ni kya Bagirgasi, Wewe waafikiliizie bulayo bobe pantu wewe uli mulunghami.” ");
INSERT INTO tap_vpl VALUES ("NH9_9","017_9_9","NEH","9","9","9","“Wewe waamwene bukyuzi bwa babikolue betu lubaali mu Misri, Kabili waunvwile malilo abo lubaali kumbali Lyezi lya Kasi. ");
INSERT INTO tap_vpl VALUES ("NH9_10","017_9_10","NEH","9","10","10","Wewe waakitile tupapo pali Farao, Pa babiloolo bakue bonse, ni pa bantu bonse ba mu kyalo kyakue, Wewe waali wamanine babikolue betu vibaakitiilue bibiipile na Bamisri. Wewe waikitiile liina lisyaliliile ni lenu kumo. ");
INSERT INTO tap_vpl VALUES ("NH9_11","017_9_11","NEH","9","11","11","Waakasaniizie lyezi pa menso a bantu bobe, Ni bo baapitile mu lyezi pansi paumine. Balia baali babakonkele waabatibiziizie, Nga libue mu menda engi, waababunziizie. ");
INSERT INTO tap_vpl VALUES ("NH9_12","017_9_12","NEH","9","12","12","Wewe waalombwele bantu bobe na lipumpu lya lilezi musita wa koba, Na lipumpu lya mulilo musita wa busiku, evi baye basanikiilue mu nzila mu baali baya. ");
INSERT INTO tap_vpl VALUES ("NH9_13","017_9_13","NEH","9","13","13","Wewe waakookeele pa Lupili lwa Sinai. Wewe waalandile nabo wali mu muulu, Waabapeele bupinguzi bwa nsambu ni mafunde a kiine ni alungheeme, pamo ni mizilo, ni milao iweme. ");
INSERT INTO tap_vpl VALUES ("NH9_14","017_9_14","NEH","9","14","14","Waabamaniizie Sabata yobe izuuke, Ni kubapeela milao ni mafunde pamo ni mizilo kupitila muli Musa mubombi obe.” ");
INSERT INTO tap_vpl VALUES ("NH9_15","017_9_15","NEH","9","15","15","“Lubaunvwile nzala waabapeele mukate kufuma mwiulu. Lubaunvwile kyaka, waabapeele menda kufuma mu mwalala. Wewe waabaanine bakapyane kyalo. Kyalo kiwaalaile kubapeela.” ");
INSERT INTO tap_vpl VALUES ("NH9_16","017_9_16","NEH","9","16","16","Inzi babikolue betu baafiiniizie mitima, Kabili tebaatonene kutwilizia milao yobe. ");
INSERT INTO tap_vpl VALUES ("NH9_17","017_9_17","NEH","9","17","17","Baakeene kunakila, kabili tebaalangulukile tupapo tuwaakitile pakati kabo, Inzi baafiniizie mitima yabo, Ni mu kwisangula kwabo, baibiikile mukulu wa kubalombola, Evi babwelele mu buzia bwabo. Inzi wewe uli Leza aliwaeleela, Wewe uli ni buwame, ni nkumbu ingi, kabili tewizi kulenga kufiitua, Wewe wizuzi ntono. Ni pakako, tewaabalekeeleele. ");
INSERT INTO tap_vpl VALUES ("NH9_18","017_9_18","NEH","9","18","18","Ee, musita ubaikitiile musoka wa nghombe wa kusungulula, Baalandile nangue ozu i leza wenu waamifumiizie ku Misri. Lubaakitile bintu bikata bya mufuupula, ");
INSERT INTO tap_vpl VALUES ("NH9_19","017_9_19","NEH","9","19","19","“Wewe kukonkana ni bwingi bwa nkumbu yobe, tewaabalekeeleele mu kaseeba. Lipumpu lya lilezi telyaalekeele kubalombola musita wa koba, Lipumpu lya mulilo telyaalekeele kubalombola musita wa busiku, evi liye lyabasanikiile ni kubalangilila nzila ya kuyamo. ");
INSERT INTO tap_vpl VALUES ("NH9_20","017_9_20","NEH","9","20","20","Wewe waabapeele Mweo obe uweme wakubasambilizia, Kabili waabapeele maana a kulia ni menda a kutalalika kyaka kyabo. ");
INSERT INTO tap_vpl VALUES ("NH9_21","017_9_21","NEH","9","21","21","Ee, pa myaka 40, waali wabateekamaniizie mu kaseeba, Kabili tebaabulilue kantu. Ngubo yabo teyaazabukile, Ni makasa abo teavimbile. ");
INSERT INTO tap_vpl VALUES ("NH9_22","017_9_22","NEH","9","22","22","“Wewe waabapeele bwanzio pa bukolo ni ntundu ya bantu, Kabili waabapeele byalo byaali byabazyungulukiile. Ba-anziizie kyalo kya Hesihoni kyaali kyateekelue na Sioni, Kabili ba-anziizie kyalo kya Basani kyaali kyateekelue na likolo Ogi. ");
INSERT INTO tap_vpl VALUES ("NH9_23","017_9_23","NEH","9","23","23","Wewe waavuziizie baana babo nga ntanda ya mwiulu, Ni kubaleeta mu kyalo Kiwaalaile basibo kuti bengile ni kwikalamo. ");
INSERT INTO tap_vpl VALUES ("NH9_24","017_9_24","NEH","9","24","24","Baana babo baingiile ni kupyana kyalo, ni we wa-anziizie Bakanaani. Wewe waabiikile Bakanaani mu maboko a babo baana. Bantu bobe baakitile mubatoneene, Ku makolo ni ku bantu ba mu kekio kyalo. ");
INSERT INTO tap_vpl VALUES ("NH9_25","017_9_25","NEH","9","25","25","Baapokele mizi ili ni byubo ni kyalo kili ni muvundo. Baapokele mizi ili ni bunonsi, nghanda izuzimo bintu bingi biweme, Biina bya menda byaali byaimbilue, Ni makaba a mizabibu, ni makaba a mizeituni, pamo ni bimuti bili ni mazabo engi. Ni pakako, baaliile ni kwikuta, Baasambukile ni kwisansamusia mu buwame bobe.” ");
INSERT INTO tap_vpl VALUES ("NH9_26","017_9_26","NEH","9","26","26","“Anzia kyaali evio tebaakunakiile, Bene baakusangukiile ni kufunghamina mizilo yobe, Baipaile bakabika bobe, Babo baababikwiliile kuti babwelele kuli wewe. Baakitile bibalo bikata. ");
INSERT INTO tap_vpl VALUES ("NH9_27","017_9_27","NEH","9","27","27","Ni pakako, waabapeene mu maboko a balwani babo baabakyuziizie, Inzi lubaali baema, baakuliliile. Waabonvwile momo mwiulu. Mu bwingi bwa nkumbu yobe waabapeele banombozi Baabafumiizie mu maboko a balwani babo.” ");
INSERT INTO tap_vpl VALUES ("NH9_28","017_9_28","NEH","9","28","28","“Inzi lubaali basyaikeele bwino, kabili baakuluviizie, Ni we waabalekeleele mu maboko a balwani babo, ni bo baabateekele. Musita ubaakubweleele ni kukulilila, Waabonvwile momo mwiulu Ni kubapususia nghendo ingi pa mulandu wa nkumbu yobe.” ");
INSERT INTO tap_vpl VALUES ("NH9_29","017_9_29","NEH","9","29","29","“Kabili waabasokele kuti babwelele ku mizilo yobe. Anzia kyaali evio, kabili baakitile kiitoni, ni milao yobe tebaitwiliziizie, Inzi baasangukiile milao yobe, i waalandile nangue Muntu waakanakila ezio milao waakaba ni bukose. Ba-alukile ni kiitoni, ni kufinia mitima yabo, kabili tebaatonene kunakila. ");
INSERT INTO tap_vpl VALUES ("NH9_30","017_9_30","NEH","9","30","30","Anzia kyaali evio, waabasipikiziizie myaka ingi, Ni kubasoka na Mweo obe kupitila mu bakabika, Inzi tebaakunvwile, Ni pakako waabalekeleele mu maboko a bekala kyalo. ");
INSERT INTO tap_vpl VALUES ("NH9_31","017_9_31","NEH","9","31","31","Anzia kyaali evio, mu bwingi bwa nkumbu yobe, Tewaabaloviizie, ao kubalekelela, Pantu wewe uli Leza wa buwame ni wa nkumbu.” ");
INSERT INTO tap_vpl VALUES ("NH9_32","017_9_32","NEH","9","32","32","“Kansi evi we Leza wetu, Leza Mukulu ni wa buvinde, Leza wakutiinia, Leza aliwafikilizia kipingo kya ntono, Izukila lyemo lyaali pali fwefue Pamo ni makolo etu, ni bakulu betu, ni babitambua betu, pamo ni bakabika betu, Ni basiitue, pamo ni bantu bobe bonse, Lyemo litwaemene kutula pa musita wa makolo a ku Asuria mpaka lelo. ");
INSERT INTO tap_vpl VALUES ("NH9_33","017_9_33","NEH","9","33","33","Inzi wewe uli mulunghami mu milandu yonse yaatukitikiile, Pantu waakitile mu kisinka, anzia kine fwefue twaaluviizie. ");
INSERT INTO tap_vpl VALUES ("NH9_34","017_9_34","NEH","9","34","34","Makolo etu, ni banombozi betu, ni babitambua betu, ni babikolue betu Tebaanakiile mizilo yobe, Tebaatwiliziizie mizilo pamo ni milao yobe i waapingheene nabo. ");
INSERT INTO tap_vpl VALUES ("NH9_35","017_9_35","NEH","9","35","35","Anzia baali bali mu bukolo bwabo, Ni mu buwame bobe bukata buwaabapeele, mu kyalo kikata kilimo nfukeezi kiwabapeele, Tebaakubombeele, kabili tebaapilibukile kuti balekele bikitua byabo bibiipile. ");
INSERT INTO tap_vpl VALUES ("NH9_36","017_9_36","NEH","9","36","36","Mona fwefue lelo tuli bazia. Tuli bazia mu kyalo kiwaapeele babikolue betu, Momo mubaaliile mazabo pamo ni binge bintu biweme. ");
INSERT INTO tap_vpl VALUES ("NH9_37","017_9_37","NEH","9","37","37","Pa mulandu wa bibalo byetu, Bunonsi bwa keno kyalo bulibwaya ku bamakolo balibatuteeka. Balibatuteeka mubatoneene, ni nama yetu balibaikitila mubatoneene, Tuli mu lyemo likata.” ");
INSERT INTO tap_vpl VALUES ("NH9_38","017_9_38","NEH","9","38","38","Ni pa mulandu wa bebi bintu byonse, twakita kipingo kya kisinka ni kukilemba. Evi bakulu betu, ni Balawi, pamo ni babitambua betu, basyusyuta ni kusinsikapo kamanino kabo. ");
INSERT INTO tap_vpl VALUES ("NH10_1","017_10_1","NEH","10","1","1","Bantu baasyusyutilepo ni kusinsikapo kamanino ni baba: Ndabukizi Nehemia mwina Hakalia, ni Zedekia. ");
INSERT INTO tap_vpl VALUES ("NH10_2","017_10_2","NEH","10","2","2","Seraia, ni Azaria, ni Yeremia, ");
INSERT INTO tap_vpl VALUES ("NH10_3","017_10_3","NEH","10","3","3","ni Pasuri, ni Amaria, ni Malkia, ");
INSERT INTO tap_vpl VALUES ("NH10_4","017_10_4","NEH","10","4","4","ni Hatusi, ni Sebania, ni Maluku, ");
INSERT INTO tap_vpl VALUES ("NH10_5","017_10_5","NEH","10","5","5","ni Harimu, ni Meremoti, ni Obadia, ");
INSERT INTO tap_vpl VALUES ("NH10_6","017_10_6","NEH","10","6","6","ni Danieli, ni Ginetoni, ni Baruku, ");
INSERT INTO tap_vpl VALUES ("NH10_7","017_10_7","NEH","10","7","7","ni Mesulamu, ni Abia, ni Miyaminu, ");
INSERT INTO tap_vpl VALUES ("NH10_8","017_10_8","NEH","10","8","8","ni Maazia, ni Bilgai, ni Semaia. ");
INSERT INTO tap_vpl VALUES ("NH10_9","017_10_9","NEH","10","9","9","Yeshua mwina Azania, ni Binui wa mu baana bena Henadadi, ni Kadimieli, ");
INSERT INTO tap_vpl VALUES ("NH10_10","017_10_10","NEH","10","10","10","ni balupua babo ni baba: Sebania, ni Hodia, ni Kelita, ni Pelaia, ni Hanani, ");
INSERT INTO tap_vpl VALUES ("NH10_11","017_10_11","NEH","10","11","11","ni Mika, ni Rehobu, ni Hasabia, ");
INSERT INTO tap_vpl VALUES ("NH10_12","017_10_12","NEH","10","12","12","ni Zakuri, ni Serebia, ni Sebania, ");
INSERT INTO tap_vpl VALUES ("NH10_13","017_10_13","NEH","10","13","13","ni Hodia, ni Bani, ni Beninu. ");
INSERT INTO tap_vpl VALUES ("NH10_14","017_10_14","NEH","10","14","14","Parosi, ni Pahati-Moabu, ni Elamu, ni Zatu, ni Bani, ");
INSERT INTO tap_vpl VALUES ("NH10_15","017_10_15","NEH","10","15","15","ni Buni, ni Azgadi, ni Bebai, ");
INSERT INTO tap_vpl VALUES ("NH10_16","017_10_16","NEH","10","16","16","ni Adonia, ni Bigwai, ni Adini, ");
INSERT INTO tap_vpl VALUES ("NH10_17","017_10_17","NEH","10","17","17","ni Ateri, ni Hezekia, ni Azuri, ");
INSERT INTO tap_vpl VALUES ("NH10_18","017_10_18","NEH","10","18","18","ni Hodia, ni Hasumu, ni Bezai, ");
INSERT INTO tap_vpl VALUES ("NH10_19","017_10_19","NEH","10","19","19","ni Harifu, ni Anatoti, ni Nobai, ");
INSERT INTO tap_vpl VALUES ("NH10_20","017_10_20","NEH","10","20","20","ni Magipiasi, ni Mesulamu, ni Hesiri, ");
INSERT INTO tap_vpl VALUES ("NH10_21","017_10_21","NEH","10","21","21","ni Mesezabeli, ni Sadoki, ni Yadua, ");
INSERT INTO tap_vpl VALUES ("NH10_22","017_10_22","NEH","10","22","22","ni Pelatia, ni Hanani, ni Anaia, ");
INSERT INTO tap_vpl VALUES ("NH10_23","017_10_23","NEH","10","23","23","ni Hosea, ni Hanania, ni Hasubu, ");
INSERT INTO tap_vpl VALUES ("NH10_24","017_10_24","NEH","10","24","24","ni Halihesi, ni Pileha, ni Sobeki, ");
INSERT INTO tap_vpl VALUES ("NH10_25","017_10_25","NEH","10","25","25","ni Rehumu, ni Hasabuna, ni Maseia, ");
INSERT INTO tap_vpl VALUES ("NH10_26","017_10_26","NEH","10","26","26","ni Ahia, ni Hanani, ni Anani, ");
INSERT INTO tap_vpl VALUES ("NH10_27","017_10_27","NEH","10","27","27","ni Maluku, ni Harimu, ni Bana. ");
INSERT INTO tap_vpl VALUES ("NH10_28","017_10_28","NEH","10","28","28","Fwefue bonse, Baizraeli, babitambua ni Balawi, ni bakalinda ba pa mulyango, ni bakemba, ni babombi ba mu Nghanda yakua Leza, pamo ni bonse baali baikekele ku Bazima ba mu byalo pa mulandu wa mafunde akua Leza pamo ni bakazi babo, ni baana babo balalume ni banakazi, ni kubalua muntu waali ni buvinde bwa kunvua, ");
INSERT INTO tap_vpl VALUES ("NH10_29","017_10_29","NEH","10","29","29","Baba bonse ba-ampeene pamo ni Baizraeli nabo, ni masiiko abo, baikakile pamo mu kitiipu ni kilapo kya kukonka milao ibaapeelue na Leza kupitila muli Musa mubombi wakua Leza, pamo ni kunakila bwino mafunde ni milao ni myano yonse yakua Yawe Mulopue wetu. ");
INSERT INTO tap_vpl VALUES ("NH10_30","017_10_30","NEH","10","30","30","Kabili twaalapile nangue tekuti tukoofie baana betu ku Bazima bali mu kyalo, ni fwe tekuti tukalekelele baana betu kuupilako. ");
INSERT INTO tap_vpl VALUES ("NH10_31","017_10_31","NEH","10","31","31","Bazima ba mu kyalo kine baleeta makwebo, ao nghano kuti basisie busiku bwa Sabata, fwefue tetukasitako pa bobo busiku ao sie bunge busiku buzuuke, kubalua mwaka wa kilooba tetukalima makaba, ni mizia yonse yaakeeleelua. ");
INSERT INTO tap_vpl VALUES ("NH10_32","017_10_32","NEH","10","32","32","Kabili twaikitiile milao ya kupeela kimo kya bitatu bya shekeli mu bubombi bwa mu Nghanda yakua Leza wetu kubalua mwaka. ");
INSERT INTO tap_vpl VALUES ("NH10_33","017_10_33","NEH","10","33","33","Pa mikate ya kilangililo, ni pa ngelelo ya bunga ya lyonse, ni pa ngelelo ya kuziziiwa ya lyonse ya mu nsiku ya Sabata, ni mu nsikunkulu ya kubaluka kwa mwezi, ni nsikunkulu inge ilekenkeene, ni ya pa bintu bizuuke, ni ya pa ngelelo ya bibalo pa mulandu wakupwanika Baizraeli, ni pa miilo yonse ya mu Nghanda yakua Leza wetu. ");
INSERT INTO tap_vpl VALUES ("NH10_34","017_10_34","NEH","10","34","34","Fwe babitambua, ni Balawi, pamo ni bantu bonse twakiteya bubale, pa mulandu wa nkuni ya kuleetua mu Nghanda yakua Leza wetu, nga mukibeeleele mu nghanda ya basiitue, kuti iye yaleetua pa musita upalile, kubalua mwaka, evi iziziiwe pa bintamba byakua Yawe Leza wetu nga mukilembeelue mu mizilo. ");
INSERT INTO tap_vpl VALUES ("NH10_35","017_10_35","NEH","10","35","35","Kabili twaikitiile milao ya kupeela ntomono ya buzombozi bwa mazabo mu Nghanda yakua Yawe ni bwa mazabo onse a misango yonse ya bimuti kubalua mwaka. ");
INSERT INTO tap_vpl VALUES ("NH10_36","017_10_36","NEH","10","36","36","Kukonkana ni vikilembelue mu mizilo, kubalua libeli mwalalume wa muntu ni wa nama, apalile kutwalua mu Nghanda yakua Leza wetu ku babitambua baakaba babomba mu Nghanda yakua Leza wetu, ni kubalua libeli lyalalume lya kaana kena mbuzi ni kena mukooko. ");
INSERT INTO tap_vpl VALUES ("NH10_37","017_10_37","NEH","10","37","37","Kabili twaakaba twatwala bunga bwetu bwa buzombozi bwa mambo, ngelelo yetu ya mbezu, ni mazabo a misango yonse ya ku bimuti, ni ya bya kumina, ni ya mafuta ku babitambua mu miputule ya mu Nghanda yakua Leza wetu. Kabili twaakaba twatwala kamo ka pa lyanondo ka mu buzombozi bwetu ku Balawi, pantu Balawi i baali baya kukolonghania kamo ka pa lyanondo mu mizi yetu yonse. ");
INSERT INTO tap_vpl VALUES ("NH10_38","017_10_38","NEH","10","38","38","Kitambua wa mu luvyalo lwakua Haruni waakaba wali pamo ni Balawi musita ubaakaba baya kukolonghania kamo ka pa lyanondo. Balawi lubalibakolonghania kamo ka pa lyanondo, bapalile bafumia kamo ka pa lyanondo ka pa bebio ni kutwala mu Nghanda yakua Leza wetu mu miputule mu nghanda ya bukonto. ");
INSERT INTO tap_vpl VALUES ("NH10_39","017_10_39","NEH","10","39","39","Baizraeli ni Balawi bapalile kutwala ngelelo ya nghano, ni ya bya kumina, ni ya mafuta a mizeituni mu miputule mulimwasungua bibombelo bya mu kifuka kizuuke, momo mulimwaikala babitambua, ni bakalinda ba pa mulyango, pamo ni bakemba. Ni fwefue tetukasia Nghanda yakua Leza wetu. ");
INSERT INTO tap_vpl VALUES ("NH11_1","017_11_1","NEH","11","1","1","Pa kyamba, banombozi ba bantu baikeele mu Yeruzalemu. Bange bonse baateele bubale evi basaakulepo lupua lumo pa elia lyanondo lwa kuti luye lwikale mu Yeruzalemu muzi uzuuke, ni elia inge fundi ilikusyalapo, i ya kuya kwikala mu mizi inge. ");
INSERT INTO tap_vpl VALUES ("NH11_2","017_11_2","NEH","11","2","2","Bantu baapaalile balia bonse baipeele mu kutona kwabo kuya kwikala mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("NH11_3","017_11_3","NEH","11","3","3","Baba i bakulu ba biputu bya byalo baali baikeele mu Yeruzalemu, Baizraeli bamo, ni babitambua, ni Balawi, ni babombi ba mu Nghanda yakua Leza, pamo ni bena Solomoni baali baikeele mu Yudea kubalua muntu pa nkendo yakue mu mizi ilekenkeene. ");
INSERT INTO tap_vpl VALUES ("NH11_4","017_11_4","NEH","11","4","4","Inzi bange ba mu mukowa wakua Yuda ni ba mu mukowa wakua Benyamina baile kwikala mu Yeruzalemu. Ataia mwina Uzia, Uzia mwina Zakaria, Zakaria mwina Amaria, Amaria mwina Sefatia, Sefatia mwina Mahalaleli, Mahalaleli mwina Peresi. ");
INSERT INTO tap_vpl VALUES ("NH11_5","017_11_5","NEH","11","5","5","Peresi mwina Maseia, Maseia mwina Baruki, Baruki mwina Koli-Hose, Koli-Hose mwina Hazaia, Hazaia mwina Adaia, Adaia mwina Yoyaribu, Yoyaribu mwina Zakaria, Zakaria mwina Musiloni. ");
INSERT INTO tap_vpl VALUES ("NH11_6","017_11_6","NEH","11","6","6","Baana balalume bena Peresi baali baikeele mu Yeruzalemu, baali babipami 468. ");
INSERT INTO tap_vpl VALUES ("NH11_7","017_11_7","NEH","11","7","7","Salu mwina Mesulamu, Mesulamu mwina Yoedi, Yoedi mwina Pedaia, Pedaia mwina Kolaia, Kolaia mwina Maseia, Maseia mwina Itieli, Itieli mwina Yesaia. ");
INSERT INTO tap_vpl VALUES ("NH11_8","017_11_8","NEH","11","8","8","Ni pa kyamba kyakue kwaali, Gabai, ni Salai. Bonse pamo baali balalume 928. ");
INSERT INTO tap_vpl VALUES ("NH11_9","017_11_9","NEH","11","9","9","Ni Yoeli mwina Sikiri i waali kiloolo wabo, ni Yuda mwina Hesenua i waali kiloolo wa bubili mu muzi. ");
INSERT INTO tap_vpl VALUES ("NH11_10","017_11_10","NEH","11","10","10","Yedaia, mwina Yoyaribu, ni Yakini. ");
INSERT INTO tap_vpl VALUES ("NH11_11","017_11_11","NEH","11","11","11","Seraia mwina Hilkia, Hilkia mwina Mesulamu, Mesulamu mwina Sadoki, Sadoki mwina Merayoti, Merayoti mwina Ahitubu mukulu wa mu Nghanda yakua Leza, ");
INSERT INTO tap_vpl VALUES ("NH11_12","017_11_12","NEH","11","12","12","ni ba mu mukowa wabo baali babombela mu Nghanda yakua Leza baali bali balalume 822: Adaia mwina Yerobohamu, Yerobohamu mwina Pasuri, Pasuri mwina Malkia, ");
INSERT INTO tap_vpl VALUES ("NH11_13","017_11_13","NEH","11","13","13","ni ba mu mukowa wabo, ni masiiko a basibo, baali 242, ni Amasai mwina Azarieli, Azarieli mwina Azai, Azai mwina Mesilomoti, Mesilomoti mwina Imeri, ");
INSERT INTO tap_vpl VALUES ("NH11_14","017_11_14","NEH","11","14","14","ni babipami ba mu mukowa wabo bali ni buvinde, bonse pamo baali 128, ni mulombozi wabo waali Zabdieli mwina Hagedolimu. ");
INSERT INTO tap_vpl VALUES ("NH11_15","017_11_15","NEH","11","15","15","Semaia mwina Hasubu, Hasubu mwina Azirikamu, Azirikamu mwina Hasabia, Hasabia mwina Buni. ");
INSERT INTO tap_vpl VALUES ("NH11_16","017_11_16","NEH","11","16","16","Sebetai, ni Yozabadi, bakulu ba mu mukowa wa Balawi, i baali bakenteleele miilo ya panze pa Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("NH11_17","017_11_17","NEH","11","17","17","Ni Matania mwina Mika, Mika mwina Zabudi, Zabudi mwina Asafu, ozu i waali mulombozi wa nghimbo ya kutasia ni mapepo. Bakubukia i waali wa bubili mu ba kwakue. Abuda mwina Samua, Samua mwina Galali, Galali mwina Yedutuni. ");
INSERT INTO tap_vpl VALUES ("NH11_18","017_11_18","NEH","11","18","18","Balawi ba mu muzi uzuuke, bonse pamo baali 284. ");
INSERT INTO tap_vpl VALUES ("NH11_19","017_11_19","NEH","11","19","19","Akubu, Talmoni, ni ba kwabo. Bakalinda ba pa milyango bonse pamo baali balalume 172. ");
INSERT INTO tap_vpl VALUES ("NH11_20","017_11_20","NEH","11","20","20","Baizraeli bange, ni babitambua, ni Balawi, baali bali mu mizi yonse ya Yudea kubalua muntu mu nkendo yakue. ");
INSERT INTO tap_vpl VALUES ("NH11_21","017_11_21","NEH","11","21","21","Inzi babombi ba mu Nghanda yakua Leza baali baikeele mu Yeruzalemu ku kapili ka Ofeli balombwelue na Ziha, ni Gisipa. ");
INSERT INTO tap_vpl VALUES ("NH11_22","017_11_22","NEH","11","22","22","Kabili mwimanizi wa Balawi baali mu Yeruzalemu waali Uzi, mwina Bani, Bani mwina Hasabia, Hasabia mwina Matania, Matania mwina Mika, wa mu mukowa wakua Asafu. Ozu Uzi i waali mulombozi wa bakemba ba mu Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("NH11_23","017_11_23","NEH","11","23","23","Paali ni mizilo yaali yabiikilue na likolo ni milao ya kisinka yaali yabiikiilue bakemba, nga mwaali mwabeeleele miilo yabo ya kubalua busiku. ");
INSERT INTO tap_vpl VALUES ("NH11_24","017_11_24","NEH","11","24","24","Petahia mwana mwalalume mwina Mesezabeli, Mesezabeli mwina Zera, Zera mwina Yuda, i waali wakwasia likolo mu milandu yonse ya bantu. ");
INSERT INTO tap_vpl VALUES ("NH11_25","017_11_25","NEH","11","25","25","Bantu bamo basyaile kwikala mu Yeruzalemu, baikeele mu mizi ya mumbali, pepi ni makaba abo. Bangepo pa ba mu mukowa wakua Yuda baikeele ku Kiriati-Araba ni mu mizi ya mumbali, ni mu Diboni ni mu mizi ya mumbali, ni mu Yekabuseli ni mu mizi ya mumbali. ");
INSERT INTO tap_vpl VALUES ("NH11_26","017_11_26","NEH","11","26","26","Bange ni bo baikeele mu Yeshua, ni mu Molada, ni mu Beti-Peleti, ");
INSERT INTO tap_vpl VALUES ("NH11_27","017_11_27","NEH","11","27","27","ni mu Hazari-Suali, ni mu Beri-Seba pamo ni mu mizi ya mumbali. ");
INSERT INTO tap_vpl VALUES ("NH11_28","017_11_28","NEH","11","28","28","Bange ni bo baikeele mu Ziklagi, ni mu Mekoma, ni mu mizi ya mumbali. ");
INSERT INTO tap_vpl VALUES ("NH11_29","017_11_29","NEH","11","29","29","Bange ni bo baikeele mu Eni-Romoni, ni mu Zora, ni mu Yarmuti. ");
INSERT INTO tap_vpl VALUES ("NH11_30","017_11_30","NEH","11","30","30","Bange ni bo baikeele mu Zanoa, ni mu Adulamu, ni mu mizi yabo ya mumbali, Lakishi ni makaba a mumbali, Azeka ni mizi ya mumbali. I kulanda nangue Bayuda baikeele mu nkendo ili pa bukata bwa Berseba lya ku nkungulua ni mu lulambe lwa Hinomu lya ku kabanga. ");
INSERT INTO tap_vpl VALUES ("NH11_31","017_11_31","NEH","11","31","31","Ba mu mukowa wakua Benyamina baafumine ku Geba, baikeele ku Mikimasi, ni ku Aya, ni ku Beteli ni mu mizi ya mumbali. ");
INSERT INTO tap_vpl VALUES ("NH11_32","017_11_32","NEH","11","32","32","Bange baikeele ku Anatoti, ni ku Nobu, ni ku Anania, ");
INSERT INTO tap_vpl VALUES ("NH11_33","017_11_33","NEH","11","33","33","ni ku Hazori, ni ku Rama, ni ku Gitaimu, ");
INSERT INTO tap_vpl VALUES ("NH11_34","017_11_34","NEH","11","34","34","ni ku Hadidi, ni ku Zeboimu, ni ku Nebalati, ");
INSERT INTO tap_vpl VALUES ("NH11_35","017_11_35","NEH","11","35","35","ni ku Lodi ni ku Ono, ni mu lulambe momo mwaali mwaikala bantu bamanine kukita bintu bilekenkeene. ");
INSERT INTO tap_vpl VALUES ("NH11_36","017_11_36","NEH","11","36","36","Balawi bange bamo ba ku Yudea, baakuukile ni kuya kwikala pamo ni baana bena Benyamina. ");
INSERT INTO tap_vpl VALUES ("NH12_1","017_12_1","NEH","12","1","1","Babitambua ni Balawi balia baabwelele ni Zerubabeli mwina Shealtieli pamo ni Yoshua ni baba: Seraia, ni Yeremia, ni Ezra, ");
INSERT INTO tap_vpl VALUES ("NH12_2","017_12_2","NEH","12","2","2","ni Amaria, ni Maluku, ni Hatusi, ");
INSERT INTO tap_vpl VALUES ("NH12_3","017_12_3","NEH","12","3","3","ni Sekania, ni Rehumu, ni Meremoti, ");
INSERT INTO tap_vpl VALUES ("NH12_4","017_12_4","NEH","12","4","4","ni Ido-Ginetoni, ni Abia, ");
INSERT INTO tap_vpl VALUES ("NH12_5","017_12_5","NEH","12","5","5","ni Miyaminu, ni Moadia, ni Bilga, ");
INSERT INTO tap_vpl VALUES ("NH12_6","017_12_6","NEH","12","6","6","ni Semaia, ni Yoyaribu, ni Yedaia, ");
INSERT INTO tap_vpl VALUES ("NH12_7","017_12_7","NEH","12","7","7","ni Salu, ni Amoki, ni Hilkia, ni Yedaia. Baba i baali bakulu ba babitambua ni ba mikowa yabo pa musita wakua Yoshua. ");
INSERT INTO tap_vpl VALUES ("NH12_8","017_12_8","NEH","12","8","8","Yeshua, ni Binui, ni Kadimieli, ni Serebia, ni Yuda, ni Matania waali mulombozi wa nghimbo ya kutasia, wene pamo ni ba mu mukowa wakue. ");
INSERT INTO tap_vpl VALUES ("NH12_9","017_12_9","NEH","12","9","9","Bakubukia ni Uno, ni ba mu mikowa yabo, baali baimana bakenteene musita wa kulonghana. ");
INSERT INTO tap_vpl VALUES ("NH12_10","017_12_10","NEH","12","10","10","Yoshua waavyele Yoyakimu, Yoyakimu waavyele Eliasibu, Eliasibu waavyele Yoyada, ");
INSERT INTO tap_vpl VALUES ("NH12_11","017_12_11","NEH","12","11","11","Yoyada waavyele Yonatana, Yonatana waavyele Yadua. ");
INSERT INTO tap_vpl VALUES ("NH12_12","017_12_12","NEH","12","12","12","Yoyakimu lu-aali Kitambua Mukulu, babitambua baali bakulu ba mikowa ni baba: Meraia waali wa mu mukowa wakua Seraia, Hanania waali wa mu mukowa wakua Yeremia. ");
INSERT INTO tap_vpl VALUES ("NH12_13","017_12_13","NEH","12","13","13","Mesulamu waali wa mu mukowa wakua Ezra, Yehohanani waali wa mu lupua lwakua Amaria. ");
INSERT INTO tap_vpl VALUES ("NH12_14","017_12_14","NEH","12","14","14","Yonatana waali wa mu mukowa wakua Maluki, Yusufu waali wa mu mukowa wakua Sebania. ");
INSERT INTO tap_vpl VALUES ("NH12_15","017_12_15","NEH","12","15","15","Adina waali wa mu mukowa wakua Harimu, Helkai waali wa mu mukowa wakua Merayoti. ");
INSERT INTO tap_vpl VALUES ("NH12_16","017_12_16","NEH","12","16","16","Zakaria waali wa mu mukowa wakua Ido, Mesulamu waali wa mu mukowa wakua Ginetoni. ");
INSERT INTO tap_vpl VALUES ("NH12_17","017_12_17","NEH","12","17","17","Zikiri waali wa mu mukowa wakua Abia, Piltai waali wa mu mukowa wakua Miniaminu ni Moadia. ");
INSERT INTO tap_vpl VALUES ("NH12_18","017_12_18","NEH","12","18","18","Samua waali wa mu mukowa wakua Bilda, Yehonata waali wa mu mukowa wakua Semaia. ");
INSERT INTO tap_vpl VALUES ("NH12_19","017_12_19","NEH","12","19","19","Matenai waali wa mu mukowa wakua Yoyaribu, Uzi waali wa mu mukowa wakua Yedaia. ");
INSERT INTO tap_vpl VALUES ("NH12_20","017_12_20","NEH","12","20","20","Kalai waali wa mu mukowa wakua Salai, Eberi waali wa mu mukowa wakua Amoki. ");
INSERT INTO tap_vpl VALUES ("NH12_21","017_12_21","NEH","12","21","21","Hasabia waali wa mu mukowa wakua Hilkia, Netaneli waali wa mu mukowa wakua Yedaia. ");
INSERT INTO tap_vpl VALUES ("NH12_22","017_12_22","NEH","12","22","22","Balawi ba mu elia nsiku yakua Eliasibu meena abo ni aza: Yoyada ni Yehohanani, ni Yadua baalembelue kuba bakulu ba nghanda ya basibo pamo ni babitambua bakulu mpaka mu buteeko bwakua Dario wa ku Persia. ");
INSERT INTO tap_vpl VALUES ("NH12_23","017_12_23","NEH","12","23","23","Ni Bena Lawi, masiiko a mu nghanda ya basibo, baalembelue mu kitabu kya bintu byaali byakitika, mpaka mu nsiku yakua Yohana mwana mwalalume mwina Eliasibu. ");
INSERT INTO tap_vpl VALUES ("NH12_24","017_12_24","NEH","12","24","24","Bakulu ba Balawi, Hasabia, ni Serebia ni Yeshua mwina Kadimieli, baali baimana bakenteene ni Balawi nabo, baatantikilue kuti bembe nghimbo ya kulumba ni kusantila kukonkana ni mafunde akua likolo Daudi muntu wakua Leza. ");
INSERT INTO tap_vpl VALUES ("NH12_25","017_12_25","NEH","12","25","25","Matania, ni Bakubukia, ni Obadia, ni Mesulamu, ni Talmoni, pamo ni Akubu, i baali bakalinda ba pa mulyango, kabili i baali bakalinda ba nghanda ingi ya bukonto lya pa milyango. ");
INSERT INTO tap_vpl VALUES ("NH12_26","017_12_26","NEH","12","26","26","Babo i baaliko mu nsiku yakua Yoyakimu mwina Yoshua, Yoshua mwina Yozadaki, ni mu nsiku yakua ndabukizi Nehemia, ni yakua kitambua Ezra kasambilizia wa mizilo. ");
INSERT INTO tap_vpl VALUES ("NH12_27","017_12_27","NEH","12","27","27","Lubaazuukiizie kibumba kya Yeruzalemu baakebele Balawi mu nkendo yabo yonse, kuti beze bakite nsikunkulu ku Yeruzalemu basansamukile ni kutasia koku balimukwimba, balizia binsekelembue, ni binanda ni mazeeze. ");
INSERT INTO tap_vpl VALUES ("NH12_28","017_12_28","NEH","12","28","28","Bakemba ba mu lupua lwa Balawi baakolongheene kufuma mu byalo bizyungulukiile Yeruzalemu, ni kufuma mu mizi ya ba Netofati, ");
INSERT INTO tap_vpl VALUES ("NH12_29","017_12_29","NEH","12","29","29","ni kufuma ku Beti-Gilgali, ni kufuma ku makaba a Geba ni Azimaweti, pantu bakemba baali baikuuliile mizi yazyungulukiile Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("NH12_30","017_12_30","NEH","12","30","30","Babitambua ni Balawi baisambile, ni kwiswesia kukonkana ni mbeela, kabili baaswesiizie bantu ni milyango pamo ni kibumba. ");
INSERT INTO tap_vpl VALUES ("NH12_31","017_12_31","NEH","12","31","31","Na-anine banombozi ba Bayuda basele peulu kibumba. Naasaakwile mabumba abili akata a bakemba aali aimba nghimbo ya kutasia kuti akonkemo. Libumba limo lyaile lya ku kulio pa muulu kibumba lyalungi ku mulyango wa kizyalala. ");
INSERT INTO tap_vpl VALUES ("NH12_32","017_12_32","NEH","12","32","32","Babo bakemba baali baakonkelue na Hosaia, ni nsempu ya bakulu ba Bayuda, ");
INSERT INTO tap_vpl VALUES ("NH12_33","017_12_33","NEH","12","33","33","ni Azaria, ni Ezra, ni Mesulamu, ");
INSERT INTO tap_vpl VALUES ("NH12_34","017_12_34","NEH","12","34","34","ni Yuda, ni Benyamina, ni Semaia, ni Yeremia, ");
INSERT INTO tap_vpl VALUES ("NH12_35","017_12_35","NEH","12","35","35","ni baana bena babitambua baali batweme ntandala i Zakaria mwina Yonatana, ni Yonatana mwina Semaia, Semaia mwina Matani, Matani mwina Mikaia, Mikaia mwina Zakuri, Zakuri mwina Asafu. ");
INSERT INTO tap_vpl VALUES ("NH12_36","017_12_36","NEH","12","36","36","Bange ba mu mukowa wakue baakonkelepo ni baba: Semaia ni Azareli, ni Malalai, ni Gilalai, ni Maai, ni Netaneli, ni Yuda, ni Anani, baali balizia binanda byakua Daudi muntu wakua Leza, ni Ezra kasambilizia wa Mizilo waali wabatangiliile. ");
INSERT INTO tap_vpl VALUES ("NH12_37","017_12_37","NEH","12","37","37","Lubaafikile pa mulyango wa kasulo, baaselele mu biselelo bilungheeme ku muzi wakua Daudi, bapita nghanda ya bukolo yakua Daudi, ni kuya ku kyamba lya ku kibumba mpaka ku mulyango wa menda uli ku kabanga. ");
INSERT INTO tap_vpl VALUES ("NH12_38","017_12_38","NEH","12","38","38","Ni libumba lya bubili lya balia baali baimba nghimbo ya kusantila, baile lya kuso peulu kibumba, nene naakonkelemo nali pamo ni nsempu ya bantu. Twaile kupita lya pa lupungu lwa kikuka, mpaka kolia ku kibumba kikata, ");
INSERT INTO tap_vpl VALUES ("NH12_39","017_12_39","NEH","12","39","39","ni peulu mulyango wakua Efraimu, ni peulu mulyango wa kale, ni peulu mulyango wa masabi, ni peulu lupungu lwa ba Hananeli, ni lupungu lwa katua kamo, mpaka ku mulyango wa mikooko. Twaapeleeziizie lwendo lwetu ku mulyango wa bakalinda. ");
INSERT INTO tap_vpl VALUES ("NH12_40","017_12_40","NEH","12","40","40","Ni pakako, mabumba onse abili aali aimba asantila aimeene mu Nghanda yakua Leza pamo ni nene. Nene pamo ni nsempu ya bantu ba pa bakateeka. ");
INSERT INTO tap_vpl VALUES ("NH12_41","017_12_41","NEH","12","41","41","Babitambua baali balizia ntandala ni baba: Eliakimu Maseia, ni Miniaminu, ni Mikaia, ni Elioyoenai, ni Zakaria, ni Hanania, ");
INSERT INTO tap_vpl VALUES ("NH12_42","017_12_42","NEH","12","42","42","ni Misea ni Semaia, ni Eleazari, ni Uzi, ni Yehohanani, ni Malkia, ni Elamu, ni Ezeri. Bakemba baimbile basamwine pamo ni Yesiraia mulombozi wabo. ");
INSERT INTO tap_vpl VALUES ("NH12_43","017_12_43","NEH","12","43","43","Bobo busiku bantu baeleele ngelelo ingi basangaleele pantu Leza waabasansamusiizie na nsansa ikata. Banakazi pamo ni baana ni bo baasangaleele. Nsungu ya nsansa ya mu Yeruzalemu yaunvwikile kule. ");
INSERT INTO tap_vpl VALUES ("NH12_44","017_12_44","NEH","12","44","44","Pa ozo musita, baasaakwile bantu bakusunga milue, momo mwaali mwasungua bintu bya ngelelo palua Nghanda yakua Leza, buzombozi bwa ntomono, ni kamo ka pa lyanondo, bibaali bakolonghania kufuma mu makaba a mu mizi kuti biye byali bya babitambua pamo ni Balawi kukonkana ni mafunde, pantu Bayuda baawamiinue na babitambua pamo ni Balawi baali babomba. ");
INSERT INTO tap_vpl VALUES ("NH12_45","017_12_45","NEH","12","45","45","Baafikiliziizie miilo i baali babombela Leza wabo ni ya kuzuukia nga mwaakitiile bakemba ni bakalinda ba pa milyango, nga mubeeleele mafunde akua likolo Daudi ni akua Solomoni mwana wakue. ");
INSERT INTO tap_vpl VALUES ("NH12_46","017_12_46","NEH","12","46","46","Pantu kale, mu nsiku yakua Daudi ni Asafu, kwaali banombozi ba bakemba, kabili kwaali kwali nghimbo ya kulumba ni kutasia Leza. ");
INSERT INTO tap_vpl VALUES ("NH12_47","017_12_47","NEH","12","47","47","Kutula pa musita wakua Zerubabeli, ni Nehemia, Baizraeli bonse baafumiizie nsempu ya bupe bwa kubalua busiku pa mulandu wa bakemba ni bakalinda ba pa milyango, kabili Baizraeli baali bafumia ni inge nsempu pa mulandu wa Balawi, Balawi ni bo baali bafumia nsempu ya byabupe pa mulandu wa bantu ba luvyalo lwakua Haruni. ");
INSERT INTO tap_vpl VALUES ("NH13_1","017_13_1","NEH","13","1","1","Bobo busiku baabelengele kitabu kyakua Musa ni bantu batwiliziizie, mu kitabu baasangile mwalembelue nangue Ba-amoni ni Bamoabu tebapalile kwingila mu kulonghana kwa bantu bakua Leza, ");
INSERT INTO tap_vpl VALUES ("NH13_2","017_13_2","NEH","13","2","2","pantu tebaabapokeleele Baizraeli ni kubapeelako bilio ni menda, inzi baamulipile Balama kuti abatiipe, anzia kyaali evio, Leza wetu wa-alwile ntiipu yabo kuba mapaalo. ");
INSERT INTO tap_vpl VALUES ("NH13_3","017_13_3","NEH","13","3","3","Bantu lubaunvwile ezi mizilo, baafumiizie Bazima bonse mu Baizraeli. ");
INSERT INTO tap_vpl VALUES ("NH13_4","017_13_4","NEH","13","4","4","Ntanzi, kitambua Eliasibu waabiikilue pa mwilo wa kusunga milue ya mu Nghanda yakua Leza wetu. Ozu Eliasibu waali wa mu mukowa wakua Tobia, ");
INSERT INTO tap_vpl VALUES ("NH13_5","017_13_5","NEH","13","5","5","Kabili waali wamukitiile Tobia muputule ukata ubaali babiikamo kamo ka pa lyanondo ka bunga pa ozo musita, ni bubaani, ni bibombelo bya mu Nghanda yakua Leza, ni kamo ka pa lyanondo ka pa nghano, ni bupe bwa bya kumina, ni bwa mafuta, bintu byaali byafumiiwa na Baizraeli pa mulandu wa Balawi, ni bakemba, ni bakalinda ba pa milyango, pamo ni bupe bwa babitambua. ");
INSERT INTO tap_vpl VALUES ("NH13_6","017_13_6","NEH","13","6","6","Pa ozo musita onse waali wakitika bebio, ne nsyaali ku Yeruzalemu, pantu mu mwaka wa 32 mu kuteeka kwakua Artasasta likolo wa ku Babeli, naabwelele kuli likolo. Pa kyamba naalombele nsambu kuli likolo ");
INSERT INTO tap_vpl VALUES ("NH13_7","017_13_7","NEH","13","7","7","ni kubwelela ku Yeruzalemu. Koko i kunainikile bubi bwaakitile Eliasibu bwa kumupeela Tobia muputule mu misolo ya Nghanda yakua Leza. ");
INSERT INTO tap_vpl VALUES ("NH13_8","017_13_8","NEH","13","8","8","Naafiitilue sana. Ni pakako, naapoozele bintu byonse byakua Tobia panze pa ozo muputule. ");
INSERT INTO tap_vpl VALUES ("NH13_9","017_13_9","NEH","13","9","9","Pa kyamba naabiikile lifunde lya kuswesia miputule, kabili naabweziizie bibombelo bya mu Nghanda yakua Leza, pamo ni ngelelo ya nghano ni bubaani. ");
INSERT INTO tap_vpl VALUES ("NH13_10","017_13_10","NEH","13","10","10","Kabili naamwene nangue Balawi tebaali bapeelua kabili nsempu yabo. Ni pakako, Balawi ni bakemba baali babomba, baabutukile kubalua muntu waya ku kulima bukaba bwakue. ");
INSERT INTO tap_vpl VALUES ("NH13_11","017_13_11","NEH","13","11","11","Nene naasasiliile bakateeka nalanda nangue, “Ale Nghanda yakua Leza yasiiluaki?” Naabakolonghaniizie ni kubabwezia pa miilo yabo. ");
INSERT INTO tap_vpl VALUES ("NH13_12","017_13_12","NEH","13","12","12","Bayuda bonse baaleetele kamo ka pa lyanondo, ni bupe bwa nghano, ni bya kumina, ni mafuta mu mulue. ");
INSERT INTO tap_vpl VALUES ("NH13_13","017_13_13","NEH","13","13","13","Bantu banaasaakwile kuba bakalinda ba mulue ni baba: Kitambua Selemia, ni kalemba Sadoki, ni Mulawi Pedaia, Hanani mwina Zakuri, Zakuri mwina Matania i waali nkonkani wabo, pantu baba i baali bamwenue kuba ba kisinka, ni miilo yabo yaali ya u byabupe ku Balawi nabo. ");
INSERT INTO tap_vpl VALUES ("NH13_14","017_13_14","NEH","13","14","14","We Leza wane nanguluke pa ozu mulandu, kabili tekulaba bikitua byane biweme binaakitiile Nghanda yakua Leza wane ni miilo inaali nabombamo. ");
INSERT INTO tap_vpl VALUES ("NH13_15","017_13_15","NEH","13","15","15","Mu ezio nsiku naamwene Bayuda bange baali bafina bya kumina busiku bwa Sabata, ni bange baali batwama bitwamo, ni kutwika bapunda nghano, ni divai, ni mizabibu, ni tini, pamo ni misango yonse ya bitwamo bibaali batwala ku Yeruzalemu busiku bwa Sabata. Ni nene naabasokele nangue tebali na nsambu ya kusisia mu bobo busiku. ");
INSERT INTO tap_vpl VALUES ("NH13_16","017_13_16","NEH","13","16","16","Kabili ni balia baafumine ku Tiro bekeele mu Yeruzalemu baaleetele masabi, ni busulu bwa misango yonse balimukusisia ku Bayuda mu Yeruzalemu busiku bwa Sabata. ");
INSERT INTO tap_vpl VALUES ("NH13_17","017_13_17","NEH","13","17","17","Nene naasasiliile bakulu ba Bayuda nabaana nangue, “Ale bobu bubi bumulimukukita bwa kutiikaania busiku bwa Sabata ni bwa musangoki? ");
INSERT INTO tap_vpl VALUES ("NH13_18","017_13_18","NEH","13","18","18","Kubako basiinue tebaakitilepo bintu bya ozu musango pakuti Leza wetu aleete busanzo pali fwefue, ni pa ono muzi? Mone vimutwaliliile kuleeta bwavia pa Baizraeli pa mulandu wakutiikaania busiku bwa Sabata.” ");
INSERT INTO tap_vpl VALUES ("NH13_19","017_13_19","NEH","13","19","19","Ni musita wa kyungulo lupaali pasyafiita, naalandile kuti milyango ya Yeruzalemu iizalue ntanzi ya kutendeka busiku bwa Sabata, tekuti iizulue mpaka Sabata paikaba kupua. Naabiikile bange ba pa babombi bane mu milyango ni kubaana nangue mu muzi tekuti mwingiziwe makwebo a misango yonse busiku bwa Sabata. ");
INSERT INTO tap_vpl VALUES ("NH13_20","017_13_20","NEH","13","20","20","Ni pakako, basulu ni balibasita misango yonse ya bintu mu nsiku imo imo baali baaleele panze pa muzi. ");
INSERT INTO tap_vpl VALUES ("NH13_21","017_13_21","NEH","13","21","21","Naabasokele nangue, “Ale kimulimukulaalila panze pa muzi ni kiki? Kine mukabe kukita kabili evi vyenka, nakaba kumyuma.” Kutula papo tekuli muntu waabwelele kabili busiku bwa Sabata. ");
INSERT INTO tap_vpl VALUES ("NH13_22","017_13_22","NEH","13","22","22","Naabaanine Balawi beswesie ni kuya kulinda milyango pakuti busiku bwa Sabata buzuukiwe. We Leza wane nangulukeko palua ozu mulandu, kabili ungeleele kukonkana ni bwingi bwa ntono yobe. ");
INSERT INTO tap_vpl VALUES ("NH13_23","017_13_23","NEH","13","23","23","Mu ezio nsiku naamwene Bayuda baali baupile banakazi ba ku Ashdodi, ni ba ku Amoni, ni ba ku Moabu. ");
INSERT INTO tap_vpl VALUES ("NH13_24","017_13_24","NEH","13","24","24","Nsempu ya baana baavyelue na baba bantu, baali balanda lulimi lwa Ba-asidodi, ni ndimi ya bange bantu. Inzi tebaamanine kulanda lulimi lwa Kiyuda. ");
INSERT INTO tap_vpl VALUES ("NH13_25","017_13_25","NEH","13","25","25","Naabasasiliile ni kubatiipa, ni kunakulapo bamo pakati kabo, ni kubavukula misisi yabo, ni kubalapizia mu Liina lyakua Leza nangue, “Tekukoofie baana benu banakazi ku baana babo balalume, ni baana benu balalume tekuti bakoope baana babo banakazi, ni mwe benka tekuti mukakite evio. ");
INSERT INTO tap_vpl VALUES ("NH13_26","017_13_26","NEH","13","26","26","Eba, te byupo bya ozu musango byaamulengiizie Solomoni likolo wa Baizraeli kuti aluvie? Mu byalo byonse temwaali likolo nga wene, kabili waali watonenue na Leza wakue, ni Leza waamubiikile kuba likolo pa Baizraeli bonse. Anzia kyaali evio, banakazi baeni i baamulengiizie kuti aluvie. ");
INSERT INTO tap_vpl VALUES ("NH13_27","017_13_27","NEH","13","27","27","Ati emwe, i kulanda nangue mutonene fwefue tukonke mibeele yenu ni kukita bubi bukata bwa ozu musango, bwa kusinakila Leza wetu mu kuupa banakazi Bazima?” ");
INSERT INTO tap_vpl VALUES ("NH13_28","017_13_28","NEH","13","28","28","Umo wa mu baana bena Yoyada, mwinzikulu wakua Eliasibu Kitambua Mukulu, waali waupile mwana mwanakazi mwina Sanibalati wa mu muzi wa Beti-Horoni. Naamukumbile mu Yeruzalemu. ");
INSERT INTO tap_vpl VALUES ("NH13_29","017_13_29","NEH","13","29","29","We Leza wane, balangulukeko pantu bakitiikaania bukitambua ni kipingo kya bukitambua ni kya Balawi. ");
INSERT INTO tap_vpl VALUES ("NH13_30","017_13_30","NEH","13","30","30","Evi n'mbaswesiizie babitambua ni Balawi ku bintu byonse bifumine ku Bazima, ni kubapeela kubalua muntu mwilo wakue u-apalile kukita. ");
INSERT INTO tap_vpl VALUES ("NH13_31","017_13_31","NEH","13","31","31","Naabaanine kuleeta bupe bwa nkuni, ni buzombozi bwa ntomono pa musita upalile. We Leza wane nanguluke pa bebi byonse ni kunkitila biweme.");
INSERT INTO tap_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Ahasuero lu-aali likolo, waateekele biputu bya kyalo 127. Waateekele kutendekela ku India mpaka ku Kushi. ");
INSERT INTO tap_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Mu ezio nsiku, likolo Ahasuero waali waikeele mu Susani, muzi ukata wa kyalo. ");
INSERT INTO tap_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Mu mwaka wa butatu mu kuteeka kwakue, waakupile makolo akue onse pamo ni babombi, ni bakulu ba balukale ba ku Persia ni ku Media, ni bakindami pamo ni bandabukizi ba mu biputu bya kyalo kuti abatebete. ");
INSERT INTO tap_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Mu nsiku 180, waali wabalangisia bunonsi bwa mu bukolo bwakue pamo ni bulumba ni mukinzi wakue. ");
INSERT INTO tap_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Ni ezio nsiku luyaapwile, likolo waatebetele bantu bonse baali mu Susani, bakindami ni basikindeeme. Maliila akitile nsiku kilooba mu bukaba bwa ku kipango kyakua likolo. ");
INSERT INTO tap_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Bobo bukaba bwaali bwafwaniiziwe na bipempe bya ngubo ya mukumino wa sue ni wa lyulu, byaali byakakiilue na lozi lwa kitani kiweme kya mukumino wa bulumbi ni bikano bya fweta ku mapumpu a marimari. Paali ni bya kwikalapo bya oro ni bya fweta byaali byateekelue pansi paali pafwaniiziwe na mabue alekenkeene akindeeme. ");
INSERT INTO tap_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Baali babapeela bya kumina mu bipe bilekenkeene bya oro, kabili baali babapeela ni divai ingi ya bukolo kukonkana ni buntu bwakua likolo. ");
INSERT INTO tap_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Likolo waabapeele nsambu ya kumina kubalua muntu mu-aatoneene, kabili wa-anine babombi babapeele kubalua muntu belia bi-atonene kumina. ");
INSERT INTO tap_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Nabeeza Washti ni ye pa ozo musita, waali walimukutebeta banakazi nakue mu nghanda ya bukolo yakua Ahasuero. ");
INSERT INTO tap_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Busiku bwa kilooba, likolo lu-aasansamukile na divai, waakuutile Mehumani, Bizta, Harbona, Bigta, Abagta, Zetari ni Karkasi, babombi kilooba bamasai baali bamubombela ni kubaana nangue, ");
INSERT INTO tap_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","“Endo mumuleete nabeeza Washti kuli likolo, wavwele kiteebo kya bukolo, eze amulangisie ku bantu bonse kuwama kwakua nabeeza, pantu waali ni lukebu luweme.” ");
INSERT INTO tap_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Babombi baafikiizie mpunda yakua likolo kuli nabeeza, inzi wene waakeene kuya kuli likolo. Likolo waunvwile kipuki kikata. ");
INSERT INTO tap_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Ni pakako, likolo waakuutile bantu baali bamanine mizilo ni bupinguzi, bantu baali bamanine bintu bipalile kukitika pa milandu ya ozu musango pantu i yaali mibeele yakue. ");
INSERT INTO tap_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Ni meena abo ni aza: Karshena, Shetari, Admata, Tarshishi, Meresi, Marasena ni Memukani. Baba bakulu kilooba ba ku Persia ni ku Media, i baali babiloolo bakua likolo mu bukolo bwakue. ");
INSERT INTO tap_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Likolo waipuziizie nangue, “Kukonkana ni mizilo, tumukite syani nabeeza Washti wakikaana kunakila mwano wakua likolo Ahasuero u-akitwalilua na babombi?” ");
INSERT INTO tap_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Memukani wa-asukile ntanzi yakua likolo ni ntanzi ya babiloolo bakua likolo nangue, “Nabeeza Washti taluviizie sie kuli likolo bunke, inzi waluvia ku bakindami bonse, ni ku bantu bonse bekeele mu biputu bya kyalo bya mu kyalo kyakua likolo Ahasuero. ");
INSERT INTO tap_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Ozu mulandu wakita nabeeza, wakaba kumanika ku banakazi bonse ni bo tebakaba kuya bakindika balume babo pantu baakaba balanda nangue, ‘Nabeeza Washti lu-aakuutilue na likolo waakeene kuya.’ ");
INSERT INTO tap_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Ni evi vyenka ba muka bakulu ba ku Persia ni ku Media balia baunvua palua keki kyakita nabeeza, baakaba bakitila evio vyenka masiiko onse akua likolo. Ni mufupula wabo ku balume babo waakaba waleeta mazibo. ");
INSERT INTO tap_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Ni pakako, kine kuti likolo wawaminua, nalomba alembe muzilo usikazilulua ku Persia ni ku Media, ulandile nangue Washti tekuti abwelele kuli likolo Ahasuero, ni nsambu ya bunabeeza ipeelue unge mwanakazi awamiisie kukila wene. ");
INSERT INTO tap_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Ni ozu muzilo paukapundua mu bukolo bwakue bonse, kubalua mwanakazi muka mukindami ni muka asikindeeme waakaba wakindika mulume wakue.” ");
INSERT INTO tap_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Likolo pamo ni babiloolo, baawaamiinue na kako keebo. Kupwako, likolo wakita nga mwaalandiile Memukani. ");
INSERT INTO tap_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Ni pakako, mpapulo yaatwelue mu nkendo yonse ya bukolo bwakue, kubalua kiputu kya kyalo kyaalembeelue mubeeleele nembelo yabo, kubalua bantu baalembeelue mu lulimi lwabo. Lupapulo lwaali lwalandile nangue, “Kubalua mwalalume abe kateeka wa nghanda yakue.” Ozo muzilo waapundiilue kubalua muntu mu lulimi lwakue mwine. ");
INSERT INTO tap_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Pa kyamba, kipuki kyakua likolo Ahasuero lukyaapwile, waamulangulukile Washti, ni kulanguluka mulandu u-aakitile ni bupinguzi bu-aapingwilue. ");
INSERT INTO tap_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Kupwako, babombi bakua likolo balanda nangue, “Likolo akebelue babinundue baweme, ");
INSERT INTO tap_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","kabili likolo abiike bandabukizi mu biputu bya kyalo bya mu bukolo bwakue, evi bakolonghanie babinundue bonse baweme ni kubatwala ku Susani, muzi ukata wa kyalo mu nghanda ya banakazi, kuti basungue na Hegai lisai mubombi wakua likolo aliwasunga banakazi, kabili bapeelue ni bintu bya kwifwaniziiziako. ");
INSERT INTO tap_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Ni kinundue alikumuwamina likolo i alikwaluka nabeeza pa kifuka kyakua Washti.” Kako keebo kaamuwaamiine likolo, ni ye waakitile mubaamwaniine. ");
INSERT INTO tap_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Mu Susani, muzi ukata wa kyalo, mwaali ni Muyuda umo wa mu mukowa wakua Benyamina liina lyakue Mordekai mwina Yairi, Yairi mwina Simei, Simei mwina Kisi, ");
INSERT INTO tap_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Ozo waatwaminiinue mu bakakua bange kufuma ku Yeruzalemu pamo ni Yekonia likolo wa Bayuda, waatwemue na Nebukadneza likolo wa ku Babeli. ");
INSERT INTO tap_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Mordekai i waakuziizie Hadasa, aliwakuutua Esta, mwana mwina mwinzio ye, pantu nghina ni se baali basyafwile. Ni ye waali ni mibeele iweme ni lukebu luweme. Mordekai waamutweme Esta ni kumusunga nga mwana wakue. ");
INSERT INTO tap_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Kupwako, mizilo yakua likolo luyaapundilue, babinundue bengi baatwelue ku Susani, muzi ukata wa kyalo, kuti basungue na Hegai. Esta ni ye waingiziiziwe mu nghanda mwa Likolo asungue na Hegai waali wali mukulu wa nghanda ya banakazi. ");
INSERT INTO tap_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Hegai lu-aawamiinue na Esta, taakokwele kubamba kumupeela mafuta a kwifwaniziiziako ni bilio biwamiisie, kabili waamupeele ni babombi banakazi kilooba baafumine kuli likolo. Esta waakuusiiziiziwe pa inge nkendo iwamiisie mu nghanda ya banakazi pamo ni babombi bakue kilooba bakuti baye bamubombela. ");
INSERT INTO tap_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Inzi Esta taababwilile mutundu ni mukowa wakue pantu Mordekai waamukaaniizie. ");
INSERT INTO tap_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Kubalua busiku, Mordekai waali waienziizia pa musolo wa nghanda ya banakazi kuti amane vili Esta, ni kumana kilikumukitikila. ");
INSERT INTO tap_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Musita wa kwifwanizia babinundue waali wa myezi lyanondo ni ibili. Myezi mutanda yaali ya kwifwanizia na mafuta a manemane, ni myezi mutanda yaali ya kwifwanizia na mafuta a manukato pamo ni ange mafuta alekeneene a kwifwaniziiziako, ntanzi ya kutwalua kinundue umo umo kuli likolo Ahasuero. ");
INSERT INTO tap_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Pa kyamba, kusyali kubalua kinundue aye waya watweme kubalua kantu ka-atona kutwama mu nghanda ya banakazi, evi aye nako ku nghanda yakua likolo. ");
INSERT INTO tap_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Kubalua kinundue waali wapeelue nsambu ya kuya kwingila musita wa kyungulo, ni lukeelekeele kinundue waali wafuma ni kuya ku inge nghanda ya banakazi kuti aye asungue na Sasagazi lisai mubombi wakua likolo, musungi wa bakazi banike bakua likolo. Kinundue taali kabili na nsambu ya kwingila mu nghanda yakua likolo, inga sie kine likolo wamutonanga, mane akuutue. ");
INSERT INTO tap_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Lwaakumeene musita wa kwingila Esta mwina Abihaili mwinzio ye kwa Mordekai, ozo mukazyana Esta waasungilue na Mordekai nga mwana wakue, wene taalombele kange kantu inga sie belia bi-aateaniiziiziwe na Hegai lisai mubombi wakua likolo mukulu wa nghanda ya banakazi. Esta waamwenekele wafwaniine ku bonse baamumwene. ");
INSERT INTO tap_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Evi, Esta waatwelue kuli likolo Ahasuero mu nghanda ya bukolo mwezi wa lyanondo, i mwezi wa Tebeti, mwaka wa kilooba mu buteeko bwakue. ");
INSERT INTO tap_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Likolo waamutoneesie Esta kukila banakazi bonse, ni ye waitabiilue ni kupeelua buwame kukila babinundue bonse. Kupwako, wamuvwika kiteebo kya bukolo ku mutue wakue, wamwalula nabeeza pa kifuka kyakua Washti. ");
INSERT INTO tap_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Likolo waatebetele babiloolo ba mu bukolo bwakue pamo ni babombi bakue bonse, ni azo matebeto aali palwakua Esta. Waabaanine bantu ba mu biputu bya kyalo byonse batuuzie, kabili waabapeele ni bilambu mu aatoneene mu buntu bwakue bwa bulikolo. ");
INSERT INTO tap_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Babinundue lubaakolonghaniiziwe lya bubili, Mordekai waali waikeele pa nghingililo ya nghanda yakua likolo. ");
INSERT INTO tap_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Esta waali tanalande kantu palua mutundu ni mukowa wakue, nga mu-aalailue na Mordekai, pantu Esta waali wamunakiile Mordekai nga vi-aali wamunakila lu-aali wakisungilue. ");
INSERT INTO tap_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Pa ozo musita Mordekai lu-aali waikeele pa nghingililo ya nghanda yakua likolo, babilipo pa bamasai babombi bakua likolo, Bigtana ni Teresi, bakalinda ba pa mulyango, baafiitilue ni kutendeka kumukambila likolo Ahasuero kuti bamwipaye. ");
INSERT INTO tap_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Mordekai lu-aunvwile ozo mulandu, waamubwilileko nabeeza Esta, ni ye waatwele ezio mpunda kuli likolo nga mu-aabwiliilue na Mordekai. ");
INSERT INTO tap_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Lubaatoosiizie ozo mulandu ni kusanga nangue ni kisinka, balia bamasai babili baakulikilue ku kimuti. Keki kyaakitikile, kyaalembelue ntanzi yakua likolo mu kitabu kya bintu byaali byakitika. ");
INSERT INTO tap_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Pa kyamba kya bebi bintu, likolo Ahasuero waamupeele Hamani mwina Hamedata Muagagi, buvinde bwa pa muulu ni kumwalula mukulu wa babombi nakue. ");
INSERT INTO tap_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Babiloolo bonse bakua likolo baali pa musolo wa nghanda yakua likolo, baafwineeme ni kumukindika Hamani, pantu i mwaalandiile likolo, inzi Mordekai taafwineeme ni kumukindika. ");
INSERT INTO tap_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Babiloolo bakua likolo baali pa musolo wa nghanda yakua likolo, baamwipuziizie Mordekai, “Ale we uliwatyonenaki mizilo yakua likolo?” ");
INSERT INTO tap_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Kubalua busiku lubaali bamwana evio tekuba waunvua, baamubwilile Hamani, evi bamone kine mapange akua Mordekai alikutwalilila, pantu waali wabaana nangue wene ni Muyuda. ");
INSERT INTO tap_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Ni kiine Hamani lu-aamwene Mordekai tekuba wafwinama ni kumukindika, waunvwile kipuki kikata. ");
INSERT INTO tap_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Inzi taatonene sie kulovia Mordekai bunke, pantu waali wasyamanine mukowa wakua Mordekai. Ni pakako, Hamani waatonene kulovia Mordekai pamo ni Bayuda bonse baali baikeele mu bukolo bwakua likolo Ahasuero. ");
INSERT INTO tap_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Mu mwezi wa mambo, i mwezi wa Nisani, mwaka wa lyanondo ni ibili mu kuteeka kwakua likolo Ahasuero, kubalua busiku ni kubalua mwezi, baali bateyamo bubale ntanzi yakua Hamani mpaka mu mwezi wa lyanondo ni ibili, i mwezi wa Adari. ");
INSERT INTO tap_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Hamani waamwanine likolo Ahasuero nangue, “Kuli mukowa umo wa bantu basalanghaniine mu mikowa ya mu biputu bya kyalo bya mu bukolo bobe, bali ni mibeele yabo ilekenkeene ni mibeele ya kubalua mukowa, kabili baba bantu balimukukaana kunakila mizilo yakua likolo. Ni pakako, likolo tapalile kubonvwila nkumbu. ");
INSERT INTO tap_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Kine likolo wawaminua, kilembue nangue, ‘Baloviiwe.’ Ni babo baakabalovia naakabapeela talanta ya mutofue nfu lyanondo bakabiike mu kipao kyakua likolo.” ");
INSERT INTO tap_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Likolo i lu-aavuulile kazele ka kusyusyutilako ka ku munue wakue, ni kumupeela Hamani mwina Hamedata Muagagi, mulwani wa Bayuda. ");
INSERT INTO tap_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Kupwako, likolo wamwana Hamani nangue, “Sunga nfolanga yobe, kitila bantu bobe nga mu utoneene we mwine.” ");
INSERT INTO tap_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Pa kyamba kya nsiku lyanondo ni itatu ya mwezi wa mambo, bakalemba bakua likolo baakuutilue na Hamani. Waabanine balembe mpapulo ya kutwala ku ndabukizi ya biputu bya kyalo bya mu bukolo bwakua likolo Ahasuero, ni ku bange bakulu balekenkeene. Kubalua kiputu kya kyalo kyaalembeelue mubeeleele nembelo yabo, ni kubalua bantu baalembeelue mu lulimi lwabo. Kubalua lupapulo lwaasyusyutiluepo kazele kakua likolo Ahasuero. ");
INSERT INTO tap_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Mikenzi yaatwele mpapulo mu biputu bya kyalo byonse bya mu bukolo bwakua likolo Ahasuero, kuti babenoone Bayuda bonse, babepaye ni kubalovia, balumendo ni bakote, baana lukeke pamo ni banakazi pa busiku bumo, ni kubatwamina bunonsi bwabo bonse. Bobo bwaali busiku bwa lyanondo ni butatu mu mwezi wa lyanondo ni ibili, i mwezi wa Adari. ");
INSERT INTO tap_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Twebo twaali mu lwambu lwa mpapulo, twaali twaapalile kupundua kuba mizilo mu kubalua kiputu kya kyalo, evi bantu ba ntundu yonse babwilue kuti baye baiteaniizie pa bobo busiku. ");
INSERT INTO tap_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Mikenzi teyaakokwele kuya nga muya-aniinue na likolo. Mpunda yaatwelue mu Susani, muzi ukata wa kyalo. Likolo Ahasuero pamo ni Hamani baikeele ni kubamba kumina divai. Inzi muzi wa Susani waatoobokele. ");
INSERT INTO tap_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Mordekai lu-aunvwile byonse byaakitikile, waakaatile ngubo yakue, wavwala masaaka ni kwipuupa mito. Waabambile kupita mu muzi wa-angwile walimukulila na kikonko. ");
INSERT INTO tap_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Waile kufika mpaka pa mulyango wa nghanda yakua likolo, pantu muntu avwele maasaka taali waitabiziiziwe kwingila mwa likolo. ");
INSERT INTO tap_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Kubalua kiputu kya kyalo mwaatwelue mpunda ya mizilo yakua likolo, Bayuda baalimo baingiile mu malilo akata ni kuizilika bilio. Bengi pakati kabo baalosiizie ni kulila, baaleele pa masaaka baipuupile mito. ");
INSERT INTO tap_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Babombi banakazi ni balalume, bamasai bakua Esta, lubaile kumubwila Esta palwakua Mordekai, Esta waamunvwiliile nkumbu. Waabapeele ngubo bamutwalile Mordekai evi avuule masaaka, inzi wene waakeene. ");
INSERT INTO tap_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Kupwako, Esta wamukuuta Hataki umo wa pa babombi bamasai bakua likolo waali wamubombela Esta, wamutuma kuli Mordekai aye amwipuzie kine kuli bwaviaki, ni kilengiizie ni kiki. ");
INSERT INTO tap_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Ni Hataki waile kumonana ni Mordekai pa musolo wa muzi pa nghingililo ya nghanda yakua likolo. ");
INSERT INTO tap_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Mordekai waamwanine byonse byaamukitikiile, ni kipendo kya nfolanga yaalaile Hamani ya kubiika mu kipao kyakua likolo kuti Bayuda baloviiwe. ");
INSERT INTO tap_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Kabili waamupeele ni lwambu lwa mpapulo ya mizilo lulembeluepo mpunda ya kulovia Bayuda, ezio yaapundilue ku Susani, muzi ukata wa kyalo, evi aye amulange Esta, ni kumubwila bi ayanga kumona. Kabili amwane Esta aye kuli likolo apaapaatileko bantu bakue. ");
INSERT INTO tap_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Kupwako, Hataki waya kumwana Esta mwa-aninwanga na Mordekai. ");
INSERT INTO tap_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Kabili Esta waatumine Hataki aye amwane Mordekai nangue, ");
INSERT INTO tap_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Babiloolo bonse bakua likolo ni bantu bonse bekeele mu biputu bya kyalo bamanine nangue kukonkana ni mizilo, kubalua muntu, mwalalume ao mwanakazi waakengila mu musolo wa mukati wa nghanda yakua likolo tekuba wakuutilue, waakeepawa, inga sie olia waakoolwelua kabango ka oro, i waakasyala wakosele. Ni nene wenka nsisyapwile nsiku anondo atatu pasili kukuutuako.” ");
INSERT INTO tap_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Mordekai lu-aabwililue mpunda yakua Esta, ");
INSERT INTO tap_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","waabweziizie kapingu kuli Esta wamwana nangue, “Tekulangakana nangue we ulikupusuka pa Bayuda bonse pantu uli mu nghanda mwa likolo. ");
INSERT INTO tap_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Kine wewe teubalandiileko Bayuda pa ono musita, wakaba kuloba pamo ni lupua lwakua so, pantu tekuli amanine nangue pange i kyubeeleele nabeeza pa mulandu wa musita nga ono, inzi Bayuda bene kuti bapusuka mu nzila inge.” ");
INSERT INTO tap_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Hataki lu-aapwile kulanda na Esta, Esta ni ye waamubweziizie kuli Mordekai aye amwane nangue, ");
INSERT INTO tap_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Endo ukolonghanie Bayuda bonse bali ku Susani ni kubaana bezilike pa mulandu wane. Bezilike nsiku itatu busiku ni koba pasili kulia ni kumina, ni nene pamo ni babombi bane tulikuizilika evelia vyenka. Pa kyamba, mane ngie nghingile kuli likolo anzia kine nsipeelue nsambu, kine kufua, nfue.” ");
INSERT INTO tap_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Kupwako, Mordekai waya kukita nga mwa-aniinue na Esta. ");
INSERT INTO tap_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Pa kyamba kya nsiku itatu ya kuizilika, Esta waavwele ngubo yakue ya bukolo ni kuya kwimana pa musolo wa mukati wa nghanda yakua likolo wakentele lya ku nghanda yakua likolo. Likolo waali waikeele mu kitebe kyakue kya bukolo wakentele lya ku mulyango. ");
INSERT INTO tap_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Likolo lu-aamwene nabeeza Esta waimeene pa musolo, waawamiinue ni kumuolwela kabango ka oro kaali kali mu minue yakue. Kupwako, Esta wapalama ni kukumiako. ");
INSERT INTO tap_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Likolo waamwipuziizie nabeeza, “Ulimukukebaki? Utoneneki? Anzia kine ulikulomba nsempu ya bukolo bwane ndikukupeela.” ");
INSERT INTO tap_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Esta wa-asukile evi, “Kine likolo wawaminua, eze lelo pamo ni Hamani ku matebeto anamuteaniizyanga.” ");
INSERT INTO tap_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Likolo wa-anine babombi bakue nangue, “Endo mumwane Hamani alenge eze evi tukite nga mutoneene Esta. Ni kiine likolo pamo ni Hamani baile ku matebeto ateaniizie Esta.” ");
INSERT INTO tap_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Lubaali balimukumina divai, likolo waamwanine Esta, “Nghane ki-ulimukukeba, ni kyonse ki-ulikulomba, ndikukupeela. Anzia kine ni nsempu ya bukolo bwane ulikupeelua.” ");
INSERT INTO tap_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Esta waalandile evi, “Kandimukukeba ni kantonene kulomba ni kaka, ");
INSERT INTO tap_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","‘Kine ngitabilue na likolo, kabili kine awaminue kun'mpeela kandikulomba, ni kukita muntoneene, nalomba likolo pamo ni Hamani bakabe kwiza ku matebeto anakaba kubatebeta lukeele. Mane nkabe kumwana likolo kandimukukeba.’” ");
INSERT INTO tap_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Bobo busiku Hamani waafumine wawamiinue ni nsansa mu mutima. Inzi Hamani lu-aamwene Mordekai pa mulyango wa nghanda yakua likolo, waamufiitiilue pantu Mordekai taimeene ni kumufwinamina. ");
INSERT INTO tap_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Anzia kyaali evio, Hamani waasipikiziizie. Kupwako, waya ku nghanda yakue, ni kukuuta babibuza bakue pamo ni mukazi wakue Zereshi. ");
INSERT INTO tap_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Hamani waabambile kubetankila palua bulumba bwa bunonsi bwakue, ni bwingi bwa baana bakue, ni byonse bi-aakitiilue na likolo, pamo ni vi-a-alwilue mukulu pa bakindami ni pa babiloolo. ");
INSERT INTO tap_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Kabili Hamani waatwaliliile kulanda nangue, “Nabeeza Esta takikupa muntu unge wa kuya pamo ni likolo ku matebeto a-akiba wateaniizie, inga sie nene, evi ni lukeele nkupilue pamo ni likolo ku matebeto ange.” ");
INSERT INTO tap_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Hamani waalandile evi, “Anzia kili evio, nsizi kuwaminua lundinamona Mordekai Muyuda waikeele pa mulyango wa nghanda yakua likolo.” ");
INSERT INTO tap_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Zereshi mukazi wakue pamo ni babibuza bakue bonse baamwanine Hamani nangue, “Tuma bantu bateanie kimuti kileepele metre 25, ni lukeele lukeelekeele ukabe kumwana likolo nangue Mordekai akulikueko, evi ukaye wawamiinue pamo ni likolo ku matebeto.” Hamani waawamiinue na kako keebo, ni kutuma bantu bateanie kekio kimuti. ");
INSERT INTO tap_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Bobo busiku likolo taaonene tulo, wa-anine mubombi amuleetele kitabu kyaali kyalembeluemo bintu byaali byakitika pa musita wakuteeka kwakue, kuti bamubelengele. ");
INSERT INTO tap_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Lubaabelengelemo, kyaamwenekele nangue Mordekai i waasongeele bamasai, Bigtana ni Teresi, balia babombi babili ba pa mulyango wa nghanda yakua likolo baali bakambila kumwipaya likolo Ahasuero. ");
INSERT INTO tap_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Likolo waipuziizie babombi nangue, “Mordekai waapeelue mukinziki, ao kilambuki pa bebio bi-aakitile?” Babombi bakue ba-asukile nangue, “Tepali ka-akitiilue.” ");
INSERT INTO tap_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Likolo waipuziizie evi, “Papa pa musolo pali ni?” Ozo i musita waali waingila Hamani pa musolo wa nghanda yakua likolo kuti alanzyanie nakue evi bamukulike Mordekai ku kimuti ki-akiteania. ");
INSERT INTO tap_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Babombi bakue baamwasukile nangue, “Pali sie Hamani i emeene pa musolo.” Likolo waalandile evi, “Mwane engile.” ");
INSERT INTO tap_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Kupwako, Hamani waingila. Likolo waamwanine nangue, “Kuli ni muntu undimukukeba kukindika. Ndikumukitilaki?” Hamani waalandile mu mutima mwakue nangue, “Kubako kuli ni unge apalile kukindikua na likolo kukila nene?” ");
INSERT INTO tap_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Hamani wa-asukile evi, “We likolo, ozo muntu u ulimukukeba kukindika, ");
INSERT INTO tap_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","aleetelue ngubo ya bukolo yaali yavwaluako na likolo ni farasi waali waseluapo na likolo mwine, ni ozo farasi aye wavwikilue kiteebo kya bukolo ku mutue, ");
INSERT INTO tap_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","ni elia ngubo pamo ni olia farasi bipeelue umo akindamiisie pa babombi bakulu bakua likolo, kuti amuvwike olia muntu likolo u alimukukeba kukindika, kabili aseziiwe pa farasi ni kumupisia mu musebo ukata wa mu muzi walimukupunda ku ntanzi yakue nangue, ‘Evi, i vyakukitilua olia muntu likolo u akebele kukindika.’” ");
INSERT INTO tap_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Kupwako, likolo wamwana Hamani, “Ale lenga utwame ngubo pamo ni farasi nga muwalandila, umukitile Mordekai Muyuda ekeele pa mulyango wa nghanda yakua likolo pasili kusiapo ata kamo pa byonse biwalanda.” ");
INSERT INTO tap_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Hamani i lu-aabuulile ngubo pamo ni farasi, wamuvwika Mordekai elia ngubo, wamusezia pa farasi, ni kumupisia mu musebo ukata wa mu muzi walimukupunda ku ntanzi yakue nangue, “Evi i vyakukitilua olia muntu likolo u-atonene kukindika.” ");
INSERT INTO tap_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Kupwako, Mordekai wabwela pa mulyango wa nghanda yakua likolo. Inzi Hamani waile lubilo ku nghanda yakue waivimbiliile ku mutue walimukulila waunvwile bulanda ni busoni bukata. ");
INSERT INTO tap_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Hamani waamulondolweleele Zereshi mukazi wakue pamo ni benakue bonse palua bintu byonse byaamukitikiile. Kupwako, bantu bakue ba maano ni Zereshi mukazi wakue bamwana nangue, “Kine ozu Mordekai uwabamba kufwinamina ni wa mu mukowa wa Bayuda, kisinka we teukikamuvinda, inzi wene waakakulovia.” ");
INSERT INTO tap_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Ni musita u baali bakilanda sie nakue evio, babombi bamasai bakua likolo baiza, ni kulenga kumutwala Hamani ku matebeto ateaniiziwe na Esta. ");
INSERT INTO tap_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Kupwako, likolo ni Hamani baya kulia matebeto pamo ni nabeeza Esta. ");
INSERT INTO tap_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Lubaali balimukumina divai busiku bwa bubili, likolo waamwipuziizie kabili nabeeza Esta nangue, “Kiulimukulomba ni kiki? Nene ndikukupeela, Ni ki-ulimukukeba ni kiki? Nene ndikukupeela. Anzia kine ni nsempu ya bukolo bwane.” ");
INSERT INTO tap_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Nabeeza Esta waalandile nangue, “Kine ngitabilue na likolo, kabili kine awaminue kun'mpeela kandikulomba, nalomba n'mpususiiwe pamo ni bantu bane, ");
INSERT INTO tap_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","pantu nene pamo ni bantu bane tusisiiziwe kuti twinoonue, twipawe ni kuloviiwa. Kabenge nangue twakisisiiwa sie kuti tuye twali bazia, balalume ni banakazi, nga nakitalala sie. Pantu bwavia bwetu tebupalile kumwemia likolo.” ");
INSERT INTO tap_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Likolo Ahasuero waamwipuziizie nabeeza Esta nangue, “Ozo muntu aliwakambila kukita evio nani? Alipi?” ");
INSERT INTO tap_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Esta wa-asukile evi, “Muntu alimukutukyuzia, kabili mulwani wetu, i ozu Hamani, muntu akilile kubiipa.” Kupwako, Hamani wamukenta likolo ni nabeeza waunvwile mwezo ukata. ");
INSERT INTO tap_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Likolo waabuukile wafiitilue, wasia matebeto ni kuya mu bukaba bwa mu kipango. Inzi pantu Hamani wainikile nangue likolo wakeba kumwipaya, waasyele wamupaapaata nabeeza Esta amulandileko tekuti bamwipaye. ");
INSERT INTO tap_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Likolo lu-aabweleele ku nghanda ya matebeto, waamusangile Hamani waaponeene pansi walimukwivulunga lya palia paali paikeele Esta watambaleele. Likolo waalandile evi, “Ati emwe, ozu muntu alimukukeba kumubaka nabeeza pa ntanzi yane kono ku kipango?” Pa kyamba kya kako keebo kaalandile likolo, baamuvimbile Hamani pa menso. ");
INSERT INTO tap_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Harbona umo wa pa babombi bamasai bakua likolo waalandile evi, “Mu nghanda mwa Hamani muli ni kimuti kileepele metre 25 ki-akiteania kumukulikako Mordekai waalandile twebo twa kupususia likolo.” Likolo waalandile evi, “Mukulikeko ye mwine.” ");
INSERT INTO tap_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Penka papo bamukulika Hamani ku kimuti ki-akiteaniizia Mordekai. Kupwako, kipuki kyakua likolo kyatontoloka. ");
INSERT INTO tap_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Bobo bwenka busiku, likolo Ahasuero waamupeele nabeeza Esta bintu byonse byakua Hamani mulwani wa Bayuda. Mordekai ni ye waile kuli likolo pantu Esta waamubwilile nangue Mordekai ni muntu wakue. ");
INSERT INTO tap_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Likolo waavuulile kazele ka kusyusyutilako ka ku munue ka-aapokolwele kuli Hamani ni kumupeela Mordekai. Esta ni ye waamubiikile Mordekai kuba mukulu wa bintu byonse byaali byakua Hamani. ");
INSERT INTO tap_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Kabili Esta waapaapaatile kuli likolo, waponeene pa makasa akua likolo walimukulila walanda likolo afumiepo mapange abi akua Hamani Muagagi a kukambila Bayuda. ");
INSERT INTO tap_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Likolo waamuolweleele Esta kabango ka oro. Esta ni ye waabuukile ni kuya kwimana ntanzi yakua likolo ni kulanda nangue, ");
INSERT INTO tap_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","“Kine likolo wawaminua, ni ne kine naitabilua, ni keebo kine kamuwamina, kabili kine wan'mona napalile, kulembue muzilo wa kuzilula muzilo waalembelue na Hamani mwina Hamedata Muagagi, muzilo ulandile palua kulovia Bayuda bonse bali mu biputu bya kyalo bya mu kyalo kyakua likolo. ");
INSERT INTO tap_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Kubako kuti navinda kusipikizia kumona busanzo pa bantu bane? Kubako kuti navinda kusipikizia kumona lupua lwane palulimukuloviiwa?” ");
INSERT INTO tap_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Likolo Ahasuero wa-anine nabeeza Esta ni Mordekai Muyuda nangue, “Nene namupeela kale Esta bintu byonse byakua Hamani, ni ye wakulikua kale ku kimuti pantu wakikita mapange abi pa Bayuda.” ");
INSERT INTO tap_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Kansi mwemue benka lembele Bayuda byonse bimutonene mu liina lyakua likolo, musyusyutepo ni kazele ka ku munue kakua likolo, pantu malembo alembelue mu liina lyakua likolo, ni kusyusyutuapo kazele ka ku munue kakua likolo, tekuli wakuvinda kwalulula. ");
INSERT INTO tap_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Pa busiku bwa 23 mu mwezi wa butatu, i mwezi wa Siwani, bakalemba bakua likolo baakuutilue kuli Mordekai kuti balembele Bayuda ni ndabukizi ya biputu bya kyalo 127 kufuma ku India mpaka ku Kushi. Kubalua kiputu kya kyalo kyaalembeelue mubeeleele nembelo yabo, kubalua bantu baalembeelue mu lulimi lwabo. Bayuda ni bo baalembeelue mubeeleele nembelo yabo ni mu lulimi lwabo. ");
INSERT INTO tap_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Mordekai waalembele mu liina lyakua likolo Ahasuero ni kusyusyutapo kazele ka ku munue kakua likolo. Mpapulo yaatwelue mu biputu bya kyalo na baseli ba farasi yaali yaenda lubilo, farasi yaakuziiziwe kuti iye yabombiiwa na likolo. ");
INSERT INTO tap_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Mpapulo yakua likolo yaapeele nsambu Bayuda bali mu mizi yonse kuti baye bakolonghana ni kwikingilila. Baapeelue nsambu ya kwinoona ni kwipaya pamo ni kulovia kubalua mutundu ni kubalua kiputu kya kyalo kine kyabasakukila, bene ni bakazi babo pamo ni baana babo. Kabili baapeelue ni nsambu ya kutwama bintu bya balwani babo. ");
INSERT INTO tap_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Busiku bwaali bwatantikiilue Bayuda bwa kukita evio mu biputu bya kyalo monse na likolo Ahasuero, bwaali busiku bwa lyanondo ni itatu ya mwezi wa lyanondo ni ibili, i mwezi wa Adari. ");
INSERT INTO tap_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Lwambu lwa mpapulo ya mizilo ya kupundua mu biputu bya kyalo yaapundilue ku ntundu yonse, evi Bayuda ni bo baye baiteaniizie kukita kibwelezi ku balwani babo pa bobo busiku. ");
INSERT INTO tap_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Baseli ba farasi yaali yaenda lubilo, farasi yaali yabombiiwa na likolo, baakinkiziiziwe na likolo kuya kutwala mpunda mu Susani, muzi ukata wa kyalo. ");
INSERT INTO tap_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Mordekai waafumine kuli likolo wavwele ngubo ya bukolo ya mukumino wa lyulu ni wa sue, ni kiteebo kikata kya oro ni nkanzu ya kitani kiweme kya mukumino wa bulumbi. Ni Susani, muzi ukata wa kyalo, waabulwile tupundu twa nsansa, ");
INSERT INTO tap_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","pantu Bayuda bonse baawamiinue ni kupeelua mukinzi. ");
INSERT INTO tap_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Kubalua kiputu kya kyalo ni kubalua muzi waatweluemo mpapulo ya mizilo yakua likolo, Bayuda baalimo baawaamiinue, baakitile nsikunkulu ni kusangalala. Ntundu ingi yaialwile Bayuda pantu yaali yasyatiina Bayuda. ");
INSERT INTO tap_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Lwaakumeene busiku bwa lyanondo ni itatu ya mwezi wa lyanondo ni ibili, i mwezi wa Adari, busiku bwaali bwateaniiziwe kupundua ni kufikilizia mizilo yakua likolo, bobo busiku balwani ba Bayuda i bubaali baswapiile kwanzia Bayuda. Inzi bintu bya alulukile pantu Bayuda i ba-anziizie balwani babo. ");
INSERT INTO tap_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Bobo bwenka busiku, Bayuda baakolongheene mu mizi yabo ni mu biputu bya byalo byonse bya mu kyalo kyakua likolo Ahasuero kuti basakukile balwani babo baali bakeba kubalovia. Tekwaali muntu waabakaaniizie pantu bonse baatiinine. ");
INSERT INTO tap_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Ndabukizi yonse ya mu biputu bya kyalo pamo ni mikenzi yabo, ni bakwasi bakua likolo, baakwasiizie Bayuda pantu baali bamutiina Mordekai. ");
INSERT INTO tap_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Mordekai wa-alukile mukulu mu nghanda yakua likolo, ni bulumba bwakue bwaakumeene mu byalo byonse, pantu buvinde bwakue bwaali bwakililako sie. ");
INSERT INTO tap_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Ni pakako, Bayuda baumine balwani babo ni kubeepaya na bipanga. Balia baali babasuulile, Bayuda baabakitiile mubatoneene. ");
INSERT INTO tap_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Ni mu Susani, Bayuda baipailemo balalume 500. ");
INSERT INTO tap_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Pershandata, ni Dalfoni, ni Aspata, ");
INSERT INTO tap_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","ni Porata, ni Adalia, ni Aridata, ");
INSERT INTO tap_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","ni Parmashta, ni Arisai, ni Aridai pamo ni Waizata, ");
INSERT INTO tap_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","baana lyanondo bena Hamani mwina Hamedata mulwani wa Bayuda, ni bo baipailue. Inzi tebaatweme bintu bya balwani babo. ");
INSERT INTO tap_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Bobo bwenka busiku likolo waaleeteelue mpendua ya bantu baipailue mu Susani. ");
INSERT INTO tap_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Likolo waamwanine nabeeza Esta nangue, “Bayuda baipaya bantu 500 ni baana lyanondo bena Hamani mono mu Susani. Paliibufi mu binge biputu bya kyalo. Nghane kinge kiwakeba ukitilue. Nghane kiutonene kulomba upeelue.” ");
INSERT INTO tap_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Esta waalandile evi, “Kine likolo awaminue, nalomba Bayuda bali mu Susani bapeelue nsambu ya kuti lukeele bakabe kukita nga vibakita lelo. Balia baana lyanondo bafwile bena Hamani bakabe kukulikua ku bimuti.” ");
INSERT INTO tap_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Likolo waitabiizie kuti kikitue evio vyenka. Mpunda yaatwelue mu Susani, ni balia baana lyanondo bena Hamani baakulikilue. ");
INSERT INTO tap_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Kabili Bayuda baakolongheene busiku bwa lyanondo ni ina ya mwezi wa Adari ni kwipaya bantu 300 mu Susani, inzi tebaatweme bintu bya balwani babo. ");
INSERT INTO tap_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Ni Bayuda bange baali mu binge biputu bya kyalo baakolongheene kuti bekingilile ku balwani babo evi babe ni mutende. Baba ni bo baipaile bantu 75,000, inzi tebaatweme bintu bya balwani babo. ");
INSERT INTO tap_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Bobo bwaali busiku bwa lyanondo ni itatu ya mwezi wa Adari. Inzi busiku bwa lyanondo ni ina mu ozo wenka mwezi, baatuuziizie. Bobo busiku baabukitile kuba busiku bwa nsikunkulu ni bwa nsansa. ");
INSERT INTO tap_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Bayuda ba mu Susani ni bo baakolongheene busiku bwa lyanondo ni itatu, ni busiku bwa lyanondo ni ina. Inzi busiku bwa lyanondo ni isaano ya ozo wenka mwezi, baatuuziizie. Bobo busiku baabukitile kuba busiku bwa nsikunkulu ni bwa nsansa. ");
INSERT INTO tap_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Ni pakako, Bayuda ba mu mizi ni ba mu tutanda, bene baali batuuzia busiku bwa lyanondo ni ina ya mwezi wa Adari. Bobo busiku i bubaakitile kuba busiku bwa nsansa ni bwa kupeelana byabupe. ");
INSERT INTO tap_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Mordekai waalembele bintu byaakitikile, kabili waatumine mpapulo ku Bayuda bonse baali baikeele mu biputu bya kyalo bya mu kyalo kyakua likolo Ahasuero, Bayuda baali baikeele pepi ni baali baikeele kule, ");
INSERT INTO tap_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","kubakonkobezia kuti batwalilile kukita nsikunkulu kubalua mwaka pa busiku bwa lyanondo ni ina, ni pa busiku bwa lyanondo ni isaano ya mwezi wa Adari. ");
INSERT INTO tap_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Mu bobo busiku Bayuda i bubaakwatiilemo mutende ntanzi ya balwani babo, kabili i mwezi wa-alwiluemo bulanda bwabo kuba nsansa, ni kwalula malilo abo kuba nsikunkulu. Bwa-alukile busiku bwa kupeelana byabupe ni bya kulia pamo ni kukwasiako bapabi. ");
INSERT INTO tap_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Ni kiine Bayuda baitabiile kukita nga mubaatendekeele, ni muba-aniinue na Mordekai. ");
INSERT INTO tap_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Pantu Hamani mwina Hamedata Muagagi, mulwani wa Bayuda bonse, waali wakambila kubeepaya ni kubalovia, kabili baateele puri, i kuteya bubale, kuti abapue ni kubalovia. ");
INSERT INTO tap_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Inzi likolo lu-aabwililue, waapeene nsambu ya kulemba mpapulo ilandile nangue kukonkana ni mapange abi akua Hamani a kukambila kulovia Bayuda, ezio nkambilo imubwelelele ye mwine, ni baana bakue bakulikue ku bimuti. ");
INSERT INTO tap_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Ni pakako, bobo busiku bwa nsikunkulu baabwinikile Purimu bafumiizie ku liina lya puri. Kyaali pa mulandu wa lupapulo lwaalembele Mordekai, ni pa mulandu wa bintu bibaamwene, ni pa mulandu wa bintu byaabakitikiile. ");
INSERT INTO tap_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Bayuda, ni nvyalo yabo, pamo ni bonse bailundileko, ezio nsiku ibili ya nsikunkulu baisungile ni kwikita kuba mbeela yabo kubalua mwaka pa musita wakue pasili kulekela. ");
INSERT INTO tap_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Ezio nsikunkulu ipalile ikabe yalangulukua lyonse pasili kulekela. Nvyalo yonse, ni mikowa yonse ili mu biputu bya kyalo, ni ili mu mizi, bapalile kuya balanguluka lyonse bobo busiku bwa Purimu. ");
INSERT INTO tap_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Nabeeza Esta mwina Abihaili, pamo ni Mordekai Muyuda, baalembele bakonkobeziizie mu lolu lupapulo lwa bubili palua Purimu. ");
INSERT INTO tap_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Lupapulo lwaalembelue ni kutwalua ku Bayuda bonse mu biputu bya kyalo 127 bya mu bukolo bwakua likolo Ahasuero. Mu lupapulo mwaali twebo twa mutende ni twa kisinka, ");
INSERT INTO tap_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","pakuti bakonkobezie ezio nsiku ya Purimu pa musita wakue, nga mwaalandiile Mordekai Muyuda ni nabeeza Esta, kabili ni kubakonkobezia palua kuizilika ni kulila, bene pamo ni nvyalo yabo. ");
INSERT INTO tap_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Mwano wakua Esta waakilile kukonkobezia palua Purimu, ni kulembua mu kitabu kya bintu byaali byakitika. ");
INSERT INTO tap_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Likolo Ahasuero wa-anine bantu bonse ba mu bukolo bwakue basonke misonko, pamo ni ba mu bilila bya mumbali lyezi. ");
INSERT INTO tap_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Bikitua byonse byaakitile Mordekai ni buvinde bwakue bwa maka bu-aapeelue na likolo, tebyaalembelue mu kitabu kya lyasi lya makolo a ku Media ni ku Persia. ");
INSERT INTO tap_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mordekai Muyuda i waali wa bubili pali likolo Ahasuero, kabili i waali muntu aweme ku Bayuda. Bayuda ba mu mukowa wakue baali bakila kumukindika pantu waali wabakitila biweme ni kulanda nabo palua kwikala bwino.");
INSERT INTO tap_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Mapinda akua Solomoni likolo wa Baizraeli, mwana mwina Daudi. ");
INSERT INTO tap_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Aza mapinda i alialengia muntu kuba ni mulangue pamo ni masambilizio, ni kumana ndubulwilo ya mukati, ");
INSERT INTO tap_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Pamo ni kumusambilizia bikitua bya mulangue, ni bya bulunghami, ni bya nsambu pamo ni biweme. ");
INSERT INTO tap_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Kabili i aliapeela babipuba mulangue, ni kupeela balumendo maano ni bukengezi, ");
INSERT INTO tap_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Evi wa mulangue onvue ni kulundiluapo masambilizio, akile kuya wali ni mulangue pamo ni nsokezi iweme, ");
INSERT INTO tap_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","Pakuti enike mapinda pamo ni bipalo, ni kwinika bulanzi bwa balia bali ni mulangue pamo ni bitandiko byabo. ");
INSERT INTO tap_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Kumutiina Yawe i ntendeko ya maano, inzi babipuba balibafuupula mulangue ni masambilizio. ");
INSERT INTO tap_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","We mwana wane, unvua masambilizio akua so, kabili tekufuupula mafunde akua noko. ");
INSERT INTO tap_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Pantu alikuya ali ngala ya buwame ku mutue obe, kabili nga mikufu mu mukosi obe. ");
INSERT INTO tap_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","We mwana wane, kine wabembua na bantu ba bibalo, tekwitabila. ");
INSERT INTO tap_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","Kine balanda nangue, “Iza tuye nobe, tuye tufyaminepo muntu umo asili na mulandu ni kumwipaya, ");
INSERT INTO tap_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","Tuye tubateleke bakosele nga vilivyateleka kilibu, tubateleke balingi nga balia balibakookela mu kiina. ");
INSERT INTO tap_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","Tulikusanga bunonsi bonse bwa mponvu, tulikwizuzia nghanda yetu na bintu bitulikupoka. ");
INSERT INTO tap_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Ale iza wampane ni fwefue, byonse bitulikupoka tulikukasana.” ");
INSERT INTO tap_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","We mwana wane, tekuba waenda pamo nabo, kaania lukasa lobe tekuti luye lwapita molia mubalibapita. ");
INSERT INTO tap_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","Pantu makasa abo aliakundukila ku bubi, kabili tebezi kukokola kuzuumia mulopa. ");
INSERT INTO tap_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Pantu bukila bulibwateiwa tooni twamwene, bwa mpuni. ");
INSERT INTO tap_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Baba bantu balibabenza mulopa wabo bene, balibafyamina bukose bwabo bene. ");
INSERT INTO tap_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Evi i vili mibeele ya bantu balibatokamua bunonsi bwa bupompo, bupompo bulibwaputukizia bukose bwabo. ");
INSERT INTO tap_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Mulangue aliwasamuna mu kisaakaanino kya bantu, aliwasamuna lizui lyakue pa kisisiizio. ");
INSERT INTO tap_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","Aliwapunda mu mampetompeto, pa milyango ya kwingililamo mu muzi, aliwalanda. ");
INSERT INTO tap_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","“Mwe basili na maano! Mwaakaba mwatonenetonene sie kusiba na maano? Mwe ba mufuupula! Mwaakaba mwawamiinuewamiinue sie kufuupula? Mwe babipuba! Mwaakaba mwasuulilesuulile sie maano? ");
INSERT INTO tap_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Pilibuke pa mulandu wa nsokezi yane. Unvue, nene ndikumipongwela Mweo wane, ndikumibwila masambilizio ane. ");
INSERT INTO tap_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Inzi nakimikuuta, ni mwe mwakaana kwitaba, nakimyolwela kuboko kwane, temwakipoozako maano, ");
INSERT INTO tap_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Mwakipuulula nsokezi yane yonse, ni kukaana mwano wane, ");
INSERT INTO tap_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Ni nene wenka naakaseka pa musita wa busanzo bwenu, naakamipunika musita waakeeza maavia, ");
INSERT INTO tap_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","Lubebue palukamifikila nga mwela ukata, ni lwinoono palukamifikila nga mulula, ni pamukafikilua na busanzo ni misa. ");
INSERT INTO tap_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","“Pabakankuuta, nsikaba-asuka. Baakankeba inzi tebakan'mona. ");
INSERT INTO tap_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Pantu bakisuula maano, kabili pantu tebakisaakula kumutiina Yawe. ");
INSERT INTO tap_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Bakisuula nsokezi yane, bakifuupula mwano wane. ");
INSERT INTO tap_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Ni pakako, bakaba kuya balia mazabo a mu bikitua byabo, ni kwikuta nsokezi yabo bene. ");
INSERT INTO tap_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Pantu misango ibi ya bupuba yaakabeepaya, balia balibatwalilila mu bupuba, bwaakabeenoona. ");
INSERT INTO tap_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Inzi muntu aliwantwilizia wakaba kuya waikeele mu mutende, kabili wakaba kuya wateekameene pasili kutiina bibiipile.” ");
INSERT INTO tap_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","We mwana wane, kine waitabila twebo twane, ni kusunga bwino mafunde ane mukati mobe, ");
INSERT INTO tap_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","Pamo ni kuteya kutui kobe kuti kutwilizie mulangue, ni kunvwisia mu mutima obe, ");
INSERT INTO tap_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","Kisinka kine wamukuuta mulangue, ni kumana wamuzanzwila lizui, ");
INSERT INTO tap_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","Kabili kine wabakeba nga mutofue, ni kubakebelezia nga bukonto bufiikilue, ");
INSERT INTO tap_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","I paulikumana vya kumutiina Yawe, ni kwinika vya kumumana Leza. ");
INSERT INTO tap_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Pantu Yawe aliwapeela bantu mulangue, mu kanua kakue mulimwafuma bukengezi ni kumana. ");
INSERT INTO tap_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Aliwabiikila balunghami bukonto, wene i kisoolelo kya balia balibaenda mu kisinka. ");
INSERT INTO tap_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Aliwalabukila nghendelo ya bantu balibakita bintu bya nsambu, ni kusunga nzila ya bazuuke bakue. ");
INSERT INTO tap_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Kine wewe wantwilizia ulikwinika bulunghami ni nsambu pamo ni kisinka. Ulikwinika kubalua nzila iweme. ");
INSERT INTO tap_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Pantu mulangue alikwingila mu mutima obe, ni maano alikusansamusia bukose bobe. ");
INSERT INTO tap_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Kwinika kulikukusunga, ni kumana kulikukulabukila. ");
INSERT INTO tap_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","Mulangue alikukupususia mu nzila ya babi, ni ku bantu balibalanda twebo tubi. ");
INSERT INTO tap_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Bantu balibasia nzila ilungi pakuti bende mu nzila ya nfinzi, ");
INSERT INTO tap_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","Bantu balibawaminua kukita bibiipile, ni kusansamukila mu bupompo bwa bubi, ");
INSERT INTO tap_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Tusansaila twabo, ni twa mampetompeto, ni nzila yabo teyololokele. ");
INSERT INTO tap_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Mulangue alikukupususia ku mwanakazi mukambue, ku mwanakazi mweni ali ni twebo twa kubembia. ");
INSERT INTO tap_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","Mwanakazi aliwasia kibuza wa mu bukazyana bwakue, ni kulaba kipingo kyakua Leza wakue. ");
INSERT INTO tap_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","Kisinka nghanda yakue ilungi ku lufu, ni ku bafwile i kulungheeme nzila yakue. ");
INSERT INTO tap_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Bonse balibaya kuli wene, tepali aliwabwela, ao kubwelela ku nzila ya bukose. ");
INSERT INTO tap_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Ni pakako upalile kuya waendela mu nzila ya bantu baweme, ni kukonka mibeele ya balunghami. ");
INSERT INTO tap_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Pantu balunghami baakeekala mu kyalo, ni basili na kabi baakeekalililamo. ");
INSERT INTO tap_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Inzi babi baakafumiiwa mu kyalo, ni bankitatubi baakanukuluamo. ");
INSERT INTO tap_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","We mwana wane, tekuba walaba masambilizio ane, inzi sunga milao yane mu mutima obe. ");
INSERT INTO tap_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Pantu yakaba kuvuzia myaka ya bwikazi bobe, ni kukupeela mutende ni buyantanzi. ");
INSERT INTO tap_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Ntono ni bukisinka tekuti bilekenkane nobe, bikakilile mu mukosi obe, bilembe pa kibao kya mu mutima obe. ");
INSERT INTO tap_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Ni we ulikwitabilua ni kumonua waweme ku menso akua Leza ni ku menso a bantu. ");
INSERT INTO tap_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Muketekele Yawe na mutima obe onse, pasili kusintilila pa maano obe we mwine. ");
INSERT INTO tap_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Mu nzila yobe yonse, mumane wene, ni ye alikuolola nzila yobe. ");
INSERT INTO tap_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Tekwimona we mwine kuba wali ni mulangue, mutiine Yawe ni kwikeka ku bubi. ");
INSERT INTO tap_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Kukita evio kulikukuleetela bukose mu mubili, ni maka mu bikuza byobe. ");
INSERT INTO tap_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Mukindike Yawe na bunonsi bobe, mukindike na ntomono ya mu buzombozi bobe bonse. ");
INSERT INTO tap_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Ni pakako, milue yobe yaakeezula, ni mitondo yobe yaakeezulamo divai ya lenu. ");
INSERT INTO tap_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","We mwana wane, tekuleebula nsokezi yakua Yawe, kabili tekutoobolua lu-aliwakusasilila. ");
INSERT INTO tap_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Pantu muntu atonenue na Yawe aliwasokua, nga evelia mwana atonenue na se. ");
INSERT INTO tap_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Lisyuko ku mwalalume aliwasanga mulangue, ni aliwainika. ");
INSERT INTO tap_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Pantu mulangue akilile bunonsi bwa mutofue, ni kibwezia kyakue kitanine kukila kibwezia kya oro. ");
INSERT INTO tap_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Mulangue ni wa mponvu kukila mabue a mutengo, ni byonse biuliwakeba tebivinda kulinghaniwako. ");
INSERT INTO tap_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Nsiku ingi ili mu kuboko kwakue kwa kulio, ni mu kuboko kwakue kwa kuso i muli bunonsi ni mukinzi. ");
INSERT INTO tap_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Nzila yakue, i nzila ifwaniine, ni tusansaila twakue tulungi ku mutende. ");
INSERT INTO tap_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Mulangue i kimuti kya bukose ku balia bamukwatiisie, kabili i lisyuko ku onse atwaliliile kuba nakue. ");
INSERT INTO tap_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Kupitila mu mulangue, Yawe waabiikile biputa bya kyalo, ni mu kumana waimikile myulu. ");
INSERT INTO tap_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Mu kumana kwakue, biponga byaakasanikile, ni kulengia malezi kutoonia lume. ");
INSERT INTO tap_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","We mwana wane, tekulekeela mulangue ni maano kufuma pa ntanzi yobe, kwatisia maano aweme pamo ni bukengezi. ");
INSERT INTO tap_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Ni byo i bilikuya byali bukose bwa mutima obe, ni bifwanizio bya mu mukosi obe. ");
INSERT INTO tap_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Ni pakako, ulikuya wali ni mutende mu nzila yobe, ni kuulu kobe tekuya kwaipuutala. ");
INSERT INTO tap_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Musita uwalaala, teuya wali na mwezo. Ulikuona tulo twaweme. ");
INSERT INTO tap_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Tekuya wali na mwezo wa lwinoono lwa kukutulumukila, anzia kine kusanzua kwa babi kwaiza, ");
INSERT INTO tap_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","Pantu Yawe waya wali maswapi obe, ni ye waya wasungile kuulu kobe tekuti kukwatue mu muteo. ");
INSERT INTO tap_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Tekukaana kupeela kiweme ku bantu bapalile, lu-ukili ni maka a kukita evio. ");
INSERT INTO tap_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Tekumwana mwinobe nangue, “Endo, ukeeze lukeele mane nkakupeele” Koku kintu kya kumupeela wakwete. ");
INSERT INTO tap_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Tekukitila mwinobe mapange abi, olia ekeele waakuketekeele. ");
INSERT INTO tap_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Tekusongela muntu pasili mulandu, kine takitile kantu ka kukukisia. ");
INSERT INTO tap_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Tekumwena bunkua muntu aliwakyuzyania, ni pa nzila yakue tekusaakulapo ata imo. ");
INSERT INTO tap_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","Pantu Yawe asuulile muntu aliwakita bibiipile, inzi wene ni kibuza wa balia balibakita biweme. ");
INSERT INTO tap_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Ntiipu yakua Yawe ili mu nghanda mwa mubi, inzi Yawe aliwapaala nghanda ya mulunghami. ");
INSERT INTO tap_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Aliwafuupula balia bali ni mufuupula, inzi aliwapeela buwame ku bekeefiizie. ");
INSERT INTO tap_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Bali ni mulangue balibapyana bulumba, inzi babipuba balibamoniiwa busoni. ");
INSERT INTO tap_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Mwe baana bane, unvue mafunde akua sinue, kabili twilizie evi mube ni maano. ");
INSERT INTO tap_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Pantu ndimukumipeela mafunde aweme, tekuti mukasie masambilizio ane. ");
INSERT INTO tap_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Lunaali mwana mu nghanda yakua tawe, nakili kalala, mwana lyonga wakua yangu. ");
INSERT INTO tap_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","Tawe waali wansambilizia walanda nangue, “Mutima obe uye walanguluka twebo twane, sunga milao yane, ni we ulikuya wali mukose. ");
INSERT INTO tap_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Ba wali ni mulangue, ba wali ni kyunvwila tekulaba ao kukaana twebo twa mu kanua kane. ");
INSERT INTO tap_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Tekumusia mulangue, ni ye alikukulabukila, mutone, ni ye alikukusunga. ");
INSERT INTO tap_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Ntendeko ya mulangue ni ezi: Ba wali ni mulangue. Anzia uzeeziiziapo byonse bi-uli nabio, kya mponvu ba wali ni kyunvwila. ");
INSERT INTO tap_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Mukindike, ni ye alikukukindika. Kine wamukumbatila alikukukindika. ");
INSERT INTO tap_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Alikukupeela buwame kuba kitambala ku mutue obe, alikukufwanizia na ngala ya bulumba.” ");
INSERT INTO tap_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Twilizia we mwana wane, itabila bindimukulanda, ni myaka ya bukose bobe ilikuvula. ");
INSERT INTO tap_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Nakusambilizia nzila ya mulangue, nakulombola mu tusansaila twa bulunghami. ");
INSERT INTO tap_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Luuliwaenda, lutanfu lobe telukilinghaniiwa. Kine wakunduka tewipuutala. ");
INSERT INTO tap_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Kwatisia mafunde, pasili ku-aleka aye, akwatisia, pantu ene i bukose bobe. ");
INSERT INTO tap_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Tekwingila mu nzila ya babi, tekukonka mibeele ya bantu babi. ");
INSERT INTO tap_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Leya ezio nzila, kabili tekwendamo, isie uye mu nzila yobe. ");
INSERT INTO tap_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Pantu tebezi kulaala kine tebanakitenke bubi, ni tulo tetwizi kuoneka kine tebanapuutazie muntu. ");
INSERT INTO tap_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Pantu bubi i bilio byabo. Nghemo ikata i divai yabo. ");
INSERT INTO tap_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Nzila ya balunghami ili nga kisue kya ku makia, kilikyailundilako mpaka bwakiililila. ");
INSERT INTO tap_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Inzi nzila ya babi ili nga nfinzi ikata, ni kilikyabeepuutazia tebakimanine. ");
INSERT INTO tap_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","We mwana wane, pooza maano ku bindimukulanda, teya kutui ku twebo twane. ");
INSERT INTO tap_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Tekubifumia pa menso obe, bisunge bwino mu mutima obe. ");
INSERT INTO tap_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Pantu i bukose ku muntu aliwabisyukila. Kabili i kutuuka kwa mubili wakue onse. ");
INSERT INTO tap_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Sunga mutima obe kukila byonse biuliwasunga, pantu i mulimwafuma byonse bi-uliwakita. ");
INSERT INTO tap_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Sunga kanua kobe ku twebo twa bukisanguka, ni milomo ya kiitoni ibe kule ni wewe. ");
INSERT INTO tap_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Menso obe akente ku ntanzi, ni nkopio yobe pasili kukapa. ");
INSERT INTO tap_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Pooza maano mulimwapita makasa obe, ni nzila yobe yonse iwamiiwe bwino. ");
INSERT INTO tap_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Tekupilibukila kulio ao kuso, fumia kuulu kobe mu bubi. ");
INSERT INTO tap_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","We mwana wane, unvua mulangue wane, teya kutui ku twebo twa maano. ");
INSERT INTO tap_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Evi uye wavinda kwinika biweme, ni milomo yobe isunge maano. ");
INSERT INTO tap_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Pantu milomo ya mwanakazi mukambue, iliyatoonia kapelo, ni bulanzi bwakue buteleele kukila mafuta. ");
INSERT INTO tap_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","Inzi mpeleezio ya bulanzi bwakue ilulile kukila kimuti kiluliisie, ni kunooneka nga kipanga kya mindyakubili. ");
INSERT INTO tap_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Makasa akue alimukuya akookela ku lufu, ntanfu yakue ilungi kumbo. ");
INSERT INTO tap_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Kabili tasakameene nzila ya bukose. Nzila yakue ipotonkeene, kabili taimanine. ");
INSERT INTO tap_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Ni pakako, mwe baana bane ntwilizie, kabili tekufume mu bindimukulanda. ");
INSERT INTO tap_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Nzila yobe ilekenkane kule ni wene, kabili tekupalamina ku mulyango wa nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Ukeeza kupeela bange mukinzi obe, ni myaka yobe ku balia basili na nkumbu. ");
INSERT INTO tap_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Baeni bakeeza kwikusiiwa na maka obe, ni miilo yobe ikeeza kuya yali mu nghanda mwa mweni. ");
INSERT INTO tap_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Ku mpeleezio ya bukose bobe waakaloosia, musita waakeenoonua munofu ni mubili obe. ");
INSERT INTO tap_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Waakalanda nangue, “Ale naasuuliileki masambilizio? Ale naafuupwiliileki nsokezi? ");
INSERT INTO tap_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Nsyaanakiile bakasambilizia bane, ni kubatwilizia balia balibanfunda! ");
INSERT INTO tap_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Naali nasyaumiine kwingila mu bwavia bukata, mu libumba lya bantu bakua Leza.” ");
INSERT INTO tap_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Mina menda a mu nsupa yobe we mwine, menda aliapita lubilo kufuma mu kiina kyobe we mwine. ");
INSERT INTO tap_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Ale tusulo tobe twa menda tulikusalanghaninaki mu misebo? Ni twezi twa menda kuya kiyeyeye? ");
INSERT INTO tap_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Aye ali sie obe we bunke, pasili kupeelako baeni. ");
INSERT INTO tap_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Kasulo kobe kapaalue, kabili uwaminue na mukazi wa mu bulumendo bobe, ");
INSERT INTO tap_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Aweme nga nswala, ni kufwanina nga kasia, mabeele akue aye akuwamiine nsiku yonse, kabili uye wawamiinue nsiku yonse mu ntono yakue. ");
INSERT INTO tap_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Ale ni kiki kilikukulengia we mwana wane kuti uwaminue na muka nghwana? Ale ni kiki kilikukulengia kukumbatila nkulo ya mwanakazi mukambue? ");
INSERT INTO tap_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Pantu nzila yobe ili ku menso akua Yawe, ni ye aliwatoosia monse muuliwapita. ");
INSERT INTO tap_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Mubi aliwakwatua na bubi bwakue mwine. Ni ye aliwakakua na nkamba ya bibalo byakue. ");
INSERT INTO tap_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Aliwafua pa mulandu wakubula masambilizio, ni bupuba bwakue bukata bulibwamulovia. ");
INSERT INTO tap_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","We mwana wane, kine waipeele kulipa mizia ya mwino, kabili kine waalaile palwakua ozo muntu, ");
INSERT INTO tap_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","Kine uteelue na biuliwalanda, kabili kine ukwetue na twebo twa mu kanua kobe. ");
INSERT INTO tap_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","We mwana wane, pakuti wipususie, pantu waibiikile mu maboko a mwino, kita evi: Endo wikeefie ni kumupaapaata mwino. ");
INSERT INTO tap_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Tekulekeela menso obe kunvua tulo, ni nkopio yobe kuona. ");
INSERT INTO tap_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Iipususie nga kasia kapusuka mu minue ya mbwela, ao nga koni kapusuka mu minue ya mutei. ");
INSERT INTO tap_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Endo waya pa lupazi we munanghani, langakana nzila yakue ube ni mulangue. ");
INSERT INTO tap_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Lupazi teluli na kalombozi, na mukulu-ao na kateeka. ");
INSERT INTO tap_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","Inzi lulilwaibiikila bilio bya pa musita wa likungulu, kabili lulilwaikolonghaniizia bilio pa musita wa buzombozi. ");
INSERT INTO tap_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","We munanghani! Waya waleeleleele sie mpaka musitaki? Ulikubuuka musitaki mu tulo tobe? ");
INSERT INTO tap_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","Uliwalanda nangue, “Ndaalenkepo kaniini, nghonenkepo kaniini, nkunzenkepo kuboko kaniini ni kutuuzia.” ");
INSERT INTO tap_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","Ni evi bupabi bwakaba kukwizila nga kabooko, ni kubulua kwakaba kukukonka nga kipoopoosi ali ni kilwilo. ");
INSERT INTO tap_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Muntu mubi, muntu wa mpuni, aliwaendooka walimukulanda twebo twa bupompo. ");
INSERT INTO tap_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Aliwakapia na menso akue ni kusinia na makasa akue, aliwakita tulangi na minue yakue. ");
INSERT INTO tap_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Mu mutima mwakue muli bupompo, aliwalangakana bubi musita onse, ni kubyala mbezu ya bupusano. ");
INSERT INTO tap_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Ni pakako, bwavia bwaakamutulumukilila sie, waakatulumukililua ni kutyonua pasili kumona ntuukilo. ");
INSERT INTO tap_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Kuli bintu mutanda bisuulilue na Yawe, ee, bintu kilooba bilibyamukisia mutima. ");
INSERT INTO tap_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","Menso a kiitoni, lulimi lulilwalanda bufi, ni minue iliyazuumia mulopa usili na kafi, ");
INSERT INTO tap_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","Mutima uliwalangakana malanga abi, ni maulu angukile kubutukila ku bubi, ");
INSERT INTO tap_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","Musininkizi wa bufi aliwalanda bufi, ni olia aliwabyala mbezu ya mbiikizi mu lupua. ");
INSERT INTO tap_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","We mwana wane, konka milao yakua so, kabili tekuti ukabe kulekela masambilizio akua noko. ");
INSERT INTO tap_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Kakilila milao lyonse mu mutima obe, ivwale mu mukosi obe. ");
INSERT INTO tap_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Luuliwaenda, milao yaya yakulombwele, lu-uliwalaala yaya ya kusungile. Ni kukulanzia lu-uliwabuuka. ");
INSERT INTO tap_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Pantu ezi milao i musaniko, aza masambilizio i kisue, ni nsokezi ya masambilizio i nzila ya bukose. ");
INSERT INTO tap_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","I bya kukusunga ku mwanakazi mubi, ni ku lubembo lwa mwanakazi mukambue. ");
INSERT INTO tap_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Tekutokamua mu mutima obe na kuwama kwakue, kabili tekulekelela akubembe na nkopio ya menso akue. ");
INSERT INTO tap_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Pantu mwanakazi mukambue kuti waongua na mutengo wa kisoso kya mukate, inzi pa muka nghwana aliwazeeziiziapo bukose bwine bwine. ");
INSERT INTO tap_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Eba, kubako muntu kuti wabiika mulilo mu nkulo, ni bivwalo byakue pasili kuzia? ");
INSERT INTO tap_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Ao muntu kuti wanyanta lukasa pa mazekezeke a mulilo, ni makasa akue pasili kuzia? ");
INSERT INTO tap_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Evi i vili muntu aliwaingila kwa muka nghwana, kubalua muntu aliwamukumia takabula kukandua. ");
INSERT INTO tap_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Bantu tebezi kumufuupula kabooko kine waibila kwikuta pantu ali ni nzala. ");
INSERT INTO tap_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Inzi kine wakwatua, alikubweziiziamo nghendo kilooba, ni ye alikufumia bunonsi bonse bwa mu nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Inzi olia aliwakita bukambue na mwanakazi, tali na maano. Olia aliwatona kwinoona mutima wakue mwine, i aliwakita evio. ");
INSERT INTO tap_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Wene waakaaluka ni bilonda ni busoni, ni kulandilua bibiipile tekukapua. ");
INSERT INTO tap_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Pantu bunkua bulibwamuleetela mulume kipuki. Ni ye takaba na nkumbu busiku bwa kukita kibwelezi. ");
INSERT INTO tap_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Takeetabila nfuto ata imo, kabili takeetabila bituulilo anzia kine bikabe byavulile. ");
INSERT INTO tap_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","We mwana wane, sunga twebo twane, labukila milao yane mukati mobe. ");
INSERT INTO tap_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Konka milao yane ukabe ni bukose, ni kusunga mafunde ane nga kambooli ka mu linso lyobe. ");
INSERT INTO tap_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Kakila milao ku minue yobe, uilembe pa kibao kya mu mutima obe. ");
INSERT INTO tap_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Ana mulangue nangue, “Uli nkazyamwine,” ni kumwana kyunvwila nangue, “Uli lupua lwane.” ");
INSERT INTO tap_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","Evi bakusunge ku mwanakazi mukambue, ni ku kuleula ku muka nghwana aliwabembia na twebo twakue. ");
INSERT INTO tap_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Pantu pa nzota ya mu nghanda yane naakentele mu kisampi. ");
INSERT INTO tap_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","Naamwene pa babipuba, pa balumendo nainikilepo mulumendo asimanine kantu. ");
INSERT INTO tap_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","Mulumendo waali waya mu musebo ukata pepi ni lipeto, walungi ku nghanda kulikwaikala mwanakazi umo. ");
INSERT INTO tap_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","Koba kasyazimiine, musita wa kyungulo, pasyafiita, pa kamuntu uli ni. ");
INSERT INTO tap_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Kupwako, mwanakazi umo waya kusaakaana nakue, wavwele nga mukende ali ni mutima wa bupompo. ");
INSERT INTO tap_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Mwanakazi ali ni nsungu ni butaale, makasa akue tekuba azikia mu nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Unge musita aliwasangua mu nzila, ni unge musita mu misolo, ni mu mapeto walimukubenza. ");
INSERT INTO tap_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Kupwako, wamukumbatila mulumendo ni kumufyompa, ni kumwana pasili busoni. ");
INSERT INTO tap_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Ngelelo ya kyabupe kya mutende ndinayo ku nghanda. Lelo nafikilizia kilapo kyane. ");
INSERT INTO tap_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Ni pakako, i kinafuminanga kuti ngize nsaakaane nobe. Nakukebanga mpaka nakumona. ");
INSERT INTO tap_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Pa bulita bwane napanzikangapo ngubo, ngubo ya ku Misri ya mazela. ");
INSERT INTO tap_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Nafuuminizyanga manukato pa bulita bwane, ni bubaani, ni kizime pamo ni mudalasini. ");
INSERT INTO tap_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Iza twikute ntono mpaka lukeelekeele, tusansamusie mitima yetu na ntono. ");
INSERT INTO tap_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Pantu mulume wane ku nghanda taliko, aile mu bulendo lwa kule. ");
INSERT INTO tap_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Wakitwama ni mufuko wa nfolanga, wakaba kubwela sie kwezi wasyalingi.” ");
INSERT INTO tap_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Na twebo twakue tuweme aliwamubembia, aliwamwanzia na lubembo lwa kanua kakue. ");
INSERT INTO tap_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Ni penka papo aliwamukonka, nga nghombe ndume alimukuya ku kusinzua, ao nga kisongo kilimukwingila mu muteo. ");
INSERT INTO tap_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","Anzia muvui kine wamutunka ku maini, nga koni kabutukiile pa kakose, tavinda kumana nangue i busanzo bwa bukose bwakue. ");
INSERT INTO tap_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Ni pakako, we mwana wane ntwilizie, poozako maano ku bindimukukwana. ");
INSERT INTO tap_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Mutima obe tekuti upooze maano ku nzila yakue, ukeeza kuzeezelela mwaliwapita. ");
INSERT INTO tap_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Pantu tasyaipaile balalume bengi, balia ba-asyasinzile, ni bengi. ");
INSERT INTO tap_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Nghanda yakue i nzila ikata ya kumbo, ikookeele ku miputule ya lufu. ");
INSERT INTO tap_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Eba, mulangue tezi kulila? Kumana ni ye tezi kuzanzula lizui lyakue? ");
INSERT INTO tap_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Pa kifuka kya pa muulu sana pepi ni nzila, pa masanzyonzila i paimeene. ");
INSERT INTO tap_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","Mumbali mulyango wa kwingililapo mu muzi, pa nghingililo, aliwasamuna, ");
INSERT INTO tap_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“Mwe bantu, ndinamikuuta, ni lizui lyane ni pa mulandu wa bantu. ");
INSERT INTO tap_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Mwe basimanine kantu, be ni maano, ni mwe babipuba, be ni mutima wa kumana. ");
INSERT INTO tap_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Twilizie pantu ndi ni twa kulanda twa mponvu, ndikwizula milomo yane nande twebo tulungi. ");
INSERT INTO tap_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Kanua kane kalikulanda kisinka, pantu bubi kunvwika mu milomo yane ni kibalo. ");
INSERT INTO tap_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Twebo tonse twa mu kanua kane ni twa nsambu, tepali kalubile ao kabiipile pa tonse. ");
INSERT INTO tap_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Tonse tuli sie bwino ku olia amanine, tulungheeme ku balia bali ni maano. ");
INSERT INTO tap_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Saakula masambilizio ane kukila mutofue, ni kumana kukila oro isambikile. ");
INSERT INTO tap_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","Pantu mulangue i aweme kukila mabue a mutengo, ni bintu byonse bitonekele tebivinda kulinghaniwa nakue. ");
INSERT INTO tap_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","“Nene, ne mulangue, ngikeele pamo ni bukengezi, kwinika ni kumana ndi nabo. ");
INSERT INTO tap_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Kutiina Yawe, kusuula bubi. Nsuulile kiitoni, ni kwitasia, ni mibeele ibi, pamo ni bulanzi bubi. ");
INSERT INTO tap_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Nsokezi ni yane pamo ni bukengezi bwa kiine, kumana ni maka ndi nabio. ");
INSERT INTO tap_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Mubukwasi bwane, makolo aliateeka, ni kupingula mu nsambu. ");
INSERT INTO tap_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Mubukwasi bwane, bena makolo balibateeka, ni babiloolo balibalombola bwino pa kyalo. ");
INSERT INTO tap_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Ntonene balia bantonene, ni bonse balibankeba na mute, baliban'mona. ");
INSERT INTO tap_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Bunonsi ni mukinzi bili kuli nene, bunonsi bulibwalunduluka pamo ni nsambu. ");
INSERT INTO tap_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Mazabo ane akindeeme kukila oro, ni kibwezia kyane kikilile mutofue usambikile. ");
INSERT INTO tap_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Ndinaenda mu nzila ya bulunghami, mu tusansaila twa nsambu, ");
INSERT INTO tap_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","Ndinanonsia balia bantonene, ndinaizuzia kipao kyabo. ");
INSERT INTO tap_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“Yawe waanengele wa mambo mu miilo yakue, ntanzi ya miilo yakue ya kale. ");
INSERT INTO tap_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Nene kundi kutula ku mambo, kyalo lukyaali tekinabeko. ");
INSERT INTO tap_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Biponga lubyaali tebinabeko, naali nasyavyelue, tusulo twizwilemo menda lutwaali tetunabeko. ");
INSERT INTO tap_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Mpili luyaali teinabeko, ntanzi ya tupili naali nasyavyelue. ");
INSERT INTO tap_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Lu-aali tanalenge kyalo, ao makaba, ni ntendeko ya lufunko lwa mu kyalo. ");
INSERT INTO tap_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Naali nalipo lu-aali wabiika myulu, lu-aali wabiika mupaka wa lyulu ni menda. ");
INSERT INTO tap_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Lu-aali wabiika malezi a mu muulu, ni lu-aali walumia tusulo twa menda, ");
INSERT INTO tap_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Lu-aali wabiika mupaka wa lyezi, evi menda tekuti apule mafunde akue, ni lu-aakitile biputa bya kyalo. ");
INSERT INTO tap_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Naali pamo nakue nga kituemambo wa miilo. Naali nsansa yakue kubalua busiku. Naali ni nsansa kubalua busiku ku menso akue. ");
INSERT INTO tap_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Naali nasansamukila kyalo kikeeluemo na bantu, ni nsansa yane yaali yali pamo ni bena bantu. ");
INSERT INTO tap_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","“Ni pakako, ntwilizie mwe baana bane, pantu lisyuko lili na balia balibakonka nzila yane. ");
INSERT INTO tap_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Unvue masambilizio ane mube ni mulangue, kabili tekukaane. ");
INSERT INTO tap_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Lisyuko ku olia aliwantwilizia, aliwapempa kubalua busiku ku milyango yane, wapembeele mumbali milyango yane. ");
INSERT INTO tap_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Pantu olia wansanga, wasanga bukose ni kupokelela buwame kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","Inzi olia aliwa-andua kunsanga, aliwakisia mutima wakue mwine, balia bonse bansuulile, batonene lufu.” ");
INSERT INTO tap_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Mulangue waakuulile nghanda yakue, waabaazile mapumpu akue kilooba. ");
INSERT INTO tap_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Waipaile nama yakue ni kusanziamo divai yakue, waapanzikile ni meza yakue. ");
INSERT INTO tap_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Waatumine mubombi wakue mwanakazi, pa kifuka kya pa muulu wa muzi kuti akupe. ");
INSERT INTO tap_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“Kubalua kipuba eze engile,” ni olia asimanine kantu, aliwamwana nangue, ");
INSERT INTO tap_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Iza ulie bilio byane, ni kumina divai inakisanzia. ");
INSERT INTO tap_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Mwe babipuba, lekele bupuba mube ni bukose. Endele mu nzila ya kumana.” ");
INSERT INTO tap_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Aliwasoka wa kapuni aliwaileetelela kuleebulua. Ni aliwasasilila mubi aliwaileetelela matuka. ");
INSERT INTO tap_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Tekusasilila ali ni mufuupula pantu nga alikukukenda, sasilila wa mulangue, ni ye alikukutona. ");
INSERT INTO tap_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Sambilizia wa mulangue, ni ye alikulunduluka kuba ni mulangue. Sambilizia mulunghami, ni ye alikulunduluka kumana. ");
INSERT INTO tap_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Kumutiina Yawe, i ntendeko ya mulangue, ni kumumana Muzuuke, i kuba ni maano. ");
INSERT INTO tap_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Pantu kupitila mu mulangue nsiku yobe ilikuvuziiwa, ni myaka ya bwikazi bobe ilikulundua. ");
INSERT INTO tap_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Kine uli ni mulangue, mulangue obe we mwine. Kine uli wa kapuni, kwema ni kobe we mwine. ");
INSERT INTO tap_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Mwanakazi kipuba aliwasaamia, Tamanine kantu, kabili tali na busoni. ");
INSERT INTO tap_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Aliwaikala mu mulyango wa nghanda yakue, pa kifuka kya pa muulu wa muzi, ");
INSERT INTO tap_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","Walimukukuuta balia balibapita, balibapita mu nzila yakue, ");
INSERT INTO tap_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“Kubalua kipuba eze engile mono!” Ni olia asimanine kantu aliwamwana nangue, ");
INSERT INTO tap_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“Menda ebilue aweme, ni mukate uliwaliiwa mu kafiso uliwawaminina.” ");
INSERT INTO tap_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Inzi kipuba tamanine nangue momo i muli bafwile, ni baeni ba ozo mwanakazi nangue bali pansi kumbo. ");
INSERT INTO tap_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Aza i mapinda akua Solomoni: Mwana wa mulangue aliwasansamusia se, inzi kipuba, bulanda kuli nghina. ");
INSERT INTO tap_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Bukonto bulibwanonkelua mu bubi tebuli na kibwezia, inzi bulunghami bulibwapususyania ku lufu. ");
INSERT INTO tap_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Yawe tezi kulekelela mulunghami kwemiwa na nzala, inzi aliwabatana babi belia bibalibatokamua. ");
INSERT INTO tap_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Olia aliwabomba na kuboko kunangheene aliwaileetelela bupabi, inzi kuboko kwa olia alumine kulikwaleeta bunonsi. ");
INSERT INTO tap_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Olia aliwakolonghania musita wa kipua, i mwana ali ni mulangue, inzi olia aliwalaala musita wa kuzombola, i mwana aliwamoniania busoni. ");
INSERT INTO tap_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Mapaalo ali pa mutue wa mulunghami, inzi bupompo bukupiliile kanua ka mubi. ");
INSERT INTO tap_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Liina lya mulunghami lililyabombiiwa ku mapaalo, inzi liina lya mubi, lyaakabola. ");
INSERT INTO tap_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Wa mulangue aliwaitabila nsokezi, inzi kipuba wa bulanzi bwingi waakaloba. ");
INSERT INTO tap_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Olia aliwaenda mu bulunghami, aliwaenda pasili busanzo, inzi olia aliwamuzeeziizia nzila waakamanika. ");
INSERT INTO tap_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Olia aliwakapia na linso aliwaleeta bulanda, inzi aliwasokana mu kisinka aliwaleeta mutende. ");
INSERT INTO tap_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Kanua ka balunghami, i kasulo ka menda a bukose, inzi bupompo buli mu kanua ka mubi. ");
INSERT INTO tap_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Kukenda kulikwalengia bupusano, inzi ntono iliyavimba pa bubi bonse. ");
INSERT INTO tap_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Mulangue uliwasangua mu milomo ya muntu aliwainika, inzi nfimbo iliyaumua mu musana wa muntu asili na maano. ");
INSERT INTO tap_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Wa mulangue aliwabiika bukonto bwa bukengezi, inzi kanua ka kipuba, kalikapalamika lwinoono. ");
INSERT INTO tap_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Bunonsi bwa munonsi, i muzi wakue ulumine. Inzi lwinoono lwa bapabi i bupabi bwabo. ");
INSERT INTO tap_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Kilambu kya mulunghami kilikyaleeta bukose, Inzi bunonsi bwa mubi ni kibalo. ");
INSERT INTO tap_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Olia aliwaunvua lu-aliwasasililua, ali mu nzila ya bukose, Inzi olia aliwakaana nsokezi, aliwazeeza. ");
INSERT INTO tap_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Olia asuulile mwinakue mu kafiso wa bufi, ni olia aliwa-ambana, kipuba. ");
INSERT INTO tap_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Mu bwingi bwa twebo, temwapusa bubi, inzi aliwasunga milomo yakue, aliwabombia maano. ");
INSERT INTO tap_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Lulimi lwa mulunghami luli nga mutofue uwamiisie, mutima wa mubi ni wa mpuni. ");
INSERT INTO tap_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Milomo ya balunghami iliyaliisia bengi, inzi babipuba balibafua pa mulandu wa kusimana. ");
INSERT INTO tap_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Mapaalo akua Yawe alianonsyania, pasili kwemenapo. ");
INSERT INTO tap_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Kipuba kukita bubi, kuli nga musaapo, inzi muntu wa kyunvwila aliwawaminua na mulangue. ");
INSERT INTO tap_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Kilikyatiina mubi i kilikyamufikila, inzi balunghami balibapeelua kibalibakeba. ");
INSERT INTO tap_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Kine mulula wapita, babi balibazeeza, inzi mulunghami wene, kiputa kya muyayaya. ");
INSERT INTO tap_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Nga mpubili mu meno, ni byunsi mu menso, i vili munanghani ku balia balibamutuma. ");
INSERT INTO tap_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Kutiina Yawe kulikwalunda nsiku ya muntu, inzi myaka ya babi iliyakeefiiwa. ");
INSERT INTO tap_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Maswapi a balunghami ni nsansa, inzi kuketekela kwa babi kwa mpuni. ");
INSERT INTO tap_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Nzila yakua Yawe, i lusako lulumine ku mulunghami, inzi ni lwinoono ku bankitatubi. ");
INSERT INTO tap_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Balunghami tebakaloviiwa, inzi babi tebakeekala mu kyalo. ");
INSERT INTO tap_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Kanua ka balunghami kalikalanda bya mulangue, inzi lulimi lwa muntu wa kiitoni lwaakaloviiwa. ");
INSERT INTO tap_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Milomo ya balunghami imanine bilibyaitabiziiwa, inzi kanua ka mubi kalikalanda bibiipile. ");
INSERT INTO tap_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Kalingo ka bupompo, ni kilubo kuli Yawe, inzi bilemo bilingheene bilibyamuwamina. ");
INSERT INTO tap_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Lulilwaiza kiitoni, ni busoni i pabulibwaiza, inzi mulangue uliwaleeta kwikeefia. ");
INSERT INTO tap_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Bulunghami bwa balunghami bulibwabalombola, inzi kiitoni kya bapoti kilikyabalovia. ");
INSERT INTO tap_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Bunonsi tebuli na kibwezia busiku bwa kukandua, inzi bulunghami buli bwapususyania ku lufu. ");
INSERT INTO tap_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Bukisinka bwa mulunghami bulibwalundulula nzila yakue, inzi mubi aliwaponena mu bubi bwakue mwine. ");
INSERT INTO tap_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Bulunghami bwa balunghami bulibwabapususia, inzi balia balibakita bya bupompo balibakwatua mu bupompo bwabo. ");
INSERT INTO tap_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Mubi lu-aliwafua, maswapi akue aliazeeza, ni byonse bi-aketekeele mu maka akue bilibyapua. ");
INSERT INTO tap_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Mulunghami aliwapususiiwa mu maavia, inzi mubi aliwaingila mu maavia. ");
INSERT INTO tap_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Olia asiliwatiina Leza aliwainoona benakue na kanua kakue, inzi mu bukengezi balunghami balibapususiiwa. ");
INSERT INTO tap_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Balunghami lubalibanonka, muzi uliwawaminua, ni babi lubalibaloba, bantu balibabulula tupundu. ");
INSERT INTO tap_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Kupitila mu mapaalo a balunghami, muzi uliwalumbua, inzi uliwainoonua kupitila mu tunua twa babipuba. ");
INSERT INTO tap_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Olia aliwalandila mwinakue twebo twa mufuupula ni kipuba, inzi muntu wa maano aliwatalala. ");
INSERT INTO tap_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Olia aliwapitaana wa-ambana, aliwafyula tufiso, inzi aketekeelue aliwafiika milandu. ");
INSERT INTO tap_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Kyalo kisili na mulombozi wa mulangue kilikya-anziiwa, inzi kolia kuli bakasoka bengi, kuli mutende. ");
INSERT INTO tap_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Olia aliwaipeela kulipa mizia ya mweni, aliwaemenamo, inzi olia asiliwalaya kulipa mizia, ali ni mutende. ");
INSERT INTO tap_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Mwanakazi wa mukinzi, aliwakindikua lyonse, inzi bapompo balibapokolola bunonsi. ");
INSERT INTO tap_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Olia ali ni nkumbu, aliwakitila mutima wakue biweme, inzi asasile aliwaemia mubili wakue mwine. ");
INSERT INTO tap_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Mubi aliwasaziiwa nsazio ya bupompo, inzi olia aliwabyala bulunghami, ali ni kilambu kya kisinka. ");
INSERT INTO tap_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Olia aliwatwalilila mu bulunghami, ali ni bukose, inzi olia aliwakonkelela bubi, aliwafua. ");
INSERT INTO tap_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Yawe asuulile balia bali ni mutima wa kiitoni, inzi balia bapwililikile mu nzila yabo balibamuwamina. ");
INSERT INTO tap_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Kisinka mubi takabula kukandua, inzi balunghami baakapususiiwa. ");
INSERT INTO tap_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Nga vili kazele ka oro ku moona wa ngulube, i vili ni mwanakazi aweme asili na mulangue. ");
INSERT INTO tap_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Nkulu ya mulunghami iliyapeleela mu biweme, inzi maswapi a mubi, ni mu kukandua. ");
INSERT INTO tap_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Muntu aliwapeelapeela, aliwakila kunonka, inzi olia aliwakilikila bisilungheeme, aliwakila kuba mupabi. ");
INSERT INTO tap_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Muntu wa buntu aliwakitikilua na biweme, ni olia aliwapaana bya kumina ni ye aliwaminiiwa. ");
INSERT INTO tap_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Olia aliwatanana nghano, bantu balibamutiipa, inzi mapaalo ali pa mutue wakua olia aliwatona kusisia. ");
INSERT INTO tap_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Olia aliwakebesia kukita biweme, atonekele, inzi olia aliwakeba kukita bubi aliwabusanga. ");
INSERT INTO tap_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Olia aswapiile bunonsi bwakue, aliwapona, inzi mulunghami aliwalunduluka nga maani abisi. ");
INSERT INTO tap_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Olia aliwatuuta nghanda yakue, aliwapyana mwela. Ni kipuba alikuba muzia wa muntu wa mulangue. ");
INSERT INTO tap_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Mazabo a mulunghami, i kimuti kya bukose, ni olia aliwapususia bantu ali ni mulangue. ");
INSERT INTO tap_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Kine mulunghami aliwasaziiwa pa kyalo, paliibufi mubi pamo ni wa bibalo. ");
INSERT INTO tap_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Olia atonene masambilizio, atonene bukengezi, inzi olia asuulile kusasililua, ni kipuba. ");
INSERT INTO tap_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Muntu aweme aliwasanga buwame bwakua Yawe, inzi wa nsokezi ibi aliwapingulua na Yawe. ");
INSERT INTO tap_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Muntu tavinda kwileetela mutende na kukita bubi, inzi mulunghami takaponiwa na kantu. ");
INSERT INTO tap_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Mukazi aweme, i ngala ya mulume wakue, inzi olia aliwamoniania busoni, ali nga keesi kalikabunguzia bikuza bya mulume. ");
INSERT INTO tap_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Malanga a balunghami alungi, inzi nsokezi ya babi, ni bupompo. ");
INSERT INTO tap_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Twebo twa babi, tuli na mapange a kulovia, inzi kanua ka balunghami kalikabapususia. ");
INSERT INTO tap_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Babi balibainoonua ni kuloba, inzi nghanda ya balunghami iliyatwalilila. ");
INSERT INTO tap_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Muntu aliwatasiiwa kukonkana ni mulangue wakue, ni wa malanga abi aliwafuupulua. ");
INSERT INTO tap_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Muntu aliwafuupulua koku waali ni mubombi, aweme kukila muntu emwene kuba wali wa mponvu inzi tekuba wali na bilio. ");
INSERT INTO tap_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Mulunghami aliwasakamana bukose bwa nama yakue, inzi nkumbu ya babi, ni kwemia. ");
INSERT INTO tap_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Mulimi wa mute, ali na bilio bingi, inzi olia aliwakonka milandu ya mpuni, tali na maano. ");
INSERT INTO tap_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Mubi aliwatokamua bunonsi bwa mubi, inzi mulunghami aliwaimana sinta. ");
INSERT INTO tap_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Kilubo kya mu kanua, muteo wa muntu mubi, inzi mulunghami aliwafuma mu maavia. ");
INSERT INTO tap_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Muntu aliwaikusiiwa na buwame bwa mazabo a mu kanua kakue, aliwabweziiziwa bikitua bya minue yakue. ");
INSERT INTO tap_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Nzila ya kipuba iweme ku menso akue mwine, inzi mulunghami aliwatwilizia nsokezi. ");
INSERT INTO tap_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Bupuba bwa muntu asili na maano tebwakokola kumanika, inzi muntu akengeele aliwapuulula matuka. ");
INSERT INTO tap_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Olia aliwalanda kisinka, aliwasininkizia bya kiine, inzi musininkizi wa bufi, aliwalanda bufi. ");
INSERT INTO tap_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Twebo tubi tulitwakisia nga kipanga, inzi bulanzi bwa mulangue bulibwaleeta bukose. ");
INSERT INTO tap_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Bukisinka bulibwatwalilila lyonse, inzi bufi ni bwa pa musita uniini sie. ");
INSERT INTO tap_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Bupompo buli mu mutima wa balia balibalangakana bubi, inzi balia bali ni mapange a mutende, bali ni nsansa. ");
INSERT INTO tap_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Tekuli busanzo bulibwaponena balunghami, inzi babi balibavuziiziwa maavia. ");
INSERT INTO tap_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Kanua ka bufi, ni kilubo kuli Yawe, inzi balia balibakita bulunghami, i nsansa yakue. ");
INSERT INTO tap_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Muntu akengeele, aliwafiika maano akue, inzi babipuba balibamania bupuba bwabo. ");
INSERT INTO tap_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Kuboko kukinkimeene, i kulikwateeka, inzi bunanghani bulibwaleeta buzia. ");
INSERT INTO tap_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Kutooboka kwa mutima kulikwapwisia nsansa, inzi keebo kaweme kalikasansamusia. ");
INSERT INTO tap_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Mulunghami aliwalanga nzila ku mwinakue, inzi nzila ya babi iliyabazeezia. ");
INSERT INTO tap_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Mukumbi munanghani tezi kusanga mabingo akue, inzi wa mute tezi kubwela tonte. ");
INSERT INTO tap_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Mu nzila ya bulunghami i muli bukose, ni mu tusansaila twakue temuli lufu. ");
INSERT INTO tap_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Mwana wa mulangue aliwatwilizia mafunde akua se, inzi wa kapuni, tezi kutwilizia nsokezi. ");
INSERT INTO tap_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Muntu aliwaikusiiwa na buwame bwa mazabo a mu kanua kakue, inzi mutima wa muntu mubi uliwalia bubi. ");
INSERT INTO tap_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Olia aliwalabukila kanua kakue, aliwasunga bukose bwakue, inzi olia aliwaizula milomo yakue ali ni bwavia. ");
INSERT INTO tap_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Mutima wa munanghani uliwatokamua pasili kusanga kantu, inzi mutima wa olia akinkimeene, uliwaikuta. ");
INSERT INTO tap_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Mulunghami tezi kutona kulanda bufi, inzi muntu mubi aliwakila kuluvia, ni ye aliwamoniiwa busoni. ");
INSERT INTO tap_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Bulunghami bulibwasunga mulunghami mu nzila yakue, inzi bubi bulibwalovia wa bibalo. ");
INSERT INTO tap_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Kuli ni olia aliwailanga kuba munonsi, inzi tekuba wali na kantu. Kuli ni olia aliwailanga kuba mupabi, inzi wali ni bunonsi bwingi. ");
INSERT INTO tap_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Bunonsi bwa muntu i bulibwamulubula, inzi mupabi tali na ka kumupususia. ");
INSERT INTO tap_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Kisue kya mulunghami kilikyabenghemesia, inzi musaniko wa mubi uliwazima. ");
INSERT INTO tap_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Kiitoni, kilikyaleeta mazibo, inzi mulangue, uli na balia balibaunvua nsokezi. ");
INSERT INTO tap_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Bunonsi bwa lubilo lubilo bulibwakeepa, inzi olia aliwanonka bukebuke, aliwavuzia. ");
INSERT INTO tap_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Maswapi aliakokola, aliakisia mutima, inzi kelia kintu kipembeelue kine kyafika, ni kimuti kya bukose. ");
INSERT INTO tap_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Olia aliwafuupula mafunde, aliwaileetela lwinoono, inzi olia aliwanakila milao, aliwalambulua. ");
INSERT INTO tap_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Masambilizio a muntu wa mulangue, i kasulo ka bukose, aliamulengia kuleuka miteo ya lufu. ");
INSERT INTO tap_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Maano aweme alialengia kutoneka, inzi nzila ya bapompo ya maavia. ");
INSERT INTO tap_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Kubalua muntu wa maano aliwabomba wakengeele, inzi kipuba aliwasalanghania bupuba bwakue. ");
INSERT INTO tap_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Mukenzi mubi aliwaponiizia bantu mu maavia, inzi mukenzi wa kisinka, aliwaleeta bukose. ");
INSERT INTO tap_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Bupabi pamo ni busoni, bili na olia aliwakaana masambilizio, inzi olia aliwakonka nsokezi, aliwakindikua. ");
INSERT INTO tap_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Kine kelia kintu kitonekele kyakitika, muntu aliwawaminua, inzi babipuba kwikeka ku bubi, kilubo. ");
INSERT INTO tap_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Enda na ba mulangue, ni we uli kuba ni mulangue, inzi kibuza wa babipuba aliwaema. ");
INSERT INTO tap_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Bwavia bulibwakonka ba bibalo, inzi mulunghami aliwalambulua buwame. ");
INSERT INTO tap_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Muntu aweme aliwasia bupyani ku benzikulu, ni bunonsi bwa muntu wa bibalo, bukonto bwa mulunghami. ");
INSERT INTO tap_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Bukaba bwa mupabi kuti bwafumia buzombozi bwingi, inzi bilibyainoonua pa mulandu wa kubiibikiziiwa. ");
INSERT INTO tap_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Muntu asiizi kubombia nfimbo, akendele mwana wakue, inzi olia amutonene, aliwamukanda pa musita upalile. ");
INSERT INTO tap_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Mulunghami ali ni bilio byamukumeene, inzi kavumo ka mubi kalikaemooka na nzala. ");
INSERT INTO tap_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Mwanakazi wa mulangue aliwakuula nghanda yakue, inzi kipuba aliwatuuta nghanda yakue na minue yakue. ");
INSERT INTO tap_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Olia aliwaenda mu bulunghami bwakue, aliwatiina Yawe, inzi olia asili mulunghami mu nzila yakue, aliwamufuupula. ");
INSERT INTO tap_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Mu kanua ka kipuba muli nfimbo ya kiitoni, inzi twebo twa muntu wa mulangue tulitwamusunga. ");
INSERT INTO tap_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Kine tekuli nghombe, mu mukondo mulimwabula bilio, inzi maka a nghombe alialeeta bilio. ");
INSERT INTO tap_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Musininkizi wa kisinka tavinda kulanda bufi, inzi musininkizi wa bufi, mupuza wakue ni bufinke sie. ");
INSERT INTO tap_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Muntu wa kapuni aliwakeba mulangue, ni ye tezi kuusanga, inzi bukengezi bulengele ku muntu aliwainika. ");
INSERT INTO tap_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Fuma ku menso a kipuba, pantu ku milomo yakue teukonvuako maano. ");
INSERT INTO tap_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Mulangue wa muntu wa maano, kulangakana nzila yakue, inzi bupuba bwa babipuba, bupomponke sie. ");
INSERT INTO tap_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Babipuba tebezi kusakamana lubalibabala, inzi balunghami balibatona kweleelua na Leza. ");
INSERT INTO tap_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Mutima i umanine bulanda bwakue, ni mweni tavinda kwampana nakue mu nsansa yakue. ");
INSERT INTO tap_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Nghanda ya mubi iliyaloviiwa, inzi katanda ka mulunghami kalikabeelelela. ");
INSERT INTO tap_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Kuli nzila imwenekele yaweme ku menso a muntu, inzi ku mpeleezio iliyatwala ku lufu. ");
INSERT INTO tap_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Anzia useka, mutima waya wali ni bulanda. Nsansa luiliyapua, palipaiza bulanda. ");
INSERT INTO tap_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Olia aliwabwelela pa kyamba mu mutima wakue, aliwawaminua mu nzila yakue mwine, ni mulunghami aliwalambulua na bikitua byakue. ");
INSERT INTO tap_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Kipuba aliwaitabila kubalua kantu, inzi wa mulangue aliwakenta pa kunyanta. ");
INSERT INTO tap_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Wa mulangue aliwatiina Yawe ni kwikeka ku bubi, inzi kipuba tezi kwisakamana, kabili aliwakita lubilo lubilo. ");
INSERT INTO tap_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Olia asiliwakokola kufiitua, aliwakita bya bupuba, ni onse aliwakita bubi aliwasuulua. ");
INSERT INTO tap_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Babipuba balibapyana bupuba, inzi ba maano balibavwala ngala ya bukengezi. ");
INSERT INTO tap_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Babi balibafwinama ku ntanzi ya balia balibakita biweme, ni ba bibalo mu milyango ya balunghami. ");
INSERT INTO tap_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Mupabi aliwasuulua na mupabi nakue, inzi munonsi ali ni babibuza bengi. ");
INSERT INTO tap_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Olia aliwapunika mwinakue, aliwaluvia, inzi olia aliwaunvwila mupabi nkumbu, asyukile. ");
INSERT INTO tap_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Eba! Balia balibalangakana bibiipile tebezi kuluvia? inzi ntono ni bukisinka bili na balia balibalangakana biweme. ");
INSERT INTO tap_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Kubomba na mute kulikwaleeta kibwezia, inzi bulanzi bwa mpuni bulibwaleeta bupabi. ");
INSERT INTO tap_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Ngala ya ba mulangue, bunonsi bwabo, inzi bupuba bwa babipuba, bupubanke sie. ");
INSERT INTO tap_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Musininkizi wa kiine aliwapususia mitima ya bantu, inzi olia aliwabeepa, aliwaleeta bupompo. ");
INSERT INTO tap_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Aliwatiina Yawe ali ni maswapi alumine, ni baana bakue baakaba ni kwa kubutukila. ");
INSERT INTO tap_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Kutiina Yawe i kasulo ka bukose, kabili i kwikeka ku miteo ya lufu. ");
INSERT INTO tap_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","Bulumba bwakua likolo, bwingi bwa bantu bakue, inzi kukeepa kwa bantu, kwinooneka kwakua kateeka. ");
INSERT INTO tap_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Olia asiliwalenga kufiitua ali ni maano engi, inzi olia ali ni mutima wa kasonto aliwalumba bupuba. ");
INSERT INTO tap_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Mutima wa mutende, uliwaleeta bukose bwa mubili, inzi bunkua, bulibwabozia bikuza. ");
INSERT INTO tap_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Olia aliwakyuzia mupabi, aliwatuka Kabumba wabo, inzi olia aliwaunvwila nkumbu muntu abulilue, aliwakindika Kabumba. ");
INSERT INTO tap_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Mubi aliwatintilua pansi pa mulandu wa bunkitatubi bwakue, inzi mulunghami ali ni maswapi mu kufua kwakue. ");
INSERT INTO tap_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Mu mutima wa muntu ali ni mulangue i muli maano, inzi tezi kusangua mu mutima wa babipuba. ");
INSERT INTO tap_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Bulunghami, bulibwakindamika ntundu, inzi kibalo, kilikyaleeta lutiipu ku bantu bonse. ");
INSERT INTO tap_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Likolo aliwawaminua na mubombi aliwabomba na mulangue, inzi kikonko kyakue kili pa olia aliwakita bintu bisipalile. ");
INSERT INTO tap_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Bwasuko bwa bufuuke bulibwafuukia kipuki, inzi twebo twa kusasa tulitwaleeta kipuki. ");
INSERT INTO tap_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Lulimi lwa muntu wa mulangue lulilwaleeta bukengezi ni bulunghami, inzi kanua ka kipuba kalikasalanghania bupuba. ");
INSERT INTO tap_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Menso akua Yawe amwene ponse, akentele pa babi ni pa baweme. ");
INSERT INTO tap_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Lulimi lufuuke, i kimuti kya bukose, inzi kiitoni kili mukati kilikyatoobola mutima. ");
INSERT INTO tap_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Kipuba aliwafuupula mafunde akua se, inzi olia ali ni maano aliwakonka nsokezi. ");
INSERT INTO tap_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Mu nghanda mwa mulunghami muli bukonto bwingi, inzi bunonsi bwa babi, bulibwaleeta lwinoono. ");
INSERT INTO tap_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Milomo ya ba mulangue, iliyasalanghania bukengezi, inzi mutima wa babipuba te evio. ");
INSERT INTO tap_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Ngelelo ya mubi, kilubo kuli Yawe, inzi mapepo a mulunghami, aliamusansamusia Yawe. ");
INSERT INTO tap_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Yawe asuulile nzila ya mubi, inzi wene atonene olia aliwakonka bulunghami. ");
INSERT INTO tap_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Olia aliwasia nzila iweme, aliwakandua, ni asitonene kusokua, aliwafua. ");
INSERT INTO tap_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Kine lufu ni lwinoono bili ku menso akua Yawe, paliibufi mitima ya bantu. ");
INSERT INTO tap_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Muntu wa mufuupula, tezi kutona kulungikua, kabili tezi kutona kwipuzia muntu wa maano. ");
INSERT INTO tap_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Mutima wa nsansa, uliwalangisia lukebu lwa nsansa, inzi bulanda bwa mu mutima, bulibwalengia mweo kutooboka. ");
INSERT INTO tap_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Mutima wa maano uliwakeba bukengezi, Inzi kanua ka babipuba kalikalia bupuba. ");
INSERT INTO tap_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Nsiku yonse ya muntu aliwaema, ibiipile, inzi muntu wa nsansa, ali mu maliila lyonse. ");
INSERT INTO tap_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Kyawama kuba ni bunonsi buniini wali ni katiina kuli Yawe, kukila kuba ni bunonsi bwingi wali ni lyemo. ");
INSERT INTO tap_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Kyawama kulia saasa palia pali ntono, kukila kulia nghombe anonene palia pali kukendana. ");
INSERT INTO tap_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Muntu wa kipuki kikata aliwalengia mazibo, inzi olia asiliwalenga kufiitua, aliwapwisia bikanza. ");
INSERT INTO tap_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Nzila ya munanghani isakiluemo myunga, inzi nzila ya mulunghami iwamiiziwe. ");
INSERT INTO tap_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Mwana wa mulangue aliwamusansamusia se, inzi kipuba aliwamufuupula nghina. ");
INSERT INTO tap_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Bupuba i nsansa ya muntu asili na maano, inzi akengeele aliwawamia lwendo lwakue. ");
INSERT INTO tap_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Kine tekuli nsokezi, butantiko bulibwakilikilua, inzi kine pali nsokezi ingi bulibwalunduluka. ");
INSERT INTO tap_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Muntu aliwawaminua na bwasuko buweme, ni keebo kalikalandua pa musita upalile, kalikakila kuwama. ");
INSERT INTO tap_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Nzila ya muntu wa mulangue ilungi mwiulu ku bukose, evi tekuti akookele kumbo. ");
INSERT INTO tap_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Yawe aliwatuuta nghanda ya olia ali ni kiitoni, inzi aliwabiika mupaka wa musolo wa mwanakazi afwiliilue na mulume. ");
INSERT INTO tap_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Yawe asuulile malanga a babi, inzi twebo tuweme tulitwamuwamina. ");
INSERT INTO tap_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Olia aliwatokamua bunonsi, aliwaemia lupua lwakue, inzi olia asitonene bituulilo, waakaba mukose. ");
INSERT INTO tap_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Mutima wa mulunghami uliwalangakana musango wakwasukilamo, inzi kanua ka kipuba kalikafumia bubi. ");
INSERT INTO tap_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Yawe ali kule ni babi, inzi aliwaunvua mapepo a mulunghami. ");
INSERT INTO tap_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Kisue kya menso kilikyasansamusia mutima, ni mpunda iweme iliyainia bikuza. ");
INSERT INTO tap_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Kutui kulikwatwilizia nsokezi iweme, kulikwaikala pa balia bali ni mulangue. ");
INSERT INTO tap_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Olia aliwakaana masambilizio, aliwaisuula ye mwine, inzi olia aliwaunvua lu-aliwasasililua, aliwakengela. ");
INSERT INTO tap_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Kutiina Yawe i masambilizio a mulangue, ni bufuuke, bulibwatangilila mukinzi. ");
INSERT INTO tap_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Mapange a mu mutima, ni obe we mwine, inzi keebo ka mpeleezio kali na Yawe. ");
INSERT INTO tap_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Nzila ya muntu, imuwamiine ye mwine, inzi Yawe aliwatoosia mutima. ");
INSERT INTO tap_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Mubiikile Yawe miilo yobe, ni mapange obe alikufikiliziiwa. ");
INSERT INTO tap_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Yawe ali ni ki-aakitiile kubalua kantu, nga evelia babi ni bo pa musita wa lwinoono. ");
INSERT INTO tap_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Yawe asuulile kubalua muntu ali ni mutima wa kiitoni, kisinka mubi takabula kukandua. ");
INSERT INTO tap_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Kupitila mu ntono ni bukisinka, bubi bulibwaeleelua. Ni mu kutiina Yawe, bantu balibaikeka ku bubi. ");
INSERT INTO tap_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Nzila ya muntu luiliyamuwamina Yawe, Yawe aliwamupwanika na balwani bakue. ");
INSERT INTO tap_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Kyawama kuba ni bunonsi buniini wali ni bulunghami, kukila kuba ni bunonsi bwingi wali ni bubi. ");
INSERT INTO tap_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Mutima wa muntu, uliwalangakana muutoneene, inzi Yawe i aliwalombola ntanfu yakue. ");
INSERT INTO tap_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Milomo yakua likolo iliyalanda bulanzi bwa kileza, ni kanua kakue tekezi kuluvia mu bupinguzi. ");
INSERT INTO tap_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Kalingo ni bilemo bya nsambu ni byakua Yawe, mabue ali mu mufuko a kulingilako, ni miilo yakue. ");
INSERT INTO tap_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Kukita bubi, kilubo ku makolo, pantu kitebe kya bukolo kilikyateekua mu bulunghami. ");
INSERT INTO tap_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Milomo ya bulunghami, nsansa ya makolo, ni balia bamutonene, balibalanda bilungi. ");
INSERT INTO tap_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","Kipuki kyakua likolo, mukenzi wa lufu, inzi muntu wa mulangue aliwakifuukia. ");
INSERT INTO tap_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Mu kubenghema kwa lukebu lwakua likolo muli bukose, ni buwame bwakue buli nga malezi a nvula ya mpeleezio. ");
INSERT INTO tap_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Kyawama kuba ni mulangue kukila oro. Ee, kipalile kusaakula maano kukila mutofue. ");
INSERT INTO tap_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Nzila ikata ya mulunghami, ni kwikeka ku bubi. Olia akonkele nzila yakue, asungile mutima wakue. ");
INSERT INTO tap_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Kiitoni kilikyatangilila lwinoono, ni mutima wa kwitantamuna uliwatangilila kupona. ");
INSERT INTO tap_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Kyawama kuya wafuukile wali mupabi, kukila kupaana bunonsi wali ni kiitoni. ");
INSERT INTO tap_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Olia aliwasunga mafunde, aliwalunduluka, ni aswapiile Yawe, ali ni lisyuko. ");
INSERT INTO tap_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Olia ali ni mutima wa mulangue, aliwakuutua wa maano, ni kuwama kwa bulanzi, kulikwalunduluzia kumana. ");
INSERT INTO tap_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Olia ali ni mulangue, ali ni kasulo ka bukose, inzi babipuba balibakandua mu bupuba bwabo. ");
INSERT INTO tap_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Mutima wa muntu wa mulangue, uliwasambilizia kanua kakue, kabili uliwalunduluzia maano a lulimi lwakue. ");
INSERT INTO tap_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Twebo tuweme tuli nga kapelo, ni to tulitwawamia mutima ni kukosia bikuza. ");
INSERT INTO tap_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Kuli nzila imwenekele yaweme ku menso a muntu, inzi ku mpeleezio iliyatwala ku lufu. ");
INSERT INTO tap_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Nzala ya mubombi iliyamulengia kubomba, pantu nkulu ya kanua kakue iliyamuleetela mute wa kubomba. ");
INSERT INTO tap_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Muntu asili na kibwezia aliwaimba kiina kya bubi, ni mumbali milomo yakue muli nga muli mulilo uliwazizyania. ");
INSERT INTO tap_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Muntu mubi, aliwaleeta mazibo, ni olia wa busongezi, aliwapusania babibuza. ");
INSERT INTO tap_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Muntu aliwakyuzyania aliwabembia mwinakue, ni kumulombola mu nzila isiweme. ");
INSERT INTO tap_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Olia aliwakapia na linso, aliwakambila kukita bibiipile, ni olia aliwasumba milomo yakue, aliwalanda bibiipile. ");
INSERT INTO tap_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Ndale, i ngala ya bulumba, iliyasangua sie mu nzila ya bulunghami. ");
INSERT INTO tap_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Olia asiliwalenga kufiitua, aweme kukila wa buvinde, ni olia aliwateeka mutima wakue, aweme kukila olia aliwasakukila muzi. ");
INSERT INTO tap_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Bubale bulibwateelua pa kibeta, inzi bupinguzi bonse bulibwafuma kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Kyawama kulia bilio byume wali ni mutende, kukila nghanda ilimo maliila engi mwali ni mazibo. ");
INSERT INTO tap_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Mubombi wa maano aliwateeka bwino mwana aliwakita bintu bya busoni, ni ye waakabamo ni nsempu ya bupyani nga wa mu lupua. ");
INSERT INTO tap_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Mupika, i wakusungulwilamo mutofue, ni kikuka kya mulilo, i kya kwapikamo oro, inzi Yawe aliwatoosia mitima. ");
INSERT INTO tap_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Nkitatubi aliwatwilizia milomo ya bubi, ni wa bufi aliwatwilizia lulimi lubi. ");
INSERT INTO tap_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Olia aliwakyuzia mupabi, aliwatuka Kabumba wabo, ni olia aliwasekelela busanzo, takabula kukandua. ");
INSERT INTO tap_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Ngala ya bakote, benzikulu, ni bulumba bwa baana, ba sibo. ");
INSERT INTO tap_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Bulanzi buweme tebwawama mu kanua ka kipuba, paliibufi milomo yakua kateeka iliyabeepa. ");
INSERT INTO tap_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Kituulilo kili nga lyese ku menso akua olia aliwapaana. Konse kualikukibombia kilikumuleetela kibwezia. ");
INSERT INTO tap_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Olia aliwavimba pa kilubo, aliwakeba ntono, inzi olia aliwabweluluka pa keebo kamonke, aliwasalanghania babibuza. ");
INSERT INTO tap_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Kusasililua kulikwapokelelua mu mutima wa olia ali ni maano, kukila nfimbo 100 ku kipuba. ");
INSERT INTO tap_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Muntu mubi aliwakeba sie kwisangula kuli Leza, ni pakako, aliwatuminua mukenzi asasile. ");
INSERT INTO tap_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Kyawama kusaakaana ni kimbui mukota kipokelue baana, kukila kusaakaana ni kipuba mu bupuba bwakue. ");
INSERT INTO tap_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Olia aliwabwezia bubi pa biweme, bubi tebukapua mu nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Ntendeko ya mazibo ili nga kulekelela menda apanguke. Kansi lekele bikanza lubisinamifikie ku mazibo. ");
INSERT INTO tap_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Olia aliwapeela mubi nsambu ni kumutana mulunghami nsambu, bonse babili, kilubo kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Ale nfolanga ibeeleeleki mu minue ya kipuba kuti asite mulangue, ni ye tekuba wali na maano? ");
INSERT INTO tap_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Kibuza aweme, ni kibuza wa kubalua busiku, inzi wa mu lupua aliwavyalua kuti akwasie musita wa lyemo. ");
INSERT INTO tap_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Muntu asili na maano aliwalaya ni kwipeela kulipa mizia ya mwinakue. ");
INSERT INTO tap_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Olia atonene mazibo, atonene bibalo, ni olia aliwaitantamuna, aliwakeba lwinoono. ");
INSERT INTO tap_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Olia akosele mutima, tezi kumona buwame, ni olia ali ni lulimi lwa kiitoni, aliwaponena mu bwavia. ");
INSERT INTO tap_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Olia avyele kipuba, bulanda bwakue mwine, se kwa kipuba, tali na nsansa. ");
INSERT INTO tap_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Mutima wa nsansa, miti iweme, inzi mutima uliwatooboka, uliwaumia bikuza. ");
INSERT INTO tap_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Muntu mubi aliwapokelela kituulilo mu kafiso pakuti avulunghanie bupinguzi. ");
INSERT INTO tap_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Maano ali ku ntanzi ya muntu ali ni mulangue, inzi menso a kipuba afikile kupelele kyalo. ");
INSERT INTO tap_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Mwana kipuba, bulanda kuli se, kabili ni kikonko kuli nghina waamuvyele. ");
INSERT INTO tap_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Kukanda mulunghami tekuweme, ao kuuma babiloolo tekuweme. ");
INSERT INTO tap_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Olia aliwasunga twebo twakue, akengeele, ni olia ateekameene mutima, ali ni maano. ");
INSERT INTO tap_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Mupuba ni ye kine waikala tondolo, alikumonua kuba ni mulangue, lu-aliwamuma kanua kakue, aliwamonua kuba ni maano. ");
INSERT INTO tap_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Olia aliwaikeka ku benakue aliwakeba kukita mu-atoneene, kabili aliwafiitua lu-aliwasokua. ");
INSERT INTO tap_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Kipuba tezi kuwaminua na maano, inga sie kukita mutoneene mutima wakue. ");
INSERT INTO tap_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Mubi lu-aliwaiza, ni mufuupula ni o uliwaiza, ni pa kyamba kya busoni, kuleebulua. ");
INSERT INTO tap_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Twebo twa mu kanua ka muntu, buziba buzikile, kasulo ka mulangue, menda a kaezi aliaenda. ");
INSERT INTO tap_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Kukita kitoolela ku mubi tekuweme, ao kumutana nsambu mulunghami musita wa bupinguzi. ");
INSERT INTO tap_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Milomo ya kipuba iliyafikyania ku bikanza, ni kanua kakue kalikakuuta bipumo. ");
INSERT INTO tap_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Kanua ka kipuba ni lwinoono lwakue, ni milomo yakue ni muteo wa kukwatuamo ye mwine. ");
INSERT INTO tap_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Twebo twa musongezi tuli nga bisoso bya bilio biweme, bisoso bilibyakookela munda. ");
INSERT INTO tap_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Olia anangheene mu miilo, i lupua lwakua nghinooni. ");
INSERT INTO tap_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Liina lyakua Yawe, kyubo kilumine. Mulunghami kine wabutukilako, alikuya wali ni mutende. ");
INSERT INTO tap_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Munonsi amwene nangue bunonsi i kyubo kyakue kya maka. Alangakeene nangue i kibumba kimusungile. ");
INSERT INTO tap_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Kwinooneka kwa muntu kulikwatangililua na kiitoni. Ni kwikeefia kulikwatangililua na mukinzi. ");
INSERT INTO tap_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Kwasuka lu-usinaunvue, bupuba ni busoni. ");
INSERT INTO tap_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Mweo wa muntu uliwasipikizia malwele, kubako kuli ni alikuvinda kuteekamania mutima utoobokele? ");
INSERT INTO tap_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Mutima wa muntu wa maano uliwakeba bukengezi, ni kutui kwa muntu wa mulangue kuli kwakeba maano. ");
INSERT INTO tap_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Kyabupe kya muntu kilikyamwizwila nzila, ni kumuleeta ku menso a bantu bakulu. ");
INSERT INTO tap_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Olia aliwaipokolola wa mambo aliwamoneka wali ni nsambu, inga sie kine unge waiza kutoosia twebo twakue. ");
INSERT INTO tap_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Kuteya bubale kulikwapwisia bikanza, ni kupingula milandu ya bakulu. ");
INSERT INTO tap_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Muntu aluviiziwe na wa kwakue, aliwafinia mutima kukila muzi uli ni kibumba, ni bikanza bili nga minkolonto ya milyango ya ku kyubo. ");
INSERT INTO tap_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Kavumo ka muntu kalikaikusiiwa na mazabo a mu kanua kakue, kabili aliwaikuta mazabo a ku milomo yakue. ");
INSERT INTO tap_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Lufu ni bukose bili mu buvinde bwa lulimi, ni balia babutonene, balibalia mazabo akue. ");
INSERT INTO tap_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Olia aliwaupa mwanakazi, aliwasanga kintu kiweme. Aliwapokelela buwame kufuma kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Mupabi aliwalanda wapaapaata, inzi munonsi aliwa-asuka wasasile. ");
INSERT INTO tap_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Olia ali ni babibuza bengi, aliwaileetelela lwinoono, inzi kuli ni kibuza aliwa-ampana na muntu kukila lupua lwakue. ");
INSERT INTO tap_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Kyawama mupabi aliwaenda mu bulunghami bwakue, kukila kipuba ali ni kiitoni mu bulanzi. ");
INSERT INTO tap_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Muntu tapalile kubulua maano, ni olia aliwaya lubilo lubilo aliwaipuutala. ");
INSERT INTO tap_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Muntu aliwailovia mu bupuba bwakue, inzi mutima wakue uliwamufiitilua Yawe. ");
INSERT INTO tap_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Bunonsi bulibwavuzia bibuza, inzi mupabi aliwakaanua na bapabi nakue. ");
INSERT INTO tap_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Musininkizi wa bufi, takabula kukandua, ni olia aliwalanda bufi takapusuka. ");
INSERT INTO tap_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Bengi balibapaapaata ku bakindami, inzi kubalua muntu, kibuza wa muntu aliwapaana. ");
INSERT INTO tap_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Lupua lonse lwa mupabi lulilwamusuula, paliibufi babibuza bakue, i balibakila sie kuya kule ni kumusia! Mupabi anzia kine wabelambilizia tebamunvua. ");
INSERT INTO tap_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Olia ali ni mulangue, atonene bukose bwakue, ni olia ali ni kyunvwila, aliwamona buwame. ");
INSERT INTO tap_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Musininkizi wa bufi takabula kukandua, ni olia aliwalanda bufi aliwazeeza. ");
INSERT INTO tap_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Bwikazi buweme tebupalile ku kipuba, paliibufi muzia kuteeka bakindami. ");
INSERT INTO tap_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Wa mulangue tezi kulenga kufiitua. Kweleela kilubo, i bulumba bwakue. ");
INSERT INTO tap_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Kipuki kyakua likolo kili nga kubuluma kwa nkalamu, inzi ntono yakue ili nga lume ku bikusi. ");
INSERT INTO tap_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Mwana kipuba, kukeepelua kwakua se, ni bikanza bya mukazi, bili nga matooni asiliapua. ");
INSERT INTO tap_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Nghanda pamo ni bunonsi, bupyani bulibwafuma ku muvyazi, inzi mukazi wa maano aliwafuma kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Muleele uliwaleeta tulo twingi, ni munanghani aliwaema na nzala. ");
INSERT INTO tap_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Olia aliwakonka mafunde, aliwasunga bukose bwakue, inzi olia asiliwakonka nzila yakue, waakafua. ");
INSERT INTO tap_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Olia aliwakwasia mupabi, aliwamukopia Yawe, ni Yawe aliwamulambula pa bikitua byakue biweme. ");
INSERT INTO tap_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Kanda mwana obe maswapi lu-akiliko, kine teumukwasiizie, wamukwasia kwinooneka. ");
INSERT INTO tap_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Muntu wa kipuki kikata, apalile kukandua, kine wewe wamukwasia, wakaba kumukwasia ni linge. ");
INSERT INTO tap_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Twilizia nsokezi ni kupokelela mafunde, evi ku mpeleezio ukabe ni mulangue. ");
INSERT INTO tap_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Mu mutima wa muntu muli mapange engi, inzi kitonene Yawe i kilikyafikiliziiwa. ");
INSERT INTO tap_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Kikebekele ku muntu, kuya wali wa kisinka, mupabi aweme kukila wa bufi. ");
INSERT INTO tap_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Kutiina Yawe kulikwatwala ku bukose, ni olia aliwamutiina, aliwaya waikeele waikusi, ni bubi tebukamupalamina. ");
INSERT INTO tap_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Munanghani aliwabiika kuboko kwakue mu nsaani, ni kwandua kutwala pa kanua kakue. ");
INSERT INTO tap_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Uma muntu wa kapuni pakuti babipuba basambilileko maano, kabili sasilila olia amanine, pakuti abe ni bukengezi. ");
INSERT INTO tap_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Mwana aliwaemia se ni kukumba nghina, aliwaleetelana busoni ni mufuupula. ");
INSERT INTO tap_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","We mwana wane, kine walekela kutwilizia mafunde ulikusangukila twebo twa mulangue. ");
INSERT INTO tap_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Musininkizi asipalile, aliwafuupula bupinguzi, ui tunua twa babi tulitwazakila bubi. ");
INSERT INTO tap_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Kukandua kuteaniiziwe pa balia bali ni mufuupula, ni bipumo mu musana wa babipuba. ");
INSERT INTO tap_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Divai i kapuni, ni kikolani i mazibo, ni muntu onse aliwabembua mu bebi bintu tali na mulangue. ");
INSERT INTO tap_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Kipuki kyakua likolo, kili nga kubuluma kwa nkalamu, olia aliwamulengia kufiitua, aliwaluvia mutima wakue mwine. ");
INSERT INTO tap_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Bukindami bwa muntu, kulekela mazibo, inzi kubalua kipuba aliwatona mazibo. ");
INSERT INTO tap_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Munanghani tezi kutona kulima pa musita wa kulima, ni pakako, musita wa buzombozi waya walombelezia bilio pantu tali na kantu. ");
INSERT INTO tap_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Malanga a mu mutima wa muntu, buziba buzikile, inzi muntu wa mulangue aliwatapulapo. ");
INSERT INTO tap_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Kubalua muntu aliwalanda buwame bwakue, ale muntu wa kisinka alikumonua nani? ");
INSERT INTO tap_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Kine mulunghami waendela mu bulunghami bwakue, baana bakue balibapaalua mu kyamba kyakue. ");
INSERT INTO tap_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Likolo lu-aliwaikala pa kitebe kya bupinguzi, aliwauluzia bubi bonse na menso akue. ");
INSERT INTO tap_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Nani alikuvinda kulanda nangue, “Nakiswesia mutima wane, nakisambika ku bibalo byane?” ");
INSERT INTO tap_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Mabue a tulingo tulekenkeene, ni bilemo bilekenkeene, bebi byonse bibili, bilubo kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Mwana ni ye aliwamanika kupitila mu bikitua byakue, kine biweme, ao kine bilungi. ");
INSERT INTO tap_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Kutui kulikwaunvua, ni linso lililyamona, byonse bibili bikitilue na Yawe. ");
INSERT INTO tap_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Tekutonesia tulo, ukeeza kukula wali mupabi, labuka, ni we ulikwikuta bilio. ");
INSERT INTO tap_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","“Temuli kantu, temuli kantu!” Nangue musiti, inzi aliwaitasia wasyaile. ");
INSERT INTO tap_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Kuli oro ni mabue engi a mutengo, inzi milomo iliyalanda twebo twa maano, libue lya mutengo. ");
INSERT INTO tap_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Muntu kine walaya kulipila mizia ya muntu asimanikile, apokueko ngubo yakue nga kikwatizi, mumukite kuba kikwatizi pa mulandu wa ozo mweni. ");
INSERT INTO tap_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Kya kulia kya bupoti, kiweme ku muntu, inzi pa kyamba, kanua kakue kalikaizulamo tubwekese. ");
INSERT INTO tap_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Kine pali nsokezi mapange aliafikiliziiwa, kine watona kusakukilana, upalile kulangakananke. ");
INSERT INTO tap_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Olia aliwapitaana wa-ambana, aliwafyula tufiso, kansi tekwampana na kilandelande. ");
INSERT INTO tap_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Olia aliwatiipa se ao nghina, kisue kya bukose bwakue kyaazimiiwa musita wa nfinzi ikata. ");
INSERT INTO tap_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Bupyani bulibwalombua ntanzi ya nsita, ku mpeleezio tebukaba na mapaalo. ");
INSERT INTO tap_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Tekulanda nangue, “Ndikukita kibwelezi!” Muswapile Yawe, akupususie. ");
INSERT INTO tap_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Mabue a tulingo tulekenkeene, kilubo kuli Yawe, ni bilemo bya bupoti tebifwaniine. ");
INSERT INTO tap_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Ntanfu ya muntu iliyalombolua na Yawe, ale muntu kuti wamana syani nzila yakue mwine? ");
INSERT INTO tap_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Kulanda lubilo lubilo nangue keki ni kya kupeela Leza, muteo, pantu kuti waiza kwemenamo. ");
INSERT INTO tap_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Likolo wa mulangue aliwauluzia babi, aliwabapingula pasili nkumbu. ");
INSERT INTO tap_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Mweo wa muntu, i musaniko wakua Yawe, i uliwakebelezia mu nkendo yonse ya mukati ka muntu. ");
INSERT INTO tap_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Ntono ni bukisinka bilibyamusunga likolo, ni bukolo bwakue busimpilue na ntono. ");
INSERT INTO tap_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Bulumba bwa balumendo, maka abo. Kuwama kwa bakote, mutue wa ndale. ");
INSERT INTO tap_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Bipumo ni bilonda, ni miti yakupwisia bubi. Nfimbo iliyaswesia mutima mpaka mukati. ");
INSERT INTO tap_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Mutima wakua likolo uli mu minue yakua Yawe nga vili tunkolonfua twa menda, aliwaulombola konse ku atonene. ");
INSERT INTO tap_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Kubalua nzila ya muntu, iweme ku menso akue mwine. Inzi Yawe aliwatoosia mitima. ");
INSERT INTO tap_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Kukita biweme ni bilungi, kulikwamuwamina Yawe kukila ngelelo. ");
INSERT INTO tap_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Menso a kiitoni ni mutima wa kwitantamuna, kilangililo kya bibalo bya bantu babi. ");
INSERT INTO tap_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Mapange a muntu wa mute, alialeeta bunonsi bwingi, inzi kubalua muntu aliwakita lubilo lubilo, bupabi bulibwaiza pali wene. ");
INSERT INTO tap_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Bunonsi bulibwanonkelua mu bufi, byunsi bilibyaya kiyeyeye. Balia balibabukeba, balibakeba lufu. ");
INSERT INTO tap_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Bupoti bwa babi bulibwabatwala kule, pantu balibakaana kukita bulunghami. ");
INSERT INTO tap_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Nzila ya muntu emanine nangue ali ni bilubo, ipeteeme, inzi mibeele ya muntu asili na mulandu ili bwino. ");
INSERT INTO tap_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Kyawama kwikala mu kafuli ka mutenge wa nghanda, kukila kwikala mu nghanda pamo ni mukazi wa mazibo. ");
INSERT INTO tap_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Muntu mubi, aliwakeba bubi, kabili tezi kunvwila mwinakue nkumbu. ");
INSERT INTO tap_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Muntu wa kapuni lu-aliwakandua, kipuba aliwa-aluka ni mulangue, ni wa mulangue lu-aliwasambiliziiwa, aliwalunduluka kuba ni maano. ");
INSERT INTO tap_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Mulunghami amanine bili mu nghanda ya babi, kabili aliwabalovia ni kubenoona. ");
INSERT INTO tap_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Olia aliwakilika matui tekuti onvue kulila kwa mupabi, ni ye waakalila, inzi takonvwiwa. ");
INSERT INTO tap_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Bupe bwa mu kafiso bulibwapwisia kikonko, ni kituulilo kya mu kafiso kilikyapwisia kipuki. ");
INSERT INTO tap_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Bupinguzi bwa nsambu lubulibwakitika, balunghami balibawaminua, inzi bankitatubi balibaswapulukua. ");
INSERT INTO tap_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Olia aliwaemooka ni kusia nzila ya maano, aliwaisanga walimukutuuzia mu libumba lya bafwile. ");
INSERT INTO tap_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Olia atonene maliila, aliwa-aluka mupabi. Olia atonene divai ni mafuta takanonka. ");
INSERT INTO tap_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Mubi i bupusuko bwa mulunghami, ni olia aliwakita bupompo, bupusuko bwa muntu wa kisinka. ");
INSERT INTO tap_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Kyawama kwikala mu kaseeba, kukila kwikala pamo ni mukazi wa mazibo ni musokozi. ");
INSERT INTO tap_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Mu bwikazi bwa bantu ba maano muli bukonto bwa mponvu ni mafuta, inzi kipuba aliwalia byonse. ");
INSERT INTO tap_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Olia aliwakonka bulunghami ni ntono, aliwasanga bukose ni bulunghami pamo ni mukinzi. ");
INSERT INTO tap_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Muntu wa mulangue aliwakwata muzi wa bantu ba maka ni kutuuta kyubo kya maswapi abo. ");
INSERT INTO tap_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Olia aliwakilikila kanua kakue ni lulimi lwakue, aliwapususia mutima wakue ku bukyuzi. ");
INSERT INTO tap_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Muntu wa kiitoni ni aliwaitantamuna, liina lyakue ni “Mupuni.” Kwitantamuna kwakue ni kwa kiitoni. ");
INSERT INTO tap_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Kutokamua kwa munanghani kulikwamwipaya, pantu maboko akue aliakaana kubomba. ");
INSERT INTO tap_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Munanghani aliwakeba koba konse, inzi mulunghami aliwapaana sie pasili kutanana. ");
INSERT INTO tap_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Ngelelo ya mubi, kilubo kikata. Paliibufi kine aliwaelela na malanga abi! ");
INSERT INTO tap_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Musininkizi wa bufi, aliwazeeza, inzi muntu ali ni matui, aliwalanda twebo tulitwatwalilila. ");
INSERT INTO tap_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Mubi aliwaumia pa mpala, inzi mulunghami aliwawamia nzila yakue. ");
INSERT INTO tap_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Tekuli mulangue ao bukengezi ao nsokezi iliyavinda kutwalilila musitoneene Yawe. ");
INSERT INTO tap_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Farasi ateaniziiziwe mbeela mu busiku bwa bului, inzi Yawe i aliwaleeta bwanzio. ");
INSERT INTO tap_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Kyawama kuba ni bulumba kukila kuba ni bunonsi bwingi. Ni kwitabilua kuweme kukila kuba ni mutofue pamo ni oro. ");
INSERT INTO tap_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Kintu kimo kili na munonsi ni mupabi ni keki: Yawe i Kabumba wabo. ");
INSERT INTO tap_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Mukengezi aliwamona bubi ni kufyama, inzi babipuba balibaya sie ku ntanzi mpaka baikisia. ");
INSERT INTO tap_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Kunakila ni kumutiina Yawe kulikwaleeta bunonsi, ni mukinzi pamo ni bukose. ");
INSERT INTO tap_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Myunga ni tukose, bili mu nzila ya bafinine mitima, inzi olia asungile mutima wakue, alikuba wali kule nabio. ");
INSERT INTO tap_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Sambilizia mwana nzila i apalile kukonka, pantu anzia akakota takafumamo. ");
INSERT INTO tap_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Mupabi, aliwateekua na munonsi, ni mukopi, mubombi wa olia aliwakopia. ");
INSERT INTO tap_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Olia aliwabyala bubi, aliwazombola bwavia, ni nfimbo yakue ya kukandilanako ilikutyoka. ");
INSERT INTO tap_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Muntu wa buntu, aliwapaalua, pantu aliwakasania bapabi bilio byakue. ");
INSERT INTO tap_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Kumba wa kapuni ni mazibo alikupua. Ee, mazibo ni matuka, bilikupua. ");
INSERT INTO tap_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Olia atonene buswesi bwa mutima ni aliwalanda bulanzi buweme, likolo alikuba kibuza wakue. ");
INSERT INTO tap_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Menso akua Yawe alialabukila maano, inzi aliwalovia twebo twa mupoti. ");
INSERT INTO tap_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Munanghani aliwalanda nangue, “Panze pali ni nkalamu! Ndikwipailua mu kisaakaanino kya bantu.” ");
INSERT INTO tap_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Kanua ka mwanakazi mukambue, kiina kizikile. Olia asuulilue na Yawe, aliwaponenamo. ");
INSERT INTO tap_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Bupuba bukakiliilue mu mutima wa mwana, inzi nfimbo ya kumukanda iliyabukumbila kule. ");
INSERT INTO tap_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Olia aliwabiibikizia mupabi pakuti avuzie bunonsi bwakue, ni aliwapeela munonsi byabupe, bonse babili balibapeleela ku bupabi. ");
INSERT INTO tap_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Twilizia unvue bulanzi bwa balia bali ni mulangue, ni kupooza maano ku bindimukusambilizia. ");
INSERT INTO tap_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","Pantu kuti kyawama kine wasunga masambilizio mukati mobe, ni ku-apitulukamo kubalua musita. ");
INSERT INTO tap_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Evi maswapi obe aye ali muli Yawe. Ni wewe wenka, nakusambilizia lelo. ");
INSERT INTO tap_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Eba, nsikulembeele bulanzi 30, bulanzi bwa nsokezi ni bwa maano, ");
INSERT INTO tap_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Evi bukusambilizie kuba wa kiine ni wa kulanda kisinka, pakuti ubwezie mpunda ya kiine ku balia bakutumine? ");
INSERT INTO tap_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Tekupompola mupabi bunonsi bwakue pantu ye ni mupabi, Ni mu kilie tekubiibikizia nsambu muntu abulilue. ");
INSERT INTO tap_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","Pantu Yawe aliwabalandila, ni kubiibikizia bwikazi bwa balia balibababiibikizia. ");
INSERT INTO tap_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Tekukita bukibuza na olia ali ni kipuki kikata, ao kwenda pamo ni muntu asiliwakokola kufiitua. ");
INSERT INTO tap_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","Ukeeza kusambilila mibeele yakue, ni kulengia kukwatua we mwine mu muteo. ");
INSERT INTO tap_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Tekuti ube umo wa pa balia balibalaya, ao kwitabila kulipa mizia nghwana. ");
INSERT INTO tap_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","Kine teuli na kinge kya kumulipa, wene kuti watwaminamo bulita bobe. ");
INSERT INTO tap_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Tekutelulula kalangi ka mipaka ya kale, mipaka yaabiikilue na babikolue bobe. ");
INSERT INTO tap_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Kubako umwene muntu amanine bwino mwilo wakue? Alikubomba ntanzi ya makolo. Takaba kubombela babiloolo basipalile. ");
INSERT INTO tap_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Luuliwaikala ku kulia pamo ni kateeka, tekulaba nangue ulimukulia nani. ");
INSERT INTO tap_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","Kine uli nkandakalio, biika mwele pa mukolomino obe. ");
INSERT INTO tap_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Kabili tekutokamua bilio byakue biweme, pantu kuti bya kubembia. ");
INSERT INTO tap_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Tekwiemia mu kukeba bunonsi. Tekupozesiako maano. ");
INSERT INTO tap_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Pantu kuti wa bumona, ni bo bwazeeza pantu kisinka bunonsi bulibwaikitila mapaapi, nga nzwiba aliwapupuka mu muulu. ");
INSERT INTO tap_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Tekulia bilio bya muntu wa butani, kabili tekutokamua bilio byakue biweme, ");
INSERT INTO tap_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","Pantu mu mutima wakue alimukupenda biulimukulia, alikukwana, “Mina, Lia!” Inzi mu mutima mwali binge. ");
INSERT INTO tap_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Elia mikusu iwalyanga ulikuiluka, ni ntasio yobe ilikuba ya mpuni. ");
INSERT INTO tap_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Tekulanda twebo twa maano ku kipuba, pantu alikufuupula mulangue wa twebo tobe. ");
INSERT INTO tap_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Tekutelulula kalangi ka mipaka ya kale, kabili tekupoka makaba a baana nsiiwa. ");
INSERT INTO tap_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","Pantu Kalubula wabo ali ni maka, wene waakabalandila, ni we waakamoneka wali ni kilubo. ");
INSERT INTO tap_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Poozako maano mu kukonka masambilizio, ni kuteya matui obe ku kutwilizia twebo twa maano. ");
INSERT INTO tap_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Tekumulekeela mwana pasili kumuuma, pantu kine wamusepula nfimbo, tafua. ");
INSERT INTO tap_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Musepule nfimbo ni kupususia bukose bwakue ku lufu. ");
INSERT INTO tap_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","We mwana wane, kine mutima obe uli ni mulangue, kisinka mutima wane ni o ulikuwaminua. ");
INSERT INTO tap_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Mutima wane ulikuwaminua, milomo yobe luiliyalanda bilungi. ");
INSERT INTO tap_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Mutima obe tekuti unvwile bantu ba bibalo bunkua, inzi wewe tiina Yawe koba konse. ");
INSERT INTO tap_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Pantu kisinka kuli ni buwame ku ntanzi, ni maswapi obe teakapua. ");
INSERT INTO tap_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Unvua we mwana wane, kabili ba ni mulangue, lombola mutima obe mu nzila iweme. ");
INSERT INTO tap_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Tekuya wali pa libumba lya bakyakolua, ao balia balibalia munani wa nama nga bakazule. ");
INSERT INTO tap_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","Pantu kyakolua ni kazule baakapeleela ku bupabi, ni tulo twaakabavwika bilaka. ");
INSERT INTO tap_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Mutwilizie so akuvyele, kabili tekumufuupula noko mu bukote bwakue. ");
INSERT INTO tap_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Sita kiine, inzi tekuti ukisisie. Sita mulangue, ni masambilizio pamo ni maano. ");
INSERT INTO tap_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Se kwa mwana mulunghami, ali ni nsansa ikata. Olia avyele mwana wa maano, ni ye aliwasansamusiiwa. ");
INSERT INTO tap_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","So ni noko bawaminue, noko akuvyele asangalale. ");
INSERT INTO tap_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","We mwana wane, n'mpeele mutima obe, ni menso obe awaminue na nzila yane. ");
INSERT INTO tap_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Pantu mukende, ali nga kiina kizikiisie, ni mwanakazi mweni ali nga kiina kyondele. ");
INSERT INTO tap_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Ee, aliwabenza nga kabooko, ni kulengia balalume bengi kusiba ba kisinka. ");
INSERT INTO tap_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Nani ali ni maavia? Nani ali ni bulanda? Nani ali ni mazibo? Nani aliwaitendooka? Nani ali ni bilonda bya mpuni? Nani akasikile menso? ");
INSERT INTO tap_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Ni olia aliwakokola musita uleepele mu bumini, olia aliwakeba kutompatompa bwalua bulekenkeene. ");
INSERT INTO tap_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Wewe tekutokamua bwalua lubukasikile, anzia kine bulimukufumia tufulo twabenghema, ni kukooka bwino bukebuke. ");
INSERT INTO tap_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Inzi pa mpeleezio bulibwasuma nga nzoka, ni bwimba bwakue nga bwa ngwezie. ");
INSERT INTO tap_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Menso obe alikumona byeni, ni mutima obe ulikufumia bintu bisipalile. ");
INSERT INTO tap_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Ee, ulikuya wali nga muntu aleele pakati buziba, nga muntu aleele ku mulingoti wa bwato. ");
INSERT INTO tap_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Ulikulanda evi, “Bakinsepa, inzi nsyakikisika. Bakinghuma, inzi nsyakyunvua kantu. Ndikubuuka musitaki kuti ntwalilile kukeba bunge bwalua?” ");
INSERT INTO tap_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Bantu babi tekubonvwila bunkua, kabili tekutokamua kuba pamo nabo. ");
INSERT INTO tap_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","Pantu mutima wabo uliwalangakana bupoti, ni milomo yabo iliyalanda sie bibiipile. ");
INSERT INTO tap_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Nghanda iliyakuulua na mulangue, ni kwimikua na maano. ");
INSERT INTO tap_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Ni mu bukengezi miputule yakue iliyaizuziwamo bintu bya mutengo ukata ni bifwaniine. ");
INSERT INTO tap_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Muntu wa mulangue, i alumine. Ee, muntu wa maano i aliwavuzia maka. ");
INSERT INTO tap_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","Pantu aliwalua bului na nsokezi ya maano, ni mu bwingi bwa bakasoka, bwanzio bulibwamoneka. ");
INSERT INTO tap_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Mulangue amukilile kipuba. Kipuba tezi kwasamuna kanua kakue pa mulyango. ");
INSERT INTO tap_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Olia aliwakambila kukita bubi, bantu balikumukuuta kankobenkania. ");
INSERT INTO tap_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Malanga akua kipuba ni kibalo, ni muntu wa kapuni ni kilubo ku bantu. ");
INSERT INTO tap_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Kine wanaka mu nsiku ya lyemo, maka obe akeepele. ");
INSERT INTO tap_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Pususia balia batwemue kuti baye bepawe, ni balia basyali pepi ni kwipawa, kita maka ubapususie. ");
INSERT INTO tap_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Kine walanda nangue, “Mona fwefue tetwakyunvua ezi milandu,” Kubako olia aliwatoosia mitima, kuti wamana? Ni olia aliwasunga mutima obe, tavinda kwinika? Ni ye takasazia kubalua muntu kukonkana ni miilo yakue? ");
INSERT INTO tap_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","We mwana wane, lia kapelo pantu kaweme, ni muto wa kapelo pantu usonsele mu kanua kobe. ");
INSERT INTO tap_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Upalile kumana nangue mulangue uli nga kapelo kuli wewe, kine wausanga, wakaba kuya wali ni nsiku iweme ku ntanzi ni maswapi obe teakaba apua. ");
INSERT INTO tap_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","We muntu mubi, tekubenza bwikazi bwa mulunghami, tekupoka nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","Anzia mulunghami apona nghendo kilooba ni kubuuka paakale, inzi babi balibaloviiwa na bubi. ");
INSERT INTO tap_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Tekuwaminua lulilwapona mulwani obe, ni mutima obe tekuti usangalale lu-aliwaipuutala. ");
INSERT INTO tap_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Pantu Yawe kine wamona evio alikufiitua, ni ye takaba kubakanda. ");
INSERT INTO tap_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Tekwema pa mulandu wa bankitatubi, ao kunvwila babi bunkua. ");
INSERT INTO tap_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","Pantu muntu mubi tali na nsiku iweme ku ntanzi. Musaniko wa mubi uliwazima. ");
INSERT INTO tap_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","We mwana wane, tiina Yawe pamo ni likolo, kabili tekwampana na babisanguka. ");
INSERT INTO tap_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","Pantu busanzo bwabo bwakaba kubatulumukilila sie. Ale nani amanine lwinoono lwaakaleetua na Yawe ni likolo? ");
INSERT INTO tap_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Bobu i bulanzi bwa bantu ba mulangue. Kuba ni kitoolela mu bupinguzi tekuweme. ");
INSERT INTO tap_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Olia aliwamwana mubi nangue, “Wewe uli ni nsambu,” Bantu balikumutiipa, ni ntundu ilikumusuula. ");
INSERT INTO tap_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Inzi ku balia balibamutana nsambu, balikuya bali ni nsansa, ni mapaalo aweme alikuya ali pali bene. ");
INSERT INTO tap_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Bwasuko bwa kisinka buli nga kufyompa pa milomo yakua kibuza. ");
INSERT INTO tap_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Wamia miilo yobe ya panze, ni kuteania bukaba bobe, mane ukuule nghanda yobe. ");
INSERT INTO tap_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Tekusininkizia bya bufi ku mwinobe pasili mulandu, ao kubeepa na milomo yobe. ");
INSERT INTO tap_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Tekulanda nangue, “Ndikumukitila nga vi-akinkitila. Ndikumulipa kukonkana ni vi-akikita.” ");
INSERT INTO tap_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Nakipita pepi ni bukaba bwa munanghani, ni pepi ni bukaba bwa mizabibu bwa muntu asili na maano, ");
INSERT INTO tap_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Ni mo mumenene sie myunga, ni bo bukupiliilue sie na lunkoto, ni kibumba kyakue kya mabue, kituutilue. ");
INSERT INTO tap_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Kupwako, nakenta, ni kulangakana, namona ni kusangapo masambilizio: ");
INSERT INTO tap_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Kulaala kaniini, ni kuona kaniini, kukunza maboko kaniini ni kutuuzia. ");
INSERT INTO tap_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Ni evi bupabi bwakaba kukwizila nga kabooko, ni kubulua kwakaba kukukonka nga kipoopoosi ali ni kilwilo. ");
INSERT INTO tap_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Aza i mapinda ange akua Solomoni, mapinda a-ambwilue na bantu bakua Hezekia likolo wa mu kyalo kya Yudea ");
INSERT INTO tap_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Kufiika keebo, bulumba bwakua Leza, inzi bulumba bwa makolo, kukebelezia keebo. ");
INSERT INTO tap_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Nga vili kuleepa kwa lyulu kuya mu muulu, ni kuzika kwa kyalo kuya pansi, ni mutima wa makolo i viusivinda kukebeleziiwa. ");
INSERT INTO tap_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Fumia biko mu mutofue, ni mutili wa mutofue alikukukitila kipe. ");
INSERT INTO tap_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Fumia babi ku menso akua likolo, ni kitebe kyakue kya bukolo kilikwimikua mu bulunghami. ");
INSERT INTO tap_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Tekwitantamuna pa menso akua likolo, ni kukeba kifuka pa bakindami. ");
INSERT INTO tap_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","Pantu kyawama kwanua nangue, “Iza kono ku ntanzi,” kukila kumoniiwa busoni pa bakindami. Kine kuli ni kawamonanga na menso obe, ");
INSERT INTO tap_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Tekubutukila kuya kusongela ku kilie, ukeeza kwandua kumana bya kukita ku mpeleezio mwinobe pa-akaba kukumonia busoni. ");
INSERT INTO tap_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Lanzyania ni mwinobe, kabili tekufyulilane tufiso. ");
INSERT INTO tap_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","Evi olia alikunvua tekuti akumonie busoni. Ukeeza kuleebulua mu bwikazi bobe bonse. ");
INSERT INTO tap_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Keebo kalikalandua pa musita upalile, kali nga nsombo ya oro ili mu kipe kya mutofue. ");
INSERT INTO tap_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Nga evelia vili lutimbi lwa oro, ni bifwanizio bya oro isambikile, i vili ni olia aliwasoka kutui kulikwanakila. ");
INSERT INTO tap_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Nga evelia vili kasama ka kibue musita wa kuzombola, i vili ni mukenzi wa kisinka ku olia amutumine. Pantu aliwasansamusia mutima wakua selenzi. ");
INSERT INTO tap_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Nga evelia vili malezi ni mwela pasili nvula, i vili ni olia aliwaitasia bufi palua kilambu kisipeenue. ");
INSERT INTO tap_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Mu kusipikizia, kateeka aliwalengiwa kuzumina, ni lulimi luteleele, lulilwatyona kakuza. ");
INSERT INTO tap_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Kine wasyukila kapelo, tekuliisia, ukeeza kwikuta ni kuluka. ");
INSERT INTO tap_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Kuulu kobe kuye kwali sie musita umo umo ku nghanda ya mwino, akeeza kunaka nobe ni kukusuula. ");
INSERT INTO tap_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Muntu aliwasininkizia mwinakue bya bufi, ali nga nondo ni kipanga, ni muvui unoonekele. ");
INSERT INTO tap_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Kuswapila muntu asiliwakisinka musita wa maavia, kuli nga liino libolele, ni mukonzo uvyukile. ");
INSERT INTO tap_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Nga evelia vili olia aliwavuula ngubo yakue musita wa kasama, kabili nga siki pa kilonda, i vili ni olia aliwaimba nghimbo ku muntu afinine mutima. ");
INSERT INTO tap_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Kine mulwani obe onvwile nzala, mupeele bilio, kabili kine onvwile kyaka, mupeele menda a kumina. ");
INSERT INTO tap_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","Mu kukita evi, ulikubiika mazekezeke a mulilo pa mutue wakue, ni Yawe alikukulambula. ");
INSERT INTO tap_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Nga vili mwela wa ku nkungua uliwaleeta nvula, i vili ni lulimi lulilwalengia muntu kufiitua. ");
INSERT INTO tap_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Kyawama kwikala mu kafuli ka mutenge wa nghanda, kukila kwikala mu nghanda pamo ni mukazi wa mazibo. ");
INSERT INTO tap_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Nga evelia vili menda a kasama ku muntu ali ni kyaka, i vili ni mpunda iweme ifumine kule. ");
INSERT INTO tap_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Mulunghami aliwalekelela mubi, ali nga kasulo ka menda kalikavunduka, kabili nga kiina kya menda kivundwilue. ");
INSERT INTO tap_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Nga evelia vikisipalile kuliisia kapelo, i vikisipalile ni kwikebela bulumba bobe we mwine. ");
INSERT INTO tap_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Olia asiliwateeka mutima wakue, ali nga muzi uli ni kibumba kituutikile. ");
INSERT INTO tap_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Nga evelia vili kibue musita wa likungulu, ni nvula musita wa buzombozi, ni mukinzi i viusipalile ku kipuba. ");
INSERT INTO tap_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Nga evelia vili munsole mu kuwayawaya kwakue, nga kamimbili mu kupupuka kwakue, i vili ni ntiipu ya mpuni isiizi kukwata muntu. ");
INSERT INTO tap_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Musepe wa kuuminako farasi, kikobelo kya kulombwelako punda, ni nfimbo ya kuuminako kipuba mu musana. ");
INSERT INTO tap_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Tekumwasuka kipuba mubeeleele bupuba bwakue, ukeeza kupalana nakue. ");
INSERT INTO tap_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Mwasuke kipuba mubeeleele bupuba bwakue, akeeza kwaluka wa mulangue ku menso akue mwine. ");
INSERT INTO tap_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Olia aliwalaizia kipuba kutwala mpunda, aliwaiputula makasa akue, ni kumina bwimba. ");
INSERT INTO tap_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Nga vilebeele maulu a mulema, i vili ni mapinda mu kanua ka kipuba. ");
INSERT INTO tap_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Nga vili libue lya mutengo mu topiito, i vili ni muntu aliwakindika kipuba. ");
INSERT INTO tap_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Nga vili musambo wa myunga mu kuboko kwakua kyakolua, I vili ni mapinda mu kanua ka kipuba. ");
INSERT INTO tap_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Nga vili muntu aliwalasa mivui ni kukisia bonse, i vili ni muntu aliwapeela miilo kipuba ao mupitanzila. ");
INSERT INTO tap_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Nga vili kabua kalikabwelela ku malusi akue, i vili ni kipuba aliwabweziapo kukita bya bupuba. ");
INSERT INTO tap_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Ewe, umwene muntu ali ni mulangue ku menso akue mwine? Kyawama kuswapila kipuba kukila wene. ");
INSERT INTO tap_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Munanghani aliwalanda nangue, “Mu nzila muli ni nkalamu, nkalamu asasile ali mu musebo ukata.” ");
INSERT INTO tap_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Nga vilivyazyungulusiiwa mulyango mu bulato bwakue, i vilivyaipilibula munanghani pa bulita bwakue. ");
INSERT INTO tap_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Munanghani aliwabiika kuboko kwakue mu nsaani, inzi aliwaunvua bunanghani bwa kutwala pa kanua kakue. ");
INSERT INTO tap_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Munanghani emwene kuba ni mulangue pa menso akue kukila bantu kilooba baliba-asuka ni maano. ");
INSERT INTO tap_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Olia aliwaingila mu mazibo asili akue, ali nga muntu aliwakwata ku matui a kabua kalimukupita. ");
INSERT INTO tap_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","18","Nga wa luuba vi-aliwapooza bikooko bya mulilo, ni mivui, bintu bilibyaipaana, ");
INSERT INTO tap_vpl VALUES ("PR26_19","021_26_19","PRO","26","19","19","i vili ni muntu aliwamubeepa mwinakue, ni kumwana nangue, “Ne nakiba nakusekia sie!” ");
INSERT INTO tap_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Mulilo uliwazima pantu tepali nkuni, ni pasili musongezi, tepali mazibo. ");
INSERT INTO tap_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Nga vitulitwazukunsia mazekezeke ao kukwikizia nkuni pa mulilo, i vili ni muntu mubi aliwasomenkezia mazibo. ");
INSERT INTO tap_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Twebo twa musongezi tuli nga bisoso biweme bya bilio, kabili tulitwakookela munda. ");
INSERT INTO tap_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Nga vili twebo twa kwiwaminizia ni mutima ubi, i vili ni keeso kakupilueko mutofue. ");
INSERT INTO tap_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Muntu asuulile bange aliwafyamina mu bulanzi bwakue, inzi aliwateeka bukonto bwa bupoti mu mutima wakue. ");
INSERT INTO tap_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Lualiwalanda twebo twaweme, tekumuketekela, pantu kuli bilubo kilooba bili mu mutima wakue. ");
INSERT INTO tap_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Anzia kukenda kwakue kuya kwafiikilue na bupoti, bubi bwakue bulibwamoneka pa menso a bantu. ");
INSERT INTO tap_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Olia aliwaimba kiina, waakaponenamo ye mwine. Kine wabulunkusia libue, lilikumubwelelela. ");
INSERT INTO tap_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Lulimi lwa bufi, lusuulile balia bakisiiziwe na lo, ni kanua ka kwiwaminizia, kalikaleeta lwinoono. ");
INSERT INTO tap_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Tekwitasia pa bya lukeele, pantu teumanine bilikukitika mu busiku bumo. ");
INSERT INTO tap_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Lekela muntu unge akutasie, tekuba kanua kobe we mwine, mweni, tekuba milomo yobe we mwine. ");
INSERT INTO tap_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Libue lifinine, ni musenga ulemene, inzi busokozi bwa kipuba bufinine kukila bebi bibili. ");
INSERT INTO tap_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Kikonko kibiipile, ni kipuki kili nga kibunda. Ale nani aliwavinda kwimana ku ntanzi ya bunkua? ");
INSERT INTO tap_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Kyawama kusasililua pa menso a bantu, kukila ntono ifiikilue. ");
INSERT INTO tap_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Kibuza kine wakukisia, muketekele, kukila miifyompo ya mulwani. ");
INSERT INTO tap_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Muntu ekusi, asuulile kapelo, inzi olia ali ni nzala, bilulile bilibyasonsa. ");
INSERT INTO tap_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Nga vili koni kalikawayawaya kule ni kinsua kyakue, i vili ni muntu aliwawayawaya kule ni nghanda yakue. ");
INSERT INTO tap_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Nga vili mafuta a bunu buweme ni bubaani, bilibyawamina mutima, i vili ni makola a bukibuza bwa muntu bulibwafuma mu mapange a mu mutima wakue. ");
INSERT INTO tap_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Kibuza obe ni kibuza wakua so, tekubalekela, kabili tekuti ukabe kuya mu nghanda mwa lupua lobe busiku bwa lyemo lyobe. Kyawamako mwinobe ali pepi kukila lupua luli kule. ");
INSERT INTO tap_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","We mwana wane, ba ni mulangue usansamusie mutima wane, evi n'mone mwakumwasukila olia aliwansasilila. ");
INSERT INTO tap_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Mukengezi aliwamona bubi ni kufyama, inzi babipuba balibaya sie ku ntanzi mpaka baikisia. ");
INSERT INTO tap_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Muntu kine walaya kulipila mizia ya muntu asimanikile, apokueko ngubo yakue nga kikwatizi, apokue kikwatizi pa mulandu wa ozo mweni. ");
INSERT INTO tap_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Olia aliwapaala kibuza wakue wasamwine lukeelekeele pakili, kyaakamoneka nga kitiipu. ");
INSERT INTO tap_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Mukazi wa mazibo, ali nga matooni a nvula aliatoonatoona busiku bwa nvula. ");
INSERT INTO tap_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Aliwakilikila ozo mukazi, aliwakilikila mwela, ao kukwata mafuta na kuboko kwakue kwa kulio. ");
INSERT INTO tap_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Nga kyela vikilikyanoona kyela nakue, ni muntu i vi-aliwasambiliziiwa na mwinakue. ");
INSERT INTO tap_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Olia aliwasunga kimuti kya miku aliwaliako mazabo, ni olia aliwasunga selenzi aliwakindikua. ");
INSERT INTO tap_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Nga lukebu vilulilwapalana na lukebu mu menda, ni muntu i vi-aimanine. ");
INSERT INTO tap_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Kumbo ni lwinoono tebyaikuta ata kaniini, ni menso a muntu te-ezi kwikuta ata kaniini. ");
INSERT INTO tap_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Mupika, i wakusungulwilamo mutofue, ni kikuka kya mulilo, i kya kwapikamo oro, inzi muntu aliwaeziiwa pa mulandu wa bulumba bwakue. ");
INSERT INTO tap_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Anzia ubuula mwinsi ni kumutua kipuba nga nghano, bupuba bwakue tebupua. ");
INSERT INTO tap_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Kita maka umane mibeele ya bisepe byobe, ni kusunga bwino nghombe yobe. ");
INSERT INTO tap_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","Pantu bukata tebwayayaya, ni ngala ya bukolo teyatwalilila mu nvyalo yonse. ");
INSERT INTO tap_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Musita uliwasebua lubambua, palipatutuka lunge, ni lubamba kufuma mu mpili lulilwakolonghaniiwa. ");
INSERT INTO tap_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Mikooko iliyakuleetela masako a kukitamo ngubo yobe, ni mbuzi wakaba kumusisia ni kusitamo makaba. ");
INSERT INTO tap_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Kabili ulikuya wali ni mabeele engi a mbuzi a kukutuusia pamo ni lupua lobe pamo ni kuliisia babombi bobe banakazi. ");
INSERT INTO tap_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Babi balibabutuka sie tekuba bakumbilue na muntu, inzi balunghami bapamine nga nkalamu. ");
INSERT INTO tap_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Pa mulandu wa bukisanguka bwa kyalo, bakateeka balibavula, inzi kateeka wa maano ni akengeele, aliwaleeta mutende. ");
INSERT INTO tap_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Mulombozi mupabi aliwaemia bapabi, ali nga nvula ya mwela iliyainoona bilio. ");
INSERT INTO tap_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Balia basilibakonka mizilo, balibatasia bubi, inzi balia balibakonka mafunde, balibakanzana nabo. ");
INSERT INTO tap_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Bantu babi tebamanine bilungheeme, inzi balia balibamukeba Yawe babimanine. ");
INSERT INTO tap_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Kyawama mupabi aliwaenda mu nsambu kukila munonsi ali mu nzila ibi. ");
INSERT INTO tap_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Olia aliwakonka mizilo, mwana wa mulangue, inzi kibuza wa bakazule, aliwamonia se busoni. ");
INSERT INTO tap_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Olia aliwavuzia bunonsi bwakue mu kukopia nfolanga ya kaloba, aliwakolonghaniizia muntu aliwaunvwila bapabi nkumbu. ");
INSERT INTO tap_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Olia aliwakilika kutui kwakue tekuti onvue mizilo, ni mapepo akue ni bilubo. ");
INSERT INTO tap_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Olia aliwalengia balunghami kuzeezelela mu nzila ibi, aliwaponena mu kiina kyakue mwine, inzi balia bapwililikile balibapyana biweme. ");
INSERT INTO tap_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Munonsi ali ni mulangue pa menso akue mwine, inzi mupabi ali ni maano, aliwamutoosia bwino bwino. ");
INSERT INTO tap_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Balunghami kine ba-anzia, bulumba bukata. Inzi babi kine i bateeka, bantu balibafyama. ");
INSERT INTO tap_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Olia aliwafiika bilubo byakue, tezi kulunduluka, Inzi olia aliwalapila ni kulekela, aliwaeleelua. ");
INSERT INTO tap_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Lisyuko ku muntu aliwatiina Yawe lyonse, inzi olia aliwafinia mutima wakue, aliwaponena mu busanzo. ");
INSERT INTO tap_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Nga vili nkalamu aliwabuluma, ni kimbui kilikyasakukila, i vili ni kateeka mubi aliwateeka bapabi. ");
INSERT INTO tap_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Kateeka asili na maano, aliwakila kubabiibikizia, inzi olia asiliwatokamua bunonsi bwa bupompo, aliwaikala nsiku ingi. ");
INSERT INTO tap_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Olia afiniinue na mulopa wa muntu, aliwaya wali mbutusi mpaka musita wa kufua kwakue. Tekuti kuye kwali muntu wa kumukwasia. ");
INSERT INTO tap_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Muntu aliwaenda mu bulunghami, aliwapususiiwa. Inzi olia ali ni kiitoni mu nzila yakue, aliwaponena mu kiina. ");
INSERT INTO tap_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","Olia aliwalima bukaba bwakue, ali ni bilio bingi. Inzi olia aliwakonka milandu ya mpuni waya wali ni bupabi bukata. ");
INSERT INTO tap_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Muntu wa kisinka, ali ni mapaalo engi. Inzi olia aliwakeba kunonka lubilo lubilo, aliwakandua. ");
INSERT INTO tap_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Kuba ni kitoolela ku bantu, tekuweme. Inzi muntu kuti waluvia pa mulandu wa kisoso kya mukate. ");
INSERT INTO tap_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Wa butani aliwatona kunonka lubilo lubilo, kabili tamanine nangue kuti wabulua. ");
INSERT INTO tap_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Olia aliwasasilila mwinakue, aliwatonua pa kyamba kukila olia aliwamulandila twebo twa kuwaminizia. ");
INSERT INTO tap_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Muntu aliwaiba bunonsi bwakua se ao bwakua nghina ni kulanda nangue, “Te kilubo,” ozo muntu, kibuza wakua nghinooni. ");
INSERT INTO tap_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Wa butani aliwabuusia mazibo, inzi olia amuswapiile Yawe, alikuba munonsi. ");
INSERT INTO tap_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Muntu eswapiile ye mwine, kipuba. Inzi olia aliwaendela mu mulangue, aliwapususiiwa. ");
INSERT INTO tap_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Muntu aliwakwasia bapabi tezi kubulua kantu, inzi olia aliwazibata, ali ni ntiipu ingi. ");
INSERT INTO tap_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Babi kine bateeka, bantu balibafyama. Inzi kine baloviiwa, balunghami balibavula. ");
INSERT INTO tap_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Olia aliwasokuasokua sie ni ye wakosia mutima, takakokola kutyoka, kabili takamona kwa kupusukila. ");
INSERT INTO tap_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Kine balunghami bapaalua, bantu balibasansamuka. Inzi mubi kine i wateeka, bantu balibalwala. ");
INSERT INTO tap_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Olia atonene mulangue, aliwasansamusia se. Inzi kibuza wa bakende, aliwazeezia bunonsi bwakue. ");
INSERT INTO tap_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Likolo aliwateeka kyalo kupitila mu nsambu. Inzi olia aliwapeelua bituulilo, aliwainoona kyalo. ");
INSERT INTO tap_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Olia aliwaiwaminizia ku mwinakue, aliwateyela mwinakue bukila. ");
INSERT INTO tap_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Mu kilubo kya muntu mubi, muli muteo. Inzi mulunghami aliwaimba ni kusangalala. ");
INSERT INTO tap_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Mulunghami aliwakenta twebo twa mupabi. Mubi tali na maano a kuti amane. ");
INSERT INTO tap_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Bantu bali ni kapuni balibazizia muzi. Inzi bantu bali ni mulangue balibapwisia kikonko. ");
INSERT INTO tap_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Kine wa mulangue wakanzana na kipuba, kipuba kine wafiitua, ao kine waseka, tepali mutende. ");
INSERT INTO tap_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Balia balibazuumia mulopa, basuulile olia apwililikile, Kabili balibakeba kwipaya balunghami. ");
INSERT INTO tap_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Kipuba aliwalanda na kipuki kyakue kyonse. Inzi wa mulangue, aliwaleeta mutende ku mpeleezio. ");
INSERT INTO tap_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Kateeka kine watwilizia bya bufi, babombi bakue bonse, baliba-aluka babi. ");
INSERT INTO tap_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Kintu kimo kili na mupabi ni aliwabiibikizyania ni keki: Yawe aliwabapeela bukose. ");
INSERT INTO tap_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Kine likolo aliwapingula mupabi mu kisinka, bukolo bwakue bwaya bwali bwa muyayaya. ");
INSERT INTO tap_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Nfimbo pamo ni kusasililua, bilibyaleeta mulangue. Inzi mwana aliwalekelelua pasili kukandua aliwamonia nghina busoni. ");
INSERT INTO tap_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Babi lubalibateeka, bubi bulibwavula. Inzi balunghami balibamona kupona kwabo. ");
INSERT INTO tap_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Kanda mwanao ni ye alikukuleetela mutende. Ee, alikusansamusia mutima obe. ");
INSERT INTO tap_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Palia pasili kimonua, bantu balibaya kiyeyeye. Inzi olia aliwakonka mizilo, ali ni nsansa. ");
INSERT INTO tap_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Mubombi tezi kusokua sie na twebo, pantu anzia amana tapoozako maano. ");
INSERT INTO tap_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Kubako umumanine olia aliwalanda kilandelande? Kyawama kuketekela kipuba kukila muntu wa ozu musango. ");
INSERT INTO tap_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Olia aliwasunga mubombi wakue kutula ku bwanike bwakue, pa mpeleezio waakamusangukila. ");
INSERT INTO tap_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Muntu wa kipuki aliwalengia mazibo. Ni muntu wa kipuki kikata aliwalengia bibalo bingi. ");
INSERT INTO tap_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Kiitoni kya muntu kilikyamukoosia. Inzi mufuuke aliwakindikua. ");
INSERT INTO tap_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Olia aliwa-ampana na kabooko, asuulile mutima wakue mwine. Aliwaunvua ntiipu yatiipua, inzi tekuba walanda kantu. ");
INSERT INTO tap_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Kutiina bantu, muteo wa kukuleetela busanzo. Inzi olia amuswapiile Yawe, ali ni mutende. ");
INSERT INTO tap_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Bengi balibakeba kutonua na kateeka. Inzi nsambu ya muntu iliyafuma kuli Yawe. ");
INSERT INTO tap_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Muntu mubi, asuulile balunghami. Ni mulunghami, asuulile babi. ");
INSERT INTO tap_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Bobu i bulanzi bwa mponvu bwakua Aguri mwina Yake, kuli Itieli ni Ukali. “We Leza wandekeela, we Leza wandekeela, kabili n'mpeleelelue. ");
INSERT INTO tap_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","Kisinka nene ndi kipuba kukila bantu bonse. Kabili nsili na maano a bumuntu. ");
INSERT INTO tap_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Nsyaasambiliile mulangue, kabili nsimanine twebo twakua Muzuuke. ");
INSERT INTO tap_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Nani waaselele mwiulu ni kukooka pansi? Nani waakolonghaniizie mwela mu minue yakue? Nani waakakile menda mu ngubo yakue? Nani waimikile mpeleezio yonse ya kyalo? Liina lyakue nani? Liina lyakua mwana wakue nani? Nghane kine umanine! ");
INSERT INTO tap_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","“Kubalua keebo kakua Leza kasininkiziiziwe. Wene i kisoolelo kya balia balibabutukilamo. ");
INSERT INTO tap_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Tekulundapo pa twebo twakue, akeeza kukusasilila ni we wamoneka kuba wa bufi. ");
INSERT INTO tap_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","“We Yawe nakulomba bintu bibili. Tekuti ukabe kuntana ntanzi ya kufua kwane: ");
INSERT INTO tap_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Fumia bupunzu ni bufi pali nene. Tekun'mpeela bupabi ao bunonsi, inzi n'mpeeleko bilio byane bya kubalua nsiku. ");
INSERT INTO tap_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Pantu kine byanvulila ndikwikuta ni kukulaba nalanda nangue, ‘Yawe nani?’ Ao tekuti ngie nali mupabi ni kuya naiba, Ni kuleebuzia Liina lyakua Leza wane. ");
INSERT INTO tap_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","“Tekubeepezia mubombi kuli selenzi, akeeza kukutiipa ni we wamoneka kuba wa kilubo. ");
INSERT INTO tap_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","“Kuli ni luvyalo lulilwatiipa basibo, kabili tebezi kupaala ba nghinabo. ");
INSERT INTO tap_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Kuli ni luvyalo luswetele ku menso abo bene, inzi telwaasambilue biko byabo. ");
INSERT INTO tap_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Kuli ni luvyalo lukilile kulendula menso abo! Nkopio yabo ni yo yalendwilue. ");
INSERT INTO tap_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Kuli ni luvyalo luli ni meno nga kipanga ni lumuma nga myele, pakuti baye balia bapabi ni kubalovia pa kyalo pamo ni balia babuliilue pakati ka bantu. ");
INSERT INTO tap_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","“Mupoti, ali na bakazyana babili balibalila nangue, ‘N'mpeele, N'mpeele.’ “Kuli bintu bitatu bisilibyaikuta ata kaniini. Ee, bina bisilibyalanda nangue, ‘Byavula.’ ");
INSERT INTO tap_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","Kilibu, kavumo ka nghumba, ni bulongo busilibwaikuta menda, pamo ni mulilo usiliwalanda nangue, ‘Byavula.’ ");
INSERT INTO tap_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","“Linso lya muntu aliwafuupula se, ni kufuupula nghina, lyaakakompua na bizooko bya mu lulambe, ni twina nzwiba twaakalilia. ");
INSERT INTO tap_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","“Kuli bintu bitatu bilibyan'mpezia maano. Ee, bintu bina binsimanine, ");
INSERT INTO tap_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","Lwendo lwa nzwiba mu lweleele, lwendo lwa kizoka pa mwalala, lwendo lwa bwato pa menda, ni lwendo lwa mwalalume ali ni mukazyana. ");
INSERT INTO tap_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","“I vili ni nzila ya mwanakazi mukende. Aliwalia ni kupukusa pa kanua kakue, ni kulanda nangue, ‘Nsiluviizie.’ ");
INSERT INTO tap_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","“Pa mulandu wa bintu bitatu, kyalo kilikyatenta, ni pa mulandu wa bintu bina kilikya-andua kusipikizia. ");
INSERT INTO tap_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Pa mulandu wa muzia lu-aliwa-aluka likolo, ni kipuba kine waikuta bilio. ");
INSERT INTO tap_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","Pa mulandu wa mwanakazi abiipile kine waupua, ni mubombi mwanakazi aliwapokolola kyupo kyakua nghinalenzi. ");
INSERT INTO tap_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","“Kuli bilengua bina bikeepele mu kyalo. Inzi bili ni maano engi. ");
INSERT INTO tap_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","Mpazi, ni bilengua bisili na maka. Anzia evio, iliyaibiikila bilio pa musita wa likungulu. ");
INSERT INTO tap_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","Bibila, ni bilengua bisili na maka. Anzia evio, bilibyaikitila nghanda mu mabue. ");
INSERT INTO tap_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","Nzie, teili na likolo. Anzia evio, iliyabuukila pamo mu mabumba. ");
INSERT INTO tap_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","Lunso, kuti wakwatua na minue. Anzia evio, aliwaikala mu nghanda mwa likolo. ");
INSERT INTO tap_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","“Kuli bilengua bitatu bilibyaenda lwendo lufwaniine. Ee, bina bili ni lwendo luweme. ");
INSERT INTO tap_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","Nkalamu ali ni maka pa nama yonse, asiizi kutiina nama inge yonse. ");
INSERT INTO tap_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","Kazenze kalikaenda kaikenkenta, pamo ni kapwata, ni likolo azyungulukiilue na balukale bakue. ");
INSERT INTO tap_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","“Kine ukitile bya bupuba ni kuya waitantamuna, ao kine ukambiile kukita bibiipile, biika kuboko kobe pa kanua kobe. ");
INSERT INTO tap_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Pantu kine wafulumia mabeele a nama ulikusanga manteka. Kuuma pa moona kulikwafumia mulopa. Ni kusomenkezia kipuki kulikwaleeta mazibo.” ");
INSERT INTO tap_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Bulanzi bwakua likolo Lemueli, bu-aasambiliziiziwe na nghina. ");
INSERT INTO tap_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","We mwana wane, twilizia! Twilizia, we mwana wa munda mwane! Twilizia, we mwana wane, we bwasuko bwa mapepo ane. ");
INSERT INTO tap_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Tekupeela banakazi maka obe, ao nzila yobe ku balia balibavulunghania likolo. ");
INSERT INTO tap_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","We Lemueli, makolo teapalile kumina divai, Makolo teapalile. Ao bakindami kutokamua bikolani. ");
INSERT INTO tap_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Bakeeza kukolua ni kulaba mizilo, bakeeza kubiibikizia nsambu ya muntu aliwaema. ");
INSERT INTO tap_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Bwalua bululile, ni ku balia balimukuzeeza. Ni divai, ni ku balia bali ni bulanda bukata mu mutima. ");
INSERT INTO tap_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Baleke bamine ni kulaba bupabi bwabo, evi tekuti baye balanguluka nghemo yabo ata kaniini. ");
INSERT INTO tap_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Landilako bakameme bonse, ni kusampulula balia basili na wa kubakwasia. ");
INSERT INTO tap_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Asamuna kanua kobe upingule mu nsambu. Bapabi pamo ni babuliilue, ubapeele nsambu yabo. ");
INSERT INTO tap_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Mwanakazi wa mibeele iweme alikumonekela pi? Pantu mutengo wakue ukilile mabue a mutengo. ");
INSERT INTO tap_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Mutima wakua mulume wakue umuketekeele, ni ye takabula kibwezia. ");
INSERT INTO tap_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Aliwamukitila biweme tekuba bibiipile, nsiku yonse ya bukose bwakue. ");
INSERT INTO tap_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Aliwakeba sufu ni kitani, ni kubomba miilo yakue na mutima onse. ");
INSERT INTO tap_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Wene ali nga bwato bwa makwebo. Aliwaleeta bilio byakue kufuma kule. ");
INSERT INTO tap_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Aliwabuuka paakili lukeelekeele, aliwapeela bilio ku bantu ba mu nghanda yakue, ni babombi bakue banakazi miilo yabo. ");
INSERT INTO tap_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Aliwakenta bukaba ni kubusita. Mu bikwatua bya mu minue yakue i mu-aliwabyalila bukaba bwa mizabibu. ");
INSERT INTO tap_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Aliwabomba miilo yakue na maka, ni kulumia maboko akue. ");
INSERT INTO tap_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Aliwamona nangue makwebo akue ali ni kibwezia. Musaniko wakue tewizi kuzima musita wa busiku. ");
INSERT INTO tap_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Aliwasuka nyunzi na minue yakue, ni maboko akue akwatiliile. ");
INSERT INTO tap_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Aliwaolola maboko akue ku bapabi, ee, aliwaolwela maboko akue ku babuliilue. ");
INSERT INTO tap_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Tezi kutiina kasama pa mulandu wa bantu ba mu nghanda yakue, pantu bonse ba mu nghanda yakue bavwikilue ngubo ya kasi. ");
INSERT INTO tap_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Aliwaikitila ngubo ya pa bulita bwakue. Aliwavwala ngubo ya kitani kiweme ni ya mukumino wa bulumbi. ");
INSERT INTO tap_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Mulume wakue amanikile mu milyango, lu-aliwaikala pakati ka masiiko a kyalo. ");
INSERT INTO tap_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Aliwakita ngubo ya kitani ni kusisia. Aliwasisia misipi ku basulu. ");
INSERT INTO tap_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Maka ni mukinzi i ngubo yakue. Aliwasekelela pa mulandu wa musita uliwaiza. ");
INSERT INTO tap_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Aliwa-asamuna kanua kakue na mulangue, ni mizilo ya buwame ili mu kanua kakue. ");
INSERT INTO tap_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Aliwakentesia nzila ya bantu ba mu nghanda yakue, kabili tezi kulia bilio bya bunanghani. ");
INSERT INTO tap_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Baana bakue balibamukuuta lisyuko. Mulume wakue aliwamukuuta evio vyenka, ni kumutasia walanda nangue, ");
INSERT INTO tap_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","“Bakazyana bengi balibakita biweme, inzi wewe ukilile bonse.” ");
INSERT INTO tap_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Monekelo iliyabeepa, ni kuwama kwa lukebu, ni kwa mpuni. Inzi mwanakazi aliwatiina Yawe i aliwatasiiwa. ");
INSERT INTO tap_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Mukindike mu byonse bi-aliwakita na maboko akue, ni miilo yakue imuleetela mukinzi ponse.");
INSERT INTO tap_vpl VALUES ("HS1_1","029_1_1","HOS","1","1","1","Keebo kakua Yawe kaizile kuli Hosea mwana mwalalume mwina Beri, mu nsiku ya kuteeka kwakua Uzia, ni Yotamu, ni Ahazia, pamo ni Hezekia, makolo a mu Yuda, ni mu nsiku yakua Yeroboamu mwana mwalalume mwina Yoasi, likolo wa mu Izraeli. ");
INSERT INTO tap_vpl VALUES ("HS1_2","029_1_2","HOS","1","2","2","Yawe lu-aatendekele kulanda na Baizraeli, waamwanine Hosea nangue, “Endo uupe mwanakazi mukende ni kuvyala nakue baana, pantu bantu ba mu keno kyalo ba-aluka ni bubi bwa kukita bukende mu kunfunghamina ne Yawe.” ");
INSERT INTO tap_vpl VALUES ("HS1_3","029_1_3","HOS","1","3","3","Ni kiine Hosea waile kuupa Gomeri mwana mwanakazi mwina Diblaimu. Gomeri waimitile ni kumuvyalila mwana mwalalume. ");
INSERT INTO tap_vpl VALUES ("HS1_4","029_1_4","HOS","1","4","4","Kupwako Yawe wamwana Hosea nangue, “Ozu mwana mwinike ‘Yezreeli,’ pantu pasyankabe kukanda nghanda ya bukolo bwakua Yehu pa mulandu wa bungipaani bwa ku Yezreeli, ni ne nakaba kupwisia bukolo bwakua Izraeli. ");
INSERT INTO tap_vpl VALUES ("HS1_5","029_1_5","HOS","1","5","5","Mu bobo busiku nakaba kutyona buta bwakua Izraeli mu lulambe lwa ku Yezreeli.” ");
INSERT INTO tap_vpl VALUES ("HS1_6","029_1_6","HOS","1","6","6","Gomeri waimitile paakale ni kuvyala mwana mwanakazi. Kabili Yawe waamwanine Hosea nangue, “Ozu mwana mwinike Lo-Ruhama, pantu nsikikaba kulanga ntono pa nghanda yakua Izraeli evi tekuti nkabeeleele. ");
INSERT INTO tap_vpl VALUES ("HS1_7","029_1_7","HOS","1","7","7","Inzi nakaba kulanga ntono pa nghanda yakua Yuda. Ne Yawe Leza wabo i wakaba kubapususia pasili kubombia buta ao kipanga, ao bului, pasili kubombia farasi ao baseli ba pa farasi.” ");
INSERT INTO tap_vpl VALUES ("HS1_8","029_1_8","HOS","1","8","8","Gomeri lu-aamusumwine Lo-Ruhama, waavyele ni unge mwana mwalalume. ");
INSERT INTO tap_vpl VALUES ("HS1_9","029_1_9","HOS","1","9","9","Kabili Yawe waamwanine Hosea nangue, “Ozu mwana mwinike Lo-Ami, pantu mwe temuli bantu baane, ni ne nsili Leza wenu.” ");
INSERT INTO tap_vpl VALUES ("HS1_10","029_1_10","HOS","1","10","10","Anzia kili evio, Baizraeli baakaba nga musenga wa mumbali buziba ozo ukilile kuvula ni usili wapendeka. Kolia kuba-aninue nangue, “Temuli bantu bane,” baakakuutua nangue, “Muli bena Leza mukose.” ");
INSERT INTO tap_vpl VALUES ("HS1_11","029_1_11","HOS","1","11","11","Bayuda ni Baizraeli baakalundana paakale ni kusaakula mulombozi umo, ni bo baakabwelela ku kyalo kyabo, pantu busiku bulibwakuutua Yezreeli bwaakaba busiku bukata. ");
INSERT INTO tap_vpl VALUES ("HS2_1","029_2_1","HOS","2","1","1","Mu bobo busiku waakakuuta ba kobe nangue Ami, “Bantu bane.” Ni bankaziizo nangue Ruhama, “Batonua bane.” ");
INSERT INTO tap_vpl VALUES ("HS2_2","029_2_2","HOS","2","2","2","Sasilile nghinenue, musasilile, pantu wene takili mukazi wane, ni nene nsikili mulume wakue. Mwane alekele mibeele ya bukende mu monekelo yakue ni bukende pa bukata bwa mabeele akue. ");
INSERT INTO tap_vpl VALUES ("HS2_3","029_2_3","HOS","2","3","3","Kine te evio nakaba kumuvuula ngubo yakue, ni kumusia mu-aavyaliilue. Nakaba kumukita nga kaseeba, nakaba kumwalula kuba musili uume, ni kumwipaya na kyaka. ");
INSERT INTO tap_vpl VALUES ("HS2_4","029_2_4","HOS","2","4","5","Baana bakue nsikabonvwila nkumbu, pantu ni baana ba mu bukende. Nghinabo tali na bukisinka, wakibeemita mu nzila isipalile. Gomeri waalandile evi, “Ndikukonkelela batonua bane, balia baliban'mpeela bilio, ni baliban'mpeela menda. Baliban'mpeela ngubo ya masako a nama ni kitani, ni mafuta a mizeituni, pamo ni bikolani.” ");
INSERT INTO tap_vpl VALUES ("HS2_6","029_2_6","HOS","2","6","6","Ni pakako, ne Leza nakaba kusaka nzila yakue na myunga, nakaba kumukingilila mukati luuba, evi tekuti akamone pa kupitila. ");
INSERT INTO tap_vpl VALUES ("HS2_7","029_2_7","HOS","2","7","7","Gomeri waakakonkelela batonua bakue, inzi takabasanga. Waakabakeba, inzi takabamona. Pa kyamba waakalanda nangue, “Ndikubwela sie ku mulume wane wa mambo, pantu naali nali bwino kukila lenu.” ");
INSERT INTO tap_vpl VALUES ("HS2_8","029_2_8","HOS","2","8","8","Gomeri tainikile nangue nene i waamupeele bintu byonse bi-ali nabio, nghano ni divai ya lenu pamo ni mafuta a mizeituni, nene i waamunonsiizie mutofue ni oro ibaali babombia mu kumubombela leza Baali. ");
INSERT INTO tap_vpl VALUES ("HS2_9","029_2_9","HOS","2","9","9","Ni pakako, nakaba kupokolola nghano yane musita wa kuzombola, ni divai yane ya lenu pa kyamba kya kutika, nakaba kupokolola ngubo yane ya masako pamo ni kitani kyane, bebio byaali byapalile kukupa mubili wakue. ");
INSERT INTO tap_vpl VALUES ("HS2_10","029_2_10","HOS","2","10","10","Ni evi, naakamuvuula ni kumusia mu-aavyaliilue ntanzi ya batonua bakue. Tekuli muntu waakamupokolola mu minue yane. ");
INSERT INTO tap_vpl VALUES ("HS2_11","029_2_11","HOS","2","11","11","Naakapwisia maliila akue onse, nsikunkulu yakue ya kubalua mwaka, ni ya kubaluka kwa kwezi, ni nsiku yakue ya Sabata, nsikunkulu yakue yonse itantikilue. ");
INSERT INTO tap_vpl VALUES ("HS2_12","029_2_12","HOS","2","12","12","Naakenoona mizabibu yakue ni bimuti byakue bya miku, bebio bi-aliwalanda nangue i nsazio yakue i-aapeelue na batonua bakue. Ni ne naakalengia mizabibu ni bimuti bya miku kuba musitu, ni nama ya mu kisonso yaakalia mazabo abio. ");
INSERT INTO tap_vpl VALUES ("HS2_13","029_2_13","HOS","2","13","13","Naakamukanda pa mulandu wa ezio nsiku i aafunkiziizie bubaani kuli leza Baali, lu-aifwaniizie na tuzele twa ku minue ni binge bifwanizio bya mutengo, ni kuya kubembia batonua bakue, inzi nene wandabile, koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("HS2_14","029_2_14","HOS","2","14","14","Ni pakako, nakaba kumubembia, nakaba kumulombola mu kaseeba ni kwambaula nakue mubufuuke. ");
INSERT INTO tap_vpl VALUES ("HS2_15","029_2_15","HOS","2","15","15","Koko, i kunakaba kumubweziizia makaba akue a mizabibu, ni lulambe lwa Akori nakaba kulukita kuba mulyango wa maswapi. Koko i ku-akaba kwimba lwimbo nga vi-aali waimba ku bukazyana bwakue, nga mu bolia busiku bu-aafumine ku Misri. ");
INSERT INTO tap_vpl VALUES ("HS2_16","029_2_16","HOS","2","16","16","Yawe walanda nangue, “Mu bobo busiku, wewe waakankuuta nangue, ‘Mulume wane.’ Teukikankuuta nangue, ‘leza wane Baali.’ ");
INSERT INTO tap_vpl VALUES ("HS2_17","029_2_17","HOS","2","17","17","Naakafumia meena a baleza baliwakuutua Baali mu milomo yakue, ni meena abo takika-azimbula. ");
INSERT INTO tap_vpl VALUES ("HS2_18","029_2_18","HOS","2","18","18","Mu ezio nsiku naakakita kipingo pa mulandu wa Baizraeli, ni nama ya mu kisonso ni tooni twa mulweleele, pamo ni bilengua bilibyayibula pansi. Buta, ni kipanga pamo ni bului, naakabifumia mu kyalo, evi bonse bakabe baikeele mu mutende. ");
INSERT INTO tap_vpl VALUES ("HS2_19","029_2_19","HOS","2","19","19","Naakakusaka we Izraeli kuti ukabe wane muyayaya, naakakusaka mu nsambu ni mu bulunghami, mu ntono ni mu nkumbu. ");
INSERT INTO tap_vpl VALUES ("HS2_20","029_2_20","HOS","2","20","20","Naakakusaka kuti ukabe wane mu kisinka, ni we waakanghinika nangue nene i Yawe. ");
INSERT INTO tap_vpl VALUES ("HS2_21","029_2_21","HOS","2","21","22","“Mu bobo busiku naakaasuka,” nangue Yawe, “naakaasuka myulu, myulu ni yo yaakaasuka kyalo, ni kyalo kyaakaasuka mbezu, ni divai ya lenu ni mafuta a mizeituni, ni bebi byonse byaakamwasuka Yezreeli. ");
INSERT INTO tap_vpl VALUES ("HS2_23","029_2_23","HOS","2","23","23","Naakamulimba Yezreeli mu kyalo. Naakalanga ntono yane ku olia unainikile Lo-Ruhama. Balia banainikile Lo-Ami, naakabaana nangue, ‘Muli bantu bane,’ ni bo baakalanda nangue, ‘Uli Leza wetu.’” ");
INSERT INTO tap_vpl VALUES ("HS3_1","029_3_1","HOS","3","1","1","Yawe wanghanine nangue, “Endo ubwezyanie paakale na mukazi obe ni kumulanga ntono anzia kine atonenue na unge ni kuya wakita nakue bukende. Mutone nga ne Yawe vintonene Baizraeli, anzia kine balibabwelela ku kupupa bange baleza ni kutona kubeelela mikate isonsele ilimo mizabibu yume.” ");
INSERT INTO tap_vpl VALUES ("HS3_2","029_3_2","HOS","3","2","2","Ni pakako, naamusitile paakale na shekeli lyanondo ni isaano ya mutofue, ni kilo 195 ya shairi. ");
INSERT INTO tap_vpl VALUES ("HS3_3","029_3_3","HOS","3","3","3","Pa kyamba naamwanine nangue, “Upalile kwikala ni nene nsiku ingi ni kulekela bukende ao kwampana na mwalalume unge. Ni nene nsikakeba mwanakazi unge.” ");
INSERT INTO tap_vpl VALUES ("HS3_4","029_3_4","HOS","3","4","4","Evi Baizraeli ni bo i vibaakeekala nsiku ingi pasili kuba na likolo ao mukulu, kabili tebakaba na ngelelo, ao mabue azuuke, ao efodi, ao mikisi. ");
INSERT INTO tap_vpl VALUES ("HS3_5","029_3_5","HOS","3","5","5","Pa kyamba, Baizraeli baakabwela kumukeba Yawe Leza wabo, ni likolo wa mu luvyalo lwakua Daudi. Mu nsiku ya mpeleezio baakeeza balimukumututumina Yawe, ni kututumina mapaalo. ");
INSERT INTO tap_vpl VALUES ("HS4_1","029_4_1","HOS","4","1","1","Mwe Baizraeli, unvue keebo kakua Yawe, pantu Yawe alimukumisongela mwe bekeele mu kyalo walimukulanda nangue, “Mu kyalo temuli bukisinka ni ntono, kwinika Leza tekulimo. ");
INSERT INTO tap_vpl VALUES ("HS4_2","029_4_2","HOS","4","2","2","Muli sie ntiipu, bufi ni bungipaani, bukabooko pamo ni bukende mwaya kyalo, ni bungipaani tekuba bwapua. ");
INSERT INTO tap_vpl VALUES ("HS4_3","029_4_3","HOS","4","3","3","Ni pakako, kyalo kilimukulilooka, ni bonse bekeelemo baakafua. Nama ya mu kisonso ni tooni twa mu lweleele, pamo ni masabi a mu lyezi byaakafua. ");
INSERT INTO tap_vpl VALUES ("HS4_4","029_4_4","HOS","4","4","4","“Kubalua muntu tekuti aye wasongela mwinakue, kubalua muntu tekuti aye wamwitendookela mwinakue, pantu bantu bobe bali nga balia balibasongela kitambua. ");
INSERT INTO tap_vpl VALUES ("HS4_5","029_4_5","HOS","4","5","5","Wewe uliwaipuutala busiku ni koba, bakabika ba bufi balibaipuutala pamo nobe. Ni pakako, nakaba kumulovia noko. ");
INSERT INTO tap_vpl VALUES ("HS4_6","029_4_6","HOS","4","6","6","Bantu baane bainooneka pa mulandu wa kusimana. “Pa mulandu wa kukaana bukengezi, ni ne ndikumikaana tekuti muye mwali babitambua bane. Pa mulandu wa kukaana mizilo yane ne Leza wenu, ni ne nsipoozako maano ku baana benu. ");
INSERT INTO tap_vpl VALUES ("HS4_7","029_4_7","HOS","4","7","7","Kukonkana ni vivulile babitambua, i vivulile ni bibalo bibaliban'mbala. Naakaalula bulumba kuba busoni. ");
INSERT INTO tap_vpl VALUES ("HS4_8","029_4_8","HOS","4","8","8","Balibalia ngelelo ya bibalo iliyaleetua na bantu bane, ni kuwaminua na bubi bwa bantu bane. ");
INSERT INTO tap_vpl VALUES ("HS4_9","029_4_9","HOS","4","9","9","Ni pakako, vilivyakita babitambua, i vilivyakita ni bantu. Bonse babili naakabakanda kukonkana ni misango yabo, ni kubasazia mubeeleele bikitua byabo. ");
INSERT INTO tap_vpl VALUES ("HS4_10","029_4_10","HOS","4","10","10","“Anzia bakalia, tebakeekuta, anzia bakakambula, tebakaba na baana, pantu baamufunghamiine Yawe ni kukonkelela baleza bange.” ");
INSERT INTO tap_vpl VALUES ("HS4_11","029_4_11","HOS","4","11","11","Kukita bukambue, ni kumina divai ya kale pamo ni ya lenu, bebio i bilibyabalengia kusiba na bukengezi. ");
INSERT INTO tap_vpl VALUES ("HS4_12","029_4_12","HOS","4","12","12","Bantu bane balibalomba nsokezi ku mukisi wa kimuti, ni kuya ba-asukua na kabango ka kimuti. Mutima wa bukambue uliwabazeezia. Tebali na bukisinka kuli Leza wabo. ");
INSERT INTO tap_vpl VALUES ("HS4_13","029_4_13","HOS","4","13","13","Balibaelela ngelelo peulu lupili, ni ngelelo ya kuziziiwa peulu tupili, mwinsina bimuti bya oaki, ni bya popla pamo ni bya terebenti, momo muli bulelo buweme. Ni pakako, baana benu bakazyana i kibalimukukitila bukambue, ni bamuka baana benu i kibalimukukitila bukende. ");
INSERT INTO tap_vpl VALUES ("HS4_14","029_4_14","HOS","4","14","14","“Nsikakanda baana benu banakazi lubalibaakita bukambue. Ao bamuka baana benu lubalibakita bukende, pantu balalume bene i balibakita bukambue, ni kwelela ngelelo pamo ni bakambue. Balibaelela pa nkendo ya kupupilapo nga mulandiile mapinda nangue, ‘Bantu basikengeele, balobele.’” ");
INSERT INTO tap_vpl VALUES ("HS4_15","029_4_15","HOS","4","15","15","“We Izraeli! Anzia kine wakikita bukende, tekumulengia Yuda kuba ni bubi. “Tekuya kupupa ku Gilgali, ao ku Bet-Aveni. Kabili tekuye kukitako mulapo nangue, ‘mu Liina lyakua Yawe mukose.’” ");
INSERT INTO tap_vpl VALUES ("HS4_16","029_4_16","HOS","4","16","16","Baizraeli, bataale nga nghombe musoka. Kubako Yawe kuti wabasunga syani nga mikooko mu bikusi bibisi? ");
INSERT INTO tap_vpl VALUES ("HS4_17","029_4_17","HOS","4","17","17","Efraimu wailunda ku mikisi, musie bunke. ");
INSERT INTO tap_vpl VALUES ("HS4_18","029_4_18","HOS","4","18","18","Banombozi ba Baizraeli lubalibapua bikolani byabo, balibatwalilila mu bukambue bwabo, ni kutonesia mibeele ya busoni. ");
INSERT INTO tap_vpl VALUES ("HS4_19","029_4_19","HOS","4","19","19","Mulula wakaba kubapyangila kule, ni ngelelo yabo yakaba kubaleetela busoni. ");
INSERT INTO tap_vpl VALUES ("HS5_1","029_5_1","HOS","5","1","1","“Mwe babitambua unvue! Poozeko maano mwe Baizraeli! Mwe nghanda ya bukolo twilizie! Bobu bupinguzi ni pa mulandu wenu: Mwemue mwaali muteo ku Misipa, bukila buteelue pa lupili lwa Tabori. ");
INSERT INTO tap_vpl VALUES ("HS5_2","029_5_2","HOS","5","2","2","Babisanguka bakila kwipaana. Nene nakaba kubakanda bonse. ");
INSERT INTO tap_vpl VALUES ("HS5_3","029_5_3","HOS","5","3","3","N'manine byonse palwakua Efraimu, Izraeli tanfyeme. We Efraimu, watendeka kukita bukambue, Izraeli waitiikania. ");
INSERT INTO tap_vpl VALUES ("HS5_4","029_5_4","HOS","5","4","4","“Bikitua byabo tebibetabiizie, kubwela kuli Leza wabo. Mupasi wa bukambue uli mu mitima yabo, tebamumanine Yawe. ");
INSERT INTO tap_vpl VALUES ("HS5_5","029_5_5","HOS","5","5","5","Izraeli wasininkiziiwa na kiitoni kyakue. Baizraeli ni Efraimu baipuutala mu bibalo byabo. Yuda ni ye waipuutala pamo nabo. ");
INSERT INTO tap_vpl VALUES ("HS5_6","029_5_6","HOS","5","6","6","Lubalibaya ni mikooko yabo pamo ni nghombe, kuya kumukeba Yawe, tebezi kumusanga, pantu abafunghamiine. ");
INSERT INTO tap_vpl VALUES ("HS5_7","029_5_7","HOS","5","7","7","Tebakili ba kisinka kuli Yawe. Bakivyala baana mu bukambue. Nsikunkulu yabo ya kubaluka kwa kwezi yaakabalovia, pamo ni makaba abo. ");
INSERT INTO tap_vpl VALUES ("HS5_8","029_5_8","HOS","5","8","8","“Lizie ntandala mu Gibea, lisengo mu Rama. Samune lizui lya bului mu Bet-Aveni, mu kyamba kyobe we mukowa wakua Benyamina. ");
INSERT INTO tap_vpl VALUES ("HS5_9","029_5_9","HOS","5","9","9","Efraimu waakasiiwa kibolia mu nsiku ya kukandua. Bindimukulanda pa mikowa ya Baizraeli ni bya kisinka. ");
INSERT INTO tap_vpl VALUES ("HS5_10","029_5_10","HOS","5","10","10","Banombozi ba Bayuda bali nga bantu balibatelulula mabue a mu mipaka pasili nsambu. Naakapongola kikonko kyane pali bene nga kibunda kya menda. ");
INSERT INTO tap_vpl VALUES ("HS5_11","029_5_11","HOS","5","11","11","Efraimu waemiiwa, wabiibikiziiwa mu bupinguzi, pakafi ka kutona kupupa mikisi. ");
INSERT INTO tap_vpl VALUES ("HS5_12","029_5_12","HOS","5","12","12","Nene ndi nga nondo kuli Efraimu, ndi nga kintu kibolele ku Bayuda. ");
INSERT INTO tap_vpl VALUES ("HS5_13","029_5_13","HOS","5","13","13","“Efraimu lu-aamwene bulwele bwakue, ni Yuda bilonda byakue, Efraimu i lu-aile ku Asuria, ni kutuma mikenzi ya kuya kulomba bukwasi kuli likolo mukulu. Inzi tali na buvinde bwa kumikosia, ao kukosia bilonda byenu. ");
INSERT INTO tap_vpl VALUES ("HS5_14","029_5_14","HOS","5","14","14","Ni pakako, naakaba nga nkalamu kuli Efraimu, nga nkalamu asasile kuli Yuda. Naakabazanghununa tuniini tuniini ni kuya, naakabatwala kule kusikaba wa kubapususia. ");
INSERT INTO tap_vpl VALUES ("HS5_15","029_5_15","HOS","5","15","15","Pa kyamba, naakabwelela pa kifuka kyane mpaka musita ubaakeetabila bubi bwabo ni kukeba lukebu lwane. Mu maavia abo baakankeba na mute.” ");
INSERT INTO tap_vpl VALUES ("HS6_1","029_6_1","HOS","6","1","1","“Ize tubwelele kuli Yawe. Wakituzanghununa tuputu tuputu, inzi wakaba kutukosia. Wakitukisia, inzi wakatukakilila bilonda byetu ni kutundapa. ");
INSERT INTO tap_vpl VALUES ("HS6_2","029_6_2","HOS","6","2","2","Pa kyamba kya nsiku ibili wakaba kututuntumuna. Mu busiku bwa butatu wakaba kutubuusia, pakuti tukabe bakose pa ntanzi yakue. ");
INSERT INTO tap_vpl VALUES ("HS6_3","029_6_3","HOS","6","3","3","Kansi tumumane Yawe. Tumumane twakoniizie. Kisinka nga vilivyatula koba, i vi-ali wakaba kumoneka. Wakaba kwiza kuli fwefue nga nvula ya muloboko, nga nvula ya mpeleezio iliyatomia pa kyalo.” ");
INSERT INTO tap_vpl VALUES ("HS6_4","029_6_4","HOS","6","4","4","“We Efraimu! Nkukite syani? We Yuda! Nkukite syani? Ntono yenu ili nga fuube wa lukeelekeele, nga lume lwa kumakia lusililwakokola kuzeeza. ");
INSERT INTO tap_vpl VALUES ("HS6_5","029_6_5","HOS","6","5","5","Ni pakako, nakimiputulania tuputu tuputu kupitila mu bakabika bane. Nakimipaya na twebo twa mu kanua kane, bupinguzi bwane bwaakasaama nga kisue kya koba. ");
INSERT INTO tap_vpl VALUES ("HS6_6","029_6_6","HOS","6","6","6","Pantu nene ntonene nkumbu, tekuba ngelelo, ni kunakila Leza kukila ngelelo ya kuzizia. ");
INSERT INTO tap_vpl VALUES ("HS6_7","029_6_7","HOS","6","7","7","Inzi ku Adamu, bainoonene kipingo, koko, kubasibanga ba kisinka kuli nene. ");
INSERT INTO tap_vpl VALUES ("HS6_8","029_6_8","HOS","6","8","8","Gileadi i muzi wa bankitatubi, muzi utiikaaniiziwe na mulopa. ");
INSERT INTO tap_vpl VALUES ("HS6_9","029_6_9","HOS","6","9","9","Nga vili mabumba a bapoti balibafyamina bantu, i vili ni libumba lya babitambua. Balibaipaya bantu mu nzila ya ku Sekemu, ni kukita bintu bibiipile. ");
INSERT INTO tap_vpl VALUES ("HS6_10","029_6_10","HOS","6","10","10","Nakimona kintu kibi mu Izraeli. Momo mulimukukita Efraimu bukambue. Izraeli waitiikania.” ");
INSERT INTO tap_vpl VALUES ("HS6_11","029_6_11","HOS","6","11","11","“Ni palwakua wewe Yuda, musita wa kuzombolua uteaniiziwe. Musita unakaba kubwezia bakakua ba pa bantu bane.” ");
INSERT INTO tap_vpl VALUES ("HS7_1","029_7_1","HOS","7","1","1","“Lyonse lundinakeba kukosia Izraeli, bibalo byakua Efraimu bilibyabiikua paswetele. Bubi bwakua Samaria bulibwafyulua, balibapompolana, bakabooko balibaingililana mu nghanda, babipoopoosi balibasompolana mu misebo. ");
INSERT INTO tap_vpl VALUES ("HS7_2","029_7_2","HOS","7","2","2","Inzi tebenikile nangue nangulukile bikitua byabo byonse bibi. Bibalo byabo bibazyungulukiile, ni byo bili pa ntanzi yane lyonse.” ");
INSERT INTO tap_vpl VALUES ("HS7_3","029_7_3","HOS","7","3","3","“Balibamusansamusia likolo na bilubo byabo, ni babiloolo na bufi bwabo. ");
INSERT INTO tap_vpl VALUES ("HS7_4","029_7_4","HOS","7","4","4","Bonse balibakita bukende, baswelele nga kyapiko kya mikate, kekio kili ni mulilo usikebekele kusonseziiwa na kaapika wa mikate kutula musita wa kukandila bunga mpaka musita wa kututumuka. ");
INSERT INTO tap_vpl VALUES ("HS7_5","029_7_5","HOS","7","5","5","Mu busiku bwa nsikunkulu yakua likolo wetu, babiloolo balibaleema na bikolani, ni likolo aliwailunda ku bantu bali ni mufuupula. ");
INSERT INTO tap_vpl VALUES ("HS7_6","029_7_6","HOS","7","6","6","Mitima yabo ili nga kikuka kya mulilo, balibamuwila likolo mu bubi. Kipuki kyabo kilikyafunka kyunsi busiku bonse, ni lukeelekeele kilikyatuutuuka nga libeebe lya mulilo. ");
INSERT INTO tap_vpl VALUES ("HS7_7","029_7_7","HOS","7","7","7","Baswelele nga kyapiko kya mikate. Balibazakila bakateeka babo. Makolo abo onse aliapona, kabili tepali muntu aliwankuuta.” ");
INSERT INTO tap_vpl VALUES ("HS7_8","029_7_8","HOS","7","8","8","“Efraimu esanziizie mu ntundu. Efraimu i mukate umaatikile upiile bwala bumo. ");
INSERT INTO tap_vpl VALUES ("HS7_9","029_7_9","HOS","7","9","9","Baeni bamupwile maka, inzi wene tenikile. Mu misisi yakue muli ni ndale pale pale, inzi wene tamanine. ");
INSERT INTO tap_vpl VALUES ("HS7_10","029_7_10","HOS","7","10","10","Kiitoni kyakua Izraeli kilikyamusininkizia, anzia evio, tamubweleele Yawe Leza wakue ao kumukeba.” ");
INSERT INTO tap_vpl VALUES ("HS7_11","029_7_11","HOS","7","11","11","“Efraimu ali sie nga nkunda, tezi kukokola kubeepua, kabili tali na maano. Musita umo aliwakuuta ku Misri, ni unge musita aliwaya ku Asuria. ");
INSERT INTO tap_vpl VALUES ("HS7_12","029_7_12","HOS","7","12","12","Mu lwendo lwabo nakaba kubateela bukila, nakaba kubakula ni kubaponiizia pansi nga tooni twa mu lweleele. Pankaba kunvua nangue balimukukolonghana pamo, nakaba kubakwata. ");
INSERT INTO tap_vpl VALUES ("HS7_13","029_7_13","HOS","7","13","13","Lisyamo lyabo, pantu bakinfunghamina! Busanzo buli pali bene, pantu bakinsangukila. Ntonene kubalubula, inzi baliban'mbeepezia. ");
INSERT INTO tap_vpl VALUES ("HS7_14","029_7_14","HOS","7","14","14","Tebalimukundilila na mitima yabo yonse, inzi balimukuloosia baleele pa malita abo.” Balimukukolonghana pamo balomba baleza babo pa mulandu wa nghano ni pa mulandu wa divai ya lenu. Baba bantu banfunghamiine. ");
INSERT INTO tap_vpl VALUES ("HS7_15","029_7_15","HOS","7","15","15","Ndinabasambilizia ni kubakoselezia, inzi balibankambila. ");
INSERT INTO tap_vpl VALUES ("HS7_16","029_7_16","HOS","7","16","16","Tebezi kumubwelela Kabezia Mpungu. Bali nga buta busifimbile. Banombozi babo baakeepawa na kipanga pa mulandu wa twebo twabo twa bukisanguka. Ni pakako, baakafuupulua mu kyalo kya Misri. ");
INSERT INTO tap_vpl VALUES ("HS8_1","029_8_1","HOS","8","1","1","“Biika ntandala ku kanua kobe! Kipungu kili peulu nghanda yakua Yawe pantu bantu bakityona kipingo kyane ni kusangukila mizilo yane. ");
INSERT INTO tap_vpl VALUES ("HS8_2","029_8_2","HOS","8","2","2","Izraeli wandilila, ‘We Leza wetu, tukumanine!’ ");
INSERT INTO tap_vpl VALUES ("HS8_3","029_8_3","HOS","8","3","3","Inzi Izraeli wakikaana kiweme. Mulwani wakaba kumukumbizia. ");
INSERT INTO tap_vpl VALUES ("HS8_4","029_8_4","HOS","8","4","4","Balibabiika makolo pasili kutona kwane, balibasaakula babiloolo tekuba nabapeele nsambu. Balibaikitila mikisi ya mutofue ni ya oro mu kwileetelela lwinoono. ");
INSERT INTO tap_vpl VALUES ("HS8_5","029_8_5","HOS","8","5","5","Mwe Basamaria, pooze mukisi wenu wa nghombe ndume! Nene n'mbafiitiilue, baakaba batiikeenetiikeene sie mpaka musitaki? ");
INSERT INTO tap_vpl VALUES ("HS8_6","029_8_6","HOS","8","6","6","Ozu mukisi wa nghombe musoka ufumine ku Izraeli! Ukitilue na muntu amanine ozo mwilo. Ozo mukisi te Leza. Mukisi wa Basamaria wakaba kutyonua tuputu tuputu. ");
INSERT INTO tap_vpl VALUES ("HS8_7","029_8_7","HOS","8","7","7","“Balibabyala mwela ni kuzombola mulula. Musense usili na musokoti, teuvinda kufumia bunga. Ufumiengeko mbezu, baeni nga baitelekele. ");
INSERT INTO tap_vpl VALUES ("HS8_8","029_8_8","HOS","8","8","8","Izraeli atelekelue, evi ali pa bukata bwa ntundu nga kintu kya mpuni. ");
INSERT INTO tap_vpl VALUES ("HS8_9","029_8_9","HOS","8","9","9","Pantu bakisela ku Asuria, nga punda wa mu kisonso aliwaendooka bunke. Efraimu waki-isisia ye mwine ku batonua. ");
INSERT INTO tap_vpl VALUES ("HS8_10","029_8_10","HOS","8","10","10","Anzia kine bai-isisiizie bo bene pa ntundu, nakaba kubakolonghania pamo. Bakaba kubamba konda na kubiibikiziiwa na likolo wa maka. ");
INSERT INTO tap_vpl VALUES ("HS8_11","029_8_11","HOS","8","11","11","“Anzia kine Efraimu waakuulile bitale bingi bya ngelelo ya bibalo, bya-alukile bitale bya kukitilapo bibalo. ");
INSERT INTO tap_vpl VALUES ("HS8_12","029_8_12","HOS","8","12","12","Naabalembeele bintu bingi palua mizilo, inzi baabimwene nga kintu kyeni. ");
INSERT INTO tap_vpl VALUES ("HS8_13","029_8_13","HOS","8","13","13","Anzia kine balimukungelela ngelelo kuba bupe, kabili anzia kine balimukulia nama, Yawe tabawamiinue. Evi wene wakaba kulanguluka bubi bwabo ni kubakanda pa bibalo byabo. Bakaba kubwelela ku Misri. ");
INSERT INTO tap_vpl VALUES ("HS8_14","029_8_14","HOS","8","14","14","Izraeli wakimulaba Kabumba wakue, ni kukuula nghanda ingi ya bukolo. Mu mizi ingi Yuda wakikuulamo byubo. Inzi nakaba kutuma mulilo mu mizi yabo, mulilo wakaba kufita byubo byabo.” ");
INSERT INTO tap_vpl VALUES ("HS9_1","029_9_1","HOS","9","1","1","We Izraeli, tekuwaminua, tekusangalala nga Bazima. Pantu tewakiba wa kisinka kuli Leza obe, utonene kuongua mu bukambue mu nkendo yonse ya kupuulilamo nghano. ");
INSERT INTO tap_vpl VALUES ("HS9_2","029_9_2","HOS","9","2","2","Kipuulilo kya nghano ni kya kutikilamo divai, tekikabeekusia. Divai ya lenu yaakaba yabakeepeele. ");
INSERT INTO tap_vpl VALUES ("HS9_3","029_9_3","HOS","9","3","3","Tebakeekala mu kyalo kyakua Yawe, Efraimu waakabwelela ku Misri ni kulia bilio bitiikeene mu Asuria. ");
INSERT INTO tap_vpl VALUES ("HS9_4","029_9_4","HOS","9","4","4","Tebakamupongwela Yawe bupe bwa divai, ngelelo yabo teikikamuwamina. Ngelelo ya ozo musango kuli bene yaakaba nga mukate wa balia balimukuloosia. Bonse balibalia bebio bilio baakaba batiikeene. Bebi bilio bilikuya byali bya bo bene. Tekuti bitwalue mu Nghanda yakua Yawe. ");
INSERT INTO tap_vpl VALUES ("HS9_5","029_9_5","HOS","9","5","5","Mwaakakitaki mu busiku bwa nsikunkulu yenu ibiikilue, pa busiku bwa nsikunkulu yakua Yawe? ");
INSERT INTO tap_vpl VALUES ("HS9_6","029_9_6","HOS","9","6","6","Anzia kine bapusuka mu busanzo, Misri wakaba kubakolonghania, ni Memfisi wakaba kubaziika. Kipao kyabo kya mutofue kyaakamenamo mikunkuli, ni myunga yakaba kukupilila mitanda yabo. ");
INSERT INTO tap_vpl VALUES ("HS9_7","029_9_7","HOS","9","7","7","Nsiku ya kukandua yapalama, nsiku ya kusaziiwa yakumana. Izraeli amane evio. Pantu bibalo byenu byavulisia ni bulwani bwenu bwatanisia, kabika amwenue kuba kipuba, muntu alombwelue na mweo, kuba wa luuba. ");
INSERT INTO tap_vpl VALUES ("HS9_8","029_9_8","HOS","9","8","8","Kabika ali ni Leza wane, i musungi pali Efraimu. Anzia kili evio, miteo imupembeele monse mu-aliwapita, bulwani ni bo mu Nghanda yakua Leza wakue. ");
INSERT INTO tap_vpl VALUES ("HS9_9","029_9_9","HOS","9","9","9","Bakikila kwi-ingizia mu bituulilo nga vikyaali mu nsiku yakua Gibea. Leza waakalanguluka bubi bwabo ni kubakanda pa mulandu wa bibalo byabo. ");
INSERT INTO tap_vpl VALUES ("HS9_10","029_9_10","HOS","9","10","10","“Lunaamusangile Izraeli, kyaali kyali nga kusanga mizabibu mu kaseeba. Lunaamwene babikolue benu, kyaali kyali nga kumona mazabo a kutendekelapo a ku kimuti kya miku. Inzi lubaafikile ku Baali-Peori baizuukiizie bo bene ku mikisi ya busoni, ni bo baitiikaaniizie nga kintu kibaatonene bo bene. ");
INSERT INTO tap_vpl VALUES ("HS9_11","029_9_11","HOS","9","11","11","Bulumba bwakua Efraimu bwaakapupuka nga koni, tekuli kuvyala, tekuli liimi, tekuli kwimita. ");
INSERT INTO tap_vpl VALUES ("HS9_12","029_9_12","HOS","9","12","12","Anzia balela baana, naakabeepaya, tekuli waakasyalapo. Lisyamo lyabo musita unakaba kubafunghamina! ");
INSERT INTO tap_vpl VALUES ("HS9_13","029_9_13","HOS","9","13","13","Efraimu naamumwene nga Tiro, abyelue pa bulongo bufukile, inzi Efraimu waakatwala baana bakue ku bangipaani.” ");
INSERT INTO tap_vpl VALUES ("HS9_14","029_9_14","HOS","9","14","14","We Yawe, bapeele, kubako ulikubapeelaki? Bapeele tuvumo twa kupulumuna ni kukama kwa mabeele. ");
INSERT INTO tap_vpl VALUES ("HS9_15","029_9_15","HOS","9","15","15","“Pa mulandu wa bubi bwabo bonse buli mu Gilgali, momo i munaabasuliile. Pa mulandu wa bikitua byabo bya bibalo, nakaba kubakumba mu nghanda yane. Nsikikaba kubatona, pantu banombozi babo bonse ni babisanguka. ");
INSERT INTO tap_vpl VALUES ("HS9_16","029_9_16","HOS","9","16","16","Efraimu wakiinoonua, musila wabo wakifumpa, tebakilimukuseekako buzabo. Anzia kine bakaba kuvyala baana, nakaba kwipaya mazabo a mponvu a mavumo abo.” ");
INSERT INTO tap_vpl VALUES ("HS9_17","029_9_17","HOS","9","17","17","Leza wane waakabakaana pantu tebaali bamunvua. Baakaba baya banukunta mu ntundu. ");
INSERT INTO tap_vpl VALUES ("HS10_1","029_10_1","HOS","10","1","1","Izraeli waali muzabibu waali wakula bwino, waali waseekako mazabo. Nga vyaali vyavula mazabo akue, i vi-aali wakila kukuula bitale. Nga vyaali vyatwalilila kyalo kyakue, i vi-aali wakila kufwaniizia mabue akue a mpupo. ");
INSERT INTO tap_vpl VALUES ("HS10_2","029_10_2","HOS","10","2","2","Mutima wabo ni wa bupompo, ni evi bapalile kutwama bubi bwabo. Yawe wakaba kutuuta bitale byabo ni kwinoona mabue abo a mpupo. ");
INSERT INTO tap_vpl VALUES ("HS10_3","029_10_3","HOS","10","3","3","I lubaakalanda nangue, “Tetuli na likolo pantu tetwakimutiina Yawe. Inzi anzia kine tubenge na likolo, kubako nga waatukitiileki?” ");
INSERT INTO tap_vpl VALUES ("HS10_4","029_10_4","HOS","10","4","4","Balibalaya bulayo bwingi, balibalapa milapo ya bufi ni kukita bipingo. Ni pakako, busongezi bulibwamena nga bikusi bilibyaleeta bwimba mu bukaba buliminue. ");
INSERT INTO tap_vpl VALUES ("HS10_5","029_10_5","HOS","10","5","5","Bekazi ba mu Samaria basakameene pa mulandu wa mukisi wa nghombe musoka wa ku Bet-Aveni. Bantu ba mu Samaria baakaulilila ozo mukisi, evio vyenka ni babitambua bakue balibaupupa, balia bakiba bawaminua na bulumba bwa ozo mukisi, pantu ufumiiziwe kwabo ni kutwalua mu buzia. ");
INSERT INTO tap_vpl VALUES ("HS10_6","029_10_6","HOS","10","6","6","Ozo mukisi waakatwalua ku Asuria kuba kyabupe kuli likolo mukulu. Efraimu wakaba kusebaana, Izraeli wakaba kumona busoni palua mukisi wakue wa kimuti. ");
INSERT INTO tap_vpl VALUES ("HS10_7","029_10_7","HOS","10","7","7","Likolo wa mu Samaria waakeenoonua, waakakungululua nga kiputu kya kimuti peulu menda. ");
INSERT INTO tap_vpl VALUES ("HS10_8","029_10_8","HOS","10","8","8","Pa bifuka bibi bya kupupilapo mukisi paakeenoonua, i nkendo iliyabalilapo Izraeli. Myunga ni tumuti twa bukobola byaakamena ni kukupilila pa bitale byabo. Pa kyamba baakaana mpili nangue, “Ize mutukupilile,” ni kwana tupili, “Ize mutuponene!” ");
INSERT INTO tap_vpl VALUES ("HS10_9","029_10_9","HOS","10","9","9","“We Izraeli, kutula busiku buwaabalile mu Gibea, koko i kumwasyele. Kubako bului tebwaakitikile ku bankitatubi ba mu Gibea? ");
INSERT INTO tap_vpl VALUES ("HS10_10","029_10_10","HOS","10","10","10","Pa musita unaakatona, naakabakanda. Ntundu yaakabakolonghanina kuti ikabakake pa mulandu wa bibalo byabo bibili. ");
INSERT INTO tap_vpl VALUES ("HS10_11","029_10_11","HOS","10","11","11","Efraimu i nghombe musoka asambiliziiziwe, musoka atonene kupuula. Ni pakako, nakaba kumukaka mupingo pa mukosi wakue uweme. Nakaba kumulombola Efraimu, Yuda apalile kutipa, ni Yakobo apalile kupuma bisinde. ");
INSERT INTO tap_vpl VALUES ("HS10_12","029_10_12","HOS","10","12","12","Byale nsambu mwe bene, zombole mazabo a ntono isiliyapua, lime mu nsinde pantu i musita wakumukeba Yawe mpaka pa-akaba kwiza ni kuminookiizia bulunghami. ");
INSERT INTO tap_vpl VALUES ("HS10_13","029_10_13","HOS","10","13","13","Inzi mwaalimbile bilubo, mwaazombwele bubi, mwaaliile buzabo bwa bupompo, muketekeele sie maka enu mwe bene, ni bwingi bwa balukale benu. ");
INSERT INTO tap_vpl VALUES ("HS10_14","029_10_14","HOS","10","14","14","Ni pakako, nsungu ya bului yaakaba pa bantu bobe, ni byubo byobe byonse byaakeenoonua nga vyainoonenue Beti-Arbeli na likolo Salmani pa busiku bwa bului, nghina ni baana bakue lubaapoozelue pansi na maka. ");
INSERT INTO tap_vpl VALUES ("HS10_15","029_10_15","HOS","10","15","15","Evi i vikyaakakitika ni kuli wewe Beteli, pantu bubi bobe ni bukata. Bobo busiku pa bukakia, likolo wakua Izraeli waakaloviiwa.” ");
INSERT INTO tap_vpl VALUES ("HS11_1","029_11_1","HOS","11","1","1","“Izraeli lu-aali wakili mwanike, naamutonene, ni kufuma ku Misri, naamukuutile mwanane. ");
INSERT INTO tap_vpl VALUES ("HS11_2","029_11_2","HOS","11","2","2","Inzi nga vibaali bakila kukuutua, i vibaali bakila kuya kule ni nene. Baeleele ngelelo ku ba Baali ni kufunkia bubaani ku mikisi. ");
INSERT INTO tap_vpl VALUES ("HS11_3","029_11_3","HOS","11","3","3","Nene i waamusambiliziizie Efraimu kwenda, nabakwete ku maboko, inzi tebainikile nangue nene i waabakosiizie. ");
INSERT INTO tap_vpl VALUES ("HS11_4","029_11_4","HOS","11","4","4","Naabalombwele na nkamba ya nkumbu ya bumuntu, na nkakilo ya ntono, kuli bene naali nga olia aliwatwama mwana pa nkombe, kabili naafwineeme kuti n'mbaliisie. ");
INSERT INTO tap_vpl VALUES ("HS11_5","029_11_5","HOS","11","5","5","“Kubako tebakabwelela ku Misri ni kuteekua na Asuria pantu baakeene kulapila? ");
INSERT INTO tap_vpl VALUES ("HS11_6","029_11_6","HOS","11","6","6","Kipanga kyaakabeekia mu mizi yabo. Kyaakazakila minkolonto ya milyango yabo ni kupwisia mapange abo. ");
INSERT INTO tap_vpl VALUES ("HS11_7","029_11_7","HOS","11","7","7","Bantu bane bekinkiziizie kuti ban'mbutuke. Anzia kine balibankuuta Leza Kabezia Mpungu, ata pakaba syani, nsikavinda kubasezia. ");
INSERT INTO tap_vpl VALUES ("HS11_8","029_11_8","HOS","11","8","8","“Kuti nakusia syani we Efraimu? Kuti nakulekelela syani we Izraeli? Kuti nakukitila syani bibiipile nga vinaakitiile Adma? Kuti nakukita syani nga Zeboimu? Mutima wane walulukile mukati mwane, nkumbu yane yonse ibuukulukile. ");
INSERT INTO tap_vpl VALUES ("HS11_9","029_11_9","HOS","11","9","9","Nsikafikilizia kikonko kyane kikata, kabili nsika-alulula malanga ni kumwinoona Efraimu paakale, pantu nene ndi Leza, kabili nsili muntu, ndi Muzuuke pakati kenu. Nsikeeza kukanda mizi yabo. ");
INSERT INTO tap_vpl VALUES ("HS11_10","029_11_10","HOS","11","10","10","Baakamukonka Yawe. Waakabuluma nga nkalamu. Lu-aliwabuluma, baana bakue balibaiza kufuma ku mboosi balimukututuma. ");
INSERT INTO tap_vpl VALUES ("HS11_11","029_11_11","HOS","11","11","11","Baakeeza kufuma ku Misri, balimukututuma nga minsole, kufuma ku Asuria, bapupukile nga nkunda. Naakabeekazia mu nghanda yabo ingi,” nangue Yawe. ");
INSERT INTO tap_vpl VALUES ("HS11_12","029_11_12","HOS","11","12","12","Efraimu anzyungulukiile na bufi, Izraeli na bupompo, inzi Bayuda baatwaliile kuba ba kisinka kuli Leza, Leza Muzuuke wa kisinka. ");
INSERT INTO tap_vpl VALUES ("HS12_1","029_12_1","HOS","12","1","1","Efraimu aliwailiisia mwela. Aliwakumba mwela wa ku kabanga koba konse ni kuvuzia bufi ni bubi. Aliwaunvwana ni Asuria ni kutuma mafuta a mizeituni ku Misri. ");
INSERT INTO tap_vpl VALUES ("HS12_2","029_12_2","HOS","12","2","2","Yawe ali ni mulandu ni Yuda. Wakaba kumukanda Yakobo kukonkana ni mibeele yakue ni kumusazia kukonkana ni bikitua byakue. ");
INSERT INTO tap_vpl VALUES ("HS12_3","029_12_3","HOS","12","3","3","Yakobo lu-aali munda, waamusakatiile mukuluube lya ku kasinghino. Wene lu-aakulile, waalwile na Leza. ");
INSERT INTO tap_vpl VALUES ("HS12_4","029_12_4","HOS","12","4","4","Waalwile na malaika ni kumwanzia, waalilile ni kulomba buwame. Waamusangile ku Beteli ni kwambaula ni ye koko kwenka. ");
INSERT INTO tap_vpl VALUES ("HS12_5","029_12_5","HOS","12","5","5","Yawe Leza wa Maka onse, Yawe i liina lyakue! ");
INSERT INTO tap_vpl VALUES ("HS12_6","029_12_6","HOS","12","6","6","Inzi upalile kubwela kuli Leza obe. Sunga ntono ni bulunghami, ni kupempa Leza obe lyonse. ");
INSERT INTO tap_vpl VALUES ("HS12_7","029_12_7","HOS","12","7","7","Musulu aliwabombia tulingo twa bupompo, aliwatona kukalana. ");
INSERT INTO tap_vpl VALUES ("HS12_8","029_12_8","HOS","12","8","8","Efraimu aliwaitantamuna, “Nene ndi munonsi mukata. Nakyaluka munonsi. Mu bunonsi bwane bonse, tebakansangamo na lubiibi ao na kibalo.” ");
INSERT INTO tap_vpl VALUES ("HS12_9","029_12_9","HOS","12","9","9","“Nene ndi Yawe Leza wenu waamifumiizie ku Misri. Naakamilengia kwikala paakale mu maema, nga mu nsiku ya nsikunkulu yenu yaabiikilue. ");
INSERT INTO tap_vpl VALUES ("HS12_10","029_12_10","HOS","12","10","10","Naalandile na bakabika, naabapeele bimonua bingi ni kulandila mu bipalo kupitila muli bene.” ");
INSERT INTO tap_vpl VALUES ("HS12_11","029_12_11","HOS","12","11","11","Kubako Gileadi te mubi? Bantu bakue ni ba mpuni! Eba, balibaeleela nghombe ndume mu Gilgali? Bitale byabo byaakaba nga milui ya mabue mu bukaba buliminue. ");
INSERT INTO tap_vpl VALUES ("HS12_12","029_12_12","HOS","12","12","12","Yakobo waabutukiile mu kyalo kya Aramu, Izraeli waabombele pakuti apate mukazi, ni pakuti alipe pa mulandu wa mukazi, waasungile mikooko. ");
INSERT INTO tap_vpl VALUES ("HS12_13","029_12_13","HOS","12","13","13","Yawe waabombiizie kabika pakuti amufumie Izraeli ku Misri, kupitila muli kabika waamusungile. ");
INSERT INTO tap_vpl VALUES ("HS12_14","029_12_14","HOS","12","14","14","Inzi Efraimu waasonseziizie kipuki kyakua Yawe, Mulopue wakue waakamupenda kuba wa kilubo pa mulandu wa bungipaani bwakue ni kumukanda pa mulandu wa mufuupula wakue. ");
INSERT INTO tap_vpl VALUES ("HS13_1","029_13_1","HOS","13","1","1","Efraimu lu-aalandile, bantu baatutumine. Waalumbilue mu Izraeli. Inzi waisangile kuba mubi pa mulandu wa kupupa leza Baali, ni ye waafwile. ");
INSERT INTO tap_vpl VALUES ("HS13_2","029_13_2","HOS","13","2","2","Evi balimukukila kubala. Balimukwikitila mikisi na mutofue wabo mu musango ubamaniinemo bo bene, byonse byaakitilue na bantu bamanine mwilo. Kilandilue palua baba bantu nangue, “Balibafumia bantu kuba ngelelo! Balibakumbatila mukisi wa nghombe musoka!” ");
INSERT INTO tap_vpl VALUES ("HS13_3","029_13_3","HOS","13","3","3","Ni pakako, baakaba nga fuube wa lukeelekeele, nga lume lusililwakokola kuzeeza, nga makapa aliaululua na mwela pa kipuulilo, nga kyunsi kilikyafumina pa nzota. ");
INSERT INTO tap_vpl VALUES ("HS13_4","029_13_4","HOS","13","4","4","“Inzi nene ndi Yawe Leza wenu kutula pa musita umwaafumine ku Misri, temupalile kukindika unge Leza inga sie nene, tekuli Mupususi unge inga sie nene. ");
INSERT INTO tap_vpl VALUES ("HS13_5","029_13_5","HOS","13","5","5","Naakulabukiile mu kaseeba, mu kyalo kya kyaka. ");
INSERT INTO tap_vpl VALUES ("HS13_6","029_13_6","HOS","13","6","6","Lunaabaliisiizie, baikutile. Lubaikutile, ba-alukile ni kiitoni. I kyaalengele kuti bandabe. ");
INSERT INTO tap_vpl VALUES ("HS13_7","029_13_7","HOS","13","7","7","Ni pakako, naakaba nali nga nkalamu kuli bene, nga kanfuma, naakababenza mu nzila. ");
INSERT INTO tap_vpl VALUES ("HS13_8","029_13_8","HOS","13","8","8","Nga kimbui kiibiilue baana bakue, naakabasakukila ni kuzanghununa mitima yabo. Nga nkalamu mukota, naakabazakila. Nama ya mu kisonso yaakabazanghununa tuputu tuputu. ");
INSERT INTO tap_vpl VALUES ("HS13_9","029_13_9","HOS","13","9","9","“Wainoonua we Izraeli pantu wanfunghamina. Wafunghamina mukwasi obe. ");
INSERT INTO tap_vpl VALUES ("HS13_10","029_13_10","HOS","13","10","10","Ale likolo obe wakuti akupususie alipi? Bakateeka ba mu mizi yobe yonse bali pi balia bawaanombele nangue, ‘N'mpeele likolo ni babiloolo?’ ");
INSERT INTO tap_vpl VALUES ("HS13_11","029_13_11","HOS","13","11","11","Mu kipuki kyane naakupeele likolo, ni mu kikonko kyane naamufumiiziepo. ");
INSERT INTO tap_vpl VALUES ("HS13_12","029_13_12","HOS","13","12","12","Bubi bwakua Efraimu busungilue, bibalo byakue bilembelue. ");
INSERT INTO tap_vpl VALUES ("HS13_13","029_13_13","HOS","13","13","13","Wene misa iliyamwizila nga mwanakazi alimukuvyala mwana, inzi ozo mwana tali na mulangue. Musita kine wakumana, aliwa-anda kufuma munda mwa nghina.” ");
INSERT INTO tap_vpl VALUES ("HS13_14","029_13_14","HOS","13","14","14","“Naakalubula baba bantu ku maka a kilibu, naakabapususia ku lufu. We lufu, lyemo lyobe lili pi? We kumbo, lwinoono lobe luli pi? “Nsikaba na nkumbu, ");
INSERT INTO tap_vpl VALUES ("HS13_15","029_13_15","HOS","13","15","15","anzia kine Efraimu akakitikilua na biweme pa ba kwakue, mwela wa ku kabanga kufuma kuli Yawe waakeeza wapuupile kufuma ku kaseeba. Kasulo kakue tekakasula, ni kiina kyakue kya menda kyaakakama. Muluwe wakue waakeenoonua pamo ni bintu byonse bilimo bya mutengo. ");
INSERT INTO tap_vpl VALUES ("HS13_16","029_13_16","HOS","13","16","16","Bantu ba mu Samaria bapalile kwisanga bali ni mulandu, pantu bakimusangukila Leza wabo. Baakaloviiwa na kipanga. Baana babo baniini baakafuntwilua pansi na maka, banakazi bemisi ba mu Samaria baakatumbulua.” ");
INSERT INTO tap_vpl VALUES ("HS14_1","029_14_1","HOS","14","1","1","We Izraeli, bwelela kuli Yawe Leza obe. Bibalo byobe byakikuponia! ");
INSERT INTO tap_vpl VALUES ("HS14_2","029_14_2","HOS","14","2","2","Be mwali ni twebo mubwelele kuli Yawe. Mumwane nangue, “Eleela bibalo byetu byonse ni kutupokelela na buwame, pakuti tufumie buzabo bwetu bwa ku milomo. ");
INSERT INTO tap_vpl VALUES ("HS14_3","029_14_3","HOS","14","3","3","Asuria tavinda kutupususia, tetukikasela pa farasi wa bului. Tetukikalanda nangue, ‘Baleza betu’ ku bintu bitwaakitile na minue yetu, pantu kuli wewe, mwana nsiwa aliwaunvwilua nkumbu.” ");
INSERT INTO tap_vpl VALUES ("HS14_4","029_14_4","HOS","14","4","4","“Naakoondapa butaale bwabo ni kubatona na mutima wane onse, pantu nsikibafiitiilue. ");
INSERT INTO tap_vpl VALUES ("HS14_5","029_14_5","HOS","14","5","5","Naakaba nga lume kuli Izraeli, waakatoota nga buluba. Waakengizia misila pansi nga kimuti kya mumpelempele kya ku Lebanoni. ");
INSERT INTO tap_vpl VALUES ("HS14_6","029_14_6","HOS","14","6","6","Misambo yakue yaakabazalala. Kuvumba kwakue kwaakaba nga kimuti kya muzeituni, bunu bwakue nga kimuti kya mumpelempele kya ku Lebanoni. ");
INSERT INTO tap_vpl VALUES ("HS14_7","029_14_7","HOS","14","7","7","Bantu baakeekala mu bulelo bwakue paakale, baakasana nga nghano, baakatoota nga mizabibu. Kumanika kwakua Izraeli kwaakaba nga divai ifumine ku Lebanoni. ");
INSERT INTO tap_vpl VALUES ("HS14_8","029_14_8","HOS","14","8","8","We Efraimu, kubako ni bwampanoki buli pali nene ni mikisi? Nene ndikukwasuka ni kukulabukila. Nene ndi nga kimuti kibisi kisili kyauma lyonse. Kuseeka kwa mazabo kobe kulikwafuma kuli nene.” ");
INSERT INTO tap_vpl VALUES ("HS14_9","029_14_9","HOS","14","9","9","Nani ali ni mulangue? Enike totu twebo. Nani ali ni maano? Amane totu twebo. Nzila yakua Yawe ilungheeme, balunghami i balibaendamo, inzi babisanguka balibaipuutalamo.");
INSERT INTO tap_vpl VALUES ("JL1_1","030_1_1","JOL","1","1","1","Mpunda ya keebo kakua Yawe yaizile kuli Yoeli mwana mwina Petueli ni ezi. ");
INSERT INTO tap_vpl VALUES ("JL1_2","030_1_2","JOL","1","2","2","Mwe masiiko unvue kaka keebo, mwe bekazi bonse ba mu kyalo kya Yudea twilizie! Kubako kintu kya ozu musango kyaakitikilepo kale mu nsiku yenu, ao mu nsiku ya babikolue benu? ");
INSERT INTO tap_vpl VALUES ("JL1_3","030_1_3","JOL","1","3","3","Kaka keebo mukabe kwanako baana benu, baana benu ni bo bakaaneko baana babo, ni babo baana babo bakaaneko nvyalo yaakakonkapo. ");
INSERT INTO tap_vpl VALUES ("JL1_4","030_1_4","JOL","1","4","4","Belia byaasiilueko na balyambala, byaaliilue na kisepe kya luzie. Byaasiilueko na kisepe kya luzie, byaaliilue na bazingilila. Ni byaasiilueko na bazingilila, byaaliilue na mifwinzi. ");
INSERT INTO tap_vpl VALUES ("JL1_5","030_1_5","JOL","1","5","5","Mwe bakyakolua, buuke mulile. Mwe bamini ba divai, angule. Angule pa mulandu wa divai ya lenu, pantu mwakipokua ku milomo yenu. ");
INSERT INTO tap_vpl VALUES ("JL1_6","030_1_6","JOL","1","6","6","Kisepe kya luzie kyakisakukila kyalo kyane, kisepe kya luzie lusililwapendeka, lolo luli ni meeno a nkalamu, ni luli ni lumuma lwa nkalamu mukota. ");
INSERT INTO tap_vpl VALUES ("JL1_7","030_1_7","JOL","1","7","7","Lwakiinoona mizabibu yane, lwakilovia miku yane, lwakyubulako mamba, lwaki-apooza kule. Lwakisia misambo yaswetele sie pepepe. ");
INSERT INTO tap_vpl VALUES ("JL1_8","030_1_8","JOL","1","8","8","Lila nga kinundue avwele lisaaka, kinundue onvwile bulanda pa mulandu wa kufwilua na musakua wakue. ");
INSERT INTO tap_vpl VALUES ("JL1_9","030_1_9","JOL","1","9","9","Bupe bwa misenga ya nghano ni bupe bwa bya kumina, tebukili bwaleetua mu nghanda yakua Yawe. Ni pakako, balia babitambua balibabomba ntanzi yakua Yawe, bali mu malilo. ");
INSERT INTO tap_vpl VALUES ("JL1_10","030_1_10","JOL","1","10","10","Makaba ainoonua, musili waumina. Tekukili nghano, tekukili divai ya lenu, mafuta a mizeituni akama. ");
INSERT INTO tap_vpl VALUES ("JL1_11","030_1_11","JOL","1","11","11","Mwe balimi polokelue, mwe balimi ba mizabibu lile. Unvue bulanda pa mulandu wa nghano ni shairi, pantu buzombozi bwa mu makaba enu bwainoonua. ");
INSERT INTO tap_vpl VALUES ("JL1_12","030_1_12","JOL","1","12","12","Misila ya mizabibu teisyaumine. Bimuti bya miku tebisyafumpile. Bimuti bya komamanga ni bya bunkindu pamo ni bya pome, byonse tebisyaumine. Kisinka nsansa ya bantu teisyapwile. ");
INSERT INTO tap_vpl VALUES ("JL1_13","030_1_13","JOL","1","13","13","Mwe babitambua, vwale masaaka mulile, mwe balibabombela ku kitale, loosie. Ize mupunge busiku bonse mwavwele masaaka. Mwe balibabombela Leza wane, pantu bupe bwa misenga ya nghano ni bupe bwa bya kumina tebukili bwaleetua mu Nghanda yakua Yawe. ");
INSERT INTO tap_vpl VALUES ("JL1_14","030_1_14","JOL","1","14","14","Punde palua kuizilika kuzuuke. Kuute libumba lya bazuuke. Kuute masiiko pamo ni bonse bekeele mu kyalo, baye mu Nghanda yakua Yawe Leza wenu, ni kumulilila Yawe. ");
INSERT INTO tap_vpl VALUES ("JL1_15","030_1_15","JOL","1","15","15","Lisyamo pa bobo busiku! Pantu busiku bwakua Yawe bwapalama, bwakaba kwiza nga lwinoono kufuma kuli wa Maka onse. ");
INSERT INTO tap_vpl VALUES ("JL1_16","030_1_16","JOL","1","16","16","Twimweneene na menso etu bilio vibisikilibyamoneka, ni mu nghanda yakua Leza vimusikili nsansa ni musangalalo. ");
INSERT INTO tap_vpl VALUES ("JL1_17","030_1_17","JOL","1","17","17","Mbezu teisyaumine mu bibungulu bya bulongo buume. Mu milue temukili kantu, milue ya bilio yatuutua, pantu temukili kantu. ");
INSERT INTO tap_vpl VALUES ("JL1_18","030_1_18","JOL","1","18","18","Mone nghombe vi-ilimukulila! Bisepe bilimukwema pantu tebikili na bilio. Bisepe bya mikooko ni byo bilimukwema. ");
INSERT INTO tap_vpl VALUES ("JL1_19","030_1_19","JOL","1","19","19","We Yawe nakukuuta. Nakukuuta pantu mulilo wazizia bikusi bya mu kisonso. Ni libeebe lyazizia bimuti byonse bya mu makaba. ");
INSERT INTO tap_vpl VALUES ("JL1_20","030_1_20","JOL","1","20","20","Nama yonse ya mu kisonso ni yo yakulilila, pantu twezi twa menda twakikama. Mulilo wazizia bikusi byonse bya mu kisonso. ");
INSERT INTO tap_vpl VALUES ("JL2_1","030_2_1","JOL","2","1","1","Lizie ntandala mu Sayuni, Punde pa lupili lwane luzuuke. Bekala kyalo bonse batutume pantu busiku bwakua Yawe bwapalama, pasia bufike. ");
INSERT INTO tap_vpl VALUES ("JL2_2","030_2_2","JOL","2","2","2","Bwaakaba busiku bwa nfinzi ni bulanda, busiku bwa malezi ni kifutika. Nga vilivyakumana kakula mwaya mpili, i vilimukwiza ni kisepe kya maka kya luzie. Kutula pa kale tepanakitike kintu nga keki, kabili tekikabako ku nvyalo ilimukwiza. ");
INSERT INTO tap_vpl VALUES ("JL2_3","030_2_3","JOL","2","3","3","Ku ntanzi ya luzie, mulilo ulimukuzizia. Ku kyamba, libeebe lilimukutuutuuka. Ku ntanzi ya luzie, kyalo kili nga bukaba bwa mu Edeni. Ku kyamba kya luzie, kuli nga kaseeba ka kutiinia. Tekuli kyaapusukile pasili kwinoonua na luzie. ");
INSERT INTO tap_vpl VALUES ("JL2_4","030_2_4","JOL","2","4","4","Nmonekelo ya lolo luzie luli nga farasi. Lwendele lubilo nga baseli ba pa farasi. ");
INSERT INTO tap_vpl VALUES ("JL2_5","030_2_5","JOL","2","5","5","Ni katuuto nga katuuto ka matyakala a bului, koku lwalimukusontoka peulu lupili lwatuuta nga libebe lilimukuzizia bikusi byume, nga balukale ba maka batanteeme ku bului. ");
INSERT INTO tap_vpl VALUES ("JL2_6","030_2_6","JOL","2","6","6","Musita ululilwamoneka, ntundu iliyatiina. Kubalua muntu aliwatooboka. ");
INSERT INTO tap_vpl VALUES ("JL2_7","030_2_7","JOL","2","7","7","Lolu luzie lulilwasakukila nga bantu ba bului. Lulilwasela mu bibumba nga balukale. Lonse lulilwasela mu milongo pasili kusalanghana mu milongo. ");
INSERT INTO tap_vpl VALUES ("JL2_8","030_2_8","JOL","2","8","8","Lulilwaya pasili kutintana. Kubalua luzie lulilwaya lwalungheeme ku ntanzi. Lulilwapulania lusako pasili kusalanghana mu milongo. ");
INSERT INTO tap_vpl VALUES ("JL2_9","030_2_9","JOL","2","9","9","Lulilwaya mu muzi lwali lubilo. Lulilwakunduka mu bibumba. Lulilwaingila mu nghanda. Lulilwaingila kupitila mu nzota nga bakabooko. ");
INSERT INTO tap_vpl VALUES ("JL2_10","030_2_10","JOL","2","10","10","Ntanzi ya luzie, kyalo kiliyakwaka. Myulu iliyasunkeena. Koba ni kwezi bilibya-aluka nfinzi. Ntanda ni yo iliyazima. ");
INSERT INTO tap_vpl VALUES ("JL2_11","030_2_11","JOL","2","11","11","Yawe wa-ana libumba lya balukale bakue walimukubuluma. Balukale bakue tebezi kupendeka. Kuluma kuli ku balia balukale, balukale banakiile mafunde akue. Busiku bwakua Yawe bwaviizie, bwene busiku bwa kutiinia. Kubako nani alikuvinda kubusipikizia? ");
INSERT INTO tap_vpl VALUES ("JL2_12","030_2_12","JOL","2","12","12","Yawe walanda evi, “Lapile na mitima yenu yonse mun'mbwelele. Iizilike mulile ni kuloosia. ");
INSERT INTO tap_vpl VALUES ("JL2_13","030_2_13","JOL","2","13","13","Kaate mitima yenu mu kulanga bulanda, tekuba ngubo yenu.” Mubwelele Yawe Leza wenu wene ali ni buwame pamo ni nkumbu. Wene tezi kulenga kufiitua, ali ni ntono ingi, aliwaeleela lyonse, ni kuya wali lebe mu kukanda. ");
INSERT INTO tap_vpl VALUES ("JL2_14","030_2_14","JOL","2","14","14","Nani amanine nangue Yawe Leza wenu kuti wa-alulula malanga akue? N'manine nangue Yawe kuti wamipaala na kumipeela buzombozi bwingi, evi ni mwe mumwelele nghano ni bya kumina. ");
INSERT INTO tap_vpl VALUES ("JL2_15","030_2_15","JOL","2","15","15","Lizie ntandala mu Sayuni, punde kuizilika kuzuuke, kuute libumba lilonghaane. ");
INSERT INTO tap_vpl VALUES ("JL2_16","030_2_16","JOL","2","16","16","Kolonghanie bantu. Zuukie libumba, kolonghanie bakote, kolonghanie baana, balia bakilibaonka. Syabuinga afume mu muputule wakue, nabuinga ni ye afume mu muputule wakue. ");
INSERT INTO tap_vpl VALUES ("JL2_17","030_2_17","JOL","2","17","17","Balia babitambua balibabomba ntanzi yakua Yawe, balile pa bukata bwa nghingililo ya Nghanda yakua Leza ni kitale. Balande nangue, “We Yawe eleela bantu bobe. Tekulekelela bupyani bobe kuleebulua na twebo twa kapuni pa ntundu. Ale ni kiki kibalikulandila pa bantu nangue, ‘Leza wabo ali pi?’” ");
INSERT INTO tap_vpl VALUES ("JL2_18","030_2_18","JOL","2","18","18","Pa kyamba, Yawe waunvwiliile bunkua kyalo kyakue, ni kunvwila nkumbu bantu bakue. ");
INSERT INTO tap_vpl VALUES ("JL2_19","030_2_19","JOL","2","19","19","Yawe waabaasukile evi, “Unvue, nakaba kumitumina bilio, divai ya lenu pamo ni mafuta a mizeituni, bebio byakaba kumiikusia ni kumiwamina. Nsikikamilekelela kuleebulua na ntundu inge. ");
INSERT INTO tap_vpl VALUES ("JL2_20","030_2_20","JOL","2","20","20","Nakaba kufumia kisepe kya luzie kifumine ku nkungua ni kukikumbila kule lya ku kaseeba mu musili uume. Luzie lwakaba lwali mu milongo lya ku ntanzi ku kabanga, naakalupooza mu Lyezi lya Mukele, lolia lwaakaba lwali ku kyamba lya ku mboosi naakalupooza mu Lyezi lya Mediterania. Luzie lufwile lwakaba kufumia bunu bubiipile, ni kununka kwa lolo luzie kwaakasalanghana.” Kisinka Yawe wakikita bintu bikata! ");
INSERT INTO tap_vpl VALUES ("JL2_21","030_2_21","JOL","2","21","21","“We kyalo kya Yudea tekutiina. Waminua usangalale. Kisinka Yawe wakikita bintu bikata! ");
INSERT INTO tap_vpl VALUES ("JL2_22","030_2_22","JOL","2","22","22","Mwe binama bya mu kisonso tekutiine pantu bikusi bya mu kisonso byavumba paakale. Bimuti byabamba kuseekako mazabo. Bimuti bya miku pamo ni mizabibu byatwamako mazabo engi. ");
INSERT INTO tap_vpl VALUES ("JL2_23","030_2_23","JOL","2","23","23","“Sansamuke mwe bantu ba mu Sayuni. Sangalale muli Yawe Leza wenu pantu wakimipeela nvula ya muloboko. Wene ni wa kisinka. Aliwaminokiizia nvula ya muvumbi, nvula ya muloboko ni ya kawalala nga viyaali yanoka pa mambo. ");
INSERT INTO tap_vpl VALUES ("JL2_24","030_2_24","JOL","2","24","24","Nghano yaakeezula pa tubanga twa kupupiiziapo. Ngeso yaakeezulamo divai ya lenu pamo ni mafuta a mizeituni. ");
INSERT INTO tap_vpl VALUES ("JL2_25","030_2_25","JOL","2","25","25","Ne Yawe naakamibweziizia belia byaalilue na luzie mu myaka yaapitile, byaaliilue na luzie ni balyambala pamo ni mifwinzi, kisepe kyane kikata kinaatumine pakati kenu.” ");
INSERT INTO tap_vpl VALUES ("JL2_26","030_2_26","JOL","2","26","26","Mwaakaba ni bilio bingi bya kulia ni kwikuta. Mwaakamutasia Yawe Leza wenu, Yawe waamikitiile tupapo. Bantu bane tebakikamoniwa busoni. ");
INSERT INTO tap_vpl VALUES ("JL2_27","030_2_27","JOL","2","27","27","Papo i pamwaakamana nangue ndi pamo nenu mu Izraeli. Mwaakamana nangue nene ndi Yawe Leza wenu, kabili tekuli unge. Bantu bane tebakikamoniiwa busoni. ");
INSERT INTO tap_vpl VALUES ("JL2_28","030_2_28","JOL","2","28","28","“Pa kyamba, naakakoosia Mweo wane pa bantu bonse. Baana benu balalume ni banakazi baakabikula. Bakote benu baakaloota bilooto, ni balumendo benu baakamona bimonua. ");
INSERT INTO tap_vpl VALUES ("JL2_29","030_2_29","JOL","2","29","29","Pa babombi bane balalume ni banakazi ni po mu ezio nsiku naakakoosiiziapo Mweo wane. ");
INSERT INTO tap_vpl VALUES ("JL2_30","030_2_30","JOL","2","30","30","“Naakalanga tulangi mu myulu ni pa kyalo, mulopa ni mulilo pamo ni mapumpu a kyunsi kitikeeme. ");
INSERT INTO tap_vpl VALUES ("JL2_31","030_2_31","JOL","2","31","31","Koba kaakaalulua nfinzi, ni kwezi waakakasika nga mulopa, ntanzi ya kwiza kwa bobo busiku bukata bwa kutiinia bwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("JL2_32","030_2_32","JOL","2","32","32","Inzi kubalua muntu aliwakuuta mu liina lyakua Yawe waakapususiiwa. Pantu peulu Lupili lwa Sayuni ni mu Yeruzalemu, mwaakaba bupusuko nga mwaalandiile Yawe palua balia baapusukile, baakuutilue na Yawe.” ");
INSERT INTO tap_vpl VALUES ("JL3_1","030_3_1","JOL","3","1","1","“Mu ezio nsiku ni pa ozo musita, musita unaakabwezia bunonsi kuli Yuda ni kuli Yeruzalemu, ");
INSERT INTO tap_vpl VALUES ("JL3_2","030_3_2","JOL","3","2","2","naakakolonghania mabumba a balukale ba ntundu yonse, naakabakoosiizia mu lulambe lwa Yehoshafati, momo i munaakabapingula. Naakabapingula pa mulandu wa bikitua bibaakitiile bantu bane, Baizraeli, pantu baasalanghaniizie bantu bane mu ntundu inge ni kukasania kyalo kyane. ");
INSERT INTO tap_vpl VALUES ("JL3_3","030_3_3","JOL","3","3","3","Baateele bubale pa mulandu wa bantu bane. Baasuluziizie balumendo kuti basangemo nfolanga ya kuonga bakambue banakazi. Baasisiizie bakazyana kuti basangemo nfolanga ya kusitamo divai ya kumina. ");
INSERT INTO tap_vpl VALUES ("JL3_4","030_3_4","JOL","3","4","4","“Ati, mwe bantu ba mu Tiro, ni ba mu Sidona pamo ni kyalo kyonse kya Bafilistini, mulimwankebaki? Mulimukukeba kulandula pa kintu kinakikita? Kine i evio, nene nsikaba kukokola kumibweziizia kilanduzi kukonkana ni vimwakikita. ");
INSERT INTO tap_vpl VALUES ("JL3_5","030_3_5","JOL","3","5","5","Pantu mwaatweme mutofue ni oro yane, kabili mwaatweme ni kipao kyane kiwamiisie mwaya kutwala mu nghanda ya baleza benu. ");
INSERT INTO tap_vpl VALUES ("JL3_6","030_3_6","JOL","3","6","6","Mwaasisiizie bantu ba mu Yudea ni ba mu Yeruzalemu ku Bayunani, evi mubatwale kule ni kyalo kyabo. ");
INSERT INTO tap_vpl VALUES ("JL3_7","030_3_7","JOL","3","7","7","Inzi nakaba kubafumia ku nkendo yonse kumwaile kubasisia, mane nkabe kulandula kuli mwemue pa bintu byonse bimwaakitile. ");
INSERT INTO tap_vpl VALUES ("JL3_8","030_3_8","JOL","3","8","8","Naakabasisia baana benu balalume ni banakazi ku Bayuda, ni bo bakabasisie ku bantu ba ku Seba, ntundu ikeele kule.” Evi i vyalanda Yawe. ");
INSERT INTO tap_vpl VALUES ("JL3_9","030_3_9","JOL","3","9","9","“Pundile ntundu mwalanda: Iiteanie kuya ku bului! Kuute balukale! Palamike babipami baye ku kusakukila. ");
INSERT INTO tap_vpl VALUES ("JL3_10","030_3_10","JOL","3","10","10","Alule nkasu yenu kuba bipanga, ni bikwakua byenu kuba mikuuki. Olia anakile alande nangue, ‘Ndumine!’ ");
INSERT INTO tap_vpl VALUES ("JL3_11","030_3_11","JOL","3","11","11","Mwe ntundu yonse ili koku ni koku, lenge mwize mukolonghane mu lulambe lwa Yehoshafati.” We Yawe, koosia babipami bobe! ");
INSERT INTO tap_vpl VALUES ("JL3_12","030_3_12","JOL","3","12","12","“Ane ntundu iye, iye ikookele lya ku lulambe lulilwakuutua Yehoshafati, pantu koko i kundikuya kwikala, ni kupingula ntundu yonse ili koku ni koku. ");
INSERT INTO tap_vpl VALUES ("JL3_13","030_3_13","JOL","3","13","13","Ale twame bikwakua pantu musita wa kuzombola wa kumana. Ize mutike mizabibu pantu mu kitikilo kya mizabibu mwaizula. Nsupa yaizula ni kusempuka pantu bubi bwabo bwatanisia.” ");
INSERT INTO tap_vpl VALUES ("JL3_14","030_3_14","JOL","3","14","14","We libumba bukata! We libumba bukata mu lulambe lwa bupinguzi! Pantu busiku bwakua Yawe bwapalama mu lulambe lwa bupinguzi. ");
INSERT INTO tap_vpl VALUES ("JL3_15","030_3_15","JOL","3","15","15","Koba ni kwezi byaakaaluka nfinzi, ni ntanda teikikasanikila. ");
INSERT INTO tap_vpl VALUES ("JL3_16","030_3_16","JOL","3","16","16","Yawe waakabuluma mu Sayuni ni lizui lya mutukumo lyaakonvwika mu Yeruzalemu, kyalo ni myulu byaakasunkeena, inzi Yawe waakaba kyubo kya bantu bakue, ni kikingililo kya mponvu ku Baizraeli. ");
INSERT INTO tap_vpl VALUES ("JL3_17","030_3_17","JOL","3","17","17","“I pa mwaakeenika nangue nene Yawe Leza wenu ngikeele mu Sayuni, lupili lwane luzuuke. Yeruzalemu waakaba wazuukile muyayaya, ni baeni tebakikavinda kumwanzia. ");
INSERT INTO tap_vpl VALUES ("JL3_18","030_3_18","JOL","3","18","18","“Mu bobo busiku mpili yaakatoonia divai ya lenu. Tupili twaakazuumia mabeele. Menda aakaba apita mu tunkolonfua tonse twa mu Yudea. Kasulo ka menda kaakaba kafuma mu Nghanda yakua Yawe ni kuleeta kinwanvi mu lulambe lwa Shitimu. ");
INSERT INTO tap_vpl VALUES ("JL3_19","030_3_19","JOL","3","19","19","“Inzi mu Misri mwaakaaluka kibolia, mu Edomu mwaakaaluka kaseeba pantu baasanzile Bayuda, ni kwitila mulopa usili na mulandu mu kyalo kyabo. ");
INSERT INTO tap_vpl VALUES ("JL3_20","030_3_20","JOL","3","20","21","Mu Yudea ni mu Yeruzalemu mwaakeekalua muyayaya. Kubako naakandua kukanda bantu baitilile mulopa wa bantu bane? Abe sie, nsika-andua. ");
INSERT INTO tap_vpl VALUES ("AM1_1","031_1_1","AMO","1","1","1","Totu i twebo twakua Amosi, umo wa pa basungi ba nama ba ku Tekoa. Twebo tu-aamwene palwakua Izraeli mu myaka ibili ntanzi ya ntensi, Uzia lu-aali likolo wa ku Yudea, ni Yeroboamu mwina Yehoashi lu-aali wali likolo wa Baizraeli. ");
INSERT INTO tap_vpl VALUES ("AM1_2","031_1_2","AMO","1","2","2","Amosi waalandile nangue, “Yawe wabuluma pa Lupili lwa Sayuni, watukuma mu Yeruzalemu. Bikusi bya kuliiwa na nama tebiliko, bikusi bili peulu lupili lwa Karmeli byauma.” ");
INSERT INTO tap_vpl VALUES ("AM1_3","031_1_3","AMO","1","3","3","Yawe walanda evi, “Pa mulandu wa bibalo bitatu ao bina bya bantu ba mu Damaski, nsikaba kubalekelela pasili kubakanda, pantu bakitwama bintu bya Bagileadi mu kubombia byela bya busanze. ");
INSERT INTO tap_vpl VALUES ("AM1_4","031_1_4","AMO","1","4","4","Naakatuma mulilo pa nghanda yakua Hazaeli, ozo waakazizia byubo byakua Ben-Hadadi. ");
INSERT INTO tap_vpl VALUES ("AM1_5","031_1_5","AMO","1","5","5","Naakatyona mulyango wa Damaski, naakeenoona likolo wa mu Lulambe lwa Aveni, ni olia akwete nkonto ya bukolo mu Beti Edeni. Bantu bonse ba ku Aramu baakaya kuteekua buzia ku kyalo kya Kiri,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM1_6","031_1_6","AMO","1","6","6","Yawe walanda evi, “Pa mulandu wa bibalo bitatu bya bantu ba mu Gaza ao bina, nsikaba kubalekelela pasili kubakanda. Pantu bakitwama bantu bengi ni kuya kubasisia nga bazia ku Baedomu. ");
INSERT INTO tap_vpl VALUES ("AM1_7","031_1_7","AMO","1","7","7","Naakatuma mulilo ku bibumba bya muzi wa Gaza, ozo waakazizia byubo byakue. ");
INSERT INTO tap_vpl VALUES ("AM1_8","031_1_8","AMO","1","8","8","Naakafumiapo makolo a ku Ashdodi ni a ku Ashkeloni. Naakakanda muzi wa Ekroni, ni kwipaya Bafilistini bonse,” koku i kulanda kwakua Yawe Kabezia Mpungu. ");
INSERT INTO tap_vpl VALUES ("AM1_9","031_1_9","AMO","1","9","9","Yawe walanda evi, “Pa mulandu wa bibalo bitatu bya bantu ba mu Tiro ao bina, nsikaba kubalekelela pasili kubakanda. Pantu bakitwama bantu bengi ni kuya kubasisia nga bazia ku Baedomu. Tebaafikiliizie kipanghano kya bukibuza kibaakitile. ");
INSERT INTO tap_vpl VALUES ("AM1_10","031_1_10","AMO","1","10","10","Naakatuma mulilo ku bibumba bya muzi wa Tiro, ozo waakazizia byubo byakue.” ");
INSERT INTO tap_vpl VALUES ("AM1_11","031_1_11","AMO","1","11","11","Yawe walanda evi, “Pa mulandu wa bibalo bitatu bya bantu ba mu Edomu ao bina, nsikaba kubalekelela pasili kubakanda, pantu bakitwama kipanga ni kukumbizia ba kwabo. Bakikaana kumunvwila nkumbu pantu kipuki kyakue kyakiba kyalunduluka musita onse, ni kikonko kyakue pasili kufuukiiwa. ");
INSERT INTO tap_vpl VALUES ("AM1_12","031_1_12","AMO","1","12","12","Naakatuma mulilo mu muzi wa Temani, ozo waakazizia byubo bya ku Bozra.” ");
INSERT INTO tap_vpl VALUES ("AM1_13","031_1_13","AMO","1","13","13","Yawe walanda evi, “Ba-amoni bakibala bibalo bitatu ao bina, ni pakako, kisinka nakaba kubakanda. Lubaali basakukila ba Gileadi pakuti belundileko mipaka, baali batumbula mavumo a banakazi baali baimisi. ");
INSERT INTO tap_vpl VALUES ("AM1_14","031_1_14","AMO","1","14","14","Naakatuma mulilo ku bibumba bya muzi wa Raba, ozo waakazizia byubo byakue mu nsungu ya malilo mu busiku bwa bului, mu mwela ukata mu busiku bwa kinkunsia. ");
INSERT INTO tap_vpl VALUES ("AM1_15","031_1_15","AMO","1","15","15","Likolo wabo pamo ni babiloolo bakue, baakatwalua mu kyalo kyeni,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM2_1","031_2_1","AMO","2","1","1","Yawe walanda evi, “Pa mulandu wa bibalo bitatu bya bantu ba mu Moabu ao bina, nsikaba kubalekelela pasili kubakanda, pantu baaziziizie bikuza byakua likolo wa ku Edomu mpaka bya-aluka nga makese. ");
INSERT INTO tap_vpl VALUES ("AM2_2","031_2_2","AMO","2","2","2","Naakatuma mulilo pa kyalo kya Moabu ozo waakazizia byubo bya mu Kerioti. Moabu waakapona mu nsungu ya bului, balukale pabakaba basamuna, ni ntandala paikaba yalila. ");
INSERT INTO tap_vpl VALUES ("AM2_3","031_2_3","AMO","2","3","3","Naakeenoona kateeka wa ku Moabu, ni kwipaya babiloolo bakue bonse pamo nakue,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM2_4","031_2_4","AMO","2","4","4","Yawe walanda evi, “Pa mulandu wa bibalo bitatu bya bantu ba mu Yudea ao bina, nsikaba kubalekelela pasili kubakanda, pantu baakeene kusunga mizilo, ni kukaana kunakila milao yane, pa mulandu wa kukonka baleza ba bufi, baleza baali bapupua na babikolue babo. ");
INSERT INTO tap_vpl VALUES ("AM2_5","031_2_5","AMO","2","5","5","Naakatuma mulilo mu Yudea, ozo waakazizia byubo bya mu Yeruzalemu.” ");
INSERT INTO tap_vpl VALUES ("AM2_6","031_2_6","AMO","2","6","6","Yawe walanda nangue pa mulandu wa bibalo bitatu bya Baizraeli ao bina, takaba kubalekelela pasili kubakanda, pantu balibasisia balunghami na mutofue, ni bapabi na mpe imo ya nkwabilo. ");
INSERT INTO tap_vpl VALUES ("AM2_7","031_2_7","AMO","2","7","7","Balibanyanta pa mitue ya bapabi, nga pa lufunko lwa pa kyalo, ni kukaana kupeela nsambu babiibikiziiziwe. Se ni mwanae mwalalume balibakumana na mwanakazi umo, ni pakako, balibatiikaania Liina lyane lizuuke. ");
INSERT INTO tap_vpl VALUES ("AM2_8","031_2_8","AMO","2","8","8","Baali balaala mumbali ya kubalua kitale, pa ngubo ipokelue ku bapabi kuti ibe kikwatizi. Baali baminina bikolani mu nghanda ya baleza babo, bikolani bibaali basita na nfolanga ya balia bali ni mizia, ");
INSERT INTO tap_vpl VALUES ("AM2_9","031_2_9","AMO","2","9","9","Yawe walanda nangue, “Anzia nainoonene Ba-amori, baali baleepele nga bimuti bya mumpelempele, ni kuya balumine nga bimuti bya mwaloni. Nainoonene mazabo abo ku misambo ku muulu, ni kutukuna misila yabo kwinsina. ");
INSERT INTO tap_vpl VALUES ("AM2_10","031_2_10","AMO","2","10","10","Naamifumiizie mu kyalo kya Misri, ni kumilombola mu kaseeba myaka 40, kuti n'mipeele kyalo kya Ba-amori.” ");
INSERT INTO tap_vpl VALUES ("AM2_11","031_2_11","AMO","2","11","11","“Kabili pa baana benu naasaakwilepo bamo kuba bakabika, ni pa baana benu balumendo naasakwilepo bamo kuba banaziri. Ati mwe Baizraeli, te i evio?” Koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM2_12","031_2_12","AMO","2","12","12","“Inzi mwe mwaalengiizie banaziri kubala mu kumina bikolani, ni kukaania bakabika tekuti babikule.” ");
INSERT INTO tap_vpl VALUES ("AM2_13","031_2_13","AMO","2","13","13","“Evi ndikumisansa nga tyakala vi-iliyasansa lu-itweme nghano mu masaaka. ");
INSERT INTO tap_vpl VALUES ("AM2_14","031_2_14","AMO","2","14","14","Olia aliwakundukisia takapusuka, wa maka, maka akue aakapua, ni lukale takeepususia. ");
INSERT INTO tap_vpl VALUES ("AM2_15","031_2_15","AMO","2","15","15","Kalasa wa buta takeesimpa, aliwakundukisia takazembuluka, ni museli wa farasi takeepususia. ");
INSERT INTO tap_vpl VALUES ("AM2_16","031_2_16","AMO","2","16","16","Pa bobo busiku anzia kine kukabe bipami biine bya ba balukale, baakabutuka tekuba bavwele kantu,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM3_1","031_3_1","AMO","3","1","1","Unvue keebo kakilandua na Yawe pa mulandu wenu mwe Baizraeli, mwe lupua lwalingi lunaafumiizie mu Misri: ");
INSERT INTO tap_vpl VALUES ("AM3_2","031_3_2","AMO","3","2","2","“Mwemue sie i banaasaakwile pa ntundu yonse ya pa kyalo. Ni pakako, naakamikanda pa mulandu wa bibalo byenu.” ");
INSERT INTO tap_vpl VALUES ("AM3_3","031_3_3","AMO","3","3","3","Ati, kubako bantu babili kuti baenda pamo tekuba baunvwenenke? ");
INSERT INTO tap_vpl VALUES ("AM3_4","031_3_4","AMO","3","4","4","Ati, kubako nkalamu aliwabuluma mu musitu lu-asinakwate nama? Kubako mwina nkalamu kuti wabuluma mu lisele lu-asinakwate kantu? ");
INSERT INTO tap_vpl VALUES ("AM3_5","031_3_5","AMO","3","5","5","Ati, kubako kooni kuti kakwatua mu muteo ute-elue pasili kabembo? Ati, kubako muteo kuti wapusa tekuba mwali kya kukwatuamo? ");
INSERT INTO tap_vpl VALUES ("AM3_6","031_3_6","AMO","3","6","6","Ati, kubako musita uliwaliziiwa ntandala ya bului mu muzi bantu tebezi kutiina? Ati, kubako musita uliwafika busanzo mu muzi, te Yawe aliwabuleeta? ");
INSERT INTO tap_vpl VALUES ("AM3_7","031_3_7","AMO","3","7","7","Kisinka Yawe Kabezia Mpungu tezi kukita kantu pasili kutubula mapange akue ku babombi bakue bakabika. ");
INSERT INTO tap_vpl VALUES ("AM3_8","031_3_8","AMO","3","8","8","Nkalamu lu-aliwabuluma, nani asivinda kutiina? Yawe Kabezia Mpungu lu-aliwalanda, nani asivinda kubikula? ");
INSERT INTO tap_vpl VALUES ("AM3_9","031_3_9","AMO","3","9","9","Ele mukunda mu byubo bya mu Ashdodi, ni mu byubo bya mu Misri nangue, “Kolonghane peulu mpili ya ku Samaria, mone lubebue viluvulilemo, ni kubiibikiziwa mukati mwakue.” ");
INSERT INTO tap_vpl VALUES ("AM3_10","031_3_10","AMO","3","10","10","Yawe walanda evi, “Bantu ba ku Samaria tebamanine kukita biweme. Bezuziizie bintu mu byubo byabo, bintu bibapokele mu bukabooko ni mu bungipaani.” ");
INSERT INTO tap_vpl VALUES ("AM3_11","031_3_11","AMO","3","11","11","Ni pakako, evi i vilimukulanda Yawe Kabezia Mpungu nangue, “Basamaria baakazyungulukila kyalo kyenu, baakatuuta byubo byenu ni kupoka nghanda yenu ya kufyamamo.” ");
INSERT INTO tap_vpl VALUES ("AM3_12","031_3_12","AMO","3","12","12","Yawe walanda evi, “Nga evelia musungi vi-aliwasompola mu kanua ka nkalamu, myendo ibili ao kiputu kya kutui, i vikyaakaba ni ku Baizraeli bekeele mu Samaria, balia baleele pa bulita bwabo, ni ku bantu ba mu Damaski, bantu bekeele mu bitebe byabo bya mutengo.” ");
INSERT INTO tap_vpl VALUES ("AM3_13","031_3_13","AMO","3","13","13","“Ale twilizie ni kusininkizia palua luvyalo lwakua Yakobo,” koku i kulanda kwakua Mulopue, Yawe Leza wa Maka onse. ");
INSERT INTO tap_vpl VALUES ("AM3_14","031_3_14","AMO","3","14","14","“Busiku bunakakanda Baizraeli pa mulandu wa bibalo byabo, naakatuuta bitale bya ku Beteli. Tutunfi twa bitale twaakeenoonua ni kuponena pansi. ");
INSERT INTO tap_vpl VALUES ("AM3_15","031_3_15","AMO","3","15","15","Naakatuuta nghanda ya pa musita wa mainza, ni nghanda ya pa musita wa kipua. Nghanda ifwaniiziwe na meno a nzovu yaakatuutua, ni nghanda yonse ikata yaakeenoonua,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_1","031_4_1","AMO","4","1","1","Twilizie kaka keebo mwe banakazi ba pa lupili lwa Samaria, mwe bali nga nghombe ya ku Basani, mwe balibabiibikizia bapabi, ni mwe balibakita bibiipile ku babulilue, ni kubaana balume benu nangue “tupeele bikolani!” ");
INSERT INTO tap_vpl VALUES ("AM4_2","031_4_2","AMO","4","2","2","Yawe Kabezia Mpungu waalaile mu buzuuke bwakue nangue, “Kisinka musita ulimukwiza lubakaba kumifumia na ndobaano, ni basyelepo pakati kenu baakaba kulobua na ndobaano nga lisabi. ");
INSERT INTO tap_vpl VALUES ("AM4_3","031_4_3","AMO","4","3","3","Mwaakafumiziwa lya palia patutikile bibumba, mwakapoozua panze lya ku Harmoni,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_4","031_4_4","AMO","4","4","4","“Endo ku Beteli, muye mubale kibalo, endo ku Gilgali, mulunduluke kubala. Leete ngelelo yenu kubalua lukeelekeele, kamo ka pa lyanondo mu nsiku itatu. ");
INSERT INTO tap_vpl VALUES ("AM4_5","031_4_5","AMO","4","5","5","Zizie mukate ututumukile nga ngelelo ya kusantila, iitasie palua bupe bumulimwapeela mu kutona kwenu, iitantamune palua bebio byabupe mwe Baizraeli pantu bebi i bimutonene kukita,” koku i kulanda kwakua Yawe Kabezia Mpungu. ");
INSERT INTO tap_vpl VALUES ("AM4_6","031_4_6","AMO","4","6","6","“Naaleetele kimina kya nzala mu mizi yenu yonse, ni kubulua kwa bilio mu kubalua muzi. Anzia kyaali evio temwambweleele,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_7","031_4_7","AMO","4","7","7","“Ntanzi ya kufikiila kuzombola, nsyaamipeele nvula pa myezi itatu. Naanokiizie nvula mu muzi umo, inzi mu unge muzi nsyaanokiiziemo. Nvula yaanokeele mu bukaba bumo, mu bunge mwaasyele mwaumine pantu nsyanokiiziemo. ");
INSERT INTO tap_vpl VALUES ("AM4_8","031_4_8","AMO","4","8","8","Bantu baendookele mu mizi ni mizi balimukukeba menda a kumina inzi tebasangilemo a kubakumana. Anzia kyaali evio, temwambweleele,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_9","031_4_9","AMO","4","9","9","“Lingi nainoonene makaba enu ni makaba a mizabibu, naumiizie bimuti na mwela wa lyuza. Luzie lwaaliile bilimbua byonse bya mu makaba enu ni bimuti bya mizeituni. Anzia kyaali evio, temwambweleele,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_10","031_4_10","AMO","4","10","10","“Naatumine kimina pakati kenu, nga vinaakitile ku Bamisri. Naipaile baana benu balumendo na kipanga. Naamipokele farasi yenu. Naizuziizie myona yenu na bunu bwa mibili ibolele mu mitanda yenu. Anzia kyaali evio, temwambweleele,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_11","031_4_11","AMO","4","11","11","“Nainoonene bamo pakati kenu nga evelia vinainoonene Sodoma ni Gomora. Naamisomwene nga kakooko ka-apulua pa mulilo. Anzia kyaali evio, temwambweleele,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM4_12","031_4_12","AMO","4","12","12","“Ni pakako, evi i vinaakamikitila mwe Baizraeli! Kabili pantu naakamikitila evio mwe Baizraeli, iiteanie kusaakaana ni Leza wenu.” ");
INSERT INTO tap_vpl VALUES ("AM4_13","031_4_13","AMO","4","13","13","Olia waabumbile mpili ni waalengele mwela, olia aliwafyula malanga akue ku bantu, aliwa-alula lukeelekeele kuba nfinzi ni kwenda pa kyalo pa nkendo ilendukile, Yawe, Leza wa Maka onse, i Liina lyakue. ");
INSERT INTO tap_vpl VALUES ("AM5_1","031_5_1","AMO","5","1","1","Mwe Baizraeli, twilizie totu twebo twa lwimbo lwa malilo lundimukumimbila. ");
INSERT INTO tap_vpl VALUES ("AM5_2","031_5_2","AMO","5","2","2","“Kinundue Izraeli aponene, takikabuuka, waasiilue waleele pansi, tekuli wa kumukwasia kubuuka.” ");
INSERT INTO tap_vpl VALUES ("AM5_3","031_5_3","AMO","5","3","3","Yawe Kabezia Mpungu wa-ana Baizraeli nangue, “Muzi waakatuma balukale 1,000 ku bului, kwaakabwela sie balukale 100. Muzi waakatuma balukale 100 ku bului, kwaakabwela sie balukale lyanondo.” ");
INSERT INTO tap_vpl VALUES ("AM5_4","031_5_4","AMO","5","4","4","Yawe wabaana Baizraeli nangue, “Nkebe mube ni bukose. ");
INSERT INTO tap_vpl VALUES ("AM5_5","031_5_5","AMO","5","5","5","Tekunkebe ku Beteli, tekuye ku Gilgali, tekwabuke kuya ku Bersheba. Pantu Gilgali, kisinka waakaya mu buzia. Ni Beteli waaka-alulua kuba mpuni.” ");
INSERT INTO tap_vpl VALUES ("AM5_6","031_5_6","AMO","5","6","6","Mukebe Yawe mube ni bukose, kine te evio, Yawe waakapyanga bantu ba mu nghanda yakua Yusufu nga mulilo. Ozo mulilo waakazizia Beteli, tekuli muntu waakauzimia. ");
INSERT INTO tap_vpl VALUES ("AM5_7","031_5_7","AMO","5","7","7","Lisyamo lyenu mwe baliba-alulula nsambu kuba bwimba bululile, ni kupooza nsambu pansi. ");
INSERT INTO tap_vpl VALUES ("AM5_8","031_5_8","AMO","5","8","8","Olia waakitile Bulimina ni Kipindabusiku pamo ni Orioni, olia aliwa-alulula nfinzi kuba lukeelekeele, ni musita wa koba kuba busiku, olia aliwakuuta menda a lyezi ni ku-etila pa kyalo, Liina lyakue i Yawe. ");
INSERT INTO tap_vpl VALUES ("AM5_9","031_5_9","AMO","5","9","9","Aliwainoona nghanda lubilo lubilo, ni kutuuta byubo bya mizi. ");
INSERT INTO tap_vpl VALUES ("AM5_10","031_5_10","AMO","5","10","10","Basuulile olia aliwasasililana mu kilie, baleebwile olia aliwalanda kisinka. ");
INSERT INTO tap_vpl VALUES ("AM5_11","031_5_11","AMO","5","11","11","Mulimwaabiibikizia bapabi, ni kubeebila buzombozi mu kusonkia musonko. Ni pakako, anzia kine mwaakuulile nghanda ya mabue, temukeekalamo. Anzia kine mwaalimine bukaba bwa mizabibu, temukamina divai ya mizabibu. ");
INSERT INTO tap_vpl VALUES ("AM5_12","031_5_12","AMO","5","12","12","Pantu n'manine vivulile bilubo byenu ni vitanine bibalo byenu. Mulimwaemia bantu basili na kilubo ni kupoka bituulilo, kabili mulimwatana bapabi nsambu mu kilie. ");
INSERT INTO tap_vpl VALUES ("AM5_13","031_5_13","AMO","5","13","13","Ni pakako, olia akengeele aliwatalala pa musita nga ozo, pantu musita ubiipile. ");
INSERT INTO tap_vpl VALUES ("AM5_14","031_5_14","AMO","5","14","14","Kite biweme, tekuba bibiipile, evi mube ni bukose. Ni Yawe Leza wa Maka onse waakaba pamo nenu nga vimulimwalanda nangue pa-ali. ");
INSERT INTO tap_vpl VALUES ("AM5_15","031_5_15","AMO","5","15","15","Suule bibiipile, tone biweme, biike nsambu mu bilie. Pange Yawe Leza wa Maka onse waakeeleela bantu basyele bakosele ba mu luvyalo lwakua Yusufu. ");
INSERT INTO tap_vpl VALUES ("AM5_16","031_5_16","AMO","5","16","16","Ni pakako, Mulopue Yawe Leza wa Maka onse walanda evi, “Kwaakaba malilo mu misebo yonse, kuloosia kwa bulanda mu kubalua kisaakaanino kya bantu. Balimi baakakuutua kwiza kulila, ni ba kuloosia bakeeza kuloosia. ");
INSERT INTO tap_vpl VALUES ("AM5_17","031_5_17","AMO","5","17","17","Mu makaba onse a mizabibu mwaakaba malilo. Pantu naakeeza kupita pakati kenu,” koku i kulanda kwakua Yawe. ");
INSERT INTO tap_vpl VALUES ("AM5_18","031_5_18","AMO","5","18","18","Lisyamo kuli mwe balibatokamua busiku bwakua Yawe. Mulimwatokaminuaki busiku bwakua Yawe? Bobo busiku bwaakaba nfinzi, tekuba kisue. ");
INSERT INTO tap_vpl VALUES ("AM5_19","031_5_19","AMO","5","19","19","Kyaakaba nga muntu wabutuka nkalamu, wasaakaana na kimbui, wapanda ku kimbui, waingila mu nghanda yakue, ni kukikilizia kuboko kwakue ku kibumba, wasumua na nzoka. ");
INSERT INTO tap_vpl VALUES ("AM5_20","031_5_20","AMO","5","20","20","Kubako busiku bwakua Yawe tebukaba nfinzi, pasili kuba kisue? Kubako teikaba nfinzi ikata isili na minghenghe? ");
INSERT INTO tap_vpl VALUES ("AM5_21","031_5_21","AMO","5","21","21","Yawe walanda nangue, “Nsuulile, ndeebwile nsikunkulu yenu ya mpupo, nsiwamiinue na kulonghana kwenu. ");
INSERT INTO tap_vpl VALUES ("AM5_22","031_5_22","AMO","5","22","22","Anzia kili evio, mulimwandeetela ngelelo ya kuzizia ni bupe bwa bunga nsikabipokelela. Anzia kine mulimwaleeta bupe bwa mutende, nsikabukentako. ");
INSERT INTO tap_vpl VALUES ("AM5_23","031_5_23","AMO","5","23","23","Lekele nsungu ya nghimbo yenu, nsikatwilizia nghimbo ya bilimba byenu. ");
INSERT INTO tap_vpl VALUES ("AM5_24","031_5_24","AMO","5","24","24","Inzi lekele nsambu ipongoke nga mwenzi, bulunghami bube nga kaezi kasili kakama. ");
INSERT INTO tap_vpl VALUES ("AM5_25","031_5_25","AMO","5","25","25","“Kubako mwe Baizraeli, mwandeeteele ngelelo ni bupe mu kaseeba mu elia myaka 40? ");
INSERT INTO tap_vpl VALUES ("AM5_26","031_5_26","AMO","5","26","26","Mwakilendula kitale kyakua likolo wenu, Sukoti kateeka leza wenu, ni Kiuni leza wenu wa lutanda, bamwaikitiile mwe bene. ");
INSERT INTO tap_vpl VALUES ("AM5_27","031_5_27","AMO","5","27","27","Ni pakako, naakamitwala mu kyalo kya buzia, kule kupita ku Damaski,” koku i kulanda kwakua Yawe, ali ni Liina lya Leza wa Maka onse. ");
INSERT INTO tap_vpl VALUES ("AM6_1","031_6_1","AMO","6","1","1","Lisyamo lyenu mwe bekeele bawamiinue mu Sayuni, mwe beyunvwile mwali ni mutende pa Lupili lwa Samaria, mwe bakindami ba mponvu pa ntundu yonse, mwe baketekeelue na Baizraeli! ");
INSERT INTO tap_vpl VALUES ("AM6_2","031_6_2","AMO","6","2","2","Endo mwaye mumone muzi wa Kalnehi, muye mumone ni muzi ukata wa Hamati, kabili muye mukookele ni ku Gati, muzi wa Bafilistini. Ati, kubako ezi mizi yaali yawamiisie kukila bukolo bwenu bwa Yuda ni bwa Izraeli? Kubako, kyalo kyabo kyaali kyatanine kukila kyalo kyenu? ");
INSERT INTO tap_vpl VALUES ("AM6_3","031_6_3","AMO","6","3","3","Mulimwalangakana kusyenia kule busiku bwa masanzo, inzi mwalimukupalamika buteeko bwa kutiinia. ");
INSERT INTO tap_vpl VALUES ("AM6_4","031_6_4","AMO","6","4","4","Kyaakamibiipila mwe bali balaala pa malita afwaniiziwe na meno a nzovu, ni kuya mwaiyolwela pa bitebe bya mutengo. Mwe balibalia munani wa misoka ya mikooko pamo ni wa misoka ya nghombe itapukile. ");
INSERT INTO tap_vpl VALUES ("AM6_5","031_6_5","AMO","6","5","5","Mwemue mulimwalizia binanda nga Daudi, mulimwatunga nghimbo ni kulizia bilimba bilekenkeene. ");
INSERT INTO tap_vpl VALUES ("AM6_6","031_6_6","AMO","6","6","6","Mulimwaminina divai mu nsupa, ni kusuba mafuta a bunu buweme ku mibili yenu. Inzi temulimwaunvua nkumbu pa mulandu wa kwinoonua kwa luvyalo lwakua Yusufu. ");
INSERT INTO tap_vpl VALUES ("AM6_7","031_6_7","AMO","6","7","7","Ni pakako, mwaakaba mwali mu bantu ba mambo kuya mu buzia. Nsikunkulu yenu pamo ni kuwaminua byaakapua. ");
INSERT INTO tap_vpl VALUES ("AM6_8","031_6_8","AMO","6","8","8","Yawe Kabezya Mpungu, Yawe Leza mwine wa Maka onse walapa walanda nangue, “Nsuulile kiitoni kyakua Yakobo, nsuulile byubo byakue. Muzi ni kubalua kantu kalimo, naakapeela balwani babo.” ");
INSERT INTO tap_vpl VALUES ("AM6_9","031_6_9","AMO","6","9","9","Kine mu nghanda imo mwaakasyala bantu lyanondo, ni bo kumo baakafua. ");
INSERT INTO tap_vpl VALUES ("AM6_10","031_6_10","AMO","6","10","10","Kabili kine muntu wa mu lupua lwa babo bafwile waiza kufumia mibili yabo mu nghanda kuti aye azizie, kine muli muntu wapandanga, wasyele wakosele mu muputule wa nghanda, ozo muntu wa mu lupua lwabo alikumwipuzia nangue, “Ewe, ulimo ni unge muntu akosele?” Kine walanda nangue, “Temuli,” alikumwana evi, “Talala! Fwefue tetupalile kuzimbula Liina lyakua Yawe.” ");
INSERT INTO tap_vpl VALUES ("AM6_11","031_6_11","AMO","6","11","11","Pantu Yawe wakifumia mwano, wene wakaba kutuuta nghanda ikata bibazu bibazu, ni iniini kutuuta tuniini tuniini. ");
INSERT INTO tap_vpl VALUES ("AM6_12","031_6_12","AMO","6","12","12","Ati, kubako farasi kuti wakunduka pa myalala? Ati, kubako muntu kuti walima na nghombe pa myalala? Inzi mwemue mwa-alwile nsambu kuba bwimba, ni mazabo a bulunghami kuba bwimba bululile. ");
INSERT INTO tap_vpl VALUES ("AM6_13","031_6_13","AMO","6","13","13","Mwe balibawaminua kwanziwa kwa muzi wa Lo-debari ni kulanda nangue, “Kubako tetwakikwata muzi wa Karnaimu na maka etu fwe bene?” ");
INSERT INTO tap_vpl VALUES ("AM6_14","031_6_14","AMO","6","14","14","Pantu Yawe Leza wa Maka onse walanda evi, “Nakaba kulengia ntundu ikabe kumyalukila mwe nghanda yakua Izraeli. Ni yo yakaba kumyemia kutendekela ku Lebo Hamati ku nkungua mpaka ku Lulambe lwa Araba ku mboosi.” ");
INSERT INTO tap_vpl VALUES ("AM7_1","031_7_1","AMO","7","1","1","Keki i kintu kinaalangisiiziwe na Yawe Kabezia Mpungu. Naamumwene walimukuteania bisepe bya luzie pa kyamba kya kuzombola buzombozi bwakua likolo pa musita waali wamenenapo binge bilimbua. ");
INSERT INTO tap_vpl VALUES ("AM7_2","031_7_2","AMO","7","2","2","Luzie palwaali lwalimukulia bilimbua byonse bya mu makaba, na-angwile nalanda nangue, “We Yawe Kabezia Mpungu eleela bantu bobe! Kubako Yakobo alikutwalilila syani kuba mukose? Wene akilile kukeepa!” ");
INSERT INTO tap_vpl VALUES ("AM7_3","031_7_3","AMO","7","3","3","Ni pakako, Yawe wa-alwile malanga akue. Yawe waalandile evi, “Keki tekikaba kukitika.” ");
INSERT INTO tap_vpl VALUES ("AM7_4","031_7_4","AMO","7","4","4","Kintu kinaalangisiiziwe na Yawe Kabezia Mpungu ni keki: Yawe Kabezia Mpungu waali wakuuta bupinguzi bwa mulilo, ni ozo mulilo waakamiizie lyezi ni kwinoona kyalo. ");
INSERT INTO tap_vpl VALUES ("AM7_5","031_7_5","AMO","7","5","5","Kabili wa-angwile, “We Yawe Kabezia Mpungu, napaapaata tekukita evio! Kubako Yakobo alikutwalilila syani kuba mukose? Wene akilile kukeepa!” ");
INSERT INTO tap_vpl VALUES ("AM7_6","031_7_6","AMO","7","6","6","Ni pakako, Yawe wa-alwile malanga akue. Yawe Kabezia Mpungu waalandile evi, “Keki tekikaba kukitika.” ");
INSERT INTO tap_vpl VALUES ("AM7_7","031_7_7","AMO","7","7","7","Kinaalangisiiziwe na Yawe mu kimonua ni keki: Yawe waali waimeene mumbali kibumba kyaali kyakuulua na kalingo ka kuolwelako, wakwete ni lukamba lwa kalingo ka kuolwelako mu minue yakue. ");
INSERT INTO tap_vpl VALUES ("AM7_8","031_7_8","AMO","7","8","8","Yawe wangipuziizie nangue, “Ati Amosi, umweneki?” Naamwasukile, “Lukamba lwa kalingo ka kuolwelako.” Kabili Yawe waalandile evi, “Mona ndimukubiika kalingo ka kuolwelako pa bantu bane Baizraeli. Nene nsikikaba kubeeleela. ");
INSERT INTO tap_vpl VALUES ("AM7_9","031_7_9","AMO","7","9","9","“Nkendo ya mukinzi iliyapupilapo ba m